﻿USE sofia;
DROP TABLE IF EXISTS sofia.tptNT_vpl;
CREATE TABLE tptNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tptNT_vpl WRITE;
INSERT INTO tptNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aniy tsꞌoqkanta ixtaqaꞌutikꞌan yu maqancha ixpayankꞌan ni Jesucristo. Jesucristo va ixpapanti ni David yu ixpapanti ni Abraham. ");
INSERT INTO tptNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ni Abraham lhitsukul istsꞌal Isaac, Isaac lhitsukul Jacob, Jacob lhitsukul Judá ali ixtꞌalaqaunin. ");
INSERT INTO tptNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá lhitsukul ni Fares ali Zara. Ixnatikꞌan va Tamar. Fares lhitsukul Esrom, Esrom lhitsukul Aram. ");
INSERT INTO tptNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram lhitsukul Aminadab, Aminadab lhitsukul Naasón, Naasón lhitsukul Salmón. ");
INSERT INTO tptNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón lhitsukul Booz, yu ixnati va Rahab. Booz kun ixanati Rut talhitsukul Obed. Obed lhitsukul Isaí. Isaí lhitsukul ni David yu ay jalhachimoꞌonuꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","David lhitsukul Salomón tejkan tꞌatsukul ixanati aqayntaun xapay yu ixjunkan Urías. ");
INSERT INTO tptNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón lhitsukul Roboam, Roboam lhitsukul Abías, Abías lhitsukul Asa. ");
INSERT INTO tptNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa lhitsukul Josafat, Josafat lhitsukul Joram, Joram lhitsukul Uzías. ");
INSERT INTO tptNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías lhitsukul Jotam, Jotam lhitsukul Akaz, Akaz lhitsukul Ezequías. ");
INSERT INTO tptNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías lhitsukul Manasés, Manasés lhitsukul Amón, Amón lhitsukul Josías. ");
INSERT INTO tptNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías lhitsukul Jeconías kun ixtꞌalaqaunin. Yucha tejkan ni israelitas va laklhaꞌankal tachꞌinin tus laka putaulan Babilonia. ");
INSERT INTO tptNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tejkan ancha ixlaklhaꞌankantacha ex ni Jeconías lhitsukul Salatiel. Salatiel lhitsukul Zorobabel. ");
INSERT INTO tptNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel lhitsukul Abiud, Abiud lhitsukul Eliaquim, Eliaquim lhitsukul Azor. ");
INSERT INTO tptNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor lhitsukul Sadoc, Sadoc lhitsukul Akim, Akim lhitsukul Eliud. ");
INSERT INTO tptNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud lhitsukul Eleazar, Eleazar lhitsukul Matán, Matán lhitsukul Jacob. ");
INSERT INTO tptNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob lhitsukul José yu ixapay ni María. Yucha va ixnati ni Jesús yu mispakan tacha Cristo, yu Dios lakꞌulata tacha Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ex chuncha tapasal tampajkautꞌati lapanakni yu Abraham tus tejkan tsukul David. Vachuꞌ tapasal tampajkautꞌati lapanakni yu David tus jalaklhaꞌankal tachꞌinin ni israelitas laka putaulan Babilonia. Vachuꞌ tapasal tampajkautꞌati lapanakni tejkan jalaklhaꞌankal laka Babilonia tus tejkan tsukul ni Cristo. ");
INSERT INTO tptNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tejkan tsukul ni Jesucristo va inchine val. María yu ixnati va ixtalaxaqalatacha para katalatꞌatsukul kun José. Ex chuncha mas jantukaꞌ ixtalatꞌatsukuy yu María va jaꞌaynaꞌ val kun ixtapꞌasta ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ni José yu ixapay ni María va qalꞌox lapanaki ixjunita, va jantu ixjamakꞌatsaniputun ni lapanakni. Ex ni yucha va saq ixmakaunputunchoqoy. ");
INSERT INTO tptNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ex va chuncha ixpastaktacha tas ixpumakaunlhi. Taval ixmayul ni Jalhachimoꞌonu Dios tasunil la ixꞌaqlaqavanti, va junil: —José, ixpapanti kꞌatꞌi ni David, jantu katꞌalhan para kalaꞌaꞌitꞌi ni María tacha mixanati. Yu jasꞌatꞌa kalhitsukuyaꞌ va ixnavin ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yu María kalhitsukuyaꞌ qayntaun tsꞌal, kꞌaꞌuneꞌe ixtaqaꞌuti Jesús. Chuncha kajunkanaꞌ va por kalaqmalaqtaxtuyaꞌ ni lapanakni la ixtalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chuncha tapasal va para laqsaval kaval yu maqancha naul ni Jalhachimoꞌonu Dios por ni lapanakni yu ixtalaqputeꞌey ixchivinti, va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Qayntaun jatsiꞌi jaꞌaynaꞌ kunaꞌ, kalhitsukuyaꞌ qayntaun jasꞌatꞌa. Ni yucha kajunkanaꞌ Emanuel. Anchanu taqaꞌuti va naunputun: Ni Dios alinta kun kijnankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ex tejkan lakpukujchoqolcha ni José, va chuncha makal tacha junil ixmayul ni Jalhachimoꞌonu Dios, va laqaꞌilcha ni María tacha ixanati. ");
INSERT INTO tptNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero jantukaꞌ ixtalatꞌatamay tus tejkan lhitsukul istsꞌal ni María. Ex chuncha ni José va mukꞌanil ixtaqaꞌuti JESÚS. ");
INSERT INTO tptNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ni Jesús tsukul ni Belén yu xalakatꞌun Judea tejkan ixlhachimoꞌonun ni Herodes ni anchanu lakamunukpaꞌ. Ex va chuncha tachil xaputaulan Jerusalén lapanakni yu machaqan taꞌan putakꞌutꞌa julchan. Va lakjunkan magos. ");
INSERT INTO tptNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Va talhasakminil: —¿Toꞌoxtaycha vil ni jasꞌatꞌa yu tsukul para kalhichimoꞌol ni israelitas? Va klaqtsꞌiniyaucha ni ixjastꞌaku ex kmintau toꞌoyanan. ");
INSERT INTO tptNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ex tejkan chuncha qasmaklhi ni Herodes, jantu ox kakꞌatsal, vachuꞌ kun tachun xalapanakni Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Va chuncha ni jalhachimoꞌonuꞌ Herodes va jalakjuntaꞌiꞌol tachun xaꞌukxtinin kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan. Jalaklhisakmil toꞌoxtaycha katsukul ni Cristo. ");
INSERT INTO tptNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yuꞌuncha tanaul: —Va laka putaulan Belén xalakatꞌun Judea. Va chuncha tsꞌoqlhi qayntaun yu maqancha ixlaqputeꞌey ixchivinti Dios, va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Putaulan Belén xalakatꞌun Judea, uxintꞌi jantu lakatꞌuniy kꞌaꞌuntꞌi, apalay ay kꞌatꞌi xajantu yu talhachimoꞌonun xalakatꞌun Judea. Kataxtuniyan qayntaun ay lapanaki yu kalhichimoꞌoyaꞌ kilapanakni yu israelitas. ");
INSERT INTO tptNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ex va chuncha ni Herodes va saq lakjuntaꞌil ni magos y jalaklhisakmil tavanancha tasul ni jastꞌaku. ");
INSERT INTO tptNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ex chuncha jalaqmalaqachalcha ni Belén, va lakjunil: —Kꞌapꞌinchꞌipitikcha lakxkaunan ni jasꞌatꞌa, ox kꞌalakxkꞌauyapitik ni anchanuꞌ jasꞌatꞌa. Ex tejkan katꞌemayapitik kilajunau para vachuꞌ lay kajkꞌal toꞌoyanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tejkan chuncha taqasmaklhi ni jalhachimoꞌonuꞌ ex va taꞌalcha. Ex yu jastꞌaku yu ixtalaqtsꞌinta taꞌan putakꞌutꞌa julchan va xapꞌulꞌanta kun yuꞌuncha. Tejkan va laycha katachaꞌal yu jastꞌaku va saq tayal taꞌan ixmal ni jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tejkan chuncha talaqtsꞌil ni jastꞌaku ex ni magos ayaj talhiꞌachantajul. ");
INSERT INTO tptNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tejkan tatanuchal laqa chaqaꞌ va talaqtsꞌil ni jasꞌatꞌa kun María yu ixnati. Ex va chuncha tataꞌaqtsoqoqtanilcha va taꞌaqtaylcha ni tatamoꞌoniy ni jasꞌatꞌa. Ex va taꞌaqmixꞌalcha ixkajajkꞌan taꞌan maꞌakan ixmaqalitkꞌan, taxtaqnil oro ali pun ali mirra. ");
INSERT INTO tptNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ex va chuncha taval ni anchanu lapanakni va taꞌaqlaqavanal, va lakjunkal para jantucha katapuꞌanchoqol ni taꞌan ixvil ni Herodes, va para katapuꞌanchoqolcha alakataun tin ni la ixtꞌunkꞌan. Ex va atauncha tin tapuꞌanchoqol la ixtꞌunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Taval tejkan taꞌanchoqolcha ni magos, qayntaun ixmayul ni Jalhachimoꞌonuꞌ Dios tasunil la ixꞌaqlaqavanti ni José, va junil: —Kaꞌostꞌaꞌulcha, kꞌasaktꞌicha ni jasꞌatꞌa kun ixnati. Kꞌapꞌintꞌikcha xalakatꞌun Egipto. Ancha katꞌaultꞌachipitik tus tejkan kitꞌin klamapastakꞌanichoqoyau. Yu Herodes kalaxkauyaꞌ ni jasꞌatꞌa para kamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Va chuncha ni José ostaulalcha, va saklhicha ni jasꞌatꞌa kun ixnati. Ex ni yuꞌuncha va taꞌalcha ni Egipto mas vananaj ixputsꞌista. ");
INSERT INTO tptNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Va ancha ixtavilananchal tus tejkan nilcha ni Herodes. Va chuncha tapasal para kataqayntsal yu naul ni Jalhachimoꞌonu Dios. Va qayntaun yu maqancha ixlaqputeꞌey ixchivinti naul: “La xalakatꞌun Egipto ijkuntaꞌil kesꞌatꞌa.” ");
INSERT INTO tptNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tejkan kꞌatsal ni Herodes ni tamakanul yu magos ex va ayaj talqaunlhi, va jamalaqachanal ixjamaqnika ni tsꞌalan yu lakstꞌuniykaꞌ. Va yu ixtalhitꞌajun laꞌatꞌiyun jachꞌitin kun yu apalay lakstꞌuniykaꞌ laka putaulan Belén ali yu ukstsꞌuniy ixtavilanal. Va pastaklhi tacha tajunil ni magos tisuncha julchan talaqtsꞌil ni jastꞌaku. ");
INSERT INTO tptNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ex laqsaval va chuncha val tacha istsꞌoqta ni Jeremías yu maqancha ixlaqputeꞌey ixchivinti Dios: ");
INSERT INTO tptNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Va qasmajkal yu talajqalhun laka putaulan Ramá, va alil taun ay jamaqaniti y lajqalhuti, va yucha ni Raquel yu ixqalhun. Jantucha lay ixlakataulay, va jalaqmaqnikalcha ni sasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ex taval tejkan ixnitacha ni Herodes, qayntaun ixmayul ni Jalhachimoꞌonu Dios va tasunichoqol ni José la ixꞌaqlaqavanti ancha lakatꞌun Egipto, va junil: ");
INSERT INTO tptNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Kaꞌostꞌaꞌulcha, kꞌasaktꞌicha ni jasꞌatꞌa kun ixnati, kapꞌinchꞌoꞌotꞌikcha xalakatꞌun Israel. Yu ixtamaqniputun ni jasꞌatꞌa va tanilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Va chuncha ni José ostaulalcha, va laklhaanchoqolcha ni jasꞌatꞌa kun ixnati xalakatꞌun Israel. ");
INSERT INTO tptNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kꞌatsal ni José ixtꞌajuncha lhachimoꞌon ni Arkelas ancha Judea tacha ixlhachimoꞌonun ixpay Herodes. Ex va talhanal, jantucha kaꞌanchoqol ancha. Va makꞌatsanichoqokal aaqtaun la ixꞌaqlaqavanti, ex va alcha xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tejkan chaꞌalcha ex va ancha tsukuchal xaputaulan Nazaret. Va chuncha tapasal para laqsaval chuncha kaval tacha tanaul yu maqancha ixtalaqputeꞌey ixchivinti Dios, tanaul: “Ni yucha kajunkanaꞌ qayntaun yu machaqaꞌ Nazaret.” ");
INSERT INTO tptNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Va chuncha taval ni anchanu julchan ni Juan yu jamaqchajꞌavanaꞌ al laqputeꞌeniꞌ ixchivinti Dios lakakꞌavin xalakatꞌun Judea. ");
INSERT INTO tptNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Va ixnajun: —Kꞌamapꞌaxatꞌikcha mijatapastakꞌatkꞌan. Va taꞌukstsꞌuniycha ixlhachimoꞌon Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ni Juan va yu lhichivinil ni Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios. Ni Isaías naul: Qasmakkan taun tꞌasati lakakꞌavin yu najun: “Kalaꞌoximanitꞌikcha ixlakatin ni Jalhachimoꞌonuꞌ. Vas kꞌamakꞌatꞌikcha para tsꞌalti katapasal.” ");
INSERT INTO tptNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yu ixlaqchꞌiti ni Juan va jamakanti xachꞌauti ni camello, yu ixlhitampachꞌikan va jaxtaꞌan, yu ixvayti va silaqa kun xaxkan seraj yu alin lakakꞌavin. ");
INSERT INTO tptNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ni lapanakni yu machaqan xalakatꞌun Judea ali yu machaqan laka putaulan Jerusalén ali yu ixtavilanal ukstsꞌuniy xalaꞌaxkan Jordán, va ixtalaqminꞌojoy ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ixtalhitaulꞌojoycha ni ixtalaqalhinkꞌan, ex yu Juan va ixjamaꞌaqchajꞌavaycha xalaꞌaxkan Jordán. ");
INSERT INTO tptNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yu Juan tejkan jalaqtsꞌilcha ixtamincha aqchajꞌaunin pumalhuu fariseos kun saduceos, va jalakjunil: —¡Sasꞌatꞌan tsapulin yu xaꞌox untꞌatꞌik! ¿Taꞌayucha xatajunancha ni uxiknankꞌan para kꞌaxajchipitik ni aniy lhitaꞌay jamaqanlqajnati yu kaꞌalina? ");
INSERT INTO tptNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kꞌamakꞌatꞌikcha yu lajꞌox para ex chuncha katasulcha ni mapꞌaxatꞌatꞌikcha mijatapastakꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Jantu lajꞌay kakꞌatsꞌantꞌik para kanauntꞌik meꞌemankꞌan: “Ni Abraham yucha kimpaykꞌan.” Kitꞌin klajunau yu Dios lay kalakmapaxal ni aniy chiyux para kataval sasꞌatꞌan Abraham. ");
INSERT INTO tptNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chavaycha va tacha taun hacha yu va laycha kachaqxtal ni kꞌiu la ixtitakxiyati. Yu jantu makay yu lajꞌox, yucha kachaqxtakal, va kamapꞌukalcha ni laka jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kitꞌin va kun xkan klamaꞌaqchajꞌavayau para katasul ni mapꞌaxatꞌatꞌikcha mijatapastakꞌatkꞌan. Astan kaminaꞌ aqayntaun yu apalay ay xajantu kitꞌin. Yu kitꞌin tus jantu kimpaxtoqniy kaklhaꞌanil ixvarachi. Yucha katapumaꞌaqchajꞌavayan kun ni Espíritu Santo ali jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yucha va tacha kalhitsukul la ixmakaꞌ ixpatankꞌalhan para kalaktankꞌalhal ni lapanakni tacha trigo. Yu lajꞌox kalakmaꞌayaꞌ la ixpakꞌatsa pero yu tacha pꞌoqxni kalaqxavayaꞌ laka jikmi yu jantu aqtaun kamixaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ex va chuncha taval ni Jesús minchal xalakatꞌun Galilea. Va al xalaꞌaxkan Jordán taꞌan xamaꞌaqchajꞌavanan ni Juan para ancha ni Juan kamaꞌaqchajꞌaval ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ex chuncha yu Juan va jantu ixꞌuyujnajun, va junil ni Jesús: —Yu kitꞌin va kmaqskꞌiniy kꞌimaꞌaqchꞌajꞌavatꞌi ni uxintꞌi. ¿Chavay va kitꞌin kilaqtꞌantꞌa para kakmaqchajꞌavan? ");
INSERT INTO tptNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero yu Jesús va junil: —Chavay va chuncha kꞌamakꞌaucha. Maqskꞌiniy chuncha kamakau tacha yu lhinajun ni Dios. Ex ni Juan xtaqkalcha para kamaqchajꞌaval. ");
INSERT INTO tptNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ex tejkan aqchajꞌaulcha ni Jesús va niman takukchoqol yu lakxkan. Yu laktꞌiyan va talaqltiꞌal y laqtsꞌil ixꞌEspíritu ni Dios ixtaꞌeltajuminta taꞌan ixyal ni yucha, ixtasuy tacha laqataun palumax. ");
INSERT INTO tptNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ex chivinkal laktꞌiyan, va naunkal: —Ni aniy yucha va kesꞌatꞌa yu ayaj kꞌachaniy. Va ayaj iklhiꞌachantajuy. ");
INSERT INTO tptNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ex va chuncha ni Espíritu va lhaꞌalcha lakakꞌavin ni Jesús para ancha ni xaꞌukxtin aqmoqxnuꞌ kalaqtsꞌintanul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ex ni Jesús jantu kavayl aqtꞌuy pꞌuxaun julchan kun aqtꞌuy pꞌuxaun jatatsꞌisin. Taval va chavanilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ex ni aqmoqxnuꞌ va talakanunil ni Jesús para kalaqtsꞌintanul, va junil: —Incha laqsaval Sasꞌatꞌa Dios kꞌatꞌi ex ni aniy chiyux kꞌamakꞌatꞌi pan. ");
INSERT INTO tptNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ex ni Jesús qaltayl, va naul: —Yu tsꞌoqkanta la ixchivinti Dios najun: “Qayntaun lapanaki, jantu vamun ixvayti kaputsukul. Va maqskꞌiniy kaputsukul tachun ni chivinti yu najun ni Dios.” ");
INSERT INTO tptNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ex va chuncha ni aqmoqxnuꞌ va lhaꞌal ni Jesús laka putaulan Jerusalén yu taꞌan ixnavin Dios, va mukꞌal ixꞌaqstiꞌ ni ay lakatajtan, ");
INSERT INTO tptNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","va junil: —Incha laqsaval Sasꞌatꞌa kꞌatꞌi ni Dios, va kꞌaltꞌujnu ni aniy. La ixchivinti Dios yu tsꞌoqkanta va najun: Ni Dios kalaklhijunaꞌ ni ixmayulnin para katalhistakni. Yuꞌuncha katatsꞌapastukkꞌan la ixmakakꞌan, va para jantu kꞌatꞌaꞌalhitꞌi la minchꞌajaꞌ laka chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ex chuncha ni Jesús va junil: —Vachuꞌ najun la ixchivinti Dios: “Jantu aqtaun kalaqtsꞌintꞌanutꞌi ni Dios miJalhachimoꞌonuꞌ incha laqsaval kamakayaꞌ yu najun.” ");
INSERT INTO tptNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ex va chuncha ni aqmoqxnuꞌ va aaqtaun lhaꞌanchoqol ni Jesús lakataun aspajun taꞌan ayaj talman. Ancha masuniꞌol tachun oqxlaqlhuu yu taꞌalinta lakamunukpaꞌ kun tachun ixkꞌusixtukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ex ni aqmoqxnuꞌ va junil ni Jesús: —Ni kitꞌin incha kꞌintꞌaꞌaqtsꞌoꞌoqtꞌaniyeꞌe y kꞌintꞌoꞌoyayeꞌe tus kakxtaqniꞌoyan tachun ni aniy yu kmasuniyan. ");
INSERT INTO tptNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ex ni Jesús va junil: —Uxintꞌi Satanás, va kapiticha. La ixchivinti Dios najun: “Kꞌatꞌoꞌoyatꞌi vamun miJalhachimoꞌonu Dios yu alintachal laktꞌiyan, y vamun yuꞌ kꞌatꞌapꞌatsꞌanin.” ");
INSERT INTO tptNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ex va chuncha ni aqmoqxnuꞌ va makaul ni Jesús. Taminchal ixmayulnin Dios, va taꞌaqtayjulcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Va manukal laka pachꞌin ni Juan. Tejkan kꞌatsal ni Jesús va anchoqol xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Astan makaul ixputaulan Nazaret, va al tsukunuꞌ Kapernaum, taun putaulan yu va ukstsꞌuniy ixkilpaꞌ lakamar. Ancha va xalakatꞌun ni Zabulón ali Neftalí. ");
INSERT INTO tptNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Laqsaval chuncha tapasal va para laqsaval kaval yu tacha istsꞌoqta ni Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios, va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yu xalakatꞌun Zabulón kun Neftalí, yu ukstsꞌuniy lakamar, yu tukuktachal ni laꞌaxkan Jordán, yu ancha laka Galilea, va taꞌan tavilanal yu jantu Israelitas kataval. ");
INSERT INTO tptNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ni lapanakni yu ixtatiꞌukxuyanal ni laka putsꞌisniꞌ va laktasunil taun ay maklku, Ni anchanu lapanakni yu ixtavilanal taꞌan ixmalkꞌiknitacha ni lhinin, va yuꞌuncha jalakmapulkunilcha ni anchanu maklku. ");
INSERT INTO tptNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ex va chuncha ni anchanu julchan va exnicha aqtaychal laqputeꞌey ixchivinti Dios ni Jesús. Va ixnajun: —Kꞌamapꞌaxatꞌikcha mijatapastakꞌatkꞌan, ixlhachimoꞌon ni Dios va ukstsꞌuniycha lakaminta. ");
INSERT INTO tptNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ex va chuncha ni Jesús va ixkiltaukꞌajꞌanta ixkilpaꞌ lakamar Galilea, ancha laktemal pumatꞌuy tꞌalaqaunin. Yu qayntaun va Simón vachu va yuꞌ yu ixjunkan Pedro, yu aqayntaun va Andrés ixjunkan. Yu anchanuꞌ tꞌalaqaunin va xachꞌapanan jatanti ixtajunita. Va ixtatꞌajun mujunun ixchꞌoqxkꞌan lakxkan. ");
INSERT INTO tptNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ex Jesús va lakjunil ni anchanu joꞌakna: —Chavay kilatꞌamiucha ni kitꞌin. Chavay tꞌemayatꞌik va jatanti pero kitꞌin kaklamakayau para kalaktꞌematꞌik lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ex ni anchanu joꞌakna va niman tamakaulcha ixchꞌoqxkꞌan, va tatꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Taval tejkan va ukstsꞌuniykaꞌ ixtaꞌanta, ni Jesús va aaqtaun jalaktemachoqol pumatꞌuy tꞌalaqaunin, yu istsꞌalan ni Zebedeo ixtajunita. Yu qayntaun va Jacobo ixjunkan, yu ixpꞌisaqa ixjunkan va Juan. Va ixtꞌatꞌajumanal ni laka barco kun ixpaykꞌan. Va ixtatꞌajun laꞌoxinin ni ixchꞌoqxkꞌan. Ex ni Jesús vachuꞌ lakjuntaꞌil. ");
INSERT INTO tptNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ex ni yuꞌuncha vachucha tamakaul ixpaykꞌan kun ixlhitapatsakꞌan, va tatꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ni Jesús va tus tiꞌukxuntayaꞌol ni talakachux xalakatꞌun Galilea, yu taꞌan laka putaulanaxna, va ixjamalaninin taꞌan ixtataqxtoꞌa ni Israelitas. Va ixlaqputeꞌey yu ox chivinti yu masuy tacha lhachimoꞌonun ni Dios. Vachuꞌ yu tapuchux taqanꞌati yu ixtalhitꞌajun ni lapanakni va tus ixlajkꞌuchꞌuꞌojoy. ");
INSERT INTO tptNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ex yu xalakatꞌun Asiria va tus talakachux takꞌatsaniꞌol yu lajꞌay lhitapatsa makal ni Jesús. Ex ni yuꞌuncha va talhiminil yu tapuchux ni ixtamaqanlqajnan ixtaqanꞌatikꞌan tacha yu lakaxkati ali yu ixtalhitꞌajun yu jantu lajꞌox espíritus ali yu lokos ali yu niy panchꞌix y kujchoqoy, ex ni anchanu taqanꞌanin va tus ixlajkꞌuchꞌuꞌojoy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ex chuncha lhuvaj lapanakni tatꞌaꞌal yu machaqan xalakatꞌun Galilea, ali yu xalakatꞌun Decápolis ali yu laka putaulan Jerusalén vachu yu xalakatꞌun Judea, vachu yu machaqan takuktachal ni xalaꞌaxkan Jordán. ");
INSERT INTO tptNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Taval ni Jesús tejkan laqtsꞌil tachun ni lapanakni va alcha la ixꞌukxni lakataun aspajun. Ex ancha va taulalcha. Ex chuncha ixtꞌaltanan yu ixlakmalaniy tachinchal qasmaknan ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ex chuncha ni Jesús aqtayl jalakmalaniy, va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Lajꞌox kaxajtachal ixjatsukuntikꞌan ni lapanakni yu takꞌatsan tacha kilpatanin. Ni yuꞌuncha tapaxtoqniy katatanul taꞌan lhachimoꞌonun Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Lajꞌox kaxajtachal ixjatsukuntikꞌan ni lapanakni yu tamaqaninin. Ni yuꞌuncha Dios kalakmalakaꞌulayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Lajꞌox kaxajtachal ixjatsukuntikꞌan ni lapanakni yu lakstꞌuniy takꞌatsan. Ni yuꞌuncha ixnavinkꞌan kunaꞌ ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Lajꞌox kaxajtachal ixjatsukuntikꞌan yu ayaj tanajun kamakakal yu Dios lhinajun tus va tacha katachavanil takꞌatsan. Dios kalaqxtaqniꞌoyaꞌ yu tapuxkajuy tus va tacha kataꞌotsalcha katakꞌatsanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Lajꞌox kaxajtachal ixjatsukuntikꞌan yu tamapaynininta. Ni yuꞌuncha Dios kalakmapayniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Lajꞌox kaxajtachal ixjatsukuntikꞌan yu ox svaq tajunita la ixjalhanutkꞌan. Ni yuꞌuncha katalaqtsꞌinaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Lajꞌox kaxajtachal ixjatsukuntikꞌan yu tamaꞌoxamaktamincha taꞌan alin jaxkayanti. Ni yuꞌuncha kalakjunkanaꞌ sasꞌatꞌancha ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Lajꞌox kaxajtachal ixjatsukuntikꞌan yu jalhilakxkaykan por tamakay yu lajꞌox. Ni yuꞌuncha tapaxtoqniy katatanul taꞌan lhachimoꞌonun ni Dios laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Lajꞌox kaxajtachal mijatsukuntikꞌan ni uxiknan tejkan ni lapanakni katalaktuꞌuyan y katamukꞌaniyan ni jalaklkanti y katalhimaqchapuyan por kilapanakni untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ayaj kalhiꞌachꞌantꞌaꞌutꞌik kun lhuu achati ni anchanu julchan tejkan chuncha katamakaniyan. Ay kunaꞌ milhilhajatkꞌan ni laktꞌiyan. Yu maqancha ixtalaqputeꞌey ixchivinti Dios vachu va chun jalaklhixkaykal. ");
INSERT INTO tptNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Uxiknankꞌan va tacha matsati para tachun ni lapanakni para ox kaval lakamunukpaꞌ. Pero incha jantu ox katꞌaylhipꞌintꞌik ex xajachipitik tacha matsati yu jantucha ox. ¿Tas pulaycha kan kajunchoqol? Jantucha tuꞌuchun xtapal kaval. Va kamajꞌankalcha lakatin para ancha katachꞌintaxapalcha ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Vachuꞌ ni uxiknankꞌan va xamaklku ni lakamunukpaꞌ untꞌatꞌik. Laqataun ay putaulan incha alinta laka aspajun ex yucha jantu lay tamaqsaꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Vachuꞌ jantu matichun mamaqtayay maklku ex maqatanuy ixqaltaꞌapuꞌ laqataun kajun. Ni maklku maqskꞌiniy kꞌamukꞌa talman ex tus kamapulkuꞌol ixpulakna laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yu uxiknankꞌan vachu va chun ni mimputsukukꞌan maqskꞌiniy kaval tacha maklku yu ox lay talaqtsꞌin ni lapanakni. Ex chuncha para ox katalaqtsꞌil yu uxiknankꞌan makꞌayatꞌik. Ex tachun ay katamakal mimPaykꞌan yu alintachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jantu kꞌalhakꞌapꞌupꞌintꞌik ni kakmil mamaktanaꞌ ixlhachimoꞌon Moisés kun ixchivintikꞌan yu maqancha ixtalaqputeꞌey ixchivinti Dios. Ni kitꞌin va ikminta laqentsanaꞌ yu taꞌan tsꞌanqaniy para laqsavalcha vas kavalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Laqsaval klajunau, tejkan vananaj tiꞌalin ni laktꞌiyan kun lakatꞌun jantu lay kamaxtunikal xalhachimoꞌon ni Moisés mas va laqatauncha punto ni laqatauncha letra. Ni yucha kataylhaꞌanaꞌ tus katapasaꞌol tachun yu maqskꞌiniy katapasal. ");
INSERT INTO tptNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Vachuꞌ klajunau incha matichun lapanaki jantu kamakal kuenta mas va lakatsꞌuniy yu lhiminta laqa xalhachimoꞌon ni Moisés vachu incha chuncha kalakmasunil lapanakni para jantu katamakal kuenta ex ni yucha lakatꞌuniy kunaꞌ taꞌan lhachimoꞌonun ni Dios. Pero yu qalasmaknan y jalakmalaniy yu alati para katamakal kuenta ex ni yucha ayaj ay kunaꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ni lapanakni yu tamasuy ixlhachimoꞌonkꞌan ni israelitas y vachuꞌ yu fariseos, yuꞌuncha la ixputsukukꞌan tasuy vas katatiꞌukxuntayal. Pero kitꞌin klajunau ni maqskꞌiniy apalay vas kataval metsukuntikꞌan xajantu yuꞌuncha para kꞌatꞌanutꞌachipitik taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Uxiknankꞌan asmaktꞌatꞌik tacha jalakjunkal yu maqancha mimpayankꞌan, va jalakjunkal: “Jantu kꞌamaqnin. Yu kamaqnininaꞌ ni yucha kamukꞌanikanaꞌ ixlaqtaqal.” ");
INSERT INTO tptNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ni yu kitꞌin iklajunau yu kalukujlayaꞌ kun ixlaqaj, yucha kamukꞌanikanaꞌ ixlaqtaqal. Mas va taꞌayuchacha lapanaki kaval incha va kaxkayl ixlaqaj y kajunil laqxtoqnuꞌ chivinti, yucha kamukꞌanikanaꞌ ixlaqtaqal u incha kajunil: “¡Uxintꞌi nitacha mijatapastakꞌati!”, ex ni yucha kapaxtoqniyaꞌ ixmaqanlqajnati la xajikmi laqnin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Ex incha lhitꞌan milapaxkan laka altar, incha kꞌapꞌastakꞌel ni lhitꞌaꞌun laqtaqal kun milaqaj, ");
INSERT INTO tptNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ex ancha kꞌamakꞌaunꞌel milapaxkan laka altar. Maqskꞌiniy pꞌunaj kꞌalaqpinꞌel milaqaj para ox kalalaqtsꞌinchꞌoꞌotꞌik. Ex laycha kꞌapꞌinchꞌoꞌo ni laka altar para kꞌamaqxtꞌaqtꞌicha milapaxkan. ");
INSERT INTO tptNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chavay incha matichun chivintanuputun laka machꞌalkꞌati por makꞌanin laqtaqal, ex tejkan pꞌintꞌatꞌik lakatin oxi kaxaꞌalatꞌi tacha milaqaj, para jantu kamaqxtaqnin kun machꞌalkꞌati. Incha jantu, ex yu machꞌalkꞌati kamaqxtaqniyan ixpolisia, ex kꞌatꞌanuyeꞌe laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Laqsaval ijkunan ni ancha jantu katꞌaxtꞌuchꞌoꞌoyeꞌe incha jantu kamapꞌalꞌoyeꞌe tachun ni tumin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Uxiknankꞌan asmaktꞌatꞌik tacha jalakjunkal yu maqancha mimpayankꞌan: “Jantu katꞌatꞌamatꞌi qayntaun yu jantu minavin kaval.” ");
INSERT INTO tptNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero kitꞌin klajunau incha matichun kalaqtsꞌil qayntaun xanati yu jantu ixnavin tus katꞌatamaputul ex ni yucha jamaqtaqalhinincha la ixjalhanuti. ");
INSERT INTO tptNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Chavay incha kꞌamakꞌapꞌutꞌu talaqalhin por yu laqtsꞌin la milaqchul, apalay ox kaval ni kꞌalakpꞌumaxtꞌukꞌa milaqchul y kamajꞌacha. Apalay ox kamaꞌatsꞌanꞌatꞌi laqataun la milakatunaj xajantu kꞌatꞌanꞌalhuꞌokꞌa kun tachun milakatunaj ni laqnin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chavay incha makꞌapꞌutꞌun talaqalhin kun milhijakanaj mimakaꞌ, apalay ox kaval ni kꞌachꞌaqxmajꞌacha. Apalay ox kamaꞌatsꞌanꞌatꞌi laqataun la milakatunaj xajantu kꞌatꞌanꞌalhukꞌa kun tachun milakatunaj ni laqnin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Vachu va naunkal ni mas va taꞌayucha kamakaunchoqol ni ixanati maqskꞌiniy kaxtaqnil aqxtaun karta yu pulamakaunkan. ");
INSERT INTO tptNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero yu kitꞌin klajunau incha qayntaun joꞌati makajun ixanati mas jantu kamaqtaqalhinil, ex va ixlaqtaqal ni xapay incha ixanati kamaqtaqalhinil por katꞌatsukuchoqol aqayntaun. Vachuꞌ yu tꞌatsukuy qayntaun xanati yu valiꞌiy makaunkal, ni yucha maqtaqalhinin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Vachu asmaktꞌik tacha lakjunkal ni lapanakni maqancha: “Jantu aqtaun kꞌanau ni va laqsaval minchivinti incha jantu laqsaval kaval. Tachun yu uniy ni Dios miJalhachimoꞌonuꞌ ni kamakꞌayeꞌe yucha kamakꞌayeꞌe.” ");
INSERT INTO tptNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero kitꞌin iklajunau jantu aqtaun kꞌapꞌuchꞌivintꞌapꞌasutꞌik tuꞌuchun por kꞌamasavalatꞌik. Jantu kꞌapꞌuchꞌivintꞌapꞌasutꞌik ni laktꞌiyan, porke ancha va taꞌan lhachimoꞌonun Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni por lakatꞌuncha, va ancha chꞌintay Dios. Ni por yu laka putaulan Jerusalén, va ancha ixputaulan ni ay Jalhachimoꞌonu Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Vachu jantu kꞌapꞌuchꞌivintꞌapꞌasutꞌik miꞌaqtsulkꞌan. Jantu aqtaun lay kamakꞌayapitik laqxnapapa nisin jantu lay kamakꞌayapitik laqtsꞌiti mas va maqataun miꞌaji. ");
INSERT INTO tptNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Incha laqsaval kꞌamakꞌayapitik yu talhisakmiy ex vamun kanauntꞌik “Chun”. Incha jantu, ex kꞌanauntꞌik “Jantu”. Chavay matichun incha jantu makay tacha aniy, ex makay talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Vachu asmaktꞌik ni va maqancha naunkal: “Incha matichun kalaqalhinil ixlaqchul aqayntaun ex vachuꞌ tsꞌanqay kamaxtunikal ixlaqchul. Incha matichun kalaqalhinil ixtatsalati aqayntaun ex vachuꞌ tsꞌanqay kamaxtunikal ixtatsalati.” ");
INSERT INTO tptNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero kitꞌin klajunau ni jantu aqtaun kamaktꞌaukꞌanichꞌoꞌo qayntaun lapanaki yu makaniyan laqtaqal. Chavay incha matichun palaqstisayan, va kaxtꞌaqnin aminpalaqxtitaun. ");
INSERT INTO tptNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chavay incha matichun lhichivintanuputunan laka pulakchivin por maxtuniputunan mixkujuꞌ, kꞌamakꞌaunincha para kalhaꞌalcha y vachu kaxtꞌaqnin yu minkutun. ");
INSERT INTO tptNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chavay incha matichun makaniyan laqatapꞌasta para kalhipꞌi ixmachꞌapati taun kilometro, ex kꞌalhipꞌi tꞌuy kilometro. ");
INSERT INTO tptNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vachu incha matichun skꞌiniyan taun tuꞌuchun kaxtꞌaqnin, incha va matsiskꞌiniyan ex kꞌamachꞌixtꞌaqnincha. ");
INSERT INTO tptNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Vachu asmaktꞌatꞌik yu maqancha naunkal: “Kꞌapꞌaxkꞌatꞌi yu mintꞌamachaqaꞌ y kꞌaxkꞌay yu mintꞌalaxkayaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero yu kitꞌin klajunau ni kapꞌaxkꞌatꞌik yu mintꞌalaxkayankꞌan y ox kalhichꞌivinitꞌik yu jantu ox talhichivinanan, ox kalakmakꞌanitꞌik yu taxkayyan, kaskꞌintꞌik Dios por yu talaktuꞌuyan y jantu ox tamakaniyan. ");
INSERT INTO tptNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ex chuncha ni uxiknan sasꞌatꞌan kꞌunapitik ni mimpaykꞌan yu vilchal laktꞌiyan. Yucha jalakmapulkuniꞌojoy ixjulchan mas yu jalaktuꞌunun kun yu lajꞌoxin lapanakni, y vachu jalakmamaniy ni xkan yu vas tatiꞌukxuyanal y vachu yu talaktuꞌunun. ");
INSERT INTO tptNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Chavay ni uxiknankꞌan incha vamun pꞌaxkꞌayatꞌik ni lapanakni yu tapaxkayan, ¿ex tisuncha xtapal kaval? Vachu va chun talapaxkay ni laktuꞌunun lapanakni yu tachꞌinin impuestos. ");
INSERT INTO tptNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Vachuꞌ incha vamun ox mastꞌakꞌayatꞌik metꞌalaqauninkꞌan ex jantu tuꞌuchun xtapal kaval. Vachu va chun talamastakꞌay ni lapanakni yu jantu ixnavin Dios kataval. ");
INSERT INTO tptNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Vas katꞌiꞌukxuntꞌayatꞌik vachu va tacha yu mimPay Dioskꞌan yu vilchal laktꞌiyan. Yucha jantu tuꞌuchun tsꞌanqay la ixjapaxkanti. ");
INSERT INTO tptNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Tejkan tꞌoꞌoyayatꞌik Dios y kamakꞌatꞌik yu lajꞌox, jantu kamakꞌatꞌik la ixtalakavantikꞌan ni lapanakni para katalaqtsꞌin yu alati. Incha va chuncha makꞌayatꞌik ex yu mimPaykꞌan yu vilchal laktꞌiyan jantu tuꞌuchun lhilhajati kataxtaqniyan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Xlhiyucha tejkan aqtꞌayꞌuy yu kilpatanin jantu maqskꞌiniy tus va kꞌalaqpꞌutꞌeꞌeniꞌocha ni lapanakni. Ni lapanakni yu tꞌuy ukxpuꞌ tamakay, tejkan taꞌaqtayjuy kilpatanin, yuꞌuncha talhinajun kasunkal ni sqol laklhitamau u laqa chaqan taꞌan tataqxtoꞌa ni lapanakni para katakꞌatsal tachun ni lapanakni y para katatoꞌoyal. Pero laqsaval klajunau ni ixtoꞌoyakkꞌan vamun yuꞌ ixlhilhajatkꞌan katalaqaꞌiyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Chavay uxintꞌi tejkan jalaqꞌaqtꞌayꞌuy yu kilpatanin jantu maqskꞌiniy kakꞌatsal matichun mas yu ox milaqaj kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tejkan aqtꞌayꞌuy matichun va saqcha kꞌaꞌuntꞌi. Yu mimPay yucha laqtsꞌiniyan yu makꞌay, yucha kaxtaqniyan milhilhajati. ");
INSERT INTO tptNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Chavay ni uxiknankꞌan tejkan skꞌinatꞌik Dios, jantu kꞌaꞌuntꞌik tacha ni lapanakni yu tꞌuy ukxpuꞌ tamakay. Yuꞌuncha ayaj tamaqamay kataskꞌil Dios laqa chaqan taꞌan tataqxtoꞌa ni lapanakni y vachu taꞌan la ixpiktunuxnan ni laklhitamau. Tanajun katalaqtsꞌil tachun ni lapanakni y katatoꞌoyal. Laqsaval klajunau vamun yuꞌ ixlhilhajatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero yu uxintꞌi tejkan skꞌin ni Dios kꞌatꞌanutꞌi la minkuarto ex kꞌamalakchꞌaucha ni mimatiꞌ ex kꞌatꞌapꞌayninincha mimPay Dios yu ancha tꞌaꞌalintan laqatamaqsaq. Ex yu mimPay Dios laqtsꞌiniyan yu makꞌay laqatamaqsaq, ex ni yucha kaxtaqniyan ni milhilhajati. ");
INSERT INTO tptNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Tejkan kꞌatꞌapꞌayninin Dios, jantu kꞌanau aqlhuvaj chivinti yu jantu ixtapal tacha tamakay yu valiꞌiy lapanakni. Yuꞌuncha talhilay tejkan ayaj lhuu tachiviniy va apalay ox makay kuenta ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ni uxiknan jantu kaꞌuntꞌik tacha yuꞌuncha. Yu mimPay Dioskꞌan tejkan jantukaꞌ skꞌinatꞌik, yucha kꞌatsaycha tisuncha maqltꞌaskꞌiniyatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Yu uxiknankꞌan tejkan skꞌinatꞌik Dios maqskꞌiniy kꞌanauntꞌik inchine: KimPay Dios kꞌatꞌi yu alintꞌachiy laktꞌiyan, katatoꞌoyan ni lapanakni mintaqaꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kꞌalhachꞌimoꞌon aniy, chuncha kamakakal yu lhinaꞌun aniy lakamunukpaꞌ vachu va tacha makakan yu lhinaꞌun laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Lhilhiy kilaxtaqniu yu vayti yu kmaqskꞌiniyau. ");
INSERT INTO tptNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kilamalaqmixiniu ni laqtaqal yu klamakaniyau, vachu va chun tacha kijnan kmalaqmixiniyau ni lapanakni yu kintamakaniyan laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jantu kilalhilhaꞌau taꞌan kakmapastaknikau yu talaqalhin, va kilamalaqtaxtuu laqa talaqalhin. Va chuncha kavalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Chavay incha ni uxiknankꞌan lamalaqmixiniyatꞌik ni lapanakni yu tamakaniyan laqtaqal, ex yu mimPay Dioskꞌan yu vilchal ni laktꞌiyan vachu katamalaqmixiniyan ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Incha jantu kꞌamalaqmixiniyapitik ni lapanakni yu tamakaniyan laqtaqal, ex vachu yu mimPay Dioskꞌan jantu katamalaqmixiniyan mintalaqalhinkꞌan ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Tejkan tꞌaskꞌaꞌayatꞌik ni uxiknan, jantu kamaqaninil miꞌukxpukꞌan, tacha ni valiꞌiy lapanakni yu tꞌuy ukxpuꞌ tamakay. Ni yuꞌuncha tejkan tataskꞌajay va tamamaqanixvay ixꞌukxpukꞌan para katalaqtsꞌil ni lapanakni ni va tataskꞌajay y katatoꞌoyal. Laqsaval klajunau vamun yuꞌ ixlhilhajatikꞌan katalhitsukuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ni uxintꞌi tejkan tꞌaskꞌaꞌay maqskꞌiniy ox kaꞌoqxpꞌuchꞌaꞌa y ox kalaꞌoxikꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ex yu lapanakni jantu katakꞌatsanin incha tꞌaꞌun taskꞌajan, vamun kakꞌatsal mimPay Dios yu ancha tꞌaꞌalintan laqatamaqsaq. Ex chuncha mimPay Dios yu laqtsꞌinꞌojoy mas yu jantu tasuy, yucha kaxtaqniyan milhilhajati. ");
INSERT INTO tptNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jantu maqskꞌiniy kꞌalalhavatꞌik maqaliti yu aniy lakamunukpaꞌ. Aniy va laqlvajiy ni tsapul y masꞌojoy, va talaqalhiꞌojoy. Aniy vachuꞌ yu alhavanaꞌ tanuy para kaꞌalhaul. ");
INSERT INTO tptNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas apalay ox kꞌalalhavatꞌik ni maqaliti ni laktꞌiyan, ex ancha ni alhavanaꞌ jantucha lay katanutachal para kaꞌalhaul, y vachu yu tsapulin kun yu mamasay jantucha lay katatanutachal para katalaqalhil. ");
INSERT INTO tptNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Taꞌan maꞌalinatꞌik mimaqalitkꞌan, va ancha pꞌastꞌakꞌatꞌik la mejalhanutikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Yu milaqchul va tacha taun xamaklku la milakatunaj; incha lajꞌox milaqchul, ex alin maklku para taꞌakchun milakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Chavay incha milaqchul jantu lajꞌoxin kataval, ex tachun yu milakatunaj kaputsꞌisꞌoyaꞌ. Mas tunkujunta la milakatunaj pero lhiꞌakxajyachal putsꞌisniꞌ. Ex chuncha apalay sqoyaq lhiꞌakxajyachal ni putsꞌisniꞌ la milakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Jantu matichun lay oxi katapatsanil qayntaun jaꞌukxtin y vachuꞌ aqtauncha katapatsanil aqayntaun. Kaꞌachaniyaꞌ yu qayntaun y kaxkayyaꞌ yu aqayntaun. Va katꞌaꞌanaꞌ yu qayntaun y jantu kamakayaꞌ kuenta yu lhinajun yu aqayntaun. Vachu va chuncha jantu lay tꞌapꞌatsꞌaniy ni Dios incha tꞌoꞌoyay yu maqaliti. ");
INSERT INTO tptNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Xlhiyucha kitꞌin klajunau jantu katapastakꞌun la metsukuntikꞌan tisuncha kꞌaꞌuyapitik y kaꞌoqyapitikcha, vachu jantu katapastakꞌun la milakatunajkꞌan suncha kꞌaꞌulayapitik. ¿Jantu kꞌatsꞌayatꞌik ni metsukuntikꞌan apalay xtapal xajantu yu vayti? Vachu yu milakatunajkꞌan apalay xtapal xajantu yu laqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chavay kalaqtsꞌintꞌik yu tsꞌoꞌon yu taltꞌilhinijtꞌajun ni laka unin. Yuꞌuncha jantu tachꞌan y jantu taxqanan y jantu tamaꞌay ixlhiꞌutkꞌan laka pakꞌatsa. Yu mimPaykꞌan yu alintachal laktꞌiyan yucha jalaqxtaqniy ixvaytikꞌan. Yu uxiknankꞌan apalay ixtapal metsukuntikꞌan xajantu yu tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Taꞌayucha siya uxiknankꞌan lay apalay putanꞌay kꞌaꞌunaꞌ vamun por pastakꞌuy? ");
INSERT INTO tptNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ex ni uxiknan ¿valiꞌiychacha ayaj tapastakꞌuyan ni milaqchꞌitkꞌan? Chavay kꞌalaqtsꞌintꞌik tacha taꞌajin ni xanti. Jantu tatapatsay, jantu tamakay isijuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero kitꞌin klajunau ixlaqchꞌiti yu ay lhachimoꞌonuꞌ Salomón mas ayaj ox ixlakatayay, jantu kalaqchaꞌal tacha ixꞌoxixtu laqataun xanti. ");
INSERT INTO tptNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ni javan yu chavay alinta lakakꞌavin, lhiy kalaqxauyacha laka horno pero ni Dios ayaj kꞌus jamalaqchꞌiniy. Ex apalay ox katamalaqchꞌiniyan ni uxiknan mas va lakatsꞌuniy milhakapuꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chuncha jantu maqskꞌiniy katapastakꞌun, jantu kanauntꞌik: “¿Tisuncha kaꞌuyaucha? u ¿Tisuncha kaꞌotꞌaucha? u ¿Tisuncha kalhimalaqchꞌininaucha?” ");
INSERT INTO tptNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yu valiꞌiy lapanakni, yuꞌuncha ayaj tapastakꞌuy yu aniy axtoqnuꞌ. Pero mimPaykꞌan yu vilchal laktꞌiyan, yucha kꞌatsay ni maqskꞌiniyatꞌik tachun ni anchanu axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Va kꞌalhipꞌuxkꞌauyapitik ni kalhachimoꞌonul Dios para kamakakal tachun yu lhinajun, ex kaꞌalinaꞌ tachun yu maqskꞌiniyatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Xlhiyucha jantu aqtaun katapastakꞌun yu katapasayaꞌ lhiy. Taun taun julchan alin yu lhitaꞌay, oxicha vamun kapꞌastꞌaktꞌik yu chavaycha. ");
INSERT INTO tptNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Jantu kꞌalakmukꞌanitꞌik laqtaqal yu alati lapanakni ex ni uxiknan jantu katamukꞌaniyan laqtaqal ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chavay yu tacha pꞌumukꞌaniyatꞌik laqtaqal yu alatin yu Dios vachu va chun katapumukꞌaniyan laqtaqal ni uxiknankꞌan. Chavay yu papulkan yu mapꞌatsꞌayatꞌik uxiknan vachu va yuꞌ ni papulkan katapulkaniyan ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Valiꞌiycha makꞌay kuenta yu lakatꞌuniy laqtaqal yu makay qayntaun milaqaj pero jantu makꞌay kuenta yu la ay laqtaqal yu makꞌay uxintꞌi? Va tacha laqtsꞌiniy xatalvayanti kꞌiu yu lakputanun la ixlaqchul milaqaj, pero jantu makꞌay kuenta yu la milaqchul va lakputanun maqaꞌay kꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chavay incha lakputanun ni maqaꞌay kꞌiu la milaqchul, ¿ex valiꞌiycha uniy milaqaj: “Kakmaxtuniyan yu xatalvayanti kꞌiu yu lakputanun la milaqchul”? ");
INSERT INTO tptNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Va tꞌuy ukxpuꞌ makꞌay. Maqskꞌiniy pꞌunaj kꞌamaxtꞌuꞌel ni maqaꞌay kꞌiu yu lakputanun la milaqchul, ex chuncha apalaycha ox kꞌalakꞌavananeꞌe para kꞌamaxtꞌunin xatalvayanti kꞌiu yu lakputanun la ixlaqchul milaqaj. ");
INSERT INTO tptNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Yu lajꞌox jantu kꞌalakmasunitꞌik ni lapanakni yu taxkajiy, yuꞌuncha va tacha laktuꞌunun xꞌoyun yu va lay katatalqamal y katalaktuꞌuyan. Vachu jantu kꞌaxtꞌaqnitꞌik jatapastakꞌati ni lapanakni yu jantu tamakay kuenta, yuꞌuncha va tacha pꞌaxnin yu valiꞌiy katalaqamanal chiyux yu laqlhuu xtapal. ");
INSERT INTO tptNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Kaskꞌinitꞌik Dios yu maqskꞌiniyatꞌik, yucha kataxtaqniyan. Kꞌalakxkꞌautꞌik ex katꞌemayapitik. Katꞌaylhipꞌi makasanaꞌ laka matiꞌ, ex katalaqltiꞌayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yu skꞌin tuꞌuchun, va laqaꞌiy. Yu puxkajuy, va temay. Yu makasay laka matiꞌ, ni yucha malaqltiꞌanikan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Xaqayntaun ni uxiknan incha kataskꞌinin ni pan mesꞌatꞌakꞌan, va kꞌaxtꞌaqnitꞌik chiyux? ");
INSERT INTO tptNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Incha kataskꞌinin jatanti, kꞌaxtꞌaqnitꞌik tsapul? ");
INSERT INTO tptNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Chuncha ni uxiknankꞌan mas va jalaktuꞌunun untꞌatꞌik lay xtꞌaqniyatꞌik laqxoqta yu lajꞌox ni mesꞌatꞌankꞌan. Ex laqsaval mimPaykꞌan yu vilchal laktꞌiyan kalaqxtaqniyaꞌ yu apalay ox yu taskꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Kꞌalakmakꞌanitꞌik yu alati vachu va tacha naunatꞌik katamakanin. Va yucha yu lhinajun ixlhachimoꞌon Moisés kun yu maqancha ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Kꞌatꞌanutꞌikcha taꞌan putꞌuniy ni kiltalakxtuti. Yu puꞌay kiltalakxtuti taꞌan jantu lhitaꞌay ni lakatin, ancha puꞌankanta laka lhinin. Yu anchanuꞌ tin, ancha apalay qaynlhuu tapuꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero yu xatin yu puꞌankanta taꞌan ox jatsukunti, ancha va putꞌuniy y ayaj lhitaꞌay, ancha va lakatsꞌuniy yu tapuꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Kꞌalhistꞌajkꞌantꞌikcha kun yu tamakanunun mas tanajun talaqputeꞌey ixchivinti Dios. Ni yuꞌuncha tejkan talaqminan tatasuy tacha qalꞌoxin tacha valiꞌiy borregos. Pero laqsaval talaktuꞌunun, va tacha maqtalin yu taꞌuputunan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Lay kꞌalakpꞌumispꞌatꞌik va por yu tamakay, vachu va tacha lay pumispakan aqataun kꞌiu por yu xaꞌunikan. Jantu lay kꞌapꞌuxtꞌi ni uvas laka jaltukun y vachu jantu lay kꞌapꞌuxtꞌi higos taꞌan valiꞌiy jakꞌivinan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tachun ox kꞌiu xtaꞌa yu lajꞌox xaꞌunikan. Yu jantu ox kꞌiu kaval ni yucha xtaꞌa yu jantu lajꞌox xaꞌunikan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yu ox kꞌiu jantu lay xtaꞌa yu jantu ox xaꞌunikan. Vachu yu kꞌiu yu jantu ox jantu lay xtaꞌa yu lajꞌox xaꞌunikan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tachun kꞌivinan yu jantu xtaꞌa lajꞌox xaꞌunikan yucha kachaqxtakalcha y kamapꞌukalcha laka jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ex chuncha ni uxiknan kꞌalakpꞌumispꞌayapitik ni lapanakni, va por ixlhitapatskꞌan yu tamakay. ");
INSERT INTO tptNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jantu tachun yu kintajuniy: “Jalhachimoꞌonuꞌ, Jalhachimoꞌonuꞌ”, katatanutachal taꞌan lhachimoꞌonun ni Dios. Vamun yu tamakay tacha lhinajun ni kimPay yu vilchal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ni anchanu julchan ayaj qaynlhuvaj lapanakni kintajunaꞌ: “Jalhachimoꞌonuꞌ, Jalhachimoꞌonuꞌ, klhichiviniu kun ixtapꞌasta mintaqaꞌuti ex ayaj lhuu aqmoqxnun iklakmaxtuniu lapanakni, y la mintaqaꞌuti lajꞌay axtoqnuꞌ ikpumakau.” ");
INSERT INTO tptNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero ex kaklakjunaꞌ: “Jantu aqtaun ni iklamispau. Kaꞌostꞌikcha kun kitꞌin yu uxiknan maqtaqalhinin untꞌatꞌik.” ");
INSERT INTO tptNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Taꞌayu yu kinqalasmatꞌa y makay tacha yu klhinajun, yucha va ayaj jalakpastaknan tacha qayntaun yu makal ixchaqaꞌ kun xaputayan chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ex chuncha tamachil lajꞌay xkan y taꞌaynlhi yu laꞌaxkan y yu pꞌas un talakanunil ni anchanuꞌ chaqaꞌ. Pero jantu kamaqtal, yu xaputayan va si chiyux ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yu kinqalasmatꞌa y jantu makay tacha kitꞌin klhinajun, yucha lhiꞌakxajyachal va tacha qayntaun tontoj lapanaki yu makal ixchaqa kun xaputayan kukuj. ");
INSERT INTO tptNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ex chuncha tamachil lajꞌay xkan y talajꞌaynl ni laꞌaxkan, y vachu yu pꞌas un talakanunil ni anchanu chaqaꞌ, tus tachun lakpujꞌol y va aqtaun tachun lhaꞌanꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ex va chuncha tejkan mamaktalcha ixchivinti ni Jesús, ex yu lapanakni va tus vak takꞌatsal por yu tacha ixjamalaninin. ");
INSERT INTO tptNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Va ixjamalaninin tacha qayntaun pꞌas jalhachimoꞌonuꞌ y jantu kamalaninil tacha yu ixtamasuy ixlhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ex va chuncha tejkan tajuminchoqochalcha ni Jesús laka aspajun va lhuvaj lapanakni tatꞌaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ex ancha va talakanunil qayntaun joꞌati taqanꞌan yu lakapuchꞌita, ex ni yucha va taꞌaqtsoqoqtanil taꞌan ixyal ni Jesús, va junil: —Jalhachimoꞌonuꞌ, incha kꞌinkꞌuchꞌupꞌutꞌun, lay kꞌinkꞌuchꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ex ni Jesús va moqslanil ixmakaꞌ, va junil: —Chun, kitꞌin knajun palaycha kꞌaꞌunchꞌoꞌo. Ex va niman lakmamakaxanichoqolcha ni ixlakapuchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ex ni Jesús va junil: —Chavay ijkunan jantu matichun kalaqpꞌutꞌeꞌenin. Vamun kalaqpꞌinchiy yu kura y kalhipꞌinin milapaxkan yu tacha lhinajun ixlhachimoꞌon ni Moisés, para katakꞌatsaꞌol ni lapanakni ni palaycha unchꞌoꞌotꞌa mintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ex va chuncha tejkan tanuchal ni Jesús ni xaputaulan Kapernaum, ex qayntaun kapitan Romano va talakanunil ni Jesús va aqtayl tapaynini. ");
INSERT INTO tptNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Va junil: —Jalhachimoꞌonuꞌ, yu kiꞌoqxtamati yucha mal la kinchaqaꞌ. Ayaj pꞌas lakanita, tꞌajun majkꞌatsan taun pꞌas maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ex chuncha ni Jesús va naul: —Kajkꞌantachal ni kꞌuchꞌunuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ex yu kapitan Romano va naul: —Jalhachimoꞌonuꞌ, kitꞌin jantu ox kakval, jantu kimpaxtoqniy para kꞌintꞌatꞌanuchꞌiy la kinchaqaꞌ. Maqskꞌiniy vamun ni uxintꞌi kꞌanau, ex yu kiꞌoqxtamati laycha palay kajunchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kitꞌin klhitꞌajun kiꞌukxtin, vachuꞌ la kintamakaꞌ alin tropas yu kintaꞌaqtayjuyan. Tejkan xaqayntaun ijkuniy kaꞌal avintꞌi, ex ni yucha va niman an. Yu aqayntaun tejkan ijkuniy kamil, va niman min. Yu kiꞌoqxtamati tejkan ijkuniy kamakal tuꞌuchun, yucha va niman makay. Uxintꞌi vachu chun lay kꞌalhinau palay kajunchoqol ni kiꞌoqxtamati. ");
INSERT INTO tptNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tejkan qasmaklhi ni Jesús va tus saq tayal. Va lakjunil ni lapanakni: —Laqsaval klajunau jantu matichun israelita kaktemal yu chuncha lhakapuꞌanan tacha yu aniy lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Klajunau ayaj lhuvaj katamintachal taꞌan putakꞌutꞌa ni julchan y vachu taꞌan puꞌanachal, va katatꞌavaynacha ni Abraham ali Isaac ali Jacob taꞌan lhachimoꞌonun ni Dios laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Chavay yu ixtapaxtoqnil katataulal taꞌan lhachimoꞌonun ni Dios, yuꞌuncha va kalaqtanqalhukanaꞌ yu ixlhimaqspaꞌ taꞌan putsꞌista. Ancha katalajqalhutsukutachal y katalaktsakꞌalhitsukutachal ixtatsalatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ex junil ni Jesús ni kapitan: —Chavay kꞌapꞌinchꞌoꞌocha la minchaqaꞌ y chuncha kavalcha tacha ixlhakꞌapꞌuꞌpꞌin. Ex va chuncha ni ixꞌoqxtamati va palaycha junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ex ni Jesús va al la ixchaqaꞌ ni Pedro, va laqtsꞌil yu ixꞌatinaꞌ, va ixtaqanꞌay, ixmal la isaqati, va ixchꞌapata skakati. ");
INSERT INTO tptNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ex chuncha ni Jesús va chꞌapanil ixmakaꞌ, ex ni xanati va makaunchoqolcha iskakati, ostaulchoqol, aqtaylcha jalakvavay. ");
INSERT INTO tptNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ex va chuncha tejkan ixtꞌajuncha putsꞌisniꞌ, va laklhaꞌanikal ni Jesús ayaj lhuvaj taqanꞌanin yu ixtalhitꞌajun yu jantu lajꞌox espíritus. Ex chuncha va kun taun chivinti yu naul ni Jesús tus tachun yu jantu lajꞌox espíritus tataxtuniꞌochoqol y tachun ni taqanꞌanin taꞌayajnanꞌochoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Va chuncha tapasal para kataqayntsal yu tacha tsꞌoqlhi ni Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios tejkan naul: “Yucha lhaꞌanꞌol tachun ni kilakaxkatkꞌan y tꞌikukꞌalhaꞌanꞌol kintaqanꞌatkꞌan.” ");
INSERT INTO tptNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ex ni Jesús tejkan jalaqtsꞌilcha ayaj lhuvaj taval ni lapanakni va laklhijunil ixtꞌaltanan para katatꞌaꞌal yu ixlhiputakuktachal ni ay lakxkan. ");
INSERT INTO tptNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ex qayntaun lapanaki yu ixmasuy ixlhachimoꞌonkꞌan ni israelitas va talakanunil, va junil: —Jamalaniniꞌ, kitꞌin kaktꞌaꞌanan mas va toꞌoxtaychacha kapꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ex yu Jesús va junil: —Yu xanixꞌoyun, yuꞌuncha tamaqalin ixchaqakꞌan taꞌan poqapaj laktalpa. Yu tsꞌoꞌon, yuꞌuncha tamaqalin ixpaqtamankꞌan ni lakakꞌiu. Pero ni kitꞌin yu Sasꞌatꞌa Lapanaki, jantu kakmaqalil toꞌoxtaycha kakmastaknil ni kiꞌaqtsul. ");
INSERT INTO tptNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Aqayntaun ixtꞌaltanaꞌ ni Jesús va junil: —Jalhachimoꞌonuꞌ, va knajun kꞌimakꞌaunꞌel para kajkꞌal maknunuꞌ ni kimpay. ");
INSERT INTO tptNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ex ni Jesús va junil: —Kꞌintꞌatꞌatꞌicha. Kꞌalakmakꞌaucha ni janinin katalamaknulcha siya yuꞌuncha ni janinin. ");
INSERT INTO tptNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ex ni Jesús tajulcha laka barco. Yu ixtꞌaltanan vachuꞌ tatajul. ");
INSERT INTO tptNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ex va chuncha va ostaulal taun pꞌas un ni lakamar. Yu xkan va tus talman tantꞌaqstꞌay, va laycha kaꞌaqxtaqmal makay ni barco, pero ni Jesús va iltatay, jantu makay kuenta mas va laycha katatalaqtsꞌanqal. ");
INSERT INTO tptNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ex yu ixtꞌaltanan va taꞌal maqloꞌonun, va tajunil: —Jalhachimoꞌonuꞌ, ¡kilaꞌaqtayjuu! ¡Aniy tꞌaunaucha talaqtsꞌanqanin! ");
INSERT INTO tptNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ex ni Jesús va lakjunil: —¿Valiꞌiycha ayaj tꞌalhananatꞌikcha? Va lakatsꞌuniy milhakapuꞌatkꞌan. Ex ostaulal, laqꞌaymal ni un kun yu ay xkan yu ixtatantꞌaqstꞌata. Ex chuncha ni un kun yu xkan va talakataulchoqolcha, va saq junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ex yu ixtꞌaltanan va tus vak takꞌatsal ixtachunkꞌan. Taꞌaqtaylcha talalhisakmiy siya yuꞌuncha, va talajuniy: —¿Tas va ayuchacha ni anu lapanaki? Mas kaval un kun xkan, si taqalasmakꞌojoy. ");
INSERT INTO tptNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ex chuncha ni Jesús tatakukchalcha ni lakamar, la xalakatꞌun Gadara. Ex ancha taxajchil pumatꞌuy lapanakni yu ixtalhitꞌajun yu jantu lajꞌox espíritus. Va taminchal taꞌan mamakan janinin taꞌan poqapaj laktalpa, va tatalakanunil ni Jesús. Va laktaxtujcha ixtajunita, va ayaj laklhitalhaunita, va tus jantu matichun lay ixtapasay anchanu lakatin. ");
INSERT INTO tptNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ex ni anchanu lapanakni va taꞌaqtayl pꞌas tatꞌasay, va tanajun: —Jesús, jantu kilalaqltalakanuu ni kijnan, ni uxintꞌi Sasꞌatꞌa Dios unitꞌa. ¿Chavay va tꞌantꞌacha para kilamamaqanlqajniu, mas jantukaꞌ lakachin ni julchan? ");
INSERT INTO tptNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ancha, jantu maqati, ixtaꞌalin lhuvaj pꞌaxnin, va ixtatꞌajun exvaynin. ");
INSERT INTO tptNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ex yu jantu lajꞌoxin espíritus va tatapayninil ni Jesús, va tajunil: —Incha kilamaxtuyau, kilamakajuu para kaklaqtanuu yu anu pꞌaxnin. ");
INSERT INTO tptNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ex ni Jesús jalakjunil: —Kapꞌintꞌikcha. Ex ni jantu lajꞌox espíritus va tataxtuchoqolcha ni anchanu pumatꞌuy lapanakni, va talaqltanulcha ni pꞌaxnin. Ex ni pꞌaxnin va taputakyaulcha taꞌan qaltalman, va tatajuchal yu lakxkan, va taꞌakskajꞌuꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ex yu ixtalhistakꞌa ni pꞌaxnin va tus tatakyauꞌol. Tejkan tachaꞌal ni laka putaulan, taꞌaqtaylcha talaqputeꞌey tachun yu tapasal ni anchanu pumatꞌuy yu ixtalhitꞌajun yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ex chuncha tus tachun yu xalapanakni ni anchanu putaulan talaqmil ni Jesús. Tejkan talaqtsꞌil ni ancha vil, va tatapayninil para kataxtuchoqol la ixtꞌunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Va chuncha taval ni Jesús va tajuchoqolcha laka barco. Ex tejkan takukchoqochil yu ay lakxkan, va anchoqol la ixputaulan. ");
INSERT INTO tptNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ex ancha talhaanil qayntaun yu ixlakanita, va ixtapulhaꞌanta putaman. Tejkan ni Jesús jalaqtsꞌil ni yuꞌuncha va ayaj talhakapuꞌan, va junil ni taqanꞌan: —Kesꞌatꞌa kꞌatꞌi, kꞌalhiꞌachꞌantꞌaꞌutꞌi. Yu mintalaqalhin laqmixlhicha. ");
INSERT INTO tptNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yu alati lapanakni yu ixtamasuy ixlhachimoꞌonkꞌan vachu ancha ixtaꞌalinta. Ex ni yuꞌuncha tapastaklhi: “Por ixchivinti xꞌaman makakan tacha Dios kaval y chuncha akchꞌintamay ni Dios.” ");
INSERT INTO tptNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ni Jesús yucha va ixlakkꞌatsaniycha yu ixtatꞌajun pastaknan, ex ni yucha va lakjunil: —¿Valiꞌiycha ni uxiknan lhitꞌaunatꞌik yu jantu lajꞌox jatapastakꞌati? ");
INSERT INTO tptNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Suncha yu mas apalay jantu lhitaꞌay kaval, va kꞌaꞌun: “Yu mintalaqalhin laqmixlhicha”, u va kꞌaꞌun: “Kꞌaꞌostꞌaꞌulcha, katꞌiꞌukxuntꞌayachꞌoꞌocha”? ");
INSERT INTO tptNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Chavay klamasuniyau ni kitꞌin yu kval Sasꞌatꞌa Lapanaki klhitꞌajun lhachimoꞌon aniy lakamunukpaꞌ para kakmalaqmixil ni talaqalhin. Ex va junil ni lapanaki yu ixlakanita: —Chavay ijkunan, kꞌaꞌostꞌaꞌulchꞌoꞌocha. Kasakchꞌoꞌocha mimputaman y kapꞌinchꞌoꞌocha la minchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ex yu ixlakanita va ostaulchoqolcha, va anchoqolcha la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tejkan chuncha talaqtsꞌintayal ni lapanakni, va ayaj tatalhanal. Ex ay tamakal ni Dios por yu ay tapꞌasta jalaqxtaqnikal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ex anchoqol ni Jesús, va laqtsꞌil qayntaun joꞌati ixjunkan Mateo. Va ixvil taꞌan mapalkan impuestos. Ex ni Jesús va junil: —Kꞌintꞌatꞌatꞌicha. Ex ni Mateo va ostayal, va tꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Va chuncha taval, ni Jesús va al vayaꞌ la ixchaqa ni Mateo. Va tachil lhuvaj yu ixtachꞌinin impuestos y vachu tamil yu alati maqtaqalhinin. Vachu tatꞌataulal chꞌantaun ni Jesús kun ixtꞌaltanan lakamesa. ");
INSERT INTO tptNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yu fariseos tejkan chuncha talaqtsꞌil, va taꞌaqtayl talhisakmiy, va lakjunkan ixtꞌaltanan ni Jesús: —¿Valiꞌiycha yu mijamalaninikꞌan yucha jalaktꞌavajin yu xachꞌinin impuestos kun yu alati jamaqtaqalhinin? ");
INSERT INTO tptNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ni Jesús va qasmaklhi. Ex va lakjunil: —Yu taꞌayajnan jantu tamaqskꞌiniy kalajkꞌuchꞌukal, yu tamaqskꞌiniy va yu taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Kꞌapꞌinchꞌoꞌotꞌikcha y kalaniyapitik para kamalaꞌasitꞌik tisuncha naunputuncha yu aniy tsꞌoqkanta la ixchivinti Dios: “Kitꞌin klhinajun va kꞌalamapꞌaynitꞌik, jantu klhinajun kꞌamoqslatꞌik lapaxkan.” Chuncha tsꞌoqkanta. Kitꞌin jantu ikminta laktꞌasaꞌin yu lajꞌoxi lapanakni, va ikminta laktꞌasaꞌin yu maqtaqalhinin. ");
INSERT INTO tptNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ex ni lapanakni yu ixtatꞌaꞌan ni Juan yu ixlakmalaniy, yuꞌuncha tatalakanunil ni Jesús, va tajunil: —Kijnan kun ni fariseos ayaj iktaskꞌajayau. ¿Chavay yu mintꞌaltanan, valiꞌiycha jantu tataskꞌajay? ");
INSERT INTO tptNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ex ni Jesús va lakjunil: —Tejkan alin lakxtuklati, ¿lhilay ni katamaqaninanaꞌ yu jalakjuntaꞌikanta? Jantu lay taskꞌajay tejkan vananaj tatꞌavilanal ni tsꞌal yu lakxtuklay. Pero kaminaꞌ julchan tejkan kamaxtukanaꞌ ni anchanuꞌ tsꞌal, ex ixtꞌaltanan katataskꞌajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Jantu matichun lhilaqpumpuy aqxtaun xkujuꞌ yu atꞌaliꞌ kun yu sastꞌi lhalaqpumpum. Yu sastꞌi lhalaqpumpum va talaqatamiy, ex chuncha yu atꞌaliꞌ laqchꞌiti va apalay taꞌexa. ");
INSERT INTO tptNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vachu jantu paxtoqniy kꞌamuꞌutꞌi yu sastꞌi xaxkan uva laka atꞌaliꞌ jaxtaꞌan. Yu atꞌaliꞌ jaxtaꞌan va taꞌexa, ex yu xaxkan uva kun yu jaxtaꞌan putꞌuy tatsꞌanqay. Yu sastꞌi xaxkan uva maqskꞌiniy kamujukal laka sastꞌi jaxtaꞌan, chuncha lay pumaꞌakan yu jaxtaꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tejkan chuncha ixtꞌajun lhichivin ni Jesús, ex chinchal qayntaun xalhachimoꞌonuꞌ ni israelitas. Va taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ ni Jesús, va junil: —Ni kintsiꞌi va aniykaꞌ ixniy. Chavay kꞌatꞌatꞌi kamoqslanin mimakaꞌ ex kalakpukujchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ex va chuncha ni Jesús kun ixtꞌaltanan va taꞌostaulal y tatꞌaꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Va chuncha, qayntaun xanati va talakanunil ni Jesús. Anchanuꞌ xanati ixtaqanꞌaycha laqakautꞌuy jachꞌitin, va ixtaxtuniy jakꞌalnan. Yucha talakanunil ni Jesús la ixlhistapuꞌ, va piklanil la ixkiltuꞌ ixlaqchꞌiti kun ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Va ixpastakꞌa: “Incha vamun kakpiklanil la ixkiltuꞌ ixlaqchꞌiti, ex palaycha kajkunchoqol ni kintaqanꞌati.” ");
INSERT INTO tptNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ex ni Jesús talaqaspꞌiklhi, laqtsꞌil ni anchanu xanati, va junil: —Kintsiꞌi kꞌatꞌi, kꞌalhiꞌachꞌantꞌaꞌutꞌi. Va kꞌilhakꞌapꞌupꞌin, xlhiyucha palaycha xaꞌunchꞌoꞌoy. Ex va niman palaycha junchoqol ni xanati. ");
INSERT INTO tptNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ex ni Jesús chaꞌalcha la ixchaqaꞌ yu anchanu jalhachimoꞌonuꞌ. Va jalaqtsꞌil ni jasanan yu ixtalaqsqoliy para ixmaknuka ni jatsiꞌi ali vachu ni lapanakni va tus pꞌasni talajqalhun. ");
INSERT INTO tptNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ex va jalakjunil: —Kꞌatꞌaxtꞌutꞌikcha. Yu jatsiꞌi jantu kanil, ni yucha va ltatay. Ex yu lapanakni vamun talhiꞌachan ni Jesús tacha ni naul. ");
INSERT INTO tptNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ex tejkan jalakmaxtulcha, tanuchalcha, va chꞌapanil ixmakaꞌ ni jatsiꞌi, va maꞌostaulnichoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ex ni anchanu xalakatꞌun va tus takꞌatsaꞌol yu tacha tapasal. ");
INSERT INTO tptNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tejkan taxtuchoqol ni Jesús, pumatꞌuy laꞌachꞌixin va tatꞌamil, va tajunil: —¡Istsꞌal David kꞌatꞌi, kilamapayniu ni kijnan! ");
INSERT INTO tptNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ex tejkan tanul laqa chaqaꞌ ni Jesús, yu laꞌachꞌixin va tatalakanunil. Ex ni yucha va lakjunil: —¿Lhakꞌapꞌupꞌinatꞌik ni uxiknan ni lay kaklamalakavaniu? Ex ni laꞌachꞌixin va tanaul: —Chun, Jalhachimoꞌonu, kalayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ex ni Jesús jalaqpuchꞌapal la ixlaqchulkꞌan, va lakjunil: —Chuncha kaval tacha lhakꞌapꞌupꞌinatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ex ni yuꞌuncha va talakavananchoqolcha. Pero ni Jesús va lakjunil: —Jantu matichun kꞌalaqpꞌutꞌeꞌenitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero yuꞌuncha mas va ankaꞌ tataxtuchal va niman talaqputeꞌeꞌol talakachux ni anchanu xalakatꞌun yu tacha lakmakanil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ex va chuncha tejkan va ankaꞌ tataxtuchoqol ni laꞌachꞌixin, ex lati lapanakni talhiminil ni Jesús qayntaun janunuꞌ. Va ixlhitꞌajun taun aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ex tejkan ni Jesús maxtunichoqol ni anchanu aqmoqxnuꞌ, ex ni janunuꞌ va aqtaylcha chiviniy. Yu lapanakni va tus vak takꞌatsal, va tanajun: —Ni aniy lakatꞌun Israel jantu aqtaun tuꞌuchun kalaqtsꞌiu tacha yu aniy ixlaqtsꞌinau. ");
INSERT INTO tptNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero yu fariseos va tanaul: —Ni yucha va yu xaꞌukxtin aqmoqxnun xtaqnichoqoy tapꞌasta para lay kalakmaxtuchoqol ni aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ni Jesús va tus kilaꞌol ni talakachux putaulanin, mas yu lakstꞌunin, va ixjalakmalaniy taꞌan ixtataqxtoꞌa ni lapanakni. Va ixjalaqputeꞌeniy yu ox chivinti yu masuy tacha lhachimoꞌonun ni Dios. Vachu ixlajkꞌuchꞌuꞌojoy tapuchux jataqanꞌati kun jalakaxkati. ");
INSERT INTO tptNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ex chuncha tejkan jalaqtsꞌil ni lapanakni, va jalakmapaynil, va ixtamaqanlqajnan y ixꞌamankꞌan ixtajunita, va tacha borregos yu jantu kaꞌalil qayntaun yu kalaklhistaklhi. ");
INSERT INTO tptNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ex va lakjunil ixtꞌaltanan yu ixlakmalaniy: —Alin pumalhuu lapanakni yu va tacha ixlhijaxqanati Dios pero tsꞌanqay oqxtamatin yu kataxqanal. ");
INSERT INTO tptNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Xlhiyucha kꞌatꞌapꞌayninitꞌik ni Dios para kajamalaqachal oqxtamatin la ixlhijaxqanati. ");
INSERT INTO tptNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ex ni Jesús lakjuntaꞌil yu pumakautꞌuy ixtꞌaltanan. Va jalaqxtaqnil ni lhachimoꞌon para katamaxtul ni jantu lajꞌox espíritus, y para lay katakꞌuchꞌuꞌol tapuchux taqanꞌati kun tapuchux lakaxkati. ");
INSERT INTO tptNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ni aniy va yu ixtaqaꞌutikꞌan yu pumakautꞌuy ixjamalaqachanti ni Jesús. Yu xapꞌunaj va Simón yu vachu ixjunkan Pedro, ali Andrés yu ixlaqaj, ali Jacobo kun Juan yu istsꞌalan Zebedeo, ");
INSERT INTO tptNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ali Felipe ali Bartolomé ali Tomás ali Mateo yu ixchꞌinin impuestos, ali Jacobo yu istsꞌal Alfeo, ali Lebeo yu vachu ixjunkan Tadeo, ");
INSERT INTO tptNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ali yu aqayntaun Simón yu ixlhiyal xapartido cananista, ali yu Judas Iscariote yu astan maqxtaqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ex ni Jesús va jalaqmalaqachalcha ni anchanu pumakautꞌuy, pero jalaqxaqalaꞌelal, va lakjunil: —Jantu kꞌapꞌintꞌik la ixputaulankꞌan yu valiꞌiy lapanakni y vachu jantu kapꞌintꞌik la xaputaulanin Samaria. ");
INSERT INTO tptNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Apalay ox kajalaqpꞌintꞌik ni xalapanakni Israel yu tatiꞌukxuyanal tamaqatsꞌanqatacha ixjatapastakꞌatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kapꞌintꞌikcha kꞌalaqpꞌutꞌeꞌeniyapitikcha ni xalhachimoꞌon laktꞌiyan va lakachilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Vachu kalajkꞌuchꞌuyapitik yu talakapuchꞌita, vachu kꞌalakmajkꞌuꞌuchꞌoꞌotꞌikcha yu janinin, vachu kamaxtꞌuyapitik yu jantu lajꞌox espíritus. Ni uxiknan va valiꞌiy laꞌaꞌitꞌik ni aniy tapꞌasta, ex chuncha yu milhitapatsakꞌan vachu va valiꞌiy kamakꞌayapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Jantu maqskꞌiniy kalhipꞌintꞌik oro ali plata ali cobre ");
INSERT INTO tptNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nisin moral jantu kalhipꞌintꞌik. Milaqchꞌitkꞌan jantu maqskꞌiniy kalhipꞌintꞌik yu para milamapaxankꞌan nisincha yu mivarachikꞌan nisincha yu mimpalikkꞌan. Yu tapatsay ni yucha lhitꞌajun lakatin para kavavakal. ");
INSERT INTO tptNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Tejkan kachꞌipꞌinapitik taꞌan lajꞌay putaulanin kun yu lakstꞌunin putaulanin, ex ancha kalhisakmiyapitik taꞌayucha ox lapanaki kaval. Katꞌaulapitik la ixchaqa tus tejkan katꞌaxtꞌuchꞌoꞌoyapitikcha. ");
INSERT INTO tptNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tejkan kꞌatꞌanutꞌachipitik ni laqa chaqaꞌ, kamastꞌakꞌayapitik kun achati tachun ni lapanakni yu ancha tavilanal. ");
INSERT INTO tptNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Incha qalꞌoxin lapanakni taꞌalinta ni anchanu chaqaꞌ, ex yu lamastakꞌan ancha katamakaunaꞌ. Pero incha jantu qalꞌoxin lapanakni kataval ex yu lamastakꞌan kataxtuchoqotachal kun uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Incha jantu katalaqaꞌiyan y jantu kataqalasmakputunan, ex katꞌaxtꞌuchꞌoꞌoyapitikcha ni anchanu laqa chaqaꞌ u putaulan. Va kꞌachꞌankꞌalapꞌuxkꞌanapitik ni pꞌoqxni la minchꞌajakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Laqsaval klajunau tejkan Dios kalaꞌoxiyaꞌ tachun laqtaqal, ex ni anchanu putaulan apalay ay kunaꞌ ixmaqanlqajnati xajantu yu xaputaulanin Sodoma kun Gomorra. ");
INSERT INTO tptNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Klamalaqachayau taꞌan kꞌaꞌunapitik tacha sasꞌatꞌan borregos taꞌan alin maqtalin. Ayaj listuj kꞌunapitik tacha ni tsapul, pero vachu kꞌunapitik tacha tukunuꞌ yu jantu lakatsꞌajmanan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ayaj kꞌalhistꞌakkꞌanapitik. Yu lapanakni katamaqxtaqniyan ni jalhachimoꞌonun, vachuꞌ katalaqanaqmayan laqa chaqan taꞌan tataqxtoꞌa ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Katamalakanuniyan jalhachimoꞌonun va por kilapanakni untꞌatꞌik. Ex chuncha laycha kilalhichivinau ni kitꞌin kun yuꞌuncha y vachu kun yu jantu israelitas kataval. ");
INSERT INTO tptNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero mas katamaqxtaꞌan kun jalhachimoꞌonun jantu katapastakꞌun yu kꞌanaunapitik u yu tacha kꞌanauntꞌik. Tejkan kachꞌivinapitik Dios kataxtaqniyan yu jatapastakꞌati ni chivinti yu kꞌanaunapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jantu va uxiknankꞌan kachꞌivinapitik, yu kachivinaꞌ va ixꞌEspíritu ni mimPaykꞌan yu tatꞌaꞌalintan uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ex lati lapanakni katamaqxtaqyaꞌ ixtꞌalaqauninkꞌan para kalaqmaqnikal. Vachu yu japayan katamaqxtaqyaꞌ sasꞌatꞌankꞌan. Vachuꞌ yu sasꞌatꞌan kataxkayyaꞌ ixpayankꞌan, katamaqniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tachun ni lapanakni katalhixkayyan por kilapanakni untꞌatꞌik, pero yu vas kataylhaꞌanaꞌ la ixlhakapuꞌati, yucha kalaqtaxtuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chavay taun putaulan incha jantu ox katalaqtsꞌinan, kaꞌospꞌinapitik yu alakataun putaulan. Vas klajunau, tejkan jantukaꞌ kꞌamakꞌaꞌotꞌik ni xaputaulanin ni israelitas, va kachinaꞌ yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Jantu matichun yu malanikanta apalay ay xajantu yu jamalaniy, vachu jantu matichun oqxtamati apalay ay xajantu xaꞌukxtin. ");
INSERT INTO tptNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yu malanikanta oxamaktauncha kaval incha chaꞌantacha laniniꞌ tacha ixjamalaniniꞌ. Yu oqxtamati vachu oxamaktauncha kaval incha chaꞌantacha mispanaꞌ tacha ixꞌukxtin. Chavay incha yu xaꞌukxtin ni laqa chaqaꞌ va kajunkal yu aqmoqxnuꞌ Beelzebú, ¿ex tas kalakjunkanaꞌ yu ixlapanakni? ");
INSERT INTO tptNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Jantu maqskꞌiniy matichun lapanaki katꞌalhaunitꞌik. Tachun yu chavay aqxtaqmanti kamispakanaꞌ y tachun yu makakan laqatamaqsaq, kamispakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yu tacha klajunau chavay taꞌan putsꞌista, ni uxiknan kalakꞌunitꞌik laka julchan. Yu iklamasuniyau laqatamaqsaq, yucha katꞌaukꞌatꞌik la ixꞌaqstꞌiꞌ ni chaqan tus pꞌas kꞌanaunatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jantu kalaktꞌalhaunitꞌik yu lay tamaqniy vamun milakatunajkꞌan pero yu milhitsukunukꞌan jantu lay tamaqniy. Apalay ox katꞌalhaunitꞌik yu lay maqniy milakatunajkꞌan y vachu milhitsukunukꞌan lay malaqachay ni laqnin. ");
INSERT INTO tptNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Laꞌatꞌuy tsꞌoꞌon yucha stꞌakan por taun tsꞌuniy tumin pero mas yucha jantu lay patajuy lakatꞌun incha jantukaꞌ najun mimPaykꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mas miꞌajikꞌan yu alin la miꞌaqtsulkꞌan tus taputeꞌeniꞌotan ni maqatamin por maqatamin. ");
INSERT INTO tptNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Xlhiyucha jantu maqskꞌiniy katꞌalhanantꞌik. Uxiknankꞌan apalay xtapal untꞌatꞌik xajantu lhuvajcha tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Incha qayntaun najun la ixtalakaꞌukxpukꞌan ni lapanakni ni va kilapanaki junita, ex kitꞌin vachuꞌ kajkunaꞌ ni kimPay yu alintachal laktꞌiyan ni va kilapanaki junita. ");
INSERT INTO tptNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero incha najun la ixtalakaꞌukxpukꞌan ni lapanakni ni jantu kilapanaki junita, ex kitꞌin vachuꞌ kajkunaꞌ ni kimPay yu alintachal laktꞌiyan ni jantu kilapanaki junita. ");
INSERT INTO tptNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Jantu kalhakꞌapꞌupꞌintꞌik ni va ikminta ni kitꞌin para oxamaktaun kaval ni lakamunukpaꞌ. Yu kitꞌin klhiminta va lhilukuj ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kitꞌin va kminta para katalaxkayl qayntaun lapanaki kun ixpay, y katalaxkayl yu jatsiꞌi kun ixnati, y katalaxkayl yu japꞌutꞌi kun ixꞌatinaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Chuncha ixtꞌalaxkaynin qayntaun lapanaki katajunaꞌ yu tavilanal la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Chavay yu apalay achaniy ixpay kun ixnati xajantu kiꞌachaniy ni kitꞌin, jantu paxtoqniy kilapanaki kaval. Yu apalay achaniy istsꞌal u istsiꞌi xajantu kiꞌachaniy vachuꞌ jantu paxtoqniy kilapanaki kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chavay yu jantu kintꞌamin mas ayaj maqanlqajnan tacha kalhaꞌal ixkurus, yucha jantu paxtoqniy kilapanaki kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ni lapanaki yu ayaj lhitsukuputun ixjatsukunti, yucha kamaqatsꞌanqayaꞌ. Yu kamaqatsꞌanqayaꞌ ixjatsukunti por kitꞌin yucha kalhitsukuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Taꞌayucha yu katalaqaꞌiyan ni uxiknan va kitꞌin kintalaqaꞌiy. Yu kilaqaꞌiy ni kitꞌin, yucha laqaꞌiy yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yu laqaꞌiy qayntaun yu laqputeꞌey ixchivinti Dios por kꞌatsay va minchal kun Dios, ex ni yucha vachu chun kalaqaꞌiyaꞌ ixlhilhajati tacha laqaꞌiy yu laqputeꞌey ixchivinti Dios. Vachu yu laqaꞌiy qayntaun qalꞌox lapanaki por ox junita, ex ni yucha vachu chun kalaqaꞌiyaꞌ ixlhilhajati tacha laqaꞌiy anchanu qalꞌox lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chavay va taꞌayucha kaval kaxtaqnil mas va taun vaso xkan yu tsukꞌunkꞌu yu aniy lakstꞌuniy tapatsanin, incha va por kintꞌaltanaꞌ junita, ex laqsaval klajunau, ni yucha vachuꞌ kalaqaꞌiyaꞌ ixlhilhajati. ");
INSERT INTO tptNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tejkan jaxaqalaꞌol ni Jesús yu pumakautꞌuy ixtꞌaltanan, ex taxtulcha taꞌan ixvil, va alcha laqputeꞌeniꞌ ixchivinti Dios la xaputaulanin ni anchanu lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ni Juan va ixtanun lakapachꞌin, ex yucha va kꞌatsal yu ixtꞌajun makan ni Jesús. Va chuncha ni Juan va malaqachal lati yu ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Talhisakmil ni Jesús: —¿Laqsaval ni uxintꞌi va Cristo kꞌatꞌi yu ixtanajun kaminaꞌ, u va kakpakxanꞌiu aqayntaun? ");
INSERT INTO tptNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ex ni Jesús va lakjunil: —Kꞌapꞌinchꞌoꞌotꞌikcha y kaꞌunapitik ni Juan yu tacha tꞌaunatꞌik qasmaknan y laqtsꞌinin. ");
INSERT INTO tptNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Talakavananchoqoycha yu laꞌachꞌixin, yu lakchꞌanltꞌul taltananchoqoycha, yu lakapuchꞌinin palaycha tajunchoqoy, yu aqatapan taqasmaknanchoqoycha, yu janinin takujchoqoycha. Vachuꞌ yu kilpatanin jalaqputeꞌenikancha ni ox chivinti yu masuy tacha lay katapulaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ox kaxajtachal ixjatsukunti ni lapanaki yu jantu aqtaun kimakajun. ");
INSERT INTO tptNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tejkan taꞌanchoqolcha yu ixtamalaqachan ni Juan, ex ni Jesús aqtaylcha lhichiviniy ni Juan, va lakjunil ni lapanakni: —Tejkan kꞌilaqtsꞌintꞌik ni Juan lakakꞌavin, ¿tisuncha ixpꞌintꞌatꞌik laqtsꞌinin? ¿Va qaltaun akltiyati yu lajkꞌalhata ni un? ");
INSERT INTO tptNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Suncha kꞌilaqtsꞌintꞌik? ¿Va qayntaun lapanaki yu ayaj kꞌus lakatayal? Ox kꞌatsꞌayatꞌik yu ayaj lajkꞌus talakayanal tavilanal la ixchaqakꞌan yu maqalinin. ");
INSERT INTO tptNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Ex tisuncha kꞌilaqtsꞌintꞌikcha? ¿Va qayntaun yu ixlaqputeꞌey ixchivinti Dios? Laqsaval klajunau chuncha ixjunita pero apalay ay ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ni Juan va yucha yu lhitsꞌoqkanta la ixchivinti Dios taꞌan najun inchine: Kitꞌin kakmalaqachayaꞌ qayntaun yu kapꞌulꞌaniyan, yu kalaꞌoximanin ni lakatin taꞌan kꞌapꞌupꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Laqsaval klajunau ni tachun lapanaki yu maqlaqavanal xanati jantu matichun yu laqputeꞌey ixchivinti Dios apalay ay kaval. Vamun yuꞌ ay ni Juan yu jamaqchajꞌavanaꞌ. Pero yu apalay lakatꞌuniy lapanaki yu Dios lhichimoꞌoy yucha apalay ay xajantu ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Chavay tejkan milcha ni Juan yu jamaqchajꞌavanaꞌ tus chavaycha vananaj jantu ox talaqtsꞌin tacha lhachimoꞌonun Dios, vananaj tapuxkaulaqtsꞌin tas katamakal para katamamaqtanil. ");
INSERT INTO tptNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tachun yu maqancha ixtalaqputeꞌey ixchivinti Dios vachuꞌ ixlhachimoꞌon Moisés ixtanajun yu katapasayaꞌ tus tejkan chil ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chavay ni uxiknan incha laꞌaꞌipꞌutꞌunatꞌik kinchivinti, klajunau ni Juan va yucha ni Elías yu maqancha ixlaqputeꞌey ixchivinti Dios, yu ixtanajun kaminaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Incha alin mimpaqasmakkꞌan, kaꞌasmaktꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tas tajunitacha ni lapanakni yu chavay tatꞌajun? Va tacha sꞌatꞌan yu taqamanan laklhitamau yu talatꞌasaniy, talajuniy: ");
INSERT INTO tptNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Klasqolniu yu maꞌachajunu jasanti, pero jantu kꞌatꞌininatꞌik. Klamilpaniu milpati yu mamaqanixvanan pero jantu kꞌaꞌalhuntꞌik.” ");
INSERT INTO tptNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Va kilachil ni Juan. Yucha jantu ox vajin vachu jantu oqnun. Xlhiyucha tanajun ni lhitꞌajun taun aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ex chuncha kminta kitꞌin yu kval Sasꞌatꞌa Lapanaki, kvajin, kꞌoqnun. Chavaycha tanajun ni kitꞌin javaynꞌoj y puqalꞌoqnuꞌ. Tanajun va klaktꞌatiꞌukxuntayay yu tachꞌinin impuestos ali alati yu tamaqataqalhinin. Pero tachun yu lhixajyachal la ixjatapastakꞌati ni Dios yucha masuy ni va ox ixjatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ex va chuncha taval ni Jesús va aqtayl jalaqꞌaymay xalapanakni yu putaulanin taꞌan jantu katamapaxal ixjatapastakꞌatkꞌan, mas va anchacha kimakal Jesús apalay lhuu yu lajꞌay axtoqnuꞌ. Ex ni Jesús va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Payniꞌincha ni uxiknan yu vilanantꞌik laka putaulan Corazín! ¡Vachu ni uxiknan laka putaulan Betsaida! Ni maqtaqalhinin lapanakni yu maqancha ixtavilanal laka putaulanin Tiro kun Sidón jantu katalaqtsꞌil yu chavay klamasuniu. Incha ixtalaqtsꞌil, ex va niman ixtamakaul ixtalaqalhinkꞌan. Ixtaꞌulalcha ixkujukꞌan yu pumaqanininkꞌan y ixjalaklkꞌakꞌalakalcha para katasul ni talhimaqaninin. ");
INSERT INTO tptNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Laqsaval klajunau tejkan kamukꞌanikanaꞌ ixmaqanlqajnatkꞌan ni lapanakni ex ni uxiknan apalay ay kunaꞌ mimaqanlqajnatkꞌan xajantu yu xalapanakni ni Tiro kun Sidón. ");
INSERT INTO tptNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chavay uxiknan xalapanakni Kapernaum, ¿lhakꞌapꞌupꞌinatꞌikcha ni kapꞌinapitik laktꞌiyan? Yu uxiknan kꞌatꞌanꞌalhukꞌanapitik laqnin. Va xakmakal laka putaulan Sodoma yu lajꞌay axtoqnuꞌ yu tacha ikmakal la mimputaulankꞌan, ex ni anchanu putaulan Sodoma tus chavaycha ka vananaj ixꞌalil. ");
INSERT INTO tptNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Laqsaval iklajunau, ni anchanu julchan tejkan kaꞌalinaꞌ maqanlqajnati, ni uxiknan apalay ay kunaꞌ mimaqanlqajnatkꞌan xajantu xalapanakni laka putaulan Sodoma. ");
INSERT INTO tptNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ex va chuncha ni anchanu julchan ni Jesús naul: —KimPay kꞌatꞌi, xajalhachimoꞌonuꞌ kꞌatꞌi laktꞌiyan kun lakamunukpaꞌ, kitꞌin ktoꞌoyayan. Va lakmalanitꞌa minchivinti ni lakstꞌuniy lapanakni y jamaqsaqnitꞌa yu talakpastaknan, yu lhuu ixtalanitkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chun, kimPay kꞌatꞌi, va chuncha jalakmapꞌaynipꞌutꞌun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Ni kimPay va tachun kimaqxtaqniꞌojota. Jantu matichun kimispay taꞌayucha ni kitꞌin yu sasꞌatꞌa, vamun kimPay kimispay. Vachu va chun jantu matichun mispay taꞌayucha ni kimPay, vamun ni kitꞌin, vachu ni lapanakni yu klakmasuniputun. ");
INSERT INTO tptNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chavay kꞌatꞌantꞌikcha kun kitꞌin tachun ni uxiknan yu laꞌalhoꞌontꞌatꞌikcha istsꞌinkꞌixtu milhitapatsakꞌan yu makꞌayatꞌik. Kitꞌin kaklamastakniyau. ");
INSERT INTO tptNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kalaꞌaꞌitꞌikcha ni ox putsuku yu klaxtaqniyau. Kilalaqtsꞌiu ni kitꞌin la ox lapanaki ijkunita y kilpataniꞌ ijkꞌatsan la kelhanuti, ex chuncha lay kastaknanaꞌ metsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ni putsuku yu klalhijunau kꞌalhipꞌintꞌik yucha jantu tsꞌinkꞌi, va xapau junita para kꞌalhipꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ex chuncha taun xajulchan jastaknati ixjunita, ni Jesús kun ixtꞌaltanan yu ixlakmalaniy va ixtapuꞌanta taꞌan ixchꞌankanta trigo. Yuꞌuncha va ayaj ixtachavanita, taꞌaqtayl talajꞌexꞌiy yu xataltsꞌi ni trigo, va taxapꞌiꞌulhaꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tejkan yu fariseos talaqtsꞌil yu tamakal, ex tajunil ni Jesús: —Yu mintꞌaltanan tatꞌajun makanan taun tuꞌuchun yu jantu maqskꞌiniy kamakꞌatꞌi tejkan xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ex ni Jesús va lakjunil: —¿Ex ni uxiknankꞌan jantu aqtaun pꞌutꞌeꞌeyatꞌik yu tacha makal ni David kun ixtꞌaltanan taun julchan tejkan ayaj tachavanil? ");
INSERT INTO tptNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yucha tanul la ixchaqa ni Dios ex taꞌul ni pan yu moqslanikantacha ni Dios mas jantu ixtapaxtoqniy kataꞌul, vamun ni kuras ixtapaxtoqniy kataꞌul. ");
INSERT INTO tptNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Jantukaꞌ pꞌutꞌeꞌeyatꞌik ixlhachimoꞌon ni Moisés taꞌan najun xtaqkan lakatin ni kuras para katatapatsal laka ay lakatajtan mas va xajulchan jastaknati? Y jantu matichun najun ni va tamakay jatalaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero kitꞌin klajunau ni aniy alin taun tuꞌuchun apalay ay xajantu yu ay lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ka jantu malaꞌasiyatꞌik tis va suncha naunputun ixchivinti Dios yu tsꞌoqkanta, yu inchine najun: “Kitꞌin va knajun kꞌapaxkꞌanantꞌik. Jantu knajun kꞌamoqslatꞌik lapaxkan.” Va ixmalaꞌasitꞌik yu klajunau, ex ka jantu ixlakmukꞌanitꞌik laqtaqal yu kintꞌaltanan yu laqsaval vas tajunita la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ni kitꞌin yu kval Sasꞌatꞌa Lapanaki klhinajun tisuncha lay makakan ni xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ex taxtulcha ni Jesús, va al laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas, ancha tanuchal. ");
INSERT INTO tptNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ancha ixꞌalinta qayntaun lapanaki yu jantu lay ixmapuꞌay ixmakaꞌ. Lati ni fariseos vachu ancha ixtaꞌalinta, yuꞌuncha va ixtatꞌajuncha lakxkaunan tacha kataputislajmal ni Jesús. Va chuncha talhisakmil ni Jesús, va tajunil: —¿Xtaqkan lakatin para palay kꞌamakꞌachꞌoꞌo qayntaun taqanꞌan tejkan xajulchan jastaknati? ");
INSERT INTO tptNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ex ni Jesús va lakjunil: —Xaqayntaun ni uxiknan, va kalhitsꞌukꞌu laqataun borrego y katajul lakxkan, ¿jantu niman kapꞌiti makutunuꞌ mas va xajulchan jastaknati? ");
INSERT INTO tptNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Qayntaun joꞌati apalay ixtapal junita xajantu laqataun borrego. Ex chuncha alin lakatin para kamakꞌatꞌi yu lajꞌox tejkan xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ex ni Jesús va junil ni anchanu taqanꞌan: —Kꞌaxnujtꞌi mimakaꞌ. Chuncha va xnujlhi, va oxicha junchoqol tacha yu amaqataun. ");
INSERT INTO tptNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ex chuncha ni fariseos taꞌanchoqol, va taꞌaqtaylcha tapuxkaulaqtsꞌin tas lay katapumaqnil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tejkan chuncha kꞌatsal ni Jesús, ex taxtul taꞌan ixvil. Lhuvaj lapanakni tatꞌaꞌal. Ni Jesús lajkꞌuchꞌuꞌol ni taqanꞌanin, ");
INSERT INTO tptNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","pero ixlakchivijvay para jantu katalhitaulal ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Va chuncha taqayntsal ixchivinti Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios, yu inchine naul: ");
INSERT INTO tptNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Aniy alinta kiꞌoqxtamati yu klaksakta. Ikpaxkay kun tachun kilhitsukunuꞌ. Kakxtaqniyaꞌ kiꞌEspíritu ni yucha. Ex yucha kalakmasuniyaꞌ tapuchux lapanakni ni lakamunukpaꞌ ni alin ixlaqtaqalkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yucha jantu kakiltaukꞌayaꞌ, jantu pꞌasni katꞌasayaꞌ. Tus jantu matichun kaqasmakniyaꞌ ixtꞌasati lakatinixnan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ni yucha jantu kateꞌeyaꞌ mas maqataun makatꞌuniy kꞌiu yu lkꞌavil. Yucha jantu kamamixiyaꞌ mas va laqataun mecha yu va tsꞌuniy maqtꞌayjiy. Tus tejkan pꞌasni y vas kunaꞌ ixlhachimoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tus tapuchux lapanakni ni lakamunukpaꞌ katapakxanꞌiyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ex va chuncha talhaanil ni Jesús qayntaun joꞌati yu laꞌachꞌix y janunuꞌ. Va ixlhitꞌajun aqmoqxnuꞌ. Ni Jesús va malakavanichoqol y machivinichoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tus tachun ni lapanakni tus vak takꞌatsal, va talalhisakmil: —¿Lhilay ni Jesús va istsꞌal David junita? ");
INSERT INTO tptNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tejkan chuncha taqasmaklhi ni fariseos, va tanaul: —Va Beelzebú, yu xaꞌukxtin aqmoqxnuꞌ yu xtaqniy tapꞌasta para lay kalakmaxtul aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ni Jesús ixkꞌatsꞌaycha yu ixtatꞌajun pastaknan, va lakjunil: —Mas va tisuncha lhachimoꞌon incha va tatalaqlvaꞌa y talaxkajiy ni lapanakni, ex xꞌamankꞌan tatalaktꞌilhiy. Vachu incha taun putaulan u tꞌalaqaunin tatalvaqta, ex jantu lay maqan tatsukuy va talamamiꞌoniy. ");
INSERT INTO tptNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Vachu chun incha xꞌaman kamaxtuchoqokal ni Satanás, ¿ex tas kaputaqnilcha ixtapꞌasta? ");
INSERT INTO tptNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Naunatꞌik va klakmaxtuy aqmoqxnun kun ixtapꞌasta Beelzebú yu xaꞌukxtin ni aqmoqxnun. ¿Ex tas ayucha jaxtaqniycha tapꞌasta mintꞌaltanankꞌan para katalakmaxtul aqmoqxnun? Mintꞌaltanankꞌan va tamasuchoqoy ni uxiknan va alꞌoqspꞌalatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yu kitꞌin klakmaxtuy aqmoqxnun va kun ixtapꞌasta ni ixꞌEspíritu Dios. Yucha naunputun yu ixlhachimoꞌon ni Dios va talaqchintancha ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Tas kapulalcha matichun katanuchal la ixchaqaꞌ qayntaun lapanaki yu pꞌasni para kamaxtunil ixꞌaxtoqnuꞌ incha jantu pꞌunaj kachꞌiꞌulaꞌelal? ");
INSERT INTO tptNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Yu jantu chꞌantaun kintꞌaval, yucha va kixkajiy. Yu jantu jalaqmaqxtoꞌa lapanakni para kintatꞌaꞌal, yucha va jalakmaputaukꞌay. ");
INSERT INTO tptNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Xlhiyucha klajunau, tachun talaqalhin yu tamakay ni lapanakni lay malaqmixiniꞌokan, mas va tuꞌuchun yu jantu ox kanaul, yucha lay malaqmixiniꞌokan. Pero yu va kalaktuꞌul ni Espíritu Santo ex ni yucha jantu lay malaqmixinikan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chavay yu kinkiltaukꞌaniy ni kitꞌin yu Sasꞌatꞌa Lapanaki, yucha lay kamalaqmixinikanaꞌ. Pero incha jantu oxi lhichiviniy ni Espíritu Santo, ex ni yucha jantu lay kamalaqmixinikanaꞌ, mas ni aniy lakamunukpaꞌ, mas yu kaꞌalinakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Yu ox kꞌiu xtaꞌa ox xaꞌunikan, yu jantu ox kꞌiu yucha jantu lajꞌox xaꞌunikan. Ex chuncha va por xaꞌunikan va yucha pumispakan ni kꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ixlapanakni tsapulin untꞌatꞌik! ¿Tas kapulayacha kꞌanaunapitik yu lajꞌox axtoqnuꞌ incha va laktuꞌunun untꞌatꞌik? Yu naunatꞌik la minkilkꞌan yucha minachal la melhanutkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yu ox lapanaki, la ixjalhanuti maꞌata yu lajꞌoxi, ancha maxtuy yu lajꞌoxi chivinti. Yu laktuꞌunuꞌ lapanaki la ixjalhanuti maꞌata yu jantu lajꞌoxi kaval, ancha maxtuy chivinti yu jantu lajꞌox. ");
INSERT INTO tptNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero yu kitꞌin klajunau, tejkan kachina julchan tejkan kalakmukꞌanikanaꞌ ixlaqtaqalkꞌan ni lapanakni, ex kataxtaqꞌoyaꞌ kuenta tachun laqxtoqnuꞌ chivinti yu tanajunta. ");
INSERT INTO tptNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Va por minchivinti katasuyaꞌ incha va ox unitꞌa u incha va lhitꞌaꞌun laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Va chuncha taval ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan va talaqltalakatanul ni Jesús, va tajunil: —Jamalaniniꞌ, kijnan klalaqtsꞌinputunau kamakꞌatꞌi taun ay axtoqnuꞌ yu lay klapumispau. ");
INSERT INTO tptNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ex ni Jesús va lakjunil: —Yu jalaktuꞌunun ali maqtaqalhinin lapanakni kintaskꞌinin para kaklakmakanil taun ay axtoqnuꞌ yu lay kintapumispal. Pero jantucha apalay tuꞌuchun kaklakmasuniyaꞌ, vamun yuꞌ yu tacha tapasal ni Jonás yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yu Jonás ixtajumachal laꞌatꞌutu julchan kun laꞌatꞌutu jatatsꞌisin la ixpulakna laqataun ay jatanti. Ex yu Sasꞌatꞌa Lapanaki vachu chun katapasayaꞌ, yucha katajuyaꞌ laꞌatꞌutu julchan kun laꞌatꞌutu tatsꞌisin la ixpulakna ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tejkan kachinaꞌ ni julchan tejkan kalakmukꞌanikanaꞌ ixlaqtaqalkꞌan ni lapanakni, katatayayaꞌ ni lapanakni yu maqancha machaqan Nínive. Katamukꞌayaꞌ laqtaqal, kalakmukꞌanikana ixlaqtaqalkꞌan yu chavay tatꞌajun lapanakni. Yu maqancha ixtavilanal lakaputaulan Nínive va tamakaul ixtalaqalhinkꞌan tejkan taqasmaknil ixchivinti Jonás. Pero chavay aniy alin qayntaun yu apalay pꞌas xajantu ni Jonás. ");
INSERT INTO tptNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vachu tejkan kalakmukꞌanikanaꞌ ixlaqtaqalkꞌan ni lapanakni, ni xanati yu ixlhachimoꞌonun maqancha ixlhisur ni lakamunukpaꞌ, va ancha katayayaꞌ y kalaktislajmayaꞌ ni lapanakni yu chavay tatꞌajun. Yucha la maqati minchal para kaqasmaknil ixchivinti Salomón yu ayaj lhuu ixjatapastakꞌati. Pero chavay aniy alin qayntaun yu apalay lhuu jatapastakꞌati lhitꞌajun xajantu Salomón. ");
INSERT INTO tptNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tejkan taun jantu ox espíritu taxtuniy qayntaun lapanaki, ex tiꞌukxuntayay mas taꞌan jaxixninta taꞌan jantu tuꞌuchun alin, lakxkajuycha toꞌoxtaycha kastaknal. Tejkan jantucha temay toꞌoxtaychacha kastaknal, va pastakchoqoy: ");
INSERT INTO tptNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Kajkꞌanchoqoyacha laqa chaqaꞌ taꞌan ikmintachal.” Tejkan chinchoqoy la ixlakatunaj ni lapanaki va tacha taun chaqaꞌ yu tus ox japꞌalnankanta y ox jalaꞌoxikanta. ");
INSERT INTO tptNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ex taxtuchoqoy y lhiminchoqoy pumatujun ixtꞌaꞌespíritus yu apalay talaktuꞌunun. Tus tachun chꞌantaun tatanuy la ixlakatunaj ni anchanu lapanaki. Ex ni anchanu lapanaki va apalay lhitaꞌay jun la ixjatsukunti xajantu tacha ixjunita pꞌunaj. Vachu va chun kꞌatꞌapꞌasayapitik yu chavaycha jalaktuꞌunun lapanakni untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tejkan vananaj ixtꞌajun jalaqxaqalanaꞌ ni lapanakni ni Jesús, ex tachinchal yu ixnati kun ixtꞌalaqaunin, va ixtatꞌachivinputun ni Jesús pero va maqspaꞌ ixtayanal. ");
INSERT INTO tptNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ex qayntaun lapanaki va junil ni Jesús: —Yu minati kun mintꞌalaqaunin tayanal maqspaꞌ. Va tatꞌachivinputunan. ");
INSERT INTO tptNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ex ni Jesús va naul: —¿Tas ayucha ni kinati y tas ayuꞌuncha ni ketꞌalaqaunin? ");
INSERT INTO tptNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ex va jalakmajkunil yu ixtꞌaltanan, va naul: —Ni yu aniy taꞌalinta, yuꞌuncha ni kinati ali ketꞌalaqaunin. ");
INSERT INTO tptNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Chavay mas va taꞌayucha yu makay tacha lhinajun kimPay yu alintachal ni laktꞌiyan, ex yucha kintꞌalaqajun y yucha kintꞌalapanaki y yucha kinati. ");
INSERT INTO tptNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Anchanu julchan taxtuchal laqa chaqaꞌ ni Jesús va al taul taꞌan ixkilpaꞌ ni lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Va lhuvaj lapanakni tataqxtoqniy, ex ni yucha va tajul laka barco, va ancha taulal. Ex ni lapanakni va tataulal la ixkilpaꞌ ni lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Chuncha va aqtaynilcha jalakmasuniy pulhuvaj axtoqnuꞌ kun chivinti yu xtaꞌa jatapastakꞌati. Va jalakjunil: —Qayntaun lapanaki al mamanaꞌ ni ixtꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tejkan ixtꞌajun maman ni ixtꞌin lakataun tamachal va lakatin, ex ancha tamil tsꞌoꞌon va niman taꞌuꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yu alati xatꞌin va tamachal laka chiyuxin. Ancha va snipaqa mal yu tꞌun, xlhiyucha va niman pꞌunlhi. ");
INSERT INTO tptNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jantu pulman kataknul istsꞌansiviti, xlhiyucha tejkan pꞌas maknaul ni julchan va lakxixꞌol, talaqxauꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Alati xatꞌin tamachal laka jaltukunan. Ancha vachu pꞌunlhi pero chꞌantaun tꞌapꞌul ni jaltukun, va maqataanul, talakxixtanulcha yu xatꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Chavay yu alati tꞌin, yucha tatamachal taꞌan ox ni lakatꞌun, ex ancha va xtaqlhi taun ox jaxqanti. Por laqatamin ni xatꞌin, lati taxtaqlhi taun ciento xataltsꞌi, lati xtaqlhi setenta y lati treinta taxtaqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Incha alin mimpaqasmakkꞌan, ex kaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ex yu ixtꞌaltanan ni Jesús yu ixlakmalaniy va tatalakanunil ni Jesús, va tajunil: —¿Valiꞌiycha jalaqlhixaꞌalaycha ni lapanakni kun chivinti yu xtaꞌa jatapastakꞌati? ");
INSERT INTO tptNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ex ni Jesús va lakjunil: —Uxiknankꞌan Dios tamasuniyan tacha lhachimoꞌonun laktꞌiyan yu jantu takꞌatsay alati lapanakni. Jantu jamasuniy yu alati lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yu lhitꞌajuncha yucha apalay lhuu kaxtaqnikanaꞌ para apalay lhuu kalhitsukul. Yu jantu kalhitsukul mas yu tsꞌuniy yu lhitꞌajun, yucha kamaxtunichoqokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xlhiyucha klhilaqxaqalay ni lapanakni kun chivinti yu xtaꞌa jatapastakꞌati. Ni yuꞌuncha talaqtsꞌincha pero va tacha jantu katalaqtsꞌil, ex va tacha jantu kataqasmaklhi. ");
INSERT INTO tptNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ex laqsaval lhiꞌakxajyachal ni yuꞌuncha tacha naul ni Isaías yu maqancha ixputeꞌey ixchivinti Dios, va naul: Ni uxiknan laqsaval kaꞌasmatꞌapitik pero jantu kamalaꞌasiyapitik; kꞌalaqtsꞌinapitikcha pero va tacha jantu kalaqtsꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yu ixjalhanutikꞌan ni aniy lapanakni va ayaj pꞌasni tamakata. Tus jantu ox taqasmaknan. Ixlaqchulkꞌan talhitꞌajun pero tus ox lakchajuy. Chuncha jantu lay talakavanan, jantu lay taqasmaknan, jantu lay tamalaqasinin, jantu chꞌantaun kintatꞌaꞌan para kaklakmaꞌayajnil. ");
INSERT INTO tptNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero ni uxiknankꞌan, kaꞌachꞌantꞌikcha, va pꞌalakꞌavanantꞌikcha milaqchulkꞌan y paꞌasmaknanantꞌikcha miꞌaqaxqolkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Laqsaval klajunau, maqancha qaynlhuvaj lapanakni yu lajꞌoxin kun qaynlhuvaj yu maqancha ixtalaqputeꞌey ixchivinti Dios ayaj ixtalaqtsꞌinputun tacha yu chavay laqtsꞌinatꞌik, pero yuꞌuncha jantu katalaqtsꞌil. Ayaj ixtaqasmakputun vachu yu tacha uxiknan asmaktꞌatꞌik, pero jantu kataqasmaklhi. ");
INSERT INTO tptNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Chavay ox kaꞌasmaktꞌik yu naunputun ni chivinti yu lhichiviniy ni lapanaki yu ixmamay ni ixtꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Qayntaun lapanaki tejkan qasmatꞌacha tacha lhachimoꞌonun Dios pero jantu malaqasiy, yucha va tacha xatꞌin yu tamachal lakatin. Taval laqtanul yu jantu ox, ex chuncha ni anchanu lapanaki va makaunchoqolcha ixchivinti Dios yu ixꞌalintacha la ixjalhanuti. ");
INSERT INTO tptNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chavay yu xatꞌin yu tamachal laka chiyuxin, yucha va yu taqasmatꞌacha ixchivinti Dios ex talaqaꞌiy kun achati. ");
INSERT INTO tptNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero jantukaꞌ ox tatꞌachꞌatay, ex vamun taun panchꞌix tayaniy. Tejkan lhitapasay maqanlqajnati, por ni chivinti yu lhakapuꞌan, ex makaunchoqoycha ixlhakapuꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chavay yu xatꞌin yu tamachal laka ltukunan, yucha va ni lapanakni yu taqasmatꞌacha ixchivinti Dios, pero vananaj ayaj tapastakꞌuy yu xajamaqaliti ni aniy lakamunukpaꞌ. Chuncha takaukchoqoy ixchivinti Dios y jantu aqtaun lay lhixajachal yu lajꞌoxi la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Chavay yu xatꞌin yu tamachal taꞌan ox lakatꞌun yucha va ni lapanakni yu taqasmatꞌa y ox tamalaqasiy, ex chuncha yuꞌuncha lhixajyachal taun ox jaxqanti. Lati taxtaꞌa taun ciento xataltsꞌi por qaltaun, alati taxtaꞌa sesenta, alati taxtaꞌa treinta. ");
INSERT INTO tptNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ni Jesús jalaqlhixaqalachoqol ataun chivinti yu xtaꞌa jatapastakꞌati, va naul: —Yu xalhachimoꞌon ni laktꞌiyan va tacha qayntaun lapanaki yu mamal ox xatꞌin la ixtꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Taval tejkan ixtaltataꞌojotacha tachun, ex chil ixtꞌalaxkayakꞌan, va mamal xataltsꞌi javan taꞌan ixmamakanta ni trigo, ex chuncha va anchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Chavay tejkan alilcha ni trigo y tapalalcha xapaꞌati, ex vachuꞌ tasul yu jantu ox javan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ex va chuncha yu tapatsanin va taꞌal mapastakꞌaninin yu manavin, va tajunil: “Jalhachimoꞌonuꞌ, uxintꞌi mamatꞌi yu lajꞌox tꞌin ni lakatꞌun. ¿Tas oxtaycha lhilay minchalcha yu jantu ox javan?” ");
INSERT INTO tptNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ex yu manavin va naul: “Ka va lay matichun kintꞌalaxkayakꞌan chun xamakay.” Ex yu tapatsanin va talhisakmil ni manavin, va tajunil: “¿Lhinaꞌun ni kajkꞌau tipatꞌanan yu jantu lajꞌox javan?” ");
INSERT INTO tptNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ex yu jamanavin va naul: “¡Ka jantu! Yu va katꞌipꞌatꞌatꞌik yu jantu ox javan kavalay vachu katꞌipꞌatꞌatꞌik ni trigo. ");
INSERT INTO tptNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Apalay ox kamakaunau para chꞌantaun katalajꞌaynlhi tus tejkan kapuꞌiyaucha. Ex kakmalaqachayaꞌ kataꞌanaꞌ puꞌinin ni javan. Katapꞌixchꞌiyaꞌ por pastamin para kalaqxavakalcha, ex astan katapuꞌiyacha ni trigo y katamaꞌayacha laka pakꞌatsa.” ");
INSERT INTO tptNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús vachu jalaqputeꞌenil ataun chivinti yu xtaꞌa jatapastakꞌati, va jalakjunil: —Yu xalhachimoꞌon ni laktꞌiyan va tacha xataltsꞌi ni mostasa yu chꞌal la ixtꞌun qayntaun lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yucha laqsaval apalay lakatꞌuniy taltsꞌi xajantu yu alati xataltsꞌi tachꞌanati pero tejkan ajin ex ni yucha apalay ay jun xajantu yu alati jatachꞌanati. Yucha jun aqataun kꞌiu, ex yu tsꞌoꞌon ancha tachinachilcha, tamakaycha ixpaqtamankꞌan la ixmaqlaqapꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ni Jesús vachu jalaqputeꞌenil ataun chivinti yu xtaꞌa jatapastakꞌati va jalakjunil: —Yu xalhachimoꞌon ni laktꞌiyan, yucha va tacha levadura yu qayntaun xanati xꞌotꞌilhiyajuy kun laꞌatꞌutu kualtil harina. Makay tus tachun kalhitayaꞌol ni skititi para la lhuu kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ni Jesús ixlakmasuniy ni lapanakni kun chivinti yu xtaꞌa jatapastakꞌati. Vamun yuꞌ ixlakpumasuniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chuncha laqsaval taqayntsal yu maqancha ixtalaqputeꞌey ixchivinti Dios yu inchine tatsꞌoqlhi: Kaklakmasuniyaꞌ chivinti yu xtaꞌa jatapastakꞌati, kaknaunaꞌ axtoqnuꞌ yu maksakkanta vananaj tus tejkan puꞌaqtaynil ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ex chuncha ni Jesús va lakmastakꞌachoqolcha ni lapanakni, va tanulcha la ixpulakna taun chaqaꞌ. Yu ixtꞌaltanan va tatalakanunil, va tajunil: —Kilalaqputeꞌeniu tisuncha naunputuncha ni chivinti yu lhichiviniy yu jantu ox javan yu tatꞌaꞌaynlhi ni trigo. ");
INSERT INTO tptNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ex va chuncha ni Jesús va jalakjunil: —Yu mamal ni la ox tꞌin, yucha va Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yu lakatꞌun yucha va yu lakamunukpaꞌ. Chavay yu lajꞌox xatꞌin yucha va yu lapanakni yu tatiꞌukxuyanalcha taꞌan lhachimoꞌonun Dios. Yu jantu lajꞌox javan yucha va yu lapanakni yu talhiyanal kun ni aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chavay yu tꞌalaxkayaꞌ yu mamal xatꞌin yu jantu lajꞌox javan, yucha va yu aqmoqxnuꞌ. Yu jaxqanti yucha tejkan xapumiꞌonucha kunaꞌ ni lakamunukpaꞌ. Yu kataminaꞌ japuꞌinin ni jaxqanti yucha va ixmayulnin ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chavay yu jantu lajꞌox javan yucha chaqxꞌikan, mapꞌukan laka jikmi para kalaqxaul, yucha vachu va chun kunaꞌ tejkan kamiꞌoyaꞌ ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yu Sasꞌatꞌa Lapanaki ni yucha kamalaqachayaꞌ ixmayulnin taꞌan jalhachimoꞌonun para kataminaꞌ jaxqanan yu talamakanin talaqalhin kun yu tamakay tachun yu jantu lajꞌox. ");
INSERT INTO tptNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ex ni yuꞌuncha kalaqtanqalhumujukanaꞌ la xaꞌorno ni jikmi taꞌan katalajqalhunaꞌy katalaktsakꞌayaꞌ ixtatsalatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero yu tamakay tacha lhinajun ni Dios, yuꞌuncha tus kꞌaluks katatunkunaꞌ tacha ni julchan taꞌan lhachimoꞌonun ni ixPaykꞌan. Chavay incha alin mimpaqasmakkꞌan, ex kꞌaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Yu xalhachimoꞌon ni laktꞌiyan va tacha taun maqaliti yu kamaqsaqkal taun lakatꞌun. Qayntaun lapanaki temay ni maqaliti ancha lakatꞌun pero va ancha maqsaqchoqoy. Ex ayaj lhiꞌachantajuycha ex minchoqoyachalcha, anꞌojoy stꞌanaꞌ tachun yu maqalin ni ixlhitapatsa. Ex chuncha iycha yu anchanu lakatꞌun yu taꞌan temal ni maqaliti. ");
INSERT INTO tptNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Vachu yu xalhachimoꞌon ni laktꞌiyan, yucha va tacha qayntaun jastꞌanaꞌ yu lakxkajuy ni laqspututu chiyux yu laqlhuu xtapal. ");
INSERT INTO tptNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tejkan temayachalcha mas va laqataun pero la laqlhuu xtapal, ex chuncha ni yucha anchoqoycha, lakstꞌay tachun yu lhitꞌajuncha ex ancha iniꞌ yu anchanu laqspututu chiyux yu laqlhuu xtapal. ");
INSERT INTO tptNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Vachu yu xalhachimoꞌon ni laktꞌiyan va tacha ni chꞌoqxu yu mujukan lakxkan, ex ni yucha chꞌapaꞌojoy tapuchux jatantin. ");
INSERT INTO tptNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tejkan aqtsamancha ni chꞌoqxu ex yu xachꞌapanan tamakutuycha ixchꞌoqxkꞌan, talhaꞌancha la ixkilpaꞌ ni laꞌaxkan. Ex ancha tataulaycha jalaksaknan ni jatanti. Yu lajꞌay tamaꞌaycha la ixqaychꞌikꞌan. Yu jantu lajꞌox ni yucha talakmajꞌancha. ");
INSERT INTO tptNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Vachu chun kunaꞌ tejkan xapumiꞌonuꞌ ni lakamunukpaꞌ. Kataminaꞌ ni ixmayulnin Dios, tumpaj katamakayaꞌ yu lajꞌoxin. Yu jantu lajꞌoxin vachu tumpaj kalakmakakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chavay yu jantu lajꞌoxin, ni yuꞌuncha kalaqtanqalhumujukanaꞌ la xaꞌorno jikmi, taꞌan katalajqalhujtajuyaꞌ y katalaktsakꞌalhitsukuyacha ixtatsalatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ex chuncha ni Jesús va lakjunil: —¿Ni uxiknan malaꞌasiꞌoyatꞌik tachun ni aniy? Ex yuꞌuncha tanaul: —Chun, Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ex chuncha va jalakjunil: —Tejkan qayntaun yu masuy ixlhachimoꞌonkꞌan ni israelitas laniy tacha xajalhachimoꞌon laktꞌiyan, ex yucha jun tacha qayntaun manavin laqataun chaqaꞌ taꞌan maꞌakan ox axtoqnuꞌ. Ex chuncha la ox mispay lakmaxtunuꞌ yu laqsastꞌi y vachu yu maqaniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Taval tejkan mamaktal ni Jesús ixlaqputeꞌeka ni chivinti yu xtaꞌa jatapastakꞌati, ex anchoqolcha, ");
INSERT INTO tptNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","va chaanchoqolcha la ixtꞌun. Ex ancha aqtaynil jamalaninin laqa chaqaꞌ taꞌan ixtataqxtoqta ni israelitas, ex yu lapanakni tus taun talhilal, ixtanajun: —¿Tas oxtaycha lanilcha yu laklaniy? ¿Tas pulakmakaycha ni anchanu lajꞌay axtoqnu? ");
INSERT INTO tptNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Jantu yuꞌ kaval yu istsꞌal ni karpintero, yu ixnati ni María? ¿Jantu yuꞌ kaval ixlaqaj ni Santiago ali José ali Simón ali Judas? ");
INSERT INTO tptNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Jantu yuꞌ ixtꞌalapanakni yu tataulay aniy la kinputaulankꞌan? ¿Tas oxtaycha pulanil anchanu axtoqnuꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Va xlhiyucha jantu ixtamakaniputun kuenta ni Jesús. Pero ni Jesús va lakjunil: —Qayntaun lapanaki yu laqputeꞌey ixchivinti Dios va talakachux toꞌoyakan, vamun la ixtꞌun jantu toꞌoyakan. ");
INSERT INTO tptNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ex ancha la ixputaulan ni Jesús jantu katalhakapuꞌanil ni lapanakni xlhiyucha jantu lhuu kamakal yu lajꞌay axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ex chuncha yu xagobernador ni Galilea, yu ixjunkan Herodes, ni yucha vachu kꞌatsal yu ixtꞌajun makan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ex yucha va lakjunil yu ixtaꞌaqtayjuy: —Ka va Juan yu jamaqchajꞌavanaꞌ ni kujchoqota. Ka xlhiyucha lhitꞌajun tapꞌasta para kamakal yu lajꞌay axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Va yucha ni Herodes yu ixmalaqachananta ixlakachꞌimaka ni Juan, ex va maqanul lakapachꞌin. Va chuncha makal va por ixanati yu Herodías junkan, yu ixanati ixjunita ixlaqaj Felipe. ");
INSERT INTO tptNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yu Juan va ixjunita: —Jantu lay kꞌamakꞌatꞌi mixanati yu ixanati milaqaj. ");
INSERT INTO tptNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ex va chuncha ni Herodes ayaj ixmaqniputun ni Juan, pero va ixlaktalhauniy ni lapanakni. Yuꞌuncha ox ixtalhakapuꞌan ni Juan va ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero tejkan lakachil ixkꞌatan ni Herodes, ex yu istsiꞌi ni Herodías va aqtaynil jatꞌinin la ixtalakaꞌukxpukꞌan yu ixlakjuntaꞌikanta. Ex ayaj maqamal ni Herodes. ");
INSERT INTO tptNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Chuncha yucha va junil ni laqsaval kaxtaqniyaꞌ va tuꞌuchun yu kaskꞌinilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Va chuncha ixnati va chivijval yu jatsiꞌi. Ex yucha va junil ni Herodes: —Va knajun kꞌixtꞌaqnin ixꞌaqtsul ni Juan yu jamaqchajꞌavanaꞌ kun laqataun ay plato. ");
INSERT INTO tptNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ex ni ay jalhachimoꞌonu Herodes va maqaninil, pero va por ixjunitacha la ixtalakaꞌukxpukꞌan ni ixlakjuntaꞌita, ex mas jantu kaꞌuyujnaul, va lhinaul kaxtaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Va malaqachanalcha ixchaqxpꞌuxnika ixꞌaqtsul ni Juan taꞌan ixtanun lakapachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chuncha talhiminil ixꞌaqtsul laqa ay plato ni jatsiꞌi, ex yu jatsiꞌi va maqxtaqnilcha ni ixnati. ");
INSERT INTO tptNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ex tachinchal yu ixtꞌaltanan ni Juan, va talhaꞌalcha maknunun ixlakatunaj. Ex astan va taꞌal mapastakꞌanin ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ex tejkan qasmaklhi ni Jesús yu tapasalcha, va taxtulcha taꞌan ixvil, va ixꞌaman al, tajul laqataun barco va puꞌal lakamar, va chaꞌal lakatꞌun taꞌan jantu alin lapanakni. Pero tejkan chuncha takꞌatsal ni lapanakni ex tataxtul ni putaulanin y tatixkaulhaꞌal pero yuꞌuncha va lakatꞌun tapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tejkan patajul laka barco ni Jesús va jalaqtsꞌil lhuvaj lapanakni. Ex ni yucha va ayaj lakmapaynil, y va jalajkꞌuchꞌul tachun yu taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Taval va putsꞌisputuncha. Ex yu ixtꞌaltanan tatalakanunil, va tajunil: —Ayaj toqoxalcha y aniy va xꞌaman ni lakatꞌun, jantu tꞌujuꞌ jataulanti. Kalakmakꞌaucha ni lapanakni para kataꞌalcha lakxkaunan ixvaytikꞌan taꞌan alin jataulanti. ");
INSERT INTO tptNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ni Jesús va lakjunil: —Jantu maqskꞌiniy kataꞌal lakxkaunan. Ni uxiknan kꞌalakvavatꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ex ni yuꞌuncha va tanaul: —Pero jantu lhuu kaklhimiu ni vayti. Va ikmaqalinau aniy va aqskis pan kun aqxtꞌuy jatanti. ");
INSERT INTO tptNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ex ni Jesús va naul: —Kilalhiminiu aniy. ");
INSERT INTO tptNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ex va lakjunil ni lapanakni para katataulal ni laka jatsꞌinan. Ex chuncha va chꞌapalcha la ixmakaꞌ ni anchanu aqskis pan kun aqxtꞌuy jatanti, ex va talaqstꞌal laktꞌiyan, va xtaqnil lhimalaqpuchuncha ni Dios. Ex va laqcheꞌelcha ni pan, va jalaqxtaqnilcha ixtꞌaltanan. Ex yuꞌuncha va taꞌaqtaynilcha talaqmapitsiniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ex tus tachun ox tavayl y tus ox taꞌotsaꞌol. Vananaj tamaꞌaqtsamachoqol laqakautꞌuy canastas yu xatalaqcheꞌeniꞌ yu xajchal. ");
INSERT INTO tptNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yu tavayl va laqakis mil joꞌakna y tumpaj yu xanatin kun jasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ex va chuncha ni Jesús va niman lakjunil ixtꞌaltanan para katatajuchoqolcha ni laka barco. Pꞌunaj kataminchoqochalcha apaꞌextaun lakxkan. Yu Jesús vananaj tamakaul jalakmastakꞌanaꞌ ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tejkan lakmastakꞌaꞌolcha ex ni Jesús va al skꞌiniꞌ Dios ixꞌaman lakataun aspajun. Taval tejkan putsꞌislhicha ex ni yucha va ancha ixꞌaman ixꞌalinta. ");
INSERT INTO tptNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ex va chuncha ni barco va la maqati anta, va laycha ixpakltaun lakamar. Va ixꞌunilata la ixꞌukxpulakapu ni barco, yu xkan ixtantꞌaqstꞌay y vachu ixqalnaqlhaꞌanta ni barco. ");
INSERT INTO tptNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ex va chuncha tejkan tunkumintacha, ni Jesús va ltanajꞌal la ixꞌukxni lakamar, va taꞌan ixtapuꞌanta yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tejkan chuncha talaqtsꞌil yu ixtꞌaltanan ni Jesús va ltanajꞌanta ni yucha la ixꞌukxni lakamar, tus pꞌas talaktꞌasal kun ixtalhantikꞌan: —¡Va qayntaun maqtsꞌisvanaꞌ! ");
INSERT INTO tptNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ni Jesús jalakkilꞌanil, va jalakjunil: —¡Kaꞌayajnantꞌik! Jantu maqskꞌiniy katꞌalhanantꞌik, va kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ex yu Pedro va naul: —Jalhachimoꞌonuꞌ, incha laqsaval va uxintꞌi, ex kꞌiꞌun para kakltanajꞌanchal la ixꞌukxni ni lakxkan. ");
INSERT INTO tptNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ex naul ni Jesús: —Kꞌatꞌatꞌicha. Ex ni Pedro va takuklhicha laka barco, va ltanajꞌalcha ni lakxkan taꞌan ixpuminta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Yu un va la pꞌasnicha talakanuniy, ex ni Pedro va talhanalcha, ex va aqtaylcha talaqtsꞌanqay, va tus sqau tꞌasal, va naul: —¡Jalhachimoꞌonu, kꞌiꞌaqtꞌayꞌutꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ni Jesús va tsꞌalaj maqchꞌapachoqol, va junil: —Ayaj lakatsꞌuniy milhakapuꞌati. ¿Valiꞌiycha jantu kꞌalhakꞌapꞌupꞌi? ");
INSERT INTO tptNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tejkan tataukꞌachoqolcha laka barco ni Jesús kun Pedro, ex yu un va vak junchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ex yu ixtatꞌajumanal laka barco va tataꞌaqtsoqoqtanil ni Jesús, va tajunil: —Laqsaval ni uxintꞌi va Sasꞌatꞌa kꞌatꞌi ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Va chuncha va tapatakuklhi ni lakamar, ex tachaꞌal xalakatꞌun Genesaret. ");
INSERT INTO tptNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Yu xalapanakni ni anchanu putaulan va tamispalcha ni Jesús, ex tus tamapastakꞌanininꞌol talakachux xaputaulanin ni anchanu jalakatꞌun. Ex ni yuꞌuncha va talhiminil tachun ixtaqanꞌaninkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ixtatapayniniy ni Jesús para lay katachꞌapanil vamun ixpiktuꞌ ni ixlaqchꞌiti. Ex tachun yu tachꞌapanil va si taꞌayajnanꞌochoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Va chuncha lati ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan taminchal ni Jerusalén. Va tatalakanunil ni Jesús, ex talhisakmil, va tajunil: ");
INSERT INTO tptNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Valiꞌiycha ni mintꞌaltanan ayaj taꞌakchꞌintamay yu ixputsukukꞌan yu maqaniyaꞌ kepayankꞌan? Jantu tamaqchaꞌay tejkan tavajin tacha lhinaunkan. ");
INSERT INTO tptNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ex ni Jesús jalakjunil: —Yu uxiknan ¿valiꞌiycha akchꞌintꞌamayatꞌik yu lhinajun ni Dios para katꞌaylhipꞌintꞌik mimputsukkꞌan? ");
INSERT INTO tptNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ni Dios naul: “Katꞌoꞌoyatꞌi ni mimpay ali minati.” Vachu va naul: “Yu jantu ox lhichiviniy ixpay ali ixnati yucha maqskꞌiniy kanil.” ");
INSERT INTO tptNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero yu uxiknankꞌan naunatꞌik ni qayntaun lapanaki lay kajunil ixpay ali ixnati: “Ka jantu lay klaꞌaqtayjuyau, tachun yu klhitꞌajun va ikmaqxtaqnitacha ni Dios.” Ex uxiknan naunatꞌik va ox tacha makay anchanu lapanaki ");
INSERT INTO tptNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","y naunatꞌik jantucha maqskꞌiniy kaꞌaqtayjul ixpay kun ixnati. Ex makꞌayatꞌik tacha jantu ixtapal kaval yu lhinajun ni Dios, vamun tꞌaylhipꞌinatꞌik mimputsukkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ni uxiknankꞌan va tꞌuy ukxpuꞌ makꞌayatꞌik. Ni Isaías yu ixlaqputeꞌey ixchivinti Dios, yucha vas ixnajun tejkan naul: ");
INSERT INTO tptNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ni aniy lapanakni vamun kun ixkilkꞌan kintatoꞌoyay. Yu ixjalhanutkꞌan va ayaj maqati alinta kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chavay mas ayaj kintatoꞌoyay jantu tuꞌuchun ixtapal kaval, jantu laqsaval yu tamalaniy, va ixjatapastakꞌatkꞌan lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ex ni Jesús lakjuntaꞌil ni lapanakni va lakjunil: —Tus ox kaꞌasmaktꞌik y kamalaꞌasitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Chavay yu talakꞌuy ni lapanakni jantu yuꞌ xkilivay. Yu xkilivay ni lapanakni va yu takiltaxtuy yu jantu ox chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Va chuncha yu ixtꞌaltanan va tatalakanunil ni Jesús, va talhisakmil: —¿Kꞌatsꞌaycha ni fariseos jantu katalhipaꞌinil tejkan chuncha nau? ");
INSERT INTO tptNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ex ni yucha lakjunil: —Mas va taꞌayucha jatachꞌanati kaval yu jantu kachꞌal ni kimPay yu vilchal laktꞌiyan, yucha va katꞌipatꞌayaꞌ kun tachun xatisiviki. ");
INSERT INTO tptNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kalakmakꞌauntꞌikcha ni yuꞌuncha, va laꞌachꞌixin yu tamapꞌulay ixtꞌalaꞌachꞌixinkꞌan. Chuncha incha qayntaun laꞌachꞌix mapꞌulay yu aqayntaun, ex taꞌan pusanjan, va chꞌantaun katalaqpaꞌaꞌ ni pumatꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ex ni Pedro va junil ni Jesús: —Kilalaqxꞌoqnichoqoo yu ixnaꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Va chuncha naul ni Jesús: —¿Mas uxiknankꞌan jantukaꞌ malaꞌasiyatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Jantu malaꞌasiyatꞌik ni yu kꞌaꞌutꞌi la kinkilkꞌan ni yucha tajuyachal la kinpajankꞌan? Ex astan taxtuchoqoy la kilakatunajkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero yu tanajun la ixkilkꞌan ni lapanakni yucha minachal tus la ixjalhanutikꞌan, va yucha lakxkilivay ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","La ixjalhanutikꞌan ni lapanakni ancha minachal yu jantu lajꞌox jatapastakꞌati, yu jamaqninti, yu jamaqtꞌatamanan, yu tamaqamaꞌojoy tachun yu jantu lajꞌox, yu alhavanti, yu jalaklkanti, y yu jamakanunti. ");
INSERT INTO tptNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yu anchanu laqxoqta va yucha yu xkilivay ni lapanakni. Mas jantu kꞌamaqchꞌaꞌa tejkan kꞌavay, jantu yuꞌ yu xkilivay ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tejkan taxtulcha ancha ni Jesús ex alcha taun lakatꞌun ixlhiꞌukstsꞌuniy xaputaulanin ni Tiro kun Sidón. ");
INSERT INTO tptNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ancha ixvilchal qayntaun xanati yu machaqaꞌ Kananea ixjunita. Talakanunil ni Jesús kun pꞌas tꞌasati, va junil: —¡Jalhachimoꞌonu, yu istsꞌal kꞌatꞌi ni David, va knajun kꞌimapꞌaynitꞌi ni kitꞌin! Yu kintsiꞌi va laqtanun yu aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ni Jesús jantu tuꞌuchun kajunil. Ex yu ixtꞌaltanan va tatalakanunil, tatapayninil, va tajunil: —Kꞌaꞌun ni anu xanati kaꞌanchoqol vamuncha ayaj tꞌasajminta la kinpulakankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ex ni Jesús va naul: —Ni Dios kilhimalaqachata vamun yu kintꞌaꞌisraelitas, yuꞌuncha tajunita tacha borregos yu tatsꞌanqatacha. ");
INSERT INTO tptNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero yu xanati taꞌukstsꞌuninil, ex taꞌaqtsoqoqtanil ni Jesús, va junil: —¡Jalhachimoꞌonu, kꞌiꞌaqtꞌayꞌutꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ex ni Jesús va junil: —Jantu ox kꞌalakmaxtꞌunin ixpankꞌan yu jasꞌatꞌan para kꞌalaqxtꞌaqnin yu xꞌoyun. ");
INSERT INTO tptNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ex yu xanati va naul: —Ka chun, Jalhachimoꞌonu. Pero mas va yu xꞌoyun vachu taꞌuy yu patajuy laka mesa yu ixtalaqcheꞌeniꞌ ixvayti ixꞌukxtin. ");
INSERT INTO tptNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ex chuncha va naul ni Jesús: —¡Xanati, va ayaj ay milhakapuꞌati! Va chuncha kaval tacha ni uxintꞌi naꞌun. Ex ni anchanu hora va palaycha junchoqol istsiꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ex minchoqochalcha ni Jesús, va chaꞌal yu xakilpaꞌ lakamar Galilea. Ex taukꞌal taun aspajun y va ancha taulal. ");
INSERT INTO tptNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Va chuncha lhuvaj lapanakni tataqxtoqlhi taꞌan ixvil ni Jesús. Va ixtalhaꞌanta yu lakchꞌanlkꞌavil ali yu lakchꞌanltꞌul, vachu yu lakmaklkꞌavil ali yu lakmakltꞌul, vachu yu laꞌachꞌixin ali yu janunun, ali alati lhuvaj taqanꞌanin. Va tamamanil la ixchꞌaja taꞌan ixvil ni Jesús. Ex ni yucha va palay lakmakaꞌol tachun. ");
INSERT INTO tptNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ex ni lapanakni va tus vak takꞌatsal tejkan talaqtsꞌil yu janunun tachivinilcha, vachu yu lakmaklkꞌavil ali yu lakmakltꞌul va tataꞌoxilcha ixmakakꞌan, y yu lakchꞌanlkꞌavil ali yu lakchꞌanltꞌul vachuꞌ tataꞌoxilcha ixchꞌajakꞌan, y yu laꞌachꞌixin vachucha talakavanalcha. Ex chuncha ni lapanakni va taꞌaqtaylcha ay tamakay xaDios ni Israel. ");
INSERT INTO tptNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ex chuncha ni Jesús va lakjuntaꞌil ixtꞌaltanan, va jalakjunil: —Va ayaj klakmapayniy ni aniy lapanakni, va laꞌatꞌutucha julchan kintatꞌaꞌalinta ni kitꞌin y jantu katamaqalil tuꞌuchuncha yu kataꞌul. Jantu knajun kataꞌanchoqol la ixchaqakꞌan incha jantu kun vayti, va lay katalaqavitil lakatin. ");
INSERT INTO tptNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yu ixtꞌaltanan va tajunil: —¿Tas oxtaycha katemaucha ni vayti yu lay kalakvavau yu aniy lhuvaj lapanakni? Aniy jantu tꞌujuꞌ jataulanti. ");
INSERT INTO tptNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ex ni Jesús laklhisakmil, va lakjunil: —¿Tachuncha pan maꞌalinatꞌik ni uxiknan? Ex tanaul ixtꞌaltanan: —Va aqxtujuncha pan ali tsꞌuniy yu lakstꞌuniy jatanti. ");
INSERT INTO tptNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ex chuncha ni Jesús lakjunilcha ni lapanakni para katataulalcha ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ex chꞌapalcha la ixmakaꞌ ni aqxtujun pan kun yu lakstꞌuniy jatanti, ex skꞌinil lhimalaqpuchuncha ni Dios. Ex laqcheꞌelcha, va jalaqxtaqnilcha ixtꞌaltanan. Ex yu yuꞌuncha va tamaqpitsinilcha ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tus tachun tavaynꞌol va tus ox taꞌotsal. Ex yu xatalaqcheꞌeniꞌ yu xajchal va tus laqatujun lajꞌay canastas talaqtsamal. ");
INSERT INTO tptNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ex yu tavayl va laꞌatꞌati mil joꞌakna y mas alati yu xanatin kun jasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ex va chuncha ni Jesús lakmastakꞌachoqolcha ni lapanakni, taukꞌachoqolcha ni laka barco, va al xalakatꞌun ni Magdala. ");
INSERT INTO tptNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ex va chuncha ni fariseos ali ni saduceos talaqꞌal ni Jesús, talaqtsꞌintanul, va taskꞌinil para kalakmasunil taun ay axtoqnu yu minachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ex ni Jesús va lakjunil: —Tejkan toqoxata, ex ni uxiknankꞌan naunatꞌik: “Chavay ka la lhiꞌacha kunchoqoyaꞌ, ni laktꞌiyan ayaj xlapul.” ");
INSERT INTO tptNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tejkan puvakuj, ex naunatꞌik: “Yu chavay ka jantu lhiꞌacha kunaꞌ, ni laktꞌiyan ayaj xlapul, chuncha aqapuchajuy.” Ex chuncha ni uxiknan ox mispꞌayatꞌik tacha kunaꞌ ni julchan, ¿ex valiꞌiycha jantu malaꞌasiyatꞌik yu tapasay chavaycha aniy taꞌan tꞌaunatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yu aniy jalaktuꞌunun ali maqtaqalhinin lapanakni taskꞌin para kakmakal taun ay axtoqnu pero jantu tuꞌuchun kaklakmasuniyaꞌ, vamun yu tacha tapasal ni Jonás yu maqancha ixlaqputeꞌey ixchivinti Dios. Ex chuncha ni Jesús jamakaulcha, va anchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tejkan taꞌal ixlhiputakuktachal ni lakamar yu ixtꞌaltanan ni Jesús, va jantu katalhaꞌal ixtiyutkꞌan, va takauklhi. ");
INSERT INTO tptNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Chuncha ni Jesús va lakjunil: —Kꞌalhistꞌajkꞌantꞌik kun yu ixlevadurajkꞌan ni fariseos kun yu saduceos. ");
INSERT INTO tptNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ex yuꞌuncha taꞌaqtaychal talaxaqalay, va talajuniy: —¡Chuncha najun por jantu kalhimiu kintiyutkꞌan! ");
INSERT INTO tptNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ni Jesús kꞌatsal yu ixtapastakꞌacha, va lakjunil: —¿Valiꞌiycha naunatꞌikcha ni jantu kꞌalhitsꞌukꞌutꞌik mintiyutkꞌan? Jantu ox kilalhakapuꞌanau. ");
INSERT INTO tptNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jantukaꞌ malaꞌasiyatꞌik? ¿Jantu pꞌastꞌakꞌatꞌik ni aqskis pan iklaqmaqpitsinil laqakis mil joꞌakna? ¿Tas chuncha canastajcha laksakchꞌoꞌotꞌikcha? ");
INSERT INTO tptNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Jantu pꞌastꞌakꞌatꞌik yu aqxtujun pan yu iklaqmaqpitsinil laꞌatꞌati mil joꞌakna? ¿Tas chuncha canasta laksakchꞌoꞌotꞌikcha? ");
INSERT INTO tptNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Jantukaꞌ malaꞌasiyatꞌik ni kitꞌin jantu kaklalhixaqalau pan. Yu klajunau va kalhistꞌakkꞌantꞌik ixlevadurajkꞌan ni fariseos kun yu saduceos. ");
INSERT INTO tptNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Taval tamalaqasilcha yu lakjunil ni Jesús. Jantu ixlhichiviniy xalevadura ni pan, va ixlhichiviniy yu ixtamalaniy ni fariseos kun saduceos. ");
INSERT INTO tptNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tejkan chaꞌal ni Jesús ixlhiꞌukstsꞌuniy ni putaulan Cesarea Filipo, ex laklhisakmil ixtꞌaltanan, va lakjunil: —¿Ni lapanakni tas ayucha talhilaycha ni kitꞌin yu Sasꞌatꞌa Lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yuꞌuncha va tanaul: —Lati tanajun uxintꞌi va Juan yu jamaqchajꞌavanaꞌ. Lati tanajun uxintꞌi va Elías. Lati tanajun va Jeremías kꞌatꞌi u matichun yu maqancha ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ex naul ni Jesús: —Ex uxiknan, ¿tas ayucha naunatꞌikcha ijkunita ni kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ex yu Simón Pedro va junil: —Ni uxintꞌi va yucha ni Cristo kꞌatꞌi, istsꞌal kꞌatꞌi ni Dios yu kujta. ");
INSERT INTO tptNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ex ni Jesús va junil ni Pedro: —Simón, yu istsꞌal kꞌatꞌi ni Jonás, ayaj achꞌantꞌacha ni uxintꞌi. Jantu matichun lapanaki kamamispanin yu nau pero yu kimPay yu alintachal laktꞌiyan, yucha mamispanin. ");
INSERT INTO tptNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kitꞌin ijkunan ni uxintꞌi va Pedro kꞌatꞌi, y kun aniy chiyux kapuꞌaqtayniyaꞌ kilapanakni y mas ixtapꞌasta ni lhinin jantu lay kaamaqalhajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kakxtaqniyan xapalhachimoꞌon laktꞌiyan. Yu kꞌachꞌiꞌulayeꞌe aniy lakamunukpaꞌ vachu jachꞌiꞌulanti kunaꞌ laktꞌiyan. Yu kaxꞌotꞌeꞌe aniy lakamunukpaꞌ, vachu jaxꞌoqnuti kunaꞌ laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ex ni Jesús va lakjunil ni ixtꞌaltanan para jantu matichun katajunil ni yucha va yu Cristo. ");
INSERT INTO tptNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Anchanu julchan ni Jesús aqtaynil jalaqputeꞌeniꞌ ixtꞌaltanan ni yucha maqskꞌiniy kaꞌal Jerusalén. Chuncha katamamaqanlqajnivayaꞌ yu xalajꞌay xapaynin, ni xaꞌukxtinin kuras, y vachuꞌ yu ixtamasuy ixlhachimoꞌonkꞌan. Va katamaqniyaꞌ, pero yu laꞌatꞌutu julchan va katakukchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Chuncha ni Pedro va alakataun ixꞌaman lhaꞌal ni Jesús, va aqtayl laqꞌaymay, va juniy: —Jalhachimoꞌonuꞌ, kamapꞌaynikꞌa meꞌeman. Apalay ox jantu chuncha kꞌatꞌapꞌasꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Chuncha ni Jesús talaqaspꞌiklhi, va junil ni Pedro: —Yu uxintꞌi, Satanás, tumpajcha kꞌaꞌuntꞌi kun kitꞌin. Uxintꞌi vamun makꞌay para kꞌimapꞌutsꞌanꞌanitꞌi. Uxintꞌi mejatapastakꞌati jantu chun tacha ixjatapastakꞌati Dios, va pastakꞌa tacha yu valiꞌiy lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ex ni Jesús va lakjunil ixtꞌaltanan: —Incha matichun kintꞌatiꞌukxuntayaputun, yucha jantucha lay makay yu makaputun. Kaval tacha kalhaꞌal ixkurus, ex chuncha lay kintꞌatiꞌukxuntayalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ni lapanaki yu ayaj lhitsukuputun ixjatsukunti, yucha kamaqatsꞌanqayaꞌ. Pero yu kamaqatsꞌanqayaꞌ ixjatsukunti por kitꞌin, yucha kalhitsukuchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Tisuncha lhajaycha qayntaun lapanaki incha kalhitsukuꞌol tachun yu alin lakamunukpaꞌ pero va maqatsꞌanqay ixjatsukunti? ¿Tas kapulhitsukuchoqoyaꞌ ixjatsukunti? ");
INSERT INTO tptNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yu kitꞌin ni Sasꞌatꞌa Lapanaki kakmintachal kun ixtapꞌasta kimPay, y kun ixmayulnin. Ex chuncha kaklakmapalacha ni lapanakni por qayntamin va yu tamakata. ");
INSERT INTO tptNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Laqsaval klajunau, aniy taꞌalin lati lapanakni yu jantukaꞌ kataniyaꞌ tus katalaqtsꞌinꞌelayaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki tejkan kakmintachal la kilhachimoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ex va chuncha astan tejkan laqachaxancha julchan val, ni Jesús va tumpaj lhaꞌal ni Pedro ali Santiago ali Juan yu ixlaqaj Santiago. Va laklhaꞌal taun ay aspajun. ");
INSERT INTO tptNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ancha la ixtalakaꞌukxpukꞌan ni yuꞌuncha, va tapaxal yu tacha ixtasuta ni Jesús. Yu ixꞌukxpuꞌ va tus kꞌuliksnaꞌ val, tacha julchan. Yu ixlaqchꞌiti va yaqaq val, va tacha jatunkunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Talaqtsꞌil ni Moisés ali Elías. Va ixtatꞌajun laxaqalanin kun Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ex yu Pedro va junil ni Jesús: —Jalhachimoꞌonuꞌ, ¡ayaj ox ijkꞌalintau ni aniy! Incha uxintꞌi naꞌun, kakmakayau aqatꞌutu moqltaꞌ. Aqataun para uxintꞌi, aqataun para Moisés y aqataun para Elías. ");
INSERT INTO tptNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ex tejkan ixtꞌajun chivin ni Pedro va laqmaqatanul kun xajalkꞌikniꞌ laqataun taputsꞌi kꞌuliksnaꞌ, ex yu laka taputsꞌi va taqasmaklhi taun chivinti, va naul: —Ni aniy yucha ni kintsꞌal yu ikmalaqachata; va ayaj ijkꞌachaniy. La ox kaꞌalasmaktꞌik ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tejkan chuncha taqasmaklhi ixtꞌaltanan va tus tatalakaputatamal la ixꞌukxpukꞌan ni lakatꞌun, va tus ox ixtalaktalhananta. ");
INSERT INTO tptNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ex ni Jesús laktalakanunil, jalakchꞌapal, va lakjunil: —Kaꞌostꞌaulatꞌikcha, jantu katꞌalhanantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ex chuncha tejkan talaqtsꞌinchoqol va jantucha matichun katalaqtsꞌil. Va ixꞌamancha yachoqol ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tejkan taminchoqochalcha ni aspajun, ex ni Jesús va lakjunil ni ixtꞌaltanan: —Jantu matichun kꞌaꞌunitꞌik yu ixlaqtsꞌinatꞌik tus tejkan kaktakukchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki ex kꞌanaunapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ex chuncha ixtꞌaltanan ni Jesús talhisakmil, va tajunil: —¿Valiꞌiychacha yu tamasuy ixlhachimoꞌonkꞌan ni israelitas tanajun ni Elías va yucha pꞌunaj kaminaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ex ni Jesús va naul: —Chun, ni Elías pꞌunaj kaminaꞌ, va yucha ni kalaqlaꞌoxiꞌoyaꞌ tachun. ");
INSERT INTO tptNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero yu kitꞌin klajunau, ni Elías kilatachilcha, pero yuꞌuncha jantu katamispal. Tamakanil ni yucha va tacha ni yuꞌuncha tamakaniputulcha. Vachu va chun ni kitꞌin yu Sasꞌatꞌa Lapanaki ayaj kakmaqanlqajnanaꞌ la ixtamakakꞌan ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ex ixtꞌaltanan ni Jesús va tamalaqasil ixtꞌajun lhichiviniꞌ Juan yu ixjamaqchajꞌavanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ex va chuncha tejkan tachinchal taꞌan ixtaꞌalinta lhuvaj lapanakni, va talakanunil ni Jesús qayntaun lapanaki, va taꞌaqtsoqoqtanil la ixtalakaꞌuxkpu ni yucha, va junil: ");
INSERT INTO tptNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Jalhachimoꞌonu, kitꞌin va knajun kꞌamapꞌaynitꞌi ni kintsꞌal. Va chꞌapay yu ixlhinin, chuncha maqanlqajnan va taxtujcha. Ayaj aqlhuvajcha taqtay laka jikmi, aqtamixna taqtay ni lakxkan. ");
INSERT INTO tptNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yu mintꞌaltanan xaklaklhiminitacha ni aniy pero jantu kalal ni katamaꞌayajnichoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ex ni Jesús va naul: —¡Yu uxiknan jantu lay lhakꞌapꞌupꞌinatꞌik, va jalaktuꞌunun untꞌatꞌik! ¿Tus tavanancha kaktamakaunaꞌ kun uxiknan? ¿Tus tavanancha kaklatayaniyaucha? Kꞌalhitꞌantꞌikcha aniy ni tsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ex chuncha ni Jesús va laqꞌaymal yu jantu ox espíritu. Va taxtunichoqol ni tsꞌal. Ex va taun panchꞌix va ayajnanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Taval yu ixtꞌaltanan va tatꞌachivinil ixꞌaman ni Jesús, va tajunil: —¿Valiꞌiychacha ni kijnan jantu kalal ikmaxtuu ni anchanu jantu ox espíritu? ");
INSERT INTO tptNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ex ni Jesús va lakjunil: —Ni uxiknan va ayaj tsꞌuniy milhakapuꞌatkꞌan. Chavay vas klajunau, mas milhakapuꞌatikꞌan va lakstꞌuniy tacha yu lakatꞌuniy xataltsꞌi mostasa, incha kaꞌunitꞌik ni aniy aspajun: “Kaꞌostꞌicha ni aniy, kꞌapꞌinchꞌiycha alakataun.” Ex yu aspajun va niman kaqosaꞌ. Chuncha jantu kaꞌalil tuꞌuchun yu jantu kalal. ");
INSERT INTO tptNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Incha maxtꞌupꞌutꞌun tacha anchanuꞌ jantu ox espíritu, ex maqskꞌiniy kaskꞌin Dios kun taskꞌajati. ");
INSERT INTO tptNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ex va chuncha tejkan chꞌantaun ixtatiꞌukxuyananchal xalakatꞌun ni Galilea, ex ni Jesús lakjunil ixtꞌaltanan, va naul: “Ni kitꞌin yu Sasꞌatꞌa Lapanaki kintamaqxtaꞌaꞌ la ixtamakakꞌan ni lapanakni, ");
INSERT INTO tptNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ex chuncha kintamaqniyaꞌ, pero yu laꞌatꞌutunuꞌ julchan kajkujchoqoyaꞌ.” Ex chuncha yu ixtꞌaltanan va ayaj tamaqaninilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ex chuncha ni Jesús kun ixtꞌaltanan va tachaꞌal Kapernaum. Ex yu ixtachꞌinin ixlhimapalkan ni ay lakatajtan va talaqꞌal ni Pedro, va talhisakmil: —¿Yu mijamalaninikꞌan jantu mapalay yu xalhimapalkan ni ay lakatajtan? ");
INSERT INTO tptNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ex ni Pedro qaltayanal, va naul: —Chun, mapalay. Ex tejkan tanuchalkaꞌ laqa chaqaꞌ ni Pedro, ni Jesús va xaqalal, va junil: —Simon, ¿uxintꞌi sun chivinticha naꞌun? Yu xajalhachimoꞌonun ni lakamunukpaꞌ, ¿tas ayuꞌunchacha chꞌikan yu xalhimapalkan? ¿Va yu sasꞌatꞌan? u ¿va yu alakataun machaqan? ");
INSERT INTO tptNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ex ni Pedro va naul: —Va yu alakataun machaqan. Ex ni Jesús va naul: —Ex yu ancha machaqan jantu maqskꞌiniy tuꞌuchun katamapalal. ");
INSERT INTO tptNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para jantu katatalqaul ni lapanakni, kapꞌinchꞌiy ni lakamar, kꞌamuꞌuyeꞌe mimpamaqlhavan, va kꞌamakꞌutꞌuyeꞌe ni jatanti yu pꞌunaj katsakꞌayaꞌ. La ixkil ancha kꞌatꞌemaniyeꞌe aqxtaun tumin. Ex ni anchanu kalaqchaanacha para kꞌalhimapꞌalꞌoyeꞌe yu klaninin y vachu kun yu uxintꞌi lhipꞌininin. Kꞌalhipꞌinchꞌiycha, kꞌamapꞌaltꞌicha. ");
INSERT INTO tptNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ex va chuncha ni anchanu julchan ixtꞌaltanan ni Jesús va tatalakanunil, va talhisakmil va tanaul: —Taꞌan lhachimoꞌonun ni Dios, ¿tas ayuchacha yu xaꞌay junita? ");
INSERT INTO tptNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ex ni Jesús va tꞌasaꞌil qayntaun sꞌatꞌa, va maqayaul la ixtalakaꞌukxpukꞌan ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ex va lakjunil: —Vas klajunau, incha uxiknan jantu lakstꞌuniy kakꞌatsꞌantꞌik tacha jasꞌatꞌan, ex jantu lay kꞌatꞌanutꞌachipitik taꞌan jalhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yu apalay ay junita taꞌan jalhachimoꞌonun ni Dios, yucha yu vamun lakatꞌuniy makakan tacha yu aniy jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yu laqaꞌiy ni aniy jasꞌatꞌa por chuncha klhinajun ni kitꞌin, ex vachu kilaqaꞌiy ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Mas va taꞌayuchacha kaval incha kamakal para kamaqtaqalhinil qayntaun kilapanaki tacha yu aniy lakatꞌuniy jasꞌatꞌa, ex ni yucha ayaj lhitaꞌay katapasayaꞌ. Apalay ox kaval ni kapixtuchꞌiꞌulakalcha kun xachiyux pachꞌikni, ex kaꞌankalcha ixmajꞌanka lakamar y kaꞌakskꞌajꞌul. ");
INSERT INTO tptNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ayaj lhitaꞌay yu aniy lakamunukpaꞌ, va pumalhuvaj alin yu talhinajun katamaqtaqalhinil. Ni yuꞌuncha va tacha taꞌalincha, pero ¡paynicha ni lapanaki yu lhinajun katamaqtaqalhinil yu alati! ");
INSERT INTO tptNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Xlhiyucha incha makꞌapꞌutꞌun talaqalhin kun mimakaꞌ u minchꞌajaꞌ, apalay ox kaval ni kꞌachꞌaqxmajꞌacha, va kamajꞌacha. Apalay ox kꞌatꞌanuchiy makltꞌul u chꞌanltꞌul taꞌan alin ox jatsukunti y jantu kamujun kun maktꞌuy u chꞌantꞌuy laka jikmi taꞌan maqtajita mas va tavanancha. ");
INSERT INTO tptNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Vachuꞌ incha kꞌamakꞌapꞌutꞌu talaqalhin por yu laqtsꞌin la milaqchul, apalay ox kaval ni kꞌalakpꞌumaxtꞌukꞌa milaqchul. Apalay ox mas vamun milakputaun kꞌatꞌanuchiy taꞌan alin ox jatsukunti y jantu kꞌatꞌanuchiy milakputꞌuy milaqchul la xajikmi ni laqnin. ");
INSERT INTO tptNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Jantu kꞌanau ni jantu xtapal kataval yu aniy lakstꞌuniy jasꞌatꞌan. Laqsaval klajunau yu ixmayulnin Dios yu jalaklhistakꞌa, yuꞌuncha taꞌalintacha la ixtalakaꞌukxpuꞌ ni kimPay yu alintachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ni kitꞌin yu Sasꞌatꞌa Lapanaki va klaqkimalaqtaxtuchil yu ixtatsꞌanqatacha. ");
INSERT INTO tptNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Tas lhilayatꞌikcha? Incha qayntaun lapanaki lhitꞌajun taun ciento ixborregos pero incha tsꞌanqay laqataun, ¿ex tisuncha kamakayaꞌ? Va kalakmakaunaꞌ yu noventa y nueve laka aspajun y kaꞌanaꞌ lakxkaunaꞌ yu laqataun borrego yu tsꞌanqata. ");
INSERT INTO tptNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chavay incha katemachoqol ni anchanu laqataun borrego yu istsꞌanqata ex apalay lhiꞌachantajuy xajantu yu anchanu noventa y nueve yu jantu katatsꞌanqal. ");
INSERT INTO tptNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vachu chun yu mimPaykꞌan yu vilchal laktꞌiyan jantu najun matichun katsꞌanqal mas va qayntaun yu aniy lakstꞌuniy. ");
INSERT INTO tptNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Chavay incha milaqaj makaniyan taun tuꞌuchun yu jantu ox, maqskꞌiniy kꞌatꞌalaqlaꞌoxitꞌi ixꞌaman. Incha makanincha kuenta yu tacha un ex ox junchoqoy tacha milaqaj. ");
INSERT INTO tptNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Chavaycha incha jantu kamakanin kuenta yu un ex maqskꞌiniy kꞌaꞌuntꞌaꞌitꞌi qayntaun u qayntꞌuy para vachuꞌ kataqasmaktayl yu lhichꞌivinatꞌik, chuncha para yuꞌuncha katamasavalal tachun yu naꞌuntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Chavay incha jantu kamakayaꞌ kuenta kun yuꞌuncha, ex maqskꞌiniy katꞌachꞌivincha la ixtalakaꞌukxpukꞌan yu talhakapuꞌan ni Dios taꞌan tataqxtoꞌa. Chavay incha jantu kamakanin kuenta mas kun yuꞌuncha, ex tsꞌanqay kꞌalaqtsꞌi tacha qayntaun yu jantu lhakapuꞌanan u tacha qayntaun yu chꞌinin impuestos. ");
INSERT INTO tptNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Laqsaval klajunau, tachun yu kꞌachꞌiꞌulayapitik aniy lakamunukpaꞌ ex vachu va chun kachꞌiꞌulakantachal laktꞌiyan. Vachu tachun yu kaxꞌoqtꞌapitik ni aniy lakamunukpaꞌ, vachu va chun kaxꞌoqkantachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Vachu klajunau incha pumatꞌuy ni uxiknankꞌan aniy lakatꞌun kꞌaskꞌinitꞌik ni Dios, incha va chꞌantaun kaꞌuntꞌik yu kaskꞌinpꞌutꞌuntꞌik, ex kataxtaqniyan yu kimPay yu alintachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chavay yu taꞌan tataqxtoꞌa pumatꞌuy u pumatꞌutu la kintaqaꞌuti, ex kitꞌin ancha ijkꞌalinta la ixtaꞌajna ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ex chuncha ni Pedro laqꞌal ni Jesús, lhisakmil, va naul: —Jalhachimoꞌonu, ¿tas aqchuxicha kakmalaqmixinil kilaqaj tejkan kimakanil taun tuꞌuchun yu jantu ox? ¿Tus aqtujun? ");
INSERT INTO tptNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ex ni Jesús va naul: —Jantu ijkunan va aqtujun, mas va tavanancha kaval kꞌamalaqmixinin, mas aqlhuucha kaval, mas setenta por siete. ");
INSERT INTO tptNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Yu xalhachimoꞌon ni laktꞌiyan va tacha qayntaun jalhachimoꞌonu yu ixmasavalaputun ixkuentajkan ixꞌoqxtamatin. ");
INSERT INTO tptNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ex va chuncha tejkan taꞌaqtaynilcha puteꞌenin ixkuentajkꞌan, ex va talhiminil qayntaun yu ixlhaaniy lhuvaj tumin, tus miyones. ");
INSERT INTO tptNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chuncha yu ixꞌoqxtamati va jantu kalhitsukul yu kalhimapalnil, ex yu ixꞌukxtin va lhijunilcha para kastꞌakal kun ixanati ali sasꞌatꞌan y vachu kun tachun yu ixlhitꞌajuncha va para kalaqchaanil ni kalhimapalal tachun ixlhaaninti. ");
INSERT INTO tptNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","’Ex va chuncha yu oqxtamati taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ ni ixꞌukxtin, tapayninil, va junil: “Jalhachimoꞌonu, va knajun kꞌimaꞌantꞌaulnin ataun panchꞌix, kakmapalniꞌoyan laksniy tachun yu iklhaaniyan.” ");
INSERT INTO tptNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ex yu ixꞌukxtin va mapaynil, va maqantaulniꞌolcha tachun ni ixlhaaniy. Va oxamaktauncha makaunchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Ex tejkan taxtuchoqolcha ni oqxtamati va temal qayntaun ixtꞌatapatsan, ni yucha ixlhaaniy lakatsꞌuniy tumin. Ex ni yucha va niman chꞌapanil la ixpixtu, va aqtaynilcha pixtulhita para kamaꞌakskajval, ex va juniy: “¡Kꞌimapꞌalnincha laqatapꞌastꞌa yu kꞌilhipꞌiniy!” ");
INSERT INTO tptNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ex ni anchanu ixtꞌatapatsan taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ yu ixlhaaniy, ex tapayninil, va junil: “Kꞌimaꞌantꞌaulnin ataun panchꞌix. Kakmapalniꞌoyan laksniy yu iklhaaniyan.” ");
INSERT INTO tptNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ixtꞌaꞌoqxtamati yu ixlhaaniy va jantu kamaqantaulnil, va manul laka pachꞌin tus kamapalal ixlhaaninti. ");
INSERT INTO tptNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ex tejkan chuncha talaqtsꞌil yu alati ixtꞌatapatsanin yu tacha tapasal va tus jantu katalhipaꞌinil, va la taxkanil. Ex va taꞌal laqputeꞌeninin ni ixꞌukxtinkꞌan yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ex chuncha yu jalhachimoꞌonu va malaqachanal ixjuntaꞌika, va junil: “Uxintꞌi jalaktuꞌunuꞌ oqxtamati kꞌatꞌi, kitꞌin ikmaqantaulnin tachun yu ixkꞌilhipꞌinin, va por kꞌintꞌapꞌayninin. ");
INSERT INTO tptNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Apalay ox ixlhitsꞌukꞌunin mapayninti mintꞌatapatsan chuncha tacha kitꞌin ikmapaynin ni uxintꞌi.” ");
INSERT INTO tptNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ex ni jalhachimoꞌonuꞌ va ayaj talqaul, va malaqachanal ixmanuka laka pachꞌin ni anchanu oqxtamati, va tus kamapalniꞌokal tachun yu ixlhaanikan. ");
INSERT INTO tptNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ex va chuncha ni Jesús taylhaꞌal ixchivinti, va naul: —Yu kimPay laktꞌiyan vachu va chun katamakaniyan ni uxiknan incha jantu laqsaval malaqmixiniyatꞌik mintꞌalaqauninkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Chuncha tejkan laqputeꞌeꞌolcha ni Jesús, va alcha xalakatꞌun Galilea, chaꞌal yu xalakatꞌun Judea taꞌan putakꞌutꞌa ni julchan, xlhiꞌavintꞌi xalaꞌaxkan Jordán. ");
INSERT INTO tptNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ex chuncha va lhuvaj lapanakni tatꞌaꞌal y va jalajkꞌuchꞌuchal ni taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ex chuncha lati ni fariseos tatalakanunil ni Jesús, talaqtsꞌintanul, va tanaul: —¿Lay kamakaunchoqol ixanati qayntaun lapanaki mas va tuꞌuchun kaval yu kamakanil? ");
INSERT INTO tptNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ex ni Jesús va lakjunil: —¿Jantu aqtaun pꞌutꞌeꞌeyatꞌik uxiknan la ixchivinti Dios taꞌan tsꞌoqkanta, va najun, “tejkan pꞌunaj lakmakal ni Dios ni lapanakni, va lakmakal qayntaun joꞌati ali qayntaun xanati”? ");
INSERT INTO tptNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Vachu naul ni Dios: “Xlhiyucha ni joꞌati makajun ni ixpay ali ixnati, tꞌatsukuy ixanati, ex yu pumatꞌuy va qayntauncha lapanaki tapalay.” ");
INSERT INTO tptNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ex chuncha jantucha pumatꞌuy tajunita, va qayntauncha jun. Ex chuncha ni lapanakni jantu maqskꞌiniy katalaqlvaqlhi yu malaqxtoꞌa ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ex chuncha ni fariseos talhisakmil, va tajunil: —¿Valiꞌiycha ni Moisés lhinaul kaxtaqnikal aqxtaun acta qayntaun xanati para kapumakaunchoqokal? ");
INSERT INTO tptNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ex ni Jesús va naul: —Va por pꞌays melhanutkꞌan va chuncha lhinaul ni Moisés para kalamakꞌauntꞌik, pero yu maqancha tejkan aqtaynichal ni lakamunukpaꞌ jantu chuncha ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero yu kitꞌin iklajunau, incha qayntaun joꞌati makajun ixanati mas jantu kamaqtaqalhinil, ex tꞌatsukuchoqoy aqayntaun xanati, ex chuncha ni yucha makay talaqalhin. Vachu incha qayntaun joꞌati tꞌatsukuchoqoy yu makaunkanta, ex ni yucha vachu makay talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ex ixtꞌaltanan va tanaul: —Incha va ay laqtaqal makay yu makajun ixanati, ex ka apalay ox jantu katꞌatsukul. ");
INSERT INTO tptNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ex ni Jesús va naul: —Jantu lay katamalaqasil tachun ni lapanakni, vamun lati yu laksakta Dios lay tamalaqasiy. ");
INSERT INTO tptNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Taꞌalin lapanakni yu jantu lay talakxtuklay va por chuncha tatsukul. Vachu lati lapanakni jantu lay talakxtuklay va por chuncha lakmakanikan. Vachu lati lapanakni jantu talakxtuklay, vamun tapatsaniputun xalhachimoꞌon ni laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ex va chuncha ni lapanakni va talhaanil ni jasꞌatꞌan ni Jesús va para kalaqmoqslanil ixmakaꞌ y para kalakskꞌinil Dios. Pero yu ixtꞌaltanan ni Jesús va taꞌaqtayl talaqꞌaymay yu ixtalhaꞌan ni sasꞌatꞌaninkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ex ni Jesús va naul: —Kꞌalakmakꞌauntꞌikcha ni jasꞌatꞌan, chaqx katamil kun kitꞌin. Jantu maqskꞌiniy kalaqꞌaymatꞌik, yu tatanuyachal taꞌan lhachimoꞌonun Dios yuꞌuncha tajunita tacha yu aniy jasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ex chuncha va laqmoqslanil ixmakaꞌ ni jasꞌatꞌan ex taval anchoqolcha alakataun. ");
INSERT INTO tptNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ex chuncha qayntaun tsꞌal laqꞌal ni Jesús, lhisakmil, va naul: —Ox jamalaniniꞌ, ¿tisuncha yu lajꞌox kakmakal para kaklhitsukul ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ex va naul ni Jesús: —¿Valiꞌiycha kꞌiꞌuniy ox kunita? Yu ox vamun Dios. Incha tꞌanupꞌutꞌunachiy taꞌan alin ox jatsukunti, ex maqskꞌiniy katꞌoꞌoyatꞌi yu lhinajun Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ex yu tsꞌal va naul: —¿Taꞌayuchacha? Ex junil ni Jesús: —Jantu kꞌamaqnin, jantu kꞌatꞌatꞌamatꞌi aqayntaun yu jantu minavin kaval, jantu kꞌaꞌalhavan, vachuꞌ jantu kalaklkꞌan y jantu kalhichꞌivin aqayntaun yu jantu laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kꞌatꞌoꞌoyatꞌi mimpay kun minati, vachuꞌ kꞌaꞌachꞌanin mintꞌamachaqaꞌ tacha uxintꞌi achꞌanikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ex va naul ni tsꞌal: —Tachuncha ni anchanu va kmakaꞌojotacha. ¿Ex tisuncha apalay kintsꞌanqaniy? ");
INSERT INTO tptNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ex va naul ni Jesús: —Incha vas ni unpꞌutꞌun, kapꞌinchꞌiycha lakstꞌanaꞌ yu lhitꞌaꞌun. Ex yu xatapal kalaqxtꞌaqnincha ni kilpatanin. Ex kꞌalhitsꞌukꞌutꞌachiy mimaqaliti laktꞌiyan. Ex chuncha kꞌintꞌatꞌatꞌicha. ");
INSERT INTO tptNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tejkan chuncha qasmaklhi ni tsꞌal, va tus maqaninijꞌanchoqolcha. Va ayaj maqaliꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ex ni Jesús va lakjunil ixtꞌaltanan: —Laqsaval klajunau, la lhitaꞌay para katanuchal qayntaun maqaliꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Laqsaval klajunau, apalay va tsꞌalti kapulaqpuslhi laqataun camello taꞌan puxalal la ixtꞌitꞌampꞌin ni makskati xajantu katanuchal qayntaun maqaliꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ex tejkan chuncha taqasmaklhi ixtꞌaltanan ni Jesús, va tus vak takꞌatsal, va tanaul: —¿Ex tas ayucha lay kalaqtaxtuyacha? ");
INSERT INTO tptNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ex ni Jesús laqtsꞌil ixtꞌaltanan, va lakjunil: —Alin yu jantu lay tamakay ni lapanakni pero ni Dios tus tachun lay makay. ");
INSERT INTO tptNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ex ni Pedro va junil: —Yu kijnankꞌan ikmakaunꞌotaucha tachun yu klhitꞌaunau y klatꞌatiꞌukxuyanaucha. ¿Ex tisuncha klaqaꞌiyau? ");
INSERT INTO tptNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ex ni Jesús va naul: —Laqsaval klajunau, kaminaꞌ julchan tejkan laqsastꞌi kunaꞌ tachun, y kaktaultachal ni kitꞌin yu Sasꞌatꞌa Lapanaki la kimpalhachimoꞌon taꞌan kaklhitsukuyaꞌ kintapꞌasta. Ex uxiknan yu kilatꞌaltananau vachu va katꞌaultꞌachipitik milaqakautꞌuykꞌan laka japalhachimoꞌon para kalaqlaꞌoxiniyapitik yu oqxlaqkautꞌuy xalapanakni Israel. ");
INSERT INTO tptNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Chavay taꞌayucha yu makajun ixchaqaꞌ, u ixlaqaj, u ixtꞌalapanaki u ixpay u ixnati, u sasꞌatꞌan u ixtꞌun por kitꞌin, ex ni yucha kalaqaꞌichoqoyaꞌ apalay lhuu, tus taun ciento. Y vachu kalaqaꞌiyaꞌ ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Chavay ayaj lhuvaj taꞌalin yu ayaj lajꞌaynin takꞌatsan, pero astan ni yuꞌuncha va lakstꞌuniy katajunaꞌ. Chavay ayaj lhuvaj taꞌalin yu lakstꞌuniy takꞌatsan pero astan ni yuꞌuncha va xalajꞌaynin katajunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ex vachu va lakjunil ni Jesús: —Yu xalhachimoꞌon laktꞌiyan va tacha qayntaun lapanaki yu ayaj maqalin ixtꞌun para kꞌatꞌapꞌatsꞌatꞌi. Taun puvakuj al jalakxkaunaꞌ oqxtamatin para katatapatsal la ixtꞌun taꞌan ixchꞌanta uvas. ");
INSERT INTO tptNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ex tejkan laktemal va talaqlaꞌoxil yu tacha katalhajayaꞌ por paqtamin ixlhitapatsakꞌan. Ex chuncha laqmalaqachalcha tapatsanin la ixtꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Taval tejkan laqanajatsicha puvakuj val, va aaqtaun anchoqol laklhitamau, va laqtsꞌil alati lapanakni yu valiꞌiy ixtayanal. ");
INSERT INTO tptNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ex va lakjunil ni maqaliꞌ: “Ni uxiknan valiꞌiy ukxuyanantꞌik. Vachu kapꞌinchꞌipitik tapatsanin la kilhitapatsa. Ox klamapalau.” Ex va chuncha va taꞌalcha tapatsanin ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Taval ni maqaliꞌ aaqtaun lajkilakxkauchoqol oqxtamatin va tejkan atunkulcha, ex vachu tejkan laꞌatꞌutu putoqoxata val. Vachu va chun laklhijunil alati yu valiꞌiy ixtatiꞌukxuyanal. ");
INSERT INTO tptNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ex chuncha tejkan va laycha kalaqchaanputul laqakis putoqoxata ni maqaliꞌ va anchoqol aaqtaun laklhitamau. Ex va laktemachoqol yu alati lapanakni yu valiꞌiy ixtatiꞌukxuyanal. Ex va lakjunil: “¿Valiꞌiycha alintꞌatꞌikcha aniy tus taun julchan y jantu katsꞌukꞌutꞌik tapatsanin?” ");
INSERT INTO tptNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ex ni yuꞌuncha va tanaul: “Jantu matichun kintalhijunan lhitapatsa.” Ex ni yucha va lakjunil: “Kꞌapꞌinchꞌipitik tapatsanin la kintꞌun. Ox klamapalau.” ");
INSERT INTO tptNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Taval tejkan putsꞌislhicha ex ni maqaliꞌ va junil yu xaꞌay ixꞌoqxtamati, va naul: “Kꞌalakjuntꞌaꞌitꞌicha ni oqxtamatin. Kꞌalakmapꞌaltꞌicha. Kꞌapꞌuꞌaqtꞌayniy yu astan taꞌaqtaynil ni lhitapatsa, y kꞌapꞌuxajchꞌiy yu pꞌunaj taꞌaqtaynil ni lhitapatsa.” ");
INSERT INTO tptNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ex va aqtayl lakmapalkan. Pꞌunaj tatalakanulcha yu taꞌaqtaynil lhitapatsa yu laqakis putoqoxata, va lakmapalkal qayntamin por qayntamin yu lhajakan paqtaun. ");
INSERT INTO tptNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ex taval tatalakanul yu pꞌunaj taꞌaqtaynil tapatsanin. Ni yuꞌuncha ixtalhilay kalakmapalkanaꞌ apalay lhuu pero por qayntamin vachu talaqaꞌil va yu lhajakan paqtaun. ");
INSERT INTO tptNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ex tejkan talaqaꞌiꞌolcha va taꞌaqtaynil talhilakchiviniy por yu anchanuꞌ xamanavin ni tꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Va tajunil ni manavin: “Yu alati, va laycha katoqoxal ixtachin, va tauncha hora tatapatsal, chavay yuꞌuncha vachu va chun talhajal tacha kijnan klhajau. Chuncha tus va tauncha julchan xaktayaniyau laka lhiꞌicha.” ");
INSERT INTO tptNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ex ni maqaliꞌ va junil xaqayntaun ni yuꞌuncha: “Kintꞌalaqajun, kitꞌin jantu tuꞌuchun laqtaqal iktsukun makanin. Laqlaꞌoxiu ni va chuncha kꞌalhaꞌayeꞌe tacha lhajakan paqtaun. ");
INSERT INTO tptNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chavay kꞌalaꞌaꞌitꞌicha milhilhajati. Kꞌapꞌinchꞌoꞌocha. Incha kitꞌin iknajun chuncha kmapalputun yu astan aqtaynil tapatsan, va chuncha kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ni kintumin yucha kinavin, va kitꞌin kimpaxtoqniy kakmakal yu ikmakaputun. U ¿va akchꞌipꞌin va por ikqalꞌox lapanaki kunita?”, va naul ni maqaliꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Vachu va naul ni Jesús: —Ex chuncha, yu chavaycha xaꞌastanin tajunita, yuꞌuncha xapꞌunajnin katajunaꞌ. Pero yu chavaycha xapꞌunajnin tajunita, yuꞌuncha xaꞌastanin katajunchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ex chuncha tejkan ixꞌantacha ni Jesús xalakatin Jerusalén, va tumpaj lakjuntaꞌil ixtꞌaltanan yu pumakautꞌuy. Va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Chavay teꞌenaucha Jerusalén. Ni kitꞌin yu Sasꞌatꞌa Lapanaki kakmaqxtaqkanaꞌ la ixtamakakꞌan yu xaꞌukxtinin kuras ali yu tamalaniy kilhachimoꞌonkꞌan. Kintamukꞌaniyaꞌ laqtaqal para kintamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ex chuncha kintamaqxtaꞌaꞌ kun yu jantu israelitas kataval para kintalaktuꞌul ni kitꞌin. Ex kintalakasamayaꞌ y kintaxtukmukꞌayaꞌ laka kurus. Pero yu laꞌatꞌutunuꞌ julchan kajkujchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ex va talakanunil ni Jesús ixanati ni Zebedeo, va laktꞌamil istsꞌalan, yu Juan kun Santiago. Ni anchanu xanati va taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ ni Jesús, va skꞌinil taun jatapayniti. ");
INSERT INTO tptNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ex ni Jesús va junil: —¿Tisuncha maqskꞌiniycha? Ex va naul ni xanati: —Va knajun kꞌalhinau kataulal la mipalhachimoꞌon yu qayntaun kintsꞌal la milhijakana y yu aqayntaun kataulal la milhijamaqxu. ");
INSERT INTO tptNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ex ni Jesús va lakjunil: —Uxiknan jantu malaꞌasiyatꞌik yu skꞌinatꞌik. ¿Lhilayatꞌik kalayaꞌ kꞌapꞌuꞌoqnunapitik yu xavaso maqanlqajnati yu kitꞌin kakpuꞌoqnunaꞌ? ¿Lhilayatꞌik kalayaꞌ kꞌapꞌuꞌaqchꞌajꞌauyapitik yu lhitaꞌay aqchajꞌauti yu kitꞌin kakpuꞌaqchajꞌauyaꞌ? Ex tanaul ni Juan kun Santiago: —Chun, kalayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ex ni Jesús va lakjunil: —Laqsaval kꞌapꞌuꞌoqyapitik ni kivaso, y vachu kꞌapꞌuꞌaqchꞌajꞌauyapitik chuncha tacha kitꞌin ikpuꞌaqchajꞌajuta. Pero yu katꞌaulatꞌik la kilhijakanaj kun la kilhijamaqxu, yucha jantu kimpaxtoqniy para kaklaxtaqniu. Va paxtoqniy kimPay kaxtaqnil yu ixtalaksaknati. ");
INSERT INTO tptNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ex tejkan chuncha taqasmaklhi ni alati yu pumakau va la tatalqaunil yu anchanu pumatꞌuy jatꞌalaqaunin. ");
INSERT INTO tptNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ex ni Jesús va lakjuntaꞌiꞌol ixtꞌaltanan, va lakjunil: —Ni uxiknankꞌan ox kꞌatsꞌayatꞌik ni xalhachimoꞌonun aniy lakamumukpaꞌ va pꞌas laklhichimoꞌoy ixlapanaknikꞌan. Yu xalajꞌaynin apalay pꞌas ixlhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero jantu maqskꞌiniy chuncha kaꞌuntꞌik ni uxiknankꞌan. Yu xaqayntaun ni uxiknankꞌan yu junputun xaꞌay, yucha maqskꞌiniy kalaqꞌaqtayjuꞌol tachun yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Vachu yu taꞌayucha ni uxiknankꞌan yu junputun xapꞌunaj, yucha maqskꞌiniy kaval tacha qayntaun oqxtamati yu jantu mapalkan. ");
INSERT INTO tptNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ni kitꞌin yu Sasꞌatꞌa lapanaki jantu kakmil para kaktapatsanikal. Kitꞌin kminta para kaklaqꞌaqtayjul yu alati. Vachu kakmaqxtaꞌaꞌ ketsukunti para chuncha katapulaqtaxtul pumalhuu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ex chuncha tejkan tataxtuchoqolcha laka putaulan Jericó, va lhuvaj lapanakni tatꞌaꞌal ni Jesús kun ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ancha lakatin ixtavilanal pumatꞌuy laꞌachꞌixin. Taval tejkan taqasmaklhi ni ancha ixtꞌajun tapasanaꞌ ni Jesús, tatꞌasal, va tanaul: —¡Jalhachimoꞌonuꞌ, istsꞌal kꞌatꞌi ni ay jalhachimoꞌonu David, kilamapayniu ni kijnan! ");
INSERT INTO tptNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yu lapanakni va talaqꞌaymal ni laꞌachꞌixin para saqcha kataval, pero yuꞌuncha apalay tataylhaꞌal ixtꞌasatikꞌan. —¡Jalhachimoꞌonuꞌ, yu istsꞌal kꞌatꞌi ni ay jalhachimoꞌonuꞌ David, kilamapayniu ni kijnan! ");
INSERT INTO tptNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ex va chuncha ni Jesús va tayal, va lakjuntaꞌil ni laꞌachꞌixin, va lakjunil: —¿Tisuncha naunatꞌikcha kaklamakaniu ni kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ex ni yuꞌuncha tanaul: —Jalhachimoꞌonuꞌ, va iklakavananputunau. ");
INSERT INTO tptNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ex chuncha ni Jesús jalakmapaynil, va lakchꞌapanil ixlaqchulkꞌan. Ex niman talakavananchoqolcha, va tatꞌaꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ex chuncha tejkan ixtatꞌajuncha taꞌukstsꞌuninin ni Jerusalén, tachaꞌal laka putaulan Betfagé, yu xalakaꞌaspajun Olivos. Taval ni Jesús va jamalaqachal pumatꞌuy ixtꞌaltanan, ");
INSERT INTO tptNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","va lakjunil: —Kꞌapꞌinchꞌipitik yu avintꞌi lakatꞌuniy putaulan. Ancha katꞌemayapitik laqataun burra jachꞌiꞌulanti kun sasꞌatꞌa. Va kꞌaxꞌoqꞌiyapitik y kilalhiminiyau. ");
INSERT INTO tptNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Incha matichun katalhisakmin valiꞌiycha lhipꞌinapitik, ex kaꞌunapitik: “Va maqskꞌiniy ni Jalhachimoꞌonuꞌ. Va niman kamalaqachachoqoyaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ni aniy chuncha val para kataqayntsal yu maqancha tsꞌoqlhi yu ixlaqputeꞌey ixchivinti Dios, yu ixnajun: ");
INSERT INTO tptNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kaꞌunitꞌik yu tavilanal laka putaulan Jerusalén: “MiJalhachimoꞌonukꞌan va talaqmintan ni uxiknankꞌan. Va tacha kilpataniꞌ pumin laqataun burra, putaukꞌal laqataun sasꞌatꞌa yu machꞌapanan.” ");
INSERT INTO tptNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ex chuncha ni ixtꞌaltanan va taꞌalcha, va chuncha tamakal tacha lakjunil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Chuncha talhimilcha ni burra kun sasꞌatꞌa. Ex tamukꞌanil laqchꞌiti la ixpulakankꞌan. Ex ni Jesús va putaukꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yu lapanakni va ayaj lhuvaj ixtajunita. Lati talakmamal ixlaqchꞌitkꞌan lakatin. Alati va talakmamal javanan yu talaqchꞌaqxpꞌuxnil ixmaqlaqapꞌu ni kꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ex yu ixtapꞌulꞌanta kun yu astan ixtaꞌanta talaktꞌasal, va tanaul: —¡Hosana! ¡Ay kaval istsꞌal ni jalhachimoꞌonu David! ¡Katoꞌoyakal yu minta la ixtaqaꞌuti ni Jalhachimoꞌonu Dios! ¡Hosana kanaunkal laktꞌiyan! ");
INSERT INTO tptNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ex chuncha tejkan tanuchal ni Jesús ni Jerusalén, va talakchꞌilil tachun xalapanakni ni anchanu ay putaulan. Ayaj ixtalalhisakmin siya yuꞌuncha, va ixtanajun: —¿Tas ayuchacha ni aniy? ");
INSERT INTO tptNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ex yu alati lapanakni va tanaul: —Va Jesús yu laqputeꞌey ixchivinti Dios, yu machaqaꞌ Nazaret yu xaꞌestado Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ex taval ni Jesús tanuchal yu ay ixlakatajtan Dios. Tus tachun lakxkaumaxtuꞌol maqspaꞌ yu ixtatꞌajun jastꞌanan kun yu ixtatꞌajun jaꞌinin ni ancha. Va laqmapuꞌaqstaꞌol yu mesas taꞌan ixtamapaxay ixtuminkꞌan ni lapanakni y vachu yu ixtꞌantsꞌikꞌan ni xastꞌanan palumax. ");
INSERT INTO tptNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ex va lakjunil: —Ixchivinti Dios yu tsꞌoqkanta va najun: “Ni kinchaqaꞌ junkan xachaqaꞌ taꞌan puskꞌinkan Dios”, pero ni uxiknankꞌan makꞌatꞌatꞌik yu ixputamaqsaqna alhavanan. ");
INSERT INTO tptNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ex ancha yu ay lakatajtan tatalakanunil ni Jesús lati laꞌachꞌixin kun lati yu lakchꞌanltꞌul, ex va lajkꞌuchꞌul. ");
INSERT INTO tptNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ni xaꞌukxtinin ni kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas va ayaj tatalqamal tejkan talaqtsꞌil yu lajꞌay axtoqnu ixmakay ni Jesús y taqasmaknil yu ixtꞌasatkꞌan yu jasꞌatꞌanin laka ay lakatajtan yu inchine ixtanajun: “¡Ay kamakakal yu sasꞌatꞌa ni ay jalhachimoꞌonu David!” ");
INSERT INTO tptNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Va tajunil ni Jesús: —¿Asmatꞌa yu tatꞌajun naunan? Va lakjunil ni Jesús: —Chun, ijqasmatꞌa. ¿Jantu pꞌutꞌeꞌeyatꞌik ixchivinti Dios taꞌan tsꞌoqkanta yu lhichiviniy ni aniy? Inchine najun: Uxintꞌi laqxtaqniy jatapastakꞌati yu lakstꞌuniy jasꞌatꞌan mas yu vananaj tatsꞌikꞌiy para ay katamakan kun kꞌus milpati. ");
INSERT INTO tptNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ex chuncha va lakmakaulcha, va alcha laka putaulan Betania. Ancha loqojchalcha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chuncha tejkan puvakuj val, va minchoqochal ni Jesús ni Jerusalén, va chavanilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ex laqtsꞌil aqataun xakꞌiu ni higo yu ancha ixyal ni lakatin. Ex ni Jesús va aqtayl lakxkajuy ni xaꞌunikan pero jantu tuꞌuchun katemanil. Vamun va xaxqoy ixjukꞌal. Ex chuncha ni Jesús va junil ni anchanu xakꞌiu ni higo: —¡Chavaycha ijkunan tus jantucha aqtaun kꞌaxtꞌaqyeꞌe mijataukꞌati! Ex va chuncha va niman xixtayal ni kꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tejkan chuncha talaqtsꞌil yu ixtꞌaltanan tus vak takꞌatsal. Talhisakmil ni Jesús, va tajunil: —¿Valiꞌiycha niman xaxixa ni xakꞌiu ni higo? ");
INSERT INTO tptNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ex ni Jesús va naul: —Laqsaval klajunau. Ni uxiknankꞌan incha lhakꞌapꞌupꞌinatꞌik y jantu putꞌuy jatapastakꞌati makꞌayatꞌik ex jantu vamun yuꞌ lay kamakꞌatꞌik tacha kmakanil xakꞌiu ni higo. Vachu lay kꞌaꞌunitꞌik ni aniy aspajun: “Kꞌaꞌostꞌicha ni ancha, kꞌapꞌinchꞌicha lakamar”, y laqsaval chuncha kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Incha lhakꞌapꞌupꞌinatꞌik ni laqsaval kalaꞌaꞌiyapitik yu skꞌinatꞌik ni Dios, ex mas tisuncha kaval kalaꞌaꞌiyapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ex va chuncha ni Jesús tanuchal laka ay lakatajtan. Tejkan ancha ixtꞌajun malaniniꞌ, ex talakanunil ni xaꞌukxtinin ni kuras kun yu xalajꞌaynin lapanakni ni israelitas. Ex ni yuꞌuncha talhisakmil, va tajunil: —¿Taꞌayucha xtaqnin lhachimoꞌon ni kꞌamakꞌatꞌi yu aniy axtoqnu? ¿Taꞌayuchacha lhijunan ni chuncha kꞌamakꞌatꞌi? ");
INSERT INTO tptNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ex ni Jesús lajqaltayl, va lakjunil: —Kitꞌin vachuꞌ klalhisakmiyau taun jalhisakminti. Incha kilajunau, ex yu kitꞌin vachu klajunau taꞌayucha kixtaqniy lakatin ni klakmakay yu axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tas ayucha malaqachalcha ni Juan jamaqchajꞌavanaꞌ? ¿Va Dios u va lapanaki? Ex chuncha va taꞌaqtaynilcha talalhisakmiy siya yuꞌuncha, va talajuniy: —Chavay incha kajunau va Dios, ex ni yucha va lay kintajunin: “¿Ex valiꞌiycha jantu kalhakꞌapꞌupꞌintꞌik?” ");
INSERT INTO tptNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chavay incha kajunau va lapanaki yu xtaqnil ixlhachimoꞌon ni Juan para kamaqchajꞌavanal, ex talhauniyau ni lapanakni, yuꞌuncha va talhilay ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ex chuncha tajunil ni Jesús: —Jantu ijkꞌatsayau. Ex chuncha ni yucha va lakjunil: —Ex ni kitꞌin vachuꞌ jantu kaklajunau tas ayucha kixtaqnil lhachimoꞌon yu ikpumakay ni aniy axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ex astan ni Jesús va lakjunil: —¿Tas lhilayatꞌikcha ni aniy? Qayntaun joꞌati ixlhitꞌajun qayntꞌuy istsꞌalan. Ex va junil yu qayntaun istsꞌal: “Chavay, kintsꞌal, kꞌapꞌinchꞌiycha tapatsan la kiꞌuvaskꞌan.” ");
INSERT INTO tptNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ex istsꞌal va naul: “Jantu kꞌuxaꞌan.” Pero taval va mapaxachoqol ixjatapastakꞌati, va al tapatsan. ");
INSERT INTO tptNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Taval ni xapay va laqꞌal yu aqayntaun istsꞌal, vachu va chun junil. Ex ni yucha va naul: “Chun, kajkꞌanaꞌ.” Pero mas chuncha naul, va jantu kaꞌal tapatsan. ");
INSERT INTO tptNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ex chuncha ¿Tasꞌayucha yu pumatꞌuy makal yu tacha lhinaul yu ixpaykꞌan? Ex ni yuꞌuncha va tanaul: —Yu xapꞌunaj. Chuncha ni Jesús va lakjunil: —Laqsaval iklajunau. Yu xachꞌinin impuestos kun yu maqtaqalhinin xanatin ni yuꞌuncha pꞌunaj katatanutachal taꞌan lhachimoꞌonun ni Dios xajantu ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ni Juan yu jamaqchajꞌavanaꞌ, yucha kilachil jamalaniniꞌ yu tacha lay vas kꞌapꞌutsꞌukꞌutꞌik, pero yu uxiknankꞌan jantu kꞌalhakꞌapꞌupꞌintꞌik. Chavay yu jachꞌinin ni impuestos kun yu jamaqtaqalhinin xanatin, ni yuꞌuncha talhakapuꞌal. Chavay uxiknan mas laqtsꞌintꞌik yu tapasal, jantu kamapꞌaxatꞌik mimputsukukꞌan y jantu kalhakꞌapꞌupꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Chavay kaꞌasmaktꞌik yu aniy chivinti yu xtaꞌa jatapastakꞌati. Qayntaun joꞌati ixlhitꞌajun aqxtaun ixtꞌun. Va ancha chꞌal uvas. Va tus ox korrarnul, ex chuncha makal aqataun xapachꞌikni. Vachu makal aqataun talman chaqaꞌ taꞌan katataulal yu xalhistaknan. ’Ex va laqxtaqnil amedias lati ixꞌoqxtamatin, va al tiꞌukxuntayan maqati. ");
INSERT INTO tptNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Taval va lakachilcha ixpupꞌuxkan. Ex ni yucha va laqmalaqachalcha lati ixꞌoqxtamatin para kataskꞌinilcha yu paxtoqniycha ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero yu oqxtamatin yu ixtalhistakta ni tꞌun jantu katalhipaꞌinil. Tachꞌapal ixtꞌaꞌoqxtamatinkꞌan. Qayntaun talaqanaqmal, yu aqayntaun tamaqnil, y yu aqayntaun va talakatꞌalmaqnil kun chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ex chuncha yu manavin ni tꞌun va aaqtaun laqmalaqachachoqol yu alati ixꞌoqxtamatin, va apalay pumalhuu laqmalaqachal. Pero yu xalhistaknan vachu va chun tamakachoqol tacha yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ex chuncha taval astan yu xamanavin ni lakatꞌun malaqachal yu istsꞌal. Va ixnajun: “Yucha katatoꞌoyal.” ");
INSERT INTO tptNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero tejkan talaqtsꞌil ni tsꞌal, va talajunil siya yuꞌuncha: “Ni anu, ka yucha kapaxtoqniyacha ni lhitapatsa, chavay kaꞌau maqniniꞌ. Chuncha kijnankꞌan kachꞌapaꞌojoo tachun yu yucha kapaxtoqnil.” ");
INSERT INTO tptNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ex chuncha tachꞌapal, va tamaxtul ixlhimaqspaꞌ ni lakatꞌun, va tamaqnilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ex chuncha ni Jesús laklhisakmil, va lakjunil: —Chavay tejkan kaminaꞌ yu xamanavin ni tꞌun, ¿tas kalakmakayacha ni anchanuꞌ oqxtamatin? ");
INSERT INTO tptNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ex tanaul: —Kalakchꞌapayaꞌ, va niman kalaqmaqniyaꞌ tus jantu tsꞌuniy kalakmapayniyaꞌ ni anchanu jalaktuꞌunun, ex kalaqxtaqniyaꞌ amedias ixtꞌun alati oqxtamatin yu achaj kataxtaqnil ni jaxqanti yu kapaxtoqniyaꞌ ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ex ni Jesús va lakjunil: —¿Jantu aqtaun pꞌutꞌeꞌeyatꞌik ixchivinti Dios taꞌan tsꞌoqkanta? Inchine najun: Ni chiyux yu jantu kamapatsaputul ni yu tamakay chaqaꞌ chavay yucha yu apalay maqskꞌiniy. Chuncha makal ni Jalhachimoꞌonuꞌ, xlhiyucha tus taun kꞌatsanau. ");
INSERT INTO tptNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Xlhiyucha klajunau ni uxiknan kꞌalakmaxtꞌunikꞌanapitik ixlhachimoꞌon ni Dios. Kalaqxtaqnikanaꞌ yu alati yu katamaqxtaꞌaꞌ ox jaxqanti tacha ni yucha lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chavay incha matichun kaputaqalqoslhi ni anchanu chiyux, ex tus katalaqateꞌeꞌoyaꞌ. Vachu incha kꞌapꞌatꞌalmal matichun ni anchanu chiyux ex tus pꞌoqxni kajunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ex tejkan taqasmaklhi yu xaꞌukxtinin ni kuras kun yu fariseos ni anchanu chivinti yu xtaꞌa jatapastakꞌati, ex tamalaqasil ni va yuꞌuncha ixtꞌaunkan laklhichivinka. ");
INSERT INTO tptNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ex chuncha ni yuꞌuncha va ayaj ixtachꞌiputun ni Jesús, pero va tatalhaunichoqol ni lapanakni, yuꞌuncha ixtalhakapuꞌan ni Jesús ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ex va chuncha ni Jesús va aaqtaun aqtaychoqol jalaqlhixaqalay kun chivinti yu xtaꞌa jatapastakꞌati, va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yu xalhachimoꞌon ni laktꞌiyan va tacha qayntaun ay jalhachimoꞌonuꞌ yu malakxtuklay istsꞌal, va makaniy kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ex ni yucha jalaqmalaqachal ixꞌoqxtamatin para kataꞌal juntaꞌinin yu kataxkavaꞌil. Pero mas lajkijuntaꞌikal, va jantu kataꞌuxamil ni laka kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ex taval va aaqtaun jamalaqachachoqol yu alati ixꞌoqxtamatin, va lakjunil: “Kꞌaꞌunapitik yu jalaqxaqalakantacha katamilcha. Yu vayti alinꞌojotacha. Klhinaulcha ixmaqnika ni vakax kun alati jatalhitsukukna yu ayaj talajꞌonta y tachun alinꞌojota. Katamilcha ni laka kꞌatan. Kaꞌalinacha ni jalakxtuklati.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Taval yu ixlakjunkan ixtamil ni kꞌatan va jantu katamakal kuenta para katamil, va taꞌal la ixlhitapatsakꞌan. Qayntaun va al laqtsꞌiniꞌ ixtꞌun, yu aqayntaun va al makanaꞌ ixlhitapatsa yu pulhajay. ");
INSERT INTO tptNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yu alati va talachꞌapachal kun ixꞌoqxtamatin ni maqaliꞌ. Va tus ox talaqalhil y tamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ex tejkan chuncha kꞌatsal ni ay jalhachimoꞌonuꞌ va ayaj talqamal. Va laqmalaqachal ixtropas para kalaqmaqnil ni anchanu jamaqninin, ex chuncha va jalaqxavanil ixputaulankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ex chuncha va lakjunil ni ixꞌoqxtamatin: “Tachun alinꞌojotacha para yu xakꞌatan ni lakxtuklati pero yu ixlakjuntaꞌikan ixtamil jantucha paxtoqniy katamil. ");
INSERT INTO tptNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chavay kꞌapꞌinchꞌipitik taꞌan talapaxtoqta ni lajꞌay lakatinixnan. Kꞌalakꞌunapitik tachun yu kꞌatꞌematꞌik para katamil ni xakꞌatan lakxtuklati.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ex chuncha ni oqxtamatin va taꞌal tiꞌukxuntayanin ni jalakatinixnan. Talhijunil va taꞌayuꞌuncha yu tatemal, mas kaval laktuꞌunun, mas kaval yu jalajꞌoxin. Ex chuncha yu ixpulakna ni laqa chaqa va tus taꞌaqtsamal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Chuncha ni ay jalhachimoꞌonuꞌ va tanuchal ixpulakna va para kalaqlaqtsꞌil yu jalakjuntaꞌikanta. Ex va laqtsꞌil qayntaun lapanaki yu jantu kaꞌulal xalaqchꞌiti ni xakꞌatan lakxtuklati. ");
INSERT INTO tptNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ex ni yucha va junil: “Laqaj, ¿valiꞌiycha ixtꞌanuyachꞌitꞌa ni aniy mas jantu kꞌaꞌulatꞌi xalaqchꞌiti ni xakꞌatan lakxtuklati?” Ex ni anchanu lapanaki va jantu tsij kanaul, vamun saq ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ex chuncha ni ay jalhachimoꞌonu va jalakjunil yu ixtatꞌajun jamunun laka mesa, va naul: “Ni anchanu lapanaki kꞌachꞌanchꞌitꞌik y kꞌamaqchꞌitꞌik. Kꞌamaxtꞌutꞌikcha ixlhimaqspaꞌ taꞌan putsꞌista. Ex ancha kaqalhujtsukutachal y ancha kalaktsakꞌayaꞌ ixtatsalati.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Laqsaval ayaj qaynlhuu yu jalakjuntaꞌiy pero va lakatsꞌuniy yu jalaksaknan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ex chuncha ni fariseos taꞌanchoqolcha. Taꞌaqtaylcha tamalakchꞌantamiy ixchivintikꞌan para katajunil taun jalhisakminti, para kalal kataputislajmal kun ixchivinti ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ex chuncha tamalaqachalcha lati ixtꞌaltanankꞌan, chꞌantaun kun lati ixlapanakni ni Herodes, va para kataꞌal juninin ni Jesús. Tajunil: —Jamalaniniꞌ, ni kijnan ijkꞌatsayau ni uxintꞌi laqpꞌutꞌeꞌey yu laqsaval, y vachuꞌ jamalaninin yu laqsaval ixlakatin Dios, y jantu makꞌay kuenta yu tanajun ni lapanakni, y jantu matichun tꞌalhauniy. ");
INSERT INTO tptNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ex chuncha va knaunau kilaxtaqniu mijatapastakꞌati: ¿tas lhilaycha ni uxintꞌi? ¿Maqskꞌiniy kakmapalniu impuestos yu ay jalhachimoꞌonu Roma, u jantu? ");
INSERT INTO tptNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ni Jesús va niman xtaqnil kuenta va taun jalaqtsꞌintanunti yu talhisakmil. Ex ni yucha va jalakjunil: —Tꞌuy ukxpuꞌ makꞌayatꞌik, ¿valiꞌiycha kilalaqtsꞌintanuyaucha? ");
INSERT INTO tptNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kilamasuniu ni tumin yu lhimapalkan impuestos. Ex chuncha tamasunil aqxtaun tumin. ");
INSERT INTO tptNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tejkan laqtsꞌil ni Jesús laklhisakmil, va lakjunil: —Yu aniy ukxpuꞌ, ¿tas ayucha lapanaki ixꞌukxpu? ¿Tas ayucha ixtaqaꞌuti aniy tsꞌoqmukꞌanikanta? ");
INSERT INTO tptNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ex ni anchanu lapanakni va tanaul: —Va yu ay jalhachimoꞌonuꞌ Roma. Ex va chuncha ni Jesús va lakjunil: —Ex kꞌaxtꞌaqnitꞌikcha yu ay jalhachimoꞌonuꞌ Roma yu yucha paxtoqniy. Kꞌaxtꞌaqnitꞌikcha ni Dios yu Dios paxtoqniy. ");
INSERT INTO tptNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tejkan chuncha taqasmaklhi ni anchanu lapanakni, va tus vak takꞌatsal, tamakaulcha ni Jesús, va taꞌanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Anchanu julchan va talaqꞌal ni Jesús lati saduceos. Yuꞌuncha ixtanajun ni jantu takujchoqoy yu janinin. Ex chuncha talhisakmil ni Jesús, va tajunil: ");
INSERT INTO tptNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Jamalaniniꞌ, ni Moisés kintajunin yu tejkan niy qayntaun joꞌati yu lakxtuklatacha y jantu makajun sasꞌatꞌan, ex yu ixlaqaj katꞌatsukuchoqol ni anchanu tiyau para kalaklhitsukunil sasꞌatꞌan ixlaqaj yu nitacha. ");
INSERT INTO tptNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ex chuncha, taun julchan ixꞌalin pumatujun tꞌalaqaunin. Yu xajayaꞌ va lakxtuklal, pero niman nil. Jantu kalhitsukul sasꞌatꞌan. Ex chuncha yu ixanati va tamakaunichoqolcha ixpꞌisaqa. ");
INSERT INTO tptNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Taval ixpꞌisaqa vachu va chun xajchal. Ex yu xapumatꞌutunuꞌ vachu va chun lhitapasal. Tus talaqatapasaꞌol ni anchanu pumatujun tꞌalaqaunin. Va taniꞌol. Jantu matichun kalhitsukul sasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ex taval vachucha nil ni xanati. ");
INSERT INTO tptNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ex va chuncha, tejkan katakujchoqoyaꞌ ni janinin, ¿ex tasꞌayucha kunaꞌ ixapay ni anchanu xanati? Ni anchanu xanati tus laktꞌalakxtuklaꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ex ni Jesús lajqaltayl, va lakjunil: —Ni uxiknankꞌan jantu pꞌastꞌakꞌatꞌik yu naunatꞌik. Jantu mispꞌayatꞌik tacha tsꞌoqkanta la ixchivinti Dios. Vachu jantu mispꞌayatꞌik tacha junita ixtapꞌasta ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tejkan katakujchoqoyaꞌ ni janinin, ex ni yuꞌuncha jantucha katalakxtuklayaꞌ. Va katajunaꞌ tacha ixmayulnin Dios laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chavay tacha lhichꞌivinanatꞌik incha ni janinin katakujchoqoyaꞌ, ¿Jantu aqtaun pꞌutꞌeꞌeyatꞌik la ixchivinti Dios yu naul ni yucha? Va inchine naul: ");
INSERT INTO tptNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Kitꞌin va ixDios kunita ni Abraham, vachu ixDios kunita ni Isaac, vachuꞌ ixDios kunita ni Jacob.” Chuncha ni yucha jantu ixDioskꞌan kaval ni janinin. Va ixDioskꞌan junita yu takujta. ");
INSERT INTO tptNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tejkan chuncha taqasmaklhi ni lapanakni va tus vak takꞌatsal por yu ixmalaniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ex chuncha tejkan takꞌatsal ni fariseos ni Jesús va tus vak lakmakal ni saduceos, ex ni yuꞌuncha va tataqxtoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Qayntaun ni yuꞌuncha va ixmasuy ixlhachimoꞌonkꞌan. Ex ni yucha va ixlaqtsꞌintanuputun ni Jesús, va lhisakmil: ");
INSERT INTO tptNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Jamalaniniꞌ, ¿tas ayucha yu apalay ay yu lhinaunkan? ");
INSERT INTO tptNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ex ni Jesús va junil: —“Kꞌaꞌachꞌanin miJalhachimoꞌonuꞌ Dios kun tachun melhanuti ali tachun mijatsukunti ali tachun mijatapastakꞌati.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ni aniy yu apalay maqskꞌiniy y yucha va yu xapꞌunaj lhinaunkan. ");
INSERT INTO tptNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yu ataun lhinaunkan va laycha vachu va chun. Va inchine najun: “Kꞌapꞌaxkꞌatꞌi mintꞌamachaqaꞌ tacha pꞌaxkꞌakꞌan milaqꞌaman.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yu aniy laꞌatꞌuy chivinti yu lhinaunkan, yuꞌuncha va tacha xaputayan tachun ixlhachimoꞌon ni Moisés, ali tachun yu maqancha ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ex chuncha tejkan ancha ixtataꞌaqxtoqnun ni fariseos, laklhisakmil ni Jesús, ");
INSERT INTO tptNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","va lakjunil: —Ni uxiknan, ¿tisuncha lhipꞌastꞌakꞌatꞌikcha ni Cristo? ¿Kun taꞌayucha mintachal? Ex ni yuꞌuncha va tajunil: —Va kun David mintachal. ");
INSERT INTO tptNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ex ni Jesús va lakjunil: —¿Ex valiꞌiycha va machivinil ni Espíritu Santo ni David para kamapaqaꞌul ni Cristo tacha ixJalhachimoꞌonu? Ni David va naul: ");
INSERT INTO tptNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ni Jalhachimoꞌonu Dios junil kiJalhachimoꞌonuꞌ: “Kꞌatꞌaꞌulcha aniy la kilhijakanaj, tus tejkan kaklaqmaqalhajaꞌoyaꞌ mintꞌalaxkayan.” ");
INSERT INTO tptNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chuncha incha ni David va mapaqaꞌuy Jalhachimoꞌonuꞌ yu Cristo, ¿ex tas pulaycha kaval qayntaun yu kaminchal kun yucha? ");
INSERT INTO tptNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jantu matichun lay kaqaltayl. Ex ni anchanu julchan jantucha matichun katapujul katalhisakmil tuꞌuchun. ");
INSERT INTO tptNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Taval ni Jesús va lakjunil ni lapanakni y vachu ixtꞌaltanan: ");
INSERT INTO tptNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ni fariseos kun yu tamasuy ixlhachimoꞌon Moisés ni yuꞌuncha ixlhitapatsakꞌan va katalakmasunil ni lapanakni ixlhachimoꞌonkꞌan ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Chuncha uxiknan kꞌatꞌoꞌoyatꞌik y kꞌamakꞌanitꞌik yu talhijunancha pero jantu maqskꞌiniy kamakꞌanitꞌik tacha ixputsukkꞌan. Ni yuꞌuncha jantu chun tamakay tacha yu tanajun. ");
INSERT INTO tptNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ni yuꞌuncha talakpꞌachꞌiy yu machꞌapati yu ayaj laktsꞌinkꞌi, ayaj lhitaꞌay para kꞌamaqchꞌixtꞌi. Chuncha talakmatꞌikꞌukꞌay yu alati lapanakni pero jantu taꞌaqtayjuy mas va kun yu maktaun yu lakatꞌuniy ixmakakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ayaj tamaqamay katamakaꞌol tapuchux para katalaqtsꞌil ni lapanakni. Vachu ayaj tamaqamay kalaklhimuntichꞌikal aqxtaun listun taꞌan tsꞌoqmukꞌakanta ixchivinti Dios. Vachuꞌ ayaj tamaqamay kataꞌulal ixlaqchꞌitkꞌan yu laqlman xakiltulaxaj. ");
INSERT INTO tptNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Vachu tejkan kꞌatan jun ayaj tamaqamay katataulal laka mesa taꞌan laktoꞌoyakan. Vachu tejkan tataqxtoꞌa ni israelitas ayaj tamaqamay katataulal taꞌan tavilanal yu laktoꞌoyakan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Vachuꞌ ayaj tanajun kalakmastakꞌakal tejkan tapaxtoꞌa lapanakni lakatinixnan, va tanajun kalaqlhimapaqaꞌukal “Jamalaninin.” ");
INSERT INTO tptNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero yu uxiknankꞌan jantu maqskꞌiniy kalakꞌunkꞌantꞌik jamalaninin. Ni uxiknan va si tꞌalaqaunin untꞌatꞌik, y va qayntaun yu miJamalaninikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Vachu jantu paxtoqniy kꞌaꞌunitꞌik matichun mimpay aniy lakamunukpaꞌ. Yu mimPaykꞌan va qayntaun, y yucha alintachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Vachu jantu maqskꞌiniy kꞌalakꞌunkꞌantꞌik ukxtinin. Va qayntaun miꞌukxtinkꞌan, yucha va Cristo. ");
INSERT INTO tptNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yu xalajꞌaynin ni uxiknan maqskꞌiniy kalaqꞌaqtayjul yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yu ay makakan ixꞌaman, yucha va lakatꞌuniy kamakakanaꞌ. Y yu lakatꞌuniy makakan ixꞌaman, yucha ay kamakakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Payniꞌincha ni uxiknankꞌan yu fariseos untꞌatꞌik y vachuꞌ yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Uxiknankꞌan va malakchꞌauniyatꞌik xapuerta taꞌan ixlhachimoꞌon laktꞌiyan para jantu lay katatanuchal yu alati lapanakni. Ni uxiknankꞌan jantu tꞌanuyatꞌik y vachu jantu xtꞌaqniyatꞌik lakatin katatanuchal yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Payniꞌincha ni uxiknankꞌan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Lajꞌalhaumaxtꞌuniyatꞌik tus ixchaqakꞌan ni tiyaunin ex panij skꞌinatꞌik Dios para kamakꞌanutꞌik ni lapanakni. Xlhiyucha kꞌalaꞌaꞌiyapitik lhuvaj maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Payniꞌincha ni uxiknankꞌan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni Moisés! Va tꞌuy ukxpuꞌ makꞌayatꞌik. Va tꞌapꞌutsꞌoꞌotsꞌukꞌuyatꞌik taꞌakchun ni lakatꞌun mas tus xlhiꞌavintꞌi ni lakamar para katꞌematꞌik qayntaun yu kalhakapuꞌal tacha uxiknankꞌan. Ex maxajniyatꞌik tacha qayntaun yu kapaxtoqniyaꞌ ixmaqanlqajnati va aqtꞌuycha chuncha tacha uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Payniꞌincha ni uxiknankꞌan yu lakmapꞌulayatꞌik yu alati mas yu uxiknankꞌan va laꞌachꞌixin untꞌatꞌik. Va naunatꞌik: “Yu masavalay ixchivinti por yu ay kilakatajtankꞌan, ex jantu laqtaqal kaval mas jantu kataqayntsal yu najun. Pero incha tamasavalay ixchivinti por xaꞌoro kilakatajtankꞌan, ex chun maqskꞌiniy kataqayntsal yu najun.” ");
INSERT INTO tptNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Va laꞌachꞌixin y tontos untꞌatꞌik. ¿Taꞌayucha yu apalay xtapal lhilayatꞌik? ¿Va yu oro u va yu ay lakatajtan taꞌan lhimapatsakan ni oro? ");
INSERT INTO tptNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Vachuꞌ inchine naunatꞌik ni uxiknankꞌan: “Yu masavalay ixchivinti por xaꞌaltar kilakatajtankꞌan, yucha jantu laqtaqal kaval mas jantu kataqayntsal yu najun. Pero incha masavalay ixchivinti por yu lapaxkan yu moqslakan la xaꞌaltar kilakatajtankꞌan, ex chun maqskꞌiniy kataqayntsal yu najun.” ");
INSERT INTO tptNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Va laꞌachꞌixin y tontos untꞌatꞌik. ¿Taꞌayucha yu apalay xtapal lhilayatꞌik? ¿Va yu lapaxkan u va yu xaꞌaltar kilakatajtankꞌan taꞌan moqslakan ni lapaxkan? ");
INSERT INTO tptNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yu masavalay ixchivinti por ni xaꞌaltar kilakatajtankꞌan, vachu masavalay ixchivinti por tachun yu ancha moqslakanta. ");
INSERT INTO tptNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Vachuꞌ yu masavalay ixchivinti por ni ay lakatajtan, ex ni yucha vachu masavalay ixchivinti por Dios yu ancha alinta. ");
INSERT INTO tptNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Vachuꞌ yu masavalay ixchivinti por ni laktꞌiyan, ni yucha vachu masavalay ixchivinti por ixputaulan ni Dios y vachu por Dios yu ancha taulay. ");
INSERT INTO tptNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Payniꞌincha ni uxiknankꞌan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Xtꞌaqniyatꞌik lakatsꞌuniy milalhaꞌoxin, ali mimuvis, ali miꞌanís chuncha tacha tapaxtoqniyan kaxtꞌaqtꞌik la kilakatajtankꞌan. Pero jantu makꞌayatꞌik kuenta yu apalay maqskꞌiniy ixlhachimoꞌon ni Dios. Yu apalay maqskꞌiniy va ox vas kaꞌukxuntꞌay la mejatsukunti, va kꞌamapꞌaynin y jantu kꞌamakꞌau milhakapuꞌati. Va yucha yu maqskꞌiniy kꞌamakꞌatꞌik pero vachu jantu kꞌamakꞌau yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Uxiknankꞌan lakmapꞌulayatꞌik yu alati mas va laꞌachꞌixin untꞌatꞌik. Va tacha kꞌamaxtꞌu lakatꞌuniy xqan la mivaso pero jantu laqtsꞌin ni ancha karran tajun laqataun juki y valiꞌiy katꞌaloqtꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Payniꞌincha ni uxiknan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Ox chꞌaꞌayatꞌik ixlhimaqspaꞌ mivasoskꞌan kun mimplatoskꞌan, pero la ixpulakna tus ox taputajita yu xkiliu por miꞌakchaꞌatikꞌan y miꞌalhavantikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseos yu laꞌachꞌixin untꞌatꞌik! Maqskꞌiniy pꞌunaj kꞌachꞌaꞌanitꞌik yu ixpulakna mivasoskꞌan ex chuncha yu ixlhimaqspaꞌ vachucha kꞌus jun. ");
INSERT INTO tptNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Payniꞌincha ni uxiknan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Untꞌatꞌik va tacha putaknun yu kꞌus maqayaqaq manikanta ixlhimaqspaꞌ pero yu ixpulakna tus ox aqtsamanta xalukuti ni janinin kun tachun yu jantu ox. ");
INSERT INTO tptNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Va chuncha untꞌatꞌik. Yu tacha talaqtsꞌinan ni lapanakni, va ayaj ox talhilay, pero yu ixpulakna melhanutikꞌan va aqtsamanta kun yu jantu lajꞌox. Valiꞌiy ox makꞌakꞌanatꞌik mas jantu laqsaval kaval. ");
INSERT INTO tptNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Payniꞌincha ni uxiknan yu fariseos untꞌatꞌik y vachu yu masuyatꞌik ixlhachimoꞌonkꞌan ni israelitas. Va tꞌuy ukxpuꞌ makꞌayatꞌik. Jalakmakꞌaniyatꞌik ixputaknunkꞌan yu maqancha ixtalaqputeꞌey ixchivinti Dios. Vachu maxantilaniyatꞌik ixpanteonkꞌan yu lajꞌoxin ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ex naunatꞌik: “Ni kijnan va istsukuu maqancha tejkan ixtatꞌajun yu maqaniya kepayankꞌan, jantu ixlaqꞌaqtayjuu ixlaqmaqnika yu maqancha ixtalaqputeꞌey ixchivinti Dios.” ");
INSERT INTO tptNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chuncha lakpꞌumispꞌakꞌanatꞌik tacha ixpapanaknikꞌan yu maqancha tamaqnil yu ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chuncha kꞌamamaktꞌatꞌikcha yu maqancha taꞌaqtaynil mimpayankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Va xalapanakni tsapulin untꞌatꞌik! ¿Tas va kꞌapꞌuxajtꞌachipitikcha yu xamaqanlqajnati ni laqnin? ");
INSERT INTO tptNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Xlhiyucha ni kitꞌin kaklamalaqachaniyau yu katalaqputeꞌeniyan ixchivinti Dios y vachu yu ayaj talakpastaknan y vachu yu tamasuy ixlhachimoꞌonkꞌan ni israelitas. Pero yu uxiknan va kꞌalaqmaqniyapitik, lati kalakxtukmukꞌayapitik laka kurus, lati kꞌalaqnaqmayapitik taꞌan tꞌaqxtꞌoꞌatꞌik, y lati kalakxkꞌaylhitsꞌukꞌuyapitik putaulan por putaulan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ex chuncha tachun kajunꞌoyaꞌ milaqtaqalkꞌan yu ixlhininkꞌan tachun yu lajꞌoxin lapanakni ixtajunita yu laqmaqnikantacha. Mas tus yu Abel yu vas ixjunita ixjatsukunti, tus Zacarías yu istsꞌal Berekías, yu maqnitꞌik la kilakatajtankꞌan la ixtaꞌajna taꞌan toꞌoyakan Dios ali laka altar. ");
INSERT INTO tptNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Laqsaval klajunau, tachun ni aniy laqtaqal katalaqchanꞌoyaꞌ yu xalapanakni yu chavay taꞌalinta. ");
INSERT INTO tptNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, xalapanakni Jerusalén! Jamaqniyatꞌik yu talaqputeꞌey ixchivinti Dios y laktꞌalmaqniyatꞌik yu tamalaqachaniyan Dios. Tacha ni piyuꞌ jamaqxtoꞌa sasꞌatꞌan la ixpaqachuj, va chuncha ni kitꞌin aqlhuvaj xaklalhistakputunau pero jantu aqtaun kꞌaꞌuyujnauntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kꞌalaqtsꞌintꞌikcha, minchaqakꞌan kamakaunkanacha, jantucha lhistakkan. ");
INSERT INTO tptNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chavay klajunau, jantucha aqtaun kilalaqtsꞌinchoqoyau tus tejkan inchine kꞌanaunapitik: “Ay kamakakal yu mintacha la ixtaqaꞌuti ni Jalhachimoꞌonu Dios.” ");
INSERT INTO tptNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ex chuncha ni Jesús taxtuchal laka ay lakatajtan. Tejkan ixꞌantacha lakatin ex yu ixtꞌaltanan tatalakanunil y va tajunil para kalaqtsꞌil tas junitacha ixkꞌusixtu yu ay lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ex ni Jesús va lakjunil: —¿Laqtsꞌinꞌoyatꞌik tachun yu aniy tayanal? Laqsaval klajunau, ni aniy tus jantu katamakaunaꞌ nisin laqataun chiyux yu katalaputoqslal, tus tachun katalaqcheꞌeꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ex va chuncha taꞌalcha laka aspajun yu junkan Olivos. Ancha taulchal ni Jesús, ex yu ixtꞌaltanan tatalakanunil y saq talhisakmil, va tanaul: —Va knaunau kilajuniu tas vanancha chuncha katapasayaꞌ yu nau. Tejkan xaputamaktanacha ni lakamunukpaꞌ y kꞌatꞌanchꞌoꞌoyeꞌe, ¿tas kakpukꞌatsayaucha? ");
INSERT INTO tptNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ex chuncha ni Jesús va lakjunil: —Kꞌalhistꞌajkꞌantꞌikcha para jantu matichun katamakanun. ");
INSERT INTO tptNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ayaj lhuvaj kataminaꞌ yu katanaunaꞌ: “Ni kitꞌin va Cristo kunita.” Kalakmakanukanaꞌ qaynlhuvaj lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Uxiknankꞌan kꞌaꞌasmakyapitik ni alinta lachꞌapati aniy kun avintꞌi pero jantu maqskꞌiniy katꞌalhanantꞌik. Va chuncha maqskꞌiniy katapasaꞌelayaꞌ pero jantukaꞌ xaputamaktanacha ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yu oqxlaqtaun lapanakni katalachꞌapayaꞌ kun aꞌoqxlaqtaun lapanakni. Yu lakataun lhachimoꞌon katalachꞌapayaꞌ kun ataun lhachimoꞌon. Vachu kaꞌalinaꞌ ay chavan kun taqanꞌati y laka lhuvaj kaxkapꞌikninaꞌ ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero kun tachun ni anchanuꞌ, yucha vamun xapuꞌaqtaykan ni maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ex chuncha ni uxiknankꞌan va kꞌamaqxtꞌaqkꞌanapitik para kꞌalhimaqchꞌapꞌukꞌantꞌik y tus tachun ni lapanakni kataxkayyan por kilapanakni untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ex chuncha ni anchanu julchan qaynlhuvaj lapanakni katamakaunchoqoyaꞌ ixlhakapuꞌatikꞌan, katalaxkayyaꞌ y katalalhimaqchapuyaꞌ siya yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ex chuncha kataꞌalinaꞌ qaynlhuvaj jalaklkanan yu katanaunaꞌ ni talaqputeꞌey ixchivinti Dios. Katalakmakanuyaꞌ lhuu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ex chuncha kaꞌalinaꞌ lhuvaj laxkayti, y qaynlhuvaj jantucha katalaꞌachaniyaꞌ siya yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero yu vas kataylhaanaꞌ la ixlhakapuꞌati tus kalaꞌoyacha, ni yucha kalaqtaxtuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yu ox chivinti yu masuy tacha lhachimoꞌonun Dios yucha kalaqputeꞌeꞌokanaꞌ yu talakachux ni lakamunukpaꞌ y tus katakꞌatsaꞌoyaꞌ yu oqxlaqtamin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ni Daniel yu maqancha ixlaqputeꞌey ixchivinti Dios, va tsꞌoqlhi, va naul: “Kꞌalaqtsꞌinapitik yu jantu ox, yu ayaj xkiliu taꞌan tꞌoꞌoyatꞌik Dios” (yu puteꞌey ni aniy chivinti tsꞌanqay ox kamalaqasil). ");
INSERT INTO tptNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ex yu tavilanal laka estado Judea maqskꞌiniy kataqoslhi, katatamaqsaqlhicha laka aspajunaxnan. ");
INSERT INTO tptNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yu kataulaꞌ la ixꞌukxna ixchaqaꞌ jantu maqskꞌiniy kataꞌeltajul maxtunuꞌ ixlaqxoqta. ");
INSERT INTO tptNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yu alintachal la ixkuxtu jantu maqskꞌiniy kaminchoqol iniꞌ ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Payniꞌincha yu xanatin ni anchanu julchan yu jaꞌaynan katajunaꞌ kun yu tamatsꞌikꞌinin. ");
INSERT INTO tptNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kꞌatꞌapꞌayninitꞌik ni Dios para jantu kaval xajulchan jastaknati vachu jantu kaval xamalkuyuꞌ lhikꞌasniy tejkan kꞌaꞌosnunapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yu anchanu julchan kaꞌalinaꞌ ay maqanlqajnati yu jantu aqtaun kaꞌalil tus tejkan puꞌaqtaynil ni lakamunukpaꞌ tus chavaycha y astan jantucha kaꞌalinchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chavay incha ayaj maqan kaval ni anchanu julchan ex jantu matichun kaxajtachal. Pero ni Dios lakmapayniy yu jalaksakta xlhiyucha jantu kamakaunaꞌ maqan kataylhaꞌal ni maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ex va chuncha ni anchanu julchan, incha matichun katajunin: “Ni, kꞌalaqtsꞌintꞌik, aniycha alinta ni Cristo”, u katajunin “Avintꞌi yachal”. Pero jantu maqskꞌiniy kꞌalhakꞌapꞌupꞌinitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ni anchanuꞌ julchan kataminaꞌ yu jamakanunun. Lati katanaunaꞌ va yuꞌuncha ni Cristo. Yu alati katanaunaꞌ va yuꞌuncha yu ixtalaqputeꞌey ixchivinti Dios maqancha. Katamakayaꞌ yu lajꞌay axtoqnuꞌ kun tapꞌasta para katapumakanun mas va yu jalaksakta ni Dios, incha kalal. ");
INSERT INTO tptNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Chavaycha klajuntaucha yu katapasayakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Xlhiyucha mas katajunin: “Ancha vilchal ni Cristo taꞌan xixninta ni lakatꞌun”, pero jantu maqskꞌiniy kꞌapꞌintꞌik. Mas katajunin: “Avintꞌi alintachal apulaktaun kuarto”, pero jantu maqskꞌiniy kꞌalhakꞌapꞌupꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tejkan kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki, ex tachun ni lapanakni kintalaqtsꞌinan. Kunaꞌ tacha taun makaliukniti yu tus slauk mapulkuy taꞌan puminachal julchan y vachu tus taꞌan puꞌanachal. ");
INSERT INTO tptNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ex taꞌan kaꞌalinaꞌ yu janinin, va ancha katataqxtoꞌaꞌ ni lajꞌay tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Ex tejkan chuncha katapasalhitsukuyaꞌ ni anchanuꞌ xajulchan maqanlqajnati, ex ni julchan kaꞌukxputsꞌisaꞌ, vachu yu malkuyuꞌ jantucha kamapulkuyaꞌ. Yu jastꞌakun katapatajuyaꞌ. Yu talhitꞌajun tapꞌasta ni laktꞌiyan, yuꞌuncha kataxkapꞌikninaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ex chuncha laktꞌiyan katasuyaꞌ tuꞌuchun yu masuy ni mintacha yu Sasꞌatꞌa Lapanaki. Ex talakachux ni lakamunukpaꞌ kataqajlhutsukuyaꞌ ni lapanakni por ixtalhantikꞌan. Ex katalaqtsꞌinacha ni kitꞌin yu Sasꞌatꞌa Lapanaki kamintachal laktꞌiyan, laka taputsꞌi kun ay tapꞌasta y tachun kiꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Vachuꞌ pꞌas kaqoxanankanaꞌ. Dios kalaqmalaqachayaꞌ ixmayulnin para katamaqxtoqlhi yu jalaksakta, tus lakatꞌati ixkankatinixnan ni lakamunukpaꞌ, mas va toꞌoxtaycha kaval xtuntaun ni laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Kꞌamakꞌatꞌikcha kuenta tacha junita tejkan maqlaqapꞌun ni xakꞌiu higo, yucha va naunputun ni taꞌukstsꞌuniycha tejkan kapꞌasnanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Vachu va chun tejkan kꞌalaqtsꞌintꞌayaꞌoyapitikcha ni tꞌajun tapasanaꞌ tacha klajunau, ex chuncha kꞌakꞌatsꞌayapitikcha ni Sasꞌatꞌa Lapanaki va lakxtuyalcha laka matiꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Laqsaval klajunau, ni lapanakni yu chavay tatꞌajun, jantukaꞌ kataniꞌoyaꞌ tus katapasaꞌoꞌelayaꞌ yu klajuntau. ");
INSERT INTO tptNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yu lakatꞌun kun laktꞌiyan katamiꞌoyaꞌ pero yu kinchivinti jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Jantu matichun kꞌatsay tisuncha hora u tisuncha julchan chuncha katapasayaꞌ. Ixmayulnin Dios laktꞌiyan jantu takꞌatsay, vachuꞌ jantu ijkꞌatsay ni kitꞌin yu Sasꞌatꞌa Dios. Vamun kꞌatsay kimPay. ");
INSERT INTO tptNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tejkan kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki, ex vachu chun kunaꞌ tacha maqancha tejkan ixtꞌajun ni Noé. ");
INSERT INTO tptNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Maqancha tejkan ixtꞌajun ni Noé, tejkan jantukaꞌ ixtaꞌaqmuxtuy, ex ni lapanakni vamun ixtaꞌoqnun, ixtavajin, ixtalakxtuklay, tus tejkan tanul ni Noé laka ay barco. ");
INSERT INTO tptNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ex jantu ixtakꞌatsay incha kaꞌalinaꞌ tuꞌuchun, tus tejkan chil ni laqmixniti y laklhaꞌanꞌol tachun ni yuꞌuncha. Vachu va chun kunaꞌ tejkan kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","’Ni anchanu julchan pumatꞌuy joꞌakna katatsukutachal kuxtunin laka kuxtu. Yu qayntaun yucha kalhaꞌankanacha, y yu aqayntaun yucha kamakaunkanacha. ");
INSERT INTO tptNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Pumatꞌuy xanatin katatsukuyaꞌ skitinin. Yu qayntaun yucha kalhaꞌankanacha, y yu aqayntaun yucha kamakaunkanacha. ");
INSERT INTO tptNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Chavay kꞌalakpꞌukꞌujtꞌikcha. Jantu kꞌatsꞌayatꞌik tisuncha horacha kaminchoqoyaꞌ miJalhachimoꞌonukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kꞌakꞌatsꞌatꞌik yu klajunau, incha kakꞌatsal qayntaun xamanavin ni chaqaꞌ tavanancha kaminaꞌ ni alhavanaꞌ, ex kakujtamal y jantu kamakaul katanul matichun la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Vachu chun ni uxiknankꞌan listujcha katsꞌukꞌutꞌik. Jantu kꞌatsꞌayatꞌikcha tavanancha kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Taꞌayucha ni xalhistaknaꞌ oqxtamati yu lhiꞌaynkan y mispay lhitapatsa? Va yucha ni ixꞌukxtin kamakaunaꞌ para kalaklhistaklhi oqxtamatin y para kalakvaval tejkan tachavaniy. ");
INSERT INTO tptNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ayaj lhiꞌachantajuycha yu oqxtamati yu tꞌajuncha makaꞌonaꞌ yu ixlhijunkanta tejkan chinchoqoy ixꞌukxtin. ");
INSERT INTO tptNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Laqsaval klajunau ni ixꞌukxtin kamakauniyaꞌ kalaklhistaklhi tachun ixmaqaliti. ");
INSERT INTO tptNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero incha laktuꞌunuꞌ maqtsukuꞌ kaval, ex va kapastaklhi va kataqmaqayaꞌ ixꞌukxtin para kaminchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ex kaꞌaqtaynilcha laqlhimaqchapunuꞌ yu alati ixtꞌamaqtsukunin. Vachu kalaktꞌatsukulcha vayaꞌ y oqnuꞌ kun taꞌapꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Incha va chuncha katapasayaꞌ, ex yu xaꞌukxtin ni anchanu maqtsukuꞌ kaminchoqoyaꞌ taun julchan u taun hora tejkan jantu kapakxanꞌil. ");
INSERT INTO tptNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ex chuncha ni anchanu maqtsukuꞌ kaxtaqnikanaꞌ ay maqanlqajnati vachu chun tacha kaxtaqnikanaꞌ yu alati yu tꞌuy ukxpuꞌ tamakay. Ancha kaqalhutsukuyaꞌ y kalaktsakꞌalhitsukuyaꞌ ixtatsalati. ");
INSERT INTO tptNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Va inchine junita yu xalhachimoꞌon ni laktꞌiyan. Taun julchan pumakau jatsiꞌin taꞌalcha pakxanꞌinin qayntaun tsꞌal yu kalakxtuklayaꞌ. Va talhaꞌalcha ixmaklkukꞌan yu pumaqtajiy aceite. ");
INSERT INTO tptNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pumakis ni anchanu jatsiꞌin va listujcha ixtajunita, y yu ataun pumakis va jantu listuj kataval. ");
INSERT INTO tptNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ex chuncha yu anchanu yu jantu listuj kataval va talhaꞌal vamun ixmaklkukꞌan, jantu katalhaꞌal alati aceite. ");
INSERT INTO tptNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Chavay yu laklistus yuꞌuncha va tumpajcha talhaꞌal alati aceite para katamaꞌaqtsamachoqol ixmaklkukꞌan tejkan kamiꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","’Chuncha ni tsꞌal yu kalakxtuklayaꞌ va jantu niman kachinchal, ex taval va tus tachun taltataꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ex tejkan pakltaun tsꞌis val, va qasmakkal taun tꞌasati, va naul: “¡Mintacha ni tsꞌal yu kalakxtuklayaꞌ! ¡Kꞌatꞌaxtꞌutꞌikcha laqaꞌinin!” ");
INSERT INTO tptNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ex taꞌostaulꞌol tus tachun ni anchanu pumakau jatsiꞌin, ex taꞌaqtaynil talaqlaꞌoxiy ixmaklkukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ex chuncha yu pumakis jatsiꞌin yu jantu listujcha kataval, va tajunil yu alati: “Kilaxtaqniu lakatsꞌuniy miꞌaceitekꞌan ni kimaklkukꞌan va laycha katamixlhi.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ex yu anchanu yu laklistujcha va tanaul: “Jantu kalayaꞌ, va jantucha kintalaqchaanan kintachunkꞌan. Apalay ox kꞌapꞌintꞌikcha inin taꞌan stꞌakan.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero tejkan taꞌalcha inin ni aceite yu anchanu jatsiꞌin yu jantu laklistus kataval, exnicha chinchal yu tsꞌal yu kalakxtuklayaꞌ. Chuncha yu pumakis jatsiꞌin yu laklistus tatꞌatanuchalcha ni yucha laqa chaqa taꞌan kaꞌalinaꞌ lakxtuklati. Ex talakchaulcha ni puerta. ");
INSERT INTO tptNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ex taval tachinchoqochalcha yu alati jatsiꞌin, va tanajun: “¡Jalhachimoꞌonu, Jalhachimoꞌonu! ¡Kilamalaqltiꞌaniu!” ");
INSERT INTO tptNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ex yu tsꞌal yu kalakxtuklayaꞌ va lakjunil: “Vas klajunau, jantu klamispayau.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ex ni Jesús va naul: —Kꞌalakpꞌukꞌujtꞌikcha ni uxiknan. Jantu lhikꞌatsan tisuncha julchan u tisuncha hora kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Chavay yu xalhachimoꞌon ni laktꞌiyan va tacha qayntaun joꞌati yu ixꞌuxaꞌan maqati tus yu alakataun lakamunukpaꞌ. Pꞌunaj jalaktꞌasaꞌil ixꞌoqxtamatin y jalakmakaunil talhistakꞌati ixtumin. ");
INSERT INTO tptNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Chavay yu qayntaun va xtaqnil laqakis mil, yu aqayntaun va xtaqnil tꞌuy mil, y yu aqayntaun va xtaqnil taun mil. Ex chuncha laqxtaqnil por qayntamin va tacha ixtalhitꞌajun ixjatalanitkꞌan. Ex ni yucha taxtulcha, va alcha. ");
INSERT INTO tptNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Chavay yu laqaꞌil ni laqakis mil, yucha mapatsal ni tumin y lhajanichoqol ataun laqakis mil. ");
INSERT INTO tptNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yu laqaꞌil tꞌuy mil, vachu chun makal y va lhajanichoqol ataun tꞌuy mil. ");
INSERT INTO tptNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero yu oqxtamati yu laqaꞌil taun mil, yucha va pukutul ni lakatꞌun y va maqsaqnil ni ixtumin ixꞌukxtin. ");
INSERT INTO tptNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Tejkan maqancha val ex ni jaꞌukxtin va jalaqminchoqolcha ixꞌoqxtamatin. Va aqtayl puteꞌeniꞌ ixkuentajkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pꞌunaj chil yu laqaꞌil laqakis mil, va naul: “Kiꞌukxtin, ni uxintꞌi kꞌixtꞌaqnin laqakis mil y chavay aniy alinchoqota alaqakis mil yu klhajanil.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ex yu xaꞌukxtin va junil: “¡Ayaj ox! ¡Uxintꞌi va ox oqxtamati kꞌatꞌi y ayaj ox jalakpastaknan! Uxintꞌi la ox makꞌatꞌi mas va kun tsꞌuniy, xlhiyucha chavay kakxtaqniyan apalay lhuu jatalhistakꞌati. Kꞌatꞌanutꞌicha y kꞌatꞌaꞌachꞌaꞌutꞌicha kun kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ex taval chil yu ixlaqaꞌita tꞌuy mil, va naul: “Kiꞌukxtin, ni uxintꞌi kꞌixtꞌaqnin tꞌuy mil y chavay aniy alinchoqota alaꞌatꞌuy mil yu klhajanil.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ex yu xaꞌukxtin va junil: “¡Ayaj Ox! ¡Uxintꞌi va ox oqxtamati kꞌatꞌi y ayaj ox jalakpastaknan! Jalakpastaknancha lakatsꞌuniy yu tacha ixmakꞌay, xlhiyucha chavay kakxtaqniyan apalay lhuu jatalhistakꞌati. Kꞌatꞌanutꞌicha y kꞌatꞌaꞌachꞌaꞌutꞌicha kun kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Taval chinchal yu ixlaqaꞌita taun mil, va naul: “Kiꞌukxtin, kitꞌin kꞌatsaycha ni uxintꞌi va pꞌays joꞌati kꞌatꞌi. Xꞌaꞌiy taꞌan jantu kꞌachꞌantꞌi y laksakꞌa taꞌan jantu kꞌamamatꞌi xatꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Xlhiyucha ni kitꞌin va iktalhaunin. Yu mintumin va kmaqsaqlhi lakatꞌun. Chavay aniycha alinchoqota yu mintumin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ex yu jaꞌukxtin va naul: “¡Uxintꞌi va malhaqniꞌ y jalaktuꞌunuꞌ oqxtamati unitꞌa! Uxintꞌi kꞌatsꞌay va kxqaꞌiy taꞌan jantu ikchꞌan y klaksakꞌa taꞌan jantu kmamay xatꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Incha va ixlhipꞌi laka banco ni kintumin, ex tejkan xakminchoqol ka xaklaqaꞌichoqol kintumin kun sasꞌatꞌa.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ex ni jaꞌukxtin va lakjunil yu ancha ixtayanal: “Kꞌamaxtꞌunitꞌikcha yu taun mil, kꞌaxtꞌaqnitꞌikcha yu lhitꞌajun laqakau mil. ");
INSERT INTO tptNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yu talhitꞌajun, apalay kalaqxtaqnikanaꞌ para lhuvaj katamaqalil. Yu jantu tamaqalin, mas va lakatsꞌuniycha talhitsukuy, yucha kalakmaxtuniꞌokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chavay kꞌamaxtꞌuchꞌipitikcha maqspaꞌ yu aniy oqxtamati yu jantu ixtapal kaval. Kꞌamajꞌanchꞌipitikcha taꞌan putsꞌista ex ancha kaqalhujtsukutachalcha y kalaktsꞌakꞌalhitsukutachalcha ixtatsalati.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Tejkan kaminchoqoyaꞌ yu Sasꞌatꞌa Lapanaki kun tachun ixtapꞌasta, vachu kun tachun ixmayulnin Dios, ex ancha kataulaꞌ la ixpalhachimoꞌon kun tachun ixꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ex yu xalapanaki yu talakachux ni lakamunukpaꞌ katataqxtoꞌaꞌ la ixlakaꞌukxpuꞌ ni yucha. Kalaqlvaꞌacha siya tumpaj, tacha ni jalhistaknaꞌ jalaqlvaꞌa ni borregos kun chivos. ");
INSERT INTO tptNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kalakmulayaꞌ la ixlhijakanaj yu borregos y la ixlhijamaqxu yu chivos. ");
INSERT INTO tptNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ex chuncha ni jalhachimoꞌonuꞌ kalakjunaꞌ yu taꞌalinta la ixlhijakanaj: “Kꞌatꞌantꞌikcha yu uxiknankꞌan yu ayaj ox tamakanitan kimPay. Kalaꞌaꞌitꞌikcha yu jalhachimoꞌon yu laꞌoxikanta para uxiknan, tus tejkan puꞌaqtaynil ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tejkan kitꞌin xakchavanita, uxiknan kilavavau. Tejkan xakꞌoqputun xkan, vachu kilamaꞌotꞌuu. Vachuꞌ tejkan xaktijuyal tacha jachiniꞌ, uxiknankꞌan kilaxtaqniu taꞌan ikloqojlhi. ");
INSERT INTO tptNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Vachu tejkan maqaꞌasasa xakꞌukxuyal, uxiknankꞌan kilaxtaqniu milaqchꞌitikꞌan. Vachu tejkan xaktaqanꞌay ixkilaꞌanau laqtsꞌinin, tejkan xaktanun lakapachꞌin ixkilaꞌanau laqtsꞌinin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ex yu lajꞌoxin va katanaunaꞌ: “Jalhachimoꞌonuꞌ, ¿tavanancha xaklalaqtsꞌinau ixchꞌavaniy y iklavavau? ¿Tavanancha ixꞌoqpꞌutꞌun xkan y iklamaꞌotuu? ");
INSERT INTO tptNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tavanancha xaklalaqtsꞌinau ixꞌukxuyatꞌi tacha jachiniꞌ, y klaxtaqniu taꞌan ixloꞌojya? ¿Tavanancha maqaꞌasasa ixꞌukxuyatꞌi y iklaxtaqniu kilaqchꞌitikꞌan? ");
INSERT INTO tptNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tavanancha ixtꞌaꞌanꞌay u ixmanukꞌantꞌa lakapachꞌin ex ixlhaꞌanau laqtsꞌinin?” ");
INSERT INTO tptNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ex yu jalhachimoꞌonu va kanaunaꞌ: “Laqsaval iklajunau, incha chuncha makꞌatꞌik mas kun qayntaun lakatꞌuniy yu kintꞌalaqajun ex va tacha kilamakaniu ni kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ex chuncha ni jalhachimoꞌonuꞌ va kalakjunaꞌ yu taꞌalinta la ixlhimaqxu: “Kilajqosmajꞌaucha ni uxiknankꞌan yu maqtaqalhinin untꞌatꞌik. Kꞌapꞌinchꞌipitikcha laqnin taꞌan laꞌoxikantacha para xaꞌukxtin ni aqmoqxnun kun ixmayulnin. ");
INSERT INTO tptNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tejkan xakchavaniy, jantu aqtaun kilavavau. Tejkan xakꞌoqputun xkan, jantu aqtaun kilamaꞌotuu. ");
INSERT INTO tptNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tejkan xaktiꞌukxuyal tacha jachiniꞌ, jantu aqtaun kilamaloqojniu. Tejkan maqaꞌasasacha xakꞌukxuyal, jantu kilaxtaqniu milaqchꞌitikꞌan. Tejkan xaktaqanꞌay y tejkan xakmanukanta laka pachꞌin, jantu aqtaun ixkilaꞌanau laqtsꞌinin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Ex chuncha yuꞌuncha katanaunaꞌ: “Jalhachimoꞌonuꞌ, ¿tavanancha ixchꞌavaniycha, u ixꞌoqpꞌutꞌun xkan, u ixꞌukxuyatꞌi tacha jachiniꞌ, u maqaꞌasasa ixꞌunita, u ixtꞌaꞌanꞌay, u ixtꞌanun laka pachꞌin, y jantu tuꞌuchun klamakaniu?” ");
INSERT INTO tptNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ex yu Jalhachimoꞌonu va kalakjunaꞌ: “Laqsaval klajunau, tejkan jantu chuncha kꞌamakꞌatꞌik, mas va kun qayntaun lakatꞌuniy yu kintꞌalaqajun ex va tacha jantu kilamakaniu ni kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ex vachu naul ni Jesús: —Ex ni anchanu lapanakni kataꞌanacha laqa pamaqanlqajnivan yu jantu aqtaun miꞌojoy mas va tavanancha. Pero yu lajꞌoxin lapanakni kataꞌanacha laka jatsukunti yu jantu aqtaun kamiꞌoyaꞌ mas va tavanancha. ");
INSERT INTO tptNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ex taval tejkan laqputeꞌeꞌolcha ni Jesús ni anchanuꞌ chivinti, ex va lakjunil ixtꞌaltanan yu ixlakmalaniy: ");
INSERT INTO tptNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Uxiknan kꞌatsꞌayatꞌikcha va tꞌuxaun kaꞌalinaꞌ xakꞌatan Paxku. Ex yu kitꞌin Sasꞌatꞌa Lapanaki kakmaqxtaqkanacha para kakxtukmukꞌakal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Taval yu xaꞌukxtinin ni kura ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, vachuꞌ yu xalajꞌaynin ni israelitas, ixtataqxtoꞌa la xapuchꞌanan ixchaqa ni Caifás, yu xaꞌay xaꞌukxtin kura. ");
INSERT INTO tptNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Va tamachꞌantamil ixjatapastakꞌatikꞌan yu tacha lay katamakanuchꞌapal ni Jesús y katamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero ixtanajun: —Ka jantu kamakayau tejkan yu mero kꞌatan jun, va lay katalakchꞌilil ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ex chuncha ni Jesús ixvilchal ni Betania, la ixchaqaꞌ ni Simón yu ixlakapuchꞌiꞌojota. ");
INSERT INTO tptNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ex va laqchinchal qayntaun xanati, va lhiminta taun lakatꞌuniy lameta yu jamakanti kun chiyux yu junkan alabastro. Va ixmaꞌaqtsamata kun yu sꞌejenꞌe yu ayaj laqlhuu xtapal. Va laqxtaqemukꞌanil la ixꞌaqtsul ni Jesús tejkan ixvil laka mesa. ");
INSERT INTO tptNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ex chuncha yu ixtꞌaltanan yu ixlakmalaniy tejkan chuncha talaqtsꞌil ayaj tatalqamal va aqtayl talajuniy: —¿Valiꞌiycha xalaqamanancha ni anchanuꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ka la ox ixval va istꞌakal, va laqlhuu ixtapal y lay ixlhiꞌaqtayjukal yu kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ex ni Jesús qasmaklhi y laklhisakmil: —¿Valiꞌiycha maꞌanchꞌapꞌuyatꞌikcha ni anchanu xanati? Ayaj ox yu ixkimakaniy. ");
INSERT INTO tptNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yu kilpatanin va tacha kaꞌalinacha kun uxiknankꞌan, pero yu kitꞌin jantucha maqan kaklatꞌaꞌalinau. ");
INSERT INTO tptNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tacha ixkimakaniy ni xanati, ixkilhilakaxapay la kilakatunaj yu sꞌejenꞌe ni yucha listujcha xamakay para kilhitaknun. ");
INSERT INTO tptNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Laqsaval klajunau, mas toꞌoxtaycha xalakatꞌun ni lakamunukpaꞌ taꞌan kaputeꞌekanaꞌ yu ox chivinti, vachuꞌ kalhichivinkanaꞌ yu tacha makal ni aniy xanati, para kalhipupastakkal. ");
INSERT INTO tptNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Xaqayntaun yu pumakautꞌuy ixtꞌaltanan ni Jesús va ixjunkan Judas Iscariote. Yucha va jalaqꞌal xaꞌukxtinin ni kuras. ");
INSERT INTO tptNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Va laklhisakmil y lakjunil: —¿Tas chuncha kilaxtaqniyau para ni kitꞌin klamaqxtaqniu ni Jesús? Ex ni yuꞌuncha tamapalal va pꞌuxaunkau xatumin plata. ");
INSERT INTO tptNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tus exnicha aqtaynil puxkaulaqtsꞌin tas kalal kapumaqxtaqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tejkan ixjun yu xapꞌunaj julchan xakꞌatan tejkan ixtaꞌuy pan yu jantu kalhitayal levadura, ex yu pumakautꞌuy ixtꞌaltanan ni Jesús va tatalakanunil, va talhisakmil: —¿Tas oxtaycha lhinaꞌun para kaklalaꞌoxiniu yu xavayti Paxku? ");
INSERT INTO tptNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ex yucha lakjunil: —Kꞌapꞌinchꞌipitikcha laka ay putaulan, kꞌatꞌemayapitik qayntaun lapanaki, y kaꞌunapitik: “Va najun ni kiJamalaninikꞌan, yu kihora va ukstsꞌuniycha. Va klapasayaꞌ ni xakꞌatan Paxku la minchaqaꞌ kun kintꞌaltanan.” ");
INSERT INTO tptNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ex yu ixtꞌaltanan ni Jesús va chuncha tamakal tacha laklhijunkal. Talaꞌoxilcha xatoqoxajvayti ni xakꞌatan Paxku. ");
INSERT INTO tptNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ex chuncha tejkan putsꞌislhicha, ni Jesús ixlaktꞌavil laka mesa yu pumakautꞌuy ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tejkan ixtatꞌajuncha vaynin, ex va lakjunil: —Laqsaval klajunau, xaqayntaun ni uxiknankꞌan kimaqxtaqyaꞌ la ixtamakakꞌan yu kintaxkajiy. ");
INSERT INTO tptNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ex yuꞌuncha va ayaj tamaqaninil. Taꞌaqtaylcha talhisakmiy por qayntaminin ni Jesús, va tanaul: —Jalhachimoꞌonu, ¿ex va kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ex ni Jesús va naul: —Yu kintꞌatamajqoyaꞌ laka plato kaꞌavayaꞌ ixpan, va yucha ni kimaqxtaqyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ni kitꞌin yu Sasꞌatꞌa Lapanaki kakniyacha tacha lhitsꞌoqkanta la ixchivinti Dios. Pero payniycha yu kimaqxtaqyaꞌ. ¡Apalay ox jantu istsukul! ");
INSERT INTO tptNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Va chuncha yu Judas yu astan kamaqxtaqyaꞌ ni Jesús, va lhisakmil: —Jamalaniniꞌ, ¿ex va kitꞌin? Ex ni Jesús junil: —Chun, va tacha naꞌuncha ni uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ex va chuncha tejkan ixtatꞌajuncha vaynin, ni Jesús chꞌapal ni pan va aqtayl xtaqniy lhimalaqpuchuncha ni Dios, ex cheꞌel y jalaqxtaqnil ni ixtꞌaltanan. Va lakjunil: —Kꞌaꞌutꞌikcha yu aniy, yucha kilakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ex vachu chꞌapal ni vaso, va xtaqnil lhimalaqpuchuncha ni Dios, ex jalakmapasanil ni yuꞌuncha y lakjunil: —Kaꞌoqtꞌik mintachunkꞌan ni uxiknan. ");
INSERT INTO tptNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ni aniy va kijakꞌalna yu masuy ni Dios va taun sastꞌi chivinti jatꞌatamakajun ixlapanakni, kalakataxtuyaꞌ para kamalaqmixinikal ixtalaqalhinkꞌan lhuvaj lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Vachu klajunau, jantucha aaqtaun kajkꞌotaꞌ ni aniy xaxkan ni uva, tus tejkan kaklatꞌaꞌoqchoqoyau yu sastꞌi xaxkan uva taꞌan lhachimoꞌonun kimPay. ");
INSERT INTO tptNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tejkan tamilpaꞌol titaun milpati, va taꞌalcha laka aspajun yu junkan Olivos. ");
INSERT INTO tptNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ex ni Jesús lakjunil: —Chavay apanchꞌix tsꞌis, tachun ni uxiknankꞌan kilamakaunꞌoyau kilaqꞌaman. Chuncha tsꞌoqkanta la ixchivinti Dios yu najun inchine: “Kaksayaꞌ yu xalhistaknaꞌ, ex yu ixborregos tus tꞌikl kataputaukꞌaꞌoyaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero tejkan kajkujchoqoyaꞌ, ex kitꞌin pꞌunaj kakchaanaꞌ ni Galilea y uxiknan astan kachꞌipꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ex yu Pedro va junil: —Mas tus tachun katamakaunꞌoyan, pero yu kitꞌin jantu aqtaun kakmakaunan. ");
INSERT INTO tptNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ex yu Jesús junil: —Laqsaval ijkunan, chavay apanchꞌix tsꞌis tejkan va laycha katꞌasal ni puyux, uxintꞌi aqtꞌutu kꞌanauneꞌe ni jantu kꞌimispꞌay. ");
INSERT INTO tptNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ex yu Pedro aaqtaun naunchoqol: —Mas maqskꞌiniy kaknil kun uxintꞌi jantu kakmakaunan. Ex tachun ni ixtꞌaltanan vachu chun tanaunꞌol tacha naul ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Taval ni Jesús kun ixtꞌaltanan va tatꞌaꞌal alakataun yu junkan Getsemaní. Ex va lakjunil: —Kꞌatꞌaulatꞌikcha aniy. Yu kitꞌin ikteꞌen tapaynin avintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Va laklhaꞌal yu Pedro kun yu pumatꞌuy istsꞌalan ni Zebedeo. Ex chuncha va aqtaynilcha jamaqaninin, ");
INSERT INTO tptNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","va lakjunil: —Ayaj ikmaqaninin la kijalhanuti, va tacha kaknil kꞌatsan. Aniycha katꞌaulatꞌik, kilapakxaucha, kꞌalakpꞌukꞌujtꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ex chuncha ni Jesús va stal tiꞌal lakatsꞌuniy, talakaputꞌatamal lakatꞌun, aqtayl tapaynin, va naul: —KimPay kꞌatꞌi, incha kalal, va knajun jantu kꞌimakꞌau kaklhitapasal yu aniy lhitaꞌay maqanlqajnati. Pero jantu kaval tacha yu kitꞌin knajun, va kꞌamakꞌatꞌi tacha yu uxintꞌi naꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Taval va jalaqminchoqol yu ixtꞌaltanan taꞌan ixtavilanal, va jalaklhitajul ixtaltatanancha. Ex ni Jesús va junil ni Pedro: —¿Ex tus jantucha lay ixꞌalkꞌujyatꞌik mas va taun hora kun kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kaꞌalkꞌujtꞌikcha, kaskꞌintꞌik Dios para jantu kꞌamakꞌanukꞌantꞌik y kamakꞌatꞌik yu jantu lajꞌox. La melhanutkꞌan ox lakꞌanaunatꞌik pero jantu laqapꞌasnin kaꞌuntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ex chuncha va xaꞌaqtꞌiyunucha anchoqol skꞌiniꞌ ni Dios va naul: —KimPay kꞌatꞌi, incha jantucha tuꞌuchun lay makꞌay para kitꞌin jantu kaklhitapasal ni maqanlqajnati, ex kamakꞌatꞌi yu uxintꞌi makꞌapꞌutꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ex chuncha va aaqtaun jalaqminchoqol va laklhitajul vananaj ixtꞌaltatanan. Yu ixlaqchulkꞌan ixtalakchajuy, va ayaj ixtaltataputunta. ");
INSERT INTO tptNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lakmakaumal y anchoqol tapayniniꞌ Dios por aqtꞌutunuꞌucha y vachu va chun naunchoqol ni anchanuꞌ chivinti yu ixnajuntacha. ");
INSERT INTO tptNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ex va minchoqol taꞌan ixtavilanal ixtꞌaltanan, va lakjunil: —¿Vananaj stꞌaknantꞌatꞌik y ltꞌatꞌatꞌatꞌik? Chilcha ni hora tejkan ni kitꞌin yu Sasꞌatꞌa Lapanaki kakmaqxtaqkanacha la ixtamakakꞌan yu talaktuꞌunun lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kaꞌostꞌaulatꞌikcha, kaꞌaucha, yu kimaqxtaꞌaꞌ va ukstsꞌuniycha minta. ");
INSERT INTO tptNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ex tejkan vananaj ixtꞌajun chivin ni Jesús, chinchal ni Judas yu xaqayntaun yu pumakautꞌuy ixtꞌaltanan. Chinchal kun pumalhuvaj lapanakni tus ox talakayanal kun espada y vachuꞌ kun kꞌiu, va ixtamalaqachan yu xaꞌukxtinin kuras y vachuꞌ kun yu lajꞌay xalapanakni ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ni Judas, yu akchꞌintamanan va ixlakjunitacha tacha katapumispal, va naul: —Tejkan kakmastakꞌayaꞌ, kakiltastukyaꞌ. Yucha kachꞌiyapitik. ");
INSERT INTO tptNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ex chuncha va talakanunil ni Jesús, va junil: —¡Maqltoꞌoxay, Jamalaniniꞌ! Ex chuncha kiltastuklhicha. ");
INSERT INTO tptNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ex ni Jesús junil: —Amigo, va yu tꞌantꞌacha makanaꞌ, kamakꞌatꞌicha. Ex yu alati va tatalakanunilcha, tachꞌapal y tachꞌilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ex yu xaqayntaun ixtꞌaltanaꞌ ni Jesús va maxtul ixꞌespada, va aqatuchaqxpꞌuxlhi xaqayntaun ixꞌoqxtamati yu xaꞌukxtin kura. ");
INSERT INTO tptNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ex chuncha ni Jesús junil: —Kꞌamanuchꞌoꞌocha miꞌespada taꞌan ixtanun. Yu talachꞌapay kun espada, kun espada kataniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Jantu kꞌatsꞌay incha va kakskꞌinil ni kimPay, ni yucha lay kimalaqachanil oqxlaqkautꞌuy ixmayulnin? ");
INSERT INTO tptNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero incha va chuncha kaval, ¿ex tas pulaycha kataqayntsal ixchivinti Dios yu tsꞌoqkanta? Va najun maqskꞌiniy katapasal chuncha tacha tꞌajun tapasanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ex chuncha ni Jesús jalaklhisakmil ni lapanakni, va lakjunil: —¿Valiꞌiycha tꞌantꞌatꞌik kun espadas ali kꞌiu para kilachꞌiu va tacha qayntaun alhavanaꞌ kakval? Lhilhiy xakmalaninin yu ay lakatajtan y jantu aqtaun kilachꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero tachun yu aniy tapasay va para kataqayntsal yu maqancha tatsꞌoqlhi yu ixtalaqputeꞌey ixchivinti Dios. Ex taval va tus taqosꞌol ni ixtꞌaltanan, va ixꞌamancha tamakaul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ex yu tachꞌapal ni Jesús va talhaꞌal la ixchaqaꞌ ni Caifás, yu ay xaꞌukxtin ni kura. Ancha ixtaꞌaqxtoqnun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas vachu kun yu xalajꞌaynin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ni Pedro paqmaqati ixtixkaulhaꞌanta, tus tachaꞌal la ixpulakna xapuchꞌanan ixchaqaꞌ yu ay xaꞌukxtin ni kura. Tejkan tanuchal laktꞌataulal xalhistaknan lakatajtan, para kalaqtsꞌil tisuncha yu kalhitapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ex yu xaꞌukxtinin kuras ali tachun yu ixtaꞌalinta laqaꞌay junta va tapuxkaulaqtsꞌil taun jalaklkanti yu kataputislajmal ni Jesús para katamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Mas va lhuvajcha jalaklkanan ixtaꞌalinta pero jantu kalal katatislajmal kun jalaklkanti. Ex taval astan tachinchal apumatꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Va tanaul: —Najun ni aniy joꞌati: “Kitꞌin lay kakmaqtal ni aniy ay lakatajtan, ex laꞌatꞌutu julchan lay kakmaqayauchoqol.” ");
INSERT INTO tptNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ex yu ay xaꞌukxtin ni kura ostayal, lhisakmil ni Jesús va junil: —¿Ex jantu tuꞌuchun kanauneꞌe? ¿Tisuncha ni anchanuꞌ yu tatꞌaunan lhitislajmanan? ");
INSERT INTO tptNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero yu Jesús jantu tuꞌuchun kanaul, vamun saq tayal. Ex yu ay xaꞌukxtin ni kura va junil: —Va ijkunan la ixtaqaꞌuti ni Dios yu kujta, kꞌanau yu laqsaval. Kilajuniu incha laqsaval ni Cristo kꞌatꞌi, yu Sasꞌatꞌa Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ex ni Jesús naul: —Chun, yucha ni kitꞌin, tacha ni uxintꞌi nau. Ni uxiknankꞌan kilalaqtsꞌinau ni kitꞌin yu Sasꞌatꞌa Lapanaki, kaktaultachal la ixlhijakanaj ni Dios yu lhitꞌajun tachun tapꞌasta. Kilalaqtsꞌinau ni kakminchoqotachal laktꞌiyan laka taputsꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ex va chuncha yu ay xaꞌukxtin ni kura exlhi ixlaqchꞌiti, va naul: —¡Ni aniy lapanaki tꞌajuncha akchꞌintaman ni Dios kun ixchivinti! Jantucha apalay maqskꞌiniyau alati lapanakni para katatislajmal. Ni uxiknan asmaktꞌikcha va puꞌakchꞌintamay ni Dios kun ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tas lhilayatꞌik? Ex ni yuꞌuncha tanaul: —Yucha lhitꞌajun laqtaqal. Maqskꞌiniy kanil. ");
INSERT INTO tptNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ex chuncha talakapuchujval y talaqanaqmal. Yu alati va talakapusal. ");
INSERT INTO tptNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ex tajunil: —¡Uxintꞌi naꞌun ni Cristo kꞌatꞌi! Chavay kꞌamispꞌatꞌi taꞌayucha ixlakapusayancha. ");
INSERT INTO tptNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Chavay yu Pedro ixvil maqspaꞌ laka puchꞌanan, ex qayntaun maqtsukuꞌ va talakanunil, va junil: —Uxintꞌi vachuꞌ ixtꞌaꞌukxuyatꞌi ni Jesús yu machaqaꞌ Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero ancha la ixtalhavaxtu ni lapanakni ni Pedro va naul: —Jantu laqsaval kaval. Jantu ijkꞌatsay tisuncha tꞌaꞌuncha lhichivin. ");
INSERT INTO tptNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ex tejkan alcha laka kiltalakxtuti, ex laqtsꞌil aqayntaun maqtsukuꞌ va lakjunil yu alati yu ancha ixtayanal: —Ni anuꞌ joꞌati vachuꞌ ixtꞌatiꞌukxuyal ni Jesús yu machaqaꞌ Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro aaqtalaqtaun va lakmasavalanil ni jantu mispay, va naul: —Laqsaval klajunau jantu kmispay ni anchanuꞌ joꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ex va panchꞌixkaꞌ val, yu ancha ixtayanal va tatalakanunil ni Pedro, va tajunil: —Laqsaval ni uxintꞌi vachu kꞌatꞌi xaqayntaun ni yuꞌuncha, por chuncha tꞌasuy y chuncha kꞌiltꞌaꞌun chꞌiviniy. ");
INSERT INTO tptNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ex ni yucha vas jalakmasavalanil y laqxtoqnuꞌ naul: —Jantu kmispay ni anchanuꞌ joꞌati. Ex chuncha va tꞌasalcha ni puyux. ");
INSERT INTO tptNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Taval ni Pedro va pastaklhi yu ixjunita ni Jesús: “Tejkan va laycha katꞌasal ni puyux uxintꞌi aqtꞌutu kꞌanauneꞌe ni jantu kꞌimispꞌay.” Ex ni Pedro tus pꞌas qalhujtaxtulcha maqspaꞌ va ayaj maqaninil. ");
INSERT INTO tptNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ex va chuncha tejkan tunkulcha, tachun yu xaꞌukxtinin ni kuras kun yu xalajꞌaynin lapanaki va tamachꞌantamilcha ni ixchivintikꞌan para katamaqnil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ex chuncha tachꞌilhaꞌalcha, va tamaqxtaqnilcha ni Pilato yu xagobernador romano. ");
INSERT INTO tptNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ex va chuncha ni Judas tejkan kꞌatsal ni kamaqnikanaꞌ ni Jesús yu ixmaqxtaqta va mapaxal ixjatapastakꞌati. Laqmaqxtaqnichoqol yu treinta xatumin plata ni xaꞌukxtinin kuras kun yu xalajꞌaynin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Va lakjunil: —Ni kitꞌin ikmaqtaqalhinil tejkan ikmaqxtaqlhi para kamaqnikal qayntaun lapanaki yu jantu kalhitsukul laqtaqal. Ex ni yuꞌuncha va tanaul: —Yucha jantu kintapaxtoqniyan ni kijnankꞌan. ¡Yucha ka minkuentajcha ni uxintꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ex ni Judas laqtanqalhul ni tumin laka ay lakatajtan, taxtul va ankal ixpixtuchꞌikiltaka ixlaqꞌaman. ");
INSERT INTO tptNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yu xaꞌukxtinin kuras tasakchoqol ni tumin, va tanaul: —Ni aniy tumin va tsamantacha jakꞌalnan, va yucha yu lhimapalkal ixmaqnika qayntaun lapanaki. Jantu lay mujuyau taꞌan mujukan xatumin lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ex va tamachꞌantamil ixjatapastakꞌatkꞌan para kataꞌil aqxtaun tꞌun yu ixnavin qayntaun xamakanaꞌ aqchoqoxna, chuncha para ancha katamaknul lapanakni yu alakataun machaqan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xlhiyucha ni anchanu lakatꞌun vananaj tajuniy va Xatꞌun Jakꞌalnan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Va chuncha val tacha maqancha tsꞌoqlhi ni Jeremías yu ixlaqputeꞌey ixchivinti Dios, yu najun inchine: “Tachꞌapal ni treinta xatumin plata, yu xatapal yu ixtamukꞌanita ni israelitas, ");
INSERT INTO tptNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","kun yucha taꞌinil ixtꞌun qayntaun xamakanaꞌ aqchoqoxna, chuncha tacha kilhijunil ni Jalhachimoꞌonuꞌ Dios.” ");
INSERT INTO tptNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ex chuncha va lhaꞌankal ni Jesús kun ni gobernador. Yucha va lhisakmil: —¿Uxintꞌi va yu ay xajalhachimoꞌonuꞌ kꞌatꞌi ni israelitas? Ex va naul ni Jesús: —Va tacha ni uxintꞌicha nau. ");
INSERT INTO tptNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pero tejkan ixtatꞌajuncha tislajmanan ni Jesús yu xaꞌukxtinin ni kuras kun yu xalajꞌaynin ni lapanakni, ex ni yucha va valiꞌiy saq ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Xlhiyucha ni Pilato va lhisakmil: —¿Jantu kꞌaꞌasmaktꞌi tachun yu tatꞌaunan lhitislajmanan? ");
INSERT INTO tptNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ni Jesús mas va laqataun chivinti jantu kaqaltayl. Ex tus taun lhilal ni gobernador. ");
INSERT INTO tptNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tejkan xakꞌatan Paxku ixjun, ex yu gobernador va si ixxꞌotꞌa qayntaun tachꞌin yu ixtalaksakꞌa ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Exnicha ixꞌalin qayntaun tachꞌin yu ayaj ixmispakan, va ixjunkan Barrabás. ");
INSERT INTO tptNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ex chuncha tejkan ixtaꞌaqxtoqnun ni lapanakni, ni Pilato va laklhisakmil, va naul: —¿Taꞌayucha naunatꞌik oxamaktaun kakmakaul? ¿U va Barrabás u va Jesús yu junkan Cristo? ");
INSERT INTO tptNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ni Pilato ixkꞌatsay va ixtamaqxtaqta ni Jesús por ixꞌakchaꞌatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tejkan vananaj ixvil la ixpulakchivin, ex yu ixanati va malaqachanil chivinti, va junil: “Jantu tuꞌuchun kꞌamakꞌanin ni anchanu lapanaki yu jantu kalhitsukul laqtaqal. Kutancha tsꞌis va taxtuj klhiꞌaqlaqavanal ni anchanu lapanaki.” ");
INSERT INTO tptNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero yu xaꞌukxtinin kuras kun yu xalajꞌaynin ni lapanakni va taxaqalal ixtalhavaxtu lapanakni para kataskꞌinil kaxꞌoqkal ni Barrabás y para kamaqnikal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ex chuncha yu gobernador va aaqtaun jalaklhisakmil ni lapanakni, va lakjunil: —¿Taꞌayucha naunatꞌik kakmakaul oxamaktaun ni aniy pumatꞌuy lapanakni? Va tanaul: —¡Va Barrabás! ");
INSERT INTO tptNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ex yu gobernador va laklhisakmichoqol, va naul: —¿Ex tisuncha kakmakayacha kun ni Jesús, yu junkan Cristo? Ex va taqaltayanal, va tamatꞌasal: —¡Kamakxtukmukꞌakal laka kurus! ");
INSERT INTO tptNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pero yu Pilato va lakjunchoqol, va naul: —¿Tisuncha laqtaqal makata? Pero ni yuꞌuncha aaqtalaqtaun tamatꞌasachoqol, va tanaul: —¡Kꞌamakxtꞌukmukꞌacha laka kurus! ");
INSERT INTO tptNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ex laqtsꞌil ni Pilato ni jantucha lay tuꞌuchun makay. Yu lapanakni va apalaycha ixtalakchiviniy y ixtatꞌasay kun lhilukuj. Chuncha ni Pilato va malaqachanil ixꞌika xkan, va makchaꞌal la ixlakaꞌukxpukꞌan ni lapanakni y lakjunil: —Ni kitꞌin jantu kilaqtaqal kunaꞌ ixmaqnika ni aniy ox lapanaki. Tapaxtoqniyan ni uxiknan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Chuncha tus tachun ni lapanakni va tanaul: —Chun, ni kijnan y vachuꞌ kesꞌatꞌankꞌan va kilaqtaqalchkꞌan kunaꞌ ni ixlhinin. ");
INSERT INTO tptNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ex chuncha ni Pilato va oxamaktaun makaulcha ni Barrabás. Ex lhinaul ixmaqanaqka ni Jesús y maqxtaqlhi para kamakxtukmukꞌakal. ");
INSERT INTO tptNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ex chuncha yu ixtropas ni gobernador va talhaꞌal ni Jesús la ixchaqa ni gobernador. Ancha laqmaqxtoqkal yu alati tropas tus xvilhin tamalaqachoqoxnul. ");
INSERT INTO tptNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tamajꞌanil ixlaqchꞌiti y tamulanil aqxtaun laqchꞌiti yu xlapul. ");
INSERT INTO tptNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Tamalakpatanul taun korona yu ixlhimakakanta jaltukun, y tamachꞌapal laqataun palik la ixlhimajkanaj. Ex taꞌaqtsoqoqtanil la ixlakaꞌukxpu, talaktuꞌul, va tajunil: —¡Katsukuꞌalil yu ay xalhachimoꞌonuꞌ ni israelitas! ");
INSERT INTO tptNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Va talakapuchujval, ex kun ni anchanu palik yu ixlhaꞌanta, va talhilaqapanaqchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tejkan talaktuꞌuꞌolcha ex tamaxtunichoqol ni xlapul laqchꞌiti, tamulanichoqol yu ixlaqchꞌiti y talhaꞌalcha para kataxtukmukꞌal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tejkan ancha tataxtul, tapaxtoqlhi qayntaun joꞌati yu junkan Simón yu machaqaꞌ Cirene. Talhijunil laqatapꞌasta kalhaꞌal ixkurus ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tachaꞌal lakataun aspajun yu ixjunkan Gólgota (va naunputun xajalukuti aqtsul). ");
INSERT INTO tptNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ancha tamaꞌotul ni Jesús xaxkan uvas yu skajtacha yu lhiyaukanta taun kꞌuchꞌu para jantu ayaj kaꞌukskꞌatsal. Pero tejkan kilkꞌatsal ni Jesús ex jantu kaꞌoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tejkan tamakxtukmukꞌaꞌol laka kurus, ex aqtayl tamakay suerte para taꞌayucha katamakaunil ixlaqchꞌiti. Ex va chuncha taqayntsal tacha maqancha istsꞌoqta yu ixlaqputeꞌey ixchivinti Dios, najun: “Talaqlvaqlhi kilaqchꞌiti y tamakanil suerte yu xakꞌulata.” ");
INSERT INTO tptNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ex chuncha ancha tataulalcha para katalhistaklhi. ");
INSERT INTO tptNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Va tatsꞌoqmukꞌanil taun chivinti la ixꞌaqtsul ni ixkurus, va najun: “Aniy va Jesús, ixJalhachimoꞌonukꞌan ni israelitas”. Va yucha talhimaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ancha vachuꞌ laktꞌaxtukmukꞌakal kun Jesús pumatꞌuy alhavanan. Qayntaun la ixlhijakanaj y yu aqayntaun la ixlhimaqxu. ");
INSERT INTO tptNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yu ancha ixtatapasay va laqxtoqnuꞌ chivinti ixtajuniy, ixtamalaklay ixꞌaqtsulkꞌan, ");
INSERT INTO tptNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","va ixtajuniy: —¡Uxintꞌi yu ixmaqtꞌatꞌi ni ay kilakatajtankꞌan ex paqtꞌutu julchan ixmaꞌayauchꞌoꞌoꞌ! Incha laqsaval va Sasꞌatꞌa Dios unitꞌa, chavay kꞌalaqtꞌaxtꞌu meꞌeman y kapꞌatꞌaꞌutꞌi laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Yu xaꞌukxtinin ni kuras ali yu xalajꞌaynin ni lapanakni ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, vachu va chun talaktuꞌul ni Jesús, va tanaul: ");
INSERT INTO tptNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ixjamalaqtaxtuy yu alati pero jantu lay laqtaxtuy ixlaqꞌaman. Incha yucha va yu ay xajalhachimoꞌonuꞌ israelitas, ex kapatajul la ixkurus y kaklhakapuꞌaniyau ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yucha lhakapuꞌan ni Dios. Chavay va Dios kamalaqtaxtul incha laqsaval achaniy. Yucha kintajuntan va Sasꞌatꞌa Dios junita. ");
INSERT INTO tptNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yu pumatꞌuy alhavanan yu ancha ixlaktꞌaxtukmukꞌakanta vachu chun laqxtoqnuꞌ chivinti tajunil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ex atunkuj va aqtaynil putsꞌisa, y taylhaꞌal tus laꞌatꞌutu putoqoxata ixputsꞌista. ");
INSERT INTO tptNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ex chuncha anchanu hora va pꞌaysni tꞌasal ni Jesús, va naul: —Eli, Eli ¿lema sabactani? (va naunputun: “KiDios kꞌatꞌi, kiDios kꞌatꞌi, ¿valiꞌiycha ni kꞌilakꞌamakꞌauntꞌacha?”) ");
INSERT INTO tptNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yu ancha ixtayanal taqasmaklhi, va tanaul: —Va tꞌajun tꞌasaꞌiniꞌ ni Elías yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ex yu qayntaun va takyauꞌal iniꞌ laqataun sponja. Va matajul laka xaxkan uva yu skajtacha, ex akatachꞌimukꞌal laka maqataun kꞌiu ex va malakanunil para kaꞌoqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero lati tanaul: —Kꞌamakꞌaucha. Kalaqtsꞌinaucha incha kaminaꞌ malaqtaxtunuꞌ ni Elías. ");
INSERT INTO tptNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Taval aaqtaun tꞌasachoqol ni Jesús, ex va nilcha. ");
INSERT INTO tptNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ex chuncha va taꞌexpakltꞌiyul yu xaꞌay kortina ni ay lakatajtan, va taꞌexminchal xꞌakpuꞌ tus xtuntaun. Vachu xkapꞌiknil ni lakatꞌun y tatampacheꞌeꞌol yu ay chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Vachu lati yu putaknun va talaqltiꞌaꞌol y pumalhuvaj ixlapanakni Dios va takujchoqol la ixlhininkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Astan tejkan takujchoqol ni Jesús la ixlhinin, ex ni yuꞌuncha tataxtul la ixputaknunkꞌan y tatanul laka ay putaulan Jerusalén yu ixnavin Dios y pumalhuu talaqtsꞌil. ");
INSERT INTO tptNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yu kapitan kun yu ixtropas yu ixtalhistakta ni Jesús va talaqtsꞌil y taꞌukskꞌatsal ni xkapꞌikniti y talaqtsꞌil tachun yu ixtꞌajun tapasanaꞌ. Ex tus ayaj tatalhanal, va tanaul: —¡Laqsaval ni aniy joꞌati va Sasꞌatꞌa Dios ixjunita! ");
INSERT INTO tptNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ancha vachu ixtayanal lhuvaj xanatin, va paqmaqati ixtatꞌajun laqtsꞌinin ni Jesús. Yuꞌuncha ixtatixkaulhimintachal tus Galilea y va ixtaꞌaqtayjulhiminta. ");
INSERT INTO tptNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lati ni yuꞌuncha va yu María Magdalena ali María yu ixnatikꞌan ni Santiago kun José, ali ixnatikꞌan yu istsꞌalan Zebedeo. ");
INSERT INTO tptNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Va chuncha ixtꞌajuncha putsꞌisniꞌ tejkan chaꞌal qayntaun maqaliꞌ yu ixjunkan José yu xamachaqaꞌ Arimatea ixjunita. Yucha vachuꞌ ixtꞌaltanaꞌ ni Jesús ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ni José va laqꞌal ni Pilato y va skꞌinil ixlakatunaj ni Jesús. Chuncha yu Pilato lhinaul kaxtaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ex ni José va pꞌuxlhi ixlakatunaj ni Jesús y pamilil kun aqxtaun kꞌus laqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Kiimaꞌanil ixlakatunaj taꞌan sastꞌi ixpukutunuta taun talpa yu yucha ixnavin. Malakchaunilcha xakiltalakxtuti kun aqxtaun ay chiyux. Taval anchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pero yu María Magdalena kun yu aqayntaun María va ancha ukstsꞌuniy ixtavilanal taꞌan maꞌakal ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ex va chuncha ataun julchan val, va xajulchan jastaknati. Ex yu xaꞌukxtinin ni kuras ali yu fariseos va talaqꞌal ni Pilato. ");
INSERT INTO tptNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Va tajunil: —Jalhachimoꞌonuꞌ, kijnan ikpastakchoqoyau tejkan vananaj ixtꞌajun ni anchanuꞌ makanunuꞌ lapanaki, va ixnajun yu laꞌatꞌutunuꞌ julchan kakujchoqoyaꞌ la ixlhinin. ");
INSERT INTO tptNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Xlhiyucha, klaskꞌiniyau kamalaꞌachꞌan ixlhistakka taꞌan maꞌakanta ixlakatunaj tus laꞌatꞌutunuꞌ julchan. Incha jantu, ex lay kataꞌal alhaumaxtunun ixlakatunaj yu ixtꞌaltanan. Ex astan katajunil ni lapanakni ni va kujchoqotacha la ixlhinin. Incha va chuncha kaval, ex va apalaycha ay kaval ni anchanuꞌ jalaklkanti xajantu yu pꞌunaj. ");
INSERT INTO tptNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ex lakjunil ni Pilato: —Kꞌalhipꞌintꞌikcha ni tropas yu katalhistakꞌaꞌ. Kꞌapꞌinchꞌipitikcha y kꞌalhistꞌaktꞌik taꞌan maꞌakanta ixlakatunaj tacha lhilayatꞌik yu ox lhistaknati. ");
INSERT INTO tptNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ex taꞌalcha, ox tamakal kuenta taꞌan ixmaꞌakanta ixlakatunaj, va tamukꞌanil taun sello ni chiyux yu ixpumalakchaukanta. Ancha tamakaulalcha ni tropas para katalhistaknal. ");
INSERT INTO tptNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ixtapasatacha yu xajulchan jastaknati. Va tunkumintacha yu xapꞌunaj julchan laka semanaj. Ni María Magdalena kun yu aqayntaun María taꞌal laqtsꞌinin taꞌan ixmaꞌakanta ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Exnicha alil taun pꞌaysni xkapꞌikniti, va taꞌeltajul laktꞌiyan qayntaun ixmayul Dios. Taꞌukstsꞌuninil taꞌan ixmaꞌakanta ixlakatunaj ni Jesús. Va xtay moqosunil ni chiyux yu ixpumalakchaukanta y va ancha putaulal. ");
INSERT INTO tptNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yu ixmayul Dios tus olaqlnaꞌ ixtasuy tacha makaliukniti y ixlaqchꞌiti tus pꞌays yaqaq ixtasuy tacha miki. ");
INSERT INTO tptNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tejkan chuncha talaqtsꞌil yu ixtatꞌajun lhistaknan, tus taxkapꞌiknil ixtalhantikꞌan, tataqtal y tatamakaul tacha katanilcha ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ex chuncha yu ixmayul Dios va lakjunil ni xanatin: —¡Jantu kꞌatꞌalhanantꞌik! Kitꞌin kꞌatsay va tꞌaunatꞌik lakxkaunan ni Jesús yu xtukmukꞌakal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","¡Jantucha aniy katamal! Va kujchoqol la ixlhinin, chuncha tacha naul ni yucha. ¡Kꞌatꞌantꞌik laqtsꞌinin taꞌan ixmamakanta! ");
INSERT INTO tptNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tsꞌalaj kapꞌinchꞌipitik y kalakꞌunchꞌipitikcha ixtꞌaltanan ni va kujchoqotacha la ixlhinin y yucha kapꞌulꞌanaꞌ Galilea. Ancha kꞌalaqtsꞌinapitik. Va yucha yu klalhilaqmintau juninin. ");
INSERT INTO tptNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ex chuncha ni xanatin va tsꞌalaj tataspꞌikchoqol taꞌan ixmaꞌakanta ixlakatunaj pero kun talhanti y vachuꞌ kun achati. Tatakyauꞌal makꞌatsaninin ixtꞌaltanan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ex chuncha va niman laktasunil ni Jesús y lakmastakꞌal. Yuꞌuncha va tatalakanunil ni Jesús y talaqatanuꞌinil ixchꞌaja y tatoꞌoyal. ");
INSERT INTO tptNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ex chuncha ni Jesús lakjunil: —¡Jantu kꞌatꞌalhanantꞌik! Kꞌapꞌinchꞌipitik juninin kintꞌaltanan ni kataꞌal Galilea y ancha kintalaqtsꞌinaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tejkan ixtaꞌantacha ni xanatin, lati ni tropas yu ixtalhistaknanta taꞌal laka ay putaulan. Talaqputeꞌeniꞌol yu xaꞌukxtinin ni kuras tachun yu ixlhitapasata. ");
INSERT INTO tptNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ex chuncha yu xaꞌukxtinin kuras va talaqꞌal yu xalajꞌaynin para katamachꞌantamil ixjatapastakꞌatikꞌan kun yuꞌuncha. Lhuu tumin taxtaqnil yu tropas. ");
INSERT INTO tptNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Va taxaqalal, va tajunil: —Uxiknankꞌan kꞌalaqpꞌutꞌeꞌeyapitik ni tejkan tsꞌis ixjunita va iltꞌatꞌatꞌatꞌik ex yu ixtꞌaltanan ni Jesús va kitaꞌalhaumaxtul ixlakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Incha kakꞌatsayaꞌ yu tapasal ni gobernador ex ni kijnankꞌan kakxaqalayau. Ex jantucha tuꞌuchun katalhitaqmukꞌaniyan. ");
INSERT INTO tptNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ex ni tropas talaqaꞌil ni tumin y tamakal tacha laklhijunkanta. Vanaj va yucha talalaqputeꞌeniy ni israelitas tus chavaycha. ");
INSERT INTO tptNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ex taval, yu pumakautaun ixtꞌaltanan ni Jesús va taꞌal taun aspajun xaꞌestado Galilea taꞌan lhinaul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tejkan talaqtsꞌil ni Jesús, ex tatoꞌoyal pero lati jantu ox ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ex ni Jesús talakanul kun yuꞌuncha, va lakjunil: —Ni Dios kixtaqnil tachun palhachimoꞌon mas laktꞌiyan y vachu lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kꞌalaqpꞌinchipitikcha yu oqxlaqchux ni lapanakni yu taꞌalinta aniy lakamunukpaꞌ, kꞌalakmakꞌatꞌik kintꞌaltanan. Kꞌalaqmaqchꞌajꞌavatꞌik la ixtaqaꞌuti ni kimPay ali yu isTsꞌal ali yu Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kꞌalakmalanitꞌik katatoꞌoyal tachun yu klajuntau. Ni kitꞌin kaklatꞌaꞌalinau mas va tavanancha kaval, tus tejkan kamiꞌoyaꞌ ni lakamunukpaꞌ. Va chuncha kaval.");
INSERT INTO tptNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aniy aqtayniy ni ox chivinti yu lhichiviniy Jesucristo yu Sasꞌatꞌa Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ni Isaías yu ixlaqputeꞌey ixchivinti Dios va tsꞌoqlhi ni laka libro ni va najun ni Dios: Ikmalaqachay qayntaun yu kapꞌulꞌaniyan ni uxintꞌi, para kalaꞌoximanin ni lakatin taꞌan kꞌapꞌupꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Qayntaun lapanaki tꞌasay lakakꞌavin, va najun: “Kalaꞌoximanitꞌikcha ixlakatin ni Jalhachimoꞌonuꞌ. Vas kꞌamakꞌatꞌikcha para tsꞌalti katapasal.” ");
INSERT INTO tptNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ex va chuncha ni Juan yu jamaqchajꞌavanaꞌ va chinchal anchanuꞌ lakatꞌun taꞌan jantu tꞌujuꞌ chaqaꞌ. Va lakjuniy ni lapanakni ni kataꞌaqchajꞌaul para katasulcha ni tamapaxal ixjatapastakꞌatkꞌan, ex ni Dios kalaqmalaqmixinil ixtalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ex ni lapanakni yu machaqan xalakatꞌun Judea ali yu machaqan laka putaulan Jerusalén ixtalaqminꞌojoy ni Juan. Ixtalhitaulꞌojoycha ixtalaqalhinkꞌan ex ni Juan ixjamaꞌaqchajꞌavaycha xalaꞌaxkan ni Jordán. ");
INSERT INTO tptNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ixlaqchꞌiti ni Juan va jamakanti xachꞌauti ni camello, yu ixlhitampachꞌin va jaxtaꞌan. Yu ixvayti va silaqa ali xaxkan seraj yu alin lakakꞌivinan. ");
INSERT INTO tptNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ex va chuncha ni Juan ixjalaqputeꞌeniy ni lapanakni, va ixlakjuniy: —Astan kaminaꞌ aqayntaun yu apalay ay xajantu kitꞌin. Yu kitꞌin tus jantu kimpaxtoqniy para kaktsoqoqtaulal y kakmusxꞌoqnil xamusni ixvarachi. ");
INSERT INTO tptNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kitꞌin va kun xkan klamaꞌaqchajꞌavayau. Ni yucha katapumaqchajꞌavayan kun ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ex va chuncha ni Jesús va taxtuchal ni laka putaulan Nazaret xalakatꞌun Galilea. Yu Juan va maqchajꞌaval ancha xalaꞌaxkan Jordán. ");
INSERT INTO tptNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ex chuncha tejkan takukchoqol ni laꞌaxkan ni Jesús va niman laqtsꞌil ni laktꞌiyan va talaqltiꞌal. Ex chuncha yu Espíritu Santo va ixtaꞌeltajuminta tacha taun palumax taꞌan ixyal. ");
INSERT INTO tptNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Va qasmajkal taun chivinti ni laktꞌiyan, va junkal ni Jesús: —Uxintꞌi, kesꞌatꞌa kꞌatꞌi, ayaj ikpaxkayan. Va ayaj klhiꞌachantajuy por uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ex taval ni Espíritu Santo va lhaꞌal lakakꞌavin ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ex chuncha ni Jesús va aqtꞌuy pꞌuxaun julchan ixvilchal ni anchanuꞌ lakakꞌavin taꞌan alin jatalhitsukuti yu kꞌivitsukunin. Ancha ni Satanás va laqtsꞌintanul ni Jesús incha lay kamaqtaqalhinil. Ex tachil ixmayulnin Dios, va taꞌaqtayjul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tejkan manukalcha laka pachꞌin ni Juan ex ni Jesús va anchoqol xalakatꞌun ni Galilea. Va al laqputeꞌeniꞌ yu lajꞌox chivinti yu masuy tacha jalhachimoꞌonun ni Dios. Ni Jesús va naul: ");
INSERT INTO tptNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—Chavay va lakachilcha ni julchan tejkan kalhachimoꞌonunaꞌ ni Dios. Kꞌamapꞌaxatꞌikcha mijatapastakꞌatkꞌan, kalhakꞌapꞌupꞌintꞌikcha yu lajꞌox chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Taval ni Jesús va ixkiltaukꞌaꞌanta ixkilpaꞌ lakamar Galilea. Ancha laqtsꞌil pumatꞌuy joꞌakna, va Simón kun ixlaqaj, Andrés. Ni yuꞌuncha va ixtatꞌajun mujunun ixchꞌoqxkꞌan lakamar. Va xachꞌapanan jatanti ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ex chuncha ni Jesús va lakjunil ni anchanuꞌ pumatꞌuy joꞌakna: —Kilatꞌamiucha ni kitꞌin. Chavay tꞌemayatꞌik va jatanti pero kitꞌin kaklamakayau para kalaktꞌematꞌik lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ex ni anchanuꞌ joꞌakna va niman tamakaulcha ixchꞌoqxkꞌan, va tatꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ex chuncha tejkan va ukstsꞌuniykaꞌ ixtaꞌanta, ex ni Jesús vachu jalaktemal yu istsꞌalan ni Zebedeo, yu Santiago ali Juan. Va ixtꞌatꞌajun laꞌoxinin ixchꞌoqxkꞌan laka barco. ");
INSERT INTO tptNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ni Jesús va niman lakjuntaꞌil ni Santiago kun Juan. Ex tamakaulcha laka barco ixpaykꞌan ali yu oqxtamatin, va tatꞌaꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ex taꞌalcha, va tachaꞌal laka putaulan Capernaúm. Tejkan xajulchan jastaknati val, ni Jesús niman tanul laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas, va aqtaylcha jamalaninin. ");
INSERT INTO tptNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ex ni lapanakni yu ixtaqalasmatꞌa va tus vak takꞌatsal. Ni Jesús ixjamalaninin tacha qayntaun pꞌas jalhachimoꞌonuꞌ y jantu kamalaninil tacha yu ixtamasuy ixlhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anchanuꞌ laqa chaqaꞌ va ixvil qayntaun joꞌati yu ixlhitꞌajun taun jantu ox espíritu. Tꞌasal, va naul: ");
INSERT INTO tptNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Valiꞌiycha kilaꞌakxkauyaucha ni kijnan, Jesús, machaqaꞌ Nazaret kꞌatꞌi? ¿Va tꞌantꞌa para kilalaktꞌilhiu? Yu kitꞌin ikmispayan, ni uxintꞌi va yu ixnavin Dios kꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ni Jesús va laqꞌaymal ni anchanuꞌ jantu ox espíritu, va junil: —¡Saqcha kaꞌuntꞌi! ¡Kꞌamakꞌaucha ni aniy joꞌati! ");
INSERT INTO tptNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ex va chuncha ni anchanuꞌ jantu ox espíritu va aqtaun pꞌas maxkapꞌiknichoqol ni anchanuꞌ joꞌati, va tus pꞌas tꞌasal, ex chuncha va makaunchoqolcha ni joꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ex chuncha yu ancha ixtaꞌalinta va tus tachun tatalhananꞌol. Va aqtaylcha talalhisakmiy siya yuꞌuncha, va talajuniy: —¿Tis va suncha ni aniycha? ¡Va taun sastꞌi jatapastakꞌati yu malaniy! Tacha qayntaun yu lhitꞌajun tapꞌasta. Jalaklhijuniy yu jantu lajꞌox espíritus, ex yuꞌuncha taqalasmatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ex chuncha ixtalhichiviniy tacha ixmakay ni Jesús va tus talakachux xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Taval tejkan tataxtuchal ni laqa chaqaꞌ, ex ni Jesús ali Juan ali Santiago va tamil la ixchaqakꞌan ni Simón ali Andrés. ");
INSERT INTO tptNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ancha ixmal ixꞌatinaꞌ ni Simón, va ixchꞌapata skakati. Tejkan tanul ni Jesús niman puteꞌenikal ni va taqanꞌay. ");
INSERT INTO tptNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ex va chuncha ni Jesús talakanunil, chꞌapanil ixmakaꞌ, va maꞌostaulnil. Ex ni xanati va makaunchoqol iskakati, aqtaylcha jalakvavay. ");
INSERT INTO tptNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ex chuncha tejkan va laycha kaputsꞌislhicha, tejkan anchalcha ni julchan, ni lapanakni va talhaꞌanil ni Jesús qaynlhuvaj taqanꞌanin vachu kun yu ixtalhitꞌajun yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ex tus tachun xalapanakni ni anchanuꞌ putaulan va tus tataqxtoqꞌol la xamatiꞌ laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ex va chuncha ni Jesús va jalakmaꞌayajnichoqol lhuvaj taqanꞌanin yu ixtalhitꞌajun pulhuu ixtaqanꞌatkꞌan. Vachu jalakmaxtunil lhuvaj yu jantu lajꞌox espíritus yu ixtalhitꞌajun. Pero jantu kalaqxtaqnil lakatin para katachivinil ni espíritus. Yuꞌuncha ixtamispaycha taꞌayucha ixjunita ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Va chuncha yu ataun puvakuj val, va ixputsꞌistakaꞌ, ni Jesús ostaulal, va taxtul laka putaulan, va xꞌaman al skꞌiniꞌ Dios lakakꞌivin. ");
INSERT INTO tptNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ex ni Simón kun yu alati ixtꞌaltanan va taꞌal lakxkaunan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ex chuncha tejkan tatemal, va tajunil: —Tus tachun ni tatꞌaunan lakxkaunan. ");
INSERT INTO tptNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ex chuncha ni Jesús va naul: —Kaꞌaucha taꞌan alati putaulanaxna yu lakꞌukstsꞌuniy. Ancha vachuꞌ klaqputeꞌeyaꞌ ixchivinti Dios, va xlhiyucha kminta. ");
INSERT INTO tptNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ex va chuncha ni Jesús ixtiꞌukxuyal taꞌakapuchun xalakatꞌun Galilea. Ixlaqputeꞌey ixchivinti Dios laqa chaqan taꞌan ixtataqxtoꞌa ni israelitas. Vachuꞌ jalakmaxtunil yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ex va chuncha talakanunil ni Jesús qayntaun joꞌati yu ixtaqanꞌay, va ixlakapuchꞌita. Va taꞌaqtsoqoqtal, tapayninil, va naul: —Jalhachimoꞌonuꞌ, incha kꞌinkꞌuchꞌupꞌutꞌun, lay kꞌinkꞌuchꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ex chuncha ni Jesús mapaynil ni taqanꞌan, moqslanil ixmakaꞌ, va junil: —Chun, kitꞌin knajun palaycha kꞌaꞌunchꞌoꞌo. ");
INSERT INTO tptNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ex tejkan chuncha junkal ni taqanꞌan, va niman makaxchoqolcha ni ixlakapuchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ex va chuncha ni Jesús va ox chivijval, niman malaqachal yu ay lakatajtan, va junil ni taqanꞌan: ");
INSERT INTO tptNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Chavay ijkunan jantu matichun kalaqpꞌutꞌeꞌenin. Vamun kalaqpꞌinchiy yu kura y kalhipꞌinin milapaxkan yu tacha lhinajun ixlhachimoꞌon ni Moisés, para katakꞌatsaꞌol ni lapanakni ni palaycha unchꞌoꞌotꞌa mintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ex chuncha ni anchanuꞌ joꞌati tejkan anchoqol va aqtayl jalaqputeꞌeniy ni lapanakni yu tacha palay pujunchoqol. Ex va xlhiyucha ni Jesús jantucha lay ixtanuy taꞌan alin putaulan taꞌan katalaqtsꞌil lapanakni. Vamun laka maknan ixchaꞌan taꞌan jantu ixꞌalin lapanakni. Tus ancha ixtalaqmin ni lapanakni yu talakachux machaqan. ");
INSERT INTO tptNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Taval ni Jesús aaqtaun chaꞌanchoqol laka putaulan Capernaúm. Ex chuncha takꞌatsal ni lapanakni ni va ancha ixvilchoqolcha laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ex taval va tataqxtoqlhi lhuvaj lapanakni laqa chaqaꞌ taꞌan ixvil ni Jesús. Va tus jantucha ixtalhijunita ni laka puchꞌanan. Yucha ixlaqlhixaqalay yu la ox chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ex va chuncha va lhiminkal qayntaun yu lakanita, talhimil pumatꞌati lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ex va jantu lay katalhachaꞌal ni taqanꞌan taꞌan ixvil ni Jesús, va ayaj lhuvaj lapanakni ixtaꞌalinta. Taval va tachꞌixmukꞌal la ixꞌukxna ni chaqaꞌ, va tamoqosunil tsꞌuniy xalhasaqen. Ex va ancha tapumaꞌeltajul la ixputaman ni taqanꞌan taꞌan ixvil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ex chuncha ni Jesús tejkan jalaqtsꞌilcha ni ayaj talhakapuꞌalcha, va junil ni taqanꞌan: —Kesꞌatꞌa kꞌatꞌi, yu mintalaqalhin va laqmixlhicha. ");
INSERT INTO tptNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ancha ixtavilanal vachu yu ixtamasuy ixlhachimoꞌon ni israelitas. Ex chuncha ni yuꞌuncha va aqtayl tapastakꞌa, va tanaul: ");
INSERT INTO tptNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Valiꞌiycha chuncha chiviniycha ni anu joꞌati? Va tꞌajuncha akchꞌintamanaꞌ ni Dios. Jantu matichun lay malaqmixiy ni talaqalhin. Yu talaqalhin vamun Dios lay malaqmixiy.” ");
INSERT INTO tptNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ex chuncha ni Jesús va niman ixkꞌatsay yu ixtatꞌajun pastaknan. Ex chuncha ni yucha va lakjunil: —¿Valiꞌiycha chuncha pꞌastꞌakꞌatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tisunchacha yu jantu lhitaꞌay kaval, va kꞌaꞌun ni taqanꞌan: “Yu mintalaqalhin laqmixlhicha”, u va kꞌaꞌun: “Kꞌaꞌostꞌaꞌulcha, kꞌasakchꞌoꞌocha ni mimputaman, katꞌiꞌukxuntꞌayachꞌoꞌocha”? ");
INSERT INTO tptNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Chavay klamasuniyau ni kitꞌin yu kval Sasꞌatꞌa Lapanaki klhitꞌajun lhachimoꞌon aniy lakamunukpaꞌ para kakmalaqmixil ni talaqalhin. Ex chuncha va junil yu ixlakanita: ");
INSERT INTO tptNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Chavay ijkunan ni uxintꞌi, kaꞌostꞌaꞌulcha, kꞌasakchꞌoꞌocha mimputaman, kapꞌinchꞌoꞌocha la minchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ex chuncha ni anchanuꞌ joꞌati yu ixtaqanꞌay ostaulchoqolcha, chꞌapachoqolcha ixputaman, va taxtuchoqolcha la ixtalakavantikꞌan tachun ni lapanakni yu ancha ixtayanal. Yuꞌuncha tus vak takꞌatsal, ay tamakalcha ni Dios, va tanaul: —Jantu aqtaun chuncha laqtsꞌinau tacha aniy yu xalaqtsꞌinau. ");
INSERT INTO tptNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Taval ni Jesús anchoqol aaqtaun la ixkilpaꞌ lakamar Galilea. Ancha tataqxtoqnilcha lhuvaj lapanakni, ex ni yucha va aqtaylcha jalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ex tejkan ancha antacha, laqtsꞌil qayntaun joꞌati yu ixjunkan Leví yu istsꞌal ni Alfeo, va ixvil taꞌan mapalkan impuestos. Ex ni Jesús va junil: —Kꞌintꞌatꞌatꞌi. Ex chuncha ni Leví va ostaulal, va tꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ex va chuncha ni Jesús ali ixtꞌaltanan taꞌal vaynin la ixchaqaꞌ ni Leví. Ancha vachuꞌ ixtavilanal laka mesa qaynlhuu yu xachꞌinin impuestos. Vachuꞌ ixtaꞌalinta alati lapanakni yu jamaqtaqalhinin. Va lhuvaj yu ixtatꞌaꞌanta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ancha ixtaꞌalinta lapanakni yu lakjunkan fariseos yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Talaqtsꞌil ni Jesús va chꞌantaun jalaktꞌavajin yu jamaqtaqalhinin ali yu xachꞌinin impuestos. Yuꞌuncha talhisakmil yu ixtꞌaltanan ni Jesús, va tanaul: —¿Valiꞌiycha ni mijamalaninikꞌan jalaktꞌavajin yu jachꞌinin impuestos ali yu alati maqtaqalhinin? ");
INSERT INTO tptNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ex tejkan chuncha qasmaklhi ni Jesús, va lakjunil: —Yu taꞌayajnan jantu tamaqskꞌiniy kalajkꞌuchꞌukal, tamaqskꞌiniy va yu taqanꞌanin. Kitꞌin jantu ikminta laktꞌasaꞌin yu lajꞌoxi lapanakni, va ikminta laktꞌasaꞌin yu maqtaqalhinin. ");
INSERT INTO tptNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taval taun julchan, ixtꞌaltanan ni Juan vachu kun ni fariseos va ixtatꞌajun taskꞌajanin. Ex chuncha lati lapanakni takilhisakmichil ni Jesús, va tajunil: —Ixtꞌaltanan ni Juan ali yu fariseos ayaj tataskꞌajay. ¿Valiꞌiycha jantu tataskꞌajay yu mintꞌaltanan? ");
INSERT INTO tptNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ex chuncha ni Jesús va naul: —Tejkan lakxtuklay qayntaun tsꞌal, ¿lhilay ni kataskꞌajayaꞌ yu jalakjuntaꞌikanta? Jantu lay taskꞌajay tejkan vananaj tatꞌavilanal ni tsꞌal yu lakxtuklay. ");
INSERT INTO tptNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero kaminaꞌ julchan tejkan kamaxtukanaꞌ ni anchanuꞌ tsꞌal, ex ixtꞌaltanan katataskꞌajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Jantu matichun lhilaqpumpuy aqxtaun xkujuꞌ yu atꞌaliꞌ kun yu sastꞌi lhalaqpumpum. Yu sastꞌi lhalaqpumpum va talaqatamiy, ex chuncha yu atꞌaliꞌ laqchꞌiti va apalay taꞌexa. ");
INSERT INTO tptNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Vachu jantu lay kamuꞌutꞌi yu sastꞌi xaxkan uva laka jaxtaꞌan yu atꞌaliꞌ. Yu xaxkan uva yu sastꞌi va matampaꞌay yu atꞌaliꞌ jaxtaꞌan. Ex chuncha yu xaxkan uva ali yu jaxtaꞌan yu putꞌuy va tatsꞌanqaycha. Yu xaxkan uva yu sastꞌi va kamuꞌutꞌi laka jaxtaꞌan yu sastꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Taun julchan tejkan xajulchan jastaknati ixjunita, ni Jesús ali ixtꞌaltanan va ixtapuꞌanta taꞌan ixchꞌankanta trigo. Tejkan tatꞌajun tapasanan, yu ixtꞌaltanan taꞌaqtayl talajꞌexꞌiy yu xataltsꞌi ni trigo. ");
INSERT INTO tptNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ex chuncha ni fariseos va tanaul: —Yu mintꞌaltanan, ¿valiꞌiycha tamakay lhitapatsa yu jantu xtaqkan lakatin kꞌamakꞌatꞌi tejkan xajulchan jastaknati? ");
INSERT INTO tptNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ex chuncha ni Jesús va lakjunil: —¿Ex ni uxiknan jantu aqtaun pꞌutꞌeꞌeyatꞌik yu makal ni jalhachimoꞌonu David? Taun julchan ni yucha ali ixtꞌaltanan ixtatsꞌanqaniy vayti, va ayaj tachavanil. ");
INSERT INTO tptNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ni David tanuchal la ixchaqaꞌ ni Dios, tejkan Abiatar xaꞌukxtin kura ixjunita. Ex ni David va ul ni pan yu ixmoqslanikan Dios, mas vamun ni kuras jaxtaqnikan lakatin kataꞌul. Vachuꞌ jalaqxtaqnil pan ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Vachu jalakjunil: —Dios makal xajulchan jastaknati para kaꞌaqtayjukal ni lapanaki. Ni lapanakni jantu kalakmakakal para katatoꞌoyal ni xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ni kitꞌin yu kval Sasꞌatꞌa Lapanaki klhinajun tisuncha lay makakan ni xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ex chuncha ni Jesús va tanuchoqochal aaqtaun laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. Ancha ixvil qayntaun joꞌati yu ixixta ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Va xajulchan jastaknati, xlhiyucha lati ixtamakata kuenta incha kakꞌuchꞌuyaꞌ ni anchanuꞌ joꞌatiꞌ. Va chuncha incha kakꞌuchꞌul ex laycha kataputislajmal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ex chuncha ni Jesús va junil ni yu joꞌati yu jantu lay ixmapuꞌay ixmakaꞌ: —Kaꞌostꞌaycha, kꞌatꞌanꞌajtꞌaycha aniy. ");
INSERT INTO tptNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ex va chuncha jalaklhisakmil, va naul: —Ni xajulchan jastaknati, ¿tas lhinajun kilhachimoꞌonkꞌan? ¿Lhinajun kamakꞌatꞌi yu ox u yu jantu ox? ¿Lhinajun kꞌamalaqtꞌaxtꞌutꞌi jatsukunti u va kamaqnitꞌi? Ex yuꞌuncha va tus saq tataulal. ");
INSERT INTO tptNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ni lapanakni jantu ixtaqalasmakputun, xlhiyucha ni Jesús va ixmaqanininta. Va kun lhilukujcha jalaqtsꞌil. Ex va junil ni anchanuꞌ joꞌati: —Kaxnujtꞌi mimakaꞌ. Ex ni joꞌati va xnujlhi ixmakaꞌ, va palaycha junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ex chuncha ni fariseos tataxtulcha. Yuꞌuncha ali ixtꞌaltanan jalhachimoꞌonuꞌ Herodes niman taꞌaqtaylcha talakchiviniy tacha lay katamaqnil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ex chuncha ni Jesús kun ixtꞌaltanan va taꞌal la ixkilpaꞌ ni lakamar. Lhuvaj xalapanakni Galilea tatꞌaꞌal, vachuꞌ yu machaqan xalakatꞌun Judea. ");
INSERT INTO tptNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tejkan takꞌatsal tacha makal lajꞌay axtoqnuꞌ ni Jesús, ex chuncha va talaqmil ayaj lhuvaj lapanakni, yu machaqan xalakatꞌun Judea ali laka putaulan Jerusalén ali xalakatꞌun Idumea ali yu xlhiꞌavintꞌi ixtavilananchal xalaꞌaxkan Jordán, vachuꞌ yu machaqan laka putaulan Tiro ali Sidón. ");
INSERT INTO tptNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ex ni Jesús jalaklhijunil ixtꞌaltanan listu katamakal laqataun barco para ancha katajul. Ex chuncha jantu lay katapaqasajlhi ni lapanakni mas va la lhuvaj ixtaꞌalinta. ");
INSERT INTO tptNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ni Jesús va ayaj lhuvajcha lapanakni palay ixlakmakata, va xlhiyucha ayaj lhuvaj taqanꞌanin tatalakanunil, ixtachꞌapaputun ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Vachuꞌ yu ixtalhitꞌajun yu jantu lajꞌox espíritus tejkan ixtalaqmin ni Jesús va ixtataꞌaqtsoqoqtaniy la ixlakaꞌukxpu. Va pꞌas ixtatꞌasay, ixtanajun: —¡Ni uxintꞌi Sasꞌatꞌa Dios kꞌatꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ex chuncha ni Jesús va jalaqꞌaymal, jantu ixnajun kalakmasunikal ni lapanakni taꞌayucha ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Taval ni Jesús al taun aspajun, va lakjuntaꞌil ni lapanakni yu ixnajun katatꞌaꞌal. Ex chuncha talaqꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ex ni Jesús va lakꞌulal pumakautꞌuy joꞌakna, ixnajun katatꞌatiꞌukxuntayal. Vachuꞌ kalaqmalaqachayaꞌ kataꞌal laqputeꞌenin ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Vachuꞌ jalaqxtaqnil tapꞌasta ni lay palay katamakal yu taqanꞌanin, vachuꞌ katamaxtunil yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inchineꞌ lakjunkan yu jalaksaklhi ni Jesús: ni Simón yu vachuꞌ junkal Pedro, ");
INSERT INTO tptNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","vachu yu Jacobo ali ixlaqaj Juan, yu istsꞌalan ni Zebedeo. Ni yuꞌuncha va jalakjunil Boanerges, va naunputun istsꞌalan ni laqpaqnati. ");
INSERT INTO tptNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yu alati va lakjunkan Andrés, Felipe, Bartolomé, Mateo, Tomás, ali Jacobo yu istsꞌal ni Alfeo, vachuꞌ yu Tadeo, ali Simón yu ixlhiyal xapartido cananista, ");
INSERT INTO tptNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","vachu yu Judas Iscariote, va yucha astan maqxtaqchoqol Jesús para katachꞌapal. ");
INSERT INTO tptNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ex va chuncha ni Jesús anchoqol laqa chaqaꞌ. Ex yu lapanakni va lhuvaj tataqxtoqchoqol, va tus jantucha lay tavajin ni Jesús ali ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yu ixlapanakni ni Jesús tejkan takꞌatsal tacha ixtꞌajun tapasanaꞌ, ni yuꞌuncha va taꞌal lakxkaunan, va ixtachꞌapaputun. Lati ixtanajun ni Jesús val loko. ");
INSERT INTO tptNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Taval vachu yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas taminchal ni Jerusalén, ixtanajun: —Va laqtanuy ni Beelzebú, yu xaꞌukxtin aqmoqxnuꞌ. Va yucha xtaqniy tapꞌasta, xlhiyucha lay maxtuy aqmoqxnun la ixlakatunajkꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Taval ni Jesús va lakjuntaꞌil ni anchanuꞌ lapanakni, va jalakjunil taun chivinti yu xtaꞌa jatapastakꞌati, va lakjunil: —¿Lhilay ni xꞌaman lay maxtuchoqokal ni Satanás? ");
INSERT INTO tptNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mas va tisuncha lhachimoꞌon kaval, incha tatalaqlvaꞌa y talaxkajiy ni lapanakni, ex jantucha lay tayaniy. ");
INSERT INTO tptNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Vachu va chun yu tavilanal aqataun chaqaꞌ, incha talaxkajiy, ex jantucha lay chꞌantaun katatsukul. ");
INSERT INTO tptNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Vachu va chun yu Satanás. Incha yucha ali ixtꞌaꞌaqmoqxnun talaxkajiy y talachꞌapay ex jantucha lay tatayaniy, va chuncha tapumiꞌojoy ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Jantu matichun lay tanuyachal la ixchaqa qayntaun laqapꞌays joꞌati y valiꞌiy kamaxtunil yu ixnavin. Pꞌunaj maqskꞌiniy kachꞌiꞌelal ex lay kalakmaxtunil yu ixnavin. ");
INSERT INTO tptNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Laqsaval klajunau tachun talaqalhin yu tamakay ni lapanakni lay kalaqmalaqmixinikal, vachu tachun yu tanajun yu jantu lajꞌox. ");
INSERT INTO tptNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero yu jantu lhiꞌajin ni Espíritu Santo yucha jantu lay kamalaqmixinikanaꞌ ixtalaqalhin, mas va tavanancha kaval kalhitsukuꞌalhiyaꞌ ixtalaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yuꞌuncha va ixtajuniy va ixlhitꞌajun taun jantu ox espíritu, xlhiyucha va chuncha naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ex chuncha va tachinchal ni ixnati ali ixtꞌalaqaunin ni Jesús, va maqspaꞌ tatayal, va tamalaqachanil ixjuntaꞌika. ");
INSERT INTO tptNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ex yu lapanakni yu ixtamalaqachoqoxnuta ni Jesús va tajunil: —Minati ali mintꞌalaqaunin tayanal maqspaꞌ, va talakxkauyan. ");
INSERT INTO tptNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ex chuncha ni yucha va lakjunil: —¿Taꞌayuꞌunchacha ni kinati ali ketꞌalaqaunin? ");
INSERT INTO tptNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ex chuncha ni Jesús va jalaqtsꞌil yu ixtamalaqachoqoxnuta, va naul: —Yu aniy taꞌalinta, yuꞌuncha ni kinati ali ketꞌalaqaunin. ");
INSERT INTO tptNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mas va taꞌayuchacha kaval incha makay tacha lhinajun ni Dios, ex yucha kilaqaj, yucha kintꞌalapanaki, yucha kinati. ");
INSERT INTO tptNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Taval ni Jesús aaqtaun aqtaychoqol jamalaninin la ixkilpaꞌ ni lakamar. Ayaj lhuvaj lapanakni tataqxtoqlhi ancha taꞌan ixvil. Ex yu Jesús va tajul laka barco yu ancha ixvil ni lakamar. Ex chuncha ni yucha va ancha taulalcha, ex yu lapanakni tus an tayanal la ixkilpaꞌ ni lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ni Jesús va pulhuvaj axtoqnuꞌ jalakmasuniy, lakjunil chivinti yu xtaꞌa jatapastakꞌati. Ex chuncha tejkan ixtꞌajun lakmalaninin, va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Yu chavay klajunau tus ox kaꞌasmaktꞌik. Qayntaun lapanaki va al maman ixtꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tejkan ixtꞌajun maman ixtꞌin, lati xatꞌin va tamachal lakatin. Ancha tachinchal ni tsꞌoꞌon, va taꞌuniꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yu alati xatꞌin va tamachal laka chiyuxin. Ancha va snipaqa mal yu tꞌun, xlhiyucha va niman pꞌunlhi. ");
INSERT INTO tptNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jantu pulman kataknul istsꞌansiviti, xlhiyucha tejkan pꞌas maknaul ni julchan va lakxixꞌol, talaqxauꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Alati xatꞌin tamachal laka jaltukunan. Ancha vachu pꞌunlhi pero chꞌantaun tꞌapꞌul ni jaltukun, va maqataanul, talakxixtanulcha yu xatꞌin. Ex chuncha ni anchanuꞌ xatꞌin jantu kaxtaqlhi xalhiꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Taval yu alati xatꞌin va tamachal taꞌan ayaj ox tꞌun. Ancha pꞌunlhi, ox aynlhi, va xtaqlhi taun ox jaxqanti. Ex chuncha por laqataun tꞌin xtaqlhi va treinta xataltsꞌi, yu ataun xtaqlhi va sesenta, vachu ataun xtaqlhi va tus taun ciento. ");
INSERT INTO tptNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ex chuncha vachu naul: —Incha alin mimpaqasmakkꞌan, ex kaꞌasmaktꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ex va chuncha, va xꞌamancha tamakaul ni Jesús ali yu pumakautꞌuy kun alati ixtꞌaltanan. Yuꞌuncha talhisakmil tisuncha naunputun ni anchanuꞌ chivinti yu xtaꞌa jatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ex chuncha va lakjunil: —Ni uxiknankꞌan ni Dios katamamispaniyan tacha lhachimoꞌonun, mas jantu ixmispakan. Yu jantu talhitanuy kun Dios, yuꞌuncha lakpumalanikan va chivinti yu xtaꞌa jatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ex chuncha mas talaqtsꞌin yu ikmakay va tacha jantu katalaqtsꞌil, vachu mas taqasmatꞌacha kinchivinti va tacha jantu kataqasmaklhi. Va chuncha ni jantu lay katamapaxal ixputsukukꞌan, vachu ni jantu lay kamalaqmixinikal ixlaqtaqalkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ex vachuꞌ va lakjunil: —¿Jantu malaꞌasiyatꞌik ni aniy chivinti yu xtaꞌa jatapastakꞌati? ¿Ex chuncha tas kꞌapꞌumalaꞌasiyapitikcha yu alati chivinti yu xtaꞌa jatapastakꞌati? ");
INSERT INTO tptNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yu mamay ni tꞌin yucha va tacha yu laqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yu xatꞌin yu tamachal ni lakatin ni yucha va tacha ni lapanakni yu taqasmatꞌacha ixchivinti Dios. Ex chuncha ni Satanás va niman chin, va lakmaxtunichoqoy ni chivinti yu tanuy la ixjalhanutkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yu xatꞌin yu tamachal laka chiyuxin, yucha va tacha ni lapanakni yu taqasmatꞌa ixchivinti Dios ex talaqaꞌiy kun achati. ");
INSERT INTO tptNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jantukaꞌ ox tatatꞌachꞌatay, ex vamun taun panchꞌix tatayaniy. Tejkan talhitapasay maqanlqajnati, por ni chivinti yu talhakapuꞌan, ex tamakaunchoqoycha ixlhakapuꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yu xatꞌin yu tamachal laka ltukunan, yucha va tacha yu alati lapanakni yu vachuꞌ taqasmatꞌa ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ni yuꞌuncha vananaj ayaj tapastakꞌuy ixlhitapatskꞌan ni aniy lakamunukpaꞌ. Vachu tapastakꞌuy tacha katapulhitsukulcha ixmaqalitkꞌan kun tachun axtoqnuꞌ. Chuncha takaukchoqoy ixchivinti Dios y jantu aqtaun lay lhixajachal yu lajꞌoxi la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Chavay yu xatꞌin yu tamachal taꞌan ox lakatꞌun, yucha va tacha ni lapanakni yu taqasmatꞌa ixchivinti Dios, va talhakapuꞌan. Ex chuncha yu xajachal la ixjatsukuntikꞌan va tacha taun ox jaxqanti, va tacha laqataun xatꞌin yu xtaꞌa treinta, ataun xtaꞌa sesenta, yu ataun xtaꞌa va tus taun ciento. ");
INSERT INTO tptNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ex chuncha vachu jalakjunil: —Jantu aqtaun matichun mamaqtꞌayay maklku ex maqatanuy ixqaltaꞌapuꞌ laka kajun nisin ixtaꞌapuꞌ laka putaman. Ni maklku maqskꞌiniy kꞌamukꞌa talman, ex lay ox kamapulkul. ");
INSERT INTO tptNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Vachu mas alin tuꞌuchun yu jantu malaqasikan chavay, astan la ox kamalaqasikanaꞌ. Mas alin yu jantu kꞌatsakan chavay, astan katasuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Chavay incha alin mimpaqasmakkꞌan, va kaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ex va lakjunil ni Jesús: —Kamakꞌatꞌikcha kuenta yu klajunau. Ni papulkan yu mapꞌatsꞌayatꞌik ni uxiknan vachu va yu papulkan katapulkaniyan ni Dios. Uxiknan yu asmatꞌatꞌik, ni Dios apalay lhuu katamasuniyan. ");
INSERT INTO tptNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yu lhitꞌajuncha, yucha apalay lhuu kaxtaqnikanaꞌ. Yu jantu kalhitsukul mas va tsꞌuniy yu lhitꞌajun, yucha kamaxtunichoqokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ex chuncha vachu naul ni Jesús: —Inchine va tacha ni Dios jalhachimoꞌonun. Va tacha qayntaun lapanaki yu mamay ixtꞌin ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mas ltatay laka putsꞌisniꞌ ni joꞌati, mas kujta laka tunkunuꞌ, yu xatꞌin yucha pꞌun, ex tsukuy aynaꞌ, jantu kꞌatsay tacha puꞌajin. ");
INSERT INTO tptNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yu tꞌun va xꞌaman maꞌayay ni jatachꞌanati. Pꞌunaj pꞌun ex ajin, astan xanay, ex taukꞌay xataltsꞌi tus aqtsaman. ");
INSERT INTO tptNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ex chuncha tejkan katꞌaycha, ni lapanaki puꞌiycha, va chil yu jaxqanti. ");
INSERT INTO tptNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ex chuncha taval vachu naul ni Jesús: —¿Tas junitacha tejkan jalhachimoꞌonun ni Dios? ¿Tas lay klamasuniyau tas junitacha? ");
INSERT INTO tptNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yucha va tacha taun xataltsꞌi ni mostasa yu vamun yuꞌ lakatꞌuniy xataltsꞌi yu lakchꞌankan lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Va chuncha tejkan chꞌankantacha ni xataltsꞌi, ox ajin, tus vamun yuꞌ ay jun. Tejkan aycha jun ni ixmaqlaqapꞌu ex va ancha taltilinintsukuy tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ex ni Jesús chuncha ixjapumalaninin ixchivinti Dios, va pulhuvaj chivinti yu xtaꞌa jatapastakꞌati ixlakpumalaniy ni lapanakni. Ixmakay tus tacha lay katapumalaqasil. ");
INSERT INTO tptNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni lapanakni vamun ixjalaqputeꞌeniy chivinti yu xtaꞌa jatapastakꞌati. Yu ixtꞌaltanan, yuꞌuncha va ixlakjunꞌojoy tisuncha naunputuncha tejkan xꞌamankꞌan ixlaktꞌataulay. ");
INSERT INTO tptNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ex chuncha taval ni anchanuꞌ julchan tejkan putsꞌislhicha, va lakjunil ixtꞌaltanan: —Chavay kaꞌau taꞌan takuktachal ni lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ex chuncha va lakmakaulakalcha yu alati lapanakni. Talhaꞌal ni Jesús laka barco yu ixtaputajun. Vachuꞌ ixtatꞌaꞌanta alati lapanakni kun alati barcos. ");
INSERT INTO tptNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Taval aqtayl pꞌas unilay, maꞌostaulnil ni xkan, tajuyachal ni laka barco, va ixꞌaqtsamanputuncha. ");
INSERT INTO tptNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ni Jesús va iltatata la ixtitampin ni barco, ixꞌaqtsꞌinta va taun aqtsꞌi. Ex yu alati va tamaqloꞌol, tajunil: —¡Jamalanini! ¿Jantu tuꞌuchun pastakꞌuyan mas tꞌaunaucha talaqtsꞌanqanin? ");
INSERT INTO tptNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ex va chuncha ni Jesús ostaulal, laqꞌaymal ni un, va junil ni xkan: —¡Kꞌalakꞌatꞌaulchꞌoꞌocha! ¡Vakcha kꞌaꞌunchꞌoꞌo! Ex ni un vakcha junchoqol. Va tus tacha aqtsꞌiyajcha ox junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ex va chuncha ni Jesús va lakjunil ixtꞌaltanan: —¿Valiꞌiychacha ayaj tꞌalhananatꞌikcha? ¿Jantukaꞌ lhakꞌapꞌupꞌinatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ex yu ixtꞌaltanan va ayaj tatalhanal, aqtaylcha talakchiviniy siya yuꞌuncha, talajuniy: —¿Tas va ayuchacha ni anu lapanaki? Kaval un, kaval yu lakxkan, si taqalasmatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ex taval tatakukchalcha yu lakamar, va tachaꞌalcha xalakatꞌun Gadara. ");
INSERT INTO tptNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tejkan taxtulcha ni Jesús ni laka barco, va laqchil qayntaun joꞌati yu taxtuchal ni kampusantu. Ixlhitꞌajun jantu ox espíritu. ");
INSERT INTO tptNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ni anchanuꞌ joꞌati va ancha tꞌaunachal ni kampusantu, va jantu matichun lay ixchꞌiꞌulay, mas kun kadena. ");
INSERT INTO tptNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Va aqlhuucha ixtachꞌiꞌulay kun kadena, va ixtachꞌiniy la ixchꞌajaꞌ ali ixmakaꞌ, pero ixlajꞌexꞌojoy, va tus lakatꞌuniy ixmakay. Jantu matichun lay ixmaqalhajay ni anchanuꞌ joꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tunkuj ali tsꞌis ixtꞌasajtsukuy ni laka kampusantu ali laka aspajunaxnan, va ixlakatꞌalmaꞌokantacha xꞌaman kun chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ex va chuncha ni anchanuꞌ joꞌati laqtsꞌil ni Jesús tejkan vananaj maqati ixmintachal, ex ni yucha va takyaulaqꞌal, va taꞌaqtsoqoqtanil. ");
INSERT INTO tptNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ex va chuncha va tꞌasal ni anchanuꞌ joꞌati, va naul: —¿Valiꞌiycha kintalakanuniy ni kitꞌin, uxintꞌi Jesús Sasꞌatꞌa kꞌatꞌi Dios yu vilchal laktꞌiyan? La ixtaqaꞌuti Dios va ktapayniniyan, jantu kꞌimamaꞌanlꞌajnivatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Yu Jesús va ixjunitacha: —Uxintꞌi, yu jantu ox espíritu kꞌatꞌi, ¡va kꞌamakꞌaucha ni aniy joꞌati! ");
INSERT INTO tptNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ex va chuncha ni Jesús va lhisakmil: —¿Tisuncha unkꞌancha mintaqaꞌuti? Ex ni yucha va naul: —Kitꞌin ijkunkan Pumalhuu. Va kilhuvajkꞌan ijkuntau. ");
INSERT INTO tptNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ex chuncha ni jantu lajꞌox espíritus yu ixtalaqtanuy anchanuꞌ joꞌati ixtatapayniniy ni Jesús ni jantu kalaqmalaqachal alakataun tꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ancha ukstsꞌuniy ni aspajun taꞌan ixtayanal va ixtatꞌajun exvaynin lhuvaj pꞌaxnin. ");
INSERT INTO tptNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ex tachun yu jantu lajꞌox espíritus tatapayninil ni Jesús, va tanaul: —Kilamalaqachaucha laka pꞌaxnin, ex yuꞌuncha lay kaklaqtanuucha. ");
INSERT INTO tptNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ex ni Jesús va niman xtaqlhi lakatin ni katalaqtanul ni pꞌaxnin. Ex chuncha ni jantu lajꞌox espíritus va tamakaulcha ni anchanuꞌ joꞌati, va talaqtanul ni pꞌaxnincha. Va tacha tꞌuy mil pꞌaxnin ixtaꞌalinta. Va taputakyaulcha taꞌan qaltalman, va tatajuchal yu lakamar, va taꞌakskajꞌuꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ex chuncha yu ixtalhistakta va tatakyauꞌal mapastakꞌaninin ni ay laka putaulan, vachuꞌ ixlhimaqspaꞌ ni putaulan. Ex chuncha lhuvaj lapanakni taminchal laqtsꞌinin yu tacha tapasal. ");
INSERT INTO tptNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ex chuncha tejkan tachinchal ni lapanakni taꞌan ixvil ni Jesús, va talaqtsꞌil ni anchanuꞌ joꞌati yu ixlaqtanuy aqmoqxnuꞌ. Ni yucha va oxicha vilchoqol, ulachoqotacha ixlaqchꞌiti, va ox jalakpastaknan. Ex chuncha ni lapanakni va ayaj tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ex chuncha yu talaqtsꞌil tacha tapasal ni anchanuꞌ joꞌati ali yu tatapasal ni pꞌaxnin, yuꞌuncha va talaqputeꞌenichoqolcha yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ex chuncha va aqtayl tatapayniniy ni Jesús para kataxtuchoqochalcha la ixtꞌunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tejkan tanuchoqolcha ni Jesús laka barco, ex yu joꞌati yu ixlaqtanuy aqmoqxnuꞌ va ixtapayniniy ni Jesús para katꞌaminchalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ex ni Jesús va jantu kaꞌuyujunil, va junil: —Kꞌapꞌinchꞌoꞌochiycha la minchaqaꞌ. Kꞌaalaqpꞌutꞌeꞌeniyeꞌe milapanakni tachun yu makanin ni Jalhachimoꞌonu Dios. Vachu kꞌalakꞌun ni yucha va ayaj mapaynin. ");
INSERT INTO tptNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ex ni anchanuꞌ lapanaki va anchoqolcha la xalakatꞌun yu junkan Decápolis. Va aqtaylcha jalaqputeꞌeniy ni lapanakni tacha pupalay makachoqol ni Jesús. Ex tachun ni lapanakni va tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Taval va takukchoqochil laka barco ni Jesús lakamar. Tejkan tachinchal la ixkilpaꞌ ni lakamar, ancha tataqxtoqlhi qaynlhuu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ex va chil qayntaun lapanaki yu ixlhichimoꞌoy laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas, ixjunkan Jairo. Tejkan laqtsꞌil ni Jesús va tus talakaputatamanil la ixchꞌaja ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tapayninil ni Jesús, va junil: —Ni kintsiꞌi va laycha kanil. Va knajun katꞌatꞌi moqslaniniꞌ mimakaꞌ, ex lay kaꞌayajnanchoqol, lay katsukul. ");
INSERT INTO tptNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ex ni Jesús va tꞌaꞌalcha ni Jairo. Vachuꞌ tatꞌaꞌal lhuvaj lapanakni, va tus ixtalapatsꞌiukslhaꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Vachu ixꞌalinta qayntaun xanati taqanꞌan. Laqakautꞌuycha jachꞌitin va si jakꞌalnan ixmajꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chuncha ni xanati va qaynlhuvaj kꞌuchꞌunun jalaqkilal yu ixtamamaqanlqajnival. Va ixmaꞌakxaꞌojotacha tachun yu ixlhitꞌajun. Jantu tsꞌuniy palay ixjun, va apalay ixtaqanꞌay. ");
INSERT INTO tptNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ex chuncha ni anchanuꞌ xanati qasmaklhi ni jakꞌuchꞌunun ni Jesús. Ex talakanunil la ixlhistapuꞌ ni Jesús, va piklanil ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Va ixpastakta: “Mas vamun ixlaqchꞌiti kakpiklanil, ka palaycha kajkunchoqol”. ");
INSERT INTO tptNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ex chuncha va niman tayajcha val ni ixjakꞌalna ni xanati. Va ukskꞌatsalcha la ixlakatunaj ni va palaycha junchoqol ixtaqanꞌati yu ixlhitꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ex chuncha ni Jesús va ukskꞌatsal ni la ixtapꞌasta palay makachoqol xaqayntaun. Va taspꞌiklakavanal taꞌan ixtayanal ni lapanakni, va naul: —¿Taꞌayucha ixkimpiklaycha la kilaqchꞌiti? ");
INSERT INTO tptNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yu ixtꞌaltanan va tajunil: —Kꞌatsꞌaycha ni lhuvaj lapanakni talapatsꞌiukslhiminta. ¿Ex valiꞌiychacha lhasakminin taꞌayucha xapꞌiklayancha? ");
INSERT INTO tptNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ni Jesús va taylhaꞌal jalaqtsꞌiniꞌ yu lapanakni, va mispaputun taꞌayucha piklanil ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ni xanati va kꞌatsaycha yu tacha tapasal. Va talhanal tus xkapꞌikninta, talakanunil ni Jesús, talakaputatamanil, va laqputeꞌeniꞌol tachun yu laqsaval tapasal. ");
INSERT INTO tptNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ex ni Jesús va junil: —Kintsiꞌi kꞌatꞌi, va kꞌilhakꞌapꞌupꞌin, xlhiyucha palaycha xaꞌunchꞌoꞌoy. Chavay oxamaktauncha kapꞌinchꞌoꞌo, palaycha kaꞌunchꞌoꞌo mintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tejkan ni Jesús vananaj ixtꞌajun chivin, va tachilcha ixlapanakni ni Jairo yu ixlhichimoꞌoy laqa chaqaꞌ taꞌan tataqxtoꞌa ni israelitas. Va tajunil: —Yu mintsiꞌi va nilcha. Jantucha apalay kamaꞌanchꞌapꞌu ni Jamalaniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tejkan qasmaklhi ni Jesús yu tanaul ni lapanakni, va naul, junkal ni lapanaki yu ixlhichimoꞌoy laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas: —Jantu katꞌalhan. Vamun kꞌalhakꞌapꞌupꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ex chuncha ni Jesús tejkan alcha va jantu matichun kaꞌuyujunil ni katꞌaꞌal, vamun ni Pedro ali Jacobo ali Juan yu ixlaqaj ni Jacobo. ");
INSERT INTO tptNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tachaꞌalcha la ixchaqaꞌ yu ixlhichimoꞌoy taꞌan ixtataqxtoꞌa ni israelitas. Ex ni Jesús va laqtsꞌil ixtalakchꞌilita ni lapanakni, va ixtalajqalhunta, tus pꞌas ixtalaktꞌasata. ");
INSERT INTO tptNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Taval va tanuchal ni Jesús, va lakjunil: —¿Valiꞌiycha ayaj pꞌasnicha lajꞌalhunatꞌik? Ni jatsiꞌi jantu kanil, va ltatay. ");
INSERT INTO tptNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Chuncha vamun talaktuꞌul ni Jesús. Taval ni yucha jalakmaxtuꞌol maqspaꞌ ni lapanakni yu ixtatanumanal ixpulakna. Laklhaꞌalcha vamun ixpay ali ixnati ni jatsiꞌi, vachuꞌ yu pumatꞌutu ixtꞌaltanan. Tatanul taꞌan ixmal ni jatsiꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ex ni Jesús va chꞌapanil ixmakaꞌ ni jatsiꞌi, va junil: —Talita, kumi —yucha naunputun: Jatsiꞌi kꞌatꞌi, kaꞌostꞌaulchꞌoꞌocha. ");
INSERT INTO tptNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ex ni anchanuꞌ jatsiꞌi va niman ostaulchoqolcha, va tiꞌukxuntayachoqolcha. Ixlhitꞌajun laqakautꞌuy ixjachꞌitin. Tejkan chuncha talaqtsꞌitapasal ni lapanakni va tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ni Jesús laklhijunil ni jantu matichun katalaqputeꞌenil yu tapasal. Ex lhinaul ixvavaka ni jatsiꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ex va chuncha ni Jesús taxtuchoqolcha taꞌan ixvil, va anchoqol la ixtꞌun. Ixtꞌaltanan vachu tatꞌaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tejkan xajulchan jastaknati val, ex ni Jesús aqtayl jalakmalaniy ni lapanakni laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. Qaynlhuvaj lapanakni tejkan taqasmaktaynil, tus vak takꞌatsal, ixtanajun: —¿Tas oxtaycha lanilcha ni anu joꞌati yu laqputeꞌey? ¿Tis va suncha ni anu jatapastakꞌati yu xtaqnikal? ¿Tas pulakmakaycha lajꞌay axtoqnuꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ni yucha va karpintero, va istsꞌal ni María, ixtꞌalaqaunin va ni Jacobo ali José ali Judas ali Simón. Ixtꞌalapanakni vachuꞌ aniy taꞌalinta kun kijnankꞌan. Ex chuncha jantu ox ixtalaqtsꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ni Jesús va jalakjunil: —Qayntaun lapanaki yu laqputeꞌey ixchivinti Dios va talakachux toꞌoyakan. Vamun la ixtꞌun, taꞌan tavilanal ixtꞌalaqaunin, ancha la ixchaqaꞌ, jantu toꞌoyakan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ex ancha ni Jesús va jantu kalal kamakal yu lajꞌay axtoqnuꞌ. Vamun laqmoqslanil ixmakaꞌ lati taqanꞌanin, va palaycha jalakmakal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yucha va tus vak kꞌatsal ni jantu ixtalhakapuꞌan ni lapanakni. Taval va ixꞌanta lakmalanin taꞌan ukstsꞌuniy laka putaulanin. ");
INSERT INTO tptNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ex chuncha va jalakjuntaꞌil pumakautꞌuy ixtꞌaltanan. Jamalaqachal pumatꞌiyun, va jalaqxtaqnil ni lhachimoꞌon para lay katamaxtul yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Va jantu kalaqxtaqnil lakatin katalhaꞌal tuꞌuchun, mas ixvaytikꞌan, mas ixmoralkꞌan, nisin ixtuminkꞌan. Vamun maqatamin ixpalikkꞌan jaxtaqnikal lakatin katalhaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jalakjunil ni katachꞌantanul ixvarachikꞌan, vachuꞌ katalhaꞌal vamun aqxtaun ixlaqchꞌitkꞌan, jantu aqxtꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jalakjunil: —Tejkan kꞌatꞌanutꞌachipitik ni aqataun chaqaꞌ, va ancha katꞌaulꞌalhiyapitikcha tus tejkan katꞌaxtꞌuchꞌoꞌoyapitik ni anchanuꞌ putaulan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Incha jantu katalaqaꞌiyan, incha jantu kataqalasmakputunan, ex katꞌaxtꞌuchꞌoꞌoyapitikcha. Kachꞌankꞌalapꞌuxkꞌanapitik ni pꞌoqxni la minchꞌajakꞌan, chuncha lay katakꞌatsal ni jantu ox yu tamakaniyan. Laqsaval klajunau, tejkan kaminaꞌ ni Dios mukꞌanaꞌ laqtaqal ex apalay ay kunaꞌ ixmaqanlqajnatkꞌan xajantu ni lapanakni yu ixtatꞌajun Sodoma kun Gomorra. ");
INSERT INTO tptNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ex chuncha ixtꞌaltanan tataxtulcha laqputeꞌenin ni maqskꞌiniy katamapaxalcha ixjatapastakꞌatkꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhuvaj taqanꞌanin talakmaxtunil yu jantu ox espíritus. Vachuꞌ talhixapal lhuvaj taqanꞌanin kun aceite, va tamaꞌayajnichoqol. ");
INSERT INTO tptNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ex yu lhachimoꞌonuꞌ Herodes va kꞌatsal yu tacha ixmakay ni Jesús. Tachun ni lapanakni ixtamispaꞌojoy yu ixmakay ni Jesús. Tanaul: —Ka va kujchoqotacha ni Juan yu jamaqchajꞌavanaꞌ. Ka xlhiyucha lhitꞌajun tapꞌasta ni lay kamakal ay axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Alati lapanakni va ixtanajun: —Ka va Elías. Yu alati ixtanajun: —Va qayntaun yu ixlaqputeꞌey ixchivinti Dios maqancha. ");
INSERT INTO tptNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tejkan chuncha qasmaklhi ni Herodes, va naul: —Ni anchanuꞌ va Juan, va yu ikmalaqachanal ixchaqxpꞌuxnika ixꞌaqtsul. Va tꞌajunchoqoycha. ");
INSERT INTO tptNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ni Herodes ixmalaqachanantacha ixchꞌika ni Juan ex manul laka pachꞌin. Va chuncha ixnajun kamakal ixanati yu ixjunkan Herodías. Yucha ixjunitacha ixanati ni Felipe, yu ixlaqaj ni Herodes pero Herodes ixmaxtunitacha, va tꞌatsukul. ");
INSERT INTO tptNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ni Juan va ixjunitacha ni Herodes: —Yu ixanati ni milaqaj jantu lay kꞌalhitsꞌukꞌu tacha mixanati. ");
INSERT INTO tptNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Xlhiyucha yu Herodías ayaj ixkajiy ni Juan va ixmaqniputun pero jantu lay kamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yu Herodes ixtalhauniy ni Juan, ixkꞌatsay va ox vas ixjunita ixjatsukunti, ixmakay yu tacha ixnajun Dios. Ex mas ni Herodías ixmaqniputun ni Juan, yu Herodes va ixlhistakta. Vachu tus ox ixꞌachajqasmakniy yu ixlaqputeꞌeniy ni Juan, mas jantu ox ixmalaqasiy yu ixlaqputeꞌey. ");
INSERT INTO tptNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Taval taun julchan ni Herodías va temal tacha pulay kamaqnil. Laqchaꞌalcha ixkꞌatan ni Herodes. Ni Herodes va makal taun ay lakvayti. Va laklhijunil ni lapanakni yu ixtaꞌaqtayjuy ali yu xaꞌukxtinin tropas, vachuꞌ alati yu xalajꞌay lapanakni yu ixtavilanal xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ex chuncha yu istsiꞌi ni Herodías tanuchal taꞌan ixꞌalinta ni kꞌatan, va aqtayl jatꞌinin. Va ayaj maqamal ni Herodes, vachu yu ixtatꞌatꞌajun vaynin ayaj tamaqamal. Ex yu jalhachimoꞌonuꞌ Herodes va junil ni jatsiꞌi: —Kꞌiskꞌinin va yu uxintꞌicha achꞌaniy. Yu kitꞌin kakxtaqniyan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ex vachu junil: —Laqsaval ijkunan ni kakxtaqniyan yu kiskꞌiniy mas va tichichuncha kaval tus kaval pakltaun ni kilakamunukpaꞌ taꞌan klhichimoꞌoy. ");
INSERT INTO tptNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Taval ni jatsiꞌi va al lhisakminin ixnati: —¿Tisunchacha kakskꞌiniyacha? Yu ixnati va junil: —Chavay ni uxintꞌi va kaskꞌiniyeꞌe ixꞌaqtsul ni Juan yu jamaqchajꞌavanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ex chuncha ni jatsiꞌi va taun laqatsꞌalaj tanuchal taꞌan ixvil ni jalhachimoꞌonu, va junil: —Yu kitꞌin iknajun chavaycha niman kꞌixtꞌaqnin laqa ay plato yu ixꞌaqtsul ni Juan yu jamaqchajꞌavanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tejkan chuncha junkal ni jalhachimoꞌonu Herodes, va ayaj maqaninil. Pero ixjunitacha ni laqsaval kaxtaqniyaꞌ yu kaskꞌinacha, vachu ni lapanakni yu lakjuntaꞌitacha lakvayti va taqasmakꞌol ixchivinti yu junil ni jatsiꞌi. Xlhiyucha jantucha lay kamapaxal ixjatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ex chuncha ni jalhachimoꞌonuꞌ Herodes niman lhijunil qayntaun ixtropa kaꞌal iniꞌ ixꞌaqtsul ni Juan yu maqchajꞌavanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ex ni tropa va al ni laka pachꞌin, va chaqxꞌinil ixꞌaqtsul ni Juan, ex lhiminil laqa ay plato, xtaqnilcha ni jatsiꞌi. Ex yu jatsiꞌi va maqxtaqnil ixnati ixꞌaqtsul ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ex chuncha yu ixtꞌaltanan ni Juan tejkan takꞌatsalcha ni maqnikal, va takiꞌinilcha ixlakatunaj. Va talhaꞌalcha maknunun laka putaknun. ");
INSERT INTO tptNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ex taval yu ixjamalaqachantacha ni Jesús va talaqminchoqol ni Jesús. Va talaqputeꞌel tachun yu tamakal ali yu tamalaninil. ");
INSERT INTO tptNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ex ni Jesús va lakjunil ixtꞌaltanan: —Chavay ni uxiknankꞌan kꞌatꞌantꞌikcha taꞌan jantu tꞌujuꞌ lapanakni, kaꞌaucha jastaknan kilaqꞌamankꞌan. Yuꞌuncha va jantu lay katastaknal taun panchꞌixcha para katavayl, va por ixtamin, ixtaꞌan pumalhuu lapanakni. Xlhiyucha chuncha naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ex va chuncha va tatajulcha laka barco. Va taꞌal jastaknan xꞌamankꞌan taꞌan jantu tꞌujuꞌ lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero lhuvaj lapanakni talaqtsꞌil tejkan al, va talaqmispal. Ex chuncha pumalhuu xalapanakni ni laka putaulanaxna va tatakyauꞌal laka tꞌun. Taval yuꞌuncha pꞌunaj tachaꞌal, yu Jesús kun ixtꞌaltanan va astan tachaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tejkan ni Jesús taxtulcha laka barco va jalaqtsꞌil lhuvaj lapanakni. Va jalakmapaynil ni lapanakni, ixtaꞌalinta tacha borregos yu jantu kaꞌalil qayntaun yu kalaklhistaklhi. Ex chuncha ni Jesús aqtaylcha jalakmalaniy, va pulhuu chivinti jalakmasunil. ");
INSERT INTO tptNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ex chuncha tejkan toqoxalcha ixtꞌaltanan ni Jesús talaqmil, va tanajun: —Aniy jantu tꞌujuꞌ chaqan, chavaycha toqoxalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Kꞌalakmastꞌakꞌachꞌoꞌo ni lapanakni kataꞌanchalcha inin ixvaytikꞌan ukstsꞌuniy taꞌan alin lakstꞌuniy putaulanaxna. ");
INSERT INTO tptNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ex ni Jesús va lakjunil: —Uxiknankꞌan kalakvavatꞌik. Ex yuꞌuncha va tanaul: —¿Ex kijnankꞌan kajkꞌanau inin vayti para kaklakvavayau? Maqskꞌiniy lhuu tumin ni kaklhiꞌiu yu kataꞌul, kaval 200 julchan lhitapatsa. ");
INSERT INTO tptNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ex chuncha ni Jesús va naul: —¿Tas chuncha maꞌalinatꞌikcha mivaytikꞌan? Kꞌapꞌinchꞌipitik laqtsꞌinin. Tejkan takꞌatsalcha tachun ixꞌalinta, tanaul: —Va aqskis pan ali aqxtꞌuy jatanti. ");
INSERT INTO tptNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ex ni Jesús jalaqmalaqachal katalhijunil ni lapanakni para katataulal oqxlaqtamin taꞌan alin lakstakꞌau jatsꞌinan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ex chuncha ni lapanakni tataulalcha tamin ciento, yu alati va tataulal pakltamin ciento. ");
INSERT INTO tptNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ex chuncha ni Jesús chꞌapalcha ni aqskis pan ali yu aqxtꞌuy jatanti. Talaqstꞌal ni laktꞌiyan, va xtaqnil lhimalaqpuchuncha ni Dios. Ex chuncha laqcheꞌelcha ni pan, jalaqxtaqnilcha ixtꞌaltanan para katamapitsinilcha ni lapanakni. Vachu jalaqcheꞌeniꞌol tachun ni lapanakni ni anchanuꞌ aqxtꞌuy jatanti. ");
INSERT INTO tptNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tachun tavaynꞌol, va tus ox taꞌotsaꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ex chuncha tapusakchoqol yu xajchal xatalaqcheꞌeniꞌ ni pan kun ni jatanti. Va tus laqakautꞌuy canastas tamaꞌaqtsamal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ni joꞌakna yu tavayl va laqakis mil. ");
INSERT INTO tptNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ex ni Jesús va niman laklhijunilcha katatajuchoqolcha ni laka barco ixtꞌaltanan para kataꞌanchoqolcha ni Betsaida. Ni Jesús jantu niman kalaktꞌaꞌal. Vananaj ixtꞌajun lakmastakꞌanaꞌ ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tejkan lakmastakꞌaꞌochoqolcha ni lapanakni ex ni Jesús va al tapayniniꞌ Dios laka aspajun. ");
INSERT INTO tptNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tejkan putsꞌislhicha, yu ixtꞌaltanan ixpakltauncha lakamar ixtaꞌanta laka barco. Ni Jesús va ixꞌamancha ixyal ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ex ni Jesús jalaqtsꞌil ni ixtꞌaltanan va tacha jantu kalal katamaltanal ixbarcokꞌan. Yu un va ayaj pꞌasni ixꞌunilata taꞌan ixtapuꞌanta. Tejkan tunkumintacha ni Jesús va iltanajmintacha la ixꞌukxna lakxkan. Va ixlaqmaqxapuꞌiniputun ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero tejkan talaqtsꞌil ni iltanajminta la ixꞌukxna ni lakxkan talhilal va taun maqtsꞌisvanaꞌ. Ex va tamatꞌasal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Tachun yu talaqtsꞌil, va ayaj tatalhanal. Ex ni Jesús niman jaxaqalal, va lakjunil: —¡Ay kꞌamakꞌatꞌik melhanutkꞌan! Va kitꞌin. Jantu katꞌalhanantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ex ni Jesús va tajulcha laka barco taꞌan ixtatajumanal. Ni un va vakcha junchoqol. Ex yuꞌuncha tatalhanal, va tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Vananaj ayaj pꞌas ixtajunita ixjalhanutkꞌan. Jantukaꞌ ox ixtamalaqasiy tichichuncha lapanaki junita yu lalhaval ni pan. ");
INSERT INTO tptNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tejkan tapatukukchalcha ni lakamar va tachaꞌalcha xalakatꞌun Genesaret, tachꞌiꞌulalcha ni barco. ");
INSERT INTO tptNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tejkan tataxtul laka barco ni Jesús ali ixtꞌaltanan, ex yu lapanakni va niman tamispal. ");
INSERT INTO tptNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ex tatakyauꞌal inin yu taqanꞌanin tus tachun ni anchanuꞌ lakatꞌun. Talaklhiminil laka putaman taꞌan ixtakꞌatsay ni ixtaulay Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ni Jesús tejkan ixtiꞌukxuntayay lakstꞌuniy putaulan, lajꞌay putaulan, laka kuxtu, mas va toꞌoxtaycha kaval, va si ixtamamaniy ni lakatinixnan ni taqanꞌanin. Ixtatapayniniy ni Jesús para lay katachꞌapanil vamun ixpiktuꞌ ni ixlaqchꞌiti. Ex tachun yu tachꞌapanil va si taꞌayajnanꞌochoqol. ");
INSERT INTO tptNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Taun julchan ni fariseos ali alati yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas va tatalakanunil ni Jesús. Va taminchal ni Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Talaqtsꞌil lati ixtꞌaltanan ni Jesús va ixtavajin mas jantu ixtamaqchaꞌay tacha lhinajun ixputsukukꞌan. Ex jantucha ox katalhilal. ");
INSERT INTO tptNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yu fariseos ali tachun yu alati israelitas yuꞌuncha ixtamakay tacha ixputsukukꞌan yu maqancha ixpayankꞌan. Jantu aqtaun lakmakxkiliu ixtavajin, va si pꞌunaj ixtamaqchaꞌay tacha lhinajun ixputsukukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Vachuꞌ tejkan ixtaꞌiy tuꞌuchun laklhitamau, pꞌunaj ixtachaꞌaꞌelay ex ixtaꞌuy. Vachu ayaj pulhuvaj ixtamakay tacha ixputsukukꞌan, ixtachaꞌay vasos ali kasvilas, xapuvay yu jamakanti kun tsasnati vachu yu putaman. ");
INSERT INTO tptNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ex chuncha yu fariseos ali yu ixtamalaniy ixlhachimoꞌonkꞌan va tajunil ni Jesús: —¿Valiꞌiycha mintꞌaltanan jantu tataylhaꞌan yu kimputsukukꞌan yu tacha ixtamakay yu maqancha kepayankꞌan? Yu mintꞌaltanan valiꞌiy tavajin mas jantu tamaqchaꞌay tacha lhinaunkan. ");
INSERT INTO tptNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ex ni Jesús va lakjunil: —Ni uxiknankꞌan va tꞌuy ukxpuꞌ makꞌayatꞌik. Ni Isaías yu ixlaqputeꞌey ixchivinti Dios, yucha vas ixnajun, va inchineꞌ tsꞌoqlhi: Ni aniy lapanakni vamun kun ixkilkꞌan kintatoꞌoyay. Yu ixjalhanutikꞌan va ayaj maqati alinta kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mas ayaj kintatoꞌoyay jantu tuꞌuchun ixtapal kaval, jantu laqsaval yu tamalaninin, va ixjatapastakꞌatkꞌan lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chavay uxiknankꞌan va makꞌauntꞌijlayatꞌik yu lhinajun Dios. Tꞌaylhipꞌinatꞌik yu talhinajun lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Vachuꞌ lakjunil: —Chavay yu lhinajun Dios valiꞌiy makꞌauntꞌijlayatꞌik. Vamun tamaqamayan katꞌaylhipꞌintꞌik tacha uxiknankꞌan mimputsukukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ni Moisés yu maqancha ixlaqputeꞌey ixchivinti Dios, va naul: “Katꞌoꞌoyatꞌi ni mimpay ali minati.” Vachu va naul: “Yu jantu ox lhichiviniy ixpay ali ixnati yucha maqskꞌiniy kanil.” ");
INSERT INTO tptNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero yu uxiknankꞌan naunatꞌik ni qayntaun lapanaki lay kajunil ixpay ali ixnati: “Laqsaval tachun yu klhitꞌajun va Korbán (va naunputun va ixnavin Dios). Xlhiyucha jantu lay klaꞌaqtayjuyau.” ");
INSERT INTO tptNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Incha chuncha najun, ex yu uxiknankꞌan naunatꞌik jantucha maqskꞌiniy kalaqꞌaqtayjul ixpay ali ixnati. ");
INSERT INTO tptNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chuncha ayaj akchꞌintꞌamayatꞌikcha yu lhinajun Dios. Va ayaj tꞌoꞌoyaniyatꞌik yu tacha ixtamakalhiminta ixputsukukꞌan mimpayankꞌan maqancha. Pulhuvaj axtoqnuꞌ chuncha makꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ex chuncha ni Jesús jalaktꞌasaꞌil yu ixtalhavaxtu lapanakni, va jalakjunil: Kilaqalasmakvi mintachunkꞌan, ox kꞌamalaꞌasitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Yu uy ni lapanaki, yucha jantu maqtaqalhiniy ixjatsukunti. Yu maqtaqalhiniy va yu kiltaxtuy.  ");
INSERT INTO tptNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Chavay incha alin mimpaqasmakkꞌan, va kaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ex chuncha ni Jesús tejkan lakmakaulcha ni lapanakni, va tanul la ixpulakna ni laqa chaqaꞌ. Ex chuncha ixtꞌaltanan va talhisakmil yu naunputun ni chivinti yu ixlakmalanita ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ex ni Jesús va jalakjunil: —¿Chavay mas uxiknankꞌan jantu malaꞌasiyatꞌik? ¿Jantu malaꞌasiyatꞌik ni tachun yu uy qayntaun lapanaki ni yucha jantu maqtaqalhiniy? ");
INSERT INTO tptNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yu uy jantu tanuyachal la ixjalhanuti. Tajuyachal la ixpuvintu ex astan taxtuchoqoy. Tejkan chuncha naul ni Jesús va masul ni puchux lhiꞌuti va si ox kꞌaꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ex chuncha vachu naul ni Jesús: —Yu maqtaqalhiniy qayntaun lapanaki va yu minachal la ixpulakna. ");
INSERT INTO tptNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","La ixpulakna ni lapanakni, la ixjalhanutikꞌan, ancha minachal yu jantu lajꞌox jatapastakꞌati, xlhiyucha tatꞌatamay lapanakni yu jantu ixnavinkꞌan kaval, tamaqamaꞌojoy tachun yu jantu lajꞌox, jamaqninin, ");
INSERT INTO tptNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","taꞌalhavanan, taꞌaqspꞌuknin, talaktuꞌunun, tamakanunun, taputꞌajuncha la ixjatsukuntikꞌan, taꞌakchaꞌanan, tamanuy jalaklkanti, ixꞌamankꞌan ay lakmakakan, jantu lakpastaknan. ");
INSERT INTO tptNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tachun ni anchanuꞌ axtoqnuꞌ yu jantu lajꞌox, yucha minachal la ixpulakna ni lapanaki, ex chuncha maqtaqalhiniy. ");
INSERT INTO tptNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ex chuncha ni Jesús taxtuchalcha, va al xalakaputaulanin ni Tiro ali Sidón. Ex chuncha tejkan chaꞌal, tanul aqataun chaqaꞌ, va ixnajun jantu matichun kakꞌatsal taꞌan taulal. Pero jantu lay katamaqsaqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Qayntaun xanati ixlhitꞌajun qayntaun lakatꞌuniy ixjatsiꞌi yu ixlhitꞌajun yu jantu ox espíritu. Tejkan kꞌatsal ni ancha vil ni Jesús, va niman laqꞌal, va talakaputatamanil la ixchꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ni xanati jantu israelita kaval, va ixchiviniy lhigriego, tsukuchal xalakatꞌun Sirofenicia. Yucha tapayninil ni Jesús ni kamaxtunil yu jantu ox espíritu ni istsiꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero ni Jesús va junil: —Pꞌunaj maqskꞌiniy kaklakvavaꞌelal ni kintꞌaꞌisraelitas. Jantu ox ni kꞌalakmaxtꞌunin ixvaytikꞌan ni jasꞌatꞌan para kꞌalaqxtꞌaqnin yu xꞌoyun. ");
INSERT INTO tptNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ex chuncha ni xanati va naul: —Ka chun, Jalhachimoꞌonuꞌ. Pero mas yu xꞌoyun yu tavilanal ixtaꞌapuꞌ laka mesa talaksakꞌuycha ixtalaqcheꞌekꞌan ni jasꞌatꞌan yu talakamakajun. ");
INSERT INTO tptNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ex chuncha ni Jesús va junil: —Ka chun, la ox tacha xanaꞌun. Laycha kapꞌinchꞌoꞌo. Yu mintsiꞌi makaunchoqolcha yu jantu ox espíritu. ");
INSERT INTO tptNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ex chuncha ni xanati va anchoqolcha. Tejkan chaꞌanchoqol la ixchaqaꞌ, yu ixjatsiꞌi va makaunchoqotacha yu jantu ox espíritu. Va saqcha machoqol la ixputaman. ");
INSERT INTO tptNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taval ni Jesús va minchoqochalcha xalakatꞌun Tiro, va pumil Sidón, tapasal lakamar Galilea, va chinchal xalakatꞌun Decápolis. ");
INSERT INTO tptNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ancha talhiminil ni Jesús qayntaun joꞌati aqatapa, vachu jantu lay vas ixchiviniy. Ex chuncha va tatapayninil ni Jesús para kamoqslanil ixmakaꞌ la ixlakatunaj ni anchanuꞌ aqatapa. ");
INSERT INTO tptNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ex ni Jesús va lhilhaꞌal ni aqatapa taꞌan jantu katatayal ni lapanakni. Ex ancha akatutamaknul kun ixmakaꞌ la ixꞌaqaxqol. Vachu chujval ixmakaꞌ ni Jesús va moqslanil la isimaꞌati ni aqatapa. ");
INSERT INTO tptNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ex ni Jesús talaqstꞌal ni laktꞌiyan, va tus pulmaniyaꞌil ni ixaniti, va naul: —¡Efata! (Va naunputun ¡Katalaqltiꞌal!) ");
INSERT INTO tptNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ex niman laycha qasmaknal, yu isimaꞌati va oxicha junchoqol, ox ixchiviniy. ");
INSERT INTO tptNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ni Jesús laklhijunil ni jantu matichun katalaqputeꞌenil pero mas chuncha ixlakjunkan va apalay ixtalaqputeꞌey. ");
INSERT INTO tptNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ex chuncha ni lapanakni tus taun talhilal ni Jesús, va ixtanajun: —Tachun yu lajꞌox lay makay. Chavay yu aqatapanin jamaqasmaknichoqoy, vachuꞌ yu janunun lakmachivinichoqoy. ");
INSERT INTO tptNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ex chuncha taun julchan va lhuvaj lapanakni ixtaꞌaqxtoqnun, ex chuncha yu ixvaytikꞌan jantu tꞌujucha ixjunita. Ex chuncha ni Jesús va lakjuntaꞌil ni ixtꞌaltanan va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Va ayaj klakmapayniy ni lapanakni. Paqtꞌutucha kintatꞌaꞌalinta ni kitꞌin, jantu katalhitsukul tuꞌuchun yu kataꞌul. ");
INSERT INTO tptNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Incha kaklaqmalaqachachoqol la ixchaqakꞌan sin vayti ka va lay katalaqavitil ni lakatin. Lati va la maqati machaqan. ");
INSERT INTO tptNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ex tanaul ixtꞌaltanan: —Ni aniy jantu matichun kataulal. ¿Tas oxtay lay kalaqxtaqnikal ixvaytikꞌan ni anchanuꞌ lapanakni aniy taꞌan jantu matichun kataulal? ");
INSERT INTO tptNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ex ni Jesús laklhisakmil ixtꞌaltanan, va lakjunil: —¿Tas chuncha pan maꞌalinatꞌik ni uxiknankꞌan? Ex tanaul: —Va aqxtujuncha alin. ");
INSERT INTO tptNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ex ni Jesús laklhijunilcha ni lapanakni katataulalcha lakatꞌun. Chꞌapalcha ni anchanuꞌ aqxtujun pan, va tapayninil ni Dios. Taval laqcheꞌelcha ni pan, va jalaqxtaqnilcha ni ixtꞌaltanan. Ex yuꞌuncha tamaqpitsinil ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vachu ixtamaqalin tsꞌuniy yu lakstꞌuniy jatanti. Ex yu Jesús xtaqnil lhimalaqpuchuncha ni Dios, va laqcheꞌelcha, ex vachu lhinaul ixmapitsika. ");
INSERT INTO tptNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ex chuncha tus tachun tavaynꞌol va tus ox taꞌotsal. Taval tamaqxtoqlhi yu xatalaqcheꞌeniꞌ yu xajchal. Laqchaꞌal laqatujun qaychꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ni lapanakni yu tavayl va laycha laꞌatꞌati mil. Ex chuncha ni Jesús va lakmastakꞌachoqolcha ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ex va jalaktꞌatajuchoqolcha ixtꞌaltanan laka barco. Va taꞌal xalakatꞌun Dalmanuta. ");
INSERT INTO tptNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ex chuncha tachinchal ni yu fariseos va taꞌaqtayl talakchiviniy kun Jesús. Ixtalaqtsꞌintanuputun, tanajun kalakmasunil taun ay axtoqnuꞌ yu minachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ni Jesús tus pulmaniyaꞌil ixaniti, va naul: —Ni uxiknan yu chavaycha tꞌaunatꞌik, ¿valiꞌiycha skꞌinatꞌikcha taun ay axtoqnuꞌ yu lay kilapumispau? Laqsaval klajunau ni jantu klamasuniyau. ");
INSERT INTO tptNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Taval ni Jesús lakmakaulcha ni lapanakni, tajuchoqolcha laka barco, va alcha tukuktachal lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yu ixtꞌaltanan ni Jesús va takauklhi katalhaꞌal ixtiyutkꞌan, vamun aqxtaun pan ixtalhaꞌanta taꞌan ixtapuꞌanta laka barco. ");
INSERT INTO tptNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ex chuncha ni Jesús jalaqxaqalal ixtꞌaltanan, va lakjunil: —Kꞌalhistꞌajkꞌantꞌik kun yu ixlevadurajkꞌan ni fariseos ali Herodes. ");
INSERT INTO tptNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ex chuncha ixtꞌaltanan taꞌaqtayl talaxaqalay siya yuꞌuncha, va talajuniy: —Jantu kalhimiu ni kintiyutkꞌan, va xlhiyucha chuncha najun. ");
INSERT INTO tptNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ni Jesús lajkꞌatsanil yu ixtatꞌajun lhilakchivinin, va lakjunil: —¿Valiꞌiycha naunatꞌikcha ni jantu maꞌalinatꞌik mimpankꞌan? ¿Jantukaꞌ malaꞌasiyatꞌik? ¿Va ayaj laqpꞌasnin miꞌaqtsulkꞌan? ");
INSERT INTO tptNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mas alin milaqchulkꞌan va tacha jantu pꞌalakꞌavananatꞌik. Mas alin mimpaqasmakkꞌan va tacha jantu asmaknanatꞌik. ¿Jantucha pꞌastꞌakꞌatꞌik yu tapasal? ");
INSERT INTO tptNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tejkan klakmapitsinil ni anchanuꞌ aqskis pan yu laqakis mil lapanakni, ¿tas chuncha canasta maqxtꞌoqtꞌikcha yu xatalaqcheꞌeniꞌ? Ex yuꞌuncha va tanaul: —Laqakautꞌuy canasta. ");
INSERT INTO tptNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ex lakjunchoqol: —Tejkan klakmapitsinil ni anchanuꞌ aqxtujun pan yu laꞌatꞌati mil joꞌakna, ¿tas chuncha qaychꞌicha maꞌaqtsꞌamatꞌik? Ex va tanaul: —Laqatujun qaychꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ex chuncha ni Jesús va lakjunil: —¿Ex jantukaꞌ malaꞌasiyatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ex chuncha tejkan ni Jesús ali ixtꞌaltanan tachaꞌal laka putaulan Betsaida, va lhiminikal qayntaun laꞌachꞌix. Va tapayninikal kamoqslanil ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ex chuncha ni Jesús maqchꞌapal ni laꞌachꞌix va lhaꞌal ixlhimaqspaꞌ ni putaulan. Ancha lhixapanil ixchujꞌuti la ixlaqchul ni laꞌachꞌix, vachu moqslanil ixmakaꞌ. Ex va lhisakmil incha laycha laqtsꞌin tuꞌuchun. ");
INSERT INTO tptNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ni laꞌachꞌix va lakavananchoqolcha, ex naul: —Chun, klaqlaqtsꞌin ni lapanakni. Tatasuy tacha jakꞌivinancha yu taltananta. ");
INSERT INTO tptNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ex ni Jesús va aqtaun moqslanichoqol ixmakaꞌ la ixlaqchul. Ex chuncha ni joꞌati va laycha lakavanal, va tus maqati tachun ox jalaqtsꞌil. ");
INSERT INTO tptNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ex ni Jesús malaqachachoqol la ixchaqaꞌ, va junil: —Jantucha kapꞌinchꞌoꞌo ixpulakna ni laka putaulan, vachuꞌ jantu matichun kꞌaꞌun yu ancha kataulal. ");
INSERT INTO tptNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Taval ni Jesús ali ixtꞌaltanan taꞌal yu xaputaulanin taꞌan ukstsꞌuniy yu ay laka putaulan Cesarea de Felipo. Tejkan taꞌantacha lakatin, ni Jesús jalaklhisakmil ixtꞌaltanan, va lakjunil: —¿Tas ayuchacha talhilay ni lapanakni ni kitꞌin ijkunita? ");
INSERT INTO tptNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ex ixtꞌaltanan va tajunil: —Lati lapanakni tanajun va Juan kꞌatꞌi yu jamaqchajꞌavanaꞌ. Alati tanajun va Elías kꞌatꞌi. Yu alati tanajun va xaqayntaun kꞌatꞌi yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ex chuncha ni Jesús va lakjunil ni ixtꞌaltanan: —Chavay yu uxiknankꞌan, ¿tasꞌayucha naunatꞌik ijkunita ni kitꞌin? Ex chuncha yu Pedro va junil: —Uxintꞌi va Cristo kꞌatꞌi yu malaqachatan ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ex ni Jesús va jalaqxaqalal ixtꞌaltanan para jantu matichun katalaqputeꞌenil ni va yucha ni Cristo. ");
INSERT INTO tptNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ex chuncha ni Jesús va aqtaynilcha jalakmalaniy ixtꞌaltanan, lakjunil ni yucha yu Sasꞌatꞌa Lapanakni kamaqanlqajnanaꞌ. Naul ni yu lajꞌay xapaynin ali yu xaꞌukxtinin kuras vachu yu tamalaninin ixlhachimoꞌonkꞌan, yuꞌuncha katalaktanchaniyaꞌ. Vachuꞌ naul ni katamaqniyaꞌ pero yu laꞌatꞌutunuꞌ julchan kakujchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Vas lakjunil ni chuncha kunaꞌ. Ex ni Pedro va tumpaj lhaꞌal ni Jesús, aqtayl laqꞌaymay por yu naul. ");
INSERT INTO tptNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ex ni Jesús talaqaspꞌiklhi, jalaqtsꞌil yu alati ixtꞌaltanan, laqꞌaymachoqol ni Pedro, va junil: —¡Tumpajcha kaꞌuntꞌi kun kitꞌin, Satanás kꞌatꞌi! Jantu pꞌastꞌakꞌa tacha pastakꞌa ni Dios, va pꞌastꞌakꞌa tacha tapastakꞌa ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ex ni Jesús lakjuntaꞌil ni ixtꞌaltanan ali yu alati lapanakni yu ancha ixtavilanal, va jalakjunil: —Incha matichun kintꞌatiꞌukxuntayaputun, yucha jantucha lay makay yu makaputun. Kaval tacha kalhaꞌal ixkurus, ex chuncha lay kintꞌatiꞌukxuntayalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chavay ni lapanaki yu ayaj lhitsukuputun ixjatsukunti, ni yucha kamaqatsꞌanqayaꞌ. Pero yu maqatsꞌanqay ixjatsukunti por kitꞌin y por laqputeꞌey yu ox chivinti, yucha kalhitsukuchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Tisuncha lhajaycha qayntaun lapanaki incha kalhitsukuꞌol tachun yu alin lakamunukpaꞌ pero va maqatsꞌanqay ixjatsukunti? ");
INSERT INTO tptNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Tas kapulhitsukuchoqoyaꞌ ixjatsukunti? ");
INSERT INTO tptNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ni lapanakni yu chavaycha tatꞌajun va tamaqtaqalhinin y talaktuꞌunun. Incha qayntaun lapanaki kilhimaxanan ni kitꞌin kun kinchivinti, ex ni kitꞌin yu kval Sasꞌatꞌa Lapanaki vachu kaklhimaxananaꞌ ni yucha, tejkan kakminchoqotachal la ixtapꞌasta kimPay kun ixmayulnin. ");
INSERT INTO tptNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ex chuncha vachuꞌ lakjunil ni Jesús: —Laqsaval klajunau, lati lapanakni yu chavay aniy taꞌalinta, jantu kataniyaꞌ tus katalaqtsꞌinꞌelayaꞌ tacha kunaꞌ tejkan ni Dios kalhachimoꞌonunaꞌ aniy lakamunukpaꞌ kun tachun ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ex tejkan laqachaxan julchan val, ni Jesús va al taun ay aspajun. Vamun jalaklhaꞌal ni Pedro ali Jacobo ali Juan. Ex chuncha la ixlakaꞌukxpukꞌan ni yuꞌuncha, ni Jesús va tapaxal tacha ixtasuta. ");
INSERT INTO tptNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yu ixlaqchꞌiti va tus kꞌuliksnaꞌ val, tus ox yaqaq val. Ixyaqaqaxtu va tus jantu matichun lay temaniy ixchaꞌaka tacha val. ");
INSERT INTO tptNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ex vachu yu Elías ali yu Moisés tatasul, va ixtatꞌajun lakchivinin kun Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ex chuncha ni Pedro va junil ni Jesús: —Jamalaniniꞌ, ¡La ox kꞌalintau aniy! Chavay klamakaniyau aqatꞌutu moqltaꞌ. Aqataun para uxintꞌi, yu aqataun para Moisés yu aqataun para Elías. ");
INSERT INTO tptNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yu Pedro jantucha ixkꞌatsay yu ixnajun. Yucha ali ixtꞌaltanan va ayaj ixtatalhananta. ");
INSERT INTO tptNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ex chil laqataun taputsꞌi, va laqꞌoqxtꞌaqyaukal. Chivinkal laka taputsꞌi, va naunkal: —Ni aniy kintsꞌal yu kꞌachaniy. La ox kꞌaꞌalasmaktꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ex va chuncha, va tus xvilin talakavananꞌol, va jantucha matichun katatꞌatayal. Vamuncha ni Jesús xꞌaman ixyal. ");
INSERT INTO tptNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tejkan taminchoqochalcha ni aspajun ni Jesús va lakjunil ixtꞌaltanan ni jantu matichun katalaqputeꞌenil yu talaqtsꞌil tus tejkan kakujchoqoyaꞌ laka janinin ni yucha, yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ex chuncha valiꞌiycha vak taval, jantu matichun kataputeꞌenil. Pero siya yuꞌuncha va ixtalalhisakmiy tisuncha naunputuncha ni kakujchoqoyaꞌ laka janinin. ");
INSERT INTO tptNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ex va chuncha va talhisakmil ni Jesús: —¿Valiꞌiycha yu xajamalaninin yuꞌuncha tanajun ni pꞌunaj kaminꞌelayaꞌ ni Elías ex astan kaminaꞌ ni Cristo yu kamalaqachayaꞌ Dios? ");
INSERT INTO tptNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ex ni Jesús va naul: —Chun, laqsaval, ixchivinti Dios najun ni Elías pꞌunaj kaminꞌelayaꞌ, kalaqlaꞌoxiyaꞌ tachun. ¿Ex tacha lhitsꞌoqkanta la ixchivinti Dios yu Sasꞌatꞌa Lapanaki? Najun ni tejkan kaminaꞌ, va jantu ox katalaqtsꞌinaꞌ, ayaj kamaqanlqajnanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kitꞌin klajunau qayntaun tacha Elías kilatachilcha. Ni lapanakni jantu katalaqaꞌil, va tamakaꞌol tachun yu yuꞌuncha tamakaniputulcha, va xajchal tacha maqancha tsꞌoqkanta la ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Taval taminchoqolcha taꞌan ixtavilanal yu alati ixtꞌaltanan. Laqtsꞌil qaynlhuu lapanakni tus xvilin ixtamalaqachoqoxnuta. Vachu ancha ixtaꞌalinta yu ixtamalaniy ixlhachimoꞌonkꞌan. Yuꞌuncha ixtatꞌajun lalaqꞌaymanin kun ixtꞌaltanan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tejkan talaqtsꞌil ni Jesús va tus tachun vak takꞌatsal, tatakyaulaqꞌalcha mastakꞌanan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ex ni Jesús va lakjunil ixtꞌaltanan: —¿Tisuncha tꞌaunatꞌik lalhilaqꞌaymanin? ");
INSERT INTO tptNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ex qayntaun xapay yu ancha ixyal, va naul: —Jamalaniniꞌ, yu kitꞌin klhiminitan ni kesꞌatꞌa, va lhitꞌajun yu jantu ox espíritu, va janunuꞌ makay. ");
INSERT INTO tptNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Mas va toꞌoxtaycha chꞌapayachalcha ni anchanuꞌ jantu ox espíritu tus maqtay lakatꞌun. Aqtayniycha qalpuputamay ni lakatꞌun, tus kꞌatꞌuj kꞌatꞌuj lakmakaniy ixtatsalati, tus ox evij jun ixlakatunaj. Chavay yu mintꞌaltanan klaklhijunil ni palay katamakal pero jantu lay palay katamakal. ");
INSERT INTO tptNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ex ni Jesús va naul: —¡Yu uxiknan jantu lay lhakꞌapꞌupꞌinatꞌik! ¿Tus tavanancha kaktamakaunaꞌ kun uxiknan? ¿Tus tavanancha kaklatayaniyaucha? Kꞌalhitꞌantꞌikcha aniy ni tsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ex va lhiminkalcha ni tsꞌal. Yu jantu ox espíritu tejkan laqtsꞌilcha ni Jesús, va aaqtaun chꞌapachoqolcha. Va maqtal lakatꞌun, maxkapꞌiknil, va qalpuputamalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ex ni Jesús va naul: —¿La maqancha aqtaynita? Yu japay va naul: —Vananajcha tus ixpulakatꞌunixtucha. ");
INSERT INTO tptNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yu jantu ox espíritu tsaj maqtay laka jikmi, vachu lakxkan, va laycha kamaqnilcha. Incha lay makꞌay tuꞌuchun, va knajun kilamapayniu, kilaꞌaqtayjuu. ");
INSERT INTO tptNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ex chuncha ni Jesús va naul: —Incha lay lhakꞌapꞌupꞌin. Yu lhakapuꞌanan tus tachun lay makaniꞌokan. ");
INSERT INTO tptNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ex chuncha yu ixpay va tus pꞌas tꞌasal va naul: —¡Chun! ¡Klhakapuꞌan! ¡Va knajun kꞌiꞌaqtꞌayꞌutꞌi para apalay ox kaklhakapuꞌal! ");
INSERT INTO tptNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ex chuncha ni Jesús tejkan jalaqtsꞌil ni tatakyauminta alati lapanakni va aqtaynil laqꞌaymay yu jantu ox espíritu, va naul: —¡Uxintꞌi janunuꞌ aqatapa espíritu kꞌatꞌi, kitꞌin kunan kꞌamakꞌaunchꞌoꞌocha ni aniy tsꞌal. Jantucha aaqtaun kachꞌapꞌachꞌoꞌo! ");
INSERT INTO tptNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ex va chuncha ni espíritu tus sqau tꞌasal, va aqtaun maxkapꞌiknil ni tsꞌal, ex chuncha va taxtunichoqolcha la ixlakatunaj. Va makaul tacha janinicha. Ex chuncha yu alati lapanakni va ixtanajun: —¡Ka va nilcha! ");
INSERT INTO tptNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero yu Jesús maqchꞌapal, va maꞌostaulnil, ex ni tsꞌal va tayachoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ex chuncha ni Jesús va tatꞌatanul ixtꞌaltanan laqa chaqaꞌ. Ex yuꞌuncha va saq talhisakmil ni Jesús, va tajunil: —¿Valiꞌiycha ni kijnankꞌan jantu lay kakmaxtuu ni anchanuꞌ jantu ox espíritu? ");
INSERT INTO tptNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ni Jesús va jalakjunil: —Incha maxtꞌupꞌutꞌun tacha anchanuꞌ jantu ox espíritu, ex maqskꞌiniy kaskꞌin Dios kun taskꞌajati. ");
INSERT INTO tptNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ex chuncha tejkan taminchoqochalcha va tatapasal xalakatꞌun Galilea. Ni Jesús va ixnajun jantu matichun kakꞌatsal ni toꞌoxtay taꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Va ixtꞌajun jalakmalaniniꞌ ixtꞌaltanan ixlaqꞌamankꞌan, va ixlakjuniy: —Kitꞌin yu Sasꞌatꞌa Lapanakni kakmaqxtaqnikanaꞌ la ixtamakakꞌan ni lapanakni. Kintamaqniyaꞌ pero tejkan katapasayaꞌ paqtꞌutu ex kaktakukchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yu ixtꞌaltanan va jantu ixtamalaqasiy yu ixlakjunkan. Va ayaj ixtatalhauniy xlhiyucha jantu katalhisakmil tisuncha ixnaunputuncha ni anchanuꞌ chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ex tachaꞌalcha ni laka putaulan Capernaúm. Tejkan ixtavilanal laqataun chaqaꞌ, ex ni Jesús va laklhisakmil, va lakjunil: —¿Tis va suncha ni lhilakchꞌivinatꞌikcha ni lakatin? ");
INSERT INTO tptNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yuꞌuncha va tus saq taval. Yu lakatin va ixtalhilakchivijminta taꞌayucha yu apalay ay. ");
INSERT INTO tptNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ni Jesús va taulalcha, va lakjuntaꞌil yu pumakautꞌuy ixtꞌaltanan, va lakjunil: —Incha matichun junputun yu apalay ay, ex maqskꞌiniy kaval yu apalay lakatꞌuniy, tacha qayntaun oqxtamati yu kalaqꞌaqtayjuꞌol tachun yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ex ni Jesús va maqchꞌapaꞌil qayntaun jasꞌatꞌa, va ancha maqayaul la ixtalakaꞌukxpukꞌan. Va chꞌixtaulal ni jasꞌatꞌa, va lakjunil ixtꞌaltanan: ");
INSERT INTO tptNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yu laqaꞌiy qayntaun jasꞌatꞌa tacha yu aniy va por chuncha klhinajun ni kitꞌin, yucha vachu kilaqaꞌiy ni kitꞌin. Yucha kilaqaꞌiy jantu vamun ni kitꞌin, vachu laqaꞌiy yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ni Juan va junil ni Jesús: —Jamalaniniꞌ, ni kijnankꞌan klaqtsꞌiu qayntaun lapanaki vachu maxtuy yu jantu ox espíritu, va mapaqaꞌuy mintaqaꞌuti. Pero ni yucha jantu kintꞌaltanakꞌan kaval, ex yu kijnankꞌan klaktanchaniu. ");
INSERT INTO tptNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ni Jesús va naul: —Jantu maqskꞌiniy kꞌalaktꞌanchꞌanitꞌik. Taꞌayucha yu mapaqaꞌuy ni kintaqaꞌuti ex chuncha pulay makay yu lajꞌay axtoqnuꞌ, yucha chꞌantaun kun kitꞌin. Yucha jantu lay kilaktuꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yu jantu kintaxkayyan yuꞌuncha va kintaꞌaqtayjuyan. ");
INSERT INTO tptNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Laqsaval klajunau yu kataxtaqnin mas va taun tasa xkan va por kilapanakni untꞌatꞌik, yucha kalaqaꞌiyaꞌ ixlhilhajati. ");
INSERT INTO tptNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Mas va taꞌayuchacha kaval incha kamakal para kamaqtaqalhinil qayntaun kilapanaki tacha yu aniy lakatꞌuniy jasꞌatꞌa, ex ni yucha ayaj lhitaꞌay katapasayaꞌ. Apalay ox kaval ni kapixtuchꞌiꞌulakalcha kun xachiyux pachꞌikni, ex kaꞌankalcha ixmajꞌanka lakamar. ");
INSERT INTO tptNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chavay incha makꞌapꞌutꞌun talaqalhin kun mimakaꞌ, apalay ox kaval ni kꞌachꞌaqxmajꞌacha. Apalay ox kꞌatꞌanuchiy makltꞌul taꞌan alin yu ox jatsukunti y jantu ox kꞌatꞌanuchiy ni laqnin kun maktꞌuy laka jikmi taꞌan maqtajita yu jantu aqtaun mixa.  ");
INSERT INTO tptNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ancha jantu aqtaun miꞌojoy ni lakstꞌuniy tsapul vachuꞌ jantu aqtaun mixa ni jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Vachuꞌ incha kaꞌuxipꞌi makanaꞌ talaqalhin la minchꞌajaꞌ, apalay ox kaval ni kachꞌaqxmajꞌacha. Apalay ox mas va chꞌanltꞌul kꞌatꞌanuchiy taꞌan alin yu ox jatsukunti. Jantu ox kꞌatꞌanuchiy ni laqnin kun minchꞌantꞌuy taꞌan maqtayvil ni jikmi yu jantu aqtaun mixa.  ");
INSERT INTO tptNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ancha jantu aqtaun miꞌojoy ni lakstꞌuniy tsapul vachuꞌ jantu aqtaun mixa ni jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Vachuꞌ incha kꞌamakꞌapꞌutꞌu talaqalhin por yu laqtsꞌin la milaqchul, apalay ox kaval ni kꞌalakpꞌumaxtꞌukꞌa milaqchul. Apalay ox mas vamun milakputaun kꞌatꞌanuchiy taꞌan lhachimoꞌonun ni Dios y jantu kꞌatꞌanuchiy ni laqnin kun milakputꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ancha jantu aqtaun miꞌojoy ni lakstꞌuniy tsapul vachuꞌ jantu aqtaun mixa ni jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tachun kalaqlaꞌoxikanaꞌ kun jikmi, vachu va tacha tachun lapaxkan laꞌoxikan kun matsati. ");
INSERT INTO tptNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ni matsati va ox. Pero tejkan jantucha sꞌoꞌo jun ex jantucha lay sꞌoꞌo junchoqoy. Ox katꞌiꞌukxuntꞌayatꞌik ex kaxajtachal tacha kꞌalhitsꞌukꞌutꞌik matsati. Chuncha lay oxamaktaun kalatꞌatꞌiꞌukxuntꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Taval ni Jesús taxtuchoqolcha laka putaulan Capernaúm, al tus xalakatꞌun ni Judea, vachuꞌ al taꞌan ixlhiputakuktachal xalaꞌaxkan Jordán. Ni lapanakni aaqtaun tataqxtoqchoqol taꞌan ixvil. Ex chuncha va aqtayl jalakmasuniy tacha jalakmasuniꞌalhiycha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ex chuncha va tatalakanunil lati yu fariseos. Talaqtsꞌintanul, va talhisakmil incha qayntaun lapanaki lay kamakaunchoqol ixanati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ex chuncha ni Jesús va lakjunil: —¿Tas talhijunincha ni Moisés? ");
INSERT INTO tptNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ex chuncha yu fariseos va tanaul: —Ni Moisés yucha chun ixtaqta lakatin para kalaꞌoxitꞌi aqxtaun jalhiki yu kꞌapꞌulamakꞌau. ");
INSERT INTO tptNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ex ni Jesús va lakjunil: —Chun, laqsaval. Va ayaj pꞌas melhanutkꞌan, xlhiyucha ni Moisés chuncha lhinaul. ");
INSERT INTO tptNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Maqancha tejkan puꞌaqtaynil tachun, ni Dios makal joꞌati ali xanati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Xlhiyucha ni joꞌati makajun ixpay ali ixnati, va tꞌatsukuycha ixanati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ex chuncha yu pumatꞌuy va qayntauncha lapanaki jun. Jantucha qayntꞌuy kataval, va qayntauncha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ex chuncha yu malaqxtoqta ni Dios, jantu maqskꞌiniy katalaqlvaqlhi ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tejkan ixtavilananchoqolcha ni laqa chaqaꞌ, ixtꞌaltanan va aaqtaun talhisakmichoqol ni anchanuꞌ chivinti yu jalakjunil ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ex ni Jesús va naul: —Incha qayntaun joꞌati makajun ixanati ex tꞌatsukuchoqoy aqayntaun, yucha makaniy laqtaqal ixanati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Vachu incha qayntaun xanati makajun ixapay ex tꞌatsukuchoqoy aqayntaun, yucha makaniy laqtaqal ixapay. ");
INSERT INTO tptNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Taval talhiminil ni Jesús jasꞌatꞌan para kalaqmoqslanil ixmakaꞌ. Ixtꞌaltanan va talaqꞌaymal yu ixtalhimin yu jasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ex ni Jesús tejkan chuncha jalaqtsꞌil, va jalaqtalqaunil ixtꞌaltanan, va naul: —Kalakmakꞌauntꞌikcha ni jasꞌatꞌan chaqx kintalaqmilcha ni kitꞌin. Jantu kalaqꞌaymatꞌik. Ni lapanakni yu katanuyaꞌ taꞌan jalhachimoꞌonun ni Dios maqskꞌiniy kataval tacha yu aniy jasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Laqsaval klajunau, qayntaun lapanaki maqskꞌiniy kalaqaꞌil ni kalhichimoꞌol ni Dios vachu va tacha qayntaun jasꞌatꞌa laqaꞌiy kalhichimoꞌokal. Incha jantu, ex jantu aqtaun katanuyaꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ex ni Jesús jalakchꞌixlhi, va jalaqmoqslanil ixmakaꞌ ni jasꞌatꞌan. Lakskꞌinil Dios para ox kataval ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ex tejkan ixꞌanchoqotacha lakatin ni Jesús, takyaulaqminta qayntaun joꞌati, taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ ni Jesús, va junil: —Oxi jamalaniniꞌ kꞌatꞌi, ¿tas kakmakalcha para kaklhitsukul ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ex ni Jesús va naul: —¿Valiꞌiychacha kꞌiꞌuniycha ni kꞌoxi kunita? Jantu matichun yu ox kaval, yu ox vamun Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uxintꞌi ka mispꞌaycha tacha lhinaunkan: “Jantu kꞌatꞌatsꞌukꞌu aqayntaun yu jantu minavin, jantu kꞌamaqnin, jantu kaꞌalhavan, jantu kꞌamanunin jalaklkanti matichun, jantu kꞌamakꞌanun, ox katꞌoꞌoyatꞌi yu mimpay ali minati.” ");
INSERT INTO tptNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ex chuncha ni anchanuꞌ joꞌati va naul: —Jamalaniniꞌ, tus tsꞌal xajkunita tus chavaycha vananaj chuncha kmakaꞌojoy. ");
INSERT INTO tptNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ex ni Jesús laqtsꞌil y mapaynil, va junil: —Ni uxintꞌi va taun tuꞌuchun tsꞌanqaniyan. Chavay kapꞌinchꞌiycha lakstꞌanaꞌ tachun mimaqaliti, ex yu xatapal kalaqxtꞌaqniyeꞌecha yu kilpatanin. Chuncha mimaqaliti kꞌalhitsꞌukꞌutꞌachiycha ni laktꞌiyan. Ex katꞌatꞌicha, kꞌintꞌatꞌiꞌukxuntꞌaycha ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tejkan chuncha qasmaklhi ni anchanuꞌ joꞌati va tus xiyan lal, va ay maqaliꞌ ixjunita, xlhiyucha va maqaninijꞌanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ex chuncha ni Jesús va talaqaspꞌiklaqtsꞌinꞌol ixtꞌaltanan, va lakjunil: —¡Laqsaval yu maqalinin va ayaj lhitaꞌay ni katatanuchal taꞌan jalhachimoꞌonun ni Dios! ");
INSERT INTO tptNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ex yu ixtꞌaltanan tejkan chuncha taqasmaklhi ni anchanuꞌ chivinti va tus vak takꞌatsal, pero ni Jesús va aaqtaun lakjunchoqol: —Kesꞌatꞌanin, laqsaval va ayaj lhitaꞌay katatanul taꞌan lhachimoꞌonun ni Dios yu talhiꞌajin vamun ixmaqalitkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jantu lay kapulaqpuslhi laqataun camello taꞌan tisalal ni makskati. Apalay lhitaꞌay katanuchal qayntaun maqaliꞌ taꞌan jalhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tejkan chuncha taqasmaklhi ixtꞌaltanan, va tus vak tamaqatsꞌanqanal. Ex chuncha taꞌaqtaylcha talalhisakmiy, va talajuniy: —¿Tasꞌayucha lay kalaqtaxtuyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ex ni Jesús jalaqtsꞌil, va lakjunil: —Jantu lay tamakay ni lapanakni pero Dios lay. Ni Dios tus tachun lay makay. ");
INSERT INTO tptNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ni Pedro va naul: —Ni kijnankꞌan klakmakaunꞌotaucha tachun yu xaklhitꞌaunau, ex klatꞌaltanantaucha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ex ni Jesús va lakjunil: —Laqsaval klajunau qayntaun lapanaki incha makajun ixchaqaꞌ, ixtꞌun, ixtꞌalaqaunin, ixtꞌalapanakni, ixpay ali ixnati ali sasꞌatꞌan va por kilapanaki kaval vachu por kalaqputeꞌel yu ox chivinti, ");
INSERT INTO tptNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yucha apalay lhuu kaxtaqnikanaꞌ aniy lakamunukpaꞌ. Ni Dios kaxtaqnichoqoyaꞌ apalay lhuu ixchaqan, ixtꞌun, ixtꞌalaqaunin, ixtꞌalapanakni, ixnatin, sasꞌatꞌan, mas kamaqanlqajnanaꞌ. Ex astan, tejkan kaꞌalinaꞌ yu ataun lakamunukpaꞌ, kalaqaꞌiyaꞌ jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Qaynlhuu yu chavay xalajꞌaynin tajunita astan katajunaꞌ xalakstꞌuninin. Yu chavay xalakstꞌuninin tajunita astan katajunaꞌ xalajꞌaynin. ");
INSERT INTO tptNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Taval ni Jesús ali ixtꞌaltanan va ixtaꞌantacha lakatin, ixtaꞌanta laka putaulan Jerusalén. Ni Jesús va ixlakmapꞌulata. Ni yuꞌuncha va tus vak ixtakꞌatsan, yu alati ixtatalhanan. Ex ni Jesús va lakjuntaꞌil yu pumakautꞌuy ixtꞌaltanan, va aqtayl jalaqputeꞌenin tacha kalhitapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Va naul: —Chavay teꞌenaucha ni Jerusalén. Ni kitꞌin yu Sasꞌatꞌa Lapanaki kakmaqxtaqkanaꞌ la ixtamakakꞌan yu xaꞌukxtinin kuras ali yu tamalaniy kilhachimoꞌonkꞌan. Kintamukꞌaniyaꞌ laqtaqal para kintamaqnil, ex kintamaqxtaqniyaꞌ la ixtamakakꞌan lapanakni yu jantu tamispay Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ex ni yuꞌuncha va kintalaktuꞌuyaꞌ, kintalakachujvayaꞌ, ayaj pꞌas kintalaqanaqmayaꞌ, tus kintamaqniyaꞌ. Mas kakniyaꞌ, yu laꞌatꞌutunu julchan kajkujchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ex chuncha ni Jacobo ali Juan yu istsꞌalan ni Zebedeo va tatalakanunil ni Jesús, va tajunil: —Jamalaniniꞌ, ni kijnankꞌan va knaunau kilamakaniu taun jamapayninti yu klaskꞌiniyau. ");
INSERT INTO tptNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ex ni Jesús va lakjunil: —¿Tisuncha naunatꞌikcha kaklamakaniu? ");
INSERT INTO tptNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ex yuꞌuncha va tanaul: —Tejkan kꞌalhachꞌimoꞌonuneꞌe kun tachun miꞌayaxtu, va knaunau kilaꞌulau qayntaun la milhijakanaj, yu aqayntaun la milhijamaqxu ex klatꞌalhachimoꞌonunau. ");
INSERT INTO tptNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ex ni Jesús va lakjunil: —Ni uxiknankꞌan jantu malaꞌasiyatꞌik yu skꞌinatꞌik. ¿Kalayaꞌ kapꞌaꞌoqnunapitik yu xavaso jamaqanlqajnati yu kakpaꞌoqnunaꞌ? ¿Kalayaꞌ kꞌapꞌuꞌaqchꞌajꞌauyapitik yu jamaqanlqajnati tacha kitꞌin kakpuꞌaqchajꞌauyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yuꞌuncha va tanaul: —Chun, kalayaꞌ. Ex ni Jesús va lakjunil: —Laqsaval kꞌapꞌuꞌoqnunapitik ni vaso yu ikpaꞌoqnunaꞌ. Vachuꞌ kꞌapꞌuꞌaqchꞌajꞌauyapitik tacha ni kitꞌin ikpuꞌaqchajꞌauyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero yu kintꞌalhachimoꞌonunaꞌ la kilhijakanaj ali kilhijamaqxu, yucha jantu kimpaxtoqniy kitꞌin kakxtaqlhi. Kaxtaqnikanaꞌ yu jalaklhilkanikanta. ");
INSERT INTO tptNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yu alati pumakau ixtꞌaltanan, tejkan takꞌatsal yu taskꞌinil Jacobo ali Juan, va tatalqaunil. ");
INSERT INTO tptNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ex chuncha ni Jesús va lakjuntaꞌiꞌol, va naul: —Ni uxiknan ox kꞌatsꞌayatꞌik yu xalhachimoꞌonun aniy lakamunukpaꞌ talhichimoꞌoy laqatapꞌasta yu valiꞌiy lapanakni. Yu lajꞌaynin talhitꞌajun tapꞌasta para kalaklhijunil tas katamakal ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yu uxiknankꞌan jantu chun kꞌaꞌuntꞌik. Incha matichun ay junputun, yucha maqskꞌiniy kalaqꞌaqtayjul yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Siya uxiknan, incha matichun junputun yu apalay ay, yucha maqskꞌiniy kaval ixꞌoqxtamatkꞌan tachun yu alati. ");
INSERT INTO tptNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ni kitꞌin yu Sasꞌatꞌa Lapanaki jantu kakmil para kaktapatsanikal. Kitꞌin kminta para kaklaqꞌaqtayjul yu alati. Vachu kakmaqxtaꞌaꞌ ketsukunti para chuncha katapulaqtaxtul pumalhuu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Taval ni Jesús ali ixtꞌaltanan va tachaꞌalcha laka putaulan Jericó. Tejkan tataxtuchoqol ixtatꞌaꞌanta lhuvaj lapanakni. Ancha la ixkilpaꞌ lakatin ixvil qayntaun laꞌachꞌix yu ixjunkan Bartimeo yu istsꞌal ni Timeo. Va ixtꞌajun puskꞌiniꞌ tumin. ");
INSERT INTO tptNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tejkan kꞌatsalcha ni va ukstsꞌuniycha minta ni Jesús yu machaqaꞌ Nazaret, ex aqtaylcha tꞌasaniy, va juniy: —¡Jesús, sasꞌatꞌa ni ay jalhachimoꞌonuꞌ David, kitꞌin va knajun kꞌimapꞌaynitꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Yu alati va talaqꞌaymal, ixtajuniy ni vak kavalcha pero va taylhaꞌal tꞌasanaꞌ. Va ixnajun: —¡Sasꞌatꞌa ni ay jalhachimoꞌonu David. Kitꞌin va knajun ni kꞌimapꞌaynitꞌi! ");
INSERT INTO tptNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ex ni Jesús va tayal, lhinaul ixtꞌasanika. Ex ni lapanakni tajuntaꞌil ni laꞌachꞌix, va tajunil: —Kaꞌachꞌacha. Kaꞌostꞌaycha. Ni Jesús tꞌasaniyancha. ");
INSERT INTO tptNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ex ni laꞌachꞌix tanqalhulcha ixkutun. Va xliu jakꞌiuklnil, va laqchaꞌal ni Jesús taꞌan ixyal. ");
INSERT INTO tptNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ni Jesús va junil ni laꞌachꞌix: —¿Tis va suncha naꞌuncha ni kakmakanin? Ex va naul ni laꞌachꞌix: —Jamalaniniꞌ, kitꞌin klakavananputun. ");
INSERT INTO tptNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ni Jesús va junil: —Kꞌapꞌinchꞌoꞌocha. Va kꞌilhakꞌapꞌupꞌi, xlhiyucha palaycha xaꞌunchꞌoꞌoy. Ex ni laꞌachꞌix va niman lakavananchoqolcha, ex tꞌaꞌal ni Jesús lakatin. ");
INSERT INTO tptNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ex chuncha va ukstsꞌuniycha ixtatꞌajun yu ay laka putaulan Jerusalén. Ixtaꞌantacha yu lakstꞌuniy putaulanin yu junkan Betfagé ali Betania ancha taꞌan alin yu xaꞌaspajun Olivos. Ni Jesús va jalaqmalaqachal pumatꞌuy ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jalakjunil: —Kꞌapꞌinchꞌipitik ni avintꞌi lakatꞌuniy putaulan. Tejkan kachꞌipꞌinapitik ancha katꞌemayapitik laqataun sasꞌatꞌa burro jachꞌiꞌulanti yu jantukaꞌ matichun putaukꞌay. Kaxꞌoqꞌiyapitik, kꞌalhitꞌanapitik aniy. ");
INSERT INTO tptNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chavay incha matichun katajunan: “¿Valiꞌiycha tꞌilhipꞌinatꞌikcha ni burro?”, ex ni uxiknankꞌan kaꞌunapitik: “Maqskꞌiniy ni Jalhachimoꞌonuꞌ, va niman katamalaqachanichoqoyan”, chuncha kaꞌunapitik. ");
INSERT INTO tptNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ex chuncha ni yuꞌuncha va taꞌalcha. Tejkan tachaꞌal laqsaval tatemal ni laqataun sasꞌatꞌa burro jachꞌiꞌulanti taꞌan puchaankan lakatin ukstsꞌuniy ni laka matiꞌ. Ex va taxꞌoqꞌilcha ni burro. ");
INSERT INTO tptNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lati lapanakni yu ancha machaqan va ancha ixtayanal. Va tanaul: —¿Tisuncha makꞌayatꞌik? ¿Valiꞌiycha xꞌoqꞌiyatꞌikcha ni burro? ");
INSERT INTO tptNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ex yuꞌuncha va tajunil yu tacha ni Jesús ixlakjunita. Ex chuncha va lakmakaunikalcha ni katalhaꞌalcha ni sasꞌatꞌa burro. ");
INSERT INTO tptNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ex chuncha va talhaanilcha ni sasꞌatꞌa burro ni Jesús, va tamukꞌaniꞌolcha yu ixlhimaqapaqakankꞌan. Ex ni Jesús va putaukꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lhuvaj lapanakni tapuxnujtaynil ixlaqchꞌitkꞌan lakatin. Alati va talaqchaqxꞌil ixmaqlaqapꞌun ni kꞌivinan, va tamamalhaꞌanil ni lakatin. ");
INSERT INTO tptNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ex va chuncha ni lapanakni yu ixtapꞌulanan, vachu yu astan ixtaminta va tus tachun ixtalaktꞌasaꞌanta, ixtanajun: —¡Hosana! ¡Katoꞌoyakal yu minta la ixtaqaꞌuti ni Jalhachimoꞌonu Dios! ");
INSERT INTO tptNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Va ayaj ox tacha lhachimoꞌonun, tacha yu maqaniya kimpaykꞌan David! ¡Hosana kanaunkal laktꞌiyan! ");
INSERT INTO tptNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chuncha ni Jesús va tanuchalcha ni ay laka putaulan Jerusalén. Kitanul yu ay lakatajtan, laqtsꞌinꞌol tachun yu ancha taꞌalin, va toqoxalcha. Ex ni Jesús kun yu pumakautꞌuy ixtꞌaltanan va taꞌalcha laka putaulan Betania. ");
INSERT INTO tptNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ataun julchan val, tejkan tataxtuchoqochal ni Betania ni Jesús va chavanilcha. ");
INSERT INTO tptNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Va laqtsꞌil aqataun xakꞌiu ni higo, pumaqati, va la ox ixlaqajunta. Va laqꞌal taꞌan ixyal ni higo. Lhilal ni kataukꞌal xaꞌunikan pero yu higo va nisin kataukꞌal, vamun xaxqoy ixlhitꞌajun. Jantu ixputaukꞌan kaval ni higos. ");
INSERT INTO tptNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ex ni Jesús va junil ni xakꞌiu ni higo: —Chavay ni uxintꞌi ijkunan tus jantucha aqtaun matichun kaꞌuniyan ni miꞌunikan. Ex chuncha yu ixtꞌaltanan va taqasmaklhi. ");
INSERT INTO tptNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ex chuncha tachanchoqolcha ni Jerusalén, ni Jesús va tanuchoqochal ni ay lakatajtan. Va aqtaynil jalakxkauxtuy yu ancha ixtatꞌajun jastꞌanan vachu yu ixtatꞌajun jaꞌinin. Va jalaqtanqalhuꞌol ixmesaskꞌan taꞌan ixtapumapaxaniy tumin ni lapanakni, vachu ixputaulankꞌan yu ixtastꞌay ni tukunun. ");
INSERT INTO tptNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jantu kaxtaqlhi lakatin matichun katapasal ixpulakna yu ay lakatajtan incha kalhaꞌal tuꞌuchun lhistꞌati. ");
INSERT INTO tptNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ex chuncha ni Jesús aqtayl jalakmalaniy, va naul: —Yu tsꞌoqkanta la ixchivinti Dios najun: “Ni kinchaqaꞌ yucha va xachaqaꞌ yu puskꞌinkan Dios para oqxlaqchux lapanakni.” Pero yu uxiknankꞌan va lhimapꞌatsꞌatꞌatꞌik xachaqaꞌ paꞌalhavanti. ");
INSERT INTO tptNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Va taqasmaklhi yu xaꞌukxtinin ni kuras ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Ex ni yuꞌuncha va tapuxkaulaqtsꞌilcha tacha pulay katamaqnil ni Jesús. Va ayaj ixtatalhauniy. Ni lapanakni vamuncha tus taun talhilal yu tacha ixjamalaninin. ");
INSERT INTO tptNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tejkan putsꞌislhicha, ex ni Jesús ali ixtꞌaltanan va tataxtul ni ay putaulan. ");
INSERT INTO tptNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ex va chuncha tejkan tunkunchoqol puvakuj, va ancha tatapasal taꞌan ixyal ni xakꞌiu ni higo. Va talaqtsꞌil ni va tus ox xixta vachu tus tachun ni xatisiviki. ");
INSERT INTO tptNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ex va chuncha yu Pedro va pastaklhi, va junil ni Jesús: —Jamalaniniꞌ, yu xakꞌiu ni higo yu laqꞌaymatꞌi chavay xixyalcha. ");
INSERT INTO tptNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ex yu Jesús va naul: —Kꞌalhakꞌapꞌupꞌintꞌik ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Laqsaval klajunau, qayntaun lay kajunil ni aniy aspajun: “Kaꞌostꞌicha ni aniy, kapꞌinchꞌiycha ni lakamar”. Incha jantu tꞌuy jatapastakꞌati kalhitsukul, incha ox kalhakapuꞌalcha ni katapasayaꞌ yu najun, ex chuncha kunaꞌ tacha najun. ");
INSERT INTO tptNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Xlhiyucha klajunau tejkan tꞌachꞌivinanatꞌik Dios, tachun yu skꞌinatꞌik, kalhakꞌapꞌupꞌintꞌik ni kalaꞌaꞌiyapitik, ex chuncha kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tejkan tꞌachꞌivinanatꞌik Dios, incha matichun tamakanitan taun laqtaqal maqskꞌiniy kamalaqmixinitꞌik. Ex chuncha mimPaykꞌan yu alintachal laktꞌiyan vachu katamalaqmixiniyan milaqtaqalkꞌan.  ");
INSERT INTO tptNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Incha jantu kꞌamalaqmixiniyapitik yu tamakaniyan laqtaqal, ex vachu yu mimPay Dioskꞌan jantu katamalaqmixiniyan mintalaqalhinkꞌan ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Taval va tachanchoqol aaqtaun Jerusalén. Ni Jesús va ixtiꞌukxuyal ni ay lakatajtan. Ancha yu xaꞌukxtinin ni kuras ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu xalajꞌaynin lapanakni, yuꞌuncha va tatalakanunil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ex ni yuꞌuncha va tajunil ni Jesús: —¿Taꞌayucha xtaqnin lhachimoꞌon ni kꞌamakꞌatꞌi yu aniy axtoqnu? ¿Taꞌayuchacha lhijunan ni chuncha kꞌamakꞌatꞌi? ");
INSERT INTO tptNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús va lakjunil: —Kitꞌin vachuꞌ klalhisakmiyau taun jalhisakminti. Incha kilajunau, ex yu kitꞌin vachu klajunau taꞌayucha kixtaqniy lakatin ni klakmakay yu axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ex chuncha va lakjunil: —¿Tas ayucha malaqachalcha ni Juan jamaqchajꞌavanaꞌ? ¿Va Dios u va lapanaki? Chavay kilajuniu. ");
INSERT INTO tptNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ex ni yuꞌuncha va taꞌaqtaylcha talakchiviniy siya yuꞌuncha, va tanaul: —Incha kajunau va Dios malaqachal, ex chuncha kintajunin: “¿Ex valiꞌiycha jantu kalhakꞌapꞌupꞌintꞌik?” ");
INSERT INTO tptNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero incha kajunau va lapanakni tamalaqachal, ¿ex tas kaval? Jantu ixtanaunputun ni va lapanakni yu tamalaqachal ni Juan. Ixtatalhauniy yu alati lapanakni, yu yuꞌuncha va ixtalhakapuꞌaniꞌojota ni Juan va laqsaval ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ex chuncha tajunil ni Jesús: —Jantu ijkꞌatsayau. Ex chuncha ni yucha va lakjunil: —Ex ni kitꞌin vachuꞌ jantu kaklajunau tas ayucha kixtaqnil lhachimoꞌon yu ikpumakay ni aniy axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Taval ni Jesús va aqtaylcha jalaqlhixaqalay, jalakjunil taun chivinti yu xtaꞌa jatapastakꞌati: —Ixꞌalin qayntaun joꞌati, ixchꞌanta uvas la ixtꞌun. Ex chuncha va korrarnul y vachu va makal ay kanuvaj taꞌan tachꞌikmujul yu xaxkan ni uva. Makal taun ay torre yu lay kapulhistakꞌokal ixtꞌun. Ex va laqxtaqnil amedias ixtꞌun ni tapatsanin, ex va alcha tiꞌukxuntayan maqati. ");
INSERT INTO tptNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ex chuncha va lakachilcha ixpupꞌuxkan ni uvas. Yu xaꞌukxtin va malaqachal qayntaun ixꞌoqxtamati para kalaqaꞌil yu kapaxtoqniyaꞌ ni xamanavin. ");
INSERT INTO tptNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yu tapatsanin va tamaqchꞌapaꞌil ni anchanuꞌ oqxtamati va talakasamal. Valiꞌiy tamalaqachachoqol, jantu tuꞌuchun kataxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ex yu xamanavin tꞌun va malaqachachoqol aqayntaun ixꞌoqxtamati. Ex anchanuꞌ oqxtamati va talakatꞌalmal va talaqpacheꞌel, ayaj talaktuꞌul. ");
INSERT INTO tptNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ex yu xamanavin va aaqtaun malaqachachoqol ataun ixꞌoqxtamati. Ni yucha va tamaqnilcha. Taval yu manavin va jalaqmalaqachachoqol pumalhuu alati. Lati vamun laqanaqmakal, alati va jalaqmaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Yu jamanavin tꞌun va ixlhitꞌajun qayntaun istsꞌal, vamun yuꞌ. Ayaj ixꞌachaniy. Ex taval va malaqachal yu istsꞌal, va ixnajun: —Ka katatoꞌoyayacha kintsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ex yu tapatsanin va aqtayl talajuniy siya yuꞌuncha: “Ni anu lapanaki ka yucha yu kapaxtoqniyacha ni lhitapatsa. Chavay ni yucha vachuꞌ kamaqniyau. Ex chuncha yu lhitapatsa kijnanchkꞌan kintapaxtoqniyan.” ");
INSERT INTO tptNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ex tachꞌapachalcha ni tapatsanin, va tamaqnil. Tejkan tamaqnil va tamaxtul ixlakatunaj ixlhimaqspa taꞌan ixchꞌankanta ni uvas. ");
INSERT INTO tptNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ex chuncha yu Jesús va naul: —¿Tas kamakayacha yu manavin lakatꞌun? Va kaminaꞌ jalaqmaqniniꞌ yu tapatsanin ex kalaqxtaqniyaꞌ yu lakatꞌun alati lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ex ni Jesús vachu lakjunil: —¿Jantu pꞌutꞌeꞌeyatꞌik taꞌan tsꞌoqkanta la ixchivinti Dios yu najun inchineꞌ? Ni chiyux yu jantu kamapatsaputul yu tamakay chaqaꞌ chavay yucha yu apalay maqskꞌiniy. ");
INSERT INTO tptNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chuncha makal ni Jalhachimoꞌonuꞌ, xlhiyucha tus taun kꞌatsanau. ");
INSERT INTO tptNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ex va chuncha ni xalajꞌaynin va tamalaqasil ni lhichivinil ixputsukukꞌan ni yuꞌuncha. Xlhiyucha va ixtachꞌapaputun ni Jesús. Pero va tatalhaunichoqol ni lapanakni, ex va chuncha tamakaulcha, va taꞌanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Taval jamalaqachakal lati yu fariseos ali lati yu chꞌantaun ixtajunita kun yu lhachimoꞌonuꞌ Herodes. Talaqꞌal ni Jesús, va talhisakmil taun chivinti para lay kataputislajmal. ");
INSERT INTO tptNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ex chuncha ni anchanuꞌ lapanakni va talaqꞌal ni Jesús: —Jamalaniniꞌ, laqsaval ni kijnankꞌan ijkꞌatsayau ni uxintꞌi laqpꞌutꞌeꞌey vamun yu laqsaval, jantu pastakꞌuyan yu katanaul ni lapanakni. Uxintꞌi jantu makꞌay kuenta taꞌayucha ni lapanaki, va laqsaval jamalaninin tacha junita ixlakatin ni Dios. Chavay klalhisakmiyau, ¿maqskꞌiniy kamapalniu impuestos yu ay jalhachimoꞌonu Roma? ¿Kamapalau u jantu kamapalau? ");
INSERT INTO tptNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ex va chuncha ni Jesús va ixkꞌatsaycha ni tꞌuy ukxpuꞌ ixtamakaniy. Ex va lakjunil: —¿Valiꞌiycha ni kilalaqtsꞌintanuyaucha? Kilalhiminiu aqxtaun tumin para kaklaqtsꞌil. ");
INSERT INTO tptNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ex chuncha va talhiminil aqxtaun tumin, va lakjunil: —¿Ni aniy tumin tasꞌayuchacha ixꞌukxpucha y tasꞌayucha ixtaqaꞌuti tsꞌoqmukꞌanikanta? Ex ni yuꞌuncha va tanaul: —Va yu ay jalhachimoꞌonuꞌ Roma. ");
INSERT INTO tptNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ex ni Jesús va lakjunil: —Kaxtꞌaqnitꞌik yu ay jalhachimoꞌonuꞌ Roma va yu paxtoqniycha ni yucha. Vachu kaxtꞌaqnitꞌik ni Dios va yu paxtoqniycha ni yucha. Ex chuncha ni anchanuꞌ lapanakni va tus tauncha talhilal tacha naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ex va chuncha lati ni saduceos va talaqꞌal ni Jesús. Yuꞌuncha ixtanajun ni jantu takujchoqoy yu janinin. Ex va xlhiyucha talhisakmil ni aniy chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Va tajunil ni Jesús: —Jamalaniniꞌ, ni Moisés kintamakaunin jatsꞌoqnuti yu inchine najun. Incha kanil qayntaun lapanaki, va kanimakaul ixanati, incha jantu kalhitsukunil sasꞌatꞌa, ex ixlaqaj, yu ixpꞌisaqa, maqskꞌiniy katꞌatsukuchoqol ixqol para kalhitsukunil sasꞌatꞌa yu xajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ex va chuncha, taun julchan ixꞌalin qayntujun tꞌalaqaunin. Yu xajayaꞌ va lakxtuklal, taval nilcha pero va jantu kamakaul ni sasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ex chuncha yu xapꞌisaqa tꞌatsukul ni ixqol. Taval vachu nil pero vachu jantu kamakaul ni sasꞌatꞌan. Chavay yu xapumatꞌutunuꞌ tꞌalaqajun va tꞌatsukul ni ixqol vachu va chun tapasal. Va jantu kamakaunil ni sasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Va chuncha ni anchanuꞌ pumatujun tꞌalaqaunin va tus laktꞌatsukuꞌol ni anchanuꞌ xanati, pero jantu matichun kalhitsukunil sasꞌatꞌa. Taval vachu va nil ni anchanuꞌ xanati. ");
INSERT INTO tptNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chavay ni kijnankꞌan ijkꞌatsaputunau tejkan katakujchoqoyaꞌ ni janinin ¿Taꞌayuchacha yu ixanaticha kunaꞌ? Yu anchanuꞌ pumatujun si talhitsukul tacha ixanatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ex chuncha ni Jesús va lakjunil: —Ni uxiknankꞌan jantu pꞌastꞌakꞌatꞌik yu naunatꞌik. Jantu mispꞌayatꞌik tacha tsꞌoqkanta la ixchivinti Dios. Vachu jantu mispꞌayatꞌik tacha junita ixtapꞌasta ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tejkan katakujchoqoyaꞌ ni janinin, ex ni yuꞌuncha jantucha katalakxtuklayaꞌ. Va katajunaꞌ tacha ixmayulnin Dios laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chavay naunatꞌik ni jantu katakujchoqoyaꞌ ni janinin. ¿Ex jantu aqtaun pꞌutꞌeꞌeyatꞌik taꞌan tsꞌoqkanta la ixlibro ni Moisés taꞌan lhichivinkan laqa qalapꞌu yu ixmaqtajita? Ancha ni Dios va junil ni Moisés: “Ni kitꞌin va ixDios ni Abraham, vachu ni ixDios ni Isaac vachu ni ixDios ni Jacob.” ");
INSERT INTO tptNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ex chuncha ni Dios jantu ixDios kaval yu janinin, va ixDios yu takujta. Ni uxiknan oqspꞌalatꞌik la mijatapastakꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ex vachuꞌ chinchal qayntaun xajamalaniniꞌ ixlhachimoꞌonkꞌan ni israelitas. Ni yucha va ixqasmaktacha ni la ox ixjaqaltayanan ni Jesús. Yucha lhisakmil ni Jesús va junil: —¿Tachun yu lhinaunkan la kilhachimoꞌonkꞌan, tisuncha yu apalay maqskꞌiniy kꞌamakꞌatꞌi? ");
INSERT INTO tptNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ni Jesús va naul: —Yu apalay maqskꞌiniy kamakꞌatꞌi va yu inchine najun. “Kaꞌalasmaktꞌik, israelitas untꞌatꞌik, ni kiJalhachimoꞌonukꞌan ni Dios va taun. ");
INSERT INTO tptNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kaꞌachꞌanincha ni Dios miJalhachimoꞌonuꞌ kun tachun melhanuti, ali tachun ni mijatsukunti, ali tachun mijatapastakꞌati, ali tachun ni mintapꞌasta.” Yucha yu apalay maqskꞌiniy kꞌamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yu ataun lhinaunkan va laycha vachu va chun. Va inchine najun: “Kꞌapꞌaxkꞌatꞌi mintꞌamachaqaꞌ tacha pꞌaxkꞌakꞌan milaqꞌaman.” Ni anchanuꞌ laꞌatꞌuy chivinti yu lhinaunkan va yuꞌuncha yu apalay maqskꞌiniy kamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ex va chuncha yu xajamalaniniꞌ ixlhachimoꞌonkꞌan ni israelitas va naul, junkal ni Jesús: —Jamalaniniꞌ, laqsaval tacha naꞌun ni Dios va taun, jantu kaꞌalil ataun. ");
INSERT INTO tptNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Maqskꞌiniy kaꞌachanin ni Dios kun tachun mejalhanuti ali tachun mijatapastakꞌati ali tachun ni mijatsukunti ali tachun mintapꞌasta. Vachuꞌ maqskꞌiniy kꞌapꞌaxkꞌatꞌi mintꞌamachaqaꞌ tacha pꞌaxkꞌakꞌan milaqꞌaman. Apalay ixtapal chuncha kꞌamakꞌatꞌi xajantu kamoqslatꞌi tachun lapaxkan para kalaqxavatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ni Jesús makal kuenta ni anchanuꞌ lapanaki la ox qaltayanal, va junil: —Jantucha lhuu tsꞌanqaniyan para kalhichimoꞌon ni Dios. Ex jantucha matichun katalhisakmiputul taun chivinti yu lay kataputislajmal. ");
INSERT INTO tptNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tejkan ni Jesús va ixtꞌajun lakmalaniniꞌ ni lapanakni ni ay lakatajtan va laklhisakmil, va naul: —¿Valiꞌiycha tanajun yu xajamalaninin ni va ixpapanti David ni Cristo yu ixtanajun kaminaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ni Espíritu Santo xtaqnil jatapastakꞌati ni David tejkan yucha naul inchineꞌ: Ni Jalhachimoꞌonu Dios va naul, va junkal kiJalhachimoꞌonuꞌ: “Aniycha kꞌintꞌatꞌaꞌul la kilhijakanaj tus tejkan kakmaqalhajaꞌoyaꞌ tachun yu taxkayyan.” ");
INSERT INTO tptNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ex chuncha ni David yucha junil ni Cristo ixJalhachimoꞌonuꞌ. ¿Tas lay kaval ni Cristo istsꞌal ni David? Ayaj ixtalhavaxtu lapanakni va tus ox achaj ixtaqalasmatꞌa ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ex chuncha ni Jesús ixjalakmalaniy ni lapanakni, va naul: —Jantu katamakanun yu tamalaninin kilhachimoꞌonkꞌan. Yuꞌuncha va ayaj tamaqamay katatiꞌukxuntayal kun yu laqlman laqchꞌiti yu tacha taꞌulay ni xalajꞌaynin lapanakni. Vachu tejkan paxtoqkan laklhitamau tanajun ni ox kꞌalakmastꞌakꞌatꞌi kun tachun jatoꞌoyanti. ");
INSERT INTO tptNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tataulputun taꞌan tataulay yu xalajꞌaynin laqa chaqan taꞌan tataqxtoꞌa ni lapanakni vachu taꞌan alin lakvayti. ");
INSERT INTO tptNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Talakmaxtuniy ixchaqakꞌan yu tiyaunin. Vachu la panij tatapayniy Dios para katatoꞌoyal ni lapanakni. Yuꞌuncha katalaqaꞌiyaꞌ apalay lhuu jamaqanlqajnati, naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ex ni Jesús va taulal la ixꞌukxpulakapuꞌ ni kajun yu taꞌan ixtamujuy ixlimosnajkꞌan. Ex chuncha ni Jesús va ixlaqtsꞌin ni lapanakni ixtamujuy ni tumin. Yu maqalinin va la laqlhuvin ixtamujuy ni tumin. ");
INSERT INTO tptNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ex va chuncha taval va chinchal qayntaun xanati, kilpataniꞌ tiyau, va mujul laka kajun laꞌatꞌuy lakstꞌuniy tumin tsasnati yu va tsꞌuniy xtapal. ");
INSERT INTO tptNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ex ni Jesús lakjuntaꞌil ixtꞌaltanan, va lakjunil: —Laqsaval klajunau, yu aniy kilpatani tiyau, yucha apalay laqlhuu xaxtaꞌa xajantu yu alati yu ixtamujuy tumin laka kajun. ");
INSERT INTO tptNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yu alati ixtamujuy va yu ixtaxajniyachal, pero yu anchanuꞌ xanati tiyau tachun yu ixlhitꞌajun para kaputapasal, va mujuꞌol laka kajun. ");
INSERT INTO tptNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tejkan ixtataxtuta ni Jesús kun ixtꞌaltanan, ex qayntaun ixtꞌaltanaꞌ va junil: —¡Jamalaniniꞌ! ¡Kalaqtsꞌi ni kilakatajtankꞌan, va ayaj laqpꞌas chiyux makakanta! ");
INSERT INTO tptNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ex ni Jesús va naul: —¿Laqtsꞌin ni aniy lajꞌay jachaqan? Kaminaꞌ julchan tejkan jantu laqataun chiyux kaxajtachal, tus tachun katalaqcheꞌeꞌoyaꞌ, naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ex taꞌal xaꞌaspajun Olivos la ixꞌukxpulakapuꞌ ni ay lakatajtan. Ancha taulchal ni Jesús. Yu Pedro ali Juan ali Jacobo ali Andrés va ixlaqꞌamankꞌan talhisakmil ni Jesús, tajunil: ");
INSERT INTO tptNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Kilajuniucha. ¿Tas vanancha katapasayaꞌ ni anchanuꞌ axtoqnu? ¿Tas kakpukꞌatsayaucha tejkan va laycha katapasaputunaꞌ ni anchanuꞌ axtoqnuꞌ? ");
INSERT INTO tptNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ni Jesús va lakjunil: —Kalhistꞌajkꞌantꞌikcha ni jantu matichun katamakanun. ");
INSERT INTO tptNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kataminaꞌ pumalhuu, katanaunaꞌ: “Va kitꞌin yu Cristo.” Chuncha lhuvaj lapanakni katamakanuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Kaꞌasmatꞌapitik ni alincha lachꞌapati aniy ali lhilukuj avintꞌi, pero jantu katꞌalhanantꞌik. Va chuncha maqskꞌiniy pꞌunaj katapasaꞌelal. Pero jantukaꞌ katamaktayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yu oqxlaqtaun lapanakni katalachꞌapayaꞌ kun aꞌoqxlaqtaun lapanakni. Yu laqataun pais katalachꞌapayaꞌ kun ataun pais. Va lakalhuu kaxkapꞌikninaꞌ ni lakatꞌun, vachuꞌ kaꞌalinaꞌ ay chavan. Tejkan chuncha katapasayaꞌ va kaꞌaqtayakaꞌ ni maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Chavay yu uxiknankꞌan ayaj kꞌalhistꞌajkꞌantꞌikcha. Katamaqxtaqniyan la ixtamakakꞌan ni jalhachimoꞌonun. Vachuꞌ katalakasamayan laqa chaqan taꞌan tataqxtoꞌa ni lapanakni. Chuncha katꞌayapitik taꞌan tavilanal yu lajꞌay jalhachimoꞌonun ex ancha kꞌanaunapitik tacha kunita ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yu lajꞌox chivinti pꞌunaj maqskꞌiniy kaputeꞌeꞌokal ni oqxlaqchux lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chavay ni uxiknankꞌan tejkan katamaqxtaꞌan la ixtamakakꞌan ni jalhachimoꞌonun, jantu maqskꞌiniy katapastakꞌun yu kꞌanaunapitik. Kꞌanauntꞌik va yu exnicha kataxtaqniyan la mijatapastakꞌatkꞌan ni Espíritu Santo. Ex jantu kunaꞌ minchivintikꞌan, kunaꞌ ixchivinti ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ex lati lapanakni katamaqxtaqyaꞌ ixtꞌalaqauninkꞌan para kalaqmaqnikal. Vachu yu japayan katamaqxtaqyaꞌ sasꞌatꞌankꞌan. Vachuꞌ yu sasꞌatꞌan kataxkayyaꞌ ixpayankꞌan, katamaqniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tachun ni lapanakni katalhixkayyan por kilapanakni untꞌatꞌik, pero yu vas kataylhaꞌanaꞌ la ixlhakapuꞌati tus kalaꞌoyacha, yucha kalaqtaxtuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Kalaqtsꞌinapitik qayntaun yu xkiliu yu kalaqtꞌilhiꞌoyaꞌ ni chaqaꞌ taꞌan toꞌoyakan Dios. Yucha lhichivinil Daniel yu maqancha ixlaqputeꞌey ixchivinti Dios. Katayayaꞌ taꞌan jantu paxtoqniy katayal. (Chavay yu puteꞌey tsꞌanqay kamalaqasil.) Ex yu tavilanal xalakatꞌun Judea maqskꞌiniy kataꞌal laka aspajunaxnan qosnin. ");
INSERT INTO tptNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yu kataulaꞌ la ixꞌukxna ixchaqaꞌ jantucha kataꞌeltajul maxtunuꞌ tuꞌuchun la chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Vachuꞌ yu kaꞌalintachal la ixkuxtu va jantu maqskꞌiniy kaminchoqol iniꞌ ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Payniꞌincha xanatin yu jaꞌaynan katajunaꞌ anchanuꞌ julchan, vachuꞌ yu katalhitsukuyaꞌ lakstꞌuniy sasꞌatꞌakꞌan yu lhimatsꞌikꞌiti! ");
INSERT INTO tptNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kꞌatꞌapꞌayninitꞌik ni Dios para jantu kapaxtoqnil tejkan lhikꞌasnin. ");
INSERT INTO tptNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yu anchanu julchan kaꞌalinaꞌ ay maqanlqajnati yu jantu aqtaun kaꞌalil tus tejkan puꞌaqtaynil ni lakamunukpaꞌ tus chavaycha y astan jantucha kaꞌalinchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yu Jalhachimoꞌonu Dios jantu xtaqniy lakatin para maqan kaval ni anchanuꞌ maqanlqajnati. Incha maqan kaval, ex jantu matichun kaxajchal. Yucha lakpaxkay ixlapanakni yu jalaksakta, xlhiyucha jantu najun maqan kaval. ");
INSERT INTO tptNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ni anchanuꞌ julchan incha matichun katajunin ni uxiknankꞌan: “Aniy alinta ni Cristo” u “Kalaqtsꞌintꞌik, avintꞌi vilchal”, jantu kalhakꞌapꞌupꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ni anchanuꞌ julchan kataminaꞌ yu jamakanunun. Lati katanaunaꞌ va yuꞌuncha ni Cristo. Yu alati katanaunaꞌ va yuꞌuncha yu ixtalaqputeꞌey ixchivinti Dios maqancha. Katamakayaꞌ yu lajꞌay axtoqnuꞌ kun tapꞌasta para katapumakanun mas va yu jalaksakta ni Dios, incha kalal. ");
INSERT INTO tptNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Kꞌalhistꞌajkꞌantꞌikcha! Klajuntaucha yu katapasayakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Exnicha tejkan katapasaꞌoyaꞌ ni anchanuꞌ maqanlqajnati, ni julchan kaꞌukxputsꞌisaꞌ, vachu yu malkuyuꞌ jantucha kamapulkuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Yu jastꞌakun katapatajuyaꞌ. Yu talhitꞌajun tapꞌasta ni laktꞌiyan, yuꞌuncha kataxkapꞌiknanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","’Ex kintalaqtsꞌinacha ni kitꞌin yu kval Sasꞌatꞌa Lapanaki kakmintachal laka taputsꞌi ni kun tachun kintapꞌasta ali tachun kiꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ex kakmalaqachayaꞌ ni kimayulnin ex yuꞌuncha katamaqxtoꞌaꞌ yu klaklaksakta talakachux ni lakamunukpaꞌ tus yu ixpiktutꞌati ni lakamunukpaꞌ, tus taꞌan maktayachalcha ni laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Kꞌamakꞌatꞌikcha kuenta tacha junita tejkan maqlaqapꞌun ni xakꞌiu higo, yucha va naunputun ni taꞌukstsꞌuniycha tejkan kapꞌasnanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Vachu va chun tejkan kalaqtsꞌinapitikcha ni tsukuy tapasanaꞌ ni anchanuꞌ axtoqnuꞌ yu klajuntau, ex chun kakꞌatsꞌayapitikcha ni va laycha kakchinchoqoyaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Laqsaval klajunau, ni lapanakni yu chavay tatꞌajun, jantukaꞌ kataniꞌoyaꞌ tus katapasaꞌoꞌelayaꞌ yu klajuntau. ");
INSERT INTO tptNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yu lakatꞌun kun laktꞌiyan katamiꞌoyaꞌ pero yu kinchivinti jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jantu matichun kꞌatsay tisuncha hora u tisuncha julchan chuncha katapasayaꞌ. Ixmayulnin Dios laktꞌiyan jantu takꞌatsay, vachuꞌ jantu ijkꞌatsay ni kitꞌin yu Sasꞌatꞌa Dios. Vamun kꞌatsay kimPay. ");
INSERT INTO tptNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Xlhiyucha maqskꞌiniy kꞌalakpꞌukꞌujtꞌikcha, kalhistꞌakkꞌantꞌikcha, kaskꞌintꞌik Dios. Jantu kꞌatsꞌayatꞌik tas vanancha kalakachinaꞌ ni anchanuꞌ julchan. ");
INSERT INTO tptNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ni anchanuꞌ julchan kunaꞌ va tacha qayntaun joꞌati yu maqati an tiꞌukxuntayan. Yucha pꞌunaj jalakmakauniy ixchaqaꞌ ni ixꞌoqxtamatin para katalhistaknal. Qayntamin si tumpajcha jalaqxtaqniy ixlhitapatskꞌan. Yu xalhistaknaꞌ kiltalakxtuti va lhijunkan kalakpukujlhi. ");
INSERT INTO tptNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xlhiyucha klajunau ni kꞌalakpꞌukꞌujtꞌikcha. Jantu kꞌatsꞌayatꞌik tavanancha kakchinacha kitꞌin yu jamanavin chaqaꞌ, u laka tatsꞌisin u va pakltaun tsꞌis u va tejkan katꞌasayacha ni puyux u va puvakuj. ");
INSERT INTO tptNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Tejkan laqatsꞌalaj kakminchoqoyaꞌ jantu kaltꞌatꞌatꞌik la mijatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yu klajunau ni uxiknankꞌan, klakjuniy tachun ni lapanakni: ¡Kꞌalakpꞌukꞌujtꞌikcha! ");
INSERT INTO tptNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ex chuncha va istsꞌanqay paqtꞌuy tejkan kaꞌalinaꞌ ni Paxku yu ay ixkꞌatankꞌan ni israelitas, tejkan taꞌuy pan yu jantu lhiyaukan levadura. Yu xaꞌukxtinin ni kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas va tapuxkaulaqtsꞌil tacha saq katapumanul lakapachꞌin ni Jesús para katamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ixtanajun: —Jantu maqskꞌiniy tejkan alin kꞌatan, va lay katalakchꞌilil ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ixvilchal ni Jesús laka putaulan Betania la ixchaqaꞌ ni Simón yu ixlakapuchꞌitacha. Tejkan ixvil laka mesa ni Jesús va chinchal qayntaun xanati yu ixlhiminta taun lameta yu jamakanti chiyux yu junkan alabastro. Va putajun yu sꞌejenꞌe yu junkan nardo yu la laqlhuu xtapal. Ex va oqxcheꞌelcha ni lameta va laqxtaqemukꞌanil la ixꞌaqtsul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lati ni yuꞌuncha yu ancha ixtaꞌalinta ayaj tatalqamal, va aqtayl talajuniy siya yuꞌuncha: —¿Valiꞌiycha laqamanancha anchanuꞌ xanati yu sꞌejenꞌe? ");
INSERT INTO tptNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Va jantu ixlaqamanal, ka la ox istꞌal. Ixtapal va tacha ixlhilhajati qayntaun lapanaki yu tapatsay 300 julchan. Ixlhilaqꞌaqtayjuu ni kilpatanin. Chuncha talhilaqꞌaymal ni xanati. ");
INSERT INTO tptNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ex ni Jesús va lakjunil: —Kꞌamakꞌauntꞌikcha ni aniy xanati. ¿Valiꞌiycha maꞌanchꞌapꞌuyatꞌikcha? Tacha ixkimakaniy yucha la ox. ");
INSERT INTO tptNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yu kilpatanin va tacha kaꞌalinacha kun uxiknankꞌan. Lay kꞌamakꞌaniyapitik yu lajꞌox va tavanancha yu kꞌanaunapitikcha. Pero yu kitꞌin jantucha maqan kaklatꞌaꞌalinau. ");
INSERT INTO tptNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni aniy xanati va makal yu lay xamakay. Chavay mas jantukaꞌ ikniy pero tejkan ixkilakpaxapay yu sꞌejenꞌe, yucha va para kilhitaknun. ");
INSERT INTO tptNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Laqsaval klajunau, mas va toꞌoxtaycha lakamunukpaꞌ kaputeꞌekanaꞌ yu ox chivinti vachu ancha kaputeꞌekanaꞌ yu makal ni aniy xanati, ni lapanakni katapastakchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ex ni Judas Iscariote yu xaqayntaun ixtꞌaltanaꞌ ni Jesús, va jalaqꞌal yu xaꞌukxtinin kuras. Va al laklhijuniniꞌ ni kalaqmaqxtaqniyacha ni Jesús la ixtamakakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Yu xaꞌukxtinin ni kuras tejkan chuncha taqasmaklhi va ayaj talhiꞌachantajul. Va tajunil kataxtaqniyaꞌ tumin ni Judas. Ex ni Judas va aqtaylcha puxkaulaqtsꞌin tas pulay kapumaqxtaqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ex chuncha va chilcha yu xapꞌunaj julchan ixkꞌatankꞌan ni israelitas, tejkan taꞌuy ni pan yu jantu lhiyaukan levadura, tejkan ixtamoqslay ixborregoskꞌan tacha lapaxkan. Yu ixtꞌaltanan ni Jesús va tajunil: —¿Toꞌoxtaycha naꞌuncha kaklalaꞌoxiniu xavayti ni kꞌatan Paxku? ");
INSERT INTO tptNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ex jamalaqachal pumatꞌuy ixtꞌaltanan, va lakjunil: —Kꞌapꞌinchꞌipitik ni laqaꞌay putaulan. Ancha kapꞌaxtꞌoqyapitik qayntaun joꞌati yu lhaꞌanta taun aqxau xkan. Katꞌapꞌinapitikcha ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Taꞌan katanutachal katꞌachꞌivinintꞌik yu jamanavin chaqaꞌ. Kaꞌunapitik ni Jamalaniniꞌ kꞌatsaputun toꞌoxtaycha alinta yu cuarto taꞌan kalaktꞌavaynaꞌ ixtꞌaltanan yu xavayti Paxku. ");
INSERT INTO tptNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ex ancha katamasuniyan taun ay cuarto taꞌan alinꞌojoy xoqta yu kꞌamapꞌatsꞌatꞌi. Ancha kꞌalaꞌoxiyapitik ni kivaytikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ex yu ixtꞌaltanan va taꞌalcha. Tejkan tachaꞌal va tatemaꞌol va chuncha tacha lakjunil ni Jesús. Ex va ancha talaꞌoxilcha ixvaytikꞌan xakꞌatan Paxku. ");
INSERT INTO tptNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tejkan putsꞌislhicha, ex ni Jesús va jalaktꞌachinchalcha yu pumakautꞌuy ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Taval tejkan tatꞌajuncha vaynin ni lakamesa yu Jesús va lakjunil: —Laqsaval klajunau ni xaqayntaun ni uxiknankꞌan yu kintꞌatꞌajun vayaꞌ, yucha kimaqxtaqyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ex yuꞌuncha va la tamaqaninilcha. Taꞌaqtaylcha talhisakmiy qayntamin por qayntamin, va tajuniy: —¿Ex va kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ni Jesús va lakjunil: —Yu mimpumakautꞌuykꞌan, xaqayntaun ni uxiknan yu kintꞌatamajqoy laka plato tejkan kaꞌavayau kimpankꞌan, va yucha kimaqxtaqyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ni kitꞌin yu Sasꞌatꞌa Lapanaki kakniyacha tacha kilhitsꞌoqkanta la ixchivinti Dios. Pero payniycha yu kimaqxtaqyaꞌ. ¡Apalay ox jantu istsukul! ");
INSERT INTO tptNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ex tejkan ixtatꞌajuncha vaynin, ni Jesús chꞌapal la ixmakaꞌ aqxtaun pan, va xtaqnil lhimalaqpuchuncha ni Dios. Ex chuncha laqcheꞌelcha ni pan, jalaqxtaqnilcha ni ixtꞌaltanan, va lakjunil: —Kaꞌutꞌikcha, yu aniy va kilakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ex vachu chꞌapal laqataun vaso, va xtaqnil lhimalaqpuchuncha ni Dios. Va jalaqxtaqnil ixtꞌaltanan, tus tachun taꞌoqꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ex chuncha ni Jesús jalakjunil: —Ni aniy va kijakꞌalna yu masuy ni Dios va taun sastꞌi chivinti jatꞌatamakajun ixlapanakni, kalakataxtuyaꞌ para kamalaqmixinikal ixtalaqalhinkꞌan lhuvaj lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Laqsaval klajunau, jantucha kajkꞌotꞌaꞌ ni xaxkan uva, tus tejkan kajkꞌoqchoqoyaꞌ aaqtaun taꞌan kalhachimoꞌonunaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ex va chuncha tejkan tamilpal titaun milpati, va taꞌalcha laka aspajun yu junkan Olivos. ");
INSERT INTO tptNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ancha ni Jesús va lakjunil: —Chavay ni aniy laka tatsꞌisin tus mintachunkꞌan kilamakaunau. Yu tsꞌoqkanta la ixchivinti Dios najun: “Kaksayaꞌ yu xalhistaknaꞌ, ex yu ixborregos tus tꞌikl kataputaukꞌaꞌoyaꞌ”. ");
INSERT INTO tptNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero tejkan kajkujchoqoyaꞌ ex ni kitꞌin pꞌunaj kakchaꞌanaꞌ xalakatꞌun Galilea, ex yu uxiknankꞌan astan kachꞌipꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ex va chuncha ni Pedro va naul: —Mas tachun katamakaunan, yu kitꞌin jantu aqtaun ni kakmakaunan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pero ni Jesús va junil ni Pedro: —Laqsaval ijkunan, chavay apanchꞌix tsꞌis tejkan jantukaꞌ aqtꞌuycha tꞌasay ni puyux, uxintꞌi aqtꞌutucha kanauneꞌe ni jantu kꞌimispꞌay. ");
INSERT INTO tptNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero yu Pedro va pꞌas naul: —Mas maqskꞌiniy kaknil kun uxintꞌi jantu kakmakaunan. Ex yu alati vachu va chun tanaunꞌol. ");
INSERT INTO tptNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ex chuncha taval va taꞌal lakataun taꞌan junkan Getsemaní. Ex chuncha ni Jesús va jalakjunil ixtꞌaltanan: —Katꞌaulatꞌikcha aniy. Yu kitꞌin va ikteꞌen skꞌiniꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ex laklhaꞌal vamun ni Pedro ali Jacobo ali Juan. Ex ni Jesús va aqtaynilcha pꞌays jamaqaninin la ixjalhanuti. ");
INSERT INTO tptNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ex chuncha va lakjunil: —Ayaj ikmaqaninin la kelhanuti, va tacha kaknil kꞌatsan. Aniycha katꞌaulatꞌik, kilapakxaucha, kꞌalakpꞌukꞌujtꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ex ni Jesús va stal tiꞌal aꞌukstsꞌuniy, va talakapuꞌaqtsoqoqtatamal lakatꞌun, va aqtayl tꞌachiviniy ni Dios. Skꞌinlhi incha kalal ni jantu kachil ni anchanuꞌ maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Va naul: —KimPay kꞌatꞌi, uxintꞌi lay makꞌay tachun axtoqnuꞌ. Va iknajun kꞌimalaqtꞌaxtꞌutꞌi ni aniy ay maqanlqajnati. Pero jantu kaval yu tacha kitꞌin iknajun. Kamakꞌatꞌi yu tacha uxintꞌi naꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Taval va jalaqꞌal ni ixtꞌaltanan. Laklhitajul, va taltatanan. Va naul, junkal ni Pedro: —Simón, ¿Ni uxintꞌi va ltꞌatꞌatꞌa? ¿Tus va jantucha kalal kꞌintꞌaꞌalkꞌujtꞌi mas va tauncha hora? ");
INSERT INTO tptNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Maqskꞌiniy kꞌalakpꞌukꞌujtꞌikcha, va kaskꞌintꞌik Dios para jantu kꞌamakꞌanukꞌantꞌik y kamakꞌatꞌik yu jantu lajꞌox. Ayaj ox yu lakꞌanaunatꞌik pero jantu laqapꞌaysnin kꞌaꞌuntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ex va chuncha aaqtaun anchoqol tꞌachivin ni Dios. Vanaj va chun naunchoqol yu iskꞌintꞌa. ");
INSERT INTO tptNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Taval va aaqtaun minchoqol ni Jesús. Yu ixtꞌaltanan va aaqtaun laklhitajuchoqol taltatanan. Va lakꞌukstsꞌinkꞌi ixtajunita ixlaqchulkꞌan, ayaj ixtaltataputun. Jantu ixtakꞌatsay tisuncha katanaulcha. ");
INSERT INTO tptNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ex chuncha va aqtꞌutunucha val ni minchoqol aaqtaun ni Jesús, va naul: —Vananaj ltꞌatꞌayatꞌik, vananaj stꞌaknanatꞌik. Ka oxicha. Chilcha ni hora tejkan ni kitꞌin yu Sasꞌatꞌa Lapanaki kakmaqxtaqkanacha la ixtamakakꞌan yu talaktuꞌunun lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Kaꞌostꞌaꞌulatꞌikcha, kaꞌaucha. Va ukstsꞌuniycha minta yu kimaqxtaqyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tejkan vananaj ixtꞌajun chivin ni Jesús, va chinchal ni Judas, xaqayntaun yu pumakautꞌuy ixtꞌaltanan. Va ixlaktꞌaminta lhuvaj lapanakni yu ixtalhiminta espada ali kꞌiu. Va jalaqmalaqachal yu xaꞌukxtinin kuras ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu xalajꞌaynin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ni Judas, yu akchꞌintamanan va ixlakjunitacha tacha katapumispal, va naul: —Tejkan kakmastakꞌayaꞌ, kakiltastukyaꞌ. Yucha kachꞌiyapitik, ox kꞌalhistꞌaklhipꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ex va chuncha ni Judas va talakanunil ni Jesús, va junil: —Jamalaniniꞌ. Taval va kiltastuklhi. ");
INSERT INTO tptNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ex tachꞌapalcha ni Jesús, va tachꞌilcha. ");
INSERT INTO tptNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Qayntaun yu ixtꞌaltanaꞌ ni Jesús va xaqaxtul ixꞌespada. Va aqatuchaqxmajꞌal akatutaun ixꞌaqaxqol ixꞌoqxtamati ni xaꞌukxtin ni kuras. ");
INSERT INTO tptNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ni Jesús va lakjunil ni lapanakni: —¿Valiꞌiycha lhitꞌantꞌatꞌikcha kꞌiu ali espada para kilachꞌiyau? ¿Va tacha qayntaun alhavanaꞌ kakval? ");
INSERT INTO tptNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lhilhiy xaklatsukuyau malaninin ni ay lakatajtan, jantu aqtaun kilachꞌiu. Pero maqancha tsꞌoqkantacha la ixchivinti Dios ni chuncha katapasal, xlhiyucha chuncha tapasay. ");
INSERT INTO tptNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ex chuncha ixtꞌaltanan va tatakyauꞌol, va xꞌamancha tamakaul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Qayntaun tsꞌal vananaj ixtꞌaꞌanta ni Jesús. Vamun sábana ixlhipamilkanta. Ni yucha vachu tachꞌapal, ");
INSERT INTO tptNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero makaumalcha isábana, va tiꞌasas qoslhi. ");
INSERT INTO tptNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ex talhachaꞌal ni Jesús yu xaꞌay xaꞌukxtin kura. Va tus tataqxtoqꞌol tachun ni xaꞌukxtinin kuras, vachuꞌ yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, vachu tachun yu xalajꞌaynin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yu Pedro vananaj ixkaulhaꞌanta pumaqati ni Jesús tus tachaꞌal la ixpulakna xapuchꞌanan ixchaqaꞌ yu ay xaꞌukxtin kura. Jalaktꞌataulalcha yu policias. Va aqtaylcha jalaktꞌasꞌon chꞌantaun kun yuꞌuncha laka jikmi. ");
INSERT INTO tptNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Yu xaꞌukxtinin kuras kun tachun yu ixtaꞌaqxtoqnun ni laka ay junta si ixtalakxkauniy matichun yu lay kanaul taun laqtaqal yu makal ni Jesús tacha lay katalhimaqnil. Pero jantu matichun katatemal. ");
INSERT INTO tptNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lhuvaj lapanakni ixtalaklkaniy ni Jesús pero jantu lay chꞌantaun ixtamakay ixlakchivintikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lati taꞌaqtayl tatislajmay yu jantu laqsaval kaval, va tanaul: ");
INSERT INTO tptNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Yu kijnankꞌan ijqalasmakvi ixnajun: “Ni kitꞌin kaklakpujꞌoyaꞌ ni aniy ay lakatajtan yu tamakata lapanakni, ex yu laꞌatꞌutunu julchan kakmaqayauchoqoyaꞌ ataun sastꞌi lakatajtan pero jantu kunaꞌ yu katamakayaꞌ lapanakni.” ");
INSERT INTO tptNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero mas chuncha ixtanajun va jantu lay chꞌantaun ixtamakay ixlakchivintikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ex va chuncha ni ay xaꞌukxtin kura va ancha ostayal. Va lhisakmil ni Jesús, va junil: —¿Jantu tuꞌuchun kꞌanauneꞌe? ¿Valiꞌiycha chuncha talhitislajmayan? ");
INSERT INTO tptNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero yu Jesús vamun saq val, jantu tsij kanaul. Ex yu xaꞌukxtin kura va aaqtaun lhisakmichoqol ni Jesús, va junil: —¿Uxintꞌicha ni Cristo kꞌatꞌi yu Dios naul kamalaqachayaꞌ? ¿Va uxintꞌi yu Sasꞌatꞌa Dios yu toꞌoyakan? ");
INSERT INTO tptNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ex chuncha ni Jesús va naul: —Va kitꞌincha. Ni uxiknankꞌan kilalaqtsꞌinau ni kitꞌin yu Sasꞌatꞌa Lapanaki, kaktaultachal la ixlhijakanaj ni Dios yu lhitꞌajun tachun tapꞌasta. Kilalaqtsꞌinau ni kakminchoqotachal laktꞌiyan laka taputsꞌi. ");
INSERT INTO tptNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ex va chuncha yu xaꞌukxtin kura talqamal, tus chꞌapal ixlaqchꞌiti, va lajꞌexlhi, ex naul: —Jantucha apalay kmaqskꞌiniyau alati chivinti. ");
INSERT INTO tptNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ni uxiknankꞌan asmaktꞌatꞌik ixchivinti, va akchꞌintamay ni Dios. ¿Tas lhilayatꞌik? Ex chuncha chꞌantauncha taval, va tamukꞌanilcha ixlaqtaqal, talhinaul kanilcha. ");
INSERT INTO tptNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yu alati taꞌaqtaynilcha talakpuchujvay, ex talaqpuchꞌilcha, taꞌaqtayl talakasamay, va tajuniy: —Chavay kꞌanau taꞌayucha sayan. Ex chuncha yu policias va taꞌaqtaylcha talakapusay ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ni Pedro va ancha ixvil maqspaꞌ laqa chaqaꞌ, la ixpulakna ni ex. Taval va chinchal qayntaun ixmaqtsukuꞌ ni xaꞌukxtin kura. ");
INSERT INTO tptNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tejkan laqtsꞌil ni Pedro tꞌajun sꞌon, aqtaylcha laqastay, va junil: —Ni uxintꞌi vachu ixtꞌatꞌiꞌukxuyatꞌi ni Jesús yu machaqaꞌ Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ni Pedro va jantu kalhitaulal, va naul: —Kitꞌin jantu ikmispay ni anchanuꞌ joꞌati. Jantu ikmalaqasiy yu kintꞌaꞌun lhixaqalan. Ex va taxtulcha maqspaꞌ taꞌan putanukanachal, va tꞌasalcha laqataun puyux. ");
INSERT INTO tptNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ex chuncha yu maqtsukuꞌ aaqtaun laqtsꞌinchoqol ni Pedro, lakjunil ni alati yu ancha ixtaꞌalinta, va naul: —Ni anchanuꞌ joꞌati vachu va xaqayntaun ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero yu Pedro aqtalaqtaun jantu kalhitaulal. Ex taun panchꞌix val, yu ancha ixtaꞌalinta va aaqtaun tajunchoqol ni Pedro, va tanaul: —Laqsaval ni uxintꞌi vachu va xaqayntaun ni yuꞌuncha. Uxintꞌi vachu machaqa kꞌatꞌi xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ex ni yucha vas jalakmasavalanil y laqxtoqnuꞌ naul: —¡Jantu kmispay ni anchanuꞌ joꞌati yu tꞌaunatꞌik lhichivinin! ");
INSERT INTO tptNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ex va niman aaqtaun tꞌasachoqol ni puyux. Ex chuncha ni Pedro va pastaklhicha tacha junil ni Jesús. Va ixjunkanta: “Tejkan jantukaꞌ tꞌasay aqtꞌuy ni puyux, uxintꞌi va aqtꞌutucha kꞌanauneꞌe ni jantu kꞌimispꞌay.” Ex ni Pedro va aqtaylcha pꞌas qalhun. ");
INSERT INTO tptNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ex tejkan tunkulcha va tataqxtoqlhi yu xaꞌukxtinin ni kuras, ali yu xalajꞌaynin ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas kun yu ixtalhichimoꞌoy ixputsukkꞌan. Tachꞌilhaꞌalcha ni Jesús, tamaqxtaqnilcha ni Pilato. ");
INSERT INTO tptNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ex chuncha ni Pilato va junil ni Jesús: —¿Uxintꞌi ni xalhachimoꞌonuꞌ kꞌatꞌi ni israelitas? Ex yu Jesús va naul: —Chun, va tacha uxintꞌi xanaꞌun. ");
INSERT INTO tptNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ex yu xaꞌukxtinin kuras va pulhuu yu ixtaputislajmay ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yu Pilato va aaqtaun lhisakmichoqol, va junil: —¿Jantu tuꞌuchun kanauneꞌe? Va ayaj pulhuvaj tatꞌaunan tislajmanan. ");
INSERT INTO tptNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ni Jesús va tus jantu kaqaltayanal. Ex chuncha ni Pilato tus vak kꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Taun taun jachꞌitin tejkan xakꞌatan Paxku yu Pilato ixtamaxtuchoqoy qayntaun lapanaki laka pachꞌin, va yu ixtaskꞌin ni lapanakni para kamaxtuchoqol. ");
INSERT INTO tptNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Va ixtanun ni laka pachꞌin qayntaun joꞌati yu ixjunkan Barrabás. Chꞌantaun ixlaktꞌatanun kun alati yu tamakal lachꞌapati, va tamaqninil. ");
INSERT INTO tptNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ex va chuncha ni lapanakni talaqmil ni Pilato, va tajunil ni kamakachoqol yu tacha ixmakay. ");
INSERT INTO tptNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ex chuncha ni Pilato va naul: —¿Ex ni uxiknankꞌan yu israelitas untꞌatꞌik naunatꞌik ni kakmakaunchoqolcha oxamaktaun mijalhachimoꞌonukꞌan? ");
INSERT INTO tptNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ni Pilato ixkꞌatsay ni yu xaꞌukxtinin kuras va por akchaꞌati ixtamaqxtaqnita ni Jesús, xlhiyucha va chuncha naul. ");
INSERT INTO tptNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero yu xaꞌukxtinin ni kuras va ayaj tamalukujlal ni lapanakni tus tatalakchꞌilil. Ex chuncha ni yuꞌuncha va taskꞌiniy para oxamaktaun kamakaunchoqokal yu Barrabás. ");
INSERT INTO tptNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ex ni Pilato laklhisakmil ni lapanakni, va lakjunil: —¿Tisuncha naunatꞌik kakmakanil yu unatꞌik xaJalhachimoꞌonuꞌ ni israelitas? ");
INSERT INTO tptNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ex ni lapanakni tanaulcha kun laktꞌasati: —¡Kꞌamakxtꞌukmukꞌacha laka kurus! ");
INSERT INTO tptNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ex chuncha yu Pilato va naul: —¿Pero tisuncha laqtaqalcha makata? Ex yu lapanakni apalay pꞌas ixtalaktꞌasay, va tanaul: —¡Kamakxtukmukꞌakalcha! ");
INSERT INTO tptNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ex yu Pilato para ox kalaktꞌaꞌal ni lapanakni va oxamaktauncha makaunchoqol ni Barrabás. Malaqachanal ixlaqanaqmaka ni Jesús, vachuꞌ lhinaul para kamakxtukmukꞌakal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ex ni tropas va talhaꞌalcha ni Jesús la xapuchꞌanan ixpulakchivin ni Pilato. Tus tachun ni tropas ancha tataqxtoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ex va taꞌulanil aqxtaun laqchꞌiti yu pꞌas xlapul. Vachu tamaꞌaqtanul laqataun korona jamakanti kun jaltukun. ");
INSERT INTO tptNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ex taval ni lapanakni va talaktuꞌul, taꞌaqtaylcha talaktꞌasay: —¡Katsukul ixlhachimoꞌonukꞌan ni israelitas! ");
INSERT INTO tptNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ex chuncha va taꞌaqtaylcha talaqpanaꞌa kun kꞌiu la ixꞌaqtsul. Vachu talakapuchujval. Tamaꞌaqtsoqoqtal, tamakal va tacha katatoꞌoyal. ");
INSERT INTO tptNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tejkan talaktuꞌuꞌol ni Jesús, ex va tamaxtunichoqol ni laqchꞌiti yu ixtaꞌulanita yu ox xlapul. Taꞌulanichoqolcha ixlaqchꞌiti ni yucha, va tamaxtulcha ixlhimaqspaꞌ para kaxtukmukꞌakalcha laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ex chuncha tejkan ixtaꞌanta ni lakatin va tapaxtoqlhi qayntaun joꞌati yu ixjunkan Simón yu machaqaꞌ Cirene, yu ixpay Alejandro ali Rufo. Chuncha tejkan ancha ixtꞌajun tapasanaꞌ, talhijunil ni kaꞌaqtayjulhaꞌal ixkurus ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ex talhaꞌal ni Jesús lakataun taꞌan junkan Gólgota (va naunputun xajalukuti aqtsul). ");
INSERT INTO tptNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ex chuncha taxtaqnil lhiꞌotꞌati laqlhiyaunti kun mirra, pero yu Jesús jantu kaꞌoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ex va chuncha va taxtukmukꞌal laka kurus ni Jesús. Yu ixlaqchꞌiti va tamakal taun suerte ni tropas, taꞌayucha kapaxtoqnil ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tejkan taxtukmukꞌal ni Jesús va laqanajatsi puvakuj ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Va tatsꞌoqmukꞌanil taun chivinti la ixꞌaqtsul ni ixkurus, va najun: “Ixjalhachimoꞌonukꞌan ni israelitas”. Va yucha talhimaqnil. ");
INSERT INTO tptNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Va taxtukmukꞌal qayntꞌuy alhavanan kun Jesús. Qayntaun taxtukmukꞌal la ixlhijakanaj, yu aqayntaun taxtukmukꞌal la ixlhijamaqxu. ");
INSERT INTO tptNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ex chuncha va taqayntsalcha ni jatsꞌoqnuti yu najun: “Va mispakal tacha chꞌantaun kun yu talaktuꞌunun.” ");
INSERT INTO tptNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yu ancha ixtatapasay va laqxtoqnuꞌ chivinti ixtajuniy, ixtamalaklay ixꞌaqtsulkꞌan, va ixtajuniy: —¡Joj! ¡Uxintꞌi yu ixmaqtꞌatꞌi ni ay kilakatajtankꞌan y kun paqtꞌutu julchan ixmaꞌayauchꞌoꞌoꞌ! ");
INSERT INTO tptNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chavay kꞌalaqtꞌaxtꞌu meꞌeman, kapꞌatꞌaꞌutꞌi laka kurus! ");
INSERT INTO tptNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Vachu va chuncha yu xaꞌukxtinin kuras ali yu ixtamalaninin ixlhachimoꞌonkꞌan ixtalaktuꞌuy ni Jesús, va ixtalajuniy siya yuꞌuncha: —Ixmalaqtaxtuy yu alati pero jantu lay laqtaxtuy ixlaqꞌaman. ");
INSERT INTO tptNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Incha laqsaval yucha ni Cristo, ni xajalhachimoꞌonuꞌ kintꞌunkꞌan Israel, ex kapatajul laka kurus chavay. Ex chuncha kalhakapuꞌanaucha. Ex chuncha mas yu ixlaktꞌaxtukmukꞌakanta, yuꞌuncha vachu ixtalaktuꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ex chuncha tejkan atunkulcha, va talakachux ni lakatꞌun tus tꞌalaj putsꞌislhi, tus laꞌatꞌutu putoqoxata ixputsꞌista. ");
INSERT INTO tptNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ex chuncha laꞌatꞌutu putoqoxata, ni Jesús va pꞌays tꞌasal, va naul: —Eloi, Eloi, ¿lama sabactani? —va naunputun: KiDios kꞌatꞌi, kiDios kꞌatꞌi, ¿valiꞌiycha ni kꞌilakꞌamakꞌauntꞌacha? ");
INSERT INTO tptNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ex chuncha yu alati lapanakni yu ancha ixtayanal taqasmaklhi, va tanaul: —¡Kaꞌasmaktꞌik! Va tꞌasaꞌiniy ni Elías yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ex chuncha xaqayntaun ni yuꞌuncha va takyauꞌal iniꞌ taun sponja, va aval kun xaxkan uva yu skajtacha. Akchꞌimukꞌal kun maqataun akltiyati. Ex va malakanunilcha ni Jesús para kamaꞌotꞌul. Va lakjunil yu alati: —Kꞌamakꞌaucha. Kalaqtsꞌinaucha incha kalaqminaꞌ ni Elías para kꞌapꞌuxlhi ni laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Taval va sqau tꞌasal ni Jesús, va nilcha. ");
INSERT INTO tptNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ex chuncha va taꞌexpakltꞌiyul yu xaꞌay kortina ni ay lakatajtan, va taꞌexminchal xꞌakpuꞌ tus xtuntaun. ");
INSERT INTO tptNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ex yu xaꞌukxtin ni tropas, va ancha ixyal la ixlakaꞌukxpu ni Jesús. Tejkan laqtsꞌilcha ni nilcha, va naul: —Laqsaval ni anu joꞌati yucha ni Sasꞌatꞌa Dios ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vachuꞌ ancha ixtayanal lati xanatin va pumaqati ixtatꞌajun laqtsꞌinin. Ancha ixtaꞌalinta ni María Magdalena vachuꞌ ni María yu ixnatikꞌan ni José ali Santiago yu lakatꞌuniy. Vachuꞌ ancha yal ni Salomé. ");
INSERT INTO tptNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ni anchanuꞌ xanatin ixtatꞌaꞌanta ni Jesús. Ixtaꞌaqtayjuy ni Jesús tejkan ixtavilananchal xalakatꞌun Galilea. Vachuꞌ pumalhuu alati xanatin tatꞌaꞌal ni Jesús laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Va chuncha ixtꞌajuncha putsꞌisniꞌ va laycha kachil ni xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Taval mil qayntaun joꞌati, ixjunkan José yu machaqaꞌ Arimatea. Yucha vachuꞌ va xaqayntaun ay lapanaki kun yu ixtamakay laqaꞌay junta. Ni yucha vachu ixpakxanꞌiy ni ixlhachimoꞌon ni Dios. Ex chuncha kun tachun ixjaꞌayajnati, va laqꞌal ni Pilato. Va skꞌinil ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ni Pilato va jantu ixlhakapuꞌan incha kanilcha. Juntaꞌil ni kapitan va lhisakmil incha ixnitacha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Chuncha pukꞌatsal ni Pilato va ixnitacha ni Jesús. Taval xtaqnil lakatin ni José para kalhaꞌal ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ex chuncha ni José va il taun laqchꞌiti yu kꞌus yu la laqlhuu xtapal. Taval va pꞌuxlhicha ixlakatunaj ni Jesús laka kurus. Ex pupamililcha ni anchanuꞌ laqchꞌiti ni ixlakatunaj, va manulcha laka putaknun taꞌan tapuꞌajnil laktalpa. Ex milchaunil kun laqataun ay chiyux ni putaknun. ");
INSERT INTO tptNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ex chuncha yu María Magdalena kun María yu ixnati ni José, va talaqtsꞌil taꞌan maknunikal ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Taval tejkan tapasalcha ni xajulchan jastaknati, ex yu María Magdalena, ali María yu ixnati Jacobo, ali Salomé va taꞌil taun sꞌejenꞌe para kataꞌal mukꞌaninin ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ex chuncha tejkan laktuminku val, va puvakuj taꞌal ni laka putaknun. Va ixtakuktacha ni julchan. ");
INSERT INTO tptNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ex tejkan taꞌanta lakatin va talajuniy siya yuꞌuncha: —¿Tas ayucha lhilayatꞌikcha kamoqosunil ni chiyux yu ixpumalakchaunikanta laka putaknun? ");
INSERT INTO tptNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ex taval tejkan tachaꞌal, talaqtsꞌil va ixmoqosunikantacha yu ay chiyux. ");
INSERT INTO tptNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Taval tatanuchal ni laka putaknun, talaqtsꞌil qayntaun tsꞌal va ixvil yu laka kanaj ni putaknun. Ixꞌulata ixlaqchꞌiti lman y va ayaj yaqaq. Ex chuncha yu xanatin va la tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ex yu tsꞌal va lakjunil: —Jantu katꞌalhanantꞌik. Ni uxiknankꞌan lakxkꞌauyatꞌik ni Jesús yu machaqaꞌ Nazaret, yu taxtukmukꞌal laka kurus. Yucha takukchoqotacha, jantucha matiꞌ aniy. Kalaqtsꞌintꞌik aniy yu taꞌan ixtamaknuta, jantucha matiꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Chavay kapꞌinchꞌoꞌotꞌikcha, kaꞌunapitik ni Pedro kun yu alati ixtꞌaltanan: “Ni Jesús kaꞌanaꞌ pꞌunaj ni Galilea. Ancha kꞌalaqtsꞌinapitik, vachu va chun tacha ixnajun.” ");
INSERT INTO tptNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ex chuncha yu xanatin va tatakyauminchoqochalcha ni laka putaknun. Va ayaj tatalhanal, tus ixtaxkapꞌikninta ixtalhantikꞌan. Va jantu matichun katajunil yu tacha lakjunkal, va ayaj tatalhanal.  ");
INSERT INTO tptNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Vananaj vakuj ni anchanuꞌ laktuminku tejkan takukchoqol ni Jesús. Ex chuncha va pꞌunaj tasunil ni María Magdalena yu ixmaxtunikanta laqatujun yu jantu lajꞌox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ex ni María Magdalena va jalaqꞌal mapastakꞌanin yu ixtatꞌatiꞌukxuyanal ni Jesús. Tejkan jalaqchaꞌal, ni yuꞌuncha va ayaj ixtamaqanininta, vamun ixtatꞌajun lajqalhunin. ");
INSERT INTO tptNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ex chuncha mas taqasmaklhi ni va tꞌajun ni Jesús, y va laqtsꞌil ni María, pero yuꞌuncha va jantu katalhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taval ni Jesús va laktasunil pumatꞌuy ixtꞌaltanan yu ixtaꞌanta lakatin ixlhimaqspaꞌ ni putaulan. Pero va ixtapaxata yu tacha ixtasuy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ex yu anchanuꞌ pumatꞌuy talaqꞌal mapastakꞌaninin yu alati, pero mas chuncha va jantu katalhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Taval ni Jesús va laktasunil yu pumakautaun ixtꞌaltanan. Yuꞌuncha va chꞌantaun ixtavilanal lakamesa. Ex ni Jesús va jalaqꞌaymal por jantu katalhakapuꞌal. Va ayaj pꞌas ixtamakachoqota ixjalhanutikꞌan y jantu ixtalhakapuꞌaniy ixchivintikꞌan yu ixtalaqtsꞌinta ni Jesús ni takukchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ex chuncha ni Jesús va lakjunil: —Kꞌapꞌinchꞌipitikcha talakachux ni lakamunukpaꞌ, kꞌalaqpꞌutꞌeꞌenichipitikcha yu ox chivinti tachun ni lapanakni ");
INSERT INTO tptNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Taꞌayuꞌ yu kalhakapuꞌanaꞌ yu ox chivinti y kaꞌaqchajꞌauyaꞌ, ni yucha kalaqtaxtuyacha. Pero yu jantu kalhakapuꞌanaꞌ, yucha kalaqaꞌiyaꞌ lhuu maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kaklaqxtaqniyaꞌ kintapꞌasta yu kintalhakapuꞌan para lay katamakal yu ay axtoqnuꞌ. La kintaqaꞌuti katamaxtuyaꞌ yu jantu lajꞌox espíritus, y katachivinanaꞌ laqsastꞌi lhichivin. ");
INSERT INTO tptNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Katachꞌapayaꞌ la ixmakakꞌan ni tsapulin y mas kataꞌotaꞌ yu lhinin, jantu tuꞌuchun kamakaniyaꞌ. Tejkan katalaqmaqchꞌapayaꞌ ni taqanꞌanin ex kataꞌayajnanchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Taval ni Jalhachimoꞌonu Jesús tejkan jaxaqalaꞌol, ex tantꞌaqstꞌalcha ni laktꞌiyan, va taulchalcha la ixlhijakanaj ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ex yu ixtꞌaltanan va taꞌalcha laqputeꞌenin ixchivinti Dios tus talakachux. Yu Jalhachimoꞌonu Jesús ayaj ixlaqꞌaqtayjuy, por yu lajꞌay axtoqnu ixtamakay va chuncha tasul ni va laqsaval yu ixtalaqputeꞌey. Va chuncha kaval.");
INSERT INTO tptNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pumalhuu lapanakni tatsꞌoqꞌulata tacha tapasal aniy taꞌan tꞌaunau kijnankꞌan. Ixtatsꞌoqꞌulaputun yu tapasal ");
INSERT INTO tptNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","vachu va tacha kintajunin ni lapanakni yu talaqtsꞌinꞌol. Yuꞌuncha talhimasul ni ox chivinti yu lhichiviniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Xlhiyucha, Teófilo, ay lapanaki kꞌatꞌi, vachuꞌ kilhipaꞌinil kaktsꞌoqnin kitꞌin tachun yu tacha tapasal. Va klaniꞌojota tachun mas va yu xapꞌunaj. ");
INSERT INTO tptNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Va chuncha kakꞌatsꞌatꞌi ni chivinti yu masunikꞌantꞌa laqsaval val. ");
INSERT INTO tptNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tejkan Herodes ixlhichimoꞌoy xalakatꞌun Judea, ex ixꞌalin qayntaun xakura israelitas yu ixjunkan Zacarías. Yucha va lhiyal ni kuras yu ixlapanakni Abías ixtajunita. Ixlhitꞌajun ixanati yu ixjunkan Elisabet. Yucha va ixpapanti ixjunita yu pꞌunaj xaꞌay kuraj yu ixjunkan Aarón. ");
INSERT INTO tptNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ixlaꞌatꞌuykꞌan va la ox ixtatiꞌukxuyanal kun Dios, ixtamakay tachun yu ixnajun la ixlhachimoꞌonkꞌan ali ixlhachimoꞌon ni Dios, jantu katamakal tuꞌuchun laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero jantu tꞌujuꞌ ixjunita sasꞌatꞌakꞌan, va jantu lay ixlhitsukuy jasꞌatꞌa ni Elisabet. Vachuꞌ ayaj lhuvajcha ixjachꞌitinkꞌan ixtalhitꞌajun yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Taval taun julchan ixtꞌajun tapatsan ni Zacarías va tacha kura. Va tapaxtoqnil ixlapanakni katatapatsanil ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ex va tamakal taun suerte yu ixtamakay xakuras israelitas, va paxtoqnil ni Zacarías. Ex va yucha tanuchal yu la ay lakatajtan, va aqtaylcha jamapuvanaꞌ taꞌan ixvil ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yu tachun ixtalhavaxtu lapanakni yuꞌuncha va maqspaꞌ ixtatamoꞌoy ixkiltalakxtuti ni ay lakatajtan taꞌan ixmapuvanan ni Zacarías. ");
INSERT INTO tptNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ex va tasunil ixmayul ni Jalhachimoꞌonu Dios, va la ixlhijakanaj ni altar. ");
INSERT INTO tptNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ex ni Zacarías tejkan chuncha laqtsꞌil taꞌan ixtꞌajun mapuvan, va ayaj talhanal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ni ixmayul Dios va najun: —Jantu katꞌalhan, Zacarías. Ni Dios yu skꞌinin, yucha qalasmatꞌan. Chavay mixanati Elisabet kalhitsukuyacha qayntaun jasꞌatꞌa, kꞌaꞌuneꞌe ixtaqaꞌuti va Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Va ayaj lhuvaj achati kalhitsꞌukꞌuyeꞌe y vachuꞌ ni lapanakni ayaj kataꞌachaxꞌiyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ni anchanu jasꞌatꞌa, yucha la ay kunaꞌ kun Dios. Jantu kaꞌotꞌaꞌ xaxkan uva nisin lhiꞌotꞌati. Tejkan jantukaꞌ tsukuy, yucha kalaqtanuyaꞌ ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kaxaqalayaꞌ ni lapanakni yu aniy machaqan Israel ex pumalhuu katalhakapuꞌanchoqoyaꞌ ni Dios ixJalhachimoꞌonukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yucha kapꞌulayaꞌ ex astan kaminaꞌ ni Jalhachimoꞌonuꞌ. Vachuꞌ kunaꞌ tacha ixjunita Elías yu ixlhichiviniy Dios, va chuncha kunaꞌ ixjatsukunti kun ixtapꞌasta. Kamakayaꞌ ni chꞌantaun kataval ixjalhanutkꞌan ni xapaynin ali sasꞌatꞌankꞌan para katalapaxkal. Kalaqxtaqniyaꞌ jatapastakꞌati yu chavay jantu taqalasmaknan para vas katatiꞌukxuntayal. Ex chuncha kalaꞌoxiyacha ni lapanakni para katalaqaꞌil ni Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ex va naul ni Zacarías, va junkal ixmayul Dios: —¿Tas kakpukꞌatsayaꞌ licha laqsaval yu kiꞌuniy? Yu kitꞌin va ayaj xapaycha, vachu kixanati la lhuvajcha ixjachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ex qaltayl ni mayul: —Kitꞌin va Gabriel yu kmakay ixlhitapatsa ni Dios. Va kmalaqachakal para kaktꞌachivinin ni uxintꞌi, va para kunin ni aniy ox chivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Chavaycha jantu kalhakꞌapꞌupꞌi kinchivinti, mas laqsaval chuncha katapasayaꞌ tejkan kalaqchaanaꞌ ni julchan. Xlhiyucha janunucha kꞌaꞌuneꞌe. Jantucha lay kꞌachꞌivinineꞌe tus kaꞌalinaꞌ yu tacha xajkunan, ex kꞌachꞌivininchꞌoꞌoyeꞌe. ");
INSERT INTO tptNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tachun ni lapanakni va maqspaꞌ ixtapakxanta ni Zacarías, va la ixtapastakꞌutacha, va maqtoqoxatanul lakatajtan ni Zacarías. ");
INSERT INTO tptNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ex tejkan taxtuchoqol va jantucha lay chiviniy. Ni lapanakni tapastaklhi ni va laqtsꞌil taun tuꞌuchun ni lakatajtan. Ex vamuncha ixlakmajkuniy, va chuncha janunucha tiꞌukxuntayal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ex mamaktalcha ixlhitapatsa lakatajtan ni Zacarías, va anchoqolcha la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ex astan va jaꞌaynaꞌ val ixanati Elisabet. Jantu katataꞌaxtul tus laqchaꞌal laqakis malkuyuꞌ, va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Chuncha kimakanil ni Jalhachimoꞌonu Dios para jantucha apalay kintalaktuꞌul ni lapanakni.” ");
INSERT INTO tptNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tejkan laqchaꞌal laqachaxan malkuyuꞌ, ni Dios va malaqachal ixmayul yu junkan Gabriel laka estado Galilea, lakataun putaulan yu junkan Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Va laqkilachil qayntaun jatsiꞌi yu ixjunkan María. Ni yucha iskꞌininti ixjunita qayntaun tsꞌal yu ixjunkan José. Yu José minchal kun ixlapanakni David yu maqancha ay jalhachimoꞌonuꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tejkan laqchinchal ni mayul Gabriel, va mastakꞌal ni María, va junil: —Dios mapayniyan, va alinta kun uxintꞌi. Apalay ox kaxajtachal mijatsukunti xajantu matichun xanati. ");
INSERT INTO tptNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ex ni María va pastakꞌul, aqtayl pastakꞌa tisuncha naunputuncha ni anchanu chivinti yu pumastakꞌakal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ex va najun ni mayul: —Jantu katꞌalhan, María. Dios kaxtaqniyan taun ay japaxkanti. ");
INSERT INTO tptNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Uxintꞌi aynacha kꞌaꞌuneꞌe, kꞌalhitsꞌukꞌuyeꞌe qayntaun tsꞌal, kꞌaꞌuneꞌe ixtaqaꞌuti va Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yucha vamun yuꞌ pꞌas kunaꞌ, kunkanaꞌ Sasꞌatꞌa Dios. Ni Dios kaxtaqniyaꞌ ixpalhachimoꞌon tacha ixlhachimoꞌon ixpapaꞌ David yu ay jalhachimoꞌonuꞌ ixjunita maqancha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mas va tavanancha yucha miJalhachimoꞌonukꞌan kunaꞌ mintachunkꞌan yu israelitas untꞌatꞌik. Ixlhachimoꞌon jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ex ni María va najun: —¿Tas va kunacha? Yu kitꞌin va keꞌemankaꞌ, jantukaꞌ klhitsukuy kixapay. ");
INSERT INTO tptNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ex qaltayl ni mayul, va junil: —Ni Espíritu Santo kachinaꞌ la milakatunaj, ixtapꞌasta ni Dios chuncha kamakayaꞌ. Xlhiyucha ni tsꞌal yu katsukuyaꞌ, yucha ox kunaꞌ kun Dios, va kunkanacha Sasꞌatꞌa Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Vachuꞌ mintꞌalapanaki Elisabet kalhitsukuyaꞌ qayntaun jasꞌatꞌa mas ayaj xanaticha. Ixtanajun jantu aqtaun lay kalhitsukul jasꞌatꞌa pero chavay laqachaxancha malkuyuꞌ tiꞌukxuyal aynaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yu Dios xoqta lay makay, jantu kaꞌalil yu jantu lay makay. ");
INSERT INTO tptNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ex ni María va naul: —Chavaycha kitꞌin kunita ixꞌoqxtamati ni Jalhachimoꞌonu Dios. Kimakalcha va yu kimakaputuncha, yu tacha uxintꞌicha naꞌun. Ex va anchoqolcha ni mayul. ");
INSERT INTO tptNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ex taxtul ni María, va soqol tus chaꞌal taun putaulan laka xaꞌaspajunuxnan xaꞌestado Judea. ");
INSERT INTO tptNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tanuchal la ixchaqaꞌ Zacarías, va mastakꞌal ni Elisabet. ");
INSERT INTO tptNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tejkan qasmaklhi Elisabet ni jamastakꞌanti, ex ni jasꞌatꞌa va laklal la ixpajan. Ni Elisabet laqtanuꞌol ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Va la pꞌas naul: —Apalay ox kaxajtachal mijatsukunti xajantu matichun xanati. Vachuꞌ ni jasꞌatꞌa la mimpajan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Valiꞌiycha kimpaxtoqniy ni kilaqminta ixnati kiJalhachimoꞌonuꞌ? ");
INSERT INTO tptNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tejkan xkꞌili ijqasmaklhi mimastakꞌanti, va laklal kun achati ni jasꞌatꞌa la kimpajan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Va lhakꞌapꞌupꞌi ni laqsaval kunaꞌ yu naul ni Jalhachimoꞌonu Dios, xlhiyucha ox kaxajtachal mijatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ex va naul ni María: La kelhanuti, kitꞌin la ay kmakay ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","La ketsukunti va klhiꞌachantajuy ni Dios yu kimalaqtaxtuta. ");
INSERT INTO tptNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kimapaynil mas va klakatꞌuniy ni kitꞌin yu ixꞌoqxtamati kunita. Chavaycha tachun ni lapanakni mas va tavanancha va si kintajunaꞌ ni ox xajachal kijatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios lhitꞌajun tapꞌasta, va yucha kimakanita yu lajꞌay. Yucha va si ox junita. ");
INSERT INTO tptNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mas va tavanancha lakmapayniy tachun ni lapanakni yu tatoꞌoyay. ");
INSERT INTO tptNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tachun yu makay yucha va masuy ixtapꞌasta. Ni lapanakni yu lajꞌay takꞌatsꞌan la ixjatapastakꞌatkꞌan, va lakstꞌuniy lakmakatacha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Va lakmaxtunil ixtapꞌastakꞌan ni lajꞌay lapanakni, va lajꞌay lakmakal yu lakstꞌuniy takꞌatsan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yu tachavaniy va ox lakmaꞌotsanil. Yu maqalinin va lakmaxtuniꞌol yu ixtalhitꞌajun, valiꞌiy jalakmakaul. ");
INSERT INTO tptNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Yucha kintaꞌaqtayjuyan yu israelitas juntau, yu ixꞌoqxtamatin juntau. Jantu aqtaun kꞌapꞌa, va si kintamapayniyancha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Vachu va tacha lakjunil ni kepayankꞌan yu maqancha ixtatꞌajun. Vachu va tacha junkal ni Abraham, kalakmapaynikanaꞌ mas va tavanancha tachun sasꞌatꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ex chuncha ni María va tꞌataulal ni Elisabet va tacha laꞌatꞌutu malkuyuꞌ. Taval anchoqolcha la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Taval laqchaꞌal ni julchan, va maqlaqavanalcha ni Elisabet, lhitsukul va tsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ex ixlapanakni kun yu ancha ixtꞌataulnin va takꞌatsal ni Dios xtaqnil taun ay jamapayninti. Tachun talhiꞌachantajuꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tejkan laqchaꞌal paqtsajin julchan, va taꞌal xvililichukꞌuninin ni jasꞌatꞌa. Ex chuncha ni lapanakni va ixtajunputun Zacarías yu ixtaqaꞌuti ixpay. ");
INSERT INTO tptNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero ixnati qaltayanal, va najun: —Jantu yuꞌ kajunkanaꞌ, kajunkanaꞌ va Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ex tanaul: —¿Valiꞌiycha? Jantu matichun katsukul milapanaki yu chuncha kajunkal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ex talhisakmil yu ixpay yu janunuꞌ y aqatapa, va tamajkunil: —¿Tisuncha taqaꞌuti kꞌaꞌuneꞌe ni mintsꞌal? ");
INSERT INTO tptNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ex yu xapay skꞌil aqxtaun tabla, ancha tsꞌoqmukꞌal: “Kintsꞌal kajunkanaꞌ va Juan.” Ex ni lapanakni va tus tachun saq tatayal. ");
INSERT INTO tptNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ex taꞌoxichoqolcha ixkil ni Zacarías, laycha malaklanichoqoy isimaꞌati, chivinchoqolcha, va ay makal ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ex chuncha tatalhanal tachun ixtꞌataulnin. Talajunil yu tapasal tus takꞌatsaꞌol tachun ni lapanakni laka aspajunuxnan xaꞌestado Judea. ");
INSERT INTO tptNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tachun yu taqasmaklhi taꞌaqtayl tapastakꞌa, va tanajun: —¿Tis va suncha kunacha ni anu jasꞌatꞌa? Ni Jalhachimoꞌonu Dios ixꞌaqtayjuy ni jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ex ni xapay Zacarías laqtanuꞌol ni Espíritu Santo, laqputeꞌel ixchivinti Dios, va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ay kamakakal ni Dios kiJalhachimoꞌonukꞌan yu israelitas juntau. Kintalaqminan y kintamalaqtaxtuyan kijnan yu ixlapanakni juntau. ");
INSERT INTO tptNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kintamalaqachaniyan qayntaun Jamalaqtaxtunuꞌ yu lhitꞌajun tapꞌasta. Yucha ixpapanti kunaꞌ ni David yu maqancha ixꞌoqxtamati Dios ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tejkan talhichivinil ni ixlapanakni yu maqancha ixtalaqputeꞌey ixchivinti Dios, va inchine tanaul. ");
INSERT INTO tptNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kintamalaqtaxtuyan la ixtamakakꞌan yu kintꞌalaxkayninkꞌan y tachun yu jantu ox kintalaqtsꞌinan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Lakmapaynil ni kepayankꞌan yu maqancha ixtatꞌajun. Vachu pastakꞌa yu maqancha naul ni kamakayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios xtaqnil ixchivinti ni Abraham yu kimpaykꞌan yu maqancha ixtꞌajun, naul laqsaval katapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Naul ni kintamalaqtaxtuyan la ixtamakakꞌan yu kintꞌalakxkayninkꞌan, ex lay katapatsaniu ni yucha sin talhanti. ");
INSERT INTO tptNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Najun jantucha kaꞌalil kintalaqalhinkꞌan, vas katiꞌukxuntayau, mas va tavanancha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chavaycha uxintꞌi kesꞌatꞌa kꞌatꞌi, kalhimispꞌakꞌaneꞌe tacha qayntaun lapanaki yu laqputeꞌey ixchivinti Dios yu vilchal laktꞌiyan. Pꞌunaj kꞌapꞌulpꞌiniyeꞌe ni Jalhachimoꞌonuꞌ taꞌan kapuꞌanaꞌ, kꞌalaklaꞌoxiniyeꞌe ixjatapastakꞌatkꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kꞌalakmakꞌatsꞌaniyeꞌe ni lapanakni ni lay katapulaqtaxtul y kalaqmalaqmixinikal ixtalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ni Dios ayaj kintamapayniyan, xlhiyucha kintaxtaqniyan xamaklku laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Va tacha katunkul para jantucha kaputsꞌislhi la ixjatapastakꞌatkꞌan ni lapanakni para kapuꞌau la ixtin Dios y laqalajꞌox kajuu kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ex ni tsꞌal va aynlhi, va ixtꞌajun mispanaꞌ Dios. Va ixtiꞌukxuyal taꞌan jantu alin chaqan tus laktasunil xalapanakni Israel. ");
INSERT INTO tptNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ex chuncha ni jalhachimoꞌonuꞌ Augusto va lhinaul ni kaꞌalil latsꞌoqꞌulanti tachun ni lapanakni ni anchanuꞌ lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni anchanu latsꞌoqꞌulanti va yu pꞌunaj ixtamakay tejkan Cirenio xagobernador Siria ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ex chuncha tachun ni lapanakni talhiꞌalcha istsꞌoqꞌulakꞌan lakatamin por lakatamin taꞌan ixputaulankꞌan ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ex va chuncha ni José vachu taxtulcha ni laka putaulan Nazaret ni laka estado Galilea. Va al laka putaulan Belén taꞌan ixputaulan David ixjunita. Ni José minchal kun ixlapanakni David yu maqancha ay jalhachimoꞌonuꞌ ixjunita, ");
INSERT INTO tptNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","xlhiyucha ancha al istsꞌoqꞌulakꞌan. Tꞌaꞌal ni María ni yu iskꞌininti. Yucha aynacha ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ex chuncha tachaꞌal ni Belén. Tejkan laqchaꞌal julchan, va maqlaqavanalcha ni María. ");
INSERT INTO tptNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Lhitsukulcha istsꞌal yu saꞌoqsni, pamilil kun laqchꞌiti ex va mamal taꞌan tavajin ni jukin. Jantu kaꞌalil chaqaꞌ taꞌan lay kataloqojlhi. ");
INSERT INTO tptNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ni anchanu putsꞌista ixtavilanal lapanakni yu ixtalhistakꞌa ixborregoskꞌan la ixlhimaqspaꞌ ni putaulan Belén. ");
INSERT INTO tptNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ex va laktasunil ixmayul ni Dios, va tus tꞌoqx jamaputunkunil ixmaklku ni Dios, va la pꞌaysni ixjunita. Ex chuncha yuꞌuncha va la tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero lakjunil ni ixmayul Dios: —Jantu katꞌalhanantꞌik. Kitꞌin klajunputunau taun chivinti yu va ayaj ox yu kalakmaꞌachajuyaꞌ tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chavaycha la ixputaulan David va tsukuchal qayntaun yu katamalaqtaxtuyan ni uxiknankꞌan. Yucha ni Cristo yu laksakta ni Dios para kamil lhachimoꞌon ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Katꞌemayapitik ni jasꞌatꞌa pamilkanta, mamakanta taꞌan tavajin jukin. Tejkan chuncha katꞌemayapitik ex chuncha kꞌapꞌukꞌatsꞌayapitik ni laqsaval yu klajunau. ");
INSERT INTO tptNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ex nimancha tatasul lhuvaj ixmayulnin Dios, ay tamakal ni Dios, va tanajun: ");
INSERT INTO tptNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ay kamakakal ni Dios laktꞌiyan. Aniy lakamunukpaꞌ oxamaktaun katataulal ni lapanakni yu tamakay yu lhinajun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ex chuncha tejkan taꞌanchoqolcha laktꞌiyan ixmayulnin Dios, ex yu jalhistaknan va talajunil: —Kaꞌaucha ni laka putaulan Belén, kaꞌaucha laqtsꞌinin tacha tapasal yu kintamasunin Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ex tatakyauꞌalcha lakpuxkaunan, tatemachal ni María ali José kun ni jasꞌatꞌa, va mamakanta taꞌan tavajin jukin. ");
INSERT INTO tptNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ni jalhistaknan tejkan talaqtsꞌil ni jasꞌatꞌa talaqputeꞌenichoqol ni lapanakni yu ancha tayanal. Tajuniꞌol yu naul ni ixmayul Dios tejkan lhichivinil ni jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ex va tus saq tatayal tachun yu taqasmaktayl yu talaqputeꞌel ni jalhistꞌaknan. ");
INSERT INTO tptNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero ni María, yucha va maꞌaꞌol la ixjalhanuti tachun ni anchanu chivinti para kapastaklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ex taminchoqochalcha aaqtaun ni jalhistaknan, talhiꞌaylcha, va ay tamakal ni Dios por tachun yu ixtalaqtsꞌinta kun yu ixtaqasmakta. Va laqsaval tapasal tacha jalakjunil ni ixmayul Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ex va chuncha tejkan tapasal laqatsajin julchan va xvililichukꞌunikal ni tsꞌal. Ex tamukꞌanilcha ixtaqaꞌuti, va tajunil Jesús, tacha naul ixmayul Dios tejkan jantukaꞌ ixlhitsukuy la ixpulakna ni ixnati. ");
INSERT INTO tptNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ex astan vachuꞌ tamakal tachun yu ixtapaxtoqniy katamakal la ixlhachimoꞌon ni Moisés para oxicha kataval. Ex chuncha talhaꞌalcha ni jasꞌatꞌa yu ay lakatajtan, laka putaulan Jerusalén para katamaqxtaqnil ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Va chuncha tsꞌoqkanta la ixlhachimoꞌon ni Dios: “Tachun tsꞌal yu saꞌoqsni yucha ixnavin Dios kunaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xlhiyucha ancha taꞌal maqxtaqniniꞌ ixlapaxkankꞌan yu tacha najun ixlhachimoꞌon Dios: laꞌatꞌuy laqaxqavan u laꞌatꞌuy palumax. ");
INSERT INTO tptNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Qayntaun lapanaki yu junkan Simeón va ancha ixvil Jerusalén. Ni anchanu lapanaki la ox ixtiꞌukxuyal, va ixtoꞌoyay Dios. Ixpakxan para kaꞌalil qayntaun yu kamalakaꞌulal xalapanakni Israel. Ni Espíritu Santo va ixtꞌatiꞌukxuyal ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Va ixmasunita ni Espíritu Santo ni jantu kaniyaꞌ tus kalaqtsꞌinaꞌ ni Cristo yu kamalaqachayaꞌ Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ex chuncha ni Espíritu Santo va makꞌatsanil ni Simeón para katanul lakatajtan. Ex vachuꞌ ixpayan ni Jesús ancha tatanuchal para katamakal tacha najun ixlhachimoꞌon Moisés. ");
INSERT INTO tptNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ex ni Simeón chꞌapal ni jasꞌatꞌa, chꞌixlhi, ay makal ni Dios va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Chavaycha, Dios kiJalhachimoꞌonuꞌ kꞌatꞌi, ni kitꞌin yu miꞌoqxtamati kunita va oxamaktauncha kaknil vachu va tacha yu kꞌiꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chavay va klaqtsꞌilcha la kintalakavanti yu Jamalaqtaxtunuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Yucha malaꞌachꞌatꞌa para katalaqtsꞌil tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yucha va tacha taun maklku yu kalakmaputunkuviniyaꞌ ixjatapastakꞌatkꞌan ni lapanakni yu jantu israelitas kataval. Ni kijnankꞌan yu israelitas kuntau va por yucha kintatoꞌoyayan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ex chuncha yu ixpay ali ixnati va tus saq tatayal por ixchivinti yu lhichivinil ni jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ex ni Simeón va skꞌinil Dios ni kalaqꞌaqtayjul. Naul, va junkal ni María yu ixnati ni jasꞌatꞌa: —Ni aniy jasꞌatꞌa va por yucha pumalhuu xalapanakni Israel katataqtayaꞌ, vachu pumalhuu kataꞌostaulchoqoyaꞌ. Kamasuyaꞌ yu ox tin pero jantu ox katalaqtsꞌinaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chuncha ox katasuyaꞌ ixjatapastakꞌatkꞌan lhuvaj lapanakni. Xlhiyucha kaxkaniyan melhanuti tus va tacha espada yu kaltꞌoꞌonikꞌa mintankilakna. ");
INSERT INTO tptNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Vachu ancha ixvil qayntaun xanati yu ixlaqputeꞌey ixchivinti Dios. Yucha ixjunkan Ana, va istsiꞌi Fanuel ixjunita yu ixmaqlaqapꞌu Aser. Ni Ana la lhuvaj ixjachꞌitin ixjunita. Yu ixapay va laqatujun jachꞌitin ixtꞌatꞌajun tejkan nil. ");
INSERT INTO tptNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ex ni Ana yucha va ochenta y cuatro jachꞌitin tiyau ixtiꞌukxuyal. Va lhilhiy ixtapatsay laka ay lakatajtan, jantu ixtaxtuy, va iskꞌin Dios, ixtaskꞌajay. Va chuncha ixtamoꞌoniy ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ex chuncha tejkan ancha tachaꞌal José ali María, vachucha chaꞌal ni Ana. Va lhipaxkajlaqtsꞌil Dios por yu jasꞌatꞌa. Ex chuncha jalhixaqalal tachun ni lapanakni yu ixtapakxanꞌita para kalaqtaxtul ni laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ex chuncha tejkan ni María ali José tamakaꞌolcha tachun yu ixnajun ixlhachimoꞌon ni Dios, va taꞌanchoqolcha xaꞌestado Galilea la ixputaulankꞌan yu junkan Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ancha aynchal ni jasꞌatꞌa, va ancha laqapꞌaysninchal. Va lhuvaj jatapastakꞌati lhitsukul, vachu la mapaynil ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ixpayan ni Jesús ixtaꞌan laka Jerusalén taun taun jachꞌitin tejkan ixꞌalin ni Paxku yu ay ixkꞌatankꞌan ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tejkan laqchaꞌal laqakautꞌuy ixjachꞌitin ni Jesús, va jalaktꞌaꞌal laka kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tejkan paꞌanchal ni anchanu kꞌatan, ni ixpayan ni Jesús ixtaꞌanchoqota la ixchaqakꞌan. Jantu katakꞌatsal ni Jesús vananaj taulal laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ixtalhilay kalaktꞌamil alati lapanakni y chuncha va taun julchancha lakatin ixtaꞌanta. Tejkan tapuxkaul la ixlapanaknikꞌan kun ixꞌamigoskꞌan, ");
INSERT INTO tptNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jantu katatemal. Ex ixtaminchoqota lakxkaunan laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tejkan paqtꞌutunuꞌ, tatemal ni Jesús yu ay lakatajtan. Va ixlaktꞌavil yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Ixlajqasmatꞌa y vachuꞌ ixlaklhisakmiy chivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","La ox ixmalaqasiy y la ox ixlajqaltajiy tus va saq tataulal tachun yu ixtaqasmatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tejkan tatemal ni Jesús, ni ixpayan va saq tatayal. Va naul ni ixnati: —Kesꞌatꞌa, ¿valiꞌiycha chuncha laycha? Mimpay ali kitꞌin klapuxkauyau, jantu klatemayau, xakmaqaninintau. ");
INSERT INTO tptNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ex lakjunil ni Jesús: —¿Valiꞌiycha kilapuxkauyau? ¿Jantu kꞌatsꞌayatꞌik ni va maqskꞌiniy kakmakal ixlhitapatsa kimpay? ");
INSERT INTO tptNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yuꞌuncha jantu katamalaqasil yu lakjunil. ");
INSERT INTO tptNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ex laktꞌaꞌanchoqol ni Jesús laka putaulan Nazaret. Va ixlajqalasmatꞌa. Ni ixnati va ixmaꞌay la ixjalhanuti tachun yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ex ni Jesús va ixꞌajin y vachu ixꞌayꞌan ixjatapastakꞌati. Vachu ni Dios kun ni lapanakni ixtalhiꞌachantajuy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Laqakaukisicha jachꞌitin ixlhachimoꞌonunta yu ay jalhachimoꞌonuꞌ yu Tiberio ixjunkan. Ni Poncio Pilato xagobernador Judea ixjunita. Yu xagobernador Galilea yucha va Herodes ixjunita. Ixlaqaj Herodes va Felipe ixjunkan, yucha xagobernador Iturea ali Trakonite ixjunita. Yu Lisanias va xagobernador Abilinia ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yu Anás ali Caifás, yuꞌuncha ixꞌukxtinkꞌan xakuras israelitas ixtajunita. Ex chuncha lakakꞌavinan ni Dios va xaqalal ni Juan yu istsꞌal Zacarías. ");
INSERT INTO tptNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ex chuncha ni Juan tapasaꞌol talakachux taꞌan ukstsꞌuniy ni xalaꞌaxkan Jordán. Va jaxaqalal ni lapanakni para kataꞌaqchajꞌaul va chuncha katasul ni tapaxalcha ixjatapastakꞌatkꞌan, ex ni Dios kalaqmalaqmixinil ixtalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yu ixmakay ni Juan va tacha yu istsꞌoqta ni Isaías yu ixlaqputeꞌey ixchivinti Dios la maqancha, va naul: Qayntaun tꞌasay ni lakakꞌavin, va najun: “Kalaꞌoximanitꞌikcha ixlakatin ni Jalhachimoꞌonuꞌ. Vas kꞌamakꞌatꞌikcha para tsꞌalti katapasal.” ");
INSERT INTO tptNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tachun yu lakpuꞌuyan kalaqtsamaꞌokal. Tachun yu aspajunuxnan kalakpujkal. Taꞌan jalkꞌavil, va kalasavalakal, taꞌan lakapulkalau, va lakaputaun kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Va chuncha katatapaxalcha ixjatsukuntikꞌan tachun ni lapanakni. Katalaqtsꞌinaꞌ ni Dios tejkan kalaqmalaqtaxtuyaꞌ ni ixlapanakni —va chuncha naul ni Isaías. ");
INSERT INTO tptNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tejkan qaynlhuu lapanakni talaqchinchal ni Juan para kalaqmaꞌaqchajꞌaval, ex va lakjunil ni Juan: —Laktuꞌunuꞌ tsapulin untꞌatꞌik. ¿Taꞌayucha xatajunancha ni uxiknan para kaꞌostꞌik ni jamaqanlqajnati yu lakamintacha? ");
INSERT INTO tptNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kꞌamakꞌatꞌikcha yu lajꞌox para ex chuncha katasulcha ni mapꞌaxatꞌatꞌikcha mimputsukkꞌan. Jantu kanauntꞌik meꞌemankꞌan: “Ni Abraham yucha kimpaykꞌan”. Kitꞌin klajunau yu Dios lay kalakmapaxal ni aniy chiyux para kataval sasꞌatꞌan Abraham. ");
INSERT INTO tptNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chavaycha va tacha taun hacha yu va laycha kachaqxtal ni kꞌiu la ixtitakxiyati. Yu jantu makay yu lajꞌox, yucha kachaqxtakal, va kamapꞌukalcha ni laka jikmi. ");
INSERT INTO tptNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ex tanajun pumalhuu lapanakni: —¿Tas kakmakayaucha? ");
INSERT INTO tptNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ex qaltayanal ni Juan, va najun: —Yu lhitꞌajun aqxtꞌuy chamarra, va kaxtaqnil yu jantu kalhitsukul. Vachu yu lhitꞌajun ixlhiꞌuti, va katꞌaꞌul yu tsꞌanqaniy. ");
INSERT INTO tptNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ex chuncha tachinchal yu tachꞌinin impuestos para kamaqchajꞌavakal, va tanajun: —Jamalaniniꞌ, yu kijnan ¿tas kakmakayaucha? ");
INSERT INTO tptNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ex lakjunil ni Juan: —Jantu kꞌalhitꞌoqslaskꞌinitꞌik tumin yu jantu tapaxtoqniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ex yu tropas vachu talhisakmil: —Yu kijnan ¿tas kakmakayaucha? Ex lakjunil: —Jantu kꞌalakꞌalhaunitꞌik alati lapanakni kun miꞌayajnatkꞌan y jantu kꞌalakmakꞌanutꞌik. Kꞌatꞌaꞌoxamaktꞌamitꞌikcha kun yu milhilhajatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tachun ni lapanakni ixtapakxanꞌita yu ixtanajun kamalaqachayaꞌ ni Dios. Taval va ixtapastakꞌa la ixjalhanutkꞌan ni Juan kaval ni Cristo yu ixtanajun kaminaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero ni Juan va jalakjunil tachun ni lapanakni: —Ni kitꞌin va xkan klapumaꞌaqchajꞌavayau. Pero kaminaꞌ aqayntaun yu apalay ay xajantu kitꞌin. Yu kitꞌin tus jantu kimpaxtoqniy kaklakmusxꞌoqnil xamusni ni ixvarachi. Yucha katapumaꞌaqchajꞌavayan kun ni Espíritu Santo ali jikmi. ");
INSERT INTO tptNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Va tacha kalhitsukul la ixmakaꞌ ixpatankꞌalhan para kalaktankꞌalhal ni lapanakni tacha trigo. Yu lajꞌoxi kalakmaꞌayaꞌ la ixpakꞌatsa pero yu tacha pꞌoqxni kalaqxavayaꞌ laka jikmi yu jantu aqtaun kamixaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Va lhuu jatapastakꞌati jaxtaqnil ni lapanakni. Jalaqputeꞌenil ni ox chivinti yu masuy tacha lay katapulaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ni gobernador Herodes ixtꞌatꞌajun Herodías yu ixanati ixpꞌisaqa, vachu makal alati axtoqnuꞌ yu jantu ox kaval, xlhiyucha laqꞌaymal ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ex chuncha ni Herodes makachoqol yu apalay jantu ox, va manul laka pachꞌin ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ex chuncha tejkan taꞌaqchajꞌauꞌol tachun ni lapanakni, ni Jesús vachu aqchajꞌaul. Va aqtayl tamoꞌoy ex talaqltiꞌal ni laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Va taꞌeltujunil ni Espíritu Santo va tacha taun palumax. Vachuꞌ chivinkal ni laktꞌiyan, va junkal ni Jesús: —Uxintꞌi, kesꞌatꞌa kꞌatꞌi, ayaj ikpaxkayan. Va ayaj klhiꞌachantajuy por uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ex chuncha ni Jesús tejkan aqtayl tapatsaniy ni Dios va pꞌuxaunkau ixjachꞌitin. Ni lapanakni va ixtapastakꞌa ni Jesús va istsꞌal José. Ni José va istsꞌal Elí ");
INSERT INTO tptNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","yu istsꞌal Matat yu istsꞌal Leví yu istsꞌal Melki yu istsꞌal Jana yu istsꞌal José ");
INSERT INTO tptNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","yu istsꞌal Matatías yu istsꞌal Amós yu istsꞌal Nahúm yu istsꞌal Esli yu istsꞌal Nagai ");
INSERT INTO tptNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","yu istsꞌal Maat yu istsꞌal Matatías yu istsꞌal Semei yu istsꞌal José yu istsꞌal Judá ");
INSERT INTO tptNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","yu istsꞌal Joana yu istsꞌal Resa yu istsꞌal Zorobabel yu istsꞌal Salatiel yu istsꞌal Neri ");
INSERT INTO tptNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","yu istsꞌal Melki yu istsꞌal Adi yu istsꞌal Kosam yu istsꞌal Elmodam yu istsꞌal Er ");
INSERT INTO tptNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","yu istsꞌal Josué yu istsꞌal Eliezer yu istsꞌal Jorim yu istsꞌal Matat yu istsꞌal Leví ");
INSERT INTO tptNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","yu istsꞌal Simeón yu istsꞌal Judá yu istsꞌal José yu istsꞌal Jonán yu istsꞌal Eliaquim ");
INSERT INTO tptNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","yu istsꞌal Melea yu istsꞌal Mainán yu istsꞌal Matata yu istsꞌal Natán yu istsꞌal David ");
INSERT INTO tptNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","yu istsꞌal Isaí yu istsꞌal Obed yu istsꞌal Booz yu istsꞌal Salmón yu istsꞌal Naasón ");
INSERT INTO tptNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","yu istsꞌal Aminadab yu istsꞌal Aram yu istsꞌal Esrom yu istsꞌal Fares yu istsꞌal Judá ");
INSERT INTO tptNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","yu istsꞌal Jacob yu istsꞌal Isaac yu istsꞌal Abraham yu istsꞌal Taré yu istsꞌal Nakor ");
INSERT INTO tptNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","yu istsꞌal Serug yu istsꞌal Ragau yu istsꞌal Peleg yu istsꞌal Heber yu istsꞌal Sala ");
INSERT INTO tptNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","yu istsꞌal Kainán yu istsꞌal Arfaxad yu istsꞌal Sem yu istsꞌal Noé yu istsꞌal Lamek ");
INSERT INTO tptNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","yu istsꞌal Matusalén yu istsꞌal Enoc yu istsꞌal Jared yu istsꞌal Mahalaleel yu istsꞌal Kainán ");
INSERT INTO tptNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","yu istsꞌal Enós yu istsꞌal Set yu istsꞌal Adán yu istsꞌal Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ni Jesús ixlaqtanuꞌojota ni Espíritu Santo. Ex chuncha va minchoqochalcha ni laꞌaxkan Jordán. Ni Espíritu Santo va lhaꞌal Jesús lakakꞌavinan. ");
INSERT INTO tptNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ancha ixvilchal aqtꞌuy pꞌuxaun julchan. Ni xaꞌukxtin aqmoqxnuꞌ ixlaqtsꞌintanuy incha lay kamaqtaqalhinil ni Jesús. Ni Jesús jantu kavayl ni anchanu tꞌuy pꞌuxaun julchan, ex astan va chavanilcha. ");
INSERT INTO tptNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ex ni xaꞌukxtin aqmoqxnuꞌ va junil: —Incha laqsaval Sasꞌatꞌa Dios kꞌatꞌi, ex ni aniy chiyux kꞌamakꞌatꞌi pan. ");
INSERT INTO tptNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ni Jesús va qaltayl, va junil: —Yu tsꞌoqkanta la ixchivinti Dios va najun: “Qayntaun lapanaki, jantu vamun ixvayti kaputsukul. Va maqskꞌiniy kaputsukul tachun ni chivinti yu najun ni Dios.” ");
INSERT INTO tptNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ex chuncha ni xaꞌukxtin aqmoqxnuꞌ va lhaꞌal la ixꞌukxni taun ay aspajun. Ex taun panchꞌix ni Jesús va masunikal tachun ni lakamunukpaꞌ taꞌan talhachimoꞌonun lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ni xaꞌukxtin aqmoqxnuꞌ va junil: —Kakxtaqniꞌoyan ni uxintꞌi tachun ni palhachimoꞌon ni aniy lakamunukpaꞌ kun tachun ixtoꞌoxixtu. Va kitꞌin ikxtaqnikanta tachun yu aniy y lay ikxtaqnichoqoy va taꞌayucha kitꞌincha ikxtaqniputuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Incha kꞌintꞌaꞌaqtsꞌoꞌoqtꞌaniyeꞌe y kꞌintꞌamoꞌoniyeꞌe ex tachun minavin kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ex ni Jesús qaltayl: —Uxintꞌi Satanás, va kapiticha. La ixchivinti Dios najun: “Katꞌoꞌoyatꞌi vamun miJalhachimoꞌonu Dios yu alintachal laktꞌiyan, y vamun yuꞌ kꞌatꞌapꞌatsꞌanin.” ");
INSERT INTO tptNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ex chuncha ni xaꞌukxtin aqmoqxnuꞌ lhaꞌal ni Jesús laka putaulan Jerusalén. Tataukꞌal la ixꞌaqstiꞌ yu ay lakatajtan, va junil: —Incha laqsaval Sasꞌatꞌa Dios kꞌatꞌi, va kꞌaltꞌujnu ni aniy. ");
INSERT INTO tptNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Va tsꞌoqkanta la ixchivinti Dios: Ni Dios kalaklhijunaꞌ ni ixmayulnin para katalhistakni. ");
INSERT INTO tptNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Yuꞌuncha katatsꞌapꞌastꞌukꞌan la ixmakakꞌan, va para jantu kꞌatꞌaꞌalhitꞌi la minchꞌajaꞌ laka chiyux. ");
INSERT INTO tptNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ex ni Jesús qaltayl: —Vachuꞌ najun la ixchivinti Dios: “Jantu aqtaun kalaqtsꞌintꞌanutꞌi ni Dios miJalhachimoꞌonuꞌ incha laqsaval kamakayaꞌ yu najun.” ");
INSERT INTO tptNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ex chuncha ni xaꞌukxtin aqmoqxnuꞌ tejkan laqtsꞌintanuꞌol ni Jesús incha kamaqtaqalhinil, va makaul ni Jesús tus ataun julchan. ");
INSERT INTO tptNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ni Jesús anchoqopal ni xaꞌestado Galilea la ixtapꞌasta ni Espíritu Santo. Ex talakachux anchanu lakatꞌun ni lapanakni va si ixtalhichiviniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ni Jesús ixjamalaninin lakalhuu chaqan taꞌan ixtataqxtoꞌa ni israelitas y tachun tatoꞌoyal. ");
INSERT INTO tptNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ex ni Jesús al laka Nazaret yu putaulan taꞌan aynchal. Taun xajulchan jastaknati yucha tanupalchal taꞌan ixtataqxtoꞌa ni israelitas, va chuncha ixputsuku ixjunita. Ancha tayal, aqtaypalcha puteꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Taxtaqnil ni libro yu istsꞌoqta Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios. Tejkan puxꞌoqlhi ni libro, va temal taꞌan istsꞌoqkanta yu najun: ");
INSERT INTO tptNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","IxꞌEspíritu ni Jalhachimoꞌonu Dios yucha alinta kun kitꞌin. Va kilakꞌulal taun lhitapatsa, ni kaklakjunil ni kilpatanin yu ox chivinti. Kimalaqachata para kaklakmaꞌayajnil yu tamaqaninin la ixjalhanutikꞌan. Kimalaqachata para kaklaqlaqputeꞌenil ni tachꞌinin tacha lay oxamaktaun kataputaxtul. Kimalaqachata para kakmalakavanil yu laꞌachꞌixin para katataxꞌoqlhicha. ");
INSERT INTO tptNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kimalaqachata para kaklaqputeꞌenil ni lapanakni ni chilcha ni julchan tejkan Dios kalakmapayniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ex ni Jesús mapuxtoqchoqolcha ni libro, xtaqnil yu xaꞌaqtayjunuꞌ ni chaqaꞌ taꞌan tataqxtoꞌa, ex taulalcha. Tachun yu ixtaꞌalinta ni laqa chaqaꞌ, va tus sniy talaqtsꞌil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ex yucha aqtayl jalaktꞌachiviniy, va lakjunil: —Chavaycha laqsaval taqayntsal la mintalakaꞌukxpukꞌan anchanuꞌ chivinti yu tsꞌoqkanta la ixchivinti Dios yu xaꞌasmakyatꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ex tachun ox talhichivinil ni Jesús, va tus saq tataulal ni va ayaj lajꞌoxi ni chivinti yu naul. Pero astan ixtalalhisakmiy siya yuꞌuncha: —¿Jantu yuꞌ istsꞌal ni José? ");
INSERT INTO tptNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ex ni Jesús lakjunil: —Ni uxiknankꞌan laqsaval kilajunputunau ni chivinti yu najun: “Jakꞌuchꞌunuꞌ, kakꞌuchꞌuchꞌoꞌokꞌa meꞌeman.” Vachuꞌ laqsaval kilajunputunau: “Ijqasmakvi yu lajꞌay axtoqnuꞌ yu makꞌatꞌi laka putaulan Kapernaum. Chavay vachu va chun kꞌamakꞌatꞌi aniy la mimputaulan.” Va chuncha kilajunputunau. ");
INSERT INTO tptNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ex taylhaꞌal ixchivinti ni Jesús, va naul: —Laqsaval klajunau matichun lapanaki yu laqputeꞌey ixchivinti Dios, jantu talaqaꞌiy la ixputaulan. ");
INSERT INTO tptNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Laqsaval klajunau ayaj ixtaꞌalin lhuvaj tiyaunin ni xalakatꞌun Israel tejkan maqancha ixtꞌajun Elías yu ixlaqputeꞌey ixchivinti Dios. Jantu katamal xkan por laꞌatꞌutu jachꞌitin apakltaun, ex alil ay chavan talakapuchux ni anchanu lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ni Elías jantu kalhimalaqachakal kalaqꞌaqtayjul ni anchanuꞌ tiyaunin yu ixtavilanal xalakatꞌun Israel. Malaqachakal kaꞌaqtayjul va qayntaun tiyau yu ixvil laka putaulan Sarepta taꞌan ukstsꞌuniy ni laka putaulan Sidón. ");
INSERT INTO tptNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Vachuꞌ xalakatꞌun Israel ayaj ixtaꞌalin lhuvaj taqanꞌanin yu ixlakapuchꞌita tejkan maqancha ixtꞌajun ni Eliseo yu ixlaqputeꞌey ixchivinti Dios. Pero jantu matichun yuꞌuncha kalajkꞌuchꞌukal. Va kꞌuchꞌukal vamun ni Naamán yu machaqaꞌ Siria yu jantu israelita kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tejkan chuncha taqasmaklhi, ex tachun ni lapanakni laqa chaqaꞌ ayaj tatalqamal. ");
INSERT INTO tptNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tamaꞌostaulnil ni Jesús va talhaꞌal la ixlhimaqspaꞌ ni anchanu putaulan Nazaret. Talhaꞌal la ixkuktan ni aspajun taꞌan vil ni putaulan. Ixtanajun ni ancha katanqalhukal. ");
INSERT INTO tptNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ni Jesús pulaqpuslhi taꞌan ixtayanal ni yuꞌuncha, ex anchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ex chuncha ni Jesús anchoqol Kapernaum, va taun putaulan laka estado Galilea. Ancha aqtaynichoqol jalakmalaniy ni lapanakni taun xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tus vak takꞌatsal ni lapanakni por ixchivinti. Va ixchiviniy tacha qayntaun jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ni laqa chaqaꞌ taꞌan ixtataqxtoꞌa, ancha ixvil qayntaun joꞌati yu ixlhitꞌajun taun aqmoqxnuꞌ. Va pꞌas tꞌasal, naul: ");
INSERT INTO tptNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Kilamakajuucha. ¿Valiꞌiycha kilaꞌakxkauyaucha ni kijnan, Jesús, machaqaꞌ Nazaret kꞌatꞌi? ¿Va tꞌantꞌa para kilalaktꞌilhiu? Yu kitꞌin ikmispayan, ni uxintꞌi va yu ixnavin Dios kꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ex ni Jesús laqꞌaymal ni aqmoqxnuꞌ, va junil: —Saqcha kꞌuntꞌi, kamakꞌaucha ni aniy lapanaki. Ex chuncha ni aqmoqxnuꞌ chꞌapachoqol ni lapanaki tus maqtal lakatꞌun taꞌan tayanal ni lapanakni, ex taxtunichoqolcha, jantucha tuꞌuchun kamakanil. ");
INSERT INTO tptNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ex tus tachun tatalhanal y taꞌaqtayl talajuniy: —¿Suncha lhichiviniy ni aniy lapanaki? Lhitꞌajun tapꞌasta para kalaklhijunil ni jantu ox espíritus ni katataxtul y yuꞌuncha tataxtuꞌojoy. ");
INSERT INTO tptNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ex chuncha mas va toꞌoxtaycha putaulan kaval ni anchanu lakatꞌun si ixtalhichiviniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ex ni Jesús taxtuchal ni laqa chaqaꞌ taꞌan ixtataqxtoꞌa, va al la ixchaqa ni Simón Pedro. Ixꞌatinaꞌ ni Pedro ixtaqanꞌay, va ixchꞌapata pꞌas skakati. Ex tatapayninil kaꞌaqtayjul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ex chuncha ni Jesús tayal taꞌan mal ni taqanꞌan, va laqꞌaymal ni skakati, ex ni skakati va niman makaunchoqol. Ni ixꞌatinaꞌ Pedro nimancha ostaulchoqol, aqtaylcha jalakvavay. ");
INSERT INTO tptNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ex tejkan va laycha kaꞌanchal ni julchan, ixtaꞌalin taqanꞌanin yu xoqtacha taqanꞌati ixtalhitꞌajun, va laklhiminikal ni Jesús. Yucha va qayntamin laqmoqslanil ixmakaꞌ. Chuncha va lakmaꞌayajniꞌochoqol ni taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","La lhuvaj aqmoqxnun tataxtul la ixlakatunajkꞌan ni lapanakni, talaktꞌasal, va tanajun: —Uxintꞌicha ni Sasꞌatꞌa Dios kꞌatꞌi. Pero ni Jesús, yucha jalaqꞌaymal ni aqmoqxnun para jantucha katachivinil. Ixtakꞌatsay ni Jesús va yu laksakta Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tejkan tunkumintacha, ni Jesús taxtul ni laka putaulan, al taꞌan jantu tꞌujuꞌ chaqan pero yu lapanakni talakxkaul tus tatemachal taꞌan ixvilchal. Tatapayninil ni Jesús para jantu kalakmakaul. ");
INSERT INTO tptNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ni Jesús va lakjunil: —Kitꞌin ikmaqskꞌiniy kajkꞌal alati putaulanaxna, kaklaqputeꞌel ni ox chivinti tacha lhachimoꞌonun ni Dios. Va yucha klhimalaqachakanta. ");
INSERT INTO tptNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ex chuncha ixtiꞌukxuyal ni Jesús xaꞌestado Galilea, ixlaqputeꞌey ixchivinti Dios laqa chaqan taꞌan ixtataqxtoꞌa ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Taun julchan ni Jesús ixyachal la ixkilpaꞌ yu ay lakxkan yu junkan Genesaret. Va tachinchal lhuvaj lapanakni tus lapatsꞌiuksni ixtajunita, taqasmakputuncha ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ni Jesús laqtsꞌil laꞌatꞌuy barcos laqpoqapaj ixtavilanal lakxkan taꞌan va ukstsꞌuniycha ni ixkilpaꞌ. Ni xachꞌapanan jatanti yuꞌuncha ixtalaqtaxtutacha, ixtatꞌajunchoqoycha chaꞌanan ixchꞌoqxkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ex ni Jesús tajul laqataun barco yu ixnavin Simón Pedro ixjunita, tapayninil para stal kalhaꞌal tsꞌuniy. Ex ni Jesús taulalcha ni laka barco, aqtaylcha lakmalaniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tejkan chivinꞌol, junil ni Simón: —Kꞌamuuchꞌoꞌo ni mibarco, kalhipꞌinchiy tus taꞌan pulman ni lakxkan. Ancha kꞌamutꞌi ni minchꞌoqxni para kachꞌapꞌa ni jatanti. ");
INSERT INTO tptNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yu Simón qaltayl: —Jamalaniniꞌ, chavay taun tatsꞌis xaktapatsayau, jantu tuꞌuchun kakchꞌapau, pero incha uxintꞌi lhinaꞌun, ex kakmujuchoqoyaꞌ ni kinchꞌoqxni. ");
INSERT INTO tptNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ex tejkan laqsaval chuncha tamakal yu laklhijunil ni Jesús, tachꞌapal lhuvaj jatanti tus taꞌexlhi ni ixchꞌoqxkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ex chuncha aqtaylcha talamaqnaqaꞌiy yu ixtꞌaltanankꞌan yu ixtatajumanal alakataun barco, va para katamil aqtayjunun. Ex ni yuꞌuncha tamil, va tus tamaꞌaqtsamal ni laꞌatꞌuy barco, va laycha kataꞌanchal ni barcos por istsꞌinkꞌixtu ni jatanti. ");
INSERT INTO tptNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tejkan chuncha laqtsꞌil ni Simón Pedro tus taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ ni Jesús, va junil: —Kꞌimakꞌaucha, Jalhachimoꞌonuꞌ, ni kitꞌin va qayntaun maqtaqalhiniꞌ joꞌati kunita. ");
INSERT INTO tptNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ni Simón kun yu ixtatꞌaꞌalinta va tus saq taval por tachꞌapal lhuvaj jatanti. ");
INSERT INTO tptNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Vachuꞌ Jacobo ali Juan yu sasꞌatꞌan ni Zebedeo yu ixtꞌaltanan ni Simón, yuꞌuncha vachu va tus saq taval. Pero ni Jesús junil ni Simón: —Jantu katꞌalhan. Va ixtꞌemay jatanti pero chavaycha kalaktꞌemayeꞌe lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ex tejkan talhimilcha ixkilpaꞌ lakatꞌun ni barcos, va tus talakmakaulaꞌol tachun ixꞌaxtoqnukꞌan, va tatꞌaꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tejkan Jesús ixvil lakataun putaulan, chinchal qayntaun lapanaki yu ixlakapuchꞌita. Va laqtsꞌil Jesús ex taꞌaqtsoqoqtal y talakaputatamal tus lakatꞌun, tapayninil, va junil: —Jalhachimoꞌonuꞌ, incha uxintꞌi kꞌanau, lay kinkꞌuchꞌunin kintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ex ni Jesús moqslanil ixmakaꞌ, va junil: —Chun, kitꞌin knajun palaycha kꞌaꞌunchꞌoꞌo. Tejkan chuncha naul ni Jesús, va niman palay junchoqol ni lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ex ni Jesús junil: —Jantu matichun kalaqputeꞌenin. Vamun kalaqpꞌinchiy yu kura y kalhipꞌinin milapaxkan yu tacha lhinajun ixlhachimoꞌon ni Moisés, para katakꞌatsaꞌol ni lapanakni ni palaycha unchꞌoꞌotꞌa mintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero takꞌatsaꞌolcha tachun ni lapanakni yu ixmakay ni Jesús. Xlhiyucha lhuvaj lapanakni ixtataqxtoꞌa para kataqasmaklhi ixchivinti vachuꞌ para kalajkꞌuchꞌukal. ");
INSERT INTO tptNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero ni Jesús, yucha ixꞌan taꞌan jantu tꞌujuꞌ lapanakni, ancha ixtꞌachiviniy ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Taun julchan ni Jesús ixtꞌajun jamalaniniꞌ. Ancha ixtavilanal ni fariseos ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Yuꞌuncha taminchal talakachux putaulanaxna xaꞌestado Galilea, xaꞌestado Judea y vachu laka putaulan Jerusalén. Ni Dios ixtaqnita ni Jesús ixtapꞌasta para lay kalakmaꞌayajnichoqol ni taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ex tachinchal alati lapanakni, va talhiminta laka putaman qayntaun taqanꞌan yu ixlakanita. Ixtamanuputun ixpulakna laqa chaqaꞌ la ixtalakaꞌukxpuꞌ ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero jantu katatemal toꞌoxtaycha kataputanuchal, va ixtaꞌalinta lhuvaj lapanakni. Ex chuncha tataukꞌal ixꞌukxni ni chaqaꞌ y taꞌaqtayl tamoqosuniy xalaseqen. Ex ancha tapumaꞌeltajul ni taqanꞌan la ixputaman taꞌan ixtayanal ni lapanakni, la ixtalakaꞌukxpuꞌ ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tejkan ni Jesús jalaqtsꞌil ni ox talhakapuꞌalcha, ex junil ni taqanꞌan: —Lapanaki, yu mintalaqalhin chavay malaqmixikalcha. ");
INSERT INTO tptNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ex yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu fariseos taꞌaqtayl tapastakꞌa: —¿Tas ayucha ni aniy lapanaki? Yucha tꞌajuncha akchꞌintamanaꞌ ni Dios kun ixchivinti. Jantu matichun lay malaqmixiy ni talaqalhin, ni talaqalhin malaqmixiy vamun Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ni Jesús ixkꞌatsaycha yu ixtatꞌajun pastaknan, va lakjunil: —¿Valiꞌiycha chuncha pꞌastꞌakꞌatꞌik ni uxiknankꞌan? ");
INSERT INTO tptNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Suncha jantu lhitaꞌay kaval? ¿Kꞌaꞌun: “Yu mintalaqalhin laqmixlhicha”, u va kꞌaꞌun: “Kꞌaꞌostꞌaꞌulcha, katꞌiꞌukxuntꞌayachꞌoꞌocha”? ");
INSERT INTO tptNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Chavay klamasuniyau ni kitꞌin yu kval Sasꞌatꞌa Lapanaki klhitꞌajun lhachimoꞌon aniy lakamunukpaꞌ para kakmalaqmixil ni talaqalhin. Ex va junil ni lapanaki yu ixlakanita: —Chavay ijkunan, kaꞌostꞌaꞌulcha, kalhipꞌinchꞌoꞌocha mimputaman. Kꞌapꞌinchꞌoꞌocha la minchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ex yu ixlakanita va niman ostaulchoqol la ixtalakaꞌukxpukꞌan ni lapanakni, lhaꞌal ixputaman, anchoqolcha la ixchaqaꞌ, va ay ixmakay ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tachun ni lapanakni va tus saq taval, ay tamakalcha ni Dios. Va ayaj tatalhanal, tanajun: —Chavay laqtsꞌiucha lajꞌay axtoqnuꞌ yu jantu aqtaun laqtsꞌinau. ");
INSERT INTO tptNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ex astan taxtul ni Jesús, va laqtsꞌil qayntaun yu chꞌinin impuestos yu ixjunkan Leví. Va ixvil taꞌan mapalkan impuestos. Ni Jesús va junil: —Kꞌintꞌatꞌatꞌicha. ");
INSERT INTO tptNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ex ni Leví ostaulal, lakmakaunꞌol tachun ixꞌaxtoqnuꞌ, va tꞌaꞌalcha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ex chuncha ni Leví va makal taun ay lakvayti la ixchaqaꞌ para Jesús. Vachuꞌ ancha ixtavilanal laka mesa qaynlhuvaj yu xachꞌinin impuestos kun alati lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yu fariseos ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas taꞌaqtaynil talaktuꞌuy ixtꞌaltanan ni Jesús, tanaul: —¿Valiꞌiycha vaynatꞌik y oqnunatꞌik kun yu tachꞌinin impuestos ali alati yu maqtaqalhinin? ");
INSERT INTO tptNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús lajqaltayl, lakjunil: —Yu taꞌayajnan jantu tamaqskꞌiniy kalajkꞌuchꞌukal, yu tamaqskꞌiniy va yu taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kitꞌin jantu ikminta laktꞌasaꞌin yu lajꞌoxi lapanakni, va ikminta laktꞌasaꞌin yu maqtaqalhinin para katamapaxal ixjatapastakꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ex talhisakmil ni Jesús: —¿Valiꞌiycha ixtꞌaltanan ni Juan y vachuꞌ ixtꞌaltanan ni fariseos ayaj tatamoꞌoy y tataskꞌajay pero yu mintꞌaltanan, yuꞌuncha si tavajin y taꞌoqnun? ");
INSERT INTO tptNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús jaqaltayl: —Tejkan alin lakxtuklati, jantu lay kꞌalhinau ni jantu katavayl yu jalakjuntaꞌikanta tejkan vananaj tatꞌavilanal ni tsꞌal yu lakxtuklay. ");
INSERT INTO tptNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero kaminaꞌ julchan tejkan kamaxtukanaꞌ ni anchanuꞌ tsꞌal, ex ixtꞌaltanan katataskꞌajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ex ni Jesús lakjunchoqol taun chivinti yu xtaꞌa jatapastakꞌati, va naul: —Jantu matichun exa aqxtaun laqchꞌiti yu sastꞌi para kalhilaqpumpul taun laqchꞌiti yu atꞌalicha. Incha chuncha makay, ex maqatsꞌanqaycha yu sastꞌi laqchꞌiti. Yu sastꞌi laqchꞌiti jantu lay ox junchoqoy kun ni laqchꞌiti yu atꞌaliꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Vachu jantu lay kꞌamuꞌutꞌi yu sastꞌi xaxkan uva laka jaxtaꞌan yu atꞌaliꞌ. Yu xaxkan uva yu sastꞌi va matampaꞌay yu atꞌaliꞌ jaxtaꞌan. Ex chuncha yu xaxkan uva ali yu jaxtaꞌan va tatsꞌanqaycha. ");
INSERT INTO tptNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yu xaxkan uva yu sastꞌi va kꞌamuꞌutꞌi laka jaxtaꞌan yu sastꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jantu matichun otꞌa yu sastꞌi xaxkan uva incha oqtacha yu maqaniyaꞌ. Tanajun: “Yu maqaniyaꞌ apalay ox.” ");
INSERT INTO tptNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Taun xajulchan jastaknati ni Jesús ali ixtꞌaltanan ixtapuꞌanta taꞌan alinta tachꞌanati, yu ixtꞌaltanan taꞌaqtayl talajꞌexꞌiy yu xataltsꞌi ni trigo, va taxapꞌiꞌulhaꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ex lati yu fariseos va talhisakmil: —¿Valiꞌiycha makꞌayatꞌik lhitapatsa chavay mas jantu xtaqkan lakatin kꞌatꞌapꞌatsꞌatꞌi ni xajulchan jastaknati? ");
INSERT INTO tptNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ex ni Jesús va jaqaltayanal: —¿Jantu kꞌapꞌutꞌeꞌetꞌik tacha tamakal ni David kun ixtꞌaltanan tejkan tachavanil? ");
INSERT INTO tptNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tejkan tanul la ixchaqa ni Dios, chꞌapal ni pan yu ixmoqslanikan Dios, va ul, ex jalaqxtaqnil ixtꞌaltanan. Chuncha makal mas vamun ni kuras ixtalhitꞌajun lakatin para kataꞌul ni anchanu pan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ex vachuꞌ naul ni Jesús: —Ni kitꞌin yu Sasꞌatꞌa Lapanaki klhinajun tisuncha lay makakan ni xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ex ataun xajulchan jastaknati val. Ni Jesús tanul laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas, ancha masul ixchivinti Dios. Ancha ixꞌalinta qayntaun lapanaki yu jantu lay ixmapuꞌay ixlhijakanaj makaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu fariseos ixtalaqtsꞌintanuy ni Jesús. Incha kakꞌuchꞌul mas va xajulchan jastaknati ex lay kataputislajmal. ");
INSERT INTO tptNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ni Jesús ixkꞌatsaycha yu ixtatꞌajun pastaknan. Ex junil ni lapanaki yu jantu lay ixmapuꞌay ixmakaꞌ: —Kaꞌostꞌaycha, kꞌatꞌanꞌajtꞌaycha aniy. Ex ni lapanaki ostayalcha, va ancha tayal. ");
INSERT INTO tptNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ex ni Jesús lakjunil yu alati: —Kaklalhisakmiyau taun tuꞌuchun. ¿Ni xajulchan jastaknati tas lhinajun kilhachimoꞌonkꞌan? ¿Lhinajun kꞌamakꞌatꞌi yu ox u va lhinajun kꞌamakꞌatꞌi yu talaqalhin? ¿Lhinajun kꞌamalaqtꞌaxtꞌutꞌi u va lhinajun kꞌamaqnitꞌi? ¿Tas lhinajun? ");
INSERT INTO tptNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ex ni Jesús jalaqtsꞌil tachun yu ixtamalaqachoqoxnuta ex junil ni lapanaki: —Kꞌaxnujtꞌi mimakaꞌ. Ex ni lapanaki xnujlhi ixmakaꞌ, oxicha junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ayaj talukujlal. Aqtaylcha talaxaqalay, va talalhisakmiy tisuncha lay katamakanil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tejkan chuncha ixtiꞌukxuntayay, ni Jesús al skꞌiniꞌ Dios laqataun aspajun. Ancha taun tatsꞌis tꞌachivinil Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tejkan tunkunchoqol lakjuntaꞌil ixtꞌaltanan, jalaksaklhi pumakautꞌuy, va jalakꞌulal ixtamalaqachan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Laksaklhi Simón, yu Jesús junil Pedro. Vachuꞌ Andrés yu ixtꞌalaqajun ni Simón. Vachuꞌ Jacobo ali Juan ali Felipe ali Bartolomé ");
INSERT INTO tptNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ali Mateo ali Tomás ali Jacobo istsꞌal ni Alfeo ali Simón yu ixjunkan Zelote. ");
INSERT INTO tptNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Vachu Judas ixtꞌalaqajun ni Jacobo y vachuꞌ aputaun yu ixjunkan Judas Iscariote yu astan maqxtaqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ni Jesús laktꞌatajuminchal ixtꞌaltanan ni laka aspajun. Tachinchal taꞌan akpujunan, ancha tatayal. Vachuꞌ ixtaꞌalinta pumalhuu ixtꞌaltanan kun pumalhuu yu machaqan xaꞌestado Judea, yu machaqan Jerusalén, vachuꞌ yu machaqan laka putaulan Tiro ali Sidón. Tachinchal para kataqalasmaklhi ni Jesús y vachuꞌ para kalajkꞌuchꞌukal ixtaqanꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Vachu ni Jesús palay jalakmakal ni lapanakni yu jamamaqanlqajnivay ni jantu ox espíritus. ");
INSERT INTO tptNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tachun ni lapanakni ixtachꞌapaputun ni Jesús, ixtapꞌasta taxtuniy para kalajkꞌuchꞌul ni taqanꞌanin tejkan lakpiklay. ");
INSERT INTO tptNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ex ni Jesús jalaqtsꞌil ixtꞌaltanan, va lakjunil: —Lajꞌox kaxajtachal mijatsukuntikꞌan ni uxiknankꞌan kilpatanin, tapaxtoqniyan kꞌatꞌanutꞌikcha taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Lajꞌox kaxajtachal mijatsukuntikꞌan yu chavay chꞌavanitꞌikcha, astan kꞌaꞌotsꞌayapitik. ’Lajꞌox kaxajtachal mijatsukuntikꞌan yu chavay alhunatꞌik, astan kꞌalajꞌachꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Lajꞌox kaxajtachal mijatsukuntikꞌan tejkan taxkayyan ni lapanakni, tejkan jantucha tatꞌaltananputunan, tejkan talaktuꞌuyan, vachuꞌ tejkan tamanuniyan jalaklkanti por kilapanakni untꞌatꞌik ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ayaj kalhiꞌachꞌantꞌaꞌutꞌik kun lhuu achati ni anchanu julchan tejkan chuncha katamakaniyan. Ay kunaꞌ milhilhajatkꞌan ni laktꞌiyan. La maqancha ixpayankꞌan vachuꞌ jantu ixtalaqtsꞌinputun yu ixtalaqputeꞌey ixchivinti ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero payniꞌincha yu uxiknankꞌan maqalinin, vamun chavay lhitꞌaunatꞌik achati. ");
INSERT INTO tptNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Payniꞌincha ni uxiknankꞌan yu chavaycha tus ox otsꞌatꞌatꞌik, astan kꞌachꞌavanapitik. ’Payniꞌincha ni uxiknankꞌan yu chavaycha achꞌanatꞌik, astan kꞌamaꞌaninanapitik y kꞌalajꞌalhunapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Incha tachun ni lapanakni tanajun lajꞌoxi lapanakni untꞌatꞌik, ex payniꞌincha ni uxiknankꞌan. Maqancha ixpayankꞌan vachuꞌ talakjunil lajꞌoxi lapanakni yu jamakanunun, yu ixtanajun ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero uxiknan yu kilaqalasmatꞌau, klajunau kapꞌaxkꞌatꞌik mintꞌalaxkayninkꞌan. Kꞌamakꞌanitꞌik lajꞌoxi yu taxkayyan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kꞌalaklhitꞌapꞌaynitꞌik yu ox yu tanajun jantu ox kꞌatꞌapꞌasatꞌik. Kaskꞌinitꞌik Dios yu tamakaniyan laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Incha matichun palaqstisayan va kaxtꞌaqnin aminpalaqxtitaun. Incha matichun kamaxtunin minkutun, kamakꞌaunincha vachuꞌ kalhaꞌalcha mixkujuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Incha matichun skꞌiniyan taun tuꞌuchun kaxtꞌaqnin. Incha tamaxtuniyan yu minavin, jantucha maqskꞌiniy kaskꞌinichꞌoꞌo. ");
INSERT INTO tptNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kalakmakꞌanitꞌik yu alati vachu va tacha naunatꞌik katamakanin. ");
INSERT INTO tptNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Incha pꞌaxkꞌayatꞌik vamun yu tapaxkayan, ¿ex tisuncha xtapal kaval? Yu talaktuꞌunun vachu va chuncha talapaxkay. ");
INSERT INTO tptNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Incha makꞌaniyatꞌik lajꞌoxi vamun yu tamakaniyan lajꞌoxi, ¿ex tisuncha xtapal kaval? Yu maqtaqalhinin vachu va chun talamakaniy. ");
INSERT INTO tptNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Incha machꞌixtꞌaqniyatꞌik vamun yu lay katamapalnichoqoyan, ¿ex tisuncha xtapal kaval? Yu maqtaqalhinin vachu va chun talamachꞌixtaqniy para katalaqaꞌichoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kꞌalakpꞌaxkꞌatꞌik mintꞌalaxkayninkꞌan, kꞌalakmakꞌanitꞌik yu lajꞌoxi, kꞌaxtꞌaqnitꞌik yu taskꞌiniyancha mas jantu kataxtaqnichoqoyan. Ex ay kunaꞌ milhilhajatkꞌan, vachuꞌ kꞌaꞌunapitik sasꞌatꞌan Dios. Ni Dios lakmapayniy mas yu jantu tapaxkajlaqtsꞌin ali yu talaktuꞌunun. ");
INSERT INTO tptNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kamapꞌayninitꞌik vachu va tacha mimPay Dioskꞌan tamapayniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Jantu kꞌalakmukꞌanitꞌik laqtaqal yu alati lapanakni ex ni uxiknan jantu katamukꞌaniyan laqtaqal ni Dios. Jantu kꞌamukꞌatꞌik maqanlqajnati, ex jantu katamukꞌaniyan maqanlqajnati. Kꞌalamalaqmixinitꞌik, ex katamalaqmixiniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Kꞌalaqxtꞌaqnitꞌik yu tamaqskꞌiniy ex kaxtꞌaqnikꞌanapitik yu maqskꞌiniyatꞌik. Kataxtaqniyan kun taun papulkan yu ox jakꞌalhamunti, ox jakꞌauksmunti y ox jatsꞌiuksmunti. Katapuxtaqniyan ni uxiknankꞌan vachu va tacha japꞌuxtꞌaqniyatꞌik yu alati. ");
INSERT INTO tptNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ex ni Jesús lakjunil taun chivinti yu xtaꞌa jatapastakꞌati, va naul: —Qayntaun laꞌachꞌix jantu lay kamapꞌulal aqayntaun laꞌachꞌix. Katataqalqosaꞌ ixlaꞌatꞌuykꞌan, va chꞌantaun katalaqpaꞌaꞌ laka pusanjan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jantu matichun yu malanikanta apalay ay xajantu yu jamalaniy. Tejkan kalaniꞌoyaꞌ, ex vachu va chun kunaꞌ tacha ixjamalaniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Valiꞌiycha makꞌay kuenta yu lakatꞌuniy laqtaqal yu makay qayntaun milaqaj pero jantu makꞌay kuenta yu la ay laqtaqal yu makꞌay uxintꞌi? Va tacha laqtsꞌiniy xatalvayanti kꞌiu yu lakputanun la ixlaqchul milaqaj, pero jantu makꞌay kuenta yu la milaqchul va lakputanun maqaꞌay kꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chavay incha lakputanun ni maqaꞌay kꞌiu la milaqchul, ¿ex valiꞌiycha uniy milaqaj: “Kakmaxtuniyan yu xatalvayanti kꞌiu yu lakputanun la milaqchul”? Va tꞌuy ukxpuꞌ makꞌay. Maqskꞌiniy pꞌunaj kꞌamaxtꞌuꞌel ni maqaꞌay kꞌiu yu lakputanun la milaqchul, ex chuncha apalaycha ox kꞌalakꞌavananeꞌe para kꞌamaxtꞌunin xatalvayanti kꞌiu yu lakputanun la ixlaqchul milaqaj. ");
INSERT INTO tptNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Jantu tꞌujuꞌ ox kꞌiu yu xtaꞌa xaꞌunikan yu jantu ox kaval. Nisin jantu kaꞌalilcha kꞌiu yu jantu ox kaval yu xtaꞌa xaꞌunikan yu ox. ");
INSERT INTO tptNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tachun kꞌivinan pumispakan ni xaꞌunikan yu xtaꞌa. Jantu lay kꞌapꞌuxtꞌi higo laka jaltukun, vachuꞌ jantu lay kꞌapꞌuxtꞌi uvas taꞌan valiꞌiy jakꞌivinan. ");
INSERT INTO tptNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yu ox lapanaki, la ixjalhanuti maꞌata yu lajꞌoxi, ancha maxtuy yu lajꞌoxi chivinti. Yu laktuꞌunuꞌ lapanaki la ixjalhanuti maꞌata yu jantu lajꞌoxi kaval y ancha maxtuy chivinti yu jantu lajꞌox. Va kiltaxtuy ixchivinti tacha najun ixjalhanuti. ");
INSERT INTO tptNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Valiꞌiycha kilajunau ni uxiknankꞌan, kiJalhachimoꞌonu, kiJalhachimoꞌonu, pero jantu makꞌayatꞌik yu klalhijunau? ");
INSERT INTO tptNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chavay klajunau tacha junita yu kinqalasmatꞌa y makay tacha yu kitꞌin klhinajun. ");
INSERT INTO tptNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yucha va tacha qayntaun lapanaki yu makal aqataun chaqaꞌ. La pulman maknunil ixputayan, va si kun chiyux. Ex tejkan aynlhi ni laꞌaxkan talakanunil kun tachun ixtapꞌasta para kamaqtal ni anchanuꞌ chaqaꞌ. Pero jantu tsꞌuniy kapiklal, va lhitꞌajun ixputayan si chiyux. ");
INSERT INTO tptNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero yu qasmatꞌa kinchivinti incha jantu makay yu kitꞌin klhinajun, yucha va tacha qayntaun lapanaki yu makal ixchaqaꞌ lakatꞌun, jantu kun xaputayan. Ex tejkan aynlhi ni laꞌaxkan talakanunil kun tachun ixtapꞌasta, va tus tachun lakpujꞌol, laqcheꞌeꞌol, va aqtaun lhaꞌanꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tejkan Jesús laqxaqalaꞌol ni lapanakni va al Kapernaum. ");
INSERT INTO tptNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ancha ixꞌalin qayntaun yu machaqaꞌ Roma, va xaꞌukxtin tropas. Ixlhitꞌajun qayntaun ixꞌoqxtamati yu va chapujcha ixꞌachaniy. Va ixtaqanꞌay, va laycha kanil. ");
INSERT INTO tptNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tejkan ni xaꞌukxtin kꞌatsal ni ancha tꞌajun ni Jesús, jalaqmalaqachal yu xalajꞌaynin israelitas para kataꞌal tapayninin para kamil kꞌuchꞌuniniꞌ ixꞌoqxtamati. ");
INSERT INTO tptNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ex yuꞌuncha talaqchinchal ni Jesús, taꞌaqtaynil tatapayniniy, va tajuniy: —Ni anuꞌ xaꞌukxtin tropas, yucha qalꞌox, paxtoqniy kꞌaꞌaqtꞌayꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ayaj kintapaxkayan ni kijnankꞌan yu israelitas juntau. Va yucha lhinaul ixmakaka ni chaqaꞌ taꞌan taqxtoꞌau. ");
INSERT INTO tptNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ex ni Jesús laktꞌaꞌal pero tejkan va ukstsꞌuniycha para katachaꞌal ni laqa chaqaꞌ, ni xaꞌukxtin tropas jamalaqachal ixꞌamigos para katalhaanil ni Jesús taun chivinti, najun: —Jalhachimoꞌonuꞌ, kitꞌin jantu ox kakval, jantu kimpaxtoqniy para kꞌintꞌatꞌanuchiy la kinchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Xlhiyucha jantu kꞌanchaꞌan lakxkaunan, va jantu ox kakval. Incha uxintꞌi naꞌun, ex ni kiꞌoqxtamati va palaycha kajunchoqoyaꞌ mas maqati yachiy. ");
INSERT INTO tptNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Kitꞌin klhitꞌajun kiꞌukxtin, vachuꞌ la kintamakaꞌ alin tropas yu kintaꞌaqtayjuyan. Tejkan xaqayntaun ijkuniy kaꞌal avintꞌi, ex ni yucha va niman an. Yu aqayntaun tejkan ijkuniy kamil, va niman min. Yu kiꞌoqxtamati tejkan ijkuniy kamakal tuꞌuchun, yucha va niman makay. Uxintꞌi vachu chun lay kalhinau palay kajunchoqol ni kiꞌoqxtamati. ");
INSERT INTO tptNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tejkan qasmaklhi ni Jesús va tus saq tayal. Taspꞌiklhi, jalaqtsꞌil ni ixtalhavaxtu lapanakni yu ixtatixkaulhaꞌanta, va lakjunil: —Laqsaval jantu matichun kaktemal xalakatꞌun Israel yu chuncha lhakapuꞌanan tacha yu aniy lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ex ni lapanakni yu ixjamalaqachakanta tachinchoqochal laqa chaqaꞌ. Ancha tatemal ni oqxtamati yu ixtaqanꞌay, va palay ixjunchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ex astan ni Jesús al taun putaulan yu junkan Naín. Vachuꞌ ixtatꞌaꞌanta ixtꞌaltanan kun lhuvaj lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tejkan va ukstsꞌuniycha kachaꞌal ni laka putaulan, va laqtsꞌil ni lhaꞌankanta qayntaun janiniꞌ ixmaknuka. Vamun yuꞌ istsꞌal ixjunita ni ixnati. Yucha va tiyau ixjunita. Qaynlhuvaj lapanakni yu ancha machaqan va ixtatꞌaꞌanta ni anchanu tiyau. ");
INSERT INTO tptNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tejkan laqtsꞌil ni Jalhachimoꞌonu Jesús ex ayaj mapaynil ni tiyau, va junil: —Jantu kꞌaꞌalhu. ");
INSERT INTO tptNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ex ni Jesús talakanunil ni pꞌaqlati, makasal. Yu xalhaꞌanan, yuꞌuncha ancha saq tatayal. Ex ni Jesús junil ni janiniꞌ: —Tsꞌal, kitꞌin kunan, kaꞌostꞌaꞌulchꞌoꞌocha. ");
INSERT INTO tptNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ex ni janiniꞌ va niman ostaulal, aqtaychoqolcha jalaktꞌachiviniy ni lapanakni. Ni Jesús maqxtaqnichoqolcha ni ixnati. ");
INSERT INTO tptNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tejkan chuncha talaqtsꞌintayal ni lapanakni tus tachun tatalhanal, ex chuncha taꞌaqtaynilcha ay tamakay ni Dios va tanajun: —Taun ay lapanaki yu laqputeꞌey ixchivinti Dios alin kun kijnankꞌan. Vachu tanaul: —Chavaycha Dios ixchin para kalaktꞌatiꞌukxuntayal ixlapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Talakachux ni xaꞌestado Judea takꞌatsaꞌol tachun yu ixmakaycha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Vachuꞌ ixtꞌaltanan ni Juan takꞌatsal tacha ixmakay ni Jesús. Ex talaqputeꞌenichoqolcha ni Juan. Ex chuncha ni Juan lakjuntaꞌil qayntꞌuy ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jamalaqachal lhasakminin ni Jesús incha laqsavalcha yucha ni Cristo yu ixtanajun kaminaꞌ u incha vananaj katapakxanꞌil aqayntaun. ");
INSERT INTO tptNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ex chuncha yu ixtamalaqachan ni Juan, anchanu pumatꞌuy lapanakni talakanunil ni Jesús, tajunil: —Ni Juan yu jamaqchajꞌavanaꞌ, yucha kintamalaqachan lhisakminin incha uxintꞌi laqsavalcha ni Cristo kꞌatꞌi yu ixtanajun kaminaꞌ u incha kakpakxanau aqayntaun. ");
INSERT INTO tptNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ni anchanu panchꞌix tejkan tachaꞌal, ni Jesús palay makal lhuvaj taqanꞌanin ali yu ixtalhitꞌajun jantu ox espíritus. Vachu jalakmalakavanichoqol lhuvaj lapanakni yu laꞌachꞌixin ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ex ni Jesús va lakjunil: —Kꞌapꞌinchꞌoꞌotꞌikcha, kꞌaꞌunapitik ni Juan yu xalaqtsꞌinatꞌikcha kun yu xaꞌasmaktꞌatꞌikcha. Talakavananchoqoycha yu laꞌachꞌixin, yu lakchꞌanltꞌul taltananchoqoycha, yu lakapuchꞌinin palaycha tajunchoqoy, yu aqatapan taqasmaknanchoqoycha, yu janinin takujchoqoycha. Vachuꞌ yu kilpatanin jatꞌaunkancha jalaqputeꞌenika ni ox chivinti yu masuy tacha lay katapulaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ox kaxajtachal ixjatsukunti ni lapanaki yu jantu aqtaun kimakajun. ");
INSERT INTO tptNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tejkan taꞌanchoqolcha ixtamalaqachan ni Juan, ex ni Jesús aqtaylcha lhichiviniy ni Juan, va lakjunil ni lapanakni: —Tejkan kꞌilaqtsꞌintꞌik ni Juan lakakꞌavin, ¿tisuncha ixpꞌintꞌatꞌik laqtsꞌinin? ¿Va qaltaun akltiyati yu lajkꞌalhata ni un? ");
INSERT INTO tptNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Suncha kꞌilaqtsꞌintꞌik? ¿Va qayntaun lapanaki yu ayaj kꞌusi lakatayal? Pero yu talakatayay kun lajkꞌus laqchꞌiti va tavilanal la ixchaqakꞌan maqalinin. ");
INSERT INTO tptNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Ex suncha ixpꞌintꞌatꞌik laqtsꞌinin? ¿Va qayntaun yu laqputeꞌey ixchivinti Dios? Laqsaval klajunau chuncha junita pero apalay ay junita xajantu yu alati yu ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ni Juan va yu lhitsꞌoqkanta la ixchivinti Dios taꞌan najun: Kitꞌin kakmalaqachayaꞌ qayntaun yu kapꞌulaniyan, kalaꞌoximanin ni lakatin taꞌan kꞌapꞌupꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Klajunau ni tachun lapanaki yu maqlaqavanal xanati jantu matichun kaꞌalil yu laqputeꞌey ixchivinti Dios yu apalay ay kaval. Vamun yuꞌ ay ni Juan. Pero yu apalay lakatꞌuniy lapanaki yu Dios lhichimoꞌoy yucha apalay ay xajantu ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tejkan chuncha taqasmaklhi tachun ni lapanakni ali yu tachꞌinin impuestos, va tanaul ni Dios vas makay. Yuꞌuncha va ixlaqmaqchajꞌavatacha ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas taꞌakchꞌintamal yu ox jatsukunti yu Dios ixlaqxtaqniputun. Xlhiyucha jantu katanaul ni Juan kamaꞌaqchajꞌaval. ");
INSERT INTO tptNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ex naul ni Jesús: —¿Tas tajunitacha ni lapanakni yu chavay tatꞌajun? ¿Tas tatasuycha? ");
INSERT INTO tptNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yuꞌuncha va tacha sꞌatꞌan yu taqamanan laklhitamau yu talatꞌasaniy, talajuniy: “Klasqolniu yu maꞌachajunuꞌ jasanti, pero jantu kꞌatꞌininatꞌik. Klamilpaniu milpati yu mamaqanixvanan pero jantu kꞌaꞌalhuntꞌik.” ");
INSERT INTO tptNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Va kilachil ni Juan yu jamaqchajꞌavanaꞌ. Yucha jantu ixꞌuy pan vachuꞌ jantu ixꞌotꞌa xaxkan uva. Xlhiyucha naunatꞌik va lhitꞌajun taun aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ex chuncha kminta kitꞌin yu Sasꞌatꞌa Lapanaki, kvajin, kꞌoqnun. Chavaycha naunatꞌik ni kitꞌin javaynꞌoj y puqalꞌoqnuꞌ. Naunatꞌik va klaktꞌatiꞌukxuntayay yu tachꞌinin impuestos ali alati yu tamaqtaqalhinin. ");
INSERT INTO tptNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero tachun yu lhixajyachal la ixjatapastakꞌati ni Dios yucha masuy ni va ox ixjatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ex qayntaun fariseo lhijunil ni Jesús ni katꞌavayl. Ex chuncha ni Jesús al la ixchaqaꞌ. Ancha tanuchal, va taulal laka mesa. ");
INSERT INTO tptNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ex chuncha ni anchanuꞌ putaulan ixꞌalin qayntaun maqtaqalhiniꞌ xanati. Yucha kꞌatsal ni mil vayaꞌ ni Jesús la ixchaqaꞌ ni fariseo. Ex yucha vachuꞌ chinchal, va lhiminta taun lameta, tajun yu ox sꞌejenꞌe. ");
INSERT INTO tptNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aqtayl qalhun y ancha talakanunil ixchꞌajaꞌ ni Jesús. Aqtaynil chꞌanchaꞌay kun ixlaqpuqalhuti. Ex aqtayl xakanichoqoy kun ixꞌaji para kaxixchoqol ixchꞌajaꞌ ni Jesús. Tejkan maxixinichoqol ex kiltastuknil ixchꞌaja ni Jesús y mukꞌanil yu sꞌejenꞌe yu ixlhiminta laka lameta. ");
INSERT INTO tptNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tejkan laqtsꞌil ni fariseo yu lhijunil ni Jesús lakvayti, va pastaklhi xꞌaman: “Incha laqsaval ni aniy lapanaki kaval yu laqputeꞌey ixchivinti Dios, ka kamispal suncha xanati junita. Va qayntaun xanati yu maqtaqalhiniꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ex ni Jesús junil: —Simón, kitꞌin kunputunan taun chivinti. Ex ni fariseo naul: —Chun, jamalaniniꞌ, kꞌiꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ex najun ni Jesús: —Qayntꞌuy lapanakni ixtalhaaniy tumin aqayntaun. Qayntaun ixlhaaniy laqakis ciento xatumin plata, yu aqayntaun ixlhaaniy pakltaun ciento xatumin plata. ");
INSERT INTO tptNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ixlaꞌatꞌuykꞌan jantucha lay ixtamapalchoqoy ni tumin. Ex ni lapanaki yu machꞌixtaqlhi va laqmaqantaulnilcha yu ixlhaanintikꞌan. Chavaycha klhisakmiyancha, ¿tas ayucha apalay lhipaxkajlaqtsꞌil ni lapanaki yu machꞌixtaqlhi? ");
INSERT INTO tptNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ex yu Simón qaltayanal: —Kitꞌin knajun ni lapanaki yu apalay laqlhuu maqantaulnikal va yu apalay paxkajlaqtsꞌil. Ex ni Jesús naul: —Chun, laqsaval yu nau. ");
INSERT INTO tptNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ex ni Jesús laqtsꞌil ni xanati, va najun, va junkan ni Simón: —¿Laqtsꞌin ni aniy xanati? Kitꞌin tejkan iktanuchil la minchaqaꞌ jantu kꞌixtꞌaqnin xkan para kaklhichaꞌal kinchꞌajaꞌ. Pero yu aniy xanati kinchaꞌanil kinchꞌajaꞌ kun ixlaqpuqalhuti y maxixichoqol kun ixꞌaji. ");
INSERT INTO tptNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Uxintꞌi tejkan iktanuchil la minchaqaꞌ jantu kꞌimastꞌakꞌatꞌi kun taun lakiltastukni pero ni yucha tejkan chilcha tus chavaycha jantu makajun kiltastukꞌa kinchꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jantu kꞌilhilakpꞌaxapꞌa ni aceite la kiꞌaqtsul. Pero ni yucha kilhixapanil yu ox sꞌejenꞌe la kinchꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Xlhiyucha laqsaval kunan yu lhuvaj ixtalaqalhin malaqmixiniꞌokal, yucha va ayaj lhipaxkajlaqtsꞌin pero yu tsꞌuniy ixtalaqalhin malaqmixiniꞌokal, yucha va tsꞌuniy lhipaxkajlaqtsꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ex naul, va junkal ni xanati: —Va ikmalaqmixiniꞌojon mintalaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ex yu alati lapanakni yu chꞌantaun ixtatꞌavilanal laka mesa, aqtaylcha talalhisakmiy, talajuniy: —¿Tas ayucha ni aniy lapanaki yu malaqmixiy talaqalhin? ");
INSERT INTO tptNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ex ni Jesús junil ni xanati: —Chavay kꞌilhakꞌapꞌupꞌicha, xlhiyucha mintalaqalhin laqtꞌaxtꞌucha. Kꞌapꞌinchꞌoꞌocha oxamaktaun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Taval ni Jesús ixtiꞌukxuyachal tachun ni lajꞌay putaulanaxna kun ni lakstꞌuniy putaulanaxna. Ixjalaqputeꞌeniy ni lapanakni tacha lhachimoꞌonun ni Dios. Yu ixpumakautꞌuykꞌan yu ixtatꞌaltanan, yuꞌuncha vachu ancha ixtatꞌatiꞌukxuyanal. ");
INSERT INTO tptNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Vachu ixtatꞌatiꞌukxuyanal xanatin yu palay tajunchoqol ixtaqanꞌatikꞌan vachuꞌ yu lakmaxtunikal aqmoqxnun. Qayntaun ixjunkan María yu machaqaꞌ Maqdala, yu maxtunikal laqatujun aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Vachuꞌ ixtꞌaꞌanta Juana yu ixanati Chuza yu xaꞌukxtin ixꞌoqxtamatin Herodes. Vachu Susana ali qaynlhuu xanatin yu ixtaꞌaqtayjuy kun ixlhitapatskꞌan ni Jesús ali ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ixtataxtuy lhuvaj lapanakni taun taun putaulan, ixtalaqmin ni Jesús. Tejkan tataqxtoqlhicha lakjunil taun chivinti yu xtaꞌa jatapastakꞌati, va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Qayntaun lapanaki al maman ni ixtꞌin. Tejkan tꞌajun maman, lati xatꞌin taꞌeltajul lakatin. Ancha vamun akchꞌintamakal y yu xatsꞌoꞌon laktꞌiyan va tataꞌeltajul unan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Alati xatꞌin tamal laka chiyux. Ancha pꞌul ni tꞌin pero yu tꞌun jantu jachꞌamal kaval, ex niman lakxixꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Alati xatꞌin tamachal laka jaltukunan. Ancha vachu pꞌul pero chꞌantaun tꞌapꞌul ni jaltukun, va maqatanul, talakxixtanulcha yu xatꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Alati tamal taꞌan ox tꞌun. Ancha pꞌul, ox aynlhi, va xtaqlhi ox jaxqanti, taun ciento por laqatamin. Tejkan chuncha naul ni Jesús ex pꞌas naul: —Incha alin mimpaqasmakkꞌan, ex kaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ex ixtꞌaltanan ni Jesús talhisakmil sunchacha naunputunta ni anu chivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ni Jesús lakjunil: —Uxiknankꞌan Dios tamasuniyan tacha lhachimoꞌonun yu jantu takꞌatsay alati lapanakni. Pero yu alati lapanakni klakpumalaniy chivinti yu xtaꞌa jatapastakꞌati. Ex chuncha mas talaqtsꞌin yu kmakay, va tacha jantu katamispal, mas taqasmatꞌacha kinchivinti, jantu tamalaqasiy. ");
INSERT INTO tptNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Yu aniy chivinti yu xtaꞌa jatapastakꞌati va inchine naunputun. Yu xatꞌin yucha va ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ni tꞌin yu tatamal lakatin, yucha va tacha ni lapanakni yu taqasmatꞌacha ixchivinti ni Dios pero yu aqmoqxnuꞌ va niman chinachil para kalakmaxtunichoqol. Va najun jantu katalhakapuꞌal va para jantu katalaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ni tꞌin yu tatamal laka chiyux, yucha va tacha lapanakni yu taqasmatꞌacha ixchivinti Dios, ex talhakapuꞌancha kun achati. Pero ni chivinti jantu tanuy ox la ixjalhanutkꞌan. Ex tejkan tatapasay tsꞌuniy maqanlqajnati va tataꞌosuspꞌikchoqoycha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ni tꞌin yu tatamal laka jaltukunan yucha va tacha ni lapanakni yu taqasmatꞌacha ixchivinti Dios pero astan tamakauntijlay. Ayaj alin yu tapastakꞌuy, vachu tamaqamay ixmaqalitkꞌan kun xaꞌachati aniy lakamunukpaꞌ. Ex jantucha ox lhixajyachal ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ni tꞌin yu tamal ox lakatꞌun yucha va tacha ni lapanakni yu taqasmaktayl ixchivinti Dios y tamaꞌay la ixjalhanutkꞌan kun ox jatapastakꞌati. Vas tataylhaꞌan kun ni chivinti yu taqasmatꞌacha. Chuncha tamaqantaulay y ox lhixajyachal ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Jantu matichun mamaqtayay taun maklku para kamaqatanul laqa aqchoq u para kamanul ixtaꞌapuꞌ ni saqati. Va mukꞌay talman para lay katalaqtsꞌil maklku yu tatanuy ni laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Vachu mas alin tuꞌuchun yu jantu ox malaqasikan chavay, astan la ox kamalaqasikanaꞌ. Mas vamun lati takꞌatsay chavay, astan tachun katakꞌatsayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chavaycha la ox kilaqasmakniu. Klajunau yu lhitꞌajuncha jatapastakꞌati yucha apalay lhuu kaxtaqnikanaꞌ. Yu jantu kalhitsukul, mas va yu lakatsꞌuniy yu lhilay lhitꞌajun, yucha kamaxtunichoqokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ex chuncha ni ixnati ali ixtꞌalaqaunin ni Jesús tachinchal taꞌan ixvil. Ixtalaqtsꞌinputun pero jantu lay katalakanunil, va lhuvaj lapanakni ixtaꞌalinta. ");
INSERT INTO tptNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ex va junkal ni Jesús: —Minati kun mintꞌalaqaunin tayanal maqspaꞌ, tatꞌachivinputunan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero ni Jesús va naul: —Yu laqsaval kinati ali yu laqsaval ketꞌalaqaunin tajunita va yu taqasmatꞌa ixchivinti Dios y tamakay tacha najun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Taun julchan ni Jesús tatajul laka barco kun ixtꞌaltanan, va lakjunil: —Kaꞌaucha tus yu alakataun ixkilpaꞌ lakxkan. Ex taꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tejkan tatꞌajuncha tapasanan ni lakxkan, va ltatal ni Jesús. Taval aqtaylcha pꞌas unilay, ex ni barco aqtaylcha tajuyachal ni xkan. Taval va laycha kaꞌaqtsamal. Va tatalhanancha katalaqtsꞌanqal ni barco. ");
INSERT INTO tptNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ex taꞌal maqloꞌonun ni Jesús, va tajunil: —Jamalaniniꞌ, jamalaniniꞌ, aniy tꞌaunaucha talaqtsꞌanqanin. Ex ni Jesús ostaulal, aqtayl laqꞌaymay ni un kun xaꞌoqxpuputi yu ixꞌukxlaklata ni xkan. Ex chuncha va tus tachun talakataulꞌochoqol, tacha aqtsꞌiyaj ox junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ex ni Jesús lakjunil ixtꞌaltanan: —¿Valiꞌiycha jantu kilalhakapuꞌau? Pero yuꞌuncha ayaj tatalhanancha por yu makal ni Jesús. Vamuncha saq tataulal, va talalhisakmiy siya yuꞌuncha: —¿Tas ayucha ni aniy lapanaki? Lhichimoꞌoy ni xkan kun ni un y taqalasmatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ex chuncha tachaꞌal ni lakatꞌun Gadara yu ixlhitukuktachal ni lakxkan Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tejkan taxtul ni Jesús ni anchanu lakatꞌun, talakanunil qayntaun lapanaki yu machaqaꞌ ni anchanu putaulan. Ni anchanu lapanaki ayaj maqancha ixchꞌapata taun aqmoqxnuꞌ. Jantucha ixꞌulay ixlaqchꞌiti. Vachu jantucha ixtꞌajun laqa chaqaꞌ, vamuncha ni kampusantu ixtꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tejkan laqtsꞌil ni Jesús, va taꞌaqtsoqoqtanil la ixtalakaꞌukxpuꞌ. Va la pꞌas tꞌasal, va junil: —¿Suncha kꞌatsꞌaycha kun kitꞌin? Jesús Sasꞌatꞌa kꞌatꞌi ni Dios yu vilchal laktꞌiyan. Iktapayniniyan jantucha apalay kꞌilhimaqchꞌapꞌu. ");
INSERT INTO tptNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ni Jesús ixtꞌajuncha tꞌachivin ni aqmoqxnuꞌ para kamakaunchoqolcha ni anchanu lapanaki. Ni aqmoqxnuꞌ aqlhuvaj ixchꞌapay. Yu ixtalhistakꞌa anchanuꞌ lapanaki, yuꞌuncha ixtamaqchꞌiy, ixtachꞌanchꞌiy kun cadenas pero va niman ixlajꞌexꞌojoy. Ex ni aqmoqxnuꞌ ixlhaꞌanchoqoycha aaqtaun lakakꞌavinan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ex ni Jesús lhisakmil: —¿Tisuncha unkꞌancha? Ex va junil: —Kitꞌin ijkunkan Pumalhuu. Lhuvaj aqmoqxnun ixtachꞌapata anchanuꞌ lapanaki, xlhiyucha chuncha naul. ");
INSERT INTO tptNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ex ni aqmoqxnun tatapayninil ni Jesús para jantu kalaqmalaqachal taꞌan pulman. ");
INSERT INTO tptNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ni anchanu aspajun ixtatꞌajun exvaynin lhuvaj pꞌaxnin. Ni anchanu aqmoqxnun tatapayninil katalaqtanul ni anchanu pꞌaxnin. Ex jaxtaqnil lakatin. ");
INSERT INTO tptNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ex ni aqmoqxnun tamakaulcha ni anchanu lapanaki. Va talaqtanulcha ni pꞌaxnin. Ex ni pꞌaxnin va taputakyaulcha taꞌan qaltalman, va tatajuchal yu lakxkan, va taꞌakskajꞌuꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ex tejkan chuncha talaqtsꞌil yu xalhistaknan pꞌaxnin, ayaj tatalhanal. Tatakyaul laqputeꞌenin yu ay laka putaulan y vachu ixlhimaqspaꞌ ni putaulan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ex ni lapanakni taꞌal laqtsꞌinin yu tapasal. Tejkan tachaꞌal taꞌan vil ni Jesús ancha vachuꞌ vil ni lapanaki yu tamakaunchoqol ni aqmoqxnun. Yucha vilnil la ixchꞌajaꞌ ni Jesús, ulachoqotacha ixlaqchꞌiti, va ox jalakpastaknan. Tejkan chuncha talaqtsꞌil, va tatalhanal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yu ixtalaqtsꞌinta yu tapasalcha, yuꞌuncha talaqputeꞌel tacha val tejkan palay junchoqol ni lapanaki yu ixlhitꞌajun aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ex chuncha tachun ni lapanakni yu ancha lakatꞌun Gadara tatapayninil ni Jesús para kaꞌanchoqolcha. Va ayaj tatalhaunil. Ex ni Jesús tanuchoqolcha laka barco, va minchoqochalcha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ni lapanaki yu tamakaunchoqol ni aqmoqxnun, va tapayninil ni Jesús para vachu katꞌaꞌal, pero ni Jesús va junil: ");
INSERT INTO tptNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Kꞌapꞌinchꞌoꞌochiycha la minchaqaꞌ, ancha kꞌalaqpꞌutꞌeꞌeyeꞌe milapanakni tachun yu makanin ni Dios. Ex ni lapanaki anchoqolcha, aqtaylcha jalaqputeꞌeniy ni lapanakni talakachux la ixputaulan yu makanil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tejkan ni Jesús takukchoqochil ixlhiꞌaniy laka xkan, tachun ni lapanakni la ox talaqaꞌil, va ixtapakxanꞌita. ");
INSERT INTO tptNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ex chinchal qayntaun lapanaki yu ixjunkan Jairo, ixlhachimoꞌonun laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. Talakaputatamal laka tꞌun taꞌan ixyal ni Jesús, va tapayninil kaꞌal la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ixlhitꞌajun vamun qayntaun istsiꞌi, va laqakautꞌuycha ixjachꞌitin ixlhitꞌajun. Ixchꞌapata taun taqanꞌati, va laycha kanil. Ex tejkan ixꞌanta ni Jesús, ixtatꞌaꞌanta lhuvaj lapanakni va tus lapatsꞌiuksni ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ancha ixꞌalin qayntaun xanati jantu ixlakaxixta ni jakꞌalnan y va laqakautꞌuycha jachꞌitin ixtꞌajun maqanlqajnaꞌ. Va jalaqkilaꞌol ni jakꞌuchꞌunun tus va mamiꞌonil yu ixlhitꞌajun ixlhitapatsa y va nisin palay kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ex ni yucha talakanunil ni Jesús la ixlhistapuꞌ, va piklanil ixkiltuꞌ ixlaqchꞌiti. Ex tejkan chuncha makal va niman tayajval ni jakꞌalnan. ");
INSERT INTO tptNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ex ni Jesús lhasakminil: —¿Tas ayucha ixkimpiklaycha? Jantu matichun kalhitaulnil. Ni Pedro kun ixtꞌaltanankꞌan tanaul: —Jamalaniniꞌ, ni lapanakni tus talapatsꞌiuksta y talasamaꞌan va toꞌoxtaycha lata. ¿Valiꞌiycha lhasakminin taꞌayucha piklayancha? ");
INSERT INTO tptNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero ni Jesús va naul: —Alin taꞌayucha ni ixkimpiklay, ni kitꞌin kꞌukskꞌatsal ni kmaꞌayajnichoqol qayntaun ixtaqanꞌati la kintapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ni xanati tejkan kꞌatsal jantu lay vak ixjun, va talhanal tus xkapꞌikninta, talakanunil ni Jesús, talakaputatamanil. Va junil la ixtalakaꞌukxpukꞌan tachun ni lapanakni valiꞌiycha piklal ni Jesús y tacha pupalaycha junchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ex ni Jesús junil: —Kintsiꞌi kꞌatꞌi, va kꞌilhakꞌapꞌupꞌin xlhiyucha palaycha xaꞌunchꞌoꞌoy. Kꞌapꞌinchꞌoꞌocha oxamaktaun. ");
INSERT INTO tptNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ni Jesús vananaj ixtaylhaꞌanta ixchivinti tejkan chinchal qayntaun yu minchal la ixchaqaꞌ Jairo. Va naul, va junkal ni Jairo: —Mintsiꞌi va nilcha. Jantucha apalay kꞌamaꞌanchꞌapꞌu ni jamalaniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero tejkan qasmaklhi ni Jesús, va junil ni Jairo: —Jantu katꞌalhan. Vamun kꞌalhakꞌapꞌupꞌi, ex mintsiꞌi palay kunchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tejkan chaꞌal laqa chaqaꞌ, ni Jesús jantu kaxtaqlhi lakatin matichun katatanuchal, vamun ni Pedro ali Jacobo ali Juan kun ixpay ali ixnati ni jatsiꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tachun yu alati lapanakni ixtatꞌajun laqalhunin ixtalhimaqatsꞌanqananta ni jatsiꞌi. Pero ni Jesús lakjunil: —Jantu kꞌalajꞌalhuntꞌik. Ni jatsiꞌi jantu kanil, va ltatay. ");
INSERT INTO tptNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Vamun talhiꞌachan tejkan chuncha naul ni Jesús, ixtakꞌatsay ni ixnitacha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ex ni Jesús chꞌapanil ixmakaꞌ ni jatsiꞌi, la pꞌas xaqalal, va junil: —Jatsiꞌi, kitꞌin kunan kaꞌostꞌaꞌulcha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ex chuncha ni jatsiꞌi kujchoqolcha mas ixnitacha, va niman ostaulchoqol. Ni Jesús laklhijunil ixpayan katavavachoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ixpayan va tus saq taval. Ex ni Jesús lakjunil jantu matichun katalaqputeꞌenil tacha yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ni Jesús jamaqxtoqlhi ixpumakautꞌuykꞌan ixtꞌaltanan. Jalaqxtaqnil lhachimoꞌon kun tapꞌasta para lay katalakmaxtunil tachun aqmoqxnun yu tachꞌapay ni lapanakni. Vachuꞌ katakꞌuchꞌul tachun yu taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jamalaqachal para katalaqputeꞌenil ni lapanakni tacha lhachimoꞌonun ni Dios, vachu para katalajkꞌuchꞌul taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Va jalakjunil: —Jantu tuꞌuchun kalhipꞌintꞌik para milakatinkꞌan, jantu palik, jantu bolsa, jantu tiyuti, jantu tumin, jantu aqxtaun laqchꞌiti para milamapaxankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mas va taꞌayucha chaqaꞌ kachꞌipꞌintꞌik ancha katꞌaulapitikcha tus katꞌaxtꞌuchꞌoꞌoyapitik ni anchanu putaulan. ");
INSERT INTO tptNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Taꞌan jantu kꞌalaꞌaꞌikꞌanapitik, niman katꞌaxtꞌuchꞌoꞌoyapitik ni anchanu putaulan. Ancha kachꞌankꞌalhakꞌanapitik ni pꞌoqxni la minchꞌajakꞌan. Chuncha katapukꞌatsayaꞌ ni jantu ox yu tamakanin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ex chuncha taꞌalcha laka putaulanin, ixtalaqputeꞌey tacha lay katapulaqtaxtul. Talakachux ixtalajkꞌuchꞌulhaꞌanta ni taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ni gobernador Herodes kꞌatsal tachun ni lhitapatsa yu ixmakay ni Jesús, ex ayaj pastakꞌul. Lati ixtanajun ni Jesús va Juan yu jamaqchajꞌavanaꞌ, ixtanajun va kujchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Alati ixtanajun ni Jesús va Elías yu maqancha ixlaqputeꞌey ixchivinti Dios. Alati ixtanajun va aqayntaun yu ixlaqputeꞌey ixchivinti Dios maqancha yu kujchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero ni Herodes va naul: —Ni Juan kitꞌin klhinaul ixchaqxpꞌuxnika ixꞌaqtsul. ¿Ex taꞌayucha kavalcha aniy lapanaki yu ayaj talhichiviniy lhuu axtoqnuꞌ? Ex ayaj ixlaqtsꞌinputuntacha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yu ixjamalaqachata ni Jesús taminchoqol, va talaqputeꞌenil yu tamakalcha. Ex ni Jesús laklhaꞌanchoqol ixlaqꞌamankꞌan laka putaulan Betsaida. ");
INSERT INTO tptNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero tejkan takꞌatsal ni lapanakni, yuꞌuncha va tatixkaulhaꞌal. Ex ni Jesús jalaqaꞌil kun achati. Va jalhixaqalal tacha lhachimoꞌonun ni Dios y jalajkꞌuchꞌul yu taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tejkan va laycha katoqoxal, yu ixpumakautꞌuykꞌan ixtꞌaltanan talaqꞌal ni Jesús, va tajunil: —Kꞌalakmastꞌakꞌachꞌoꞌocha ni lapanakni para kataꞌal jastaknan y katalakxkaul ixvaytkꞌan laka putaulanin taꞌan ukstsꞌuniy kaval. Aniy taꞌan alintau va lakakꞌavinan. Jantu tuꞌuchun alin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ex ni Jesús va jalakjunil: —Uxiknankꞌan kꞌalaqxtꞌaqnitꞌik ixvaytkꞌan. Ex tanaul: —Jantu kaklhitsukuu ni vayti. Klhitꞌaunau vamun aqskis pan kun aqxtꞌuy jatanti. ¿Va naꞌun kajkꞌau inin vayti para katalaqchaꞌanꞌol ixvaytkꞌan tachun ni aniy lapanakni? ");
INSERT INTO tptNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ni joꞌakna por tachun ixtaꞌalinta va laqakis mil. Ex ni Jesús lakjunil ixtꞌaltanan: —Kalakꞌunitꞌik ni lapanakni katataulal por pakltamin ciento lakatamin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chuncha tamakal, ni lapanakni tus tachun tataulꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ex ni Jesús chꞌapal ni aqskis pan kun ni aqxtꞌuy jatanti. Talaqstꞌal laktꞌiyan, va xtaqnil lhimalaqpuchuncha ni Dios. Aqtaylcha laqcheꞌey ex jaxtaqlhaꞌanilcha ixtꞌaltanan. Yu ixtꞌaltanan taꞌaqtaylcha talakmapitsiniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chuncha tachun ni lapanakni tavaynꞌol, tus ox taꞌotsal. Ex yu ixtꞌaltanan ni Jesús tapusakchoqol yu xajchal. Va laqakautꞌuy canasta yu xajchal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Taun julchan ni Jesús va ixtꞌajun skꞌiniꞌ Dios xꞌaman. Yu ixtꞌaltanan vachu ancha ixtatꞌaꞌalinta. Ex ni Jesús va laklhisakmil: —¿Tas tanajuncha ni lapanakni? ¿Taꞌayucha kintalhilaycha ni kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ex yuꞌuncha taqaltayl: —Lati tanajun va Juan kꞌatꞌi yu jamaqchajꞌavanaꞌ. Alati tanajun va Elías kꞌatꞌi. Alati tanajun ni uxintꞌi va aqayntaun yu kujchoqotacha yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ex naul ni Jesús: —Chavay klalhisakmiyau yu uxiknankꞌan, ¿tas ayucha kilalhilayaucha ni kitꞌin? Ex yu Pedro va junil: —Uxintꞌi ni Cristo kꞌatꞌi yu ixtanajun kamalaqachayaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús jalakachivitijlal ixtꞌaltanan para jantu matichun katajunil ni va yu Cristo junita. ");
INSERT INTO tptNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ex lakjunil ni Jesús: —Ni kitꞌin yu kval Sasꞌatꞌa Lapanaki va ayaj kakmaqanlqajnanaꞌ. Ni lajꞌay lapanakni ali yu xaꞌukxtinin kuras ali yu tamasuy kilhachimoꞌonkꞌan, yuꞌuncha kintalaktanchaniyaꞌ. Va kintamaqniyaꞌ pero yu laꞌatꞌutunuꞌ julchan kajkujchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ex ni Jesús lakjunil tachun ni lapanakni: —Incha matichun kintꞌatiꞌukxuntayaputun, yucha jantucha lay makay yu makaputun. Kaval tacha lhilhiy kalhaꞌal ixkurus, ex chuncha lay kintꞌatiꞌukxuntayalcha. ");
INSERT INTO tptNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Chavay ni lapanaki yu ayaj lhitsukuputun ixjatsukunti va kamaqatsꞌanqayaꞌ. Yu kamaqatsꞌanqayaꞌ ixjatsukunti por kitꞌin, yucha kalhitsukuchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Tisuncha lhajaycha qayntaun lapanaki incha kalhitsukuꞌol tachun yu alin lakamunukpaꞌ pero va maqatsꞌanqay ixjatsukunti? ");
INSERT INTO tptNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Incha matichun kilhimaxaniy ni kitꞌin kun kinchivinti, ex kitꞌin yu kval Sasꞌatꞌa Lapanaki, vachuꞌ kaklhimaxaniyaꞌ ni yucha, tejkan kakminchoqoyaꞌ kun kintapꞌasta vachu kun ixtapꞌasta ni kimPay kun ixmayulnin. ");
INSERT INTO tptNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Laqsaval klajunau ni alin lati yu chavay aniy tatꞌajun yu jantu kataniyaꞌ tus katalaqtsꞌinꞌelayaꞌ ni Dios lhachimoꞌonun. ");
INSERT INTO tptNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tejkan paqtsajin val, ni Jesús al skꞌiniꞌ Dios laka aspajun. Yu Pedro ali Juan ali Jacobo vachu jalaklhaankal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tejkan Jesús ixtꞌajun skꞌiniꞌ Dios va tapaxal ixꞌukxpu, vachu ixlaqchꞌiti tus ayaj yaqaq val, tus kꞌuliksnaꞌ val. ");
INSERT INTO tptNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ex tatꞌatasul pumatꞌuy xapaynin, ixtatꞌachiviniy ni Jesús. Ni yuꞌuncha va Moisés ali Elías yu la maqancha ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yuꞌuncha tus ixlaqmalaqachoqoxnukanta kun yu kꞌuliksnaꞌ jatunkunaꞌ. Ixtatꞌajun lhichivinin tejkan kaniyaꞌ ni Jesús, yu katapasayaꞌ laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ni Pedro kun ixtꞌaltanan va ayaj ixtachꞌapata ltatati. Talaqtsꞌinil tacha ixjunita ixꞌoxixtu ni Jesús y talaqtsꞌil ni pumatꞌuy lapanakni yu ixlaktꞌatayal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tejkan ni Moisés ali Elías ixtatꞌaunchoqoycha makaunan ni Jesús, ex ni Pedro va junil ni Jesús: —Jamalaniniꞌ, la ox kꞌalintau aniy. Ka la ox kakmakau aqatꞌutu moqltaꞌ. Aqataun para uxintꞌi, aqataun para Moisés vachuꞌ aqataun para Elías. ");
INSERT INTO tptNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tejkan chuncha ixchiviniy, chil laqataun taputsꞌi, va laqꞌoqxtꞌaqyaukal. Va ayaj tatalhanal tejkan ixtayanal ixpulaknacha laka taputsꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Va chivinkal laka taputsꞌi: —Yucha aniy kesꞌatꞌa yu kꞌachaniy. Ox kꞌaꞌalasmaktꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tejkan miꞌol ni chivinti, ni Jesús tasuchoqolcha, va xꞌamancha. Yuꞌuncha tus saq taval y paqlhuucha val jantu matichun katajunil yu ixtalaqtsꞌinta. ");
INSERT INTO tptNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ataun julchan val, va tataꞌeltajul ni aspajun. Ancha qaynlhuvaj lapanakni tapaxtoqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ixꞌalinta qayntaun lapanaki yu tꞌasal, va junil: —Jamalaniniꞌ, ktapayniniyan kaꞌaqtꞌayꞌutꞌi kintsꞌal, vamun yuꞌ klhitꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Va chꞌapay taun jantu ox espíritu, niman maqantꞌasay, maxkapꞌikniy tus maqalpupuy, va ayaj malakaxkayay y jantu makaunputun. ");
INSERT INTO tptNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Klaktapayninitacha katamaxtul ni jantu ox espíritu ni mintꞌaltanan pero jantu kalal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ex ni Jesús qaltayanal, va naul: —¡Yu uxiknan jantu lay lhakꞌapꞌupꞌinatꞌik, va jalaktuꞌunun untꞌatꞌik! ¿Tus tavanancha kaktamakaunaꞌ kun uxiknan? ¿Tus tavanancha kaklatayaniyaucha? Kꞌalhitꞌantꞌikcha aniy ni mintsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tejkan ni tsꞌal talakanunil ni Jesús ni aqmoqxnuꞌ va niman tanqalhul, va maxkapꞌiknil. Ex ni Jesús laqꞌaymal ni aqmoqxnuꞌ, va palay makal ni tsꞌal, va maqxtaqnichoqol ni ixpay. ");
INSERT INTO tptNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ex tus vak takꞌatsal tachun ni lapanakni por ixꞌayaxtu Dios. Tejkan chuncha tus vak ixtakꞌatsan ni lapanakni por yu makal ni Jesús, va lakjunil ixtꞌaltanan: ");
INSERT INTO tptNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Oxi kaꞌasmaktꞌikcha ni inchine, jantu aqtaun kakꞌauktꞌik. Kitꞌin yu kval Sasꞌatꞌa Lapanaki va laycha kakmaqxtaqkal la ixtamakakꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ixtꞌaltanan jantu katamalaqasil, jantu kalaqxtaqnikal lakatin para katamalaqasil. Va tatalhanal xlhiyucha jantu katalhisakmil. ");
INSERT INTO tptNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ixtꞌaltanan ixtalhilakchiviniy taꞌayucha yu apalay ay ixjunita siya yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ni Jesús kꞌatsal yu ixtapastakꞌa. Ex chꞌapal qayntaun jasꞌatꞌa va tamaqayaul, ");
INSERT INTO tptNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jalakjunil: —Yu laqaꞌiy ni aniy jasꞌatꞌa por chuncha klhinajun ni kitꞌin, yucha vachu kilaqaꞌiy ni kitꞌin. Yu kilaqaꞌiy ni kitꞌin vachu laqaꞌiy yu kimalaqachata. Yu lakatꞌuniy kꞌatsꞌan yucha va yu apalay ay. ");
INSERT INTO tptNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ex chuncha ni Juan va naul: —Jamalaniniꞌ, klaqtsꞌiu qayntaun lapanaki yu maxtuy aqmoqxnun tejkan mapaqaꞌuy mintaqaꞌuti. Pero jantu kintꞌaltanan kaval, xlhiyucha klaktanchaniu. ");
INSERT INTO tptNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero ni Jesús lakjunil: —Jantu kꞌalaktꞌanchꞌanitꞌik. Yu jantu kintaxkayyan, va kintaꞌaqtayjuyan. ");
INSERT INTO tptNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ixlakamintacha julchan tejkan kalaqaꞌikanaꞌ ni Jesús laktꞌiyan. Ex naul mas va tichichun katapasal ni kaꞌanacha laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ex jamalaqachal lapanakni katapꞌulꞌal. Yuꞌuncha tatanuchal taun putaulan taꞌan ixtavilanal yu samaritanos para katapuxkaul taꞌan kataloqojlhi. ");
INSERT INTO tptNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero yu ancha machaqan jantu katalaqaꞌil tejkan takꞌatsal ni Jesús ixꞌuxaꞌan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tejkan chuncha takꞌatsal ni Jacobo ali Juan, va talhisakmil ni Jesús: —Jalhachimoꞌonu, ¿tas naꞌuncha? ¿Kaskꞌiu ni kataꞌeltajul jikmi laktꞌiyan para katalaqxauꞌol, chuncha tacha skꞌil ni Elías? ");
INSERT INTO tptNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ex taspꞌiklhi ni Jesús, va jalaqꞌaymal, va lakjunil: —Jantu kꞌatsꞌayatꞌik tisuncha espíritu lhitꞌaunatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kitꞌin yu Sasꞌatꞌa Lapanaki jantu kakmil para kakmaꞌakxal ixjatsukuntikꞌan ni lapanakni, va kminta para klaqmalaqtaxtul. Ex taꞌanchoqol ataun putaulan. ");
INSERT INTO tptNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tejkan ixtaꞌanta lakatin, qayntaun lapanaki naul, va junkal ni Jesús: —Kitꞌin kaktꞌaꞌanan mas va toꞌoxtaychacha kapꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ex ni Jesús junil: —Yu xanixꞌoyun, yuꞌuncha tamaqalin ixchaqakꞌan taꞌan poqapaj laktalpa. Yu tsꞌoꞌon, yuꞌuncha tamaqalin ixpaqtamankꞌan. Pero ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, jantu kakmaqalil toꞌoxtaycha kakmastaknil kiꞌaqtsul. ");
INSERT INTO tptNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ex ni Jesús junil aqayntaun: —Kꞌintꞌatꞌatꞌicha. Pero ni lapanaki va naul: —Jalhachimoꞌonuꞌ, kꞌimakꞌaunꞌel kajkꞌanꞌelayaꞌ maknunuꞌ kimpay. ");
INSERT INTO tptNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ex va junil ni Jesús: —Kꞌalakmakꞌaucha ni janinin katalamaknulcha siya yuꞌuncha ni janinin. Pero uxintꞌi kapiti jalaqputeꞌeniꞌ tacha lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ex naul aqayntaun, va junkal ni Jesús: —Vachu ktꞌaꞌuxanan, Jalhachimoꞌonuꞌ. Pero kꞌimakꞌaunꞌel klakmastakꞌaꞌelayaꞌ kilapanakni la kinchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ni Jesús junil: —Chuncha va tacha qayntaun yu chꞌapay ixpuchꞌa pero tejkan chꞌan si laqtsꞌilhaꞌan ixpulakan. Yucha jantu paxtoqniy katanul taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Taval ni Jesús jalaksaklhi setenta alati lapanakni y jamalaqachal pumatꞌiyun katapꞌulꞌal talakachux putaulanin va toꞌoxtaycha kaval taꞌan yucha astan kaꞌanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Pꞌunaj lakjunil: —Va tacha taun ay jaxqanti tajunita ni lapanakni yu talakapuꞌuxaꞌan ni Dios, pero tsꞌanqay oqxtamatin yu kataxqanal. Xlhiyucha kꞌatꞌapꞌayninitꞌik ni Dios para kajamalaqachal oqxtamatin la ixlhijaxqanati. ");
INSERT INTO tptNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ex kapꞌintꞌik. Klamalaqachayau taꞌan kꞌaꞌunapitik tacha sasꞌatꞌan borregos taꞌan alin maqtalin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jantucha kalhipꞌintꞌik ixpupachꞌikan mintuminkꞌan, nisin mintiyutkꞌan, nisin mivarachikꞌan. Jantucha matichun katamataqmaqanin kꞌamastꞌakꞌatꞌik lakatin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tejkan kachꞌipꞌinapitik laqa chaqaꞌ, kꞌamastꞌakꞌananapitik, kꞌanaunapitik: “Oxamaktauncha katsꞌukꞌutꞌik yu vilanantꞌik laqa chaqaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Va chuncha incha alin lapanaki yu oxamaktaun tsukuputun ex oxamaktaun kunaꞌ. Incha jantu, ex jantu paxtoqniy. ");
INSERT INTO tptNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Va ancha katꞌaulapitik laqa chaqaꞌ. Kaꞌuyapitik y kaꞌotꞌapitik yu kataxtaqniyan. Paxtoqniy kaxtaqnikal ixlhilhajati yu tapatsan. ");
INSERT INTO tptNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tejkan kachꞌipꞌinapitik taun putaulan taꞌan katalaqaꞌiyan, kꞌaꞌuyapitik yu kataxtaqniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Palay kalakmakꞌachꞌoꞌotꞌik yu taqanꞌanin yu ancha taꞌalinta. Kꞌalakꞌunapitik: “Va laycha kachil tejkan Dios katalhichimoꞌoyan.” ");
INSERT INTO tptNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero incha kachꞌipꞌinapitik taun putaulan taꞌan jantu katalaqaꞌiyan ex kapꞌinapitik lakatin, kꞌanaunapitik: ");
INSERT INTO tptNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ni pꞌoqxni yu tsꞌantsꞌaunau kakchꞌankꞌalhakanau la kinchꞌajakꞌan para kakꞌatsꞌatꞌik ni jantu ox yu ixkilamakaniyau. Pero kakꞌatsꞌatꞌik ni va ukstsꞌuniycha chil ixlhachimoꞌon Dios.” Chuncha kꞌanaunapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Va klajunau kaminaꞌ julchan tejkan apalay pꞌas kunaꞌ ixmaqanlqajnatkꞌan ni lapanakni yu machaqan ni anchanu putaulan taꞌan jantu katalaqaꞌin xajantu yu machaqan laka putaulan Sodoma. ");
INSERT INTO tptNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Payniꞌincha ni uxiknan yu machaqan laka putaulan Corazín. Payniꞌincha uxiknan yu machaqan laka putaulan Betsaida yu jantu mapꞌaxapꞌutꞌunatꞌik mijatapastakꞌatkꞌan. La mimputaulankꞌan klamakaniu yu lajꞌay axtoqnuꞌ. Ni lapanakni yu machaqan laka putaulanin Tiro kun Sidón yu maqancha ixtatꞌajun, jantu katalaqtsꞌil yu chavay klamasuniu. Va ixtalaqtsꞌil ex va niman ixtamapaxal ixjatapastakꞌatkꞌan. Va ixtaꞌulal puchꞌiniꞌ laqchꞌiti y va ixtataulal laka lkꞌakꞌan para katasul ni talhimaqaninin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Xlhiyucha tejkan kamukꞌanikanaꞌ ixtalaqalhinkꞌan ni lapanakni yu machaqan xaputaulan Tiro ali yu machaqan xaputaulan Sidón, ex va apalay pꞌas kunaꞌ mimaqanlqajnatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Uxiknan, xalapanakni Kapernaum, ¿lhakꞌapꞌupꞌinatꞌikcha ni kapꞌinapitik laktꞌiyan? Yu uxiknan kꞌatꞌanꞌalhukꞌanapitik laqnin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ex lakjunil ixtꞌaltanan: —Yu taqalasmatꞌan uxiknankꞌan kintaqalasmatꞌa ni kitꞌin. Yu jantu talaqaꞌiyan, jantu kintalaqaꞌiy ni kitꞌin. Yu jantu kintalaqaꞌiy ni kitꞌin jantu talaqaꞌiy yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tejkan taminchoqol ni setenta yu ixjamalaqachata ni Jesús, va ayaj talajꞌachal. Tajunil ni Jesús: —Jalhachimoꞌonuꞌ, mas ni aqmoqxnun kintaqalasmatꞌan tejkan ikmapaqaꞌuyau mintaqaꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ex ni Jesús lakjunil: —Klaqtsꞌil ni Satanás va tsꞌalaj patajul laktꞌiyan tacha taun makaliukniti. ");
INSERT INTO tptNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kitꞌin klaxtaqnitau tapꞌasta para lay kaltꞌanantꞌik taꞌan alin tsapulin kun statsuku y para lay kalhaꞌatꞌik ni aqmoqxnuꞌ kun tachun ixtapꞌasta y jantu tuꞌuchun kꞌalhitꞌapꞌasatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mas taqalasmatꞌan ni jantu ox espíritus jantu va yucha kꞌalhiꞌachꞌantꞌaꞌutꞌik. Kalhiꞌachꞌantꞌaꞌutꞌik ni tsꞌoqmulakantachalcha mintaqaꞌutikꞌan laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ex ni Jesús va niman lhiꞌachantajul ni Espíritu Santo, va naul: —KimPay kꞌatꞌi, xaJalhachimoꞌonuꞌ kꞌatꞌi laktꞌiyan kun lakamunukpaꞌ, kitꞌin ktoꞌoyayan. Va lakmalanitꞌa minchivinti ni lakstꞌuniy lapanakni y jamaqsaqnitꞌa yu talakpastaknan, yu lhuu ixtalanitkꞌan. Ay mijamapayninti xlhiyucha chuncha lhinaꞌun kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ex lakjunil ni lapanakni: —Ni kimPay va tachun kimaqxtaqnita. Jantu matichun kimispay taꞌayucha ni kitꞌin yu Sasꞌatꞌa, vamun kimPay kimispay. Vachu va chun jantu matichun mispay taꞌayucha ni kimPay, vamun ni kitꞌin vachu ni lapanakni yu klakmamispaniputun. ");
INSERT INTO tptNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ex talaqaspꞌiklaqtsꞌil ixtꞌaltanan, va lakjunil ixꞌamankꞌan: —Kꞌalhiꞌachꞌantꞌaꞌutꞌik ni laqtsꞌinatꞌik yu chavay tꞌajun tapasanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Laqsaval klajunau la maqancha qaynlhuvaj ixlapanakni ni Dios yu ixtalaqputeꞌey ixchivinti kun yu lhachimoꞌonun va ixtalaqtsꞌinputun yu chavay laqtsꞌinatꞌik, pero jantu kalal katalaqtsꞌil. Va ixtaqasmakputun yu chavay asmatꞌatꞌik pero jantu kalal kataqasmaklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ex chuncha va tayal qayntaun yu ixmasuy ixlhachimoꞌonkꞌan ni israelitas, va ixlaqtsꞌintanuputun ni Jesús. Junkal ni Jesús: —Jamalaniniꞌ, ¿tisuncha kakmakalcha para kaklhitsukul jatsukunti yu jantu aqtaun kamiꞌoyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ex naul ni Jesús: —¿Tisuncha jatsꞌoqnucha la kilhachimoꞌonkꞌan? ¿Tisuncha pꞌuꞌteꞌecha ancha? ");
INSERT INTO tptNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ex yu ixmasuy ixlhachimoꞌonkꞌan va naul: —Ni kilhachimoꞌonkꞌan najun: “Kaꞌachꞌanin ni Dios miJalhachimoꞌonuꞌ kun tachun melhanuti ali tachun metsukunti ali tachun mintapꞌasta ali tachun mijatapastakꞌati.” Vachu najun: “Kapꞌaxkꞌatꞌi mintꞌamachaqaꞌ tacha pꞌaxkꞌakꞌan meꞌeman.” ");
INSERT INTO tptNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ex va naul ni Jesús: —La ox yu altꞌiyanan. Va chuncha kꞌamakꞌatꞌi ex jantu aqtaun kamiꞌol ni metsukunti. ");
INSERT INTO tptNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ni anchanu lapanaki ixmakaputun para jantu lay kamukꞌanikal ixlaqtaqal. Va lhisakmil ni Jesús: —¿Ex tas ayucha kintꞌamachaqaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ex naul ni Jesús: —Qayntaun lapanaki ixtaxtuta Jerusalén, va ixꞌuxaꞌan tus Jericó pero tachꞌapayaul alhavanan. Maqaꞌasas tamakal y talaqanaqmal. Ex taꞌalcha, tamakaumalcha, va laycha ixnil. ");
INSERT INTO tptNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ex chuncha qayntaun xakura Jerusalén tapasal ancha lakatin, va laqtsꞌil ni kilpataniꞌ pero yucha va maqachoqol ni lakatin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Vachu va chun qayntaun Levita yu ixtapatsay xalakatajtan Jerusalén tapasal ni ancha lakatin, va laqtsꞌil y vachu vamun maqachoqol ni lakatin. ");
INSERT INTO tptNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ex qayntaun yu machaqaꞌ Samaria taꞌan talaxkajiy yu machaqan Jerusalén ixꞌukxuntayay ancha lakatin va chaꞌal taꞌan ixmal. Tejkan laqtsꞌil va ayaj mapaynil. ");
INSERT INTO tptNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ex chuncha niman taꞌukstsꞌuninil, lhikꞌuchꞌul aceite kun vino taꞌan talaqalhil, va lhichꞌinil laqchꞌiti. Ex mukꞌalcha la ixjuki, va lhaꞌalcha taꞌan loqojkan, ex va lhistaklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ex ataun julchan val, yu machaqaꞌ Samaria va xtaqnil aqxtꞌuy tumin ni manavin yu taꞌan loqojkan. Va junil: “Kꞌalhistꞌaktꞌi ni aniy lapanaki y tachun yu kamaꞌakxayeꞌe mintumin, kitꞌin kakxtaqnichoqoyan tejkan kakminchoqoyaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ex naul ni Jesús, va junkal ni yu masuy ixlhachimoꞌonkꞌan: —¿Tas naꞌuncha? ¿Taꞌayucha ixpumatꞌutukꞌan yu ixtꞌamachaqaꞌ ni kilpatani ni yu tachꞌapayaul alhavanan? ");
INSERT INTO tptNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ex yu masuy ixlhachimoꞌonkꞌan va naul: —Va yu mapaynil, yucha ixtꞌamachaqaꞌ. Ex junil ni Jesús: —Kꞌapꞌinchꞌiycha, vachu va chuncha kamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ex chuncha ni Jesús anchoqol lakatin va chaꞌal taun putaulan. Qayntaun xanati yu junkan Marta va yucha lhijunil ni Jesús kamil la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ixlhitꞌajun qayntaun ixtꞌalapanaki va ixjunkan María. Yucha taulnil taꞌan taulal ni Jesús va ixqasmakputun yu ixnajun. ");
INSERT INTO tptNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yu Marta vamun pastakꞌuy tas kapulaqlaꞌoxil ixvayti. Ex laqꞌal ni Jesús va naul: —Jalhachimoꞌonuꞌ, ka jantu kꞌilhipꞌastꞌakꞌa. Ni yu kintꞌalapanaki va kimakaunil ni lhitapatsa. Kꞌaꞌun kiꞌaqtayjul. ");
INSERT INTO tptNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ni Jesús qaltayanal: —Marta, Marta. La alin milhitapatsa yu makꞌapꞌutꞌun, va pastakꞌuyan milhilati. ");
INSERT INTO tptNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero vamun taun tuꞌuchun yu maqskꞌiniy kꞌamakꞌatꞌi. Va yu la ox yu laksakta ni María. Jantu matichun kamaxtuniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Taun julchan ni Jesús va lakataun ixtꞌajun skꞌiniꞌ ni Dios. Tejkan skꞌinꞌol ex qayntaun ixtꞌaltanaꞌ va junil: —Jalhachimoꞌonuꞌ, kilamasuniu tacha skꞌinkan ni Dios vachu chun tacha Juan lakmasunil ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ex ni Jesús lakjunil: —Tejkan kaskꞌintꞌik ni Dios kanauntꞌik: KimPay Dioskꞌatꞌi yu alintꞌachiy laktꞌiyan, katatoꞌoyan ni lapanakni mintaqaꞌuti. Kꞌalhachꞌimoꞌon aniy, chuncha kamakakal yu lhinaꞌun aniy lakamunukpaꞌ vachu va tacha makakan yu lhinaꞌun laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Lhilhiy kilaxtaqniu yu vayti yu kmaqskꞌiniyau. ");
INSERT INTO tptNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kilamalaqmixiniu kintalaqalhinkꞌan tacha kijnankꞌan klamalaqmixiniyau yu kintamakaniyan yu jantu lajꞌoxi. Jantu kilalhilhaꞌau taꞌan kakmapastaknikau yu talaqalhin, va kilamalaqtaxtuu laqa talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ex taylhaꞌal ixchivinti, jalakjunil: —Tas kavalcha incha xaqayntaun uxiknankꞌan va kapiti la ixchaqa milaqaj mas pakltaun tsꞌis kaval y kꞌaꞌun: “Laqaj, kimachꞌixtaqnin aqxtꞌutu pan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Qayntaun kilaqaj va aniykaꞌ xachin. La maqati ixminachal pero kitꞌin jantu klhitsukul yu kakxtaqnil.” ");
INSERT INTO tptNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ex yu milaqaj yu ixpulakna ixchaqaꞌ tanun, kunan: “Jantu kꞌimaꞌanchꞌapꞌu. Va lakchajuy kimatiꞌ y klaktꞌamal kesꞌatꞌan. Jantu lay kaꞌostaulay para kakxtaqnin tuꞌuchun.” ");
INSERT INTO tptNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kitꞌin klajunau mas milaqaj kaval jantu kaꞌostaulaꞌ para kaxtaqnin tuꞌuchun. Pero incha jantu kꞌamakꞌau, ex kaꞌostaulaꞌ, kaxtaqniyan yu uxintꞌi maqskꞌiniy. ");
INSERT INTO tptNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Laqsaval klajunau, kaskꞌinitꞌik Dios yu maqskꞌiniyatꞌik, yucha kataxtaqniyan. Kꞌalakxkꞌautꞌik ex katꞌemayapitik. Katꞌaylhipꞌi makasanaꞌ laka matiꞌ, ex katalaqltiꞌayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yu skꞌin tuꞌuchun, va laqaꞌiy. Yu puxkajuy, va temay. Yu makasay laka matiꞌ, ni yucha malaqltiꞌanikan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Xaqayntaun ni uxiknan incha kataskꞌinin ni pan mesꞌatꞌakꞌan, va kꞌaxtꞌaqnitꞌik chiyux? ¿Incha kataskꞌinin jatanti, kꞌaxtꞌaqnitꞌik tsapul? ");
INSERT INTO tptNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Incha kataskꞌinin axvati, kaxtꞌaqnitꞌik statsuku? Jantu matichun siya uxiknankꞌan chuncha layatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Chuncha ni uxiknankꞌan mas va jalaktuꞌunun untꞌatꞌik lay xtꞌaqniyatꞌik laqxoqta yu lajꞌox ni mesꞌatꞌankꞌan. Ex laqsaval mimPaykꞌan yu vilchal laktꞌiyan kalaqxtaqniyaꞌ yu apalay ox yu taskꞌin, va kalaqxtaqniyaꞌ ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ancha ixvil qayntaun lapanaki yu ixchꞌapata aqmoqxnuꞌ yu ixmakata janunuꞌ. Taval tejkan tisaxtul ni Jesús ni aqmoqxnuꞌ, ex ni lapanaki chivinchoqol. Yu alati lapanakni va tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero lati tanaul: —Va Beelzebú, yu xaꞌukxtin aqmoqxnuꞌ, xtaqniy ixtapꞌasta para lay kalakmaxtul ni aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lati ixtalaqtsꞌintanuy ni Jesús, taskꞌinil para kalakmasunil taun ay axtoqnuꞌ yu minachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ni Jesús ixkꞌatsaycha yu ixtapastakꞌa. Lakjunil: —Mas va tisuncha lhachimoꞌon incha va tatalaqlvaꞌa y talaxkajiy ni lapanakni, ex ixꞌamankꞌan tatalaktꞌilhiy. Vachu va chun aqataun chaqaꞌ incha tatalaqlvaꞌa y talaxkajiy ni lapanakni ex ixꞌamankꞌan tatalaktꞌilhiy. ");
INSERT INTO tptNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Vachu chun incha xꞌaman lay maxtuchoqokal ni Satanás yu xaꞌukxtin ni aqmoqxnu, ¿ex tas kaputaqnilcha ixtapꞌasta? Ex chuncha kꞌatsꞌayatꞌikcha ni jantu la ixtapꞌasta Beelzebú yu klakmaxtuy aqmoqxnun, mas chuncha naunatꞌik, va klakmaxtuy la ixtapꞌasta Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Incha kilajunau klakmaxtuy aqmoqxnun kun ixtapꞌasta ni Beelzebú ex vachu va chuncha tamaxtuy aqmoqxnun mintꞌaltanankꞌan yu tamalaniyan. Pero yuꞌuncha katajunan va jantu kun ixtapꞌasta ni aqmoqxnu tamaxtuy aqmoqxnun. ");
INSERT INTO tptNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kitꞌin kmaxtuy aqmoqxnuꞌ la ixtapꞌasta Dios chuncha kꞌatsꞌayatꞌik chavay ni Dios lhachimoꞌonun taꞌan ukxuyanantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tejkan qayntaun pꞌas lapanaki chꞌapata ixpatꞌalan y va lhistakta ixchaqaꞌ, ex chuncha jantu matichun lay kamaxtunichoqol yu ixnavin yu maꞌata. ");
INSERT INTO tptNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero incha kachinaꞌ aqayntaun yu apalay pꞌas, ex yucha kalhajayaꞌ, kamaxtuniyaꞌ ixpatꞌalan yu ixlhiꞌajin kun tachun yu ixnavin y kalaqlvaqniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yu jantu kintꞌaꞌan ni kitꞌin yucha va kixkajiy. Yu jantu jalaqmaqxtoꞌa lapanakni para kintatꞌaꞌal, yucha va lakmaputaukꞌay. ");
INSERT INTO tptNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Tejkan taxtuy taun jantu ox espíritu la ixlakatunaj qayntaun lapanaki, ex va an ukxuntayan taꞌan jaxixninta. Lakxkajuy taꞌan kataulal pero jantu temay. Ex va pastakchoqoy: “Ka va kajkꞌanchoqoyacha la kinchaqaꞌ taꞌan kmintachal.” ");
INSERT INTO tptNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tejkan chinchoqoy la ixlakatunaj ni lapanaki va tus ox japꞌalnankanta y ox jalaꞌoxikanta. ");
INSERT INTO tptNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ex anchoqoy laqmaqxtoqnuꞌ pumatujun ixtꞌaꞌespíritus yu apalay talaktuꞌunun. Tus tachun chꞌantaun tatanuy la ixlakatunaj ni anchanu lapanaki. Ex chuncha apalay lhitaꞌay jun ixjatsukunti ni lapanaki xajantu tacha ixjunita pꞌunaj. ");
INSERT INTO tptNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ex tejkan ixtꞌajun chivin ni Jesús, va tꞌasal qayntaun xanati, va junil: —Ka la achancha ni xanati yu memaqlaqavanaꞌ, yu matsꞌikꞌin ni uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero ni Jesús junil ni anu xanati: —Yu laqsaval achan va yu qasmatꞌa ixchivinti Dios y makay tacha lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ex chuncha ixtalhavaxtu lapanakni taylhaꞌal maqxtoqnun ni Jesús. Va naul ni Jesús: —Yu chavay tatꞌajun lapanakni ayaj talaktuꞌunun. Kintaskꞌiniy kaklakmasunil ay axtoqnuꞌ yu lay kintapumispal. Pero jantu tuꞌuchun kaklakmasuniyaꞌ ni lapanakni, vamun yu tapasal ni Jonás yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Va por yu tapasal ni Jonás va ixtapukꞌatsaniy yu machaqan Nínive va ixmalaqachata ni Dios. Vachu va chun yu kaktapasayaꞌ va chuncha kintapukꞌatsaniyaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Taun julchan kalakmukꞌanikanaꞌ ixlaqtaqalkꞌan ni lapanakni, ex chuncha ni xanati yu ixlhichimoꞌoy maqancha ixlhisur ni lakamunukpaꞌ, va ancha katayayaꞌ y kalaktislajmayaꞌ ni lapanakni yu chavay tatꞌajun. Yucha la maqati minchal para kaqasmaknil ixchivinti Salomón yu ayaj lhuu ixjatapastakꞌati. Pero chavay alin qayntaun aniy yu apalay lhuu jatapastakꞌati lhitꞌajun xajantu Salomón. ");
INSERT INTO tptNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Vachu ni anchanu julchan katatayayaꞌ ni lapanakni yu maqancha machaqan Nínive. Vachu katalakmukꞌaniyaꞌ ixlaqtaqalkꞌan yu chavay tatꞌajun lapanakni. Yuꞌuncha yu machaqan Nínive va tamapaxal ixjatapastakꞌatkꞌan tejkan taqasmaknil ixchivinti Jonás. Pero uxiknan maꞌalinatꞌik qayntaun aniy yu apalay pꞌas xajantu ni Jonás. ");
INSERT INTO tptNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jantu matichun mamaqtayay ixmaklku para kamaꞌal taꞌan jantu tasuy, vachuꞌ jantu maqanuy ixtaꞌapuꞌ kajun. Va mukꞌay talman para lay katalaqtsꞌil maklku yu tatanuy ni laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yu milaqchulkꞌan va tacha xamaklku milakatunajkꞌan. Incha lajꞌox milaqchul, ex alin maklku para taꞌakchun milakatunaj. Chavay incha jantu ox milaqchul ex va putsꞌista la metsukunti. ");
INSERT INTO tptNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ex kꞌalhistꞌajkꞌantꞌik incha laqsaval alin maklku la metsukuntikꞌan u incha va putsꞌista. ");
INSERT INTO tptNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Incha tus ox maqtajita ni maklku, ex jantu intachun kaputsꞌislhi la metsukuntikꞌan. Vachu va tacha la ox lakꞌavananatꞌik taꞌan alin maklku yu ox maqtajita. ");
INSERT INTO tptNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ex tejkan chivinꞌol ni Jesús, qayntaun fariseo juntalhaꞌal vayaꞌ la ixchaqaꞌ. Ex tanuchal ni Jesús, va taulal laka mesa. ");
INSERT INTO tptNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ni fariseo va laqtsꞌil ni jantu kamaqchaꞌaꞌelal ni Jesús tacha ixnajun ixlhachimoꞌonkꞌan. Ex yucha jantu ox kalhilal. ");
INSERT INTO tptNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ex junil ni Jesús, junkal yu fariseo: —Laqsaval ni uxiknankꞌan yu fariseos va tacha yu tasa ali plato yu ox chaꞌakanta pero vamun ixlhimaqspakꞌan. Va chuncha ni uxiknankꞌan. Jantu makꞌayatꞌik kuenta la ixpulakna metsukuntikꞌan. Ancha alin taꞌaqspukniti kun jaxkayanti. ");
INSERT INTO tptNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Va tontos untꞌatꞌik. Ni Dios yu makal yu ixlhimaqspaꞌ vachu makal yu ixlhipulakna. ");
INSERT INTO tptNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kaꞌaqtꞌayꞌutꞌik ni kilpatanin ex la lhiꞌacha kunaꞌ mejalhanutkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Payniꞌincha uxiknankꞌan fariseos. Laqsaval xtꞌaqniyatꞌik ni lakatajtan tsꞌuniy mimuviskꞌan ali tsꞌuniy jalaꞌoxinti ali tsꞌuniy mijaxqantikꞌan tacha najun kilhachimoꞌonkꞌan. Pero jantu makꞌayatꞌik kuenta para kaꞌaqtꞌayꞌutꞌik yu alati y jantu tꞌoꞌoyayatꞌik Dios. Va yucha yu maqskꞌiniy kꞌamakꞌatꞌik pero vachu jantu kꞌamakꞌau yu alati. ");
INSERT INTO tptNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Payniꞌincha uxiknankꞌan fariseos. Taꞌan tataqxtoꞌa ni lapanakni tꞌaulpꞌutꞌunatꞌik taꞌan katoꞌoyakꞌantꞌik. Vachuꞌ lakatin va naunatꞌik kamastꞌakꞌakꞌantꞌik tacha lajꞌay lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Payniꞌincha uxiknankꞌan. Lhichꞌivinanatꞌik yu lajꞌoxi pero makꞌayatꞌik yu jantu ox taꞌan jantu talaqtsꞌinan ni lapanakni, tacha putaknun untꞌatꞌik yu jantu tasuy, taꞌan tatapasay lapanakni sin katakꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ex va junil qayntaun yu ixmasuy ixlhachimoꞌonkꞌan ni israelitas: —Jamalaniniꞌ, tejkan chuncha naꞌun uxintꞌi, kilalaqꞌaymayau kijnankꞌan vachuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ex qaltayl ni Jesús: —Vachu payniꞌincha ni uxiknankꞌan yu masuyatꞌik ixlhachimoꞌonkꞌan ni lapanakni. Laklhijunatꞌik ni lapanakni yu ayaj lhitaꞌay tus jantu lay tatayaniy. Chuncha lakmatꞌikꞌukꞌayatꞌik yu alati lapanakni pero jantu aqtꞌayꞌuyatꞌik mas va kun yu maktaun yu lakatꞌuniy mimakakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Payniꞌincha uxiknankꞌan. Yu mimpayankꞌan tamaqnil yu maqancha ixtalaqputeꞌey ixchivinti Dios. Chavay yu uxiknankꞌan makꞌayatꞌik ixpupastakꞌankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ex chuncha tꞌalhipꞌiniyan yu tamakal mimpayankꞌan. Yuꞌuncha talaqmaqnil yu ixtalaqputeꞌey ixchivinti Dios y uxiknankꞌan makꞌayatꞌik ixpupastakꞌankꞌan mas jantu laqsaval laktꞌoꞌoyayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ni Dios yu ayaj pastaknan va naul: “Klaqmalaqachaniyaꞌ lapanakni yu talaqputeꞌey kinchivinti kun yu alati kintamalaqachan. Lati kalaqmaqnikanaꞌ, lati kalakxkaykanaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ex chuncha yu chavay tatꞌajun lapanakni kalakmukꞌanikanaꞌ laqtaqal por tachun yu laqmaqnikanta lapanakni yu ixtalaqputeꞌey ixchivinti Dios. Mas yu ixtalaqputeꞌey ixchivinti Dios tejkan aqtaynil ni lakamunukpaꞌ tus chavaycha. ");
INSERT INTO tptNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mas va Abel yu la maqancha maqnikal tus Zacarías yu maqnikal la kilakatajtankꞌan la ixtanꞌajna taꞌan toꞌoyakan Dios kun laka altar. Laqsaval klajunau, ni chavay tatꞌajun lapanakni kalakmukꞌanikanaꞌ laqtaqal por tachun yu laqmaqnikanta yu ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Payniꞌincha uxiknankꞌan yu masuyatꞌik ixlhachimoꞌonkꞌan ni lapanakni. Chavay ni uxiknankꞌan va tacha kachꞌapꞌatꞌikcha xapumalaqltiꞌakan xachaqaꞌ jatapastakꞌati. Pero jantu tꞌanuyatꞌik y vachu laktanchꞌaniyatꞌik yu alati lapanaki para jantu lay katalhitsukul jatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Va chuncha chivinꞌol ni Jesús. Ex ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, taꞌaqtaynilcha talaqtsꞌintanuy, talhisakmiy axtoqnu yu lhitaꞌay. ");
INSERT INTO tptNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Chuncha ixtamakay para kanaul ni Jesús taun chivinti yu jantu lhinajun ixlhachimoꞌonkꞌan para ex chuncha lay kataputislajmal. ");
INSERT INTO tptNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ex tataqxtoqnil ixtalhavaxtu lapanakni por miles tus ixtalapatsꞌiuksta. Ni Jesús va jalakjunꞌelal ixtꞌaltanan, va naul: —Kꞌalhistꞌajkꞌantꞌik para jantu kalhakꞌapꞌupꞌintꞌik ixchivintikꞌan ni fariseos yu tꞌuy ukxpuꞌ tamakay, va tacha levadura. ");
INSERT INTO tptNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tachun yu chavay aqxtaqmanti kamispakanaꞌ y tachun yu makakan laqatamaqsaq, kamispakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yu naunatꞌik laka putsꞌista para jantu kaqasmajkal, va kaqasmajkanaꞌ laka tunkunaꞌ. Tachun yu chꞌivinanatꞌik laksniy la minchaqakꞌan para jantu kamispakal, va kamispakanaꞌ tacha katꞌasakal talman. ");
INSERT INTO tptNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Kintꞌalaqaunin, jantu kꞌatꞌalhaunitꞌik ni lapanakni yu lay katamaqniyan. Yuꞌuncha astan tejkan kaniyapitik jantucha lay tuꞌuchun katamakaniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero klajunau taꞌayucha kꞌatꞌalhaunitꞌik. Kꞌatꞌalhaunitꞌik ni Dios yu lay tamaqniyan y vachuꞌ astan lay tamalaqachayan laqnin. Yucha kꞌatꞌalhaunitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Laqakis tsꞌoꞌon lhistꞌakan aqxtꞌuy pero mas va tsꞌuniy ixtapalkꞌan, Dios jantu lajkꞌapꞌa ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mas miꞌajikꞌan yu alin la miꞌaqtsulkꞌan tus taputeꞌeniꞌotan ni maqatamin por maqatamin. Xlhiyucha jantu maqskꞌiniy katꞌalhanantꞌik. Uxiknankꞌan apalay xtapal untꞌatꞌik xajantu lhuvajcha tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Incha qayntaun najun la ixtalakaꞌukxpukꞌan ni lapanakni ni va kilapanaki junita, ex kitꞌin yu kval Sasꞌatꞌa Lapanaki vachuꞌ kaknaunaꞌ la ixtalakaꞌukxpukꞌan ixmayulnin Dios, ni va kilapanaki junita. ");
INSERT INTO tptNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero incha najun la ixtalakaꞌukxpukꞌan ni lapanakni ni jantu kilapanaki junita, ex kitꞌin vachuꞌ kaknaunaꞌ la ixtalakaꞌukxpukꞌan ixmayulnin Dios, ni jantu kilapanaki kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yu kinkiltaukꞌaniy ni kitꞌin yu Sasꞌatꞌa Lapanaki, yucha ni Dios kamalaqmixiniyaꞌ. Pero yu jantu ox lhichiviniy ni Espíritu Santo yucha jantu kamalaqmixinikanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Tejkan kalhipꞌinkꞌanapitik laqa chaqaꞌ taꞌan tataqxtoꞌa y la ixtalakaꞌukxpukꞌan ni lhachimoꞌonun, jantu kapastakꞌun tas kꞌalhaꞌaltꞌayananapitik u tisuncha kꞌanaunapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ni Espíritu Santo katamalakpastakꞌaniyan tas kanaunapitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ex chuncha qayntaun yu ancha ixyal va naul, va junkal ni Jesús: —Jamalaniniꞌ, kꞌaꞌun keeyaꞌ kixtaqnil pakltaun ixlhitapatsa kimPaykꞌan yu kimpaxtoqniycha ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ex va najun ni Jesús: —Lapanaki, kitꞌin jantu kimpaxtoqniy kaklaꞌoxil. ");
INSERT INTO tptNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ex chuncha ni Jesús va lakjunil ni lapanakni: —Kꞌalhistajkꞌantꞌikcha, jantucha aqtaun kaꞌakchꞌipꞌintꞌik. Jantu vamun mimaqalitkꞌan kꞌapꞌutsꞌukꞌuyapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ex va chuncha jalaqputeꞌenil taun chivinti yu xtaꞌa jatapastakꞌati. Va lakjunil: —Qayntaun maqaliꞌ va la ox ixlhitꞌajun ixtꞌun, va lhuvaj lhiꞌuti xqal. ");
INSERT INTO tptNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ex va pastaklhi: “¿Tas kakmakayacha ni kijaxqanti? Kimpakꞌatsa aqtsamalcha, jantucha lhijun.” ");
INSERT INTO tptNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ex va pastakchoqol ni maqaliꞌ: “Kakmaqtayacha ni kimpakꞌatsa. Ataun kakmakachoqoyaꞌ sastꞌi yu apalay ay kaval ex ancha kakmaꞌaꞌoyaꞌ tachun kilaqxoqta, ex chuncha la ox kunaꞌ para kalaqchaanacha lhuvaj jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ex kakstaknanacha, vamuncha kakvaynaꞌ, kajqoqnunaꞌ, jantucha kaktapatsayaꞌ, oxamaktauncha kajkꞌalinaꞌ”, va naul ni anchanu lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero yu Dios va junil ni maqaliꞌ: “¡Tontoj! Jantu pꞌastꞌakꞌa yu makꞌay chavaycha. Apanchꞌix putsꞌista kalaqmixacha metsukunti. ¿Ex yu milaqxoqta tas kꞌapꞌulhitsꞌukꞌuyeꞌecha?” ");
INSERT INTO tptNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ex tejkan ni Jesús lakjunil ni anchanu chivinti yu xtaꞌa jatapastakꞌati, va naul: —Va chuncha kaniyaꞌ yu vamun pastakꞌa para kalalhaval ixmaqaliti, pero jantu pastakꞌa tacha kapulaqaꞌil ixlhilhajati kun Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ex va lakjunil Jesús ixtꞌaltanan: —Xlhiyucha kitꞌin klajunau jantu katapastakꞌun la metsukuntikꞌan suncha kꞌaꞌuyapitik, vachu jantu katapastakꞌun la milakatunajkꞌan suncha kꞌaꞌulayapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Apalay ixtapal ni metsukuntikꞌan xajantu ni vayti y apalay ixtapal ni milakatunajkꞌan xajantu ni laqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kalaqtsꞌintꞌik ni laꞌa. Mas yuꞌuncha jantu tachꞌan, mas jantu taxqanan, mas jantu tꞌujuꞌ ixmoqltakꞌan, mas jantu tꞌujuꞌ ixpakꞌatsakꞌan, va lakvavay ni Dios. Yu uxiknankꞌan apalay ixtapal metsukuntikꞌan xajantu yu tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Taꞌayucha siya uxiknankꞌan lay apalay putanꞌay kꞌaꞌunaꞌ vamun por pastakꞌuy? ");
INSERT INTO tptNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ex incha jantu chuncha lay makꞌayatꞌik mas va tsꞌuniy, ¿ex valiꞌiycha tapastakꞌuyan kꞌamakꞌatꞌik yu apalay lhitaꞌay? ");
INSERT INTO tptNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Kalaqtsꞌintꞌik tacha taꞌajin ni xanti. Jantu tatapatsay, jantu tamakay isijuntikꞌan. Pero kitꞌin klajunau ixlaqchꞌiti yu ay lhachimoꞌonuꞌ Salomón mas ayaj ox ixlakatayay, jantu kalaqchaꞌal tacha ixꞌoxixtu laqataun xanti. ");
INSERT INTO tptNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ni javan yu chavay alinta lakakꞌavin, lhiy kalaqxauyacha laka horno pero ni Dios ayaj kꞌus jamalaqchꞌiniy. Ex apalay ox katamalaqchꞌiniyan ni uxiknan mas va lakatsꞌuniy milhakapuꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jantu kꞌapꞌuxkꞌautꞌik vamun yu kꞌaꞌuyapitik kun yu kꞌaꞌotꞌapitik. Jantu tuꞌuchun katapastakꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yu valiꞌiy lapanakni aniy lakamunukpaꞌ, yuꞌuncha ayaj tapastakꞌuy yu aniy axtoqnuꞌ. Pero mimPaykꞌan Dios, yucha kꞌatsay ni maqskꞌiniyatꞌik tachun ni anchanu axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Va kꞌalhipꞌuxkꞌauyapitik ni kalhachimoꞌonul Dios, ex kaꞌalinaꞌ tachun yu maqskꞌiniyatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Jantu katꞌalhanantꞌik. Ni uxiknankꞌan yu ixnavin Dios va tacha kiborregos untꞌatꞌik. Mas jantu qaynlhuu kꞌaꞌuntꞌik, ni Dios va maqamay kataxtaqnin palhachimoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kastꞌatꞌik yu lhitꞌaunatꞌik y kꞌaxtꞌaqnitꞌik ni tumin yu tamaqskꞌiniy. Chuncha va tacha kamaꞌatꞌik milhilhajatikꞌan laka bolsas yu jantu aqtaun tapuchꞌiy. Chuncha kalalhavatꞌik laktꞌiyan mimaqalitikꞌan yu jantu aqtaun kamiꞌoyaꞌ. Ancha laktꞌiyan jantu tanuyachal alhavanan, vachuꞌ jantu laqlvajiy ni matapil. ");
INSERT INTO tptNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Taꞌan maꞌalinatꞌik mimaqalitkꞌan, va ancha pꞌastꞌakꞌatꞌik la mejalhanutikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Kakꞌujtꞌikcha. Va kamaqtaylcha mimaklkukꞌan. Va listujcha kꞌaꞌuntꞌik kun mimaklkukꞌan maqtajitacha. ");
INSERT INTO tptNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kꞌaꞌuntꞌik tacha oqxtamatin yu tapakxan kachinchoqol ixꞌukxtinkꞌan yu al taꞌan lakxtuklakan. Va chuncha kꞌapꞌakxantꞌik ni Dios miJalhachimoꞌonukꞌan. Tejkan kachinaꞌ ni ukxtin va kamakasayaꞌ ni matiꞌ y va niman katamalaqltiꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ox kaxajtachal para ni anchanu oqxtamatin yu kalaktemakanaꞌ takujtacha tejkan kachinaꞌ ixꞌukxtinkꞌan. Laqsaval klajunau, yu ukxtin kamakakanaꞌ ixꞌaman tacha oqxtamati kaval. Yucha kalakmulayaꞌ ixꞌoqxtamatin laka mesa y ancha kalakmulaniyaꞌ ixvaytikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mas kachil pakltaun tsꞌis, mas kachil katunkumil, incha kalaktemakanaꞌ takujtacha ni oqxtamatin, ex ox kaxajtachal ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Laqsaval klajunau, va kakꞌatsal ni machaqaꞌ tavanan kachil ni alhavanaꞌ ex va kakujtaulal, ex jantu kaxtaqlhi lakatin kaꞌalhavanankal ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Uxiknankꞌan vachu kꞌakꞌujtꞌikcha. Jantu kꞌatsꞌayatꞌik tavanancha kakminchoqoyaꞌ kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ex ni Pedro va lhisakmil: —Jalhachimoꞌonuꞌ, ¿vamun ni kijnan kilajuniu ni aniy chivinti yu xtaꞌa jatapastakꞌati u va lakꞌunꞌoj tachun ni aniy lapanakni? ");
INSERT INTO tptNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ex va junil ni Jesús: —¿Taꞌayucha ni xalhistaknaꞌ oqxtamati yu lhiꞌaynkan y mispay lhitapatsa? Va yucha ni ixꞌukxtin kamakaunaꞌ para kalaklhistaklhi oqxtamatin y para kalakvaval tejkan tachavaniy. ");
INSERT INTO tptNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ayaj lhiꞌachantajuycha yu oqxtamati yu tꞌajuncha makaꞌonaꞌ yu ixlhijunkanta tejkan chinchoqoy ixꞌukxtin. ");
INSERT INTO tptNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Laqsaval klajunau ni ixꞌukxtin kamakauniyaꞌ kalaklhistaklhi tachun ixmaqaliti. ");
INSERT INTO tptNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero incha ni xalhistaknaꞌ oqxtamatin pastakꞌa ixꞌaman kataqmaqayaꞌ ixꞌukxtin y aqtaylcha jalakasamay ixtꞌaꞌoqxtamatin ali yu maqtsukunin y vamun vajin, oqnun, taꞌapꞌay, ");
INSERT INTO tptNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ex chuncha va kaminchoqoyaꞌ ixꞌukxtin taun julchan tejkan jantu pakxanꞌiy y taun hora tejkan jantu kꞌatsay. Kamaxtunikanaꞌ ixlhitapatsa y kamakakanaꞌ tacha yu lapanakni yu jantu talhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Qayntaun oqxtamati yu mispay tacha najun ixꞌukxtin pero jantu listuj kaval y jantu makay yu lhijunkan yucha ox kalaqanaqmakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero qayntaun oqxtamati yu jantu mispay tacha najun ixꞌukxtin y jantu listuj kaval yucha tsꞌuniy lamaqanaqni kalaqaꞌiyaꞌ. Yu apalay lhuu ixtaqnikan, yucha apalay lhuu kaskꞌinichoqokanaꞌ. Yu apalay ox lhiꞌaynkan para lhuu kalhistaklhi, yucha apalay lhuu kaskꞌinichoqokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Va chuncha kmil va tacha kakmamaqtiyal jikmi ni lakamunukpaꞌ. Va knajun kamaqtaylcha. ");
INSERT INTO tptNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kitꞌin ayaj kakmaqanlqajnanaꞌ y ayaj kmaqaninin tus katamaktal ni maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Lhakꞌapꞌupꞌinatꞌik ni kminta para chꞌantaun kaval ni lapanakni ni aniy lakamunukpaꞌ? Jantu laqsaval kaval. Va kminta para kaꞌalil laꞌatꞌuy ixjatapastakꞌatkꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chavaycha aqataun chaqaꞌ taꞌan tavilanal pumakis lapanakni ancha kaꞌalinaꞌ laꞌatꞌuy jatapastakꞌati. Qayntꞌuy yuꞌuncha ataun jatapastakꞌati katalhitsukuyaꞌ y yu qayntꞌutu ataun jatapastakꞌati katalhitsukuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yu japay kaxkayyaꞌ istsꞌal, yu jatsꞌal kaxkayyaꞌ ixpay. Yu janati kaxkayyaꞌ istsiꞌi, ni jatsiꞌi kaxkayyaꞌ ixnati. Ni xaꞌatinaꞌ kaxkayyaꞌ ixpꞌuti, ni ixpꞌuti kaxkayyaꞌ ixꞌatinaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ex ni Jesús lakjunil ni lapanakni: —Tejkan laqtsꞌinatꞌik ni ostaulay taputsꞌi ixlhitoꞌanta, naunatꞌik katamayaꞌ xkan y chuncha jun. ");
INSERT INTO tptNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tejkan laqpaqnan, laktꞌasakan paxtoꞌanta, naunatꞌik kataylhaanaꞌ skunuꞌ y chuncha jun. ");
INSERT INTO tptNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tꞌuy ukxpuꞌ makꞌayatꞌik. Uxiknankꞌan kꞌatsꞌayatꞌik tas katapasayaꞌ lakamunukpaꞌ kun laktꞌiyan. ¿Valiꞌiycha jantu malaꞌasiyatꞌik yu tapasay chavaycha aniy taꞌan tꞌaunatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Valiꞌiycha jantu laksakꞌatꞌik meꞌemankꞌan yu lajꞌoxi para metsukuntikꞌan? ");
INSERT INTO tptNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Chavay incha matichun chivintanuputun laka machꞌalkꞌati por makꞌanin laqtaqal, ex tejkan tꞌapꞌin lakatin kꞌalaꞌoxitꞌi, para jantu kamaqxtaqnin kun machꞌalkꞌati. Incha jantu, ex yu machꞌalkꞌati kamaqxtaqniyan ixpolisia ex yu polisia kamanuyan laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kitꞌin ijkunan ni jantu katꞌaxtꞌuyeꞌe incha jantu kꞌamapꞌalꞌoyeꞌe tachun mijalhaaninti. ");
INSERT INTO tptNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tejkan chuncha naul ni Jesús ancha tayanal lati lapanakni yu taputeꞌenil yu tapasal Galilea. Va taputeꞌenil tacha laqpumaqnil ni Pilato lati yu machaqan Galilea tejkan ixtatꞌajun moqslanan ixlapaxkankꞌan ni Dios y va lakmalhiyaul ixjakꞌalnankꞌan kun ixjakꞌalnankꞌan ni talhitsukukna yu ixlapaxkankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ex ni Jesús lakjunil: —Ni uxiknan pꞌastꞌakꞌatꞌik va tanil ni anchanu lapanakni va por apalay ixtalhitꞌajun ixtalaqalhinkꞌan xajantu yu alati yu machaqan Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero kitꞌin klajunau jantu laqsaval kaval. Va klajunau incha jantu kamapꞌaxayapitik mijatapastakꞌatkꞌan ex katsꞌanꞌayapitik vachu va tacha ni anchanuꞌ lapanakni yu machaqan Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Vachu va taniꞌol pumakautsajin lapanakni tejkan taqtal ni torre laka Siloé. ¿Ex va lhilayatꞌik va apalay lhuu ixtalaqalhinkꞌan xajantu yu alati lapanakni yu ixtavilanal Jerusalén? ");
INSERT INTO tptNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jantu laqsaval kaval. Va klajunau incha jantu kꞌamapꞌaxayapitik mijatapastakꞌatkꞌan ex katsꞌanꞌayapitik vachu va tacha ni anchanu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ex va lakjunil ni Jesús yu aniy chivinti yu xtaꞌa jatapastakꞌati: —Qayntaun lapanaki va ixchꞌanta taun kꞌiu yu junkan higuera taꞌan ixchꞌanta ixꞌuvas. Astan puxkaul xaꞌunikan ni higuera pero jantu katemal. ");
INSERT INTO tptNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ex junil yu xalhistaknaꞌ lakatꞌun: “Va laꞌatꞌutu jachꞌitin iktiꞌukxuyal puxkaunaꞌ xaꞌunikan, jantu aqtaun kaktemal. Kꞌamaqtꞌatꞌicha. Vamun valiꞌiy mapatsay ni lakatꞌun.” ");
INSERT INTO tptNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ex naul yu xalhistaknaꞌ lakatꞌun: “Kiꞌukxtin kꞌatꞌi, kꞌamakꞌau ataun jachꞌitin. Kitꞌin kaklajꞌajniyaꞌ lakatꞌun, kakmamaniyaꞌ abono. ");
INSERT INTO tptNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chuncha ka va lay kaꞌalil xaꞌunikan ataun jachꞌitin. Pero incha jantu ex kakmaqtayacha.” ");
INSERT INTO tptNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Taun xajulchan jastaknati ni Jesús ixmalaninin laqa chaqaꞌ taꞌan ixtaqxtoꞌa ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ancha ixtanun qayntaun xanati ixlaqtanun yu jantu ox espíritu. Xlhiyucha va ixtaqanꞌay. Va laqakautsajin jachꞌitin ixtamakataltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tejkan ni Jesús laqtsꞌil ni xanati, juntaꞌil, va naul: —Xanati kꞌatꞌi, palaycha kꞌaꞌunchꞌoꞌo mintaqanꞌati. ");
INSERT INTO tptNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ex moqslanikal ixmakaꞌ ni xanati, va nimancha vas tayal, aqtaylcha ay makay ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ex ni xaꞌukxtin ni anchanuꞌ chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas lhitalqamal va por kꞌuchꞌunul ni Jesús tejkan xajulchan jastaknati. Va lakjunil ni lapanakni: —Alin paqchaxan putapatsa laka semana. Yu ixkꞌuchꞌuka lapanaki va lhitapatsa. Kꞌatꞌantꞌik laka semana para kꞌakꞌuchꞌukꞌantꞌik, pero jantu kꞌatꞌantꞌik yu xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ex va naul ni Jalhachimoꞌonu Jesús: —Va tꞌuy ukxpuꞌ makꞌayatꞌik. Mas va xataꞌayuꞌ uxiknankꞌan va xꞌotꞌatꞌik mivakaxkꞌan u mimburrokꞌan, lhipꞌinatꞌik moꞌotꞌunun xkan mas va xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chavay yu aniy xanati yu ixpapanti Abraham, va laqakautsajin jachꞌitin ixtaqanꞌay, va ixlaqtanuy ni Satanás. Yucha vachu chun maqskꞌiniy kaxꞌoqnikal ixtaqanꞌati para palay kaval mas va xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tejkan chuncha naul ni Jesús va tatamaxaniꞌol tachun ixtꞌalaxkaynin. Pero tachun yu alati lapanakni taꞌaqtayl talhiꞌachantajuy por tachun yu ay axtoqnuꞌ yu lakmakal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ex chuncha naul ni Jesús: —Chavay klamasuniyau tacha junita tejkan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Va tacha ni lakatꞌuniy xatꞌin yu junkan mostasa. Qayntaun lapanaki chꞌal ni lakatꞌuniy tꞌin la ixtꞌun. Ancha aynlhi tus ay kꞌiu val. Ancha tamakal ixpaqtamankꞌan ni tsꞌoꞌon la ixmaqlaqapꞌu. ");
INSERT INTO tptNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ex chuncha vachu naul ni Jesús: —Klamasunichoqoyau tacha junita tejkan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Va tacha levadura yu qayntaun xanati lhiyajuy kun laꞌatꞌutu kualtil harina, va tus kalhitayaꞌol tachun ni skititi. ");
INSERT INTO tptNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ex ixꞌanchoqota lakatin ni Jesús ni Jerusalén, va ixtapasaꞌanta taun taun putaulan yu lajꞌay kun yu lakstꞌuniy. Va ixmalaniniꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Qayntaun lapanaki va lhisakmil: —Jalhachimoꞌonuꞌ, ¿vamun tsꞌuniy yu kalaqmalaqtaxtukanaꞌ? Ex ni Jesús va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Kamakꞌatꞌik tachun la mintapꞌastakꞌan para kalal kꞌatꞌanutꞌik taꞌan putꞌuniy matiꞌ. Klajunau astan katatanuputunaꞌ lhuvaj lapanakni ex jantucha kalayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Incha jantu chuncha makꞌayatꞌik, ex va kaꞌostaulaꞌ yu machaqaꞌ, kamalakchauyaꞌ ni matiꞌ. Ex kꞌatꞌayayapitik maqspaꞌ, kꞌamakꞌasayapitik ni matiꞌ, kꞌaꞌunapitik: “Jalhachimoꞌonuꞌ, kilamalaqltiꞌaniu.” Ex yucha katajunan: “Jantu klamispayau. Jantu kꞌatsay toꞌoxtaycha machaqan untꞌatꞌik.” ");
INSERT INTO tptNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ex kꞌaꞌunapitik: “Klatꞌavajiu uxintꞌi y klatꞌaꞌoqnuu y la kinputaulankꞌan kilamasuniu.” Chuncha kꞌanaunapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ex katajunchoqoyan: “Jantu klamispayau. Jantu kꞌatsay toꞌoxtay machaqan untꞌatꞌik. Kapꞌintꞌikcha. Kilamakajuucha uxiknankꞌan yu laktꞌuꞌununatꞌik”, chuncha katajunan. ");
INSERT INTO tptNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ex ancha kaꞌalhunapitik y kꞌalaktsꞌakꞌalhitsꞌukꞌuyapitik mintatsalatikꞌan. Kꞌalaqtsꞌinapitik ni Abraham ali Isaac ali Jacob ali tachun yu ixtalaqputeꞌey ixchivinti Dios taꞌan lhachimoꞌonun Dios. Pero ni uxiknankꞌan va kꞌatꞌanꞌalhumaxtꞌukꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pero lapanakni yu machaqan talakachux ni lakamunukpaꞌ, taꞌan putakꞌutꞌa ni julchan y vachu taꞌan puꞌanachal, yu machaqan ixlhitoꞌanta, ixpaxtoꞌanta, va kataminaꞌ, katataulaꞌ, katavaynꞌoyaꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ex chuncha yu jantu ay kꞌatsan chavay, ex anchanu julchan va ay lapanaki kunaꞌ. Yu la ay kꞌatsan chavay, va jantu ay kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ex tejkan chuncha naul ni Jesús, va talaqchil lati ni fariseos, va tajunil: —Katꞌaxtꞌucha aniy. Kapiticha. Ni jalhachimoꞌonuꞌ Herodes va maqniputunan. ");
INSERT INTO tptNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ex ni Jesús va lakjunil: —Kalaqpꞌinchipitik ni anchanuꞌ jamakanunu xanixꞌoy. Kꞌaꞌunapitik va chavaycha kun lhiy kaklakmaxtuyaꞌ aqmoqxnun y kajkꞌuchꞌununaꞌ. Ex yu paqtꞌutunuꞌ kakmajkaniꞌoyaꞌ kilhitapatsa. ");
INSERT INTO tptNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero chavaycha kun lhiy kun tꞌuxaun maqskꞌiniy kaktaylhaꞌal kilakatin. Qayntaun yu laqputeꞌey ixchivinti Dios maqskꞌiniy kanil laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalén, xalapanakni Jerusalén. Jamaqniyatꞌik yu talaqputeꞌey ixchivinti Dios y laktꞌalmaqniyatꞌik yu tamalaqachaniyan Dios. Tacha ni piyuꞌ jamaqxtoꞌa sasꞌatꞌan la ixpaqachuj, va chuncha ni kitꞌin aqlhuvaj xaklalhistakputunau pero jantu aqtaun kꞌaꞌuyujnauntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kꞌalaqtsꞌintꞌikcha, minchaqakꞌan kamakaunkanacha. Chavay klajunau, jantucha aqtaun kilalaqtsꞌinchoqoyau tus tejkan inchine kꞌanaunapitik: “Ay kamakakal yu mintacha la ixtaqaꞌuti ni Jalhachimoꞌonu Dios.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Taun xajulchan jastaknati al vayaꞌ ni Jesús la ixchaqaꞌ qayntaun xaꞌukxtin fariseos. Lati ni fariseos va ixtalaqtsꞌin ni Jesús incha kamakal tuꞌuchun yu jantu kapaxtoqnil ixlhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ex ancha la ixtalakaꞌukxpuꞌ ni Jesús ixyal qayntaun lapanaki va ixlakakꞌunta. ");
INSERT INTO tptNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ex ni Jesús jalaqxaqalal ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Va laklhisakmil: —¿Tis va sun najun kilhachimoꞌonkꞌan? ¿Va lhinaunkan jakꞌuchꞌunti xajulchan jastaknati u jantu? Pero yuꞌuncha va saq taval. ");
INSERT INTO tptNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ex ni Jesús chꞌapal ni taqanꞌan, va palay makal, va malaqachachoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ex lakjunil ni alati lapanakni: —Uxiknankꞌan va katajqajul mimburrokꞌan u mivakaxkꞌan lakxkan va niman kꞌamakꞌutꞌutꞌik mas va xajulchan jastaknati. ");
INSERT INTO tptNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ex yuꞌuncha jantu lay tuꞌuchun katanaunchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ex tejkan taꞌaqtayl tataulay laka mesa, jalaqtsꞌil ni Jesús tachun yu ixlaklhijunkan vayti, va tataulputun taꞌan tataulay yu lajꞌay lapanakni. Ex va lakjunil ni aniy chivinti yu xtaꞌa jatapastakꞌati: ");
INSERT INTO tptNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Tejkan lhiꞌunkꞌanatꞌik kapꞌintꞌik xalakvayti lakxtuklati jantu kꞌalaksaktꞌik taꞌan tataulay ni lajꞌay lapanakni. Ka va lay kachil ataun lapanaki yu apalay ay xajantu uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ex yu xalhinaunaꞌ kalaqminan y kajunan: “Kꞌaxtaqnin ni mimputaulan yu ataun lapanaki.” Ex katꞌamaxaniyeꞌe, katꞌauleꞌe alakataun putaulan taꞌan tataulay yu xalakstꞌuniy. ");
INSERT INTO tptNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Xlhiyucha tejkan kalhiꞌunkꞌaneꞌe kapiti vayaꞌ, ex kataꞌul taꞌan tataulay yu jantu lajꞌay lapanakni. Ex chuncha yu xalhinaunaꞌ kalaqminan va kajunan: “Laqaj, kꞌatꞌapꞌas taꞌan tataulay yu lajꞌay lapanakni.” Ex chuncha jantu katꞌamaxaniyeꞌe la ixtalakaꞌukxpukꞌan tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tachun yu lajꞌay takꞌatsan va lakstꞌuniy kalakmakakanaꞌ pero tachun yu lakstꞌuniy takꞌatsan va lajꞌay kalakmakakanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ex chuncha ni Jesús junil ni xalhinaunaꞌ: —Tejkan makꞌay lakvayti jantu vamun kꞌalaklhiꞌun miꞌamigos ali mintꞌalaqaunin ali milapanakni ali mintꞌataulnin yu maqalinin. Jantu chuncha kꞌamakꞌatꞌi. Va katalhijunchoqoyan la ixchaqakꞌan ex chuncha va tapaxanti jun. ");
INSERT INTO tptNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero tejkan makꞌay lakvayti kꞌalaklhiꞌun ni kilpatanin ali ni lakmaknin ali ni talaknin ali ni laꞌachꞌixin. ");
INSERT INTO tptNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ex chuncha kalhitsꞌukꞌuyeꞌe achati, va por jantu lay katamapalchoqoyan. Pero kꞌamapꞌalchꞌoꞌonikꞌaneꞌe tejkan katakujchoqoyaꞌ tachun yu tanitacha yu jamalaqtaxtukantacha. ");
INSERT INTO tptNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ex chuncha tejkan qasmaklhi qayntaun yu ancha ixvil laka mesa, va naul: —Ayaj kataꞌachanaꞌ tachun yu katavaynaꞌ taꞌan kalhachimoꞌonunaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ex ni Jesús va junil: —Taun julchan qayntaun lapanaki ixmakay taun ay lakvayti va ixlaklhijunita lhuvaj lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ex tejkan lakachilcha xahora lakvayti va malaqachal ixꞌoqxtamati para kalakjunil yu laklhijunkanta: “Kapꞌintꞌikcha, alinꞌojoycha tachun ni vayti.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ex tachun ixlaklhijunkanta taꞌaqtaynil naunan ni jantu lay kataꞌanaꞌ. Pꞌunaj va junil qayntaun: “Va kꞌilkaꞌ aqxtaun tꞌun. Ikmaqskꞌiniy kteꞌen laqtsꞌiniꞌ. Kꞌaꞌuneꞌe miꞌukxtin va kimalaqmixinil.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ex yu aqayntaun naul: “Va aniykaꞌ kꞌil laqakis par vakaxna yu tatapatsay laka kuxtu. Va klaqlaqtsꞌinputun incha lay katatapatsal u jantu. Kꞌaꞌuneꞌe miꞌukxtin va kimalaqmixinil.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ex aqayntaun naul: “Va aniykaꞌ klakxtuklata, xlhiyucha jantu lay kꞌanachal.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ex ni oqxtamati laqchaanchoqol ixꞌukxtin va puteꞌeniꞌol yu tanaul. Ex ni ukxtin aqtaylcha lukujlay. Va junchoqol ni oqxtamati: “Kꞌapꞌinchꞌiy lakatinixnan laka putaulan. Kꞌalaklhitꞌanchiy ni kilpatanin ali ni lakmaknin ali ni talaknin ali ni laꞌachꞌixin.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ex chuncha chinchoqol ni oqxtamati, junchoqol ixꞌukxtin: “Ikmakalcha yu naꞌun pero vananaj xajyachal taꞌan katataulal laka mesa.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ex va naunchoqol ni ukxtin: “Kꞌapꞌinchꞌoꞌochiy lakatinixnan maqspaꞌ ni putaulan kalaklhiꞌun laqatapꞌasta katamil vaynin. Kitꞌin knajun kataꞌaqtsamal vaynin la kinchaqaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Klajunau ni lapanakni yu ixlaklhijunkanta yu jantu katamil vaynin, yuꞌuncha jantu katakilkꞌatsayaꞌ ni lakvayti. ");
INSERT INTO tptNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ex chuncha ixtalhavaxtu ni lapanakni ixtatꞌaꞌan ni Jesús. Ex ni yucha talaqaspꞌiklhi, va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Mas va taꞌayucha yu apalay toꞌoyay ixpay, ixnati, ixanati, yu sasꞌatꞌan, yu ixtꞌalaqaunin, yu ixtꞌalapanakni xajantu kitꞌin, ex ni yucha jantu lay jun kintꞌaltanaꞌ. Vachu yu apalay toꞌoyay ixjatsukunti xajantu kitꞌin, jantu lay jun kintꞌaltanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yu jantu laqaꞌiputun maqanlqajnati tacha kitꞌin, yucha jantu lay jun kintꞌaltanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xataꞌayuꞌ uxiknankꞌan incha kamakꞌapꞌutꞌu putanꞌay chaqaꞌ, pꞌunaj katꞌaꞌul, kꞌapꞌastꞌaktꞌi tachuncha ixtapal kunaꞌ para kakꞌatsꞌatꞌi incha kalaqchaꞌaniyan yu lhitꞌaꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Incha jantu kapastakꞌel, ex tejkan kꞌamakꞌaꞌoj ni xaputayan chaqaꞌ, jantu kalaqchaanaꞌ mintumin para kamajkꞌanitꞌi. Ex tejkan katalaqtsꞌinaꞌ ni lapanakni kataꞌaqtayniyancha laktuꞌunun. ");
INSERT INTO tptNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Katanaunaꞌ: “Aniy lapanaki ixꞌaqtajitacha makan ixchaqaꞌ pero jantu kamajkanil.” ");
INSERT INTO tptNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Vachuꞌ incha qayntaun la ay lhachimoꞌonuꞌ yu lhitꞌajun laqakau mil tropas, talachꞌapaputun ixtꞌalhachimoꞌonuꞌ yu lhitꞌajun pꞌuxaun mil ex pꞌunaj kapastakꞌelal incha lay katalhajal. ");
INSERT INTO tptNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ex incha najun jantu lay kalhajal, ex malaqachay lapanaki para kalhisakmil tas katamakal para jantu katalachꞌapal. Chuncha kamakayaꞌ tejkan vananaj la maqati mintachal ixtꞌalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ex vachu va chuncha uxiknankꞌan. Incha jantu makaꞌun tachun yu lhitꞌaꞌun ex jantu lay un kintꞌaltanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ni matsati la ox pero tejkan jantucha sꞌoꞌo jun ex jantucha lay sꞌoꞌo junchoqoy. ");
INSERT INTO tptNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Chuncha mas va para ni lakatꞌun, mas va para laka abono, jantu ox kaval. Valiꞌiy majꞌankan. Incha alin mimpaqasmakkꞌan, ex kaꞌasmaktꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ancha tachaꞌal lhuvaj jachꞌinin impuestos kun alati laktuꞌunun lapanakni para kataqasmaklhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ex chuncha ixtapastaklhitꞌajun ni fariseos kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Va siya yuꞌuncha talajunil: —Aniy lapanaki jalaqaꞌiy yu maqtaqalhinin y va laktꞌavajin. ");
INSERT INTO tptNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ex ni Jesús lakjunil taun chivinti yu xtaꞌa jatapastakꞌati, va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Xataꞌayu uxiknankꞌan yu kalhitsukul taun ciento borrego y va kamaqatsꞌanqal laqataun, ex yucha kalakmakaul yu noventa y nueve, y va kapuxkaul yu tsꞌanqay tus katemal. ");
INSERT INTO tptNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tejkan katemachoqol va kaꞌaqxoꞌol kun achati. ");
INSERT INTO tptNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ex tejkan kachil laqa chaqaꞌ, va kalaqmaqxtoqlhi ixꞌamigos kun ixtꞌataulnin, va kalakjunil: “Kilatꞌaꞌachanchoqoocha. Ni borrego yu istsꞌanqata chavay ktemachoqolcha.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Vachu va chun klajunau, mas kaꞌalil noventa y nueve lapanakni yu jantu katalhitsukul ixtalaqalhinkꞌan, pero va apalay talhiꞌachantajuy yu tavilanachal laktꞌiyan tejkan mapaxay ixjatapastakꞌati qayntaun maqtaqalhiniꞌ lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Vachu va chun incha kaꞌalil qayntaun xanati yu kalhitsukul aqxkau tumin pero kamaqatsꞌanqal aqxtaun, ex kamamaqtiyal ixmaklku, va kapalnal ixchaqaꞌ, va kapuxkauꞌol laksniy laksniy tus katemachoqol ixtumin. ");
INSERT INTO tptNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ex chuncha tejkan katemachoqol va kalakjuntaꞌil ixꞌamigas kun ixtꞌataulnin, kalakjunil: “Kilatꞌaꞌachanchoqoocha. Va iktemachoqol ni tumin yu xakmaqatsꞌanqata.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Va chuncha klajunau va ayaj talhiꞌachantajuy ixmayulnin Dios tejkan makajun ixtalaqalhin mas va qayntaun lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ex naunchoqol ni Jesús: —Qayntaun lapanaki ixlhitꞌajun qayntꞌuy istsꞌalan. ");
INSERT INTO tptNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ex yu xapꞌisaqa junil ixpay, va naul: “Kimpay kꞌatꞌi, kꞌixtꞌaqnin ni milhitapatsa yu kimpaxtoqniy kitꞌin.” Ex chuncha ni ixpay va xtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Taval ni xapꞌisaqa lakstꞌaꞌol yu lvaqnikal maqaliti, ex va maqati al, lhaꞌanꞌol yu ixtumin. Ancha ixpumaqtaqalhin pulaqamananꞌol ni ixtumin. ");
INSERT INTO tptNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ex chuncha tejkan laqamananꞌolcha, va alil ay chavan ancha taꞌan ixvil. Ex va aqtayl majkꞌatsay ixchavan. ");
INSERT INTO tptNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Taval ni tsꞌal va al kuxtutiyan kun qayntaun lapanaki yu ancha machaqaꞌ. Va xtaqnikal lhitapatsa va kalakvaval pꞌaxnin. ");
INSERT INTO tptNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ex va ayaj ixchavaniy tus ixlhiꞌotsaputun ni xataltsꞌi ni kꞌiu yu ixtaꞌuy ni pꞌaxnin pero jantu matichun kaxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ex va pastakchoqol va naul: “Ni kimpay va qaynlhuvaj ixꞌoqxtamatin y la alin ixvaytikꞌan, pero aniy kitꞌin iktiniycha kinchavan. ");
INSERT INTO tptNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Chavaycha kitꞌin kꞌanchoqoyaꞌ la ixchaqaꞌ kimpay, kajkꞌunaꞌ: Kimpay kꞌatꞌi, ikmakanil laqtaqal ni Dios y vachu uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Chavaycha jantucha lay kakval mintsꞌal. Va knajun kꞌimakꞌatꞌi tacha qayntaun miꞌoqxtamati.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ex chuncha ni tsꞌal anchoqol la ixchaqaꞌ ixpay. ’Tejkan vananaj la maqati para ixlaqchaꞌal, yu ixpay va laqtsꞌil istsꞌal. Va ayaj mapaynil, va takyauꞌal taꞌan ixpuminta ni istsꞌal, va laqatanul, va kiltastuklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ex naul ni tsꞌal: “Kimpay kꞌatꞌi, ikmakanil laqtaqal Dios y vachu uxintꞌi. Jantucha lay kakval mintsꞌal.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ni ixpay va naul: “Oqxtamatin, kasoꞌotꞌik, kꞌalhitꞌanchipitikcha yu mas apalay ox laqchꞌiti y va kꞌamulanichipitik kintsꞌal, vachu kꞌamamaqtꞌanutꞌik ixmaqtanuti y kꞌamachꞌantꞌanutꞌik isapato. ");
INSERT INTO tptNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kalhitꞌantꞌik ni sasꞌatꞌa vakax yu apalay onta y kꞌamaqnitꞌik. Kamakayau kꞌatan y kaꞌalinaꞌ lakvayti. ");
INSERT INTO tptNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yu aniy kintsꞌal mas va tacha ixnitacha pero chavay va kujchoqolcha. Mas va istsꞌanqatacha pero chavay temachoqoocha.” Ex aqtaynilcha ni kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ni xajayaꞌ va ixtꞌajun tapatsan laka kuxtu. Tejkan chinchoqochal laqa chaqaꞌ qasmaklhi ni jasanti kun jatꞌinti. ");
INSERT INTO tptNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ex juntaꞌil qayntaun maqtsukuꞌ va lhisakmil: “¿Sun makꞌayatꞌikcha?” ");
INSERT INTO tptNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ex naul ni maqtsukuꞌ: “Va chinchoqol mimpꞌisaqa y mimpay lhinaul katamaqnil ni sasꞌatꞌa vakax yu apalay onta va por ox xachinchoqoy mimpꞌisaqa.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ex ni xajayaꞌ va lukujlal va jantu katanuputul. Ex chuncha ixpay taxtul, va tapayninil para katanul. ");
INSERT INTO tptNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero va naul ni istsꞌal yu xajayaꞌ: “Kꞌatsꞌaycha va maqancha iktapatsaniyan, jantu aqtaun kꞌakchꞌintaman, pero uxintꞌi jantu aqtaun kꞌixtꞌaqnin ni kitꞌin mas va laqataun chivo para kakmakal kꞌatan kun kiꞌamigos. ");
INSERT INTO tptNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero chavaycha chinchoqol yu aniy mintsꞌal yu laqamananꞌol mimaqaliti kun maqtaqalhinin xanatin y uxintꞌi tus va lhimaqnitꞌicha ni sasꞌatꞌa vakax yu apalay onta.” ");
INSERT INTO tptNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ex va naul ni ixpay: “Kesꞌatꞌa kꞌatꞌi, uxintꞌi va tacha kꞌintꞌaviltꞌi y tachun yu klhitꞌajun va si minavin. ");
INSERT INTO tptNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero va maqskꞌiniy kamakau kꞌatan y kaꞌachaxꞌiu. Yu aniy mimpꞌisaqa ixnitacha y chavaycha va kujchoqotacha. Va istsꞌanqatacha y chavaycha temachoqoocha.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ex chuncha ni Jesús vachu lakjunil ixtꞌaltanan: —Qayntaun maqaliꞌ ixlhitꞌajun yu xaꞌay ixꞌoqxtamati yu xatsꞌoqmulanaꞌ. Ex va tislajmakal ni anchanu xaꞌay oqxtamati va junkal ni ixꞌukxtin tꞌaunꞌojoycha maqatsꞌanqan ixmaqaliti. ");
INSERT INTO tptNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ni ixꞌukxtin juntaꞌil, va junil: “Va ijkꞌatsaycha yu makꞌatꞌa. Chavaycha kꞌixtꞌaqnin kuenta kilhitapatsa. Kꞌiꞌuneꞌe tachuncha kintalhaanin ni lapanakni. Jantucha kꞌaꞌuneꞌe yu xaꞌay kiꞌoqxtamati.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ex va pastaklhi xꞌaman ni xaꞌay oqxtamati: “Kimamakaunilcha lhitapatsa ni kiꞌukxtin. ¿Chavay tas kaklayacha kaktapatsal? Jantu kꞌayajnan kaktapatsal, va jantu kaklhitsukul tapꞌasta. Jantu kpuskꞌinputun, va ikmaxanan. ");
INSERT INTO tptNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ay! Kitꞌin kꞌatsaycha suncha kakmakayaꞌ para kaꞌalil lapanakni yu kintalaqaꞌiyaꞌ la ixchaqakꞌan tejkan jantucha xaꞌay oqxtamati kajkꞌunaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ex chuncha va laktꞌasaꞌil qayntaun por qayntaun yu ixtalhaaniy ixꞌukxtin. Yu pꞌunaj va lhisakmil: “¿Tachuncha lhipꞌinin ni kiꞌukxtin?” ");
INSERT INTO tptNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ex va naul ni lapanaki: “Va taun ciento barriles aceite.” Ex va junil: “Aniy minkuenta. Kꞌasoꞌo, katꞌaulchiycha, katsꞌoqmulachiy vamun cincuenta.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ex va lhisakmil aqayntaun: “¿Uxintꞌi tachuncha lhipꞌinincha?” Ex va naul ni lapanaki: “Va klhaaniy cien medidas trigo.” Ex ni xaꞌay oqxtamati va junil: “Aniy minkuenta, katsꞌoqmulatꞌi vamun ochenta.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ex chuncha kꞌatsalcha ni ixꞌukxtin tacha makal ni xaꞌay ixꞌoqxtamati y va naul: “Va mero listuj yu xaꞌay kiꞌoqxtamati yu jantu ox, la lhuvaj jatapastakꞌati ixpumakanunun.” Vachu va chuncha yu taꞌalin lakamunukpaꞌ yu jantu talhakapuꞌanan, apalay tamakay kuenta tacha katamakal. Yu tamispay ixchivinti Dios, apalay jantu tamakay kuenta tacha maqskꞌiniy katamakal. ");
INSERT INTO tptNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Vachu klajunau kꞌalaqꞌaqtꞌayꞌutꞌik ni kilpatanin kun tachun yu lhitꞌaunatꞌik ni aniy lakamunukpaꞌ, va para kaꞌalil miꞌamigoskꞌan. Kꞌamakꞌaunapitik yu lhitꞌaunatꞌik tejkan kaniyapitik, pero kalaꞌaꞌikꞌanapitik ancha xachaqan laktꞌiyan yu jantu aqtaun katamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Yu lapanaki yu ox makay kuenta yu lhitsukuy mas va tsꞌuniy, ex vachu ox kamakal kuenta incha la lhuu kalhitsukul. Chavay yu jantu makay kuenta yu lhitsukuy mas va tsꞌuniy, ex vachu jantu lay kamakal kuenta incha la lhuu kalhitsukul. ");
INSERT INTO tptNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vachu va chun incha jantu makꞌayatꞌik kuenta mas va tumin yu lay tamapastakniyan yu jantu ox, ex ni Dios jantu kataxtaqniyan kamakꞌatꞌik kuenta yu laqsaval lajꞌoxi. ");
INSERT INTO tptNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Vachu incha jantu makꞌayatꞌik kuenta yu machꞌixtꞌaqnikꞌanatꞌik, ex jantu kaxtꞌaqnikꞌanapitik yu tapaxtoqniyan. ");
INSERT INTO tptNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jantu matichun lay oxi katapatsanil qayntꞌuy ukxtinin. Kaꞌachaniyaꞌ yu qayntaun y kaxkayyaꞌ yu aqayntaun. Va katꞌaꞌanaꞌ yu qayntaun y jantu kamakayaꞌ kuenta yu lhinajun yu aqayntaun. Vachu va chuncha jantu lay tꞌapꞌatsꞌaniy ni Dios incha tꞌoꞌoyay yu maqaliti. ");
INSERT INTO tptNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ni fariseos yu ixtatꞌajun qasmaknan ni Jesús va ayaj ixtalhiꞌajin ixtuminkꞌan. Ex vamun talaktuꞌul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Pero ni Jesús lakjunil: —Uxiknankꞌan va meꞌemankꞌan makꞌakꞌanatꞌik para katalhilal ni lapanakni va la ox metsukuntikꞌan. Pero Dios tamispaniyan yu melhanutikꞌan. Ni Dios jantu pastakꞌa tacha lapanakni. Yu la lajꞌoxi talhilay ni lapanakni va yucha ni Dios lakxkajiy. ");
INSERT INTO tptNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Tejkan jantukaꞌ istsukuy ni Juan, yu ixlhachimoꞌon Moisés kun ixchivintikꞌan yu maqancha ixtalaqputeꞌey ixchivinti Dios va yucha tapukꞌatsal tisuncha katamakal ni lapanakni. Pero tejkan mil ni Juan tus chavaycha jalaqputeꞌenikal ni lapanakni tacha lhachimoꞌonun ni Dios. Tachun tatapꞌasniy kalaklhichimoꞌol ni Dios la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Apalay va tsꞌayl kamiꞌol ni laktꞌiyan kun lakamunukpaꞌ xajantu yu lhinajun Dios, mas va laqatauncha chivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Mas va taꞌayucha yu makajun ixanati y tꞌatsukuchoqoy aqayntaun yucha makay talaqalhin. Vachuꞌ makay talaqalhin yu tꞌatsukuy qayntaun xanati yu valiꞌiy makaunkanta. ");
INSERT INTO tptNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ex va naunchoqol ni Jesús: —Taun julchan ixꞌalin qayntaun maqaliꞌ yu va si ixlakatayay yu la kꞌus ixlaqchꞌiti, yu laqlhuu xtapal y lhilhiy ixmakay yu ayaj kꞌus kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Vachu ixꞌalinta qayntaun kilpataniꞌ ixjunkan Lázaro. Taun taun julchan va ixmamakan la ixkiltalakxtuti ixchaqaꞌ ni anchanu maqaliꞌ. Ni yucha va ixlakapuchꞌiꞌojota tachun ixlakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yucha ixꞌuputun mas va yu ixpatajuy laka mesa yu ixtacheꞌe ni maqaliꞌ. Vachuꞌ ni xꞌoyun ixtasnauniy ixlakapuchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ex chuncha taun julchan va nil ni kilpataniꞌ, yu ixmayulnin Dios va talhaꞌal ixlhitsukunuꞌ taꞌan vilchal Abraham. Taval vachuꞌ nil ni maqaliꞌ, va maknukal. ");
INSERT INTO tptNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ex alcha laqnin ni maqaliꞌ. Ancha ayaj majkꞌatsal. Ex va lakachaꞌal la maqati, va laqtsꞌil ni Abraham y vachu laqtsꞌil Lázaro va tꞌavil ni Abraham. ");
INSERT INTO tptNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ex va la pꞌas tꞌasanil, va naul: “Kimpay kꞌatꞌi Abraham, iktapayniniyan kꞌiꞌaqtꞌayꞌutꞌi. Kꞌimalaꞌachꞌanin Lázaro. Va kimil avaniniꞌ kun xkan la kisimaꞌati. Mas va kun makatꞌuniy ixmakaꞌ para kimatsukꞌunkꞌulcha taꞌan iktꞌajun maqanlqajnan laka jikmi.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ni Abraham va naul: “Kintsꞌal, kapꞌastꞌaktꞌi va ixlaꞌaꞌiy tachun yu lajꞌoxi tejkan ixtꞌaꞌun ni lakamunukpaꞌ. Pero ni Lázaro tejkan ixtꞌajun ni lakamunukpaꞌ va ayaj ixmajkꞌatsay. Chavaycha yucha alin ixꞌachati aniy, pero uxintꞌi majkꞌatsaycha. ");
INSERT INTO tptNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Vachu ixpakltaun uxintꞌi kun kijnankꞌan ancha japukutunti. Yu vilchil jantu lay takukyachal, mas kaꞌuxaꞌanchal, y yu vilchal jantu lay takukyachil.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ex va naul ni maqaliꞌ: “Ex iktapayniniyan, kimpay kꞌatꞌi, kꞌamalaꞌachꞌatꞌi Lázaro la ixchaqaꞌ kimpay. ");
INSERT INTO tptNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ancha alin pumakis kintꞌalaqaunin, kalaqlaqputeꞌenil tacha tapasaycha para jantu katamil majkꞌatsanan aniy vachu.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ex va naul ni Abraham: “Yuꞌuncha talhitꞌajun ixchivinti Moisés kun yu ixtalaqputeꞌey ixchivinti Dios. Va kataqalasmaklhi ni yuꞌuncha.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ex va naunchoqol ni maqaliꞌ: “Jantu chuncha, kimpay kꞌatꞌi, Abraham. Jantu ox taqasmatꞌa ixchivinti Dios. Pero va kalaqlaqchaꞌal qayntaun janiniꞌ yu kujchoqotacha ex katamapaxal ixjatapastakꞌatkꞌan.” ");
INSERT INTO tptNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ni Abraham va junil: “Incha jantu talhakapuꞌaniy ni Moisés kun yu ixtalaqputeꞌey ixchivinti Dios, ex nisin jantu katamapaxal ixputsukukꞌan mas va kakujchoqol qayntaun janiniꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ex ni Jesús lakjunil ixtꞌaltanan: —Si kaꞌalinaꞌ yu maqtaqalhinin pero paynicha yu jamalaniy lapanakni para katamakal yu jantu lajꞌoxi. ");
INSERT INTO tptNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Apalay ox kaval kapixtuchꞌimukꞌakal xachiyux pachꞌikni y kamajꞌankalcha lakamar. Apalay lhitaꞌay kunaꞌ incha kamamaqtaqalhinil qayntaun lakatꞌuniy tacha yu aniy jasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","La ox kꞌalhistꞌajkꞌantꞌik. Incha milaqaj makaniyan yu jantu ox, ex kꞌaxaꞌalatꞌi. Incha mapaxay ixjatapastakꞌati, ex kꞌamalaqmixinin. ");
INSERT INTO tptNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Incha makaniyan yu jantu ox mas va aqtujun laka julchan y aqtujun mapaxachoqoy ixjatapastakꞌati ex kꞌamalaqmixinin. ");
INSERT INTO tptNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ex yu ixtamalaqachan ni Jesús va tajunil: —Kilaꞌaqtayjuu para apalay ox kaval kilhakapuꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ex chuncha ni Jesús va lakjunil: —Mas va tsꞌuniy milhakapuꞌatikꞌan tacha yu lakatꞌuniy xataltsꞌi mostasa, ex lay unatꞌik ni aniy kꞌiu katakuklhi, kachꞌankal ixꞌaman lakamar y va chuncha kunaꞌ yu unatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Xataꞌayuꞌ uxiknankꞌan va kaꞌalil miꞌoqxtamatikꞌan va kaloqnul u va kalhistaklhi mimborregoskꞌan. Ex tejkan kaminchoqol laqa chaqaꞌ jantu kꞌaꞌun: “Kasoꞌo, katꞌaulchiycha, kavaynchiycha.” ");
INSERT INTO tptNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Va kꞌaꞌun: “Kꞌalaꞌoxitꞌi kivayti, kꞌamapꞌaxa milaqchꞌiti, kimunincha kivayti, kitꞌin pꞌunaj kakvaynaꞌ, uxintꞌi astan.” ");
INSERT INTO tptNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Vachuꞌ jantu paxtoqniyan kꞌaꞌun: “Malaqpuchuncha” tejkan kamakaꞌol ixlhitapatsa yu lhiꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Vachu va chuncha uxiknankꞌan tejkan kꞌamakꞌaꞌoyapitik tachun yu talhijunan Dios va kꞌaꞌunitꞌik: “Ka jantu ox oqxtamatin kuntau. Vamun ikmakau yu kilalhijuniu.” ");
INSERT INTO tptNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ex chuncha tejkan ixꞌanta tus Jerusalén ni Jesús va ixtiꞌukxuyal taꞌan paqxtoꞌa ni xaꞌestado Samaria kun xaꞌestado Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ex tejkan chaꞌal taun lakatꞌuniy putaulan ancha talapaxtoqlhi pumakau lapanakni, va ayaj ixtalakapuchꞌita. Va amaqati tatꞌasanil, va tajunil: ");
INSERT INTO tptNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Jesús jamalaniniꞌ, kilamapayniu kijnankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ex tejkan ni Jesús jalaqtsꞌil va lakjunil: —Kapꞌintꞌik tasuninin ni kuras. Ex chuncha tejkan ixtaꞌanta lakatin, va ancha palaycha tajunꞌol ixtaqanꞌatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ex chuncha qayntaun xataꞌayuꞌ makal kuenta ni oxicha ixjunchoqota, va taspꞌikchoqol, va la pꞌas aqtayl ay makay ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Va talakaputal taꞌan ixyal ni Jesús, aqtayl skꞌiniy lhimalaqpuchuncha. Ni yucha va machaqaꞌ Samaria. ");
INSERT INTO tptNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ex naul ni Jesús: —Va pumakau yu palay tajunchoqol. ¿Toꞌoxtaycha ixtaꞌan yu pumanajatsi? ");
INSERT INTO tptNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Vamun yu aniy yu jantu israelita kaval taspꞌikchoqolcha para ay kamakal ni Dios? ");
INSERT INTO tptNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ex ni Jesús va junil ni jachꞌiniꞌ: —Kaꞌostꞌaꞌulcha, kapꞌinchꞌoꞌocha. Va kꞌilhakꞌapꞌupꞌicha, xlhiyucha oxicha xaꞌunchꞌoꞌoy. ");
INSERT INTO tptNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ex chuncha ni fariseos va talhisakmil ni Jesús tavanancha kalhachimoꞌonunaꞌ ni Dios. Ex lakjunil ni Jesús, va naul: —Jantu katasuyaꞌ tejkan kaꞌaqtayaꞌ kalhachimoꞌonunaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nisin jantu lay katanaul: “Kalaqtsꞌi. Va aniy yal”, u “Avintꞌi vilchal.” Jantu lay chuncha kanaunkal. Ni Dios lhachimoꞌonunta la ixjatsukuntikꞌan ixlapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ex lakjunil ixtꞌaltanan ni Jesús: —Kaminaꞌ julchan kilalaqtsꞌinputunchoqoyau kakminchoqol ni kitꞌin yu Sasꞌatꞌa Lapanaki para kaklhichimoꞌol pero jantukaꞌ lay kilalaqtsꞌinau. ");
INSERT INTO tptNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Va katajunan lapanakni: “Aniy yal”, u “Avintꞌi vilchal.” Pero jantu kꞌapꞌuxkꞌautꞌik, jantu kamakꞌaꞌuntꞌik milhitapatsakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ni makaliukniti va tasuꞌojoy tachun ni laktꞌiyan y vachu va chun kunaꞌ tejkan kakminchoqoyaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero maqskꞌiniy kakmaqanlqajnanꞌelal ni kitꞌin yu kval Sasꞌatꞌa Lapanaki y vachu kintaꞌakchꞌintamaꞌelayaꞌ yu chavaycha tatꞌajun lapanakni, jantu kintalaqaꞌiyaꞌ para kaklaklhichimoꞌol la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tejkan kakminchoqoyaꞌ ni kitꞌin yu Sasꞌatꞌa Lapanaki vachu va chun kajunchoqoyaꞌ tacha ixjunita tejkan ixtꞌajun Noé. ");
INSERT INTO tptNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ni anchanuꞌ lapanakni ixtavajin, ixtaꞌoqnun, ixtalakxtuklay, ixtamalakxtuklhanan, y vamun yuꞌ ixtapastakta tus tejkan tanul Noé laka barco. Ex alil ay akskajꞌuti y tamuxtuꞌol tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Vachu va chuncha kajunchoqoyaꞌ tacha ixjunita tejkan ixtꞌajun Lot. Va ixtavajin, ixtaꞌoqnun, ixtastꞌanan, ixtaꞌiy axtoqnuꞌ, ixtamakay chaqan. ");
INSERT INTO tptNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero tejkan taxtul Lot ni putaulan Sodoma va taꞌeltajul laktꞌiyan jikmi kun azufre y va laqmaqniꞌol ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Vachu va chuncha kajunchoqoyaꞌ tejkan kaktasuchoqoya ni kitꞌin yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Tejkan kachinaꞌ ni anchanu julchan ex yu yal la ixꞌukxna chaqaꞌ jantu katanuchoqol iniꞌ yu ixnavin yu tanun la ixchaqaꞌ. Yu yal laka kuxtu jantucha kaꞌanchoqol la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kapꞌastꞌaktꞌik ni ixanati Lot val matsati tejkan talaqaspꞌiklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ni lapanaki yu ixꞌaman malaqtaxtuputun ixjatsukunti, yucha kamaqatsꞌanqayaꞌ. Pero yu maqxtaꞌa ixjatsukunti, yucha kalhitsukuchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Klajunau tejkan kakminchoqoyaꞌ katatamayaꞌ qayntꞌuy aqataun putaman. Qayntaun kalhaꞌankanaꞌ y yu aqayntaun katamakaunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Qayntꞌuy xanatin katatsukuyaꞌ skitinin. Qayntaun kalhaꞌankanaꞌ y yu aqayntaun katamakaunaꞌ.  ");
INSERT INTO tptNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Qayntꞌuy lapanakni katatapatsayaꞌ laka kuxtu. Qayntaun kalhaꞌankanaꞌ y yu aqayntaun katamakaunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ex talhisakmil yu ixtꞌaltanan: —Jalhachimoꞌonuꞌ, ¿toꞌoxtaycha chuncha katapasayaꞌ? Ex ni Jesús va lakjunil: —Va katasuyaꞌ vachu va tacha tasuy taꞌan alin yu janinin, va ancha tataqxtoꞌa ni lajꞌay tsꞌoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ex chuncha ni Jesús va lakmasunil taun chivinti yu xtaꞌa jatapastakꞌati para katakꞌatsal ni maqskꞌiniy si kataskꞌinil ni Dios y jantu katamakauntijlal. ");
INSERT INTO tptNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Va naul: —Qayntaun juez va ixvil taun putaulan. Ni yucha jantu ixtoꞌoyay Dios vachuꞌ jantu ixlaktoꞌoyay lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Vachuꞌ ancha ixvil qayntaun tiyau va ixꞌan chivintanun para kaꞌaqtayjukal. Va ixnajun, va junkan ni juez: “Kꞌilaqlaꞌoxinin ni lhilukuj kun kintꞌalaxkayaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero ni juez la maqan jantu ixlaqlaꞌoxiputun. Pero taval va naul la ixjatapastakꞌati: “Kitꞌin jantu iktoꞌoyay Dios vachuꞌ jantu klaktoꞌoyay lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero yu aniy tiyau va ayaj kimaqanchapuy, ka va kaklaqlaꞌoxiniyacha yu kiskꞌiniy para chuncha jantucha apalay kimaqanchapul.” ");
INSERT INTO tptNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ex va naul ni jalhachimoꞌonuꞌ Jesús: —Kꞌapꞌastꞌaktꞌik yu makal ni jalaktuꞌunuꞌ juez. ");
INSERT INTO tptNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ni Dios va ox, xlhiyucha apalay kalaqꞌaqtayjuyaꞌ ixlapanakni yu jalaksakta, yu si taskꞌiniy tunkuj y putsꞌista. ¿Lhilay va la maqan kalaqlaꞌoxiniyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Va klajunau ni jantu. Va niman kalaqꞌaqtayjuyaꞌ. ¿Pero lhilay ni kataꞌalinaꞌ yu chuncha talhakapuꞌan tejkan kakminchoqoyaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ex chuncha ni Jesús lakjunil ni aniy chivinti yu xtaꞌa jatapastakꞌati. Va lakjunkal ni lapanakni yu ixtanajun va lajꞌoxi ixtajunita y ixtalakchꞌintamay yu alati. Va inchine naul: ");
INSERT INTO tptNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Qayntꞌuy lapanakni taꞌal skꞌinin Dios laka ay lakatajtan. Qayntaun va fariseo ixjunita, yu aqayntaun va xachꞌiniꞌ impuestos ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ex ni anchanu fariseo va tayal va iskꞌin Dios, va naul: “¡Ay Dios kꞌatꞌi! Kitꞌin kxtaqniyan malaqpuchuncha ni jantu chun kakval tacha yu alati lapanakni yu alhavanan, yu makanunun, yu tatꞌatamay yu jantu ixnavinkꞌan kaval, y vachu jantu chun kakval tacha yu aniy chꞌinin impuestos. ");
INSERT INTO tptNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ni kitꞌin iktaskꞌajay paqtꞌuy laka semana. Vachu ikxtaꞌa tsꞌuniy kilhitapatsa”, va chuncha naul ni fariseo. ");
INSERT INTO tptNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero ni jachꞌiniꞌ impuestos va la maqati ixyal, jantu katalaqstꞌal laktꞌiyan. Va aqtayl tankilaksakan, va junil ni Dios: “¡Ay Dios kꞌatꞌi! Kꞌimapꞌaynitꞌicha ni kitꞌin klaktuꞌunuꞌ kunita”, va naul ni jachꞌiniꞌ impuestos. ");
INSERT INTO tptNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ex vachu naul ni Jesús: —Kitꞌin klajunau ni jachꞌiniꞌ impuestos yucha anchoqol la ixchaqaꞌ, va malaqmixinikal ixlaqtaqal, pero yu fariseo jantu kamalaqmixinikal. Yu xꞌaman makakan la ay, yucha ni Dios kamakayaꞌ lakatꞌuniy. Pero yu xꞌaman makakan lakatꞌuniy yucha ni Dios ay kamakayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ex chuncha lati ni lapanakni va talaklhiminil sasꞌatꞌankꞌan ni Jesús para kalaqmoqslanil ixmakaꞌ. Tejkan talaqtsꞌil ixtꞌaltanan ni Jesús, yuꞌuncha taꞌaqtayl jalaqꞌaymay para jantu katamaqanchapul. ");
INSERT INTO tptNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ni Jesús lakjuntaꞌil ni jasꞌatꞌan, va lakjunil ixtꞌaltanan: —Kꞌamakꞌauntꞌik ni jasꞌatꞌan para kintalaqmil. Jantu kꞌalakmaspꞌiktꞌik. Yu talhakapuꞌanan tacha jasꞌatꞌan, va yuꞌuncha yu laklhichimoꞌoy Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Laqsaval klajunau qayntaun lapanaki maqskꞌiniy kalaqaꞌil ni kalhichimoꞌol ni Dios vachu va tacha qayntaun jasꞌatꞌa laqaꞌiy kalhichimoꞌokal. Incha jantu, ex jantu aqtaun katanuyaꞌ taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ex chuncha qayntaun ay lapanaki va lhisakmil ni Jesús: —Jamalaniniꞌ, ox kꞌatꞌi, kꞌiꞌun suncha kakmakalcha para kaꞌalil ketsukunti yu jantu aqtaun kamiꞌol. ");
INSERT INTO tptNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ex ni Jesús junil: —¿Valiꞌiycha kꞌiꞌuniy ox kunita? Jantu matichun ox, vamun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Uxintꞌi kꞌatsꞌaycha tacha junita ixlhachimoꞌon Dios. Va najun jantu kꞌamaꞌanchꞌaꞌoluxnun, jantu kꞌamaqnin, jantu kaꞌalhavan, jantu kalaklkꞌan y katꞌoꞌoyatꞌi mimpay ali minati. ");
INSERT INTO tptNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ex va naul ni ay lapanaki: —Yucha tachun ikmakaꞌojotacha tejkan lakatꞌuniy xajkunita tus chavaycha. ");
INSERT INTO tptNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tejkan chuncha qasmaklhi ni Jesús, va naul: —Va tsꞌuniy tsꞌanqaniyan. Kastꞌaꞌocha yu lhitꞌaꞌun, kꞌalaqxtꞌaqnitꞌi kilpatanin. Ex chuncha kꞌalhitsꞌukꞌuyeꞌe milhilhajati laktꞌiyan. Ex katꞌatꞌicha, kꞌintꞌixkꞌaulhipꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tejkan chuncha qasmaklhi ni ay lapanaki va ayaj maqaninil, va ayaj maqaliꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tejkan ni Jesús chuncha laqtsꞌil maqaninil, ex va naul: —Ayaj lhitaꞌay katatanul ni maqalinin taꞌan lhachimoꞌonun Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Laqataun camello jantu lay tapasay taꞌan pusalal ni makskati. Pero apalay lhitaꞌay katatanul taꞌan lhachimoꞌonun Dios yu talhitꞌajun lhuvaj maqaliti. ");
INSERT INTO tptNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ex ni lapanakni yu ancha tayanal va tanaul: —¿Ex taꞌayuchacha lay katalaqtaxtul? ");
INSERT INTO tptNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ex ni Jesús lakjunil: —Yu jantu lay katamakal ni lapanakni, ni Dios yucha lay makay. ");
INSERT INTO tptNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ex chuncha ni Pedro va junil ni Jesús: —Pero ni kijnankꞌan ikmakaunꞌotaucha yu klhitꞌaunau para kaklatꞌaltanau. ");
INSERT INTO tptNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ex ni Jesús va lakjunil: —Laqsaval klajunau mas va taꞌayucha yu makajun ixchaqaꞌ, u ixpayan, u ixtꞌalaqaunin, u ixanati, u sasꞌatꞌan para Dios kalhichimoꞌol, ");
INSERT INTO tptNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ex ni yucha kalaqaꞌiyaꞌ alati aniy lakamunukpaꞌ y vachuꞌ kalaqaꞌiyaꞌ xatsukunti yu jantu aqtaun kamiꞌoyaꞌ tejkan kaminaꞌ yu ataun lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ex ni Jesús laklhaꞌal pumakautꞌuy ixtꞌaltanan alakataun, va lakjunil: —Chavaycha kaꞌanau laka putaulan Jerusalén. Ancha kaꞌalinacha tacha yu tatsꞌoqlhi yu maqancha ixtalaqputeꞌey ixchivinti Dios tejkan kintalhitsꞌoqlhi kitꞌin yu Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Va kakmaqxtaqkanaꞌ la ixtamakakꞌan yu jantu israelitas kataval, ex yuꞌuncha kintalaktuꞌuyaꞌ, pꞌas kintalhiꞌachanaꞌ, kintalakapuchujvayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ex kintalaqanaqmaꞌelayaꞌ ex kintamaqniyacha. Ex tejkan paqtꞌutu kunaꞌ, kajkujchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ixtꞌaltanan jantu katamalaqasil, jantu kalakmasunikal, jantu katakꞌatsal tas ixnaunputuntacha. ");
INSERT INTO tptNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ex chuncha tejkan va laycha kachaꞌal ni putaulan Jericó ancha ixvil qayntaun laꞌachꞌix, ixpuskꞌin tumin lakatin. ");
INSERT INTO tptNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tejkan qasmaklhi ni ixtatapasay lhuvaj lapanakni lakatin, ex va laklhisakmil ni laꞌachꞌix, va naul: —¿Suncha alin? ");
INSERT INTO tptNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ex yuꞌuncha va tajunil: —Va tꞌajun tapasanaꞌ ni Jesús yu machaqaꞌ Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ex tꞌasal ni laꞌachꞌix, va naul: —Jesús, istsꞌal kꞌatꞌi ni ay jalhachimoꞌonuꞌ David. Kꞌimapꞌaynitꞌicha kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yu ixtapꞌulanan ni lapanakni va talaqꞌaymal ni laꞌachꞌix para saqcha kaval pero yucha apalay matꞌasal. Va naul: —Istsꞌal kꞌatꞌi ni ay jalhachimoꞌonuꞌ David, kꞌimapꞌaynitꞌicha kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ex tayal ni Jesús, va malaqachanal ixꞌika. Ex tejkan laqchaꞌalcha, va lhisakmikal ni laꞌachꞌix: ");
INSERT INTO tptNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Suncha naꞌuncha kakmakanin? Ex ni laꞌachꞌix qaltayanal, va naul: —Jalhachimoꞌonuꞌ, va klakavananputun. ");
INSERT INTO tptNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ex va naul ni Jesús: —Kalakꞌavancha. Palaycha kꞌaꞌunchꞌoꞌo, va kꞌilhakꞌapꞌupꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ex va limancha lakavananchoqol, va tꞌaꞌal ni Jesús va ay ixmakay ni Dios. Tejkan talaqtsꞌil ni lapanakni yu tacha tapasal, tus tachun va ay tamakal ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ex ni Jesús tanul laka putaulan Jericó va ancha ixtapasaꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ancha ixꞌalin qayntaun lapanaki yu ixjunkan Zaqueo. Ni yucha va xaꞌukxtin jachꞌiniꞌ impuestos y va maqaliꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ni yucha ixmispaputun tacha tasuy ni Jesús. Pero la lhuvaj lapanakni ixtaꞌanta, jantu lay kalaqtsꞌil, va por jantu putanꞌay kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ex takyaujapꞌulal, va taukꞌal laka kꞌiu para lay kalaqtsꞌil, va ancha ixpuminta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ex tejkan ancha chaꞌal ni Jesús, talaqstꞌal laka kꞌiu, laqtsꞌil ni Zaqueo, va junil: —Va knajun kꞌapꞌatꞌaꞌutꞌicha, chavaycha kakloqojaꞌ la minchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ex va tsꞌalaj patajul ni Zaqueo, va achajlaqaꞌil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tejkan chuncha talaqtsꞌil ni lapanakni ex talhichivinil ni Jesús, va ixtalajuniy: —Ni Jesús va al loqojnuꞌ la ixchaqaꞌ qayntaun jalaktuꞌunuꞌ lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ex chuncha tayal ni Zaqueo, va junil ni Jalhachimoꞌonuꞌ Jesús: —Chavay, Jalhachimoꞌonuꞌ kꞌatꞌi, pakltaun kimaqaliti klaqxtaqniyaꞌ kilpatanin y va taꞌayucha yu ikmakanuxtunil kakxtaqnichoqoyachaꞌ aqtꞌati chuncha tacha kmaxtunil. ");
INSERT INTO tptNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ex chuncha va naul ni Jesús: —Chavaycha yu tatanumanal ni aniy chaqaꞌ va talaqtaxtutacha, vachu laqsaval ixpapanti Abraham junita. ");
INSERT INTO tptNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Kitꞌin yu kval Sasꞌatꞌa Lapanaki klakminta puxkaunaꞌ ni lapanakni yu tatsꞌanqatacha para kaklaqmalaqtaxtuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Va chuncha ni Jesús ixtꞌajun chivin y ni lapanakni ixtatꞌajun qasmaknan. Va lakjunil taun chivinti yu xtaꞌa jatapastakꞌati. Va laycha katachaꞌal yu la ay putaulan Jerusalén y yuꞌuncha ixtapastakꞌa ni Dios va niman ixlhachimoꞌonul. ");
INSERT INTO tptNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xlhiyucha va naul: —Qayntaun ay lapanaki va maqati al taꞌan ataun xalakatꞌun. Va al laqaꞌiniꞌ ixpalhachimoꞌon para kalaklhichimoꞌol ixtꞌamachaqan la ixtꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Va jalakjuntaꞌiꞌelal pumakau ixꞌoqxtamatin. Laqxtaqnil qayntamin lhuu tumin, va lakjunil: “Kꞌapꞌutꞌapꞌatsꞌatꞌik ni aniy tumin tus kakminchoqoyaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero yu lapanakni yu ancha ixtꞌamachaqan va ixtaxkajiy yu junputun lhachimoꞌonuꞌ. Tamalaqachal chivinti, va tanaul: “Kijnankꞌan iknaunau jantu kaval kiJalhachimoꞌonukꞌan.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero tejkan chinchoqol ni ay lapanaki la ixputaulan va ixlaqaꞌitacha ixpalhachimoꞌon. Jalakjuntaꞌil ixꞌoqxtamatin yu ixlaqxtaqnita tumin. Va ixkꞌatsaputun tacha tamakatacha qayntamin. ");
INSERT INTO tptNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yu pꞌunaj chinchal, va naul: “Jalhachimoꞌonuꞌ, chavay yu mintumin talhavatacha aqkau chuncha tacha kꞌixtꞌaqnin.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ex ni jalhachimoꞌonu va junil: “Ox oqxtamati kꞌatꞌi. Uxintꞌi la ox makꞌatꞌi mas va kun tsꞌuniy, xlhiyucha kꞌalhachꞌimoꞌonuneꞌe lakakau putaulan.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ex chinchal aqayntaun, va naul: “Jalhachimoꞌonuꞌ, chavay yu mintumin talhavatacha aqkis chuncha tacha kꞌixtꞌaqnin.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ex ni jalhachimoꞌonuꞌ va junil: “Ex uxintꞌi kꞌalhachꞌimoꞌonuneꞌe lakakis putaulan.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ex aqayntaun vachu chinchal, va naul: “Jalhachimoꞌonu, aniy mintumin. Va xakpachꞌimaꞌata la kimpayoj. ");
INSERT INTO tptNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Va xaktalhauniyan uxintꞌi. Ijkꞌatsay va la pꞌas milhachimoꞌon, va chꞌapꞌay yu jantu minavin y xꞌanan taꞌan jantu chꞌan.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ex ni jalhachimoꞌonu va junil: “Kun minchivinti meꞌeman mapꞌukꞌan mintalaqalhin. Laqsaval ixkꞌatsay ni va la pꞌas kilhachimoꞌon y va ikchꞌapay yu jantu kinavin y ikxqanan yu jantu ikchꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Ex valiꞌiychacha jantu kꞌamanutꞌi kintumin laka banco? Ex chuncha kitꞌin xaklhajal sasꞌatꞌa tejkan ikchinchoqol.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ex lakjunil yu ancha tayanal: “Kꞌamaxtꞌunitꞌikcha ni tumin, kaxtꞌaqnitꞌik yu lhajal aqkau chuncha tacha kxtaqnil.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yuꞌuncha tajunil: “Pero, jalhachimoꞌonuꞌ, yucha lhitꞌajuncha aqkau chuncha tacha xtꞌaqnin.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ex ni jalhachimoꞌonu lakjunil: “Klajunau mas yu lhitꞌajuncha, kaxtaqnikanaꞌ alati. Pero yu jantu tuꞌuchun kalhitsukul, mas va tsꞌuniy yu lhitꞌajun kamaxtunichoqokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chavaycha kalaklhitꞌantꞌikcha aniy ni lapanakni yu kintaxkajiy yu jantu ixkintajuniy xaklhachimoꞌonul. Aniy kꞌalaqmaqniꞌotꞌikcha la kintꞌalakaꞌukxpuꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Taval tejkan chuncha naul ni Jesús va taylhaꞌal ixlakatin para kachaꞌal Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Tejkan va laycha kachaꞌal lakatꞌuy putaulanin yu lakjunkan Betfagé y Betania yu ukstsꞌuniy ni aspajun yu junkan Olivos, ex jalaqmalaqachal qayntꞌuy ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Va lakjunil: —Kꞌapꞌinchꞌipitik ni lakatꞌuniy putaulan yu ancha vil. Ex taꞌan kachꞌipꞌinapitik, katꞌemayapitik laqataun sasꞌatꞌa burro chꞌiꞌulakanta yu jantukaꞌ matichun putaukꞌay. Kaxꞌoqꞌiyapitik, kalhitꞌantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Incha taꞌayucha katalhisakmiyan ni valiꞌiycha xꞌotꞌatꞌik ni burro, ex kꞌaꞌunapitik va maqskꞌiniy ni Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ex taꞌal ixtꞌaltanan, tatemal va tacha lakjunkal. ");
INSERT INTO tptNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tejkan ixtatꞌajun xꞌoqnun ni burro, ex yu jamanavinin va talaklhisakmil: —¿Valiꞌiycha xꞌotꞌatꞌik ni kiburrokꞌan? ");
INSERT INTO tptNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ex yuꞌuncha tanaul: —Va maqskꞌiniy ni Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ex va talhaꞌanilcha ni Jesús, va tamukꞌanil ixlaqchꞌitikꞌan ni burro, ex putaukꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tejkan chuncha alcha ni Jesús, ni lapanakni tamamanil ixlaqchꞌitikꞌan lakatin para ancha kapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Va la lhuu lapanakni yu ixtatꞌaꞌan ni Jesús. Ex chuncha tejkan va lay kachaꞌal ni Jesús lakatajunti ni aspajun yu junkan Olivos, va ayaj talhiꞌachantajul ni yuꞌuncha. Va ixtatꞌasay, la ay ixtamakay ni Dios por tachun yu ixtalaqtsꞌinta yu makal ni Jesús la ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Va ixtanajun: —¡Katoꞌoyakal yu minta la ixtaqaꞌuti ni Jalhachimoꞌonu Dios! Ox katalaqtsꞌinchoqol ni Dios kun ni lapanakni y katoꞌoyakal ni Dios laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pero lati ni fariseos yu ancha ixtayanal va tajunil ni Jesús: —Jamalaniniꞌ, kꞌaꞌun yu tatꞌamintan ni saq kataval. ");
INSERT INTO tptNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ex ni Jesús va lakjunil: —Klajunau incha va saq kataval ni lapanakni ex va katalaktꞌasal ni chiyuxin, va ay katamakal ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ex chuncha tejkan va laycha kachaꞌal laka Jerusalén, laqtsꞌil ni ay putaulan, va laqlhiqalhul ni lapanakni yu ancha tavilanal. ");
INSERT INTO tptNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Va naul: —Va ixmalaꞌasitꞌik chavay tas pulaycha oxicha katꞌaulchꞌoꞌotꞌik kun Dios pero jantucha lay kꞌamalaꞌasiyapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kaminaꞌ julchan tejkan kataꞌostaulaꞌ mintꞌalaxkayninkꞌan, katamalaqachꞌinuyan para jantu lay kꞌatꞌapꞌasatꞌik y katamalaqachoqoxnuyan. ");
INSERT INTO tptNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Katamaꞌakxaꞌoyan, katamaqniyan uxiknan yu ancha katꞌaulapitik. Jantu katamakaunaꞌ chiyuxin yu katalaꞌakltankukꞌataulal. Jantu ixmispꞌayatꞌik ni Dios tejkan kilachil xlhiyucha katapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ex va tanul ni Jesús yu ay ixlakatajtankꞌan ni israelitas, va jalakxkauxtul yu ixtatꞌajun jastꞌanan y vachuꞌ yu ixtatꞌajun jalaktamunun. ");
INSERT INTO tptNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Va naul: —Va tsꞌoqkanta la ixchivinti Dios: “Ni kinchaqaꞌ junkan xachaqaꞌ taꞌan puskꞌinkan Dios.” Pero uxiknankꞌan makꞌayatꞌik paꞌalhavan. ");
INSERT INTO tptNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ex chuncha lhilhiy ixjalakmalaniy yu ay lakatajtan ni Jesús. Pero ni xaꞌukxtinin ni kuras ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu lajꞌay lapanakni, yuꞌuncha aqtayl talakpastaknan tas laycha katapumaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero tachun ni lapanakni tus ox ixtatꞌajun qalasmaknan ni Jesús, xlhiyucha jantu katatemal tas laycha katapumaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Taval taun julchan ni Jesús ixvil yu ay lakatajtan. Ixlakmasuniy ni lapanakni, ixjalaqputeꞌeniy tacha lay katapulaqtaxtul. Ancha tachaꞌal ni xaꞌukxtinin kuras ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas ali yu lajꞌay lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yuꞌuncha tanaul: —¿Taꞌayucha xtaqnin lhachimoꞌon ni kꞌamakꞌatꞌi yu aniy axtoqnu? ¿Taꞌayuchacha lhijunan ni chuncha kꞌamakꞌatꞌi? ");
INSERT INTO tptNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ex ni Jesús va lakjunil: —Kitꞌin vachuꞌ kaklalhisakmiyau taun chivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kilajuniu, ¿taꞌayucha malaqachal ni Juan para kamaqchajꞌavanal? ¿Va Dios u va lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ex aqtaylcha talalhisakmiy siya yuꞌuncha, ixtalajuniy: —¿Tas kajunaucha? Incha kajunau va Dios yu malaqachal ni Juan, ex ni Jesús kintalhisakmiyan: “¿Ex valiꞌiycha jantu kalhakꞌapꞌupꞌintꞌik?” ");
INSERT INTO tptNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero incha kanaunau valiꞌiy lapanakni yu tamalaqachal ni Juan, ex ni lapanakni kintalakatꞌalmayan. Yuꞌuncha talhakapuꞌan ni Juan va yu ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ex chuncha tajunil ni Jesús: —Kijnankꞌan jantu ijkꞌatsayau taꞌayucha malaqachal ni Juan para kamaqchajꞌavanal. ");
INSERT INTO tptNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ex Jesús jalakjunil: —Ex ni kitꞌin vachuꞌ jantu kaklajunau tas ayucha kixtaqnil palhachimoꞌon yu ikpumakay ni aniy axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ex aqtaylcha jalaqxaqalay ni lapanakni, va jalakjunil taun chivinti yu xtaꞌa jatapastakꞌati. Va naul: —Qayntaun lapanaki chꞌal uvas la ixtꞌun. Va jalaqxtaqnil amedias lati tapatsanin. Ex taxtul, la maqan al. ");
INSERT INTO tptNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ex lakachilcha ixpupꞌuxkan ni uvas. Ni ukxtin va malaqachal qayntaun ixꞌoqxtamati para kaskꞌinil lati yu japꞌuxnucha yu ixpaxtoqniy yucha. Pero yuꞌuncha tasamajꞌal ni oqxtamati, tamalaqachachoqol, jantu tuꞌuchun kataxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ex yu xamanavin tꞌun va malaqachachoqol aqayntaun ixꞌoqxtamati. Vachuꞌ tasamajꞌal ni oqxtamati, tamalaqachachoqol, jantu tuꞌuchun kataxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ex ni ukxtin va malaqachachoqol aqayntaun pero yuꞌuncha talhimaqchapul y tamaxtulcha ixlhimaqspaꞌ ni lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Ex ni anchanuꞌ xaꞌukxtin va naul: “¿Tas kakmakayacha? Kakmalaqachayaꞌ kesꞌatꞌa yu ayaj kꞌachaniy. Ka va yucha katatoꞌoyayaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ex tejkan talaqtsꞌil yu ixtatꞌajun tapatsanin talaxaqalal siya yuꞌuncha, va tanaul: “Yu aniy kalaqaꞌiyaꞌ ixlhitapatsa ixpay. Kamaqniu para kinavinkꞌan kaval ixlhitapatsa.” ");
INSERT INTO tptNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ex tamaxtul ixlhimaqspa ni anchanu lakatꞌun, va tamaqnil. Ex ni Jesús jalaklhisakmil: —¿Ex chuncha tas kamakayacha ni xaꞌukxtin ni tꞌun? ");
INSERT INTO tptNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Va kaminaꞌ la ixtꞌun, kalaqmaqniꞌoyaꞌ ni anchanu tapatsanin. Kaxtaqniyaꞌ ni tꞌun aqayntaun. Ex ni lapanakni yu taqasmaklhi va tanaul: —Jantu chun kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ex ni Jesús jalaqtsꞌil, va naul: —Incha jantu chuncha kaval, ex ¿valiꞌiycha inchine najun yu tsꞌoqkanta la ixchivinti Dios? Ni chiyux yu jantu kamapatsaputul yu tamakay chaqaꞌ chavay yucha yu apalay maqskꞌiniy. ");
INSERT INTO tptNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Vachuꞌ naul ni Jesús: —Mas va taꞌayuꞌ lapanaki kataqalqoslhi ni anchanuꞌ laka chiyux, kataqalhiyaꞌ. Pero incha ni anchanu chiyux kapatajul y kaꞌaktꞌalmal qayntaun lapanaki ex va kalhiꞌakxajtachal tacha pꞌoqxni. ");
INSERT INTO tptNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ex yu xaꞌukxtinin kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas va takꞌatsal ni Jesús ixlaklhichiviniy ni yuꞌuncha tejkan jalaqputeꞌenil ni anchanuꞌ chivinti. Xlhiyucha ancha ixtalakxkajuy tacha katapuchꞌapal ni Jesús. Pero jantu katachꞌapal, va ixtatalhauniy ni lapanakni yu ancha tayanal. ");
INSERT INTO tptNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ex ni yuꞌuncha jalaqmalaqachal lapanakni yu ixmakakan tacha ox lapanakni kataval. Va ixtamakanuputun ni Jesús para kanaul tuꞌuchun yu jantu ox. Ex chuncha lay katalhaꞌanil ni xagobernador. ");
INSERT INTO tptNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xlhiyucha talhisakmil, va tanaul: —Jamalaniniꞌ, ni kijnankꞌan ijkꞌatsayau va si laqsaval yu naꞌun y si laqsaval yu lakmalaniy ni lapanakni. Vachuꞌ jantu makꞌay kuenta taꞌayucha ni lapanaki. Uxintꞌi ayaj ox jamasuniy ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Va klalhisakmiyau incha maqskꞌiniy kamapalniu impuestos yu xaꞌay jalhachimoꞌonuꞌ Roma u jantu. ");
INSERT INTO tptNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ni Jesús yucha kꞌatsal va ixtamakanuputun. Va jalakjunil: —¿Valiꞌiycha kilalaqtsꞌintanuyaucha? ");
INSERT INTO tptNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kꞌimasunin aqxtaun tumin. ¿Ni aniy tumin tas ayuchacha ixꞌukxpucha? ¿Tas ayucha ixtaqaꞌuti aniy tsꞌoqmukꞌanikanta? Ex chuncha tanaul: —Va ixꞌukxpuꞌ kun ixtaqaꞌuti ni xaꞌay jalhachimoꞌonuꞌ Roma. ");
INSERT INTO tptNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ex chuncha jalakjunil: —Kaxtꞌaqnitꞌik yu jalhachimoꞌonuꞌ Roma yu ixnavin yucha y kaxtꞌaqnitꞌik Dios yu ixnavin Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ex chuncha jantu lay katamakanul ni Jesús la ixtalakaꞌukxpukꞌan ni lapanakni. Tus vak jalakmakal por ixchivinti, ex yuꞌuncha saq taval. ");
INSERT INTO tptNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ex chuncha lati ni saduceos talaqꞌal ni Jesús. Yuꞌuncha ixtanajun ni jantu takujchoqoy yu janinin. Ex va chuncha va tajunil ni Jesús: ");
INSERT INTO tptNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Jamalaniniꞌ, ni Moisés kintatsꞌoqnin la ixlhachimoꞌon incha kanil qayntaun lapanaki y kamakauntijlal ixanati y jantu kalhitsukunil sasꞌatꞌa, ex yu ixpꞌisaqa maqskꞌiniy katꞌatsukuchoqol ixanati para kalhitsukunil sasꞌatꞌa por xajayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ex chuncha ixꞌalin qayntujun tꞌalaqaunin. Yu xajayaꞌ lakxtuklal, va nil, jantu kalhitsukul sasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ex yu pꞌunaj ixpꞌisaqa tꞌatsukuchoqol ixanati pero vachu nil, jantu kalhitsukul sasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ex va chuncha yu aqayntaun ixpꞌisaqa vachuꞌ tꞌatsukuchoqol ni xanati ex vachu nil. Ex vachu va chuncha val kun tachun ni tꞌalaqaunin, jantu katalhitsukunil sasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ex taval vachuꞌ nil ni xanati. ");
INSERT INTO tptNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ex tejkan katakujchoqoyaꞌ ni janinin, ¿taꞌayucha ixanati kunaꞌ? Qayntujun tꞌalaqaunin va si ixtatꞌatꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ex ni Jesús va lakjunil: —Ni lapanakni aniy lakamunukpaꞌ va talakxtuklay y lakꞌikan. ");
INSERT INTO tptNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ni lapanakni yu tapaxtoqniy katachaꞌal yu ataun lakamunukpaꞌ, mas taniy va katakujchoqoyaꞌ. Ancha jantu katalakxtuklayaꞌ y jantu kalakꞌikanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Yuꞌuncha jantucha kataniyaꞌ. Tacha ixmayulnin Dios katajunaꞌ, va yu sasꞌatꞌan Dios katajunaꞌ, va takujchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ni Moisés yucha kintamasuniyan ni takujchoqoy ni janinin tejkan lhitsꞌoqlhi ni javan yu ixmaqtayvil. Taꞌan chuncha tsꞌoqlhi, va naul ni Dios: “Kitꞌin ixDios Abraham, ixDios Isaac, ixDios Jacob kunita”, naul ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Chavay mas naunatꞌik va ixtanitacha ni anchanu lapanakni pero yu Dios naul: “Kitꞌin va ixDioskꞌan kunita.” Ex chuncha pukꞌatsayau va ixtakujchoqotacha. Ni Dios jantu Dios kaval kun yu janinin, va ixDioskꞌan yu tatꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ex lati yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas va ancha ixtayanal, va tajunil ni Jesús: —La ox altꞌayan, jamalaniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ex chuncha tatalhaunilcha, jantucha apalay tuꞌuchun katalhisakmil. ");
INSERT INTO tptNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ex ni Jesús laklhisakmil ni lapanakni: —¿Valiꞌiycha tanajun va sasꞌatꞌa David ni Cristo yu ixtanajun kamalaqachayaꞌ ni Dios? ");
INSERT INTO tptNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Jantu vamun sasꞌatꞌa David kaval. David tsꞌoqlhi laka salmos va naul: Ni Dios naul, va junkal kiJalhachimoꞌonuꞌ: “Aniy kꞌintꞌatꞌaꞌul la kilhijakanaj makaꞌ para katatoꞌoyan ni lapanakni ");
INSERT INTO tptNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tus kakmaqalhajaꞌoyaꞌ tachun mintꞌalaxkaynin.” ");
INSERT INTO tptNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ex incha David naul ni Cristo va ixJalhachimoꞌonuꞌ, ex naunputun ni jantu vamun sasꞌatꞌa kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ex tachun ni lapanakni taqalasmaklhi ni Jesús tejkan jalakjunil ixtꞌaltanan, va naul: ");
INSERT INTO tptNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Kꞌalhistꞌajkꞌantꞌikcha para jantu katamakanun yu tamasuy kilhachimoꞌonkꞌan. Yuꞌuncha tamaqamay katatiꞌukxuntayal kun yu laqlman laqchꞌiti tacha taꞌulay ni lajꞌay lapanakni. Taꞌachaniy kalakmastakꞌakal laklhitamau tacha ay lapanakni kataval. Tataulputun taꞌan tataulay yu xalajꞌaynin laqa chaqan taꞌan tataqxtoꞌa ni lapanakni vachu taꞌan alin lakvayti. ");
INSERT INTO tptNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Talakmaxtuniy ixchaqakꞌan yu tiyaunin. Vachu la panij tatapayniy Dios para katatoꞌoyal ni lapanakni. Yuꞌuncha katalaqaꞌiyaꞌ apalay lhuu jamaqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ex chuncha taꞌan ixvil ni Jesús lakatajtan va lakavanal, va jalaqtsꞌil ni maqalinin ixtamujuy ixlimosnajkꞌan laka kajun. ");
INSERT INTO tptNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ex ancha laqtsꞌil qayntaun kilpataniꞌ tiyau va mujul aqxtꞌuy lakstꞌuniy tumin. ");
INSERT INTO tptNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ex va naul ni Jesús: —Laqsaval klajunau yu aniy kilpataniꞌ tiyau apalay lhuu xtaqlhi xajantu yu alati lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Yuꞌuncha mas va taxtaꞌa laqlhuu pero taxtaꞌa vamun yu tamaxajniyachal. Chavay ni kilpataniꞌ tiyau mas va tsꞌuniy tumin yu xtaqlhi pero va xtaqꞌol tachun yu ixputapasay. ");
INSERT INTO tptNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ex chuncha lati ixtatꞌajun lhichivinin yu la ay lakatajtan. Ixtanajun va kun la lajkꞌus chiyux ixmaxantilakanta y vachuꞌ kun yu la kꞌus axtoqnuꞌ yu taxtaqlhi lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Pero ni Jesús lakjunil: —Kaminaꞌ julchan tejkan tachun yu laqtsꞌinatꞌik kalaqcheꞌeꞌokanaꞌ, jantu katamakaunaꞌ chiyuxin yu katalaꞌakltankukꞌataulal. ");
INSERT INTO tptNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ex chuncha talhisakmil: —Jamalaniniꞌ, ¿tavanancha chuncha katapasayaꞌ? Tejkan va laycha chuncha katapasal, ¿tas kakpukꞌatsayaucha? ");
INSERT INTO tptNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ex va naul ni Jesús: —Kꞌalhistꞌajkꞌantꞌikcha para jantu matichun katamakanun. Kataminaꞌ qaynlhuu la kintaqaꞌuti y katanaunaꞌ: “Kitꞌin ni Cristo”; y katanaunaꞌ: “Chavaycha kamiꞌoyaꞌ ni lakamunukpaꞌ.” Pero uxiknankꞌan jantu kꞌalaktꞌapꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tejkan kaꞌasmaktꞌapitik la alin lhilukuj ni lakamunukpaꞌ y tejkan katalachꞌapayaꞌ ni lapanakni kun lhachimoꞌonun ex jantu katꞌalhanantꞌik. Chuncha maqskꞌiniy pꞌunaj katapasal. Pero tejkan chuncha kunaꞌ jantukaꞌ kamiꞌoyaꞌ ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ex chuncha taylhaꞌal ixchivinti ni Jesús, va lakjunil: —Yu oqxlaqtaun lapanakni katalachꞌapayaꞌ kun aꞌoqxlaqtaun lapanakni. Yu laqataun pais katalachꞌapayaꞌ kun ataun pais. ");
INSERT INTO tptNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kalaklayaꞌ lakatꞌun lakalhuu lakamunukpaꞌ y lakalhuu kaꞌalinaꞌ chavan y lakalhuu kaꞌalinaꞌ taqanꞌati. Vachuꞌ kaꞌalinaꞌ la ay talhanti laktꞌiyan y va yucha katapukꞌatsayaꞌ ni lapanakni va laycha kamiꞌol ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero pꞌunaj tejkan jantukaꞌ chuncha katapasayaꞌ katachꞌapayan, katamamajkꞌatsanivayan, katamaqxtaqniyan yu xalajꞌay lapanakni laqa chaqan taꞌan tataqxtoꞌa ni israelitas. Kalhipꞌinikꞌanapitik yu lajꞌay lapanakni kun yu jalhachimoꞌonun. Kalhipꞌinkꞌanapitik laka pachꞌin. Va si chun katapasayaꞌ por kilapanakni untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero tejkan chuncha katapasayaꞌ ex laycha kꞌachꞌivinapitik para kintamispal. ");
INSERT INTO tptNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero kapꞌastꞌaktꞌik la melhanutkꞌan ni jantu katapastakꞌun tas laycha kꞌapꞌuꞌaltꞌayanantꞌik tejkan katamukꞌaniyan laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ni kitꞌin klaxtaqniyau chivinti kun jatapastakꞌati. Chuncha tachun mintꞌalaxkayninkꞌan katakꞌatsayaꞌ va laqsaval yu naunatꞌik, jantu lay katanaul yu jantu laqsaval yu naunatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mas va mimpaykꞌan u minatikꞌan katamaqxtaꞌan. Mas va mintꞌalaqaunin u miꞌamigoskꞌan katamaqxtaꞌan. Lati yu uxiknankꞌan kꞌamaqnikꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tachun ni lapanakni katalhixkayan por kilapanakni untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero jantu kamaꞌatsꞌanꞌayapitik metsukuntikꞌan mas va maqataun miꞌajikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mas va lhitaꞌay kunaꞌ incha kilalhakapuꞌanꞌalhiyau ex kꞌalhitsꞌukꞌuyapitik jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Tejkan kalaqtsꞌinapitik va katamalaqachoqoxnuyaꞌ ni tropas ni aniy putaulan yu Jerusalén. Chuncha kakꞌatsꞌayapitik va niman kalaqmaqniꞌokanaꞌ xalapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tejkan chuncha katapasayaꞌ, ex yu tavilanal xaꞌestado Judea maqskꞌiniy kataqoslhi laka aspajunuxnan. Yu tavilanal aniy laka ay putaulan maqskꞌiniy katataxtul y yu tavilanal ixlhimaqspa ni putaulan jantu katatanul. ");
INSERT INTO tptNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ni anchanu julchan kaꞌalinaꞌ maqanlqajnati por yu talaqalhin. Chuncha laqsaval kunaꞌ tachun yu tsꞌoqkanta la ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Payniꞌincha xanatin yu jaꞌaynan katajunaꞌ anchanuꞌ julchan, vachuꞌ yu katalhitsukuyaꞌ lakstꞌuniy sasꞌatꞌakꞌan yu lhimatsꞌikꞌiti! La kaꞌalina maqanlqajnati aniy la kintꞌunkꞌan y ni Dios ayaj katalqaunaꞌ kun yu aniy lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lati kalaqmaqnikanaꞌ laka lhilukuj. Lati kalakchꞌikanaꞌ, kalaklhaꞌankanaꞌ ixlhilakalhuu lakamunukpaꞌ. Yu aniy la ixputaulankꞌan Jerusalén katataulaꞌ yu jantu israelitas kataval tus tejkan kamiꞌoyaꞌ julchan yu lakꞌulanikanta. ");
INSERT INTO tptNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ex chuncha laktꞌiyan katatapaxayaꞌ ni julchan kun ni malkuyuꞌ kun ni jastꞌakun para katapulakpastaknal. Aniy lakatꞌun la katatalhananaꞌ ni lapanakni, jantu katamalaqasiyaꞌ tejkan ayaj kamakatꞌaunaꞌ ni lakamar. ");
INSERT INTO tptNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jantucha katalhitsukuyaꞌ tapꞌasta por ixtalhantikꞌan y va por la katapastakꞌuyaꞌ tisuncha katapasayaꞌ lakamunukpaꞌ. Ni julchan ali ni malkuyuꞌ ali ni jastꞌakun kataxkapꞌiknanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ex chuncha katalaqtsꞌinaꞌ ni Sasꞌatꞌa Lapanaki, va kaminaꞌ laka taputsꞌi, kaminaꞌ kun ixtapꞌasta y tachun ixꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Tejkan chuncha kaꞌaqtayniyacha ex kꞌaꞌachꞌantꞌik, y kꞌatalaqstꞌatꞌik kun achati. Tejkan chuncha kunaꞌ ex kꞌalaqtꞌaxtꞌuyapitikcha. ");
INSERT INTO tptNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ex lakjunil ataun chivinti yu xtaꞌa jatapastakꞌati, va naul: —Kꞌalaqtsꞌintꞌik ni kꞌiu yu junkan higuera, u va taꞌayucha kꞌiu kaval. ");
INSERT INTO tptNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tejkan kalaqatajuyaꞌ xaxqoy ex meꞌemankꞌan kꞌatsꞌayatꞌik ni taꞌukstsꞌuniycha ni lhikꞌatsa. ");
INSERT INTO tptNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Vachu va chun tejkan kalaqtsꞌinapitik ni chuncha tꞌajun tapasanaꞌ aniy lakamunukpaꞌ yu tacha klajuniu, ex va chuncha kakꞌatsꞌayapitik ni taꞌukstsꞌuniycha tejkan Dios kalhachimoꞌonunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Laqsaval klajunau, ni lapanakni yu chavay tatꞌajun, jantukaꞌ kataniꞌoyaꞌ tus katapasaꞌoꞌelayaꞌ yu klajuntau. ");
INSERT INTO tptNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yu lakatꞌun kun laktꞌiyan katamiꞌoyaꞌ pero yu kinchivinti jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Kꞌalhistꞌajkꞌantꞌikcha para jantu pꞌas kꞌamakꞌatꞌik melhanutikꞌan por mintaꞌapꞌatikꞌan nisin por yu makꞌapꞌutꞌunatꞌik la milakatunajkꞌan, y jantu kꞌatꞌapꞌastakꞌun tacha kꞌapꞌutꞌapꞌasayapitik la metsukuntikꞌan. Ni anchanuꞌ julchan va tsꞌalaj kachinaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kaminaꞌ tacha laqataun patꞌal yu tsꞌalaj putaqtay, va kalaqmaqsvaꞌoyaꞌ ni lapanakni yu tavilanal talakachux ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lhistujcha kꞌaꞌuntꞌik, va si kaskꞌintꞌik Dios para lay kꞌapꞌulaqtꞌaxtꞌutꞌik tachun yu katapasayaꞌ. Ex chuncha lay kꞌapꞌulaqchꞌipꞌintꞌik ni Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tejkan tunkuj, ni Jesús ixlakmalanin laka ay ixlakatajtankꞌan ni israelitas. Chuncha tejkan tsꞌis, ixꞌan loqojnuꞌ taꞌan junkan xaꞌaspajun Olivos. ");
INSERT INTO tptNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tachun ni lapanakni vakuj ixtalaqꞌan ni Jesús ni ay lakatajtan. Va ixtaꞌan qasmaknan ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ex chuncha ixtaꞌuktsꞌuniy ni Paxku yu ay ixkꞌatankꞌan ni israelitas, tejkan ixtaꞌuy ni pan yu jantu lhiyaukan levadura. ");
INSERT INTO tptNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chuncha ni xaꞌukxtinin ni kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, va ixtalakxkauniy tas laycha katapumaqnil ni Jesús. Pero va ixtatalhauniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ex chuncha ni Satanás va tanunil ni Judas, yu ixtajuniy Iscariote. Yucha xaqayntaun yu ixpumakautꞌuykꞌan ixtꞌaltanan Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ex yucha jalaqꞌal ni xaꞌukxtinin kuras kun yu xapolicias ni ay lakatajtan. Va laqlhixaqalal para laycha kalaqmaqxtaqnil ni Jesús ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ex yuꞌuncha talhiꞌachantajul, va tajunil kataxtaqnil tumin incha kalaqmaqxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ex va lhipaꞌinil ni Judas, va aqtayl lakpastaknan tas lay kapumaqxtaqlhi ni Jesús tejkan jantu kaꞌalil pumalhuu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ex chuncha va lakachilcha xakꞌatan Paxku, tejkan ixtaꞌuy pan yu jantu ixlhiyaukan levadura, vachuꞌ ixtamaqniy sasꞌatꞌa borrego tacha ixlapaxkankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ni Jesús malaqachal ni Pedro ali Juan, va lakjunil: —Kapꞌintꞌik laꞌoxinin yu kaꞌuyau xakꞌatan Paxku. ");
INSERT INTO tptNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ex va tanaul: —¿Toꞌoxtaycha naꞌun kaklaꞌoxiu? ");
INSERT INTO tptNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ex lakjunil ni Jesús: —Tejkan katꞌanuyapitik ni laka putaulan ancha kapꞌaxtꞌoꞌapitik qayntaun lapanaki yu lhaꞌanta xkan la ixꞌaqxau. Yucha katꞌapꞌinapitik tus laqa chaqaꞌ taꞌan katanuyanta. ");
INSERT INTO tptNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ancha kꞌaꞌunitꞌik ni jamachaqaꞌ: “Kijamalaninikꞌan va lhasakminin toꞌoxtaycha lay kalaktꞌavayl ni ixtꞌaltanan ni xakꞌatan Paxku.” ");
INSERT INTO tptNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ex ni yucha katamasuniyan taꞌan apulaktaun ni chaqaꞌ yu pulajꞌay taꞌan alinꞌojotacha yu axtoqnuꞌ. Ancha kꞌalaꞌoxiyapitik ni lakvayti. ");
INSERT INTO tptNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ex chuncha ni yuꞌuncha taꞌal, tatemal va chuncha tacha lakjunkal. Ancha talaꞌoxil xalakvayti ni kꞌatan Paxku. ");
INSERT INTO tptNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ex chuncha tejkan chaꞌalcha ni hora ni Jesús kun ixtꞌaltanan tatanul ni laqa chaqaꞌ, va tataulal laka mesa. ");
INSERT INTO tptNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ex lakjunil ni Jesús: —Kitꞌin kun tachun la kelhanuti klatꞌavaynputunau yu uxiknan xavayti ni aniy kꞌatan Paxku tejkan jantukaꞌ ikmaqnikan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kitꞌin klajunau jantucha kajkꞌuchoqoyaꞌ xavayti ni aniy kꞌatan tus tejkan kataqayntsayaꞌ yu naunputun aniy kꞌatan tejkan kalhachimoꞌonunaꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ex chuncha chꞌapal laqataun vaso, va xtaqnil lhimalaqpuchuncha ni Dios. Ex va lakjunil: —Kachꞌapꞌatꞌik ni vaso, kaꞌoqtꞌik tachun uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Laqsaval klajunau jantucha aqtaun kajkꞌoqchoqoyaꞌ kitꞌin yu aniy xaxkan ni uva tus tejkan kaminaꞌ jalhachimoꞌonuꞌ ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ex chꞌapal ni pan va xtaqnil lhimalaqpuchuncha ni Dios. Va cheꞌel, laqxtaqnilcha, va lakjunil: —Yu aniy va kilakatunaj maqxtaqkanta por uxiknankꞌan. Va tsaj chuncha kꞌamakꞌayapitik para kilapupastakvi ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ex tejkan tavaynꞌol vachu va chuncha chꞌapal ni vaso, va naul: —Yu aniy vaso masuy ni Dios va taun sastꞌi chivinti jatꞌatamakajun ixlapanakni por kijakꞌalna. Va kataxtuyaꞌ kijakꞌalnan para kꞌalaqtꞌaxtꞌutꞌik ni uxiknan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero qayntaun yu kintꞌataulay aniy laka mesa yucha kimaqxtaqyaꞌ para kakmaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chuncha katapasayaꞌ, ni kitꞌin yu kval Sasꞌatꞌa Lapanaki ikpuꞌan lakatin taꞌan kimpaxtoqniy. Pero paynicha ni anchanu lapanaki yu kimaqxtaqyaꞌ para kakmaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ex yuꞌuncha taꞌaqtayl talaklhichiviniy taꞌayucha kaval yu kamaqxtaqlhi. ");
INSERT INTO tptNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ex chuncha taꞌaqtaynilcha talalhisakmiy siya yuꞌuncha taꞌayucha yu apalay ay kaval yu ixpumakautꞌuykꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero ni Jesús lakjunil: —Ni lajꞌay xalhachimoꞌonun aniy lakamunukpaꞌ talhichimoꞌonun tacha pꞌas xaꞌukxtinin. Yuꞌuncha tanajun kalaktoꞌoyakal tacha lajꞌoxi lapanakni kataval. ");
INSERT INTO tptNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero uxiknan jantu chun kꞌamakꞌakꞌantꞌik. Va knajun yu apalay ay junita yucha kaval tacha yu apalay lakatꞌuniy. Yu lhinajun, yucha kaval tacha qayntaun oqxtamati. ");
INSERT INTO tptNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Tas naunatꞌikcha uxiknankꞌan? ¿Taꞌayucha yu apalay ay? ¿Va yu vil laka mesa u va yu jamunuꞌ? Va yu vil laka mesa. Pero ni kitꞌin ikmakakan tacha miꞌoqxtamatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Ni uxiknankꞌan jantu aqtaun ixkilamakaunau tejkan lhitaꞌay xaktapasay. ");
INSERT INTO tptNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Xlhiyucha klaxtaqniyau taun palhachimoꞌon tacha kixtaqnil palhachimoꞌon ni kimPay. ");
INSERT INTO tptNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Para chuncha lay kilatꞌavajiu y kilatꞌaꞌoqvi la kimesa taꞌan kaklhachimoꞌonunaꞌ ni kitꞌin. Kꞌatꞌaulapitik tacha jalhachimoꞌonun. Kꞌalhiꞌunapitik yu oqxlaqkautꞌuykꞌan xalapanakni Israel. ");
INSERT INTO tptNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ex naul ni Jesús, va junil ni Pedro: —¡Ay, Simón kꞌatꞌi! Ni Satanás taskꞌintancha para katatankꞌalhan uxiknan vachu va tacha tankꞌalhakan ni trigo. ");
INSERT INTO tptNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero kitꞌin ikskꞌinil Dios por uxintꞌi para jantu kamaꞌatsꞌanꞌatꞌi milhakapuꞌati. Ex tejkan kꞌintꞌapꞌinchꞌoꞌoyeꞌe kꞌalaqꞌaqtꞌayꞌutꞌi mintꞌalaqaunin para ox katataylhaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ex ni Pedro va junil: —Jalhachimoꞌonuꞌ, kitꞌin va klistujcha kunita para kaktꞌaꞌan uxintꞌi mas lakapachꞌin, u mas kaknil kun uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero ni Jesús va junil: —Pedro, kitꞌin kunan chavay tsꞌis tejkan jantukaꞌ tꞌasay ni puyux va aqtꞌutu kꞌanauneꞌe ni jantu kꞌimispꞌay. ");
INSERT INTO tptNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ex chuncha va laklhisakmil ni Jesús, va naul: —Tejkan klamalaqachau y jantu ixlhipꞌinatꞌik ni mintuminkꞌan nisin mibolsakꞌan nisin misapatojkꞌan, ¿ex va tatsꞌanqaniyan tuꞌuchun? Ex yuꞌuncha tajunil: —Jantu. ");
INSERT INTO tptNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ex ni Jesús lakjunil: —Pero chavaycha yu alin ixtumin, va kalhaꞌal. Vachuꞌ kalhaꞌal ixbolsa. Yu jantu kalhitsukul ixꞌespada, va kalhiꞌil ixlaqchꞌiti. ");
INSERT INTO tptNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kitꞌin klajunau va maqskꞌiniy kataqayntsal tacha tsꞌoqkanta la ixchivinti Dios yu kilhichiviniy kitꞌin taꞌan najun: “Ni yucha laqtsꞌinkal tacha jalaktuꞌunuꞌ kaval.” Yu anu yu kilhichiviniy kitꞌin laqsaval katapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ex va tanaul ni yuꞌuncha: —Jalhachimoꞌonuꞌ, aniy alin maꞌatꞌuy kiꞌespadakꞌan. Ex va naul ni Jesús: —Ka oxicha. ");
INSERT INTO tptNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ex chuncha ni Jesús taxtul ni laqa chaqaꞌ, va anchoqopal ni aspajun yu junkan Olivos, va tatꞌaꞌal ixtꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ex tejkan ancha tachaꞌal, va lakjunil: —Kaskꞌintꞌik Dios para jantu kꞌamakꞌanukꞌantꞌik y kamakꞌatꞌik yu jantu lajꞌox. ");
INSERT INTO tptNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ex chuncha va al ixlhimaqati tacha kꞌatꞌanꞌalhutꞌi chiyux. Ancha taꞌaqtsoqoqtal, aqtayl skꞌin Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Va naul: —KimPay kꞌatꞌi, incha va naꞌun uxintꞌi ex kꞌamakꞌatꞌi para jantu kaktapasal ni maqanlqajnati. Pero jantu kꞌamakꞌatꞌi tacha iknajun kitꞌin, va kamakꞌatꞌi tacha naꞌun uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ex ancha tasul taun xamayul laktꞌiyan va xtaqnil tapꞌasta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Va ayaj ixmajkꞌatsay va la pꞌas iskꞌin Dios. Ixchanita xtꞌajlhi tacha jakꞌalnan ixjunita, va taꞌeltajul laka tꞌun. ");
INSERT INTO tptNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ex chuncha skꞌinꞌol va tayachoqolcha, jalaqꞌal ixtꞌaltanan, va jalaqtsꞌil va ixtaltatay. Va tamaqaninil yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ex va lakjunil: —¿Valiꞌiycha ltꞌatꞌayatꞌik? Kaꞌostꞌaulatꞌik, kaskꞌintꞌik Dios para jantu kꞌamakꞌanukꞌantꞌik y kamakꞌatꞌik yu jantu lajꞌox. ");
INSERT INTO tptNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ex chuncha tejkan vananaj ixtꞌajun chivin, va tachaꞌal lhuu lapanakni. Xaqayntaun ixpumakautꞌuykꞌan ixtꞌaltanan ni Jesús yu ixjunkan Judas, yucha japꞌulatal. Va taꞌuktsꞌuniniycha taꞌan ixyal ni Jesús, va laqmil para kakiltastuklhi. ");
INSERT INTO tptNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero ni Jesús va lhisakmil: —Judas, ¿uxintꞌi kꞌinkꞌiltꞌastꞌukꞌa vamun para kꞌimpꞌumaqxtꞌaqyeꞌe ni kitꞌin yu Sasꞌatꞌa Lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ex yu ixtatꞌavilanal ni Jesús tejkan takꞌatsal yu va laycha katapasal, va talhisakmil: —Jalhachimoꞌonuꞌ, ¿tas naꞌuncha? ¿Va kalakchꞌapayaucha kun espada u jantu? ");
INSERT INTO tptNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ex qayntaun maxtul ixꞌespada, va chaqxlhi ixꞌoqxtamati yu xaꞌukxtin ni kuras, va chaqxpꞌuxnil ixlhijakanaj aqaxqol. ");
INSERT INTO tptNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ex jaqaltayl ni Jesús, va naul: —Ancha katamaktalcha. Ex ni Jesús va saknil ni ixꞌaqaxqol, va mukꞌanichoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yu ixtachaꞌanta para katachꞌapal va ni xaꞌukxtinin kuras ali yu xaꞌukxtinin policias lakatajtan ali yu xalajꞌaynin. Ex chuncha ni Jesús va lakjunil: —¿Va tacha alhavanacha kakval ni kilalaqminau kun kꞌiu ali espada? ");
INSERT INTO tptNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mas va lhilhiy xaklatꞌataulau lakatajtan jantu aqtaun kilachꞌapau. Pero chavay va putsꞌista y va chuncha kilamakayau va por tapaxtoqniyan yu xalhachimoꞌon putsꞌista. ");
INSERT INTO tptNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ex chuncha tachꞌapal ni Jesús, va talhaꞌal, va tamanul la ixchaqaꞌ yu xaꞌukxtin kura. Ni Pedro va paqmaqati ixtixkaulhaꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ancha ixtamalkulata taꞌan malaqachoqoxnuta ni chaqaꞌ, valiꞌiy ixvilin ixtavilanal. Vachu laktꞌataulal ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ex qayntaun maqtsukuꞌ laqtsꞌil laka jikmi va aqtayl oqspulaqtsꞌin va naul: —Yu aniy lapanaki va ixtꞌaltanaꞌ ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ni Pedro va naul ni jantu, va junil ni maqtsukuꞌ: —Xanati, kitꞌin jantu kmispay ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ex taun panchꞌix val, aqayntaun laqtsꞌil, va naul, junkal ni Pedro: —Uxintꞌi vachuꞌ ixtꞌaltanaꞌ kꞌatꞌi. Pero ni Pedro va junil: —Joꞌati, jantu kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ex taun hora val, aqayntaun va pꞌas chivinil, va naul: —Laqsaval, yu aniy lapanaki va ixtꞌaltanaꞌ, va machaqaꞌ Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ex va naul ni Pedro: —Joꞌati, jantu laqsaval kaval yu naꞌun. Ex tejkan vananaj ixtꞌajun chivin va tꞌasal ni puyux. ");
INSERT INTO tptNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ex ni Jesús talaqaspꞌiklhi, laqtsꞌil ni Pedro. Ex va pastaklhi ni Pedro tacha naul ni Jesús: “Va aqtꞌutu kꞌanauneꞌe ni jantu kꞌimispꞌay tejkan jantukaꞌ istꞌasay ni puyux.” ");
INSERT INTO tptNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ex taxtul ni Pedro, va la pꞌays qalhul. ");
INSERT INTO tptNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Taval ni lapanakni yu ixtachꞌapata ni Jesús va talaktuꞌul, va tanaqlhi. ");
INSERT INTO tptNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ex talaqpuchꞌil, tanaqlhi, va tajunil: —Kilajuniu taꞌayucha yu naqnicha. ");
INSERT INTO tptNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Va pulhuu laqxtoqnuꞌ chivinti tapulaktuꞌul. ");
INSERT INTO tptNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ex va tunkulcha tataqxtoqlhi yu lajꞌay xapaynin yu xaꞌukxtinin kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas. Yuꞌuncha ixtalhichimoꞌoy ixputsukkꞌan. Ancha lhiminkal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ex va tajunil: —Kilajuniu incha laqsaval ni Cristo kꞌatꞌi, yu ixtanajun kamalaqachayaꞌ ni Dios. Ex ni Jesús va lakjunil: —Mas va kaklajuniu, jantu kilalhakapuꞌau. ");
INSERT INTO tptNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mas va kaklalhisakmiu jantu kꞌaꞌaltꞌayanantꞌik nisin jantu kilaxꞌotau. ");
INSERT INTO tptNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero chavay y mas va tavanancha, kitꞌin yu kval Sasꞌatꞌa Lapanaki kaktaulaꞌ la ixlhijakanaj Dios, kaklhitsukuyaꞌ ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ex tachun ni anchanu lajꞌay lapanakni va tanaul: —¿Ex uxintꞌi Sasꞌatꞌa Dios kꞌatꞌi? Ex ni Jesús lakjunil: —Chun, tacha uxiknan naunatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ex chuncha ni yuꞌuncha va tanaul: —¿Tisuncha alati chivinti maqskꞌiniyau para kamukꞌaniu ixlaqtaqal? Oxicha kun yu xanajun. ");
INSERT INTO tptNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ex tachun ni anchanuꞌ lajꞌay lapanakni tatayal, va talhaꞌal ni Jesús taꞌan vil yu xalhachimoꞌonuꞌ romanos yu junkan Pilato. ");
INSERT INTO tptNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ex taꞌaqtayl tachivintanuy, va junkal ni Pilato: —Yu aniy lapanaki iktemau, yucha va lakmalukujlay ni lapanakni para jantucha katatoꞌoyal ixlhachimoꞌonunkꞌan. Va lakjuniy jantu katamapalal ixꞌimpuestoskꞌan y vachu najun va yucha ni Cristo yu Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ex ni Pilato va lhisakmil: —¿Uxintꞌi xajalhachimoꞌonuꞌ kꞌatꞌi ni israelitas? Ex ni Jesús va junil: —Chun, tacha naꞌun uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ex ni Pilato va lakjunil ni xaꞌukxtinin kuras kun tachun ni lapanakni, va naul: —Aniy lapanaki jantu tuꞌuchun laqtaqal kaktemanil. ");
INSERT INTO tptNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero apalay pꞌas tamanul jalaklkanti ni lapanakni, va tanaul: —Pero aniy lapanaki ayaj lakmalukujlay ni lapanakni kun ixchivinti y malaninin tachun la kintꞌunkꞌan yu israelitas kuntau, yu xaꞌestado Galilea tus aniy. ");
INSERT INTO tptNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ex tejkan chuncha qasmaklhi ni Pilato, va laklhisakmil incha ni Jesús machaqaꞌ xaꞌestado Galilea ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tejkan kꞌatsal va ancha machaqaꞌ ixjunita taꞌan ixlhachimoꞌonun ni Herodes, ex yucha malaqachanil ni Jesús. Ni Herodes va chilkaꞌ ni anchanu putaulan Jerusalén y ancha ixvil tejkan xajulchan kꞌatan ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ex chuncha tejkan ni Herodes laqtsꞌil ni Jesús, va ayaj lhiꞌachantajul. Va la maqancha ixlaqtsꞌinputun, va ixqasmaktacha yu ixmakay y va ixlaqtsꞌinputun kamakal tuꞌuchun yu ay. ");
INSERT INTO tptNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ex chuncha la lhuu chivinti lhisakmil pero ni Jesús jantu tsij kanaul. ");
INSERT INTO tptNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Va ancha tayanal ni xaꞌukxtinin kuras kun yu ixtamasuy ixlhachimoꞌonkꞌan israelitas. Yuꞌuncha va la pꞌas tamukꞌanil laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chuncha ni Herodes kun ixtropas jantu katatoꞌoyal, va la lhuu laqxtoqnu chivinti tajunil. Ex chuncha talaktuꞌul, va taꞌulanil aqxtaun laqchꞌiti yu taꞌulay jalhachimoꞌonun. Ex va chuncha tapulaktuꞌul, va tamalaqachanichoqol ni Pilato. ");
INSERT INTO tptNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ex chuncha ni anchanu julchan ni Herodes kun Pilato va amigos taval. Pꞌunaj ixtalaxkajiy pero ni anchanu julchan va chuncha talamakal tacha amigos. ");
INSERT INTO tptNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ex chuncha taval ni Pilato va laqmaqxtoqlhi ni xaꞌukxtinin kuras ali ni jalhachimoꞌonun ali ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ex va lakjunil: —Va kilalhiminiu yu aniy lapanaki, va kilajuniu ni lakmalukujlay ni lapanakni para jantucha katatoꞌoyal ixlhachimoꞌonunkꞌan. Pero la mintalakaꞌukxpukꞌan kitꞌin klhisakmil incha laqsaval kaval tacha naunatꞌik. Jantu kaktemanil ni ixlaqtaqal yu mukꞌaniyatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Vachuꞌ ni Herodes jantu katemanil ixlaqtaqal. Chuncha kꞌatsay va por kintamalaqachanichoqon. Xlhiyucha kitꞌin knajun jantu kamakal tuꞌuchun yu kalhimaqniu. ");
INSERT INTO tptNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ex kitꞌin kaklhinaunaꞌ ixmaqanaqka, ex kakmakaunacha. ");
INSERT INTO tptNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ni Pilato ixmaqskꞌiniy kaxꞌoqlhi qayntaun tachꞌin taun taun jachꞌitin tejkan kꞌatan Paxku. ");
INSERT INTO tptNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ex tachun ni lapanakni va chꞌantaun taval, va la pꞌas tanaul: —Jantu kamakꞌau yu aniy lapanaki. Kamakꞌau yu junkan Barrabás. ");
INSERT INTO tptNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ni Barrabás ixmakata lhilukuj ixpulakna ni putaulan y vachu va maqnil qayntaun, xlhiyucha tamanul laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pero Pilato va ixmakaunputun ni Jesús, xlhiyucha laqxaqalachoqol aaqtaun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero yuꞌuncha apalay pꞌas ixtatꞌajun lakchivinin, va tanaunchoqol: —¡Kꞌamakxtꞌukmukꞌacha laka kurus! ");
INSERT INTO tptNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ex yu aqtꞌutunuꞌ ni Pilato laqxaqalachoqol, va naul: —¿Valiꞌiycha chun unatꞌik? Jantu tuꞌuchun laqtaqal kamakal. Kitꞌin kaklhinaunaꞌ ixmaqanaqka, ex kakmakaunacha. ");
INSERT INTO tptNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yuꞌuncha la pꞌas ixtachiviniy, ixtaskꞌin laqatapꞌasta para kamakxtukmukꞌakal laka kurus. Ex kun ixchivintikꞌan ni lapanakni kun yu xaꞌukxtinin kuras va talhajal yu ixtaskꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ex chuncha ni Pilato lhinaul kamakakal tacha ixtaskꞌinta ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ex chuncha makaunkal yu ixtanun laka pachꞌin por makal lhilukuj y por maqninil. Ni Jesús va maqxtaqkal para katamakal ni lapanakni tacha ixtaskꞌinta. ");
INSERT INTO tptNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ex chuncha tejkan talhaꞌal ni Jesús va tachꞌapayaul qayntaun lapanaki yu Simón ixjunkan, va machaqaꞌ xalakatꞌun Cirene. Ixminta ixlhimaqspaꞌ ni putaulan. Tamaqxꞌoꞌal ni kurus, va talhijunil kalhaꞌal taꞌan ixjapꞌulꞌanta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Va astan ixtaꞌanta qaynlhuvaj lapanakni. Vachu ixꞌalin xanatin yu ixtamaqaninin, va la ixtaqalhun. ");
INSERT INTO tptNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ni Jesús va talaqaspꞌiklhi va lakjunil: —Xanatin machaqan Jerusalén, jantu kilalhiqalhuu ni kitꞌin. Kalhiꞌalhuntꞌik por metsukuntikꞌan y por mesꞌatꞌankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kaminaꞌ julchan tejkan kanaunkanaꞌ: “La ox istsukuntikꞌan ni xanatin yu jantu lay talhitsukuy sasꞌatꞌakꞌan ali yu jantu aqtaun katalhitsukul ali yu jantu aqtaun katamatsꞌikꞌinil.” ");
INSERT INTO tptNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Vachu katanaunaꞌ kalaktapujnul ni aspajun para katanil, y katanaunaꞌ kalaktapujnul ni aqstijun para kalaqꞌaqxtaqmal. ");
INSERT INTO tptNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Maqataun kꞌiu yu ltakni yucha jantu xavakan. Pero ni kitꞌin kakmaqnikanaꞌ mas jantu tꞌujuꞌ kintalaqalhin. ¿Ex tas katamakayan uxiknankꞌan yu va tacha xixni kꞌiu untꞌatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Va talhaꞌal ni Jesús kun pumatꞌuy tachꞌinin yu ixtamakata talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ex chuncha tejkan tachaꞌal ni aspajun yu junkan Xajalukuti Aqtsul, va ancha tamakxtukmukꞌal ni Jesús kun yu qayntꞌuy laktuꞌunun, qayntaun la ixlhijakanaj yu aqayntaun la ixlhijamaqxu. ");
INSERT INTO tptNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ex chuncha va naul ni Jesús: —KimPay kꞌatꞌi, kꞌalaqmalaqmixinin, va jantu takꞌatsay yu tamakay. Ex ancha ni tropas talalaqlvaqnil ixlaqchꞌiti ni Jesús. Tamakal taun suerte para katalalhajal. ");
INSERT INTO tptNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Vachu ancha tayanal ni lapanakni xalaqtsꞌinin. Vachu ni lhachimoꞌonun ixtalaktuꞌuy, va tanaul: —Yu aniy incha laqmalaqtaxtuy lapanakni, ex vachuꞌ kamalaqtaxtukal yucha xꞌaman incha laqsaval ni Cristo yu laksakta Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ni tropas vachu talaktuꞌul. Ixtalaqmin, ixtaxtaqniputun vinagre yu skajni. ");
INSERT INTO tptNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Va ixtanajun: —Incha laqsaval xalhachimoꞌonuꞌ israelitas kꞌatꞌi, ex kꞌamalaqtꞌaxtꞌukꞌa meꞌeman. ");
INSERT INTO tptNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ancha vachuꞌ tsꞌoqkanta la ixꞌaqtsul ni kurus, va najun: “Yu aniy va ixJalhachimoꞌonukꞌan ni israelitas.” Va chuncha istsꞌoqkanta laka lhichivin Griego ali laka lhichivin Latín ali laka lhichivin Hebreo. ");
INSERT INTO tptNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Vachu qayntaun yu laktuꞌunuꞌ yu ixtꞌajukꞌal ni Jesús va ixlaktuꞌuy, va najun: —Incha laqsaval ni Cristo kꞌatꞌi, ex kꞌamalaqtꞌaxtꞌukꞌa uxintꞌi meꞌeman y vachu kilamalaqtaxtuu ni kijnankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero yu aqayntaun yu ixtꞌajukꞌal ni Jesús, va laqꞌaymal por laktuꞌul ni Jesús, va naul: —Ka jantu tꞌalhauniy ni Dios ni vachu va chun maꞌanlꞌajnan tacha ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pero ni kijnankꞌan chavaycha laqsaval maqanlqajnanau por yu makau talaqalhin. Pero yu aniy jantu tuꞌuchun kamakal. ");
INSERT INTO tptNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ex va naul, va junkal ni Jesús: —Jesús, kꞌimpꞌastꞌaktꞌi tejkan kꞌatꞌanchꞌoꞌoyeꞌe jalhachimoꞌon. ");
INSERT INTO tptNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ex ni Jesús junil: —Laqsaval kunan, chavaycha kꞌintꞌatꞌauleꞌe laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Va atunkuj ixjunita pero va putsꞌislhi ni lakamunukpaꞌ tus laꞌatꞌutu putoqoxata. ");
INSERT INTO tptNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Va tacha kalakapuchꞌapakal ni julchan val. Vachuꞌ ni ay lakatajtan va taꞌexlhi xalaqchꞌiti yu ixjukꞌal ixtaꞌajna lakatajtan taꞌan lhimalakchaukanta taꞌan ixvil ixtapꞌasta Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ex chuncha ni Jesús va la pꞌays chivinil, va naul: —KimPay, kmaqxtaqniyancha ketsukunti. Ex tejkan chuncha naul va nimancha nil. ");
INSERT INTO tptNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ex chuncha yu xaꞌukxtin tropas tejkan laqtsꞌil tachun yu tapasal, va ay makal ni Dios tejkan naul: —Laqsaval, yu aniy lapanaki, yucha ox ixjunita. Jantu tuꞌuchun laqtaqal kalhitsukul. ");
INSERT INTO tptNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tachun ni lapanakni yu ancha ixtayanal tejkan talaqtsꞌil yu tapasal, va taꞌaqtayl jatankilaksakan por ixjamaqanitkꞌan, ex taꞌanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero tachun ni lapanakni yu ixtamispay ni Jesús la maqati ixtayanal, va ixtalakaꞌan, vachu kun ni xanatin yu tatꞌaminchal Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Vachuꞌ ixꞌalin qayntaun lapanaki yu ixjunkan José, va machaqaꞌ putaulan Arimatea. Yucha va xaꞌay lapanaki kun ni israelitas. Va la ox lapanaki ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jantu kalhipaꞌinil yu tacha ixtalhichiviniy ni Jesús ni ixtꞌalhachimoꞌonun, vachu jantu kalhipaꞌinil tacha tamakal. Yucha ixpakxanꞌita kalhachimoꞌonul ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Taval yucha laqkilal ni Pilato, va kiskꞌinil ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ex xtaqnikal lakatin kaꞌal pꞌuxnuꞌ. Va pachꞌil kun lman laqchꞌiti. Ex maknul laka putaknun yu ixmakakanta laktalpa, va sastꞌikaꞌ ixjunita, jantukaꞌ ixtamapatsay. ");
INSERT INTO tptNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ex chuncha va laycha xajulchan jastaknati ixjunita tejkan jantu ixlaqxtaqnikan lakatin katatapatsal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ni xanatin yu tatꞌamil ni Jesús xaꞌestado Galilea va tatꞌaꞌal ni José. Va talaqtsꞌil ni putaknun yu tacha makakal taꞌan maknukal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ex taꞌanchoqol laqa chaqaꞌ, va talaꞌoxil ni kꞌuchꞌu yu laqseꞌejenꞌe yu ixtꞌamaknukan ni janinin. Ex tastaknal yu xajulchan jastaknati tacha ixlhinaunkan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ex chuncha ni laktuminku tejkan ixtunkuminta, taꞌal laka putaknun, va talhaꞌal ni kꞌuchꞌu yu laqseꞌejenꞌe yu ixtalaꞌoxita. Vachu ixtalatꞌaꞌanta alati xanatin. ");
INSERT INTO tptNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ex chuncha tachaꞌal, talaqtsꞌil ni chiyux va ixmoqosukantacha. Yucha ni chiyux yu ixpumalakchaukanta laka putaknun. ");
INSERT INTO tptNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tatanul laka putaknun. Jantu katatemal ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Chuncha va vak takꞌatsal. Ex ancha tatasul qayntꞌuy lapanakni, va laktꞌatayakal ni xanatin. ");
INSERT INTO tptNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ex ayaj tatalhanal, va tataꞌaqtsoqoqtal, tamaqayntal ixꞌaqtsulkꞌan laka tꞌun. Va lakjunkal: —¿Valiꞌiycha lakxkꞌauyatꞌik yu kujta taꞌan tataknuy yu janinin? ");
INSERT INTO tptNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jantucha aniy katamal, va kujchoqotacha. Kꞌapꞌastꞌaktꞌik yu tajunin tejkan ixtiꞌukxuyal Galilea. ");
INSERT INTO tptNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Va tajunin yu Sasꞌatꞌa Lapanaki va kamaqxtaqkanaꞌ la ixtamakakꞌan yu talaktuꞌunun, va kamakxtꞌukmukꞌakanaꞌ laka kurus pero kakujchoqoyaꞌ yu laꞌatꞌutunuꞌ julchan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ex chuncha ni xanatin va tapastakchoqol yu laqlhixaqalal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ex tataxtuchoqol ni laka putaknun, taꞌal, va talajunꞌol yu pumakautaun kun yu alati ixtꞌaltanan ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ni anchanu xanatin va María yu machaqaꞌ Magdala, ali Juana ali María ixnati ni Jacobo, ali vachuꞌ yu alati xanatin, va chuncha talajunil yu ixtamalaqachan Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero yu ixtamalaqachan Jesús va talhilal ni va lokoj ixchivintikꞌan ni xanatin, xlhiyucha jantu katalhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero ni Pedro ostaulal, takyauꞌal laka putaknun, talaknul, va laqtsꞌil ni va ixꞌaman mal ni laqchꞌiti. Ex chuncha anchoqol laqa chaqaꞌ, valiꞌiy saq lakpastaknal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ex chuncha ni anchanuꞌ julchan qayntꞌuy ixtꞌaltanan Jesús ixtaꞌanta taun putaulan yu junkan Emaus, va tacha laqakautaun kilometros ixlhimaqati Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ixtalhilakchiviniy tachun yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Taval tejkan chuncha ixtalakchiviniy, ex ni Jesús yucha chil, va laktꞌaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero lakmakakal para jantu katamispal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ex ni Jesús va lakjunil: —¿Tisuncha lhilakchꞌivinatꞌik aniy lakatin? ¿Valiꞌiycha maꞌanininatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ex yu junkan Cleofas va naul: —Tachun ni lapanakni yu ixtatꞌajuncha laka putaulan Jerusalén takꞌatsay yu ancha tapasal, ka vamun uxintꞌi jantu kꞌatsꞌay. ");
INSERT INTO tptNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ex ni Jesús laklhisakmil: —¿Tisuncha tapasal? Ex tanaul: —Va yu Jesús yu machaqaꞌ Nazaret, yucha va qayntaun lapanaki yu ixlaqputeꞌey ixchivinti Dios. La ixtalakaꞌukxpuꞌ Dios y la ixtalakaꞌukxpukꞌan tachun ni lapanakni va ixtasuy ixtapꞌasta yu ixmakay kun yu ixchiviniy. ");
INSERT INTO tptNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ni xaꞌukxtinin kuras kun kijalhachimoꞌonunkꞌan tamukꞌanil laqtaqal para kamaqnikal. Ex chuncha tamakxtukmukꞌal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pero ni kijnankꞌan va xakpastakꞌau va yucha yu ixkintamalaqtaxtun ni kijnankꞌan yu israelitas juntau. Pero chuncha tapasal y chavaycha va paqtꞌutucha nita. ");
INSERT INTO tptNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero lati ni xanatin yu kintꞌaltanankꞌan va kintamaqsvan. Chavay tunkuminta tejkan taꞌal laka putaknun, ");
INSERT INTO tptNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","jantu katatemal ixlakatunaj. Ex taminchoqol va kintajunin va talaqtsꞌil ixmayulnin Dios yu tanaul ni va kujta ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ex lati yu ketꞌalaqaunin va taꞌal laka putaknun, va talaqtsꞌil vachu va tacha tanaul ni xanatin, jantu katatemal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ex chuncha ni Jesús lakjunil: —Va la pꞌas mijatapastakꞌatkꞌan, jantu ox lhakꞌapꞌupꞌinatꞌik tachun yu tanaul yu ixtalaqputeꞌey ixchivinti Dios maqancha. ");
INSERT INTO tptNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ka jantu kꞌatsꞌayatꞌik va tachun yu majkꞌatsal ni Cristo va chuncha ixmaqskꞌiniy katapasal para ex chuncha apalay ay kamakakal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ex chuncha ni Jesús aqtayl lakmasuniy tachun yu lhichiviniy ni yucha la ixchivinti Dios. Va aqtaynil kun yu istsꞌoqta ni Moisés y vachuꞌ yu ixtatsꞌoqta yu maqancha ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ex chuncha tachaꞌal ni putaulan taꞌan ixtaꞌuxaꞌan. Ex ni Jesús lal va tacha kaꞌuxaꞌal taꞌan apalay maqati. ");
INSERT INTO tptNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yuꞌuncha laqatapꞌasta talhijunil kalaktꞌataulal, va tanaul: —Kilatꞌataulau, va toqoxalcha, va laycha kaputsꞌislhi. Ex chuncha laktꞌatanul laqa chaqaꞌ para kalaktꞌataulal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ex chuncha tejkan ixlaktꞌavil laka mesa, chꞌapal ni pan, xtaqnil lhimalaqpuchuncha ni Dios, va laqcheꞌel, ex laqmaqxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ex chuncha ni Dios va lakmakal para katamispachoqol ni Jesús. Ex va niman laqmixtayal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ex talajunil siya yuꞌuncha: —Laqsaval, la xaꞌachanau tejkan ixkintaxaqalayan lakatin y vachuꞌ tejkan ixkintamalanin tacha naunputun ixchivinti Dios yu tsꞌoqkanta. ");
INSERT INTO tptNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ex chuncha tatayal, va niman taꞌanchoqol laka putaulan Jerusalén. Ancha talapaxtoqlhi yu pumakautaun kun yu alati ixtꞌaltanan ni Jesús, va ancha ixtataqxtoqta. ");
INSERT INTO tptNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ex tachun ni yuꞌuncha tanaul, va lakjunkal yu qayntꞌuy: —Laqsaval, kujchoqolcha kiJalhachimoꞌonukꞌan. Vachuꞌ tasunil ni Simón. ");
INSERT INTO tptNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ex chuncha yu qayntꞌuy va talaqputeꞌel yu tacha tatapasal lakatin y tacha tapumispachoqol ni Jesús tejkan laqcheꞌel ni pan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ex tejkan chuncha ixtalaxaqalay va laktasunil ni Jesús va ancha tayal, lakmastakꞌal, va naul: —Oxamaktauncha kꞌaꞌuntꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ex tatalhanal, va laqmaqsvakal. Ixtalhilay va qayntaun janiniꞌ yu ixtalaqtsꞌin. ");
INSERT INTO tptNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ex ni Jesús lakjunil: —¿Valiꞌiycha tꞌalhanantꞌik? ¿Valiꞌiycha chun pꞌastꞌakꞌatꞌikcha la melhanutikꞌan? ");
INSERT INTO tptNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kalaqtsꞌintꞌik kimakaꞌ kun kinchꞌajaꞌ. Va kitꞌin kunita. Kilachꞌapau para kakꞌatsꞌatꞌik, para kilamispau. Taun jalhitsukunuꞌ jantu lhitsukuy vakax nisin jalukuti tacha kilalaqtsꞌinau chuncha kunita. ");
INSERT INTO tptNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tejkan chuncha lakjunil, va lakmasunil ixmakaꞌ kun ixchꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero jantukaꞌ ixtalhakapuꞌan mas ixtalhakapuꞌanputun kun achati, va ixtatalhanan. Ex ni Jesús laklhisakmil: —¿Alin vayti? ");
INSERT INTO tptNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ex taxtaqnil tsꞌuniy makchaunti jatanti kun aqxtaun istsꞌalukꞌu seraj. ");
INSERT INTO tptNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ex chꞌapal, va uꞌol, ancha la ixtalakaꞌukxpukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ex lakjunil: —Tejkan xaklatꞌatiꞌukxuntayayau, ixklajunau va maqskꞌiniy chuncha kaktapasal tachun yu tsꞌoqkanta yu kilhichiviniy kitꞌin la ixlhachimoꞌon Moisés y la ixchivinti yu maqancha ixtalaqputeꞌey ixchivinti Dios kun yu tsꞌoqkanta laka salmos. ");
INSERT INTO tptNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ex chuncha va lakmalanil para katamalaqasil ni ixchivinti Dios yu tsꞌoqkanta. ");
INSERT INTO tptNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Va lakjunil: —Va chuncha kilhitsꞌoqkanta ni kitꞌin yu Cristo kunita. Ikmaqskꞌiniy kakmaqnikal ex yu laꞌatꞌutunuꞌ julchan kajkujchoqol. ");
INSERT INTO tptNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Vachu tsꞌoqkanta kaputeꞌekanaꞌ ni kintaqaꞌuti ni kalaklhijunkal tachun ni lapanakni para katamapaxal ixjatapastakꞌatkꞌan para kalaqmalaqmixinikal. Va chuncha kalaqlaqputeꞌenikanaꞌ aniy laka putaulan Jerusalén tus talakapuchux ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kꞌanaunapitik tachun yu tapasal tacha laqtsꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kitꞌin klamalaqachaniyaucha yu naul kimPay kataxtaqniyan. Pero uxiknan katꞌaulchꞌipitik aniy laka putaulan tus tejkan kꞌalaꞌaꞌiyapitik ni tapꞌasta yu kamintachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ex chuncha ni Jesús va laklhaꞌal ixtꞌaltanan tus alakataun putaulan yu junkan Betania. Ex laqmaqstal ixmakaꞌ va lakskꞌinil Dios para ox kataval ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ex chuncha tejkan tꞌajun skꞌiniꞌ, lakmakaul ixtꞌaltanan, va lhaꞌankal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ex chuncha yuꞌuncha tatoꞌoyal, va taꞌanchoqolcha laka putaulan Jerusalén, va ayaj taꞌachal. ");
INSERT INTO tptNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lhilhiy ixtavilanal lakatajtan, ay ixtamakay Dios. Chuncha kavalcha.");
INSERT INTO tptNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pꞌunaj tejkan tachun puꞌaqtaynil, va tavanancha ixlhiꞌalin qayntaun yu junkan ni Chivinti. Ni Chivinti va chꞌantaun ixtꞌaꞌalinta ni Dios, vachu ni anchanuꞌ Chivinti yucha va Dios ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yucha va chꞌantaun ixtꞌaꞌalinta ni Dios tejkan tachun puꞌaqtaynil. ");
INSERT INTO tptNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Va por yucha Dios makal tachun yu alin. Incha jantu kaꞌalil ni yucha, ex jantu ixmakakal tuꞌuchun yu alin. ");
INSERT INTO tptNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Va kun yucha minchal ni jatsukunti. Ni jatsukunti va tacha taun maklku yu jalakmasuniy ni lapanakni yu ox tin. ");
INSERT INTO tptNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Chuncha yu maklku tꞌoqx mapulkuy laka putsꞌisniꞌ. Ixtapꞌasta ni putsꞌisniꞌ jantu lay kamaqalhajal. ");
INSERT INTO tptNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ni Dios malaqachal qayntaun lapanaki yu ixjunkan Juan. ");
INSERT INTO tptNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yucha mil va para kalhichivinil ni anchanu maklku para chuncha lay katalhakapuꞌal tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pero ni Juan yucha jantu ni maklku kaval. Yucha malaqachakal va para kalhichivinil yu anchanuꞌ maklku para katamispal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ni anchanuꞌ maklku va yu laqsaval mapulkuy la ixjatsukuntikꞌan tachun ni lapanakni. Va yucha ixminta aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yucha makal ni lakamunukpaꞌ, ex aniy kilachil, pero ni lapanakni yu ixtavilanal aniy jantu katamispal. ");
INSERT INTO tptNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kilachil la ixtꞌun pero ixlapanakni jantu katalaqaꞌil. ");
INSERT INTO tptNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ni lapanakni yu ox talaqaꞌil, yu talhakapuꞌal, yuꞌuncha jalaqxtaqnil ixtapꞌasta para kataval sasꞌatꞌan Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Va Dios yu jalakmakal sasꞌatꞌan. Jantu chuncha katatsukul la ixlakatunajkꞌan. Vachuꞌ jantu por yu ixtanajun lapanakni. Va Dios yu chuncha jalakmakal. ");
INSERT INTO tptNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ni anchanu yu junkan ni Chivinti yucha kiilhitsukuchil ixlakatunaj y val lapanaki, ex taulal chꞌantaun kun kijnan. Vamun yuꞌ minchal kun Dios. Xlhiyucha klaqtsꞌiu ni laqsaval la ay ixjunita. Va ayaj qalꞌox y tachun yu masuy va laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ni Juan lhichivinil ni yucha, va pꞌays naul: “Va yucha yu kitꞌin xaklajunau kaminaꞌ astan. Pero mas kamil astan, yucha ixlhiꞌalin tejkan kitꞌin jantukaꞌ xaktsukuy. Xlhiyucha yucha apalay ay xajantu kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ex yu kijnan tachun laqaꞌiniu yu lajꞌay ixmaqaliti, yucha kintaxtaqlhaanitan yu lajꞌoxi. ");
INSERT INTO tptNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ni ixlhachimoꞌon Dios lhimil qayntaun lapanaki yu ixjunkan Moisés. Va Jesucristo lhimil yu ay japaxkanti ali ni chivinti yu laqsaval kintamasuniyan Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jantu matichun kalaqtsꞌil ni Dios. Ni istsꞌal yu achaniy yucha va chꞌantaun tꞌavil ixPay. Va yucha kintamasunin tacha junitacha ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ni israelitas yu machaqan Jerusalén tamalaqachanil kuras ali levitas ni Juan ni katalhisakmil tasꞌayucha ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tejkan talhisakmil, niman jalakjunil: —Ni kitꞌin jantu ni Cristo kakval. ");
INSERT INTO tptNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ex astan tajunchoqol: —¿Ex tasꞌayucha kꞌatꞌi? ¿Uxintꞌicha kꞌatꞌi ni Elías yu maqancha ixlaqputeꞌey ixchivinti Dios? Ex yu Juan naul: —Jantu yuꞌ kakval. Ex aaqtaun tajunil: —¿Ex tasꞌayucha unitꞌa ni uxintꞌi? ¿Uxintꞌicha ni lapanaki yu maqancha ixtanajun tsꞌanqay kamil astan laqputeꞌeniꞌ ixchivinti Dios? Ex qaltayanal: —Jantu yuꞌ kakval. ");
INSERT INTO tptNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aaqtaun tajunchoqol: —Kilajuniu tasꞌayucha kꞌatꞌi ni uxintꞌi. Tsꞌanqay kajkunchoqoo yu kintamalaqachan. ¿Tas naꞌuncha uxintꞌi ni taꞌayucha kꞌatꞌi? ");
INSERT INTO tptNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ex jalakjunil ni Juan: —Kitꞌin kunita ni lapanaki yu ixnaunkan kaminaꞌ, yu pꞌays tꞌasay lakakꞌavinan taꞌan jaxixninta, yu najun: “Kꞌamalaqltꞌiꞌatꞌikcha maqataun tin taꞌan kapuminaꞌ ni Jalhachimoꞌonuꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ni fariseos tamalaqachal ni anchanu lapanakni ni chuncha katalhisakmil ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ex aaqtaun talhisakmichoqol, tajunil: —Uxintꞌi naꞌun ni jantu Cristo kaꞌuntꞌi, nisin Elías, vachu jantu kaꞌuntꞌi ni anchanu lapanaki yu maqancha ixtanajun kaminaꞌ laqputeꞌeniꞌ ixchivinti Dios. ¿Ex valiꞌiycha maqchꞌajꞌavanancha? ");
INSERT INTO tptNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ex ni Juan va jalajqaltayl: —Ni kitꞌin va xkan kpumaqchajꞌavanan. Pero alin qayntaun siya uxiknan yu jantu mispꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yucha kaminaꞌ astan. Kitꞌin tus jantu kimpaxtoqniy kakmusxꞌoqnil xamusni ixvarachi. ");
INSERT INTO tptNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tachun yu aniy tapasal xalakatꞌun yu junkan Betania takuktachal xalaꞌaxkan Jordán. Ancha ixtꞌajun jamaqchajꞌavan ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tejkan atauncha julchan val ex ni Juan laqtsꞌil ni Jesús ixminta taꞌan ixyal. Ex naul ni Juan: —¡Kꞌalaqtsꞌintꞌik! Yucha ni Sasꞌatꞌa borrego yu Dios maqxtaqlhi tacha taun lapaxkan. Va yucha maqosuy ni talaqalhin yu alin lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yucha yu klhichivinil ni kitꞌin tejkan knaul ni minta qayntaun yu apalay ay xajantu yu kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jantu xakmispay taꞌayucha ixjunita. Pero xlhiyucha kitꞌin kminta jamaqchajꞌavanaꞌ ni lay katamispal kintꞌaꞌisraelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ni Juan vachu naul: —Kitꞌin klaqtsꞌil ni Espíritu Santo taꞌeltajuminchal tus laktꞌiyan tacha laqataun palumax, ex kiitoqslachil la ixkuktan ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ni kitꞌin jantukaꞌ xajkꞌatsay maticha ixjunita pero yu kimalaqachal kakmil jamaqchajꞌavanaꞌ kun xkan, yucha kijunil: “Kꞌalaqtsꞌineꞌe ni Espíritu Santo kataꞌeltajuminaꞌ, katoqslayanta la ixkuktan. Va yucha yu kamaqchajꞌavananaꞌ kun ni Espíritu Santo.” ");
INSERT INTO tptNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ni kitꞌin klaqtsꞌil. Chavay klhichivininta ni va yucha laqsaval Sasꞌatꞌa Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tejkan atauncha julchan val ex ni Juan ancha ixlaktayachoqol pumatꞌuy yu ixtatꞌaꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tejkan laqtsꞌil ni ixtꞌajun tapasanaꞌ ni Jesús ex ni Juan naul: —Kꞌalaqtsꞌintꞌik ni anchanu lapanaki. Yucha ni Sasꞌatꞌa borrego yu Dios malaqachal tacha taun lapaxkan. ");
INSERT INTO tptNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tejkan chuncha taqasmaklhi yu pumatꞌuy tacha naul ni Juan ex nimancha tatꞌaꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ex ni Jesús niman talaqaspꞌiklhi tejkan jalaqtsꞌil ni ixtatixkaulhaꞌanta. Va jalaklhisakmil: —¿Tisuncha tꞌaunatꞌikcha lakxkaunan ni uxiknan? Ex ni yuꞌuncha talhisakmil: —Jamalaniniꞌ, ¿tas ancha viltꞌi ni uxintꞌi? ");
INSERT INTO tptNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ni Jesús jalajqaltayl: —Kꞌatꞌantꞌik laqtsꞌinin taꞌan kvil. Ex taꞌal, talaqtsꞌil taꞌan ixvil. Ex ancha tamaqltoqoxalcha, va laꞌatꞌaticha putoqoxata ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Xaqayntaun ni yuꞌuncha yu taqasmaklhi ixchivinti ni Juan y tatꞌamil ni Jesús va ixjunkan Andrés, yucha ixlaqaj ni Simón Pedro ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ni Andrés niman kiilakxkaul yu ixlaqaj Simón, va junil: —Chavay ktemaucha ni Mesías. (Yucha naunputun Cristo, yu ixtanajun kamalaqachayaꞌ ni Dios.) ");
INSERT INTO tptNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Taval ni Andrés lhaꞌal ni Simón taꞌan ixyal ni Jesús. Tejkan laqtsꞌil Jesús ni Simón, va junil: —Uxintꞌi va Simón kꞌatꞌi, yu istsꞌal Jonás. Pero chavaycha kaꞌunkꞌaneꞌe Cefas (yucha naunputun Pedro, yu naunputun Chiyux). ");
INSERT INTO tptNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tejkan tunkunchoqolcha ex ni Jesús pastaklhi kaꞌal la xaꞌestado Galilea. Ancha temal ni Felipe, va junil: —Kꞌintꞌatꞌatꞌicha ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ni Felipe va machaqaꞌ Betsaida ixjunita, la ixtꞌunkꞌan ni Andrés ali Pedro. ");
INSERT INTO tptNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ni Felipe al lakxkaunaꞌ ni Natanael. Tejkan temalcha va junil: —Chavaycha ktemaucha ni anchanu lapanaki yu maqancha lhitsꞌoqꞌulal ni Moisés la ixlhachimoꞌon Dios, vachuꞌ yu talhitsꞌoqꞌulal ni lapanakni yu ixtalaqputeꞌey ixchivinti Dios maqancha. Yucha va Jesús istsꞌal José yu machaqaꞌ Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ex ni Natanael va niman naul: —¿Lay kaꞌalil matichun ox yu machaqaꞌ Nazaret? Ni Felipe junchoqol: —Kꞌatꞌatꞌi y kꞌalaqtsꞌineꞌecha tas junita. ");
INSERT INTO tptNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tejkan laqtsꞌil ni Jesús va ukstsꞌuniy ixminta ni Natanael va junil: —Aniy minta qayntaun israelita yu jantu aqtaun jamakanunun. ");
INSERT INTO tptNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ex ni Natanael lhisakmil: ¿Tas kꞌimpꞌumispꞌaycha ni kitꞌin? Ex ni Jesús va junil: —Tejkan jantukaꞌ ixjuntaꞌiyan ni Felipe, tejkan ixyatꞌi la ixtaꞌapuꞌ xakꞌiu higuera, kitꞌin xaklhilaqtsꞌintancha. ");
INSERT INTO tptNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ni Natanael junil: —Uxintꞌi jamalaniniꞌ kꞌatꞌi, va Sasꞌatꞌa Dios unitꞌa, vachu uxintꞌi va yu ay xaJalhachimoꞌonuꞌ Israel. ");
INSERT INTO tptNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ex ni Jesús junil: —Chavay ni uxintꞌi ox kꞌilhakꞌapꞌupꞌin vamun por kunin ni klaqtsꞌin la ixqaltaꞌapuꞌ higuera. Astan kꞌalaqtsꞌineꞌe yu apalay lajꞌay axtoqnu xajantu yu aniy. ");
INSERT INTO tptNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Vachuꞌ jalakjunil ni Jesús: —Laqsaval klajunau, kaminaꞌ julchan tejkan kꞌalaqtsꞌinapitik ni laktꞌiyan katalaqltiꞌayaꞌ, vachu yu ixmayulnin Dios katataꞌeltajuyaꞌ y katapataxtuyaꞌ tejkan kintalaqminacha ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tejkan paqtꞌutucha val, alil taun lakxtuklati ancha laka putaulan Kaná, la xaꞌestado Galilea. Chuncha yu ixnati ni Jesús vachuꞌ ancha ixvil. ");
INSERT INTO tptNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ni Jesús kun ni lapanakni yu ixtatꞌaꞌanta vachuꞌ ixjalakjuntaꞌikanta taꞌan ixꞌalinta ni lakxtuklati. ");
INSERT INTO tptNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ex chuncha va miꞌol ni xaxkan uva. Ex yu ixnati ni Jesús va junil: —Chavay jantucha katalhitsukul xaxkan uva. ");
INSERT INTO tptNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ex ni Jesús va junil: —Kinati, ¿valiꞌiycha chuncha kꞌiꞌuncha? Tus chavaycha jantukaꞌ lakachin kijulchan. ");
INSERT INTO tptNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ex ni ixnati jalakjunil yu ixtatꞌajun tapatsanin: —Yu katajunan ni yucha, uxiknan kꞌamakꞌayapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chuncha va ancha ixvil laqachaxan aqxau yu jamakanti chiyux. Yucha va yu ixputajuy xkan yu ixtamapatsay ni israelitas, chuncha tacha yu ixputsukukꞌan ixjunita yu maqancha ixjapayankꞌan. Va si tsꞌanqay katachaꞌal kun xkan para ox kaval ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ex ni Jesús jalakjunil: —Kꞌalaqtsꞌamaꞌotꞌik kun xkan ni aniy aqxavin. Ex chuncha tamakal ni yuꞌuncha tus talaqtsamaꞌol tachun. ");
INSERT INTO tptNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ni Jesús jalakjunil: —Chavay kꞌamakꞌutꞌutꞌik lakatsꞌuniy ex kꞌalhipꞌinitꞌik yu jamakꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tejkan talhaanil ex ni makꞌatan kilkꞌatsal ni xkan pero va ixtapalata xaxkan uva. Yucha jantu kaxtaqnil kuenta toꞌoxtaycha ixmintachal. Pero yu tamujul, yuꞌuncha ixtakꞌatsay toꞌoxtay ixmintachal. Ex ni makꞌatan nimancha juntaꞌil ni tsꞌal, ");
INSERT INTO tptNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","va junil: —Tachun ni lapanakni pꞌunaj tamujuy yu ox xaxkan uva. Astan tejkan oxicha talhiꞌotsay ni lapanakni yu jalakjuntaꞌikan ex jamunikan ni xaxkan uva yu jantu la ox. Pero uxintꞌi tus chavaycha vananaj maꞌatꞌa ni xaxkan uva yu apalay ox. ");
INSERT INTO tptNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Chuncha tacha yu aniy xamakay ni Jesús, va yucha yu skutsajkaꞌ xamasuy lajꞌay axtoqnu, va makal laka putaulan Kaná taꞌan xaꞌestado Galilea. Va yucha pumasul ixꞌayaxtu. Ex ni lapanakni yu ixtatꞌaꞌanta talhakapuꞌal ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ex taval taꞌal laka putaulan Capernaúm chꞌantaun kun ixnati ali ixtꞌalaqaunin ali ni lapanakni yu ixtatꞌaꞌanta. Ancha tataqmaqal tsꞌuniy. ");
INSERT INTO tptNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Va laycha kalakachil ni Paxku yu ay ixkꞌatankꞌan ni israelitas. Ex ni Jesús alcha laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ex jalaktemal laka ay lakatajtan yu ixtastꞌay vakaxna ali borregos ali tukunuꞌ. Vachu jalaktemal taꞌan ixtavilanal yu ixtamapaxaniy ixtuminkꞌan ni lapanakni yu maqati ixtaminachal. ");
INSERT INTO tptNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Tejkan chuncha laqtsꞌil ni Jesús va chꞌapal maqataun cuarta y laqxoqxtuꞌol tachun yu ixꞌalin laka ay lakatajtan, chꞌantaun kun ni lapanakni ali ixborregoskꞌan ali ixvakaxkꞌan. Vachu yu ixtamapaxay tumin lakpumajꞌaniꞌol ixtuminkꞌan, vachuꞌ yu mesas jalaqmapuꞌaqstal. ");
INSERT INTO tptNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jalakjunil yu xastꞌanan palumax: —Kꞌalhipꞌintꞌikcha yu aniy axtoqnuꞌ. Yu aniy va ixchaqaꞌ ni kimPay. ¡Jantu kꞌamakꞌatꞌik taun ay pastꞌan! ");
INSERT INTO tptNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ex yu ixjalakmalaniy, yuꞌuncha tapastaklhi tacha ixnajunta taꞌan istsꞌoqꞌulakanta la ixchivinti Dios yu inchineꞌ najun: “Kitꞌin va kxiyax kunita por minchaqaꞌ tus va tacha taun jikmi yu kimpulakxavay.” ");
INSERT INTO tptNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Va chuncha ni israelitas talhisakmil: —¿Tis va suncha lajꞌay axtoqnuꞌ kꞌamakꞌayeꞌe yu kilamasuniyau incha alin mimpalhachimoꞌon para chuncha kꞌamakꞌatꞌi tachun yu aniy xamakꞌay? ");
INSERT INTO tptNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ex ni Jesús jalakjunil: —Kꞌalakpꞌujtꞌik ni aniy ay lakatajtan, ex ni kitꞌin va laꞌatꞌutu julchan kakmaqayauchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ni israelitas tajunil: —Ni aniy ay lakatajtan va cuarenta y seis jachꞌitin lal ixmaqayauka. ¿Ex lhilay yu uxintꞌi va laꞌatꞌutu julchan lay kꞌamaꞌayauchꞌoꞌoyeꞌe? ");
INSERT INTO tptNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ni ay lakatajtan yu lhichivinil ni Jesús yucha naunputun va ixlakatunaj ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xlhiyucha astan tejkan ixnitacha y takukchoqotacha ni Jesús ex yu ixjalakmalaniy tapastakchoqol tacha ixnajunta. Ex talhakapuꞌal chuncha tacha istsꞌoqkanta la ixchivinti Dios, vachu talhakapuꞌanil yu naul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Exnicha alil ni Paxku yu ay ixkꞌatankꞌan ni israelitas. Ni Jesús vananaj ixvil laka putaulan Jerusalén. Ni lapanakni ixtalaqtsꞌin ni lajꞌay axtoqnuꞌ yu ixmakay, xlhiyucha qaynlhuvaj talhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ni Jesús ox ixjalakmispay ni yuꞌuncha tacha ixtajunita, xlhiyucha ixkꞌatsay ni lati jantu laqsaval katalhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jantu ixmaqskꞌiniy matichun kajunil tacha ixtajunita ni lapanakni. Yucha ixjalakmispaniy ixjalhanutkꞌan, tisuncha jatapastakꞌati ixtalhitꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ixꞌalin qayntaun lapanaki, va fariseo ixjunita yu ixjunkan Nicodemo, yucha va qayntaun yu ixjalaklhichimoꞌoy ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Va laqkilal ni Jesús tejkan tsꞌis ixjunita, va junil: —Jamalaniniꞌ, kijnan kꞌatsayau ni va Dios malaqachatan para kilamiu masuninin. Yu va matichun kaval incha jantu chꞌantaun katꞌataulal ni Dios jantu lay kamakal lajꞌay axtoqnuꞌ chun tacha uxintꞌi makꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ex ni Jesús va junil: —Laqsaval kunan ni matichun lapanaki yu jantu katsukuchoqoyaꞌ, yucha jantu lay katanuyanta taꞌan lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ex ni Nicodemo lhisakmil ni Jesús, va naul: —¿Tas laycha kꞌapꞌutsꞌukꞌuchꞌoꞌo tejkan xapaycha kaꞌuntꞌi? ¿Incha qayntaun lapanaki lay katanuchoqol la ixpajan ixnati y astan katsukuchoqol? ");
INSERT INTO tptNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ex ni Jesús junil: —Kitꞌin kunan, ni matichun lapanaki yu jantu kalhitsukuchoqoyaꞌ saystꞌi ixjatsukunti kun ni Espíritu ali xkan yucha jantu katanuyanta taꞌan lhachimoꞌonun Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Taꞌayuꞌ yu vamun tsukuy aniy yucha va valiꞌiy lapanaki. Yu tsukuy la ixtapꞌasta ni Espíritu, yucha lhitsukuy sastꞌi jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jantu vak kakꞌatsꞌa mas kunan ni maqskꞌiniy katsꞌukꞌuchꞌoꞌo saystꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ni un unilay taꞌan yucha najun. Mas kꞌaꞌasmaktꞌi ni makatꞌajun, jantu kꞌatsꞌay toꞌoxtay puminta nisin toꞌoxtaycha kapuꞌanaꞌ. Vachu va chuncha tajunita ni lapanakni yu tatsukuy la ixtapꞌasta ni Espíritu. ");
INSERT INTO tptNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ni Nicodemo aaqtaun lhisakmichoqol ni Jesús, va junil: —¿Tas laycha kaval? ");
INSERT INTO tptNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ex ni Jesús junil: —Uxintꞌi mas ay jamalaniniꞌ kꞌatꞌi aniy xalakatꞌun Israel, ¿jantu malaꞌasiy yu tacha kunan? ");
INSERT INTO tptNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kitꞌin laqsaval kunan ni kijnan klhichivinanau yu laqsaval ijkꞌatsayau. Kijnankꞌan klhitaulau yu laqsaval klaqtsꞌiu. Mas chuncha jantu kilalhakapuꞌaniyau yu klajunau. ");
INSERT INTO tptNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tejkan klalhixaqalayau axtoqnu yu alin aniy lakamunukpaꞌ jantu kilalhakapuꞌaniyau. ¿Ex tas kꞌapꞌulhakꞌapꞌupꞌintꞌikcha incha kaklalhixaqalau yu alinachal laktꞌiyan? ");
INSERT INTO tptNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Jantu matichun kapataxtul laktꞌiyan, vamun yu minchal laktꞌiyan. Yucha ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chuncha tacha Moisés maꞌostaulnil maqataun tsapul taꞌan ixjaxixninta lakatꞌun, vachu chun kakmaꞌostaulnichoqokanaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ex chuncha tachun yu kintalhakapuꞌanan jantu katatsꞌanqayaꞌ, va katalhitsukuyaꞌ jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ni Dios va por ayaj ixjalakpaxkay xalapanakni aniy lakamunukpaꞌ, va maqxtaqlhi yu vamun yuꞌ istsꞌal. Ex chuncha tachun yu katalhakapuꞌanaꞌ ni yucha jantu katatsꞌanqayaꞌ, va katalhitsukuyaꞌ jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ni Dios jantu kamalaqachal istsꞌal para kalaqxtaqnil maqanlqajnati ni lapanakni. Va para kaamalaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Taꞌayuꞌ yu lhakapuꞌan ni Sasꞌatꞌa Dios, yucha jantu kamukꞌanikanaꞌ laqtaqal. Pero taꞌayu yu jantu lhakapuꞌan, yucha mukꞌanikantacha laqtaqal, va jantu kalhakapuꞌal yu vamun yuꞌ Sasꞌatꞌa Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jalakmukꞌanikantacha ixlaqtaqalkꞌan. Jantu talhakapuꞌan mas chil ni maklku yu mapulkuy ni lakamunukpaꞌ. Vamun tamaqamay yu japutsꞌisniꞌ, jantu tamaqamay yu jatunkunuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Yu tꞌajun makan laqtaqal jantu maqamay katalakanul taꞌan alin ixmaklku ni Dios, jantu najun katasul yu tꞌajun makan. ");
INSERT INTO tptNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero yu vas makay yu lajꞌox, yucha talakanuy taꞌan alin ixmaklku ni Dios para katasul ni tꞌajun makan tacha yu Dios najun. ");
INSERT INTO tptNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ex chuncha astan ni Jesús alcha taꞌan xaꞌestado Judea, chꞌantaun jalaktꞌaꞌal yu ixjalakmalaniy. Ancha tataqmaqal, ixtꞌajun jamaqchajꞌavan. ");
INSERT INTO tptNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Vachu ni Juan ixtꞌaunachal jamaqchajꞌavan ancha xalakatꞌun Enón, ixlhiꞌukstsꞌuniy Salim, ancha ixꞌalin lhuu xkan. Ni lapanakni ixtalaqchaꞌan, ex ancha ixjalaqmaqchajꞌavakan. ");
INSERT INTO tptNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jantukaꞌ ixtamanuy laka pachꞌin ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taval lati lapanakni yu ixjalakmalaniy ni Juan taꞌaqtayl tatꞌachiviniy aqayntaun israelita. Taꞌaqtayl talhilakchiviniy tacha ixputsukukꞌan ni yuꞌuncha yu maqskꞌiniy kachꞌaꞌamajꞌa tachun yu jantu ox para ox kalaqaꞌin ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ex talaqꞌal ni Juan, va tajunil: —Jamalaniniꞌ, chavaycha yu ixyal chꞌantaun kun uxintꞌi takuktachal ni laka Jordán, yucha tꞌajun jamaqchajꞌavan. Va Jesús yu kilalhixaqalau pꞌunaj. Tachun ni lapanakni jantucha kintalaqꞌanan, va tatꞌaꞌan ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ex ni Juan jalakjunil: —Jantu matichun lay laqaꞌiy tuꞌuchun incha Dios jantu kaxtaqnil. ");
INSERT INTO tptNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Uxiknan ox kilaqalasmakvi ni vas klajuniu ni kitꞌin jantu yu Cristo kakval. Kitꞌin kunita va qayntaun yu malaqachakal, yu japꞌulminta, ex astan ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Taꞌan alin lakxtuklati yu laqsaval lhitꞌajun la ixtamakaꞌ ni jatsiꞌi va yu tsꞌal. Tejkan chiviniy ex ixꞌamigo ni tsꞌal vamun qasmatꞌa y lhiꞌachantajuy. Ex vachu chun klhiꞌachantajuy ni kitꞌin, va taqayntsay yu ixkintsꞌanqaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yucha minta para kalalhaval ixtapꞌasta. Yu kintapꞌasta ni kitꞌin, yucha maqskꞌiniy kataꞌeltajul. ");
INSERT INTO tptNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yu mintachal talman yucha lhichimoꞌoy tachun yu alin. Pero yu valiꞌiy lapanaki yu minchal aniy lakamunukpaꞌ, yucha vamun lay lhichiviniy yu alin aniy. Yu mintachal laktꞌiyan lhichimoꞌoy tachun. ");
INSERT INTO tptNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yucha mas lhichiviniy tachun yu laqtsꞌintacha ali yu qasmakta pero jantu matichun lhakapuꞌan tacha yu yucha najun. ");
INSERT INTO tptNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero yu lhakapuꞌan yucha masuy ni va laqsaval yu najun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ni lapanaki yu Dios malaqachal yucha vachuꞌ xtaqnikal ixꞌEspíritu, xlhiyucha lhichiviniy ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yu ixPay ayaj achaniy isTsꞌal xlhiyucha yucha maqxtaqnil lhuu tapꞌasta para kalhichimoꞌol tachun yu alin. ");
INSERT INTO tptNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Chuncha taꞌayuꞌ yu kalhakapuꞌanaꞌ ni isTsꞌal yucha lhitꞌajun jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Yu jantu lhakapuꞌan ni isTsꞌal yucha jantu kalhitsukuyaꞌ ni anchanuꞌ jatsukunti, va paxtoqniy yu ay maqanlqajnati yu xtaꞌa ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ni fariseos taqasmaklhi ni apalay lhuu lapanakni ixtatꞌaꞌan ni Jesús xajantu ni Juan. Vachuꞌ taqasmaklhi ni apalay lhuu yu ixjamaqchajꞌavay, ");
INSERT INTO tptNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","mas jantu Jesús kamaqchajꞌavanal, va yu lapanakni yu ixjalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Xlhiyucha ni Jesús nimancha taxtul xaꞌestado Judea, va anchoqolcha xaꞌestado Galilea. ");
INSERT INTO tptNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Para kachaꞌal maqskꞌiniy kapuꞌal xaꞌestado Samaria. ");
INSERT INTO tptNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tejkan tanuchal xalakatꞌun Samaria va chaꞌal taun putaulan yu junkan Sikar. Ancha va ixlhiꞌukstsꞌuniy ni lakatꞌun yu maqancha ixlhitꞌajun Jacob, ixpaykꞌan tachun yu israelitas, va xtaqnil istsꞌal yu José ixjunkan. ");
INSERT INTO tptNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ancha ixvil taun lakxkan yu ixlhimapaqaꞌukan ixlakxkan ni Jacob. Ancha chinchal ni Jesús. Oxicha ixlaqalhoqonta ixjaltanti ex ancha taulalcha. Pero va laycha atunkuj ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ex ixtꞌaltanan yu ixjalakmalaniy, ixtaꞌanta inin laka putaulan yu kataꞌul. Ex nimancha chinchal qayntaun xanati yu machaqaꞌ Samaria va ixminta makutunuꞌ xkan. Chuncha ni Jesús va junil: —Kꞌintꞌaꞌoqtꞌi tsꞌuniy mixkan. ");
INSERT INTO tptNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ni israelitas jantu ox ixtalalhaꞌan kun yu machaqan Samaria, xlhiyucha ni xanati va junil: —Uxintꞌi va israelita kꞌatꞌi. ¿Valiꞌiycha kꞌiskꞌiniycha xkan? Kitꞌin va aniy machaqaꞌ Samaria kunita. ");
INSERT INTO tptNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ex junil ni Jesús: —Incha uxintꞌi kꞌamispꞌatꞌi yu xtaꞌa ni Dios, vachuꞌ incha kꞌimispꞌatꞌi ni kitꞌin yu iktꞌaunan skꞌininin xkan, ex yu uxintꞌi kꞌiskꞌinin kitꞌin ex kakxtaqnin xkan yu xtaꞌa jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ex yu xanati va junil: —Ni uxintꞌi jantu kꞌalhitsꞌukꞌu yu kꞌapꞌumakꞌutꞌu ni xkan. Ni lakxkan ayaj pulman. ¿Ex tas ancha kaꞌiyeꞌe ni xkan yu kꞌixtꞌaqniyeꞌe yu lhitꞌajun jatsukunti? ");
INSERT INTO tptNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yu maqancha kimpaykꞌan Jacob yucha kintamakaunin aniy lakxkan taꞌan ixꞌotꞌa ni yucha, y vachu kun tachun sasꞌatꞌan y tachun ixtalhitsukukna, va si aniy ixtaꞌotꞌa. ¿Ex ni uxintꞌi apalaycha ay lapanaki kꞌatꞌi xajantu yu Jacob? ");
INSERT INTO tptNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Chuncha ni Jesús va junil: —Tachun yu taꞌotꞌa ni aniy xkan yuꞌuncha aqtsꞌiyaj va kataꞌoqputunchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero matichun yu kaꞌoqlhi ni xkan yu kitꞌin kakxtaqyaꞌ, yucha jantucha aqtaun kapukikxixaꞌ. Ni xkan yu kxtaꞌa ni kitꞌin yucha kunaꞌ va tacha taꞌan mukxi xajachil xkan laktalpa. Kalhixajtachal taun jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ex ni anchanuꞌ xanati va junchoqol ni Jesús: —Kꞌixtꞌaqnin ni anchanuꞌ xkan para jantucha aqtaun kajkꞌoqputunchoqol, vachu jantucha kakmil uchuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chuncha ni Jesús va junil: —Kꞌapꞌinchꞌiy juntaꞌin ni mixapay ex kꞌatꞌanchꞌoꞌo aniy. ");
INSERT INTO tptNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ex ni anu xanati qaltaychoqol, va junil: —Jantu kaklhitsukul kixapay. Ex ni Jesús junchoqol: —Uxintꞌi ox xaꞌaltꞌayanan ni naꞌun jantu kꞌalhitsꞌukꞌu mixapay. ");
INSERT INTO tptNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Laqsaval ni uxintꞌi ixlhitꞌaꞌun pumakis mixapaynin. Vachu yu chavaycha lhitꞌaꞌun jantu laqsaval mixapay kaval. Va laqsaval yu uxintꞌi naꞌun. ");
INSERT INTO tptNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Tejkan chuncha qasmaklhi ni xanati, va junil: —Chavaycha klaqtsꞌinan tacha qayntaun yu laqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","La maqancha aniy ixtamin yu kepayankꞌan ni kijnan yu aniy machaqan Samaria kuntau. Yuꞌuncha ixtamin aniy laka aspajun para katatoꞌoyal ni Dios. Pero yu uxiknankꞌan israelitas untꞌatꞌik kilalhijunau ni va maqskꞌiniy kaktoꞌoyau Dios vamun laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ex ni Jesús junil: —Uxintꞌi, xanati kꞌatꞌi, kꞌilhakꞌapꞌupꞌinincha yu kunan. Kaminaꞌ ni julchan tejkan uxiknankꞌan jantucha katꞌoꞌoyayapitik ni kimPay Dioskꞌan mas aniy laka aspajun, mas kaval laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ni uxiknan tꞌoꞌoyayatꞌik yu jantu mispꞌayatꞌik. Kijnankꞌan ktoꞌoyayau yu kmispayau. Ni Jamalaqtaxtunuꞌ mintachal kun yu israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ni julchan yu istsꞌanqay kalakachil yucha chavaycha lakachin, tejkan ni lapanakni yu laqsaval katatoꞌoyayaꞌ kimPay Dioskꞌan, katatoꞌoyayacha chuncha tacha lhinajun ixꞌEspíritu. KimPay Dioskꞌan yucha lakxkajuy lapanakni para chuncha katatoꞌoyal. ");
INSERT INTO tptNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ni Dios yucha va Espíritu junita xlhiyucha yu tatoꞌoyay tsꞌanqay katatoꞌoyal tacha lhinajun ixꞌEspíritu yu laqsaval masuy tacha junita. ");
INSERT INTO tptNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ex ni anchanuꞌ xanati va junil: —Kitꞌin ox ijkꞌatsay ni kaminaꞌ ni Mesías (va naunputun Cristo yu ixtanajun kaminaꞌ). Tejkan kaminaꞌ ex yucha ox kintamasuniꞌoyan tachun. ");
INSERT INTO tptNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ni Jesús junil: —Va yucha ni kitꞌin yu ktꞌaunan tꞌachivinin ni uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tejkan chuncha ixtꞌajun chivin ex tachinchoqolcha ixtꞌaltanan yu ixjalakmalaniy. Ni yuꞌuncha tus taun talhilal tejkan talaqtsꞌil ixtꞌachivijyal qayntaun xanati. Pero jantu matichun kalhisakmil yu ixmaqskꞌiniy, vachu jantu katalhisakmil tisuncha ixtatꞌajun lhilakchivinin. ");
INSERT INTO tptNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ex ni anchanu xanati makaulalcha ni ixꞌaqxau, va anchoqolcha la ixchaqaꞌ. Tejkan chaꞌal va lakjunil ni lapanakni katatꞌaꞌal, va naul: ");
INSERT INTO tptNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Kꞌatꞌantꞌikcha laqtsꞌinin qayntaun lapanaki yu tus kijunꞌol tachun yu kitꞌin kmakata. Ka va lay va yucha ni Cristo yu ixtanajun kaminaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Chuncha nimancha tataxtul ni laka putaulan, va taꞌalcha taꞌan ixyachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tejkan jantukaꞌ ixtalaqchaꞌan ex ni ixtꞌaltanan ixtatꞌajun lhijuninin para kavayl pero mas ixtalhijuniy jantu ixchavaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ni Jesús jalakjunil: —Ni kitꞌin klhitꞌajun vayti yu uxiknankꞌan jantu mispꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ex ixtꞌaltanan yu ixjalakmalaniy, taꞌaqtayl talakchiviniy, ixtakꞌatsaputun incha va matichun kalhiminil ixvayti. ");
INSERT INTO tptNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ni Jesús jalakjunil: —Alin aputaun kivayti. Kitꞌin kmakay yu lhipaꞌiniy ni Dios yu kimalaqachal tus kakmakaniꞌol ixlhitapatsa yu kilhijuniy. Anchanu lhitapatsa va tacha kivayti. ");
INSERT INTO tptNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Uxiknan naunatꞌik: “Ni chavaycha vananaj tsꞌanqay laꞌatꞌati malkuyuꞌ para kalakachil ni jaxqanti.” Pero kitꞌin klajunau tsꞌanqay kꞌamakꞌatꞌik kuenta ni taꞌan jachꞌananti va oxicha para kaxqaꞌikal. ");
INSERT INTO tptNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Chuncha qayntaun lapanaki yu jaxqanan yucha laqaꞌiy ixlhilhajati, ex yu xqaꞌikal yucha xtaꞌa jatsukunti. Ex pumatꞌuy talhiꞌachantajuy, yu chꞌal ali yu jaxqanal. ");
INSERT INTO tptNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Laqsaval chuncha junita tacha klajunau: “Qayntaun tapatsay para kachꞌanlhi, aqayntaun para kaxqanal.” ");
INSERT INTO tptNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kitꞌin klamalaqachau jaxqanan taꞌan jantu kachꞌantꞌik. Jalakxkꞌauyatꞌik lapanakni yu kintalhakapuꞌal por yu tajunilcha alati lapanakni yu talaqtapatsatacha. Uxiknankꞌan chavaycha aqchꞌapꞌatꞌatꞌik la ixlhitapatsakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ni anu xanati ixjalakjunita ixtꞌamachaqan ni ixnajunta Jesús tachun yu ixmakatacha, xlhiyucha ayaj lhuu lapanakni yu machaqan Samaria talhakapuꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ex tejkan tachil ni machaqan Samaria taꞌaqtayl tatapayniniy ni Jesús para katamakaul kun yuꞌuncha. Ex ni yucha ancha loqojlhi paqtꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Chuncha apalay lhuu talhakapuꞌal tejkan taqasmaklhi yu ixnajun ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ex va tajunil ni xanati: —Chavaycha klhakapuꞌanau pero jantucha vamun por yu kilajuniu. Va kijnankꞌan ijqasmakvi ixchivinti, xlhiyucha klhakapuꞌanau. Vachu ijkꞌatsayau ni yucha va yu laqsaval ni Cristo, yu Jamalaqtaxtunuꞌ aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Chuncha tejkan paqtꞌuy val, va taxtuchal ancha Samaria ni Jesús, ex al tus xaꞌestado Galilea. ");
INSERT INTO tptNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ni yucha ixnajunta ni qayntaun lapanaki yu laqputeꞌey ixchivinti Dios jantu toꞌoyakan la ixtꞌun. ");
INSERT INTO tptNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ex tejkan chaꞌal Galilea ni lapanakni yu ancha machaqan va ox talaqaꞌil. Ni yuꞌuncha vachuꞌ ixtaꞌanta Jerusalén tejkan alil ni xakꞌatan Paxku. Ancha talaqtsꞌinꞌol tachun lajꞌox yu makal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ex astan anchoqol laka putaulan Caná ancha xalakatꞌun Galilea taꞌan yu valiꞌiy xkan maxajnichal xaxkan uva. Ancha ixꞌalin qayntaun yu ay jalhachimoꞌonu yu ixtapatsaniy ni rey. Yucha ixlhitꞌajun qayntaun istsꞌal yu ixtaqanꞌay laka putaulan Capernaúm. ");
INSERT INTO tptNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ni anchanu lapanaki kꞌatsal ni Jesús va taxtul Judea, va chinchal Galilea. Ex niman al tapaynininiꞌ ni katꞌaꞌal la ixchaqaꞌ. Ixnajun palay kamakanichoqol istsꞌal yu va laycha kanil. ");
INSERT INTO tptNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Chuncha yu Jesús va niman naul: —Uxiknankꞌan jantu kilalhakapuꞌaniyau kinchivinti incha jantu pꞌunaj laqtsꞌinꞌelayatꞌik lajꞌay axtoqnu yu kitꞌin kmakay. ");
INSERT INTO tptNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero yu jalhachimoꞌonuꞌ va naul: —Kꞌintꞌatꞌatꞌicha niman laqtsꞌiniꞌ kintsꞌal ni jantukaꞌ niy. ");
INSERT INTO tptNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Chuncha ni Jesús va junil: —Kꞌapꞌinchꞌoꞌocha la minchaqaꞌ, mintsꞌal palay junchoqota. Ex ni yucha lhakapuꞌal tacha junil ni Jesús y va anchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tejkan va ixꞌantakaꞌ la ixchaqaꞌ ex takipaxtoqꞌil ixꞌoqxtamatin, va tajunil: —Mintsꞌal oxicha vilchoqol. ");
INSERT INTO tptNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ex laklhisakmil: —¿Tisuncha hora aqtaynil ox kꞌatsanchoqoy? Ex tanaul ni yuꞌuncha: —Va kutancha laqataun putoqoxata tejkan taꞌeltajunichoqol iskakati. ");
INSERT INTO tptNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ex chuncha ni japay makal kuenta ni anchanu hora va exnicha tejkan junil ni Jesús: “Mintsꞌal va palaycha junchoqota.” Ex ni anchanu japay kun tachun ixlapanakni talhakapuꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ex chuncha kun yu aniy, va aqtꞌuycha makal ni Jesús yu lajꞌay axtoqnuꞌ tejkan minchal Judea, chinchal Galilea. ");
INSERT INTO tptNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ex astan tejkan tapasaꞌol tachun yu aniy va ixjunita aputaun ixkꞌatankꞌan ni israelitas. Chuncha ni Jesús anchoqol Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ancha Jerusalén ixlhiꞌukstsꞌuniy laka puerta yu lhimapaqaꞌukan Borregos, ancha ixꞌalin taun ay japuꞌan yu junkan Betesda laka lhihebreo. Ixlhitꞌajun laqakis xacorredor. ");
INSERT INTO tptNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ancha ixtamanal lhuu taqanꞌanin. Ixtaꞌalinta laꞌachꞌixin, vachu ixtaꞌalin yu lakchꞌanlkꞌavil ali yu jantu lay ixtapiklay xantaꞌan ixlakatunajkꞌan. Yuꞌuncha ixtapakxanꞌita kalaklal ni xkan. ");
INSERT INTO tptNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aqtamixna ixtaꞌeltajuy ixmayul ni Dios ni laqapuꞌan ex yucha ixlaqxaꞌamuy ni xkan. Ex chuncha tejkan ixlaqxaꞌamuꞌojoy ni xkan ex taꞌayu yu pꞌunaj ixtataꞌanuy, niman palay ixjunchoqoy mas va tuꞌuchuncha taqanꞌati yu kalhitsukul. ");
INSERT INTO tptNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Vachu ancha ixꞌalin qayntaun lapanaki yu ixlhitꞌajuncha ixtaqanꞌati 38 jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ex ni Jesús tejkan laqtsꞌil ni ancha ixmal va makal kuenta ni ayaj maqancha ixtaqanꞌay, va lhisakmil, va junil: —¿Palay unpꞌutꞌunchꞌoꞌoy? ");
INSERT INTO tptNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chuncha ni taqanꞌan va naul: —Jalhachimoꞌonuꞌ, kitꞌin kunan tejkan laklay ni xkan, ni jantu alin matichun kimataꞌanul ni laqapuꞌan. Tejkan kitꞌin ktaꞌanuputun, aqayntaun niman kilhajay. ");
INSERT INTO tptNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ex junil ni Jesús: —Kꞌaꞌostꞌaycha. Kꞌasaktꞌicha ni mimputaman y kꞌapiticha. ");
INSERT INTO tptNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ex chuncha ni anchanu lapanaki va nimancha palay junchoqol, saklhicha ixputaman, aqtaylcha jaltanan. Ni anchanu julchan va xajulchan jastaknati ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ex ni israelitas tajunil ni lapanaki yu palaycha ixjunchoqota: —Chavaycha va xajulchan jastaknati. Ex jantu paxtoqniy kꞌalhipꞌi mimputaman. ");
INSERT INTO tptNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ex ni yucha jalakjunil: —Yu palay kimakachoqol va yucha kijunil: “Kꞌasaktꞌicha ni mimputaman y kapꞌinchꞌoꞌocha.” ");
INSERT INTO tptNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ex talhisakmil: —¿Tasꞌayucha xalhijunan kꞌasaktꞌicha ni mimputaman y kapꞌinchꞌoꞌocha? ");
INSERT INTO tptNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ni lapanaki yu palaycha ixjunchoqota jantu ixkꞌatsay taꞌayucha palay makal. Yu Jesús ixlaqmaqayauchoqotacha ni pumalhuu lapanakni yu ancha ixtayanal. ");
INSERT INTO tptNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ex taval ni Jesús paxtoqlhi ni anuꞌ lapanaki taꞌan ay lakatajtan, va junil: —Chavay palaycha unchꞌoꞌotꞌa ni uxintꞌi. Kitꞌin kunan ni jantucha apalay kꞌamaqtꞌaꞌalhin para jantu tuꞌuchun kapꞌaxtꞌoqtꞌay yu apalay pꞌays maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ex chuncha alcha ni anchanu lapanaki, jalakjunil ni israelitas ni va Jesús yu palay ixmakachoqota. ");
INSERT INTO tptNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Xlhiyucha ni israelitas ixtaxkajiy ni Jesús por ixmakay lajꞌay lhitapatsa xajulchan jastaknati, xlhiyucha ixtamaqniputun. ");
INSERT INTO tptNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ex ni Jesús jalakjunil: —Yu kimPay va si tapatsay ex kitꞌin vachuꞌ ktapatsay. ");
INSERT INTO tptNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Chuncha ni israelitas takꞌatsal ni jantucha vamun xajulchan jastaknati ixtꞌajun tapasaniniꞌ. Vachuꞌ naul ni yucha ixPay va Dios. Chuncha ixmakakan xꞌaman tacha Dios kaval, xlhiyucha apalay ixtamaqniputun. ");
INSERT INTO tptNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ni Jesús jalakjunil: —Kitꞌin klajunau ni kitꞌin yu Sasꞌatꞌa Dios jantu lay kmakay tuꞌuchun keꞌeman. Kitꞌin vachu va chun kmakay tacha klaqtsꞌin makay kimPay. Ex tachun yu makay ni kimPay va yucha kmakay ni kitꞌin yu Sasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yu kimPay yucha kiꞌachaniy y kimasuniy tachun yu makay. Vachuꞌ kimasuniyaꞌ alati axtoqnuꞌ yu apalay lajꞌay yu kꞌalaqtsꞌinapitik, tus vak kakꞌatsꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Chuncha tacha yu jaPay jalakmajkujuchoqoy janinin y jalaqxtaqniy jatsukunti, vachuꞌ kitꞌin yu isTsꞌal kxtaqniy jatsukunti va yu kitꞌin kxtaqniputun. ");
INSERT INTO tptNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yu kimPay jantu matichun mukꞌaniy laqtaqal. Va kixtaqnil kitꞌin yu isTsꞌal kunita tachun tapꞌasta para kakmukꞌal laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ex chuncha tachun kintatoꞌoyayaꞌ kitꞌin yu isTsꞌal vachu chun tacha tatoꞌoyay ni kimPay. Ni lapanakni yu jantu kintatoꞌoyay ni kitꞌin yu isTsꞌal, yuꞌuncha vachu jantu tatoꞌoyay ni kimPay yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Laqsaval klajunau ni uxiknan: Taꞌayu yu qasmatꞌa ni kinchivinti y vachu lhakapuꞌan yu kimalaqachal, yucha lhitꞌajun jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Jantu aqtaun kaxtaqnikanaꞌ maqanlqajnati, ni yucha tapasatacha laka lhinin y lhitꞌajuncha jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Laqsaval klajunau, ni lapanakni yu tacha janinin tajunita por jantu talhakapuꞌan, kaminaꞌ julchan tejkan yuꞌuncha kintaqasmakniyaꞌ kinchivinti kitꞌin yu Sasꞌatꞌa Dios. Anchanu julchan va yu chavaycha lakachin. Yu taqalasmatꞌa, yuꞌuncha katatsukuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yu jatsukunti minchal kun kimPay Dios. Vachu kimaqxtaqnil tapꞌasta ni kitꞌin yu isTsꞌal kunita para lay kakxtaqlhi jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Vachuꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, kimaqxtaqnil lhachimoꞌon para kaklakmukꞌanil ixlaqtaqalkꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jantu vak kakꞌatsꞌantꞌik por tachun yu aniy klajunau. Kaminaꞌ julchan tejkan tachun ni janinin yu taꞌaknunun kintaqasmakniyaꞌ kinchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ex tachun yu tamakal yu lajꞌoxi la ixjatsukuntikꞌan katakujchoqoyaꞌ para katalhitsukul yu ox jatsukunti. Yu tamaqtaqalhinin yuꞌuncha kalaqxtaqnikanaꞌ maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Yu kitꞌin jantu tuꞌuchun lay kmakay kilaqꞌaman, kmukꞌay laqtaqal vamun tacha kilhijuniy kimPay. Xlhiyucha vas kmakay tejkan kmukꞌay laqtaqal, va kmakay tacha najun kimPay yu kimalaqachal aniy. ");
INSERT INTO tptNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Incha vamun kitꞌin kaklhichivinkal kilaqꞌaman ex ka jantu laqsaval kaval kinchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Klajunau ni alin qayntaun yu lay kilhichiviniy ni kitꞌin. Kitꞌin ijkꞌatsay ni va laqsaval yu najun. ");
INSERT INTO tptNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Laqsaval uxiknankꞌan jamalaꞌachꞌanantꞌik para kataꞌal lhisakminin ni Juan taꞌayucha kunita ni kitꞌin. Yucha jaqaltayanal yu laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ni kitꞌin jantu kmaqskꞌiniy ixchivinti qayntaun lapanaki. Va klajunau taꞌayuꞌ kilhichiviniy para lay kꞌalhakꞌapꞌupꞌintꞌik y kꞌalaqtꞌaxtꞌutꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","’Yu Juan ixjunita va tacha laqataun maklku yu ixmaqtajiy y ixmapulkuy. Taun panchꞌix yu uxiknan ixtamaqamayan ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero yu kmakay ni kitꞌin yucha apalay ox masuy taꞌayucha kunita xajantu ixchivinti ni Juan. Ni lhitapatsa yu kixtaqnil kimPay va yucha yu kmakay. Chuncha ox masuy taꞌayucha kunita ni kitꞌin y masuy ni va kimPay kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ni kimPay yu kimalaqachal ni kitꞌin yucha kilhichiviniy, mas jantu aqtaun kꞌaꞌasmaktꞌik ixchivinti y vachu jantu aqtaun kꞌalaqtsꞌintꞌik tacha junita. ");
INSERT INTO tptNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yucha kimalaqachal pero jantu kilalhakapuꞌaniyau kinchivinti. Xlhiyucha uxiknan jantu kalhitsꞌukꞌutꞌik ixchivinti la melhanutkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Uxiknankꞌan laka laksniy lhitꞌamoꞌoyatꞌik ixchivinti Dios taꞌan tsꞌoqkanta, lhilayatꞌik ni va ancha katꞌemayapitik ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Ni anchanu chivinti va yu kilhichiviniy ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero jantu kilalaqꞌuxaminau para kꞌalhitsꞌukꞌutꞌik ni anchanu jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Kitꞌin jantu knajun ni kintatoꞌoyal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ox klamispayau ni uxiknankꞌan jantu laqsaval tꞌoꞌoyayatꞌik Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kitꞌin kmil kun ixpalhachimoꞌon ni kimPay pero uxiknan jantu kilalaqaꞌiyau. Yu va kamil aqayntaun lapanaki yu vamun la ixtapꞌasta ni yucha, ka tus laqa achati kꞌalaꞌaꞌitꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xlhiyucha jantu lay lhakꞌapꞌupꞌinatꞌik. Ayaj tamaqamayan tejkan lajꞌay tamakayan ni lapanakni, jantu lakxkꞌauyatꞌik para lajꞌay katamakan ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kitꞌin jantu kaklaslajau kun kimPay. Yu laqsaval kataslajan va Moisés mas va yucha yu pꞌakxanꞌiyatꞌik para kataꞌaqtayjun. ");
INSERT INTO tptNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Incha laqsaval kꞌalhakꞌapꞌupꞌintꞌik chuncha tacha yu naul ni Moisés ex vachuꞌ ixkilalhakapuꞌau ni kitꞌin. Taꞌan jatsꞌoqnul ni Moisés yucha kilhichiviniy. ");
INSERT INTO tptNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Incha jantu lhakꞌapꞌupꞌinatꞌik ni chivinti yu tsꞌoqlhi ni Moisés ex yu kinchivinti vachu jantu lay lhakꞌapꞌupꞌinatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ex astan ni Jesús va alcha takukchal lakamar Galilea yu vachuꞌ ixjunkan lakamar Tiberias. ");
INSERT INTO tptNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tatꞌaꞌal pumalhuu lapanakni, va talaqtsꞌil ni palay jalakmakal taqanꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Taval ni Jesús taukꞌal laqataun aspajun, ancha jalaktꞌataulal yu ixjalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Va laycha kalakachil ni Paxku yu ay ixkꞌatankꞌan ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tejkan Jesús laqtsꞌil ni qaynlhuu lapanakni ixtatixkaulhaꞌanta, ex lhisakminil, va junkal ni Felipe: —¿Tas ancha kaꞌiyaucha vayti para kalaqchaꞌal tachun yu aniy lapanakni? ");
INSERT INTO tptNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chuncha junkal ni Felipe va para kalaqtsꞌintanukal tisuncha chivinti kaqaltayanal. Ni Jesús yucha ixkꞌatsaycha yu maqskꞌiniy kamakal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Chuncha ni Felipe va junil: —Mas laꞌatꞌuy ciento julchan katsꞌukꞌu tapatsan jantu kalaqchaꞌal para kꞌalakvavatꞌi tachun ni lapanakni mas va laktsꞌuninin pan. ");
INSERT INTO tptNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ex aqayntaun yu ixtꞌaltanaꞌ yu junkan Andrés yu ixlaqaj yu Simón Pedro va naul: ");
INSERT INTO tptNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Aniy alin qayntaun tsꞌal. Yucha lhitꞌajun aqskis pan yu lhiyal cebada, vachu lhitꞌajun aqxtꞌuy jatanti. Pero jantu kalaqchaanaꞌ por tachun yu aniy lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ex chuncha ni Jesús laklhijunil: —Kꞌaꞌunitꞌik katataulal ni lapanakni. Ancha ayaj ixꞌalin lhuu jatsꞌin. Tejkan tataulꞌol va laqchaꞌal tus laqakis mil joꞌakna. ");
INSERT INTO tptNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Chuncha ni Jesús chꞌapal ni pan, aqtayl xtaqniy lhimalaqpuchuncha ni Dios. Ex jalaqxtaqnil ni lapanakni. Vachu chun makal kun yu jatanti. Jalaqxtaqnil tacha yu yuꞌuncha ixtaꞌuputun. ");
INSERT INTO tptNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tejkan oxicha talhiꞌotsaꞌol ex ni Jesús jalaklhijunil ixtꞌaltanan katapusakchoqol tachun yu xajchal para jantu valiꞌiy katalaqamanal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Chuncha tapusaklhi ni yuꞌuncha tachun yu xatalaqcheꞌeniꞌ, tus laqakautꞌuy canasta talaqtsamal vamun por yu anuꞌ aqskis pan yu jalakvaval ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ni lapanakni por talaqtsꞌil yu aniy ay axtoqnu yu makal ni Jesús aqtayl talajuniy siya yuꞌuncha: —Laqsaval ni aniy ka yucha yu laqputeꞌey ixchivinti Dios yu ixtanajun kaminaꞌ aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ni Jesús kꞌatsal ni va kataminaꞌ inin para katalhaꞌal taꞌan katamakayaꞌ ixjalhachimoꞌonukꞌan. Xlhiyucha taꞌeltajuchoqol laka aspajun, va qoslhi para ixlaqꞌaman katiꞌukxuntayal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tejkan putsꞌislhicha ex ixtꞌaltanan ni Jesús yu ixjalakmalaniy tataꞌeltajulcha, va taꞌalcha lakamar. ");
INSERT INTO tptNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ex ancha tataukꞌal laka barco para katapalaqpuslhi ni lakamar para katachaꞌal laka putaulan Capernaúm. Anchanuꞌ hora oxicha tꞌalaj ixputsꞌista, yu Jesús jantukaꞌ ixminchoqoy. ");
INSERT INTO tptNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Chuncha ni lakamar aqtayl laklay kun taun pꞌas un yu ostaulal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tejkan maqaqcha ixtaꞌanta va tachaꞌal laqakis, laqachaxan kilometro ex talaqtsꞌil ni Jesús ixtꞌajun taꞌukstsꞌunin laka barco, ixjaltanajꞌanta la ixꞌukxna lakxkan. Ex ayaj tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ni Jesús jalakjunil: —Va kitꞌin kunita. Jantu katꞌalhanantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Va laqa achati talaqaꞌil laka barco. Ex yu barco nimancha talakanuchal lakatꞌun taꞌan yuꞌuncha ixtachaanputun. ");
INSERT INTO tptNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tejkan atauncha julchan junchoqol, ni lapanakni ixtayanal tus takuktachal lakamar. Tapastakchoqol ni vamun ixꞌalin laqataun barco, va yucha yu tapuꞌal ixtꞌaltanan ni Jesús, pero ni Jesús jantu kalaktꞌaꞌal ni yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero exnicha tachinchal alati barcos yu taminchal laka putaulan Tiberias. Tachinchal ixlhiꞌukstsꞌuniy taꞌan taꞌul yu pan tejkan ni Jesús xtaqnil lhimalaqpuchuncha ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pero tejkan taxtaqnil kuenta ni Jesús jantu an katayal y vachu ixtꞌaltanan jantu sik ixtalay, ex tachun ni lapanakni tataukꞌal ni laka barcos, taꞌal lakxkaunan tus laka putaulan Capernaúm. ");
INSERT INTO tptNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Chuncha tejkan tapalaqpuslhi ni lakamar ancha tatemal ni Jesús, talhisakmil, va tajunil: —Jamalaniniꞌ, ¿tasvanancha chꞌitꞌi aniy? ");
INSERT INTO tptNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ex ni Jesús jalakjunil: —Kitꞌin vas klajunau ni uxiknankꞌan vayntꞌik tus ox otsꞌatꞌik. Va xlhiyucha kilalakxkauyau, mas jantu kꞌamalaꞌasitꞌik yu ay axtoqnuꞌ yu xaklamasuniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jantu kꞌatꞌapꞌatsꞌatꞌik por mivaytkꞌan yu niman miꞌojoy. Tsꞌanqay kꞌatꞌapꞌatsꞌatꞌik por ni vayti yu kataxtaqniyan jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Va yucha yu klaxtaqniyau ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, va kitꞌin kilakꞌulal kimPay Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Chuncha talhisakmil ni Jesús: —¿Ex tisuncha tsꞌanqay kakmakau para kakmakau ni lhitapatsa yu Dios lhinajun? ");
INSERT INTO tptNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ni Jesús jalajqaltaychoqol, va jalakjunil: —Ni lhitapatsa yu lhinajun Dios va inchineꞌ. Yucha kimalaqachal aniy, va talhijunan ni maqskꞌiniy kilalhakapuꞌaniu yu klajunau. ");
INSERT INTO tptNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Chuncha talhisakmil ni Jesús: —¿Suncha kilamasuniyau yu ay kaval para kaklaqtsꞌiu? Ex lay kaklalhakapuꞌaniu minchivinti. ¿Suncha lay makꞌay? ");
INSERT INTO tptNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ni kimpaykꞌan yu maqancha ixtatiꞌukxuntayay lakakꞌivinan yuꞌuncha taꞌul ni vayti yu junkan maná. Chuncha tapasal tacha tsꞌoqkanta taꞌan najun: “Ni yucha jalaqxtaqnil ixvaytkꞌan yu minchal laktꞌiyan.” ");
INSERT INTO tptNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ni Jesús jalakjunil: —Ni kitꞌin klajunau. Ni Moisés jantu kataxtaqnin vayti yu minchal laktꞌiyan. Chavay kimPay taxtaqniyan ni anchanu vayti yu laqsaval yu minachal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ni vayti yu xtaꞌa Dios minachal laktꞌiyan, va yucha jaxtaqniy ixjatsukuntikꞌan ni lapanakni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ex ni lapanakni tajunil: —Jalhachimoꞌonuꞌ, kilaxtaqniꞌalhiu ni anchanuꞌ vayti. ");
INSERT INTO tptNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ex ni Jesús jalakjunil: —Kitꞌin kunita yu vayti yu xtaꞌa jatsukunti. Taꞌayuꞌ yu kilaqmil ni kitꞌin yucha jantucha aqtaun kachavanaꞌ. Vachu yu kilhakapuꞌanil kinchivinti yucha jantucha aqtaun kapukikxixaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Xaklajunaucha ni uxiknankꞌan mas kilalaqtsꞌinaucha jantu lhakꞌapꞌupꞌinatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tachun ni lapanakni yu kimaqxtaqniy kimPay yuꞌuncha kintalaqminaꞌ ni kitꞌin. Tachun yu kintalaqminaꞌ kitꞌin jantu klakmaspꞌitꞌaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ni kitꞌin va kminchal laktꞌiyan para kakmakal yu najun kimPay, jantu yu knajun ni kitꞌin. Va yucha kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yu kimalaqachal va najun ni jantu kakmaqatsꞌanqal mas va qayntaun yu kimaqxtaqnil. Va najun kaklakmajkujuꞌochoqol ni anchanuꞌ julchan tejkan tachun katamaktayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yu kimPay va najun ni katalhitsukul jatsukunti yu jantu aqtaun kamiꞌoyaꞌ tachun ni lapanakni yu kintalaqtsꞌil y kintalhakapuꞌal ni kitꞌin yu isTsꞌal. Ex kitꞌin astan kaklakmajkujuchoqoyaꞌ tejkan tachun katamaktayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tejkan chuncha naul ni Jesús va vayti junita yu minchal laktꞌiyan, ex yu israelitas taꞌaqtayl talhichiviniy ni Jesús, taqaltaꞌestuklhi por chuncha naul. ");
INSERT INTO tptNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Va tanaul: —Ni aniy lapanaki va Jesús yu istsꞌal José. Ni kijnan ox mispayau ixpay ali ixnati. ¡Chavaycha kintajunan ni yucha taꞌeltajuminchal laktꞌiyan! ");
INSERT INTO tptNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ex chuncha ni Jesús jalakjunil: —Jantucha kilaqaltaꞌestukvi. ");
INSERT INTO tptNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jantu matichun lay kilaqmin ni kitꞌin incha kimPay yu kimalaqachal jantu kilhiminil. Ex kitꞌin kakmajkujuchoqoyaꞌ tejkan tachun katamaktayacha. ");
INSERT INTO tptNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yu maqancha ixtalaqputeꞌey ixchivinti Dios va inchine tatsꞌoqꞌulal: “Ni Dios kalakmasuniyaꞌ tachun ni lapanakni.” Tachun yu taqalasmatꞌa ni kimPay y talaniy yu najun, yuꞌuncha kintalaqmin ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Yu kimPay yucha jantu aqtaun kalaqtsꞌinkal pero ni kitꞌin yu kminchal kun Dios va klaqtsꞌil. ");
INSERT INTO tptNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Laqsaval klajunau incha matichun lapanaki ox kilhakapuꞌan ex ni yucha lhitꞌajun jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ni kitꞌin kunita ni vayti yu xtaꞌa jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ni mimpaykꞌan yu maqancha ixtatꞌajun, taꞌul ni vayti yu patajul talman ancha lakakꞌivinan pero ex astan tanil. ");
INSERT INTO tptNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kitꞌin klhichiviniy ni vayti yu minchal laktꞌiyan, matichun lapanaki yu kaꞌul yu aniy vayti, yucha jantu aqtaun kaniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kitꞌin kunita ni vayti yu kujta yu minchal laktꞌiyan. Taꞌayu yu kaꞌuyaꞌ aniy vayti yucha katsukuyaꞌ mas va tavanancha kaval. Ni anchanu vayti yu kitꞌin kxtaꞌa yucha va kilakatunaj yu kmaqxtaꞌa para katalhitsukul jatsukunti tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ex chuncha ni israelitas aqtayl talhilakchiviniy siya yuꞌuncha, ixtanajun: —¿Ex tas laycha kintapuxtaqnin ixlakatunaj para kaꞌuu? ");
INSERT INTO tptNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ex ni Jesús naul: —Kitꞌin vas klajunau ni uxiknankꞌan incha jantu kilaꞌuniyau kilakatunaj ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, vachu incha jantu kilaꞌoqniyau kijakꞌalnan, ex jantu lay kꞌalhitsꞌukꞌuyapitik jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ex chuncha taꞌayuꞌ yu kaꞌuyaꞌ kilakatunaj, vachuꞌ incha kaꞌoqyaꞌ kijakꞌalnan, ex ni yucha lhitꞌajuncha jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Ex astan tejkan kamiꞌoyacha ni lakamunukpaꞌ ex kakmajkujuchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yu kilakatunaj va yucha yu laqsaval lhiꞌuti para kaꞌutꞌi, vachu yu kijakꞌalnan va yu laqsaval xkan para kaꞌoqtꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xlhiyucha ni lapanaki yu uy kilakatunaj y vachuꞌ yu otꞌa kijakꞌalnan, yucha chꞌantaun junita kun kitꞌin y kitꞌin vachuꞌ chꞌantaun kunita kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ni kimPay yu kimalaqachal yucha lhitꞌajun jatsukunti y yu kitꞌin va yucha kputsukuy. Ex chuncha vachuꞌ matichun lapanaki yu kiꞌuyaꞌ ni kitꞌin, yucha vachuꞌ kimputsukuyaꞌ ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kitꞌin klhichiviniy vayti yu minchal laktꞌiyan. Yucha jantu va aqstanchun kaval tacha yu junkan maná yu maqancha taꞌul mepayankꞌan. Yuꞌuncha tejkan taꞌul astan tanil. Pero yu kaꞌuyaꞌ ni aniy vayti yucha katsukuyaꞌ mas va tavanancha kaval. ");
INSERT INTO tptNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ni Jesús va chuncha laqputeꞌel laka putaulan Capernaúm laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tejkan chuncha taqasmaklhi tacha yu jalakmasunil ni Jesús ex lati lapanakni va tanaul: —Tacha najun ni yucha ayaj lhitaꞌay para kꞌalaꞌaꞌitꞌi. ¿Tasꞌayucha lapanaki lay kamakaniyaꞌ kuenta yu najun? ");
INSERT INTO tptNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero ni Jesús niman xtaqnil kuenta ni va ixtatꞌajun pastaknan y ixtatꞌajun jakiltaynan. Ex jalhisakmil, va jalakjunil: —¿Ex jantu katamaqaman yu xaklajunau? ");
INSERT INTO tptNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tas kꞌalhilatꞌikcha ni uxiknan incha kilalaqtsꞌinau ni kitꞌin yu kval Sasꞌatꞌa Lapanaki kakpataxtuchoqol taꞌan pꞌunaj xakvilchal? ");
INSERT INTO tptNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ni Espíritu yucha xtaꞌa jatsukunti, ixtapꞌasta lapanaki jantu tuꞌuchun ixtapal kaval. Tachun kinchivinti yu kitꞌin kiltaxtuy va minachal kun ni Espíritu yu xtaꞌa jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero vananaj alin lati uxiknankꞌan yu jantukaꞌ lhakꞌapꞌupꞌinatꞌik. Ni Jesús yucha ixkꞌatsay mas tejkan aqtaynil ixlhitapatsa tasꞌayuꞌuncha yu jantu katalhakapuꞌanaꞌ. Vachu ox ixkꞌatsay tasꞌayucha yu kamaqxtaꞌaꞌ para kamaqnikal. ");
INSERT INTO tptNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ex jalakjunil: —Jantu matichun lapanaki lay kilaqmin ni kitꞌin incha yu kimPay jantu xtaqniy lakatin. ");
INSERT INTO tptNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tejkan chuncha naunꞌol ex lhuvaj lapanakni yu ixtatꞌaꞌanta tamakauntijlal, jantucha apalay katatijuntayal kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ex chuncha ni Jesús vachuꞌ jalaklhisakmil yu pumakautꞌuy yu ixjalakmalaniy va jalakjunil: —¿Uxiknan vachuꞌ kilamakauntijlayau? ");
INSERT INTO tptNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ex ni Simón Pedro va liman qaltayl, va junil: —Jalhachimoꞌonuꞌ, ¿tasꞌayucha lay kaktꞌaꞌau? Kijnan kꞌatsayau ni laqsaval vamun uxintꞌi kꞌiltꞌaxtꞌuy chivinti yu xtaꞌa jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chavay kijnan klalhakapuꞌantaucha, vachuꞌ ijkꞌatsayau ni uxintꞌi va yu ixnavin Dios kꞌatꞌi, jantu tuꞌuchun laqtaqal kꞌalhitsꞌukꞌu. ");
INSERT INTO tptNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ni Jesús jaqaltaychoqol, va jalakjunil: —Kitꞌin klalaksakvi pumakautꞌuy pero xaqayntaun ni uxiknankꞌan va lhitꞌajun aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Va Judas yu ixtꞌajun lhichivin. Yucha istsꞌal ixjunita qayntaun joꞌati yu junkan Simón Iscariote. Ni Judas va yucha yu kamaqxtaqyaꞌ ni Jesús para kamaqnikal mas yucha va xaqayntaun ixtꞌaltanaꞌ yu ixjamalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ex taval ni Jesús ixtiꞌukxuyal la xalakatꞌun Galilea. Jantu ixtaulputun Judea, ancha ixtatꞌajun lakxkaunan niisraelitas para katamaqnil. ");
INSERT INTO tptNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero ni anchanu julchan va laycha kalakachil ixkꞌatankꞌan ni israelitas tejkan ixtamakay ixmoqltakꞌan ixlhimaqspaꞌ ixchaqakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yu ixtꞌalaqaunin va tajunil: —Apalay ox kaval kꞌapiti Judea. Ex ancha katalaqtsꞌil mintꞌaltanan ni lajꞌay axtoqnuꞌ yu makꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Qayntaun lapanaki tejkan najun kamispakal ex yucha jantu makay axtoqnuꞌ laqatamaqsaq. Ex uxintꞌi incha makꞌay lajꞌay axtoqnuꞌ ex apalay ox kꞌamakꞌatꞌi taꞌan lay katalaqtsꞌin tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ixtꞌalaqaunin ni Jesús yu chuncha tanaul, yuꞌuncha vachuꞌ jantu ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Xlhiyucha ni Jesús jalakjunil: —Kitꞌin jantukaꞌ lakachin julchan para kakmakal yu maqskꞌiniy pero yu uxiknan mas va tisuncha hora kaval lay makꞌayatꞌik yu makꞌapꞌutꞌunatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Aniy lakamunukpaꞌ ni lapanakni jantu lay taxkayyan ni uxiknan pero yu kitꞌin ayaj kintalhixkajiy va por klakjuniy ni yuꞌuncha tamaqtaqalhinin. ");
INSERT INTO tptNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Uxiknankꞌan kapꞌintꞌik laka kꞌatan pero kitꞌin jantukaꞌ. Jantukaꞌ lakachin julchan yu kimpaxtoqniy. ");
INSERT INTO tptNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tejkan chuncha jalakjunil ex yucha tamakaul laka estado Galilea. ");
INSERT INTO tptNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Astan tejkan taꞌalcha ixtꞌalaqaunin ni Jesús laka kꞌatan ex ni yucha vachuꞌ al. Jantu ixtakꞌatsay ni lapanakni, valiꞌiy ixtamaqsaqꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ni israelitas yuꞌuncha ayaj ixtatꞌajun lakxkaunan ni laka kꞌatan. Ixtalalhisakmiy: —¿Toꞌoxtaycha katijuntayal ni anuꞌ lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ni lapanakni va si ixtalhilakchiviniy ni yucha. Va saq ixtalajuniy: “Ni yucha va qayntaun yu ox lapanaki junita.” Yu alati ixtanajun: “Ni yucha va qayntaun yu tꞌajun jalakmakanun lhuu lapanakni.” ");
INSERT INTO tptNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ni lapanakni va si ixtatamaqsaqchiviniy, ixtatalhauniy ixjalhachimoꞌonunkꞌan ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tejkan ixpakltauncha ixꞌanta ni kꞌatan ex ni Jesús tanuchal ni ay lakatajtan. Aqtayl jalakmalaniy ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ni israelitas tus taun talhilal, va ixtalajuniy siya yuꞌuncha: —¿Tas junitacha ni aniy lapanaki? Yucha ayaj lhuu jatalaniti lhitꞌajun mas jantu katamoꞌol. ");
INSERT INTO tptNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chuncha ni Jesús jalajqaltayl, va jalakjunil: —Tachun yu kitꞌin kmasuy jantu vamun kinchivinti kaval. Va yu masuy ni kimPay yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taꞌayu yu makaputun yu Dios lhinajun ex yucha kakꞌatsayaꞌ ni chivinti yu kmasuy incha va kun Dios mintachal u incha va por kitꞌin kilaqꞌaman. ");
INSERT INTO tptNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Qayntaun lapanaki yu ixlaqꞌaman chiviniy va najun katatoꞌoyal ni lapanakni. Pero kitꞌin va knajun katoꞌoyakal ni Dios yu kimalaqachal. Klhichiviniy yu laqsaval, jantu kaklhitsukul talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ni Moisés taxtaqnin ni uxiknan yu ixlhachimoꞌon Dios pero jantu makꞌayatꞌik yu lhinajun ni anchanu lhachimoꞌon. ¿Ex valiꞌiycha kilamaqniputunau? ");
INSERT INTO tptNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ex taqaltayl ni lapanakni, va tajunil: —¿Tasꞌayucha maqniputunan? Ka va lay lhitꞌaꞌun aqmoqxnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ex ni Jesús va jajunil: —Va aqtauncha kmakal yu ay lhitapatsa la xajulchan jastaknati, va xlhiyucha uxiknankꞌan tus tumpaj lhilatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Laqsaval ni Moisés talhijunin kꞌaxvililichꞌukꞌupꞌuxnikꞌantꞌik pero jantu kaminchal kun Moisés. Yu laqsaval minchal va kun yu apalay maqancha kepayankꞌan ixtatꞌajun. Pero uxiknan mas xajulchan jastaknati vachuꞌ xvililichꞌukꞌupꞌuxniyatꞌik mintsꞌalankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ayaj makꞌapꞌutꞌunatꞌik tacha yu lhinajun Moisés xlhiyucha mas xajulchan jastaknati xvililichꞌukꞌupꞌuxniyatꞌik qayntaun jasꞌatꞌa. ¿Ex valiꞌiycha kilalukujlaniyau por kꞌuchꞌul qayntaun lapanaki tejkan xajulchan jastaknati? ");
INSERT INTO tptNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jantu kꞌamukꞌanitꞌik laqtaqal matichun lapanaki vamun por yu laqtsꞌinatꞌik. Incha kꞌamukꞌanitꞌik laqtaqal kaval yu laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lati lapanakni yu ixtavilanal Jerusalén taꞌaqtayl talalhisakmiy, va tanaul: —¿Jantu kaval yu aniy lapanaki yu tatꞌajun lakxkaunan para katamaqnil? ");
INSERT INTO tptNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chavay mas tꞌajun chivin la ixlakaꞌukxpukꞌan ni lapanakni, yu lhachimoꞌonun jantu tuꞌuchun tajuniy. ¿Ex vachu talhakapuꞌan ni yucha va Cristo yu Dios lakꞌulata? ");
INSERT INTO tptNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ni kijnan ox kꞌatsayau taꞌan laqsaval minchal ni yucha. Pero yu Cristo tejkan kaminaꞌ jantu matichun kamispayaꞌ toꞌoxtaycha kaminanta, ex ka jantu yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tejkan qasmaklhi ni Jesús tacha ixtatꞌajun juninin, ex aqtayl jalaqxaqalay pꞌaysni ancha ixpulakna laka ay lakatajtan, va jalakjunil: —Uxiknan ox kilamispayau, ox kꞌatsꞌayatꞌik toꞌoxtaycha kminchal. Pero jantu kilaqꞌaman kakmil. Va kimPay kimalaqachal. Yucha najun yu laqsaval pero yu uxiknan jantu mispꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ni kitꞌin ox kmispay. Kmintachal kun yucha, va yucha yu kimalaqachal kakmil aniy. ");
INSERT INTO tptNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ex astan lati ixtalaqxaqamaputun pero jantu matichun kachꞌapal. Jantukaꞌ ixlakachin julchan yu Dios laksaklhi para katalhimaqchapul. ");
INSERT INTO tptNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Qaynlhuu lapanakni talhakapuꞌal. Vachuꞌ ixtanajun: —¿Tas kunacha tejkan kaminaꞌ ni Cristo? ¿Kamakayaꞌ ni yucha apalay lajꞌay axtoqnu xajantu yu aniy lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ni fariseos takꞌatsal ni lapanakni va chuncha ixtalhilakchiviniy ni Jesús. Chuncha ni yuꞌuncha ali yu xaꞌukxtinin kuras talhijunil yu xapolicias ni ay lakatajtan para kataꞌal laqxaqamanan. ");
INSERT INTO tptNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ex ni Jesús naul: —Kitꞌin jantucha paqlhuu kaktaulaꞌ kun uxiknan. Niman kaklaqꞌanchoqoyaꞌ yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Astan uxiknan kilalakxkauyau pero jantu lay kilatemayau. Jantu lay kapꞌinapitik taꞌan kitꞌin kaktaulanta. ");
INSERT INTO tptNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Chuncha ni israelitas aqtayl talalhisakmiy, va tanaul: —¿Tas ancha kaꞌanacha ni yucha ni jantu lay katemayau? ¿Kalaqꞌanaꞌ taꞌan tavilanal yu jantu israelitas kataval y kalakmalaniyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kintajunan “Kilalakxkauyau pero jantu kilatemayau.” Vachu najun “Jantu lay kapꞌinapitik taꞌan kitꞌin kaktaulanta.” ¿Tis va suncha naunputun? ");
INSERT INTO tptNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Tejkan va paqtauncha para kalal ni kꞌatan, tayal ni Jesús, va pꞌays chivinil, va naul: —Incha matichun oqputun xkan, kilaqmilcha ni kitꞌin ex kaꞌoqlhicha. ");
INSERT INTO tptNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yu kilhakapuꞌan yucha kunaꞌ tacha najun la ixchivinti Dios: “La xalhanuti kaxajtachal xkan yu xtaꞌa jatsukunti.” ");
INSERT INTO tptNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tejkan chuncha naul ni Jesús va ixlhichiviniy ni Espíritu Santo yu katalaqaꞌiyaꞌ ni lapanakni yu katalhakapuꞌanaꞌ ni yucha. Pero ni Jesucristo jantukaꞌ ay ixmakakan xlhiyucha ni Espíritu Santo jantukaꞌ ixmin. ");
INSERT INTO tptNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ixꞌalin lati lapanakni tejkan chuncha taqasmaklhi, va ixtajuniy: —Laqsaval, yucha va yu xalaqputeꞌeniꞌ ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y yu alati ixtajuniy: —Yucha ni Cristo yu lakꞌulata Dios. Pero lati ixtanajun: —Jantu yuꞌ kaval ni Cristo. Ni Cristo jantu kamintachal Galilea. ");
INSERT INTO tptNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","La ixchivinti Dios najun ni Cristo yu kaminaꞌ va ixpapanti David kunaꞌ. Najun kaminaꞌ tsukunuꞌ laka putaulan Belén taꞌan la ixputaulan ixjunita ni David yu maqancha ixlhachimoꞌonun. ");
INSERT INTO tptNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Chuncha ni lapanakni tatapulvaqlhi va por Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lati ixtalhiꞌuxaꞌan laka pachꞌin pero jantu matichun kachꞌapal. ");
INSERT INTO tptNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ex yu xapolicias laka ay lakatajtan taminchoqolcha taꞌan ixtayanal ni fariseos ali ni xaꞌukxtinin kuras. Va talhisakmil: —¿Valiꞌiycha jantu kꞌalhitꞌantꞌik? ");
INSERT INTO tptNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Chuncha ni policias taqaltayanal, va tanaul: —Jantu aqtaun matichun lapanaki chiviniy tacha yu aniy lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ex ni fariseos tanaul: —¿Ex yu uxiknankꞌan vachucha tamakanutan ni yucha? ");
INSERT INTO tptNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Jantu matichun jalhachimoꞌonuꞌ lhakapuꞌan. Vachuꞌ ni kijnan yu fariseos kuntau jantu klhakapuꞌanau. ");
INSERT INTO tptNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Vamun talhakapuꞌan ni valiꞌiy lapanakni yu jantu tamispay ixlhachimoꞌon ni Moisés. Yuꞌuncha kalakmukꞌanikanaꞌ maqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ex ni Nicodemo yu aqtauncha laqkilal ni Jesús lakaputsꞌisni va jalakjunil: ");
INSERT INTO tptNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—La kilhachimoꞌonkꞌan najun ni jantu lay valiꞌiy kꞌamukꞌanin laqtaqal qayntaun lapanaki. Pꞌunaj maqskꞌiniy kaꞌasmaktꞌi yu najun ex kꞌalaqtsꞌintꞌanuyeꞌe incha makal laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ex tanaul ni ixtꞌafariseos: —¿Ex yu uxintꞌi vachu va machaqaꞌ Galilea kꞌatꞌi? Kꞌalanin ixchivinti Dios ex ancha kꞌalaqtsꞌineꞌe ni jantu matichun yu xalaqputeꞌeniꞌ ixchivinti Dios kaminchal Galilea.  ");
INSERT INTO tptNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ex astan tataxtul lakapulakchivin, va taꞌanchoqol por qayntamin la ixchaqakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ex astan ni Jesús alcha lakataun aspajun yu junkan Xaꞌaspajun Olivos. ");
INSERT INTO tptNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tejkan ixtunkuminta ni Jesús al laka ay lakatajtan, ancha tachun ni lapanakni talaqꞌanꞌol. Taulalcha la ixpulakna ni laka ay lakatajtan ex aqtaylcha jalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ex yu fariseos ali ni lapanakni yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas, yuꞌuncha talhiminil qayntaun xanati yu tatemal makanaꞌ laqtaqal, tꞌatamal qayntaun yu jantu ixapay kaval. Tamaqayaul ixtanꞌajna taꞌan ixtayanal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ex tajunil ni Jesús: —Jamalaniniꞌ, ni aniy xanati yucha temakal makanaꞌ laqtaqal kun yu jantu ixapay kaval. ");
INSERT INTO tptNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","La ixlhachimoꞌon ni Moisés ancha lhinajun kalaklakatꞌalmakal xanatin yu chuncha talay. Yu uxintꞌi, ¿tas naꞌuncha? ");
INSERT INTO tptNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chuncha tamakal va para lay katatislajmal ni Jesús. Pero yucha taqayntal, aqtayl jatsꞌoqnun lakatꞌun kun ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Vananaj ixtataylhaanita lhisakminin, ex tayal ni Jesús jalakjunil: —Xaqayntaun uxiknan yu jantu kalhitsukul talaqalhin yucha pꞌunaj katanqalhunil chiyux y katꞌalal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ex aqtaun taqayntachoqol ni Jesús, taylhaꞌal jatsꞌoqnuꞌ lakatꞌun la ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tejkan chuncha taqasmaklhi tacha jalakjunil ni Jesús ex taꞌaqtaylcha taꞌan por qayntamin. Yu tapꞌulꞌal va yu xapaynincha ixtajunita tus taꞌanꞌolcha. Ex ni Jesús laqtsꞌil ni va xꞌamancha tamakaul ni xanati. ");
INSERT INTO tptNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Chuncha tayal, va junil ni xanati: —¿Tas ancha tayanal ni lapanakni? ¿Jantucha matichun kamukꞌanin laqtaqal? ");
INSERT INTO tptNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ex naul ni xanati: —Jantucha matichun. Ex naul ni Jesús: —Kitꞌin vachu jantu kakmukꞌaniyan laqtaqal. Kꞌapiticha. Jantucha kꞌamaqtꞌaꞌalhin. ");
INSERT INTO tptNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Astan ni Jesús aaqtaun jalaqxaqalachoqol ni lapanakni, va jalakjunil: —Kitꞌin va ixmaklkukꞌan ni lapanakni kunita. Ex yu kintꞌaminaꞌ kalhitsukuyaꞌ ni maklku yu kaxtaqniyaꞌ jatsukunti. Ex jantucha aqtaun katijuntayayaꞌ laka putsꞌisni. ");
INSERT INTO tptNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ex tajunil ni fariseos: —Va milaqꞌaman tꞌaunkꞌan lhichivinka. Jantu laqsaval kaval yu naꞌun. ");
INSERT INTO tptNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ni Jesús jaqaltaychoqol, jalakjunil: —Mas va kilaqꞌaman klhichivinkan, pero yucha laqsaval yu knajun. Kitꞌin ox ijkꞌatsay toꞌoxtaycha kmintachal, vachuꞌ toꞌoxtaycha kajkꞌanchoqoyaꞌ. Yu uxiknan jantu kꞌatsꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Uxiknan mukꞌayatꞌik laqtaqal tacha tamukꞌay yu valiꞌiy lapanakni. Ni kitꞌin jantu matichun kmukꞌaniy laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Incha kitꞌin kakmukꞌal laqtaqal yucha kaval yu laqsaval, jantu kilaqꞌaman kakmukꞌal. Ni kimPay yu kimalaqachal, yucha va chꞌantaun kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","La milhachimoꞌonkꞌan ancha najun incha qayntꞌuy talhitaulay tuꞌuchun, y va taun tanajun, ex chun lay kꞌalhakꞌapꞌupꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chuncha kitꞌin va klhitaulay yu knajun y vachuꞌ alin aqayntaun yu lhitaulay kun kitꞌin. Yucha va kimPay yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ex tajunil: —¿Tas ancha vil ni mimpay? Ex ni Jesús jaqaltayanal, jalakjunil: —Uxiknan jantu kilamispayau ni kitꞌin, vachu jantu mispꞌayatꞌik yu kimPay. Incha kilamispau ni kitꞌin ex vachu kꞌamispꞌatꞌik ni kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ni Jesús tejkan chuncha naul va ixtꞌajun masun laka ay lakatajtan taꞌan maqxtaqkan ofrenda. Jantu matichun kalhaꞌal laka pachꞌin, jantukaꞌ ixlakachin ixjulchan tejkan Dios kanaunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ni Jesús jajunchoqol: —Kitꞌin kajkꞌanacha. Yu uxiknan kilalakxkauyau pero kꞌaniyapitik la mintalaqalhinkꞌan. Taꞌan kitꞌin kajkꞌanaꞌ uxiknankꞌan jantu lay kapꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ex ni israelitas talajunil siya yuꞌuncha: —¿Ex va maqniputunkan ixlaqꞌaman? Ka va lay xlhiyucha najun: “Taꞌan kitꞌin kajkꞌanaꞌ uxiknankꞌan jantu lay kapꞌinapitik”. ");
INSERT INTO tptNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ex ni Jesús jalakjunchoqol: —Uxiknan untꞌatꞌik xalapanakni yu aniy lakamunukpaꞌ, pero kitꞌin kminchal laktꞌiyan. Uxiknan va aniy lakamunukpaꞌ aqtꞌaynitꞌik tsukunun, pero kitꞌin jantu aniy kajkꞌaqtaynil. ");
INSERT INTO tptNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Xlhiyucha klajuniu ni uxiknan kꞌaniyapitik la mintalaqalhinkꞌan. Incha jantu kilalhakapuꞌaniyau tejkan klajunau taꞌayucha kunita ex kꞌaniyapitik la mintalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ex tajunil ni Jesús: —¿Tasꞌayucha kꞌatꞌi ni uxintꞌi? Ex ni Jesús jalakjunil: —Kitꞌin kunita vachu chun tacha klajunau. ");
INSERT INTO tptNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ni kitꞌin ayaj lhuu chivinti lay kaklalhichiviniu ni uxiknan vachu pulhuu milaqtaqalkꞌan lay klamukꞌaniyau. Yu kimalaqachal yucha jantu aqtaun jalaklkanan y yu kijunil va yucha klajunchoqoyau. Xlhiyucha yu klajunau kitꞌin, yucha jantu jalaklkanti kaval. ");
INSERT INTO tptNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ni lapanakni jantu katamalaqasil ni va ixPay Dios ixtꞌajun lhichivin ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ex naul ni Jesús: —Tejkan kilamukꞌayau talman ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, exnicha kilamispayau taꞌayucha kunita. Ni kitꞌin jantu aqtaun kmakay tuꞌuchun kilaqꞌaman. Vamun knajun ni chivinti yu kimPay Dios kimasunil. ");
INSERT INTO tptNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni kimPay yu kimalaqachal yucha alinta kun kitꞌin. Kitꞌin si kmakay yu lakanajun ni yucha, xlhiyucha jantu aqtaun kimakajun keꞌeman. ");
INSERT INTO tptNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tejkan ni Jesús chuncha naunꞌol ex ayaj qaynlhuu talhakapuꞌal ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ni Jesús jalakjunil ni israelitas yu talhakapuꞌal: —Incha uxiknan ox katꞌaylhipꞌiniyapitik chuncha tacha chavay xaꞌasmatꞌatꞌik kinchivinti, ex laqsaval kilapanakni kaꞌunapitik, kꞌalaniyapitik yu klamasuniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chuncha kꞌamispꞌayapitik ni chivinti yu laqsaval, ex yucha oxamaktaun katamakayan. ");
INSERT INTO tptNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Chuncha taqaltayl ni yuꞌuncha, tajunil: —Kijnan va lapanakni kuntau yu kminchaꞌau kun Abraham. Oxamaktaun kuntau, jantu aqtaun kaꞌalil kiꞌukxtinkꞌan. ¿Valiꞌiycha naꞌun ni oxamaktaun kajkunau? ");
INSERT INTO tptNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ex ni Jesús jaqaltaychoqol, va jalakjunil: —Vas klajunau ni lapanakni yu tamaqtaqalhinin, yuꞌuncha ixꞌukxtinkꞌan va yu talaqalhin. ");
INSERT INTO tptNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Qayntaun oqxtamati yu ixnavin ixꞌukxtin yucha jantu lay tsukuꞌalhiy la ixchaqaꞌ ixꞌukxtin tacha ixlapanaki kaval. Pero yu sasꞌatꞌan ni ukxtin yuꞌuncha chun lay ancha tataulꞌalhiy mas va tavanancha kaval. ");
INSERT INTO tptNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Chavay incha yu istsꞌal miꞌukxtinkꞌan oxamaktaun katamakan ex laqsaval oxamaktaun kaꞌunapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kitꞌin ox ijkꞌatsay ni va kun Abraham tꞌanchꞌipitik pero jantu laꞌaꞌiyatꞌik kinchivinti, xlhiyucha kilamaqniputunau. ");
INSERT INTO tptNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tachun yu kchiviniy va si yu kimasunil kimPay. Yu uxiknan makꞌayatꞌik va yu tamasunin mimpaykꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ex tanaul ni israelitas: —Kijnan va Abraham yu maqancha kimpaykꞌan junita. Ex ni Jesús jalakjunil: —Incha laqsaval ni Abraham maqancha mimpaykꞌan ixval, ex kꞌatꞌiꞌukxuntꞌayatꞌik tacha ixtiꞌukxuntayay ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero uxiknan mas klajuntaucha ni va Dios yu laqsaval kimasunil, aqtsꞌiyaj kilamaqniputunau. Ni Abraham jantu aqtaun chun kamakal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Uxiknan vananaj chun makꞌayatꞌik tacha yu makay mimpaykꞌan. Ex tanaul ni yuꞌuncha: —Kijnan jantu aqchunan kajkuu, va qayntaun yu kimPaykꞌan yucha va Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ex ni Jesús jalakjunil: —Incha laqsaval ni Dios mimPaykꞌan kaval ex kilaꞌachaniu ni kitꞌin, ni kitꞌin va kun Dios kmintachal. Chavaycha aniy kvil pero jantu kakmil kilaqꞌaman, va Dios kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Valiꞌiycha jantu malaꞌasiyatꞌik yu klajunau? Va jantu tamaqamayan kaꞌasmaktꞌik, va xlhiyucha. ");
INSERT INTO tptNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Yu mimpaykꞌan va aqmoqxnuꞌ junita, va makꞌayatꞌik yu yucha maqamay. Yucha junita jamaqniniꞌ tus tejkan puꞌaqtaynichal lakamunukpaꞌ. Yucha vamun lhipaꞌiniy yu jalaklkanti, jantu lay najun yu laqsaval. Tejkan jalaklkanan yucha va ixkilchuncha. Yucha va jalaklkanaꞌ junita y va yucha xajapay tachun yu jalaklkanti. ");
INSERT INTO tptNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kitꞌin klhichiviniy yu laqsaval, xlhiyucha uxiknan jantu kilalhakapuꞌaniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ni uxiknan jantu matichun lay kalhitaulal ni kitꞌin klhitꞌajun talaqalhin. Chavay incha kitꞌin klhichiviniy yu laqsaval, ¿ex valiꞌiycha jantu kilalhakapuꞌaniyau yu knajun? ");
INSERT INTO tptNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yu laqsaval ixnavin Dios yucha qasmatꞌa ixchivinti Dios. Uxiknan jantu ixnavin Dios kaꞌuntꞌik, xlhiyucha jantu asmakpꞌutꞌunatꞌik ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ex chuncha tajunil ni israelitas: —Kijnan klajuniu ni uxintꞌi va qayntaun machaqa kꞌatꞌi Samaria. Klajuniu ni uxintꞌi va laqtanuyan laqataun aqmoqxnuꞌ y va laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ex naul ni Jesús: —Kitꞌin jantu kaklhitsukul aqmoqxnuꞌ. Kitꞌin yu kmakay va ktoꞌoyay ni kimPay, pero uxiknan jantu kilatoꞌoyayau ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jantu klalhijunau kilatoꞌoyau ni kitꞌin pero alin qayntaun yu lhinajun kaktoꞌoyakal. Yucha va Dios yu lay mukꞌay laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kitꞌin vas klajunau. Matichun lapanaki yu makay kuenta kinchivinti yucha jantu aqtaun kaniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ex tajunil ni israelitas: —Chavay ox ijkꞌatsayau ni uxintꞌi laqsaval lhitꞌaꞌun aqmoqxnuꞌ. Ni Abraham ali yu ixtalaqputeꞌey ixchivinti Dios maqancha yuꞌuncha si tanil. Ex uxintꞌi, ¿valiꞌiycha naꞌuncha ni yu kamakayaꞌ kuenta minchivinti yucha jantu aqtaun kaniyaꞌ? ");
INSERT INTO tptNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Apalaycha ay kꞌatꞌi ni uxintꞌi xajantu yu kimpaykꞌan Abraham yu maqancha nil? Vachu yu maqancha ixtalaqputeꞌey ixchivinti Dios tanitacha. ¿Tasꞌayucha lhilakꞌan ni uxintꞌi? ");
INSERT INTO tptNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ni Jesús jaqaltaychoqol, jalakjunil: —Yu va kitꞌin kilaqꞌaman kaktoꞌoyakal ex jantu tuꞌuchun xtapal kaval kintoꞌoyaka. Pero yu kintoꞌoyay kitꞌin va kimPay. Yucha naunatꞌik va miDioskꞌan junita. ");
INSERT INTO tptNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yucha jantu mispꞌayatꞌik pero kitꞌin ox kmispay. Incha kitꞌin kaklajuniu jantu kmispay ex kakval tacha qayntaun jalaklkanaj lapanaki vachu va chun tacha uxiknan. Pero kitꞌin laqsaval kmispay y kmakay kuenta ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ni mimpaykꞌan Abraham yu maqancha ixtꞌajun ayaj lhiꞌachantajul tejkan kꞌatsal ni kalaqtsꞌinaꞌ ni julchan tejkan kitꞌin kakminaꞌ. Tejkan chuncha laqtsꞌil ayaj lhiꞌachantajul. ");
INSERT INTO tptNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ex tajunil ni israelitas: —Jantukaꞌ malaqchꞌipꞌiniy cincuenta mijachꞌitin. ¿Valiꞌiycha naꞌuncha uxintꞌi mispꞌay ni Abraham? ");
INSERT INTO tptNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ex ni Jesús jalakjunchoqol: —Kitꞌin ktꞌajun mas va tavanancha, mas tejkan jantukaꞌ istsukuy ni Abraham. ");
INSERT INTO tptNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ex nimancha tasaklhi chiyux para katalakatꞌalmal ni Jesús. Pero ni yucha niman tsꞌalaj tamaqsaqlhi. Astan chꞌapal ixlakatin, taxtulcha ni laka ay lakatajtan, va alcha. ");
INSERT INTO tptNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Chuncha taꞌan ixtꞌajun tapasanaꞌ ni Jesús ancha laqtsꞌil qayntaun laꞌachꞌix yu chuncha tsukul. ");
INSERT INTO tptNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ex ixtꞌaltanan yu ixjalakmalaniy talhisakmil, tajunil: —Jamalaniniꞌ, ¿valiꞌiycha tsukulcha laꞌachꞌix ni aniy lapanaki? ¿Va por ixtalaqalhin ixpay ali ixnati o va por ixtalaqalhin ni yucha? ");
INSERT INTO tptNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chuncha ni Jesús jalakjunil: —Jantu por ixtalaqalhinkꞌan ixpay ali ixnati kaval, nisin por ixtalaqalhin ni yucha. Va para lay kamasukal ixlhitapatsa ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tejkan vananaj tunkujunta ex lay tapatsakan pero tejkan putsꞌista jantucha lay. Vachu va chun chavaycha maqskꞌiniy kamakau ixlhitapatsa yu kimalaqachal. Astan kaminaꞌ ni japutsꞌisniꞌ tejkan jantucha matichun lay katapatsayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Chavaycha vananaj ktijuyal aniy lakamunukpaꞌ ex chuncha kalakmapulkulnita xalapanakni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tejkan chuncha naunꞌol ni Jesús, ex aqchujꞌul lakatꞌun. Aqtayl makay pulꞌan kun ixchujꞌuti ex lhilakpuxapal ni laꞌachꞌix. ");
INSERT INTO tptNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ex junil ni laꞌachꞌix: —Chavay kapꞌinchꞌiycha oqxpuchaꞌaꞌ lakxkan yu junkan Siloé (yucha naunputun yu malaqachakanta). Ex ni laꞌachꞌix alcha oqxpuchaꞌaꞌ. Tejkan minchoqolcha va oxicha ixjalakavanan. ");
INSERT INTO tptNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Chuncha ni ixtꞌamachaqan ali tachun yu ixtalaqtsꞌin taꞌan ixtaulay ixpuskꞌin limosna, yuꞌuncha si ixtalalhisakmiy siya yuꞌuncha: —¿Ni aniy lapanaki jantu yuꞌ yu ixtaulay ixpuskꞌin limosna? ");
INSERT INTO tptNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lati ixtanajun: —Va yucha junita. Pero lati ixtanajun: —Tasuy tacha yucha pero jantu yuꞌ kaval. Pero ni laꞌachꞌix yucha ixnajun: —Chun, va kitꞌin kunita. ");
INSERT INTO tptNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ex talhisakmil va tajunil: —¿Ex tas laycha pꞌalakꞌavanan? ");
INSERT INTO tptNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ex ni laꞌachꞌix jaqaltayanal, va jalakjunil: —Qayntaun lapanaki yu junkan Jesús makal pulꞌan y kilhilakpuxapal la kilaqchul, ex astan kijunil: “Kꞌapꞌinchꞌiy laqapuꞌan la xalakxkan Siloé, ancha kꞌaꞌoqxpꞌuchꞌaꞌayeꞌe.” Ex kitꞌin niman kꞌal. Tejkan kꞌoqxpuchaꞌal ex klakavanalcha. ");
INSERT INTO tptNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chuncha aqtaun talhisakmichoqol, va tajunil: —¿Toꞌoxtaycha yal ni anchanu lapanaki? Ex yucha naul: —Jantu ijkꞌatsay toꞌoxtaycha yal. ");
INSERT INTO tptNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ex astan ni lapanaki yu laꞌachꞌix ixjunita, talhaꞌal taꞌan ixtayanal ni fariseos. ");
INSERT INTO tptNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ni anchanu julchan tejkan ni Jesús laꞌoxinil kun pulꞌan ixlaqchul ni laꞌachꞌix va xajulchan jastaknati ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ex ni fariseos talhisakmichoqol tas palakavanalcha. Ex jalakjunil ni laꞌachꞌix: —Ni lapanaki yu kimalakavanil yucha kimukꞌanil pulꞌan la kilaqchul, ex kimalaqachal oqxpuchaꞌaꞌ, ex kꞌaqtayl klakavanan. ");
INSERT INTO tptNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lati ni fariseos tanaul: —Yu malakavanil ni aniy lapanaki yucha jantu kaminchal kun Dios, jantu toꞌoyay xajulchan jastaknati. Chuncha yu alati vachu tanaul: —Pero incha va maqtaqalhini lapanaki junita, ¿ex tas laycha kapumakal lajꞌay axtoqnuꞌ? Chuncha alil laꞌatꞌuy jatapastakꞌati siya yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ex aqtaun talhisakmil ni lapanaki yu laꞌachꞌix ixjunita, va tajunil: —Chavay ni lapanaki yu malakavanin, ¿tas lhilaycha ni uxintꞌi? Ex jaqaltayanal yu laꞌachꞌix ixjunita, va naul: —Kitꞌin knajun ni yucha va qayntaun yu laqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ni anchanu israelitas jantu ixtalhakapuꞌan ni yucha yu laꞌachꞌix ixjunita y chavay laycha lakavanan. Xlhiyucha tajuntaꞌinil ixpay ali ixnati. ");
INSERT INTO tptNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ixtalhisakmin ni yuꞌuncha, va tajunil: —¿Yucha ni aniy ni mintsꞌalkꞌan? Naunatꞌik ni va laꞌachꞌix tsukul. ¿Ex tas pulaycha lakavanan? ");
INSERT INTO tptNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yu ixpay ali ixnati tanaul: —Kijnan ox ijkꞌatsayau ni va yucha ni kintsꞌalkꞌan y yucha va laꞌachꞌix tsukul. ");
INSERT INTO tptNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero jantu kꞌatsayau tas laycha palakavanal. Vachu jantu kꞌatsayau taꞌayucha laꞌoxinil ixlaqchul. Lay kꞌalhisakmitꞌik ni yucha. Yucha jantucha sꞌatꞌa kaval. Yucha lay katajunan tas laycha palakavanal. ");
INSERT INTO tptNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yuꞌuncha ixtatalhanan, xlhiyucha chuncha tanaul. Ni xalajꞌaynin israelitas chꞌantauncha ixtamakata ixjatapastakꞌatkꞌan. Ixtanajun incha matichun kalhakapuꞌal ni Jesús va yu Cristo junita, yucha katatinaqxtul laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xlhiyucha tanaul ni ixpay ali ixnati: Jantucha sꞌatꞌa kaval y lay kꞌalhisakmitꞌik ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ni israelitas aqtaun tajuntaꞌichoqol ni lapanaki yu laꞌachꞌix ixjunita, va tajunil: —La ixlakaꞌukxpuꞌ ni Dios kilalhitaulniu yu laqsaval. Kijnan ox kmispayau ni anchanu lapanaki yu palay makan, yucha ayaj maqtaqalhini lapanaki junita. ");
INSERT INTO tptNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ex jaqaltayl ni lapanaki yu laꞌachꞌix ixjunita, va jalakjunil: —Kitꞌin jantu ijkꞌatsay incha va maqtaqalhini lapanaki junita. Vamun ijkꞌatsay ni kitꞌin va laꞌachꞌix xajkunita y chavay laycha klakavanan. ");
INSERT INTO tptNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chuncha aaqtaun talhisakmichoqol, va tajunil: —¿Tas makancha? ¿Tas pumalakavanincha? ");
INSERT INTO tptNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ex naul ni laꞌachꞌix: —Kitꞌin klajuntaucha pero jantu kilalhakapuꞌaniu kinchivinti. ¿Valiꞌiycha naunatꞌik aaqtaun klajunchoqoo? ¿Vachu va tꞌaꞌuxapꞌinatꞌik ni yucha? ");
INSERT INTO tptNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Chuncha ox talaktuꞌul, va tajunil: —Uxintꞌi maqamayan katꞌapiti ni anchanu lapanaki. Kijnan vamun Moisés kintamaqamayan kaktꞌaꞌau. ");
INSERT INTO tptNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ni Moisés yucha ijkꞌatsayau ni laqsaval tꞌachivinil Dios pero ni anchanu lapanaki yucha jantu kꞌatsayau toꞌoxtaycha minchal. ");
INSERT INTO tptNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chuncha ni laꞌachꞌix jaqaltayl, va jalakjunil: —Tus vak ijkꞌatsan. Naunatꞌik ni uxiknankꞌan jantu kꞌatsꞌayatꞌik toꞌoxtaycha minchal, pero ni kitꞌin kimalakavanil. ");
INSERT INTO tptNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Laqsaval ox kꞌatsayau ni Dios yucha jantu qalasmakputun yu maqtaqalhinin. Yucha jaqalasmatꞌa vamun yu tatoꞌoyay y tamakay yu lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jantu aqtaun kꞌatsayau matichun yu lay kakꞌuchꞌul yu laꞌachꞌix katsukul. ");
INSERT INTO tptNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ex chuncha yu anu lapanaki incha jantu kaminchal kun Dios ex jantu lay tuꞌuchun kamakal. ");
INSERT INTO tptNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ex tajunil ni laꞌachꞌix: —Uxintꞌi tsꞌukꞌu kun lhuu talaqalhin, ex chavay ¿va uxintꞌi kilamalaniputunau ni kijnan? Ex chuncha va nimancha tatinaqxtul ni laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas para jantucha katanuchoqol. ");
INSERT INTO tptNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ni Jesús niman kꞌatsal ni lapanaki yu laꞌachꞌix ixjunita ixtatinaqxtutacha laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. Ex tejkan paxtoqlhi va lhisakmil: —¿Uxintꞌi lhakꞌapꞌupꞌin yu val Sasꞌatꞌa Lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ex qaltayl, va junil: —Jalhachimoꞌonuꞌ, kꞌiꞌun tasꞌayucha junita para lay kaklhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ex junil ni Jesús: —Uxintꞌi mispꞌaycha y laqtsꞌintꞌacha. Va kitꞌin kunita yu chavaycha ktꞌaꞌun tꞌachivin uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ex ni laꞌachꞌix va taꞌaqtsoqoqtalcha taꞌan ixyal ni Jesús, va junil: —Ox klhakapuꞌanan ni uxintꞌi, Jalhachimoꞌonu kꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ex naul ni Jesús: —Kitꞌin kchil ni aniy lakamunukpaꞌ va para lay kamukꞌanikal ixlaqtaqalkꞌan yu tapaxtoqniy. Chuncha kmil para kaklaqlaꞌoxinil ixlaqchulkꞌan yu laꞌachꞌixin. Vachu yu ox talakavanan para kataꞌakxajchal tacha laꞌachꞌixin por jantu kintalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lati ni fariseos yu ancha ixtayanal tejkan taqasmaklhi tacha naul ni Jesús ex talhisakmil, tajunil: —¿Ex kijnan vachuꞌ va laꞌachꞌixin kuntau? ");
INSERT INTO tptNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Chuncha jaqaltayl ni Jesús, jalakjunil: —Incha laꞌachꞌixin kaꞌuntꞌik, ex jantu tuꞌuchun laqtaqal kꞌamukꞌanikꞌantꞌik. Pero naunatꞌik ox jalakꞌavananatꞌik. Xlhiyucha mukꞌanikꞌanatꞌik milaqtaqalkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Chuncha ni Jesús jalakjunil: —Laqsaval klajunau incha matichun lapanaki tanuy ixpulakna laka korral pero incha jantu putanuy taꞌan yal xapuerta ex ni yucha va alhavanaꞌ junita, laqatapꞌasta maxtuy yu jantu ixnavin. ");
INSERT INTO tptNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yu putanuy taꞌan yal xapuerta ex ni yucha va yu xalhistaknaꞌ borregos. ");
INSERT INTO tptNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ancha qayntaun malaqltiꞌaniy xapuerta para katanul. Ex laktꞌasaniy la ixtaqaꞌutkꞌan laqatamin ni borregos. Yuꞌuncha niman taqasmatꞌa ixchivinti para kalakmaxtul laka korral. ");
INSERT INTO tptNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tejkan lakmaxtuꞌojoy tachun yu ixnavin ex japꞌulaycha ni yucha. Tachun tatꞌaꞌan, va taqalmispay ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero tejkan jalaktꞌasaniy aqayntaun yu jantu tamispay, ex jantu taqalasmatꞌa, jantu tatꞌaꞌan. Jantu taqalmispay, xlhiyucha va niman talajqosmajꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ni Jesús chuncha jalakjunil ni fariseos pero yuꞌuncha jantu katamalaqasil. ");
INSERT INTO tptNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ex aaqtaun ni Jesús jalakjunil: —Laqsaval klajunau, ni kitꞌin va xapuerta kunita taꞌan lay taputanuy ni borregos. ");
INSERT INTO tptNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tachun yu pꞌunaj takilachil, yuꞌuncha va alhavanan ixtajunita. Ixtaꞌalhaumaxtuputun yu jantu ixnavinkꞌan kaval, pero ni borregos jantu kataqalasmaklhi. ");
INSERT INTO tptNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ni kitꞌin va xapuerta korral kunita. Taꞌayuꞌ yu kaputanuyaꞌ taꞌan yal xapuerta, yucha kalaqtaxtuyaꞌ. Kajunaꞌ tacha laqataun borrego yu lay tanuy y lay taxtuy ni laka korral, lay temay yu kaꞌuputul. ");
INSERT INTO tptNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Yu alhavanaꞌ yucha min vamun para kaꞌalhavanal, vachu para kamaqninil y para kalaktꞌilhininꞌol. Kitꞌin kminta va para laqsaval lay katalhitsukul yu ox jatsukunti y para katalhaval yu achati la ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ni kitꞌin ox xalhistaknaꞌ borregos kunita. Yu ox xalhistaknaꞌ borregos, yucha maqxtaꞌa ixjatsukunti para ox katatsukul. ");
INSERT INTO tptNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero qayntaun oqxtamati yu mapalkan jantu ixnavin kaval ni borregos. Xlhiyucha tejkan min yu maqtaliꞌ, ex yucha niman takyajuy. Ex yu maqtaliꞌ jalakchꞌapayachal ni borregos y valiꞌiy tꞌikl taputaukꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chuncha ni anchanu lapanaki jalakmakauntijlaycha. Yucha jantu makay kuenta ni borregos, vamun yu ixlhilhajati makay kuenta. ");
INSERT INTO tptNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Kitꞌin kunita yu laqsaval ox xalhistaknaꞌ borregos. Ox klakmispay kiborregos, vachu yuꞌuncha ox kintamispay. ");
INSERT INTO tptNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Vachu chun tacha kimPay ox kimispay ni kitꞌin, kitꞌin vachu ox kmispay ni yucha. Kitꞌin kmaqxtaꞌa ketsukunti para ox katatsukul ni kiborregos. ");
INSERT INTO tptNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Vachu klhitꞌajun alati borregos yu jantu xanavin aniy laka korral kataval. Yuꞌuncha vachu maqskꞌiniy kaklaklhimil. Kintatoꞌoyayaꞌ, va oqxlaqtaun kaꞌalinaꞌ laka korral. Va qayntaun xalhistaknaꞌ kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Kitꞌin kmaqxtaꞌa ketsukunti para kaknil ex astan kaklaqaꞌichoqol ketsukunti. Xlhiyucha yu kimPay ayaj kiꞌachaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jantu matichun lay kimaxtuniy ketsukunti. Va kitꞌin kmaqxtaꞌa kilaqꞌaman. Kitꞌin lay kmaqxtaꞌa, vachuꞌ lay kaklaqaꞌichoqoyaꞌ. Va chuncha kilhijunil kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tejkan chuncha taqasmaklhi ni israelitas va nimancha tumpaj taval. ");
INSERT INTO tptNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Lati tanaul: —Ni yucha ka va aqmoqxnuꞌ lhitꞌajun la ixjatsukunti, vachu va lokoj. ¿Valiꞌiycha makꞌayatꞌikcha kuenta yu najun? ");
INSERT INTO tptNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero yu alati tanaul: —Jantu chiviniy tacha kalhitsukul aqmoqxnuꞌ. Laqataun aqmoqxnuꞌ jantu lay kalakmalakavanil yu laꞌachꞌixin. ");
INSERT INTO tptNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ancha Jerusalén lhikꞌasnin ixjunita tejkan yu ancha machaqan va ixtatꞌajun makaninin xakꞌatan yu ay lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ni Jesús va ixtijuyal la ixlhimaqspaꞌ laka ay lakatajtan taꞌan ixjapuchꞌanan Salomón. ");
INSERT INTO tptNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ex ancha tamalaqachoqoxnul ni israelitas va aqtayl talhisakmiy, va tajunil: —¿Tasvanancha kilalhitaulniyau yu laqsaval? Incha va uxintꞌi ni Cristo yu lakꞌulatan ni Dios chavaycha va aqtauncha kilajuniu. ");
INSERT INTO tptNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ex jaqaltayl ni Jesús, jalakjunil: —Kitꞌin klajuniucha pero jantu kilalhakapuꞌaniyau. Tachun lajꞌay axtoqnuꞌ yu kmakay la ixtapꞌasta ni kimPay ancha ox tasuy para lay kilapumispau. ");
INSERT INTO tptNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Uxiknan jantu kiborregos kꞌaꞌuntꞌik xlhiyucha jantu lhakꞌapꞌupꞌinatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yu kiborregos yuꞌuncha kintaqalmispay. Kitꞌin vachuꞌ klakmispay ni yuꞌuncha, va kintatꞌaꞌan ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kitꞌin klaqxtaqniy jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Yuꞌuncha jantu aqtaun kataniyaꞌ, vachu jantu aqtaun matichun kimaxtuniyaꞌ la kimakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Va kimPay yu kimaqxtaqnil, vamun yuꞌ ay junita. Jantu matichun lay maxtuniy la ixmakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yu kimPay Dios ali kitꞌin va taun kuntau. ");
INSERT INTO tptNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ex ni israelitas aaqtaun talakasakchoqol chiyux para katalakatꞌalmal. ");
INSERT INTO tptNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ni Jesús jalakjunil: —Kun ixtapꞌasta kimPay kitꞌin klamasuniu lhuu axtoqnuꞌ yu lajꞌay lhitapatsa. ¿Ex tisuncha yu klamasuniu yu kilalhilakatꞌalmaputunau? ");
INSERT INTO tptNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Chuncha ni israelitas taqaltayl, va tajunil: —Kijnan jantu klalhilakatꞌalmayau por yu lajꞌox lhitapatsa yu makꞌatꞌi. Va klalhilakatꞌalmayau por minchivinti. Chuncha tacha naꞌun ayaj tꞌapꞌasaniy ni Dios. Uxintꞌi valiꞌiy lapanaki kꞌatꞌi pero makꞌakꞌan milaqꞌaman tacha Dios kꞌaꞌuntꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ni Jesús jalakjunil: —La mimpalhachimoꞌonkꞌan ancha tsꞌoqkanta yu najun inchine: “Kitꞌin klajuniu ni uxiknan va dioses untꞌatꞌik.” ");
INSERT INTO tptNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yu tsꞌoqmukꞌakanta la ixchivinti Dios va si laqsaval. Ancha Dios jalakjunil dioses ni anchanu lapanakni yu jalaqmalaqachanil ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios kilaksaklhi para kimalaqachal kakmil aniy lakamunukpaꞌ. ¿Ex valiꞌiycha kilajunaucha ni kitꞌin va ktꞌajun tapasaniniꞌ ni Dios vamun por yu klajunau ni kitꞌin va Sasꞌatꞌa kunita? ");
INSERT INTO tptNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Incha kitꞌin jantu kmakay ixlhitapatsa kimPay ex jantu maqskꞌiniy kilalhakapuꞌaniu yu klajunau. ");
INSERT INTO tptNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero kitꞌin aqtsꞌiyaj va kmakay ixlhitapatsa ni kimPay. Ex mas jantu kilalhakapuꞌaniyau yu klajunau, maqskꞌiniy kilalhakapuꞌaniu tejkan laqtsꞌinatꞌik ni lhitapatsa yu kmakay. Chuncha lay ox kꞌatsꞌayatꞌik ni kimPay va chꞌantaun junita kun kitꞌin y kitꞌin vachuꞌ chꞌantaun kunita kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ex aaqtaun ixtalaqxaqamaputunchoqoy ni Jesús, pero tamaqanqoslhi. ");
INSERT INTO tptNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ex anchoqolcha aaqtaun tus taꞌan takuktachal xalaꞌaxkan Jordán taꞌan Juan pꞌunaj ixmaqchajꞌavanan. Ex ancha taulchalcha. ");
INSERT INTO tptNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ancha qaynlhuvaj lapanakni ixtalaqminta ni Jesús, va tanaul: —Ni Juan yucha jantu kamasul yu lajꞌay axtoqnuꞌ, pero tachun yu naul tejkan lhichivinil ni Jesús va si laqsaval val. ");
INSERT INTO tptNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chuncha qaynlhuu lapanakni talhakapuꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ixꞌalin qayntaun lapanaki yu ixtaqanꞌay yu ixjunkan Lázaro. Va machaqaꞌ Betania ixjunita taꞌan ixputaulankꞌan ixjatꞌalapanakni yu junkan María ali Marta. ");
INSERT INTO tptNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ni anchanuꞌ María vachu va yuꞌ yu lhilakxapanil yu sꞌejenꞌe la ixchꞌajaꞌ ni Jalhachimoꞌonuꞌ Jesús ex malakxixinil kun ixꞌaji. ");
INSERT INTO tptNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Chuncha ixlaꞌatꞌuykꞌan jatꞌalapanakni tamalaqachanil chivinti ni Jesús. Tajunil: —Jalhachimoꞌonuꞌ, chavay ni miꞌamigo taqanꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ni Jesús tejkan qasmaklhi va naul: —Yu aniy taqanꞌati chꞌapata jantu kaꞌaqxajtachal ixlhinin. Va para kamasukal ixꞌayaxtu ni Dios, vachu kiꞌayaxtu ni kitꞌin yu isTsꞌal kunita. ");
INSERT INTO tptNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ni Jesús ayaj ixlakpaxkay ni Marta ali ixtꞌalapanaki ali Lázaro. ");
INSERT INTO tptNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero vananaj taqmaqal paqtꞌuy ancha taꞌan ixvil mas tajunilcha ni Lázaro taqanꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ex astan jalakjunil yu ixjalakmalaniy: —Chavay kaꞌanchoqoocha aaqtaun ni Judea. ");
INSERT INTO tptNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ex yu ixjalakmalaniy tajunil: —Jamalaniniꞌ, jantukaꞌ paqlhuu jun yu machaqan Judea ixtalakatꞌalmaputunan para katamaqnin. ¿Ex aaqtauncha uxapꞌinchꞌoꞌoy? ");
INSERT INTO tptNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ex jalakjunil ni Jesús: —Taun julchan lhitꞌajun laqakautꞌuy hora. Yu tijuyal tunkuj yucha jantu aystukkan, va lakavanan taꞌan alin xamaklku lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero yu tijuyal lakaputsꞌisniꞌ yucha aystukkan, va tsꞌanqaniy maklku. ");
INSERT INTO tptNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ex astan naul: —Ni kiꞌamigojkꞌan Lázaro chavaycha ltatay pero kteꞌen maqloꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yu ixjalakmalaniy tajunil: —Jalhachimoꞌonuꞌ, incha valiꞌiy ltatay, ex chun palay kajunchoqoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tejkan naul ni va ltatay yucha naunputun ni Lázaro ixnitacha. Ixtꞌaltanan yu ixjalakmalaniy, yuꞌuncha talhilal valiꞌiy ltatati ixlhichiviniy. ");
INSERT INTO tptNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ex ni Jesús va aaqtauncha vas jalakjunil para katamalaqasil: —Ni Lázaro yucha nitacha. ");
INSERT INTO tptNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Chavaycha kitꞌin ayaj klhiꞌachantajuy ni jantu an xakvilchal. Apalay ox kaxajtachal para uxiknan para apalay kilalhakapuꞌanau. Kaꞌau laqtsꞌinin. ");
INSERT INTO tptNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ex ni Tomás yu ixtalhimapaqaꞌuy Jachiyan va jalakjunil ni alati ixtꞌaltanan Jesús: —Katꞌaꞌaucha ni Jesús para kanichaꞌau chꞌantaun kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tejkan chaꞌalcha ni Jesús ex kꞌatsal ni va paqtꞌaticha ixꞌaknuy ni Lázaro. ");
INSERT INTO tptNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ancha laka putaulan Betania, va ukstsꞌuniy laka putaulan Jerusalén, jantu kalaqchaꞌal laꞌatꞌutu kilometro. ");
INSERT INTO tptNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lhuvaj israelitas ixtalaqminta ni Marta ali María. Ixtamalakaꞌulaputun para jantu katamaqaninil por nil ni Lázaro yu ixtꞌalapanakkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tejkan Marta kꞌatsal ni valaycha kachaꞌal ni Jesús, ex niman takyauꞌal laqaꞌiniꞌ. Yu María vananaj tamakaul ixpulakna la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni Marta junil ni Jesús: —Jalhachimoꞌonuꞌ, incha aniy ixtꞌaꞌul ex ni kintꞌalapanakkꞌan ka jantu ixnil. ");
INSERT INTO tptNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero kitꞌin ijkꞌatsay ni uxintꞌi, tachun yu chavaycha kꞌaskꞌiniyeꞌe ni Dios, yucha kamaqxtaqniyan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ex ni Jesús qaltayl va junil: —Yu mimpꞌisaqa yucha kakujchoqoyaꞌ laka janinin. ");
INSERT INTO tptNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ex qaltaychoqol ni Marta, va naul: —Chun, kitꞌin ijkꞌatsay ni kakujchoqoyaꞌ ni kimpꞌisaqa, astan tejkan katakujchoqoyaꞌ ni janinin, tejkan katamaktayacha ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ex ni Jesús junil: —Va kitꞌin klaqmaqloꞌoy ni janinin, vachu kxtaꞌa ni jatsukunti. Ex taꞌayuꞌ yu kilhakapuꞌal ni kitꞌin mas kanil katsukuchoqoyaꞌ aaqtaun. ");
INSERT INTO tptNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tachun yu alin ixjatsukuntikꞌan, incha kintalhakapuꞌan, ex yuꞌuncha jantu aqtaun kataniyaꞌ. ¿Lhakꞌapꞌupꞌin yu aniy? ");
INSERT INTO tptNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ex ni Marta junil: —Chun, Jalhachimoꞌonuꞌ, kitꞌin klhakapuꞌan ni uxintꞌi va yu Cristo kꞌatꞌi yu Sasꞌatꞌa Dios unitꞌa yu ixmaqskꞌiniy kamil aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tejkan chuncha junꞌol va nimancha takyauꞌal juntaꞌin ixtꞌalapanaki María. Ex saq junil: —Ni jamalaniniꞌ aniy yal, va tꞌachivinputunan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tejkan chuncha qasmaklhi ni María va nimancha takyauꞌostaulal, va laqꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ni Jesús jantukaꞌ ixtanuyachal ni laka putaulan, vananaj an ixyal taꞌan Marta paxtoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tejkan takyauꞌostaulal ni María, y niman taxtul la ixchaqaꞌ, ex ni israelitas yu ancha ixtatꞌajun malakaꞌulanan, tatꞌaꞌal, ixtalhilay va al qalhuꞌ laka putaknun. ");
INSERT INTO tptNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tejkan chaꞌal taꞌan ixyal ni Jesús ex ni María niman taꞌaqtsoqoqtanil, va junil: —Jalhachimoꞌonuꞌ, incha va aniy ixtꞌaꞌul ex ni kimpꞌisaqa Lázaro ka jantu ixnil. ");
INSERT INTO tptNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ex ni Jesús va laqtsꞌil ayaj qalhun ni María, vachuꞌ ixtaqalhun ni israelitas yu tatꞌamil, ex tus xkanil ixjalhanuti. ");
INSERT INTO tptNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ex jalhisakmil, va jalakjunil: —¿Tas ancha xamaknuyatꞌikcha? Va tajunil: —Katꞌatꞌi laqtsꞌiniꞌ, Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ex qalhul ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ex ni israelitas tanaul: —Kꞌalaqtsꞌintꞌik. Ni yucha ayaj ixꞌachaniy ni Lázaro. ");
INSERT INTO tptNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Alati vachu tanaul: —Yu aniy yucha lay malakavaniy laꞌachꞌix. Ka lay ixkꞌuchꞌul para jantu ixnil ni Lázaro. ");
INSERT INTO tptNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ni Jesús ixmaqaninijꞌanta ni laka putaknun. Ni putaknun va taun poqapaj talpa ixpumalakchaukanta laqataun ay chiyux. ");
INSERT INTO tptNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Chuncha ni Jesús naul: —Kꞌamaꞌosutꞌikcha ni chiyux. Ex ni Marta yu ixtꞌalapanaki ni lijunto Lázaro niman naul: —Jalhachimoꞌonuꞌ, chavay ka ayaj akamincha, va paqtꞌaticha xajun tejkan nil. ");
INSERT INTO tptNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ni Jesús junil: —Kitꞌin kunin incha kꞌalhakꞌapꞌupꞌineꞌe ex kꞌalaqtsꞌineꞌe ixꞌayaxtu ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ex tamaqosul ni chiyux, ex ni Jesús talaqstꞌal laktꞌiyan, va naul: —KimPay Dios, kitꞌin kxtaqniyan lhimalaqpuchuncha ni uxintꞌi kꞌiꞌalasmatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kitꞌin ijkꞌatsay ni uxintꞌi va si ox kꞌiꞌalasmatꞌa. Va chuncha knajun para kataqasmaklhi tachun ni lapanakni yu aniy tayanal, para katalhakapuꞌal ni uxintꞌi kꞌimalaꞌachꞌatꞌi aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Astan tejkan chuncha naul ex ayaj pꞌays chivinil, va naul: —¡Lázaro, katꞌaxtꞌucha ni anchanu laka putaknun! ");
INSERT INTO tptNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ex ni lijunto Lázaro va tsꞌalaj taxtul ni laka putaknun. Va ox jamaqchꞌinti y jachꞌanchꞌinti ixjunita kun laqchꞌiti. Vachuꞌ ixꞌukxpuꞌ ox jalaqapupaqanti ixjunita. Ex ni Jesús jalakjunil: —Kꞌamaqxꞌoqtꞌik, kachꞌanxꞌoqtꞌik, ex kꞌaxtꞌaqnitꞌik lakatin kaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tejkan chuncha makal ni Jesús ayaj lhuu israelitas yu tatꞌachaꞌal ni María, yuꞌuncha talaqtsꞌil, ex talhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero lati niman taꞌal laqputeꞌeninin ni fariseos yu makal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ex ni fariseos ali yu xaꞌukxtinin kuras, vachu yu xalajꞌaynin jalhachimoꞌonun va chꞌantaun tataqxtoqlhi. Chuncha talajunil siya yuꞌuncha: —¿Chavay tas kalayaucha ni kijnan? Ni anu lapanaki tꞌajun masunuꞌ lhuu axtoqnuꞌ yu lajꞌay yu jantu aqtaun laqtsꞌinkan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Incha kaxtaqniyau lakatin chuncha tacha lay ex tachun ni lapanakni si katalhakapuꞌanaꞌ. Ex yu talhachimoꞌonun yu machaqan Roma kataminaꞌ, katalaqmaqtayaꞌ yu ay kilakatajtankꞌan, vachu katalaktꞌilhiyaꞌ taꞌakapuchun kimputaulankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Exnicha anchanuꞌ jachꞌitin ixꞌalin qayntaun kuraj yu ixjunkan Caifás yucha jalakjunil: —Uxiknan jantu tuꞌuchun kꞌatsꞌayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jantu malaꞌasiyatꞌik. Apalay ox kaxajchal para kijnan incha kanil qayntaun por yu alati lapanakni, para jantu tachun katsꞌanqau. ");
INSERT INTO tptNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ni Caifás jantu xꞌaman chuncha kanaul. Yucha va xaꞌukxtin kura ixjunita ni anchanuꞌ jachꞌitin. Ni Dios va xtaqnil ixchivinti para kanaul ni Jesús va maqskꞌiniy kanil por yu israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Vachu jantu vamun por yuꞌuncha kaniyaꞌ. Vachuꞌ maqskꞌiniy kanil por tachun ni sasꞌatꞌan Dios yu valiꞌiy tꞌikl taputaukꞌata lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Exnicha ni israelitas yu ixtalhachimoꞌonun va chꞌantaun taval para katamaqnil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Xlhiyucha ni Jesús jantucha ixtijuyal taꞌan ixtatijuyanal ni xajalhachimoꞌonun israelitas. Va taxtulcha xalakatꞌun Judea, alcha lakataun putaulan yu junkan Efraín lakakꞌavinan. Ancha tamakaulcha kun ixtꞌaltanan yu ixjalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Va ixtaꞌukstsꞌuniy ni Paxku yu ay ixkꞌatankꞌan ni israelitas. Lhuvaj lapanakni ixtataxtutacha la ixputaulankꞌan. Ixtaꞌantacha laka putaulan Jerusalén. Yuꞌuncha pꞌunaj ixtachaꞌamajꞌan yu jantu ox tacha ixlhinajun la ixlhachimoꞌonkꞌan para lay katatanul ni laka kꞌatan. ");
INSERT INTO tptNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ancha ixtatꞌajun lakxkaunan ni Jesús. Tejkan ixtatanuy ixpulakna ni laka ay lakatajtan, si ixtalalhisakmiy siya yuꞌuncha: —¿Tas lhilayatꞌikcha? ¿Kaminaꞌ u jantu? ");
INSERT INTO tptNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ni fariseos ali yu xaꞌukxtinin kuras ixtachꞌiputun ni Jesús. Incha matichun kakꞌatsal taꞌan kataulal, yuꞌuncha ixtalhinajunta ni kalhitaulal para lay katachꞌil. ");
INSERT INTO tptNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tejkan vananaj istsꞌanqay paqchaxan para kalakachaꞌal ni xakꞌatan Paxku, ex ni Jesús alcha laka putaulan Betania, taꞌan ixvil ni Lázaro yu majkujuchoqol la ixputaknun tejkan ixnitacha. ");
INSERT INTO tptNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ancha tamakal taun lakvayti para ixlhitoꞌoyakan ni Jesús. Ni Marta yucha ixmujuy yu ixtaꞌuy. Yu Lázaro chꞌantaun ixtꞌavil laka mesa ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ex ni María lhimil laꞌatꞌutu ciento gramos yu pꞌays sꞌejenꞌe yu ayaj laqlhuu xtapal ixjunita. Chuncha lhichꞌanxapal ni Jesús. Ex astan malakxixinichoqol kun ixꞌaji. Tus taꞌakchun ixpulakna ni chaqaꞌ la sꞌej ixꞌakamin. ");
INSERT INTO tptNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ex ni Judas Iscariote, istsꞌal Simón yu kamaqxtaqyaꞌ ni Jesús, ancha ixyal chꞌantaun kun yu alati ixtꞌaltanan ni Jesús, va naul: ");
INSERT INTO tptNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Valiꞌiycha jantu kastꞌakal yu sꞌejenꞌe? Yucha lay ixlhistꞌati tacha talhajay pumatꞌutu ciento oqxtamatin por paqtamin. Ex lay ixjalaqxtꞌaqnin kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mas chuncha naul ni Judas yucha jantu laqsaval ixjalakmapayniy ni kilpatanin, va alhavanaꞌ ixjunita. Ni bolsa yu ixtapumujuy tumin yu ixtaxtaꞌa ni lapanakni, va yucha ixlhitꞌajun ex ancha ixꞌalhaumaxtuy. ");
INSERT INTO tptNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ex ni Jesús va junil: —Kꞌamakꞌaucha. Ni yucha aqtsꞌiyaj va ixlhilkamaꞌata para kaklhilakaxapakal tejkan kakniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yu kilpatanin va tacha kaꞌalinacha kun uxiknankꞌan, pero yu kitꞌin jantucha maqan kaklatꞌaꞌalinau. ");
INSERT INTO tptNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pumalhuvaj israelitas takꞌatsal ni Jesús ixvilchal Betania. Ex taꞌal laqtsꞌinin pero vachu taꞌal va para katalaqtsꞌil ni Lázaro yu majkujuchoqol la ixputaknun tejkan ixnitacha. ");
INSERT INTO tptNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ex ni xaꞌukxtinin kuras vachu ixtamaqniputun ni Lázaro. ");
INSERT INTO tptNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Va por majkujuchoqokal ni Lázaro ayaj qaynlhuucha israelitas ixtalhakapuꞌan ni Jesús, ixtatꞌajun tamakauntꞌaꞌanan ni xaꞌukxtinin kuras. ");
INSERT INTO tptNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lhuu lapanakni tachaꞌal ancha Jerusalén taꞌan laka kꞌatan Paxku. Ataun julchan val, takꞌatsal ni ancha ixꞌantacha ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Chuncha talajꞌexꞌil xaxqoy chꞌapꞌa ex taꞌalcha tastukꞌinin, tanaul: —¡Kilamalaqtaxtuyau! ¡Katoꞌoyakal yu minta la ixtaqaꞌuti ni Dios! ¡Yucha va xaJalhachimoꞌonuꞌ Israel! ");
INSERT INTO tptNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ni Jesús temal laqataun burro ex putaukꞌalhaꞌal, chuncha tacha najun taꞌan istsꞌoqkanta la ixchivinti Dios: ");
INSERT INTO tptNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jantu katꞌalhanantꞌik ni uxiknan yu machaqan Jerusalén untꞌatꞌik. Kꞌalaqtsꞌintꞌik ni miJalhachimoꞌonukꞌan, putaukꞌalhiminta laqataun sasꞌatꞌa burra. ");
INSERT INTO tptNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tejkan chuncha val, ixtꞌaltanan ni Jesús yu ixjalakmalaniy jantu katamalaqasil tachun yu ixtꞌajun tapasanaꞌ. Astan tejkan ni Jesús anchoqol laktꞌiyan ex tapastakchoqol yu chuncha istsꞌoqkanta. Ex takꞌatsal va ixlhichiviniy ni Jesús kun tachun yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ni lapanakni yu talaqtsꞌil ni Jesús tejkan tꞌasanil ni Lázaro y majkujuchoqol la ixputaknun, yuꞌuncha ixtalaqputeꞌechoqoy tacha yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Xlhiyucha ni lapanakni niman taꞌal tastukꞌinin. Takꞌatsal ni ixmakata ni anchanuꞌ ay axtoqnuꞌ yu masul ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ni fariseos ixtalajuniy siya yuꞌuncha: —Kꞌalaqtsꞌintꞌik, ni kijnan jantucha tuꞌuchun lay xamakayau. Tachun ni lapanakni tatꞌaꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Lati lapanakni yu ixtaꞌanta ni laka kꞌatan ancha Jerusalén va griegos ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yuꞌuncha talaqꞌal ni Felipe yu machaqaꞌ laka putaulan Betsaida xalakatꞌun Galilea, va tajunil: —Kijnan klaqtsꞌinputunau ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ex ni Felipe niman chuncha al juniniꞌ ni Andrés, ex ixlaꞌatꞌuykꞌan chuncha taꞌal makꞌatsaninin ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ex chuncha ni Jesús jalakjunil: —Chavay lakachilcha hora tejkan ay kakmakakanaꞌ ni kitꞌin yu kval Sasꞌatꞌa Lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kitꞌin vas klajunau ni laqataun xatꞌin trigo incha jantu patajuy lakatꞌun para kataknul ex jantu tuꞌuchun xtaꞌa, va xꞌamancha. Pero incha patajuy y taknuy ex talhavaꞌan, va xtaꞌa lhuu xaꞌunikan. ");
INSERT INTO tptNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Taꞌayuꞌ yu ayaj achaniy ixjatsukunti aniy lakamunukpaꞌ, yucha astan kamaqatsꞌanqayaꞌ. Pero yu maqxtaqtacha ixjatsukunti aniy lakamunukpaꞌ yucha kalhajaꞌiyaꞌ xajatsukunti laktꞌiyan yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Incha matichun kintapatsaniputun ex maqskꞌiniy kintꞌaꞌal. Taꞌan kaktaulaꞌ ni kitꞌin ex yucha vachuꞌ ancha kataulaꞌ. Yu kintapatsaniyaꞌ yucha vachu katoꞌoyakanaꞌ, ni kimPay ay kamakayaꞌ. Ni Jesús taylhaꞌal ixchivinti, va naul: ");
INSERT INTO tptNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Chavaycha aniy hora ayaj kmaqaninin, tus taꞌexpatajuy kelhanuti. ¿Suncha tsꞌanqay kakskꞌinil kimPay? ¿Va kakskꞌinil para kimalaqtaxtul ni aniy maqanlqajnati? Jantu, va para yucha kminta ni aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","KimPay kꞌatꞌi, ay kꞌamakꞌakꞌa para katoꞌoyakal mintaqaꞌuti. Ex niman qasmakkal laqataun chivinti tus laktꞌiyan, va naul: —Chavaycha kitꞌin aycha kmakakanta para kintatoꞌoyal ni lapanakni. Aaqtaun kaklakmasunichoqoyaꞌ kiꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ni lapanakni yu ancha ixtayanal talhilal va jamaxkan makatꞌaul. Alati ixtalhilay va qayntaun ixmayul Dios tꞌachivinil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ex ni Jesús jalakjunil: —Ni aniy chivinti yu xachivinkan jantu va para kitꞌin kaval, va para uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chavaycha lakachincha julchan tejkan kamukꞌakanaꞌ ixlaqtaqalkꞌan xalapanakni lakamunukpaꞌ. Chavay kalaqtinaqxtukanacha yu xajalhachimoꞌonuꞌ ni aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kitꞌin tejkan kakmukꞌakanaꞌ talman aniy lakamunukpaꞌ, kaklaktꞌasaniꞌoyacha tachun ni lapanakni ni kintalaqmil. ");
INSERT INTO tptNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chuncha naul ni Jesús para katamalaqasil tacha kapuniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ni lapanakni taqaltayl, tajunil: —Kijnankꞌan ijqasmatꞌaucha ni Cristo yu kalakꞌulayaꞌ Dios, yucha katsukuꞌalhiyaꞌ. ¿Valiꞌiycha naꞌuncha ni Sasꞌatꞌa Lapanaki kamukꞌakanaꞌ talman? ¿Tasꞌayucha ni anchanuꞌ yu val Sasꞌatꞌa Lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Chuncha ni Jesús jajunil: —Chavaycha vananaj kataulaꞌ kun uxiknan ni maklku yu mapulkuy. Pero jantucha paqlhuu tsꞌanqay para kaꞌal. Chavaycha vananaj alin ni maklku xlhiyucha maqskꞌiniy katꞌiꞌuntꞌayatꞌik. Chuncha jantu vak kakꞌatsꞌanapitik tejkan kaputsꞌisaꞌ. Yu tijuyal lakaputsꞌisni yucha jantu kꞌatsay taꞌan puꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ni kitꞌin yu xamaklku kunita, vananaj klatꞌavilanau. Ex kꞌalhakꞌapꞌupꞌintꞌik ni maklku yu mapulkuy. Chuncha kꞌatsꞌukꞌuyapitik la kimaklku. Tejkan chuncha naunꞌol ni Jesús, va al, va jatamaqsaqnilcha taꞌan ixtayanal. ");
INSERT INTO tptNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ni Jesús mas ixjalakmasunitacha lhuu axtoqnuꞌ yu jantu aqtaun ixtalaqtsꞌin, jantu ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Va maqskꞌiniy chuncha katapasal tacha tsꞌoqlhi ni Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios, yu najun inchineꞌ: Jalhachimoꞌonuꞌ, ¿tasꞌayucha lhakapuꞌalcha yu kijnankꞌan klaqputeꞌeyau? ¿Maticha lay kalaqtsꞌil ixtapꞌasta ni Dios? ");
INSERT INTO tptNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Xlhiyucha jantu lay ixtalhakapuꞌan. Ni Isaías vachu tsꞌoqlhi yu najun inchineꞌ: ");
INSERT INTO tptNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ni Dios jalakmakal laꞌachꞌixin, vachuꞌ pꞌays jalakmakanil ixjalhanutkꞌan para jantu katalakavanal y jantu katamalaqasil la ixjalhanutkꞌan. Vachu jantu taꞌuxamin kun kitꞌin para palay kaklakmakal la ixtaqanꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tejkan chuncha tsꞌoqlhi ni Isaías lhichivinil ni Jesús, va laqtsꞌil ixꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Qaynlhuu lajꞌay lapanakni talhakapuꞌal ni Jesús, pero jantu tsij ixtanajun. Ixtatalhauniy ni fariseos, ixtalhilay ni va lay kalaqtinaqxtukal ni laqa chaqaꞌ taꞌan ixtataqxtoꞌa ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Apalay ixtamaqamay lajꞌay kataval kun ni lapanakni xajantu kun Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ni Jesús pꞌays chivinil, va naul: —Yu kilhakapuꞌan ni kitꞌin vachu lhakapuꞌan yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yu kilaqtsꞌin ni kitꞌin vachuꞌ laqtsꞌin yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kitꞌin kminta tacha taun maklku yu mapulkuy aniy lakamunukpaꞌ para kajkamapulkunil ni lapanakni yu kintalhakapuꞌan. Ex jantucha katatamakaul lakaputsꞌisni. ");
INSERT INTO tptNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Vachu yu qasmatꞌa kinchivinti pero jantu makay kuenta, yucha jantu kitꞌin kmukꞌaniy maqanlqajnati. Kitꞌin jantu kakmil mukꞌaniniꞌ maqanlqajnati ni lapanakni aniy lakamunukpaꞌ. Va kminta para kajkalaqmalaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Vachu yu jantu kilhiꞌajin y jantu laqaꞌiy kinchivinti yucha alincha yu kamukꞌaniyaꞌ ixmaqanlqajnati. Tejkan kamiꞌoyaꞌ ni lakamunukpaꞌ exnicha kamukꞌanikanaꞌ maqanlqajnati por ni chivinti yu kitꞌin knaul. ");
INSERT INTO tptNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Kitꞌin jantu kchiviniy kilaqꞌaman, ni kimPay yu kimalaqachal yucha kilhijunil yu maqskꞌiniy kaknaul, vachuꞌ yu kakmasul. ");
INSERT INTO tptNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kitꞌin ox kꞌatsay tachun yu kilhijuniy kakmakal ni kimPay, yucha va para kaꞌalil jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. Xlhiyucha tachun yu knajun va yu kimPay kilhijuniy. ");
INSERT INTO tptNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Va laycha kachil ni Paxku yu ay ixkꞌatankꞌan ni israelitas. Exnicha ni Jesús ox ixkꞌatsay ni laqchaꞌalcha ixhora para kamakauntijlalcha ni aniy lakamunukpaꞌ. Ixkꞌatsay ni kaꞌanchoqoyacha taꞌan vilchal ixPay. Yucha ayaj ixlakꞌachaniy ixlapanakni yu ixtꞌatiꞌukxuyanal aniy lakamunukpaꞌ, jantu aqtaun kamiꞌol ixjapaxkanti. ");
INSERT INTO tptNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Va laycha kaꞌaqtaynil ni vayti. Exnicha ni xaꞌukxtin aqmoqxnuꞌ ixlhimanunita la ixjatapastakꞌati ni Judas Iscariote yu istsꞌal Simón para kamaqxtaqlhi ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yu Jesús oxicha ixkꞌatsay ni yucha va kun Dios ixmintachal, y kaꞌanchoqoyaꞌ kun yucha. Vachuꞌ ixkꞌatsay ni ixPay maqxtaqniꞌol la ixtamakaꞌ tachun yu alin para kalhichimoꞌol. ");
INSERT INTO tptNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ex ostayal taꞌan ixtatꞌajun vaynin, majꞌal ixlaqchꞌiti yu ixmulata y lhitampachꞌikal aqxtaun toalla. ");
INSERT INTO tptNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ex pulal taun paxutu xkan aqtayl lakchꞌanchaꞌay ni pumakautꞌuy yu ixjalakmalaniy. Ex jalakmachꞌanxixil kun ni toalla yu ixlhitampachꞌikanta. ");
INSERT INTO tptNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tejkan ixchꞌanchaꞌaputun ni Simón Pedro ex yucha niman junil ni Jesús: —¿Valiꞌiycha ni uxintꞌi va kitꞌin kꞌinchꞌanchꞌaꞌayeꞌe? ");
INSERT INTO tptNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ex ni Jesús qaltaychoqol ni Pedro, va junil: —Chavaycha jantu malaꞌasiy yu ktꞌajun makan ni kitꞌin, pero astan ex kꞌamalaꞌasiyeꞌe. ");
INSERT INTO tptNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ex ni Pedro naul: —Kitꞌin jantu aqtaun kakxtaqniyan lakatin kꞌinchꞌanchꞌaꞌatꞌi. Ex ni Jesús aaqtaun qaltaychoqol, va junil: —Incha jantu kakchꞌanchaꞌayan ex jantu lay chꞌantaun kꞌaꞌuneꞌe kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ex chuncha ni Simón Pedro junil: —Jalhachimoꞌonuꞌ, ex jantu vamun kinchꞌajaꞌ kꞌinchꞌaꞌanin. Vachuꞌ kꞌinchꞌaꞌanin kimakaꞌ ali kiꞌaqtsul. ");
INSERT INTO tptNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chuncha ni Jesús aaqtaun qaltaychoqol, va junil: —Taꞌayuꞌ yu ox laqachaꞌata yucha jantu maqskꞌiniy kalaqachaꞌakal taꞌakchun, vamun ixchꞌajaꞌ. Ox junita taꞌakchun la ixlakatunaj. Uxiknan lajꞌoxin untꞌatꞌik mas jantu mintachunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ni Jesús ox ixkꞌatsay xaqayntaun ni yuꞌuncha kamaqxtaꞌaꞌ, xlhiyucha naul ni jantu tachun lajꞌoxin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ni Jesús tejkan jalaqchꞌanchaꞌaꞌolcha ex ulachoqolcha ni ixlaqchꞌiti ex anchoqolcha taul ni laka mesa, chuncha jalakjunil: —¿Malaꞌasiyatꞌik yu xaklamakaniyau? ");
INSERT INTO tptNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Uxiknan kilajunau ni kitꞌin va jamalaniniꞌ kunita, vachuꞌ kilajunau jalhachimoꞌonuꞌ. Laqsaval ixlaqmiti chuncha kilajuniu, va yucha kunita. ");
INSERT INTO tptNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ni kitꞌin kunita miJamalaninikꞌan, vachuꞌ miJalhachimoꞌonukꞌan kunita. Xlhiyucha incha klachꞌanchaꞌau ex ni uxiknan vachuꞌ maqskꞌiniy kꞌalachꞌanchꞌaꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ni kitꞌin klamasuniu va para kilalaqtsꞌixtuu. Ex vachu chun kꞌamakꞌatꞌik tacha kmakal kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ni kitꞌin klajunau yu laqsaval. Qayntaun oqxtamati yucha jantu ay kaval tacha ixꞌukxtin. Vachuꞌ yu jamalaqachanan apalay ay xajantu yu malaqachakan. ");
INSERT INTO tptNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ex chuncha incha malaꞌasiyatꞌik tachun yu aniy, ex katsꞌukꞌuyapitik kun achati tejkan chuncha kꞌamakꞌayapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pero jantu mintachunkꞌan klalhichivinau. Kitꞌin ox klamispayau ni uxiknan yu klalaksaktau. Chuncha tacha tsꞌoqkanta la ixchivinti Dios maqskꞌiniy chuncha katapasal, yu najun inchineꞌ: “Yu kintꞌavajin chꞌantaun kun kitꞌin chavay kimakay ixtꞌalaxkayaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chuncha klajuniu chavaycha mas jantukaꞌ tapasay. Ex tejkan chuncha katapasayaꞌ lay kalhakꞌapꞌupꞌinapitik ni tasꞌayucha kunita ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Laqsaval kitꞌin klajunau, taꞌayuꞌ yu ox kalaqaꞌiyaꞌ yu kmalaqachay ni kitꞌin, yucha vachu kilaqaꞌiy ni kitꞌin. Yu kilaqaꞌiy ni kitꞌin, yucha vachuꞌ laqaꞌiy ni kimPay yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tejkan chuncha naul ni Jesús ayaj pꞌays jamaqaninil la ixjalhanuti. Ex vas laklhitaulnil yu ixpastakꞌa, va naul: —Kitꞌin vas klajunau, xaqayntaun ni uxiknankꞌan chavay kimaqxtaqyacha. ");
INSERT INTO tptNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Chuncha ixtꞌaltanan yu ixjalakmalaniy aqtayl sniy talalaqtsꞌin siya yuꞌuncha, pero jantu ixtakꞌatsay tasꞌayucha yu ixtꞌajun lhichivin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ni Jesús ayaj ixꞌachaniy qayntaun ni yuꞌuncha y yucha ixtꞌajun vayaꞌ taꞌan apeꞌextaun taꞌan ixvil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ex ni Simón Pedro majkunil ni anchanu lapanaki para kalhisakmil ni Jesús tasꞌayucha yu ixtꞌajun lhichivin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ex ni anchanuꞌ lapanaki niman taꞌukstsꞌuninil ni Jesús ex lhisakmil, va junil: —Jalhachimoꞌonuꞌ, ¿tasꞌayucha lhichꞌiviniy ni uxintꞌi? ");
INSERT INTO tptNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ni Jesús qaltayl, va junil: —Kajkꞌavayaꞌ lakatsꞌuniy ni pan. Yu kakxtaqniyaꞌ, va yucha klhichiviniy. Tejkan chuncha aval ni ixpan, va xtaqnil ni Judas Iscariote yu istsꞌal Simón. ");
INSERT INTO tptNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tejkan laqaꞌil ni pan ni Judas, ex ni Satanás nimancha laqtanul. Ex junkal, naul ni Jesús: —Yu kꞌamakꞌayeꞌe, nimancha kꞌamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yu ixtatꞌajun vaynin laka mesa jantu katamalaqasil tacha junil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ni Judas ixpaxtoqniy kamaꞌal ixtuminkꞌan. Ex lati talhilal va iskꞌinikan tumin ni Judas para katalhiꞌil axtoqnuꞌ para yu kꞌatan o para kalaqxtaqnil kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Chuncha tejkan ni Judas laqaꞌil ni pan va nimancha taxtul. Ni anchanuꞌ hora ixputsꞌistacha. ");
INSERT INTO tptNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tejkan taxtul ni Judas ex ni Jesús naul: —Chavaycha katasuyaꞌ kiꞌayaxtu ni kitꞌin yu kval Sasꞌatꞌa Lapanaki, vachuꞌ la ketsukunti katasuyaꞌ ixꞌayaxtu ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","La ketsukunti ni katasuyaꞌ ixꞌayaxtu ni Dios, xlhiyucha yu Dios kamasuyaꞌ kiꞌayaxtu kitꞌin y jantucha kataqmaqayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kesꞌatꞌan, kitꞌin jantucha apalay kaktaqmaqayaꞌ kun uxiknan. Uxiknan kilalakxkauyau pero vachu chun klajunau tacha klakjunil mintꞌaꞌisraelitaskꞌan: uxiknan jantu lay kapꞌinapitik taꞌan kitꞌin kajkꞌanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Chavaycha klalhijunau taun saystꞌi putsuku. Kꞌalapꞌaxkꞌatꞌik vachu chun tacha kitꞌin klapaxkau. ");
INSERT INTO tptNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Incha lapꞌaxkꞌayatꞌik ex tachun ni lapanakni katakꞌatsayaꞌ ni va laqsaval kintꞌaltanan untꞌatꞌik yu klamalaniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ni Simón Pedro lhisakmil ni Jesús, va junil: —Jalhachimoꞌonuꞌ, ¿tas ancha tꞌipꞌincha? Ex ni Jesús qaltayl, va junil: —Taꞌan kitꞌin kteꞌen chavaycha jantu lay kꞌapꞌineꞌe pero astan ex chun lay kapꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ex ni Pedro qaltayl, va junil: —Jalhachimoꞌonuꞌ, ¿valiꞌiycha chavay jantu lay kaktꞌaꞌanan? Kitꞌin kxtaqkan mas tus kakmaqxtaqlhi ketsukunti por uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ex ni Jesús junil ni Pedro: —¿Laqsaval xtꞌaqkꞌan mas tus kꞌamaqxtꞌaqtꞌi metsukunti por kitꞌin? Kitꞌin laqsaval kunan tejkan jantukaꞌ tꞌasay ni puyux uxintꞌi aqtꞌutu kꞌanauneꞌe ni jantu kꞌimispꞌay. ");
INSERT INTO tptNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ni Jesús taylhaꞌal ixchivinti, jalakjunil: —Jantu kꞌamaꞌaninintꞌik ni uxiknan la melhanutkꞌan, kꞌalhakꞌapꞌupꞌintꞌik ni Dios, vachu kilalhakapuꞌau ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Taꞌan vilchal ni kimPay ayaj lhuu jachaqan alin taꞌan lay katꞌaꞌul. Yu va jantu ixꞌalil ex kitꞌin xaklajuniu. Kitꞌin kajkꞌanacha jalaqlaꞌoxin taꞌan lay katꞌaulatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Astan tejkan kaklaꞌoxiꞌoyacha taꞌan katꞌaulapitik ex kakminchoqoyaꞌ, kaklalhaꞌanau para katꞌaulatꞌik chꞌantaun kun kitꞌin taꞌan kaktaulaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Uxiknan mispꞌayatꞌik taꞌan kitꞌin kajkꞌanaꞌ, vachuꞌ mispꞌayatꞌik ni lakatin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Chuncha ni Tomás junil ni Jesús: —Jalhachimoꞌonuꞌ, kijnan jantu ijkꞌatsayau taꞌan uxintꞌi kapꞌineꞌe. ¿Tas lay kakpumispaucha ni lakatin? ");
INSERT INTO tptNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Chuncha ni Jesús qaltaychoqol, va junil: —Va kitꞌin kunita yu ox lakatin, va kitꞌin kmasuy yu laqsaval, va kitꞌin kxtaꞌa yu jatsukunti. Jantu lay kachꞌipꞌi taꞌan vilchal kimPay Dios incha jantu kꞌilaꞌaꞌitꞌi ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Va ixkilamispau taꞌayucha ni kitꞌin ex yu kimPay vachu ixmispꞌatꞌik. Mas chavaycha mispꞌayatꞌikcha, va tꞌaunatꞌikcha laqtsꞌinin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ex ni Felipe junil: —Jalhachimoꞌonuꞌ, kilamasuniu ni kimPay Dioskꞌan, va yucha kalhitaulacha kejalhuntkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ex qaltaychoqol ni Jesús, va junil: —Felipe, maqancha ktijuyal kun uxiknan. ¿Mas chavaycha jantukaꞌ kilamispayau? Taꞌayuꞌ yu kilaqtsꞌin ni kitꞌin, vachu laqtsꞌin kimPay. ¿Valiꞌiycha kꞌilhiꞌuniycha kaklamasuniu ni kimPaykꞌan? ");
INSERT INTO tptNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Jantu lhakꞌapꞌupꞌin ni kitꞌin va chꞌantaun kunita kun kimPay, vachu yucha chꞌantaun junita kun kitꞌin? Tachun yu klajunau jantu klajunau keꞌeman. Ni kimPay yu vil chꞌantaun kun kitꞌin va yucha makay ixlhitapatsa la kijatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kꞌalhakꞌapꞌupꞌintꞌik ni kitꞌin va chꞌantaun kunita kun kimPay, yucha vachuꞌ chꞌantaun junita kun kitꞌin. Incha jantu lhakꞌapꞌupꞌinatꞌik, maqskꞌiniy kꞌamakꞌatꞌik kuenta tachun yu lajꞌay axtoqnuꞌ yu kmakay, ex lay kꞌalhakꞌapꞌupꞌintꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kitꞌin vas klajunau, ni lapanaki yu kilhakapuꞌan, yucha vachu kamakayaꞌ ixlhitapatsa tacha yu kmakay kitꞌin. Chavay kajkꞌanacha taꞌan vilchal kimPay, xlhiyucha yu kilhakapuꞌan kamakayaꞌ apalay lajꞌay axtoqnuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tachun yu kaskꞌinapitik la kintaqaꞌuti, kitꞌin kaklaxtaqniyau. Chuncha lay kakmasul ni kitꞌin tas junitacha ixꞌayaxtu ni kimPay. Ni Jesús vachu naul: ");
INSERT INTO tptNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","—Mas va tuꞌuchuncha kaval yu kilaskꞌiniyau la kintaqaꞌuti, kitꞌin si kakmakayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Incha kilaꞌachaniyau ni kitꞌin, ex kamakꞌatꞌik tacha klhinajun. ");
INSERT INTO tptNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kitꞌin kakskꞌiniyaꞌ ni kimPay Dios para katamalaqachanin aqayntaun yu lay kataꞌaqtayjun, yu lay katalapꞌasnin. Chuncha lay kataulal kun uxiknan mas va tavanancha. ");
INSERT INTO tptNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yucha ni Espíritu Santo yu masuy yu laqsaval. Ni lapanakni yu jantu talhakapuꞌan Dios, yuꞌuncha jantu katalaqaꞌiyaꞌ. Yuꞌuncha jantu talaqtsꞌin, vachu jantu tamispay, pero uxiknan mispꞌayatꞌik. Yucha alinta kun uxiknan y kaꞌalinaꞌ kun uxiknan mas va tavanancha. ");
INSERT INTO tptNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Jantu kaklamakauntijlayau milaqꞌamankꞌan. Kaklalaqminchoqoyau. ");
INSERT INTO tptNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ni lapanakni yu jantu kintalhakapuꞌan, yuꞌuncha jantucha maqan kintalaqtsꞌinaꞌ. Pero uxiknan vananaj kilalaqtsꞌinau. Ktꞌajun ni kitꞌin, xlhiyucha ni uxiknan lay katsꞌukꞌuyapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Anchanuꞌ julchan ex kakꞌatsꞌayapitik ni va chꞌantaun kunita kun kimPay. Kakꞌatsꞌayapitik ni uxiknan chꞌantaun untꞌatꞌik kun kitꞌin y kitꞌin chꞌantaun kunita kun uxiknan. ");
INSERT INTO tptNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Taꞌayu yu mispay kinchivinti y makay yu klhinajun, va yucha laqsaval kiꞌachaniy. Yu kiꞌachaniy ni kitꞌin, yucha kimPay paxkay. Kitꞌin vachu kakpaxkayaꞌ y kaktasuniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Qayntaun yu ixjunkan Judas, yu jantu Judas Iscariote kaval, yucha junil ni Jesús: —Jalhachimoꞌonuꞌ, ¿valiꞌiycha kilatasuniyaucha ni kijnan pero yu lapanakni yu jantu talhakapuꞌanan yuꞌuncha jantu? ");
INSERT INTO tptNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ex ni Jesús qaltaychoqol, va junil: —Matichun lapanaki yu kiꞌachaniy, yucha makay kuenta yu knajun ni kitꞌin. Vachu kimPay kaꞌachaniyaꞌ ni yucha. Ex ni kimPay ali kitꞌin chꞌantaun kakminau taulnin kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yu jantu makay kuenta yu knajun, yucha jantu kiꞌachaniy. Ni chivinti yu klaqputeꞌey yu tꞌaunatꞌik qasmaknan, yucha jantu kinchivinti kaval, va ixchivinti kimPay yu kimalaqachal. ");
INSERT INTO tptNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Chavaycha vananaj kvil kun uxiknan, xlhiyucha klatꞌaunau juninin tachun. ");
INSERT INTO tptNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ni Espíritu Santo katamalakaꞌulayan la memaqanitkꞌan. KimPay katamalaqachaniyan la kintaqaꞌuti. Katamalaniyan tachun y katamapastakniꞌochoqoyan tachun yu aniy xaklajunau. ");
INSERT INTO tptNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Kaklamakaunau oxamaktamin, kaklaxtaqniyau kiꞌachati yu oxamaktamin katamakayan. Jantu va aqstanchun kaval tacha xaꞌachati aniy lakamunukpaꞌ. Jantu kꞌamaꞌaninintꞌik la melhanutkꞌan, jantu katꞌalhanantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Chavay asmaktꞌikcha ni kitꞌin klajuniu chavay kajkꞌanacha ex astan kaklalaqminchoqoyau. Incha laqsaval kilaꞌachaniyau ex uxiknan ox xalhiꞌachꞌantꞌaꞌuyatꞌik tejkan kꞌatsꞌatꞌik ni kitꞌin kteꞌencha taꞌan vilchal kimPay. Yucha apalay ay xajantu kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Chavaycha chuncha klajunau mas jantukaꞌ kꞌan ni laktꞌiyan. Ex tejkan chuncha katapasayaꞌ lay kꞌalhakꞌapꞌupꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Jantucha apalay kaktaqmaqayaꞌ chiviniꞌ kun uxiknan. Chavay mintacha yu jalhachimoꞌonuꞌ aniy lakamunukpaꞌ, mas jantu kalhitsukul tapꞌasta kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Va chuncha maqskꞌiniy katapasal para katakꞌatsal ni lapanakni aniy lakamunukpaꞌ ni laqsaval kꞌachaniy kimPay y vachu kmakay yu kilhijuniy. ’Chavay kꞌaꞌostꞌalatꞌikcha, kaꞌaucha. ");
INSERT INTO tptNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ni Jesús taylhaꞌal ixchivinti, va naul: —Kitꞌin kunita ni xakꞌiu uvas yu lay lhakapuꞌankan. KimPay va tacha qayntaun yu lhistakꞌa ixjatachꞌanati. ");
INSERT INTO tptNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Incha alin maqlakapataun kimaqlaqapꞌu yu jantu xtaꞌa xaꞌunikan ex yucha niman chaqxmajꞌan. Incha ox xtaꞌa xaꞌunikan, ex yucha valiꞌiy lakamajꞌan laqachaqxtuniy yu jantu lajꞌox xalaqapꞌu. Chuncha laꞌoxiy para apalay lhuu kaxtaqlhi xaꞌunikan. ");
INSERT INTO tptNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Uxiknan laꞌoxitꞌatꞌikcha metsukuntikꞌan por ni chivinti yu klamasuniu. ");
INSERT INTO tptNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Katꞌaylhipꞌintꞌik chꞌantaun kun kitꞌin, tacha kitꞌin chꞌantaun kunita kun uxiknan. Yu maqlaqapꞌu jantu lay xtaꞌa xaꞌunikan ixlaqꞌaman, maqskꞌiniy katakilnul laka kꞌiu yu titay lakatꞌun. Vachu chun tapasay kun uxiknan, incha jantu chꞌantaun kaꞌuntꞌik kun kitꞌin ex metsukuntikꞌan jantu lay kaxtaqlhi yu lajꞌoxi. ");
INSERT INTO tptNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Kitꞌin va yu xakꞌiu yu titay lakatꞌun, yu uxiknan yu kilalhakapuꞌanau, va xamaqlaqapꞌu untꞌatꞌik. Incha qayntaun taylhaꞌan chꞌantaun kun kitꞌin y kitꞌin vachuꞌ kun yucha, yucha junita tacha maqlaqapꞌu yu xtaꞌa lhuu xaꞌunikan. Jantu lay makꞌayatꞌik tuꞌuchun incha jantu chꞌantaun kaꞌuntꞌik kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yu jantu chꞌantaun kaval kun kitꞌin, yucha kalaqchaqxmajꞌankanaꞌ, kapuchꞌiyaꞌ vachu chun tacha xamaqlaqapꞌu yu laqchaqxmajꞌankan. Chꞌantaun maqxtoqmakan y laqxavakan laka jikmi. ");
INSERT INTO tptNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Incha tꞌaylhipꞌinatꞌik chꞌantaun kun kitꞌin, vachu incha kinchivinti ox taylhaꞌan kun uxiknankꞌan, ex kꞌaskꞌintꞌik yu skꞌinpꞌutꞌunatꞌik y kꞌaxtꞌaqnikꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Incha uxiknan untꞌatꞌik tacha maqlaqapꞌu yu xtaꞌa lajꞌox xaꞌunikan ex ni kimPay ox toꞌoyakan. Ex uxiknan vachuꞌ lhiꞌakxajyachꞌipitik tacha yu laqsaval kintꞌaltanan untꞌatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kitꞌin ayaj klapaxkayau vachu chun tacha kimPay kimpaxkay. Katꞌaylhipꞌintꞌik kun yu japaxkanti yu kitꞌin klaxtaqniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Incha laqsaval kꞌamakꞌayapitik tacha klhinajun, ex katꞌaylhipꞌinapitik kun yu japaxkanti yu klaxtaqniyau. Vachu va chun kitꞌin kmakay yu lhinajun kimPay y chuncha ktaylhaꞌanta kun yu japaxkanti yu kixtaqniy. ");
INSERT INTO tptNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Kitꞌin chuncha klalhixaqalayau para kaꞌachꞌantꞌik tacha kꞌachan ni kitꞌin y tus kꞌalhitsꞌukꞌuꞌotꞌik tachun ni achati. ");
INSERT INTO tptNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yu klalhijunau kꞌamakꞌatꞌik va yu inchineꞌ: Kꞌalapꞌaxkꞌatꞌik vachu va tacha ni kitꞌin klapaxkayau. ");
INSERT INTO tptNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yu apalay ay japaxkanti yu lay kꞌamakꞌatꞌi va kꞌamaqxtꞌaqtꞌi mijatsukunti por mintꞌaltanan. ");
INSERT INTO tptNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Uxiknan va kintꞌaltanan untꞌatꞌik incha makꞌayatꞌik tacha yu klalhijunau. ");
INSERT INTO tptNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jantucha klajunau kiꞌoqxtamatin. Qayntaun oqxtamati jantu kꞌatsay yu makay ixꞌukxtin. Kitꞌin klajunau va kintꞌaltanan, va klamasuniꞌojoo tachun yu kijunil kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Uxiknan jantu kilalaksakvi kitꞌin, va kitꞌin klalaksakvi ni uxiknan. Klamalaqachayau ni kaꞌuntꞌik tacha maqlaqapꞌu yu xtaꞌa lajꞌox xaꞌunikan yu jantu aqtaun kamiꞌoyaꞌ. Chuncha ni kimPay kataxtaqniyan tachun yu kꞌaskꞌiniyapitik la kintaqaꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Klalhijunau yu inchineꞌ: Kꞌalapꞌaxkꞌatꞌik. Ni Jesús taylhaꞌal ixchivinti, va naul: ");
INSERT INTO tptNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Incha ayaj taxkayyan yu xalapanakni lakamunukpaꞌ, kapꞌastꞌaktꞌik ni va pꞌunaj kintaxkayl ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Incha uxiknan ixꞌuntꞌik chꞌantaun kun xalapanakni lakamunukpaꞌ ex yuꞌuncha ox ixtalaqtsꞌin. Pero jantu chꞌantaun kaꞌuntꞌik kun yuꞌuncha, va kitꞌin klalaksakvi para jantucha kaꞌuntꞌik xalapanakni lakamunukpaꞌ. Xlhiyucha ayaj taxkayyan. ");
INSERT INTO tptNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kapꞌastꞌaktꞌik tacha klajuntaucha: “Jantu matichun oqxtamati ay kaval tacha ixꞌukxtin.” Incha kitꞌin kintaxkaylhitꞌajun, ex ni uxiknan vachu chun kataxkaylhitsukuyan. Yu taqasmatꞌa kinchivinti, yuꞌuncha vachu kataqasmakniyan minchivintikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yu kataxkaylhitsukuyan chuncha katamakayan por kilapanakni untꞌatꞌik. Jantu tamispay yu kimalaqachata. ");
INSERT INTO tptNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Incha jantu xakmil, incha jantu xaklaqlhixaqalal ex yuꞌuncha jantu tuꞌuchun laqtaqal ixtataukꞌanil. Pero chavay yuꞌuncha jantu lay tanajun ni jantu kaꞌalil ixlaqtaqalkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tachun yu kintaxkajiy vachu taxkajiy ni kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jantu tuꞌuchun laqtaqal ixtataukꞌanil incha jantu xaklakmasunil lajꞌay axtoqnuꞌ yu jantu aqtaun laqtsꞌinkan. Pero mas va talaqtsꞌintacha va kintaxkajiy, vachuꞌ taxkajiy ni kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chuncha tapasay para katapasal tacha tsꞌoqkanta la ixchivinti Dios yu najun inchineꞌ: “Kintaxkajiy ni lapanakni mas jantu tuꞌuchun laqtaqal kakmakal.” ");
INSERT INTO tptNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Kaminaꞌ yu kataꞌaqtayjuyan yu kamintachal kun kimPay. Yucha ni Espíritu Santo yu masuy yu laqsaval. Yucha kaklamalaqachaniyau kamintachal kun kimPay ex vas kilhichivinanaꞌ ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ex ni uxiknan vachuꞌ maqskꞌiniy kilalhichiviniu ni kitꞌin. Va uxiknan ukxuyanantꞌikcha kun kitꞌin tus tejkan kꞌaqtaynil jamalaniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Tachun yu aniy klalhixaqalayau para jantu kꞌamakꞌauntꞌijlatꞌik milhakapuꞌatkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Katalaqnaqxtuyan taꞌan tataqxtoꞌa kintꞌaꞌisraelitaskꞌan. Kaminaꞌ julchan tejkan lati katamaqniyan, chuncha katalhilayaꞌ ni va ox tatapatsaniy ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jantu tamispay ni kimPay y jantu kintamispay ni kitꞌin, xlhiyucha chuncha katamakayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Chuncha klajunau, ex tejkan chuncha kꞌatꞌapꞌasayapitik kapꞌastꞌakchꞌoꞌoyapitik ni va pꞌunaj chuncha xaklajuntaucha. ’Jantu chuncha kaklajuniu tejkan pꞌunaj xaklatꞌaꞌukxuyanau. Ni kitꞌin xakvil kun uxiknankꞌan y jantu tuꞌuchun ixtꞌapꞌasayatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Chavay klaqꞌanacha yu kimalaqachal, jantu matichun ni uxiknan kilalhisakmiputunau toꞌoxtaycha kteꞌencha. ");
INSERT INTO tptNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Klajunau ni kteꞌenchoqoycha, xlhiyucha uxiknan va ayaj jamaꞌanininatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kitꞌin laqsaval klajunau, apalay ox kaxajtachal para uxiknankꞌan incha kajkꞌalcha. Incha jantu kajkꞌanaꞌ ex jantu lay katalaqminan ni Espíritu Santo yu kataꞌaqtayjuyan. Incha kajkꞌanaꞌ ex kaklamalaqachaniyau. ");
INSERT INTO tptNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tejkan yucha kaminaꞌ ex kalakmasuniyaꞌ xalapanakni lakamunukpaꞌ ni alin ixtalaqalhinkꞌan, kalakmasuniyaꞌ tacha junita yu vas jatsukunti, vachuꞌ kalakmasuniyaꞌ ni Dios mukꞌay laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kalakmasuniyaꞌ ni alin ixtalaqalhinkꞌan por jantu kintalhakapuꞌal ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kalakmasuniyaꞌ tacha junita yu vas jatsukunti. Yucha klhitꞌajun kitꞌin xlhiyucha kaklaqꞌanaꞌ kimPay y uxiknan jantucha kilalaqtsꞌinau. ");
INSERT INTO tptNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kalakmasuniyaꞌ ni Dios mukꞌay laqtaqal, xlhiyucha ni aqmoqxnuꞌ yu lhachimoꞌonun ni lakamunukpaꞌ yucha mukꞌanikantacha ixmaqanlqajnati. ");
INSERT INTO tptNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ayaj lhuu alin yu klajunputunau pero chavaycha jantukaꞌ lay malaꞌasiyatꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tejkan kaminaꞌ ni Espíritu Santo yu masuy yu laqsaval, exnicha katamasuniyan tachun yu laqsaval. Yucha jantu kachivinanaꞌ ixlaqꞌaman, vamun yu kaqasmaktayaꞌ. Yucha katamasuniyan yu katapasayaꞌ astan. ");
INSERT INTO tptNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yucha kalaqaꞌiyaꞌ yu kakmaqxtaqniyaꞌ ex katamasuniyan ni uxiknankꞌan, chuncha kintoꞌoyayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tachun yu lhitꞌajun ni kimPay va si kinavin junita. Xlhiyucha klajunau ni Espíritu Santo kalaqaꞌiyaꞌ ni chivinti yu kitꞌin kakmaqxtaqniyaꞌ para katamasunin ni uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Jantucha kaktaqmaqayaꞌ, ex ni uxiknan jantucha kilalaqtsꞌinau. Pero astan ex kilalaqtsꞌinchoqoyau, va kajkꞌanaꞌ taꞌan vilchal kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Chuncha ixtꞌaltanan yu jalakmalaniy aqtayl talalhisakmiy siya yuꞌuncha, va tanaul: —¿Tisuncha naunputun yu ixkintajunan? Najun ni jantucha kataqmaqayaꞌ ex jantucha kalaqtsꞌinau. Vachu najun astan kalaqtsꞌinchoqoyau. ¿Suncha naunputun tejkan naul ni kaꞌanacha taꞌan vilchal ixPay? ");
INSERT INTO tptNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ex tataylhaꞌal lalhisakminin: —¿Suncha naunputun tejkan najun jantucha kataqmaqayaꞌ? Tus jantu malaqasiyau. ");
INSERT INTO tptNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ni Jesús xtaqnil kuenta yu ixtalhisakmiputun. Ex lakjunil: —Va klajuniu ni jantucha kaktaqmaqayaꞌ ex jantucha kilalaqtsꞌinau pero astan kilalaqtsꞌinchoqoyau. ¿Va yucha tꞌaunatꞌik lalhisakminin, valiꞌiycha chuncha xaknajun? ");
INSERT INTO tptNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Laqsaval klajunau ni kꞌalajꞌalhunapitik, ayaj kꞌamaꞌaninanapitik. Yu xalapanakni aniy lakamunukpaꞌ, yuꞌuncha ayaj katalhiꞌachantajuyaꞌ. Pero uxiknan mas kꞌamaꞌaninanapitik, astan kaꞌachꞌanapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Tejkan qayntaun xanati kalhitsukuyaꞌ sasꞌatꞌa ex ayaj jamaqaninin, va lakachilcha ixjulchan para kamajkꞌatsal. Pero astan tejkan tsukuycha ni jasꞌatꞌa ex jantucha pastakꞌa ixjamaqanlqajnati. Va lhiꞌachantajuy ni tsukulcha qayntaun jasꞌatꞌa aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Vachu va chun ni uxiknan chavaycha kꞌamaꞌaninanapitik pero astan kaklalaqtsꞌinchoqoyau. Exnicha kꞌalhitsꞌukꞌuyapitik lhuu achati la melhanutkꞌan. Jantu matichun lay katamaxtunichoqoyan ni anuꞌ achati. ");
INSERT INTO tptNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Anchanu julchan ex jantucha tuꞌuchun kilalhisakmiyau. Laqsaval kitꞌin klajunau ni uxiknan tachun yu kꞌaskꞌiniyapitik ni kimPay la kintaqaꞌuti yucha kataxtaqniyan. ");
INSERT INTO tptNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Chavaycha uxiknan jantukaꞌ tuꞌuchun skꞌinatꞌik la kintaqaꞌuti. Kaskꞌintꞌik ex kꞌalaꞌaꞌiyapitik, chuncha kꞌalhitsꞌukꞌuyapitik lhuu achati. ");
INSERT INTO tptNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Chavay klalhixaqalayau tachun yu aniy kun chivinti yu tamapastakniyan pero lhitaꞌay para kamalaꞌasitꞌik. Pero kaminaꞌ julchan tejkan jantucha chuncha kaklalhixaqalayau, va vas kaklajunau tacha junita kimPay. ");
INSERT INTO tptNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Anchanu julchan kꞌaskꞌiniyapitik kimPay la kintaqaꞌuti yu kꞌamaqskꞌiniyapitik. Kitꞌin jantucha maqskꞌiniy kaktapayniniyaꞌ por uxiknankꞌan, ");
INSERT INTO tptNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","va yucha taꞌachaniyan. Uxiknan kilaꞌachaniyau vachu lhakꞌapꞌupꞌintꞌatꞌikcha ni kitꞌin va ancha kmintachal kun Dios, xlhiyucha taꞌachaniyan. ");
INSERT INTO tptNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kminchal taꞌan vilchal ni kimPay tus aniy lakamunukpaꞌ. Pero chavay kakmakaunaꞌ ni aniy lakamunukpaꞌ, kaklaqꞌanchoqoyacha ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ex ixtꞌaltanan yu jalakmalaniy tajunil: —Chavay chun vas kilatꞌaunau xaqalanan, jantucha mapꞌatsꞌay chivinti yu lhitaꞌay ixmalaqasika. ");
INSERT INTO tptNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chavay ijkꞌatsayau ni uxintꞌi mispꞌaꞌoꞌoy tachun, jantucha maqskꞌiniy kꞌalhisakmikꞌa tuꞌuchun. Xlhiyucha klhakapuꞌanau ni laqsaval va kun Dios tꞌantꞌachiy. ");
INSERT INTO tptNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ex ni Jesús va jalakjunil: —¿Ex chavay lhakꞌapꞌupꞌinatꞌikcha? ");
INSERT INTO tptNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Va tsꞌuniycha tsꞌanqay para kachil ni anchanu hora, chavaycha va chilcha tejkan uxiknan valiꞌiy tꞌikl kꞌapꞌutꞌaukꞌayapitik, siya lakatamin kapꞌinapitik. Ex va keꞌemancha kilamakaulayau. Pero jantu keꞌeman kaktaulaꞌ, ni kimPay chꞌantaun vil kun kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chuncha klajunau para lay oxamaktamin katsꞌukꞌutꞌik tejkan chꞌantaun kilatꞌatꞌaunau ni kitꞌin. Ni xalapanakni ni aniy lakamunukpaꞌ va ayaj katamamaqanlqajnivayan. Pero kꞌaꞌayajnantꞌik, ni kitꞌin kmaqalhajatacha ixtapꞌasta ni aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tejkan chuncha naunꞌol ni Jesús ex talaqstꞌal laktꞌiyan, va naul: —Uxintꞌi, kimPay kꞌatꞌi, chavay lakachilcha ni hora. Ay kꞌimakꞌatꞌi ni kitꞌin mesꞌatꞌa para vachuꞌ ay kakmakan ni uxintꞌi. ");
INSERT INTO tptNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Uxintꞌi kꞌilakꞌulatꞌacha para kaklaklhichimoꞌol tachun ni lapanakni. Ex chuncha tachun ni lapanakni yu kꞌimaqxtꞌaqnin kitꞌin lay kaklaqmaqxtaqnil jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Katalhitsukuyaꞌ ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ incha tamispayan ni uxintꞌi vamun yuꞌ yu laqsaval Dios kꞌatꞌi. Vachu tejkan kintamispay ni kitꞌin yu Jesucristo kunita yu kꞌimalaꞌachꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Kitꞌin ay kmakancha ni aniy lakamunukpaꞌ, chavay kmajkaniꞌolcha tachun yu uxintꞌi kꞌilhiꞌun kakmakal. ");
INSERT INTO tptNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chavaycha, kimPay kꞌatꞌi, ay kꞌimakꞌachꞌoꞌo chꞌantaun kun uxintꞌi chuncha tacha pꞌunaj ay xajkunita tejkan jantukaꞌ ixꞌalin ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ni lapanakni yu jalaksakmaxtꞌu ni lakamunukpaꞌ para kꞌimaqxtꞌaqnin kitꞌin, va yuꞌuncha klakmasunitacha tacha unitꞌa ni uxintꞌi. Va minavin ixtajunita pero uxintꞌi kꞌimaqxtꞌaqnin ni kitꞌin. Yuꞌuncha tamakata kuenta ni minchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chavay ox takꞌatsay ni va si kun uxintꞌi minchal tachun yu kꞌimaqxtꞌaqnin. ");
INSERT INTO tptNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kitꞌin ijkalaqputeꞌenilcha ni chivinti yu uxintꞌi kꞌimaqxtꞌaqnin, ex yuꞌuncha talaqaꞌil. Ox takꞌatsay va kun uxintꞌi kmintachal y talhakapuꞌantacha ni va uxintꞌi kꞌimalaꞌachꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Kitꞌin ktapayniniyan por yuꞌuncha. Jantu ktapayniniyan por yu valiꞌiy lapanakni aniy lakamunukpaꞌ. Va ktapayniniyan por yu kꞌimaqxtꞌaqnin, yuꞌuncha va minavin tajunita. ");
INSERT INTO tptNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tachun yu kitꞌin kinavin va si minavin. Vachuꞌ tachun yu minavin va si kinavin ni kitꞌin. La ixjatsukuntikꞌan kilapanakni ox tasuy kiꞌayaxtu. ");
INSERT INTO tptNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Kitꞌin jantucha apalay kaktaulaꞌ aniy lakamunukpaꞌ, va klaqꞌantachaꞌancha. Pero yuꞌuncha vananaj katataylhaanaꞌ aniy. KimPay kꞌatꞌi, vamun uxintꞌi ox unitꞌa, kꞌalaklhistꞌaktꞌi kun la ixtapꞌasta mintaqaꞌuti ni lapanakni yu kꞌimaqxtꞌaqnin. Kalaklhistꞌaktꞌi para chꞌantaun kataval tacha uxintꞌi ali kitꞌin chꞌantaun juntau. ");
INSERT INTO tptNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tejkan kitꞌin chꞌantaun xaklaktꞌavil aniy lakamunukpaꞌ si ox xaklaklhistakꞌa kun ixtapꞌasta ni mintaqaꞌuti yu kꞌimaqxtꞌaqnin. Jantu matichun katsꞌanqal, vamun tsꞌanqal qayntaun yu aqtsꞌiyaj istsꞌanqatacha, va para chuncha katapasal tacha maqancha istsꞌoqkanta. ");
INSERT INTO tptNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chavay kaklaqꞌantachaꞌancha. Pero vananaj kꞌalinta aniy lakamunukpaꞌ, xlhiyucha chuncha knajun tachun yu aniy para katalhitsukuꞌol yu ox achati vachu va chun tacha klhitꞌajun ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kitꞌin klakjunita minchivinti. Ixtꞌalapanaknikꞌan aniy lakamunukpaꞌ taxkajiy ni kilapanakni por jantucha chꞌantaun kataval kun yuꞌuncha. Chuncha tacha kitꞌin jantu xalapanaki aniy lakamunukpaꞌ kakval. ");
INSERT INTO tptNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Kitꞌin jantu kskꞌiniyan para kꞌalakmaxtꞌu aniy lakamunukpaꞌ. Yu kskꞌiniyan va kꞌalaqꞌaqtꞌayꞌutꞌi tejkan ni aqmoqxnuꞌ kalaqmamaqanlqajnivaputul. ");
INSERT INTO tptNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jantucha chꞌantaun kataval kun xalapanakni aniy lakamunukpaꞌ, chuncha tacha kitꞌin jantu xalapanakni lakamunukpaꞌ kakval. ");
INSERT INTO tptNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kꞌalakmasunin minchivinti y chuncha kꞌalakmakꞌanin milapanakni. Minchivinti vamun yuꞌ yu laqsaval. ");
INSERT INTO tptNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chuncha tacha uxintꞌi kꞌimalaꞌachꞌatꞌi aniy lakamunukpaꞌ vachu chun ni kitꞌin klaqmalaqachay para katalhixaqalal minchivinti yu xalapanakni aniy lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Va por yuꞌuncha kmaqxtaqniyan ketsukunti para vachuꞌ minavin kaval ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Kitꞌin jantu ktapayniniyan vamun por kilapanakni. Vachu ktapayniniyan por alati yu kintalhakapuꞌanaꞌ astan tejkan kataqasmakyaꞌ kinchivinti yu katalaqputeꞌeyaꞌ kilapanakni. ");
INSERT INTO tptNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Vachu kskꞌiniyan para chꞌantaun kataval. Vachu chun tacha uxintꞌi ali kitꞌin chꞌantaun juntau. Vachuꞌ chꞌantaun kataval kun kijnan para katalhakapuꞌal yu xalapanakni aniy lakamunukpaꞌ ni va uxintꞌi kꞌimalaꞌachꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Vachu chun tacha uxintꞌi ay kꞌimakꞌatꞌa ni kitꞌin, kitꞌin vachuꞌ lajꞌay klakmakata ni yuꞌuncha. Ex va chꞌantaun katajunaꞌ, vachu chun tacha ni uxintꞌi kun kitꞌin va laqataun juntau. ");
INSERT INTO tptNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kitꞌin chꞌantaun kunita kun yuꞌuncha y uxintꞌi chꞌantaun unitꞌa kun kitꞌin. Va tacha laqataun kataval ni yuꞌuncha. Ex ni xalapanakni aniy lakamunukpaꞌ lay katakꞌatsal ni va uxintꞌi kꞌimalaꞌachꞌatꞌa, vachu katakꞌatsal ni uxintꞌi jalakpꞌaxkꞌay kilapanakni vachu chun tacha kꞌimpꞌaxkꞌay ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’KimPay kꞌatꞌi, uxintꞌi kꞌimaqxtꞌaqnin ni yuꞌuncha. Kitꞌin knajun vachuꞌ ancha katataulal taꞌan kitꞌin kaktaulanta para lay katalaqtsꞌil ni kiꞌayaxtu. Uxintꞌi kꞌimpꞌaxkꞌay, xlhiyucha ay kꞌimakꞌatꞌa tus la maqancha mas tejkan jantukaꞌ ixꞌalin ni lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","KimPay kꞌatꞌi yu vas unitꞌa, ni xalapanakni aniy lakamunukpaꞌ jantu tamispayan. Pero kitꞌin kmispayan y kilapanakni takꞌatsay ni uxintꞌi kꞌimalaꞌachꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kitꞌin klakmasunitacha taꞌayucha ni uxintꞌi, vachuꞌ tas unitꞌacha. Vananaj ktaylhaꞌanta jalakmasuniniꞌ. Knajun katalapaxkal vachu chun tacha uxintꞌi kꞌimpꞌaxkꞌay. Vachu kaktsukuyaꞌ la ixjalhanutkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tejkan chuncha naunꞌol ni Jesús ex tataxtulcha chꞌantaun kun ixtꞌaltanan yu jalakmalaniy para katatakukchalcha yu xalaqxqatij Cedrón. Ancha jalaktꞌatanuchalcha ni Jesús taꞌan ixchꞌankan xakꞌiu olivos. ");
INSERT INTO tptNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ni Judas yu kamaqxtaꞌaꞌ ni Jesús, yucha vachu ox ixjamispanan ni ancha taꞌan ixꞌalin ni olivos. Ni Jesús aqlhuvaj ixtataqxtoqtacha ancha chꞌantaun kun ixtꞌaltanan yu jalakmalaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ex ni Judas jalaktꞌachaꞌal oqxlaqtaun tropas. Vachuꞌ taꞌal yu talhistaknan lakatajtan, va chuncha talhinaul ni xaꞌukxtinin kuras ali yu fariseos. Ixtalhaꞌanta ixpamaqninkꞌan vachuꞌ ixtalhaꞌanta ixqaꞌichikꞌan ali ixmaklkukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ni Jesús ox ixkꞌatsay tachun yu kalhitapasayaꞌ, ex taxtul y jalaklhisakmil: —¿Taꞌayucha lakxkꞌauyatꞌikcha? ");
INSERT INTO tptNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ex taqaltayl, va tajunil: —Kijnan klakxkauyau Jesús yu machaqaꞌ Nazaret. Ex ni Jesús naul: —Va kitꞌin kunita. Ni Judas yu ixmaqxtaꞌa ni Jesús ancha ixjalaktꞌayalcha tachun yu ixjalaklhaꞌanta. ");
INSERT INTO tptNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tejkan Jesús jalakjunil: “Va kitꞌin kunita”, ex niman tatatichoqoꞌal tus tataqtal lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ni Jesús aaqtaun jalaklhisakmichoqol: —¿Tasꞌayucha ni lakxkꞌauyatꞌikcha? Ex yuꞌuncha aaqtaun taqaltayananchoqol: —Kijnan klakxkauyau va Jesús yu machaqaꞌ Nazaret. ");
INSERT INTO tptNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chuncha ni Jesús aaqtaun jalakjunchoqol: —Kitꞌin klajuniucha ni va kitꞌin kunita. Incha laqsaval va kitꞌin kilalakxkauyau ex kꞌalaqxtꞌaqnitꞌik lakatin kataꞌal yu aniy tayanal. ");
INSERT INTO tptNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chuncha naul va para chuncha kaval tacha ixnajuntacha ni Jesús: “KimPay kꞌatꞌi, tachun yu kꞌimaqxtꞌaqnin jantu katsꞌanqal mas va qayntaun.” ");
INSERT INTO tptNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ex ni Simón Pedro maxtul ixꞌespada yu ixlhitꞌajun, niman aqatuchaqxpꞌuxlhi aqxtaun ixꞌaqaxqol taꞌan la ixlhijakanaj qayntaun yu junkan Malko. Yucha va ixꞌoqxtamati ixjunita yu xaꞌay kuraj. ");
INSERT INTO tptNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ex ni Jesús junil ni Pedro: —Kꞌamanuchꞌoꞌocha miꞌespada la xapaꞌinaj. Yu kimPay yucha kixtaqnil para ayaj kakmaqanlqajnal, kitꞌin maqskꞌiniy kaklaqaꞌil. ");
INSERT INTO tptNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ni tropas ali ixꞌukxtinkꞌan, vachuꞌ ni israelitas yu xalhistaknan lakatajtan tachꞌapachal ni Jesús, va tachꞌil. ");
INSERT INTO tptNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pꞌunaj talhaꞌal la ixchaqaꞌ qayntaun jalhachimoꞌonuꞌ yu junkan Anás. Yucha va ixꞌapaꞌ ni Caifás yu ay kuraj ixjunita ni anchanuꞌ jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ni anchanuꞌ Caifás vachu va yuꞌ yu jalakjunil ni israelitas ni apalay ox kaxajchal incha kanil qayntaun lapanaki por tachun yu alati. ");
INSERT INTO tptNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ni Simón Pedro ali aqayntaun ixtꞌaltanaꞌ Jesús, yuꞌuncha astan ixtatꞌaꞌanta ni Jesús. Ni anuꞌ yu tꞌaꞌal ni Pedro yucha ixmispay ni ay kuraj. Yucha vas tanuchal taꞌan lhaꞌankal ni Jesús la ixjapuchꞌanan ixchaqaꞌ ni ay kuraj. ");
INSERT INTO tptNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Yu Pedro tamakaul ixlhimaqspaꞌ laka puerta, ex ni anchanuꞌ yu ixmispay ni ay kuraj taxtul maqspaꞌ. Ex lhijunil ni jatsiꞌi yu xamalaqltiꞌanaꞌ para kamalaqpusul ni Pedro, ex tanulcha. ");
INSERT INTO tptNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Chuncha ni xamalaqltiꞌanaꞌ lhisakmil ni Pedro, va naul: —¿Jantu uxintꞌi kaꞌuntꞌi xaqayntaun ixtꞌaltanaꞌ ni anu lapanaki? Ex qaltayl ni Pedro, va junil: —Jantu kitꞌin kakval. ");
INSERT INTO tptNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Anchanuꞌ julchan ayaj lhikꞌasnin ixjunita. Ni oqxtamatin ali xalhistaknan lakatajtan ixtamamata jikmi, va ixtatꞌajun sꞌonun. Vachuꞌ ancha ixyal ni Pedro, ixlaktꞌatꞌajun sꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ni ay kuraj aqtayl lhisakmiy ni Jesús taꞌayucha ixtꞌaltanan yu jalakmalaniy. Vachu lhisakmil tisuncha chivinti ixmasuy. ");
INSERT INTO tptNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ni Jesús junil: —Kitꞌin kmasuy kinchivinti la ixlakaꞌukxpukꞌan tachun ni lapanakni. Vachuꞌ kmasuy taꞌan tataqxtoꞌa yu alati israelitas y vachuꞌ yu ay lakatajtan. Jantu aqtaun kmasuy laqatamaqsaq. ");
INSERT INTO tptNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Valiꞌiycha kꞌilhisakmiycha ni kitꞌin? Kꞌalhisakmitꞌi yu kintaqalasmaklhi. Yuꞌuncha katanaul yu klaqlhixaqalal, yuꞌuncha takꞌatsay tachun yu knaul ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Tejkan chuncha naul ni Jesús ex qayntaun tropa yu ixjalhistaknan yu ay lakatajtan niman palaqstisal laqataun, va junil: —¿Valiꞌiycha chuncha lhiꞌaltꞌaꞌiy ni ay kuraj? ");
INSERT INTO tptNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ni Jesús junil: —Incha kitꞌin jantu vas kakchivinil ex kꞌiꞌun tisuncha yu jantu vas kaknaul. Pero incha vas kchivinil, ¿ex valiꞌiycha ixkꞌisay? ");
INSERT INTO tptNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ex ni Anás lhinaul kalhaꞌankal tachꞌin taꞌan vil ni Caifás yu xaꞌukxtin kuraj. ");
INSERT INTO tptNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ni Pedro vananaj ixtaylhaꞌanta sꞌon laka jikmi. Lati talhisakmil, tajunil: —¿Jantu uxintꞌi kaꞌuntꞌi xaqayntaun ixtꞌaltanaꞌ ni anchanuꞌ lapanaki? Ni Pedro jantu kalhitaulal, va naul: —Jantu kitꞌin kval. ");
INSERT INTO tptNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Astan chivinil qayntaun ixꞌoqxtamati yu ay kuraj. Yucha ixlaqaj ixjunita yu aqatuchaqxpꞌuxlhi ni Pedro. Yucha vachuꞌ lhisakmil, va junil: —¿Uxintꞌi klaqtsꞌin chꞌantaun kun yucha ancha laka olivos? ");
INSERT INTO tptNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ni Pedro aaqtaun jantu kalhitaulal. Exnicha tꞌasal ni puyux. ");
INSERT INTO tptNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tejkan tamaqaxtulcha la ixchaqaꞌ ni Caifás ex ni lapanakni talhaꞌalcha ni Jesús laqa ay chaqaꞌ taꞌan vil ni gobernador. Va ixtꞌajuncha tunkunuꞌ. Yuꞌuncha jantu katatanuputunchal. Ixtalhilay incha katatanul la ixchaqaꞌ qayntaun yu jantu israelita kaval ex kataxkilival ixjatsukuntikꞌan. Ex astan jantucha lay katavayl la ixkꞌatankꞌan yu Paxku, ex jantu katatanul. ");
INSERT INTO tptNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Xlhiyucha ni Pilato taxtul maqspaꞌ para katꞌachivinil, ex jalakjunil: —¿Tisuncha laqtaqal mukꞌaniyatꞌik ni aniy lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ex taqaltayl, va tajunil: —Yu va jantu ixlhitsukul tuꞌuchun laqtaqal, kijnan jantu xaklalhiminiu. ");
INSERT INTO tptNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ex va chuncha jalakjunil ni Pilato: —Kꞌalhipꞌintꞌikcha, uxiknan kꞌamukꞌanitꞌik laqtaqal tacha yu lhinajun la milhachimoꞌonkꞌan. Ex taqaltayl ni israelitas, tajunil: —Kijnan yu israelitas kuntau jantu klhitsukuu lakatin kakmaqniu qayntaun lapanaki por ixlaqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ex laqsaval chuncha tapasal tacha naul ni Jesús tas kunacha tejkan kaniyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ni Pilato aaqtaun tanuchoqol laqa ay chaqaꞌ ex juntaꞌil ni Jesús, va lhisakmil: —¿Uxintꞌicha kꞌatꞌi yu ay ixjalhachimoꞌonukꞌan ni israelitas? ");
INSERT INTO tptNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ni Jesús junil: —¿Va chuncha pꞌastꞌakꞌa milaqꞌaman u va chuncha tajuniy yu alati yu kintalhichiviniy kitꞌin? ");
INSERT INTO tptNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ex qaltayanal ni Pilato, va naul: —¿Kilhilay ni kitꞌin va israelita kunita? Tachun yu mintꞌamachaqan ali yu xaꞌukxtinin kuras, va yuꞌuncha tamaqxtaqyan la kintamakaꞌ. ¿Tisuncha laqtaqal makꞌatꞌa? ");
INSERT INTO tptNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ex qaltayanal ni Jesús: —Kimpalhachimoꞌon jantu aniy lakamunukpaꞌ kaval. Incha va aniy ixval ex xaklhitsukul lapanakni yu ixkintaꞌaqtayjul para jantu kintachꞌapachal kintꞌaꞌisraelitas. Pero kimpalhachimoꞌon jantu aniy kaval. ");
INSERT INTO tptNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ex ni Pilato aaqtaun naunchoqol: —Ex ni uxintꞌi ka va jalhachimoꞌonu kꞌatꞌi. Ex ni Jesús qaltayl, va junil: —Laqsaval yu naꞌun, ni va kitꞌin jalhachimoꞌonuꞌ kunita. Xlhiyucha ktsukul aniy, kmil lakamunukpaꞌ va para knaul yu laqsaval. Tachun yu taꞌachaniy yu laqsaval yuꞌuncha kintaqasmakniy kinchivinti. ");
INSERT INTO tptNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ex qaltaychoqol ni Pilato, va junil: —¿Ex tisuncha yu laqsaval? Tejkan chuncha naul ni Pilato ex anchoqol maqspaꞌ jalaktꞌachivin ni israelitas, jalakjunil: —Kitꞌin jantu ktemaniy tuꞌuchun laqtaqal ni aniy lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero mimputsukukꞌan yucha najun ni kitꞌin maqskꞌiniy kakxꞌoqlhi qayntaun tachꞌin tejkan xakꞌatan Paxku jun. ¿Naunatꞌik kakxꞌoqlhi ni aniy lapanaki yu junkan mijalhachimoꞌonukꞌan ni uxiknan yu israelitas untꞌatꞌik? ");
INSERT INTO tptNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tachun tamatꞌasal, tajunil: —¡Jantu kaxꞌoqtꞌi ni anchanu lapanaki! ¡Va kaxꞌoqtꞌi ni Barrabás! Ni Barrabás yucha va alhavanaꞌ ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ex ni Pilato chꞌapachal ni Jesús, lhinaul ixmaqanaqka. ");
INSERT INTO tptNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yu tropas tamalaqxtoqlhi jaltukun, tamakal laqataun korona. Ex tamaꞌaqtanul la ixꞌaqtsul, vachu taꞌulanil aqxtaun laqchꞌiti yu xakolor qoteꞌe tacha ixtaꞌulay jalhachimoꞌonun. ");
INSERT INTO tptNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ex tatalakanunil ni Jesús, tanaul: —¡Katsukul ixlhachimoꞌonukꞌan ni israelitas! Tachun ixtalakapusay. ");
INSERT INTO tptNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ni Pilato aaqtaun taxtuchoqol, jalakjunil ni lapanakni: —Kꞌaꞌasmaktꞌik. Kitꞌin kmaqaxtul va para kataxtaqnin kuenta ni kitꞌin jantu kaktemanil tuꞌuchun laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Chuncha taxtulcha ni Jesús, ixꞌaqtanuy ixkorona yu jamakanti kun jaltukun, vachu ixꞌulata ni anchanu laqchꞌiti yu qoteꞌe. Ex naul ni Pilato: —Kꞌalaqtsꞌintꞌik ni aniy lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tejkan ni xaꞌukxtinin kuras ali yu xajalhistaknan lakatajtan talaqtsꞌil ni Jesús, ex aqtayl pꞌays tamatꞌasay, tajunil: —¡Kꞌamakxtꞌukmukꞌacha! ¡Kꞌamakxtꞌukmukꞌacha! Chuncha ni Pilato jalakjunil: —Kꞌalhipꞌintꞌikcha, kꞌamakxtꞌukmukꞌatꞌikcha uxiknan. Kitꞌin jantu tuꞌuchun laqtaqal ktemaniy. ");
INSERT INTO tptNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ex tanaul ni israelitas: —Kijnan la kilhachimoꞌonkꞌan, ancha najun yu aniy lapanaki maqskꞌiniy kanil, va por najun ni yucha Sasꞌatꞌa Dios junita. ");
INSERT INTO tptNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tejkan chuncha qasmaklhi ni Pilato ex ayaj talhanal. ");
INSERT INTO tptNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tanuchoqochalcha aaqtaun ixpulakna ni ay chaqaꞌ, va lhisakmil ni Jesús: —¿Toꞌoxtaycha machaqa kꞌatꞌi ni uxintꞌi? Pero yu Jesús jantu kaqaltayl. ");
INSERT INTO tptNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ex ni Pilato va junil: —¿Ex jantu kꞌiꞌaltꞌayeꞌe? ¿Jantu kꞌatsꞌay ni kitꞌin klhitꞌajun tapꞌasta para kakmakajun oxamaktaun, vachu klhitꞌajun tapꞌasta para kakmakxtukmukꞌan? ");
INSERT INTO tptNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ex qaltayl ni Jesús, va junil: —Yu mintapꞌasta yu lhitꞌaꞌun vamun yu xtaqnin ni Dios. Xlhiyucha apalay ay laqtaqal tataukꞌaniyachal yu kimaqxtaqlhi la mintamakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tejkan chuncha naul ni Jesús ex ni Pilato ayaj ixlakxkauniy tas kamakalcha para kamakaul oxamaktaun, pero yu israelitas pꞌays tamatꞌasal, tajunil: —Incha kꞌamakꞌauneꞌe oxamaktaun ex jantu kaꞌuntꞌi ixꞌamigo ni ay jalhachimoꞌonuꞌ César. Aniy lapanaki makakan tacha ay jalhachimoꞌonuꞌ kaval, xlhiyucha va ixtꞌalaxkayaꞌ ni César. ");
INSERT INTO tptNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tejkan chuncha qasmaklhi ni Pilato, ex lhinaulcha kamaqaxtukkal ni Jesús. Chuncha ni Pilato taulalcha laka siya yu palhachimoꞌon yu vil taꞌan ixlakmamakanta laqxtaꞌalachiyux ixlhimaqspaꞌ laqa ay chaqaꞌ, ancha va junkan Gabata laka lhihebreo. ");
INSERT INTO tptNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ni anchanu julchan va paqtauncha istsꞌanqay para xakꞌatan Paxku yu ay ixkꞌatankꞌan ni israelitas. Tejkan atunkujcha ixjunita ex jalakjunil ni israelitas ni Pilato: —Aniy lhitꞌaunatꞌikcha la mintamakakꞌan ni mijalhachimoꞌonukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ni yuꞌuncha pꞌays tamatꞌasal, tajunil: —¡Tsꞌanqay kanil! ¡Kanilcha! ¡Kꞌamakxtꞌukmukꞌacha! Ex va chuncha jalhisakmil ni Pilato, va naul: —¿Ex kitꞌin kakmakxtukmukꞌayaꞌ ni mijalhachimoꞌonukꞌan? Chuncha taqaltayl ni xaꞌukxtinin kuras: —Kijalhachimoꞌonukꞌan vamun ni César yu ay jalhachimoꞌonuꞌ. Jantu kaklhitsukuu aqayntaun. ");
INSERT INTO tptNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ex ni Pilato maqxtaqlhicha ni Jesús para kamakxtukmukꞌakalcha. Ex talhaꞌalcha. ");
INSERT INTO tptNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ni Jesús taxtulcha, aqxaulhaꞌalcha ixkurus taꞌan ixlhimapaqaꞌukan Xajalukuti Aqtsul yu laka lhihebreo junkan Gólgota. ");
INSERT INTO tptNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ancha tamakxtukmukꞌachal chꞌantaun kun qayntꞌuy lapanakni yu lakmakxtukmukꞌakanta la ixpaꞌexnan, yucha tanꞌajmukꞌakalcha. ");
INSERT INTO tptNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ni Pilato jamalaqachanal kaꞌankal tsꞌoqmukꞌaka letras la ixꞌukxna ixkurus yu najun inchineꞌ: “Jesús yu machaqaꞌ Nazaret yu ay ixJalhachimoꞌonukꞌan ni israelitas.” ");
INSERT INTO tptNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ayaj qaynlhuu israelitas taputeꞌel ni letrero, taꞌan tamakxtukmukꞌal ni Jesús jantu ixlhimaqati ixjunita yu ay putaulan. Yu letrero istsꞌoqkanta laka putꞌutu lhichivin. Istsꞌoqkanta laka lhihebreo ali laka lhilatin ali laka lhigriego. ");
INSERT INTO tptNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xlhiyucha ni xaꞌukxtinin kuras ali ni israelitas tajunil ni Pilato: —Jantu katsꞌoqmukꞌa “Ixjalhachimoꞌonukꞌan ni israelitas.” Apalay ox katsꞌoqmukꞌa “Yu ixnajun va ixJalhachimoꞌonukꞌan israelitas junita.” ");
INSERT INTO tptNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ni Pilato jalajqaltayl, jalakjunil: —Va chuncha ktsꞌoqmukꞌal, ex va chuncha kavalcha. ");
INSERT INTO tptNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Taval tejkan tamakxtukmukꞌalcha ni Jesús ex ni tropas tasaknil ixlaqchꞌiti. Talaqlvaqnilcha siya yuꞌuncha yu pumatꞌati tropas ixtajunita. Vachu tasaknil aqxtaun ixlaqchꞌiti yu jantu kalakatsꞌapꞌamakal, valiꞌiy aqxtaun lman laqchꞌiti ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ex ni tropas talajunil siya yuꞌuncha: —Ox kaval jantu kalajꞌexvi. Kamakau taun suerte para kakꞌatsau tasꞌayucha kapaxtoqniyacha. Ex laqsaval chuncha tapasal tacha tsꞌoqkanta la ixchivinti Dios taꞌan junkan Salmo yu najun inchine: “Talaqlvaqnil por qayntamin kilaqchꞌiti y vachu tamakal suerte por kilaqchꞌiti yu lman.” Y laqsaval chuncha tamakal ni tropas. ");
INSERT INTO tptNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ancha taꞌan ixyal ni kurus, ixtayanal pumatꞌati xanatin. Ancha ixyal ixnati ni Jesús ali ixtꞌalapanaki ixnati ali ixanati Cleofas yu junkan María, vachu ancha ixyal ni María Magdalena. ");
INSERT INTO tptNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ni Jesús laqtsꞌil ni ixnati va chꞌantaun ixtꞌayal ixtꞌaltanaꞌ yu ayaj ixꞌachaniy. Ex junil ni ixnati: —Xanati, anchanuꞌ yal mintsꞌal. ");
INSERT INTO tptNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Astan vachu junil ixtꞌaltanaꞌ yu ixmalaniy: —Kalaqtsꞌi, anchanuꞌ yal minati. Ex ni anchanu laqaꞌil la ixchaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ex astan ni Jesús tejkan tapasaꞌolcha tachun yu ixmaqskꞌiniy katapasal, ixnajun kataqayntsal tacha istsꞌoqkanta, xlhiyucha naul: —Ayaj kpukikxixa. ");
INSERT INTO tptNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Yu tropas ixtaꞌulata taun xaluj vinagre. Tamatajul taun esponja ex taꞌakatachꞌimukꞌal aqatataun javan yu junkan hisopo, talhachaꞌanil la ixkilna. ");
INSERT INTO tptNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ni Jesús oqlhi ni vinagre ex naul: —Chavay taqayntsaꞌolcha. Ex maqayntalcha ixꞌaqtsul, ex nilcha. ");
INSERT INTO tptNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Anchanu julchan va tauncha julchan istsꞌanqay para kaval Paxku yu ay ixkꞌatankꞌan ni israelitas, vachu yu xajulchan jastaknati yu ayaj ixtatoꞌoyay ni israelitas. Yuꞌuncha jantu ixtamaqamay katamakaul laka kurus yu ixlakatunajkꞌan yu ixlakmakxtukmukꞌakan. Xlhiyucha tajunil ni Pilato para kalhinaul ixlajqatuteꞌekakꞌan para katanil y kamaqosukal ixlakatunajkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yu tropas tejkan ancha tachaꞌal, pꞌunaj taqatuteꞌel qayntaun yu ixmaknajukꞌal, vachu yu aqayntaun taꞌan ixpaꞌexna ixjukꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero tejkan talaqꞌal ni Jesús taꞌan ixjukꞌal ex niman talaqtsꞌil ni yucha ixnitacha. Ex jantucha kataqatuteꞌel. ");
INSERT INTO tptNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero qayntaun tropa vananaj ltoqonil ixtankilakna kun ixlanza, ex taxtul ixjakꞌalnan kun xkan. ");
INSERT INTO tptNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Yu laqsaval laqtsꞌil yucha laqputeꞌey tachun yu tapasal, va ox kꞌatsay y najun yu laqsaval para kꞌalhakꞌapꞌupꞌintꞌik vachuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tachun yu aniy tapasal para kataqayntsal yu istsꞌoqkanta la ixchivinti Dios yu najun inchineꞌ: “Yucha jantu intachun katalaqteꞌeniyaꞌ ixjalukuti.” ");
INSERT INTO tptNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Vachuꞌ alakataun istsꞌoqkanta yu najun inchineꞌ: “Katalaqtsꞌinaꞌ ni lapanaki yu taltoqol.” ");
INSERT INTO tptNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ixꞌalin qayntaun José yu machaqaꞌ Arimatea yu vachu ixtꞌaꞌan Jesús para kalanil, pero va laqatamaqsaq. Ixjalaktalhauniy yu xalajꞌaynin israelitas. Yucha tapayninil ni Pilato para kaxtaqnikal lakatin incha lay kalhaꞌal ixlakatunaj ni Jesús. Ni Pilato xtaqnil lakatin ex alcha pꞌuxnuꞌ ni ixlakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Vachuꞌ chinchal ni Nicodemo, yucha va yu ixtꞌachivininta ni Jesús aqtauncha tejkan tsꞌis ixjunita. Lhichil treinta kilos yu sꞌejenꞌe perfume, ixlhiyal xakꞌiu mirro ali aloes. ");
INSERT INTO tptNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ex ni José ali Nicodemo tapꞌuxlhicha ixlakatunaj ni Jesús, aqtayl tapamiliy kun laqchꞌiti. Ox talhilakaxapal ni sꞌejenꞌe perfume, va chuncha ixputsukukꞌan ni israelitas tejkan ixtamaknunun. ");
INSERT INTO tptNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Taꞌan tamakxtukmukꞌal ni Jesús ixꞌalin taꞌan ixchꞌankanta olivos, ancha ixꞌalin laqataun putaknun yu ox saystꞌi ixjunita. Jantukaꞌ matichun ixmamakan. ");
INSERT INTO tptNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Va laycha kaꞌaqtaynil xajulchan jastaknati y jantu maqati ixjunita yu putaknun. Ex ancha tamaꞌalcha ixlakatunaj ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yu xapꞌunaj julchan laka semana ni puvakuj tejkan vanaj tsꞌis ixjunita ex ni María Magdalena al laka putaknun. Ancha laqtsꞌil ni va ixmoqosukantacha ni chiyux yu ixlhimalakchaukanta. ");
INSERT INTO tptNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ex takyaulaqꞌal ni Simón Pedro ali yu aqayntaun ixtꞌaltanaꞌ Jesús yu ayaj ixꞌachaniy. Va lakjunil: —¡Tamoqosutacha ni Jalhachimoꞌonu Jesús la ixputaknun! ¡Jantu ijkꞌatsayau toꞌoxtaycha talhaꞌanta! ");
INSERT INTO tptNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ex Pedro ali yu aqayntaun ixtꞌaltanaꞌ Jesús taꞌal laka putaknun. ");
INSERT INTO tptNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tatakyauꞌal pero yu aqayntaun apalay soqol xajantu yu Pedro, yucha pꞌunaj chaꞌal laka putaknun. ");
INSERT INTO tptNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ancha taqayntal, va lakavanal ixpulakna taꞌan ixmal ni laqchꞌiti yu ixlhipamilkanta pero jantu katanul. ");
INSERT INTO tptNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ex astan chaꞌal ni Simón Pedro, yucha vas tanuchal laka putaknun. Ancha laqtsꞌil ni laqchꞌiti yu ixmal, ");
INSERT INTO tptNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","vachuꞌ ni laqchꞌiti yu ixlhipamilnikanta ixꞌaqtsul ni Jesús. Ni anchanuꞌ laqchꞌiti jantu chꞌantaun katamal kun yu alati laqchꞌiti, va tumpaj ixmilmakanta. ");
INSERT INTO tptNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ex yu aqayntaun yu pꞌunaj chaꞌal vachuꞌ tanuchal. Va laqtsꞌil ex lhakapuꞌal ni kujchoqol. ");
INSERT INTO tptNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Jantukaꞌ ixtamalaqasiy tacha istsꞌoqkantacha la ixchivinti Dios ni maqskꞌiniy kakujchoqol laka janinin. ");
INSERT INTO tptNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ex ni anchanuꞌ pumatꞌuy yu ixjalakmalaniy Jesús taꞌanchoqol laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María ixqalhunyal ixlhimaqspaꞌ laka putaknun. Tejkan ixqalhun va taqayntal, va lakavanal ixpulakna ni putaknun. ");
INSERT INTO tptNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ancha laqtsꞌil qayntꞌuy ixmayulnin Dios, ixtalhilakayanal laqxutꞌutꞌu laqchꞌiti, va ixtavilanal taꞌan ixmamakanta ixlakatunaj ni Jesús, qayntaun la ixlaqaꞌaqtsul, yu aqayntaun la ixlakachꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ex tajunil: —Xanati, ¿valiꞌiycha alhun? Ex yucha qaltayanal: —Talhaꞌantacha ixlakatunaj kiJalhachimoꞌonuꞌ y jantu ijkꞌatsay toꞌoxtaycha tamamatacha. ");
INSERT INTO tptNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ex talaqaspꞌiklhi, va laqtsꞌil ni Jesús yu ancha ixyal pero jantu kamispal incha va Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ex ni Jesús va junil: —Xanati, ¿valiꞌiycha alhun? ¿Taꞌayucha lakxkꞌaꞌuycha? Ni María lhilal va xalhistaknaꞌ ni jatachꞌanati, ex chuncha junil: —Incha va uxintꞌi lhipꞌi ex kiꞌun toꞌoxtaycha mamatꞌa ex kitꞌin kajkꞌanaꞌ iniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ex ni Jesús junil: —María. Ni María talaqaspꞌiklhi, va lhimapaqaꞌul: —¡Raboni! (Yucha naunputun maestro laka lhihebreo.) ");
INSERT INTO tptNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ni Jesús va junil: —Jantucha kꞌinchꞌapꞌa, jantukaꞌ kpataxtuchoqoy taꞌan vil kimPay. Kꞌalaqpꞌinchꞌiy ketꞌalaqaunin. Kꞌalakꞌun ni kakpataxtuchoqoyaꞌ taꞌan vil kimPay yu vachuꞌ mimPaykꞌan, yucha kiDios y vachuꞌ miDioskꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ex ni María Magdalena jalaqꞌal ixtꞌaltanan ni Jesús, va jalakjunil: —¡Va klaqtsꞌil ni Jalhachimoꞌonu Jesús! Ex jalaqputeꞌeniꞌol tachun yu ixjunkanta. ");
INSERT INTO tptNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ni anchanu julchan yu xapꞌunaj laka semana tejkan putsꞌista val, ixtaꞌaqxtoqnun ixtꞌaltanan Jesús yu ixjalakmalaniy. Ixtalaqachꞌinunun laqa chaqaꞌ, va ixtatalhauniy yu alati ixtꞌaꞌisraelitaskꞌan. Ex va chinchal ni Jesús, va tayachil taꞌan ixtavilanal. Va lakjunil: —Kꞌatꞌaꞌoxamaktꞌamichꞌoꞌotꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tejkan chuncha naul, va jalakmasunil ixmakaꞌ ali ixtankilakna. Ixtꞌaltanan va ayaj talhiꞌachantajul tejkan talaqtsꞌil ixJalhachimoꞌonukꞌan. ");
INSERT INTO tptNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aaqtaun naunchoqol ni Jesús: —Kꞌatꞌaꞌoxamaktꞌamichꞌoꞌotꞌik. Vachu va tacha kimalaqachal ni kimPay vachu va chun klamalaqachayau ni uxiknan. ");
INSERT INTO tptNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tejkan chuncha naul, va jalaksunul ex naul: —Kꞌalaꞌaꞌitꞌik ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Incha uxiknan malaqmixiniyatꞌik ixtalaqalhin matichun ex va malaqmixikantacha. Incha naunatꞌik ni jantu kamalaqmixikal ixtalaqalhin ex jantu kamalaqmixikal. ");
INSERT INTO tptNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ni Tomás yu vachuꞌ ixlhimapaqaꞌukan Jachiyan, xaqayntaun yu pumakautꞌuy ixtꞌaltanan Jesús, yucha jantu kalaktꞌataulal tejkan jalaktasunil ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yu alati ixtꞌaltanan Jesús tajunil: —¡Klaqtsꞌiucha ni Jalhachimoꞌonu Jesús! Pero ni Tomás jalakjunil: —Incha jantu klaqtsꞌiniy taꞌan ixmakxtukkanta kun klavos, vachuꞌ incha jantu kmanuy kimakaꞌ taꞌan ixmaqltoqokanta, vachuꞌ taꞌan ixtanqalaqltoqokanta, ex jantu klhakapuꞌanaꞌ ni kujchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tejkan tauncha semana val ixtaꞌaqxtoqnunchoqoy ixtꞌaltanan ni Jesús. Yu Tomás vachuꞌ ancha ixꞌalinta kun yuꞌuncha. Mas ox ixlakchajuy ni puertas, va chil ni Jesús, tayachal taꞌan ixtaꞌalinta. Va naul: —Kꞌatꞌaꞌoxamaktꞌamichꞌoꞌotꞌik. ");
INSERT INTO tptNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ex naul, va junkal ni Tomás: —Kꞌamanutꞌi aniy mimakaꞌ, vachuꞌ kalaqtsꞌi ni kimakaꞌ. Kꞌalhitꞌi mimakaꞌ ex kꞌamanutꞌi la kintankilakna. Jantucha kꞌalapꞌasnitꞌi mijatapastakꞌatꞌi, kꞌalhakꞌapꞌupꞌicha. ");
INSERT INTO tptNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ni Tomás qaltayl: —¡KiJalhachimoꞌonu kꞌatꞌi y kiDios kꞌatꞌi! ");
INSERT INTO tptNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ex ni Jesús va junil: —¿Va chavaykaꞌ xalhakꞌapꞌupꞌin tejkan kꞌilaqtsꞌi? Ni lapanakni yu kintalhakapuꞌan mas jantu kintalaqtsꞌin va yuꞌuncha yu laqsaval taꞌachantacha. ");
INSERT INTO tptNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ni Jesús jalakmasunichoqol ixtꞌaltanan yu jalakmalaniy lhuu lajꞌay axtoqnuꞌ yu jantu katsꞌoqmukꞌakal aniy laka libro. ");
INSERT INTO tptNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero yu aniy tsꞌoqmukꞌakal va para kꞌalhakꞌapꞌupꞌintꞌik ni Jesús va yu Cristo, yu Dios ixnajunta kamalaqachayaꞌ, vachuꞌ yu Sasꞌatꞌa Dios junita. Kꞌalhitsꞌukꞌuyapitik yu ox jatsukunti incha chuncha kꞌalhakꞌapꞌupꞌinapitik. ");
INSERT INTO tptNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Astan ni Jesús aaqtauncha jalaktasunichoqol ixtꞌaltanan yu ixjalakmalaniy taꞌan ixkilpaꞌ lakamar yu junkan Tiberias. Va inchineꞌ val. ");
INSERT INTO tptNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Va chꞌantaun ixtaꞌalinta ni Simón Pedro ali Tomás yu junkan Jachiyan ali Natanael yu machaqaꞌ Kaná xalakatꞌun Galilea ali yu pumatꞌuy istsꞌalan Zebedeo ali apumatꞌuy yu ixjalakmalaniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ni Simón Pedro va jalakjunil yu alati: —Kitꞌin kteꞌen chꞌapanaꞌ jatanti. Ex yuꞌuncha tajunil: —Vachuꞌ klatꞌaꞌanau. Ex taꞌal laka barco pero tus taun tatsꞌisin jantu tuꞌuchun katachꞌapal. ");
INSERT INTO tptNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Tejkan ixtunkumintacha ni Jesús ixyal la ixkilpaꞌ ni lakamar pero jantu katamispal incha va yucha. ");
INSERT INTO tptNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ex va jalaklhisakmil: —Tsꞌalan, ¿jantukaꞌ chꞌapꞌayatꞌik tuꞌuchun? Yuꞌuncha tanaul: —Jantu. ");
INSERT INTO tptNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ex jalakjunil: —Kꞌatꞌanꞌalhutꞌik minchꞌoqxkꞌan la ixlhijakanaj ni barco, ex kꞌachꞌapꞌayapitik. Ex tatanqalhul ixchꞌoqxkꞌan pero jantucha lay ixtaxaqakutuchoqoy por lhuu jatanti ixtanun. ");
INSERT INTO tptNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ni ixtꞌaltanaꞌ Jesús yu ayaj ixꞌachaniy va junil ni Pedro: —¡Va yucha ni Jalhachimoꞌonuꞌ! Tejkan Pedro qasmaklhi ni va yu Jalhachimoꞌonu Jesús, va lhitampachꞌikal ixlaqchꞌiti yu ixmajꞌanta ex jakꞌiuklnil lakxkan. ");
INSERT INTO tptNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yu alati yu ixtꞌaltanan ni Jesús tapuminchoqol barco, ixtaxaqamalhaꞌanta ni chꞌoqxni yu aqtsamanta jatanti. Jantu maqati ixtatꞌajun la ixkilpaꞌ, va tacha cien metros. ");
INSERT INTO tptNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tejkan tapatajul ancha la ixkilpaꞌ va talaqtsꞌil jayaqan. Ancha ixmal jatanti, vachuꞌ ixꞌalin pan. ");
INSERT INTO tptNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ex ni Jesús jalakjunil: —Kꞌalhitꞌantꞌik ni jatanti yu xachꞌapꞌayatꞌikkaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ex ni Simón Pedro taukꞌachoqol ni laka barco, va xaqamaxtul ni chꞌoqxni tus la ixkilpaꞌ. Va ixꞌaqtsamanta kun lajꞌay jatantin tus 153. Pero jantu kataꞌexlhi ni chꞌoqxni. ");
INSERT INTO tptNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ni Jesús jalakjunil: —Kꞌavaynchꞌipitik. Jantu matichun ixtꞌaltanan ixtapujuy kalhisakmil taꞌayucha ixjunita. Ixtakꞌatsay ni va yu Jalhachimoꞌonuꞌ Jesús. ");
INSERT INTO tptNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ni Jesús al iniꞌ ni pan y jalaqxtaqnil. Vachuꞌ jalaqxtaqnil ni jatanti. ");
INSERT INTO tptNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yucha va yu aqtꞌutunucha val tejkan Jesús jalaktasunil ixtꞌaltanan tejkan ixkujchoqotacha la ixlhinin. ");
INSERT INTO tptNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tejkan tavaynꞌolcha ex ni Jesús lhisakmil ni Simón Pedro: —Simón, istsꞌal Jonás kꞌatꞌi, ¿apalay kꞌiꞌachꞌaniy xajantu yu alati? Ex Pedro qaltayl: —Chun, Jalhachimoꞌonuꞌ. Uxintꞌi kꞌatsꞌaycha ni va kitꞌin kꞌachaniyan. Ex ni Jesús junil: —Kꞌalaklhistꞌaktꞌi kilapanakni, yu va tacha lakstꞌuniy borregos tajunita. ");
INSERT INTO tptNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aaqtauncha ni Jesús lhisakmichoqol: —Simón, istsꞌal Jonás kꞌatꞌi, ¿kꞌiꞌachꞌaniy? Ex ni Pedro qaltaychoqol: —Chun, Jalhachimoꞌonuꞌ. Uxintꞌi kꞌatsꞌaycha ni va kitꞌin kꞌachaniyan. Ex ni Jesús junil: —Kꞌalaklhistꞌaktꞌi kilapanakni yu va tacha lakstꞌuniy borregos tajunita. ");
INSERT INTO tptNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ex yu aqtꞌutunuꞌ ni Jesús lhisakmichoqol: —Simón, istsꞌal Jonás kꞌatꞌi, ¿kꞌiꞌachꞌaniy? Ex va maqaninil ni Pedro va por aqtꞌutucha ixlhisakmiy ni Jesús incha ixꞌachaniy. Ex va junil: —Jalhachimoꞌonuꞌ, uxintꞌi kꞌatsꞌaꞌoꞌoy tachun. Va kꞌatsꞌaycha ni kitꞌin kꞌachaniyan. Ex ni Jesús junil: —Kꞌalaklhistꞌaktꞌi kilapanakni yu tacha lakstꞌuniy borregos tajunita. ");
INSERT INTO tptNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Laqsaval kunan ni tejkan tsꞌalkaꞌ ixꞌunitꞌa ixmalaqchꞌinikꞌan meꞌeman, ixpꞌin taꞌan ixꞌuxipꞌin. Pero tejkan kꞌatꞌaxapꞌayayeꞌecha ex kꞌamakxnujkꞌaneꞌe, va aqayntaun kamalaqchꞌiniyan. Vachuꞌ kalhaꞌanan taꞌan jantu kaꞌuxapꞌineꞌe. ");
INSERT INTO tptNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Chuncha naul ni Jesús para kamasul tas kapuniyaꞌ ni Pedro y chuncha ay kamakakanaꞌ ni Dios. Ex ni Jesús junil: —Kꞌintꞌaltꞌancha. ");
INSERT INTO tptNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ex ni Pedro talaqaspꞌiklhi, va laqtsꞌil yu aqayntaun ixtꞌaltanaꞌ Jesús, yu ayaj ixꞌachaniy. Va yucha ixtaꞌukstsꞌuninita ni Jesús tejkan ixtatꞌatꞌajun vaynin y ixlhisakmitacha: “Jalhachimoꞌonuꞌ, ¿taꞌayucha yu kamaqxtaꞌancha?” ");
INSERT INTO tptNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tejkan Pedro laqtsꞌil, va lhisakmil ni Jesús: —Jalhachimoꞌonuꞌ, ¿tas kalhitapasayacha kun yucha? ");
INSERT INTO tptNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ex ni Jesús qaltayl: —Incha kitꞌin knajun jantu kanil tus tejkan kakminchoqol, ex yucha jantu minkuenta kaval. Ni uxintꞌi maqskꞌiniy kꞌintꞌaltꞌancha. ");
INSERT INTO tptNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Por chuncha naul ni Jesús, lati ni tꞌalaqaunin ixtanajun ni anchanu lapanaki jantu kaniyaꞌ. Pero ni Jesús jantu kanaul incha jantu kaniyaꞌ, vamun naul: “Incha kitꞌin knajun jantu kanil tus tejkan kakminchoqol, ex yucha jantu minkuenta kaval.” ");
INSERT INTO tptNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ni anchanuꞌ ixtꞌaltanaꞌ ni Jesús, va yucha yu lhichivinil tachun yu aniy lhitapasal y va yucha yu tsꞌoqlhi. Kijnan ijkꞌatsayau ni va laqsaval yu najun. ");
INSERT INTO tptNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Apalay lhuu axtoqnuꞌ alin yu makal ni Jesús. Incha katsꞌoqmukꞌakal tachun por laqatamin, kitꞌin knajun kamaqskꞌinil aqxlhuu libros tus jantu kalhival ni lakamunukpaꞌ. Va chuncha kaval.");
INSERT INTO tptNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ni karta yu pꞌunaj kmalaqachanin, Teófilo, ancha xaktsꞌoqnitan tachun yu makal ni Jesús. Vachu ancha xaktsꞌoqnitan tachun yu jamalaninil mas tus tejkan pꞌunaj yu puꞌaqtaynil makanaꞌ ixlhitapatsa ");
INSERT INTO tptNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tus tejkan anchoqol laktꞌiyan. Ixꞌalin lapanakni yu ixjalaksakta y jalaqmalaqachal tejkan jantukaꞌ ixꞌan laktꞌiyan, ex kun ixtapꞌasta ni Espíritu Santo jalakmasunil yu maqskꞌiniy katamakal. ");
INSERT INTO tptNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tejkan nil ni Jesús ex astan aqlhuvaj jalaktasunichoqol. Tus tꞌuy pꞌuxaun julchan ixtꞌajun jalaktasuniniꞌ para katakꞌatsal ni laqsaval ixkujchoqotacha y laqlhixaqalal tacha lhachimoꞌonun ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tejkan vananaj ixjalaktꞌavil va jalakjunil ni jantu katataxtul laka putaulan Jerusalén, y va lakjunil: —Pꞌunaj kapꞌakxanꞌelayapitik yu ixnajun laqsaval kataxtaqniyan kimPay Dios chuncha tacha klajuniu. ");
INSERT INTO tptNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ni Juan va xkan ixpumaqchajꞌavanan pero va laycha kalakachil ni julchan tejkan kꞌapꞌumaqchꞌajꞌavakꞌanapitik ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ex chuncha tejkan tataqxtoqlhi va talhisakmil ni Jesús va tajunil: —¿Jalhachimoꞌonuꞌ, chavaycha kalakmapꞌaxayeꞌecha ni jalhachimoꞌonun la kilakatꞌunkꞌan para kalhichimoꞌochoqoocha ni kijnankꞌan yu israelitas juntau? ");
INSERT INTO tptNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ex va lakjunil ni Jesús: —Ni uxiknankꞌan jantu tapaxtoqniyan kakꞌatsꞌatꞌik tisuncha julchan u tisuncha hora chuncha katapasayaꞌ. Yu kimPay Dios yucha paxtoqniy kalhinaul tas vanancha kamakayaꞌ tuꞌuchun. ");
INSERT INTO tptNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Katanuyaꞌ ni Espíritu Santo la melhanutikꞌan ex chuncha kalaꞌaꞌiyapitik ixtapꞌasta. Ex kilalhichivinanau ni kitꞌin aniy laka putaulan Jerusalén y vachuꞌ tachun aniy xalakatꞌun Judea y vachuꞌ tus xalakatꞌun Samaria y mas tus yu apalay laqmaqati lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tejkan chuncha naunꞌol ni Jesús ex talaqtsꞌil va lhaꞌankalcha, pataxtulcha laktꞌiyan. Tanulcha laka taputsꞌi, y jantucha apalay katasul. ");
INSERT INTO tptNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tejkan sniy ixtatꞌajun laqtsꞌinin taꞌan puꞌal laktꞌiyan ex tsꞌalaj tatasul qayntꞌuy lapanakni. Ixtalhilakayanal yu pꞌays laqxutꞌutꞌu laqchꞌiti y laktꞌatayal chꞌantaun kun yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Va tanaul: —Uxiknan, lapanakni yu machaqan Galilea untꞌatꞌik, ¿valiꞌiycha lakꞌapꞌinatꞌikcha laktꞌiyan? Ni Jesús yu pataxtulcha laktꞌiyan y tamakajuncha, yucha kaminchoqoyaꞌ vachu va chun tacha xalaqtsꞌinatꞌik tejkan xaꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ex chuncha yu jamalaqachal ni Jesús tataꞌeltajul laka aspajun yu junkan Xaꞌaspajun Olivos. Taꞌanchoqol ni laka ay putaulan Jerusalén. Ancha jantu ixlhimaqati ixjunita, ukxchuncha tacha yu ixtapaxtoqniy kataltanal ni israelitas tejkan xajulchan jastaknati ixjun. ");
INSERT INTO tptNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ex tachaꞌalcha ni laka putaulan va tataukꞌalcha taꞌan talaqtꞌuy chaqaꞌ ixjunita taꞌan ixtaloqojya. Yu taꞌal va Pedro ali Jacobo ali Juan ali Andrés ali Felipe ali Tomás ali Bartolomé ali Mateo ali Jacobo yu istsꞌal Alfeo ali Simón yu ixmapaxaputun ni gobierno ali Judas ixpꞌisaqa Jacobo. ");
INSERT INTO tptNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Aqlhuu ixtataqxtoqya y vamun ixtaskꞌin Dios tachun ni yuꞌuncha kun ixtꞌalaqaunin Jesús ali María, yu ixnati, ali alati xanatin. ");
INSERT INTO tptNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tejkan ataun julchan val, ex tataqxtoqlhi ni yuꞌuncha tus tacha ciento veinte lapanakni. Ex tayal ni Pedro la ixlakaꞌukxpukꞌan, va lakjunil: ");
INSERT INTO tptNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ketꞌalaqaunin, laqsaval ixmaqskꞌiniy chuncha kaval tacha yu maqancha ixnajun ni ay jalhachimoꞌonuꞌ David tejkan machivinil ni Espíritu Santo. Ni David lhichivinil ni Judas yu lakmapꞌulnil ni lapanakni yu tachꞌapal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ni Judas ixmispakan tacha kintꞌaltanakꞌan y va ixlaksakkanta para chꞌantaun kintatꞌatapatsan. ");
INSERT INTO tptNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero yu ixlhilhajati yu lhajal por maqxtaqlhi ni Jesús va kun yucha lhiꞌil aqxtaun tꞌun ex ancha nil. Y patajul tus tatanpusꞌea la ixpajan y taxtuꞌol ixpalun. ");
INSERT INTO tptNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ex tachun yu ixtavilanal Jerusalén takꞌatsal y talhimapaqaꞌul ni anchanuꞌ lakatꞌun Aseldama, yucha naunputun la ixlhichivinkꞌan Xatꞌun Jakꞌalnan. ");
INSERT INTO tptNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","La xalibro Salmos yu tsꞌoqlhi David, ancha lhichiviniy Judas, inchine najun: Kamakauntijlalcha taꞌan ixvil, jantucha kaꞌalil matichun yu lay ancha kataulal. Vachuꞌ alakataun najun: Aqayntauncha kalhitsukul ixlhitapatsa. ");
INSERT INTO tptNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ex taylhaanil ixchivinti ni Pedro, va naul: —Xlhiyucha maqskꞌiniy kalaksakvi aqayntaun lapanaki. Kalaksakꞌau qayntaun yu chꞌantaun tijuyal kun kijnan mas tus tejkan ixtꞌaꞌukxuyanau ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Tsꞌanqay kaval xaqayntaun yu kintꞌaltanakꞌan junita mas tus tejkan ixmaqchajꞌavanan ni Juan tus anchoqol laktꞌiyan ni Jesús la kintalakavantikꞌan. Chuncha ni yucha vachuꞌ kintatꞌalaqputeꞌeyan chꞌantaun kun kijnan ni laqsaval kujchoqolcha ni Jesús —naul ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ex talakꞌulal pumatꞌuy lapanakni. Xaqayntaun va José Barsabás yu vachuꞌ ixjunkan Justo. Yu aqayntaun ixjunkan Matías. ");
INSERT INTO tptNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ex va taskꞌinil ni Dios va tanaul: —KiJalhachimoꞌonuꞌ kꞌatꞌi. Uxintꞌi kilamispaniꞌoyau kelhanutikꞌan. Kilamasuniu tas ayucha yu uxintꞌi laksakꞌa ");
INSERT INTO tptNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para katapatsal kun uxintꞌi y para kaꞌal laqputeꞌeniꞌ minchivinti. Va yucha kapaxtoqnil ni lhitapatsa yu makaul Judas por ixtalaqalhin tejkan al taꞌan maqskꞌiniy. ");
INSERT INTO tptNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ex tamakal taun qamanti para katasul taꞌayucha kapaxtoqniyaꞌ y va paxtoqnil Matías. Ex ancha tamanulcha kun yu pumakautaun lapanakni yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tejkan lakachilcha ixkꞌatankꞌan ni israelitas yu junkan xajulchan Pentecostes, ex tachun yu ixtalhakapuꞌan ni Jesús va chꞌantaun ixtataꞌaqxtoqnun. ");
INSERT INTO tptNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Taval pꞌaysni makatꞌaunkal, tus tacha taun pꞌays un ixmakatꞌajun. Minchal tus laktꞌiyan y taqasmakꞌol ni lapanakni tus tapulakchux ni laqa chaqaꞌ taꞌan ixtavilanal. ");
INSERT INTO tptNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ex niman talaqtsꞌil taun tuꞌuchun tacha jikmi, y tataukꞌanichal laktsꞌuninin por qayntamin la ixꞌaqtsulkꞌan yu ancha ixtavilanal. ");
INSERT INTO tptNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ex tanul ni Espíritu Santo la ixjalhanutikꞌan. Taꞌaqtaylcha tachiviniy alati lhichivin yu jantu aqtaun ixtachiviniy. Chuncha lakmachivinil ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chuncha ni laka putaulan Jerusalén ixtachaꞌanta israelitas yu ox ixtataylhaꞌan tacha ixputsukukꞌan ixjunita, va ixtaminꞌotachal taꞌakapuchun ni lakamunukpaꞌ por ixkꞌatankꞌan yu ixtamakay. ");
INSERT INTO tptNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tejkan taqasmaklhi tacha ixtachiviniy yu ixtalhakapuꞌan ni Jesús, ex ni yuꞌuncha va tataqxtoqlhi y tus saq tatayal porke ixtaqasmatꞌa ixlhichivinkꞌan yu ixtalhichiviniy yuꞌuncha la ixlakatꞌunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ex chuncha tus taun takꞌatsal. Va tus tumpaj talhilal, va ixtalajuniy siya yuꞌuncha: —Tachun ni aniy lapanakni yu tatꞌajun chivinin va si machaqan xalakatꞌun Galilea. ");
INSERT INTO tptNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Ex tas laycha tapuchiviniy kilhichivinkꞌan yu chivinanau? ");
INSERT INTO tptNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lati ni kijnankꞌan va machaqan Partia juntau, y lati va machaqan Media, vachu lati va machaqan Elam ali machaqan Mesopotamia, ali machaqan Judea, ali machaqan Kapadosia, ali machaqan Ponto, ali machaqan Asia, ");
INSERT INTO tptNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ali machaqan Frigia, ali machaqan Panfilia, ali machaqan Egipto, ali machaqan xaputaulanaxna Libia yu vilchal xlhiꞌavintꞌi Cirene, ali machaqan Roma. Lati ni kijnankꞌan va israelitas juntau va por chuncha pupaqvi, y lati mas jantu katapupaqlhi tacha israelitas pero vachu talhakapuꞌan Dios tacha kijnankꞌan yu israelitas juntau. ");
INSERT INTO tptNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Y vachuꞌ alin yu machaqan Kreta ali machaqan Arabia. Chavaycha tachun ni kijnankꞌan qasmatꞌau la kilhichivinkꞌan yu lajꞌay axtoqnuꞌ yu makay Dios —chuncha talajunil ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tachun ayaj ixtapastakꞌuta, y jantu ixtamispay yu ixtatꞌajun laqtsꞌintapasanan. Ixtalalhisakmiy: —¿Chavaycha suncha tapasaycha ni aniy? ");
INSERT INTO tptNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero alati lapanakni ayaj ixtalajꞌachan, va tanaul: —Ka va taꞌapꞌanin. ");
INSERT INTO tptNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ex chuncha ni Pedro va laktꞌatayal yu pumakautaun yu jamalaqachal ni Jesús. Va la pꞌays chivinil va lakjunil tachun ni lapanakni: —Kintꞌaꞌisraelitas y vachuꞌ tachun yu chavaycha vilanantꞌik aniy laka putaulan Jerusalén. Ox kilaqasmakniu kinchivinti yu klajunau. ");
INSERT INTO tptNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni kijnankꞌan jantu taꞌapꞌanin kajkuu yu tacha uxiknankꞌan pꞌastꞌakꞌatꞌik. Chavaycha va laqanajatsikaꞌ puvakuj. ");
INSERT INTO tptNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Yu tꞌajun tapasanaꞌ va chuncha tacha lhichivinil Joel yu maqancha ixlaqputeꞌey ixchivinti Dios, va naul: ");
INSERT INTO tptNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Inchine najun ni Dios, tejkan valaycha kamiꞌoyaꞌ ni lakamunukpaꞌ kaklaqxtaqniyaꞌ ni Espíritu Santo tachun ni lapanakni. Yu mintsꞌalankꞌan ali metsiꞌinkꞌan katalaqputeꞌeyaꞌ kinchivinti. Yu mintsꞌalankꞌan katalaqtsꞌinaꞌ la ixtalakavantikꞌan yu katapasayaꞌ astan. Vachu yu xapaynin kalaqxaqalakanaꞌ la ixꞌaqlaqavantikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Vachuꞌ ni anchanu julchan kaklaqxtaqniyaꞌ ni Espíritu Santo yu joꞌakna ali xanatin yu kiꞌoqxtamatin tajunita, ex ni yuꞌuncha katalaqputeꞌeyacha kinchivinti. ");
INSERT INTO tptNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Vachuꞌ kakmasuyaꞌ lajꞌay axtoqnuꞌ laktꞌiyan. Vachuꞌ lakatꞌun kaꞌalinaꞌ yu jantu aqtaun katalaqtsꞌil ni lapanakni: Kaꞌalinaꞌ lhilukuj, lhuu jakꞌalnan, lhuu jikmi, ali lhuu jin tus tacha taputsꞌi kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yu julchan jantucha kamapulkuyaꞌ, putsꞌista kunaꞌ. Yu malkuyuꞌ tacha jakꞌalnan katasuyaꞌ. Ex astan kachinaꞌ ixjulchan ni ay Jalhachimoꞌonuꞌ Dios, tejkan kaꞌalinaꞌ lajꞌay axtoqnuꞌ yu kalaqtsꞌinꞌokanaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ex tachun yu katatapayniniyaꞌ ni Jalhachimoꞌonuꞌ Dios, yuꞌuncha katalaqtaxtuyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ex ni Pedro va taylhaꞌal ixchivinti, va naul: —Kintꞌaꞌisraelitas, ox kilaqasmakniu yu klajunau: Ni Dios tamasunin ni Jesús yu machaqaꞌ Nazaret. Xtaqnil ixtapꞌasta para lay kamakal la milakaꞌukxpukꞌan yu lajꞌay axtoqnuꞌ yu jantu matichun lay makay. Chuncha makal ni Dios para kakꞌatsꞌatꞌik ni laqsaval va yucha malaqachal. Uxiknankꞌan ox malaꞌasiyatꞌik ni laqsaval chuncha val. ");
INSERT INTO tptNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chuncha tacha maqancha ni Dios ixnajun kunaꞌ tus chun val. Va maqxtꞌaqnitꞌik ni Jesús la ixtamakakꞌan ni laktuꞌunun lapanakni para kamakxtukmukꞌakal y kamaqnikal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero astan ni Dios majkujuchoqol la ixtapꞌasta tejkan nil. Va malaqtaxtul la ixjamaqanlqajnati y yu lhinin jantu lay kamaqalhajal. ");
INSERT INTO tptNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yu maqancha tsꞌoqlhi ni David yucha lhichiviniy Jesús va inchine najun: Kitꞌin si xaklaqtsꞌin ni ay Jalhachimoꞌonuꞌ Dios yu ixkintꞌatiꞌukxuyal para jantu aqtaun kaktalhanal, ");
INSERT INTO tptNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","xlhiyucha la ijkꞌachan tachun la kelhanuti y la kinkil ay ikmakay ni Dios. Vachuꞌ mas kanil kilakatunaj pero oxamaktaun kakpakxanꞌiyaꞌ ni kajkujchoqoyaꞌ astan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porke uxintꞌi, Dios kꞌatꞌi, jantu kꞌimakꞌauneꞌe taꞌan alin janinin. Jantu naꞌun kapuchꞌil kilakatunaj ni kitꞌin yu kꞌilaksaktꞌa. ");
INSERT INTO tptNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Uxintꞌi kꞌimasunin ni tin yu xtaꞌa jatsukunti. Laqsaval kajkꞌachanaꞌ tejkan kaktꞌataultachaꞌan. Va chuncha tsꞌoqlhi ni David tejkan ixlhichiviniy ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ketꞌalaqaunin, kijnan ox kꞌatsayau ni maqancha nil y maknukal ni kimpaykꞌan David. Mas tus chavaycha lay laqtsꞌinau taꞌan aknuy. ");
INSERT INTO tptNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ni David ixlaqputeꞌey ixchivinti Dios. Dios junil ni laqsaval ni xaqayntaun ixpapanti yu kaminaꞌ maqan yucha va ay jalhachimoꞌonuꞌ Cristo kunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ni David ixtꞌaunkan makꞌatsanika ni kakujchoqoyaꞌ ni Cristo. Naul ni Dios ni laqsaval jantu aqtaun kamakaunaꞌ taꞌan alin janinin, y vachuꞌ jantu kapuchꞌiyaꞌ ixlakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Y yucha va Jesús yu Dios majkujuchoqol y vachu va yuꞌ yu klaqtsꞌiu yu kujchoqol tachun ni kijnankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ex ni Dios ayaj ay makal tejkan mulal la ixlhijakanaj taꞌan vilchal ni yucha. Ex ni Jesús laqaꞌil ni Espíritu Santo chuncha tacha junil ni Dios. Vachuꞌ kintamalaqachanin ni kijnankꞌan. Tachun yu laqtsꞌinatꞌik y yu asmatꞌatꞌik va si la ixtapꞌasta ni Espíritu Santo val. ");
INSERT INTO tptNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ni David yucha jantu kaꞌal laktꞌiyan kun ixlakatunaj mas inchine naul: Ni Jalhachimoꞌonuꞌ Dios junil ni kiJalhachimoꞌonuꞌ Cristo: “Kintꞌatꞌaultꞌachiy la kilhijakanaj” ");
INSERT INTO tptNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","tus tejkan kakmaqalhajaꞌoyaꞌ tachun yu taxkayyan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Xlhiyucha klajunau kakꞌatsꞌatꞌik tachun uxiknankꞌan yu kintꞌaꞌisraelitas untꞌatꞌik. Ni Jesús yu maqnitꞌik laka kurus va yucha yu Dios makal ay Jalhachimoꞌonuꞌ y va yucha ni Cristo yu Dios laksaklhi —naul ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tejkan chuncha taqasmaklhi ni lapanakni ayaj tamaqaninil la ixjalhanutikꞌan. Ex jalhisakmikal ni Pedro kun yu alati yu jamalaqachal ni Jesús: —Ketꞌalaqaunin, ¿tisuncha tsꞌanqay kakmakau chavaycha? ");
INSERT INTO tptNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ex ni Pedro lakjunil: —Kꞌamapꞌaxatꞌik mijatapastakꞌatkꞌan, kꞌapꞌuꞌaqchꞌajꞌautꞌikcha la ixtaqaꞌuti ni Jesucristo para kꞌamalaqmixinikꞌantꞌik mintalaqalhinkꞌan. Ex chuncha kꞌalaꞌaꞌiyapitik ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Maqancha ni Dios naul ni laqsaval kataxtaqniyan ni Espíritu Santo ni uxiknankꞌan kun mesꞌatꞌankꞌan y vachuꞌ kalaqxtaqniyaꞌ tachun ni lapanakni yu kalaksakꞌaꞌ ni Dios kiJalhachimoꞌonukꞌan mas va toꞌoxtaycha kaval. ");
INSERT INTO tptNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chuncha jalaqxaqalal ni Pedro y jalaqxtaqnil alati jatapastakꞌati. Va naul: —Kꞌalaqtꞌaxtꞌutꞌikcha para jantu kalaktꞌapꞌintꞌik ni lapanakni yu jantu ox ixjatsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ex chuncha tachun ni lapanakni yu talhakapuꞌal ixchivinti va taꞌaqchajꞌaul. Y ni anchanu julchan va tus laꞌatꞌutu mil lapanakni talhakapuꞌal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ni yuꞌuncha va si ixtamakay kuenta yu ixtamasuy yu jamalaqachal ni Jesús. Va si chꞌantaun ixtajunita, y si chꞌantaun ixtalaqcheꞌey ni pan yu ixtaꞌuy, y si ixtaskꞌin Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ex chuncha tachun yu alati lapanakni va si ixtatalhananta porke yu jamalaqachal ni Jesús ixtamakay lajꞌay axtoqnuꞌ yu jantu aqtaun ixlaqtsꞌinkan, yu ixmasuy ixtapꞌasta Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tachun yu ixtalhakapuꞌan ni Jesús va chꞌantaun ixtajunita y tachun yu ixtamaqalin va chꞌantaun ixtamakata. ");
INSERT INTO tptNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ixtastꞌay ixtꞌunkꞌan kun yu ixtamaqalin, ixtalalvaqniy siya yuꞌuncha ni tumin tacha yu ixtamaqskꞌiniy qayntamin por qayntamin. ");
INSERT INTO tptNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Taun taun julchan ixtataqxtoꞌa laka ay lakatajtan y la ixchaqakꞌan ixtalatꞌaꞌuy ni pan y ixtalatꞌavajin kun achati y ox chꞌantaun ixtajunita la ixjalhanutikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ay ixtamakay ni Dios y tachun yu alati lapanakni yu jantu ixtalhakapuꞌan ni Jesús va lajqalꞌoxin ixtalhilay. Ni Dios lhilhiy ixlalhavay ni lapanakni yu istsꞌanqay katalaqtaxtul. ");
INSERT INTO tptNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tauncha julchan ni Pedro ali Juan ixtaꞌanta yu ay lakatajtan Jerusalén. Va laꞌatꞌutu putoqoxata ixjunita, yucha va xahora tejkan ixtaskꞌin Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ancha lhilhiy ixtaulay qayntaun lapanaki yu chꞌanlkꞌavil ixjunita yu aqtsꞌiyaj chuncha tsukul. Va ancha ixꞌankan ulaka ni ay lakatajtan la xamatiꞌ yu ixjunkan Kꞌus. Ancha ixjapuskꞌiniy tumin yu ixtatanuyachal lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ex ni anchanu chꞌanlkꞌavil lapanaki tejkan jalaqtsꞌil ni va laycha katatanuchal lakatajtan ni Pedro ali Juan, ex aqtayl jalakskꞌiniy tumin. ");
INSERT INTO tptNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ex ni Pedro ali Juan va aqtayl sniy talaqtsꞌin. Ex ni Pedro junil: —Kilalaqtsꞌiu ni kijnankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ex ni anchanu lapanaki ox jalaqtsꞌil, ixjapakxanꞌiniy kataxtaqnil tumin. ");
INSERT INTO tptNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero ni Pedro va junil: —Ni tumin jantu kaklhitsukul. Pero kakxtaqniyan yu klhitꞌajun. La ixtapꞌasta ni Jesucristo yu machaqaꞌ Nazaret, katꞌaycha y kꞌaltꞌancha. ");
INSERT INTO tptNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ex ni Pedro maqchꞌapal la ixmajkanaj, maqayaul ni lapanaki. Va niman palay junchoqol ixchꞌajaꞌ kun la ixpixtu ixchꞌajaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ex jakꞌiuklnil, va ostayalcha, aqtaylcha jaltanan. Ex laktꞌatanul lakatajtan ni Pedro ali Juan. Ancha aqtayl tapuchoqotsukuy, y vachuꞌ ixjakꞌiuklnin, y ay ixmakay ni Dios kun achati. ");
INSERT INTO tptNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Chuncha tachun ni lapanakni talaqtsꞌil ni ixjaltanan y ixlhikilꞌan ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ixtamispay ni yucha va yu lapanaki yu ixtaulay la xamatiꞌ lakatajtan yu junkan Kꞌus, y ancha ixpuskꞌin tumin. Xlhiyucha tachun ni lapanakni yu talaqtsꞌil tus taun talhilal y tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ni chꞌanlkꞌavil lapanaki yu palay junchoqol jantu ixjalakmakaunputun ni Pedro ali Juan. Tachun ni lapanakni va niman talaqmil ni yuꞌuncha taꞌan ixtayanal la ixlhimaqspaꞌ ni lakatajtan taꞌan xapuchꞌanan Salomón ixjunkan. Va tus vak takꞌatsal. ");
INSERT INTO tptNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tejkan chuncha laqtsꞌil ni Pedro, va lakjunil ni lapanakni: —Kintꞌaꞌisraelitas, ¿valiꞌiycha tus tumpaj lhilayatꞌik yu aniy? ¿Valiꞌiycha sniy kilalaqtsꞌinaucha? Ka va lhilayatꞌik por kintapꞌastkꞌan palay kpumakau ni lapanaki u kavalay pꞌastꞌakꞌatꞌik va por ayaj ox lapanakni kuntau. Pero jantu laqsaval kaval. Yu palay makal va Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Vachu va yuꞌ ixDioskꞌan kimpaykꞌan Abraham ali Isaac ali Jacob ali yu alati kepayankꞌan. Vachu va yuꞌ yu la ay makal ni Jesús yu istsꞌal. Va yucha yu maqxtꞌaqnitꞌik ni lhachimoꞌonun tejkan Pilato ixxꞌoqputun pero uxiknankꞌan jantu katalhipaꞌinin. ");
INSERT INTO tptNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ni uxiknankꞌan jantu katalhipaꞌinin kaxꞌoqkal ni anchanuꞌ ox lapanaki yu jantu kalhitsukul tuꞌuchun talaqalhin, pero uxiknan apalay talhipaꞌinin kataxꞌoqnin qayntaun jamaqniniꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ni Jesús yu xtaꞌa jatsukunti va yucha yu maqnitꞌik pero Dios majkujuchoqol la ixlhinin y kijnankꞌan klaqtsꞌiu ni laqsaval kujchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Va por ixtaqaꞌuti ni Jesús palay junchoqol ni aniy lapanaki yu chavay laqtsꞌinatꞌik y mispꞌayatꞌik. Yucha palay junchoqol porke klhakapuꞌau ni Jesús lay kaꞌaqtayjul. ");
INSERT INTO tptNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ketꞌalaqaunin, kitꞌin kꞌatsay ni uxiknan jantu kꞌamalaꞌasitꞌik yu makꞌatꞌik tejkan maqnitꞌik ni Jesús. Vachuꞌ milhachimoꞌonunkꞌan jantu katamalaqasil. ");
INSERT INTO tptNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Maqancha yu ixtalaqputeꞌey ixchivinti Dios tanaul ni Cristo yu kamalaqachakanaꞌ ayaj kamaqanlqajnanaꞌ. Y chavay laqsaval chuncha tapasal tacha yu ixnajunta Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Xlhiyucha klajunau ni kꞌamapꞌaxatꞌikcha mijatapastakꞌatkꞌan. Kꞌalhakꞌapꞌupꞌintꞌik ni Dios ex yucha kataxakaniyan mintalaqalhinkꞌan. Ex chuncha katamaꞌeltajuniyan yu kꞌamaqskꞌiniyapitik la metsukuntikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ex katamalaqachanichoqoyan ni Jesucristo yu maqancha laksakkal para katamin malaqtaxtunun. ");
INSERT INTO tptNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero chavaycha maqskꞌiniy kataulchal laktꞌiyan tus tejkan Dios kalasastꞌiꞌoyaꞌ tachun yu alin. Chuncha tacha tanaul yu maqancha ixtalaqputeꞌey ixchivinti Dios yu laqsaval ixlapanakni ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ni Moisés inchine lakjunil kepayankꞌan yu maqancha ixtatꞌajun, va naul: “Ni Dios yu miJalhachimoꞌonukꞌan kalaksakꞌaꞌ xaqayntaun mintꞌaꞌisraelitaskꞌan yu katalaqputeꞌeniyan ixchivinti chuncha tacha kitꞌin. Yucha ox kaꞌalasmakniꞌoyapitik tachun yu katajunan. ");
INSERT INTO tptNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tachun ni lapanakni yu jantu kataqalasmakputunaꞌ ni yuꞌuncha kalaqnaqxtꞌukkanaꞌ para jantucha chꞌantaun katatꞌaval kun ixlapanakni Dios,” chuncha naul ni Moisés. ");
INSERT INTO tptNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Vachuꞌ ni Samuel ali tachun yu alati yu ixtalaqputeꞌey ixchivinti Dios maqancha tus chavaycha va si ixtalhichiviniy yu chavaycha tapasay. ");
INSERT INTO tptNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","’Ni xalaqputeꞌenin ixchivinti Dios chuncha tanaul maqancha para laqsaval chuncha kaval ixchivintikꞌan kun uxiknan. Vachuꞌ ni Dios va taun jatapastakꞌati jatꞌatamakaul ni kepayankꞌan tejkan junil inchine ni Abraham: “Tus tachun yu oqxlaqtamin lapanakni yu alin lakamunukpaꞌ, si katalhitsukuyaꞌ ox jatsukunti por qayntaun mimpapanti yu kaꞌalinaꞌ maqan.” ");
INSERT INTO tptNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ni Dios tejkan majkujuchoqol isTsꞌal va uxiknankꞌan yu pꞌunaj tamalaqachanin para kataxtaqnin yu ox jatsukunti y vachuꞌ para kꞌamakꞌauntꞌijlatꞌik mintalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Chuncha vananaj ixtataylhaꞌanta jalaqxaqalanan ni lapanakni tejkan tachil ni xakuras israelitas ali ixꞌukxtinkꞌan policias yu ixtatapatsay lakatajtan ali ni saduceos. ");
INSERT INTO tptNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ayaj ixtalhilukujlhay yu ixlakmalanikan ni lapanakni y vachuꞌ por ixjalakjunkan ni Jesús kujchoqotacha y chuncha takꞌatsalcha ni laqsaval katakujchoqoyaꞌ yu janinin. ");
INSERT INTO tptNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ex chuncha tachꞌapal ni Pedro ali Juan. Nimancha tamanul laka pachꞌin porke toqoxatacha ixjunita y tapakxanil tus katunkuꞌelal. ");
INSERT INTO tptNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero qaynlhuvaj talhakapuꞌal yu taqasmaknil ixchivintikꞌan ni Pedro ali Juan. Ex chuncha por tachun yu ixtalhakapuꞌan ni Jesús laqchaꞌal tus laqakis mil joꞌakna. ");
INSERT INTO tptNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tejkan tunkunchoqolcha ex tataqxtoqlhi ni lhachimoꞌonun ali ni xalajꞌay xapaynin ali yu ixtamasuy ixlhachimoꞌonkꞌan ni israelitas laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Vachuꞌ kun yu ixꞌukxtinkꞌan kuras yu ixjunkan Anás y vachuꞌ Caifás ali Juan ali Alejandro ali yu alati ixjatꞌalaqaunin ni Anás. ");
INSERT INTO tptNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ex ancha jalakꞌulakal la ixlakaꞌukxpukꞌan, va jalaklhisakmikal ni Pedro ali Juan: —¿Taꞌayucha taxtaqnin tapꞌasta y taꞌayucha taxtaqnin lakatin para kamakꞌatꞌik yu makꞌayatꞌik uxiknankꞌan? ");
INSERT INTO tptNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ex ni Espíritu Santo laqtanuꞌol ni Pedro, ex ni yucha jalakjunil: —Uxiknan yu jalhachimoꞌonun untꞌatꞌik, y yu xalajꞌay xapaynin untꞌatꞌik: ");
INSERT INTO tptNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","chavaycha kilalhisakmiyau valiꞌiycha kmakau yu la ox y tas palaycha kpumakachoqoo qayntaun taqanꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Chavaycha knaunau kakꞌatsꞌatꞌik ni uxiknankꞌan y vachuꞌ katakꞌatsal tachun ni israelitas, ni lapanaki yu aniy yal yu palaycha junchoqota va chuncha val por ixtapꞌasta Jesucristo yu machaqaꞌ Nazaret yu uxiknan maqnitꞌik laka kurus pero ni Dios majkujuchoqol. ");
INSERT INTO tptNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uxiknankꞌan untꞌatꞌik va tacha lapanakni yu tamaqayajuy chaqaꞌ. Ni Jesús va tacha taun chiyux yu uxiknankꞌan ixmajꞌantꞌatꞌikcha pero astan val tacha taun chiyux yu xamatau chaqaꞌ, yu apalay pꞌays maqskꞌinikan. ");
INSERT INTO tptNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jantu alin ataun jamalaqtaxtunuꞌ porke ni Dios jantu kintajunin ixtaqaꞌuti aqayntaun para kintamalaqtaxtun, vamun ni Jesús —va naul ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ex yu xalajꞌay xapaynin tus vak takꞌatsal porke ni Pedro ali Juan jantu katatalhanal, mas yuꞌuncha va tsꞌuniy jatalaniti ixtalhitꞌajun y mas valiꞌiy lapanakni ixtajunita. Va chuncha taxtaqnil kuenta ni Pedro ali Juan va ixtatꞌatijuntayay ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Tejkan talaqtsꞌil ni ancha ixlaktꞌayal ni lapanaki yu palaycha ixjunchoqota ex jantu tuꞌuchun laqtaqal lay kamukꞌanikal. ");
INSERT INTO tptNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ex chuncha jalakjunkal katataxtul taun panchꞌix laka pulakchivin y xꞌamankꞌan talakchivinil ni lhachimoꞌonun. ");
INSERT INTO tptNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tanaul: —¿Tas kalakmakayaucha ni aniy lapanakni? Laqsaval tamasul taun ay tuꞌuchun yu jantu aqtaun laqtsꞌinkan. Jantu lay junau ni lapanakni incha jantu laqsaval yu tamakal porke tus takꞌatsaꞌol taꞌakchun yu tavilanal laka putaulan Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero para jantucha apalay kaputaukꞌal yu tacha tamakal, tsꞌanqay kalaklhijuniu laqatapꞌasta ni jantucha apalay katalhichivinil la ixtaqaꞌuti ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ex chuncha tajunchoqol para katatanuchoqolcha ixpulakna ni Pedro ali Juan, y laqatapꞌasta talaktanchanil para jantucha katalaqputeꞌel ixchivinti ni Jesús y jantucha apalay katamasul axtoqnuꞌ kun ixtaqaꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero taqaltayanal ni Pedro ali Juan, tanaul: —¿Tisuncha lhilayatꞌik yu apalay ox kakmakau? ¿Yu kilalhijunau uxiknankꞌan u yu kintalhijunan Dios? ¿Tisuncha yu apalay kalhipaꞌinil Dios? Ancha kalakpꞌastꞌaknantꞌik. ");
INSERT INTO tptNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ni kijnankꞌan jantu lay kmakauntijlayau ixlaqputeꞌeka yu klaqtsꞌiu y yu ijqasmakvi. ");
INSERT INTO tptNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ex ni lhachimoꞌonun laka lhilukuj taxaqalal y jantucha katamanul laka pachꞌin. Jantu lay katamukꞌanil laqtaqal porke tachun ni lapanakni va si ay ixtamakay Dios kun achati por yu tamakal ni Pedro ali Juan. ");
INSERT INTO tptNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ni anu lapanaki yu palay junchoqol la ixtapꞌasta Dios, ni yucha ixlhiꞌoqslaycha cuarenta ixjachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Taval tejkan lakmakaunchoqokalcha ni Pedro ali Juan ex talaqꞌanchoqolcha alati yu ixtalhakapuꞌan Jesús. Ex talaqputeꞌeniꞌochoqol tachun tacha tanaul ni xaꞌukxtinin kuras kun ni lhachimoꞌonun. ");
INSERT INTO tptNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tejkan chuncha taqasmaklhi ex chꞌantaun taꞌaqtayl tatꞌachiviniy ni Dios. Tanaul: —Uxintꞌi Dios yu ay Jalhachimoꞌonuꞌ kꞌatꞌi, uxintꞌi makꞌatꞌi laktꞌiyan, ali lakatꞌun, ali xkan ali tachun axtoqnuꞌ yu alinta. ");
INSERT INTO tptNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Maqancha ni uxintꞌi makꞌatꞌi para kachivinil miꞌoqxtamati David kun ixtapꞌasta miꞌEspíritu Santo, va naul: ¿Valiꞌiycha la talukujlaycha ni lapanakni yu jantu talhakapuꞌan? ¿Valiꞌiycha tapastakꞌacha katamakal yu jantu tuꞌuchun ixtapal kaval? ");
INSERT INTO tptNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ni jalhachimoꞌonun yu alin aniy lakamunukpaꞌ va lakataun tavilanal kun yu xalajꞌay lapanakni y chꞌantaun tataqxtoꞌa para kataxkayl ni Dios kiJalhachimoꞌonukꞌan y vachuꞌ para kataxkayl yu malaqachal. ");
INSERT INTO tptNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Laqsaval aniy Jerusalén tataqxtoqlhi Herodes kun Pilato kun alati yu jantu israelitas kataval kun yu kintꞌaꞌisraelitas tajunita para kataxkayl ni minTsꞌal Jesús yu laksaktꞌi. ");
INSERT INTO tptNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chuncha tamakal tacha yu maqancha uxintꞌi lhichꞌivin la mintapꞌasta katapasayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chavaycha, Jalhachimoꞌonuꞌ kꞌatꞌi, kamakꞌatꞌi kuenta yu ixkintaxaqalayan kun lhilukuj yu jantu kintaꞌuyujjunan kaklhichiviniu mintaqaꞌuti. Kilaxtaqniu tapꞌasta para lay kaklaqputeꞌeu minchivinti y jantu kun talhanti. ");
INSERT INTO tptNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Vachuꞌ kilaxtaqniu ixtapꞌasta minTsꞌal Jesús para lay palay kakmakau taqanꞌanin y para lay kakmakau yu lajꞌay axtoqnuꞌ para katapukꞌatsal ni lapanakni ni laqsaval milapanakni kuntau. ");
INSERT INTO tptNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Chuncha tejkan tatꞌachivinꞌol ni Dios ex aqtayl xkapꞌiknin ni chaqaꞌ. Ex talaqtanuꞌol ni Espíritu Santo la ixjatapastakꞌatikꞌan y taꞌaqtaylcha talaqputeꞌey ixchivinti Dios y jantu kun talhanti. ");
INSERT INTO tptNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ex chuncha tachun yu ixtalhakapuꞌanta ni Jesús va chꞌantaun ixjunita ixjatapastakꞌatikꞌan. Jantu matichun ixnajun va xꞌaman ixnavin yu ixmaqalin. Tachun yu ixtalhitꞌajun va chꞌantaun ixtamakay y va si ixnavinkꞌan ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ex yu jamalaqachal ni Jesús va kun tapꞌasta tataylhaꞌal laqputeꞌenin ni ixkujchoqotacha ni Jalhachimoꞌonuꞌ Jesús. Ayaj ixtalapaxkay la ixjatsukuntikꞌan ");
INSERT INTO tptNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","porke jantu kaꞌalil matichun yu kaval kilpataniꞌ. Yu ixlhitꞌajun ixtꞌun u ixchaqaꞌ va istꞌay y ixlhiminꞌojoy yu xatapal. ");
INSERT INTO tptNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ixtamaqxtaqniy yu jamalaqachal ni Jesús para katalaqlvaqnil yu alati lapanakni chuncha tacha ixtamaqskꞌiniy. ");
INSERT INTO tptNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ixꞌalin qayntaun lapanaki yu machaqaꞌ Chipre va Levita ixjunita. Yucha ixjunkan José pero yu jamalaqachal ni Jesús va talhimapaqaꞌuchoqol va Bernabé, yucha naunputun la ixlhichivinkꞌan va xaqayntaun yu malakaꞌulanan. ");
INSERT INTO tptNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ni anchanu lapanaki stꞌal aqxtaun ixtꞌun, lhimil xatapal, va laqmaqxtaqniꞌol yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Vachuꞌ qayntaun lapanaki yu ixjunkan Ananías kun ixanati Safira tastꞌal aqxtaun ixtꞌunkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ni anchanu lapanaki jantu kaxtaqꞌol xatumin, pero tejkan lhaꞌanil yu jamalaqachal ni Jesús ex makakal tacha kaxtaqniꞌol tachun xatapal. Yu ixanati ox ixkꞌatsay tacha makal ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ex ni Pedro junil ni Ananías: —¿Valiꞌiycha xtꞌaqnincha lakatin ni Satanás katanul la mijatapastakꞌati? Uxintꞌi ixmakꞌanupꞌutꞌun ni Espíritu Santo porke chꞌapamatꞌi lati xatapal mintꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tejkan jantukaꞌ istꞌay ni mintꞌun va minavin ixjunita. Mas tejkan stꞌatꞌicha vananaj minavin ixjunita xatumin. ¿Ex valiꞌiycha pꞌastꞌaktꞌi chuncha kamakꞌatꞌi? Uxintꞌi jantu ixjamakꞌanupꞌutꞌun yu valiꞌiy lapanakni, va Dios yu ixmakꞌanupꞌutꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tejkan chuncha qasmaklhi ni Ananías ex nimancha tꞌuluj taqtalcha, va nilcha. Tachun ni lapanakni yu takꞌatsal va ayaj tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ex ancha ixtayanal lati yu tsꞌalankaꞌ, va tapachꞌinil ixlakatunaj ni Ananías y taꞌalcha maknunun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Chuncha tejkan laꞌatꞌutu hora val ex vachuꞌ tanuchal ancha ixanati ni Ananías y jantu ixkꞌatsay yu tapasal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ex ni Pedro lhisakmil: —Kiꞌun incha laqsaval va chuncha xtapal lhistꞌatꞌik ni mintꞌunkꞌan. Ex yu xanati va naul: —Chun, va chuncha xtapal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ex ni Pedro junil: —¿Valiꞌiycha chꞌantauncha untꞌik para kalaqtsꞌintꞌanutꞌik IxꞌEspíritu Santo ni Jalhachimoꞌonuꞌ Dios? Laka matiꞌicha taminchoqota yu takimaknul mixapay. Chavaycha uxintꞌi vachuꞌ kataꞌanan maknunun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ex chuncha ni xanati va nimancha tꞌuluj taqtal taꞌan ixchꞌatay ni Pedro, ex nilcha. Tejkan tatanuchoqolcha ni tsꞌalan la ixpulakna ni laqa chaqaꞌ, tatemal ni xanati taꞌan ixnimal. Ex vachuꞌ tamaxtulcha y talhaꞌalcha maknunun taꞌan ixꞌaknuy ixapay. ");
INSERT INTO tptNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ex chuncha tachun yu ixtalhakapuꞌan ni Jesús kun tachun alati yu taqasmaklhi va ayaj tatalhanal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yu jamalaqachal ni Jesús ixtamakay lajꞌay axtoqnuꞌ y chuncha ox ixtasuy ixtapꞌasta ni Dios. Si ixtataqxtoꞌa ixlhimaqspaꞌ ni ay lakatajtan taꞌan ixjunkan ixjapuchꞌanan Salomón. ");
INSERT INTO tptNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pero yu alati lapanakni jantu ixtatapujuy katataqxtoqlhi chꞌantaun kun yuꞌuncha mas ox ixtatoꞌoyay por ixlhakapuꞌatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ex chuncha lhilhiy ixtalhavay ni lapanakni yu ixtalhakapuꞌan ni Jalhachimoꞌonuꞌ Jesús, mas joꞌakna kun xanatin. ");
INSERT INTO tptNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tus ixtamaxtuy ni taqanꞌanin lakatinixnan ixtamamay laka putaman para katatapasanil mas va ixmaqtsꞌansilaqa ni Pedro tejkan katapasal lakatin para palaycha katajunchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Vachuꞌ ixtaminachal lhuu lapanakni yu machaqan alati putaulanaxna ixlhiꞌukstsꞌuniy Jerusalén. Ixtalhimin taqanꞌanin kun lapanakni yu ixtachꞌapata jantu ox espíritus. Tus tachun palay ixtajunchoqoy. ");
INSERT INTO tptNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ex chuncha ayaj akchaꞌal ni xaꞌukxtin kura kun tachun ixtꞌaltanan yu saduceos ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Talhinaul kalakchꞌapakal yu jamalaqachal ni Jesús, ex nimancha lakmanukal laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero tejkan tsꞌis ixjunita, ex qayntaun ixmayul Dios kimalaqltiꞌachil la xamatiꞌ ni pachꞌin, ex jalakmaxtul y jalakjunil: ");
INSERT INTO tptNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Kꞌapꞌinchꞌoꞌotꞌikcha taꞌan ay lakatajtan. Kalaqpꞌutꞌeꞌeniꞌotꞌik ni lapanakni tachun ni chivinti yu lhichiviniy ni sastꞌi jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ex chuncha tejkan ixtunkumintacha tatanuchoqolcha lakatajtan, taꞌaqtayl tamasuy yu ox chivinti tacha jalakjunkal. Ni ixꞌukxtinkꞌan kuras kun ixtꞌaltanan talhinaul katamakal taun ay taqxtoꞌati y va tamaqxtoqlhi kun tachun ixlhachimoꞌonunkꞌan ni israelitas. Talhinaul ixjaꞌikakꞌan yu jamalaqachal ni Jesús yu ixtatanumanal laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero tejkan tachaꞌal ni policias laka pachꞌin jantucha katatemal. Ex taꞌanchoqol juninin ixꞌukxtinkꞌan, ");
INSERT INTO tptNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","va tanaul: —Tejkan kchaꞌau laka pachꞌin ox ixlakchajuy la xamatiꞌ. Y yu jalhistaknan ancha ixtayananꞌol la xakiltalakxtuti. Pero tejkan kmalaqltiꞌau, jantu matichun ixtanun ixpulakna. ");
INSERT INTO tptNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tejkan chuncha takꞌatsal ni ixꞌukxtinkꞌan kuras kun yu ixꞌukxtinkꞌan xapolicias lakatajtan kun yu xalajꞌay kuras va tus taun talhilal y va aqtayl talakpastaknan tisuncha tapasalcha. ");
INSERT INTO tptNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ex chil aqayntaun lapanaki yu naul: —Ni lapanakni yu ixjalakmanutꞌatꞌik laka pachꞌin, yuꞌuncha tayananchal lakatajtan, tatꞌajun lakmasuninin lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ex ni ixꞌukxtinkꞌan xapolicias lakatajtan jalaklhaꞌal ixpolicias y talhiminchoqol yu jamalaqachal ni Jesús. Jantu laqatapꞌasta katalhimil porke ixtatalhauniy yu alati lapanakni, va lay kalaklakatꞌalmakal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tejkan laklhiminkal, laqmaqayaukal la ixlakaꞌukxpukꞌan ixꞌukxtinkꞌan ni kuras. Va tajunil: ");
INSERT INTO tptNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Kijnan laqatapꞌasta klalhichimoꞌoo para jantucha kꞌalhixaꞌalatꞌik ni lapanakni la ixtaqaꞌuti ni anu lapanaki. Pero chavaycha jamalaniꞌotꞌatꞌikcha tachun xalapanakni aniy Jerusalén y vachuꞌ kilamukꞌaniputunau laqtaqal ixmaqnika anu lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Chuncha ni Pedro kun alati yu jamalaqachal ni Jesús taqaltayanal y tanaul: —Kijnan apalay maqskꞌiniy kakmakau yu lhinajun Dios y jantu yu talhinajun lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ni ixDioskꞌan yu maqaniyaꞌ kepayankꞌan yucha majkujuchoqol ni Jesús yu uxiknankꞌan maqnitꞌik tejkan makxtꞌukmukꞌatꞌik laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero ni Dios kun ixtapꞌasta la ay makal y mulal la ixlhijakanaj para kalhachimoꞌonul y kamalaqtaxtul lapanakni y chuncha katamapaxal ixjatapastakꞌatkꞌan ni kintꞌaꞌisraelitaskꞌan y kalaqmalaqmixinikal ixtalaqalhinkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ni kijnankꞌan ox klhitaulau ni laqsaval chuncha tapasal. Y yu Espíritu Santo vachuꞌ ox lhitaulay ni va chuncha val. Yucha va yu laqxtaqnil Dios tachun ni lapanakni yu tamakay tacha lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ex ni lhachimoꞌonun tejkan chuncha taqasmaklhi va ayaj talukujlal tus ixtamaqniputun yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ancha chꞌantaun kun yu alati jalhachimoꞌonun ixyal qayntaun fariseo yu ixjunkan Gamaliel. Yucha ixjamalaninin ixlhachimoꞌonkꞌan ni israelitas y tachun ni lapanakni si ixtatoꞌoyay. Yucha lhinaul kalakmaxtukal maqspaꞌ yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ex lakjunil ni ixtꞌalhachimoꞌonun: —Kintꞌaꞌisraelitas, chuncha tacha lakmakꞌanipꞌutꞌunatꞌik ni aniy lapanakni, kitꞌin klajunau kꞌalhistꞌajkꞌantꞌikcha kun yuꞌuncha. ");
INSERT INTO tptNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Kapꞌastꞌaktꞌik ni jantukaꞌ maqan ostaulal qayntaun lapanaki yu ixjunkan Teudas. Yucha ixjunputun ay jalhachimoꞌonuꞌ y yu ixlapanakni va tacha laꞌatꞌati ciento ixtajunita. Pero taval maqnikal y tachun yu ixtꞌaltanan valiꞌiy tꞌikl taputaukꞌaꞌol. Ex ancha tamaktalcha, jantucha tuꞌuchun katataylhaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Astan vachuꞌ ixꞌalin qayntaun yu ixjunkan Judas yu machaqaꞌ Galilea. Yucha ostaulal tejkan ixtꞌaunkan laqtsꞌoqolaka ni lapanakni. Ex yucha lakmakanul lhuu lapanakni para chꞌantaun katatꞌaval. Pero yucha vachuꞌ maqnikal y tachun yu ixtꞌaltanan valiꞌiy tꞌikl taputaukꞌaꞌol. ");
INSERT INTO tptNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Xlhiyucha klajunau kꞌalakmakꞌauntꞌikcha ni aniy lapanakni. Yu tamakay ni yuꞌuncha jantu katataylhaaniyaꞌ incha valiꞌiy lapanaki yu lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero incha va Dios lhinajun yu tamakay ni yuꞌuncha, ex uxiknankꞌan jantu lay kꞌalaktꞌanchꞌaniyapitik porke ex laqsaval va kun Dios kꞌalachꞌapꞌayapitik —naul ni Gamaliel. ");
INSERT INTO tptNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ex chuncha yu ixtꞌalhachimoꞌonun talhipaꞌinil tacha naul. Ex tamalaqachanal ixjalakꞌika yu malaqachal ni Jesús y talhinaul ixjalaqmaqanaqka. Jalaktanchanikal ni jantucha katalhichivinil ni Jesús. Chuncha astan jalaqxtaqnil lakatin para kataꞌanchoqolcha. ");
INSERT INTO tptNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pero ni yuꞌuncha tejkan jalakmakaunkalcha kataꞌanchoqol va apalay talhiꞌachantajul mas ixtalamaqanlqajnan porke ni Dios jalaksaklhi para kalhilaktuꞌukal por ixtalhakapuꞌan ixtaqaꞌuti ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ex taun taun julchan ixtalaqputeꞌey taꞌan ay lakatajtan y vachuꞌ laqa chaqan. Jantu ixtastaknan ixmasuka ni Jesús va Cristo yu ixnajun kamalaqachayaꞌ Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chuncha ni anchanu julchan ixtatalhavay ni lapanakni yu ixtalhakapuꞌan ni Jesús. Ex lati yu ixtachiviniy griego taꞌaqtaylcha tachivintanuniy yu ixtachiviniy hebreo por ni xanatin yu tiyaunin. Ixtanajun jantu qayntsay yu lhilhiy ixjalaqlvaqnikan ixlhiꞌutikꞌan yu ixtꞌamachivinkꞌan griego y yu hebreos chun. ");
INSERT INTO tptNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ex yu pumakautꞌuy yu jamalaqachal ni Jesús tamaqxtoqꞌol tachun yu ixtalhakapuꞌan, va tajunil: —Kijnan jantu maqskꞌiniy kakmakajuu ixlaqputeꞌeka ixchivinti Dios para kaklatsukuu laqlvaqninin milhiꞌutikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Xlhiyucha klajunau, ketꞌalaqaunin, kalaksaktꞌik pumatujun lapanakni siya uxiknan yu ox jalaktoꞌoyakan y yu talaqtanuꞌojota ni Espíritu Santo la ixjatsukuntikꞌan y vachuꞌ yu lhuu jatapastakꞌati talhitꞌajun. Va yuꞌuncha katataylhaꞌal makanan ni aniy lhitapatsa. ");
INSERT INTO tptNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pero ni kijnankꞌan kaktaylhaꞌanau skꞌinin ni Dios y vachuꞌ kaktaylhaꞌanau laqputeꞌenin ixchivinti —chuncha tanaul yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ex ni lapanakni tachun talhipaꞌinil yu tanaul. Ex talaksaklhi Esteban yu ox ixlhakapuꞌan, yu ixlaqtanuꞌojota ni Espíritu Santo. Vachuꞌ talaksaklhi Felipe, ali Prókoro, ali Nikanor, ali Timón, ali Parmenas y vachuꞌ Nicolás yu machaqaꞌ Antiokía. Yucha jantu israelita ixjunita pero tejkan jantukaꞌ ixlhakapuꞌan Jesús, ixlhakapuꞌanta Dios vachu chun tacha yu israelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ex ni yu jalaksakkal jalaklhaꞌankal taꞌan ixtayanal yu jamalaqachal ni Jesús. Yuꞌuncha taskꞌinil Dios y tamoqslanil ixmakakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ex chuncha apalay maqati ixputaukꞌay ixchivinti Dios y apalay qaynlhuu ixtalhakapuꞌan ni Jesús xalakaputaulan Jerusalén. Vachuꞌ qaynlhuvaj xakuras ni israelitas talhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ni Dios ox ixꞌaqtayjuy ni Esteban y ixtaqniy lhuu ixtapꞌasta. Va yucha ixpumakay lajꞌay axtoqnuꞌ yu lay katapalakpastaknal ni lapanakni y vachuꞌ ixmasuy yu jantu aqtaun ixlaqtsꞌinkan. ");
INSERT INTO tptNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ancha ixꞌalin lapanakni yu taminchal taꞌan ixtataqxtoꞌa israelitas yu ixlakjunkan Oqxtamatin yu Tamakauntijlal Ixꞌukxtinkꞌan. Vachuꞌ ixꞌalin lati yu machaqan Cirene ixtajunita y lati yu machaqan Alejandría, ali lati yu machaqan xalakatꞌun Cilicia vachuꞌ kun yu machaqan xalakatꞌun Asia. Ixtachunkꞌan va si talhilakchivinil ixlhakapuꞌati ni Esteban. ");
INSERT INTO tptNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero yuꞌuncha jantu aqtaun lay katamaqalhajal ni Esteban por ixjatapastakꞌati yu ixtaqnil ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ex chuncha lakmapalkal lapanakni para katamanul jalaklkanti. Xlhiyucha tanaul: —Kijnan ijqalasmakvi ni Esteban kiltaxtul laqxtoqnu chivinti, va lhichivinil Moisés kun Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ex chuncha talapumalukuklal tachun ni lapanakni kun yu xalakꞌay lapanakni israelitas kun yu ixtamalaninin ixlhachimoꞌonkꞌan. Va talaqꞌal ni Esteban y tachꞌapal, talhaꞌal taꞌan ixtamakay junta yu xalajꞌaynin. ");
INSERT INTO tptNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Vachuꞌ talakxkaul lati lapanakni para katamanul jalaklkanti, ex vachuꞌ tanaul: —Yu aniy lapanaki jantu aqtaun ox lhichiviniy yu ay kilakatajtankꞌan kun kilhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kijnan klajqasmakniu ni yucha najun ni Jesús yu machaqaꞌ Nazaret kamaqtayaꞌ yu ay kilakatajtankꞌan. Vachuꞌ najun ni Jesús kamapaxayaꞌ kilhachimoꞌonkꞌan yu la maqancha kintamakaunin Moisés. ");
INSERT INTO tptNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ex tachun yu ancha ixtavilanal tus sniy ixtalaqapulaqtsꞌin la ixꞌukxpuꞌ ni Esteban, va ixtasuy tacha ixꞌukxpuꞌ qayntaun ixmayul Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ni yu xaꞌukxtin kura lhisakmil ni Esteban, va junil: —¿Laqsaval yu tanajun? ");
INSERT INTO tptNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ex va naul ni Esteban: —Ketꞌalaqaunin ali kepayan yu xapaynincha untꞌatꞌik, ox kilaqasmakniu kinchivinti. Maqancha ni ay Dios tasunil ni kimpaykꞌan Abraham. Tasunil tejkan vananaj ixvilchal xalakatꞌun Mesopotamia tejkan jantukaꞌ ixꞌan laka putaulan Harán. ");
INSERT INTO tptNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ni Dios junil ni Abraham: “Katꞌaxtꞌucha la mintꞌun, kꞌalakmakꞌaucha lati milapanakni yu mintꞌamachaqan. Kapiticha lakatꞌun taꞌan kakmasuniyan.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ex ni Abraham taxtuchalcha la ixlakatꞌunkꞌan ni Kaldeos, va alcha tus laka putaulan Harán. Ex ancha nichal ixpay. Ex chuncha ni Dios malaqachal ni Abraham tus taꞌan chavaycha vilanantꞌik uxiknankꞌan aniy lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ni Dios jantu kamaqxtaqnil ni aniy lakatꞌun para kaval ixnavin, mas va tsꞌuniy mas va taꞌan lay katachꞌatal la ixchꞌajaꞌ. Pero ni Dios tꞌatamakaul chꞌantaun ni Abraham ni kaxtaqniyaꞌ ni lakatꞌun astan tejkan katatsukuyaꞌ ixpapanakna, mas jantukaꞌ ixꞌalin xaqayntaun sasꞌatꞌa. ");
INSERT INTO tptNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Vachuꞌ ni Dios junil ni Abraham: “Ni mepapanakna yu katatsukuyaꞌ maqan, kataꞌanaꞌ jatsukunun alakataun lakatꞌun, katajunaꞌ tacha jachinin. Ancha kalakmakakanaꞌ oqxtamatin y ox kalaqlhimaqchapukanaꞌ tus katapasayaꞌ laꞌatꞌati ciento jachꞌitin.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Vachuꞌ naul ni Dios: “Pero kitꞌin kaklakmukꞌaniyaꞌ ixmaqanlqajnatikꞌan yu ixꞌukxtinkꞌan yu kalaklhichimoꞌoyaꞌ, y katamajkꞌatsayaꞌ. Ex ancha katataxtuchoqoyacha mepapanakna y kataminacha aniy lakatꞌun y kintatoꞌoyayaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ni Dios va taun jatapastakꞌati tꞌatamakaul ni Abraham, va junil: “Kaxvililichꞌukꞌupꞌuxnikꞌaneꞌe mextaꞌa y chuncha kun tachun mintsꞌalan.” Ex xlhiyucha tejkan tsukul istsꞌal ni Abraham yu ixjunkan Isaac, vachuꞌ xvililichukꞌupꞌuxnil xaxtaꞌa tejkan laqchaꞌal laqatsajin julchan. Vachuꞌ Isaac vachu chun makanil istsꞌal yu ixjunkan Jacob y yu Jacob vachu chun makanil yu pumakautꞌuy istsꞌalan. Yuꞌuncha yu kepayankꞌan yu maqancha ixtatꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ex ni yuꞌuncha taꞌakchaꞌanil ixpꞌisaqakꞌan yu José ixjunkan. Xlhiyucha tachꞌapal y tastꞌal para kalhaꞌankal alakataun tꞌun yu ixjunkan Egipto. Pero ni Dios ixlhistakꞌa ni José ");
INSERT INTO tptNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","y maxtul taꞌan ixmaqanlqajnan. Va aqtayjul, va xtaqnil lhuu jatapastakꞌati y chuncha makal para kalhipaꞌinil ni Faraón yu ay jalhachimoꞌonuꞌ Egipto. Ni Dios vachuꞌ makal para kaval lhachimoꞌonuꞌ ancha xalakatꞌun Egipto ni José y chuncha makal xaꞌukxtin tachun yu ixtatapatsay la ixchaqaꞌ Faraón. ");
INSERT INTO tptNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ex ancha Egipto alil ay chavan kun lhuu maqanlqajnati y vachuꞌ xalakatꞌun Canaán. Yu kepayankꞌan jantu ixtatemay ixvaytikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero tejkan kꞌatsal ni Jacob vananaj ixꞌalin lhiꞌuti ancha Egipto ex pꞌunaj laqmalaqachaꞌelal istsꞌalan y yuꞌuncha takiꞌil. ");
INSERT INTO tptNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ex aqtaun taꞌanchoqol inin lhiꞌuti. Ex ni José jalakjunil ni va ixtꞌalaqajunkꞌan ixjunita ni yuꞌuncha. Ex chuncha ni Faraón lakmispal ixlapanakni ni José. ");
INSERT INTO tptNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ex ni José jalaqmalaqachal ixtꞌalaqaunin kataꞌal juntaꞌinin ixpaykꞌan kun tachun ixlapanaknikꞌan. Ex chuncha yuꞌuncha va setenta y cinco lapanakni ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ex chuncha ni Jacob alcha jatsukunuꞌ xalakatꞌun Egipto. Ancha nichal y vachuꞌ taniꞌochal ni kepayankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Taval laklhaꞌanꞌochoqokal ixjalukutkꞌan laka putaulan Sikem. Ancha tataknul taꞌan puqapaj talpa taꞌan il Abraham, va yu tastꞌanil istsꞌalan Hamor yu machaqan Sikem. ");
INSERT INTO tptNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Chuncha tejkan maqancha val, yu ixpapanakna ni Abraham va ayaj ixtatalhavatacha ancha xalakatꞌun Egipto y valaycha ixlaqchaꞌal ni julchan tejkan ni Dios istsꞌanqay kamakal tacha junil ni Abraham. ");
INSERT INTO tptNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ex aqtaylcha lhachimoꞌonun aqayntaun yu jantu ixmispay ni José. ");
INSERT INTO tptNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ni anchanu lhachimoꞌonuꞌ jalakmakanul kilapanaknikꞌan y vachuꞌ jalaqlhimaqchapul. Laqatapꞌasta laklhijunil para kataꞌal tanqalhunun sasꞌatꞌankꞌan ni israelitas yu talhitsukuykaꞌ para katanilcha. ");
INSERT INTO tptNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chuncha tejkan chuncha ixjunita, exnicha tsukul ni Moisés y yu Dios lhiꞌachantajul por tsukul ni Moisés. Laꞌatꞌutu malkuyuꞌ tamaꞌayal la ixchaqaꞌ ixpay kun ixnati. ");
INSERT INTO tptNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ex taval tejkan tamakaulcha ni anchanu tsꞌal, ex istsiꞌi ni Faraón va temal, va maꞌayal tacha istsꞌal kaval. ");
INSERT INTO tptNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ex chuncha tamalanil tachun ixjatalanitkꞌan ni lapanakni yu ancha machaqan Egipto. La laqapꞌasni val y lhuu jatalaniti lhitsukul. ");
INSERT INTO tptNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Tejkan lhitsukulcha cuarenta ixjachꞌitin ex ni Moisés pastaklhi kalaqlaqꞌal ixtꞌaꞌisraelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ex va chuncha al y va laqtsꞌil qayntaun machaqaꞌ Egipto ixtꞌajun lhimaqchapunuꞌ qayntaun ixtꞌaꞌisraelita ni Moisés. Ex niman aqanixtul, va maqnil yu machaqaꞌ Egipto. ");
INSERT INTO tptNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ni Moisés ixlhilay ixtakꞌatsaycha ni ixtꞌaꞌisraelitas ni va Dios ixmalaqachata para kalaqmalaqtaxtul pero yuꞌuncha jantu ixtakꞌatsay. ");
INSERT INTO tptNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ex yu ataun julchan val ni Moisés aaqtaun jalaqpaxtoqchoqol pumatꞌuy ixtꞌaꞌisraelitas. Ni yuꞌuncha ixtatꞌajun lasanin. Chuncha ni Moisés va ixjalaqlvaqputun, va naul: “Ketꞌalaqaunin, uxiknankꞌan va tꞌalaqaunin untꞌatꞌik. ¿Valiꞌiycha lalhimaqchꞌapꞌuyatꞌikcha?” ");
INSERT INTO tptNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ex yu ixtꞌajun lhimaqchapunuꞌ ixlaqaj va niman samajꞌal ni Moisés, va naul: “¿Taꞌayucha lakꞌulatan uxintꞌi para kilalhichimoꞌoo?” ");
INSERT INTO tptNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Vachuꞌ lhisakmikal: “¿Vachuꞌ kꞌimaqnipꞌutꞌun chuncha tacha yu kutancha maqnitꞌi qayntaun lapanaki yu machaqaꞌ Egipto?” ");
INSERT INTO tptNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ex tejkan chuncha qasmaklhi ni Moisés, va limancha makaul y jaqosnulcha, alcha alakataun putaulan yu junkan Madián. Ancha tsukuchalcha taꞌan jantu machaqaꞌ kaval y vachuꞌ lhitsukuchal pumatꞌuy istsꞌalan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Tejkan laqchaꞌalcha cuarenta jachꞌitin, tasunikal lakakꞌavinan taꞌan ixlhiꞌukstsꞌuniy yu ay aspajun yu junkan Sinaí, ancha tasunil qayntaun ixmayul Dios laka jikmi yu ixmaqtajita va qaltaun yu ay javan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ex chuncha ni Moisés tus vak kꞌatsal por yu laqtsꞌil. Tejkan ixtalakanuputun para apalay ox kalaqtsꞌil ex va qasmaklhi ixchivinti ni Jalhachimoꞌonuꞌ Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Yucha va naul: “Kitꞌin va yu ixDioskꞌan kunita ni Abraham ali Isaac ali Jacob.” Ex ni Moisés tus aqtayl jaxkapꞌiknin ixtalhanti, ex jantucha apalay ixlaqtsꞌinputun. ");
INSERT INTO tptNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ex naul ni Jalhachimoꞌonuꞌ Dios: “Kintꞌoꞌoyatꞌi ni kitꞌin, kachꞌantꞌaxtꞌucha ni mivarachi. Aniy lakatꞌun taꞌan chꞌintꞌatꞌa ancha kꞌalinta ni kitꞌin. ");
INSERT INTO tptNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Kitꞌin klaqtsꞌinta ixmaqanlqajnatikꞌan kilapanakni yu tavilanal Egipto y vachuꞌ klajqasmakniy ixqalhutikꞌan. Va yucha klhilaqmintan para kajkamalaqtaxtul. Ex chavay, katꞌatꞌicha. Kitꞌin kakmalaqachayan para kapiti Egipto.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Ni anchanu Moisés vachu va yuꞌ yu jantu ixtaꞌachaniy ni ixtꞌaꞌisraelitas por tajunil yu najun inchine: “¿Tasꞌayucha lakꞌulatan para kilalhichimoꞌoo?” Yucha va Dios ixmalaqachata para kalhachimoꞌonul y kamalaqtaxtul ixlapanakni, por ixmayul Dios yu tasunil laka ay javan va yucha lhijunil. ");
INSERT INTO tptNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ni Moisés va yucha yu jamaqaxtul ni kepayankꞌan taꞌan xalakatꞌun Egipto. Va si ixmakay lajꞌay axtoqnuꞌ kun ixtapꞌasta Dios, mas va ancha Egipto y vachuꞌ lakamar yu ixlhitapaqaꞌuy Xlapul y vachuꞌ ali lakakꞌavinan taꞌan ixtatiꞌukxuntayay tus cuarenta jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ni anchanuꞌ Moisés va yucha yu lakjunil ni ixtꞌaꞌisraelitas, yu naul inchine: “Ni Dios katamalaqachaniyan aqayntaun lapanaki yu kalaqputeꞌeyaꞌ ixchivinti. Kamalaqachayaꞌ qayntaun mintꞌaꞌisraelitakꞌan vachu chun tacha kimalaqachal ni kitꞌin.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisés va yucha yu chꞌantaun ixjatꞌatijuyal ixlapanakni Dios lakakꞌavinan y va yucha yu tꞌachivinil ixmayul ni Dios laka aspajun yu junkan Sinaí. Ex astan jalaqputeꞌenichoqol kepayankꞌan ixchivinti Dios yu xtaꞌa jatsukunti. Ex yuꞌuncha vachuꞌ kintamapasanin kijnankꞌan anchanu chivinti. ");
INSERT INTO tptNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero yu kepayankꞌan yu maqancha ixtatꞌajun jantu ixtaqalasmakputun ni Moisés, va ixtakiltsꞌakꞌastukꞌa, va ayaj ixtaꞌuxaꞌanchoqoy xalakatꞌun Egipto. ");
INSERT INTO tptNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tejkan ixjukꞌachal ni Moisés laka aspajun ex tajunil ni Aarón: “Kilamakaniu kidioskꞌan para yucha kintamapꞌulnin lakatin. Jantu lhikꞌatsan tisuncha xatapasay ni anchanu Moisés yu kintamaxtuchaꞌan xalakatꞌun Egipto.” ");
INSERT INTO tptNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ex chuncha tamakal laqataun ixdioskꞌan, va ixtasuy tacha laqataun sasꞌatꞌa vakax. Ex tamaqnil lhuu talhitsukukna para katamoqslanil ixdioskꞌan y tamakꞌatanil por tamakal yuꞌuncha la ixmakakꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Xlhiyucha ni Dios jalajqosmajꞌalcha y jalakmakauntijlalcha para katatoꞌoyal ni jastꞌakun kun julchan kun malkuyuꞌ. Chuncha tsꞌoqkanta la ixjalhikikꞌan yu maqancha ixtalaqputeꞌey ixchivinti Dios. Ancha tsꞌoqꞌulakanta yu naul ni Dios: Uxiknan yu israelitas untꞌatꞌik, tejkan ixꞌukxuyanantꞌik cuarenta jachꞌitin lakakꞌavinan, jantu kilamaqniniu mintalhitsukutkꞌan y jantu kilamoqslaniu laka altar. ");
INSERT INTO tptNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Va chꞌixlhipꞌintꞌik kun chux xachaqaꞌ midioskꞌan yu junkan Molok. Vachuꞌ lhipꞌintꞌik ni xajastꞌaku yu ixtasuy tacha midioskꞌan yu junkan Refán. Va uxiknan lakmakꞌatꞌik para katꞌoꞌoyatꞌik. Va por yucha kaklamaxtuyau la mintꞌunkꞌan. Kaklalhaꞌanau taꞌan apalay maqati, tus xlhiꞌavintꞌi xalakatꞌun Babilonia. ");
INSERT INTO tptNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Tejkan vananaj ixtatiꞌukxuyanal ni kepayankꞌan maqancha lakakꞌavinan, ixtalhitꞌajun ixlakatajtankꞌan yu ixtalhipaqay laqchꞌiti. Ancha ixlakmaꞌakan ni chiyux taꞌan tsꞌoqmukꞌakanta ixlhachimoꞌon Dios. Ni anu lakatajtan ixmakakanta tacha ixlhijunkanta Moisés, vachu chun tacha masunil ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ex astan jamapasanikal kepayankꞌan ni anu lakatajtan yu ixtalhipaqay laqchꞌiti. Yuꞌuncha chꞌantaun kun Josué yu ixlhachimoꞌonukꞌan va talhimil anchanu lakatajtan tejkan talhajal ni aniy tꞌun taꞌan Dios jalaqnaqxtul yu jantu israelitas ixtajunita. Ex chuncha va si ixtalamapasalhaaniy ni anu lakatajtan tus tejkan aqtayl lhachimoꞌonun ni David. ");
INSERT INTO tptNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ni David ox ixtiꞌukxuyal chꞌantaun kun Dios. Pero tejkan skꞌinil Dios para kamakanil taun ay lakatajtan ixtꞌaꞌisraelitas ex ni Dios jantu kaꞌuyujunil. ");
INSERT INTO tptNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero yu istsꞌal David yu ixjunkan Salomón va yucha makal ni ay lakatajtan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero ni Dios yu vilchal laktꞌiyan yucha jantu taulay taꞌan maqayaukan laka makaꞌ. Chuncha tacha tanaul ni lapanakni yu maqancha ixtalaqputeꞌey ixchivinti Dios yu tanaul: ");
INSERT INTO tptNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Yu laktꞌiyan ancha la kimpalhachimoꞌon taꞌan kvil ni kitꞌin, yu lakamunukpaꞌ ancha vamun kinchꞌajaꞌ kmastakniy. ¿Tas laycha kilamakaniu chaqaꞌ para lay ancha kakstaknal? ");
INSERT INTO tptNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tachun yu alin va kitꞌin kmakaꞌol, naul ni Dios —va chuncha puteꞌeꞌol ni Esteban. ");
INSERT INTO tptNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ex chuncha ni Esteban taylhaꞌal jalaqxaqalanaꞌ ni lajꞌay lapanakni: —Klajunau ni uxiknankꞌan va la pꞌays makꞌayatꞌik melhanutkꞌan. Jantu lhakꞌapꞌupꞌinatꞌik Dios y jantu asmakpꞌutꞌunatꞌik ixchivinti. Untꞌatꞌik tacha yu talaktuꞌunun lapanakni. Jantu aqtaun alasmakpꞌutꞌunatꞌik ni Espíritu Santo. Vachu chun untꞌatꞌik tacha ixtajunita mepayankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","’Yuꞌuncha talaqlhimaqchapul tachun ni lapanakni yu maqancha ixtalaqputeꞌey ixchivinti Dios. Vachuꞌ tamaqnil ni lapanakni yu ixtanajun kaminaꞌ aqayntaun yu lhitꞌajun ox vas jatsukunti. Chavaycha por melaktuꞌuntikꞌan maqxtꞌaqtꞌik y maqnitꞌik ni anchanuꞌ lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mas uxiknankꞌan xtꞌaqnikꞌantꞌik ixlhachimoꞌon Dios yu tamaqxtaqnin ixmayulnin pero jantu makꞌayatꞌik tacha lhinajun —naul ni Esteban. ");
INSERT INTO tptNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Tejkan chuncha taqasmaklhi yu ancha ixtavilanal va ayaj tatalqamal, tus taꞌaqtayl talaktsakꞌay ixtatsalatikꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ni Esteban yucha tus ixlaqtanuꞌojota ni Espíritu Santo, y tus sniy talaqstꞌal laktꞌiyan. Va laqtsꞌil ixꞌoxixtu ni Dios y vachuꞌ laqtsꞌil ni Jesús yu ixyal la ixlhijakanaj Dios taꞌan alin ixtapꞌasta. ");
INSERT INTO tptNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ex va naul ni Esteban: —¡Kꞌalaqtsꞌintꞌik ni uxiknankꞌan! Ni kitꞌin chavaycha klaqtsꞌinta ni laktꞌiyan laqltiꞌay y ancha yachal ni Sasꞌatꞌa Lapanaki taꞌan la ixlhijakanaj Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ex tachun ni lajꞌay lapanakni si pꞌays talaktꞌasal y laqꞌaqatuchꞌapakal la ixꞌaqaxqolkꞌan y tachun tatakyaulaqꞌal para katachꞌapachal ni Esteban. ");
INSERT INTO tptNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Talaqxaqaxtul ni laka putaulan, va tamajꞌal ixkujukꞌan ex talakatꞌalmal kun chiyux. Yu ixlhistakmata ixkujukꞌan va qayntaun lapanaki yu va tsꞌalkaꞌ yu ixjunkan Saulo. ");
INSERT INTO tptNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ex chuncha tejkan ixtatꞌajun lakatꞌalmanan ex ni Esteban aqtayl skꞌin Dios, va naul: —KiJalhachimoꞌonuꞌ Jesús, kalaꞌaꞌitꞌicha ketsukunti. ");
INSERT INTO tptNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ex taqtsoqoqtalcha, va pꞌays tꞌasal, va naul: —KiJalhachimoꞌonuꞌ, jantu kꞌalakmukꞌanin laqtaqal por yu kintamakanil. Ex tejkan chuncha naunꞌol va limancha nil. ");
INSERT INTO tptNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ni Saulo ayaj ox lhilal por tamaqnil ni Esteban. Ex ni anchanu julchan aqtaynil pꞌays laqmamaqanlqajnivakan tachun yu ixtalhakapuꞌan ni Jesús yu ancha ixtavilanal Jerusalén. Tus taqosꞌol y taꞌanꞌolcha taulnin taꞌakapuchun xalakatꞌun ni Judea ali Samaria. Tatamakaul vamun yu jamalaqachal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lati lapanakni yu ox ixtalhakapuꞌan va tamaknul ni Esteban, va pꞌays talhiqalhul. ");
INSERT INTO tptNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero ni Saulo aqtayl laqlhimaqchapuy yu ixtalhakapuꞌan ni Jesús. Ixtanuy jachaqan por jachaqan, ixjalaqxaqaxtuy joꞌakna kun xanatin para kalakmanul laka pachꞌin. ");
INSERT INTO tptNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ex chuncha ni lapanakni yu taqosnunchal Jerusalén mas va toꞌoxtaycha taꞌan ixtapuꞌan va si ixtalaqputeꞌey yu lay katapulaqtaxtul ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Qayntaun yu ixjunkan Felipe, yucha al lakataun xaputaulan Samaria y aqtayl lhichiviniy ni Cristo. ");
INSERT INTO tptNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lhuu lapanakni ixtaꞌaqxtoqnun y ixtalaqtsꞌin yu lajꞌay axtoqnuꞌ yu ixmakay ni Felipe. Va ox ixtasuy ni laqsaval yu ixnajun. Xlhiyucha ox tamakal kuenta yu ixlaqputeꞌey. ");
INSERT INTO tptNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Qaynlhuu lapanakni palay tajunchoqol yu ixtalhitꞌajun jantu ox espíritus la ixlakatunajkꞌan. Si pꞌays ixtalaktꞌasay ni jantu ox espíritus tejkan ixtataxtuchoqoy la ixlakatunajkꞌan. Vachuꞌ qaynlhuu lapanakni yu ixtalakanita kun alati yu jantu lay ixtaltanan va si palay tajunchoqol. ");
INSERT INTO tptNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Xlhiyucha tachun si talhiꞌachantajul yu ixtavilanal ni anchanu laka putaulan. ");
INSERT INTO tptNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ancha ixꞌalinta qayntaun jachavanaꞌ yu ixjunkan Simón y tachun ni lapanakni si lakmakanul. Vachuꞌ ixkilhuntsukuy ni yucha ma vamun yuꞌ ay lapanaki ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tachun ni lapanakni lajꞌay kun lakstꞌuniy si talhakapuꞌanil yu ixnajun ni yucha. Si ixtanajun: —Yu aniy lapanaki yucha va yu la ay ixtapꞌasta Dios junita. ");
INSERT INTO tptNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ox ixtamakaniy kuenta yu ixnajun porke maqancha ixtꞌajun jalakmakanun por ixjachavanti yu ixmakay. ");
INSERT INTO tptNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero tejkan chinchal ni Felipe va jalakjunil tacha lhachimoꞌonun ni Dios y lhichivinil ni Jesús yu ixtanajunta kamalaqachayaꞌ Dios ex talhakapuꞌal y taꞌaqchajꞌaul joꞌakna kun xanatin. ");
INSERT INTO tptNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ex chuncha ni Simón vachuꞌ lhakapuꞌal y aqchajꞌaul. Yucha tus vak kꞌatsal tejkan laqtsꞌil yu lajꞌay axtoqnuꞌ yu ixmakay ni Felipe yu ixmasuy ixtapꞌasta ni Dios y xlhiyucha aqtayl tꞌatiꞌukxuntayay ni yucha. ");
INSERT INTO tptNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ex ancha Jerusalén yu jamalaqachal ni Jesús va takꞌatsal va ixtalhakapuꞌanta ixchivinti Dios lati yu tavilananchal Samaria. Ex chuncha tamalaqachal ni Pedro ali Juan para kataꞌal ancha Samaria. ");
INSERT INTO tptNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tejkan tachaꞌal va taskꞌinil Dios para katalaqtanuꞌol ni Espíritu Santo ni lapanakni yu ancha ixtavilanal. ");
INSERT INTO tptNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ni yuꞌuncha ixtaꞌaqchajꞌajutacha la ixtaqaꞌuti ni Jesús, pero jantukaꞌ ixtalaqtanuy ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ex ni Pedro ali Juan tamoqslanil ixmakakꞌan yu ixtalhakapuꞌanta y va chuncha talaqtanuꞌol ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ni Simón yu jachavanaꞌ jalaqtsꞌil ni ixtalaqtanuy ni Espíritu Santo tejkan ixjamoqslanikan ni ixmakakꞌan, ex ixjalaqxtaqniputun tumin. ");
INSERT INTO tptNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Va lakjunil ni Pedro ali Juan: —Kilaxtaqniu vachuꞌ ni aniy tapꞌasta para kalaqtanul ni Espíritu Santo mas va taꞌayucha yu kakmoqslanil kimakaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ex ni Pedro junil: —Ni uxintꞌi kapiticha laqnin kun mintumin incha lhakꞌapꞌupꞌin ni lay lhiꞌikan tumin yu xtaꞌa ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ni uxintꞌi jantu paxtoqniyan kalaꞌaꞌitꞌi yu xtaꞌa Dios, la melhanuti va jantu ox katꞌiꞌuntꞌay kun Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chavay kꞌamapꞌaxacha mijatapastakꞌati, kamakꞌauntꞌijlacha milaktuꞌunti. Kꞌatꞌapꞌayninin Dios, yucha kꞌatsay incha kamalaqmixiniyan yu pꞌastꞌakꞌa la melhanuti. ");
INSERT INTO tptNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Kitꞌin ijkꞌatsay ni uxintꞌi ayaj akchꞌipꞌin y vachuꞌ milaktuꞌunti ox laqalhumanitan la mijatapastakꞌati. ");
INSERT INTO tptNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ex chuncha ni Simón jaqaltaychoqol va lakjunil: —Kꞌatꞌapꞌayninitꞌik ni jalhachimoꞌonuꞌ Dios por kitꞌin para jantu chun kaktapasal tacha kilajunau. ");
INSERT INTO tptNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ex chuncha ni Pedro ali Juan jalaqputeꞌenil ni lapanakni yu talaqtsꞌil yu makal ni Jesús y vachuꞌ talaqputeꞌenil ixchivinti Dios. Astan tachꞌapachoqolcha ixlakatinkꞌan para kataꞌanchoqolcha laka putaulan Jerusalén. Ni lakatin taꞌan ixtapuꞌanta si ixtatapasatijlay laka putaulanaxna xaꞌestado Samaria y ancha ixtalaqputeꞌey yu lay katapulaqtaxtul ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ex chuncha taval qayntaun ixmayul Dios laqchaꞌal ni Felipe, va junil: —Kaꞌostꞌaycha, kapiticha taꞌan ixlhisur ni Jerusalén. Kꞌachꞌapꞌa xatin yu puꞌankan laka putaulan Gaza yu tapasay ni lakatꞌun taꞌan jantu matichun kataulal. ");
INSERT INTO tptNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ex chuncha ni Felipe ostayal, va alcha. Ancha lakatin paxtoqlhi qayntaun lapanaki. Yucha va qayntaun yu ay lapanaki yu machaqaꞌ xalakatꞌun Etiopía taꞌan ixlhachimoꞌonun qayntaun xanati yu ixjunkan Kandace. Ni anchanu lapanaki yu paxtoqlhi ni Felipe va yucha yu ixlhistakniꞌojota tachun ixtumin ni Kandace. Yucha kilal laka putaulan Jerusalén para katoꞌoyal ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chuncha va ixꞌanchoqotacha la ixtꞌun. Ex chuncha taꞌan ixpuꞌanta la ixkarro yu taxaqalhaꞌan jukin ancha ixtꞌajun puteꞌeniꞌ ni jalhiki yu tsꞌoqlhi ni Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ex ni Espíritu Santo junil ni Felipe: —Kapiticha, katꞌematꞌi ni anu karro. ");
INSERT INTO tptNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tejkan talakanunil ni Felipe, qasmaknil ixchivinti taꞌan ixtꞌajun puteꞌeniꞌ ni jalhiki yu tsꞌoqlhi Isaías yu maqancha ixlaqputeꞌey ixchivinti Dios. Ex ni Felipe lhisakmil: —¿Malaꞌasiy yu tꞌaꞌun puteꞌeniꞌ? ");
INSERT INTO tptNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ex ni anu ay lapanaki va naul: —¿Tas kakpumalaqasilcha incha jantu alin matichun yu lay kimasunil? Ex chuncha lhijunkal ni Felipe kataukꞌalcha y katꞌataulal. ");
INSERT INTO tptNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Yu ixtꞌajun puteꞌeniꞌ va inchine istsꞌoqkanta: Qayntaun lapanaki lhaꞌankal ixmaqnika tacha laqataun borrego. Va tacha taun sasꞌatꞌa borrego yu jantu tꞌasay tejkan makasikkan, yucha vachuꞌ jantu tsij najun. ");
INSERT INTO tptNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ni lapanakni jantu katalhiꞌaynlhi, yuꞌuncha tamukꞌanil laqtaqal y jantu matichun kaꞌaqtayjul. Va niman tamaqnil, xlhiyucha jantucha lay lhichivinkan ixlapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ex ni ay lapanaki va lhisakmil ni Felipe, va junil: —Kitꞌin kskꞌiniyan taun jatapayniti ni uxintꞌi, kiꞌun tasꞌayucha lapanaki lhichiviniy yu tsꞌoqlhi ni aniy jalhiki. ¿Va lhichivinkan xꞌaman yu tsꞌoqlhi u va lhichiviniy aqayntaun lapanaki? ");
INSERT INTO tptNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ex chuncha ni Felipe aqtaylcha laqputeꞌeniy tacha naunputun ixchivinti Dios yu ixtꞌajun puteꞌeniꞌ y vachuꞌ laqputeꞌenil ni ox chivinti yu lhichiviniy Jesucristo. ");
INSERT INTO tptNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ex chuncha tejkan ixtaꞌanta lakatin va tachaꞌal taun lakxkan. Ex yu ay lapanaki va junil ni Felipe: —Aniy alin xkan. Kitꞌin knajun ka ox kaval kajkꞌaqchajꞌaul. ");
INSERT INTO tptNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ex ni Felipe va junil: —Incha lhakꞌapꞌupꞌin kun tachun la melhanuti ex chun kalal kꞌaꞌaqchꞌajꞌau. Ex ni yucha va qaltayanal, va naul: —Kitꞌin klhakapuꞌan ni Jesucristo va yucha yu Sasꞌatꞌa Dios junita. ");
INSERT INTO tptNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ex chuncha lhinaul kaꞌulakal ni karro. Ex tapatajul ni yucha kun ni Felipe taꞌan ixꞌalin xkan. Ex ni Felipe maqchajꞌaval ni anu lapanaki yu machaqaꞌ Etiopía. ");
INSERT INTO tptNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Tejkan tatakukchoqolcha lakxkan ex ni ixꞌEspíritu ni Jalhachimoꞌonuꞌ Dios va taun laqatsꞌalaj lhaꞌal ni Felipe. Ex yu ay lapanaki jantucha aqtaun kalaqtsꞌinchoqol. Ex va chꞌapachoqolcha ixlakatin kun achati. ");
INSERT INTO tptNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Astan ni Felipe xtaqnil kuenta va ixyachal taꞌan ixꞌalinachal taun putaulan yu ixjunkan Azoto. Tejkan taxtuchal ni Azoto ex taun taun putaulan yu ixtapasay va si ixjalaqputeꞌeniy ni lapanakni yu ox chivinti yu lhichiviniy Cristo, tus chaꞌal taꞌan laka putaulan Cesarea. ");
INSERT INTO tptNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Exnicha ni anchanu julchan, ni Saulo va ayaj ixnajun kalaqmaqnil yu ixtalhakapuꞌan ni Jalhachimoꞌonuꞌ Jesús. Va laqꞌal yu ay ixꞌukxtinkꞌan xakuras ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Va skꞌinil para kaxtaqnil lhachimoꞌon kun aqxtaun karta yu lay kalakmasunil ni israelitas yu ixtataqxtoꞌa laka ay putaulan Damasco taꞌan ixjamasunikan ixlhachimoꞌon ni israelitas. Chuncha para lay kalaklhimil tachꞌinin laka putaulan Jerusalén ni lapanakni yu kalaktemal yu ixtalhakapuꞌan ni Saystꞌi Lakatin, mas kaval joꞌakna ali xanatin. ");
INSERT INTO tptNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Tejkan ixꞌanta lakatin taꞌan va ukstsꞌuniycha laka putaulan Damasco va tꞌoqx maklkunil taun pꞌays maklku laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ex niman taqtal laka tꞌun, va qasmaklhi taun chivinti yu naul: —Saulo, Saulo, ¿valiꞌiycha kꞌixkꞌaylhitꞌaꞌuncha? ");
INSERT INTO tptNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yu Saulo va naul: —¿Jalhachimoꞌonuꞌ, tas ayucha kꞌatꞌicha ni uxintꞌi? Ex va junkal: —Ni kitꞌin va Jesús kunita. Va kitꞌin yu kixkꞌaylhitꞌaꞌun ni uxintꞌi. Va milaqꞌaman tꞌaꞌunkꞌan mamajkꞌatsꞌanikꞌa tacha laqataun vakax tejkan chꞌintay yu putiltoqolhaankan yu aqtsupipi. ");
INSERT INTO tptNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ex ni Saulo va jaxkapꞌiknil ixtalhanti, va naul: —Jalhachimoꞌonuꞌ, ¿tisuncha naꞌun kakmakal ni kitꞌin? Ex yu Jalhachimoꞌonuꞌ va naul: —Kaꞌostꞌaꞌulcha, kapiticha ni laka putaulan Damasco. Ancha katajunan yu maqskꞌiniy kamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ex ni lapanakni yu ixtatꞌaꞌanta ni Saulo va ayaj tatalhanal, va taqasmaklhi chivinkal pero jantu matichun katalaqtsꞌil. ");
INSERT INTO tptNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Taval tayachoqolcha ni Saulo pero tejkan malaqltiꞌal ixlaqchul jantu lay kalakavanal. Ex tamaqchꞌapal y talhaꞌalcha laka putaulan Damasco. ");
INSERT INTO tptNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ancha paqtꞌutu ixvilchal, jantu lay ixlakavanan y vachuꞌ jantu kavayl y jantu tuꞌuchun kaꞌoqlhi. ");
INSERT INTO tptNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ancha Damasco ixvil qayntaun yu ixjunkan Ananías yu ixlhakapuꞌan ni Jesús. Yucha tasunil ni Jalhachimoꞌonuꞌ Dios y laqtsꞌil la ixtalakavanti, va junil: —Ananías. Ex yu Ananías va naul: —Aniy kꞌalinta, Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ex ni Jalhachimoꞌonuꞌ aaqtaun junchoqol: —Kaꞌostꞌaꞌulcha, kapiticha la ixchaqaꞌ Judas yu yal lakatin yu junkan Vas Tin. Ancha kꞌalakxkꞌauyeꞌe qayntaun joꞌati yu machaqaꞌ Tarso yu junkan Saulo. Yucha kintꞌajun tapaynininiꞌ ni anchanu laqa chaqaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yucha jalakavanal tus tacha kalaqmil qayntaun joꞌati yu junkan Ananías y va moqslanil ixmakaꞌ para kalal kalakavananchoqol. ");
INSERT INTO tptNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ex taval yu Ananías va naul: —Jalhachimoꞌonuꞌ, qaynlhuucha lapanakni kintalaqputeꞌenita ni anchanu lapanaki, yucha ayaj jalaqlhimaqchapuy milapanakni yu tavilanal Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y chavay ni aniy putaulan vachuꞌ lhiminta ixlhachimoꞌon ni ixꞌukxtinkꞌan kuras para kalakchꞌilhaꞌal tachun ni lapanakni yu talhakapuꞌan mintaqaꞌuti. ");
INSERT INTO tptNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ex yu Jalhachimoꞌonuꞌ va naul: —Kapiticha. Ni anchanu lapanaki kitꞌin klaksakta para kalhaꞌal kintaqaꞌuti y kilhichivinil kun lapanakni yu jantu israelitas kataval y vachuꞌ kun ixlhachimoꞌonunkꞌan y vachuꞌ kun yu israelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kakmasuniyaꞌ ni yucha ayaj maqskꞌiniy kilamaqanlqajnal. ");
INSERT INTO tptNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ex alcha ni Ananías, va tanuchal laqa chaqaꞌ taꞌan ixvil ni Saulo. Va moqslanil ixmakaꞌ, va junil: —Kintꞌalaqajun Saulo, ni Jalhachimoꞌonuꞌ Jesús yu tasunin ni lakatin taꞌan ixpꞌutꞌantꞌa, va yucha kimalaqachal para kꞌalakꞌavananchꞌoꞌocha y vachuꞌ para kalaqtanuꞌojon ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ex nimancha lakapupatajul tuꞌuchun tus tacha ixtaxꞌapꞌiti jatanti, ex lakavananchoqolcha. Ex chuncha va ostaulchoqolcha, va aqchajꞌaulcha. ");
INSERT INTO tptNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Astan vaynchoqolcha y va chꞌapachoqolcha ixtapꞌasta. Va jalaktꞌatamakaul lati julchan para katꞌataulal ancha laka putaulan Damasco yu ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ex ni Saulo niman aqtayl jalaqputeꞌeniy lapanakni laqa chaqan taꞌan ixtataqxtoꞌa ni israelitas. Va jalakjunil ni lapanakni ni Jesús va Sasꞌatꞌa Dios junita. ");
INSERT INTO tptNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tejkan chuncha taqasmaklhi ni lapanakni va tus vak takꞌatsal, va talalhisakmil y tanaul: —¿Tas ayucha ni aniy joꞌati? ¿Jantu yuꞌ yu lakxkaulhitꞌajun ni lapanakni ancha Jerusalén yu taskꞌin Dios la ixtaqaꞌuti Jesús? Chavay vachuꞌ aniy minta vamun para kalakchꞌapal yu talhakapuꞌan Jesús y kalaklhaꞌanil yu ixꞌukxtininkꞌan kuras. ");
INSERT INTO tptNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ni Saulo ixchiviniy kun tapꞌasta yu lhilhiy ixtalhavaniy, y ox ixlakmasuniy ni Jesús va Cristo yu laksakta Dios. Va jalaktꞌilhinil ixjatapastakꞌatkꞌan ni israelitas yu ancha ixtavilanal laka putaulan Damasco. ");
INSERT INTO tptNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ex chuncha paqlhuu val, ni israelitas chꞌantaun taval para katamaqnil ni Saulo. ");
INSERT INTO tptNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero yucha kꞌatsal yu ixtamakaniputun. Mas laka julchan u mas laka putsꞌista va si ixtapakxanꞌiy taꞌan putaxtukan ni anchanu ay putaulan. ");
INSERT INTO tptNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero tejkan tsꞌis ixjunita yu ixtalhakapuꞌan va tapumaꞌeltajul laqataun ay qaychꞌi la xaꞌexni ni putaulan. Ex chuncha tapumaqosulcha ni Saulo. ");
INSERT INTO tptNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tejkan chaꞌal Jerusalén va ixlaktꞌatanuputun yu ancha ixtalhakapuꞌan. Pero tachun ixtatalhauniꞌojoy, va jantu katalhakapuꞌanil ni yucha incha laqsaval kalhakapuꞌal vachuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero qayntaun yu ixjunkan Bernabé yucha va laqaꞌil, y jalakmamispanil yu jalaqmalaqachal ni Jesús. Va jalakjunil ni yuꞌuncha ni Saulo va laqtsꞌil lakatin ni Jalhachimoꞌonuꞌ Jesús, y va tꞌachivinil. Vachuꞌ jalakjunil ni Saulo laqputeꞌel ixtaqaꞌuti Jesús sin talhanti laka putaulan Damasco. ");
INSERT INTO tptNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ex Saulo tamakaunchalcha Jerusalén, jalaktꞌatiꞌukxuntayalcha yu ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Va laqputeꞌel ixtaqaꞌuti Jesús sin talhanti. Va jalaktꞌachivinil ni israelitas yu ixtachiviniy griego y yuꞌuncha vamun talhilakchivinil kun lhuu lakchivinti. Vachuꞌ ni yuꞌuncha ixtamaqniputun. ");
INSERT INTO tptNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tejkan chuncha takꞌatsal ixjatꞌalaqaunin yu vachuꞌ ixtalhakapuꞌan, ex va talhaꞌal ni Saulo laka putaulan Cesarea, ex astan tamalaqachal laka putaulan Tarso. ");
INSERT INTO tptNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tachun yu ixtalhakapuꞌan xaꞌestado Judea ali xaꞌestado Galilea ali xaꞌestado Samaria va oxamaktaun ixtaꞌukxuyanal y pꞌays val ixlhakapuꞌatikꞌan. Va ayaj ixtatoꞌoyay ni Jalhachimoꞌonuꞌ Jesús, y ni Espíritu Santo laqꞌaqtayjul para katatalhaval. ");
INSERT INTO tptNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ex chuncha ni Pedro va ixjalaqlaqꞌan ixlapanakni Dios, y vachuꞌ jalaqꞌal yu ixtavilanal laka putaulan Lida. ");
INSERT INTO tptNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ancha paxtoqlhi qayntaun lapanaki yu ixlakanita, laqatsajin jachꞌitin ixmal laka putaman. ");
INSERT INTO tptNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ex yu Pedro va junil: —Eneas, ni Jesucristo palaycha makachoqoyan. Kaꞌostꞌaꞌulcha, kasaktꞌicha mixtaꞌati. Ex nimancha ostaulal. ");
INSERT INTO tptNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tejkan chuncha talaqtsꞌil ni lapanakni yu ixtavilanal laka putaulan Lida kun laka putaulan Sarón, va tamapaxal ixputsukukꞌan, va talhakapuꞌal ni Jalhachimoꞌonuꞌ Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Laka putaulan Jope ixꞌalin qayntaun xanati yu ixlhakapuꞌan yu ixjunkan Tabita yu vachuꞌ ixjunkan Dorcas laka lhichivin Griego. Yucha mas va tavanancha kaval ixmakay tachun yu lajꞌox vachuꞌ ixlaqꞌaqtayjuy ni kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ex taval taqanꞌal ni yucha y va nilcha. Va talaqachaꞌal la ixlakatunaj, ex astan talhaꞌal taun kuarto taꞌan talman laqa chaqaꞌ yu talaqtꞌuy. ");
INSERT INTO tptNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yu putaulan Jope va ixlhiꞌukstsꞌuniy ixjunita kun Lida taꞌan ixvilchal ni Pedro. Tejkan takꞌatsal yu ixtalhakapuꞌan ni ancha ixvilchal ni Pedro ex va tamalaqachal pumatꞌuy jaltanan, va tatapayninil ni Pedro, va tajunil: —Kijnan klalaqmintau para tsꞌalaj kilatꞌaꞌau Jope. ");
INSERT INTO tptNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ex yu Pedro nimancha ostaulal, va jalaktꞌaꞌalcha. Tejkan chinchal ex tajuntalhaꞌal ni laka kuarto taꞌan ixmachal ni janiniꞌ. Yu tiyaunin ayaj ixtalhiqalhun, va tamasunil ni Pedro ixlaqchꞌitikꞌan yu jalakmakanil ni Dorcas tejkan vananaj ixtꞌajun. ");
INSERT INTO tptNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ni Pedro laklhijunil katataxtul maqspaꞌ, ex va taꞌaqtsoqoqtanil ni Dios y va tapayninil. Ex astan talaqaspꞌiklhi y laqastal ni janiniꞌ, va junil: —Tabita, kaꞌostꞌaꞌulcha. Ex ni janiniꞌ talaqpuꞌalcha la ixlaqchul y laqtsꞌil ni Pedro, y ostaulalcha. ");
INSERT INTO tptNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ex ni Pedro maqchꞌapaꞌostaulnil y jalakjuntanuchoqolcha ixpulakna yu ixtalhakapuꞌan vachuꞌ kun yu tiyaunin, y lakmasunil va ixkujchoqotacha. ");
INSERT INTO tptNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Taval takꞌatsaꞌolcha ni xaputaulan Jope, ex qaynlhuu lapanakni talhakapuꞌal ni Jalhachimoꞌonuꞌ Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ex ni Pedro ancha tamakaunchalcha paqlhuu laka putaulan Jope la ixchaqaꞌ qayntaun xalaꞌoxiniꞌ jaxtaꞌan yu ixjunkan Simón. ");
INSERT INTO tptNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ni laka putaulan Cesarea ixvilchal qayntaun lapanaki yu ixjunkan Cornelio. Yucha va qayntaun kapitan yu ixlhichimoꞌoy cien tropas yu taminchal Italia. ");
INSERT INTO tptNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ni yucha kun tachun ixlapanakni ayaj ox ixtatoꞌoyay ni Dios. Y ox jalaqꞌaqtayjul ni kilpatanin y lhilhiy ixtatapayniniy Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Tauncha julchan va laꞌatꞌutu putoqoxata ixjunita, ex ox tasunil ixmayul ni Dios. Va talakanunil y va junil: —Cornelio. ");
INSERT INTO tptNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Chuncha ni Cornelio va ayaj talhanal, va aqtaylcha sniy laqtsꞌin, va naul: —¿Tisun naꞌuncha, kiꞌukxtin? Ex yu ixmayul Dios va naul: —Ni Dios laqaꞌinin tacha taun ox lapaxkan tachun yu mintapayniti kun tachun yu laqxtꞌaqnin ni kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Chavay kꞌalaqmalaꞌachꞌatꞌi lapanakni laka putaulan Jope para kataꞌal juntaꞌinin qayntaun lapanaki yu junkan Simón yu vachuꞌ junkan Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Yucha tꞌavilchal qayntaun xalaꞌoxiniꞌ jaxtaꞌan yu vachuꞌ junkan Simón, yu yachal ixchaqaꞌ va ixlhiꞌukstsꞌuniy lakamar. Yucha kajunan tachun yu maqskꞌiniy kamakꞌatꞌi. ");
INSERT INTO tptNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tejkan anchoqolcha ixmayul ni Dios yu tꞌachivinil, ex ni Cornelio jalakjuntaꞌil pumatꞌuy ixꞌoqxtamatin kun qayntaun ixtropa yu ixtoꞌoyay Dios y ixmakay yu ixlhijuniy ni Cornelio. ");
INSERT INTO tptNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Va aqtayl jalaqputeꞌeniy tachun yu tapasal ex astan jalaqmalaqachalcha kataꞌal laka putaulan Jope. ");
INSERT INTO tptNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ex yu ataun julchan val tejkan atunkujcha ixjunita, va ixlhiꞌukstsꞌuniycha para katachaꞌal Jope, exnicha taukꞌal ni Pedro la ixꞌukxni laqa chaqaꞌ, aqtayl tapayniniy Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Taval chꞌapachal taun chavan, ixnajuntacha niman kavayl. Pero tejkan ixtꞌaunkan laꞌoxinika ixvayti, va tasunil taun tuꞌuchun. ");
INSERT INTO tptNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Va laqtsꞌil tacha katalaqltiꞌal ni laktꞌiyan. Ancha tasul tacha kamaꞌeltajukal lakatꞌun aqxtaun ay laqchꞌiti yu kankatꞌati chꞌinikanta ixkankatiꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Va ixtatajumanal tapuchux talhitsukuti yu maꞌatꞌati ixchꞌajakꞌan ali tsapulin yu alin lakatꞌun ali xatsꞌoꞌon laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ex va qasmaklhi taun chivinti, va junkal: —Kaꞌostꞌaꞌulcha, Pedro. Yu aniy talhitsukuti kꞌamaqnitꞌi y kꞌaꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yu Pedro va naul: —Jalhachimoꞌonuꞌ, jantu lay kꞌuy. Jantu aqtaun kꞌuy yu jantu uyujnajun kꞌaꞌutꞌi la kilhachimoꞌonkꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ex va qasmakchoqol ataun chivinti, va junkal ni Pedro: —Tachun yu najun Dios lajꞌox para kꞌaꞌutꞌi yucha jantu kꞌaꞌun incha jantu ox kꞌaꞌutꞌi. ");
INSERT INTO tptNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ex chuncha aqtꞌutu chuncha tapasal. Ex yu ay laqchꞌiti nimancha lhaꞌanchoqokal laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Tejkan Pedro ixtꞌajun pastaknaꞌ suncha naunputun yu laqtsꞌitapasal, va exnicha tachinchal ni lapanakni yu laqmalaqachal ni Cornelio taꞌan ixyal ixchaqaꞌ ni Simón y tatalakxtutayal laka matiꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Va pꞌaysni tachivinil, talhasakminil incha ancha ixvil ni Simón yu vachuꞌ ixjunkan Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ni Pedro vananaj ixtꞌajun pastaknaꞌ yu laqtsꞌitapasal. Ex ni Espíritu Santo va junil: —Simón, talakxkauyan qayntꞌutu lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kaꞌostꞌaꞌulcha, kapꞌatꞌaꞌutꞌicha talaktsin. Kalaktꞌapiticha y jantu kapastakꞌun tuꞌuchun, va kitꞌin klaqmalaqachata para katalaqmin. ");
INSERT INTO tptNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ex patajul ni Pedro, va lakjunil: —Va kitꞌin ni kilalakxkauyau. ¿Tisuncha kilalhilaqmintau? ");
INSERT INTO tptNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ex tanaul: —Kintamalaqachan qayntaun kapitan yu junkan Cornelio. Yucha va qayntaun yu ayaj qalꞌox lapanaki. Ox toꞌoyay Dios y tachun yu israelitas mas va toꞌoxtaycha kaval va si ox talhichiviniy. Qayntaun ixmayul Dios lhinaul kaklalaqmiu para kapiti la ixchaqaꞌ para lay kaqasmaknin yu kꞌaꞌuneꞌe. ");
INSERT INTO tptNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ex ni Pedro jalaklhijunil kataloqojlhi laqa chaqaꞌ. Ex yu ataun julchan val, laktꞌaꞌalcha y vachuꞌ tatꞌaꞌal lati ixtꞌalaqaunin yu ixtavilanal Jope. ");
INSERT INTO tptNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ex apaqtaun val, tachaꞌal laka putaulan Cesarea. Y yu Cornelio ancha ixlakpakxanꞌita kun alati ixtꞌalapanakni ali ixꞌamigos yu ixjalakjuntaꞌita. ");
INSERT INTO tptNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tejkan Pedro va laycha katanuchal laqa chaqaꞌ exnicha ni Cornelio va paxtoqlhi, va taꞌaqtsoqoqtanil la ixchꞌajaꞌ ni Pedro para katoꞌoyal. ");
INSERT INTO tptNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro maꞌostaulnil, va junil: —Katꞌaycha. Kitꞌin vachuꞌ va lapanaki kunita. ");
INSERT INTO tptNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Tejkan vananaj ixtꞌajun tꞌachivin Cornelio ni Pedro ex tanulcha laqa chaqaꞌ y ancha japaxtoqlhi pumalhuu lapanakni yu ixtaꞌaqxtoqnun. ");
INSERT INTO tptNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ex yu Pedro lakjunil: —Kꞌatsꞌayatꞌikcha ni kilhachimoꞌonkꞌan yu israelitas kuntau jantu kintaxtaqniyan lakatin para kaktaqxtoqvi chꞌantaun kun uxiknan yu jantu israelitas kꞌaꞌuntꞌik. Pero chavay kimasunil ni Dios ni jantu maqskꞌiniy kajkunil matichun incha jantu ox ixjatsukunti u incha lhitꞌajun laqtaqal. ");
INSERT INTO tptNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Xlhiyucha tejkan kilajuntaꞌiu, jantu tsij kaknaul, va niman kmil. Chavaycha klalhisakmiyau ¿Valiꞌiycha kilajuntaꞌiucha? ");
INSERT INTO tptNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ex yu Cornelio junil: —Laꞌatꞌaticha julchan xajun chuncha tacha chavaycha aniy hora laꞌatꞌutu putoqoxata xaktꞌajun tapaynininiꞌ Dios aniy la kinchaqaꞌ. Ex niman kintasunil qayntaun lapanaki yu ox kꞌuliksnaꞌ ixjunita ixlaqchꞌiti. Va kijunil: ");
INSERT INTO tptNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Cornelio, Dios qasmaknitan mintapayniti y pastakꞌan por yu ox jalaqꞌaqtꞌayꞌuy ni kilpatanin. ");
INSERT INTO tptNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Kꞌamalaꞌachꞌan ixꞌika laka putaulan Jope qayntaun Simón yu junkan Pedro. Yucha vil la ixchaqaꞌ qayntaun xalaꞌoxiniꞌ jaxtaꞌan yu vachuꞌ junkan Simón yu vil ixlhiꞌukstsꞌuniy lakamar. Yucha katꞌachivinanan tejkan kaminaꞌ.” ");
INSERT INTO tptNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ex niman kmalaqachanal mijuntaꞌika y klhiꞌachantajuy ni aniycha viltꞌi. Chavaycha aniy alintau la ixlakaꞌukxpuꞌ Dios. Knaunau kilajuniu tachun yu lhijunin ni Jalhachimoꞌonuꞌ para kaklaqasmakniu. ");
INSERT INTO tptNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ex yu Pedro aqtayl chiviniy, va naul: —Chavaycha ox kmalaqasiy ni Dios tachun jalaqaꞌiꞌojoy mas va taꞌayucha kaval. ");
INSERT INTO tptNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ox jalaqaꞌiy lapanakni mas va toꞌoxtaycha katataulal incha tatalhauniy ni yucha y tamakay yu lajꞌox yu lhinajun. ");
INSERT INTO tptNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yucha laqmalaqachanil ni israelitas yu ox chivinti. Va jalakjunil tacha lay oxamaktaun katapuꞌukxuntayal por yu makal Jesucristo yu xaJalhachimoꞌonuꞌ tachun ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Uxiknankꞌan ox kꞌatsꞌayatꞌik yu tapasal la xalakatꞌun Judea. Aqtaynichal xaꞌestado Galilea tejkan Juan laqxaqalal ni lapanakni para kataꞌaqchajꞌaul. ");
INSERT INTO tptNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kꞌatsꞌayatꞌik ni Dios xtaqnil palhachimoꞌon ni Jesús yu machaqaꞌ Nazaret y chuncha laqtanul ni Espíritu Santo kun tapꞌasta. Chuncha ni Jesús ixꞌukxuyal makanaꞌ yu lajꞌox y palay ixjalakmakachoqoy tachun ni lapanakni yu ixjalaqmamaqanlqajnivay ni aqmoqxnuꞌ porke Dios ixꞌalinta chꞌantaun kun yucha. ");
INSERT INTO tptNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","’Ni kijnankꞌan klaqtsꞌinꞌojoo tachun yu makal mas la ixtꞌunkꞌan ni israelitas y vachuꞌ yu ay ixputaulankꞌan Jerusalén, tus tejkan tamaqnil y tamakxtꞌukmukꞌal laka kurus. ");
INSERT INTO tptNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero tejkan paqtꞌutu val, ex ni Dios va majkujuchoqol y kintamasunin. ");
INSERT INTO tptNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jantu kalaktasuniꞌol tachun ni lapanakni. Vamun kijnan kintatasunin yu Dios ixkintalaksaktan. Tejkan kujchoqolcha, ex xaktꞌavaynau y xaktꞌaꞌoqyau yu oqkan. ");
INSERT INTO tptNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesús kintamalaqachan kajkꞌau jalaqputeꞌeninin ni lapanakni ni Dios xtaqnil ixpalhachimoꞌon para kapuxkaulaqtsꞌinil ixlaqtaqalkꞌan tachun ni lapanakni mas yu takujta y mas yu tanitacha. ");
INSERT INTO tptNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ni Jesús va yucha yu ixtalhichiviniy tachun yu maqancha ixtalaqputeꞌey ixchivinti Dios tejkan tanaul ni va por ixtaqaꞌuti ni yucha kalaqmalaqmixinikanaꞌ ixlaqtaqalkꞌan tachun ni lapanakni yu talhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tejkan vananaj ixtꞌajun chivin ni Pedro, ex ni Espíritu Santo talaqtanuꞌol tachun yu ancha ixtatꞌajun qasmakninin ixchivinti. ");
INSERT INTO tptNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ni israelitas yu ixtalhakapuꞌan yu tatꞌamil ni Pedro va tus vak takꞌatsal tejkan talaqtsꞌil jalaqxtaqnikal vachuꞌ ni Espíritu Santo yu jantu israelitas ixtajunita. ");
INSERT INTO tptNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Taqasmaklhi ni va ixtatꞌajun chivinin kun alati lhichivin yu jantu ixtamalaqasiy y ay ixtamakay ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ex yu Pedro va naul: —Jantu matichun lay laktanchay para jantu kataꞌaqchajꞌaul ni aniy lapanakni. Vachuꞌ talaqaꞌil ni Espíritu Santo tacha kijnankꞌan klaqaꞌiu. ");
INSERT INTO tptNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ex astan ni Pedro lhinaul kataꞌaqchajꞌaul la ixtaqaꞌuti ni Jesucristo. Ex talhijunil kalaktꞌatamakaul lati julchan ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Yu jalaqmalaqachal ni Jesús kun tachun yu ixtalhakapuꞌan yu ixtavilanachal xaꞌestado Judea va takꞌatsal ni vachuꞌ talaqaꞌil ixchivinti Dios yu jantu israelitas kataval. ");
INSERT INTO tptNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ex tejkan chinchoqol ni Pedro laka putaulan Jerusalén ancha ixtavilanal lati israelitas yu talhakapuꞌan. Yuꞌuncha tamukꞌanil laqtaqal ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Va tanaul: —¿Valiꞌiycha jalaqkꞌilatꞌicha lapanakni yu jantu israelitas kataval y chꞌantaun jalaktꞌavay yuꞌuncha? ");
INSERT INTO tptNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ex ni Pedro va qaltayanal, aqtaylcha jalaqputeꞌeniy tachun yu tapasal. Va naul: ");
INSERT INTO tptNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Tejkan xakvil laka putaulan Jope kitꞌin xaktꞌajun tapaynininiꞌ Dios ex klaqtsꞌil aqxtaun ay laqchꞌiti yu kintaꞌeltajunil tus laktꞌiyan. Kankatꞌati ixchꞌinikanta ixkankatiꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ancha klaqtsꞌil ixtatajumanal xatalhitsukuti lakatꞌun yu talhitꞌajun maꞌatꞌati ixchꞌajakꞌan, ali maqtalin ali tsapulin ali xatsꞌoꞌon laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kitꞌin ijqasmaklhi taun chivinti, va kijunil: “Kaꞌostꞌaꞌulcha, Pedro, yu aniy talhitsukuti kamaqnitꞌi y kꞌaꞌutꞌi.” ");
INSERT INTO tptNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ex kitꞌin kunil: “Jantu lay kꞌuy, Jalhachimoꞌonuꞌ. Jantu aqtaun kꞌuy yu najun la kilhachimoꞌonkꞌan jantu ox kꞌaꞌutꞌi.” ");
INSERT INTO tptNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ex va ijqasmakchoqol ataun chivinti yu minchal laktꞌiyan, va kijunil: “Tachun yu najun Dios lajꞌox para kꞌaꞌutꞌi yucha jantu kꞌaꞌun incha jantu ox kꞌaꞌutꞌi.” ");
INSERT INTO tptNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ex aqtꞌutu chuncha tapasal. Taval lhaꞌanchoqokalcha laktꞌiyan. ");
INSERT INTO tptNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Exnicha tachaꞌal pumatꞌutu lapanakni yu laqmalaqachakal laqa chaqaꞌ taꞌan xakvil yu taminchal laka putaulan Cesarea. ");
INSERT INTO tptNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ni Espíritu Santo kilhijunil kaklaktꞌaꞌal y jantu kimpastakꞌul tuꞌuchun. Vachuꞌ kintatꞌaꞌal yu aniy pumachaxan ketꞌalaqauninkꞌan. Va ktanuchaꞌau la ixchaqaꞌ qayntaun lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yucha kintalaqputeꞌenin ni vachuꞌ laqtsꞌil ixmayul Dios y va lhijunkal kamalaqachanal Jope ixjuntaꞌika qayntaun Simón yu junkan Pedro ");
INSERT INTO tptNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","para kajunil tas lay kapulaqtaxtul ni yucha kun ixlapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ex tejkan kitꞌin kꞌaqtayl klaqxaqalay, va taꞌeltajul ni Espíritu Santo, tus talaqtanuꞌol vachu chun tacha yu pꞌunaj kintalaqtanun kijnan. ");
INSERT INTO tptNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ex niman kpastakchoqol yu kintajunin ni Jalhachimoꞌonuꞌ Jesús tejkan naul: “Ni Juan va xkan ixpumaqchajꞌavanan pero uxiknan kꞌapꞌuꞌaqchꞌajꞌauyapitik ni Espíritu Santo.” ");
INSERT INTO tptNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Va Dios yu jalaqxtaqnil ni Espíritu Santo vachu chun tacha kintaxtaqnin kijnan tejkan lhakapuꞌau ni Jalhachimoꞌonuꞌ Jesucristo. Ex chuncha kitꞌin jantu klaktanchaputun yu makay Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Tejkan chuncha taqasmaklhi yu ancha ixtavilanal va tus saq taval y ay tamakal ni Dios, va tanaul: —Chavaycha ni Dios mas yu jantu israelitas kataval vachuꞌ jamapaxaniy ixjatapastakꞌatkꞌan para lay katalaqaꞌil yu ox jatsukunti. ");
INSERT INTO tptNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Tejkan maqnikal ni Esteban ex lati ni lapanakni aqtayl jalaqmamaqanlqajnivakan por ixlhakapuꞌatikꞌan. Ex taꞌal jaqosnun tus xaꞌestado Fenicia kun Chipre y vachuꞌ laka putaulan Antiokía. Ancha talaqputeꞌel ni sastꞌi chivinti yu xtaꞌa jatsukunti, pero vamun ni israelitas jalaqputeꞌenikal. ");
INSERT INTO tptNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Lati yu ixtalhakapuꞌan yu machaqan Chipre kun Sirene yuꞌuncha vachuꞌ tachaꞌal ni laka putaulan Antiokía. Ex yuꞌuncha talaqputeꞌenil yu jantu israelitas kataval ni sastꞌi chivinti yu lhichiviniy ni Jalhachimoꞌonuꞌ Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yuꞌuncha ixtalhitꞌajun ixtapꞌasta ni Jalhachimoꞌonuꞌ, xlhiyucha pumalhuu lapanakni tapaxal ixputsukukꞌan, y talhakapuꞌal ni Jalhachimoꞌonuꞌ Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tejkan takꞌatsal yu ixtalhakapuꞌan ancha laka putaulan Jerusalén, ex yuꞌuncha vachuꞌ tamalaqachal ni Bernabé kaꞌal laka putaulan Antiokía. ");
INSERT INTO tptNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tejkan ancha chaꞌal ni Bernabé va laqtsꞌil ni laqsaval ixjalakmapayniy ni Dios. Ex ni Bernabé ayaj lhiꞌachantajul va laqxaqalal tachun para katataylhaꞌal kun chux la ixjalhanutikꞌan ni Jalhachimoꞌonuꞌ y jantu aqtaun katamakauntijlal. ");
INSERT INTO tptNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Yucha va qayntaun lapanaki yu ayaj qalꞌox ixjunita. Va tus ixlaqtanuꞌol ni Espíritu Santo, y pꞌays ixjunita ixlhakapuꞌati. Va por yucha pumalhuu lapanakni talhakapuꞌal ni Jalhachimoꞌonuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Taval ni Bernabé al puxkaunaꞌ Saulo laka putaulan Tarso. Tejkan temachal va lhimil tus laka putaulan Antiokía. ");
INSERT INTO tptNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ancha ixlaktꞌavil taun jachꞌitin yu ixtalhakapuꞌan, jalakmasunil lhuvaj lapanakni. Ni laka putaulan Antiokía va ancha taꞌan pꞌunaj lakjunkal Cristianos yu ixtalhakapuꞌan ni Cristo. ");
INSERT INTO tptNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ni anchanu julchan, lati lapanakni yu ixtalaqputeꞌey ixchivinti Dios tataxtulcha Jerusalén y taꞌal Antiokía. ");
INSERT INTO tptNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ex xaqayntaun ni yuꞌuncha yu ixjunkan Agabo tayal taꞌan ixtataqxtoꞌa yu ixtalhakapuꞌan Jesús. Ni Espíritu Santo va xtaqnil jatapastakꞌati, ex va naul yu Agabo ni kaꞌalinaꞌ taun ay chavan tachun ni anchanuꞌ lakamunukpaꞌ. Astan chuncha val tejkan Claudio ixjunita yu ay jalhachimoꞌonuꞌ Romano. ");
INSERT INTO tptNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ex chuncha yu ixtalhakapuꞌan ancha Antiokía va chꞌantaun tamakal ixjatapastakꞌatikꞌan para kataꞌaqtayjul ixtꞌalaqauninkꞌan yu vachuꞌ ixtalhakapuꞌan yu ixtavilanal xaꞌestado Judea, mas va lakstsꞌuninin yu kalal. ");
INSERT INTO tptNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ex chuncha laqsaval va tamalaqachanil taun limosnaj yu xalajꞌaynin yu ixtalhakapuꞌan xaꞌestado Judea. Va talhaꞌal Bernabé ali Saulo. ");
INSERT INTO tptNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ex chuncha ni anchanu julchan ni jalhachimoꞌonuꞌ Herodes aqtayl lakxkaylhitsukuy lati yu ixtalhakapuꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Va malaqachanal ixmaqnika ni Jacobo yu xajayaꞌ Juan ixjunita. Va tamaqnil kun aqxtaun espada. ");
INSERT INTO tptNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Yu israelitas ayaj tamaqamal xlhiyucha tejkan chuncha kꞌatsal ni Herodes ex vachuꞌ malaqachanal ixchꞌika ni Pedro. Chuncha tapasal tejkan ixjunita ixkꞌatankꞌan ni israelitas tejkan ixtaꞌuy pan yu jantu ixlaqlhitayay levadura. ");
INSERT INTO tptNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tejkan Herodes chꞌapal ni Pedro ex manul laka pachꞌin, va laqmaqxtaqnil oqxlaqtꞌati tropas para katalhistaklhi. Va pumatꞌatin oqxlaqtamin. Va ixnajun kamaxtul tus katamaktaꞌelal xakꞌatan Paxku, para kamukꞌanil laqtaqal la ixlakaꞌukxpukꞌan ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ex ni Pedro va ox ixtalhistaknuta laka pachꞌin, pero yu ixtalhakapuꞌan Jesús laqatapꞌasta ixtatꞌajun tapayninin Dios por yucha. ");
INSERT INTO tptNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ex valaycha kalakachil ni julchan tejkan ni Herodes ixmaxtuputun laka pachꞌin ni Pedro para kamukꞌanil laqtaqal. Tejkan tsꞌis ixjunita ex yu Pedro ixmal laka pachꞌin. Va ixtamataꞌajmata pumatꞌuy tropas, ox ixtachꞌimata kun maꞌatꞌuy kadena y vachuꞌ alati tropas ixtalhistaknuta la xakiltalakxtuti. ");
INSERT INTO tptNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ex tsꞌalaj tasul ixmayul ni Jalhachimoꞌonuꞌ Dios y tꞌoql mapulkul taꞌakchun laka pachꞌin. Va tampasal ni Pedro, maqloꞌol, va junil: —¡Tsꞌalaj kaꞌostꞌaycha! Ex ni kadenas niman talajꞌexpatajul la ixmakaꞌ ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ex ni ixmayul Dios va junil: —Kꞌamulatꞌicha milaqchꞌiti y kachꞌantꞌanutꞌicha misapato. Ex chuncha makal ni Pedro. Ex vachuꞌ naul ni mayul: —Kꞌalhilaqapaqaqkꞌacha minkutun y kintꞌapꞌitꞌicha. ");
INSERT INTO tptNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ex yu Pedro niman nuks maqayaul ixmayul ni Dios, y tataxtul laka pachꞌin. Pero yu Pedro jantu ixkꞌatsay incha laqsaval ixjunita yu ixtꞌajun makaniniꞌ ni mayul. Ixlhilay va ixtꞌajun aqlaqavan. ");
INSERT INTO tptNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Va tapalaqpuslhi taꞌan ixtayanal oqxlaqtꞌuy tropas, tachaꞌal tus laka puerta yu tsasnati ixjunita, yu paxajtachal tus lakatin. Va xꞌaman talaqltiꞌal, ex tataxtul. Va taltanal maqataun tin. Ex yu mayul laqatsꞌalaj makaulcha xꞌaman ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ex yu Pedro lakpukujlhicha, va naul: —Chavay ijkꞌatsay ni laqsaval kimalaqachanil ixmayul ni Jalhachimoꞌonuꞌ Dios. Kimalaqtaxtul la ixtamakaꞌ ni Herodes kun tachun yu ixkintamakaniputun ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Tejkan chuncha pastaklhi ni Pedro, ex alcha la ixchaqaꞌ María yu ixnati qayntaun yu ixjunkan Juan Marcos. Ancha ixtaꞌaqxtoqnun lhuvaj lapanakni, ixtatꞌajun tapaynininin Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Tejkan chaꞌal laqa chaqaꞌ ni Pedro, va tayal la ixlhimaqspaꞌ, aqtayl makasay xapuerta. Qayntaun maqtsukuꞌ yu ixjunkan Rode al laka matiꞌ para kamispal tas ayucha ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tejkan aqapimispal va Pedro ixjunita ex ayaj lhiꞌachantajul. Pero jantu kamalaqltiꞌal ni puerta porke niman takyautaspꞌikchoqol, va la pꞌas naul: —¡Ni Pedro lakxtuyal laka puerta! ");
INSERT INTO tptNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yuꞌuncha tanaul: —Ka va lokoj kꞌatꞌi. Pero yucha aqlhuu naul ni va laqsaval. Ex yuꞌuncha tanaul: —Kavalay va ixjalhitsukunuꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yu Pedro taylhaꞌal makasanaꞌ ni puerta. Ex tejkan tamalaqltiꞌal, tus taun talhilal. ");
INSERT INTO tptNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ex ni Pedro va lakmajkunil para saq kataval. Ex aqtayl jalakjuniy tacha pumalaqtaxtul laka pachꞌin ni Jalhachimoꞌonuꞌ Dios. Taval jalakjunil: —Kꞌalaqpꞌutꞌeꞌeniyapitik ni Jacobo kun yu alati ketꞌalaqauninkꞌan yu ktapasal. Ex taxtulcha, alcha alakataun. ");
INSERT INTO tptNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Tejkan tunkulcha va ayaj taputꞌilhil ixjatapastakꞌatikꞌan ni tropas porke jantu ixtakꞌatsay tisuncha lhitapasalcha ni Pedro. ");
INSERT INTO tptNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ex ni Herodes malaqachanal ixpuxkauka pero jantu katatemal. Ex jalhisakmil ni tropas tisuncha tapasal y astan malaqachanal ixjalaqmaqnikakꞌan ni anchanu tropas. Ex ni Herodes taxtul ancha laka estado Judea, va al laka putaulan Cesarea. Ancha taulchalcha. ");
INSERT INTO tptNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ni Herodes ixlaklukujlaniy ni lapanakni yu ixtavilananchal laka putaulan Tiro kun Sidón. Ex yuꞌuncha tataqxtoqlhi laka putaulan Cesarea, ixtatꞌachivinputun ni Herodes. Pꞌunaj tatꞌachivinꞌelal qayntaun yu ixjunkan Blasto para kalaqꞌaqtayjul. Yucha yu ay ixꞌoqxtamati ixjunita ni jalhachimoꞌonuꞌ Herodes. Skꞌinil lakatin para lay katatꞌachivinil Herodes para ox katatiꞌukxuntayal porke ixlhiꞌutikꞌan va ixminachal laka tꞌun taꞌan ixjalhichimoꞌonun ni Herodes. ");
INSERT INTO tptNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Tejkan laqchaꞌalcha julchan para katatꞌachivinil, ex ni Herodes ulal ni laqchꞌiti yu taꞌulay jalhachimoꞌonun, va taulal laka siya taꞌan jalhachimoꞌonun. Ex laqxaqalal ni lapanakni. ");
INSERT INTO tptNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ex ni lapanakni aqtayl pꞌaysni tachiviniy, va tanaul: —Va tacha qayntaun dios akapitꞌajun jantu tacha lapanaki. ");
INSERT INTO tptNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ni Herodes jantu ay kamakal ni Dios xlhiyucha niman maqtaqanꞌal ixmayul ni Dios. Ex aqtaylcha taꞌuniy tsapulin ixlakatunaj, ex nilcha. ");
INSERT INTO tptNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero ixchivinti Dios yucha laqputeꞌekal mas va toꞌoxtaycha kaval y talhavaꞌal taꞌakapuchun lakamunukpaꞌ yu talhakapuꞌal. ");
INSERT INTO tptNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Tejkan ni Bernabé kun Saulo tamajkanilcha ixpujaltanakꞌan por ixjamalaqachakanta Jerusalén, ex taminchoqochalcha. Talhimil yu ixjunkan Juan Marcos. ");
INSERT INTO tptNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ancha laka ay putaulan Antiokía ixtataqxtoꞌa lapanakni yu ixtalhakapuꞌan Jesús, lati ixtalaqputeꞌey ixchivinti Dios y lati ixtamalaninin. Yuꞌuncha ixlakjunkan Bernabé, ali Simón yu ixjunkan Niger, ali Lucio yu machaqaꞌ laka putaulan Cirene, ali Manaén yu chꞌantaun tꞌaꞌaynl ni jalhachimoꞌonuꞌ Herodes, ali Saulo. ");
INSERT INTO tptNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Tejkan ixtatꞌajun toꞌoyanan ni Dios y vachuꞌ ixtatꞌajun taskꞌajanan ex naul ni Espíritu Santo, va lakjunil: —Kilalaksakniu Bernabé kun Saulo para katamakal kilhitapatsa yu kitꞌin kaklaklhijunaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Chuncha tejkan tamamaktal ixtaskꞌajatikꞌan y tatapayniniꞌol ni Dios ex tamoqslanil ixmakakꞌan ni Bernabé ali Saulo y tamalaqachalcha. ");
INSERT INTO tptNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ex chuncha ni Espíritu Santo laqmalaqachalcha. Ex ni Bernabé ali Saulo taꞌalcha laka putaulan Seleucía. Ex tataxtulcha ni Seleucía, tapuꞌal laqataun barco lakamar, tachaꞌal tus alakataun lakatꞌun yu ixjunkan Chipre yu taꞌajmal lakamar. ");
INSERT INTO tptNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ancha tachaꞌal laka putaulan Salamina y talaqputeꞌel ixchivinti Dios taꞌan ixtatamoꞌoy ni israelitas. Ni Juan vachuꞌ ixtatꞌaꞌanta para kaꞌaqtayjul. ");
INSERT INTO tptNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tapalaqpusꞌol taꞌakchun ni anchanu lakatꞌun yu taꞌajmal lakamar, tachaꞌal tus ataun putaulan yu ixjunkan Pafos. Ancha tapaxtoqlhi qayntaun israelita yu jachavanaꞌ ixjunita, ixjunkan va Bar-Jesús. Anchanu joꞌati va ayaj ixjalaklkanan, ni yucha ixnajun ixlaqputeꞌey ixchivinti Dios mas jantu laqsaval ixjunita. ");
INSERT INTO tptNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yucha va chꞌantaun ixtꞌavil ni gobernador yu ixjunkan Sergio Paulo, yu ixlhitꞌajun lhuu jatapastakꞌati. Ni Sergio Paulo jalaklhijunil katamil ni Bernabé ali Saulo, va ixqasmakputun ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero ni jachavanaꞌ, yu vachuꞌ ixjunkan Elimas, yucha ixjalaktanchaniputun ni Bernabé ali Saulo para jantu kalhakapuꞌal ni gobernador. ");
INSERT INTO tptNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ex ni Saulo, yu vachuꞌ ixtajuniy Pablo, yucha ixlaqtanuꞌojota ni Espíritu Santo. Ex laqastal ni Elimas, ");
INSERT INTO tptNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","va junil: —Uxintꞌi jamakanunuꞌ y jalaklkanaꞌ kꞌatꞌi, va sasꞌatꞌa aqmoqxnuꞌ unitꞌa, uxintꞌi unitꞌa ixtꞌalaxkayaꞌ tachun yu lajꞌox. Uxintꞌi vamun laktꞌanchꞌapꞌutꞌun para jantu vas kaꞌal ixlakatin Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chavay ni Dios kaxtaqniyan maqanlqajnati. Kꞌaꞌuneꞌe laꞌachꞌix y paqlhuu jantu kalaqtsꞌineꞌe julchan. Ex nimancha laꞌachꞌix val ni jachavanaꞌ. Chuncha tiꞌukxuntayalcha, ixlakxkajuy taꞌayuꞌ kamaqchꞌapalhaꞌal. ");
INSERT INTO tptNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Tejkan chuncha laqtsꞌil ni gobernador va lhakapuꞌal y tus taun lhilal ni chivinti yu lhichiviniy ni Jalhachimoꞌonuꞌ Jesús yu laqputeꞌenikal. ");
INSERT INTO tptNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ex ni Pablo ali yu alati ixtꞌaltanan tataxtulcha laka putaulan Pafos y tatajuchoqolcha laka barco. Taꞌalcha laka putaulan Perge la xaꞌestado Panfilia. Ancha ni Juan jalakmakaunchoqolcha y nimancha anchoqol Jerusalén. ");
INSERT INTO tptNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Y yu alati tataxtulcha ni Perge, tataylhaꞌal jaltanan tus laka putaulan Antiokía la xaꞌestado Pisidia. Ex tejkan xajulchan jastaknati val, tatanuchal taꞌan ixtatamoꞌoy ni israelitas, ancha tataulal. ");
INSERT INTO tptNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Tejkan puteꞌekal xalibro yu ixjapulhichimoꞌonkꞌan ni israelitas y vachuꞌ kun ixchivintikꞌan yu maqancha ixtalaqputeꞌey ixchivinti Dios, ex ni ixꞌukxtininkꞌan ni israelitas yu ancha ixtataqxtoꞌa va tajuntaꞌil ni Pablo kun ixtꞌaltanan. Va tajunil: —Ketꞌalaqaunin, incha lhitꞌantꞌatꞌik taun chivinti para katatapꞌaysnil kun Dios ni lapanakni ex kanauntꞌikcha. ");
INSERT INTO tptNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ex tayal ni Pablo, niman jalakmajkunil ni lapanakni kun ixmakaꞌ para saq katataulal, y va naul: —Uxiknan tachun yu kintꞌaꞌisraelitas untꞌatꞌik y tachun yu tꞌalhauniyatꞌik ni Dios, kilaqasmakniu kinchivinti. ");
INSERT INTO tptNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ni kiDioskꞌan yu israelitas juntau jalaksaklhi ni kepayankꞌan yu maqancha ixtatꞌajun. Jalaklalhaval tejkan ixtavilanal xalakatꞌun Egipto mas jantu an machaqan ixtajunita. Astan ni Dios kun ixtapꞌasta jalakmaxtul ni anu lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Yucha jalaqmaqantaulnil ixputsukukꞌan lakakꞌavinan tus tacha cuarenta jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jalaqmaqnil oqxlaqtujun lapanakni yu ixtavilanal la xalakatꞌun Canaán ex jalaqlvaqnil ixtꞌunkꞌan y jalaqxtaqnil ni israelitas. ");
INSERT INTO tptNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Chuncha por tachun yu aniy tapasal va taqmaqal tacha cuatro cientos cincuenta jachꞌitin. Ex astan jaxtaqnikal jueces tus tejkan aqtayl laqputeꞌey ixchivinti Dios ni Samuel. ");
INSERT INTO tptNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ex chuncha yuꞌuncha taskꞌil qayntaun jalhachimoꞌonuꞌ para kalaklhichimoꞌokal y chuncha yu Dios jamaqxtaqnil qayntaun yu ixjunkan Saulo, yu istsꞌal Sis ixjunita, va minchal kun Benjamín. Ni Saulo jalaklhichimoꞌol tus cuarenta jachꞌitin. ");
INSERT INTO tptNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ex taval ni Dios maqosunil ixpulhachimoꞌon ni Saulo, va jamaqxtaqnil kalhichimoꞌonul yu David. Ni Dios lhichivinil David, va naul: “Klaqtsꞌin ni David yu istsꞌal Isaí. Yucha va qayntaun lapanaki yu chꞌantaun junita kun kitꞌin y yucha makaꞌojoy tachun yu kitꞌin klhinajun.” ");
INSERT INTO tptNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ex vachuꞌ naul ni Pablo: —Ni Dios malaqachal qayntaun lapanaki yu minchal kun David yu junkan Jesús para kamalaqtaxtul xalapanakni Israel, chuncha tacha ixnajunta kamalaqachayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tejkan jantukaꞌ ixmin ni Jesús ni Juan lhichivinil la ixlakaꞌukxpukꞌan tachun ni israelitas ni kaminaꞌ y jalakjunil ni maqskꞌiniy katamapaxal ixjatapastakꞌatkꞌan y kataꞌaqchajꞌaul. ");
INSERT INTO tptNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tejkan va laycha kamiꞌol ixjatsukunti ni Juan, va naul: “Kitꞌin jantu yuꞌ kakval chuncha tacha yu uxiknankꞌan pꞌakxanꞌiyatꞌik, pero astan kaminaꞌ yu mas apalay ay xajantu kitꞌin. Ni kitꞌin jantu kimpaxtoqniy mas kaklaqmusxꞌoqnil isapato,” naul ni Juan. ");
INSERT INTO tptNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ex vachuꞌ naul ni Pablo: —Ketꞌalaqaunin yu tꞌanchꞌipitikcha kun Abraham y vachuꞌ uxiknankꞌan yu jantu israelitas kꞌaꞌuntꞌik yu tꞌalhauniyatꞌik ni Dios, ni aniy chivinti yu pulaqtaxtukan yucha va para uxiknankꞌan. ");
INSERT INTO tptNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yu ixtavilanal Jerusalén kun ixjalhachimoꞌonunkꞌan, yuꞌuncha jantu ixtakꞌatsay tasꞌayucha ixjunita ni Jesús y jantu ixtamalaqasiy ixchivinti Dios yu ixlaqputeꞌekan xajulchan jastaknati taꞌan ixtatamoꞌoy ni israelitas. Yuꞌuncha tamukꞌanil laqtaqal ni Jesús ex chuncha tapasaꞌol ni anchanu chivinti yu maqancha tanaul yu ixtalaqputeꞌey ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mas jantu katatemanil tuꞌuchun laqtaqal para katamaqnil, pero taskꞌinil ni Pilato para kamalaqachanal ixmaqnika. ");
INSERT INTO tptNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tejkan chuncha tamakaꞌol, ex tapasaꞌol tachun yu istsꞌoqkanta yu lhichiviniy Jesús, tapꞌuxlhi ni la ixkurus y tamaknul. ");
INSERT INTO tptNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero mas nil ni Jesús, ni Dios yucha majkujuchoqol. ");
INSERT INTO tptNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Astan ni Jesús paqlhuvaj jalaktasunichoqol yu ixjatꞌaꞌukxuntayay yu tataxtuchal Galilea y tatꞌaꞌal Jerusalén. Chavay va yuꞌuncha yu talaqputeꞌeniy ni lapanakni tacha tapasal ni Jesús. ");
INSERT INTO tptNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Y vachuꞌ naul ni Pablo: —Chuncha kijnankꞌan klalaqputeꞌeniyau taun ox chivinti yu maqancha jalakjunil kepayankꞌan ni Dios yu kamakayaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Laqsaval chuncha makal tacha naul kun kijnankꞌan yu ixjapapanaknakꞌan juntau. Chuncha makal tejkan majkujuchoqol ni Jesús. Chuncha tacha tsꞌoqkanta laka Salmo dos taꞌan najun: “Uxintꞌi kesꞌatꞌa unitꞌa, chavay kitꞌin kval mimPay.” ");
INSERT INTO tptNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ni Dios naul ni kamajkujuchoqoyaꞌ laka janinin xlhiyucha ni ixlakatunaj jantu kapuchꞌil. Inchine naul ni taꞌan tsꞌoqkanta: “Kakmaqxtaqniꞌoyan tachun yu lajꞌox chuncha tacha kunil ni David.” ");
INSERT INTO tptNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Xlhiyucha ni David vachuꞌ tsꞌoqlhi taꞌan alakataun Salmo yu inchine najun: “Jantu naꞌun kapuchꞌil kilakatunaj ni kitꞌin yu kꞌilaksaktꞌa.” ");
INSERT INTO tptNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Laqsaval ni David tapatsanil ni Dios tejkan vananaj ixtiꞌukxuyal chuncha tacha Dios lhijunil. Ex nil ni David, tamaknul chꞌantaun taꞌan ixtaꞌaknunun ixjapayan, ex astan niman puchꞌil ixlakatunaj. ");
INSERT INTO tptNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero yu majkujuchoqol ni Dios yucha jantu kapuchꞌil. ");
INSERT INTO tptNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ex chuncha, ketꞌalaqaunin, tsꞌanqay kakꞌatsꞌatꞌik ni lay kamalaqmixinikꞌantꞌik tachun milaqtaqalkꞌan por Jesús yu klalhixaqalayau. ");
INSERT INTO tptNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Va por yucha tachun yu talhakapuꞌan va jalaqlaꞌoxinikan ixjatsukuntikꞌan para jantucha kalakmukꞌanikal ixlaqtaqalkꞌan yu jantu lay xamalaqmixinikan mas ixtamakay ixlhachimoꞌon ni Moisés. ");
INSERT INTO tptNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kꞌalhistꞌakkꞌantꞌik para jantu chun kalhitꞌapꞌasatꞌik tacha yu maqancha tatsꞌoqlhi yu ixtalaqputeꞌey ixchivinti Dios yu tanaul inchine: ");
INSERT INTO tptNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Uxiknan yu jalaktꞌuꞌununatꞌik, katꞌalhanantꞌik, kꞌamiꞌoyapitik. Ni kitꞌin yu Dios kunita kakmakayaꞌ lajꞌay axtoqnuꞌ taꞌan tꞌiꞌukxuyanantꞌik, mas matichun katajunan jantu kalhakꞌapꞌupꞌinapitik, va naul ni Dios, —chuncha jalaqputeꞌenil ni lapanakni ni Pablo. ");
INSERT INTO tptNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ex va chuncha taval tejkan tataxtuchoqolcha taꞌan ixtatamoꞌoy ni israelitas, ex yu jantu israelitas ixtajunita talhijunil ni Pablo ali Bernabé para kataminchoqol yu ataun xajulchan jastaknati para kalhichivinchoqol aaqtaun ni anu chivinti. ");
INSERT INTO tptNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ex chuncha tejkan tamaktalcha ni taqxtoꞌati lhuvaj israelitas y vachuꞌ lhuu lapanakni yu talhitanul tacha israelitas tatixkaulhaꞌal ni Pablo ali Bernabé. Ex yuꞌuncha taxtaqnil ox jatapastakꞌati para katataylhaꞌal la ixjamapayninti ni Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ex chuncha tejkan ataun semana junchoqol yu xajulchan jastaknati, va tataqxtoqlhi valaycha tachun ni lapanakni ni anchanu laka putaulan para kataqasmaklhi ixchivinti Dios. ");
INSERT INTO tptNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero tejkan talaqtsꞌil ni israelitas va lhuu lapanakni tataqxtoqlhi ex nimancha taꞌaqtayl tamakay ixꞌakchaꞌatikꞌan. Chuncha taꞌaqtaynil talhichiviniy ni Pablo yu jantu laqsaval kaval y talaktuꞌul. ");
INSERT INTO tptNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pero ni Pablo ali Bernabé jantu katachivinil kun talhanti, va tanaul: —Ixmaqskꞌiniy kalaqputeꞌekal ixchivinti Dios pꞌunaj kun uxiknankꞌan yu israelitas untꞌatꞌik. Kijnan klamasuniu pero uxiknankꞌan jantu kalaꞌaꞌitꞌik, lhilayatꞌik ni jantu tapaxtoqniyan jatsukunti yu jantu miꞌojoy. Xlhiyucha kajkꞌanaucha jalaqputeꞌeninin ixchivinti Dios yu jantu israelitas kataval. ");
INSERT INTO tptNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Va chuncha kintalhijunin ni Jalhachimoꞌonuꞌ, va naul: Kitꞌin klalakꞌulatau tacha ixmaklkukꞌan ni lapanakni yu jantu israelitas kataval, para katalaqtaxtul lapanakni tus taꞌakapuchun lakamunukpaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tejkan chuncha taqasmaklhi yu jantu israelitas ixtajunita, ayaj talhipaꞌinil y talhiꞌachantajul y nimancha aqtayl tanajun ni Jalhachimoꞌonuꞌ Dios la ox ixjunita ixchivinti. Ex talhakapuꞌal tachun yu laqsaval jalaksakkal para katalhitsukul ni jatsukunti yu jantu aqtaun kamiꞌoyaꞌ. ");
INSERT INTO tptNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chuncha laqputeꞌeꞌokal ixchivinti Dios tus taꞌakchun anchanu lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero yu israelitas taxaqalal ni xanatin yu apalay ixlaktoꞌoyakan yu ixtalhakapuꞌan Dios y vachuꞌ yu joꞌakna yu ixtalhitꞌajun tapꞌasta. Jalakchivijvakal para kalakxkaykal ni Pablo ali Bernabé y para chuncha kalaqtinaqxtukal ni anchanu lakatꞌun. ");
INSERT INTO tptNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ex chuncha yuꞌuncha jalakchꞌankꞌalapꞌuxkal ixchꞌanpꞌoqxkꞌan para kapumasunikal va jalaktanchanikalcha ni lapanakni por jantu katalaqaꞌil ixchivinti Dios. Ex taꞌalcha alakataun putaulan yu ixjunkan Iconio. ");
INSERT INTO tptNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero yu ixtalhakapuꞌan Jesús yu ixtavilanal laka putaulan Antiokía tus ox ixtalhitꞌajun achati y ixtalaqtanun ni Espíritu Santo. ");
INSERT INTO tptNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ancha laka putaulan Iconio, ni Pablo ali Bernabé vachuꞌ tatanul taꞌan ixtatamoꞌoy ni israelitas. Lhuvaj lapanakni talhakapuꞌal por tamaqamal ixchivintikꞌan mas yu israelitas y vachuꞌ mas yu jantu israelitas kataval. ");
INSERT INTO tptNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero yu israelitas yu jantu ixtalhakapuꞌan niman taꞌaqt