﻿USE sofia;
DROP TABLE IF EXISTS sofia.tpp_vpl;
CREATE TABLE tpp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tpp_vpl WRITE;
INSERT INTO tpp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yucha aniya yu ixjat'alalhila'ts'inin an Jesucristo yu japu'a'p'unminchalh. Japu'a'p'unminchalh an ixjat'alalhila'ts'inin an David chi an Abraham. ");
INSERT INTO tpp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","An Abraham ixlit'ajun ists'alh ixjunkan Isaac. Chi an Isaac ixlit'ajun ists'alh ixjunkan Jacob. An Jacob ixluwk'ani ixjalhit'ajun ists'alan, xapumatam ixjunkan Judá. ");
INSERT INTO tpp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","An Judá yu ixjas'at'an pumatam ixjunkan Fares chi pumatam Zara. Yu ixnatik'an ixjunkan Tamar. An Fares ixlit'ajun ists'alh ixjunkan Esrom. Chi an Esrom ixlit'ajun ists'alh ixjunkan Aram. ");
INSERT INTO tpp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","An Aram ixlit'ajun ists'alh ixjunkan Aminadab. An Aminadab ixlit'ajun ists'alh ixjunkan Naasón. An Naasón ixlit'ajun ists'alh ixjunkan Salmón. ");
INSERT INTO tpp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","An Salmón ixlit'ajun ists'alh ixjunkan Booz, chi yu ixt'iwi an Salmón ixjunkan Rahab. An Booz ixlit'ajun ists'alh ixjunkan Obed chi yu ixnati ixjunkan Rut. An Obed ixlit'ajun ists'alh ixjunkan Isaí. ");
INSERT INTO tpp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","An Isaí ixlit'ajun ists'alh yu junlhi rey, yucha an David. An rey David ixlit'ajun ists'alh ixjunkan Salomón, chi yu ixnati an Salomón ixt'iwi ixjunita tichi lapanak ixjunkan Urías yu ixnitacha. ");
INSERT INTO tpp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","An Salomón ixlit'ajun ists'alh ixjunkan Roboam. An Roboam ixlit'ajun ists'alh ixjunkan Abías. An Abías ixlit'ajun ists'alh ixjunkan Asa. ");
INSERT INTO tpp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","An Asa ixlit'ajun ists'alh ixjunkan Josafat. An Josafat ixlit'ajun ists'alh ixjunkan Joram. An Joram ixlit'ajun ists'alh ixjunkan Uzías. ");
INSERT INTO tpp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","An Uzías ixlit'ajun ists'alh ixjunkan Jotam. An Jotam ixlit'ajun ists'alh ixjunkan Acaz. An Acaz ixlit'ajun ists'alh ixjunkan Ezequías. ");
INSERT INTO tpp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","An Ezequías ixlit'ajun ists'alh ixjunkan Manasés. An Manasés ixlit'ajun ists'alh ixjunkan Amón. An Amón ixlit'ajun ists'alh ixjunkan Josías. ");
INSERT INTO tpp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","An Josías ixluwk'ani ixjalhit'ajun ists'alan, xapumatam ixjunkan Jeconías, yu'uncha akxni ixtat'ajun akxni an judiojnin jalhi'ankalhcha tacha tach'inin la'acha'an Babilonia. ");
INSERT INTO tpp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ixli'astan akxni jalhi'ankalhcha Babilonia, an Jeconías wachucha lhitsukunikalhi ists'alh, ixjunkan Salatiel. Chi an Salatiel ixlit'ajun ists'alh ixjunkan Zorobabel. ");
INSERT INTO tpp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","An Zorobabel ixlit'ajun ists'alh ixjunkan Abiud. An Abiud ixlit'ajun ists'alh ixjunkan Eliaquim. An Eliaquim ixlit'ajun ists'alh ixjunkan Azor. ");
INSERT INTO tpp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","An Azor ixlit'ajun ists'alh ixjunkan Sadoc. An Sadoc ixlit'ajun ists'alh ixjunkan Aquim. An Aquim ixlit'ajun ists'alh ixjunkan Eliud. ");
INSERT INTO tpp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","An Eliud ixlit'ajun ists'alh ixjunkan Eleazar. An Eleazar ixlit'ajun ists'alh ixjunkan Matán. An Matán ixlit'ajun ists'alh ixjunkan Jacob. ");
INSERT INTO tpp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","An Jacob ixlit'ajun ists'alh ixjunkan José. An José ixt'apapa an María, an ixnati an Jesús, yu lhimispakan Cristo. ");
INSERT INTO tpp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pus chunchacha yu pu'a'p'unminchalh an Cristo. Sta akxni ixt'ajun an Abraham, asta akxni wachucha tsukulh an David, ixlipu'a'kawt'at'icha ixtalaapu'a'p'unmintachalh. Chi akxni ixt'ajuncha an David sta akxni jalhi'ankalh an judiojnin tacha tach'inin la'acha'an Babilonia, a'tamcha ixlipu'a'kawt'at'i ixjumpalata ixtalaapu'a'p'unmintachalh. Chi sta akxni ixjalhi'ankantacha la'acha'an Babilonia, sta akxni tsukulhcha an Cristo, a'tamcha ixlipu'a'kawt'at'i. ");
INSERT INTO tpp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Chunchuniya pula'awlh an Jesús. An María an ixnati Jesús, wa isk'in'ulakantaka', yucha an José, walh an Stalan'a Takuwin ilhtulhi li kaja'aynalh. ");
INSERT INTO tpp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pus an José, tacha ixt'apapacha an María, mu yucha ixjalakpastaknan chi jantu ixmamaxaniputuni an María, wa kalaks ixmakawputun. ");
INSERT INTO tpp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Pero wa chunchaka ixpast'ak'a, akxni lhtatalh talakasunilh pumatam ix'angelh an Dios, juniy: ―José, ists'alh David, jant'u k'at'alhani k'at'at'a'ulh an María, mu an pakxanta ixjas'at'a yucha an Stalan'a ixTakuwin Diosi chuncha ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kalhitsukuya pumatam ists'alh, ch'i k'a'ulaniya'a ixta'a'ut JESÚS, mu yucha kajama'alhtaxtuya an ixlapanakni la ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chux tacha ani tapasalh, wa xliyu li an Dios ixmanawnitacha an yu ixlichiwiniy ixchiwinti Dios, akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tichi yucha jatsi yu jatsika sawalh, kapakxana ixjas'at'a, chi kalhitsukuya', Emanuel ka'ulaniya ixta'a'ut, yucha nawputun: Dios kintat'a'aklat'awnan. ");
INSERT INTO tpp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Akxni kujcho'olhcha an José, chunchacha ilhtulh tacha an junilh an ix'angelh Dios, la'a'ilhi an María tacha ixt'iwi'. ");
INSERT INTO tpp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero jantu tacha ixt'iwicha sawalhi t'atawilh, sta akxni lhitsukulhcha an ixjas'at'a, chi ulanilhcha ixta'a'ut JESÚS. ");
INSERT INTO tpp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","An Jesús tsukulhcha an la'acha'an Belén, la xalakaat'un Judea, akxni rey ixjunita an Herodes, walh tichi lapanakni yu ixtajalakpastaknan yu taminchalh lhitan akxajachilh an wilhchan, tacha'alhcha an la'acha'an Jerusalén, tanajun: ");
INSERT INTO tpp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","―¿Tanischa tan tsukulh ixrejk'an an judiojnini? Mu kla'ts'inawi an ist'aku sta tan iklhiwilhcha'aw, tan lhi'akxajachilh an wilhchan, pus ikmintaw tatso'ottaninin. ");
INSERT INTO tpp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Pus akxni k'atsaalhcha an rey Herodes, jantucha oxi ixliwilay chi ixchuxk'an an jamacha'an Jerusalén wachu'. ");
INSERT INTO tpp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wa chuncha jama'ayxto'olhi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin yu ancha jamacha'an, chi jalhisakmilhcha tanchuncha nawkan li katsukuya Cristo. ");
INSERT INTO tpp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Pus yu'uncha tajuniy: ―An Belén, xalakaat'un Judea, mu chuncha ts'o'muk'ata an yu ixlichiwiniy ixchiwinti Dios tan najun: ");
INSERT INTO tpp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Chi uxint'i la'acha'an Belén, xalakaat'un Judá, jantu li sna wa xalakat'ikt'ichak'at'i tacha an tach'alhkatnan Judá. Mu aniya kataxtuya pumatam jamach'alhkat yu kajalhist'ak'a kilapanakni yu israelitajnin. ");
INSERT INTO tpp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ixli'astan an Herodes, kalaks jat'asanilhi an yu tajalakpastaknan lapanakni, chi oxicha jalhisakmilh taniwanancha talakasulh an st'aku. ");
INSERT INTO tpp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Chi jamala'achalhcha la'acha'an Belén, jajuniy: ―K'ap'inchi'itcha, oxicha k'ap'uxk'awya'it an jas'at'a chi akxni k'ala'ch'ip'ina'itcha akilamak'atsaaniyaw, para li wachu ak'alh tatso'ottanini'. ");
INSERT INTO tpp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pus ta'asmatni'olh an rey, ta'alhcha, chi an st'aku an yu ixtala'ts'intachalh sta tan akxajachilh an wilhchan ixlakapuchak'ani ixja'aninita, sta cha'alhi an tan ixmachalh an jas'at'a, chi sa'cha tayalh. ");
INSERT INTO tpp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Akxni tala'ts'ilhcha an st'aku sawalhcha ixtalaj'achan. ");
INSERT INTO tpp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chi tatanulhcha an laka cha'a'. Wachuncha tala'ts'ilhcha an jas'at'a chi an María, ixnaticha an jas'at'a. Pus tatatso'ottanilhcha an jas'at'a chi ay tukani tala'ts'ilh. Ixli'astan talaj'a'mix'alhcha an ixtanlhunk'an chi taxta'nilhcha oro, chi cencia chi perjume. ");
INSERT INTO tpp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Akxni ta'ancho'olhcha an yu tajalakpastaknan lapanakni jantucha la'acha'an Jerusaleni tapu'alh, para li kaxtamak'atsaanilh an Herodes, mu an Dios jamala'awanilh tan jajuniy li lakatamcha katapu'alh. ");
INSERT INTO tpp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ixli'astan akxni ta'ancho'olhcha, an José la ixjala'awanti talakasunilh pumatam ix'angelh an Dios, juniy: ―K'a'ost'aycha, k'ach'ixsakt'icha an jas'at'a, chi ali an ixnati xalakaat'uncha Egiptojo k'a'osp'it'it. Anch'ach'a k'at'awlht'achi'it sta akxni kit'in ajkuncho'oyan, mu an Herodes kapuxkawya an jas'at'a para li lay kama'nilh. ");
INSERT INTO tpp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pus ostayalhcha an José chi ch'ixsaklhicha an jas'at'a, chi alicha an ixnati an jas'at'a, puts'ista ta'alh xalakaat'un Egipto. ");
INSERT INTO tpp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Anchacha ixtawilananchalh sta akxni nilh an Herodes, pus walhcha sawalhi tacha an ixnajunta yu ixlichiwiniy ixchiwinti Dios, mu Diosi ixmanawnita tan najun: “La xalakaat'un Egiptojo ikt'asanilh an kints'alh.” ");
INSERT INTO tpp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","An Herodes akxni k'atsaalhi li ta'o'xcho'olhi an yu tajalakpastaknan lapanakni, talh'amalhcha. Lhinawlhcha li kajama'ni'okalhi an jas'at'an yu ts'alan an la'acha'an Belén, chi an la'acha'anaxni yu waniycha ancha lhitamakajun. Jama'ni'okalhi yu wa ixtat'ajunka sta yu la'at'uycha k'ata ixtat'ajun, tacha an ixlima'ancha ixjalhisakmita an lapanakni yu tajalakpastaknan. ");
INSERT INTO tpp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chunchacha sawalhi tapasalh tacha an ists'o'ta an Jeremías yu ma'anchacha ixlichiwiniy ixchiwinti Dios, akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ay ta'oxila'alhit chi alhuti asmatkalh an la'acha'an Ramá, yucha an Raquelhi jalhi'alhun ixjas'at'an, mu talaknilh chi jantucha la'a'ilhi li kama'oxamixikalh. ");
INSERT INTO tpp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero ixli'astan akxni nilhcha an Herodes, an José la ixjala'awanti talakasunilh pumatam ángel an xalakaat'un Egipto, juniy: ");
INSERT INTO tpp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―K'a'ost'aycha, k'ach'ixsakt'icha an jas'at'a chi ali an ixnati k'ap'inchi'itcha xalakaat'un Israel, mu an yu ixtama'niputun an jas'at'a, talaknilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pus ostayalhcha an José chi a María, chi an José ch'ixsaklhicha an jas'at'a, ta'alhcha xalakaat'un Israel. ");
INSERT INTO tpp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wa yu an José k'atsaalhi li an Arquelao, ists'alh an Herodes yuchacha ixch'alhkatnancho'oy an xalakaat'un Judea, pus talhanalhi li ancha ka'alh, pus an Dios mak'atsaanilhi an José la ixjala'awanti tanchuncha ka'alh, pus xalakaat'uncha Galileaja alh. ");
INSERT INTO tpp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Anchacha cha'alh, tawilhcha lakatam la'acha'an tan junkan Nazaret, pus tapasalhcha sawalhi tacha an ixtanajunta an yu ixtalhichiwiniy ixchiwinti Dios, li nazarenojo kajunkana'. ");
INSERT INTO tpp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Akxni an jama'paxanaj Juan tsukulhcha lhichiwiniya ixchiwinti Dios, an xalakaat'un Judea, tan lakak'iwin ");
INSERT INTO tpp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","najun: ―T'uch'a ali k'a'ilht'ut'iti mintala'alhink'an, mu an ixlich'alhkat Dios waniycha t'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yucha anicha lapanaki yu an ixlichiwiniy Isaías, yu ixlichiwiniy ixchiwinti Dios tan ixnajun: “Chiwinkani an lakak'iwin, nawkan mintacha an ay Jamach'alhkat, k'ala'asijt'itcha para li akxni kachina ts'awjch'a t'awnat'it.” ");
INSERT INTO tpp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","An ixla'ch'it an Juan wa ixla'ach'awt camellojo ixla'oxinikanta chi ixch'axpawilhcha a'xtam jaxt'a'an. Chi yu ix'uy, xat'axkat lakak'iwin chi sele'. ");
INSERT INTO tpp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ixta'ancha alha'asmatnini an Juan an jamacha'an Jerusalén chi ixchuxk'an an yu xalakaat'un Judea ixtawilanalh chi ixchuxk'an an yu ixtala'acho'owilananilhcha an ayxkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yu ixtanajuncha tuchini ixtala'alhinchak'ani ixtalhit'ajun, ixjama'paxaycha an Juan an ayxkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Walh akxni jala'ts'ilhi li ixluwk'ani ixta'anta a'paxnin an lapanakni yu ixjajunkan fariseojnin chi saduceojnin, jajuniy: ―¡Ixjas'at'an tsapulin! ¿Tisiyuchacha tajunin tani k'alhit'a'alht'axt'utcha la ixtalh'amti Dios akxni kamina'a? ");
INSERT INTO tpp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","P'us k'a'ilht'utcha yu oxicha tanlhun para li katasulhcha li mak'a'unt'itcha sawalhi mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ch'i jant'u k'ap'ast'akt'iti k'ana'unt'it: an Abraham tacha kimpayk'an, mu an Dios yucha layi kaja'ilhtulh ixjas'at'an an Abraham ani lakwilh chiwx. ");
INSERT INTO tpp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chi atumpaj, an Dios tachanu mala'asijnitacha an ix'acha para li kala'ticha'x'oyacha an k'iw yu jantu oxi tawk'aniy xajatawk'at chi kajala'xawa'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kit'in sawalh, wa laka xkani ijkama'paxay yu jantucha ali katita'ilhtulh ixtala'alhink'an, pero an yu astan mintachalh yucha palay ay, kit'in jantu, yucha kajama'paxanana la ixTakuwin Dios chi laka jikmi, yucha jantu ikt'acha'ani masi wa aklakch'apalhi'anilhcha ixwarachi. ");
INSERT INTO tpp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yucha ch'apatacha an ixpak'alhan kamaxtuniyacha an xajamakxtalh an ixtrigo, chi kama'ayacha an ixtrigo laka cha'a tan la'oxinita chi an xajamakxtalh kala'xawayacha laka jikmi, tan jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","An Jesús minchalhi sta xalakaat'un Galilea chi la'cha'alhi an Juan, para li an Juan kama'paxalhi an Jesús an ayxkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero an Juan jantu ixma'paxaputun, yucha juniy: ―Kit'in iknajun uxint'i ak'ima'p'axat'i chi uxint'i kit'ini k'ila't'ant'a. ");
INSERT INTO tpp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pus an Jesús alhtaylh juniy: ―Ak'ima'p'axat'icha chaway, mu chuncha lhitask'iniy li ka'ilhtuw yu oxi lhiwilay an Dios. Pus an Juan ma'paxalhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Akxni ma'paxa'olhcha, takutlhicha an lakxkan an Jesús. Chi mati'anikalhcha an lakt'iyan, la'ts'in ta'alhtajulhcha an ixTakuwin Dios tan ixyalh, wa tacha paloma. ");
INSERT INTO tpp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chi an lakt'iyan chiwinkanchalhcha nawkan: ―Yucha anicha yu ikmapayniy kinTs'alh yucha yu kima'an'achay. ");
INSERT INTO tpp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","An ixTakuwin Dios lhi'alhi an Jesús lakak'iwin para li an xapay makxkay'un kalhila'ts'intanuchalh. ");
INSERT INTO tpp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chi mu t'up'uxamcha (40) wilhchan chi t'up'uxamcha jatats'isni ixlitask'ajata ixwayt an Jesús, pus chawanilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chi la'cha'alhcha an xapay makxkay'un, juniy: ―Li isTs'alhk'at'i Dios sawalh k'aja'un ani chiwx li katawalh pan. ");
INSERT INTO tpp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero yucha alhtaylh juniy: ―Ts'o'muk'akanta la ixchiwinti Dios li jantu wa waytcha katiputsukulh an lapanak. Wachu layi kaputsukuya chux ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wa chuncha an xapay makxkay'un lhi'ampalh an la'acha'an Jerusalén, ixla'acha'an Dios, chi muk'achalhcha an la ix'ukxni ay tajtan. ");
INSERT INTO tpp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chi jumpalhkancha an Jesús: ―Li isTs'alhk'at'i Dios k'awarj p'it'i an talaktsin, mu ts'o'muk'akanta an la ixchiwinti Dios: li an Dios kajamakmina ix'angelhnin para li katama'ch'apan, para li jant'u k'a'ayst'uk'uk'a laka chiwx. ");
INSERT INTO tpp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","An Jesús juniy: ―Ts'o'muk'akanta la ixchiwinti Dios li jant'u wa k'at'ilhila'ts'int'anut'i an miJamach'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","An xapay makxkay'un a'tam lhi'ampalh lakatam laka ay a'stitawk'a an Jesús. Chi lakmasuni'olhcha an laj'ay lhich'alhkat alin lakamunulhpa chi an ixk'usinti. ");
INSERT INTO tpp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Chi junkan an Jesús: ―Chux ani akxta'ni'oyancha li ak'int'ats'o'ott'aniya'a. ");
INSERT INTO tpp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pus an Jesús akxni alhtaylh juniy: ―K'ap'inchicha Satanás, mu ts'o'muk'akanta an la ixchiwinti Dios tan najun: “Wa yucha an miJamach'alhkat Diosi k'at'ats'o'ott'aniya'a chi wa yucha k'ak'iklaka'iya'a.” ");
INSERT INTO tpp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wa chuncha an xapay makxkay'un alhcha. Chi ixli'astan tala'cha'alhcha angelhnini an Jesús, chi ixtatapatsaniycha. ");
INSERT INTO tpp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Akxni k'atsaalhi an Jesús li an Juan ixmalaklhchawkanta, ancho'olhi ixla'acha'an Nazaret, xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Chi taxtupalhi la'acha'an Nazaret, alhcha tawlhna la'acha'an Capernaúm, waniy ixkilhtu lakxkan, waniy xalakaat'un Zabulón chi Neftalí. ");
INSERT INTO tpp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Wa xliyu li chunchacha katapasalh tacha ixnajunta an Isaías yu ma'anchacha ixlichiwiniy ixchiwinti Dios akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","La ixt'un Zabulón chi la ixt'un Neftalí, an ixtapiktutamcha juntachalh ayxkan Jordán, la ixkilhtu alamalh yu junkan Galilea, lhuwi tawilanalh yu jantu tamispay Dios. ");
INSERT INTO tpp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ani lapanakni yu wa lakaputs'isnicha ixtat'ajun tala'ts'ilhcha an ay jatapulhkunu'. Chi an lapanakni yu wa la ixma'stele'cha lhinin ixtalak'aklat'ajun, jamapulhkunilhcha an jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Akxnicha tsukulhcha lhichiwiniy ixchiwinti Dios an Jesús, jajuniy: ―K'amap'axat'itcha mijatapast'ak'atk'an mu an ixlich'alhkat Dios waniycha minta. ");
INSERT INTO tpp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Akxni waniycha ix'antachalh ixpiktu xa'alamalh Galilea, an Jesús jala'ts'ilh ixt'uyunk'an ixch'apayawnan jatanti, wa lhit'ala'awnin. Yu'uncha an Simón yu ixtajumpalay ma Pedro chi an Andrés ixt'ala'ajuncha. Ixtamujuy ixpaxo'tankan an lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pus jajuniy: ―Akilat'a'awcha, walh ixma'alhilanancha lapanakni akla'ilhtuyaw. ");
INSERT INTO tpp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wa chuncha yu'uncha watukan tamakawlhi an ixpaxo'tank'an chi tat'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wanika ancha ixtala'pust'ajun an Jesús jala'ts'impalh ixt'uyunk'an, wachu wa lhit'ala'awnin yu'uncha an Jacobo chi Juan, ixtalakch'it'ajun ixpaxo'tank'an laka barco ali ixpayk'an yu junkan Zebedeo, walh jat'asanilhi an ixt'uyunk'an. ");
INSERT INTO tpp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pus yu'uncha tamakawlh watukani an ixbarcojk'an chi an ixpayk'an, tat'a'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ta ixlijalhi'ay an xalakaat'un Galilea ta'a'cho'o'olhi an Jesús. Chi ixjamasuniycha an ixchiwinti Dios an lapanakni an laka lakcha'a yu ixpulakta'ayxto'kan, chi ixjalhixa'alaycha an laj'oxi chiwinti yu masuy ixlich'alhkat Dios chi wa tuchicha ta'an'at, ixk'uch'uy chi chux tu'u yu jantu oxi ixjama'ank'ats'ay an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pus sawalhcha tapumispalh sta chux xalakaat'un Siria, lhuwcha ta'an'anini ixtalhicha'aniy, yu intacha ixtaxkaniy, yu ixlakpach'apata makxkay'un, yu wa ixniy chi yu wa ixtalaklakalhtukulun, pus ixjak'uchuycha. ");
INSERT INTO tpp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Wanajcha lhuw lapanakni tach'a'o'alh, yu ixtamintachalh xalakaat'un Galilea, chi xalakaat'un Decápolis, chi jamacha'an Jerusalén, chi xalakaat'un Judea chi yu ixlitapiktutamcha ixtawilananchalh an ayxkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Akxni la'ts'ilhi li wanajcha lhilhuw an Jesús, tama'ast'alhcha a'stitawk'a, anchacha sa' tawlhchalh chi tala'cha'alhcha an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pus tsukulhcha jamasuniy, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Oxi para yu'uncha an yu la ixtakuwink'an tajakilhpatinijk'atsay, mu yu'uncha ixnawink'ani an lhich'alhkat an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Oxi para yu'uncha an yu talaj'alhun, mu yu'uncha kajama'oximaj'ayakana'. ");
INSERT INTO tpp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Oxi para yu'uncha an yu jantu ta'ayajk'atsay, mu yu'uncha, ix'anunk'ani kajuna an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Oxi para yu'uncha an yu sawalhcha talakask'in li ka'ilhtukalhi yu Dios lhinajun, mu yu'uncha kajama'an'achakana'. ");
INSERT INTO tpp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Oxi para yu'uncha an yu tajamapayninin, mu yu'uncha kajamapaynikana'. ");
INSERT INTO tpp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Oxi para yu'uncha an yu stalan'a ixjalhunutk'an, mu yu'uncha katala'ts'ina Dios. ");
INSERT INTO tpp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Oxi para yu'uncha an yu talhipuxkawniy li wa sa'cha katawlakalh, mu yu'uncha ixjas'at'an Diosi kajajunkana'. ");
INSERT INTO tpp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Oxi para yu'uncha an yu jalhimama'alh'ajnikan li ta'ilhtuy an yu lhinajun Dios, mu yu'uncha ixnawink'ani an lhich'alhkat an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Oxi para uxitnani akxni ixlakata li kilakiklaka'iyaw wa tani k'alhich'iwink'ana'itcha masi yu jantucha sawalh chi k'alhit'ama'ch'ap'uk'ana'it. ");
INSERT INTO tpp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","K'alaj'ach'ant'it, mu an yu k'alhajaxt'uya'it an lakt'iyan yucha ay chi wachu chuni jalhitama'chapukalh an yu p'ulhnajcha ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Uxitnan tachanu xamatsat ani lakaat'un. Pero li kama'ats'an'alhi is'o'onti an matsat, ¿tasicha kalhis'o'ocho'okana'a? Jantucha lay, pus yucha kamaj'ankanacha, chi wa tichicha kaputayaya'. ");
INSERT INTO tpp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Uxitnan xajatapulhkunun an lakamunulhpa'. La'atam la'acha'an yu a'stitawk'a wilhchalh jantu lay tats'e'a. ");
INSERT INTO tpp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chi jantu makilhnukani la'atam pumaklhku para li wa ka'a't'alh'ulakalhcha laka cajón, yucha muk'akancha tan talhman para li an yu tatanumanalh laka cha'a kajamapulhkunilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wachu chuni uxitnan, k'a'ilht'ut'iti li an mijatapulhkunuk'an katapulhkulhi la ix'ukxlakapuk'an an lapanakni, para li katala'ts'ilhi an yu oxi ilht'uyat chi katanawlhi li ayi an minPayk'an yu wilhchalh an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Jant'u kana'unt'it li sna ikmintacha ilhtunu li jantucha kalhitapalalhi an ixlamap'a'sin Moisés chi an tacha ixtamasuy an yu ixtalhichiwiniy ixchiwinti Dios, jantu yu ikla'minta. Kit'in ikminta muktaxtunu tuchini yu jumputuncha sawalh an lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kit'in sawalhi ani yu klajunaw, an lakt'iyan chi an lakaat'un, layi ka'ukla'olh. Pero masi wa la'atamcha punto u masi wa la'atamcha jats'o'nut jantu katima'osunikalhi an lhamap'a'sin, sta akxni kalaktapasa'oyacha yu kalaktapasaya'. ");
INSERT INTO tpp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xliyu li yu jantu ilhtuyi wa tanyuchacha tacha an najunta an lhamap'a'sin, masi yu wa lakat'ikt'icha lhamap'a'sin, chi chunchacha jat'alamasuniy an ali'in lapanakni, wanaj wa xalakat'ikt'i kajunkananta awint'i laka lhich'alhkat lakt'iyan. Pero yu ilhtuyi an lhamap'a'sin chi jat'alamasuniya an ali'in, yucha xa'ayi kajunkananta awint'i laka lhich'alhkat lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chi iklajunaw li jant'u jap'u'iniyat'iti an xamaestrojnin lhamap'a'sin chi an fariseojnin para palaycha oxi k'a'ilht'ut'it an yu Dios lhinajun, jant'u k'at'it'anuchi'it'iti an laka lhich'alhkat anu lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Asmatt'atcha li an yu ma'anchacha ixtat'ajun yu t'a ixjalhila'ts'inat'it jajunikalh: “Jant'u k'at'ijama'ninint'it, yu kajama'ninina yucha kalhitawk'aya an tala'alhin.” ");
INSERT INTO tpp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero kit'in klajunaw watichicha yu t'alama'talh'aman ixt'ala'ajun kalhimama'alh'ajnikana'. Chi watichicha yu kaxkayaj juna ixt'ala'ajun kalhimama'alh'ajnikana'. Chi yu kajuna ixt'ala'ajun, wa tontojk'at'i, yucha layi kamak'ankalh la xajikmi la'nin. ");
INSERT INTO tpp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Xliyu li lhit'ant'a mi lha'ulan tan ma'axta'kan ch'i anch'ach'a p'ast'ak'a li mint'ala'ajun talh'amniyan, ");
INSERT INTO tpp_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","k'amak'awi amilha'ulan an la ixlakapu an tan ma'axta'kan, chi k'ap'inchicha p'ulhnaj t'ala'oxamixnini amint'ala'ajun. Chi ixli'astan k'at'anch'o'oya'acha chi k'ama'anxt'a'a'acha amilha'ulan. ");
INSERT INTO tpp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Watukan k'at'alats'awalat'i li tu'u yu wa t'ala'ayan akxni laka tijka t'awnat, jantu junita kama'axta'niy amint'ala'ay la ixmakni juez, chi an juez kama'axta'niy la ixmakni an policia chi k'amalaklhchajuncha. ");
INSERT INTO tpp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kit'in sawalhi ani yu ijkunan li anch'a jant'u k'at'it'axt'u li jant'u map'alh'o'oy chux. ");
INSERT INTO tpp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Uxitnan asmatt'atcha li nawkalh li: “Jant'u k'at'it'at'amat'i yu jant'u t'at'a'un.” ");
INSERT INTO tpp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero kit'in klajunaw masi yu wa la'ts'inka xamati t'aku chi li sk'unla'ts'incha li wa laycha kat'atamalh, tachanu t'atamalhcha, mu pastaklhicha yu jantu oxi la ixjalhunut. ");
INSERT INTO tpp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Xliyu li sna an yu oxi mila'chulh ma'ilhtuyani tala'alhin, k'at'ap'axt'u ch'i k'amaj'acha. Mu palay oxi li wa lakats'uniy an milakatunaj k'ama'ats'an'at'i, walh jantu li chux an milakatunaj kamak'ankalh la'nin. ");
INSERT INTO tpp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chi li an yu oxi mimaka ma'ilhtuyani tala'alhin, k'ach'a'xmaj'a ch'i ma'atch'a k'amaj'a. Mu palay oxi li wa lakats'uniy kats'an'alh an milakatunaj, walh jantu li ta milhi'ay k'amak'ap'ink'a laka la'nin. ");
INSERT INTO tpp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Wachu nawpalakalh: “Wa tichicha yu kamakawna ixt'iwi, ka'ilhtulh la'atam jalhiki tan tasuy li kamakawnacha ixt'iwi'.” ");
INSERT INTO tpp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero kit'in klajunaw, wa tichicha lapanak yu makajun ixt'iwi, li jantu wa xamaticha t'atamalh, tachanu wa tisamaka'ancha apaliji li kat'atamalhcha xamati lapanak. Chi an yu t'atsukuy xamati t'aku yu makawkanta wachu tala'alhincha ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Atumpaj wach'uch'a asmatt'at'iti li jajunikalh an yu ma'anchacha ixtat'ajun: “Jant'u k'at'ijurarlat'i yu jant'u k'at'i'ilht'u sawalh. K'a'ilht'unini an Dios yu jurarlaniy li k'a'ilht'uniya'a.” ");
INSERT INTO tpp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero kit'in klajunaw: Jantu k'is tu'u k'ap'ujurarlat'it. Jant'u k'ap'ujurarlat'iti an lakt'iyan, mu ancha tan wilhchalh an Dios. ");
INSERT INTO tpp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ch'i jant'u k'ap'ujurarlat'iti an lakaat'un, mu ancha tach'atay. Ch'i jant'u k'ap'ujurarlat'iti an la'acha'an Jerusalén, mu yucha ixla'acha'an an ay Jamach'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chi ami'a'tsulh jant'u k'at'ip'ujurarna, mu jant'u lay k'at'i'ilht'u sut'ut'u u ts'iti masi wa ma'atamcha ami'ay. ");
INSERT INTO tpp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“Chun” u “jantu” wa k'ana'unt'it, mu yu palaycha wa t'ala'maka'ankan chiwinkan, tan jantucha oxi jatapast'ak'ati minachalh. ");
INSERT INTO tpp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Asmat'atcha li nawkalh: “Li xamati lakt'ilhiniy ixla'chulh apumatam wachu kalakt'ilhinikalh chi li xamati lakt'ilhiniy ixtatsalat apumatam wachu kalakt'ilhinikalh.” ");
INSERT INTO tpp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero kit'in klajunaw: Jant'u k'at'alasat'iti an yu sawalh ay junita. Apalij li xamati la'xtisayan mintala'xtitam, k'ala'xt'ip'inip'alhi an mintala'xtitam. ");
INSERT INTO tpp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chi li yu wa t'ala'ayan chi maxtuniyani mixkuju wach'u k'axt'a'nini aminkutun. ");
INSERT INTO tpp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chi li xamati asi malhi'aniyan tu'u tak'uk'at tam mil metro ixlima'at, la'at'uy mil metrojo k'at'alhip'i. ");
INSERT INTO tpp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yu sk'iniyani tu'u, k'axt'a'nin, chi yu mach'isk'iniyan tu'u, jant'u k'a'uni li jantu. ");
INSERT INTO tpp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Asmatt'atcha li nawkalh: “K'amap'ayniya'a wa tichicha mint'alapanak, pero yu mint'alaxkay, k'axk'aya'a.” ");
INSERT INTO tpp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero kit'in klajunaw: K'ajamap'aynit'iti masi yu jantu tala'ts'imputunan, uxitnan oxi kajaxa'alat'it an yu wa xkayaj tajunan, oxi k'ajala'ts'int'it an yu wa taxkayan chi k'ajalhit'ap'aynit'iti an yu wa talhitama'chapuyan, ");
INSERT INTO tpp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","para li chuncha k'a'unt'iti ixjas'at'an amimPayk'an yu wilhchalh anu lakt'iyan. Mu yucha ilhtuy li kataxtulh an wilhchan para ta lhichux, masi yu wa ay tajunita chi yu oxi lapanakni. Chi yucha makmin xkan para ta lhichux, para yu oxi lapanakni chi masi yu wa ay tajunita. ");
INSERT INTO tpp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mu li wa yu tat'alamapayniyani jat'alamap'ayniyat'it, ¿t'isunch'a k'ala'a'iya'it chuncha? ¿Chu jantu wanajcha chuni talay an yu talaklhach'inin tanlhun? ");
INSERT INTO tpp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chi li wa yucha amijat'ala'awnink'ani jala'axa'alayat'it, ¿t'anyuch'a yu t'amch'a ilht'uyat'iti? Wanajcha chuni talay an yu jantu tamispay Dios. ");
INSERT INTO tpp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Uxitnan ts'awjch'a k'ats'uk'ut, tacha ts'awj t'ajun amimPayk'an yu wilhchalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’K'ajalajk'ats'anant'it, jant'u k'a'ilht'ut'iti tanlhun yu oxi para li wa sawalhch'a k'ala'ts'ink'ant'it. Yu chuncha talay jantu tu'u kati'jaxta'nilh an yu wilhchalh lakt'iyan kimPayk'an. ");
INSERT INTO tpp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Xliyu akxni xt'a'a tu'u, jant'u k'ajamak'ats'aanin. Tacha talay ali'in an laka lakcha'a yu puta'ayxto'kan u an laka lajcalle, wa xliyu li wa oxicha kajalhichiwinkalh. Yucha klajunaw wa x'amani katala'a'iya'. ");
INSERT INTO tpp_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Uxint'i akxni xt'a'a tu'u, jant'u k'a'uni xamati masi yu sawalhch'a oxi t'alalhip'in. ");
INSERT INTO tpp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Para li jantu xamati kak'atsaalh li t'u'u xt'a'a, pero amimPay yucha la'ts'ini masi yu wa la'asa', pus yucha kaxta'niyani tu'u yu katala'ts'ina ali'in. ");
INSERT INTO tpp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ch'i akxni t'ap'ayniy jant'u k'alat'i tacha an yu wa talaycha, mu yu'uncha talaktayaycha an tan pula'ta'ayxto'kan cha'a chi an la ixla'ma'ats'astunuxni calle anchacha tatapayniy para li kajala'ts'inkalhcha. Yucha klajunaw wa x'amani katala'a'iya'. ");
INSERT INTO tpp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Uxint'i akxni t'ap'aynini amimPay yu jantu tasuy, k'at'ala'at'ich'awt'anut'i la mincha'a', mu yucha la'ts'ini masi yu wa la'a'sa', pus yucha kaxta'niyani tu'u yu katala'ts'ina ali'in. ");
INSERT INTO tpp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ch'i jant'u wa sawalhch'a a'lhuj, a'lhuj k'anawi yu na'un akxni t'ap'ayniy, tacha talay an yu jantu tamispay Dios, mu yu'uncha tanajun li sna chunchacha kaja'asmatnikana'. ");
INSERT INTO tpp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jant'u ch'uni k'alat'it tacha yu'uncha, mu an Dios yucha k'atsaycha t'uch'ini ma'lht'ask'iniyatcha masi jant'uk'a' sk'iniyat'it. ");
INSERT INTO tpp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Uxitnan ch'unch'uniya kat'ap'ayniya'it: Kimpay, uxint'i yu wilhchi lakt'iyan, aminta'a'ut stalan'a kala'ts'inkalh. ");
INSERT INTO tpp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kamakachilhi amilhich'alhkat. Ani lakaat'un chunchacha kawalh t'ach'a yu uxint'ich'a oxi lhiwilay, t'ach'a ilht'uyachi an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Akilaxta'niwi yu ak'uw chaway, yu lhilhij ikma'lhtask'iniyaw. ");
INSERT INTO tpp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chi akilamala'mixiniwi kintala'alhink'an tacha ijkamala'mixiniyaw wachu yu jantu oxi tu'u kinta'ilhtuniyan. ");
INSERT INTO tpp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Chi jantu akilamakajuwi li akintalhila'ts'intanukan, akilama'alhtaxtuwi tan jantu oxi, mu uxint'i ayk'at'i, chi uxint'i ch'alhk'atnan ch'i lhina'un, wa tawanancha kajuna'. ");
INSERT INTO tpp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Mu uxitnan li jamala'mixiniyat'iti yu ta'ilhtuniyan tu'u tala'alhin, wachu katamala'mixiniyani mintala'alhink'an amimPayk'an yu wilhchalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero li jant'u jamala'mixiniyat'it, wachu jantu katitamala'mixinini a mimPayk'an mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Ch'i akxni lhit'ask'ajay jant'u wa'in, jant'u wa t'ach'a t'a'oxila'alhiych'a k'alat'i, tacha talay an yu jantu ixlisawalh, mu yu'uncha chuncha talay ma wa kajala'ts'inkalhcha li talhitask'ajat'ajun ixwaytk'an. Yucha klajunaw jantu lhitapalay. ");
INSERT INTO tpp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Uxint'i akxni lhit'ask'ajay mi wayt, jant'u k'alhimasut'i, k'asp'uyj akt'u'uk'a ch'i k'ala'p'uch'a'acha. ");
INSERT INTO tpp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Para li jantu katala'ts'ini li lhit'ask'ajat'a'un mi wayt, pero amimPay yu wilhchalh lakt'iyan yucha la'ts'inan, pus yucha kaxta'niyani tu'u yu katala'ts'ina ali'in. ");
INSERT INTO tpp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Jant'u wa st'akch'a k'alhits'uk'ut'iti mintumink'an ani lakaat'un, mu ani talaj'ats'iya xatsapulh, chi laj'alhuni an tanlhun chi layi tapala'pusa yu ta'alhajuy. ");
INSERT INTO tpp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","K'alalhawat yu laj'oxi tanlhun an lakt'iyan, tan jantu laj'alhun chi tan jantu laj'ats'iy xatsapulh, chi tan jantu xamati ja'alhawana'. ");
INSERT INTO tpp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Mu t'anch'unch'a yu k'alhits'uk'uya'it laj'oxi mintanlhunk'an wachu ani katsukuya amijalhunutk'an. ");
INSERT INTO tpp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’An la'chulh yucha xamaklhku an lakatunaj, xliyu li amila'chulh oxi, chux amilakatunaj kalhitsuku'oya jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero li amila'chulh wa ay junita, chux amilakatunaj lakaputs'isni tan t'ajun. Xliyu li sna lakaputs'isni an t'an t'a'un, jantu tu'u yu ay lakaputs'isni alimpalay. ");
INSERT INTO tpp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Jantu xamati lay ixt'uyunk'an patronin jat'atapatsay, mu an pumatam jantu oxi katila'ts'ilh, chi an pumatam chun, u an pumatam kakiklaka'iya, chi an pumatam jantu. Jantu lay wa ayxtam t'atapatsakan Dios chi an tumin. ");
INSERT INTO tpp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Xliyu klalhijunaw: Jant'u k'alhak'ap'up'it'iti amijatsukuntik'an, t'uch'ini k'a'uya'itcha ch'i t'uch'ini k'a'ot'a'itcha, ch'i t'uch'ini k'ala'ch'iya'itcha la milakatunajk'an. Mu an jatsukunti palay lhitapalay, an wayt jantu, chi an lakatunaj wachu palay lhitapalay an la'ch'it jantu. ");
INSERT INTO tpp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","’K'ajala'ts'int'it an ts'o'on, yu'uncha jantu tach'an chi jantu tajax'anan chi jantu talhit'ajuni ixmulht'a'ak'an tan katama'alh ixjax'antik'an, walh an yu wilhchalh lakt'iyan mimPayk'an, jamaway. ¿Ch'u jant'u p'alay lhit'ap'alat'iti uxitnan chi an ts'o'on jantu? ");
INSERT INTO tpp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Chi masi sawalhch'a k'ajat'ap'ast'aknant'it, ¿tisiyuchacha lay k'is kalhimo'slaya ixta'ayati? ");
INSERT INTO tpp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Amila'ch'itk'an wach'u jant'u k'alhak'ap'up'it. K'ajala'ts'int'it an xanti tacha tata'ayay, yu'uncha jantu tatapatsay chi jantu tasiwnin. ");
INSERT INTO tpp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Walh an Salomón jantu a'tami chuncha oxi mala'ch'inilh tacha an xanti, masi yucha lhuwi ixlaklhit'ajun oxi ixlaktanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Chi li an Dios chuncha jamala'ch'iniy an jach'itin an tan wa jalhi'aycha tala'ajunta, chi lhiy jala'xawapalhkancha, ¿pus tasu li uxitnan jantu palaycha oxi katamala'ch'iniyani? ¡Wa jant'u t'uk'ancha k'iklak'a'iyat! ");
INSERT INTO tpp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Xliyu jant'uch'a k'ap'ast'akt'iti t'uch'ini k'a'uya'itcha, u t'uch'ini k'a'ot'a'itcha u t'uch'ini k'ala'ch'iya'itcha. ");
INSERT INTO tpp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yu chuncha talay yu'uncha an yu jantu tamispay Dios, pero uxitnan amimPayk'an anu lakt'iyan k'atsaycha t'uch'ini ma'lht'ask'iniyatcha. ");
INSERT INTO tpp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Yucha p'ulhnaj k'ap'uxka'ut an ixlich'alhkat Dios chi oxicha k'at'a'aklats'uk'ut, walh chux an ali tanlhun wa katat'axta'niyancha. ");
INSERT INTO tpp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","T'uch'a sawalh k'ap'ast'akt'iti yu para lhiyka', mu para lhiy ka'alina yu kalhakapu'ankana'. Tamin wilhchan lhimini yu lhilhakapu'at. ");
INSERT INTO tpp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Jant'u k'ajalhimuk'at'iti li tuchini ta'ilhtutacha ali'in para li an Dios wachu jantu katalhimuk'ani t'uch'ini ilht'ut'atcha uxitnan. ");
INSERT INTO tpp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mu t'ani jalhimuk'ayatcha an ali'in wach'u ch'uni k'alhimuk'ak'ana'it. Ch'i t'ani p'alhk'ananatcha, wach'u ch'uni k'ap'ulhk'ak'ana'it. ");
INSERT INTO tpp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chi t'asich'a li la'ts'iniycha an laktanun lakat'ikt'i jamakxtalh amint'ala'ajuni, chi uxint'i jant'u la'ts'ini an p'amj laktanuman a'tolo'ontawlhna'a? ");
INSERT INTO tpp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿T'asu li uniycha amint'ala'ajun: “Aklakpumaxtuyani an lakat'ikt'i jamakxtalh”? ¿Chi uxint'i jant'u la'ts'ini an p'amj laktanuman a'tolo'ontawlhna'a? ");
INSERT INTO tpp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Uxint'i wa na'uncha! P'ulhnajch'a k'alakp'umaxt'uk'a an p'amj laktanuman a'tolo'ontawlhana', walh ch'unch'a laych'a k'alakp'umaxt'uya'a an laktanun lakat'ikt'i jamakxtalh amint'ala'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Jant'u k'ajaxt'a'nit'iti yu ixnawin Dios an x'oyun, jantu junita katatala'asp'itchalh chi katalakts'ak'a'ulan. Ch'i jant'u k'ajaxt'a'nit'iti an p'axnin yu la'lhuw ixtapalh, jantu junita katalakputayalh. ");
INSERT INTO tpp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’K'ask'int'it, walh k'axt'a'nik'ana'it'it, k'ap'uxk'a'ut'it, walh k'ala'ch'ip'ina'it, ch'i k'ach'iwinint'it, walh k'amat'i'anik'ana'it. ");
INSERT INTO tpp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mu wa tichicha yu sk'in, xta'nikan, chi yu puxkajuy, la'cha'an, chi yu chiwiniy, mati'anikan. ");
INSERT INTO tpp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Mu jantu xamati lapanak li pumatam ixjas'at'a sk'iniy pan kaxta'nilhcha chiwx. ");
INSERT INTO tpp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","U li sk'iniy jatanti, kaxta'nilhcha tsapulh. ");
INSERT INTO tpp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pus masi ay unt'at'it layi jaxt'a'niyat yu laj'oxi tanlhun mi jas'at'ank'an, ¿tasicha li an yu wilhchalh lakt'iyan minPayk'an jantu palaycha kajaxta'niya laj'oxi tanlhun an yu task'iniya? ");
INSERT INTO tpp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Xliyu t'ach'a lak'ask'inat'iti li k'a'ilht'uk'ant'it, wach'u ch'uni k'aja'ilht'ut an ali'in, mu chuncha najun an ixlamap'a'sin Moisés chi an yu ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’An tan wa put'ikt'i malhticha k'ap'ut'anut'it, mu an tan pu'ay malhticha chi an tan pu'ay tij, ancha tan puts'an'akan, walh lhuwi yu ancha taputanuy. ");
INSERT INTO tpp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","An tan wa put'ikt'i maticha chi tan wa put'ikt'i tij, yucha yu pula'cha'ankan jatsukunti, walh wa lakats'uniya yu tala'cha'an. ");
INSERT INTO tpp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’K'ajalajk'ats'anant'it, mu katala'cha'anani yu jantu ixlisawalh ixchiwinti Dios talhichiwiniy. Tacha an borregojnin jantu ta'at'ajnani katalaya', pero ixpulaknik'an ma'tilin yu taja'unanan. ");
INSERT INTO tpp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Yu'uncha k'ajap'umisp'aya'it'it tani talaycha. Tacha a'atam k'iw, xajatawk'ati pumispakan. An uva jantu layi aktip'uxlicha lakalhtukunan chi an higo jantu layi aktip'uxlicha lakaxt'it'inaj. ");
INSERT INTO tpp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Watuchicha k'iw yu oxi, oxi tawk'aniy xajatawk'at, pero yu jantu oxi k'iw, wachu jantu oxi an xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","An yu oxi k'iw, jantu layi jantucha oxi xajatawk'at katitawk'anilh, chi an yu jantu oxi k'iw, jantu layi katitawk'anilhcha oxi xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wa tuchicha k'iw yu jantu oxi tawk'aniy xajatawk'at, ticha'xkan chi la'xawakancha. ");
INSERT INTO tpp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pus tani talaycha an ali'in chuncha k'ajap'umisp'aya'it'it. ");
INSERT INTO tpp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Jantu ixchuxk'ani katitacha'alh an tan ch'alhkatnan Dios, masi yu kintajuniy, Jamach'alhkat, Jamach'alhkat. Wa yu'uncha an yu ta'ilhtuy sawalh tacha an najun an kimPay yu wilhchalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Akxni ajkasakxtununacha, ixluwk'ani yu akintajuna: “Jamach'alhkat, Jamach'alhkat ¿chu jantu iklhichiwiniwi minchiwinti, chi ijkak'uch'uwi la minta'a'ut yu ixtala'apaxt'o'a makxkay'un chi tanlhuncha ali yu la'lhi'a'nini k'ilhtuw la minta'a'ut?” ");
INSERT INTO tpp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kit'in akxni ajkajuna: “Ix'ilhtunan tala'alhin, jantu iklamispayaw, k'ap'inchi'itcha.” ");
INSERT INTO tpp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yu asmat'a kinchiwinti chi ilhtuy, jalakpastaknan. Tachanu oxi yajuy an ixcha'a la ix'ukxni chiwx, ");
INSERT INTO tpp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","walh laniy masi kamilh p'as xkan chi kaja'a'muxtunulh chi kalalh p'as un, jantu katita'a'talhi an ixcha'a', mu an ixjach'aja chiwx. ");
INSERT INTO tpp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero yu ki'alha'asmat'a chi jantu ilhtuy, tachanu xamati lapanak yu wa tonto yu mach'atalh ixcha'a wa la ix'ukxni kukuj. ");
INSERT INTO tpp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Akxni milh p'as xkan, chi ja'a'muxtunulh chi lalh yu p'as un, p'asi talakanuchalh an laka cha'a', juluklh ta'a'talh wanaj talakt'ilhi'olh. ");
INSERT INTO tpp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Akxni chunchacha jajun'olh an Jesús, ixtalhi'a'niycha tacha an ixmasuy, ");
INSERT INTO tpp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mu yucha ixjamasuniy tacha yu lhit'ajun lhich'alhkat sawalh, jantu wa tacha an xamaestrojnincha lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Akxni ta'alhtajucho'olhcha an a'stitawk'a an Jesús, lhilhuwi ixch'a'o'akanta. ");
INSERT INTO tpp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chi tichiyucha lapanak la'cha'alhcha an Jesús, wanajcha ixlakap'uch'i'ojota, chi tatso'ottanilhcha la ixlakapu, juniy: ―Jamach'alhkat Jesús, li sna ak'ink'uch'up'ut'u, ak'ink'uch'ut'ika'. ");
INSERT INTO tpp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","An Jesús lats'awalalhi an ixmaka chi lakpach'apachalhcha, juniy: ―Chun, k'at'ala'a'oxit'icha. Wa akxni wak tala'a'oxilh. ");
INSERT INTO tpp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Wa chuncha an Jesús juniy: ―Jant'u xamat'i k'a'un wa k'ap'inchicha talakasunini an sacerdote, chi k'alhip'ina'acha milha'ulan tacha lhinawlh a Moisés, para li katak'atsaa'olhi an sacerdotejnin. ");
INSERT INTO tpp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Akxni cha'alhcha la'acha'an Capernaúm an Jesús, ancha la'cha'alh pumatam ixcapitank'an soldadojnin de Roma, an capitán ixtapayniniycha an Jesús, ");
INSERT INTO tpp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ixjuniy: ―Jamach'alhkat Jesús, an kima'tsuku wa lakalhtukulun, p'asi ta'an'ay, wa malhcha an kincha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","An Jesús juniy: ―Ak'ana k'uch'unu'. ");
INSERT INTO tpp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero an capitán juniy an Jesús: ―Jamach'alhkat Jesús, jantu k'is ikt'acha'ani li k'at'anuchi an kincha'a', wa k'anawcha sta aniya li kata'oxiya, kata'oxiyacha. ");
INSERT INTO tpp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ijk'atsay, mu iklhismanita akxni tu'u kintalhijuniy an yu palaycha xalaj'ajin. Chi kit'in akxni xamati soldado ijkuniy li ka'alh inta, an, chi li kamilh, min. Chi li tu'u iklhijuniy an kima'tsuku, ilhtuy. Xliyu iklhik'atsay li uxint'i layi ka'una'a an ta'an'at li kamakawlhcha an kima'tsuku'. ");
INSERT INTO tpp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","An Jesús, lhi'a'nilhcha akxni chunchacha alha'asmatlhi, chi jajuniy an yu ixtach'a'o'ata: ―Jantu xamati masi an xalakaat'un Israel akla'cha'alh xamati yu chuncha jakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pero chunchacha yu katapasaya', ta ixlijalhi'ay an lakamunulhpa kata'alina lapanakni tacha ani capitán yu katat'a'ana tawlhnin an Abraham chi an Isaac chi an Jacob, an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Chi apalij an yu ancha ixta'alh tawlhnin, kajamak'ankana ma'spa tan lakaputs'isni, ancha kastak laj'alhunkana chi wa xwat'at'acha kalaktasat'awkana'. ");
INSERT INTO tpp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wa chuncha an Jesús juniy an capitán: ―K'ap'inch'o'ochicha, t'ach'a an k'iklak'a'it'i chunchacha walh. An ixma'tsuku wa akxni ta'oxilh. ");
INSERT INTO tpp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","An Jesús la'cha'alhi la ixcha'a an Pedro, walh an ixput'icha'o'olh Pedro ixmalh la ixputamat, wa stakcha ixch'apata yu alhp'as iskakat. ");
INSERT INTO tpp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pus an Jesús ma'ch'apachalh, walh makawlhi an alhp'as iskakat, chi ostayacho'olhcha tsukulhcha jamaway. ");
INSERT INTO tpp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chi akxni tats'isilhcha lhuwi jalhicha'anikalh an Jesús yu wa ixtalakpach'apay makxkay'un chi yu wa ixtala'ta'an'ay, walh wanaj jak'uch'u'olhi la ixchiwinti. ");
INSERT INTO tpp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chunchacha tapasalh para li kawalhi tacha an ixnajunta Isaías, yu ixlichiwiniy ixchiwinti Dios, akxni nawlh: “Yucha lhi'an'olh an kinta'an'atk'an chi an kima'alh'ajnatk'an.” ");
INSERT INTO tpp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Mu la'ts'ini an Jesús li lhilhuwi ixla'acho'oyanikalh, pus jajuniy an ixt'alhtanan li an ixtapiktutamcha lakxkani kata'alh. ");
INSERT INTO tpp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pumatam an yu ixtalajk'atsay lhamap'a'sin la'cha'alh, juniy: ―Maestro Jesús, wa t'anch'unch'a k'ap'ina'a akt'a'anan. ");
INSERT INTO tpp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","An Jesús juniy: ―An zorrajnin talhit'ajuni ixcha'ak'an chi an ts'o'on talhit'ajuni ixpamaj'ank'an. Pero kit'in yu ikwalh isTs'alh Lapanak jantu inta ikmast'ak'ay ki'a'tsulh. ");
INSERT INTO tpp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Pumatam ixt'alhtana jumpalay: ―Jamach'alhkat Jesús, kachajcha p'ulhnaj ikti'an maknunu an kimpay. ");
INSERT INTO tpp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","An Jesús alhtaylh: ―Ak'inch'a'o'acha. K'amak'awcha, kachajcha tamaknulhi ixjaninink'an an janinin. ");
INSERT INTO tpp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","An Jesús tat'atajulhcha an ixt'alhtanan an laka barco. ");
INSERT INTO tpp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Walh an lakxkan tsukulhcha lay p'as un, chi p'as xkan, wa milh, milhcha ixlayi an lakxkan, an barco ixtalak'aknuputuncha. An Jesús ilhtatay. ");
INSERT INTO tpp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pus tala'alhi an ixt'alhtanan tamakujulh, tajuniy: ―¡Jamach'alhkat Jesús, akilama'alhtaxtuw ka aklakniyawcha! ");
INSERT INTO tpp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yucha jajuniy: ―¿T'asu li lakt'alhananatcha? Jantu ayi mijakiklaka'intik'an. Wa chuncha, an Jesús tayalh chi jalaj'aymalhi an un chi an alamalh, pus wanaj sa' tatawilh. ");
INSERT INTO tpp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Pus an lapanakni ixtalhi'a'niycha, ixtalajuniy: ―¿Tisiyuchacha lapanaki aniya, li masi an un chi an alamalh ta'asmatniya? ");
INSERT INTO tpp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Akxni an Jesús cha'alhcha an ixtapiktutam lakxkan, la ixlakaat'unk'ancha yu jamacha'an Gadara, japaxto'lhi ixt'uyunk'an yu ixtala'apaxto'ta lakmakxkay'un. Kampusantojo ixtaminachalh, sawalhcha ixta'at'ajnan, jantu lay k'is xamati ixpula'pusa ancha. ");
INSERT INTO tpp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tajuniy an Jesús: ―¿Tasicha kla'ilhtuyawi Jesús, isTs'alh Dios? ¿Kilamintawcha mama'alh'ajninini masi jantuka' ixpaku'? ");
INSERT INTO tpp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lanan ma'at an tan ixtayanalh yu'uncha, lhuw p'axnini ixta'exwayt'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pus tatapayniniycha an Jesús an lakmakxkay'un, tajuniy: ―Li akilatamakxtuyaw akilamakawniw ajkaputanuw an p'axnin. ");
INSERT INTO tpp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","An Jesús yucha jajuniy: ―K'ap'inchi'itcha. Pus tamakawlhcha an lapanakni, yu'uncha an p'axnincha taputanulh. Walh an p'axnin jululu ta'an'olh tan wanaj a'talhman la ixpiktu an lakxkan chi tata'aj'aju'olh talaj'aksk'anj'u'olh. ");
INSERT INTO tpp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","An yu ixtalhist'ak'a an p'axnin, watukan talakats'alaj'alhi an la'acha'an, ixtalaknajuncha tani tapasalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pus wanaj tala'cha'an'olhi an Jesús, chi sa'cha ixtala'ts'in, chi tatapayninilhcha li kataxtucho'olhcha an la ixlakaat'unk'an. ");
INSERT INTO tpp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wa chuncha tajulhcha laka barco an Jesús, tapiktutamcha alh, la ixla'acha'ancha cha'alh. ");
INSERT INTO tpp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ancha tach'ixlicha'anilh la ixputamat pumatam yu ixlakalhtukulunta. Chi jala'ts'incha li tajakiklaka'inin, pus juniy an yu lakalhtukulunta: ―Oximaj'ayi k'a'unt'i, kints'alh, amintala'alhin ikmala'mixini'oyan. ");
INSERT INTO tpp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wa chuncha ali'in xamaestrojnin lhamap'a'sin yu ancha ixtayanalh ixjapula'chiwinkancha, ixtanajun: “Ani wa aya juniya Dios.” ");
INSERT INTO tpp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Walh an Jesús yucha ixjak'atsaaniycha tanischa ixtapast'ak'a, pus jajuniy: ―¿Tasu li wa aya jat'ap'ast'aknanatcha? ");
INSERT INTO tpp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tampiyuchacha yu palay wa las aknawlh: “Ikmala'mixini'ojoncha mintala'alhin”, u aknawlh: “Kat'aycha, k'ap'inchicha”? ");
INSERT INTO tpp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Para li k'ak'ats'at'iti li an isTs'alh Lapanak layi kamala'mixiya tala'alhin ani lakaat'un (junilhcha an yu ixlakalhtukulunta): K'a'ost'aycha, k'asakt'icha amimputamat, k'ap'inch'o'ochicha mincha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Wa chuncha ostayalhcha an yu ixlakalhtukulunta, alhcha la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pus an lapanakni sawalhcha ixtalaktalhanajlhi'a'niy, ixtalaknajuncha li an Dios ay sawalh, chi li yucha jaxta'niya an lapanakni ix'alhp'asninti para li lay kata'ilhtulh tu'u'. ");
INSERT INTO tpp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tan ixla'pust'ajun an Jesús la'ts'ilh pumatam lapanak ixjunkan Mateo, sa' ixwilh tan ixjach'inin ixlakata yu lakmapalhlhi'ankan tanlhun, juniy: ―Ak'int'ap'it'icha. Pus yucha tayalh, t'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","An Jesús ali an ixt'alhtanan jat'alakwaylhi la ixcha'a an Mateo, chi ixluwk'an an yu wachu ixtalaklhach'inin tanlhun wachu ani ixtama'wilanalh, chi ali'incha ma'lhta'alhinin. ");
INSERT INTO tpp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Walh an lapanakni yu ixjajunkan fariseojnin akxni tala'ts'ilhi an Jesús, tat'alajuniy an ixt'alhtanan: ―¿Tasu li amimaestrojk'an jat'alakwajini an yu tajach'inin chi an la'ma'lhta'alhinini? ");
INSERT INTO tpp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","An Jesús asmatlhi, pus jajuniy: ―Yu oxi tat'ajun jantu tama'lhtask'iniya jak'uch'unu', pero an yu tata'an'ay, chun. ");
INSERT INTO tpp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","K'ap'inchi'it laninini tuchini nawputuncha an tan najunta: “Lamapayniti iklakask'in, jantu ixma'nika jatapakxat.” Mu k'it'in jantu ikminta jat'asanini an yu oxi tat'ajun. K'it'in ikminta jat'asanini an yu ta'ilhtuy ixtala'alhink'an, para li jantucha ali kata'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","An ixt'alhtanan an Juan tala'cha'alh an Jesús, tajuniy: ―¿Tasu li kitnan chi an fariseojnin a'lhuwi iklhitask'ajayaw kiwaytk'an chi amint'alhtanan jantu chuni ta'ilhtuyi? ");
INSERT INTO tpp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yucha jajuniy: ―Jantu layi katitala'ta'oxila'alhilhcha li yu tat'ajun tan tama'xto'kan chi li ancha jat'a'aklat'ajun an yu tama'xt'o'a. Pero kamina wilhchan kajama'osunikana an yu tama'xto'lhi, pus akxni chun wachucha katalhitask'ajaya ixwaytk'an an yu jat'awaykan chaway. ");
INSERT INTO tpp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Jantu xamati lhila'ts'ap'an sast'i la'ch'it yu at'ilhcha la'ch'it, mu an yu sast'ika la'ch'it tala'atumiy, pus palay ta'exa an yu at'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chi wachu jantu pumukani yu laj'at'ilhcha jaxt'a'an yu sast'ika xaxkan uva, mu an jaxt'a'an tatan'exa chi pu'an'ojoy. Chi an jaxt'a'an ts'an'aycha. Yu sast'ika xaxkan uva laka sast'i jaxt'a'ani mujukan, chuncha wa tamcha talhitayaniy. ");
INSERT INTO tpp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Chunchaka ixjajunt'ajun an Jesús, la'cha'alh pumatam xa'ay lapanak chi tatso'ottanilhcha, juniy: ―An kintsi wa nilhka', ak'int'ap'it'i la'ts'ini', k'alakp'ach'ap'aya'a, walh kala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pus talaktayalhi an Jesús ali an ixt'alhtanan chi tat'a'alhcha an lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Walh pumatam t'aku yu la'akawt'uycha k'ata ixta'an'ay, wa ixmaj'an ixjak'alhni, ch'a'o'ayawlh, la ix'a'lhch'a pupiktuch'apanichalh an ixla'ch'it. ");
INSERT INTO tpp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Mu an t'aku ixpast'ak'a, ixnajun: “Masi wa yucha an ixla'ch'it akch'apanichalh aktak'uch'uya'.” ");
INSERT INTO tpp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pus an Jesús, tala'asp'itlhi sa'cha la'ts'in, juniy: ―Jant'u k'at'a'oxila'alhit'i, kintsi', amijakiklaka'inti p'ut'ak'uch'ut'icha. Wa akxni ta'oxilhcha an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chi akxni tanuchalhcha an Jesús la ixcha'a an xa'ay lapanak, jala'ts'incha an yu ixtala's'oliy laka s'olh chi an ali'in wa t'ililicha ixtalhilaj'alhuni an jatsi'. ");
INSERT INTO tpp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Pus jajuniy: ―K'ap'inch'o'ochi'itcha, ani jatsi jantu nita, wa lhtatay. Pero yu'uncha wa ixtalhits'i'in. ");
INSERT INTO tpp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wa chuncha akxni jatamakxtu'okalhcha an yu ixtatanumanalh pulakni, an Jesús tanulhcha tan ixmalh an jatsi', chi ma'ch'apachalh, ostayalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Wanajcha lajk'atsa'okalhi ta ixlijalhi'ay anchunu lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Akxni ixti'ancho'oycha an Jesús, ixt'uyunk'an la'la'lhtulu'un lapanakni tach'a'o'ayawlh, p'ascha tajuniy: ―¡Ists'alh David, lamapaynin, akilalhi'a'tayjuw! ");
INSERT INTO tpp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tat'acha'alhi tan ixtawlay laka cha'a an Jesús. Pus jajuniy: ―¿K'iklak'a'iyat'iti li layi aklak'uch'uw? Yu'uncha tajuniy: ―Chuni, Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wa chuncha yucha jalaklakpuch'apalhcha, chi jajuniy: ―T'ach'a yu jak'iklak'a'ininatcha chunchacha kawalh. ");
INSERT INTO tpp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wakcha tajalakawanalh. Chi an Jesús jajuniy li jantu k'is xamati katajunilh. ");
INSERT INTO tpp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero yu'uncha akxni ta'alhcha, tsukulhcha talaknajuni chux an la'acha'anaxni. ");
INSERT INTO tpp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Akxni ta'alhcha an yu jantu lay ixtajalakawanan, talhicha'anipalh pumatami an Jesús yu wa ixla'apaxto'ta makxkay'un, jantucha lay ixchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pero akxni tamakxtulhcha an Jesús an makxkay'un la ixlakatunaj an lapanak, tsukulhcha chiwiniy. Pus an yu tala'ts'in ixtalhi'a'niycha, ixtalaknajun: ―¡Jantu a'tam chuncha la'ts'inkanta ani xalakaat'un Israel! ");
INSERT INTO tpp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Walh an lapanakni yu ixjajunkan fariseojnin, tanajun: ―Xliyu lay jalhitamakxtuy, mu yucha an xapay makxkay'uni t'atapatsay. ");
INSERT INTO tpp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ixkilajkila'ojoyi an Jesús an laj'ay la'acha'anaxni chi tan wa lakt'ikt'i, ixjamasuniycha an tan ixtala'ta'ayxt'o'a lapanakni an laj'oxi chiwinti yu ixlich'alhkat Dios, chi ixk'uch'uyi wa tuchicha ta'an'at, chi wa tuchicha ixma'alh'ajnatk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","An Jesús ixjala'ts'incha li jantu xamati ixjalhist'ak'a an lapanakni, pus ixjamapayniycha. Wa tacha wa tilhcha ixta'a'pitsinin borregojnini ixtat'ajun, yu jantu xamati jalhist'ak'a. ");
INSERT INTO tpp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pus jajuniy an ixt'alhtanan: ―An tapatsat wanaj lhuw, walh an yu tatapatsay jantu ixluwk'an. ");
INSERT INTO tpp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","K'at'ap'ayninit'iti an yu jamanawin an tapatsat para li kajamakmilh aliy yu katatapatsalh. ");
INSERT INTO tpp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jat'asanilhi an ixpumakawt'uyk'an ixt'alhtanan an Jesús chi ja'ilhtulhcha li lay katak'uch'ulh an wa tala'apaxt'o'a makxkay'un chi wa tuchicha ta'an'at, chi wa tuchicha ma'alh'ajnat. ");
INSERT INTO tpp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","An ixpumakawt'uyk'an ixt'alhtanan yu'uncha an: Simón, yu ixjumpalhkan ma Pedro, chi Andrés ixt'ala'ajuncha ani Pedro, chi Jacobo chi Juan ists'alan tichiyucha lapanak ixjunkan Zebedeo, ");
INSERT INTO tpp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","chi Felipe, chi Bartolomé, chi Tomás chi Mateo, yu ixma'ach'inin, chi Jacobo, ists'alh tichiyucha lapanak ixjunkan Alfeo, chi Lebeo yu ixtajumpalay Tadeo, ");
INSERT INTO tpp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","chi Simón, yu ma'partido Cananista ixjunita, chi Judas Iscariotejcha, yu an ma'axta'lhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ani ixpumakawt'uyk'an, an Jesús jamap'a'silhcha chi jamala'achalhcha, jajuniy: ―Tan tawilanalh yu jantu judiojnin jant'u k'at'ip'it'it, chi tan tawilanalh an jamacha'an Samaria wachu'. ");
INSERT INTO tpp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yuch'a k'ajak'ip'uxk'a'ut an yu judiojnin, yu'uncha tachanu tats'an'ata borregojnin. ");
INSERT INTO tpp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","K'ap'inchi'it chi k'aja'unit'iti li an ixlich'alhkat Dios waniycha t'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","K'ajak'uch'ut'iti an ta'an'anin, chi an yu wa talaklakap'uch'ita, k'ajamala'awnit'iti an janinin chi k'ajak'uch'ut'iti an yu wa tala'apaxt'o'a makxkay'un. Ch'i t'ach'a jant'u map'alat'iti li laych'a jak'uch'ununat la ixtalakask'i Dios, wach'u jant'u k'alhach'inint'it. ");
INSERT INTO tpp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Jant'u k'alhip'it'iti oro, chi plata chi cobre, ");
INSERT INTO tpp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","chi bolsa yu t'u'uch'a k'ap'ulhip'it'it laka tij. Jant'u k'alhip'it'iti alht'uy mila'ch'itk'an chi miwarachijk'an chi mimpalikk'an, mu yu tapatsay kaxta'nikana wayt chi watuchicha ma'lhtask'iniy. ");
INSERT INTO tpp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Chi wa t'anch'unch'a k'ach'ip'ina'it ay la'acha'an u tan wa lakat'ikt'i, k'ap'uxk'awya'it ixcha'a xamati yu oxi lapanak ch'i wa anch'ach'a k'at'awla'it, sta akxni k'ap'inch'o'oya'itcha lakatam la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Li akxni t'anuyatcha an laka cha'a para li lay anch'a k'at'amak'a'unt'it, k'ajala'axa'alanant'it. ");
INSERT INTO tpp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chi li an yu ancha tawilanalh laka cha'a tat'acha'ani li katala'a'ilh an oxi jatawlhnat, anchacha katamakawna', pero li jantu, jantu katitamakawlh. ");
INSERT INTO tpp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Li inta la'acha'an u laka cha'a jant'u la'a'ik'anat'it ch'i jant'u asmatnip'ut'unk'anat'iti minchiwintik'an, k'at'axt'ut'it chi k'alakch'ank'alhap'uxk'ant'iti an po'xmi. ");
INSERT INTO tpp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Anchunu la'acha'an u laka cha'a o'sliyancha li palay kaxta'nikana lhima'alh'ajna akxni kajasakxtununa an Dios, walh masi palay jantu an xalakaat'un Sodoma chi an xalakaat'un Gomorra. ");
INSERT INTO tpp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Kit'in klamak'anaw tacha borregojnin tan t'o' tat'ajun ma'tilin. La's'alalani k'a'unt'it tacha tsapulin, pero jant'u k'a'ayajk'ats'at'it, tacha palomajnini k'a'unt'it. ");
INSERT INTO tpp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","K'as'alajnant'it, mu an lapanakni katalhi'anan laka lakjamach'alhkat chi an tan tata'ayxt'o'a lapanakni k'alaj'ayna'k'ana'it'it. ");
INSERT INTO tpp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chi masi la ix'ukxlakapuk'an laj'ay jamach'alhkatni chi rejnin k'alhip'ink'ana'it'iti kilakata. Akxni lay k'ajalhixa'alaya'it'it an kinchiwinti yu'uncha, chi an yu jantu tajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Akxni ma'axt'a'k'anat'it, jant'u k'alhak'ap'up'it'it'i t'ani k'anawna'itcha. Yucha an Diosi katamapast'ak'aniyan t'ani k'anawna'itcha akxni k'alhisakmik'ana'it. ");
INSERT INTO tpp_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Jantu mijatapast'ak'atk'ani an yu k'at'ina'unt'it, yucha an ixtakuwin Diosi katapuchiwininan. ");
INSERT INTO tpp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Katalama'axt'a'a masi wa lhit'ala'awnin laka lhinin, chi an xapay kama'axt'a'a masi ists'alh, chi an xajas'at'an katat'ala'aya an ixlakpaynink'an, chi katama'niya ixlakpaynink'an. ");
INSERT INTO tpp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ta lhichux k'axk'ayk'ana'it'iti kilakata, pero yu kalhitayaniya sta akxni ka'ukla'oya, yucha kata'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Akxni ch'a'o'ak'anat inta la'acha'an, lakatami k'a'osp'it'it. Mu an isTs'alh Lapanak kaminacha akxni masi jantuka' stunij k'ilajk'ila'oyat an xala'acha'anaxni Israel. ");
INSERT INTO tpp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Pumatam jatalanini jantu yu palay k'atsay, yucha an ixmaestro, chi tam ma'tapatsan yucha an ixpatrón. ");
INSERT INTO tpp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","An jatalanini ka'achalhcha li tacha an ixmaestrojcha jalakpastaknan chi an ma'tapatsan li tacha an ixpatroncha tapatsay. Li tajuniy xapay makxkay'un an lapanak yu la'ts'ilhi'an tani lhiwilakalhcha la ixcha'a, ¿tasu jantu palaycha kajajunkana yu tawilanalh la ixcha'a'a? ");
INSERT INTO tpp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Pero jant'u k'ajat'alhamnit'iti an yu chuncha talay, mu wa tuchicha yu jantu k'ats'akan kak'atsakana', chi yu wa la'asa', wachu kak'atsakana'. ");
INSERT INTO tpp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yu lakaputs'isni klajunaw, tan putunkuwi k'ana'unt'it, chi yu wa laksniy asmat'at, p'asi k'ana'unt'it sta la ixlaj'a'sti cha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jant'u k'ajat'alhamnit'iti an yu tama'niy lakatunaj, mu yu'uncha jantu lay tama'niya an takuwin. Yucha an Diosi k'at'alhamnit'it, mu yucha layi ma'niy an lakatunaj chi an takuwin laka la'nin. ");
INSERT INTO tpp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Tasuncha tapalay la'at'uy ts'o'on? ¡Jantu la'lhuw! Walh an Dios yucha k'atsayi akxni patajuy masi wa la'atamcha. ");
INSERT INTO tpp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Chi yucha k'atsayi tani ma'achuxcha lhit'awnat mi'ayk'an. ");
INSERT INTO tpp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Xliyu jant'u k'alakt'alhanant'it, mu palay lhit'ap'alat'it, walh jantu masi lhuw ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Watichicha yu kajajuna an lapanakni li kimispay wachu ajkuna an kimPay anu lakt'iyan li ikmispay. ");
INSERT INTO tpp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero yu kajajuna li jantu kimispay, wachu ajkuna an kimPay anu lakt'iyan li jantu ikmispay. ");
INSERT INTO tpp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Jant'u k'ana'unt'it li sna sawalhcha oxi katawlhkana li ikmintacha ani lakaat'un. Kit'in jantu ikminta li sawalhcha oxi katawlhkana', iklajunaw kala'aykana'. ");
INSERT INTO tpp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mu ikminta jamalasanini an lapanakni, an xapay kat'ala'aya an ists'alh chi an jatsi yucha an ixnati, chi an xaput'i yucha an ixput'icha'o'olh. ");
INSERT INTO tpp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lakatam laka cha'a wa siya yu'unchacha katalaxkaya'. ");
INSERT INTO tpp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Yu palay mapayniya ixpay chi ixnati, chi kit'in jantu, jantu t'acha'ani lay akinch'a'o'alh. Chi yu palay mapayniya ists'alh u istsi, wachu jantu lay akintich'a'o'alh. ");
INSERT INTO tpp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yu jantu xa'a'iya ixcruz yu lay kapuma'nikalh chi jantu kinch'a'o'aputun, wanajcha chun, jantu lay akintich'a'o'alh. ");
INSERT INTO tpp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yu sawalhcha lhakapu'ani an ixjatsukunti, kama'ats'an'aya', pero yu kama'ats'an'aya an ixjatsukunti kilakata, kalhitsukuya ixjatsukunti. ");
INSERT INTO tpp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Yu tala'a'iyan, kit'ini kila'a'iy. Chi yu kila'a'iy, yucha an yu kimakminta la'a'iy. ");
INSERT INTO tpp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Li xamati la'a'iy pumatam yu lhichiwiniy ixchiwinti Dios, wachu chuni kamapalhnikana tacha kamapalhnikana ani yu lhichiwiniy ixchiwinti Dios. Chi yu la'a'iya xamati yu oxi lapanak wachu chuni kamapalhnikana tacha kamapalhnikana ani yu oxi lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chi wa tichicha masi wa tamcha vaso ts'uk'unk'u xkan kat'a'ot'a masi yu wa xalakat'ikt'icha kint'alhtana, yucha o'sliyajcha li kamapalhnikana'. ");
INSERT INTO tpp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Akxni jamap'a'si'olhcha an ixpumakawt'uyk'an ixt'alhtanan an Jesús, yucha alhcha masunu chi alhcha lhichiwiniy an ixchiwinti Dios an la'acha'anaxni yu lak'alin anchunu lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Chi an Juan ixlaklhchajuy laka pulach'in, walh an Juan k'atsaalhi tuchini ix'ilhtuycha an Jesús, pus jamala'achanilh ixt'uyunk'an ixt'alhtanan, ");
INSERT INTO tpp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para li katalhisakmilhi li yucha yu kamina u katapakxan'ipala pumatam. ");
INSERT INTO tpp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","An Jesús ja'alhtaylh, jajuniy: ―K'ap'inchi'itcha mak'atsaaninini an Juan t'acha ani asmat'at ch'i t'ach'a ani la'ts'inat. ");
INSERT INTO tpp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Li an la'la'lhtulu'un tajalakawanancha, chi an lakch'anlht'ulukun, talakalhtanancha, an yu ixtalaklakap'uch'ita, tala'tala'a'oxilhcha, an laj'a'atapan, taja'asmatnancha, an yu ixtalaknitacha, jala'mala'awnicho'okalh, chi an jakilhpatinin jamak'atsaanikancha an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chi oxi para yucha yu jantu akintiputa'a'talh. ");
INSERT INTO tpp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Akxni ta'ancho'olhcha an ixt'alhtanan jama'paxanaj Juan, an Jesús tsukulhcha jalhixa'alayi an lapanakni an Juan, jajuniy: ―¿T'isunch'a k'ila'ts'int'it an tan wa jasa'nik'a? ¿Ma'atam ts'a'am yu ixmalaklay un? ");
INSERT INTO tpp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿T'isunch'a k'ila'ts'int'iti? ¿Pumatam lapanak yu sawalhcha k'usi ixmala'ch'ininta? Yu k'usi tala'mala'ch'inin la ixcha'ak'an rejnini tawilanalh. ");
INSERT INTO tpp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pero uxitnan, ¿t'isunch'a k'ila'ts'int'iti? ¿Pumatam yu lhichiwiniy ixchiwinti Dios? Chun, yucha sawalh, walh jantu wa yuchacha lhilakatijtami la'minta. ");
INSERT INTO tpp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mu ani jama'paxanaj Juan yucha an yu lhichiwininta la ixchiwinti Dios, tan najunta: P'ulhnaj akmak'ana yu ka'ana lhichiwiniy an kinchiwinti para li kamala'asijnilhi mintij. ");
INSERT INTO tpp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","An Juan xa'ay, jantu xamati ixt'achun kajumpalh an yu wa anicha t'awkan lapanakni yu wachu wa t'aku pula'ajun, pero awint'i la ixlich'alhkat Dios masi yu wa xalakat'ikt'i, palay xa'ay, an Juan jantu. ");
INSERT INTO tpp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sta akxni chilhcha an jama'paxanaj Juan, sta chaway, an ixlich'alhkat Dios anu lakt'iyan sawalhcha lhilaxtukukan, chi wa yucha an yu la'jo'atni lay tacha'an ancha. ");
INSERT INTO tpp_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ixchuxk'an an yu p'ulhnajcha talhichiwinilh ixchiwinti Dios, chi an ixlamap'a'sin Moisés, talhichiwinilh li kamina an ixlich'alhkat Dios, sta wa akxni chilhcha an Juan. ");
INSERT INTO tpp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Li lhiwilayat'it, yucha anicha yu Elías an Juan, yu ixnawkan li kamina'. ");
INSERT INTO tpp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yu lhit'ajuni ixpa'asmatna ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Chi chaway yu ani panch'e'ex t'awnat'it, ¿tasicha aklalhimalakxtuwi?, wa tacha an jas'at'ancha an yu talaj'amanan ixtan'ajni an la'acha'an, akxni talaxa'alay p'as, chi talajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Klala's'olhniwcha laka s'olh ch'i jant'u lak'at'ininat'it, chi klamilhpaniyawcha yu wa lhita'oxila'alhikan, walh ch'i jant'u laj'alhunat'it.” ");
INSERT INTO tpp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mu kilachilhcha an Juan, yu jantu wa ixwaytcha ixlilata u wa sawalhcha ka'otlhi tu'u', chi chuncha ixtajuniy li makxkay'uni ixlakpach'apata. ");
INSERT INTO tpp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chi ixli'astan milhcha an isTs'alh Lapanak yu ixjat'alakwajin chi ixjat'alaj'ot'a xaxkan uva an yu ixtalaklhach'inin tanlhun chi an la'ma'lhta'alhinin, chi chuncha ixtajumpalay li yu'uncha ix'amigojnin, chi li wa sawalhcha wajin chi li wa sawalhcha ot'a xaxkan uva. Pero yucha an ixjatapast'ak'atcha kintamasuniyan li yucha sawalh, ixlakata tacha an ixjatsukuntik'an an ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wa chuncha an Jesús tsukulhcha jajuniya an la'acha'anaxni tan lhuw ixjak'uch'ununta li jantu k'is taja'asmatnan, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡K'ap'ulhik'ats'aya'a la'acha'an Corazín! ¡K'ap'ulhik'ats'aya'a la'acha'an Betsaida! Mu li an la'acha'an Tiro chi an la'acha'an Sidoni ixlaktapasalh tacha an laj'oxi tanlhun laktapasalh an t'an wilat'it, ma'anchacha ixtaja'asmatnalh, ixtala'la'ch'ilhi laklhwat'aka ixla'ch'itk'an chi ixtalaktawilhi laka lhk'ak'a. ");
INSERT INTO tpp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Xliyu klalhijunaw li akxni kachinacha panch'e'ex kanawkana tanchuncha ka'ana atamj atamj, p'alay k'ama'alh'ajnana'it, an la'acha'an Tiro chi Sidón jantu. ");
INSERT INTO tpp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chi uxint'i la'acha'an Capernaúm, ¿na'uncha li sta lakt'iyancha k'ach'ixk'ana'a? jantu, uxint'i k'ama'alht'a'uk'ana'a laka la'nin, mu li an la'acha'an Sodomaja ixtala'ts'ilh t'ach'a an la'ts'i yu jantu wa xamaticha lapanak lay lak'ilhtuy, ixtaja'asmatnalh chi ixtatsukulhka'. ");
INSERT INTO tpp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chaway klajunaw, an la'acha'an Sodoma palay jantu katima'alh'ajnalhi akxni an Dios kajasakxtununacha, pero uxint'i la'acha'an Capernaúm, chun. ");
INSERT INTO tpp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ixli'astan an Jesús tsukulhcha tapayniy, najun: ―KimPay, uxint'i ayk'at'i, Jamach'alhkatk'at'i lakt'iyan chi lakaat'un, uxint'i ilht'u li jantu katalhimacha'xalhi an tanlhun an yu sawalhcha tajalakpastaknan tanajun chi an yu sawalhcha lay talhimacha'xay tanajun, yucha an wa tajakilhpatinijk'atsayi ja'ilht'u li katalhimacha'xalh. ");
INSERT INTO tpp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chuni, kimPay, uxint'ich'a ch'unch'a oxi lhi'ach'anin. ");
INSERT INTO tpp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Chux an tanlhun kima'axta'ni'olhi an KimPay. Chi jantu xamati kimispay, wa yucha an KimPay, chi an KimPay, wa kit'ini ikmispay chi yu ijkamamispaniputun. ");
INSERT INTO tpp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Akilala'miwi yu la'lho'ont'at'it ch'i yu mak'uk'anant'at'it, aklamast'ak'ayaw. ");
INSERT INTO tpp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","K'alanit'iti tacha klamasuniyaw chi tacha ikt'ajun kit'in, kit'in ixlak'anti ijkamapayninin, chi jantu iklhita'ayayi li tu'u'. Chuncha lay kajastaknana mijatsukuntik'an. ");
INSERT INTO tpp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mu kit'in jantu lhima'anxkayi tacha iklhilhi'an kintak'uk'at, chi jantu ts'ink'i. ");
INSERT INTO tpp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Anchunu wilhchan an Jesús ix'anta tan jach'ananankanta, akxni jantu tapatsakan wilhchan, walh an ixt'alhtanan talakchawanalhcha, pus tsukulhcha ta'akatan'ex'iya an trigo chi ixta'uycha. ");
INSERT INTO tpp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Walh an fariseojnin tala'ts'in, pus tajuniy an Jesús: ―Amint'alhtanan ta'ilhtuyi yu jantu ilhtukan akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pus an Jesús jajuniy: ―¿Jant'u p'unawt'at'iti tani lalhcha an David akxni ixchawaniycha chi an yu ixtat'a'anta? ");
INSERT INTO tpp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","¿Jant'u k'ats'ayat'iti li tanuchalhi an la ixcha'a Dios? Chi talak'ulhi an pan yu jamatajtanilanti, walh yu'uncha jantu layi ka'ixtalak'ulh wa yu'uncha an sacerdotejnin ");
INSERT INTO tpp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿U jant'u p'unawt'at'iti an la ixlamap'a'sin Moisés?, li an sacerdotejnin tatapatsayi an laka tajtan masi akxni jantu tapatsakan, walh chi jantu tala'alhini li chuncha ta'ilhtuy ");
INSERT INTO tpp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Klajunaw chaway, ani t'ajun pumatam yu palay ay, an tajtan jantu. ");
INSERT INTO tpp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ch'i li k'alhimach'a'xat'iti yu nawputun an tan najunta: “Jamapayninti ikma'lhtask'iniy, jantu ixma'nika tanlhun jatapakxat para li k'alha'ulan.” Li lhimach'a'xayat'it, jant'u k'at'ilhimuk'at'iti tu'u yu jantu tu'u tala'alhin ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mu kit'in yu ikwalh isTs'alh Lapanak ikch'alhkatnani masi akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wa chuncha an Jesús, alhcha, chi tanuchalhcha an tan ixtata'ayxt'o'a an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ancha ixtanun pumatam lapanak yu jantu lay ixlak'anuy ma'atam ixmaka'. Pus wa chuncha, mu wa ixtalhipuxkawniycha an lapanakni tani katalhima'axta'lhicha an Jesús, pus tajuniy li sna ma layi lak'uch'ukan akxni jantu tapatsakan wilhchan, para li kata'alhtasulhcha. ");
INSERT INTO tpp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yucha jajuniy: ―¿Xamati uxitnan li yu lhit'ajun la'atam ixborrego, chi li ka'alh tan a'talhman akxni jantu tapatsakan wilhchan, jantu kamakutulh? ");
INSERT INTO tpp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Chi la'atam borrego yucha yu palay lhitapalay u pumatam lapanak? Pus jantu tani lay masi akxni jantu tapatsakan wilhchan ja'a'tayjukan an ali'in. ");
INSERT INTO tpp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wa chuncha an Jesús junilhi an lapanak an yu jantu lay ixlak'anuy ixmaka: ―K'alats'awalat'icha amimaka'. Pus lats'awalalhcha, chi tamaj'oxilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pus an lapanakni an yu ixjajunkan fariseojnin ta'ancho'olhcha, chi talhilakchiwinilhcha tani katalhima'nilhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wa yu mu an Jesús yucha ixk'atsay, pus taxtulhi ancha, chi lhilhuwi t'a'ankalh chi ixjak'uch'u'ojoyi an ta'an'anin. ");
INSERT INTO tpp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yucha ixjajuniy an lapanakni li jantu katalaknawlhi tichini yuchacha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Para li chunchacha kawalh tacha an ixnajunta an Isaías, yu ixlichiwiniy ixchiwinti Dios, akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yucha anicha yu iksakxtuta yu kint'atapatsay, oxi lhik'atsan kintak'atsan, ikmapayniy. Yucha akxta'niya kinTakuwin, chi yucha kajajuna an yu jantu tajakiklaka'inin tanyucha yu oxi chi yu jantu. ");
INSERT INTO tpp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jantu katilasalh chi jantu wa lh'ap'aj, lh'ap'ajcha katichiwinilh. Jantu xamati kati'alha'asmatlhi ixchiwinti laka tij. ");
INSERT INTO tpp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yucha sawalh jamapayniya an yu tama'alh'ajnan, jantu katicha'xmaj'alhi an makat'ikt'i k'iw yu wa lh'awilh, chi jantu katimamixilhi tan k'ischa takilhnulh jikmi, sta akxni kalats'awala'oyacha an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chi masi an lapanakni yu jantu judiojnin katapakxan'iya yucha. ");
INSERT INTO tpp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wa chuncha an Jesús talhicha'anilh pumatam lapanak yu ixla'apaxto'ta makxkay'un, jantucha lay ixjalakawanan chi jantucha lay ixchiwiniy. Walh k'uch'ulh, laycha jalakawanalh chi laycha chiwinilh. ");
INSERT INTO tpp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chux an yu ancha ts'anaks ixtayanalh sawalhcha ixtalhi'a'niy chi ixtalajuniy: ―¿Chi jantu yuchacha yu ists'alh David? ");
INSERT INTO tpp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Walh an fariseojnin mu ixta'asmat'acha, pus talajuniy: ―Ani xliyu lay jalhitamakxtuy an lakmakxkay'un mu Beelzebú yu ixpayk'an an lakmakxkay'uni t'atapatsay. ");
INSERT INTO tpp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero an Jesús ixjak'atsaaniya tani ixtapast'ak'acha, pus jajuniy: ―La'atam lhich'alhkat li wa lapu'aykan, talakt'ilhiy. Chi lakatam la'acha'an u lakatam laka cha'a li wa sawalhcha la'aykan, talakt'ilhitawlhkan. ");
INSERT INTO tpp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chi li an Satanás wa yuchacha jatamakxtuy an lakmakxkay'un, pus wa ix'akstucha t'ala'aykan, chuncha katalakt'ilhiya an ixlich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Chi li kit'in Beelzebuju ikpak'uch'unun, an yu tach'a'o'ayan, ¿tisiyuchacha tapak'uch'ununi? Yu'unchacha katajunan li sawalh u jantu t'ach'a an nawnat'it. ");
INSERT INTO tpp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero li kit'in ijkatamakxtuyi an lakmakxkay'un la ixTakuwin Dios, tasuycha li an ixlich'alhkat Dios tala'chintancha. ");
INSERT INTO tpp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Mu, ¿tasicha kalhitanuyanta xamati la ixcha'a yu k'ut'ilh lapanak li jantu p'ulhnajcha ma'ch'imayi, para li ka'alhawnilhcha ixlaktanlhuni? ");
INSERT INTO tpp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Watichicha yu jantu oxi kilhiwilay, kint'alaxkajiy. Chi yu jantu kint'ama'ayxt'o'a, wa laktilha. ");
INSERT INTO tpp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Chi chaway iklajunaw, chux tala'alhin, chi yu wa aya lhichiwiniy Dios, layi kamala'mixinikana', pero yu wa aya lhichiwiniy an ixTakuwin Dios, yucha jantu katimala'mixinikalh. ");
INSERT INTO tpp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chi yu wa aya lhichiwiniy an isTs'alh Lapanak, lay wachu kamala'mixinikana', pero yu wa aya lhichiwiniy an ixTakuwin Dios, yucha jantu katimala'mixinikalh, yu chaway ani lakamunulhpa chi an yu mimpalhtachalh. ");
INSERT INTO tpp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’An k'iw xajatawk'ati lay pumispakan. Yu oxi k'iw, oxi tawk'aniy xajatawk'at, chi yu jantu oxi k'iw, jantu oxi tawk'aniy xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ixjas'at'ank'an tsapulin! ¿Tasucha lay oxi k'alhich'iwinina'it'it li ay unt'at'iti? Chux chiwinti laka jalhunuti minachalh. ");
INSERT INTO tpp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An yu oxi lapanak, yu laj'oxi jatapast'ak'ati makutuy la ixjalhunut. Chi an yu jantu oxi lapanak, yu jantu oxi jatapast'ak'ati makutuy la ixjalhunut. ");
INSERT INTO tpp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero klajunaw, an yu wa aya talakchiwiniy, akxni la ix'ukxlakapucha Dios tat'ajuni katak'atsaya li jantu oxi tacha ixtanajun. ");
INSERT INTO tpp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mu tani chiwiniycha atam, chunchacha kapuk'atsanikana li oxi lapanak, u li sna kajunkana li ilhtuta ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wa chuncha ali'in xamaestrojnin lhamap'a'sin chi ali'in fariseojnin, tajuniy an Jesús: ―Maestro klakask'inaw li tu'u akilamasuniw yu lhi'a'nin. ");
INSERT INTO tpp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yucha jajuniy: ―Yu'uncha an yu jantu tajakiklaka'inini task'in li tu'u kajamasunikalh, pero jantucha tu'u katijamasunikalh wa yucha an tacha putapasalhcha Jonás yu ma'anchacha ixlichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yucha la'at'utu wilhchan chi la'at'utu jatats'isni ixpalaktajun la ixpalakni la'atam ay jatanti, wachuchuni an isTs'alh Lapanak la'at'utu wilhchan chi la'at'utu jatats'isni kata'aknuya'. ");
INSERT INTO tpp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","An jamacha'an Nínive wa ayxtami katat'a'ostayaya an lapanakni an yu chawayka tat'ajun akxni kala'puskana la ix'ukxlakapu Dios. Chi yu'uncha katanawna li an yu chaway tat'ajun jantu k'is taja'asmatnamputun, mu yu'uncha an jamacha'an Nínive, taja'asmatnalhi akxni jalhixa'alalh ixchiwinti Dios an Jonás. Chi uxitnan masi aniya t'a'aklat'awnat'it yu palay xa'ay, an Jonás jantu, ch'unch'a jant'u k'iklak'a'iyat'it. ");
INSERT INTO tpp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","An xareina xalakaat'un Sabá wachu ayxtami kajat'a'ostayaya an yu chaway tat'ajun akxni kala'puskana la ix'ukxlakapu Dios, chi kanawna li yu chaway t'awkani jantu ja'asmatnankan, mu yucha ma'ati minchalh akxni ki'alha'asmatchilh ixjatapast'ak'at an Salomón. Chi uxitnan masi aniya t'a'aklat'awnat'it yu palay xa'ay, an Salomón jantu, ch'unch'a jant'u k'iklak'a'iyat'it. ");
INSERT INTO tpp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Akxni an makxkay'un makajuncha an lapanak, wa lakaalakxixnicha puxkawlhitsukuy tan katawilh, chi li jantu la'cha'an, ");
INSERT INTO tpp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","najun: “Ak'ancho'oya la kincha'a tan iktaxtuchalh.” Chi li akxni cha'ancho'oycha jantu xamati wilh, pero li wa sp'uyjcha jalakp'alhnankanta chi jamalht'ak'anankanta, ");
INSERT INTO tpp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ancha jat'ala'iniy ixpumatujunk'an yu palay wa tani talaycha lakmakxkay'un masi jantu yucha. Pus tatanuycha, anchacha tatawlay, ixli'astan anchunu lapanak palaycha wa tani laycha walh masi jantu tukancha ixlip'ulhnaj. Chuncha kataputapasaya an yu sawalhcha talakxkayajk'atsay chaway. ");
INSERT INTO tpp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ixjaxa'alat'ajunka an lapanakni an Jesús, walh an ma'spa tacha'alhcha an ixnati chi an ixjat'ala'awnin, ixtat'achiwinimputun. ");
INSERT INTO tpp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Xapumatam juniy an Jesús: ―Aminati chi amijat'ala'awnin ma'spa tayanalh, ma tat'achiwimputunan. ");
INSERT INTO tpp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yucha alhtaylh juniy: ―¿Tisiyuchacha kinati chi kijat'ala'awnini? ");
INSERT INTO tpp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Chi jamukuniycha an ixt'alhtanan tan ixtayanalh, najun: ―Yu'uncha aniya kinatin chi kijat'ala'awnin. ");
INSERT INTO tpp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mu wa tichicha li yu ilhtuyi tacha an najun kimPay, yu anu lakt'iyan wilhchalh, yucha kint'ala'ajun chi kijamatsan chi kinati. ");
INSERT INTO tpp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Taxtulhcha yuchaka wilhchan an laka cha'a an Jesús, alhcha sa' tawlhna ixpiktu ay lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Walh wanaj lhilhuwi la'cha'ankalh. Pus yucha tajulhcha laka barco sa'cha tawlhchalh, chi an lapanakni ixpiktucha an lakxkani ixtayanalh. ");
INSERT INTO tpp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Lhuw tanlhuni jajunilh laka pulhamacha'xan, tacha ani: ―Pumatam lapanak, alh jach'anana'. ");
INSERT INTO tpp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Akxni ixch'ant'ajuncha an ixt'in, an ali wa ixpiktu tiji tamachalh, pus ta'usaklhi an ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","An ali tan wa laka chiwxini tamachalh, tan tutukancha tu'u t'un, pus wa lasi la'awlh mu jantu talhmani yu t'un. ");
INSERT INTO tpp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Chi xajchilhcha an wilhchan, maxixilh, mu jantu tu'u ixjataxiyak an jach'ananti. ");
INSERT INTO tpp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","An ali lakalhtukunani tamachalh, pus akxni ta'ayalhcha an jalhtukun, t'alamaxixilhi an yu oxi jach'ananti. ");
INSERT INTO tpp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero an ali tan oxi t'uni tamachalh, pus tawk'anilhcha xajatawk'at. A'atamincha xak'iw la'awlh, cien, chi sesenta chi treintajcha xta'lhi xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yu lhit'ajuni ixpa'asmatna, ¡ka'asmatlhi! ");
INSERT INTO tpp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","An ixt'alhtanan an Jesús, stalhcha tala'alh, tajuniy: ―¿T'asu li wanaj t'u'u jalhimalakxt'uniy akxni jaxa'alayi? ");
INSERT INTO tpp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yucha jajuniy: ―Uxitnan layi k'alhimach'a'xaya'it yu jantu tasuy an ixlich'alhkat Dios yu alinachalh anu lakt'iyan, pero yu'uncha jantu. ");
INSERT INTO tpp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mu watichicha yu lhit'ajun, ali kaxta'nikana', pus palay lhuwi kalhitsukuya', pero yu jantu tu'u lhit'ajun, masi wa k'ischa ka ixlitsukulh wanaj kamaxtuni'okana'. ");
INSERT INTO tpp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Wanaj laka pulhamacha'xani ijkaxa'alay, mu masi tajalakawanan tachanu jantu tajalakawanan, chi masi taja'asmatnan tachanu jantu taja'asmatnan, mu jantu talhimacha'xay. ");
INSERT INTO tpp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chunchacha sawalhi tat'axajachalh tacha an ixnajunta an Isaías yu ixlichiwiniy ixchiwinti Dios, tan nawlh: Masi sawalhch'a k'a'asmatt'it, jant'u k'at'ilhimach'a'xat'it, ch'i masi sawalhch'a k'ala'ts'int'it, jant'u k'at'imisp'at'it. ");
INSERT INTO tpp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mu an ixjalhunutk'an ani lapanakni sawalhcha lakt'ak'alha. An lapanakni talaj'akatupats'inin chi tala'la'puts'inin, para li jantu lay katajalakawanalh chi jantu lay kataja'asmatnalh, chi jantu lay katalhimacha'xalh, chi chuncha jantu lay akintitach'a'o'alh, chi jantu lay aktijak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero oxi para uxitnani li jalak'awananat'it ch'i li ja'asmatnanat'it. ");
INSERT INTO tpp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mu ixluwk'an yu ixtalhichiwiniy ixchiwinti Dios chi yu wachu ixtajakiklaka'inini ixtala'ts'imputun t'ach'a an la'ts'inat'it chi ixta'asmatputuni t'ach'a an asmat'at'it, pero jantu tala'ts'ilh chi jantu ta'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Chaway k'a'asmatt'itcha yu nawputun an ijkalhixa'alalh jach'anana'. ");
INSERT INTO tpp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Akxni xamati asmat'a an ixlich'alhkat Dios, chi li jantu lhimacha'xay, an xapay makxkay'un la'cha'an chi maxtunicho'oyi an yu tachanu ch'ankalhcha la ixjalhunut. Yucha an wa ixpiktu tij tamachalh. ");
INSERT INTO tpp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chi an yu wa laka chiwxin tamachalh, yucha an yu asmat'acha an ixchiwinti Dios, chi akxni wa asmatt'ajunka sawalhcha achaniy asmat'a. ");
INSERT INTO tpp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero tachanu jantu jataxiyaklay, wa lasi xixa, mu akxni lhima'anxkaycha la'ts'in u li lhich'a'o'akancha an ixchiwinti Dios, makawcho'oycha. ");
INSERT INTO tpp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","An yu lakalhtukunan tamachalh, yucha an yu asmat'acha ixchiwinti Dios, pero mu sawalhcha lhakapu'ani tacha an lak'alincha tanlhun chi lhuw tumini lhitsukuputun pus chunchacha pumaksk'anjwacho'oy an ixchiwinti Dios, jantu tu'u ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero an yu tan oxi t'un tamachalh an t'in, yu'uncha an yu ta'asmat'a chi talhimacha'xay an ixchiwinti Dios, chi lhuwi taxt'a'a ixjatawk'atk'an tacha cien chi sesenta chi treintaja pumatamin. ");
INSERT INTO tpp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jalhixa'alapalh la'atam pulhamacha'xan an Jesús, jajuniy: ―An ixlich'alhkat Dios, ixt'atam tacha pumatam lapanak, yu ch'anlhi oxi xatalhts'i tu'u la ixlakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero akxni taputs'isilhcha an tan ch'anlhi trigo, kalaks ki'alhawch'anlhi an yu wa ay junita yu jantu oxi jach'ananti chi ancho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Akxni ta'ayalhcha an jach'ananti tawk'anilhcha xajatawk'at, chi wachucha ma'ta'ayalhi an yu jantu oxi jach'ananti. ");
INSERT INTO tpp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pus an ixma'tapatsanin an patrón tajuniy: “Patrón, ¿chu jantu yu oxi xatalhts'i jach'ananti ch'ant'i an la milakaat'un? Mu wachu la'ajunta yu jantu oxi jach'ananti.” ");
INSERT INTO tpp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yucha jajuniy: “Ka xamati yu wa kintaxkayani chuncha ki'ilhtuchilh.” Pus an ixma'tapatsanin tajuniy: “¿Lak'ask'ini li ak'aw p'ulhumaj'anin?” ");
INSERT INTO tpp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yucha jajuniy: “Jantu, kawalh, wa lay t'ap'ulhumaj'ant'it an trigo. ");
INSERT INTO tpp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kachajcha wa tam t'ata'ayalh sta akxni kacha'xmaj'ankana'. Akxni ixpakucha ajkajuna an yu katacha'xmaj'ana li p'ulhcha katacha'xmaj'alhi an yu jantu oxi jach'itin, kalakch'axpach'ikanacha chi kala'xawakanacha, pero an trigo akma'aya'.” ");
INSERT INTO tpp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jalhixa'alapalh la'atam pulhamacha'xani an Jesús, jajuniy: ―An ixlich'alhkat Dios, tachanu xamati lapanak kach'anlhi la ixlakaat'un xatalhts'i mostaza. ");
INSERT INTO tpp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Yucha wa lakat'ikt'i xatalhts'i xt'a'a, walh chi akxni ta'ayaycha yucha yu palay ay ta'ayay jach'ananti, k'iwcha jun, taputawk'aycha an ts'o'on chi tapumuk'aycha ixpamaj'ank'an. ");
INSERT INTO tpp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","A'tam la'atam pulhamacha'xani jajumpalh an Jesús, jajuniy: ―An ixlich'alhkat Dios anu lakt'iyan tachanu xamati t'aku yu lhiyajuy lakat'ikt'i lhamaskajan lhuw harina walh wanaj maskaja'ojoy. ");
INSERT INTO tpp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Chux yu ixjalhixa'alay an Jesús an lapanakni wanaj laka pulhamacha'xani ixjajuniy, wa chuncha ixjaxa'alay. ");
INSERT INTO tpp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ts'awjcha tapasalh tacha an ixnajunta an yu ma'anchacha ixlichiwiniy ixchiwinti Dios, akxni nawlh: Tu'u pulhamacha'xani aknawna akxni akchiwinina', aknawna yu jantu k'atsakan sta akxni ilhtukanchalh an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Akxni talak'ancho'olhcha an ixta'a'yanalh an Jesús, yucha tanulhcha an laka cha'a', pus an ixt'alhtanan stalhcha tala'alh, tajuniy: ―Akilajuniwi tuchini nawputuncha an yu jantu oxi jach'ananti. ");
INSERT INTO tpp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yucha ja'alhtaylh jajuniy: ―An lapanak an yu ch'an yu oxi xatalhts'i tu'u, yucha an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","An lakaat'un yucha an lakamunulhpa', an oxi xatalhts'i jach'ananti yu'uncha an yu kata'ana an la ixlich'alhkat Dios, chi an yu jantu oxi jach'ananti yu'uncha an ixjas'at'an an yu wa ay junita. ");
INSERT INTO tpp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","An kint'alaxkayk'an an yu kich'anlhi yu jantu oxi jach'ananti yucha an xapay makxkay'un. Akxni kacha'xmaj'ankana nawputun akxni ka'ukla'oya an lakamunulhpa'. Chi an yu tacha'xmaj'an yu'uncha an angelhnin. ");
INSERT INTO tpp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tacha p'ulhumaj'ankani an yu jantu oxi jach'itin chi la'xawakan, chuncha kajuna akxni ka'ukla'oya ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kajamakmina an isTs'alh Lapanak ix'angelhnin para li katamilh ma'osunini an la ixlich'alhkat an yu wa tama'ilhtuycha tala'alhin ali'in, chi an yu wa tanlhuncha yu jantu laj'oxi ta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kajamak'ankana laka jikmi, tan laj'alhunkan chi wa xwat'at'acha laktasat'awkan. ");
INSERT INTO tpp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Akxni chun, an yu oxi tat'ajun la ixtij Dios, kaxlimjcha tajuna tacha an wilhchan, tan an ch'alhkatnan ixPayk'an. Yu lhit'ajuni ixpa'asmatna, ¡ka'asmatlhi! ");
INSERT INTO tpp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’An ixlich'alhkat Dios tachanu jamaknunti tumin, chi xamati lapanak kala'cha'alh, chi ka'a't'ap'ucho'olh, chi mu li sawalhcha achaniy li la'cha'alh an tumin, kast'a'olhcha an yu lhit'ajun, chi katamawlhcha an lakaat'un an tan aknuy tumin. ");
INSERT INTO tpp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Chi an ixlich'alhkat Dios wachu tacha pumatam lapanak yu puxkawlhit'ajun perla, ");
INSERT INTO tpp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","chi li akxni kala'cha'alhcha la'atam perla yu xtapalh la'lhuw tukan ka'an'olhcha st'ana an ixtanlhun, chi katamawlhcha. ");
INSERT INTO tpp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Wanajcha chun an ixlich'alhkat Dios tachanu la'atam paxo'tan, li akxni mujukancha an lakxkan, wa tuchicha jatanti ma'alhilay. ");
INSERT INTO tpp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chi li a'tsamancha, makutukancha, la ixpiktucha an lakxkani laktawlhkan, sakxtukancha yu laj'oxi, chi laka canastajcha mujukan chi yu jantu laj'oxi t'o'cha puxte'emaj'ankan. ");
INSERT INTO tpp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chuncha ka'ilhtukana akxni ka'ukla'oya an lakamunulhpa'. An angelhnin lakatami kata'ilhtuya an yu wa ay tajunita lapanakni, chi an yu ts'awj ixtat'ajun lapanakni, lakatam. ");
INSERT INTO tpp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","An yu ay tajunita kajamak'ankana laka jikmi, tan laj'alhunkan chi wa xwat'at'acha laktasat'awkan. ");
INSERT INTO tpp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","An Jesús jajuniy: ―¿Lhimach'a'xa'o'ot'iti tacha an klajuniw? Yu'uncha ta'alhtaylh tajuniy: ―Chuni Jamach'alhkat. ");
INSERT INTO tpp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","An Jesús jajuniy: ―Xliyu wa tichicha xamaestro lhamap'a'sin yu laklaniy an ixlich'alhkat Dios, tachanu pumatam xapay inta laka cha'a', yu lakmakutuyi yu lhitapalay la'sast'i ixtanlhun chi yu la'ma'anchacha, para li kajapumalaklanilhi an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Akxni chunchacha jajun'olh an pulhamacha'xan an Jesús, alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","La ixla'acha'ancha cha'alh, anchacha ixjamasuniy an laka cha'a tan ixtata'ayxt'o'a yu'uncha. Sawalhcha ixtalhi'a'niya an lapanakni, ixtanajun: ―¿Tanischa wa ti'ilh chuncha jatapast'ak'at ani lapanaki? ¿Tasucha lay lhijak'uch'ununi? ");
INSERT INTO tpp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Chu jantu yu an ists'alh an jaxpitni'? ¿Jantu yu ixnati a María? ¿Jantu ixjat'ala'awnini an Jacobo, chi an José, chi Simón chi Judas? ");
INSERT INTO tpp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Chu jantu aniya tawilanalh an ixjap'isa'an yu jatsi'in? ¿Tanischa lanilh yucha tacha ani lak'ilhtuyi? ");
INSERT INTO tpp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pus jantucha oxi ixtalhipast'ak'a. Pero an Jesús jajuniy: ―Jantu xamati yu lhichiwiniy ixchiwinti Dios la'ts'imputunkan la ixt'un chi la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pus ancha an Jesús, jantu tukancha lhuwi tanlhun ilhtulh yu la'lhi'a'nin, mu jantu ixtakiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Anchunu panch'e'ex an rey Herodes asmatlhi li sawalhcha ixlichiwinkani an Jesús, ");
INSERT INTO tpp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Pus an ixma'tsukunin jajuniy: ―Yucha an jama'paxanaj Juancha la'awcho'olh, xliyu lay lhilak'ilhtuy yu masuy an ix'alhp'asninti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chunchacha ixnajun an Herodes, mu ixmalaklhchajuta laka pulach'ini an Juan, wa xliyu li an Herodes ixt'at'ajuni ixt'iwi wa ixt'ala'ajuncha, yu junkan Felipe, an ixt'iwi Felipe ixjunkan Herodías. ");
INSERT INTO tpp_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chi mu an Juan ixjuniya an Herodes: ―Jantu oxi li t'ats'uk'uniy an ixt'iwi ixjunita mint'ala'ajun Felipe. ");
INSERT INTO tpp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chi an Herodes ixma'niputuni an Juan, pero wa ixjatalhamniya an lapanakni li kaxtat'atasp'itchalh, mu an lapanakni ixtakiklaka'iya li an Juan Diosi ixmakminta. ");
INSERT INTO tpp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Walh akxni la'tsalh ixk'ata an Herodes, chi ixk'atanit'ajuncha, an istsi an t'aku Herodías jat'inilhi ixtan'ajni an tan ixk'atanikan, pus oxicha lhiwilalh an Herodes. ");
INSERT INTO tpp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wa chuncha an Herodes juniy an jatsi li kaxta'ni'oya wa tuchicha kask'iniya', jantucha wa lhi'elh'amanan. ");
INSERT INTO tpp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pus an jatsi, mu ixmap'a'sitacha an ixnati, najun: ―Ak'ixt'a'nin laka pulatoj an ix'a'tsulh jama'paxanaj Juan. ");
INSERT INTO tpp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wa chuncha an rey Herodes ta'oxila'alhilh pero mu ixjunitacha li kaxta'niya sawalhi watuchicha kask'iniya chi ta'asmat'acha an yu ancha ixtat'awilanalh laka mesa, pus lhinawlhcha li kaxta'nikalh. ");
INSERT INTO tpp_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Lhinawlhcha an rey Herodes li ka'a'cha'xkalhi an Juan an laka pulach'in. ");
INSERT INTO tpp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Lhiminkalhcha an ix'a'tsulh laka pulatoj, xta'nikalhcha an jatsi chi yucha xta'nilhcha an ixnati. ");
INSERT INTO tpp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wa chuncha tacha'alhi an ixt'alhtanan an Juan, taki'ilhi an ixlakatunaj, tamaknulhcha chi ta'alhcha juninini an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Akxni k'atsaalhcha an Jesús li tama'nilhi an Juan, tajulhcha laka barco, alhcha ma'at tan wa jasa'nik'a, pero an lapanakni tala'ts'ilhi tan pu'alh, pus tat'a'alh, yu'uncha wa lakaat'uni tapu'alh akxni tataxtulh an la'acha'anaxni. ");
INSERT INTO tpp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Chi akxni ixtakutt'ajuncha an Jesús, la'ts'incha li wa ts'anakscha ixlakyakalh, pus ixjamapayniycha, jak'uch'ulhi an yu wa ixtala'ta'an'ay. ");
INSERT INTO tpp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ixtats'isit'ajuncha, an ixt'alhtanan an Jesús tajuniy: ―Ani jantu xamati wilh chi ta'oxaycha, k'aja'un an lapanakni li kata'alhcha an la'acha'anaxni para li katatamawlhcha yu kata'uya'. ");
INSERT INTO tpp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yucha jajuniy: ―Jantu task'iniya li inta kata'alh, k'ajaxt'a'nitcha uxitnani yu kata'uya'. ");
INSERT INTO tpp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pus ta'alhtaylh tajuniy: ―Wa a'xkisi pan chi wa ma'at'uy jatanti iklhit'awnaw. ");
INSERT INTO tpp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","An Jesús jajuniy: ―Akilalhiminiw. ");
INSERT INTO tpp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wa chuncha an Jesús jajuniy an lapanakni li katalaktawilhka an tan jala'awnininta. Xa'a'ilhcha an a'xkisi pan chi an ma'at'uy jatanti chi, tala'st'alhcha an lakt'iyan, xta'lhicha lhimala'puchajun. La'ch'e'elhcha an pan chi jala'xta'nilhcha an ixt'alhtanan. Yu'uncha tamala'pitsilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ixchuxchak'ani talak'ulh chi talhikiklalhcha. Ixli'astan tamach'ixtamilhcha la'akawt'uy kanastaja an xaxajni pan chi an jatanti akxni talakway'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Katacha la'akisi milh lapanakni yu talakwaylh, an t'akunin chi an jas'at'an jantu jat'aput'e'ekalh. ");
INSERT INTO tpp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ixli'astan an Jesús, jajuniy an ixt'alhtanan li katapu'alhcha an barco an ixtapiktutam lakxkan, mu yucha ma katijala'axa'alaya an lapanakni li kata'ancho'oyacha. ");
INSERT INTO tpp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Akxni ta'alhcha an lapanakni, an Jesús alhcha tapaynini a'stitawk'a, wa ix'akstu. Walh tats'isilhcha, yucha anchaka ixt'awnachalh wa ix'akstucha. ");
INSERT INTO tpp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","An ixt'alhtanan ixtan'ajnicha an lakxkani ixtapu'antachalh an barco. Wa milh, milhcha ixlaklayi an xkan, mu an un p'asi wa ixjalakatast'uk'a, chi p'ascha ixmalaklay an barco. ");
INSERT INTO tpp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ixtunkunmintacha, las trescha, jataymalhcha an Jesús, wa ix'ukxjalhtanaj'anta an lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pus an ixt'alhtanan mu ixtala'ts'incha li ix'ukxjalhtanani an lakxkan, ixtalaktalhanancha, p'ascha ixtalaknajun: ―¡Ka wa takuwincha! ");
INSERT INTO tpp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero an Jesús jaxa'alalh watukan, jajuniy: ―¡Oximaj'ayi k'a'unt'it, mu kit'in, jant'u k'alakt'alhanant'it! ");
INSERT INTO tpp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pus an Pedro alhtaylh, juniy: ―Li uxint'i Jamach'alhkat Jesús, k'a'ilht'u li lay akla'ancha'an an la ix'ukxni lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yucha juniy: ―K'at'at'icha. Takutlhi an laka barco an Pedro, ukxjalhtanaj'alhcha an lakxkan an tan ixyachalh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero akxni la'ts'ilhi an Pedro li p'asi ixmin an un, talhanalh, pus tsukulh talak'aknuy, chi ixpukilht'asaycha, ixnajun: ―¡Jamach'alhkat, ak'ima'alht'axt'ut'i! ");
INSERT INTO tpp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Watukan las mak'anilhi an Jesús, ma'ch'apachalh, chi juniy: ―¡Jantu ayi mijakiklaka'inti! ¿T'asu li jant'u k'ilhiwilayi? ");
INSERT INTO tpp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wa chuncha sa'cha walhi an un akxni tatajulhcha an laka barco. ");
INSERT INTO tpp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ixli'astan an yu ixtatajumanalh an laka barco stalhcha tala'alhi an Jesús, chi tatatso'ottanilhcha, tajuniy: ―Uxint'i isTs'alhk'at'i Dios sawalh. ");
INSERT INTO tpp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Akxni tapatakutchalhcha an lakxkan, tacha'alhcha xalakaat'un tanchun junkan Genesaret. ");
INSERT INTO tpp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Walh akxni tamispalhi an Jesús an lapanakni an yu ancha tawilanalh, tama'pitsi'olhi chiwinti ta ixlijalhi'ay, pus chux an ta'an'anin jalhicha'anikalhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ixtatapayniniycha li ma kajamakawnilhi masi wa yucha an ixpiktucha ixla'ch'it katapiktuch'apanichalh, yu an tach'apanichalh an ixla'ch'it ixchuxk'ani tatak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ali'in xamaestrojnin lhamap'a'sin chi an lapanakni yu ixjajunkan fariseojnin jamacha'an Jerusalén, tala'cha'alhi an Jesús, tajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Tasu li amint'alhtanan jantu ta'ilhtuyi tacha an tanajun an yu laktatanincha, jantu tama'ch'a'ayi akxni talakwajini? ");
INSERT INTO tpp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","An Jesús yucha wachu jajuniy: ―¿Chi uxitnan tasu li an ixlamap'a'sin Dios lhimap'axayatcha wa milhamap'a'sinchak'ani? ");
INSERT INTO tpp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mu an Dios najun: “K'a'asmatnini yu junan minpay chi minati.” Chi nawpalay: “Yu xkayaj juniya ixpay chi ixnati kaniya'.” ");
INSERT INTO tpp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Walh uxitnan nawnat'iti li jantu tani lay masi jantu kata'a'tayjulh ixlakpaynink'an an lapanakni, yu tama'lhtask'iniy la'a'tayjun, mu li yu ixtaxta'nilh ixlakpaynink'an li kataxta'ni'oyacha Dios. ");
INSERT INTO tpp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ch'unch'ach'a p'unawnat li jantucha task'iniya li kata'a'tayjulh ixpayk'an chi ixnatik'an an lapanakni. Lhimap'axayatcha an ixchiwinti Dios wa minchiwintichak'an. ");
INSERT INTO tpp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Uxitnan wa layat'itcha! Ts'awjcha talhichiwinin an Isaías yu ixlichiwiniy ixchiwinti Dios akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ani lapanakni oxi kintalhichiwiniy, pero la ixjalhunutk'an jantu sawalh. ");
INSERT INTO tpp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Wa la'a'ijcha oxi kintalhipast'ak'a, mu tamasuyi yu wa ixjatapast'ak'atchak'an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wa chuncha jat'asani'olhi an Jesús an lapanakni, chi jajuniy: ―K'a'asmatt'itcha, chi k'alhimach'a'xat'it: ");
INSERT INTO tpp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jantu yu an yu ukani lhkilikiy an lapanak, yu jalhkilikinin yucha an tacha kilhtaxtukan chiwinti. ");
INSERT INTO tpp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pus an ixt'alhtanan an Jesús stalh tala'alh tajuniy: ―An fariseojnin jantu oxi talhiwilalh akxni an ta'asmatlhi t'ach'a an naw. ");
INSERT INTO tpp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero an Jesús jajuniy: ―Wa tuchicha jach'itin yu jantu yu ch'anta an kimPay, yu wilhchalh anu lakt'iyan, kap'ulhumaj'ankana'. ");
INSERT INTO tpp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Yu'unch'a k'ajamak'a'unt'itcha, yu'uncha la'la'lhtulu'un, chi wa ixt'ala'la'lhtulu'unchak'ani tat'alama'ch'apalhi'anta, wa ayxtami kawarj ta'ana tan a'talhman. ");
INSERT INTO tpp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","An Pedro alhtaylh juniy: ―Akilajuniwi tuchini nawputuncha t'ach'a an na'un. ");
INSERT INTO tpp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Pus an Jesús alhtaylh juniy: ―¿Wach'u jant'uk'a' lay lhimach'a'xayat'it? ");
INSERT INTO tpp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Jant'u k'ats'ayat'iti li chux an yu ukan la kimpajank'ani tajuyachalh, chi ixli'astan maj'ancho'okancha? ");
INSERT INTO tpp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero an chiwinti, la kijalhunutk'ani minachalh, yucha yu lhkilikiy an lapanak la ixjatsukunti. ");
INSERT INTO tpp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mu an laka jalhunuti minachalh an lakmakxkay jatapast'ak'at, tacha an yu jama'ninin, chi yu talat'atamay yu jantu talat'at'ajun, chi yu wa aya talay, chi yu ja'alhawnan, chi yu wa maslakatinin, chi yu wa aya juniy Dios u xamati ixt'alapanak. ");
INSERT INTO tpp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yucha yu lhkilikiy an lapanak pero li wa jantucha akma'ch'a'alh chi ak'ulhcha li tu'u, yucha jantu jalhkilikinin. ");
INSERT INTO tpp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Taxtulhcha ancha an Jesús, alhcha xalakaat'un Tiro chi Sidón. ");
INSERT INTO tpp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Walh pumatam t'aku jamacha'a Canán, la'cha'alhi an Jesús, chi p'ascha ixa'alay ixjuniy: ―¡Jamach'alhkat Jesús, ists'alh David, iksk'iniyan lamapaynin! An kintsi wa la'apaxto'ta la'atam makxkay'un, chi sawalhcha mama'alh'ajni. ");
INSERT INTO tpp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero an Jesús jantu k'is alhtaylh. Pus tajuniy an ixt'alhtanan: ―K'a'un li ka'ancho'ochalhcha, mu kintach'a'o'atan chi t'asajmintacha. ");
INSERT INTO tpp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","An Jesús najun: ―Kit'in kimakminkanta li wa yucha an jamacha'an Israelhi ajkapuxkawlh, mu tats'an'ata. ");
INSERT INTO tpp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero an t'aku la'cha'alhi an Jesús chi tatso'ottanilhcha la ixlakapu', ixtapayniniycha ixjuniy: ―¡Ak'ilhi'a't'ay'ut'i Jamach'alhkat, Jesús! ");
INSERT INTO tpp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero yucha wa juniy: ―Jantu oxi li kajama'osunikalhcha yu ta'ut'ajun jas'at'an chi kajamaka'anikalhcha an x'oyun. ");
INSERT INTO tpp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","An t'aku juniy: ―Chuni Jamach'alhkat Jesús, pero an x'oyun ta'usak'a masi wa xala'tach'e'echa an ts'aluku yu patajuy laka mesa. ");
INSERT INTO tpp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pus akxni an Jesús juniy an t'aku: ―Uxint'i jak'iklak'a'inin sawalh, kajunacha yu lak'ask'in. Pus an istsi an t'aku wa akxni ta'oxicho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ancho'olhcha an Jesús, alhcha waniy xa'alamalh Galilea. Chi tama'ast'a'alhcha a'stitawk'a, anchacha sa' tawlhchalh. ");
INSERT INTO tpp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lhilhuwi la'cha'ankalh, chi ixtalhicha'aniycha yu wa la'ch'anlh'awilin, chi yu wa la'la'lhtulu'un, chi yu wa laj'a'atapanin, chi yu wa lakmaklht'ulukun, chi ali'incha ta'an'anin, wa tuchicha ta'an'at ixtapakxanta. La ixlakapucha an Jesusi ixtayajuy chi yucha ixjak'uch'uycha. ");
INSERT INTO tpp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tacha an ts'anakscha ixlakyakalh, sawalhcha ixtalhi'a'niya li an yu jantu lay ixtachiwiniy, ixtachiwiniycha, chi an lakmaklht'ulukun ixtata'oxicha, chi an la'ch'anlh'awilin oxicha ixtalakalhtanan, chi an la'la'lhtulu'un oxicha ixtajalakawanan. Sawalhcha ixtalaknajuni li an ixDiosk'an jamacha'an Israel, ay sawalh. ");
INSERT INTO tpp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jat'asanilhi an ixt'alhtanan an Jesús, jajuniy: ―Ijkamapayniya ani lapanakni, mu la'at'utucha wilhchani ani tat'ajun, chi jantu tu'u yu katita'ulh. Chi ajkamala'achacho'olhcha wa chuncha, wa lay inta tala'la'awitijtayalh laka tij. ");
INSERT INTO tpp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","An ixt'alhtanan tajuniy: ―Wanaj lhilhuwi tacha ani ayxto'kan, para kajamalhilaaniw. ¿Tanischa lay ka'iyaw lhuw pan li ani jantu tu'u lakwilakalhi? ");
INSERT INTO tpp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","An Jesús jajuniy: ―¿Tasu a'xchuxcha pani lhit'ant'at? Yu'uncha tajuniy: ―A'xtujun chi lakats'uniycha lakt'ikt'i jatanti. ");
INSERT INTO tpp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pus an Jesús jajuniy an lapanakni li katalaktawlh'olhka an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chi yucha xa'a'ilhcha an a'xtujun pan chi an jatanti, chi xta'lhicha lhimala'puchajun, ixli'astan la'ch'e'elhcha, wa chuncha jala'xta'nilhcha an ixt'alhtanan, chi yu'uncha tamala'pitsinilhcha ixchuxk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ixchuxchak'ani talak'ulh chi talhikiklalhcha. Ixli'astan la'atujun kanastaja a'tsamcho'olh yu wa xaxajnicha tapusakcho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","An lapanakni an yu talakwaylh, la'at'at'i milh, an t'akunin chi an jas'at'an yu tama'waylh wachu, jantu jat'aput'e'ekalh. ");
INSERT INTO tpp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jala'axa'ala'olh an Jesús an lapanakni, tajulhcha an laka barco, alhcha tanchun xalakaat'un Magdala. ");
INSERT INTO tpp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","An Jesús tala'cha'alhi an fariseojnin chi an saduceojnin ixtalhila'ts'intanuycha, ixtajuniy li ma kajamasunilh tu'u an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yucha ja'alhtaylh jajuniy: ―Akxni tats'isiycha uxitnan nawnat li oxi wilhchani kajuna katunkuna akxni la'ts'inat an lakt'iyan li slapulh. ");
INSERT INTO tpp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chi akxni wats'isin, li wa talaktsin an jataputs'i chi li slapulhi an lakt'iyan, nawnat li kamina xkan chi li kalaya un. ¡Uxitnan wa layatcha! Mu li layi k'ats'ayat tuchini katapasayacha xlakata t'ani la'ts'inatcha an lakt'iyan, ¿pus tasu li jant'uch'a lhimach'a'xayat'iti an tanlhunch'a la'ts'inat ani panch'e'exi? ");
INSERT INTO tpp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","An la'ma'lhta'alhinin yu chaway tat'ajun talakask'in li tu'u kajamasunikalh, pero jantu tu'u katijamasunikalh, wa yucha an tacha putapasalh tichi lapanak yu ixjunkan Jonás, yu ma'anchacha ixlichiwiniy ixchiwinti Dios. Jamakawlh an Jesús, alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tacha'alhcha ixtapiktutam an lakxkan, an ixt'alhtanan an Jesús ixtakapta li katalhi'alh pan. ");
INSERT INTO tpp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","An Jesús jajuniy: ―K'ajalajk'ats'anant'iti li jantu katamatsaman an ixlamaskajank'an an fariseojnin chi an saduceojnin. ");
INSERT INTO tpp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yu'uncha ixtapast'ak'a li sna xliyu jantu ixtalhi'anta pan. ");
INSERT INTO tpp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pus jalhimacha'xanilhi an Jesús, jajuniy: ―Wa k'isi jak'iklak'a'ininat'iti lapanakni. ¿Tasu li p'ast'ak'atcha li sna xliyu jant'u lhit'ant'at pani li chuncha klajunawi? ");
INSERT INTO tpp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jant'uk'a' lhimach'a'xayat'it, ch'i jant'u p'ast'ak'at'iti akxni an la'akisi milh lapanakni ta'ulh wa a'xkisi pan, chi tani la'achuxcha canastaja p'usakch'o'ot? ");
INSERT INTO tpp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Chi akxni ta'ulh la'at'at'i milh lapanakni wa a'xtujun pan, chi tani la'achuxcha canastaja p'usakch'o'ot? ");
INSERT INTO tpp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿T'asuch'a li jant'u lhimach'a'xayat'iti li jantu xliyu li jant'u lhit'ant'at pani li iklajunaw li k'ajalajk'ats'anant'iti, li jantu katamatsaman ixlamaskajank'an an fariseojnin chi an saduceojnini? ");
INSERT INTO tpp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pus akxni talhimacha'xalhcha li jantu yu an lhimaskajakan pani juniy an Jesús, yucha an ixlamap'a'sink'an an fariseojnin chi an saduceojnin. ");
INSERT INTO tpp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Akxni cha'alhcha xalakaat'un tanchun junkan Cesarea de Filipo an Jesús, jalhisakmiycha an ixt'alhtanan, jajuniy: ―¿Tasucha talaknajun an lapanakni li tichini yuchacha an isTs'alh Lapanaki? ");
INSERT INTO tpp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yu'uncha tajuniy: ―Ali'in tanajun ma jama'paxanaj Juan, chi ali'in tanajun ma Elías, chi ali'in tanajun ma Jeremías, u ma wa xatichicha yu ixlichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yucha jajuniy: ―Chi uxitnan, ¿tisi kit'inch'a nawnat'iti? ");
INSERT INTO tpp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pus an Simón Pedro alhtaylh, juniy: ―Uxint'i Cristojk'at'i, isTs'alh Dios, yu la'ajunta. ");
INSERT INTO tpp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Wa chuncha alhtaylh an Jesús, juniy: ―Sawalhch'a oxi ilht'uk'ani Simón, ists'alh Jonás, yucha an kimPay yu wilhchalh lakt'iyani chuncha manawniyan, jantu wa mijatapast'ak'atcha. ");
INSERT INTO tpp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chi k'it'in wachu ijkunan, uxint'i Pedrojk'at'i, chi la ix'ukxni ani chiwxi akyawya an kintajtan. An ixlakmakxkayaxtu lhinin jantu lay katilhajalhi an kintajtan. ");
INSERT INTO tpp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Akxta'niyani an xayavej an lhich'alhkat anu lakt'iyan, chux yu k'ach'i'ulaya'a ani lakaat'un, anu lakt'iyan wachu kach'i'ulakananta. Chi chux yu k'ax'ot'a'a ani lakaat'un, anu lakt'iyan wachu kax'otkananta. ");
INSERT INTO tpp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wa chuncha an Jesús, jajuniy an ixt'alhtanan li jantu xamati katajunilh li yucha Cristo. ");
INSERT INTO tpp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chi akxni, an Jesús tsukulhcha jajuniya ixla'ts'awalanti an ixt'alhtanan li ka'ana stak ma'alh'ajna yucha, la'acha'an Jerusalén, li katama'niya'. Jajuniy: ―Yu'uncha an laktatanincha jamacha'an Israel chi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sini yu akintama'niya'. Pero akla'awcho'oya ixlila'at'utu wilhchan. ");
INSERT INTO tpp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pus wa chuncha an Pedro t'atala'xtinulhi an Jesús, chi sawalhcha juniy: ―¡Jantu Jamach'alhkat Jesús, jantu layi ch'unch'ach'a k'at'ip'ut'ap'asa! Dioscha kalhi'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","An Jesús tala'asp'itlhi, juniy an Pedro: ―¡K'a'ost'i, Satanás, k'imama't'ijlay! Mu uxint'i jant'u yu lhak'ap'up'in yu ixnawin Dios, wa yucha an ixjatapast'ak'atchak'an lapanakni lhak'ap'up'in. ");
INSERT INTO tpp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Chi jajuniy an ixt'alhtanan an Jesús: ―Li xamati kint'alhtana jumputun, kamakawlhcha yu wa ixjatapast'ak'atcha, kaxa'a'ilhcha ixcruz yu lay kapuma'nikalh chi akinch'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mu wa tichicha li yu kama'alhtaxtuputuna ixjatsukunti, kama'ats'an'aya', pero yu kama'ats'an'aya ixjatsukunti kilakata, kala'cha'ana'. ");
INSERT INTO tpp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Chi an lapanak masi wanajcha ix'anu kajun'olh an lakamunulhpa, ¿tasu lhila'ancha li kama'ats'an'alhi an ixjatsukunti? ¿Tasucha lay kalhila'cha'ancho'oya ixjatsukunti? ");
INSERT INTO tpp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mu an isTs'alh Lapanak alhp'asi kaxlimj mina la ixtachaput an ixPay, ali an ix'angelhnini kajat'amina'. Akxni atamj atamjcha kamapalhnikana tuchini ilhtulhcha. ");
INSERT INTO tpp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Klajunaw yu sawalh, ali'in yu ani tat'ajun, jantu katitanilh sta akxni katala'ts'inacha kamina ch'alhkatna an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","La'achaxancha wilhchan la'pusli, an Jesús jat'a'alhcha tanchun talhman a'stitawk'a an Pedro chi ixt'uyunk'an yu wa lhit'ala'awnin, Jacobo chi Juan, wa ix'akstuk'an. ");
INSERT INTO tpp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","La ix'ukxlakapuchak'an yu'uncha, an Jesús, tapaxalh, an ix'ukxpu wa xlimjcha walh, tacha an wilhchan, chi an ixla'ch'it wa sut'ut'ucha walh, tacha an jatunkunu'. ");
INSERT INTO tpp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chi tatalakasulhcha an Moisés chi an Elías, ixtat'achiwiniycha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","An Pedro juniy an Jesús: ―Jamach'alhkat, Jesús, oxi li ani ikt'awnaw, li la'a'iy akyawya a'at'utu yu wa jach'itin cha'a': a'atam mi anucha, chi a'atam ix'anucha a Moisés, chi a'atam ix'anucha an Elías. ");
INSERT INTO tpp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chunchaka ixnawt'ajun, walh jala'atanchanulhcha la'atam jataputs'i, wa xlimjnik'acha, chi an laka jataputs'i ixchiwinkancha, ixnawkan: ―Yucha aniya yu ikmapayniy kinTs'alh, oxi iklhiwilay, k'a'asmatnit'iti yucha. ");
INSERT INTO tpp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Akxni chunchacha ta'asmatlhi an ixt'alhtanan an Jesús, tala'ta'antatawilhcha, sawalhcha ixtalaktalhanan. ");
INSERT INTO tpp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pus an Jesús, stalh jala'alh ixjalak'aych'apaycha, jajuniy: ―K'alakt'ayatcha jant'u k'alakt'alhanant'it. ");
INSERT INTO tpp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Akxni talaktalakatiyawcho'olhcha wa yucha an Jesuscha ixtala'ts'incho'oy. ");
INSERT INTO tpp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chi akxni tata'alhtaju'cho'olhcha an a'stitawk'a an Jesús, jajuniy: ―Jant'u xamat'i k'a'unit t'ach'a an la'ts'int'it, sta akxni akla'awcho'oya kit'in yu ikwalh isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wa chuncha an ixt'alhtanan an Jesús, talhisakmiy tajuniy: ―¿Pus tasu li an xamaestrojnin lhamap'a'sin tanajun li task'iniya li yucha an Eliasi p'ulhnaj kamilhi? ");
INSERT INTO tpp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yucha jajuniy: ―Chun sawalh, an Elías p'ulhnaja kamina', kamina mala'asijnini chux an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero klajunaw yucha kilachilhcha, pero jantu tamispalh, stak ta'ilhtulhi wa tani ta'ilhtuputulhcha, wachu chuni kata'ilhtuya an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pus akxni an ixt'alhtanan talhimacha'xalhi li yucha an jama'paxanaj Juani ixjalhixa'alay. ");
INSERT INTO tpp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Akxni tacha'alhcha tan lhilhuw ts'anaks ixlakyakalh, pumatam lapanak la'cha'alh an Jesús, tatso'ottanilhcha, juniy: ");
INSERT INTO tpp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Jamach'alhkat Jesús, lamapaynin ak'ink'uch'uninka an kints'alh, mu wa sawalh niy chi sawalhcha ma'alh'ajnan, a'lhuwcha ta'a'tay laka jikmi chi lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yucha amint'alhtanani xajkalhiminita, pero jantu lay tak'uch'uy. ");
INSERT INTO tpp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","An Jesús najun: ―¡Yu ch'away t'awnat jant'u jak'iklak'a'ininat'it, wa t'ani lap'ut'unatcha layat'itcha! ¿Tasu wanancha wa aktilat'a'aklatsukuyawi? ¿Tasu wanancha wa aktilalhilhitayaniyawi? ¡K'alhit'at'iti an ts'alh! ");
INSERT INTO tpp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Wa chuncha an Jesús, la'a'aymalhi an makxkay'un, pus makawlhcha an ts'alh, wa akxni ta'oxilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ixli'astan akxni wa ix'akstuchak'an ixtat'ayanalh an Jesús an ixt'alhtanan, stalh tala'alh, tajuniy: ―¿Tasu li jantu lay ijk'uch'uw kitnani? ");
INSERT INTO tpp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yucha jajuniy: ―Mu wanaj wa k'isi jak'iklak'a'ininat'it. Li k'ajak'iklaka'inint'it masi wa tacha lakat'ikt'icha xatalhts'i mostaza, layi ka'una'it ani a'stitawk'a, anu kast'alh p'it'i, chi ka'ana', layi k'a'ilht'uya'it wa tuchicha.  ");
INSERT INTO tpp_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ani makxkay'un chuncha kataxtuya li t'ap'ayniniyat'iti Dios ch'i li lhit'ask'ajayat'iti miwaytk'an. ");
INSERT INTO tpp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Anchaka ixtat'ajun xalakaat'un Galilea, an Jesús, jajuniy an ixt'alhtanan: ―An isTs'alh Lapanak kama'axta'kana la ixmaknik'an an lapanakni, ");
INSERT INTO tpp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","katama'niya', pero kala'awcho'oya ixlila'at'utu wilhchan. Pus an ixt'alhtanan sawalhcha ixtalhita'oxila'alhiy. ");
INSERT INTO tpp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Akxni tacha'alhcha la'acha'an Capernaúm an Jesús, an Pedro tala'cha'alh an talhach'inin ixlakata tajtan, talhisakmiy, tajuniy: ―¿Amimaestrojk'an mapalhlhi'ani ixlakata an tajtan? ");
INSERT INTO tpp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Chun, mapalhlhi'an ―jajuniya an Pedro. Walh akxni tanuchalhcha an Pedro, tan ixwilh an Jesús, yuchacha p'ulh xa'alast'uk'a, junkan an Pedro: ―Pedro, ¿t'asuch'a lhiwilayi? An xarejnin ani lakamunulhpa, ¿tisiyu'unchacha yu talhich'iy an tanlhuncha lhimapalhlhi'ati? ¿Yu'uncha an yu tat'alamispay an rejnin u yu'uncha an yu jantu tat'alamispay? ");
INSERT INTO tpp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","An Pedro juniy: ―Yu'uncha an yu jantu tat'alamispay. Pus an Jesús juniy: ―Ah, pus an yu tat'alamispay jantu tamapalay. ");
INSERT INTO tpp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero masi chuncha kitnan kajamapalhniyaw, para li jantu tu'u katanawlh. K'ap'inchi an lakxkan, k'amu'uya'a ami'anzuelo, chi an yu p'ulhnaj k'ach'ap'ayawya'a jatanti k'ak'ikmaxt'uya'a a'xtam tumin, yuch'ach'a k'alhimap'ala'a kilakata chi milakata. ");
INSERT INTO tpp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La'atam panch'e'ex an ixt'alhtanan an Jesús tala'cha'alh, talhisakmiy: ―¿Tichini yu palaycha xa'ay anu la ixlich'alhkat Dios? ");
INSERT INTO tpp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yucha t'asanilh pumatam jas'at'a chi ixtan'ajnichak'an yu'uncha yawlh. ");
INSERT INTO tpp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Chi jajuniy: ―Li jant'u map'axayatcha mijatsukuntik'an li jantu tacha ani jas'at'a unat'it jant'u k'at'ip'it'iti la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yu tacha ani jas'at'a kajakilhpatinijk'atsaya yucha yu xa'ay an la ixlich'alhkat Dios kajuna'. ");
INSERT INTO tpp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chi yu mapayniya xamati jas'at'a kilakata, kit'ini kila'a'iy. ");
INSERT INTO tpp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Pero wa tichicha yu mama'lhta'alhiniy xapumatam an jas'at'an an yu kintakiklaka'iy, palay oxi kalhtuj ch'ipixtanukalh palakskitin aya chiwx chi kawarjcha maka'ankalh tan putalhman alamalh. ");
INSERT INTO tpp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Payni'incha an lapanakni ani lakamunulhpa', mu tanlhuni alin yu jamama'lhta'alhiniy! Wa xliyu chuncha lhitask'iniy li katapasalh, ¡pero yu wa la'ayajcha ilhtuyi li xamati ka'ilhtulh tala'alhin, ay tala'alhini ilhtuy! ");
INSERT INTO tpp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Xliyu li mimaka u minch'aja ma'ilhtuyani yu jantu oxi, k'ach'a'xmaj'a. Palay oxi wa ch'anlht'uluku u maklht'uluku k'ach'ip'i laka jatsukunti, walh jantu masi li a'ts'a'o'oy, ch'i k'amakp'ink'a laka jikmi tan jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chi li mila'chulh ma'ilhtuyani yu jantu oxi, k'amaxt'u, k'amaj'a. Palay oxi wa la'atam mila'chulh k'ach'ip'i laka jatsukunti, walh jantu li a'tsa'ojoy mila'chulh k'amakp'ink'a tan jantu a'tam mixa jikmi. ");
INSERT INTO tpp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Jant'u k'ajaxk'ayla'ts'int'iti ani jas'at'an, mu yu'uncha talhit'ajun ix'angelhnink'an yu lhilhij tala'ts'inachalh an kimPay anu lakt'iyan.  ");
INSERT INTO tpp_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mu an yu walh isTs'alh Lapanak minta jama'alhtaxtunu an yu tats'an'ata. ");
INSERT INTO tpp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿T'asuch'a lhiwilayat? Li xamati lapanak jalhit'ajun tamciento ixborregojnin chi li kama'ats'an'alh la'atam, ¿chu jantu kajamakawnaka an noventa y nueve, chi ka'anacha puxkawna an la'atam an lakak'iwin? ");
INSERT INTO tpp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chi li akxni la'cha'ancho'oycha, sawalhcha t'alaj'achan, palay jantu an noventa y nueve yu jantu ixtats'an'ata. ");
INSERT INTO tpp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pus chunchacha amimPayk'an yu wilhchalh lakt'iyan, jantu la'a'iya li xamati kats'an'alh an jas'at'an. ");
INSERT INTO tpp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Li tu'u jantu oxi ilhtuniyan mint'ala'ajun, k'ala'p'it'i, k'at'alakch'iwin tan wa mi'akstuk'an, li asmatniyan, lhajaxt'uch'o'ocha amint'ala'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero li jantu asmatniyan, k'a'aylhip'i pumatam u pumat'uy, para li lhipumat'uy u lhipumat'utucha k'at'ach'iwinint'it. ");
INSERT INTO tpp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Li wachu jantu ja'asmatniy, an tan tata'ayxt'o'acha ixlapanakni Diosi k'aja'un, chi li wachu jantu ja'asmatniy, kalhi'ilht'ucha li jantu mispay Dios chi li wa tacha an yu wa talhimo'slayalhach'inincha tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Klajunaw, watuchicha yu jant'u k'at'imak'a'unt'iti chuncha kajunlhi ani lakaat'un, anu lakt'iyan wachu jantu katijunchalh, chi yu k'amak'awna'it'iti chuncha kawalh ani lakaat'un, anu lakt'iyan wachu chuni kajunanta. ");
INSERT INTO tpp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’A'tam klajumpalaw, li mint'uyunk'an wa tami k'ak'ats'at'it ani lakaat'un ch'i k'ask'init'it tu'u an Kimpay yu wilhchalh lakt'iyan, kataxta'niyan. ");
INSERT INTO tpp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mu tan ixt'uyunk'an u ixt'utunk'an ta'ayxto'nun la kinta'a'ut ancha ikjapujayalh. ");
INSERT INTO tpp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wa chuncha an Pedro stalh la'alh, juniy: ―Jamach'alhkat Jesús, ¿tasu a'chuxcha lay akmala'mixiniya kint'ala'ajun li tu'u yu jantu oxi ki'ilhtuniya? ¿A'tujun? ");
INSERT INTO tpp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","An Jesús alhtaylh, juniy: ―Jantu ijkunan li a'tujun, ijkunan sta a't'utump'uxamkaw an a'tujun. ");
INSERT INTO tpp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’An lhich'alhkat an lakt'iyan tachanu pumatam ay jamach'alhkat, yu jat'asanilhcha an ixma'tapatsanin mu ix'ilhtuputuncha cuenta. ");
INSERT INTO tpp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Walh akxni ix'ilhtut'ajuncha ixcuenta an ay jamach'alhkat, talhicha'anilh pumatam yu ixli'aniy la'alhuw millón ixtumin, jantucha lay ixput'e'echo'okan. ");
INSERT INTO tpp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chi mu jantucha lay mapalayi an yu lhicha'ankalh, pus najun an ay jamach'alhkat li kast'akalhcha, chux ixt'iwi chi ixjas'at'an chi yu lhit'ajuncha ixlaktanlhun, para li anchacha kalhitamalh. ");
INSERT INTO tpp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pus an ma'tapatsana tatso'ottanilhcha an ay jamach'alhkat, chi tapayniniycha, juniy: “Lamapaynin ak'imp'akxanin, akmapalhni'oyan.” ");
INSERT INTO tpp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pus an ay jamach'alhkat mu mapayniycha, makawlh, mak'akxanilhi an ixjalhi'aninti. ");
INSERT INTO tpp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero akxni taxtulhcha anchunu ma'tapatsana, paxto'lhi pumatam ixt'ama'tapatsan yu wachu ixt'alalhi'aniy tamciento tumin de plata, tacha la'at'utu malhkuyu xatapatsat, chi pixtuch'apachalh ixmaksk'anjwaputuncha, juniy: “Ak'imap'alhnincha an yu k'ilhip'iniy.” ");
INSERT INTO tpp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pus an ixt'ama'tapatsan tatso'ottanilh la ixjach'aja, chi juniy: “Lamapaynin ak'imp'akxanin, akmapalhni'oyan.” ");
INSERT INTO tpp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero yucha jantu k'is pakxaniputulh, lhinawlhi li kamalaklhchawkalh sta li kamapalh'olh. ");
INSERT INTO tpp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","An ali'in ixt'ama'tapatsanin mu tala'ts'ilhi tacha an tapasalh, pus sawalhcha talhila'ta'oxila'alhilh, chi ta'alhcha juninini an ay jamach'alhkat tacha an tapasalh. ");
INSERT INTO tpp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wa chuncha an ay jamach'alhkat, t'asanilhi anchunu ixma'tapatsana, chi juniy: “¡Ayajk'atsan ma'tapatsan! Kit'in ikmak'akxani'ojoni an yu k'ilhip'iniy, mu k'int'ap'ayninin. ");
INSERT INTO tpp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Jantu wachuchuni k'axmak'akxanin amint'ama'tapatsan?” ");
INSERT INTO tpp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wa chuncha an ay jamach'alhkat, mu talh'amancha, pus lhinawlhi li kamalaklhchawkalh, sta li kamapalh'olhi an yu lhi'aniy. ");
INSERT INTO tpp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Akxni chunchacha jajun'olh an Jesús, jajuniy: ―Wachu chuni kata'ilhtuyan an Kimpay, yu wilhchalh lakt'iyan, li jantu chux la mijalhunutk'an mala'mixiniyat ixtala'alhin mint'ala'ajunk'an. ");
INSERT INTO tpp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Akxni chunchacha chiwin'olh an Jesús, taxtulhcha an xalakaat'un Galilea, alhcha xalakaat'un Judea, ixtapiktutamcha ayxkan junkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chi lhuw lapanaki tat'a'alh, ancha jak'uch'uchalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Wa chuncha tala'cha'alh an lapanakni an yu ixjajunkan fariseojnin chi ixtalhila'ts'intanuycha, ixtajuniy: ―¿Oxi li xamati lapanak kamakawlh ixt'iwi wa tuchicha ixlakata? ");
INSERT INTO tpp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","An Jesús jajuniy: ―¿Jant'u p'unawt'at'iti tan najun Dios, li akxni ilhtulh an lapanak, ilhtulhcha an lapanak chi ilhtulhcha an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chi an Dios najun li xliyu an lapanak kamakawna ixpay chi ixnati, li ixt'iwicha kat'atawla', chi an ixt'uyunk'an li tachanu wa pumatamcha katajuna'? ");
INSERT INTO tpp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jantucha tacha ixt'uyunk'ani katitawalh, tachanu wa pumatamcha katajuna'. Pus xliyu li yu Dioscha jamala'xto'lhi, an lapanak jantucha kajalamamakawnilh. ");
INSERT INTO tpp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","An Jesús tajuniy: ―¿Pus tasu li najuncha an Moisés li layi ak'ilhtuw la'atam jalhiki yu akpumakajuw kint'iwik'ani? ");
INSERT INTO tpp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yucha jajuniy: ―Wa xliyu jant'u k'is ja'asmatnanat'it, xliyu talhimakawnincha an Moisés, pero an Dios jantu chuni najun. ");
INSERT INTO tpp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kit'in klajunaw, wa tichicha lapanak yu makajun ixt'iwi, li jantu ixlakata li wa xamaticha t'atamalhi an t'aku, chi li t'atsukupalaycha pumatam t'aku an lapanak, tala'alhincha ilhtuy, chi yu t'atsukupalaycha wachu an yu makawkantacha t'aku, wachu tala'alhincha ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tajuniy an ixt'alhtanan an Jesús: ―Li chuncha t'atapasay ixt'iwi an lapanak, jantu oxi akt'atsukukalh. ");
INSERT INTO tpp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Pus an Jesús jajuniy: ―Jantu lhichuxi lay chuncha tsukukan, wa yu chuncha jalhisakxtulh an Diosi lay chuncha tatsukuy. ");
INSERT INTO tpp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ta'alini yu jantu katijat'atsukukalh, yu wa chunchacha tatsukulh. Chi ta'alini yu wa yucha an ixt'alapanaknichak'an chuncha ta'ilhtulh para li jantu kajat'atsukukalh. Chi ta'alini yu wa ix'akstuchak'an jantu jat'atsukukan wa xliyu li palay oxi tat'atapatsaputun an Dios yu ch'alhkatnan lakt'iyan. Yu layi tsukuy wa ix'akstu, chunchacha katsukulh. ");
INSERT INTO tpp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wa chuncha jalhicha'anikalh jas'at'ani an Jesús, para li kajalaklakpach'apalh chi li kajalhitapaynilh, walh an ixt'alhtanan an Jesús, talaj'aymastuklhi an yu ixtalhi'anta ixjas'at'ank'an. ");
INSERT INTO tpp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero an Jesús, jajuniy: ―K'ajamak'awnit'iti an jas'at'an li akintala'milh, jant'u k'ajalaj'aymast'ukt'it, mu yu'uncha ixnawink'ani an lhich'alhkat an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wa chuncha, jalaklakpach'apa'olh an jas'at'an, alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","La'atam wilhchan pumatam ts'alh yu ixlit'ajun ixtumin, juniy an Jesús: ―Oxi maestro, ¿tasucha aklhit'alalh para li aklhitsukulh an jatsukunti yu jantu min'ojoyi? ");
INSERT INTO tpp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","An Jesús, alhtaylh juniy: ―¿T'asu li k'i'uniycha li sawalhcha oxi ikmaestrojo? Jantu xamati yu oxi lapanak, yu chun wa pumatam, Dios. Li lhits'uk'up'ut'uni an jatsukunti yu jantu min'ojoy wa k'a'ilht'ucha tacha an najunta laka lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","An ts'alh najun: ―¿Tanyucha lhamap'a'sini? Pus an Jesús juniy, an tan najunta: ―Jant'u kat'ijama'nin, jant'u k'at'it'at'amat'i yu jant'u yu t'at'a'un, jant'u k'at'ija'alhawan, jant'u k'at'imaslak'at'in. ");
INSERT INTO tpp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Oxi k'ala'ts'i mimpay chi minati ch'i k'amap'aynit'i mint'alapanak t'ach'a akst'u map'aynik'an. ");
INSERT INTO tpp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Pus an ts'alh najun: ―Chunchacha k'ilhtuy wa kintajas'at'at, ¿tanyucha yu kintits'an'aniya? ");
INSERT INTO tpp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","An Jesús juniy: ―Li ts'ajwi ts'uk'up'ut'un, k'ast'at'i an yu lhit'a'un, ch'i k'ajaxt'a'nincha an tumin an jakilhpatinin, ch'unch'a k'alhits'uk'uya'a yu laj'oxi tanlhun an lakt'iyan, ch'i k'at'ana'acha, ak'inch'a'o'aya'acha. ");
INSERT INTO tpp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Akxni chunchacha asmatlhi an ts'alh, ancho'olhcha, sawalhcha ta'oxila'alhi'alh, mu lhuw ixtanlhuni ixlit'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Pus akxni an Jesús, jajuniy an ixt'alhtanan: ―Sawalh lhima'anxkayi kacha'ana pumatam yu jamatumin laka lhich'alhkat an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chi a'tam klajumpalaw, li palay wa lasi la'atam camello kala'pusli la ix'istaj makskat, walh jantu li katanuchalh la ixlich'alhkat Dios xamati jamatumin lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pus sawalhcha ixtalhi'a'niya akxni chunchacha ta'alha'asmatlhi an ixt'alhtanan an Jesús, chi tajuniy: ―¿Pus chuncha tisiyuchacha lay kata'alhtaxtuya'a? ");
INSERT INTO tpp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Chi sa'cha jala'ts'in, jajuniy: ―Yu jantu lay ilhtuy an lapanak, an Dios yucha layi ilhtu'ojoy, wa tuchicha. ");
INSERT INTO tpp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","An Pedro, ja'alhtayanalh, najun: ―Kitnan iklhimakaw'otawcha kilaktanlhunk'an chi iklach'a'o'atawcha, ¿tisuncha akla'a'iyawi? ");
INSERT INTO tpp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","An Jesús jajuniy: ―Sawalhi ani yu klajunaw akxni chuxcha kalaklasast'i'okana, kit'in isTs'alh Lapanak aktawlanta la kilhich'alhkat, tan iklhajaxtuta. Uxitnan yu kilach'a'o'ayaw, wachu ka'alina tan k'at'awlht'achi'it, lakakawt'uyi juntachalh, chi uxitnani k'ajach'alhk'atnaniya'it an kilhmakkawt'uy xalapanakni Israel. ");
INSERT INTO tpp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Wa tichicha yu kint'alhtanan chi lhimakajuncha ixcha'a, u ixjat'ala'awnin, u ixjamatsanan, u ixpay, u ixnati, u ixt'iwi, u ixjas'at'an, u ixlakaat'un, tam cientoj palayi kaxta'nikana', chi kaxta'nikana jatsukunti yu jantu min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero ixluwk'ani yu p'ulhnaj chaway, yu'uncha astani katajuna', chi yu astan chaway p'ulhnaja katajuna'. ");
INSERT INTO tpp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Mu an lhich'alhkat awint'i lakt'iyan tachanu pumatam jamalakaat'un, yu ka'alh japuxkawna wats'isin lapanakni yu tama'tapatsay, para li kata'alh tapatsanin tan ch'anta ix'uva. ");
INSERT INTO tpp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chi akxni jat'atamakawlhcha an lapanakni tani chunchacha kajamapalhniya tamin wilhchan, jamala'achalhcha an tan ch'anta ix'uva. ");
INSERT INTO tpp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Walh a'tam taxtunipalhi an jamalakaat'un akxni jantuka' ix'atunkujun, katacha las nuevejcha, chi jala'ts'impalh ali'ini an ixtan'ajni la'acha'an yu jantu tu'u ixta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pus jajuniy: “Wachu akilat'a'awi tapatsanin an tan ikch'anta ki'uva, aklamapalhniyawcha mimpanch'e'exk'an.” Pus tat'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ka atunkujuncha, an jamalakaat'un a'tam taxtunipalh. Chi akxni ixta'oxat'ajuncha, las trescha, a'tam taxtunipalh, chi wanajcha chuni jamala'achapalh an tan ch'anta ix'uva an yu jakila'cha'alh. ");
INSERT INTO tpp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Walh a'tam taxtunipalhi puta'oxay katacha las cincojcha ixjunt'ajun, jala'cha'ampalhi yu jantu tu'u ixtapatsatk'an, jajuniy: “¿Tasu li wa anicha tuntakuju t'awnat'iti?” ");
INSERT INTO tpp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yu'uncha tajuniy: “Wa xliyu jantu xamati ikt'atapatsayaw.” Yucha jajuniy: “Pus wachu akilat'a'awi tapatsanin an tan ikch'anta ki'uva, aklamapalhniyawcha mimpanch'e'exk'an.” ");
INSERT INTO tpp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Chi akxni tats'isit'ajuncha, an jamalakaat'un juniy an yu mala'ts'ilhi'anita tan ch'anta ix'uva: “K'ajat'asanincha an lapanakni an yu tatapatsalh chi k'ajaxt'a'nincha ixtalhajak'an, p'ulhnajcha k'ajamap'alhnini an yu astancha tatanulh, chi ixli'astan yu'uncha an yu p'ulhnajcha tatanulh tatapatsay.” ");
INSERT INTO tpp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pus akxni tacha'alhcha an yu ta'oxaycha las cincojcha ixjunt'ajun tatanulh, pumatamjtamin a'tsayi talhajalh, tacha lhajakan tam wilhchan. ");
INSERT INTO tpp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chi akxni wachucha tacha'alhi an yu p'ulhnaj tatanuchalh tatapatsay, ixtapast'ak'a li sna palaycha katalhajaya', pero wachu wa chuni tajama'lhtayanalh ixtalhajak'an. ");
INSERT INTO tpp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pus akxni tajama'lhtayanalhcha, talhichiwiniycha an jamalakaat'un, ");
INSERT INTO tpp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","chi tajuniy: “Ani yu astancha tachilh wa tam horaja tatapatsalh, walh wanajch'a ch'uni jamap'alhnin. Kitnan iklhitayaniwi kilho'otk'an chi an lhi'ichi tam wilhchan.” ");
INSERT INTO tpp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pus an jamatumin juniy xapumatam: “Kint'ala'ajun, jantu tu'u yu jantucha oxi k'ilhtut'ajun, ¿ch'u jant'u k'int'at'amak'awi t'ani ch'unch'ach'a k'alhajaya'a tam wilhchan? ");
INSERT INTO tpp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","K'alhip'inchicha yu mintalhaja, chi ani yu astancha tanulh tapatsay wanajcha chuni akmapalhniya'. ");
INSERT INTO tpp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Chu xamati akijuna li jantu chuni yu k'ilhtuy li kintumini yu iklhimapalay? ¿U sna wa lhaxk'ayanani li kit'in oxi iklapanak?” ");
INSERT INTO tpp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Chuncha yu kajuna', ixluwk'ani yu p'ulhnaj chaway, yu'uncha astani katajuna', chi yu astan chaway p'ulhnaja katajuna', mu lhuwi yu jat'asanikanta, pero wa lakats'uniya yu jasakxtukan. ");
INSERT INTO tpp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Akxni an Jesús tama'ast'a'alhcha an la'acha'an Jerusalén, laka tijcha, an ixpumakawt'uyk'an ixt'alhtanan wa lakatamcha ja'ilhtu'olh, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Chaway ti'anawcha la'acha'an Jerusalén, an isTs'alh Lapanak la ixmaknichak'an an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sini kama'axta'kana', katalhimuk'aya wa tanlhuncha chi katama'niya'. ");
INSERT INTO tpp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chi yu'uncha wachucha katama'axt'a'a la ixmaknik'an an yu jantu judiojnin, para li wa katalhila'ts'ilhcha chi katala'ana'malhcha, chi katamakxtukmuk'alhcha laka cruz, pero ixlila'at'utu wilhchan kala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wa chuncha tichiyucha t'aku ixt'iwi tichi lapanak ixjunkan Zebedeo, la'cha'alhi an Jesús, ixjat'a'anta ixt'uyunk'an ists'alan, Jacobo chi Juan, tatso'ottanilhcha an Jesús, chi isk'iniycha lamapaynin. ");
INSERT INTO tpp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pus an Jesús juniy: ―¿T'isunch'a lak'ask'ini? An t'aku najun: ―K'anawi li ani ixt'uyunk'an kints'alan katapiktutawlhcha'ani an la milhich'alhkat, pumatam tan oxi mimpa'xti, chi an pumatam la milhijama'xi. ");
INSERT INTO tpp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","An Jesús alhtaylh juniy: ―Jant'u k'ats'ayat t'uch'ini sk'inatcha. ¿Layi k'alhit'ayaniya'it an ma'alh'ajnat yu akma'alh'ajnana'? Yu'uncha ta'alhtaylh tajuniy: ―Chun kalaya'. ");
INSERT INTO tpp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Pus an Jesús jajuniy: ―Chun, k'ap'uma'alh'ajnana'itcha yu akpuma'alh'ajnana', pero li akilalakpa'xtitawlaw jantu lay kit'in aktilamakawniw, yucha an kimPayi kajamakawniya yu ancha jalhisakxtuta. ");
INSERT INTO tpp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Akxni chunchacha ta'asmatlhi an ali'in ixpumakawk'an ixt'alhtanan an Jesús, tat'alatalh'amnilhi an ixt'uyunk'an. ");
INSERT INTO tpp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pus an Jesús, jat'asanilh, jajuniy: ―K'ats'ayat'iti li an xajamach'alhkatni ta kilhmakchux lapanakni wa talhinajuncha, chi an yu xalaj'ajin yu'uncha yu palaycha wa talhinajun. ");
INSERT INTO tpp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ani, uxitnan, tam. Ani, yu xa'ay jumputun p'ulhnajcha kajatapatsanilhi an ali'in. ");
INSERT INTO tpp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chi yu tukancha palay xa'ay jumputun uxitnan, mima'tsukuk'ani kajuna'. ");
INSERT INTO tpp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mu masi kit'in yu ikjunlhi isTs'alh Lapanak, jantu ikminta li wa akilak'ilhtunikalhcha an tapatsat, kit'in iklamintaw tapatsaninin, chi ikminta ma'axta'na an kijatsukunti para li lhuw lapanakni katata'alhtaxtulh. ");
INSERT INTO tpp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Akxni tataxtucho'olhcha la'acha'an Jericó, an Jesús, wa ts'ananacha ixch'a'o'akanta. ");
INSERT INTO tpp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Walh ixt'uyunk'an la'la'lhtulu'un lapanakni, yu sa' ixtawilanalh waniy laka tij, taxa'alaycha an Jesús, akxni ta'asmatlhi li ancha ixla'pust'ajun, tajuniy: ―¡Jamach'alhkat, Ists'alh David, lamapaynin akilalhi'a'tayjuw! ");
INSERT INTO tpp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Pero an ali'in lapanakni wa talaj'aymalhi an la'la'lhtulu'un lapanakni, para li ma sa'cha katalajkilhulh, pero yu'uncha palay p'as ixtaxa'alay, ixtajuniy: ―¡Jamach'alhkat, Ists'alh David, akilalhi'a'tayjuw! ");
INSERT INTO tpp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pus an Jesús, sa'cha tayalh, jat'asanilhcha chi jajuniy: ―¿T'isunch'a lak'ask'inat akla'ilhtuniwi? ");
INSERT INTO tpp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yu'uncha ta'alhtaylh: ―Jamach'alhkat Jesús, klakask'inaw li akilamalakawaniw. ");
INSERT INTO tpp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pus wa chuncha an Jesús, jamapayniycha, pus jalaklakpuch'apalh, walh wa tukan tajalakawanalh chi tach'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Akxni waniycha ixtacha'ant'ajun la'acha'an Jerusalén, chi ixtacha'antacha la'acha'an Betfagé, a'stitawk'acha ixtat'ajun tan junkan Laka Olivojnin, an Jesús jamala'achalhcha ixt'uyunk'an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jajuniy: ―K'ap'inchi'it an tan tasuy la'acha'an, k'ala'ch'ip'ina'it ch'iyawkanta la'atam xanati burro chi t'ayalh ixjas'at'a, k'ax'ot'iya'it'it chi akilalhiminiyawi an la'at'uy. ");
INSERT INTO tpp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Li xamati tu'u tajunan, k'a'una'it li yucha an Jamach'alhkati jama'lhtask'iniy, li wa tukan kajaxta'nicho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Tacha ani tapasalh, para li kawalhi tacha an ixnajunta an yu ixlichiwiniy ixchiwinti Dios, akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","K'a'uni an istsi la'acha'an Sión: “La'mintancha amiRey, yucha jantu ayajk'atsay, puminta la'atam burro, jas'at'a burrojo puminta, ixjas'at'a la'atam jatapakxat yu mak'uk'anan.” ");
INSERT INTO tpp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pus an ixt'alhtanan an Jesús, ta'alhcha, chi chunchacha ta'ilhtulh tacha an jajunilh. ");
INSERT INTO tpp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Talhiminilhcha an xanati burro chi an xajas'at'a, talak'aymuk'anilhcha ixla'la'ch'itk'an chi yucha putawk'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chi mu wanajcha lhilhuw, ixtamamaniycha ixla'la'ch'itk'ani an laka tij, chi an ali'in ixtala't'e'e'iycha xax'oy k'iw, ixtamamaniycha an laka tij. ");
INSERT INTO tpp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","An yu ixtap'ulanan chi an yu astan ixtamintachalh, ixtalhit'asaycha, ixtalaknajun: ―¡Alhp'asi an isTs'alh David! ¡Oxi yu an Dios makminta! ¡Hosanna kanawkalhi an lakt'iyan! ");
INSERT INTO tpp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Akxni tanuchalhcha la'acha'an Jerusalén an Jesús, chux an lapanakni an yu ancha jamacha'an sawalhcha ixtalhakapu'an, ixtalaknajun: ―¿Tisiyuchacha aniya? ");
INSERT INTO tpp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pus an ali'in lapanakni tanajun: ―Ani Jesús, yucha lhichiwiniy ixchiwinti Dios, jamacha'a Nazaret, xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tanuchalhi laka tajtan an Jesús, jalakxkawxtu'olhi an yu ixtajast'anan chi ixtajatamawnan laka tajtan. Jala'ma'pusp'itni'olhi an ixmesajk'an an yu ixtamapaxay tumin chi an ixtants'ik'an an yu ixtast'ay paloma. ");
INSERT INTO tpp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jajuniy: ―Ts'o'muk'akanta tan najunta: “An kincha'a putapaynin cha'a kajunkana'”, walh uxitnan wa mimpa'alhawnachak'ani ilht'ut'at'it. ");
INSERT INTO tpp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ixli'astan an laka tajtan, an Jesús tala'cha'alh yu wa la'la'lhtulu'un chi yu wa lakch'anlht'ulukun, chi jak'uch'ulhcha. ");
INSERT INTO tpp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Walh an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin, mu ixtala'ts'incha tacha an laj'oxi tanlhun ixlak'ilhtuy an Jesús, chi ixta'asmat'acha li an jas'at'an ixtalhit'asaycha an laka tajtan, ixtalaknajun: “¡Jama'alhtaxtununi an ists'alh David!”, pus talhitalh'amalh. ");
INSERT INTO tpp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chi tajuniy an Jesús: ―¿Asmat'a tacha an talaknajun? An Jesús jajuniy: ―Chun, ik'asmat'a. ¿Jant'u a't'am p'unawt'at'iti tan najunta?: La ixmilhpatk'an an jas'at'an chi an lakt'ikt'inka yu tats'ik'iyka ilht'u li oxi katamilhpanin. ");
INSERT INTO tpp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pus jalaj'oslicha an Jesús, taxtulhcha an la'acha'an, alhcha la'acha'an Betania, anchacha la'akujchalh. ");
INSERT INTO tpp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wats'isin ancho'olhcha an tan ay la'acha'an, walh chawanalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chi waniy an laka tij la'ts'ilh a'atam xak'iw higo, pus alh, pero jantu tu'u la'cha'aninilh xajatawk'at, wa si xax'oy, chi juniy: ―¡Jantu a'tam katawk'anini mijatawk'at! Walh watukan xixli an xak'iw higo. ");
INSERT INTO tpp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Chi mu tala'ts'incha an ixt'alhtanan, talhi'a'niycha, tajuniy: ―¿Tasu li wa lascha xixli an xak'iw higojo? ");
INSERT INTO tpp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Pus an Jesús, jajuniy: ―Iklajunaw, li jak'iklak'a'ininat'it sawalh, li jantu wa tamj tamjcha p'ast'ak'at'it, jantu wa tacha ani k'ilhtulh an xak'iw higojo k'at'i'ilht'ut'it, layi k'a'una'it ani a'stitawk'a: “K'a'ost'i, an alamalhcha k'at'a'uchi',” chi kajuna'. ");
INSERT INTO tpp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chi wa tuchicha k'at'ap'aynisk'ina'it, li jak'iklak'a'ininat'it, k'axt'a'nik'ana'it'it. ");
INSERT INTO tpp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Akxni cha'alhcha laka tajtan an Jesús, an xalaj'ajin sacerdotejnin chi an laktatanincha yu ancha jamacha'an, tala'cha'alhi akxni ixmasut'ajun, chi tajuniy: ―¿T'asu li ch'unch'ach'a lay lak'ilht'uy ani tanlhuni? ¿Tisiyuchacha makawniyan li k'alak'ilht'u? ");
INSERT INTO tpp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yucha ja'alhtaylh jajuniy: ―Wachu aklalhisakmiyaw la'atam chiwinti, li akilajunaw, wachu aklajunawi tuchini laycha chuncha iklhilak'ilhtuy ani tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tacha an ixjama'paxanan an Juan, ¿tisiyuchacha ixlijuniya, Dios u wa yucha an lapanaknicha ixtalhijuniy? Pus wa chuncha tsukulhcha talhilakchiwiniy, talajuniy: ―Li kajunaw li Dios, akintajunan: “¿P'us ch'i li jant'uch'a k'iklak'a'it'iti?” ");
INSERT INTO tpp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chi li kajunaw li wa yu'uncha an lapanaknicha ixtalhijuniy, jalhitalhamniti an lapanakni, mu ixchuxk'ani takiklaka'iy li an Juan ixchiwinti Diosi ixlichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pus tajuniy an Jesús: ―Jantu ijk'atsayaw. Pus yucha wachu jajuniy: ―Wachu jantu aktilajuniwi tuchini chunchacha lay iklhilak'ilhtuy ani tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Chi, ¿t'asuch'a lhiwilayat'iti? Pumatam lapanak ixjalhit'ajun ixt'uyunk'an ists'alan, chi an lapanak juniy an xapumatam ists'alh: “Kints'alh, k'ap'inchi tapatsana an tan ikch'anta ki'uva.” ");
INSERT INTO tpp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","An ts'alh alhtaylh an ixpay, juniy: “Jantu ijk'uxa'an.” Pero ixli'astan, astan nawlh, chi alh. ");
INSERT INTO tpp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chi an pumatam ts'alh wanajcha chuni junkan li ka'alh tapatsana', yucha najun: “Chuni kimpay, ak'ana'.” Pero yucha jantu alh. ");
INSERT INTO tpp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ani ixt'uyunk'an ts'alan, tisiyuchacha yu ilhtulh an yu jalhijunilh an ixpayk'ani? Ta'alhtaylh an Jesús, tajuniy: ―Yucha an p'ulhnaj junikalh. Pus an Jesús jajuniy: ―Klajunaw li an yu talaklhach'inin tanlhun lhimapalhlhi'at chi an wa aya talay t'akunin, tatap'ulhniyani tatanuyachalh an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mu takimasunichincha an jama'paxanaj Juan yu oxi tij, walh uxitnan jant'u k'iklak'a'it'it, apalij yucha an talaklhach'inin tanlhun chi an wa aya talay t'akunini takiklaka'ilh. Pero uxitnan masi chuxi la'ts'in'o'ot'it, jant'u mak'a'unt'iti mintala'alhink'an, jant'u k'iklak'a'it'it. ");
INSERT INTO tpp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’K'a'asmatp'alat la'atam pulhamacha'xan: ixt'ajun pumatam jamalakaat'un lapanak, yucha ch'anlhicha ix'uva chi kurralhnulhcha, chi ilhtulhcha tan kapach'itkana an uva, chi yawlhcha a'atam torre, yu palhistakna. ’Chi ixli'astan jamach'ixta'nilhcha tichi yu'uncha lapanakni an ixlakaat'un, chi yucha alhcha ma'at. ");
INSERT INTO tpp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Akxni chilhcha ixpaku an uva, jamala'achachalhcha ixma'tsukunin an jamalakaat'un lapanak, para li an yu jamach'ixta'nita ixlakaat'un kataxta'nilhcha yu ixnawin. ");
INSERT INTO tpp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero an yu jamach'ixta'nikanta lakaat'un, t'o' tach'apa'ochalhi an ixma'tsukunin an jamalakaat'un: pumatam stakcha talakasamalh, an pumatam tama'nilhcha, chi an pumatam stakcha talakat'alhmalh. ");
INSERT INTO tpp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","An jamanawin lakaat'un a'tam jamala'achapalhchalhi ali'in ixma'tsukunin, palaycha ixluwk'an, pero an yu ixjamach'ixta'nikanta lakaat'un wanajcha chuni ta'ilhtupalh. ");
INSERT INTO tpp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Ixli'astan makminchalhcha yu ists'alh an jamalakaat'un lapanak, mu ixnajun: “Ani mu kints'alh, kata'asmatniya'.” ");
INSERT INTO tpp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero akxni tala'ts'ilhcha an ists'alh, an yu ixjamach'ixta'nikanta lakaat'un, talajuniy: “Yucha anicha yu jamanawin kajuncho'oya an lakaat'un. Kama'niw, walh ki'anuchak'ani kajuna an yu ixnawin ka'ixwalh.” ");
INSERT INTO tpp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pus tach'apachalh, tatamakxtulhi an tan ch'ankanta uva, tama'nilh. ");
INSERT INTO tpp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Chaway akxni kamina an jamanawin an tan ch'ankanta uva, ¿t'asuch'a lhiwilayat kaja'ilhtuya an yu tatapatsay tan ch'ankanta uvaja? ");
INSERT INTO tpp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yu'uncha ta'alhtaylh, tajuniy: ―Kajama'ni'oya', jantu k'is katijamak'akxanilh, chi xamati'incha kajamach'ixta'nicho'oya an ixlakaat'un, yu kataxta'niya wa tukani yu ixnawin akxni ixpakucha an ix'uva. ");
INSERT INTO tpp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","An Jesús jajuniy: ―¿Jant'u a't'am p'unawt'at'iti an tan ts'o'muk'akanta?, tan najun: An chiwx an yu wa tala'amaj'alh an yu tayajuy cha'a, apalij yucha yu palay lhitapalay chaway. Yucha an Diosi chuncha ilhtulh. Chi chaway sawalhcha lhi'a'niyaw. ");
INSERT INTO tpp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Xliyu iklalhijunaw, li uxitnan k'amaxt'unik'ana'it'iti an ixlich'alhkat Dios, chi ali'ini kajaxta'nikana yu taja'asmatnan sawalh. ");
INSERT INTO tpp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yu la ix'ukxni ani chiwx katamayanta, wanaj lakt'ikt'i kajun'oya', chi yu kaputamaya ani chiwx, wanaj po'xmi kajun'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Akxni chunchacha ta'alha'asmat'olh an Jesús, an xalaj'ajin sacerdotejnin chi an fariseojnin, talhimacha'xalhi li yu'uncha ixjalhichiwint'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pus ixtach'apayawputuncha, wa yu tatalhanajlalh, mu an lapanakni an yu ancha jamacha'an ixtakiklaka'iya li yucha ixchiwinti Diosi ixnajun. ");
INSERT INTO tpp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A'tam jalhixa'alapalh la'atam pulhamacha'xani an Jesús, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―An lhich'alhkat anu lakt'iyan, tachanu pumatam rey, yu mala'asijninilh k'atan ists'alh akxni tama'xto'lhi. ");
INSERT INTO tpp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","An rey jamala'achalhcha an ixma'tsukunin li kata'alhcha jalakt'asaninin an yu jat'awayputunkan, pero yu'uncha jantu tak'uxa'alhi ma'waynin. ");
INSERT INTO tpp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Chi a'tam jamala'achapalhi ali'in ixma'tsukunin an rey, jajuniy: “K'ajak'i'unitcha an yu jamak'atsaanikantacha li ikmala'asijnitacha an wayt. An kintorojnin chi an ali kijatapakxat yu ixtalaj'ontacha jala'ma'nikalhcha, la'asij'ojotacha, katamilhcha ani laka k'atan.” ");
INSERT INTO tpp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero an yu jat'awayputunkan jantu k'is talhakapu'alh, atamj atamj intacha lhitaxtunilh. Pumatam alh la ixkuxtu, pumatam alhcha jast'ana'. ");
INSERT INTO tpp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chi an ali'in tach'apachalhi an ma'tsukunin stakcha jalaksamakalh, sta jala'manikalhi an ma'tsukunin. ");
INSERT INTO tpp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Akxni k'atsaalhi an rey, lhitalh'amalh, pus jamala'achalh isoldadojnin, wachu jakima'ni'okalhi an yu ixtajama'nininta chi an la'acha'an an tan ixtawilanalh tala'xawalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","An rey jajuniy an ixma'tsukunin: “La'asij'ojotacha an wayt, pero an yu ixjat'asanikan ixjat'awayputunkan jantu ixtat'acha'ani li kaxtamilh. ");
INSERT INTO tpp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","K'ap'inchi'it'iti an tan lala'paxto'ta tij chi chux yu p'axt'o'at'it k'a'aylhit'ana'it'itcha.” ");
INSERT INTO tpp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pus tataxtunilhcha laka tij an ma'tsukunin, lhuwcha tama'ayxto'lhi yu ixtapaxt'o'a, yu wa ay tajunita lapanakni chi yu oxi lapanakni, wanajcha lhilhuwi junkalh an tan lakwaykan. ");
INSERT INTO tpp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Walh akxni tanuchalhcha an rey, jala'ts'incha an yu talakwajin, la'ts'ilh pumatam lapanak yu jantu ixla'ch'ita yu pu'ankan tan tama'xto'kan. ");
INSERT INTO tpp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pus juniy: “Uxint'i, ¿t'asich'a lhit'anuch'ita li jant'u la'ch'ita yu task'iniy tan tama'xto'kani?” Pero yucha jantu k'is ja'alhtayanalh. ");
INSERT INTO tpp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wa chuncha an rey, jajuniy an yu ixtala'ts'ilhi'an an tan lakwaykan: “K'alakch'anch'it'it ch'i k'ala'ma'ch'it'it, ch'i k'ak'imak'ap'it'itcha anu ma'spa tan puts'ista. Ancha ka'alina alhut chi wa xwat'at'acha kalaktasat'awkana'.” ");
INSERT INTO tpp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Mu lhuwi yu jat'asanikan, pero wa lakats'uniya yu jasakxtukan. ");
INSERT INTO tpp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wa chuncha ta'alhcha an fariseojnin, chi talalhima'achiwinilhcha tani katalhit'alalhcha para li an Jesús tu'ucha kanawlh yu jantu chun, para li kata'alhtasulhcha. ");
INSERT INTO tpp_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chi tamala'achachalhcha ixt'alhtanank'ani an fariseojnin ali an ixt'alhtanan Herodes, an tan ixt'ajun an Jesús, tajuniy: ―Maestro, ijk'atsayaw li sawalhi yu na'un, chi li ixtij Dios sawalhi an yu masuy, ch'i jant'u lhak'ap'up'ini masi tani katanawlhcha an lapanakni, mu uxint'i jant'u yu la'ts'in tani tasuycha an lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Akilajuniwi t'ani lhiwilaycha, ¿oxi li akmapalhlhi'aniw an xajamach'alhkat la'acha'an Roma u jantu? ");
INSERT INTO tpp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero an Jesús, ixjak'atsaaniycha li wa ixtalhila'ts'intanuycha, pus jajuniy: ―¿Tasu li wa kilalhila'ts'intanuyawcha? ");
INSERT INTO tpp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Akilamasuniwi an tumin yu pujamapalanaj'ankan. Pus tamasunilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Chi an Jesús, jajuniy: ―¿Tisiyuchacha ani puwilh chi an ta'a'ut ani ts'o'ulakanta? ");
INSERT INTO tpp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yu'uncha tajuniy: ―Yucha an xajamach'alhkat la'acha'an Roma. Pus an Jesús jajuniy: ―Pus k'axt'a'nitcha yu ix'anu an xajamach'alhkat Roma chi yu ix'anu an Dios wach'uch'a k'axt'a'nit'it. ");
INSERT INTO tpp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Akxni chunchacha ta'alha'asmatlhi, ixtalhi'a'niycha, ixli'astan, ta'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Yuchaka wilhchan, an Jesús, tala'cha'alh an lapanakni yu ixjajunkan saduceojnin, yu an tanajun li jantu lay katila'awcho'okalh, chi tajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, an Moisés nawlh li xamati lapanak kaniya chi li jantu tu'u lhitsukunikalh ixjas'at'a, ixt'ala'ajuncha kat'atsukucho'oya an ixt'iwi', para li kata'alilhi ixjas'at'an an yu nilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kitnan ijkamispaw ixpumatujunk'an wa lhit'ala'awnin, an xa'aycha t'atsukukalhcha, walh nilh, jantu tu'u makawlh ixjas'at'a, pus an ixt'iwi yucha an ixt'ala'ajuncha t'atsukucho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Walh wanajcha chuni putapasapalh an ixlipumat'uycha, chi an ixlipumat'utucha wanajcha chun, sta talakni'olhi an ixpumatujunk'an. ");
INSERT INTO tpp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chi akxni talakni'olhcha, wachucha nilhi an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pus akxni kala'awcho'okana, an ixpumatujunk'an wa lhit'ala'awnin, ¿tisiyuchacha yu ixt'iwi kajuna an t'aku, mu ixchuxk'ani tat'atsukulhi? ");
INSERT INTO tpp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","An Jesús jajuniy: ―Wa xliyu uxitnan jant'u k'ats'ayat'iti tacha an ts'o'muk'akanta ixchiwinti Dios, chi li an Dios layi ilhtu'ojoy watuchicha. ");
INSERT INTO tpp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Akxni katala'awcho'oya an yu tanitacha, jantu katitalat'atsukulh, mu tacha an ix'angelhnincha Diosi katajuna anu lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ch'i li jant'u lhiwilayat'iti li katala'awcho'oya an yu talaknitacha, ¿ch'u jant'u p'unawt'at'iti li Diosi najun: ");
INSERT INTO tpp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Kit'ini ixDios Abraham, chi Isaac chi Jacob”? An Dios jantu ixDiosk'an janinin, yucha ixDiosk'an yu tala'ajunta. ");
INSERT INTO tpp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Akxni chunchacha ta'alha'asmatlhi an Jesús, sawalhcha talhi'a'nilhi tacha an ixmasuy. ");
INSERT INTO tpp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pero an fariseojnin akxni ta'asmatlhi li sa' jamakilhunilhi an Jesús an saduceojnin, tata'ayxto'lhicha. ");
INSERT INTO tpp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chi pumatam yu yu'uncha, yu ixlajk'atsay lhamap'a'sin ixlila'ts'intanuycha an Jesús, junkan an Jesús: ");
INSERT INTO tpp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿tanyucha yu palay ay lhamap'a'sini? ");
INSERT INTO tpp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","An Jesús alhtaylh, juniy: ―“K'amap'ayniya'a amijamach'alhkat Dios, chux la mijalhunut, chux la mintakuwin, chux la mijatapast'ak'at.” ");
INSERT INTO tpp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yucha yu p'ulhnaj chi ay lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chi ixlitipat'uy lanancha wa ixt'atam: “K'amap'ayniya'a mint'alapanak t'ach'a map'aynik'an mi'akstu.” ");
INSERT INTO tpp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yucha anicha la'at'uy lhamap'a'sini t'alach'apa'ojota chux an ixlamap'a'sin Moisés, chi an ali'incha yu ixtalhichiwiniy wachu ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Akxni wa lakatam ixta'ayxto'nun'ojoy an fariseojnin, ");
INSERT INTO tpp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","an Jesús jalhisakmilh, jajuniy: ―¿T'asuch'a p'ast'ak'at'iti? ¿An Cristo tisiyuchacha pu'a'p'unminchalhi? Yu'uncha tajuniy: ―Yucha an David. ");
INSERT INTO tpp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Chi an Jesús, jajuniy: ―¿Pus tasucha li akxni an ixTakuwin Dios machiwinilh an David, najun: “kiJamach'alhkati an Cristo”: ");
INSERT INTO tpp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","An Jamach'alhkat Dios juniy an kiJamach'alhkat Cristo: “Ak'imp'ikt'ut'a'ulhcha tan oxi kimpa'xti', sta akxni ajkamama'oya la mijach'aja an yu wa taxkayan para li k'ajap'ut'ach'at'acha.” ");
INSERT INTO tpp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","An David ixjamach'alhkati juniy an Cristo, ¿pus tasicha li ists'alh a'tami? ");
INSERT INTO tpp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pus wa chuncha jantu layi xamati tu'u alhtaylh, chi sta akxni jantucha k'is xamati ali tapujulh kalhisakmilh tu'u an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ixli'astan, tsukulhcha jaxa'alayi an lapanakni chi an ixt'alhtanan an Jesús, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―An tan ixtawlay Moisesi talaktawlay an xamaestrojnin lhamap'a'sin chi an fariseojnin. ");
INSERT INTO tpp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pus xliyu, k'a'ilht'ut'iti wa tuchicha yu tajunan, pero jant'u k'a'ilht'ut'iti yu tacha an talay yu'uncha, mu yu'uncha tanajuni yu ka'ilhtukalh, pero yu'uncha jantu ta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tachanu tapach'iya tu'u yu ts'ink'i, yu lhima'anxkay lhi'ankan, chi tajamak'uk'aninincha, pero yu'uncha masi wa katamalaklalhcha ma'atam ixk'its'ilimakak'an jantu tamak'aniputun. ");
INSERT INTO tpp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chux an yu ta'ilhtuy yu'uncha ma wa kajapula'ts'inkalhcha. Palaycha laj'o'xapa'ay jaxt'a'ani talakma'stumpatawk'ay, yu puwilh ixchiwinti Dios, chi an ixla'la'ch'itk'an la'lhmancha palayi lachaj talakstamuk'ay jaxpatanti hilo yu lajk'usi. ");
INSERT INTO tpp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chi yu'uncha la ixlakapuw talaktawlhputunachalh an tan lakwaykan, chi an laka lakcha'a tan pulakta'ayxto'kan. ");
INSERT INTO tpp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chi yu'uncha talakask'in li sawalhcha kajala'axa'alakalhi an laka laktij, talakask'in li kajajunikalh maestrojnin. ");
INSERT INTO tpp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero uxitnan jant'u k'alak'ask'int'iti li k'a'unk'ant'it maestrojnin, mu wa pumatami mi Maestrojk'an, Cristo, chi chux uxitnan lhit'ala'awnin. ");
INSERT INTO tpp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ch'i jant'u xamat'i k'a'unit mimpayk'an ani lakaat'un, mu wa pumatami mimPayk'an, an yu wilhchalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ch'i jant'u k'alak'ask'int'iti li k'a'unk'at maestrojnin, mu wa pumatami mi Maestrojk'an, Cristo. ");
INSERT INTO tpp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yu palay xa'ay uxitnan, yucha katalak'ilhtuniyan tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mu yu sawalhcha lhitapalayi najun jantu tu'u katilhitapalalh, pero yu jantu tu'u lhitapalay lay, yucha kalhitapala'. ");
INSERT INTO tpp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, mu wa ja'o'xch'o'onunat'itcha! Jant'u jamak'awniyat'iti katatanuchalh laka lhich'alhkat an lakt'iyan an lapanakni, chi uxitnan jant'u t'anuyat'it, wa jamama't'ijlayatcha an yu tatanuputunachalh.  ");
INSERT INTO tpp_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha! Mu wanajch'a jat'olo'ni'oyat'iti ixcha'ak'an an yu jantucha tu'u ixt'apapak'an t'akunin, chi para li wa jant'uch'a k'ak'ats'anik'ant'it wa panijnich'a t'ap'ayniyat'it, xliyu palay k'alhila'a'iya'it'iti lhima'alh'ajna. ");
INSERT INTO tpp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha! T'a'a'ch'o'oyat'itcha ani lakaat'un chi an alamalh, jap'uxk'awyat yu katach'a'o'an. Pero akxni jala'ch'ip'inatcha apalijcha wa ja'ilht'uyat'it li a't'uyuj ixjas'at'ancha la'nini katawalh, walh masi jantu uxitnan. ");
INSERT INTO tpp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Payni'incha uxitnani la'la'lhtulu'un jamap'a'sinin!, uxitnan nawnat'it: “Li xamati pujurarnan an tajtan, li jantu tani lay, pero li xamati pujurarnan an oro yu xanawin laka tajtan, li jalhi'aninincha.” ");
INSERT INTO tpp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Laktontojnin la'la'lhtulu'un! ¿Tampiyuchacha yu palay lhitapalay, yucha an oro, u yucha an tajtan, tan matajtanilakan an oro? ");
INSERT INTO tpp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Wach'u nawp'alat'it: “Li xamati tu'u najun ka'ilhtuya, chi pujurarnancha an tan xta'kan lha'ulan, li jantu tani lay masi jantu ka'ilhtulh. Pero li xamati pujurarnan an lha'ulan yu o'slay an tan ma'axta'kan lha'ulan, nawnat li jalhi'aninincha.” ");
INSERT INTO tpp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡La'la'lhtulu'un! ¿Tampiyuchacha yu palay lhitapalay, yucha an lha'ulan u an tan muk'akan lha'ulan, tan matajtanilakan an lha'ulan? ");
INSERT INTO tpp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yu pujurarnan an tan ma'axta'kan lha'ulan jantu wa yucha an puma'axta'kan lha'ulancha pujurarnan, chuxi pujurarnan'ojoy an yu ancha o'slay. ");
INSERT INTO tpp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chi yu pujurarnan an tajtan, jantu wa yucha an tajtancha pujurarnan, wachu pujurarnani an Dios, mu ancha wilh. ");
INSERT INTO tpp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chi yu pujurarnani an lakt'iyan, pujurarnancha an ixtants'i Dios yu puch'alhkatnan, chi pujurarnancha an Dios mu ancha wilhchalh. ");
INSERT INTO tpp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha t'ach'a an lhimasuyat'it! Mu xta'atcha xadiezmo an lhaklhi xax'oy menta chi an eneldo chi an comino. Pero k'apmaj'anat'iti an yu palay lhitapalay lhamap'a'sin: an oxi lanti, an jamapayninti chi an jakiklaka'inti. Pus lhitask'iniya li k'adiezmarnant'it, pero jant'u k'alhik'apmaj'amp'alat'iti an ali tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡La'la'lhtulu'un jamap'a'sinin, t'ank'alhamaj'anatcha an x'an, pero an camello t'olo'at'it! ");
INSERT INTO tpp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha! Lakmak'axak'ayatcha an vaso chi an pulatoj, pero la ixpulakni wa stakcha a'tsamanta ja'alhawanti chi tanlhun yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡La'lhtuluw fariseo! P'ulhnajch'a k'ap'ulakxak'at'i an vaso chi an pulatoj, para li an ixmakan wachucha sut'ut'u kawalh. ");
INSERT INTO tpp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha! Uxitnan tachanu an tan lak'ulakanta puta'aknun yu wa k'usicha sut'o' lakmakamanikanta, pero ixlipulakni wa stakcha taputanumanalh ixjalukutk'an janinin, chi tanlhuncha yu wa stakcha lakp'uch'ita. ");
INSERT INTO tpp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chuncha uxitnan, lhimasuyat'iti li oxi lapanakni, pero mimpulaknik'an wa stakcha tapu'a'tsamtani mija'o'xcho'ontik'an chi lhi'ay junita! ");
INSERT INTO tpp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Payni'incha uxitnani xamaestrojnin lhamap'a'sin chi uxitnani fariseojnin, wa ja'o'xch'o'onunat'itcha! Jala'la'oxiniyatcha an ixputa'aknunk'an an yu ixtalhichiwiniy ixchiwinti Dios, chi jalakmalht'ak'aniyatcha an ixmonumentojk'an an yu ts'awj ixtat'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ch'i nawnat: “Li akxni istsukuw akxni ixtat'ajun kilakpaynink'an, jantu xakintat'alhimuk'akani an ixjak'alhnik'an an yu ixtalhichiwiniy ixchiwinti Dios.” ");
INSERT INTO tpp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ch'unch'ach'a p'unawnat'it mi'akstuk'an li uxitnan ixjas'at'ank'an an yu tama'nilh an yu ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Apalijcha wa xawa'a'tami k'a'ilht'u'o'ot'it yu talhi'a'taynilh milakpaynink'an. ");
INSERT INTO tpp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Tsapulin! ¡Ixjas'at'an tsapulin! ¿T'asuch'a k'alhit'a'alht'axt'uya'it'it laka lhima'alh'ajnajlhinini? ");
INSERT INTO tpp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kit'in aklamala'achaniyawi yu katalhixa'alayan ixchiwinti Dios, chi yu tajalakpastaknan, chi xamaestrojnin lhamap'a'sin. Pero uxitnan wa k'ajama'niya'it'iti ali'in, chi ali'in k'ajamakxt'ukmuk'aya'it'iti laka Cruz, ali'in k'ajala'na'maya'it'iti an laka cha'a tan puta'ayxto'kan, ch'i k'ajach'a'o'aya'it'iti lakatamj lakatamj la'acha'an kata'ana'. ");
INSERT INTO tpp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pus uxitnani katala'cha'anan an tala'alhin, tacha an stak jats'alalh ixjak'alhnik'an an yu ts'awj ixtat'ajun. Xlakata an ixjak'alhni Abel, yu ts'awj ixt'ajun sta an Zacarías, ists'alh tichi lapanak ixjunkan Berequías, yu ma'nit'it waniy laka tajtan chi waniy tan ma'axta'kan lha'ulan. ");
INSERT INTO tpp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Klajunaw yu sawalh, k'amap'ala'it'iti chux an tala'alhin yu chaway ani t'awnat'it. ");
INSERT INTO tpp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén, Jamacha'an Jerusalén, jama'niyat'iti an yu talhichiwiniy ixchiwinti Dios, ch'i jalakt'alhmayat'iti an yu jamakt'anik'anat'it! ¡A'lhuwcha ijkamach'ixtamiputulh mijas'at'ank'an, tacha xanati piyu yu jama'ay ixjas'at'an la ixpa'achuj, pero jant'u k'is la'a'it'it! ");
INSERT INTO tpp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chawayi jamacha'an Jerusalén, ani la'acha'an kakapmaj'ankana'. ");
INSERT INTO tpp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mu klajunaw, sta chaway jantucha ali akintilala'ts'iw, sta akxni k'anawna'it: “Ikxta'niy lhimala'puchajuni an yu Dios mala'achatachalh.” ");
INSERT INTO tpp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Akxni taxtulhcha an laka tajtan an Jesús chi ixti'ancha, stalh tala'alhi an ixt'alhtanan chi tsukulhcha tamasuniya an ay tajtan. ");
INSERT INTO tpp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yucha ja'alhtaylh, jajuniy: ―¿Yuch'a la'ts'inat'it chux tacha ani yalh? Wanaj kalakt'ilhi'okana', jantu tu'u masi wa chiwxcha katila'ukxtawk'atawilh. ");
INSERT INTO tpp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Chi akxni sa' ixwilh an Jesús a'stitawk'a, tan junkan Laka Olivojnin an ixt'alhtanan stalh tala'alh, wa ixpu'akstuchak'ani talhisakmiy, tajuniy: ―¿Tasu wanancha chuncha kalaktapasaya an tanlhuni, tisuncha katapasaya akxni k'at'anch'o'oya'a, chi akxni ka'ukla'oya an lakamunulhpa'a? Akilajuniw. ");
INSERT INTO tpp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","An Jesús jajuniy: ―K'as'alajnant'iti li jantu xamati kata'o'xcho'on. ");
INSERT INTO tpp_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mu lhuwi katamina yu katanawna li yu'uncha Cristo, chi lhuwi katata'o'xcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ch'i k'a'asmat'a'it'iti li lasakancha chi lat'alhkancha, pero jant'u k'alakt'alhanant'it, mu lhitask'iniya li chuncha katapasalh, pero jantuka' kati'ukla'olh. ");
INSERT INTO tpp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mu la'atam ay la'acha'an kat'alasaya la'atam ixt'a'ay la'acha'an chi pumatam ay jamach'alhkat kat'alasaya pumatam ixt'a'ay jamach'alhkat chi watanchuncha kalaklaya an lakaat'un chi ka'alinacha chawan. ");
INSERT INTO tpp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero masi chuncha, yucha wa kapu'a'tayniyaka an lhima'alh'ajna. ");
INSERT INTO tpp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Chi k'ama'axt'a'k'ana'itcha laka lhima'alh'ajna, k'ama'nik'ana'it, jant'uch'a k'is k'at'ila'ts'imp'ut'unk'ant'iti ani lakamunulhpa' ixlakata li kilakiklaka'iyaw. ");
INSERT INTO tpp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lhuwi yu katamakawnacha an ixjakiklaka'intik'an, chi katalama'axta'paxayacha chi katalaxkayacha. ");
INSERT INTO tpp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Wanajcha lhuwi kata'alina yu jantu sawalh ixchiwinti Dios katitalhichiwinilh, chi lhuwi kata'o'xcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wa stakcha kalak'alina lakmakxkay tanlhun, chi an lapanakni jantucha katitalamapaynilh. ");
INSERT INTO tpp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero yu kalhitayaniya sta akxni ka'ukla'oya, yucha kata'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chi kalhichiwinkana ani laj'oxi chiwinti yu puch'alhkatnan an Dios chux an lakamunulhpa', para li an ta kilhmakchux lapanakni katak'atsaalh, ixli'astan ka'ukla'oyacha. ");
INSERT INTO tpp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Akxni k'ala'ts'ina'itcha pumatam lapanak yu sawalhcha ay junita an laka tajtan, an la'acha'an Jerusalén chi tacha dioscha kala'ts'inkana tacha nawlh an Daniel yu ixlichiwiniy ixchiwinti Dios, (kalhimacha'xalhi yu punajun ani tacha najunta). ");
INSERT INTO tpp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yu xalakaat'un Judea t'awnachalh, ka'os'alhcha laka a'stitawk'an. ");
INSERT INTO tpp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yu ix'a'sti ixcha'a uk'achalh, jantu kata'alhtajulhi para li ka'alh maxtunu tu'u la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chi yu la ixkuxtu t'awnachalh, jantu ka'alhi p'uxnu ixpu'ayxt'a'kan tan muk'atachalh. ");
INSERT INTO tpp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Chi payni'incha an t'akunin yu ixt'a'akxni tukan taja'aynanta, chi yu ixt'a'akxni tukan talhit'ajun ixjas'at'ank'an yu tats'ik'iyka', mu akxni lhima'anxkay! ");
INSERT INTO tpp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","K'at'ap'aynit'it, para li akxni k'aja'osnunt'it akxni jantu ixpaku lhik'asnin, chi jantu kawalh la'atam wilhchan akxni wa jastaknankan. ");
INSERT INTO tpp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mu ka'alina ay lhima'alh'ajna, tacha yu jantu a'tam alinta sta wa ta wanancha ilhtukantachalh an lakamunulhpa', chi jantu a'tam chuncha kati'alincho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Chi li jantu ka'ixlalakat'ikt'ilhi Dios anchunu panch'e'ex, jantu xamati ka'ixta'alhtaxtulh. Pero mu jamapayniya an Dios an yu jasakxtukantacha, kalalakat'ikt'ikana an panche'ex. ");
INSERT INTO tpp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Pus xliyu li xamati tajunan: “Anicha t'ajun Cristo, u anucha t'awnachalh Cristo”, jant'u k'ak'iklak'a'it. ");
INSERT INTO tpp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mu kata'alina yu jantu Cristojnin sawalh, chi yu jantu ixlisawalh ixchiwinti Dios katitalhichiwinilh, chi layi kata'ilhtuya laj'ay tanlhun tu'u', tacha jak'uchunti, pero wa ixpa'o'xcho'onchak'an, chi li lay, kata'o'xcho'oputuna an yu jasakxtukantacha. ");
INSERT INTO tpp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pus chaway klamak'atsaaniwcha. ");
INSERT INTO tpp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Li xamati tajunan: “K'ak'ila'ts'int'it, an tan wa jasa'nik'a t'awnachalh”, jant'u k'ap'it'it, u li tajunan, “Awint'i laka cha'a tanumachalh”, jant'u k'ak'iklak'a'it. ");
INSERT INTO tpp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mu tacha an jamakalipnin, akxni slimj tak'ut'achalh an tan akxajachilh wilhchan, chi sta tan ta'aknucho'oyachalhi makacha'an, chuncha kala'ts'inkana kalaya akxni kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","U tacha akxni inta nimalh tu'u', ancha la'ts'inkani mu ancha tata'ayxt'o'a an ch'unin. ");
INSERT INTO tpp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Watukan tacha kala'oya an ay lhima'alh'ajna, anchunu panch'e'ex, an wilhchan kataputs'isiya', chi an malhkuyu jantucha katimapulhkulh, chi an st'akunin katapatajuyanta an lakt'iyan, chi an takuwinin yu an lakt'iyan tat'ajun kajalakchikixkana'. ");
INSERT INTO tpp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wa chuncha katalakasuyacha an isTs'alh Lapanak an lakt'iyan, akxni chun, chux an la'acha'anaxni ani lakamunulhpa kalaktalhanankanacha chi kalaj'alhunkanacha. Katala'ts'inacha an isTs'alh Lapanak li alhp'ascha minta laka jataputs'i chi wa xlimjnik'acha. ");
INSERT INTO tpp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chi an ix'angelhnin p'ascha kajas'olhniya laka la'atam s'olh, kajamala'achayacha para li katamach'ixtamilhcha an yu jasakxtutacha ta ixlijalhi'ay an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’K'ap'ulhimach'a'xatcha t'ach'a an lhixa'alak'ant'it xak'iw higo: Akxni alhajas'at'alacho'oycha chi xajnicho'oyachilhcha sast'i xax'oy, k'ats'ayatcha li waniycha ixpaku lhi'ichi. ");
INSERT INTO tpp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pus chunchacha uxitnan, akxni k'ala'la'ts'ina'itcha tacha an kalaktapasaya, k'ak'ats'atcha li waniycha laka maticha ikminta. ");
INSERT INTO tpp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kit'in klajunaw yu sawalh, akxni chuxcha chuncha kalaktapasaya, lhilhuwi kala'ts'inkana', mu katsukukanaka'. ");
INSERT INTO tpp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","An lakt'iyan chi an lakaat'un ka'ukla'oya', pero an kinchiwinti yucha jantu. ");
INSERT INTO tpp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Tuchini wilhchancha chi tuchi horajcha katapasaya jantu xamati k'atsay, masi an angelhnin awint'i lakt'iyan, chi an isTs'alh Dios, wa yucha an Diosi k'atsay. ");
INSERT INTO tpp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Tacha akxni an ixt'ajun Noé chuncha katapasaya akxni kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Anchunu panch'e'ex akxni ixt'ajun an Noé, akxni jantuka' ix'a'muxtukan, an lapanakni ixtalakwajin chi ixtalaj'ot'a chi ixtalat'atsukuy, sta wa cha'alhcha wilhchan akxni tanulhcha an laka aya barco an Noé. ");
INSERT INTO tpp_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Yu'uncha jantu k'is taja'asmatnamputulh, walh milhcha an a'muxtut, wanaj jama'ni'olh, chuncha katapasaya akxni kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kamina panch'e'exi akxni ixt'uyunk'an lapanakni tat'ajun lakakuxtu, an pumatam kalhi'ankana chi an pumatam katamakawna'. ");
INSERT INTO tpp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chi tan ixt'uyunk'an t'akunin taskitit'ajun, an pumatam kalhi'ankana chi an pumatam katamakawna'. ");
INSERT INTO tpp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’K'as'alaj ts'uk'ut'it, mu jant'u k'ats'ayat'iti tuchi panch'e'excha kamina an miJamach'alhkatk'an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ch'i k'alhimach'a'xat'iti ani: li tam lapanak jamanawin laka cha'a kak'atsaalhi tuchi jatats'isnicha kamina xamati ja'alhawna, kakujtawla', chi jantu katimakawnilhi katanuchalh para li kaja'alhawanalh. ");
INSERT INTO tpp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xliyu uxitnan wach'u k'ala'asijt'it, mu an isTs'alh Lapanak kamina akxni jant'u lhiwilayat'it li lay kamilh. ");
INSERT INTO tpp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’A ma'tsuku yu jalajk'atsanan chi yu oxi jalhistaknan la ixcha'a ixpatrón, yucha kamalhistaknikana an cha'a', chi yuchacha kajaxta'niya yu kata'uya an ali'in ixt'ama'tsukunin akxni katalakwaynacha. ");
INSERT INTO tpp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sawalhcha oxi anchunu ma'tsuku li akxni kachina an ixpatrón, oxi tapatsat'ajun. ");
INSERT INTO tpp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yucha iklajunaw li an ixpatrón o'sliyancha li kamalhistakni'oya an ixtanlhun. ");
INSERT INTO tpp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero li anchunu ma'tsuku kapastaklhi, kanawlh: 'Jantu so'ojo katimilh an kimpatrón. ");
INSERT INTO tpp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chi kajalaksamalhcha an ali'in ixt'ama'tsukunin, chi kawaylhcha chi ka'otlhicha yu otputun chi wa kat'a'ap'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Akxni jantu k'atsay tuchi horajcha chi tuchi wilhchancha kachina an ixpatrón. ");
INSERT INTO tpp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Chi akxni alhp'asi kastak mama'alh'ajnikana', kajat'amak'ankana an yu wa taja'o'xcho'onun, tan kalaj'alhunkana chi tan wa xwat'at'acha kalaktasat'awkana'. ");
INSERT INTO tpp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Chunchuniya katapasaya an lhich'alhkat anu lakt'iyan, tachanu ixpumakawk'an jatsi'in yu taxa'a'ilh ixpumaklhkuk'an chi ta'alhcha paxto'nini an ts'alh yu kat'atsukukana'. ");
INSERT INTO tpp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","An ixkisink'an s'alaj tat'ajun chi an ali'in ixkisink'an jantu. ");
INSERT INTO tpp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","An yu jantu s'alaj tat'ajun jantu talhi'alhi xa'asaytej an ixpumaklhkuk'an, yu sast'icha katamunicho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero an yu s'alaj tat'ajun ixkisink'an jatsi'in, talhi'alhi xa'asaytej ixpumaklhkuk'an laka frasco. ");
INSERT INTO tpp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mu jantu so'ojo chin an ts'alh, pus sawalhcha talaklhtataputulh, talaklhtatalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jaytatnancha, p'ascha chiwinkan, nawkan: “¡Mintacha an ts'alh an yu kat'atsukukana'! ¡K'at'axt'utcha, k'alak'at'ast'ukt'itcha!” ");
INSERT INTO tpp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pus an ixpumakawk'an jatsi'in talaj'ostaya'olh chi tamala'asijnilhcha an ixpumaklhkuk'an. ");
INSERT INTO tpp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","An ixkisink'an an yu jantu s'alaj tat'ajun tat'alajuniy an yu s'alaj tat'ajun: “Akilaxta'niwka lakats'uniya ami'asaytejk'an, mu mixt'ajuncha an kimpumaklhkuk'an.” ");
INSERT INTO tpp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero an yu s'alaj tat'ajun jatsi'in tat'ala'alhtaylh, tat'alajuniy: “Jantu, mu chuncha wa lasi kaxaw'oya kitnan chi uxitnan. Apalij k'ak'it'ama'ut'it wachu yu mi'anuk'an an tan st'akan.” ");
INSERT INTO tpp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pus an ixpumakisik'an jatsi'in anchaka ta'ampalh, walh chilhcha an ts'alh. An ixpumakisik'an an yu ixtala'asijta, tat'atanulhcha an ts'alh an tan tama'xt'o'a laka cha'a', chi talaklhchawlhcha an malhticha. ");
INSERT INTO tpp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ixli'astan tacha'alhka wachu an ali'in jatsi'in, tanajun: “¡Jamach'alhkat, Jamach'alhkat, akilamati'aniw!” ");
INSERT INTO tpp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero an Jamach'alhkat jajuniy: “Klajunaw yu sawalh, jantu iklamispayaw tichini uxitnancha.” ");
INSERT INTO tpp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jaxa'ala'olh an Jesús jajuniy: ―Chuncha uxitnan, k'as'alaj ts'uk'ut'it, mu jant'u k'ats'ayat'it tuchi wilhchancha chi tuchi horajcha kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’An lhich'alhkat anu lakt'iyan wachu tacha xamati lapanak yu jamatumin, yu ti'ancha inta ma'at la'acha'an, chi an yu tat'atapatsay kajat'asanilhcha chi kajamalhistaknilhcha an ixtumin. ");
INSERT INTO tpp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Pumatam la'akisi milhcha tumini xta'nilh, chi pumatam la'at'uycha milh, chi pumatam tam milhcha, atamj atamjcha malhistaknikalh tacha laycha la'ts'ilhi'an. Chi wa chuncha alhcha ma'ati an jamatumin. ");
INSERT INTO tpp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","An yu la'akisi milh jama'lhtayanalh putapatsalhcha, chi la'akisi milhcha lhajanicho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wanajcha chuni ilhtulh an yu wa la'at'uy milh jama'lhtayanalh, la'at'uycha milhi lhajanicho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero an yu wa tam milh jama'lhtayanalh, alh maknunu an ixtumin an ixpatrón. ");
INSERT INTO tpp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Ma'ancha walh, chincho'olhcha an ixpatronk'an an ma'tapatsanin chi jalakt'asanicho'olhcha, jalhisakmilhcha tuchini tapu'ilhtulhcha an tumin. ");
INSERT INTO tpp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cha'alhcha p'ulhnaja an yu la'akisi milh ixjama'lhtayananta tumin, chi t'axta'lhicha an la'akisi milh yu ilhajanitacha, najun: “Patrón, la'akisi milhi an k'ixt'a'nin, anicha malh, chi anicha malhi an yu iklhajanilh, wachu la'akisi milh.” ");
INSERT INTO tpp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","An ixpatrón juniy: “Sawalhcha oxi, oxi ma'tapatsank'at'i chi sawalhi yu na'un. Jantu lhuwi an ixlist'akt'a pero ilht'u sawalh, chaway yu lhuwcha akmalhistakniyan. K'at'anut'icha, kalaj'achanawcha.” ");
INSERT INTO tpp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","La'cha'ampalh wachu an yu wa la'at'uy milh tumin ixjama'lhtayananta, najun: “Patrón, la'at'uy milhi an k'ixt'a'nin, anicha malh, chi anicha malhi yu iklhajanilh, wachu la'at'uy milh.” ");
INSERT INTO tpp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","An ixpatrón juniy: “Sawalhcha oxi, oxi ma'tapatsank'at'i chi sawalhi yu na'un. Jantu lhuwi an ixlist'akt'a pero ilht'u sawalh, chaway yu lhuwcha akmalhistakniyan. K'at'anut'icha, kalaj'achanawcha.” ");
INSERT INTO tpp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Pero akxni cha'alh an yu wa tam milh tumin ixjama'lhtayananta, juniy an ixpatrón: “Patrón, kit'in xajk'atsaycha li sawalhch'a unit'a, uxint'i jax'anani masi t'ant'u uxint'i ch'ant'a ch'i p'ulasak'a masi t'ant'u uxint'i ma'p'its'it'a. ");
INSERT INTO tpp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pus iktalhanalh, ik'alh maknunu lakaat'uni amintumin, pero anicha malhi amintumin.” ");
INSERT INTO tpp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","An ixpatrón, alhtaylh juniy: “Uxint'i wa ay unit'a ma'tapatsan, ch'i jant'u t'u'u ilht'up'ut'un, mu li ixk'ats'aycha li ijkax'anani tan jantu kit'in ikch'an chi li ikpulasak'a tan jantu kit'in ikma'pitsiy tu'u, ");
INSERT INTO tpp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","p'us k'a'xlip'i laka bancojo an kintumin, walh akxni xakchincho'olh, xajkama'lhtayanalhcha an kintumin chi xajas'at'a.” ");
INSERT INTO tpp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Chi jajuniy an patrón an yu ancha ixtayanalh: “K'amaxt'unit'iti an tam milh tumin, yucha an yu la'akaw milh tumin lhit'ajuni k'axt'a'nit'it. ");
INSERT INTO tpp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mu yu lhit'ajun, kaxta'nikana palay, pus palay kalhitsukuya'. Pero yu jantu lhit'ajun, masi yu wa lakats'uniycha kaxlitsukulh kamaxtuni'okana'. ");
INSERT INTO tpp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani yu jantu tu'u lhitapalay ma'tapatsan, k'amak'ap'itcha ma'spa tan puts'ista, tan kalaj'alhunkana chi wa xwat'at'acha kalaktasat'awk'ana'.” ");
INSERT INTO tpp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Akxni kaxlimjcha jat'amina an isTs'alh Lapanak an ix'angelhnin, yucha katawlacha an la ixputawlan yu ta lhichux kapumispa'okana li yucha ay. ");
INSERT INTO tpp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chux an lapanakni ta kilhmakchux ta'alin, la ixlakapucha katata'ayxto'oya', chi yucha kajamala'apitsiyacha, tacha an ja'ilhtuy yu jalhist'ak'a ixborregojnin chi ixcabrajnin. ");
INSERT INTO tpp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","An borregojnin lhi tan oxicha ixmaka kajalhiyawyanta chi an cabrajnin lhila'ixjama'xicha. ");
INSERT INTO tpp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Chi akxni an Rey kajajunacha an yu lhila'ix'oxi ixmaka tayanalh: “Uxitnan yu tamapayniyan an kimPay, k'at'at'itcha. K'ajama'lht'ayanant'itcha an lhich'alhkat yu mala'asijninik'ant'at'it sta akxni an Dios ilhtulh an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mu ikchawanalh, chi uxitnan kilat'awajiw, ijkikxixli, chi uxitnan kilat'a'otwi xkan. Tan xakcha'an chi jantu inta xakla'akuja, uxitnan kilaxta'niwi tan aktawilh. ");
INSERT INTO tpp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jantu tu'u kila'ch'it xakla'ch'ita, uxitnan kilaxta'niwi kila'ch'it. Xakta'an'ay, uxitnan kilakila'kilaw. Xaklaklhchajuy chi uxitnan kilakila'ts'iw.” ");
INSERT INTO tpp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Akxni, katalhisakmiya an yu jantu ay tajunita lapanakni, katajuna: “Rey, ¿tasu wananch'a ixch'awaniy chi iklat'awajiwi? ¿U tasu wananch'a ixk'ikxixa chi iklat'a'otwi xkani? ");
INSERT INTO tpp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Chi tasu wananch'a jant'u int'a ixla'ak'uja chi iklaxta'niwi t'an k'at'a'ulhi, chi akxni alhalha ixt'a'un, chi iklaxta'niwi mila'ch'iti? ");
INSERT INTO tpp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Chi tasu wananch'a ixt'a'an'ay ch'i ixlaklhch'a'uy, chi klakila'ts'iwi?” ");
INSERT INTO tpp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","An Rey kaja'alhtaya, kajajuna: “Wa tichicha yu ch'unch'a ilht'ut an kijat'ala'awnin masi yu wa xalakt'ikt'incha, tachanu kit'ini chuncha kila'ilhtuw.” ");
INSERT INTO tpp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ixli'astan an Rey kajajunacha an yu ixlila'ama'xi tayanalh: “¡Uxitnan yu laka lhima'alh'ajna k'ap'ina'it k'a'ost'itcha ani, k'ap'inchi'itcha laka jikmi tan jantu a'tam mixa, tan mala'asijninikanta an xapay makxkay'un chi an lakmakxkay'un! ");
INSERT INTO tpp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mu ikchawanalh, chi jantu kilat'awajiw, ijkikxixli, chi jantu kilaxta'niwi xkan. ");
INSERT INTO tpp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Akxni jantu inta xakla'akuja tan xakcha'an, jantu kilaxta'niwi tan aktawilh. Jantu tu'u kila'ch'it ixjunita, jantu kilaxta'niw. Xakta'an'ay chi xaklaklhchajuy, walh jantu kilakila'kilaw.” ");
INSERT INTO tpp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Akxni, yu'uncha katalhisakmiya, katajuna: “Rey, ¿tasu wanancha iklala'ts'iw ixch'awaniy u ixk'ikxixa, u jant'u int'a ixla'ak'uja, u jantu tu'u mila'ch'it, u ixt'a'an'ay, u ixlaklhch'a'uy, chi jantu iklalhi'a'tayjuwi?” ");
INSERT INTO tpp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","An Rey kajajuna: “T'ach'a jant'u xamat'i ch'unch'a ilht'ut an xalakt'ikt'in yu kilapanakni, jant'u t'u'u ilht'ut kilakata.” ");
INSERT INTO tpp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yu'uncha kata'anacha laka lhima'alh'ajna tan jantu a'tam min'ojota, chi an yu oxi lapanakni kajaxta'nikanacha jatsukunti yu jantu a'tam min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Akxni chunchacha jajun'olh an Jesús, jajuniycha an ixt'alhtanan: ");
INSERT INTO tpp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―K'ats'ayatcha li wa la'at'uycha wilhchani ts'an'ay ixk'atan paxku, an isTs'alh Lapanak kama'axta'kanacha para li katamakxtukmuk'alhcha laka Cruz. ");
INSERT INTO tpp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wa chuncha an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an laktatanincha yu ancha ixla'acha'ank'an, tata'ayxto'lhicha an la ixjatalakxtut an xa'aycha tukan sacerdote, yu junkan Caifás. ");
INSERT INTO tpp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chi anchacha talhilakchiwinilh tani katalhi'o'xcho'och'apayawlhcha an Jesús, para li katama'nilhcha. ");
INSERT INTO tpp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero talajuniy: ―Tukan k'atan jantu, para li jantu katala'talh'amalh an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","An Jesús, la'acha'an Betaniaja ixt'ajun, la ixcha'a Simón, yu ixlakap'uch'i'ojota. ");
INSERT INTO tpp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Walh ancha la'cha'alh pumatam t'aku yu ixli'anta la'atam perjume la xafrasco, yu wanaj la'lhuw ixtapalay, chi ukmuk'akalhi an Jesús akxni sa' ixwilh laka mesa. ");
INSERT INTO tpp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Chi mu tala'ts'incha an ixt'alhtanan an Jesús, pus talhitalh'amalh, tajuniy: ―¿Tasu li wa lha'amanancha an perjumeje? ");
INSERT INTO tpp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yucha layi kaxlist'akalh la'lhuw, chi kaxjamala'pitsinikalhcha an jakilhpatinin. ");
INSERT INTO tpp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero an Jesús asmat'a, pus jajuniy: ―¿T'asu li la'a'aymayatcha ani t'aku'u? Oxicha tacha ani ki'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mu an jakilhpatinin lhilhiji k'ajat'a'aklats'uk'uya'it'it, kit'in jantu. ");
INSERT INTO tpp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ani t'aku kilakamuk'alhcha an perjume ixlakata li mala'asijniycha li akxni akimaknukana'. ");
INSERT INTO tpp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Chaway sawalh, klajunaw, wa tanchuncha kalhichiwinkana ani laj'oxi chiwinti, chux lakamunulhpa, wachu kalhichiwinkana an yu ilhtulh ani t'aku', para li kalhipastakkalh. ");
INSERT INTO tpp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Xapumatam an ixpumakawt'uyk'an ixt'alhtanan an Jesús, yu ixjunkan Judas Iscariote, jala'alhi an xalaj'ajin sacerdotejnin, ");
INSERT INTO tpp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","chi jajuniy: ―¿Tasuncha kilaxta'niyaw para li aklama'axta'niw an Jesusi? Yu'uncha taxta'nilh a'xp'uxamkaw tumin de plata. ");
INSERT INTO tpp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pus sta akxni wa ixlipuxkawniycha tani kalhima'axta'lhicha. ");
INSERT INTO tpp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Walhcha la'atam wilhchan ixk'atan pan yu jantu lhiyalh lhamaskajan, tala'cha'alhcha an ixt'alhtanan an Jesús, tajuniy: ―¿T'anisch'a na'un akmala'asijniw para li k'awaycha laka paxku? ");
INSERT INTO tpp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yucha jajuniy: ―K'ala'p'inchi'it tichi lapanak an la'acha'an, k'a'una'it: An Maestro najun: “Waniycha kimpanch'e'ex, an la mincha'a akmak'ataniya an paxku ali an kint'alhtanan.” ");
INSERT INTO tpp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pus an ixt'alhtanan an Jesús chunchacha ta'ilhtulh tacha an jajunilh, tamala'asijnilhcha ixlakata an paxku. ");
INSERT INTO tpp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Akxni tats'isilhcha, jat'atawilhcha laka mesa an ixpumakawt'uyk'an ixt'alhtanan an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chi akxni ixtalakwayt'ajuncha, jajuniy: ―Sawalhi ani yu klajunaw, xapumatam yu uxitnani akima'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pus sawalhcha ixtata'oxila'alhiy, atamj atamjcha ixtalhisakmiy, ixtajuniy: ―¿Kit'in sna'a, Jamach'alhkat Jesús? ");
INSERT INTO tpp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Wa chuncha yucha ja'alhtaylh jajuniy: ―Yucha an kint'atamaj'oy la kimpulatojo akima'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sawalhi li an isTs'alh Lapanak ts'ajwi ti'an, tacha an lhits'o'muk'akanta, pero an lapanak an yu kama'axt'a'a an isTs'alh Lapanak kapulhik'atsaya'. Yucha palay oxi jantu katsukulh. ");
INSERT INTO tpp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wa chuncha an Judas Iscariote, an yu kama'axt'a'a, alhtaylh juniy: ―¿Maestro, chu sna kit'in? An Jesús juniy: ―Uxint'ich'a naw. ");
INSERT INTO tpp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chi ixtalakwayt'ajunka, an Jesús xa'a'ilhcha an pan, chi xta'lhicha lhimala'puchajun, la'ch'e'elhcha jaxta'nilhcha an ixt'alhtanan, jajuniy: ―Ni'ijcha, k'a'ut'itcha, ani kilakatunaj. ");
INSERT INTO tpp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ixli'astan xa'a'ipalh la'atam vaso yu ixputajun xaxkan uva, chi wachucha lhixta'nilh lhimala'puchajuni an Dios, chi jaxta'nilhcha an ixt'alhtanan, jajuniy: ―Minchuxchak'ani k'ap'u'ott'it ani vaso, ");
INSERT INTO tpp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","mu ani yucha kijak'alhni, yu sast'icha putamakawkan li ani jak'alhni kamaj'ankana, para li lhuw lapanakni katapumala'mixilh ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Kit'in klajunaw sta chaway jantu akti'otcho'olhi an xaxkan uva, sta akxni aklat'alaj'otcho'otacha'aw yu sast'icha an la ixlich'alhkat kimPay. ");
INSERT INTO tpp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Akxni talakmilhpa'olhcha la'atam milhpat, ta'alhcha a'stitawk'a tan junkan Laka Olivojnin. ");
INSERT INTO tpp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ancha jajuniy an Jesús: ―Ani katats'isiya wanaj akilamakaw'oyaw. Mu ts'o'muk'akanta an la ixchiwinti Dios tan najunta: “Akma'niya an yu jalhist'ak'a ixborregojnin, chi an ixborregojnin wanaj tilh katata'a'pitsi'oya'.” ");
INSERT INTO tpp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero akxni akla'awcho'oyacha kit'ini aklatap'ulhniyaw ak'ana xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","An Pedro, alhtaylh juniy: ―Masi katamakaw'ojon, kit'in jantu aktimakajun. ");
INSERT INTO tpp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","An Jesús juniy: ―Kit'in sawalhi yu ijkunan li chaway ani katats'isiya, akxni jantuka' k'is tu'u katit'asalh puyux, a't'utu k'anawna'a li jant'u k'imisp'ay. ");
INSERT INTO tpp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero an Pedro juniy: ―Masi akima'nikalh wachu jantu a'tam aktinawlh li jantu ikmispayan. Chi an ali'in ixt'alhtanan wachu chuni tajunilh. ");
INSERT INTO tpp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wa chuncha jat'acha'alhcha an ixt'alhtanan an Jesús, tan jalakch'ananankanta junkan Getsemaní, jajuniy: ―K'alakt'awlatka ani, kit'in ikti'an anu', ikti'an tapaynini'. ");
INSERT INTO tpp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pus ja'aylhi'alhcha an Pedro, chi an ixt'uyunk'an ists'alan tichi lapanak junkan Zebedeo, walh sawalhcha tsukulh ta'oxila'alhiya an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jajuniy: ―An kintak'atsan sawalhcha ta'oxila'alhiy, wa tacha akniyacha ijk'atsan. Ani akilapakxaw jant'u k'alaklht'at'at'it. ");
INSERT INTO tpp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pus stalhcha alh lakats'uniy, tatso'ottalhcha chi tamuntitachalhcha an lakaat'un, tsukulhcha tapayniy, najun: ―KimPay, li lay, ak'imala'xt'inunini ani ay lhima'alh'ajna pero jantu tacha kit'in klakask'ini kawalh, tacha uxint'i lak'ask'ini kawalh. ");
INSERT INTO tpp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ixli'astan jala'cha'ancho'olhcha an ixt'alhtanan, walh ixtalaklhtatanancha. Pus junkan an Pedro: ―¿Jantu layi masi wa tamcha hora akilat'a'alhkujwi? ");
INSERT INTO tpp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","K'ak'ujt'it ch'i k'at'ap'aynit, para li jant'u k'alhila'ts'int'anuk'ant'it li k'a'ilht'up'ut'ut yu jantu oxi. Mu an takuwin yucha ilhtuputuni yu oxi, pero an lakatunaj yucha yu jantu k'ut'ilh. ");
INSERT INTO tpp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A'tam ampalh, a'tam tapaynipalhi ixlipu'a't'uycha, najun: ―Kimpay li jantu layi ak'int'imala'xt'inunin ani ay lhima'alh'ajna, chunchacha kawalh t'ach'a oxi lhiwilay. ");
INSERT INTO tpp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jala'cha'ampalh a'tami an ixt'alhtanan, a'tamcha ixtalaklhtatanampalay, mu sawalhcha ixjala'cha'an ilhtatapututk'an. ");
INSERT INTO tpp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pus jamakawlh, a'tam ampalh, ixlipu'a't'utucha alh tapaynini'. Wanajcha yu chiwinti nawpalh. ");
INSERT INTO tpp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wa chuncha jala'cha'ampalh an ixt'alhtanan, jajuniy: ―¿Jast'aknant'awnatka ch'i laklht'at'ayatka'? Chilhcha panch'e'ex, an isTs'alh Lapanak kama'axta'kanacha la ixmakak'an an la'ma'lhta'alhinin. ");
INSERT INTO tpp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","K'alaj'ost'ayatcha, ka'awcha, jo', mintacha an yu akima'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ixchiwint'ajunka an Jesús, la'cha'alhcha an Judas, xapumatam an ixpumakawt'uyk'an ixt'alhtanan, t'o'o'ocha jat'acha'alh lhuw lapanakni, ixtalaklhi'antacha ix'espadajk'an chi ixk'iwk'an. Yu'uncha an xalaj'ajin sacerdotejnin chi an laktatanincha yu ancha xalapanakni ixtalhinajunta. ");
INSERT INTO tpp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","An ja'o'xcho'onuj Judas la'asiyaj ixjajunitacha tani kajapumasuniyacha, ixjajunita: ―Yucha an akla'xtikilhtast'uk'a yu Jesús, k'ach'ap'ayawya'itcha. ");
INSERT INTO tpp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pus an Judas la'cha'alhcha an Jesús la'axa'alalhcha, juniy: ―¡Xaycha, Maestro! Chi la'xtikilhtastuklhicha. ");
INSERT INTO tpp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pus an Jesús alhtaylh: ―Kint'ala'ajun, ¿t'isunch'a la't'ant'a? Wa chuncha an ali'in t'o'cha tala'cha'an'olhi an Jesús, tach'apayawlhcha. ");
INSERT INTO tpp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero xapumatam yu ixtat'a'anta an Jesús, xtalan xa'axtulhi an ix'espada chi xtalh akatuch'uk'up'uxli xapumatam ixma'tsuku an yu tukancha xa'ay sacerdote. ");
INSERT INTO tpp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wa chuncha an Jesús juniy: ―K'ama'at'i ami'espada, mu yu espadaja pulasay, wachu espadaja kapuniya'. ");
INSERT INTO tpp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ch'u na'uncha li jantu layi aktapayninilh an kimPay chi akijamakminilh palay de la'akawt'uy batallón angelhnin? ");
INSERT INTO tpp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero li chuncha, ¿tasucha lay kalhitapasaya tacha an ts'o'muk'akanta tan najun li chuncha katapasalhi? ");
INSERT INTO tpp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pus akxni an Jesús jajuniy an lapanakni: ―¿Chu ijka'alhawna li kilamintawcha ch'apayawnin laka espada chi laka k'iw? Lhilhiji xak'an masunu an laka tajtan, chi akxni jantu kilach'apayajuw. ");
INSERT INTO tpp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero wa xliyu li chuncha katapasaya tacha an tats'o'muk'ata an yu ixtalhichiwiniy ixchiwinti Dios. Wa chuncha an ixt'alhtanan an Jesús, wanaj tamakaw'olh, ta'oslicha. ");
INSERT INTO tpp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","An yu tach'apayawlh an Jesús talhi'anilhcha an Caifás, yu xa'ay tukan sacerdote, tan ixta'ayxto'nun an xamaestrojnin lhamap'a'sin chi an laktatanincha. ");
INSERT INTO tpp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","An Pedro wa ma'atcha ixch'a'o'alhi'anta sta an la ixjatalakxtut an yu xa'ay tukan sacerdote, chi tanuchalhcha, sa'cha jat'atawilh an yu ixtajalhistaknan, para li kala'ts'ilhcha tuchini katapasayacha. ");
INSERT INTO tpp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Walh an xalaj'ajin sacerdotejnin chi chux an yu ancha ixta'ayxto'nun, ixtapuxkajuycha tu'u maslakatinti para li katalhimuk'alhcha an Jesús, chi laycha katama'nilh. ");
INSERT INTO tpp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero jantu tu'u tala'cha'alh, masi ixluwk'ancha ixtacha'an yu ixtanajun tu'u yu jantu sawalh. Ixli'astan tacha'ampalh ixt'uyunk'an, ");
INSERT INTO tpp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tanajun: ―Ani lapanak najun: Layi aklakt'ilhilh an ixtajtan Dios chi ixlila'at'utu wilhchan akla'oxicho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pus tayalhi an yu tukancha xa'ay sacerdote, chi xa'alaycha an Jesús, juniy: ―¿Jant'u k'at'ija'alht'ayan? ¿Tisuncha tacha ani talhimuk'ayani? ");
INSERT INTO tpp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero an Jesús jantu k'is alhtaylh. Wa chuncha an xa'ay tukan sacerdote jumpalay an Jesús: ―La ixtalakask'i an yu la'ajunta Dios ijkunan akilajuniwi li uxint'i Cristo, an isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Pus an Jesús alhtaylh juniy: ―Uxint'ich'a naw, chi atumpaj klajunaw chaway ati'anta k'ala'ts'ina'itcha an isTs'alh Lapanak katawlanta tan oxi la ixpa'xti an Dios tan ch'alhkatnan, ch'i k'ala'ts'ina'it'iti akxni kaminanta lakt'iyan laka jataputs'i. ");
INSERT INTO tpp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wa chuncha, an yu xa'ay tukan sacerdote la'lh'alhcha an ixla'ch'it, najun: ―¡Wa aya juniya an Dios! ¿Ali jama'lhtask'iniyawi yu kata'alhtasulh? Alha'asmat'atcha tacha an wa aya juniy an Dios. ");
INSERT INTO tpp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿T'asuch'a lhiwilayat'iti? Yu'uncha ta'alhtaylh, tajuniy: ―¡T'acha'ancha kama'nikalh! ");
INSERT INTO tpp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Pus akxni tsukulhcha tala'puchujway, chi ixtalakasamaycha chi ali'in ixtala'xtisaycha. ");
INSERT INTO tpp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ixtajuniy: ―Akilajuniwcha tichini muk'anincha Cristo. ");
INSERT INTO tpp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","An Pedro sa'cha ixwilh ma'spa jatalakxtut. Walh la'cha'alh pumatam t'aku ma'tsuku, juniy: ―Uxint'i wachu ixt'alhtanak'at'i an Jesús, jamacha'a Galilea. ");
INSERT INTO tpp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero an Pedro najun ma jantu, ixchuxk'ani ta'alha'asmat'olh, najun: ―Jantu ijk'atsay t'uch'ini uniycha. ");
INSERT INTO tpp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ixli'astan an Pedro, alhi an jatalakxtut, walh a'tam la'ts'impalh pumatam t'aku ma'tsuku', an t'aku jajuniy an yu ancha ixtat'ajun: ―Ani wachu ancha ixt'a'aklat'ajun an Jesús, yu jamacha'a Nazaret. ");
INSERT INTO tpp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero an Pedro a'tam nawpalhi li jantu mispay, najuncha li jantu sawalh, najun: ―¡Jantu ikmispayi tichini yuchacha lapanak! ");
INSERT INTO tpp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Pants'ik'ischa jumpalh, an yu ancha ixtat'ajun tala'cha'alh an Pedro tajuniy: ―Chun sawalh uxint'i wachu yu yu'uncha, mu wanaj ch'unch'a ch'iwiniy. ");
INSERT INTO tpp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pus akxni wa aya najuncha, chi ixnajuncha li xasawalh, najun: ―Jantu ikmispayi anchunu lapanak. Walh wa akxni t'asalhcha an puyux. ");
INSERT INTO tpp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pus akxni, an Pedro pastaklhicha tacha an ixjunita an Jesús, akxni junikalh an Pedro: “Jantuka' katit'asalh puyux, a't'utucha k'anawna'a li jant'u k'imisp'ay.” Pus taxtulh ma'spa, wa stakcha alhulh. ");
INSERT INTO tpp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Akxni tunkulhcha, ixchuxk'an an xalaj'ajin sacerdotejnin chi an xalaktatanin an jamacha'an Israel, tatamakawlhcha li katama'niyacha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pus tach'ilhi'anilhcha an Pilato, tama'axta'nilhcha, mu yucha gobernador ixjunita. ");
INSERT INTO tpp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wa chuncha an Judas, an yu ma'axta'lhi an Jesús, akxni la'ts'incha li kama'nikanacha, astancha najun, pus jama'axta'nicho'olhi an a'xp'uxamkaw tumin de plata an xalaj'ajin sacerdotejnin chi an laktatanin, ");
INSERT INTO tpp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","jajuniy: ―Tala'alhincha k'ilhtuy li ikma'axt'a'acha ani lapanak yu jantu tani lay. Pero yu'uncha wa tajuniy: ―Kitnan jantu kintala'alhink'an. ¡K'ala'ts'icha uxint'i! ");
INSERT INTO tpp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pus tilh maka'alhi an tumin an laka tajtan, taxtulhcha, alhcha, chi lhtujcha ch'ikilhtakalh ix'akstu. ");
INSERT INTO tpp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Chi an xalaj'ajin sacerdotejnin talaksaklhi an tumin talajuniy: ―An lhamap'a'sin jantu najuni li layi kamucho'o ani tumin, an tan mukan xatumin laka tajtan, mu ixtapalhcha jak'alhni. ");
INSERT INTO tpp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ixli'astan talakchiwinilhcha chi tatamakawlhcha li katalhitamawyacha lakaat'un, pus talhitamawlhcha lakaat'un tan junkan ixlakaat'un yu la'la'oxiy a'cho'o, tan kajamaknukalhcha yu jantu an jamacha'an. ");
INSERT INTO tpp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xliyu anchunu lakaat'un masi chaway junkan lakaat'un de jak'alhni. ");
INSERT INTO tpp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chunchacha walh sawalh tacha an ixnajunta Jeremías, yu ixlichiwiniy ixchiwinti Dios akxni nawlh: “Taxa'a'ilhi an a'xp'uxamkaw tumin de plata yu ixtapalhcha ixta'ulanita an jamacha'an Israel, ");
INSERT INTO tpp_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","chi talhitamawlhcha an ixlakaat'un yu la'la'oxiy a'cho'o, tacha kilhijunilh an Dios.” ");
INSERT INTO tpp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","An Jesús la ixlakapucha an Pilatojo ixyalh, pus an Pilato lhisakmiy an Jesús, juniy: ―¿Uxint'i ixrejk'an jamacha'an Israel? An Jesús alhtaylh: ―Uxint'ich'a na'un. ");
INSERT INTO tpp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chi akxni ixta'alhtasuycha an xalaj'ajin sacerdotejnin chi an laktatanin, an Jesús jantu k'is ja'alhtayanalh. ");
INSERT INTO tpp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pus an Pilato juniy: ―¿Jant'u asmat'a tacha an stak talhimuk'ayan? ");
INSERT INTO tpp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero an Jesús jantu k'is tu'u alhtaylh, pus an Pilato sawalhcha ixli'a'niy. ");
INSERT INTO tpp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chi mu a'tamincha akxni ix'alin k'atan, an Pilato ixmakajun xamati tach'in, watichicha ixtask'iniy an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Walh akxni, ixmalaklhchawkanta pumatam tach'in ixjunkan Barrabás, sawalhcha ixmispakan. ");
INSERT INTO tpp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pus akxni anchacha ixta'ayxto'nun an lapanakni, an Pilato jajuniy: ―¿T'isiyuch'ach'a lak'ask'inat aklamakawniwi? ¿Yucha an Barrabás, u yucha an Jesús, an yu tajuniy li Cristo? ");
INSERT INTO tpp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chunchacha jajunilh an Pilato mu yucha ixk'atsayi li wa ixtaxkajiya an Jesús, xliyu talhima'axta'nilh. ");
INSERT INTO tpp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Walh akxni sa'cha ixwilh la ixtants'i an Pilato, tan ixnajun tichini ixli'ancha tala'alhin chi tichini yu jantucha, an ixt'iwi mala'achanilh chiwinti tan juniy: “Jant'u t'ani k'a'ilht'u anchunu yu jantu ta lay lapanak, mu ts'isicha makxkay tukani ijkala'awanalh, yucha ixlakata.” ");
INSERT INTO tpp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero an xalaj'ajin sacerdotejnin chi an laktatanin, tamatanunilhi an lapanakni li yucha an Barrabasi katask'inilh an Pilato chi an Jesús kama'nikalhcha. ");
INSERT INTO tpp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pus an Pilato jalhisakmipalh jajuniy: ―¿Tanyuchacha an ixt'uyunk'ani nawnat aklamakawniwi? Yu'uncha ta'alhtaylh: ―¡Yucha an Barrabás! ");
INSERT INTO tpp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","An Pilato jajuniy: ―¿Chi an Jesús yu unat'it li Cristo, tasicha ak'ilhtuya'a? Ixchuxk'ani tajun'olh: ―¡Kamakxtukmuk'akalhcha laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","An Pilato jajuniy: ―¿Tasu'u, tisuncha tala'alhini ilhtuta? Pero yu'uncha palay p'as ixtalaknajun: ―¡Kamakxtukmuk'akalhcha laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pus la'ts'incha an Pilato li jantucha lay tu'u ilhtuy, li apalijcha wa palay tala'talh'amani an lapanakni, pus sk'inlhicha xkan, chi ix'ukxlakapuchak'an ixchuxk'an an lapanakni ma'ch'a'alhcha, jajuniy: ―Kit'in jantu kintala'alhini an xak'alhni ani lapanak, mu jantu tani lay. K'ala'ts'int'itcha uxitnan. ");
INSERT INTO tpp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pus chux an lapanakni taja'alhtayanalh, tanajun: ―¡Kitnancha aklhitawk'ayaw an xak'alhni, chi an kilakjas'at'anink'an! ");
INSERT INTO tpp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wa chuncha an Pilato jamakawnilhcha an Barrabás. Pero an Jesús lhinawlhcha li kala'ana'makalhcha, chi ma'axta'lhicha li kamakxtukmuk'akalhcha laka cruz. ");
INSERT INTO tpp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","An isoldadojnin an Pilato talhi'alhcha an Jesús an laka palacio, chi anchacha talama'ayxto'olh ixchuxk'an an soldadojnin, lhtayancha tala'atanchanulh. ");
INSERT INTO tpp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tamaxtunilhcha an ixla'ch'it, chi tamala'ch'inilhcha slapulh la'ch'it. ");
INSERT INTO tpp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chi tama'tanulhcha ixcorona, si jalhtukun, chi tamach'apalhcha ma'atam wa tacha ch'ankat an tan lhi'oxi ixmaka'. Ixtatatso'ottaniycha, ixtamamaxaniycha, ixtajuniy: ―¡K'ajama'alht'axt'uncha ixrejk'an judiojnin! ");
INSERT INTO tpp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ixtala'achujwaycha, chi ixtapula'pana'acha an wa tacha ch'ankat ixtamach'apata. ");
INSERT INTO tpp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ixli'astan tamamaxani'olh, tamaxtunicho'olhcha an slapulh la'ch'it chi tamala'ch'inicho'olhcha an yu ixla'ch'it, chi talhi'alhcha tan katamakxtukmuk'aya laka cruz. ");
INSERT INTO tpp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Akxni ixtita'ancha, tapaxto'lhi pumatam lapanak jamacha'a Cirene, Simón ixjunkan, asi tamalhi'anilhi an ixcruz an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chi akxni tacha'alhcha tan junkan Gólgota (nawputun la Ixla'pa'axi Swe'elukut), ");
INSERT INTO tpp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ixtama'ot'uycha xaxkan uvaja an Jesús yu ixta'a'mujunita ix'alhch'ajat sun jach'itin pero akxni kilhk'atsalh jantu otlhi. ");
INSERT INTO tpp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chi akxni tamakxtukmuk'alhcha, an ixla'ch'it talamala'pitsilhcha, wa ta'amanalh suerte para li katak'atsaalhcha tichini yu laycha kalhi'alh. ");
INSERT INTO tpp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chi anchacha sa' ixtalakwilanalh, ixtalhist'ak'acha. ");
INSERT INTO tpp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","An la ix'akpuxni ixtats'o'nitacha tuchini talhima'nilhcha, ixtats'o'nita: “Ani Jesús, ixrejk'an judiojnin.” ");
INSERT INTO tpp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jat'amakxtukmuk'akalh ixt'uyunk'an ja'alhawnan, ixtapiktutamincha ixjat'ayawkanta, lhilaxjama'xi chi tan oxi ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","An yu ancha ixtapula'pusa wili wilicha ixtatalakpayajuy chi xkayajcha ixtajuniy. ");
INSERT INTO tpp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ixtajuniy: ―¡Li k'a'ixlakt'ilhi tajtan, chi li wa la'at'utu wilhchan k'a'ixla'oxiych'o'ocha, k'ama'alht'axt'uk'acha mi'akstu! ¡Li isTs'alhk'at'i Dios, k'at'a'alht'a'ut'icha an laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","An xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an fariseojnin, chi an laktatanin wanajcha chuni ixtamamaxaniy, ixtajuniy: ");
INSERT INTO tpp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ali'in jama'alhtaxtulh chi yucha jantucha layi ma'alhtaxtunikan ix'akstu. Li xaRey Israel kata'alhtaxtulhcha chaway an laka cruz, walh chuncha kakiklaka'iyawcha. ");
INSERT INTO tpp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sawalhcha kiklaka'iya Dios, pus kama'alhtaxtunilhcha li mapayniy sawalh, mu najun: “Kit'in isTs'alh Dios.” ");
INSERT INTO tpp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","An ixjat'amakxtukmuk'akanta ja'alhawnan, xkayajcha ixtajuniy wachu'. ");
INSERT INTO tpp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chux an lakaat'un wanaj taputs'isi'olhi atunkuwcha walh sta las tres yu ta'oxaycha. ");
INSERT INTO tpp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ixjunt'ajuncha las tres yu ta'oxaycha, an Jesús p'asi chiwinilh, najun: ―Eli, Eli, ¿lama sabactani? ―nawputun: KiDios, kiDios, ¿t'asu li k'imak'a'unt'acha? ");
INSERT INTO tpp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ali'in yu ancha ixtayanalh talajuniy akxni ta'alha'asmatlhi: ―Yucha an Eliasi t'asaniy. ");
INSERT INTO tpp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pus jats'alaj'alh pumatam watukan, xa'a'ilh la'atam wa tacha panimak, chi mala'ch'uch'uwalhcha vinagre chi kinkach'imuk'alhcha ma'atam swa'alh k'iw, para li yuchacha kapuma'ot'ulh. ");
INSERT INTO tpp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero an ali'in tanajun: ―K'amak'awcha, kala'ts'inawcha li kamina ma'alhtaxtunu an Elías. ");
INSERT INTO tpp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Walh an Jesús, a'tam p'asi chiwimpalh, ma'axta'lhicha an ixtakuwin. ");
INSERT INTO tpp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pus akxni, an la'ch'it an yu ix'uk'alh laka tajtan, lht'it'in tapu'exli, aklht'uyi walh, talhmani pu'a'taynichalh ta'exa sta talaktsin. Chi an lakaat'un laklalhcha, an chiwx la'tapup'a'xli. ");
INSERT INTO tpp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chi an tan ixlak'aknukan la'ta'a'mix'alh, pus ixluwk'an an yu ixtajakiklaka'inin yu ixtalaknitacha, tala'awcho'olh. ");
INSERT INTO tpp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pus akxni tatakutlhicha an tan ixta'aknunun, ixlila'awcho'otacha an Jesús, ta'alhcha an la ixla'acha'an Dios, Jerusalén, pus ixluwk'ani yu tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","An ixcapitank'an an soldadojnin chi an ali'in yu an ixtat'alhistakta an Jesús, sawalhcha talaktalhanalhi akxni tala'ts'ilhcha tacha an laktapasalh chi tacha an ixlaklay an lakaat'un, pus talajuniy: ―Sawalhi li ani isTs'alh Diosi ixjunita. ");
INSERT INTO tpp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Wa ma'at ixluwk'an t'akunini ixtalaka'an, yu'uncha an ixta'a'tayjuy an Jesús, yu ixtach'a'o'atachalh sta xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ancha ixtama'yanalh an María Magdalena, chi an María, an ixnati Jacobo chi José, chi an ixnatik'an an ists'alan tichi lapanak junkan Zebedeo. ");
INSERT INTO tpp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Akxni tats'isilhcha, cha'alh pumatam lapanak jamatumin, José junkan, jamacha'a Arimatea, yucha wachucha ixt'alhtana an Jesusi ixjunita. ");
INSERT INTO tpp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","La'cha'alhi an Pilato, sk'inilhi an ixlakatunaj an Jesús. Pus an Pilato lhinawlhi li kaxta'nikalh. ");
INSERT INTO tpp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","An José pula'apamililhcha laka sut'ut'u sábanaja an ixlakatunaj an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Chi maknulhcha tan wa sast'ika ixja'ajnanta ixtamp'in laktalhpa, ixli'astan ma'atamp'ililhi'alhcha la'atam aya chiwx yu pumalaklhchawlhcha an tan putanukan, chi ancho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ancha sa' ixtalakwilanalh an María Magdalena chi an pumatam María la ixlakapu an tan maknukalh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tunkunchalh, sábado, an xalaj'ajin sacerdotejnin chi an fariseojnin wa ayxtamcha ta'alh la'ts'inin an Pilato. ");
INSERT INTO tpp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tajuniy: ―Jamach'alhkat, ikpastakwi li akxni ixt'ajunka anchunu ja'o'xcho'onu, nawlh: “Ixlila'at'utu wilhchan akla'awcho'oya'.” ");
INSERT INTO tpp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","K'alhinaw li oxi kalhistakkalh an tan aknuy sta la'at'utu wilhchan, wa lay kata'alh an ixt'alhtanan puts'ista, chi kataki'alhawlhi an ixlakatunaj chi katanawlh li la'awcho'olh, li chuncha katapasaya palaycha ay la'o'xcho'o kajuna', walh jantu ixlip'ulhnaj. ");
INSERT INTO tpp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pus an Pilato jajuniy: ―Aniych'a jalhit'awnat'iti soldadojnin yu katajalhistaknana'. K'ap'inchi'itcha lhistaknini tacha yu laycha. ");
INSERT INTO tpp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pus ta'alhcha, oxicha ta'o'slamnilhi an tan ix'aknuy an Jesús chi ta'ulanilhcha la'atam sello, chi tamalhistaknilhcha an soldadojnin. ");
INSERT INTO tpp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","La'puslicha akxni jantu tapatsakan wilhchan, tunkuncho'olhcha la'atam wilhchan yu pu'a'taynicho'oycha la'atam samana, an María Magdalena chi an pumatam María ta'alhcha laka'anini an tan ix'aknuy Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Walh p'asi laklalh an lakaat'un, mu pumatam ix'angelh an Dios minchalh lakt'iyan, ta'alhtajulh, chi cha'alhcha an tan ix'aknuy an Jesús, ma'osunilhi an aya chiwx an yu ixpu'o'xt'alhkanta, sa'cha putawilh. ");
INSERT INTO tpp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wa tacha wa jamakalipnicha ixtasuy, chi an ixla'ch'it wa tacha wa sut'ut'ucha nieve. ");
INSERT INTO tpp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","An yu ixtajalhistaknan soldadojnin sawalhcha talaktalhanalh wa xk'ip'ip'icha ixtalaklay chi tala'ta'a'talhcha, wa tacha wa talaknilhcha sa' talaktamalh. ");
INSERT INTO tpp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pero an angelh jajuniy an t'akunin: ―Jant'u k'alakt'alhanant'iti uxitnan. Kit'in ijk'atsay li yucha an Jesusi p'uxk'awyat, an yu tamakxtukmuk'alh laka cruz. ");
INSERT INTO tpp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yucha jantucha tu'u tanun, la'awcho'olhcha, tacha an ixnajunta. Li k'at'atcha la'ts'inini an tan ixmamakanta. ");
INSERT INTO tpp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","K'alas jak'i'unit'iti an ixt'alhtanan li la'awcho'otacha. Yucha katatap'ulhniyan ka'ana xalakaat'un Galilea, ancha k'ala'ts'int'achi'it. Chaway klajuniwcha. ");
INSERT INTO tpp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pus an t'akunin so'ojo tataxtulh an tan ix'aknuy an Jesús, p'ascha ta'alh, mu ixtalaktalhanancha, pero wachu ixtalaj'achampalay. Ta'alhcha mak'ats'aaninini an ixt'alhtanan an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Akxni wa ixtita'anka an t'akunin, an Jesús jatalakasunilh chi jala'axa'alalhcha. Pus stalhcha tala'alh, tatatso'ottanilhcha chi tala'atanunilhcha an ixch'aja'. ");
INSERT INTO tpp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Pus akxni an Jesús jajuniy: ―Jant'u k'alakt'alhanant'it. K'ap'inchi'it jamak'atsaaninini an kijat'ala'awnin li kata'alhi xalakaat'un Galilea, ancha akintala'ts'inanta. ");
INSERT INTO tpp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pus akxni anchaka ixtita'an an t'akunin, ali'in an yu ixtajalhistaknanta soldadojnin ta'alhi an la'acha'an, takimak'atsaanilhi an xalaj'ajin sacerdotejnin tacha an laktapasalh. ");
INSERT INTO tpp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pus an xalaj'ajin sacerdotejnin tat'ata'ayxto'lhi an laktatanin, chi talakchiwinilhcha, chi jaxta'nikalhcha la'lhuw tumini an soldadojnin, ");
INSERT INTO tpp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","jajunkan: ―K'anawna'it li akxni ixlaklht'at'ayat'it, puts'ista taki'alhawlh an ixlakatunaj an Jesús an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chi li kak'atsaya an Pilato, kitnancha akt'achiwininaw para li jant'u t'a k'a'ilht'uk'ant'it. ");
INSERT INTO tpp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","An soldadojnin tajama'lhtayanalhi an tumin chi chunchacha tanawlh tacha an ixjajunkanta. Tacha an jajunikalh an soldadojnin li katanawlh, sta masi chaway an judiojnin chuncha talajuniy. ");
INSERT INTO tpp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pero an ixpumakawtamk'an ixt'alhtanan an Jesús yu'uncha ta'alhcha an xalakaat'un Galilea, an a'stitawk'a tan an Jesús ixjajunita li kata'ana'. ");
INSERT INTO tpp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Akxni tala'ts'ilhcha, tatatso'ottanilhcha pero an ali'in jantu tukancha ixtalhiwilay. ");
INSERT INTO tpp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pus an Jesús stalh jala'alh, chi jajuniy: ―Chux lhich'alhkat an lakt'iyan chi an lakaat'un la kimaknicha kima'axta'nikalh. ");
INSERT INTO tpp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chaway k'ap'inchi'itcha, chi k'aja'ilht'utcha kint'alhtanan ta kilhmakchux ta'alin an lapanakni, k'ajama'p'axaya'itcha la ixta'a'ut an kimPay chi an isTs'alh chi an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","K'ajamasuniya'it'itcha li katakiklaka'ilhi tacha an klajuntawcha uxitnan. Lhilhiji aklat'a'aklatsukuyaw uxitnan sta akxni ka'ukla'oya an lakamunulhpa'.");
INSERT INTO tpp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aniya a'taynilh an laj'oxi chiwinti yu lhichiwiniy Jesucristo, isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","An tan ts'o'muk'ata an Isaías, yu ma'anchacha ixlichiwiniy ixchiwinti Dios, najun, tan manawnilh an Dios: P'ulhnaj akmak'ana yu ka'ana lhichiwiniy an kinchiwinti para li kamala'asijnilhi min tij. ");
INSERT INTO tpp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chiwijlakaminkani an tan jantu xamati wilh lakak'iwin, nawkan: “K'ala'asijt'itcha, k'ala'oxit'itcha an ixtij an ay Jamach'alhkat, oxich'a k'ats'uk'ut'it.” ");
INSERT INTO tpp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pus an Juan, tsukulhcha jama'paxayi an lapanakni an lakak'iwin chi ixjalhixa'alaycha li katamakawlhcha ixtala'alhink'an para li an Dios kajamala'mixiynilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pus wanajcha lhilhuwi ixtala'cha'an yu ixtaminachalh xalakaat'un Judea chi la'acha'an Jerusalén. Ixtanajuncha tuchini ixtala'alhinchak'an pus ixjama'paxaycha, tanchun ayxkan junkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","An ixla'ch'it an Juan wa ixla'ach'awt camellojo ixla'oxiynikanta chi ixch'axpawilhcha a'xtam jaxt'a'an. Chi akxni xwajin wa t'axkat yu alin lakak'iwini ix'uy, chi sele'. ");
INSERT INTO tpp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ixnajun: ―Xli'astan kamina pumatam yu palay alhp'asni, kit'in jantu k'is ixt'achun, yucha masi li wa akta'antalhcha ak'o'x'otnilh ixwarachi, jantu ikt'acha'an. ");
INSERT INTO tpp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kit'in wa laka xkani iklama'paxayaw pero yucha katama'paxayan la ixTakuwin Dios. ");
INSERT INTO tpp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Walh la'atam wilhchan an Jesús minchalh la'acha'an Nazaret xalakaat'un Galilea. La'cha'alhcha an Juan, juniy: ―Ak'ima'p'axat'i. Pus an Juan ma'paxalhcha an Jesús, an ayxkan tan junkan Jordán. ");
INSERT INTO tpp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Walh wa ixtakutt'ajunka an Jesús an lakxkan, la'ts'incha an lakt'iyan tati'alh, chi ta'alhtajulhcha wa tacha la'atam paloma, tan ixyalh, yucha an ixtakuwin Dios. ");
INSERT INTO tpp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Xli'astan chiwinkancha an lakt'iyan nawkan: ―Uxint'i kinTs'alhk'at'i, ikmapayniyan. Uxint'i k'ima'an'ach'ay. ");
INSERT INTO tpp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wa chuncha watukan lhi'alhi an ixtakuwin Dios lakak'iwin, ");
INSERT INTO tpp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","chi anchacha aklatsukuchalh t'up'uxam wilhchan, tan ta'alin ma'tilin. Chi an Satanás ixlila'ts'intanuycha an Jesús. Akxni makawlhcha an Satanás, tala'cha'alhcha an angelhnin chi ixtatapatsaniycha. ");
INSERT INTO tpp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","La'puslicha wilhchan akxni an Juan ixmalaklhchawkanta, an Jesús alh lhichiwiniy ixchiwinti Dios an xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Najun: ―Chilhcha panch'e'ex, an ixlich'alhkat Dios waniycha minta, k'ak'iklak'a'itcha an ixchiwinti Dios jant'uch'a ali k'a'ilht'ut'iti mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Akxni waniycha ix'antachalh ixpiktu xa'alamalh Galilea, an Jesús jala'ts'ilh ixt'uyunk'an ixch'apayawnan jatanti, wa lhit'ala'awnin. Yu'uncha an Simón chi Andrés. Ixtamujuy ixpaxo'tank'an an lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jajuniy an Jesús: ―Akilat'a'awcha walh ixma'alhilanancha lapanakni akla'ilhtuyaw. ");
INSERT INTO tpp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pus watukan tamakawlhi an ixpaxo'tank'an, chi tat'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lanancha ma'ati ixta'antalh, an Jesús jala'ts'impalh an Jacobo chi an Juan, ists'alan Zebedeo, ixtalakch'it'ajun ixpaxo'tank'an laka barco. ");
INSERT INTO tpp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jat'asanilh, pus tamakawchalhi an ixpayk'an Zebedeo laka barco ali an yu tat'atapatsay, chi tat'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tacha'alhcha Capernaúm. Chi akxni jantu ixtapatsakan wilhchan ixmasuycha an Jesús an laka cha'a yu puta'ayxto'kan. ");
INSERT INTO tpp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ixtalhi'a'niycha tacha an ixmasuy, mu yucha ixjamasuniy tachanu yu lhit'ajun lhich'alhkat, jantu wa tacha an xamaestrojnincha lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Walh an laka tajtan ixtanun pumatam lapanak yu ixlakpach'apata makxkay'un, t'asaycha, najun: ");
INSERT INTO tpp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¡Jijwa! Jesús de Nazaret, ¿t'isunch'a la't'ant'a? ¿Wa kilamintawcha lalakt'ilhi'ulanin? Kit'in ikmispayan, uxint'i Stalan'a ixlapanak Dios. ");
INSERT INTO tpp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero an Jesús la'a'aymalh, juniy: ―¡Wa sa'cha! ¡Lasch'a k'amak'aw ani lapanak! ");
INSERT INTO tpp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pus an makxkay'un p'ascha lakchikixli an lapanak, chi p'ascha t'asalh, chi makawlhcha an lapanak. ");
INSERT INTO tpp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pus sawalhcha ixtalhi'a'niya an yu ancha ixtatanumanalh, ixtalajuniy: ―¿Tisuncha aniya? ¿Tisu sast'icha lhamap'a'sini li layi jalaj'aymay an makxkay'un chi ta'asmatniya? ");
INSERT INTO tpp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Watukan ta'a'pitsi'olhi an chiwinti chux Galilea. ");
INSERT INTO tpp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Akxni tataxtulhcha an laka tajtan, ta'alhcha ixcha'a an Simón chi Andrés, ali an Jacobo chi Juan. ");
INSERT INTO tpp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Walh an ixput'icha'o'olh Simón wa ixmalhcha, stak ixch'apata alhp'asni iskakat, pus tajuniycha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Wachuncha yucha la'alh chi ma'ch'apasaklhicha, walh watukan makawlhi an alhp'asni iskakat chi tsukulhcha jamaway. ");
INSERT INTO tpp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Akxni tats'isilhcha wanaj lhuw ta'an'anini jalhicha'anikalh an Jesús chi yu wa ixtalakpachapay makxkay'un. ");
INSERT INTO tpp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chux an lapanakni yu an tawilanalh an la'acha'an tacha'an'olhi an jatalakxtut. ");
INSERT INTO tpp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Pus tsukulhcha jak'uch'uyi an ta'an'anin, watuchicha ta'an'at ixtalhit'ajun, chi jak'uch'ulhcha wachu an yu wa ixtala'apaxto'ta makxkay'un, jantu ixjamakawniya katachiwinilh an lakmakxkay'un, mu ixtamispay. ");
INSERT INTO tpp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sawalhka wats'isin puts'istaka an Jesús ostayalh, taxtulhcha, alhcha tapaynini tan lakak'iwin. ");
INSERT INTO tpp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Walh an Simón ixpuxkajuycha chi an yu ancha ixtat'atamakajunta. ");
INSERT INTO tpp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Akxni tala'cha'alh tajuniy: ―Wanaj si tapuxkawyan. ");
INSERT INTO tpp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yucha jajuniy: ―Ka'aw an tan wa lakwaniy lakwilakalh wachu aklhichiwinina ixchiwinti Dios, mu yucha ikla'minta. ");
INSERT INTO tpp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pus ixlichiwiniycha an laka lakcha'a yu ixpula'ta'ayxto'kan, chux Galilea, chi ixjak'uch'uycha an yu wa ixtala'apaxto'ta lakmakxkay'un. ");
INSERT INTO tpp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","La'cha'alh pumatam lapanak yu ixlakap'uch'i'ojotacha, an Jesús, tatso'ottanilhcha juniy: ―Li sna ak'ink'uch'up'ut'u, ak'ink'uch'ut'ika'. ");
INSERT INTO tpp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pus mapayniycha an Jesús, lats'awalalhi an ixmaka chi lakpach'apachalhcha, juniy: ―Chun, k'at'ala'a'oxit'icha. ");
INSERT INTO tpp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wachuncha junilh, watukan wak tala'a'oxilh. ");
INSERT INTO tpp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Xli'astan p'ascha watukani mala'achalh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Juniy: ―Jant'u xamat'i tu'u k'a'un, wa k'ap'inchicha talakasunini an sacerdote. Chi k'ama'axt'a'a'acha milha'ulan ixlakata li t'ala'a'oxit'icha, tacha lhinawlh a Moisés para li katak'atsaalhi an sacerdotejnin. ");
INSERT INTO tpp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero yucha akxni alhcha, tsukulhcha laknajuni tani putapasalhcha, pus an Jesús xli'astan jantucha wanaj lay ixtanuyachalhi ixlitalakasun an la'acha'an, wa ma'atcha istsukuyachalh tan wa la'asa'nik'a, pero wa tanchuncha ixtalakminachalh ixtala'cha'an. ");
INSERT INTO tpp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jantu la'alhuw wilhchani ixtaxtuta an Jesús, xli'astan cha'ancho'olhcha la'acha'an Capernaúm, walh watukan lajk'atsakalhi li ma cha'ancho'otacha. ");
INSERT INTO tpp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pus watukan lhuwi tata'ayxto'lhi, jantucha ixtalhilayi masi wa jatalakxtutcha, chi ixjalhixa'alaycha an ixchiwinti Dios an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Walh tichi yu'uncha ixt'at'ink'an lapanakni tach'ixlicha'anilh pumatam lapanak yu wa ixlakalhtukulunta. ");
INSERT INTO tpp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero jantu lay ixtala'cha'ani waniy mu lhilhuw, pus ta'a'stilhukukulh lakats'uniya an cha'a'. Anchacha taputamaknulh la ixputamat an yu lakalhtukulunta. ");
INSERT INTO tpp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Akxni jala'ts'ilhi li tajakiklaka'inin, juniy an yu lakalhtukulunta: ―Ikmala'mixiniyani mintala'alhini kints'alh. ");
INSERT INTO tpp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Walh mu ancha ixtawilanalh an ali'in xamaestrojnin lhamap'a'sin, pus sa'cha ixtalhatapastaknan: ");
INSERT INTO tpp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tasu li chunchacha najuni? Wa aya najun, wa Diosi lay mala'mixiy tala'alhin. ¿Tisiyuchacha lay kamala'mixipala tala'alhini?” ");
INSERT INTO tpp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wayu mu an Jesús ixjak'atsaaniya tani ixtapast'ak'acha, jajuniy: ―¿T'asu li ch'unch'ach'a jat'ap'ast'aknanat'iti? ");
INSERT INTO tpp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tanyucha yu palay jantu lhima'anxkay ajkunilh: “Amintala'alhin ikmala'mixinincha”, u ajkunilh: “K'at'aycha k'asakt'icha amimputamat k'ap'inchicha”? ");
INSERT INTO tpp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Chaway kit'in yu ikwalh isTs'alh Lapanak aklamasuniyawi li layi ikmala'mixiy tala'alhin ani lakamunulhpa'. Junilh an yu lakalhtukulunta: ");
INSERT INTO tpp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Chaway uxint'i ijkunan k'a'ost'aycha, k'asakt'icha amimputamat chi k'ap'inchicha mincha'a'. ");
INSERT INTO tpp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pus ostayalhcha an yu ixlakalhtukulunta, chi saklhicha an ixputamat, tala'ts'in'ojoycha, pus sawalhcha talhi'a'niy, tanajun: ―Jantu a'tam ixla'ts'intawi tacha ani. An Dios ay sawalh. ");
INSERT INTO tpp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Xli'astan an Jesús ampalhi an ixpiktu lakxkan, anchacha ixjamap'a'siy mu lhuw lapanakni ixtala'cha'an. ");
INSERT INTO tpp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tan ixla'pust'ajun an Jesús la'ts'ilh an Leví, ists'alh Alfeo, sa' ixwilh tan mapalhlhi'ankan ixlakata tanlhun, pus juniy: ―Ak'int'ap'it'icha. Walh t'a'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Xli'astan an Jesús chi an ixt'alhtanan ixtat'awilanalhcha la ixmesa an Leví, la ixcha'a, ixluwk'an wachu ixtat'awilanalh an yu ixtalhach'inin tanlhun chi, an yu ixtalhit'ajun ixtala'alhink'an, mu wanaj lhilhuwi ixch'a'o'akanta an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pus an xamaestrojnin lhamap'a'sin chi an fariseojnin tala'ts'incha li tat'alakwajini an Jesús an yu talhach'inin tanlhun chi an yu talhit'ajun ixtala'alhink'an, pus jajunkan an ixt'alhtanan Jesús: ―¿Tasu li jat'alakwajincha an yu talhach'inin tanlhun chi an yu talhit'ajun ixtala'alhink'ani? ");
INSERT INTO tpp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","An Jesús asmatlhi, jajuniy: ―Yu oxi tat'ajun jantu tama'lhtask'iniya jak'uch'unu', yu tata'an'ay chun. Kit'in ikminta jat'asanini an yu talhit'ajun ixtala'alhink'an, jantu yu oxi tat'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","An ixt'alhtanan Juan chi an fariseojnin ixtalhitask'ajayi ixwaytk'an a'tamin. Chi tala'alh an Jesús tajuniy: ―¿Tasu li an ixt'alhtanan Juan chi an fariseojnin talhitask'ajayi ixwaytk'an a'tamini, chi amint'alhtanan yu'uncha tawajini? ");
INSERT INTO tpp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","An Jesús jajuniy: ―¿Chu laycha jantu katitawaylh yu tat'ajun tan tama'xto'kan? Li anchaka tat'ayanalh an yu tama'xt'o'a jantu layi katitalhitask'ajalhcha ixwaytk'an. ");
INSERT INTO tpp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero kamina wilhchani akxni an yu tama'xto'lhi jantucha ani katitsukulh. Akxni katalhitask'ajayacha ixwayk'an a'tamin. ");
INSERT INTO tpp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jantu xamati ts'ap'amuk'aniy yu sast'ika la'ch'it yu at'ilhcha la'ch'it, li chuncha, an yu sast'ika la'ch'it wa palay exa an yu at'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chi jantu xamati mujuy yu sast'ika xaxkan uva laka at'ilh jaxt'a'an, li chuncha, an sast'i xaxkan uva laj'exa an jaxt'a'an, pus pu'ancha an xaxkan uva chi an jaxt'a'an talaj'exacha. Yu sast'ika xaxkan uva laka sast'i jaxt'a'ani kamujukalh. ");
INSERT INTO tpp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","La atam wilhchan akxni wa jastaknankan ixla'pust'ajun tan jach'ananankanta an Jesús, walh an ixt'alhtanan tsukulhcha ta'akatan'ex'iya an trigo. ");
INSERT INTO tpp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pus an fariseojnin tajuniy an Jesús: ―K'ajala'ts'i, ¿tasu li ta'ilhtuycha yu jantu makawkan akxni jantu tapatsakan wilhchani? ");
INSERT INTO tpp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yucha jajuniy: ―¿Jant'u a'tam p'unawt'at'iti tani lalhcha an David chi an yu ixtat'a'anta akxni tachawanalh? ");
INSERT INTO tpp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yucha tanulhi an la ixcha'a Dios akxni xa'ay sacerdote ixjunita an Abiatar, chi ulhi an jamatajtanilanti pan, walh jantu lay xamati ix'uy, wa yu'uncha an sacerdotejnin, walh an David wachu jat'a'ulhi an yu ixtat'a'anta. ");
INSERT INTO tpp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Chi jajumpalay: ―An wilhchan akxni jantu tapatsakan, ilhtukalh ixlakata an lapanak, jantu ilhtukalh an lapanak ixlakata an wilhchan akxni jantu tapatsakan. ");
INSERT INTO tpp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Xliyu kit'in yu ikwalh isTs'alh Lapanak ikch'alhkatnani masi akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","A'tam tanupalhi an Jesús an tan ixtata'ayxt'o'a an lapanakni, walh ancha ixtanun pumatam lapanak yu jantu lay ixlak'anuy ma'atam ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chi mu akxni jantu ixtapatsakan wilhchan, an yu ixtaxkajiy an Jesús sawalhcha ixtalhist'ak'a li katapujuya kamajk'uch'uya an lapanak, para li katapu'alhtasulh. ");
INSERT INTO tpp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Walh an Jesús juniy an lapanak: ―K'at'aycha, tan'ajnich'a k'at'ay. ");
INSERT INTO tpp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chi jalhisakmilhcha an ali'in an Jesús, jajuniy: ―¿Oxi li ka'ilhtukalh yu oxi tu'u akxni jantu tapatsakan wilhchan? ¿U ani wilhchan ixpu'ilhtuka yu jantu oxi? ¿Ani wilhchan layi akma'alhtaxtunilh jatsukunti, u akma'nilh? Jantu xamati alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pus talh'amancha jala'ts'in an Jesús chi lhita'oxila'alhiycha li yu'uncha jantu talhakapu'ani li kataja'a'tayjunulh, juniy an lapanak: ―K'alats'awalat'icha amimaka'. Walh lats'awalalhcha, tamaj'oxilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wachuncha tataxtulhcha an fariseojnin ta'alhcha lhilakchiwinin ali an herodianojnin tani katalhima'nilhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Walh an Jesús chi an ixt'alhtanan ta'alhcha ixpiktu an lakxkan, lhuw lapanakni tama'alh. Jamacha'an Galilea, chi Judea, ");
INSERT INTO tpp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","chi Jerusalén, chi Idumea, chi ixlitapiktutamcha an ayxkan Jordán, chi la ixtuntala'acho'ocha an la'acha'an Tiro, chi Sidón, lhuw lapanakni tala'cha'alh, mu ixta'asmat'acha li laj'ay tanlhuni ix'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","An ixt'alhtanan jajuniy li katamala'asijninilh la'atam barco, para li jantu katapa'asilh, mu wanajcha lhilhuwi ixjunkanta. ");
INSERT INTO tpp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ixluwchak'ani ixjak'uch'uta pero an ali'in yu wachu ixtata'an'ay ixtalakask'in wachu masi wa kaxta'aych'apachalhcha, wa ixtaputamacho'oycha. ");
INSERT INTO tpp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","An lapanakni yu ixtalakpach'apata makxkay'un akxni ixtala'ts'incha an Jesús ixtata'a'tso'ottaniycha chi p'ascha ixtachiwiniy, ixtanajun: ―Uxint'i isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero yucha sawalhcha ixjalaj'aymayi para li jantu katanawlhi tichini yuchacha. ");
INSERT INTO tpp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xli'astan alhcha a'stitawk'a an Jesús, chi anchacha jat'asanichalh yu yuchacha jat'asaniputulh, pus tala'cha'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ixpumakawt'uychak'ani jasakxtulh yu katat'alhtanana chi kajamak'anacha kata'ana lhichiwinin ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ja'ilhtulhcha li layi katatamakxtuya lakmakxkay'un: ");
INSERT INTO tpp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","An ixpumakawt'uyk'an chunchuniya ixjajunkan: Simón, yu wachu junikalh Pedro, ");
INSERT INTO tpp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","chi Jacobo, chi Juan, ists'alan tichi lapanak junkan Zebedeo, yu'uncha jalhimapa'a'ulh Boanerges, nawputun ists'alan xalapanak xkan, ");
INSERT INTO tpp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","chi Andrés, chi Felipe, chi Bartolomé, chi Mateo, chi Tomás, chi Jacobo, ists'alh Alfeo, chi Tadeo, chi Simón yu ma'partido Cananista, ");
INSERT INTO tpp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","chi Judascha Iscariote, yu an ma'axta'lhi Jesús. Xli'astan ta'alhcha lakatam laka cha'a'. ");
INSERT INTO tpp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wanajcha lhilhuwi jumpalakalh, jantucha layi masi wa katitalakwaylhcha. ");
INSERT INTO tpp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Akxni an ixt'alalhila'ts'inin Jesús tak'atsaalh, ta'alhcha puxkawnini an Jesús para li katalhi'alhcha, mu ixtalaknajun ma wa lokojlaycha. ");
INSERT INTO tpp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ixpulaknicha ch'a'a an xamaestrojnin lhamap'a'sin, yu ixtamintachalh Jerusalén ixtanajun: ―Xliyu lay jalhitamakxtuy an lakmakxkay'un mu yucha an Beelzebú xapay makxkay'uni t'atapatsay. ");
INSERT INTO tpp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pus jaxa'alalhi an Jesús, chi tsukulhcha jajuniya tacha laycha talhimacha'xay, jajuniy: ―¿Tasicha lay kalhitamakxtukana wa ix'akstucha an Satanasi? ");
INSERT INTO tpp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Li la'atam lhich'alhkat wa lapu'aykan, yucha jantu a'tam oxi katitaylhi'alh, ");
INSERT INTO tpp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","chi lakatam laka cha'a, li wa siya yu'unchacha wachu tala'ajiy, katatalakt'ilhitawla'. ");
INSERT INTO tpp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chi mu li an Satanás wa ix'akstucha t'ala'aykan, jantu layi katitaylhi'alh, yucha ixputs'an'ancha. ");
INSERT INTO tpp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jantu xamati lay an tanunu la ixcha'a xamati lapanak yu k'ut'ilh, li jantu p'ulhnajcha ma'ch'imay chi xli'astan ka'alhawniyacha an ixtanlhun. ");
INSERT INTO tpp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Klajunaw yu sawalh, watuchicha tala'alhin kamak'akxanikana an lapanak, wa tani lhichiwinintacha an Dios. ");
INSERT INTO tpp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero watichicha yu wa aya lhichiwiniy an ixTakuwin Dios, jantu a'tam katimala'mixinikalh, yucha ixpujun'alhincha kajuna tach'in. ");
INSERT INTO tpp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chuncha jajunilh mu ixtajuniy li ma makxkay'uni ixlakpach'apata. ");
INSERT INTO tpp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Akxni tacha'alhcha an ixnati Jesús chi an ixjat'ala'awnin an tan ixtanumalh, tamala'achalhcha pumatam li ka'alh t'asanini'. ");
INSERT INTO tpp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pus tacha an ixtala'acho'owilananilh, tajuniy: ―Ma tapuxkawyan an mijat'ala'awnin chi an minati. ");
INSERT INTO tpp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yucha ja'alhtaylh jajuniy: ―¿Tisiyuchacha kinati chi kijat'ala'awnini? ");
INSERT INTO tpp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pus sa'cha jala'ts'ini an ixtala'acho'owilananilh, jajuniy: ―Uxitnani tacha kinati chi tacha kijat'ala'awnin, ");
INSERT INTO tpp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","mu wa tichicha yu ilhtuyi tacha an najun Dios, yucha kint'ala'ajun, kijamatsan chi kinati. ");
INSERT INTO tpp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A'tamcha tsukulh jamasunipalayi an Jesús la ixpiktu an lakxkan, walh wanajcha lhilhuwi ta'ayxto'palakalh pus tajulhcha lakatam laka barco anchacha sa' tawlhchalh chi chux an lapanakni ixpiktucha an lakxkani ixtayanalh. ");
INSERT INTO tpp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lhuw tanlhuni jajunilh pulhamacha'xan, chi tu'ucha ixjapumasuniy, tacha ani jajunilh: ");
INSERT INTO tpp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―A'tamchacha pumatam lapanak alh jach'anana'. ");
INSERT INTO tpp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Walh akxni tsukulhcha ch'an, an ali wa laka tiji tamachalh, pus ta'usaklhi an ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","An ali laka chiwxini tamachalh, tan tutukancha lhiyalh t'un, pus wa tukancha la'awlh, mu jantu talhmani yu t'un. ");
INSERT INTO tpp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Akxni xajchilhcha an wilhchan, la'xlo'lhi chi lakxixli, mu jantu tu'u ixjataxiyak. ");
INSERT INTO tpp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","An ali lakalhtukunani tamachalh, walh ta'ayalhi an jalhtukun, pus maxixilh, jantu tawk'anilhi xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero an ali tan oxi t'uni tamachalh, la'tampa'lhicha chi ta'ayalhcha. Tawk'anilhcha xajatawk'at, lhuwcha talhawalh. Wa la'atamin xatalhts'i alilhcha yu xta'cho'olhcha treinta chi sesenta chi tamcientojcha xatalhts'i. ");
INSERT INTO tpp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Chi jajuniy: ―Yu lhit'ajuni ixpa'asmatna ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Akxni wa ix'akstucha tamakawlh, an yu wa niy ixtayanalh chi an ixpumakawt'uyk'an ixt'alhtanan talhisakmiycha tuchini nawputuncha. ");
INSERT INTO tpp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Pus jajuniy: ―Uxitnan layi k'alhimach'a'xaya'it an yu jantu tasuy ixlich'alhkat Dios, pero an yu ma'spa tat'ajun wanaj wa laka pulhamacha'xani jajunkan, ");
INSERT INTO tpp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","mu masi tajalakawanan, tachanu jantu tajalakawan chi masi taja'asmatnan tachanu jantu taja'asmatnan, pus jantu layi jamala'mixinikan ixtala'alhink'an mu jantu tach'a'o'ayi Dios. ");
INSERT INTO tpp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chi jajuniy: ―¿Jant'u lhimach'a'xayat'iti an pulhamacha'xan klajuniw? ¿Chuncha tasicha k'alhimach'a'xaya'it an ali'i? ");
INSERT INTO tpp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","An jach'anana yucha an yu lhichiwiniy ixchiwinti Dios, ");
INSERT INTO tpp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","chi an yu wa laka tij tamachalh jach'ananti yu'uncha an yu jalhixa'alakancha, pero akxni ta'asmattacha, an Satanás jamak'ap'apalaycha la ixjalhunutk'an. ");
INSERT INTO tpp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wanajcha chuni an yu wa laka chiwxin tatamachalh, mu masi sawalhcha ta'achani ta'asmat'a akxni jalhixa'alakan, ");
INSERT INTO tpp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","jantu tajataxiyaklay, wa putamcha pants'ik'is, mu akxni lhima'anxkaycha talhiwilay u jalhich'a'o'akancha ixlakata an ixchiwinti Dios, tamakawcho'oycha. ");
INSERT INTO tpp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","An yu lakalhtukunan tamachalh, yu'uncha an yu ta'asmat'acha, ");
INSERT INTO tpp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero mu sawalhcha talhakapu'ani tacha an lak'alincha tanlhun chi lhuw tumini talhitsukuputun, pus chux ani tanlhun maksk'anjwacho'oyi an ixchiwinti Dios jantu tu'u ta'ilhtuy yu laj'oxi. ");
INSERT INTO tpp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","An yu tan oxi t'un tatamachalh, yu'uncha an yu ta'asmat'acha ixchiwinti Dios chi takiklaka'iy, pus lhuwcha talalalhaway, wa pumatamjtamin, alincha yu treinta, sesenta chi cien xt'a'a ixjatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Wachu jajumpalay: ―¿Chu sna li makilhnukan pumaklhku, a't'alh'ulakancha laka cajón u la ixtan'apuwcha putamati tamaknukan? ¡Jantu! Yucha muk'akancha tan oxicha kamapulhkulh. ");
INSERT INTO tpp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jantu tu'u yu jantucha lay katik'atsakalh yu jantu ixk'atsakan, chi jantu tu'u yu jantucha katimalakasukalh tan putunku. ");
INSERT INTO tpp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Li xamati lhit'ajun ixpa'asmatna, ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Chi jajumpalay an Jesús: ―K'alhak'ap'up'it'iti an t'ach'a asmat'at, mu t'ani p'alhk'ananatcha, wach'u ch'uni k'ap'ulhk'ak'ana'it, ch'i p'alay k'alhimo'slanik'ana'it'iti uxitnan yu asmat'atcha. ");
INSERT INTO tpp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mu an yu lhit'ajun palay kajama'lhtayanana', pero an yu jantu lhit'ajun, masi wa k'ischa kaxlitsukulh kamaxtuni'okana'. ");
INSERT INTO tpp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ixnawpalay: ―An ixlich'alhkat Dios tacha xamati lapanak yu jach'ananan. ");
INSERT INTO tpp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Puts'ista lhtatay chi wats'isin ostayapalaycha. An yu ch'anta tamp'a'acha chi ta'ayaycha, pero yucha jantu k'atsayi tani lhita'ayaycha. ");
INSERT INTO tpp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","An lakaat'un ix'akstucha ma'alay an jach'ananti, p'ulhnajcha taxtuniya xax'oy, p'a'acha xli'astan tawk'aniycha xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chi li akxni li oxicha k'at'ata, p'uxacha an lapanak, mu ixpakucha chi cha'xmaj'ancho'oycha. ");
INSERT INTO tpp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","An Jesús wachu jajumpalay: ―¿Tasicha lay aklalhimalakxtuniw an ixlich'alhkat Diosi? Chunchuni: ");
INSERT INTO tpp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tachanu la'atam lakat'ikt'i xatalhts'i mostaza, masi yucha wanaj wa lakat'ikt'i, ");
INSERT INTO tpp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","apalij yucha yu palay ay lhtinin ta'ayay, tan tamuk'aycha ixpamaj'ank'an an ts'o'on chi tapamalhk'iknincha. ");
INSERT INTO tpp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Tamj tamjcha ixjajuniy pulhamacha'xan an Jesús, tacha lay ixtalhimacha'xaniy. ");
INSERT INTO tpp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa laka pulhamacha'xani ixjajuniy wa chuncha ixjaxa'alay. Pero li akxni wa la'stu an ixt'alhtanan ixtat'atawlay ixjajun'ojoy, mu yu'uncha ixtalhimacha'xay. ");
INSERT INTO tpp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Akxni tats'isilhcha jajuniy an ixt'alhtanan: ―An ixtakilhtutamcha an lakxkani ka'aw. ");
INSERT INTO tpp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pus jamakawyawlhcha tacha an lhilhuw ixlakyakalh, tatajulhcha an laka barco, ta'alhcha. Ali barco ixtach'a'o'alhi'anta. ");
INSERT INTO tpp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Walh tsukulh lay p'as un chi xkan, an xkan tsukulhcha putajuyi an barco, ixtalak'aknut'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","An Jesús ilhtatajtajumachalh la ix'istaj an barco, ix'a'ts'inta ix'a'ts'i. Mu sawalhcha ixtalaktalhanani an ixt'alhtanan tamakujulhcha, tajuniy: ―Maestro, talak'aknut'awnawcha uxint'i jant'u lhak'ap'up'in. ");
INSERT INTO tpp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pus ostayalh, la'a'aymalhi an p'as un, chi an alamalh, juniy: ―Sa'ch'a k'at'a'ulh chi sa'ch'a k'ak'ilhu. Pus wanaj sa' tawlhcho'olh. ");
INSERT INTO tpp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chi jajuniy an ixt'alhtanan: ―¿T'asu li sawalhch'a lakt'alhananat'iti, ch'u jant'u jak'iklak'a'ininat? ");
INSERT INTO tpp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pus sawalhcha ixtalaktalhanan, ixtalajumpaxay: ―¿Tisiyuchacha ani, li an un chi an xkan ta'asmatniya? ");
INSERT INTO tpp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tacha'alhcha ixtapiktutam an lakxkan la ixlakaat'unk'ancha an jamacha'an Gadara. ");
INSERT INTO tpp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","An Jesús takutlhicha an laka barco. Walh xajnichilh pumatam lapanak an kampusantu yu lakpach'apata makxkay'un. ");
INSERT INTO tpp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","An tan ixlak'aknukani ixtawlay, chi jantucha xamati lay ixch'i'ulay masi laka cadena. ");
INSERT INTO tpp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mu a'lhuwchaa ixch'i'ulakan laka cadena pero ixlaj'ex'ulay, pus jantu xamati lay ilhajay. ");
INSERT INTO tpp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Stakcha ixt'asajtsukuyi tunkuw chi puts'ista an lakak'iwin chi an kampusantu. Chi ixlakamak'atsanikancha laka chiwx. ");
INSERT INTO tpp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Walh, akxni la'ts'inkalhcha an Jesús akxni ma'atka ix'antachalh, la'ats'alaj'ankalhcha chi tatso'ottanikalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","P'ascha ixa'alakan an Jesús, ixjunkan: ―¡Jesús, isTs'alh Dios yu wilhchalh talhman! ¿Tasicha k'ilhtuyani? Iksk'iniyan la ixtalakask'i Dios, jant'u ak'imama'alh'ajnit'i. ");
INSERT INTO tpp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chuncha ixnajun an makxkay'un mu an Jesús juniy: ―¡Makxkay'un, k'amak'awcha ani lapanak! ");
INSERT INTO tpp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","¿T'asich'a unk'an? ―juniy. ―Legión, mu wanaj kilhuwk'an, ―najun. ");
INSERT INTO tpp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sawalhcha tapayniniya an makxkay'un an Jesús li ma jantu kajatamakxtulhi an tan tat'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chi mu waniy ancha a'stitawk'a ixta'exwayt'ajun lhuw p'axnin, ");
INSERT INTO tpp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","pus an lakmakxkay'un tatapaynisk'iniycha an Jesús, tajuniy: ―Yu'uncha an p'axnincha ajkalakpach'apayaw. Anchacha akilamak'aw. ");
INSERT INTO tpp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jamakawnilhi an Jesús, pus tamakawlhcha an lapanak. Yucha an p'axnincha talakpach'apalh, ka tacha la'at'uy milh p'axnin. Talakats'alaj'alhi an p'axnin an tan a'talhman chi tata'aj'ajulh, chi talaj'aksk'anj'u'olh an lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","An yu ixtalhist'ak'a an p'axnin talakats'alalh chi ixtajamak'atsaaninincha an la'acha'an chi masi tan wa jalhi'ay tacha an tapasalh. Pus ta'alhcha la'ts'inini tuchini tapasaycha. ");
INSERT INTO tpp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tala'cha'alhcha an Jesús, chi tala'ts'incha an yu ixlakpach'apata makxkay'un tan sa'cha ixwilh, ixmala'ch'inincho'otacha, oxicha ixjalakpastaknancho'oy, pus ixtalaktalhanancha an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","An yu tala'ts'ilh tani tapasalhcha an yu ixlakpach'apata makxkay'un, ixtat'alajuniycha an ali'in, chi tani talalhcha an p'axnin. ");
INSERT INTO tpp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pus tatapayninilhcha an Jesús li ma kataxtucho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Akxni tajucho'olhcha an laka barco an Jesús, an yu ixlakpach'apata makxkay'un sawalhcha tapayniniya li ma kat'a'ana'. ");
INSERT INTO tpp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero an Jesús jantu makawnilh, yucha juniy: ―K'ap'inchicha mincha'a'. K'ajala'p'inchicha yu t'a jalhila'ts'in, k'aja'una'acha li an Dios yucha k'uch'un chi li yucha mapaynin. ");
INSERT INTO tpp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pus alhcha, chi tsukulhcha laknajuni an xala'acha'anaxni Decápolis tani lhik'uch'ulhcha an Jesús. Sawalhcha ixtalhi'a'niy. ");
INSERT INTO tpp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Akxni pupatakutcho'ochalhcha an barco an Jesús an ixtakilhtutamcha lakxkan, lhuwcha tala'cha'ampalh. Wa an ixkilhtucha lakxkani ixyalh yucha. ");
INSERT INTO tpp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Walh la'cha'alh pumatam lapanak yu ixjunkan Jairo, yu ixla'ts'ilhi'an laka cha'a tan ixtata'ayxt'o'a an judiojnin, tatso'ottanilhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sawalhcha tapayniniy, juniy: ―An kintsi nit'ajuncha. Ak'int'ap'it'i. K'alakp'ach'ap'aya'a para li kata'oxilh chi kala'awcho'olh. ");
INSERT INTO tpp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pus an Jesús t'a'alh. Lhilhuwi ixch'a'o'akanta, wa ixtapa'asicho'oycha. ");
INSERT INTO tpp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pumatam t'aku la'akawt'uycha k'ata ixta'an'ay, wa ixmaj'an ixjak'alhni. ");
INSERT INTO tpp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jantu layi ixta'oxiy masi ix'ancha laka jak'uch'unun, apalijcha wa ixlita'o'slay, chi ixmakamin'ojotacha ixtumin. ");
INSERT INTO tpp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Akxni asmatlhi li tanchuncha t'ajun an Jesús, ch'a'o'ayawlh, japujatanulhi an lapanakni chi ch'apanichalhi an ixla'ch'it. ");
INSERT INTO tpp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mu ixnajun: “Masi wa akch'apanichalh an ixla'ch'it, aktak'uch'uya'.” ");
INSERT INTO tpp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Walh watukan sa' aninilhi an ixjak'alhni, oxicha lakak'atsancho'olh li ta'oxilhcha tacha an ixma'alh'ajnajt'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Xli'astan an Jesús mu k'atsayi li xamati k'uch'ulh, tala'asp'itlhi, jajuniy: ―¿Tisiyuchacha kinch'apanichalh an kila'ch'it? ");
INSERT INTO tpp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","An ixt'alhtanan tajuniy: ―Pero sawalhcha tapa'asiyan ch'i lhasakminini tichini aych'apacha'ancha. ");
INSERT INTO tpp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero yucha sa'cha jalakawanani tichini yuchacha kawalh. ");
INSERT INTO tpp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pus an t'aku xk'ip'ip'icha lay talhanancha, mu k'atsaycha tacha tapasalh, pus la'alh, tatso'ottanilhi an Jesús, chi jun'olh. ");
INSERT INTO tpp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","An Jesús juniy: ―Amijakiklaka'inti p'ut'ak'uch'ut'icha, kintsi'. Lhi'ach'ach'a k'ap'inch'o'ochi', mu t'ak'uch'ut'icha. ");
INSERT INTO tpp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Walh ixchiwint'ajunka an Jesús, tacha'alhcha yu taminchalh la ixcha'a an yu ixla'ts'ilhi'an laka cha'a tan ixtata'ayxt'o'a an judiojnin, tajuniy: ―Amintsi nilhcha, jant'uch'a ali k'ama'ach'ap'u an Maestro. ");
INSERT INTO tpp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Walh mu asmat'a an Jesús, pus juniy an yu ixla'ts'ilhi'an laka cha'a yu ixputa'ayxto'kan: ―Jant'u k'at'alhan. Wa k'ajak'iklaka'incha. ");
INSERT INTO tpp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Chi jantu xamati makawnilh li kat'a'alh an Jesús, wa yucha an Pedro chi Jacobo chi Juan ixt'ala'ajuncha an Jacobo. ");
INSERT INTO tpp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta'alhcha la ixcha'a an yu ixla'ts'ilhi'an laka cha'a tan ixtata'ayxt'o'a an judiojnin. An Jesús jala'ts'incha tacha sawalhcha tala'ta'oxila'alhiy chi wa tilh tilhcha ixtalay chi ixtalaj'alhuncha. ");
INSERT INTO tpp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pus jala'tanuchalh an Jesús, jajuniy: ―¿T'asu li wa t'ilh tilhch'a layat'iti ch'i laj'alhunatcha? An jatsi jantu nita, wa lhtatay. ");
INSERT INTO tpp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero yu'uncha wa ixtalhits'i'in. Pus jatamakxtu'olh, wa yucha an ixpay chi an ixnati jatsi chi an yu ixtat'a'anta an Jesusi tat'atanulh an tan ixmalh an jatsi'. ");
INSERT INTO tpp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma'ch'apachalhi an jatsi an Jesús, juniy: ―Talita, kumi ―yucha nawputun: Jatsi', uxint'i ijkunan, ¡k'a'ost'aycha! ");
INSERT INTO tpp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Watukan ostayalhi an jatsi, tsukulhcha jalhtanan. Mu la'akawt'uycha k'ata ixpakxanta. Chi sawalhcha ixtalhi'a'niya an lapanakni an yu tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wachuncha jajuniy an Jesús li jantu xamati katajunilh tacha an tala'ts'ilh, chi lhinawlhcha li kamawakalhcha an jatsi'. ");
INSERT INTO tpp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Taxtulh an Jesús, jat'amilhcha la ixt'un an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Walh, akxni jantu tapatsakan wilhchan, tsukulhcha masuyi an laka tajtan. Lhuwi yu sawalhcha ixtalhi'a'niy. Ixtanajun: ―¿Tani laklanilhcha an jatapast'ak'at chi tacha an jak'uch'ununcha la ixmaka'a? ¿Tisu jatapast'ak'atcha ani xta'nikanta? ");
INSERT INTO tpp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pero mu yucha an jaxpitni', an ists'alh María, an ixt'ala'ajunk'an Jacobo chi José chi Judas chi Simón chi an ixjap'isa'an wachu aniya tawilanalh. Tucha oxi ixtalhiwilay an Jesús an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pus an Jesús jajuniy: ―Jantu xamati yu lhichiwiniy ixchiwinti Dios la'ts'imputunkan la ixt'un chi la ixt'alalhila'ts'inin chi la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pus jantu tu'u lay ilhtulh ancha tu'u yu laj'ay tanlhun an Jesús, yu masuy ix'alhp'asninti an Dios, wa ali'in ta'an'anini jak'uch'ulh yu jalakpach'apalh. ");
INSERT INTO tpp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Wachuncha sawalhcha lhi'a'niya an Jesús li jantu k'is tajakiklaka'inini yu'uncha. Ix'ancha masunu an lakt'ikt'i la'acha'anaxni. ");
INSERT INTO tpp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jat'asanilhcha an ixpumakawt'uyk'an ixt'alhtanan an Jesús, chi tsukulhcha jamala'pitsiy ixpumat'uyunk'an. Ja'ilhtulhcha li layi katalhajaya an tanlhuncha lakmakxkay'un. ");
INSERT INTO tpp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jajuniy li jantu tu'u katalhi'alh, ixnik'an, chi ixbolsajk'an chi tumin, wa ma'atamin ixpalikk'an, ");
INSERT INTO tpp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","chi ixwarachijk'an, pero alht'uy ixla'ch'itk'an jantu. ");
INSERT INTO tpp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jajuniy: ―Wa t'anch'unch'a k'ach'ip'ina'it laka cha'a wa anch'ach'a k'at'awla'it, sta akxni k'at'axt'uch'o'oya'it an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Chi wa t'anch'unch'a jant'u la'a'ik'anat, u jant'u asmatnik'anat, akxni t'axt'uch'o'oyatcha, k'ach'ank'alhap'uxk'ana'it'iti an po'xmi para li katak'atsaalh, mu yu chuncha talay jantu ta'asmatputun, palay katama'alh'ajnana akxni ka'ukla'oya', walh masi an la'acha'an Sodoma chi an la'acha'an Gomorra palay wa ixlak'anti katama'alh'ajnana'. ");
INSERT INTO tpp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pus tataxtunilhcha, ixtanajuncha li katamapaxalhcha ixjatapast'ak'atk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ixluwchak'ani tak'uch'ulh yu wa ixtala'apaxt'o'a makxkay'un, chi ixluchak'ani yu ixta'ukmuk'aycha asayte yu wa ixtata'an'ay, chi ixtatak'uch'uycha. ");
INSERT INTO tpp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","An rey Herodes k'atsaalhi li an Jesús sawalhcha ixmispakan. Ixtalaknajun yucha an ixjama'paxanancha Juani la'awcho'olh xliyu lay lhilak'ilhtuy masi yu la'lhima'anxkay laj'ay tanlhun, yu masuy ix'alhp'asninti an Dios. ");
INSERT INTO tpp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","An ali'in ixtanajun: ―Yucha an Elías. Chi an ali'in ixtanajun: ―Ka xamaticha yu wachu chun tacha an yu ixtalhichiwiniy ixchiwinti Dios ma'anchacha. ");
INSERT INTO tpp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Akxni asmatlhi an Herodes, najun: ―Yucha an Juancha la'awcho'olh an yu iklhinawlh li ka'a'cha'xkalh. ");
INSERT INTO tpp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mu yucha an Herodesi ixmalaklhchajuta an Juan, xliyu chuncha lhinajun, ixch'i'ulatacha laka kadena, wa xliyu li an Herodes ixt'at'awniya an ixt'iwi wa ixt'ala'ajuncha, junkan Felipe, an ixjamach'a Felipe ixjunkan Herodías. ");
INSERT INTO tpp_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chi mu an Juan ixjuniya an Herodes: ―Jantu oxi li t'ats'uk'uniy an ixt'iwi mint'ala'ajun Felipe. ");
INSERT INTO tpp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pus xliyu an t'aku Herodías sawalhcha ixma'niputuni an Juan, pero jantu lay ixma'niy. ");
INSERT INTO tpp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mu an Herodes ixtalhamniya an Juan, mu ixk'atsayi li yucha oxi ixt'ajun, yucha jantu ix'ilhtuyi ixtala'alhin, pus an Herodes oxi ixlist'ak'a an Juan. Sawalhcha ix'alha'asmatputuni an Herodes an Juan, pero jantu oxi ixlimacha'xay. ");
INSERT INTO tpp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Milh la'atam wilhchan akxni la'tsapalhcha k'ata an Herodes tacha ixput'ajun, jat'awaylh an ix'a'tayjunin chi an xalaj'ajin lapanakni xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pus an istsi an t'aku Herodías tanuchalh chi jat'ínilhcha. Walh an Herodes oxicha lhiwilalh chi an yu ixjat'alakwajin wachu', pus an Herodes juniy an jatsi: ―Wa t'uch'ich'a k'isk'inip'ut'un, ak'isk'inincha. ");
INSERT INTO tpp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Chi jurarlanilhcha, juniy: ―Akxta'niyani wat'uch'ich'a ak'isk'iniya'a, sta paytat an kilhich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pus an jatsi taxtulh chi juniy an ixnati: ―¿Tisuncha aksk'inilh? An ixnati an jatsi juniy an istsi: ―Yucha an ix'a'tsulh jama'paxanaj Juani k'ask'int'i. ");
INSERT INTO tpp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","So'ojo tanucho'ochalh an jatsi, juniycha an rey: ―Yucha an ix'a'tsulh jama'paxanaj Juani ak'ixt'a'nin laka la'atam pulatoj. ");
INSERT INTO tpp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pus an rey sawalhcha ta'oxila'alhilh, pero mu ixjunitacha li kaxta'niya sawalhi watuchicha kask'iniya an jatsi, chi ixta'alha'asmat'ojotacha ixchuxk'an, pus jantucha ta laputulh. ");
INSERT INTO tpp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Watukancha mak'alhi pumatam isoldado, juniy li kalhiminilhi an ix'a'tsulh jama'paxanaj Juan. Pus chunchacha ilhtulh an soldado. Ki'a'cha'xlicha an Juan an laka pulach'in. ");
INSERT INTO tpp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Chi lhicha'alhcha an a'tsulh laka pulatoj an soldado, pus xta'nilhcha an jatsi', chi an jatsi yucha xta'nilhcha an ixnati. ");
INSERT INTO tpp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Akxni tak'atsaalhcha an ixt'alhtanan an Juan, taki'inilhi an ixlakatunaj, chi tamaknulhcha. ");
INSERT INTO tpp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","An ixt'alhtanan Jesús tat'atala'xto'lhicha chi tajuniycha tuchini ta'ilhtulhcha chi tuchini tamasulhcha. ");
INSERT INTO tpp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yucha jajuniy: ―K'at'at'itcha, katala'xtinuw, tan wa jasa'nik'acha k'at'ijast'aknana'it. Mu lhuwi yu ixtacha'an chi yu ixtatasp'itcho'oyachalhcha, pus jantucha layi masi wa katitawaylhcha. ");
INSERT INTO tpp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tapu'alhcha la'atam barco tan wa jasa'nik'a. ");
INSERT INTO tpp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero mu ixluwk'ani yu tala'ts'ilh tan tapu'alh. Pus tamispalhi an Jesús, wachuncha chux an la'acha'anaxni an lapanakni tataxtulh talakats'alaj'alh, yu'uncha p'ulh tacha'alh. ");
INSERT INTO tpp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Akxni tatakutlhicha an laka barco, an Jesús jala'tsincha tan ts'anan ixtayanalh, pus jamapayniycha, mu wa tacha borregojnincha yu jantu xamati jalhist'ak'a. Pus tsukulhcha jamasuniy lhuw tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sawalhcha ta'oxay, an ixt'alhtanan an Jesús tala'alh, tajuniy: ―Sawalhcha ta'oxay, chi ani wa jasa'nik'a. ");
INSERT INTO tpp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","K'aja'un li kata'alhcha an lakt'ikt'i la'acha'anaxni, katatamawyacha ancha yu kata'uya'. ");
INSERT INTO tpp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yucha ja'alhtaylh, jajuniy: ―K'ajamawatcha uxitnan. Yu'uncha tajuniy: ―¿Tasicha? Ka wanajcha la'lhuwi ajkalhimawaw pan ixchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Pus jajuniy: ―¿Tasu a'xchuxcha pani lhit'ant'at'it? Ak'ila'ts'int'it. Akxni tala'cha'ancho'olh, tajuniy: ―A'xkisi pan chi ma'at'uy jatanti. ");
INSERT INTO tpp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ixchuxk'an jajuniy li katatala'apitsilhcha kilhmaktamin, chi li katalaktawilhcha an tan st'a'an malh jats'in. ");
INSERT INTO tpp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pus talaktawilhcha, kilhmaktamin taminciento chi kilhmaktamin t'up'uxamkawin. ");
INSERT INTO tpp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yucha xa'a'ilhcha an a'xkisi pan chi an ma'at'uy jatanti chi tala'st'alhcha an lakt'iyan, xta'nilhcha lhimala'puchajuni an Dios. La'ch'e'elhcha an pan chi jaxta'nilhcha an ixt'alhtanan para li katamala'pitsilhcha, chi an jatanti wanajcha chun. ");
INSERT INTO tpp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ixchuxchak'ani oxi talak'ulh tacha talhikiklalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","La'akawt'uy kanastaja a'tsamcho'olh yu wa xaxajnicha an pan chi an jatanti, yu jantucha ta'u'olh. ");
INSERT INTO tpp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","La'akisi milh lapanakni yu an talakwaylh. ");
INSERT INTO tpp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ixli'astan an Jesús jajuniy an ixt'alhtanan li katapu'alhcha an ixtapiktutam lakxkan an barco, tanchun la'acha'an junkan Betsaida, mu yucha ma katijala'axa'alaya an lapanakni para li kata'ancho'oyacha. ");
INSERT INTO tpp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jala'axa'ala'olh, alhcha tapayninini Dios a'stitawk'a. ");
INSERT INTO tpp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Walh puts'istacha, ixpaytatcha an lakxkani ix'anta an barco. Wa ix'akstucha ixt'awnachalh an Jesús lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chi mu jala'ts'incha tacha lhita'ayj talay tax'elhniy an barco an ixt'alhtanan, mu an un wa ixjalakatast'uka, pus ka tacha las trescha tunkunmintacha jala'alhcha. Ukxjalhtanaj'alhcha an xkan, ixjapu'iniputuncha ixja'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Akxni tala'ts'ilh li ukxjalhtanani an lakxkan, tanajun li sna wa takuwincha, ixtalakt'asaycha. ");
INSERT INTO tpp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mu ixchuxchak'ani ixtala'ts'in ixtalaktalhanancha, pero yucha watukan jaxa'alalh, jajuniy: ―¡Oximaj'ayi k'a'unt'it, jant'u k'alakt'alhanant'it, mu kit'in! ");
INSERT INTO tpp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jala'tajuchalh an laka barco an Jesús, sa'cha walhi an un, pus sawalhcha ixtalhi'a'niy, ");
INSERT INTO tpp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mu wachuka jantuka' ixtalhimacha'xapalayi an tan ixlalhawata pan, mu jantu ixtakiklaka'iya li layi ka'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Akxni tapatakutchalhcha an lakxkan, tacha'alhcha xalakaat'un Genesaret. ");
INSERT INTO tpp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","An Jesús watukan tamispalhi akxni tatakutlhicha an laka barco. ");
INSERT INTO tpp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pus watukan tata'a'pitsi'olhi an lapanakni, ta'alhcha lak'iynini an ta'an'anin, chi talakch'ixlicha'a'nilhcha la ixputamatk'an an ta'an'anin an Jesús, tan an ixtak'atsay li ancha ixt'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Watanchuncha ixcha'an an Jesús, laj'ay la'acha'anaxni, chi lakt'ikt'i la'acha'anaxni, u masi tan wa jalhi'ay, an laka laktij ixtamamaycha an yu wa ixtata'an'ay chi ixtatapayniniycha li ma kajamakawnilhi masi wa katapikch'apanichalhcha an ixla'ch'it. Ixchuxk'an an yu ixtach'apaniyachalh an ixla'ch'it, ixtatak'uch'uycha. ");
INSERT INTO tpp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","An fariseojnin chi ali'in xamaestrojnin lhamap'a'sin, yu ixtamintachalh la'acha'an Jerusalén, tala'cha'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Walh tala'ts'ilhi li an ali'in ixt'alhtanan an Jesús jantu ixtama'ch'a'ayi ixtalakwajin, pus yu'uncha tanajun li jantu oxi chuncha. ");
INSERT INTO tpp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Mu yu'uncha chi an judiojnin jantu ixtawajini li jantu ixtala'ma'ch'a'ay, tacha ixtanajun an laktatanin. ");
INSERT INTO tpp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Li ixtakitasp'it'acha tiankis, yu'uncha ixtala'ma'ch'a'apalaycha akxni tu'u kata'uya'. Atumpaj yu wachu sawalhcha ixtalhismanita ixta'ilhtuy, li ixtala'ch'a'ay an vaso, chi jarro, chi yu de tsasnat pala'oxin chi putamat.) ");
INSERT INTO tpp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pus talhisakmiycha an Jesús an fariseojnin chi an xamaestrojnin lhamap'a'sin, tajuniy: ―¿Tasu li amint'alhtanan jantu ta'ilhtuyi tacha an tanajun an laktatanincha? ¿Tawajini masi jantu tala'ma'ch'a'ayi? ");
INSERT INTO tpp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yucha jajuniy: ―¡Uxitnan wa layat'itcha! Ts'ajwi talhichiwinin an Isaías, an tan ts'o'muk'akanta la ixchiwinti Dios, tan najunta: Ani lapanakni oxi kintalhichiwiniy, pero la ixjalhunutk'an jantu ixlisawalh. ");
INSERT INTO tpp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wa la'a'ijcha oxi kintalhipast'ak'a, mu yu'uncha tamasuyi yu wa ixjatapast'ak'atchak'an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tamakajuni an ixlamap'a'sin Dios, wa yucha an ixjatapast'ak'atchak'an lapanakni p'as tach'a'o'ay: an ixla'ch'a'aka vaso, chi jarro, chi tanlhuncha ali yu wanajcha chun. ");
INSERT INTO tpp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jajumpalay: ―An ixlamap'a'sin Dios lhimap'axayatcha wa milhamap'a'sinchak'an. ");
INSERT INTO tpp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","An Moisés nawlh: “K'a'asmatnini yu junan minpay chi minati”, chi nawpalay: “Yu xkayaj juniya ixpay chi ixnati kaniya'”. ");
INSERT INTO tpp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Walh uxitnan nawnat'iti li jantu tani lay masi jantu kata'a'tayjulh ixlakpaynink'an an lapanakni, yu tama'lhtask'iniy la'a'tayjun. Mu li yu ixtaxta'nilh ixlakpaynink'an wa Korbán (nawputun xta'ni'okantacha Dios). ");
INSERT INTO tpp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jant'uch'a jamak'awniyat'iti li kata'a'tayjulh ixlakpaynink'an. ");
INSERT INTO tpp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","An ixchiwinti Dios lhimap'axayatcha an wa mijatapast'ak'atchak'an, lhuwi yu ch'unch'a ilht'uyat'it. ");
INSERT INTO tpp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wachuncha jat'asani'olhi an Jesús an lapanakni, chi jajuniy: ―Akila'asmatniw chi k'alhimach'a'xat'it minchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jantu yu an yu ukani lhkilikiy an lapanak. Yu kalhkilikin yucha an tacha kilhtaxtukan chiwinti.  ");
INSERT INTO tpp_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Li xamati lhit'ajun ixpa'asmatna, ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tala'xtinulhcha an tan ts'anaks ixlakyakalh tanulhcha laka cha'a', pus an ixt'alhtanan talhisakmiycha tuchini nawputuncha. ");
INSERT INTO tpp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yucha jajuniy: ―¿Wach'u jant'u lhimach'a'xayat'it? ¿Jant'u k'ats'ayat'iti li chux an yu uy an lapanak jantu layi katimama'lhta'alhinilhcha? ");
INSERT INTO tpp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mu jantu li sna la ixjalhunuti tanuy, la ixpalakni tanuy, chi ixli'astan maj'ancho'oycha. Yucha nawputulh an Jesús li chux an yu ukan si laj'oxi. ");
INSERT INTO tpp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wachu jajumpalay: ―Yucha an ixchiwinti an lapanakcha yu mama'lhta'alhiniy. ");
INSERT INTO tpp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mu la ixpulakni an ixjalhunutk'an lapanakni taxtuy an lakmakxkay jatapast'ak'at: chi yu talat'atamay yu jantu talat'at'ajun, yu wa aya talay, yu jama'ninin, ");
INSERT INTO tpp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yu ja'alhawanan, yu sawalhcha a'sputni, yu jalhitama'chapunun, yu ja'o'xcho'onun, yu ayajk'atsay, yu xkayaj najun, yu lhita'ayay tu'u, chi yu jantu ja'asmatnan. ");
INSERT INTO tpp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chux ani yu jantu laj'oxi tanlhun ixpulakni an jalhunuti minachalh, yucha yu mama'lhta'alhiniy an lapanak. ");
INSERT INTO tpp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","An Jesús taxtuchalhcha Galilea alhcha xalakaat'un Tiro chi xalakaat'un Sidón. Tanuchalhcha lakatam laka cha'a'. Jantu ixlakask'in li xamati kala'ts'ilh, pero jantu lay tats'e'lhi. ");
INSERT INTO tpp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mu tichi t'aku ixlit'ajun istsi, wa ixlakpach'apata makxkay'un. K'atsaalhi li ancha t'ajun an Jesús, pus la'cha'alh chi tatso'ottatawlhnilhcha la ixjach'aja'. ");
INSERT INTO tpp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tapayniniycha li kak'uch'unilhi an istsi'. An t'aku lhigriegojo ixchiwiniy chi jamacha'a Sirofenicia. ");
INSERT INTO tpp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","An Jesús juniy: ―Kachajcha p'ulhnaj tita'o'atsalh an jas'at'an, mu jantu oxi xajachalh li ajkama'osunilhcha yu ta'ut'ajun chi ajkamaka'anilhcha an x'oyun. ");
INSERT INTO tpp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pus an t'aku juniy: ―Chuni, Jamach'alhkat, pero an x'oyun ta'usak'a masi wa ixtach'e'echak'an an jas'at'an an ixtan'api mesa. ");
INSERT INTO tpp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pus akxni juniy an Jesús an t'aku: ―T'ach'a an na'un chunchacha sawalh, chaway k'ap'inch'icha, an makxkay'un makawlhcha amintsi'. ");
INSERT INTO tpp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Akxni cha'ancho'olhcha la ixcha'a an t'aku, an makxkay'un jantucha tu'u ixlakpach'apata an istsi', chi sa'cha ixmalhi an la ixputamat. ");
INSERT INTO tpp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taxtucho'ochalhcha xalakaat'un Tiro an Jesús, la'puslicha xalakaat'un Sidón, chi pula'pus'alhcha xalakaat'un Decápolis, chi cha'alhcha la xalakxkan Galilea. ");
INSERT INTO tpp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Talhicha'anilh pumatam lapanak yu jantu lay ixja'asmatnan chi jantu lay oxi ixchiwiniy. Tatapayniniycha an Jesús li kak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Mu lhilhuw, pus mala'xtinulh, tan wa ix'akstucha lhi'alh, lak'akatutamaknulhcha chi lhilakapuch'apanilhcha ixchuj'uti an isima'at. ");
INSERT INTO tpp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chi tala'st'alhcha an Jesús an lakt'iyan, jama'aninilh, najun: ―¡Efata! ―nawputun: ¡K'alakt'a'a'at'umix'at'icha! ");
INSERT INTO tpp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Walh watukan la'ta'a'atumix'alh chi ta'oxinilhcha an isima'at, oxicha chiwinilh. ");
INSERT INTO tpp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","―Jant'u xamat'i k'a'unit'it ―jajuniy an Jesús. Pero masi li chuncha ixjajuniy palay ixtalaknajun. ");
INSERT INTO tpp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Chi sawalhcha ixtalhi'a'niy, ixtalaknajun: ―Sawalh oxi tacha an ilhtulh, layi jak'uch'uy masi an yu wa laj'a'atapan chi an yu jantu lay tachiwiniy. ");
INSERT INTO tpp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","La'atam wilhchan wanajcha lhilhuwi ixjumpalhkanta, walh jantu tu'u yu kati'ukalh, pus an Jesús jajuniy an ixt'alhtanan: ");
INSERT INTO tpp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Ijkamapayniya ani lapanakni, mu la'at'utucha wilhchani kintala'chinta chi jantu tu'u yu katita'ulh, ");
INSERT INTO tpp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","li wachunchacha ajkamala'achacho'oya ixcha'ak'an katala'awitijtayaya laka tij, mu ali'in ma'ati tamintachalh. ");
INSERT INTO tpp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","An ixt'alhtanan an Jesús tajuniy: ―¿Pero tanischa lay xamati kaja'inilh pan ani li jantu xamati wilhi? ");
INSERT INTO tpp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pus an Jesús jajuniy: ―¿Tasu a'xchuxcha pani lhit'ant'at'it? Yu'uncha tajuniy: ―A'xtujun. ");
INSERT INTO tpp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pus wachuncha an Jesús jajuniy tacha an ts'anaks ixta'ayxto'nun li katalaktawilhka an lakaat'un, chi yucha xa'a'ilhcha an a'xtujun pan, chi xta'nilhcha lhimala'puchajuni an Dios chi la'ch'e'elhcha, xli'astan jaxta'nilhcha an ixt'alhtanan, chi yu'uncha tamala'pitsilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wachu ixtalhi'anta lakats'uniy lakt'ikt'i jatanti, an Jesús wachu lhixta'palh lhimala'puchajun chi jamamala'pitsinilhcha wachu an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ixchuxchak'ani talak'ulh chi talhikiklalhcha. Ixli'astan la'atujun kanastaja tapusakcho'olh yu wa lakt'ikt'icha xaxajni. ");
INSERT INTO tpp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","An yu talakwaylh lapanakni ka tacha la'at'at'i milh. Xli'astan an Jesús jala'axa'alalhcha an lapanakni chi talak'ancho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chi an Jesús jat'atajulhcha laka barco an ixt'alhtanan, ta'alhcha xalakaat'un Dalmanuta. ");
INSERT INTO tpp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tala'cha'alh an fariseojnin an Jesús, tsukulhcha tat'alakikxtukuy, tajuniy ma kajamasunilh tu'u an lakt'iyan para li ma katakiklaka'ilh. ");
INSERT INTO tpp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pus an Jesús jama'aninilh la ixta'oxila'alhit, najun: ―¿Tasu li talakask'incha kajamasunikalh tu'u ani lapanakni? Chaway sawalh klajunaw jantu tu'u katijamasunikalh an yu chaway tat'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pus tajupalhi an laka barco an Jesús, jamakawyawlhcha. An ixtapiktutamcha lakxkani alh. ");
INSERT INTO tpp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Walh takaplhi li katalhi'alh pan, wa a'xtam pani ixtalhi'anta an laka barco. ");
INSERT INTO tpp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Chi jajuniy an ixt'alhtanan an Jesús: ―K'ajalajk'ats'anant'iti li jantu katamatsaman an ixlamaskajank'an an fariseojnin chi an ixlamaskajan Herodes. ");
INSERT INTO tpp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pus yu'uncha ixtalalhisakmipaxaycha li sna xliyu li jantu tu'u ixtalhi'anta pan. ");
INSERT INTO tpp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Chi mu jalhimacha'xaniycha an Jesús, pus jajuniy: ―¿Xliyu li jant'u lhit'ant'at pani lhilakch'iwininat'it? ¿Ch'unt'u lhimach'a'xayat'it, sawalhka lakt'ak'alha mijalhunutk'an? ");
INSERT INTO tpp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Masi li lhit'awnat'iti mi la'chulhk'an, ¿jant'u jalak'awananat'it? Chi masi li lhit'awnat'iti mi a'ax'olhk'an, ¿jant'u ja'asmatnanat'it? ¿Jant'u p'ast'ak'at'iti ");
INSERT INTO tpp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","akxni an kla'puch'e'elh a'xkisi pan, chi ijkamawalh la'akisi milh lapanakni? ¿Tasu la'achuxcha kanastaja a'tsamcho'olh an xaxajni yu p'usakch'o'ot'iti? ―La'akawt'uy canasta, ―tajuniy. ");
INSERT INTO tpp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Chi akxni ijkamawalh a'xtujun pan la'at'at'i milh lapanakni, ¿tasu la'achuxcha canastaja a'tsamcho'olh an xaxajni yu p'usakch'o'ot'iti? ―La'atujun canasta, ―tajuniy. ");
INSERT INTO tpp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Pus an Jesús jajuniy: ―¿Ch'i t'asuch'a li jant'uch'a lay lhimach'a'xayat'iti? ");
INSERT INTO tpp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tacha'alhcha la'acha'an Betsaida an Jesús, walh talhicha'anilh pumatam la'lhtuluw lapanak. Tatapayniniycha li kalakpach'apalh. ");
INSERT INTO tpp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pus an Jesús ma'ch'apachalhi an yu wa la'lhtuluw, mala'xtinulhcha an la'acha'an. La'puchujwalhcha chi lakpuch'apalhcha, xli'astan lhisakmiycha li laycha tu'u la'ts'in. ");
INSERT INTO tpp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yucha jalakawanalh, najun: ―Wa tacha wa k'iwi ijkala'ts'in an lapanakni, pero talakjalhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pus a'tam lakpuch'apapalhi an Jesús, oxicha malakawanilh, tala'pu'oxilhcha, ma'atcha ixlakacha'an chi oxicha ixjala'ts'in'ojoy. ");
INSERT INTO tpp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Walh mala'achalhcha ixcha'a juniy: ―Jant'u k'ap'it'i an la'acha'an ch'i jant'u xamat'i ka'un. ");
INSERT INTO tpp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","An Jesús chi an ixt'alhtanan ta'alhcha an lakt'ikt'i la'acha'anaxni lhila'acha'an Cesarea de Filipo. Walh laka tijcha jalhisakmiycha an ixt'alhtanan an Jesús, jajuniy: ―¿An lapanakni tisi kit'incha tanajuni? ");
INSERT INTO tpp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yu'uncha ta'alhtaylh, tajuniy: ―Ali'in tanajun ma jama'paxanaj Juank'at'i, ali'in ma Eliask'at'i, chi ali'in tanajun ma xamaticha yu wachu lhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wa chuncha yucha jajuniy: ―¿Chi uxitnan, tisi kit'inch'a nawnat'iti? An Pedro alhtaylh, juniy: ―Uxint'i Cristojk'at'i. ");
INSERT INTO tpp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pus an Jesús jajuniy: ―Jant'u xamat'i k'a'unit'it. ");
INSERT INTO tpp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tsukulhcha jajuniya li an isTs'alh Lapanak kastak ma'alh'ajnana'. Li jantu katitala'ts'imputulhi an laktatanin, chi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin. Jajunilhi li katama'niya', pero li ixlila'at'utu wilhchan kala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ts'ajwi ixjajuniy. Walh an Pedro aylhi'alh tan wa ix'akstu an Jesús, chi tsukulhcha juniya li jantu chuni kanawlh. ");
INSERT INTO tpp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero an Jesús tala'asp'itlhi chi sa'cha jala'ts'ini an ali'in ixt'alhtanan, pus la'a'aymalhcha an Pedro, junkan an Pedro: ―¡K'a'ost'i la ki'ukxlakapu'u Satanás!, mu uxint'i jant'u lhak'ap'up'ini yu ix'anu Dios wa yucha an ixjatapast'ak'atk'an lapanakni lhak'ap'up'in. ");
INSERT INTO tpp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wachuncha an Jesús, jaxa'alalhi an lapanakni chi an ixt'alhtanan, chi jajuniy: ―Li xamati kint'alhtana jumputun, kamakawlhcha yu wa ixjatapast'ak'atcha, kaxa'a'ilhcha ixcruz yu lay kapuma'nikalh chi akinch'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mu yu kama'alhtaxtuputuna ixjatsukunti, kama'ats'an'aya', pero yu kama'ats'an'aya ixjatsukunti kilakata chi ixlakata an ixchiwinti Dios, kama'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jantu tani lhila'an masi wanajcha amaj ix'anu kajun'olh an lapanak an lakamunulhpa', li kama'ats'an'alh an ixjatsukunti. ");
INSERT INTO tpp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Tasucha lay kalhila'cha'ancho'oya ixjatsukunti? ");
INSERT INTO tpp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ani lapanakni yu chaway tat'ajun ta'ilhtuyi ixtala'alhink'an chi jantu ta'ilhtuyi yu sawalh. Yu kint'amaxanani kit'in chi an kinchiwinti, kit'in isTs'alh Lapanak wachu akt'amaxanana akxni akmina la ix'alhp'asninti an kimPay ali an ix'angelhnin yu la'stalan'an. ");
INSERT INTO tpp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jajumpalay: ―Sawalhi ani yu klajunaw, ali'in yu ani tat'ajun jantu katitanilh, sta akxni katala'ts'inacha kamina alhp'as an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ixlila'achaxancha wilhchan la'pusli, an Jesús jalhi'alhcha an Pedro chi an Jacobo chi an Juan wa ix'akstuk'an tanchun talhman a'stitawk'a. Chi la ixjalakawantichak'an tapaxalhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","An ixla'ch'it xlimjcha walh, wa lhi'o'slaycha sut'ut'u walh, tacha yu jantu lay tu'u chuncha kamasut'ut'ulh xamati masi wa stakcha kama'pajlhi an la'ch'it. ");
INSERT INTO tpp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chi tatalakasulhcha an Elías ali an Moisés, ixtat'achiwiniycha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pus an Pedro juniy an Jesús: ―Maestro, oxi li ani ikt'awnaw, akla'oxiyaw a'at'utu de jach'itin cha'a', a'atam mi anucha, a'atam ix'anucha an Moisés chi a'atam ix'anucha an Elías. ");
INSERT INTO tpp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jantucha ixk'atsay tani kanawlhcha an Pedro, mu ixtalaktalhanancha. ");
INSERT INTO tpp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wa akxni ta'alhtajulh la'atam jataputs'i jala'atanchanulhcha, chi chiwinkalhcha an laka jataputs'i nawkan: ―Yucha aniya yu ikmapayniy kinTs'alh, yuch'a k'a'asmatnit'it. ");
INSERT INTO tpp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Xli'astan akxni tajalaklakawanancho'olh jantucha xamati ali tala'ts'ilh, wa yucha an Jesuscha. ");
INSERT INTO tpp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tata'alhtajucho'olhcha an a'stitawk'a, an Jesús jajuniy li jantu xamati katajunilh tacha an tala'ts'ilh. Jajuniy li katalaknawnaka sta akxni kala'awcho'oya an Jesús an yu walh isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pus wa sa'cha tak'atsalh. Wa yu'unchacha ixtalalhisakmipaxay tuchini jumputuncha li kala'awcho'oya an laka lhinin. ");
INSERT INTO tpp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tsukulhcha talhisakmiya an Jesús, tajuniy: ―¿Tasu li tanajun an xamaestrojnin lhamap'a'sin li task'iniya li p'ulhnaja kamilh an Eliasi? ");
INSERT INTO tpp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","An Jesús yucha jajuniy: ―An Elías p'ulhnaja kamina sawalh, kamina lats'awalana chux an tanlhun. ¿Chi k'ats'ayat'iti tacha kilhits'o'muk'akanta kit'in yu ikwalh wa tacha isTs'alh Lapanak, li akstak mina ma'alh'ajna chi jantu tu'u akintitalhiwilalh? ");
INSERT INTO tpp_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero kit'in klajunaw an Elías kilachilhcha, chi wa tani ta'ilhtuputulhcha ta'ilhtulhcha, tacha an lhits'o'muk'akanta la ixchiwinti Dios li kaputapasaya'. ");
INSERT INTO tpp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Akxni jala'cha'ancho'olhcha an ali'in ixt'alhtanan an Jesús, jala'ts'incha tacha ts'anan ixja'a'yakalh, chi ixjat'alakikxtukut'awkancha yu'uncha an xamaestrojnin lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chi an lapanakni talhi'a'niycha li cha'alhcha an Jesús, pus tala'ats'alaj'alhcha chi ixtala'axa'alaycha. ");
INSERT INTO tpp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yucha jalhisakmilh jajuniy: ―¿T'isunch'a lalhik'ikxt'uk'uyat'iti? ");
INSERT INTO tpp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pus pumatam najun an tan ts'anan ixlakyakalh: ―Maestro, wa iklhiminitan an kints'alh wa lakpach'apata makxkay'un, jantucha makawniya kachiwinilh. ");
INSERT INTO tpp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wa tanchuncha putawlachilh ma'taycha, xut'ut'ucha ma'pupuy chi wa xwat'at'acha tasat'ajun, wa k'alijicha junt'ajun, chi ijkajuniycha a mint'alhtanan li katak'uch'ulhka', pero jantu lay tak'uch'uy. ");
INSERT INTO tpp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Pus an Jesús jajuniy an ixt'alhtanan: ―¡Yu chaway ani t'awnat jant'u jak'iklak'a'ininat'it! ¿Tasu wanancha wa aktilat'a'aklatsukuyaw chi wa aktilalhilhitayaniyawi? Akilalhiminiw. ");
INSERT INTO tpp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pus talhi'anilhcha an ts'alh an Jesús. Walh akxni an makxkay'un la'ts'ilhcha an Jesús, ma'tapalhcha an ts'alh, p'ascha ixlakchikixa chi ixma'atamp'iliycha, chi ixma'pupuycha. ");
INSERT INTO tpp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","An Jesús lhisakmiycha an ixpay an ts'alh tani ixlima'ancha chuncha lay, yucha najun: ―Wa ixtajas'at'at, ");
INSERT INTO tpp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","a'lhuwcha ma'niputun ma'tay laka jikmi chi lakxkan. Li sna layi k'ak'uchut'i lamapaynin akilalhi'a'tayjuka'. ");
INSERT INTO tpp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","An Jesús juniy: ―¿Sna layi ajk'uch'ulh? Watuchicha layi li k'iklak'a'iy. ");
INSERT INTO tpp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pus watukan najuni an ixpay an ts'alh: ―Chun, ijkiklaka'iy, pero ak'ila'alhp'asninini an kijakiklaka'inti. ");
INSERT INTO tpp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chi mu la'ts'incha an Jesús li wanajcha lhilhuwi ixcha'ant'awkan, pus akxni la'a'aymalhcha an makxkay'un, juniy: ―Makxkay'un yu jant'u ch'iwiniy chi a'atapa, k'amak'awcha ani ts'alh, ch'i jant'uch'a ali k'alakp'ach'ap'a. ");
INSERT INTO tpp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","An makxkay'un ch'ik'ik'icha t'asalh, chi p'ascha lakchikixli an ts'alh, makawlhcha, wa tacha wa nitacha sa' tamalh, ixtalaknajun ma niilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Walh an Jesús ma'ch'apasaklhi an ts'alh, oxicha tayacho'olh. ");
INSERT INTO tpp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tanulhcha laka cha'a an Jesús, chi tan wa ix'akstuchak'an an ixt'alhtanan tajuniy: ―¿Tasu li kitnan jantu lay ijk'uch'uwi? ");
INSERT INTO tpp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pus yucha jajuniy: ―Wa xliyu li ani makxkay'un jantu taxtuyi li jantu tapayninikani an Dios chi li jantu lhitask'ajakan kiwaytk'an. ");
INSERT INTO tpp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Wa ancha ta'alhcha, xalakaat'uncha Galileaja tapu'alh, chi jantu ixlakask'ini an Jesús li xamati kak'atsaalh. ");
INSERT INTO tpp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mu ixjamasuniy an ixt'alhtanan ixjajuniy: “Kit'in yu ikjunlhi isTs'alh Lapanak akima'axta'kana la ixmaknik'an an lapanakni, chi akintama'niya', walh ixlila'at'utu wilhchan akla'awcho'oya'”. ");
INSERT INTO tpp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero yu'uncha jantu talhimacha'xanilh chi ixtatalhanani li katalhisakmilh. ");
INSERT INTO tpp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tacha'alhcha la'acha'an Capernaúm, chi laka cha'acha an Jesús, jalhisakmiycha an ixt'alhtanan tuchini ixtalhilakchiwij'antacha an laka tij. ");
INSERT INTO tpp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yu'uncha sa' talajkilhulh, mu yu'uncha ixtalhilakchiwij'anta tichini palaycha lhitapalayi yu yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wachuncha tawilhcha an Jesús, chi jaxa'alalhcha an ixpumakawt'uyk'an ixt'alhtanan, jajuniy: ―Li xamati palay lhitapalay jumputun, yucha xalakat'ikt'i kawalh chi kajatapatsani'olhcha an ali'in. ");
INSERT INTO tpp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chi ma'ch'apachalh pumatam jas'at'a an Jesús, ixtan'ajnichak'ani yawlh, chi ch'ix'ilhcha, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Li xamati la'a'iy xamati jas'at'a tacha ani la kinta'a'ut, kit'ini kila'a'iy, chi li kila'a'iy, yucha an yu kimakminta la'a'iy. ");
INSERT INTO tpp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","An Juan alhtaylh, juniy: ―Maestro, ikla'ts'iw pumatam lapanak yu jak'uch'uyi la minta'a'ut an yu wa talakpach'apata makxkay'un, walh chi jantu kintat'alhtananan, pus jantucha ikmakawniw, mu jantu kintach'a'o'an. ");
INSERT INTO tpp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","An Jesús juniy: ―Jantu, jant'u ch'uni k'a'unit'it, mu jantu xamati yu lay ilhtuy laj'ay tu'u la kinta'a'ut, chi xli'astan wa tani akilhipastakpalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yu jantu kintat'alaxtukuyan, kintat'a'anan. ");
INSERT INTO tpp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chi wa tichicha yu taxta'niyan masi wa tamcha vaso xkan kilakata, mu uxitnan kint'alhtanan, yucha o'sliyajcha li kamapalhnikana'. ");
INSERT INTO tpp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Pero li xamati ma'o'xcho'oy xapumatam an jas'at'an an yu kintakiklaka'iy, palay oxi kalhtuj ch'ipixtanukalh palakskitin aya chiwx, chi kawarjcha maka'ankalh tan talhman lakxkan. ");
INSERT INTO tpp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Chi li amimaka ma'ilhtuyani tala'alhin, k'at'iklh ch'a'xmaj'a, mu palay oxi wa maklht'uluku k'a'unt'i ch'i k'ach'ip'i laka jatsukunti, walh jantu li a'tsa'ojoy mi maka ch'i k'ap'it'i laka la'nin tan jantu a'tam mixta jikmi,  ");
INSERT INTO tpp_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","tan an ixlakatsapulhk'an jantu a'tam taniniy, chi an jikmi wachu jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Chi li aminch'aja ma'ilhtuyani tala'alhin, k'at'iklh ch'a'xmaj'a, palay oxi wa ch'anlht'uluku k'ach'ip'i laka jatsukunti, walh jantu li ch'an'a'ts'a'o'oy k'amakp'ink'a laka la'nin, tan jantu a'tam mixa jikmi,  ");
INSERT INTO tpp_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tan an ixlakatsapulhk'an jantu a'tam taniniy chi an jikmi wachu jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chi li amila'chulh ma'ilhtuyani tala'alhin, k'at'ap'axt'u, palay oxi k'ach'ip'i tan ch'alhkatnan Dios wa mintalaktam, walh jantu li masi a'tsa'ojoy mila'chulh k'amakp'ink'a laka la'nin, ");
INSERT INTO tpp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tan an ixlakatsapulhk'an jantu a'tam taniniy chi an jikmi wachu jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chux lapanakni laka jikmi kajalhila'ts'intanukana', chi chux lha'ulan laka matsati kas'o'okana'. ");
INSERT INTO tpp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","An matsat oxi, pero li kama'ats'an'alh an is'o'onti, ¿t'asich'a k'alhis'o'och'o'oya'it'iti? Jant'u k'ama'ats'an'at'iti amimatsatk'an, para li oxi k'alalhip'it'it. ");
INSERT INTO tpp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Taxtulh an Jesús la'acha'an Capernaúm, alhcha xalakaat'un Judea chi an ixlitapiktutamcha ayxkan junkan Jordán, walh wanajcha lhilhuwi la'cha'ampalakalh, pus tsukulhcha jamasunipalay tacha ixlismanitacha. ");
INSERT INTO tpp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tala'cha'alh ali'in fariseojnin talhila'ts'intanuycha an Jesús, tajuniy li sna oxi li xamati lapanak kamakawlh ixt'iwi'. ");
INSERT INTO tpp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yucha ja'alhtaylh jajuniy: ―¿Tasicha tajunin an Moisés? ");
INSERT INTO tpp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yu'uncha tajuniy: ―An Moisés, makawnilhi an lapanak li layi kaxta'niya ixt'iwi la'atam jalhiki yu katalapumakawna', chi kamakawnacha. ");
INSERT INTO tpp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pus an Jesús jajuniy: ―Chunchacha lhinawlh an Moisés mu wa xliyu jant'u k'is ja'asmatnanat'it. ");
INSERT INTO tpp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero an Dios akxni ilhtulh an lapanak “ilhtulhcha an lapanak chi ilhtulhcha an t'aku'”. ");
INSERT INTO tpp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Xliyu an lapanak, kamakawna ixpay chi ixnati, ixt'iwicha kat'atala'xt'o'a'. ");
INSERT INTO tpp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","An ixt'uyunk'an tachanu wa pumatamcha katajuna'”, jantucha ixt'uyunk'an, tachanu wa pumatamcha. ");
INSERT INTO tpp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yu Dioscha jamala'xto'lhi jantucha kajalamamakawnilhi an lapanak. ");
INSERT INTO tpp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Laka cha'acha, a'tam talhisakmipalhi an ixt'alhtanan an Jesús yu yucha ixlakata. ");
INSERT INTO tpp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pus jajuniy: ―Wa tichicha yu makajun ixt'iwi chi t'atsukupalaycha pumatam t'aku, tala'alhincha ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chi tam t'aku yu makajuni ixt'apapa chi t'atsukupalaycha pumatam lapanak, wachucha tala'alhini ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ixtalhicha'aniycha an jas'at'an an Jesús para li kajalaklakpach'apalh, pero an ixt'alhtanan talaj'aymastuklhi an yu ixtalhicha'aniy. ");
INSERT INTO tpp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Walh akxni jala'ts'ilh an Jesús lhitalh'amalh chi jajuniy: ―Kachajcha tamilhi an jas'at'an, jant'u k'ajalaj'aymast'ukt'it, mu an ixlich'alhkat Dios ixnawink'an yu tacha yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kit'in sawalhi an yu klajunaw li yu jantu la'a'iya an ixlich'alhkat Dios tacha pumatam jas'at'a, jantu katicha'alhi tan ch'alhkatnan Dios. ");
INSERT INTO tpp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chi jalakch'ix'ilhcha an jas'at'an, jalaklakpach'apalhcha, jalhisk'inilhcha an Dios li oxi katatsukulh. ");
INSERT INTO tpp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Akxni ixti'ancho'oycha an Jesús, la'ats'alajcha'alh pumatam lapanak, chi tatso'ottanilhcha la ixlakapu', juniy: ―Oxi maestro, ¿tasicha aklhit'aalalh para li aklhitsukulh an yu jantu min'ojoy jatsukunti? ");
INSERT INTO tpp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","An Jesús juniy: ―¿T'asu li k'i'uniycha li oxi klapanaki? Jantu xamati yu oxi lapanak, wa pumatami yu chun, Dios. ");
INSERT INTO tpp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","K'ats'aycha an lhamap'a'sin: “Jant'u wa aya k'alat'i, jant'u k'ajama'nin, jant'u k'aja'alhawan, jant'u k'amaslak'at'in, jant'u k'aja'o'xch'o'on, oxi k'ala'ts'i mimpay chi minati.” ");
INSERT INTO tpp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pus an lapanak juniy: ―Maestro, chuxcha chuncha ik'ilhtu'ojoy wa kintats'alat. ");
INSERT INTO tpp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pus an Jesús sa'cha ixla'ts'in chi ixmapayniycha, juniy: ―Pero ts'an'aniyanka la'atami yu k'a'ilht'u, k'ast'a'o chux an yu lhit'a'un ch'i k'ajamala'p'its'inincha an tumin an jakilhpatinin, chuncha yu k'alhits'uk'uya'a laj'oxi mintanlhun an lakt'iyan, xli'astan k'at'ana'acha ak'inch'a'o'aya'acha k'axa'a'iya'acha mincruz yu lay kap'uma'nik'a. ");
INSERT INTO tpp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ancho'olhcha an lapanak, sawalhcha lhita'oxila'alhiya tacha an junikalh, mu lhuw ixtanlhuni ixlit'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Chi an Jesús jalaklakawanancha, jajuniy an ixt'alhtanan: ―¡Sawalhcha lhima'anxkayi katacha'ana an la ixlich'alhkat Dios an yu talhit'ajun lhuw ixtumink'an! ");
INSERT INTO tpp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","An ixt'alhtanan sawalhcha ixtalhi'a'niya tacha an jajunilh, pus an Jesús jajumpalay: ―Kints'alan, ¡sawalh lhima'anxkayi katatanuyanta la ixlich'alhkat Dios an yu tachanu tumin takiklaka'iy! ");
INSERT INTO tpp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Palay wa lasi kastaala'pusli la ix'ista makskat la'atam camello, walh jantu li katanuchalh xamati jamatumin an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pus palaycha ixtalhi'a'niy, ixtalajumpaxay: ―¿Pus tisiyuchacha lay kata'alhtaxtuya'a? ");
INSERT INTO tpp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pus an Jesús sa'cha jala'ts'in, jajuniy: ―Yu an lapanak jantu lay ilhtuy, an Dios yucha layi ilhtu'ojoy chux. ");
INSERT INTO tpp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Xli'astan an Pedro tsukulhcha juniya an Jesús: ―Kitnan iklhimakaw'otawcha kintanlhunk'an, mu iklach'a'o'atawcha. ");
INSERT INTO tpp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pus an Jesús najun: ―Aklajunaw yu sawalh, masi yu lhimakajuntacha ixcha'a, u ixjat'ala'awnin, u ixjamatsanan, u ixpay, u ixnati, u ixt'iwi, u ixjas'at'an, u ixlakaat'un, kilakata chi ixlakata an laj'oxi chiwinti, ");
INSERT INTO tpp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tam cientoj palayi kaxta'nikana ani lakamunulhpa: ixcha'a, ixjat'ala'awnin, ixjamatsanan, ixnatin, ixjas'at'an chi ixlakaat'un, masi ani lalhilhitama'chapukan. Atumpaja kaxta'nikana jatsukunti yu jantu a'tam min'ojoy, akxni kamina an yu tumpajcha lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero ixluwk'ani yu p'ulhnaj chaway, yu'uncha astani katajuna', chi yu astan chaway p'ulhnaja katajuna'. ");
INSERT INTO tpp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ixtitatama'ast'a'ancha la'acha'an Jerusalén an Jesús ali an ixt'alhtanan, ixp'ulayi an Jesús, an ixt'alhtanan jantucha ixtalhimacha'xayi li an Jesús o'sliyani ixti'an an la'acha'an masi ixk'atsaycha li kaniya', chi an yu astan ixtamintachalh ixtalaktalhanancha. Pus an Jesús a'tam jalhi'ampalhi tan wa ixpu'akstuk'an an ixpumakawt'uyk'an ixt'alhtanan, tsukulhcha jajuniya tani kaputapasayacha, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Titama'ast'a'anawcha Jerusalén, tan kama'axta'kana an yu junlhi isTs'alh Lapanak. La xmaknik'an an xalaj'ajin sacerdotejnin, chi an xamaestrojnin lhamap'a'sini kama'axta'kana', chi yu'uncha katanawna li kama'nikalhcha. Katama'axt'a'a la xmaknik'an an yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jantu tu'u katitalhiwilalh, katala'ana'maya, katala'achujwaya, chi katama'niya', walh ixlila'at'utu wilhchan kala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","An Jacobo chi an Juan, ists'alan tichi lapanak junkan Zebedeo, waniycha tala'alh an Jesús, tajuniy: ―Maestro, klask'iniputunaw lamapaynin. ");
INSERT INTO tpp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yucha jajuniy: ―¿Tisunch'a lak'ask'inat akla'ilhtuniwi? ");
INSERT INTO tpp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pus tajuniy: ―Akilamakawniw li aklapiktutawlhcha'aw tapiktutamin t'an k'ap'ina'a ch'alhkatna', pumatam tan oxi mimpa'xti chi pumatam la milhijama'xi. ");
INSERT INTO tpp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","An Jesús jajuniy: ―Jant'u k'ats'ayat t'uch'ini sk'inatcha. ¿Layi k'alhit'ayaniya'it an ma'alh'ajnat yu akma'alh'ajnana', ch'i k'aniya'it'iti tacha akniya'? ");
INSERT INTO tpp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yu'uncha tajuniy: ―¡Chun, kalaya'! Pus an Jesús jajuniy: ―K'ama'alh'ajnana'itcha tacha kit'in, chi k'aniya'itcha tacha kit'in. ");
INSERT INTO tpp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero li akilalakpa'xtitawlaw jantu lay kit'in aktilamakawniw, mu ancha katatawla yu anchacha jalhisakxtukanta. ");
INSERT INTO tpp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Akxni ta'asmatlhi an ixpumakawk'an ali'in ixt'alhtanan an Jesús, tat'alatalh'amajla'ts'ilhcha an Jacobo chi an Juan. ");
INSERT INTO tpp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pus an Jesús, jaxalalh jajuniy: ―Uxitnan k'ats'ayat'iti li an yu tajun xajamach'alhkatni an laj'ay la'acha'anaxni wa talhinajuncha, chi an yu palay xalaj'ajin, yu'uncha yu palaycha wa talhinajun. ");
INSERT INTO tpp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ani uxitnan, tam. Ani yu lhitapalay jumputun p'ulhnajcha kajatapatsanilhi an ali'in. ");
INSERT INTO tpp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chi yu palaycha tukan xa'ay jumputun yu uxitnan, mima'tsukuk'ani kajuna'. ");
INSERT INTO tpp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mu masi kit'in yu ikjunlhi isTs'alh Lapanak, jantu ikminta li wa akilak'ilhtunikalhcha an tapatsat, kit'in iklamintaw tapatsaninin, chi ikminta ma'axta'na an kijatsukunti para li lhuw lapanakni katata'alhtaxtulh. ");
INSERT INTO tpp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wachuncha la'acha'an Jericojcha tacha'alh. Chi akxni ixtitataxtucho'oycha an Jesús ali an ixt'alhtanan ts'ananacha ixjach'a'o'akanta. Walh pumatam la'lhtuluw lapanak junkan Bartimeo, ists'alh tichi lapanak junkan Timeo, an ixpiktu tiji sa' ixwilh, isk'in la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pus akxni asmat'acha li yucha an Jesús yu jamacha'a Nazareti ix'antachalh, tsukulhcha t'asay, najun: ―¡Jesús, Ists'alh David, lamapaynin ak'ilhi'a't'ay'ut'i! ");
INSERT INTO tpp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pero an ali'in lapanakni tala'a'aymalh para li sa'cha kakilhulh. Pero yucha palay p'as ixt'asay: ―¡Ists'alh David lamapaynin ak'ilhi'a't'ay'ut'i! ");
INSERT INTO tpp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wachuncha an Jesús sa'cha tayalh, chi jajuniy an yu ixtat'a'anta li katat'asanilhcha an la'lhtuluw lapanak, pus tat'asanilhcha chi tajuniy: ―Jant'u t'ani k'anaw, k'at'aycha, t'asaniyani an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pus lht'ele' maj'alhi an ixpupula'axt'a'kan an la'lhtuluw lapanak, tayalhcha, la'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","An Jesús juniy: ―¿Tasu ak'ilhtunch'a na'uni? Pus an la'lhtuluw lapanak juniy: ―Maestro, ijkalakawanamputun. ");
INSERT INTO tpp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","An Jesús juniy: ―An mijakiklaka'inti p'ut'ak'uch'ut'icha, k'ap'inchicha. Pus wa akxni jalakawanalhcha, chi ch'a'o'alhi'alhcha an Jesús an laka tij. ");
INSERT INTO tpp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Akxni ixtacha'ant'ajuncha la'acha'an Jerusalén, wa niycha la'acha'an Betfagé chi wa niycha la'acha'an Betania, la ixlakapucha an a'stitawk'a junkan Laka Olivojnin, an Jesús jamala'achalhcha ixt'uyunk'an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jajuniy: ―K'ap'inchi'it'it an tan tasuy la'acha'an, chi akxni k'ach'ip'ina'itcha k'ala'ch'ip'ina'it'it la'atam jas'at'a burro, ch'iyawkanta, jantuka' a'tam putawk'akan, k'ax'ot'iya'it, akilalhiminiyaw. ");
INSERT INTO tpp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Li xamati talhisakmiyan t'uch'ini lhix'ot'iyatcha, k'a'una'it'it li yucha an jamach'alhkati ma'lhtask'iniy, li wa tukan kama'axta'cho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pus ta'alhcha, walh tala'cha'alhcha an burro, ixch'iyawkanta laka maticha lhilaka tij, pus tax'ot'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Walh tichi yu'uncha yu ancha ixtawilanalh tajuniy: ―¿Tasu li x'ot'iyatcha an burrojo? ");
INSERT INTO tpp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Pus yu'uncha chunchacha tanajun tacha an ixjajunita an Jesús, pus jamakawnikalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Talhi'anilhcha an Jesús an burro chi an lapanakni talak'aymuk'anilhcha an burro yu ixtaputala'axt'a'ta yu'uncha, chi putawk'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","An ali'in ixtalakmamaycha an yu ixtaputala'axt'a'a an tan ixpu'anta an Jesús, chi an ali'in ixtala't'e'emaniycha jach'itin. ");
INSERT INTO tpp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","An yu ixtap'ulanan chi an yu astan ixtamintachalh ixtalakt'asaycha, ixtalaknajun: ―¡K'ajama'alht'axt'uncha chaway! ¡Oxi ani lapanak yu Dios makmintalh! ");
INSERT INTO tpp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Oxi an minta lhich'alhkat, ixlich'alhkat kimpayk'an David! ¡Hosanna kanawkalhi an lakt'iyan! ");
INSERT INTO tpp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Cha'alhcha Jerusalén an Jesús chi tanuchalhcha an laka xa'ay tajtan, sa'cha ixjalaklakawanan wa yu, mu tats'isiycha, ta'alhcha Betania ali an ixpumakawt'uyk'an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Xlila'atamcha wilhchan, akxni ixtitataxtucho'oycha Betania, chawanalhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Walh laka'an ma'at lanan, st'a'aj yachalh a'atam xak'iw higo, pus alh laka'ana li sna uk'anilhi xajatawk'at, walh cha'alh la'ts'in jantu tu'u uk'alh, wa si xax'oy mu jantu ixpaku'. ");
INSERT INTO tpp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pus an Jesús juniy an xak'iw higo: ―Jantu a'tam ka'unini xamati mijatawk'at. Walh ta'alha'asmatlhi an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tacha'ampalhcha Jerusalén, walh an Jesús akxni tanuchalh an laka xa'ay tajtan, tsukulh jatamakxtuyi an yu ixtajast'anan chi an ixtajatamawnan ixpulakni tajtan. Jala'ma'atasp'itni'olhi an mesa an yu ixtamapaxay tumin chi an ixtants'ik'an an yu ixtast'ay paloma. ");
INSERT INTO tpp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jantucha ixmakawniya li xamati ali kat'atanuchalh tu'u'. ");
INSERT INTO tpp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tsukulhcha jamasuniy jajuniy: ―Mu ts'o'kanta an la ixchiwinti Dios tan najun: “Chux an lapanakni ta ixlijalhi'ay an lakamunulhpa an kincha'a katajuna putapaynin.” Walh uxitnan wa p'a'alhawnanatcha. ");
INSERT INTO tpp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pus ta'alha'asmat'acha an xamaestrojnin lhamap'a'sin chi an xalaj'ajin sacerdotejnin. Pus talhipuxkawnilhcha tani katalhima'nilhcha, mu ixtatalhamnicha chi, mu ta lhichux an lapanakni ixtalhi'a'niniycha an ixlamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero an Jesús akxni tats'isilhcha taxtulhi an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tala'puspalhcha wats'isin an tan yalh xak'iw higo, xixtacha chux xajataxiyak. ");
INSERT INTO tpp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wachuncha an Pedro past'ak'ach'a, juniy: ―Maestro, jo'o k'ala'ts'i, an xak'iw higo an yu la'a'aymat'i xixtacha. ");
INSERT INTO tpp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","An Jesús alhtaylh juniy: ―K'ak'iklak'a'it'iti an Dios. ");
INSERT INTO tpp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mu wa tichicha yu kajunilh ani a'stitawk'a: “K'a'ost'i, an alamalhch'a k'at'a'uchi'”, li kiklaka'iya chux la ixjalhunut chi li lhiwilayi an yu najun li kajuna, kajuna sawalh. ");
INSERT INTO tpp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Xliyu klalhijunaw, wat'uch'ich'a t'ap'aynisk'inat'it, k'ak'iklak'a'it'iti li k'axt'a'nik'ana'it'it sawalh, walh k'axt'a'nik'ana'it'it sawalh. ");
INSERT INTO tpp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ch'i akxni t'ap'ayniyat, k'amala'mixinit'iti xamati yu ta'ilhtuniyan tu'u tala'alhin, walh wachu katamala'mixiniyani mintala'alhink'an an mimPayk'an yu wilhchalh lakt'iyan.  ");
INSERT INTO tpp_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero li jant'u mala'mixiyat'it, wachu jantu katitamala'mixinini an mimPayk'an yu wilhchalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wachuncha ta'ampalhcha Jerusalén, walh akxni ix'aklat'ajuncha laka tajtan an Jesús, tala'cha'alhcha an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an laktatanin. ");
INSERT INTO tpp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tajuniy: ―¿T'asu li ch'unch'ach'a layi, tisiyuchacha makawniyan li k'ajalakt'amakxt'u an tajast'anani? ");
INSERT INTO tpp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","An Jesús ja'alhtaylh jajuniy: ―Wachu aklalhisakmiyaw la'atam chiwinti. Li akilajunaw, wachu aklajunawi tuchini laycha chuncha iklhilak'ilhtuy ani tanlhun. ");
INSERT INTO tpp_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿An ixjama'paxanti Juan, Diosi ixlijuniy u wa ixjatapast'ak'atcha lapanak? Akilajuniw. ");
INSERT INTO tpp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pus wachuncha tsukulhcha talakchiwiniy talajuniy: ―Li kajunaw li Diosi ixlijuniy, akintajunan: “¿P'us ch'i li jant'uch'a k'iklak'a'it'iti?” ");
INSERT INTO tpp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chi li kajunaw li wa ixjatapast'ak'atcha lapanak, chux an lapanakni akintatayla'minan, mu yu'uncha tak'atsayi li an Juan ixchiwinti Dios sawalhi ixlichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pus an Jesús ta'alhtaylh tajuniy: ―Jantu ijk'atsayaw. Yucha wachu jajuniy: ―Wachu jantu aktilajuniwi tuchini chunchacha iklhi'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tsukulhcha jaxa'alay wa laka pulhamacha'xani an Jesús, jajuniy: ―Pumatam lapanak ch'anlhi ix'uva chi kurralhnulhcha, chi ja'ajnalhcha tan kapach'itkana', chi ilhtulhcha la'atam torre, jamach'ixta'nilhcha tichi yu'uncha lapanakni, chi yucha ma'atcha alh. ");
INSERT INTO tpp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Walh akxni chilhcha ixpaku an ix'uva, makminchalhcha pumatam yu kamilh inini yu ixnawincha. ");
INSERT INTO tpp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero an yu ixjamalhistaknikanta wa talakasamalhi an yu ixmala'achakantachalh, pus wachuncha tamala'achacho'olh. ");
INSERT INTO tpp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","An yu jamanawin a'tam mala'achapalhchalh pumatam ixma'tsuku, pero palaycha talakasamanilh, tamalakpak'atsanilh, chi stakcha tamamaxanilh. ");
INSERT INTO tpp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A'tam mala'achapalhchalh pumatam, walh tama'ninilh. Chi ali'incha yu ixjamala'achapalachalh, ixjama'ninikan chi ixjalaksamanikan. ");
INSERT INTO tpp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Xli'astan wa pumatamcha yu sawalh ixmapayniy ists'alhi ixlit'ajun, pus yuchacha makminchalh, mu ixnajun: “Ani mu kints'alh, kata'asmatniya'.” ");
INSERT INTO tpp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Walh an yu ancha ixtajalhistaknan talajuniy: “Yucha anicha jamanawin kajuncho'oya an lakaat'un. Kama'niw, walh ki'anuchak'ani kajuna'.” ");
INSERT INTO tpp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pus tach'apachalh, tama'nilh, ma'spacha an tan ixtalhistakta lakaat'uni takimaj'alh. ");
INSERT INTO tpp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿T'asich'a lhiwilayat kalaya an yu jamanawin an tan ch'ankanta uvaja? Yucha kamina chi kajama'ni'oya an yu ixtajalhistaknan, ali'ini kajaxta'niya an lakaat'un an tan ixch'an ix'uva. ");
INSERT INTO tpp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Jant'u p'unawt'at'iti tacha an najunta tan an ts'o'muk'akanta an la ixchiwinti Dios? Tan najun: An chiwx an yu tala'amaj'alh an yu tayajuy cha'a, apalij yucha palay lhitapalalh. ");
INSERT INTO tpp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yucha an Diosi chuncha ilhtulh. Chi lhi'a'niyawcha li chunchacha la'ts'inaw. ");
INSERT INTO tpp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pus ixtach'apayawputuncha an Jesús, mu talhimacha'xalhi li yu'uncha jajuniy, pero wa tatalhanajlalh, mu lhilhuw, pus ta'ancho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tamala'achachalhcha ali'in fariseojnin chi yu ixt'apartidojnincha an Herodes an tan ixt'ajun an Jesús, para li tu'ucha kata'alh'a'taymalh. ");
INSERT INTO tpp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tala'cha'alh tajuniy: ―Maestro, ijk'atsayaw li sawalhi an yu na'un chi li jant'u xamat'i t'alhamniy, mu uxint'i jant'u yu lhak'ap'up'in tani tasuycha xamati', uxint'i ts'ajwi masuy an ixtij Dios. ¿Oxi li akmapalhlhi'aniw tanlhun an ay xajamach'alhkat la'acha'an Roma u jantu? ");
INSERT INTO tpp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Walh yucha mu ixjak'atsaaniya li wa tajuniycha, pus jajuniy: ―¿Tasu li wa kilalhila'ts'intanuyawcha? K'alhit'at'it a'xtami an tumin, akla'ts'ina'. ");
INSERT INTO tpp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pus talhicha'anilhcha chi jajuniy: ―¿Tisiyuchacha ani puwilh chi an ixta'a'ut? Yu'uncha tajuniy: ―Ix'anu an ay xajamach'alhkat Roma. ");
INSERT INTO tpp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pus yucha jajuniy: ―K'axt'a'nitcha yu ix'anu an ay xajamach'alhkat Roma, chi yu ix'anu Dios wach'uch'a k'axt'a'nit. Pus sawalhcha talhi'a'nilh. ");
INSERT INTO tpp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","An saduceojnin yu jantu takiklaka'iy li kala'awcho'okana tala'cha'alh, tajuniy: ");
INSERT INTO tpp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, a Moisés kintats'o'nini an la ixchiwinti Dios li ma xamati niy ixt'ala'ajun chi li t'ajuni ixt'iwi, pero li jantu tu'u ixjas'at'an, ma tamcha ixt'ala'ajuni kat'atsukucho'olh, para li ma kat'ajamas'at'analhcha. ");
INSERT INTO tpp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ixtat'ajun ixpumatujunk'an wa lhit'ala'awnin. An xa'aycha t'atsukukalhcha, walh nilh, jantu tu'u jamakawlh ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pus an yu ixt'ala'ajuncha yuchacha t'atsukucho'olh an t'aku', walh wachu niipalh, jantu tu'u ixjas'at'an jamakawpalh. Chi an ixlipumat'utucha t'atsukulh ixt'ala'ajunk'an wanajcha chun, niipalh. ");
INSERT INTO tpp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Sta tat'atsuku'olhi an ixpumatujunk'an an t'aku', chi talakni'olh, jantu tu'u tamakawlh ixjas'at'ank'an, xli'astan an t'aku wachucha niilh. ");
INSERT INTO tpp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akxni kala'awcho'okana, mu an ixpumatujunk'an tat'atsuku'olhi an t'aku, ¿tisiyuchacha ixt'iwi kajuna'a? ");
INSERT INTO tpp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","An Jesús ja'alhtaylh jajuniy: ―Wa xliyu jant'u k'ats'ayat an ixchiwinti Dios, chi li yucha layi ilhtu'ojoy watuchicha, walh o'palaj xliyu k'a'ilht'ut yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Akxni kala'awcho'okana, jantu xamati katit'atsukukalh, mu tacha an angelhnini kajun'okana'. ");
INSERT INTO tpp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chi li sna jant'u k'ats'ayat'iti li kala'awcho'okana, ¿ch'u jant'u p'unawt'at'iti an la ixlibro Moisés, tacha an xa'alalh Dios akxni ixla'xawt'ajun a'atam k'iw yu junkan zarza, tan junikalh a Moisés: “Kit'ini ixDios Abraham, chi Isaac, chi Jacob?” ");
INSERT INTO tpp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","An Dios jantu ixDiosk'an janinin, ixDiosk'an yu tala'ajunta. Uxitnan sawalhch'a lhits'an'ayat. ");
INSERT INTO tpp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Pumatam xamaestro lhamap'a'sin jala'cha'alh, mu ja'alha'asmat'acha li talakikxtukuy, chi k'atsayi li oxi ja'alhtaylh an Jesús, pus lhisakmiycha, juniy: ―¿Tanyucha yu palay ay lhamap'a'sin? ");
INSERT INTO tpp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","An Jesús juniy: ―Tan an najunta: “Israel, k'a'asmatt'i, an kiJamach'alhkatk'an Dios, wa pumatam. ");
INSERT INTO tpp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Chi k'amap'ayniya'a amiJamach'alhkat Dios, chux la mijalhunut, chux la mintakuwin, chux la mijatapast'ak'at chi chux la mintachaput. Yucha yu ay lhamap'a'sin.” ");
INSERT INTO tpp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ixlitipat'uy wa ixt'atamcha lanan: “K'amap'ayniya'a mint'alapanak t'ach'a map'aynik'an mi'akstu”. Ani la'at'uy lhamap'a'sin yucha yu laj'ay, jantu tu'u atumpaj. ");
INSERT INTO tpp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Wachuncha an xamaestro lhamap'a'sin juniy: ―Chun sawalhi Maestro, t'ach'a an na'un li wa pumatami Dios, jantu tu'u t'awpalay sawalh, ");
INSERT INTO tpp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","chi li kamapaynikalhi chux laka jalhunut, chi chux laka jatapast'ak'at, chi chux laka tak'atsaan, chi chux laka tachaput, sawalh. Chi li akmapayniwi kint'alapanakk'an tacha ikmapaynikanaw, palay lhitapalay, walh jantu masi chux tacha an jama'nikan jatapakxat chi jala'xawakancha tan ma'axta'kan lha'ulan. ");
INSERT INTO tpp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","An Jesús, mu la'ts'incha li oxi tacha an ja'alhtayanalh, pus juniy: ―Jantu ma'ati t'a'un an la ixlich'alhkat Dios. Wachuncha jantucha xamati k'is tapujucho'olh kalhisakmilh tu'u'. ");
INSERT INTO tpp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Akxni ixmasuy an Jesús an laka tajtan ixjajuniy: ―¿Tasu li tanajuncha an xamaestrojnin lhamap'a'sin li an Cristo ists'alh Daviti? ");
INSERT INTO tpp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pero mu an David yucha nawpalay akxni machiwinilh an ixtakuwin Dios, najun: “An Jamach'alhkat Dios juniy an kiJamach'alhkat Cristo: Tan oxicha kimpa'xti ak'imp'ikt'ut'a'ulh, sta akxni ajkamama'oyacha la mijach'aja an yu wa taxkayan.” ");
INSERT INTO tpp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","An David yucha najun li an Cristo ixJamach'alhkat, ¿tasicha li ists'alh a'tami? Pus tacha an wanajcha lhilhuw ts'anaks ixlakyakalh sawalhcha ixta'achani ixta'alha'asmat'a an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ixjamap'a'siy ixjajuniy: ―K'ajalajk'ats'anant'it, mu an xamaestrojnin lhamap'a'sin sawalhcha ta'achaniya tala'la'ch'iy la'lhman ixla'ch'itk'an, chi ta'achaniya kajala'axa'alakalh laka tiankis. ");
INSERT INTO tpp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chi tan p'ulhnaja talaktawlhputunachalh an laka lakcha'a tan pulakta'ayxto'kan, chi tan alin k'atan tan lakwaykan. ");
INSERT INTO tpp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yu'uncha yu wanajcha tamaxtuni'ojoy ixcha'ak'an an yu jantucha tu'u ixt'apapak'an t'akunin. Chi sawalhcha oxi lapanakni talay, panijnicha tatapayniy. Yu'uncha palay ay lhima'alh'ajna kajaxta'nikana'. ");
INSERT INTO tpp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","An Jesús sa'cha ixwilh lhilaxlakapu an caja tan ixtamujuy ixla'ulank'an an lapanakni, sa'cha ixjala'ts'in, ixpumalhuk'an an yu jamatuminin la'lhuwi ixtamujuy. ");
INSERT INTO tpp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Walh cha'alh pumatam jakilhpatinij t'aku yu maticha ixt'apapa, wachu mujulh a'xt'uy lakt'ikt'i ixtumin. ");
INSERT INTO tpp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Wachuncha an Jesús jaxa'alalhi an ixt'alhtanan, chi jajuniy: ―Ani jakilhpatinij t'aku yu jantucha tu'u ixt'apapa palay mujulh, walh jantu an ali'in. ");
INSERT INTO tpp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Mu yu'uncha wa xaxajnicha tamujulh, pero ani t'aku, masi wa ixkilhpatitcha muju'olhi yu ixch'apata, chux yu kaxlitamawwaylh. ");
INSERT INTO tpp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Akxni taxtucho'olhcha an laka tajtan an Jesús, pumatam ixt'alhtana juniy: ―¡Maestro, k'ala'ts'i an chiwx chi an cha'a wa lajk'usicha! ");
INSERT INTO tpp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Alhtaylh an Jesús juniy: ―T'ach'a ani la'ts'in laj'ay cha'a, wanaj kama'ta'okana', jantu tu'u masi wa katila'ukxtawk'atawilhcha chiwx. ");
INSERT INTO tpp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Chi akxni sa'cha tawilh an Jesús an a'stitawk'a tan junkan Laka'Olivojnin, lhilaxlakapu an tajtan, an Pedro chi an Jacobo chi an Juan chi an Andrés wa ixpu'akstuk'an talhisakmiycha, ");
INSERT INTO tpp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","tajuniy: ―¿Tasu wanancha chuncha katapasaya'a? ¿Chi tasucha aklhik'atsayaw akxni chunchacha kalaktapasaya'a? Akilajuniw. ");
INSERT INTO tpp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","An Jesús ja'alhtaylh tsukulhcha jajuniy: ―K'ajalajk'ats'anant'it, para li jantu xamati kata'o'xcho'on. ");
INSERT INTO tpp_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mu ixluwk'ani katamina yu katanawna: Kit'ini ijCristo, chi ixluwk'ani katata'o'xcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Akxni k'a'asmat'a'it'iti li lasakancha chi lat'alhkancha, jant'u k'alakt'alhanant'it, mu lhitask'iniya li chuncha katapasalh, pero jantuka' kati'ukla'olh. ");
INSERT INTO tpp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mu kilhmaktam lapanak kat'alasaya akilhmaktam lapanak chi pumatam ay jamach'alhkat kat'alasaya apumatam ixt'a'ay jamach'alhkat. Chi wa tanchuncha kalaklaya an lakaat'un chi ka'alinacha chawan. Yucha wa kapu'a'tayniyaka an lhima'alh'ajna. ");
INSERT INTO tpp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero uxitnan, uxitnani k'alhak'ap'up'ink'ant'it, mu k'ama'axt'a'k'ana'it'it laka lakjamach'alhkat, chi k'a'ayna'k'ana'it'iti tan tata'ayxto'ojoy an lapanakni, chi ixlakapuk'an an jamach'alhkatni k'alhip'ink'ana'it'iti kilakata. Akxni lay k'aja'una'it an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Task'iniya li an laj'oxi chiwinti katijamak'atsaani'okalhcha p'ulhnaja ta kilhmakchux an lapanakni ta'alin, xli'astan ka'ukla'oyacha. ");
INSERT INTO tpp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chi akxni ma'axt'a'k'anat'it, jant'u k'alhak'ap'up'it'iti t'ani k'anawna'itcha, k'anawna'it yu anchacha katamapast'ak'aniyan an ixTakuwin Dios, mu jantu uxitnani k'at'ichiwinint'it yucha an ixTakuwin Dios. ");
INSERT INTO tpp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Akxni masi yu tam mint'ala'ajunk'an katama'axt'a'ani laka lhinin, chi tam xapay kama'axt'a'a masi ists'alh, chi katat'ala'ayacha an ixpaynink'an an xajas'at'an, katama'niya ixlakpaynink'an. ");
INSERT INTO tpp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tucha k'is k'at'ila'ts'imp'ut'unk'ant'iti kilakata, pero yu kalhitayaniya, yucha kata'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’K'ala'ts'ina'itcha an ay tuchichun yu jantu k'is lhitayanikan la'ts'inkan yu lhichiwinilh an Daniel, yu ixlichiwiniy ixchiwinti Dios. Anchunu ay tuchichun ka'ulakanacha tan jantu ixlitask'inin katawilh, (yu punajun kalhimacha'xalhcha), pus yu katatsukuya lakaat'un Judea, kata'os'alhcha an laka'a'stitawk'an. ");
INSERT INTO tpp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chi yu ix'a'sti ixcha'a uk'achalh, jantu kata'alhtajulhi para li ka'alh maxtunu tu'u la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chi yu la ixkuxtu t'awnachalh, jantu ka'alhi puxkawna ixpu'ayxt'a'kan. ");
INSERT INTO tpp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Chi payni'incha an t'akunin yu ixt'a'akxni tukan taja'aynanta, chi yu ixt'a'akxni tukan talhit'ajun ixjas'at'ank'an yu tats'ik'iyka', mu akxni lhima'anxkay! ");
INSERT INTO tpp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","K'at'ap'aynit'it, para li jantu akxni ixpaku lhik'asnini k'aja'osnunt'it. ");
INSERT INTO tpp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mu ay lhima'alh'ajna ka'alina', tacha yu jantu a'tam alinta sta wa tawanancha ilhtutachalh an lakamunulhpa an Dios, sta chaway, chi jantu a'tam chun katitapasacho'olh. ");
INSERT INTO tpp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Li jantu kaxlalakat'ikt'ilhi an xapanch'e'ex lhima'alh'ajna an Dios, jantu xamati ixta'alhtaxtulh, pero mu jamapayniya an Dios an yu jasakxtutacha, pus kalalakat'ikt'iya an xapanch'e'ex ma'alh'ajnat. ");
INSERT INTO tpp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Li xamati tajunan: “Anicha t'ajun Cristo, u anucha t'awnachalh Cristo”, jant'u k'ak'iklak'a'it. ");
INSERT INTO tpp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mu kata'alina yu jantu Cristojnin sawalh, chi yu jantu ixlisawalh ixchiwinti Dios katitalhichiwinilh, chi layi kata'ilhtuya laj'ay tanlhun tu'u', tacha jak'uchunti, pero wa ixpa'o'xcho'onchak'an, chi li lay, kata'o'xcho'oputuna an yu jasakxtukantacha. ");
INSERT INTO tpp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pus chaway iklamak'atsaaniwcha, ¡k'ajalajk'ats'anant'itcha! ");
INSERT INTO tpp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Chi anchunu panch'e'ex, xli'astancha an ay lhima'alh'ajna, an wilhchan kataputs'isiya', chi an malhkuyu jantucha katimapulhkulh. ");
INSERT INTO tpp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chi an st'akunin katapatajuya', chi an yu talhit'ajun ix'alhp'asnintik'an awint'i lakt'iyan kajalakchikixkana'. ");
INSERT INTO tpp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Wachuncha an yu kijunchilh isTs'alh Lapanak, sawalhcha alhp'asi kala'ts'istukkana kamina an laka jataputs'i, chux la ixta'ayaxtu. ");
INSERT INTO tpp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chi an ix'angelhnin, kajamala'achayacha li katamach'ixtamilhcha an yu jasakxtutacha, ta ixlijalhi'ay an lakamunulhpa chi an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’K'ap'ulhimach'a'xatcha t'ach'a an lhixa'alak'ant'it xak'iw higo. Akxni lajkilhawilhcho'olhcha, chi xajnicho'oyachilhcha sast'i xax'oy, k'ats'ayatcha li wa niycha ixpaku lhi'ichi. ");
INSERT INTO tpp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Xliyu li akxni k'ala'ts'ina'itcha kalaktapasaya tacha an iklajuniw, k'ats'ayatcha li wa niycha laka maticha ikminta. ");
INSERT INTO tpp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kit'in iklajunaw yu sawalh, akxni chuxcha chuncha kalaktapasaya, lhilhuwi kala'ts'inkana', mu katsukukanaka'. ");
INSERT INTO tpp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","An lakt'iyan chi an lakaat'un ka'ukla'oya', pero an kinchiwinti jantu. ");
INSERT INTO tpp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Chi tuchi wilhchancha chi tuchi panch'e'excha chuncha katapasaya, jantu xamati k'atsay, masi an angelhnin awint'i lakt'iyan chi an masi an isTsálh Dios, wa yucha an ixPayi k'atsay. ");
INSERT INTO tpp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’K'as'alaj ts'uk'ut'it ch'i k'at'ap'aynit'it, mu jant'u k'ats'ayat'iti tani wanancha chuncha katapasaya'. ");
INSERT INTO tpp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Tacha xamati lapanak yu ka'alh ma'at, chi an ixma'tapatsanin kajamalhistaknilhcha an ixcha'a chi atamj atamjcha yu la'tapatsay. Chi an yu jalhistaknan laka malhticha, kajunikalh li kas'alaj tayalh. ");
INSERT INTO tpp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","K'as'alajnant'it, mu jant'u k'ats'ayat'iti tani wanancha kamina an yu jamacha'a', sna ta'oxay, u jaytatnan, u akxni t'asaycha puyux, u wats'isin. ");
INSERT INTO tpp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Para li jantu akxni laklht'at'ayat'iti wa puwalas kachilh. ");
INSERT INTO tpp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Chi ani klajunaw para lhichux, k'as'alajnant'it. ");
INSERT INTO tpp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wa la'at'uycha wilhchani ists'an'ay para kachilhcha ixpaku paxku chi ixk'atan pan yu jantu lhiyalh lhamaskajan. An xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin ixtalhipuxkawniycha tani katalhi'o'xcho'och'apayawlhcha an Jesús, para li katama'nilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Chi ixtalajuniy: ―Tukan laka k'atan jantu, para li jantu kach'ilili talaknawlh an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pero an Jesús, la'acha'an Betaniaja ixt'awnachalh, la ixcha'a Simón, yu ixlakap'uch'i'ojota la ixts'its'i, sa' ixwilh laka mesa. Walh cha'alh pumatam t'aku ixli'anta la'atam lhaklhi perjume la xafrasco sawalh k'usi, yu wanaj la'lhuw, a't'olhicha chi ukmuk'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Walh an ali'in talhitalh'amalh, tanajun: ―¿Tasu li wa lhitama'chapuycha an perjumeje? ");
INSERT INTO tpp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yucha layi ixlist'akalh tacha lhajay pumatam lapanak la'at'utu ciento wilhchan chi ixjamala'pitsinikalhcha an jakilhpatinin. P'ulu p'ulucha ixtalhichiwiniya an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero an Jesús jajuniy: ―K'amak'a'unt'itcha. ¿T'asu li ma'ach'ap'uyatcha?, li mu yucha oxi tacha an ki'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Uxitnan lhilhiji k'ajat'a'aklats'uk'uya'it'it an jakilhpatinin, layi k'ajaxt'a'niya'it tu'u akxni jaxt'a'nip'ut'unat'it, pero kit'in jantu lhilhiji akintilat'a'aklatsukuw. ");
INSERT INTO tpp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ani t'aku ilhtulhcha yu lay, mu la'asiyaj kilakamuk'alhcha an perjume para li akxni akimaknukana'. ");
INSERT INTO tpp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ani sawalhi an yu klajunaw, watanchuncha kalhichiwinkana ani laj'oxi chiwinti, chux lakamunulhpa, wachu kalhichiwinkana an yu ilhtulh ani t'aku', para li kalhipastakkalh. ");
INSERT INTO tpp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wachuncha an Judas Iscariote, xapumatam an ixpumakawt'uyk'an ixt'alhtanan an Jesús, jala'alhi an xalaj'ajin sacerdotejnin, chi jajuniycha li kajama'axta'niya an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pus yu'uncha akxni ta'alha'asmatlhi talaj'achalhcha, chi tajuniy li kataxta'niya tumin. An Judas ixlipuxkawniycha tani kalhima'axta'lhicha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xlila'atamcha wilhchan ixk'atan pan yu jantu lhiyalh lhamaskajan, akxni ma'nikancha jas'at'a borrego para paxku, an ixt'alhtanan an Jesús tajuniy: ―¿T'anisch'a lak'ask'in ak'aw jala'oxinin para li k'awaycha laka paxku? ");
INSERT INTO tpp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pus yucha jamala'achalhcha ixt'uyunk'an ixt'alhtanan, jajuniy: ―K'ap'inchi'it an la'acha'an, ch'i k'ap'axt'o'a'it pumatam lapanak yu lhi'anta ixkan la ix'uyuli', k'ach'a'o'aya'it. ");
INSERT INTO tpp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tan katanuyanta k'a'una'it an yu jamacha'a lapanak: An maestro najun: “¿Tanischa laka cha'a tan ajkat'alakwayna an kint'alhtanan ixlakata Paxku?” ");
INSERT INTO tpp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yucha katamasuniyan pulaktam aya cha'a talhman ixlitala't'uycha, sawalhcha oxi ilhtukanta, anch'ach'a k'ajala'oxinina'it para kitnan. ");
INSERT INTO tpp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pus ta'alhcha an ixt'uyunk'an ixt'alhtanan. Tacha'alhcha an la'acha'an, walh tala'cha'alhcha an lapanak, tacha an ixjajunita an Jesús, chi tamala'asijnilhcha ancha ixlakata an paxku. ");
INSERT INTO tpp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Akxni taputs'isilhcha jat'acha'alhcha an ixpumakawt'uyk'an ixt'alhtanan, ");
INSERT INTO tpp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","chi talaktawilhcha, tsukulhcha talakwajini an laka mesa, walh an Jesús jajuniy: ―Sawalhi ani yu aklajunaw, xapumatam yu uxitnani akima'axt'a'a', yu wachu kint'alakwayt'ajun. ");
INSERT INTO tpp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wachuncha tsukulhcha tala'ta'oxila'alhiy, chi atamj atamjcha talhisakmiy, tajuniy: ―¿Kit'in sna'? ");
INSERT INTO tpp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yucha jajuniy: ―Xapumatam uxitnan ani mimpumakawt'uyk'an, yu kint'atamaj'oy laka pulatoj. ");
INSERT INTO tpp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Sawalhi li an isTs'alh Lapanak ts'ajwi ti'an, tacha an lhits'o'muk'akanta, pero an lapanak an yu kama'axt'a'a an isTs'alh Lapanak kapulhik'atsaya'. Yucha palay oxi jantu ka'istsukulh. ");
INSERT INTO tpp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chi ixtalakwayt'ajunka, an Jesús xa'a'ilh a'xtam pan, xta'lhicha lhimala'puchajun chi la'ch'e'elhcha, jala'xta'nilhcha, jajuniy: ―K'a'utcha, ani kilakatunaj. ");
INSERT INTO tpp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Chi xa'a'ipalh vaso yu ixputajun xaxkan uva, wachu xta'palhi lhimala'puchajun, chi jaxta'nilhcha, tapulaj'otlhicha ixchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jajuniy: ―Ani kijak'alhni, yu sast'icha putamakawkan li ixluwk'ani ijkalhimaj'an kijak'alhni an tacha t'awkan. ");
INSERT INTO tpp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kit'in klajunaw yu sawalh, jantu ali akti'otlhi an xaxkan uva, sta akxni akcha'ana an tan ch'alhkatnan Dios, akxni ak'otcho'oya yu sast'i. ");
INSERT INTO tpp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Akxni talakmilhpa'olhcha la'atam milhpat, ta'alhcha an a'stitawk'a tan junkan Laka Olivojnin. ");
INSERT INTO tpp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","An Jesús jajuniy: ―Chaway ani jata'oxana wanaj akilamakaw'oyaw, mu ts'o'muk'akanta an la ixchiwinti Dios tan najun: “Akma'niya an yu jalhist'ak'a ixborregojnin, chi an ixborregojnin wanaj tilh katata'a'pitsi'oya'.” ");
INSERT INTO tpp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero akxni akla'awcho'oya kit'ini aklatap'ulhniyaw ak'ana xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wachuncha an Pedro juniy: ―Masi katamakaw'ojon, kit'in jantu. ");
INSERT INTO tpp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pus an Jesús juniy: ―Kit'in sawalhi yu ijkunan, ani katats'isiya akxni jantuka' a't'uy t'asay puyux, a't'utu k'anawna'a li jant'u k'imisp'ay. ");
INSERT INTO tpp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero yucha ali juniy: ―Masi k'ama'nik'a chi kit'in wachu, jantu aktimakajun. Chi an ali'in wachu chuni tajunilh. ");
INSERT INTO tpp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Wachuncha ta'alhcha tanchun tan jalakch'ananankanta tan junkan Getsemaní, jajuniy an ixt'alhtanan an Jesús: ―K'alakt'awlatka ani, kit'in ikti'an tapaynini'. ");
INSERT INTO tpp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ja'aylhi'alhcha an Pedro chi an Jacobo chi an Juan, walh tsukulhcha ta'oxila'alhiy. ");
INSERT INTO tpp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jajuniy: ―Sawalhcha ta'oxila'alhiya an kintak'atsan, wa tacha akniyacha ijk'atsan. Akilapakxaw ani, jant'u k'alaklht'at'at'it. ");
INSERT INTO tpp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lanancha ma'ati alh, lilijcha tatso'ottalh chi tamuntitachalhcha, tsukulhcha tapayniy, najun li sna ma layi kamala'pusunikalh an makxkay panch'e'ex yu ixmininita akxni. ");
INSERT INTO tpp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Najun: ―KimPay, kimPay, uxint'i jantu tu'u yu jantucha lay k'a'ilht'u. Ak'imala'xt'inunini ani ay lhima'alh'ajna, pero yu tacha uxint'i lak'ask'ini kawalh, jantu yu tacha kit'in iknajun. ");
INSERT INTO tpp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Walh akxni jala'cha'ancho'olh an ixt'alhtanan, ixtalaklhtatanancha, pus juniy an Pedro: ―Simón, ¿lht'at'ay? ¿Jantu layi masi wa tamcha hora ak'int'a'alhk'ujt'i? ");
INSERT INTO tpp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","K'ak'ujt'it ch'i k'at'ap'aynit, para li jant'u k'alhila'ts'int'anuk'ant'it li k'a'ilht'up'ut'ut yu jantu oxi. Mu an takuwin yucha ilhtuputuni yu oxi, pero an lakatunaj yucha yu jantu k'ut'ilh. ");
INSERT INTO tpp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A'tam ampalhi tapaynini an Jesús, wanajcha chuni nawpalh tacha an ixnajuntacha p'ulhnaj. ");
INSERT INTO tpp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Walh a'tamcha ixtalaklhtatanampalayi an ixt'alhtanan akxni jala'cha'ancho'opalh, mu wa sawalhcha ixjala'cha'an ilhtatapututk'an, chi jantucha ixtak'atsay tani katajunilhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ixli'a't'utucha jala'cha'alh jajuniy: ―¿Jast'aknant'awnatka ch'i laklht'at'ayatka'? Chilhcha panch'e'ex, an isTs'alh Lapanak kama'axta'kanacha la xmaknik'an an la'ma'lhta'alhinin. ");
INSERT INTO tpp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","K'alaj'ost'ayatcha, ka'awcha, jo' mintacha an yu akima'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ixchiwint'ajunka an Jesús, la'cha'alhcha an Judas, xapumatam an ixpumakawt'uyk'an ixt'alhtanan, ts'ananacha tat'acha'alhi ali'in lapanakni, ixtalaklhi'antacha ix'espadajk'an chi ixk'iwk'an. Yu'uncha an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an laktatanini ixtamala'achata. ");
INSERT INTO tpp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","An ja'o'xcho'onuj Judas la'asiyaj ixjajunitacha tani kajapumasuniyacha, ixjajunita: ―Yucha an akla'xtikilhtast'uk'a yu Jesús, k'ach'ap'ayawya'itcha chi k'alhip'ina'itcha. ");
INSERT INTO tpp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pus akxni la'cha'alhcha, juniy: ―Maestro, maestro. Chi la'xtikilhtastuklhicha. ");
INSERT INTO tpp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wachuncha t'o'cha tala'alhi an Jesús chi tach'apayawlhcha. ");
INSERT INTO tpp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero pumatam yu ancha ixma'yalh, xtalaj xa'axtulhi an ix'espada, xtalh akatuch'uk'up'uxli an ixma'tsuku xa'ay sacerdote. ");
INSERT INTO tpp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Chi an Jesús jajuniy: ―Wa t'ach'a wa p'uxk'awyatcha ja'alhawna t'ant'at li kilach'apayawputunaw, laklhit'ant'atcha mi'espadajk'an chi mink'iwk'an. ");
INSERT INTO tpp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Lhilhiji xaklala'cha'anaw xakmasuy an laka ay tajtan, walh akxni jantu kilach'apayajuw, pero wa xliyu li chuncha kajuna tacha an ts'o'muk'akanta la ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wachuncha tamakaw'olhi an ixt'alhtanan an Jesús, talakats'alalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero pumatam ts'alh ch'a'o'alhi'alh, ixla'axt'a'kanta laka sábana, walh tach'apayawlh, ");
INSERT INTO tpp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero ayputaxtumakawlhi an sábana, ix'alhalhanti osli. ");
INSERT INTO tpp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Talhicha'anilhcha an Jesús an yu tukancha xa'ay sacerdote, pus anchacha tata'ayxto'olh an ali'incha xalaj'ajin sacerdotejnin, chi an laktatanin, chi an xamaestrojnin lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","An Pedro wa ma'atcha ixch'a'o'alhi'anta sta ixpulakni an tan jalhi'ay la ixjatalakxtut an tukancha xa'ay sacerdote, chi ixjat'ala's'onwilhcha an yu ixtajalhistaknan laka tajtan. ");
INSERT INTO tpp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Walh an xalaj'ajincha sacerdotejnin chi ixchuxk'ancha an yu ancha ixtatanumanalh, ixtalhipuxkawniycha tani katalhima'nilhcha an Jesús, pero jantu tu'u ixtala'cha'aniniy yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mu ixluwk'ani yu ixtalhimuk'ay yu jantu sawalh, pero tacha an ixtalhimuk'ay jantu wa tami ixtanajun. ");
INSERT INTO tpp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wachuncha ali'in tatayalh, talhimuk'alhcha yu jantu sawalh, tanajun: ");
INSERT INTO tpp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Kitnan ik'alha'asmattawi tan najun: “Aklakt'ilhiya ani ay tajtan yu wa laka maka yawkanta, chi ixlila'at'utu wilhchan akla'oxicho'oya yu jantu wa laka maka yawkan.” ");
INSERT INTO tpp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero masi chuncha jantu wa tami tacha an ixtalhimuk'ay. ");
INSERT INTO tpp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pus an tukancha xa'ay sacerdote japujatayalhi ixtan'ajnik'an, chi lhisakmiycha an Jesús, juniy: ―¿Jant'u t'u'u k'at'ija'alht'ayan? ¿Tisuncha tacha ani talhimuk'ayani? ");
INSERT INTO tpp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yucha jantu ja'alhtayanalh. An tukancha xa'ay sacerdote a'tam lhisakmipalh, juniy: ―¿Uxint'i yu Cristo, isTs'alh Dios? ");
INSERT INTO tpp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Pus an Jesús alhtaylh juniy: ―Chun, kit'in. Chi kit'in yu ikminta juna wa tacha isTs'alh Lapanak akilala'ts'inawi akxni akpiktutawlanta an kimPay tan ch'alhkatnan, chi akxni akminanta an lakt'iyan laka jataputs'i. ");
INSERT INTO tpp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wachuncha an tukancha xa'ay sacerdote, la'lh'alhi an ixla'ch'it wa xliyu talh'amalhcha, chi najun: ―¿Tisu wa tiyuchacha ali ma'lhtask'iniyaw ali akintajunini? ");
INSERT INTO tpp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Alha'asmat'at'itcha tacha an wa aya juniy Dios. ¿T'asuch'a nawnat'iti? Pus ixchuxk'ani talakt'asa'olh, tanajun li ma kama'nikalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tsukulhcha tala'achujwayi an ali'in, chi tala'puch'ilhcha, ixtalakasamaycha, ixtajuniy: ―¡K'alhajachicha tichini muk'anincha! Chi an yu ixtajalhistaknan laka tajtan wachucha lo's lo's ixtala'xtisay. ");
INSERT INTO tpp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","An Pedro talaktsini ixt'awnachalh tan jalhi'ay, walh cha'alh pumatam t'aku ixma'tsuku an xa'ay tukan sacerdote, ");
INSERT INTO tpp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","pus la'ts'incha tan is'onwilh an Pedro, chi juniy: ―Uxint'i wach'u anch'a ixt'a'aklat'a'un an Jesús yu jamacha'a Nazaret. ");
INSERT INTO tpp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yucha najun ma jantu, najun: ―Jantu ijk'atsay t'uch'ini uniycha, kit'in jantu ikmispay. Walh taxtulh an tan putanukanachalh, asmat'a t'asaycha an puyux. ");
INSERT INTO tpp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Walh an t'aku a'tam sa' la'ts'impalayi an Pedro, pus jalakjuniycha an yu ancha ixtat'ajun: ―Ani wachu de yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero an Pedro a'tam nawpalay ma jantu sawalh. Pants'ik'ischa walh, an yu ancha ixtat'ajun a'tamcha tajumpalayi an Pedro: ―Chun sawalh, uxint'i de yu'uncha, mu uxint'i jamacha'a Galilea, ch'i wach'u ch'uni ch'iwiniy. ");
INSERT INTO tpp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pus akxni tsukulhcha wa aya najun, chi ixnajuncha li ma sawalh: ―Jantu ikmispayi an lapanak yu lhich'iwinat'it. ");
INSERT INTO tpp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Walh t'asalhcha an puyux ixli'a't'uycha, wachuncha pastaklhicha an Pedro tacha an ixjunita an Jesús: “Jantuka' a't'uyi katit'asalh an puyux, a't'utucha k'anawna'a li jant'u k'imisp'ay.” Pus sa'cha lhatapastaknani an Pedro, tsukulhcha alhun. ");
INSERT INTO tpp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sawalhka wats'isin, tata'ayxto'opalhcha an xalaj'ajin sacerdotejnin, chi an laktatanin, chi an xamaestrojnin lhamap'a'sin, chi ixchuxk'an an judiojnin yu ixtach'alhkatnan la ixla'acha'ank'an. Tach'ilhi'anilhcha an Jesús an Pilato. ");
INSERT INTO tpp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","An Pilato lhisakmiy, juniy: ―¿Uxint'i ixrejk'an judiojnin? Yucha alhtaylh juniy: ―Uxint'ich'a nawt'a'un. ");
INSERT INTO tpp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pus an xalaj'ajin sacerdotejnin ixta'alhtasuycha, pero an Jesús jantu tu'u ja'alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","A'tam lhisakmipalhi an Pilato juniy: ―Tacha an stak talhimuk'ayan, ¿jant'u t'u'u k'at'ija'alht'ayan? ");
INSERT INTO tpp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","An Jesús masi chuncha jantu k'is ja'alhtayanalh, pus an Pilato ixli'a'niycha. ");
INSERT INTO tpp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","An Pilato akxni k'atan ixjun ixmakajuni watichicha tach'in yu ixtask'ini an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","An laka pulach'in ixtanun pumatam tach'in ixjunkan Barrabás, ixjat'atanun ixkompañerojnin yu ixtat'ajama'nininta akxni tat'alasalh jamach'alhkatni. ");
INSERT INTO tpp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ts'anan tala'cha'alhi an Pilato, tajuniy li ma tacha a'tajcha ilhtuyi ka'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pus an Pilato jajuniy: ―¿Lak'ask'inat'iti li akmakawlh an ixrejk'an judiojnin? ");
INSERT INTO tpp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Chuncha jajunilh an Pilato mu yucha ixjak'atsaaniya li an xalaj'ajin sacerdotejnin xliyu ixtalhima'axta'niy an Jesús li wa ixtaxkajiy. ");
INSERT INTO tpp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wachuncha an xalaj'ajin sacerdotejnin tachiwiwalhi an lapanakni para li katajunilhi an Pilato li yucha an Barrabasi kamakawlh. ");
INSERT INTO tpp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pus akxni jaxa'alapalh an Pilato, jajumpalay: ―¿Pus t'asuch'a nawnat ak'ilhtulh an yu unat li ixrejk'an judiojnini? ");
INSERT INTO tpp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yu'uncha ixchuxk'ani talakt'asa'opalh tanajun: ―¡K'amakxt'ukmuk'acha laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","An Pilato jajuniy: ―¿Tisuncha tala'alhini ilhtuta? Pero yu'uncha wa palay p'as ixtalakt'asapalay ixtanajun: ―¡K'amakxt'ukmuk'acha laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pus an Pilato mu sa'cha ixja'ulaputuni an lapanakni tacha an ixtala'talh'amanta, jamakawnilhcha an Barrabás. Chi an Pilato lhinawlhcha an Jesús li kastakcha ta'ayna'lhi, xli'astan ma'axta'lhicha para li kamakxtukmuk'akalhcha. ");
INSERT INTO tpp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wachuncha an soldadojnin talhi'alhcha tan jalhi'ay junita an laka palacio tan tawlay jamach'alhkat, chi tat'alat'asanilhcha an ali'in ixt'asoldadojnink'an. ");
INSERT INTO tpp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tamala'ch'inilhcha xmumuw la'ch'it, chi tama'tanulhcha corona de jalhtukun. ");
INSERT INTO tpp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tsukulhcha tamat'asay ixtajuniy: ―¡K'ajama'alht'axt'uncha ixrejk'an judiojnin! ");
INSERT INTO tpp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chi ixtala'pana'acha laka aktiyak chi ixtala'achujwaycha chi ixtatatso'ottaniycha, chi ixtatapayniniycha. ");
INSERT INTO tpp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Akxni stakcha tamamaxani'olh, tamaxtunicho'olhcha an xmumuw la'ch'it chi tamala'ch'inicho'olhcha an yu ixla'ch'it tukan. Xli'astan talhi'alhcha tan tamakxtukmuk'alhcha laka cruz. ");
INSERT INTO tpp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pumatam lapanak yu ancha ixla'pust'ajun, wa tanuchilhka an la'acha'an, junkan Simón, jamacha'a Cirene, ixpayk'an Alejandro chi Rufo, ta'asi t'amalhi'anilhi an ixcruz an Jesús, ");
INSERT INTO tpp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","tanchun junkan Gólgota, nawputun la Ixla'pa'axi Sue'elukut. ");
INSERT INTO tpp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chi ixtama'ot'oputuncha jamaskajanti xaxkan uva yu ixtalhiyawnita mirra, pero jantu otlhi. ");
INSERT INTO tpp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Akxni tamakxtukmuk'alhcha an Jesús, an soldadojnin talamala'pitsilhcha an ixla'ch'it, wa ta'amanalh suerte, para li tuchini katalhi'alhcha atamj atamj. ");
INSERT INTO tpp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wats'isini tamakxtukmuk'alh, katacha las nueve. ");
INSERT INTO tpp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","An la ix'akpuxni ixtats'o'nitacha tuchini talhima'nilhcha, ixtats'o'nita: “IxRejk'an judiojnin”. ");
INSERT INTO tpp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Wachu jat'amakxtukmuk'akalh ixt'uyunk'an ja'alhawnan, ixtapiktutamincha ixjat'ayawkanta tan la ixcruzchak'an, lhilaxjama'xi chi tan oxi ixmaka'.  ");
INSERT INTO tpp_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ts'awjcha tapasalh tacha an najunta la ixchiwinti Dios, tan najunta: “Wa tachanu wa aycha ma'lhta'alhini wachu talhimalakxtulh.” ");
INSERT INTO tpp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yu ancha ixtala'pusa xkayajcha ixtajuniy chi wili, wilicha ixtatalakpayajuy. Ixtajuniy: ―¡Li k'a'ixlakt'ilhi tajtan, chi li wa la'at'utu wilhchan, k'a'ixla'oxich'o'ocha! ");
INSERT INTO tpp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Chaway k'ama'alht'axt'uk'acha mi'akstu, ch'i k'at'a'alht'a'ut'icha an laka cruz! ");
INSERT INTO tpp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","An xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an fariseojnin, wanajcha chuni ixtamamaxaniy, ixtajuniy: ―Ali'in jama'alhtaxtulh chi yucha jantucha layi ma'alhtaxtukan ix'akstu. ");
INSERT INTO tpp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Kata'alhtajulhcha an laka cruz an Cristo, xaRey Israel, kala'ts'inawcha, chuncha kakiklaka'iyawcha! Chi masi an yu anchacha ixjat'amakxtukmuk'akanta, wachu ixtamamaxaniya an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Atunkulhcha, taputs'isi'olhi chux an lakaat'un, sta las tres akxni ta'oxaycha. ");
INSERT INTO tpp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pus las trescha an Jesús, p'asi chiwinilh, najun: ―Eloí, Eloí, ¿lama sabactani? ―nawputun: KiDios, kiDios, ¿t'asu li k'imak'a'unt'acha? ");
INSERT INTO tpp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Akxni ta'alha'asmatlhi an yu ancha ixtayanalh, talajuniy: ―¡Jo'! T'asaniy an Elías. ");
INSERT INTO tpp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pumatam jats'alaj'alh, mala'ch'uch'uwalh la'atam wa tacha panimak laka vinagre, chi kinkach'imuk'alhcha ma'atam k'iw, para li kapuma'ot'ulhcha, chi jajuniy an ali'in: ―K'amak'a'unt'itcha, kala'ts'inawcha li kamina ma'alhtajunu an Elías. ");
INSERT INTO tpp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Walh an Jesús p'asi chiwimpalh, nilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wa akxni an la'ch'it yu ix'uk'alh an laka tajtan lht'it'in tapu'exli, aklht'uyi walh, an talhmani pu'a'taynichalh sta talaktsin. ");
INSERT INTO tpp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","An ixkapitank'an an soldadojnin oxi la'ts'ilh an Jesús akxni t'asalh chi niilh, pus najun: ―Chun sawalh, ani lapanak isTs'alhi an Dios. ");
INSERT INTO tpp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ali'in t'akunin wachu ani ixtayanalh wa ma'atcha ixtalaka'an. Ancha ixma'yalh an María Magdalena, chi an María yu ixnatik'an José chi Jacobo xalakat'ikt'i, chi pumatam t'aku yu ancha ixjat'ayapalh yucha an Salomé. ");
INSERT INTO tpp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ani t'akunin ixtach'a'o'ayi an Jesús chi ixta'a'tayjuy akxni ixt'awnachalh Galilea, chi ali'incha t'akunin yu wachu ixtat'a'anta Jerusalén ancha wachu ixtayanalh. ");
INSERT INTO tpp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tats'isilhcha, chi mu akxni ixmala'asijnikan para li kajastaknankana katunkunanta, ");
INSERT INTO tpp_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","an José, jamacha'a Arimatea jantu talhanan, la'alhi an Pilato, kiisk'inilhi an ixlakatunaj an Jesús. Mu yucha wachu ixpakxan'iya an ixlich'alhkat Dios, chi yucha wachu ay lapanaki ixjunita an tan ix'alin lakchiwinti laka ay junta. ");
INSERT INTO tpp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jantu ixliwilayi an pilato li ixnitacha an Jesús, pus t'asanilhi an ixcapitank'an soldadojnin chi lhisakmilhcha. ");
INSERT INTO tpp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","An capitán juniya li chun sawalh, pus an José makawnikalhcha an ixlakatunaj an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ixtamajutacha alhtam sábana, yuchacha pula'apamililh akxni ma'alhtajulhcha, chi maknulhcha tanchun ixtantilhpatakanta laktalhpa, an tan ixputanukan yawnilhcha aya chiwx. ");
INSERT INTO tpp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","An María Magdalena chi an María ixnati José tala'ts'ini tan maknukalh. ");
INSERT INTO tpp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","La'puslicha an wilhchan akxni jastaknankan, an María Magdalena chi an María ixnati Jacobo, chi an Salomé, takilaktamawlhcha laklhaklhi perjume yu kata'ana lakamuk'anin an ixlakatunaj an Jesús. ");
INSERT INTO tpp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pus xlila'atamcha wilhchan a'taynicho'olh samana, sawalhka wats'isin, ta'alhcha an tan aknuy Jesús, chi jask'unulhcha. ");
INSERT INTO tpp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Talajuniy: ―¿Tisiyuchacha akintama'osuniyan an chiwx an tan putanukani? ");
INSERT INTO tpp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Walh akxni tacha'alh, tala'ts'in mala'xtinukanta an aya chiwx. ");
INSERT INTO tpp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chi tatanuchalh tala'ts'in ch'up'e' wilh pumatam ts'alh, lhilaka oxi ixpa'xti an puta'aknun, wanaj lhmani an sut'ut'u ixla'ch'it, pus ixtalaktalhanancha. ");
INSERT INTO tpp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yucha jajuniy: ―Jant'u k'alakt'alhanant'it. Yucha an ka tamakxtukmuk'alh Jesús jamacha'a Nazareti p'uxk'awyat'it. Yucha la'awcho'olhcha, jantucha tu'u tanun. Jo' k'ala'ts'int'it, jantucha tu'u malh an tan ixtamamata. ");
INSERT INTO tpp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","K'ajak'i'unit'iti an ixt'alhtanan chi an Pedro, li an Jesús yucha katatap'ulhniyan ka'ana xalakaat'un Galilea, anch'a k'ala'ts'int'achi'it tacha ixtajuntancha. ");
INSERT INTO tpp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","An t'akunin so'ojo tataxtulh an tan ix'aknuy mu ixtalaktalhanancha, wa xk'ip'ip'icha ixtalay. Jantu k'is xamati tu'u ixtajuniy mu ixtalaktalhanancha.  ");
INSERT INTO tpp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mu ixla'awcho'otacha wats'isin an Jesús, yu xlila'atamcha wilhchan a'taynicho'olh samana, yucha an María Magdalenajcha p'ulhnaj talakasunilh, yu ixk'uch'uta akxni ixtala'apaxto'ta la'atujun makxkay'un. ");
INSERT INTO tpp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pus yucha alh jamak'atsanini an ixt'alhtanan an Jesús, tan ixtalhita'oxila'alhiy chi ixtalhi'alhun. ");
INSERT INTO tpp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Akxni ta'alha'asmatlhi an María Magdalena, li la'ajunta an Jesús chi li la'ts'ilh, jantu takiklaka'ilh. ");
INSERT INTO tpp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","La'puslicha panch'e'ex, an Jesús tamcha jalhitalakasunipalh ixt'uyunk'an ixt'alhtanan, akxni ixtat'ajun tanchun laka tij, ma'spa an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Chi yu'uncha wachucha tat'alajunilhi an ali'in ixt'alhtanank'an, walh wachu jantu jakiklaka'ikalh. ");
INSERT INTO tpp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Xli'astan jatalakasunilhcha an Jesús an ixpumakawtamk'an ixt'alhtanan akxni ixtalakwilanan'olh laka mesa, chi jalaj'aymalhi mu jantu ixtat'alakiklaka'iya an ali'in li ixtala'ts'intacha li ixla'awcho'otacha, mu sawalhcha lakt'ak'alha ixtajuninita an ixjalhunutk'an. ");
INSERT INTO tpp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Chi jajuniy: ―K'ap'inchi'it'iti ta ixlijalhi'ay an lakamunulhpa chi ixchuxk'ani k'ajalak'unit'it an lapanakni an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yu kakiklaka'iya chi ka'a'paxa, kata'alhtaxtuya'. Pero yu jantu katikiklaka'ilh, kala'a'iya lhima'alh'ajna. ");
INSERT INTO tpp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chunchuniya katamasuya an yu tajakiklaka'inin: layi katak'uch'uya la kinta'a'ut an yu wa tala'apaxt'o'a makxkay'un, chi layi katachiwinina tipalhuw tumpaj chiwinti. ");
INSERT INTO tpp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Layi katach'apayanta tsapulin, chi masi kata'otlhi veneno, jantu katitalhinilh; katalakpach'apaya an ta'an'anin, chi katatak'uch'uya'. ");
INSERT INTO tpp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Xli'astan jaxa'ala'olh an jamach'alhkat Jesús, lhi'ankalhcha an lakt'iyan, piktutawlhchalhcha tan oxi ixpa'xti an Dios. ");
INSERT INTO tpp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Chi yu'uncha an ixt'alhtanan tataxtunilhcha talhichiwiniy an ixchiwinti Dios, ta ixlijalhi'ay, chi an jamach'alhkat Jesús ixja'a'tayjuycha, ixjamasuniycha an lapanakni li an ixchiwinti Dios sawalh, tacha an ixtala'ts'incha yu la'lhi'a'nin tanlhun ixlaktapasay. Chunchacha kawalh.");
INSERT INTO tpp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ixluwk'ancha yu ta'a'taynita tats'o'a tani laktapasalhcha an tanlhun yu k'atsayaw kitnan li sawalh, ");
INSERT INTO tpp_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","tacha an kintalakmasunin yu la ixla'chulhk'an tala'ts'ilh akxni a'taynichalh. Chi mu yu'uncha jalhimap'a'sikalh li katalaknawlh an chiwinti, ");
INSERT INTO tpp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","kit'in wachu oxi iklhiwilay, mu oxicha ixlak'anti iklhakapu'alh chux an tanlhun, tanchuncha pu'a'taynichalh. Pus chawayi Teófilo uxint'i mu ayk'at'i lapanak akts'o'niyani ixlakata ani tanlhun tanischa yu pu'aklaminchalh. ");
INSERT INTO tpp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Para li oxi k'ak'ats'at'i an yu sawalh t'ach'a an masunik'ant'acha. ");
INSERT INTO tpp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Akxni ixjunita rey an Herodes, xalakaat'un Judea, ixt'ajun pumatam sacerdote ixjunkan Zacarías ixjat'atala'xt'o'a an Abías. Chi yu ixt'iwi ixjunita Elisabet ixjunkan, ixt'alalhila'ts'i an Aarón. ");
INSERT INTO tpp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","An ixt'uyunk'an oxi ixtat'ajun la ix'ukxlakapu an Dios, chi ixta'ilhtuy sawalhi an ixlamap'a'sin an Dios chi yu ixjalhijuniy kata'ilhtulh, pus jantu xamati lay tu'u ixjalhimuk'ay. ");
INSERT INTO tpp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero jantu ixtalhit'ajuniy ixjas'at'ak'an, mu an Elisabet jantu lay ixjamas'at'anan, chi an ixt'uyunk'an laj'ajincha ixtajunita. ");
INSERT INTO tpp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Walh milh wilhchan akxni yucha an Zacarías ixtapatsat'ajun ixlisacerdote la ix'ukxlakapu an Dios, chux ali an yu ixjat'ata'ayxt'o'a, ");
INSERT INTO tpp_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ta'amanalh suerte chi yucha la'cha'alh li kala'xawalh an cencia, tacha ixtalhilaniycha an sacerdotejnin. Pus tanulhcha an Zacarías tan wa lhilakatijtam ma'axta'nikan lha'ulan an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chi chux an lapanakni ma'spacha ixtatapaynit'ajun akxni ixla'xawat'ajuncha an cencia. ");
INSERT INTO tpp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Walh talakasunilh pumatam ix'angelh an Diosi an Zacarías, sa'cha ixyalh tan oxi ixpa'xti an tan ma'axta'kan lha'ulan tan ixla'xawat'ajun an cencia. ");
INSERT INTO tpp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pus an Zacarías akxni la'ts'ilh an angelh talhanalh. ");
INSERT INTO tpp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero an angelh juniy an Zacarías: ―Zacarías, jant'u k'at'alhan, mu amintapaynit asmatnik'acha, chi amint'iwi Elisabet kaxta'niyan pumatami mints'alh, Juan k'a'ulaniya'a ixta'a'ut. ");
INSERT INTO tpp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sawalhcha oxi k'alhiwilaya'a, k'a'ach'ana'a, chi ixluwk'ani yu sawalhcha katalaj'achana akxni katsukuyacha. ");
INSERT INTO tpp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mu ayi kajuna la ix'ukxlakapu Dios. Jantu kati'otlhi xaxkan uva chi k'uch'u, sawalhcha kalhitsukuya an ixTakuwin Dios, masi palaktajunka an ixnati. ");
INSERT INTO tpp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ka'ilhtuya li ixluwk'an an jamacha'an Israel, katakiklaka'ilhi an Dios, yu ixJamach'alhkatk'an. ");
INSERT INTO tpp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chi an Juan katap'ulhniya an Cristo kalhichiwinina an ixchiwinti Dios la ixTakuwin an Dios, chi la ix'alhp'asninti an Elías, para li an xalakpaynin katat'ala'oxamixnicho'olhcha an ixjas'at'ank'an, chi an yu jantu k'is taja'asmatnan kataja'asmatnalhcha tacha an yu taja'asmatnan, para li akxni kachina an Jamach'alhkat taja'asmatnancha kajala'china'. ");
INSERT INTO tpp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","An Zacarías juniy an angelh: ―¿Tasucha aklhik'atsaalh li sawalhi an yu k'i'uniya? Mu kit'in ik'aycha chi an kint'iwi wachucha ay. ");
INSERT INTO tpp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","An angelh alhtaylh juniy: ―Kit'in ijGabriel, la ix'ukxlakapu an Diosi ikt'ajun. Yucha kimala'achatachalh para li akmin mak'atsaaninin ani laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ch'away jant'u lay k'at'ich'iwin, sta akxni chunchacha katapasaya', mu jant'u k'ink'iklak'a'it'i tacha an ijkunan li katapasaya akxni kachinacha ixpanch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","An lapanakni sa'cha ixtapakxanta an Zacarías, jantucha ixtalhimacha'xayi tuchini jantucha so'oj ixlitaxtuy an laka tajtan. ");
INSERT INTO tpp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Walh akxni taxtulhcha, jantucha lay ixjaxa'alay, pus talhimacha'xanilhcha li tu'u talakasunilh an laka tajtan. Wa ixjatamakyawniycha, chunchacha taylhi'alh jantucha lay ixchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Akxni la'tsalhcha wilhchan yucha ixtapatsat'ajun ixlisacerdote, ancho'olhcha ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ixli'astan an Elisabet an ixt'iwi an Zacarías, ja'aynalhcha, pus la'akisi malhkuyu jantucha ixtaxtuy la ixcha'a', ixnajun: ");
INSERT INTO tpp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“An Dios oxi lapanak, chaway kima'osunilhcha an maxanti xaklhit'ajun la ix'ukxlakapuk'an an ali'in.” ");
INSERT INTO tpp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ixlila'achaxancha malhkuyu, an Dios mala'achalh an ix'angelh yu junkan Gabriel tanchun la'acha'an xalakaat'un Galilea junkan Nazaret, ");
INSERT INTO tpp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tan ixwilh pumatam jatsi ixjunkan María, jantuka' ixt'atsukukan, pero isk'in'ulakantacha pumatam ts'alh ixjunkan José, ixt'alalhila'ts'i an rey David. ");
INSERT INTO tpp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pus an angelh tanuchalhi tan ixwilh an María, juniy: ―¡Sawalhch'a map'aynik'an! An Dios lhistaktan, chux tacha an tat'ajun an t'akunin, uxint'i sawalhch'a oxi la'ts'ink'an. ");
INSERT INTO tpp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Akxni chunchacha alha'asmatlhi chi chunchacha la'ts'ilh an María an angelh, jantucha ixlimacha'xaniy tuchi jala'axa'alanticha tacha an junilh, ixtalhanancha. ");
INSERT INTO tpp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pus an angelh juniy a María: ―Jant'u k'at'alhan, mu an Dios oxi lhiwilayan. ");
INSERT INTO tpp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chaway k'ap'akxana'a mijas'at'a, k'alhits'uk'uya'a pumatam mints'alh, chi k'a'ulaniya'a ixta'a'ut JESÚS. ");
INSERT INTO tpp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yucha ay lapanaki kajuna', chi isTs'alh yu wilhchalh talhmani kajunkana'. An Jamach'alhkat Dios, Reje ka'ilhtuya tacha an David yu ma'anchacha ta ixlila'ts'in. ");
INSERT INTO tpp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yucha ixpujun'alhincha kajach'alhkatnaniya an ixlapanakni Jacob, jantu a'tam katimin'olhi an ixlich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wa chuncha an María alhtaylh an angelh juniy: ―¿Pero tasicha li jantuka' ikt'at'awkani? ");
INSERT INTO tpp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","An angelh alhtaylh juniy: ―Yucha an Stalan'a Takuwini kala'chinan, chi an ix'alhp'asninti an yu wilhchalh talhman Dios kamatanchaniyan la ixma'stele', xliyu an stalan'a jas'at'a katsukuya, isTs'alh Diosi kajunkana'. ");
INSERT INTO tpp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","An mint'alalhila'ts'i Elisabet, an yu ixtajuniy li jantu lay jamas'at'anan wachu kalhitsukuya pumatam ists'alh masi yucha nanacha, la'achaxancha malhkuyu chaway yucha pakxanta. ");
INSERT INTO tpp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mu an Dios yucha jantu tu'u yu jantucha lay ka'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pus akxni an María najun: ―Kit'in ixma'tsuku an Dios. Kachajcha walhi la kijatsukunti t'ach'a an k'i'uniy. Pus an angelh akxni ancho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Alhcha lakats'uniya panch'e'ex, an María sawalhcha so'oyi alh tanchun a'stitawk'a la'acha'an, xalakaat'un Judá, ");
INSERT INTO tpp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","walh tanuchalhcha la ixcha'a an Zacarías, pus la'axa'alaycha an Elisabet. ");
INSERT INTO tpp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Walh akxni asmatlhicha an Elisabet li la'axa'alay an María, an ixpalaktajun ixjas'at'a an Elisabet jalht'ujnulh. Chi wanajcha la'tanu'olhi an Elisabet an Stalan'a Takuwin, ");
INSERT INTO tpp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","pus p'ascha chiwiniy najun: ―Chux an t'akunin, uxint'i sawalhch'a map'aynik'an chi an palaktajuman mijas'at'a. ");
INSERT INTO tpp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tasu li kit'incha kila'minta pixiyalhna an ixnati kiJamach'alhkati? ");
INSERT INTO tpp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mu wa tacha ik'alha'asmatni k'ila'axa'alat'i, sawalhcha achaniy jalht'ujnulh la kimpalakni an jas'at'a. ");
INSERT INTO tpp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sawalhcha oxi para uxint'i li k'iklak'a'it'i yu junin an Dios, mu chuncha katapasaya'. ");
INSERT INTO tpp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Wa chuncha an María najun: La kintak'atsaan ijkuniya an Dios li yucha ay. ");
INSERT INTO tpp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chi an kiJama'alhtaxtunuj Dios ma'an'achayi an kintakuwin, ");
INSERT INTO tpp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","mu yucha lhakapu'alhi masi wa ixjakilhpatinij ma'tsukucha. Chaway, sta chaway chux tacha an kala'aw'ankana katanawna li sawalhcha oxi yu ikputapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mu an yu lay ilhtu'ojoy wa tuchicha, laj'ay tanlhuni pu'ilhtut'ajun an kijatsukunti. Yucha Stalan'a junkan. ");
INSERT INTO tpp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chi tacha an la'aw'ankanta yucha si mapayniya yu kiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yucha laj'ay tanlhuni ilhtulh la ixmaka'. Ilhtulhi li jantu kawalhi tacha an ixtapast'ak'a an yu wa talaj'ayajk'atsay. ");
INSERT INTO tpp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jamaxtunilhi an ixlich'alhkatk'an an laj'ajin jamach'alhkatni, yu'uncha an wa tajakilhpatinijk'atsayi xalaj'ajin ja'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","An yu ixtalakchawaniy jaxta'nilhi yu ixtama'lhtask'iniy. Chi an jamatuminin wanaj jamaxtuni'olhi ixtanlhunk'an, wachunchacha jamala'achacho'olh. ");
INSERT INTO tpp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ja'a'tayjulhi an jamacha'an Israel, yu'uncha tacha ixma'tsukunin, jantu kapmaj'alhi an ixjamapayninti ");
INSERT INTO tpp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","tacha ixjajunita an kilakpaynink'an. Masunikalhcha an jamapayninti an Abraham chi an yu katapu'a'p'un'ana', mu ixpujun'alhincha. ");
INSERT INTO tpp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","An María t'atamakawlhi an Elisabet la ixcha'a ka tacha la'at'utu malhkuyu'. Ixli'astan ancho'olhcha la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Akxni cha'alhcha wilhchan lhitsukulh ixjas'at'a an Elisabet, ts'alhi lhitsukulh. ");
INSERT INTO tpp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Chi an yu waniy ixjat'awilh chi an ta ixjalhila'ts'in talakcha'alhcha akxni tak'atsaalh, sawalhcha tat'alaj'achan, mu an Dios masunilhi an Elisabet an ay ixjamapayninti. ");
INSERT INTO tpp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","La'atsajincha wilhchan cha'alh, talhi'alhcha an jas'at'a tan akaxwililich'uk'up'uxkalh ix'a'axt'a'a. Chi tacha an junkancha ixpayi ixtalhimapa'a'uputun, ma Zacarías. ");
INSERT INTO tpp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero an ixnati jajuniy: ―Jantu, jantu chuni junkan, kajunkana Juan. ");
INSERT INTO tpp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pus ta'alhtaylh tajuniy: ―¿Tasu'u? Jant'u xamat'i t'a lhila'ts'in yu chuncha junkan. ");
INSERT INTO tpp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pus wa chuncha tatamakyawniycha an ixpay an jas'at'a tani jumputuncha yucha. ");
INSERT INTO tpp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yucha jask'inilh lakat'ikt'i lht'a'alak'iw chi anchacha ts'o'lhi, najun: “Juan, junkan.” Pus sawalhcha ixtalhi'a'niy. ");
INSERT INTO tpp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","K'ak'i 'it an yu onta cha ja s'a t'a to ro chi k'am a' ni t'it cha, kala k'uyaw, ka'ilh tuyaw k'a tan. ");
INSERT INTO tpp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ixchuxk'an an yu waniy ixjat'awilh sawalhcha ixtalaktalhanan, chi ta ixlijalhi'ay an ixla'a'a'stitawk'an Judea ixlaknawkancha tacha an tapasalh ");
INSERT INTO tpp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yu ixta'asmat'a ixtapast'ak'a: ―¿Tisuncha ixlijunti kajuna ani jas'at'a? Mu an Dios ixlistakta an jas'at'a. ");
INSERT INTO tpp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","An Zacarías, an ixpay an jas'at'a, la'chilhi an Stalan'a ixTakuwin Dios chi manawnilhi yu katapasaya', najun: ");
INSERT INTO tpp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Lhimala'puchajuncha an Dios ixJamach'alhkat Israel, mu jala'pixiyalhnalhcha an ixlapanakni, chaway jama'alhtaxtulhcha. ");
INSERT INTO tpp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kintamakminincha pumatami yu lay jama'alhtaxtunun, pumatam yu ta lhila'ts'in an David, an ixma'tsuku Dios. ");
INSERT INTO tpp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tacha an ixjamanawnita an la'stalan'an ixlapanakni yu ixtalhichiwiniy ixchiwinti ma'anchacha, ");
INSERT INTO tpp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","li akintamala'xtinuniyani an yu sawalh kintaxkayan chi an yu jantu k'is kintala'ts'imputunan. ");
INSERT INTO tpp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Li kapast'ak'a tacha an ixjat'atamakajunta laka laj'oxi ixchiwinti an yu japu'a'p'unmincha'aw, li kajalhi'a'tayjuya'. ");
INSERT INTO tpp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","An kimpayk'an Abraham jurarlanikalh, tan junkan: ");
INSERT INTO tpp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Li ka'ilhtuya an Dios katsukuyaw jantucha xamati akintitaxkayajla'ts'in, li kinta'achaninchak'ani kat'atapatsayaw, ");
INSERT INTO tpp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","laka la'stalan'a jatsukunti chi laka laj'oxi lanti la ix'ukxlakapu', chux wilhchan la kijatsukuntik'an. ");
INSERT INTO tpp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chi uxint'i kints'alh, uxint'i kapuchiwininan an yu talhman wilhchalh, mu k'at'ap'ulhniya'a an Jamach'alhkat para li k'ala'oxinin an ixtij. ");
INSERT INTO tpp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","K'ajamak'ats'aaniya'a an ixlapanakni li yucha jamala'mixiniya ixtala'alhink'an para li katata'alhtaxtulh. ");
INSERT INTO tpp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mu an kiDiosk'an ay jamapayninti lhit'ajun, an lakt'iyan la'atam jatapulhkunu akintamapulhkuniyan. ");
INSERT INTO tpp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kajamapulhkuniya an yu lakaaputs'isni tat'ajun chi an yu la ixma'stele' lhinin tat'ajun. Akintapulhi'anani tan oxi tij. ");
INSERT INTO tpp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","An jas'at'a tacha ixta'ayay, wachu palay k'ut'ilhi ixjun la ixtakuwin. Chi tan jantu la'acha'ani ta'ayalh sta akxni tsukulhcha jalhixa'alay an ixchiwinti Dios an israelitajnini talakasulh tan lhilhuw. ");
INSERT INTO tpp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lanancha alhi panch'e'ex ixlila'ajunta an jama'paxanaj Juan, an ay xajamach'alhkat Roma ixjunkan Augusto César, lhinawlh li kasakkalh censo ta ixlijalhi'ay an Roma. ");
INSERT INTO tpp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ani p'ulhnaj censo sakkalh, akxni gobernador ixjunita an Cirenio xalakaat'un Siria. ");
INSERT INTO tpp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Atamj atamjcha ixta'an tats'o'nin tanchuncha la ixla'acha'ank'an. ");
INSERT INTO tpp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Xliyu an José taxtulhi Nazaret, xalakaat'un Galilea, chi alhcha Belén, xalakaat'un Judea, la ixla'acha'an an rey David yu ma'anchacha ta ixlila'ats'in an José. ");
INSERT INTO tpp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Anchacha ta'alh tats'o'nin an José ali a María tacha ixt'iwicha, pero jantuka' ixt'at'ajun. A María ixja'aynantacha. ");
INSERT INTO tpp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","An la'acha'anka Beleni ixtat'ajun, walh cha'alhcha wilhchan li a María kata'oxiyacha. ");
INSERT INTO tpp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pus anchacha lhitsukulh yu p'ulhnajcha ixjas'at'a, pasmililhcha la ixtipa'at chi p'ilikscha mamalh tan ixjamawakan jatapakxat, mu jantucha inta ixjunita yu para yu'uncha tan laka cha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Waniycha ancha lanan tan wa jalhi'ay, ixtat'ajun yu ixtalhist'ak'a ixborregojnink'an puts'ista. ");
INSERT INTO tpp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Walh jatalakasunilh an ix'angelh an Dios. Xlimjcha jamapulhkunilhi tuntala'acho'o an Dios, pus sawalhcha talaktalhanalh. ");
INSERT INTO tpp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero an angelh jajuniy: ―Jant'u k'alakt'alhanant'it, kit'in iklalhiminitaw laj'oxi chiwinti, yu oxi k'alhiwilaya'it'it chi ixchuxk'an an ali'in. ");
INSERT INTO tpp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chaway tsukulhcha an la ixla'acha'an David yu katama'alhtaxtuniyan, yucha an CRISTO, yucha Jamach'alhkat. ");
INSERT INTO tpp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chunchuniya k'ap'ula'ch'ip'ina'it'it an jas'at'a: K'ala'ch'ip'ina'it'it tan pasmilhmakanta la ixtipa'at tan jamawakan jatapakxat. ");
INSERT INTO tpp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wa akxni, lhuw angelhnin yu tat'ajun an lakt'iyani tat'atalakasulh an angelh, ixtalhilakmilhpaycha an Dios, ixtanajun: ");
INSERT INTO tpp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡An Dios ayi an talhman chi an lakaat'un. Oxi sa' ja'ulay an yu tala'a'iy an ixjamapayninti! ");
INSERT INTO tpp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Akxni ta'ancho'olhcha an angelhnin lakt'iyan, an yu ixtalhist'ak'a ixborregojnink'an talajuniy: ―Ka'awi sta Belén, ka'aw la'ts'inini an yu kintamak'atsaanin an Dios li tapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pus watukan ta'alh, p'asi ta'alh. Walh tala'cha'alhcha an María chi an José, chi an jas'at'a sa'cha ixmalh an tan tawajin jatapakxat. ");
INSERT INTO tpp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Akxni tala'ts'ilhcha an jas'at'a, tanajuncha tani ixjalhixa'alakantacha. ");
INSERT INTO tpp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pus ixchuxk'an an yu ta'asmatlhi, sawalhcha talhi'a'nilhi tacha an tanawlh an yu ixtalhist'ak'a ixborregojnink'an. ");
INSERT INTO tpp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero a María yucha wa la ixjalhunutcha sa' ixlatapastaknan'ojoy chux tacha an ixlaktapasay. ");
INSERT INTO tpp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","An yu ixtalhist'ak'a ixborregojnink'an ta'ancho'olhcha, oxicha talhilakchiwij'alh an Dios chi ixtaxta'niycha lhimala'puchajun, xliyu li tacha an tala'ts'ilhcha chi tacha an ixta'asmattacha, mu chunchacha ixjajunkanta. ");
INSERT INTO tpp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Akxni ilhtulhcha la'atsajin wilhchan an jas'at'a, akaxwililich'uk'up'uxkalhcha ix'a'axt'a'a, chi Jesuscha junikalh, tacha ixnajunta an angelh li kajunkana' akxni jantuka' istsukuy. ");
INSERT INTO tpp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chi akxni ta'a'tsalhcha wilhchan para li laycha kata'alh stalan'ancho'onin an ixpay chi an ixnati an Jesús, tacha najun an ixlamap'a'sin Moisés, an José chi an María ta'alhcha Jerusalén malakasuninin an Dios an jas'at'a. ");
INSERT INTO tpp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chunchacha ta'ilhtulh mu an la ixlamap'a'sin an Dios chuncha ts'o'muk'akanta tan najunta: “Yu p'ulhnaj katsukuya jas'at'a li ts'alh, yucha an Diosi kama'axta'nikana'.” ");
INSERT INTO tpp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chi para li katastalan'ancho'olhcha tacha an najunta la ixlamap'a'sin an Dios, kalhi'ankalh la'at'uy tuluway u la'at'uy s'apantin, yuchacha kajama'nikalh. ");
INSERT INTO tpp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Akxni chuncha tapasalh, ixt'ajun pumatam lapanak an Jerusalén ixjunkan Simeón, sawalh ixjakiklaka'inin chi oxi lapanak, ixpakxan'iya li an xalapanakni Israel katata'alhtaxtulh. An Stalan'a Takuwin ixt'a'aklat'ajuni an Simeón, ");
INSERT INTO tpp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","pus ixjunita li jantuka' katinilhi li jantuka' la'ts'ini an Cristo yu yucha an Jamach'alhkat Dios kamala'achayanta. ");
INSERT INTO tpp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","An Stalan'a Takuwin ilhtulhi li an Simeón ka'alhi an laka tajtan. Walh akxni, an ixpaynin an Jesús talhicha'alhcha an laka tajtan, para li kata'ilhtuyacha tacha an najun laka lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","An Simeón jama'lhtaylhi an jas'at'a chi xta'nilhcha lhimala'puchajuni an Dios najun: ");
INSERT INTO tpp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Chaway chuni Jamach'alhkat, tapasalhcha t'ach'a an xak'i'unit'a, chaway lhi'achacha ak'imak'aw li ajkastaknalhcha, mu kit'in mima'tsuku'. ");
INSERT INTO tpp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chaway ikla'ts'ilhcha an mimpama'alhtaxtun, ");
INSERT INTO tpp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ta kilhmakchux lapanakni tala'ts'incha li mala'asijnit'acha. ");
INSERT INTO tpp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yucha tacha jatapulhkunu', kajaxa'ala'oya ta kilhmakchux an lapanakni, chi an xalapanakni Israel laj'ajini katapujuna'. ");
INSERT INTO tpp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tacha an ixlichiwint'ajun an Simeón an Jesús, sawalhcha ixtalhi'a'niya an ixpay chi an ixnati. ");
INSERT INTO tpp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chi an Simeón tapayninilhcha an Dios para li oxi katatsukulh. An Simeón juniy an María: ―Ani jas'at'a lhimakminkanta para li ixluwk'ani katata'a'talh u ixluwk'ani kata'ostayalh an xalapanakni Israel. Chi ixluwk'ani yu jantu k'is katitala'ts'imputulh. ");
INSERT INTO tpp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Pus chunchacha kapuk'atsakana tanischa tajatapastaknan an lapanakni. (Uxint'i tachanu wanaj an la mintak'atsani kapala'pusa espada.) ");
INSERT INTO tpp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wachu ancha ixt'ajun pumatam t'aku ixjunkan Ana, istsi Fanuel, ixt'alalhila'ts'i an Aser, ixlichiwiniy ixchiwinti an Dios. Nanacha ixjunita. Lakat'ikt'ika lanani t'atsukukalh, pero cha'alh la'atujun k'ata ixt'at'awkan nimakawtijlakalh. ");
INSERT INTO tpp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pus t'at'ip'uxamt'at'i (84) k'ata wa ix'akstucha ixt'ajun. Jantucha ixtaxtuyi an laka tajtan, wa anchacha ixt'atapatsay an Dios, ixlitask'ajayi ixwayt, chi tunkuw chi ts'isi ixtapayniy. ");
INSERT INTO tpp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","An Ana jala'cha'alhi akxni ancha ixtayanalh, tsukulhcha xta'niya lhimala'puchajun an Dios, chi ixjalhixa'alaycha an jas'at'a ixchuxk'an an yu ixtapakxan'iy li an Jerusalén kata'alhtaxtulh. ");
INSERT INTO tpp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Akxni taki'ilhtu'olhcha tacha an najunta la ixlamap'a'sin an Jamach'alhkat, ixli'astan ta'ancho'olhcha ixla'acha'ank'an Nazaret, xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","An jas'at'a tachapuncha tsukulh ta'ayay, sawalhcha tsukulh jalakpastaknan chi an Dios ixmapayniy, ixlist'ak'a. ");
INSERT INTO tpp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","An ixpaynin an Jesús chux k'ata ixta'an Jerusalén la ixk'atan paxku. ");
INSERT INTO tpp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Akxni la'tsalhcha la'akawt'uy k'ata an Jesús, ta'alhi k'atan Jerusalén tacha ixlismanikantacha, ixchuxk'ani ta'alh. ");
INSERT INTO tpp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Akxni tamincho'ochalhcha, mu la'ochalhcha an k'atan, tamakawchalhi an Jesús Jerusalén, jantu talhakapu'ani an ixpaynin. ");
INSERT INTO tpp_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ixtanajun li sna inta ma'minta, tam wilhchancha tajalhtanalh. Walh akxni tapuxkajuycha tan ixtalakminta yu ta talhila'ts'in chi yu tat'alamispay, ");
INSERT INTO tpp_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jantu tala'cha'alh, pus ta'ampalhi Jerusalén puxkawnin. ");
INSERT INTO tpp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La'at'utucha wilhchan walh, laka tajtani tala'cha'alh, sa'cha ixjapujawilh an yu ixtamasuy lhamap'a'sin, ixja'asmatniycha chi ixjalhisakmiycha. ");
INSERT INTO tpp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ixchuxk'an an yu ixta'alha'asmat'a an Jesús sawalhcha ixtalhi'a'niniya an ixjatapast'ak'at chi tacha an ixja'alhtajiy. ");
INSERT INTO tpp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Akxni tala'ts'ilhcha an ixpaynin ixtalhi'a'niycha, an ixnati juniy: ―Kints'alh, ¿tasu li chunchacha kila'ilhtuyawi? Aminpay chi kit'in jantucha oxi ijk'atsanaw li jantucha lay xaklalhitajuyaw. ");
INSERT INTO tpp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","An Jesús jajuniy an ixpaynin: ―¿Tasu li kilapuxkawyawcha, ch'u jant'u k'ats'ayat'iti li an la ixcha'a kimPayi lhitask'iniy aktawilh? ");
INSERT INTO tpp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yu'uncha jantu talhimacha'xanilhi tacha an jajunilh. ");
INSERT INTO tpp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wa chuncha, jat'ataju'ancho'olhcha la'acha'an Nazaret an ixpaynin chi taylhi'alhi ixja'asmatniy yu ixtajuniy. An ixnati an Jesús wa ixma'a'ojoycha la ixjalhunuti tacha an ixla'ts'in. ");
INSERT INTO tpp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","An Jesús tacha ixta'ayay wachu palay ixjalakpastaknan, chi an Dios ixmapayniy chi an lapanakni wachu ixtamapayniy. ");
INSERT INTO tpp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","La'akawkisicha k'ata ixch'alhkatnant'ajun an ay jamach'alhkat Tiberio, akxni gobernador ixjunita an Poncio Pilato, xalakaat'un Judea. Chi an Herodes ixch'alhkatnan xalakaat'un Galilea, chi an ixt'ala'ajun junkan Felipe ixch'alhkatnant'ajun xalakaat'un Iturea chi Traconite. Chi an Lisanias ixch'alhkatnan xalakaat'un Abilinia. ");
INSERT INTO tpp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chi akxni xalaj'ajin sacerdotejnin ixtajunita an Anás chi an Caifás, an Dios xa'alalhi an Juan, ists'alh Zacarías, tan wa la'asa'nik'a. ");
INSERT INTO tpp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pus yucha alhcha ta'a'cho'onu an lakaat'un yu waniy an ayxkan Jordán ixlaklhitamakawniy, ixjajuniy an lapanakni li katamapaxalhcha ixjatapast'ak'atk'an, chi li kata'a'paxlicha para li an Dios kajamala'mixinilhi ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tapasalhcha tacha an ts'o'muk'akanta laka libro an ixchiwinti Isaías yu ixlichiwiniy ixchiwinti Dios, tan najun: P'asi chiwinkan an tan jantu la'acha'an, nawkan: “K'amala'asijnit'itcha an ixtij an Jamach'alhkat. K'ala'ts'awalanitcha an tan kapumina'. ");
INSERT INTO tpp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tan wa japulh'ot'alh kajat'ap'ujununkana', chi tan lakaa'a'stitawk'an ja'o'spiti ka'ilhtukana'. An tij yu la'lh'awilh kalats'awalakana', chi tan wa la'jalh'ot'alh an laka tij kajat'ap'ujununkana'. ");
INSERT INTO tpp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chux lapanak kala'ts'ina an ixjama'alhtaxtunti an Dios.” ");
INSERT INTO tpp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Akxni ixtala'cha'ancha an lapanakni an Juan para li kajama'paxalh ixjajuniy: ―¡Ixjas'at'ank'an tsapulin! ¿Tisiyuchacha tajunan li k'at'a'alht'axt'uya'it'iti an laka lhima'alh'ajna yu minta? ");
INSERT INTO tpp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pus k'a'ilht'utcha yu oxicha tanlhun para li katasulhcha li mak'a'unt'itcha mintala'alhink'an, ch'i jant'u k'ap'ast'akt'iti li mimpayk'an sna an Abraham, mu an Dios yucha layi kaja'ilhtulh ixjas'at'an an Abraham ani lakwilh chiwx. ");
INSERT INTO tpp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","An acha chaway wachucha mala'asijnikanta para li chux an k'iw yu jantu oxi xt'a'a xajatawk'at katicha'xkana', chux ixjataxiyak chi kala'xawakana'. ");
INSERT INTO tpp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pus an lapanakni ixtajuniy: ―Pus, ¿tasucha yu aklawi? ");
INSERT INTO tpp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","An Juan ixjajuniy: ―K'axt'a'nit'iti yu jantu tu'u lhit'ajun ixla'ch'it li uxitnan alht'uyi lhit'awnat'it, chi li alini yu uyat'it, k'at'a'ut'iti yu jantu tu'u uy. ");
INSERT INTO tpp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wachu tala'cha'alh ali'in an yu ixtalhach'inin tanlhun para li kajama'paxalh, tajuniy: ―Maestro, kitnan ¿tisuncha lay ak'ilhtuwi? ");
INSERT INTO tpp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","An Juan ja'alhtaylh: ―Jant'u k'alhimo'slat'iti k'ajach'inint'it, wa t'ach'a lhi'unk'anat'itch'a k'a'ilht'ut. ");
INSERT INTO tpp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chi ali'in soldadojnin wachu talhisakmilh tajuniy: ―Chi kitnan, ¿tisuncha ak'ilhtuwi? Yucha jajuniy: ―Jant'u xamat'i k'a'asi maxt'unit tu'u', k'alhimamatch'a yu lhajayat'it, ch'i jant'u k'alhimuk'at'iti tu'u xamati yu jantu tu'u ilhtuta. ");
INSERT INTO tpp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","An lapanakni sawalhcha ixtalhi'a'niy, ixtanajun li sna an Juan yuchacha Cristo. ");
INSERT INTO tpp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero an Juan jajuniy: ―Kit'in wa laka xkani klama'paxayaw, pero kamina pumatam yu palay ay, kit'in jantu, yucha katama'paxayan la ixTakuwin an Dios chi laka jikmi, yucha jantu ikt'acha'ani masi wa ak'o'x'otnilhcha ixwarachi. ");
INSERT INTO tpp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yucha ch'apatacha an ixpak'alhan, kamaxtuniyacha an xajamakxtalh an ixtrigo, chi kama'ayacha an ixtrigo laka cha'a tan la'oxinita chi an xajamakxtalh kala'xawayacha laka jikmi tan jantu a'tam mixa. ");
INSERT INTO tpp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chunchacha ixjajuniy an Juan chi tamj tamjcha ixjapumak'atsaaniy an laj'oxi chiwinti an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Atumpaj an Herodes yu gobernador ixjunita, an Juan ixjuniya li jantu oxi tacha an ixlay, mu an Herodes ixt'at'awniya ixt'iwi wa ixt'ala'ajuncha yu ixjunkan Felipe chi an ixt'iwi ixjunkan Herodias, chi tanlhuncha ali ixlakata yu jantu oxi tacha ixlay an Herodes. ");
INSERT INTO tpp_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Walh a'tam ilhtupalhi yu jantu oxi an Herodes, palay lhimo'slapalh, malaklhchawlhi an Juan laka pulach'in. ");
INSERT INTO tpp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Akxni ixchuxk'an an lapanakni ixjama'paxat'ajun an Juan, an Jesús wachu a'paxli, walh akxni ixtapaynit'ajunka an Jesús, an lakt'iyan tati'achalh. ");
INSERT INTO tpp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chi ta'alhtajulhi an ixTakuwin an Dios, tan ixyalh an Jesús, wa tacha paloma, chi chiwinkanchalhi an lakt'iyan nawkan: ―Uxint'i kinTs'alhk'at'i ikmapayniyan, uxint'i k'ima'an'ach'ay. ");
INSERT INTO tpp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Katacha la'ap'uxamkawcha k'ata ixpakxanta an Jesús akxni tsukulhcha lhichiwiniy an ixchiwinti Dios. Ixtalhi'ilhtuy li an Jesús ists'alh an José, an ists'alh Elí. ");
INSERT INTO tpp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","An Elí ists'alh Matat ixjunita, an Matat ists'alh Leví, an Leví ists'alh Melqui, an Melqui ists'alh Jana, an Jana ists'alh José, ");
INSERT INTO tpp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","an José ists'alh Matatías, an Matatías ists'alh Amós, an Amós ists'alh Nahum, an Nahum ists'alh Esli, an Esli ists'alh Nagai, ");
INSERT INTO tpp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","an Nagai ists'alh Maat, an Maat ists'alh Matatías, an Matatías ists'alh Semei, an Semei ists'alh José, an José ists'alh Judá, ");
INSERT INTO tpp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","an Judá ists'alh Joana, an Joana ists'alh Resa, an Resa ists'alh Zorobabel, an Zorobabel ists'alh Salatiel, an Salatiel ists'alh Neri, ");
INSERT INTO tpp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","an Neri ists'alh Melqui, an Melqui ists'alh Adi, an Adi ists'alh Cosam, an Cosam ists'alh Elmodam, an Elmodam ists'alh Er, ");
INSERT INTO tpp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","an Er ists'alh Josué, an Josué ists'alh Eliezer, an Eliezer ists'alh Jorim, an Jorim ists'alh Matat, an Matat ists'alh Leví, ");
INSERT INTO tpp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","an Leví ists'alh Simón, an Simón ists'alh Judá, an Judá ists'alh José, an José ists'alh Jonán, an Jonán ists'alh Eliaquim, ");
INSERT INTO tpp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","an Eliaquim ists'alh Melea, an Melea ists'alh Mainán, an Mainán ists'alh Matata, an Matata ists'alh Natán, an Natán ists'alh David, ");
INSERT INTO tpp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","an David ists'alh Isaí, an Isaí ists'alh Obed, an Obed ists'alh Booz, an Booz ists'alh Salmón, an Salmón ists'alh Naasón, ");
INSERT INTO tpp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","an Naasón ists'alh Aminadab, an Aminadab ists'alh Admín, an Admín ists'alh Aram, an Aram ists'alh Esrom, an Esrom ists'alh Fares, an Fares ists'alh Judá, ");
INSERT INTO tpp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","an Judá ists'alh Jacob, an Jacob ists'alh Isaac, an Isaac ists'alh Abraham, an Abraham ists'alh Taré, an Taré ists'alh Nacor, ");
INSERT INTO tpp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","an Nacor ists'alh Serug, an Serug ists'alh Ragau, an Ragau ists'alh Peleg, an Peleg ists'alh Heber, an Heber ists'alh Sala, ");
INSERT INTO tpp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","an Sala ists'alh Cainán, an Cainán ists'alh Arfaxad, an Arfaxad ists'alh Sem, an Sem ists'alh Noé, an Noé ists'alh Lamec, ");
INSERT INTO tpp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","an Lamec ists'alh Matusalén, an Matusalén ists'alh Enoc, an Enoc ists'alh Jared, an Jared ists'alh Mahalaleel, an Mahalaleel ists'alh Cainán, ");
INSERT INTO tpp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","an Cainán ists'alh Enós, an Enós ists'alh Set, an Set ists'alh Adán, chi an Adán ists'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","An Jesús sawalhcha ixla'tanu'ojota an ixTakuwin Dios akxni tasp'itcho'ochalh an ayxkan tan junkan Jordán. Chi an ixTakuwin Dios lhi'alhcha lakak'iwin. ");
INSERT INTO tpp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","T'up'uxam wilhchani ancha ixt'awnachalh. Ancha an xapay makxkay'un ixlila'ts'intanuycha an Jesús. Jantu k'is tu'u ix'uy an Jesús an t'up'uxam wilhchan, ixli'astan chawanalhcha. ");
INSERT INTO tpp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pus an xapay makxkay'un juniy: ―Li isTs'alhk'at'i Dios, k'aja'un ani chiwx li katatapalalh pan. ");
INSERT INTO tpp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","An Jesús alhtaylh juniy: ―Ts'o'kanta tan najun: “Jantu wa pancha katiputsukulh an lapanak, wachu kaputsukuya chux an ixchiwinti Dios.” ");
INSERT INTO tpp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Wa chuncha an xapay makxkay'un a'tam lhi'ampalh lakatam laka ay a'stitawk'a an Jesús, chi lakmasuni'olhcha an laj'ay lhich'alhkat alin lakamunulhpa chi an ixk'usinti. ");
INSERT INTO tpp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Juniy: ―Akxta'ni'oyancha chux ani lhich'alhkat chi an ixk'usinti, mu kit'ini kima'axta'nikanta, kit'in layi akma'axta'niya yu ikma'axta'niputun. ");
INSERT INTO tpp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Li ak'int'ats'o'ott'aniya'a mi'anucha kajun'oya chux. ");
INSERT INTO tpp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","An Jesús alhtaylh juniy: ―¡K'ap'inchicha Satanás, mu ts'o'muk'akanta an la ixchiwinti Dios tan najun: “Wa yucha an miJamach'alhkat Diosi k'at'ats'o'ott'aniya'a chi wa yucha k'ak'iklak'a'iya'a.” ");
INSERT INTO tpp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Walh lhi'ampalh la'acha'an Jerusalén, muk'achalhcha la ix'ukxni an tajtan, chi juniy: ―Li isTs'alhk'at'i Dios, k'awarj p'it'i an talaktsin. ");
INSERT INTO tpp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mu ts'o'muk'akanta an la ixchiwinti Dios: An Dios kajamakminiyani ix'angelhnin para li katalhistakni, ");
INSERT INTO tpp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","katama'ch'apayani para li jant'u k'a'ayst'uk'uk'a laka chiwx. ");
INSERT INTO tpp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","An Jesús alhtaylh juniy: ―Ts'o'muk'akanta tan najun: “Jant'u wa k'at'ilhila'ts'int'anut'i an miJamach'alhkat Dios.” ");
INSERT INTO tpp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pus an xapay makxkay'un akxni la'ts'ilhi li tucha lay ali lhila'ts'intanuy, makawlhcha, sta apu'a'tamka'. ");
INSERT INTO tpp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ancho'olhcha xalakaat'un Galilea an Jesús, sawalhcha ixla'tanuni an ixTakuwin Dios, chi sawalhcha ixtamispayi ta ixlijalhi'ay an tan ixt'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ixjamasuniycha an laka lakcha'a tan ixtala'ta'ayxt'o'a an judiojnin, chi oxicha ixtalhipast'ak'a ixchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Alhcha la'acha'an Nazaret, tan ta'ayachalh, chi akxni sábado tanuchalhcha an laka cha'a an tan ixtata'ayxt'o'a an judiojnin, mu chunchacha ixlismanita, chi sa'cha ixyalh tsukulhcha punajuni an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chi taxta'nilhcha an ixlibro Isaías, an yu ma'anchacha ixlichiwiniy ixchiwinti Dios, pus pux'otlhicha, walh ancha la'cha'alh tan najunta: ");
INSERT INTO tpp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","An ixTakuwin Dios la ki'ukxni t'ajun, mu yucha kilakpach'apalh la ixmaka para li ajkalhixa'alalh an laj'oxi chiwinti an jakilhpatinin. Chi kimakminta para li ajkak'uch'ulh an yu wa tala'ta'oxila'alhiy la ixjalhunutk'an. Chi para li p'asi aknawlh li an yu talaklhchawnan kajamakawkalh, chi katajalakawanalhi an yu jantu tajalakawanan. Chi para li kajamakawkalhi an yu sawalhcha jamama'alh'ajnikan. ");
INSERT INTO tpp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chi para li aklhichiwinilhi yu chaway ani oxi panch'e'ex yu ixnawin an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Pasmilhcho'olhcha an libro an Jesús, xta'nicho'olhcha an yu ixja'a'tayjunun lapanak, chi tawilhcha. An yu ancha ixtat'aw'ojoy wa sa'cha ixtala'ts'ini an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yucha tsukulhcha jajuniy: ―Chaway walhcha la mi'ukxlakapuk'an tacha an ts'o'kanta. ");
INSERT INTO tpp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ixchuxk'an oxicha ixtalhichiwiniy an Jesús, chi sawalhcha ixtalhi'a'niya tacha an laj'oxi chiwinti ixchiwiniy, ixtalajuniy: ―¿Ani chu jantu yu an ists'alh José? ");
INSERT INTO tpp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yucha jajuniy: ―Ijk'atsaycha li akilajunaw ani chiwinti: “Jak'uch'unu', k'ak'uch'uk'a mi'akstu! Wach'u k'a'ilht'u ani la mint'un yu t'ach'a lak'ilht'uchi la'acha'an Capernaúm.” ");
INSERT INTO tpp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chi jajumpalay: ―Ani sawalhi an yu klajunaw, jantu xamati la'a'ikan yu lhichiwiniy ixchiwinti Dios tan la ixla'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Chi ixluwk'an t'akunini ixtat'ajun an xalakaat'un Israel yu ixtalaknitacha ixt'apapak'an akxni ixt'ajun an Elías, akxni la'at'utu k'ata apaytat jantu ixmin xkan, ay lhichawani ix'alin ani lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Walh an Elías jantu mala'achakalhi para li ka'alh jala'ts'ini an t'akunin yu jamacha'an Israel, apalij la'acha'an Sareptaja mala'achakalh waniy la'acha'an Sidón, para li ka'alh la'ts'ini pumatam t'aku yu ixnitacha ixt'apapa'. ");
INSERT INTO tpp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chi ixluwk'an yu ixtalaklakap'uch'i'ojotacha ixtat'ajun an xalakaat'un Israel akxni ixt'ajun an Eliseo, yu ixlichiwiniy ixchiwinti Dios. Walh jantu xamati k'uch'ukalh, apalij yucha an Naamán jamacha'a Siriaja k'uch'ukalh. ");
INSERT INTO tpp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Akxni chunchacha ta'alha'asmatlhi, ixchuxk'an an yu ixtatanumanalh an tan ixta'ayxt'o'nun sawalhcha tala'talh'amalh. ");
INSERT INTO tpp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pus tatamakxtulhcha an Jesús an la'acha'an, talhi'alhcha tanchun la ix'ukxni a'stitawk'a tan ixla'acha'ank'an ixjuntachalh yu'uncha, sta anchacha ixtama'aj'ajuputun. ");
INSERT INTO tpp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero yucha japujataxtulh, alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","An Jesús alh Capernaúm xalakaat'un Galilea, chi akxni jantu ixtapatsakan wilhchan, ixjamasuniycha. ");
INSERT INTO tpp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ixtalhi'a'niycha tacha an ixmasuy mu ixchiwiniy tacha yu lhit'ajun lhich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","An tan ixta'ayxto'nun ixtanun pumatam lapanak yu wa ixlakpach'apata makxkay'un, pus p'ascha pukilht'asay ");
INSERT INTO tpp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","najun: ―¡Jijwa! Jesús de Nazaret, ¿t'isunch'a la't'ant'a? ¿Wa kilamintawcha lalakt'ilhi'ulanin? Kit'in ikmispayan, uxint'i Stalan'a ixlapanak Dios. ");
INSERT INTO tpp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pus an Jesús la'a'aymalh juniy: ―¡Wasa'cha k'ak'ilhu, chi k'amak'awcha ani lapanak! Wa chuncha an makxkay'un, ma'talhi an lapanak tan an ixtayanalh ali'in, pero jantu tani ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pus ixchuxk'an an yu tala'ts'ilh ixtalaktalhanancha, chi ixtalajumpaxay: ―¿Tisu wa tichiwinticha ani li layi ilhtuy li kata'osli an lakmakxkay'un chi ta'osa? ");
INSERT INTO tpp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ta ixlijalhi'ay an tan ixt'ajun an Jesús sawalhcha ixmispakan. ");
INSERT INTO tpp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Akxni taxtulhcha an Jesús an tan ixta'ayxto'nun an lapanakni, la ixcha'acha an Simoni tanuchalh, walh an ixput'icha'o'olh an Simón sawalhcha ixch'apata alhp'as iskakat, pus tatapayniniycha an Jesús li kak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yucha tantawilhi an tan ixmalh, la'a'aymalhi an alhp'as jaskakana', pus makawlhcha an alhp'as iskakat, chi wa akxni tayalhcha an ixput'icha'o'olh an Simón tsukulhcha jamaway. ");
INSERT INTO tpp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Akxni ta'aknuchalhcha an wilhchan, wa tuchicha ta'an'at ixtapakxanta yu ixtalaklhit'ajun ixta'an'ank'an, talhicha'anilhcha an Jesús, pus yucha ixjalaklakpach'apaycha pumatamjtamin chi ixjak'uch'uycha. ");
INSERT INTO tpp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Wachu tamakawlhi tanlhun lakmakxkay'un ixluwk'an an ta'an'anin, akxni ixtat'asay an lakmakxkay'un ixtanajun: ―Uxint'i an isTs'alh Dios. Pero an Jesús jantu ixjamakawniya katachiwinilh. Ixjalaj'aymay, mu yu'uncha ixtak'atsayi li yucha an Cristo. ");
INSERT INTO tpp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Akxni tunkulhcha an Jesús taxtulh, alhcha tan jantu la'acha'an. Pero an lapanakni ixtapuxkajuy pus tala'cha'alhi tan ixt'awnachalh, jantu ixtamakawniya li ka'alh, ixtach'apa'ulaputun, ");
INSERT INTO tpp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","pero an Jesús jajuniy: ―Wachu lhitask'iniya li ak'alh nawna an ali la'acha'anaxni an laj'oxi chiwinti yu alin la ixlich'alhkat Dios, mu yucha kilhimakminkanta. ");
INSERT INTO tpp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pus an laka lakcha'a an yu ixpulakta'ayxt'okan an Galilea, an Jesús ixlichiwiniycha an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","A'tamchacha akxni an Jesús ixpiktu an ay xalakxkan Genesaret ixt'ajun, an lapanakni wa ixtapa'asicho'oycha li ixta'asmatputun an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Walh an Jesús jala'ts'ilh la'at'uy barco yu waniy ixpiktu an lakxkan ixtawilanalh, mu an yu ixtach'apayajuy jatanti ixtaputakutta, ixtala'ch'a'ay an ixpaxo'tank'an. ");
INSERT INTO tpp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Pus putajulh la'atami an Jesús an barco, ma ix'anu Simón. Chi sk'inilhka lamapaynin li kastalhka mujulh palay an lakxkan. Chi sa'cha tawlhchalh, sta anchacha ixjamasuniyachalh an laka barco tacha an ts'anan ixlakyakalh. ");
INSERT INTO tpp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Akxni chiwin'olhcha, juniy an Simón: ―Tan putalhmancha k'alhip'inchi', chi k'amutcha an mimpaxo'tank'an. ");
INSERT INTO tpp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","An Simón alhtaylh juniy: ―Maestro, tuntats'isnicha iktapatsaw, pero jantu lay tu'u ikch'apayawyaw, pero li uxint'ich'a na'un, akmuyacha an paxo'tan. ");
INSERT INTO tpp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Walh akxni tamujulhcha, lhuw jatanti tama'alhilalh, ixla'ta'exacha an ixpaxo'tank'an. ");
INSERT INTO tpp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pus tatamakyawlaka'aniycha an yu lakatam laka barco ixtatajumananchalh, para li katamilhcha t'ala'a'tayjunin, pus tamilhcha. Tala'tsamalhi an la'at'uy barco, wa laycha tatalak'aknulh. ");
INSERT INTO tpp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Akxni chunchacha la'ts'in an Simón Pedro, tatso'ottanilhcha an Jesús, juniy: ―Ak'ilaj'ost'i Jamach'alhkat Jesús, mu kit'in lhuwi kintala'alhin. ");
INSERT INTO tpp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wa xliyu an Simón chi an ali'in ixtalaktalhanancha li tacha an tach'apayawlhcha an jatanti. ");
INSERT INTO tpp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","An Jacobo chi an Juan, ists'alan Zebedeo yu ixjat'a'anta an Simón wachucha ixtalaktalhanan. Pero an Jesús juniy an Simón: ―Jant'u k'at'alhan, chaway tukan lapanaknicha k'ajama'alhilaya'a t'ach'a ixjama'alhilay jatantin. ");
INSERT INTO tpp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Akxni talakmakutu'olhcha an ixbarcojk'an, chuxi talakmakaw'ula'olh, chi tat'a'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","La'atam wilhchan akxni an Jesús ixt'ajun tanchun la'acha'an, la'cha'alh pumatam lapanak yu ixlakap'uch'i'ojota, an lapanak akxni la'ts'incha an Jesús tatso'ottanilhcha chi tamuntitachalhcha lakaat'un, tapayniniycha juniy: ―Jamach'alhkat, li sna ak'ink'uch'up'ut'u, ak'ink'uch'ut'ika'. ");
INSERT INTO tpp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pus lats'awalalhi ixmaka an Jesús, chi lakpach'apachalhcha, juniy: ―Chun, k'at'ala'a'oxit'icha. Wa akxni watukan tala'a'oxilhi an lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chi juniy li jantu xamati kajunilh, juniy: ―Wa k'ap'inchicha talakasunini an sacerdote, chi k'ama'axt'a'a'acha milha'ulan ixlakata li t'ala'a'oxit'icha, tacha lhinawlh a Moisés, para li katak'atsa'olhi an sacerdotejnin. ");
INSERT INTO tpp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ali ali ixmispakani an Jesús, chi lhilhuwi ixla'cha'ankan mu ixta'alha'asmatputun chi ixtalakask'in li kajalajk'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero yucha ix'an tapaynini tan wa ix'akstu, tan jantu la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tapasalh la'atam wilhchan akxni ixmasut'ajun an Jesús, ali'in fariseojnin chi an xamaestrojnin lhamap'a'sin ancha sa' ixtalakwilanalh, yu ixtalakmintachalh xala'acha'anaxni Galilea, chi Judea chi Jerusalén. Walh an ix'alhp'asninti an Dios ancha ixt'a'aklat'ajun an Jesús para li lay kajak'uch'unulh. ");
INSERT INTO tpp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wa chuncha tichi yu'uncha lapanakni talhicha'alh la ixputamat pumatam lapanak, yu wa ixlaklhtukulunta. Ixtama'anuputunachalhi an laka cha'a', la ix'ukxlakapu an Jesús, ");
INSERT INTO tpp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero jantu tala'cha'alhi tan kataputamaknulh, mu wanajcha lhilhuwi ixjunkanta, pus an ix'a'sti cha'a tatawk'alh, ta'a'stip'uxli lakats'uniya an ix'a'sti cha'a ancha taputamaknuchalh an ta'an'an la ixputamat, ixtan'ajnichak'an an lapanakni tamamalh, la ix'ukxlakapu an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","An Jesús mu jala'ts'incha li tajakiklaka'inin, pus juniy an yu ta'an'ay: ―Amigo, ikmala'mixini'oyani mintala'alhin. ");
INSERT INTO tpp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pus an xamaestrojnin lhamap'a'sin chi an fariseojnin tsukulhcha tajatapastaknan, tanajun: “¿Tisiyuchacha ani li wa lhila'ts'incha Diosi? Wa Diosi yu lay mala'mixiy tala'alhin.” ");
INSERT INTO tpp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero mu an Jesús ixjak'atsaniya tacha an ixtajatapastaknan, pus jajuniy: ―¿Tasu li ch'unch'ach'a jat'ap'ast'aknanat'iti? ");
INSERT INTO tpp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tampiyu yu palaycha wa las, aknawlh: “Ikmala'mixini'ojoncha mintala'alhin”, u aknawlh: “K'a'ost'aycha, k'ajalht'ancha”? ");
INSERT INTO tpp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","K'ak'ats'at'iti li kit'in yu ikwalh isTs'alh Lapanak layi akmala'mixiya tala'alhin ani lakaat'un. La'alhi an yu lakalhtukulunta lapanak, juniy: ―Chaway uxint'i ijkunan, k'a'ost'aycha, k'asakt'icha amimputamat chi k'ap'inch'o'ochicha mincha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wa akxni ostayalh an yu ixlakalhtukulunta, sakcho'olhcha an ixputamat, chi ancho'olhcha la ixcha'a'. Xta'nilhi'alhcha lhimala'puchajun an Dios, chi ixchuxk'ani tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pus sawalhcha ixtalaktalhanan chi oxicha ixtalhipast'ak'a an Dios. Laka ay ixtalhantik'an ixtanajun: ―Chaway la'ts'iw yu lhi'a'nin. ");
INSERT INTO tpp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ixli'astan tacha an laktapasalh, an Jesús alhcha, walh la'ts'ilh pumatam lapanak yu ixlaklhach'inin tanlhun an laka banco, Leví ixjunkan, sa' ixwilh tan an ixjach'inin, pus an Jesús juniy: ―Ak'int'ap'it'icha. ");
INSERT INTO tpp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yucha makaw'olhi an yu ix'ilhtuy, tayalh chi ch'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ixli'astan an Leví, an la ixcha'a ilhtunilh la'atam wayti an Jesús. Ixluwk'an an yu ixtalhach'inin tanlhun ancha ixtama'wilanalh chi ali'incha lapanakni wachu ancha ixtama'wilanalh laka mesa. ");
INSERT INTO tpp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","An xamaestrojnin lhamap'a'sin chi an fariseojnin kalaks kalakscha ixtaxa'alayi an ixt'alhtanan an Jesús, ixjajunkan: ―¿Tasu li jat'alakwaynatcha chi jat'alaj'ot'atcha an yu talaklhach'inin tanlhun chi an ma'lhta'alhinini? ");
INSERT INTO tpp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","An Jesús ja'alhtaylh jajuniy: ―Yu oxi tat'ajun jantu tama'lhtask'iniya jak'uch'unu', an ta'an'anin chun. ");
INSERT INTO tpp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kit'in jantu ikminta jat'asanini yu jantu tu'u ixtala'alhink'an, kit'in ikminta jat'asanini yu talhit'ajun ixtala'alhink'an para li katamakawlhcha. ");
INSERT INTO tpp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wa chuncha yu'uncha tajuniy: ―¿Tasu li an ixt'alhtanan Juan chi an ixt'alhtanank'an fariseojnin sawalh tatapayniy chi sawalh talhitask'ajayi ixwatkani? Amint'alhtanan talakwajin chi ta'ot'a li tu'u'. ");
INSERT INTO tpp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","An Jesús jajuniy: ―¿Ch'u laych'a k'aja'ilht'uya'it li katalhitask'ajalhi ixwayk'an yu jat'asanikanta tan tama'xto'kan, li ancha jat'a'aklat'ajun an ts'alh yu tama'xt'o'a? ");
INSERT INTO tpp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kachina wilhchani akxni an ts'alh an yu tama'xt'o'a kama'osukana' pus akxni an yu ixtalakwajin wachucha katalhitask'ajaya ixwaytk'an. ");
INSERT INTO tpp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wachu jajumpalh la'atam pulhamacha'xan: ―Jantu xamati ex'iy sast'i la'ch'it chi lhila'ts'ap'ancha yu at'ilhcha. Li xamati chuncha ilhtuy, jantu oxi t'atasuy an la'ch'it, chi an sast'i la'ch'it exa an yu at'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chi jantu xamati pumujuy yu sast'ika xaxkan uva yu laj'at'ilhcha jaxt'a'an, mu an sast'i xaxkan uva tan'exa an jaxt'a'an, pus pu'an'ojoy, chi an jaxt'a'an ts'an'aycha. ");
INSERT INTO tpp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yu sast'ika xaxkan an uva, yu sast'ika wachu jaxt'a'ani pumujukan, chuncha an xaxkan uva chi an jaxt'a'an jantu tani talay. ");
INSERT INTO tpp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chi jantu xamati yu ot'a an yu xama'ancha xaxkan uva watukan ka'otputumpalhi an yu wa sast'ika', mu najun: “Palay oxi an yu xama'ancha.” ");
INSERT INTO tpp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","La'atam wilhchan akxni jantu tapatsakan wilhchan, an Jesús ixla'pust'ajun tan ch'ankanta trigo. An ixt'alhtanan ixta'akatan'ex'iycha an trigo chi ixta'akatanswajp'uxacha, ixta'uycha. ");
INSERT INTO tpp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Walh ali'in fariseojnin tat'alajuniy an ixt'alhtanan an Jesús: ―¿T'asu li ilht'uyatcha yu jantu ixpu'ilhtuka akxni jantu tapatsakan wilhchani? ");
INSERT INTO tpp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","An Jesús ja'alhtaylh jajuniy: ―¿Jant'u p'unawt'at'iti tani lalhcha an David akxni chawanalh, chi an yu ixtat'a'anta? ");
INSERT INTO tpp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Yucha tanulhi an la ixcha'a Dios chi xa'a'ilhi an pan yu jamatajtanilanti, chi ulh chi jaxta'nilhcha wachu an yu ixtat'a'anta. Walh yucha wa yucha an sacerdotejnini lay ixta'uy. ");
INSERT INTO tpp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chi jajumpalay an Jesús: ―Kit'in yu ikwalh isTs'alh Lapanak ikch'alhkatnani masi akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tapasapalh a'tam la'atam wilhchan akxni jantu tapatsakan wilhchan, an Jesús tanuchalhi an laka cha'a tan ixtata'ayxt'o'a an judiojnin, chi ixmasuycha. Walh ancha ixtanun pumatam lapanak yu jantu lay ixlak'anuy an yu oxi ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pus an xamaestrojnin lhamap'a'sin chi an fariseojnin sawalhcha ixtalhakapu'ani an Jesús li sna kak'uch'uya an lapanak mu akxni jantu ixtapatsakan wilhchan, para li ka'alilhi yu lay katapu'alhtasulh. ");
INSERT INTO tpp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero mu yucha ixjak'atsaniya an ixjatapast'ak'atk'an, pus juniy an yu ixmaklhtukulunta lapanak: ―K'at'aycha, an ixtan'ajnicha k'at'ay. Pus yucha tayalh, sa'cha tayalh. ");
INSERT INTO tpp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Wa chuncha an Jesús jajuniy: ―Aklalhisakmiyaw la'atam jasakminti: ¿Oxi li ak'ilhtulh yu oxi u yu jantu oxi tu'u akxni jantu tapatsakan wilhchan? ¿u li akma'alhtaxtulh jatsukunti u akma'nilh? ");
INSERT INTO tpp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa'cha jala'ts'ini tuntala'acho'o an Jesús, juniy an lapanak: ―K'alats'awalat'icha amimaka'. Pus chunchacha ilhtulh, walh ta'oxinilhcha an ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pus yu'uncha sawalhcha tala'talh'amalh, tsukulhcha talalhima'achiwiniya tani kata'ilhtulhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Anchunu panch'e'ex an Jesús alh tapaynini a'stitawk'a, tuntats'isni tapayninilh an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Akxni tunkuncho'olhcha, jat'asanilhcha an ixt'alhtanan, chi ixpumakawt'uychak'ani jasakxtulh yu katat'alhtananacha chi kajamala'achayacha kata'alh lhichiwinin an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","An ixpumakawt'uyk'an chunchuniya ixjajunkan: Simón, yu wachu ixjumpalhkan Pedro, chi Andrés ixt'ala'ajun an Pedro, chi Jacobo chi Juan chi Felipe chi Bartolomé ");
INSERT INTO tpp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","chi Mateo chi Tomás chi Jacobo ists'alh Alfeo chi Simón yu ixtajumpalay Zelote ");
INSERT INTO tpp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","chi Judas ixt'ala'ajun Jacobo chi Judas Iscariote an yu ma'axta'lhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ixli'astan jat'ajatajununcho'ochalhcha an Jesús, chi tan jaswa'alhcha sa' jat'atayalh. Wanajcha ixluwk'an an yu ixtat'alhtanani ixtala'cha'anta. Chi lhuw lapanaki ixtala'cha'anta yu ixtamintachalh xalakaat'un Judea, chi la'acha'an Jerusalén, chi an la'acha'an Tiro chi Sidón yu ixpiktu lakxkan ixtalakwilanalh. Mu ixta'alha'asmatputun chi ixtalakask'in li kajalajk'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","An yu wa ixtala'apaxto'ta makxkay'un ixjalajk'uch'uycha, ");
INSERT INTO tpp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","pus ixchuxk'an an lapanakni wa laycha li kata'aych'apa'ochalhcha an Jesús, mu ixtala'ts'incha li layi ixjak'uch'u'ojoy. ");
INSERT INTO tpp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Chi sa'cha jala'ts'ini an ixt'alhtanan an Jesús, jajuniy: ―Oxi para uxitnani jakilhpatinin mu uxitnan minawink'ani an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Oxi para uxitnani yu ch'away lakch'awananat'it, mu oxi k'a'o'ats'aya'it'it akxni k'alakwayna'it'it. ’Oxi para uxitnani yu ch'away laj'alhunat'it, mu k'alakts'i'ina'it'it. ");
INSERT INTO tpp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Oxi para uxitnani akxni xk'ayk'anat'it, ch'i akxni jant'uch'a la'ts'imp'ut'unk'anat'it, chi akxni wa t'ani k'alhich'iwink'ana'itcha, ch'i akxni jant'uch'a oxi lhip'ast'akk'anat'it li kilakiklaka'iyaw kit'in yu ikwalh isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","K'alaj'ach'ant'iti akxni ch'unch'a ilht'uk'anat'it st'a k'ala't'a'a'lht'ujt'it, mu an yu k'alhajaxt'uya'it an lakt'iyan yucha ay. An ixlakpaynink'an yu'uncha chuncha stak ta'ilhtulh an yu ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’¡Payni'incha uxitnani jamatuminin k'ap'ulhik'ats'aya'it'it!, mu jama'lht'ayanant'atcha mi'achatk'an. ");
INSERT INTO tpp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Payni'incha uxitnan yu o'ats'at'atcha k'ap'ulhik'ats'aya'it'it!, mu k'ast'ak lakch'awanana'it'it. ’¡Payni'incha uxitnan yu lakts'i'inat'it, k'ap'ulhik'ats'aya'it'it!, mu k'ala't'a'oxila'alhiya'it chi k'alaj'alhuna'it'it. ");
INSERT INTO tpp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Payni'incha uxitnan yu sawalhch'a oxi lhip'ast'akk'anat'it k'ap'ulhik'ats'aya'it'it!, mu aminlakpaynink'an chuncha oxi ixtalhipast'ak'a an yu jantu xasawalh ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero uxitnan yu kila'alha'asmat'aw, klajunaw: K'ajamap'aynit'iti masi yu jantu tala'ts'imputunan, oxi k'aja'ilht'ut masi yu wa taxkayan. ");
INSERT INTO tpp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","K'ask'init'iti an Dios li oxi katatawilh masi yu wa aya tajunan, chi k'ajalhit'ap'aynit'iti masi yu wa talhitama'chapuyan. ");
INSERT INTO tpp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Li xamati la'xtisayan, k'alhip'inip'alhi amintala'xtitam. Chi li xamati maxtuniyan mixkuju wach'u k'axt'a'nini aminkutun. ");
INSERT INTO tpp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wa tichicha tu'u sk'iniyan, k'axt'a'nin, chi li xamati xa'a'iniyan tu'u yu minawin, jant'uch'a k'ask'inich'o'o. ");
INSERT INTO tpp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","T'ach'a lak'ask'inat'iti li k'a'ilht'uk'ant'it, wach'u ch'uni k'aja'ilht'ut an ali'in. ");
INSERT INTO tpp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Mu li wa yu tat'alamapayniyani jat'alamap'ayniyat'it, ¿t'anyuch'a yu p'alaych'a oxi ilht'uyat'iti? An ma'lhta'alhinin wachu chuni talay. ");
INSERT INTO tpp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ch'i li wa yu'unch'a oxi jala'ts'inat'it yu oxi tala'ts'inan, ¿t'anyuch'a yu p'alaych'a oxi ilht'uyat'iti? An ma'lhta'alhinin wachu chuni talay. ");
INSERT INTO tpp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ch'i li wa yu'unch'a jamach'ixt'a'niyat'it tu'u yu jalhiwilayat'it li tu'u kataxta'niyan, ¿t'anyu yu p'alaych'a t'am ilht'uyat'iti? An ma'lhta'alhinin wachu chuni talamach'ixta'niy. ");
INSERT INTO tpp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Uxitnan k'ajamap'aynit'iti masi yu jantu tala'ts'imputunan, oxi k'aja'ilht'ut, chi k'ajamach'init'iti tu'u masi jantu tu'u kataxta'nin. Chuncha ayi yu k'ajama'lht'ayanana'it'it uxitnan, chi ixjas'at'an Dios an yu wilhchalh talhmani k'a'una'it'it, mu yucha oxi ja'ilhtuy masi an yu jantu taxta'niy lhimala'puchajun chi an yu wa ay tajunita. ");
INSERT INTO tpp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pus uxitnan k'ajamap'ayninint'it wachu tacha jamapayninin aminPayk'an. ");
INSERT INTO tpp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Jant'u k'ajalhimuk'at'iti li tuchini ta'ilhtutacha ali'in para li an Dios wachu jantu katalhimuk'ani t'uch'ini ilht'ut'atcha uxitnan. Jant'u k'ajamuk'anit'it'i lhima'alh'ajna an ali'in, walh an Dios wachu jantu chuni katita'ilhtun. K'ajamala'mixinit'iti ixtala'alhink'an an ali'in, walh wach'u k'amala'mixinik'ana'it'it. ");
INSERT INTO tpp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","K'axt'a't'it, walh wach'u k'axt'a'nik'ana'it'it. Palay lhuwi k'axt'a'nik'ana'it'it yu wa t'ak'alhcha a'tsamanta, yu wa lhi'o'slaycha a'tsamanta. T'ach'a p'alhk'ananat'it wach'u ch'uni k'ap'ulhk'ak'ana'it. ");
INSERT INTO tpp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chi jajumpalh la'atam pulhamacha'xani an Jesús, jajuniy: ―¿Chu layi xamati lapanak yu la'lhtuluw kamalhtanalh yu ixt'ala'lhtuluw? ¿Jantu wa ayxtami kajuluklh ta'alh tan jalh'ot'alh? ");
INSERT INTO tpp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","An jatalanini jantu yu palay k'atsay, yucha an ixmaestro, pero li akxni jatalaninin'olhcha tacha an ixmaestrojcha kajuna'. ");
INSERT INTO tpp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Ch'i t'asich'a li la'ts'iniycha an k'is laktanun xatap'aksni ts'a'am amint'ala'ajuni, chi uxint'i jant'u la'ts'ini an p'amj laktanuman a'tolo'ontawlhna'a? ");
INSERT INTO tpp_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿T'asu li uniycha amint'ala'ajun: “Aklakpumaxtuyan an laktanuman lakat'ikt'i jamakxatalh”?, ¿chi uxint'i jant'u la'ts'ini an p'amj laktanuman a'tolo'ontawlhna'a? ¡Uxint'i wa laycha! P'ulhnajch'a k'alakp'umaxt'uk'a an p'amj laktanuman a'tolo'ontawlhana', walh ch'unch'a laycha k'alakp'umaxt'uya'a an laktanun lakat'ikt'i jamakxtalh amint'ala'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Jantu tu'u yu oxi k'iw yu jantu oxi kaxta'lhi xajatawk'at, chi jantu tu'u yu jantu oxi k'iw yu oxi kaxta'lhi xajatawk'at. ");
INSERT INTO tpp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A'atamin k'iw xajatawk'ati pumispakan, mu jantu layi aktip'uxlicha higo chi uva lakaalhtukunan. ");
INSERT INTO tpp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","An yu oxi lapanak, yu laj'oxi jatapast'ak'ati makutuy la ixjalhunut; chi an yu jantu oxi lapanak, yu jantu oxi jatapast'ak'ati makutuy la ixjalhunut. Mu chux chiwinti laka jalhunuti minachalh. ");
INSERT INTO tpp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tasu li Jamach'alhkat, Jamach'alhkat kilajunawcha ch'i jant'u ilht'uyat'iti yu klajunawi? ");
INSERT INTO tpp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wa tichicha yu kila'min chi ilhtuyi an kinchiwinti yu ijkuniy, aklajunawi tichini ixt'achunchacha. ");
INSERT INTO tpp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wanaj tacha an lapanak yu yawlh ixcha'a'. Yucha p'ulhnajcha ja'ajnalh talhman chi akxni la'cha'alhcha an chiwx anchacha mach'atalh. Pus akxni ja'a'muxtunulh jantu tani ilhtunilh an xkan an ixcha'a masi p'as talakanuchalh, mu an ixjach'aja chiwx. ");
INSERT INTO tpp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero yu ki'alha'asmat'a chi jantu ilhtuy, tachanu an lapanak yu mach'atalh ixcha'a wa la ix'ukxni an lakaat'un, jantu laka chiwxi mach'atalh. Pus akxni p'as talakanuchalh an xkan, wa lasi juluklh ta'a'talh wanaj talakt'ilhi'olh. ");
INSERT INTO tpp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Akxni chunchacha jajun'olh an Jesús, alhcha la'acha'an Capernaúm. ");
INSERT INTO tpp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Walh ancha ixt'ajun pumatam ixcapitank'an soldadojnin de Roma, ixlit'ajun pumatam ixma'tsuku yu sawalh ixmapayniy, an ixma'tsuku p'asi ixta'an'ay, ixnit'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pus akxni k'atsaalhi an capitán li ancha t'ajun an Jesús, jamala'achalh ali'in an xalaj'ajin judiojnin, ixtapayniniycha li ka'alh k'uch'unu an ixma'tsuku'. ");
INSERT INTO tpp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yu'uncha tala'cha'alhcha an Jesús, sawalhcha ixtatapayniniy, ixtajuniy: ―Ka t'acha'ani li k'a'a't'ay'ut'i, ");
INSERT INTO tpp_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","mu yucha jamapayniya an kilapanaknik'an, yucha kintayawnin a'atam cha'a tan ikta'ayxt'o'aw. ");
INSERT INTO tpp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pus an Jesús jat'a'alh. Pero akxni jantucha tukan ma'at ixtacha'ant'ajun an laka cha'a, an capitán jamala'achanilh ali'in ix'amigojnini an Jesús, tan junkan: ―Jamach'alhkat Jesús, jant'u k'alhak'ap'up'i, jantu k'is ikt'acha'ani li k'at'anuch'ita an la kincha'a', ");
INSERT INTO tpp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","xliyu wanaj jantu iktapujulh ak'ancha'an t'asaninin kit'in. Wa k'anawcha li kata'oxilhcha an kima'tsuku kata'oxiyacha. ");
INSERT INTO tpp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mu masi kit'in wachu wa kintalhijuniya an yu palaycha xalaj'ajin, chi wachu ijkalhit'ajuni soldadojnin yu wachu ijkalhijuniy, akxni ijkuniy xapumatam li inta ka'alh, an. Chi akxni xapumatam ijkuniy li kamilh, min. Chi akxni iklhijuniy tu'u ka'ilhtulh an kima'tsuku, ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","An Jesús lhi'a'nilhcha akxni chunchacha alha'asmatlhi, pus sa'cha jala'ts'ini an lapanakni yu an ixtat'a'anta, jajuniy: ―Klajunaw, masi an xalakaat'un Israel jantu tu'u kla'ts'in ay jakiklaka'inti ka'alilh tacha ani jakiklaka'inin ani lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Akxni tacha'ancho'olhcha laka cha'a an yu ixjamala'achata an capitán, tala'ts'ilhcha li ta'oxitacha an ixma'tsuku'. ");
INSERT INTO tpp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ixli'astan tapasapalh akxni an Jesús ixti'an la'acha'an Naín, ixluwk'ani ixtat'a'anta an ixt'alhtanan chi wanaj lhilhuwi ixjat'a'ankanta. ");
INSERT INTO tpp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Walh akxni ixcha'ant'ajuncha an tan putanukanachalh la'acha'an, la'ts'in li ixti'ankan maknuka janini', ists'alh tichiyucha t'aku yu jantucha tu'u ixt'apapa', wa pumatami ixlit'ajun ists'alh. Lhilhuwcha ixt'a'ankanta an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","An Jesús la'ts'incha an t'aku pus mapayniycha, juniy: ―T'uch'a k'a'alhu. ");
INSERT INTO tpp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Stalh la'alhi an yu ixpulhi'ankanta, chi ch'apachalh, pus an yu ixtalhi'anta sa'cha tat'atayalh. Chi juniycha an Jesús an yu ixli'ankanta: ―Ts'alh, ijkunan: ¡K'a'ost'aycha! ");
INSERT INTO tpp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pus ostayalhcha an yu ixnitacha, sa'cha tawilh chi tsukulhcha chiwiniy. An Jesús ma'axta'nilhcha an ixnati. ");
INSERT INTO tpp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ixchuxk'an an yu ixtama'anta talaktalhanalh, chi ixtaxta'niycha lhimala'puchajuni an Dios, ixtalaknajun: ―Ayi ani yu lhichiwiniy ixchiwinti Dios, yu makminkanta ani tan t'awnaw. An Dios minta jama'alhtaxtunu an ixlapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wanajcha ta'a'pitsi'olhi an chiwinti chux xalakaat'un Judea, chi chux an la'acha'anaxni yu ixtala'acho'owilananilh. ");
INSERT INTO tpp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","An Juan k'atsaalhi tacha an laktapasalh, mu an ixt'alhtanan tamak'atsaanilh. Pus jat'asanilh ixt'uyunk'an ixt'alhtanan ");
INSERT INTO tpp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jamala'achanilhi an Jesús para li katalhisakmilhi li yucha yu kamina u katapakxan'ipala pumatam. ");
INSERT INTO tpp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Akxni tala'cha'alhcha an Jesús an yu jamala'achalh an Juan, tajuniy: ―Yucha an Jama'paxanaj Juani kintamala'achatacha'an para li ma aklalhisakmiw li sna uxint'icha yu k'at'ana'a u akpakxan'ipalaw pumatam. ");
INSERT INTO tpp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Walh ixt'a'akxni tukan an Jesús ixluwk'ani jak'uch'ulh yu wa ixtata'an'ay, chi yu wa ixtala'ma'alh'ajnan, chi yu wa ixtala'apaxto'ta makxkay'un, chi ixluwk'an yu wa la'la'lhtulu'un, jamalakawanilh. ");
INSERT INTO tpp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pus an Jesús ja'alhtaylh, jajuniy: ―K'ap'inchi'itcha mak'atsaaninini an Juan yu la'ts'int'it ch'i yu asmatt'it: an la'la'lhtulu'un tajalakawanancha, chi an lakch'anlht'ulukun, talakalhtanancha, an yu ixtalaklakap'uch'ita tala'tala'a'oxilhcha, an laj'a'atapan taja'asmatnancha, an yu ixtalaknitacha jala'mala'awnicho'okalh, chi an jakilhpatinin jamak'atsaanikancha an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Oxi para yucha yu jantu akintiputa'a'talh! ");
INSERT INTO tpp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Akxni ta'ancho'olhcha an yu ixjamala'achata an Juan, an Jesús tsukulhcha jalhixa'alayi an Juan an lapanakni, jajuniy: ―¿T'isunch'a k'ila'ts'int'it an tan wa jasa'nik'a? ¿Ma'atam ts'a'am yu ixmalaklay un? ");
INSERT INTO tpp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Li jantu yu, ¿T'isunch'a k'ila'ts'int'iti? ¿Pumatam lapanak yu sawalhcha k'usi ixmala'ch'ininta? Jantu, yu k'usi tala'mala'ch'inin chi yu sawalhcha tama'an'achaputun, an la ixcha'ak'an rejnini tawilanalh. ");
INSERT INTO tpp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pero uxitnan, ¿t'isunch'a k'ila'ts'int'iti? ¿Pumatam yu lhichiwiniy ixchiwinti Dios? Chun, yucha sawalh, walh jantu wa yuchacha lhilakatijtami la'minta. ");
INSERT INTO tpp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ani lapanak, yucha an lhits'o'muk'akanta tan najunta: P'ulhnaj akmak'ana yu ka'ana lhichiwiniy an kinchiwinti para li kamala'asijnilhi mintij. ");
INSERT INTO tpp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Klajunaw jantu xamati apumatam lapanaki ani yu chuncha ixli'ay tacha an Juan, walh masi chuncha, anu la ixlich'alhkat Dios masi yu palay wa xalakat'ikt'i, palay ay, an Juan jantu. ");
INSERT INTO tpp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pus chux an lapanakni chi an yu ixtalhach'inin tanlhun akxni chunchacha ta'alha'asmatlhi, tapastaklhicha li oxi an ixtij Dios, pus jama'paxalhcha an Juan. ");
INSERT INTO tpp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero an fariseojnin chi an xamaestrojnin lhamap'a'sin jantu tala'a'ilhi li kajama'paxalh an Juan, pus chunchacha tapula'amaj'alh yu oxi ixja'ilhtuniputun an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Chi an Jesús najun: ―¿Tasucha ajkalhimalakxtulh an lapanakni yu chaway tat'ajuni? ¿Tisuncha ixt'atamk'ani? ");
INSERT INTO tpp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wanaj tacha an jas'at'an akxni an talaj'amanajtawlay ixtan'ajni an la'acha'an chi talamat'asaycha talajuniy: “Klala's'olhniwcha laka s'olh pero, jant'u lak'at'inint'it, chi klamilhpaniwcha yu wa lhita'oxila'alhikan pero, jant'u laj'alhunt'it.” ");
INSERT INTO tpp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mu kilachilhcha an Jama'paxanaj Juan yu jantu wa sawalhcha ixwajin chi jantu ix'ot'a xaxkan uva, ch'i unat'iti li makxkay'uni ixlakpach'apata. ");
INSERT INTO tpp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chi milhcha an isTs'alh Lapanak yu ixwajin chi ix'ot'a li tu'u, ch'i ch'unch'a ix'ump'alat li wa sawalhcha wajin chi li wa sawalhcha ot'a xaxkan uva, chi li x'amigojnini an talaklhach'inin tanlhun chi an la'ma'lhta'alhinin. ");
INSERT INTO tpp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero tacha an laj'oxi xajachalh an tanlhun anchacha putasuy an ixjatapast'ak'at Dios. ");
INSERT INTO tpp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pumatam fariseo juniy an Jesús li ka'alh t'alakwayna la ixcha'a'. Pus an Jesús t'a'alhcha la ixcha'a an fariseo, tanuchalh tawilhcha laka mesa an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Walh pumatam t'aku yu ancha ixla'aacha'an, yu wa sawalhcha ix'ilhtuy ixtala'alhin, akxni k'atsaalhi li an Jesús alh t'alakwayna la ixcha'a an fariseo, lhicha'alh la'atam perjume la xafrasco. ");
INSERT INTO tpp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","An t'aku ix'alhuncha, chi tantawilhcha la ixjach'aja an Jesús, tsukulhcha lhich'ampaxayi an ix'alhut, ixli'astan ch'anxakalhcha la ix'ay chi lakch'ankilhtastuklhicha chi lakch'anmuk'alhcha an perjume. ");
INSERT INTO tpp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Akxni chunchacha la'ts'in an fariseo yu ixt'alakwajin an Jesús, ixpast'ak'a: “Ani li ixchiwinti Dios sawalhi lhichiwiniy kaxk'atsaalhi tani t'ajuncha ani t'aku an yu lakch'anch'apay, yucha wanaj jantu oxi tacha t'ajun.” ");
INSERT INTO tpp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wa chuncha an Jesús juniy: ―Simón, aklhisakmiyan tuchichun. Yucha alhtaylh: ―Ak'i'uncha, maestro. ");
INSERT INTO tpp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","An Jesús najun: ―Ixt'uyunk'an lapanakni ixtalhi'aniy tichi lapanak yu ixjamach'inita ixtumin: pumatam quinientojo ixli'aniy chi an pumatam cincuenta, ");
INSERT INTO tpp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","chi mu tucha lay tu'u ixtalhimapalhnicho'oy, yucha jamak'akxanilh. Chi, ¿tisiyuchacha an yu palay kalhimapayniya lhiwilayi? Ak'i'un. ");
INSERT INTO tpp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","An Simón alhtaylh, juniy: ―Kit'in ikpast'ak'a ka yucha an yu palay la'lhuw ixli'aniy. An Jesús juniy: ―Chun sawalh, chuncha t'ach'a an p'ast'ak'a. ");
INSERT INTO tpp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Chi an Jesús la'ts'impalhi an t'aku, juniy an Simón: ―¿La'ts'ini ani t'aku'? Iktanuchilhcha an la mincha'a chi jant'u k'ixt'anini xkan yu aklhich'anch'a'alh, pero ani t'aku kilhich'anch'a'alhi ix'alhut chi kilhich'anxakalhi an ix'ay. ");
INSERT INTO tpp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jant'u k'ila'xt'ik'ilht'ast'ukt'i, pero ani t'aku, wa iktichilh tuka' kilakch'ankilhtastuk'ojoy. ");
INSERT INTO tpp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jant'u k'i'ukmuk'a asayte, pero ani t'aku kilakch'anmuk'alhi perjume. ");
INSERT INTO tpp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Xliyu iklhijunan li masi lhuwi ixtala'alhin, mala'mixini'okalhcha, mu sawalhcha jamapayninilh. Pero yu wa lakats'uniya mala'mixinikan, wa k'isi jamapayninin. ");
INSERT INTO tpp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pus an Jesús juniy an t'aku: ―Amintala'alhin mala'mixini'ok'acha. ");
INSERT INTO tpp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wa chuncha an yu ancha ixtat'awilanalh laka mesa tsukulhcha tapast'ak'a: ―¿Tisiyuchacha ani li wachu mala'mixiya tala'alhini? ");
INSERT INTO tpp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero an Jesús juniy an t'aku: ―Amijakiklaka'inti ma'alhtaxtuncha, k'ap'inch'o'ochicha. Jant'uch'a t'u'u k'alhak'ap'up'i. ");
INSERT INTO tpp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ixli'astan an Jesús alhcha lhichiwiniy an laj'oxi chiwinti yu mintachalh la ixlich'alhkat Dios, ta lakachux an laj'ay la'acha'anaxni chi tan wa lakt'ikt'i. Ixtat'a'anta an ixpumakawt'uyk'an ixt'alhtanan, ");
INSERT INTO tpp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","chi ali'incha t'akunin yu ixjak'uch'uta akxni wa ixtala'apaxto'ta makxkay'un chi yu akxni wa ixtala'ta'an'ay. Ancha ixma'anta an María yu ixtajuniy ma Magdalena, yu la'atujun makxkay'un tamakawlh, ");
INSERT INTO tpp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","chi Juana, ixt'iwi Chuza, yu ixt'atapatsay an Herodes, chi Susana, chi ixluwk'ancha ali'in t'akunin yu ixta'a'tayjuycha laka tu'u an Jesús chi an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lhilhuwi lakminkanchalh lakatamincha la'acha'an, pus wanajcha lhilhuwi la'cha'ankalh an Jesús, chi yucha jajunilh la'atam pulhamacha'xan, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Pumatam lapanak alh maj'ana ixt'in, walh akxni ixmaj'ant'ajuncha, an ali xatalhts'i an yu ixmaj'an waniy laka tiji tamachalh, pus putayakalh chi ta'usaklhi an ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","An ali an ixt'in an yu ixmaj'an laka chiwxini tamachalh, pus akxni la'awlhcha lakxixli, mu jantu tu'u xkan. ");
INSERT INTO tpp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","An ali laka jalhtukunani tamachalh, chi mu wa ayxtami t'ata'ayalh an jalhtukun, pus maxixilh. ");
INSERT INTO tpp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero an ali tan oxi t'uni tamachalh, pus p'unlhicha, chi oxi alilh, la'atamin t'in tamciento xatalhts'i xta'cho'olh. Akxni chunchacha naw'olh an Jesús, p'ascha najun: ―Yu lhit'ajuni ixpa'asmatna, ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pus an ixt'alhtanan an Jesús tajuniy: ―¿Tisuncha nawputun t'ach'a an na'un? ");
INSERT INTO tpp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yucha jajuniy: ―Uxitnan layi k'alhimach'a'xaya'it an ixlich'alhkat Dios masi jantu tasuy. Pero an ali'in wanaj laka pulhamacha'xani ijkajuniy, mu masi tajalakawanan tachanu jantu tajalakawanan, chi masi ta'asmat'a jantu talhimacha'xay. ");
INSERT INTO tpp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ani pulhamacha'xan yucha aniya jumputun: An t'in yucha an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chi an t'in an yu tamachalh laka tij yu'uncha an yu ta'asmat'acha an ixchiwinti Dios, pero akxni jala'cha'an an xapay makxkay'un jamaxtuni'ojoyi an la ixjalhunutk'an an ixchiwinti Dios, para li jantu katajakiklaka'inilh chi jantu katata'alhtaxtulh. ");
INSERT INTO tpp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","An t'in an yu laka chiwxnan tamachalh, yu'uncha an yu akxni ta'asmat'acha an ixchiwinti Dios, sawalhcha ta'achaniy ta'asmat'a, pero jantu tajataxiyaklay, jantu ma'ani tajakiklaka'inin, mu akxni jalhila'ts'intanukancha, tamakawcho'oycha. ");
INSERT INTO tpp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","An yu lakajalhtukunan tamachalh t'in, yu'uncha an yu ta'asmat'acha an ixchiwinti Dios, pero ancha panch'e'ex, ixli'astan talhimakawcho'oycha an ixlitsukuputunka laj'oxi tanlhun, lhuw tumin chi an ixma'an'achaka jatsukunti, pus jantu tu'u taxt'a'a ixjatawk'atk'an. ");
INSERT INTO tpp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero an yu tan oxi t'un tamachalh an t'in, yu'uncha an yu oxi tama'ay la ixjalhunutk'an an ixchiwinti Dios chi ta'ilhtuy sawalh, pus oxi taxt'a'a ixjatawk'atk'an mu ali tataylhi'an. ");
INSERT INTO tpp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Jantu xamati makilhnuy la'atam pumaklhku chi ka'a't'alhmuk'alhcha laka a'cho'o, u ixtan'apucha putamat katamaknulh, talhmancha muk'ay para li yu tanuyachalh oxicha kajalakawanalh. ");
INSERT INTO tpp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pus wanajcha chuni tapasay, tu'u yu jantu k'atsakan kak'atsakana', chi yu tats'e'ta kala'cha'ankana', pus kak'atsa'okana'. ");
INSERT INTO tpp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Pus chunchacha, oxi k'a'asmatt'it. Yu lhit'ajun, palay kaxta'nikana'; pero yu jantu tu'u lhit'ajun, masi wa k'ischa kaxlitsukulh, kamaxtuni'okana'. ");
INSERT INTO tpp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wa chuncha an ixnati chi an ixjat'ala'awnin an Jesús tala'cha'alh, pero jantu lay ixtala'cha'ani an tan ixyachalh mu wanajcha lhilhuw. ");
INSERT INTO tpp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pus xapumatam juniy an Jesús: ―Aminati chi amijat'ala'awnin ma'spa tayananchalh, ma tat'achiwimputunan. ");
INSERT INTO tpp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero yucha jajuniy: ―Yu kinati chi kijat'ala'awnin yu'uncha an yu ta'asmat'a an ixchiwinti Dios, chi ta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","La'atam wilhchan an Jesús jat'atajulh laka barco an ixt'alhtanan, chi jajuniy: ―Ka'aw an ixtapiktutam lakxkan. Pus ta'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Walh akxni ixtala'pust'ajuncha an lakxkan, yucha lhtatalh. Pus tsukulhcha lay p'as un chi xkani an lakxkan, an barco lhuwcha putajulh an xkan, wa laycha katalak'aknulh. ");
INSERT INTO tpp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pus tala'alh tamakujulh, tajuniy: ―¡Maestro, Maestro, ka kalakniyawcha! Yucha ostayalh, la'a'aymalhi an un chi tacha an milh milh ixlaklay an alamalh, pus wanaj sa' tawilh, sa'cha juncho'olh. ");
INSERT INTO tpp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chi jajuniy: ―¿Tanischa t'ajun mijakiklaka'intik'ani? Pus ixtalaktalhanancha chi ixtalhi'a'niycha, ixtalajuniy: ―¿Tisiyuchacha ani li masi an un chi an xkan ta'asmatniya li jalaj'aymayi? ");
INSERT INTO tpp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ixli'astan tacha'alhcha tan talhiwilananchalh an jamacha'an Gadara, ixtapiktutamcha an lakxkan, yu t'alalakapu'anitacha an xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Akxni takutlhicha an Jesús tayachalhcha lakaat'un, la'cha'alh pumatam lapanak yu ancha jamacha'a', ma'anchacha ixlakpach'apata makxkay'un, jantucha ixmala'ch'ininta chi jantucha ixcha'a ixwilh, wa laka lakpanteoncha ixtawlay. ");
INSERT INTO tpp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pus an lapanak akxni la'ts'ilhcha an Jesús, p'ascha t'asalh chi tatso'ottatawlhnilhcha la ixjach'aja an Jesús, najun: ―¿Tasicha k'ilhtuyani Jesús, isTs'alh Dios yu wilhchalh talhman? ¡Lamapaynin jant'u ak'imama'alh'ajnit'i! ");
INSERT INTO tpp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chunchacha najun mu an Jesús la'a'aymalhcha an makxkay'un, juniy li kamakawlhcha an lapanak. Wanajcha a'lhuwi ixputawlachilh, masi ixch'i'ulakan laka cadena ixlaj'exa chi an makxkay'un ixli'ancha tan jantu la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","An Jesús lhisakmiy juniy: ―¿T'asich'a unk'an? Yucha najun: ―Legión. Mu wanaj lhuw lakmakxkay'uni ixtalakpach'apata. ");
INSERT INTO tpp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","An lakmakxkay'un sawalhcha ixtatapayniniya an Jesús li jantu kajamak'alhi tan jantu inta kilhimaktay putalhman. ");
INSERT INTO tpp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ixtajuniy li kajamakawnilh li yu'uncha an p'axnincha katalakpach'apaya', mu wa ancha a'stitawk'a lhuw p'axnini ixta'exwayt'ajun, pus jamakawnilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Akxni tamakawlhcha an lapanak an lakmakxkay'un, yu'uncha an p'axnincha talakpach'apa'olh, pus wanaj t'o'o'o tata'aj'aju'olh an lakxkan, talak'aksk'anj'u'olh. ");
INSERT INTO tpp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pus an yu ixtalhist'ak'a an p'axnin akxni chunchacha tala'ts'ilh, talakats'alalhcha, ta'alhcha jamak'atsaaninini an la'acha'an chi masi tan wa jalhi'ay. ");
INSERT INTO tpp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pus an lapanakni ta'alhcha la'ts'inini tuchini tapasalhcha. Tala'cha'alhcha an Jesús, chi an lapanak an yu tamakawlh lakmakxkay'un sa'cha ixwilh la ixjach'aja an Jesús, ixmala'ch'inincho'otacha chi oxicha ixjalakpastaknancho'oy, pus ixtalaktalhanancha. ");
INSERT INTO tpp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","An yu tala'ts'ilh tanischa lhik'uch'ukalh an yu ixtalakpach'apata makxkay'un ixtat'alajuniycha an ali'in. ");
INSERT INTO tpp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wa chuncha ixchuxk'an tacha an ts'anaks ixta'ayxto'nun an yu ancha ixtalhilakwilanalh xalakaat'un Gadara, tatapayninilhcha an Jesús li ka'alhcha, mu sawalhcha ixtalaktalhanan, pus an Jesús tajucho'olhcha an laka barco, alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pero an lapanak an yu tamakawlh lakmakxkay'un sawalhcha ixt'ak'uxa'ani an Jesús, pero an Jesús jantu makawnilh, juniy: ");
INSERT INTO tpp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―K'ap'inch'o'ochicha mincha'a, k'alaknawna'acha tuchi laj'ay tanlhuncha lay ilhtuy an Dios, tani ilhtuncha. Pus yucha alhcha, ixlaknajuncha an la'acha'an tuchi laj'ay tanlhuncha lay ilhtuy an Jesús, tani ilhtulhcha yucha. ");
INSERT INTO tpp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Akxni cha'ancho'olhcha an ixtapiktutam lakxkan an Jesús, sawalhcha talaj'achani talakatastuklhi an lapanakni, mu anchacha ts'anaks ixtapakxan'ita. ");
INSERT INTO tpp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wa chuncha cha'alh pumatam lapanak junkan Jairo, xajefe an laka cha'a tan ixtata'ayxt'o'a an judiojnin, tatso'ottanilhcha la ixjach'aja an Jesús, chi tapaynisk'inilhcha li kat'a'alh la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mu wa pumatam istsi ixlit'ajun katacha la'akawt'uycha k'ata ixpakxanta chi ixnit'ajuncha. Akxni ixtit'a'ancha an Jesús sawalhcha ixtapa'asiy mu wanajcha lhilhuwi ixch'a'o'akanta. ");
INSERT INTO tpp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pus pumatam t'aku yu ancha ixma'anta, la'akawt'uycha k'ata ixta'an'ay, wa ixmaj'an ixjak'alhni, chi ixmakamin'ojotacha ixtumin laka lakjak'uch'unu pero jantu layi ixtak'uch'uy. ");
INSERT INTO tpp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pus ch'a'o'ayawlh, la ix'a'lhch'a pupiktuch'apanichalh an ixla'ch'it, walh wa akxni sa' tayanilh an ixjak'alhni. ");
INSERT INTO tpp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pus an Jesús jajuniy: ―¿Tisiyuchacha ki'aych'apachalh? Pero jantu xamati tu'u alhtaylh. Pus an Pedro chi an yu ancha ixtat'ayanalh tajuniy: ―Maestro, sawalhcha tapa'asiyan chi tatisamaj'anan, mu wanajcha lhilhuw, ch'i lhasakminini tichini aych'apacha'ancha. ");
INSERT INTO tpp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero an Jesús wa jajumpalay: ―Ka xamati ki'aych'apachalh, mu ijk'atsayi li tak'uch'ulhi akxni an ki'aych'apachalh. ");
INSERT INTO tpp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pus akxni an t'aku la'ts'ilhi li jantu lay kati'alhtats'e'lhi, talhanajla'alhi an Jesús chi tatso'ottanilhcha la ixjach'aja. Junilhcha an Jesús la ix'ukxlakapuk'an chux an yu ixta'ayxto'nun tuchini lhi'aych'apachalhcha chi li akxnicha ta'oxilh. ");
INSERT INTO tpp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pus an Jesús juniy: ―Kintsi', amijakiklaka'inti p'ut'ak'uch'ut'icha. Lhi'ach'ach'a k'ap'inch'o'ochi'. ");
INSERT INTO tpp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ixchiwint'ajunka an Jesús, cha'alhcha pumatami yu minchalh la ixcha'a an ixla'ts'ilhi'an laka cha'a tan ixtata'ayxt'o'a an judiojnin, juniy: ―Amintsi nilhcha, t'uch'a ali k'ama'ach'ap'u an Maestro. ");
INSERT INTO tpp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero an Jesús asmatlhi pus juniy: ―Jant'u k'at'alhan, wa k'ajak'iklak'a'incha, walh kata'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Akxni cha'alhcha an laka cha'a an Jesús, jantu wa tichicha makawnilh kat'atanulh, wa yucha an Pedro chi Jacobo chi Juan chi an ixpay chi an ixnati an jatsi'. ");
INSERT INTO tpp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ixtalhita'oxila'alhiycha chi ixtalhilaj'alhuncha an yu ancha ixtatanumanalh, pero an Jesús jajuniy: ―Jant'u k'alaj'alhunt'it, mu jantu nita an jatsi', wa lhtatay. ");
INSERT INTO tpp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yu'uncha wa ixtalhits'i'in, mu ixtala'ts'incha li ixnitacha. ");
INSERT INTO tpp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero an Jesús ma'ch'apachalh, p'ascha juniy: ―¡Jatsi', k'a'ost'aycha! ");
INSERT INTO tpp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wa chuncha la'awcho'olh watukan, chi ostayalhcha, chi an Jesús lhinawlhcha li kamawakalh. ");
INSERT INTO tpp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pus an ixpaynin an jatsi ixtalhi'a'niycha pero an Jesús jajuniy li jantu xamati katajunilh tacha an tapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","An Jesús jama'ayxto'olhi an ixpumakawt'uyk'an ixt'alhtanan chi ja'ilhtulhcha li lay katatamakxtuya tanlhun lakmakxkay'un chi li layi katak'uch'uya wa tuchicha ta'an'at. ");
INSERT INTO tpp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jamala'achalhcha li kata'alh lhichiwinin an ixlich'alhkat Dios chi li katak'uch'ulh an ta'an'anin. ");
INSERT INTO tpp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jajuniy: ―Jant'u t'u'u k'alhip'it'it para laka tij, jant'u k'alhip'it'iti minpalikk'an, chi mibolsajk'an, chi pan, chi tumin, chi alht'uy mila'ch'itk'an. ");
INSERT INTO tpp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wa t'anch'unch'a k'ach'ip'ina'it laka cha'a wa anch'ach'a k'at'awla'it, sta akxni k'ap'inch'o'oya'itcha. ");
INSERT INTO tpp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Chi wa tanchuncha la'acha'an jant'u la'a'ik'anat'it, k'at'axt'ut'it, chi k'alakch'ank'alhap'uxk'ant'iti an po'xmi para li katak'atsaalhi li jantu oxi tacha an talay. ");
INSERT INTO tpp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pus yu'uncha tataxtunilhcha ta lakachux an la'acha'anaxni, ixtalhichiwiniycha an laj'oxi chiwinti chi ixtajak'uch'ununcha. ");
INSERT INTO tpp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","An rey Herodes k'atsaalhi tacha an ixlaktapasay, pus jantucha ixlimacha'xay mu ali'in ixtalaknajun li ma yucha an Juancha la'awcho'olh, ");
INSERT INTO tpp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ali'in ixtalaknajun ma yucha an Eliascha talakasucho'olh, chi ali'in ixtalaknajun ma wa xatichicha an yu ixtalhichiwiniy ixchiwinti Diosi la'awcho'olh. ");
INSERT INTO tpp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero an Herodes najun: ―An Juan kit'ini iklhinawlh li ka'a'cha'xkalh, ¿tisiyuchacha an yu lhichiwinkani? Pus ixmispaputuncha. ");
INSERT INTO tpp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Akxni tala'cha'ancho'olhcha an ixt'alhtanan an Jesús tajuniycha tuchini ta'ilhtulhcha. Yucha ja'aylhi'alhcha tan wa ix'akstuk'an tan wa jasa'nik'a lhila'acha'an Betsaida. ");
INSERT INTO tpp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero akxni an lapanakni tak'atsaalh, tach'a'o'alh, pus tala'cha'alhi an Jesús, yucha jala'a'ilh, tsukulhcha jalhixa'alayi an ixlich'alhkat Dios chi ixjak'uch'uycha an yu wa ixtata'an'ay. ");
INSERT INTO tpp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Akxni ixta'oxat'ajuncha tala'cha'alhcha an ixpumakawt'uyk'an ixt'alhtanan an Jesús, tajuniy: ―K'ajamala'ach'ach'o'ocha an lapanakni para li kata'alhcha puxkawnini tanchuncha katajastaknana chi para li kata'alhcha puxkawnini an la'acha'anaxni u masi tan wa jalhi'ay yu kata'uya', an tan waniy laklhitamakajun, mu ani jantu tu'u alin. ");
INSERT INTO tpp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","An Jesús jajuniy: ―K'ajaxt'a'nitcha uxitnani yu kata'uya'. Yu'uncha ta'alhtaylh: ―Wa a'xkisi pan chi ma'at'uy jatanti iklhit'awnaw, ka wanaj ak'aw jatamawninini yu kata'ulh tacha an ta'ayxto'nun. ");
INSERT INTO tpp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tacha la'akisi mil lapanakni ixta'ayxto'nun. An Jesús jajuniy an ixt'alhtanan: ―K'aja'unitka li katalaktawilhka', t'up'uxamkawincha katalaktawilh kilhmaktamin. ");
INSERT INTO tpp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pus chunchacha ta'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Chi an Jesús xa'a'ilhcha an a'xkisi pan chi an ma'at'uy jatanti, tala'st'alhcha an lakt'iyan, xta'lhicha lhimala'puchajun chi la'ch'e'elhcha, jala'xta'nilhcha an ixt'alhtanan para li katamala'pitsilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pus ixchuxk'ancha talak'ulh, talhikiklalhcha. Chi an yu tucha lay ta'o'olh xaxajni tamach'ixtamicho'olh la'akawt'uy canasta. ");
INSERT INTO tpp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A'tamchacha akxni ixtapaynit'ajun wa ix'akstu an Jesús, jajuniy an ixt'alhtanan mu ancha ixtat'a'aklat'ajun: ―¿Tisi kit'incha tanajun an lapanakni? ");
INSERT INTO tpp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yu'uncha tajuniy: ―Ali'in tanajun ma Jama'paxanaj Juank'at'i, ali'in ma Eliask'at'i, chi ali'in tanajun ma xamati yu an ma'anchacha ixtalhichiwiniy ixchiwinti Diosi la'awcho'olh. ");
INSERT INTO tpp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pus yucha jajuniy: ―¿Chi uxitnan tisi kit'inch'a nawnat'iti? An Pedro juniy: ―Uxint'i ixCristo Dios. ");
INSERT INTO tpp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","An Jesús sawalhcha jajuniy li jantu k'is xamati katajunilh. ");
INSERT INTO tpp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chi jajuniy: ―Kit'in yu ikwalh isTs'alh Lapanak akstak ma'alh'ajnana', chi jantu akintitala'ts'imputulhi an laktatanincha chi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin. Akintama'niya pero ixlila'at'utu wilhchan akla'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chi tan ixchuxchak'an jajuniy: ―Li xamati kint'alhtana jumputun, kamakawlhcha yu wa ixjatapast'ak'atcha, kaxa'a'ilhcha ixcruz yu lay kapuma'nikalh chi akinch'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mu yu kama'alhtaxtuputuna ixjatsukunti, kama'ats'an'aya', pero yu kama'ats'an'aya ixjatsukunti kilakata, kama'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Tasipi lhila'ancha masi an lapanak wanajcha ix'anu kajun'olh an lakamunulhpa', li wa akstu lakt'ilhi'ulakancha chi wa akstu ma'ats'an'akancha? ");
INSERT INTO tpp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Yu kint'amaxanan chi t'amaxanani an kinchiwinti wachu akt'amaxanana akxni akmina tacha Rey, la ixmakalip'at an kimPay chi la ixmakalip'atk'an an la'stalan'a ix'angelhnin. ");
INSERT INTO tpp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero klajunaw an ali'in yu ani tat'ajun jantu katitanilhi li jantuka' tala'ts'ini an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ixli'astan katacha la'atsajincha wilhchan la'pusli chuncha ixjalhixa'alata an Jesús, jat'a'alhcha an Pedro chi Juan chi an Jacobo tanchun a'stitawk'a, alhcha tapaynini'. ");
INSERT INTO tpp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Akxni ixtapaynit'ajuncha, an ix'ukxpu tapaxalhcha, chi an ixla'ch'it wa sut'ut'ucha walh chi wa xlimjnik'acha. ");
INSERT INTO tpp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chi tatalakasulhcha ixt'uyunk'an lapanakni yu ixtat'achiwiniy. Yu'uncha an Moisés chi an Elías. ");
INSERT INTO tpp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wa xlimjcha ixjunita ixtuntala'acho'ok'an, ixtalhit'alakchiwiniycha an Jesús li ka'anacha, mu wa k'ischa ists'an'aniy yu kamuktaxtuya an la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pus an Pedro chi an yu ixtat'a'anta masi sawalhcha ixtalaklhtataputun talhitayanilh, tala'ts'ilhi li an Jesús ay, wa xlimjnik'acha ixjunita chi an ixt'uyunk'an an yu ixjat'achiwiniy. ");
INSERT INTO tpp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Akxni ixtita'ancho'oycha an yu ixjat'achiwiniy an Jesús, an Pedro juniy an Jesús: ―Maestro, ¡oxi li ani ikt'awnaw! Akyawyaw a'at'utu mulht'a'a, a'atam mi'anucha, a'atam ix'anucha Moisés chi a'atam ix'anucha Elías. Jantu ixk'atsay tani ixnawt'ajuncha an Pedro. ");
INSERT INTO tpp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chunchaka ixnawt'ajun, ta'alhtajulh la'atam jataputs'i, jala'atanchanulhcha, pus ixtalaktalhanancha akxni ixjala'atanchanutacha an jataputs'i. ");
INSERT INTO tpp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wa chuncha an laka jataputs'i chiwinkalhcha, nawkan: ―Yucha aniya yu iksakxtuta kinTs'alh, yuch'a k'a'asmatnit'it. ");
INSERT INTO tpp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Akxni chunchacha naw'okalh, an Jesús wa ix'akstucha tala'ts'incho'olh. Chi yu'uncha jantu k'is talaknawlh, alhcha panch'e'ex akxni chuncha tapasachalh jantu xamati ixtajuniy tacha an tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tunkunchalh, akxni tata'alhtajucho'olhcha an a'stitawk'a, lhuw lapanaki talakatastuklhi. ");
INSERT INTO tpp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ancha ixma'anta pumatam lapanak p'ascha xa'alay an Jesús, juniy: ―Maestro, iktapaynisk'iniyan li k'ala'ts'ika an kints'alh, wa ix'akstu kints'alh, ");
INSERT INTO tpp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","walh chi wa lakpach'apapalay makxkay'un, wa la'a'ijcha tsukuy t'asay chi p'ascha lakchikixa, wa xut'ut'ucha a'pupuy stakcha lhitama'chapuy chi jantu makawputun. ");
INSERT INTO tpp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ijkatapaynisk'inilhcha amint'alhtanan li akintak'uch'unilhka', pero jantu lay tak'uch'uy. ");
INSERT INTO tpp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","An Jesús alhtaylh najun: ―¡Yu ch'away t'awnat jant'u jak'iklak'a'ininat'it, wa t'ani lap'ut'unatcha layat'itcha! ¿Tasu wanancha wa aktilat'a'aklatsukuyawi? ¿Tasu wanancha wa aktilalhilhitayaniyawi? K'alhit'a amints'alh. ");
INSERT INTO tpp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Akxni stalhcha la'alhi an ts'alh an Jesús, an makxkay'un ma'talh, p'ascha lakchikixli. Pero an Jesús la'a'aymalhi an makxkay'un pus ta'oxilhcha an ts'alh chi ma'axta'nicho'olhcha an ixpay. ");
INSERT INTO tpp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sawalhcha ixtalhi'a'niya ixchuxk'an li an Dios ay. Chunchaka ixtalhi'a'nit'ajun tacha an ixlak'ilhtuy an Jesús, yucha jajuniy an ixt'alhtanan: ");
INSERT INTO tpp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Oxi kata'akatutanun ani chiwinti yu aklajunaw: kit'in yu ikwalh isTs'alh Lapanak akima'axta'kana la ixmakak'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero yu'uncha jantu talhimacha'xanilhi tuchini ixjajuniycha, mu lhima'anxkayi para yu'uncha kaxtalhimacha'xalh, chi jantucha talhisakmiputulh, mu ixtatalhanajlay. ");
INSERT INTO tpp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wa chuncha tsukulhcha talalhisakmipaxay tichini palaycha xa'ay kajuna yu yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Chi mu an Jesús ixjak'atsaniya tani ixtajatapastaknancha la ixjalhunutk'an, xa'a'ilh pumatam jas'at'a, la ixpa'xticha yawlh. ");
INSERT INTO tpp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chi jajuniy: ―Watichicha yu la'a'iya ani jas'at'a la kinta'a'ut, kit'ini kila'a'iy, chi yu kila'a'iy, yucha la'a'iy an yu kimakmintalh; xliyu yu palay wa xalakat'ikt'i yu chux uxitnan, yucha yu palay xa'ay. ");
INSERT INTO tpp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pus an Juan alhtaylh juniy: ―Maestro, ikla'ts'inaw pumatam lapanak yu ixjak'uch'uyi la minta'a'ut an yu wa talakpach'apay makxkay'un, pero jantucha ikmakawniw mu jantu kintach'a'o'ayan. ");
INSERT INTO tpp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","An Jesús juniy: ―Jantu k'ala'a'aymat'it, mu yu jantu tani kinta'ilhtuyan, kintat'a'anan. ");
INSERT INTO tpp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Akxni waniycha ixchint'ajun panch'e'ex para li an Jesús ka'anacha lakt'iyan, wachunchacha t'ak'alh lhi'ilhtulh ixtak'atsan li ka'anacha la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jamala'achalhcha lapanakni p'ulhnaj yu ta'alh puxkawninin tan kacha'ana', lakatam xala'acha'an Samariajcha tacha'alh, ");
INSERT INTO tpp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","pero an yu ancha jamacha'an jantu tala'a'ilh, mu ixtak'atsayi li Jerusaleni ka'ana an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pus akxni tak'atsaalhi an Jacobo chi an Juan yu ixt'alhtanan an Jesús, tajuniy: ―Jamach'alhkat Jesús, ¿na'uni li akma'alhtajuwi jikmi an lakt'iyan para li katala'xaw'olh? ");
INSERT INTO tpp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero an Jesús yucha jalaj'aymalh, jajuniy: ―Uxitnan jant'u k'ats'ayat tuchi takuwinch'a lhit'awnat. ");
INSERT INTO tpp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Kit'in yu ikwalh isTs'alh Lapanak ikminta jama'alhtaxtunu an ixjatsukuntik'an lapanakni, jantu ikminta jama'nini'. Chi ta'alhcha lakatam la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Akxni laka tijcha ixtat'ajun, pumatam juniy: ―Jamach'alhkat Jesús, wa t'anch'unch'a k'ap'ina'a akt'a'anan. ");
INSERT INTO tpp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","An Jesús alhtaylh: ―An zorrajnin talhit'ajuni ixcha'ak'an, chi an ts'o'on talhit'ajuni ixpamaj'ank'an. Pero kit'in yu ikwalh isTs'alh Lapanak jantu inta ikmast'ak'ay ki'a'tsulh. ");
INSERT INTO tpp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chi pumatam jumpalay: ―Ak'inch'a'o'acha. Yucha juniy: ―Jamach'alhkat, kachajcha p'ulhnaj ikti'an maknunu an kimpay. ");
INSERT INTO tpp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","An Jesús juniy: ―K'amak'awcha, kachajcha tamaknulhi ixjaninink'an an janinin, uxint'i k'ap'inchicha lhichiwiniy an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Chi pumatam wachu najun: ―Akch'a'o'ayani, Jamach'alhkat, pero kachajcha p'ulhnaj ikti'an jamak'atsaanini an yu ta ijkalhila'ts'in an la kincha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","An Jesús juniy: ―Jantu xamati li akxni ma'lhts'anch'apatacha yu kapupuja an t'un la ix'a'lhch'acha kalaka'alh, yu chuncha lay, jantu lhitapalayi an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ixli'astan an Jesús pumat'utump'uxamkaw lapanakni jasakxtupalh, chi jala'mala'achalhcha ixlipumat'uyunk'an p'ulhnaj, ta lakachux an la'acha'anaxni chi tanlayjcha tan ixpast'ak'a li ka'ana'. ");
INSERT INTO tpp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ixjajuniy: ―Lhuwi an tapatsat walh chi jantu ixluwk'ani an yu tatapatsay, xliyu k'at'ap'ayninit'iti an yu jamanawin an tapatsat li kajamakmilh aliy yu katatapatsalh. ");
INSERT INTO tpp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Uxitnan k'ap'inchi'itcha, k'ats'ayatcha li kit'in klamak'anaw tacha borregojnin ixtan'ajni tan wanaj lhuw tat'ajun ma'tilin. ");
INSERT INTO tpp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jant'u k'alhip'it'iti mintumink'an chi mibolsajk'an chi miwarachijk'an, chi jantu xamati k'at'ilhima't'ijlat'it k'at'ila'axa'alat'it laka tij. ");
INSERT INTO tpp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wa tanchuncha k'ach'ip'ina'it laka cha'a p'ulhcha k'anawna'it: “Oxicha jatawlhnati ka'alilh ani laka cha'a'.” ");
INSERT INTO tpp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chi li xamati ancha wilh yu la'a'iy an oxi jatawlhnat, an mi jama'oxintik'an la ixjatsukunticha katsukuya', pero li jantu, jantu tu'u kati'alilh yu oxi tu'u ancha. ");
INSERT INTO tpp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wa anchacha k'at'awla'it t'an ch'ip'inat laka cha'a'. Jant'u k'at'alak'ap'axats'uk'ut'iti laka cha'a', ancha k'awayna'it chi k'a'ot'a'it yu xt'a'nik'anat'it. Mu yu tapatsay t'acha'ani li kamapalhnikalh. ");
INSERT INTO tpp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wa tanchuncha la'acha'an ch'ip'inat li la'a'ik'anat, k'a'ut'iti yu xt'a'nik'anat'it. ");
INSERT INTO tpp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Chi k'ajak'uch'ut'iti yu ancha ta'alin ta'an'anin, k'aja'una'it: “Waniycha tala'chintan an ixlich'alhkat Dios.” ");
INSERT INTO tpp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero wa tanchuncha la'acha'an ch'ip'inat'it t'an jant'u la'a'ik'anat'it, akxni t'awnatcha laka calle k'aja'una'it: ");
INSERT INTO tpp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Masi wa xapo'xmicha amila'acha'ank'an iklakch'ank'alhap'uxkanaw, mu jant'u oxi t'ach'a an layat. Pero klamak'atsaaniyaw, an ixlich'alhkat Dios waniycha tala'chintan.” ");
INSERT INTO tpp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Kit'in klajunaw akxni kachinacha panch'e'ex, anchunu la'acha'an yu jantu tala'a'iyan, palay kala'a'iya lhima'alh'ajna, walh jantu an la'acha'an Sodoma. ");
INSERT INTO tpp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡K'ap'ulhik'ats'aya'a la'acha'an Corazín! ¡K'ap'ulhik'ats'aya'a la'acha'an Betsaida! Li an la'acha'an Tiro chi an la'acha'an Sidoni chuncha ixlaktapasalh tacha an laj'oxi tanlhun laktapasalh t'an wilat'it, ma'anchacha ixtaja'asmatnalh yu'uncha. Ixtala'la'ch'ilhi laklhwat'aka ixla'ch'itk'an chi ixtalaktawilhi laka lhk'ak'a. ");
INSERT INTO tpp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Xliyu li akxni kachinacha panch'e'ex kanawkana tanchuncha ka'ana atamj atamj, uxitnan p'alay k'ama'alh'ajnana'it, an la'acha'an Tiro chi Sidón jantu. ");
INSERT INTO tpp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chi uxint'i la'acha'an Capernaúm, ¿na'uncha li sta lakt'iyancha k'ach'ixk'ana'a? Jantu, uxint'i k'ama'alht'a'uk'ana'a laka lhinin. ");
INSERT INTO tpp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Yu ta'asmatniyan, kit'ini ki'asmatniy, chi yu jantu ta'asmatniyan, kit'ini jantu ki'asmatniy. Chi yu kila'amaj'an yucha an yu kimakminta la'amaj'an. ");
INSERT INTO tpp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","An ixt'utump'uxamkawt'uyk'an lapanakni sawalhcha ixtalaj'achani akxni tatasp'itcho'ochalhcha, tajuniy an Jesús: ―Jamach'alhkat, masi an lakmakxkay'un kinta'asmatniyani akxni ijkalaj'aymayaw la minta'a'ut. ");
INSERT INTO tpp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yucha jajuniy: ―Kit'in kla'ts'ini an Satanás akxni wa tacha jamakalipnicha patajulh an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Uxitnan kla'ilhtuyawi li layi k'ajap'ut'ayaya'it an tsapulin chi an kululhnin, chi wa tuchicha ixmakxkayaxtu an xapay makxkay'un, pero jantu lay ta katita'ilhtun. ");
INSERT INTO tpp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero jantu xliyu k'alhilaj'ach'ant'it li ta'asmatniyan an lakmakxkay'un, k'alaj'ach'ant'it li aminta'a'utk'an ts'o'muk'akantacha awint'i lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wa akxni an Jesús achalhcha, yucha an ixTakuwin Dioscha chuncha ilhtulh, najun: ―KimPay, uxint'i ayk'at'i, Jamach'alhkatk'at'i lakt'iyan chi lakaat'un, uxint'i ilht'u li jantu katalhimacha'xalhi an tanlhun an yu sawalhcha tajalakpastaknan tanajun chi an yu sawalhcha lay talhimacha'xay tanajun, yu'uncha an yu tajakilhpatinijk'atsayi ja'ilht'u li katalhimacha'xalh. Chuni, kimPay, uxint'ich'a ch'unch'a oxi lhi'ach'anin. ");
INSERT INTO tpp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Chux an tanlhun kima'axta'ni'olhi an KimPay. Chi jantu xamati kimispay tichini kit'incha, wa yucha an KimPay. Chi an KimPay wachu jantu xamati mispay tichini yuchacha, wa kit'ini ikmispay chi yu ijkamamispaniputun. ");
INSERT INTO tpp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jala'ancho'olhcha an ixt'alhtanan an Jesús jajuniy tan wa ixpu'akstuk'an: ―Oxi para yu'uncha an yu tala'ts'in t'ach'a an la'ts'inat'it, ");
INSERT INTO tpp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","mu ixluwk'an yu an ixtalhichiwiniy ixchiwinti Dios chi an rejnini ixtala'ts'imputun t'ach'a an la'ts'inat'it, pero jantu tala'ts'ilh, chi ixta'asmatputuni an yu asmat'at'it, pero jantu ta'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wa chuncha pumatam yu la'mispay lhamap'a'sin tayalh lhila'ts'intanuycha an Jesús, juniy: ―Maestro, ¿tisuncha ak'ilhtulh para li akixta'nikalhi yu jantu a'tam min'ojoy jatsukunti? ");
INSERT INTO tpp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","An Jesús juniy: ―¿Tasicha ts'o'kanta an laka lhamap'a'sin? ¿T'asich'a p'una'un? ");
INSERT INTO tpp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","An xamaestro lhamap'a'sin najun: ―“K'amap'ayniya'a amijamach'alhkat Dios, chux la mijalhunut, chux la mintakuwin, chux la mintachaput chi chux la mijatapast'ak'at. Chi k'amap'ayniya'a mint'alapanak t'ach'a map'aynik'an mi'akstu.” ");
INSERT INTO tpp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","An Jesús juniy: ―Oxicha t'ach'a an ja'alht'ayan, wa k'a'ilht'ucha, walh k'alhits'uk'uya'a an jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero yucha jantu tu'u lhitamaxaniputulh, jumpalayi an Jesús: ―¿Chi tisiyuchacha kint'alapanaki? ");
INSERT INTO tpp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","An Jesús juniy: ―Pumatam lapanak tajuminchalh la'acha'an Jerusalén ixti'an la'acha'an Jericó. Walh tapaxto'lhi ja'alhawnan wanaj tamaxtuni'olhi ixtanlhun. Stakcha talakasamalh wanajcha ixtama'nit'ajun chi ixli'astan tamakawlhcha, ta'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Walh o'palaj chuncha lhila'cha'alh pumatam sacerdote ancha ixpula'pust'ajun, wa sa' a'la'ts'imay, wakcha alh. ");
INSERT INTO tpp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Wanajcha chun pumatam lapanak levita, ancha pula'puspalh, sa'cha a'la'ts'imay wachu, chi wakcha alh. ");
INSERT INTO tpp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero pumatam lapanak jamacha'a Samaria yu ancha ixla'pust'ajun la'ts'incha, pus la'alh chi mapayniycha. ");
INSERT INTO tpp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","La'cha'alhcha, chi muk'anilhcha asayte chi alcolhi an tan ixlajk'atsanini chi la'apach'inilhcha laka la'ch'it. Ixli'astan ch'ixmuk'alhcha la ixjatapakxat yu ixpulhi'anta ixlaktanlhun, lhi'alhcha tan laka cha'a', chi lhistaklhicha. ");
INSERT INTO tpp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Tunkunchalh, an lapanak de Samaria makutulh a'xt'uy ixtumin chi xta'nilhcha an yu jamacha'a', mu yucha taylhi'alhi ixjalhtanti, juniy: “K'alhist'akt'ika ani lapanak, chi tani chunchacha ali k'alhits'an'aya'a mintumin akmapusp'itnicho'oyani akxni aktasp'itcho'oyanta.” ");
INSERT INTO tpp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ani ixt'utunk'an lapanakni, ¿tisiyuch'ach'a lhiwilay li ixt'alapanak sawalhi an yu tapaxto'lhi ja'alhawanani? ");
INSERT INTO tpp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","An la'mispay lhamap'a'sin najun: ―Yucha an yu mapaynilh. Pus an Jesús juniy: ―K'ap'inchicha, wachucha chuni k'ak'i'ilht'u. ");
INSERT INTO tpp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","An Jesús taylhi'alhi ixtij, walh akxni cha'alh lakatam la'acha'an, pumatam t'aku junkan Marta aylhi'alh la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ixlit'ajun pumatam ixp'isa'a an Marta, María ixjunkan. An María yucha sa'cha tawilh la ixjach'aja an Jesús, chi ix'alha'asmat'acha. ");
INSERT INTO tpp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero an Marta wa yuchacha ixlatapastaknan li lhuwi ixlilat, pus stalh la'alhi an Jesús, juniy: ―Jamach'alhkat, ¿jant'u t'ani na'un masi an kimp'isa'a jantu kint'a'ilhtuyi an kilhilat? K'a'unka li aki'a'tayjulh. ");
INSERT INTO tpp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","An Jesús alhtaylh juniy: ―Marta, Marta, sawalhch'a lhak'ap'up'ini li wanajcha lhuwi amintapatsat, ch'i jant'uch'a lay sa' t'awlay. ");
INSERT INTO tpp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero wa la'atami yu lhitapalay kalhakapu'ankalh, an María sakxtulhcha yu palay oxi chi jantu xamati katimaxtunilh. ");
INSERT INTO tpp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","A'tamchacha akxni ixtapaynit'ajun an Jesús tanchun, akxni tapayni'olhcha, pumatam ixt'alhtana juniy: ―Jamach'alhkat, akilamasuniwi tani lhitapaynikancha, tacha an Juan jamasunilh wachu an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pus jajuniy: ―Akxni t'ap'ayniyat k'anawna'it: KimPay, uxint'i yu wilhchi lakt'iyan, aminta'a'ut stalan'a kala'ts'inkalh. Kamakachilhi amilhich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Akilaxta'niwi yu ak'uw chaway, yu lhilhij ikma'lhtask'iniyaw. ");
INSERT INTO tpp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chi akilamala'mixiniwi kintala'alhink'an, mu kitnan wachu ijkamala'mixiniyawi yu jantu oxi tu'u kinta'ilhtuniyan. Chi jantu akilamakajuwi li akintalhila'ts'intanukan, akilama'alhtaxtuwi tan jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Chi jajumpalay: ―Kanajuw xapumatam yu uxitnan lhit'ajun pumatam ix'amigo, chi akxni jaytatnancha kala'alh la ixcha'a kajunilh: “Amigo, ak'imach'inin a'xt'utu pan, ");
INSERT INTO tpp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mu kila'chilh pumatam ki'amigojo an la kincha'a', ma'ati mintachalh, chi jantu tu'u yu akt'a'ulh.” ");
INSERT INTO tpp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","O'sliyani li kachiwijtalakxtunikana kajunkana: “Jant'u ak'ima'ach'ap'u, laklhchajuycha an maticha chi an kijas'at'an chi kit'in iklakma'ojocha, jantucha layi akti'ostayalh para akxta'nin tu'u'.” ");
INSERT INTO tpp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kit'in klajunaw masi li jantu ka'ix'ostayalhi para li ka'ixta'nilhi tu'u yu ma'lhtask'iniy, mu li yucha ix'amigo, o'sliyani ka'ostayaya chi kaxta'niya yu sk'iniy li lhima'achapuy. ");
INSERT INTO tpp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Xliyu kit'in klalhijunaw: K'ask'int'it, walh k'axt'a'nik'ana'it'it, k'ap'uxk'a'ut'it, walh k'ala'ch'ip'ina'it, chi k'ach'iwinint'it, walh k'amat'i'anik'ana'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mu wa tichicha yu sk'in, xta'nikan, chi yu puxkajuy, la'cha'an, chi yu chiwiniy, mati'anikan. ");
INSERT INTO tpp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Chu sna xamati yu uxitnan yu xapay, kaxta'nilh tsapulh xas'at'a akxni sk'iniy jatanti? ");
INSERT INTO tpp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿U kaxta'nilh la'atam kululh akxni sk'iniy la'atam ja'axwat? ");
INSERT INTO tpp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pero masi uxitnan ay unt'at'it layi jaxt'a'niyat yu laj'oxi tanlhun amijas'at'ank'an, ¡pus aminPayk'an yu wilhchalh lakt'iyan, palaycha kajaxta'niya yu task'iniy an Stalan'a ixTakuwin! ");
INSERT INTO tpp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","An Jesús a'tamchacha ixtamakxtunit'ajun la'atam makxkay'un pumatam lapanak, an makxkay'un jantucha ixmakawniya li kachiwinilh an lapanak. Pero akxni tamakxtulhcha an Jesús an makxkay'un la ixlakatunaj an lapanak, tsukulhcha chiwiniy. Pus an yu tala'ts'in ixtalhi'a'niycha. ");
INSERT INTO tpp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero an ali'in ixtanajun: ―Ani lapanak yucha an Beelzebú xajefe an lakmakxkay'uni t'atapatsay para li lay kajatamakxtulh an lakmakxkay'un. ");
INSERT INTO tpp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Chi an ali'in ixtajuniy ma kajamasunilh tu'u an lakt'iyan, ixtalhila'ts'intanuycha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero yucha ixjak'atsaniya an ixjatapast'ak'atk'an, jajuniy: ―Wa tuchicha lhich'alhkat li wa lapu'aykan talakt'ilhiy, chi tan wilakalh laka cha'a li wa la'aykan talakt'ilhitawlhkan. ");
INSERT INTO tpp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chi li wachu an Satanás wa ix'akstucha t'ala'aykan, ¿tasucha kalhich'alhkatnajtsukuya'a?, mu uxitnan nawnat li Beelzebuju ki'ilhtuy li lay ajkatamakxtulh an lakmakxkay'un. ");
INSERT INTO tpp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pus li kit'in Beelzebuju ikpak'uch'unun, an yu tach'a'o'ayan, ¿tisiyuchacha tapak'uch'ununi? Yu'unchacha katajunan li sawalh u jantu t'ach'a an nawnat'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Li la ixmakni Diosi ijkatamakxtuy an lakmakxkay'un, tasuycha li an ixlich'alhkat Dios tala'chintancha. ");
INSERT INTO tpp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Akxni xamati lapanak yu jalhistaknan la ixcha'a li k'ut'ilh chi oxi lhit'ajun ixpat'alan, lhitala'si yu laklhit'ajun la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero li xamati yu palay k'ut'ilh kala'cha'alh, chi kalhajalh, kamaxtuniya an ixpat'alan yu ixputa'a'tayjuy chi chux an ixlaktanlhun, yuchacha kamala'pitsiya'. ");
INSERT INTO tpp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Yu jantu kint'a'an, kint'alaxkajiy. Chi yu jantu kint'ama'ayxt'o'a wa laktilha. ");
INSERT INTO tpp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Akxni an makxkay'un makajuncha an lapanak, wa lakalakxixnicha puxkawlhitsukuy tan katawilh, chi li jantu la'cha'an, najun: “Ak'ancho'oya la kincha'a tan iktaxtuchalh.” ");
INSERT INTO tpp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chi akxni cha'ancho'oycha, li wa sp'uyjcha jalakp'alhnankanta chi jamalht'ak'anankanta, ");
INSERT INTO tpp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ancha jat'ala'iniy ixpumatujunk'an yu palay wa tani talaycha lakmakxkay'un masi jantu yucha. Pus tatanuycha, anchacha tatawlay, ixli'astan anchunu lapanak palaycha wa tani laycha walh masi jantu tukancha akxni wa ixlip'ulhnaj. ");
INSERT INTO tpp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chunchaka ixnawt'ajun an Jesús, pumatam t'aku an tan lhilhuw ixlakyakalh, p'ascha juniy: ―Oxi para yucha an t'aku yu mala'awnin chi mats'ik'in. ");
INSERT INTO tpp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yucha alhtaylh juniy: ―Kit'in iknajun palay oxi para yu'uncha an yu ta'asmat'a ixchiwinti Dios chi takiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chi mu ali ixcha'ant'awkan, tsukulhcha jajuniy: ―An lapanakni yu chaway ani tat'ajun jantu tajakiklaka'inin, task'in li tu'u kajamasunikalh, pero jantucha tu'u katijamasunikalh, wa yucha an tacha putapasalhcha Jonás. ");
INSERT INTO tpp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mu an Jonás yucha japumak'atsaanikalh an jamacha'an Nínive li Diosi ixmak'anta. Kit'in yu ikwalh isTs'alh Lapanak wachu chuni ajkapumak'atsaaniy an lapanakni yu chaway tat'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","An xareina xalakaat'un Sabá wachu ayxtami kajat'a'ostayaya an yu chaway tat'ajun akxni kala'puskana la ix'ukxlakapu Dios, chi kanawna li yu chaway t'awkani jantu ja'asmatnankan, mu yucha ma'ati minchalh akxni ki'alha'asmatchilh ixjatapast'ak'at an Salomón. Chi uxitnan masi aniya t'a'aklat'awnat'it yu palay xa'ay, an Salomón jantu, ch'unch'a jant'u k'iklak'a'iyat'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","An jamacha'an Nínive wa ayxtami katat'a'ostayaya an lapanakni an yu chawayka tat'ajun akxni kala'puskana la ix'ukxlakapu Dios. Chi yu'uncha katanawna li an yu chaway tat'ajun jantu k'is taja'asmatnamputun, mu yu'uncha an jamacha'an Nínive, taja'asmatnalhi akxni jalhixa'alalh ixchiwinti Dios an Jonás. Chi uxitnan masi aniya t'a'aklat'awnat'it yu palay xa'ay, an Jonás jantu, ch'unch'a jant'u k'iklak'a'iyat'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jantu xamati makilhnuy la'atam pumaklhku chi kamats'e'lhicha, u ka'a't'alh'ulalhcha laka cajón. Apalij talhmancha muk'ay para li yu tanuyachalh kala'ts'ilhcha an jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","An la'chulh yucha xamaklhku an lakatunaj. Li amila'chulh oxi, chux amilakatunaj lhit'aw'ojoyi jatapulhkunu'. Pero li jantu oxi amila'chulh, wachu chuxi amilakatunaj lakaputs'isni t'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","K'alhak'ap'up'i, o'palaj an yu mapulhkuniyan jatats'isni. ");
INSERT INTO tpp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Li chux la milakatunajch'a lhit'aw'o'oy an jatapulhkunu, li jant'uch'a k'is int'a lhit'a'un yu jatats'isni, chuxcha katapulhku'oya', tacha akxni la'atam pumaklhku mapulhkuniyan la ixjatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Akxni chiwin'olhcha an Jesús, pumatam fariseo aylhi'alh la ixcha'a', ma kat'a'alh lakwayna'. Pus tanuchalhcha an laka cha'a an Jesús, sa'cha tawilh tan yalh mesa. ");
INSERT INTO tpp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Chi mu an Jesús jantu p'ulhnajcha ma'ch'a'alhi para li kawaynacha, tacha ancha ixtalamalaniy an judiojnin, pus an fariseo ixli'a'niycha. ");
INSERT INTO tpp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero an Jesús juniy: ―Uxitnan an fariseojnin la'ma'ach'a'ayat'iti an vaso chi an pulatoj, pero mimpulaknik'an uxitnan wa stakcha tapu'a'tsamtani yu wa alhawt'atcha chi yu jantu oxi tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tontojnin! ¿An yu ilhtulh lhima'spa, chu jantu wachu yu ilhtulh yu lhipulakni? ");
INSERT INTO tpp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Palay oxi k'ajaxt'a'nit an jakilhpatinin yu lhit'awnat'it, chuncha chuxi stalan'a k'a'un'oya'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Pero, ¡payni'incha uxitnani fariseojnin! Ma'axt'a'atcha midiezmojk'an an xax'oy menta chi an laksun mijach'itink'an chi chux milhala'oxink'an, tacha najunta la kilhamap'a'sink'an, pero jant'u lhak'ap'up'inat'iti an oxi lanti chi an ixjamapayninti Dios. Oxich'a li ma'axt'a'niyatcha midiezmojk'an an Dios, pero jant'u k'alhik'apmaj'ant'iti an ali'. ");
INSERT INTO tpp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Payni'incha uxitnani fariseojnin! Sawalhch'a lakt'awlhp'ut'unat'iti an laka lakcha'a tan an ta'ayxt'o'aw tan lhitapalay putawlan, chi lak'ask'inat'iti li an lapanakni sawalhcha katalhiwilan, li katala'axa'alani an laka laktij. ");
INSERT INTO tpp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Payni'incha uxitnan wa t'a'ukxp'ut'uyununat'it! Wa tacha wa tan jantucha tasuy tan lak'aknukan, an lapanakni taputayayancha walh jantu tak'atsay. ");
INSERT INTO tpp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pumatam an xamaestrojnin lhamap'a'sin alhtaylh juniy: ―Maestro, t'ach'a ani na'un wachucha kilalhilakajunawi kitnan. ");
INSERT INTO tpp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pus an Jesús najun: ―¡Payni'incha uxitnan wachu'u xamaestrojnin lhamap'a'sin! Jamak'uk'ayat'iti an lapanakni yu ts'ink'i lhi'ankan, pero uxitnan masi wa laka ma'atamcha mink'its'ilimakak'an k'ap'uch'ap'achi'it, jant'u ilht'up'ut'unat'it. ");
INSERT INTO tpp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Payni'incha uxitnan! Jala'la'oxiniyatcha an tan talak'aknunun an yu ixtalhichiwiniy ixchiwinti Dios, yu tama'nilh amilakpaynink'an. ");
INSERT INTO tpp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ch'unch'ach'a p'ulhimalaksuyat'it li oxi lhiwilayat'it an yu ta'ilhtulh amilakpaynink'an, mu yu'uncha tama'nilh, chi uxitnan jala'la'oxiniyatcha an tan ta'aknunun. ");
INSERT INTO tpp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Xliyu wachu an Dios nawlhi la ixjatapast'ak'at: “Ajkamak'aniya yu katalhichiwinina an kinchiwinti chi yu katanawna yu katapasaya', walh chi ali'in kajama'nikana chi an ali'in kajamama'alh'ajnikana'.” ");
INSERT INTO tpp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pus an lapanakni yu chaway tat'ajun, an Dios kajalhich'iya an ixjak'alhnik'an an yu ixtalhichiwiniy ixchiwinti Dios, tacha an tamaj'alh, sta akxni ilhtukanchalh an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Sta akxni an maj'anchalh ixjak'alhni an Abel, sta akxni an maj'alh ixjak'alhni an Zacarías, yu ma'nikalh la ixpujan tan yalh tan ma'axta'kan lha'ulan chi laka tajtan. Xliyu iklalhijunaw kit'in, an Dios kajalhich'iya an yu chaway tat'ajun ixlakatak'an an yu jama'nikalh. ");
INSERT INTO tpp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Payni'incha uxitnan xamaestrojnin lhamap'a'sin! Uxitnani a'ch'ap'at'at'it an xayave jalakpastaknat, pero jant'u t'anuyat'it ch'i jant'u jamak'awniyat'iti katatanulh an yu tatanuputun. ");
INSERT INTO tpp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Akxni an Jesús taxtulhcha ancha, an xamaestrojnin lhamap'a'sin chi an fariseojnin, sawalhcha talhila'talh'amalh, pus tsukulhcha talhisakmiy lhuw tanlhuni an Jesús, ");
INSERT INTO tpp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","para li tu'ucha kanawlh yu laycha katapu'alhtasulh. ");
INSERT INTO tpp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wa chuncha, wanajcha la'alhuw mil lapanakni ixta'ayxto'nun wa ixtalapa'ucho'oycha. Pus an Jesús tsukulhcha jaxa'alay p'ulhnaja an ixt'alhtanan, jajuniy: ―K'ajalajk'ats'anant'iti li jantu katamatsaman an ixlamaskajank'an an fariseojnin, mu yu'uncha wa taja'o'xcho'onun. ");
INSERT INTO tpp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chi mu wa tuchicha yu jantu k'atsakan, kak'atsakana', chi yu wa la'asa', wachu kak'atsakana'. ");
INSERT INTO tpp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Xliyu wa tuchicha tu'u nawt'at tan lakaputs'isni, an tan putunkuw ka'asmatkana'; chi yu nawt'at'iti wa la'asa' chi tan laklhchajuy maticha, kalhit'asakana sta la ixlaj'a'sti an cha'a'. ");
INSERT INTO tpp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Pero kit'in klajunawi, ki'amigojnin: ―Jant'u k'ajat'alhamnit'iti an yu tama'niy lakatunaj, mu ixli'astan jantucha lay ali tu'u ta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aklajunawi kit'in tichini yu k'at'alhamnit'itcha: Yuch'a k'at'alhamnit'it an yu lay maxtuy jatsukunti, chi ixli'astan layi kamak'ampalan laka la'nin. Yucha chun, yucha yu klajunaw k'at'alhamnit'it. ");
INSERT INTO tpp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Chu jantu la'akisi lakt'ikt'i ts'o'on wa a'xt'uy lakt'ikt'i tumin? Walh masi chuncha, an Dios jantu tu'u yu wa kajakapmaj'alhcha an ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pus uxitnan masi wa mi'aychak'an chuxi put'e'e'okanta. Jant'u k'alakt'alhanant'it, palay lhit'ap'alat'it, walh jantu masi lhuw ts'o'on. ");
INSERT INTO tpp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chi iklajunaw, watichicha yu kajajuna an lapanakni li kimispay, kit'in yu ikwalh isTs'alh Lapanak wachu ajkuna li ikmispayi la ix'ukxlakapuk'an an ix'angelhnin an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero yu najuni li jantu kimispay la ix'ukxlakapuk'an an lapanakni, wachu jantu katimispakalhi la ix'ukxlakapuk'an an ix'angelhnin an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Wa tichicha yu wa aya kilhichiwiniy kit'in yu ikwalh isTs'alh Lapanak kamala'mixinikana', pero yu wa aya lhichiwiniy an Stalan'a ixTakuwin Dios jantu katimala'mixinikalh. ");
INSERT INTO tpp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Akxni lhip'ink'anat laka lakcha'a tan ta'ayxt'o'aw u la ix'ukxlakapuk'an an jueznin chi an jamach'alhkatni, jant'u k'alhak'ap'up'it'iti tanischa u tuchini k'aja'alht'ayanana'itcha, u t'ani k'anawna'itcha. ");
INSERT INTO tpp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mu an Stalan'a ixTakuwin Dios yucha katajunan tani k'anawna'itcha akxni k'ach'iwinina'it. ");
INSERT INTO tpp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pumatam lapanak an tan lhilhuw ixlakyakalh juniy an Jesús: ―Maestro, k'a'un an kint'ala'ajun li akint'alamapitsilhi an yu kintamakawnin kimpayk'an. ");
INSERT INTO tpp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero an Jesús alhtaylh: ―¿Tisiyuchacha kilhka'ulata kilhijuez u li lay aklamala'pitsiniw tu'u'u? ");
INSERT INTO tpp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Chi jajuniy: ―K'ajalajk'atsanant'iti an la ixlitsukuputunka lhuw tanlhun, mu jantu yu xt'a'a jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chi jajumpalh la'atam pulhamacha'xan, jajuniy: ―Pumatam lapanak jamatumin lhuwi ma'alalh yu ixch'anta la ixlakaat'un. ");
INSERT INTO tpp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chi sa'cha ixjatapastaknan, ixnajun: ¿Tasucha aklhit'alaya li jantucha inta aktima'alh an yu ikma'alalhi? ");
INSERT INTO tpp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chi najun: “Chunchuniycha ak'ilhtuya', aklakt'ilhiya an tan ijkama'anan chi yu palaycha ayi akyawya', anchacha akma'a'oya an yu ikma'alay chi chux an kilaktanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chi ajkunkanacha ki'akstu: Amigo, lhuwcha mintanlhun ma'at'a, para la'alhuwcha k'ata, k'asa'ch'a t'a'ulh, k'awaycha, k'a'ott'icha, chi k'ama'an'ach'at'icha.” ");
INSERT INTO tpp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero an Dios juniy: “Tonto, chawaycha ani jatats'isni k'ama'ats'an'ach'o'oya'a amijatsukunti. ¿Tisiyuchacha ix'anu kajuna'a an yu ma'at'a?” ");
INSERT INTO tpp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chuncha putapasay an lapanak yu wa lhuwcha ma'ayxt'o'a ixtumin, pero la ix'ukxlakapu Dios wa jakilhpatini'. ");
INSERT INTO tpp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ixli'astan jajuniy an ixt'alhtanan an Jesús: ―Xliyu iklalhijunaw: Jant'u k'alhak'ap'up'it'iti amijatsukuntik'an, ch'i t'uch'ini k'a'uya'itcha, ch'i t'uch'ini k'ala'ch'iya'itcha la milakatunajk'an. ");
INSERT INTO tpp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mu an jatsukunti palay lhitapalay, an wayt jantu, chi an lakatunaj wachu palay lhitapalay, an la'ch'it jantu. ");
INSERT INTO tpp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","K'ajala'ts'int'it an pa'an, yu'uncha jantu tach'an chi jantu tajax'anan, chi jantu tu'u talhit'ajun ixmulht'a'ak'an tan katama'alh ixjax'antik'an, walh an Dios jamaway. ¿Ch'u jant'u p'alay lhit'ap'alat'iti uxitnan chi an ts'o'on jantu? ");
INSERT INTO tpp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Chi masi sawalhch'a k'ajat'ap'ast'aknant'it, ¿tisiyuchacha lay k'is kalhimo'slaya ixta'ayati? ");
INSERT INTO tpp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pus mu li jant'u layi ilht'uyat masi wa lakat'ikt'icha tu'u, ¿t'asu li lhak'ap'up'inatcha an ali tanlhuni? ");
INSERT INTO tpp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’K'ajala'ts'int'it an xanti tacha tata'ayay, yu'uncha jantu tatapatsay, chi jantu tasiwnin, walh an Salomón jantu a'tami chuncha oxi mala'ch'inilh tacha an xanti, masi yucha lhuwi ixlaklhit'ajun yu oxi ixlaktanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chi li an Dios chuncha jamala'ch'iniy an jach'itin an tan wa jalhi'aycha tala'ajunta, chi lhiy jala'xawapalhkancha, ¿pus tasu li uxitnan jantu palaycha oxi katamala'ch'iniyani? ¡Wa jant'u t'uk'ancha k'iklak'a'iyat! ");
INSERT INTO tpp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Klajunawcha, uxitnan jant'u k'alhak'ap'up'it'iti t'uch'ini k'a'uya'itcha u t'uch'ini k'a'ot'a'itcha, t'uch'a k'alhak'ap'up'it. ");
INSERT INTO tpp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mu yu chuncha talay yu'uncha an lapanakni yu jantu tamispay Dios, pero uxitnan aminPayk'an k'atsaycha li ma'lht'ask'iniyat'iti an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wa k'ap'uxk'a'utcha an ixlich'alhkat Dios, walh chux an ali tanlhun wa katat'axta'niyancha. ");
INSERT INTO tpp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Jant'u k'alakt'alhanant'iti masi jantu milhuwk'ani, kiborregojnin, mu amimPayk'an kataxta'niyani an lhich'alhkat. ");
INSERT INTO tpp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","K'ast'at'iti yu lhit'awnat'it, chi an tumin k'ajamala'p'its'initcha an jakilhpatinin, chuncha tachanu lak'ilht'utawnatcha bolsa yu jantu laj'at'ilin, yu laj'oxi mintanlhunk'an yu jantu min'ojoy an lakt'iyan, tan jantu lay cha'an an ja'alhawna chi an xatsapulh tu'u yu kalaj'ats'ilh. ");
INSERT INTO tpp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mu t'anch'unch'a yu k'alhits'uk'uya'it laj'oxi mintanlhunk'an, wachu ani katsukuya amijalhunutk'an. ");
INSERT INTO tpp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Lhilhiji k'ala'asijt'it, ch'i k'alakmap'ulhk'ut'iti an pumaklhku. ");
INSERT INTO tpp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tacha an ma'tsukunin yu tapakxan'iy ixpatronk'an akxni alh ma'wayna tan tama'xto'kani k'alat'it, para li tacha kachina chi kachiwinina k'amat'i'aniya'itcha. ");
INSERT INTO tpp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Oxi para yu'uncha an ma'tsukunin li akxni kachina an ixpatronk'an, takujta kajala'chimpulaya'. Yucha klajunaw o'sliyancha li kaja'ulaya laka mesa, chi kajamuniyacha apalij yucha yu kata'uya'. ");
INSERT INTO tpp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anchunu ma'tsukunin oxi para yu'uncha li takujta wa ta wanancha kachina an ixpatronk'an, jaytatnan u wats'isin. ");
INSERT INTO tpp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","K'ak'ats'at'iti ani: Li xamati lapanak, kak'atsaalhi tuchi panch'e'excha kacha'ana ja'alhawna la ixcha'a, jantu katimakawnilhi li katanuchalh an ja'alhawna'. ");
INSERT INTO tpp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pus uxitnan wach'u k'ala'asijt'it, mu an isTs'alh Lapanak kamina akxni jant'u lhiwilayat'it li lay kamilh. ");
INSERT INTO tpp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wa chuncha an Pedro juniy: ―Jamach'alhkat, ¿ani pulhamacha'xan na'un wa para kitnan u para lhichux? ");
INSERT INTO tpp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","An Jesús najun: ―A ma'tsuku yu jalajk'atsanan chi yu oxi jalhistaknan la ixcha'a ixpatrón, yuchacha kamalhistaknikana an cha'a, chi yuchacha kajaxta'niya yu kata'uya an ali'in ixt'ama'tsukunin akxni katalakwaynacha. ");
INSERT INTO tpp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sawalhcha oxi anchunu ma'tsuku li akxni kachina an ixpatrón, oxi tapatsat'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yucha klajunaw li an ixpatrón o'sliyancha li kamalhistakni'oya an ixtanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero li anchunu ma'tsuku kapastaklhi, kanawlh: “Jantu so'ojo katimilh an kinpatrón”. Chi kajalaksamalhcha an ali'in ixt'ama'tsukunin, an t'akunin chi lapanakni, chi kawaylhcha chi ka'otlhicha yu otputun chi wa kat'a'ap'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","An ixpatrón anchunu ma'tsuku, kamina akxni jantu s'alaj wilh chi akxni jantu k'atsay tuchi panch'e'excha. Chi an ixpatrón ay lhima'alh'ajna kaxta'niya', kajat'amak'ana an yu jantu tajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Pus anchunu ma'tsuku mu li ixk'atsaycha li tani lhi'achaniycha an ixpatrón, walh chi li jantu mala'asijnilh chi jantu chuni ilhtulh tacha an ixjunkanta, kastak ayna'kana'. ");
INSERT INTO tpp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero yu jantu ixk'atsay chi li xliyucha lhi'ilhtulh yu lay kalhimama'alh'ajnikalh, wa ixlak'anti ka'ayna'kana'. Yu lhuwi ixta'nikanta, wachu lhuwi kask'inikana', chi yu palay lhuwi ixmalhistaknikanta, palay lhuw wachu kask'inikana'. ");
INSERT INTO tpp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Kit'in wa tacha wa ikmintacha mama'tayana jikmi an lakamunulhpa'. Chi, ¡iknajun wa laycha li kama'taylhcha! ");
INSERT INTO tpp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Akla'pusa tan alhp'as akilhila'ts'intanukana laka lhima'alh'ajna, chi sawalhcha ikma'alh'ajnan sta wa akxni chunchacha katapasaya'. ");
INSERT INTO tpp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ch'u nawnatcha li ikminta, sawalhcha lhi'acha katawlhkana ani lakaat'un? Jantu, kit'in klajunaw kala'aykana'. ");
INSERT INTO tpp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chaway ati'anta, tan lhipumakisi wilakalh, katala'apitsikana'. An ixpumat'utuk'an katat'ala'aya an ixt'uyunk'an chi an ixt'uyunk'an katat'ala'aya an ixt'utunk'an. ");
INSERT INTO tpp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","An xapay kat'ala'aya an ists'alh, chi an ts'alh kat'ala'aya an ixpay; chi an xanati kat'ala'aya an istsi', chi an jatsi kat'ala'aya an ixnati; chi an xaput'icha'o'olh kat'ala'aya an ixput'i, chi an xaput'i kat'ala'aya an ixput'icha'o'olh. ");
INSERT INTO tpp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Chi tacha an ts'anan ixlakyakalh jajumpalay an Jesús: ―Akxni la'ts'inat tak'ut'achalh jataputs'i an tan ta'aknuyachalh wilhchan nawnat: “Kamina an xkan”, walh chi min sawalh. ");
INSERT INTO tpp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chi akxni minachalh un lhitalaktsin, nawnat: “Lhi'ichi kajuna'.” Chi chuncha jun sawalh. ");
INSERT INTO tpp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Wa layatcha! Layi lhimach'a'xayat'it tani tasuycha an lakt'iyan chi an lakaat'un, ¿tasuch'a jant'u lay lhimacha'xayat tani t'awkancha chawayi? ");
INSERT INTO tpp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿T'asu li jant'u akst'u p'u'unk'anatcha tanyucha yu ts'ajwi? ");
INSERT INTO tpp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Li xamati chiwimaj'anan, ch'i li t'it'ap'incha laka jamach'alhkat, k'at'alakch'iwiniy laka tij akxni pulhijunka', para li k'ala'oxamixnit, jantu junita kamaj'ajuni la ix'ukxlakapu an juez, chi an juez kama'axta'ni la ixmakni an policia, chi an policia kamalaklhchajuncha. ");
INSERT INTO tpp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ancha ijkunan jant'u k'at'it'axt'u li jant'u map'alh'o'oy stunij yu jalhip'ininin. ");
INSERT INTO tpp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Yuchaka anchunu panch'e'ex, ali'in yu ancha ixta'a'yanalh an Jesús, ixtajuniycha li an Pilato jama'nilh lapanakni jamacha'an Galilea, chi an xak'alhnik'an t'alalhitayalhcha an ixjak'alhnik'an an jatapakxat yu ixtama'axta't'ajun ixla'ulank'an. ");
INSERT INTO tpp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","An Jesús ja'alhtaylh jajuniy: ―¿Nawnatcha li an lapanakni jamacha'an Galilea yu tani taputapasalhcha, xliyu palay ixtalhit'ajun ixtala'alhink'an, chi an ali'in yu de ancha wachu, jantu? ");
INSERT INTO tpp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Klajunaw, jantu. Li jant'u mak'awnat'iti mintala'alhink'an, wach'u k'alakniya'it. ");
INSERT INTO tpp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿U sna nawnat'iti li anchunu ixpumakawtsajink'an yu tanilh akxni ja'a'lhtants'ilh an torre an laka Siloé, palay ixtajalhi'aninin walh masi jantu an ali'in yu wachu an la'acha'an Jerusalén tawilanalh? ");
INSERT INTO tpp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Klajunaw, jantu. Li jant'u mak'awnat'iti mintala'alhink'an wach'u k'alakniya'it. ");
INSERT INTO tpp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Chi jajumpalh ani pulhamacha'xan: ―Pumatam lapanak ixch'anta a'atam higo tan stak ixch'anta ix'uva, akxni alhcha puxkawnini xajatawk'at an ixhigo jantu tu'u la'cha'aninilh. ");
INSERT INTO tpp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Pus juniy an yu ixmalhistaknita an ix'uva: “La'at'utucha k'ata chaway ikmin puxkawnini xajatawk'at ani xak'iw higo, pero jantu tawk'ay. K'at'ich'a'xt'icha, wa la'a'ijcha yalh ani lakaat'un.” ");
INSERT INTO tpp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","’Pero an yu ixjalhist'aknan an tan stak ixch'ankanta uva, alhtaylh an ixpatrón, juniy: “Patrón, k'at'imak'awnin ani k'ata, aktanti'aj'ulaya chi akmuniya abono. ");
INSERT INTO tpp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Li katawk'aniya xajatawk'at, oxicha, pero li jantu, k'at'ich'a'xa'acha.” ");
INSERT INTO tpp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","La'atam wilhchan akxni jastaknankan an Jesús ixmasut'ajun lakatam laka cha'a tan ixtata'ayxt'o'a an judiojnin, ");
INSERT INTO tpp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","walh ancha ixtanun pumatam t'aku yu la'akawtsajincha k'ata ixta'an'ajt'ajun. La'atam makxkay'uni chuncha ix'ilhtuy, wanajcha ixpuxk'awitta, jantucha k'is lay ixtats'awalay. ");
INSERT INTO tpp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Akxni la'ts'ilh an Jesús t'asanilh, juniy: ―Jant'uch'a ali k'at'it'a'an'at'i. ");
INSERT INTO tpp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chi lakpach'apachalhcha. Pus an t'aku wanaj wa akxni tats'awalalhcha, chi a'taynilhcha xta'niy lhimala'puchajun an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero an xajefe laka ch'a'a tan ixtata'ayxt'o'a, lhitalh'amalhi li an Jesús k'uch'ulhi akxni wa xawilhchan jastaknat, pus jajuniy an lapanakni: ―La'achaxan wilhchani yu tapatsakan, wa akxni k'at'at tak'uch'unin, jantu akxni xawilhchan jastaknat. ");
INSERT INTO tpp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wa chuncha an Jamach'alhkat Jesús alhtaylh, juniy: ―¡Wa t'a'ukxp'ut'uyununat'it! ¿Chu jantu atamj atami x'ot'iy ixburro u ixtoro tan ch'iyajuta, chi ancha ma'ot'unu xkan akxni wa xawilhchan jastaknat? ");
INSERT INTO tpp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chi ani istsi Abraham yu tachanu la'akawtsajincha k'ata ixch'i'ulata an Satanás, ¿jantu layi katix'otkalhi akxni wa xawilhchan jastaknat? ");
INSERT INTO tpp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Akxni chunchacha nawlh an Jesús, ixtalhimaxanancha an yu wa ixtaxkajiy, pero chux an ali'in ixtalaj'achancha li tacha an ixtala'ts'incha an Jesús ixlak'ilhtuy an yu jantu lay xamati chuncha ixlak'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chi jajuniy an Jesús: ―An ixlich'alhkat Dios, ¿tisuncha ixt'achuncha, chi tisuncha lay akt'alamaklhkalhi? ");
INSERT INTO tpp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wanaj tacha an xatalhts'i mostaza, yu xamati lapanak ch'an la ixlakaat'un. Ta'ayaycha, aycha k'iwi jun, chi an ts'o'on anchacha tamuk'ay ixpamaj'ank'an. ");
INSERT INTO tpp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Chi jajumpalay: ―An ixlich'alhkat Dios, ¿tisuncha lay akt'alamaklhkalhi? ");
INSERT INTO tpp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ixt'atami an lhamaskajan, li xamati t'aku lhiyajuy lhuw harina, wanaj maskaja'ojoy. ");
INSERT INTO tpp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","An Jesús ixla'la'pus'antacha lakt'ikt'i la'acha'anaxni chi tan laj'ay, akxni ixti'ancha la'acha'an Jerusalén, chi ixmasulhi'antacha an ixchiwinti. ");
INSERT INTO tpp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tichiyucha juniy: ―Jamach'alhkat, ¿chu wa lakats'uniya yu katata'alhtaxtuya'? Yucha juniy: ");
INSERT INTO tpp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―K'alhit'aalaat'iti li k'at'anuchi'it an tan wa put'ikt'i malhticha, mu klajunaw ixluwk'ani yu katatanuputunanta, pero jantu katilalh. ");
INSERT INTO tpp_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ixli'astan akxni an jamanawin an laka cha'a katayayacha chi kamalaklhchawyacha an ixmalhticha, yu ma'spa katalaktamakawtayayanta, katalaknawna: “Jamach'alhkat, Jamach'alhkat, akilamati'aniw.” Yucha kaja'alhtaya, kajajuna: “Jantu ijk'atsay t'anch'unch'a t'ant'achi'it.” ");
INSERT INTO tpp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Pus yu'uncha katajuna: “Ayxtami klat'alakwaytaw, chi klat'alaj'ottaw, chi an la kilajcallejk'an masut'i.” ");
INSERT INTO tpp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero yucha kajajuna: “Klajunaw jantu ijk'atsay t'anch'unch'a t'ant'achi'it'it. ¡Ix'ilhtunan tala'alhin, minchuxk'an k'ap'inchi'itcha!” ");
INSERT INTO tpp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ancha kastak laj'alhunkana chi wa xwat'at'acha kalaktasat'awkana', mu katala'ts'inacha an Abraham chi an Isaac chi an Jacob chi ixchuxk'an an yu ixtalhichiwiniy ixchiwinti Dios li la ixlich'alhkatcha Diosi tat'ajun, pero yu'uncha ma'spacha jamaka'ankalh. ");
INSERT INTO tpp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ali'in lhitan akxajachilh wilhchani kataminanta, chi ali'in tan lhita'aknuyachalh, chi ali'in lhitalaktsin chi ali'in lhi'alhma'ast'ay, katalaktawlacha laka mesa an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Kata'alina an yu chaway xati'astan tajunita, p'ulhnaja katajuna', chi an yu p'ulhnaj tajunita, xati'astani katajuna'. ");
INSERT INTO tpp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wa yuchaka wilhchan tacha'alh ali'in fariseojnin, tajuniy an Jesús: ―K'ap'inchicha, k'at'axt'ucha ani mu an Herodes ma'niputunan. ");
INSERT INTO tpp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yucha jajuniy: ―Anchunu ayajk'atsan k'ak'i'unit'it: “Li chaway chi lhiy ajkak'uch'uya an yu wa jalaklakpach'apay makxkay'un chi ajkak'uch'uya an ta'an'anin, chi t'uxam ak'ilhtu'oyacha.” ");
INSERT INTO tpp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero aktaylhi'ana kintij chaway, chi lhiy chi t'uxam, mu jantu layi ma'spacha la'acha'an Jerusalén katinilh yu lhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén, Jamacha'an Jerusalén, jama'niyat'iti an yu talhichiwiniy ixchiwinti Dios, chi jalakt'alhmayat'iti an yu jamakt'anik'anat'it! ¡A'lhuwcha ijkamach'ixtamiputulh mijas'at'ank'an, tacha xanati piyu yu jama'ay xas'at'an la ixpa'achuj, pero jant'u k'is la'a'it'it! ");
INSERT INTO tpp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pus chaway amincha'ak'an aklakamakawna', chi klajunaw jantu akintilala'ts'incho'o, sta akxni k'anawna'it: “Lhimala'puchajuncha an yu Dios mala'achatachalh.” ");
INSERT INTO tpp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A'tamchacha akxni wa xawilhchan jastaknat an Jesús alh t'alakwayna pumatam xa'ay fariseo, akxni tanuchalhcha laka cha'a, an ali'in wa ixtalhist'ak'acha li tu'ucha ka'ilhtulh yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chi an la ixlakapu ixwilh pumatam lapanak wa ixpakxanta ixjak'unti. ");
INSERT INTO tpp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pus an Jesús jajuniy an yu ixtala'mispay lhamap'a'sin chi an fariseojnin: ―¿Layi ajkak'uch'unulh akxni wa xawilhchan jastaknat? ");
INSERT INTO tpp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero yu'uncha jantu ta'alhtaylh. Pus an Jesús ma'ch'apachalhi an yu wa ixta'an'ay, k'uch'ulh chi mala'achacho'olhcha. ");
INSERT INTO tpp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chi jajuniy an fariseojnin: ―¿Xamati uxitnan, li ixburro u ixtoro ka'alh tan a'talhman, jantu wa tukan kamakutulhi masi akxni jantu tapatsakan wilhchan? ");
INSERT INTO tpp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yu'uncha jantu lay tu'u ta'alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","An Jesús sa'cha ixjala'ts'ini tacha ixtalaksakxtuy tan palay lhitapalay putawlan an laka mesa, an yu ixjat'awaykan. Chi jajunilh la'atam pulhamacha'xan, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Akxni xamati aylhi'anan k'ap'it'i t'ama'wayna tan tama'xto'kan, jant'u k'at'a'ulhi tan palay lhitapalay, wa lay chilh yu palay lhitapalay, yu wachu t'awayputunkan, ");
INSERT INTO tpp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","chi kajunin an yu tat'awaynan: “Yucha aniya katawla an t'an wilht'i, chi uxint'i k'amaxanajp'it'icha tan xati'astan wilhchalh putawlan.” ");
INSERT INTO tpp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Apalij akxni t'asanik'an t'awayp'ut'unk'an, xati'astani k'at'awlhchi', walh akxni kachina an yu t'awayputunan kajunan: “Amigo, palaych'a k'ast'alh t'at'i. Chuncha oxicha katala'ts'inan an ali'in yu k'ajat'at'awla'a laka mesa.” ");
INSERT INTO tpp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mu yu sawalhcha lhitapalayi najun jantu tu'u katilhitapalalh, pero yu jantu tu'u lhitapalay lay, yucha kalhitapala'. ");
INSERT INTO tpp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chi an Jesús, wachu jumpalayi an lapanak an yu ix'aylhi'anta ka'alh t'alakwayna, juniy: ―Akxni ilht'uy la'atam wayt, jant'u k'ajat'asanini mi'amigojnin, chi mijat'ala'awnin, chi yu t'a jalhila'ts'in chi yu wanich'a jat'alakwilht'i yu talhit'ajun ixtumink'an, mu yu'uncha wachu wa katat'a'upalani tu'u', pus k'amap'usp'itnich'o'ok'ana'acha. ");
INSERT INTO tpp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Akxni ilht'uy la'atam wayt, k'ajat'asanin an jakilhpatinin, chi an lakmaklht'ulukun, chi an lakch'anlht'ulukun, chi an la'la'lhtulu'un. ");
INSERT INTO tpp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Walh laniy chuncha oxi para uxint'i, mu yu'uncha jantu lay katitamapusp'itnicho'on, pero anchacha oxi k'alhi'o'xla'ts'inch'o'ok'ana'a akxni katala'awcho'oya an yu ixtajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Akxni chunchacha alha'asmat'a pumatam yu ancha ixt'awilh laka mesa, juniy: ―¡Oxi para yucha yu kama'waynanta an la ixlich'alhkat Dios! ");
INSERT INTO tpp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pus an Jesús juniy: ―Pumatam lapanak mala'asijnilh ay wayt chi ixluwk'ancha jajunilh li kata'anacha ma'waynin. ");
INSERT INTO tpp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chi akxni chilhcha ixpaku an wayt, mala'achalhcha pumatam ixma'tsuku ka'alh jalakjunini an yu ixjamak'atsaanikantacha, jajuniy: “K'at'atcha, mala'asijni'okantacha an wayt.” ");
INSERT INTO tpp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero tachalayjcha ixtalhikilh'an. Pumatam najun: “Iktamawlh ay kilakaat'un, pus ancha ak'ana laka'ana'. Lamapaynin ak'imak'akxanin.” ");
INSERT INTO tpp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Chi pumatam najun: “Ijkatamawlh la'akaw xapay torojnin yu japutapatsakan chi ak'ana jalhila'ts'intanunu'. Lamapaynin ak'imak'akxanin.” ");
INSERT INTO tpp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chi pumatam najun: “Wa ikt'atsukukalhka, pus jantu lay akti'alh.” ");
INSERT INTO tpp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Akxni tasp'itcho'ochalhcha an ma'tsuku, jun'olhi an ixpatrón. Pus lhitalh'amalhi an ixpatrón, chi juniy an ixma'tsuku: “Watukan k'ap'inchi an laka lajcalle chi an laka lakt'ikt'i callejon, k'ajalhit'ana'acha an jakilhpatinin, chi an lakmaklht'ulukun, chi an lakch'anlht'ulukun, chi an la'la'lhtulu'un.” ");
INSERT INTO tpp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ixli'astan walh an ma'tsuku najun: “Patrón, ik'ilhtulhcha an t'ach'a k'ilhi'un, pero alinka tan kalaktawlakalh.” ");
INSERT INTO tpp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Pus an ixpatrón juniy: “K'ap'inchi an laka laktij chi an tan wa lakput'ikt'icha tij yu lhima'spacha an la'acha'an, chi k'a'asi lhit'ana'a an la kincha'a yu k'ala'ch'ip'ina'a para li ka'a'tsamkalh. ");
INSERT INTO tpp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Mu klajunaw jantu xamati kati'ulh ani wayt an yu p'ulhnaj xajkat'awayputun.” ");
INSERT INTO tpp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wanajcha lhilhuwi ixch'a'o'akanta an Jesús, chi tala'asp'itlhi, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Li xamati kint'ak'uxa'an, pero li jantu palay kimapayniy, li palay mapayniya ixpay u ixnati u ixt'iwi u ixjas'at'an u ixjat'ala'awnin u ixjamatsanan chi yu wa ix'akstucha ixjatsukunti, jantu lay katiwalh kint'alhtana'. ");
INSERT INTO tpp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yu jantu ma'alh'ajnamputun tacha kit'in chi jantu kinch'a'o'aputun, jantu lay katiwalh kint'alhtana'. ");
INSERT INTO tpp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tacha uxitnan, li xamati yawputun la'atam torre, p'ulhnaj kasa' tawla chi ka'ilhtuyacha ixcuenta para li kak'atsaalhi li kata'a'tsaniya yu kalhiyaw'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Li jantu, li ka'ilhtuniyacha ixjach'aja, chi ixli'astan tucha lay kati'ilhtu'olh, yu an tala'ts'in katamamaxaniyacha, ");
INSERT INTO tpp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","katajuna: “Ani lapanak lhi'a'taynilhcha yajuy an torre, walh jantu lay ilhtu'olh.” ");
INSERT INTO tpp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","U xamati rey, akxni ka'ana t'alat'alhna pumatam ixt'arey, ¿jantu p'ulhnaj sa' tawlay chi past'ak'acha li layi kalakatast'uk'a an ixt'arey, li yucha wa la'akaw milhi ixlapanak, chi an ixt'arey yucha la'ap'uxam milh? ");
INSERT INTO tpp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chi li jantu katilalh, akxni an pumatam ma'atka mintachalh, kajamak'aniya yu kata'ana mak'ats'aninin li wa oxicha katalalhi'alh. ");
INSERT INTO tpp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pus wanajcha chuni watichicha yu uxitnan, yu jantu makaw'ojoyi watuchicha lhit'ajun, jantu lay katiwalh kint'alhtana'. ");
INSERT INTO tpp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’An matsat oxi, pero li ma'ats'an'ay an is'o'onti, ¿tasicha lay kalhitapalhpala'a? ");
INSERT INTO tpp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Masi wa yucha an lakaat'uncha u an abono, jantucha tu'u lhitapalhniy, yucha wa maj'ankancha. Yu lhit'ajuni ixpa'asmatna, ka'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ixchuxk'an an yu ixtalaklhach'inin tanlhun chi an la'ma'lhta'alhinin ixtala'cha'ancha an Jesús, para li kata'alha'asmatlhicha. ");
INSERT INTO tpp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pus an fariseojnin chi an xamaestrojnin lhamap'a'sin ixtalhichiwiniycha an Jesús, ixtajuniy: ―Ani jala'a'iya an ma'lhta'alhinin chi jat'alakwajin. ");
INSERT INTO tpp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wa chuncha an Jesús jajunilh la'atam pulhamacha'xan, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Uxitnan xamati li yu lhit'ajun tam ciento ixborregojnin chi li akxni kama'ats'an'alh la'atam, ¿jantu katijamakawlhi an t'at'ip'uxamkawnajatsi (99) an tan jama'amaniy, chi ka'anacha puxkawna an yu ma'ats'an'ata sta kalhitajuya'? ");
INSERT INTO tpp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Li akxni lhitajucho'oycha, achancha a'x'o'alhimincho'oy. ");
INSERT INTO tpp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chi akxni cha'ancho'oycha la ixcha'a, jama'ayxt'o'acha an yu oxi jat'alalhi'an chi yu waniycha jalakt'awilh, jajuniy: “Kalaj'achawcha, mu kla'cha'ancho'olhi an kiborrego yu ists'an'ata.” ");
INSERT INTO tpp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","’Kit'in klajunaw chuncha palay lhi'acha junachalh an lakt'iyan akxni xamati makajun ixtala'alhin chi tapaxaycha, walh jantu masi ixt'at'ip'uxamkawnajatsik'an (99) yu oxi tat'ajun, yu jantu tu'u ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’U kanajuw, xamati t'aku li lhit'ajun a'xkaw ixtumin, chi kama'ats'an'alh a'xtam, ¿jantu kamapulhkuya ixpumaklhku, chi kajap'alhnanacha, chi sawalhcha ixlak'anti kapuxkawya sta li jantu kala'cha'ana'? ");
INSERT INTO tpp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Akxni la'cha'ancho'oycha, jama'ayxt'o'acha an yu oxi jat'alalhi'an ixt'at'akunin, chi yu waniycha jalakt'awilh, jajuniy: “Kalaj'achawcha, mu kla'cha'ancho'olhi an kintumin yu xakma'ats'an'ata.” ");
INSERT INTO tpp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Klajunaw chuncha talaj'achanachalh an ix'angelhnin Dios akxni pumatam ma'lhta'alhini makajuncha ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Chi nawpalay an Jesús: ―Pumatam lapanak ixjalhit'ajun ixt'uyunk'an ists'alan. ");
INSERT INTO tpp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","An xalakat'ikt'i juniy an ixpay: “Kimpay, ak'ixt'a'nincha amintanlhun yu ki'anucha kajuna'.” Pus jala'xta'nilhcha yu ix'anuchak'an kajuna'. ");
INSERT INTO tpp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jantu tukancha ma'an walh, an xalakat'ikt'i ists'alh an lapanak, st'amaj'an'olhi an yu xta'nikalh, pus ma'atcha pu'alh an tumin, lakatamcha lakaat'uni stak lakch'apachalh an ixtumin, wa tani ixputijunt'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Akxni lakch'apa'olhcha, alilh ay chawani anchunu lakaat'un, pus tsukulhcha pachawaniya yucha. ");
INSERT INTO tpp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Pus wa chuncha la'alh pumatam lapanak yu ancha jamacha'a', sk'inilhcha tapatsat. Pus mala'achakalhcha ka'alh jalhistakna p'axnin. ");
INSERT INTO tpp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wa laycha li wachucha chuni ka'ixwaylh tacha an ixtawajin an p'axnin, pero jantu xamati ixta'niy yucha. ");
INSERT INTO tpp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pus sa'cha ixjatapastaknan, ixnajun: “La ixcha'a an kimpay ixluwk'ani jalhit'ajun ixma'tsukunin, chi yu'uncha wa taxajnicho'oyachalh cha yu ta'uy. Chi kit'in ani iknit'ajuncha kinchawan. ");
INSERT INTO tpp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Akla'ancho'oya an kimpay, chi ajkuna: Kimpay, wa stakcha ik'ilhtunitani tala'alhin uxint'i chi an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jantucha ikt'acha'ani ak'i'un mints'alh. Wa tacha xapumatamcha amima'tsukunini ak'i'ilht'u!” ");
INSERT INTO tpp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pus wa chuncha wakcha ancho'olh, cha'ancho'olhcha an la ixcha'a ixpay. ’Akxni ma'atka ix'antachalh, an ixpay la'ts'istuklhi, pus mapayniycha, la'ats'alaj'alhcha chi la'atanustuklhicha chi la'xtikilhtastuklhicha. ");
INSERT INTO tpp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","An ists'alh juniy: “Kimpay, wa stakcha ik'ilhtunitani tala'alhin chi an lakt'iyan, jantucha ikt'acha'ani ak'i'un mints'alh.” ");
INSERT INTO tpp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero an ixpay jajuniy an ixma'tsukunin: “K'alas lhit'anchi'it la'ch'it yu palay oxi, k'amala'ch'init'it, chi k'amamakt'anut ix'aniyoj, chi k'amach'ant'anut'it ixwarachi. ");
INSERT INTO tpp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","K'ak'i'it n yu ontacha jas'at'a toro chi k'ama'nit'itcha, kalak'uyaw, ka'ilhtuyaw k'a tan. ");
INSERT INTO tpp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mu aniy kints'alh tachanu ixnitacha, walh tachanu la'awcho'olh, chi tachanu ists'an'atacha, walh la'cha'ancho'o.” Pus tsukulhcha talaj'achan. ");
INSERT INTO tpp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’An yu xa'ay ists'alh an lapanak ma'spa an la'acha'ani ixt'awnachalh, walh akxni ixcha'ancho'ot'ajuncha an la ixcha'ak'an, asmat'acha li lakasanankan chi li lakat'ininkan. ");
INSERT INTO tpp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pus t'asanilh pumatam ixma'tsuku an ixpay, lhisakmiycha tuchini alincha. ");
INSERT INTO tpp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","An ma'tsuku juniy: “Yucha amint'ala'ajuni chincho'olh, chi aminpayk'an lhinawlhi li kama'nikalhcha an yu ix'ontacha jas'at'a toro, wa xliyu li ma oxi t'ajun chincho'olh amint'ala'ajun.” ");
INSERT INTO tpp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wa chuncha lhitalh'amalhi an xa'aycha ists'alh an lapanak, jantucha ixtanuputuni an la ixcha'ak'an, pus an ixpay taxtulh tapayniniycha li katanulh. ");
INSERT INTO tpp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero yucha alhtaylh juniy an ixpay: “La'alhuwcha k'ata ikt'atapatsat'awnan kit'in, chi jantu a'tami wa ak'asmatmaj'anincha, walh jantu a'tami masi wa lakat'ikt'icha chivo ak'ixt'a'nin para li ajkat'alak'ulhcha yu oxi ijkat'alalhi'an. ");
INSERT INTO tpp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero li chilh ani mints'alh yu wa stakcha jakit'alakch'apalh mintumin yu wa aya talay t'akunin, lhima'nit'i an yu ix'ontacha jas'at'a toro.” ");
INSERT INTO tpp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pus wa chuncha juniy an ixpay: “Kints'alh, uxint'i lhilhiji ani k'int'awilht'i, pus chux an yu iklhit'ajun minawin. ");
INSERT INTO tpp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero chaway chuncha yu lhitask'iniy li ka'ilhtuwi ani k'atan chi kalaj'achaw, mu amint'ala'ajun, tachanu ixnitacha, pero la'awcho'olh, chi tachanu ists'an'atacha, chi la'cha'ancho'o.” ");
INSERT INTO tpp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Wachu jajumpalay an ixt'alhtanan an Jesús: ―Ixt'ajun pumatam lapanak jamatumin, ixlit'ajun pumatam xa'ay ixma'tsuku', walh an ixma'tsuku ta'alhtasulh li ma wa la'lha'amananiycha an ixlaktanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pus t'asanilh chi juniy: “¿Tasu li tacha anicha k'asmat'a tajunani? Ak'i'uncha t'ani yu t'ap'ats'at'acha, mu chaway tucha lay ali uxint'i ak'int'it'ala'ts'ilhip'i an kintapatsat.” ");
INSERT INTO tpp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pus an xa'ay ma'tsuku najun: “¿Tasucha aklhit'alaya chawayi, mu an kimpatrón akimaxtuniyacha an kintapatsati? Chi jantucha ijk'ut'ilhi para li aktapatsalh chi wa aksk'inlhicha tu'u, ikmaxanan. ");
INSERT INTO tpp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ijk'atsaalhcha tani aklhit'alayacha para li kata'alilhi yu akintala'a'ilh la ixcha'ak'an akxni akimaxtunikanacha an kintapatsat.” ");
INSERT INTO tpp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pus atamj atamjcha jat'asanilh an yu ixtalhi'aniy an ixpatrón, pumatam juniy: “¿T'asunch'a lhip'iniy an kimpatrón?” ");
INSERT INTO tpp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yucha alhtaylh juniy: “Tamciento barrilh asayteje iklhi'aniy.” Pus an xa'ay ma'tsuku alhtaylh, juniy: “Ni'ijcha an jalhiki tan tasuy t'ani ch'unch'ach'a jalhip'ininin, k'at'a'ulhcha chi k'ats'o'muk'acha wa cincuenta.” ");
INSERT INTO tpp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ixli'astan jumpalay pumatam: “¿Chi uxint'i, tasunch'a jalhip'ininini?” Yucha juniy: “Tamciento kuxtalh trigo.” Pus an xa'ay ma'tsuku alhtaylh, juniy: “Anicha malhi an jalhiki tan tasuy yu j'alhip'ininin, k'ala'oxich'o'o a'xtam yu wa ochentajcha katasulh.” ");
INSERT INTO tpp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pus an jamatumin lapanak najuni li sawalhcha s'alalhi an ixma'tsuku ixjunita, mu sawalhcha lhipuxkawnilhi tani lhit'alalhcha an tanlhun. Chunchacha an yu chaway ani t'awkan lakamunulhpa', yu wa tu'ucha tu'u talat'atamakajun wa li sawalhcha la's'alalan, chi an yu t'awkan laka jatapulhkunu tachanu apalij jantu. ");
INSERT INTO tpp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Kit'in klajunaw, k'ajapulhajaxt'ut'iti mi'amigojnink'an an tanlhuncha alin laj'oxi ani lakamunulhpa', walh laniy akxni kamin'oya, uxitnan k'ala'a'ik'ana'it'iti an lakt'iyan tan minputawlh'alhinchak'an. ");
INSERT INTO tpp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Yu oxi lhist'ak'a masi wa lakats'uniy tu'u, wachu oxi kalhist'ak'a yu lhuw tu'u', pero yu jantu oxi lhist'ak'a masi wa lakats'uniycha tu'u, wachu jantu oxi katilhistaklhi yu lhuw tu'u'. ");
INSERT INTO tpp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pus mu li an yu jantu xasawalh laj'oxi tanlhun lak'alin ani lakamunulhpa jant'u wa oxich'a lhist'ak'at, ¿tisiyuchacha katalhiwilayan li oxi k'alhist'ak'a'it an yu laj'oxi tanlhun sawalhi? ");
INSERT INTO tpp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chi mu li jant'u oxi lhist'akt'it yu jantu mi'anuk'an, jant'u k'at'ixt'a'nik'ant'iti yu mi'anuk'an. ");
INSERT INTO tpp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Jantu xamati ma'tsuku lay ixt'uyunk'an patronin jat'atapatsay, mu an pumatam jantu oxi katila'ts'ilh, chi an pumatam chun, u an pumatam kakiklaka'iya, chi an pumatam jantu. Jantu lay wa ayxtam t'atapatsakan Dios chi an tumin. ");
INSERT INTO tpp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","An lapanakni yu ixjajunkan fariseojnin sa'cha ixta'alha'asmat'a an Jesús, chi mu yu'uncha sawalhcha ixta'achaniya an tumin, pus jantucha oxi ixtalhichiwiniy an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","An Jesús jajuniy: ―Uxitnani yu jantu tu'u mintala'alhink'an layat t'an la'ts'ink'anat, pero an Dios yucha tak'atsaaniyani tani mijalhunutchak'an, mu an lapanakni masi yu sawalhcha talapulhiwilay tu'u, an Dios yucha jantu k'is la'ts'imputun. ");
INSERT INTO tpp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Akxni jantuka' istsukuy an Jama'paxanaj Juan, an Dios ixlakask'in li an lapanakni chuncha kaxtatsukulh tacha an ixnajunta la ixlamap'a'sin an Moisés chi tacha an ixtats'o'ta an yu ixtalhichiwiniy ixchiwinti Dios. Sta akxnicha tsukulh lhichiwinkan an ixlich'alhkat Dios, pus chaway wa tichi kawalhi lhit'aalay tanuputunachalh. ");
INSERT INTO tpp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Pero palay wa lasi li an lakt'iyan chi an lakaat'un ka'ukla'olh, walh jantu masi wa k'ischa jantu chun kawalh tacha an ts'o'kanta laka lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Wa tichicha yu makajun ixt'iwi chi t'atsukupalaycha pumatam t'aku, tala'alhincha ilhtuy. Chi yu t'atsukuy an t'aku an yu makawkalh, wachu tala'alhincha ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ixt'ajun pumatam lapanak jamatumin, sawalhcha oxi ixmala'ch'inin chi lhilhiji ix'ilhtuy oxi k'atan, ixlakwaykan. ");
INSERT INTO tpp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chi wachu ixt'ajun pumatam jakilhpatinij lapanak ixjunkan Lázaro, wa stakcha ixlakats'its'ita chi sa'cha ixtalakxtutawlay an la ixmaticha an jamatumin lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wa laycha li kax'usaklhicha an tacha ixpatajuy xatach'e'e yu ixlak'ukan la ixmesa an jamatumin, chi masi wa x'oyuncha ixtacha'an ixtalaksnawniycha an la ists'its'i. ");
INSERT INTO tpp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Walh milh wilhchan an jakilhpatini, nilhcha. Pus an angelhnin talhi'alhcha tan kat'atawlantacha an Abraham, chi an jamatumin wachucha nilh, pus maknukalhcha. ");
INSERT INTO tpp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Walh akxni an jamatumin lapanak stakcha ixma'alh'ajnant'ajuni an laka la'nin, tala'st'aycha, pus wa ma'at la'ts'incha an Abraham, chi an Lázaro sa'cha piktuwilhchalh. ");
INSERT INTO tpp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pus t'asajlaka'aniycha, juniy: “¡Kimpay Abraham! Lamapaynin k'amala'ach'achi an Lázaro para li ka'awalhi an ix'akatan ixmaka laka xkan, chi akimats'uk'unk'unilhi an kisima'at, mu sawalhcha ikma'alh'ajnani ani laka jikmi.” ");
INSERT INTO tpp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero an Abraham juniy: “Kints'alh, k'ap'ast'akt'i, uxint'i jama'lht'ayancha la mijatsukunti laj'oxi mintanlhun, chi ani Lázaro wa stakcha ma'alh'ajnalh. Pero chaway yucha anicha ma'oxamixikan, chi uxint'i st'akch'a ma'alh'ajnan. ");
INSERT INTO tpp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Atumpaj wanaj a'talhmani yu kintamala'apitsiyan, pus masi xamati yu kitnan ka'amputunchalh anchunu, jantu katilalh, chi xamati yu uxitnan kamimputulh ani, wachu jantu katilalh.” ");
INSERT INTO tpp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Pus an jamatumin lapanak ixjunita, najun: “Pus sawalh iktapaynisk'iniyani kimpay Abraham li k'amala'ach'at'ika an Lázaro an la ixcha'a kimpay, ");
INSERT INTO tpp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","mu ijkalhit'ajun ixkisink'an kijat'ala'awnin, kajamak'atsaanilh, para li jantu katamilh wachu ani tan ay lhima'alh'ajna.” ");
INSERT INTO tpp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","An Abraham juniy: “Talhit'awnachalhcha an tan ts'o'muk'ata Moisés chi an yu ixtalhichiwiniy ixchiwinti Dios, yuchacha kata'asmatchalh.” ");
INSERT INTO tpp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yucha najun: “Jantu, kimpay Abraham, li xamati ka'alh yu ixnitacha kataja'asmatnantachalh.” ");
INSERT INTO tpp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero an Abraham alhtaylh: “Li jantu ta'asmatniya an Moisés chi an yu talhichiwiniy ixchiwinti Dios, wachu jantu katitakiklaka'ilhi masi xamati kajala'alh yu ixnitacha.” ");
INSERT INTO tpp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","An Jesús jajuniy an ixt'alhtanan: ―Jantu layi jantucha kati'alilh yu kaputa'a'takalh, pero yu walhuncha ilhtuyi li xamati ka'ilhtulh tala'alhin, ");
INSERT INTO tpp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","yu ilhtuyi li kats'antijlalhi xapumatam ani xalakt'ikt'in, palay oxi kalhtuj ch'ipixtanukalh xachiwx palakskitin, chi kawarjcha maka'ankalh alamalh. ");
INSERT INTO tpp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","K'ajalajk'ats'anant'it. ’Li xamati mint'ala'ajun ilhtuniyan tu'u tala'alhin, kala'a'aymat'i, chi li astan najun, k'amala'mixinin. ");
INSERT INTO tpp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Chi li tam wilhchan, a'tujuni tu'u yu jantu oxi ilhtunin, chi li a'tujuni la'cha'ancho'on junan: “Astan iknajun, jantucha chuni aktilalh”, k'amala'mixinin. ");
INSERT INTO tpp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","An ixpumakawt'uyk'an ixtat'alhtanan an Jesús, tajuniy: ―Jamach'alhkat, ali akilaxta'niwi jakiklaka'inti. ");
INSERT INTO tpp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pus an Jesús jajuniy: ―Li k'ajak'iklak'a'inint'it masi wa tacha an xatalhts'icha mostaza, layi k'a'una'it'it ani k'iw junkan sicómoro: “K'a'ost'i, an lakxkancha k'at'ayachi'”, walh kata'asmatniyan. ");
INSERT INTO tpp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Li xamati yu uxitnan lhit'ajun pumatam ixma'tsuku yu anta jalhistakna mintorojk'an u anta mulhini t'un la minkuxtuk'an, akxni chincho'oycha, ¿ch'u sna unat'it: “K'at'anut'icha, k'at'a'ulhcha, k'awaycha?” ");
INSERT INTO tpp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Li mu jantu, uxitnan unat: “K'ajamap'axancha oxi, ak'ila'oxinincha yu ak'uya chi ak'i'iniya'acha, ixli'astan k'awayna'acha wachu chi k'a'ot'a'acha wachu yu otp'ut'un akxni ikway'ojotacha kit'in p'ulhnaj.” ");
INSERT INTO tpp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chi wachu jantu xta'niya lhimala'puchajun an ixma'tsuku an yu lhinajun, li ilhtunilhcha yu lhijunilh. ");
INSERT INTO tpp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wanajcha chuni uxitnan, akxni ilht'ut'atcha yu talhijunan Dios, k'anawna'it: “Jantu oxi ma'tsukunini kitnan, mu an yu ik'ilhtuw wa xliyu kilhi'ilhtutk'an.” ");
INSERT INTO tpp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Akxni ixti'ancha la'acha'an Jerusalén an Jesús, lhitapitsicha xalakaat'un Samaria chi Galileaja ixpula'pust'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Walh akxni cha'alh lakatam la'acha'an, taxajnichilh ixpumakawk'an lapanakni yu wanajcha ixtalakap'uch'i'ojota, wa ma'atcha sa' tatayachalh ");
INSERT INTO tpp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","chi ixtat'asajlaka'aniycha, ixtajuniy: ―¡Jesús, Maestro, klask'iniyaw ay lamapaynin! ");
INSERT INTO tpp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Akxni jala'ts'ilh an Jesús jajuniy: ―K'ajak'it'alak'asunit'it an sacerdotejnin. Walh akxni wa ixtita'anka, tatala'a'oxi'olhcha. ");
INSERT INTO tpp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pus xapumatam, la'ts'inkancha li tala'a'oxilhcha, tasp'itcho'ochalh, ixta'niycha lhimala'puchajuni an Dios, ixlipukilht'asaycha. ");
INSERT INTO tpp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tatso'ottatawlhnilhcha la ixlakapu an Jesús, tamuntitachalhcha, ixta'niycha lhimala'puchajun. Ani lapanak jamacha'a Samaria. ");
INSERT INTO tpp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","An Jesús najun: ―¿Chu jantu ixpumakawk'ani an yu tatala'a'oxilh, an ixpumanajatsik'an tanischa tat'ajuni? ");
INSERT INTO tpp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jantucha xamati kak'uxamilh xta'nini lhimala'puchajun Dios, wa yucha anicha yu jantu ani jamacha'a'? ");
INSERT INTO tpp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pus an Jesús juniy an lapanak: ―K'at'aycha, k'ap'inch'o'ochicha; mu jak'iklak'a'inin p'us t'ak'uch'ut'icha. ");
INSERT INTO tpp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","An lapanakni yu ixjajunkan fariseojnin talhisakmilh an Jesús taniwanancha kachina an ixlich'alhkat Dios, yucha ja'alhtaylh jajuniy: ―An ixlich'alhkat Dios jantu katila'ts'inkalhi akxni kamina'. ");
INSERT INTO tpp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jantu katinawkalh: “¡Jo', k'ala'ts'int'itcha, anicha t'ajun!”, u “¡anucha t'awnachalh!” Mu an ixlich'alhkat Dios tat'a'aklat'awnancha. ");
INSERT INTO tpp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chi jajuniy an ixt'alhtanan: ―Kamina panch'e'exi akxni uxitnan akilala'ts'imputunawi kit'in yu ikwalh isTs'alh Lapanak, masi wa la'atamcha wilhchan, pero jantu akintilala'ts'iw. ");
INSERT INTO tpp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chi k'a'unk'ana'it: “¡Aniya t'ajun, u anu t'awnachalh! Pero jant'u k'ap'it'it, jant'u k'ajach'a'o'at'it.” ");
INSERT INTO tpp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Mu akxni akmina kit'in yu ikwalh isTs'alh Lapanak, wa tacha akxni an jamakalipnini kalaya', limj jamakalipnini ixlitapiktutam an lakt'iyan chi sta ixtapiktutami makacha'an. ");
INSERT INTO tpp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero p'ulhnaj akstak ma'alh'ajnana', jantu k'is akintitala'a'ilhi an yu chaway tat'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tacha akxni an ixt'ajun Noeje katapasaya akxni kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Akxni ixt'ajun an Noé, an lapanakni ixtalakwajin, ixtalaj'ot'a, chi ixtalat'atsukuy chi ixtalamat'atsukuy, sta wa akxni tajulhcha an laka ay barco an Noé, chi an lapanakni yu'uncha wanaj talakni'olhi an laka a'muxtut. ");
INSERT INTO tpp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wanajcha chun tacha tapasalh akxni ixt'ajun an Lot. Ixtalakwajin, ixtalaj'ot'a, ixtajatamawnan, ixtajast'anan, ixtajach'ananan chi ixtayajuy ixcha'ak'an. ");
INSERT INTO tpp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero akxni taxtulhcha an la'acha'an Sodoma an Lot, an lakt'iyan tacha wa xkancha patajulh jikmi, wanaj jama'ni'olhi an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chuncha katapasaya akxni kamina an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Akxni, yu uk'achalh la ix'a'sti ixcha'a, jantu kata'alhtajulhi ka'alh maxtunu ixlaktanlhun, chi yu t'awnachalh la ixkuxtu jantu katasp'itcho'ochalh. ");
INSERT INTO tpp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","K'ap'ast'akt'iti tacha putapasalh an ixt'iwi Lot. ");
INSERT INTO tpp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yu kama'alhtaxtuputuna ixjatsukunti, kama'ats'an'aya', chi yu kama'ats'an'aya, kama'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Klajunaw anchunu jatats'isni tan ixt'uyunk'an tamanalh la ixputamatk'an, an pumatam kalhi'ankana', an pumatam jantu. ");
INSERT INTO tpp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Li ixt'uyunk'an t'akunin wa lakatam taskitit'ajun, an pumatam kalhi'ankana', chi an pumatam jantu.  ");
INSERT INTO tpp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tan ixt'uyunk'an lapanakni tat'ajun laka kuxtu, an pumatam kalhi'ankana chi an pumatam jantu. ");
INSERT INTO tpp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pus ta'alhtaylh an Jesús, tajuniy: ―¿Tanischa chuncha katapasaya'a, Jamach'alhkat? Yucha jajuniy: ―Tan tamay tu'u yu nitacha, ancha tatawlachalh an ch'unin. ");
INSERT INTO tpp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Chi jalhixa'alapalh la'atam pulhamacha'xani an Jesús tan japujuniy li lhitask'iniya li lhilhij katatapaynilh, chi li jantu a'tami wa katakapmaj'ancho'olhcha, ");
INSERT INTO tpp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","jajuniy: ―Ix'alin pumatam juez lakatam la'acha'an, jantu ixkiklaka'iya Dios chi jantu xamati tu'u ixliwilay ixt'alapanak. ");
INSERT INTO tpp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chi anchunu la'acha'an wachu ixt'ajun pumatam t'aku yu jantucha tu'u ixt'ajun ixt'apapa', ixla'cha'an an juez, ixjuniy: “Ak'int'alats'awalat'i ixlakata an yu wa kint'ala'ajiy.” ");
INSERT INTO tpp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero an juez ma'ani jantu ix'asmatniy, walh ixli'astan pastaklhi: “Masi jantu iktalhamniya Dios chi jantu xamati tu'u iklhiwilay, ");
INSERT INTO tpp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ak'a'tayjuyacha ani yu jantucha tu'u ixt'apapa t'aku', mu sawalhcha kimin ma'achapunu', jantu junita li wa paktsincha min sawalhcha akija's mawalh.” ");
INSERT INTO tpp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chi nawpalay an Jesús: ―K'a'asmatt'iti tacha an nawlh an yu jantu oxi juez. ");
INSERT INTO tpp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Chu laycha an Dios jantu katijat'alats'awalalhi li tu'u an yu jasakxtutacha, li ts'isi chi tunkuw talhitapaynisk'iniy? ¿Kata'a'ma'aya para li kaja'alhtaylh? ");
INSERT INTO tpp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kit'in klajunaw watukan kajalhi'a'tayjuya'. Pero akxni akmina kit'in yu ikwalh isTs'alh Lapanak, ¿ajkala'cha'ana yu tajakiklaka'inin? ");
INSERT INTO tpp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","An Jesús jalhixa'alapalh la'atam pulhamacha'xan, ixlakatak'an an yu ixtapast'ak'a li jantu tu'u ixtala'alhink'an, chi jantucha tu'u ixtat'alalhiwilay an ali'in, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Ixt'uyunk'an lapanakni ta'alh tapayninin laka tajtan, pumatam yu'uncha an jajunkan fariseojnin chi pumatam yu'uncha an talaklhach'inin tanlhun lhimapalhlhi'at. ");
INSERT INTO tpp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","An fariseo wa sa' ixyalhi ixtapaynit'ajun, ixnajun: “Ikxta'niyan lhimala'puchajuni Dios, mu jantu chuni iklay tacha an ali'in. Yu'uncha taja'alhawanan, chi sawalh ay tajunita, chi tat'atamayi yu jantu tat'at'ajun, chi jantu chuni iklay tacha ani yu laklhach'inin tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kit'in iklhitask'ajayi kiwayt, a't'uyi tam samana, ikxt'a'a kidiezmo akxni iklhajay.” ");
INSERT INTO tpp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero an yu ixlaklhach'inin tanlhun wa ma'ati ixyachalh, yucha masi wa katala'st'alhcha an lakt'iyan jantu ixtala'st'aputun, wa p'as ixtankilhaksakan, ixnajun: “Lamapaynini Dios, ak'imala'mixinini kintala'alhin.” ");
INSERT INTO tpp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iklajunaw an yu ixlaklhach'inin tanlhun yucha oxicha tsukulh la ix'ukxlakapu Dios, pero an fariseo jantu. Mu yu sawalhcha lhitapalayi najun jantu tu'u katilhitapalalh, pero yu jantu tu'u lhitapalay lay, yucha kalhitapala'. ");
INSERT INTO tpp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wachu ixjalhicha'anikan lakt'ikt'in jas'at'ani an Jesús para li kajalaklakpach'apalh la ix'a'tsulhk'an pero an ixt'alhtanan an Jesús talaj'aymastuklhi an yu ixtalhicha'an ixjas'at'ank'an. ");
INSERT INTO tpp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pus an Jesús jat'asanilh jajuniy: ―Kachajcha kintala'milhi an jas'at'an, jant'u k'ajalaj'aymast'ukt'it, mu an ixlich'alhkat Dios ixnawink'an yu tacha yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sawalhi ani yu iklajunaw, yu jantu la'a'iya an ixlich'alhkat Dios tacha pumatam jas'at'a, jantu a'tam katitanuchalhi ancha. ");
INSERT INTO tpp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pumatam xa'ay lapanak lhisakmiy an Jesús, juniy: ―Oxi Maestro, ¿tisuncha lay ak'ilhtulh para li aklhitsukulhi jatsukunti yu jantu a'atam min'ojoyi? ");
INSERT INTO tpp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","An Jesús juniy: ―¿T'asu li k'i'uniycha li oxi klapanaki? Wa pumatami yu oxi lapanak, Dios. ");
INSERT INTO tpp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","K'ats'aycha an lhamap'a'sin tan najun: “Jant'u k'at'at'amat'i yu jant'u t'at'a'un, jant'u k'ajama'nin, jant'u k'aja'alhawan, jant'u xamat'i wa aya k'alhich'iwin, ch'i oxi k'ala'ts'i mimpay chi minati.” ");
INSERT INTO tpp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","An lapanak najun: ―Chunchacha ik'ilhtu'ojoy wa kintats'alat. ");
INSERT INTO tpp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","An Jesús mu alha'asmat'acha, juniy: ―Ts'an'aniyanka la'atami yu k'a'ilht'u: K'ast'a'o chux an yu lhit'a'un chi k'ajaxt'a'nincha an jakilhpatinin. Ch'unch'a k'alhits'uk'uya'acha laj'oxi mintanlhun an lakt'iyan. Chi k'at'ana'acha, ak'inch'a'o'aya'acha. ");
INSERT INTO tpp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pus an lapanak akxni chunchacha alha'asmatlhi an Jesús, sawalhcha lhita'oxila'alhilh, mu sawalh ix'alin ixtumin. ");
INSERT INTO tpp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chi an Jesús, mu la'ts'incha li lhita'oxila'alhiycha, najun: ―¡An yu jamatuminin lhima'anxkayi katatanuchalh an la ixlich'alhkat Dios! ");
INSERT INTO tpp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Palay wa lasi la'atam camello kastaala'pusli ma'atam makskat, walh jantu li katanuchalh pumatam jamatumin la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","An yu ta'alha'asmatlhi tanajun: ―¿Pus tisiyuchacha lay kata'alhtaxtuya'a? ");
INSERT INTO tpp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","An Jesús ja'alhtaylh jajuniy: ―Yu jantu lay ilhtuy an lapanak, an Dios yucha layi ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pus an Pedro juniy: ―Jamach'alhkat, kitnan iklach'a'o'atawcha chi iklhimakaw'otawcha kintanlhunk'an. ");
INSERT INTO tpp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yucha juniy: ―Wa tichicha li yu lhimakajuntacha ixcha'a, ixt'iwi, u ixjat'ala'awnin u ixpaynin u ixjas'at'an ixlakata an ixlich'alhkat Dios, o'sliyani ");
INSERT INTO tpp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","li palay kajama'lhtayanana masi wa anika t'awkan, chi an yu mimpalhtachalh jatsukunti kajama'lhtayanana yu jantu min'ojoy jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wa lakatamcha jama'ayxto'lhi an ixpumakawt'uyk'an ixt'alhtanan an Jesús, chi jajuniy: ―Akxni kacha'anawcha la'acha'an Jerusalén, kalaktapasayacha tacha an kintalhits'o'muk'ata yu ixtalhichiwiniy ixchiwinti Dios kit'in yu ikwalh isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mu akima'axta'kanacha la ixmaknik'an an yu jantu judiojnin, chi akintalhilaktsi'inacha, akixkayaj tajuna, chi akintala'achujwaya'. ");
INSERT INTO tpp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chi ixli'astan akxni akintala'ana'ma'oyacha, akintama'niyacha, pero ixlila'at'utu wilhchan akla'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yu'uncha jantu tu'u talhimacha'xanilh, tuchini ixjalhixa'alaycha tacha ani jajunilh, mu yu chuncha jantu lay ixtalhimacha'xay. ");
INSERT INTO tpp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Akxni waniycha ix'antachalh la'acha'an Jericó an Jesús, pumatam la'lhtuluw lapanak yu sa' ixwilh la ixpiktu tij, ixpusakt'ajun la'a'tayjun, ");
INSERT INTO tpp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","lhasakminilhi tuchini ixtapasaycha akxni asmatlhi li lhilhuw ixla'pust'awk'an. ");
INSERT INTO tpp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pus tajuniy li yucha an Jesús jamacha'a Nazareti ixla'pust'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yucha p'asi chiwinilh, najun: ―¡Jesús, Ists'alh David, lamapaynin ak'ilhi'a't'ay'ut'i! ");
INSERT INTO tpp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","An yu ixtap'ulanan tala'a'aymalh para li ma sa'cha kakilhulh, pero yucha palay p'as ixt'asay, ixnajun: ―¡Ists'alh David, lamapaynin ak'ilhi'a't'ay'ut'i! ");
INSERT INTO tpp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pus an Jesús sa'cha tayalh, chi mala'achalhcha pumatam para li kaki'ilh. Akxni la'cha'alhcha an Jesús, junkan an la'lhtuluw lapanak: ");
INSERT INTO tpp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tasucha ak'ilhtun na'uni? An la'lhtuluw lapanak najun: ―Jamach'alhkat, iklakask'in li ajkalakawanalh. ");
INSERT INTO tpp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","An Jesús juniy: ―K'ajalak'awancha, mu jak'iklak'a'inin p'us p'ut'ak'uch'ut'icha. ");
INSERT INTO tpp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wanaj wa akxni, wa tukan tala'pu'oxilhi an la'lhtuluw lapanak ixjunita, chi ch'a'o'alhcha an Jesús, ixta'nilhi'antacha lhimala'puchajuni an Dios. Chi ixchuxk'an an yu tala'ts'ilh, wachucha oxi ixtalhichiwiniy an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Akxni tanuchalhcha an Jesús la'acha'an Jericó, anchacha ixla'pust'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Walh pumatam lapanak ixjunkan Zaqueo, xa'ay an yu ixtalaklhach'inin tanlhun, chi jamatumin, ");
INSERT INTO tpp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ixmispaputuni an Jesús, pero jantu lay ixla'ts'in, mu wanajcha lhilhuwi ixjunkanta chi yucha wa putant'ikt'i ixjunita. ");
INSERT INTO tpp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pus jats'alaj'alhi tan ixtipu'an an Jesús, chi tawk'alhcha laka a'atam k'iw junkan sicómoro para li laycha kala'ts'ilh, mu ancha ixla'pust'ajun an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","An Jesús akxni anchacha ixla'pust'ajun tala'st'alh, pus la'ts'ilh, chi juniy: ―Zaqueo, lasch'a k'at'a'alht'a'ut'i, mu chaway an la mincha'a aktamakawna'. ");
INSERT INTO tpp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Wa chuncha so'ojo ta'alhtajulh chi sawalhcha ixta'achanini lakatastuklhi. ");
INSERT INTO tpp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Akxni chunchacha tala'ts'ilh, ixtalhichiwiniycha an Jesús, ixtanajun ma t'a'alhcha la ixcha'a pumatam ma'lhta'alhini'. ");
INSERT INTO tpp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wa chuncha an Zaqueo tayalh, chi juniy an Jamach'alhkat Jesús: ―Jamach'alhkat, an paytat kintanlhun ajkaxta'niyacha an jakilhpatinin, chi li xamati tu'u ik'o'xcho'ota, a't'at'i akmapusp'itnicho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","An Jesús juniy: ―Chaway ani laka cha'a' chilhcha ta'alhtaxtut, mu ani lapanak wachu ists'alh an Abraham. ");
INSERT INTO tpp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mu kit'in yu ikwalh isTs'alh Lapanak ikminta japuxkawna chi ikminta jama'alhtaxtunu an yu wa tats'an'ata. ");
INSERT INTO tpp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Chunchacha ixta'alha'asmatt'ajun an lapanakni an Jesús. Chi taylhi'alh jajumpalh la'atam pulhamacha'xan, mu waniycha la'acha'an Jerusaleni ixt'ajun chi yu'uncha ixtanajun li an ixlich'alhkat Dios akxnicha kachina'. ");
INSERT INTO tpp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jajuniy: ―Pumatam lapanak jamatumin chi lhitapalay, alh jama'lhtayana ixlich'alhkat tanchun ma'at lakatam la'acha'an, pero katasp'itcho'oyanta. ");
INSERT INTO tpp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akxni jantuka' ixtaxtuy p'ulhnajcha jat'asanilh ixpumakawk'an ixma'tsukunin, chi pumatamincha jaxta'nilh ixtumin, jajuniy: “K'ap'ut'ap'ats'atka' kachajcha aktichincho'oya'.” ");
INSERT INTO tpp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero an yu ancha ixt'amacha'an sawalhcha ixtaxkajiy, pus tamach'a'o'alhi yu kanawnanta: “Jantu ikla'a'iyawi li ani lapanak akintach'alhkatnanin.” ");
INSERT INTO tpp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Pero yucha lhka'ulakanchalhcha ixlich'alhkat, chi akxni tasp'itcho'ochalhcha, lhinawlhcha li kajat'asanikalhi an ixma'tsukunin an yu ixjaxta'nita ixtumin, para li katajunilhcha tanichunchacha talhajanilh pumatamin. ");
INSERT INTO tpp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pumatam yu p'ulhnajcha cha'alh najun: “Jamach'alhkat, an mintumin a'kawcha lhajacho'olh t'ach'a an k'ixt'a'nin.” ");
INSERT INTO tpp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","An jamach'alhkat alhtaylh: “Oxicha, oxi ma'tsukuk'at'i, mu oxi lhist'akt'i masi yu jantu lhuw, chaway lakakaw la'acha'anaxni k'ajach'alhk'atnaniya'a.” ");
INSERT INTO tpp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Cha'ampalh pumatam, najun: “Jamach'alhkat, an mintumin a'kisicha chuncha lhajacho'olh.” ");
INSERT INTO tpp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yucha wachu juniy: “Uxint'i lakakisi la'acha'ani k'ajach'alhk'atnaniya'a.” ");
INSERT INTO tpp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Pero pumatam cha'ampalh, najun: “Jamach'alhkat, ani iklhiminitani an mintumin, xakpach'ima'ata laka payo, ");
INSERT INTO tpp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","mu iktalhamniyan, mu uxint'i sawalhch'a unit'a, maxt'uyi masi t'an jant'u uxint'i t'amaknut'i, ch'i jax'anani masi t'an jant'u uxint'i ch'ant'i.” ");
INSERT INTO tpp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pus an jamach'alhkat juniy: “Uxint'i jantu oxi ma'tsukuk'at'i, t'ach'a an ch'iwiniycha ikpuk'atsaniyan. Li ixk'ats'ay li kit'in sawalhcha ikjunita, chi li wanaj stuniji iksk'in'ojoyi li tu'u, chi ikjap'uxnuni tan jantu kit'in ikch'anlhi, ");
INSERT INTO tpp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿pus tasu li jant'u ma'anut'i laka bancojo an kintumini, para li akxni xakchincho'olh xajkama'lhtayanalhcha an xajas'at'a?” ");
INSERT INTO tpp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Chi jajuniy an yu ancha ixtayanalh: “K'amaxt'unit'iti an tumin, yucha an yu a'kaw pulhajacho'olhi k'axt'a'nit'it.” ");
INSERT INTO tpp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yu'uncha tajuniy: “Jamach'alhkat, pero yucha a'kawcha chuncha lhit'ajun.” ");
INSERT INTO tpp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pus an jamach'alhkat ja'alhtaylh jajuniy: “Kit'in iklajunaw, li yu lhit'ajun, ali kaxta'nikana', pero yu jantu tu'u lhit'ajun, masi wa lakat'ikt'icha kaxlitsukulh, kamaxtuni'okana'. ");
INSERT INTO tpp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chi an yu jantu kintala'ts'imputun, an yu jantu ixtala'a'iy li ajkach'alhkatnanilh, k'ajalhit'at'it chi tan ijkala'ts'incha k'ajama'nit'it.” ");
INSERT INTO tpp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Akxni chunchacha naw'olh, taylhi'ampalhcha ixtij an Jesús, tama'ast'a'alhcha la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Walh akxni ixcha'ant'ajuncha la'acha'an Betfagé chi la'acha'an Betania, waniycha a'stitawk'a tan junkan Laka Olivojnin, jamala'achalh ixt'uyunk'an an ixt'alhtanan, ");
INSERT INTO tpp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","jajuniy: ―K'ap'inchi'it an tan tasuy la'acha'an, chi akxni k'at'anut'achi'it k'ala'ch'ip'ina'it la'atam burro, ch'iyawkanta, tuka' a'tam putawk'akan, k'ax'ot'iya'it chi akilalhiminiyaw. ");
INSERT INTO tpp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Li xamati talhisakmiyan t'uch'ini lhix'ot'iyatcha, k'a'una'it li yucha an Jamach'alhkati ma'lhtask'iniy. ");
INSERT INTO tpp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ta'alhcha an yu jamala'achakalh, walh tala'cha'alhcha sawalhi an burro tacha an ixjajunita an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Akxni ixtax'ot'it'ajuncha an burro, an yu jamanawinin talhasakminilhcha tanajun: ―¿T'asu li x'ot'iyatcha an burrojo? ");
INSERT INTO tpp_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yu'uncha taja'alhtayanalh: ―Mu yucha an Jamach'alhkati ma ma'lhtask'iniy. ");
INSERT INTO tpp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pus ta'aymuk'alhcha an burro an yu ixjapupula'la'axt'a'kanta, talhi'anilhcha an Jesús chi tapumuk'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tan ixpu'anta laka tij an Jesús, an lapanakni ixtalakmamaycha an yu ixjapupula'la'axt'a'kanta. ");
INSERT INTO tpp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chi akxni ixcha'ant'ajuncha an Jesús tan a'taynitacha jatajunti an a'stitawk'a tan junkan Laka Olivojnin, chux an yu ixtach'a'o'ata ixtalaj'achancha, p'ascha tsukulh talakt'asay, ixtaxta'niycha lhimala'puchajuni an Dios ixlakata li lhuwcha ixtala'ts'inta yu ilhtuy an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ixtalaknajun: ―¡An Dios kintamakminitan pumatam rey! ¡Alincha oxamixat an lakt'iyan chi an Dios yucha ayi anu lakt'iyan! ");
INSERT INTO tpp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Wa chuncha ali'in lapanakni an yu ixjajunkan fariseojnin yu ancha ixtama'anta tajuniy an Jesús: ―Maestro, k'ajalaj'aymat'i an mint'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yucha jajuniy: ―Li kasa' talajkilhulh, yu'uncha an chiwxi katalakt'asaya'. ");
INSERT INTO tpp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Akxni waniycha cha'alh an la'acha'an Jerusalén an Jesús, la'ts'incha, pus lhi'alhulhcha, ");
INSERT INTO tpp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","najun: ―Wa laycha li k'axk'ats'at'icha tichini yu laycha ka'ixta'nin oxi jatawlhnat chaway. Pero chaway jant'u lay k'at'ila'ts'i. ");
INSERT INTO tpp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kamina wilhchani akxni katala'atanchanuyan an yu taxkayan. Katalakyawya ch'ak'ani an laka ay axi an yu pula'atanchanukanta la'acha'an, chi wa lhitanchuncha kawalh kataput'alasayan, ");
INSERT INTO tpp_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","chi katama'ni'oyan. Katama'niniyani amijas'at'an ani ixpulakni la mincha'a', chi jantu tu'u katitamakawlh masi wa kala'ukxtawk'atawilhcha chiwx ani, mu jant'u asmatp'ut'u akxni an Dios kila'pixiyalhnanchin. ");
INSERT INTO tpp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ixli'astan an Jesús tanuchalhcha an laka tajtan chi jatamakxtu'olhi an yu ancha ixtajast'anant'ajun, ");
INSERT INTO tpp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jajuniy: ―Ts'o'muk'akanta tan najun: “An kincha'a putapaynin”, pero uxitnan wa ixcha'achak'an ja'alhawnani ilht'ut'at. ");
INSERT INTO tpp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lhilhiji ixmasuy an laka tajtan an Jesús, pero an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin chi an xalaj'ajin lapanakni wa ixtama'niputujlhit'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero jantu lay ta ixta'ilhtuy, mu chux an lapanakni yucha ixtalhakapu'aniniy yu ixjajuniy. ");
INSERT INTO tpp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","La'atam wilhchan akxni an Jesús ixjamasunit'ajun an lapanakni laka tajtan chi akxni ixjajunt'ajun an laj'oxi chiwinti, tala'cha'alh an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin, chi an laktatanincha, ");
INSERT INTO tpp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","chi taxa'alalh tajuniy: ―Akilajuniwi t'uch'ini ch'unch'ach'a lhi'ilht'uy ani laktanlhun, u tichini yuchacha makawniyan li ch'unch'a k'a'ilht'u. ");
INSERT INTO tpp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","An Jesús ja'alhtaylh, jajuniy: ―Kit'in wachu aklalhisakmiyaw la'atam lhasakminti. Akilajuniw: ");
INSERT INTO tpp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tacha an ixjama'paxanan Juan, ¿Diosi ixlijuniy, u wa yucha an lapanaknicha? ");
INSERT INTO tpp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pus yu'uncha tsukulhcha talhilakchiwiniy, talajuniy: ―Li kajunaw li Diosi ixmakmintachalh, akintajunan: “¿P'us ch'i li jant'ucha k'iklak'a'it'iti?” ");
INSERT INTO tpp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chi li kajunaw li wa yu'uncha an lapanaknicha ixtalhijuniy, chux an lapanakni akintalakat'alhmayan, mu ixchuxk'ani takiklaka'iy li an Juan ixchiwinti Diosi ixlichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pus taja'alhtayanalh li jantu tak'ats'ayi tichini yuchacha ixmala'achatachalh an Juan li kajama'paxanalh. ");
INSERT INTO tpp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Wa chuncha an Jesús jajuniy: ―Kit'in wachu jantu aktilajuniwi tuchini laycha chuncha iklhi'ilhtuy ani tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wa chuncha an Jesús tsukulhcha jajuniy la'atam pulhamacha'xani an lapanakni, jajuniy: ―Pumatam lapanak ch'anlhi ix'uva, chi jamach'ixta'nilhcha tichi yu'uncha lapanakni, chi yucha ma'ancha alh tanchun ma'at. ");
INSERT INTO tpp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Akxni ixpakucha walh an uva, mala'achachalhcha pumatam ixma'tsuku para li kataxta'nilhcha an yu ixjamalhistaknita yu ixnawincha, pero yu'uncha wa talakasamanilh, pus wachuncha cha'ancho'olh. ");
INSERT INTO tpp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chi a'tam mala'achapalhchalh pumatam ixma'tsuku', pero wachu wa talakasamanipalh, xkayajcha tajunilh chi wa chuncha wachu tamala'achacho'opalh. ");
INSERT INTO tpp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Walh a'tam mala'achapalhchalh pumatam ixma'tsuku' pero wanajcha chun, tatamakxtupalh chi tamak'atsanilh. ");
INSERT INTO tpp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Pus wa chuncha an jamanawin an tan ch'ankanta uva najun: “¿Tasucha aklhit'alaya'a? Akmala'achaya an kints'alh, masi wa pumatami kints'alh, ka sna katakiklaka'iyanta yucha.” ");
INSERT INTO tpp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero an yu ixjamalhistaknikanta uva, akxni tala'ts'ilh, talajuniy: “Yucha anicha yu kajama'lhtayanana an herencia, kama'niw, walh lani ki'anuchak'ani kajuna'.” ");
INSERT INTO tpp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pus tatamakxtulhi an tan ixch'ankanta uva chi tama'nilhcha. ’¿Chaway uxitnan t'asuch'a lhiwilayat kaja'ilhtuya an jamanawin uva an yu ixjamalhistaknita ix'uvaja? ");
INSERT INTO tpp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yucha ka'ana, chi kajama'ni'oya an yu ixtajalhistaknanta, ali'ini kajaxta'niya an tan ch'anta ix'uva. Akxni chunchacha ta'alha'asmatlhi tanajun: ―¡Dioscha akintama'alhtaxtun! ");
INSERT INTO tpp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero an Jesús sa'cha jala'ts'in chi jajuniy: ―Pus, ¿tasipi nawputuncha an tan ts'o'muk'akanta? tan najun: An chiwx an yu tala'amaj'alh an tayajuy cha'a, apalij yucha yu palay lhitapalalh. ");
INSERT INTO tpp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yu la ix'ukxni ani chiwx katamayanta, wanaj lakt'ikt'i kajun'oya', chi yu kaputamaya ani chiwx, wanaj po'xmi kajun'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wa akxni an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin ixtach'apayawputuncha an Jesús, mu talhimacha'xalhi li yu'uncha jajunilh an tacha nawlh. Pero jantu tach'apayawlhi mu ixtatalhamniya an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ixli'astan tamala'achalhcha yu kata'alh jalakawanin an tan ixt'ajun an Jesús, ma wa oxicha lapanakni katalalh, para li kata'alh'a'taymalhcha tu'u chi chuncha laycha katama'axta'nilh an xajamach'alhkat Roma. ");
INSERT INTO tpp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","An yu ixta'anta jalakawanin tajuniy an Jesús: ―Maestro, ijk'atsayawi li an yu na'un ch'i an masuy chuncha sawalh, chi para lhichuxi an yu na'un, uxint'i ts'awj sawalhi masuy an ixtij Dios. ");
INSERT INTO tpp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Oxi li akmapalhlhi'aniw an xajamach'alhkat Roma, u jantu? ");
INSERT INTO tpp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero an Jesús ja'uksak'atsalhi li jantu oxi an yu ixtala'anta, pus jajuniy: ―¿Tasu li kilalhila'ts'intanuyawcha? ");
INSERT INTO tpp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Akilamasuniw a'xtami an tumin. ¿Tisapiyuchacha an puwilh chi an ixta'a'ut? Yu'uncha ta'alhtaylh, tajuniy: ―Yucha an ay xajamach'alhkat Roma. ");
INSERT INTO tpp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","An Jesús jajuniy: ―P'us k'axt'a'nitcha yu ix'anu an xajamach'alhkat Roma chi yu ix'anu an Dios wach'uch'a k'axt'a'nit'it. ");
INSERT INTO tpp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wa chuncha jantu layi tu'u ta'alh'a'taymalh yu ixjajuniy an lapanakni, para li katach'apayawlhcha, apalijcha sa' talajkilhulh, mu ixtalhi'a'niycha tacha an ja'alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ixli'astan an Jesús tala'cha'alh ali'in lapanakni yu ixjajunkan saduceojnin, yu an tanajun li tucha lay katila'awcho'okalh, talhisakmilh. ");
INSERT INTO tpp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tajuniy: ―Maestro, an Moisés kintats'o'nin tan najun: Li xamati tam t'aku li nimakawtijlakalh chi li jantu t'ajamas'at'analhi ixt'apapa pero li an yu nilh lhit'ajuni ixt'ala'ajun, yuchacha kat'atsukucho'oya an t'aku para li katajamas'at'analhi tacha kaxt'ajamas'at'analh an ixt'ala'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pus ixtat'ajun ixpumatujunk'an wa lhit'ala'awnin, an xa'aycha t'atsukukalhcha, walh nilh, chi jantu tu'u jamakawlh ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pus wa chuncha an t'aku t'atsukupalhi an ixt'ala'ajun an yu nilhcha, walh wachu nipalh, chi jantu tu'u jamakawpalh ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chi a'tam t'atsukupalhi yu ixlipumat'utucha, chi sta jat'atsuku'olhi an ixpumatujunk'an, walh talakni'olh, jantu tu'u tamakawlh ixjas'at'ank'an. ");
INSERT INTO tpp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ixli'astan, wachucha nilhi an t'aku'. ");
INSERT INTO tpp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pus akxni kala'awcho'okana, ¿an ixpumatujunk'an wa lhit'ala'awnin tisiyuchacha ixt'iwi kajuna an t'aku, mu an ixpumatujunk'an tat'atsuku'olhi? ");
INSERT INTO tpp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","An Jesús ja'alhtaylh, jajuniy: ―Yu chaway ani t'awkan an lapanakni chi an t'akunin jat'atsukukan. ");
INSERT INTO tpp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero li yu an Dioscha kanawna li katala'a'iya an sast'i jatsukunti yu wa ka'alinaka, chi katala'awcho'oya, akxni jantucha katitalat'atsukulh. ");
INSERT INTO tpp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mu akxni tucha lay katitanilh, akxni tacha an angelhnincha katajuna', chi ixjas'at'ancha an Dios, mu xliyu li katala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero an Moisés wachu najuni li kala'awcho'okana', tan an lhits'o'muk'alh an jach'itin yu junkan zarza yu ixma'tajita, akxni nawlh an Moisés li an Dios, ixDios Abraham, chi ixDios Isaac chi ixDios Jacob, ");
INSERT INTO tpp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","mu an Dios jantu ixDiosk'an janinin, yucha ixDiosk'an yu tala'ajunta, mu para yucha, tala'aw'ojota. ");
INSERT INTO tpp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ali'in an xamaestrojnin lhamap'a'sin ta'alhtaylh, tajuniy: ―Oxi t'ach'a an na'uni Maestro. ");
INSERT INTO tpp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pus jantucha tu'u tatapujulh ali katalhisakmilh. ");
INSERT INTO tpp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wa chuncha an Jesús jajuniy: ―¿Tasu li tanajuncha li an Cristo ists'alh Daviti? ");
INSERT INTO tpp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero mu yucha an Daviti nawpalay an laka libro tan junkan Salmos, najun: An Jamach'alhkat Dios juniy an kiJamach'alhkat Cristo: “K'at'a'ulhcha tan oxi la kimpa'xti', ");
INSERT INTO tpp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sta kachajcha aktijamama'oya la mijach'aja an yu wa taxkayan.” ");
INSERT INTO tpp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Pus an David ixJamach'alhkati juniy an Cristo, ¿tasucha li ists'alh a'tami? ");
INSERT INTO tpp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ixchuxk'an an lapanakni ixta'alha'asmat'acha an Jesús chi jajuniy an ixt'alhtanan: ");
INSERT INTO tpp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Walh kata'o'xcho'oni an xamaestrojnin lhamap'a'sin, mu yu'uncha ta'achaniy tala'la'ch'iy la'lhman ixla'ch'itk'an, chi talakask'in li sawalhcha kajalhiwilakalhi kajala'axa'alakalh an laka laktij. Chi tapuxkajuy tan lhitapalay putawlani an laka lakcha'a tan pulakta'ayxto'kan chi tan p'ulhnaja talaktawlhputun an tan lakwaykan. ");
INSERT INTO tpp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tamaxtuniya ixcha'ak'an an yu jantucha tu'u ixt'apapak'an t'akunin, chi para wa jantucha kajak'atsanikalh wa panijniycha tatapayniy. Yu'uncha palay katala'a'iya lhima'alh'ajna. ");
INSERT INTO tpp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","An Jesús sa'cha ixjala'ts'ini an jamatuminin lapanakni tacha ixtamujuy ixtumink'an laka la'atam kaja. ");
INSERT INTO tpp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chi wachu la'ts'ilh pumatam jakilhpatinij t'aku yu jantucha tu'u ixt'apapa', ma'mujulh a'xt'uy lakt'ikt'i ixtumin yu jantu oxi tsasnat. ");
INSERT INTO tpp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Chi najun: ―Sawalhi ani yu klajunaw, ani t'aku yu jantucha tu'u lhit'ajun ixt'apapa palay mujulh, walh jantu ixchuxk'an an ali'in. ");
INSERT INTO tpp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Mu ixchuxk'an an ali'in wa xaxajnicha talha'ulananilh an Dios; pero ani t'aku masi wa kilhpatiycha wanaj muju'olhi masi yu ka'ixlitamawwaytsukulh. ");
INSERT INTO tpp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ali'in ixtalhilakchiwint'ajun an tajtan, tacha an ixtala'ts'in lajk'usi an chiwx chi li lhuwcha lha'ulani ixta'kanta yu lhiyawkalh. Pero an Jesús jajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Kamina wilhchani t'ach'a ani la'ts'inat'it, jantu tu'u katitayalh, masi wa kala'ukxtawk'atawilhcha chiwx. Kalakt'ilhi'okana'. ");
INSERT INTO tpp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wa chuncha talhisakmiy, tajuniy: ―Maestro, ¿tasu wanancha chuncha katapasaya'a? chi ¿tisuncha kapuk'atsakana akxni chunchacha katapasaya'a? ");
INSERT INTO tpp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yucha jajuniy: ―K'ajalajk'ats'anant'it para li jant'u k'a'o'xch'o'ok'ant'it, mu ixluwk'ani yu katamina katanawna li yu'uncha Cristojnin, chi jantucha ma'an, waniycha, pero jant'u k'ajach'a'o'at'it. ");
INSERT INTO tpp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Akxni k'a'asmat'a'itcha li lasakancha chi lat'alhkancha, jant'u k'alakt'alhanant'it, mu lhitask'iniya li chuncha katapasalh, pero jantuka' kati'ukla'olh. ");
INSERT INTO tpp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wa chuncha jajumpalay: ―La'atam ay la'acha'an, kat'alasaya lakatam ay ixt'ala'acha'an, chi tan rey ch'alhkatnan ay la'acha'an wachu kat'alasaya tan wachu rey ch'alhkatnan. ");
INSERT INTO tpp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kastak laklaya p'asi an lakaat'un, chi lakalhuwi ka'alina chawan, chi ta'an'at, chi kalaktalakasuya tanlhun lhitalhamnit an lakt'iyan, chi tanlhuncha laj'ay tu'u katalakasuyanta an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero akxni jantuka' chun tapasay, k'ach'ap'ayawk'ana'it'it, ch'i k'ach'a'o'ak'ana'it'it, k'ama'axt'a'k'ana'it'iti an laka lakcha'a tan puta'ayxt'o'aw chi laka lakpulach'in, k'alhip'ink'ana'it'iti tan tawilanalh an rejnin chi an jamach'alhkatni, kilakata. ");
INSERT INTO tpp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ch'unch'a yu lay k'ajap'u'una'it an kinchiwinti. ");
INSERT INTO tpp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero jantu li sna p'ulhnajcha k'at'ip'ast'akt'iti t'ani k'anawna'itcha akxni k'aja'alht'ayanana'it, ");
INSERT INTO tpp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","mu kit'ini aklaxta'niyaw laj'oxi jatapast'ak'at chi chiwinti yu jantu lay ta katita'alhtaystukni chi jantu katitalhitayanilhi an yu wa taxkayan. ");
INSERT INTO tpp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Masi milakpaynink'an u mijat'ala'awnink'an, u yu t'a jalhila'ts'inat u yu oxi jat'alalhip'inat, kata'o'xcho'oma'axt'a'an. Chi ali'in k'ama'nik'ana'it'it. ");
INSERT INTO tpp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chi ta lhichuxi k'axk'ayk'ana'it kilakata. ");
INSERT INTO tpp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero masi wa ma'atamcha mi'ayk'an, jantu tu'u katits'an'alh. ");
INSERT INTO tpp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Li t'aylhip'inat'it, ch'unch'a k'ap'ut'a'alht'axt'uya'it'it! ");
INSERT INTO tpp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Akxni la'ts'inatcha li tala'atanchanu'olhcha soldadojnin an la'acha'an Jerusalén, k'ats'ayatcha li chilhcha ixwilhchan li kalakt'ilhikanacha. ");
INSERT INTO tpp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Akxni, yu xalakaat'un Judea tat'ajun, an laka a'stitawk'ancha katalaj'os'alh. Chi yu an la'acha'an Jerusalén tat'ajun, katataxtulh, chi yu lakakuxtun inta tat'ajun, jantu kata'alhi an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mu akxni ixpaku ay lhima'alh'ajna kajuna', tan katapasa'oya tacha an ts'o'muk'akanta. ");
INSERT INTO tpp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Payni'incha an t'akunin yu ixt'a'akxni taja'aynanta, chi yu ixt'a'akxni talhit'ajun yu tamats'ik'ika ixjas'at'ak'an! Mu ka'alina ay lhima'alh'ajna an lakaat'un chi ay talhanti katala'ts'ina anchunu lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ali'in kajama'nikana laka espada, ali'in kajalhi'ankanacha tacha tach'inin wa tanchuncha la'acha'anaxni. An yu jantu judiojnin kastak talhitama'chapuya an jamacha'an Jerusalén, sta tacha ixlima'an jamakawnikanta. ");
INSERT INTO tpp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Chi tuchichuncha kalaktapasaya an laka wilhchan, chi an laka malhkuyu, chi an laka lakst'aku, chi an lakaat'un ta kilhmakchux an lapanakni katalaktalhananacha. Chi jantucha katilhimacha'xakalhi tacha an lhitalhan kamakat'awna an alamalh, chi tacha an kamilh milh laya'. ");
INSERT INTO tpp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","An lapanakni katala'la'awitijta'a'tayacha ixtalhantik'an, mu katapast'ak'acha tani katapasayacha an lakamunulhpa'. Sta tacha an lakwilhchalh lakt'iyan, wachu kajalakchikixkana'. ");
INSERT INTO tpp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wa chuncha kala'ts'inkanacha an yu walh isTs'alh Lapanak, tacha kaminanta laka jataputs'i, alhp'as chi wa xlimjnik'acha. ");
INSERT INTO tpp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Akxni chunchacha kalaj'a'tayniya kalaktapasaya ani laktanlhun, oximaj'ayi k'a'unt'it, k'alakt'alak'at'iya'ut'it, mu akxni wa k'ischa k'ama'alht'axt'uk'ana'itcha. ");
INSERT INTO tpp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wachu jajumpalh ani la'atam pulhamacha'xani an Jesús, jajuniy: ―K'alhak'ap'up'it'it an xak'iw higo u watuchicha k'iw. ");
INSERT INTO tpp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Akxni la'ts'inatcha li lakmininicho'otacha xax'oy, k'ats'ayatcha li waniycha lhi'ichi kajuncho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pus wanajcha chuni uxitnan, akxni la'ts'inatcha li chunchacha laktapasay, waniycha minta an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Kit'in klajunaw yu sawalh, akxni chuxcha chuncha kalaktapasaya, lhilhuwi kala'ts'inkana', mu katsukukanaka'. ");
INSERT INTO tpp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","An lakt'iyan chi an lakaat'un ka'ukla'oya', pero an kinchiwinti jantu. ");
INSERT INTO tpp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’K'as'alajnant'it, jantu junita kat'ak'alh lalhi mijalhunutk'an ixlakata an wa tanlhuncha t'a'ap'at, u wa tanlhuncha lhatapastaknat ani laka jatsukunti. Li ch'unch'a k'alaya'it, akxni jant'u s'alaj wilat'iti chuncha katapasaya tacha an klajuniw. ");
INSERT INTO tpp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Mu wa tacha s'apa kamina para ixchuxk'an an yu ani tawilanalh lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Lhilhiji k'as'alajnant'it, ch'i k'at'ap'aynit'it, para li layi k'at'a'alht'axt'ut'it tacha an kalaktapasaya', ch'i ch'unch'a layi k'ach'ip'it la ix'ukxlakapu an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","An Jesús, tunkuw ixmasuy an laka tajtan, pero puts'ista an a'stitawk'a tan junkan Laka Olivojnini ix'an. ");
INSERT INTO tpp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chi wats'isini an lapanakni ixta'an alha'asmatnin an Jesús an laka tajtan. ");
INSERT INTO tpp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Waniycha ixchint'ajun ixk'atan pan yu jantu ixliyawkan lhamaskajan, yu junkan Paxku. ");
INSERT INTO tpp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin ixtalhipuxkawniycha tani katalhima'nilhcha an Jesús, pero jantu lay ixta'ilhtuy mu ixtatalhanani li wa lay katalhitalh'amalh chux an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wa chuncha an Satanás, lakpach'apalhcha an Judas, xapumatam an ixpumakawt'uyk'an ixt'alhtanan an Jesús, yu ixtajumpalay ma Iscariote, ");
INSERT INTO tpp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","alhcha jala'ts'ini an xalaj'ajin sacerdotejnin chi an xalaj'ajin an yu ixtajalhistaknan laka tajtan, jajuniycha tanischa kajalhima'axta'niya an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yu'uncha sawalhcha oxi talhiwilalh, chi tajuniy li kataxta'niyacha tumin. ");
INSERT INTO tpp_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","An Judas jama'lhtayanalh chi a'taynilhcha lhipuxkawniy tani wanancha lay kama'axta'lhi an Jesús, akxni jantu xamati la'ts'in. ");
INSERT INTO tpp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Chilhcha k'atan akxni ix'ukan pan yu jantu ixliyawkan lhamaskajan, akxni ixma'nikan jas'at'a borrego ixlakata Paxku. ");
INSERT INTO tpp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","An Jesús jamala'achalh an Pedro chi an Juan, jajuniy: ―K'ap'inchi'itcha la'oxinini an wayt ixlakata Paxku, kalakwaynawcha. ");
INSERT INTO tpp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chi talhisakmiy, tajuniy: ―¿T'anisch'a lak'ask'in ak'aw la'oxinini? ");
INSERT INTO tpp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","An Jesús jajuniy: ―Akxni k'at'anut'achi'it an la'acha'an, k'ap'axt'o'a'it pumatam lapanak yu lhi'anta xkan la ix'uyuli', k'ach'a'o'alhip'ina'it sta tan laka cha'a katanutachalh. ");
INSERT INTO tpp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chi k'a'una'it an yu jamacha'a: “An maestro najun: ¿tanischa laka cha'a tan ajkat'alakwayna an kint'alhtanan ixlakata Paxku?” ");
INSERT INTO tpp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yucha katamasuniyan pulaktam la ixcha'a tan talhman chi ay, mala'asijnikantacha, anchacha k'ala'oxiya'it yu katask'iniya'. ");
INSERT INTO tpp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yu'uncha ta'alhcha, walh chunchacha sawalhi tapasalh tacha an ixjajunita an Jesús, pus anchacha tamala'asijnilh ixlakata an Paxku. ");
INSERT INTO tpp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Akxni cha'alhcha ixpaku, an Jesús jat'alaktawilhcha an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chi jajuniy: ―¡Chunchacha xaklhi'achaniy li p'ulhnajcha aklat'alakwaynawi laka Paxku akxni jantuka' ikniy! ");
INSERT INTO tpp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Mu klajunaw jantu chuni aktiwaycho'olh laka Paxku, sta akxni kajunacha tuchini jumputuncha ani Paxku an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pus xa'a'ilhcha la'atam vaso yu ixputajun xaxkan uva chi xta'lhicha lhimala'puchajun, chi jajuniy: ―Ni'ijcha ani, k'alaxt'a'nitcha, k'alhawap'u'ott'itcha, ");
INSERT INTO tpp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","mu kit'in klajunaw jantu ali akti'otcho'olhi ani xaxkan uva sta akxni kaminacha an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Chi xa'a'ipalhi an pan, wachucha lhixta'lhi lhimala'puchajun, chi la'ch'e'elhcha, chi jaxta'nilhcha, jajuniy: ―Ani kilakatunaj, yu kama'axta'kana milakatak'an, chunchacha wachu k'a'ilht'uya'it'it para li akilalhipastakwi. ");
INSERT INTO tpp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chi akxni talakway'olh, wanajcha chuni ilhtupalh an vaso yu ixputajun xaxkan uva, xa'a'ilh jajuniy: ―Ani vaso yu putajun xaxkan uva yucha yu sast'icha putamakawcho'oyaw li milakatak'ani aklhimaj'ana an kijak'alhni. ");
INSERT INTO tpp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero chaway xapumatam yu uxitnan, yu akima'axt'a'a, an laka mesaja kint'amaj'o'slay. ");
INSERT INTO tpp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Mu sawalhi li an isTs'alh Lapanak ts'ajwi ti'an, tacha an lhits'o'muk'akanta, pero an lapanak an yu kama'axt'a'a an isTs'alh Lapanak kapulhik'atsaya'. ");
INSERT INTO tpp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wa chuncha tsukulhcha talalhisakmipaxay, tichini yuchacha yu kama'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Chi atumpaj wachu tsukulh talalhixtukupalay tichini yuchacha yu palay kalhitapala'. ");
INSERT INTO tpp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero an Jesús jajuniy: ―An xarejnin an laj'ay la'acha'anaxni tach'alhkatnancha wa tani tach'alhkatnamputuncha, chi an yu wa talhinajuncha anchunu la'acha'anaxni ma oxicha ja'a'tayjununi jajunkan. ");
INSERT INTO tpp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero uxitnan jantu chun, yu palay lhitapalay yu uxitnan, tacha yu palayka ts'alhi kalalh, chi yu wa lhinajuncha, yucha yu kalak'ilhtulhcha an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Tisapiyuchacha yu palay lhitapalay, yucha an yu wa tawlaycha wajin, u yucha an yu iy pulatoj? Yu palay lhitapalay yucha an yu wa tawlaycha wajin. Pero kit'in ani iklat'a'aklat'awnaw tachanu yu wa talak'iniyan mimpulatojk'an. ");
INSERT INTO tpp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Uxitnan akxni lhima'anxkay lhilhiji kilat'a'aklat'awnaw, ");
INSERT INTO tpp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","xliyu aklalhixta'niyaw la'atam lhich'alhkat, tacha an kimPay kixta'nilh wachu'. ");
INSERT INTO tpp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Uxitnan k'alakwayna'it'it ch'i k'alaj'ot'a'it'iti tu'u la kimesa tan akch'alhkatnana', ch'i k'alakt'awla'it'iti t'an k'anawna'it li oxi u jantu yu ta'ilhtulh an kilhmakkawt'uy xalapanakni Israel. ");
INSERT INTO tpp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chi nawpalh an Jamach'alhkat: ―Simón, Simón, an Satanás task'inani li ma katalaktilhan tacha trigo. ");
INSERT INTO tpp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero uxint'i iklhitapayniyani para li jant'u k'ama'ats'an'at'i an mijakiklaka'inti. Chi akxni ak'ink'iklak'a'ich'o'oya'acha, k'aja'a't'ay'uya'a amijat'ala'awnin para li ixlisawalhi katajakiklaka'inilh. ");
INSERT INTO tpp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","An Simón juniy: ―Jamach'alhkat, kit'in akt'a'anani masi laka pulach'in, chi sta masi akintama'nikan. ");
INSERT INTO tpp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","An Jesús alhtaylh, juniy: ―Pedro, chaway ijkunan akxni jantuka' t'asay puyux, a't'utucha k'anawna'a li jant'u k'imisp'ay. ");
INSERT INTO tpp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chi ixchuxk'an jalhisakmilh, jajuniy: ―Akxni iklamala'achaw li jant'u k'alhip'it mintumink'an chi mibolsajk'an chi miwarachijk'an, ¿tu'u tats'an'atayanin? Yu'uncha tajuniy: ―Jantu. ");
INSERT INTO tpp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pus jajuniy: ―Pus chaway chun, yu lhit'ajuni ixtumin kalhi'alh, chi ixbolsa wachu'. Chi yu jantu tu'u ix'espada, kast'alh ix'aytanut chi kalhi'ilhcha ma'atam. ");
INSERT INTO tpp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mu klajunaw, kajuna la kijatsukunti tacha an najunta an tan ts'o'muk'akanta, tan najunta: “Jat'aput'e'ekalhi an yu wa ay tajunita.” Mu chux tacha an kilhits'o'muk'akanta katapasa'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yu'uncha tajuniy: ―Jamach'alhkat, ani iklhit'awnaw ma'at'uy espada. Yucha ja'alhtaylh: ―¡Wachunchacha kawalhcha! ");
INSERT INTO tpp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wa chuncha taxtulhcha, alhcha tan a'tajcha ix'an a'stitawk'a tan junkan Laka Olivojnin, chi an ixt'alhtanan tach'a'o'alhcha. ");
INSERT INTO tpp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Akxni cha'alhcha, jajuniy: ―K'at'ap'aynit'it, para li jant'u k'a'ilht'up'ut'ut'iti yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chi jamakawyawlhcha, alhcha tacha ixlima'at lay akmakat'alh'alh laka chiwx, tatso'ottatawlhchalhcha chi tsukulhcha tapayniy, ");
INSERT INTO tpp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","najun: ―KimPay, li lay, ak'imala'xt'inunini ani ay lhima'alh'ajna, pero jantu yu wa tacha kit'incha iknajuni kawalh, yu t'ach'a na'un uxint'i kawalh. ");
INSERT INTO tpp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wa chuncha talakasunilh pumatam xa'angelh an lakt'iyani an Jesús, chi lak'ut'ililh. ");
INSERT INTO tpp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pero mu akxni sawalhcha ixma'alh'ajnant'ajun, pus palay p'as ixtapayniy, an ixchanit wa tacha wa laj'aya jak'alhnicha xt'amj xt'amj ixtamayachalh an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Akxni tapayni'olhcha tayalhcha, jala'alhcha an ixt'alhtanan, walh ixtalaklhtatanani jala'cha'alh, mu sawalhcha ixtala'ta'oxila'alhiy, ");
INSERT INTO tpp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","pus jajuniy: ―¿T'asu li laklht'at'ayatcha? K'alaj'ost'ayat'it, k'at'ap'aynit'it, para li jant'u k'a'ilht'ut'iti yu jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chunchaka ixchiwint'ajun an Jesús, walh lhilhuwcha cha'ankalh, an yu ixjunkan Judas, xapumatam an ixpumakawt'uyk'an ixt'alhtanan an Jesús, ixjap'ulhnitacha an lapanakni, chi la'cha'alhcha an Jesús, la'xtikilhtastuklhicha. ");
INSERT INTO tpp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pus an Jesús juniy: ―Judas, ¿la'xt'ik'ilht'ast'ukma'axt'a'acha an yu isTs'alh Lapanak? ");
INSERT INTO tpp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Mu tala'ts'incha tuchini katapasayacha an yu ancha ixtat'ayanalh an Jesús, pus tajuniy: ―Jamach'alhkat, ¿akmak'atsaniyaw laka espada? ");
INSERT INTO tpp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wa chuncha xapumatam yu yu'uncha, mak'atsaninilh xapumatam ixma'tsuku an xa'ay sacerdote, xtalh akatuch'uk'up'uxli an oxi ix'a'ax'olh. ");
INSERT INTO tpp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Chi an Jesús jajuniy an yu ixtat'a'anta: ―Wa sa'ch'a k'at'awlat'it, k'ajamak'a'unt'itcha. Chi akatuch'apalhi an yu akatuch'uk'up'uxkalh, akatuk'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ixli'astan an Jesús jajuniy an xalaj'ajin sacerdotejnin chi an xalaj'ajin an yu ixtajalhistaknan laka tajtan chi an laktatanincha, li ma wa ta'antacha ch'apayawnin, jajuniy: ―¡Wa t'ach'a wa ch'a'o'ayatcha ja'alhawna laklhit'ant'at mi'espadajk'an chi mink'iwk'an! ");
INSERT INTO tpp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pero mu lhilhiji xaklapaxt'o'aw an laka tajtan, walh chi akxni jantu kilach'apayajuw. Pero chaway chilhcha mimpanch'e'exk'an para li k'a'ilht'ut'it, chi yucha an jatats'isnicha ch'alhkatnan. ");
INSERT INTO tpp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pus tach'apayawlhcha an Jesús, talhi'alhcha la ixcha'a an xa'ay sacerdote. An Pedro wa ma'atcha ixch'a'o'alhi'anta. ");
INSERT INTO tpp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chi an tan jalhi'ay jatalakxtut, ixtan'ajni, ta'ulalhcha jikmi chi tala'atanchanulhcha, an Pedro anchacha japujatawilh wachu'. ");
INSERT INTO tpp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pero pumatam t'aku, ma'tsuku, la'ts'ilhi li ancha ixma'wilh tan an ixla's'onkan, pus najun: ―Ani wachu ancha ixt'a'aklat'ajun an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero an Pedro najun ma jantu, najun: ―¡T'aku', jantu ikmispay! ");
INSERT INTO tpp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Panch'e'excha lakats'uniya jumpalh, pumatamcha la'ts'impalh, juniy: ―Uxint'i wachu ixt'alhtanak'at'i an Jesús. An Pedro najun: ―¡Lapanak, jantu kit'in! ");
INSERT INTO tpp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Katacha tamcha horaja jumpalh, pumatamcha nawpalay, najun: ―Chun sawalh, ani wachu ani ixt'a'aklat'ajun, chi wachu jamacha'a Galilea. ");
INSERT INTO tpp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","An Pedro najun: ―Jantu ijk'atsay t'uch'ini uniycha, lapanak. Walh wa akxni, chunchaka ixnawt'ajun, t'asalhcha an puyux. ");
INSERT INTO tpp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pus wa chuncha an Jamach'alhkat Jesús tala'asp'itlaka'alhi tan ixyalh an Pedro. Pus pastaklhicha an Pedro li an Jamach'alhkat ixjunita: “Jantuka' katit'asalhi an puyux, a't'utucha k'anawna'a li jant'u k'imisp'ay.” ");
INSERT INTO tpp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pus an Pedro taxtulh ma'spa, chi wa stakcha alhulh. ");
INSERT INTO tpp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","An lapanakni an yu ixtalhist'ak'a an Jesús, ixtamamaxaniycha chi ixtamuk'aniycha. ");
INSERT INTO tpp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tala'puch'ilhcha chi ixtalakpusaycha, ixtajuniy: ―¿Tisiyuchacha muk'anini? K'anawcha. ");
INSERT INTO tpp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chi tachalayjcha aliy ixtalhimamaxaniy. ");
INSERT INTO tpp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Akxni tunkulhcha, tata'ayxto'lhicha an xalaktatanin lapanakni, chi an xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin. Talhi'alhcha an Jesús laka ay junta, tajuniy: ");
INSERT INTO tpp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―¿Uxint'i Cristojk'at'i? Akilajuniw. Yucha jajuniy: ―Li aklajuniw, jantu akintilakiklaka'iw, ");
INSERT INTO tpp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","chi li aklalhisakmiw tu'u, jantu akintilajuniw chi jantu akintilamakajuw. ");
INSERT INTO tpp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero chaway ati'anta kit'in yu ikwalh isTs'alh Lapanak akpiktutawlantacha tan oxi ixpa'xti an Dios, yu lay ilhtu'ojoy wa tuchicha. ");
INSERT INTO tpp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pus wa ayxtami ixchuxk'an talhisakmilh, tajuniy: ―¿Uxint'i isTs'alh Dios? Yucha jajuniy: ―Uxitnanch'a nawnat li kit'in. ");
INSERT INTO tpp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wa chuncha talajuniy: ―¿Ali ma'lhtask'iniyawi yu akintajunin? Wanajcha kitnani alha'asmat'aw. ");
INSERT INTO tpp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pus ixchuxk'an an yu ancha ixta'ayxto'nun laka junta talaktaya'olh chi talhi'anilhcha an Jesús an Pilato. ");
INSERT INTO tpp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chi tsukulhcha ta'alhtasuy, tanajun: ―Ani lapanak ik'a'taymaw li wa jalaktilha an lapanakni yu ani jamacha'an, chi najun li jantu kamapalhlhi'anikalhi an ay xajamach'alhkat Roma, najun li ma Cristojo yucha, ma Rey. ");
INSERT INTO tpp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pus an Pilato lhisakmiy, juniy: ―¿Uxint'i ixrejk'an judiojnin? Yucha ja'alhtayanalh, najun: ―Uxint'ich'a na'un. ");
INSERT INTO tpp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Wa chuncha an Pilato, jajuniy an xalaj'ajin sacerdotejnin chi an lapanakni: ―Jantu tu'u tala'alhini ikla'cha'aniniy ani lapanak. ");
INSERT INTO tpp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero yu'uncha palay p'as ixtanajun: ―Wa japulaktilhiya an lapanakni tacha an masuy, an xalakaat'un Galileaja pu'a'taynichalh chi chaway anicha xalakaat'un Judeaja taylhi'anta. ");
INSERT INTO tpp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pus an Pilato akxni asmatlhi nawkalh Galilea, lhasakminilhi li an Jesús sna jamacha'a Galilea. ");
INSERT INTO tpp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Akxni k'ats'aalhi an Pilato li an Jesús jamacha'a tan ixch'alhkatnan an Herodes, ancha mala'achanilh, chi mu akxni an Herodes wachu Jerusaleni ixt'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","An Herodes akxni la'ts'ilhcha an Jesús, sawalhcha achalh, mu ma'anchacha sawalhcha ixla'ts'imputun. Mu lhuwcha tanlhuni ixlaj'asmatta ixlichiwinkan yu ixlak'ilhtuy, chi ixla'ts'imputuncha li tu'ucha lhi'a'nini kax'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tipalhuwcha tu'u ixlisakmiy, pero yucha jantu tu'u alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","An xalaj'ajin sacerdotejnin chi an xamaestrojnin lhamap'a'sin wachu ancha ixtayanalh, p'ascha ixta'alhtasuy ixtalhimuk'ay tanlhun. ");
INSERT INTO tpp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pus wa chuncha an Herodes ali an isoldadojnin jantucha tu'u ixtalhiwilay an Jesús, tamala'ch'inilhcha yu k'usi la'ch'it, wa ixtapumamaxaniycha chi an Herodes mala'achanipalhi an Pilato. ");
INSERT INTO tpp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pus akxni, oxicha talalhi'alh an Pilato ali an Herodes, mu ixlip'ulhnaj wa ixtalaxkajiy. ");
INSERT INTO tpp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wa chuncha an Pilato, jama'ayxto'olhi an xalaj'ajin sacerdotejnin chi an jamach'alhkatni chi ta ixchuxk'an tawilanalh an lapanakni, ");
INSERT INTO tpp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","jajuniy: ―Ani lapanak kilalhiminitaw kilajunaw li wa jalaktilhiya an lapanakni. Pero la mi'ukxlakapuchak'ani iklhisakmilh, chi jantu tu'u ikla'cha'aninilh tala'alhin t'ach'a an lhimuk'ayat'it. ");
INSERT INTO tpp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chi an Herodes, wanajcha chun kintamala'achanicho'ochin. La'ts'inat'itcha, jantu tu'u ilhtuta yu laycha kalhima'nikalh. ");
INSERT INTO tpp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Akxta'niyacha la'atam lhima'alh'ajna chi akmakawcho'oyacha.  ");
INSERT INTO tpp_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Chuncha jajunilh mu akxni k'atan ixjun an Pilato ixjamakawniy pumatam tach'ini an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero ixchuxk'an wa ayxtami talakt'asa'olh, tanajun: ―¡Ani Jesús jantu! ¡Yu akilamakawniw yucha an Barrabás! ");
INSERT INTO tpp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","An Barrabás ixmalaklhchawkanta mu ixjama'nininta chi wa ixt'alaxtukuy an xajamach'alhkat an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","An Pilato a'tam jalhisakmipalhi mu ixmakawputuni an Jesús, ");
INSERT INTO tpp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","pero yu'uncha a'tam palay p'as talakt'asapalh, ixtalaknajun: ―¡K'amakxt'ukmuk'acha, k'amakxt'ukmuk'acha! ");
INSERT INTO tpp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pero an Pilato, ixlipu'a't'utucha, a'tam jajumpalh: ―¿Tisuncha tala'alhini ilhtuta? Jantu tu'u tala'alhini ikla'cha'anini para li kama'nikalhcha. Akmama'alh'ajniyacha pero akmakawcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yu'uncha palay p'as ixtalakt'asay, ixtalhisk'in li ma kamakxtukmuk'akalhcha. Pus tacha an ixtalakt'asay an lapanakni chi an xalaj'ajin sacerdotejnin, tamatapujunilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pus an Pilato ilhtulhcha yu an ixtalakask'in yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jama'axta'nilhcha an Jesús an lapanakni para li kata'ilhtulhcha wa tani ta'ilhtuputuncha chi an yu ixlimalaklhchawkanta ixjama'ninti chi ixlakata li wa ixt'ala'ajiy an xajamach'alhkat la'acha'an, yucha makawlhcha, mu chunchacha ixtajuniy. ");
INSERT INTO tpp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Akxni ixtitalhi'ancha an Jesús, tach'apayawlh pumatam lapanak ixjunkan Simón, jamacha'a Cirene, la ixlima'spa la'acha'ani minchalh, tamak'uk'alhcha an cruz para li ma kach'a'o'alhi'alhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Wanajcha lhilhuwi ixch'a'o'akanta chi lhuw t'akunini ixtama'anta, sawalhcha ixtalhita'oxila'alhiy chi ixtalhilaj'alhuncha. ");
INSERT INTO tpp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero an Jesús tala'asp'itlhi chi sa'cha ixjala'ts'in, ixjajuniy: ―Ixjatsi'in la'acha'an Jerusalén, jantu akilalhi'alhuw. Mijas'at'ank'ani k'ajalhi'alhunt'it chi milakatak'an, ");
INSERT INTO tpp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","mu kamina wilhchani akxni kanawkana: “Oxi para yu'uncha an t'akunin an yu jantu lay tajamas'at'analh, chi an yu jantu a'tam tajamas'at'analh chi an yu jantu a'tam tajamats'ik'inilh.” ");
INSERT INTO tpp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Akxni katajuna an laj'a'stitawk'a: “Akila'a'lhtants'iwcha”. Chi an tan laklakatitawk'a katajuna: “Akilamats'ewi”, ");
INSERT INTO tpp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","mu li kit'in tacha kinta'ilhtuy, walh chi tacha ikst'a'aw k'iw, pus uxitnan, ¿t'asu li jant'uch'a ch'uni k'at'i'ilht'uk'ant'it li tachanu xaxixni k'iwi unt'at'it'i? ");
INSERT INTO tpp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ixjat'alhi'ampalhkanta ixt'uyunk'an lapanakni an Jesús, para li kajat'ama'nikalhcha. Yu'uncha ixta'ilhtuta ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Akxni tacha'alhcha tan junkan la Ixla'pa'axi Swe'elukut, anchacha makxtukmuk'akalh an Jesús chi an ixt'uyunk'an lapanakni yu ixta'ilhtuta tala'alhin, ixtapiktutamincha, lhilaxjama'xi chi tan oxi ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","An Jesús nawlh: ―KimPay, k'ajamala'mixinin, mu wa jantu tak'atsay tuchini ta'ilhtuycha. Chi talamala'pitsilhcha an ixla'ch'it an Jesús, wa ta'amanalh suerte. ");
INSERT INTO tpp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chi chux an lapanakni sa'cha ixtala'ts'in, chi masi an jamach'alhkatni ixtamamaxaniycha, ixtalajuniy: ―Ali'in jama'alhtaxtulh, kama'alhtaxtukalhcha ix'akstu li Cristo sawalh yu sakxtuta Dios. ");
INSERT INTO tpp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","An soldadojnin wachucha ixtamamaxaniy, waniycha ixtala'an ixtama'ot'uycha vinagre ");
INSERT INTO tpp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","chi ixtajuniy: ―Li ixrejk'at'i judiojnin, k'at'a'alht'axt'ucha mi'akstu. ");
INSERT INTO tpp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","An la ix'akpuxni ists'o'nikanta tan ixnajunta: “Ani ixRejk'an judiojnin.” ");
INSERT INTO tpp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pumatam an yu ixjat'amakxtukmuk'akanta an Jesús, ixlilakajuniycha, ixjuniy: ―Li Cristojk'at'i, k'ama'alht'axt'uk'acha chi akilama'alhtaxtuw. ");
INSERT INTO tpp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","An pumatam la'a'aymalh juniy: ―Masi wanajch'a ch'uni ma'alh'ajnant'a'un jant'u t'alhamniya an Dios. ");
INSERT INTO tpp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kitnan t'acha'anawi li chuncha kama'alh'ajnaw, mu mapalht'awnawi yu ilhtutaw tala'alhin, pero ani lapanak jantu tu'u tala'alhini ilhtuta. ");
INSERT INTO tpp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Chi juniy an Jesús: ―Jesús, ak'imp'ast'ak'a'a akxni k'ach'alhk'atnana'acha. ");
INSERT INTO tpp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pus an Jesús alhtaylh juniy: ―Uxint'i chaway ak'int'ap'ina'acha tan lhi'acha alin jatsukunti, sawalhi ani yu ijkunan. ");
INSERT INTO tpp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ka tacha atunkujuncha sta las tres yu ta'oxaycha, chux an lakaat'un taputs'isilh. ");
INSERT INTO tpp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","An wilhchan taputs'isilh, chi an la'ch'it an ix'uk'alh laka tajtan lht'it'in tapu'exli, tukan ixpaytat, aklht'uyi walh. ");
INSERT INTO tpp_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Akxni an Jesús, p'ascha t'asalh, najun: ―KimPay, an kintakuwin la mimaka ikma'axta'niyan. Chi akxni chunchacha naw'olh, nilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","An capitán akxni la'ts'ilhcha li chunchacha tapasalh oxicha lhipastaklhi an Dios, najun: ―Chun sawalh, ani lapanak jantu tu'u ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ixchuxk'an an yu chunchacha tala'ts'ilh tacha an tapasalh, ta'ancho'olhcha, jalaktankilhaksalhi'ankalhcha. ");
INSERT INTO tpp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ixchuxk'an an yu ixjamispay an Jesús chi an t'akunin yu ixtat'amintachalh sta xalakaat'un Galilea wa ma'atcha ixtalakaminachalh tacha an ixtapasay. ");
INSERT INTO tpp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ixt'ajun pumatam lapanak ixjunkan José, jamacha'a Arimatea, xala'acha'an an Judea. Yucha wachu ixma'ta'ayxt'o'a an laka ay junta yu ixta'ilhtuy an judiojnin, ");
INSERT INTO tpp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","pero mu yucha oxi lapanak chi ixkiklaka'iy Dios, yucha jantu oxi ixliwilay tacha an tatamakawlh laka junta, mu yucha wachu ixpakxan'iya an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yucha la'alhi an Pilato chi sk'inilhi an ixlakatunaj an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Akxni ma'alhtajulhcha an laka cruz, la'apamililhcha laka sábana, chi maknulhcha tan ixtantipujkanta a'stitawka la'stu chiwx, jantuka' k'is xamati ancha ixmaknukan. ");
INSERT INTO tpp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Akxni chuncha tapasalh sawalhcha ixtala'asijt'ajuni an lapanakni, mu katunkunanta xawilhchan jastaknat. ");
INSERT INTO tpp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","An t'akunin an yu ixtat'amintachalh an Jesús sta xalakaat'un Galilea tat'a'alh, tala'ts'ilhi tan kimaknukalh chi tani lhimamakalhcha an ixlakatunaj. ");
INSERT INTO tpp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Akxni ta'ancho'olhcha ixcha'ak'an, tamala'asijnilhcha laklhaklhi perjume yu lay lakatawk'akan. Chi tajastaknalhcha akxni xawilhchan jastaknat, tacha najunta laka lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","A'taynicho'olhcha la'atam wilhchan, sast'icha samana, sawalh wats'isin ta'alhcha an t'akunin an tan ix'aknuy an Jesús, ixtat'a'antacha ali'in ixt'at'akunink'an chi ixtalhi'antacha an yu ixtamala'asijnita laklhaklhi perjume. ");
INSERT INTO tpp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Walh akxni tacha'alh, tala'ts'in an aya chiwx an yu ixpumalaklhchawkanta an tan ix'aknuy, ma'osukanta. ");
INSERT INTO tpp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chi tatanulh, walh jantu tala'cha'alhi an ixlakatunaj an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pus jantucha ixtalhimacha'xay, walh wa akxni tatalakasulh ixt'uyunk'an lapanakni waniy an tan ixtalakyanalh, wa la'xlimjnik'acha an ixla'ch'itk'an. ");
INSERT INTO tpp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Chi mu ixtalaktalhanancha an t'akunin, tala'ta'antatawilhcha an lakaat'un, pus jajunkan: ―¿T'asu li p'uxk'awyatcha an yu la'ajunta an tan tamanalh janinini? ");
INSERT INTO tpp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yucha jantu aniya t'ajun, yucha la'awcho'olh. K'ap'ast'akt'iti tacha an tajunin akxni an ixt'ajunka xalakaat'un Galilea, ");
INSERT INTO tpp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","tajunan lhitask'iniya li an isTs'alh Lapanak kama'axta'kalhi la ixmakak'an an ma'lhta'alhinin, chi li kamakxtukmuk'akalh, pero kala'awcho'oya ixlila'at'utu wilhchan. ");
INSERT INTO tpp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wa chuncha yu'uncha tapastaklhi tacha an ixnajunta. ");
INSERT INTO tpp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pus tataxtulh an tan ix'aknuy, ta'ancho'olhcha chi tamak'ats'aanilhcha an ixpumakawtamk'an ixt'alhtanan an Jesús chi ixchuxk'ancha an ali'in tacha an tapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","An t'akunin an yu tajamak'atsaaninilh yu'uncha an María Magdalena, chi Juana, chi María ixnati Jacobo, chi an ali'incha ixt'at'akunink'an yu ixtat'a'anta. ");
INSERT INTO tpp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero an ixt'alhtanan an Jesús, jantu ixtakiklaka'iya an t'akunin, ixtalhi'ilhtuy li wa lhilokojcha li katakiklaka'ilh. ");
INSERT INTO tpp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero an Pedro jats'alaj'alhi an tan ixmaknukanta an Jesús, chi kiila'ts'ilhi li wa yucha an la'ch'itcha ancha ixlaktanun. Wa chuncha alhcha la ixcha'a, chi ixli'a'niycha tacha an tapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Wa yuchaka anchunu wilhchan, ixt'uyunk'an an ixt'alhtanan an Jesús, ixtita'an tanchun la'acha'an junkan Emaús, ka tacha la'akawtam kilómetrojo lhitamakawniy an la'acha'an Jerusalén, ");
INSERT INTO tpp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ixtalhilakchiwij'antacha chux tacha an laktapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Walh akxni chunchaka ixtalalhikikxtukulhi'anta, an Jesús waniycha jala'cha'alh, ixjat'alakjalhtanaj'antacha. ");
INSERT INTO tpp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero an ixla'chulhk'an yu'uncha wa tachanu tu'ucha kajala'puch'apalh para li jantu katamispalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","An Jesús jajuniy: ―¿T'isunch'a lhilakch'iwijp'int'at'it? Pus sa'cha tatayalh chi ixtata'oxila'alhiycha. ");
INSERT INTO tpp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chi pumatam ixjunkan Cleofas alhtaylh, juniy: ―An yu jantu jamacha'an Jerusalén wa uxint'i yu jant'u k'a k'ats'ay tacha an tapasalh wa aniyka'. ");
INSERT INTO tpp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Pus yucha ja'alhtaylh, jajuniy: ―¿Tisuncha tapasalhi? Chi tajuniy: ―Yucha an Jesús, jamacha'a Nazaret yu ixlichiwiniy ixchiwinti Dios, chi alhp'asi lay ixlak'ilhtuy an tanlhun tapatsat, alhp'asi ixchiwiniy la ix'ukxlakapu an Dios chi la ix'ukxlakapuk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Walh chi li laycha tama'axta'lhi an xalaj'ajin sacerdotejnin chi an kijamach'alhkatnank'an para li kamakxtukmuk'akalh chi li kama'nikalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Kitnan xakpakxan'iyaw li yuchacha akintama'alhtaxtuyan yu ikwilaw Israel. Pero chaway la'at'utucha wilhchani yu chunchacha tapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Masi ali'in an t'akunin, yu ancha kintat'awilanan kintame'e'swayan, mu takilaka'alhi wats'isin an tan ix'aknuy an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma jantu tu'u tanun, pus tacha'ancho'olh, tanajun ma tala'ts'ilh angelhnin yu ma tanajun li an Jesús la'ajunta. ");
INSERT INTO tpp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Pus ali'in an yu kintat'alach'a'o'ayan wachu takilaka'alhi an tan ix'aknuy an Jesús. Chi chuncha sawalhi takila'ts'ilh tacha an tanajun an t'akunin, pero an Jesús jantu tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wa chuncha an Jesús jajuniy: ―¡Laj'a'atu'axixin, sawalhcha laksniya k'iklak'a'iyat tacha an tanawlh an yu ixtalhichiwiniy ixchiwinti Dios! ");
INSERT INTO tpp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Chu jantu ixlitask'iniya li an Cristo chuncha p'ulhnaj ka'ixlaktapasanilh la ixjatsukunti ani tanlhun, para li ixli'astan kaxlimjcha juna chi ay tukani kala'ts'inkana'? ");
INSERT INTO tpp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pus tsukulhcha jalhixa'alayi an Jesús chux an tan lhichiwininta ixlakata yu yucha, sta la ixlaklibro an Moisés sta tacha an alin ali ixlaklibrojk'an an yu ixtalhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Akxni tacha'alhcha an la'acha'an tan ixtita'an, an Jesús ixlay li palay ma'ati ixti'an. ");
INSERT INTO tpp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yu'uncha p'asi tajunilh li anchacha kajat'atamakawlh, tajuniy: ―Kakilat'atamakajuwcha, mu ta'oxaycha, taputs'isit'ajuncha. Pus anchacha jat'atamakawlh. ");
INSERT INTO tpp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Akxni sa'cha ixtalakwilanalh laka mesa, xa'a'ilhcha an pan chi xta'lhicha lhimala'puchajun, puch'e'elhcha chi jala'xta'nilhcha. ");
INSERT INTO tpp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Akxni chun tamispalhcha mu tachanu tajalakawanalhcha pero la ixjalakawantik'ani la'mixpalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chi ixtalajumpaxay: ―Sawalh, ¿chun jantu xakintaxawniyani an kijalhunutk'an la kintankilhaknik'an akxni an xakintat'alakchiwijmintan laka tij chi xakintalhixa'alayan an tacha ts'o'muk'akanta la ixchiwinti Dios? ");
INSERT INTO tpp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wa chuncha jantu ali tapakxalh, watukan ta'ancho'olhi la'acha'an Jerusalén. Chi tala'cha'alhi an ixpumakawtamk'an ixt'alhtanan an Jesús tan ixtat'a'ayxto'nun an ali'in yu wachu ixtach'a'o'ay an Jesús. ");
INSERT INTO tpp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ixtalajuniy: ―Chun sawalh la'awcho'ota an Jamach'alhkat Jesús, chi talakasunilhi an Simón. ");
INSERT INTO tpp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pus akxni yu'uncha wachucha tanawlhi tani tala'ts'ilhcha an laka tij, chi li tamispalhi an Jesús akxni puch'e'elh an pan. ");
INSERT INTO tpp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chunchaka ixtalhilakchiwint'ajun ani tanlhun, an Jesús japujatayachalhcha chi jajuniy: ―¡Oxich'a k'at'awlat'it! ");
INSERT INTO tpp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pus yu'uncha sawalhcha talaktalhanalh, ixtanajun li sna wa uncha. ");
INSERT INTO tpp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero an Jesús jajuniy: ―¿T'asu li lakt'alhananatcha ch'i li nawnatcha li sna jantu kit'ini? ");
INSERT INTO tpp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","K'ala'ts'int'it an kimaka chi an kinch'aja', kit'in. Akilalakach'apaw ch'i k'ala'ts'int'itcha. Yu wa takuwincha jantu tu'u ixjakanit chi ixjalukut t'ach'a la'ts'inat iklhit'ajun. ");
INSERT INTO tpp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chunchacha jajun'olh chi ixjamasuniycha an ixlakmaka chi an ixlakch'aja'. ");
INSERT INTO tpp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero mu yu'uncha jantuka' oxi ixtalhimacha'xay mu sawalhcha ixtalaj'achan chi sawalhcha ixtalhi'a'niy, pus jajuniy an Jesús: ―¿T'u'u lhit'awnat ani yu ukan? ");
INSERT INTO tpp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wa chuncha taxta'nilh lakats'uniy jamaxkawawanti jatanti chi t'axkat. ");
INSERT INTO tpp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jama'lhtaylhcha chi ulhcha la ix'ukxlakapuk'an. ");
INSERT INTO tpp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ixli'astan jajuniy: ―Chunchuniya an iklajuniw akxni an xaklat'a'aklat'awnaw: li lhitask'iniya li chuncha katapasa'olh tacha an kilhits'o'muk'akanta an la ixlamap'a'sin Moisés, chi an yu ixtalhichiwiniy ixchiwinti Dios, chi an Salmos. ");
INSERT INTO tpp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pus wa chuncha ja'ilhtulhi li katalhimacha'xalhi an tan chuncha ts'o'muk'akanta. ");
INSERT INTO tpp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chi jajuniy: ―Chuncha ts'o'muk'akanta li an Cristo kaniya chi kala'awcho'oya ixlila'at'utu wilhchan. ");
INSERT INTO tpp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chi li chux an ta kilhmakchux ta'alin an lapanakni kalhichiwinkalhi la ixta'a'ut li katakiklaka'ilhi an Dios, para li kajamala'mixinilhi ixtala'alhink'an. Sta la'acha'an Jerusaleni kapu'a'taynikana'. ");
INSERT INTO tpp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Uxitnan k'ats'ayat'it'i tacha ani laktapasalh. ");
INSERT INTO tpp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chi kit'in aklamakminiyawi an yu nawlh kimPay li kamakmina'; pero uxitnan k'asa' t'awlat'iti ani la'acha'an Jerusalén, sta li akxni k'ala'a'iya'itcha an yu alhp'as k'ap'u'una'it an yu kaminanta lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ixli'astan chux an ixt'alhtanan an Jesús jamaxtulhcha an la'acha'an Jerusalén, jalhi'alhcha sta la'acha'an Betania, chi tamakch'ixlicha chi tapayninilhcha an Dios para li oxi katatsukulh. ");
INSERT INTO tpp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Akxni jalhitapayni'olhcha, wa akxni jamakawyawlhcha, chi alhcha lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yu'uncha akxni stakcha taxta'olh lhimala'puchajun, talaj'achaj'ancho'olhcha la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chi lhilhiji ixtatsukuy an laka tajtan, ixtalakmilhpaniycha an Dios chi ixtaxta'niycha lhimala'puchajun. Chunchacha kawalh.");
INSERT INTO tpp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Akxni jantuka' tu'u ix'alin, ix'alincha pumatam yu junkan Chiwinti, chi an Chiwinti yucha an Diosi ixt'a'aklat'ajun, an Chiwinti yucha an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Akxni jantuka' tu'u ix'alin, yucha ixt'ajuncha, ixt'a'aklat'ajuncha an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chi chux an laktanlhun, yucha pu'ilhtukalh, jantu tu'u an yu alin laktanlhun yu jantu yu kapu'ilhtukalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mu yucha ixlit'ajun an jatsukunti, chi an jatsukunti, ixjatapulhkunuk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","An jatapulhkunu mapulhkuyi an tan lakaaputs'isni, chi an jatats'isni jantu lay mamixiya an jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kilachilh pumatam lapanak yu ixmala'achatachalh an Dios, ixjunkan Juan. ");
INSERT INTO tpp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yucha kilhichiwinchilh an jatapulhkunu', para li katapukiklaka'i'olhi an lapanakni, kijamak'ats'aanininchilhi ixlakata an jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","An Juan jantu yu jatapulhkunu', yucha wa kijamak'atsaanininchilh ixlakata an jatapulhkunu'. ");
INSERT INTO tpp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","An yu sawalh jatapulhkunu yu jamapulhkuni'ojoy chux an lapanakni kaminaka ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Chi akxni ixt'ajuncha an yu jatapulhkunu sawalh ani lakamunulhpa, masi yucha pu'ilhtukalh an lakamunulhpa, an lapanakni jantu tamispalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kilachilhi an la ixlakamunulhpa pero an yu ancha jamala'awnita jantu tala'a'ilh. ");
INSERT INTO tpp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ixchuxk'an yu tala'a'ilh, chi takiklaka'ilh, ja'ilhtulhi li ixjas'at'an Diosi katawalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yu'uncha jantu wa laka jak'alhni tapula'ajun, chi jantu wa laka jakanit, chi jantu wa laka lapanak, yu'uncha Diosi jamala'awniy la ixtakuwink'an. ");
INSERT INTO tpp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","An Chiwinti junlhi lapanak chi kintakit'atawlhchin. Chi la'ts'iwi an ix'alhp'asninti, yu xta'niy an ixPay, mu wa ix'akstu isTs'alh, chi yucha lhuwi ixjamapayninti chi chux an ixchiwinti sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","An Juan lhichiwinilh ixnajun: ―Yucha aniya an yu xaklalhixa'alayaw, akxni xaklajunaw: “Yu aminta ixli'astan palay lhitapalay, mu yucha o'sliyancha ixt'ajun, kit'in astani ikt'ajun.” ");
INSERT INTO tpp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yucha pula'a'i'oyaw wa tuchicha, chi yucha ali ali lalhawayi ixjamapayninti. ");
INSERT INTO tpp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mu an lhamap'a'sin yucha an Moisesi puxta'kalh, pero an jamapayninti chi an yu sawalh yucha an Jesucristojo japu'ilhtukalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","An Dios jantu a'tam xamati la'ts'inta; pero an isTs'alh, mu wanajcha yucha an Dios, yucha kintamamispanin, mu yucha lhilhiji t'awilhchalh an ixPay. ");
INSERT INTO tpp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yucha anicha yu lhichiwiniy an Juan, akxni an judiojnin yu ixtat'ajun la'acha'an Jerusalén, tamala'achalh sacerdotejnin chi levitajnin para li kata'alh lhisakminin an Juan tichini yuchacha. ");
INSERT INTO tpp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","An Juan ixla'ts'awalanti nawlh, najun: ―Kit'in jantu ijCristo. ");
INSERT INTO tpp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pus talhisakmiy tajuniy: ―¿Pus tisu uxint'icha? ¿Uxint'i Elías? Yucha najun: ―Jantu, jantu kit'ini Elías. ―¿Uxint'i yu lhich'iwiniy ixchiwinti Dios? Yucha ja'alhtaypalh: ―Jantu. ");
INSERT INTO tpp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wa chuncha, tajuniy: ―¿Pus tisu uxint'icha? Mu ajkamak'atsaaniyawi tichini uxint'icha an yu kintamala'achatacha'an. ¿Tisu uxint'icha kilajunawi? ");
INSERT INTO tpp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","An Juan ja'alhtaylh: ―Kit'ini an chiwinti an yu ixchiwiniy p'as an tan wa sa' junita, tan ixnajun: “K'alats'awalat'iti an ixtij an Jamach'alhkat Cristo.” Tacha an nawlh Isaías, yu ixlichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","An yu ixjamala'achakanta li katakila'ts'ilh an Juan yu'uncha an fariseojnin. ");
INSERT INTO tpp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Tajuniy an Juan: ―¿Pus mu li jantu uxint'i Cristojk'at'i, chi jantu Elíask'at'i chi jantu uxint'i an yu kamina lhichiwiniy ixchiwinti Dios, t'asu li jama'p'axanancha? ");
INSERT INTO tpp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","An Juan ja'alhtaylh: ―Kit'in wa laka xkani ijkama'paxanan, pero t'a'aklat'awnat pumatami yu jant'u misp'ayat. ");
INSERT INTO tpp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yucha yu kamina ixli'astan, yucha masi wa ak'o'x'otnilhcha ixwarachi jantu ikt'acha'an. ");
INSERT INTO tpp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tan chuncha laktapasalh ani tanlhun, la'acha'an tan junkan Betania, ixtapiktutam an ayxkan junkan Jordán, ancha an Juan ixjama'paxanant'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tunkunchalh an Juan, la'ts'ist'uk'acha an Jesús li ixla'antachalhcha, pus najun: ―¡Yucha aniya yu ixJas'at'a Borrego an Dios, yu lha'ulanalh, para li kamala'mixinilhi ixtala'alhin an lakamunulhpa'! ");
INSERT INTO tpp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yucha an yu ijkuniy akxni iknajun: “Ixli'astan kit'in, kamina pumatam lapanak yu palay lhitapalay, mu yucha p'ulhnajcha ixt'ajun.” ");
INSERT INTO tpp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Kit'in wachu jantu xakmispay, pero para li katamispalhi an jamacha'an Israel, xliyu kit'in xajkama'paxanancha lakaxkan. ");
INSERT INTO tpp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Atumpaj an Juan nawpalh: ―Ikla'ts'ilhi an ixTakuwin Dios akxni ta'alhtajulh an lakt'iyan, wa tacha paloma, tan ixyalh. ");
INSERT INTO tpp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Kit'in jantu xakmispay, pero an yu kimakmilh li akmilh jama'paxana lakaxkan kijunilh: “An yu k'ala'ts'ina'a li kalakpatawlanta an ixTakuwin Dios akxni kata'alhtajuya, yucha yu jama'paxanan laka Stalan'a ixTakuwin Dios.” ");
INSERT INTO tpp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chi kit'in ikla'ts'ilhcha, pus iknajuncha li ani yucha isTs'alh an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tunkunchalh an Juan anchacha ixt'awpalay ali ixt'uyunk'an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chi la'ts'ilhi an Jesús li ancha ix'aklat'ajun, pus an Juan najun: ―¡Yucha anu yu ixJas'at'a Borrego an Dios! ");
INSERT INTO tpp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","An ixt'uyunk'an ixt'alhtanan an Juan ta'alha'asmatlhi, pus tach'a'o'alhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","An Jesús tala'asp'itlhi pus jala'ts'ilhi li ixtach'a'o'ata, chi jajuniy: ―¿T'isunch'a p'uxk'awyat'iti? Yu'uncha tajuniy: ―¿T'anisch'a wilht'i, Rabí? (Rabí nawputun, Maestro) ");
INSERT INTO tpp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pus an Jesús jajuniy: ―K'at'at'itcha ch'i k'ala'ts'ina'itcha. Yu'uncha tat'a'alhcha chi takila'ts'ilhcha tan ixtawlay, chi mu ixta'oxaycha ka tacha las cuatrojcha, pus tat'atamakawchalhcha yu akxni ixtunkujunta. ");
INSERT INTO tpp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","An Andrés, ixt'ala'ajun Simón Pedro, yucha xapumatam an ixt'uyunk'an an yu ta'alha'asmatlhi an Juan chi tach'a'o'alh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Chi an Andrés watukan la'alhi an ixt'ala'ajun yu junkan Simón, chi juniy: ―Ikla'cha'aw an Mesías. (Yucha nawputun Cristo.) ");
INSERT INTO tpp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pus t'a'alhcha an tan ixt'awnachalh an Jesús, chi an Jesús juniy an Simón: ―Uxint'i Simonk'at'i, ists'alh Jonás, chaway Cefasch'a k'a'unk'ana'a ―nawputun Pedro. ");
INSERT INTO tpp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tunkumpalhchalh, an Jesús k'uxa'alh xalakaat'un Galilea, walh paxto'lhicha an Felipe, pus juniy: ―Ak'int'ap'it'icha. ");
INSERT INTO tpp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","An Felipe, jamacha'a Betsaida, tan ixla'acha'ank'an an Andrés chi an Pedro. ");
INSERT INTO tpp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","An Felipe la'cha'alh an Natanael, pus juniy: ―Ikla'cha'awcha an yu ts'o'muk'ata an Moisés an laka lhamap'a'sin, chi an tacha ixtanajun wachu an yu ixtalhichiwiniy ixchiwinti Dios: Yucha an Jesús, ists'alh José, jamacha'a Nazaret. ");
INSERT INTO tpp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","An Natanael najun: ―¿Jamacha'a Nazaret, laycha oxi tu'u kaminchalh ancha? An Felipe alhtaylh juniy: ―Li k'at'at'icha k'ala'ts'ina'acha. ");
INSERT INTO tpp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Akxni an Jesús la'ts'incha li la'antachalhcha an Natanael, najun: ―¡Ani minta pumatam jamacha'a Israel, yu jantu ja'o'xcho'onun! ");
INSERT INTO tpp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","An Natanael ja'alhtayanalh: ―¿T'asich'a k'ilhimisp'ayi? An Jesús alhtaylh juniy: ―Akxni jantuka' ixt'asaniyan an Felipe, ikla'ts'inani akxni ixyat'i ixtamp'in an xak'iw higo. ");
INSERT INTO tpp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","An Natanael, juniy an Jesús: ―¡Maestro, uxint'i isTs'alhk'at'i Dios! ¡Uxint'i ixRejk'an an xalapanakni Israel! ");
INSERT INTO tpp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yucha alhtaylh juniy: ―¿K'iklak'a'iya mu wa xliyu ijkunan li ikla'ts'ini an ixtamp'in xak'iw higo? Tacha ani palay k'ala'ts'ina'a yu palay laj'ay tanlhun. ");
INSERT INTO tpp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Chi nawpalay an Jesús: ―Sawalhi an yu iklajunaw, ati'anta uxitnan k'ala'ts'ina'it'iti an lakt'iyan katati'ayanta ch'i k'ajala'ts'ina'it'iti an ix'angelhnin an Dios tacha tatach'ixa chi tata'alhtajuy la ix'ukxni an isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ixlila'at'utucha wilhchan walh, tama'xto'kalh la'acha'an Caná, xalakaat'un Galilea, chi ancha ixt'ajun an ixnati Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chi an Jesús chi an ixt'alhtanan wachu jamak'atsaanikalhi li kata'alh. ");
INSERT INTO tpp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Walh ancha min'olhcha an yu ixlaj'otkan xaxkan uva. Pus wa chuncha an ixnati an Jesús, juniy: ―Jantucha tu'u an xaxkan uva. ");
INSERT INTO tpp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","An Jesús alhtaylh juniy: ―¿Chi kit'in tasu li k'i'uniycha? Jantuka' chini kimpanch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","An ixnati an Jesús, jajuniy an yu ixtamala'pitsiy tanlhun: ―Chux yu tajunan yucha, yuch'ach'a k'a'ilht'ut'it. ");
INSERT INTO tpp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ancha ixlakwilh la'achaxan wa tacha a'xaw de chiwx, yu ixpumujukan xkan, cincuenta u setenta litro xkani lay ixputajuy, yucha ixtaxa'a'iy an judiojnin akxni ixta'ilhtuy yu tacha ixtamasunita ixlakpaynink'an para li katastalan'alh. ");
INSERT INTO tpp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","An Jesús jajuniy: ―K'ala'la'ts'amat laka xkani anchunu lakwilh yu pumujukan xkan. Pus oxicha tala'la'tsamalh. ");
INSERT INTO tpp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Chi ixli'astan jajuniy: ―Chaway k'amak'ut'utcha lakats'uniy chi k'alhip'inichi'itcha an yu la'ts'ilhi'anta ani wayt. Pus talhi'anilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kilhk'atsalhcha an yu ixla'ts'ilhi'anta laka k'atan li junitacha tacha xaxkan uva an xkan, masi yucha jantu ixk'atsayi tanchuncha minchalh. Pero an yu ixtamala'pitsiy tanlhun yu'uncha ixtak'atsay, mu yu'uncha tamakutulh an xkan an laka pozo. An yu ixla'ts'ilhi'anta laka k'atan t'asanilhi an yu tama'xt'o'a lapanak, ");
INSERT INTO tpp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","chi juniy: ―Watichicha lapanak p'ulhnajcha yu an oxi xaxkan uvaja xt'a'a, chi akxni lhuwcha laj'otkanta, yucha an yu palaycha wa aktayi xt'a'a, walh chi uxint'i an yu oxi lhi'ot'at ma'at'aka sta astan. ");
INSERT INTO tpp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yucha anicha yu p'ulhnajcha masulh an Jesús, la'acha'an Caná xalakaat'un Galilea, masulhcha li alhp'asi yucha, chi an ixt'alhtanan takiklaka'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ixli'astan akxni chunchacha tapasalh, an Jesús jat'a'alhcha an ixnati chi an ixjat'ala'awnin chi an ixt'alhtanan la'acha'an Capernaúm; anchacha tatamakawlh, jantu la'alhuw wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Mu waniycha ixminta ixk'atan paxku, ixk'atank'an an judiojnin, an Jesús alh la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Walh an laka tajtan jala'cha'alh an yu ixtast'ay torojnin chi borregojnin chi palomajnin chi an yu ixtamapaxay tumin, anchacha ixtalakwilanalh. ");
INSERT INTO tpp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Mu chunchacha jala'ts'in an Jesús, pus xa'a'ilh ma'atam lazo, ilhtulhcha ixpa'ayna'na. Wanaj jatamakxtu'olhi an laka tajtan chux an ixborregojnink'an chi an ixtorojnink'an an lapanakni. Chi tilhcha jamaj'anilhi an ixtumink'an an yu ixtamapaxay tumin chi jala'ma'pusp'itnilhcha an ixmesajk'an. ");
INSERT INTO tpp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jajuniy an yu ixtast'ay paloma: ―¡K'alakt'amakxt'ut'iti an tanlhun ani, jant'u k'a'ilht'ut'iti mimpast'ank'an an ixcha'a kimPay! ");
INSERT INTO tpp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pus akxni tapastaklhicha an ixt'alhtanan li ts'o'muk'akanta, tan najunta: “¡Sawalh aklhitalh'amna an mincha'a'!” ");
INSERT INTO tpp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","An judiojnin tajuniy an Jesús: ―Li ch'unch'ach'a lay, ¿tisuncha akilamasuniyaw li t'ach'ip'ini li ch'unch'ach'a k'alat'i? ");
INSERT INTO tpp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","An Jesús jajuniy: ―K'alakt'ilhit'iti ani tajtan, walh chi wa la'at'utu wilhchan akyawcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pus an judiojnin tajuniy: ―¿Wa la'at'utu wilhchani k'ayawch'o'oya'a? Ani tajtan t'up'uxamchaxan (46) k'ata yawkalh. ");
INSERT INTO tpp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero an Jesús yucha an ixlakatunaja ixjuniy. ");
INSERT INTO tpp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Xliyu akxni la'awcho'olhcha, an ixt'alhtanan tapastaklhi li chuncha ixnajunta, pus takiklaka'ilhi an tan ts'o'muk'akanta chi an ixchiwinti an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Akxni la'acha'anka Jerusalén ixt'awnachalh an Jesús, la ixk'atan Paxku, ixluwk'ani takiklaka'ilh, mu ixtala'ts'incha tacha an tu'u ixlak'ilhtuy yu jantu wa tichicha lay ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero an Jesús jantu ixjalhiwilay, mu yucha ixjamispa'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yucha jantu xamati ixma'lhtask'iniy kajunilh tani ixlaycha xamati'. Mu yucha ixjamispani'ojoyi an ixjalhunutk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ixt'ajun pumatam lapanak yu'uncha an yu ixjajunkan fariseojnin, ixjunkan Nicodemo, an judiojnin xa'ayi ixta'ilhtuta. ");
INSERT INTO tpp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ani lapanak la'alhi an Jesús puts'ista, chi juniy: ―Maestro, ijk'atsayawi li Diosi mala'achatacha'an para li akilamiw masuninin, mu jantu xamati lay kati'ilhtulh t'ach'a an lak'ilht'uy tanlhun yu wa tichicha lapanak, li yu jantu Dios t'a'aklat'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","An Jesús juniy: ―Sawalhi ani yu ijkunan, yu jantu sast'i tsukucho'oy jantu lay katila'ts'ilh an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","An Nicodemo juniy: ―¿Tasicha lay kalhitsukucho'olh xamati li papacha? ¿Laycha kapalaktajucho'olh ixnati chi katsukupalh? ");
INSERT INTO tpp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","An Jesús juniy: ―Kit'in sawalhi ani yu ijkunan, li yu jantu tsukuyi laka xkan chi la ixTakuwin an Dios, jantu lay katitanuchalh an la ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yu wa laka lakatunaja pula'ajun, wa lakatunaj, yu laka Takuwin pula'ajun, yucha takuwin. ");
INSERT INTO tpp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jant'u k'alhi'a'nit'i li ijkunan: “Li lhitask'iniya li sast'i kala'awcho'okalh.” ");
INSERT INTO tpp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","An un wa lhitanchuncha minachalh, chi masi k'a'asmatt'i makat'ajun, pero jant'u k'ak'ats'ati tanchuncha minachalh chi tanchuncha ti'an. Chuncha yu la'ajun laka Takuwin. ");
INSERT INTO tpp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","An Nicodemo lhisakmilh juniy: ―¿Chi tasicha aklhit'alalhi? ");
INSERT INTO tpp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","An Jesús alhtaylh juniy: ―Uxint'i li ixmaestrojk'an xalapanakni Israel, ¿ch'i jant'u k'ats'ayi ani tanlhun? ");
INSERT INTO tpp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sawalhi an yu ijkunan, kitnan iknawnaw yu ijk'atsayaw chi yu ikla'ts'intaw. Pero uxitnan jant'u k'iklak'a'iyat'iti an yu iklajunaw. ");
INSERT INTO tpp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Li jant'u k'iklak'a'iyat'iti an yu iklalhixa'alayaw yu wa ani lakamunulhpa alin, ¿t'asu laych'a k'alhik'iklak'a'iya'it an yu lakt'iyan alinachalhi? ");
INSERT INTO tpp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Jantu xamati anta an lakt'iyan, wa yucha an yu ancha minchalh, an yu kijunchilh isTs'alh Lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Chi tacha an tanxtukmuk'alh an tsapulh an Moisés an tan wa jasa'nik'a lakaat'un, chuncha wachu an yu kijunchilh isTs'alh Lapanak kaxtukmuk'akana laka k'iw. ");
INSERT INTO tpp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Para li wa tichicha yu kakiklaka'iya, katsuku'alhiya', jantu katits'an'alh. ");
INSERT INTO tpp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Mu an Dios sawalh jamapayniya an lapanakni yu tat'ajun an lakamunulhpa', yucha lhixta'lhi an isTs'alh masi wa ix'akstu, para li yu kiklaka'iy jantu kats'an'alh, kalhitsukulhi jatsukunti yu jantu a'tam min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","An Dios jantu mala'achachalh an isTs'alh ani lakamunulhpa para li kamilh jalhitama'chapunu', yucha minta jama'alhtaxtunu'. ");
INSERT INTO tpp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Yu kiklaka'iy jantu katimama'alh'ajnikalh, pero yu jantu kiklaka'iy yucha o'sliyancha li kamama'alh'ajnikana', mu jantu kiklaka'iya an isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yucha aniya ixlakata an lhima'alh'ajnat, li an jatapulhkunu yucha kilachilhcha ani lakamunulhpa', pero an lapanakni jantu tala'ts'imputulh, palay ta'achanilhi an lakaputs'isni, mu wa yu jantu oxi laktanlhuncha ixta'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Watichicha yu wa tanlhuncha yu jantu oxi lak'ilhtuy, jantu la'ts'imputuni an jatapulhkunu', chi jantu k'uxa'ani tan pulhkuy para li jantu katasulhi yu an ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero yu ilhtuyi yu laj'oxi tanlhun yucha tan pulhkuyi an, para li katasulhi li an yu ilhtuy yucha an tacha najun Dios. ");
INSERT INTO tpp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ixli'astan an Jesús ali an ixt'alhtanan ta'alhcha xalakaat'un Judea, anchacha ixtat'awnachalh chi ixjama'paxanancha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chi an Juan, tanchun junkan Enón waniy Salim ancha ixjama'paxanan, mu ancha lhuwi ix'alin xkan. Ixtalaj'a'paxacha an lapanakni akxni ixtacha'an, ");
INSERT INTO tpp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","mu an Juan akxni jantuka' ixmalaklhchawkan. ");
INSERT INTO tpp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Wa chuncha an ixt'alhtanan an Juan chi ali'in judiojnin tsukulhcha talalhikikxtukuyi ixlakata an stalan'anti. ");
INSERT INTO tpp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chi tala'alhi an Juan, tajuniy: ―Maestro, an yu ixt'ayan an ixtapiktutam ayxkan Jordán, an lapanak an yu jalhixa'alat'i, wachu jama'paxanan, chi yucha tala'an'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","An Juan jajuniy: ―Jantu xamati lay la'a'iy tu'u li jantu yucha an Diosi xta'niy. ");
INSERT INTO tpp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Uxitnan k'ats'ayat'iti li iknajun li jantu kit'ini ijCristo, kit'in wa p'ulhnajcha kimakminkanchalh. ");
INSERT INTO tpp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Lakatam tan tama'xto'kan, an ts'alh yucha yu lhit'ajun an ixli'it, chi an ix'amigo an ts'alh an yu tama'xt'o'a, yu waniy t'ayalh chi alha'asmat'a yu najun, sawalhcha achan. Xliyu kit'in an ki'achat a'tsay. ");
INSERT INTO tpp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yucha task'iniya li kata'ayalhi laka lhitapalat, chi kit'in aktalakat'ikt'ilh. ");
INSERT INTO tpp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Yu talhman mintachalh jantu xamati ixt'achun. Chi yu wa anicha lakaat'un alin wa xanawincha lakaat'un, chi wa yu anicha alini lhichiwiniy. Pero yu lakt'iyan mintachalh jantu xamati ixt'achun, ");
INSERT INTO tpp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","chi yucha lhichiwiniy yu la'ts'intacha chi asmattacha, pero jantu xamati kiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Li xamati kiklaka'iy an tacha najun, yucha najuni li sawalhi an tacha najun an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mu an yu Dios makminta, yucha an ixchiwinti Diosi lhichiwiniy, chi mu an Dios yucha jantu wa jatapulhkanti xt'a'a an ixTakuwin. ");
INSERT INTO tpp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","An Dios mapayniya an isTs'alh, pus ma'axta'ni'olhi an laktanlhun la ixmaka'. ");
INSERT INTO tpp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yu kiklaka'iya an isTs'alh Dios lhit'ajuncha an jatsukunti yu jantu katimin'olh. Pero yu jantu kiklaka'iputun jantu katila'ts'ilhi an jatsukunti, yucha kala'a'iya an ay lhima'alh'ajna yu kaxta'niya an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Akxni k'atsaalhi an Jesús li an fariseojnin tak'atsaalhi li ixnawkan li an Jesús palay ixjama'paxanan chi an Juan jantu, ");
INSERT INTO tpp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","masi an Jesús jantu yu ixjama'paxanan, yu'uncha an ixt'alhtanan, ");
INSERT INTO tpp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","an Jesús taxtulhi xalakaat'un Judea k'uxa'ancho'olhi xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chi ixlitask'iniya li kala'pusli o'sliyani xalakaat'un Samaria. ");
INSERT INTO tpp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pus cha'alhcha lakatam xala'acha'an Samaria, junkan Sicar, waniy la ixlakaat'un an Jacob yu ixta'nitacha an ists'alh José. ");
INSERT INTO tpp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ancha ix'ulata ixpozojo an Jacob, pus anchacha sa' tawilh an Jesús, mu sawalhcha ilho'onta la ixjalhtanti, wa k'ischa ix'atunkunt'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Walh cha'alh pumatam t'aku, jamacha'a Samaria, ixmakutuycha xkan, pus an Jesús juniy: ―Ak'int'a'ott'ika lakats'uniy mixkan. ");
INSERT INTO tpp_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mu an ixt'alhtanan an Jesús ixta'anta an la'acha'an tamawnin yu kata'uya'. ");
INSERT INTO tpp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","An t'aku, jamacha'a Samaria alhtaylh, juniy: ―¿Tasu li k'isk'iniycha xkan li akt'a'otni li uxint'i jamacha'a Judeajk'at'i chi kit'in ijkamacha'a Samariaja? Chuncha junilh mu an judiojnin chi an samaritanojnin jantu ixtalala'ts'imputum. ");
INSERT INTO tpp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pus an Jesús alhtaylh juniy: ―Li k'a'ixk'ats'at'i yu xt'a'a an Dios, chi tichini yuchacha an sk'iniyan xkan, uxint'i yuch'a k'a'isk'inin, chi yucha ka'ixta'nini xkan yu la'ajunta. ");
INSERT INTO tpp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","An t'aku juniy: ―Jamach'alhkat, jant'u t'u'u lhit'a'un yu k'ap'umak'ut'u an xkan, chi an pozo putalhman. ¿T'anisch'a k'a'iya'a xkan yu ak'ixt'a'niya'a yu la'ajunta? ");
INSERT INTO tpp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Chu sna palay ayk'at'i, palay jantu an kimpayk'an Jacob yu kintaxta'nin ani pozo, tan otlhi xkan chi an ixjas'at'an chi ixjatapakxat? ");
INSERT INTO tpp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","An Jesús juniy: ―Wa tichicha yu ot'a ani xkan kakikxixpala', ");
INSERT INTO tpp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","pero yu ka'ot'a an xkan yu kit'in akxta'niya jantucha a'tam katikikxixli. Mu an xkan yu kit'in akxta'niya la ixjatsukunticha kataxtutawla yu kaxta'niyacha ixjatsukunti yu jantu min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","An t'aku juniy: ―Ak'ixt'a'nini yu yucha xkani Jamach'alhkat, para li jantucha ali ajkikxixli chi jantucha ali akmilh makutunu ani. ");
INSERT INTO tpp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","An Jesús juniy: ―K'ap'inchi t'asanini mint'apapa chi k'at'at'ana'acha. ");
INSERT INTO tpp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","An t'aku alhtaylh juniy: ―Jantu tu'u kint'apapa'. An Jesús juniy: ―Chunchacha sawalhi t'ach'a an na'un li jantu tu'u mint'apapa'. ");
INSERT INTO tpp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ixkisinchak'ani jamak'a'unt'a chi chaway an yu lhit'a'un jantu mint'apapa'. Sawalhi an yu na'un. ");
INSERT INTO tpp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Akxni chunchacha alha'asmat'a an t'aku, juniy: ―Jamach'alhkat, kit'in iklhiwilay ka ixchiwinti Diosi lhich'iwiniy. ");
INSERT INTO tpp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kitnan an kilakpaynink'an ani a'stitawk'a ixtatapayniniy Dios, pero uxitnan yu judiojnin nawnat li la'acha'an Jerusaleni katapayninikalh. ");
INSERT INTO tpp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","An Jesús juniy: ―Ani ijkunan sawalh, kachina panch'e'ex akxni k'at'ap'ayniniya'it'it an Dios wa tanchuncha masi jantucha ani a'stitawk'a chi Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Uxitnan jant'u k'ats'ayat'iti t'ich'ini t'ap'ayniniyatcha, pero kitnan ijk'atsayawi tichini iktapayniniyawcha, mu tuchi lhita'alhtaxtukan ixlakatak'an an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero an panch'e'ex kachinacha, chi chawaycha, akxni an yu ixlisawalh tatapayniniy an Dios katatapayniniya laka takuwin chi ixlisawalh, chi mu wachu an Dios, an yu tatapayniniy japuxkajuyi li katatapayninilh. ");
INSERT INTO tpp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","An Dios wa Takuwin, chi an yu tatapayniniy laka takuwin chi ixlisawalh task'iniya li katatapayninilh. ");
INSERT INTO tpp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","An t'aku juniy an Jesús: ―Ijk'atsayi li kamina an Mesías, yu junkan Cristo. Akxni kaminacha akintajun'oyani an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","An Jesús alhtaylh: ―Yucha kit'in, kit'in yu ikt'achiwint'awnan. ");
INSERT INTO tpp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wa akxni tachincho'olhcha an ixt'alhtanan an Jesús, pus ixtalhi'a'niycha li ixt'achiwint'ajun pumatam t'aku'. Pero jantu xamati lhisakmilh tani ixnajuncha an t'aku u tuchini ixlit'alakchiwint'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wa chuncha an t'aku makaw'ulalhi an ix'a'xaw, chi alhcha jamak'atsaanini an la'acha'an an lapanakni, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―K'at'at'it, ka'aw la'ts'inin pumatam lapanak yu kijunilhi tuchini k'ilhtutacha. ¿Jantu yucha an Cristojcha? ");
INSERT INTO tpp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pus tataxtulhi an la'acha'an chi tala'cha'alhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","An ixt'alhtanan an Jesús yu'uncha ixtalhitapayniniyanalh, ixtajuniy: ―Maestro, k'awaycha. ");
INSERT INTO tpp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yucha jajuniy: ―Kit'in iklhit'ajun la'atam wayt yu uxitnan jant'u misp'ayat. ");
INSERT INTO tpp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Pus an ixt'alhtanan ixtanajun: ―¿Xamati amaj lhiminilh tu'u yu ka'ulh? ");
INSERT INTO tpp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","An Jesús jajuniy: ―Kit'in kiwayt yucha li ak'ilhtulh tacha an lakask'in an yu kimakminta, chi li ak'ilhtu'olhi an ixtapatsat. ");
INSERT INTO tpp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Uxitnan nawnat: “Ts'an'ayka la'at'at'i malhkuyu para li kajap'uxnunkalhcha”. Pero kit'in iklajunaw li k'alhak'ap'up'it'itcha an jach'ananti, mu k'at'atacha para li kajap'uxnunkalhcha. ");
INSERT INTO tpp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yu ma'tapatsay an tan jap'uxnunkan kamapalhnikana', chi mach'ixtamiy jatawk'ati an yu ma'tapatsay para li ka'alilh jatsukunti yu jantu a'tam katimin'olh, chi katalaj'achana an yu jach'ananalh ali an yu jap'uxnun. ");
INSERT INTO tpp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ts'awjcha tacha an nawkan, li: “Ali'ini yu tach'an chi ali'ini an yu tajap'uxnun.” ");
INSERT INTO tpp_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kit'in iklamak'antaw para li k'ap'uxt'iti yu jantu uxitnan lhit'ap'ats'at'it, ali'ini yu tatapatsalh, chi uxitnanch'a yu oxi la'a'iyat an yu tala'tapatsalh yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ixluwk'an an lapanakni an yu ancha jamacha'an anchunu xala'acha'an Samaria takiklaka'ilhi an Jesús, xliyu tacha an ixjajunitacha an t'aku', li an Jesús junilhi tuchini ix'ilhtutacha. ");
INSERT INTO tpp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wa chuncha tala'cha'alhi an jamacha'an Samaria an Jesús chi tajuniy li ma kajat'atamakawlh, pus jat'atamakawlhcha la'at'uy wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Palaycha ixluwk'ani takiklaka'ilh an Jesús, mu wanajcha yucha ixta'alha'asmat'a. ");
INSERT INTO tpp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chi ixtajuniy an t'aku: ―Jantucha wa xliyu iklhikiklaka'iyaw li t'ach'a an na'un, wanajcha kitnani ik'alha'asmat'aw chi ijk'atsayawi li ani yucha sawalhi yu jama'alhtaxtunun ani lakamunulhpa', ani Cristo. ");
INSERT INTO tpp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","La'puslicha la'at'uy wilhchan, an Jesús taxtulhcha xalakaat'un Samaria, alhcha xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Mu wanaj yucha ixnajunta, li yu lhichiwiniy ixchiwinti Dios jantu la'a'ikani la ixlakaat'un. ");
INSERT INTO tpp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Akxni cha'alhcha Galilea, an jamacha'an Galilea tala'a'ilhcha an Jesús, mu ixtala'ts'intacha tacha an ixlak'ilhtutachalh tanlhun an la'acha'an Jerusalén, akxni k'atan ixjunita, mu yu'uncha wachu ixta'anta an laka k'atan. ");
INSERT INTO tpp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pus an Jesús a'tamcha ampalhi Caná, xalakaat'un Galilea, tan an ix'ilhtuta tacha xaxkan uva yu wa xkan. Walh an la'acha'an Capernaúm ixt'ajun pumatam xa'ay ixt'atapatsan an rey, wa ixta'an'ay ists'alh. ");
INSERT INTO tpp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Akxni asmatlhi an ixt'atapatsan an rey li an Jesús Galileajcha ixt'ajun, la'alh chi ixtapayniniycha li kat'a'alhi la ixcha'a para li kak'uch'unilhi an ists'alh, mu ixnit'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wa chuncha an Jesús juniy an lapanak: ―Uxitnan li jant'u la'ts'inat'iti tu'u yu lhi'a'nin jant'u jak'iklak'a'ininat'it. ");
INSERT INTO tpp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","An xa'ay ixt'atapatsan an rey juniy: ―Jamach'alhkat Jesús, li jantuka' niya an kints'alh watukancha ak'int'ap'it'i. ");
INSERT INTO tpp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","An Jesús juniy: ―K'ap'inch'o'ochicha mincha'a', amints'alh t'ajun. An lapanak kiklaka'ilhi tacha an junilh an Jesús, pus alhcha. ");
INSERT INTO tpp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Akxni ixcha'ant'ajuncha la ixcha'a, an ixma'tsukunin talakatastuklhicha, tajuniy: ―Amints'alh ta'oxilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pus jalhisakmilhcha tuchi panch'e'excha akxni ta'oximaj'ayacho'olhcha. Tajuniy: ―Kutanchacha ta'oxay, la una, akxnicha makawlh an alhp'as iskakat. ");
INSERT INTO tpp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pus an ixpay an ts'alh lhimacha'xalhcha li chunchacha horaja ixjunita akxni an junilh an Jesús: “Amints'alh t'ajun.” Pus kiklaka'ilhcha yucha chi chux an yu ta jalhila'ts'in. ");
INSERT INTO tpp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yucha anicha yu ixlitipat'uycha yu laj'oxi masulh an Jesús, akxni minchalh xalakaat'un Judea chi cha'alhcha xalakaat'un Galilea. ");
INSERT INTO tpp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ixli'astan jumpalh, an judiojnin ixta'ilhtuy la'atam k'atan, pus an Jesús tama'ast'a'alhi Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","An Jerusalén, alin lakatam tan nap'an tajun xkan, lakakisi xamalhticha lhit'ajun. Tan junkan lhihebreo Betesda. Waniy tan junkan ixmalhtichak'an borregojnin ");
INSERT INTO tpp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","An tan ixlakputanukanachalh, lhuw ta'an'anini ixtalakmanalh, yu la'la'lhtulu'un, yu lakch'anlht'ulukun, chi yu wa ixtalaklakalhtukulunta, ixtapakxancha li kalaklalh an xkan.  ");
INSERT INTO tpp_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Mu an tan nap'an ixtajun xkan ixlila'paj'ayan ixta'alhtajuy pumatam angelh chi ixlaklaycha an xkan, pus yu p'ulhcha ixtajuy an lakxkan akxni ixlaklaycha, ixtak'uch'uycha, wa tuchicha ta'an'at kaxlitsukulh. ");
INSERT INTO tpp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ancha ixmalh pumatam lapanak la'ap'uxamkawtsajincha k'ata ixta'an'ajmalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Pus akxni an Jesús la'ts'ilhi li ancha ixmalh, chi k'atsaalhi li ma'anchacha chuncha ixta'an'ajmalh, juniy: ―¿T'ak'uch'up'ut'un? ");
INSERT INTO tpp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","An ta'an'an alhtaylh juniy: ―Jamach'alhkat, jantu xamati kintamaj'oy an tan wilh xkan akxni laklay, akxni wa ik'amputunka pumatamcha las tajuyachalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Pus an Jesús juniy: ―K'a'ost'aycha, k'asakt'icha amimputamat ch'i k'ajalht'ancha. ");
INSERT INTO tpp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pus wa akxni anchunu lapanak ta'oxilhcha, saklhicha an ixputamat chi jalhtanajtsukulhcha. Akxni chuncha tapasalh, akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wa chuncha an judiojnin tajuniy an yu k'uch'uk'alh: ―Chaway wa jastaknankan wilhchan, jantu oxi li ch'ixlit'a'un amimputamat. ");
INSERT INTO tpp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Yucha jajuniy: ―An yu kink'uch'ulh yucha kijuniy: “K'asakt'icha amimputamat ch'i k'ajalht'ancha.” ");
INSERT INTO tpp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pus tajuniy: ―¿Tisiyuchacha yu junan li: “K'asakt'icha mimputamat ch'i k'ajalht'ancha”? ");
INSERT INTO tpp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero an lapanak an yu k'uch'ukalh jantu ixk'atsayi tichini yuchacha an yu k'uch'ulh, mu an Jesús jantucha ani ixt'ajun an tan lhilhuw ixlakyakalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ixli'astan an Jesús la'cha'alh an laka tajtan chi juniy: ―Chaway t'ak'uch'ut'icha, jant'uch'a ali k'a'ilht'u mintala'alhin para li jant'u t'u'u k'ap'ut'ap'asa yu palay makxkay. ");
INSERT INTO tpp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","An lapanak alhcha chi jalakjunilhcha an judiojnin li yucha an Jesusi yu k'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pus an judiojnin ixtalhich'a'o'aycha an Jesús, ixtama'niputuncha, wa xliyu li ixlak'ilhtuyi ani tanlhun akxni masi wa jastaknankan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","An Jesús jajuniy: ―An kimPay masi tacha chaway, tapatsay, kit'in wachu iktapatsay. ");
INSERT INTO tpp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pus an judiojnin palaycha ixtalhima'niputun li ixnajun li yucha isTs'alh Dios, chi li yucha tapatsayi akxni jantu tapatsakan wilhchan, tacha Dios. ");
INSERT INTO tpp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","An Jesús jajuniy: ―Ani klajunaw sawalh: Jantu lay tu'u kati'ilhtulhi an isTs'alh Dios wa ix'akstucha ka'ilhtuputulh, yucha ilhtuy yu la'ts'in ilhtuy an ixPay. Chux yu ilhtuy an ixpay wanajcha chuni ilhtuy an Ists'alh. ");
INSERT INTO tpp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mu an ixPay mapayniya an isTs'alh chi masuniya chux tacha an lak'ilhtuy. Chi palay kalakmasunikana yu palay laj'ay tanlhun, yu sawalhch'a k'alhi'a'niya'it'it uxitnan. ");
INSERT INTO tpp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mu tacha an ixPay jamala'awniya an janinin chi jaxta'niya jatsukunti, an isTs'alh wachu jaxta'niya jatsukunti yu jaxta'niputun. ");
INSERT INTO tpp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","An ixPay jantu xamati lhimuk'ay tuchini ilhtutacha xamati', yucha an isTs'alhi ma'axta'nita li kanawna tuchini yu ilhtutacha xamati'. ");
INSERT INTO tpp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Para li lhichuxi kakiklaka'ikalh chi kalhiwilakalh an isTs'alh tacha kiklaka'ikan an ixPay. Yu jantu kiklaka'iya an isTs'alh Dios, wachu jantu kiklaka'iya an ixPay, yu mala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ani iklajunaw sawalh: Yu asmat'a an kinchiwinti chi kiklaka'iya an yu kimala'achatachalh lhit'ajuni jatsukunti yu jantu min'ojoy, jantu katimama'alh'ajnikalh, yucha la'puslicha laka lhinin, laka jatsukunticha cha'alh. ");
INSERT INTO tpp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kamina panch'e'ex chi sawalh, chi an panch'e'ex chawaycha, akxni an janinin kata'alha'asmat'a an isTs'alh Dios. Chi an yu kata'alha'asmat'a katatsukuya'. ");
INSERT INTO tpp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mu tacha an ixPay lhit'ajuni jatsukunti, wanajcha chuni ilhtuta an isTs'alh li kalhitsukulhi jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Chi atumpaj, xta'nipalhi lhich'alhkat li yucha kanawna tuchini ilhtulhcha atam, mu yucha isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Pero jant'u k'alhi'a'nit'iti ani, mu kachina panch'e'ex akxni ixchuxk'an an yu ta'aknunun kata'alha'asmat'a an ixchiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chi yu ta'ilhtulhi yu oxi tanlhun katatak'ut'acha chi katala'awcho'oyacha ixpujun'alhincha. Pero yu ta'ilhtulhi yu jantu oxi, katala'awcho'oya para li katama'alh'ajnanacha. ");
INSERT INTO tpp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Jantu layi tu'u k'ilhtuy yu wa ki'akstucha ak'ilhtuputulh. Tacha ik'asmat'a kijuniy an kimPay chunchacha ik'ilhtuy, pus an yu ik'ilhtuy ts'awj, mu jantu yu wa kit'incha iknajuni ik'ilhtuy, yu najun an kimPayi ik'ilhtuy, yu kimakminta. ");
INSERT INTO tpp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Li wa ki'akstucha aklhichiwinkalh, an yu aknawna jantu katilhitapalalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pumatami yu kilhichiwiniy kit'in, chi ijk'atsayi li tacha an kilhichiwiniy sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Uxitnan jamala'ach'anit'iti yu kata'alh lhisakminin an Juan tichini yuchacha, chi yucha ts'ajwi lhichiwinilh yu sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero jantu li sna wa ijkiklaka'it'ajuncha xamati wa lapanak, ani iklajunaw para li uxitnan k'at'a'alht'axt'ut'it. ");
INSERT INTO tpp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","An Juan tachanu la'atam pumaklhku ixjunita, yu ixma'tajiy chi ixmapulhkuy, chi uxitnan p'ulaj'ach'amp'ut'unt'iti an ixjatapulhkunu wa tam pants'ik'is. ");
INSERT INTO tpp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero kit'in iklalhiminitaw yu palay laj'ay pujamak'atsaaninti, an Juan palay wa lakat'ikt'i. Yu ik'ilhtuy kit'in, yucha yu kilhijuniy an kimPay, chunchacha putasuy li yucha an kimPayi kimakminta. ");
INSERT INTO tpp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","An kimPay an yu kimakminta wachu kilhichiwiniya kit'in, masi uxitnan jant'u a't'am alha'asmatt'at'it ch'i jant'u a't'am la'ts'int'at'it. ");
INSERT INTO tpp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ch'i jant'u mak'awniyat'iti li an ixchiwinti kataputsuku'alhin, mu jant'u k'iklak'a'iyat'iti an yu mala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sawalhcha ixlak'anti p'unawnat an tan ts'o'muk'akanta an ixchiwinti Dios, mu lhiwilayat li anch'a la'ch'ip'imp'ut'unat an jatsukunti yu jantu a'tam min'ojoy, chi ancha kilhichiwininta. ");
INSERT INTO tpp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Walh jantu kilala'mimputunawi para li k'alhits'uk'ut'iti an jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Kit'in jantu yu iklhakapu'an li an lapanakni ay akintala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Atumpaj iklamispayawi uxitnan chi ijk'atsayi li jant'u lhit'awnat'iti an ixjamapayninti Dios. ");
INSERT INTO tpp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Kit'in yucha an kimPayi kimakminta, walh chi jantu kilala'a'iyaw. Pero li xamati lapanak ka'ixmilh yu wa ix'akstucha ka'ixk'uxamilh, yuch'a k'a'ixla'a'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Tasich'a k'ajalhik'iklak'a'inina'it uxitnan li wa mi'akstuchak'ani sawalh lalhiwilayat'iti, ch'i jant'u p'uxk'awyat'iti yu ix'alhp'asninti an yu wa yuchacha Dios sawalhi? ");
INSERT INTO tpp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Jant'u k'ana'unt'it li sna akla'alhtasuyawi la ix'ukxlakapu an kimPay. Yucha an Moisesi kata'alhtasuyan, an yu k'iklak'a'iyat uxitnan. ");
INSERT INTO tpp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mu li uxitnan k'a'ixk'iklak'a'it'iti an Moisés, kit'in wachu xakilakiklaka'iw, mu an Moisés yucha kilhits'o'muk'alh. ");
INSERT INTO tpp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero li jant'u k'iklak'a'iyat'iti an yu ts'o'muk'ata, ¿t'asich'a k'alhik'iklak'a'iya'it kinchiwinti? ");
INSERT INTO tpp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ixli'astan, an Jesús alhcha an ixtapiktutam ay xalakxkan Galilea, jumpalhkan Tiberias. ");
INSERT INTO tpp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Wanaj lhilhuwi ixch'a'o'akanta, mu ixtala'ts'incha tacha an ixjak'uch'uy an ta'an'anin. ");
INSERT INTO tpp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wa chuncha tama'ast'a'alhcha tanchun a'stitawk'a chi anchacha sa' tawlhchalh ali an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","An Paxku iso'omintacha, ixk'atank'an an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Akxni an Jesús talakatiyawlh chi la'ts'ilhi li wanajcha lhilhuw, lhisakmilhi an Felipe, juniy: ―¿Tanischa kajatamawniyaw pan ani lapanakni para li kata'ulhcha? ");
INSERT INTO tpp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pero an Jesús yucha wa ixjuniycha an Felipe, wa ixlila'ts'intanuycha, mu yucha ixk'atsaycha tani kalhit'alayacha. ");
INSERT INTO tpp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","An Felipe najun: ―Masi la'at'uy ciento wilhchan aklhima'tapatsalh jantu katicha'alhi para li lakts'unijcha kata'ulh. ");
INSERT INTO tpp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Xapumatam an ixt'alhtanan an Jesús, junkan Andrés, ixt'ala'ajun Simón Pedro, juniy an Jesús: ");
INSERT INTO tpp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ani t'ajun pumatam ts'alh lhit'ajun a'xkisi pan de cebada chi la'at'uy jatanti, pero, ¿tisuncha li wanajcha lhilhuwi? ");
INSERT INTO tpp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Wa chuncha an Jesús jajuniy: ―K'aja'unitka li katalaktawilhka'. Ancha wa stakcha ixjala'awnininta, pus talaktawilhcha, katacha la'akisi milh lapanakni. ");
INSERT INTO tpp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","An Jesús xa'a'ilhcha an pan, chi ixli'astan xta'lhicha lhimala'puchajun, chi jaxta'nilhcha an ixt'alhtanan. Chi yu'uncha tamala'pitsinilhcha ixchuxk'an an lapanakni yu ancha ixtawilanalh, chi an jatanti wanajcha chuni ilhtulh, chi jaxta'nilhcha, tacha oxicha talhikiklalh. ");
INSERT INTO tpp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Akxni talaj'o'atsa'olhcha, an Jesús jajuniy an ixt'alhtanan: ―K'amach'ixt'amitcha an yu xajchalh lakt'ikt'i, para li jantu tu'u kats'an'alh. ");
INSERT INTO tpp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pus tamach'ixtamilhcha, la'akawt'uy kanastaja an xala'tach'e'en yu xajchalh an yu ta'ulh an a'xkisi pan de cebada. ");
INSERT INTO tpp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","An lapanakni akxni chunchacha tala'ts'ilh ilhtulh an Jesús, ixtanajun: ―Yucha anicha sawalhi an li yu kamina lhichiwiniy ixchiwinti Dios ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero an Jesús jalhimacha'xanilhi li ka'asi talhi'amputuna para li kata'ilhtulh rey, pus ampalhi an a'stitawk'a wa ix'akstu. ");
INSERT INTO tpp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Akxni tats'isilhcha, an ixt'alhtanan an Jesús ta'alhcha an lakxkan, ");
INSERT INTO tpp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","chi tatajulhcha lakatam laka barco, ixtapatakutt'ajuncha an lakxkan, ixtita'ancha la'acha'an Capernaúm. An Jesús tuka' ixjala'cha'an, walh chi puts'istacha ixjunita. ");
INSERT INTO tpp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Wa akxni an lakxkan tsukulhcha laklay, mu p'ascha ixmin un. ");
INSERT INTO tpp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Katacha la'akisicha u la'achaxancha kilometrojo ixta'antachalh, tala'ts'ilhcha an Jesús li ix'ukxjalhtanaj'antachalhcha an lakxkan chi waniycha ixla'antachalh an barco, pus tatalhamnilh. ");
INSERT INTO tpp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero yucha jajunilh: ―¡Mu kit'in, jant'u k'alakt'alhanant'it! ");
INSERT INTO tpp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Pus wa chuncha yu'uncha ixtalaj'achancha akxni jala'cha'alh an laka barco, chi an barco cha'alhcha an tan ixtita'an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tunkunchalh, an lapanakni yu ixtawilananchalh an ixtapiktutam lakxkan, talhakapu'alhi li an Jesús jantu jat'a'alhi an ixt'alhtanan an laka barco, tak'atsaalhi li wa ix'akstuk'ani ta'alh chi mu wa la'ata'mi barco ancha ixwilh. ");
INSERT INTO tpp_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero ali barco yu ixtamintachalh la'acha'an Tiberias, ixtacha'anta waniy an tan ixtalak'uta pan, akxni ixta'ojotacha lhimala'puchajun an jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pus akxni an lapanakni tala'ts'ilhi li an Jesús jantu tu'u ancha ixt'ajun, chi an ixt'alhtanan, talaktajulhi an laka lakbarco ta'alhcha puxkawnini la'acha'an Capernaúm an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Akxni tacha'alhcha an ixtapiktutam lakxkan ancha tala'cha'alh, pus tajuniy: ―Maestro, ¿t'asu wananch'a ch'it'a ani? ");
INSERT INTO tpp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","An Jesús ja'alhtaylh jajuniy: ―Ijk'atsaycha, xliyu kilalhipuxkawyaw mu oxi o'ats'at'it akxni an lakwa'int'it, jantu xliyu kilalhipuxkawyaw li wa lhimach'a'xat'itcha an t'ach'a la'ts'int'it. ");
INSERT INTO tpp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Jant'u k'alhit'ap'ats'at'iti an wayt yu wa lakp'uch'iy u wa min'ojoy. Yucha an yu jantu min'ojoyi k'alhit'ap'ats'at'it, yu xt'a'a jatsukunti yu jantu min'ojoy, yu iklaxta'niyaw kit'in yu ikwalh isTs'alh Lapanak, mu an Dios, an kimPay yucha kisakxtulh. ");
INSERT INTO tpp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wa chuncha tajuniy: ―¿Tisuncha ak'ilhtuw para li ak'ilhtuwcha an tapatsat yu tacha lhi'achaniy an Diosi? ");
INSERT INTO tpp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","An Jesús ja'alhtaylh jajuniy: ―An tapatsat yu an Dios lakask'in, yucha li k'ak'iklak'a'it'iti an yu mala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Pus tajuniy: ―¿Pus tisuncha akilamasuniyaw para li akla'ts'iwcha chi aklakiklaka'iwcha? ¿Tisuncha tapatsati ilht'uyi? ");
INSERT INTO tpp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","An kilakpaynink'an ixtajunita ta'ulhi an pan yu patajulh lakt'iyan an tan wa lakaxixnicha lakaat'un, tacha ts'o'muk'akanta tan najunta: “Jamawalh xapan lakt'iyan.” ");
INSERT INTO tpp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pus an Jesús jajuniy: ―Ani klajunaw sawalh, jantu yu an Moisesi yu taxta'nin an xapan lakt'iyan, yucha an kimPayi yu taxta'niyan an yu xapan sawalh lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mu an ixpan an Dios yucha an yu minchalh talhman chi xta'niya jatsukunti an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yu'uncha tajuniy: ―Jamach'alhkat Jesús, lhilhiji akilaxta'niw yu yucha pan. ");
INSERT INTO tpp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","An Jesús jajuniy: ―Kit'ini ikpan yu xt'a'a jatsukunti. Yu akint'amina jantu a'tam katichawanalh, chi yu kinkiklaka'iy jantu a'tam katikikxixli. ");
INSERT INTO tpp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero tacha iklajuniwcha, masi kilala'ts'inawcha jant'u jak'iklak'a'ininat. ");
INSERT INTO tpp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ixchuxk'an yu kijaxta'niy an kimPay, akintala'mina', chi yu kintala'min jantu aktijasastuklhi. ");
INSERT INTO tpp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Mu kit'in ikminchalh an lakt'iyan para li ak'ilhtulhi yu tacha lhi'achaniy an kimPay yu kimakmintachalh, jantu yu kit'in iknajun. ");
INSERT INTO tpp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","An kimPay yu kimakminchalh lakask'in li jantu k'is tu'u akma'ats'an'alh yu yucha kijaxta'niy, yucha lakask'in li ajkamala'awnilhi akxni xati'astancha wilhchan kajuna'. ");
INSERT INTO tpp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chunchuniya lakask'in an kimPay, li ixchuxk'an an yu tala'ts'in an isTs'alh Dios chi takiklaka'iy, katalhitsukulhi jatsukunti yu jantu min'ojoy. Chi kit'in ajkamala'awnicho'oya akxni xati'astancha wilhchan kajuna'. ");
INSERT INTO tpp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","An judiojnin tsukulhcha talhichiwiniy, xliyu najun: “Kit'in ikpan yu ta'alhtajulh lakt'iyan”, ");
INSERT INTO tpp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","chi ixtalaknawpalay: ―Ani, ¿chun jantu yu an Jesús an ists'alh José? Jamispayawi ixpay chi ixnati. Chi chaway najun li lakt'iyani minchalh. ");
INSERT INTO tpp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","An Jesús ja'alhtaylh jajuniy: ―Jant'uch'a ali k'alakna'unt'iti tu'u wa siya uxitnancha. ");
INSERT INTO tpp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jantu xamati lay akintich'a'o'alh li an kimPay yu kimakmintalh jantu kilhiminiy, para li lay akmala'awnicho'olh akxni xati'astancha wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","An la ixlibrojk'an yu ixtalhichiwiniy ixchiwinti Dios najunta: “Yucha an Diosi kajamalaklani'oya ixchuxk'an.” Pus ixchuxk'an yu ta'asmatniya an kimPay chi talaklaniya yu jamasuniy, akintach'a'o'aya'. ");
INSERT INTO tpp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Chi jantu nawputun li sna xamaticha la'ts'ilh an kimPay, wa kit'ini yu ikla'ts'intacha, mu ancha ikminchalh tan wilhchalh. ");
INSERT INTO tpp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ani sawalhi an yu iklajunaw, yu kinkiklaka'iy lhit'ajuni jatsukunti yu jantu min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kit'in ikpan yu xt'a'a jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Amilakpaynink'an ixtajunita ta'ulhi an xapan lakt'iyan an lakaxixni lakaat'un, walh chi lanani tanilh. ");
INSERT INTO tpp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero kit'in iklhichiwiniy pan yu lakt'iyan minachalh, yu yucha uy, jantu katinilh. ");
INSERT INTO tpp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Kit'ini an pan yu la'ajunta yu lakt'iyan mintachalh. Yu yucha uy ani pan, katsuku'alhiya'. An pan yu kit'in akxt'a'a, yucha an kilakatunaj. Aklhima'axt'a'a ixlakata tacha an t'aw'ok'an ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Wa chuncha an judiojnin tsukulhcha talhilakchiwiniy, talajuniy: ―¿Tasicha akintalhimawayan ixlakatunaj aniya? ");
INSERT INTO tpp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","An Jesús jajuniy: ―Chun sawalhi ani yu klajunaw, li jant'u k'at'i'ut'iti an ixjakanit an isTs'alh Lapanak ch'i jant'u k'at'i'ott'iti an ixjak'alhni, jant'u k'at'ilhits'uk'ut'iti an jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yu ka'uya an kijakanit chi ka'ot'a an kijak'alhni katsuku'alhiya', akmala'awnicho'oya akxni xati'astancha wilhchan kajuna'. ");
INSERT INTO tpp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Mu an kijakanit yucha yu wayt sawalh, chi an kijak'alhni yucha yu lhi'ot'at sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yu uyi an kijakanit chi ot'a an kijak'alhni akimputsuku'alhiya chi akputsuku'alhiya'. ");
INSERT INTO tpp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tacha an kimakmilhi an yu lhit'ajun jatsukunti kimPay, chi yucha ikput'ajun, wanajcha chuni yu aki'uya akimputsukuya'. ");
INSERT INTO tpp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yu iklhichiwiniy yucha an pan yu minchalh an lakt'iyan. Ani pan jantu tacha an yu talak'ulh amilakpaynink'an ixtajunita, an tan wa jaxixnintacha lakaat'un, yu'uncha masi ta'ulh talaknilh. Yu ka'uya an pan yu iklalhixa'alayaw kit'in, yucha katsuku'alhiya'. ");
INSERT INTO tpp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Chuncha nawlh an Jesús akxni ixmasut'ajun laka tajtan an la'acha'an Capernaúm. ");
INSERT INTO tpp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Akxni chunchacha ta'alha'asmatlhi, ixluwk'an an ixt'alhtanan tanajun: ―Tacha ani najun lhima'anxkay, ¿tisiyuchacha lay kakiklaka'iya'a? ");
INSERT INTO tpp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","An Jesús lhakapu'alhi li an ixt'alhtanan wa ixtalhichiwiniya tacha an jajunilh, pus jajuniy: ―¿Jant'u oxi lhiwilayat? ");
INSERT INTO tpp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Li k'a'ixla'ts'int'iti an isTs'alh Lapanak ka'ixtach'ixcho'olh tan p'ulhnaj ixwilhchalh, t'asu k'a'ixna'unt'itcha? ");
INSERT INTO tpp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","An takuwin yucha yu xt'a'a jatsukunti, an lakatunaj yucha yu jantu tu'u lhitapalay. An chiwinti an yu iklalhixa'alayaw yucha takuwin chi jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Chi ta'alinka yu uxitnan yu jantuka' tajakiklaka'inin. Mu an Jesús yucha ixk'atsaycha ixlip'ulhnaj ixjuntachalh, tichini yu'unchacha yu jantu tajakiklaka'inin, chi tichini yuchacha yu kama'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Chi nawpalay: ―Xliyu iklalhijunaw li jantu xamati lay akintila'milh li jantu yu an kimPay makawniy. ");
INSERT INTO tpp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Wa chuncha, ixluwk'an an yu wachucha ixtat'alhtanan an Jesús tamakawlhcha, jantucha ixtach'a'o'ay. ");
INSERT INTO tpp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pus an ixpumakawt'uyk'an ixt'alhtanan jajuniy an Jesús: ―¿Uxitnan wach'uch'a k'uxap'inat'it? ");
INSERT INTO tpp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","An Simón Pedro alhtaylh: ―Jamach'alhkat Jesús, ¿tisiyuchacha akch'a'o'ayawi? Aminchiwinti yucha yu xt'a'a jatsukunti yu jantu a'tam min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Chi kitnan ijkiklaka'itawcha, chi ijk'atsayawcha li uxint'i Cristo, isTs'alh Dios yu la'ajunta. ");
INSERT INTO tpp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","An Jesús alhtaylh juniy: ―¿Jantu kit'ini iklasakxtutaw amimpumakawt'uyk'an? Walh chi xapumatam yu uxitnan yucha xapay makxkay'un. ");
INSERT INTO tpp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","An Jesús yucha an Judas Iscarioteje ixlichiwint'ajun, ists'alh tichi Simón, mu yucha yu kama'axt'a'a', masi yucha yu ixlipumakawt'uychak'an ixtajunita an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ixli'astan an Jesús, xalakaat'un Galileajcha ixt'awnachalh, mu jantu ixtawlhputuni xalakaat'un Judea, wa xliyu an judiojnin wa ixtama'niputun. ");
INSERT INTO tpp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Pero mu waniycha ixminta ixk'atank'an an judiojnin akxni ixtala'la'oxiy ixmulht'a'ak'an yu wa jach'itin, ");
INSERT INTO tpp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","pus an ixjat'ala'awnin an Jesús tajuniy: ―K'at'axt'ucha ani, k'ap'inchicha xalakaat'un Judea, para li wachucha katala'tsilhi amint'alhtanan an t'ach'a lak'ilht'uy tanlhun laj'oxi tapatsat. ");
INSERT INTO tpp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mu jantu xamati lapanaki li yu lakask'in li kamispakalh, tan wa la'asa'nik'acha kalak'ilhtulh tu'u'. Li lak'ilht'uycha ani tanlhun, k'alak'ilht'ucha tan ixlitalakasun. ");
INSERT INTO tpp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Masi ixjat'ala'awnin jantu ixtakiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pus an Jesús jajuniy: ―Kit'in jantuka' chini kimpanch'e'ex, pero uxitnan mimpanch'e'exk'an lhilhiji alin. ");
INSERT INTO tpp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Uxitnan jantu lay taxkayani an lapanakni, pero kit'in kintaxkajiy, mu kit'in ixla'ts'awalanti iknajun li an yu ta'ilhtuy jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","K'ap'inchi'itcha uxitnani laka k'atan, kit'in jantuka' akti'alh, mu jantuka' chini kimpanch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Chuncha jajunilh, chi yucha an xalakaat'un Galileajcha tamakawlh. ");
INSERT INTO tpp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero ixli'astan akxni ta'alhcha an ixjat'ala'awnin, wachucha alhi an laka k'atan, wa la'asa', jantu xamati mak'atsaanilh. ");
INSERT INTO tpp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","An judiojnin ixtapuxkajuycha an laka k'atan, chi ixtanajun: ―¿Tanischa t'ajun anchunu lapanaki? ");
INSERT INTO tpp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","An lapanakni sawalhcha ixtalhichiwiniya an Jesús. Ali'in ixtanajun: “Yucha oxi lapanak.” Pero ali'in ixtanajun: “Jantu, wa ja'o'xcho'oycha an lapanakni.” ");
INSERT INTO tpp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero masi chunchacha, jantu xamati ts'awj ixlichiwiniy an Jesús, mu ixjatalhamnikani an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ixpaytatcha an k'atan, an Jesús tanulhcha an laka tajtan chi tsukulhcha jamasuniy. ");
INSERT INTO tpp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","An judiojnin ixtalhi'a'niycha, ixtanajun: ―¿Tasicha sawalhcha lhilajk'atsay li jantu tu'u jatalanininta? ");
INSERT INTO tpp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","An Jesús ja'alhtaylh: ―An tacha ikmasuy jantu kinawin, ixnawin an yu kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Yu ilhtuputuni tacha an lhi'achaniy Dios, kak'atsayacha li an tacha ikmasuy Diosi kilhijuniy u wa kit'incha iknajun. ");
INSERT INTO tpp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yu wa ix'akstucha lhichiwinkan, wa ix'akstucha puxkajuy yu sawalhcha kapulhiwilakalh. Pero yu yucha lhichiwiniy ixchiwinti an yu mala'achatachalh, yucha xasawalh, chi jantu tu'u yu jantucha oxi ka'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Pero yucha an Moisesi taxta'nin an lhamap'a'sin, walh ch'i jant'u k'iklak'a'iyat. ¿Tasu li kilama'niputunawcha? ");
INSERT INTO tpp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","An lapanakni ta'alhtaylh, tajuniy: ―Wa lakpach'apayan makxkay'un, ¿tisiyuchacha ma'niputunani? ");
INSERT INTO tpp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","An Jesús ja'alhtaylh, jajuniy: ―Sawalhch'a lhi'a'niyat'iti masi wa la'atamcha tu'u ikmasulh akxni jantu tapatsakan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero an Moisés tajunini li k'ala'ak'axwililich'uk'up'uxt'iti mi'a'axt'a'ak'an, pero jantu yu tukani lhinajun, yu'uncha an yu t'a ixjalhila'ts'inat'it. Chi masi akxni jantu tapatsakan wilhchan, ak'axwililich'uk'up'uxat'iti xamati lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Li an lapanak akaxwililich'uk'up'uxkani ix'a'axt'a'a akxni jantu tapatsakan wilhchan para li an ixlamap'a'sin Moisés jantu kats'an'alh, ¿tasu li lhit'alh'amnatcha li wanaj ijk'uch'u'ojoyi kit'in ta ixlila'a'ay an lapanaki? ");
INSERT INTO tpp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jant'u k'alhich'iwinint'iti xamati wa xliyu t'ani la'ts'inatcha, akxni t'u'u nawnat, k'ana'unt'it yu ixla'ts'awalanti. ");
INSERT INTO tpp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pus wa chuncha ali'in jamacha'an Jerusalén ixtalaknajun: ―¿Jantu yucha ani lapanaki yu tapuxkajuy li tama'niputun? ");
INSERT INTO tpp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chi aniya t'ajun, ixlitalakasuni chiwiniy chi jantu tu'u tajuniy. ¿Xliyu sna li takiklaka'ilhcha an jamach'alhkatni li yucha Cristo sawalh? ");
INSERT INTO tpp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero mu kitnan k'atsayawi tanchuncha mintachalh ani, pero akxni kamina an Cristo, jantu xamati katik'atsaalh tanchuncha kaminanta. ");
INSERT INTO tpp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pus wa chuncha an Jesús ja'alha'asmatlhicha, mu ixmasut'ajun an laka tajtan, pus p'ascha jajuniy: ―¡Pus kakilamispayaw ch'i k'ak'ats'ayat'it'i tanchuncha ikmintachalh! Pero kit'in jantu wa kijatalapututcha li ikminta, yu kimakmintachalh yucha yu sawalh, uxitnan jant'u misp'ayat. ");
INSERT INTO tpp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kit'in ikmispay, mu yucha ikpula'awlh, chi yucha kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pus wa chuncha ixtach'apayawputuncha, pero jantu xamati maktapujulh, mu jantuka' ixcha'ani ixpanch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ixluwk'ani takiklaka'ilh an Jesús chi ixtanajun: ―Akxni kamina an Cristo, ¿chu sna palay kalak'ilhtuya tanlhun yucha? ");
INSERT INTO tpp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","An fariseojnin ta'alha'asmatlhi an lapanakni li chunchacha ixtalhichiwiniy an Jesús. Pus an xalaj'ajin sacerdotejnin chi an fariseojnin tamala'achalhi lapanakni para li katach'apayawlh. ");
INSERT INTO tpp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","An Jesús najun: ―Wa lakats'uniycha panch'e'exi aklat'a'aklatsukuyaw, chi ixli'astan akla'ancho'oyacha an yu kimakmintachalh. ");
INSERT INTO tpp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Akilapuxkawyaw, pero jantu akintilala'cha'aw chi tan ikti'an jant'u lay k'at'ip'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wa chuncha an judiojnin ixtalajuniy: ―¿Tanischa ka'ana ani li jantucha lay katila'cha'awi? ¿Kajala'anacha sna an yu ta'a'pitsinin jamacha'an Grecia chi yu'unchacha kajamasuniya'? ");
INSERT INTO tpp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tasicha nawputun li najuncha li: “Akilapuxkawyaw, pero jantu akintilala'cha'aw, mu tan ak'ana uxitnan jant'u lay k'at'ip'it'iti'”? ");
INSERT INTO tpp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Akxni wa x'amancha wilhchan an laka k'atan, mu yucha yu palaycha ixlitapalay, an Jesús tayalhcha chi p'ascha najun: ―Li xamati kikxixa, akila'milhcha, chi ka'ot'a' xkan. ");
INSERT INTO tpp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tacha an najunta an tan ts'o'muk'akanta ixchiwinti Dios, li yu kinkiklaka'iy, tachanu ma'alhuw ayxkani la ixpulakni kapujats'alaya xkan yu la'ajunta. ");
INSERT INTO tpp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","An Jesús nawputun li yu katakiklaka'iya, katala'a'iya an ixTakuwin Dios, mu akxni an ixTakuwin Dios jantuka' ixmakminkan. ");
INSERT INTO tpp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wa chuncha an ali'in tacha an lhilhuw ixlakyakalh, akxni chunchacha ta'alha'asmatlhi, ixtanajun: ―Ani yucha ixchiwinti Dios sawalhi lhichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ali'in ixtanajun: ―Ani yucha an Cristo. Pero ali'in ixtanajun: ―Jantu, an Cristo jantu xalakaat'un Galileaja katiminchalh. ");
INSERT INTO tpp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","An tan ts'o'muk'akanta najunta li an Cristo yucha an rey Daviti kapu'a'p'unminanta, yucha jamacha'a Beléni ixjunita, ancha kaminanta an Cristo. ");
INSERT INTO tpp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pus an lapanakni ixlakata an Jesús tatala'apitsilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","An ali'in lapanakni ixtach'apayawputuncha an Jesús, pero jantu xamati ch'apayawlh. ");
INSERT INTO tpp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","An yu ixtajalhistaknan an laka tajtan ta'ancho'olhcha an tan ixtat'awnachalh an fariseojnin chi an xalaj'ajin sacerdotejnin, walh akxni tacha'alhcha jalhisakmikancha tuchini jantucha talhilhi'alh. ");
INSERT INTO tpp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yu'uncha taja'alhtayanalh: ―¡Jantu a'tam chuncha xamati lapanak kachiwinilh! ");
INSERT INTO tpp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Pus an fariseojnin tat'alajuniy: ―¿Uxitnan wach'uch'a o'xch'o'ok'ant'it? ");
INSERT INTO tpp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Chu sna xamati kiklaka'iy an kijefejnink'an u an fariseojnin? ");
INSERT INTO tpp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","An lapanakni an yu takiklaka'iy wa jantu tak'atsay an lhamap'a'sin, jantu oxi tacha an talay. ");
INSERT INTO tpp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","An Nicodemo, pumatam fariseo yu ixkila'pixiyalhnanta an Jesús la'atam jatats'isni, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―An la kilhamap'a'sink'an tasuyi li jantu layi katima'niw xamati lapanak li jantu alha'asmat'awi yu najun, para li kak'atsawi tuchini yu ilhtutacha. ");
INSERT INTO tpp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yu'uncha tajuniy: ―¿Chu wachu jamacha'a Galileajk'at'i? K'ap'unawi an tan ts'o'muk'akanta para li k'ak'ats'at'i li Galilea jantu a'tami ancha katiminchalh yu kalhichiwinina ixchiwinti Dios.  ");
INSERT INTO tpp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Chi atamj atamjcha ancho'olh la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero an Jesús alhcha an a'stitawk'a tan junkan Laka Olivojnin. ");
INSERT INTO tpp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Wats'isin chincho'olhcha an laka tajtan, pus ta lhichux tacha an wilakalh an la'achan tala'cha'alhcha, chi yucha tawilhcha, tsukulhcha jamasuniy. ");
INSERT INTO tpp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wa chuncha an xamaestrojnin lhamap'a'sin chi an fariseojnin talhicha'anilh pumatam t'aku', yu ta'a'taymalh tan ixa'alat'ajun yu jantu yu ixt'apapa', ixtan'ajnicha tayawlh an tan lhilhuw ixlakyakalh, ");
INSERT INTO tpp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","chi tajuniy an Jesús: ―Maestro, ani t'aku a'taymakalh tan ixa'alat'ajun lapanak, ");
INSERT INTO tpp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","chi an la ixlamap'a'sin Moisés kintajunan li yu chuncha lay t'aku aklakat'alhmayaw sta kaniya'. ¿Uxint'i t'asich'a na'uni? ");
INSERT INTO tpp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Chunchacha ixtajuniy wa ixtalhila'ts'intanuycha, para li ka'alilhcha yu katapu'alhtasulh. Pero an Jesús ix'antawilh chi ixjats'o'nuncha la ixmaka an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Walh ali ixtalhisakmiy, pus tats'awalatawilh chi jajuniy: ―Yu jantu tu'u ixtala'alhin yuchacha p'ulhnaj kamakat'alh'anilh. ");
INSERT INTO tpp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chi a'tam ta'antatawlhpalh, tsukunipalh jats'o'nuni an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pus an lapanakni mu ta'alha'asmatlhicha tacha an jajunilh an Jesús, tapastaklhi li wachu talhit'ajuni ixtala'alhink'an, pus talak'ancho'olhcha. P'ulhnajcha yucha an yu laktatanincha talak'alh, chi ixli'astan yucha an yu palayka lakts'alanin. Xli'astan wa yucha an t'akucha chi an Jesuscha tatamakawlh. ");
INSERT INTO tpp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pus tats'awalatawilhcha an Jesús chi mu jantucha xamati la'ts'in wa yucha an t'akucha, pus juniy: ―¿Tanischa tat'ajun yu ixta'alhtasuyani? ¿Jantu xamati lakat'alhman? ");
INSERT INTO tpp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","An t'aku alhtaylh: ―Jantu, jantu xamati kilakat'alhmalh. Wa chuncha an Jesús juniy: ―Kit'in wachu jantu aktilakat'alhman, k'ap'inch'o'ochicha pero jant'uch'a ali k'a'ilht'u mintala'alhin. ");
INSERT INTO tpp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","An Jesús a'tam jaxa'alapalhi an lapanakni, jajuniy: ―Kit'ini xajatapulhkunu an lakamunulhpa', yu akinch'a'o'aya jantu wa lakaputs'isni katitsukulh, kalhitsukuya an jatapulhkunu yu xt'a'a jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wa chuncha an fariseojnin tajuniy: ―Uxint'i wa mi'akst'uch'a lhich'iwink'an, aminchiwinti jantu lhitapalay. ");
INSERT INTO tpp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","An Jesús jajuniy: ―Masi wa ki'akstucha iklhichiwinkan, an kinchiwinti lhitapalay, mu ijk'atsayi tanchuncha ikmintachalh chi tanchuncha ikti'an. Pero uxitnan jant'u k'ats'ayat tanchuncha ikmintachalh chi tanchuncha ikti'an. ");
INSERT INTO tpp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Uxitnan ch'unch'ach'a lhich'iwinat t'anisch'a la'ts'inat lay an lapanak, pero kit'in jantu xamati iklhichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Chi li iknajuni tani laycha xamati, an yu iknajun yucha sawalh, mu jantu wa ki'akstucha iknajun, ali an kimPay yu kimakmintachalhi iknawnaw. ");
INSERT INTO tpp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","An la milhamap'a'sink'an ts'o'muk'akanta li akxni ixt'uyunk'an yu tala'ts'ilh tu'u wa tami tanajun, an ixchiwintik'an lhitapalay. ");
INSERT INTO tpp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kit'in iklhichiwinkani wa ki'akstucha, pero an kimPay yu kimakmintachalh wachu kilhichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yu'uncha tajuniy: ―¿Tanischa t'ajun mimpayi? An Jesús jajuniy: ―Uxitnan jantu kilamispayaw chi an kimPay wach'u jant'u misp'ayat. Li xakilamispaw, an kimPay wach'u k'a'ixmisp'at'it. ");
INSERT INTO tpp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","An Jesús chuncha nawlh akxni ixmasut'ajun an laka tajtan, tan ixlakwilh yu pumujukan tumin yu ixla'ulanankan, chi jantu xamati ch'apayawlh mu jantuka' ixcha'ani ixpanch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A'tam jajumpalhi an Jesús: ―Kit'in ikti'ancha, chi uxitnan akilapuxkawyaw, pero uxitnan la mintala'alhink'ani k'alakniya'it. Tan ikti'an kit'in, uxitnan jant'u lay k'at'ip'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Pus an judiojnin ixtanajun: ―¿Tasu li chunchacha najuni li tan ti'an kitnan jantu lay kati'awi? ¿Sna wa ka'akstuma'nikanacha? ");
INSERT INTO tpp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","An Jesús jajuniy: ―Uxitnan ani talaktsini mincha'ak'an, pero kit'in awint'i talhman. Uxitnan ani lakamunulhpa k'at'amak'awna'it, pero kit'in jantu ikde ani. ");
INSERT INTO tpp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Xliyu iklalhijunaw li la mintala'alhink'ani k'alakniya'it'it, mu li jantu kilakiklaka'iyawi li kit'in, la mintala'alhink'ani k'alakniya'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wa chuncha tajuniy: ―¿Tisu uxint'ichak'at'i? An Jesús jajuniy: ―Yu p'ulhnajcha iklajuntaw. ");
INSERT INTO tpp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wanaj lhuwi yu aknawna chi yu aklajunaw t'ani layatcha, pero an yu kimakmintachalh yucha sawalhi an yu najun, chi kit'in, wanajcha yu iklajunaw ani lakamunulhpa an yu ik'alha'asmat'a an yu kimakminta. ");
INSERT INTO tpp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero yu'uncha jantu talhimacha'xalhi li yucha an ixPayi ixjalhixa'alat'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pus an Jesús jajuniy: ―Akxni talhmancha k'amuk'aya'it an yu isTs'alh Lapanak kijunchilh, akxnich'a k'ak'ats'aya'it li kit'in, chi li jantu tu'u ik'ilhtuy yu wa kit'incha iknajun, kit'in ikchiwiniy tacha kimasuniy an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mu an yu kimakminta aniya kint'a'aklat'ajun, jantu wa ki'akstucha kimakajunta an kimPay, mu kit'in lhilhiji ik'ilhtuy yu oxi lhiwilay. ");
INSERT INTO tpp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Akxni chunchacha naw'olh an Jesús, ixluwk'ani takiklaka'ilh. ");
INSERT INTO tpp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","An Jesús jajunilh an judiojnin an yu ixtakiklaka'itacha: ―Li k'iklak'a'iyat sawalhi an kinchiwinti, kint'alhtanan sawalhi k'a'una'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","K'amisp'aya'it'iti an yu sawalh, chi an yu sawalh katama'alhtaxtuniyan chi k'amak'awk'ana'it'itcha. ");
INSERT INTO tpp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yu'uncha ta'alhtaylh: ―Kitnan yucha an Abrami ikpu'a'p'unmintacha'aw, chi jantu a'tam xamati la ixmaka akintalhitsukun, ¿t'asu li na'uncha li akmakawkanawcha? ");
INSERT INTO tpp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","An Jesús jajuniy: ―Sawalhi an yu iklajunaw, wa tichicha yu ilhtuy tala'alhin, la ixmaka an tala'alhini t'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Chi an yu wa putapatsakancha lapanak, jantu ma'tawlh'alhiya an laka cha'a tan putapatsakan, pero yu ancha xajas'at'a yucha tawlh'alhiy. ");
INSERT INTO tpp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Xliyu li an yu isTs'alh Lapanak kijunchilh ta'ilhtuyancha li k'amak'awk'ant'itcha, uxitnan k'amak'awk'ana'itcha sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ijk'atsaycha li yucha an Abrami p'u'a'p'unt'anchi'it pero kilama'niputunaw, mu jantu kilakiklaka'iyawi an kinchiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kit'in iklhichiwiniy yu an kimPay kimasunita, ch'unch'ach'a wach'u ilht'uyat yu alha'asmat'at mimpayk'an. ");
INSERT INTO tpp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yu'uncha ta'alhtaylh tajuniy: ―¡Kitnan kimpayk'an yucha an Abram! Pero an Jesús jajuniy: ―Li ixjas'at'an Abram sawalhi uxitnan, k'a'ix'ilht'ut'iti tacha an ilhtulh yucha. ");
INSERT INTO tpp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero chaway uxitnan kilama'niputunawi li iklalhixa'alayaw yu sawalh, yu ik'alha'asmatta an Dios. An Abram jantu a'tam chuncha lalh. ");
INSERT INTO tpp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Uxitnan wanajch'a ch'uni layat tacha lay mimpayk'an. Yu'uncha tajuniy: ―¡Kitnan jantu wa a'chunancha! ¡Wa pumatami kimPayk'an, Dios! ");
INSERT INTO tpp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wa chuncha an Jesús jajuniy: ―Li mimPayk'ani Dios ixwalh, xakilamapayniw, mu kit'in tan wilhchalh Diosi ikminchalh chi anicha ikt'ajun, jantu wa ki'akstucha ijk'uxamilh, Diosi kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tasucha li jantu lay kilalhimacha'xaniyaw an kinchiwinti? Wa xliyu jantu kila'asmatniputunaw. ");
INSERT INTO tpp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Uxitnan mimpayk'an yucha an xapay makxkay'un, ch'i yuch'ach'a ach'aniyat ilht'unip'ut'unat yu lhinajun. Yucha sta akxni ilhtukanchalh an lakamunulhpa, sta akxnicha jama'ninilh, chi jantu a'tam najunta yu sawalh, mu jantu tu'u yu sawalh kanawlh yucha. Akxni maslakatinin, najuncha tanischa yucha, mu yucha maslakatini', chi xapay maslakatinti. ");
INSERT INTO tpp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero kit'in, mu iknajun yu sawalh, jantu kilakiklaka'iyaw. ");
INSERT INTO tpp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Uxitnan, ¿tisiyuchacha lay kanawna li iklhit'ajun tu'u tala'alhini? Chi li iknajun yu sawalh, ¿tasu li jantu kilakiklaka'iyawi? ");
INSERT INTO tpp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yu ixjas'at'a Dios, an ixchiwinti Dios asmat'a pero uxitnan jant'u asmat'at'iti mu jantu ixjas'at'an Dios. ");
INSERT INTO tpp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","An judiojnin tajuniy an Jesús: ―Sawalhcha tacha an iknawnaw li jamacha'ak'at'i Samaria chi li makxkay'uni lakpach'apatan. ");
INSERT INTO tpp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","An Jesús jajuniy: ―Kit'in jantu tu'u kilakpach'apata makxkay'un. Kit'in ijkiklaka'iy an kimPay, yucha yu ik'ilhtuy, pero uxitnan wa kilamamaxaniyaw. ");
INSERT INTO tpp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Kit'in jantu kit'ini yu ikpuxkajuy kinta'ayaxtu, alini yu yucha puxkajuy, chi yucha yu kanawna li oxi u jantu yu ilhtuy atam. ");
INSERT INTO tpp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Sawalhi ani yu iklajunaw, yu kiklaka'iya an kinchiwinti, jantu a'tam katinilh. ");
INSERT INTO tpp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","An judiojnin tajuniy: ―Chaway oxicha ijk'atsaw li wa lakpach'apatan makxkay'un sawalh. An Abraham chi an ali'in yu ixtalhichiwiniy ixchiwinti Dios talaknilh, chi uxint'i na'un: “Yu kinkiklaka'iy jantu a'tam katinilh.” ");
INSERT INTO tpp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Chu sna palay ayk'at'i, palay wa lakat'ikt'i an kimpayk'an Abraham? Yucha nilh, chi an yu ixtalhichiwiniy ixchiwinti Dios wachu talaknilh. ¿Tisu milhijunt'ich'a na'uni? ");
INSERT INTO tpp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","An Jesús jajuniy: ―Li wa kit'incha ikla'ayakan, an kinta'ayat jantu tu'u lhitapalay. Pero yu kila'ayay yucha an kimPay, an yu unat li miDiosk'an. ");
INSERT INTO tpp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero uxitnan jant'u misp'ayat. Kit'in ikmispay, chi li aknawlh li jantu ikmispay, wa ikmaslakatinincha tacha uxitnan. Kit'in ikmispay sawalh, chi ijkiklaka'iya tacha an najun. ");
INSERT INTO tpp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","An Abraham, yu p'u'a'p'unt'anchi'it lhi'achalhi li kala'ts'ina kiwilhchan, chi la'ts'ilh, pus achalhcha. ");
INSERT INTO tpp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wa chuncha tajuniy an judiojnin: ―Jant'uk'a' lhit'a'uni t'up'uxamkaw (50) k'ata, ch'i na'un li la'ts'int'acha an Abram. ");
INSERT INTO tpp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","An Jesús jajuniy: ―Sawalhi ani yu iklajunaw, akxni jantuka' istsukuy an Abraham, kit'in xakt'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Pus wa chuncha talaksaklhicha chiwx ixtalakat'alhmaputuncha. Pero an Jesús tats'e'lhi chi taxtulhcha an laka tajtan chi japujataxtu'olh, alhcha. ");
INSERT INTO tpp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tan ixla'pust'ajun an Jesús, la'ts'ilh pumatam la'lhtuluw lapanak, wa chunchacha tsukulh. ");
INSERT INTO tpp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","An ixt'alhtanan tajuniy: ―Maestro, ¿tisiyuchacha ilhtulh ixtala'alhin li chunchacha la'awlhi, ixpaynin u yucha? ");
INSERT INTO tpp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","An Jesús jajuniy: ―Jantu xliyu ani wa ka'ilhtulhcha tu'u ixtala'alhin u an ixpaynin, wa xliyu an Dios masuputuni ixtapatsat la ixlakatunaj ani lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Li tunkuwka, task'iniya li ka'ilhtuw an ixtapatsat an yu kimakminta, mu mintacha an jatats'isni, akxni jantucha lay tapatsakan. ");
INSERT INTO tpp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Li ikt'ajunka an lakamunulhpa, ikxajatapulhkunu an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Akxni chunchacha naw'olh, a'chujlhicha an lakaat'un, chi ilhtulhcha pulh'om. Lakpuxapamuk'alhcha an la ixla'chulh an yu jantu ixjalakawanan lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ixli'astan juniy: ―K'ap'inchicha la'puch'a'a an tan nap'an wilh xkan junkan Siloé ―nawputun Mala'achakanta. Pus alhcha la'puch'a'a', walh tasp'itcho'ochalh, ixjalakawanancha. ");
INSERT INTO tpp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","An yu waniy ixjalakt'awilh la ixcha'a chi an yu ixtala'ts'in tan ixtawlay isk'in tu'u la'a'tayjun, ixtanajun: ―¿Ani chu jantu yu an sa' ixtawlay isk'in la'a'tayjun? ");
INSERT INTO tpp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ali'in ixtanajun: ―Mu chun, yucha. Ali'in ixtanajun: ―Mu jantu, masi wanaj chuncha tasuy jantu yu'. Pero yucha ixnajun: ―Chun, kit'in. ");
INSERT INTO tpp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wa chuncha talhisakmilh tajuniy: ―¿Ch'i t'asich'a laych'a lhijalak'awanan chawayi? ");
INSERT INTO tpp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yucha jajunilh: ―Yucha anchunu tajuniy li Jesusi ilhtulh pulh'om, chi kilakpuxapamuk'alhcha, ixli'astan kijuniy: “K'ak'ila'p'uch'a'acha an laka Siloé, tan nap'an tajun xkan.” Pus ik'alhcha, chi ikla'puch'a'alhcha, walh ijkalakawanalhcha. ");
INSERT INTO tpp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pus tajuniy: ―¿Tanischa t'ajun anchunu lapanaki? Yucha jajuniy: ―Jantu ijk'atsay. ");
INSERT INTO tpp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Talhi'alhcha an tan ixtawilanalh an fariseojnin an yu la'lhtuluw ixjunita lapanak. ");
INSERT INTO tpp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Akxni la'oxilh an pulh'om an Jesús chi malakawanilhcha an yu jantu lay ixjalakawanan akxni jantu ixtapatsakan wilhchani ixjunita. ");
INSERT INTO tpp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","An fariseojnin wachu talhisakmipalhi tani laycha lhijalakawanalh. Pus yucha jajuniy: ―Wa kilakpuxapamuk'alhcha an pulh'om, chi ikla'puch'a'alhcha chi chaway ijkalakawanancha. ");
INSERT INTO tpp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pus an ali'in fariseojnin ixtanajun: ―Anchunu lapanak jantu Diosi makminta, mu tapatsayi akxni masi jantu tapatsakan wilhchan. Pero ali'in ixtanajun: ―¿Pero tasicha lay kalhilak'ilhtulh ani tanlhun li wa ma'lhta'alhiniycha? Pus tatala'apitsilhcha, tatakilhmakt'uyulhcha. ");
INSERT INTO tpp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wa chuncha talhisakmipalh a'tami an yu la'lhtuluw ixjunita lapanak, tajuniy: ―An yu malakawanin, ¿tisu lapanakch'a na'uni? Yucha najun: ―Kit'in iknajun pumatam yu lhichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero an judiojnin jantu ixtakiklaka'iya li la'lhtuluwi ixjunita chi li laycha ixjalakawanan, wanaj tat'asanilh ixpay chi ixnati ");
INSERT INTO tpp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","chi talhisakmilhcha, tajuniy: ―¿Yucha aniya mints'alhk'an, yu nawnat li wa la'lhtuluwi tsukulh? ¿Tasicha lhijalakawanan chawayi? ");
INSERT INTO tpp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","An ixpaynin taja'alhtayanalh tanajun: ―Ijk'atsayawi li ani yucha kints'alhk'an, chi li wa la'lhtuluwi tsukulh. ");
INSERT INTO tpp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero jantu ijk'atsayaw tani lhijalakawanancha chaway, chi jantu ijk'atsayaw tichini malakawanilhcha. Yuch'ach'a k'alhisakmit, mu aycha, yuchacha katajunan. ");
INSERT INTO tpp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","An ixpaynin wa chuncha tanawlh, mu ixtatalhanan, mu an judiojnin ixtatamakajuntacha li yu kanawna li an Jesús yucha Cristo, katamakxtukana an tan ixtata'ayxt'o'a yu tajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xliyu talhinawlh an ixpaynin: “Yuch'ach'a k'alhisakmit, mu aycha.” ");
INSERT INTO tpp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","An judiojnin a'tam tat'asanipalhi an yu la'lhtuluw ixjunita, chi tajuniy: ―Akilajuniw yu sawalh la ix'ukxlakapu Dios. Kitnan ijk'atsayawi li anchunu lapanak wa ma'lhta'alhini'. ");
INSERT INTO tpp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yucha jajuniy: ―Li ma'lhta'alhini, kit'in jantu ijk'atsay. Yu ijk'atsay, li jantu lay xajkalakawanan, pero chaway ijkalakawanancha. ");
INSERT INTO tpp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","A'tam talhisakmipalh tajuniy: ―¿Tasicha ilhtuni? ¿Tasicha ilhtulh li malakawaniyncha? ");
INSERT INTO tpp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yucha jajuniy: ―Iklajuniwcha, pero jantu kilakiklaka'iyaw. ¿Tasu li a'tam aklajumpalawi? ¿Chu wachu sna ixt'alhtanani ump'ut'unat'it? ");
INSERT INTO tpp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wa chuncha tamamaxanilhcha, chi tajuniy: ―Uxint'i ka ixt'alhtanak'at'i anchunu lapanak, pero kitnan ixt'alhtanan an Moisés. ");
INSERT INTO tpp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kitnan ijk'atsayaw li an Dios xa'alalhi an Moisés, pero anchunu lapanak jantu ijk'atsayaw tanchuncha minchalh. ");
INSERT INTO tpp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","An yu la'lhtuluw lapanak ixjunita jajuniy: ―¡Pus yuchacha yu lhi'a'nincha! Uxitnan jant'u k'ats'ayat tanchuncha minchalh, walh chi kit'in kimalakawanilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Chi k'atsayawi li an Dios jantu ja'asmatniya an ma'lhta'alhinin, pero yu kiklaka'iya an Dios chi ilhtuniya yu najun, yucha asmatniy. ");
INSERT INTO tpp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jantu a'tam asmatkanta li xamati lay kamalakawanilh yu wa la'lhtuluw la'awlh. ");
INSERT INTO tpp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Li ani lapanak jantu Diosi makminta, jantu lay tu'u ka'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pus yu'uncha tajuniy: ―Uxint'i wa tala'alhinch'a p'uts'uk'u, ¿chi uxint'icha akilamasuniyaw? Pus tatamakxtulhcha an tan ixtata'ayxt'o'a an yu tajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Walh an Jesús k'atsaalhi li tatamakxtulh, pus akxni paxto'lhi lhisakmiy juniy: ―¿Uxint'i k'iklak'a'iya an isTs'alh Dios? ");
INSERT INTO tpp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yucha alhtaylh juniy: ―¿Jamach'alhkat, tisiyuchacha, para li ajkiklaka'ilh? ");
INSERT INTO tpp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","An Jesús juniy: ―La'ts'int'a'uncha, kit'in, yu t'ach'iwint'a'un. ");
INSERT INTO tpp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wa chuncha an lapanak tatso'ottatawlhnilhcha la ixlakapu an Jesús, chi juniy: ―Ijkiklaka'iyani, Jamach'alhkat. ");
INSERT INTO tpp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","An Jesús juniy: ―Kit'in ikminta nawna ani lakamunulhpa tanyuchacha yu oxi chi yu jantu, para li an yu jantu tajalakawanan, katajalakawanalh, chi an yu tajalakawanan jantu katajalakawanalh. ");
INSERT INTO tpp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ali'in fariseojnin yu ancha ixtat'ayanalh, mu ta'alha'asmat'acha, pus tajuniy: ―¿Chu wachu la'la'lhtuluw'uni kitnan? ");
INSERT INTO tpp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","An Jesús ja'alhtaylh jajuniy: ―Li la'la'lhtuluw'uni k'a'ix'unt'it, jantu tu'u k'a'ixlits'uk'ut mintala'alhink'an, pero mu nawnat'iti li jalak'awananat'it chaway amintala'alhink'an mincuentajk'an. ");
INSERT INTO tpp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Ani yu iklajunaw sawalh, yu jantu la xamalhticha putanuyachalh an la ixkurralhk'an an borregojnin yu lakatami putanuyachalh, wa ja'alhawna'. ");
INSERT INTO tpp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero yu la xamalhticha putanuyachalh, yucha yu jalhist'ak'a an borregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","An yu jalhistaknan laka malhticha yucha mati'aniycha an yu jalhist'ak'a ixborregojnin chi la ixta'a'utchak'ani jamapa'a'uy la'atamin, pus ta'alhmispaycha, chi jamaxtuycha. ");
INSERT INTO tpp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Chi akxni tataxtu'ojoycha, jatap'ulhniycha, pus an borregojnin tach'a'o'aycha mu ta'alhmispay. ");
INSERT INTO tpp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero yu jantu tamispay jantu tach'a'o'ay, wa talakats'alhniy mu jantu ta'alhmispay. ");
INSERT INTO tpp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","An Jesús chuncha jalhimalakxtunilh, pero yu'uncha jantu talhimacha'xanilh. ");
INSERT INTO tpp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pus a'tam jajumpalhi an Jesús, jajuniy: ―Ani iklajunaw yucha sawalh, kit'ini ixmalhtichak'an an borregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Akxni jantuka' xakmin, ixchuxk'an an yu p'ulhnaj takilachilh wa ja'alhawnan, pero an borregojnin jantu ta'alha'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kit'in, ikmalhticha, yu kit'ini kimputanuy kata'alhtaxtuya'. Katanuya chi kataxtuya chi kala'cha'ana jats'in. ");
INSERT INTO tpp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’An ja'alhawna yucha wa mintacha ja'alhawana', chi minta jama'nini', chi minta jalakt'ilhiyni'. Pero kit'in ikminta para li k'alhits'uk'ut jatsukunti, chi li lhuwi k'alhits'uk'ut jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Kit'ini yu oxi ijkalhist'ak'a an borregojnin. Yu oxi jalhist'ak'a an borregojnin lhima'axt'a'a ixjatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero li yu wa mapalhnikancha tapatsay, akxni la'ts'in min an ma'tili jamakajuncha an borregojnin chi jats'alaycha, mu jantu yu yu jalhist'ak'a sawalh chi mu jantu ixnawin. An ma'tili ja'uycha an borregojnin chi tatalaktilhacha. ");
INSERT INTO tpp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Anchunu lapanak jats'alay mu yucha wa yucha an ixtalhajacha lhakapu'an, jantu yu an borregojnin sawalhi jalhakapu'an. ");
INSERT INTO tpp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Kit'ini yu oxi ijkalhist'ak'a an borregojnin, chi ijkamispayi yu kinawin, chi yu'uncha kintamispay, ");
INSERT INTO tpp_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","tacha kimispay an kimPay chi kit'in ikmispay wachu'. Kit'in ijkalhima'axt'a'a kijatsukunti an borregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Atumpaj ijkalhit'awpalay ali kiborregojnin yu jantu ani tatanumanalh ani laka kurralh. Yu'uncha wachu ajkalhimina chi akinta'asmatniya kinchiwinti, wa lakatamcha katatsuku'oya chi wa pumatami yu kajalhist'ak'a'. ");
INSERT INTO tpp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’An kimPay xliyu kilhimapayniy, mu kit'in ikma'axt'a'a an kijatsukunti para li ajkama'lhtayanancho'olh. ");
INSERT INTO tpp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jantu xamati kimaxtuniy an kijatsukunti, wa ki'akstucha ikma'axt'a'a. Ikt'acha'ani li akma'axta'lhi chi li akla'a'icho'olh. Ani, yucha an kimPayi chuncha kilhijunilh. ");
INSERT INTO tpp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","An judiojnin a'tam tatala'apitsipalhi akxni chunchacha ta'alha'asmatlhi. ");
INSERT INTO tpp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ixluwk'ani yu yu'uncha ixtanajun: ―Wa loko chi wa lakpach'apata makxkay'un, ¿tasu li takiklaka'iycha? ");
INSERT INTO tpp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ali'in ixtanajun: ―Jantu xamati yu wa lakpach'apata makxkay'un chuncha kachiwinilh. ¿Chu sna layi an makxkay'un kajamalakawanilh yu wa la'la'lhtulu'un? ");
INSERT INTO tpp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","An la'acha'an Jerusalén ixk'atanit'awkan, ixlakata yu ixpupastakkan an ay ixtajtank'an. Ixpaku lhik'asnini ixjunita. ");
INSERT INTO tpp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Chi an Jesús an laka tajtani ix'aklat'ajun, an lhila'ixmalhticha Salomón. ");
INSERT INTO tpp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Walh an judiojnin tala'atanchanulh chi tajuniy: ―¿Tasu wa tiwanancha chuncha akilalhilatsukuyaw li jantu oxi kilajunaw li sna uxint'i Cristojk'at'i? Li uxint'i Cristojk'at'i ixla'ts'awalanticha akilajuniw. ");
INSERT INTO tpp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","An Jesús jajuniy: ―Mu iklajunawcha, pero jantu kilakiklaka'iyaw. An tanlhun an yu iklak'ilhtuy la ixta'a'ut an kimPay, yuchacha masuy. ");
INSERT INTO tpp_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero uxitnan jant'u k'iklak'a'iyat'it, mu uxitnan jantu kiborregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","An kiborregojnin yu'uncha kinta'alhmispay, chi ijkamispay chi kintach'a'o'ay. ");
INSERT INTO tpp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Kit'in ijkaxta'niy jatsukunti yu jantu a'tam katimin'olh, chi jantu a'tam katitanilh, chi jantu xamati akintijamaxtunilh. ");
INSERT INTO tpp_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","An kimPay yucha jantu xamati ixt'achun, yucha yu kijaxta'nilh an borregojnin chi jantu xamati katijama'xa'axtulh an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","An kimPay chi kit'in wa la'atami ijkuntaw. ");
INSERT INTO tpp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wa chuncha an judiojnin ixtalakat'alhmaputumpalaycha, ixtalaksak'acha chiwx. ");
INSERT INTO tpp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero an Jesús jajuniy: ―Lhuwcha tanlhun yu laj'oxi tu'u iklamasuniw yu ixnawin an kimPay. ¿Tanyucha yu akilalhilakat'alhmayawi? ");
INSERT INTO tpp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","An judiojnin tajuniy: ―Jantu xliyu li aktilalhilakat'alhmaw li laj'oxi tanlhun ilht'uy, aklalakat'alhmayaw mu wa aya uniya an Dios. Wachu wa lapanakk'at'i, ch'i uxint'i na'un li Diosk'at'i. ");
INSERT INTO tpp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","An Jesús jajuniy: ―¿Chu jantu ts'o'muk'akanta an la milhamap'a'sink'an tan najun?: “Kit'ini iknajun, uxitnan diosnin.” ");
INSERT INTO tpp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Li an Dios, diosnini jajunilh an yu takilhichiwinchilh ixchiwinti, pus k'atsayawi li an tan chuncha ts'o'muk'akanta jantu layi jantucha katikiklaka'iw. ");
INSERT INTO tpp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Chi li an Dios kisakxtulh chi kimakmilhcha ani lakamunulhpa, ¿t'asu li nawnatcha li wa aya ijkuniycha, li iknajun li kit'in isTs'alh Diosi? ");
INSERT INTO tpp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Li jantu yu ik'ilhtuy an tapatsat tacha an ilhtuy kimPay, jantu akilakiklaka'iw. ");
INSERT INTO tpp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero li chuncha ik'ilhtuy, masi jantu akilakiklaka'iw, yucha an yu ik'ilhtuycha k'ak'iklak'a'it, para li wa xawa'a'tamcha k'ak'ats'at li an kimPay kinput'ajun chi kit'in yucha ikput'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","A'tam ixtach'apayawputumpalay, pero an Jesús tama'a'osli. ");
INSERT INTO tpp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ampalhcha ixtapiktutam an ayxkan tan junkan Jordán, tan ixlip'ulhnaj ixjama'paxanan an Juan, anchacha tamakawchalh. ");
INSERT INTO tpp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ixluwk'ani ixtala'cha'an, chi ixtanajun: ―Chun sawalh, masi an Juan jantu tu'u masulh yu la'lhi'a'nin, pero tacha an lhichiwinilh ani lapanak chun sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ixluwk'ani ancha takiklaka'ilh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ixt'ajun pumatam lapanak wa ixta'an'ay ixjunkan Lázaro, jamacha'a Betania, la ixla'acha'an an Marta chi an ixp'isa'a María. ");
INSERT INTO tpp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ani María ixt'alajamatsan an Lázaro, yucha yu lhich'ampaxalh perjume an Jamach'alhkat Jesús chi ch'anxakalhcha la ix'ay. ");
INSERT INTO tpp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pus an ixt'uyunk'an ixt'alajamatsanan an Lázaro, tamala'achanilhi chiwinti an Jesús tan tajuniy: ―Jamach'alhkat, an yu map'ayniy wa ta'an'ay. ");
INSERT INTO tpp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","An Jesús, akxni asmatlhi, najun: ―Ani ta'an'at jantu katijama'ninilh, yucha apalij wa kapumasukana an ixta'ayat Dios, chi an ixta'ayat an isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Chi masi sawalh ixmapayniya an Jesús an Marta, chi an ixp'isa'a chi an Lázaro, ");
INSERT INTO tpp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","la'at'uy wilhchani tamakawpalhchalh an tan ixt'ajun masi junikalhcha li an Lázaro wa ixta'an'ay. ");
INSERT INTO tpp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ixli'astan jajunilh an ixt'alhtanan: ―Ka'ampalawi xalakaat'un Judea. ");
INSERT INTO tpp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","An ixt'alhtanan tajuniy: ―Maestro, jantuka' ma'ani an judiojnin ancha ixtalakat'alhmaputunacha'an, ¿ch'i a't'amch'a t'ip'imp'alay? ");
INSERT INTO tpp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","An Jesús jajuniy: ―¿Chu jantu la'akawt'uy horaja lhit'ajun an wilhchan? Yu akxni tunkuwi jalhtanan jantu kati'ayst'uk'ukalh, mu la'ts'ini an xajatapulhkunu ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero yu puts'ista jalhtanan, ayst'uk'ukan, mu jantu pulhkuyi ancha. ");
INSERT INTO tpp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ixli'astan jajumpalay: ―An ki'amigojk'an Lázaro lhtatalhcha, pero ikti'an makujunu'. ");
INSERT INTO tpp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","An ixt'alhtanan an Jesús tajuniy: ―Jamach'alhkat, li lhtatalhcha, nawputun li katak'uch'uya'. ");
INSERT INTO tpp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero an Jesús yucha ixjajunt'ajun li an Lázaro nilhcha, pero an ixt'alhtanan ixtanajun li yu wa lhtatakancha sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wa chuncha an Jesús ts'awjcha jajunilh: ―An Lázaro nilhcha, ");
INSERT INTO tpp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","chi oxi iklhiwilay milakatak'an uxitnan li jantu ani xakt'awnachalh para li k'ak'iklak'a'it'it. Ka'awcha la'ts'inin. ");
INSERT INTO tpp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Wa chuncha an Tomás yu ixtajuniy lhist'uy, jajuniy an ali'in ixt'alhtanan: ―Wachu ka'awi kitnan, para li wachucha kat'aniyaw. ");
INSERT INTO tpp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Akxni cha'alh an Jesús, la'at'at'icha wilhchani ixmaknukanta an Lázaro. ");
INSERT INTO tpp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","An la'acha'an Betania waniy la'acha'an Jerusaleni ixlitamakajun, ka wa tacha la'at'utu kilometrojo ixlima'at. ");
INSERT INTO tpp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ixluwk'an an judiojnini ixta'anta la'ts'inin an Marta chi an María, ixtat'alama'oxamixiycha li nilh an Lázaro ixt'alajamatsank'an an Marta chi an María. ");
INSERT INTO tpp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Akxni an Marta k'atsaalhi li an Jesús ixcha'ant'ajuncha, taxtulhcha, alhcha lakatastuknu'. Pero an María tamakawlhi an la ixcha'ak'an. ");
INSERT INTO tpp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","An Marta juniy an Jesús: ―Jamach'alhkat, li ani k'axt'a'ulh, an Lázaro jantu kaxnilh. ");
INSERT INTO tpp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero wachu ijk'atsapalayi masi sta chaway k'ask'inin watuchicha an Dios, kaxta'niyan. ");
INSERT INTO tpp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","An Jesús juniy: ―An Lázaro kala'awcho'oya'. ");
INSERT INTO tpp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","An Marta alhtaylh juniy: ―Mu chun, ijk'atsayi li kala'awcho'oya akxni kala'awcho'okana', yu xati'astancha wilhchan. ");
INSERT INTO tpp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","An Jesús juniy: ―Kit'ini yu ikpula'awcho'okan chi ijkatsukunti. Yu kinkiklaka'iy, masi kanilh, katsukucho'oya'. ");
INSERT INTO tpp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Chi wa tichicha yu t'ajunka chi kinkiklaka'iy, jantu katini'alhilh. ¿K'iklak'a'iya ani yu ijkunan? ");
INSERT INTO tpp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","An Marta alhtaylh juniy: ―Chuni, Jamach'alhkat, kit'in ijkiklaka'iya li uxint'i Cristojk'at'i, isTs'alh Dios, yu t'ant'a ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Akxni chunchacha naw'olh an Marta, alhcha t'asanini an María, ixt'alajamatsan, kalakscha junilh: ―An Maestro aniya t'ajun chi t'asaniyan. ");
INSERT INTO tpp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","An María wa chuncha asmatlhi, las tayalh chi alhcha la'ts'ini an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","An Jesús jantuka' ixtanuyachalhi an la'acha'an. Wa anchaka ixt'ajun tan an kila'kilalh an Marta. ");
INSERT INTO tpp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Akxni tala'ts'ilhi an María li tayalhcha, chi lascha taxtulh, an judiojnin an yu ancha ixtat'awilanalh laka cha'a yu ixtama'oxamixiy tach'a'o'alh, ixtanajun li sna an tan aknukanachalhcha alh alhunu'. ");
INSERT INTO tpp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Akxni cha'alhcha an María tan ixt'ajun an Jesús, tatso'ottanilhcha la ixjach'aja', juniy: ―Jamach'alhkat Jesús, li ani k'a'ixt'a'ulh, an Lázaro jantu ka'ixnilh. ");
INSERT INTO tpp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","An Jesús akxni la'ts'incha an María li ix'alhuncha chi an judiojnin an yu tat'acha'alh wachucha ixtalaj'alhun, an Jesús sawalhcha ta'oxila'alhilh. ");
INSERT INTO tpp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Chi jalhisakmilhcha, jajuniy: ―¿T'anisch'a maknut'it? Yu'uncha tajuniy: ―Jamach'alhkat, k'at'at'icha la'ts'ini'. ");
INSERT INTO tpp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Wa chuncha an Jesús alhulhcha. ");
INSERT INTO tpp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pus an judiojnin ixtanajun: ―¡Jo' k'ala'ts'int'it, sawalhcha ka ixmapayniy! ");
INSERT INTO tpp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero an ali'in ixtanajun: ―Ani mu yucha layi malakawanilh an la'lhtuluw, ¿chu jantu layi ta ka'ixlit'alalh para li jantu ka'ixnilhi an Lázaro? ");
INSERT INTO tpp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","An Jesús, mu a'tamcha ixlita'oxila'alhipalay, pus alhi an tan ix'aknuyachalh an Lázaro. Wa tan'apilho'o'o an lakachiwxin, ixlakapuyawkantacha chiwxi an tan ixputanukanachalh. ");
INSERT INTO tpp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","An Jesús jajuniy: ―K'ama'osut'iti an chiwx. An Marta, an ixt'alajamatsan an yu ixniytacha, juniy an Jesús: ―Jamach'alhkat, ka makxkaycha akamin, mu la'at'at'icha wilhchani niyta. ");
INSERT INTO tpp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","An Jesús juniy: ―¿Chu jantu ijkunani li jak'iklak'a'inin, k'ala'ts'ina'a an ix'alhp'asninti Dios? ");
INSERT INTO tpp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Pus wa chuncha tama'osulhcha an chiwx an tan ix'aknukan, chi an Jesús tala'st'alhcha, najun: ―KimPay ikxta'niyan lhimala'puchajun, mu k'i'asmatnin. ");
INSERT INTO tpp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ijk'atsayi li lhilhiji k'i'asmatniy pero tuchi chuncha iklhinajun ixlakatak'an ani tayanalh lapanakni, para li katakiklaka'ilhi li uxint'i k'imakt'ant'a. ");
INSERT INTO tpp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ixli'astan akxni chunchacha naw'olh, p'ascha chiwinilh, najun: ―¡Lázaro, k'at'axt'ucha! ");
INSERT INTO tpp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pus an yu ixnitacha taxtulhcha, an la ixlakmaka chi an la ixlakch'aja ixla'la'apach'inikantacha laka laksliwilh la'ch'it chi an la ix'ukxpu yu aycha la'ch'iti ixpula'apach'inikanta. An Jesús jajuniy: ―K'ala'ax'ott'itcha chi kachajcha ana'. ");
INSERT INTO tpp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tacha ani ilhtulh an Jesús, ixluwk'ani takiklaka'ilh an judiojnin an yu ixtala'cha'anta an María, mu tala'ts'ilhcha tacha an ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero an ali'in ta'alh la'ts'inini an fariseojnin, chi tajunilhi tani ilhtulhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Pus an xalaj'ajin sacerdotejnin chi an fariseojnin tata'ayxto'lhi laka ay junta chi talajuniy: ―¿Tasu ka'ilhtuyawcha? Ani lapanak wa stakcha lakmasut'ajuni tanlhun yu la'lhima'anxkay. ");
INSERT INTO tpp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Li wa chuncha kamakawniyaw, katakiklaka'i'oya', chi an yu jamacha'an Roma katamina chi katalakt'ilhiya an kintajtank'an chi an kilakaat'unk'an. ");
INSERT INTO tpp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero pumatam yu yu'uncha, ixjunkan Caifás, xa'ay sacerdoteje ixjunita anchunu k'ata, jajuniy: ―Uxitnan jant'u t'u'u k'ats'ayat, ");
INSERT INTO tpp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ch'i jant'u lhak'ap'up'inat'iti li palay oxi para kitnani li wa pumatam lapanaki kajalhinilh ixchuxk'an an lapanakni, walh jantu li ta ixlijalhi'ay lakwilakalh an kilakaat'unk'an kalakt'ilhikalh. ");
INSERT INTO tpp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tacha an nawlh, jantu wa ix'akstucha chuncha nawputulh, wa xliyu yucha xa'ay sacerdoteje ixjunita anchunu k'ata, pus la'asiyaj manawnilhcha an Dios li an Jesús kajalhiniya an ixlapanakni. ");
INSERT INTO tpp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chi jantu wa ixlakatacha ani lapanakni, wachu ixlakata li kajapuma'ayxto'kana an ixjas'at'an Dios yu ta'a'pitsinin. ");
INSERT INTO tpp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pus chunchacha, akxnicha wilhchani tatamakawlh an xajamach'alhkatni judiojnin li katama'niyacha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Xliyu an Jesús jantucha ixjatalakasuniya an judiojnin, taxtulhcha an xalakaat'un Judea, alhcha tanchun la'acha'an junkan Efraín, waniy tan wa jaxixnintacha. Anchacha jat'atamakawlh an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Chi waniycha ists'an'ay ixpaxkuk'an an judiojnin, pus ixluwk'ani yu wa ancha la'la'acha'anaxni ixtawilanalh tatama'ast'a'alhi Jerusalén akxni jantuka' ix'a'tayniy an paxku, para li katastalan'alh. ");
INSERT INTO tpp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ixtapuxkajuycha an Jesús chi ixtalajumpaxay an laka tajtan: ―¿T'asch'a lhiwilayat'iti? ¿Kamina laka k'atan u jantu? ");
INSERT INTO tpp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","An fariseojnin chi an xalaj'ajin sacerdotejnin ixtalhinajuntacha li ma xamati la'ts'in an Jesús, ma kanawlh, para li katach'apayawlhcha. ");
INSERT INTO tpp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","An Jesús alh Betaniaja akxni la'achaxanka wilhchan ists'an'ay kachilh paxku, tan ixwilhchalh an Lázaro, an yu ixmala'awnicho'ota. ");
INSERT INTO tpp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ancha tamawachalh, an Marta ixjalak'iniycha ixpulatojk'an, chi an Lázaro wachu ani ixt'awilh an Jesús an laka mesa. ");
INSERT INTO tpp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wa chuncha an María xa'a'ilh la'atam perjume yu la'stu de nardo katacha paytat litro, chi yucha wanaj la'lhuwi tapalay, pus lakch'anmuk'alhcha an Jesús, chi ixli'astan lakch'anxakalhcha la ix'ay. An ixpulakni an cha'a wa pulaklhaklhicha walh. ");
INSERT INTO tpp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Chi xapumatam an ixt'alhtana Jesús, junkan Judas Iscariote, ists'alh Simón, yu an kama'axt'a'a an Jesús, najun: ");
INSERT INTO tpp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tasu li jantu st'akalhi ani perjume yu la'at'utu ciento wilhchan xatapatsat tapalayi, para li ka'ixjamala'pitsinikalhcha an jakilhpatinini? ");
INSERT INTO tpp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero yucha masi chuncha nawlh, jantu wa xliyu ixjalhakapu'ancha an jakilhpatinin, yucha wa xliyu ixja'alhawanan, chi mu yucha ixlit'ajun an bolsa yu ixputajuy an tumin, pus ixmakutuy. ");
INSERT INTO tpp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wa chuncha an Jesús juniy: ―K'amak'awcha, ani wa mala'asijniycha para li akxni akimaknukana'. ");
INSERT INTO tpp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","An jakilhpatinin lhilhiji k'ajat'a'aklats'uk'uya'it, pero kit'in jantu. ");
INSERT INTO tpp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ixluwk'an an judiojnini tak'atsaalh li an Jesús Betaniaja ixt'ajun, pus ta'alh, pero jantu wa yuchacha ixtala'ts'imputun, wachu ixtala'ts'imputuni an Lázaro, an yu ixmala'awnicho'ota an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wa chuncha an xalaj'ajin sacerdotejnin tat'acha'alhcha li katama'niya wachu an Lázaro, ");
INSERT INTO tpp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","mu ixlakata yucha li wanajcha ixluwk'ani ixtat'alamakawt'ajun an judiojnin, yucha an Jesuscha ixtakiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lhuw tukan lapanaki ix'anta la'acha'an Jerusalén ixlakata an k'atan yu junkan paxku, chi akxni tunkunchalh tak'atsaalhi li kacha'ana an la'acha'an an Jesús, ");
INSERT INTO tpp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tala't'e'e'ilhcha jap'ach'i chi ta'alhcha lakatastuknin, p'ascha ixtalakt'asay: ―¡Hosanna! ¡Oxi ani yu la ixta'a'ut Dios minta! ¡An xaRey Israel, oxi! ");
INSERT INTO tpp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","An Jesús la'cha'alh la'atam burro chi putawk'alhcha, tacha najunta an tan ts'o'muk'akanta: ");
INSERT INTO tpp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jant'u k'at'alhani, la'acha'an Sión. Mu aminRey mintacha, pu'uk'alh la'atam xajas'at'a burro. ");
INSERT INTO tpp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Wa ixlip'ulhnaj an ixt'alhtanan an Jesús jantu talhimacha'xalh, pero ixli'astan, akxni an Jesús la'ayakalhcha, akxni tapastaklhicha li chuncha ixlits'o'muk'akanta li yucha ixlichiwininta tacha an ta'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","An lapanakni an yu ixtala'ts'inta akxni an Jesús t'asanilh chi mala'awnicho'olh an Lázaro an tan ix'aknuy, ixtalaknajuncha. ");
INSERT INTO tpp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Xliyu an lapanakni ta'alhcha lakatastuknini an Jesús, mu tak'atsaalhcha tacha an ix'ilhtuta yu lhima'anxkay. ");
INSERT INTO tpp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero an fariseojnin ixtalajumpaxay: ―La'ts'inatcha uxitnan li chuncha jantu tu'u kati'ilhtuw. K'ala'ts'int'it, ¡wanajcha ta lhichuxi tit'a'ankan! ");
INSERT INTO tpp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tacha an ix'ankanta Jerusalén laka k'atan, ixtama'anta yu griegojnin. ");
INSERT INTO tpp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Pus tala'cha'alhi an Felipe, jamacha'a Betsaida, xalakaat'un Galilea, chi ixtatapayniniycha, ixtajuniy: ―Jamach'alhkat, ikla'ts'imputunaw an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pus an Felipe alh junini an Andrés, chi ixlit'uyunchak'ani ta'alh juninin an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","An Jesús jajuniy: ―Chilhcha panch'e'ex li an yu isTs'alh Lapanak kijunchilh kala'ayakanacha. ");
INSERT INTO tpp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chaway iklajunaw li an xatalhts'i trigo patajuy an lakaat'un chi li jantu tamp'a'a, wa sa'cha tamay ix'akstu pero li tamp'a'a, lhuwi xajatawk'at xt'a'a. ");
INSERT INTO tpp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yu mapayniya ixjatsukunti, kama'ats'an'aya'. Pero yu xkajiya ixjatsukunti ani lakamunulhpa, kalhitsukuya ixjatsukunti yu jantu a'tam katimin'olh. ");
INSERT INTO tpp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Li xamati kint'atapatsaputun, akinch'a'o'alhcha. Chi tan aktsukuya, wanajcha ani katsukuya an yu kint'atapatsay. Li xamati kint'atapatsay, an kimPay oxi kalhi'o'xla'ts'ina'. ");
INSERT INTO tpp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Chaway wanaj jantu k'is oxi ijk'atsan la kintak'atsan. ¿Chi tasicha aknawna'a? ¿Aknawna: “KimPay ak'ima'osunini ani tacha ijk'atsan, aknawna'”? ¡Kit'in yuchacha ikla'minta ani! ");
INSERT INTO tpp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“KimPay, k'ala'ayat'icha aminta'a'ut.” Wa chuncha chiwinkanchalh an lakt'iyan, nawkan: ―Ikla'ayatacha, chi akla'ayapala a'tam. ");
INSERT INTO tpp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","An lapanakni an yu ancha ixtayanalh chi ta'asmatlhi an tacha nawkalh, ixtanajun ma wa t'asalh xalapanak xkan. Ali'in ixtanajun: ―Pumatam angelhi alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","An Jesús jajuniy: ―Ani chiwinti asmatt'it jantu para kit'in, para uxitnan. ");
INSERT INTO tpp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chawaycha kanawkana li oxi u jantu yu ta'ilhtuy an lapanakni ani lakamunulhpa', chi chaway katamakxtukanacha an yu ch'alhkatnan ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero kit'in, akxni akimakxtukmuk'akanacha laka k'iw ani lakaat'un, wanaj lhuwi yu akintach'a'o'aya'. ");
INSERT INTO tpp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chunchacha ixjapumak'atsaaninin tani kalayacha akxni kaniya'. ");
INSERT INTO tpp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","An lapanakni ta'alhtaylh tajuniy: ―Kitnan ik'asmattaw an laka lhamap'a'sin li an Cristo katsuku'alhiya'. ¿T'asuch'a li na'un li task'iniya li an yu kijunchilh isTs'alh Lapanak kamakxtukmuk'akana'a? ¿Tanyucha isTs'alh Lapanaki? ");
INSERT INTO tpp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","An Jesús jajuniy: ―Wa lakats'uniycha ani katat'a'aklatsukuyan an jatapulhkunu'. K'alak'alht'anant'iti li lhit'awnatka an jatapulhkunu', para li jantu wa kalaks katala'chini an jatats'isni akxni jant'u jalajk'ats'anant'at'it, mu yu lakaaputs'isni jalhtanan jantu k'atsay tanchuncha ti'an. ");
INSERT INTO tpp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Li lhit'awnatka an jatapulhkunu, k'ak'iklak'a'it'it, para li ixjas'at'an jatapulhkunu k'a'unt'it. Akxni chunchacha jajun'olh, an Jesús alhcha, jatats'e'nilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Masi an Jesús wanajcha lhuwi ix'ilhtuta la ix'ukxlakapuk'an an lapanakni yu la'lhi'a'nin tanlhun, jantu ixtakiklaka'iy, ");
INSERT INTO tpp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","wa xliyu li tapasalhi tacha an ists'o'muk'ata an Isaías, yu ixlichiwiniy ixchiwinti Dios, tan najun: Dios, ¿tisiyuchacha kiklaka'ita an kinchiwintik'ani? ¿An lapanak tasuwanancha la'ts'inta ix'alhp'asninti Diosi? ");
INSERT INTO tpp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Pus jantu lay ixtakiklaka'iy, mu wachu ists'o'muk'apalata an Isaías tan najun: ");
INSERT INTO tpp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","An Dios jamala'puts'inita chi t'ak'alh ja'ilhtunita an ixjalhunutk'an, para li jantu katajalakawanalh, chi para li jantu kataja'asmatnalh, chi para li jantu katawalhi ixjas'at'an Dios chi chuncha jantu ajkak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","An Isaías chuncha nawlh mu ixla'ts'inta an ixta'ayaxtu an Jesús chi yucha lhichiwinilh. ");
INSERT INTO tpp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Masi chuncha, ixluwk'ani takiklaka'ilh an judiojnin an Jesús, sta an jamach'alhkatni wachu'. Pero jantu ixtanajuni tan lhilhuw mu ixtatalhamniya an fariseojnin, para li jantu kajatamakxtukalh an laka cha'a tan ixtata'ayxt'o'a an yu ixtajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mu palay ixtala'a'iya li oxi kajala'ts'inkalh, pero jantu ixtala'a'iya li oxi kajala'ts'ilh Dios. ");
INSERT INTO tpp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","An Jesús p'asi chiwinilh, najun: ―Yu kinkiklaka'iy, jantu wa kit'incha kinkiklaka'iy, wachu kiklaka'iya an kimPay, yu kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chi yu kila'ts'in, wachu la'ts'ini an yu kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Kit'in ijkatapulhkunu', chi ani lakamunulhpa ikminta para li chux yu kinkiklaka'iy jantu wa lakaaputs'isnicha katsuku'alhilh. ");
INSERT INTO tpp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yu asmat'a kinchiwinti chi jantu kiklaka'iy, jantu aktinawlhi li oxi u jantu lay, mu jantu yu ikla'minta ani lakamunulhpa', kit'in ikminta ma'alhtaxtunu an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yu kisamaj'an chi jantu ki'asmatniputuni kinchiwinti, alincha yu kajuna li oxi u jantu tacha lay, yucha an kinchiwinti kajuna li oxi u jantu ixt'ajun akxni xati'astancha wilhchan kajuna'. ");
INSERT INTO tpp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Mu kit'in jantu wa ki'akstucha iknajun yu ikchiwiniy, yucha an kimPay yu kimala'achatachalhi kilhijuniy li aknawlh chi li akmasulh. ");
INSERT INTO tpp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Chi ijk'atsayi li an ixlamap'a'sin an kimPay xt'a'a jatsukunti yu jantu a'tam min'ojoy. Xliyu an tacha iknajun, mu chuncha kilhijunita an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Akxni jantuka' ixchin ixk'atan Paxku, an Jesús ixk'atsaycha li chilhcha ixpanch'e'ex para li ani lakamunulhpa tan ixt'ajun kala'ancho'oyacha an ixPay, chi mu ixjamapayniya an yu ixtat'alhtanan ani lakamunulhpa, sta wa nilhcha jamapaynilh. ");
INSERT INTO tpp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Akxni ixtalakwayt'ajuncha puts'ista, an xapay makxkay'un ixtamaknunitacha la ixjatapast'ak'at an Judas Iscariote, ists'alh Simón, li kama'axt'a'a an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","An Jesús ixk'atsayi li an ixPay ixma'axta'ni'ojota wa tuchicha la ixmaka'. Ixk'atsayi an Jesús li tan wilhchalh Diosi ixmintachalh chi li anchacha kacha'ancho'oya'. ");
INSERT INTO tpp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","An Jesús tayalhi an tan ixtalakwayt'ajun, chi ayp'uxkalhi an ixla'ch'it an yu ixpu'ayxt'a'kanta. Xa'a'ilhcha la'atam toalla chi ch'axpach'imuk'akalhcha. ");
INSERT INTO tpp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ixli'astan mujulhcha xkan laka la'atam axi, chi tsukulhcha jala'ch'anch'a'ayi an ixt'alhtanan chi jalakch'anxakalhcha an laka toalla an yu ixch'axpach'imuk'akanta. ");
INSERT INTO tpp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Akxni yucha an Pedrojcha kach'anch'a'akana, yucha juniy: ―Jamach'alhkat Jesús, ¿uxint'ich'a ak'inch'anch'a'aya'a? ");
INSERT INTO tpp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","An Jesús juniy: ―Chaway jant'u lhimach'a'xayi tuchini ik'ilhtut'ajuncha, pero ixli'astan k'alhimach'a'xaya'acha. ");
INSERT INTO tpp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","An Pedro juniy: ―¡Jantu aktilhitamakawlhi li ak'inch'anch'a'at'i! An Jesús juniy: ―Li jantu aktich'anch'a'an, jantu kint'alhtanak'at'i k'at'i'unt'i. ");
INSERT INTO tpp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pus an Simón Pedro juniy: ―Jamach'alhkat Jesús, jant'u wa ak'ila'ch'anch'a'at'i, wach'u ak'ila'ma'ch'a'at'i ch'i ak'ila'p'ach'a'at'i. ");
INSERT INTO tpp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","An Jesús alhtaylh juniy: ―Yu wa pax'ojotaka jantu ma'lhtask'iniya kapaxpalh, mu oxicha paxta, wa kach'anch'a'alhcha. Chi uxitnan oxich'a lakp'axt'at, masi jantu minchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","“Jantu minchuxk'ani oxicha la'stalan'an la mijalhunutk'an,” jajuniy, mu yucha ixk'atsayi tichini yuchacha yu kama'axt'a'a'. ");
INSERT INTO tpp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Akxni jala'ch'anch'a'a'olhcha, la'ch'icho'olhcha an ixla'ch'it an Jesús, chi tawlhcho'olhcha an laka mesa, jajuniy: ―¿Lhimach'a'xayat'iti tacha an ikla'ilhtuw? ");
INSERT INTO tpp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Uxitnan Maestro chi Jamach'alhkati kilajunaw, chi kit'in sawalh, oxich'a t'ach'a an nawnat. ");
INSERT INTO tpp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pus kit'in ikMaestro chi ikJamach'alhkat, chi iklala'ch'anch'a'awcha, chaway wach'uch'a k'alala'ch'anch'a'ap'axat'it. ");
INSERT INTO tpp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mu iklamasuniwcha t'ani k'a'ilht'utcha, wachucha chuni k'a'ilht'ut tacha an ikla'ilhtuw. ");
INSERT INTO tpp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tacha ani iklajunaw sawalh, an patrón yucha yu ay, an yu wa ma'tapatsay jantu, chi yu inta mala'achakan jantu yu xa'ay, yucha an yu jamala'achanan. ");
INSERT INTO tpp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Li lhimach'a'xayat'iti ani tanlhun ch'i ilht'uyat'it, oxi para uxitnan. ");
INSERT INTO tpp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Jantu minchuxk'ani iklalhichiwint'awnaw, kit'in ijk'atsayi tichini yu'unchacha yu ijkasakxtuta. Pero katapasaya tacha an najunta an tan ts'o'muk'akanta: “An yu kint'alakwayt'ajun wa akint'atasp'it'a'.” ");
INSERT INTO tpp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chawaycha iklamak'atsaaniyaw akxni jantuka' tapasay, para li akxni katapasayacha k'ak'iklak'a'iya'itcha li kit'in. ");
INSERT INTO tpp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ani iklajunaw sawalh, yu kala'a'iya yu kit'in ikmala'achata, kit'ini kila'a'iy; chi yu kila'a'iy, la'a'iya an yu kimakminta. ");
INSERT INTO tpp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Akxni chunchacha naw'olh, an Jesús sawalhcha ta'oxila'alhilh, chi ixla'ts'awalanticha nawlh, jajuniy: ―Xapumatam uxitnani akima'axt'a'a', chi sawalhi tacha ani iklajunaw. ");
INSERT INTO tpp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Pus wa chuncha an ixt'alhtanan ixtalala'ts'impaxaycha, jantu ixtak'atsay tichini yuchacha. ");
INSERT INTO tpp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Xapumatam yu yu'uncha, yu an Jesús ixmapayniy, la ixpa'xti an Jesusi ixmalh, ");
INSERT INTO tpp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","pus an Simón Pedro tamakyawnilh, para li kalhisakmilhi tichini yuchacha an yu lhichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wa chuncha yucha stalhcha la'alh palayi an Jesús, chi lhisakmilhcha, juniy: ―Jamach'alhkat Jesús, ¿tisiyuchacha? ");
INSERT INTO tpp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","An Jesús alhtaylh juniy: ―Ak'awaya lakat'ikt'i xatach'e'en pan, chi an yu akxta'niya yucha. Pus awalhcha an pan, chi yucha an Judas Iscariotejcha xta'nilh, ists'alh Simón. ");
INSERT INTO tpp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Akxni u'olhcha, an Satanás putanulhcha. Wa chuncha an Jesús juniy: ―Yu k'a'ilht'uya'a, wa t'uk'anch'a k'a'ilht'u. ");
INSERT INTO tpp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero jantu xamati lhimacha'xalh an yu ixtawilanalh laka mesa tuchini chunchacha lhijunilh. ");
INSERT INTO tpp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ali'in ixtanajun li sna an Jesús jumputulh: “K'at'amawcha yu kama'lhtask'iniyaw an laka k'atan”, u li tu'ucha kajaxta'nilh an jakilhpatinin, mu yucha an Judasi ixma'ay an tumin laka bolsa. ");
INSERT INTO tpp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Akxni ix'u'ojotacha an pan an Judas, taxtulhcha, puts'istacha. ");
INSERT INTO tpp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Chi akxni alhcha an Judas, an Jesús jajuniy: ―Chaway kala'ayakanacha an yu kijunchilh isTs'alh Lapanak, chi an ixta'ayat Dios yucha an isTs'alhcha kaputasuya'. ");
INSERT INTO tpp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Li an isTs'alh Dios masuyi an ixta'ayat Dios, an Dios wachu kamasuya an ixta'ayat an isTs'alh, chi watukancha kamasuya'. ");
INSERT INTO tpp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Lakt'ikt'in kijas'at'an, jantucha ma'ani aktilat'a'aklatsukuw. Uxitnan akilapuxkawyaw, pero tacha an ijkajunilh judiojnin wanajcha chuni iklajunaw uxitnan: Jant'u lay k'at'ip'it'iti tan ikti'an kit'in. ");
INSERT INTO tpp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Iklaxta'niyaw ani sast'i lhamap'a'sin: Li k'alamap'aynip'axat'it. Tacha kit'in iklamapayniyaw. ");
INSERT INTO tpp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Li k'alamap'aynip'axaya'it'it, ta ixlijalhi'ay an lakamunulhpa katalhakapu'ana li kint'alhtanani uxitnan. ");
INSERT INTO tpp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","An Simón Pedro juniy an Jesús: ―Jamach'alhkat, ¿t'anisch'a t'ip'ini? An Jesús juniy: ―Tan ikti'an jant'u lay ak'int'ich'a'o'a chaway, pero ixli'astan chun. ");
INSERT INTO tpp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","An Pedro juniy: ―Jamach'alhkat, ¿tasu li jantu lay aktich'a'o'ani chawayi? ¡An kijatsukunti aklhima'axt'a'a milakata! ");
INSERT INTO tpp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","An Jesús juniy: ―¿K'alhima'axt'a'a'a mijatsukunti kilakata? Kit'in sawalhi yu ijkunan, jantuka' katit'asalhi an puyux, a't'utucha k'anawna'a li jant'u k'imisp'ay. ");
INSERT INTO tpp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Jant'u k'ala't'a'oxila'alhit'it, k'ak'iklak'a'it'iti an Dios chi wachu akilakiklaka'iw. ");
INSERT INTO tpp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","An la ixcha'a an kimPay wanaj a'alhuwi cha'a alin, li jantu chuni ixwalh, kit'in xaklajuniw. Pus kit'in ikti'ancha, akmala'asijnitachalhcha t'an k'ach'ip'ina'it. ");
INSERT INTO tpp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ixli'astan akxni akmala'asijni'oyantacha, akmimpala a'tam, chi aklalhi'anawcha, para li wachu ani k'at'awlhchi'it tan kit'in aktawlanta. ");
INSERT INTO tpp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Uxitnan misp'ayatcha an tij yu lay pucha'ankan tan ikti'an kit'in. ");
INSERT INTO tpp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","An Tomás juniy an Jesús: ―Jamach'alhkat, jantu ijk'atsayaw t'anch'unch'a t'ip'in, ¿tasicha aklhik'atsayaw an tiji? ");
INSERT INTO tpp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","An Jesús juniy: ―Kit'ini yu iktij, kit'ini yu iksawalh, chi ikjatsukunti, li jantu kit'ini akintipu'alh wa tichicha, jantu lay katila'cha'alh an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Li kilamispayaw, an kimPay wach'u k'amisp'aya'it chi sta chaway misp'ayat'itcha, mu la'ts'inlhit'awnat'itcha. ");
INSERT INTO tpp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pus an Felipe juniy: ―Jamach'alhkat Jesús, akilamasuniwi amimPay, walh wa chuncha oxicha. ");
INSERT INTO tpp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","An Jesús juniy: ―Felipe, ma'anchacha iklat'a'aklat'awnaw, ¿ch'i jant'uka' k'imisp'ay? Yu kila'ts'incha, la'ts'incha an kimPay. ¿T'asu li k'i'uniycha li aklamasuniwi an kimPayi? ");
INSERT INTO tpp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ch'u jant'u k'iklak'a'iya li kit'in ikput'ajuni an kimPay chi an kimPay kimput'ajun? An tacha iklajunaw jantu wa kit'incha chuncha iklajunaw. An kimPay an yu kimput'ajun, yucha kimpulak'ilhtuy an ixtapatsat. ");
INSERT INTO tpp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Akilakiklaka'iwi li yucha an kimPayi ikput'ajun, chi an kimPay kit'ini kimput'ajun, li jantu, masi wa yucha an tacha iklak'ilhtuycha tapatsati akilapukiklaka'iw. ");
INSERT INTO tpp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ani sawalh, yu kinkiklaka'iy wachu kalak'ilhtuya an tapatsat an tacha iklak'ilhtuy. Walh chi palay laj'ayi kalak'ilhtuya', mu kit'in iktila'ancha an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ch'i wa t'uch'ich'a k'ask'iniya'it an kimPay la kinta'a'ut, ak'ilhtuya', para li an isTs'alh Dios kaputasulhi an ixta'ayaxtu Dios. ");
INSERT INTO tpp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wa t'uch'ich'a sk'inat la kinta'a'ut, kit'in ak'ilhtuya'. ");
INSERT INTO tpp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Li kilamapayniyaw, k'ak'iklak'a'it'iti an kilhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Chi kit'in aktapayniniya an kimPay, walh katamak'anipalhtacha'ani pumatam yu katalhi'a'tayjuyan, yu jantucha a'tam katitamakajun: ");
INSERT INTO tpp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","yucha an Takuwin yu kapulhi'an tan sawalh, yu an jantu tajakiklaka'inin jantu lay talhitsukuy, mu jantu tala'ts'in chi jantu tamispay. Pero uxitnan misp'ayat'it, mu tat'a'aklat'awnan chi kataputsukuyan. ");
INSERT INTO tpp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jantu yu tacha jantucha tu'u ixpayk'ani aktilamakawpulaw. ");
INSERT INTO tpp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wa lakats'uniycha, an yu jantu tajakiklaka'inin jantucha ali akintitala'ts'ilh. Pero uxitnan akilala'ts'inaw, ch'i k'ats'uk'uya'it'it mu kit'in ikt'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Anchunu wilhchan, uxitnan k'ak'ats'aya'it'iti li yucha an kimPaycha ikput'awnachalh chi uxitnan kit'incha kilaput'awnaw chi kit'in uxitnancha iklaput'awnaw. ");
INSERT INTO tpp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yu la'a'iya an kilhamap'a'sin chi kiklaka'iy, lhimasuyi li kimapayniy sawalh. Chi yu kimapayniy, kamapayniya an kimPay, chi kit'in akmapayniya wachu', chi aktalakasuniya'. ");
INSERT INTO tpp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","An Judas juniy, (jantu yu an Iscariote pumatam yu wachu chun ixjunkan): ―Jamach'alhkat Jesús, ¿tasu li wa kitnani akilatalakasuniyawi, chi jantu chux lakamunulhpa'a? ");
INSERT INTO tpp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","An Jesús juniy: ―Yu kimapayniy, kiklaka'iya an kinchiwinti chi an kimPay kamapayniya'. Chi kit'in chi an kimPay akminaw t'atawlhnin. ");
INSERT INTO tpp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yu jantu kimapayniy, jantu kiklaka'iya an kinchiwinti. An chiwinti an t'ach'a asmat'at jantu kinchiwinti, ixchiwinti an kimPay an yu kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Li iklat'a'aklat'awnawka ani, iklajunawi ani laktanlhun. ");
INSERT INTO tpp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero an yu katalhi'a'tayjuyan, an Stalan'a Takuwin yu kamakminanta an kimPay la kinta'a'ut, yucha katamasuni'oyani an laktanlhun chi katamapast'ak'ani'oyani chux tacha an iklajuntaw. ");
INSERT INTO tpp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Iklamakawniyawi an oxi jatawlhnat, iklamakawniyawi an oxi kijatawlhnat. Kit'in jantu tacha an yu wa lakamunulhpa tat'ajuni iklaxta'niyaw. Jant'u k'ala't'a'oxila'alhit'it ch'i jant'u k'alakt'alhanant'it. ");
INSERT INTO tpp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Asmatt'itcha li iklajunaw: “Ikti'ancha chi aklala'mimpalaw.” Li xakilamapayniw sawalh, k'a'ixlaj'ach'ant'iti li iktila'an an kimPay, mu yucha palay ay, kit'in jantu. ");
INSERT INTO tpp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Chaway iklamak'atsaaniwcha p'ulhnaja masi li jantuka' tapasay, para li akxni katapasayacha k'ak'iklak'a'iya'itcha. ");
INSERT INTO tpp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Jantucha ali lhuwi aktilat'achiwiniw, mu mintacha an yu ch'alhkatnan ani lakamunulhpa'. Masi yucha jantu tu'u ix'alhp'asninti para li tu'u akilhijunilh. ");
INSERT INTO tpp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero chunchacha yu katapasaya para li an lakamunulhpa kak'atsaalhi li kit'in ikmapayniya an kimPay chi ik'ilhtuyi yu yucha kilhijuniy. ¡K'alakt'ayatcha, ka'awcha! ");
INSERT INTO tpp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kit'ini yu xak'iw uva sawalh, chi an kimPay yucha an yu ch'an. ");
INSERT INTO tpp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Li la'atam ki'a'atan'alat jantu tawk'aniya xa'uva, cha'xa. Pero li tawk'aniya xa'uva, kilhasitmaj'an chi la'alaxtuy, para li ali katawk'alh. ");
INSERT INTO tpp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Uxitnan la'stalan'ancha mu iklajuniwcha an kinchiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wa akilat'a'aklatsuku'alhiwcha, chi kit'in aklat'a'aklatsuku'alhiyaw. Tacha an ix'a'atan'alat uva jantu lay tawk'aniya xa'uva wa ix'akstu, li jantu t'alach'apata an yu xak'iw, pus wanajcha chuni uxitnan, li jantu kilat'a'aklatsuku'alhiyaw. ");
INSERT INTO tpp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Kit'ini an xak'iw uva, uxitnan ixlaj'a'atan'alat. Yu kint'alach'apatachalh, chi kit'in ikt'alach'apatachalh, lhuwi xt'a'a ixjatawk'at, li jantu kit'in, jant'u lay t'u'u k'at'i'ilht'ut'it. ");
INSERT INTO tpp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yu jantu kint'a'aklatsuku'alhiy, ma'spa kamak'ankana', tacha an ix'a'atan'alat uva, chi kaxixa', kala'xawakana laka jikmi. ");
INSERT INTO tpp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Li kilat'a'aklatsuku'alhiyaw, chi an kinchiwinti lhits'uk'u'alhiyat'it, wa t'uch'ich'a sk'imp'ut'unat kaxt'a'nik'ana'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chunchacha yu putasuy ixta'ayaxtu an kimPay akxni uxitnan lhuw xt'a'at mijatawk'atk'an ch'i ch'unch'ach'a p'umasuyat li uxitnan kint'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kit'in iklamapayniyaw tacha kimapayniy an kimPay. K'ats'uk'u'alhitcha an la kijamapayninti. ");
INSERT INTO tpp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Li k'iklak'a'iyat'iti an kilhamap'a'sin, k'ats'uk'u'alhiya'it'iti la kijamapayninti, tacha kit'in ijkiklaka'iya an kimPay chi ikt'aw'alhiya la ixjamapayninti. ");
INSERT INTO tpp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ani iklalhixa'alaw, para li k'alhits'uk'ut'iti an ki'achat chi a'tsayi k'alhits'uk'ut mi'achatk'an. ");
INSERT INTO tpp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yucha aniya kilhamap'a'sin: Li k'alamap'aynip'axat'it, tacha kit'in iklamapayniyaw. ");
INSERT INTO tpp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Yu lhixt'a'a ixjatsukunti ixlakatak'an ix'amigojnin yucha yu lhit'ajun ay jamapayninti. ");
INSERT INTO tpp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Uxitnan ki'amigojnini li ilht'uyat'iti yu iklalhijunaw. ");
INSERT INTO tpp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jantucha aktilajuniwi ma'tsukunin, mu an ma'tsuku yucha jantu k'atsayi tuchini ilhtuycha an ixpatrón. Ki'amigojnincha aklajunaw, mu iklajun'ojocha yu an kimPay kimak'atsaanita. ");
INSERT INTO tpp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Uxitnan jantu wa kilasakxtuw, kit'ini iklasakxtuw uxitnan, chi iklalhisakxtuw li k'ap'inchi'it xta'nini lhuw mijatawk'atk'an, chi amijatawk'atk'an ixpujun'alhincha kawalh. Chuncha kataxta'niyani an kimPay wa tuchicha yu k'ask'iniya'it la kinta'a'ut. ");
INSERT INTO tpp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Pus, yuchacha yu iklajunaw li k'a'ilht'ut'it: Li k'alamap'aynip'axat'it. ");
INSERT INTO tpp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Li an yu tat'ajun lakamunulhpa taxkayan, wa k'ap'ast'akt'itcha li kit'ini p'ulhnaj kintaxkaylh. ");
INSERT INTO tpp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Li xanawin ani lakamunulhpa k'a'ix'unt'it, an lapanakni an yu ani tat'ajun ka'ixtamapaynin, tacha yu'uncha talamapayniy. Pero uxitnan kit'ini iklasakxtuw an tan wa lakamunulhpa ixma't'awnat'it, xliyu an lakamunulhpa taxkayancha, mu chaway uxitnan jantucha xanawin lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","K'ap'ast'akt'iti tacha an iklajuntaw: “An patrón yucha yu palay ay, jantu yu an ma'tsuku'.” Li kit'in kintalhitama'chapulh, uxitnan wach'u k'alhit'ama'ch'ap'uk'ana'it. Chi li talhakapu'ani an kinchiwinti, wachu katalhakapu'ana an minchiwintik'an. ");
INSERT INTO tpp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero chux t'ach'a ani k'a'ilht'uk'ana'it, kilakata. Mu jantu tamispayi an yu kimala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Jantu tu'u ixtalhitsukulh ixtala'alhink'an li jantu xakmilh jaxa'alana'. Pero chaway ixlakata an ixtala'alhink'an jantucha lay ta katitanawlh. ");
INSERT INTO tpp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mu yu an kintaxkajiy, wachu taxkajiya an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jantu tu'u ixtalhitawk'alh li jantu tu'u ixtala'ts'ilh yu iklak'ilhtulh tanlhun, yu jantu xamati lay ilhtuy, pero chaway tala'ts'intacha. Walh masi chuncha kintaxkajiy chi an kimPay wachu taxkajiy. ");
INSERT INTO tpp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero ani chunchacha tapasay, wa xliyu katapasaya an tacha ts'o'muk'akanta chiwinti an la ixlamap'a'sink'an yu'uncha, tan najun: “Jantu tu'u ixlakata, walh kintaxkajiy.” ");
INSERT INTO tpp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Pero kaminacha an yu katalhi'a'tayjuyan, an yu aklamakminitacha'aw, la ixtalakask'i an kimPay, an ixTakuwin yu sawalh. Kaminanta tan wilhchalh an kimPay, yucha kamasuya tichini kit'incha. ");
INSERT INTO tpp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chi uxitnan wachu akilalhichiwininaw, mu sta akxni wa ti'a'taynichalhi kilat'a'aklat'awnaw. ");
INSERT INTO tpp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ani tanlhun iklajuniw para li jant'u k'ama'ats'an'at'iti mijakiklaka'intik'an. ");
INSERT INTO tpp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","K'alakt'amakxt'uk'ana'it'iti an laka lakcha'a tan tata'ayxt'o'a an yu tajakiklaka'inin, chi kachina panch'e'ex akxni masi yu katama'niyan kapast'ak'a li Diosi ma'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wa xliyu li jantu tamispayi an kimPay chi kit'in, xliyu chuncha katalhilaya'. ");
INSERT INTO tpp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ani iklajunaw para li akxni kachinacha an panch'e'ex, k'ap'ast'ak'a'itcha li xaklajuntawcha. ’Jantu iklajuniwi p'ulhnaj, mu aniya xaklat'a'aklat'awnaw. ");
INSERT INTO tpp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero chaway ikti'ancha t'atawlhna an yu kimakmintachalh, walh chi jantu xamati yu uxitnan kilhisakmiy tanchuncha ikti'an. ");
INSERT INTO tpp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Apalijcha wa la't'a'oxila'alhiyat'iti li chunchacha iklajuniw. ");
INSERT INTO tpp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero kit'in iklajunaw yu sawalh: Oxi para uxitnani li kit'in ak'alh. Mu li jantu ak'alh, an yu katalhi'a'tayjuyan jantu katitala'min, pero li ak'ana, aklamakminitacha'aw. ");
INSERT INTO tpp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Akxni kachinacha, oxi kajamasuniya an lapanakni ani lakamunulhpa tichini yu lhit'ajuncha ixtala'alhin chi yu jantu, chi tichini kamama'alh'ajniyacha Dios. ");
INSERT INTO tpp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yu lhit'ajuni ixtala'alhin yucha an yu jantu kinkiklaka'iy, ");
INSERT INTO tpp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","yu jantu lhit'ajun ixtala'alhin, kit'in. Mu kit'in iktila'an an kimPay, chi jantucha ali akintilala'ts'iw. ");
INSERT INTO tpp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yu kala'a'iya lhima'alh'ajna, yucha an ch'alhkatnan ani lakamunulhpa', an xapay makxkay'un, yucha o'sliyancha kama'alh'ajnana'. ");
INSERT INTO tpp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Lhuwka yu lay aklajuniw, pero yu chaway para uxitnan wanaj lhuw. ");
INSERT INTO tpp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Akxni kamina an Stalan'a Takuwin yu sawalh, yucha katapulhi'anani tan oxi sawalh, mu jantu wa ix'akstucha katichiwinilh, yucha kanawna yu ka'asmat'anta, chi katamak'atsaaniyancha an yu kalaktapasaya'. ");
INSERT INTO tpp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yucha kamasuya an ki'alhp'asninti, mu kala'a'iya yu ki'anun chi katamasuniyan. ");
INSERT INTO tpp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chux an yu lhit'ajun an kimPay, wachu ki'anun, xliyu iklhinajun li an Stalan'a Takuwin kala'a'iya yu ki'anun chi katamasuniyan. ");
INSERT INTO tpp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Wa lakats'uniycha, jantucha akintilala'ts'iw, pero ixli'astan lakats'uniy a'tam akilala'ts'impalaw. ");
INSERT INTO tpp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wa chuncha an ixt'alhtanan an Jesús ixtalalhisakmipaxaycha, ixtalajuniy: ―¿Tisuncha nawputun tacha an najuni? Wa lakats'uniycha jantucha akintilala'ts'iw, pero ixli'astan lakats'uniy a'tam akilala'ts'impalaw, mu kit'in iktila'an an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tisuncha nawputun li “wa lakats'uniycha”? Jant'u k'alhimach'a'xat'i. ");
INSERT INTO tpp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Pus an Jesús lhimacha'xalhi li ixtalhisakmiputun, pus jajuniy: ―Kit'in iklajunaw li wa lakats'uniycha jantucha akintilala'ts'iw, chi li ka'ana lakats'uniy panch'e'ex akilala'ts'impalaw. ¿Yuch'a yu lalhisakmip'axayat? ");
INSERT INTO tpp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kit'in ijk'atsaycha li k'alaj'alhuna'it chi k'ala't'a'oxila'alhiya'it, pero an lapanakni yu ani tat'ajun lakamunulhpa wa katalaj'achana'. Pero masi uxitnan k'ala't'a'oxila'alhiya'it, aminta'oxila'alhitk'an achati kajuna'. ");
INSERT INTO tpp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Akxni xamati t'aku lhitsukuy ixjas'at'a, ma'alh'ajnan. Pero ixli'astan akxni t'ajuncha an ixjas'at'a, jantucha pastakcho'oyi li ma'alh'ajnalh, mu achancha li tsukulhcha pumatam lapanaki ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chunchacha wachu chaway uxitnan, ma'alh'ajnanat'iti chaway, pero kit'in aklala'ts'incho'oyaw, akxni ka'achana mijalhunutk'an chi jantu xamati lay katitama'osunin mi'achatk'an. ");
INSERT INTO tpp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Akxni jantucha tu'u akintilalhisakmiw. Wa tuchicha k'ask'iniya'it la kinta'a'ut an kimPay, kataxta'niyan. ");
INSERT INTO tpp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sta chaway jant'u t'u'u sk'int'at la kinta'a'ut. K'ask'int'it walh k'ala'a'iya'it, para li a'tsayi k'alhits'uk'ut mi'achatk'an. ");
INSERT INTO tpp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ani tacha iklaxa'alaw wanaj iklapuxkawniw tu'u t'ach'a laych'a k'alhimach'a'xat, pero mintacha panch'e'ex akxni jantucha aktilaxa'alaw wanaj laka pulhamacha'xan, ixla'ts'awalanticha aklajunaw ixlakata an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Anchunu wilhchan akxni mi'akstuchak'ani k'ask'iniya'it la kinta'a'ut an kimPay, jantucha iklajunaw li kit'ini aksk'iniya an kimPay milakatak'an, ");
INSERT INTO tpp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mu an kimPay yucha tamapayniyan. Tamapayniyan mu uxitnan kilamapayniyaw, chi mu uxitnan k'iklak'a'iyat'iti li kit'in Diosi kimakminta. ");
INSERT INTO tpp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tan wilhchalh an kimPayi iktaxtuchalh, para li akmilh ani lakamunulhpa', chi chaway ikmakawcho'oycha ani lakamunulhpa mu iktila'ancho'oycha an kimPay. ");
INSERT INTO tpp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","An ixt'alhtanan an Jesús tajuniy: ―Chaway ixla'ts'awalanticha ch'iwint'a'un, jantucha wanaj tu'u kilalhixa'alayaw para li lay aklhimacha'xaw. ");
INSERT INTO tpp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Chaway ijk'atsayawcha li k'ats'a'o'oyi an tanlhun, jant'u ma'lht'ask'iniya li xamati kalhisakmin. Chunchacha ikpukiklaka'iyaw li Diosi makmintacha'an. ");
INSERT INTO tpp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","An Jesús jajuniy: ―¿Ah, pus chaway ka kilakiklaka'iyawcha? ");
INSERT INTO tpp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pus mintacha an panch'e'ex, chi chawaycha, akxni atamj atamjcha kala'ts'ina tanchuncha ka'ana', wa ki'akstu akilamakawnaw. Pero jantu wa ki'akstu ikt'ajun, mu an kimPay kint'a'aklat'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tacha ani iklajunaw para li oxi akilat'a'aklatsukuw. Ani lakamunulhpa k'ama'alh'ajnana'it'it, pero oximaj'ayi k'a'unt'it, mu kit'in iklaklhajatacha an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Akxni chunchacha chiwin'olh an Jesús, tala'st'alhcha an lakt'iyan, najun: ―KimPay, an panch'e'ex chilhcha. K'amasut'icha aminTs'alh li ay, para li aminTs'alh wachucha kamasuni li ayk'at'i. ");
INSERT INTO tpp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Mu uxint'i xt'a'nit'a lhich'alhkat aminTs'alh la ix'ukxnik'an an lapanakni, para li kajaxta'nilhi jatsukunti yu jantu min'ojoy an yu jama'axt'a'nit'a. ");
INSERT INTO tpp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","An jatsukunti yu jantu min'ojoy ixlakata li katamispani uxint'i, yu wa uxint'i Diosk'at'i sawalh, chi an Jesucristo, yu uxint'i mala'ach'at'achi'. ");
INSERT INTO tpp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Kit'in ikmasuncha ani lakamunulhpa li ayk'at'i, ik'ilhtu'olhcha an tapatsat yu k'i'uniy li ak'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pus chawayi kimPay, k'amasut'icha li ik'ayi la mimpa'xti', tacha an kilhi'ay xakjunita la mimpa'xti akxni jantuka' ix'alin an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’An yu jasakxt'u lakamunulhpa ch'i k'ijaxt'a'nincha, ijkamak'atsaanilhcha tichini uxint'icha. Minawini ixtajunita, chi k'ijaxt'a'nin, yu'uncha tama'ata an minchiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chaway tak'atsaycha li chux an yu k'ixt'a'nin minawin, ");
INSERT INTO tpp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","mu an chiwinti an yu k'i'un ijk'amak'atsaanilhcha, chi yu'uncha tala'a'ilhcha, chi tak'atsaycha li sawalhi li t'an wilhchi ikminchalh, takiklaka'iya li uxint'i k'imakt'anchi'. ");
INSERT INTO tpp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Ijkalhitapayniniyani ixlakatak'an an lapanakni an yu k'ijaxt'a'nin, mu minawinin, jantu yu ijkalhitapayniniyan an yu wa lakamunulhpacha tat'ajun, an yu wa tachalayjcha talay. ");
INSERT INTO tpp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mu chux yu kinawin, minawin, chi yu minawin, kinawin, yu'unchacha taputasuy kinta'ayat. ");
INSERT INTO tpp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Jantucha ani lakamunulhpa ali akti'aklatsukulh kit'in, pero yu'uncha chun, kit'in ak'antacha'ancha t'atawlhnin. Stalan'ak'at'i kimPay, an yu k'ijaxt'a'nit'acha k'ajama'at'i, mu uxint'i alhp'asnik'at'i, para li tachanu wa pumatamcha katawalh, tacha kitnan. ");
INSERT INTO tpp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Akxni ani lakamunulhpa xajkat'a'aklat'ajun, kit'in ijkama'alhi la minta'a'ut an yu k'ijaxt'a'nin. Kit'in ijkama'alh chi jantu xamati ts'an'alh, wa yucha an yu ists'an'atacha, para li katapasalhi tacha an najunta an tan ts'o'muk'akanta. ");
INSERT INTO tpp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Pero chaway akla'ancho'otacha'ancha, chi tuchi chunchacha iklhichiwint'ajun ani lakamunulhpa li anika ikt'ajun, para li a'tsayi katalhitsukulh wachu an ki'achat. ");
INSERT INTO tpp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ijkamak'atsaanilhcha yu'uncha aminchiwinti, pero sawalhcha jaxkaykan, yu'uncha an lapanakni an yu ani tawilanalh lakamunulhpa' tajaxkayanan. Mu yu'uncha jantucha xanawin ani lakamunulhpa', tacha kit'in jantu aniya la kincha'a'. ");
INSERT INTO tpp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jantu iksk'iniyan li k'ajamaxt'u an lakamunulhpa', iksk'iniyan li k'ajalhist'akt'i, mu t'ajuni an ayajk'atsan xapay makxkay'un. ");
INSERT INTO tpp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Tacha kit'in jantu ani lakamunulhpa kincha'a, yu'uncha wachu jantu ani lakamunulhpa ixcha'ak'an. ");
INSERT INTO tpp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","K'ajast'alan'at'icha an la minchiwinti yu sawalh, aminchiwinti yucha sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tacha uxint'i k'imala'ach'achi ani lakamunulhpa, wanajcha chuni yu'uncha, ijkamala'achalhi an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ixlakatachak'an yu'uncha li ikma'axt'a'a an kijatsukunti, para li yu'uncha wachucha katapustalan'alhi an yu sawalh chiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Chi jantu wa ix'akstuchak'an yu'uncha iklhisk'iniyan, wachu an yu wa akintakiklaka'iyaka', akxni kata'asmat'antacha tacha an katanawnanta. ");
INSERT INTO tpp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Iklhisk'iniyan li ixchuxk'an wa tami katak'atsaalh, tacha uxint'i kimPay, uxint'i k'int'a'aklat'a'un chi kit'in ikt'a'aklat'awnan, yu'uncha wanajcha chuni akintat'a'aklatsukun, para li an lakamunulhpa kakiklaka'ilhi li uxint'i k'imala'ach'achi'. ");
INSERT INTO tpp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ijkaxta'nilhi an alhp'asninti an t'ach'a k'ixt'a'nin, para li wa pumatami katawalh, tacha kitnan wa pumatami juntaw. ");
INSERT INTO tpp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Kit'in ijkat'a'aklat'ajun chi uxint'i k'int'a'aklat'a'un, para li oxi wa tam katak'atsaalh, para li an lakamunulhpa kak'atsaalhi li uxint'i k'imala'ach'achi', ch'i li jamap'ayniya t'ach'a k'imap'ayniy. ");
INSERT INTO tpp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’KimPay, uxint'i k'ijaxt'a'nin chi iklakask'ini li akintat'atawlhchalhi tan aktawlanta, para li katala'ts'ilhi an kinta'ayaxtu yu uxint'i k'ixt'a'nin. Mu uxint'i k'imap'aynit'i akxni jantuka' ix'ilhtukan an lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Stalan'ak'at'i kimPay, ts'ajwi minchiwinti, an lakamunulhpa jantu mispayan, pero kit'in ikmispayan, chi ani wachu tamispayani li uxint'i k'imala'ach'achi'. ");
INSERT INTO tpp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mu ijkamak'atsaanilhcha tichini uxint'icha, chi aktaylhi'anaka', para li amijamapayninti yu k'imp'umap'aynit'a wachu katalhitsukulh, chi kit'in ajkat'a'aklatsukuya la ixjatsukuntik'an. ");
INSERT INTO tpp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ixli'astan akxni chunchacha naw'olh an Jesús, jat'ataxtulhcha an ixt'alhtanan, jat'a'alhcha ixlitapiktutam la'x'ati junkan Cedrón, tan stak ixlakyalh olivo, anchacha jat'apatanulh an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","An Judas, an yu kama'axt'a'a an Jesús, wachu ixjamispanan, mu an Jesús a'lhuwcha ancha ixjat'ata'ayxt'o'a an ixt'alhtanan. ");
INSERT INTO tpp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pus an Judas jat'acha'alhcha ixluwk'an soldadojnin chi ixpoliciajnink'an an xalaj'ajin sacerdotejnin chi an fariseojnin, ixtalaklhi'antacha ixpumaklhkuk'an chi k'iw yu ixlajkinkama'tajita chi ixpama'nink'an. ");
INSERT INTO tpp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero mu an Jesús ixk'atsaycha tuchini katapasayacha, yuchacha p'ulhnaj jalakatastuklhi, jajuniy: ―¿Tisiyuch'ach'a p'uxk'awyat'iti? ");
INSERT INTO tpp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yu'uncha tajuniy: ―Yucha an Jesús jamacha'a' Nazaret. An Jesús jajuniy: ―Kit'in. An Judas an yu kama'axt'a'a wachucha ani ixjat'ayalh. ");
INSERT INTO tpp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Akxni an Jesús jajunilh: “Kit'in”, tataticho'olh chi lakaat'uni tatama'ochalh, tala'ta'a'talh. ");
INSERT INTO tpp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","An Jesús a'tam jalhisakmipalh: ―¿Tisiyuch'ach'a p'uxk'awyat'iti? Yu'uncha a'tam tajumpalay: ―Yucha an Jesús jamacha'a' Nazaret. ");
INSERT INTO tpp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","An Jesús jajuniy: ―Iklajunawcha li kit'in. Li kit'ini kilapuxkawyaw, ani ali'in k'ajamak'awnit'iti li kata'alh. ");
INSERT INTO tpp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tacha ani nawlh wa xliyu li katapasalhi tacha an ixnajunta an Jesús, akxni nawlh: “KimPay, an yu k'ijaxt'a'nin jantu xamati ts'an'alh.” ");
INSERT INTO tpp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Wa chuncha an Simón Pedro, ix'atu'uk'alh ma'atam ix'espada, xtalan xa'axtulh, chi xtalh akatuch'uk'up'uxli yu lhi'oxi ix'a'ax'olh an ixma'tsuku an xa'ay tukan sacerdote, an ma'tsuku ixjunkan Malco. ");
INSERT INTO tpp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","An Jesús juniy an Pedro: ―¡K'amat'a'uch'o'o la xacubierta ami'espada! Li yucha an kimPaycha kixta'niy ani suniya lhima'alh'ajna, ¿chu laycha jantucha aktila'a'ilh? ");
INSERT INTO tpp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wa chuncha an soldadojnin, chi an ixcomandantejk'an, chi an ixpoliciajnink'an an judiojnin, tach'apayawlhcha an Jesús chi tach'iylhcha. ");
INSERT INTO tpp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","P'ulhnajcha talhi'anilh an Anás, mu ixput'ijo'at an Caifasi ixjunita, yu xa'ay tukan sacerdote ixjunita anchunu k'ata. ");
INSERT INTO tpp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","An Caifás yucha yu ixjajunita an judiojnin li palay oxi li wa pumatam lapanak kajalhinilh ixchuxk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","An Simón Pedro chi apumatam ixt'alhtana an Jesús ixtach'a'o'ata. An pumatam ixt'alhtana an Jesús t'atanuchalhi an la ixcha'a an xa'ay tukan sacerdote, mu yucha ixt'alamispay. ");
INSERT INTO tpp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero an Pedro wa ma'spacha tamakawchalh, laka malhticha. Pus an ixt'alhtana an Jesús an yu t'alamispay an xa'ay tukan sacerdote, taxtulh, t'achiwinilhi an t'aku yu ixjalhistaknan an laka malhticha, pus ma'anuchalhi an Pedro. ");
INSERT INTO tpp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wa chuncha an t'aku an yu ixjalhistaknan an laka malhticha, juniy an Pedro: ―¿Chu jantu wachu ixt'alhtanak'at'i an anu lapanak? Yucha najun: ―Jantu, kit'in jantu. ");
INSERT INTO tpp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chi mu lhik'asnini ixjunita, an ma'tsukunin chi an yu ixtajalhistaknan an laka tajtan, ixta'ulatacha jikmi, anchacha ixtala's'ont'ajun. An Pedro wachucha ani ixma'la's'onyalh. ");
INSERT INTO tpp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","An xa'ay tukan sacerdote lhisakmilhcha an Jesús ixlakatak'an an ixt'alhtanan chi tuchini yu ixmasuycha. ");
INSERT INTO tpp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","An Jesús alhtaylh juniy: ―Kit'in chux lakamunulhpa ixlitalakasuni xajkaxa'alay. Jantu tu'u yu wa la'asa'nik'acha akchiwinilh, o'sliyan li tan pulakchiwin ch'a'a chi laka laktajtani xakmasuy, tan tata'ayxto'ojoy an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿T'asu li k'it'inch'a k'ilhisakmiya? K'ajalhisakmit'icha an yu kinta'asmatnita, yu'unchacha katanawlh tuchini ijkalhixa'alatacha. Yu'uncha tak'atsayi tuchini iknajuntacha. ");
INSERT INTO tpp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Akxni chunchacha nawlh an Jesús, xapumatam an yu tajalhistaknan an laka tajtan lo'scha la'xtisalh, juniy: ―¿Ch'unch'ach'a alht'ayst'uk'a an xa'ay tukan sacerdote? ");
INSERT INTO tpp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","An Jesús juniy: ―Li jantu oxi yu iknawlh, k'anawcha tuchini chunchacha, pero li oxi, ¿t'asu li k'imuk'aniycha? ");
INSERT INTO tpp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wa chuncha an Anás, mak'alhcha an Jesús tan ixwilhchalh an xa'ay sacerdote Caifás, tach'ilhi'anilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Walh an Pedro, anchaka ixyalh ixma'la's'ont'ajun, pus tajuniy: ―¿Chu jantu ixt'alhtanak'at'i wachu'? Yucha najun ma jantu, najun: ―¡Jantu, kit'in jantu! ");
INSERT INTO tpp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Walh pumatam ixma'tsuku an xa'ay tukan sacerdote, ixt'alalhila'ts'i an yu ix'akatuch'uk'up'uxta an Pedro, juniy: ―¿Chu jantu uxint'i an ikt'ala'ts'in an tan lakyalh xak'iw olivo? ");
INSERT INTO tpp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","An Pedro a'tam nawpalh ma jantu, walh wa naw'olhka, t'asalhcha an puyux. ");
INSERT INTO tpp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Tamaxtulhcha an Jesús an la ixcha'a an Caifás, talhi'alhcha la ixpalacio an jamach'alhkat. Chi mu ixtunkunmintacha, an judiojnin jantu tatanulhi an laka palacio, para li jantu katalhkilikilhi ixjatsukuntik'an chi chuncha layi katawaylh laka Paxku. ");
INSERT INTO tpp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Wa chuncha taxtulhcha an Pilato, chi jala'cha'alhcha, jajuniy: ―¿T'isunch'a lhi'alht'asuyat ani lapanaki? ");
INSERT INTO tpp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yu'uncha tajuniy: ―Li jantu tu'u ilhtuy tala'alhin, jantu xaklama'axta'niw. ");
INSERT INTO tpp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pus an Pilato jajuniy: ―K'alhip'inchi'itcha uxitnan, chi tacha najuntacha la milhamap'a'sink'ani k'ap'umama'alh'ajnichi'it. An judiojnin tajuniy: ―Pero kitnan jantu kintamakawnikanani li akma'niw xamati'. ");
INSERT INTO tpp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chunchacha tanawlh para li katapasalhcha tacha an ixnajunta an Jesús, tani kapuniyacha. ");
INSERT INTO tpp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Wa chuncha an Pilato tanupalhi an laka palacio, chi t'asanilhcha an Jesús, juniy: ―¿Uxint'i ixrejk'an judiojnin? ");
INSERT INTO tpp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","An Jesús juniy: ―¿Wa mi'akst'uch'a k'ilhisakmiy u xamati'ini talhixa'alatan kit'in? ");
INSERT INTO tpp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","An Pilato juniy: ―¿Chu sna ikjudio? Amint'amacha'an chi an xalaj'ajin sacerdotejnin yu'uncha tama'axt'a'an la kimakni. ¿T'isunch'a ilht'ut'a? ");
INSERT INTO tpp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","An Jesús juniy: ―An kilhich'alhkat jantu xanawin ani lakamunulhpa'. Li xanawin ani lakamunulhpa ka'ixwalh kilhich'alhkat, an ki'a'tayjunin ka'ixtalhilasalhi para li jantu akma'axta'kalh la ixmaknik'an an judiojnin. Pero an kilhich'alhkat jantu aniya xanawin. ");
INSERT INTO tpp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pus an Pilato juniy: ―¿Pus, uxint'i ka Rejk'at'i? An Jesús alhtaylh, juniy: ―Kit'in ikRey, tacha uxint'ich'a nawt'a'un. Kit'in ixlakata yucha li iktsukulh chi yucha ikla'minta ani lakamunulhpa', para li aklhichiwinilhi an yu sawalh. Wa tichicha yu sawalhi tan t'ajun, asmat'a an kinchiwinti. ");
INSERT INTO tpp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","An Pilato juniy: ―¿Tisuncha yu sawalhi? Chi akxni chunchacha nawlh, taxtupalh, jala'ampalhi tan ixtayanalh an judiojnin, chi jajuniy: ―Kit'in jantu tu'u ikla'cha'anini ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero uxitnan ch'unch'a lhismanit'at li iklamakawniyaw pumatam tach'in akxni Paxku. ¿La'a'iyat'iti li aklamakawniwi an ixRejk'an judiojnin? ");
INSERT INTO tpp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wa chuncha ixchuxk'an a'tam p'as talakt'asapalh, tanajun: ―¡Ani jantu! ¡Yucha an Barrabás! An Barrabás, pumatam ja'alhawna ixjunita. ");
INSERT INTO tpp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pus wa chuncha an Pilato lhinawlhcha li kala'ana'makalhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","An soldadojnin tala'oxilhcha la'atam corona de jalhtukun chi tama'tanulhcha chi tamala'ch'inilhcha la'atam ixla'ch'it yu slapulh, ");
INSERT INTO tpp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ixtajuniy: ―¡K'ajama'alht'axt'uncha ixrejk'an judiojnin! Chi lo's lo'scha, ixtala'xtisay. ");
INSERT INTO tpp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","An Pilato a'tam taxtupalhchilh chi jajuniy: ―Jo' k'ala'ts'int'it, ani iklalhiminitaw, para li k'ak'ats'at'iti li jantu tu'u ikla'cha'aniniy ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pus taxtulhcha an Jesús, ixtama'tanutacha an corona de jalhtukun, chi an slapulh la'ch'it ixtamala'ch'initacha. Chi an Pilato jajuniy: ―¡Jo' aniych'a lhit'awnat'iti ani lapanak! ");
INSERT INTO tpp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Akxni tala'ts'ilhi an xalaj'ajin sacerdotejnin chi an yu ixtajalhistaknan laka tajtan, tsukulhcha talakt'asay, ixtalaknajun: ―¡K'amakxt'ukmuk'acha laka cruz! ¡K'amakxt'ukmuk'acha laka cruz! An Pilato jajuniy: ―K'alhip'inchi'itcha uxitnan, uxitnanch'a k'amakxt'ukmuk'at, mu kit'in jantu tu'u ikla'cha'aniniy ixtala'alhin. ");
INSERT INTO tpp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","An judiojnin ta'alhtaylh: ―Kitnan iklhit'awnaw la'atam lhamap'a'sin tan chuncha t'acha'an li kaniylh, mu yucha wa ix'akstucha najun li isTs'alh Dios. ");
INSERT INTO tpp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Akxni chunchacha asmatlhi an Pilato, palaycha talhanalh. ");
INSERT INTO tpp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pus a'tam tanupalhi an laka palacio chi juniy an Jesús: ―¿T'anisch'a t'ant'achi'? Pero an Jesús jantu alhtaylh. ");
INSERT INTO tpp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wa chuncha an Pilato juniy: ―¿Jant'u ak'int'i'alht'ay? ¿Jant'u k'ats'ayi li iklhit'ajuni lhich'alhkat li akmakxtukmuk'an u li akmakajun k'ap'it'i? ");
INSERT INTO tpp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","An Jesús alhtaylh, juniy: ―Jant'u t'u'u ixlits'uk'u lhich'alhkat yu xak'imp'ut'alaxt'uk'u li jantu awint'i talhmani ixmakt'anik'anchi', xliyu an yu kima'axta'lhi la mimaka, palay ay tala'alhini lhit'ajun. ");
INSERT INTO tpp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pus wa akxni an Pilato ixmakawputuncha an Jesús, pero an judiojnin p'asi tamat'asalh, tajuniy: ―¡Li k'amak'awna'a, jantu mi'amigojo an César! ¡Wa tichicha yu jun rey, ixt'alaxkaycha an César! ");
INSERT INTO tpp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pus an Pilato akxni chunchacha ja'alha'asmatlhi, ma'spacha lhi'alh an Jesús, chi tawilhcha an tan tawlay juez, ani tan ixwilh ixjunkan ja'axi'ulanti de chiwx, laka lhihebreo junkan Gabata. ");
INSERT INTO tpp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Akxni chuncha tapasalh, ka tacha ix'atunkunt'ajuncha, chi katunkunanta Paxkucha. An Pilato jajuniy an judiojnin: ―¡Ni'ijcha amiRejk'an! ");
INSERT INTO tpp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero yu'uncha talakt'asalh tanajun: ―¡Jantu, jantu, k'amakxt'ukmuk'acha laka cruz! An Pilato jajuniy: ―¿Akmakxtukmuk'alhcha amiRejk'an? An xalaj'ajin sacerdotejnin ta'alhtaylh tajuniy: ―Kitnan jantu xamati iklhit'awpalaw pumatam kirrejk'an, wa yucha an César. ");
INSERT INTO tpp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pus wa chuncha an Pilato jama'axta'nilhcha an Jesús para li katamakxtukmuk'alhcha, chi talhi'alhcha. ");
INSERT INTO tpp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","A'x'o'alhi'alhcha an ixcruz, tanchun junkan la Ixla'pa'axi Swe'elukut, lhihebreo junkan, Gólgota. ");
INSERT INTO tpp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Anchacha tamakxtukmuk'alh, chi tichi yu'uncha ixt'uyunk'an lapanakni wachu jamakxtukmuk'ak'alh, tapiktutamincha jayawnikalh an Jesús, chi an Jesús tan'ajnicha lhitamakawlh. ");
INSERT INTO tpp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","An Pilato ts'o'lhicha jats'o'nut, chi lhinawlhcha li ka'akpuxtukmuk'akalhcha an ixcruz Jesús, tan najunta: “Jesús jamacha'a Nazaret, ixRejk'an judiojnin.” ");
INSERT INTO tpp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ixluwk'an an judiojnini tapunawlh an tacha ists'o'nikanta. Mu an tan makxtukmuk'akalh an Jesús, wa niya ixlitamakajun an la'acha'an. An tacha ists'o'nikanta, lhihebreo, lhigriego chi lhilatín. ");
INSERT INTO tpp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","An xalaj'ajin isacerdotejnink'an judiojnin tajuniy an Pilato: ―Jant'u k'ats'o't'i li: “IxRejk'an judiojnin”. K'ats'o't'i: “Yu najun li ma ixRejk'an judiojnin”. ");
INSERT INTO tpp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero an Pilato jajuniy: ―Yu ikts'o'tacha, ikts'o'tacha. ");
INSERT INTO tpp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Akxni an soldadojnin tamakxtukmuk'a'olhcha an Jesús, taxa'a'inilhcha an yu ixma'amo'slay ixla'ch'it, aklht'at'icha ta'ilhtunilh chi pumatamjtamincha taxa'a'ilh. Chi an la'atam ixla'ch'it wachu taxa'a'inipalh, chi mu wanaj wa ixpusani'okanta, talhman sta talaktsin, jantu wa ixla'ts'ap'ankanta, ");
INSERT INTO tpp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","pus an soldadojnin talajuniy: ―Jantu kalaj'exwi, wa ka'amanaw suerte, a ver tichini kalhi'anacha. Pus chunchacha ta'ilhtulh. Chi chunchacha tapasalh sawalh tacha an najunta tan ts'o'muk'akanta: Talamala'pitsilhi an yu xakma'amo'slay kila'ch'it, chi an yu xakmatan'anuta kila'ch'it, talhi'amanalhcha suerte. ");
INSERT INTO tpp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Waniy an la ixcruz an Jesús ancha ixtayanalh an ixnati, chi an ixt'alajamatsancha an ixnati, an María, ixt'iwi Cleofas, chi an María Magdalena. ");
INSERT INTO tpp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Akxni an Jesús la'ts'ilhi an ixnati, chi la'ts'ilhi an ixt'alhtana yu ixmapayniy li ancha ixyalh, juniy an ixnati: ―Anchunu yalh, mints'alh. ");
INSERT INTO tpp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Chi an ixt'alhtana yucha juniy: ―Anchunu yalh, minati. Pus sta akxni an ixt'alhtana an Jesús, tacha ixnaticha la'a'ilh la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ixli'astan, mu k'atsaycha an Jesús li chuxcha tapasa'olh, chi para li katapasalhi tacha an ts'o'muk'akanta, najun: ―Ijkikxixa. ");
INSERT INTO tpp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Walh wa ancha ixwilh la'atam xaluj snap'a' ix'a'tsamanta si vinagre, pus yu'uncha tamala'ch'uch'uwanilh la'atam wa tacha panimak, chi takinkach'imuk'anilhcha laka ma'atam xak'iw hisopo, talhi'anilhcha an la ixkilhni. ");
INSERT INTO tpp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Akxni otlhicha an Jesús, ixli'astan najun: ―Tapasa'olhcha. Pus lilijcha ma'alhtajulhi an ix'a'tsulh, ma'axta'lhicha an ixtakuwin. ");
INSERT INTO tpp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Akxni chuncha tapasalh akxni ixmala'asijnikancha ixpaku Paxku, katunkuna Paxkucha, pus para li jantu katatamakawtawk'alhi la ixcruzk'an akxni jantu tapatsakan an yu ixjamakxtukmuk'akanta, an judiojnin tatapayninilhi an Pilato li kajalaj'atut'e'ek'alh chi kajap'uxkalhcha an la ixcruzk'an, mu akxni jantu ixtapatsakan sawalhcha ay wilhchani para yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pus ta'alhcha an soldadojnin chi talaj'atut'e'elhcha an pumatam, chi an pumatam wanajcha chun, an yu wachu ixt'amakxtukmuk'akanta an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero akxni tala'cha'alh an Jesús, mu tala'ts'incha li nitacha, jantucha talaj'atut'e'elhi yucha. ");
INSERT INTO tpp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero xapumatam an soldadojnin lit pajalhto'olhi an Jesús, pus watukan taxtunilhi ixjak'alhni chi xkan. ");
INSERT INTO tpp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","An yu la'ts'ilh tacha an tapasalh, yuchaa najun. Chi tacha an najun, sawalh, yucha k'atsayi li sawalhi an yu najun, para li uxitnan wachu k'ak'iklak'a'it'it. ");
INSERT INTO tpp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Mu tacha ani laktapasalh wa xliyu li katapasalhi an tacha ts'o'muk'akanta tan najunta: “Jantu katit'e'enikalhi ixjalukut.” ");
INSERT INTO tpp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Chi lakatam nawpalata: “K'ala'ts'ina'it'iti an yu pajalhto'okalh.” ");
INSERT INTO tpp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ixli'astan akxni chunchacha tapasa'olh, an José, jamacha'a Arimatea, yu wa la'asa' ixt'alhtana ixjunita an Jesús, mu ixjatalhamniy an judiojnin, tapaynisk'inilhi an ixlakatunaj an Jesús an Pilato, pus an Pilato makawnilh. Wa chuncha alhcha ma'alhtajunu chi lhi'alhcha an ixlakatunaj an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Walh wachu cha'alhi an Nicodemo, yu an ixlip'ulhnaj ixla'pixiyalhnanta an Jesús la'atam jatats'isni, ixli'antacha yu ixlalhiyajuta perjume la'stu jach'itin yu junkan mirra chi áloe, ka tacha la'ap'uxamkaw kilo. ");
INSERT INTO tpp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pus tsukulhcha tala'apach'iya an ixlakatunaj an Jesús laka la'lhman la'ch'it chi ixtalakamuk'aycha an perjume, tacha ixtalhilaniycha ixtalamaknuy an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","An tan makxtukmuk'akalh an Jesús ix'alin lakatam palakch'anan, chi ancha ix'ilhtukanta la'atam sast'i puta'aknun, jantuka' k'is xamati ixmaknukan. ");
INSERT INTO tpp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pus anchacha tamaknulh an Jesús, mu ancha wa niya ixlitamakajun, chi mu akxni ixla'asijt'awkancha ixlakata ixPaxkuk'an an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yu p'ulhnajcha wilhchan akxni sast'icha a'taynicho'olh samana, an María Magdalena alhi wats'isin masi puts'istaka an tan ix'aknuy an Jesús, walh akxni la'ts'in ma'osunikanta an chiwx an yu ixpu'o'xt'alhnikanta an tan ix'aknuy. ");
INSERT INTO tpp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wa chuncha jats'alaj'ancho'olh, alhi an tan ixtawilananchalh an Simón Pedro chi an pumatam ixt'alhtana an Jesús an yu sawalh ixmapayniy, chi jajuniy: ―¡Maxtukanta an Jamach'alhkat Jesús an tan ix'aknuy, chi jantu ijk'atsayaw tanchuncha lhi'ankalh! ");
INSERT INTO tpp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pus an Pedro chi an pumatam ixt'alhtana an Jesús ta'alhi an tan ix'aknuy an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","An ixt'uyunk'an wa lakatami ixtalakats'alaj'anta, pero an pumatam ixt'alhtana an Jesús palay p'asi jats'alalh, an Pedro jantu, pus p'ulhnaja cha'alh an pumatam. ");
INSERT INTO tpp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Akxni cha'alhcha, la'ts'incha an la'sliwilh la'ch'it li anchacha ixlakmamakanta, pero jantu tanulh. ");
INSERT INTO tpp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ixli'astan cha'alhcha wachu an Simón Pedro, yucha tanulhi an tan ix'aknuy an Jesús chi wachucha la'ts'ilhi an la'sliwilh la'ch'it li anchacha ixlakmakawnukanta. ");
INSERT INTO tpp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Chi an la'ch'it an yu ixpula'pamilhkanta an Jesús jantu wa lakatami ixt'amamakanta an la'sliwilh la'ch'it yucha lakatami ixpasmilhmakanta. ");
INSERT INTO tpp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wa chuncha wachucha tanulhi an tan ix'aknuy an Jesús an pumatam ixt'alhana', an yu p'ulhnaj ixcha'anta, chi la'ts'ilhcha tacha an ixtapasata, pus kiklaka'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Mu jantuka' ixtalhimacha'xayi tacha an ts'o'muk'akanta la ixchiwinti Dios, tan najun li an Jesús kala'awcho'oya an tan tamanalh janinin. ");
INSERT INTO tpp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wa chuncha an ixt'alhtanan an Jesús ta'ancho'olhcha ixcha'ak'an. ");
INSERT INTO tpp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero an María, ancha tamakawtayalh, ix'alhujyalh, waniy an tan ix'aknuy an Jesús. Yucha ix'alhunt'ajunka, walh ta'antalh para li kala'ts'ilhi an ixpulakni an puta'aknun, ");
INSERT INTO tpp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","walh jala'ts'ilh ixt'uyunk'an angelhnin, la'sut'ut'u ixla'ch'itk'an. An pumatam lhilax'akpuxnicha an tan ixmalh an Jesusi ixwilh chi an pumatam lhilaxjach'ajacha. ");
INSERT INTO tpp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Chi tajuniy an María: ―¿T'asu li alhuncha? Yucha jajuniy: ―Wa xliyu li tamaxtuta an kiJamach'alhkat Jesús chi jantu ijk'atsay tanchuncha tamaka'alh. ");
INSERT INTO tpp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wachunchaka naw'olh, akxni talakatiyawpalh la'ts'ilhcha an Jesús li ancha ixyalh, pero jantu ixk'atsay li yucha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","An Jesús juniy: ―¿T'asu li alhuncha? ¿T'isiyuch'ach'a p'uxk'a'uy? An María ixnajun li yucha an lhist'ak'acha palakch'anan, pus juniy: ―Li sna uxint'i lhip'i, ak'i'uni t'anch'unch'a mak'ap'i, aklhi'ana'. ");
INSERT INTO tpp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","An Jesús juniy: ―¡María! Pus an María akxni la'ts'impalh juniy: ―¡Maestro! ");
INSERT INTO tpp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","An Jesús juniy: ―Jant'u ak'ilak'ach'ap'a, mu jantuka' ikla'ani an kimPay anu talhman. Pero k'ap'inchi jajunini an kijat'ala'awnin, li ikti'ancha tan wilhchalh an kimPay chi mimPayk'an, an kiDios chi miDiosk'an. ");
INSERT INTO tpp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pus wa chuncha an María Magdalena alhcha jajunini an ixt'alhtanan an Jesús, li yucha la'ts'ilhcha an Jamach'alhkat Jesús chi jajunilhcha wachu tani junikalhcha. ");
INSERT INTO tpp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wa yuchaka anchunu wilhchan yu a'taynicho'olhcha sast'i samana, akxni tats'isilhcha, an ixt'alhtanan an Jesús ixta'ayxto'nuncha chi ixtamalaklhchaw'ojota an lakalakmalhticha, mu ixtatalhamniya an judiojnin. An Jesús tanuchalh chi ixtan'ajnichak'ani tayachalh, jajuniy: ―¡Oxich'a k'ats'uk'ut uxitnan! ");
INSERT INTO tpp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Akxni chunchacha nawlh, jamasunilhcha an ixlakmaka chi an ixpaja'elhni. Pus an ixt'alhtanan sawalhcha talaj'achalhi akxni tala'ts'ilhcha an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ixli'astan an Jesús a'tam jajumpalh: ―¡Oxich'a k'ats'uk'ut uxitnan! Tacha kimala'achachalh an kimPay, wachu chuni iklamala'achayaw. ");
INSERT INTO tpp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wa chuncha jasunulhcha an ixt'alhtanan an Jesús chi jajuniy: ―K'ala'a'itcha an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yu k'ajamala'mixiniya'it'iti ixtala'alhink'an, kajamala'mixinikana', ch'i yu jant'u k'at'ijamala'mixinit'it, jantu katijamala'mixinikalh. ");
INSERT INTO tpp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Xapumatam an ixpumakawt'uyk'an ixt'alhtanan an Jesús, yu ixjunkan Tomás, yu ixtajumpalay lhist'uy, jantu ani ixma't'ajun akxni an ali'in jala'cha'alh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ixli'astan an ali'in ixt'alhtanan an Jesús tajuniy: ―Ikla'ts'iwi an Jamach'alhkat Jesús. Pero an Tomás ja'alhtaylh jajuniy: ―Li jantu ikla'ma'la'ts'ini an la ixlakmaka tan lakmakmak'atsanita clavos chi li jantu iktamaknuyi an kimaka, jantu aktikiklaka'ilh, chi li jantu ikpajatamaknuyi an la ixpaja'elhni. ");
INSERT INTO tpp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","La'atsajincha wilhchan la'pusli, an ixt'alhtanan an Jesús a'tamcha ixta'ayxto'numpalayi an laka cha'a', akxni anchacha ixma'wilh an Tomás wachu'. An malhticha ixlaklaklhchaw'ojoy, pero an Jesús tanuchalh, ixtan'ajnichak'ani japujatayalh chi jala'axa'alalhcha, jajuniy: ―¡Oxich'a k'ats'uk'ut'it uxitnan! ");
INSERT INTO tpp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ixli'astan an Jesús juniy an Tomás: ―K'at'amaknut'icha amimaka ani, ch'i ak'ila'ma'la'ts'icha. Ch'i k'alhip'icha amimaka la kimpaja'elhni, k'at'amaknut'icha. Jant'u ch'uni k'alat'i li jant'u jak'iklak'a'inin, k'ajak'iklak'a'in. ");
INSERT INTO tpp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Wa chuncha an Tomás alhtaylh chi juniy: ―¡KiJamach'alhkat chi kiDios! ");
INSERT INTO tpp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","An Jesús alhtaylh juniy: ―Mu k'ila'ts'incha Tomás, p'us k'iklak'a'iycha. Sawalhcha oxi para yu'uncha an yu kintakiklaka'iy masi jantu kintala'ts'inta. ");
INSERT INTO tpp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","An Jesús tipalhuwi masupalh yu la'lhi'a'nin la ix'ukxlakapuk'an an ixt'alhtanan, pero yucha jantu tu'u ts'o'muk'akanta ani laka libro. ");
INSERT INTO tpp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ani ts'o'muk'akalhi para li uxitnan k'ak'iklak'a'it'iti li an Jesús yucha Cristo, isTs'alh Dios, ch'i li k'iklak'a'iyatcha k'ap'ulhits'uk'uya'it'iti jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ixli'astan an Jesús jatalakasunipalhcha a'tami an ixt'alhtanan waniy an lakxkan tan junkan Tiberias. Chunchuniycha tapasalh: ");
INSERT INTO tpp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Wa lakatami ixtat'aw'ojoy, ancha ixt'ajun an Simón Pedro, chi an Tomás, yu ixtajuniy lhist'uy, chi Natanael, jamacha'a Caná xalakaat'un Galilea, chi an ists'alan Zebedeo chi ixt'uyunk'an ali'in ixt'alhtanan an Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","An Simón Pedro jajuniy: ―Ikti'an jach'apayawna jatanti. Yu'uncha ta'alhtaylh: ―Wachu aklat'a'anaw. Pus ta'alhcha chi taputajulhcha la'atam barco. Pero anchunu jatats'isni akxni jantu tu'u tach'apayawlh jatanti. ");
INSERT INTO tpp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Akxni tsukulhcha tunkuncho'oy, an Jesús talakasulhcha an japiktu', pero an ixt'alhtanan jantu ixtak'atsay li yucha. ");
INSERT INTO tpp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","An Jesús jajuniy: ―Ts'alan, ¿jant'u t'u'u lhit'awnat jatanti? Yu'uncha tajuniy: ―Jantu. ");
INSERT INTO tpp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pus jajuniy: ―An lhitan'oxi ixpa'xti an barcojo k'amu'ut an mimpaxo'tank'an, anch'a k'ach'ap'ayawya'it'it. Pus chunchacha ta'ilhtulh, walh ixli'astan jantucha lay ixtamakutuyi an ixpaxo'tank'an mu wanajcha lhuw jatanti ixtama'alhilata. ");
INSERT INTO tpp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wa chuncha an ixt'alhtana an Jesús an yu sawalh ixmapayniy, juniy an Pedro: ―¡Yucha an Jamach'alhkat Jesús! Wa yucha asmatlhi an Simón Pedro li yucha an Jamach'alhkat Jesús, las mala'ch'inilh, mu wa alhalha ixjunita, chi chamancha alhi an lakxkan, para li kacha'alh an la ixpiktu'. ");
INSERT INTO tpp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","An ali'in ixt'alhtanan an Jesús tacha'alhcha an la ixpiktu an lakxkan, an laka barco, katacha cien metrojo ixlitamakajun tan ixtat'awnachalh, taxa'amalhicha'alhcha an paxo'tan la'stu jatanti ix'a'tsamanta. ");
INSERT INTO tpp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Akxni tatayachalhcha lakaat'un, tala'ts'in ulakantacha jikmi chi ukxmuk'akantacha la'atam jatanti chi pan. ");
INSERT INTO tpp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","An Jesús jajuniy: ―K'alhit'at la'atam la'at'uyi an jatanti yu wa jach'ap'aya'utka'. ");
INSERT INTO tpp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","An Simón Pedro tawk'alhi an laka barco chi xa'alhicha'alhcha an paxo'tan an la ixpiktu an lakxkan, la'stu laj'ay jatanti ixtaputajumanalh, ciento cincuenta y tres, chi masi lhuw, an paxo'tan jantu ta'exli. ");
INSERT INTO tpp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","An Jesús jajuniy: ―K'at'atcha lakwaynin. Jantu k'is xamati an ixt'alhtanan katapujulh kalhisakmilh tichini yuchacha, mu ixtak'atsayi li yucha an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","An Jesús stalh alh chi xa'a'ilhcha an pan chi jaxta'nilhcha, chi an jatanti wanajcha chun. ");
INSERT INTO tpp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ani ixli'a't'utucha ixjatalakasuniy an ixt'alhtanan an Jesús akxni ixla'awcho'otacha. ");
INSERT INTO tpp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Akxni talakway'olhcha, an Jesús lhisakmiycha an Simón Pedro, juniy: ―Simón, ists'alh Jonás, ¿k'imap'ayniy palayi kit'in, palay jantu ani tayanalh? An Pedro alhtaylh juniy: ―Chuni, Jamach'alhkat Jesús, uxint'i k'ats'ayi li ikmapayniyan. An Jesús juniy: ―K'ajalhist'akt'i an kiborregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","A'tam lhisakmipalh: ―Simón, ists'alh Jonás, ¿k'imap'ayniy? An Pedro juniy: ―Chuni, Jamach'alhkat Jesús, uxint'i k'ats'ayi li ikmapayniyan. An Jesús juniy: ―K'ajalhist'akt'i an kiborregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ixlipu'a't'utucha lhisakmilh juniy: ―Simón, ists'alh Jonás, ¿k'imap'ayniy? An Pedro ixta'oxila'alhiycha mu a't'utucha lhisakmilh li sna mapayniy, pus juniy: ―Jamach'alhkat Jesús, uxint'i k'ats'a'o'oy, uxint'i k'ats'ayi li ikmapayniyan. An Jesús juniy: ―K'ajalhist'akt'i an kiborregojnin. ");
INSERT INTO tpp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sawalhi an yu ijkunan, akxni palayka ts'alhk'at'i ix'unit'a, ixmala'ch'inini para li k'ap'it'icha t'anch'unch'a ixk'uxap'in. Pero akxni k'at'ap'ap'aya'acha, k'alaklats'awalaya'a amimaka chi pumatami kamala'ch'iniyan chi kalhi'anani t'an jant'u k'a'ixk'uxap'i. ");
INSERT INTO tpp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Akxni chunchacha nawlh an Jesús, ixnawt'ajun tani kapuniyacha an Pedro, chi li chuncha kapumasuya an Pedro li an Dios yucha ay. Ixli'astan juniy: ―¡Ak'inch'a'o'a! ");
INSERT INTO tpp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tala'asp'itlhi an Pedro la'ts'in li an yu sawalh ixmapayniy an ixt'alhtana an Jesús, ixjach'a'o'ata, an yu akxni ixtalakwajinta puts'ista an Jesús ixpiktumalh chi ixlisakmita: “Jamach'alhkat, ¿tisiyuchacha yu kama'axt'a'an?” ");
INSERT INTO tpp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Akxni la'ts'ilh an Pedro juniy an Jesús: ―Jamach'alhkat, chi anu ¿tasu kalayacha? ");
INSERT INTO tpp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","An Jesús alhtaylh: ―Li iknajuni li katsukulhi sta akxni akmincho'oya, yucha jantucha mincuenta, uxint'i wa ak'inch'a'o'acha. ");
INSERT INTO tpp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wa chuncha, tacha ani nawlh an Jesús, wanaj talamak'atsaani'olhi an ixlapanakni an Jesús li ma jantu katinilhi anchunu ixt'alhtana'. Pero an Jesús jantu chuni juniy li jantu katinilh, an Jesús yucha najun: “Li kit'ini iknajun li katsukulhi sta akxni akmincho'oya, yucha jantucha mincuenta.” ");
INSERT INTO tpp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wanaj kit'in, ixt'alhtana an Jesusi yu iknajun tacha an laktapasalh, chi kit'ini ikts'o'lhi, chi k'atsayawi li an yu iknajun, sawalh. ");
INSERT INTO tpp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Chi wanaj lhuw tanlhuni yu ilhtupalh an Jesús, li wa ka'ists'o'muk'a'okalhcha la'atamj la'atamj tacha an lak'ilhtulh, kit'in iknajun ka jantucha inta ka'ixlitamalh ani lakamunulhpa an libro tacha an ists'o'kalh.");
INSERT INTO tpp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, an p'ulhnaj libro ikts'o'lhi ancha lhichiwin'ojota chux yu a'taynilhcha lak'ilhtuy an Jesús chi yu ixmasuycha, ");
INSERT INTO tpp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","sta akxni alhcha an lakt'iyan. Pero akxni jantuka' ix'an jajunilhcha an yu jamala'achay an yu ixjasakxtuta, tuchini yu kata'ilhtuyacha, yucha an ixTakuwin Diosi japuxa'alalh. ");
INSERT INTO tpp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ixli'astan akxni la'awcho'olhcha an Jesús, jatalakasunilhi an ixt'alhtanan, chunchacha japumak'atsaaniylh oxi li yucha la'ajunta. T'up'uxam wilhchani jatalakasunilh chi ixjalhixa'alaycha an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Akxni anchaka ixjat'a'aklat'ajun an ixt'alhtanan an Jesús, jajuniy li an la'acha'an Jerusalén jantu katataxtulh, jajuniy: ―K'ap'akxan'it'iti an yu iklajuntaw li katamakminiyan an kimPay. ");
INSERT INTO tpp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Chun sawalh an jama'paxanaj Juan wa laka xkani jama'paxanalh, pero uxitnan wa lakats'uniycha wilhchani tats'an'aniyan k'a'a'p'axa'itcha laka Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","An yu ancha ixtat'a'ayxto'nun an Jesús, talhisakmiy, tajuniy: ―Jamach'alhkat Jesús, ¿chawaycha akilaxta'nicho'oyaw kijamach'alhkatk'an an xalakaat'un Israel? ");
INSERT INTO tpp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yucha ja'alhtaylh: ―Uxitnan jantu layi k'at'ik'ats'at'itcha tuchi wilhchancha u panch'e'excha chuncha kajuna', yucha an kimPayi yu ka'ilhtuya'. ");
INSERT INTO tpp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero uxitnan akxni katala'chinancha an Stalan'a Takuwin, laj'alhp'asch'a k'a'una'it. Akila'anawcha lhichiwinini an la'acha'an Jerusalén, chi chux xalakaat'un Judea, chi xalakaat'un Samaria, chi sta masi tan ma'at tukan laklhitamakajun ani lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Akxni chunchacha jajunilh an Jesús, wakcha tach'ixli chi sa'cha ixtala'ts'imaka'an, walh matanchanilhcha la'atam jataputs'i chi jantucha lay ali tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chi akxni sa'cha ixtala'ts'imaka'ani an ixt'alhtanan an Jesús an lakt'iyan, an tan ixtalakyanalh tatalakasulhcha ixt'uyunk'an lapanakni, wa la'sut'ut'ucha an ixla'ch'itk'an. ");
INSERT INTO tpp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Chi jajunkan an ixt'alhtanan an Jesús: ―Jamacha'an Galilea, ¿tasu li wa sa'ch'a t'ala'st'ayat'iti an lakt'iyani? Ani Jesús yu ixtat'a'aklat'awnan, yu lhi'ankalhcha lakt'iyan, chuncha kamimpala', t'ach'a la'ts'int'it alh an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wa chuncha an ixt'alhtanan an Jesús an a'stitawk'a tan junkan Laka Olivojnini ixtat'awnachalh, chi ancha ta'alhcha la'acha'an Jerusalén, mu waniya ixlitamakajun, yu lay chuncha ixjalhtanankan akxni jastaknankan. ");
INSERT INTO tpp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Akxni tacha'alhcha an la'acha'an, tatawk'achalhcha an tan ixtawilanalh, tan talhman laka cha'a', yu'uncha an Pedro, chi Juan, chi Santiago, chi Andrés, chi Felipe, chi Tomás, chi Bartolomé, chi Mateo, chi Santiago, ists'alh tichi lapanak junkan Alfeo, chi Simón yu ixtajumpalay ma Zelote, chi Judas, ists'alh tichi lapanak junkan Santiago. ");
INSERT INTO tpp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ixchuxk'an yu'uncha lhilhiji ixtata'ayxt'o'a, ixtatapayniy, chi wachu ani ixtama'ta'ayxt'o'a ali'in t'akunin, ancha ixma'ta'ayxt'o'a an María, ixnati an Jesús chi an ixjat'ala'awnin. ");
INSERT INTO tpp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Anchunu wilhchan an Pedro tayalhi la ixpujank'an an yu ixta'ayxto'nun ixlapanakni an Jesús, katacha tamciento apumap'uxam lapanakni, chi jajuniy: ");
INSERT INTO tpp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Kint'ala'awnin, ixlitask'iniya li chuncha ka'ixtapasalh tacha an ixnajuntacha an David akxni machiwinilh an Stalan'a Takuwin. Yucha lhichiwinilhi an Judas yu jatap'ulhnilh an lapanakni an yu tach'apayawlh an Jesús, ");
INSERT INTO tpp_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","masi yucha xakintat'aput'e'ekanan chi wachu yu tapatsati ix'ilhtuy an tacha ilhtuyaw. ");
INSERT INTO tpp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ani lapanak akxni ilhtulhcha an tala'alhin jama'lhtayanalhcha tumin chi lhitamawlhcha lakatam lakaat'un. Chi akxni patajulhcha an tan ixch'ikilhtakanta ix'akstu, ix'a'tsulhi putamachalh chi wanaj tatan'exli, p'ut'un putaxtu'olhi an ixpaluw. ");
INSERT INTO tpp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Akxni tak'atsaalhi an jamacha'an Jerusalén, anchunu lakaat'un talhimapa'a'ulh la ixlichiwink'an, Acéldama, nawputun Lakaat'un yu Jak'alhni. ");
INSERT INTO tpp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mu ts'o'muk'akanta an laka libro yu junkan Salmos tan najunta: Wanaj kasa' walhi an la ixcha'a', Chi jantu k'is xamati katawilh ancha. Chi najun: Pumatamcha ka'a'ch'apanicho'olh an ixtapatsat. ");
INSERT INTO tpp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Lhitask'iniya li ani lapanakni yu lhilhij kintat'a'aklat'awnan sta akxni an Jamach'alhkat Jesús xakintat'a'aklat'awnan, ");
INSERT INTO tpp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","kasakxtu pumatami yu wachu kanawna li la'ts'ilhi li la'awcho'olhi an Jesús. Mu ani lapanakni kintat'a'aklat'awnani sta akxni ixjama'paxanan an Juan sta wa akxni lhi'ankalhcha anu talhman an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pus tasakxtulhcha ixt'uyunk'an lapanakni: Pumatam ixjunkan José, yu ixtajumpalay Barsabás chi ixtajumpalay justo, chi pumatam ixjunkan Matías. ");
INSERT INTO tpp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Chi ixli'astan tatapayninilhcha an Dios, tajuniy: ―Jamach'alhkat Dios, uxint'i jamisp'ani'o'oyi ixjalhunutk'an ixchuxk'an an lapanakni. Akilamasuniwi t'ich'ini yu sakxt'uycha ani ixt'uyunk'an lapanakni, ");
INSERT INTO tpp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","walh lani wachucha mintamala'achani kajuna', tacha kitnan, chi wachucha chuni katapatsalh. Mu an Judas yucha ts'antijlalhi la ixtala'alhin chi makawpulalhcha an ixtapatsat, pus alhcha tan lhitamakawniy. ");
INSERT INTO tpp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Wa chuncha an ixt'uyunk'an an yu jasakxtukalh, jats'o'muk'anikalhcha ixta'a'utk'an chi yucha an Matiasi walh, pus wa akxni jalhit'aput'e'ekalhcha an ixpumakawtamk'an yu jamala'achay an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Alin ixk'atank'an an judiojnin yu junkan Pentecostés. Akxni chilhcha anchunu k'atan wa lakatami ixta'ayxto'nun'ojoy an yu ixtakiklaka'iy an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Walh akxni tak'atsanalh minchalh an lakt'iyan la'atam wa tacha p'as un, wanaj p'asi ixmakat'ajun, chi wanaj tanu'olhi an laka cha'a an tan ixtatanumanalh. ");
INSERT INTO tpp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Chi wa chuncha jatalakasunilhcha lhuw sima'at, wa tacha jikmi, jala'mala'pitsinikalhcha atamj atamj, jalak'uktawk'achalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ixchuxk'an wanaj tala'a'i'olhi an Stalan'a Takuwin, chi tsukulhcha talakchiwiniy tumpaj chiwinti, tacha yu jaxta'nilhcha an Stalan'a Takuwin li katachiwinilh. ");
INSERT INTO tpp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Anchunu panch'e'ex, an la'acha'an Jerusalén ixtawilanalh judiojnin, yu ixtamuktaxtuy an ixlamap'a'sin Dios, ta lakachux anchunu lakamunulhpa ixtalakmintachalh. ");
INSERT INTO tpp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Akxni chunchacha ta'asmatlhi an lapanakni tacha an makat'awlh, talakats'alaj'alhi an laka cha'a an tan ixtatanumanalh an ixt'alhtanan an Jesús, chi akxni tacha'alh jantucha ixtak'atsay tuchini ixtapasaycha, mu an ixt'alhtanan an Jesús chunchacha ixtalakchiwiniy tacha an ixtalakchiwiniy an lapanakni, tipaspit chiwinti. ");
INSERT INTO tpp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","An lapanakni sawalhcha ixtalhi'a'niy chi jantucha lay ixtalhimacha'xay, ixtalajuniy: ―¿Chu jantu si jamacha'an Galileaja ani talakchiwiniy? ");
INSERT INTO tpp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tasu li jalaj'alha'asmat'awcha lay talakchiwiniy tacha atamj atamj chiwininaw tanchuncha lakmintacha'awi? ");
INSERT INTO tpp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ani, tat'ajun yu jamacha'an Partia, chi jamacha'an Media, chi jamacha'an Elam, chi de Mesopotamia chi de Judea, chi de Capadocia chi xalakaat'un Ponto chi de Asia, ");
INSERT INTO tpp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","chi yu xalakaat'un Frigia tamintachalh chi de Panfilia chi de Egipto chi de Libia waniy la'acha'an Cirene. Chi wachu aniya tat'ajun yu ani tawilanalh yu jamacha'an Roma. ");
INSERT INTO tpp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ali'in yu ixlakpaynink'an judiojnin sawalh, chi ali'in wa tajunlhicha judiojnin. Chi wachu aniya tat'ajun yu jamacha'an Creta chi de Arabia. ¡Walh chi laycha jalaj'alha'asmat'aw an ixt'alhtanan Jesús tacha an talhichiwiniy yu la'lhi'a'nin ilhtuy an Dios, mu tacha an lakchiwininaw ta lakachux la'acha'an lakmintacha'aw chunchacha talakchiwiniy! ");
INSERT INTO tpp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ixchuxk'an an lapanakni sawalhcha ixtalhi'a'niy, chi mu jantucha ixtak'atsay tuchini yu ixtapasaycha, ixtalajuniy: ―¿Tisuncha nawputun tacha ani tapasayi? ");
INSERT INTO tpp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ali'in wa xkayaj ixtanajun, ixtanajun: ―¡Wa tala't'a'ap'ata! ");
INSERT INTO tpp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wa chuncha an Pedro, jat'atayalhi ali an ixpumakawtamk'an ixt'alhtanan an Jesús, chi p'ascha chiwinilh najun: ―Jamacha'an Judea chi chux yu wilat la'acha'an Jerusalén, k'ak'ats'at'iti ani chi oxi k'a'asmatt'it yu aklajunaw. ");
INSERT INTO tpp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ani lapanakni jantu wa tala't'a'ap'ata t'ach'a nawnat uxitnan, mu chaway wats'isinka', wa lasnuevejka'. ");
INSERT INTO tpp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ani yu tapasat'ajun yucha an tacha nawlh an Joel, yu ixlichiwiniy ixchiwinti Dios, akxni nawlh: ");
INSERT INTO tpp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","An Dios najun, Akxni xalakti'astancha wilhchan, akpuxte'emaj'ana an kinTakuwin la ix'ukxnik'an chux an lapanakni. Amijas'at'ank'an, ts'alan chi jatsi'in, katanawna kinchiwinti, an yu lakts'alaninka katala'puminatnana yu katapasaya', chi an yu laktatanincha katajala'awanana'. ");
INSERT INTO tpp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chi an yu kintat'atapatsaycha t'akunin chi lapanakni, ajkaxta'niya an kinTakuwin anchunu panch'e'ex, chi katanawna an kinchiwinti. ");
INSERT INTO tpp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","An lakt'iyan aklakmasuya tanlhun yu laj'ay lhi'a'nin. Chi wachu aklakmasuya tanlhun ani lakaat'un: Jak'alhni, jikmi chi tan kasamama ostayaya jin. ");
INSERT INTO tpp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Akxni jantuka' chini ixwilhchan an Jamach'alhkat an yu wilhchalh lakt'iyan, akxni ay wilhchan kajuna chi lhitapalay, an wilhchan wa ts'iticha kajuna', chi an malhkuyu wa tacha jak'alhnicha kajuna'. ");
INSERT INTO tpp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Chi wa tichicha yu katapayniniya an Dios, kata'alhtaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Jamacha'an Israel, k'a'asmatt'iti ani chiwinti: Uxitnan oxi k'ats'ayat li an Dios tamasunini la mi'ukxlakapuk'an an ix'alhp'asninti an Jesús, jamacha'a Nazaret. An Dios pu'ilhtulhi an Jesús laj'ay tanlhun yu la'lhi'a'nin chi tanlhuncha yu lakmasulh. ");
INSERT INTO tpp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Chi ani lapanak, ma'axt'a'nik'ant'it, ch'i ma'nit'it, mu chunchacha ixlilaklhkata chi chunchacha ix'ilhtuputun an Dios, jalhi'unit'iti an ay tajunita lapanakni li katamakxtukmuk'alhi laka cruz. ");
INSERT INTO tpp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero an Dios mala'awnicho'olh, chi jantucha ali ma'alh'ajnalhi laka lhinin, mu an lhinin jantu layi katit'alalhajalh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pero an rey David lhichiwinilhi an Jesús, akxni nawlh: Kit'in lhilhiji xakla'ts'in an Jamach'alhkat la ki'ukxlakapu'. Yucha yalhi tan oxi kimpa'xti para li jantu tu'u akima'talh. ");
INSERT INTO tpp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Xliyu an kijalhunut achan chi an kisima'at sawalhcha achani milhpay. Chi chux an kilakatunaj lhi'acha kajastaknana', ");
INSERT INTO tpp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","mu jant'u ak'int'imak'awi li akta'aknu'alhilh chi li kalakp'uch'ilh an kilakatunaj yu Stalan'a, kit'in yu ikt'atapatsayan. ");
INSERT INTO tpp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","K'imasunini an xatij jatsukunti, lhuw achati ak'ixt'a'niya'a akxni k'at'ana'a. ");
INSERT INTO tpp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Kint'ala'awnin, akila'asmatniwi yu aklajunaw laka lakxlak'anti chiwinti, an kimpayk'an David niylh chi maknukalh, chi anika tan t'awnawi aknuy. ");
INSERT INTO tpp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Chi an David ixlichiwiniy ixchiwinti Dios, chi ixk'atsayi li an Dios ixjurarlanita li reji ka'ilhtuya xapumatam yu yucha kapu'a'p'unmina'. ");
INSERT INTO tpp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Pus an David akxni jantuka' ixtapasayi li kala'awcho'oya an Cristo, yucha ixk'atsaycha li kala'awcho'oya', yucha lhichiwinilh akxni a najun li jantu katita'aknu'alhilh chi li jantu katilakp'uch'ilh. ");
INSERT INTO tpp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Chaway chun, an Dios mala'awnicho'olhcha an Jesús, chi kitnan kinchuxk'ani ikla'ts'iw li chuncha tapasalh. ");
INSERT INTO tpp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Akxni an Dios la'ayalhcha an Jesús chi ulachalhcha tan oxi ixpa'xti chi xta'nilhcha an Stalan'a ixTakuwin, yucha wanajcha chuni kintaxta'nin tacha xakintajuntan li akintaxta'niyan. Pus chaway yuch'ach'a t'ach'a ani la'ts'inat'it ch'i asmat'at'it. ");
INSERT INTO tpp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","An David jantu tu'u kilalh lakt'iyan, pero yucha najun: An Jamach'alhkat Dios juniy an kiJamach'alhkat: “K'at'a'ulhcha tan oxi kimpa'xti', ");
INSERT INTO tpp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","sta akxni ajkamama'oyacha an yu wa taxkayan la mijach'aja', para li k'ajap'ut'aycha.” ");
INSERT INTO tpp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Kint'a'israelitajnin chux uxitnan oxi k'ak'ats'at'it li ani Jesús an yu makxt'ukmuk'at'it laka cruz, an Dios ilhtulhcha Jamach'alhkat chi Cristo. ");
INSERT INTO tpp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Akxni chunchacha ta'asmatlhi an yu ancha ixta'ayxto'nun, sawalhcha tala'ta'oxila'alhilh, pus talhisakmilhcha an Pedro chi an ali'in ixjamala'achata an Jesús wachucha jalhisakmikalh, jajunkan: ―T'ala'awnin, ¿tisuncha lay ak'ilhtuwi? ");
INSERT INTO tpp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","An Pedro ja'alhtaylh: ―K'amak'a'unt'itcha mintala'alhink'an ch'i k'alaj'a'p'axt'itcha la ixta'a'ut an Jesucristo, para li an Dios katamala'mixinini mintala'alhink'an, walh laniy chuncha kataxta'niyani an Stalan'a ixTakuwin. ");
INSERT INTO tpp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mu para uxitnani tacha an najun an Dios li ka'ilhtuya', chi para mijas'at'anink'an chi para ixchuxk'an masi yu ma'at tawilananchalh chi wa tichi kawalhcha yu an Dios kajat'asaniya'. ");
INSERT INTO tpp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","An Pedro chunchacha ixjajuniy, chi lhuw ali chiwinti japuxa'alalh yu ixjapumap'a'siy, jajuniy: ―¡K'amak'a'unt'itcha tacha ani chaway wa tani t'awkancha, walh lani k'at'a'alht'axt'uya'it'it! ");
INSERT INTO tpp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pus yu ta'asmatnilhi an ixchiwinti, talaj'a'paxlicha. Anchunu wilhchan ka tacha la'at'utu milh lapanakni yu tat'atala'xto'lhicha an yu ixtakiklaka'iycha Dios. ");
INSERT INTO tpp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chi ixta'ilhtuycha sawalhi tacha an ixtamasuy an yu ixjamala'achata an Jesús, wa ixtalhawaxa'a'iycha yu ixtalaklhit'ajun, ixtata'ayxt'o'acha akxni ixtalakwajin chi akxni ixtatapayniy. ");
INSERT INTO tpp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ixchuxk'an an lapanakni ixtalaktalhanancha, wa xliyu li an yu ixjamala'achata an Jesús wanajcha lhuw tanlhuni ixtalakmasuy chi tanlhuncha yu wa tichicha lapanak jantu lay ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ixchuxk'an an yu ixtajakiklaka'inincha watami ixtak'atsay chi an ixlaktanlhunk'an wa sicha ixtalamach'inipaxay. ");
INSERT INTO tpp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ixtast'aycha ixlakaat'unk'an chi tanlhuncha yu ixtalaklhit'ajun chi atamj atamjcha tani chunchacha yu ixma'lhtask'iniy an tumin chunchacha ixtalamala'pitsiy. ");
INSERT INTO tpp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lhilhiji ixtata'ayxt'o'a an laka tajtan, chi an la ixla'cha'aninchak'an anchacha lhi'acha ixtalakwajin chi ixtalamapayniy sawalh. ");
INSERT INTO tpp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ayi ixtala'ts'in an Dios chi yu'uncha wachu oxi ixjala'ts'inkan, chux lapanaki oxi ixjalhiwilay, chi lhilhiji an Dios ali ali ixjat'amala'xt'o'a yu ixtajakiklaka'inincha, yu wachucha ixjama'alhtaxtuy. ");
INSERT INTO tpp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","La'atam wilhchan an Pedro chi an Juan ta'alh an laka tajtan, ta'alh tapayninin yu puta'oxay, las tres. ");
INSERT INTO tpp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Walh an tan ixputanukanachalh an laka tajtan ixwilh pumatam lapanak yu wa la'ch'anlh'awilh, wachunchacha tsukulh, lhilhiji ixtalhi'an chi ixta'ulaycha waniy laka maticha tan junkan k'usi, para li kajask'inilhcha la'a'tayjuni an yu ixtatanuy an laka tajtan. ");
INSERT INTO tpp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","An la'ch'anlh'awilh lapanak akxni jala'ts'ilhi an Pedro chi an Juan, li ixtatanut'awnachalhcha an laka tajtan jask'inilh li kataxta'nilh tumin tacha la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pus an Pedro chi an Juan wa sa'cha ixtala'pula'ts'in, chi an Pedro juniy: ―Akilala'ts'iw. ");
INSERT INTO tpp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pus an lapanak sa'cha ixjala'ts'in, yucha ixnajun li sna tu'ucha kataxta'niya'. ");
INSERT INTO tpp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero an Pedro juniy: ―Jantu tu'u iklhit'ajun plata chi oro, pero yu ani iklhit'ajun akxta'niyan, la ixta'a'ut an Jesucristo yu jamacha'a Nazaret, k'at'aycha chi k'ajalht'ancha. ");
INSERT INTO tpp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Akxni chunchacha junilh an Pedro an yu wa la'ch'anlh'awilh lapanak, ma'ch'apayawlhcha, yucha an yu oxi ixmaka ch'apanichalh. Walh watukan la'tach'an'oxilh, an la ixlakpixtu ixch'aja lakts'awalanilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ani lapanak yu wa la'ch'anlh'awilh ixjunita, wanajcha jalht'ujnulhi akxni t'ujcha tayalh chi tsukulhcha jalhtanan. Ixli'astan jat'atanulhcha an laka tajtan, la ixch'ajacha putanuchalh, ixjalht'ujnuncha chi oxicha ixlichiwiniy an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ixchuxk'an an yu tala'ts'ilh li ixjalhtanancha chi li oxicha ixlichiwiniy an Dios, ");
INSERT INTO tpp_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","sawalhcha ixtalaktalhanan chi sawalhcha ixtalhi'a'niya tacha an putapasalh an lapanak, mu ixtamispay chi ixtak'atsayi li yucha an yu ixtawlay an laka maticha tan junkan k'usi, an laka tajtan. Ixtak'atsayi li yucha an yu isk'in tu'u la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","An yu wa la'ch'anlh'awilh lapanak ixjunita jantucha k'is ixjamakajuni an Pedro chi an Juan. Chux an lapanakni mu sawalhcha ixtalhi'a'niy, talakats'alaj'alhi an la ixpa'xti an tajtan tan a'apacha'a'ikanta, tan tajuniy ma ix'anu Salomón, mu ancha ixtat'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","An Pedro akxni chunchacha jala'ts'in, jajuniy: ―Jamacha'an Israel, ¿tasu li sawalhch'a lhi'a'niyat'iti? ¿Tasu li wa kitnancha kilala'ts'inaw li tachanu kitnancha ijk'uch'u ani lapanaki, chi li tachanu kitnancha akmalhtanaw la ki'alhp'asnintik'an u la kijamapaynintik'ani? ");
INSERT INTO tpp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","An IxDiosk'an Abraham, chi Isaac chi Jacob, an IxDiosk'an yu ta ixjalhila'ts'inaw, yucha masut'ajun ixta'ayat an isTs'alh, yu junkan Jesús, an yu uxitnan ma'axt'a't'it laka lakjamach'alhkat chi uxitnan la'amaj'ant'iti akxni an Pilato ixnajuncha li kamakawna'. ");
INSERT INTO tpp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Akxni uxitnan k'a'isk'int'iti li kaxmakawkalhi an yu Stalan'a chi yu jantu tu'u ixtala'alhin ixlit'ajun, apalij sk'int'iti li kamakawkalh pumatam jama'nini'. ");
INSERT INTO tpp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ch'unch'ach'a ma'nit uxitnan an yu kintalhi'anan laka jatsukunti. Pero an Dios mala'awnicho'olh, chi kitnan ikla'ts'iw. ");
INSERT INTO tpp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tacha ani ta'oximaj'ayacho'olhi ani lapanak yu la'ts'inat ch'i misp'ayat, wa xliyu ijkiklaka'iyawi li an Jesús yucha layi k'uch'uy. Tacha ani oxi tak'uch'ulh ani lapanak yu la'ts'in'oyat'it, ancha puminachalh li kiklaka'ikan an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Pero chaway kit'in ijk'atsaycha kint'ala'awnin, akxni an milakjamach'alhkatk'an chi uxitnan ma'nit'it an Jesús, wa xliyu jant'u ixk'ats'ayat t'uch'ini ix'ilht'uyatcha. ");
INSERT INTO tpp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero an Dios chunchacha yu pumuktaxtulh yu ixnajunta li ka'ilhtuya'. Yu ixjamanawnita an lapanakni yu ma'anchacha, akxni ixtanajun li an ixCristo Dios, kaniya'. ");
INSERT INTO tpp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Xliyu chaway uxitnan k'amak'a'unt'itcha mintala'alhink'an chi k'ach'a'o'atcha an Dios, para li katamala'mixinini mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Chi chuncha, kachina panch'e'ex akxni k'ajast'aknana'it'it, yucha an Diosi katamast'ak'ayan, mu katamakminiyani an ixCristo yu para uxitnancha o'sliyan ixlimala'asijnikanta, yucha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Masi yu chaway tukan an lakt'iyanka katawlanta, sta akxni an Dios kalats'awala'oyacha an tanlhun, tacha an ixjamanawnitacha an la'stalan'an lapanakni yu ixtalhichiwiniy ixchiwinti Dios, yu ma'anchacha ixtat'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","An Moisés jalhixa'alalhi an yu ta ixjalhila'ts'inaw ma'anchacha, jajuniy: “An Dios miJamach'alhkatk'an ka'ilhtuya li aniya kala'awlh pumatam yu kalhichiwinina ixchiwinti Dios, tacha kit'in. K'ak'iklak'a'i'o'ot'iti wa tuchicha katajunan, ");
INSERT INTO tpp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","mu wa tichicha yu jantu katikiklaka'ilhi anchunu lapanak, an yu kamina lhichiwiniy ixchiwinti Dios, kamala'mixikana an tan tat'ajun ixlapanakni Dios”, chuncha nawlh a Moisés. ");
INSERT INTO tpp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Chi ixchuxk'an an tacha ixtalhichiwiniy ixchiwinti Dios, sta akxni ixt'ajun an Samuel chi yu tataylhi'alhcha ixtalhichiwiniy wachu, talhichiwinilhi tacha katapasaya ani panch'e'ex. ");
INSERT INTO tpp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Uxitnanch'a yu k'ala'a'iya'it an tacha nawlh an Dios li ka'ilhtuya'. Yu jamanawnilh an ixtalhichiwiniy ixchiwinti Dios. Chi uxitnanch'a yu k'ala'a'iya'it an tacha ixjat'atamakajunta an Dios an yu t'a ixjalhila'ts'inat'it, akxni an Dios junilh an Abraham: “Yu'uncha amijas'at'an yu katapu'a'p'un'anani katapulhitsukuya oxi jatsukunti ta kilhmakchux lapanak ani lakamunulhpa'.” ");
INSERT INTO tpp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Akxni an Dios mala'awnicho'olhcha an isTs'alh, uxitnani p'ulhnaj tamala'achanin, para li kataxta'nin oxi jatsukunti. Ta'ilhtuni li atamj atamj k'amak'a'unt'itcha mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","An Pedro chi an Juan chunchaka ixtalhixa'alat'ajun an lapanakni, walh tacha'alhcha an sacerdotejnin ali an xa'ay an yu ixtajalhistaknan an laka tajtan chi an saduceojnin. ");
INSERT INTO tpp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sawalhcha ixtala'talh'aman, mu an Pedro chi an Juan ixtamasuycha an ixchiwinti Dios chi ixtanajuncha li katala'awcho'oya an yu talaknitacha. Tacha an la'awcho'olh an Jesús, chunchacha kapuk'atsakalh li chuncha kala'awcho'okana'. ");
INSERT INTO tpp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jamalaklhchawkalhcha laka pulach'ini an Pedro chi an Juan, chi mu ta'oxaycha, tama'atunkuntanulhcha. ");
INSERT INTO tpp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero ixluwk'an an yu ixta'asmattacha an tacha ixtanajunta an Pedro chi an Juan, takiklaka'ilh. Katacha la'akisi milh lapanakni yu ixtajakiklaka'inincha. ");
INSERT INTO tpp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chi chunchunicha tapasalh akxni tunkunchalh, tata'ayxto'lhicha an la'acha'an Jerusalén an xalaj'ajin judiojnin, chi an laktatanincha chi an xamaestrojnin lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Chi ancha wachu ixt'ajun an xa'ay tukan sacerdote yu ixjunkan Anás, chi an Caifás, chi Juan, chi Alejandro chi ixchuxk'ancha an yu ta ixtala'lhila'ts'in an yu tukancha xalaj'ajin sacerdotejnin. ");
INSERT INTO tpp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Talhinawlhcha li kajalhi'anikalhi an Pedro chi an Juan. Pus ixtan'ajnichak'ani jayawkalh chi jalhisakmikalhcha, jajunkan: ―¿Tisiyuchacha tamakawniyan u la ixta'a'ut tisiyuchacha li ch'unch'ach'a ilht'uyat ani laktanlhuni? ");
INSERT INTO tpp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","An Pedro mu sawalhcha ixlit'ajuni an Stalan'a Takuwin, ja'alhtaylh jajuniy: ―Uxitnani jamach'alhkatni chi uxitnani laktatanin. ");
INSERT INTO tpp_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chaway kilalhisakmiyawcha ixlakata li ijk'uch'uw pumatam lapanak, yu wa ixta'an'ay chi li tasicha lhitak'uch'ulh. ");
INSERT INTO tpp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","K'ak'ats'a'o'ot'itcha, chi chux an xalapanakni Israel, la ixta'a'ut an Jesucristo jamacha'a Nazareti tak'uch'ulh. Yu makxt'ukmuk'at'it uxitnan laka cruz chi yu mala'awnicho'olh an Dios, yucha yu puta'oxilh ani lapanak chi aniya yalh. ");
INSERT INTO tpp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uxitnan yu tachanu ixyawnan cha'a la'amaj'ant'iti an Jesús yu tachanu la'atam chiwx, pero chaway yucha yu tukan apalij lhitapalay, yucha yu tukan ixtamp'in. ");
INSERT INTO tpp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Chi jantu xamati apumatami lay katijama'alhtaxtunulh, mu ta ixlijalhi'ay ani lakamunulhpa, an Dios jantu xamati apumatam lapanaki kintaxta'niyan yu lay akintama'alhtaxtun. ");
INSERT INTO tpp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wa chuncha akxni chunchacha tala'ts'ilh an jamach'alhkatni li an Pedro chi an Juan jantucha k'is ixtatalhanani ixtachiwiniy chi ixtak'atsaycha an jamach'alhkatni li an Pedro chi an Juan jantu ixtajatalaninin, pus sawalhcha ixtalhi'a'niy. Chi tak'atsaalhi li ixt'alhtanan an Jesús sawalhi yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Atumpaj an lapanak an yu ixtak'uch'uta, wachu ani ixjat'ayalh, pus jantucha layi ixtanajun an lapanakni li jantu sawalh. ");
INSERT INTO tpp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ixli'astan an Pedro chi an Juan jatamakxtukalhcha, wa siya yu'uncha an jamach'alhkatnicha ixtalakchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ixtalajuniy: ―¿Tasu kaja'ilhtuyawcha ani lapanakni? Mu chaway chux an yu tawilanalh Jerusalén tak'atsaycha li yu'uncha ta'ilhtulh ani lhi'a'nin jak'uch'unti, yu jantu wa xamaticha lapanak lay ilhtuy, chi jantu lay katinajuw li jantu sawalh. ");
INSERT INTO tpp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Para li jantucha ali kalajk'atsakalhi tacha ani tapasalh, kajala'me'e'swaw, para li sta chaway ati'anta jantucha ali katalhichiwinilhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pus wa chuncha jat'asanipalakalhi an Pedro chi an Juan, chi jajunikalhcha li jantucha k'is katamasulh chi li jantucha k'is katalhichiwinilhi an ixchiwinti Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero an Pedro chi an Juan taja'alhtayanalh tanajun: ―Pus uxitnancha akilajuniw, ¿an Dios chuncha oxi lhiwilay li uxitnancha aklakiklaka'iw chi yucha jantu? ");
INSERT INTO tpp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kitnan jantu layi jantucha aktinajuwi yu ikla'ts'intawcha chi yu ik'asmattawcha. ");
INSERT INTO tpp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pus wa chuncha an jamach'alhkatni, a'tamcha tame'e'swapalhi an Pedro chi an Juan laka chiwinti, ixli'astan jamakawkalhcha, mu jantu tu'u yu lay kajalhimama'alh'ajnikalh. Chi ixchuxk'an an lapanakni oxi ixtalhipast'ak'a an Dios wa xliyu tacha an ixtala'ts'intacha. ");
INSERT INTO tpp_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","An lapanak an yu ixputak'uch'uta la ix'alhp'asninti an Dios palaycha la'at'up'uxam k'ata ixpakxanta. ");
INSERT INTO tpp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Akxni jamakawcho'okalhcha an Pedro chi an Juan, tala'alhcha an ali'in ixt'alhtanank'an chi tat'alajun'olhcha tacha an tanawlh an xalaj'ajin sacerdotejnin chi an laktatanin. ");
INSERT INTO tpp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Chi akxni ja'alha'asmat'okalhcha an Pedro chi an Juan, wa ayxtamcha tatapayninilh an Dios, tajuniy: ―Dios, uxint'i Jamach'alhkatk'at'i, uxint'i ilht'u an lakt'iyan chi an lakaat'un, chi an alamalh chi wa tuchicha yu ancha lak'alin. ");
INSERT INTO tpp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","La ixkilhni an David yu ixt'atapatsayan mach'iwinit'i, an laka Stalan'a minTakuwini nawlh: ¿Tasu li tala'talh'amancha an lapanakni? ¿Chi tanlhuncha tatamakajun li kata'ilhtuya yu jantu lhitapalayi? ");
INSERT INTO tpp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","An rejnin chi an jamach'alhkatni ani lakaat'un, tala'talh'amancha chi wa tamcha tak'atsay, tat'alaxtukuycha an Dios chi an ixCristo. ");
INSERT INTO tpp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Sawalhi li an Herodes chi an Poncio Pilato aniya tatala'xto'lhi, ani la'acha'an, ali an yu jantu israelitajnin chi an yu israelitajnin. Tat'alaxtukulhi an Jesús, mima'tsuku', yu uxint'i sakxt'u li Cristo kawalh. ");
INSERT INTO tpp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Chunchacha yu'uncha tamuktaxtu'olh tacha an yu uxint'i ch'unch'ach'a ixli'ilht'ut'a li katapasalh. ");
INSERT INTO tpp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chawayi Jamach'alhkat Dios, k'alhak'ap'up'i tacha an kintala'me'e'swayan ch'i k'ajamak'awnini amima'tsukunin li jantu katalaktalhanalhi katalhichiwinilh aminchiwinti. ");
INSERT INTO tpp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","K'amasut'i ami'alhp'asninti, k'ajak'uch'ut'i an ta'an'anin chi k'amasut'i tanlhun yu wa lapanakcha jantu lay ilhtuy, la ixta'a'ut amima'tsuku', an Stalan'a Jesús, minTs'alh. ");
INSERT INTO tpp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Akxni tatapayni'olhcha, an tan ixta'ayxto'nun, laklalh. Chi ixchuxchak'ani alhp'as jala'cha'alh an Stalan'a Takuwin. Chi jantucha ixtatalhanani ixtalhichiwiniy an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ixchuxk'an an yu ixtajakiklaka'inincha wanajcha ixluwk'ani ixtajunita chi wa tamcha ixtajatapastaknan chi wa la'atamcha tak'atsaani ixtalhit'ajun. Jantu xamati ixnajun li wa ix'akstucha ixnawin ixtanlhun, ancha wa siya ix'anunchak'an. ");
INSERT INTO tpp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","An yu ixjamala'achata an Jesús palaycha alhp'as ixtalhichiwiniy li la'awcho'olhi an Jamach'alhkat Jesús, chi an Dios ixchuxk'ani sawalhcha jalakmapaynilh. ");
INSERT INTO tpp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jantucha xamati yu yu'uncha tu'u ixma'lhtask'iniy, mu an yu ixtalaklhit'ajun ixlakaat'unk'an chi ixcha'ak'an, ixtast'aycha chi an tumin ");
INSERT INTO tpp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ixtaxta'niycha an yu ixjamala'achata an Jesús. Para li katamala'pitsilhcha, tanichunchacha ixtama'lhtask'iniy atamj atamj. ");
INSERT INTO tpp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pumatam levita yu ixjunkan José, jamacha'a Chipre, yu talhimapa'a'upalh an yu ixjamala'achata Jesús ma Bernabé, nawputun ists'alh yu jama'oxamixinin, ");
INSERT INTO tpp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","yucha ixlit'ajun la'atam ixlakaat'un, walh st'alh chi an tumin jaxta'nilhcha an yu ixjamala'achata an Jesús. Para li yu'unchacha katala'ts'ilh tani katalhimala'pitsilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero ixt'awpalay pumatam lapanak ixjunkan Ananías yucha wachu st'alh ixlakaat'un ali an ixt'iwi ixjunkan Safira. ");
INSERT INTO tpp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ani lapanak, wa tamcha t'ak'atsaalh an ixt'iwi', taxa'a'ilhcha tachuni an tumin chi an ali tama'axta'nilhcha an yu ixjamala'achata an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","An Pedro juniy: ―Ananías, ¿tasu li mak'awnincha an Satanás li yuchacha kajunin t'uch'ini k'a'ilht'ucha, ch'i maslak'at'ijwat'icha an Stalan'a Takuwini? Uxint'i xa'a'it'i an ali tumin an yu map'alhnik'a ixlakata an lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Chu jantu milakaat'uni ixjunita? Ch'i li st'at'icha, ¿an tumin jantu mi'anuncha ixjunita? ¿T'asu li ch'unch'ach'a p'ast'akt'i k'a'ilht'u? Jantu yu an lapanakni ja'o'xch'o'oy, yucha an Diosi o'xch'o'oy. ");
INSERT INTO tpp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Akxni chunchacha asmatlhi an Ananías, alo'cha ta'a'talh chi nilhcha. Chi ixchuxk'an an yu tak'atsaalh, sawalhcha talaktalhanalh. ");
INSERT INTO tpp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wa chuncha tichi yu'uncha ts'alan, tala'apamililhcha an janini chi ta'alhcha maknunin. ");
INSERT INTO tpp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pants'ik'ischa walh katacha la'at'utucha hora la'pusli tanuchalhcha an ixt'iwi an Ananías, jantu ixk'atsayi tuchini tapasalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","An Pedro lhisakmilh juniy: ―¿Ch'unch'a lhist'at'it an lakaat'un t'ach'a an nawnat'it? Ak'i'un. An t'aku ja'alhtayanalh najun: ―Chun, wa chuncha iklhist'aw. ");
INSERT INTO tpp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","An Pedro juniy: ―¿Tasu li wa t'amch'a k'ats'ayat para li k'alhila'ts'int'anutcha an ixTakuwin Diosi? Anucha tamincho'ota an yu takimaknulh amint'apapa', chaway uxint'icha katalhi'anan wachu'. ");
INSERT INTO tpp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wanaj wa akxni an Safira alo'cha ta'a'talhi la ixjach'aja an Pedro. Pus akxni tatanuchalhcha an ts'alan, tala'ts'in nitacha. Pus ta'alhcha maknunini la ixpa'xti an tan takimaknulh an ixt'apapa'. ");
INSERT INTO tpp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Chi ixchuxk'an an yu ixtajakiklaka'inincha, chi ixchuxk'an an lapanakni an yu tak'atsaalh tacha an tapasalh, sawalhcha ixtalaktalhanan. ");
INSERT INTO tpp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lhuw tanlhun yu jantu watichicha lapanak lay ilhtuyi ixjapu'ilhtukan an yu ixjamala'achata an Jesús chi lhuw tanlhuni ixjamasunikan an lapanakni. Chi wa lakatami ixtata'ayxt'o'a an tan ix'a'apacha'a'ikanta tajtan, tan ixjunkan ja'a'apacha'a'inti yu ix'anu Salomón. ");
INSERT INTO tpp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","An akilhmaktamin lapanakni, jantu k'is xamati ixjat'atala'xto'putun an yu ixtajakiklaka'inincha, pero sawalh oxi ixjalhiwilakan. ");
INSERT INTO tpp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Chi ali tatalhawalhi yu tajakiklaka'inilhcha, takiklaka'ilhi an lapanakni chi an t'akunin. ");
INSERT INTO tpp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Chi an ta'an'anin ixjamamakancha an laka lajcalle la ixputamatk'an, para li akxni kala'pusacha an Pedro masi wa ixma'stele'cha kala'cha'alh xapumatam. ");
INSERT INTO tpp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Tanlayjcha la'acha'anaxni yu wanicha ixlaklhitamakajun an la'acha'an Jerusaleni ixtalakminachalh an lapanakni, ixtalaklhicha'ancha an ta'an'anin chi yu wa ixtala'apaxto'tacha tanlhun lakmakxkay'un chi ixchuxchak'ani ixjak'uch'ukan. ");
INSERT INTO tpp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","An yu xa'ay tukan sacerdote chi ixchuxk'an an yu ixtach'a'o'ay, an yu ixjajunkan saduceojnin, tala'talh'amalhcha, t'ilhcha ixtala'ts'in, ");
INSERT INTO tpp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","pus jach'apayawkalhcha an yu ixjamala'achata an Jesús chi jamalaklhchawkalhcha lakatam laka pulach'in tan wa para tichicha. ");
INSERT INTO tpp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero pumatam ix'angelh an Dios malhti'alhi an xamalhticha an pulach'in akxni puts'ista ixjunita chi jamaxtulh, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―K'ap'inchi'it an laka tajtan, ancha k'aja'una'it an lapanakni chux ani chiwinti yu xt'a'a jatsukunti. ");
INSERT INTO tpp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Akxni chunchacha ta'asmatlhi, tunkunchalh wats'isin, tatanuchalhcha an laka tajtan chi tsukulhcha tamasuy. Wa chuncha, an xa'ay tukan sacerdote chi an yu ixtach'a'o'ay, tat'asanilhi ixchuxk'an an xalaktatanin israelitajnin, chi talhinawlhcha li kaja'ankalhcha maxtuka an laka pulach'in. ");
INSERT INTO tpp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero akxni tacha'alhcha an laka pulach'in an yu ixtajalhistaknan, jantucha tu'u ixtatanumanalh. Pus ta'ancho'olh chi takijamak'atsaaninilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Tanajun an yu ixtajalhistaknan: ―An pulach'in oxi ixlaklhchajuy akxni ikcha'aw, chi an soldadojnin an ixlakapu an malhticha tajalhistaknanta. Pero akxni ikmati'awcha, jantu xamati ikla'cha'aw pulakni. ");
INSERT INTO tpp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Akxni chunchacha asmatlhi an xa'ay an yu ixtajalhistaknan laka tajtan chi an xalaj'ajin sacerdotejnin ixtanajun: ―¿Tisu katapasayacha li tacha anicha talayi? ");
INSERT INTO tpp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wa chuncha pumatam jala'cha'alh chi jajuniy: ―An yu ixjamalaklhch'awt'at'it laka pulach'in, an laka tajtani tamasunit'ajun an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Pus an xa'ay an yu ixtajalhistaknan laka tajtan jat'a'alhi an yu ixtat'ajalhistaknan, ta'alhcha puxkawnin, pero jantu talhitama'chapulh, mu wachu ixtatalhanani li an lapanakni katatalh'amalh chi kajalakt'alhmakalh. ");
INSERT INTO tpp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Akxni jalhicha'ankalhcha an yu ixjamala'achata an Jesús, jalhi'ankalhcha la ix'ukxlakapuk'an an xalaj'ajin sacerdotejnin chi an yu xa'ay sacerdote jajuniy: ");
INSERT INTO tpp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Kitnan klajuniwcha li jant'uch'a k'is k'amasut'iti ixchiwinti an Jesús, walh chi uxitnan wanajcha ta ixlijalhi'ay an la'acha'an Jerusaleni lakmasut'at chi kitnancha kilalhimuk'aputunaw li ma'nikalh an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","An Pedro chi an ali'in an yu ixjamala'achata an Jesús, taja'alhtayanalh: ―Kitnan kilhi'ilhtutk'ani li ajkiklaka'iwi an Dios, yucha p'ulhnaj ajkiklaka'iyaw, jantu yu an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","An ixDiosk'an an yu ta xajkalhila'ts'inaw mala'awnicho'olhi an Jesús, yuch'a an yu ma'nit'it uxitnan akxni muk'at laka cruz. ");
INSERT INTO tpp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","An Dios ma'ostayanicho'olh chi tan oxicha ixpa'xti ulachalh, chi chaway yuchacha ilhtuta li akintatap'ulhnin chi akintama'alhtaxtun, para li an kint'a'israelitajnink'an katakiklaka'ilhi an Dios chi chuncha kajamala'mixinikana ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tacha ani laktapasay kitnan ijk'atsayaw chi wachu k'atsayi an Stalan'a Takuwin, yu an Dios jaxta'niy yu takiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Akxni chunchacha ta'asmatlhi, sawalhcha talhitalh'amalh chi ixjama'niputunkancha an yu ixjamala'achata an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero xapumatam an jamach'alhkatni yu ixjunkan Gamaliel yucha an yu ixjajunkan li fariseojnin, tayalh chi lhinawlh li kajamaxtukalhka tam pants'ik'is ma'spa an yu ixjamala'achata an Jesús. Ani lapanak sawalh ixtakiklaka'iya an lapanakni, mu xamaestro wachu lhamap'a'sini ixjunita. ");
INSERT INTO tpp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jajuniy an ali'in ixt'ajamach'alhkatni: ―Kint'a'israelitajnin, k'ajalajk'ats'anant'iti t'ani ja'ilht'up'ut'unat'itcha ani lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","K'ap'ast'akt'iti li tawananchacha ixjuntachalh ixt'ajun yu Teudas ixjunkan, yu ixnajun li ixlitapalay lapanak, chi katacha la'at'at'i ciento lapanakni yu wa tamcha ixtat'ak'atsay. Pero an Teudas ma'nikalh, chi an yu ixtach'a'o'ay tatalaktilh'olh, pus wa chuncha yu kiputamaktalh. ");
INSERT INTO tpp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ampalh wilhchan akxni an isakkan censo, ixt'awpalay pumatam lapanak yu an ixjunkan Judas, jamacha'a Galilea chi wachu tach'a'o'alhi ali'in. Pero ixli'astan wachu ma'nikalh, chi ixchuxk'an an yu ixtach'a'o'ay tatalaktilh'olh. ");
INSERT INTO tpp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pus yu chaway kit'in klat'alajunaw li k'ajamak'a'unt'iti ani lapanakni, jant'u t'ani k'aja'ilht'ut'it. Mu li ani yu tala't'ajun wa ix'anuchak'an an lapanakni, wa kala'pusa'. ");
INSERT INTO tpp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero li Diosi jalhijuniy, jant'u lay k'at'ijalhajat'it. K'ajalajk'ats'anant'it, jantu junita Dioscha t'alasat'awnat'it. Pus wa chuncha an ixt'ajamach'alhkatni takiklaka'ilh. ");
INSERT INTO tpp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Chi ixli'astan jat'asanicho'okalhcha an yu ixjamala'achata an Jesús, chi stakcha ja'ayna'kalh chi jajunikalhcha li jantucha ali katalhichiwinilhi ixchiwinti an Jesús, chi wa chuncha jamakawkalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","An yu ixjamala'achata an Jesús sawalhcha ixtalaj'achani akxni tataxtulhcha an tan ixtawilanalh an jamach'alhkatni. Wa xliyu an Dios ja'ilhtulhi li katat'acha'alhi li kajalhimama'alh'ajnikalh ixlakata an ixta'a'ut Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Chux wilhchani ixtamasuy chi ixtalhichiwiniy an Jesús yu Cristo. Ixtalhichiwiniya an laka tajtan chi lakatamincha laka lakcha'a'. ");
INSERT INTO tpp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Anchunu panch'e'ex, mu an yu ixtajakiklaka'inincha palay palay ixtatalhaway, an yu lhigriego ixtachiwiniy tsukulhcha tat'alalhichiwiniya an yu lhihebreo ixtachiwiniy. Ixtanajun an yu lhigriego ixtachiwiniy li ma an yu jantucha tu'u ixt'apapak'an t'akunin, an yu griegajnin, ma jantucha oxi ixjaxta'nikan an tanlhuncha yu ixjamala'pitsinikan la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wa chuncha an ixpumakawt'uyk'an yu ixjamala'achata an Jesús, tama'ayxto'olhi ixchuxk'an an yu ixtajakiklaka'inincha chi tajuniy: ―Jantu oxi xajachalh li kitnan jantucha ali aklhichiwiniwi an ixchiwinti Dios wa xliyu li wa akmala'pitsiwcha an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pus chawayi kint'ala'awnin, iklajunaw mu milhuwk'an k'ajap'uxk'a'ut ixpumatujunk'an lapanakni yu de uxitnan yu jalhiwilayat li oxi katatapatsalh chi yu oxi tajalakpastaknan chi yu lhuw talhit'ajun an Stalan'a Takuwin. Para li yu'unchacha ajkama'axta'niw li kata'ilhtulh ani tapatsat. ");
INSERT INTO tpp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kitnan aktaylhi'anawi aktapayniyaw chi aklhichiwininaw an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pus ixchuxk'ani an lapanakni oxi talhiwilalh. Chi tasakxtulhcha an Esteban yu sawalhcha ixlit'ajun an Stalan'a Takuwin chi sawalh ixjakiklaka'inin, chi tasakxtulhcha an Felipe chi Prócoro, chi Nicanor, chi Timón, chi Parmenas chi Nicolás, pumatam jamacha'a Antioquía, yu wa junlhi judio. ");
INSERT INTO tpp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Wa chuncha jalhi'ankalhcha tan ixtat'ajun an ixpumakawt'uyk'an an yu ixjamala'achata an Jesús chi yu'uncha talhitapaynilhcha chi tamo'slanilhcha ixmakak'an an ixpumatujunk'an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","An ixchiwinti Dios palaycha ta'a'pitsilh, chi an yu ixtajakiklaka'inincha palaycha ixtatalhaway an Jerusalén. Chi ixluwk'an masi an yu sacerdotejnin ixtajunita takiklaka'ilhcha wachu'. ");
INSERT INTO tpp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","An Esteban sawalhcha ixlit'ajuni an ix'alhp'asninti Dios chi an ixjamapayninti. Pus tanlhuncha lay ixlak'ilhtuy chi layi ixjalakmasuniy an lapanakni ix'alhp'asninti an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ixta'alin lapanakni yu ixtalhitapa'a'uy Jama'alhtaxtukantacha, wa lakatami ixtata'ayxt'o'a. Wa chuncha yu'uncha, ali ali'in an jamacha'an Cirene chi jamacha'an Alejandría chi yu jamacha'an Cilicia chi yu jamacha'an Asia, tsukulhcha tat'alaxtukuyi an Esteban. ");
INSERT INTO tpp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero jantu lay ixtalakatast'uk'a, mu yucha, yucha an jatapast'ak'at an yu ixta'niy an Stalan'a Takuwini ixpuchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pus ani lapanakni tatamaw'ilh tichi yu'uncha lapanakni para li katanawlhcha li an Esteban ta'alha'asmatta tan wa aya lhichiwiniy an Moisés chi an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Chunchacha lay tapuma'talh'amalh an lapanakni, chi an laktatanin chi an xamaestrojnin lhamap'a'sin. Pus an Esteban tatayla'alhcha chi tach'apayawlhcha, talhi'alhcha la ix'ukxlakapuk'an an ixjamach'alhkatk'an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Atumpaj tapuxkawlhcha yu katamaslakatinilh, yu tanawlh: ―Ani lapanak wa lhilhijcha wa aya lhichiwiniy ani stalan'a tajtan chi an lhamap'a'sin. ");
INSERT INTO tpp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ik'alha'asmat'awi li ma an Jesús an jamacha'a Nazaret ma kalakt'ilhiya ani tajtan chi ma kamapaxa'oya an tanlhuncha yu lhismanitawcha ilhtuyaw yu kintamakawnin an Moisés. ");
INSERT INTO tpp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","An jamach'alhkatni chi ixchuxk'an an yu ancha ixtawilanalh, akxni ta'ukxpula'ts'ilh an Esteban, wa tacha wa ix'ukxpucha angelhi ixjunita. ");
INSERT INTO tpp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Chi an yu tukancha xa'ay sacerdote lhisakmilhcha an Esteban, junkan an Esteban li sna sawalhcha tacha an ixtalhichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Pus yucha ja'alhtayanalh, jajuniy: ―T'ala'awnin, chi xalakpaynin, akila'asmatniw: An yu ay Dios sawalh talakasunilhi an kimpayk'an Abraham, akxni ixt'ajun an xalakaat'un Mesopotamia, akxni jantuka' ix'an tawlhna la'acha'an Harán, ");
INSERT INTO tpp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","chi junilh: “K'at'axt'ucha, chi k'amak'awcha amilakaat'un chi an yu t'a jalhila'ts'in, an tan akmasuniyancha lakaat'uni k'ap'inchi'.” ");
INSERT INTO tpp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pus wa chuncha an Abraham taxtulhcha an xalakaat'un Caldea chi alhcha tawlhna Harán. Ixli'astan nilhcha an ixpay, chi an Dios anicha lakaat'uni lhimilh an Abraham, tan chaway uxitnan aniych'a wilat. ");
INSERT INTO tpp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero an Dios jantu tu'u xta'nilh an Abraham ani lakaat'un, masi tan wa katach'atalhcha. Pero an Dios junilhi an Abraham li kaxta'niya ani lakaat'un para li akxni kaniyacha. Yu tacha jalhila'ts'ini ix'anuk'an kajuna', masi akxni an Abraham jantuka' tu'u ixjas'at'an ixjalhit'awnikan. ");
INSERT INTO tpp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Atumpaj, an Dios juniy an Abraham li an yu ta kajalhila'ts'ina katatawla lakatam lakaat'un tan jantu ix'anuk'an. Chi wa kastakcha japutapatsakana', la'at'at'i ciento k'ata wa kastakcha jalhitama'chapukana'. ");
INSERT INTO tpp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero an Dios jumpalay wachu: “Pero kit'in ajkamama'alh'ajniya anchunu lapanakni yu wa kajaputapatsayacha amijas'at'an, chi ixli'astan katataxtuyantacha chi anicha akintat'atapatsaya'.” ");
INSERT INTO tpp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","An Dios t'atamakawlhi an Abraham li an lapanakni kajalak'akaxwililich'uk'up'uxkana'. Pus xliyu akxni la'tsalhcha la'atsajin wilhchan ixt'ajun an Isaac, ists'alh an Abraham, yucha akaxwililich'uk'up'uxlicha. An Isaac, wanajcha chuni ilhtulh yu ists'alhcha, ixjunkan Jacob, chi an Jacob wanajcha chuni ja'ilhtulh ists'alan, yu'uncha yu tawalhcha xapaynin an kilhmakkawt'uy lapanakni yu israelitajnin. ");
INSERT INTO tpp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ani ists'alan an Jacob, yu xapaynincha ixtajunita, taxkaylhi an xapumatam ixt'ala'ajunk'an yu junkan José, pus tast'amaka'alhcha xalakaat'un Egipto. Pero mu an Dios ixlistakta an José, ");
INSERT INTO tpp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","pus ma'osuni'olhi chux an ixma'alh'ajnat. Chi xta'nilhi oxi jatapast'ak'at, chi an Dios ilhtulhi li an Faraón oxi kalhiwilalh an José, mu yucha rey ixjunita an Faraón an xalakaat'un Egipto. Chi an Faraón ilhtulhcha an José li kawalh ay jamach'alhkat an xalakaat'un Egipto chi malhistaknilhcha an la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Walh anchunu panch'e'ex alilhcha chawan chi ay lhima'alh'ajna, ta ixlijalhi'ay an Egipto chi an xalakaat'un Canaán, jantucha tu'u ixtalhit'ajun yu kata'ulh an yu ta ixjalhila'ts'inaw. ");
INSERT INTO tpp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero akxni k'atsaalhi an Jacob li an Egipto ix'alini yu ukan, jamala'achalhi an ists'alan, an yu ta ixjalhila'ts'inaw ma'anchacha. Akxnicha yu p'ulhnajcha ma'at tajalhtanalh. ");
INSERT INTO tpp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Akxni ixlipu'a't'uycha takilalh Egipto an ixjat'ala'awnin an José, jajunilhcha li yucha ixt'ala'ajunk'an. Pus an Faraón k'atsaalhi tanchuncha ixmintachalh an José. ");
INSERT INTO tpp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ixli'astan, an José lhinawlhcha li an ixpay, yu junkan Jacob chi ixchuxk'an an yu ta jalhila'ts'in kata'alhcha xalakaat'un Egipto. Ixpumat'utump'uxamkawkisik'an lapanaknicha ixtajunita. ");
INSERT INTO tpp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pus chunchacha yu pu'alhcha tawlhna xalakaat'un Egipto an Jacob, chi anchacha nichalh, chi an kilakpaynink'an wachu'. ");
INSERT INTO tpp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","An ixlakatunaj an Jacob chi an ali'in, la'acha'an Siquemcha jalhi'ankalh. Anchacha jamaknukanchalh, lakatam tan ixlamaknukan, tan an Abraham tachun laka tumini ixjalhitamawnita an ists'alan tichiyucha lapanak yu ixjunkan Hamor, an Siquem. ");
INSERT INTO tpp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Akxni wanicha ixchint'ajun wilhchan tacha an ixt'atamakajunta an Dios an Abraham li ka'ilhtuya, an kilapanaknik'an ixtatalhawatacha an xalakaat'un Egipto. Wanajcha ixluwk'ani ixtajunita. ");
INSERT INTO tpp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Chi akxni, tsukulhcha ch'alhkatnan pumatam rey an Egipto yu jantu ixmispay an José. ");
INSERT INTO tpp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ani rey wa ja'o'xcho'olhi an kilapanaknik'an chi stakcha jalhitama'chapulh. P'asi jajunilh li katamakawlhi ixjas'at'ank'an yu wa ixtat'ajunka chi li kachajcha tanilh. ");
INSERT INTO tpp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ani panch'e'ex, akxni tsukulh a Moisés. Sawalhcha k'usi jas'at'a ixjunita, chi an ixpaynin wa la'at'utu malhkuyu talhistaklhi la ixcha'ak'an. ");
INSERT INTO tpp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Akxni takimakawjulhcha laka canasta an lakxkan, an istsi an Faraón makutulh, pus lhi'alh chi yuchacha la'ayalh tachanu ists'alhcha. ");
INSERT INTO tpp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Chi chunchacha a Moisés tamatalaninilhcha la ixjatapast'ak'atk'an an jamacha'an Egipto, pus sawalhcha alhp'asi walh la ixchiwinti chi laka laktanlhuncha yu ixlak'ilhtuy. ");
INSERT INTO tpp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Akxni t'up'uxamcha k'ata lhitsukulh an Moisés, pastaklhi li ka'alh jala'pixiyalhna an ixjat'ala'awnin israelitajnin. ");
INSERT INTO tpp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pero akxni la'ts'ilhi li pumatam yu jamacha'a Egipto, wa stakcha ixlitama'chaput'ajun pumatam yu israelita, an Moisés lhi'a'tayjulh, ma'nilhi an yu jamacha'a Egipto. ");
INSERT INTO tpp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Wa xliyu an Moisés ixpast'ak'a li an ixjat'ala'awnin israelitajnin katalhimacha'xalhi li yucha kajapuma'alhtaxtuya an Dios, pero yu'uncha jantu talhimacha'xalh. ");
INSERT INTO tpp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tunkunchalh, a Moisés jala'cha'alh ixt'uyunk'an ixt'a'israelitajnin ixtala'ayt'ajun chi yucha jalamamakawniputulh, para li wa oxicha katalalhi'alh, jajuniy: “Uxitnan lhit'ala'awnin. ¿T'asu li wa lalhit'ama'ch'ap'up'axayatcha?” ");
INSERT INTO tpp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wa chuncha an yu wa ixlitama'chaput'ajun an pumatam, jatisamaj'analh, tisamaj'ankalhi an Moisés chi junkan: “¿Tisi yuchacha ulan milhijuez u li xa'aych'a k'a'unt'i, para li akilalaj'aymawcha? ");
INSERT INTO tpp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Sna wach'u k'ima'nip'ut'un, t'ach'a ama'nit'i an jamacha'a Egipto kutanchacha?” ");
INSERT INTO tpp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Akxni chunchacha asmatlhi an Moisés oslicha, alhcha xalakaat'un Madián. Anchacha ma'tawlhchalh chi jalhitsukunikanchalhcha ixt'uyunk'an ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’T'up'uxamcha k'ata la'pusli, tanchun lakak'iwin, waniy a'stitawk'a yu junkan Sinaí, talakasunilh pumatam angelh, akxni ixma'tajita la'atam jach'itin, an laka jikmi ancha talakasulh an angelh. ");
INSERT INTO tpp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A Moisés lhi'a'nilhcha tacha an la'ts'ilh, chi akxni palaycha stalh alh para li palaycha oxi kala'ts'ilh, alha'asmatlhicha chiwinilh an Dios, tan najun: ");
INSERT INTO tpp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Kit'ini ixDiosk'an an yu t'a ixjalhila'ts'in, kit'ini ixDios an Abraham chi an Isaac chi Jacob.” Wa chuncha an Moisés tsukulhcha jaxk'ip'ip'itnin la ixtalhanti, jantucha ixlaka'amputuni an tan ixma'tajita. ");
INSERT INTO tpp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pus an Dios juniy: “K'alakch'ant'axt'u amiwarachi, mu an t'an yat'i stalan'a lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Oxi kla'ts'in tacha tama'alh'ajnan an kilapanakni, an yu tat'awnachalh xalakaat'un Egipto, ik'asmat'a tacha tachiwiniy li tama'alh'ajnan, pus chaway ikta'alhtajuta para li ajkalhi'a'tayjulh. Chaway, k'at'at'icha, akmak'anani xalakaat'un Egipto.” ");
INSERT INTO tpp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Masi yu'uncha wa ixtala'amaj'anta a Moisés akxni an tajunilh: “¿Tisiyuchacha ulan uxint'i milhijuez u li xa'aych'a k'a'unt'i?” An Dios mala'achalhi tachanu xa'ay chi tachanu jama'alhtaxtunu a Moisés, yucha an angelh an yu talakasunilh tan ixma'tajita jach'itini t'amala'achalh. ");
INSERT INTO tpp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yucha a Moisesi jakimaxtulh an xalakaat'un Egipto an yu ta ixjalhila'ts'inaw. Pero anchunu xalakaat'un Egipto, a Moisés, ixlip'ulhnaj tanlhun yu la'lhi'a'nin tu'u ilhtulh, yu jantu wa xamaticha lapanak lay ilhtuy. Chi an alamalh tan junkan Slapulh Alamalh chi an lakak'iwin akxni t'up'uxam k'ata ancha ixtat'ajun, wachu lhuwi lak'ilhtulh tanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ani Moisés yucha yu jajunilh an israelitajnin: “An Dios ka'ilhtuya li yu de uxitnan, katsukulh pumatam yu kalhichiwinina an ixchiwinti, tacha kit'in.” ");
INSERT INTO tpp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Chi akxni an jamacha'an Israel wa lakatami ixtat'aw'ojoy an lakak'iwin, an angelh wanajcha yu an Moisesi yu ixa'alay an a'stitawk'a tan junkan Sinaí. Chi ancha wachu ixtat'ajun an kilakpaynink'an, yucha ani Moisesi yu la'a'ilh an chiwinti yu xt'a'a jatsukunti para li akintajunancha. ");
INSERT INTO tpp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero an kilakpaynink'an ixtajunita, jantu takiklaka'iputulh, wa tala'amaj'alh, tak'uxa'ancho'olhi xalakaat'un Egipto. ");
INSERT INTO tpp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tajuniy an Aarón: “Akila'ilhtuniw dios yu akintatap'ulhnin, mu jantu ijk'atsayaw tani lalhcha a Moisés an yu kintamaxtucha'an Egipto.” ");
INSERT INTO tpp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Pus wa chuncha akxnicha tala'oxilh la'atam yu tacha ixdioschak'an tala'ts'ilh, jas'at'a toro chi tama'ninilhcha lhuw jatapakxat. Talha'ulananilhcha chi ta'ilhtulhcha la'atam k'atan ixlakata an ixdiosk'an yu jas'at'a toro yu wa yu'unchacha tala'oxilh. ");
INSERT INTO tpp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Chi tacha anicha tatapasalh, an Dios jamakawlhcha, chi jamakawnilhcha li tacha ixdioschak'ani katala'ts'ilh an st'akunin an yu tawilananchalh lakt'iyan. Tacha an najunta an tan ts'o'muk'akanta la ixlibrojk'an an yu ixtalhichiwiniy ixchiwinti Dios, tan najunta: Israelitajnin, ¿chu sna kit'ini kilama'niniw jatapakxat chi kilaja'ulananiw akxni ixt'awnat'it t'up'uxam k'ata an lakak'iwin? ");
INSERT INTO tpp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Li mu jantu, uxitnan yuch'a p'as lhak'ap'up'it an ixcha'a midiosk'an Molok chi an ist'aku an midiosk'an Renfán chi an yu wa uxitnanch'a jalak'ilht'ut yu tacha midioschak'an jala'ts'inat. Chaway xliyu uxitnan aklamak'anawi palay awint'i la'puskan la'acha'an Babilonia. ");
INSERT INTO tpp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’An kilakpaynink'an ixtajunita ixtalhit'ajuni an lakak'iwin an tabernáculo, yu ixpuma'akanta an tan ts'o'muk'akanta an lhamap'a'sin. Chi ani tabernáculo ts'ajwi ixla'oxikanta tacha lhijunilh an Dios a Moisés. An Dios yucha lhijunilh a Moisés li kala'oxilhi an tabernáculo ixt'atam tukan tacha masunilh. ");
INSERT INTO tpp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","An kilakpaynink'an ixtajunita tajama'tayanalhi ani tabernáculo. Chi an yu tat'a'alhcha an Josué ixtalhi'anta akxni tamaxtulh an ixlakaat'unk'an an akilhmaktamin lapanakni, yu an Dios jamakawnilh an kilakpaynink'an. Ancha ixtalhit'ajun an tabernáculo sta akxni ixt'ajun an David. ");
INSERT INTO tpp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Chi an Dios oxi la'ts'ilh an David chi an David sk'inilhi an ixDios Jacob li kaxta'nilhi tan kala'oxinilh ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero yucha an Salomoni yu la'oxinilh ixcha'a an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Masi an Dios yu wilhchalh lakt'iyan, jantu wa laka cha'acha yu wa lapanaknicha tala'oxiya putawlay. Tacha nawlh an yu ixlichiwiniy ixchiwinti Dios: ");
INSERT INTO tpp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","An lakt'iyan yucha kimputawlan, chi an lakaat'un yucha ikputach'atay. ¿Tanyucha cha'a yu akilala'oxiniyawi?, najuni an Dios. ¿Tanischa tan ajkastaknana'a? ");
INSERT INTO tpp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Kit'ini iklak'ilhtu'olh chux an tanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Chi jajumpalay an Esteban: ―Uxitnan wa minchunchachak'ani jant'u k'is ja'asmatnanat'it, uxitnan lhit'awnat mi'a'ax'olhk'an chi mijalhunutk'an yu jant'u p'ak'iklak'a'ininat'it. Wa lhilhijch'a t'alaxt'uk'uyat an Stalan'a Takuwin. Wa mijalakt'atamchak'ani amilakpaynink'an ixtajunita. ");
INSERT INTO tpp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿An yu ixtalhichiwiniy ixchiwinti Dios, tisiyu'unchacha yu jantucha talhitama'chapulh amilakpaynink'an ixtajunita? Amilakpaynink'an yu'uncha tala'ma'nilh an yu ixtalhichiwiniy li kamina yu ts'awj katsukuya lapanak, chi chaway li kilachilhcha, uxitnan o'xch'o'ot'it ch'i ma'nit'it. ");
INSERT INTO tpp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Uxitnan li yucha an angelhnini p'u'unk'anat'it an lhamap'a'sin, jant'u k'iklak'a'iyat'it. ");
INSERT INTO tpp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Akxni chunchacha ta'alha'asmatlhi an Esteban, tala'talh'amalhcha, wa xwat'at'acha ixtalaktasat'ajun, ixtaxkajiycha an Esteban. ");
INSERT INTO tpp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero an Esteban, mu sawalhcha ixlit'ajuni an Stalan'a Takuwin, yucha tala'st'alh chi la'ts'ilhi tacha an xlimj junita an Dios, chi an Jesús tan oxicha ixpa'xti an Diosi sa' ixyalh. ");
INSERT INTO tpp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pus an Esteban najun: ―¡Jo', k'ala'ts'int'it! An lakt'iyan lhti'ay, chi an isTs'alh Lapanak tan oxicha ixpa'xti an Diosi yachalh. ");
INSERT INTO tpp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero yu'uncha t'ak'alhcha jalak'akatuch'apakalh, chi p'ascha talakt'asalh, tatayla'alhcha an Esteban. ");
INSERT INTO tpp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tamaxtulhcha an la'acha'an an Esteban, chi talakat'alhmalhcha. An yu ixta'alhtasuy an Esteban tamalhistaknilhcha an ixla'la'ch'itk'an tichiyucha ts'alh junkan Saulo. ");
INSERT INTO tpp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Akxni ixtalakat'alhmat'ajuncha an Esteban, tapaynilh, najun: ―Jamach'alhkat Jesús, k'ala'a'it'i an kintakuwin. ");
INSERT INTO tpp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Chi istso'ottayka, p'asi chiwinilh najun: ―Jamach'alhkat, jant'u k'ajalhak'ap'up'ininini ani tala'alhin. Akxni chunchacha nawlh, nilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","An Saulo ancha ixt'ajun, wa tamcha ixma'k'atsay li tama'nilhcha an Esteban. Anchunu wilhchan tsukulhcha jach'a'o'akani an yu ixtajakiklaka'inincha an la'acha'an Jerusalén. Ixchuxk'ani tatalaktilh'olh, talak'alhcha an xala'acha'anaxni Judea chi Samaria, pero an yu ixjamala'achata an Jesús yu'uncha jantu. ");
INSERT INTO tpp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tichi yu'uncha lapanakni yu wachucha ixtajakiklaka'inin tamaknulhcha an Esteban chi stakcha talhi'alhulh. ");
INSERT INTO tpp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero an Saulo yucha wa ixjalhitama'chapuyi an yu ixtajakiklaka'inincha chi ixjach'a'o'ayi lakatamincha lakalakcha'a', ixkilaktanuycha, ixjala'xa'axtuycha an lapanakni chi an t'akunin, ixjalhi'ancha lakapulach'in. ");
INSERT INTO tpp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","An yu ixtataxtutacha an la'acha'an Jerusalén ixtalhichiwinicha an laj'oxi chiwinti wa tanchuncha ixta'an. ");
INSERT INTO tpp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","An Felipe, yucha la'acha'an Samariaja alh, chi tsukulhcha jalhixa'alayi an Cristo. ");
INSERT INTO tpp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ixtata'ayxt'o'acha an lapanakni chi ixchuxchak'ani sa' ixta'alha'asmat'a an Felipe, chi ixtala'ts'incha tacha an ixlakmasuy tanlhun yu ixmasuy ix'alhp'asninti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Lhuw lapanakni yu wa ixtala'apaxto'ta lakmakxkay'un ixjak'uch'uycha. An lakmakxkay'un akxni ixtamakajuncha xamati lapanak, ixtat'asaycha. Chi ixluwk'an yu wa ixtalaklakalhtukulunta chi yu wa la'ch'anlh'awilin ixtajunita, ixjak'uch'uycha. ");
INSERT INTO tpp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Tacha ani ixtapasay, an la'acha'an, an lapanakni sawalhcha ixtalaj'achan. ");
INSERT INTO tpp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Chi ancha ixt'ajun pumatam lapanak yu ixjunkan Simón, ixlip'ulhnaj jachawana ixjunita, chi stakcha ixjalaj'o'xcho'ota an jamacha'an Samaria. Ixjalhimasuniy li sawalhcha ixlitapalay lapanak. ");
INSERT INTO tpp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ixchuxk'an lakt'ikt'in chi laj'ajin, sawalhcha ixta'asmatniy, ixtalaknajun: ―Tacha ani masuy yucha an ay ix'alhp'asninti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Sawalhcha ixta'asmatniy, mu tacha an ixlima'ancha ixjachawanan wa stakcha ixjapulaj'o'xcho'ota. ");
INSERT INTO tpp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero akxni takiklaka'ilhcha an Felipe tacha an ixlichiwiniy laj'oxi chiwinti, ixlakata an ixlich'alhkat Dios chi an Jesucristo, ixtalaj'a'paxacha an lapanakni chi an t'akunin. ");
INSERT INTO tpp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Chi an Simón wachucha kiklaka'ilh, chi akxni a'paxlicha lhilhijcha ixch'a'o'ay an Felipe, sawalhcha ixla'lhi'a'niya tacha an ixla'ts'in ixlaktapasay tanlhun chi tacha an ixtata'oxicha an ta'an'anin. ");
INSERT INTO tpp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tak'atsaalhcha an yu ixjamala'achata an Jesús an yu ixtat'awnachalh la'acha'an Jerusalén, li an la'acha'an Samaria ta'asmat'acha an ixchiwinti Dios. Tamala'achalhcha an Pedro chi an Juan la'acha'an Samaria. ");
INSERT INTO tpp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Chi akxni tacha'alhcha Samaria, talhitapaynilhcha an yu tajakiklaka'inilhcha an yu ancha jamacha'an, para li katala'a'ilhi an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Mu jantuka' xamati ixla'a'iy yu yu'uncha. Wa ixtalaj'a'paxtaka la ixta'a'ut an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Wa chuncha an Pedro chi an Juan talaklakpach'apalhcha an lapanakni, chi chuncha tala'a'ilhcha an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","An Simón akxni la'ts'ilhi li an Stalan'a Takuwin ixjala'chincha an lapanakni akxni ixtajalakpach'apaninincha an yu ixjamala'achata Jesús, ixjaxta'niycha tumin. ");
INSERT INTO tpp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Chi jajuniy: ―Wachu akilaxta'niwi an ix'alhp'asninti Dios, para li yu wachu aklakpach'apalh wachu kala'a'ilhi an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wa chuncha an Pedro alhtaylh juniy: ―K'at'ats'an'a'o amintumin, mu uxint'i wa laka tumini t'amawp'ut'un an yu xt'a'a Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uxint'i jant'u t'ach'ip'ini li k'ala'a'it'i, mu la ix'ukxlakapu an Dios jantu ts'ajwi t'ajun mijalhunut. ");
INSERT INTO tpp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","T'ach'a ani jant'uch'a k'is oxi lay, jant'uch'a ch'uni k'alat'i, k'at'ap'ayninini an Dios, kala'ts'inawcha li sna kamala'mixinini t'ach'a ani p'ast'ak'a. ");
INSERT INTO tpp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mu ikla'ts'inani li wa lhaxk'ayanani li tu'u', ch'i jant'u lay mak'awt'ijlay. ");
INSERT INTO tpp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","An Simón ja'alhtayanalh: ―K'at'ap'ayninit'iti an Dios kilakata para li jantu tu'u katapasalh tacha an kilajunaw. ");
INSERT INTO tpp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ixli'astan akxni talhichiwin'olhcha an ixchiwinti Dios an Pedro chi an Juan, ta'ancho'olhcha la'acha'an Jerusalén, chi talhichiwinilhcha wachu an laj'oxi chiwinti lakalhuw xala'acha'anaxni an xalakaat'un Samaria. ");
INSERT INTO tpp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pumatam ix'angelh an Dios xa'alalh an Felipe, junkan an Felipe: ―K'a'ost'aycha chi k'ap'inchi anu lhitalaktsin, la xatij la'acha'an Jerusalén, an tan la'pusta tij tan lakak'iwin, yu wakcha anta la'acha'an Gaza. ");
INSERT INTO tpp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pus an Felipe ostayalh chi alhcha, walh an laka tij paxto'lhicha pumatam lapanak jamacha'a Etiopía. Ani lapanak xa'ayi ixjunita, ixtesorero an xarreina Etiopía chi kilalh la'acha'an Jerusalén, kitapayninilh an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Chi ixti'ancho'oycha la ixlakaat'un, sa'cha ixtajun la ixcarreta, ixpunawlhi'antacha an yu ists'o'ta an Isaías yu ixlichiwiniy ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pus an ixTakuwin Dios juniy an Felipe: ―Waniya k'ap'inchi an tan la'pust'ajun an carreta. ");
INSERT INTO tpp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Akxni an Felipe cha'alhcha, asmat'acha li an jamacha'a Etiopía ixpunawlhi'anta an yu ists'o'ta an Isaías, pus juniy: ―¿Lhimach'a'xayi an yu p'una'un? ");
INSERT INTO tpp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","An lapanak jamacha'a Etiopía ja'alhtayanalh najun: ―¿Tasucha lay aklhimacha'xaya li jantu xamati kijuniy tuchini nawputuncha? Pus an Felipe, junkan li katajulhcha an laka carreta chi li kapiktutawilhcha an lapanak jamacha'a Etiopía. ");
INSERT INTO tpp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tan ixpunawt'ajun an ixchiwinti Dios, an tan najunta: Wa tacha wa la'atamcha jas'at'a borregojo lhi'ankalh tan kama'nikana', chi wa tacha wa la'atamcha borrego yu jantu k'is t'asay akxni la'asitkan, jantu k'is ta'elh'a'mix'alh. ");
INSERT INTO tpp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Stakcha tamamaxanilh, walh chi jantu xamati lhi'a'tayjulh. An ixjatsukunti ma'osukalhi ani lakaat'un. Jantu xamati lay katinawlh tichini yu'unchacha yu tapu'a'p'un'alh. ");
INSERT INTO tpp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","An jamacha'a Etiopía juniy an Felipe: ―Lamapaynin ak'i'uni tichini yuchacha lhichiwiniy an lapanak an yu ixlichiwiniy ixchiwinti Dios. ¿Wa ix'akstucha lhichiwinkan tacha ani najunta u xamati apumatami lhichiwiniy? ");
INSERT INTO tpp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pus an Felipe, tsukulhcha lhixa'alayi an tacha ixpunawt'ajun ixchiwinti Dios an jamacha'a Etiopía. Junilhcha an laj'oxi chiwinti yu lhichiwiniy an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Chi wakcha ta'alh, walh tacha'alhcha tan ixwilh xkan, an jamacha'a Etiopía najun: ―Ani wilhi xkan, ¿jantucha layi ani ak'a'paxli?  ");
INSERT INTO tpp_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pus an Felipe juniy: ―Li ixlisawalh chux la mijalhunuti k'iklak'a'iy an Dios, laych'a k'a'a'p'axt'i. Pus an jamacha'a Etiopía najun: ―Kit'in ijkiklaka'iya li an Jesucristo isTs'alh an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wa chuncha lhinawlhi li kasa' yawkalhi an carreta, chi an ixt'uyunk'an tata'alhtajulhcha, an Felipe ma'paxalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Akxni tatakutlhicha an lakxkan, an ixTakuwin Dios lhi'alhcha an Felipe. Chi an xa'ay lapanak jamacha'a Etiopía jantucha la'ts'incho'olh, pero sawalhcha ix'achani taylhi'alh ixtij. ");
INSERT INTO tpp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","An Felipe akxni k'ats'aanalh la'acha'an Azotojcha ixt'awnachalh, chi lakatamj lakatamjcha la'acha'anaxni ix'an lhichiwiniy an laj'oxi chiwinti, sta la'acha'an Cesareajcha cha'alh. ");
INSERT INTO tpp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","An Saulo ali ali ixtaylhi'anta ixjala'me'e'sway li kajama'niya an yu ixtakiklaka'iy an Dios. Pus xliyu lhila'alhi an xa'ay tukan sacerdote. ");
INSERT INTO tpp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Chi sk'inilhcha jalhiki tan tasuy li laycha ka'alh an laka lakcha'a tan ixtaputa'ayxt'o'a an yu judiojnin an la'acha'an Damasco. Para li ka'alhcha japuxkawna an yu ixtach'a'o'ay an Sast'i Tij, t'akunin chi lapanakni. Chi kajalhi'alhcha tacha tach'inin an la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero akxni waniycha ixcha'ant'ajun la'acha'an Damasco, la'atam jatapulhkunu minchalh an lakt'iyan, wanaj la'atanchanu'olh, wa xlimjnik'acha. ");
INSERT INTO tpp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pus an Saulo alo' ta'a'talh, chi asmat'a junkan: ―Saulo, Saulo, ¿t'asu li k'ilhit'ama'ch'ap'uycha? ");
INSERT INTO tpp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","An Saulo najun: ―¿Tisu uxint'icha Jamach'alhkat? An yu ixchiwiniy alhtaylh, juniy: ―Kit'in Jesús, kit'ini k'ilhit'ama'ch'ap'uy. ");
INSERT INTO tpp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","K'a'ost'aycha chi k'ap'inchicha an la'acha'an. Anchacha k'a'unk'ana'a t'uch'ini k'a'ilht'uya'acha. ");
INSERT INTO tpp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","An yu ixtat'a'anta an Saulo sawalhcha ixtalaktalhanan, mu ta'asmatlhi tacha an chiwinkalh, pero jantu xamati tala'ts'ilh. ");
INSERT INTO tpp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Wa chuncha an Saulo ostayalhi an lakaat'un, pero akxni tala'pumix'alh, jantucha lay ixjalakawanan. Pus wa tama'ch'apalhi'alhcha la'acha'an Damasco. ");
INSERT INTO tpp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ancha la'at'utu wilhchani ixwilh jantu lay ixjalakawanan chi jantucha ixwajin chi jantucha ix'ot'a tu'u'. ");
INSERT INTO tpp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","An la'acha'an Damasco ixwilh pumatam lapanak yu ixkiklaka'iy Dios, ixjunkan Ananías, chi an Jesús talakasunilh, wa tacha la'puminatnalh, chi juniy: ―Ananías. Yucha ja'alhtayanalh najun: ―Jamach'alhkat Jesús ¿tisuncha?, anicha ikyalh. ");
INSERT INTO tpp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","An Jamach'alhkat Jesús juniy: ―K'a'ost'aycha, chi k'ap'inchi an laka tij tan lhitapa'a'uy Ts'awj. K'ap'uxk'awya'a pumatam lapanak jamacha'a Tarso, junkan Saulo, an la ixcha'a Judasi k'ap'uxk'awya'a, mu chaway yucha tapaynit'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Chi la ixla'puminatnat la'ts'in pumatam lapanak junkan Ananías. La'ts'in li tanuchalh chi lakpach'apalh para li laycha kajalakawanancho'olh. ");
INSERT INTO tpp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Akxni chunchacha asmatlhi an Ananías najun: ―Jamach'alhkat Jesús, wanajcha ixluwk'ani kintalhixa'alata anchunu lapanak chi kintajun'ojotacha tacha jala'lhitama'chapuy an yu takiklaka'iyan, an la'acha'an Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Chi chaway anicha minta, mu yu'uncha an xalaj'ajincha sacerdotejnini tamakawniy li kamilh, para li kajalhi'an'olhcha tacha tach'inini an yu ta'a'atant'asayan. ");
INSERT INTO tpp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero an Jamach'alhkat Jesús juniy an Ananías: ―K'ap'inchi', mu anchunu lapanak iksakxtutacha para li akilhichiwinilhcha tan tawilanalh yu jantu judiojnin, chi li kajajunilhi kinchiwinti an rejnin chi an yu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kit'in akmasuniya tacha kastak ma'alh'ajnana kilakata. ");
INSERT INTO tpp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pus an Ananías alhcha an laka cha'a tan ixtanumachalh an Saulo. Akxni tanuchalhcha an Ananías lakpach'apalhcha an Saulo chi juniy: ―Kint'ala'ajun Saulo, an Jamach'alhkat Jesús an yu talakasunin laka tij t'an ixp'ut'ant'a yucha kimala'achachalh, para li laych'a k'ajalak'awanch'o'o chi li sawalhch'a k'alhits'uk'u an Stalan'a Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wa akxni, an la ixla'chulh an Saulo, patajunilh wa tacha ix'ayxk'ip'it jatanti chi jalakawanancho'olhcha. Wa chuncha an Saulo tayalhcha chi a'paxlicha. ");
INSERT INTO tpp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ixli'astan waycho'olhcha chi k'ut'ilhcha juncho'olh, chi anchacha jat'atamakawlh an jamacha'an Damasco yu an ixtakiklaka'iy an Jesús, lanan la'alhuw wilhchani jat'atamakawlh. ");
INSERT INTO tpp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chi wa chuncha an Saulo tsukulhcha lhichiwiniya an Jesús, isTs'alh Dios, an laka lakcha'a an tan ixtata'ayxt'o'a an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ixchuxk'an an yu ixta'alha'asmat'a ixtalhi'a'niycha chi ixtanajun: ―¿Chu jantu yu ani lapanak an yu ixjalhitama'chapuy an yu takiklaka'iy Jesús, an Jerusalén? ¿Jantu yucha ani chilh, para li kajalhi'alhcha chi kajama'axta'nilhcha an xalaj'ajin sacerdotejnin? ");
INSERT INTO tpp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero an Saulo ali ixlichiwiniya alhp'as an ixchiwinti Jesús, ixjajuniya li an Jesús yucha Cristo. Pus jantucha ixtalhimacha'xayi an judiojnin yu la'acha'an Damasco ixtawilanalh. ");
INSERT INTO tpp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","La'alhuwcha wilhchani la'pusli, an judiojnin wa tamcha tak'atsaalh li katama'niya an Saulo, ");
INSERT INTO tpp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero yucha k'atsaalh. Ts'isi chi tunkuw ixtapakxan'iycha an la xalakmalhticha an la'acha'an, para li laycha katama'nilh. ");
INSERT INTO tpp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero an yu ixt'alhtanancha an Jesús ixtajunita tamujulh laka la'atam ay canasta chi yuchacha tapuma'alhtajulh puts'ista an laka axi, yu ixla'acho'oni'ojoy an la'acha'an, chi chunchacha lay osli. ");
INSERT INTO tpp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Akxni cha'alhcha la'acha'an Jerusalén an Saulo, ixjat'atala'xto'putuncha an yu ixtakiklaka'iy Jesús, pero yu'uncha ixchuxk'ani wa ixtatalhamni, mu jantu ixtalhiwilayi li wachucha ixkiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wa chuncha an Bernabé lhi'alhi an Saulo an tan ixtat'ajun yu ixjamala'achata an Jesús. Chi jajunilhcha li an Saulo la'ts'ilhi an Jamach'alhkat Jesús, an laka tij, chi li xa'alalh. Chi li an la'acha'an Damasco an Saulo jantu wa talhanajlhichiwinilhcha an ixchiwinti Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Pus an Saulo jat'atamakawlhcha an la'acha'an Jerusalén, anchacha ixjat'a'aklat'ajun. Jantu wa ixtalhanajlhichiwiniycha an ixchiwinti Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ixjat'achiwinicha chi ixjat'alakikxtukuycha an judiojnin yu ixtachiwiniy lhigriego, pero yu'uncha wa ixtama'niputun. ");
INSERT INTO tpp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Akxni tak'atsaalhi an yu takiklaka'iy Jesús li wa tama'niputun, talhi'alhi an Saulo la'acha'an Cesarea, chi ancha tamak'alhcha la'acha'an Tarso. ");
INSERT INTO tpp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wa chuncha an yu ixtakiklaka'icha an Dios ta ixlijalhi'ay an xalakaat'un Judea chi Galilea chi Samaria lhi'achacha ixtawilanalh. Chi alhp'ascha ixtajun la ixtakuwink'an chi ixtakiklaka'iycha an Dios, chi an Stalan'a Takuwin ali ali ixjalalhaway. ");
INSERT INTO tpp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","An Pedro ixjala'pixiyalhnant'ajuni an ixlapanakni Dios, chi wachu alh jala'ts'ini an yu ixtawilananchalh la'acha'an Lida. ");
INSERT INTO tpp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Walh ancha la'cha'alh pumatam lapanak junkan Eneas, la'atsajincha k'ata ixta'an'ajmalh, wa ixlakalhtukulunta. ");
INSERT INTO tpp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","An Pedro juniy: ―Eneas, an Jesucristo kak'uch'uyan, k'a'ost'aycha, ch'i k'asakt'icha amimputamat. An Eneas watukan ostayalh. ");
INSERT INTO tpp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ixchuxk'ani tala'ts'in'olh an yu ixtawilanalh la'acha'an Lida chi xalakaat'un Sarón. Chi takiklaka'ilhcha an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Anchunu panch'e'ex an la'acha'an Jope ixt'ajun pumatam t'aku yu ixjakiklaka'inin, ixjunkan Tabita, lhigriego nawputun Dorcas. Ani t'aku wa tanlhuncha yu laj'oxi ix'ilhtuy chi ixja'a'tayjuycha an yu ixtama'lhtask'iniy la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pero chilh panch'e'ex an Dorcas ta'an'alh chi nilh. Akxni paxa'okalhcha, an ixlakatunaj pulaktamcha laka cha'a tan ixlitala't'uycha juntachalhi mamakanchalh. ");
INSERT INTO tpp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","An la'acha'an Lida waniy la'acha'an Jopeje ixlitamakajun, chi an Pedro ancha ixt'awnachalh Lida, pus akxni tak'atsaalhi an yu ixtajakiklaka'inin li ancha t'awnachalh an Pedro, tamala'achanilh ixt'uyunk'an lapanakni tan tajuniy: ―Pedro, k'at'at'i watukani an la'acha'an Jope. ");
INSERT INTO tpp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pus an Pedro jat'a'alhi la'acha'an Jope. Akxni cha'alhcha, talhi'alhcha an tan ixmachalh an lakatunaj, chi ixchuxk'an an yu maticha ixt'apapak'an t'akunin ixtalhi'alhuncha. Tala'atanchanulhcha an Pedro chi tamasunilhcha yu ixlak'ilhtuta la'la'ch'it an Dorcas akxni ixt'ajunka'. ");
INSERT INTO tpp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wa chuncha an Pedro jajuniy li katataxtu'olhka'. Chi ixli'astan yucha tatso'ottalhcha chi tapaynilhcha chi sa'cha ixla'ts'ini an yu ixnitacha, chi juniy: ―¡Tabita, k'a'ost'aycha! An t'aku jalakawanalhcha, chi akxni la'ts'ilhcha an Pedro, ostawilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","An Pedro ma'ch'apachalh chi ma'ch'apayawlhcha. Pus akxni jat'asanilhcha an yu ixtajakiklaka'inin chi an t'akunin yu jantucha tu'u ixt'apapak'an, ixla'awcho'otacha jamasunicho'olh. ");
INSERT INTO tpp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tacha ani tapasalh wanajcha lajk'atsa'okalhi an Jope, chi lhuwi yu takiklaka'ilh an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","An Pedro la'alhuw wilhchani tamakawlh an la'acha'an, la ixcha'a tichiyucha lapanak yu ixla'tapatsay jaxt'a'an, ixjunkan Simón. ");
INSERT INTO tpp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","An la'acha'an Cesarea ixt'ajun tichiyucha lapanak ixjunkan Cornelio, xacapitan la'atam batallón yu ixjunkan Italiano. ");
INSERT INTO tpp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ani lapanak chi chux yu ixtawilanalh la ixcha'a ixtakiklaka'iya an Dios. Chi ixja'a'tayjuyi an judiojnin, la'lhuwi ixt'a'a tumin chi lhilhiji ixtapayniniy an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","La'atam wilhchan, katacha las trescha yu puta'oxaycha, la'puminatnalh, sawalhcha oxi la'ts'ilh pumatam ix'angelh an Dios, tanuchalhcha an tan ixwilh chi juniy: ―¡Cornelio! ");
INSERT INTO tpp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","An Cornelio wa sa'cha ixla'ts'ini an angelh chi masi sawalhcha ixtalhanan lhisakmilh, juniy: ―¿T'isunch'a lak'ask'ini Jamach'alhkat? An angelh alhtaylh juniy: ―An Dios lhakapu'ani amintapaynit ch'i t'ach'a an ilht'uy li ja'a't'ay'uy an yu tama'lhtask'iniy la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","K'amala'ach'at'i xamati an la'acha'an Jope, kaki'ilh tichiyucha lapanak junkan Simón, yu tajumpalay ma Pedro. ");
INSERT INTO tpp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ani yucha la ixcha'a tichi yucha yu wachu Simón junkani wilhchalh, yu la'tapatsay jaxt'a'an waniy an alamalh. ");
INSERT INTO tpp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Akxni ancho'olhcha an angelh an yu xa'alalh an Cornelio, an Cornelio jat'asanilhcha ixt'uyunk'an ixma'tsukunin chi pumatamcha soldado yu oxi ixt'alalhi'an yu ixkiklaka'iy an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Jajun'olhcha tacha an la'ts'ilh, ixli'astan jamala'achalhcha la'acha'an Jope. ");
INSERT INTO tpp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Tunkunchalh, akxni ix'atunkunt'ajuncha, laka tijcha ixtat'ajun waniycha la'acha'an Jope. Chi an Pedro yu an ta'alh puxkawnin tawk'alhcha la ix'a'sti cha'a', alhcha tapaynini'. ");
INSERT INTO tpp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Walh sawalhcha chawanalh, wa laycha tu'u ka'ulh, pero akxni ixla'oxinit'awkanka yu ka'uyacha la'puminatnalh. ");
INSERT INTO tpp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","La'ts'in li an lakt'iyan tati'achalhcha chi ta'alhtajulhcha an lakaat'un wa tacha alhtam ay sábana, an tama'ats'astut'at'i ixch'apanikantachalhcha an talhman. ");
INSERT INTO tpp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chi an laka sábana watuchicha jatapakxat yu ma'at'at'i ixch'aja ixtatajumanalh chi yu wa tatatanxe'e'an chi yu tala'pa'achujlata. ");
INSERT INTO tpp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Chi an Pedro asmatlhi chiwinkalh, nawkan: ―Pedro, k'at'aycha, k'ajama'nit'icha ch'i k'aja'ut'icha. ");
INSERT INTO tpp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","An Pedro ja'alhtayanalh najun: ―Jantu, Jamach'alhkat, mu kit'in jantu a'tam ik'uta yu jantu oxi ukan chi yu nawkan li jantu stalan'a para li ak'ulh. ");
INSERT INTO tpp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","An yu chiwinilh a'tam xa'alapalhi an Pedro, juniy: ―Yu Dioscha mastalan'anita jant'u k'a'uni li jantu oxi. ");
INSERT INTO tpp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A't'utu chuncha junikalh, ixli'astan an sábana tach'ixcho'olhcha an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","An Pedro sawalhcha ixpast'ak'a tuchini jumputuncha tacha an la'ts'ilh, walh tatayachalhcha laka malhticha an lapanakni an yu ixjamala'achata an Cornelio, mu talhasakminilhcha tanchuncha la ixcha'a yu junkan Simón. ");
INSERT INTO tpp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Pus mu tacha'alhcha, pus p'ascha tachiwiniy talhasakminincha li ancha wilh yu junkan Simón yu talhimispapalay Pedro. ");
INSERT INTO tpp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pus wa chuncha masi ixpastakt'ajunka tuchini jumputuncha tacha an la'ts'ilh an Pedro, an ixTakuwin Dios juniy: ―K'ajala'ts'inchi', ixt'utunk'an lapanakni tapuxkawyan. ");
INSERT INTO tpp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","K'at'aycha chi k'at'a'alht'a'ut'icha, k'ajat'ap'inchicha, jant'u t'u'u k'alhak'ap'up'i, mu kit'ini ijkamala'achatachalh. ");
INSERT INTO tpp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pus an Pedro ta'alhtajulh chi jajuniy an lapanakni: ―Kit'ini an yu p'uxk'awyat'it, ¿t'isunch'a la't'ant'at'iti? ");
INSERT INTO tpp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yu'uncha ta'alhtaylh tajuniy: ―Yucha an capitán Corneliojo kintamala'achatacha'an, yucha pumatam lapanak yu ja'asmatnan, kiklaka'iya an Dios, chi ixchuxk'an an judiojnin oxi talhiwilay chi tamapayniy. Pumatam ix'angelh an Diosi junilh li kat'asanin, para li k'ap'it'i la ixcha'a', chi li ka'asmatnini yu k'a'una'a. ");
INSERT INTO tpp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pus wa chuncha an Pedro jatamaknulhcha pulakni chi anchacha tala'akujlhi anchunu jatats'isni. Tunkunchalh, jat'a'alhcha an Pedro, chi wachu tat'a'alhi ali'in yu ixtakiklaka'iy an Jesús yu jamacha'an Jope. ");
INSERT INTO tpp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","La'atamcha wilhchan jumpalh tacha'alhcha la'acha'an Cesarea. An Cornelio sa'cha ixjapakxan'ita, ixjalakt'asanitacha yu ta ixjalhila'ts'in chi yu oxi ixjat'alalhi'an. ");
INSERT INTO tpp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Akxni cha'alhcha an Pedro la ixcha'a an Cornelio, an Cornelio taxtulhcha, lakatastuklhicha chi tatso'ottanilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero an Pedro xa'ayawlh juniy: ―K'at'ay, kit'in wachucha wa klapanak tacha uxint'i. ");
INSERT INTO tpp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Akxni chunchacha ixt'achiwint'ajun, tanulhcha laka cha'a an Pedro, walh la'ts'incha li wanaj lhilhuwi ixlakwilakalh. ");
INSERT INTO tpp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","An Pedro jajuniy: ―Uxitnan k'ats'ayat'iti li pumatam judio jantu jat'achiwiniya yu jantu ixt'amacha'an chi jantu tanuyi la ixcha'ak'an, wa xliyu tumpaja yu kiklaka'iy lhamap'a'sin. Pero an Dios kimasunilhi li jantu xamati ajkunilh li lhkiliki u li jantu wa kint'atam. ");
INSERT INTO tpp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Xliyu tacha kilamak'atsaaniw li akmilh, watukan ikmilh, jantu tu'u iknajun li jantu akmilh. Chaway ijk'atsaputuncha tuchini kilalhit'asaniyawcha. ");
INSERT INTO tpp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","An Cornelio juniy: ―La'at'at'icha wilhchan ixjuntachalh tacha chaway panch'e'ex ixjunita aniya xaktanun la kincha'a', xaktapaynit'ajun yu puta'oxaycha las tres, walh akxni ikla'ts'in kintalakasunilhcha pumatam lapanak, an ixla'ch'it wa xlimjnik'acha. ");
INSERT INTO tpp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Kijuniy: “Cornelio, an Dios asmat'a amintapaynit chi past'ak'a an yu ilht'ut'a li ja'a't'ay'uy an yu tama'lhtask'iniy la'a'tayjun. ");
INSERT INTO tpp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","K'amala'ach'at'i xamati an la'acha'an Jope, para li kaki'ilh an Simón yu lhimispapalhkan Pedro. La ixcha'a yu wachu junkan Simoni wilhchalh, yu la'tapatsay jaxt'a'an chi waniy an alamalhi wilhchalh.” ");
INSERT INTO tpp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pus watukan iklhinawlhi li k'ap'ink'a puxkawka, walh chi uxint'i milhi'oxi lapanak ch'it'acha. Chaway kinchuxk'ani la ix'ukxlakapu an Dios aniya ikt'awnaw, chi iklakask'inaw li akilajun'ojowi chux yu an Dios junan li akilajuniw. ");
INSERT INTO tpp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pus an Pedro tsukulhcha chiwiniy, jajuniy: ―Chaway iklhimacha'xaycha li sawalhi li an Dios jantu wa jasakxtunun. ");
INSERT INTO tpp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ta kilhmakchux lapanakni jala'a'iya yu takiklaka'iy chi yu ta'ilhtuy yu laj'oxi tanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","An Dios jaxa'alalhi an jamacha'an Israel, jamak'atsaanilhi an laj'oxi chiwinti yu xt'a'a oxi jatawlhnat. Yucha an Jesucristojo puchiwinilh chi yucha kiJamach'alhkatk'an kinchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Uxitnan oxi k'ats'ayat yu tapasalh ta ixlijalhi'ay an xalakaat'un Judea. Tan pu'a'taynichalh xalakaat'un Galilea, akxni an Juan ixlilhichiwinintacha li lhitask'iniya li kalaj'a'paxkalh. ");
INSERT INTO tpp_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","K'ats'ayat'iti li an Dios xta'nilhi ix'alhp'asninti chi Stalan'a ixTakuwin an Jesús yu jamacha'a Nazaret, ch'i k'ats'ayat'iti li an Jesús tanlhun yu laj'oxi ix'ilhtuy chi ixjak'uch'uyi wa tichicha yu an xapay makxkay'un ixjamama'alh'ajniy. Chuncha lay ix'ilhtuy mu an Dios ixt'a'aklat'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Chi kitnan ijk'atsayawi chux tacha an lak'ilhtulh tanlhun an Jesús an xalakaat'un Judea chi an Jerusalén. Ixli'astan tama'nilhcha, tamuk'alhcha lakatam laka cruz. ");
INSERT INTO tpp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero an Dios mala'awnicho'olhi ixlila'at'utu wilhchan, chi ilhtulhi li akintatalakasunini kitnan. ");
INSERT INTO tpp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jantu lhichuxi jatalakasunilh, wa kitnan yu an Dios kixtasakxtutancha ixlip'ulhnaj, para li aknajuwi li kla'ts'inaw. Kitnan ikt'alakwajiw chi ikt'alaj'otwi akxni ixla'awcho'otacha. ");
INSERT INTO tpp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Chi yucha, kintamala'achancha li ak'awcha jalakjuninini an lapanakni li an Dios ulalhcha an Jesús ixlijuez, ixjuezk'an an yu tala'ajunta chi an yu tanitacha. ");
INSERT INTO tpp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ixchuxk'an an yu ixtalhichiwiniy ixchiwinti Dios, ixtalhichiwinintacha an Jesús, chi ixtanajuntacha li yu takiklaka'iy an Jesús, kajamala'mixinikana ixtala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Chunchaka ixchiwint'ajun an Pedro, walh an Stalan'a Takuwin jala'cha'an'olhcha ixchuxk'an an yu ixta'alha'asmatt'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pus an yu ixtat'acha'anta an Pedro, an yu wachu ixtakiklaka'iy an Jesús yu judiojnin, ixtalhi'a'niycha li an Stalan'a Takuwin wachu jaxta'nikalhi masi an yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Mu an lapanakni tipalhuwcha yu tamcha chiwinti ixtalakchiwiniy chi ixtaxta'niycha lhimala'puchajuni an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Wa chuncha an Pedro najun: ―¿Laycha jantucha kamakawkalhi li katalaj'a'paxli ani lapanakni, yu tala'a'ilhcha an Stalan'a Takuwin tacha kitnan? ");
INSERT INTO tpp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pus lhinawlhcha li katalaj'a'paxlicha la ixta'a'ut an Jesucristo. Ixli'astan tatapaynisk'inilhcha an Pedro li kajat'atamakawlh la'alhuw lanan wilhchan. ");
INSERT INTO tpp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","An yu ixjamala'achata an Jesús chi an ixlapanakni Dios yu ixtawilanalh an xalakaat'un Judea tak'atsaalhi li an yu jantu jamacha'an Judea wachu tala'a'ilhi an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Pus an Pedro akxni cha'ancho'olhcha Jerusalén, an ali'in judiojnin yu wachu ixtajakiklaka'inin ixtajuniy li jantu oxi ixtalhiwilay. ");
INSERT INTO tpp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Tajuniy an Pedro: ―¿T'asu li jak'ila'k'ilat'icha an yu jantu judiojnin ch'i jat'alakwaycha? ");
INSERT INTO tpp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","An Pedro wanaj jajun'olhi tacha an tapasalh, sta tan pu'a'taynichalh, jajuniy: ");
INSERT INTO tpp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Kit'in an la'acha'an Jopeje xakt'ajun, walh akxni xaktapaynit'ajun ikla'puminatnalh, ikla'ts'ilh wa tacha la'atam ay sábana, an tama'ats'astut'at'i an lakt'iyani ixcha'anta chi ix'alhtajuycha an tan xakt'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Chi oxicha iklhakapu'an para li oxicha akla'ts'ilh tuchini tajuncha an ixpulakni, la'stu jatapakxati ixtatajumanalh, yu ixputach'ant'at'ik'an ta'alin ani lakaat'un, chi yu ta'at'ajnan, chi yu tatatanxe'e'an, chi yu tala'pa'achujlata. ");
INSERT INTO tpp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Chi ik'asmat'a chiwinkancha, kijunkan: “Pedro, k'at'aycha chi wa tanyuchacha k'ama'nit'i, k'a'ut'icha.” ");
INSERT INTO tpp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kit'in ik'alhtaylh, ijkuniy: “Jantu, Jamach'alhkat, mu kit'in jantu a'tam ik'uta yu lhkiliki chi yu jantu oxi ukan.” ");
INSERT INTO tpp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Wa chuncha an chiwinti, aminchalh lakt'iyan a'tam kixa'alapalh, kijumpalay: “Yu Dioscha mastalan'anita, jant'u k'a'uni li jantu oxi.” ");
INSERT INTO tpp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A't'utu chuncha tapasalh, chi ixli'astan ch'ixcho'okalhcha an wa tacha sábana an lakt'iyan. ");
INSERT INTO tpp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Walh wa akxni, tacha'alhcha an laka cha'a tan xakwilh ixt'utunk'an lapanakni, yu kixtapuxkajuy, la'acha'an Cesareaja ixjamakminkantachalh. ");
INSERT INTO tpp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","An ixTakuwin Dios kijuniy li jantu tani aknawlh ma ajkat'a'alhcha an lapanakni. Chi wachu kintat'akilalhi ani ixpumachaxank'an t'ala'awnin, iktanu'ocha'awi la ixcha'a an lapanak an yu kint'asanilh. ");
INSERT INTO tpp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yucha kintajunini li an la ixcha'a la'ts'ilh pumatam angelh, ma ancha sa' ixyalh chi an angelh ma juniy: “K'amala'ach'at'i xamati an la'acha'an Jope, para li kaki'ilhi an Simón yu lhimispapalhkan Pedro, ");
INSERT INTO tpp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","yucha kajunan tani laych'a k'alhit'a'alht'axt'uya'a chi chux yu tawilanalh an mincha'a'.” ");
INSERT INTO tpp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Akxni tsukulhcha ijkaxa'alay, an Stalan'a Takuwin wanajcha chuni jala'chilh tacha kitnan p'ulhnaj kintala'chin. ");
INSERT INTO tpp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Pus ancha ikpastaklhicha tacha an ixnajunta an Jamach'alhkat Jesús, tan an nawlh: “Chun sawalh an Juan wa laka xkani jama'paxanalh pero uxitnan an laka Stalan'a Takuwini k'ama'p'axak'ana'it.” ");
INSERT INTO tpp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pus an Dios, mu li wanajcha chuni jaxta'niy tacha yu kitnan kintaxta'niyan yu kiklaka'itawcha an Jamach'alhkat Jesucristo, ¿tisu kilhijunticha kit'in para li ajkunilhcha an Dios li jantu chuni ka'ilhtulhi? ");
INSERT INTO tpp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Akxni chunchacha ta'alha'asmatlhi an Pedro an t'ala'awnin yu jamacha'an Jerusalén, sa' talajkilhun'olh chi taxta'nilhcha lhimala'puchajuni an Dios, ixtajuniy: ―¡Pus an yu jantu judiojnin wachu jamakawniya an Dios li katakiklaka'ilh, para li katalhitsukulhi an jatsukunti yu jantu a'tam katimin'olh! ");
INSERT INTO tpp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Akxni tama'nilhcha an Esteban, an yu ixtakiklaka'iy Dios tsukulhcha jach'a'o'akan, ixjaxkaykancha, pus an ali'in ta'os'alhcha xalakaat'un Fenicia, chi Chipre, chi la'acha'an Antioquía. Anchacha ixtalhixa'alayachalh ixchiwinti Dios an jamacha'an Judea, pero an yu jantu jamacha'an Judea, yu'uncha jantu. ");
INSERT INTO tpp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero ixta'alin wachu yu ixtakiklaka'iy an Dios yu jamacha'an Chipre chi jamacha'an Cirene, yu'uncha tacha'alhi an la'acha'an Antioquía chi talhixa'alalh wachu an ixchiwinti Dios an yu jantu jamacha'an Judea, tajamak'atsaaninilhi an ixchiwinti Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","An ix'alhp'asninti an Jamach'alhkat Dios ancha ixjat'a'aklat'ajun, pus lhuw lapanaki yu makawlhcha yu p'ulhnaj ixkiklaka'iy, chi takiklaka'ilhcha an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","An yu ixtajakiklaka'inin an la'acha'an Jerusalén, akxni chunchacha tak'atsaalh li ixtapasay, tamala'achalhcha an Bernabé la'acha'an Antioquía. ");
INSERT INTO tpp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Akxni cha'alhcha an Bernabé, la'ts'ilhcha tacha an Dios sawalhcha ixjalakmapaynita, pus sawalhcha ix'achan. Chi ixchuxk'ani jalhimap'a'silh li la ixjalhunutk'an ixlisawalhcha katataylhi'alh katach'a'o'alh an Jamach'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Mu an Bernabé sawalhcha oxi lapanaki ixjunita chi sawalhcha ixlit'ajuni an Stalan'a Takuwin chi sawalhcha ixkiklaka'iya an Dios. Chi lhuw lapanaki t'atala'xto'lhi an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ixli'astan, an Bernabé alhcha la'acha'an Tarso, alhcha puxkawna an Saulo. ");
INSERT INTO tpp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Chi akxni la'cha'alhcha aylhi'alhcha la'acha'an Antioquía. Ancha, kalaks tam k'ata tat'atawlhchalh an yu ixtakiklaka'iy wachu an Dios, chi lhuw lapanakni tamasunilh. An la'acha'an Antioquiaja tan p'ulhnajcha jalhimapa'a'ukanchalh li Cristianojnin an ixt'alhtanan Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Anchunu panch'e'ex ixjuntachalh, tacha'alhi la'acha'an Antioquía ali'in yu ixtalhichiwiniy an ixchiwinti Dios, la'acha'an Jerusaleni ixtamintachalh. ");
INSERT INTO tpp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Chi xapumatam yu yu'uncha, yu ixjunkan Agabo, akxni sa'cha ixyalh, an Stalan'a Takuwin machiwinilh, nawlh li ka'alina ay chawani ta ixlijalhi'ay an lakamunulhpa', chi tapasalh sawalh, akxni ixch'alhkatnant'ajun an ay jamach'alhkat Claudio. ");
INSERT INTO tpp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pus an yu ixtakiklaka'iy Dios yu jamacha'an Antioquía tapastaklhi li katamala'achanilhi la'a'tayjun an t'ala'awnin yu ixtawilananchalh Judea, tacha yu laycha ixt'a'a atamj. ");
INSERT INTO tpp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Chunchacha ta'ilhtulh, yu'uncha an Bernabé chi Saulojcha jamalhi'anikalh an tacha tala'xta'lhi an t'ala'awnin, para li katalhi'anilhcha an laktatanin an xalakaat'un Judea. ");
INSERT INTO tpp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Anchunu panch'e'ex ixjuntachalh, an rey Herodes tsukulhcha jalhinajuni li kajach'apayawkalhcha ali'in yu ixtakiklaka'iy an Dios, para li kajalhitama'chapukalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Lhinawlhcha an Herodes li kama'nikalhcha laka espadaja an Jacobo, ixt'ala'ajun an Juan. ");
INSERT INTO tpp_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Chi mu la'ts'ilhi an Herodes li oxi talhiwilalh an judiojnin, pus wachu lhinawlhi li kamalaklhchawkalhi an Pedro. Akxni chunchacha tapasalh akxni k'atan ixjunita, akxni ix'ukan pan yu jantu tu'u lhiyalh lhamaskajan. ");
INSERT INTO tpp_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Akxni ixch'apayawkantacha an Pedro, an Herodes malaklhchawlhcha, chi ancha kilhmakt'at'icha soldadojnini ixtalhistakta. Ixpumat'at'ik'an soldadojnini ixtajunita kilhmaktamincha. An Herodes ixli'ilhtuy li akxni kala'oyacha an ixk'atan Paxku kajamalakasuniya an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pus an Pedro oxicha ixlistakkanta an laka pulach'in, pero an yu ixtakiklaka'iy Dios alhp'asi ixtataylhi'anta ixtalhitapaynini. ");
INSERT INTO tpp_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chi anchunu jatats'isni akxni an Herodes ixpast'ak'acha li kamaxtuya katunkuna, an Pedro ilhtatay, la ixpujank'an ixt'uyunk'an soldadojnin, laka ma'at'uy cadenajcha ixmakch'i'ulakanta. Chi an ali'in soldadojnin ixtajalhistaknantacha an la xamalhticha an pulach'in. ");
INSERT INTO tpp_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Walh wa akxni cha'alh pumatam ix'angelh an Dios, an laka pulach'in wanaj tapulhku'olh. An angelh pajach'apachalhi an Pedro, makujulh, chi juniy: ―Lascha k'at'ay. Pus wa akxni an cadena lakmakpatajulhi an Pedro. ");
INSERT INTO tpp_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Chi an angelh juniy: ―K'amala'ch'incha ch'i k'ach'ant'anut'icha amiwarachi. Pus chunchacha ilhtulh an Pedro, chi an angelh jumpalay: ―K'ap'ula'axt'a'k'acha ch'i ak'inch'a'o'acha. ");
INSERT INTO tpp_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Wa chuncha an Pedro ch'a'o'alhcha an angelh, masi jantu ixk'atsayi an Pedro li sawalh u jantu yu ix'ilhtut'ajun an angelh. An Pedro ixnajun li sna wa ixla'puminatnant'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Tala'puslicha tan p'ulh ixtayanalh an soldadojnin chi tan ixlilakat'uycha ixtayanalh, chi akxni tacha'alhcha an laka malhticha wa ix'akstucha tati'alh. Pus tataxtulhcha chi akxni tala'puslicha lakatam laka tij, an angelh wa ix'akstucha makawlh an Pedro. ");
INSERT INTO tpp_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Akxni, an Pedro lhimacha'xalhcha. Chi najun: ―Chaway oxicha ijk'atsay li yucha an Dios sawalhi mala'achachalh an ix'angelh, para li akimilh ma'alhtaxtunu la ixmaka an Herodes chi ixchuxk'an tacha an kixtalhitama'chapuputun an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Akxni lhimacha'xalhcha ixlakata ani, an Pedro alhcha la ixcha'a a María, ixnati Juan yu ixtajumpalay Marcos, ancha lhilhuwi ix'ayxto'kan ixtatapaynit'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","An Pedro akxni chiwinilhcha an laka malhticha yu yalh lhilaka tij, pumatam jatsi alh la'ts'ini tichini yuchacha. An jatsi ixjunkan Rode. ");
INSERT INTO tpp_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Akxni alhmispalhi li yucha an Pedro, wa ix'achatcha jantu malhti'anilh, apalij jats'alajtanucho'olh chi jamak'atsaaninilhcha li yucha an Pedrojo yalh laka malhticha. ");
INSERT INTO tpp_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","An yu ixtatanumanalh pulakni tajuniy: ―K'a wa lok'ojlay. Pero yucha jajuniy li sawalh, chi yu'uncha ixtanajun: ―Jantu yu', yucha an ix'angelh. ");
INSERT INTO tpp_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero an Pedro ali ixchiwiniya an laka malhticha. Pus akxni tamati'anilhcha chi tala'ts'ilhcha, ixtalaktalhanancha. ");
INSERT INTO tpp_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","An Pedro jatamakyawnilh, jajuniy li wa sa'cha katalajkilhulh, chi jajunilhcha tani lhitaxtulhcha an laka pulach'in, li yucha an Diosi maxtulh, chi jajumpalay: ―Tacha ani iklajunaw k'ajamak'ats'aanit'iti an Jacobo chi an t'ala'awnin. Wa chuncha taxtulhcha, chi lakatamcha ampalh. ");
INSERT INTO tpp_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Akxni tunkunchalhcha, wa tilhilhicha ixtalayi an soldadojnin, mu jantu ixtak'atsayi tani lhitaxtulhcha an Pedro chi tanchuncha ixt'ajun. ");
INSERT INTO tpp_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","An Herodes lhinawlh li kapuxkawkalh, pero mu jantu lay tala'cha'alh, pus yucha an soldadojnini ixcuentajk'an ja'ilhtunilh chi jalhinawlhcha kajama'ni'okalh. Ixli'astan, an Herodes taxtulhcha Judea, alhcha tawlhna la'acha'an Cesarea. ");
INSERT INTO tpp_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","An Herodes wa ixjatalh'amniya an jamacha'an Tiro chi an jamacha'an Sidón, pero yu'uncha wa tami tak'atsaalh tani laycha katalhi'alh la'ts'inin. Talhipuxkawnilhi li oxi kajat'alalhi'alh xapumatam yu ixt'atapatsay an rey Herodes. Chi mu wachucha xa'ayi yucha, pus yuchacha tajunilh li kajat'anawlhi li wa oxicha katat'alalhi'alh an Herodes. Mu an la'acha'an Tiro chi an Sidón ancha ixta'an'ojoy lak'inin tanlhun yu ixtama'lhtask'iniy an la ixlakaat'un rey Herodes. ");
INSERT INTO tpp_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","An Herodes ja'ulanilh la'atam wilhchani tani wanancha katala'cha'ana pus takila'kilalhcha. Yucha ixla'ch'itacha yu laj'oxi ixla'ch'it yu ixpurey, chi tawilhcha tan ixtawlay tan ixp'uch'alhkatnan chi jaxa'alalhcha. ");
INSERT INTO tpp_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wa chuncha an lapanakni tsukulhcha talakt'asay, ixtalaknajun: ―¡Ani ixchiwinti dios, jantu wa lapanak! ");
INSERT INTO tpp_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Wa akxni pumatam ix'angelh an Dios, ilhtulh li kata'an'alhi an Herodes, mu jantu tu'u ixliwilay an Dios, pus nilhi an Herodes, wanaj pupa'olh tsapulh. ");
INSERT INTO tpp_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pero an ixchiwinti an Dios ali ali ixta'a'pitsit'ajun, wa tanchuncha sicha ixlichiwinkan. ");
INSERT INTO tpp_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Akxni an Bernabé chi an Saulo ta'ilhtu'olhcha ixtapatsatk'an an la'acha'an Jerusalén, ta'ancho'olhcha, talhi'alhcha wachu an Juan yu ixjumpalhkan Marcos. ");
INSERT INTO tpp_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","An tacha ixtata'ayxt'o'acha an yu ixtajakiklaka'inin an la'acha'an Antioquía, ixta'alin yu ixtalhichiwiniy an ixchiwinti Dios chi yu maestrojnin. Yu'uncha an Bernabé, chi Simón yu ixtajumpalay ma Ts'iti, chi Lucio jamacha'a Cirene, chi Manaén yu ayxtam t'ala'ayakalh an Herodes yu ch'alhkatnalh an xalakaat'un Galilea, chi Saulojcha. ");
INSERT INTO tpp_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","La'atam wilhchan akxni ixtatapayninit'ajun an Dios chi ixtalhitask'ajay ixwaytk'an, an ixTakuwin Dios nawlh: ―An Bernabé chi an Saulo, akilasakxtuniw, mu yu'uncha kata'ilhtuya an tapatsat yu ijkalhisakxtuta. ");
INSERT INTO tpp_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Pus wa chuncha tatapaynilhcha ixchuxk'an chi talhitask'ajalhcha ixwaytk'an, chi jalaklakpach'apakalhcha la ix'a'tsulhk'an chi ixli'astan jamala'achakalhcha tan kata'ana'. ");
INSERT INTO tpp_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","An Saulo chi an Bernabé yucha an ixTakuwin Dioscha jalhi'alh tan kata'alh, ta'alhcha la'acha'an Seleucia, chi ancha tapu'alhcha la'atam barco an xalakaat'un Chipre, ani lakaat'un wanaj la'atanchanu'ojota xkan. ");
INSERT INTO tpp_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Akxni tacha'alhcha la'acha'an Salamina, tsukulhcha talhichiwiniya an ixchiwinti Dios an laka lakcha'a tan ixtaputa'ayxt'o'a an judiojnin. An Juan wachu ani ixjat'a'anta tachanu ix'a'tayjunchak'an. ");
INSERT INTO tpp_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tata'a'cho'o'olhi ani lakaat'un tan wanaj la'atanchanu'ojota xkan. Chi tacha'alhcha la'acha'an Pafos, ancha tala'cha'alh pumatam lapanak yu jachawana', jamacha'a Judea, ixjunkan Barjesús. Ani lapanak ixnajun ma ixlichiwiniy ixchiwinti Dios, pero jantu yu sawalhi ixlichiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ani jachawanaj lapanak ixt'atala'xt'o'a an gobernador Sergio Paulo, pumatam lapanak yu ixjalakpastaknan. An gobernador lhinawlhi li kajakit'asanikalhi an Bernabé chi an Saulo, mu yucha ix'asmatputuni an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero an jachawanaj lapanak yu ixtalhimapa'a'uy lhigriego Elimas, wa jat'atasp'itlhi, jantu ixla'a'iy li an gobernador kakiklaka'ilhi an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pus an Saulo yu wachu jumpalhkan Pablo, mu sawalhcha ixlit'ajuni an Stalan'a Takuwin, sa'cha la'pula'ts'in, ");
INSERT INTO tpp_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","chi juniy: ―¡Ixjas'at'a xapay makxkay'un yu maslakatinin chi ayjunita, ixt'alaxkayna chux yu oxi! ¿Tasu li ali ali alhap'uyawlhip'iniya an ixtij Diosi? ");
INSERT INTO tpp_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chaway an Dios kamama'alh'ajniyan, k'ala'ach'ixlaya'a chaway chi ma'an lanani jant'u lay k'at'ila'ts'i an ixjatapulhkunu wilhchan. Pus wa tukan ma'la'ats'isli an la ixla'chulh an Elimas, chi ixpuxkajuycha xamati yu kama'ch'apalhi'alh, mu jantucha lay ixjalakawanan. ");
INSERT INTO tpp_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Akxni chunchacha la'ts'ilh an gobernador, jakiklaka'inilhcha, chi ixli'a'niycha tacha an ixtamasuy an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","An Pablo chi an ixt'alhtanan tataxtunilhi la'acha'an Pafos laka barco chi tacha'alhcha la'acha'an Perge xalakaat'un Panfilia, pero an Juan jantu jat'a'alh yucha ancho'olhcha Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Chi akxni tataxtucho'olhcha la'acha'an Perge, ta'alhcha la'acha'an Antioquía xalakaat'un Pisidia. Ancha la'atam sábado, tatanulhcha lakatam laka cha'a tan ixtaputa'ayxt'o'a an lapanakni judiojnin, chi sa'cha talaktawilh. ");
INSERT INTO tpp_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Akxni tapunaw'olhcha an lhamap'a'sin chi an ixlamap'a'sink'an yu ma'anchacha ixtalhichiwiniy ixchiwinti Dios, an xalaj'ajin an tan ixtata'ayxt'o'a an lapanakni tanajun: ―T'ala'awnin li sna tu'u k'anawna'it yu k'ajap'ula'oximaj'ayat'it an lapanakni, ch'awaych'a k'ana'unt'it. ");
INSERT INTO tpp_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pus wa chuncha an Pablo tayalh chi jatamakyawnilhcha, jajuniy li kasa'ka talajkilhulh, chi jajuniy: ―Jamacha'an Israel chi masi yu jantu an mila'acha'ank'an, pero yu k'iklak'a'iyat'it an Dios, k'a'asmatt'it. ");
INSERT INTO tpp_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","An ixDiosk'an xalapanakni Israel yu'uncha an yu ta ixjalhila'ts'inawi jasakxtulh. Wanaj lhuwi ja'ilhtulh akxni wa ixtama'wilananchalhka xalakaat'un Egipto, tan jantu la ixlakaat'unk'an, chi ixli'astan la ix'alhp'asninti an Dios jamaxtulhi an la xalakaat'un Egipto. ");
INSERT INTO tpp_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","An Dios lhitayanilhi an ixlakatijlak'an an lapanakni t'upuxam k'ata, an lakalakxixni lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","An xalakaat'un Canaán lakatujun la'acha'ani lakt'ilhilh an Dios, para li an ixlakaat'unk'an ani la'acha'anaxni, yucha an yu tacha ixjalhila'ts'inawi kajaxta'nikalh. ");
INSERT INTO tpp_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tacha ani tapasalh ka tacha la'at'at'i ciento at'up'uxamkaw (450) k'ata ta'a'ma'alh. Ixli'astan an Dios jaxta'nilhcha jueznini an israelitajnin sta akxni ixt'ajun an yu ixlichiwiniy ixchiwinti Dios, yu ixjunkan Samuel. ");
INSERT INTO tpp_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Wa chuncha an lapanakni task'inlhi pumatam rey yu kajach'alhkatnanilh, pus an Dios jaxta'nilhcha an Saúl, para li yuchacha kawalh rey. An Saúl ists'alh tichi yucha yu ixjunkan Cis, yu ta ixlila'ts'in an Benjamín. An Saúl t'up'uxam k'ata ch'alhkatnalh. ");
INSERT INTO tpp_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ixli'astan akxni ma'osukalhcha ixlirey an Saúl, yucha an Davidcha jaxta'nicho'olh an lapanakni an Dios para li yuchacha kajuncho'olh rey, an Dios nawlh: “An David, ists'alh Isaí oxi iklhiwilay, mu yucha ka'ilhtuya chux yu kit'in iklakask'in.” ");
INSERT INTO tpp_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pumatam yu yucha pu'a'p'unminchalh ani David yucha an Jesús, chi an Dios mala'achalhi an Jesús para li ka'alh jama'alhtaxtunu xalapanakni Israel, tacha ixnajuntacha li ka'ilhtuya an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Akxni jantuka' ixmin an Jesús, an Juan ixjalhixa'alaycha an xalapanakni Israel an ixchiwinti Dios, ixjajuniy li katakiklaka'ilhcha an Dios chi li katalaj'a'paxlicha. ");
INSERT INTO tpp_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Chi akxni an Juan ix'ilhtu'ot'ajuncha an ixtapatsat, nawlh: “Kit'in jantu yu an yu uxitnan p'ast'ak'at'it. Pero ixli'astan kamina pumatam yu masi wa ak'ukxmala'xtunilhcha ixwarachi kit'in jantu k'is ikt'acha'an.” ");
INSERT INTO tpp_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’T'ala'awnin, yu p'u'a'p'unt'ant'achi'it an Abraham chi wachu uxitnan masi yu jantu judiojnin pero yu k'iklak'a'iyat an Dios, ani chiwinti yu puta'alhtaxtukan yucha para kitnan. ");
INSERT INTO tpp_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mu an yu ixtawilanalh la'acha'an Jerusalén chi an ixlakjamach'alhkatnik'an, jantu tamispalhi an Jesús chi jantu talhimacha'xalhi an ixchiwintik'an an yu ixtalhichiwiniy ixchiwinti Dios, yu ixpunawkan an laka cha'a tan tata'ayxt'o'a an lapanakni akxni jantu tapatsakan wilhchan. Xliyu akxni tama'nilhi an Jesús wa yu'unchacha tamuktaxtulh tacha an ixnawkanta li katapasaya'. ");
INSERT INTO tpp_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Chi masi jantu k'is tu'u tala'cha'aninilh para li katama'nilhcha, tajunilhi an Pilato li kalhinawlhcha li kama'nikalh. ");
INSERT INTO tpp_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wa chuncha akxni ta'ilhtu'olhcha tacha an ixnajunta tan ists'o'muk'akanta li katapasaniya an Jesús, tama'alhtajucho'olhcha an laka cruz chi tamaknulhcha. ");
INSERT INTO tpp_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero an Dios mala'awnicho'olh. ");
INSERT INTO tpp_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Chi la'alhuw wilhchani an Jesús jatalakasunitsukulh an lapanakni yu ixtat'a'anta la'acha'an Jerusalén, akxni tat'aminchalh sta xalakaat'un Galilea. Pus yu'uncha tala'ts'ilhi an Jesús chi chaway talhichiwiniycha la ix'ukxlakapuk'an an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Kitnan chaway iklamak'atsaanit'awnaw an laj'oxi chiwinti yu an Dios jajunilh an yu ta ixjalhila'ts'inaw li kamuktaxtuya'. ");
INSERT INTO tpp_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Chaway kitnancha kintamuktaxtunin, mu kitnancha xajas'at'an. Muktaxtuycha an Dios, mu mala'awnicho'olhcha an Jesús, tacha an ts'o'muk'akanta an la ixchiwinti, tan junkan salmo segundo, tan najunta: “Uxint'i kinTs'alhk'at'i, mu kit'in chaway ikmala'awnicho'oncha.” ");
INSERT INTO tpp_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","An Dios ixnajuntacha li kamala'awnicho'oya', para li an ixlakatunaj jantu kalakp'uch'ilh, akxni nawlh: “Akmuktaxtuya sawalhi an laj'oxi chiwinti yu ijkunilh an David li ak'ilhtuya'.” ");
INSERT INTO tpp_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Xliyu wachu an lakatam wachu nawpalata: “Jant'u k'at'imak'awi li kalakp'uch'ilh an ixlakatunaj amilapanak yu sakxt'u, yu t'atapatsayan.” ");
INSERT INTO tpp_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pus chun sawalh akxni ixt'ajun an David jatapatsanilhi an ali'in, tacha ixlijunita an Dios li ka'ilhtulh, chi ixli'astan nilhcha, pus jala'cha'ancho'olhcha an ixpaynin, chi an ixlakatunaj lakp'uch'ilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero an ixlakatunaj an pumatam an yu Dios mala'awnicho'olh, yucha jantu lakp'uch'ilh. ");
INSERT INTO tpp_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pus chaway k'ak'ats'at'itcha aniya t'ala'awnin, yucha an Jesusi p'umak'ats'aanik'anat'it li layi k'amala'mixinik'ana'it'it mintala'alhink'an. ");
INSERT INTO tpp_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Li k'iklak'a'iyat'iti an Jesús yuch'a k'ap'umala'mixinik'ana'it'it wa tuchicha mintala'alhink'an, yu jant'u lay mala'mixinik'ant'it an la ixlamap'a'sin Moisés. ");
INSERT INTO tpp_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pus k'ajalajk'ats'anant'it, para li jantu uxitnani ch'unch'a k'ap'ut'ap'asat tacha an tats'o'lhi an yu ma'anchacha ixtalhichiwiniy ixchiwinti Dios, tan najunta: ");
INSERT INTO tpp_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Uxitnan yu jant'u k'is tu'u jalhiwilanant'it, k'alhak'ap'up'it'itcha, ch'i k'alhi'a'nit'itcha ch'i k'alaknit'itcha. Mu chaway ani panch'e'ex t'awnat'it kit'in ik'ilhtuy la'atam tapatsat yu jantu k'is k'at'ik'iklak'a'it'iti masi xamati katajunan. ");
INSERT INTO tpp_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Akxni an Pablo chi an ixt'alhtanan tataxtucho'olhcha an laka cha'a an tan tata'ayxt'o'a an lapanakni, an lapanakni tajuniy li ma akxni kachimpala wilhchan yu jantu putapatsakan ma a'tam katalhichiwimpalhi ani laktanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pus akxni la'olhcha an lakchiwinti an laka cha'a, ixluwk'an an judiojnin chi an yu wachucha judiojnin tajunlhi masi yu'uncha jantu Judea tatsukulh, tach'a'o'alhcha an Pablo chi an Bernabé. Chi yu'uncha tat'alajunilhcha li katach'a'o'a'alhilhcha sawalhi an Dios, mu yucha jat'asaniy, mu jamapayniy. ");
INSERT INTO tpp_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Akxni chimpalhcha wilhchan yu jantu putapatsakan, wanajcha lanan lhichux an la'acha'ani tata'ayxto'lhi an lapanakni para li kata'asmatlhicha an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero an judiojnin, mu tala'ts'incha li wanajcha lhilhuw, pus talhitalh'amalhcha, tsukulhcha ta'alhapu'iyawniya an ixchiwinti an Pablo, chi wa aya ixtajuniycha. ");
INSERT INTO tpp_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pus wa chuncha an Pablo chi an Bernabé, jo'ati tachiwinilh, ta'alhtaylh tat'alajuniy: ―Kitnan lhitask'iniya li aklamak'atsaaniwi an ixchiwinti Dios uxitnan p'ulhnaj, mu uxitnan judiojnin. Pero li uxitnan jant'u asmatp'ut'unat'it ch'i li lhi'ilht'uyat'iti li jant'u t'ach'ip'inat'iti li k'alhits'uk'ut'it an jatsukunti yu jantu a'tam min'ojoy, ak'anawcha tan jantu judiojnin tawilanalh. ");
INSERT INTO tpp_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Mu chuncha kintalhijunin an Dios. Yucha kintajunin: Uxint'i k'ulatan tachanu jatapulhkunu para ixchuxk'an an yu jantu judiojnin, para li k'ajalhip'inini yu kataputa'alhtaxtuya', wa tanchuncha masi ma'at ani lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Akxni chunchacha ta'asmatlhi, an yu jantu judiojnin talaj'achalhcha, chi tsukulhcha talaknajuni li an ixchiwinti Dios oxi, pus takiklaka'ilhcha ixchuxk'an an yu ixjalhisakxtukanta li katalhitsukuya jatsukunti yu jantu a'tam min'ojoy. ");
INSERT INTO tpp_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Chi an ixchiwinti an Dios wanajcha ta'a'pitsi'olhi ta ixlijalhi'ay anchunu lakaat'un. ");
INSERT INTO tpp_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero an judiojnin tat'achiwinilh ali'in t'akunin yu ixtapuxkajuy an Dios chi xalaj'ajincha lapanakni ixjalhiwilakan anchunu la'acha'an, para li kajach'a'o'akalhi an Pablo chi an Bernabé chi kajatamakxtukalhcha anchunu la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pus wa chuncha an Pablo chi an Bernabé talakch'ank'alhap'uxkalhi an po'xmi para li katala'ts'ilhi an lapanakni li jantu oxi tacha an talay, chi ta'alhcha la'acha'an Iconio. ");
INSERT INTO tpp_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Chi an ixt'alhtanan an Jesús sawalhcha ixtalhit'ajuni an Stalan'a Takuwin chi sawalhcha ixtalaj'achan. ");
INSERT INTO tpp_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","An la'acha'ancha Iconio, an Pablo chi an Bernabé wa ayxtamcha tatanuchalh an laka cha'a tan ixtaputa'ayxt'o'a an judiojnin chi ixluwk'ani takiklaka'ilh an yu judiojnin chi an yu jantu judiojnin an tacha talhichiwinilh. ");
INSERT INTO tpp_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero an judiojnin an yu jantu ixtajakiklaka'inin ta'ilhtulhi li an yu jantu judiojnin katat'alaxkaylhi an t'ala'awnin. ");
INSERT INTO tpp_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pero an Pablo chi an Bernabé ma'ani ancha ixtawilanalh, jantu ixtatalhanani ixtalhichiwiniy an ixchiwinti Dios, mu ixtakiklaka'iya li an Dios ancha ixjat'a'aklat'ajun. Ixmasuyi an Dios li an yu ixtanajun, sawalh, mu an Pablo chi an Bernabé ixjapu'ilhtuycha an Dios tanlhun yu la'lhi'a'nin, chi laycha ixtajak'uch'unun. ");
INSERT INTO tpp_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","An lapanakni yu ancha jamacha'an ixtatala'apitsitacha, an ali'in ixtat'a'ancha an yu judiojnin chi an ali'in yu'uncha an Pablojcha chi an Bernabé. ");
INSERT INTO tpp_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pus akxni an yu judiojnin ali an yu jantu judiojnin tat'atamakawlhcha an jamach'alhkatni li kajalhitama'chapukanacha chi kajalakt'alhmakanacha an Pablo chi an Bernabé. ");
INSERT INTO tpp_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Walh yu'uncha tak'atsaalh, pus ta'alhcha la'acha'an Listra chi Derbe, xala'acha'anaxni an xalakaat'un Licaonia, chi alicha la'acha'anaxni yu anchacha ixlak'alin. ");
INSERT INTO tpp_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Wachu talhichiwinilhi ancha an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","An la'acha'an Listra ixt'ajun pumatam lapanak yu jantu lay ixjalhtanan. Jantu a'tam ixjalhtananta, mu wa ch'anlh'awilhi ixjunita, wachunchacha ixla'ajunta. Ani lapanak sa' ixwilh, ");
INSERT INTO tpp_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ix'asmatt'ajun yu ixnawt'ajun an Pablo, walh an Pablo lhakapu'alh chi la'ts'ilhi li layi katak'uch'ulh, mu ixjakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Pus an Pablo p'ascha junilh: ―¡K'at'aycha ts'awjcha k'ap'ut'ay aminch'aja'! An lapanak t'ujcha tayalh chi tsukulhcha jalhtanan. ");
INSERT INTO tpp_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Akxni an lapanakni tala'ts'ilhcha tacha an ilhtulh an Pablo, tsukulhcha talakt'asay, ixtalaknajuncha ixlichiwink'an an de Licaonia: ―¡Kintala'chintan diosnin yu wa tacha lapanakni, talhmani tamintachalh! ");
INSERT INTO tpp_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Chi an Bernabé talhimapa'a'ulhcha ma dios Jupiter, chi an Pablo ma dios Mercurio, mu yucha yu ixchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Chi an xasacerdote jupiter, yu ixyalh ixtajtan la ixlakapu an la'acha'an, jalhimilhcha torojnin chi xanti, para li yucha ali an lapanakni katalha'ulananilhcha an Pablo chi an Bernabé. ");
INSERT INTO tpp_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero an Bernabé chi an Pablo tak'atsaalh, chi yu'uncha tala'lh'alhi an ixla'ch'itk'an chi tapujatanulhi an lapanakni, p'ascha tanajun: ");
INSERT INTO tpp_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―¡Lapanakni, ¿t'asu li ch'unch'ach'a layat'iti? Kitnan wa lapanakni, tacha uxitnan, kitnan xliyu iklhimintaw li aklamak'atsaaniw an laj'oxi chiwinti, para li k'amak'a'unt'itcha ani tanlhun yu jantu tu'u lhitapalay, chi li k'ak'iklak'a'it'itcha an Dios yu la'ajunta, yu ilhtulh an lakt'iyan chi an lakaat'un, chi an alamalh chi chux yu ancha lak'alin! ");
INSERT INTO tpp_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Masi minchalhcha panch'e'ex an Dios makawlhi li atamj atamj kalalhcha wa tani laputuncha ");
INSERT INTO tpp_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","pero jantu a'tami jantucha kamasulhi tichini yuchacha yucha, tacha an laj'oxi tanlhun ix'ilhtuy. Mu yucha tamakminiyan an xkan chi li oxi kalak'alilh an jach'ananti, chi yucha taxta'niyan li lhuwi ka'alilh yu k'a'ut'it ch'i k'alaj'ach'ant'it. ");
INSERT INTO tpp_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero masi chunchacha tajunilh an lapanakni, sawalhcha lhima'anxkayi talhiwilalh an Pablo chi an Bernabé para li an lapanakni jantu kataja'ulananilh. ");
INSERT INTO tpp_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chi wa akxni tacha'alhcha tichi yu'uncha judiojnin jamacha'an Antioquía chi jamacha'an Iconio, chi yu'unchacha ta'ilhtulh li tamcha katapastaklhi an lapanakni. Pus talakat'alhmalhcha an Pablo, chi mu talhi'ilhtulh li tama'nilhcha, taxa'axtulhcha an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero akxni an yu ixtajakiklaka'inincha tata'ayxto'lhicha ixtuntala'acho'o an tan ixmalh an Pablo, yucha ostayalhcha chi tanupalhchalhcha a'tami an la'acha'an, chi akxni tunkunchalhcha ta'alhcha ali an Bernabé la'acha'an Derbe. ");
INSERT INTO tpp_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Akxni jamak'atsaaninin'olhcha an laj'oxi chiwinti an la'acha'an Derbe, tan wanaj lhuw tajakiklaka'inilh, ta'ancho'olhcha la'acha'an Listra chi Iconio chi Antioquía. ");
INSERT INTO tpp_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ani la'acha'anaxni tat'alamachapulhi an yu ixtajakiklaka'inincha, ixtat'alajuniy li oxi katataylhi'alh an la ixjakiklaka'intik'an, tat'alajuniy li para lay tanukanachalh an la ixlich'alhkat Dios lhuw tanlhuni ma'alh'ajnankan. ");
INSERT INTO tpp_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Chi an Pablo chi an Bernabé talhka'ulapalhi laktatanin para li katala'ts'ilhi'alhi an ixlapanakni Dios. Chi akxni tatapayni'olhcha chi talhitask'aja'olhcha ixwayt'an, an Pablo chi an Bernabé tama'axta'nilhcha an Dios an lapanakni an yu jalhka'ulakalh, mu yucha an Diosi yu ixtakiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Yu'uncha tala'puslicha xalakaat'un Pisidia chi tacha'alhcha xalakaat'un Panfilia. ");
INSERT INTO tpp_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Talhichiwinilhcha an ixchiwinti Dios an la'acha'an Perge chi ixli'astan ta'alhcha an la'acha'an Atalía. ");
INSERT INTO tpp_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chi ancha tapu'alhcha barco la'acha'an Antioquía tan ixtataxtunitachalh akxni ta'alhcha ilhtunin an tapatsat yu ta'ilhtu'olhcha, ancha tan ixjajunkanta li Dioscha kaja'a'tayjulh para li kataki'ilhtulhi an tapatsat yu taki'ilhtu'olhcha. ");
INSERT INTO tpp_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Akxni tacha'alhcha Antioquía tama'ayxto'lhicha an yu ixtajakiklaka'inin, chi tat'alajun'olhcha chux tacha an Dios japu'ilhtulh, chi li an Dios wachu tachanu jamalhti'anilhi an malhticha para li lay katajakiklaka'inilh an yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Chi an Pablo chi an Bernabé ma'ancha tat'atamakawlh ancha an yu ixtajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tichi yu'uncha lapanakni yu ixtamintachalh xalakaat'un Judea, tacha'alhi la'acha'an Antioquía. Chi tsukulhcha tamasuniya an t'ala'awnin li ma jantu katitata'alhtaxtulhi li jantu jalaj'akaxwililich'uk'up'uxkani ix'a'axt'a'ak'an, tacha najunta an la ixlamap'a'sin Moisés. ");
INSERT INTO tpp_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","An Pablo chi an Bernabé yu'uncha jantu ixtala'a'iya tacha ani ixtamasuy an tichi yu'uncha lapanakni. Stak tat'alakikxtukulh, wa chuncha, t'atawlhkanchalhi li an Pablo chi an Bernabé chi ali'incha, kata'alhi la'acha'an Jerusalén, para li katakit'achiwinilhi an yu ixjamala'achata an Jesús chi an laktatanin, yu xalaj'ajin, ixlakata an yu talalhikikxtukuy. ");
INSERT INTO tpp_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pus jamala'achakalhcha, yu'uncha an yu ixtajakiklaka'inincha tajamala'achaninilh, chi akxni ixtala'pust'ajuncha xalakaat'un Fenicia chi Samaria ixtajamak'atsaaninincha li an yu jantu judiojnin tamakawlhcha yu ixtakiklaka'iy p'ulhnaj, para li katach'a'o'alhcha an Dios. Pus ixchuxk'an an t'ala'awnin sawalhcha ixtalaj'acha'ni akxni chunchacha tak'atsaalh. ");
INSERT INTO tpp_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Akxni an Pablo chi an Bernabé tacha'alhcha la'acha'an Jerusalén, an yu ixtajakiklaka'inincha chi an yu ixjamala'achata Jesús chi an laktatanin oxi tala'a'ilh. Chi yu'uncha tanaw'olhcha chux yu an Dios jat'a'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero ali'in lapanakni an yu ixjajunkan fariseojnin, yu ixtajakiklaka'ininta, tatayalh, tanajun: ―Lhitask'iniya li kajalaj'akaxwililich'uk'up'uxkalhi ix'a'axt'a'ak'an an yu jantu judiojnin yu tajakiklaka'inintacha, chi kajajunikalhi li kata'ilhtulhi an ixlamap'a'sin an Moisés. ");
INSERT INTO tpp_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Pus wa chuncha tata'ayxto'lhicha an yu ixjamala'achata Jesús chi an laktatanin, para li oxicha katalhilakchiwinilh an yu talalhikikxtukuy. ");
INSERT INTO tpp_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ixli'astan akxni stakcha lalhikikxtukukalh, an Pedro tayalhcha chi jajuniy: ―T'ala'awnin, uxitnan k'ats'ayat'iti li ma'anchacha, an Dios kisakxtulhi de kitnan, para li ajkamak'atsaanilhi an laj'oxi chiwinti an yu jantu judiojnin, para li yu'uncha katajakiklaka'inilh. ");
INSERT INTO tpp_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Chi mu an Dios yucha mispa'ojoyi chux jalhunut, yucha masulhi li wachu jala'a'iy, mu jaxta'nilhi an Stalan'a Takuwin tacha kitnan kintaxta'nin. ");
INSERT INTO tpp_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","An Dios jantu tu'u najun li yu'uncha tamj chi kitnan tam, yu'uncha wachu jamastalan'anilhi ixjalhunutk'an, mu tajakiklaka'inilhcha. ");
INSERT INTO tpp_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pus chaway, ¿tasu li wa lhila'ts'inatcha an Diosi, li ja'unatcha ani yu tajakiklaka'inincha li katak'uk'alhcha ts'ink'i tak'uk'ati? An ta ixjalhila'ts'inaw chi kitnan jantu lay lhi'anaw. ");
INSERT INTO tpp_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Jantu chun, kitnan k'atsayawi li jantu tu'u ilhtutaw masi ta'alhtaxtutawcha, ta'alhtaxtutaw wa xliyu an Jamach'alhkat Jesús kintamapayniyan, tacha jamapayniy yu'uncha. ");
INSERT INTO tpp_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pus wa chuncha wanaj sa' talajkilhun'olh, chi ixta'asmat'acha tacha ixtanajun an Pablo chi an Bernabé, li an Dios ixjapu'ilhtuycha tanlhun yu sawalh la'lhi'a'nin an tan ixtawilanalh an yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Akxni tachiwin'olhcha an Jacobo, najun: ―T'ala'awnin, akila'asmatniw, ");
INSERT INTO tpp_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","an Simón kintajunincha tacha an Dios oxi wachu ja'ilhtuy wa ixlikutsajka an yu jantu judiojnin, wachu jasakxtuyi yu yu'uncha para li katawalhi ixjas'at'an. ");
INSERT INTO tpp_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tacha ani tapasay, ts'ajwi t'ala'an tacha an tats'o'lhi an yu ixtalhichiwiniy ixchiwinti Dios, tan najunta: ");
INSERT INTO tpp_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ixli'astan akmincho'oya chi akla'oxicho'oya an ixcha'a David yu ta'a'talh. Akla'oxicho'oya an yu tilaktamakawwilh. Oxi ak'ilhtucho'oya'. ");
INSERT INTO tpp_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Para li an ali'in akintapuxkawlh, chi ta kilhmakchux lapanak yu ikjasakxtuta katamispalhi kinta'a'ut. ");
INSERT INTO tpp_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Chuncha najun an Dios yu lak'ilhtuy ani laktanlhun, yu wa ma'anchacha lakmispakan. ");
INSERT INTO tpp_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Pus yu kit'in iknajun, an yu jantu judiojnin yu tamakajuncha yu ixtakiklaka'iy ixlip'ulhnaj chi tach'a'o'aycha Dios, jantu layi katijajunkalhcha li kata'ilhtulhi tu'u yu jantu lhitask'iniy. ");
INSERT INTO tpp_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Oxicha li jats'o'nikancha li jantucha kata'ilhtulhi yu jasmala'aninin, ixlakatak'an an tacha la'laa'oxikanta yu tacha ixdioschak'an ixtala'ts'in, chi li jantucha katalaxa'alalhi yu jantu talat'at'ajun, chi li jantucha kata'ulhi jatapakxat yu wa aksk'anj'uta chi an ixjak'alhni tu'u jatapakxat. ");
INSERT INTO tpp_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Mu ma'anchacha ta'alin lakatamin la'acha'anaxni, yu talhichiwiniy an ixlamap'a'sin Moisés chi tamin sábado punawkani yu yucha an laka lakcha'a tan puta'ayxto'kan. ");
INSERT INTO tpp_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wa chuncha an ixjamala'achata Jesús chi an laktatanin chi ixchuxk'an an yu ixtajakiklaka'inin, tasakxtulhi lapanakni yu de yu'uncha para li katat'amak'alhcha la'acha'an Antioquía an Pablo chi an Bernabé. Yu sakxtukalh yucha an Judas yu ixtajumpalay ma Barsabás chi pumatam yucha an Silas. Ani lapanakni ixtalhitapalayi tacha an ixtat'ajun t'ala'awnin. ");
INSERT INTO tpp_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Chi yu'unchacha japumala'achakalh ani carta: “Kitnan yu kintamala'achayan an Jesús chi an laktatanin mijat'ala'awnink'ani uxitnan, ijkala'axa'alayawi an t'ala'awnin yu jantu judiojnin yu tawilanalh la'acha'an Antioquía chi xalakaat'un Siria chi xalakaat'un Cilicia. ");
INSERT INTO tpp_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ijk'atsayawi li tichi yu'uncha lapanakni yu jantu kitnan ijkamala'achaw, aniya tataxtulh, chi li sawalhcha tama'achapuyani uxitnan la ixchiwintik'an, chi li tamala'a'o'xcho'oyancha. ");
INSERT INTO tpp_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Xliyu iklhipastakwi mu chuncha yu oxi iklhiwilaw li ajkalhka'ulaw lapanakni yu kitnan para li kata'ancha'an la'ts'inin ali an yu sawalhcha oxi ijkalhiwilayaw kint'ala'awnink'an Bernabé chi an Pablo. ");
INSERT INTO tpp_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Yu'uncha an ixjatsukuntik'an wa k'is k'ischa tata'alhtaxtulh, ixlakata an Jamach'alhkat Jesucristo. ");
INSERT INTO tpp_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pus iklamala'achaniyawi an Judas chi an Silas, yu'unchacha katajunan la ixkilhnik'an chux ani tanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Mu an ixTakuwin Dios chi kitnan oxi iklhiwilayaw li jant'uch'a ali k'amak'uk'ak'ant'iti ali tanlhun, kalayantacha t'ach'a ani unk'anat'it. ");
INSERT INTO tpp_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Li jant'uch'a k'a'ut'iti an lhiway yu ixja'ulanikantacha an yu tacha ixdioschak'an tala'ts'in an lapanakni. Ch'i li jant'uch'a k'a'unit'iti ixjak'alhni tu'u jatapakxat, chi yu wa aksk'anj'uta jatapakxat, ch'i li jant'uch'a k'ajaxa'alat'iti yu jant'u t'at'awnat'it. Li ch'unch'ach'a k'a'ilht'uya'it ani tanlhun, oxich'a k'ats'uk'uya'it'it. Iklala'axa'alayaw.” ");
INSERT INTO tpp_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pus akxni tajala'axa'alanan'olhcha, ta'alhcha la'acha'an Antioquía, chi akxni tacha'alhcha, tama'ayxto'lhicha an t'ala'awnin chi taxta'nilhcha an carta. ");
INSERT INTO tpp_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Akxni an t'ala'awnin tapunawlhcha, sawalhcha ixtalaj'achan, mu ixjama'oximaj'ayaycha tacha an ixnajunta. ");
INSERT INTO tpp_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Chi mu an Judas chi an Silas wachu ixchiwinti Diosi ixtalhichiwiniy, pus sawalhcha tama'oximaj'ayalh chi sawalhcha tamachapulhi an t'ala'awnin an la ixchiwintik'an. ");
INSERT INTO tpp_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Chi alhcha panch'e'ex ancha ixtat'ajun, an yu ancha jamacha'an t'ala'awnin tamala'achacho'olhcha laka laj'oxi chiwinti, para li kata'ancho'olhcha tan tawilananchalh yu tamala'achalh.  ");
INSERT INTO tpp_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero an Silas yucha oxicha lhiwilalh li anchacha katamakawlh. ");
INSERT INTO tpp_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Chi an Pablo chi an Bernabé yu'uncha la'acha'an Antioquiajcha tatamakawlh, ixtamasuy ali chi ixtalhichiwiniy ali an ixchiwinti Dios, ali an ali'in lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Alhcha panch'e'ex, an Pablo juniy an Bernabé: ―Ka'ampalawcha jala'pixiyalhnin an t'ala'awnin ta lakachux an la'acha'anaxni tan lhichiwintawcha an ixchiwinti Dios, para li kak'atsawi tani tat'ajuncha. ");
INSERT INTO tpp_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","An Bernabé ixnajun li kaxjat'a'alh an Juan yu ixtajumpalay ma Marcos, ");
INSERT INTO tpp_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero an Pablo najun li jantu ka'alh, mu an Marcos an xalakaat'un Panfilia wa ixjat'alamakajunta chi jantucha ali ixjat'ataylhi'anta an tapatsat. ");
INSERT INTO tpp_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Pus yuchacha ixlakata li jantu wa tam tapastaklhi, an Pablo chi an Bernabé talamakawlhcha. An Bernabé t'a'alhcha an Marcos, tapu'alhcha barco la'cha'an Chipre. ");
INSERT INTO tpp_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Chi an Pablo yucha an Silascha t'atala'xto'lhi. Chi ixli'astan an t'ala'awnin tatapayninilhcha an Dios para li kalhistaklhi an Pablo, chi ancha taxtulhcha, ");
INSERT INTO tpp_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","xalakaat'un Siria chi Ciliciaja tala'puschalh, ixtat'alamachapuycha an t'ala'awnin yu ancha jamacha'an, yu ancha ixtala'ta'ayxt'o'a. ");
INSERT INTO tpp_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ixli'astan an Pablo cha'alhcha la'acha'an Derbe chi lakatam la'acha'an tan junkan Listra, ani la'acha'an la'cha'alh pumatam yu ixjakiklaka'inin, ixjunkan Timoteo, ists'alh tichi yucha t'aku judia yu ixjakiklaka'inin chi yu ixpay griego. ");
INSERT INTO tpp_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","An t'ala'awnin yu jamacha'an Listra chi jamacha'an Iconio oxi ixtalhichiwiniy an Timoteo. ");
INSERT INTO tpp_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pus an Pablo oxi lhiwilalh li kat'a'alh, pero p'ulhnaj ilhtulhi li ka'akaxwililich'uk'up'uxk'alh an ix'a'axt'a'a, ixlakatak'an an jamacha'an Judea yu ancha ixtalakwilanalh, mu ixchuxk'ani ixtak'atsay li an ixpay an Timoteo jamacha'a Grecia. ");
INSERT INTO tpp_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ta lakachux la'acha'an ixtala'pus'anta, tamak'atsaanilhi an t'ala'awnin an ixlamap'a'sink'an an yu ixjamala'achata an Jesús chi an laktatanincha yu ixtat'awnachalh Jerusalén. ");
INSERT INTO tpp_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Pus ta kilhmakchux tacha an ixtata'ayxt'o'acha an yu ixtakiklaka'iycha Dios, oxicha ixtajakiklaka'inin, chi palay palay ixtatalhawayi an yu ixtajakiklaka'inin tamin wilhchan. ");
INSERT INTO tpp_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Chi mu an Stalan'a Takuwin jantu jamakawnilhi li katalhichiwinilhi an ixchiwinti Dios an xala'acha'anaxni Asia, pus ta'alhcha xala'acha'anaxni Frigia chi xalakaat'un Galacia. ");
INSERT INTO tpp_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Chi akxni tacha'alhcha tanchun xalakaat'un Misia, de ancha ixtak'uxa'ancha xalakaat'un Bitinia, pero an ixTakuwin Jesús jantu jamakawnilh. ");
INSERT INTO tpp_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Pus wa wak tala'pusli xalakaat'un Misia, ta'alhcha la'acha'an Troas. ");
INSERT INTO tpp_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ancha an Pablo, puts'ista jala'awanalh, tan la'ts'ilh pumatam lapanak jamacha'a Macedonia, anchacha sa' ixyalh chi ixtapaynisk'inikancha an Pablo ixjunkan: “K'at'at'i xalakaat'un Macedonia chi akilalhi'a'tayjuw.” ");
INSERT INTO tpp_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Akxni chunchacha la'ts'ilh an Pablo, ixli'astan watukan ikmala'asijniwi para li ak'aw xalakaat'un Macedonia, mu oxicha xajk'atsayaw li yucha an Diosi kixtat'asaniyan para li ancha aklhichiwiniw an laj'oxi chiwinti. ");
INSERT INTO tpp_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pus la'acha'ancha Troas xakt'awnaw, ikpu'awcha barco lakatam lakaat'un yu la'acho'oni'ojoy xkan ixjunkan Samotracia, chi tunkunchalh ik'awcha la'acha'an Neápolis. ");
INSERT INTO tpp_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Chi de ancha ik'awcha la'acha'an Filipos, ani la'acha'an Filipos yucha yu palay ixlitapalay an xalakaat'un Macedonia chi yucha la'atam la'acha'an tan ixtawilanalh yu jamacha'an Roma, anchacha xakt'awnaw lanan la'alhuw wilhchan. ");
INSERT INTO tpp_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","La'atam sábado iktaxtuw ma'spa an la'acha'an, ik'awcha waniy lakatam ayxkan, tan a'tajcha ixtapaynikan, chi ancha, iklaktawlawcha, chi xajkalhixa'alayawcha an ixchiwinti Dios an t'akunin yu ancha ixta'ayxto'nun. ");
INSERT INTO tpp_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Xapumatam ani t'akunin ixjunkan Lidia, jamacha'a Tiatira, yucha ist'ay la'ch'it yu xmumuw, yu xtapalh la'lhuw, chi mu ixkiklaka'iya an Dios, sa'cha ix'asmat'a an yu xaknawt'awnaw, walh an Jamach'alhkat Dios malhti'anilhi an ixjalhunut, para li sawalhcha kalhakapu'alhi an yu ixnawt'ajun an Pablo. ");
INSERT INTO tpp_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Akxni a'paxlicha an Lidia wanaj jat'a'a'pax'olhi chux yu ta jalhila'ts'in, chi ixli'astan sawalhcha kintatapayninin kintajunan: ―Li nawnatcha li ijkiklaka'iycha sawalhi an Dios, k'at'atcha tamakawnini an la kincha'a'. Pus kintamatanunini ak'aw tamakawnin an la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","A'tam walh, akxni xakti'anaw an tan tapaynikan, ikpaxto'wi pumatam jatsi yu ixlit'ajun la'atam takuwin yu ixpala'ts'ikutunun. Ani jatsi wa ixputapatsakancha, mu esclavaja ixjunita, ixjalhit'ajun ixpatronin yu wanajcha la'lhuw tumini ixtapulhajay li ixla'ts'ikutuniycha tu'u xamati'. ");
INSERT INTO tpp_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","An Pablo chi kitnan tsukulhcha kintach'a'o'ayani an jatsi', chi p'ascha ixt'asay ixnajun: ―¡Ani lapanakni yucha an Dios yu wilhchalh talhmani tat'atapatsay, tamak'atsaaniyani an tij yu puta'alhtaxtukan! ");
INSERT INTO tpp_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Chi mu wanajcha la'alhuw wilhchani chuncha ixlay, pus an Pablo ja'scha mawalh, chi juniy an makxkay'un, an yu ixlakpach'apay an jatsi: ―¡La ixta'a'ut an Jesucristo ijkunan k'amak'awcha an jatsi'! Pus wanaj wa akxni, an makxkay'un makawlhcha an jatsi'. ");
INSERT INTO tpp_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero akxni an ixpatronin an jatsi tala'ts'ilhcha li tucha lay ali katitapulhajalh, tach'apayawlhcha an Pablo chi an Silas, talhi'anilhcha an jamach'alhkatni an ixtan'ajni la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","La ixlakapucha an jueznini jalhicha'ankalh, chi tanajun an yu ixtalhi'anta an Pablo chi an Silas: ―Ani lapanakni yu'uncha judiojnin chi wa tachiwiwayi an lapanakni ani kila'acha'ank'an, ");
INSERT INTO tpp_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","chi tanlhuncha tamasuy yu kitnan jantu katimakajuw li chunchacha ka'ilhtukalh, mu kitnan jamacha'an Roma. ");
INSERT INTO tpp_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pus wa chuncha an lapanakni tala'talh'amalhcha, jaxkaykalhcha an Pablo chi an Silas, an jueznin talhinawlhcha li kajala'la'a'exkalhcha an ixla'ch'itk'an chi li kajala'na'makalhcha laka lakmakat'ikt'i k'iw. ");
INSERT INTO tpp_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Akxni stakcha jala'na'ma'okalh jamakawkalhcha, chi lhijunkalhcha an yu ixjamalaklhchawnan laka pulach'in li oxi kajalhistaklhi. ");
INSERT INTO tpp_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","An yu ixjamalaklhchawninin akxni chunchacha lhijunikalh, jakitamaknulhcha tan wa anchacha juntachalh pulakni an laka pulach'in chi jalakch'ampa'asi'ulalhcha laka k'iw. ");
INSERT INTO tpp_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Walh ka tacha ixjaytatnant'ajuncha, akxni an Pablo chi an Silas ixtatapaynit'ajun chi ixtalakmilhpanit'ajun an Dios, an ali'in tach'inin wa sa'cha ixta'alha'asmat'a. ");
INSERT INTO tpp_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Walh wa akxni p'asi laklalh an lakaat'un, wanaj lakchikix'olhi an ixjach'aja an pulach'in. Chi wa chuncha wanaj la'tati'a'olhi an xamalhticha an pulach'in, chi wanaj la'tax'ot'olhi an cadenaj an yu ixjapulakch'i'ulakanta ta ixchuxk'an an tach'inin. ");
INSERT INTO tpp_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Wa chuncha akxni kujlhi an yu ixjamalaklhchawninin chi ixla'la'ts'incha an malhticha li ixla'ti'a'ojoy, matakutulhi an ix'espada chi ixma'niputunkancha, mu ixnajun li sna ta'os'olhcha an tach'inin. ");
INSERT INTO tpp_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero an Pablo p'asi xa'alalh, juniy: ―¡Jant'u t'ani k'a'ilht'uk'a, mu iktanuma'ojo! ");
INSERT INTO tpp_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pus wa chuncha an jamalaklhchawna sk'inlhi jatapulhkunu chi jats'alajtanulhcha pulakni, wa xk'ip'ip'icha ixlay la ixtalhanti chi jatatso'ottatawlhnilhcha la ixjach'ajak'an an Pablo chi an Silas. ");
INSERT INTO tpp_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Chi ixli'astan jamaxtulhcha chi jajuniy an Pablo chi an Silas: ―¿Tasicha aklalh para li akta'alhtaxtulh? ");
INSERT INTO tpp_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","An Pablo chi an Silas tajuniy: ―Wa k'ak'iklak'a'it'icha an Jamach'alhkat Jesús, walh k'at'a'alht'axt'uya'a chi chux yu t'a jalhila'ts'in. ");
INSERT INTO tpp_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Chi an yu ixjamalaklhchawninin talhixa'alalhcha an ixchiwinti Dios chi chux yu ixtawilanalh la ixcha'a'. ");
INSERT INTO tpp_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Wa yucha anchunu xapanch'e'ex jatats'isni, an jamalaklhchawna jala'ch'a'anilhcha tan ixtalajk'atsanini an Pablo chi an Silas. Chi ixli'astan, yucha, chi chux an yu ta ixjalhila'ts'in talaj'a'paxlicha. ");
INSERT INTO tpp_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Wa chuncha an yu ixjamalaklhchawninin, jalhi'alhcha an Pablo chi an Silas la ixcha'a chi jamawalhcha, chi chux an yu ta ixjalhila'ts'in sawalhcha ixtalaj'achan wa xliyu takiklaka'ilhcha an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tunkunchalhcha wats'isin, an jueznin tamala'achanilhi policiajnin an yu ixjamalaklhchawninin tan tajuniy li kajamakawlhcha an Pablo chi an Silas. ");
INSERT INTO tpp_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","An yu ixjamalaklhchawninin juniy an Pablo: ―An jueznin kintajuniy li ma aklamakajuwcha, pus chaway laych'a k'ap'inch'o'ot'it, jantu tu'u alin. ");
INSERT INTO tpp_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero an Pablo jajuniy an yu ixjamala'achakanta policiajnin: ―Li stakcha kintala'na'makani tan lhilhuw kintala'ts'inkanan masi jantu p'ulhnajcha la'ts'inkalhi li tu'u tala'alhini k'ilhtuyaw chi kintamalaklhchawkancha masi kitnan wachu romanojnin, ¿chaway wa la'asa'cha kintamakawcho'okanan? ¡Jantu!, wanaj yu'uncha akintamin maxtunin. ");
INSERT INTO tpp_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pus wa chuncha an policiajnin chunchacha tamak'atsaanilh an jueznin tacha an tanawlh an Pablo chi an Silas, pus ixtalaktalhanancha, mu tak'atsaalhcha li wachu romanojnin. ");
INSERT INTO tpp_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Chi ixli'astan an jueznin tala'alhcha an Pablo chi an Silas, ixtask'incha lamala'mixin, chi jamaxtukalhcha an Pablo chi an Silas, ixjatapaynisk'inikancha li ma katataxtulhcha an la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Akxni tataxtulhcha laka pulach'in an Pablo chi an Silas, ta'alhcha la ixcha'a an Lidia, chi tat'alakila'ts'ilhcha an t'ala'awnin, takit'alama'oximaj'ayalhcha, ixli'astan ta'alhcha. ");
INSERT INTO tpp_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Akxni tala'puslicha an Pablo chi an Silas la'acha'an Anfípolis chi la'acha'an Apolonia, tacha'alhcha la'acha'an Tesalónica, tan ixyalh a'atam cha'a yu ixtaputa'ayxt'o'a an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Chi an Pablo, mu chunchacha ixlismanita, pus jala'alhi an tan ixtata'ayxt'o'a, chi la'at'utu sábadojo ixjat'alakikxtukut'ajun. An Pablo an la ixchiwinti Diosi ixla'ts'ilhi'anta. ");
INSERT INTO tpp_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ixjajuniya li an Cristo ixlitask'iniya li kaxnilh chi ixli'astan kala'awcho'oya tacha tapasalhcha. Ixjajuniy: ―Ani Jesús yu klalhixa'alayaw yucha Cristo. ");
INSERT INTO tpp_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ali'in an judiojnin takiklaka'ilh, pus tach'a'o'alhcha an Pablo chi an Silas. Wachu ixluwk'ani an yu tachiwiniy lhigriego takiklaka'ilh, yu ixtatapayniniy an Dios, chi ixluwk'ancha t'akunin yu ixjalhila'sikan. ");
INSERT INTO tpp_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero tacha ani ixtapasay, an judiojnin yu jantu ixtajakiklaka'inin talhaxkayanalhcha, chi tama'ayxto'lhicha lapanakni yu wa ay ixtajunita, yu wa ixtalaktijuntsukuycha lakalaktij, para li katala'talh'amalhcha chi katajalaktilhnilhcha an la'acha'an. Atumpaj tacha'alhcha an la ixcha'a Jasón, ixtapuxkajuycha an Pablo chi an Silas, para li katamaxtulhcha chi katama'axta'nilhcha an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero mu jantu tala'cha'alhi ancha, yu'uncha an Jasón chi ali'incha t'ala'awnini jala'xa'alhi'ankalh tan ixtawilananchalh an xajamach'alhkatni an la'acha'an, ixtanajun: ―¡Ani lapanakni yu wanajcha ta ixlijalhi'ay an lakamunulhpa tajalakt'ilhi'ulanan, wachucha taminta ani, ");
INSERT INTO tpp_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","chi ani Jasón la ixcha'acha ja'ulata! ¡Ixchuxk'an ani lapanakni jantu ta'ilhtuyi tacha an najun ixlamap'a'sin an ay jamach'alhkat, yu'uncha tanajun li ma t'awpalay pumatam rey, ma Jesusi junkan! ");
INSERT INTO tpp_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Akxni chunchacha ta'asmatlhi an lapanakni chi an jamach'alhkatni jantucha k'is oxi talhiwilalh. ");
INSERT INTO tpp_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero an Jasón chi an ali'in jamakawkalh, mu tamakawlh tumin chi tanajun li jantu katita'osli. ");
INSERT INTO tpp_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Akxni puts'istacha ixjunita, an t'ala'awnin watukan tamala'achalhi an Pablo chi an Silas la'acha'an Berea. Wa tacha tacha'alh, ta'alhcha an laka cha'a tan ixtata'ayxt'o'a an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Chi ani judiojnin mu yu'uncha palay oxi ixtajalakpastaknan, jantu tacha an jamacha'an Tesalónica, pus sawalhcha oxi talhiwilalh an ixchiwinti Dios, chi lhilhiji ixtapunajun an ixchiwinti Dios, para li katak'atsaalh li sawalhi an yu ixjajunkan. ");
INSERT INTO tpp_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pus wanajcha ixluwk'ani yu yu'uncha tajakiklaka'inilh, chi wachu ixluwk'ani tajakiklaka'inilh an jamacha'an Grecia, t'akunin yu ixjalhiwilakan chi lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero akxni an judiojnin yu jamacha'an Tesalónica tak'atsaalhi li an Pablo wachu ixlichiwiniya an ixchiwinti Dios an la'acha'an Berea, ta'alhi ancha chi tsukulhcha tama'talh'amani an lapanakni chi ixtajalaktilhnincha. ");
INSERT INTO tpp_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Wa chuncha an t'ala'awnin watukan tamala'achalhi an Pablo la ixkilhtu an alamalh, pero an Silas chi an Timoteo ancha tatamakawlh Berea. ");
INSERT INTO tpp_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Yu tat'a'alh an Pablo tat'acha'alhi sta la'acha'an Atenas. Ixli'astan akxni tamincho'ochalhcha, jalhimap'a'sikanchalhcha li an Silas chi an Timoteo watukan katala'cha'ana an Pablo. ");
INSERT INTO tpp_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","An Pablo akxni ixjapakxan'iyachalhcha la'acha'an Atenas an Silas chi an Timoteo, jantu k'is oxi lhiwilalh akxni la'ts'ilh an la'acha'an li wa stakcha ixlak'alin tanlhun yu tacha ixdioschak'an ixtala'ts'in an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Xliyu ixjalhit'alakikxtukuycha an laka cha'a tan ixtata'ayxt'o'a an judiojnin chi ali'incha an yu ixtatapaynini an Dios, chi tamin wilhchan wanajcha chuni ixjat'alakixtukuy an yu ixtata'ayxt'o'a an pulakni la'acha'an. ");
INSERT INTO tpp_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Chi wachu ali'in lapanakni yu sawalh ixtajatalaninin yu ixjajunkan epicúreos chi yu ixjajunkan estoicos tsukulhcha tat'alakikxtukuyi an Pablo. Ali'in ixtanajun: ―¿Tasucha nawputun ani p'ululu kilhuyalhi? Chi ali'in ixtanajun: ―Wa li pumatam yu jalhichiwiniy yu tumpaj diosnin. Chunchacha ixtajuniy an Pablo, mu yucha ixjalhixa'alay an laj'oxi chiwinti, yu ixchiwinti an Jesús, chi ixlakata tani kalhila'awcho'okanacha. ");
INSERT INTO tpp_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wa chuncha talhi'alhcha tan ixtata'ayxt'o'a jueznin, laka Areópago junkan, chi tajuniy: ―¿Tisu la'sast'icha lhamap'a'sini yu kilalhiminitawi, layi akilajuniw? ");
INSERT INTO tpp_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Mu wa tayawi ik'asmat'aw tacha an kilalhixa'alayaw, chi ijk'atsaputunawi tuchini jumputuncha. ");
INSERT INTO tpp_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Chunchacha ixtanajun mu ixchuxk'an an jamacha'an Atenas chi an yu ancha ixtawilanalh yu jantu an jamacha'an wa yuchacha yu sawalh ixta'asmatputun yu wa sast'ika tu'u ixtapasay chi ixtalhichiwiniycha. ");
INSERT INTO tpp_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","An Pablo tayalhi la ixpujank'an yu'uncha, an laka Areópago, chi jajuniy: ―Jamacha'an Atenas, chux tacha ani klala'ts'inaw uxitnan, sawalhch'a jak'iklak'a'ininat'iti layat. ");
INSERT INTO tpp_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mu akxni ijkilaka'alh an tan t'ap'ayniniyat midiosk'an, ikla'cha'alh la'atam tan ma'axta'kan lha'ulan tan chunchuni ts'o'kanta: “Pumatam Dios yu jantu mispakan.” Pus an yu uxitnan t'ap'ayniniyat masi jant'u misp'ayat, yucha yu klamintaw lhixa'alanin. ");
INSERT INTO tpp_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Yucha Dios yu ilhtulh an lakamunulhpa chi chux an laktanlhun yu ancha lak'alin, yucha xaJamach'alhkat an lakt'iyan chi an lakaat'un. Yucha jantu ani wilh laka tajtan tan wa lapanaknicha tala'oxita. ");
INSERT INTO tpp_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Chi yucha jantu ma'lhtask'iniya li xamati tu'u ka'ilhtunilh, mu yucha yu kintaxta'ni'oyan kijatsukuntik'an, chi an un chi chux an ali laktanlhun. ");
INSERT INTO tpp_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Wa pumatam lapanaki pu'ilhtu'olh ta kilhmakchux tat'ajun an lapanakni, para li ta ixlijalhi'ay an lakaat'un, katatawlh'olh, chi jamasunitacha an panch'e'ex chi tanchuncha katatawla', ");
INSERT INTO tpp_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","para li katapuxkawlhi an Dios, masi wa kap'a'aj p'a'ajcha tajalakch'apanalh, chi katala'cha'alhcha, masi an Dios yucha jantu ma'ati t'ajun, yucha waniya t'ajun tan t'awnaw. ");
INSERT INTO tpp_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mu yucha an Diosi yu pula'awtaw chi yucha pulaklayaw chi yucha put'awnaw, tacha tanawlh wachu an ali'in minpoetajnink'an, akxni tanawlh: “Kitnan Diosi kintamala'awnitan.” ");
INSERT INTO tpp_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","’Pus, mu Diosi kintamala'awnitan, jantu layi katipastakwicha li an Dios tachanu wa la'atamcha lha'aman yu oro lhila'oxikanta u plata u chiwx, yu tacha an ta'ilhtuy lapanakni, yu wa tacha tapast'ak'acha. ");
INSERT INTO tpp_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","An Dios jantu jalhakapu'aninilhi ixtala'alhink'an an lapanakni tawananchacha, li jantu tu'u ixtak'atsay, pero chaway wa tanchuncha chi ta lhichux, najuni an Dios li kamapaxawi kijatapast'ak'atk'an. ");
INSERT INTO tpp_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Mu an Dios ulata la'atam wilhchani akxni chux an lakamunulhpa kala'ts'ina tani ixt'ajuncha atamj, oxi u jantu. Pumatam lapanak yu yucha sakxtuta chuncha kapu'ilhtuya', chi yucha kintamasunitancha ta kinchuxk'an li sawalhi li chuncha kuna', mu yucha mala'awnicho'olh. ");
INSERT INTO tpp_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Akxni chunchacha ta'asmatlhi an lapanakni ixlakata li kala'awcho'okana, wa ixtalhilakts'i'incha chi ali'in ixtanajun: ―Apu'a'tami akla'alha'asmat'aw t'ach'a ani nawt'a'un. ");
INSERT INTO tpp_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wa chuncha an Pablo jamakawlhcha. ");
INSERT INTO tpp_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero ali'in tach'a'o'alhcha chi takiklaka'ilhcha. An yu takiklaka'ilhcha, xapumatam ixjunkan Dionicio, yucha wachu ixma'ta'ayxt'o'a an laka Areópago, chi pumatam t'aku yu ixjunkan Dámaris chi ali'incha. ");
INSERT INTO tpp_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ixli'astan akxni chunchacha laktapasalh, an Pablo taxtulhcha an la'acha'an Atenas chi alhcha la'acha'an Corinto. ");
INSERT INTO tpp_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ancha la'cha'alh pumatam lapanak judio ixjunkan Aquila, jamacha'a Ponto, wa ixmintachalhka xalakaat'un Italia ali ixt'iwi junkan Priscila, wa xliyu an jamach'alhkat Claudio ixlinajunta li ixchuxk'an an judiojnin katataxtulhi an la'acha'an Roma. Pus an Pablo jala'alh. ");
INSERT INTO tpp_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Chi mu wanajcha yu tapatsati ixta'ilhtuy yu ix'ilhtuy an Pablo, pus jat'atamakawchalhcha, wa lakatamcha ixtatapatsay, yu'uncha wa ixtala'oxiy cha'a yu wa de lona. ");
INSERT INTO tpp_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Chi tamin sábado, an Pablo an laka cha'acha an tan ixtaputa'ayxt'o'acha an lapanakni, ix'an, ixjaxa'alaycha an lapanakni chi ixlipuxkawniycha tani kajalhimatanunilhcha katajakiklaka'inilh an judiojnin chi an yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Akxni taminchalhcha Macedonia an Silas chi an Timoteo, tacha'alhcha tan ixt'ajun an Pablo, wa chuncha an Pablo wa yuchacha p'as tayla'alh lhichiwiniy an ixchiwinti Dios chi ixjajuniycha an judiojnin li an Jesús yucha Cristo. ");
INSERT INTO tpp_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero yu'uncha wa tsukulhcha tat'atasp'it'a chi xkayajcha ixtajuniy, pus an Pablo k'alhalhi an ixla'ch'it tan japujuniycha li jantu oxi tacha an talay, chi jajuniy: ―Uxitnani mintala'alhink'an li ts'an'a'oyat'it, kit'in jantu kintala'alhin. Chaway kit'in ikti'ancha an tan tawilananchalh yu jantu judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pus taxtulhi an Pablo an laka cha'a an yu ixtaputa'ayxt'o'a an judiojnin, chi alhcha la ixcha'a tichi lapanak junkan Ticio Justo, yucha waniy la ixpa'xti an laka cha'a tan ixtata'ayxt'o'a an judiojnini ixwilh, chi yucha ixkiklaka'iya an Dios. ");
INSERT INTO tpp_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Chi an Crispo, yu xa'ay an laka cha'a an tan ixtata'ayxt'o'a an judiojnin, chux an yu ta jalhila'ts'in takiklaka'ilhi an Dios. Chi wachu wanaj ixluwk'an an jamacha'an Corinto akxni ta'asmatlhicha an chiwinti, takiklaka'ilh chi talaj'a'paxlicha. ");
INSERT INTO tpp_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","La'atam jatats'isni an Dios juniy an Pablo la ixjala'awanti: ―Jant'u k'at'alhan, jant'u sa' k'ak'ilhu, ali k'alhich'iwini an kinchiwinti, ");
INSERT INTO tpp_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","mu kit'in iklhistaktan, chi jantu xamati lay ta kati'ilhtun, ani la'acha'an wanaj lhuwi yu kintakiklaka'iy. ");
INSERT INTO tpp_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pus an Pablo tam k'ata apaytatcha tamakawlh an la'acha'an Corinto, ixjamasuniycha an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero akxni an Galión, gobernador ixjunita an xalakaat'un Acaya, an judiojnin tata'ayxto'lhi chi tat'alaxtukulhcha an Pablo, chi talhi'alhcha laka jamach'alhkat, ");
INSERT INTO tpp_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","tajuniy an gobernador: ―Ani lapanak wa stakcha jamatanunit'ajuni an lapanakni li ma katakiklaka'ilhi an Dios, tacha jantu chun najunta an laka lhamap'a'sini jajuniy ma kata'ilhtulh. ");
INSERT INTO tpp_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Walh akxni an Pablo ixchiwimputuncha, an Galión jajuniy an judiojnin: ―Judiojnin, li ixlakata tu'u yu ay tala'alhin u ay jama'ninti kaxwalh, kit'in xakla'asmatniw, ");
INSERT INTO tpp_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","pero mu wa ixlakatacha chiwinti chi ta'a'ut chi milhamap'a'sink'an, pus mi akstuchak'ani k'alats'awalat'it, kit'in jantu ikma'tanuputuni tan ancha. ");
INSERT INTO tpp_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wa chuncha jatamakxtulhcha an jamach'alhkat an lapanakni an tan ixtawlay. ");
INSERT INTO tpp_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ixli'astan t'o'cha tach'apachalhi an Sóstenes, yu xa'ay an laka cha'a an tan ixtata'ayxt'o'a judiojnin, chi wa ancha, la ixlakapucha an tan ixtawlay jamach'alhkat, stakcha talakasamalh. An Galión jantu tu'u ixlakapu'an tacha an ixtapasay. ");
INSERT INTO tpp_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","An Pablo la'alhuwka wilhchani ancha ixwilh an la'acha'an Corinto. Ixli'astan jamakawlhcha an t'ala'awnin chi, alicha an Priscila chi an Aquila taxa'a'ilhcha ixtijk'an para li kata'alhcha xalakaat'un Siria. Chi akxni tacha'alhcha la'acha'an Cencrea, an Pablo uksp'iruncha ta'a'sitlhi, mu chunchacha ixlitamakajunta. Tataxtupalh Cencrea tapu'alhcha laka barco para li katacha'alhcha Siria. ");
INSERT INTO tpp_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Chi akxni tacha'alhcha la'acha'an Éfeso, an Pablo jamakawlhcha an Priscila chi an Aquila, alhcha laka cha'a tan ixtata'ayxt'o'a an lapanakni, jat'achiwinilhcha an judiojnin yu ancha ixtata'ayxt'o'a. ");
INSERT INTO tpp_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Chi yu'uncha ixtatapaynini li ali kaxjat'atamakawlh, pero an Pablo jantu tamakawputulh, ");
INSERT INTO tpp_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","yucha wa jajuniy: ―Li Diosi chuncha lakask'in, aklamimpalawi lala'pixiyalhnin. Chi ixli'astan taxtulhcha la'acha'an Éfeso, pu'alhcha barco. ");
INSERT INTO tpp_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Akxni cha'alhcha la'acha'an Cesarea, alhcha la'acha'an Jerusalén, alhcha jala'axa'alana an yu ancha ixtajakiklaka'inin, chi ixli'astan alhcha la'acha'an Antioquía. ");
INSERT INTO tpp_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Alhcha wilhchan, a'tamcha ampalhi an xala'acha'anaxni an xalakaat'un Galacia, chi xalakaat'un Frigia, ixjat'alamachapuycha an yu ixtajakiklaka'inincha. ");
INSERT INTO tpp_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Anchunu panch'e'ex cha'alh pumatam judiojo an la'acha'an Éfeso, ixjunkan Apolo, yucha jamacha'a la'acha'an Alejandría, sawalh ixjalakpastaknan chi oxi ixmispay an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ani lapanak oxi ixmatalaninikanta an la ixtij Dios, chi sawalhcha tachapuni ixlichiwiniy an Jesús chi ts'ajwi ixlichiwiniy, masi wa yucha ixmispay an ixjama'paxanti Juan. ");
INSERT INTO tpp_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","An Apolo tsukulhcha chiwiniya an laka cha'a an tan ixtaputa'ayxt'o'a an lapanakni, jantucha k'is ixkiktalhanan, pero akxni ta'alha'asmatlhi an Priscila chi an Aquila, ta'aylhi'alhi tan wa ixpu'akstu chi palaycha oxi talhixa'alalh an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Akxni an Apolo k'uxa'alhcha xalakaat'un Acaya, an t'ala'awnin ta'a'tayjulh, tats'o'nilh la'atam carta li oxi katala'a'ichalh an t'ala'awnin an xalakaat'un Acaya. Akxni cha'alhcha Acaya, sawalhcha ja'a'tayjulhi an yu ixtajakiklaka'inintacha ixlakata an ixjamapayninti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Mu an Apolo alhp'asi ixjajuniy la ix'ukxlakapuk'an ixchuxk'an an judiojnin, chi sawalhi an yu ixjajuniy, pus jantu layi ixtanajun li jantu chun, chi ixnajuni an Apolo li an Jesús yucha Cristo, mu an la ixchiwinti Diosi ixla'ts'ilhi'an. ");
INSERT INTO tpp_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Akxni an Apolo la'acha'anka Corinto ixt'awnachalh, an Pablo an tan la'a'a'stitawk'ancha ixlakwilhkanchalh la'acha'anaxni la'pusli. Chi cha'alhcha la'acha'an Éfeso, ancha jala'cha'alh ali'in yu ixtajakiklaka'inin. ");
INSERT INTO tpp_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jajuniy: ―¿Uxitnan la'a'itcha an Stalan'a Takuwin akxni jak'iklak'a'inint'itcha? Yu'uncha ta'alhtaylh tajuniy: ―Jantu a'tam k'asmattawi tuchini yu Stalan'acha Takuwin. ");
INSERT INTO tpp_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","An Pablo jajumpalay: ―Pus, ¿tisu a'paxatch'a yu la'a'it'iti? Yu'uncha tajuniy: ―Yucha an ixjama'paxanti Juan. ");
INSERT INTO tpp_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","An Pablo jajuniy: ―Chun sawalh, an Juan ixjama'paxaycha yu ixtakiklaka'iycha an Dios, pero ixjajuniy li katakiklaka'ilhi an yu astan mintachalh. Yu ixjajumputun li katakiklaka'ilhi an Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Akxni chunchacha ta'alha'asmatlhi an Pablo, talaj'a'paxlicha la ixta'a'ut an Jamach'alhkat Jesús. ");
INSERT INTO tpp_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Chi akxni an Pablo jalaklakpach'apalhcha, wachucha jala'chilhi an Stalan'a Takuwin chi tamcha ixtalakchiwiniy yu tumpaj chiwinti chi ixtalhichiwiniycha an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Katacha ixpumakawt'uyk'an lapanakni ixchuxk'an. ");
INSERT INTO tpp_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","An Pablo la'at'utu malhkuyu ix'ant'ajun an laka cha'a an tan ixtaputa'ayxt'o'a an judiojnin, ixlichiwiniycha an ixchiwinti Dios, chi jantu k'is ixtalhanan, ixjalhixa'alaycha chi ixlipuxkawniycha tani kajalhimakiklaka'inilhcha an ixlich'alhkat Dios. ");
INSERT INTO tpp_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero ali'in yu sawalhcha laj'axixin, jantu tajakiklaka'inimputulh, apalijcha la ix'ukxlakapuk'an an lapanakni wa aya ixtalhichiwiniycha an ixtij Dios. Wa chuncha an Pablo jalaj'oslicha, chi jalhi'alhcha an yu ixtajakiklaka'inin lakatam laka skwela, la iskwela tichi yucha ixjunkan Tirano, anchacha lhilhij ixchiwiniy an Pablo. ");
INSERT INTO tpp_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","La'at'uy k'ata chuncha ilhtulh, pus ixchuxk'an an yu ixtawilanalh xalakaat'un Asia, yu judiojnin chi yu jantu judiojnin, ta'asmatlhi an ixchiwinti Dios. ");
INSERT INTO tpp_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Chi an Dios, laj'aycha tanlhun yu jantu wa xamaticha lapanaki pu'ilhtulh an Pablo. ");
INSERT INTO tpp_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Masi wa payojcha u wa la'ch'itcha li ixla'ala'cha'an an Pablo chi li ixjalhi'anikancha an ta'an'anin, ixtatak'uch'uycha, chi an lakmakxkay'un ixtamakajuncha an ta'an'anin. ");
INSERT INTO tpp_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pero ali'in judiojnin yu ancha ixtalak'aklat'ajun, yu ixtatamakxtuy an lakmakxkay'un la ixlakatunajk'an an lapanakni, wachu talhila'ts'intanulhi katajak'uch'unulh la ixta'a'ut an Jamach'alhkat Jesús, chi ixtajuniycha an lakmakxkay'un: ―¡La ixta'a'ut an Jesús yu lhichiwiniy an Pablo, klajunaw k'at'axt'utcha! ");
INSERT INTO tpp_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Yu chuncha ixta'ilhtuy, tichi yu'uncha ixpumatujunk'an ists'alan tichi lapanak ixjunkan Esceva, yu xa'ay ixjunita an sacerdotejnin. ");
INSERT INTO tpp_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero la'atam wilhchan an makxkay'un ja'alhtaylh, jajuniy: ―Kit'in ikmispayi an Jesús chi an Pablo, pero uxitnan, ¿tisu uxitnancha? ");
INSERT INTO tpp_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wa akxni, an lapanak an yu ixla'apaxto'ta makxkay'un jatayla'alh, chi wanaj jalhaja'olh, mu sawalhcha k'ut'ilhi ixjunita, stakcha jala'lhitama'chapulh chi wa laj'alhalhancha talakats'alalh, ixjalakmak'atsanitacha. ");
INSERT INTO tpp_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Chux an yu ixtawilanalh la'acha'an Éfeso, an judiojnin chi yu jantu judiojnin, tak'atsaalh, pus sawalhcha ixtalaktalhanan. Chi chunchacha an ixta'a'ut an Jamach'alhkat Jesús, palaycha ixpumispakan. ");
INSERT INTO tpp_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ixluwk'an wachu ixtacha'an an yu ixtajakiklaka'inintacha chi ixtanajuncha tuchini yu jantucha oxi ixta'ilhtuta ixlip'ulhnaj. Tan laj'asmatkancha ixtanajun. ");
INSERT INTO tpp_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Chi ixluwk'ani an yu ixtajachawanan talaklhicha'alhcha an ixlibrojk'an chi tala'xawalhcha, tan jala'ts'inkan. Akxni put'e'ekalhcha tani chunchacha tawlachalh xtapalh an libro an yu la'xawakalh, tawlhchalhi li tacha a'xt'up'uxamkaw (50) mil tumin de plataja ixtapalay. ");
INSERT INTO tpp_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pus chunchacha an ixchiwinti an Jamach'alhkat Dios palaycha ixta'a'pitsiy, chi ixtasuycha an ix'alhp'asninti. ");
INSERT INTO tpp_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Akxni chunchacha laktapasalh, ixli'astan, an Pablo pastaklhi li ka'alh la'pixiyalhna an xalakaat'un Macedonia chi an xalakaat'un Acaya, chi ancha ka'anchalhcha sta la'acha'an Jerusalén. Chi ixnawpalay li ka'anacha Jerusalén, ka'ampala la'acha'an Roma. ");
INSERT INTO tpp_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pus wa chuncha p'ulhnajcha jamala'achalhi xalakaat'un Macedonia an ixt'uyunk'an ix'a'tayjunin, yu'uncha an Timoteo chi an Erasto, pero yucha lananka ma'ani tamakawlh xalakaat'un Asia. ");
INSERT INTO tpp_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Anchunu panch'e'ex an la'acha'an Éfeso sawalhcha ixlilaxtukukani ixlakata an ixtij Dios, ");
INSERT INTO tpp_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","tichi yucha lapanak ixjunkan Demetriojo chuncha ix'ilhtuy, yucha ixla'tapatsay plata, chi ixlak'ilhtuycha lakt'ikt'i tajtan yu wa lha'aman de plata, yu ixlimalakxtuycha an ixtajtan diosa yu ixjunkan Artemisa, chi sawalhcha la'lhuw tumini ixtapulhajay an yu yucha ixtala'tapatsay. ");
INSERT INTO tpp_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pus an Demetrio jama'ayxto'olhi ixchuxk'an an yu yucha tapatsat ixtalak'ilhtuy chi jajuniy: ―Lapanakni, uxitnan k'ats'ayat'iti li oxi wilaw, ixlakata ani tapatsat ilhtuyaw. ");
INSERT INTO tpp_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pero chaway la'ts'inatcha ch'i asmat'atcha li an yu tajuniy li Pablo laknawt'ajuncha li yu wa la ixmakacha lapanak la'oxikanta dios, jantu dios sawalh, chi chunchacha lhuw lapanak makiklaka'inita, chi jantu wa ani la'acha'an Éfeso, wachu lanan ta ixlijalhi'ay an xalakaat'un Asia. ");
INSERT INTO tpp_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tacha ani tapasay sawalhcha lhima'anxkay, layi kats'an'alh an kintapatsatk'an, chi an ixtajtan an ay diosa Artemisa wachu jantucha katilhitapalalh, jantucha tu'u katilhiwilakalh an ixta'ayat ani diosa yu chux an xalakaat'un Asia tapayninikan chi chux lakamunulhpa'. ");
INSERT INTO tpp_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Akxni chunchacha ta'alha'asmatlhi sawalhcha tala'talh'amalh, chi p'ascha talaknawlh: ―¡An Artemisa yucha ay, ixdiosajk'an jamacha'an Éfeso! ");
INSERT INTO tpp_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Pus wa chuncha jantucha ixtak'atsay tani katalalhcha an lapanakni chux an la'acha'an. Tatayla'alhcha an Gayo chi an Aristarco, ixt'uyunk'an lapanakni jamacha'an Macedonia, yu ixtat'a'anta an Pablo, watatacha jala'xa'alhi'ankalhi sta laka cha'a tan ixtaputa'ayxt'o'a ixtapulakchiwiniy. ");
INSERT INTO tpp_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","An Pablo ixtanuputunachalh, para li kaxjat'achiwinilhi an lapanakni, pero an yu ixtajakiklaka'inincha wachu, jantu tamakawnilh. ");
INSERT INTO tpp_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","An xajamach'alhkatni Asia, an ali'in oxi ixjat'alalhi'an an Pablo, pus yu'uncha talhinawlhi li kajunkalhi an Pablo li jantu katanulh. ");
INSERT INTO tpp_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","An tan lhuw ix'ayxto'kan jantucha xamati ixlimacha'xay tuchini ixtapasaycha, wa tamj tamjcha ixtalaknajun, chi lanan ixchuxk'ani jantu ixtak'atsay tuchini ixtaalhii'ayxto'nuncha. ");
INSERT INTO tpp_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","An judiojnin tatisamaka'alhi an Alejandro la ix'ukxlakapuk'an tan an lhuw ixlakyakalh. An Alejandro jatamakyawnilhi li kasa' talajkilhulhi an lapanakni, para li laycha kachiwinilh, chi li kajalhi'a'tayjulhi an judiojnin. ");
INSERT INTO tpp_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pero akxni tak'atsaalhi li an Alejandro wachu judio, wa ayxtami talakt'asa'olh ka tacha la'at'uy hora, ixtalaknajun: ―¡An Artemisa yucha ay, ixdiosajk'an jamacha'an Éfeso! ");
INSERT INTO tpp_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wa chuncha an yu ixmats'o'lhi'anikan tanlhun an la'acha'an, akxni laycha sa' jamakilhunilh an lapanakni, jajuniy: ―Jamacha'an Éfeso, chux an lakamunulhpa k'atsakani li yucha ani la'acha'ani lhistakta an ixtajtan an ay diosa Artemisa, chi an yu patajulh an lakt'iyan yu ixt'achuncha tasuy an diosa. ");
INSERT INTO tpp_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Chi mu jantu layi xamati katinawlh li jantu sawalhi ani, wa k'asa'ch'a t'awlat'it, chi jant'u t'u'u k'a'ilht'ut li jant'u oxi p'ast'ak'at p'ulhnaj. ");
INSERT INTO tpp_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ani lapanakni yu uxitnan jalhit'ant'at'it jantu tu'u ta'alhajuy an laka tajtan chi jantu tu'u wa aya talhichiwiniy an kidiosajk'an. ");
INSERT INTO tpp_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Li an Demetrio chi an yu tat'atapatsay, li xamati jantu oxi talhiwilaniy, ta'alini jueznin chi jamach'alhkatni, anchacha kata'alh lats'awalanin tuchini talats'awalaputuncha. ");
INSERT INTO tpp_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Chi li uxitnan tu'u atumpaja lak'ask'inat, laka juntaa kalhilakchiwinkana'. ");
INSERT INTO tpp_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Yu tacha chaway ani tapasay layi akintalhi'alhtasukan li wa jalakt'ilhi'ulananawcha, chi jantu tu'u lay katinajuw tuchini ixlakatacha li tacha anicha tapasay li akintalhisakmikan. ");
INSERT INTO tpp_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Akxni chunchacha naw'olh an yu ists'o'lhi'an tu'u an la'acha'an jamala'pitsicho'olhcha an lapanakni. ");
INSERT INTO tpp_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Akxni sa'cha juncho'olh an tacha ixtala'talh'amanta an lapanakni, an Pablo jat'asanilhi an yu ixtajakiklaka'inincha chi jamap'a'silhcha. Chi ixli'astan jat'alamakawlhcha, alhcha xalakaat'un Macedonia. ");
INSERT INTO tpp_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kilajkila'olhi yu ancha ixlak'alin la'acha'anaxni, sawalhcha ixjat'alamachapuyi an t'ala'awnin la ixchiwinti, chi ixli'astan cha'alhcha xalakaat'un Grecia, ");
INSERT INTO tpp_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ancha la'at'utu malhkuyu tamakawlh. Chi akxni tukancha ixtajuputun laka barco, para li ka'alhcha xalakaat'un Siria, k'atsaalhi li an judiojnin ixtatamakajuntacha li ta kata'ilhtuya', pus wa chuncha an Pablo wa lakaat'uni pu'ancho'olh, a'tam la'puspalhi xalakaat'un Macedonia. ");
INSERT INTO tpp_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yu tat'a'alhi sta xalakaat'un Asia yu'uncha an Sópater, jamacha'a Berea, ists'alh tichi Pirro, chi tichi yucha Aristarco, chi Segundo, jamacha'a Tesalónica, chi Gayo, jamacha'a Derbe, chi Timoteo, chi yu jamacha'an xalakaat'un Asia yu'uncha an Tíquico chi Trófimo. ");
INSERT INTO tpp_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ani yu'uncha tatap'ulalhcha chi la'acha'ancha Troasi kintapakxancha'an. ");
INSERT INTO tpp_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Kitnan, akxni la'puslicha xawilhchan akxni ukan pan yu jantu tu'u lhiyalh lhamaskajan, iktaxtuwcha la'acha'an Filipos laka barco, chi la'akisicha wilhchan walh, ijkataymawcha la'acha'an Troas, ancha la'atujun wilhchani iktamakajuw. ");
INSERT INTO tpp_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Yu p'ulhnajcha xawilhchan an samana, ikta'ayxto'wicha, para li akla'ch'e'ewcha an pan, chi an Pablo ixjamasuniycha an yu ixtajakiklaka'inincha. Chi mu katunkunanta kataxtuyacha an Pablo, pus stakcha chiwinilh sta jaytatnancha. ");
INSERT INTO tpp_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Tan xak'ayxt'o'aw lakatam laka cuarto tan talhman juntachalh, wanaj la'alhuw pumaklhku ixlakpulhkuy, ");
INSERT INTO tpp_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","walh pumatam ts'alh ixjunkan Eutíco sa' ixwilh an laka ventana, chi mu an Pablo wanajcha panijniya chiwinilh, pus lhtataputulhcha an ts'alh, walh akxni oxicha ilhtatay, patajulh, ixlitala't'utucha juntachalh an cha'a' tan patajulh, chi akxni tasaklhi ixnitacha. ");
INSERT INTO tpp_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Wa chuncha an Pablo ta'alhtajulh, chi lhnujuncha ukxtawk'