﻿USE sofia;
DROP TABLE IF EXISTS sofia.tpa_vpl;
CREATE TABLE tpa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tpa_vpl WRITE;
INSERT INTO tpa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Weꞌi yana Maimaituwa Natuna Yesu Keriso* tuyeghana ahiꞌahina anivikarenana. ");
INSERT INTO tpa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Peroveta Isaiah ana au buka i amgiruma ma i riwa ipa, “Ma rautanighana, aꞌu tauvituyetuyegha apo a ai pariꞌahareiyaꞌi, po am tayaha ina ghadari. ");
INSERT INTO tpa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tauna yana pona au dobu kwakwava ei ghoreghore ipa, ‘Tayaha ona ghadari Bada aubaina, ana aninae ona raidumarui.’” ");
INSERT INTO tpa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","We au marana John i neꞌi po au dobu kwakwava rava i babataitohi, ma Maimaituwa tuyeghana i rauguguyei rava auwarihi ma ipa, “Ona amꞌohe* ma Maimaituwa ina nuwaꞌaharemi. Anima a babataitomi po ina vihegha da taumi ami dewaboꞌa auwarina o amꞌohe.” ");
INSERT INTO tpa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ma rava atapuhi au Judea ma au Jerusalem ma auririvahi taumaꞌae, hi neꞌi po John hi rautanighanei, ma ahi dewaboꞌa au habuhabuna hi viheghei, ma Jordan au wairana i babataitohi. ");
INSERT INTO tpa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma John ana gara yana me peroveta ahi gara hi oteꞌoteniya camel bo ghamoghamo opinei hi hirahiramiya i oteni, ma a dagiroro ghamoghamo opina ausiporina i raukwaviviroi, ma ana yam i aniꞌanihi yana kapau ma taꞌwaya. ");
INSERT INTO tpa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma i rauguguya rava auwarihi ipa, “Muriꞌuwei rava e neneꞌi yana i ghe vavahagha ma apoma taꞌu. Taꞌu yana egha emoꞌemosiꞌu po a kururu ma a aehuma a ohei. ");
INSERT INTO tpa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Taꞌu wairei a babataitomi* ma tauna yana Aruwa Vivireinei ina babataitomi.” ");
INSERT INTO tpa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na au marana Yesu Nazareth meyagaina Galilee autupona i hopu aharei ma i neꞌi John auwarina, John, Yesu i babataitoi Jordan au wairana. ");
INSERT INTO tpa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma maranai wairei i hurahura gheꞌetaꞌi yana mara i wanakaiweni, ma Aruwa me gabubu i ghaꞌiraꞌi po Yesu autepana i rauwei. ");
INSERT INTO tpa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma pona marei i riwa hopuꞌi ipa, “Tam yana natuꞌu aꞌu rauhoghara babana tam aꞌu anikaoha.” ");
INSERT INTO tpa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na aumurina yaghiyaghinaꞌava Maimaituwa Aruwana Yesu i himira naiyei au dobu kwakwava. ");
INSERT INTO tpa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Maratom 40 Yesu au dobu kwakwava i maꞌae ma Taumodurere* i raudadani po apoꞌapoe ita dewai. Tauna yana ghamoghamo hiyohiyohi maitehi hi maꞌae na au dobuna, ma Maimaituwa ana aneya* hi inaꞌinana vaitetei. ");
INSERT INTO tpa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Muriyai po Guyauna Herod, John Taubabataito* au deri i tereruiyei, yana Yesu i nae Galilee autupona, po Maimaituwa tuyeghana ahiꞌahina rava auwarihi i rauguguyei. ");
INSERT INTO tpa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I ririwehi ipa, “Maimaituwa a hipohipo i teretereiya i raimoinai! Maimaituwa a vitaniwaga vouna ana rava auwarihi* i vighereghere. Ami dewaboꞌei ona amꞌohe* ma tuyeghana ahiꞌahina ona vitumaghanei.” ");
INSERT INTO tpa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maratom emosi Yesu Galilee hagahagana ririvanei i nene, po tauvikaimo ruwagha i inanahi, Simon ma a tevera Andrew maiteni au hagahaga hi rauhagihagida. ");
INSERT INTO tpa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma auwarihi i riwa ipa, “Taumi ona neꞌi ma ona votaghoꞌu. Po marina me oi kaimonei, nanaꞌarena a vihanahanapumi po rava ona taravainihi po hina vitumaghaneꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mara emosi ahi hagida hi voterei ma hi vimuritaghoi. ");
INSERT INTO tpa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wate mara haburuna gerahei hi veraunae yana Zebedee natunatuna, James ma John i inanahi au wam, ahi hagida wanawana rorona hi hemohemohi. ");
INSERT INTO tpa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Me marana i inanahi yana i raughorehi ipa, “Ona votaghoꞌu.” Yamna aubaina amahi ma a taubagibagi au wam hi voterehi ma tauna hi votaghoi. ");
INSERT INTO tpa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu, a tauvotagho maitehi hi gheꞌeta dobu ana wava Caponiam auwarina, ma maranai viyagohina maratomna* i gheꞌeta yana Yesu i nae, po aniviꞌemosi numana* auhinenina vihanahanapu i taraiwawari. ");
INSERT INTO tpa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A vihanahanapu yana vibadana maiteni, ma egha me raugagayo tauvihanahanapuweina, aubaina rava hi amhuna duma a vihanahanapu auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma maranai aniviꞌemosi numana auhinenina i hanahanapu, yana rava aruwa apoꞌapoena* i taniwageiya i otu ");
INSERT INTO tpa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ma i riwa ipa, “Tam auwariꞌai aiwa u ghohei, Yesu rava Nazarethei? U ne wehidana po ma viꞌapoꞌapoeniꞌai? A hanapuwem tam aiyaꞌi! Tam yana Maimaituwa a Vinevine! Vivireina.” ");
INSERT INTO tpa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Yesu i eni ma ipa, “Ma genuwana, ma na ravana ma hopu aharei!” ");
INSERT INTO tpa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Anima aruwa apoꞌapoena* ravana i guhui yamoyamonei, ma a otuna i hopu aharei. ");
INSERT INTO tpa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma rava atapuhi ahi amhuna i raꞌata, ma hi deedei hipa, “We yana aiwaꞌi? Weꞌi yana vihanahanapu vouna vibadana maiteni. We ravana yana vibadana auwarina, emoꞌemosina po aruwa apoꞌapoehi ina riwehi ma hina viponavowei.” ");
INSERT INTO tpa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ma yaghiyaghinaꞌava Yesu tuyeghana hi nohai yabayababai, po Galilee hinenina i vihowai. ");
INSERT INTO tpa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nahidana ma aniviꞌemosi numana* hi neꞌaharei po hi nae Simon ma Andrew ahi au numa, James ma John maitehi. ");
INSERT INTO tpa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon pohiyana wavinena boyaboya i vaini po i enoꞌeno ma aubaina Yesu hi pariverei. ");
INSERT INTO tpa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Po i rui auwarina ma au nimana i vowa ma i vovai mahirini. Anima mara emosi boyaboya i hopu aharei ma i vomahiri yana ahi yam i dewai. ");
INSERT INTO tpa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma aubigai madegha i yoriyori yana rava ahi rava doridoriꞌahi, po aruwa apoꞌapoehi hi taniwagehi hi nehima Yesu auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Meyagaina ghaeghaenana ravahi hi ne po numa mataꞌetana hi vihowai. ");
INSERT INTO tpa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Yesu rava maghamaghauhi, ahi doriꞌa tapuna ma tapuna i viyawahanihi. Ma aruwa apoꞌapoehi rava auwarihi i raukaiwenihi, ma aruwa apoꞌapoehi egha ita viꞌaninehi po hita vibabani, babana hi hanapuwei da tauna ayaꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Hubahubanai boiboghi yohora i waguwaguvarei ma Yesu i eno vomahiri, po numa i hopu aharei ma i nae au dobu kwakwava raupari aubaina. ");
INSERT INTO tpa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma muriyai Simon ana rava maitehi hi veraveraubaihei. ");
INSERT INTO tpa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma maranai hi tuhaghai yana hi riwei hipa, “Rava maghamaghauhi he baibaihem!” ");
INSERT INTO tpa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Yesu i pariverehi ipa, “Tana nae we au meyagaihi aughereghereta po Maimaituwa tuyeghana auwarihi a rauguguyei. Babana yamna aubaina a neꞌi.” ");
INSERT INTO tpa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yamna aubaina Galilee i kwaviviroi ma Maimaituwa tuyeghana i rauguguyei, aniviꞌemosi au numahi ma aruwa apoꞌapoehi i raukaiwenihi rava auwarihi. ");
INSERT INTO tpa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maratom emosi rava opina waikamakamana* i neꞌi, yana Yesu aunaona i raudune ma ipa, “Inapa ma ghohei yana ma dewaꞌu po a raughadaghadariꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Anima Yesu we ravana nuwanuwana i boyai, ma i voꞌayaya po i vodadani ma i riwei ipa, “Ee, a ghohei. Po tam ma raughadaghadarim!” ");
INSERT INTO tpa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Po mara emosi ravana kamakamana i yababa ma opina i raughadaghadari. ");
INSERT INTO tpa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Anima i vighaꞌena dumei ipa, ");
INSERT INTO tpa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Marina ma nae, ma egha aiya mai heghei da taꞌu a viyawahanim. Dumaruwei ma nae gudutaupuyoweina* auwarina po ma viheghanamem, ma ina raudadanim po rava hina inanam da tam u yawahana, ma gudu* ma amverenei Moses a raugagayo* i ririweiya nanaꞌarena.” ");
INSERT INTO tpa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ma we ravana egha ita viponavowa ma i nae, yana tuyeghana i nohai po na dobuna atapunana i vihowai. Yamna aubaina po Yesu egha emoꞌemosina, habuhabunei ita nae au meyagai, ma au dobu kwakwava i maꞌae ma dobu atapuna ravahi hi nene auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Maratom egha ita magha ma Yesu a tauvotagho maitehi hi wanavirahi au Caponiam. Ma rava maghamaghauhi hi nonori da i wanavirameeiyaꞌi au meyagai, ");
INSERT INTO tpa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","po rava hi neneꞌi yana numa hinenina po mataꞌeta maiteni hi vihowai ma i rauguguya auwarihi. ");
INSERT INTO tpa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma rava wahepari turahi opina hirahiraghena hi pawe neiyaꞌi auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma rava maghamaghauhi hi rautomenihi, po egha emoꞌemosina Yesu auwarina hita gheꞌeta. Aubaina numa upunei hi amghaena autepana, ma gavogavo hi dewai Yesu autepana ma aunaona hi tere ghaꞌirei. ");
INSERT INTO tpa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Anima yamna aubaina ahi vitumaghana* i inanai ma ravana opina hirahiraghena i riwei ipa, “Natuꞌu, am dewaboꞌa a nuwaꞌaharei.” ");
INSERT INTO tpa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nahidana mai Judea* ahi raugagayo tauvihanahanapuweina hi maꞌamaꞌae, yana au nuwanuwahi hi ampiri we nanaꞌarena hipa, ");
INSERT INTO tpa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Aiwa aubaina we ravana nanaꞌarena ei babani? Ei jibogha! Maimaituwa tauꞌavana dewaboꞌa taunuwaꞌahareina!” ");
INSERT INTO tpa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mara emosi Yesu aruwanei me hi vinuwanuwatuhunei i hanapuwei po i riwehi ipa, “Aiwa aubaina po we nanaꞌarena oi nuwanuwatuhu? ");
INSERT INTO tpa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Metauna i teꞌateꞌa? Ravana opina hirahiraghena ata riwei da, ‘Am dewaboꞌa a nuwaꞌaharei,’ bo ata ripa, ‘Ma vomahiri po am aniꞌeno maꞌavarai ma ma nae’? ");
INSERT INTO tpa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A viheghemi po ona inanai, da taꞌu yana Rava Natuna taniwaga auwariꞌu e maꞌamaꞌae, po dewaboꞌa a nuwaꞌaharei.” Anima ravana opina hirahiraghena i riwei ipa, ");
INSERT INTO tpa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tam ma vomahiri po am aniꞌeno maꞌavarai, ma ma nae am au numa!” ");
INSERT INTO tpa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Anima atapuhi hi iyaꞌiyauwei, ma mara emosi i vomahiri po a aniꞌeno i rauꞌavarai ma i neꞌaharehi. Atapuhi ahi amhuna i kwaha ma Maimaituwa hi vohepahepai, ma hipa, “Egha meyanai ginauri we nanaꞌarena ata inaꞌinanaiya i tupuwa!” ");
INSERT INTO tpa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu, Caponiam meyagaina i vomahiri ahare po i naeme Galilee au gerahana. Ma rava maghamaghauhi hi neꞌi auwarina ma i vikare po i hanahanapuhi. ");
INSERT INTO tpa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Maranai i naenae yana rava wavana Levi, Alphaeus natuna i inanai a au anibagibagi takisi i tamatama. Yesu i riwei ipa, “Ma votaghoꞌu.” Egha baine i vomahiri po i votaghoi. ");
INSERT INTO tpa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Maranai Yesu, Levi ana au numa i amꞌam, ma takisi tautama maghamaghauhi ma taudewaboꞌa hi muritaghoi, ma wate Yesu a tauvotagho maitehi hi am gogona. ");
INSERT INTO tpa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ma Pharisee* ghehauhi yana raugagayo tauvihanahanapuweina, hi inanai ma i amꞌam takisi tautama po taudewaboꞌa maitehi, ma a tauvotagho auwarihi hi raubayada hipa, “Aiwa aubaina takisi tautama ma taudewaboꞌa maitehi e amꞌam?” ");
INSERT INTO tpa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Anima Yesu we i nonori yana i riwehi ipa, “Rava ahiꞌahihi yana egha tauviyawahana hita ghoheghohei, ma rava doridoriꞌahi yana tauviyawahana hi ghoheghohei. Taꞌu egha rava dumadumaruhi ghorenahi aubaina ata neꞌi ma taꞌu yana taudewaboꞌa aubaihi a neꞌi.” ");
INSERT INTO tpa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maratom emosi yana John Taubabataito* a tauvimuritagho ma Pharisees* hi hujihuji. Ma rava ghehauhi hi ne po Yesu hi raubayadei hipa, “John a tauvimuritagho ma Pharisees ahi tauvimuritagho he hujihuji. Ma aiwa aubaina po tam am tauvotagho egha hita hujihuji?” ");
INSERT INTO tpa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Yesu i riwehi ipa, “Maranai rava tautavinevou awana maiteni he maꞌamaꞌae, yana ana rava egha hita hujihuji babana tauna maitehi he maꞌamaꞌae. ");
INSERT INTO tpa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ma mara e neneꞌi yana tautavinevou orotona apo auwarihi ma hina vaina aharei, Yesu hina vihiragheni ma na au marana apoma hina huji.” ");
INSERT INTO tpa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Wate i riwehi ipa, “Egha meyanai gara vouna hina vaini po gara ꞌwadubona wanawana hogirana auwarina hina popoi, babana apo ina roroi raꞌaraꞌahi. ");
INSERT INTO tpa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nanaꞌarena wate apo egha meyanai wine* vouna hina vaini po huma ꞌwadubona, auwarina hina terei babana, i ꞌwadubo apo egha ina amriyana. Babana wine vouna viboyana apo ina dewai po ina wanaroroi, yamna anona yana ruwaghahina wine ma anihumana apo hina apoꞌapoe, egha po wine vouna yana huma vouna auwarina hina terei babana ina amriyana yana apegha ina wanaroroi.” ");
INSERT INTO tpa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Viyagohina au maratomna Yesu a tauvotagho maitehi payawa vaovaona hineninei hi neneꞌi, ma payawa anona hi tamihi po hi amꞌam. ");
INSERT INTO tpa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Pharisees* hi inanahi yana hi riwehi hipa, “Ma inanai! Ata raugagayo* yana havena po viyagohina au maratomna* we nanaꞌarena hita dewai!” ");
INSERT INTO tpa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ma i paribeehi ipa, “O hiyavi bo eꞌegha? Da David ana rava maitehi am hi voiyehi ma egha ahi yam, ");
INSERT INTO tpa_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ma David, Maimaituwa a au Numa i rui, Abiathar na haugana, yana tauna Gudutaupuyoweina Gheghetehaharana, ma na payawana Maimaituwa auwarina hi amverenei, yana wairaugagayona po gudutaupuyoweina* ꞌava ahi yam, ma David ana rava maitehi i verehi po hi ani.” ");
INSERT INTO tpa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Autepana i riwehi ipa, “Aniviyagohina maratomna yana Maimaituwa i terei po rava ina haguhi, ma egha itapa rava viyagohina maratomna hina hagui. ");
INSERT INTO tpa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Taꞌu Rava Natuna vibadana auwariꞌu po ana riwa auwarihi da viyagohina maratomna ai badei.” ");
INSERT INTO tpa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mara emosi Yesu i wanavirameei po i rui aniviꞌemosi numana* auhinenina, ma nahidana rava nimana wanawana ruꞌumana i inanai i tughutughura. ");
INSERT INTO tpa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma rava ghehauhi hi ghohei da Yesu hina viwavui, yamna aubaina hi inaꞌinana vaimaiha, mepa da viyagohina au maratomna we ravana ina viyawahani. ");
INSERT INTO tpa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma ravana nimana wanawana ruꞌumana i riwei ipa, “Ma neꞌi po rava aunaohi ma mahiri.” ");
INSERT INTO tpa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Anima rava i raubayadehi ipa, “Metauna raugagayona* i ahi, viyagohina au maratomna: ahi ta dewai bo apoꞌapoe ta dewai, ta viyawahana bo ta vihiraghena?” Egha hita paribeei ma atapuhi hi genuwana. ");
INSERT INTO tpa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Anima amona i ghaighai ma i inana viravira babana nuwanuwahi i toghara, ma i vinuwaboya ma i riwa nae ravana nimana wanawana ruꞌumana auwarina ipa, “Nimam ma rodomi.” Ma nimana i rodomi yana i yawahana. ");
INSERT INTO tpa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Anima Pharisees* yaghiyaghinaꞌava hi nae, po guyau Herod ana boru marina maitehi hi viꞌemosi po Yesu vihiraghenana hi viꞌogatarei. ");
INSERT INTO tpa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yesu ma a tauvotagho maitehi hi nae hagahaga au gerahana, ma rava maghamaghauhi Yesu aiwa i dewadewaiya tuyeghana hi nonori po hi neꞌi auwarina. Ahi anineꞌi yana Galilee, Judea, Jerusalem, Idumea ma Jordan tupohi, anima Tyre ma Sidon meyagaihi auririvahi. ");
INSERT INTO tpa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Rava maghamaghauhi i viyawahanihi ma ghehauhi doridoriꞌahi yana yohora hi amdudugheꞌi hipa hita vodadani. Aubaina po a tauvotagho i riwehi po aubaina wam hi nonoghei, babana rava hi magha duma hi garigaribewani. ");
INSERT INTO tpa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mepa nanaꞌarena rava aruwa apoꞌapoehi hi tanitaniwagehi Yesu hi inanai, yana aunaona hi peꞌu ma hi ghoreghore hipa, “Tam yana Maimaituwa Natuna!” ");
INSERT INTO tpa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ma aruwahi i vighaꞌehi da havena rava hita riwehi da tauna aiyaꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu i ghae oya autepana ma rava i rauhogharehi, i ghorehi po hi neꞌi auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ma maghauhi 12 i vinehi ma wava i verehi, tauvotagho vinevinehi.* Ma weꞌi aubaina i vinehi da tauna maitehi ma muriyai ita himira hopunehi rauguguya aubaina, ");
INSERT INTO tpa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ma vitaniwaga i verehi po aruwa apoꞌapoehi hina raukaiwenihi. ");
INSERT INTO tpa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tauhi 12 ahi wava yana we nanaꞌarena: Simon (yana Yesu i viwavai po Peter), ");
INSERT INTO tpa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee natunatuna James ma a tevera John i ghorehi po Boanerges (Boanerges anona yana ‘waiparara natunatuna’), ");
INSERT INTO tpa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, ma Thomas, James yana Alphaeus natuna, ma Thaddaeus, ma Simon yana Zealot ");
INSERT INTO tpa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ma Judas Iscariot yana Yesu tauvibenabenameina. ");
INSERT INTO tpa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu, a tauvotagho maitehi hi naeme au numa, ma wate rava hi riyaneꞌi yana numa hi vihowai po egha emoꞌemosina hita am. ");
INSERT INTO tpa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A ghughuni hi nonori aiwa i tuputupuwa ma hipa, “Unuꞌununa i neyabayababa!” Aubaina hi neꞌi po hita taravaini po hita paꞌini. ");
INSERT INTO tpa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mai Judea* ahi raugagayo tauvihanahanapuweina Jerusalemei hi ghaꞌiraꞌi po Yesu hi deedei hipa, “Beelzebub yana aruwa apoꞌapoehi ahi bada, Yesu ei taniwagei! Aruwa apoꞌapoehi ahi bada a kajijirei we aruwahi e raukaiwenihi.” ");
INSERT INTO tpa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Aubaina Yesu i ghorehi po hi neꞌi ma ampariruveruvei i vibabani auwarihi ipa, “Apo menanaꞌarena ma Taumodurere* ina vireta hopunenameei? ");
INSERT INTO tpa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Inapa dobu ina viꞌam kahakaha ma hinai tona vivira, yana na dobuna apo egha ina mahiri. ");
INSERT INTO tpa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma dam ina viꞌamkahakaha ma hinai tona vivira, yana apo na damna egha ina maꞌae. ");
INSERT INTO tpa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Yamna aubaina inapa Taumodurere ana dobu hinai amkahakaha ma hinai tona vivira, yana apegha hina mahiri apo hina peꞌu babana ahi mara i kwaha. ");
INSERT INTO tpa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Apegha meyanai rava kajikajijirana ana numa hina ruini po a purapura hina danenenei. Da aunaona hina raghiraghihi ma muriyai a purapura hina danenenei. ");
INSERT INTO tpa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Taꞌu riwa moinana a ririwemi, rava ahi dewa ma ahi babani, apoꞌapoehi atapuna apo Maimaituwa ina nuwaꞌaharei.* ");
INSERT INTO tpa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ma aiya ravana Aruwa Vivireina ei jiboghi yana Maimaituwa apegha ina nuwaꞌaharei, babana naꞌi yana dewaboꞌa maꞌemaꞌe vavahaghana i dewai.” ");
INSERT INTO tpa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesu i riwehi babana tauna Aruwa Vivireinei aruwa apoꞌapoehi i raukaiwenihi ma hi riwei hipa, “Aruwa apoꞌapoena* tauna ita ruini.” ");
INSERT INTO tpa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Anima Yesu ayona ma varevarehina hi gheꞌeta po numa au mataꞌetana, hi mahimahiri ma ana riwa hi himiri. ");
INSERT INTO tpa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rava maghamaghauhi hi tughura kwaviviroi ma hi maꞌamaꞌae ma hi riwei hipa, “Ayom, varevarehim ma novunovum yana au dowa hi ghoheghohei po hina inanam.” ");
INSERT INTO tpa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu i paribeehi ipa, “Aiya ayoꞌuna ma varehiꞌuna?” ");
INSERT INTO tpa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Anima i inana viravira po rava auririvana hi tughutughura i inanahi ma ipa, “Ona inanai! We ravahi yana ayoꞌu ma varevarehiꞌu! ");
INSERT INTO tpa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aiya ravana Maimaituwa a rauhoghara e dewadewai yana tauna varehiꞌu, novuꞌu ma ayoꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu vihanahanapu i vikarenameei, Galilee hagahagana auririvana. Ma rava maghamaghauhi hi garibewani, aubaina po au wam i geru ma i verauhopu au bogei. Ma rava atapuhi yana au geraha. ");
INSERT INTO tpa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ampariruveruvei i babani, ma ginauri maghamaghauna i vihanahanapuhi ipa, ");
INSERT INTO tpa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“We ona nonori, tauraupehi i hopu vao aubaina, ");
INSERT INTO tpa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","po ana pehi i vihuruhi, ma ghehauhi yana tayaha auririvana hi peꞌu, po kiu hi anihi. ");
INSERT INTO tpa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma ghehauhi yana dowa waighaꞌighaꞌimana auwarina hi peꞌu nahidana yana egha dowa ghaeghaena, po pehina egha davona ma hi raupiharehi, ");
INSERT INTO tpa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ma egha dedehi hita ghaꞌira dowa auhinenina, po maranai madegha i gheꞌeta yana i boyahi po hi poꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ghehauhi yana raꞌwau au toyana hi peꞌu po hi raupiharehi, ma yamhi yana yavana i viꞌapoꞌapoenihi, po egha hita rauꞌano. ");
INSERT INTO tpa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma ghehauhi yana dowa ahiꞌahina auwarina hi peꞌu, po hi ghe vaimaiha, ma ghehauhi anohi 30, ma ghehauhi 60, ma ghehauhi 100.” ");
INSERT INTO tpa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma i riwehi ipa, “Inapa waitanighami yana aiwa a ririweiya ona nonori.” ");
INSERT INTO tpa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mara ghehauna, Yesu a tauvotagho ma rava ghehauhi, ampariruvaruva* aubaina hi raubayadei. ");
INSERT INTO tpa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma i amparibeeyana ipa, “Taumi ravamina a viꞌaninemi po Maimaituwa a vitaniwaga vouna, tuyeghana govagovaghana ai heghemi. Ma tauhi taumae uputa auwarihi yana apegha ina raughadari, ma ampariruveruvei auwarihi a vibabani. ");
INSERT INTO tpa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","A dewai po peroveta wadubona, aiwa i ririweiya ina raimoinai, ‘He inaꞌinana ma egha hita inaꞌinana tuhagha, ma he rautanighana ma nuwanuwahi egha ita wanawanaghadari, yamna aubaina apegha hina wanatavirahi ma ahi dewaboꞌa ata nuwaꞌaharei.’” ");
INSERT INTO tpa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu i raubayadehi ipa, “We ampariruvaruvana* auwarimi i raughadaghadari bo eꞌegha? Ma apo menanaꞌarena ampariruvaruva* ghehauhi auwarimi ina raughadari? ");
INSERT INTO tpa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tauraupehi yana me Maimaituwa riwana rava auwarihi e rairahahi. ");
INSERT INTO tpa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Rava ghehauhi auwarihi yana me pehi tayaha auririvana e peꞌupeꞌu, ma me marana tuyegha hi nonori, yana mara emosi Taumodurere* i vaina aharei. ");
INSERT INTO tpa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma rava ghehauhi yana me dowa waighaꞌighaꞌimana, a kaohahi tuyegha hi nonori, ");
INSERT INTO tpa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ma egha hita vomomota, babana dedehi egha ita amtonana dowa auhinenina. Po maranai tuyegha ahiꞌahina hi vaini, ma piripiri ma amparihopuhopu hei aronihi, yana egha davona ma he vootere. ");
INSERT INTO tpa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma rava ghehauhi yana me au raꞌwau. We ravahi yana tuyegha hi nonori, ");
INSERT INTO tpa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ma we dobuna a yawahana hi vinuwaboyana dumei, ma a viguyau ma ginauri maghamagha rauhogharahi, tuyeghana ahiꞌahinana hi yavanihi po egha anohi. ");
INSERT INTO tpa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma dowa ahiꞌahina yana me rava tuyegha hi nonori, po hi vomomohi ma hi rauꞌano, po ghehauhi yana 30, ma ghehauhi yana 60, ma ghehauhi yana 100.” ");
INSERT INTO tpa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu auwarihi ipa, “Rava egha meyanai rampa gaebei hina vitaradaꞌwai bo aniꞌeno augabaꞌurina hina terei. Eghapo, ana au animaꞌae hina terei. ");
INSERT INTO tpa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Purapura govagovaghahi apo hina vogheꞌetehi, ma humahumahi apo hina kaiwenihi. ");
INSERT INTO tpa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Inapa waitanighami yana ona rautanighana.” ");
INSERT INTO tpa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma i riwehi ipa, “Aiwa o nonoriya yana ona viꞌateꞌatei. Ma ona rautanighana vaimaiha ma auwarimi ina raughadari, ma nuwahuyahuya yagana ina veremi. ");
INSERT INTO tpa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aiyavo auwarihi, yana apo ina raipotoi ma aiyavo auwarihi eꞌegha, ma haburuna auwarihi e maꞌamaꞌae yana apo ina voꞌaharei.” ");
INSERT INTO tpa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ipa, “Maimaituwa a vitaniwaga vouna ana rava auwarihi,* yana me rava pehi au dowa e rairahahi. ");
INSERT INTO tpa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Marana waguvarai po maratomai, ana eno po a vomahiri auwarina, we pehina i rahai po i ghaeghae, yana egha ita haramanei da me i wawaranei. ");
INSERT INTO tpa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Dowa tauꞌavana i dewai po i rahai ma i ghae, po i raꞌata ma i rauꞌano. ");
INSERT INTO tpa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma maranai yam i magura, yana tauraupehi rauyam ei kareni.” ");
INSERT INTO tpa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Anima ipa, “Apo aiwa ampariruvaruvana* ta vibagibagi po Maimaituwa a vitaniwaga vouna ana rava auwarihi* ta dedei? ");
INSERT INTO tpa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Maimaituwa a vitaniwaga vouna ana rava auwarihi yana me gaga porana vomuhomuhona. ");
INSERT INTO tpa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma maranai i raꞌata yana eyagi maghamaghauhi au vaovao i ghe aharehi, ma ragharaghana hi raꞌata po auwarihi kiu he raunoghi.” ");
INSERT INTO tpa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu ani ampariruvaruva* maghamaghauhi we nanaꞌarena, i vibabaniyei rava auwarihi, ma i naiyei po au ruvahi ma hi noonora tuhaghai. ");
INSERT INTO tpa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mara maghamaghauna ampariruvaruva* auwarina i babani, ma maranai a tauvotagho tauhiꞌava auwarihi yana, aiwa atapuna au habuhabuna i vogheꞌetei. ");
INSERT INTO tpa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na maratomna emosina aubigaina, yana Yesu a tauvotagho i riwehi ipa, “Ta amkuka damana hagahaga autupo ghehauna.” ");
INSERT INTO tpa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tauna yana au wam, aubaina a tauvotagho hi geru, ma patara ghaeghaena au geraha hi voterehi, ma hi vomahiri po hi damana autupo gheha wam ghehauhi maitehi. ");
INSERT INTO tpa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma hive ghaeghaena i vikare, po togowa wam hadana i raviravi, ma waira i rautaghona auhinenina. ");
INSERT INTO tpa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Yesu yana wam aumurina i viꞌunutana ma i enoꞌeno. Ma a tauvotagho hi raidagui ma hipa, “Tauvihanahanapu egha uta weno, we apo ta hiraghe weꞌi?” ");
INSERT INTO tpa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I vomahiri yana hive i eni ma i riwei ipa, “Ma genuwana!” Ma togowa auwarina i riwei ipa, “Rauwa ma voterei!” Anima hive rauwa i voterei ma daumora ghaeghaena i eno. ");
INSERT INTO tpa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma i riwehi ipa, “Aiwa o rovorovoei? Egha ami vitumaghana?” ");
INSERT INTO tpa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hi rovo duma ma hi raubayadanameehi hipa, “We ravana aiyaꞌi? Ma i manini ohoota da hive ma togowa hi viponavowei!” ");
INSERT INTO tpa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu a tauvotagho maitehi hi amkuka damana, Galilee hagahagana autupo ghehauna, mai Gerasa ahi au meyagai. ");
INSERT INTO tpa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Me marana Yesu wamei i hauhopu, yana rava kokowagei i verautomeni, we ravana yana aruwa apoꞌapoena* i taniwagei. ");
INSERT INTO tpa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","5","We ravana yana kokowaga* gubahi auhinenina i maꞌamaꞌae, ma egha emoꞌemosina po aiya seiniyei ina raghiraghihi. Mara i magha duma aena po nimana seiniyei hi panihi, ma i rautuinihi ma i raumutuhi, egha aiya a kajijira emoꞌemosina po ita vomomohi. Maratomai po waguvarai i ghae ma i hopu, au tetete po au kokowaga, ma i otuꞌotu nae. Ma ghaꞌimei i hapihapimei. ");
INSERT INTO tpa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Maranai Yesu auheiya i inanai, yana i ruba po au aena i raupari. ");
INSERT INTO tpa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ma ponana ghaeghaena ma i otu ipa, “Yesu Maimaituwa Gheghetehaharana Natuna, aiwa auwariꞌu ma dewai? Maimaituwa wavanei ai bagham po egha ma kovokovoghiꞌu!” ");
INSERT INTO tpa_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","We nanaꞌarena i vibagha babana Yesu i riwei ipa, “Aruwa apoꞌapoena, we ravana ma hopu aharei!” ");
INSERT INTO tpa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Anima Yesu i raubayadei ipa, “Wavam aiyaꞌi?” “Wavaꞌu yana Boru, Taumodurere* a tauvighaviya maghamaghauꞌai babana a magha duma.” ");
INSERT INTO tpa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma Yesu i haighirighiriyei da havena, ita himirihi po we dobuna hita hopu aharei. ");
INSERT INTO tpa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nahidana yana poro maghamaghauhi, tetete auririvana hi yabayaba nae. ");
INSERT INTO tpa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma aruwa apoꞌapoehi Yesu hi vibaghai hipa, “Ma pariꞌahareiꞌai poro auwarihi ma ma viꞌanineꞌai po a ruinihi.” ");
INSERT INTO tpa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma Yesu i viꞌanina po aruwa apoꞌapoehi hi hopuhopuꞌi yana poro hi ruinihi. Ma maghamaghauhina hi ghohorihi yana gubara hi ghaꞌirini po au boga hi yori, ma hi magha duma 2,000 nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ravahi poro taupaꞌinihi hi nae po meyagai ghaeghaehi auwarihi rava hi riwehi, po rava maghamaghauhi hi riyaneꞌi po aiwa i tuputupuwa hi inanai. ");
INSERT INTO tpa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Maranai hi ne po hita inana yana we ravana aruwa apoꞌapoehi hi taniwageiya, yana i vigara ma unuꞌununa i dumaru ma i tughutughura, ma tauhi yana hi rovo. ");
INSERT INTO tpa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tauhi aiyavo aiwa hi inanai ma i tuputupuwa yana rava hi riwehi. ");
INSERT INTO tpa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Anima ravahi, Yesu hi vibagha dumai da ahi dobu ina hopu aharei. ");
INSERT INTO tpa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Me haugana Yesu ipa, au wam ina geru yana ravana, aruwa apoꞌapoehi hi taniwageiya i vibaghai po maiteni hita nae. ");
INSERT INTO tpa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ma egha ita viꞌaninei, ma i riwei ipa, “Ma naeme po am au meyagai po am ghughuni auwarihi, Bada auwarim ginauri ani amhuna ghaeghaehi, ma a rauꞌiviꞌahiꞌahi auwarim i dewadewaiya ma vituyetuyeghei.” ");
INSERT INTO tpa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Yamna aubaina po ravana i naeme au Decapolis, ma Yesu aiwa auwarina i dewadewaiya i vituyetuyeghei. Ma taurautanighana atapuhi yana hi amhuna duma. ");
INSERT INTO tpa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu wamei i damaname hagahaga autupo ghehauna. Maranai yohora tauna hagahaga auririvana, yana rava maghamaghauhi hi ne po hi gari kwaviviroi. ");
INSERT INTO tpa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma aniviꞌemosi numana* taupaꞌinina ana wava Jairus, maranai Yesu i inanai yana i ne po au aena i peꞌu ma i vibaghai. ");
INSERT INTO tpa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ma ipa, “Natuꞌu guguhinina haburunaꞌava ina hiraghe.” Ma i haighirighiriyei ipa, “Tana nae po ma votepani ma ina yawahana.” ");
INSERT INTO tpa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Egha baine Yesu maiteni hi nae, ma rava maghamaghauhi hi muritaghoi ma hi amdududu. ");
INSERT INTO tpa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma nahidana wavine ghehauna, a borima 12 tara i maemae aharei. ");
INSERT INTO tpa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma ana mane atapuhi tauviyawahana auwarihi, i vihuru gaewei ma egha hagu ita nehaghai, ma apoma a doriꞌana i raꞌaraꞌata duma. ");
INSERT INTO tpa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Maranai wavinena Yesu tuyeghana i nonori yana a nuwatuhu ipa, “Inapa ana gara ipirinaꞌava a vodadani yana apo a yawahana.” Yamna aubaina murinei i nae, po rava maghamaghauhi aupouhi i vohonagha yana ana gara i vodadani. ");
INSERT INTO tpa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Anima egha davona ma tara ruba i voterei ma mayana i vaini yana i yawahana. ");
INSERT INTO tpa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma Yesu mara emosi, i haramanei da boyaboya i hopu aharei, po aubaina rava maghamaghauhi auwarihi i wanatavirai ma i raubayada ipa, “Aiya aꞌu gara i vodadani?” ");
INSERT INTO tpa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma a tauvotagho hi riwei hipa, “U inanai po rava hi gari kwavivirom ma hei amdududu, ma e raubayada upa, ‘Aiya i vodadaniꞌu?’” ");
INSERT INTO tpa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ma Yesu yana yohora i inaꞌinana baibaiha po tauvodadanina ita inanai. ");
INSERT INTO tpa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma wavinena mayana i vaini da auwarina aiwa i tupuwa, yamna aubaina a rovona ma a tatavana i neꞌi po au aena i peꞌu, ma riwa moinana i vogheꞌetei. ");
INSERT INTO tpa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Yesu i riwei ipa, “Natuꞌu, am vitumaghana* i viyawahanim, a nuwahubam ma nae, ma am piripiri atapuna i kwaha.” ");
INSERT INTO tpa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma Yesu yohora i babani, ma tauvituyetuyegha Jairus a numei hi ne po hipa, “Natum ana mara i kwaha, ma tauvihanahanapu egha ma raiweno highirighiriyei.” ");
INSERT INTO tpa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu i nonorihi ma egha ita weno ma Jairus i riwei ipa, “Egha ma rovo ma ma vitumaghana.” ");
INSERT INTO tpa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Anima Yesu, Peter ma James varehina John maitehi i taravainihi, ma rava ghehauhi i vighaꞌehi po egha maitehi hita nae. ");
INSERT INTO tpa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus ana au numa hi raugheꞌeta, yana Yesu rava i inanahi hi toutou ma hi rauhiyava ma ponahi dobu i howai. ");
INSERT INTO tpa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma i rui numa auhinenina ma i riwehi ipa, “We aiwa o toutouwei? We teverana yana egha ita hiraghe ma e enoꞌeno ohota.” ");
INSERT INTO tpa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Hi parihibehibei ma hi vinamei. Aubaina po i himira hopunehi, ma teverana amana ma ayona ma a tauvotagho tonugha, maitehi hi rui mepa teverana i enoꞌenoyana. ");
INSERT INTO tpa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Anima au nimana i vowa ma ipa, “Talitha koum.” (Anona yana “Tevera, a ririwem we marina ma vomahiri.”) ");
INSERT INTO tpa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma mara emosi i vomahiri po i nae. Teverana a borima yana 12. Maranai we i tupuwa yana ahi amhuna i kwaha. ");
INSERT INTO tpa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu raugagayo* kajikajijirana i terei ipa, “Egha rava ghehauhi ona ririwehi, ma yam ona verei po ina am.” ");
INSERT INTO tpa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ma a tauvotagho we dobuna Caponiam hi voterei, ma hi naeme a au meyagai au Nazareth mepa i raꞌaraꞌatayana. ");
INSERT INTO tpa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Viyagohina au maratomna yana aniviꞌemosi au numana i vikare po i hanahanapu, ma rava maghamaghauhi hi rautanighana ma hi amhuna. Ma hi raubayadanameehi hipa, “Mepa we dewahi i vainihi?” ma “We nuwahuyahuyana aiya i verei?” ma “Menanaꞌarena po we dewahi anivinuwanaina e vogheꞌetehi?” ");
INSERT INTO tpa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wate hipa, “We tauna yana tauraunuma ohota, Mary natuna ma James, Joseph, Judas ma Simon tuwahi magurina. Ma novunovuna we hei maꞌeyana.” Yamna aubaina po hi geduꞌaiyei. ");
INSERT INTO tpa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Yesu auwarihi ipa, “Peroveta au dobu gheha hi viꞌateꞌatehi ma a au meyagai, a ghughuni ma ana dam yana eꞌegha.” ");
INSERT INTO tpa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yamna aubaina dewa anivinuwanaina egha ita vogheꞌetei, ma rava doridoriꞌahi vohiyavahiꞌava i vodadanihi ma hi yawahana. ");
INSERT INTO tpa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma egha hitai tumaghana aubaina i amhuna. Ma meyagai ghehauhiyei i nae ma i hanahanapu nae. ");
INSERT INTO tpa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu, a tauvotagho 12 ruwaruwagheiꞌava i himirihi, po meyagai tapuna ma tapuna auwarihi. Ma manini i verehi po aruwa apoꞌapoehi hina raukaiwenihi. ");
INSERT INTO tpa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma babani ghaeghaena i terei auwarihi ipa, “Egha purapura aiwa ami kadau auwarina ona vowai, aita ami jighonaꞌava, egha yam bo autu ma egha mane autuna. ");
INSERT INTO tpa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Aehuma ona oteni ma egha kwama viruwaina ona vaivaini.” ");
INSERT INTO tpa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma i riwehi ipa, “Me au numana ona rui, yana nahidana ona maꞌae da na meyagaina ona hopu aharei. ");
INSERT INTO tpa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma inapa metauna au meyagaina rava egha hina vokaokaohemi bo hina rautanighanemi, yana ona neneꞌaharei ma aeyapayapami vunavunana ona raihoruhorui. Po naꞌi yana virovorovo matakirahana.” ");
INSERT INTO tpa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Anima hi hopu po hi rauguguyanai rava auwarihi ma hipa, “Ami dewaboꞌa ona voterehi ma ona wanatavirami Maimaituwa auwarina.” ");
INSERT INTO tpa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma aruwa apoꞌapoehi maghamaghauhi hi raukaiwenihi, ma rava maghamaghauhi olive oyohinei hi viꞌoyohihi ma hi viyawahanihi. ");
INSERT INTO tpa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Dobu maghamaghauhi ma rava atapuhi, yana Yesu wavana hi hanapuwei ma hi babaniyei. Ma rava ghehauhi hipa, “John Taubabataito* i hiraghe ma i yawahaname, yamna aubaina we dewahi anivinuwanaina e vogheꞌetehi.” ");
INSERT INTO tpa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ghehauhi hipa, “Weꞌi yana Elijah.” Ghehauhi hipa, “Weꞌi yana peroveta ghehauna me warihagha.” ");
INSERT INTO tpa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wate maranai guyauna Herod we tuyeghana i nonori yana ipa, “Weꞌi yana John Taubabataito,* a riwa po uwana hi tarautuini ma i yawahaname.” ");
INSERT INTO tpa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","John Taubabataito* uwana borina dededena yana we nanaꞌarena. Muriyai po Yesu a bagibagi ita vikareni, Herodias yana Philip awana, ma Herod yana varehina Philip ma i vomahiri po i haroi. Aubaina John Taubabataito i ririwei ipa, “I viraugagayo duma, havena po varehim awana uta ravaghi.” Ma Herod tauꞌavana i viꞌautana po hi pani ma au deri hi gudutomeni. ");
INSERT INTO tpa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ma Herodias yana John rauꞌamo ghaighaiyana dumei, aubaina i ghohei po ita vihiragheni. Ma egha emoꞌemosina ");
INSERT INTO tpa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","babana Herod i haramanei, po John yana rava vivireina ma i dumaru Maimaituwa au matana, aubaina po i rovowei ma i tere vaimahiꞌeni. Ma i ghohei po ponana ina nonori ma wate kamnana i raiꞌapoꞌapoeni. ");
INSERT INTO tpa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ma Herodias a gavogavo i viꞌaroni, Herod a haugaghuni kaohana auwarina. Toreha i dewai yana dobu babadahi, ghaviya tanitaniwagahi ma rava ghaeghaehi mai Galilee i ghorehi po hi riyaneꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Maranai Herodias natuna guguhinina i rui po i harahara, yana Herod ma a taꞌomana i rauvainihi. Aubaina guyauna, guguhinina i riwei ipa, “Aiwa u ghohei? Am rauhoghara aiwaꞌi yana apo a verem.” ");
INSERT INTO tpa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma i parivainuwaghani ma i vigwara ipa, “Aiwa u ghoheghoheiya apo a verem, inapa aꞌu anivitaniwaga tupona ghehauna, yana apo emoꞌemosiꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Mara emosi, guguhinina i hopu po ayona i raubayadei ipa, “Aiwa a vibaghei?” Ma ayona ipa, “John Taubabataito* unuꞌununa.” ");
INSERT INTO tpa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Po yaghiyaghinaꞌava i wanavirai po guyauna i raihunahunai ipa, “We marina yaghiyaghinaꞌava John Taubabataito,* unuꞌununa ona raugaebai po ona vereꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Guyauna yana i vinuwaboya duma, ma egha emoꞌemosina po ita geduꞌai, babana a taꞌomana au matahi ma i vigwara. ");
INSERT INTO tpa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Aubaina po tauvighaviya i raihunai ipa, “John unuꞌununa ona neiyaꞌi.” Ma i nae au deri po John uwana i tarautuini, ");
INSERT INTO tpa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma au gaeba i terei, po i neiyaꞌi, ma guguhinina i verei po ayona i vere damanei. ");
INSERT INTO tpa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Maranai John a tauvimuritagho tuyeghana hi nonori, yana hi nae po tupuwana hi vaini ma hi naiyei, po kokowaga* me duyuwa auhinenina hi terei. ");
INSERT INTO tpa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu a tauvotagho vinevinehi* hi wanavirameehi auwarina po aiwa hi dewadewaiya, ma me hi hanahanapunei atapuna hi vipariverenei. ");
INSERT INTO tpa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ma na au marana, yana rava hi magha duma hi neneꞌi ma hi naenae, ma egha Yesu a tauvotagho maitehi gavogavo hita verehi po hita am. Ma i riwehi ipa, “Na ravahi ona voterehi ma ona neꞌi, ma tana nae au dobu kwakwava po ta viyagohina.” ");
INSERT INTO tpa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Po tauhiꞌava au wam hi geru ma hi amkuka nae au dobu kwakwava. ");
INSERT INTO tpa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma rava maghamagha hi inanahi, ma hi inana tuhaghahi, aubaina meyagai maghamaghauna ravahi, gerahei hi votaghonae po hi ai gheꞌeta na au dobuna, ma muriyai Yesu a tauvotagho maitehi hi ghota. ");
INSERT INTO tpa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Maranai Yesu wamei i hauhopu yana rava maghamaghauhi i inanahi, aniꞌinanahi me ghamoghamo (sheep) egha ahi tauvipaꞌipaꞌi maiteni. Yamna aubaina i nuwadubuwehi, ma i vikare po Maimaituwa a vitaniwaga vouna* tuyeghana ana rava auwarihi atapuna i vihanahanapuhi. ");
INSERT INTO tpa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Maranai au i biga, yana a tauvotagho hi neꞌi po hi riwei hipa, “We au dobuna egha rava hita maꞌamaꞌae, ma aita madegha e yoriyori. ");
INSERT INTO tpa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Rava ma pariꞌaharehi po hina nae, meyagai aughereghereta auwarina po ahi yam hina gimara.” ");
INSERT INTO tpa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma i paribeehi ipa, “Taumi yam ona verehi po hina am.” Ma tauhi auwarina hipa, “Tam u ghoheꞌai po denarii 200 a gimarei po we patarana ghaeghaena a hewahi, ma auwariꞌai egha emoꞌemosina!” ");
INSERT INTO tpa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Po i raubayadehi ipa, “Habe ona baiha, payawa habiꞌagha auwarimi?” Maranai hi tuhaghai yana hipa, “Auwariꞌai yana payawa nima emosi ma iyana ruwagha.” ");
INSERT INTO tpa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Anima Yesu a tauvotagho i riwehi ipa, “Rava atapuhi ona riwehi po au gidagida hina tughura.” ");
INSERT INTO tpa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aubaina hi tughura, boru ghehauhi 50 ma ghehauhi 100. ");
INSERT INTO tpa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Anima Yesu payawa 5 ma iyana ruwagha i vaini, ma au mara i watata ma Maimaituwa i tarahiyauwei, ma payawa i tomutomui iyana maiteni. Ma a tauvotagho i vereverehi ma rava auwarihi hi raughutei. ");
INSERT INTO tpa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma atapuhi hi am po hi amhiyauwa duma, ");
INSERT INTO tpa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","anima a tauvotagho payawa ma iyana amtereterenana hi tuꞌwaruhi, yana poha 12 hi vihowahi. ");
INSERT INTO tpa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Rava, tauꞌam yana hi magha duma (5,000) nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yaghiyaghinaꞌava Yesu a tauvotagho i himirihi, po au wam hi geru ma hi aitayaha, hagahaga autupo ghehauna, dobu ana wava Betsaida, ma wate tauna patarahi i himirihi. ");
INSERT INTO tpa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Maranai i pariꞌaharehi nuwa ahiꞌahiyei, yana tauna au oya i amghaena raupari aubaina. ");
INSERT INTO tpa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma na waguvaraina, yana Yesu a tauvotagho wamei, hagahaga ausiporina, ma tauꞌavana yana au hayahaya. ");
INSERT INTO tpa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma i inanahi hi voevoe ma hi reta, togowa ma hive hi veraveraumatamatani. Ma naꞌi yana waguvarai, ma maratomtom augheregherena, ma hagahaga tepanei i neneꞌi po ipa ita verauvirehi. ");
INSERT INTO tpa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma hi inanai yana hi pamina konagha po hi otu boꞌaboꞌa. ");
INSERT INTO tpa_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Maranai atapuhi hi inanai yana hi rovo duma. Ma yaghiyaghinaꞌava, Yesu ponana i terei ma ipa, “Ona nuwamotu! We yana taꞌu. Egha ona rovo!” ");
INSERT INTO tpa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Anima au wam maitehi i geru, ma hivena i daumori. Ma a tauvotagho hi amhuna duma, babana egha aiwa hita inana tuhaghai marana payawa i dewai po i maghamagha. Babana nuwanuwahi yana i toghara duma. ");
INSERT INTO tpa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Hagahaga hi damani po hi nae au Gennesaret, po hi ghota ma ahi wam hi yoghoni. ");
INSERT INTO tpa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Po ahi wam hi tere aharei, ma rava mara emosi Yesu hi inana tuhaghai. ");
INSERT INTO tpa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma dobuna ghaeghaenana hi naeni, ma rava doridoriꞌahi hi hihiva naiyehi, mepa hi nonori po Yesu i nene yana. ");
INSERT INTO tpa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yesu a aninae atapuna auwarina, meyagai ghaeghaehi ma muhomuhohi po vaovao au numahi, rava ahi rava doridoriꞌahi na dobuna auwarina, hi naiyehi po au habuhabuna hi terehi, ma hi vibagha hipa, “Ma viꞌanina po am gara ipirinaꞌava hina vodadani.” Ma aiyavo doridoriꞌahi ma hi vodadani yana atapuhi hi yawahana, Yesu a kajijirei. ");
INSERT INTO tpa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Pharisees* ma mai Judea* ghehauhi raugagayo* maghamaghauhi ghooghahiyei hi votaghoiya. Yana ahi keyaka po ahi gaeba ma waira anihighuhi he rauꞌogha vaimaiha ma he dewadewa vaimaiha. Maranai maketiyei hina neꞌi yana nimahi hina oghai ma muriyai hina am. Mara maghamaghauna ghooghahi ahi raugagayo hi votaghoiya yana hina ogha da hina am. Mara emosi raugagayo tauvihanahanapuweina ma Pharisees ghehauhi Jerusalemei hi ghaꞌiraꞌi, po Yesu hi gari kwaviviroi ma hi rautanighanei. Ma hi iyaꞌiyau ma a tauvotagho egha nimahi hita ogha ma hi amꞌam. ");
INSERT INTO tpa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yamna aubaina Yesu hi riwei hipa, “Aiwa aubaina po a tauvotagho a nima mirahi ma he amꞌam? Aiwa aubaina raugagayo ghooghataiyei egha hita votaghoi?” ");
INSERT INTO tpa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I paribeehi ipa, “Taumi yana rava waimorumorumi, o dewamemi po ahi ota dewadewai ma tamoghi eꞌegha! Taumi aubaimi peroveta Isaiah i amgiruma we nanaꞌarena: ‘Maimaituwa ipa, “We ravahi yana gamohiyei hei ateꞌateꞌu ma ahi nuwatuhu yana autapuna ");
INSERT INTO tpa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tauhi ahi raugagayo hei hanahanapuwei ma hipa Maimaituwa a raugagayo, Yamna aubaina ahi viꞌateꞌate auwariꞌu yana egha anona.’” ");
INSERT INTO tpa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Anima Yesu ipa, “Taumi yana Maimaituwa a raugagayo o voterei ma ghooghami ahi raugagayo oi hanahanapuwei ma o votaghoi.” ");
INSERT INTO tpa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Wate i riwehi ipa, “Taumi aiwa o dewadewaiya o notai da i ahi duma! Ma Maimaituwa a raugagayo o tereriyei ma ghooghami ahi vihanahanapu o votaghoi. ");
INSERT INTO tpa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Aniꞌinana emosi yana we nanaꞌarena. Moses Maimaituwa a raugagayo auwarina i amgiruma, ipa, ‘Amam ma ayom ma viꞌateꞌatehi’ ma inapa ‘Aiya amana ma ayona ina eni boꞌahi yana hina raihiragheni.’ ");
INSERT INTO tpa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ma taumi oi hanahanapu, yana rava amana ma ayona purapura ina vohaguhi ma ina riwa inapa, ‘Apo ata vohagumi ma boiboghi Maimaituwa auwarina a parivainuwaghana aubaina apegha a vohagumi.’ ");
INSERT INTO tpa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Inapa we nanaꞌarena oi babani da ota dumaru, ma naꞌi yana eꞌegha, oi ghaꞌei da amana ma ayona egha ina vohaguhi. ");
INSERT INTO tpa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Maranai we nanaꞌarena ona dewai, yana ghooghami ahi vihanahanapu o votaghoi ma Maimaituwa a raugagayo o raugahi. Marina a ririwemi, da menanaꞌarena Maimaituwa a raugagayo o raugahinei yana a tayaha i magha duma.” ");
INSERT INTO tpa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu rava i ghoremehi po hi neꞌi auwarina ma i riwehi ipa, “Atapumi ai babani ona nonori ma anona au nuwanuwami ina raughadaghadari. ");
INSERT INTO tpa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Rava yam e aniꞌaniya apegha ina dewai, po ina mira Maimaituwa au matana. Ma aiwa au nuwanuwana e maꞌamaꞌae ma gamonei e hopuhopuꞌi, yana e dewai po e miramira Maimaituwa au matana.” ");
INSERT INTO tpa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Anima rava i voterehi ma i rui au numa ma a tauvotagho hi raubayadei hipa, “We marina aiwa u ampariruveruveiya yana anona aiwaꞌi?” ");
INSERT INTO tpa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","I paribeehi ipa, “Taumi maitemi! Auwarimi aꞌu babani anona egha ita raughadaghadari? O hanapuwei da maranai rava yam e aniꞌani, yana egha ita ruirui au nuwanuwana, ma e naenae au amoꞌamona ma e puwapuwana aharenei. Yamna apo egha ina dewai po Maimaituwa au matana ina mira.” Maranai Yesu we i yatoni, yana i vihegha da yam atapuhi, yana ahiꞌahihi Maimaituwa au matana. ");
INSERT INTO tpa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Anima wate ipa, “Rava nuwanuwanei aiwa e hopuhopuꞌi yana tauna e dewai po e miramira, Maimaituwa au matana. ");
INSERT INTO tpa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","We dewahi yana nuwanuwana hineninei e neneꞌi yana nuwatuhu apoꞌapoehi, yana rava egha hita tavine ma hei awaꞌawana, danene, vihiraghena, viꞌawa danene, ");
INSERT INTO tpa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","amboho, viꞌamparipari, vimorumoru, dewa waitepahinihinimayana, unura, viꞌaraꞌutu, nuwaghaeghae, ma dewa yabayababa. ");
INSERT INTO tpa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","We dewaboꞌahi atapuhi rava nuwanuwanei e hopuhopuꞌi, ma e dewai po e miramira Maimaituwa au matana.” ");
INSERT INTO tpa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Anima Yesu na dobuna i neꞌaharei ma i nae Tyre meyagaina auririvana po au numa i rui. Egha ita ghohei po rava hina hanapuwei ma wate egha emoꞌemosina po ita raugovagha. ");
INSERT INTO tpa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Wavine emosi i nonori yana tauna nahidana aubaina i nae auwarina. Ma we wavinena yana egha Judeyei, au Phoenicia hi ghuni Syria dobuna autupona. Ma aruwa apoꞌapoena* natuna wavinena haburuna i taniwagei, aubaina i neꞌi yana Yesu aunaona i raupari, ma i vibaghai po aruwa apoꞌapoena natuna auwarina ita raukaiweni. ");
INSERT INTO tpa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma i hanapuwei da na wavinena yana egha Judeyei, ma i neꞌi auwarina aubaina i riwei ipa, “Egha ita ahi po rowarowa ahi yam ouꞌou auwarihi ta aharei, yamna aubaina rowarowa ta ai ghamohi po aunaona hina amhiyauwa.” ");
INSERT INTO tpa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma wavinena ipa, “Bada, u riwa vaimaiha ma mara gheha aniꞌam patana auwarina, ma yam vunavunahi he horuhoru yana ouꞌou he aniꞌanihi, yamna aubaina i ahi po ma vohaguꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Anima Yesu ipa, “Moina! U riwa vaimaiha, am vitumaghana* aubaina aruwa apoꞌapoena natum auwarina a raukaiweni. Anima ma naeme am au numa.” ");
INSERT INTO tpa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Anima i naeme a au numa po natuna ita inanai yana i enoꞌeno a au aniꞌeno. Ma aruwa apoꞌapoena i hopu aharei. ");
INSERT INTO tpa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu, Tyre tupona i neꞌaharei po Sidon meyagaina siporinei i nae. Anima Decapolis meyagaina hineninei i neꞌi po Galilee au hagahagana i hopu. ");
INSERT INTO tpa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma nahidana rava ghehauhi, oroto tanighana pupuna ma egha itai babani vaimaiha, hi neiyaꞌi ma hi vibaghai da ita vodadani ma ita yawahana. ");
INSERT INTO tpa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aubaina po orotona i taravaini, ma rava hi neꞌaharehi po ahi ruwaghaꞌava ma nimagigina au tanighana i terei ma nimagigina i hovai ma menana i vodadani. ");
INSERT INTO tpa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ma i rauꞌiyau gheꞌeta au mara, ma i yavutu aharena ma ipa, “Efata!” Na babanina anona yana ipa, “Ma wanakaiwenim!” ");
INSERT INTO tpa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma mara emosi ravana tanighana i wanakaiweni, ma menana i vidagudagu po i vibabani vaimaiha. ");
INSERT INTO tpa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Anima Yesu i raugagayowehi da egha rava ghehauhi hinai heghehi. Ma maranai i ghaꞌehi yana apoma i raimaruhi aharei ma rava maghamaghauhi, hi ririwehi da menanaꞌarena we ravana i viyawahani. ");
INSERT INTO tpa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma maranai rava we babanina hi nonori yana hi amhuna duma ma hi riwa hipa, “We ravana ginauri maghamaghauna ahiꞌahihi e dewadewahi. Rava tanighahi puupuhi i viyawahanihi po he rautanighana ma gumgum hei babani.” ");
INSERT INTO tpa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na au marana, yana rava maghamaghauhi hi amtuborume. Ma Yesu maitehi hi maꞌae, ma i hanahanapu ma hi rautanighanei po ahi yam i kwaha. Yamna aubaina Yesu a tauvotagho i ghorehi po hi neꞌi auwarina, ma i riwehi ipa, ");
INSERT INTO tpa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“We ravahi maghamaghauhina yana a nuwadubuwehi babana maitehi maratom tonugha ta maꞌae, ma egha ahi yam. ");
INSERT INTO tpa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Inapa a am hiraghehi a himirihi ahi au numa, yana apo tayaha ausiporina hina raumoyaghahu. Ma wate ghehauhi yana uwamei hi neꞌi.” ");
INSERT INTO tpa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A tauvotagho hi paribeei hipa, “Egha aiya wehidana ita maꞌamaꞌae, aubaina apo mepa payawa tana vaini po we ravahi ta hewahi?” ");
INSERT INTO tpa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Anima Yesu i raubayadehi ipa, “Ma payawa habiꞌagha auwarimi?” Ma hipa, “Payawa 7.” ");
INSERT INTO tpa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Anima Yesu patarana ghaeghaenana i riwehi po au dowa hi tughura. Ma na payawahi i vainihi po Maimaituwa i amamari ma i vokabakabari, ma a tauvotagho i verehi po hi raughutei rava boruhi auwarihi. ");
INSERT INTO tpa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wate auwarihi yana iyana muhomuhohi, po i viꞌamamara iyana aubaina ma a tauvotagho i riwehi po boruna auwarihi hi raughutehi. ");
INSERT INTO tpa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rava atapuhi hi amꞌam yana hi amhiyauwa duma. Anima yam am tereterenahi a tauvotagho poha 7 hi vihowai. ");
INSERT INTO tpa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Na au marana yana rava maghauhi 4,000 nanaꞌarena. Ma aumurina yana Yesu i himirihi po hi vineyana ahi au numa. ");
INSERT INTO tpa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Anima Yesu a tauvotagho maitehi hi geru au wam po hi damana au Dalmanutha. ");
INSERT INTO tpa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma Pharisee ghehauhi hi neꞌi, po Yesu maiteni vipariꞌwayaꞌwaya hi vikareni. Hi ghohei po hita raudadani, aubaina hi vibaghai po matakiraha ita dewai, po hita inanai da moina tauna Maimaituwei i neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu aruwanei i yavutu aharena ma ipa, “Ahuu! Aiwa aubaina po we hapana o maꞌamaꞌae, oi baghaꞌu po matakiraha a dewai po ona inanai? Moinana a ririwemi da apo egha we hapana matakiraha awa a voghetei po ona inanai.” ");
INSERT INTO tpa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Anima i voterehi ma au wam i geru, po i damaname hagahaga autupo ghehauna. ");
INSERT INTO tpa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma Yesu a tauvotagho payawa nuwanuwahi i vuru, ma emosiꞌava hi vaini ma au wam hi geru. ");
INSERT INTO tpa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Yesu babani kajikajijirana i verehi ipa, “Ona inana vaimaiha, po Pharisees* ma Herod, ahi anihahana egha inai apoꞌapoenimi.” ");
INSERT INTO tpa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Po tauhiꞌava hi taratarapiri hipa, “Egha payawa tata vaini, yamna aubaina anihahana e dedei.” ");
INSERT INTO tpa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yesu ahi nota i hanapuwei po i raubayadehi ipa, “Aiwa oi nuwaboyei opa egha payawa ota vaini? Yohora oi nuwanaina? Nuwanuwami i pupu ma egha ita raughadari! ");
INSERT INTO tpa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Waimatami ma egha ota inana tuhagha. Waitanighami ma egha ota rautanighana vaimaiha. ");
INSERT INTO tpa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","O nota tuhaghai bo eꞌegha, payawa 5 a vokahakahaiya rava maghauhi 5,000 auwarihi. Yana poha habiꞌagha, hi amteretereiya o vihowai?” Ma hi paribeei hipa, “12.” ");
INSERT INTO tpa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ma wate payawa 7 a vokahakahaiya rava 4,000 aubaihi, yana hi amteretereiya poha habiꞌagha o vihowai?” Ma hi paribeei hipa, “7.” ");
INSERT INTO tpa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma i riwehi ipa, “Aiwa atapuna yana o inanai pahi ma o nonori ma yohora po oi nuwanaina?” ");
INSERT INTO tpa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Anima hi neꞌi Betsaida au meyagaina ma nahidana rava turahi matakeke hi neiyaꞌi Yesu auwarina, ma hi vibaghai po ita vodadani ma ita ahi. ");
INSERT INTO tpa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Po Yesu matakeke i raunimani, ma ahi ruwagha meyagai hi hopu aharei. Anima au matana i hova ma nimana au matana i terei ma i raubayadei ipa, “Aiwa e inaꞌinanai?” ");
INSERT INTO tpa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ma orotona i tahepai ma ipa, “Rava a inanahi me eyagi ma he naenae.” ");
INSERT INTO tpa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Anima Yesu nimana au matana i teremeei, ma matana i wanaghadari po ginauri atapuhi, i inana vaimahiꞌenihi. ");
INSERT INTO tpa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma Yesu ipa, “Egha ma naenaeme au meyagaina, ma dumaruwei ma nae am au numa.” ");
INSERT INTO tpa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Anima Yesu a tauvotagho maitehi hi veraunae Siseria Philippi, meyagaihi augheregherena. Maranai tauhi au tayaha yana a tauvotagho i raubayadehi ipa, “Rava he ririwa da taꞌu aiyaꞌi?” ");
INSERT INTO tpa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma hi paribeei hipa, “Rava ghehauhi he ririwa da tam John Taubabataito,* ma ghehauhi he ririwa da tam Elijah ma ghehauhi he ririwa da tam peroveta ghehauna i vomahirime.” ");
INSERT INTO tpa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Anima i raubayadehi ipa, “Ma taumi, me o ririwanei opa taꞌu aiyaꞌi?” Ma Peter ipa, “Tam yana Keriso, Maimaituwa a Vinevine Waiyawahanana.”* ");
INSERT INTO tpa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Anima i vighaꞌehi po egha aiya hina ririwei da tauna Keriso, Maimaituwa a Vinevine Waiyawahanana. ");
INSERT INTO tpa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Anima Yesu i vikare po a tauvotagho i hanahanapuhi da apo aiwa auwarina ina tupuwa. Ipa, “Taꞌu, Rava Natuna, viuva ghaeghaena apo a viꞌaroni, mai Judea* ahi babada, gudutaupuyoweina* ghaeghaehi, ma raugagayo tauvihanahanapuweina apo hina geduꞌaiyeꞌu. Aꞌu ghaviya apo hina vihiragheniꞌu po maratom tonugha aumurina ma apo hiragheei a vomahirime.” ");
INSERT INTO tpa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Weꞌi yana au habuhabuna Yesu i babaniyei, aubaina Peter i taravaini po auririva ma i vighaꞌei ipa, “Egha we nanaꞌarena am viuva ma am hiraghe mai babaniyei.” ");
INSERT INTO tpa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ma Yesu i ruhaghavirei po a tauvotagho i inanahi, ma Peter i eni, ipa, “Taumodurere* ma neꞌahareꞌu! Aiwa ei babaniyei yana egha Maimaituwa a rauhoghara ma dobu ravahi ahi vinuwanuwatuhuwei tam ei babani.” ");
INSERT INTO tpa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu, a tauvotagho ma rava atapuhi i ghorehi po hi neꞌi augheregherena ma i riwehi ipa, “Aiya ravana votaghoꞌu ina ghohei yana ina boviyanamei, ma a korosi inaꞌavarai ma ina votaghoꞌu. ");
INSERT INTO tpa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Rava aiya a yawahana ina nuwanei yana apo ina vineboꞌai, ma rava aiya a yawahana ina vineboꞌai tuyeghaꞌu ahiꞌahina ma votaghoꞌu aubaina, yana apo yawahana maꞌemaꞌe vavahaghana ina vaini. ");
INSERT INTO tpa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Inapa rava ginauri atapuna au dobu ina vaini, ma egha yawahana maꞌemaꞌe vavahaghana ina vaini, yana we ginaurihi egha ana ahi aiwa tauna auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Inapa rava a yawahana maꞌemaꞌe vavahaghana ina vineboꞌai, yana apo egha aiwaꞌiyei ina vimaiha ma ina vainameei. ");
INSERT INTO tpa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Rava we au dobuna he maꞌamaꞌae, yana aꞌu dewa hi geduꞌaiyei ma he dewadewaboꞌa. Ma inapa rava aiya i geduꞌaiyeꞌu ma i rovo po riwaꞌu we ravahi aunaohi egha ita vituyetuyeghei yana, Taꞌu Rava Natuna, apo a geduꞌaiyei. We apo ina tupuwa maranai aꞌu nememeꞌi amaꞌu a viguyauwei ma a aneya* vivireihi maitehi.” ");
INSERT INTO tpa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“A ririwana dumemi, ghehaumi we o mahimahiri yana apo yohora ona maꞌamaꞌae ma Maimaituwa a vitaniwaga vouna* ma a kajijira ana rava auwarihi e neneꞌi ona inanai.” ");
INSERT INTO tpa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Maratom 6 aumurina, yana Yesu, Peter, James ma John tauꞌavahi i rautayahahi ma oya davodavona hi ghaini, ma au matahi inanana i wanavirai. ");
INSERT INTO tpa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ana gara wakekena i vimataꞌam. Apo egha rava ghehauna gara ina oghai, po ina wakeke we au dobuna nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Anima peroveta Elijah ma Moses hi raugheꞌetehi po Yesu maiteni hi babani. ");
INSERT INTO tpa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Aubaina po Peter ana rava ruwagha maitehi hi rovo duma, ma egha hita haramanei po aiwa hina yatoni yamna aubaina Peter ipa, “Tauvihanahanapu, i ahi po tauta wehidana. Ma kape tonugha a vowahi, emosi yana aubaim, emosi Moses aubaina ma emosi yana Elijah aubaina.” ");
INSERT INTO tpa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nahidana hapau i hopuꞌi po atapuhi i puruyaghohihi, ma Maimaituwa hapauna auhinenina i vibabani ipa, “Weꞌi yana natuꞌu aꞌu rauhoghara. Ona viponavowei!” ");
INSERT INTO tpa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anima hipa hina rauꞌiyaume yana egha aiya hita inanai ma Yesu tauꞌavana. ");
INSERT INTO tpa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yesu ma a tauvotagho tonugha maitehi oya hi ghaꞌighaꞌirini, ma i vighaꞌehi da au oya aiwa hi inaꞌinanaiya havena da aiya hina riwei. Da Tauna Rava Natuna apo ina hiraghe ma ina vomahirime, ma aumurina yana rava hina pariverehi. ");
INSERT INTO tpa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Po Yesu aiwa i ririweiya hi nuwadaꞌwai ma tauhiꞌava aupouhi hi babani yana hipa, “Aiwa anona ma Yesu hiraghei vomahirina ei babaniyei?” ");
INSERT INTO tpa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma hi raubayadei hipa, “Aiwa aubaina raugagayo tauvihanahanapuweina he ririwa da Elijah apo ina ai nememeꞌi?” ");
INSERT INTO tpa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma Yesu ipa, “Yamna moina, Elijah apo ina nememeꞌi po ginauri atapuna ina nonoghei. Ma we ona notai da Maimaituwa tuyeghana i riwa da Taꞌu Rava Natuna apo viuva a viꞌaroni ma hina geduꞌaiyeꞌu. ");
INSERT INTO tpa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Riwa moina a ririwemi, Elijah boiboghi i neꞌi ma rava aiwa hi ghoheghoheiya auwarina hi dewai. Me peroveta i amgirumanei, nanaꞌarena i tupuwa.” ");
INSERT INTO tpa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Yesu, a tauvotagho maitehi oyei hi wanavirahi, po hi hopume ahi rava auwarihi, ma rava maghamaghauhi ma raugagayo tauvihanahanapuweina hi inanai yana a tauvotagho hi gari kwavivirohi, ma maitehi hi gamo gahigahi. ");
INSERT INTO tpa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Maranai Yesu, rava hi inanai yana hi hauhepahi, ma hi ruba po hi vokaokaohei. ");
INSERT INTO tpa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma i raubayadehi ipa, “Aiwa oi gamo gahigahiyei?” ");
INSERT INTO tpa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma oroto na au boruna ipa, “Tauvihanahanapu, aruwa apoꞌapoena* natuꞌu i ruini ma i dewai po egha itai babani, aubaina po a neiyaꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Maranai e verauhurui yana e dubari, po gamonei puropuro e hopuhopu, ma ivona e utaꞌuta ghirighiriyei ma e doodora. Ma am tauvotagho a vibaghahi po aruwana apoꞌapoena, hita raukaiweni ma egha emoꞌemosina hita dewai.” ");
INSERT INTO tpa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma Yesu i paribeehi ipa, “Ahuu, mara aiwa ona vitumaghana! Maiteꞌu ta maꞌe duma! Ma mara habiꞌagha a viꞌatataiyemi? Teverana ona neiyaꞌi auwariꞌu!” ");
INSERT INTO tpa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Po teverana hi neiyai Yesu auwarina. Ma me haugana aruwa apoꞌapoena Yesu i inanai, yana i dewai po opina i dodora ma i guhui yamoyamonei po au dowa i peꞌu, ma i vitovitovira po i nae ma puropuro gamonei i hopuhopu. ");
INSERT INTO tpa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yamna aubaina Yesu, teverana amana i raubayadei ipa, “Mara aiwa doriꞌana i vikareni?” Ma ipa, “Haburuna ma i vikareni. ");
INSERT INTO tpa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Aruwa apoꞌapoena mara maghamaghauna ei peꞌuni eyagi araꞌaratana auwarina bo au waira, ipa ina vihiragheni. Ma inapa emoꞌemosim yana auwarina aiwa ma dewai ai bagham, po ma raunuwa apoꞌapoeꞌai ma vohaguꞌai.” ");
INSERT INTO tpa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma Yesu i ipa, “Ma menanaꞌarena ma upa, ‘Emoꞌemosina yana aiwa auwarina ma dewai?’ Rava aiya ina vitumaghana* yana Maimaituwa auwarina ginauri atapuna yana emoꞌemosina!” ");
INSERT INTO tpa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Mara emosi teverana amana ponana i raꞌata ma ipa, “A vitumaghana. Ma aꞌu vitumaghana egha ita raꞌata, yamna aubaina ma vohaguꞌu po ina raꞌata!” ");
INSERT INTO tpa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu auwarina patara ghaeghaena hi neneꞌi, yamna aubaina po aruwa apoꞌapoena i autani ipa, “Tam aruwa apoꞌapoena rava e dewahi po hei vigumgum ma tanighahi he pupupu, a autanim po na teverana ma hopu aharei ma egha meyanai ma ruinameei!” ");
INSERT INTO tpa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aruwana i otu, ma teverana i dewai po i dodora ma i guhui yamoyamonei, ma i hopu aharei. Anima teverana i aniꞌinana me rava hirahiraghena, aubaina rava atapuhi hipa, “Aeta i hiraghe.” ");
INSERT INTO tpa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ma Yesu au nimana i vowa ma i vovaimahirini po i tumahiri. ");
INSERT INTO tpa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma muriyai, yana Yesu au numa i rui ma a tauvotagho tauhiꞌava ma hi riwei hipa, “Me nanaꞌarena po taiꞌwai egha aruwana apoꞌapoenana ata himira hopunei?” ");
INSERT INTO tpa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma i riwehi ipa, “Aruwa apoꞌapoehi me we tauna yana apegha ta himira yababai, da raupariꞌavei.” ");
INSERT INTO tpa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu, a tauvotagho maitehi na dobuna hi voterei, ma Galilee hineninei hi nae. Ma Yesu egha ita ghoheghohei da aiya ina hanapuwei da tauhi me autupona, ");
INSERT INTO tpa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","babana a tauvotagho i hanahanapuhi. Ma i ririwehi ipa, “Taꞌu, Rava Natuna, aꞌu ghaviya apo hina amvereneꞌu, po rava ghehauhi hina vihiragheniꞌu, ma maratom tonugha aumurina ma apo a vomahirime.” ");
INSERT INTO tpa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","We nanaꞌarena auwarihi i vibabani, ma egha hita hanapuwei, ma hi rovo po egha hita raubayadei. ");
INSERT INTO tpa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Anima Yesu ma a tauvotagho maitehi au Caponiam hi raugheꞌeta po au numa hi rui, ma i raubayadehi ipa, “We au tayaha aiwa oi tarapiriyei?” ");
INSERT INTO tpa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ma hi vogenuwana babana au tayaha yana tauhiꞌava hi tarapiri vivira, da aupouhi yana aiya apo ina vibada. ");
INSERT INTO tpa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","I tughura ma a tauvotagho vinevinehi* 12, i ghorehi po hi neꞌi auwarina ma ipa, “Aiya vibada ina ghohei yana ina tereghaꞌiranamei, ma ina vitaubagibagi ana rava auwarihi.” ");
INSERT INTO tpa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ma tevera i vaini po ausiporihi i vimahirini. Ma i tarahaghavui ma i riwehi ipa, ");
INSERT INTO tpa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aiya wavaꞌuwei tevera ina vokaokaohei, yana taꞌu e vokaokaoheꞌu, ma aiyaꞌi e vokaokaoheꞌu, yana egha tauꞌavaꞌu ma tauhimiriꞌu maiteni e vokaokaohei.” ");
INSERT INTO tpa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John, Yesu i riwei ipa, “Tauvihanahanapu, taiꞌwai rava ghehauna a inanai ma wavammei aruwa apoꞌapoehi i raukaiwenihi. Ma a vighaꞌei po egha ina dewameei, babana tauna yana egha turata.” ");
INSERT INTO tpa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Yesu ipa, “Egha onai ghaꞌei. Egha emoꞌemosina po rava wavaꞌuwei dewa anivinuwanaina, ina dewai ma aumurina wavaꞌu inai apoꞌapoeni. ");
INSERT INTO tpa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aiya egha itai ghaviyeta yana turata. ");
INSERT INTO tpa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Moina a riwa duma, inapa rava aiya waira ina veremi babana taumi tauvotaghoꞌu, yana ana maiha apegha ina vineboꞌai, ma apo ina vaini.” ");
INSERT INTO tpa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Inapa tevera ei tumaghaneꞌu ma aiya ravana aena ina taini po apoꞌapoe ina dewai, yana Maimaituwa apo kovogha ghaeghae dumana ina verei. Ma inapa au uwana ghaꞌima ghaeghaena hina raghihi ma au boga hina dubari, yana i ahi ma na kovoghana egha ita raꞌata vaimaiha. ");
INSERT INTO tpa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma ona inana vaimaiha po egha ona dewadewaboꞌa. Inapa nimam ina dewam po apoꞌapoe ma dewai, yana ma tarautuina aharei. I ahi po nimam emosiꞌava ma yawahana Maimaituwa auwarina ma nehaghai, ma apoma nimam ruwagha ma ma nae au gehena, mepa eyagi hauga davodavona e araꞌaratayana. ");
INSERT INTO tpa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma inapa aem ina dewam po apoꞌapoe u dewai, yana ma tarautuina aharei. I ahi po aem emosiꞌava ma yawahana Maimaituwa auwarina, ma nehaghai ma apoma aem ruwagha ma au gehena hina dubara hopunem. ");
INSERT INTO tpa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Inapa matam ina dewam po apoꞌapoe u dewai, yana ma vahiꞌaharei. I ahi po matam emosi ma Maimaituwa a anivitaniwaga vouna auwarina ma rui, ma apoma matam ruwagha ma au gehena hina dubarim. ");
INSERT INTO tpa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na au dobuna, yana ‘motamota rava he aniꞌanihi ma egha hita hirahiraghe, ma eyagi hauga davodavona e araꞌarata, ma egha ita bohoboho.’ ");
INSERT INTO tpa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ma aꞌu tauvotagho atapuhi yana apo raudadana hina viꞌaroni, mayana vainana yana me eyagi araꞌaratana. ");
INSERT INTO tpa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Niha yana ginauri ahiꞌahina, ma inapa a viniha ina yababa, yana apo egha emoꞌemosina ta dewai po ina vinihame. Egha nanaꞌarena ona dewadewa, ma ona viniha ma ami rava maitehi a nuwahubami ona maꞌae. ");
INSERT INTO tpa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu na dobuna i votere aharei, ma i nae au Judea po Jordan wairana i damani au maramatanei. Ma rava boruhi hi nememe auwarina po i hanahanapuhi, me mara maghamaghauna i dewadewaiya nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma Pharisee ghehauhi hi neꞌi po hi ghohei, da Yesu hita raudadani po hi raubayadei hipa, “Ata raugagayo* i viꞌanina da oroto awana ina aharei?” ");
INSERT INTO tpa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma i paribeehi ipa, “Ma Moses raugagayo i amvereneiya, me i riwanei?” ");
INSERT INTO tpa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma hipa, “Moses i viꞌanina po oroto awana raimoina pepana, ina girumi po ina verei ma muriyai ina aharei.” ");
INSERT INTO tpa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Anima Yesu i paribeehi ipa, “Moses na raugagayona aubaimi i girumi babana nuwanuwami hi toghara. ");
INSERT INTO tpa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ma au karena Maimaituwa rava ‘orotona ma wavinena i dewahi.’ ");
INSERT INTO tpa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Ma ‘Weꞌi aubaina, oroto ayona ma amana ina votere aharehi, ma awana maiteni hina ampopo, ma hina dewamehi po tauhi viyowa emosi.’ ");
INSERT INTO tpa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Au karena we nanaꞌarena Maimaituwa i dewai aubaina po aiwa i emosiyeiya, yana egha rava ina viyamonehi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma hi naeme au numa, yana a tauvotagho we aubaina hi raubayadei. ");
INSERT INTO tpa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma i paribeehi ipa, “Inapa oroto awana ina aharei ma wavine tapuna ina ravaghi, yana tavine raugagayona i raugahi. ");
INSERT INTO tpa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tayahana emosina, inapa wavine awana ina aharei ma oroto tapuna ina ravaghi, yana tavine raugagayona i raugahi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rava ghehauhi rowarowa hi nehimaꞌi Yesu auwarina po ita votepanihi, ma a tauvotagho hi ghahiyawa. ");
INSERT INTO tpa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma Yesu i inanahi yana amona i ghaighai ma a tauvotagho i riwehi ipa, “Rowarowa ona voterehi po auwariꞌu hina neꞌi, ma egha onai ghaꞌehi, babana Maimaituwa a vitaniwaga vouna yana rava aiyavo me we tauhi rowarowahi nanaꞌarena aubaihi. ");
INSERT INTO tpa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A ririwemi, rava aiya Maimaituwa a vitaniwaga vouna* egha ina vaini me we teverana nanaꞌarena, yana apo egha emoꞌemosina po ina ruini.” ");
INSERT INTO tpa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Anima rowarowa i vainihi po au yapana i terehi, ma i votepanihi ma Maimaituwa i vibaghai po i viꞌahiꞌahinihi. ");
INSERT INTO tpa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Anima, na au marana Yesu i vomahiri po i naenae, ma rava ghehauna i ruba po aunaona i raudune ma i raubayadei ipa, “Tauvihanahanapu ahiꞌahina, aiwa a dewai po yawahana maꞌemaꞌe vavahaghana ana vaini?” ");
INSERT INTO tpa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Yesu i riwei ipa, “Aiwa aubaina u riweꞌu da taꞌu ata ahi? Egha aiya ita ahi da Maimaituwa tauꞌavana. ");
INSERT INTO tpa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tam yana Maimaituwa a raugagayo* u haramanei. ‘Egha ma vihiraghena, egha ma viꞌawadanene, egha ma danene, egha ma terevaidegha, egha vimorumoruwei rava ahi purapura ma vaini, ma amam ma ayom ma viꞌateꞌatehi.’” ");
INSERT INTO tpa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma i paribeei ipa, “Tauvihanahanapu, haburuꞌumai po amadoꞌi yana we raugagayohi a voteꞌeteꞌehi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ma Yesu rauhogharei i inanai ma ipa, “Dewa emosiꞌava u vineboꞌai. Ma nae po am mahura atapuna ma gimarehi, ma aiwa u vaivainiya ma naiyei po yamoyamona ma verehi, ma am maiha yana apo au mara. Yamna ma dewai ma aumurina, ma neꞌi po ma votaghoꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tauna yana i mahura duma aubaina po maranai we babanina i nonori, yana naona i hariri ma a nuwaboyana i nae. ");
INSERT INTO tpa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu i inana viravira ma a tauvotagho auwarihi i vibabani ipa, “Tauhi aiyavo mahumahurahi yana i piripiri duma auwarihi, po Maimaituwa hina viꞌaninei po ahi yawahana ina vitaniwagei.” ");
INSERT INTO tpa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A tauvotagho yana hi amhuna duma a babani auwarina. Ma Yesu ipa, “Natunatuꞌu, Maimaituwa a vitaniwaga vouna ruinana yana i piripiri duma. ");
INSERT INTO tpa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I piripiri po camel ighoma au gavogavona ina rui, ma i piripiri duma po rava mahumahurana Maimaituwa ita viꞌaninei po a yawahana ita vitaniwagei.” ");
INSERT INTO tpa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ahi amhuna i kwaha ma hi raubayadanameehi hipa, “Inapa we nanaꞌarena yana apo aiya yawahana maꞌemaꞌe vavahaghana ina vaini? Bo menanaꞌarena?” ");
INSERT INTO tpa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu i inanahi ma ipa, “Egha emoꞌemosina po rava hina viyawahanameehi, ma Maimaituwa apo ina dewai, babana ginauri atapuna Maimaituwa auwarina yana emoꞌemosina.” ");
INSERT INTO tpa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Anima Peter i riwei ipa, “Ma inanai, we taiꞌwai menanaꞌarena. Boiboghi aꞌi ginauri atapuhi a voterehi ma a votaghom.” ");
INSERT INTO tpa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu ipa, “A ririwana dumemi, inapa aubaiꞌu ma tuyegha ahiꞌahina vidabararana aubaina, ma rava ana numa, varevarehina, novunovuna, ayona, amana, natunatuna ma ana dobu ina neꞌaharei, ");
INSERT INTO tpa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","yana we marina Maimaituwa apo ginauri autepana maghamaghau dumahi ina raipotoi. Ma aiwa i voterehi apo ina vainihi, ana numa, varevarehina, novunovuna, ayoyona, natunatuna ma ana dobu. Wate rava apo piripiri davodavona hina verei. Ma mara muriyai apo yawahana maꞌemaꞌe vavahaghana ina vaini. ");
INSERT INTO tpa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Rava maghamaghauhi marina he tayatayaha yana apo hina vimuri, ma marina maghamaghauhi heimurihi apo hina tayaha.” ");
INSERT INTO tpa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu, a tauvotagho maitehi hi naena au Jerusalem, ma Yesu i aitayaha ma a tauvotagho ahi nuwatuhu i magha, ma tauvimuritagho ghehauhi yana hi rovo. Anima Yesu, a tauvotagho 12, i vainameehi po auririva, ma apo auwarina aiwa ina wawara i riwehi, ");
INSERT INTO tpa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ipa, “Ona inanai we ta ghaeghae au Jerusalem, yana apo Taꞌu Rava Natuna hina amvereneꞌu gudutaupuyoweina* ghaeghaehi ma raugagayo tauvihanahanapuweina auwarihi po hina viꞌanineꞌu da a hiraghe. Apoma rava egha mai Judea auwarihi hina amvereneꞌu. ");
INSERT INTO tpa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Po tauhi hina vijiboghiꞌu, hina hovaꞌu, hina kwapuꞌu ma hina vihiragheniꞌu. Ma maratom tonugha aumurina apo a vomahirime.” ");
INSERT INTO tpa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Anima Zebedee natunatuna James ma John hi neꞌi Yesu auwarina ma hipa, “Tauvihanahanapu, a ghohei po aꞌi vibagha aiwa auwarim yana ma dewai.” ");
INSERT INTO tpa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma i raubayadehi ipa, “Aiwa o ghoheꞌu po aubaimi a dewai?” ");
INSERT INTO tpa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma hi paribeei hipa, “Ma viꞌanina po au ahoꞌohohim ma au ahokeham a tughura am viguyau au marana.” ");
INSERT INTO tpa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu i riwehi ipa, “Egha ota hanapuwei aiwa oi gigimanei. Taumi anina po vinuwaviuva keyakana ana umaumaiya ona umai, bo ona babataito* me taꞌu ana babataito nanaꞌarena?” ");
INSERT INTO tpa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma hi paribeei hipa, “Auwariꞌai yana anina.” Ma i riwehi ipa, “Na keyakana ana umaumaiya apo ona umai, ma me ana babataitonei nanaꞌarena ona babataito. ");
INSERT INTO tpa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ma au ahoꞌohohiꞌu bo au ahokehaꞌu tughurana, yana egha taꞌu ghariꞌuwei po a veremi, Maimaituwa we gabuhi yana tauhi aiyavo, i vinevinehi apo ina verehi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Maranai a tauvotagho ghehauhi 10 hi nonori aiwa James ma John hi dewadewaiya yana amohi i ghaighai. ");
INSERT INTO tpa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Yesu i ghorehi po auwarina hi viꞌemosi ma i riwehi ipa, “O hanapuwei, tauhi aiyavo vitaniwaga hi vaini ma rava egha mai Judea hei badehi, yana ahi kajijira i raghonihi, ma tautayahehi yana ahi taniwaga i vibagibagi po he rauꞌiviꞌapoꞌapoehi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ma taumi auwarimi yana egha nanaꞌarena, inapa aiya i ghohei po wavana ina raꞌata yana ina vitaupaura aupoumi. ");
INSERT INTO tpa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","45","Ma aiya ina ghohei po ina tayaha, yana atapumi aubaimi ina vitaupaura. Babana Rava Natuna egha ita neꞌi po hina paurei ma tauna ina vitaupaura, ma a yawahana ina amverenei po rava maghamaghauhi ina gimarahi.” ");
INSERT INTO tpa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Anima maranai Yesu a tauvotagho maitehi hi gheꞌeta au Jericho. Po maranai hi hopuhopu aharei yana rava boruhi maitehi hi nae. Ma rava emosi wavana Bartimaes, yana Timeas natuna matana keekena tayaha auririvana i tughura ma mane i gigimana. ");
INSERT INTO tpa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma maranai i nonori da rava hi ririwa hipa, “Yesu Nazarethei e veraverauvira” yana i vighore ipa, “Yesu, David a umavou, ma raunuwa apoꞌapoeꞌu!” ");
INSERT INTO tpa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma rava boruhi hi eni ma hi riwei hipa, “Ma genuwana!” Ma apoma ponana i raꞌata ma i ghoreghore duma ipa, “Yesu, David a umavou, ma raunuwa apoꞌapoeꞌu!” ");
INSERT INTO tpa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yamna aubaina Yesu i tumahiri ma i riwehi ipa, “Ona ghoreiya wehidana.” Eghabaine ravana matana keekena hi ghoreiyaꞌi po hi riwei hipa, “Nuwanuwam ina ahi ma ma vomahiri! E ghoreghorem ma ne auwarina.” ");
INSERT INTO tpa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ravana kaoha i dewai po ana anirauhawawara i ahare naiyei ma i vihauhepa, ma i nae Yesu auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Yesu i raubayadei ipa, “Aiwa u ghoheꞌu po aubaim a dewai?” Ravana matana keekena i paribeei ipa, “Tauvihanahanapu, a ghohei po a inana.” ");
INSERT INTO tpa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu i riwei ipa, “Anima ma nae, am vitumaghana* i viyawahanim.” Ma mara emosi matana i wanakaiweni, po i inana ma Yesu tayahei i vimuritaghonaiyei. ");
INSERT INTO tpa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu a tauvotagho maitehi muriya po hita gheꞌeta au Jerusalem, yana hi ai gheꞌeta au Betage ma Bethany, Oya Olive augheregherena. Anima a tauvotagho ruwagha ");
INSERT INTO tpa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","i riwehi, ma i pariꞌaharehi ipa, “Ona nae meyagai aunaomi ona ghegheꞌetaiyana, apo donki yaubona hi raghihi po e maꞌamaꞌae, egha aiya ghehauna ita geru dadani, ona ohei po ona neiyaꞌi wehidana. ");
INSERT INTO tpa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma aiyaꞌi ina raubayademi inapa, ‘Aiwa aubaina we o dewadewai?’ yana ona riwei, ‘Onapa Bada i rauhogharei ma apo mara tuponaꞌava, ma ina himirameeiyaꞌi.’” ");
INSERT INTO tpa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aubaina ahi ruwagha hi nae po donkina yaubona au tayaha rava hi raghihi numa au mataꞌetana po i mahimahiri hi nehaghai, yana hi oheꞌohei, ");
INSERT INTO tpa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ma nahidana rava hi mahimahiri yana hi raubayadehi hipa, “Aiwa aubaina donkina yaubona o oheꞌohei?” ");
INSERT INTO tpa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Po a tauvotagho ruwagha hi paribeehi, Yesu me i ririwanehi nanaꞌarena, anima ravahi hi viꞌaninehi po hi naiyei. ");
INSERT INTO tpa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Maranai donkina hi neiya auwarina, yana ahi anirauhawawara au uputuwana hi taꞌuri ma autepana Yesu i tughura. ");
INSERT INTO tpa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ma rava maghamaghauhi ahi anirauhawawara au tayaha hi taꞌuri ma ghehauhi ghihi au ꞌwapu hi tarai ma au tayaha hi taꞌuri. ");
INSERT INTO tpa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma rava aiyavo hi tayatayaha po waimurihi hi otuꞌotu ma hipa, “Maimaituwa ta votaraghaiyei! Maimaituwa ina viꞌahiꞌahini, tauna Bada wavanei e neneꞌi! Votaraghae! Waiꞌahiꞌahinana tauna auwarina Bada wavanei e neneꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Waiꞌahiꞌahinana amata David a umavou e neneꞌi ma a vitaniwaga vouna ta kaohei! Votaraghae Maimaituwa auwarina!” ");
INSERT INTO tpa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Anima Yesu i gheꞌeta au Jerusalem po i rui Maimaituwa a au Numa. Ma ginauri atapuhi i inana naiyehi, ma aita au i biga aubaina po a tauvotagho 12 maitehi hi nae au Bethany. ");
INSERT INTO tpa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Maratom au ghehauna, maranai Yesu a tauvotagho maitehi Bethaniyei hi nenememeꞌi, yana am i voiyei. ");
INSERT INTO tpa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma kaiyaha rauruguna auheiya i inanai, aubaina i nae po anona ita baihei, ma maranai i nae auwarina yana egha anona ma rugunaꞌava, babana egha ana hauga rauꞌano. ");
INSERT INTO tpa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Anima Yesu kaiyahana i riwei ipa, “Egha meyanai aiya anom ina ameei!” Anima a tauvotagho aiwa i yatoyatoniya hi nonori. ");
INSERT INTO tpa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Maranai Yesu a tauvotagho maitehi hi raugheꞌeta au Jerusalem, yana Yesu i rui Maimaituwa ana Numa* au ganahobena ma tauviꞌuneꞌune i vireta hopunehi ma mane tauvivereverena ahi pata ma gabubu taugimareina ahi anitughura i buinihi. ");
INSERT INTO tpa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma i vighaꞌa po egha anivigimagimara hinaꞌavara ma hina vitupatuni Maimaituwa ana Numa ganahobenei. ");
INSERT INTO tpa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Maranai i hanahanapuhi yana ipa, “Maimaituwa ponana hi girugirumiya ipa, ‘Rava hina riwa da aꞌu numa yana dobu atapuna ravahi ahi pari numana.’ Ma taumi o dewai po me rava danedanenehi, ahi numa.” ");
INSERT INTO tpa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Gudutaupuyoweina* ghaeghaehi ma raugagayo tauvihanahanapuweina we hi nonori yana hi vikare po tayaha hi baibaiha vihiraghenana aubaina ma hi rovowei, babana rava boruhi a vihanahanapu auwarina hi amhuna. ");
INSERT INTO tpa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Maranai au i pompom yana a tauvotagho maitehi Jerusalem hi neꞌaharei. ");
INSERT INTO tpa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Maratomtom ghehauna Yesu a tauvotagho maitehi hi neꞌi po hita verauvira ma kaiyahana hi inanai yana i poꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Peter nuwanei i ghae po Yesu i riwei ipa, “Tauvihanahanapu ma inanai! Kaiyahana u parikubaiya i poꞌi.” ");
INSERT INTO tpa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu i paribeehi ipa, “Maimaituwa ona vitumaghanei. ");
INSERT INTO tpa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Taꞌu yana riwa vaimaiha a ririwemi, rava aiya we oyana ina riwei inapa, ‘Ma nae po ma aharemem au boga’ ma egha ina raunuwa ruwaruwagha, ma ina vitumaghana* yana aiwa i ririweiya, apo ina wawara ma aubaina apo ina dewai. ");
INSERT INTO tpa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yamna aubaina po a ririwemi. Maranai ginauri aiwa o raupari ma oi bagheiya, ona vitumaghana da boiboghi o vaini, yana apo aiwa oi bagheiya ina veremi. ");
INSERT INTO tpa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Maranai e raupari ma rava ghehauna i dewaboꞌa auwarim, yana ma ai nuwaꞌaharei, ma Amam au mara nanaꞌarena apo am dewaboꞌa ina nuwaꞌaharei.” ");
INSERT INTO tpa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu, a tauvotagho maitehi hi gheꞌetame au Jerusalem, ma Yesu i naenae Maimaituwa ana Numa* au ganahobe, ma gudutaupuyoweina* ghaeghaehi, raugagayo tauvihanahanapuweina ma ahi babada hi neꞌi auwarina, ");
INSERT INTO tpa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","po a vaivai hi vitaravirevirei hipa, “Aiya wavanei we dewahi e dewadewai? Bo aiya vaivaina i verem?” ");
INSERT INTO tpa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Yesu i pariverehi ipa, “Aꞌu raubayada emosi a vitaravireviremi, po ona vimaihei ma apo a riwemi, aiwa vaivainei we ginaurihi a dewadewahi. ");
INSERT INTO tpa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ona riweꞌu John aiya i riwei po i ambabataito: Maimaituwa bo rava?” ");
INSERT INTO tpa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tauhiꞌava hi vikare po hi taratarapiri vivira hipa, “Me ta riwanei, inapa ta paribeei tanapa Maimaituwa, yana apo inapa, ‘aiwa aubaina John egha ota vitumaghanei?’ ");
INSERT INTO tpa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wate apo egha tana riwa da rava hi riwei.” Babana rava yana John hi vitumaghanei, da tauna peroveta, po patarahi hi rovowehi. ");
INSERT INTO tpa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Po ahi paribeeyana Yesu auwarina yana hipa, “Egha ata hanapuwei.” Ma Yesu i riwehi ipa, “Taꞌu nanaꞌarena apegha a riwemi, da aiwa vaivainei we ginaurihi a dewadewahi.” ");
INSERT INTO tpa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Anima Yesu ampariruveruvei auwarihi i vibabani ipa, “Rava emosi, wine a epaꞌepana i vaghoi ma i gari kwaviviroi. Ma anibuyona i dewai ma oyagha numana i vowai. Anima tauvipaꞌipaꞌi i vainihi po vaovaona hita vobagibagiyei, ma tauna i neꞌaharehi au dobu gheha. ");
INSERT INTO tpa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maranai raupupu ana mara i gheꞌeta yana taniwagana a hewari i himiri, a tauvipaꞌipaꞌi auwarihi po ana ghuta ita vaini. ");
INSERT INTO tpa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ma a tauvipaꞌipaꞌi hi vomahiri yana hi vojijini po hi kwapui ma a nima kwakwavina hi himirameei. ");
INSERT INTO tpa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wate taniwagana a hewari ghehauna i himirameei auwarihi, yana wate hi vomahirime po unuꞌununa hi ravi, ma dewa waitepahinihinimayana auwarina hi dewai. ");
INSERT INTO tpa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wate taniwagana a hewari ghehauna i himiri, ma we tauna yana hi vihiragheni, ma maghamaghauhi ghehauhi, yana dewana emosina auwarihi hi dewai, hi kwapuhi ma ghehauhi hi vihiraghenihi. ");
INSERT INTO tpa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ma marina yana rava emosiꞌava yagana, naꞌi yana tauna natu ohohina a rauhoghara, i himiri a tauvipaꞌipaꞌi auwarihi. Ma ipa, ‘A vimoina da apo natuꞌu hina viꞌateꞌatei.’ ");
INSERT INTO tpa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ma a tauvipaꞌipaꞌi hi viꞌogatara vivira hipa, ‘Weꞌi yana taniwaga natuna, ona neꞌi po ta vihiragheni ma a buderi ina vigharitaiyei!’ ");
INSERT INTO tpa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yamna aubaina hi vunui po hi vihiragheni ma hi ahare hopunei, epaꞌepana auꞌupuna. ");
INSERT INTO tpa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma apo aiwa epaꞌepana taniwagana ina dewai? Apo ina neꞌi yana a tauvipaꞌipaꞌihi ina vihiraghenihi, ma epaꞌepana a tauvipaꞌipaꞌi ghehauhi ina verehi. ");
INSERT INTO tpa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Egha Maimaituwa riwana girugirumana ota hiyavi: ‘Oghorana tauraunuma hi gedugeduꞌaiyeiya i vitovira po i viꞌoghora hoghona. ");
INSERT INTO tpa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bada we i dewadewaiya, yana au matata i ahi vavahagha!’” ");
INSERT INTO tpa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Anima mai Judea* ahi babada tayaha hi baibaiha po Yesu hita pani, babana hi haramanei da we ampariruvaruvana yana tauhi i babaniyehi, ma patara hi rovowehi, aubaina hi voterei ma hi nae. ");
INSERT INTO tpa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma muriyai mai Judea ahi babada, Pharisee* ma Herodian ghehauhi hi himirihi po vitaravirevirei Yesu hita ꞌwaroi. ");
INSERT INTO tpa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yana hi neꞌi Yesu auwarina ma hi riwa hipa, “Tauvihanahanapu, a haramanem tam ririwa vaimahim. Rava wavahi ghaeghaehi egha uta genowehi ma rava atapuhi emosina e rauwarowarorohi, ma Maimaituwa ana dewa moinana ei hanahanapuwei. Anina da takisi ta vimaihei mai Rome ahi guyau Caesar auwarina? Ta vimaiha bo havena?” ");
INSERT INTO tpa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ma Yesu ahi moru i inana tuhaghai po i paribeehi ipa, “Aiwa aubaina o raudadana po ona ꞌwaroꞌu, manena ona neiyaꞌi po a inanai.” ");
INSERT INTO tpa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Anima manena hi neiyaꞌi ma i raubayadehi ipa, “Ma we aiya tepana ma wavana?” Ma hi riwehi hipa, “Caesar.” ");
INSERT INTO tpa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Anima Yesu i riwehi ipa, “Caesar gharinei yana Caesar ona verei ma Maimaituwa gharinei yana Maimaituwa ona verei.” Ma hi amhunei. ");
INSERT INTO tpa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadducees hi riwa da hiraghe aumurina egha vomahirime, yana tauhi hi neꞌi po Yesu hi vitaravirevirei hipa, ");
INSERT INTO tpa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tauvihanahanapu, Moses raugagayo* i girumi ma i riwa, da rava ina hiraghe ma awana egha natuna, yana varehina hiwapena ina ravaghi po varehinana hirahiraghena aubaina rowarowa ina ghunihi. ");
INSERT INTO tpa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aubaina po mara emosi rava varevarehina maitehi maghauhi 7, tutuwogana i ravaghi po egha natunatuna ma i hiraghe. ");
INSERT INTO tpa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ma viruwaina hiwapena i ravaghi, po nanaꞌarena egha natuna ma i hiraghe. Wate varehina vitonuina auwarina dewana emosina i wawara. ");
INSERT INTO tpa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Anima atapuhina maghauhi 7 wavinena hi ravaghi, ma egha hita vinatuna ma hi hiraghe, ma aumurina yana wavinena i hiraghe. ");
INSERT INTO tpa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Maranai hiraghe aumurina atapuhi hina vomahirime, yana we wavinena apo aiya ina viꞌawanei?” ");
INSERT INTO tpa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu i riwehi ipa, “O verauboꞌa duma! Ma o haramanei aiwa aubaina? Babana aiwa Moses i girugirumiya ma Maimaituwa a kajijira egha ota haramanei. ");
INSERT INTO tpa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Maranai rava hirahiraghehi hina vomahirime, yana tauhi apo me aneya* au mara ma apegha hina tavine. ");
INSERT INTO tpa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma hirahiraghehi ahi vomahirime aubaina: ma egha meyanai Moses a au buka ota hiyavi, eyagi haburuna i araꞌarahi ma egha ita araigavuꞌarei riwana? Nahidana giruma i riwa da Maimaituwa Moses i riwei ipa, ‘Taꞌu yana Abraham a Maimaituwa, Isaac a Maimaituwa ma Jacob a Maimaituwa.’ ");
INSERT INTO tpa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","We babanihi auwarihiyei ta haramanei da Maimaituwa rava hirahiraghehi ma yawayawahanihi atapuhi e inainanahi yana yawayawahanihi. Taumi yana o verauboꞌa duma!” ");
INSERT INTO tpa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Raugagayo tauvihanahanapuweina i neꞌi ma hi pariꞌwayaꞌwaya i nonori. Ma i inana tuhaghai da Sadducees ahi raubayada Yesu i vimaihana vaimahiꞌeni, aubaina i ne po i raubayadei ipa, “Metauna raugagayona i gheduma ma apoma we maghamaghauhina?” ");
INSERT INTO tpa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma Yesu i paribeehi ipa, “‘Mai Israel ona nonori! Me raugagayona i gheduma yana wetaauna. Bada ata Maimaituwa yana tauꞌavana Bada. ");
INSERT INTO tpa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bada am Maimaituwa ma rauhogharei nuwanuwam taputapunei ma aruwamei am nuwatuhuwei ma am kajijira taputapunei.’ ");
INSERT INTO tpa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma viruwaina gheghedumana yana wetaauna. ‘Turam ma rauhogharei me tam u rauhogharanamem nanaꞌarena.’ Egha raugagayo* ghehauhi hita gheduma ma apoma we ruwaghahina.” ");
INSERT INTO tpa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tauvihanahanapuna Yesu i riwei, “Moina! Tauvihanahanapu, i ahi duma, riwa moinana maranai u riwa da Bada tauꞌavana yana Maimaituwa ma egha maimaituwa ghehauna tauna nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma Maimaituwa ta rauhogharei nuwanuwata taputapunei ma aruwataiyei ma ata nuwatuhuwei ma ata kajijira taputapunei, ma turata tana rauhogharei me ta rauhogharanameta nanaꞌarena. We raugagayohi ruwaghahi viponavowanahi i gheduma, ma apoma ghamoghamo au gahana apuꞌapunana, ma puyo* ghehauhi he amverenehi Maimaituwa auwarina.” ");
INSERT INTO tpa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Maranai Yesu i inanai da nuwahuyehuyei i paribeei yana i riwei ipa, “Maimaituwa a vitaniwaga vouna ana rava auwarihi,* ruinana tam auwarim yana egha ita davo.” Ma yamna aumurina egha aiya tepana ita tora po ita raubayadei. ");
INSERT INTO tpa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Maranai Yesu, Maimaituwa ana Numa* au ganahobena i hanahanapu yana i riwehi ipa, “Raugagayo tauvihanahanapuweina hi riwa da Maimaituwa a Vinevine Waiyawahanana* yana David natuna. Naꞌi moina ma we ona vinuwanuwatuhuwei: ");
INSERT INTO tpa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David Aruwa Vivireina a raitayatayahei i riwa ipa, ‘Maimaituwa aꞌu Bada auwarina ipa, ‘Au ahoꞌohohiꞌu ma tughutughura ma i nanapo am ghaviya a tereghaꞌirei po aem aurabena a terei.” ");
INSERT INTO tpa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ma we a au babanihi David tauꞌavana Maimaituwa a Vinevine i ghorei da ana ‘Bada.’ Ma apo menanaꞌarena ma Maimaituwa a Vinevine hina ghorei da David a umavou?” Ma patara ghaeghaena yana a kaohahi Yesu hi rautanighanei. ");
INSERT INTO tpa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Maranai Yesu i hanahanapu ipa, “Raugagayo tauvihanahanapuweina ona inana vaimahiꞌeni. Hi ghohe po gara davodavohi hina oteni ma rava naohiyei hina naenae, ma hinai ateꞌatehi ma hina vokaokaohei maranai he mahimahiri nae au maketi, ");
INSERT INTO tpa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ma hi ghohe po anitughura ahiꞌahina aniviꞌemosi au numahi ma au toreha he vinevinemeehi po rava ghaeghaehi ahi anitughura auwarina he tughutughura. ");
INSERT INTO tpa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ma moruwei hiwahiwape ahi numa he haroharohi, anima he raupari davodavoei po rava hina hunehi. Ma ahi bigo yana apo ina raꞌata duma!” ");
INSERT INTO tpa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu puyo* aniterenana auririvana i tughura Maimaituwa ana au Numa ma i iyaꞌiyau ma rava mane hi ampohei. Rava mahumahurahi maghamaghauhi mane maghamaghauhi hi ampohei, ");
INSERT INTO tpa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ma hiwape waiyamoyamonana i ne po mane muhomuhona ruwagha i raupohai. ");
INSERT INTO tpa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Aubaina a tauvotagho i ghorehi po hi neꞌi auwarina ma i riwa ipa, “Moina a ririwemi, we hiwapena waiyamoyamonana ana puyo i raupohaiya yana i raꞌata duma, ma apoma rava ghehauhi. ");
INSERT INTO tpa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Babana ghehauhi yana ahi mahura auwarina hi teretereriyeiya hi amverenei, ma we hiwapena a viyamoyamonei gharinei atapuna, ma a yawahana atapuna i amverenei.” ");
INSERT INTO tpa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu maranai Maimaituwa ana Numa* i vomahiri aharei, ma a tauvotagho emosi i ripa, “Tauvihanahanapu, ma inanai! We ghaꞌimahi hi ahi ghagha ma ghaeghaehiyei we numahi waiguyaunana hi vowai.” ");
INSERT INTO tpa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Yesu i paribeei ipa, “U inanai we numahi ghaeghaehina! Apo egha ghaꞌima emosi ana au gabu ina maꞌae, atapuna apo rava hina goruhi.” ");
INSERT INTO tpa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Maranai Yesu i tughutughura Oya Olive autepana, Maimaituwa ana Numa* ma autupo ghehauna, ma Peter, James, John ma Andrew, hi vaini po auririva ma hi raubayadei hipa, ");
INSERT INTO tpa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ma riweꞌai, meyanai we ginaurihi apo hina tupuwa, ma apo matakiraha aiwa a inanai da eighereghere po ina tupuwa?” ");
INSERT INTO tpa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma Yesu i riwehi ipa, “Ona inana vaimaiha po egha aiya ina rautayahaboꞌami. ");
INSERT INTO tpa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Rava magha apo wavaꞌuwei hina neꞌi ma hinapa, ‘Taꞌu yana tauna!’ Ma rava magha apo hina rautayahaboꞌahi. ");
INSERT INTO tpa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Egha nuwanuwami ina araꞌarayaguri maranai ghaviya tuyeghana o nonori po aughereghere bo auheiya. We dewahi yana apo hina tupuwa, ma yamna egha mara damona ita gheꞌeta. ");
INSERT INTO tpa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Dobu hina vitona vivira ma dam hina vitona vivira. Ma dobu ghehauhi apo yoyo ina ravihi ma wate gomara ina raꞌata. We dewahi yana me wavina duwaduwamana ana voavoa viuvana ei kare, ma muriyai apoꞌapoe dumana ina neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Taumi ona paꞌinameemi, apo ami ghaviya hina panimi ma hina amverenemi ani viꞌemosi numana babadahi auwarihi. Ma hina kwapumi aniviꞌemosi au numahi, ma oi tumaghaneꞌu aubaina dobu babadahi aunaohi ona mahiri ma hina hetaremi anima tuyegha ahiꞌahina ona rauguguyei auwarihi. ");
INSERT INTO tpa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma muriyai da damona ina neꞌi, yana aꞌu tauvotagho tuyeghaꞌu ahiꞌahina rava atapuhi auwarihi hina rauguguyei. ");
INSERT INTO tpa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma maranai hina panimi yana rauhetara auwarina egha onai nuwaboya da apo me ona vibabaninei. Na au marana aiwa i raugheꞌetei yana ona yatoni, babana aiwa e yatoyatoniya yana Aruwa Vivireinei ma egha taumiei. ");
INSERT INTO tpa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Rava varevarehihi hina amverenehi babada auwarihi po hina vihiraghenihi, ma ama apo natunatuhi auwarihi nanaꞌarena hina dewai, ma natunatu apo taughunihi hina vighaviyehi ma hina vihiraghenihi. ");
INSERT INTO tpa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma o votaghoꞌu aubaina apo rava atapuhi hina geduꞌaiemi, ma rava aiya ina maꞌe momota po au damona yana apo ina yawahana.” ");
INSERT INTO tpa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu i ripa, “Ginauri apoꞌapoe dumana apo ona inanai ina raugheꞌetei au dobu mepa egha ita rauinanaiyana. (Tauhiyava we bukana o hiyahiyavi ona vinuwanuwatuhuwana vaimahiꞌeni.) Anima au Judea taumaꞌae yana hina virovoiyana au oya. ");
INSERT INTO tpa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Rava aiya numa autepana egha ana hauga ina aharei, po ina hopu au numa ma ina rui po a nimapota aiwa ina vaini. ");
INSERT INTO tpa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Rava aiya au ꞌwapu, yana egha ana hauga ina aharei po ina wanavirai a au numa, po anirauhawawara ina vaini. ");
INSERT INTO tpa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","No haugahi yana apo hina apoꞌapoe duma waivine duwaduwamahi, ma waighughuhi auwarihi! ");
INSERT INTO tpa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ona raupari po ami rovo egha hauga apoꞌapoe ina wawara na au marana! ");
INSERT INTO tpa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Babana no haugahi yana apo hina apoꞌapoe duma, egha hauga ghehauna meyanai dobu we nanaꞌarena ita hanapuwei. Maranai au karena Maimaituwa dobu i viwawari ma i ne po we amadoꞌi. Wate apo eghaiwa ghehauna we nanaꞌarena ina tupuwame. ");
INSERT INTO tpa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma Bada we marana piripirina ina raitupoi, ma itapa eꞌegha, apo egha aiya ita maꞌamaꞌae. Ma ana rava aubaihi we marana i raitupoi. ");
INSERT INTO tpa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Anima na au marana aiya ina riwa inapa, ‘Ona inana, Keriso, Maimaituwa a Vinevine Waiyawahanana* wehidana!’ bo, ‘Ona inanai tauna nohidana!’ yana egha onai tumaghanei. ");
INSERT INTO tpa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Babana keriso waimorumoruhi, ma peroveta waimorumoruhi apo hina vomahiri. Apo matakiraha po ani amhuna hina vogheꞌetehi, po Maimaituwa ana rava vinevinehi hina rautayahaboꞌahi yamna inapa emoꞌemosina. ");
INSERT INTO tpa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Yamna aubaina ona inana vaimaiha! Muriyai po we dewahi hina tupuwa yana a ririwemi.” ");
INSERT INTO tpa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Anima Yesu ipa, “Piripiri apoꞌapoe dumahi aumurina ‘ginauri atapuhi kajikajijirahi au mara hina viguhuguhu. Madegha apo ina waguvarei ma nawaravi egha ina raraname, ma kipora aidamoei hina peꞌu.’ ");
INSERT INTO tpa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na au marana rava atapuhi hina inaꞌinana, ma Taꞌu Rava Natuna au hapau kajijira ma borumana maitehi ana neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Anima a aneya* ina himirihi dobu tupo wahepari po ana rava vinevinehi ina boinihimaꞌi dobu au mutuna po au mutuna.” ");
INSERT INTO tpa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Vihanahanapu kaiyaha auwarina tana vaini. Maranai raghana e raunabinabi po ruguruguna e tereterei, yana ta hanapuwei da raupupu ana mara e tutugheregherei. ");
INSERT INTO tpa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nanaꞌarena ona inanai ma we ginaurihi hina tuputupuwa, yana ona haramanei da Taꞌu Rava Natuna aꞌu nememeei ana mara i vighereghere we au mataꞌeta. ");
INSERT INTO tpa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Moina a ririwana dumemi, we hapana o mahimahiri apo yohora ona maꞌamaꞌae ma we dewahi ataphi apo hina wawara. ");
INSERT INTO tpa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mara ma dobu hina hamowa, ma ponaꞌu apo egha meyanai ina hamowa.” ");
INSERT INTO tpa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Egha aiya ita hanapuwei da metauna maratomna, bo mara aiwa apo ina neꞌi, aneya* au mara ma Natuna egha hita haramanei, ma Amana tauꞌavana. ");
INSERT INTO tpa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Onai raurauꞌona, ma onai mayavaivaina, babana egha ota haramanei mara aiwaꞌi apo na marana ina neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Aniꞌinana me rava ana numa i neꞌaharei ma a hewahewari i autanihi, po yamoha a bagibagi ina dewadewai, ma mataꞌeta taupaꞌinina i riwei po inai raurauꞌona. ");
INSERT INTO tpa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yamna aubaina onai raurauꞌona babana egha ota hanapuwei da numa taniwagana mara aiwa ina wanavirai. Mepapo aubigai bo waguvara aupouna, bo kamkam ina toutou au maratomtom bo madegha e gheꞌegheꞌeta. ");
INSERT INTO tpa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ona vononogha inapa ina raighohoghorimi, yana egha ina nehaghami da taumi o enoꞌeno. ");
INSERT INTO tpa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aiwa a ririwemi yana rava atapuhi auwarihi nanaꞌarena, onai raurauꞌona.” ");
INSERT INTO tpa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma marina yana maratom ruwagha aumurina da Verauvira* ma Payawa Egha Hahanana a Toreha.* Gudutaupuyoweina* ghaeghaehi ma raugagayo tauvihanahanapuweina, yana tayaha hi baibaiha po Yesu govagovaghanei hita pani ma hita vihiragheni ");
INSERT INTO tpa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ma hipa, “Egha toreha auhinenina ta dewadewai apo rava ata ghaviya hina vomahiri.” ");
INSERT INTO tpa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu yana au Bethany Simon a au numa, we ravana aunaona opina i paga ma i yawahana. Maranai Yesu i amꞌam ana au numa, ma wavine i neꞌi po oyohi jimujimumuna maihana ghaeghaena ana wava nard. We oyohina botorana auhinenina alabastei hi dewai, ma uwanaꞌava i gahi po Yesu au unuꞌununa i hiwaghi. ");
INSERT INTO tpa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma rava ghehauhi nahidana amohi i ghaighai po hi taraviravira hipa, “Aiwa aubaina po we oyohina i raukahiyarei? ");
INSERT INTO tpa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Apo emoꞌemosina hita gimarei po mane ghaeghaena hita vaini po rava waiyamoyamonahi hita verehi!” Anima hi eniboꞌai. ");
INSERT INTO tpa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ma Yesu ipa, “Ona votere aharei! Aiwa aubaina po o raiwenoi? Dewa ahiꞌahina auwariꞌu i dewai. ");
INSERT INTO tpa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Rava waiyamoyamonahi hauga davodavona apo maitehi ona maꞌae ma mara ghehauna ona ghohei, yana ona vohaguhi. Ma taꞌu yana apo mara haburunaꞌava ma apo a neꞌaharemi. ");
INSERT INTO tpa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Aiwa emoꞌemosina po ita dewadewai yana i dewai, oyohi au opiꞌu i terei yana mara muriyai ghuruvaꞌu aubaina i vononogheꞌu. ");
INSERT INTO tpa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Marina auwarimi aiwa ai babaniyei yana moina, dobu atapuna mepa tuyegha ahiꞌahina hi rauguguyei yana, we wavinena aiwa i dewadewaiya apo a rainuwaghana hina babaniyei.” ");
INSERT INTO tpa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Anima a tauvotagho 12, auhinenihi emosi wavana Judas Iscariot, i nae gudutaupuyoweina* ghaeghaehi auwarihi po Yesu ita vibenabenamei. ");
INSERT INTO tpa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma tauhi aiwa i ririweiya hi nonori yana hi kaoha, ma hi viꞌanina da mane hina verei. Ma Judas i vikare po gavogavo i baibaiha po Yesu ita amverenei auwarihi. ");
INSERT INTO tpa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mara i gheꞌeta po Payawa Egha Hahanana Torehana.* Ma maratom wainaona auwarina yana ahi mumuga po sipu yaubona hina vihiragheni Verauvira Torehana aubaina. Yesu a tauvotagho hi raubayadei hipa, “Mepa u ghoheꞌai po ana nae Verauvira amna aubaita a vovaimaihiꞌeni?” ");
INSERT INTO tpa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Anima Yesu a tauvotagho ruwagha i himirihi ma i parihanahanapuhi ipa, “Ona nae au Jerusalem ma oroto waira eꞌavaꞌavarai apo ina veraubeemi. Ma ona votaghoi. ");
INSERT INTO tpa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma numana e ruiyana taniwagana ona riwei onapa, ‘Tauvihanahanapu ipa, “Metauna hayana auwarina aꞌu tauvotagho maitehi apo Verauvira yamna ana ani?” ’ ");
INSERT INTO tpa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Anima apo haya ghaeghaena au banobanowa ina viꞌatataiyemi, aiwa atapuna yana anina. Ma nahidana aiwa atapuna ona nonoghei aubaita.” ");
INSERT INTO tpa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tauvotaghohi hi vomahiri po hi nae au Jerusalem, ma aiwa atapuna Yesu i ririweiya nanaꞌarena hi nehaghai, anima Verauvira amna hi vononoghei. ");
INSERT INTO tpa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Maranai au i biga, yana Yesu a tauvotagho 12 maitehi hi neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Maranai hi amꞌam yana Yesu i riwehi ipa, “A riwemi yana taumi emosi apo ina vibenabenameꞌu, tauna aiya maitemi a amꞌam.” ");
INSERT INTO tpa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","A tauvotagho hi nuwa apoꞌapoe ma hi vikare po emosi po emosi hi raubayada hipa, “Moina da taꞌu mai wavuꞌu? Ma a notanotai da egha taꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma i paribeehi ipa, “12 aupoumi tauna aiya aꞌi ruwagha aꞌi payawa au gaeba a raikabu gogoneiya. ");
INSERT INTO tpa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Taꞌu Rava Natuna apo a hiraghe, me Maimaituwa riwana aubaiꞌu hi girugirumiya ina rautaghoi. Aee! Ma vinuwaboyana iraꞌata ghagha na ravana aiya, Taꞌu Rava Natuna tauvibenabenameꞌu apo ina viꞌaroni! Itapa egha hita ghuni yana tauna aubaina apo ita ahi.” ");
INSERT INTO tpa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maranai hi amꞌam, ma Yesu payawa i vaini, po pariyei i viꞌamamara ma i vokabakabari, po i raughutei a tauvotagho auwarihi ma i riwa ipa, “Ona vaini po ona ani, weꞌi yana taꞌu viyowaꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Anima keyaka i vaini po i viꞌamamara ma i verehi, po atapuhi hi umei. ");
INSERT INTO tpa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma Yesu i riwa ipa, “Weꞌi yana taꞌu taraꞌu e wanawana hiwaghi yana rava maghamaghauhi ahi dewaboꞌa nuwaꞌaharenana aubaihi, taraꞌuweina Maimaituwa a vipiko ei raikajijirai. ");
INSERT INTO tpa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Moina a ririwemi, apo egha meyanai wine* a umameei da na au maratomna Maimaituwa a vitaniwaga vouna* auwarina wine vouna a umai.” ");
INSERT INTO tpa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Anima weya hi ravi ma aumurina hi hopu po hi nae au Oya Olive. ");
INSERT INTO tpa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu i riwa ipa, “Atapumina apo ona votereꞌu ma ona ruba ahareꞌu, babana Maimaituwa ponana hi girumi a au buka i riwa da Maimaituwa apo tauvipaꞌipaꞌi ina vihiragheni, ma sipu apo hina neyabayababa. Po atapumina apo ona rovo. ");
INSERT INTO tpa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ma muriyai apo a vomahirime, yana a ainae au Galilee ma ona neꞌi po ta viꞌemosi.” ");
INSERT INTO tpa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma Peter i paribeei ipa, “Taꞌu apo egha meyanai a voterem, havena po atapuhina hina dewai!” ");
INSERT INTO tpa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Yesu, Peter i riwei ipa, “A riwem muriyai po kamkam orotona mara ruwagha ina tou we waguvaraina, yana apo mara tonugha ma riwa da egha uta haramaneꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Apoma Peter paribeeyana kajikajijirana i terei ipa, “Apegha meyana a boviyem, mepapo inapa tam ma taꞌu ta hiraghe!” Anima a tauvotagho atapuhi riwana emosina hi yatoni. ");
INSERT INTO tpa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu, a tauvotagho maitehi hi ne au Gethsemane ma i riwehi ipa, “Wehidana ona maꞌamaꞌae, maranai taꞌu a raaupari.” ");
INSERT INTO tpa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Anima Peter, James ma John i taravainihi. Ma naꞌi yana nuwaboya ma viuva i gheraghoni, ");
INSERT INTO tpa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","aubaina i riwehi ipa, “Nuwaviuva au ateꞌu i raꞌata duma po aughereghere ina raumutuꞌu. Wehidana ona maꞌae ma ona iyaꞌiyau.” ");
INSERT INTO tpa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Anima mara haburuna i veraunae ma i aharemei au dowa, ma i raupari da inapa emoꞌemosina yana viuvana ana mara ina honagha aharei. ");
INSERT INTO tpa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma Yesu i raupari ma ipa, “Amaꞌu! Amaꞌu! Ginauri atapuna auwarim yana emoꞌemosina. Wate we viuvana keyakana auwariꞌu ma vaina aharei. Ma am rauhoghara ma dewai ma egha taꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ma Yesu i wanavirai yana a tauvotagho tonugha i nehaghai hi enoꞌeno. Po Peter i riwei ipa, “Simon, we tam e enoꞌeno? Egha emoꞌemosina po matam ita kaya, ma uta vomaꞌae mara haburuna?” ");
INSERT INTO tpa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma i riwehi ipa, “Ona iyaꞌiyau ma ona raupari, po egha raudadana auhinenina ona peꞌu. Aruwa ei anina, ma viyowa i tapiya.” ");
INSERT INTO tpa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Wate mara viruwaina i naeme po i raaupari, yana babanihi emosihina i hiyavihi. ");
INSERT INTO tpa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Anima i nememe a tauvotagho auwarihi po i nehaghahi yana hi raunuwavuru; ma egha emoꞌemosina po matahi ita kaya. Yamna aubaina egha hita haramanei da auwarina aiwa hina riwei. ");
INSERT INTO tpa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Maranai mara vitonuina i nememeꞌi, yana i riwehi ipa, “We taumi yohora o enoꞌeno ma oi yagohina? Anina! Mara i gheꞌeta. Ona inanai marina yana boiboghi taꞌu, Rava Natuna, hina amvereneꞌu taudewaboꞌa ahi au kajijira. ");
INSERT INTO tpa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ona vomahiri, ma tana nae! Ona inanai ravana tauvibenabenameꞌu i gheꞌeta!” ");
INSERT INTO tpa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu yohora i babani maranai a tauvotagho emosi 12 auhinenihi Judas i gheꞌeta. Ma boru maitehi a apiyahi naipi mena ruwaruwagha ma dabaruma maitehi. Tauhi yana gudutaupuyoweina* ghaeghaehi, raugagayo tauvihanahanapuweina ma babada hi himirihi po Judas maitena hi nae. ");
INSERT INTO tpa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tauvibenabenamna boiboghi matakiraha ravahi boruhi i verehi ipa, “Ravana naona a yaghoyaghoniya tauna o ghohei. Ona pani yana ona vomomohi po maiteni ona nae.” ");
INSERT INTO tpa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Maranai Judas i gheꞌegheꞌeta yana yaghiyaghinaꞌava i ghae Yesu auwarina ma ipa, “Tauvihanahanapu!” ma naona i yaghoni. ");
INSERT INTO tpa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yamna aubaina ma Yesu hi vomomohi po hi panipani. ");
INSERT INTO tpa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ma nahidana turahi ghehauna i mahimahiri naipi mena ruwaruwagha i sinahori yana Gudutaupuyoweina Gheghetehaharana a taupaura tanighana i tarautuini. ");
INSERT INTO tpa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","49","Ma Yesu i riwehi ipa, “Mara maghamaghauna taꞌu maitemi Maimaituwa a au Numa ai hanahanapu! Ma aiwa aubaina egha ota paniꞌu? Ma egha itapa naipi mena ruwaruwagha ma dabaruma maitehi, ona neꞌi po ona paniꞌu me taꞌu raugagayo tauraugahina! Ma we o dewai yana Maimaituwa ana riwa au buka hi girugirumiya ina raimoinai.” ");
INSERT INTO tpa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Anima a tauvotagho atapuhi hi voterei ma hi ruba aharei. ");
INSERT INTO tpa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hewari anirauhawawara i oteni, ma Yesu i muritaghoi ipa hina pani, ");
INSERT INTO tpa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ma ana anirauhawawaraꞌava hi sinagagi po aumurina, ma akanakopana i ruba po i neꞌaharehi. ");
INSERT INTO tpa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yesu hi taravaina naiyei Gudutaupuyoweina* Gheghetehaharana ana au numa, mepa gudutaupuyoweina ghaeghaehi, babada ma raugagayo tauvihanahanapuweina hi emosiyana. ");
INSERT INTO tpa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter i vimuritagho po heiyei ma i ruighae Gudutaupuyoweina Gheghetehaharana a animaꞌae waigarina auhinenina. Nahidana eyagi araꞌaratana auririvana i tughura, ma tauvipaꞌipaꞌi maitehi i rarana. ");
INSERT INTO tpa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Numa auhinenina gudutaupuyoweina ghaeghaehi ma Tauviꞌogatara* atapuhi Yesu a dewaboꞌa hi baibaihei po wavu hita verei ma hita vihiragheni, ma egha aiwa hita nehaghai. ");
INSERT INTO tpa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tauviwavu maghamaghauhi hi neꞌi po Yesu hi vibabanimoruwei hi verei, ma ahi babani egha ita viꞌaroni. ");
INSERT INTO tpa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anima rava ghehauhi hi vomahiri po ahi moruwei Yesu hi viwavui. Ma hipa, ");
INSERT INTO tpa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“A nonori i ririwa ipa, ‘Apo we Maimaituwa a Numana rava nimahiyei hi vowavowaiya a goruhi, ma maratom tonugha aumurina ma apo vouna a vowai, egha me rava nimahiyei hi vowavowaiya nanaꞌarena.’” ");
INSERT INTO tpa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wate egha ahi dede hita dewai po ita viꞌarona dadani. ");
INSERT INTO tpa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Anima Gudutaupuyoweina Gheghetehaharana atapuhi aunaohi i vomahiri po Yesu i vitaravirevirei ipa, “We dewaboꞌana aubaina hei wavum ma egha am aniparibeeyana ghehauna aiwaꞌi?” ");
INSERT INTO tpa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wate Yesu i vogenuwana ma egha babani emosi ita yatoni. Ma Gudutaupuyoweina Gheghetehaharana i raubayadanameei ipa, “Moina tam Maimaituwa a Vinevine Waiyawahanana,* Maimaituwa Waiꞌahiꞌahinana Natuna?” ");
INSERT INTO tpa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu i paribeei ipa, “E taꞌu, ma apo ona inanai taꞌu Rava Natuna a tughura, Manimaninina au ahoꞌohohina, ma apo a neneꞌi marei a hapauꞌu!” ");
INSERT INTO tpa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nahidana Gudutaupuyoweina Gheghetehaharana ana kwama i roroi ma ipa, “Egha viwavu maghamaghauna tata ghoheghohei! ");
INSERT INTO tpa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aita o nonori, i riwa da tauna yana Maimaituwa maitena emoꞌemosihi. Ma ami vikaha menanaꞌarena?” Atapuhi hi amvine po tauna yana wavu i vaini aubaina po anina da hina vihiragheni. ");
INSERT INTO tpa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Anima ghehauhi hi vikare po hi hovahovai, ma matana hi raghitapupui, ma nimahiyei hi raviravi ma hi ririwei hipa, “Mepada tam peroveta yana ma riweꞌai aiya i ravim.” Anima tauvipaꞌipaꞌi hi naiyei po hi raunavanavai. ");
INSERT INTO tpa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Na marana emosina auwarina Peter yohora animaꞌae waigarina auhinenina, ma Gudutaupuyoweina* Gheghetehaharana a taupaura wavinena ghehauna i neꞌi. ");
INSERT INTO tpa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma maranai Peter i inanai i rarana, yana i inana tunutunui ma ipa, “We tam maitem yana Yesu Nazarethei a tauvotagho.” ");
INSERT INTO tpa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma i boviyei ipa, “Egha ata hanapuwei wate au nuwanuwaꞌu egha ita raughadaghadari, da tam aiwa ei babaniyei,” ma i hopu po i nae gari au mataꞌetana anima kamkam i tou. ");
INSERT INTO tpa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Anima taupaurana wavinena i inanai yana taumahiri i riwanamehi ipa, “We ravana yana a tauvotagho ghehauna.” ");
INSERT INTO tpa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Anima Peter i bovime, ma mara haburuna ma nahidana, taumahiri hi viwavumeei hipa, “Moina dumana, tam yana a tauvotagho ghehauna, wate tam yana Galileeyei.” ");
INSERT INTO tpa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ma i vomahiri po ipa, “Aꞌu gwara amata moina a ririwa duma! Na ravana o deedeiya taꞌu egha ata hanapuwei! Inapa a morumoru yana anina da Maimaituwa ina kovoghiꞌu.” ");
INSERT INTO tpa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma nahidana yana kamkam mara viruwaina i tou, ma Yesu, Peter auwarina aiwa i ririweiya nuwanei i ghae ipa, “Muriyai po kamkam mara ruwagha ina tou, yana apo tam mara tonugha ma boviyeꞌu da egha uta hanapuweꞌu.” Anima i notai po nuwanuwana i tou hapuwei. ");
INSERT INTO tpa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Hubahubanai boiboghi gudutaupuyoweina* ghaeghaehi, babada maitehi ma raugagayo tauvihanahanapuweina ma Tauviꞌogatara* atapuhi hi viꞌogatara. Ma hi viꞌanina po tauvighaviya Yesu hi panipani ma hi naiyei, po hi amverenei Pilate auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma i raubayadei ipa, “Tam mai Judea* ahi Guyau?” Ma Yesu i paribeei ipa, “Ee, tam aiwa u ririweiya nanaꞌarena.” ");
INSERT INTO tpa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma gudutaupuyoweina ghaeghaehi wavu maghamagha Yesu hi verei. ");
INSERT INTO tpa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Yamna aubaina Pilate i raubayadanameei ipa, “Apo ma amparibeeyana bo eꞌegha? U inanai wavu maghamagha he vereverem.” ");
INSERT INTO tpa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ma Yesu gamona i pota, yamna aubaina Pilate i amhuna duma. ");
INSERT INTO tpa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Borima emosi emosi auhinenina Verauvira Torehana* marana, yana Pilate a mumuga po rava emosi paniyei e oheꞌohei rava ahi rauhogharei. ");
INSERT INTO tpa_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma na au marana yana rava emosi wavana Barabbas yana au deri, tauna mai Rome* ahi taniwaga tauvighaviyeina maitehi, hi amtaraihoghara po hi vihiraghena ma hi panihi. ");
INSERT INTO tpa_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ma rava maghamaghauhi hi neꞌi po Pilate hi vibaghai po aiwa aubaihi ita dewai, me mara maghamaghauna i dewadewaiya nanaꞌarena. ");
INSERT INTO tpa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Pilate i raubayadehi ipa, “O ghoheꞌu po mai Judea* ahi Guyau a ohei?” ");
INSERT INTO tpa_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ma i hanapuwana dumei da gudutaupuyoweina* ghaeghaehi, Yesu hi unurei aubaina hi amverenei auwarina. ");
INSERT INTO tpa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ma gudutaupuyoweina ghaeghaehi yana rava maghamaghauhi hi raihunahi, po Pilate Barabbas ita ohei. ");
INSERT INTO tpa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Anima Pilate i raubayadanameehi ipa, “We ravana Yesu, o ririwa da tauna mai Judea ahi Guyau, aiwa o ghoheghoheꞌu po auwarina a dewai?” ");
INSERT INTO tpa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma hi vighorenaeme hipa, “Ma tuparatui!” ");
INSERT INTO tpa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Pilate i raubayadehi ipa, “Aiwa aubaina! Aiwa i dewa boꞌai?” Ma hi otuꞌotu ghirighiriyana ma hipa, “Ma tuparatui!” ");
INSERT INTO tpa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Pilate i ghohei da rava maghamaghauhi ita raikaohahi, aubaina Barabbas i ohei aubaihi. Anima tauvighaviya i riwehi po Yesu hi kwapui, ma hi taravaina naiyei tuparatuna aubaina. ");
INSERT INTO tpa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tauvighaviya Yesu hi taravaina ruiyei, taniwaga Pilate a animaꞌae waigarina auhinenina, anima tauvighaviya atapuhi hi ghoreboinihi. ");
INSERT INTO tpa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gara waipiyopiyovina hi viꞌoteni me guyau, ma ghoroghorova waidonadonana hi viri po me kunuteiya ma hi viꞌoteni. ");
INSERT INTO tpa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Anima hi vikare po vijiboghei hi ateꞌatei, ma nimahi hi vohepai ma hipa, “A tarahiyauwem mai Judea* ahi Guyau ma maꞌevavahagha.” ");
INSERT INTO tpa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kwapuwei unuꞌununa hi raviravi ma hi hovahovai, ma aunaona aetutuhiyei hi raupari ma vijiboghei hi rauduneei. ");
INSERT INTO tpa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Maranai hi vijibogha vorovei yana garana waipiyopiyovina hi gagi, ma gara gharinei hi viꞌotenameei, ma hi taravaina naiyei tuparatuna aubaina. ");
INSERT INTO tpa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Au tayaha rava Cyreniyei wavana Simon, Alexander ma Rufus amahi, ꞌwapuwei i neneꞌi ma tauvighaviya hi hegari, po Yesu a korosi iꞌavarai. ");
INSERT INTO tpa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dobu ana wava Golgotha nahidana hi naiyei, anona yana Unu Tetetena. ");
INSERT INTO tpa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma hi raudadana po wine,* mer maiteni viravirana hi verei ma umana i geduꞌaiyei. ");
INSERT INTO tpa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Anima hi tuparatui ma ana gara aubaina aupouhi hiyavei hi vikayokayo, po hita inanai aiya apo metauna ghutana ita vaini. ");
INSERT INTO tpa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Na madeghana yana maratomtom, ahubena ma ausiporina ma hi tuparatui. ");
INSERT INTO tpa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma hi wavuiya tuyeghana hi tuturatui au korosi, girumana ipa: “Mai Judea* ahi Guyau”. ");
INSERT INTO tpa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Anima taudanene ruwagha Yesu maitena hi tuparatuhi, emosi au ahoꞌohohina ma ghehauna au ahokehana. ");
INSERT INTO tpa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ma aiwa hi dewadewaiya yana peroveta ponana i raimoinai ipa, “Hina inanai yana tauna me taudewaboꞌa.” ");
INSERT INTO tpa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rava hi nae ma hi neꞌi ma unuꞌunuhi hi kwajikwajiyei ma hi jiboghi hipa, “Habe tam upa Maimaituwa ana Numa* ma goruhi ma maratom tonugha aumurina ma vowameei. ");
INSERT INTO tpa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Habe marina ma hagumeem po korosiyei ma hopuꞌi!” ");
INSERT INTO tpa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Wate nanaꞌarena gudutaupuyoweina* ghaeghaehi ma raugagayo tauvihanahanapuweina aupouhi hi jibogha vivira hipa, “Rava ghehauhi i viyawahanihi ma apegha emoꞌemosina po tauna ina hagumei. ");
INSERT INTO tpa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Habe we Kerisona Maimaituwa a Vinevine Waiyawahanana,* mai Israel ahi Guyauna, marina korosiyei ina hopuꞌi, po ta inana ma ta vitumaghanei.” Ma na taudanenehi Yesu maiteni hi tupatuparatuhi wate hi jiboghi. ");
INSERT INTO tpa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Maranai madegha au unuborita, yana taraiwaguvara ghaeghaena dobu i puruyaghohi, ma i nae po ahubenai ma aubigai ausiporina. ");
INSERT INTO tpa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma na madeghana au damona yana Yesu ponana i raꞌata ma i taraghabara ipa, “Eloi, Eloi lama sabatani?” Anona yana, “Aꞌu Maimaituwa, Aꞌu Maimaituwa, aiwa aubaina u votere ahareꞌu?” ");
INSERT INTO tpa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Maranai rava taumahiri hi nonori yana hipa, “Ona nonori Elijah e ghoreghorei.” ");
INSERT INTO tpa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma rava ghehauna i ruba po gara hogihogirana i vaini, po wine* waighorana auwarina i raitowai, ma au kwapu i terei ma i viyoyo ghaiyei Yesu au ipirina, po ita umai, ma ipa, “Marina ta voterei ma ta iyauwei, mepapo Elijah ina neꞌi po korosiyei ina tere hopunei.” ");
INSERT INTO tpa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma Yesu ghaeghaenaꞌava i taraghabara ma i hiraghe. ");
INSERT INTO tpa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma Maimaituwa ana Numa* auhinenina aniraughaghara garana autepana ma i wanawanatevaiya, yana i hopu po aurabena ma i rauruwaghei. ");
INSERT INTO tpa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nahidana mai Rome* ahi tauvighaviya badana i mahimahiri Yesu aunaona, yana i inanai me i hiraghenei. Yamna aubaina ipa, “Moina dumana we ravana yana Maimaituwa Natuna!” ");
INSERT INTO tpa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nahidana waivine auririva hi mahiri ma hi iyaꞌiyau. Auhinenihi yana Mary Magdalene ma Mary tauna yana James haburuna ma Joses ayohi, ma Salome. ");
INSERT INTO tpa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Maranai tauna au Galilee yana hi muritagho naiyei, ma a rauhoghara hi dewadewai, ma waivine maghamaghauhi maitena hi ghegheꞌi au Jerusalem yana wate tauhi nahidana. ");
INSERT INTO tpa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma nahidana yana rava Arimathiyei ana wava Joseph yana Tauviꞌogatara emosi, wate tauna yana aniviꞌateꞌate, ma Maimaituwa a vitaniwaga vouna* i paꞌipaꞌiyei. Ma we marana yana madegha i yoriyori ma vovaimaiha marana i kwahakwaha, ma viyagohina maratomna i tutugheregherei, aubaina a tepamahirina ma i nae po Pilate i vibaghai Yesu tupuwana aubaina. ");
INSERT INTO tpa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma Pilate yana i ghohori maranai i nonori da Yesu i hiraghe, aubaina tauvighaviya ahi bada i ghorei po i raubayadei da Yesu boiboghi i hiraghe bo eꞌegha. ");
INSERT INTO tpa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Maranai tauvighaviya ahi bada auwarina i nonori da moina, yana Yesu tupuwana Joseph auwarina i viꞌaninei. ");
INSERT INTO tpa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Po Joseph gara wakewakekena i gimarai, ma Yesu tupuwana hi tere hopunei, yana gareina hi humai ma au kokowaga* hi terei. Ma ghaꞌima hi tahiruiyei po me duyuwa auhinenina hi terei. Anima ghaꞌima ghaeghaena hi vitovitovirei po mataꞌetana hi rautomeni. ");
INSERT INTO tpa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene ma Mary, Joses ayona, yana mepa Yesu tupuwana hi enoiya yana hi inanai. ");
INSERT INTO tpa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Maranai viyagohina maratomna* i verauvira, yana Mary Magdalene ma Mary, James ayona, ma Salome, oyohi jimujimumuna hi gimarai po Yesu au tupuwana hita mutui. ");
INSERT INTO tpa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma Sande hubahubanai boiboghi yana hi naenae au kokowaga.* ");
INSERT INTO tpa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma hi raubayadanameehi hipa, “Apo aiya ghaꞌimana au mataꞌeta ina vitovira riyei aubaita?” ");
INSERT INTO tpa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma hita rauꞌiyau ghae yana ghaꞌimana ghaeghaenana boiboghi hi vitovira riyei. ");
INSERT INTO tpa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eghabaine anima hi rui kokowaga auhinenina ma hewari vouna gara wakewakekena i oteni ma au ahoꞌohohihi i tughutughura ma hi tughohorei. ");
INSERT INTO tpa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma nahidana i riwehi ipa, “Egha ona ghohoghohorimi! Taumi yana Yesu Nazarethei hi tupatuparatuiya o baibaihei. Tauna yana egha wehidana! Boiboghi i vomahirime. O inanai, wehidana tupuwana hi viꞌenoi. ");
INSERT INTO tpa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ma ona nae po a tauvotagho ma wate Peter maiteni ona riwehi onapa, “Tauna yana i aitayaha po e naenae au Galilee. Nahidana apo Yesu ona inanai me rorova i ririwemi nanaꞌarena.” ");
INSERT INTO tpa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma maranai we hi nonori yana kokowagei hi hopu, po hi rubaruba yana a tatavahi ma hi vinuwanaina, aubaina au tayaha egha aiya aiwa ghehauna hita riwei babana hi rovo. ");
INSERT INTO tpa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sande hubahubana boiboghi maranai Yesu hiragheei i vomahirime, yana Mary Magdalene auwarina i ai hegha. Na Maryna yana aunaona auwarina aruwa apoꞌapoehi 7 i raukaiwenihi. ");
INSERT INTO tpa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","I nae po a tauvotagho hi nuwaboya ma hi toutou ma i pariverehi aiwa i tuputupuwa. ");
INSERT INTO tpa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma maranai hi nonori da Yesu i vomahirime ma tauna i inanai, yana egha hita vitumaghanei. ");
INSERT INTO tpa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma muriyai, Yesu a tauvotagho ruwagha Jerusalemei hi hopu po tayahei hi naenae, ma auwarihi ana hegha yana inana tapuna. Yamna aubaina ma egha hita inana tuhaghai. ");
INSERT INTO tpa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma maranai hi inana tuhaghai yana hi wanavirahi po ahi rava ghehauhi hi pariverehi, wate egha hita vitumaghanehi. ");
INSERT INTO tpa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma muriya dumai, Yesu a tauvotagho 11 hi amꞌam ma auwarihi i hegha. Po i enihi babana a vomahirime aumurina tauꞌinanaina yana egha hita vitumaghanehi,* ma nuwanuwahi i toghara. ");
INSERT INTO tpa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma i riwehi ipa, “Ona hopu po ona nae dobu atapuna auwarina, ma rava atapuhi auwarihi po tuyeghaꞌu ahiꞌahina ona rauguguyei. ");
INSERT INTO tpa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma rava aiya i vitumaghana po i babataito* yana apo ina yawahana, ma aiya egha itai tumaghana yana raibahibahi ina viꞌaroni. ");
INSERT INTO tpa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tauvitumaghana apo manini a verehi po matakiraha hina vogheꞌetehi. Ma wavaꞌuwei apo aruwa apoꞌapoehi hina raugagihi, ma apo pona vouhi hina vibabaniyehi. ");
INSERT INTO tpa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Apo mota nimahiyei hina vohepai ma waꞌiyawa ani hiraghe hina umai yana apo egha viuva ina verehi. Ma rava doridoriꞌahi hina votepanihi yana apo kamnahi ina ahi.” ");
INSERT INTO tpa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bada Yesu, i vibabani a tauvotagho auwarihi po aumurina, ma i vohepa po i ghae au mara, po Maimaituwa au ahoꞌohohina i tughura. ");
INSERT INTO tpa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Anima a tauvotagho dobu dobuwai hi nae ma tuyeghana ahiꞌahina hi rauguguyei. Ma Bada maiteni i bagibagihi ma i vohaguhi po a maniniyei, dewa anivinuwanaina hi dewadewahi ma au ponahi rava hi inainana yana hipa moina. ");
ALTER TABLE tpa_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
