﻿USE sofia;
DROP TABLE IF EXISTS sofia.tosNT_vpl;
CREATE TABLE tosNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tosNT_vpl WRITE;
INSERT INTO tosNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yuma̱ c-tatzoknú̱n tatzoktahuilani̱t xtucuhuinicán pacs la̱ntla̱ mi̱nti̱lhachá̱ xquilhtzucut Quimpu̱chinacán Jesucristo. Huá̱ ma̱lacatzúqui̱lh xamaka̱n Abraham, chu̱ rey David na̱ cha̱tum xquilhtzúcut tihua̱. ");
INSERT INTO tosNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Yama̱ ko̱lutzi̱n Abraham xuí̱ cha̱tum xkahuasa hua̱nti̱ xuanicán Isaac, chi̱nchu̱ xkahuasa Isaac xuanicán Jacob, chi̱nchu̱ xkahuasa Jacob xuanicán Judá ma̱squi na̱ xkalhi̱ko̱y tanuj xlakkahuasán. ");
INSERT INTO tosNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Xlakkahuasan Judá xuaniko̱cán Fares chu̱ Zara, xtzicán xuanicán Tamar. Xapuxcu xkahuasa Fares xuanicán Esrom. Xkahuasa Esrom xuanicán Aram. ");
INSERT INTO tosNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Xkahuasa Aram xuanicán Aminadab. Xkahuasa Aminadab xuanicán Naasón. Xkahuasa Naasón xuanicán Salmón. ");
INSERT INTO tosNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Xkahuasa Salmón xuanicán Booz (xtzi xuanicán Rut). Xkahuasa Booz xuanicán Obed. Xkahuasa Obed xuanicán Isaí. ");
INSERT INTO tosNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Xkahuasa Isaí xuanicán David hua̱nti̱ acxni̱ Rey xuani̱t xlá̱ tita̱tahui̱ hua̱nti̱ xpusca̱t xuani̱t Urías, chu̱ chuná̱ tilacáchilh cha̱tum xkahuasacán hua̱nti̱ xuanicán Salomón. ");
INSERT INTO tosNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Xkahuasa Salomón xuanicán Roboam. Xkahuasa Roboam xuanicán Abías. Xkahuasa Abías xuanicán Asá. ");
INSERT INTO tosNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Xkahuasa Asá xuanicán Josafat. Xkahuasa Josafat xuanicán Joram. Xkahuasa Joram xuanicán Uzías. ");
INSERT INTO tosNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Xkahuasa Uzías xuanicán Jotam. Xkahuasa Jotam xuanicán Acaz. Xkahuasa Acaz xuanicán Ezequías. ");
INSERT INTO tosNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Xkahuasa Ezequías xuanicán Manasés. Xkahuasa Manasés xuanicán Amón. Xkahuasa Amón xuanicán Josías. ");
INSERT INTO tosNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Xkahuasa Josías xuanicán Jeconías ma̱squi xkalhi̱ko̱y tanuj xlakkahuasán. Xlacán xlama̱kó̱ acxnitiyá̱ yama̱ xamaka̱n quilhtamacú̱ acxni̱ xamaká̱n tichi̱le̱nko̱ca̱ xta̱chuná̱ la̱ntla̱ tachí̱n laqui̱mpi̱ antá̱ nascujko̱ya̱chá̱ israelitas c-xaca̱chiqui̱n Babilonia. ");
INSERT INTO tosNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ali̱sta̱lh acxni̱ israelitas xtaspitpalako̱ni̱t c-xtiyatcán tilacáchilh cha̱tum xkahuasa Jeconías hua̱nti̱ xuanicán Salatiel. Chi̱nchu̱ xkahuasa Salatiel xuanicán Zorobabel. ");
INSERT INTO tosNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Xkahuasa Zorababel xuanicán Abiud. Xkahuasa Abiud xuanicán Eliaquim. Xkahuasa Eliaquim xuanicán Azor, ");
INSERT INTO tosNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Xkahuasa Azor xuanicán Sadoc. Xkahuasa Sadoc xuanicán Aquim. Xkahuasa Aquim xuanicán Eliud. ");
INSERT INTO tosNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Xkahuasa Eliud xuanicán Eleazar. Xkahuasa Eleazar xuanicán Matán. Xkahuasa Matán xuanicán Jacob. ");
INSERT INTO tosNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Xkahuasa Jacob xuanicán José. Pus huá̱ chú̱ yuma̱ José hua̱nti̱ tita̱tapu̱chúhualh María hua̱nti̱ tima̱lakatuncúhui̱lh Jesús hua̱nti̱ a̱li̱sta̱lh na̱ li̱ma̱pa̱cuhui̱ca̱ Cristo sa̱mpi̱ yuma̱ tachihuí̱n Cristo c-xatachihui̱n hebreo huanicán “ma̱akapu̱taxti̱ná.” ");
INSERT INTO tosNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chuná̱ pi̱ hua̱ la̱ntla̱ tilácstacli̱ quilhacatunu tastacni̱ la̱ntla̱ li̱macatzucuy c-xtalatama̱n Abraham hasta acxni̱ tilacáchilh rey David, quilhaccu̱ta̱ti tastacni̱ xli̱pacs; chu̱ la̱ntla̱ li̱quilhtzucuy c-xtalatama̱n David hasta acxni̱ israelitas tachí̱n tile̱nko̱ca̱ c-Babilonia, akcu̱ta̱ti quilhtzúcut xli̱pacs; na̱ chuna li̱tum tilacstacpalako̱lh quilhaccu̱ta̱ti tastacni̱ hasta acxni̱ tilacáchilh Cristo, akcu̱ta̱ti quilhtzúcut xli̱pacs. ");
INSERT INTO tosNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Hua̱ xtalacachin Jesucristo, chuna̱ na̱má̱ tílalh: Hua̱ xtzi tihua̱ María, hua̱nti̱ xli̱ta̱tahuilat José, acxni̱ ni̱ xa̱la̱ta̱tahuilay, chu̱ ni̱ naj huá̱ xta̱tapaksi̱y José, xtacatzi̱y pi̱ nia̱lh xacstu xlama̱ María, hua̱mpi̱ hua̱ xlá̱ xli̱tlihuaka Espíritu Santo hua̱nti̱ chuná̱ xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José luhua tla̱n chixcú xuani̱t, pus acxni̱ cátzi̱lh pi̱ xli̱ta̱tahuilat María nia̱lh xacstu xlama̱, ni̱ ma̱laksiyupútulh xpa̱lacata̱ pi̱ ni̱ nama̱ma̱xani̱y, huata xlá̱ caj tze̱k xmakaxtakputún laqui̱mpi̱ chuná̱ chú̱ nalactlahuay xtachihuí̱n ni̱ma̱ xqui̱ma̱lacnu̱ni̱t c-xchic xtasquín. ");
INSERT INTO tosNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Luhua acxni̱ chuná̱ xlacapa̱stacma̱, titasiyúnilh cha̱tum xángel Quimpu̱chinacán c-xca̱tama̱nixni, huánilh: “José, xcam xamaka̱n rey David, ni̱ cali̱ma̱xánanti̱ nali̱pina̱ María c-mínchic, chu̱ mimpusca̱t natlahuaya. Sa̱mpi̱ yama̱ skata̱ hua̱ntu̱ xlá̱ kalhkalhi̱ma̱, huá̱ xli̱tlihuaka Espíritu Santo chuná̱ tlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Acxni̱ chú̱ nama̱chixcuhui̱li̱y actzu̱ kahuasa, huix nali̱ma̱pa̱cuhui̱ya̱ Jesús. Hua̱ xlá̱ chuná̱ nali̱huanicán sa̱mpi̱ nama̱laktaxti̱ko̱y xnata̱chiqui̱n israelitas la̱ntla̱ nama̱laksputuniko̱y xtala̱kalhi̱ncán.” ");
INSERT INTO tosNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hua̱ chuná̱ li̱akspúlalh xli̱pacs yumá̱ laqui̱mpi̱ María nama̱kantaxti̱y xtachihui̱n Dios hua̱ntu̱ xamaka̱n tima̱puhuá̱ni̱lh xprofeta Isaías natzoka̱ c-xlibro̱ acxni̱ na̱má̱ huá̱: ");
INSERT INTO tosNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Cha̱tum tzuma̱t hua̱nti̱ ni̱ a̱ta̱tapaksi̱y chixcú, chú̱ nia̱lh xacstu lama̱, sa̱mpi̱ nama̱lakatuncuhui̱y cha̱tum skata; xlá̱ nali̱ma̱pa̱cuhui̱cán Emanuel” (sa̱mpi̱ yama̱ tachihuí̱n “Emanuel” c-xatachihui̱n hebreo huamputún “Dios quinca̱ta̱lamá̱n”). ");
INSERT INTO tosNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cha̱nchu̱ acxni̱ José lakastakuánalh la̱ntla̱ xma̱nixnama̱, pus chuná̱ xlá̱ tláhualh hua̱ la̱ntla̱ xli̱ma̱paksi̱ni̱t xángel Quimpu̱chinacán, tita̱tahui̱ xpusca̱t titláhualh. ");
INSERT INTO tosNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hua̱mpi niucxnicú ta̱tapáksi̱lh la̱ntla̱ xta̱hui̱ hasta ni̱li̱huaya̱ tima̱chixcuhuí̱li̱lh tama̱ actzu̱ xkahuasa, na̱ Jesús tihuilí̱nilh xtucuhuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tilacáchilh Jesús c-aktum actzu̱ ca̱chiquí̱n huanicán Belén c-xtama̱paksi̱n Judea acxni̱ xli̱hui̱ xli̱ma̱paksi̱ná̱ rey Herodes. Ni̱ maka̱s quilhtamacú̱ tichinko̱lh c-xaca̱chiqui̱n Jerusalén makapitzi̱n acastaca̱n chixcuhuí̱n xtaca̱xko̱ni̱tanchá̱ c-aktum makat tíyat pakán c-xli̱pulhni. ");
INSERT INTO tosNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xlacán chuná̱ xkalhasquini̱nama̱kó̱: —¿Ní̱ chu̱ huí̱ yama̱ actzu̱ Rey hua̱nti̱ la̱nchú̱ lacachini̱t laqui̱mpi̱ xlá̱ natzucuyá̱n ca̱ma̱paksi̱yá̱n huixín judíos? Sa̱mpi̱ hasta c-quintiyatcán cucxilhcha̱hu la̱ntla̱ tzúculh makaxkaka̱nán cstacu̱ anta̱ni̱ pulha̱ chichiní, na̱ huá̱ cli̱mini̱tahu lakataquilhpu̱taya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cha̱nchu̱ acxni̱ káxmatli̱ rey Herodes tu̱ xlakminko̱ni̱t, lanaj lacahuanko̱lh, chu̱ pacs xa̱hua̱ xli̱pacs ti̱ antá̱ xalani̱n c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Acxni̱ chú̱ tima̱makstokko̱lh xli̱pacs xanapuxcun xpa̱lijnican judíos, chu̱ lakskalalan xma̱kalhtahuaka̱nacán. Na̱má̱ kalhasquinko̱lh: —Cumu huixín catzi̱yá̱tit, caquihuanítit: ¿Xatú̱ ca̱chiquí̱n anta̱ni̱ luhua nalacachín Cristo hua̱nti̱ huaná̱tit pi̱ naca̱lakma̱xtuyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Cha̱nchu̱ xlacán na̱má̱ huaniko̱lh: —Tama̱ Cristo antá̱ nalacachín c-actzu̱ xaca̱chiqui̱n Belén c-xtama̱paksi̱n Judea, sa̱mpi̱ chuná̱ títzokli cha̱tum profeta̱ c-Xasa̱ntujlani Li̱kalhtahuaka̱ anta̱ni̱ na̱má̱ huan: ");
INSERT INTO tosNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Chi̱nchu̱ huix actzu̱ chuchutsipij Belén antá̱ c-xatiyat Judá. Ni̱ taji̱ cali̱púhuanti̱ pala huix puhuana̱ pi̱ ni̱tú̱ milakasi la̱ntla̱ makapitzi̱n lactlanca ca̱chiquí̱n hua̱ntu̱ huilakó̱ c-Judá; sa̱mpi̱ ma̱squi li̱lakaputza ca̱chiquí̱n huix, antá̱ nalacachín cha̱tum tali̱pa̱hu chixcú̱ hua̱nti̱ napu̱lale̱nko̱y, chu̱ namaktakalhko̱y quilakskata̱n israelitas.’ ");
INSERT INTO tosNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ali̱sta̱lh Herodes tze̱k tasaniko̱lh acastaca̱n chixcuhuí̱n hua̱nti̱ xala mákat minko̱ni̱tanchá, li̱huana̱ kalhasquinko̱lh xatú̱ ya̱ quilhtamacú̱ luhua tzúculh ucxilhko̱y tama̱ stacu. ");
INSERT INTO tosNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Cha̱nchu̱ acxni̱ xlacán huaniko̱lh, xlá̱ ma̱lakacha̱ko̱lh c-Belén, chu̱ na̱má̱ huaniko̱lh: —Lacapala̱ capimpítit c-Belén, chu̱ na̱ li̱huana̱ cakalhasquini̱nántit xpa̱lacata xaní̱ luhua huí̱ laqui̱mpi̱ na̱ nacán quit lakataquilhpu̱tay. ");
INSERT INTO tosNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hua̱ xlacán, acxni̱ kaxmatniko̱lh Rey, anko̱lh. Cha̱nchu̱ hua̱ stacu̱ tu̱ xucxilhko̱ni̱t c-xtiyatcán aya tzucupaj pu̱laniti̱lhako̱y c-tiji, chu̱ acxni̱ ticha̱nko̱lh, antá̱ titachókolh c-xta̱lacaxtum chiqui̱ anta̱ni̱ xuí̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Acxni̱ chú̱ ucxilhko̱lh stacu̱ pi̱ antá̱ xtachokoni̱t, tipa̱xuhuako̱lh, luhua xli̱ca̱na̱ tlanca tapa̱xuhuá̱n tikalhi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Acxni̱ chú̱ tanu̱ko̱lh c-chiqui, chu̱ acxni̱ ucxilhko̱lh actzu̱ kahuasa̱ pi̱ xchaxni̱t xtzi María, lacapala̱ tatzokostako̱lh, lakataquilhpu̱tako̱lh. Ali̱sta̱lh ma̱kalhka̱ko̱lh xpaklha̱tcán anta̱ni̱ xmuju̱ko̱ni̱t hua̱ntu̱ xlacán xle̱nko̱y, chu̱ ma̱xqui̱ko̱lh xtumi̱ncán xla oro, li̱ma̱jiní̱n, chu̱ xalacuan perfumes huanicán mirra. ");
INSERT INTO tosNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ali̱sta̱lh chú̱ acxni̱ aya lhtatako̱lh ca̱tzi̱sní, c-xca̱tama̱nixni ma̱catzi̱ni̱ko̱lh cha̱tum xangel Dios pi̱ nia̱lh antá̱ caanko̱lh c-Jerusalén anta̱ni̱ huilachá̱ Herodes. Pus xlacán chuná̱ tlahuako̱lh, huata tanuj tiji̱ chipako̱lh hua̱ntu̱ ti̱tum an hasta c-xchuchutsipijcán. ");
INSERT INTO tosNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Acxni̱ tianko̱lh xlace1n titasiyúnilh c-xca̱tama̱nixni̱ José xangel Quimpu̱chinacán, na̱má̱ huánilh: “Lacapala̱ cata̱qui. Cata̱taca̱xkó̱ tama̱ actzu̱ kahuasa xa̱hua̱ xtzi, chu̱ mákat catza̱látit hasta c-xatiyat Egipto. Antá̱ chú̱ natamakaxtakka̱pítit hasta ni̱li̱huaya̱ nacuaniyá̱n hua̱ntu̱ mili̱tláhuat, sa̱mpi̱ rey Herodes, nama̱putzi̱nán tama̱ actzu̱ kahuasa laqui̱mpi̱ namakni̱y.” ");
INSERT INTO tosNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Cha̱nchu̱ xlá̱ huatiya̱ yuma̱ ca̱tzi̱sní̱ tá̱qui̱lh, chu̱ lacapala̱ ma̱ca̱xko̱lh actzu̱ kahuasa, chu̱ xtzi; antá̱ chú̱ anko̱lh tahuilako̱y c-Egipto. ");
INSERT INTO tosNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Antá̱ chú̱ xlacán xuilako̱chá̱ hasta acxni̱ ni̱lh Herodes. Chuná̱ tancs li̱kantáxtulh xtachihui̱n Quimpu̱chinacan Dios hua̱ntu̱ tima̱puhuá̱ni̱lh pi̱ natzoka̱ xpa̱lacachihui̱na Oseas c-xlibro̱ anta̱ni̱ na̱má̱ huan: “Quit cli̱ma̱paksí̱nalh pi̱ cali̱minca̱ quincam anta̱ni̱ xuilachá̱ c-Egipto.” ");
INSERT INTO tosNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Acxni̱ cátzi̱lh rey Herodes pi̱ xakskahuiko̱ni̱t acastaca̱n chixcuhuí̱n, xlá̱ li̱pe̱cua̱ la̱ntla̱ tisí̱tzi̱lh, li̱ma̱paksí̱nalh pi̱ camakni̱ko̱ca̱ xli̱pacs lactzu̱ lakkahuasán ti̱ ni̱ xa̱ma̱katzi̱ko̱y akatuyú̱n ca̱ta, hua̱nti̱ xuilakó̱ c-Belén, chu̱ ti̱ xala c-xquilhapá̱n. Hua̱ chuná̱ li̱tláhualh sa̱mpi̱ hua̱ yuma̱ acastaca̱n chixcuhuí̱n li̱ta̱chihui̱nanko̱lh pi̱ xkalhi̱y na̱mpala aktuy ca̱ta̱ la̱ntla̱ xlacán tiucxilhko̱lh cstacu̱ Cristo. ");
INSERT INTO tosNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Puschí̱ hua̱ntu̱ tláhualh rey Herodes la̱ntla̱ ma̱makni̱ni̱nanko̱lh lactzu̱ camán, chuná̱ li̱kantáxtulh hua̱ntu̱ maka̱n quilhtamacú̱ títzokli profeta Jeremías c-xlibro̱ anta̱ni̱ na̱má̱ huan: ");
INSERT INTO tosNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Antá̱ c-xaca̱chiqui̱n Ramá takaxmata̱ la̱mpala huí̱ ti̱ li̱pe̱cua̱ putlma̱, chu̱ tasaxni̱ma̱ xpa̱lacata xtali̱puhuá̱n. Laktasako̱y Raquel xlakskatá̱n, na̱ ni̱ lacásquilh pala tí̱ nama̱koxumixiy, nama̱aktziyaja sa̱mpi̱ huá̱ laktasama̱kó̱ xcamán hua̱nti̱ aya makni̱ko̱cani̱t.” ");
INSERT INTO tosNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hua̱mpi̱ lacatzá̱lalh quilhtamacú̱, chu̱ acxni̱ ni̱lh rey Herodes, cha̱tum xangel Quimpu̱chinacán c-xca̱tama̱nixni̱ tasiyúnilh José c-Egipto. ");
INSERT INTO tosNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Na̱má̱ huánilh: “Cataca̱xta̱qui, catiya̱ actzu̱ kahuasa, chu̱ xtzi, na̱ antá̱ cataspitpalátit c-mintiyatcan Israel; sa̱mpi̱ chú̱ aya ni̱ko̱ni̱t xli̱pacs hua̱nti̱ xpuhuaniko̱y namakni̱ko̱y actzu̱ minkahuasacán.” ");
INSERT INTO tosNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Taca̱xtá̱qui̱lh chú̱ José, quilhta̱yapá̱ xtiji, ta̱anko̱lh actzu̱ kahuasa, chu̱ xtzi, antá̱ chú̱ titaspitpalako̱lh c-xtiyatcan Israel. ");
INSERT INTO tosNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hua̱mpi̱ acxni̱ ni̱ xa̱chá̱n José káxmatli̱ pi̱ huá̱ Arquelao xma̱paksi̱nama̱ c-Judea, pi̱ huá̱ xpa̱lacatanu̱ni̱t xtla̱t Herodes, tipé̱cualh tzinú̱ naán antá. Hua̱mpi̱ cumu stacya̱huapalaca̱ ca̱tama̱nixni, huata xatlá̱n xlacán antá̱ tianko̱lh c-xatiyat Galilea. ");
INSERT INTO tosNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Acxni̱ ticha̱nko̱lh, antá̱ tianko̱lh tahuilako̱y c-aktum actzu̱ ca̱chiquí̱n huanicán Nazaret. Hua̱ chuná̱ qui̱li̱táxtulh laqui̱mpi̱ nakantaxtuy c-xlatama̱t Jesús hua̱ntu̱ tatzoktahuilani̱t xpa̱lacata̱ c-xlibro̱can xpa̱lacachihui̱nani̱n Dios pi̱ Nazareno nali̱tapa̱cuhui̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na̱ acxni̱ yama̱ quilhtamacú̱ tímilh ma̱tzuqui̱y xtascújut cha̱tum chixcú̱ hua̱nti̱ a̱li̱sta̱lh tili̱ma̱pa̱cuhui̱ca̱ Juan Bautista. Acxni̱ chá̱lh c-desierto, usu anta̱ni̱ tzili̱s ca̱huán c-xatiyat Judea, antá̱ chú̱ tzúculh li̱akchihui̱nán aktum xasa̱sti xtama̱catzi̱ni̱n Dios la̱ntla̱ xma̱laktaxti̱putún tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","C-xta̱kchihuí̱n na̱má̱ xquilhuama̱: “Calakpalí̱tit xali̱xcajnit mintalacapa̱stacnicán, chuná̱ calatapá̱tit la̱ntla̱ Dios lacasquín, sa̱mpi̱ aya talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tuxá̱huat.” ");
INSERT INTO tosNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Huatiya̱ chú̱ tama̱ Juan Bautista hua̱nti̱ xamaka̱n quilhtamacú̱ tili̱chihuí̱nalh profeta Isaías acxni̱ na̱má̱ titzóknu̱lh c-xlibro̱: “Takaxmata̱chá̱ xtachihui̱n cha̱tum ti̱ ca̱tasay anta̱ni̱ tzili̱s ca̱huán, na̱má̱ huan: ‘Caca̱xtlahuanítit tiji̱ anta̱ni̱ tla̱n nalacmín Quimpu̱chinacán, na̱ cama̱tzajuaní̱tit kantum tiji̱ anta̱ni̱ nama̱tla̱ni̱y nalactla̱huán.’” ");
INSERT INTO tosNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lháka̱t hua̱ntu̱ xli̱lhaka̱nán Juan huá̱ xli̱tatlahuani̱t xchixit camello chu̱ xli̱tampu̱lakchi̱cán kantum xli̱tampa̱chi xla xu̱hua, chi̱nchu̱ hua̱ xlí̱huat huá̱ xlá̱ xuay lactzu̱ xtuqui, xa̱hua̱ táxca̱t hua̱ntu̱ xlá̱ xta̱ksa̱ ca̱quihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Cha̱nchu̱ lhu̱hua chixcuhuí̱n xala mákat xminko̱y kaxmatniko̱y xtachihuí̱n, na̱ chuná̱ hua̱nti̱ xuilakó̱ c-xaca̱chiqui̱n Jerusalén, xa̱huá̱ ti̱ xalani̱n xli̱ca̱tlanca c-xatiyat Judea, na̱ chuná̱ chú̱ hua̱nti̱ antá̱ xuilakó̱ xli̱ca̱tlanca c-xca̱quilhtu̱ni̱n kalhtu̱choko̱ huanicán Jordán. ");
INSERT INTO tosNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Acxni̱ chú̱ xuilakó̱ hua̱nti̱ maktum xuanko̱y pi̱ xli̱ca̱na̱ xlakpali̱putunko̱y xali̱xcajnit xtalacapa̱stacnicán, Juan xmunuko̱y c-kalhtu̱choko̱. ");
INSERT INTO tosNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hua̱mpi̱ acxni̱ Juan xucxilhko̱y lhu̱hua̱ judíos hua̱nti̱ xuaniko̱cán fariseos, chu̱ laktzokqui̱naní̱n xlakminko̱y pi̱ na̱ nata̱kmunuko̱y, na̱má̱ huaniko̱y: “Luhua xta̱chuná̱ lapá̱tit la̱ lako̱y xcanani̱n lu̱hua̱ acxni̱ tzucuko̱y tza̱laniko̱y lhcúya̱t acxni̱ ca̱xkoma̱kó̱. ¿Tí̱ ca̱ma̱siyunín huixín pala caj la̱ nata̱kmunuyá̱tit tla̱n nalaktaxtuniyá̱tit tapa̱tí̱n hua̱ntu̱ chú̱ ni̱ maka̱s Dios naca̱macaminiyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Huá̱ chú̱ tu̱ tla̱n nahuán pi̱ aksti̱tum natzucuyá̱tit latapa̱yá̱tit laqui̱mpi̱ chuná̱ nali̱ma̱siyuyá̱tit pi̱ xli̱ca̱na̱ lakpali̱putuná̱tit ni̱tla̱n mintalacapa̱stacnicán. ");
INSERT INTO tosNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na̱ nia̱lh tili̱pacxá̱tit pi̱ caj xpa̱lacata xquilhtzucut xamaka̱n ko̱lutzí̱n Abraham huixín, chú̱ ni̱ lay pala tú̱ catica̱akspulán. Sa̱mpi̱ xli̱ca̱na̱ pi̱ tamá̱ ni̱ tzinú̱ catica̱makta̱yán c-xlacati̱n Dios. Pus lacatancs cca̱huaniyá̱n pi̱ pala Dios chuná̱ xlacásquilh, hasta caj catu̱hua̱ chíhuix, xlá̱ tla̱n xca̱li̱má̱xtulh xcaman Abraham. ");
INSERT INTO tosNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dios xta̱chuná̱ ca̱li̱ucxilhá̱n xta̱chuná̱ la̱ quihui̱ tu̱ caj mini̱niko̱y tasakni nahuanko̱y, hasta aya xalanitá huí̱ hacha hua̱ntu̱ chipani̱t laqui̱mpi̱ natanca̱mi̱ko̱y quihui̱ hua̱ntu̱ nia̱lh tú̱ li̱lacán. Xli̱pacs caxatu̱cahua̱ quihui̱ hua̱ntu̱ ni̱tla̱n xtahuácat ma̱sta̱y, naca̱cán, na̱ natamacapu̱cán c-lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Xli̱ca̱na̱ xlá̱ pi̱ caj chúchut quit cca̱li̱akmunumá̱n laqui̱mpi̱ chuná̱ nali̱catzi̱cán pi̱ xli̱ca̱na̱ lakpali̱putuná̱tit xalacli̱xcajnit mintalacapa̱stacnicán; hua̱mpi̱ chú̱ nachín cha̱tum hua̱nti̱ quit cpu̱laniti̱lhay, huata xlá̱ naca̱li̱munuyá̱n xli̱tlihuaka Espíritu Santo. Sa̱mpi̱ xlá̱ xali̱huaca̱ tlanca̱ xlacatzúcut ni̱ xahua̱ quit, huá̱ xpa̱lacata quit hasta ni̱ pala tzinú̱ quimini̱niy xtasa̱cua̱ nacli̱taxtuy laqui̱mpi̱ nacxcutniy xatasij xtatuhuanu. ");
INSERT INTO tosNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xlá̱ luhua aya li̱huana̱ lacapa̱stacni̱t la̱ntla̱ nama̱pa̱pitziko̱y, luhua xta̱chuná̱ xlá̱ natlahuako̱y la̱ntla̱ yama̱ cha̱tum chixcú̱ hua̱nti̱ xalanitá̱ chipani̱t xli̱scujni̱ c-xmacán hua̱ntu̱ nali̱lacsunuy xtrigo c-xpu̱lacpajcán laqui̱mpi̱ namakaniy xapalhma, chu̱ acxni̱ aya actancs lacsunuko̱ni̱t nahuán xtrigo li̱huana̱ nama̱qui̱y c-xpu̱ma̱qui̱cán. Chi̱nchu̱ huá̱ xapalhma, nalhcuyuy c-lhcúya̱t anta̱ni̱ niucxnicú̱ catímixli.” ");
INSERT INTO tosNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Hua̱nchú̱ Jesús taca̱xchá̱ c-xca̱chiquí̱n hua̱ntu̱ xuí̱ c-Galilea, antá̱ chilh c-xakalhtu̱choko̱ Jordán anta̱ni̱ xakmunu̱nama̱ Juan laqui̱mpi̱ xlá̱ na̱ naakmunuy. ");
INSERT INTO tosNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Hua̱mpi̱ acxni̱ xlá̱ lákchilh, Juan ni̱ luhua xakmunuputún, na̱má̱ huánilh: —Quit hua̱nti̱ xlacasquinca̱ naquiakmunuya, ¿pi̱ huata huix chú̱ ti̱ quilaktana̱ laqui̱mpi̱ quit nacakmunuyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Cha̱nchu̱ kalhtí̱nalh Jesús, huánilh: —Luhua xli̱ca̱na̱ catlahua̱ hua̱ntu̱ cuanimá̱n, sa̱mpi̱ chuná̱ quinca̱mini̱niyá̱n nama̱kantaxti̱ya̱hu xli̱pacs hua̱ntu̱ Dios lhca̱huili̱ni̱t. Huata tla̱n titlahuánilh chú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cha̱nchu̱ a̱li̱sta̱lh acxni̱ ta̱kmúnulh Jesús, chu̱ aya xtacutma̱ c-chúchut, caj xamaktum talácqui̱lh akapú̱n, chu̱ Jesús úcxilhli̱ cspiritu Dios xta̱ctama̱chi xta̱chuná̱ tantum actzu̱ tijtímpu̱t, na̱ antá̱ ti̱tum xlakmima̱. ");
INSERT INTO tosNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na̱ luhua acxnitiyá̱ takáxmatli̱ aktum tachihuí̱n hua̱ntu̱ minchá̱ c-akapú̱n, na̱má̱ huá̱: “Hua̱ yuma̱ Quincam hua̱nti̱ quit luhua cpa̱xqui̱y, luhua xli̱ca̱na̱ cli̱pa̱xuhuay hua̱ntu̱ xpa̱lacata.” ");
INSERT INTO tosNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ali̱sta̱lh acxni̱ ta̱kmunuko̱lh, yama̱ Xespíritu Dios le̱lh Jesús c-desierto anta̱ni̱ tzili̱s ca̱huán, laqui̱mpi̱ antá̱ natoklha̱ akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","La̱ntla̱ antá̱ xlama̱chá, ti̱puxam quilhtamacú̱ tantacu tantascaca̱ ni̱ huá̱yalh, a̱li̱sta̱lh chú̱ tzuculhá tzincsa. ");
INSERT INTO tosNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Huata akskahuiní̱ lacapala̱ lákmilh laqui̱mpi̱ natoklha, chu̱ chuná̱ nama̱tlahui̱y tala̱kalhí̱n. Na̱má̱ huánilh: —Hua̱ lapi̱ xli̱ca̱na̱ xCam Dios huix, pus chú̱ cali̱ma̱paksí̱nanti̱ laqui̱mpi̱ yuma̱ chíhuix caxtala̱nchu̱ nahuán. ");
INSERT INTO tosNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús kálhti̱lh: —Xtachihui̱n Dios hua̱ntu̱ tatzokni̱t c-Li̱kalhtahuaka, na̱má̱ huan: ‘Ni̱ luhua caj xma̱n xtahuá̱ catili̱latáma̱lh cha̱tum, pus na̱ luhua xlacasquinca̱ nali̱latama̱y xtachihui̱n Dios hua̱ntu̱ xlá̱ li̱ma̱paksi̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ali̱sta̱lh akskahuiní̱ tá̱alh Jesús c-xaca̱chiqui̱n Jerusalén anta̱ni̱ xyá̱ tlanca xtemplo̱can judíos, ta̱tahuácalh c-xakstí̱n, anta̱ni̱ a̱huatiyá̱ c-xacpu̱n xapá̱tzaps. ");
INSERT INTO tosNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Antá̱ na̱má̱ huánilh: —Hua̱ lapi̱ xli̱ca̱na̱ xCam Dios huix, catamákuasti̱ u̱nú̱ hasta ca̱tu̱tzú̱ pi̱ chuná̱ na̱má̱ tatzokni̱t c-xtachihui̱n Dios c-Li̱kalhtahuaka: ‘Dios naca̱li̱ma̱paksi̱y xángeles pi̱ nacui̱ntajtlahuako̱yá̱n. Nali̱chipapa̱xtokko̱yá̱n xmacancán, laqui̱mpi̱ ni̱ pala aktum chíhuix nali̱akchakxa̱ mintuhuán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na̱má̱ kálhti̱lh Jesús: —Hua̱mpi̱ na̱ luhua mili̱cátzi̱t pi̱ hua̱ntu̱ tatzoktahuilani̱t xtachihui̱n Dios na̱ chuna̱ na̱má̱ huan: ‘Ni̱ caj chunata cali̱kalhakamá̱nanti̱ Mimpu̱chinacan Dios laqui̱mpi̱ natlahuay hua̱ntu̱ huix lakati̱ya̱ catláhualh hua̱ntu̱ ni̱ pala tzinú̱ mini̱niyá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Pus xaa̱huatiyá, yama̱ akskahuiní̱ ta̱ampá̱ Jesús c-aktum ka̱stí̱n luhua ta̱lhmá̱n, antá̱ ma̱ucxilhni̱ko̱lh xli̱pacs lactlanca ca̱chiquí̱n hua̱ntu̱ tata̱ksa̱ ca̱tiyatna, na̱ chuná̱ pacs la̱ntla̱ tu̱ kalhi̱ko̱y xli̱ca̱li̱lakáti̱t, chu̱ hua̱ntu̱ xtapalh tumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Na̱má̱ huánilh: —Lapi̱ huix natatzokostaya, chu̱ naquilakataquilhpu̱taya, chu̱ naquilakachixcuhui̱ya̱ la̱ mimpu̱chiná, quit nacma̱xqui̱yá̱n pacs hua̱ntu̱ ucxílhpa̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Cha̱nchu̱ huánilh Jesús: —Huix akskahuiní, catapa̱nu̱ anta̱ni̱ cyá̱, sa̱mpi̱ c-Li̱kalhtahuaka̱ na̱má̱ tatzokni̱t: ‘Xma̱n huá̱ Mimpu̱chinacan Dios nalakataquilhpu̱taya, chu̱ na̱ xma̱n hua̱nti̱ nalakachixcuhui̱ya.’ ");
INSERT INTO tosNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Puschí̱ titapa̱nú̱nilh akskahuiní, cha̱nchu̱ tichinko̱lh ángeles, laqui̱mpi̱ namaktakalhko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Acxni̱ tikáxmatli̱ Jesús pi̱ tamacanu̱ca̱ Juan c-pu̱la̱chi̱n huata xlá̱ antá̱ tiampá̱ c-Galilea, na̱ antá̱ cha̱lh c-Nazaret. ");
INSERT INTO tosNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hua̱mpi̱ ni̱ maka̱s tamakáxtakli̱ antá, huata antá̱ alh tahuilay c-Capernaum. Yuma̱ ca̱chiquí̱n huí̱ c-xquilhtu̱n ta̱kaya̱huaná, na̱ huí̱ lacatzú̱ c-xli̱pa̱lhca̱n Zabulón, chu̱ Neftalí. ");
INSERT INTO tosNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chuná̱ li̱kantáxtulh hua̱ntu̱ títzokli̱ profeta Isaías c-xlibro̱ anta̱ni̱ na̱má̱ huan: ");
INSERT INTO tosNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Hua̱nti̱ antá̱ huilako̱chá̱ mákat anta̱ni̱ huilakó̱ yama̱ aktuy tíyat huaniko̱cán Zabulón, chu̱ Neftalí, anta̱ni̱ ti̱taxtuy tlanca̱ti̱ ni̱ma̱ cha̱n hasta c-ta̱kaya̱huaná, anta̱ni̱ tzucuma̱chá̱ xakalhtu̱choko̱ Jordán, antá̱ c-xatiyat Galilea anta̱ni̱ lhu̱hua̱ huilakó̱ hua̱nti̱ ni̱ judíos. ");
INSERT INTO tosNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Hua̱ tachixcuhuí̱tat antá̱ xalaní̱n ma̱squi xlacán ca̱paklhtu̱tá̱ xlama̱kó̱, hua̱mpi̱ namín quilhtamacú̱ acxni̱ naucxilhko̱y tlanca xkakánat; chu̱ hua̱nti̱ huilakó̱ antá̱ c-xaca̱ska̱kna tíyat xla li̱ní̱n, xlacán nali̱lacahua̱nanko̱y tlanca xkakánat.” ");
INSERT INTO tosNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hasta acxnitiyá̱ Jesús tzúculh akchihui̱nán, chu̱ na̱má̱ xuan: “Calakpalí̱tit xalacli̱xcajnit milatama̱tcán, chu̱ chuná̱ calatapá̱tit la̱ntla̱ Dios lacasquín, sa̱mpi̱ chú̱ aya talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ xlá̱ nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tiyatna.” ");
INSERT INTO tosNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Maktum acxni̱ Jesús xquilhtu̱tla̱huama̱ xata̱kaya̱huana Galilea, úcxilhli̱ cha̱tuy li̱nata̱lán, cha̱tum xuanicán Simón hua̱nti̱ a̱li̱sta̱lh li̱ma̱pa̱cuhui̱ca̱ Pedro, chi̱nchu̱ a̱cha̱tum xuanicán Andrés. Xlacán caj squi̱ti̱naní̱n xuanko̱ni̱t, chu̱ xmaca̱ma̱kó̱ xtza̱lhcán c-chúchut. ");
INSERT INTO tosNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hua̱mpi̱ Jesús huaniko̱lh: —Huixín squi̱ti̱naní̱n, chu̱ tla̱n catzi̱yá̱tit la̱ntla̱ chipacán squi̱ti, caquista̱lanítit, chu̱ quit nacca̱ma̱siyuniyá̱n tanu̱ mintascujutcán la̱ntla̱ tla̱n nachipayá̱tit hua̱nti̱ aktzanka̱ko̱ni̱t laqui̱mpi̱ naquili̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Acxni̱ chuná̱ huaniko̱lh, hua̱ yuma̱ squi̱ti̱naní̱n makaxtakko̱lh tuncán xtza̱lhcán, sta̱laniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Caj akchú̱ titla̱huampá̱, tiucxilhpá̱ cha̱tuy li̱tum chixcuhuí̱n, na̱ li̱nata̱lán, hua̱ Jacobo, chu̱ Juan xcaman Zebedeo. Xlacán antá̱ xtaju̱ma̱kó̱ c-aktum pu̱tacutnu̱ xlacachi̱ma̱kó̱ xtza̱lhcán; na̱ antá̱ xtaju̱ma̱ ko̱lutzi̱n Zebedeo hua̱nti̱ xtla̱tcán. Jesús tasaniko̱lh, chu̱ huaniko̱lh pi̱ casta̱laniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pus xlacán na̱ tuncán makaxtakko̱lh xtza̱lhcán, xa̱hua̱ xtla̱tcán, chu̱ sta̱laniko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús xlakatza̱latla̱huán lactzu̱ ca̱chiquí̱n xli̱ca̱tlanca̱ c-xatiyat Galilea, xakchihui̱naniko̱y judíos c-xpu̱kalhtahuakacán; anta̱ni̱ xcha̱n xlá̱ xli̱ta̱chihui̱nanko̱y xpa̱lacata yama̱ xasa̱sti xtapáksi̱t hua̱ntu̱ Dios xma̱tzuqui̱putún ca̱tuxá̱huat, chu̱ na̱ chuna li̱tum xma̱pacsako̱y caxatu̱cahua̱ tajátat, usu tacatzanájuat tu̱ xkalhi̱ko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na̱ ticatzi̱caj tuncán hua̱ntu̱ xtlahuama̱ Jesús la̱ntla̱ xli̱ca̱tlanca̱ c-xatiyat Siria; chu̱ lhu̱hua̱ tzucucaj li̱mincán ta̱tatlaní̱n hua̱nti̱ tuhuajcuta tajátat xkalhi̱ko̱y, chu̱ na̱ chuná̱ hua̱nti̱ xakchipako̱ni̱t xtalacapa̱stacnicán akskahuiní, chu̱ ti̱ xakuitiko̱y, chu̱ ti̱ xaní̱n xkalhi̱ko̱y c-xnujutcán. Pus Jesús pacs tima̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na̱ tista̱laniko̱lh lhu̱hua chixcuhuí̱n xala c-Galilea, chu̱ xala c-Decápolis, chu̱ xala c-Jerusalén, chu̱ xala c-Judea, chu̱ ti̱ xala c-xa̱lakapu̱tu Jordán. ");
INSERT INTO tosNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Maktum acxni̱ úcxilhli̱ Jesús pi̱ luhua lhu̱hua̱ hua̱nti̱ csta̱lanima̱kó̱, lacapala̱ talacaacxtutahui̱ c-xmacni aktum tlanca ka̱stí̱n; acxni̱ cha̱lh anta̱ni̱ ca̱xtum tzinú̱, antá̱ titahui̱, xli̱pu̱tum xli̱ma̱kalhtahuáka̱t ta̱tahuilako̱chá, ");
INSERT INTO tosNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","xlá̱ tzúculh ma̱siyuniko̱y yuma̱ lactla̱n talacapa̱stacni: ");
INSERT INTO tosNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ca̱na̱ lacli̱pa̱xuhu camakcatzí̱tit huixín hua̱nti̱ catzi̱yá̱tit pi̱ xli̱ca̱na̱ huí̱ pu̱lactum hua̱ntu̱ ca̱tzanka̱niyá̱n c-xlacati̱n Dios, sa̱mpi̱ hua̱nti̱ chuná̱ kalhi̱ko̱y xtalacapa̱stacni xli̱ca̱na̱ pi̱ hua̱ xlacán ti̱ Dios lakati̱y maklhti̱nanko̱y c-xasa̱sti xtapáksi̱t tu̱ nahuili̱y ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ ca̱la̱nchú̱ li̱puhuaxni̱ma̱kó̱, sa̱mpi̱ namín quilhtamacú̱ acxni̱ namakamaklhti̱nanko̱y ta̱ktziyani. ");
INSERT INTO tosNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ xalacsma̱lhuán, sa̱mpi̱ huá̱ namakamaklhti̱nanko̱y tama̱ lakli̱lakati̱t pu̱táhui̱lh hua̱ntu̱ Dios ma̱lacnu̱ni̱t nama̱xqui̱ko̱y xlakskatá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ ca̱la̱nchú̱ xli̱pacs xnacu̱cán putzako̱y, chu̱ lactzaksako̱y la̱ntla̱ aksti̱tum nalatama̱ko̱y, sa̱mpi̱ xli̱ca̱na̱ pi̱ huá̱ Dios nama̱xqui̱ko̱y hua̱ntu̱ xlacán putzako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ xalakalhama̱naní̱n, chu̱ tla̱n catzi̱niko̱y a̱makapitzí̱n, sa̱mpi̱ xli̱ca̱na̱ pi̱ c-xlacati̱n Dios nalakcha̱nko̱y xlacán talakalhamá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ ni̱ caj xquilhnicán li̱huanko̱y hua̱mpi̱ xli̱pacs xnacu̱cán tlahuaputún xtalacasquin Dios, sa̱mpi̱ xli̱ca̱na̱ pi̱ hua̱ xlacán ti̱ naucxilhko̱ya̱chá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ ta̱katzanka̱ma̱kó̱, chu̱ li̱scujma̱kó̱ xpa̱lacata̱ pi̱ ankalhí̱n caánalh tatancsni̱ c-xlaksti̱pa̱ncan tachixcuhuí̱tat, sa̱mpi̱ hua̱ xlacán ti̱ Dios li̱ma̱xtuko̱y luhua xli̱ca̱na̱ xlakskatá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Lacli̱pa̱xuhu cali̱makcatzi̱ko̱ca̱ hua̱nti̱ ma̱pa̱ti̱ni̱ko̱cán caj xpa̱lacata pi̱ tlahuaputunko̱y hua̱ntu̱ tla̱n xtascujut Dios, sa̱mpi̱ xli̱ca̱na̱ pi̱ hua̱ xlacán hua̱nti̱ luhua nalakcha̱nko̱y, chu̱ nali̱pa̱xuhuako̱y hua̱ntu̱ Dios nama̱xqui̱ko̱y c-xtapáksi̱t c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Lacli̱pa̱xuhu caca̱li̱makcatzi̱cántit huixín acxni̱ caj quimpa̱lacat naca̱xcajnicaná̱tit, chu̱ lakahuán xca̱ta̱la̱tlahuacántit, chu̱ naca̱soka̱li̱caná̱tit, chu̱ naca̱ma̱xtunicaná̱tit ta̱ksaní̱n hua̱ntu̱ huixín naca̱li̱ya̱huacaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yama̱ quilhtamacú̱ huixín cali̱pa̱xuhuátit hua̱ntu̱ ca̱okspulamá̱n, chu̱ ni̱ caj cali̱li̱puhuántit, sa̱mpi̱ luhua lhu̱hua̱ naca̱li̱ma̱skahuicaná̱tit c-akapú̱n; xa̱huachí̱ na̱ calacapa̱stáctit pi̱ na̱ chuná̱ tlahuako̱cani̱t xpa̱lacachihui̱nani̱n Dios hua̱nti̱ xapu̱lanajá̱ qui̱chinko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Huixín catzi̱yá̱tit pi̱ mátzat luhua tamaclacasquín sa̱mpi̱ li̱ma̱skoka̱nancán, pus chú̱ huixín cca̱li̱ma̱xtuyá̱n la̱ mátzat c-xlaksti̱pa̱ncan tachixcuhuí̱tat hua̱nti̱ nama̱skoka̱yá̱tit laqui̱mpi̱ ni̱ naaktzanka̱ko̱y. Hua̱mpi̱ pala tama̱ mátzat cspútnilh ixli̱skoko ¿lá̱ntla̱ nali̱ma̱skoka̱nancán? Xli̱ca̱na̱ pi̱ nia̱lh tú̱ xli̱lacán, huata xatlá̱n cajá namakancán quilhtí̱n laqui̱mpi̱ cati̱huá̱ nalacta̱yami̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Na̱ chuna li̱tum huixín c-xlaksti̱pa̱ncan tachixcuhuí̱tat li̱taxtuyá̱tit la̱ xkakánat hua̱ntu̱ namakskoniko̱y ca̱tiyatna. Pus aktum chuchutsipi̱ hua̱ntu̱ huilachá̱ c-xokspun tlanca ka̱stí̱n xli̱ca̱na̱ pi̱ ni̱ lay tatze̱ka̱ lapi̱ ni̱ fuerza naucxilhcán. ");
INSERT INTO tosNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chu̱ na̱ ni̱ pala ma̱pasi̱cán mákskot pala c-xtampi̱n pakxu̱ nahuili̱cán, hua̱mpi̱ antá̱ huili̱cán anta̱ni̱ c-xpu̱táhui̱lh, pacs chí̱ namakaxkaka̱naniko̱y hua̱nti̱ huilakó̱ c-chiqui. ");
INSERT INTO tosNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na̱ chuná̱ na̱má̱ camakaxkaká̱nalh mixkakanatcán c-xlacati̱n tachixcuhuí̱tat laqui̱mpi̱ naucxilhko̱y hua̱ntu̱ xatla̱n mintatlahucán, chu̱ nali̱ma̱xqui̱ko̱y ca̱cni̱ Mintla̱tcán ti̱ huí̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ni̱ tipuhuaná̱tit pala caj cmini̱t lactlahuay hua̱ntu̱ timakáxtakli̱ xli̱ma̱paksi̱n Moisés, xa̱huá̱ hua̱ntu̱ tiqui̱ma̱siyuchi̱ xalakmaka̱n xpa̱lacachihui̱nani̱n Dios: quit ni̱tu̱ caj cmini̱t lactlahuay, huata caj cmini̱t ma̱siyuy hua̱ntu̱ luhua huaniputún. ");
INSERT INTO tosNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa̱mpi̱ luhua xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ xli̱makua̱ ca̱la̱nchú̱ huijcú̱ ca̱tuxá̱huat, xa̱hua̱ akapú̱n, ni̱ pala cha̱tum chixcú̱ anán hua̱nti̱ tla̱n nama̱pa̱nu̱y ca̱na̱ caj aktum letra̱, usuchí̱ hua̱ntu̱ ma̱squi luhua actzu̱ xta̱takatzi̱n letra̱ hua̱ntu̱ maka̱n tatzoktahuilani̱t xli̱ma̱paksi̱n Dios, hasta ni̱ li̱huaya̱ nakantaxtuko̱y hua̱ntu̱ huan pi̱ xli̱kantáxtut. ");
INSERT INTO tosNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ caxati̱cahuá̱ ti̱ kalhakaxmatmakán, chu̱ ni̱ ma̱kantaxti̱putún c-xlatáma̱t makapitzí̱n ná̱ yuma̱ li̱ma̱paksí̱n tu̱ ni̱tú̱ xlakasi̱ puhuán, chu̱ ma̱lacatiji̱ni̱ko̱y a̱makapitzí̱n pi̱ na̱ chuná̱ nakalhakaxmatmakán, xli̱ca̱na̱ pi̱ na̱ chuná̱ ni̱tu̱ xlakasi̱ catili̱taxtuchá̱ antá̱ c-xtapaksi̱t Dios. Hua̱mpi̱ hua̱ caxati̱cahuá̱ ti̱ nakalhakaxmata, chu̱ nama̱kantaxti̱y c-xlatáma̱t, chu̱ nama̱siyuniko̱y a̱makapitzí̱n pi̱ na̱ chuná̱ natlahuako̱y, hua̱ yumá̱ luhua tlanca nali̱tapa̱cuhui̱y antá̱ c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sa̱mpi̱ luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lapi̱ huixín ni̱ nama̱kantaxti̱yá̱tit xli̱ma̱paksi̱n Dios, chu̱ na̱ caj chuná̱ natlahuayá̱tit la̱ tlahuako̱y laktzokqui̱naní̱n, xa̱hua̱ fariseos, pus ni̱ pala huixinín ni̱ lay catitapaksí̱tit c-xasa̱sti xtapaksi̱t Dios tu̱ ma̱tzuqui̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Huixín catzi̱yá̱tit la̱ntla̱ huan yama̱ li̱ma̱paksí̱n hua̱ntu̱ maká̱n tica̱ma̱xqui̱cántit, na̱má̱ huan: ‘Ni̱ timakni̱nana, sa̱mpi̱ caxati̱cahuá̱ hua̱nti̱ xmakní̱nalh namactahuacay tala̱kalhí̱n, chu̱ fuerza̱ naxoko̱nán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Hua̱mpi̱ hua̱ chú̱ quit, nacca̱huaniyá̱n hua̱ntu̱ a̱tzinú̱ tlak tla̱n tachihuí̱n, pi̱ caxati̱cahuá̱ ti̱ ma̱squi caj naxcajniy, chu̱ aklakuá̱ nasi̱tzi̱niy xta̱lá, ma̱squi caj c-xtalacapa̱stacni, na̱ huatiya̱ tala̱kalhí̱n mactahuacay c-xlacati̱n Dios. Huixín catzi̱yá̱tit pi̱ hua̱nti̱ ma̱squi caj aklakua̱ nata̱la̱makasi̱tzi̱y xta̱chixcú, chu̱ naaktlakaxakatli̱y, tamá̱ chixcú̱ mini̱niy cama̱lacapu̱ca̱ c-xlacati̱ncan ma̱paksi̱naní̱n laqui̱mpi̱ antá̱ nama̱kalhapali̱cán xpa̱lacata hua̱ntu̱ siyuj huanini̱t. Hua̱mpi̱ quit cca̱huaniyá̱n pi̱ caxati̱cahuá̱ ti̱ ma̱squi caj nahuaniy xta̱lá, xuánilh: ‘Huix xapala’, na̱ namactahuacay tala̱kalhí̱n hua̱ntu̱ mini̱niy hasta nata̱kastacya̱huay c-pu̱pa̱tí̱n c-lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n, hua̱ pala pi̱ huix li̱pímpa̱t mili̱ca̱xtlahuá̱n c-templo, na̱ antá̱ xlacapá̱stacti̱ pi̱ huí̱ cha̱tum minta̱lá̱ hua̱nti̱ tzinú̱ ta̱la̱makasi̱tzi̱ni̱ta, ");
INSERT INTO tosNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pus huata xatlá̱n antá̱ cahuili̱ka̱ya̱ mili̱ca̱xtlahuá̱n c-xpa̱xtu̱n altar anta̱ni̱ c-xokspún huili̱putuná̱ mili̱ca̱xtlahuá̱n, chu̱ lacapala̱ capit ta̱la̱ma̱koxumixiya̱ yama̱ minta̱lá, chu̱ a̱li̱sta̱lh chú̱ capimpala̱ c-templo laqui̱mpi̱ xli̱pacs mintalacapa̱stacni̱ chú̱ nali̱sa̱huaniya̱ Dios mili̱ca̱xtlahuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Na̱ chuna li̱tum pala cha̱tum minta̱chixcú, catzi̱ya̱ pi̱ si̱tzi̱niyá̱n, chu̱ catzi̱ya̱ pi̱ aya nama̱lacapu̱yá̱n c-xlacati̱n ma̱paksi̱naní̱n, huata xatlá̱n huix lacapalaj tuncán cata̱lacca̱xla̱ xli̱makua ni̱ a̱ma̱lacapu̱yá̱n c-pu̱ma̱paksí̱n; laqui̱mpi̱ ni̱ huá̱ pala namakstuntlahuayá̱n c-xmacán juez, cha̱nchu̱ hua̱ juez c-xmacán máyu̱lh namacama̱sta̱yá̱n pi̱ napa̱ti̱nana̱ c-pu̱la̱chi̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chu̱ pala antá̱ nama̱nu̱cana, quit lacatancs cuaniyá̱n pi̱ ni̱ catitamacaxtuca̱ hasta ni̱li̱huaya̱ naxokoya̱ mimu̱lhta̱ hua̱ntu̱ antá̱ nasquinicana. ");
INSERT INTO tosNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Huixín catzi̱yá̱tit la̱ huan yama̱ li̱ma̱paksí̱n ni̱ma̱ maká̱n quinca̱ma̱xqui̱cani̱tán, na̱má̱ huan: ‘Ni̱ caxakatli̱ tanuj pusca̱t pala huí̱ mimpusca̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Hua̱mpi̱ hua̱ chú̱ quit cca̱huaniyá̱n pi̱ hua̱nti̱ ma̱squi caj naucxilha̱ cha̱tum pusca̱t, chu̱ xlá̱ napuhuán pi̱ tuncán xlá̱ xtláhualh, pus tama̱ chixcú̱ aya tlahuani̱t tala̱kalhí̱n c-xnacú̱, sa̱mpi̱ qui̱taxtuy xta̱chuná̱ pala aya xakátli̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Pus na̱ huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ lapi̱ huá̱ xala c-mimpakstácat milakastapu̱ ma̱tlahui̱putuná̱n tala̱kalhí̱n, huata xatlá̱n tuncán calacpi̱ma̱xtuca, chu̱ mákat camákanti, sa̱mpi̱ xali̱huacá̱ tla̱n natzanka̱y ti̱pa̱tu̱ xla mili̱lacahuá̱n, ni̱ xahua̱ hua̱ xli̱pacs mili̱tlanca̱ natamacapu̱cana̱ c-pu̱pa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na̱ chuna li̱tum, lapi̱ hua̱ mimpakstácat fuerza̱ ma̱tlahui̱putuná̱n tala̱kalhí̱n, xatlá̱n cachucu̱cti, chu̱ mákat camacapi, sa̱mpi̱ xali̱huaca̱ tla̱n caj ti̱pa̱tu̱ xla mimacán nama̱aktzanka̱ya, chu̱ ni̱ mili̱tlanca̱ natamacapu̱cána̱ c-pu̱pa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Na̱ chuna li̱tum, ma̱x catzi̱yá̱tit la̱ntla̱ huan c-pu̱lactum li̱ma̱paksí̱n hua̱ntu̱ xamaka̱n tica̱makaxtaknicántit, na̱má̱ huan: ‘Lapi̱ cha̱tum chixcú̱ makaxtakputún xpusca̱t, pus huata luhua xlacasquinca̱ pi̱ nama̱xqui̱y mactum cápsnat hua̱ntu̱ li̱huana̱ naca̱xtlahuanicán c-pu̱chihuí̱n, laqui̱mpi̱ antá̱ nahuán pi̱ maktum nala̱makaxtakko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Hua̱mpi̱ huata chú̱ quit cca̱huaniyá̱n aktum tachihuí̱n hua̱ntu̱ luhua a̱tzinu̱ xatancs: lapi̱ cha̱tum chixcú̱ namakaxtaka̱ xpusca̱t, ma̱squi xlá̱ ni̱tú̱ tlahuani̱t hua̱ntu̱ ni̱tlá̱n pala xakatli̱ni̱t a̱tanuj chixcú, pus huata xlá̱ caj nama̱tlahui̱y tala̱kalhí̱n lapi̱ naputzapalay hua̱nti̱ nata̱tahuilapalay; chu̱ na̱ chuná̱ yama̱ chixcú̱ hua̱nti̱ nata̱tahuilay yama̱ xatamakan pusca̱t na̱ chuná̱ tlahuay lhu̱hua tala̱kalhí̱n c-xlacati̱n Dios sa̱mpi̱ xlá̱ maktum pi̱ lactlahuako̱y yama̱ tapu̱chúhuat. ");
INSERT INTO tosNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Xa̱huachí̱ na̱ catzi̱yá̱tit la̱ntla̱ huan yama̱ li̱ma̱paksí̱n hua̱ntu̱ xamaka̱n quilhtamacú̱ tica̱ma̱xqui̱cántit, na̱má̱ huan: ‘Fuerza̱ cama̱kántaxti̱ yama̱ mintachihuí̱n hua̱ntu̱ ma̱lacnu̱ya̱ c-xtucuhuiní̱ Mimpu̱chinacán pi̱ natlahuaya.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Hua̱mpi̱ huata quit lacatancs cca̱huaniyá̱n: Niucxnicú̱ tu̱ cali̱ta̱yátit natlahuayá̱tit, chu̱ huá̱ nali̱quilhaná̱tit ma̱squi pala la̱ntla̱ catu̱cahuá̱. Niucxnicú̱ cali̱quilhántit akapú̱n pala tu̱ nali̱ta̱yayá̱tit, sa̱mpi̱ luhua xta̱chuná̱ qui̱taxtuy la̱mpala hua̱ Dios li̱quilhaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Chu̱ na̱ ni̱ pala hua̱ ca̱tiyatna̱ catili̱quilhántit xpa̱lacata̱ tu̱ nali̱ma̱lacnu̱yá̱tit, sa̱mpi̱ anta̱ u̱nú̱ ca̱tiyatna̱ li̱ma̱xtuy Dios xta̱chuná̱ antá̱ ma̱jaxay xtantú̱n, chu̱ na̱ ni̱ pala hua̱ Jerusalén cali̱quilhántit pala tu̱ nama̱lacnu̱yá̱tit, sa̱mpi̱ antá̱ c-Jerusalén huí̱ xpu̱ma̱paksí̱n tlanca̱ quireycan Dios cca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Chu̱ na̱ ni̱ pala huá̱ miakxe̱ka̱ catili̱quílhanti̱ pala tu̱ nama̱kantaxti̱putuna, sa̱mpi̱ huix ni̱ ma̱paksi̱ya, chu̱ ni̱ lay lakpali̱niya̱ la̱ntla̱ xli̱tzitzaka kantum miacchíxit pala snapapa̱ natlahuaya. ");
INSERT INTO tosNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Hua̱mpi̱ pala tu̱ nali̱kalhti̱nana̱ pi̱ natlahuaya, caj xma̱n cahuanti: ‘Tla̱n, nactlahuay’, usuchí̱ acxni̱ lacatancs catzi̱ya̱ pi̱ ni̱ lay catima̱kántaxti, huata caj xma̱n cahuanti: ‘Ni̱ ctitláhualh.’ Sa̱mpi̱ pala huix luhua li̱huana̱ ma̱catzi̱ni̱namputuna̱ pi̱ nama̱kantaxti̱ya̱ tu̱ ma̱lacnu̱ya, chu̱ li̱quilhana̱ hua̱ntu̱ huix li̱pa̱huana, pus antá̱ chú̱ makatlajayá̱n xali̱xcajnit talacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Huixín catzi̱yá̱tit la̱ntla̱ huampalay yama̱ li̱ma̱paksí̱n hua̱ntu̱ xamaka̱n quilhtamacú̱ tica̱makaxtaknicántit: ‘Lapi̱ cha̱tum nasi̱tzi̱niy, na̱ nata̱la̱huili̱niy xta̱chixcú, chu̱ nama̱xtuniy xlakastapu, usu nama̱acti̱niy xtatzán, pus na̱ luhua chuná̱ catlahuaca̱ la̱ntla̱ xlá̱ ma̱sipa̱ni̱ni̱t a̱cha̱tum laqui̱mpi̱ nali̱makaxokocán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Hua̱mpi̱ hua̱ chú̱ quit cca̱huaniyá̱n aktum tachihuí̱n hua̱ntu̱ luhua a̱tzinu̱ xatancsua: Ni̱ timakaxokoyá̱tit ti̱ ni̱tlá̱n tu̱ naca̱tlahuaniyá̱n, chi̱ hua̱mpi̱ hua̱ caxati̱cahuá̱ ti̱ xma̱sipa̱ní̱n c-milakxti̱pakstácat, calakxti̱pini̱ a̱lakxti̱tu. ");
INSERT INTO tosNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chu̱ hua̱nti̱ luhua chuná̱ catzi̱y nama̱lacapu̱yá̱n, chu̱ namaklhti̱putuná̱n mincamisa, pus cama̱xqui, hasta huata xatlá̱n na̱ cama̱xqui̱ talacasquín pi̱ na̱ nalé̱n mintamaknu. ");
INSERT INTO tosNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chu̱ palapi̱ cha̱tum xafuerza nama̱cuqui̱yá̱n pi̱ cali̱pini̱ xtacuca̱ ca̱na̱ caj aktum kilómetro xli̱lakamákat, huata huix cama̱li̱huaqui̱ni, ca̱na̱ a̱aktum kilómetro, tlak catlahuani̱ li̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chu̱ caxati̱cahuá̱ ti̱ nasquiniyá̱n hua̱ntu̱ qui̱tzanka̱niy, pus cama̱xqui, chu̱ niucxnicú̱ caj cakaxpatni̱ hua̱nti̱ squiniyá̱n, chu̱ hua̱nti̱ maksa̱cuanamputuná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Huixín na̱ lakapasá̱tit yuma̱ li̱ma̱paksí̱n hua̱ntu̱ maka̱n quilhtamacú̱ tica̱ma̱xqui̱cántit hua̱ntu̱ na̱má̱ huan: ‘Capa̱xqui̱ miamigo hua̱nti̱ pa̱xqui̱yá̱n, chi̱nchu̱ hua̱nti̱ ta̱la̱tlahuayá̱n, na̱ nata̱la̱tlahuaya.’ ");
INSERT INTO tosNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Hua̱mpi̱ hua̱ chú̱ quit lacatancs cca̱huaniyá̱n aktum tachihuí̱n hua̱ntu̱ a̱tzinu̱ xatancsua, pi̱ capa̱xquí̱tit minta̱la̱tlahuanacán, chu̱ casquinítit Dios xpa̱lacata̱ hua̱nti̱ ni̱ ca̱ucxilhputuná̱n pi̱ xlá̱ camaktá̱yalh. ");
INSERT INTO tosNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Hua̱ lapi̱ xli̱ca̱na̱ chuná̱ natlahuayá̱tit, pus Quintla̱ticán ti̱ huilachá̱ c-akapú̱n xlá̱ naca̱li̱pu̱lhca̱yá̱n la̱ntla̱ xli̱ca̱na̱ xcamán. Sa̱mpi̱ xlá̱ pacs acxtum tla̱n catzi̱niko̱y, chu̱ li̱pu̱tum ma̱xqui̱ko̱y cxkakanat chichiní̱ hasta ma̱squi hua̱ yama̱ chixcuhuí̱n hua̱nti̱ lacli̱xcajnit xtapuhua̱ncán, na̱ xa̱huá̱ hua̱nti̱ lacuan xtapuhua̱ncán, chu̱ na̱ huá̱ macamín se̱n c-xokspuncán hua̱nti̱ xatlá̱n, chu̱ hua̱nti̱ ni̱tla̱n xtá̱yat. ");
INSERT INTO tosNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Hua̱mpi̱ lapi̱ huixín caj xma̱n huá̱ pa̱xqui̱ko̱yá̱tit hua̱nti̱ na̱ ca̱pa̱xqui̱yá̱n, ¿tú̱ chú̱ ya̱ taskahu namaklhti̱naná̱tit c-xlacati̱n Dios caj xpa̱lacata̱ pi̱ chuná̱ natlahuayá̱tit? Sa̱mpi̱ hasta ma̱squi hua̱nti̱ lacli̱xcájnit xtapuhua̱ncán na̱ chuná̱ xlacán la̱ta̱lako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na̱ chuna li̱tum, lapi̱ caj xma̱n hua̱ li̱pa̱xuhu xakatli̱ko̱yá̱tit hua̱nti̱ catzi̱yá̱tit na̱ ca̱pa̱xqui̱yá̱n, ¿tú̱ chú̱ xli̱tlá̱n tlahuapá̱tit laqui̱mpi̱ naca̱ma̱skahui̱caná̱tit c-xlacati̱n Dios? Sa̱mpi̱ hasta ma̱squi yama̱ chixcuhuí̱n hua̱nti̱ ni̱ lakapasko̱y Dios na̱ chuná̱ tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chi̱ hua̱mpi̱ hua̱ntu̱ luhua xli̱ca̱na̱ aksti̱tum cakalhí̱tit mintalacapa̱stacnicán, xta̱chuná̱ la̱ntla̱ Quintla̱ticán ti̱ huilachá̱ c-akapú̱n aksti̱tum kalhi̱y xtalacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ca̱na̱ huixín, cuí̱ntaj catlahuátit pi̱ ni̱tú̱ titlahuayá̱tit mintalakalhama̱ncán c-xlacati̱ncan tachixcuhuí̱tat, laqui̱mpi̱ caj nali̱tlancaná̱tit, chu̱ tla̱n nali̱tasiyuyá̱tit. Sa̱mpi̱ hua̱ lapi̱ chuná̱ natlahuayá̱tit, yama̱ mintla̱tican Dios hua̱nti̱ huí̱ c-akapú̱n, cumu xlá̱ pacs lakapasa̱ mintalacapa̱stacnicán, pus ni̱tú̱ catica̱ma̱xquí̱n mintatlajancán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Huá̱ xpa̱lacata, acxni̱ huix nalakalhamanko̱ya̱ li̱ma̱xkaní̱n hua̱nti̱ xli̱ca̱na̱ tali̱ma̱xka̱ko̱y, pus ni̱ cali̱ta̱chihui̱nankó̱ xli̱pacs tachixcuhuí̱tat xta̱chuná̱ la̱ntla̱ tlahuako̱y hua̱nti̱ lakati̱ko̱y aksani̱nanko̱y, chu̱ antá̱ tzucuko̱y li̱chihui̱nanko̱y c-mimpu̱kalhtahuakacán, usu antá̱ c-tlanca̱ti̱. Huá̱ chuná̱ li̱tlahuako̱y laqui̱mpi̱ pacs nali̱ucxilhko̱cán xta̱chuná̱ la̱ lacuan chixcuhuí̱n. Hua̱mpi̱ luhua lacatancs cca̱huaniyá̱n pi̱ caj huá̱ xpa̱lacata̱ hua̱ntu̱ xlacán tlahuako̱y, pus chuná̱ chú̱ ta̱ksko̱ni̱t hua̱ntu̱ luhua xputzama̱kó̱ xpa̱lacata naca̱cni̱nanicán, pero pacsá ma̱skahui̱ko̱cani̱t nahuán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Hua̱mpi̱ huata acxni̱ huix pala ti̱ lakalhamanko̱ya̱ li̱ma̱xkaní̱n hua̱nti̱ xli̱ca̱na̱ tali̱ma̱xka̱ko̱y, pus ni̱ pala cali̱ta̱chihuí̱nanti̱ hasta ma̱squi hua̱nti̱ luhua a̱tzinu̱ tali̱pa̱hu miamigo. ");
INSERT INTO tosNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Huata caj xma̱n huix miacstu̱ caj tze̱k cali̱catzi̱ hua̱ntu̱ tla̱n tlahuani̱ta. Cha̱nchu̱ hua̱ Quintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n xlá̱ pacs catzi̱y hua̱ntu̱ caj tze̱k tlahuápa̱t, pus huata xlá̱ luhua lhu̱hua nama̱xqui̱yá̱n hua̱ntu̱ nata̱qui̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Chu̱ na̱ chuna li̱tum acxni̱ tlahuayá̱tit mioracioncán, ni̱ chuná̱ catlahuátit la̱ntla̱ tlahuako̱y hua̱nti̱ caj akskahuimi̱nanko̱y. Xlacán lakati̱ko̱y kalhtahuakata̱yako̱y c-templo, xa̱huá̱ c-xcha̱stu̱ni̱n tlanca̱ti̱ anta̱ni̱ luhua lhu̱hua̱ tzamacán laqui̱mpi̱ pacs mat naucxilhko̱y hua̱ntu̱ xlacán tlahuako̱y. Huata quit luhua lacatancs cca̱huaniyá̱n pi̱ caj xpa̱lacata hua̱ntu̱ xlacán tlahuako̱y, pus chuná̱ chú̱ pacsá ta̱ksko̱ni̱t hua̱ntu̱ xputzama̱kó̱ pi̱ naca̱cni̱naniko̱cán, chu̱ aya ma̱skahui̱ko̱cani̱t nahuán sa̱mpi̱ nia̱lh tú̱ catimakamaklhti̱nanko̱lh c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Hua̱mpi̱ acxni̱ huix natlahuaniya̱ oración miDios, huata xatlá̱n miacstu̱ catanu̱ c-mínchic, li̱huana̱ cama̱lacchuhua̱ mimá̱laccha, antá̱ chú̱ catlahua̱ mioración, caxakatli̱lacapi̱ Quintla̱ticán Dios, sa̱mpi̱ xlá̱ lacxtum ta̱huilán ma̱squi ni̱ tasiyuy. Chú̱ pi̱ Quintla̱ticán ucxilhma̱ pi̱ tla̱n hua̱ntu̱ huix tlahuápa̱t, pus luhua xli̱ca̱na̱ pi̱ huá̱ nama̱xqui̱yá̱n mintata̱quí̱n hua̱ntu̱ lakcha̱ná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Hua̱mpi̱ acxni̱ natlahuaya̱ mioración, ni̱ maklhu̱hua̱ tihuana̱ tu̱ huatiya tachihuí̱n tu̱ ni̱ kalhi̱y xlakasi, xta̱chuná̱ la̱ntla̱ tlahuako̱y hua̱nti̱ ni̱ lakapasko̱y Dios, chu̱ xlacán puhuanko̱y pi̱ Dios nakaxmatniko̱y la̱ntla̱ makcatzi chihui̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pus huixín ni̱ chuná̱ catzi̱yá̱tit la̱ntla̱ xlacán, sa̱mpi̱ huá̱ Quintla̱tican Dios, xlá̱ aya catzi̱y hua̱ntu̱ huixín ca̱tzanka̱niyá̱n, ma̱squi hasta ni̱ a̱squiniyá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chuna̱ na̱má̱ huixín nahuaná̱tit acxni̱ natlahuayá̱tit mioracio̱ncán: ‘Huix Quintla̱ticán ti̱ huilapi̱ c-akapú̱n, Caj xma̱n huix mini̱niyá̱n naca̱cni̱nanicán mintucuhuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Camilh mili̱ma̱paksí̱n u̱nú̱ c-quilaksti̱pa̱ncán. Laqui̱mpi̱ xli̱ca̱tlanca̱ ca̱tiyatna̱ ma̱kantaxti̱má̱caj nahuán mili̱ma̱paksí̱n, la̱ntla̱ ma̱kantaxti̱ma̱canchá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hua̱ntu̱ la̱nchú̱ cmaclacasquina̱hu quinchujcán caquinca̱ma̱xqui. ");
INSERT INTO tosNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Na̱ caquinca̱ma̱tzanka̱nani̱ xli̱pacs hua̱ntu̱ ni̱tlá̱n cca̱tlahuanini̱tán, na̱ chuná̱ la̱ntla̱ quin cma̱tzanka̱naniko̱ya̱hu hua̱nti̱ quinca̱ta̱la̱tlahuani̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ni̱ caquinca̱makáxtakti̱ laqui̱mpi̱ pala ti̱ naquinca̱ma̱tlahui̱yá̱n tala̱kalhí̱n, huata caquinca̱ma̱pa̱nu̱ni̱ xli̱pacs hua̱ntu̱ xquinca̱ma̱tlahuí̱n tu̱ ni̱tlá̱n. Sa̱mpi̱ huata huix mini̱niy nama̱paksi̱nana̱ c-quilatama̱tcán, chu̱ ni̱tí̱ ma̱ta̱xtuca̱ mili̱tlihuaka, chu̱ huata huix mini̱niy nacca̱cni̱naniya̱hu xli̱tlanca mili̱ca̱cni̱ caxani̱li̱huayaj xtihua̱. Chuná̱ calalh, Amén.’ ");
INSERT INTO tosNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pus lapi̱ nama̱tzanka̱naniko̱yá̱tit a̱makapitzí̱n hua̱nti̱ ca̱makasi̱tzi̱yá̱n, na̱ chuná̱ Mintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n naca̱ma̱tzanka̱naniyá̱n xli̱pacs hua̱ntu̱ ni̱tlá̱n tlahuani̱tántit. ");
INSERT INTO tosNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Hua̱mpi̱ hua̱ lapi̱ huixín ni̱ nama̱tzanka̱naniko̱yá̱tit hua̱nti̱ ca̱makasi̱tzí̱n, pus na̱ chuná̱ Mintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n ni̱ lay catica̱ma̱tzanka̱nanín mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Acxni̱ namakalhkajnaná̱tit laqui̱mpi̱ naca̱cni̱naniyá̱tit Dios, pus ni̱ cali̱ma̱siyútit pala luhua lacali̱puhuampá̱tit caj c-milacancán, chuná̱ la̱ntla̱ tlahuako̱y hua̱nti̱ akskahuimi̱nanko̱y. Huá̱ chuná̱ xlacán li̱tlahuako̱y laqui̱mpi̱ pacs nacatzi̱cán pi̱ mat makalhkajnanko̱y. Quit xli̱ca̱na̱ cca̱huaniyá̱n pi̱ caj xpa̱lacata hua̱ntu̱ xlacán tlahuako̱y c-xlacati̱ncan a̱makapitzí̱n, pus aya makamaklhti̱nanko̱ni̱t xtaskahucán hua̱ntu̱ xputzama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hua̱mpi̱ hua̱ huix acxni̱ makalhkajnana̱ xpa̱lacata naca̱cni̱naniya̱ Dios, li̱huana̱ calakachákanti, chu̱ caácxquitti ");
INSERT INTO tosNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","laqui̱mpi̱ xli̱lhu̱hua chixcuhuí̱n ni̱ nacatzi̱ko̱y pala huix makalhkajnámpa̱t. Huata caj xma̱n hua̱ Mintla̱ticán hua̱nti̱ catzi̱y hua̱ntu̱ huix tlahuápa̱t, chu̱ cumu xlá̱ acxtum ta̱lamá̱n, pus nama̱xqui̱yá̱n mintata̱quí̱n hua̱ntu̱ lakcha̱ná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ni̱ ca̱ta catu̱huá̱ cama̱makstokuilí̱tit hua̱ntu̱ xtapalh tumi̱n laqui̱mpi̱ nama̱tamacu̱ni̱naná̱tit u̱nú̱ ca̱tiyatna, sa̱mpi̱ antá̱ u̱nú̱ catu̱huá̱ pacs ma̱laksputuy xalu̱hua, chu̱ pacs laktzanka̱ko̱y, xa̱huá̱ u̱nú̱ tzamay hua̱nti̱ tla̱n nakalhanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Huata luhua xatlá̱n pi̱ caj luhua lhu̱hua̱ hua̱ntu̱ lacuan tatlahu catlahuátit, chu̱ luhua xta̱chuná̱ la̱ntla̱ a̱li̱sok cama̱akstokuili̱pi̱ mintumi̱n c-akapú̱n anta̱ni̱ niucxni̱ lay pasay xalu̱hua, chu̱ ni̱ ma̱laktzanka̱y, ");
INSERT INTO tosNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sa̱mpi̱ anta̱ni̱ huixín nahuili̱yá̱tit mintapa̱xuhua̱ncán xta̱chuná̱ pala lhu̱hua mintumincán nama̱makstokuili̱yá̱tit c-milatama̱tcán, pus na̱ antá̱ namakaxtaká̱tit mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Milakastapucán xta̱chuná̱ la̱ntla̱ mákskot hua̱ntu̱ makskolé̱n xli̱pacs mincha̱tumi̱nica. Pus lapi̱ huá̱ tla̱n milakastapu, xli̱tlanca̱ c-mincha̱tumi̱nica̱ nakalhi̱yá̱ xkakánat. ");
INSERT INTO tosNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Chi̱ hua̱ lapi̱ hua̱ milakastapu̱ ni̱tlá̱n li̱lacahua̱nana, pus xli̱tlanca mincha̱tumi̱nica̱ xalakapoklhua li̱lámaj nahuán. Chuná̱ pi̱ lapi̱ hua̱ntu̱ li̱lacahua̱nana̱ ni̱ kalhi̱y hua̱ntu̱ tla̱n xkakánat xli̱ca̱na̱ pi̱ xaaktzanká̱n lápa̱t nahuán c-milatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ni̱ pala cha̱tum chixcú̱ tla̱n ta̱scujko̱y cha̱tuy ma̱la̱ná̱ aktuma quilhtamacú̱, sa̱mpi̱ acxni̱ nata̱scuja, chu̱ nakalhakaxmata̱ cha̱tum, pus hua̱ chú̱ cha̱tum li̱tum fuerza̱ nakalhakaxmatmakán, chu̱ ni̱ nama̱xqui̱y ca̱cni. Xa̱huachí̱ ni̱ lay catitá̱scujli sa̱mpi̱ ni̱ catitláhualh hua̱ntu̱ nali̱ma̱paksi̱cán. Pus quit clacasquín pi̱ luhua li̱huana̱ caakatá̱kstit hua̱ntu̱ cuaniputún: Cha̱tum chixcu ni̱ lay li̱pa̱huán Dios la̱ntla̱ xpu̱chiná, chu̱ natlahuay hua̱ntu̱ li̱ma̱paksi̱y, chu̱ lapi̱ na̱ huatiya̱ yama̱ quilhtamacú̱ nali̱pa̱huampalay xtumi̱n la̱ntla̱ xpu̱chiná̱ hua̱nti̱ nakalhakaxmata̱ hua̱ntu̱ nali̱ma̱paksi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pus na̱ chuna li̱tum luhua clacasquín pi̱ caakatá̱kstit hua̱ntu̱ cca̱huaniyá̱n: Ni̱ a̱huan huá̱ tili̱lakaputzayá̱tit pala tu̱ nahuayá̱tit cha̱li̱ cha̱lí̱ laqui̱mpi̱ tla̱n nalatapa̱yá̱tit; usu xpa̱lacata mi̱lhaka̱tcán hua̱ntu̱ nali̱lhaka̱naná̱tit ni̱ taji̱ cali̱lakaputzátit. ¿Tú̱ huá̱ latáma̱t tlak xlacasquinca, ni̱ xahua̱ li̱stakuán? Chu̱ hua̱ macni, ¿tú̱ huá̱ tlak xlacasquinca, ni̱ xahua̱ talhaká̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Caucxílhtit lactzu̱ spu̱n hua̱ntu̱ kosko̱y ca̱u̱ní̱n, ni̱ chana̱nanko̱y, na̱ ni̱ xka̱nanko̱y, na̱ ni̱ pala ma̱qui̱ko̱y xlana̱natcán c-xpu̱ma̱qui̱cán; hua̱mpi̱ huata hua̱ Quintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n xlá̱ cha̱li̱ cha̱lí̱ ma̱xqui̱ko̱y xli̱huatcán hua̱ntu̱ tla̱n nali̱latama̱ko̱y, chu̱ stalanca catzi̱yá̱tit pi̱ huixín xaa̱li̱huaca lhu̱hua̱ xtápalh huixín ni̱ xahua̱ xlacán. ");
INSERT INTO tosNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pus luhua caj caquinca̱huanítit: ¿Tí̱ cha̱tum huixín, hua̱ caj xpa̱lacata xta̱klituán tla̱n nama̱tla̱ni̱y nama̱li̱huaqui̱y ca̱na̱ caj aktum hora xlatáma̱t lapi̱ aya ni̱majá? ");
INSERT INTO tosNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Chu̱ huá̱ xpa̱lacata mintalhaka̱ncán, ¿tú̱huan a̱huan huá̱ lacapa̱stacá̱tit? Cali̱ucxílhtit xánat xala ca̱pu̱cuxtú̱n, la̱ntla̱ stacko̱y. Ni̱ scujko̱y, chu̱ na̱ ni̱ pala sihuinanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hua̱mpi̱ luhua cca̱huaniyá̱n pi̱ hasta ni̱ pala hua̱ yama̱ xamaka̱n ma̱tamacu̱nu rey Salomón, ma̱squi xli̱ca̱na̱ pi̱ luhua ca̱ta lacli̱pe̱cua xalacuan lháka̱t hua̱ntu̱ xlá̱ xlhaka̱ko̱y, niucxnicú̱ ma̱tá̱xtucli̱ laqui̱mpi̱ chuná̱ nalhaka̱nán luhua li̱lakáti̱t xta̱chuná̱ la̱ntla̱ tasiyuko̱y yama̱ lactzu̱ xaxanat ca̱pu̱cuxtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Lapi̱ Dios chuná̱ lakli̱lakáti̱t ca̱xya̱huako̱y catu̱cahua̱ lactzu̱ tuhuá̱n hua̱ntu̱ la̱nchiyú̱ li̱lakáti̱t stakuanaya̱ c-pú̱cuxtu, hua̱mpi̱ caj cha̱li̱ tu̱xama̱ naxnakko̱y, naca̱cán, chu̱ natamacapu̱cán clhcúya̱t, ¿pi̱ puhuaná̱tit chú̱ pi̱ huata huixín ni̱ luhua catica̱li̱ta̱katzanká̱n? ¡Xli̱ca̱na̱ luhua mákat makatzanka̱yá̱tit, sa̱mpi̱ ni̱ lay aksti̱tum li̱pa̱huaná̱tit! ");
INSERT INTO tosNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Huá̱ xpa̱lacata cca̱li̱huaniyá̱n, ni̱ luhua a̱huan huá̱ nali̱lakaputzayá̱tit hua̱ntu̱ tla̱n nali̱hua̱yaná̱tit, usu hua̱ntu̱ nali̱lhaka̱naná̱tit cha̱li̱ tu̱xama. ");
INSERT INTO tosNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sa̱mpi̱ lhu̱hua̱ hua̱nti̱ ni̱ lakapasko̱y Dios caj luhua xma̱n huá̱ li̱lakaputzako̱y, hua̱mpi̱ ni̱ chuná̱ camacasta̱lakó̱tit hua̱ntu̱ xlacán tlahuama̱kó̱, sa̱mpi̱ huixín kalhi̱yá̱tit cha̱tum Mintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n hua̱nti̱ naca̱maktakalhá̱n, xlá̱ aya catzi̱y hua̱ntu̱ huixín ca̱qui̱tzanka̱niyá̱n cha̱li̱ cha̱lí̱. ");
INSERT INTO tosNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hua̱mpi̱ huata huixín xatlá̱n huá̱ calakpuhualacapítit la̱ntla̱ huí̱ xli̱ma̱paksi̱n Dios, xa̱huachí̱ cali̱tzaksátit natlahuayá̱tit hua̱ntu̱ xlá̱ lakati̱y. Lapi̱ chuná̱ natlahuayá̱tit ni̱tu̱ capuhuántit, xlá̱ naca̱ma̱xqui̱yá̱n pacs hua̱ntu̱ caqui̱tzanka̱niyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Chuná̱ pi̱ ni̱ huá̱ naucxilhlacachipítit hua̱ntu̱ namaclacasquiná̱tit xala cha̱li̱ quilhtamacú̱, usu xala tu̱xama, sa̱mpi̱ la̱ntla̱ cha̱li̱ cha̱li̱ xkakati̱lhay acxnicú̱ natasiyuy xatú̱ ta̱klituán li̱mín yuma̱ quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Niucxni̱ huix xaankalhí̱n putza̱nanípa̱t nahuán xtala̱kalhí̱n hua̱ntu̱ tla̱n nali̱ya̱huaya̱ minta̱lá, laqui̱mpi̱ a̱li̱sta̱lh na̱ ni̱ chuná̱ putzámaj nahuán mintala̱kalhí̱n hua̱ntu̱ tla̱n nali̱ya̱huayá̱n, chu̱ chuná̱ chú̱ nama̱xoko̱ni̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa̱mpi̱ Dios na̱ chuná̱ naca̱putza̱naniyá̱n mintala̱kalhí̱n la̱ntla̱ huix putza̱naniko̱ya̱ xtala̱kalhi̱ncán a̱makapitzí̱n minata̱lancán. Na̱ chuná̱ la̱ntla̱ tu̱ tlahuaniya̱ minta̱lá, xlá̱ na̱ chuná̱ natamakapu̱spitniyá̱n, sa̱mpi̱ mili̱catzi̱tcán pi̱: huá̱ li̱lhca̱ tu̱ li̱lhca̱naná̱tit, na̱ huá̱ naca̱li̱lhca̱caná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chu̱ na̱ chuná̱ chú̱, ¿lá̱ntla̱ pi̱ tla̱n li̱ucxilhniya̱ yama̱ actzu̱ pokxni̱ tu̱ lacpi̱tanu̱ma̱ c-xlakastapu̱ minta̱lá, pala huata huix ni̱ tzinú̱ makcatzi̱ya̱ pala c-milakastapu̱ lacpi̱tanu̱má̱n tzinú̱ tlak tlanca palhma? ");
INSERT INTO tosNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na̱ chuna li̱tum, lapi̱ huix ni̱ catzi̱ya̱ pi̱ na̱ talakpi̱xtapuni̱ta, ¿lá̱ntla̱ chú̱ tla̱n li̱catzi̱ya̱ nahuaniya̱ minta̱lá: ‘Cakalhkalhi̱ka̱ya̱ tzinú̱ xli̱makua̱ u̱cma̱xtuniyá̱n tama̱ actzu̱ pokxni̱ hua̱ntu̱ lacpi̱tanu̱má̱n c-milakastapu’? ");
INSERT INTO tosNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Aksani̱ná, huata xapu̱lh cama̱xtu̱ tama̱ tlak tlanca pokxni̱ tu̱ lacpi̱tanu̱má̱n, laqui̱mpi̱ chuná̱ tla̱n nalacahua̱nana, chu̱ luhua tla̱n chi̱nchu̱ nama̱xtuniya̱ yama̱ actzu̱ pokxni̱ hua̱ntu̱ lacpi̱tanu̱ma̱ minta̱lá. ");
INSERT INTO tosNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ni̱ tima̱xqui̱ko̱yá̱tit chichí̱ hua̱ntu̱ xasa̱ntujlani lí̱huat, chi̱mpala xamaktum caj nasi̱tzi̱y, chu̱ natapu̱spitko̱y, chu̱ naca̱xcayá̱n. Chu̱ na̱ ni̱ pala huá̱ paxni̱ camacapinikó̱tit xalactapala̱xlá, chu̱ lacuan mintapixnu xla perlas laqui̱mpi̱ xlacán caj nalacta̱yami̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ankalhí̱n casquinítit Dios hua̱ntu̱ maclacasquiná̱tit, chu̱ xlá̱ naca̱ma̱xqui̱yá̱n; hua̱ntu̱ xatlá̱n talacapa̱stacni̱ caputzátit, chu̱ nata̱ksá̱tit; calakatláktit má̱laccha, chu̱ chuná̱ naca̱ma̱lacqui̱nicaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sa̱mpi̱ caxati̱cahuá̱ ti̱ squin, ma̱xqui̱cán; chu̱ hua̱nti̱ putzay, ta̱ksa; chu̱ hua̱nti̱ lakatlaka̱ má̱laccha, ma̱lacqui̱nicán. ");
INSERT INTO tosNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Lapi̱ cha̱tum huixín huí̱ actzu̱ minkahuasa, ¿pi̱ huata nama̱xqui̱ya̱ aktum chíhuix acxni̱ xlá̱ nasquiniyá̱n mactum caxtala̱nchu̱? ");
INSERT INTO tosNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Usu pala squi̱ti̱ csquinín, hua̱ la̱ntla̱ xma̱xqui̱ squi̱ti, ¿pi̱ huata lu̱hua̱ nama̱xqui̱ya? ");
INSERT INTO tosNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Huixín xala ca̱tuxá̱huat, chu̱ chuná̱ li̱smani̱ni̱tántit tlahuayá̱tit lhu̱hua̱ tu̱ ni̱ tla̱n, hua̱mpi̱ ma̱squi chuná, huixín fuerza̱ catzi̱yá̱tit la̱ntla̱ tu̱ tla̱n xli̱huatcán nama̱xqui̱yá̱tit mincamancán, pus ¿tu̱ xali̱huacá̱ Mintla̱ticán ti̱ ankalhí̱n tla̱n catzi̱ya̱chá̱ c-akapú̱n, naca̱ma̱xqui̱yá̱n xalacuan talacapa̱stacni̱ acxni̱ huixín nasquiniyá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chuna̱mpi̱ lacatancs cca̱huaniyá̱n pi̱ xli̱ankalhí̱n catlahuanikó̱tit li̱tlá̱n a̱makapitzí̱n xta̱chuná̱ la̱ntla̱ huixín lacasquiná̱tit xlacán xca̱tlahuanikó̱n li̱tlá̱n. Sa̱mpi̱ xli̱ca̱na̱ pi̱ la̱ntla̱ kampa̱lhu̱hua xli̱ma̱paksí̱n hua̱ntu̱ tili̱ma̱paksí̱nalh Moisés, xa̱hua̱ hua̱ntu̱ maká̱n titzokuili̱ko̱lh c-xlibro̱can profetas, caj xma̱n hua̱ yuma̱ kampa̱tum li̱tapu̱lhca̱y hua̱ntu̱ chuná̱ huan: ‘Calakalhámanti̱ xli̱pacs a̱makapitzí̱n chuná̱ la̱ntla̱ta huix acstulakalhamancana’. ");
INSERT INTO tosNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Hua̱nti̱ luhua xli̱ca̱na̱ lakma̱xtuputún xli̱stacna, luhua fuerza̱ catlahuánilh cali̱tzáksalh pi̱ antá̱ nalactanu̱y c-xati̱tzu̱ má̱laccha. Sa̱mpi̱ na̱ huí̱ xati̱tlanca má̱laccha̱ anta̱ni̱ ni̱ pala tzinú̱ tuhua̱ lactanu̱cán, chu̱ na̱ chuná̱ ti̱tlanca tiji̱ anta̱ni̱ ni̱ tuhua̱ lactla̱huancán, chu̱ lhu̱hua̱ ti̱ antá̱ lactla̱huanko̱y, hua̱mpi̱ hua̱nti̱ antá̱ naanko̱y pus lacatancs pi̱ caj c-pu̱laktzanká̱n lacaya̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Hua̱mpi̱ huata ti̱tzú̱ ma̱laccha̱ anta̱ni̱ luhua tuhua̱ lactanu̱cán, xa̱huá̱ yama̱ tiji̱ anta̱ni̱ luhua ca̱laktzú̱, chu̱ ni̱ lhu̱hua̱ lactla̱huanko̱y sa̱mpi̱ antá̱ luhua tuhua̱ lactla̱huancán, xlá̱ ti̱tum naca̱li̱cha̱ná̱n anta̱ni̱ namakamaklhti̱naná̱tit latáma̱t c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ca̱na̱ huixín, cui̱ntaj caca̱tlahuacántit pi̱ ni̱ naca̱akskahuiyá̱n hua̱nti̱ caj akskahuimi̱nanko̱y, xlacán huanko̱y pi̱ mat huá̱ li̱chihui̱nama̱kó̱ xtachihui̱n Dios. Luhua tla̱n la̱ntla̱ kalhchihui̱nanko̱y xta̱chuná̱ la̱ntla̱ lacma̱ntzu̱ calhni̱lu̱ li̱taxtuko̱y la̱ntla̱ tasiyuko̱y laqui̱mpi̱ tla̱n natalacatzuhui̱niyá̱n, hua̱mpi̱ c-xpu̱lacnicán xta̱chuná̱ la̱ntla̱ xalaclu̱cu̱ la̱páni̱t hua̱nti̱ huananko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Huixín hua tuncán nali̱lakapasko̱yá̱tit tu̱ luhua xta̱yatcán caj xpa̱lacata li̱xcájnit hua̱ntu̱ tlahuako̱y c-xlatama̱tcán. Huixín stalanca catzi̱yá̱tit pi̱ ni̱ makalacán uvas ca̱lhtucu̱ní̱n, na̱ ni̱ pala hua̱ higo puxcán ca̱kajní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Akatum quihui, lapi̱ tla̱n, huá̱ nali̱talakapasa̱ xtahuácat sa̱mpi̱ lacuán natahuacay; chu̱ hua̱ntu̱ ni̱tla̱n quihui, pus na̱ huá̱ xtahuácat nali̱talakapasa̱ pi̱ ni̱tlá̱n, sa̱mpi̱ ni̱ lacuán catitahuácalh xtahuácat. ");
INSERT INTO tosNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ni̱ pala akatum quihui̱ anán hua̱ntu̱ luhua xli̱ca̱na̱ tla̱n, pala chú̱ natzucuy tahuacay xtahuácat hua̱ntu̱ ni̱ lacuán; chu̱ ni̱ pala akatum quihui̱ hua̱ntu̱ ni̱ xatlá̱n, chú̱ natzucuy tahuacay hua̱ntu̱ luhua xalacuan xtahuácat. ");
INSERT INTO tosNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Xli̱pacs quihui̱ hua̱ntu̱ ni̱ lacuán tahuacay xtahuácat, ca̱tanca̱mi̱cán, chu̱ tamacapu̱cán c-lhcúya̱t laqui̱mpi̱ antá̱ nalaclhcutapu̱y; na̱ chuná̱ yuma̱ chixcuhuí̱n naakspulako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chuná̱ pi̱ huixín huá̱ nali̱lakapasko̱yá̱tit hua̱ntu̱ xlacán tlahuako̱y, sa̱mpi̱ luhua xta̱chuná̱ la̱ntla̱ akatum quihui̱ hua̱ xtahuácat li̱talakapasa̱ lapi̱ tla̱n usu ni̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ni̱ xli̱pacs hua̱nti̱ caj xquilhnicán quili̱huaniko̱y pi̱ quili̱pa̱huanko̱y la̱ntla̱ xpu̱chinacán natapaksi̱niko̱y Dios, huata caj xma̱n huá̱ hua̱nti̱ xli̱ca̱na̱ nama̱kantaxti̱ko̱y c-xlatama̱tcán hua̱ntu̱ xtalacasquin Quintla̱t hua̱nti̱ huilachá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Yama̱ quilhtamacú̱ acxni̱ nata̱tlahuako̱cán cue̱nta̱ tachixcuhuí̱tat c-xlacati̱n Dios, lhu̱hua̱ hua̱nti̱ naquihuaniko̱y: ‘Quimpu̱chinacán, quin xacli̱chihui̱nana̱hu mintachihuí̱n, caj mintucuhuiní̱ xacli̱quilhana̱hu tla̱n xacli̱tamacaxtuko̱ya̱hu cspiritu akskahuiní, xa̱hua̱ caj mintucuhuiní̱ tla̱n xacli̱tlahuako̱ya̱hu lhu̱hua lactlanca li̱ca̱cni.’ ");
INSERT INTO tosNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Hua̱mpi̱ quit chuná̱ nackalhti̱ko̱y: ‘Caquintapa̱nu̱nítit huixín hua̱nti̱ xli̱scujpá̱tit hua̱ntu̱ ni̱tlá̱n, sa̱mpi̱ quit niucxni̱ cca̱lakapasni̱tán lapi̱ xli̱ca̱na̱ xquili̱pa̱huaná̱tit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Caxati̱cahuá̱ ti̱ quinkalhakaxmata, chu̱ tzucuy tlahuay hua̱ntu̱ quit cuan luhua xta̱chuná̱ li̱taxtuy cha̱tum akskalalh chixcú̱ hua̱nti̱ tláhualh xchic, chu̱ li̱huana̱ putzay anta̱ni̱ tlanca chíhuix acnu̱y, usu chihuix lakslamahuili̱y anta̱ni̱ ya̱huay xtalaya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Acxni̱ chú̱ milh tlanca se̱n, stacná̱nalh c-kalhtu̱choko̱, chu̱ li̱pe̱cua̱ ú̱nalh anta̱ni̱ xyá̱ yama̱ chiqui. Pero ma̱squi chuná̱ lalh, yama̱ chiqui̱ ni̱ pala tzinú̱ láca̱lh, sa̱mpi̱ xatalaya̱hu li̱huana̱ xma̱ti̱ju̱cani̱t c-xlaksti̱pa̱n chíhuix. ");
INSERT INTO tosNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Hua̱mpi̱ na̱ chuna li̱tum, lama̱palakó̱ hua̱nti̱ na̱ quinkaxmatniko̱y hua̱ntu̱ quit cuan, hua̱mpi̱ cumu ni̱ tlahuako̱y hua̱ntu̱ cli̱ma̱paksi̱ko̱y, pus xlacán luhua xta̱chuná̱ li̱taxtuko̱y la̱ntla̱ cha̱tum chixcú̱ xatu̱ntu̱, hua̱nti̱ tlahuay xchic c-xokspun cucu̱, usu caj xli̱ma̱n tíyat ni̱ xapalha. ");
INSERT INTO tosNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Acxni̱ chú̱ milh tlanca se̱n, tla̱n stacli̱ kalhtu̱choko̱, chu̱ luhua li̱pe̱cua̱ la̱ntla̱ ú̱nalh, pus como tla̱n milh u̱n, ¡hua̱ yuma̱ chiqui̱ ma̱akpu̱spitca̱, maktum laksputtámalh!” ");
INSERT INTO tosNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Acxni̱ Jesús chihui̱nanko̱lh, hua̱ yuma̱ chixcuhuí̱n cacs lacahuanko̱lh caj xpa̱lacata xtakalhchihuí̱n hua̱ntu̱ xlá̱ xma̱siyuni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Sa̱mpi̱ xli̱pacs hua̱ntu̱ xli̱ma̱paksi̱ko̱y, xuaniko̱y la̱ntla̱ ti̱ xli̱ca̱na̱ kalhi̱y talulóktat, chu̱ li̱ma̱paksí̱n, chu̱ ni̱ caj xta̱chuná̱ la̱ntla̱ laktzokqui̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Acxni̱ tita̱ctachi̱ c-ka̱stí̱n, luhua lhu̱hua̱ tachixcuhuí̱tat csta̱lanima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Cha̱nchu̱ antá̱ c-tiji̱ laktalacatzúhui̱lh cha̱tum chixcú̱ hua̱nti̱ xkalhi̱y kampa̱tu li̱xcajnit tzitzi̱ huanicán lepra. Acxni̱ lákchilh lakatatzokóstalh c-xlacatí̱n, chu̱ na̱má̱ huánilh: —Lapi̱ huix chuná̱ lacasquina caquima̱pacsani̱ la̱ntla̱ ckalhi̱y quintzitzi. ");
INSERT INTO tosNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús lakalhámalh, li̱chípalh xmacán c-xmacni, chu̱ na̱má̱ huánilh: —Chuná̱ clacasquín, la̱nchuj tuncán capacsti. Acxni̱ chuná̱ huanko̱lh, yama̱ ta̱tatlá, tuncán pacsli. ");
INSERT INTO tosNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ali̱sta̱lh Jesús na̱má̱ huánilh: —Luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n ni̱tí̱ cali̱ta̱chihuí̱nanti. Huata caj xma̱n calakpimpi̱ cha̱tum pa̱li̱ c-templo, huá̱ cama̱xqui̱ miofrenda̱ hua̱ntu̱ tili̱ma̱paksí̱nalh Moisés xamaka̱n quilhtamacú̱ laqui̱mpi̱ acxni̱ xlá̱ naucxilhá̱n nama̱luloka, chu̱ xli̱pu̱tum nacatzi̱cán pi̱ huix aya pacsni̱ta̱ yama̱ mintajátat hua̱ntu̱ xkalhi̱ya. ");
INSERT INTO tosNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Acxni̱ Jesús cha̱lh c-aktum ca̱chiquí̱n huanicán Capernaum lacapala̱ laktalacatzúhui̱lh cha̱tum xapuxcu tropa̱; xlá̱ tzúculh squiniy aktum li̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Chuná̱ huánilh: —Quimpu̱chinacan Jesús, c-quínchic caj má̱ cha̱tum quiscujni, xaní̱n huani̱t c-xnújut na̱ li̱pe̱cua̱ catza̱ni̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Cha̱nchu̱ Jesús huánilh: —Quit nacán ma̱pacsay. ");
INSERT INTO tosNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hua̱mpi̱ yama̱ capitán na̱má̱ kálhti̱lh: —Tla̱ti, xli̱ca̱na̱ pi̱ huix luhua xasa̱ntujlani, cumu ni̱ chuná̱ quit ni̱mpala tzinú̱ quimini̱niy pi̱ huix natanu̱ya̱pi̱ c-quínchic. Huata xatlá̱n caj kalhtum tachihuí̱n cahuanti, cama̱paksí̱nanti, chu̱ yama̱ quiscujni̱ napacsa, sa̱mpi̱ cli̱pa̱huaná̱n, chu̱ ccatzi̱y pi̱ hua̱ntu̱ huix nali̱ma̱paksi̱nana, chuná̱ nalay. ");
INSERT INTO tosNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Huá̱ chuná̱ cli̱huanimá̱n sa̱mpi̱ quit soldado, chu̱ na̱ huí̱ hua̱nti̱ quima̱paksi̱ko̱y lactlanca quinapuxcún. Xa̱huá̱ chú̱ quit na̱ huilakó̱ quintropa̱ hua̱nti̱ cma̱paksi̱ko̱y; acxni̱ cuaniy cha̱tum pala ní̱ caalh, pus xlá̱ an; chu̱ acxni̱ cuanipalay cha̱tum pi̱ camilh, xlá̱ namín; chu̱ acxni̱ chú̱ cli̱ma̱paksi̱y quintasa̱cua̱ pala tú̱ catláhualh, xlá̱ lacapala̱ tlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Acxni̱ Jesús káxmatli̱ hua̱ntu̱ xlá̱ huánilh luhua cacs li̱lacahua̱, puschí̱ na̱má̱ huaniko̱lh hua̱nti̱ csta̱lanima̱kó̱: —Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ la̱ntla̱ xli̱ca̱tlanca c-xatiyat Israel ni̱tí̱ quit ca̱ma̱noklhuy hua̱nti̱ luhua xli̱ca̱na̱ naquili̱pa̱huán la̱ntla̱ quili̱pa̱huán yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pus chú̱ luhua lacatancs cca̱huanimá̱n hua̱ntu̱ naqui̱taxtuy a̱li̱sta̱lh: la̱ntla̱ xli̱ca̱tlanca ca̱tuxá̱huat lhu̱hua̱ hua̱nti̱ ni̱tú̱ xlakasicán li̱ma̱xtuko̱cán sa̱mpi̱ ni̱ judíos, hua̱mpi̱ huá̱ xlacan tla̱n nalakcha̱nko̱y anta̱ni̱ huilachá̱ Dios c-akapú̱n; xlacán antá̱ macxtum namaktahuilako̱y c-pu̱hua̱y anta̱ni̱ pu̱tum nata̱hua̱yanko̱ya̱chá̱ xalakmaka̱n quinatla̱tnacan Abraham, Isaac chu̱ Jacob. ");
INSERT INTO tosNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hua̱mpi̱ lhu̱hua̱ hua̱nti̱ luhua israelitas hua̱nti̱ xma̱lacnu̱niko̱cani̱t pi̱ nalakma̱xtuko̱cán, chu̱ xli̱tahuilatcán c-xpu̱tahui̱lhcán antá̱ c-xpa̱xtu̱n Dios, caj xpa̱lacata ni̱ ma̱kantaxti̱ko̱lh c-xlatama̱tcán hua̱ntu̱ xli̱ma̱paksi̱ko̱cani̱t, pus xlacán natamacaxtuko̱cán c-quilhtí̱n anta̱ni̱ luhua ca̱paklhtu̱tá̱. Koxutaní̱n xlacán, sa̱mpi̱ antá̱ natasako̱y, chu̱ nama̱lacsa̱ni̱ko̱y xtatzancán caj xpa̱lacata li̱pe̱cua̱ la̱ntla̱ napa̱ti̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Acxnitiyá̱ Jesús na̱má̱ huánilh yamá̱ capitán: —Capittá̱ c-mínchic, nia̱lh tú̱ capúhuanti, pus huata chuná̱ cakantáxtulh la̱ntla̱ huix ca̱najlani̱ta̱ pi̱ nalay. Xli̱ca̱na̱ xlá̱ pi̱ acxnitiyá̱ yama̱ tlanca̱liya̱ cscujni̱ capitán pacsli̱ la̱ntla̱ xta̱tatlay. ");
INSERT INTO tosNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Maktum quilhtamacú̱ acxni̱ Jesús alh c-xchic Pedro, antá̱ xlá̱ úcxilhli̱ xpu̱tiya̱tzi Pedro pi̱ xmá̱ c-xpu̱tama sa̱mpi̱ xli̱lama̱ palha lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Huata Jesús macachípalh c-xmacán, chu̱ acxni̱ tuncán makáxtakli̱ lhcúya̱t hua̱ntu̱ luhua xmakni̱ma̱; chu̱ yama̱ pusca̱t lacapala̱ tá̱qui̱lh, tzúculh ca̱xtlahuay xlí̱huat hua̱ntu̱ nata̱li̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cha̱nchu̱ a̱li̱sta̱lh acxni̱ aya ko̱tánu̱lh, luhua lhu̱hua ta̱tatlaní̱n li̱minica̱ c-chiqui̱ anta̱ni̱ xuí̱ Jesús. Huí̱ ti̱ xma̱xcajua̱li̱niko̱ni̱t xtalacapa̱stacnicán cspiritu akskahuiní, hua̱mpi̱ cumu Jesús kalhi̱y li̱tlihuaka, caj makatunu̱ cxakatli̱ko̱y, xpu̱tlakaxtuko̱y yama̱ akskahuiní̱n. Xa̱hua̱ chí̱ pacs ma̱pacsako̱lh xli̱kampa̱lhu̱hua tajátat hua̱ntu̱ xkalhi̱ko̱y ta̱tatlaní̱n hua̱nti̱ antá̱ xli̱miniko̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesús chuná̱ ma̱pacsako̱lh yama̱ ta̱tatlaní̱n, chu̱ li̱ma̱kantáxti̱lh c-xlatáma̱t hua̱ntu̱ xamaka̱n quilhtamacú̱ xli̱chihui̱nani̱ttá̱ profeta Isaías acxni̱ chuná̱ huá̱: “Pacs ma̱pacsako̱lh quintajatatcán, chu̱ ma̱pá̱nu̱lh quintacatzanajuatcán.” ");
INSERT INTO tosNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Acxni̱ Jesús úcxilhli̱ pi̱ luhua lhu̱hua̱ hua̱nti̱ xchima̱kó̱ anta̱ni̱ xuí̱ xlá, huaniko̱lh xli̱ma̱kalhtahuáka̱t pi̱ cataca̱xko̱lh laqui̱mpi̱ napa̱tacutko̱y c-xa̱quilhtu̱tu̱ ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cha̱tum saduceo laktalacatzúhui̱lh, chu̱ na̱má̱ huánilh: —Ma̱kalhtahuaka̱ná, quit na̱ csta̱laniputuná̱n la̱ntla̱ chá̱ cani̱cahuá̱ anta̱ni̱ napina. ");
INSERT INTO tosNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús kálhti̱lh: —Quit ni̱tú̱ ckalhi̱y, ni̱ xahua̱ la̱ntla̱ yama̱ lactzu̱ hue̱kni, xlacán kalhi̱ko̱y clhucucán anta̱ni̱ lhtatako̱y, xa̱huá̱ yama̱ lactzu̱ spu̱n pacs kalhi̱ko̱y xma̱sakacán; hua̱mpi̱ quit Xatalacsacni Chixcú, ni̱ ckalhi̱y anta̱ni̱ cma̱jaxay quiakxe̱ka̱ acxni̱ ctlakuán. ");
INSERT INTO tosNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cha̱tum li̱tum hua̱nti̱ na̱ xli̱ma̱kalhtahuáka̱t xuamputún chuná̱ huánilh: —Quimpu̱chiná, quit na̱ nacsta̱laniyá̱n, hua̱mpi̱ caquintima̱xqui̱ quilhtamacú̱ hasta acxni̱ nani̱y quintla̱t laqui̱mpi̱ nacma̱acnu̱ta̱qui̱y, chu̱ nacsta̱laniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús huánilh: —Lapi̱ xli̱ca̱na̱ huix quista̱laniputuna, chiyuj tuncán caquista̱lani, chu̱ camakaxtakkó̱ a̱makapitzí̱n hua̱nti̱ li̱taxtuko̱y la̱ntla̱ xaní̱n lama̱kó̱ laqui̱mpi̱ huá̱ cama̱acnu̱ko̱lh xta̱ni̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús lacapala̱ ta̱taju̱ko̱lh xli̱ma̱kalhtahuáka̱t c-aktum pu̱tacutnu̱ laqui̱mpi̱ antá̱ nacha̱nko̱y c-xa̱quilhtu̱tu ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni̱ naj pala mákat xanko̱y c-chúchut acxni̱ li̱pe̱cua̱ la̱ntla̱ tzúculh u̱nán, chu̱ na̱ chuná̱ li̱pe̱cua̱ tzúculh ta̱kaya̱huay chúchut; a̱tzinú̱ xuani̱t aya xma̱aktzijputuncán pu̱tacutnu. Jesús na̱ antá̱ xtaju̱ma̱ c-pu̱tacutnu̱ hua̱mpi̱ xlá̱ xmá̱, chu̱ clhtatama̱. ");
INSERT INTO tosNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xli̱ma̱kalhtahuaka̱t Jesús lacapala̱ ma̱stacni̱ko̱lh, chu̱ na̱má̱ huaniko̱lh: —Quimpu̱chinacán, ¡catlahua̱ li̱tlá̱n, caquinca̱makta̱ya sa̱mpi̱ cmu̱xtuma̱hu! ");
INSERT INTO tosNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hua̱mpi̱ huata xlá̱ na̱má̱ kalhti̱ko̱lh: —¿Tú̱ xpa̱lacata taji̱ pe̱cuampá̱tit? ¡Xli̱ca̱na̱ pi̱ huixín ni̱ luhua quili̱pa̱huaná̱tit! Huata xlá̱ lacapala̱ tá̱qui̱lh, li̱ma̱paksi̱ko̱lh u̱n chu̱ ta̱kaya̱huaná̱ pi̱ catacacsko̱lh, puschí̱ tuncán taca̱cacsko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Acxni̱ xlacán ucxilhko̱lh la̱ntla̱ ma̱paksi̱ko̱lh u̱n, chu̱ ta̱kaya̱huaná, lanaj tilacahuanko̱lh, na̱má̱ chú̱ tzúculh la̱kalhasquinko̱y: —¿Pus tú̱ ya̱ li̱tlihuaka̱ kalhi̱y yuma̱ chixcú, pi̱ hasta ma̱squi hua̱ u̱n, chu̱ ta̱kaya̱huaná kalhakaxmatko̱y acxni̱ xlá̱ ma̱paksi̱ko̱y? ");
INSERT INTO tosNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Acxni̱ Jesús tacutchá̱ c-xa̱quilhtu̱tu ta̱kaya̱huaná, antá̱ cha̱lh c-aktum tíyat huanicán Gadara, puschí̱ c-xtampi̱n sipi̱ anta̱ni̱ xma̱nu̱ko̱cán ni̱ní̱n taxtuko̱chi̱ cha̱tuy lacli̱xcajnit chixcuhuí̱n hua̱nti̱ xma̱xcahua̱li̱niko̱ni̱t xtalacapa̱stacnican akskahuiní sa̱mpi̱ xpa̱laktaju̱ma̱kó̱. Yuma̱ chixcuhuí̱n luhua laclu̱cu̱ xuanko̱ni̱t, chu̱ hasta yama̱ c-tiji̱ ni̱tí̱ luhua xlactla̱huán sa̱mpi̱ xpe̱cuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chu̱ la̱ntla̱ xtalacatzuhui̱ma̱kó̱ antá̱ xlá̱ ni̱ xyá̱ Jesús, caj xalán quilhanko̱lh: —¡Jesús! ¿Tú̱ xpa̱lacata quinca̱ta̱la̱tlahuaya? Caj luhua chuná̱ catzi̱ya, a̱li̱sok tani̱ta quinca̱ma̱pa̱ti̱ni̱ya sa̱mpi̱ huix xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cumu antá̱ lacatzú̱ xputxuanama̱kó̱ ta̱lhu̱hua paxni, ");
INSERT INTO tosNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","huata yama̱ cspiritucan akskahuiní na̱má̱ huaniko̱lh Jesús: —Lapi̱ naquinca̱tlakaxtuya̱ la̱ntla̱ cpa̱laktaju̱ma̱hu yuma̱ chixcuhuí̱n, pus luhua catlahua̱ li̱tlá̱n caquinca̱ma̱xqui̱ talacasquín nacpa̱laktaju̱ya̱hu yama̱ ta̱lhu̱hua paxni. ");
INSERT INTO tosNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús huaniko̱lh: —Pus tla̱n, antá̱ catanú̱tit. Cspiritucan akskahuiní̱ makaxtakko̱lh chixcuhuí̱n, huata huá̱ pa̱laktaju̱ko̱lh paxni. Xli̱pacs yama̱ paxni̱ tla̱n pe̱cuanko̱lh, tzúculh kosnanko̱y hasta cha̱nko̱lh anta̱ni̱ luhua c-xuástat, antá̱ lkan anko̱lh, hasta c-ta̱kaya̱huaná, pacs antá̱ jicsuako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yama̱ chixcuhuí̱n hua̱nti̱ xmaktakalhma̱kó̱ paxni, caj la̱ntla̱ xtape̱cuacán takosú̱n tza̱lako̱lh hasta cha̱nko̱lh ca̱chiquí̱n, chu̱ acxni̱ antá̱ cha̱nko̱lh xlacán tzúculh li̱chihui̱nanko̱y hua̱ntu̱ akspulako̱lh xpaxnicán, chu̱ na̱ chuná̱ li̱chihui̱nanko̱lh hua̱ la̱ntla̱ xpacsko̱ni̱t yama̱ chixcuhuí̱n hua̱nti̱ xapu̱lh xpa̱laktaju̱ma̱kó̱ cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Xli̱pu̱tum hua̱nti̱ xuilakó̱ ca̱chiquí̱n lacapala̱ anko̱lh anta̱ni̱ xlama̱chá̱ Jesús. Acxni̱ xlacán ucxilhko̱lh huaniko̱lh pi̱ catláhualh li̱tlá̱n catatampú̱xtulh c-xtiyatcán hua̱ntu̱ xlacán xma̱paksi̱ko̱y, chu̱ mákat caalh. ");
INSERT INTO tosNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pus huata Jesús táju̱lh c-pu̱tacutnu, tacutpalachá̱ c-xa̱quilhtu̱tu ta̱kaya̱huaná, chu̱ antá̱ cha̱nko̱lh anta̱ni̱ luhua xuí̱ xchic c-xaca̱chiqui̱n Capernaum. ");
INSERT INTO tosNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Antá̱ chú̱ xuilachá̱ acxni̱ li̱cha̱nica̱ cha̱tum chixcú̱ hua̱nti̱ xlu̱ntu̱nán, yama̱ ta̱tatlá̱ pu̱chaxna̱ xpu̱le̱ncán. Acxni̱ Jesús ucxilhko̱lh pi̱ yama̱ chixcuhuí̱n xli̱pa̱huanko̱y pi̱ tla̱n xlá̱ nama̱pacsay, na̱má̱ huánilh ta̱tatlá: —Tla̱ti, catahuixca̱ni, sa̱mpi̱ xli̱pacs mintala̱kalhí̱n aya cma̱tzanka̱nanini̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Hua̱mpi̱ makapitzi̱n laktzokqui̱naní̱n hua̱nti̱ antá̱ xlaya̱kó̱ xlacán tuncán na̱má̱ acstupuhuanko̱lh: “Yuma̱ chixcú̱ caj xpa̱lacata xtachihuí̱n li̱kalhakama̱nama̱, chu̱ ta̱la̱lacata̱qui̱ma̱ Dios.” ");
INSERT INTO tosNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Hua̱mpi̱ cumu Jesús cátzi̱lh hua̱ntu̱ xlacán xpuhuama̱kó̱ na̱má̱ huaniko̱lh: —¿Tú̱huan huixín luhua lacli̱xcájnit kalhi̱yá̱tit mintalacapa̱stacnicán? ");
INSERT INTO tosNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pus caquihuanítit, ¿xatú̱ a̱tzinú̱ ni̱ pala tuhua̱ ma̱kanta̱xti̱cán, pa̱ acxni̱ nahuaniya̱ cha̱tum ta̱tatlá: ‘Mintala̱kalhí̱n pacs cma̱tzanka̱naniyá̱n’, usuchí̱ lapi̱ nahuaniya: ‘Lacapala̱ cata̱qui, chu̱ catlá̱huanti’? ");
INSERT INTO tosNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pus chú̱ nacca̱ma̱siyuniyá̱n pi̱ quit xli̱ca̱na̱ ckalhi̱y li̱tlihuaka̱ u̱nú̱ ca̱tiyatna, chu̱ caj quintachihuí̱n tla̱n cli̱ma̱tzanka̱nán tala̱kalhí̱n. Xlá̱ xakátli̱lh yama̱ chixcú̱ hua̱nti̱ xlu̱ntu̱nán, na̱má̱ huánilh: —Huix cuanimá̱n, lacapala̱ cata̱qui, casacti̱ mimpu̱chaxna, chu̱ capit c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yama̱ chixcú̱ hua̱nti̱ xlu̱ntu̱nán lacapala̱ tá̱qui̱lh, táxtulh, chu̱ alh c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Acxni̱ hua̱nti̱ antá̱ xlaya̱kó̱ ucxilhko̱lh hua̱ntu̱ xlá̱ xtlahuani̱t tla̱n pe̱cuanko̱lh caj xpa̱lacata ca̱cni̱ko̱lh xtascújut, chu̱ tzúculh pa̱xcatcatzi̱niko̱y Dios caj xpa̱lacata cumu xlá̱ xma̱xqui̱ni̱t tlanca li̱tlihuaka̱ yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ali̱sta̱lh Jesús táxtulh, alh a̱lacatanu̱ ca̱chiquí̱n, chu̱ maktum acxni̱ xtla̱huama̱ c-tiji̱ úcxilhli̱ cha̱tum chixcú̱ xuanicán Mateo, antá̱ xlá̱ xuí̱ c-mesa c-xquilhti̱n oficina anta̱ni̱ xmakamaklhtinán xla impuestos hua̱ntu̱ xma̱ta̱ji̱nanima̱ca̱ Roma. Xlá̱ na̱má̱ huánilh: —Huix na̱ caquista̱lani. Pus yama̱ Mateo lacapala̱ lit tá̱yalh, akxtakuili̱ko̱lh xtascújut, chu̱ sta̱lánilh. ");
INSERT INTO tosNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ali̱sta̱lh Jesús antá̱ alh hua̱yán c-xchic Mateo, chu̱ na̱ luhua lhu̱hua chixcuhuí̱n hua̱nti̱ judíos xpuhuaniko̱y pi̱ pacs xaktzanká̱n xlama̱kó̱, xa̱hua̱ xma̱ta̱ji̱nani̱n impuestos hua̱nti̱ ni̱tú̱ xli̱ucxilhko̱cán, xlacán na̱ antá̱ xanko̱ni̱t makua̱yanko̱y; chu̱ na̱ antá̱ quilhpa̱xtum maktahuilako̱lh anta̱ni̱ xuí̱ Jesús, chu̱ xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hua̱mpi̱ makapitzi̱n xanapuxcun judíos hua̱nti̱ xuaniko̱cán fariseos, acxni̱ xlacán ucxilhko̱lh la̱ntla̱ xta̱huilako̱chá̱ c-mesa, xlacán na̱má̱ kalhasquinko̱lh xli̱ma̱kalhtahuaka̱t Jesús: —¿Tú̱ xpa̱lacata mima̱kalhtahuaka̱nacán lacxtum ta̱hua̱yanko̱y hua̱nti̱ xma̱ta̱ji̱naní̱n impuestos, chu̱ hua̱nti̱ luhua lacli̱xcajnit makla̱kalhi̱nani̱n chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cumu Jesús káxmatli̱ hua̱ntu̱ xlacán xquilhuama̱kó̱, na̱má̱ huaniko̱lh: —Ni̱tú̱ li̱maclacasquín ma̱cuchi̱ná̱ hua̱nti̱ tla̱n lama̱, chu̱ ni̱tú̱ kalhi̱y tajátat; hua̱mpi̱ hua̱nti̱ ta̱tatlako̱y maclacasquima̱kó̱ pi̱ nama̱pacsako̱y ma̱cuchi̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ luhua li̱huana̱ caakatá̱kstit hua̱ntu̱ huamputún xtachihui̱n Dios anta̱ni̱ chuná̱ na̱má̱ tatzoktahuilani̱t c-Li̱kalhtahuaka: ‘Quit ni̱ cma̱tla̱ni̱y caj xma̱n naquili̱ca̱xtlahua̱naniyá̱tit mintakalhi̱ncán hua̱ntu̱ makni̱ko̱yá̱tit c-quilacatí̱n, pus huata quit clacasquín pi̱ na̱ calakalhamankó̱tit a̱makapitzí̱n hua̱nti̱ na̱ aktzanka̱ta̱yama̱kó̱ c-xlatama̱tcán.’ Chu̱ na̱ chuna li̱tum, quit ni̱ huá̱ cmini̱t huaniko̱y pi̱ nalakpali̱ko̱y xtalacapa̱stacnicán hua̱nti̱ luhua xli̱ca̱na̱ lacuan xtalacapa̱stacnicán kalhi̱ko̱y, huata huá̱ cmini̱t tasaniko̱y hua̱nti̱ luhua makla̱kalhi̱naní̱n laqui̱mpi̱ quit naclakma̱xtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maktum li̱tum makapitzi̱n xli̱ma̱kalhtahuaka̱t Juan Bautista lakminko̱lh Jesús, na̱má̱ huaniko̱lh: —Quin, chu̱ makapitzi̱n fariseos ankalhí̱n cmakalhkajnana̱hu laqui̱mpi̱ chuná̱ nali̱ca̱cni̱naniya̱hu Dios, ¿tú̱ chú̱ xpa̱lacata mili̱ma̱kalhtahuáka̱t ni̱ li̱makalhkajnanko̱y? ");
INSERT INTO tosNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús na̱má̱ kalhti̱ko̱lh: —Hua̱nti̱ putzako̱cani̱t laqui̱mpi̱ naanko̱y makpa̱xuhuako̱y c-tapu̱chuhuani, ¿pi̱ mini̱niy xlacán caj tali̱puhuá̱n antá̱ namaklatahuilako̱ya̱chá̱ xli̱makua antá̱ ta̱lahuilakó̱ yama̱ kahuasa hua̱nti̱ tapu̱chuhuama̱? Hua̱mpi̱ nalakchá̱n quilhtamacú̱ acxni̱ nasputa̱ pu̱tapu̱chuhu, chu̱ yama̱ kahuasa hua̱nti̱ tapu̱chúhualh mákat naán, chuná̱ la̱ntla̱ quit naquiakspulay; acxnicú̱ chú̱ xlacán nali̱puhuanko̱y, chu̱ namakalhkajnanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Xli̱pacs hua̱ntu̱ quit cca̱ma̱siyunimá̱n pacs xasa̱sti li̱ma̱paksí̱n, pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ ni̱ pala cha̱tum ti̱ mini̱niy nalaktzapay mactum xalakuan talhaká̱n, chú̱ nama̱huacaniy ti̱tzu̱ xasa̱sti lháka̱t, sa̱mpi̱ yama̱ xasa̱sti lháka̱t acxni̱ nachaka̱cán nata̱ctzuhui̱y, chu̱ a̱tzinu̱ li̱huaca kalhtlanca nahuán anta̱ni̱ nataxti̱ta̱ ni̱ xahua̱ la̱ntla̱ xapu̱lh xtaxti̱tni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Chu̱ na̱ chuna li̱tum, ni̱ namaclacasquina̱ pú̱xtoko̱ hua̱ntu̱ aya lakuama̱ xmakxu̱hua calhni̱lu̱, pala antá̱ namuju̱ya̱ hua̱ntu̱ ni̱ xacatla vino, sa̱mpi̱ lapi̱ chuná̱ natlahuacán, yama̱ xmakxu̱hua calhni̱lu̱ napanka, chuná̱ la̱ xu̱hua, chu̱ vino caj pá̱xcat nahuanko̱y, sa̱mpi̱ lacxtum nalaktzanka̱y. Pus huá̱ xpa̱lacata̱ pi̱ li̱huaca tla̱n muju̱cán ni̱ xacatla vino c-xasa̱sti xmakxu̱hua calhni̱lu̱ laqui̱mpi̱ luhua lacxtum nacatlanko̱y, chu̱ nata̱yaniko̱y, ni̱tú̱ catilaniko̱lh.” ");
INSERT INTO tosNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Acxni̱ Jesús chuná̱ xli̱xakatli̱ma̱kó̱ yuma̱ tachihuí̱n, cha̱tum chixcú̱ hua̱nti̱ xpuxcu̱naniko̱y judíos chilh anta̱ni̱ xlá̱ xlaya̱, lakatatzokóstalh c-xlacatí̱n laqui̱mpi̱ nama̱xqui̱y ca̱cni, chu̱ na̱má̱ huánilh: —Quintzuma̱t, u̱cu ni̱lh, hua̱mpi̱ lapi̱ huix nalakpina, chu̱ nali̱chipaya̱ mimacán c-xmacni xlá̱ luhua nakalhi̱palay xlatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Puschí̱ táca̱xli̱ Jesús, chu̱ lacapala̱ tá̱alh c-xchic, chu̱ na̱ pacs ta̱anko̱lh xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hua̱mpi̱ la̱ntla̱ xama̱ ctiji, na̱ sta̱laniko̱lh cha̱tum pusca̱t hua̱nti̱ aya xle̱ma̱ xli̱akcu̱tuy ca̱ta̱ la̱ntla̱ xta̱tatlay, cstajmakama̱ xkalhni. Xlá̱ tze̱k laktalacatzúhui̱lh Jesús c-xka̱n, tampaksta̱xamánilh xlháka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sa̱mpi̱ xlá̱ xacstupuhuán: “Huatiya̱ lapi̱ tla̱n xacxamánilh tzinú̱ xlháka̱t, quit tuncán nacpacsa.” ");
INSERT INTO tosNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Acxni̱ chú̱ xamaniko̱lh xlháka̱t, Jesús lacapala̱ talakáspitli, úcxilhli̱ pusca̱t, na̱má̱ huánilh: —Na̱na̱, huix aya pacsni̱ta, sa̱mpi̱ luhua xli̱ca̱na̱ quili̱pá̱huanti, chu̱ ca̱najlani̱ta̱ pi̱ quit tla̱n nacma̱pacsayá̱n. Acxnitiyá̱ chú̱ yama̱ pusca̱t xapacsni huá̱. ");
INSERT INTO tosNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Acxni̱ chú̱ cha̱lh Jesús c-xchic yama̱ xapuxcu judío xuanicán Jairo, xlá̱ ucxilhko̱lh csununani̱n xtzucuko̱ni̱t sunuko̱y xli̱skolhcán laqui̱mpi̱ aya naancán ma̱acnu̱nancán, na̱ chuná̱ xli̱lhu̱hua̱ la̱ntla̱ acchilij xtanu̱ma̱kó̱, xtasama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xlá̱ na̱má̱ huaniko̱lh: —Catlahuátit li̱tlá̱n lacapala̱ cataxtútit sa̱mpi̱ tama̱ tzuma̱t caj lhtatama̱, ni̱ xaní̱n la̱ntla̱ huixín puhuaná̱tit. Hua̱mpi̱ pacs caj tzúculh li̱li̱tzi̱nko̱y hua̱ntu̱ xlá̱ huá̱. ");
INSERT INTO tosNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesús fuerza̱ tlakaxtuko̱lh, a̱li̱sta̱lh xlá̱ tánu̱lh, chipánilh xmacan, cha̱nchu̱ tzuma̱t tuncán tá̱qui̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Cha̱nchu̱ la̱ntla̱ xli̱ca̱tlanca̱ yama̱ c-tíyat cani̱huá̱ tzucúcaj li̱chihui̱nancán hua̱ntu̱ xlá̱ xtlahuani̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Acxni̱ Jesús táxtulh yama̱ ca̱chiquí̱n, chu̱ alhá, cha̱tuy lakatzi̱ní̱n tzúculh sta̱laniko̱y xca̱tasati̱lhako̱y, na̱má̱ xuanima̱kó̱: —Xquilhtzucut rey David, ¡catlahua̱ li̱tlá̱n, caquinca̱lakalhámanti! ");
INSERT INTO tosNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesús ni̱ tachókolh. Acxni̱ chú̱ cha̱lh c-chiqui̱ anta̱ni̱ xlá̱ nalaktuncuhuiy, hua̱ yuma̱ cha̱tuy lakatzi̱ní̱n, na̱ tanu̱ko̱lh, chu̱ acxni̱ laktalacatzuhui̱ko̱lh anta̱ni̱ xlá̱ xuí̱, na̱má̱ kalhasquinko̱lh: —¿Pi̱ ca̱najlayá̱tit huixín pi̱ quit tla̱n nactlahuay hua̱ntu̱ huixín quisquinipá̱tit? Xlacán kalhti̱nanko̱lh: —Quimpu̱chinacán, quin xli̱ca̱na̱ cca̱najlaya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Puschí̱ Jesús lacaxamako̱lh c-xlakastapucán, chu̱ na̱má̱ huaniko̱lh: —Lapi̱ chuná, pus cakantáxtulh hua̱ntu̱ huixín ca̱najlani̱tántit. ");
INSERT INTO tosNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Xlakastapucán yuma̱ chixcuhuí̱n tuncán tatla̱ni̱ko̱lh, chu̱ tla̱n lacahua̱nanko̱lh. Ali̱sta̱lh Jesús huaniko̱lh: —Luhua xli̱ca̱na̱ catlahuátit li̱tlá̱n, ni̱tí̱ cali̱ta̱chihui̱nántit laqui̱mpi̱ ni̱tí̱ nacatzi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Hua̱mpi̱ cajcu puntzú̱ xlacán xtaxtuko̱ni̱t, tuncán tzúculh li̱chihui̱nanko̱y hua̱ntu̱ Jesús xtlahuani̱t c-xlatama̱tcán, chu̱ la̱ntla̱ xli̱ca̱tlanca̱ yama̱ c-tíyat pacs catzi̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Acxni̱ cajcu xtaxtuma̱ko̱lh chixcuhuí̱n hua̱nti̱ a̱cu xma̱pacsako̱cani̱t, chimpalako̱lh makapitzi̱n chixcuhuí̱n, li̱miniko̱lh Jesús cha̱tum chixcú̱ ko̱ko̱, sa̱mpi̱ hua̱ cspiritu akskahuiní̱ hua̱nti̱ xpa̱laktaju̱ma̱ xma̱ko̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús li̱ma̱páksi̱lh yama̱ akskahuiní̱ pi̱ capa̱laktácutli̱ chixcú. Acxni̱ chu̱ makaxtakko̱lh, yama̱ ko̱ko̱ tla̱n tzúculh chihui̱nán. La̱ntla̱ xli̱lhu̱hua̱ hua̱nti̱ antá̱ xuilakó̱ lanaj li̱lacahuanko̱lh tu̱ xucxilhko̱ni̱t, chu̱ chuná̱ xuanko̱y: —Niucxnicú̱ xa̱taucxilha c-xatiyat Israel aktum tlanca li̱ca̱cni tatlahu la̱ntla̱ chiyú̱ ucxilhni̱tahu. ");
INSERT INTO tosNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Hua̱mpi̱ makapitzi̱n fariseos hua̱nti̱ csi̱tzi̱niko̱y na̱má̱ xuanko̱y: —Yuma̱ chixcú̱ tla̱n tamacaxtuko̱y cspiritucan akskahuiní sa̱mpi̱ huá̱ li̱pa̱huán, chu̱ ta̱scujma̱ xapuxcu akskahuiní, huá̱ chú̱ ma̱xqui̱ni̱t xli̱tlihuaka. ");
INSERT INTO tosNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A̱li̱sta̱lh Jesús alh lakapaxia̱lhnanko̱y xli̱pacs c-lactzu̱ ca̱chiquí̱n hua̱ntu̱ xuilakó̱ yama̱ c-tíyat. C-akatunu ca̱chiquí̱n anta̱ni̱ xcha̱n, xtanu̱y c-xpu̱kalhtahuakacan judíos, chu̱ antá̱ xli̱akchihui̱naniko̱y hua̱nti̱ xtamakstokko̱y. Huá̱ xli̱chihui̱naniko̱y la̱ntla̱ Dios xuili̱putún xasa̱sti xli̱ma̱paksí̱n c-xlatama̱tcán; xa̱huá̱ xlá̱ pacs xma̱pacsay la̱ntla̱ tu̱ya̱ta tajátat, chu̱ tacatzanájuat xkalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Acxni̱ úcxilhli̱ lhu̱hua tachixcuhuí̱tat la̱ntla̱ xlacán xlama̱kó̱, xlá̱ xli̱ca̱na̱ kayaj catzaniko̱lh; sa̱mpi̱ lhu̱hua̱ hua̱nti̱ ni̱ xkalhi̱ko̱y tapa̱xuhuá̱n, chu̱ ni̱tí̱ xanán hua̱nti̱ namakta̱yako̱y. Luhua xta̱chuná̱ xlama̱kó̱ la̱ntla̱ kampu̱tum calhni̱lu̱ hua̱nti̱ lhtuj makaxtakko̱cani̱t, ni̱ kalhi̱ko̱y xpu̱chinacán ti̱ namaktakalhko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Puschí̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Lhu̱hua̱ xlacán hua̱nti̱ xli̱ca̱na̱ aktzanka̱tama̱ko̱ni̱t, chu̱ luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ lakatum tlanca tachaná̱n anta̱ni̱ lhu̱huacú̱ huí̱ li̱xká̱nat, hua̱mpi̱ huá̱ chú̱ scujní̱n ti̱ xka̱nama̱kó̱, luhua ni̱ pala clhu̱huacán. ");
INSERT INTO tosNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ casquinítit xma̱la̱na tachaná̱n, cahuanítit pi̱ camacámilh tlak lhu̱hua̱ scujní̱n laqui̱mpi̱ lacapala̱ nama̱macxtumi̱ko̱y hua̱ntu̱ li̱ma̱qui̱tcú̱ laná̱nat. ");
INSERT INTO tosNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Maktum quilhtamacú̱ Jesús tasaniko̱lh laqui̱mpi̱ natamacxtumi̱ko̱y yama̱ kalhacu̱tuy xli̱ma̱kalhtahuáka̱t hua̱nti̱ luhua ankalhí̱n xta̱lapu̱lako̱y. Xlá̱ ma̱xqui̱ko̱lh li̱tlihuaka̱ laqui̱mpi̱ xtama̱lakachá̱n nahuanko̱y hua̱nti̱ tla̱n natamacaxtuko̱y cspiritucan akskahuiní, chu̱ laqui̱mpi̱ tla̱n nama̱pacsako̱y ta̱tatlaní̱n xa̱huá̱ hua̱nti̱ xkalhi̱ko̱y tuhuajcuta tacatzanájuat. ");
INSERT INTO tosNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hua̱ xtucuhuinicán yuma̱ kalhacu̱tuy tama̱lakacha̱ní̱n, usu xapóstoles, hua̱ yumá̱: Simón, hua̱nti̱ xlá̱ li̱ma̱pa̱cúhui̱lh Pedro, xa̱hua̱ xta̱la Andrés; Santiago, xa̱hua̱ Juan, hua̱ yuma̱ xcaman cha̱tum ko̱lutzi̱n xuanicán Zebedeo; ");
INSERT INTO tosNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, chu̱ Tomás; Mateo hua̱nti̱ xapu̱lana̱ xma̱ta̱ji̱nán impuestos, xa̱hua̱ Santiago hua̱nti̱ xkahuasa Alfeo; Lebeo hua̱nti̱ na̱ xli̱ma̱pa̱cuhui̱cán Tadeo; ");
INSERT INTO tosNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Xa̱hua̱ Simón, yuma̱ chixcú̱ xapu̱lh xta̱tapaksi̱y kampu̱tum chixcuhuí̱n hua̱nti̱ xuaniko̱cán zelotes; xa̱hua̱ Judas Iscariote hua̱nti̱ a̱li̱sta̱lh macamá̱sta̱lh Quimpu̱chinacan Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ali̱sta̱lh Jesús cajcu xma̱lakacha̱putunko̱y yuma̱ kalhacu̱tuy xatalacsacni xapóstoles; acxni̱ ni̱ xa̱anko̱y xlá̱ na̱má̱ huaniko̱lh: “Ni̱ antá̱ capítit xtiyatcán hua̱nti̱ ni̱ judíos, na̱ ni̱ natanuyá̱tit antá̱ ca̱chiquí̱n tu̱ tapaksi̱ko̱y c-Samaria. ");
INSERT INTO tosNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Huata xatlá̱n huá̱ calakpinkó̱tit hua̱nti̱ la̱ntla̱ xata̱ktzanka̱tapu̱li̱n calhni̱lu̱ lama̱kó̱ u̱nú̱ c-xatiyat Israel. ");
INSERT INTO tosNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Huixín huá̱ cali̱akchihui̱nanti̱lhátit pi̱ aya talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xli̱pacs ta̱tatlaní̱n cama̱pacsakó̱tit, cama̱lakastakuaní̱tit hua̱nti̱ a̱cu ni̱ko̱ni̱t chixcuhuí̱n, na̱ chuná̱ hua̱nti̱ kalhi̱ko̱y li̱xcajnit tzitzi̱ huanicán lepra cama̱pacsakó̱tit, na̱ catamacaxtunikó̱tit hua̱nti̱ pa̱laktaju̱ko̱ni̱t cspiritu akskahuiní. Huixín caj chunata maklhti̱nántit tama̱ li̱tlihuaka, pus na̱ chuná̱ chú̱ huixín acxni̱ nali̱ma̱pacsayá̱tit hua̱nti̱ ta̱tatlay, na̱ caj li̱tlá̱n cali̱tlahuátit mintascujutcán, ni̱ cama̱ta̱ji̱nántit. ");
INSERT INTO tosNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ni̱tú̱ cali̱pítit tumi̱n c-mili̱tampa̱chicán, ni̱ pala xla plata, usu xla oro, chu̱ na̱ ni̱ pala xla cobre. ");
INSERT INTO tosNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na̱ ni̱ pala tili̱piná̱tit pú̱xtoko̱ c-tiji, na̱ ni̱ cali̱pítit pu̱tiyu̱n milhaka̱tcán hua̱ntu̱ nali̱lakpali̱naná̱tit, huata caj xma̱n huá̱ cali̱pítit hua̱ntu̱ lhaka̱ni̱tántit, chu̱ na̱ chuná̱ mintatuhuanu̱ncán. Na̱ ni̱ pala huá̱ cali̱pítit mili̱xtokocán, pacs yuma̱ ni̱ tzanka̱y tí̱ naca̱ma̱xqui̱yá̱n; sa̱mpi̱ hua̱nti̱ xli̱ca̱na̱ scujma̱ fuerza̱ mini̱niy pi̱ nama̱hui̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Xa̱huá̱ anta̱ni̱ nachipiná̱tit c-aktum ca̱chiquí̱n, caputzátit cha̱tum chixcú̱ hua̱nti̱ luhua tla̱n xtapuhuá̱n, chu̱ antá̱ chú̱ catamakaxtáktit c-xchic hasta acxni̱ huixín napiná̱tit a̱lacatanu̱ ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Acxni̱ nata̱ksá̱tit aktum chiqui̱ anta̱ni̱ namaklhtatayá̱tit, cahuanikó̱tit hua̱nti̱ xala c-chiqui̱ pi̱ cakalhi̱ko̱lh tapa̱xuhuá̱n hua̱ntu̱ ma̱sta̱y Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ali̱sta̱lh lapi̱ antá̱ yama̱ c-chiqui̱ huilakó̱ hua̱nti̱ tla̱n catzi̱ko̱y, chu̱ mini̱niko̱y pi̱ nakalhi̱ko̱y tapa̱xuhuá̱n, pus casquinítit Dios pi̱ antá̱ cata̱tamakaxtakko̱lh. Hua̱mpi̱ lapi̱ hua̱nti̱ huilakó̱ c-chiqui̱ ni̱ mini̱niko̱y nakalhi̱ko̱y tapa̱xuhuá̱n, pus huixín calactlahuátit tamá̱ mintachihui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lapi̱ c-aktum chiqui, usu c-aktum ca̱chiquí̱n ni̱tlá̱n naca̱tlahuacaná̱tit, chu̱ na̱ ni̱ pala ca̱kaxpatniputuncaná̱tit yama̱ tachihuí̱n hua̱ntu̱ huixín li̱chihui̱nampá̱tit, pus huata huixín lacapala̱ cataxtútit c-chiqui, usu ca̱chiquí̱n, chu̱ acxni̱ nataxtuyá̱tit caca̱lactincxcántit pokxni̱ hua̱ntu̱ ca̱lactahuacán c-mintantu̱ncán laqui̱mpi̱ xlacán naucxilhko̱y pi̱ huixín nia̱lh mincui̱ntajcán lapi̱ nalaktzanka̱ko̱y tama̱ chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Luhua xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ Dios naakastacya̱huako̱y xli̱pacs tachixcuhuí̱tat xpa̱lacata̱ tu̱ ni̱tlá̱n tlahuako̱ni̱t, hua̱nti̱ xala yama̱ ca̱chiquí̱n a̱tzinú̱ luhua li̱huaca la̱ntla̱ napa̱ti̱nanko̱y ni̱ xahua̱ lacli̱xcajnit tachixcuhuí̱tat hua̱nti̱ xuilakó̱ xamaka̱n quilhtamacú̱ c-chuchutsipi̱ hua̱ntu̱ xuaniko̱cán Sodoma, chu̱ Gomorra. ");
INSERT INTO tosNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Luhua li̱huana̱ cakaxpáttit! Quit cca̱maca̱má̱n luhua xta̱chuná̱ lactzu̱ calhni̱lu̱ c-xlaksti̱pa̱ncan lacli̱pe̱cua huanani̱n la̱páni̱t. Pus huata huixín luhua skálalh calatapu̱lí̱tit xta̱chuná̱ la̱ntla̱ latla̱huanko̱y lu̱hua, hua̱mpi̱ na̱ chuna li̱tum xacacsua cahuántit la̱ntla̱ lacma̱ntzu̱ paloma. ");
INSERT INTO tosNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ca̱na̱ huixín, cuí̱ntaj catlahuátit sa̱mpi̱ caj quimpa̱lacata̱ naca̱macama̱sta̱caná̱tit c-pu̱ma̱paksí̱n, huixín naca̱snokcaná̱tit c-xpu̱kalhtahuakacan judíos. ");
INSERT INTO tosNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xa̱huá̱ caj quimpa̱lacata̱ naca̱li̱pincaná̱tit c-xlacati̱ncan lactlanca ma̱paksi̱naní̱n, usu c-xlacati̱ncan lactlanca napuxcun Reyes. Hua̱ yumá̱ tla̱n naqui̱li̱taxtuy laqui̱mpi̱ tla̱n naquili̱chihui̱naná̱tit c-xlacati̱ncán hua̱nti̱ ni̱ judíos. ");
INSERT INTO tosNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Acxni̱ huixín naca̱macama̱sta̱caná̱tit c-xlacati̱ncán ma̱paksi̱naní̱n, ni̱ luhua tilacapala̱tnaná̱tit xpa̱lacata la̱ntla̱ nakalhti̱naná̱tit, usu la̱ntla̱ nahuaná̱tit acxni̱ natamakta̱yayá̱tit. Sa̱mpi̱ acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ huixín nachihui̱naná̱tit, Dios naca̱ma̱xqui̱yá̱n lacuan tachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sa̱mpi̱ xli̱ca̱na̱ pi̱ ni̱ huixín catichihui̱nántit, huata hua̱ xEspíritu Quintla̱ticán hua̱nti̱ naca̱ma̱chihui̱ni̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Acxni̱ yama̱ quilhtamacú̱, lhu̱hua̱ ti̱ nala̱makasi̱tzi̱ko̱y caj quimpa̱lacata, chu̱ hasta nala̱macama̱sta̱ko̱y huatiya li̱nata̱lán laqui̱mpi̱ namakni̱ko̱cán; chi̱nchu̱ na̱ chuná̱ hua̱nti̱ huilakó̱ xcamancán nalacata̱qui̱ko̱y xtla̱tcán, na̱ namacama̱xqui̱ko̱y ti̱ namakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Huixín naca̱xcajniko̱yá̱n xli̱pacscan a̱makapitzí̱n caj quimpa̱lacata, hua̱nti̱ luhua aksti̱tum naquili̱pa̱huán hasta acxni̱ nati̱taxtuko̱y yuma̱ ni̱ tla̱n quilhtamacú̱, pus hua̱ xlá̱ tamá̱ nalakma̱xtuy xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Acxni̱ huixín naca̱putzasta̱lacaná̱tit c-aktum ca̱chiquí̱n, huata xatlá̱n catza̱látit, capítit a̱lacatanu̱ ca̱chiquí̱n. Sa̱mpi̱ luhua lacatancs cca̱huaniyá̱n pi̱ quit Xatalacsacni Chixcú̱ nacmimpalay acxni̱ ni̱ a̱ma̱katsputuyá̱tit nahuán mintascujutcán xli̱pacs c-akatunu lactzu̱ ca̱chiquí̱n hua̱ntu̱ huilakó̱ c-xatiyat Israel. ");
INSERT INTO tosNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Caakatá̱kstit yumá̱ tu̱ cca̱huanimá̱n: ni̱ cha̱tum hua̱nti̱ caj li̱ma̱kalhtahuáka̱t napuhuán pi̱ a̱tzinú̱ xlá̱ nama̱xqui̱cán ca̱cni ni̱ xahua̱ xma̱kalhtahuaka̱ná, chu̱ ni̱ pala cha̱tum ti̱ caj tasa̱cua̱ napuhuán pi̱ a̱tzinú̱ xlá̱ talí̱pa̱hu ni̱ xahua̱ xma̱la̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Hua̱nti̱ caj li̱ma̱kalhtahuáka̱t luhuata tla̱n pi̱ caj xma̱n hua̱ xlá̱ capa̱xcatcátzi̱lh pi̱ sta̱lanima̱ xma̱kalhtahuaka̱ná, chu̱ na̱ chuná̱ hua̱nti̱ caj scujni̱ capa̱xcatcátzi̱lh pi̱ hua̱ntu̱ lakcha̱ma̱ xma̱la̱ná̱ c-xlatáma̱t fuerza̱ na̱ nalakchá̱n. Huá̱ cca̱li̱huaniyá̱n, pala cha̱tum xpu̱china chiqui̱ li̱ma̱pa̱cuhui̱cán Beelzebú xapuxcu akskahuiní, ¿pi̱ puhuaná̱tit chú̱ huixín pi̱ li̱huacá̱ ni̱ li̱xcájnit catihuaniko̱ca̱ a̱makapitzí̱n ti̱ na̱ xala c-xchic? ");
INSERT INTO tosNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Hua̱mpi̱ huixín ni̱ cape̱cuanikó̱tit hua̱ntu̱ naca̱tlahuaniyá̱n a̱makapitzí̱n caj xpa̱lacata ni̱ ma̱tla̱ni̱ko̱y hua̱ntu̱ huixín nahuaná̱tit, sa̱mpi̱ ni̱ pala actum tachihuí̱n hua̱ntu̱ quit cca̱huanini̱tán, caj chunata tze̱k catitahui̱ lapi̱ ni̱ fuerza̱ nacatzi̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lapi̱ acxni̱ ca̱paklhtu̱tá̱ xuani̱t quit cca̱huanini̱tán aktum tachihuí̱n, pus acxni̱ chú̱ ca̱cuhuiní̱ huixín cali̱akchihui̱nampítit, chu̱ na̱ chuná̱ hua̱ntu̱ caj tze̱k cca̱huanini̱tán, huixín xli̱ca̱na̱ ma̱squi antá̱ luhua pixtlanca̱ cali̱ca̱tasátit c-xca̱aksti̱ni̱n lacta̱lhma̱n chiqui. ");
INSERT INTO tosNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ni̱ cape̱cuanikó̱tit yama̱ hua̱nti̱ ma̱squi tla̱n naca̱makni̱yá̱n, sa̱mpi̱ xlacán ni̱ lay ma̱pa̱ti̱ni̱ko̱y mili̱stacnacán. Huata xatlá̱n huá̱ cape̱cuanítit Dios sa̱mpi̱ xlá̱ la̱ntla̱ namakni̱ko̱y mintiyatli̱hua kalhi̱palay li̱tlihuaka̱ laqui̱mpi̱ a̱li̱sta̱lh na̱ tla̱n namacá̱n mili̱stacna̱ c-pu̱pa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Caj luhua caucxilhkó̱tit la̱ntla̱ luhua actu̱jú̱ xtápalh ma̱sta̱ko̱cán tantuy lactzu̱ spu̱n, chu̱ ni̱ pala tzinú̱ tapala̱xlá̱ li̱sta̱cán, hua̱mpi̱ ma̱squi chuná, ni̱ pala tantum xaní̱n catitama̱chá̱ c-tíyat lapi̱ ni̱ huá̱ chuná̱ nalacasquín Quintla̱tican Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Huá̱ chuná̱ cca̱li̱huanimá̱n sa̱mpi̱ xlá̱ pacs catzi̱y, chu̱ xa̱huachí̱ hasta ma̱squi miacchixitcán hua̱ntu̱ ya̱kó̱ c-miakxe̱kacán pacs tapu̱tlakata̱yani̱t la̱ntla̱ kanatunu. ");
INSERT INTO tosNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Chuná̱ pi̱ ni̱ cape̱cuántit; Dios naca̱makta̱yayá̱n sa̱mpi̱ tlak xali̱huacá̱ huixín lhu̱hua̱ kalhi̱yá̱tit milakasicán ni̱ xahua̱ pacs yama̱ lactzu̱ spu̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Caxati̱cahuá̱ ti̱ nali̱ta̱yay c-xlaksti̱pa̱ncan a̱makapitzí̱n pi̱ xli̱ca̱na̱ quili̱pa̱huán, pus na̱ chuná̱ chú̱ quit na̱ nackalhmakta̱yay c-xlacati̱n Quintla̱t ti̱ huilachá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Hua̱mpi̱ caxati̱cahuá̱ ti̱ ni̱ nali̱ta̱yay c-xlacati̱ncan a̱makapitzí̱n pi̱ xli̱ca̱na̱ quili̱pa̱huán, pus na̱ chuná̱ chú̱ quit na̱ ni̱ ctikalhmaktá̱yalh c-xlacati̱n Quintla̱t ti̱ huí̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ni̱ luhua tipuhuaná̱tit huixín pala caj xma̱n huá̱ luhua cmini̱t huili̱y tapá̱xqui̱t u̱nú̱ ca̱tiyatna, pus quit ni̱ luhua xma̱n huá̱ cli̱mini̱t tapá̱xqui̱t huata na̱ caj cmini̱t huili̱y tala̱makasi̱tzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Quit caj la̱mpala cmini̱t la̱ma̱chipi̱y tachixcuhuí̱tat, huá̱ chuná̱ cli̱quilhuama̱ sa̱mpi̱ caj quimpa̱lacata̱ cha̱tum kahuasa nata̱la̱makasi̱tzi̱y xtla̱t, cha̱tum tzuma̱t nata̱la̱makasi̱tzi̱y xtzi, chu̱ cha̱tum pusca̱t nata̱la̱makasi̱tzi̱y xpu̱tiya̱tzi. ");
INSERT INTO tosNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","La̱ntla̱ cha̱tunu chixcuhuí̱n ma̱n xli̱nata̱lancán xta̱la̱makasi̱tzi̱nacán nahuán, chu̱ ni̱ catila̱ucxilhputunko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Na̱ chuna li̱tum, lapi̱ cha̱tum huixín tlak lakcatzán xtla̱t, usu xtzi̱ ni̱ xahua̱ quit, laqui̱mpi̱ aktum catzi̱y quilacscujni nahuán, pus huata xlá̱ ni̱ lakchá̱n quit quintapaksi̱niy la̱ntla̱ quili̱ma̱kalhtahuáka̱t; chu̱ na̱ chuna li̱tum yama̱ hua̱nti̱ a̱tzinú̱ lakcatzán xkahuasa, usu xtzuma̱t ni̱ xahua̱ quit, xlá̱ ni̱ lay li̱tanu̱y la̱ xaxli̱ca̱na̱ quili̱kalhtahuaka. ");
INSERT INTO tosNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chu̱ na̱ chuná̱ hua̱nti̱ ni̱ aktum catzi̱y la̱ cha̱li̱ cha̱lí̱ cale̱lh xcruz, chu̱ caquista̱lánilh hasta ma̱squi chuna tla̱n cali̱macamá̱sta̱lh xlatáma̱t caj quimpa̱lacata, xlá̱ ni̱ lay quintapaksi̱niy la̱ntla̱ ti̱ xli̱ca̱na̱ quilacscujni. ");
INSERT INTO tosNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Sa̱mpi̱ hua̱nti̱ lakma̱xtuputún xlatáma̱t u̱nú̱ ca̱tiyatna, huata xlá̱ namakatzanka̱y, hua̱mpi̱ hua̱nti̱ namakatzanka̱y xlatáma̱t caj quimpa̱lacata̱ huata xlá̱ nama̱akapu̱taxti̱y c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Hua̱nti̱ huixín tla̱n naca̱tlahuayá̱n c-xchic, chu̱ naca̱makamaklhti̱naná̱n, pus luhua xta̱chunatiyá̱ la̱mpala quit quimakamaklhti̱nama̱; huá̱ chú̱ ti̱ quit tla̱n quintlahuay, chu̱ quimakamaklhti̱nán, pus na̱ luhua chunatiya qui̱taxtuy la̱mpala huá̱ makamaklhti̱nama̱ Quintla̱t hua̱nti̱ quimacamini̱t ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Caxati̱cahuá̱ ti̱ xta̱laktuncúhuilh c-xchic cha̱tum xprofeta Dios caj cumu catzi̱y pi̱ huá̱ lacscujnima̱, xli̱ca̱na̱ xlá̱ pi̱ na̱ chunata namaklhti̱nán xtaskahu c-xlacati̱n Dios la̱ntla̱ nalakchá̱n cha̱tum xprofeta Dios. Na̱ chuna li̱tum hua̱nti̱ nata̱laktuncuhuiy c-xchic cha̱tum chixcú̱ hua̱nti̱ luhua tla̱n xtapuhuá̱n, caj xpa̱lacata pi̱ lakapasa̱ pi̱ aksti̱tum chixcú, Dios nama̱xqui̱y xtaskahu la̱ntla̱ tu̱ lakchá̱n cha̱tum hua̱nti̱ luhua tla̱n xtapuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chu̱ caxati̱cahuá̱ ti̱ xmá̱xqui̱lh ma̱squi ca̱na̱ caj paktum má̱ko̱t xaskahuihui chúchut cha̱tum hua̱nti̱ ni̱ pala tú̱ xlakasi tasiyuy quili̱ma̱kalhtahuáka̱t caj xpa̱lacata catzi̱y quista̱laniy, xli̱ca̱na̱ cca̱huaniyá̱n pi̱ ni̱ caj chunata catitamakáxtakli̱ pala ni̱ fuerza̱ nama̱xqui̱cán xtaskahu c-xlacati̱n Dios.” ");
INSERT INTO tosNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Acxni̱ chú̱ xuaniko̱ni̱ttá̱ la̱ntla̱ natlahuako̱y xtascujutcán kalhacu̱tuy xli̱ma̱kalhtahuáka̱t, xlacán anko̱lh, chu̱ xlá̱ na̱ lacapala̱ táca̱xli, chu̱ na̱ antá̱ alh li̱akchihui̱nán xtachihui̱n Dios c-lactzu̱ ca̱chiquí̱n hua̱ntu̱ lacatzú̱ xuilakó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma̱squi Juan Bautista chunacú̱ xtanu̱ma̱ c-pu̱la̱chi̱n, hua̱mpi̱ antá̱ xlá̱ catzi̱chá̱ la̱ntla̱ Cristo lactlanca li̱ca̱cni̱ xtlahuama̱. Pus xlá̱ ma̱lakácha̱lh makapitzi̱n xli̱ma̱kalhtahuáka̱t anta̱ni̱ xlama̱chá. ");
INSERT INTO tosNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Yama̱ chixcuhuí̱n acxni̱ lakcha̱nko̱lh Jesús chuná̱ kalhasquinko̱lh: —Quinca̱macamimá̱n Juan Bautista laqui̱mpi̱ nacca̱kalhasquiná̱n lapi̱ xli̱ca̱na̱ huix Cristo hua̱nti̱ namín quinca̱lakma̱xtuyá̱n, usu natimincú̱ a̱li̱sta̱lh hua̱nti̱ luhua xli̱ca̱na̱ Cristo. ");
INSERT INTO tosNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Cha̱nchu̱ Jesús kalhti̱ko̱lh, huaniko̱lh: “Lacapala̱ calakpimpítit, chu̱ cahuanítit Juan hua̱ntu̱ huixín ucxilhpá̱tit ctlahuama̱, chu̱ hua̱ntu̱ kaxpatpá̱tit cli̱chihui̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na̱ cali̱ta̱chihui̱nántit pi̱ hua̱nti̱ lakatzi̱ní̱n xuanko̱ni̱t chú̱ aya tla̱n lacahua̱nanko̱y, na̱ chuná̱ hua̱nti̱ ni̱ lay xta̱yako̱y, chú̱ aya tla̱n tla̱huanko̱y. Xa̱hua̱ hua̱nti̱ xkalhi̱ko̱y li̱xcajnit tzitzi̱ huanicán lepra, chú̱ pacs tatla̱ni̱ma̱kó̱, na̱ chuná̱ hua̱nti̱ akata̱paní̱n xlama̱kó̱, chú̱ aya tla̱n kaxmatko̱y. Chu̱ hasta na̱ chuná̱ makapitzí̱n ti̱ aya xni̱ko̱ni̱t chú̱ cma̱lakastakuani̱ko̱ni̱t ca̱li̱ní̱n, chi̱nchu̱ hua̱nti̱ lakli̱ma̱xkaní̱n lama̱kó̱, pus xlacán tali̱akchihui̱nanima̱kó̱ pu̱lactum xasa̱sti talacapa̱stacni̱ hua̱ntu̱ nalakma̱xtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hua̱mpi̱ na̱ cahuanítit Juan pi̱ luhua ca̱na̱ li̱pa̱xuhu nalatama̱y yama̱ chixcú̱ hua̱nti̱ ni̱ naxlajuanán c-xtali̱pa̱huán acxni̱ chú̱ aya li̱huana̱ quilakapasni̱ttá̱ xatí̱ quit.” ");
INSERT INTO tosNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Acxni̱ chú̱ aya anko̱lh xlacscujni Juan, Jesús tzúculh li̱chihui̱nán Juan c-xlacati̱ncan li̱lhu̱hua, chu̱ na̱má̱ huaniko̱lh: “Acxni̱ tiqui̱látit c-desierto, ¿tú̱ luhua tiqui̱putzátit, usu xatú̱ luhua qui̱ucxilhputúntit? ¿Pi̱ huá̱ qui̱ucxilhputúntit huixín cha̱tum chixcú̱ ti̱ xta̱chuná̱ la̱ntla̱ kantum ká̱ti̱t tu̱ ni̱ tuhua̱ akxmu̱tya̱huama̱ u̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pus lapi̱ ni̱ chuná, ¿tú̱ chi̱nchu̱ qui̱ucxilhputúntit? ¿Pá̱ qui̱ucxilhputúntit cha̱tum chixcú̱ ti̱ luhua lacuan lháka̱t li̱lhaka̱nani̱t? Tamá̱ ni̱ chuná̱ sa̱mpi̱ huixín stalanca catzi̱yá̱tit pi̱ hua̱nti̱ li̱taca̱xta̱yako̱ni̱t lacuan lháka̱t, antá̱ xlacán huilakó̱ c-xchiccan lactlanca puxcu̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hua̱mpi̱ ¿xatí̱ luhua qui̱ucxílhtit? ¿Tú̱ huá̱ xqui̱ucxilhputuná̱tit cha̱tum profeta? Lapi̱ huá̱ qui̱putzátit pus li̱huaca tla̱n sa̱mpi̱ quit luhua lacatancs cca̱huaniyá̱n pi̱ xli̱ca̱na̱ tama̱ chixcú̱ ti̱ huixín qui̱ucxílhtit a̱tzinu̱ tlak tlanca ma̱xqui̱cani̱t xtascújut ni̱ xahua̱ la̱ntla̱ tu̱ xma̱xqui̱ko̱cani̱t xtascujutcan xli̱pacscan xalakmaka̱n profetas. ");
INSERT INTO tosNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa̱mpi̱ huatiya̱ tama̱ Juan Bautista hua̱nti̱ li̱chihui̱nán Dios c-Li̱kalhtahuaka̱ acxni̱ na̱má̱ huá̱: ‘Quit cma̱lakacha̱y quintalakachá̱n hua̱nti̱ napu̱laniyá̱n, laqui̱mpi̱ xlá̱ naca̱xtlahuaniti̱lhayá̱n mintiji.’ ");
INSERT INTO tosNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ la̱ntla̱ xli̱pu̱tum chixcuhuí̱n hua̱nti̱ lacachinko̱ni̱t ca̱tuxá̱huat ni̱ pala cha̱tum ti̱ anani̱t hua̱nti̱ tlak tlanca xtascújut xma̱xqui̱cani̱t xta̱chuná̱ la̱ntla̱ xla Juan Bautista. Hua̱mpi̱ ma̱squi chuná, chú̱ na̱ mili̱catzi̱tcán pi̱ cati̱huá̱ chixcú̱ ma̱squi ni̱tú̱ xlakasi xuá̱, hua̱nti̱ Dios namakamaklhti̱nán c-xasa̱sti xtapáksi̱t hua̱ntu̱ xli̱chihui̱nán Juan, pus huata namakatlajapalacán Juan, sa̱mpi̱ xlá̱ hasta tlak xali̱huacá̱ nakalhi̱y xtascújut. ");
INSERT INTO tosNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Hasta la̱ntla̱ titzúculh akmunu̱nán Juan Bautista hasta chú̱, lhu̱hua̱ hua̱nti̱ li̱tzaksama̱ pi̱ fuerza̱ nama̱kantaxti̱y yama̱ laktáxtut, chu̱ tanu̱ma̱kó̱ c-xtapaksi̱t Dios, sa̱mpi̱ xlacán fuerza̱ tlahuanima̱kó̱ ni̱ tachokoko̱y hasta pi̱ tla̱n natanu̱ko̱ya̱chá. ");
INSERT INTO tosNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Maka̱n quilhtamacú̱ hasta acxni̱ ni̱ xa̱mín Juan Bautista, xli̱pacs ti̱ xti̱taxtuko̱ni̱t profetas tzokuili̱ko̱lh c-xli̱kalhtahuakacán la̱ntla̱ namín quilhtamacú̱ acxni̱ Dios nahuili̱y xasa̱sti xtapáksi̱t u̱nú̱ ca̱tuxá̱huat, xa̱hua̱ Moisés na̱ títzokli̱ xpa̱lacata̱ c-xlibro̱ anta̱ni̱ na̱ tatzoktahuilani̱t xli̱ma̱paksi̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ma̱squi huixín ni̱ luhua caca̱najlaniputúntit quintachihuí̱n, hua̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ tama̱ Juan Bautista huatiya̱ yama̱ profeta Elías xuani̱t hua̱nti̱ tihuanica̱, usu tima̱lacnu̱ca̱ pi̱ xlá̱ namimpalay a̱maktum ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Lapi̱ huixín kalhi̱yá̱tit mili̱akahua̱ncán pus li̱huana̱ cakaxpáttit laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ cca̱ma̱akata̱ksni̱putuná̱n! ");
INSERT INTO tosNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Xatí̱ xta̱chuná̱ tla̱n nacca̱ta̱li̱ma̱xtuyá̱n huixín hua̱nti̱ lapá̱tit la̱nchú̱ yuma̱ quilhtamacú̱? Pus huixín caj luhua xta̱chuná̱ li̱taxtuyá̱tit la̱ntla̱ yama̱ lactzu̱ camán hua̱nti̱ kama̱nantahuilako̱y c-tlanca̱ti̱, chu̱ na̱ lacaca̱tasako̱y xta̱camancán. ");
INSERT INTO tosNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Na̱má̱ huanko̱y: ‘Pus ¿tú̱ luhua lacasquiná̱tit? ¡Quin aya cca̱li̱skolinini̱tán lacli̱pa̱xuhu tatlakni xlacan tantli̱ní̱n, hua̱mpi̱ huixín ni̱ tantlí̱tit, chu̱ na̱ aya cca̱li̱quilhtli̱nín xla tali̱puhuá̱n taquilhtlí̱n, hua̱mpi̱ na̱ ni̱ pala chuná̱ tasátit!’ ");
INSERT INTO tosNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Luhua xli̱ca̱na̱ pi̱ chuná̱ li̱taxtuyá̱tit huixín hua̱nti̱ la̱nchú̱ yuma̱ quilhtamacú̱ lapá̱tit, sa̱mpi̱ aya quí̱chilh Juan Bautista hua̱nti̱ ni̱ lacxtum xta̱hua̱yanko̱y, chu̱ ni̱ lacxtum xta̱ca̱taniko̱y caj cati̱hua̱ chixcuhuí̱n laqui̱mpi̱ nata̱pa̱xuhuako̱y, hua̱mpi̱ huata huixinín kalhtum huántit pi̱ huá̱ xkalhi̱y xtalacapa̱stacni akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Cha̱nchu̱ a̱li̱sta̱lh cmimpá̱ quit Xatalacsacni Chixcú, quit lacxtum ctzúculh ta̱hua̱yanko̱y, chu̱ ta̱ca̱taniko̱y cati̱hua̱ chixcuhuí̱n laqui̱mpi̱ chuná̱ pu̱tum nacta̱pa̱xuhuako̱y, hua̱mpi̱ huata huixín huampalayá̱tit pi̱ mat luhua tlanca xakotni, chu̱ luhua xma̱n huá̱ clacapa̱staca̱ la̱ntla̱ caj nacua̱yán, xa̱huá̱ xli̱pacs quiamigos ctlahuako̱y hua̱nti̱ ma̱ta̱ji̱nankoy impuestos, xa̱hua̱ cati̱hua̱ makla̱kalhi̱nani̱n chixcuhuí̱n. Hua̱mpi̱ quit cca̱huaniyá̱n pi̱ la̱ntla̱ huí̱ xli̱skalala Dios antá̱ lacatancs kantaxtuma, chu̱ li̱tasiyuma̱ xtascújut c-xlatáma̱t hua̱nti̱ xli̱ca̱na̱ akata̱ksma̱.” ");
INSERT INTO tosNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús la̱ntla̱ xakchihui̱nantla̱huán c-akatunu ca̱chiquí̱n, xuí̱ makapitzi̱n ca̱chiquí̱n anta̱ni̱ xtlahuay lhu̱hua lactlanca li̱ca̱cni, hua̱mpi̱ ma̱squi chuná̱, hua̱nti̱ antá̱ xuilakó̱ xlacán ni̱ xlakpali̱putunko̱y li̱xcajnit xtalacapa̱stacnicán laqui̱mpi̱ nali̱pa̱huanko̱y Dios. Maktum acxni̱ xli̱li̱puhuanko̱y yama̱ chixcuhuí̱n, xla luhua tlihuaka̱ tzúculh sta̱cya̱huako̱y, na̱má̱ xuanima̱kó̱: ");
INSERT INTO tosNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Koxutaní̱n huixín ti̱ huilapítit c-xaca̱chiqui̱n Corazín, chu̱ na̱ chuná̱ huixín ti̱ huilapítit c-Betsaida! Sa̱mpi̱ lapi̱ yama̱ lactlanca li̱ca̱cni̱ hua̱ntu̱ ctlahuani̱t c-milaksti̱pa̱ncán chuná̱ xtitlahuaca̱ aya mincha quilhtamacú̱ c-xaca̱chiqui̱n Tiro, chu̱ Sidón; pus ti̱ antá̱ xuilakó̱ xlacán aya maka̱sa cahuá̱ la̱ntla̱ xtilakpali̱ko̱lh xali̱xcajnit xtalacapa̱stacnicán, xa̱huá̱ aya xma̱siyuko̱lh pi̱ xli̱ca̱na̱ li̱puhuanko̱y caj xpa̱lacata xli̱lhaka̱nanko̱lh xatzitzaka lháka̱t, chu̱ na̱ xli̱actlahuapu̱xtuko̱ca̱ lhcaca. ");
INSERT INTO tosNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pus quit lacatancs cca̱huaniyá̱n pi̱ acxni̱ nalakchá̱n quilhtamacú̱ acxni̱ naakastacya̱huako̱cán xli̱pacs tachixcuhuí̱tat, huixín a̱tzinú̱ luhua li̱pe̱cua̱ la̱ntla̱ naca̱ma̱pa̱ti̱ni̱caná̱tit ni̱ xahua̱ yuma̱ hua̱nti̱ maká̱n huilako̱chá̱ c-xaca̱chiqui̱n Tiro, chu̱ Sidón. ");
INSERT INTO tosNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chi̱nchu̱ huixín xala c-Capernaum, Huixín ma̱x puhuaná̱tit pi̱ Dios ca̱li̱kalhi̱má̱n tlanca mimpu̱tahui̱lhcán c-akapú̱n. Pus quit lacatancs cca̱huaniyá̱n pi̱ ni̱ chuná, huata xatlá̱n anta̱ni̱ luhua xapu̱lhmá̱n c-pu̱pa̱tí̱n naca̱macapincaná̱tit laqui̱mpi̱ antá̱ naxoko̱naná̱tit. Sa̱mpi̱ lapi̱ antá̱ yama̱ c-chuchutsipi̱ tu̱ huanicán Sodoma xtatlahuaniko̱lh lactlanca li̱ca̱cni̱ hua̱ntu̱ tatlahuani̱t c-milaksti̱pa̱ncán, yama̱ tlanca ca̱chiquí̱n ni̱ xtima̱laksputuca̱, luhua tla̱n cahuá̱ xtahui̱ hasta chú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n, pi̱ hua̱nti̱ maká̱n xuilakó̱ c-Sodoma, tlak pa̱íta̱t nakalhi̱ko̱y ta̱kastacya̱huán acxni̱ yama̱ quilhtamacú̱ nachín taputzá̱n, ni̱ xahua̱ huixín.” ");
INSERT INTO tosNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Acxnitiyá̱ yama̱ quilhtamacú̱ Jesús tzúculh tlahuay xoración, na̱má̱ xuanima̱ xtla̱t: “Cma̱xqui̱yá̱n pa̱xcatcatzí̱nit, huix Ta̱ta̱ hua̱nti̱ xma̱la̱na akapú̱n, chu̱ ca̱tiyatna, pi̱ ma̱tze̱kuili̱niko̱ni̱ta̱ xatla̱n mintalacapa̱stacni̱ hua̱nti̱ luhua kalhi̱ko̱y xlakasi, chu̱ lakskalalan chixcuhuí̱n puhuanko̱y; huata huá̱ ma̱akata̱ksni̱ko̱ni̱ta̱ hua̱nti̱ luhua ni̱tu̱ tuncán xlakasicán laqui̱mpi̱ xlacán nakalhakaxmatko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Luhua chuná̱ tla̱n, Ta̱ta̱, sa̱mpi̱ huix chuná̱ lacásquinti̱ pi̱ chuná̱ naqui̱taxtuy.” ");
INSERT INTO tosNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ali̱sta̱lh ta̱chihui̱nampalako̱lh hua̱nti̱ antá̱ xya̱kó̱, tihua̱: “Xli̱pacs hua̱ntu̱ kalhi̱y Quintla̱t, pacs quimacama̱xqui̱ni̱t. Quit xCam Dios, chu̱ ni̱tí̱ luhua quilakapasa̱ xatí̱ quit huata caj xma̱n huá̱ Dios catzi̱y pi̱ quit xCam. Na̱ chuna li̱tum ni̱tí̱ luhua catzi̱y la̱ntla̱ luhua xtalacapa̱stacni̱ Quintla̱t Dios huata caj xma̱n quiacstu quit ccatzi̱y cumu quit xCam, na̱ caj xma̱n huá̱ nalakapasa̱ hua̱nti̱ quit nacma̱lakapasni̱putún. ");
INSERT INTO tosNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chi̱nchu̱ huixín hua̱nti̱ scujtamakani̱tántit, chu̱ aya ca̱makatlakuanko̱ni̱tán milatama̱tcán, luhua tuhua̱ makcatzi̱yá̱tit lapá̱tit xta̱chuná̱ pala cucali̱pimpá̱tit aktum tzinca tacuca; huata xatlá̱n caquilaktántit, laqui̱mpi̱ quit nacca̱ma̱jaxayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Luhua li̱pa̱xuhu camakamaklhti̱nántit quintastacya̱hu hua̱ntu̱ quit cma̱sta̱y, chu̱ na̱ aksti̱tum caquiucxilhti̱nítit quilatáma̱t, sa̱mpi̱ quit xli̱ca̱na̱ luhua xapa̱xuhuá, chu̱ luhua xalakalhama̱ná̱ c-quilatáma̱t; lapi̱ chuná̱ nalatapa̱yá̱tit, huixín xli̱ca̱na̱ nama̱jaxako̱yá̱tit mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sa̱mpi̱ yama̱ tastacya̱hu hua̱ntu̱ quit cca̱ma̱xqui̱yá̱n ni̱ pala tzinú̱ tuhua̱ chu̱ yuma̱ tacuca̱ hua̱ntu̱ quit nacca̱ma̱xqui̱yá̱n ni̱ pala tzinú̱ tzinca̱ le̱ncán.” ");
INSERT INTO tosNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Maktum quilhtamacu̱ sábado acxni̱ pacs judíos xjaxko̱y, Jesús chu̱ xli̱ma̱kalhtahuáka̱t hua̱nti̱ csta̱lanima̱kó̱ xti̱puntaxtuma̱kó̱ lakatum tachaná̱n anta̱ni̱ pacs xchancani̱t trigo̱. Cha̱nchu̱ xli̱ma̱kalhtahuáka̱t pi̱ xtzincsma̱kó̱, pus tzucuko̱lh puxko̱y xatahuacat trigo̱, xlakpakxko̱y, chu̱ xuani̱niko̱y xtalhtzi. ");
INSERT INTO tosNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Makapitzi̱n fariseos hua̱nti̱ na̱ antá̱ xmaksta̱lama̱kó̱, xlacán ucxilhko̱lh hua̱ntu̱ xli̱ma̱kalhtahuáka̱t xtlahuama̱kó̱, na̱má̱ huaniko̱lh Jesús: —¿Tú̱ xpa̱lacata̱ yuma̱ mili̱ma̱kalhtahuáka̱t ni̱tú̱ li̱ucxilhni̱nanko̱y, sa̱mpi̱ tlahuama̱kó̱ aktum tascújut hua̱ntu̱ li̱huancán, xahua̱ chiyú̱ li̱jaxat quilhtamacú̱? ");
INSERT INTO tosNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús na̱má̱ kalhti̱ko̱lh: —¿Lá̱ntla̱ pi̱ niucxni̱ a̱li̱kalhtahuakayá̱tit huixín xaSa̱ntujlani Li̱kalhtahuaka̱ anta̱ni̱ li̱chihui̱nán hua̱ntu̱ titláhualh rey David acxni̱ xlá̱ xta̱tzincsni̱ma̱kó̱ xcompañeros? ");
INSERT INTO tosNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Antá̱ huan pi̱ tama̱ David tánu̱lh c-xtemplo̱ Dios, chu̱ hualh yama̱ xatasiculuna̱tlahu caxtala̱nchu̱ hua̱ntu̱ ni̱ pala tzinú̱ xlí̱huat xuani̱t, na̱ ni̱ pala hua̱ xcompañeros, hua̱mpi̱ xlá̱ acxtum ta̱huako̱lh, hua̱ntu̱ xma̱n huá̱ xli̱huatcán xuani̱t pa̱lijni. ");
INSERT INTO tosNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Usu ¿a poco ni̱ a̱li̱kalhtahuakayá̱tit c-xlibro̱ Moisés anta̱ni̱ huan pi̱ hua̱ yuma̱ palijni̱ hua̱nti̱ scujma̱kó̱ c-xtemplo̱ Dios, xlacán ni̱ jaxko̱y ma̱squi lakcha̱ni̱t quilhtamacú̱ sábado la̱ntla̱ jaxcán, hua̱mpi̱ yuma̱ ni̱ li̱huancán? ");
INSERT INTO tosNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pus quit lacatancs cca̱huaniyá̱n pi̱ tlak kalhi̱y ca̱cni̱ ti̱ huí̱ u̱nú̱ cha̱tum ni̱ xahua̱ xtemplo̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Luhua xli̱ca̱na̱ pi̱ huixín ni̱ a̱akata̱ksá̱tit hua̱ntu̱ huamputún xli̱ma̱paksi̱n Dios anta̱ni̱ chuná̱ na̱má̱ tatzoktahuilani̱t c-Li̱kalhtahuaka: ‘Ni̱ clacasquín pi̱ caj xma̱n huá̱ naquili̱lakachixcuhui̱yá̱tit la̱ntla̱ naquili̱ca̱xtlahua̱naniyá̱tit xali̱makni̱t mintakalhi̱ncán, pus huata a̱tzinú̱ luhua tla̱n nacma̱tla̱ni̱y pi̱ naquili̱lakachixcuhui̱yá̱tit la̱ntla̱ acxtum nala̱lakalhamaná̱tit cha̱tunu huixín.’ Lapi̱ xli̱ca̱na̱ xakatá̱kstit tu̱ quinca̱huaniputuná̱n xtachihui̱n Dios, ni̱ xli̱huanikó̱tit, chu̱ ni̱ xtimakstuntlahuaputunkó̱tit yuma̱ hua̱nti̱ ni̱ kalhi̱ko̱y tala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Chu̱ na̱ chuna li̱tum, luhua mili̱catzi̱tcán pi̱ quit Xatalacsacni Chixcú̱ ckalhi̱y li̱ma̱paksí̱n laqui̱mpi̱ nacuaniko̱y tachixcuhuí̱tat la̱ntla̱ tu̱ tla̱n natlahuako̱y ma̱squi acxni̱ quilhtamacu̱ sábado li̱jáxat. ");
INSERT INTO tosNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Acxni̱ Jesús cha̱lh c-actzu̱ ca̱chiquí̱n anta̱ni̱ xama̱kó̱, tánu̱lh c-xpu̱kalhtahuakacan judíos hua̱ntu̱ xuí̱ antá. ");
INSERT INTO tosNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na̱ antá̱ xmakui̱ cha̱tum chixcú̱ hua̱nti̱ csca̱cnini̱t kantum xmacán. Na̱ antá̱ xmakuilakó̱ makapitzi̱n fariseos hua̱nti̱ luhua csi̱tzi̱niko̱y Jesús. Cumu ankalhí̱n xta̱ksniputunko̱y hua̱ntu̱ tla̱n nali̱ya̱huako̱y tala̱kalhí̱n, chu̱ nali̱sta̱huako̱y, cha̱tum na̱má̱ kalhásquilh: —La̱ntla̱ huix huana, ¿pi̱ mini̱niy lapi̱ nama̱pacsacán cha̱tum ta̱tatlá̱ acxni̱ quilhtamacu̱ sábado li̱jáxat? ");
INSERT INTO tosNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús na̱má̱ kalhti̱ko̱lh: —Chi̱nchu̱ lapi̱ cha̱tum huixín kalhi̱y tantum calhni̱lu̱, na̱ pala xtamákuasli̱ ca̱pu̱lhmá̱n, ma̱squi luhua lakcha̱ni̱t quilhtamacú̱ li̱jáxat, ¿a poco ni̱ lacapala̱ catíalh ma̱cutuy? ");
INSERT INTO tosNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pus quit lacatancs cca̱huaniyá̱n pi̱ tlak kalhi̱y lhu̱hua xtápalh cha̱tum chixcú, ni̱ xahua̱ tantum calhni̱lu̱. Pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ ankalhí̱n mini̱niy natlahuayá̱tit hua̱ntu̱ tla̱n ma̱squi lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ jaxcán. ");
INSERT INTO tosNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Puschí̱ Jesús huánilh yama̱ chixcú̱ hua̱nti̱ csca̱cniko̱ni̱t xmacán: —Huix cuaniyá̱n, castonkti̱ mimacán. Acxni̱ xlá̱ stonkli̱ xmacán, xli̱ca̱na̱ pi̱ li̱huana̱ tla̱n tihua̱ xmacán xta̱chuná̱ la̱ntla̱ xa̱pakatu. ");
INSERT INTO tosNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yama̱ fariseos si̱tzi̱ko̱lh, chu̱ acxni̱ taxtuko̱lh tzúculh la̱li̱xakatli̱koy la̱ntla̱ natlahuako̱y laqui̱mpi̱ namakni̱ko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús cátzi̱lh hua̱ntu̱ xlacapa̱stacma̱kó̱ fariseos, huata xlá̱ tatampú̱xtulh, alh a̱lacatanu̱. Luhua lhu̱hua tachixcuhuí̱tat sta̱laniko̱lh, chu̱ xli̱pacs hua̱nti̱ xkalhi̱ko̱y tajátat xlá̱ xma̱pacsama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Acxni̱ xlá̱ xma̱pacsako̱y, luhua li̱huana̱ xuaniko̱y pi̱ ni̱ ta̱ji̱ nali̱chihui̱nanko̱y la̱ntla̱ xtlahuay tlanca li̱ca̱cni. ");
INSERT INTO tosNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yuma̱ hua̱ntu̱ xqui̱taxtuma̱ c-xlatama̱t huá̱ chuná̱ lí̱lalh laqui̱mpi̱ xli̱kantáxtulh hua̱ntu̱ tili̱chihuí̱nalh maka̱sa quilhtamacú̱ profeta Isaías acxni̱ na̱má̱ tihua̱: ");
INSERT INTO tosNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Quit cca̱ma̱lakacha̱nimá̱n quilacscujni̱ hua̱nti̱ clacsacni̱t, luhua cpa̱xqui̱y, chu̱ xli̱ca̱na̱ cli̱pa̱xuhuay caj xpa̱lacata. Quit nacma̱xqui̱y xli̱pacs xli̱tlihuaka quispíritu, chu̱ quintalacapa̱stacni̱, laqui̱mpi̱ xlá̱ chuná̱ lacatancs nali̱akchihui̱naniko̱y hua̱ntu̱ luhua xaxli̱ca̱na̱ xtalacapa̱stacni Dios xli̱pacs tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xlá̱ ni̱ catiaklhu̱huá̱tnalh, chu̱ na̱ ni̱ pixtlanca̱ catichihuí̱nalh, chu̱ ni̱ pixtlanca̱ catiakchihui̱nantá̱yalh ca̱tijí̱n laqui̱mpi̱ fuerza̱ natlahuaniy pi̱ pacs nakaxmatniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xlá̱ li̱pa̱xuhu namakta̱yalé̱n hua̱nti̱ ni̱ kalhi̱y li̱tlihuaka, xta̱chuná̱ la̱ntla̱ kantum ká̱ti̱t hua̱ntu̱ talacchuntatahuilani̱t, chu̱ laktzanka̱ni̱t xlatáma̱t; chu̱ na̱ ni̱ pala catilactlahuánilh xtalacapa̱stacni̱ yama̱ hua̱nti̱ a̱takalán li̱pa̱huán, hua̱mpi̱ fuerza̱ natlahuaniy pi̱ li̱huana̱ cataca̱xtahui̱ hua̱ntu̱ xatla̱n xtalacapa̱stacni Dios u̱nú̱ ca̱tuxá̱huat, ");
INSERT INTO tosNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","chu̱ xa̱huá̱ xli̱pacs ti̱ xala cani̱hua̱ ca̱chiqui̱ní̱n nali̱pa̱huanko̱y, chu̱ nakalhkalhi̱tahuilakoy, sa̱mpi̱ nacatzi̱ko̱y pi̱ huá̱ nalakma̱xtuko̱y.” ");
INSERT INTO tosNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maktum quilhtamacú̱ Jesús li̱minica̱ cha̱tum chixcú ko̱ko̱, chu̱ lakatzí̱n xuani̱t, hua̱ chuná̱ li̱taxtuni̱t sa̱mpi̱ xpa̱laktaju̱ma̱ cspiritu akskahuiní. Puschí̱ Jesús tima̱tlá̱ni̱lh; acxni̱ chú̱ xlá̱ ma̱pacsako̱lh yama̱ chixcú, tla̱n lacahuá̱nalh, chu̱ na̱ tla̱n chihuí̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pacs lanaj xlacahuanko̱ni̱t li̱lhu̱hua̱ hua̱nti̱ ucxilhko̱lh, na̱má̱ xuanko̱y: “¿Pi̱ huatiya cahuá̱ yuma̱ chixcú̱ tali̱pa̱hu xCam Dios hua̱nti̱ xli̱mínat xuani̱t?” ");
INSERT INTO tosNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Hua̱mpi̱ acxni̱ fariseos kalhakaxmatko̱lh hua̱ntu̱ xlacán xquilhuama̱kó̱, chuná̱ huanko̱lh: “Yuma̱ chixcú̱ tla̱n tamacaxtuko̱y cspiritu akskahuiní̱ sa̱mpi̱ xlá̱ huá̱ ta̱scujma̱, chu̱ li̱pa̱huán Beelzebú hua̱nti̱ xapuxcu akskahuiní, chu̱ huá̱ ma̱xqui̱ni̱t xli̱tlihuaka.” ");
INSERT INTO tosNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Cha̱nchu̱ Jesús pi̱ pacs xcatzi̱y hua̱ntu̱ xlacán xpuhuama̱kó̱, xlá̱ na̱má̱ huaniko̱lh: “Huixín catzi̱yá̱tit pi̱ caxati̱cahua̱ xanapuxcun ma̱paksi̱naní̱n xala c-aktum tlanca tíyat, lapi̱ xlacán caj natapa̱pitziko̱y hua̱nti̱ sta̱lanima̱kó̱, chu̱ xacstucán natzucuy la̱ta̱la̱tlahuako̱y, pus chuná̱ ni̱ lay tapalhi̱y yama̱ pu̱ma̱paksí̱n, huata caj nala̱lactlahuaya̱huako̱y. Chu̱ na̱ chuná̱ c-aktum ca̱chiquí̱n, usu c-aktum chiqui, lapi̱ caj xankalhí̱n la̱makasi̱tzi̱huilaca̱, ni̱ lay maka̱s catitapalhi̱ko̱lh, huata caj nalaclata̱yako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pus na̱ chuná̱ chú̱ lapi̱ cha̱tum xlacscujni akskahuiní̱ ta̱la̱tamacaxtuy xta̱lacscujni, pus caj xacstu la̱ma̱pa̱pitziy. ¿La̱ntla̱ cha̱nú̱ chú̱ natapalhi̱y xpu̱ma̱paksi̱n akskahuiní? ");
INSERT INTO tosNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Huixín huántit pi̱ quit ctamacaxtuko̱y cspiritu akskahuiní sa̱mpi̱ mat huá̱ quima̱xqui̱ni̱t xli̱tlihuaka Beelzebú hua̱nti̱ luhua xapuxcu akskahuiní; pus lapi̱ xli̱ca̱na̱ chuná, chi̱nchu̱ yama̱ hua̱nti̱ mili̱ma̱kalhtahuaka̱tcán, chu̱ hua̱nti̱ ca̱ta̱lapulayá̱n, ¿tí̱ ca̱ma̱xqui̱y li̱tlihuaka̱ laqui̱mpi̱ na̱ tla̱n tamacaxtuko̱y cspiritucan akskahuiní? Pus hua̱ yuma̱ nali̱akata̱ksá̱tit pi̱ huixín xli̱ca̱na̱ luhua mákat aktzanka̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Hua̱mpi̱ huata quit ctamacaxtuko̱y cspiritucan akskahuiní sa̱mpi̱ hua̱ Dios quima̱xqui̱ni̱t cSpíritu, chu̱ xli̱tlihuaka, chu̱ na̱ luhua lacatancs li̱tasiyuy pi̱ yama̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ nahuili̱y u̱nú̱ ca̱tiyatna̱ aya tzucuni̱ttá̱ kantaxtuy c-milatama̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Na̱ chuna li̱tum, ¿lá̱ntla̱ cha̱nú̱ natlahuacán natanu̱cana̱chá̱ c-xchic cha̱tum tlihuaka chixcú̱ laqui̱mpi̱ namakkalha̱nancán, hua̱ palapi̱ ni̱ xapu̱lana̱ namakatlajacán, chu̱ li̱huana̱ nachi̱huili̱cán? Lapi̱ chuná̱ natlahuacán, pus tla̱n namakkalhancán pu̱tum hua̱ntu̱ xlá̱ kalhi̱y. Pus na̱ chuná̱ la̱ntla̱ quit cmakatlajani̱t akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Na̱ chuná̱ chú̱ hua̱nti̱ ni̱ quit quinta̱ta̱yay, tamá̱ caj quilaksi̱tzi̱niy hua̱ntu̱ quit cli̱scujma̱, chu̱ na̱ chuná̱ hua̱nti̱ ni̱ acxtum quinta̱ma̱macxtumi̱ko̱y tachixcuhuí̱tat laqui̱mpi̱ quit naclakma̱xtuko̱y, pus huata xlá̱ caj ma̱pa̱pitzima̱ laqui̱mpi̱ li̱huacá̱ nalaktzanka̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Pus huá̱ cca̱li̱huaniyá̱n pi̱ caxati̱cahuá̱ ti̱ Dios tla̱n nama̱tzanka̱naniy xli̱lhu̱hua xtala̱kalhi̱n, chu̱ na̱ chuná̱ pu̱tum caxatu̱cahuá̱ tama̱xcajua̱lí̱n hua̱ntu̱ chihui̱nanko̱ni̱t, hua̱mpi̱ hua̱nti̱ makcatzi cala̱huá̱ nali̱kalhkama̱nán hua̱ntu̱ lacatancs li̱ma̱lacahua̱ni̱ma̱ Espíritu Santo, pus ni̱ lay catima̱tzanka̱nanica̱. ");
INSERT INTO tosNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na̱ chuná̱ yama̱ chixcú̱ hua̱nti̱ cala̱huá̱ xquili̱kalhakamá̱nalh, quit Xatalacsacni Chixcú, fuerza̱ ma̱x tla̱n nama̱tzanka̱nanicán xtala̱kalhí̱n sa̱mpi̱ caj ni̱ catzi̱y, hua̱mpi̱ hua̱nti̱ makcatzi cala̱hua̱ li̱xcajnit tachihuí̱n nali̱kalhkama̱nán hua̱ntu̱ xlá̱ luhua lacatancs catzi̱y pi̱ hua̱ xtascujut Espíritu Santo, ¿lá̱ntla̱ chá̱ nama̱tzanka̱nanicán ca̱quilhtamacú̱, usu hua̱ntu̱ mima̱chá̱ a̱li̱sta̱lh? ");
INSERT INTO tosNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Huá̱ cali̱ucxílhtit akatum quihui̱ pi̱ lapi̱ tla̱n quihui, pus tuncán talakapasa sa̱mpi̱ luhua lacuán tahuacay xtahuácat; hua̱mpi̱ lapi̱ akatum quihui̱ ni̱tlá̱n, na̱ chuná̱ ni̱ lacuán tahuacay xtahuácat; sa̱mpi̱ akatum quihui̱ huá̱ li̱talakapasa̱ xtahuácat. ");
INSERT INTO tosNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Quit luhua lacatancs cca̱lakapasá̱n sa̱mpi̱ huixín akskahuinaná̱tit. ¡Luhua xta̱chuná̱ minta̱yatcán la̱ntla̱ lacli̱xcajnit lu̱hua̱ hua̱ntu̱ tze̱k xcananko̱y! ¿Lá̱ntla̱ chú̱ tla̱n nali̱chihui̱naná̱tit lacuan tachihuí̱n pala antá̱ c-minacu̱cán luhua xli̱ca̱na̱ li̱xcájnit li̱catzi̱yá̱tit? ¿Sa̱mpi̱ cha̱tum chixcú̱ huá̱ li̱chihui̱nán c-xquilhni̱ hua̱ntu̱ xtalacapa̱stacni̱ kalhi̱y c-xnacú̱? ");
INSERT INTO tosNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yama̱ chixcú̱ hua̱nti̱ luhua tla̱n xtapuhuá̱n, hua̱ xlá̱ li̱chihui̱nán hua̱ntu̱ lacuan tachihuí̱n sa̱mpi̱ pacs huá̱ huí̱ c-xnacú̱. Hua̱mpi̱ hua̱nti̱ luhua li̱xcájnit xtapuhuá̱n, hua̱ xlá̱ li̱chihui̱nán hua̱ntu̱ lacli̱xcájnit sa̱mpi̱ pacs hua̱ntu̱ ni̱ lacuan huí̱ c-xnacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hua̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ nama̱xoko̱ni̱ko̱cán tachixcuhuí̱tat tu̱ tlahuako̱ni̱t, xli̱pacs la̱ntla̱ cha̱tunu̱ nama̱sta̱ko̱y cue̱nta̱ la̱ntla̱ caj lakahuán chihui̱nanko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sa̱mpi̱ caj xpa̱lacata la̱ntla̱ kalhatunu mintachihui̱ncán hua̱ntu̱ naca̱ma̱kalhapali̱caná̱tit huixín, naca̱li̱putza̱nanicaná̱tit, chuná̱ chú̱ naca̱ma̱catzi̱ni̱caná̱tit lapi̱ ni̱tú̱ li̱piná̱tit cue̱nta̱, usu huí̱ tu̱ nali̱tamakstuntlahuayá̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Maktum, makapitzi̱n fariseos, chu̱ laktzokqui̱naní̱n lakminko̱lh Jesús, chu̱ na̱má̱ huaniko̱lh: —Ma̱kalhtahuaka̱ná, quin clacasquina̱hu pi̱ huix xtlahua̱ aktum tlanca li̱ca̱cni tatlahu laqui̱mpi̱ xacli̱ucxilhui̱ pi̱ xli̱ca̱na̱ Dios macamini̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús na̱má̱ kalhti̱ko̱lh: —Luhua xaaktzanká̱n lapá̱tit huixín u̱nú̱ ca̱quilhtamacú̱, sa̱mpi̱ xli̱ca̱na̱ pi̱ luhua lacli̱xcájnit mintapuhua̱ncán, na̱ xali̱kama̱n tlahuananí̱n, huixín lacasquiná̱tit cactláhualh aktum tlanca li̱ca̱cni tatlahu laqui̱mpi̱ naquili̱pa̱huaná̱tit. Hua̱mpi̱ quit ni̱tú̱ cactica̱li̱ma̱lakasta̱ní̱n hua̱ntu̱ huixín ucxilhputuná̱tit, huata xatlá̱n caj huá̱ nacca̱li̱ma̱lacahua̱ni̱yá̱n aktum tatlahu xta̱chuná̱ hua̱ntu̱ Dios titláhualh c-xlatama̱t profeta Jonás. ");
INSERT INTO tosNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pus chuná̱ la̱ntla̱ Jonás xtaju̱ma̱ aktutu quilhtamacú̱, chu̱ aktutu tzi̱sní̱ c-xpu̱lacni tlanca squi̱ti, na̱ chuná̱ chú̱ quit Xatalacsacni Chixcú̱ aktutu quilhtamacú̱, chu̱ aktutu tzi̱sní̱ ctaju̱ma̱ nahuán c-xtampu̱n tíyat. ");
INSERT INTO tosNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ Dios nata̱tlahuako̱y xcue̱ntajcán tachixcuhuí̱tat, yama̱ chixcuhuí̱n hua̱nti̱ xamaka̱n quilhtamacú̱ xuilakó̱ c-xaca̱chiqui̱n Nínive, xlacán nata̱yako̱y c-xlacati̱n Dios, chu̱ naca̱ma̱lacapu̱ko̱yá̱n huixín, sa̱mpi̱ acxni̱ xlá̱ Jonás li̱akchihui̱naniko̱lh xtachihui̱n Dios, xlacán tilakpali̱ko̱lh xali̱xcajnit xtalacapa̱stacnicán; huá̱ hua̱ntu̱ huixín ni̱ lay tlahuayá̱tit, ma̱squi xli̱ca̱na̱ u̱nú̱ huí̱ cha̱tum hua̱nti̱ tlak tlanca̱ kalhi̱y xlacatzúcut ni̱ xahua̱ Jonás. ");
INSERT INTO tosNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na̱ chuná̱ hua̱nti̱ xli̱hui̱ puxcu̱na pusca̱t hua̱nti̱ maka̱n xma̱paksi̱nán c-aktum tíyat c-sur huanicán Sheba, xlá̱ na̱ nata̱yay c-xlacati̱n Dios acxni̱ naca̱ta̱tlahuacaná̱tit mincuentajcán mili̱pacscán hua̱nti̱ lapá̱tit la̱nchuj quilhtamacú̱, yama̱ reina pusca̱t na̱ naca̱makstuntlahuayá̱n, sa̱mpi̱ ma̱squi luhua mákat xuani̱t c-xtíyat hua̱mpi̱ fuerza̱ tímilh laqui̱mpi̱ nakaxmatniy xtachihuí̱n la̱ntla̱ xkalhi̱y xli̱skalala xamaka̱n rey Salomón, hua̱mpi̱ huixín ni̱ pala tzinú̱ quinkaxpatniputuná̱tit ma̱squi u̱nú̱ ca̱ta̱chihui̱namá̱n cha̱tum hua̱nti̱ tlak tlanca̱ xlacatzúcut ni̱ xahua̱ la̱ntla̱ yama̱ rey Salomón. ");
INSERT INTO tosNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Acxni̱ cspiritu akskahuiní̱ ma̱makaxtaknicán cha̱tum chixcú̱ xlá̱ an putzay a̱lacatanu̱ anta̱ni̱ tla̱n natahuilay, chu̱ an lata̱kchokoy anta̱ni̱ mákat; hua̱mpi̱ huata acxni̱ ni̱ ta̱ksa̱ chuná̱ puhuán: ");
INSERT INTO tosNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Huata xatlá̱n nactaspitpalay c-quínchic anta̱ni̱ ctaxtuni̱tanchá.’ Acxni̱ chú̱ xlá̱ chimpalay, ma̱noklhuy yama̱ chixcú̱ xta̱chuná̱ aktum chíqui hua̱ntu̱ caj chunata yá̱, chu̱ ni̱tú̱ huilakó̱, xa̱huá̱ li̱huana̱ ma̱ca̱qui̱nancani̱t, chu̱ palhnancani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Puschí̱ huata xlá̱ lacapala̱ an tiyako̱y a̱kalhatujun xta̱spíritu̱ hua̱nti̱ a̱tzinú̱ luhua lacli̱xcájnit li̱catzi̱ko̱y, chu̱ antá̱ pu̱tum anko̱y tahuilako̱y c-xlatáma̱t yama̱ chixcú. Huá̱ chú̱ yuma̱ chixcú̱ hua̱nti̱ aya xtatla̱ni̱ni̱t, ca̱x a̱tzinú̱ luhua lacli̱xcájnit huan xtapuhuá̱n ni̱ xahua̱ la̱ntla̱ xakasiya̱. Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ na̱ pacs chuná̱ nacaakspulayá̱n huixín hua̱nti̱ la̱nchu̱ quilhtamacú̱ u̱nú̱ lapá̱tit, sa̱mpi̱ xli̱ca̱na̱ ni̱ lay quili̱pa̱huaná̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chunacú̱ cxakatli̱ma̱kó̱ chixcuhuí̱n c-chiqui̱ antani̱ xuí̱ acxni̱ chinko̱lh xtzi, chu̱ makapitzi̱n xli̱nata̱lán, xlacán xta̱chihui̱namputunko̱y, chu̱ antá̱ ta̱yako̱chá̱ c-quilhtí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cha̱tum chixcú̱ huánilh Jesús: —Mintzí, chu̱ makapitzi̱n mili̱nata̱lán a̱ya̱ko̱chá̱ c-quilhtí̱n, ta̱chihui̱namputunko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hua̱mpi̱ huata xlá̱ kálhti̱lh hua̱nti̱ chuná̱ ma̱catzí̱ni̱lh, huánilh: —¿Tí̱ yuma̱ quintzí, chu̱ tí̱ yuma̱ luhua quili̱nata̱lán? ");
INSERT INTO tosNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huata xlá̱ huá̱ laklaca̱nko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ na̱má̱ huá̱: —Hua̱ yumá̱ quintzí, xa̱hua̱ quili̱nata̱lán. ");
INSERT INTO tosNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sa̱mpi̱ caxati̱cahuá̱ hua̱nti̱ natlahuako̱y xli̱ma̱paksi̱n Quintla̱t hua̱nti̱ huilachá̱ c-akapú̱n xli̱ca̱na̱ pi̱ hua̱ tamá̱ quinta̱lá, chu̱ na̱ hua̱ quintzí. ");
INSERT INTO tosNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Huatiya̱ yuma̱ quilhtamacú̱ Jesús táca̱xli̱ c-chiqui, chu̱ táxtulh alh c-xquilhtu̱n ta̱kaya̱huaná. Antá̱ titahui̱ laqui̱mpi̱ chuná̱ nali̱akchihui̱naniko̱y tachixcuhuí̱tat xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hua̱mpi̱ cumu luhua lhu̱hua̱ la̱ntla̱ tamacxtumi̱ko̱lh anta̱ni̱ xlá̱ xuí̱, huata xatlá̱n táju̱lh c-aktum pu̱tacutnu, antá̱ culucs tahui̱, hua̱nchú̱ a̱makapitzí̱n la̱ntla̱ xli̱lhu̱hua̱ antá̱ ta̱yako̱lh c-xquilhtu̱n chúchut laqui̱mpi̱ nakaxmatniko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jesús lhu̱hua̱ hua̱ntu̱ li̱xakatli̱ko̱lh caj takalhchihuí̱n, chu̱ na̱ huaniko̱lh yuma̱ takalhchihuí̱n: “Maktum quilhtamacú̱ cha̱tum chana̱ná̱ alh chán xatalhtzi xli̱chánat. ");
INSERT INTO tosNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cha̱nchu̱ la̱ntla̱ xchana̱nanti̱lhay makapitzi̱n xli̱chánat tama̱ko̱chá̱ c-tiji; caj li̱puntzú̱ minko̱chá̱ lactzu̱ spu̱n, chu̱ sacuaqui̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chi̱nchu̱ makapitzi̱n xli̱chánat tama̱ko̱chá̱ ca̱chihuixni̱ anta̱ni̱ ni̱tú̱ xkalhi̱y tíyat anta̱ni̱ nama̱ti̱ju̱ko̱y xtankáxe̱k. Yama̱ li̱chánat lacapala̱ pulhli̱ sa̱mpi̱ ni̱ lhu̱hua̱ xkalhi̱y tíyat. ");
INSERT INTO tosNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Hua̱mpi̱ acxni̱ taxtuchi̱ chichiní, chu̱ li̱pe̱cua̱ tzúculh akchichín, lacapala̱ sca̱cli sa̱mpi̱ ni̱ li̱huana̱ xma̱ti̱ju̱ni̱t xtankáxe̱k. ");
INSERT INTO tosNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Makapitzi̱n xli̱chánat tama̱ko̱chá̱ ca̱lhtucu̱ní̱n; yama̱ lhtucú̱n la̱li̱huán stacli, chu̱ ma̱aklankanu̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hua̱mpi̱ huata makapitzi̱n xli̱chánat tama̱ko̱chá̱ c-xatla̱n tíyat, chu̱ acxni̱ stacko̱lh luhua lhu̱hua̱ tahuácalh xalí̱huat; makapitzi̱n tachaná̱n huí̱ tu̱ xkalhi̱y ma̱x pala aktum ciento xtalhtzi caj la̱ntla̱ akatum xaquihui, makapitzí̱n pala tutumpuxam, chu̱ makapitzí̱n ma̱x pala puxamaca̱hu caj la̱ntla̱ akatunu tachaná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","¡Lapi̱ huixín kalhi̱yá̱tit mili̱akahua̱ncán pus li̱huana̱ cakaxpáttit laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ cca̱ma̱akata̱ksni̱putuná̱n!” ");
INSERT INTO tosNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Caj li̱puntzú̱ yama̱ xli̱ma̱kalhtahuáka̱t Jesús laktalacatzuhui̱ko̱lh anta̱ni̱ xlá̱ xuí̱, chu̱ na̱má̱ tikalhasquinko̱lh: “¿Tú̱ xpa̱lacata acxni̱ huix ma̱siyuniko̱ya̱ tachixcuhuí̱tat xtachihui̱n Dios caxatu̱cahuá̱ li̱ma̱xtuniko̱ya̱ mintachihuí̱n, sa̱mpi̱ huix catzi̱ya̱ pi̱ tzinú̱ tuhua̱ naakata̱ksko̱y?” ");
INSERT INTO tosNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Cha̱nchu̱ xlá̱ kalhtí̱nalh, huaniko̱lh: “Huixín xli̱ca̱na̱ pi̱ Dios ca̱ma̱catzi̱ni̱putuná̱n, laqui̱mpi̱ naakata̱ksá̱tit la̱ntla̱ xlá̱ lacapa̱stacni̱t nahuili̱y xasa̱sti xtapáksi̱t u̱nú̱ ca̱tiyatna, hua̱mpi̱ hua̱ la̱ntla̱ xli̱pacs hua̱nti̱ ni̱ quista̱laniko̱y, xlacán ni̱ lay akata̱ksko̱y la̱ntla̱ luhua naqui̱taxtuy. ");
INSERT INTO tosNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa̱mpi̱ hua̱nti̱ li̱tzaksay akata̱ksa̱ yuma̱ xatla̱n talacapa̱stacni, hua̱ntu̱ kalhi̱y ta̱kata̱ksni a̱tzinú̱ nama̱li̱hua̱ca̱nicán, chu̱ a̱tzinú̱ pacs nakalhi̱y; hua̱mpi̱ hua̱nti̱ ni̱ li̱tzaksaputún cacátzi̱lh, pi̱ hua̱ntu̱ kalhi̱y namaklhti̱cán hasta ma̱squi caj xma̱n huá̱ hua̱ntu̱ tzinú̱ ta̱kata̱ksni̱ kalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pus huachá̱ xpa̱lacata cli̱ma̱xtunikoy caxatu̱cahuá̱ hua̱ntu̱ tzinú̱ tuhua̱ nali̱akata̱ksko̱y acxni̱ quit cli̱xakatli̱ko̱y, laqui̱mpi̱ ma̱squi kaxmatko̱y quintachihuí̱n chunatiya tamakaxtakko̱y la̱mpala ni̱tu̱ kaxmatko̱ni̱t, chu̱ ma̱squi xlacán ucxilhma̱kó̱ hua̱ntu̱ quit cma̱kantaxti̱ma̱, chunatiya tamakaxtakko̱y la̱mpala ni̱tú̱ ucxilhko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pus antá̱ chú̱ c-xlatama̱tcán yuma̱ chixcuhuí̱n li̱kantaxtuy hua̱ntu̱ xamaka̱n quilhtamacú̱ tili̱chihuí̱nalh profeta Isaías acxni̱ na̱má̱ huá̱: ‘Yuma̱ tachixcuhuí̱tat ma̱squi cakaxmatko̱lh hua̱ntu̱ lacuan tastacya̱hu, hua̱mpi̱ ni̱tú̱ catiakata̱ksko̱lh; ma̱squi na̱ caucxilhko̱lh lactlanca li̱ca̱cni quintatlahu, hua̱mpi̱ chunatiya natamakaxtakko̱y la̱mpala ni̱tú̱ ucxilhko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Xnacu̱can yuma̱ tachixcuhuí̱tat luhua xli̱ca̱na̱ tzaca̱tlako̱ni̱t; ma̱squi xlacán kaxmatko̱y hua̱mpi̱ ni̱ lay akata̱ksko̱y, ma̱squi luhua kalhi̱ko̱y xlakastapucán chunatiya la̱ntla̱ lakatzí̱n lama̱kó̱. Hua̱mpi̱ chuná̱ akspulako̱ni̱t sa̱mpi̱ ma̱n xlacán chuná̱ lacasquinko̱ni̱t pi̱ ni̱ cali̱lacahua̱nanko̱lh xlakastapucán, chu̱ na̱ ni̱ cali̱kaxmatko̱lh xtaka̱ncán, chu̱ na̱ ni̱ pala cali̱akata̱ksko̱lh xnacu̱cán. Huá̱ xacstucán le̱nko̱y cui̱nta̱ lapi̱ talakaspitta̱yako̱y, chu̱ quili̱pa̱huanko̱y laqui̱mpi̱ quit naclakalhamanko̱y, chu̱ nacma̱pacsako̱y xli̱stacnacán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Hua̱mpi̱ luhua ca̱na̱ li̱pa̱xuhu huixín sa̱mpi̱ kalhi̱yá̱tit milakastapucán, chu̱ li̱ucxilhá̱tit hua̱ntu̱ ctlahuay, na̱ kalhi̱yá̱tit mintaka̱ncán, chu̱ li̱kaxpatá̱tit quintachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Sa̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ lhu̱hua̱ profetas, chu̱ lacuan chixcuhuí̱n hua̱nti̱ maka̱n quilhtamacú̱ qui̱latama̱ko̱chi, hua̱ xlacán na̱ luhua xucxilhputunko̱y hua̱ntu̱ huixín la̱nchú̱ ucxilhpá̱tit, hua̱mpi̱ xlacán ni̱ ucxilhko̱lh; na̱ xkaxmatputunko̱y hua̱ntu̱ huixín la̱nchú̱ kaxpatpá̱tit hua̱mpi̱ huata xlacán ni̱ ma̱xqui̱ko̱ca̱ quilhtamacú̱ nakaxmatko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Huixín luhua li̱huana̱ cakaxpáttit, chu̱ caakatá̱kstit hua̱ntu̱ cuani̱t yuma̱ takalhchihui̱n xla cha̱tum chana̱ná: ");
INSERT INTO tosNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ c-tiji, chu̱ sacuaqui̱ko̱lh lactzu̱ spu̱n, huá̱ cli̱ma̱xtuy caxati̱cahuá̱ ti̱ kaxmatko̱y xtachihui̱n Dios, chu̱ la̱ntla̱ xlá̱ lacasquín nalatama̱ko̱y c-xasa̱sti xtapáksi̱t. Xlacán kaxmatko̱y, hua̱mpi̱ a̱li̱sta̱lh mina̱chá̱ akskahuiní chú̱ ma̱pa̱nu̱niy yama̱ lacuan tachihuí̱n hua̱ntu̱ xchancani̱t c-xnacu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chi̱nchu̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ ca̱lacchihuixni, huá̱ cli̱ma̱xtuy yama̱ ti̱ kaxmatko̱y xtachihui̱n Dios, xli̱ca̱na̱ luhua aktum tapa̱xuhuá̱n ca̱najlako̱y, lakati̱ko̱y, chu̱ tla̱n tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Hua̱mpi̱ cumu ni̱ luhua pu̱lhmá̱n xkalhi̱y xtankáxe̱ka, ni̱ luhua maka̱s makapalako̱y, acxni̱ chú̱ min tu̱ nali̱talactuhuajko̱y, usu huí̱ ti̱ soka̱li̱ko̱y caj xpa̱lacata li̱pa̱huanko̱y xtachihui̱n Dios, tzucuy li̱puhuanko̱y, huata tu̱ xlacán tlahuako̱y xatlá̱n tuncán talacapa̱nu̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chi̱nchu̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ ca̱lhtucu̱ní̱n xlacán huá̱ li̱taxtuko̱y hua̱nti̱ kaxmatko̱y hua̱mpi̱ huata a̱tzinú̱ li̱ta̱katzanka̱ko̱y catu̱huá̱ hua̱ntu̱ caj xala ca̱tuxá̱huat, la̱ntla̱ nakalhi̱ko̱y lhu̱hua tumi̱n, chu̱ la̱ntla̱ li̱pa̱xuhu nalatama̱ko̱y, pus chuná̱ li̱ta̱kskahuitama̱ko̱y pu̱tum hua̱ntu̱ xlacán lakati̱ko̱y, caj chuna̱ na̱má̱ li̱ma̱aklankanu̱ko̱y tu̱ catzi̱ko̱y xtapaksi̱t Dios, ni̱ ma̱xqui̱ko̱y talacasquín ma̱sta̱y xtahuácat c-xlatama̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hua̱mpi̱ yama̱ tachaná̱n hua̱ntu̱ tama̱ko̱chá̱ c-xatla̱n tíyat, huá̱ xlacán li̱taxtuko̱y hua̱nti̱ kaxmako̱y, chu̱ na̱ akata̱ksko̱y xtachihui̱n Dios, xlacán tlahuako̱y hua̱ntu̱ antá̱ li̱ma̱paksi̱ko̱y, tapalhi̱niko̱y, lhu̱hua̱ chú̱ hua̱ntu̱ li̱ma̱siyuko̱y xatahuácat. Makapitzí̱n xta̱chuná̱ yama̱ li̱chánat hua̱ntu̱ ma̱sta̱ko̱lh aktum ciento xtalhtzi caj la̱ntla̱ta akatum, chu̱ makapitzí̱n xta̱chuná̱ la̱ntla̱ ti̱ ma̱sta̱ko̱lh tutumpuxam, chu̱ puxamaca̱hu.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús na̱ tili̱xakatli̱ko̱lh yuma̱ takalhchihuí̱n: “Yuma̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱tzuqui̱putún u̱nú̱ ca̱tiyatna, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ lacuan li̱chánat hua̱ntu̱ cha̱tum chixcú̱ chálh c-xpú̱cuxtu. ");
INSERT INTO tosNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hua̱mpi̱ acxni̱ tzí̱sualh pacsá clhtatama̱ko̱ca̱, ca̱tzi̱sní̱ tze̱k tanu̱chi̱ cha̱tum hua̱nti̱ csi̱tzi̱niy xpu̱chiná̱ pú̱cuxtu, chu̱ antá̱ xlá̱ tzúculh xpuyumakán catu̱cahuá̱ hua̱ntu̱ ni̱ lacuan tachaná̱n c-xlaksti̱pa̱ncan trigo̱; acxni̱ chuná̱ tlahuako̱lh lacapala̱ alh. ");
INSERT INTO tosNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Acxni̱ yama̱ trigo̱ stacli, chu̱ tzúculh tahuacay xtahuácat, na̱ hasta acxnicú̱ tzúculh tasiyuy xani̱ma̱ caj xachunata tuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Cscujní̱n hua̱nti̱ antá̱ cscujma̱kó̱, lacapala̱ anko̱lh huaniko̱y xma̱la̱nacán: ‘Tla̱ti, lapi̱ caj xlakstu trigo̱ tíchanti̱ yuma̱ c-mipú̱cuxtu, ¿ní̱ chú̱ minchá̱ yama̱ xali̱xcajnit li̱chánat?’ ");
INSERT INTO tosNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xpu̱chiná̱ yama̱ tachaná̱n, na̱má̱ huaniko̱lh: ‘Huá̱ cha̱tum ti̱ luhua quinca̱si̱tzi̱niyá̱n chuná̱ quinca̱tlahuani̱tán.’ Xlacán huanipalako̱lh: ‘¿Lá̱ntla̱ chí̱ Huana? ¿Pi̱ lacasquina̱ pi̱ cana̱hu pulhumakana̱hu tama̱ li̱xcájnit tuhuá̱n?’ ");
INSERT INTO tosNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hua̱mpi̱ xlá̱ huaniko̱lh: ‘Ni̱ chuná̱ catlahuátit, ¿chá̱mpala xamaktum acxni̱ huixín pulhupá̱tit nahuán tuhuá̱n na̱ napulhuyá̱tit yama̱ trigo̱? ");
INSERT INTO tosNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Huata xatlá̱n lacxtum castacko̱ka̱lh hasta acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ pu̱tum nama̱macxtumi̱cán quintachaná̱n, acxnicú̱ nacuaniko̱y scujní̱n pi̱ xapu̱lh huá̱ napulhuko̱y hua̱ntu̱ ni̱ xatla̱n tuhuá̱n, na̱ tanuj napa̱chi̱cán laqui̱mpi̱ nalaclhcuyuhuili̱cán. Ali̱sta̱lh chú̱ nama̱macxtumi̱cán trigo̱, li̱huana̱ nama̱qui̱cán xlá.’” ");
INSERT INTO tosNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús na̱ tili̱xakatli̱palako̱lh yuma̱ takalhchihuí̱n: “Yama̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱tzuqui̱ma̱ ca̱tiyatna, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ staca̱ yama̱ aktum xali̱chanat quihui̱ hua̱ntu̱ huanicán mostaza, acxni̱ cha̱tum chixcú̱ chán c-xpú̱cuxtu. ");
INSERT INTO tosNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Xli̱ca̱na̱ pi̱ huá̱ yuma̱ xtalhtzi quihui̱ hua̱ntu̱ tlak luhua actzú̱, acti̱ná̱ la̱ntla̱ xli̱pacs a̱makapitzi̱n tachaná̱n hua̱ntu̱ lactlanca stacko̱y, hua̱mpi̱ ma̱squi chuná, acxni̱ xlá̱ lacapala̱ pun, chu̱ na̱ lacapala̱ tzucuy staca, hasta tlanca quihui̱ huan; chu̱ luhua lhu̱hua̱ kalhi̱y xpakaní̱n, chu̱ hasta lactzu̱ spu̱n hua̱ntu̱ kosko̱y ca̱u̱ní̱n antá̱ xlacán tla̱n tlahuay xma̱sakacán c-xpakaní̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na̱ tili̱xakatli̱palako̱lh yuma̱ aktum li̱tum takalhchihuí̱n, huaniko̱lh: “Huá̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱tzuqui̱ma̱ u̱nú̱ ca̱tiyatna̱ luhua xta̱chuná̱ nata̱kahuani̱y la̱ntla̱ lay actzu̱ levadura acxni̱ cha̱tum pusca̱t ta̱lakuilhapa̱spita̱ xcaxtala̱squítit tu̱ tipú̱lhca̱lh pa̱tutu. Yama̱ levadura lacatzucu̱ tzucuy tlahuay xtascújut hasta acxni̱ ma̱paklhako̱y xli̱pacs xli̱tlanca̱ yama̱ xatalakmun xcaxtala̱squítit.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Cha̱nchu̱ Jesús acxni̱ cxakatli̱ko̱y tachixcuhuí̱tat, ankalhí̱n caj catu̱huá̱ xli̱ma̱xtuniko̱y xtakalhchihuí̱n, niucxni̱ tú̱ xli̱xakatli̱ko̱y lapi̱ ni̱ huí̱ tú̱ nali̱ma̱xtuniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Pus huá̱ chuná̱ li̱tláhualh laqui̱mpi̱ nama̱kantaxti̱y hua̱ntu̱ tili̱chihuí̱nalh profeta Isaías acxni̱ chuná̱ tzóknu̱lh c-xlibro̱: “Acxni̱ quit nacxakatli̱ko̱y tachixcuhuí̱tat, catu̱huá̱ hua̱ntu̱ nacli̱ma̱lacastucniko̱y quintachihuí̱n; lhu̱hua̱ hua̱ntu̱ lacuan talacapa̱stacni̱ nacuán hua̱ntu̱ xta̱ktze̱ktahuilani̱t hasta la̱ntla̱ Dios tima̱lacatzúqui̱lh ca̱tuxá̱huat.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Acxni̱ Jesús huaniko̱lh yama̱ chixcuhuí̱n pi̱ caanko̱lhá̱ c-xchiccán, xlá̱ na̱ ta̱anko̱lh xli̱ma̱kalhtahuáka̱t c-chiqui̱ anta̱ni̱ natamakaxtakko̱y. Acxni̱ cha̱nko̱lh, xli̱ma̱kalhtahuáka̱t na̱má̱ huaniko̱lh: “Xtlahua̱ tlanca li̱tlá̱n, xquinca̱huani̱ hua̱ntu̱ ma̱akata̱ksni̱namputún yama̱ xatakalhchihui̱n li̱xcajnit tuhuá̱n hua̱ntu̱ xpulhni̱t c-xlaksti̱pa̱ncan xalacsuan li̱chánat hua̱ntu̱ xchancani̱t c-pú̱cuxtu.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Huata xlá̱ na̱má̱ huaniko̱lh: “Yama̱ chixcú̱ hua̱nti̱ chalh xatla̱n li̱chánat, pus huatiya̱ quit Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chi̱nchu̱ hua̱ pú̱cuxtu, pus huá̱ la̱ntla̱ xli̱ca̱tlanca̱ ca̱tuxá̱huat. Yama̱ xatla̱n li̱chánat huá̱ li̱taxtuko̱y hua̱nti̱ ca̱najlako̱ni̱t quintachihuí̱n, chu̱ tapaksi̱niko̱y Dios; chi̱nchu̱ hua̱ xali̱xcajnit tuhuá̱n huá̱ xlacán li̱taxtuko̱y hua̱nti̱ tapaksi̱niko̱y akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chi̱nchu̱ hua̱nti̱ luhua si̱tzi̱niy xpu̱china tachaná̱n, pus huatiya̱ li̱taxtuy akskahuiní. Yama̱ li̱xká̱nat huá̱ huaniputún la̱ntla̱ nasputa̱ xli̱ca̱tlanca̱ ca̱tuxá̱huat; chu̱ yuma̱ xka̱naní̱n hua̱nti̱ namacaminko̱cán laqui̱mpi̱ nama̱macxtumi̱ko̱y hua̱ntu̱ ya̱kó̱ xalí̱xka̱t, pus xlacán hua̱ ángeles. ");
INSERT INTO tosNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na̱ chuná̱ tu̱ ma̱akspuli̱cán ni̱tla̱n tuhuá̱n acxni̱ naxka̱nancán, pu̱lh huá̱ li̱cúxtut pulhucán, li̱huana̱ ma̱macxtumi̱cán, chu̱ lhcuyucán, pus na̱ chuná̱ chú̱ naqui̱taxtuy acxni̱ nasputcán ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Quit Xatalacsacni Chixcú̱ nacma̱lakacha̱ko̱y quiángeles laqui̱mpi̱ nama̱macxtumi̱ko̱y xli̱pacs yama̱ chixcuhuí̱n hua̱nti̱ ma̱tlahui̱ko̱y tala̱kalhí̱n a̱makapitzí̱n, chu̱ xli̱pacs hua̱nti̱ luhua lacli̱xcájnit xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Xlacán antá̱ natamacapu̱ko̱cán c-tlanca lhcúya̱t laqui̱mpi̱ antá̱ natasako̱y, chu̱ nama̱lacsa̱ni̱ko̱y xtatzancán caj xpa̱lacata xtapa̱ti̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Chi̱nchu̱ yamá̱ hua̱nti̱ tlahuako̱ni̱t hua̱ntu̱ xatla̱n tatlahu c-xlatama̱tcán xlacán li̱pe̱cua̱ la̱ntla̱ namacaxkaka̱nanko̱ya̱chá̱ c-xpu̱ma̱paksi̱n Quintla̱tican Dios xta̱chuná̱ la̱ntla̱ chichiní. ¡Lapi̱ huixín kalhi̱yá̱tit mili̱akahua̱ncán pus li̱huana̱ cakaxpáttit laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ cca̱ma̱akata̱ksni̱putuná̱n! ");
INSERT INTO tosNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Hua̱nti̱ huacu kaxmata̱ pi̱ li̱chihui̱nancán xasa̱sti xli̱ma̱paksi̱n Dios, chu̱ luhua lakati̱y, pus xlá̱ luhua xta̱chuná̱ li̱taxtuy la̱ntla̱ yama̱ chixcú̱ hua̱nti̱ ta̱ksa̱ aktum lhu̱hua tumi̱n, pacs xla oro, hua̱ntu̱ xma̱acnu̱cani̱t c-aktum pú̱cuxtu. Acxni̱ cátzi̱lh pi̱ chuná, huata xlá̱ lacapala̱ ma̱acnu̱palay, chá̱pa̱xuhua̱na̱ taspita̱ c-xchic, pacs sta̱ko̱y hua̱ntu̱ xkalhi̱y laqui̱mpi̱ tla̱n chú̱ natama̱huay yama̱ pú̱cuxtu. ");
INSERT INTO tosNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Na̱ chuna li̱tum yama̱ hua̱nti̱ huacu kaxmata̱ la̱ntla̱ li̱chihui̱nancán xasa̱sti xtapaksi̱t Dios, chu̱ xlá̱ luhua lakati̱y, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ cha̱tum chixcú̱ hua̱nti̱ sta̱nán, chu̱ tama̱huanán, chu̱ putzatla̱huán lacuan perlas, hua̱mpi̱ hua̱ntu̱ luhua xli̱ca̱na̱ xalacuán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hua̱mpi̱ lapi̱ chú̱ naqui̱ta̱ksa̱ aktum hua̱ntu̱ luhua xatlá̱n, chu̱ xlá̱ tancs catzi̱y pi̱ hua̱ yumá̱ luhua xatapala̱xla, huata lacapala̱ taspita̱ c-xchic, sta̱ko̱y pacs la̱ntla̱ tu̱ kalhi̱y laqui̱mpi̱ tla̱n chú̱ natama̱huay yama̱ xatla̱n perla. ");
INSERT INTO tosNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Yama̱ xasa̱sti xtapaksi̱t Dios na̱ luhua xta̱chuná̱ naqui̱taxtuy la̱ntla̱ tza̱lh acxni̱ muju̱cán c-ta̱kaya̱huaná, chu̱ ti̱pa̱lhu̱hua̱ caxatu̱cahua̱ squi̱ti, pacs pu̱chipacán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Acxni̱ chú̱ tatzamay tza̱lh la̱ntla̱ lhu̱hua squi̱ti̱ xtaju̱ni̱tanchá, yama̱ squi̱ti̱naní̱n, xuatacutuko̱y c-xquilhtu̱n chúchut, antá̱ chú̱ xlacán culucs lakatahuilako̱y tzucuy lacsacko̱y squi̱ti. Hua̱ntu̱ xalacuan squi̱ti̱ li̱huana̱ pu̱ma̱qui̱ko̱y pakxu, chu̱ hua̱ntu̱ ni̱ xalacuán, ni̱ le̱nko̱y, huata caj makanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pus na̱ chuná̱ naqui̱taxtuy acxni̱ nasputa̱ ca̱tuxá̱huat, naminko̱ya̱chá̱ ángeles c-akapú̱n laqui̱mpi̱ nama̱pa̱pitziko̱cán hua̱nti̱ lacli̱xcájnit li̱catzi̱ko̱y c-xlaksti̱pa̱ncán hua̱nti̱ lacuán xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huá̱ chú̱ yamá̱ hua̱nti̱ luhua lacli̱xcájnit kalhi̱ko̱y xtapuhua̱ncán, pus huá̱ namaca̱nko̱cán c-lhcúya̱t laqui̱mpi̱ antá̱ nama̱lacsa̱ni̱y, usu nala̱li̱xcay xtatzancán caj xpa̱lacata yama̱ li̱pe̱cua tapa̱tí̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesús na̱má̱ kalhasquinko̱lh hua̱nti̱ cxakatli̱ma̱kó̱: —¿Pi̱ pacs akata̱ksá̱tit hua̱ntu̱ quit cca̱huanimá̱n? Xlacán kalhti̱nanko̱lh: —Cakata̱ksa̱hu, tla̱ti. ");
INSERT INTO tosNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Huata xlá̱ na̱má̱ huanipalako̱lh: —Lapi̱ chuná, pus mili̱catzi̱tcán pi̱ cha̱tum hua̱nti̱ luhua li̱huana̱ li̱kalhtahuakani̱t hua̱ntu̱ la̱ntla̱ xuí̱ xamaka̱n xli̱ma̱paksi̱n Dios, chu̱ lapi̱ na̱ lakapasma̱ xli̱pacs la̱ntla̱ aksti̱tum nali̱latama̱ya̱hu c-xasa̱sti xtapáksi̱t, pus luhua xta̱chuná̱ li̱taxtuy la̱ntla̱ cha̱tum ma̱tamacu̱nú̱ hua̱nti̱ xpu̱china aktum tlanca chiqui̱ anta̱ni̱ ma̱qui̱ni̱t xtalacapa̱stacni, sa̱mpi̱ ni̱ xma̱n huá̱ catzi̱y la̱ntla̱ nama̱siyuniko̱y a̱makapitzí̱n hua̱ntu̱ xamaka̱n talacapa̱stacni, hua̱mpi̱ na̱ xa̱huá̱ catzi̱y la̱ntla̱ acxtum ta̱ma̱lacastuca̱ hua̱ntu̱ la̱nchú̱ cma̱siyuma̱ xasa̱sti talacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Acxni̱ Jesús ma̱katspútulh yuma̱ takalhchihuí̱n tíalh a̱lacatanu̱. ");
INSERT INTO tosNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cha̱nchu̱ antá̱ cha̱lh luhua c-xca̱chiquí̱n anta̱ni̱ xlá̱ cstacni̱t. Antá̱ chú̱ tzúculh li̱akchihui̱nán xtapaksi̱t Dios c-xpu̱kalhtahuakacan judíos hua̱ntu̱ xuí̱ antá, chu̱ la̱ntla̱ xli̱lhu̱hua̱ ti̱ xkaxmatnima̱kó̱, caj cacs xli̱lacahuanko̱y xtachihuí̱n, pus na̱má̱ xuanko̱y: —¿Ní̱ cahuá̱ catzí̱nilh xli̱pacs tlanca talacapa̱stacni̱ hua̱ntu̱ kalhi̱y yuma̱ Jesús? ¿Lá̱ntla̱ cahuá̱ li̱kalhi̱y li̱tlihuaka̱ pi̱ tla̱n tlahuako̱y lactlanca li̱ca̱cni hua̱ntu̱ kalhi̱y li̱pe̱cua xlakasi? ");
INSERT INTO tosNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pus hua̱ yumá̱ hua̱ xkahuasa José ti̱ xuacna xuani̱t, chi̱nchu̱ xtzi, huanicán María, xa̱huá̱ na̱ lakapasko̱ya̱hu xnata̱lán huaniko̱cán Santiago, José, Simón, xa̱hua̱ Judas. ");
INSERT INTO tosNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Chu̱ na̱ chuná̱ makapitzi̱n xnata̱lan lactzumaján, na̱ antá̱ u̱nú̱ huilakó̱, luhua lakapasko̱ya̱hu. Pus ¿tí̱ chi̱nchu̱ ma̱xqui̱ni̱t cahuá̱ xli̱skalala hua̱ntu̱ xlá̱ quinca̱ma̱siyuniyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Puschí̱ caj xpa̱lacata̱ pi̱ xta̱chiqui̱ncán ni̱ xli̱ca̱najlaniko̱y. Huata Jesús na̱má̱ huaniko̱lh: —Ni̱ cha̱tum xprofeta Dios la̱ntla̱ cani̱cahuá̱ anta̱ni̱ an pacs ca̱najlanicán, chu̱ li̱pa̱huancán, hua̱mpi̱ acxni̱ cha̱n c-xca̱chiquí̱n, xa̱hua̱ c-xchic, antá̱ ni̱ pala tzinú̱ ca̱najlanicán hua̱ntu̱ xlá̱ li̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pus caj xpa̱lacata yumá̱ ni̱ lhu̱hua̱ li̱tlahuako̱lh lactlanca li̱ca̱cni̱ c-xlaksti̱pa̱ncán sa̱mpi̱ xlacán ni̱ xli̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Rey Herodes hua̱nti̱ xli̱hui̱ li̱gobernador c-Galilea, acxni̱ xlá̱ lákcha̱lh tachihuí̱n la̱ntla̱ xli̱chihui̱nancán Jesús, ");
INSERT INTO tosNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","huata xlá̱ na̱má̱ huaniko̱lh hua̱nti̱ antá̱ xta̱scujma̱kó̱: “Tamá̱ hua̱nti̱ huanicán Jesús xalán pala huá̱ Juan Bautista, ma̱x lakastakuánalh ca̱li̱ní̱n, chu̱ mimpá̱ ca̱quilhtamacú̱, huachá̱ chuná̱ li̱tlahuako̱y lactlanca li̱ca̱cni tatlahu.” ");
INSERT INTO tosNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hua̱ chuná̱ xli̱huán Herodes sa̱mpi̱ huá̱ xma̱chipi̱nani̱t Juan, chu̱ tachí̱n tile̱nca̱ c-pu̱la̱chi̱n. Huá̱ chuná̱ li̱tláhualh caj xpa̱lacata Herodías hua̱nti̱ xpusca̱t xuani̱t xta̱la Felipe, ");
INSERT INTO tosNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","sa̱mpi̱ xlá̱ ni̱tlá̱n tláhualh hua̱ntu̱ maktum quilhtamacú̱ tihuánilh Juan: “Ni̱tlá̱n la̱ntla̱ li̱pímpa̱t milatámat, ni̱ mi̱li̱ta̱tahuílat miya̱stá.” ");
INSERT INTO tosNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Puschí̱ rey Herodes xmakni̱putún Juan, hua̱mpi̱ xlakpe̱cuampalay sa̱mpi̱ la̱ntla̱ xli̱lhu̱hua judíos xcatzi̱cán pi̱ Juan huá̱ profeta xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hua̱mpi̱ acxni̱ ma̱kátzi̱lh xca̱ta̱ la̱ntla̱ tachixcúhui̱lh Herodes, chu̱ xli̱pa̱xuhuama̱ca̱ xtucuhuiní, hua̱ xtzuma̱t Herodías, xlá̱ alh tantli̱y antá̱ c-xlacati̱ncan li̱pu̱tum anta̱ni̱ xua̱yama̱ko̱ca̱. Pus luhua lakáti̱lh Herodes la̱ntla̱ xlá̱ tántli̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hasta ma̱lacnú̱nilh pi̱ nama̱xqui̱y la̱ntla̱ tu̱ xlá̱ nasquiniy. ");
INSERT INTO tosNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hua̱mpi̱ cumu yama̱ tzuma̱t alh li̱xakatli̱y xtzi, xlá̱ li̱huana̱ stacyá̱hualh tu̱ nasquín, pus na̱má̱ alh huaniy Herodes: —Quit clacasquín pi̱ la̱nchuj tuncán xquima̱xqui̱ c-paktum pula̱tu̱ xakxe̱ka Juan Bautista. ");
INSERT INTO tosNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Acxni̱ chuná̱ káxmatli̱ rey Herodes hua̱ntu̱ xlacasquín tzuma̱t, xlá̱ luhua tali̱puhuá̱ni̱lh. Hua̱mpi̱ huá̱ xpa̱lacata̱ pi̱ xma̱lacnu̱nini̱t la̱ntla̱ pala tú̱ csquínilh, chu̱ pi̱ na̱ pacs xkaxmatko̱ni̱t ti̱ xta̱huilakó̱, pus lacapala̱ li̱ma̱paksí̱nalh pi̱ namaxqui̱cán, ");
INSERT INTO tosNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","chu̱ na̱ ma̱paksí̱nalh pi̱ capixca̱acti̱ca̱ xakxe̱ka Juan Bautista c-pu̱la̱chi̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A̱li̱sta̱lh chú̱ pu̱li̱minca̱ paktum pula̱tu, macama̱xqui̱ca̱ yama̱ tzuma̱t, hua̱ chu̱ xlá̱ má̱xqui̱lh xtzi. ");
INSERT INTO tosNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Cha̱nchu̱ caj li̱puntzú̱ chinko̱lh hua̱nti̱ xli̱pa̱huanko̱y Juan, le̱nko̱lh xtiyatli̱hua, chu̱ ma̱acnu̱ko̱lh. A̱li̱sta̱lh chú̱ lakanko̱lh Jesús, ma̱catzi̱ni̱ko̱lh hua̱ntu̱ xakspulani̱t Juan. ");
INSERT INTO tosNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Acxni̱ Jesús cátzi̱lh hua̱ntu̱ xakspulani̱t Juan, huata xlá̱ na̱ tatampú̱xtulh anta̱ni̱ xlama̱, cha̱lh c-ta̱kaya̱huaná, antá̱ táju̱lh c-aktum pu̱tacutnu, chu̱ tá̱alh xli̱ma̱kalhtahuáka̱t lacatum anta̱ni̱ tzili̱s ca̱huán cajá ka̱nu̱y. Hua̱mpi̱ lhu̱hua̱ xala cani̱hua̱ lactzu̱ ca̱chiquí̱n ca̱lacatzuní̱n, acxni̱ catzi̱ko̱lh anta̱ni̱ nachá̱n yama̱ pu̱tacutnu, xlacán anko̱lh putzako̱y, hua̱mpi̱ caj tuhuani̱anko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Acxni̱ chú̱ Jesús tácutli̱ c-pu̱tacutnu, úcxilhli̱ pi̱ luhua lhu̱hua̱ xkalhkalhi̱ma̱kó̱. Xlá̱ lakalhamanko̱lh, chu̱ ma̱pacsako̱lh xli̱pacs hua̱nti̱ xli̱minko̱ni̱t xta̱tatlacán. ");
INSERT INTO tosNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huatiya̱ yama̱ quilhtamacú̱, acxni̱ ko̱tánu̱lh, xli̱ma̱kalhtahuaka̱t Jesús lakminko̱lh, chu̱ na̱má̱ huaniko̱lh: —Aya ko̱tánu̱lh, chu̱ tzi̱suamajá, xa̱huachí̱ ni̱ anán cachiquí̱n u̱nú̱ lacatzú̱, Huata xatlá̱n cahuanikó̱ yuma̱ xli̱pacscán pi̱ caanko̱lhá̱ c-xchiccán, usu anta̱ni̱ huí̱ aktum ca̱chiquí̱n laqui̱mpi̱ antá̱ natama̱huako̱y xli̱huatcán. ");
INSERT INTO tosNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Huata Jesús huaniko̱lh: —Pus ni̱ luhua xlacasquinca̱ pala a̱lacatanu̱ naanko̱y, huata huixín ma̱n cama̱hui̱kó̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xlacán kalhti̱nanko̱lh: —Hua̱mpi̱, ¿lá̱ntla̱ chú̱ quin nacma̱accha̱ni̱ya̱hu nacma̱hui̱ko̱ya̱hu? Sa̱mpi̱ ni̱ lhu̱hua̱ ckalhi̱ya̱hu caxtala̱nchu̱, caj xma̱n macquitzis, xa̱hua̱ tantuy squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús huanipalako̱lh: —Pus caquili̱tanítit hua̱ntu̱ kalhi̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús li̱ma̱paksi̱ko̱lh xli̱pacs li̱lhu̱hua̱ pi̱ antá̱ catahuilako̱lh ca̱sakatna. A̱li̱sta̱lh acxni̱ maklhtí̱nalh yama̱ macquitzis caxtala̱nchu̱, xa̱hua̱ tantuy squi̱ti, xlá̱ talacayá̱hualh c-akapú̱n, pa̱xcatcatzí̱nilh Dios xpa̱lacata lí̱huat. Acxni̱ lakchakako̱lh caxtala̱nchu̱, chú̱ ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t laqui̱mpi̱ xlacán nama̱akpitziniko̱y xli̱pacs. ");
INSERT INTO tosNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pacs hua̱yanko̱lh, chu̱ tla̱n kalhkasko̱lh. Hua̱mpi̱ a̱li̱sta̱lh xlacán ma̱tzamapalako̱lh pa̱cu̱tuy pakxu̱ xatalakchakatama̱n caxtala̱nchu̱, xa̱hua̱ squi̱ti̱ hua̱ntu̱ akatá̱xtulh. ");
INSERT INTO tosNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hua̱nti̱ tihua̱yanko̱lh, xkatzi̱y ma̱x pala akquitzis mi̱lh chixcuhuí̱n, tanuj cue̱nta̱ lacchaján, chu̱ lactzu̱ camán. ");
INSERT INTO tosNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","A̱li̱sta̱lh Jesús huaniko̱lh xli̱ma̱kalhtahuáka̱t pi̱ cataju̱ko̱lh yama̱ c-pu̱tacutnu̱ laqui̱mpi̱ xlacán pu̱lh huá̱ napa̱tacutko̱ya̱chá, chu̱ hasta a̱li̱sta̱lh xlá̱ nalakcha̱nko̱y sa̱mpi̱ a̱cu xuanima̱kó̱ tachixcuhuí̱tat pi̱ caanko̱lhá̱ c-xchiccán. ");
INSERT INTO tosNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Acxni̱ chú̱ pacs ma̱quilhanu̱ko̱lh tachixcuhuí̱tat, tiaksputtahui̱ ka̱stí̱n anta̱ni̱ caj xacstu alh tlahuay xoración. Acxni̱ chú̱ luhua aya li̱huana̱ tzi̱suanko̱lh antacú̱ xlá̱ xlaya̱ xacstu. ");
INSERT INTO tosNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Chi̱nchu̱ pu̱tacutnu̱ hua̱ntu̱ xpu̱ama̱kó̱ xli̱ma̱kalhtahuáka̱t, antiyá̱ c-xita̱t ta̱kaya̱huaná̱ xan, hua̱mpi̱ caj xamaktum li̱pe̱cua̱ la̱ntla̱ tzúculh u̱nán, chu̱ yama̱ pu̱tacutnu̱ li̱pe̱cua̱ xma̱lactzuhuiji̱ma̱ la̱ntla̱ xli̱tlihuaka ta̱kaya̱huaná̱ xtanakama̱; hasta xma̱lakspitputún la̱ntla̱ csnokmín u̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Acxni̱ chú̱ luhua tzi̱sacú xuani̱t, ni̱ naj cxkakay, Jesús lakanko̱lh xli̱ma̱kalhtahuáka̱t xkalhtla̱huanti̱lhay chúchut c-ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Cha̱nchu̱ xli̱ma̱kalhtahuáka̱t acxni̱ ucxilhko̱lh pi̱ xkalhtla̱huama̱ chúchut, xlacán li̱pe̱cua̱ pe̱cuanko̱lh, tzúculh ca̱tasako̱y, na̱má̱ huanko̱y: —Tama̱ xlá̱ ma̱x caj ni̱n quinca̱ma̱lacapalajuani̱má̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Hua̱mpi̱ tuncán xakatli̱ko̱lh Jesús, huaniko̱lh: —Cama̱tlihuaklhcántit, ni̱ cape̱cuántit, sa̱mpi̱ quit Jesús hua̱nti̱ cca̱lakama̱chá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedro xakátli̱lh, chu̱ na̱má̱ quilhánilh: —Tla̱ti, hua̱ palapi̱ xli̱ca̱na̱ huix hua̱nti̱ támpa̱t, pus chú̱ na̱ caquintasanipi̱ laqui̱mpi̱ na̱ tla̱n nactla̱huán c-xkalhni chúchut hasta anta̱ni̱ huix ya̱pi. ");
INSERT INTO tosNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Cha̱nchu̱ xlá̱ huá̱: —Pus caakpúhuanti, catat. Yama̱ Pedro la̱li̱huán tácutli̱ c-pu̱tacutnu, chu̱ na̱ chuná̱ tzúculh kalhtla̱huán chúchut laqui̱mpi̱ namín ta̱la̱pa̱xtoka̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hua̱mpi̱ acxni̱ xlá̱ makcátzi̱lh pi̱ luhua tlihuaka xmima̱ u̱n, fuerza̱ pé̱cualh, tzúculh laktzanka̱y c-chúchut, na̱má̱ quilhánilh: —¡Tla̱ti Jesús, catlahua̱ li̱tlá̱n caquimakta̱ya! ");
INSERT INTO tosNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Acxnitiyá̱ chú̱ Jesús macachípalh, na̱má̱ huánilh: —Pedro, ¿tú̱huan huix ni̱ lay quili̱pa̱huana? ¿Lá̱ntla̱ chú̱ quimacpuhuani̱ pi̱ ni̱ cactimakta̱yán? ");
INSERT INTO tosNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Acxni̱ chú̱ xlacán taju̱ko̱lh c-pu̱tacutnu, yama̱ u̱n tuncán tácacsli. ");
INSERT INTO tosNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Chi̱nchu̱ a̱makapitzi̱n xli̱ma̱kalhtahuáka̱t hua̱nti̱ antá̱ xtaju̱ma̱kó̱ c-pu̱tacutnu, lacapala̱ lakatatzokostako̱lh, na̱má̱ huaniko̱lh: —¡Luhua xli̱ca̱na̱ chú̱ ccatziya̱hu pi̱ huix xCam Dios! ");
INSERT INTO tosNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Acxnitiyá̱ chú̱ lacapala̱ tzúculh pa̱tacutko̱y c-ta̱kaya̱huaná, chu̱ antá̱ cha̱nko̱lh c-xatiyat huanicán Genesaret. ");
INSERT INTO tosNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Acxni̱ hua̱nti̱ antá̱ xalaní̱n lakapasko̱lh pi̱ hua̱ Jesús hua̱nti̱ xchini̱t, xlacán tuncán li̱chihui̱nanko̱lh c-xli̱ca̱tlanca̱ anta̱ni̱ xuilakó̱ c-xtiyatcán. Tuncán tzúculh li̱minko̱y xta̱tatlaní̱n laqui̱mpi̱ nama̱pacsako̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Makapitzí̱n squiniko̱lh li̱tlá̱n pi̱ cama̱xqui̱ko̱lh talacasquín ca̱na̱ caj xtampaksta̱n xlháka̱t naxamaniko̱y yama̱ ta̱tatlaní̱n, chu̱ xli̱pacs hua̱nti̱ xamaniko̱lh xlhaka̱t Jesús pacs tatla̱ni̱ko̱lh ma̱squi caxatu̱cahua̱ tajátat xkalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maktum laktalacatzuhui̱ko̱lh Jesús makapitzi̱n fariseos, chu̱ laktzokqui̱naní̱n, xminko̱ni̱tanchá̱ c-Jerusalén; na̱má̱ kalhasquinko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tú̱huan tama̱ mili̱ma̱kalhtahuáka̱t caj luhua kalhakaxmatmakanko̱y hua̱ntu̱ li̱lama̱hu xtahuilatcan xalakmaka̱n quinatla̱tnacán? Sa̱mpi̱ xlacán ni̱ aksti̱tum ca̱cni̱naniko̱y Dios cumu ni̱ tlahuako̱y hua̱ntu̱ cli̱smani̱ni̱tahu ctlahuaya̱hu pi̱ luhua li̱huana̱ nali̱makachakana̱hu chúchut acxni̱ ni̱ a̱hua̱yana̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hua̱mpi̱ Jesús na̱ chuná̱ kalhasquinko̱lh aktum tachihuí̱n: —Chi̱nchu̱ huixín, ¿tú̱huan chá̱ kalhakaxmatmakaná̱tit hua̱ntu̱ Dios ca̱li̱ma̱paksi̱ni̱tán nama̱kantaxti̱yá̱tit, chu̱ huata caj xma̱n huá̱ tlahuayá̱tit hua̱ntu̱ caj miacstucán kalhi̱yá̱tit mintasmani̱ncán? ");
INSERT INTO tosNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sa̱mpi̱ hasta la̱ntla̱ xamaka̱n quilhtamacú̱ Dios na̱má̱ tihua̱: ‘Capa̱xqui, chu̱ calakalhámanti̱ mintla̱t, chu̱ mintzí, hua̱mpi̱ hua̱nti̱ nata̱la̱lacata̱qui̱y xtla̱t, usu xtzi la̱ntla̱ cala̱huá̱ nahuaniy, tama̱ chixcú̱ luhua mini̱niy pi̱ maktum cani̱lh.’ ");
INSERT INTO tosNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Hua̱mpi̱ chi̱nchu̱ huixín kalhtum ma̱luloká̱tit pi̱ ni̱ tlahuay tala̱kalhí̱n acxni̱ huaná̱tit pi̱ cha̱tum chixcú̱ tla̱n nahuaniy xtla̱t, usu xtzi: ‘La̱nchú̱ ni̱ lay cmakta̱yayá̱n ma̱squi xacmakta̱yaputún sa̱mpi̱ xli̱pacs hua̱ntu̱ ckalhi̱y actzú̱ tu̱ xacma̱xquí̱n, pacs huatiya̱ chú̱ cma̱lacnu̱nini̱t Dios pi̱ nacma̱xqui̱y c-xtemplo̱.’ ");
INSERT INTO tosNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","¿Lá̱ntla̱ pi̱ ni̱ catzi̱yá̱tit pi̱ xli̱pacs hua̱nti̱ na̱má̱ huanko̱y luhua lacatancs huamputunko̱y pi̱ tla̱n nia̱lh ucxni̱ catimakta̱yako̱lh xtla̱tcán, xa̱hua̱ xtzicán? Acxni̱ huixín tlahuayá̱tit tu̱ puhuaná̱tit tlak kalhi̱y xlakasi̱ mintahuilatcán, chuná̱ ma̱siyuyá̱tit pi̱ lakmakampá̱tit tu̱ ca̱li̱ma̱paksi̱yá̱n Dios pi̱ pu̱lh calakalhamankó̱tit minatla̱tnacán. ");
INSERT INTO tosNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Xli̱ca̱na̱ pi̱ huixín luhua xaaksani̱naní̱n! Luhua lacatancs ma̱lulokni̱t profeta Isaías acxni̱ na̱má̱ titzóknu̱lh c-xaSa̱ntujlani Li̱kalhtahuaka̱ caj mimpa̱lacatacán: ");
INSERT INTO tosNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Hua̱ yuma̱ tachixcuhuí̱tat, caj luhua xma̱n xquilhnicán li̱chihui̱nanko̱y acxni̱ huanko̱y pi̱ mat quili̱pa̱huanko̱y, chu̱ quima̱xquiko̱y ca̱cni, hua̱mpi̱ huata antá̱ c-xnacu̱cán luhua tanuj talacapa̱stacni̱ huili̱ko̱ni̱t, pus chuná̱ chú̱ quili̱ma̱lakamakatli̱niy. ");
INSERT INTO tosNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Luhua xli̱ca̱na̱ pi̱ ni̱tú̱ xtápalh ma̱squi quili̱ma̱xqui̱ko̱y ca̱cni, sa̱mpi̱ xli̱pacs hua̱ntu̱ xlacán li̱ma̱paksi̱nanko̱y catlahuako̱lh tachixcuhuí̱tat, pacs caj xtahuilatcan chixcuhuí̱n, chu̱ ni̱ huá̱ hua̱ntu̱ quit cca̱li̱ma̱paksi̱ko̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A̱li̱sta̱lh chú̱ Jesús pacs tasaniko̱lh ti̱ antá̱ xya̱kó̱, chu̱ na̱má̱ huaniko̱lh: —Cakaxpáttit yuma̱ quintachihuí̱n, chu̱ li̱huana̱ caakatá̱kstit: ");
INSERT INTO tosNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ni̱ huá̱ hua̱ntu̱ quilhtanu̱y, chu̱ kotuay cha̱tum ma̱tlahui̱y tala̱kalhí̱n, chu̱ ma̱xcajua̱li̱y xli̱stacna hua̱mpi̱ huata hua̱ntu̱ taxtuya̱chi̱ c-xquilhni̱ acxni̱ chihui̱nán, pus hua̱ xlá̱ ma̱xcajua̱li̱y xli̱stacna, chu̱ ni̱ lakati̱y Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","A̱li̱sta̱lh yama̱ xli̱ma̱kalhtahuáka̱t laktalacatzuhui̱ko̱lh, chu̱ na̱má̱ huaniko̱lh: —Yama̱ fariseos ni̱tlá̱n tlahuako̱lh acxni̱ kaxmatko̱lh mintachihuí̱n, huata caj li̱akasi̱tzi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Huata xlá̱ na̱má̱ kalhti̱ko̱lh: —Xli̱pacs tachaná̱n hua̱ntu̱ ni̱ huá̱ chani̱t Quintla̱t ti̱ huilachá̱ c-akapú̱n, luhua xli̱ca̱na̱ pi̱ napulhumakancán pu̱tum xtankáxe̱k. ");
INSERT INTO tosNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ni̱tú̱ cahuanikó̱tit, calatama̱ko̱ka̱lh, sa̱mpi̱ xlacán caj xta̱chuná̱ li̱taxtuy la̱ntla̱ lakatzí̱n hua̱nti̱ pakachipale̱ma̱kó̱ a̱makapitzi̱n xta̱lakatzi̱ncán. Pero lapi̱ cha̱tum lakatzí̱n pakachipale̱mputún hua̱nti̱ na̱ lakatzí̱n, luhua lacatancs cca̱huaniyá̱n pi̱ ni̱ pala mákat catitla̱huanko̱lh, chu̱ xlacxtumcán xcha̱tuycán natamakuasko̱y anta̱ni̱ luhua ca̱pu̱lhmá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro na̱má̱ huánilh Jesús: —Xtlahua̱ li̱tlá̱n, xquinca̱ma̱lacatancsani̱ hua̱ntu̱ huaniputún tamá̱ takalhchihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Cha̱nchu̱ Jesús, huá̱: —¿Lá̱ntla̱ pi̱ na̱ ni̱ pala huixinín akata̱kspá̱tit hua̱ntu̱ cca̱huaniputuná̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Lá̱ntla̱ pi̱ ni̱ catzi̱yá̱tit pi̱ xli̱pacs yama̱ lí̱huat hua̱ntu̱ quilhtanu̱y c-xquilhni̱ cha̱tum antá̱ ti̱tum an c-xpoko, chu̱ a̱li̱sta̱lh chú̱ c-xcajuá̱lat makampalay, chu̱ ni̱ huá̱ ma̱tlahui̱y tala̱kalhí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Hua̱mpi̱ hua̱ntu̱ taxtuya̱chi̱ c-xquilhni, antá̱ ti̱tum mina̱chá̱ c-xnacú̱; xli̱ca̱na̱ chú̱ xlá̱ pi̱ huá̱ ma̱tlahui̱y tala̱kalhí̱n, chu̱ ma̱xcajua̱li̱y xlatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sa̱mpi̱ antá̱ c-xnacu̱ cha̱tum chixcú̱ mina̱chá̱ xalacli̱xcajnit talacapa̱stacni; antá̱ mina̱chá̱ xtalacapa̱stacni̱ la̱ntla̱ namakni̱y xta̱chixcú, antá̱ puhuán la̱ntla̱ naxakatli̱y tanuj pusca̱t, usu chixcú, usu la̱ntla̱ nalakamaklhti̱y xpusca̱t xta̱chixcú, na̱ chuná̱ pala takalhá̱n, taquiclhcatza, xa̱huá̱ la̱ntla̱ nama̱xtuy ta̱ksaní̱n a̱cha̱tum, chu̱ catu̱huá̱ xcajua̱chihuí̱nat. ");
INSERT INTO tosNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Xli̱ca̱na̱ pi̱ hua̱ yuma̱ li̱xcájnit tlahuaniy xli̱stacna cha̱tum chixcú, chu̱ ni̱ lakati̱y Dios chuná̱ nalatama̱y. Hua̱mpi̱ pala caj nahua̱yana, chu̱ ni̱ chuná̱ nama̱kantaxti̱ya̱ hua̱ntu̱ huí̱ tasmaní̱n pi̱ li̱huana̱ nali̱makachakancana̱ chúchut, pus tamá̱ ni̱ huá̱ ma̱xcajua̱li̱y xlatama̱t cha̱tum, pala napuhuana̱ chú̱ pi̱ Dios ni̱ lakati̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Acxni̱ chú̱ Jesús taxtupá̱, luhua mákat alh hasta c-xatiyat Tiro, chu̱ Sidón. ");
INSERT INTO tosNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Antá̱ xuí̱ cha̱tum pusca̱t xala mákat hua̱nti̱ ni̱ israelita xuani̱t. Xlá̱ takosú̱n lákmilh Jesús, chu̱ na̱má̱ xquilhanima̱: —¡Quimpu̱chinacán, huix tali̱pa̱hu xCam David, luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n caquilakalhámanti! Sa̱mpi̱ koxutá̱ quintzuma̱t ma̱xcajua̱li̱nini̱t xtalacapa̱stacni cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Hua̱mpi̱ Jesús ni̱tú̱ li̱kálhti̱lh; pero huata hua̱ xli̱ma̱kalhtahuáka̱t lacapala̱ laktalacatzuhui̱ko̱lh, na̱má̱ huaniko̱lh: —Catlahua̱ li̱tlá̱n, cahuani̱ tama̱ pusca̱t pi̱ caalhá sa̱mpi̱ luhua li̱pe̱cua̱ quinca̱akaxculiti̱lhayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús tachókolh, na̱má̱ huánilh yama̱ pusca̱t: —Dios huá̱ quili̱macamini̱t laqui̱mpi̱ xma̱n huá̱ nacmakta̱yako̱y hua̱nti̱ israelitas sa̱mpi̱ xlacán xta̱chuná̱ li̱taxtuko̱y la̱ntla̱ xaaktzanká̱n xlakskatá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Puschí̱ yama̱ pusca̱t laktalacatzúhui̱lh, lakatatzokóstalh c-xlacatí̱n, chu̱ na̱má̱ huánilh: —¡Quimpu̱chinacán, catlahua̱ li̱tlá̱n caquimakta̱ya! ");
INSERT INTO tosNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Cha̱nchu̱ xlá̱ kalhtí̱nalh, huá̱: —Ma̱x chuná, hua̱mpi̱ ni̱tlá̱n qui̱taxtuy lapi̱ nacmaklhti̱ko̱ya̱hu xli̱huatcan lactzu̱ camán laqui̱mpi̱ nacli̱ma̱hui̱ko̱ya̱hu lactzu̱ chichi̱xni. ");
INSERT INTO tosNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Hua̱mpi̱ yama̱ pusca̱t akáta̱ksli̱ hua̱ntu̱ xuaniputún, chu̱ na̱má̱ kálhti̱lh: —Quimpu̱chiná, xli̱ca̱na̱ xlá̱ la̱ntla̱ huana, hua̱mpi̱ hasta lactzu̱ chichi̱xni̱ tla̱n sacuaqui̱ko̱y lactzu̱ xatalakchakatamá̱n caxtala̱nchu̱ hua̱ntu̱ tamakaxtaktahuilay, chu̱ tamakuasa̱ c-xmesa̱cán hua̱nti̱ xpu̱chiná. ");
INSERT INTO tosNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús chuná̱ huánilh: —Pusca̱t, xli̱ca̱na̱ pi̱ huix luhua quili̱pa̱huana̱ xli̱pacs minacú̱, pus huata chuná̱ cakantáxtulh la̱ntla̱ huix puhuana. Pus acxnitiyá̱ yuma̱ tlanca̱liya̱ hua̱ tzuma̱t hua̱nti̱ xta̱tatlay, tuncán tatlá̱ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Acxni̱ chú̱ titapá̱nu̱lh Jesús yama̱ lacatum, antá̱ tícha̱lh c-xquilhtu̱n ta̱kaya̱huaná̱ hua̱ntu̱ huí̱ c-xatiyat Galilea. A̱li̱sta̱lh chú̱ talacaacxtutahui̱ c-aktum ka̱stí̱n, chu̱ antá̱ culucs tahuilachá. ");
INSERT INTO tosNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Pus tilakchinko̱lh lhu̱hua̱ tachixcuhuí̱tat, hua̱nti̱ na̱ xta̱minko̱y lhu̱hua̱ xta̱tatlaní̱n; huí̱ ti̱ xle̱n lu̱ntu, lakatzí̱n, ko̱ko̱, huí̱ ti̱ macastulu xuani̱t. Antá̱ chú̱ tihuili̱ko̱ca̱ c-xlacati̱n Jesús, na̱ tima̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Luhua chí̱ lanaj xli̱lacahuanko̱y li̱lhu̱hua̱ acxni̱ xucxilhko̱y ko̱ko̱ní̱n xchihui̱nanko̱y, chu̱ la̱ntla̱ xpacsko̱y pakastuluní̱n, chu̱ lu̱ntu̱ní̱n xtla̱huanko̱y, chu̱ la̱ntla̱ xlacahua̱nanko̱y lakatzi̱ní̱n. Pus acxni̱ yuma̱ quilhtamacú̱ lhu̱hua̱ tzúculh pa̱xcatcatzi̱niko̱y tlanca tali̱pa̱hu Dios makapitzi̱n israelitas hua̱nti̱ xli̱pa̱huanko̱y caj xpa̱lacata̱ hua̱ntu̱ xlá̱ xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Cha̱nchu̱ tasaniko̱lh Jesús xli̱ma̱kalhtahuáka̱t, huaniko̱lh: —Luhua kayaj ccatzaniko̱y tachixcuhuí̱tat, pi̱ aya le̱ma̱ xli̱aktutu quilhtamacú̱ la̱ntla̱ minko̱ni̱t u̱nú, chu̱ ni̱ pala tú̱ kalhi̱ko̱y hua̱ntu̱ nali̱hua̱yanko̱y, pus ni̱ clacasquín caj pa̱lakchunatá̱ naanko̱y c-xchiccán, pala chú̱ nalakahuitita̱yako̱y c-tiji̱ caj xpa̱lacata aya tzincsni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Hua̱mpi̱ hua̱ xli̱ma̱kalhtahuáka̱t na̱má̱ kalhti̱ko̱lh: —Hua̱mpi̱ quin, ¿ní̱ nactiyako̱ya̱hu lhu̱hua caxtala̱nchu̱ hua̱ntu̱ nacli̱ma̱hui̱ko̱ya̱hu yuma̱ tachixcuhuí̱tat, sa̱mpi̱ xli̱ca̱na̱ luhua clhu̱huacán, xa̱huachí̱ u̱nú̱ lacatzú̱ ni̱ní̱ sta̱cán? ");
INSERT INTO tosNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús kalhasquinkolh: —Hua̱mpi̱ huixín, ¿ní̱ macli̱t caxtala̱nchu̱ kalhi̱yá̱tit? Kalhti̱nanko̱lh xlacán: —Quin ckalhi̱ya̱hu mactujun caxtala̱nchu̱, chu̱ tzinú̱ squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Puschí̱ li̱ma̱paksi̱ko̱lh tachixcuhuí̱tat pi̱ catahuilako̱lh ca̱sakatna. ");
INSERT INTO tosNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A̱li̱sta̱lh tíyalh yama̱ mactujun caxtala̱nchu̱, xa̱hua̱ yama̱ squi̱ti, xlá̱ pa̱xcatcatzí̱nilh Dios lí̱huat, a̱li̱sta̱lh chú̱ macama̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, hua̱ xlacán ma̱akpitziniko̱lh tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xpu̱tumcán pacs hua̱yanko̱lh, chu̱ tla̱n kalhkasko̱lh. A̱li̱sta̱lh chú̱ na̱ pa̱tujún pakxu̱ tima̱tzamako̱lh hua̱ntu̱ tisacqui̱ko̱lh, xakata̱xtuni̱t a̱pakatzuni̱n caxtala̱nchu̱. ");
INSERT INTO tosNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma̱x pala akta̱ti mi̱lh chixcuhuí̱n hua̱nti̱ hua̱yanko̱lh, tanuj cue̱nta̱ lacchaján, xa̱hua̱ lactzu̱ camán ");
INSERT INTO tosNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A̱li̱sta̱lh Jesús huaniko̱lh tachixcuhuí̱tat pi̱ caanko̱lhá c-xchiccán, cha̱nchu̱ xlá̱ taju̱pá̱ c-pu̱tacutnu, antá̱ alh c-aktum tíyat tu̱ xuanicán Magdala. ");
INSERT INTO tosNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Makapitzi̱n fariseos, xa̱hua̱ laktzokqui̱naní̱n anko̱lh anta̱ni̱ xlama̱chá̱ Jesús laqui̱mpi̱ nakalhputzako̱y pala tú̱ nali̱ma̱makuasi̱ko̱y. Xlacán squiniko̱lh pi̱ catláhualh aktum tlanca li̱ca̱cni tatlahu tu̱ ma̱n natasiyuy laqui̱mpi̱ xlacán nali̱ucxilhko̱y, chu̱ naca̱najlako̱y pi̱ xli̱ca̱na̱ hua̱ Dios xmacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero hua̱ xlá̱ na̱má̱ kalhti̱ko̱lh: “Acxni̱ ko̱tanu̱majá, aya tzanka̱ma̱ chichiní, chu̱ ucxilhá̱tit pi̱ luhua ca̱huán tasiyuy c-akapú̱n huixín huaná̱tit: ‘Chú̱ cha̱lí̱ luhua tla̱n huij nahuán quilhtamacú̱, sa̱mpi̱ luhua tla̱n a̱hua̱nán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chi̱nchu̱ lapi̱ lacatzi̱sa̱ luhua chichi min u̱n, chu̱ luhua tapoklhni̱tanchá̱ xli̱pulhni, huaná̱tit: ‘Chú̱ ma̱x ni̱ luhua tla̱n catichichínalh yuma̱ quilhtamacú̱ sa̱mpi̱ luhua caj li̱puhuán tasiyuy c-akapú̱n.’ ¡Xli̱ca̱na̱ pi̱ luhua mákat aktzanka̱yá̱tit! ¿Lá̱ntla̱ chú̱ tla̱n li̱ma̱lakchipiniyá̱tit, chu̱ akata̱ksá̱tit hua̱ntu̱ tasiyuy c-akapú̱n, hua̱mpi̱ ni̱ lay akata̱ksá̱tit hua̱ntu̱ ca̱la̱nchú̱ ca̱li̱ma̱lacahua̱ni̱má̱n Dios yuma̱ quilhtamacú̱? ");
INSERT INTO tosNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","¡Koxutaní̱n huixín tachixcuhuí̱tat hua̱nti̱ lapá̱tit la̱nchuj quilhtamacú̱, sa̱mpi̱ xli̱ca̱na̱ pi̱ luhua li̱xcájnit mintapuhua̱ncán la̱ntla̱ ni̱ li̱pa̱huamputuná̱tit Dios! Huixín ankalhí̱n quisquinipá̱tit pi̱ cacca̱li̱ma̱lacahua̱ní̱n aktum tlanca li̱ca̱cni tatlahu, hua̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ ni̱tú̱ cactica̱li̱ma̱lacahua̱ní̱n hua̱ntu̱ luhua ucxilhputuná̱tit, huata xatlá̱n huá̱ nacca̱li̱ma̱lacahua̱ni̱yá̱n aktum tatlahu xta̱chuná̱ la̱ntla̱ tu̱ Dios titláhualh c-xlatama̱t profeta Jonás.” Acxni̱ chuná̱ huaniko̱lh xlá̱ akxtakya̱huako̱lh, aya tíalh. ");
INSERT INTO tosNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Maktum acxni̱ xli̱ma̱kalhtahuáka̱t Jesús pa̱tacutko̱chá̱ a̱li̱quilhtu̱an chúchut, xlacán pa̱tzanka̱ko̱lh nale̱nko̱y caxtala̱nchu̱ hua̱ntu̱ nahuako̱ya̱chá̱ acxni̱ nahua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na̱ acxnitiyá̱ chú̱ Jesús na̱má̱ huaniko̱lh: —Quit ccahuaniyá̱n pi̱ huixín luhua cui̱ntaj catlahuátit xpa̱lacata ni̱tú̱ naca̱ma̱pasi̱yá̱n xali̱ma̱xcuti̱n xlevadurajcan fariseos, chu̱ laktzokqui̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yama̱ li̱ma̱kalhtahuáka̱t na̱má̱ tzúculh la̱huaniko̱y xacstucán: —Ma̱x huá̱ quinca̱li̱huanimá̱n sa̱mpi̱ ni̱ li̱mina̱hu caxtala̱nchu̱. ");
INSERT INTO tosNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús tuncán cátzi̱lh hua̱ntu̱ xquilhuama̱kó̱, huachá̱ na̱má̱ li̱huaniko̱lh: —¿Tú̱ xpa̱lacata chuná̱ na̱má̱ li̱lakaputzayá̱tit caj xma̱n huá̱ pi̱ ca̱tzanka̱niyá̱n caxtala̱nchu̱ tu̱ nahuayá̱tit? ¡Xli̱ca̱na̱ pi̱ ni̱ lay quili̱pa̱huaná̱tit, usu ca̱najlayá̱tit hua̱ntu̱ quit tla̱n ctlahuay! ");
INSERT INTO tosNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tú̱huan chunacú̱ ni̱ akata̱ksá̱tit chú̱ pi̱ nia̱lh lacapa̱stacá̱tit acxni̱ ctilakchákalh yama̱ macquitzis caxtala̱nchu̱ tu̱ tili̱áccha̱lh nahua̱yanko̱y ma̱x akquitzis mi̱lh chixcuhuí̱n? ¿Ní̱ pa̱li̱t pakxu̱ tisacquí̱tit tu̱ akatá̱xtulh hua̱ntu̱ ni̱ huako̱lh? ");
INSERT INTO tosNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Pi̱ na̱ nia̱lh lacapa̱stacá̱tit xpa̱lacata yama̱ macquitzis caxtala̱nchu̱ tu̱ tili̱áccha̱lh acxni̱ ctima̱hui̱ko̱lh yama̱ akta̱ti mi̱lh chixcuhuí̱n, chu̱ ní̱ pa̱li̱t pakxu̱ tisacquí̱tit? ");
INSERT INTO tosNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Tú̱huan chi̱nchu̱ ni̱ akata̱ksá̱tit pi̱ ni̱ huá̱ xpa̱lacata pala pa̱tzanká̱tit nali̱taná̱tit mincaxtala̱nchujcán cca̱li̱xakatlí̱n acxni̱ cca̱huanín pi̱ cui̱ntaj naca̱tlahuacaná̱tit xpa̱lacata xali̱ma̱xcuti̱n xlevadurajcan fariseos, chu̱ laktzokqui̱naní̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Puschí̱ acxnicú̱ akata̱ksko̱lh pi̱ Jesús ni̱ huá̱ xli̱chihui̱nama̱ yama̱ li̱ma̱xcuti̱n levadura hua̱ntu̱ ta̱tlahuacán caxtala̱nchu̱; huata huá̱ xlá̱ xli̱chihui̱nama̱ xpa̱lacata xtama̱siyuncan fariseos, chu̱ saduseos sa̱mpi̱ yama̱ xlacán ni̱ luhua aksti̱tum xle̱ma̱kó̱ xtalacapa̱stacnicán. ");
INSERT INTO tosNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Acxni̱ chú̱ Jesús ta̱cha̱nko̱lh xli̱ma̱kalhtahuáka̱t c-xatiyat hua̱ntu̱ huanicán Cesarea de Filipo xlá̱ na̱má̱ kalhasquinko̱lh: —Acxni̱ tachixcuhuí̱tat quili̱chihui̱nanko̱y, ¿xatí̱ ya̱ chixcú̱ quit quili̱ma̱xtuko̱y? ");
INSERT INTO tosNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Cha̱nchu̱ xlacán huanko̱lh: —Makapitzí̱n huanko̱y pi̱ mat huix Juan Bautista, huí̱ ti̱ huampalay pi̱ mat huix profeta Elías xuani̱t, usuchí̱ mat huix yama̱ profeta Jeremías xuani̱t, usu a̱cha̱tum tali̱pa̱hu xprofeta Dios hua̱nti̱ qui̱latama̱ni̱tanchi̱ maka̱sa quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Huata xlá̱ na̱má̱ kalhasquimpalako̱lh: —¿Chi̱nchu̱ huixín? ¿Tí̱ luhua puhuaná̱tit quit? ¿Tí̱ quili̱quilhpiná̱tit? ");
INSERT INTO tosNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro tuncán kálhti̱lh: —¡Huix Cristo xCam Dios hua̱nti̱ xli̱ca̱na̱ lama̱ xastacná! ");
INSERT INTO tosNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Cha̱nchu̱ kalhtí̱nalh Jesús, huánilh: —Luhua ca̱na̱ li̱pa̱xuhu calatapa̱ huix Simón xcam Jonás; sa̱mpi̱ ni̱ pala caj cha̱tum chixcú̱ ma̱catzi̱ni̱ni̱tán hua̱ntu̱ huix aya catzi̱ya, hua̱mpi̱ hua̱ Dios Quintla̱t ti̱ huilachá̱ c-akapú̱n ma̱catzi̱ni̱ni̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hua̱mpi̱ na̱ lacatancs cuaniyá̱n pi̱ xta̱chuná̱ la̱ntla̱ huix li̱ma̱pa̱cuhui̱cana̱ Pedro hua̱ntu̱ huaniputún tlanca chíhuix, na̱ chuná̱ c-xokspun aktum tlanca sipi̱ tu̱ ni̱tí̱ lay ma̱lacxija nacma̱quilhtzuqui̱y yama̱ kampu̱tum tachixcuhuí̱tat hua̱nti̱ luhua xli̱ca̱na̱ naquili̱pa̱huanko̱y, chu̱ hua̱ntu̱ quit cma̱quilhtzuqui̱y ni̱ pala huá̱ xli̱tlihuaka ca̱li̱ní̱n catilactláhualh. ");
INSERT INTO tosNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xa̱huachí̱ quit nacma̱xqui̱yá̱n yama̱ xallave tu̱ nali̱ma̱lacqui̱ya̱ c-xasa̱sti xtapaksi̱t Dios hua̱ntu̱ cma̱quilhtzuqui̱ma̱. Quit lacatancs cuaniyá̱n pi̱ hua̱ntu̱ huix nachi̱ya, usu ni̱tlá̱n natlahuaya̱ u̱nú̱ ca̱tiyatna, na̱ chuná̱ xatachí̱n, natahuilaya̱chá̱ c-akapú̱n, chu̱ na̱ chuná̱ hua̱ntu̱ huix naxcuta, usu tla̱n natlahuaya̱ u̱nú̱ ca̱tiyatna, na̱ xataxcutni nahuán c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A̱li̱sta̱lh la̱ntla̱ ta̱chihui̱nanko̱lh Pedro, li̱ma̱paksi̱ko̱lh xli̱ma̱kalhtahuáka̱t pi̱ ni̱ cali̱chihui̱nanko̱lh pi̱ xli̱ca̱na̱ huá̱ Cristo ti̱ namín lakma̱xtuko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Hasta acxnitiyá̱ yuma̱ quilhtamacú̱ Jesús tzúculh ma̱lacatancsaniko̱y xli̱ma̱kalhtahuáka̱t hua̱ntu̱ naakspulay, xlá̱ huaniko̱lh pi̱ fuerza̱ xli̱ánat xuani̱t c-xaca̱chiqui̱n Jerusalén anta̱ni̱ xanapuxcún pa̱lijni, xa̱hua̱ laktzokqui̱naní̱n, xlacán nama̱pa̱ti̱ni̱ko̱y. Xlá̱ luhua lacatancs huaniko̱lh pi̱ namakni̱cán hua̱mpi̱ na̱ huaniko̱lh pi̱ caj xli̱aktutu quilhtamacú̱ nalakastakuanampalay ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Huata Pedro lacatanu̱ ta̱tatampú̱xtulh tzúculh stacya̱huay, na̱má̱ huánilh: —Quimpu̱chiná, ¡ni̱ calacásquilh Dios hua̱ lapi̱ chuná̱ huix naakspulayá̱n hua̱ntu̱ quilhuámpa̱t! Sa̱mpi̱ ni̱tlá̱n catiqui̱táxtulh pala tú̱ nalaniya. ");
INSERT INTO tosNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hua̱mpi̱ huata Jesu̱s talakáspitli, chu̱ na̱má̱ huánilh Pedro: —¡Luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n catatampu̱xtu̱ anta̱ni̱ quit cyá̱, sa̱mpi̱ huix xta̱chuná̱ akskahuiní, chu̱ caj quisoka̱li̱ya! Xli̱ca̱na̱ pi̱ huix ni̱ chuná̱ kalhi̱ya̱ mintalacapa̱stacni̱ la̱ntla̱ lacuan xtapuhua̱n Dios, huata huix chuná̱ lacapa̱stacnana̱ la̱ntla̱ xtapuhua̱ncan cati̱hua̱ chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","A̱li̱sta̱lh xlá̱ pu̱tum huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Lapi̱ huí̱ cha̱tum ti̱ luhua xli̱ca̱na̱ quista̱laniputún, chu̱ la̱ntla̱ xaxli̱ca̱na̱ quili̱ma̱kalhtahuáka̱t nahuán, pus huata luhua xlacasquinca̱ capa̱tzánka̱lh hua̱ntu̱ caj xacstu lakati̱y li̱pa̱xuhuay, xatlá̱n cacúcalh xcruz laqui̱mpi̱ napa̱ti̱nán caj quimpa̱lacata, chu̱ caquista̱lánilh cani̱huá̱. ");
INSERT INTO tosNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa̱mpi̱ hua̱nti̱ lakma̱xtuputún xlatáma̱t u̱nú̱ ca̱tiyatna, huata namakatzanka̱y, hua̱mpi̱ hua̱nti̱ namakatzanka̱y xlatáma̱t caj quimpa̱lacata, huata xlá̱ luhua lacatancs cacátzi̱lh pi̱ namakamaklhti̱nampalay c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Sa̱mpi̱ ¿tú̱ xtápalh qui̱taxtuniy cha̱tum, lapi̱ tla̱n xkálhi̱lh pacs la̱ntla̱ tu̱ anán ca̱tiyatna, chu̱ lapi̱ antá̱ c-xlacati̱n Dios nama̱laktzanka̱y xlatáma̱t? Usu ¿tú̱ tla̱n xli̱xokóxtulh xlatáma̱t cha̱tum laqui̱mpi̱ ni̱ napa̱ti̱nán? ");
INSERT INTO tosNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sa̱mpi̱ xli̱ca̱na̱ pi̱ nachá̱n quilhtamacú̱ acxni̱ quit Xatalacsacni Chixcú̱ nacmimpalay, chu̱ nacli̱mín xli̱pacs xli̱tlanca xli̱tlihuaka̱ hua̱ntu̱ kalhi̱y Dios Quintla̱t, chu̱ na̱ pacs nacta̱minko̱y xángeles laqui̱mpi̱ quit nacma̱xoko̱ni̱y xcuentajcan xli̱pacs tachixcuhuí̱tat, cha̱tunu cha̱tunu̱ nacma̱kalhapali̱ko̱y, chu̱ nacma̱xoko̱ni̱ko̱y hua̱ la̱ntla̱ mini̱niy tu̱ tlahuako̱ni̱t ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Quit lacatancs cca̱huaniyá̱n pi̱ makapitzí̱n hua̱nti̱ u̱nú̱ huilakó̱ hasta ni̱ a̱ni̱ko̱y nahuán acxni̱ nalakchá̱n quilhtamacú̱ xlacán naquiucxilhko̱y pi̱ nacmín xta̱chuná̱ la̱ntla̱ cha̱tum tlanca rey hua̱nti̱ luhua xli̱ca̱na̱ puxcu. ");
INSERT INTO tosNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A̱li̱akcha̱xan quilhtamacú̱, Jesús ta̱taca̱xko̱lh Pedro, chu̱ Jacobo, chu̱ xta̱la Juan, chu̱ antá̱ ta̱ksputtahuilako̱lh lacatum c-aktum ka̱stí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Acxni̱ chú̱ aya xcha̱nko̱ni̱t c-xokspun ka̱stí̱n caj xacstucán xlaya̱kó̱, antá̱ chú̱ c-xlacati̱ncán yama̱ kalhatutu xli̱ma̱kalhtahuáka̱t Jesús luhua caj tanuj tasíyulh, talakpali̱ko̱lh la̱ntla̱ xtasiyuy ankalhí̱n. La̱ntla̱ c-xlacán luhua li̱pe̱cua̱ xma̱lakachixi̱nán xta̱chuná̱ la̱ntla̱ chichiní, cha̱nchu̱ hua̱ xlháka̱t hua̱ntu̱ xlhaka̱ni̱t Jesús, luhua tlayajua̱ xtasiyuy xta̱chuná̱ la̱ntla̱ xkakánat. ");
INSERT INTO tosNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na̱ acxnitiyá̱ chú̱ caj xalán tasiyuniko̱lh Moisés xuani̱t, xa̱hua̱ profeta Elías hua̱nti̱ maka̱n xlatama̱ko̱ni̱t; xlacán xta̱chihui̱nama̱kó̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Cha̱nchu̱ chihuí̱nalh Pedro, huánilh Jesús: —Quimpu̱chinacán, huata ma̱x xali̱huaca̱ tla̱n antiyá̱ u̱nú̱ luhua ankalhí̱n xactahuilahu. Lapi̱ huix chuná̱ lacasquina u̱ctlahuaya̱hu aktutu lactzu̱ pu̱ni̱lhcha̱ chiqui, aktum milá, aktum xla Moisés, chu̱ aktum xla Elías. ");
INSERT INTO tosNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chunacú̱ xchihui̱nama̱ Pedro caj xamaktum tatu̱tzúhui̱lh aktum xasnapapa puclhni, hua̱ chú̱ pu̱tum ma̱lakapa̱tze̱kko̱lh. Chu̱ c-xlacni puclhni̱ takáxmatli̱ pi̱ taxtuchi̱ aktum tachihuí̱n hua̱ntu̱ na̱má̱ huá̱: “Huá̱ yuma̱ Quincam ti̱ quit clacsacni̱t, chu̱ luhua cpa̱xqui̱y, chu̱ xma̱n huá̱ luhua cakalhakaxpáttit.” ");
INSERT INTO tosNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Acxni̱ xlacán kaxmatko̱lh yuma̱ tachihuí̱n, lacapala̱ tatzokostako̱lh, lí̱cha̱lh xlacancán hasta ca̱tiyatna̱ caj xpa̱lacata xpe̱cuaxni̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús laktalacatzuhui̱ko̱lh, qui̱toklhko̱lh, chu̱ na̱má̱ huaniko̱lh: —Lacapala̱ cata̱yátit, chu̱ ni̱ cape̱cuántit. ");
INSERT INTO tosNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cha̱nchu̱ xlacán acxni̱ talacaya̱huako̱lh, ti̱ni̱ pala xucxilhko̱lh hua̱mpi̱ xma̱n hua̱ Jesús xta̱stum. ");
INSERT INTO tosNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cha̱nchu̱ acxni̱ xli̱makua xta̱ctama̱ko̱chi̱ c-ka̱stí̱n, Jesús chuná̱ li̱ma̱paksi̱ko̱lh: —Ni̱tí̱ pala tí̱ nali̱xakatli̱yá̱tit yuma̱ talacahuá̱n hua̱ntu̱ huixín ucxilhni̱tántit, hasta acxnicú̱ quit Xatalacsacni Chixcú̱ clakastakuanani̱t nahuán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Cha̱nchu̱ yama̱ kalhatutu xli̱ma̱kalhtahuáka̱t, kalhasquinko̱lh Jesús: —¿Tú̱ xpa̱lacata li̱huanko̱y laktzokqui̱naní̱n pi̱ pu̱lana̱ huá̱ xli̱mínat profeta Elías xuani̱t, chu̱ a̱li̱sta̱lh chú̱ namín ma̱akapu̱taxti̱na Cristo? ");
INSERT INTO tosNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Cha̱nchu̱ na̱má̱ kalhti̱ko̱lh: —Xli̱ca̱na̱ pi̱ pu̱lana̱ huá̱ Elías mima̱, chu̱ huá̱ xlá̱ nama̱ca̱xko̱y tachixcuhuí̱tat laqui̱mpi̱ tla̱n nali̱pa̱huanko̱y Cristo acxni̱ namín. ");
INSERT INTO tosNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Hua̱mpi̱ hua̱ quit lacatancs cca̱huaniyá̱n pi̱ profeta Elías aya qui̱lani̱tanchi, hua̱mpi̱ tachixcuhuí̱tat ni̱ tzinú̱ lakapasko̱lh pala huá̱, huata caj catu̱huá̱ tu̱ xlacán puhuaniko̱lh, chuná̱ chú̱ tlahuaniko̱lh. Pus na̱ li̱xcájnit la̱ntla̱ naquima̱pa̱ti̱ni̱ko̱y acxni̱ naquinchipako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Acxnicú̱ chú̱ akata̱ksko̱lh yuma̱ li̱ma̱kalhtahuáka̱t pi̱ hua̱ xlá̱ xli̱xakatli̱ma̱kó̱ Juan Bautista. ");
INSERT INTO tosNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Acxni̱ cha̱nko̱lh anta̱ni̱ xtamacxtumi̱ko̱ni̱t lhu̱hua̱ tachixcuhuí̱tat, cha̱tum chixcú̱ laktalacatzúhui̱lh Jesús, lakatatzokóstalh c-xlacatí̱n, chu̱ na̱má̱ huánilh: ");
INSERT INTO tosNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Tla̱ti, catlahua̱ li̱tlá̱n, caquilakalhámanti sa̱mpi̱ cli̱mín cha̱tum quinkahuasa hua̱nti̱ ankalhí̱n lactlahuay ni̱tlá̱n u̱n, chu̱ luhua li̱pe̱cua̱ la̱ntla̱ ma̱pa̱ti̱ni̱y. Lakachuní̱n antá̱ tapu̱ya̱chá̱ c-lhcúya̱t, usu c-chúchut taju̱ya̱chá. ");
INSERT INTO tosNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Quit luhua liyajá̱ ctili̱miniko̱lh mili̱ma̱kalhtahuáka̱t hua̱mpi̱ xlacán ni̱ lay ma̱tla̱ni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús na̱má̱ kalhtí̱nalh: —Koxutaní̱n huixín tachixcuhuí̱tat ti̱ la̱nchú̱ lapá̱tit, ni̱ lay maktum quili̱pa̱huaná̱tit, sa̱mpi̱ xli̱ca̱na̱ luhua aktzanka̱ta̱yani̱tántit, ¿hasta niajcu li̱huaya̱ makcatzi nactica̱pa̱xuhua̱na̱le̱niyá̱n, nactica̱ta̱pa̱ti̱yá̱n hua̱ntu̱ kalhi̱yá̱tit minta̱yatcán? Lacapala̱ úhuit cali̱tántit tama̱ kahuasa. ");
INSERT INTO tosNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Acxni̱ chú̱ li̱chinca̱, Jesús lacaquílhni̱lh cspiritu akskahuiní, chu̱ tlakáxtulh c-xtiyatli̱hua yama̱ kahuasa, acxnitiyá̱ chú̱ luhua li̱huana̱ tatlá̱ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A̱li̱sta̱lh yama̱ xli̱ma̱kalhtahuáka̱t acstuta̱chihui̱nanko̱lh, na̱má̱ kalhasquinko̱lh: —¿Tú̱ xpa̱lacata̱ quin ni̱ lay ctlakaxtuhu yama̱ cspiritu akskahuiní? ");
INSERT INTO tosNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús na̱má̱ kalhti̱ko̱lh: —Huixín ni̱ kalhi̱yá̱tit li̱tlihuaka̱ c-mintaca̱najlacán laqui̱mpi̱ li̱huana̱ nali̱pa̱huaná̱tit Dios. Quit xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ lapi̱ xtzucútit kalhi̱yá̱tit mintaca̱najlacán ca̱na̱ caj xta̱chuná̱ actzu̱ xatalhtzi mostaza, caj xma̱n na̱má̱ xuanítit yuma̱ ka̱stí̱n: ‘Cataka̱nu̱ antá̱ la̱ntla̱ huila, chu̱ capit tahuilaya̱ a̱lacatanu̱’, xli̱ca̱na̱ xlá̱ pi̱ xtaká̱nu̱lh. Chu̱ ni̱ pala pu̱lactum xtahui̱ hua̱ntu̱ huixín ni̱ lay xtlahuátit lapi̱ xli̱ca̱na̱ xli̱pa̱huántit Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Hua̱mpi̱ tama̱ cspiritu akskahuiní, tuhua̱ natlakaxtuyá̱tit sa̱mpi̱ li̱pe̱cua̱ tatlanca̱ni̱y, xma̱n huá̱ hua̱nti̱ namakalhkajnán la̱ntla̱ xli̱pacs xtapuhuá̱n nasquiniy Dios xtamakta̱y tla̱n natlakaxtuy. ");
INSERT INTO tosNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Maktum acxni̱ luhua macxtum xlatla̱huanko̱y c-xatiyat Galilea, Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Xli̱ca̱na̱ pi̱ huí̱ cha̱tum hua̱nti̱ naquimacama̱sta̱y c-xlacati̱ncán hua̱nti̱ quinta̱la̱tlahuako̱y, chu̱ ni̱ quiucxilhputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xlacán naquimakni̱ko̱y, hua̱mpi̱ caj xli̱aktutu quilhtamacú̱ naclakastakuanampalay ca̱li̱ní̱n. Acxni̱ xlacán kaxmatko̱lh la̱ntla̱ namakni̱cán, li̱pe̱cua̱ tzúculh tali̱puhua̱ni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Acxni̱ Jesús, chu̱ xli̱ma̱kalhtahuáka̱t cha̱nko̱lh c-xaca̱chiqui̱n Capernaum makapitzi̱n chixcuhuí̱n hua̱nti̱ ca̱ta ca̱ta̱ xma̱ta̱ji̱nanko̱y tumi̱n tu̱ xli̱xoko̱nancán xla templo̱ ta̱tanoklhko̱lh Pedro c-tiji, chu̱ na̱má̱ kalhasquinko̱lh: —Hua̱ mima̱kalhtahuaka̱nacán, ¿Tú̱ xpa̱lacata ni̱ makxoko̱nán c-tlanca quintemplo̱cán c-Jerusalén? ");
INSERT INTO tosNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Cha̱nchu̱ xlá̱ kalhtí̱nalh: —Na̱ makxoko̱nán xlá. Acxni̱ chú̱ cha̱lh xlá̱ c-chiqui̱ anta̱ni̱ xuilakó̱, tuncán tánu̱lh laqui̱mpi̱ nata̱chihui̱nán Jesús, huata pu̱lh na̱má̱ huánilh: —Simón, ¿lá̱ntla̱ huix puhuana? Yama̱ lactlanca napuxcun ma̱paksi̱naní̱n xala c-Roma, ¿pi̱ huá̱ luhua ma̱xoka̱ko̱y impuestos hua̱nti̱ xta̱chiquicán, usu hua̱nti̱ tapaksi̱ko̱y ca̱lacatanuj tíyat hua̱ntu̱ akchipahuili̱ko̱ni̱t? ");
INSERT INTO tosNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro kálhti̱lh: —Xlacán huá̱ ma̱xoka̱niko̱y hua̱nti̱ ma̱paksi̱ko̱y xala a̱lacatanu̱ tíyat. Jesús huampá̱: —Pus xli̱ca̱na̱ huana̱ pi̱ huata huá̱ chú̱ ti̱ xta̱chiquicán ni̱ xafuerza̱ naxokoniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Hua̱mpi̱ huata laqui̱mpi̱ ni̱tí̱ naquinca̱li̱huaniyá̱n pi̱ ni̱ makxoko̱nana̱hu, lacapala̱ huix capimpi̱ c-ta̱kaya̱huaná, antá̱ camacapi̱ mili̱ma̱slokuí̱n, huá̱ chú̱ tu̱ xakasiya̱ squi̱ti̱ napa̱ti̱y tuncán cama̱cutu. Antá̱ chú̱ c-xquilhni̱ nata̱ksa̱ paktum tumi̱n hua̱ntu̱ naacchá̱n nali̱xokoya̱ tu̱ ma̱ta̱ji̱nancán xala c-templo, naxokoya̱ quilá, chu̱ milá. ");
INSERT INTO tosNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na̱ acxnitiyá̱ chú̱ yama̱ quilhtamacú̱ xli̱ma̱kalhtahuáka̱t Jesús laktalacatzúhui̱lh, chu̱ na̱má̱ kalhasquinko̱lh: —La̱ntla̱ quili̱lhu̱huacán ti̱ cca̱li̱pa̱huaná̱n, ¿xatí̱ cahuá̱ a̱tzinú̱ tlak nakalhi̱y xlakasi, usu tali̱pa̱hu nali̱taxtuy c-xasa̱sti xtapaksi̱t Dios tu̱ ma̱quilhtzuqui̱ma̱? ");
INSERT INTO tosNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús tasánilh cha̱tum actzu̱ kahuasa, c-xíta̱t yá̱hualh, ");
INSERT INTO tosNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","chu̱ na̱má̱ huaniko̱lh: —Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lapi̱ huixín ni̱ nalakpali̱yá̱tit mintalacapa̱stacnicán, chu̱ ni̱ nali̱taxtuyá̱tit la̱ntla̱ lactzu̱ camán hua̱nti̱ ni̱ kalhi̱y xlakasi makcatzi̱cán, ni̱ lay catitapaksí̱tit c-xasa̱sti xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hua̱mpi̱ hua̱nti̱ a̱tzinú̱ xlakasi nali̱taxtuy c-xasa̱sti xtapaksi̱t Dios hua̱ yumá̱ ti̱ ni̱tú̱ putzama̱ la̱ntla̱ talí̱pa̱hu nahuán, huata kalhi̱y xtalacapa̱stacni̱ xta̱chuná̱ la̱ntla̱ yuma̱ hua̱nti̱ ni̱tú̱ xlakasi actzu̱ kahuasa. ");
INSERT INTO tosNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chi̱nchu̱ hua̱nti̱ pa̱xqui̱y, chu̱ tla̱n nacatzi̱niy cha̱tum actzu̱ kahuasa̱ caj xpa̱lacata̱ catzi̱y pi̱ quit cpa̱xqui̱y, pus luhua xta̱chuná̱ cli̱maxtuy pi̱ quit quimpa̱xqui̱ma̱, chu̱ tla̱n quincatzi̱nima̱. ");
INSERT INTO tosNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Na̱ caxati̱cahuá̱ ti̱ xma̱lacatiji̱ni̱ko̱lh c-ni̱tla̱n tiji̱ na̱ yuma̱ lactzu̱ camán hua̱nti̱ aya quili̱pa̱huanko̱y, hua̱ yuma̱ chixcú̱ huata xali̱huaca̱ tla̱n xuá̱ xli̱makua̱ ni̱ a̱ma̱tlahui̱nán tala̱kalhí̱n, xpixchi̱huacaca̱ aktum tlanca xachihuix molino, chu̱ lkan xmaca̱nca̱ c-xtampu̱n chúchut c-ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Luhua xli̱ca̱na̱ pi̱ ni̱ pala tzinú̱ tla̱n la̱ntla̱ lama̱hu ca̱tuxá̱huat, sa̱mpi̱ catu̱huá̱ anán pacs li̱laktzanka̱ta̱yacán. Luhua chuná̱ xli̱ankalhí̱n huij nahuán, hua̱mpi̱ ¡koxutá̱ hua̱ yama̱ chixcú̱ hua̱nti̱ nama̱tzuqui̱y tu̱ nali̱laktzanka̱ta̱yako̱y a̱makapitzí̱n! ");
INSERT INTO tosNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ lapi̱ hua̱ mimacán, usu mintantú̱n nama̱tlahui̱yá̱n tala̱kalhí̱n, huata xatlá̱n caca̱acti, chu̱ mákat camákanti; sa̱mpi̱ a̱tzinu̱ li̱huaca̱ tla̱n tantu̱stulu, usu pakastulu̱ nalakcha̱na̱chá̱n li̱pa̱xuhu latáma̱t hua̱ntu̱ xa̱li̱ankalhí̱n nakalhi̱ya, ni̱ xahua̱ xaacchá̱n nakalhi̱ya̱ kantuy mimacán, chu̱ kantuy mintuhuán namacapincana̱ c-lhcúya̱t anta̱ni̱ niucxni̱ catímixli. ");
INSERT INTO tosNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Chi̱nchu̱ hua̱ lapi̱ hua̱ milakastapu̱ ma̱tlahui̱yá̱n tala̱kalhí̱n, calacpi̱ma̱xtuca, na̱ mákat camákanti, sa̱mpi̱ xali̱huaca̱ tla̱n caj aktum milakastapu̱ nakalhi̱ya̱ nalakcha̱na̱chá̱n yama̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ xa̱li̱ankalhí̱n nakalhi̱ya, ni̱ xahua̱ acchá̱n nakalhi̱ya̱ aktuy milakastapu̱ lapi̱ antá̱ chú̱ namacapincana̱ c-pu̱pa̱tí̱n c-lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ca̱na̱ huixín, niucxni̱ tilakmakaná̱tit na̱ yumá̱ lactzu̱ camán hua̱nti̱ aya quili̱pa̱huanko̱ni̱t ma̱squi ni̱ pala tú̱ xlakasicán tasiyuko̱y, sa̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ xlacán kalhi̱ko̱y cha̱tunu xángeles hua̱nti̱ maktakalhma̱kó̱, chu̱ antá̱ xlacán c-akapú̱n ankalhí̱n pa̱lacachihui̱nama̱kó̱ c-xlacati̱n Quintla̱tican Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xa̱hua̱ quit na̱ clakalhamanko̱y sa̱mpi̱ huá̱ cli̱mini̱t nacma̱laktaxti̱ko̱y hua̱nti̱ aya xaktzanka̱ta̱yako̱ni̱t u̱nú̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Pus lapi̱ huí̱ ti̱ cha̱tum chixcú̱ kalhi̱y aktum ciento xcalhni̱lu̱, chu̱ pala xamaktum namakatzanka̱y tantum, ¿tú̱ huixín puhuaniyá̱tit natlahuay? Quit cpuhuán pi̱ lapi̱ xli̱ca̱na̱ pa̱xqui̱y namakaxtakko̱y a̱makapitzí̱n ta̱tipuxamacu̱naja̱tza̱ pi̱ xacstucán naputxua̱yanko̱y ca̱tuhuá̱n laqui̱mpi̱ lacapala̱ naán putzay yama̱ koxuta calhni̱lu̱ hua̱ntu̱ makatzanka̱ni̱t, chu̱ ni̱ catitáspitli̱ hasta acxni̱ nata̱ksa. ");
INSERT INTO tosNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Chu̱ lapi̱ fuerza̱ naqui̱ta̱ksa̱ luhua tlak nali̱pa̱xuhuay sa̱mpi̱ tasíyulh yama̱ tantum xcalhni̱lu̱ hua̱ntu̱ xmakatzanka̱ni̱t, chu̱ ni̱ luhua xta̱chuná̱ catili̱pa̱xuhuako̱lh a̱makapitzí̱n xcalhni̱lu̱ tu̱ ni̱tú̱ xtzanka̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pus na̱ chuná̱ chú̱ Mintla̱ticán hua̱nti̱ huilachá̱ c-akapú̱n, xlá̱ ni̱ lacasquín ni̱ pala cha̱tum na̱ yuma̱ lactzu̱ camán naaktzanka̱y hua̱nti̱ quit quili̱pa̱huanko̱y ma̱squi luhua ni̱tú̱ xlakasi tasiyuy. ");
INSERT INTO tosNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Na̱ chuná̱ lapi̱ cha̱tum minta̱ca̱najlani̱ hua̱nti̱ tlahuanini̱tán hua̱ntu̱ ni̱tlá̱n, luhua lacati̱tum cata̱chihuí̱nanti̱ xacstu, chu̱ cahuani̱ pi̱ luhua cui̱ntaj catláhualh sa̱mpi̱ ni̱tlá̱n tu̱ tlahuanini̱tán. Lapi̱ xlá̱ nakaxmatniyá̱n tu̱ huix nahuaniya, pus chú̱ qui̱taxtuy pi̱ huix aya tla̱n nali̱kalhi̱palaya̱ minta̱lá̱ a̱maktum. ");
INSERT INTO tosNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Chí̱ hua̱ palapi̱ ni̱ cuí̱ntaj natlahuaniyá̱n, chu̱ ni̱ tla̱n natlahuaniyá̱n hua̱ntu̱ huix nahuaniya, pus huix lacapala̱ catasanikó̱ cha̱tum usu kalhatutu testigos hua̱nti̱ na̱ nakaxmatko̱y, chu̱ nama̱lulokko̱y pi̱ xli̱ca̱na̱ tu̱ huix nali̱ta̱chihui̱nana. ");
INSERT INTO tosNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hua̱mpi̱ lapi̱ ni̱ pala chuná̱ nakaxmatniko̱y hua̱ntu̱ xlacán nali̱xakatli̱ko̱y, pus huata chú̱, tuncán cama̱catzi̱ni̱kó̱ minta̱ca̱najlaní̱n acxni̱ nata̱tamacxtupi̱ko̱ya̱ laqui̱mpi̱ xlacán huá̱ naxakatli̱ko̱y. Chu̱ lapi̱ xlá̱ na̱ ni̱tlá̱n natlahuaniko̱y xtachihui̱ncán, pus huata chú̱ huix tla̱n nali̱ma̱xtuya̱ xta̱chuná̱ la̱ntla̱ cha̱tum chixcú̱ hua̱nti̱ nia̱lh luhua li̱pa̱huán usu la̱ntla̱ hua̱nti̱ nia̱lh ca̱ta̱tapaksi̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Quit lacatancs cca̱huaniyá̱n pi̱ hua̱ntu̱ huixín mili̱pu̱tumcán ca̱najlaní̱n nachi̱yá̱tit, usu tla̱n natlahuayá̱tit u̱nú̱ ca̱tiyatna, pus na̱ chuná̱ tachí̱n huilachá nahuán c-akapú̱n; hua̱mpi̱ na̱ chuná̱ hua̱ntu̱ huixín naxcutá̱tit, usu ni̱ tla̱n natlahuayá̱tit u̱nú̱ ca̱tiyatna, na̱ xataxcutni huilachá nahuán c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Quit lacatancs cca̱huaniyá̱n pi̱ lapi̱ huixín ma̱squi caj mincha̱tuycán luhua lacxtum nali̱catzi̱yá̱tit xpa̱lacata̱ pala tú̱ nasquiniyá̱tit Dios acxni̱ natlahuayá̱tit mioracioncán, xli̱ca̱na̱ pi̱ hua̱ Quintla̱t ti̱ huilachá̱ c-akapú̱n naca̱ma̱xqui̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sa̱mpi̱ cani̱huá̱ anta̱ni̱ ma̱squi caj li̱cha̱tuy, usu li̱kalhatutu̱ tamacxtumi̱ko̱y hua̱nti̱ quili̱pa̱huanko̱y, antá̱ quit c-xíta̱t claksti̱pa̱huilakó̱ nahuán.” ");
INSERT INTO tosNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro laktalacatzúhui̱lh Jesús, chu̱ na̱má̱ kalhásquilh: —Quimpu̱chiná, chi̱nchu̱ pala cha̱tum quinta̱chixcú̱ ankalhí̱n quinta̱la̱tlahuay, ¿ní̱ makli̱t nacta̱pa̱ti̱y, chu̱ nacma̱tzanka̱naniy? ¿Pi̱ cahuá̱ hasta̱ pala maktujún? ");
INSERT INTO tosNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kálhti̱lh: —Quit ni̱tú̱ cuanimá̱n hasta pala maktujún nata̱pa̱ti̱ya, chu̱ nama̱tzanka̱naniya, huata huix tla̱n nama̱tzanka̱naniya̱ pala tú̱ xtlahuanín, chu̱ nata̱pa̱ti̱ya̱ hasta ma̱squi akta̱ti ciento a̱ta̱tipuxamaca̱hu pala chuná̱ talacasquín. ");
INSERT INTO tosNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Yama̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱lacatzuqui̱ma̱ u̱nú̱ ca̱tiyatna, xta̱chuná̱ qui̱taxtuy la̱ntla̱ yama̱ cha̱tum rey hua̱nti̱ tita̱tlahuaputunko̱lh cue̱nta̱ laqui̱mpi̱ nacatzi̱y ni̱nchulá̱ tapa̱hua̱ li̱huilaniko̱lh cscujní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aya xtzucuni̱ttá̱ ta̱tlahuako̱y cue̱nta̱ acxni̱ tili̱minica̱ cha̱tum cscujni̱ hua̱nti̱ lhu̱hua tumi̱n tapa̱hua̱ xli̱hui̱. ");
INSERT INTO tosNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Hua̱mpi̱ cumu yama̱ chixcú̱ ni̱tú̱ xkalhi̱y hua̱ntu̱ nali̱xoko̱nán, hua̱ yuma̱ Rey li̱ma̱paksí̱nalh pi̱ castá̱ca̱ xta̱chuná̱ la̱ntla̱ cha̱tum tachí̱n, xa̱hua̱ xpusca̱t, chu̱ xcamán, chu̱ pu̱tum la̱ntla̱ tu̱ xkalhi̱y laqui̱mpi̱ pacs chú̱ chuná̱ nali̱xoko̱nanko̱y hua̱ntu̱ xlá̱ xlakahui̱. ");
INSERT INTO tosNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Hua̱ yamá̱ scujni̱ lakatatzokóstalh c-xlacati̱n xma̱la̱ná, chu̱ na̱má̱ huánilh: ‘Tla̱ti, csquiniyá̱n caquintlahuani̱ tlanca li̱tlá̱n, Caquinkalhi̱ni̱ tapa̱xuhua̱na̱lé̱n a̱tzinú̱. Quit pacs nacxokoniyá̱n tu̱ clé̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yama̱ Rey lakalhámalh, ma̱tzanka̱nánilh, chu̱ nia̱lh ma̱tá̱ji̱lh hua̱ntu̱ xlakahuilánilh, chu̱ a̱li̱sta̱lh makáxtakli̱ laqui̱mpi̱ caalhá̱ c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Hua̱mpi̱ caj la̱ntla̱ taxtuchá̱ c-tiji̱ yama̱ scujni̱ xlá̱ ta̱tánoklhli̱ cha̱tum xta̱scujni̱ hua̱nti̱ na̱ xlacle̱niy actzu̱ centavo. Xlá̱ ma̱chókolh chu̱ li̱pixchípalh xmacán, tzúculh pixpitay, chu̱ na̱má̱ huánilh: ‘Chuj tuncán clacasquín caquilakxokoni̱ yama̱ quintumi̱n hua̱ntu̱ quilakahuilani, usuchí̱ naquintilakapasacú̱ xatí̱ quit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Cha̱nchu̱ yama̱ xta̱scujni, lakatatzokóstalh, csquinima̱ li̱tlá̱n huánilh: ‘Caquinkalhi̱ni̱ tapa̱xuhua̱na̱lé̱n, na̱ pacs nacxokoniyá̱n xli̱pacs.’ ");
INSERT INTO tosNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Hua̱mpi̱ yama̱ chixcú̱ xlá̱ ni̱ ta̱pá̱ti̱lh, tuncán ma̱tamacanu̱ní̱nalh c-pu̱la̱chi̱n, chu̱ ni̱ makaxtakca̱ hasta acxni̱ afuerza ma̱xoko̱ni̱ko̱lh actzu̱ tumi̱n hua̱nti̱ xlá̱ xle̱niy. ");
INSERT INTO tosNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Acxni̱ a̱makapitzi̱n xta̱scujní̱n catzi̱ko̱lh hua̱ntu̱ xlá̱ xtlahuani̱t, xlacán luhua xli̱ca̱na̱ li̱si̱tzi̱ko̱lh, na̱ anko̱lh huaniko̱y xma̱la̱nacán xli̱pacs hua̱ntu̱ xlani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Acxni̱ chú̱ huaniko̱ca̱, hua̱ yuma̱ Rey tuncán ma̱tasani̱nán chixcú, chu̱ na̱má̱ huánilh acxni̱ lacaquílhni̱lh: ‘Luhua ni̱tla̱n mintá̱yat huix. Xli̱pacs yamá̱ tu̱ xquili̱piniya, pacs cma̱tzanka̱nanín, xpa̱lacata̱ pi̱ quisquini̱ caclakalhamán. ");
INSERT INTO tosNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pus huix na̱ chuná̱ xtilakalhámanti̱ yama̱ koxuta minta̱scujni̱ xta̱chuná̱ la̱ntla̱ quit ckalhi̱nín talakalhamá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cha̱nchu̱ xma̱la̱ná, pi̱ sí̱tzi̱lh, pus ma̱paksí̱nalh pi̱ cama̱pa̱ti̱ni̱ca̱ hasta ni̱li̱huaya̱ naxokoko̱y hua̱ntu̱ xle̱niy.” ");
INSERT INTO tosNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Acxni̱ Jesús chihui̱nanko̱lh, na̱má̱ huaniko̱lh: —Pus na̱ chuná̱ naca̱tlahuayá̱n Mintla̱tican Dios hua̱nti̱ huilachá̱ c-akapú̱n hua̱ palapi̱ ni̱ luhua minacu̱cán nali̱ma̱tzanka̱naniyá̱tit cha̱tunu minata̱lancán hua̱ntu̱ pala ca̱li̱makasi̱tzi̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Acxni̱ Jesús chuná̱ ma̱katspútulh xtakalhchihuí̱n, táxtulh c-xatiyat Galilea, chu̱ antá̱ chá̱lh anta̱ni̱ c-xtachipa xtiyat Judea hua̱ntu̱ huí̱ li̱quilhtu̱án c-xakalhtu̱choko̱ Jordán. ");
INSERT INTO tosNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na̱ luhua lhu̱hua̱ tachixcuhuí̱tat tista̱laniko̱lh, chu̱ antá̱ xlá̱ tima̱pacsako̱chá̱ xli̱pacs ta̱tatlaní̱n ti̱ lakminko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Makapitzi̱n fariseos laktalacatzuhui̱ko̱lh caj xkalhputzaputunko̱y pala tú̱ ni̱ tancs nakalhti̱nán, chunachí̱ tla̱n nali̱ma̱makuasi̱ya̱huako̱y. Tzúculh kalhputzako̱y, na̱má̱ kalhasquinko̱lh: —¿Lá̱ntla̱ huix huana? ¿Pi̱ kalhi̱y li̱ma̱paksí̱n namakaxtaka̱ xpusca̱t cha̱tum chixcú̱ ma̱squi pala caxatu̱cahuá̱ xpa̱lacata? ");
INSERT INTO tosNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús kalhti̱ko̱lh: —¿Lá̱ntla̱ pi̱ ni̱ a̱li̱kalhtahuakayá̱tit huixín hua̱ntu̱ tatzoktahuilani̱t xtachihui̱n Dios c-Li̱kalhtahuaka? Antá̱ huan pi̱ acxni̱ Dios ma̱lacatzucúnalh c-xquilhtzúcut, xlá̱ tláhualh cha̱tum chixcú, chu̱ cha̱tum pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chu̱ na̱ chuná̱ li̱ma̱peksí̱nalh: ‘Huachá̱ xpa̱lacata, cha̱tum kahuasa acxni̱ natapu̱chuhuay, tla̱n nali̱makaxtaka̱ xtla̱t, chu̱ xtzi̱ la̱qui̱mpi̱ xlá̱ nata̱talakxtumi̱y xpusca̱t, chu̱ yama̱ kahuasa, chu̱ tzuma̱t hua̱nti̱ xcha̱tuycán xuanko̱ni̱t, chiyú̱ luhua cha̱tumá nali̱taxtuko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Pus qui̱taxtuy pi̱ acxni̱ natapu̱chuhuako̱y, nia̱lh xcha̱tuycán huata cha̱tumá̱ nahuanko̱y. Huá̱ cca̱li̱huaniyá̱n, ni̱ cha̱tum chixcú̱ mini̱niy nama̱pa̱pitziy hua̱ntu̱ Dios cha̱tumi̱nica̱ tláhualh. ");
INSERT INTO tosNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xlacán kalhasquimpalako̱lh: —Tla̱n huana, hua̱mpi̱, ¿tú̱ xpa̱lacata c-xli̱ma̱paksi̱n Moisés huan pi̱ cha̱tum chixcú̱ tla̱n namakaxtaka̱ xpusca̱t, hua̱mpi̱ pu̱lh nata̱lacca̱xlay c-pu̱chihuí̱n, chu̱ namacama̱xqui̱y mactum xatalacca̱xlan cápsnat, nafirmartlahuanicán, chu̱ antá̱ nahuán hua̱ntu̱ xpa̱lacata la̱li̱makaxtakma̱, tla̱n chinchú̱ namakaxtaka̱ xpusca̱t, chu̱ taxapani̱t nahuán xtapu̱chuhuatcán? ");
INSERT INTO tosNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús huaniko̱lh: —Moisés ma̱tlá̱ni̱lh pi̱ nala̱makaxtakko̱y hua̱nti̱ tapu̱chuhuako̱ni̱t caj xpa̱lacata̱ pi̱ huixín luhua xalactzaca̱tna, chu̱ ni̱ lay akata̱ksá̱tit hua̱ntu̱ xatla̱n talacapa̱stacni; hua̱mpi̱ la̱ntla̱ Dios ma̱lacatzúqui̱lh xapu̱lh chixcu̱, xa̱hua̱ xapulh pusca̱t, xlá̱ niucxnicú̱ tla̱n tlahuani̱t nala̱makaxtakko̱y hua̱nti̱ pu̱chuhuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Quit lacatancs cca̱huaniyá̱n pi̱ lapi̱ cha̱tum chixcú̱ namakaxtaka̱ xpusca̱t, ma̱squi xlá̱ yama̱ pusca̱t ni̱tú̱ xakatli̱y a̱tanuj chixcú, chu̱ yama̱ chixcú nata̱tapu̱chuhuay tanuj pusca̱t, xli̱ca̱na̱ pi̱ luhua lhu̱hua tala̱kalhí̱n tlahuay sa̱mpi̱ xlá̱ caj lactlahuaya̱huay aktum tapu̱chúhuat. Na̱ chuná̱ ya̱ma̱ chixcú̱ hua̱nti̱ nata̱tapu̱chuhuay pusca̱t hua̱nti̱ makaxtakcani̱t, xlá̱ na̱ luhua lhu̱hua tala̱kalhí̱n tlahuay sa̱mpi̱ xlá̱ maktum pi̱ lactlahuako̱y ya̱ma̱ tapu̱chúhuat hua̱ntu̱ Dios tisculuna̱tláhualh. ");
INSERT INTO tosNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xli̱ma̱kalhtahuáka̱t na̱má̱ huaniko̱lh: —Pus palapi̱ xli̱ca̱na̱ chuná qui̱taxtuniy cha̱tum chixcú̱ tu̱ huix quilhuámpa̱t, pi̱ ni̱ xli̱makaxtákat xpusca̱t, pus luhua ni̱ pala tzinú̱ li̱tapu̱chuhuaputu. ");
INSERT INTO tosNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús huaniko̱lh: —Xli̱ca̱na̱ pi̱ huá̱ yu̱ma̱ talacapa̱stacni xpa̱lacata̱ la̱ntla̱ ni̱ natapu̱chuhuaya, tuhua̱ qui̱taxtuy sampi̱ ni̱ li̱pu̱tum catimacálahu lapi̱ ni̱ Dios chuná̱ ma̱lacapa̱stacako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Hua̱mpi̱ u̱nú̱ ca̱tuxá̱huat lama̱kó̱ makapitzi̱n chixcuhuí̱n hua̱nti̱ chuná̱ kalhi̱ko̱y xtiyatli̱huacán pi̱ ni̱ lay catitapu̱chuhuako̱lh, chu̱ makapitzí̱n hua̱nti̱ kas chuná̱ lactlahuaya̱huanicani̱t xlatama̱tcán la̱qui̱mpi̱ nia̱lh ucxnicú̱ natapu̱chuhuako̱y, hua̱mpi̱ na̱ lama̱kó̱ makapitzí̱n hua̱nti̱ tla̱n tapu̱chuhuako̱y, hua̱mpi̱ ni̱ tapu̱chuhuaputunko̱y caj xpa̱lacata xlacán catzi̱ko̱y pi̱ chuná̱ á̱tzinú̱ tla̱n natlahuako̱y hua̱ntu̱ Dios lakati̱y c-xlatama̱tcán, chu̱ hua̱ntu̱ xlá̱ li̱lacsacko̱ni̱t. Pus hua̱nti̱ ma̱tla̱ni̱y pi̱ chuná̱ nalatama̱y la̱ntla̱ cca̱huanini̱tán ucú, pus xli̱ca̱na̱ pi̱ chuná̱ cali̱tzáksalh. ");
INSERT INTO tosNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Maktum makapitzí̱n li̱miniko̱lh lactzu̱ xcamancán anta̱ni̱ xuí̱ Jesús la̱qui̱mpi̱ xlá̱ nali̱acchipakoy xmacán, chu̱ nasquiniy Dios pi̱ nasiculana̱tlahuako̱y. Hua̱mpi̱ huata xli̱ma̱kalhtahuáka̱t tzúculh lacaquilhni̱ko̱y hua̱nti̱ xli̱mima̱kó̱ ya̱ma̱ lactzu̱ camán. ");
INSERT INTO tosNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Hua̱mpi̱ Jesús káxmatli, chu̱ huaniko̱lh: —Ni̱ cali̱huanikó̱tit tama̱ lactzu̱ camán pi̱ naquilakminko̱y anta̱ni̱ quit cuí̱, sa̱mpi̱ xli̱ca̱na̱ pi̱ caj xma̱n huá̱ hua̱nti̱ kalhi̱y xtalacapa̱stacni̱ la̱ntla̱ tu̱ kalhi̱ko̱y lactzu̱ camán, xlá̱ mini̱niy li̱pa̱xuhuay tu̱ Dios quinca̱ma̱xqui̱putuná̱n c-xasa̱sti xtapáksi̱t tu̱ ma̱quilhtzuqui̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A̱li̱sta̱lh chú̱ xlá̱ li̱acchipako̱lh xmacán, chu̱ siculana̱tlahuako̱lh ya̱ma̱ lactzu̱ camán. Acxni̱ chu̱ chuná̱ ca̱tlahuako̱lh, Jesús tatampú̱xtulh, chu̱ alh a̱lacatanu̱. ");
INSERT INTO tosNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maktum cha̱tum kahuasa qui̱láklalh Jesús, chu̱ na̱má̱ kalhásquilh: —Ma̱kalhtahuaka̱ná, ¿tú̱ luhua tla̱n tatlahu quili̱tláhuat hua̱ntu̱ naquimakta̱yay la̱qui̱mpi̱ tla̱n nackalhi̱y li̱pa̱xuhu latáma̱t c-akapú̱n hua̱ntu̱ niucxni̱ nalaksputa? ");
INSERT INTO tosNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Cha̱nchu̱ Jesús huánilh: —¿Tú̱huan quinkalhasquina̱ xpa̱lacata hua̱ntu̱ xli̱ca̱na̱ tla̱n tatatlahu? Caj xma̱n hua̱ Dios hua̱nti̱ chuná̱ tla̱n catzi̱y, chu̱ tlahuay tu̱ xli̱ca̱na̱ tla̱n tascújut. Hua̱mpi̱ lapi̱ xli̱ca̱na̱ huix kalhi̱putuna̱ ya̱ma̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ niucxni̱ laksputa, quit cuaniyá̱n pi̱ cali̱tzaksa̱ catlahua̱ xli̱ma̱pa̱ksi̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ama̱ kahuasa huánilh: —¿Xatú̱ ya̱ li̱ma̱pa̱ksí̱n hua̱ntu̱ huix huanípa̱t? Jesús kálhti̱lh: —‘Niucxni̱ timakni̱nana, ni̱ caxakatli̱ tanuj pusca̱t lapi̱ huí̱ mimpusca̱t, ni̱tú̱ tikalha̱nana, niucxni̱ tí̱ tima̱xtuniya̱ ta̱ksaní̱n, ");
INSERT INTO tosNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","capa̱xqui̱kó̱ mintla̱t, chu̱ mintzí, chu̱ na̱ calakalhamankó̱ xli̱pacs a̱makapitzí̱n chuná̱ la̱ntla̱tá̱ huix acstulakalhamancana.’ ");
INSERT INTO tosNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ama̱ kahuasa huánilh: —Xli̱pacs yu̱ma̱ li̱ma̱pa̱ksí̱n tu̱ huix quihuanípa̱t, pacsá̱ ctlahuani̱t hasta c-quinca̱taskata. ¿Tu̱ ta̱jí̱ quintzanka̱niy? ");
INSERT INTO tosNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Pus huánilh Jesús: —Hua̱ palapi̱ xli̱ca̱na̱ luhua aksti̱tum latapa̱putuna, pus lacapala̱ capimpi̱ c-mínchic, casta̱t xli̱pacs hua̱ntu̱ kalhi̱ya, chu̱ ya̱ma̱ mintumi̱n hua̱ntu̱ namaklhti̱nana, cama̱akpitzinikó̱ hua̱nti̱ lakli̱ma̱xkaní̱n, chuna chí̱ huix nakalhi̱ya̱ lhu̱hua̱ mintamacú̱n antá̱ c-akapú̱n. Acxni̱ chú̱ chuná̱ natlahuako̱ya, lacapala̱ natampalaya̱ la̱qui̱mpi̱ huix na̱ naquista̱laniya. ");
INSERT INTO tosNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Hua̱mpi̱ acxni̱ ya̱ma̱ kahuasa káxmatli̱ hua̱ntu̱ huanica̱, luhua xli̱ca̱na̱ cha̱li̱puhua̱na̱ álh sa̱mpi̱ xlá̱ luhua ma̱tamacu̱nú xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A̱li̱sta̱lh Jesús na̱má̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Quit lacatancs cca̱huaniyá̱n pi̱ luhua tuhua̱ xpa̱lacata ma̱tamacu̱naní̱n natanu̱ya̱chá̱ c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Catzi̱yá̱tit pi̱ luhua tuhua xuá̱ xpa̱lacata tantum camello natanu̱y c-tzan xalhucu li̱tzapan, hua̱mpi̱ cca̱huaniyá̱n pi̱ tlak xatuhua xpa̱lacata cha̱tum ti̱ kalhi̱y lhu̱hua tumi̱n natanu̱y c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Acxni̱ xli̱ma̱kalhtahuáka̱t káxmatli̱ xtachihuí̱n, luhua cacs li̱lacahuanko̱lh, chu̱ tzúculh la̱kalhasquinko̱y xacstucán: —Lapi̱ chuná̱ naqui̱taxtuy, ¿tí̱ chu̱ tla̱n nalakma̱xtuy xli̱stacna? ");
INSERT INTO tosNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús laklaca̱nko̱lh, chu̱ na̱má̱ huaniko̱lh: —Xli̱ca̱na̱ pi̱ hua̱ntu̱ xpa̱lacatacan chixcuhuí̱n ni̱ lay ma̱tla̱ni̱ko̱y hua̱ntu̱ quit cquilhuama̱, hua̱mpi̱ hua̱ntu̱ xpa̱lacata Dios ni̱ pala pu̱lactum huí̱ hua̱ntu̱ napuhuaná̱tit pala ni̱ lay tlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro na̱má̱ huánilh: —Ma̱kalhtahuaka̱ná, quin pacs cmakaxtakni̱tahu hua̱ntu̱ xackalhi̱ya̱hu caj xpa̱lacata huix cca̱sta̱lanini̱tán, pus ¿xatú̱ ya̱ quintaskahucán naquinca̱ma̱xqui̱caná̱n a̱li̱sta̱lh? ");
INSERT INTO tosNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús kálhti̱lh: —Quit xli̱ca̱na̱ cca̱huaniyá̱n pi̱ antá̱ ya̱má̱ c-xasa̱sti ca̱quilhtamacú̱ tu̱ naquinca̱ma̱xqui̱yá̱n Dios, quit Xatalacsacni Chixcú nactahuilaya̱chá̱ c-xali̱lakati̱t xlactahui̱lh Rey hua̱ntu̱ huí̱ c-quimpu̱ma̱paksí̱n, chi̱nchu̱ huixín hua̱nti̱ ankalhí̱n quista̱lanipá̱tit, pus huixín minkalhacu̱tuycán, na̱ nakalhi̱yá̱tit milactahui̱lhcán laqui̱mpi̱ chuná̱ huixín naquinta̱makma̱paksi̱yá̱tit yama̱ pu̱laccu̱tuy israelitas hua̱nti̱ xma̱quilhtzuqui̱ko̱ni̱t xamaka̱n ko̱lutzi̱n Israel. ");
INSERT INTO tosNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na̱ caxati̱cahuá̱ ti̱ makaxtakko̱ni̱t xchiccán, usu xcamán, na̱ chuná̱ lapi̱ makaxtakko̱ni̱t xtíyat caj xpa̱lacata pi̱ quista̱laniko̱ni̱t, chu̱ quili̱pa̱huanko̱ni̱t, la̱ntla̱ pu̱lacatunu̱u tu̱ makaxtakkoni̱t qui̱taxtuy napu̱xokoniko̱cán, hasta a̱akatunu ciento li̱huacá̱, chu̱ na̱ namaklhti̱nanko̱y li̱pa̱xuhu latáma̱t hua̱ntu̱ niucxni̱ laksputa. ");
INSERT INTO tosNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pus lhu̱hua lactali̱pa̱hu hua̱nti̱ la̱nchiyú̱ luhua macapu̱lama̱kó̱, acxni̱ ya̱ma̱ quilhtamacú huata xlacán a̱huatiyá̱ namacasta̱lako̱y, chi̱nchu̱ lhu̱hua̱ ti̱ la̱nchiyú̱ ni̱tú̱ xlakasi li̱taxtuko̱y luhua a̱huatiyá̱ macasta̱lama̱kó̱, hua̱mpi̱ acxni̱ ya̱ma̱ quilhtamacú huata namacapu̱lako̱y, pu̱lh huá̱ nama̱xqui̱ko̱cán xpu̱tahui̱lhcán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Yama̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱lacatzuqui̱ma̱, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ cha̱tum chixcú̱, xpu̱china aktum tlanca pú̱cuxtu, hua̱nti̱ alh putzako̱y tzi̱sa̱ xtasa̱cua̱ laqui̱mpi̱ naanko̱y puxniko̱y xacha̱n xuvas. ");
INSERT INTO tosNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xlá̱ qui̱ta̱ksko̱lh makapitzí̱n hua̱nti̱ cscujputunko̱y, chu̱ ta̱lacca̱xlako̱lh pi̱ nama̱skahui̱ko̱y okxtum tumi̱n huanicán denario caj la̱ntla̱ tantacú̱ nascujko̱y, a̱li̱sta̱lh chú̱ ma̱lakacha̱ko̱lh c-xpú̱cuxtu̱ laqui̱mpi̱ antá̱ nascujko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Caj li̱puntzú̱ taxtupá̱ yama̱ chixcú, ma̱x cumu ca̱maknaja̱tza hora, chu̱ na̱ chuná̱ ucxilhpalako̱lh makapitzi̱n chixcuhuí̱n hua̱nti̱ na̱ caj chunata xlahuilakó̱ c-tlanca̱ti̱, chu̱ ni̱tú̱ xli̱scujma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pus huaniko̱lh: ‘Amigos, huixín na̱ capimpítit c-quinca̱uvasna, chu̱ antá̱ cascújtit, ni̱tú̱ capuhuántit quit nacca̱ma̱xqui̱yá̱n mintaskahucán hua̱ la̱ntla̱ lakchá̱n mitascujutcán.’ Pus xlacán na̱ anko̱lh scujko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yama̱ xpu̱china ca̱uvasna̱ taca̱xpá̱, ma̱x pala tastúnut, chu̱ a̱li̱sta̱lh chú̱ na̱ ampá̱ pala ca̱maktutu hora, chu̱ na̱ chuná̱ qui̱putzapalako̱lh xtasa̱cua̱ hua̱nti̱ nascujko̱y c-xca̱uvasna. ");
INSERT INTO tosNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Acxni̱ chú̱ lakcha̱mpá̱ ca̱makquitzis hora la̱ntla̱ aya ko̱tanu̱ko̱y, xlá̱ ampá̱ c-plaza, chu̱ na̱ chuna li̱tum ucxilhpalako̱lh makapitzi̱n chixcuhuí̱n hua̱nti̱ caj chunata xuilakó̱. Xlá̱ huaniko̱lh: ‘¿Tú̱huan caj chunata lahuilátit tantacú̱, chu̱ ni̱tú̱ li̱scujpá̱tit?’ ");
INSERT INTO tosNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Xlacán kalhti̱nanko̱lh: ‘Sa̱mpi̱ yuma̱ quilhtamacú̱ ni̱tí̱ quinca̱sa̱cuani̱tán.’ Yama̱ chixcú̱ na̱má̱ huaniko̱lh: ‘Lapi̱ luhua xli̱ca̱na̱ scujputuná̱tit lacapala̱ capimpítit c-quinca̱uvasna̱ laqui̱mpi̱ antá̱ nascujá̱tit, chu̱ ni̱tú̱ capuhuántit sa̱mpi̱ quit nacca̱ma̱skahui̱yá̱n hua̱ la̱ntla̱ lakchá̱n mintascujutcán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Acxni̱ ko̱tánu̱lh yuma̱ quilhtamacú̱, huá̱ xama̱la̱ná̱ ti̱ xlá̱ uvas, huánilh xapuxcu̱ xtasa̱cua: ‘Catasanikó̱ scujní̱n, na̱ cama̱skahui̱kó̱ xla xtascujutcán, hua̱mpi̱ cali̱macatzucukó̱ hua̱nti̱ a̱huatiyá̱ chinko̱ni̱t laqui̱mpi̱ chú̱ a̱huatá̱ nama̱skahui̱ko̱ya̱ hua̱nti̱ aya tantacú̱ scujma̱kó̱.’ ");
INSERT INTO tosNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Acxni̱ talacatzuhui̱ko̱lh yama̱ tasa̱cua̱ hua̱nti̱ xtzucuko̱ni̱t scujko̱y ma̱x pala ca̱makquitzis, pus la̱ntla̱ cha̱tunu̱ tzúculh maklhti̱nanko̱y akatunu denario tumi̱n hua̱ntu̱ xli̱ma̱skahui̱ma̱kó̱ tantacú̱ xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chi̱nchu̱ acxni̱ xaa̱huatiyá̱ tzúculh talacatzuhui̱ko̱y yama̱ tasa̱cua̱ hua̱nti̱ tzi̱saj tuncán xtzucuko̱ni̱t scujko̱y, xlacán tzúculh puhuanko̱y pi̱ ma̱x a̱tzinú̱ luhua lhu̱hua̱ nama̱xqui̱ko̱cán xtaskahucán, hua̱mpi̱ ni̱tú̱ ma̱li̱huaqui̱niko̱ca̱, huata na̱ chunatiya akatunu denario ma̱xqui̱ko̱ca̱ xtaskahucán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Acxni̱ chú̱ xlacán maklhti̱nanko̱lh, ucxilhko̱lh pi̱ chunatiyá, tzúculh li̱aklhu̱hua̱tnanko̱y xma̱la̱nacán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Chuná̱ huanko̱lh: ‘Hua̱ yuma̱ makapitzí̱n hua̱nti̱ a̱huatiyá̱ chinko̱lh, chu̱ caj xma̱n aktum hora scujko̱lh, ¿tú̱ chú̱ xpa̱lacata̱ na̱ chunatiyá̱ ma̱skahui̱pa̱kó̱ la̱ntla̱ quinca̱ma̱skahuí̱pa̱t ma̱squi quin tantacú̱ cmacalahu lhca̱cná, chu̱ chichiní?’ ");
INSERT INTO tosNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Yama̱ xma̱la̱nacán na̱má̱ kálhti̱lh cha̱tum xtasa̱cua̱ hua̱ntu̱ xliaklhu̱hua̱tnama̱: ‘Amigo, quit ni̱tú̱ cakskahuimaklhi̱má̱n mintaskahu. ¿Lá̱ntla̱ pi̱ nia̱lh lacapa̱staca̱ pi̱ huatiya aktum denario cta̱lacca̱xlani̱tán nacma̱skahui̱yá̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pus huata xatlá̱n caj cachipatá̱ mintumi̱n, chu̱ capittá̱ c-mínchic. Sa̱mpi̱ quit na̱ chuná̱ cma̱skahui̱putunko̱y hua̱nti̱ a̱huatiyá̱ chinko̱lh na̱ chuná̱ la̱ntla̱ huix cma̱skahui̱ni̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Pi̱ puhuana̱ huix pi̱ ni̱ lay cli̱tlahuay quintumi̱n hua̱ntu̱ quit tla̱n cpuhuán? Usu ¿pi̱ caj taskahuiniya̱ minta̱scujni̱ xpa̱lacata̱ pi̱ tla̱n ccatzi̱nini̱t?’ ");
INSERT INTO tosNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Quit lacatancs cca̱huaniyá̱n pi̱ chuná̱ naqui̱taxtuy c-xlacati̱n Dios, lhu̱hua̱ hua̱nti̱ la̱nchú̱ macapu̱lama̱kó̱, huata a̱li̱sta̱lh xlacán a̱huatiyá̱ macasta̱lama̱koj nahuán, hua̱mpi̱ na̱ chuná̱ lhu̱hua̱ hua̱nti̱ la̱nchú̱ a̱huatiyá̱ qui̱taxtuma̱kó̱ yama̱ quilhtamacú̱ huata xlacán luhua macapu̱lama̱koj nahuán.” ");
INSERT INTO tosNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Acxni̱ Jesús aya xtla̱huama̱ c-tiji, xama̱ c-Jerusalén, xlá̱ tánuj ta̱anko̱lh xli̱ma̱kalhtahuáka̱t tzinú̱ lakamákat, chu̱ na̱má̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Huixín catzi̱yá̱tit pi̱ ama̱hu c-Jerusalén; pus na̱ luhua cacatzí̱tit pi̱ antá̱ quit naquinchipacán, naquimacama̱sta̱cán c-xlacati̱ncan xanapuxcun pa̱lijni, xa̱hua̱ laktzokqui̱naní̱n, chuná̱ chú̱ nali̱tachihui̱nli̱ko̱y la̱ntla̱ naquimakni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A̱li̱sta̱lh chú̱ xlacán naquimacama̱sta̱palako̱y c-xlacati̱ncan chixcuhuí̱n hua̱nti̱ u̱nú̱ ma̱paksi̱nanko̱y hua̱nti̱ ni̱ judíos, huá̱ chú̱ xlacán naquili̱kama̱nanko̱y, naquihuili̱niko̱y, chu̱ hasta naquimpakaxtokohuacako̱y c-cruz laqui̱mpi̱ nacni̱y; hua̱mpi̱ ma̱squi chuná, caj xli̱aktutu quilhtamacú̱ quit naclakastakuanampalay ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Maktum xpusca̱t Zebedeo, chu̱ cha̱tuy xcamán talacatzuhui̱ko̱lh anta̱ni̱ xyá̱ Jesús. Yama̱ pusca̱t lakatatzokóstalh c-xlacatí̱n laqui̱mpi̱ nasquiniy aktum tlanca li̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús kalhasquínilh: —¿Tú̱ huix lacasquina̱ xactláhualh mimpa̱lacata? Xlá̱ na̱má̱ huánilh: —Catlahua̱ aktum tlanca li̱tlá̱n: acxni̱ huix natzucuya̱ ma̱paksi̱nana̱ la̱ntla̱ tlanca Rey, calacásquinti̱ pi̱ xtahui̱ cha̱tum quinkahuasa c-mimpakstácat, chi̱nchu̱ cha̱tum c-mimpakxuqui̱ laqui̱mpi̱ lacxtum nata̱ma̱paksi̱ko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huata Jesús na̱má̱ kálhti̱lh: —Ni̱ cha̱tum huixín catzi̱yá̱tit tu̱ squiná̱tit. Huixín lakkahuasán cca̱kalhasquiná̱n: ¿Pi̱ xli̱ca̱na̱ puhuaná̱tit pi̱ tla̱n nata̱yaniyá̱tit yama̱ c-tlanca tapa̱tí̱n hua̱ntu̱ quit nacpa̱ti̱y? Xlacán kalhti̱nanko̱lh: —Cpuhuana̱hu pi̱ ma̱x tla̱n nacta̱yaniya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús huanipalako̱lh: —Xli̱ca̱na̱ xlá̱ pi̱ tla̱n nata̱yaniyá̱tit huixín, sa̱mpi̱ huixín a̱li̱sta̱lh fuerza̱ antá̱ nati̱taxtuyá̱tit lhu̱hua tapa̱tí̱n xta̱chuná̱ la̱ntla̱ hua̱ntu̱ quit nacpa̱ti̱y; hua̱mpi̱ huá̱ chú̱ la̱ntla̱ huixín lacasquiná̱tit nacca̱ma̱xqui̱yá̱n milactahui̱lhcán c-quimpa̱xtú̱n antá̱ c-quimpu̱ma̱paksí̱n, pus quit lacatancs cca̱huaniyá̱n pi̱ ni̱ quilá̱ pala nacma̱sta̱y, huata xma̱n huá̱ lakchá̱n hua̱nti̱ lacsacko̱ni̱t Quintla̱t nama̱xqui̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Acxni̱ chú̱ hua̱ xa̱kalhaca̱hu xta̱li̱ma̱kalhtahuaka̱tcán kaxmatko̱lh hua̱ntu̱ xlacán csquima̱kó̱, pus si̱tzi̱niko̱lh yama̱ cha̱tuy li̱nata̱lán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hua̱mpi̱ Jesús tasaniko̱lh, chu̱ na̱má̱ huaniko̱lh: —Huixín catzi̱yá̱tit pi̱ hua̱nti̱ puxcu̱nanko̱y c-aktum ca̱chiquí̱n, xlacán antá̱ ma̱paksi̱nanko̱y xta̱chuna̱ lactlanca xpu̱chinacán li̱taxtuniko̱y hua̱ntu̱ antá̱ anán, chu̱ hua̱nti̱ lactlanca lactali̱pa̱hu ma̱paksi̱naní̱n xlacán luhua tlihuaka huili̱ko̱y xli̱ma̱paksi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Hua̱mpi̱ hua̱ntu̱ mimpa̱lacatacán ni̱ chuná̱ catiqui̱táxtulh, huata cati̱hua̱ huixín ti̱ tali̱pa̱hu mimpuxcucán li̱taxtuputún, xlacasquinca̱ pi̱ cama̱tlá̱ni̱lh nali̱taxtuy la̱ntla̱ ti̱ caj mintasa̱cuacán. ");
INSERT INTO tosNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Chu̱ hua̱nti̱ putzama̱ la̱ntla̱ calacatín naán c-milaksti̱pa̱ncán, huata caj cakálhi̱lh xtalacapa̱stacni cha̱tum ti̱ caj la̱ntla̱ milacscujnicán ca̱makta̱yaputuná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Sa̱mpi̱ quit Xatalacsacni Chixcú, na̱ chuná, ni̱ huá̱ cli̱mini̱t ca̱tuxá̱huat laqui̱mpi̱ caj la̱ntla̱ cha̱tum tlanca puxcu̱ naquiscujnanicán, huata huá̱ clakmini̱t laqui̱mpi̱ caj la̱ntla̱ cha̱tum xlacscujnicán nacmakta̱yako̱y a̱makapitzí̱n, chu̱ na̱ huá̱ cli̱mini̱t laqui̱mpi̱ nacmacama̱sta̱y quilatáma̱t laqui̱mpi̱ chuná̱ tla̱n nacli̱lakma̱xtuko̱y xlatama̱tcan lhu̱hua tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","La̱ntla̱ xtiji̱tla̱huama̱kó̱, luhua lhu̱hua tachixcuhuí̱tat csta̱lanima̱kó̱, chu̱ maktum la̱ntla̱ aya xti̱puntaxtuma̱kó̱ xaca̱chiqui̱n Jericó, ");
INSERT INTO tosNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","anta tuncán xuilakó̱ cha̱tuy lakatzi̱ní̱n c-xquilhpa̱n tiji. Acxni̱ yama̱ chixcuhuí̱n kaxmatko̱lh pi̱ hua̱ Jesús ti̱ xti̱taxtuma̱, xlacán tuncán tzúculh ca̱tasako̱y, na̱má̱ xuanko̱y: —Quimpu̱chinacán, xCam xamaka̱n rey David, luhua catlahua̱ li̱tlá̱n caquinca̱lakalhámanti. ");
INSERT INTO tosNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Makapitzí̱n tzúculh quilhni̱ko̱y laqui̱mpi̱ cakatxtakko̱lh. Hua̱mpi̱ xlacán ni̱ cui̱ntaj tlahuako̱lh hua̱ntu̱ xuanima̱ko̱ca̱, huata li̱huaca̱ palha̱ tzúculh quilhaniko̱y Jesús: —¡Quimpu̱chinacán, xCam xamaka̱n rey David, catlahua̱ li̱tlá̱n caquinca̱kalhi̱ni̱ talakalhamá̱n! ");
INSERT INTO tosNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús tachókolh, tasaniko̱lh yama̱ cha̱tuy lakatzí̱n, na̱má̱ kalhasquinko̱lh: —¿Tú̱ lacasquiná̱tit nactlahuay mimpa̱lacatacán? ");
INSERT INTO tosNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Xlacán kalhti̱nanko̱lh: —Quimpu̱chinacán, quin clacasquina̱hu pi̱ na̱ tla̱n xaclacahua̱nana̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús luhua xli̱ca̱na̱ lakalhamanko̱lh, chu̱ li̱lacaxamako̱lh xmacán xlakastapucán, acxnitiyá̱ chú̱ luhua tuncán tatlá̱ni̱lh xlakastapucán, chu̱ tla̱n lacahua̱nanko̱lh. A̱li̱sta̱lh chu̱ xlacán na̱ sta̱laniko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Acxni̱ chú̱ xtalacatzuhui̱ma̱kó̱ c-xaca̱chiqui̱n Jerusalén, pu̱lh antá̱ cha̱nko̱lh c-aktum ka̱stí̱n hua̱ntu̱ huanicán Monte de los Olivos, calacatín xuilakó̱ aktuy lactzu̱ ca̱chiquí̱n huaniko̱cán Betfagé, chu̱ Betania, yuma̱ xta̱pakstokuilakó̱ Jerusalén. Acxni̱ antá̱ xuilako̱chá̱ Jesús ma̱lakacha̱ko̱lh cha̱tuy xli̱ma̱kalhtahuáka̱t, ");
INSERT INTO tosNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","chu̱ na̱má̱ huaniko̱lh: —Huixín capimpítit tamá̱ c-actzu̱ ca̱chiquí̱n hua̱ntu̱ calacatín huí̱, chu̱ anta tuncán nama̱noklhuyá̱tit pi̱ chi̱ya̱huacani̱t tantum xatzi a̱xnu̱ c-xtanquilhti̱n chiqui, chu̱ na̱ antá̱ chú̱ ta̱láyaj nahuán cskata yama̱ a̱xnu̱. Huixín lacapala̱ naxcutá̱tit naquili̱taniyá̱tit antá̱ u̱nú. ");
INSERT INTO tosNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hua̱ palapi̱ huí̱ ti̱ naca̱huaniyá̱n: “¿Tú̱ li̱layá̱tit xcutá̱tit?”, huixín cahuanítit pi̱ mimpu̱chinacán maclacasquimputún, hua̱mpi̱ lacapalaj tuncán napu̱spitnipalay. ");
INSERT INTO tosNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hua̱ yumá̱ chuná̱ tilí̱lalh xli̱pacs laqui̱mpi̱ chuná̱ pacs xli̱kantáxtulh hua̱ntu̱ titzóknu̱lh cha̱tum xamaka̱n xprofeta Dios c-xlibro̱ anta̱ni̱ na̱má̱ huan: ");
INSERT INTO tosNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Cahuanítit xli̱pacs hua̱nti̱ huilakó̱ c-xaca̱chiqui̱n Jerusalén: ‘Caucxílhtit hua̱ mireycán, sa̱mpi̱ huá̱ chú̱ ca̱lakmimá̱n, hua̱mpi̱ xli̱ca̱na̱ pi̱ ni̱ pala tzinú̱ xlá̱ tlanca̱ makcatzi̱cán, sa̱mpi̱ caj tantum a̱xnu̱ pu̱mima̱. Xli̱ca̱na̱ pi̱ huá̱ pu̱mima̱ tantum a̱xnu̱, cskata tantum xatzi cuca̱na a̱xnu̱.’” ");
INSERT INTO tosNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xli̱ma̱kalhtahuáka̱t anko̱lh, chu̱ chuná̱ xlacán tlahuako̱lh tu̱ xuaniko̱ni̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Caj li̱puntzú̱ li̱minko̱lh yama̱ xatzi a̱xnu̱, xa̱hua̱ cskata. Acxni̱ chú̱ li̱ka̱tlapaniko̱lh xtamaknucán, Jesús ka̱tahui̱. ");
INSERT INTO tosNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Luhua lhu̱hua̱ tachixcuhuí̱tat xminko̱ni̱t pa̱xtokko̱y, chu̱ makapitzí̱n hasta tzúculh tucxko̱y xpakani̱n quihui, chu̱ na̱ antá̱ xma̱mi̱ko̱y c-tiji. ");
INSERT INTO tosNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Xli̱pacs hua̱nti̱ xpu̱lati̱lhako̱y, xa̱huá̱ hua̱nti̱ csta̱lati̱lhako̱y, chuná̱ tzúculh ca̱tasako̱y: —¡Cama̱xqui̱hu ca̱cni̱ yuma̱ xCam xamaka̱n rey David! ¡Dios casiculana̱tláhualh yuma̱ cscujni̱ hua̱nti̱ quinca̱ma̱lakacha̱nini̱tán! ¡Cama̱tlanqui̱hu, cama̱xqui̱hu pa̱xcatcatzí̱nit Dios xpa̱lacata xtalakalhamá̱n! ");
INSERT INTO tosNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Acxni̱ Jesús tanu̱chá̱ c-Jerusalén, xli̱pacs ti̱ xuilakó̱ antá̱ tzúculh acchilij tama̱ko̱y, chu̱ tzucuko̱lh la̱kalhasquinko̱y: —¿Tí̱ hua̱ yuma̱ chixcú̱ mini̱t? ");
INSERT INTO tosNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Makapitzí̱n na̱má̱ xkalhti̱nanko̱y: —Hua̱ yumá̱ tlanca xprofeta Dios, huanicán Jesús xala c-Nazaret c-xtapaksi̱n Galilea. ");
INSERT INTO tosNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","A̱li̱sta̱lh chú̱ titánu̱lh Jesús c-tlanca xtemplo̱ Dios tu̱ antá̱ xyá̱, chu̱ acxni̱ xlá̱ úcxilhli̱ tu̱ ni̱tlá̱n xtlahuama̱ca̱, xlá̱ tzúculh pu̱tlakako̱y hua̱nti̱ antá̱ csta̱nama̱kó̱, chu̱ hua̱nti̱ xtama̱huama̱kó̱ antá̱ c-xpu̱lacni li̱pacán xla templo, chu̱ na̱ tima̱akpu̱spitniko̱lh xmesa̱cán hua̱nti̱ xlakpali̱nani̱n tumi̱n, chu̱ xlactahui̱lhcán hua̱nti̱ csta̱ma̱kó̱ tijtímpu̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Acxni̱ chuná̱ tlahuako̱lh huaniko̱lh: —C-xaSa̱ntujlani Li̱kalhtahuaka̱ tatzoktahuilani̱t pi̱ na̱má̱ huá̱ Dios: ‘Huá̱ quínchic luhua ma̱n huá̱ nali̱ma̱xtucán xpu̱tlahuacan oración, hua̱mpi̱ huata huixín aya li̱ma̱xtuni̱tántit xta̱chuná̱ la̱ntla̱ xpu̱tatze̱knican kalha̱naní̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na̱ antá̱ chú̱ c-tlanca templo tuncán tzúculh laktalacatzuhui̱ko̱y anta̱ni̱ xyá̱ Jesús makapitzi̱n lakatzi̱ní̱n, chu̱ ti̱ ni̱ lay xta̱yako̱y laqui̱mpi̱ nama̱pacsako̱y, chu̱ xlá̱ pacs ma̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huá̱ chú̱ yuma̱ xtascújut hua̱ntu̱ tláhualh Jesús, acxni̱ ucxilhko̱lh xanapuxcún pa̱lijni, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos, chu̱ na̱ chuná̱ chú̱ xkaxmatko̱y la̱ntla̱ lactzu̱ camán pixtlanca̱ xca̱tasama̱kó̱ c-templo, na̱má̱ xuanko̱y: “¡Cama̱xqui̱hu ca̱cni̱ hua̱ yuma̱ xCam xamaka̱n rey David hua̱nti̱ mini̱t!”, pus yama̱ xta̱la̱tlahuanani̱n Jesús ni̱ pala tzinú̱ ma̱tla̱ni̱ko̱lh, chu̱ luhua li̱pe̱cua̱ la̱ntla̱ si̱tzi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Puschí̱ huaniko̱lh Jesús: —¿Lá̱ntla̱ pi̱ ni̱ kaxpátpa̱t hua̱ntu̱ yuma̱ lactzu̱ camán quilhuama̱kó̱? Jesús kalhti̱ko̱lh: —Hua̱mpi̱, ¿lá̱ntla̱ chú̱ ni̱ nackaxmata? ¡Pus ckaxmatma̱! Hua̱mpi̱ na̱ chuna li̱tum, la̱ntla̱ chí̱ huixín ¿pi̱ ni̱ a̱li̱kalhtahuakayá̱tit tu̱ tatzoktahuilani̱t xtachihui̱n Dios c-Li̱kalhtahuaka̱ anta̱ni̱ li̱chihui̱nán xpa̱lacata yumá̱ tu̱ qui̱taxtuma̱? Chuná̱ huan: ‘Huix chuná̱ ma̱xqui̱ko̱ni̱ta̱ talacapa̱stacni̱ hua̱nti̱ cajcu lactzu̱ camán, xa̱huá̱ hua̱nti̱ hasta tziqui̱ko̱ycú̱, laqui̱mpi̱ xlacán tla̱n nali̱tli̱niko̱yá̱n li̱lakati̱t tatlí̱n hua̱ntu̱ nali̱ma̱xqui̱ko̱yá̱n ca̱cni.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Acxni̱ chuná̱ huaniko̱lh xlá̱ akxtakya̱huako̱lh, chu̱ antá̱ alh c-xaca̱chiqui̱n Betania laqui̱mpi̱ antá̱ nalaktuncuhuiya̱chá̱ yama̱ catzi̱sní. ");
INSERT INTO tosNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cha̱nchu̱ li̱cha̱li̱ tzi̱sa̱, acxni̱ Jesús xama̱pá̱ c-Jerusalén, xlá̱ tzúculh tzincsa. ");
INSERT INTO tosNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lacatzú̱ c-tiji̱ úcxilhli̱ pi̱ xya̱chá̱ pu̱kalhtum xaquihui higo. Laktalacatzúhui̱lh, ni̱tú̱ tá̱ksnilh xtahuácat, huata caj xma̱n hua̱ xatuhuá̱n ka̱tum xta̱ya̱. Jesús xakátli̱lh, na̱má̱ huánilh: —¡Quit clacasquín pi̱ nia̱lh pala maktum catitahuácalh mintahuácat! Acxni̱ na̱má̱ huaniko̱lh, yuma̱ quihui̱ tuncán tzúculh sca̱ca. ");
INSERT INTO tosNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Acxni̱ xli̱ma̱kalhtahuáka̱t ucxilhko̱lh hua̱ntu̱ xlá̱ tláhualh luhua cacs li̱lacahuanko̱lh, chu̱ na̱má̱ kalhasquinko̱lh Jesús: —Ma̱kalhtahuaka̱ná, ¿lá̱ntla̱ tlahua̱ yumá̱ sa̱mpi̱ tuncán sca̱cli̱ xaquihui higo hua̱ntu̱ xakatli? ");
INSERT INTO tosNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús kalhti̱ko̱lh: —Quit xli̱ca̱na̱ lacatancs cca̱huaniyá̱n pi̱ lapi̱ huixín xli̱ca̱na̱ luhua xli̱pa̱huántit Dios, chu̱ ni̱ xmacpuhuántit, pus ni̱ caj xma̱n huá̱ xtlahuátit hua̱ntu̱ quit ctlahuaninit xaquihui higo, huata hasta na̱ tla̱n xuanítit yama̱ ka̱stí̱n: ‘Catapa̱nu̱ antá̱ lantla̱ huila, chu̱ antá̱ capit tahuilaya̱ c-ta̱kaya̱huaná’, luhua xli̱ca̱na̱ pi̱ chuná̱ xqui̱táxtulh. ");
INSERT INTO tosNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na̱ xli̱pacs hua̱ntu̱ nasquiniyá̱tit naca̱tlahuaniyá̱n Dios acxni̱ natlahuayá̱tit mioracioncán, luhua lacatancs cca̱huaniyá̱n lapi̱ li̱pa̱huaná̱tit, chu̱ catzi̱yá̱tit pi̱ xlá̱ naca̱ma̱xqui̱yá̱n, xli̱ca̱na̱ chuná̱ naca̱qui̱taxtuniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","A̱li̱sta̱lh Jesús tanu̱palachá̱ c-tlanca xtemplo̱ Dios tu̱ xuí̱ c-Jerusalén, chu̱ tzucuko̱lh ma̱kalhtahuaka̱ko̱y ti̱ antá̱ xtamakstokko̱ni̱t. Hua̱mpi̱ caj li̱puntzú̱ lakchinko̱lh xanapuxcun pa̱lijni, xa̱hua̱ lakko̱lutzi̱n judíos hua̱nti̱ xpuxcu̱naniko̱y, xlacán na̱má̱ kalhasquinko̱lh: —¿Tí̱ ma̱xqui̱ni̱tán li̱tlihuaka̱ natlahuaya̱ la̱ntla̱ tu̱ huix lacasquina? Hua̱ntu̱ huix tlahua̱ u̱nú̱ c-templo acxni̱ pu̱tlakaxtukó̱ sta̱naní̱n, ¿tí̱ ma̱xqui̱ni̱tán li̱ma̱paksí̱n chuná̱ natlahuaya? ");
INSERT INTO tosNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús na̱má̱ kalhti̱ko̱lh: —Quit na̱ u̱ckalhi̱y aktum tachihuí̱n hua̱ntu̱ cca̱kalhasquimputuná̱n. Pus lapi̱ huixín tancs naquinkalhti̱yá̱tit hua̱ntu̱ nacca̱kalhasquiná̱n, na̱ chuná̱ chú̱ quit nacca̱huaniyá̱n xatí̱ quima̱xqui̱ni̱t li̱ma̱paksí̱n caj xpa̱lacata hua̱ntu̱ ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pus caquihuanítit, ¿tí̱ li̱ma̱páksi̱lh Juan Bautista pi̱ naakmunuko̱y tachixcuhuí̱tat? ¿Pi̱ hua̱ Dios, usu hua̱ chixcuhuí̱n? Xlacán ni̱ naj tuncán kalhti̱nanko̱lh, huata caj xacstucán tzúculh la̱huaniko̱y: “Lapi̱ nahuaniya̱hu pi̱ hua̱ Dios tili̱ma̱páksi̱lh, pus huata xlá̱ naquinca̱huaniyá̱n: ‘¿Tú̱ xpa̱lacata chi̱nchu̱ ni̱ li̱ca̱najlanítit?’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chi̱ lapi̱ nahuaniya̱hu pi̱ hua̱ chixcuhuí̱n li̱ma̱paksi̱ko̱lh, ni̱tlá̱n caquintica̱qui̱taxtunín, sa̱mpi̱ xli̱pacs tachixcuhuí̱tat naquinca̱li̱si̱tzi̱niko̱yá̱n, sa̱mpi̱ ca̱najlako̱y pi̱ hua̱ Juan huá̱ xli̱chihui̱nama̱ xtachihui̱n Dios tu̱ ma̱n xma̱xqui̱ni̱t.” ");
INSERT INTO tosNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pus huata na̱má̱ huaniko̱lh Jesús: —Quin ni̱ ccatzi̱ya̱hu ti̱ li̱ma̱páksi̱lh Juan pi̱ naakmunu̱nán. Jesús na̱ chuná̱ huaniko̱lh: —Pus na̱ ni̱ pala quit cactica̱huanín ti̱ quima̱xqui̱ni̱t li̱ma̱paksí̱n hua̱ntu̱ xpa̱lacata cli̱tlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús na̱má̱ huanipalako̱lh yuma̱ xta̱la̱tlahuananí̱n: —Na̱ cakaxpatpalátit huixín yuma̱ aktum takalhchihuí̱n: Maktum xuí̱ cha̱tum chixcú, xlá̱ xuilakó̱ xlakkahuasán. Cha̱nchu̱ aktum quilhtamacú̱ na̱má̱ huánilh cha̱tum: ‘Ta̱ta̱, lacapala̱ capimpi scuja̱ c-quimpú̱cuxtu̱ anta̱ni̱ laccha̱tahuacama̱ uvas.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Yama̱ kahuasa kalhtí̱nalh: ‘Chú̱ ni̱ camputún scuja.’ Hua̱mpi̱ acxni̱ chu̱ a̱li̱sta̱lh lacapá̱stacli̱ pi̱ ni̱tlá̱n la̱ntla̱ kálhti̱lh xtla̱t, pus alh scuja. ");
INSERT INTO tosNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A̱li̱sta̱lh chú̱ yama̱ ko̱lutzí̱n huanipá̱ cha̱tum li̱tum xkahuasa̱ pi̱ na̱ caalh scuja. Yama̱ kahuasa kalhtí̱nalh: ‘Ni̱tú̱ capú̱huanti, quit xlá̱ nacán scuja.’ Hua̱mpi̱ ma̱squi na̱má̱ huá̱, huata xlá̱ ni̱ alh. ");
INSERT INTO tosNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Xatí̱ huixín puhuaná̱tit yuma̱ xli̱cha̱tuycan lakkahuasán tlahuako̱lh hua̱ntu̱ xlacasquín xtla̱tcán? Cha̱nchu̱ xlacán kalhti̱nanko̱lh: —Hua̱nti̱ xakasiya̱ huanica̱. Jesús huaniko̱lh: —Luhua xli̱ca̱na̱ na̱ chuná̱ qui̱taxtuma̱ c-milatama̱tcán, sa̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ huata hua̱nti̱ huixín ni̱tú̱ li̱ucxilhko̱yá̱tit, xta̱chuná̱ la̱ntla̱ yama̱ xpu̱qui̱nani̱n impuestos, chu̱ yumá̱ hua̱nti̱ caj xaaktzanka̱ta̱yani̱n lacchaján, huá̱ xakasiya̱ namakamaklhti̱nanko̱y Dios c-xasa̱sti xtapáksi̱t ni̱ xahua̱ huixín. ");
INSERT INTO tosNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa̱mpi̱ acxni̱ milh Juan Bautista laqui̱mpi̱ naca̱huaniyá̱n la̱ntla̱ Dios lacasquín nama̱aksti̱tupi̱yá̱tit milatama̱tcán, hua̱mpi̱ ma̱squi chuná̱ huixín ni̱ ca̱najlanítit xtachihuí̱n. Hua̱mpi̱ huá̱ chú̱ ti̱ kaxmatko̱lh xtachihuí̱n, chu̱ lakpali̱ko̱lh xalacli̱xcajnit xlatama̱tcán, pus hua̱ tama̱ xma̱ta̱ji̱naní̱n impuestos, xa̱huá̱ hua̱nti̱ aya xaktzanka̱ta̱yako̱ni̱t lacchaján. Ma̱squi huixín na̱ ucxílhtit la̱ntla̱ xlacán xli̱puhuama̱kó̱ xpa̱lacata xtala̱kalhi̱ncán, chu̱ xlakpali̱ma̱kó̱ xlatama̱tcán, huixín ni̱ pala tzinú̱ talakaspitta̱yátit laqui̱mpi̱ na̱ naca̱najlaniyá̱tit Juan. ");
INSERT INTO tosNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Na̱ cakaxpáttit yuma̱ aktum li̱tum takalhchihuí̱n: Xuí̱ cha̱tum chixcú, xpu̱chiná̱ aktum tlanca pú̱cuxtu, chálh c-xpu̱chaná̱n lhu̱hua xali̱chanat uvas. Na̱ tistilipacánu̱lh. Antá̱ lacatzú̱ tipu̱huaxácnu̱lh xpu̱chitni̱ hua̱ntu̱ napu̱lakchita̱ xuvas acxni̱ nacha̱y, chu̱ a̱li̱sta̱lh tima̱púlhulh aktum tlanca xpu̱lacahua̱n xla pá̱tzaps laqui̱mpi̱ antá̱ tla̱n namaktakalhcán xli̱tlanca̱ xtachaná̱n. Acxni̱ chú̱ li̱huana̱ li̱scujko̱lh, xlá̱ ma̱sa̱cuani̱ko̱lh makapitzi̱n scujní̱n laqui̱mpi̱ huá̱ chú̱ nali̱scujko̱y yama̱ tlanca xtachaná̱n, sa̱mpi̱ xlá̱ alh mákat a̱lacatanu̱ ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cha̱nchu̱ acxni̱ lákcha̱lh quilhtamacú̱ la̱ntla̱ tzúculh cha̱y xuvas, yama̱ xpu̱china pú̱cuxtu̱ ma̱lakacha̱ko̱lh makapitzi̱n scujní̱n laqui̱mpi̱ naanko̱y tiyako̱y xatachitni uvas hua̱ntu̱ xlakchá̱n sa̱mpi̱ chuná̱ xta̱lacca̱xlako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Hua̱mpi̱ huá̱ chú̱ yuma̱ scujní̱n hua̱nti̱ xpu̱scujma̱kó̱ xpú̱cuxtu, chipako̱lh, makapitzí̱n tla̱n ma̱sipa̱ni̱ko̱lh, chi̱nchu̱ a̱makapitzí̱n makni̱ko̱lh, chu̱ a̱makapitzí̱n tla̱n li̱actalako̱lh chíhuix. ");
INSERT INTO tosNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hua̱nti̱ xpu̱china yama̱ tachaná̱n xlá̱ ma̱lakacha̱palako̱lh tlak lhu̱hua̱ cscujní̱n, hua̱mpi̱ hua̱ yuma̱ ni̱tla̱n maktakalhnaní̱n, na̱ chuná̱ tlahuako̱chá̱ xta̱chuná̱ la̱ntla̱ xtlahuako̱cani̱t a̱makapitzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Huata xatlá̱n chú̱ ma̱n ma̱lakácha̱lh xkahuasa, sa̱mpi̱ xlá̱ chuná̱ xpuhuán: ‘Lapi̱ hua̱ quinkahuasa̱ nacmacá̱n, ma̱x fuerza̱ nalacapuhuaniko̱y, chu̱ nakalhakaxmatko̱y hua̱ntu̱ nahuaniko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Hua̱mpi̱ acxni̱ yuma̱ maktakalhnaní̱n ucxilhko̱lh pi̱ hua̱ xkahuasa xpu̱china pú̱cuxtu̱ xlacán chuná̱ tzúculh la̱huaniko̱y: ‘Li̱huana̱ catzi̱ya̱hu pi̱ hua̱ yuma̱ kahuasa hua̱nti̱ nachipay pu̱tum yuma̱ hua̱ntu̱ quin li̱scujma̱hu, huata xatlá̱n camakni̱hu laqui̱mpi̱ quin nakalhi̱ya̱hu hua̱ntu̱ xli̱chípat.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pus tuncán chipako̱lh, mákat c-xquilhapa̱n pú̱cuxtu̱ tamacaxtuko̱lh chu̱ antá̱ makni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Chi̱nchu̱ acxni̱ namín xpu̱china pú̱cuxtu, ¿tú̱ huixín puhuaná̱tit natlahuaniko̱y yuma̱ maktakalhnaní̱n hua̱nti̱ ni̱tla̱n xtapuhua̱ncán?” ");
INSERT INTO tosNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Pus yuma̱ xanapuxcun pa̱lijni, xa̱hua̱ lakko̱lutzí̱n hua̱nti̱ cxakatli̱ma̱ko̱ca̱ kalhti̱ko̱lh: —Pus quin cpuhuana̱hu pi̱ ni̱ catilakalhamanko̱lh, chu̱ namakni̱ko̱y yuma̱ chixcuhuí̱n hua̱nti̱ ni̱tla̱n xtapuhua̱ncan, chu̱ tanu̱ hua̱nti̱ nama̱sa̱cuani̱ko̱y nama̱maktakalhni̱ko̱y xtachana̱n xla uvas laqui̱mpi̱ acxni̱ xquilhtamacú̱ naqui̱lay xatahuácat nama̱xqui̱ko̱y hua̱ntu̱ lakchá̱n xpu̱china pú̱cuxtu. ");
INSERT INTO tosNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús na̱má̱ huanipalako̱lh: —Huixín ma̱x aya li̱kalhtahuakani̱tántit hua̱ntu̱ tatzoktahuilani̱t c-xtachihuí̱n Dios lacatum anta̱ni̱ na̱má̱ huan: ‘Yuma̱ chíhuix hua̱ntu̱ lakmakanko̱lh xya̱huanani̱n chiqui̱ sa̱mpi̱ xpuhuanko̱y pi̱ ni̱tú̱ xlakasi, a̱li̱sta̱lh milh li̱taxtuy yuma̱ tali̱pa̱hu xapuxcu chíhuix xala c-xcha̱stú̱n anta̱ni̱ li̱tzinca̱snanko̱ni̱t chiqui. Hua̱mpi̱ huá̱ Quimpu̱chinacán hua̱nti̱ laclhca̱ni̱t pi̱ chuná̱ naqui̱taxtuy, laqui̱mpi̱ quin caj cacs nali̱lacahuana̱hu hua̱ntu̱ tlahuani̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Cca̱li̱huaniyá̱n pi̱ pacs naca̱maklhti̱caná̱tit hua̱ntu̱ Dios ma̱lacnu̱ni̱t naca̱ma̱xqui̱yá̱n antá̱ c-xasa̱sti xtapáksi̱t hua̱ntu̱ ma̱quilhtzuqui̱ma̱ laqui̱mpi̱ huá̱ chú̱ nama̱xqui̱ko̱cán hua̱nti̱ namacama̱sta̱ko̱y c-xlacati̱n Dios hua̱ntu̱ aksti̱tum li̱scujko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Huá̱ chú̱ xpa̱lacata yuma̱ chíhuix tu̱ xacli̱chihui̱nama̱, pus cca̱huanipalayá̱n pi̱ lapi̱ cha̱tum natamakuasa, natahuacaya̱chá̱ c-xokspún, lactzu̱ lactzú̱ nalay nani̱y, chi̱nchu̱ lapi̱ huata hua̱ chíhuix xatí̱ naactahuilaya̱chi, luhua xli̱ca̱na̱ pi̱ nalakchitami̱y, chu̱ xta̱chuná̱ la̱ntla̱ pokxni̱ natlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Acxni̱ kaxmatko̱lh yuma̱ takalhchihuí̱n hua̱ntu̱ Jesús xli̱chihui̱nama̱, yuma̱ xanapuxcun pa̱lijni, xa̱hua̱ fariseos catzi̱ko̱lh pi̱ caj xpa̱lacatacán ma̱squi chuná̱ xlá̱ xli̱chihui̱nani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xlacán xchipaputunko̱y Jesús laqui̱mpi̱ nachi̱le̱nko̱y hua̱mpi̱ ni̱ fuerza̱ tlahuaniko̱lh sa̱mpi̱ xpe̱cuaniko̱y la̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat, sa̱mpi̱ luhua lhu̱hua̱ hua̱nti̱ xca̱najlaniko̱y pi̱ xli̱ca̱na̱ Jesús huá̱ xli̱chihui̱nama̱ xtachihui̱n Dios c-xtakalhchihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A̱li̱sta̱lh Jesús tzucupaj li̱ta̱kalhchihui̱nanko̱y tanuj takalhchihuí̱n, chu̱ chuna̱ na̱má̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hua̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱lacatzuqui̱ma̱, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ cha̱tum Rey hua̱nti̱ tláhualh aktum tapa̱xuhuá̱n sa̱mpi̱ xma̱pu̱chuhuama̱ xkahuasa. ");
INSERT INTO tosNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Xlá̱ ma̱lakacha̱ko̱lh cscujní̱n laqui̱mpi̱ naanko̱y huaniko̱y hua̱nti̱ ma̱catzi̱ni̱ko̱cani̱t pi̱ caminko̱lhá̱ c-pu̱tapu̱chuhu sa̱mpi̱ aya natapu̱chuhuay xkahuasa. Hua̱mpi̱ huata hua̱ yuma̱ chixcuhuí̱n hua̱nti̱ xma̱ca̱tzi̱ni̱ko̱cani̱t nata̱makpa̱xuhuako̱y, ni̱ mimputunko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ma̱lakacha̱palako̱lh a̱maktum a̱makapitzi̱n cscujní̱n laqui̱mpi̱ na̱má̱ nahuaniko̱cán: ‘Cahuanikó̱tit yuma̱ quintama̱ca̱tzi̱ní̱n pi̱ catlahuako̱lh li̱tlá̱n lacapala̱ caminko̱lhá̱ c-taca̱tani, sa̱mpi̱ pacsá xalanitá̱ huí̱. Quit aya cmakni̱ko̱ni̱t quintoro̱, chu̱ xalakkon quintakalhí̱n, xa̱huá̱ aya ca̱xtlahuacani̱t xalacuan lí̱huat.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Hua̱mpi̱ ma̱squi na̱má̱ huaniko̱ca̱, yuma̱ hua̱nti̱ xma̱catzi̱ni̱ko̱cani̱t ni̱ lakachixcuhui̱nanko̱lh, chu̱ ni̱ anko̱lh cpu̱tapu̱chuhu. Cha̱tum alh scuja̱ c-xpú̱cuxtu, cha̱nchu̱ hua̱ a̱cha̱tum pala tú̱ xlacca̱xtlahuama̱. ");
INSERT INTO tosNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Cha̱nchu̱ hua̱ a̱makapitzí̱n, caj li̱si̱tzi̱ko̱lh la̱ntla̱ xlakalatla̱huanko̱cán, huata chipako̱lh yuma̱ xlacscujni̱n Rey, tla̱n huili̱niko̱lh, makapitzí̱n hasta makni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Acxni̱ yama̱ Rey cátzi̱lh hua̱ntu̱ xtlahuaniko̱cani̱t xlacscujní̱n, xlá̱ luhua li̱pe̱cua̱ la̱ntla̱ sí̱tzi̱lh. Li̱ma̱paksi̱ko̱lh makapitzí̱n xtropa̱ pi̱ cama̱laksputuko̱lh yuma̱ makni̱naní̱n, chu̱ na̱ calhcuyuniko̱ca̱ xca̱chiqui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A̱li̱sta̱lh huaniko̱lh makapitzi̱n xlacscujní̱n: ‘Chú̱ luhua xaaccha̱ná̱ huilahu laqui̱mpi̱ natapu̱chuhuay quinkahuasa, chu̱ naca̱taniya̱hu; hua̱mpi̱ hua̱ yumá̱ hua̱nti̱ quit xaclacasquín naquilakminko̱y nia̱lh mini̱niko̱y naminko̱y sa̱mpi̱ caj xpa̱lacata, xali̱xcajnit xtapuhua̱ncán li̱laktzanka̱ta̱yako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pus huá̱ chú̱ tu̱ catlahuátit, capítit ca̱tlanca̱tí̱n, cama̱akpuhuanti̱kó̱tit xli̱pacs hua̱nti̱ nata̱tanoklhko̱yá̱tit, cahuanikó̱tit naminko̱y c-taca̱tani̱ laqui̱mpi̱ namakua̱yanko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yama̱ lacscujní̱n anko̱lh ca̱tlanca̱tí̱n, chu̱ pu̱tum ma̱stokko̱lh cati̱hua̱ ti̱ ma̱noklhuko̱lh, pacs xa̱huá̱ ti̱ akstitum, chu̱ hua̱nti̱ xaktzanká̱n xlama̱kó̱. Puschí̱ acxni̱ yuma̱ xli̱pacscán tanu̱ko̱lh anta̱ni̱ xca̱tanima̱ca̱ li̱tatzamako̱lh chiqui. ");
INSERT INTO tosNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Acxni̱ yuma̱ Rey tánu̱lh, alh ucxilhko̱y tama̱ca̱xní̱n hua̱nti̱ xminko̱ni̱t c-taca̱tani, hua̱mpi̱ xlá̱ ni̱ pala tzinú̱ ma̱tlá̱ni̱lh acxni̱ úcxilhli̱ cha̱tum chixcú̱ pi̱ ni̱tú̱ xlhaka̱ni̱t yuma̱ xatla̱n lháka̱t hua̱ntu̱ ma̱xqui̱ko̱ca̱ acxni̱ tanu̱ko̱lh c-pu̱tapu̱chuhu. ");
INSERT INTO tosNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Puschí̱ huánilh: ‘Amigo, ¿Lá̱ntla̱ tanu̱ u̱nú, na̱ ni̱ chuná̱ lhaka̱nani̱ta̱ hua̱ la̱ntla̱ talacasquín c-pu̱tapu̱chuhu?’ Hua̱mpi̱ yama̱ chixcú̱ ni̱ cátzi̱lh la̱ntla̱ nakalhti̱nán, chu̱ cacs lacahua̱. ");
INSERT INTO tosNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Puschí̱ huaniko̱lh Rey hua̱nti̱ xmacascujní̱n: ‘Cachipátit, na̱ catantu̱chí̱tit, chu̱ capakachí̱tit. Na̱ antá̱ quilhtí̱n ca̱paklhtu̱tá̱ catamacaxtútit laqui̱mpi̱ antacú̱ natasay, chu̱ nala̱li̱xcay xtatzán caj xpa̱lacata̱ pi̱ napa̱ti̱nán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sa̱mpi̱ lhu̱hua̱ hua̱nti̱ Dios tasaniko̱ni̱t natanu̱ko̱y c-xasa̱sti xtapáksi̱t, hua̱mpi̱ caj lacsacko̱y natanu̱ko̱y hua̱nti̱ xli̱ca̱na̱ ma̱tla̱ni̱ko̱y xtama̱lacnú̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A̱li̱sta̱lh yuma̱ fariseos macxtum tili̱chihui̱nanko̱lh pi̱ nakalhasquinko̱y Jesús aktum tachihuí̱n laqui̱mpi̱ nali̱putza̱naniko̱y, pala chú̱ huij nahuán hua̱ntu̱ nali̱sta̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pus hua̱ntu̱ tlahuako̱lh, ma̱lakacha̱ko̱lh makapitzí̱n hua̱nti̱ xli̱ma̱kalhtahuáka̱t, chu̱ makapitzí̱n hua̱nti̱ xta̱ta̱yako̱y rey Herodes. Acxni̱ xlacán lakcha̱nko̱lh na̱má̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, quin ccatzi̱ya̱hu pi̱ huix xli̱ca̱na̱ li̱chihui̱nana̱ hua̱ntu̱ talulóktat, chu̱ ma̱siyuya̱ la̱ntla̱ Dios lacasquín nalatama̱ko̱y xlakskatá̱n u̱nú̱ ca̱tuxá̱huat, xa̱huá̱ huix ni̱tí̱ li̱quilhpuhuana, chu̱ huaniya̱ hua̱ntu̱ ni̱tlá̱n tlahuama̱, chu̱ ni̱ pe̱cuaniko̱ya̱ ma̱squi calaksí̱tzi̱lh, sa̱mpi̱ huix ni̱tí̱ tlanca̱ c-milacatí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pus clacasquina̱hu pi̱ xquinca̱huani: ¿Pi̱ mini̱niy la̱ntla̱ cmakxoko̱nama̱hu yuma̱ xapuxcu gobierno xala c-Roma, usu ni̱ mini̱niy? ");
INSERT INTO tosNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Hua̱mpi̱ Jesús cátzi̱lh la̱ntla̱ ni̱tla̱n xta̱yatcán pi̱ caj chunata xli̱kalhasquima̱kó̱ laqui̱mpi̱ chuná̱ tla̱n nama̱makuasi̱ya̱huako̱y; huata xlá̱ na̱má̱ huaniko̱lh: —¡Lakapu̱tiyu̱naní̱n huixín! ¿Tú̱ xpa̱lacata caj chunatá̱ quinkalhputzayá̱tit hua̱ntu̱ tla̱n naquili̱ma̱makuasi̱ya̱huayá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aver, caquima̱siyunítit yama̱ okxtum tumi̱n xla plata̱ hua̱ntu̱ ca̱ma̱ta̱ji̱caná̱tit xpa̱lacata impuestos. Acxni̱ chú̱ ma̱xqui̱ko̱lh yuma̱ okxtum tumi̱n xla plata̱ hua̱ntu̱ xuanicán denario, ");
INSERT INTO tosNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús na̱má̱ kalhasquinko̱lh: —¿Tí̱ xlacapú̱n yumá̱? Chu̱ ¿tí̱ xtucuhuiní̱ talhca̱tahuilani̱t? ");
INSERT INTO tosNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Hua̱ tamá̱ xlacapú̱n tlanca ma̱paksi̱na gobierno —kalhti̱nanko̱lh xlacán. Jesús huaniko̱lh: —Pus huata huá̱ camacama̱xquí̱tit hua̱ntu̱ xlá̱ ma̱paksi̱y gobierno sa̱mpi̱ huá̱ lakchá̱n, chu̱ hua̱ntu̱ tapaksiniy Dios huá̱ camacama̱xquí̱tit sa̱mpi̱ huá̱ lakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Acxni̱ xlacán kaxmatko̱lh hua̱ntu̱ huaniko̱ca̱, cacs lacahuanko̱lh, chu̱ nia̱lh catzi̱ko̱lh la̱ntla̱ tu̱ nahuaniko̱y Jesús, huata xatlá̱n caj makaxtakko̱lh, chu̱ anko̱lhá. ");
INSERT INTO tosNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na̱ acxni̱ yuma̱ quilhtamacú̱ makapitzi̱n chixcuhuí̱n xuaniko̱cán laktzokqui̱naní̱n lakanko̱lh anta̱ni̱ xuilachá̱ Jesús laqui̱mpi̱ nata̱chihui̱nanko̱y, sa̱mpi̱ hua̱ yuma̱ chixcuhuí̱n xlacán xuanko̱y pi̱ ni̱ xli̱ca̱na̱ lakastakuananko̱y ni̱ní̱n ca̱li̱ní̱n. Pus huá̱ xpa̱lacata̱ na̱má̱ li̱huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ma̱kalhtahuaka̱ná, Moisés quinca̱makaxtaknini̱tán aktum li̱ma̱paksí̱n anta̱ni̱ huan pi̱ lapi̱ cha̱tum chixcú̱ nani̱y, chu̱ lapi̱ huí̱ xpusca̱t hua̱nti̱ tita̱tapu̱chúhualh, hua̱mpi̱ ni̱ kalhi̱ko̱lh xcamancán, pus lapi̱ huí̱ chú̱ xta̱la kahuasa yuma̱ chixcú, xlá̱ tla̱n nata̱tahuilay xya̱stá laqui̱mpi̱ chuná̱ huij nahuán xcaman yuma̱ xta̱lá̱ hua̱nti̱ aya ni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pus maktum u̱nú̱ c-quilaksti̱pa̱ncán xuilakó̱ kalhatujun li̱nata̱lán. Hua̱nti̱ xapuxcu̱ tapu̱chúhualh, hua̱mpi̱ ni̱ li̱maka̱s quilhtamacú̱ ni̱lh, chu̱ acstutahui̱ chú̱ pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hua̱mpi̱ hua̱ yuma̱ xli̱cha̱tuy kahuasa̱ hua̱nti̱ na̱ ta̱tahui̱ yuma̱ pusca̱t xlá̱ na̱ ni̱lh, chu̱ na̱ chuná̱ akspúlalh xli̱kalhatutu, chu̱ pu̱tum li̱takatzi̱ko̱lh xli̱kalhatujuncán pacs li̱nata̱lán, pero pacs ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cha̱nchu̱ acxni̱ xli̱pacs ni̱ko̱lh, pus ni̱ maka̱s quilhtamacú̱ na̱ tíni̱lh yuma̱ pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pus chú̱ caquinca̱huani, acxni̱ chú̱ nalakastakuananko̱y ni̱ní̱n ca̱li̱ní̱n, ¿xatí̱ luhua nata̱tapaksi̱y yuma̱ pusca̱t, sa̱mpi̱ xkalhatujuncán pacs tita̱tahuilako̱lh? ");
INSERT INTO tosNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús kalhti̱ko̱lh: —Xli̱ca̱na̱ pi̱ luhua mákat aktzanka̱yá̱tit, sa̱mpi̱ ni̱ catzi̱yá̱tit, chu̱ ni̱ akata̱ksá̱tit hua̱ntu̱ huaniputún xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka; na̱ ni̱ pala catzi̱yá̱tit la̱ntla̱ kalhi̱y xli̱tlihuaka̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Acxni̱ Dios nama̱lakastakuani̱ko̱y ni̱ní̱n ca̱li̱ní̱n, pacs chixcuhuí̱n xa̱hua̱ lacchaján nia̱lh catitapu̱chuhuako̱lh sa̱mpi̱ xta̱chuná̱ nali̱taxtuko̱y la̱ntla̱ ángeles hua̱nti̱ huilakó̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Xa̱hua̱ huixín luhua mákat aktzanka̱yá̱tit pala ni̱ ca̱najlayá̱tit pi̱ Dios ma̱lakastakuani̱ko̱y ni̱ní̱n ca̱li̱ní̱n sa̱mpi̱ ni̱ akata̱ksá̱tit hua̱ntu̱ huaniputún Li̱kalhtahuaka̱ lacatum anta̱ni̱ na̱má̱ huan Dios: ");
INSERT INTO tosNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Quit xDios Abraham, xDios Isaac, xa̱hua̱ xDios Jacob.’ Antá̱ huamputún pi̱ hua̱nti̱ lama̱kó̱ xastacná̱ ca̱tuxá̱huat, chu̱ hua̱nti̱ aya ni̱ko̱ni̱t lacxtum ta̱huanko̱y xta̱chuná̱ pala xastacnacú̱ lama̱kó̱, sa̱mpi̱ Dios ni̱ huá̱ xDioscan ni̱ní̱n huata hua̱nti̱ lama̱kó̱ xastacná. ");
INSERT INTO tosNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Acxni̱ Jesús chihui̱nanko̱lh, hua̱ yuma̱ li̱lhu̱hua̱ ti̱ xkaxmatma̱kó̱ luhua cacs lacahuanko̱lh caj xpa̱lacata xtakalhchihuí̱n hua̱ntu̱ xlá̱ xma̱siyuni̱t, luhua xli̱ca̱na̱ ca̱cni̱naniko̱lh la̱ntla̱ xkalhi̱y xli̱skalala. ");
INSERT INTO tosNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Acxni̱ yuma̱ fariseos catzi̱ko̱lh pi̱ xma̱katxtakako̱ni̱t Jesús laktzokqui̱naní̱n xlacán tamacxtumi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chu̱ macxtum lakanko̱lh Jesús. Cha̱tum xlacán ma̱kalhtahuaka̱ná xuani̱t hua̱nti̱ tla̱n xma̱siyuy hua̱ntu̱ xuamputún xli̱ma̱paksi̱n Moisés, xlá̱ xkalhputzaputún Jesús aktum tachihuí̱n laqui̱mpi̱ pala tú̱ ni̱tlá̱n nahuán chuná̱ chú̱ tla̱n nama̱lacapu̱ko̱y. Xlá̱ na̱má̱ kalhásquilh yuma̱ tachihuí̱n: ");
INSERT INTO tosNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ma̱kalhtahuaka̱ná, ¿xaní̱ huí̱ xli̱ma̱paksi̱n Dios hua̱ntu̱ tlak xlacasquinca̱ nama̱kantaxti̱ya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Cha̱nchu̱ Jesús huánilh: —Hua̱ntu̱ luhua tlak xlacasquinca̱ nama̱kantaxti̱yá̱tit xli̱ma̱paksi̱n Dios chuná̱ huan: ‘Capa̱xqui, chu̱ cali̱pá̱huanti̱ Mimpu̱china Dios xli̱pacs minacú̱ chu̱ xli̱pacs mili̱stacna, chu̱ xli̱pacs mintalacapa̱stacni.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hua̱ yumá̱ hua̱ntu̱ tlak xli̱ma̱kantaxti̱tcán pacs tachixcuhuí̱tat, chu̱ na̱ hua̱ntu̱ xali̱huacá̱ naca̱makta̱yayá̱n ni̱ xahua̱ a̱makapitzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chi̱nchu̱ huá̱ xli̱pu̱lactuy, a̱yuj xta̱chuná̱ huamputún, na̱má̱ huan: ‘Calakalhamankó̱ a̱makapitzí̱n xta̱chuná̱ la̱ntla̱ miacstu̱ lakalhamancana.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hua̱ntu̱ ma̱siyuy yuma̱ caj kampu̱tuy li̱ma̱paksí̱n antá̱ huí̱ xquilhtzúcut la̱ntla̱ xli̱pacs hua̱ntu̱ huamputún xli̱ma̱paksi̱n Moisés xa̱huá̱ hua̱ntu̱ xma̱siyuputuncán c-xlibrojcán xalakmaka̱n profetas. ");
INSERT INTO tosNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Xli̱makua antacú̱ xlaya̱kó̱ yuma̱ fariseos, ");
INSERT INTO tosNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús na̱má̱ kalhasquinko̱lh: —Huixín ma̱x catzi̱yá̱tit, xtlahuátit li̱tlá̱n xquinca̱huanítit, ¿xaní̱ luhua puhuaná̱tit namina̱chá̱ Cristo hua̱nti̱ naca̱lakma̱xtuyá̱n? ¿Xatí̱ xamaká̱n xquilhtzúcut nahuán? Xlacán kalhti̱nanko̱lh: —Quin ccatzi̱ya̱hu pi̱ acxni̱ xlá̱ nalacachín, huá̱ xCam xamaka̱n rey David nali̱taxtuy. ");
INSERT INTO tosNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Huata Jesús huanipalako̱lh: —Hua̱mpi̱ palapi̱ xli̱ca̱na̱ chuná̱ cahuá̱, pus ¿tú̱ xpa̱lacata acxni̱ rey David ma̱puhuá̱ni̱lh Espíritu Santo, xlá̱ na̱ má̱xqui̱lh ca̱cni̱ la̱ntla̱ li̱ma̱pa̱cúhui̱lh xpu̱chiná? Sa̱mpi̱ lacatum c-libro xla Salmos chuná̱ tzokli: ");
INSERT INTO tosNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Quimpu̱china Dios na̱má̱ huánilh cha̱tum li̱tum ti̱ na̱ Quimpu̱chiná: Catahuila̱ c-quimpa̱xtú̱n laqui̱mpi̱ naquinta̱ma̱paksi̱nana, hasta acxni̱ quit nacca̱makatlajako̱y pu̱tum hua̱nti̱ minta̱la̱tlahuananí̱n, laqui̱mpi̱ pacs nalakachixcuhui̱ko̱yá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Pus tú̱huan chuná̱ puhuaná̱tit pi̱ Cristo xquilhtzúcut nahuán xamaka̱n rey David, lapi̱ huatiya̱ David ca̱cni̱naniy, chu̱ li̱ma̱pa̱cuhui̱y Quimpu̱chiná? ");
INSERT INTO tosNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Acxni̱ na̱má̱ huaniko̱lh yuma̱ chixcuhuí̱n, ni̱ pala tzinú̱ catzi̱ko̱lh la̱ntla̱ nakalhti̱nanko̱y, la̱ntla̱ alh quilhtamacú̱ nia̱lh tí̱ pala xpuhua̱ tú̱ makcatzi nakalhasquín. ");
INSERT INTO tosNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","A̱li̱sta̱lh chú̱ Jesús tzúculh xakatli̱ko̱y xli̱ma̱kalhtahuáka̱t, xa̱hua̱ xli̱lhu̱hua̱ ti̱ antá̱ xya̱kó̱, na̱má̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Yama̱ laktzokqui̱naní̱n, xa̱hua̱ fariseos, hua̱ xlacán ma̱xqui̱ko̱cani̱t li̱ma̱paksí̱n nama̱lacatancsaniy tachixcuhuí̱tat hua̱ntu̱ huamputún xli̱ma̱paksi̱n Moisés. ");
INSERT INTO tosNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Cumu hua̱ xlacán mima̱kalhtahuaka̱nacán luhua xli̱ca̱na̱ pi̱ tla̱n nakaxpatniko̱yá̱tit tu̱ xlacán naca̱huaniyá̱n, chu̱ cama̱kantaxtí̱tit hua̱ntu̱ naca̱li̱ma̱paksi̱yá̱n, hua̱mpi̱ ni̱ chuná̱ huixín cakantí̱tit xta̱yatcán hua̱ntu̱ xlacán tlahuama̱kó̱. Sa̱mpi̱ tama̱ chixcuhuí̱n luhua tla̱n hua̱ntu̱ li̱chihui̱nanko̱y, hua̱mpi̱ caj a̱lakamákat, anta̱ni̱ caj xacstucán, tlahuama̱kó̱ hua̱ntu̱ ni̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xlacán huaniko̱y xta̱ca̱najlaní̱n pi̱ fuerza̱ cama̱kantaxti̱ko̱lh lactzu̱ lactzu̱ li̱ma̱paksí̱n hua̱ntu̱ xlacán na̱ ni̱ ma̱kantaxti̱ma̱kó̱ c-xlatama̱tcán. Yumá̱ tu̱ li̱ma̱paksi̱ko̱y catlahuako̱lh tachixcuhuí̱tat, xta̱chuná̱ li̱taxtuy la̱ntla̱ lactzinca tacuca̱ hua̱ntu̱ ma̱cuqui̱ko̱y a̱makapitzi̱n hasta ma̱squi nia̱lh lay le̱ncán. Hua̱mpi̱ hua̱ yuma̱ fariseos ni̱ pala tzinú̱ li̱toklhputunko̱y ca̱na̱ caj skantum actzu̱ xmacancán. ");
INSERT INTO tosNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Acxni̱ xlacán tlahuako̱y aktum li̱tla̱n tamakta̱y, huata luhua lakati̱ko̱y anko̱y anta̱ni̱ tzamacán laqui̱mpi̱ nali̱ucxilhko̱y a̱makapitzí̱n pi̱ xli̱ca̱na̱ lacuan chixcuhuí̱n. Xlacán lakati̱ko̱y slamahuacaniko̱cán c-xmu̱ncan, chu̱ c-xmacxpa̱ncan xlháka̱t lacti̱tzu̱ xu̱hua̱ anta̱ni̱ tatzokni̱t xtachihui̱n Dios, chu̱ na̱ chuna li̱tum luhua lakati̱ko̱y paktlanca̱ tlahuako̱y xquilhpa̱n xlhaka̱tcán laqui̱mpi̱ nali̱ucxilhcán pi̱ xli̱ca̱na̱ chuná̱ li̱ma̱xqui̱ma̱ ca̱cni̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Anta̱ni̱ pa̱scuajnama̱ca̱ xlacán lakati̱ko̱y hua̱ xacalacan lactáhui̱lh c-pu̱makca̱tani, chu̱ na̱ chuná̱ li̱catzi̱ko̱y acxni̱ anko̱y c-pu̱makca̱tani, lacasquinko̱y pi̱ hua̱ntu̱ xacalacan lactáhui̱lh nama̱xqui̱cán sa̱mpi̱ luhua lactalí̱pa̱hu, chu̱ lakskalalan chixcuhuí̱n makcatzi̱ko̱cán, ");
INSERT INTO tosNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","chu̱ luhua lacasquinko̱y pi̱ nama̱xqui̱ko̱cán ca̱cni̱ acxni̱ naxakatli̱pa̱xtokko̱cán c-tiji, chu̱ lakati̱ko̱y nali̱ma̱pa̱cuhui̱ko̱cán lactlanca ma̱kalhtahuaka̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Hua̱mpi̱ huata hua̱ huixín, niucxni̱ tiputzayá̱tit pi̱ chuná̱ nali̱ca̱cni̱nanicaná̱tit la̱ntla̱ naca̱li̱ma̱pa̱cuhui̱caná̱tit lactlanca ma̱kalhtahuaka̱naní̱n, huá̱ chuná̱ cca̱li̱huaniyá̱n sa̱mpi̱ huixín caj li̱nata̱lán, chu̱ caj xma̱n cha̱tum kalhi̱yá̱tit ti̱ luhua mima̱kalhtahuaka̱nacán, huá̱ quit, Cristo. ");
INSERT INTO tosNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chu̱ na̱ chuna li̱tum ni̱ pala cha̱tum huixín ti̱ capútzalh pi̱ nali̱ma̱pa̱cuhui̱y tlanca mintla̱ticán sa̱mpi̱ caj xma̱n cha̱tum kalhi̱yá̱tit tlanca Mintla̱ticán, huachá̱ ti̱ huilachá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Na̱ ni̱ pala huá̱ tla̱n catlahuátit pi̱ cha̱tum huixín nahuanicán tlanca Mimpuxcucán, sa̱mpi̱ caj xma̱n cha̱tum kalhi̱yá̱tit hua̱nti̱ luhua Mimpuxcucán, caj xma̱n huá̱ quit, Cristo mima̱akapu̱taxti̱nacán. ");
INSERT INTO tosNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Hua̱nti̱ luhua putzaputún la̱ntla̱ xlakasi nali̱taxtuy c-milaksti̱pa̱ncán, pus huata huá̱ cama̱tlá̱ni̱lh xlacscujni nali̱taxtuniko̱y a̱makapitzi̱n xta̱ca̱najlaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Huá̱ chuná̱ cca̱li̱huanimá̱n sa̱mpi̱ hua̱nti̱ caj xacstu putzama̱ la̱ntla̱ xlakasi naacstuli̱ma̱xtucán, xalán ni̱ maka̱s tama̱ma̱xani̱y, chu̱ ma̱tu̱tzuhui̱cán; huata hua̱nti̱ ni̱tú̱ putzama̱ ma̱squi caj la̱ntla̱ ni̱tú̱ xlakasi li̱taxtuma̱, huata huá̱ chú̱ luhua kalhi̱y xca̱cni̱ li̱taxtuy a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“¡Hua̱mpi̱ koxutaní̱n la̱ntla̱ aktzanka̱ni̱tántit huixín laktzokqui̱naní̱n, chu̱ huixín fariseos, sa̱mpi̱ huixín luhua lakapu̱tiyu̱naní̱n! Li̱pe̱cua̱ tu̱ napa̱ti̱naná̱tit sa̱mpi̱ huixín ma̱lacchuhuaniko̱yá̱tit má̱laccha̱ hua̱nti̱ tanu̱putunko̱y c-xtapaksi̱t Dios. Huixín ni̱ tanu̱putuná̱tit, na̱ ni̱ pala makaxtakko̱yá̱tit pi̱ natanu̱ko̱ya̱chá̱ hua̱nti̱ xli̱ca̱na̱ tanu̱putunko̱y. Huixín tze̱k akskahuimaklhti̱ko̱yá̱tit xchiccán hua̱nti̱ ni̱makanko̱cani̱t lacchaján, chu̱ laqui̱mpi̱ ni̱ naca̱catzi̱nicaná̱tit minta̱yatcán luhua lacsuan tachihuí̱n li̱chihuinanta̱yayá̱tit acxni̱ tlahuayá̱tit oración. Pus huá̱ xpa̱lacata cca̱li̱huaniyá̱n pi̱ luhua tlanca kalhi̱yá̱tit mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Koxutaní̱n la̱ntla̱ aktzankani̱tántit huixín fariseos, chu̱ laktzokqui̱naní̱n, sa̱mpi̱ luhua xaaksani̱naní̱n! Xli̱ca̱na̱ pi̱ cani̱huá̱ piná̱tit lakatza̱lako̱yá̱tit lhu̱hua ca̱chiquí̱n, chu̱ tíyat hasta acxni̱ naqui̱ta̱ksá̱tit cha̱tum akmakat chixcú̱ hua̱nti̱ judío natlahuayá̱tit, hua̱mpi̱ acxni̱ tzucuyá̱tit makaca̱najlayá̱tit, chuná̱ la̱ntla̱ huixín ca̱najlayá̱tit, hasta tlak xatzanka̱n latáma̱t ma̱xqui̱yá̱tit hua̱ntu̱ nali̱chá̱n c-lhcúya̱t c-pu̱pa̱tí̱n ni̱ xahua̱ la̱ntla̱ tu̱ huixín kalhi̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Koxutaní̱n la̱ntla̱ aktzanka̱ni̱tántit huixín lakatzi̱ni̱n chixcuhuí̱n hua̱nti̱ pu̱lali̱pimpá̱tit a̱makapitzí̱n! Huixín huaná̱tit: ‘Acxni̱ pala ti̱ li̱ta̱yay hua̱ntu̱ nama̱kantaxti̱y, chu̱ lapi̱ caj huá̱ nali̱quilhán yama̱ tlanca xtemplo̱ Dios, ni̱tu̱ tlahuay tala̱kalhí̱n ma̱squi ni̱ cama̱kantáxti̱lh. Hua̱mpi̱ lapi̱ huá̱ nali̱quilhán oro hua̱ntu̱ tanu̱ma̱ c-templo, xli̱ca̱na̱ pi̱ luhua xli̱ma̱kantáxti̱t xtachihuí̱n hua̱ntu̱ nali̱ta̱yay sa̱mpi̱ natlahuay tala̱kalhí̱n lapi̱ ni̱ nama̱kantaxti̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Xli̱ca̱na̱ pi̱ huixín luhua xalactu̱ntusnu, chu̱ na̱ lakatzi̱ní̱n! Sa̱mpi̱ caj caquihuanítit: ¿tú̱ tlak luhua xlacasquinca? ¿Pi̱ huá̱ oro usu huá̱ xtemplo̱ Dios? Pus huixín mili̱catzi̱tcán pi̱ caj huá̱ xpa̱lacata templo ma̱squi chú̱ li̱tasiculuna̱tlahuani̱t oro. ");
INSERT INTO tosNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huixín na̱ chuná̱ huaná̱tit pi̱ lapi̱ cha̱tum ma̱lacnu̱y xpa̱lacata̱ tu̱ natlahuay, chu̱ lapi̱ huá̱ nali̱quilhán yuma̱ altar hua̱ntu̱ huí̱ c-xpu̱lacni templo, ni̱ tlahuay tala̱kalhí̱n ma̱squi ni̱ cama̱kantáxti̱lh hua̱ntu̱ xli̱ta̱yani̱t, hua̱mpi̱ lapi̱ huá̱ nali̱quilhán li̱ca̱xtlahuá̱n hua̱ntu̱ huí̱ c-xokspun altar luhua fuerza̱ xli̱ma̱kantáxti̱t hua̱ntu̱ nali̱ta̱yay, sa̱mpi̱ lapi̱ ni̱ nama̱kantaxti̱y aya tlahuani̱t tala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Luhua lakatzi̱ní̱n, chu̱ lactzaca̱tna̱ c-mintalacapa̱stacnicán huixín! Pus caj caquihuanítit, ¿tú̱ tlak kalhi̱y xlakasi̱ c-xlacati̱n Dios? ¿Pi̱ hua̱ li̱ca̱xtlahuá̱n, usu hua̱ altar anta̱ni̱ huili̱cán yuma̱ li̱ca̱xtlahuá̱n laqui̱mpi̱ chuná̱ nali̱tasiculuna̱tlahuay? ");
INSERT INTO tosNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Quit lacatancs cca̱huaniyá̱n pi̱ hua̱nti̱ ma̱lacnu̱y pala tú̱ nama̱kantaxti̱y, chu̱ huá̱ li̱quilhán yuma̱ altar hua̱ntu̱ huí̱ c-templo, ni̱ caj xma̱n huá̱ li̱quilhama̱ altar huata na̱ pacs li̱quilhama̱ la̱ntla̱ tu̱ huí̱ c-xokspun altar. ");
INSERT INTO tosNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na̱ chuna li̱tum hua̱nti̱ li̱ta̱yay pala tú̱ nama̱kantaxti̱y, chu̱ li̱quilhán yuma̱ tlanca xtemplo̱ Dios xala c-Jerusalén, fuerza̱ na̱ li̱quilhama̱ Dios sa̱mpi̱ xlá̱ ankalhí̱n antá̱ huí̱. ");
INSERT INTO tosNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chu̱ na̱ chuná̱ hua̱nti̱ ni̱ ma̱kantaxti̱y xtachihuí̱n, chu̱ li̱quilhán akapú̱n, tlak kalhi̱y tala̱kalhí̱n sa̱mpi̱ na̱ li̱quilhama̱ Dios sa̱mpi̱ xlá̱ antá̱ ma̱paksi̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Koxutaní̱n huixín laktzokqui̱naní̱n, chu̱ huixín fariseos, sa̱mpi̱ xli̱ca̱na̱ pi̱ luhua xaaksani̱naní̱n huixín! Huixín niucxni̱ ca̱lacatza̱layá̱n pi̱ ankalhí̱n ma̱xqui̱yá̱tit Dios la̱ntla̱ midiezmojcán actum hua̱ntu̱ acca̱hu yamá̱ tu̱ makalayá̱tit c-mimpu̱cuxtucán, ma̱pa̱pitziyá̱tit lactzu̱ lactzú̱ xta̱chuná̱ la̱ntla̱ milhkajnacán, chu̱ a̱makapitzí̱n lactzu̱ tuhuá̱n usu caca, hua̱mpi̱ huata pa̱tzanka̱yá̱tit, chu̱ ni̱ ma̱kantaxti̱pá̱tit yuma̱ xli̱ma̱paksi̱n Dios hua̱ntu̱ luhua tlak xlacasquinca̱ mili̱ma̱kantaxti̱tcán c-milatama̱tcán, huachá̱ pi̱ ni̱tí̱ nastokopitziyá̱tit la̱ntla̱ acxtum xla̱lakalhamántit, la̱ntla̱ ankalhí̱n tla̱n xla̱catzi̱nítit, la̱ntla̱ hua̱ntu̱ luhua xlí̱lat xla̱tlahuanítit, chu̱ la̱ntla̱ luhua aktuma talacapa̱stacni̱ xkalhí̱tit la̱ntla̱ nali̱pa̱huaná̱tit Dios. Quit ni̱tú̱ cca̱huanimá̱n pala nia̱lh cama̱stá̱tit lactzu̱ midiezmojcán hua̱ntu̱ ma̱sta̱yá̱tit, hua̱mpi̱ cca̱huaniputuná̱n pi̱ luhua xlacasquinca̱ pi̱ pu̱lh huá̱ nama̱kantaxti̱yá̱tit hua̱ntu̱ tlak xlacasquinca̱ xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Koxutaní̱n huixín sa̱mpi̱ la̱mpala lakatzí̱n li̱taxtuyá̱tit! Huixín huata lakapu̱xtu̱ tlahuayá̱tit acxni̱ xta̱chuná̱ pala luhua cui̱ntaj tlahuayá̱tit pi̱ ni̱ nata̱huayá̱tit tantum actzu̱ sima̱hua̱ yama̱ chúchut hua̱ntu̱ li̱kotnaná̱tit, chu̱ luhua li̱huana̱ lactziquiyá̱tit, hua̱mpi̱ ni̱ pala tzinú̱ catzi̱yá̱tit acxni̱ huayá̱tit tantum tlanca camello. ");
INSERT INTO tosNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Koxutaní̱n huixín laktzokqui̱naní̱n, chu̱ fariseos, sa̱mpi̱ luhua xaaksani̱naní̱n huixín. Huixín luhua li̱ta̱katzanka̱yá̱tit li̱huana̱ lakchaka̱pi̱yá̱tit caj xma̱n huá̱ xla c-xmacni mimpula̱tucán, chu̱ mivasocán hua̱ntu̱ pu̱hua̱yaná̱tit, chu̱ hua̱ntu̱ pu̱kotnaná̱tit, hua̱mpi̱ huata huá̱ c-mimpu̱lacnicán, antá̱ c-minacu̱cán luhua lhu̱hua̱ huí̱ hua̱ntu̱ ni̱tlá̱n, sa̱mpi̱ chuná̱ li̱ma̱akstokuili̱ni̱tántit la̱ntla̱ catu̱huá̱ hua̱ntu̱ kalhani̱tántit, chu̱ minta̱ksani̱ncán li̱akskahuinani̱tántit hua̱ntu̱ ni̱ milacán. ");
INSERT INTO tosNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lakatzi̱ní̱n huixín fariseos, tlak mini̱niy pu̱lana̱ c-xpu̱lacni, anta̱ni̱ ni̱ tasiyuy, cachaka̱nítit mimpu̱hua̱ycán, chu̱ acxni̱ chú̱ nalakchaka̱yá̱tit c-xmacni luhua xli̱ca̱na̱ xatachaká̱n nahuán. ");
INSERT INTO tosNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Koxutaní̱n huixín laktzokqui̱naní̱n, chu̱ fariseos, sa̱mpi̱ milatama̱tcán luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ yama̱ xpa̱tzaps ni̱ní̱n xatama̱tzasán hua̱ntu̱ huilakó̱ c-pu̱ta̱cnú̱n. Xli̱ca̱na̱ pi̱ luhua lakli̱lakáti̱t tasiyuy c-xmacnicán sa̱mpi̱ mani̱ko̱cani̱t, hua̱mpi̱ huá̱ chú̱ c-xpu̱lacni luhua lacli̱xcajnit xlaclucut ni̱n taju̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xli̱ca̱na̱ pi̱ chuná̱ huixín tasiyuyá̱tit c-xlacati̱ncan tachixcuhuí̱tat, caj la̱ntla̱ c-mimacnicán la̱mpala luhua lacuan chixcuhuí̱n tasiyuyá̱tit, chu̱ chuná̱ li̱taxtuyá̱tit hua̱mpi̱ huá̱ chú̱ c-minacu̱cán luhua li̱xcájnit xtá̱yat sa̱mpi̱ lhu̱hua̱ hua̱ntu̱ ni̱tla̱n talacapa̱stacni̱ kalhi̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Koxutaní̱n huixín laktzokqui̱naní̱n, chu̱ fariseos, sa̱mpi̱ luhua lakapu̱tiyu̱naní̱n huixín. Hua̱ yuma̱ xlacán xprofeta Dios, chu̱ aksti̱tum chixcuhuí̱n xuanko̱ni̱t, hua̱nti̱ timakni̱ko̱lh xalakmaka̱n minatla̱tnacán, huixín chú̱ ma̱pulhuyá̱tit, chu̱ stla̱n ca̱xtlahuaniko̱yá̱tit xalakli̱lakati̱t xpa̱tzapscán c-pu̱ta̱cnú̱n anta̱ni̱ acnu̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Acxni̱ chú̱ li̱kalhchihui̱naná̱tit huaná̱tit: ‘Huá̱ lapi̱ na̱ acxni̱ xactilatama̱hu yama̱ maka̱n quilhtamacú̱ acxni̱ xlama̱kó̱ xalakmaka̱n quinatla̱tnacán hua̱nti̱ timakni̱ko̱lh profetas, quin ni̱ xactimaktanu̱hu laqui̱mpi̱ nacmakni̱ko̱ya̱hu yama̱ profetas hua̱nti̱ makni̱ko̱ca̱.’ ");
INSERT INTO tosNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Acxni̱ chuná̱ huaná̱tit luhua ma̱n lacatancs li̱ta̱yayá̱tit pi̱ xli̱ca̱na̱ huixín huá̱ minquilhtzucutcán hua̱nti̱ timakni̱ko̱lh profetas hua̱nti̱ xlama̱kó̱ xamaka̱n quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pus luhua xli̱ca̱na̱ pi̱ hua̱ yama̱ xamaka̱n minatla̱tnacán xuanko̱ni̱t, pus tza̱pu̱ catlahuátit, cama̱ta̱sputútit xtala̱kalhi̱ncán hua̱ntu̱ xlacán tima̱quilhtzuqui̱ko̱lh maka̱n quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Huixín luhua xta̱chuná̱ li̱taxtuyá̱tit la̱ntla̱ yama̱ xalaclu̱cu̱ luhua hua̱ntu̱ tze̱k xcananko̱y. Pus caj tzinú̱ cakalhkalhí̱tit, ¿lá̱ntla̱ chú̱ nalayá̱tit puhuaná̱tit pi̱ tla̱n nalaktaxtuniyá̱tit yama̱ tlanca tapa̱tí̱n hua̱ntu̱ talacatzuhui̱ma̱ xala c-pu̱pa̱tí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pus cumu huixín ni̱ luhua ca̱najlayá̱tit hua̱ntu̱ cca̱huanimá̱n, pus nacca̱ma̱lakacha̱naniyá̱n lhu̱hua̱ profetas, xa̱hua̱ lakskalalan ma̱kalhtahuaka̱naní̱n, hua̱mpi̱ huata huixín namakni̱ko̱yá̱tit, makapitzí̱n napakaxtokohuacayá̱tit c-cruz, na̱ chuná̱ makapitzí̱n nasnokko̱yá̱tit c-mimpu̱kalhtahuakacán, chu̱ hasta naputzasta̱lako̱yá̱tit la̱ntla̱ cani̱cahua̱ ca̱chiquí̱n xlacán natahuilaputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hua̱mpi̱ lacatancs cca̱huaniyá̱n pi̱ antá̱ chú̱ c-mintiyatcán naca̱lakcha̱ná̱n xli̱pacs yama̱ li̱akastacya̱huán hua̱ntu̱ luhua xli̱lakchá̱nat xuani̱t xalakmaka̱n minatla̱tnacán caj xpa̱lacata hua̱ntu̱ tlahuako̱ni̱t la̱ntla̱ makni̱nanko̱ni̱t, acxni̱ makni̱ko̱cani̱t yama̱ lacuan ca̱najlani̱n chixcuhuí̱n, hasta la̱ntla̱ ti̱ pu̱lh timakni̱ca̱ xamaká̱n, huachá̱ xakasiya̱ cha̱tum xakstitum chixcú̱ hua̱nti̱ xuanicán Abel, chu̱ na̱ xli̱pacs hua̱nti̱ timakni̱ko̱ca̱ hasta acxni̱ xlama̱ yama̱ akchihui̱na̱ chixcú̱ Zacarías hua̱nti̱ xkahuasa xuani̱t Berequías, hua̱ yumá̱ ti̱ makni̱ko̱lh minatla̱tnacán lacatzú̱ c-altar hua̱ntu̱ huí̱ u̱nú̱ c-tlanca templo. ");
INSERT INTO tosNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ pacs huá̱ naca̱mactahuacako̱ya̱chá̱n xli̱pacs huixín judíos hua̱nti̱ lapá̱tit la̱nchu̱ quilhtamacú̱ laqui̱mpi̱ naca̱ma̱xoko̱ni̱caná̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","A̱li̱sta̱lh Jesús chuná̱ chihui̱nampá̱: “¡Jerusalén, koxutá̱ huix quinca̱chiqui̱n Jerusalén! Anta̱ u̱nú̱ makni̱ko̱cani̱t hua̱nti̱ lactlanca xpa̱lacachihui̱nani̱n Dios, na̱ antá̱ actalamakni̱ko̱ca lhu̱hua xlacscujni̱n Dios hua̱nti̱ timacaminko̱lh. Quit ca̱na̱ maklhu̱hua̱ ctzaksani̱t cma̱macxtumi̱putún xli̱pacs hua̱nti̱ u̱nú̱ huilakó̱, xta̱chuná̱ la̱ntla̱ lactzu̱ xalakskata xti̱la̱n ma̱macxtumi̱ko̱y xtzi, chu̱ luhua li̱huana̱ pu̱skokay tampi̱tanu̱ko̱y c-xtampi̱n xpakán, hua̱mpi̱ huata huixín niucxni̱ tla̱n tlahuátit. ");
INSERT INTO tosNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hua̱mpi̱ lacatancs cacatzí̱tit pi̱ aya laktzanka̱ko̱ni̱t hua̱nti̱ antá̱ huilakó̱ c-Jerusalén, sa̱mpi̱ talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ xli̱pacs akatunu chiqui̱ hua̱ntu̱ antá̱ tlahuako̱cani̱t, ca̱ta caj chunata nata̱yako̱y sa̱mpi̱ nia̱lh tí̱ catitahui̱ xpu̱chiná. ");
INSERT INTO tosNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hua̱ chuná̱ cca̱li̱huanimá̱n huixín xala c-Jerusalén sa̱mpi̱ chú̱ nia̱lh caquintiucxílhtit huixín hua̱nti̱ u̱nú̱ huilátit hasta acxni̱ nalakchá̱n quilhtamacú̱ acxni̱ ni̱li̱huaya̱ huixín nahuaná̱tit: ‘¡Luhua ca̱na̱ li̱pa̱xuhu cmakamaklhti̱ma̱hu hua̱nti̱ Quimpu̱chinacan Dios quinca̱macaminimá̱n!’” ");
INSERT INTO tosNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","A̱li̱sta̱lh Jesús táxtulh c-tlanca xtemplo̱ Dios, aya xamakó̱ acxni̱ xli̱ma̱kalhtahuáka̱t tzúculh li̱ta̱chihui̱nanko̱y pi̱ caucxilhko̱lh yuma̱ lakli̱lakati̱t chíhuix hua̱ntu̱ lacsuán li̱ca̱xtlahuako̱cani̱t xapa̱tzaps templo. ");
INSERT INTO tosNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hua̱mpi̱ Jesús huaniko̱lh: —Huixín ucxilhpá̱tit la̱ntla̱ xli̱lacsuán ca̱xya̱huacani̱t xapa̱tzaps tama̱ templo, hua̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ nalakchá̱n quilhtamacú̱ acxni̱ nia̱lh pala aktum chíhuix catitahui̱ anta̱ni̱ xuili̱ko̱cani̱t sa̱mpi̱ pacs nalactilhmi̱ko̱cán, chu̱ nia̱lh tú̱ catiánalh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Acxni̱ chú̱ cha̱nko̱lh c-xaka̱stí̱n hua̱ntu̱ huanicán Cerro de los Olivos, Jesús culucs titahui̱, chu̱ laktalacatzuhui̱ko̱lh xli̱ma̱kalhtahuáka̱t, chuná̱ tze̱k kalhasquinko̱lh: —Quin clacasquina̱hu pi̱ xquinca̱huani̱ xatú̱ quilhtamacú̱ luhua nalakchá̱n acxni̱ nakantaxtuy hua̱ntu̱ huix quinca̱li̱ta̱kalhchihui̱námpa̱t acxni̱ nalactilhmi̱ko̱cán tlanca templo xala c-Jerusalén. Chu̱ na̱ chuna li̱tum. ¿Tú̱ li̱ucxílhti̱t natasiyuy laqui̱mpi̱ naccatzi̱ya̱hu quin pi̱ aya mili̱minattá nahuán u̱nú̱ ca̱tuxá̱huat, chu̱ na̱ acxnitiyá̱ chú̱ nasputcán? ");
INSERT INTO tosNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús kalhti̱ko̱lh: —Luhua xli̱ca̱na̱ cui̱ntaj catlahuátit pi̱ ni̱tí̱ naca̱akskahuimi̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sa̱mpi̱ quit lacatancs cca̱huaniyá̱n pi̱ lhu̱hua̱ ti̱ xta̱chuná̱ nali̱taxtuputunko̱y la̱ntla̱ quit, xa̱huachí̱ nahuanko̱y: ‘Quit Cristo hua̱nti̱ naca̱lakma̱xtuyá̱n’, luhua lhu̱hua̱ hua̱nti̱ naakskahuimi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hua̱mpi̱ huixín acxni̱ yuma̱ quilhtamacú̱ nakaxpatá̱tit la̱ntla̱ nali̱chihui̱nancán pi̱ li̱pe̱cua̱ la̱ntla̱ lama̱ guerra usu la̱ta̱la̱tlahu lacatzú̱, chu̱ na̱ chuná̱ lama̱ la̱ta̱la̱tlahu a̱lacatanu̱ mákat, hua̱mpi̱ huixín ni̱ cape̱cuántit sa̱mpi̱ luhua xlacasquinca̱ pi̱ chuná̱ pu̱lh nalay, hua̱mpi̱ ni̱ naj a̱lakchá̱n nahuán quilhtamacú̱ la̱ntla̱ nasputcán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Acxni̱ chú̱ nalakchá̱n yuma̱ quilhtamacú̱, la̱ntla̱ xli̱lhu̱hua̱ tu̱ huilakó̱ ca̱chiquí̱n natzucuy la̱lacata̱qui̱ko̱y, natlahuako̱y guerra, chu̱ lactlanca tíyat na̱ nala̱makasi̱tzi̱y, chu̱ natlahuako̱y guerra. Xa̱hua̱ luhua li̱pe̱cua̱ nalay tatzíncstat, chu̱ lacaxtum natachiquiy tíyat hasta huí̱ anta̱ni̱ nalaktzanka̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hua̱mpi̱ acxni̱ chuná̱ nalay cajcu luhua quilhtzucúmaj nahuán la̱ntla̱ namín xli̱lhu̱hua tacatzanájuat. ");
INSERT INTO tosNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Huixín naca̱macama̱sta̱caná̱tit laqui̱mpi̱ naca̱ma̱sipa̱ni̱caná̱tit, hasta makapitzi̱n huixín naca̱makni̱caná̱tit, xli̱lhu̱hua tachixcuhuí̱tat naca̱xcajniko̱yá̱n caj xpa̱lacata quili̱pa̱huaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Acxni̱ nalakchá̱n yuma̱ quilhtamacú̱ luhua lhu̱hua̱ ti̱ natachokoko̱y, chu̱ nia̱lh caquintili̱pa̱huanko̱lh, hasta xalán natzucuko̱y la̱quiclhcatzaniko̱y, chu̱ nala̱sta̱macama̱sta̱ko̱y cha̱tunu a̱makapitzí̱n, laqui̱mpi̱ nama̱pa̱ti̱ni̱cán c-xmacan mapaksiná. ");
INSERT INTO tosNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lhu̱hua̱ aksani̱naní̱n natzucuko̱y huanko̱y pi̱ hua̱ xtachihui̱n Dios li̱chihui̱nama̱kó̱, chu̱ luhua lhu̱hua̱ hua̱nti̱ naakskahuiko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Caj xpa̱lacata̱ pi̱ cani̱huá̱ nalhu̱huanko̱y hua̱nti̱ ni̱tla̱n xtapuhua̱ncán lhu̱hua̱ ti̱ natzucuy maksta̱lako̱y, chu̱ nia̱lh tí̱ catila̱lakalhamanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Hua̱mpi̱ pacs hua̱nti̱ nata̱yaniy, ni̱ natachokoy, chunatiya aksti̱tum naquili̱pa̱huán hasta acxni̱ nati̱taxtuy yuma̱ ni̱tla̱n quilhtamacú̱, pus huá̱ tamá̱ nama̱akapu̱taxti̱y xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hua̱mpi̱ hua̱ yuma̱ tla̱n tama̱catzi̱ní̱n la̱ntla̱ Dios nama̱lacatzuqui̱y xasa̱sti xtapáksi̱t, xlacasquinca̱ pi̱ pu̱lh nama̱akahuani̱cán xli̱ca̱tlanca ca̱tuxá̱huat laqui̱mpi̱ pacs nalakapasko̱y, pus acxnitiyá̱ aya lakapasko̱cani̱t nahuán, na̱ acxnitiyá̱ nasputcán ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Namín quilhtamacú̱ acxni̱ huixín naucxilhá̱tit pi̱ kantaxtuma̱ hua̱ntu̱ xamaka̱n quilhtamacú̱ tili̱chihuí̱nalh profeta Daniel, acxni̱ tzokli̱ la̱ntla̱ nali̱kama̱nancán tu̱ huí̱ c-xpu̱lacni̱ yama̱ tlanca xtemplo̱ Dios xala c-Jerusalén —hua̱nti̱ li̱kalhtahuakay yuma̱ libro caakáta̱ksli̱ hua̱ntu̱ li̱chihui̱nama̱ Jesús—. ");
INSERT INTO tosNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pus acxni̱ chuná̱ catzi̱yá̱tit pi̱ akspulama̱, cca̱huaniyá̱n pi̱ hua̱nti̱ huilako̱chá nahuán c-Judea huata xatlá̱n catza̱lako̱lh, ca̱sipijni̱ caanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chu̱ hua̱nti̱ lahuacachá nahuán c-xaksti̱n xchic, nia̱lh calacapá̱stacli̱ pala tú̱ namín tamacaxtuy c-xchic, huata xatlá̱n caj catzá̱lalh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chi̱nchu̱ hua̱nti̱ ani̱t nahuán c-xpú̱cuxtu, nia̱lh catapú̱spitli̱ c-xchic pala namín tiyay xlháka̱t, huata xatlá̱n na̱ caj catzá̱lalh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Li̱lakalhamánat yuma̱ lacchaján hua̱nti̱ kalhkalhi̱nama̱koj nahuán, chu̱ luhua acxni̱ yama̱ quilhtamacú̱ aya nata̱tatlako̱y, usu hua̱nti̱ ma̱tziqui̱ko̱y nahuán cskatacán! ");
INSERT INTO tosNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Casquinítit Dios c-mioracioncán pi̱ hua̱ mintatza̱lancán ni̱ acxni̱ nahuán ca̱lonkni, chu̱ na̱ ni̱ pala acxni̱ quilhtamacu̱ sábado sa̱mpi̱ li̱jáxat. ");
INSERT INTO tosNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sa̱mpi̱ yuma̱ quilhtamacú̱ luhua xli̱ca̱na̱ huíj nahuán tlanca tacatzanájuat, la̱ntla̱ niucxnicu̱ a̱lay xta̱chuná, hasta acxni̱ Dios tima̱lacatzúqui̱lh ca̱tuxá̱huat, chu̱ nia̱lh ucxni̱ pala chuná̱ catianampá̱ a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hua̱mpi̱ Dios catzi̱y tu̱ tlahuama̱, sa̱mpi̱ aya li̱ma̱actzuhui̱ni̱t quilhtamacú̱, chu̱ ni̱ luhua maka̱s catimakapálalh, sa̱mpi̱ lapi̱ xlá̱ ni̱ chuná̱ xtláhualh nia̱lh pala cha̱tum xakatá̱xtulh, hua̱mpi̱ huá̱ xlá̱ chuná̱ li̱tlahuani̱t laqui̱mpi̱ tla̱n naakapu̱taxtuko̱y hua̱nti̱ lacsacko̱ni̱t xca̱najlaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Acxni̱ yuma̱ quilhtamacú̱ hua̱ pala huí̱ ti̱ naca̱huaniyá̱n: ‘A̱nú̱ lama̱chá̱ mima̱akapu̱taxti̱nacan Cristo’, usu nahuanicán: ‘Hua̱ yumá̱ Cristo’, huixín ni̱ caca̱najlátit. ");
INSERT INTO tosNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sa̱mpi̱ luhua lhu̱hua̱ hua̱nti̱ natzucuy li̱taxtuko̱y Cristo, usu mima̱akapu̱taxti̱nacán, chu̱ na̱ chuná̱ luhua lhu̱hua̱ hua̱nti̱ naakchihui̱nanko̱y, chu̱ nahuanko̱y pi̱ hua̱ xtachihui̱n Dios li̱chihui̱nanko̱y hua̱mpi̱ ni̱ xli̱ca̱na̱. Xlacán tla̱n natlahuako̱y lactlanca li̱ca̱cni tatlahu laqui̱mpi̱ chuná̱ tla̱n namakaca̱najlako̱y a̱makapitzí̱n, chu̱ hasta xlacán naakskahuimi̱putunko̱y hua̱nti̱ luhua ma̱n Dios lacsacko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Quit a̱li̱sokcú̱ cca̱a̱li̱huanimá̱n laqui̱mpi̱ huixín aya li̱catzi̱huilátit nahuán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pus huá̱ xpa̱lacata acxni̱ huixín naca̱huanicaná̱tit: ‘A̱nú̱ lama̱chá̱ Cristo c-desierto’, usu naca̱huanicaná̱tit: ‘A̱nú̱ tze̱k tanu̱ma̱ c-chiqui’, huixín ni̱ caca̱najlátit. ");
INSERT INTO tosNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pus cca̱huaniyá̱n pi̱ xta̱chuná̱ la̱ntla̱ acxni̱ jiliy, chu̱ maklipa, chu̱ xli̱ca̱tlanca̱ ca̱tiyatna̱ macaxkaka̱nanko̱y, pus na̱ xta̱chuná̱ cani̱huá̱ naquiucxilhcán acxni̱ quit nacmimpalay xli̱maktuy ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Huixín catzi̱yá̱tit pi̱ anta̱ni̱ ni̱y tantum takalhí̱n, pacs tuncán catzi̱ko̱y, chu̱ tamacxtumi̱ko̱y chu̱n, pus na̱ chuná̱ chú̱ acxni̱ nacmimpalay, tuncán cani̱huá̱ nacatzi̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Acxni̱ chú̱ sputni̱ttá nahuán tacatzanájuat xla yuma̱ quilhtamacú̱, tuncán natalakapaklhtu̱ti̱y chichiní̱ ca̱cuhuiní, chu̱ hua̱ papá, ni̱ catimakaxkaká̱nalh ca̱tzi̱sní; chi̱nchu̱ stacu̱ natasiyuko̱y la̱mpala tamakuasma̱ ca̱tu̱tzú̱, chu̱ hasta pacs lactlanca stacu̱ tu̱ huilakó̱ c-akapú̱n lacuilhá̱ nalako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Acxnitiyá̱ chú̱ yuma̱ quilhtamacú̱ natasiyuy aktum tlanca li̱ucxílhti̱t laqui̱mpi̱ nacatzi̱cán pi̱ quit cmimajá nahuán. Acxnitiyá̱ chú̱ naquiucxilhá̱tit, quit Xatalacsacni Chixcú, pi̱ cta̱ctama̱chi nahuán c-akapú̱n, cmímaj nahuán c-xlacni puclhni, chu̱ cli̱mímaj nahuán xli̱pacs li̱tlihuaka, chu̱ li̱ca̱cni̱ tu̱ ckalhi̱y. Xli̱pacs tachixcuhuí̱tat xala ca̱tiyatna, acxni̱ naquiucxilhko̱y cta̱ctama̱chi̱ c-akapú̱n natzucuy tasako̱y caj xpa̱lacata xtali̱puhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A̱li̱sta̱lh quit nacli̱ma̱paksi̱ko̱y quiángeles pi̱ pixtlanca̱ nali̱skoliko̱y xtrompeta Dios, laqui̱mpi̱ acxni̱ nakaxmatko̱y nali̱lakminko̱y natamacxtumi̱ko̱y xli̱pacs xcaman Dios hua̱nti̱ xlá̱ lacsacko̱ni̱t la̱ntla̱ xli̱ca̱tlanca ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Huixín luhua catzi̱yá̱tit pi̱ acxni̱ ucxilhá̱tit tzucuy akayuja̱ makapitzi̱n quihui, chu̱ tzucuy akaskatampalay, pi̱ aya talacatzuhui̱ma̱ quilhtamacú̱ la̱ntla̱ natzucuy lhca̱cnán, ");
INSERT INTO tosNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pus na̱ chuna li̱tum acxni̱ chuná̱ huixín ucxilhá̱tit pi̱ aya kantaxtuma̱ nahuán hua̱ntu̱ la̱nchú̱ cca̱huanimá̱n, pus cacatzí̱tit pi̱ aya lakcha̱ni̱t quilhtamacú̱ acxni̱ quit nacmimpalay ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ hua̱ yuma̱ tu̱ cca̱li̱ta̱chihui̱namá̱n, pacs kantaxtuni̱t nahuán ma̱squi acxni̱ ni̱ a̱ni̱ko̱y nahuán xli̱pacs tachixcuhuí̱tat hua̱nti̱ lama̱kó̱ la̱nchu̱ quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","La̱ntla̱ xli̱tlanca̱ ca̱tuxá̱huat, chu̱ akapú̱n nalaksputa, hua̱mpi̱ hua̱ quintachihuí̱n ni̱ catiláksputli̱ hasta acxni̱ kantaxtuko̱ni̱t nahuán la̱ntla̱ pu̱lacatunu̱ hua̱ntu̱ cca̱li̱ta̱kalhchihui̱nani̱tán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hua̱mpi̱ acxni̱ yuma̱ quilhtamacú̱ nalakchá̱n pi̱ nakantaxtuy hua̱ntu̱ cca̱huanimá̱n chú̱, tamá̱ xlá̱ ni̱ pala cha̱tum ti̱ catzi̱y, ni̱ pala hua̱ xángeles Dios, na̱ ni̱ pala quit, caj xma̱n xacstu catzi̱y Quintla̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Xta̱chuná̱ la̱ntla̱ tílalh xamaka̱n quilhtamacú̱ acxni̱ xlama̱ Noé, ni̱tí̱ xca̱najlay pi̱ namín sputná̱nat, pus na̱ chuná̱ chú̱ naqui̱taxtuy acxni̱ quit Xatalacsacni Chixcú̱ nacmimpalay xli̱maktuy ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yama̱ maka̱n quilhtamacú̱ acxni̱ ni̱ xa̱lay muncá̱clat, chu̱ Noé ni̱ xa̱tanu̱y c-tlanca páklha̱t hua̱ntu̱ huanicán arca, la̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat ni̱ pala tzinú̱ xli̱puhuanko̱y, chunatiya li̱pa̱xuhu xua̱yama̱kó̱, xkotnama̱kó̱, xtapu̱chuhuama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hua̱mpi̱ acxni̱ ni̱ pala tzinú̱ xli̱a̱catzi̱huilakó̱, tahuilachi̱ tlanca se̱n, lalh muncá̱clat, chu̱ pu̱tum mu̱xtuko̱lh. Na̱ chuná̱ chú̱ naqui̱taxtuy acxni̱ quit Xatalacsacni Chixcú̱ nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Acxni̱ yuma̱ quilhtamacú̱, lapi̱ cha̱tuy chixcuhuí̱n lacxtum cuxtuma̱koj nahuán c-xpu̱cuxtucán, cha̱tum nale̱ncán, chu̱ cha̱tum namakaxtakcán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cha̱tuy lacchaján lacxtum squitima̱kó̱ nahuán, hua̱ cha̱tum nale̱ncán chi̱nchu̱ hua̱ a̱cha̱tum namakaxtakcán. ");
INSERT INTO tosNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ca̱na̱ huixín skálalh catahuilátit sa̱mpi̱ ni̱ tzinú̱ catzi̱yá̱tit tú̱ ya̱ quilhtamacú̱ quit Mimpu̱chinacán nacca̱lakchiná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xli̱ca̱na̱ huixín luhua skálalh calatapá̱tit xta̱chuná̱ la̱ntla̱ cha̱tum chixcú̱ ti̱ luhua skálalh tama̱y, ni̱ aktziyaj lhtatay laqui̱mpi̱ ni̱ nalaktanu̱ko̱y kalha̱naní̱n, sa̱mpi̱ lapi̱ xlá̱ ni̱ skálalh natahuilay ni̱ pala tzinú̱ li̱catzi̱y acxni̱ nalaktanu̱ko̱ya̱chá̱ kalha̱naní̱n, chu̱ namakkalhanko̱cán pacs la̱ntla̱ tu̱ xlá̱ kalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pus na̱ chuná̱ chú̱ huixín skálalh catahuilátit, sa̱mpi̱ acxni̱ ni̱ pala tzinú̱ li̱catzi̱huilátit nahuán quit nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Quit clacasquín pi̱ huixín huá̱ xkanti̱nítit cha̱tum scujni̱ ti̱ tla̱n xtapuhuá̱n, hua̱ xma̱la̱ná̱ ma̱cui̱ntajli̱y xchic laqui̱mpi̱ xlá̱ namaktakalhko̱y xli̱pacs hua̱ntu̱ kalhi̱y, chu̱ na̱ nama̱hui̱ko̱y a̱makapitzi̱n xta̱scujní̱n acxni̱ nalakchá̱n hora la̱ntla̱ nahua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Luhua xli̱ca̱na̱ hua̱ xma̱la̱ná̱ natzucuy ta̱pa̱xuhuay cscujni̱ acxni̱ makatunu̱ nalakchín, chu̱ naucxilha̱ pi̱ chuná̱ ma̱kantaxti̱ma̱ nahuán tascújut hua̱ntu̱ li̱ma̱paksi̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Acxni̱ ankalhí̱n nama̱noklhucán pi̱ xli̱ca̱na̱ scujma̱ yuma̱ chixcu, hua̱ xma̱la̱ná̱ nali̱pa̱huán huata pacs nama̱cui̱ntajli̱ko̱y la̱ntla̱ tu̱ kalhi̱y, chuna̱ na̱má̱ nalakalhamancán hua̱nti̱ tla̱n xtapuhuá̱n scujni. ");
INSERT INTO tosNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Chi̱ hua̱ lapi̱ hua̱ yuma̱ scujni̱ napuhuán pi̱ ni̱ lacapala̱ catíchilh xma̱la̱ná, ");
INSERT INTO tosNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","huata natzucuy ma̱pa̱ti̱ni̱ko̱y a̱makapitzi̱n xta̱scujní̱n, chu̱ caj amigos nata̱lako̱y hua̱nti̱ na̱ luhua lacli̱xcajnit xtapuhua̱ncán, chu̱ huá̱ tzucuy ta̱kotko̱y kotní̱n; ");
INSERT INTO tosNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","hua̱ lapi̱ chuná̱ tlahuay, ni̱ skálalh natahuilay la̱ntla̱ nakalhkalhi̱y xma̱la̱ná, pus acxni̱ ni̱ li̱catzi̱hui̱ nalakchín xma̱la̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tancs cca̱huaniyá̱n pi̱ yama̱ xma̱la̱ná̱ tla̱n nama̱pa̱ti̱ni̱y, namaca̱ncán c-pu̱pa̱tí̱n anta̱ni̱ maca̱nko̱cán hua̱nti̱ xaaksani̱naní̱n. Antá̱ natasay, chu̱ nala̱li̱lacxcay xtatzán. ");
INSERT INTO tosNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Yama̱ quilhtamacú̱ acxni̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tiyatna, lhu̱hua̱ hua̱nti̱ chuná̱ naakspulay xta̱chuná̱ la̱ntla̱ tiakspulako̱lh yuma̱ kalhaca̱hu lactzumaján hua̱nti̱ tili̱lacsacko̱ca̱ pi̱ naanko̱y makskotkalhkalhiti̱ko̱y yuma̱ kahuasa acxni̱ nachín sa̱mpi̱ xtapu̱chuhuama̱. ");
INSERT INTO tosNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kalhaquitzis lactzumaján luhua ni̱ pala tzinú̱ xli̱ta̱katzanka̱ko̱y xpa̱lacata̱ pala nale̱nko̱y hua̱ntu̱ namaclacasquinko̱ya̱chá, hua̱mpi̱ a̱makapitzí̱n kalhaquitzis, xlacán luhua skálalh xanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yama̱ lactzumaján hua̱nti̱ ni̱tú̱ xli̱ta̱katzanka̱ko̱y pala tú̱, xlacán le̱nko̱lh xli̱makskocán hua̱mpi̱ caj xma̱n hua̱ntu̱ xtaju̱ma̱ gas, ni̱tú̱ tanuj le̱nko̱lh gas hua̱ntu̱ xmaclacasquinko̱lh pala xqui̱tzánka̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Hua̱mpi̱ a̱makapitzí̱n hua̱nti̱ skálalh xanko̱y, xlacán stap ma̱tzamako̱lh xli̱makskocán, chu̱ tanuj lumi̱ta̱ xpu̱le̱mpalako̱y gas huá̱ chú̱ tu̱ namuju̱niko̱y xli̱makskocán acxni̱ pala xqui̱tzánka̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hua̱mpi̱ cumu hua̱ yuma̱ kahuasa ti̱ xtapu̱chuhuama̱ luhua maka̱s la̱ntla̱ xmakapalama̱chá, lactzumaján lhtataputunko̱lh, pus punchú̱ lhtatako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hua̱mpi̱ ma̱x pala ca̱ta̱ncánat xuani̱t acxni̱ cha̱tum chixcú̱ pixtlanca̱ chihuí̱nalh, na̱má̱ huaniko̱lh: ‘¡Calakastakuanántit tuncán, aya mima̱ kahuasa tapu̱chuhuani, lacapala̱ catántit pa̱xtoká̱tit!’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yama̱ kalhaca̱hu lactzumaján lacapala̱ taca̱xta̱qui̱ko̱lh, chu̱ tzúculh ma̱pasi̱ko̱y xli̱makskocán. ");
INSERT INTO tosNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hua̱mpi̱ hua̱ yuma̱ kalhaquitzis lactzumaján hua̱nti̱ ni̱tú̱ tanuj xle̱nko̱y xga̱scán, xlacán huaniko̱lh a̱makapitzí̱n hua̱nti̱ xpu̱le̱nko̱y lumi̱ta̱ gas: ‘Catlahuátit li̱tlá̱n caquinca̱ta̱quí̱tit tzinú̱ miga̱scán sa̱mpi̱ aya mixputún quimpu̱makskocán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yama̱ kalhaquitzis lactzumaján chuná̱ kalhti̱ko̱lh: ‘Lapi̱ nacca̱ta̱qui̱yá̱n caj tzinín, ni̱ caquintica̱accha̱nín, sa̱mpi̱ acxni̱ chú̱ nalhcuko̱y nia̱lh tú̱ catihuá̱. Huata caqui̱tama̱huapítit anta̱ni̱ sta̱cán laqui̱mpi̱ ma̱n natama̱huayá̱tit hua̱ntu̱ naca̱accha̱niyá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yama̱ kalhaquitzis lactzumaján hua̱nti̱ xqui̱tzankaniko̱y xga̱scán, lacapala̱ anko̱lh putzako̱y anta̱ni̱ sta̱cán laqui̱mpi̱ natama̱huako̱y, hua̱mpi̱ ni̱ xa̱qui̱taspitko̱y acxni̱ chilh yuma̱ kahuasa tapu̱chuhuani, chu̱ a̱makapitzí̱n kalhaquitzis lactzumaján hua̱nti̱ cha̱catzi̱ya̱ xle̱nko̱y gas, xlacán lacapala̱ ca̱xma̱pasi̱ko̱lh xli̱makskocán, chu̱ anko̱lh makskottiyako̱y kahuasa, chu̱ ta̱tanu̱ko̱lh c-xpu̱lacni chiqui̱ anta̱ni̱ xpa̱xuhuama̱kó̱, chu̱ a̱li̱sta̱lh chú̱ li̱huana̱ ma̱lacchuhuaca̱. ");
INSERT INTO tosNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Caj li̱puntzú̱ chinko̱lh a̱makapitzi̱n lactzumaján, xlacán tzúculh lakatlakko̱y má̱laccha, chu̱ chuná̱ xuanko̱y: ‘Tla̱ti, tla̱ti, catlahua̱ li̱tlá̱n caquinca̱ma̱lacqui̱ni.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Hua̱mpi̱ hua̱ yuma̱ kahuasa tapu̱chuhuani̱ chuná̱ kalhti̱ko̱lh: ‘Quit lacatancs cca̱huaniyá̱n pi̱ ni̱ lay cca̱ma̱lacqui̱niyá̱n sa̱mpi̱ ni̱ cca̱lakapasá̱n.’” ");
INSERT INTO tosNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Acxni̱ Jesús chuná̱ li̱kalhchihuí̱nalh yuma̱ takalhchihuí̱n xlá̱ huanipalako̱lh: “Cca̱huaniyá̱n pi̱ luhua skálalh calatapá̱tit sa̱mpi̱ ni̱ catzi̱yá̱tit tú̱ ya̱ quilhtamacú̱, chu̱ tú̱ ya̱ hora acxni̱ quit Xatalacsacni Chixcú̱ nacmimpalay xli̱maktuy. ");
INSERT INTO tosNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Xasa̱sti xtapaksi̱t Dios hua̱ntu̱ nama̱lacatzuqui̱y, luhua xta̱chuná̱ qui̱taxtuy la̱ntla̱ cha̱tum ma̱la̱ná̱ acxni̱ xtaca̱xma̱ xpa̱lacata nataquilhanu̱y, mákat naán a̱lacatanu̱ ca̱chiquí̱n. Acxni̱ aya xtaca̱xma̱, tasaniko̱lh cscujní̱n, chu̱ cha̱tunu cha̱tunu̱ ma̱xqui̱ko̱lh xtumi̱n laqui̱mpi̱ xlacán nama̱scujuniko̱y, chu̱ nama̱skati̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Huá̱ chú̱ xakasiya̱ cscujni má̱xqui̱lh akquitzis mi̱lh tumi̱n xla oro, chu̱ cha̱tum li̱tum má̱xqui̱lh aktuy mi̱lh tumi̱n xla oro, chu̱ tanu̱ hua̱nti̱ má̱xqui̱lh aktum mi̱lh. Huá̱ li̱ma̱xqui̱ko̱lh laqui̱mpi̱ xlacán nama̱scujuko̱y, chu̱ nama̱skati̱ko̱y yuma̱ tumi̱n sa̱mpi̱ xlá̱ aya xlakapasko̱y la̱ntla̱ xli̱skalalacan cha̱tunu cha̱tunu. Acxni̱ chú̱ chuná̱ ta̱lacca̱xlako̱lh yama̱ ma̱la̱ná̱ fuerza̱ alh paxia̱lhnán mákat la̱ntla̱ chunata xlacapa̱stacni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hua̱ yuma̱ cscujni ti̱ ma̱xqui̱ca̱ akquitzis mi̱lh tumi̱n xla oro, xlá̱ tzúculh tama̱huanán, chu̱ tláhualh negocio, chuná̱ chú̱ ma̱tláji̱lh akquitzis mi̱lh caj la̱ntla̱ ma̱scújulh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na̱ chuná̱ yuma̱ scujni̱ ti̱ maklhtí̱nalh aktuy mi̱lh, xlá̱ na̱ ma̱scújulh tumi̱n, chu̱ li̱huaca aktuy mi̱lh caj la̱ntla̱ tu̱ ma̱skáti̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Hua̱mpi̱ huata hua̱nti̱ caj aktum mi̱lh maklhtí̱nalh, xlá̱ ni̱ ma̱scújulh yuma̱ tumi̱n, huata caj cá̱huaxli̱ ca̱tiyatna, antá̱ má̱acnu̱lh xtumi̱n xma̱la̱ná̱ laqui̱mpi̱ ni̱ natzanka̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Acxni̱ chú̱ xli̱maka̱s quilhtamacú̱, caj xamaktum chilh xma̱la̱nacán yuma̱ scujní̱n. Xlá̱ qui̱táspitli̱ la̱ntla̱ mákat qui̱paxiá̱lhnalh, chu̱ tuncán tasaniko̱lh cscujní̱n laqui̱mpi̱ nata̱tlahuako̱y cui̱ntaj la̱ntla̱ xma̱skati̱ni̱t xtumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pu̱lh huá̱ chilh hua̱nti̱ xmaklhti̱nani̱t akquitzis mi̱lh tumi̱n xla oro, chu̱ macamá̱sta̱lh akquitzis mi̱lh hua̱ntu̱ ma̱skáti̱lh la̱ntla̱ xma̱scujuma̱. Pus chuná̱ huánilh xma̱la̱ná: ‘Tla̱ti, huix quintima̱xqui̱ akquitzis mi̱lh, chi̱nchu̱ caj xpa̱lacata̱ pi̱ quit cscujli̱ la̱ntla̱ huix quintili̱ma̱paksi, pus u̱huí̱ chú̱ a̱akquitzis mi̱lh hua̱ntu̱ quit cma̱tlaji̱ni̱t mintumi̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cha̱nchu̱ xma̱la̱ná̱ huánilh: ‘Xli̱ca̱na̱ luhua clakati̱y mintascújut. Caj xpa̱lacata cumu huix cui̱ntajtlahua̱ ma̱squi ni̱ luhua lhu̱hua̱ tu̱ ctima̱xquí̱n, pus huata chú̱ nacma̱cui̱ntajli̱yá̱n tu̱ tlak lhu̱hua̱ laqui̱mpi̱ namaktakalha. Hua̱mpi̱ lacapala̱ catanu̱ laqui̱mpi̱ luhua lacxtum li̱pa̱xuhu naca̱taniya̱hu xpa̱lacata mintascújut hua̱ntu̱ ma̱kantaxti̱ni̱ta.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Caj li̱puntzú̱ chilh yuma̱ cscujni ti̱ xmaklhti̱nani̱t aktuy mi̱lh. Acxni̱ xlá̱ chilh chuná̱ huánilh xma̱la̱ná: ‘Huix quintima̱cui̱ntajli̱ aktuy mi̱lh mintumi̱n xla oro, hua̱mpi̱ u̱huilapá̱ chú̱ aktum mi̱lh hua̱ntu̱ quit cma̱skati̱ni̱t mintumi̱n caj la̱ntla̱ xacma̱scujuma̱.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Pus huánilh xma̱la̱ná: ‘Xli̱ca̱na̱ pi̱ na̱ luhua clakati̱y mintascújut, huix luhua tali̱pa̱hu scujni, pus cumu huix luhua cui̱ntajtlahua̱ ma̱squi ni̱ luhua lhu̱hua̱ tu̱ xacma̱xqui̱ni̱tán la̱nchú̱ nacma̱xqui̱yá̱n hua̱ntu̱ tlak lhu̱hua laqui̱mpi̱ huix naquima̱scujuniya. Hua̱mpi̱ na̱ lacapala̱ catanu̱ c-quínchic, chu̱ lacxtum nali̱ca̱taniya̱hu xpa̱lacata mintascújut hua̱ntu̱ huix aya ma̱kantaxti̱ni̱ta.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Hua̱mpi̱ acxni̱ chú̱ chilh yuma̱ cscujni ti̱ xma̱cui̱ntajli̱cani̱t aktum mi̱lh xpa̱lacata na̱ nama̱scujuy, xlá̱ chuná̱ huánilh xma̱la̱ná: ‘Tla̱ti, quit aya maka̱sá̱ ccátzi̱lh pi̱ luhua scalajua̱ mintá̱yat, huix akchipahuili̱ya, chu̱ milá̱ tlahuaya̱ hua̱ntu̱ ni̱ huix li̱scujni̱ta, chu̱ ma̱squi pala xactima̱scújulh mintumi̱n xli̱pacs hua̱ntu̱ xactima̱skáti̱lh, huix pacs xquimaklhti̱kó. ");
INSERT INTO tosNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hua̱mpi̱ na̱ chuna li̱tum quit cpé̱cualh pala nacmakatzanka̱y, huata caj li̱huana̱ cmá̱qui̱lh, antá̱ ctimá̱acnu̱lh c-xtampi̱n tíyat. Hua̱mpi̱ ni̱ cali̱púhuanti, u̱huí̱ mintumi̱n tu̱ huix quintima̱xqui.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Hua̱mpi̱ hua̱ ma̱la̱ná̱ na̱má̱ kálhti̱lh: ‘Hua̱mpi̱ huix luhua ni̱ tali̱pa̱hu scujni, chu̱ luhua xalhquítit huix. Pus lapi̱ xli̱ca̱na̱ xcatzi̱ya̱ pi̱ quit cakchipahuili̱y, chu̱ quilá̱ ctlahuay hua̱ntu̱ ni̱ quit cli̱scujni̱t, ");
INSERT INTO tosNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿tú̱ chi̱nchu̱ xpa̱lacata̱ ni̱ pit li̱huili̱ya̱ quintumi̱n c-banco laqui̱mpi̱ acxni̱ quit xactíchilh antá̱ xactíalh maklhti̱nán quintumi̱n sa̱mpi̱ antá̱ fuerza̱ xquintiakxokonica̱?’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pus hua̱ yuma̱ ma̱la̱ná̱ li̱ma̱paksi̱ko̱lh hua̱nti̱ antá̱ xlayakó̱: ‘Camaklhtí̱tit yuma̱ chixcú̱ tumi̱n tu̱ xlá̱ li̱mín aktum mi̱lh, chu̱ huá̱ cama̱xquí̱tit hua̱nti̱ kalhi̱y akca̱hu mi̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sa̱mpi̱ hua̱nti̱ lhu̱hua̱ kalhi̱y hua̱ntu̱ maclacasquín, a̱tzinú̱ nama̱xqui̱cán laqui̱mpi̱ naakata̱xtuniy, hua̱mpi̱ hua̱nti̱ ni̱tú̱ kalhi̱y hua̱ntu̱ maclacasquín, hasta namaklhti̱ko̱cán ma̱squi caj xma̱n huá̱ tu̱ xkalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chi̱nchu̱ yuma̱ ni̱ tali̱pa̱hu scujni, hua̱nti̱ ni̱tú̱ li̱scujputún, lacapala̱ catamacaxtútit c-quilhtí̱n ca̱paklhtu̱tá̱, laqui̱mpi̱ antá̱ naxoko̱nán caj xpa̱lacata luhua ni̱ tali̱pa̱hu scujni; antá̱ nala̱li̱xcay xtatzán caj xpa̱lacata tlanca tapa̱tí̱n hua̱ntu̱ namakcatzi̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Acxni̱ yuma̱ quilhtamacú̱ quit Xatalacsacni Chixcú̱ nacmimpalay xli̱maktuy ca̱tuxá̱huat, quit nactahuilay c-quimpu̱ma̱paksí̱n xta̱chuná̱ la̱ntla̱ cha̱tum tlanca Rey, xa̱hua̱ xli̱pacs quili̱ca̱cni, chu̱ xli̱pacs ángeles nacta̱minko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Na̱ naquili̱tamacxtumi̱ko̱y xli̱pacs tachixcuhuí̱tat xala caxani̱cahua̱ tíyat. Quit nactzucuy ma̱pa̱pitziko̱y xta̱chuná̱ la̱ntla̱ xma̱putxuani̱ná̱ acxni̱ ma̱pa̱pitziy xtakalhí̱n, tánuj ya̱huako̱y calhni̱lu̱, chu̱ lacatanu̱ ti̱ntzun. ");
INSERT INTO tosNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Xli̱pacs hua̱nti̱ xkaxmatko̱y quintachihuí̱n, chu̱ xli̱tzaksama̱kó̱ xpa̱lacata nama̱kantaxti̱ko̱y, pus antá̱ nacuili̱ko̱y c-quimpakstácat; chu̱ a̱makapitzí̱n hua̱nti̱ caj chunata xkaxmatmakanko̱y quintachihuí̱n, chu̱ ni̱ li̱tzaksako̱lh, pus antá̱ nacuili̱ko̱y c-quimpakxuqui. ");
INSERT INTO tosNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","A̱li̱sta̱lh quit nacuaniko̱y hua̱nti̱ huilako̱lh nahuán c-quimpakstácat: ‘¡Luhua xli̱ca̱na̱ capa̱xuhuátit huixín hua̱nti̱ ca̱lacsacni̱tán quintla̱t! Lacapala̱ catahuilátit c-mimpu̱tahui̱lhcán hua̱ntu̱ xlá̱ ca̱li̱kalhi̱má̱n hasta la̱ntla̱ tima̱lacatzúqui̱lh ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sa̱mpi̱ acxni̱ quit xactzincsni̱ma̱ huixín quintima̱huí̱tit, acxni̱ quit xackalhpu̱ti̱xni̱ma̱ huixín quintima̱kotní̱tit, xaclapu̱lay c-minca̱chiquí̱n, ni̱tú̱ xackalhi̱y quínchic, huixín quima̱lacqui̱nítit minchiccán laqui̱mpi̱ antá̱ naclaktuncuhuiy. ");
INSERT INTO tosNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Acxni̱ xaclama̱, ni̱tú̱ xuani̱t quilháka̱t, huixín quintita̱quí̱tit hua̱ntu̱ naclhaka̱y, acxni̱ xacta̱tatlay, chu̱ acxni̱ xactanu̱ma̱ c-pu̱la̱chi̱n, huixín quintiqui̱lakata̱yátit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Hua̱ yumá̱ hua̱nti̱ Dios nalakma̱xtuko̱y nakalhasquini̱nanko̱y: ‘Tla̱ti hua̱mpi̱ ¿Ní̱ li̱huayajá̱ xkalhpu̱ti̱xní̱pa̱t, chu̱ quin ctica̱ma̱kotní̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Usuchí̱ ¿ní̱ li̱huayajá̱ xlapu̱laya̱ c-quinca̱chiqui̱ncán pala ni̱ní̱ xlaktuncuhuiya, chu̱ quin ctica̱ta̱laktuncuhuín c-quinchiccán, usu ni̱tú̱ xuani̱t milháka̱t, chu̱ quin ctica̱ma̱xquí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Usu ¿Ní̱ makli̱t pala xta̱tatlaya, usu xtanú̱pa̱t c-pu̱la̱chi̱n, chu̱ quin ctica̱qui̱lakatayán?’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huata quit chuná̱ nackalhti̱ko̱y: ‘Xli̱ca̱na̱ quit cca̱huaniyá̱n pi̱ la̱ntla̱ caxatu̱cahua̱ li̱tlá̱n tu̱ huixín tlahuanikó̱tit, pala c-xca̱tali̱ma̱xka̱tcán hua̱ yumá̱ hua̱nti̱ quit cli̱ma̱xtuko̱y quinata̱laní̱n, ma̱squi ni̱ pala tzinú̱ tu̱ xlakasicán li̱tasiyuko̱y, qui̱taxtuy xta̱chuná̱ la̱ntla̱ pala quit quintlahuanítit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“A̱li̱sta̱lh na̱ naclaktalakaspitko̱y hua̱nti̱ ya̱kó̱ nahuán c-quimpakxuqui, chu̱ chuná̱ nacuaniko̱y: ‘Catlahuátit li̱tlá̱n, caquintapa̱nu̱nítit chú̱ huixín hua̱nti̱ aya napa̱ti̱naná̱tit caj xpa̱lacata hua̱ntu̱ ni̱tlá̱n tlahuanini̱tántit. Huata antá̱ capimpítit c-lhcúya̱t anta̱ni̱ niucxni̱ catímixli, hua̱ntu̱ tica̱xtlahuanica̱ akskahuiní, chu̱ xli̱pacs yama̱ ni̱tla̱n xángeles, usu cspíritu̱ hua̱nti̱ xta̱scujma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sa̱mpi̱ acxni̱ quit xactitzincstamakama̱, huixín ni̱ quima̱huí̱tit, acxni̱ xackalhpu̱ti̱xni̱ma̱, huixín ni̱ quima̱kotní̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Acxni̱ xaclapu̱lay, chu̱ ni̱ní̱ xaclaktuncuhuiy, huixín ni̱ pala tzinú̱ xpuhuántit pala naquinta̱laktuncuhuiyá̱tit c-minchiccán. Acxni̱ laksputko̱lh quilháka̱t hua̱ntu̱ xaclhaka̱ni̱t huixín ni̱tú̱ quima̱xquí̱tit hua̱ntu̱ naclhaka̱y. Acxni̱ ctama̱chá̱ ca̱tajátat, usu quintitamacanu̱ca̱ c-pu̱la̱chi̱n, huixín ni̱ pala xpuhuántit pala naquilakata̱yayá̱tit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Hua̱ xlacán naquinkalhasquinko̱y: ‘Quimpu̱chinacán, hua̱mpi̱ quin ni̱ pala maktum xacca̱ucxilhni̱ pala xtzincsní̱pa̱t, chu̱ ni̱ cca̱ta̱hua̱yán, usu pala xkalhpu̱ti̱xní̱pa̱t, chu̱ ni̱ cca̱ta̱kotnán, pala xlapu̱laya, ni̱ní̱ xlaktuncuhuiya, usu pala xtzanka̱niyá̱n milháka̱t, chuná̱ pala xta̱tatlaya, usu xtanú̱pa̱t c-pu̱la̱chi̱n, chu̱ quin ni̱tú̱ ctica̱li̱makta̱yán.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Hua̱mpi̱ quit chuná̱ nackalhti̱ko̱y: ‘Quit lacatancs cca̱huaniyá̱n pi̱ la̱ntla̱ makatunu̱ ni̱ makta̱yakó̱tit yama̱ caj xachunata tasiyuko̱y quinata̱lán acxni̱ xlacán catu̱huá̱ xtzanka̱nima̱kó̱, pus luhua chuná̱ cli̱ma̱xtuy pi̱ quit quilakmakani̱tántit, chu̱ ni̱ quimakta̱yátit.’ ");
INSERT INTO tosNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pus huá̱ xlacán hua̱nti̱ ni̱ lacuan xtapuhua̱ncán antá̱ nacha̱nko̱y lacatum anta̱ni̱ pa̱ti̱nama̱kó̱ nahuán caxani̱li̱huayaj xtihua̱; chi̱nchu̱ hua̱nti̱ tlahuako̱ni̱t hua̱ntu̱ lakati̱y Dios, huá̱ xlacán antá̱ nacha̱nko̱y lacatum anta̱ni̱ pa̱xuhuama̱koj nahuán caxani̱li̱huayaj xtihua̱.” ");
INSERT INTO tosNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Acxni̱ ma̱akaspútulh yuma̱ tachihuí̱n, Jesús na̱má̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: ");
INSERT INTO tosNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Huixín catzi̱yá̱tit pi̱ huatiya̱ la̱ntla̱ tu̱xama̱ natzucuy pa̱scua̱ xla ta̱kspuntza̱lí̱n, na̱ acxnitiyá̱ yuma̱ quilhtamacú̱ naquinchipacán, chu̱ naquimacama̱sta̱cán c-xlacati̱ncán hua̱nti̱ quinta̱la̱tlahuako̱y laqui̱mpi̱ naquimpakaxtokohuacacán c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Luhua xli̱ca̱na̱ hua̱ntu̱ Jesús xli̱chihui̱nama̱, sa̱mpi̱ na̱ huatiya̱ yuma̱ quilhtamacú̱ xtamacxtumi̱ko̱ni̱t xanapuxcun pa̱lijni, xa̱hua̱ lakko̱lutzí̱n hua̱nti̱ xpuxcu̱naniko̱y judíos, antá̱ xtamacxtumi̱ko̱ni̱t c-xchic Caifás sa̱mpi̱ xlá̱ xapuxcu pa̱li̱ hua̱nti̱ xma̱paksi̱ko̱y pacs a̱makapitzi̱n xta̱pa̱lijni. ");
INSERT INTO tosNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xlacán li̱la̱ta̱chihui̱nanko̱lh, la̱li̱stacya̱huako̱lh pi̱ ma̱squi caj ta̱ksaní̱n nama̱xtuniko̱y Jesús laqui̱mpi̱ tla̱n nachipacán, chu̱ namakni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hua̱mpi̱ huata xacstucán xla̱huanipalako̱y: —Huata xatlá̱n ni̱ chipama̱hu acxni̱ luhua xquilhtamacu̱ pa̱scua̱, sa̱mpi̱ nasi̱tzi̱ko̱y hua̱nti̱ li̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Acxni̱ Jesús antá̱ xuí̱ c-xchic Simón c-xaca̱chiqui̱n Betania, hua̱ yuma̱ chixcú̱ hua̱nti̱ pacsli̱ acxni̱ xkalhi̱y aktum li̱xcajnit tzitzi̱ hua̱ntu̱ huanicán lepra. ");
INSERT INTO tosNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Luhua acxni̱ Jesús xua̱yama̱, chilh cha̱tum pusca̱t, xlá̱ laktalacatzúhui̱lh c-mesa anta̱ni̱ macahuácaj xuí̱; xlá̱ xli̱mini̱t pa̱tum lumi̱ta̱ xatla̱n perfume hua̱ntu̱ luhua xatapala̱xlá. Acxni̱ chú̱ lákcha̱lh acma̱huácalh c-xakxe̱ka Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Acxni̱ yuma̱ xli̱ma̱kalhtahuáka̱t ucxilhko̱lh, xlacán tzúculh si̱tzi̱ko̱y chu̱ na̱má̱ la̱huaniko̱lh: —¿Tú̱huan caj pá̱xcat lactlahuami̱ca̱ yuma̱ xatapala̱xla perfume? ");
INSERT INTO tosNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Huata xatlá̱n caj luhua lhu̱hua tumi̱n xtili̱sta̱ca̱, chu̱ hua̱ntu̱ xtitástokli̱ xatumi̱n xli̱makta̱yako̱ca̱ li̱ma̱xkaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús kalhakaxmatko̱lh hua̱ntu̱ xlacán xla̱huanima̱kó̱, chu̱ xlá̱ na̱má̱ huaniko̱lh: —¿Tú̱huan li̱lacasi̱tzi̱nipá̱tit yuma̱ koxuta pusca̱t? Ni̱ calacasi̱tzi̱nítit sa̱mpi̱ hua̱ntu̱ xlá̱ tlahuani̱t xli̱ca̱na̱ pi̱ luhua tla̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Huá̱ chuná̱ cca̱li̱huanimá̱n sa̱mpi̱ yama̱ hua̱nti̱ lakli̱ma̱xkaní̱n, ankalhí̱n lama̱koj nahuán c-milaksti̱pa̱ncán, hua̱mpi̱ quit ni̱ ankalhí̱n cca̱ta̱lamá̱n c-milaksti̱pa̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Xa̱huá, hua̱ yuma̱ perfume hua̱ntu̱ quiacma̱huacani̱t naquimakta̱yay a̱li̱sta̱lh, sa̱mpi̱ chuná̱ a̱li̱sokcú̱ quima̱mu̱csi̱nini̱t quintiyatli̱hua̱ laqui̱mpi̱ aya ca̱xlani̱t nahuán xpa̱lacata acxni̱ naquima̱acnu̱cán c-quimpu̱ta̱cnú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Quit lacatancs cca̱huaniyá̱n pi̱ caxani̱cahuá̱ xli̱ca̱tlanca̱ ca̱tuxá̱huat anta̱ni̱ naquili̱chihui̱nancán la̱ntla̱ cmini̱t lakma̱xtuko̱y tachixcuhuí̱tat, na̱ chuná̱ nali̱chihui̱nancán hua̱ntu̱ xlá̱ quintlahuanini̱t yuma̱ pusca̱t acxni̱ quili̱tláhualh perfume, chu̱ chuná̱ xli̱ankalhí̱n nali̱lacapa̱staccán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","La̱ntla̱ kalhacu̱tuy xca̱lacsacni̱t xli̱ma̱kalhtahuaka̱t Jesús, cha̱tum taxtuchá̱ hua̱nti̱ xuanicán Judas Iscariote. Xlá̱ qui̱laklako̱lh xanapuxcun pa̱lijni, ");
INSERT INTO tosNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","chu̱ na̱má̱ huaniko̱lh: —Lapi̱ quit nacca̱macama̱xqui̱yá̱n Jesús, ¿ní̱ntla̱ naquima̱skahui̱yá̱tit? Xlacán ma̱xqui̱ko̱lh puxamaca̱hu tumi̱n la̱ntla̱ xaokxutunu, pacs xla plata. ");
INSERT INTO tosNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Pus hasta acxnitiyá̱ yuma̱ quilhtamacú̱ judas tzúculh putzay la̱ntla̱ namacama̱sta̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Acxni̱ yama̱ xakasiya̱ quilhtamacu̱ xapa̱scua ta̱kspuntza̱lí̱n, luhua acxni̱ xli̱pacs judíos xli̱ca̱cni̱naniko̱y Dios la̱ntla̱ xuako̱y caxtala̱nchu̱ tu̱ ni̱tú̱ kalhi̱y li̱ma̱xcutí̱n, xli̱ma̱kalhtahuáka̱t laktalacatzuhui̱ko̱lh Jesús, chu̱ chuna̱ na̱má̱ huaniko̱lh: —¿Ní̱ lacasquina̱ nacana̱hu ca̱xtlahuaya̱hu quili̱huatcán laqui̱mpi̱ nali̱hua̱yana̱hu ca̱tánit xla ta̱kspuntza̱lí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Cha̱nchu̱ xlá̱ huaniko̱lh: —Capimpítit c-Jerusalén, antá̱ nachipiná̱tit c-xchic cha̱tum chixcú̱ hua̱nti̱ quit aya cta̱lacca̱xlani̱t, chu̱ chuná̱ na̱má̱ nahuaniyá̱tit: ‘Huán quima̱kalhtahuaka̱nacán: Chú̱ aya talacatzuhui̱ma̱ quilhtamacú̱ nacma̱sputuy quintascújut, huá̱ xpa̱lacata̱ cli̱ta̱ama̱ko̱chá̱ quili̱ma̱kalhtahuáka̱t laqui̱mpi̱ antá̱ c-mínchic nacuaya̱hu lí̱huat huá̱ tu̱ huacán acxni̱ pa̱scua̱ xla ta̱kspuntza̱lí̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Puschí̱ chuná̱ tlahuako̱lh xli̱ma̱kalhtahuáka̱t hua̱ la̱ntla̱ Jesús xli̱ma̱paksi̱ko̱ni̱t, chu̱ antá̱ ca̱xtlahuako̱chá̱ xli̱huatcán tu̱ nahuako̱y yama̱ ca̱ko̱tanú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Acxni̱ chú̱ tzí̱sualh, Jesús aya xta̱cha̱nko̱ni̱t, antá̱ chú̱ macxtum xta̱huilakó̱ kalhacu̱tuy xli̱ma̱kalhtahuáka̱t c-pu̱hua̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Acxni̱ chú̱ xua̱yama̱kó̱, tihua̱ Jesús: —Quit lacatancs cca̱huaniyá̱n pi̱ la̱ntla̱ mili̱kalhacu̱tuycán cha̱tum nataxtuya̱chá̱ hua̱nti̱ naquimacama̱sta̱y c-xmacancán ti̱ quimakni̱putunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xlacán li̱pe̱cua̱ tali̱puhua̱ni̱ko̱lh, chu̱ cha̱tunu̱ tzúculh kalhasquinko̱y: —Quimpu̱chinacán, ¿pi̱ quit? Ni̱ catílalh. ");
INSERT INTO tosNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huata Jesús kalhti̱ko̱lh: —Huá̱ naquimacama̱sta̱y hua̱nti̱ la̱nchú̱ lacxtum quinta̱tamakaju̱ma̱ c-pula̱tu. ");
INSERT INTO tosNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Quit Xatalacsacni Chixcú̱ fuerza̱ nacma̱kantaxti̱y hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ caj quimpa̱lacata, hua̱mpi̱ ¡koxutá̱ yama̱ chixcú̱ hua̱nti̱ naquili̱akskahuinán, chu̱ naquimacama̱sta̱y! Huata luhua xatlá̱n xtihua̱ pi̱ ni̱ xtachixcuhuilani̱t u̱nú̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Hua̱ chú̱ Judas hua̱nti̱ xli̱akskahuinama̱ Jesús chuná̱ kalhásquilh: —Ma̱kalhtahuaka̱ná, ¿ma̱x quit hua̱nti̱ huix li̱chihui̱námpa̱t? Jesús kálhti̱lh: —Ma̱x chuná̱ la̱ntla̱ puhuana. ");
INSERT INTO tosNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Acxni̱ chú̱ luhua xua̱yama̱kó̱, Jesús tíyalh mactum caxtala̱nchu̱, pa̱xcatcatzí̱nilh Dios, lakchákalh, chu̱ ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: —Macxtum cahuátit yuma̱ caxtala̱nchu̱, sa̱mpi̱ caj xta̱chuná̱ li̱taxtuy quintiyatli̱hua. ");
INSERT INTO tosNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A̱li̱sta̱lh tiyapá̱ pa̱tum vaso, pa̱xcatcatzí̱nilh Dios xpa̱lacata, na̱ chuná̱ ma̱xqui̱ko̱lh, chu̱ chuná̱ huaniko̱lh: —Mimpu̱tumcán na̱ cahuátit hua̱ntu̱ taju̱ma̱ c-vaso. ");
INSERT INTO tosNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sa̱mpi̱ quit lacatancs ccahuaniyá̱n pi̱ hua̱ yuma̱ quinkalhni̱ hua̱ntu̱ nama̱luloka̱ pi̱ Dios ta̱tlahuako̱ni̱t tachixcuhuí̱tat aktum xasa̱sti talacca̱xlán la̱ntla̱ nalakma̱xtuko̱y. Nastajtamakán laqui̱mpi̱ chuná̱ lhu̱hua̱ xlacán tla̱n nali̱ma̱tzanka̱nanicán xtala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Xa̱huá̱ quit lacatancs cca̱huaniyá̱n pi̱ nia̱lh pala maktum cactili̱kótnalh xchuchut uva, hasta acxni̱ antá̱ c-xasa̱sti xtapaksi̱t Quintla̱t quit pu̱tum nacca̱ta̱kotnana̱chá̱n tanu̱ xasa̱sti xchuchut uva ni̱ xta̱chuná̱ la̱ntla̱ yumá̱. ");
INSERT INTO tosNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","A̱li̱sta̱lh chú̱ acxni̱ xlacán li̱tli̱ko̱lh aktum tatlí̱n xla tapa̱xcatcatzí̱n anko̱lh c-xaka̱stí̱n huanicán Monte de los Olivos. ");
INSERT INTO tosNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Antá̱ Jesús chuná̱ huaniko̱lh: —Yuma̱ tzi̱sní̱ xli̱pacs huixín naquili̱laclata̱yayá̱tit, chu̱ naquintza̱lamakaná̱tit; sa̱mpi̱ chú̱ nakantaxtuy hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ anta̱ni̱ na̱má̱ huan: ‘Quit nacma̱sta̱y quilhtamacú̱ pi̱ camakni̱ca̱ xmaktakalhná, chu̱ kampu̱tum calhni̱lu̱, pacs nata̱kahuani̱ko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Hua̱mpi̱ acxni̱ clakastakuanani̱ttá nahuán ca̱li̱ní̱n, huata pu̱lh nacca̱pu̱laniyá̱n, nacán c-Galilea laqui̱mpi̱ antá̱ natanoklha̱cha̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Puschí̱ Pedro chuná̱ huánilh: —Ma̱squi xli̱pacs yuma̱ xlacán calaclata̱yako̱lh, quit ni̱ cactitza̱lamakán huata chunacú̱ nacli̱pa̱huaná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús kálhti̱lh: —Pedro, ni̱ pala tzinú̱ catzi̱ya̱ hua̱ntu̱ huix quilhuámpa̱t, sa̱mpi̱ quit lacatancs cuaniyá̱n pi̱ huatiya̱ yuma̱ tzi̱sní, acxni̱ ni̱ a̱tasay nahuán pu̱yu̱ huix aya xli̱maktutu̱ huani̱ta nahuán pi̱ ni̱ quilakapasa. ");
INSERT INTO tosNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro huanipá̱: —Hasta ma̱squi lapi̱ xlí̱lat nacta̱ni̱yá̱n, hua̱mpi̱ niucxni̱ nacuán pala ni̱ clakapasá̱n. Xli̱pacs xa̱makapitzi̱n xli̱ma̱kalhtahuáka̱t, pacs na̱ chuná̱ huanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pus aya tita̱chinko̱lh Jesús lacatum ca̱quihuí̱n anta̱ni̱ huanicán Getsemaní. Acxni̱ antá̱ xuilako̱chá, chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Unú̱ catahuilátit xli̱makua u̱cán a̱nú̱ tlahuay quioración. ");
INSERT INTO tosNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xma̱n huá̱ ta̱anko̱lh Pedro, chu̱ yama̱ cha̱tuy xlakkahuasan Zebedeo, Santiago, chu̱ Juan. Caj xamaktum tzúculh makcatzi̱y tali̱puhuá̱n, chu̱ xtali̱puhua̱ni̱ma̱, xlakpe̱cuán caj xpa̱lacata̱ tu̱ naakspulay. ");
INSERT INTO tosNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huata chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Nia̱lh lay cpa̱ti̱y yuma̱ tali̱puhuá̱n c-quincuxmú̱n, luhua li̱pe̱cua̱ la̱ntla̱ pa̱ti̱ma̱ quinacú̱, la̱mpala aya cni̱ma̱ cmakcatzi̱y. Huata u̱nú̱ huixín catamakaxtáktit, chu̱ ni̱ calhtatátit. ");
INSERT INTO tosNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús alh tzinú̱ lakamákat, antá̱ tatzokóstalh lí̱cha̱lh xlacán hasta ca̱tiyatna, chu̱ chuná̱ kalhtahuakánilh Dios: “Ta̱ta̱, huá̱ lapi̱ xlí̱lat, catlahua̱ li̱tlá̱n ni̱ xquilákcha̱lh yama̱ tlanca tapa̱tí̱n hua̱ntu̱ naquiakspulay, hua̱mpi̱ ni̱ huá̱ calalh hua̱ntu̱ caj quit quintalacasquín, huata xatlá̱n huá̱ cakantáxtulh mintalacasquín. ");
INSERT INTO tosNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A̱li̱sta̱lh chú̱ táspitli̱ anta̱ni̱ xuilakó̱ xli̱ma̱kalhtahuáka̱t, hua̱mpi̱ acxni̱ xlá̱ lakcha̱nko̱lh xlacán clhtatama̱kó̱. Huánilh Pedro: —¡Pedro! ¿Lá̱ntla̱ pi̱ luhua lhtataputuxni̱yá̱tit? ¿Tú̱ lay macalayá̱tit ni̱ nalhtatayá̱tit ca̱na̱ pi̱ caj hua̱ aktum hora? ");
INSERT INTO tosNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ni̱ calhtatátit, skálalh catahuilátit xa̱huá̱ caxakatlí̱tit Dios laqui̱mpi̱ ni̱ naca̱makatlajayá̱n akskahuiní. Sa̱mpi̱ ma̱squi tlihuaka̱ kalhi̱yá̱tit mintalacapa̱stacnicán, hua̱ mintiyatli̱huacán xli̱ca̱na̱ xaxlajuani, ni̱ kalhi̱y li̱tlihuaka. ");
INSERT INTO tosNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xli̱maktuy ampaj tlahuaniy oración Dios, chu̱ chuná̱ huanipá̱: “Ta̱ta̱, hua̱ palapi̱ ni̱ lay puhuana̱ pi̱ ni̱ xacpá̱ti̱lh xli̱pacs yama̱ tapa̱tí̱n hua̱ntu̱ naquiakspulay, pus caj xma̱n huá̱ cakantáxtulh mintalacasquín.” ");
INSERT INTO tosNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Acxni̱ qui̱taspitpá̱, pi̱ chuna li̱tum xalhtatán ma̱noklhupalako̱lh xli̱ma̱kalhtahuáka̱t sa̱mpi̱ nia̱lh lay xmacalako̱y xlakastapucán caj xpa̱lacata̱ talhtata, lhu̱huatá̱ xlakpi̱tlakuanko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Antá̱ xlá̱ makaxtakpá̱, chu̱ ampaj tlahuay xoración xli̱maktutu. Chunatiya huanipá̱ na̱ la̱ntla̱ xuanini̱t xapu̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Pus acxni̱ chú̱ lakchimpalako̱lh anta̱ni̱ xlacán xuilakó̱ na̱má̱ huaniko̱lh: —¿Lá̱ntla̱ pi̱ chunacú̱ huixín lhtatapá̱tit, chu̱ jaxpá̱tit? Pus castacnántit sa̱mpi̱ chú̱ aya lakcha̱ni̱t hora acxni̱ quit Xatalacsacni Chixcú̱ naquimacama̱sta̱cán c-xlacati̱ncán hua̱nti̱ luhua ni̱ lacuan xtapuhua̱ncan chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Lacapala̱ cata̱quí̱tit, caahuá̱ chú̱, sa̱mpi̱ chú̱ aya talacatzuhui̱ma̱ hua̱nti̱ quimacama̱sta̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chunacú̱ xchihui̱nama̱ Jesús acxni̱ Judas, huachá̱ cha̱tum xli̱kalhacu̱tuycán, pu̱tum ta̱chinko̱lh lhu̱hua̱ chixcuhuí̱n, xlacán xli̱minko̱y xma̱chi̱ti̱cán, chu̱ quihui. Yuma̱ chixcuhuí̱n xma̱lakacha̱ko̱ni̱tanchá̱ xanapuxcun pa̱li̱, xa̱hua̱ lakko̱lutzi̱n judíos hua̱nti̱ xpuxcu̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas xuaniko̱ni̱t pi̱ xma̱kalhtahuaka̱ná̱ hua̱nti̱ xmacama̱sta̱ma̱, pu̱lh nalacatzu̱ca̱ laqui̱mpi̱ chuná̱ nalakapasko̱y, chu̱ nachipacán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pus acxni̱ li̱huana̱ laktalacatzúhui̱lh anta̱ni̱ xyá̱ Jesús, chuná̱ huánilh: —¡Skalhí̱n, ma̱kalhtahuaka̱ná, hasta a̱cu clakchimá̱n! Acxni̱ chuná̱ huaniko̱lh, lacátzu̱cli. ");
INSERT INTO tosNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kálhti̱lh: —Amigo, hua̱ntu̱ huix tani̱ta ma̱kantaxti̱ya, pus lacapala̱ catlahua. Hua̱ chú̱ xalhu̱hua̱ lacapala̱ laktalacatzuhui̱ko̱lh, chipako̱lh Jesús, chu̱ chi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Cha̱nchu̱ cha̱tum hua̱nti̱ xta̱huilakó̱ Jesús, xtat tláhualh xma̱chi̱ti̱, chu̱ ca̱actí̱nilh xtaka̱n cha̱tum cscujni xapuxcu pa̱li̱. ");
INSERT INTO tosNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hua̱mpi̱ Jesús li̱ma̱páksi̱lh: —Catamacanu̱pala̱ mima̱chi̱ti̱ c-xpu̱tanú̱n, sa̱mpi̱ xli̱pacs hua̱nti̱ ma̱chi̱ti̱ li̱makni̱nán, na̱ huá̱ ma̱chi̱ti̱ nali̱makni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Lá̱ntla̱ pi̱ ni̱ catzi̱ya̱ huix pi̱ lapi̱ quit xacli̱squínilh Quintla̱t pi̱ xquimacamínilh lhu̱hua̱ ángeles laqui̱mpi̱ naquimakta̱yay, xlá̱ tla̱n chuj tuncán xtláhualh? ");
INSERT INTO tosNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Hua̱mpi̱ lapi̱ chuná̱ xactláhualh, ni̱ xkantáxtulh hua̱ntu̱ tatzoktahuilani̱t xtachihui̱n Dios c-Li̱kalhtahuaka, anta̱ni̱ huan pi̱ fuerza̱ chuná̱ xli̱kantáxtut hua̱ntu̱ quit naquiakspulay. ");
INSERT INTO tosNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Acxni̱ chuná̱ huánilh Jesús, a̱li̱sta̱lh na̱má̱ huaniko̱lh ti̱ xminko̱ni̱t chipako̱y: —¿Pi̱ cha̱tum tlanca makni̱na̱ chixcú̱ quit quiliucxilhá̱tit huachá̱ li̱li̱taná̱tit machi̱ti̱, chu̱ quihui̱ hua̱ntu̱ naquili̱chipayá̱tit? Quit ankalhí̱n, chu̱ cha̱li̱ cha̱lí̱ xacma̱kalhtahuaka̱ma̱kó̱ tachixcuhuí̱tat c-milaksti̱pa̱ncán antá̱ c-tlanca xtemplo̱ Dios, hua̱mpi̱ ni̱ pala maktum xuántit pala naquinchipayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Hua̱mpi̱ huá̱ chuná̱ li̱tlahuapá̱tit laqui̱mpi̱ ma̱kantaxti̱pá̱tit hua̱ntu̱ tili̱chihui̱nanko̱lh xalakmaka̱n profetas acxni̱ chuná̱ tzokko̱lh pi̱ chuná̱ nalay. Acxni̱ xlá̱ chuná̱ xuanima̱kó̱, xli̱ma̱kalhtahuáka̱t pacs tza̱lamakanko̱lh, chu̱ ca̱ta caj xacstu akxtakya̱huako̱lh xma̱kalhtahuaka̱nacán. ");
INSERT INTO tosNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yama̱ chixcuhuí̱n hua̱nti̱ chi̱le̱nko̱lh Jesús antá̱ ti̱tum li̱cha̱nko̱lh c-xchic xapuxcu pa̱li̱ Caifás xuanicán, anta̱ni̱ pacs xtamakstokko̱ni̱t xma̱kalhtahuaka̱nacan judíos, xa̱hua̱ lakko̱lutzi̱n ma̱paksi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Cha̱nchu̱ Pedro tze̱k csta̱laniti̱lhani̱t hasta li̱cha̱nca̱ Jesús c-xchic Caifás. Xlá̱ tánu̱lh c-li̱pacán, chu̱ cha̱lh c-xtanquilhti̱n chiqui̱ anta̱ni̱ xuilakó̱ policías, antá̱ tahui̱ laqui̱mpi̱ pacs naucxilha̱ hua̱ntu̱ nalay. ");
INSERT INTO tosNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yama̱ chixcuhuí̱n hua̱nti̱ xtamacxtumi̱ko̱ni̱t, antá̱ xuilakó̱ xanapuxcún pa̱lijni, xa̱hua̱ ti̱ xkalhi̱ko̱y xlakasican chixcuhuí̱n hua̱nti̱ pu̱tum xli̱ma̱pa̱cuhui̱ko̱cán La Junta Suprema. Xlacán xmakni̱putunko̱y Jesús, huachá̱ xli̱putzama̱kó̱ ti̱ nali̱ma̱xtuniputún ta̱ksaní̱n la̱ntla̱ tu̱ nali̱ya̱huako̱y Jesús, laqui̱mpi̱ chuná̱ tla̱n nali̱macama̱xqui̱ko̱y ti̱ xkalhi̱ko̱y li̱ma̱paksí̱n namakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Hua̱mpi̱ ma̱squi lhu̱hua̱ ti̱ xli̱ya̱huama̱kó̱, ni̱tu̱ lay xma̱lulokniko̱y, xa̱huachí̱ lhu̱hua̱ ti̱ talacnu̱ko̱lh pi̱ nama̱xtuniko̱y ta̱ksaní̱n, hua̱mpi̱ ma̱squi luhua chuná̱ tlahuako̱lh ni̱tú̱ ma̱tla̱ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hua̱mpi̱ a̱li̱sta̱lh chinko̱lh cha̱tuy chixcuhuí̱n hua̱nti̱ luhua xma̱lulokma̱kó̱ acxni̱ chuná̱ xquilhuama̱kó̱: —Maktum quin ckaxmatni̱tahu pi̱ yuma̱ chixcú̱ na̱má̱ xquilhuama̱: ‘Quit tla̱n naclactlahuay tlanca xtemplo̱ Dios hua̱mpi̱ caj xli̱aktutu quilhtamacú̱ nactlahuapalay tanu̱ xasa̱sti.’ ");
INSERT INTO tosNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Xapuxcu pa̱li̱ tuncán tá̱yalh, chu̱ kalhásquilh Jesús: —¿Tú̱huan ni̱tú̱ kalhti̱nana̱ laqui̱mpi̱ natakalhmakta̱yaya? ¿Tú̱ kaxpátpa̱t hua̱ntu̱ ma̱lulokko̱y yuma̱ chixcuhuí̱n c-mimpa̱lacata? ");
INSERT INTO tosNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Hua̱mpi̱ huata Jesús caj huá̱ cacs tá̱yalh xta̱chuná̱ la̱mpala ni̱ káxmatli, chu̱ yama̱ xapuxcu pa̱li̱ kalhasquimpá̱: —Dios xastacná̱ calhcuyuya̱huán lapi̱ naquinca̱akskahuiya, cli̱ma̱paksi̱yá̱n pi̱ naquinca̱huaniya̱ lapi̱ xli̱ca̱na̱ pi̱ huix Cristo, xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús kálhti̱lh: —Xli̱ca̱na̱ xlá̱ pi̱ quit Cristo, hua̱mpi̱ na̱ luhua lacatancs cca̱huaniyá̱n pi̱ huixín naquiucxilhá̱tit acxni̱ quit Xatalacsacni Chixcú̱ cuilachá nahuán c-xpakstacat xpu̱ma̱paksi̱n Dios hua̱nti̱ huilachá̱ c-akapú̱n, chu̱ na̱ naquiucxilhá̱tit acxni̱ antá̱ nacmimpalaya̱chá̱ xli̱maktuy, antá̱ cmímaj nahuán c-xlacni puclhni. ");
INSERT INTO tosNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yama̱ xapuxcu pa̱li̱ acxni̱ káxmatli̱ yumá̱, xti̱t lactláhualh xlháka̱t caj xtasi̱tzi, chu̱ chuná̱ na̱má̱ huaniko̱lh a̱makapitzí̱n: —Xli̱ca̱na̱ pi̱ caj xpa̱lacata hua̱ntu̱ chihui̱nani̱t yuma̱ chixcú̱ ta̱la̱lacata̱qui̱ni̱t Dios. ¿Tú̱ taji̱ tili̱lacasquina̱hu ma̱luloknaní̱n? Pus huixiná̱ ma̱n kaxpatni̱tántit la̱ntla̱ caj tama̱xcajua̱li̱n xtachihuí̱n li̱ta̱la̱lacata̱qui̱ni̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Lá̱ huixín puhuaná̱tit? ¿Tú̱ natlahuaniya̱hu? Cha̱nchu̱ xlacán kalhti̱nanko̱lh, huanko̱lh: —Tama̱ chixcú̱ fuerza̱ mini̱niy pi̱ nani̱y sa̱mpi̱ kalhi̱y xtala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","A̱li̱sta̱lh caj tzúculh li̱kama̱nanko̱y, lacachujmani̱ko̱lh, chu̱ li̱pe̱cua̱ ma̱sipa̱ni̱ko̱lh. Na̱ xuí̱ makapitzí̱n ti̱ tzúculh lakalasko̱y, ");
INSERT INTO tosNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na̱má̱ xuaniko̱y: —Hua̱ lapi̱ xli̱ca̱na̱ huix Cristo, pus cahuanti̱ lapi̱ lakapasa̱ ti̱ huili̱nimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Cha̱nchu̱ Pedro, antá̱ caj cacs xuí̱ c-xtanquilhti̱n chiqui̱ c-xpu̱lacni li̱pacán, antiyá̱ ni̱ xtamakaxtakni̱t acxni̱ antá̱ chá̱lh. Caj li̱puntzú̱ laktalacatzúhui̱lh cha̱tum tzuma̱t maksquití, huánilh: —Clakapasá̱n, sa̱mpi̱ na̱ xa̱ huix ti̱ xta̱lapu̱laya̱ tama̱ Jesús xala c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Hua̱mpi̱ cumu luhua lhu̱hua̱ xtzamacán Pedro kalhtátze̱kli, ni̱ li̱tá̱yalh, na̱má̱ chú̱ kálhti̱lh: —Ma̱x ta̱kskahuípa̱t, sa̱mpi̱ quit ni̱ ccatzi̱y hua̱ntu̱ huix quili̱ya̱huápa̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","A̱li̱sta̱lh táxtulh quilhtí̱n, luhua xcha̱majá̱ c-xama̱laccha li̱pacán acxni̱ cha̱tum tanu̱ maksquití̱ úcxilhli̱, chu̱ chuná̱ huaniko̱lh hua̱nti̱ antá̱ lacatzú̱ xya̱kó̱: —Xli̱ca̱na̱ xlá̱ pi̱ yuma̱ chixcú̱ na̱ huá̱ xta̱lapu̱lay Jesús xala c-Nazaret. ");
INSERT INTO tosNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huata Pedro kalhtatze̱kpá̱, catu̱hua̱ tachihuí̱n tzúculh li̱quilhán laqui̱mpi̱ chuná̱ mat naca̱najlanicán hua̱ntu̱ xlá̱ xquilhuama̱, chu̱ chuná̱ huánilh: —Tancs cuaniyá̱n pi̱ ni̱ clakapasa̱ tama̱ chixcú̱ hua̱nti̱ huix ma̱pa̱cuhuí̱pa̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Caj tzinú̱ a̱li̱sta̱lh, yama̱ chixcuhuí̱n hua̱nti̱ antá̱ xlaya̱kó̱ xlacán tilaktalacatzuhui̱ko̱lh Pedro, chu̱ chuná̱ huaniko̱lh: —Luhua maktum xli̱ca̱na̱ pi̱ na̱ huix cha̱tum xlacán ti̱ xta̱lama̱kó̱ tama̱ chixcú, sa̱mpi̱ caj mintachihuí̱n li̱talakapasa̱ pi̱ luhua xta̱chuná̱ chihui̱nana̱ la̱ntla̱ chihui̱nán xlá. ");
INSERT INTO tosNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Puschí̱ tzúculh aklhu̱hua̱tnán, hasta Dios xli̱quilhán laqui̱mpi̱ caca̱najlanica̱ pi̱ tancs xchihui̱nama̱, huá̱: —Tancs cuaniyá̱n pi̱ ni̱ clakapasa̱ tama̱ chixcú̱ hua̱nti̱ huixín ma̱pa̱cuhui̱pá̱tit. Acxnitiyá̱ chú̱ tásalh tantum pu̱yu̱. ");
INSERT INTO tosNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Cha̱nchu̱ Pedro na̱ acxnicú̱ lacapá̱stacli̱ xtachihui̱n Jesús hua̱ntu̱ xuanini̱t: ‘Acxni̱ ni̱ a̱tasay nahuán pu̱yu̱ huix aya xli̱maktutu̱ huani̱ta nahuán pi̱ ni̱ quilakapasa.’ Acxni̱ chú̱ lacapa̱stacko̱lh lacapala̱ táxtulh c-quilhtí̱n c-tiji, chu̱ antá̱ tzúculh tasay caj xtali̱puhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Acxni̱ chú̱ tituncúhuilh, tamakstokko̱lh xli̱pacscan xanapuxcun pa̱lijni, chu̱ lakko̱lún hua̱nti̱ xpuxcu̱naniko̱y judíos, luhua lacxtum li̱catzi̱ko̱lh xatú̱ nali̱ya̱huako̱y Jesús acxni̱ namacama̱sta̱ko̱y c-xlacati̱n gobernador romano laqui̱mpi̱ xlá̱ namakni̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xlacán tla̱n macachi̱ko̱lh, antá̱ le̱niko̱lh c-xlacati̱n gobernador hua̱nti̱ xuanicán Pilato. ");
INSERT INTO tosNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cha̱nchu̱ Judas hua̱nti̱ xmacama̱sta̱ni̱t, acxni̱ úcxilhli̱ pi̱ xtamakstuntlahuani̱t Jesús, aya xli̱lhca̱cani̱t pi̱ namakni̱cán, huata a̱tuyá̱ tipuhua̱, tzúculh li̱puhuán; lacapala̱ lakanko̱lh xanapuxcun pa̱lijni, na̱ antá̱ xuilakó̱ lakko̱lun ma̱paksi̱naní̱n, xma̱pu̱spitniputunko̱y tumi̱n puxamaca̱hu xla plata. ");
INSERT INTO tosNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Acxni̱ lakcha̱nko̱lh chuná̱ huaniko̱lh: —Quit cca̱lakmimá̱n, cmimá̱n ca̱pu̱spitniyá̱n mintumi̱n, sa̱mpi̱ ctlahuani̱t tala̱kalhí̱n pi̱ cca̱macama̱xqui̱ni̱tán cha̱tum chixcú̱ hua̱nti̱ ni̱tú̱ le̱n xtala̱kalhí̱n laqui̱mpi̱ huixín namakni̱yá̱tit. Hua̱mpi̱ huata xlacán chuná̱ kalhti̱ko̱lh: —Hua̱ pala tú̱ nalaniya, tamá̱ quin ni̱ quincui̱ntajcán, huix ti̱ tú̱ caacxtulacca̱xtlahua. ");
INSERT INTO tosNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas xputzama̱ talacca̱xlán xpa̱lacata xtala̱kalhí̱n hua̱ntu̱ xtlahuani̱t, maktum lhkan ma̱kósulh yama̱ tumi̱n c-xpu̱lacni templo, chu̱ tuncán taquilhánu̱lh alh anta̱ni̱ xacstu tapixchi̱tahuácalh. ");
INSERT INTO tosNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Cha̱nchu̱ xanapuxcun pa̱lijni̱ sacqui̱ko̱lh yama̱ tumi̱n xla plata, chu̱ chuná̱ la̱huaniko̱lh: —Yuma̱ tumi̱n xtápalh tu̱ li̱taxokoni̱t xlatáma̱t cha̱tum chixcú̱ laqui̱mpi̱ namakni̱cán, huá̱ xpa̱lacata ni̱ lakchá̱n namuju̱ya̱hu c-xpu̱ma̱qui̱can ofrenda. ");
INSERT INTO tosNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Huata xatlá̱n lacxtum lacca̱xlako̱lh pi̱ namaktama̱huako̱y xpu̱cuxtu cha̱tum chixcú̱ xtlahuana xa̱lu̱, laqui̱mpi̱ antá̱ nama̱acnu̱ko̱cán hua̱nti̱ caj antá̱ nani̱tamakán, chu̱ hua̱nti̱ ni̱ antá̱ xalaní̱n, caj xamini. ");
INSERT INTO tosNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pus huá̱ xpa̱lacata, yuma̱ pú̱cuxtu̱ li̱ma̱pa̱cuhui̱cán hasta la̱nchú̱ Campo de Sangre. ");
INSERT INTO tosNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Puschí̱ chuná̱ xlacán li̱ma̱kantaxti̱ko̱lh hua̱ntu̱ maka̱n quilhtamacú̱ títzokli̱ profeta Jeremías c-Li̱kalhtahuaka̱ anta̱ni̱ chuná̱ huan: “Tiyaca̱ yama̱ puxamaca̱hu tumi̱n xla plata, hua̱ xtápalh tu̱ xli̱lacca̱xlako̱ni̱t makapitzí̱n xala c-Israel pi̱ nali̱macama̱sta̱cán cha̱tum chixcú, ");
INSERT INTO tosNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na̱ huá̱ li̱xokoca̱ xpu̱cuxtu xtlahuana xa̱lu̱ xta̱chuná̱ la̱ntla̱ quili̱ma̱páksi̱lh Quimpu̱chinacán pi̱ nactzoka̱ c-quilibro.” ");
INSERT INTO tosNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Acxnitiyá̱ antá̱ xyá̱ Jesús anta̱ni̱ xli̱cha̱ncani̱t c-xlacati̱n gobernador, chu̱ xlá̱ kalhásquilh: —¿Pi̱ xli̱ca̱na̱ huix xReycan judíos? —Xli̱ca̱na̱ xlá, luhua lacatancs la̱ huana —kalhtí̱nalh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hua̱mpi̱ a̱li̱sta̱lh acxni̱ xanapuxcun pa̱lijni, chu̱ lakko̱lun ma̱paksi̱naní̱n catu̱huá̱ tu̱ tzúculh li̱ya̱huako̱y ta̱ksaní̱n, Jesús ni̱ pala kalhtum tachihuí̱n xkalhtí̱nalh tu̱ xli̱ya̱huama̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pus huá̱ xpa̱lacata Pilato chuná̱ kalhásquilh: —¿Lá̱ntla̱ pi̱ ni̱tú̱ catili̱kalhtí̱nanti? ¿Tú̱ kaxpata̱ pi̱ catu̱huá̱ li̱ya̱huama̱kó̱n yuma̱ chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Hua̱mpi̱ huata Jesús a̱tzinú̱ luhua caj cacs tá̱yalh, chu̱ ni̱tú̱ kalhtí̱nalh. Chuna̱mpi̱ gobernador Pilato luhua lanaj li̱lacahua̱ acxni̱ úcxilhli̱ pi̱ yama̱ chixcú̱ ni̱tú̱ xkalhti̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Xli̱ankalhí̱n Pilato xli̱smani̱ni̱t pi̱ ca̱ta ca̱ta̱ xmakaxtakniko̱y judíos cha̱tum tachí̱n acxni̱ xlakcha̱ná̱ xpa̱scuajcán xla ta̱kspuntza̱lí̱n, la̱ntla̱ chá̱ xatí̱ nalacsacko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pus luhua acxni̱ yama̱ quilhtamacú̱ xtanu̱ma̱ c-pu̱la̱chi̱n cha̱tum tlanca lu̱cuj chixcú, luhua xatalakapasni̱ hua̱nti̱ xuanicán Barrabás. ");
INSERT INTO tosNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Chuná̱ pi̱ Pilato acxni̱ úcxilhli̱ pi̱ aya macxtum xya̱kó̱ lhu̱hua tachixcuhuí̱tat, pus kalhasquinko̱lh: —¿Xatí̱ huixín lacasquiná̱tit nacca̱macama̱xqui̱yá̱n yuma̱ ca̱ta, ¿pi̱ hua̱ Barrabás, usu yuma̱ Jesús hua̱nti̱ na̱ li̱tapa̱cuhui̱y Cristo? ");
INSERT INTO tosNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Huá̱ chuná̱ li̱huaniko̱lh Pilato sa̱mpi̱ xlá̱ lacatancs xcatzi̱y pi̱ cumu caj xquiclhcatzaniko̱y Jesús huá̱ xli̱macama̱sta̱ko̱ni̱t c-xlacati̱n xpu̱ma̱paksí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Acxni̱ Pilato ni̱tú̱ xa̱lacca̱xtlahuay yuma̱ talakapútzi̱t, xlá̱ xuí̱ c-xlactahui̱lh xla ma̱paksi̱ná̱ acxni̱ chilh cha̱tum chixcú̱ hua̱nti̱ xmima̱ huaniy xtachihui̱n xpusca̱t hua̱ntu̱ xmacaminima̱, chu̱ chuna̱ na̱má̱ xuanima̱: “¡Luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n, ni̱tú̱ tili̱paktanu̱ya̱ huix tama̱ chixcú̱ hua̱nti̱ ni̱tú̱ xtala̱kalhí̱n pala tu̱ nali̱ya̱huaya! Sa̱mpi̱ yuma̱ tzi̱sní̱ quit luhua li̱pe̱cua̱ la̱ntla̱ cli̱ma̱níxnalh caj xpa̱lacata.” ");
INSERT INTO tosNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pus acxni̱ yama̱ xanapuxcun pa̱lijni, xa̱hua̱ lakko̱lun ma̱paksi̱naní̱n kaxmatko̱lh hua̱ntu̱ xma̱lacnu̱nima̱kó̱ Pilato, xlacán chihui̱nama̱xqui̱ko̱lh xli̱lhu̱hua chixcuhuí̱n pi̱ huá̱ casquinko̱lh camakaxtakca̱ Barrabás, chu̱ na̱ cahuanko̱lh pi̱ maktum camakni̱ca̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobernador Pilato kalhasquimpalako̱lh xli̱maktuy: —¿Xatí̱ yumá̱ luhua lacasquiná̱tit nacca̱makaxtakniyá̱n, pá̱ hua̱ Barrabás, usu hua̱ Jesús? Xlacán kalhti̱nanko̱lh: —¡Huá̱ camakáxtakti̱ Barrabás! ");
INSERT INTO tosNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kalhasquimpalako̱lh: —Hua̱mpi̱ chi̱nchu̱ yuma̱ Jesús hua̱nti̱ li̱ma̱xtuputuncán Cristo mima̱laktaxti̱nacán, ¿tú̱ chú̱ quit nactlahuaniy? Li̱macxtum kalhti̱nanko̱lh: —¡Capakaxtokohuaca̱ c-cruz! ");
INSERT INTO tosNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xlá̱ huanipalako̱lh: —Hua̱mpi̱ caquihuanítit, ¿tú̱ tlahuani̱t hua̱ntu̱ ni̱tlá̱n? Huata xlacán caj tzucupaj quilhaniko̱y: —¡Capakaxtokohuaca̱ c-cruz! ");
INSERT INTO tosNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Acxnicú̱ Pilato luhua li̱huana̱ cátzi̱lh pi̱ ni̱ lay xma̱tla̱ni̱y xpa̱lacata namakaxtaka̱ Jesús, hua̱mpi̱ xli̱lhu̱hua̱ huata caj ca̱x xca̱tasama̱kó̱ pi̱ namakni̱cán, pus huá̱ xpa̱lacat’ li̱ma̱tiyí̱nalh paktum actzu̱ bandeja̱ chúchut, chu̱ acxni̱ tzúculh makachakán c-xlacati̱ncán chuná̱ huaniko̱lh: —¡Hua̱ lapi̱ tú̱ natlahuaniyá̱tit tama̱ chixcú, quit ni̱ quincui̱nta̱! Xa̱huachí̱ huixín naxoko̱naná̱tit xpa̱lacata̱ pi̱ namakni̱yá̱tit, sa̱mpi̱ ni̱tú̱ cli̱ma̱lacapu̱y quit, xlá̱ ni̱ kalhi̱y xtala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huata xli̱lhu̱hua chixcuhuí̱n quilhminko̱chá, chu̱ na̱má̱ kalhti̱nanko̱lh: —¡Pus ma̱squi quin xa̱hua̱ quincamancán caquinca̱tahuacanichá̱n tala̱kalhí̱n, chu̱ li̱xokó̱n xpa̱lacata pi̱ nacmakni̱ya̱hu yuma̱ chixcú! ");
INSERT INTO tosNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Puschí̱ Pilato makaxtakniko̱lh Barrabás, chu̱ xli̱ma̱paksí̱nalh pi̱ casnokca̱ Jesús. A̱li̱sta̱lh chú̱ macama̱xqui̱ko̱lh xtropa̱ laqui̱mpi̱ xlacán napakaxtokohuacako̱y c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Cha̱nchu̱ yama̱ xtropa̱ ma̱paksi̱ná̱ le̱nko̱lh Jesús c-xtanquilhti̱n xpu̱ma̱paksi̱n gobernador, chu̱ na̱ antá̱ tamacxtumi̱ko̱lh xa̱makapitzi̱n xta̱tropa̱cán, chu̱ li̱tamakstiliko̱lh Jesús xli̱pacs kampu̱tum tropa̱. ");
INSERT INTO tosNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xlacán ma̱lakxtuko̱lh xlhaka̱t Jesús, chu̱ ma̱lhaka̱ko̱lh mactum luhua tzutzoko li̱la̱ lháka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cha̱tum tropa̱ huilí̱nilh c-xakxe̱ka̱ aktum corona tu̱ xli̱katstilini̱t lhtucú̱n, na̱ ma̱chipi̱ko̱lh kantum lasasa quihui̱ c-xpakstacat xmacán. A̱li̱sta̱lh chú̱ tzucuko̱lh li̱kama̱nanko̱y, lakatatzokostako̱lh, chu̱ chuná̱ tzúculh huaniko̱y: —¡Caxani̱li̱huayá̱ calatapa̱ huix xreycan judíos! ");
INSERT INTO tosNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Makapitzí̱n xchujmani̱ma̱kó̱, maklhti̱ko̱lh yama̱ lasasa quihui̱ tu̱ xma̱chipi̱ko̱ni̱t, chu̱ pi̱ huatiya̱ xlit xli̱aksnokko̱y c-xakxe̱ka. ");
INSERT INTO tosNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Acxni̱ chú̱ li̱tlakuanko̱lh la̱ntla̱ xli̱kama̱nama̱kó̱ tropa̱, pus ma̱lakxtupalako̱lh xatzutzoko lháka̱t hua̱ntu̱ xma̱lhaka̱ko̱ni̱t, chu̱ huá̱ ma̱lhaka̱palako̱lh xlháka̱t Jesús. Acxnitiyá̱ chú̱ le̱nca̱ laqui̱mpi̱ napakaxtokohuacako̱y c-aktum cruz. ");
INSERT INTO tosNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yama̱ tropa̱ ma̱cuqui̱ko̱lh Jesús kantum cruz, chu̱ antá̱ xle̱ma̱kó̱ anta̱ni̱ napakaxtokohuacako̱y. Xpuntaxtuma̱ko̱lhá̱ ca̱chiquí̱n acxni̱ pa̱xtokko̱lh cha̱tum chixcú̱ xuanicán Simón, xala c-Cirene xuani̱t. Acxni̱ xlacán ucxilhko̱lh, chipako̱lh, chu̱ fuerza̱ ma̱le̱ni̱ko̱lh xcruz Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Acxni̱ chú̱ cha̱nko̱lh lacatum anta̱ni̱ huanicán Gólgota (yuma̱ tachihuí̱n huamputún: “Xaclucut Ni̱n”), ");
INSERT INTO tosNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","antá̱ tima̱hui̱putunko̱lh vinagre hua̱ntu̱ xlakmaca̱ncani̱t xu̱n lí̱cuchun, hua̱mpi̱ acxni̱ Jesús kalhuá̱nalh xlá̱ ni̱ huapútulh. ");
INSERT INTO tosNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Acxni̱ chú̱ xpakaxtokohuacacani̱ttá̱ c-cruz yama̱ tropa̱ ma̱akpitziko̱lh xlháka̱t, caj tili̱maca̱nko̱lh suerte xatí̱ tla̱n nalakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A̱li̱sta̱lh caj tahuilako̱lh laqui̱mpi̱ namaktakalhko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yama̱ tropa̱ na̱ xtokoko̱lh c-xacpu̱n xcruz Jesús paktum tama̱ anta̱ni̱ chuná̱ na̱má̱ xtatzokni̱t: “Hua̱ yumá̱ Jesús xReycan judíos.” ");
INSERT INTO tosNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chu̱ na̱ luhua lacxtum tita̱pakaxtokohuacako̱ca̱ cha̱tuy kalha̱naní̱n, cha̱tum huaca̱ c-xpakstácat, chu̱ hua̱ a̱cha̱tum c-xpakxuqui. ");
INSERT INTO tosNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Makapitzí̱n hua̱nti̱ antá̱ xti̱taxtuti̱lhako̱y c-tiji̱ xma̱xcajua̱li̱ko̱y, chu̱ na̱ xli̱ta̱cchiquiko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Xuaniko̱y: —¡Chi̱nchu̱ cumu huix huana̱ pi̱ tla̱n nalactlahuaya̱ tlanca xtemplo̱ Dios, chu̱ caj xli̱aktutu quilhtamacú̱ nali̱ya̱huapalaya̱ tanu̱ xasa̱sti, pus chú̱ cata̱cta̱ c-cruz lapi̱ ca̱na̱ huana̱ laqui̱mpi̱ quin naccatzi̱ya̱hu lapi̱ xli̱ca̱na̱ huix xCam Dios! ");
INSERT INTO tosNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pus na̱ chuná̱ xli̱kalhkama̱nanko̱y hua̱ xanapuxcun pa̱lijni, xa̱hua̱ laktzokqui̱naní̱n, chu̱ lakko̱lun ma̱paksi̱naní̱n hua̱nti̱ na̱ antá̱ xlaya̱kó̱, xuanko̱y: ");
INSERT INTO tosNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—¡Xli̱ca̱na̱ luhua tla̱n xlá̱ ma̱laktaxti̱ko̱lh xa̱makapitzí̱n, hua̱mpi̱ xacstu ni̱ lay ma̱laktaxti̱cán! Pus lapi̱ xli̱ca̱na̱ huá̱ chú̱ Rey xala c-Israel, pus lacapala̱ catáactalh c-cruz laqui̱mpi̱ quin na̱ nali̱pa̱huana̱hu, chu̱ naca̱najlaya̱hu pi̱ huá̱ quima̱laktaxti̱nacán. ");
INSERT INTO tosNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xlá̱ huan pi̱ mat xli̱ca̱na̱ li̱pa̱huán Dios sa̱mpi̱ mat huá̱ xCam, pus chú̱ camilh makta̱yay lapi̱ xli̱ca̱na̱ xlá̱ luhua lakalhamán, sa̱mpi̱ chuná̱ quinca̱huanini̱tán pi̱ xli̱ca̱na̱ huá̱ xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chu̱ hasta na̱ chuná̱ xlacama̱huacako̱y kalha̱naní̱n hua̱nti̱ xta̱pakaxtokohuacako̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yama̱ quilhtamacú̱, ma̱x la̱mpala ca̱tastúnut xuani̱t, acxni̱ chunata la̱ntla̱ titapaklhtu̱ti̱ko̱lh la̱ntla̱ xli̱ca̱tlanca̱ yama̱ tíyat, chu̱ hasta ca̱maktutu hora xala ca̱ko̱tanú̱n a̱cu ca̱xkakapá̱. ");
INSERT INTO tosNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Na̱ luhua acxnitiyá̱ chú̱ yama̱ hora Jesús luhua palha̱ chuná̱ ca̱tásalh: “Elí, Elí, ¿lama sabactani?” (Yuma̱ tachihuí̱n huamputún: “Ta̱ta̱ Dios, ¿tú̱huan lhtuj quimakaxtakni̱ta?”) ");
INSERT INTO tosNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Makapitzi̱n chixcuhuí̱n hua̱nti̱ antá̱ xlaya̱kó̱ kaxmatko̱lh tu̱ Jesús xquilhuama̱, chu̱ chuná̱ huanko̱lh: —Yuma̱ chixcú̱ tasanima̱ xamaka̱n profeta Elías xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cha̱tum lacapala̱ alh putzay actzu̱ panáma̱c, xlá̱ li̱huana̱ lí̱lupli̱ xaxcuta vinagre, antá̱ chú̱ ma̱láknu̱lh c-kantum lasasa, cha̱nchu̱ huá̱ chú̱ li̱cháxnilh hasta c-xquilhni̱ Jesús laqui̱mpi̱ nahuay. ");
INSERT INTO tosNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hua̱mpi̱ huata xa̱makapitzí̱n xuanko̱y: —¡Ni̱ chuná̱ catlahua̱ la̱ntamá̱! Catahuacaka̱lh, calaka̱lh chú̱ pala namín lakma̱xtuy profeta Elías xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús a̱maktum palha̱ ca̱tásalh, chu̱ acxnitiyá̱ ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na̱ luhua acxni̱ chú̱ yama̱ li̱lakatlapá̱n hua̱ntu̱ xli̱lakatlapa̱nancán c-tlanca templo xala c-Jerusalén, pu̱makatuy tihua̱ la̱ntla̱ xacstu talácxti̱tli, tzucuchá̱ ta̱lhmá̱n hasta tu̱tzú̱. Xli̱ca̱tlanca̱ tíyat tachiquiko̱lh, chu̱ na̱ chuná̱ lactlanca chíhuix pu̱makatuy huá̱ la̱ntla̱ taska̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lhu̱hua tahuaxni, usu lhucu̱ c-pu̱ta̱cnú̱n talacqui̱ko̱lh anta̱ni̱ xma̱acnu̱ko̱cani̱t hua̱nti̱ xamaka̱n quilhtamacú̱ xli̱pa̱huanko̱ni̱t Dios, chu̱ hua̱nti̱ aya xni̱ko̱ni̱ttá, pus xlacán lakastakuananko̱lh ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A̱li̱sta̱lh acxni̱ Jesús lakastakuanánalh ca̱li̱ní̱n xlacán titaxtuko̱lh c-pu̱ta̱cnú̱n, chu̱ titanu̱ko̱lh c-Jerusalén, na̱ lhu̱hua̱ ti̱ ucxilhko̱lh pi̱ xlakastakuananko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Yama̱ capitán, xa̱hua̱ makapitzi̱n tropa̱ ti̱ xmaktakalhma̱kó̱ Jesús, acxni̱ xlacán ucxilhko̱lh la̱ntla̱ xtachiquima̱ tíyat, chu̱ xlaktzankama̱, xlacán li̱pe̱cua̱ tipe̱cuanko̱lh, chu̱ chuná̱ huanko̱lh: —¡Xli̱ca̱na̱ hua̱ yuma̱ cha̱tum chixcú̱ xCam Dios xuani̱t! ");
INSERT INTO tosNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Antá̱ tzinú̱ lakamákat xlaya̱kó̱ makapitzi̱n lacchaján hua̱nti̱ a̱huatá̱ csta̱laniko̱ni̱tanchá̱ Jesús c-Galilea, chu̱ xmakta̱yako̱ni̱t acxni̱ xlá̱ xli̱chihui̱nama̱ xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Antá̱ xmaklaya̱ María Magdalena, xa̱hua̱ María hua̱nti̱ xtzi Santiago, chu̱ José; chu̱ na̱ antá̱ xlaya̱ xpusca̱t Zebedeo. ");
INSERT INTO tosNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Acxni̱ ko̱tánu̱lh yama̱ quilhtamacú̱, cha̱tum chixcú ma̱tamacu̱nú, xuanicán José xala c-Arimatea, hua̱nti̱ na̱ xli̱pa̱huán Jesús, ");
INSERT INTO tosNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","xlá̱ alh ta̱chihui̱nán gobernador Pilato, huánilh pi̱ camá̱xqui̱lh talacasquín laqui̱mpi̱ nama̱acti̱y, chu̱ nama̱acnu̱y xtiyatli̱hua. Pilato tla̱n tláhualh hua̱ntu̱ huanica̱, chu̱ ma̱paksí̱nalh pi̱ cama̱xqui̱ca̱ xtiyatli̱hua Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José lacapala̱ alh, chu̱ má̱acti̱lh Jesús; xlá̱ li̱huana̱ li̱pu̱máksuitli̱ mactum xachakani sábana. ");
INSERT INTO tosNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Cha̱nchu̱ antá̱ chú̱ má̱acnu̱lh c-aktum xasa̱sti tahuaxni̱ hua̱ntu̱ ma̱n xma̱lacahuaxni̱nani̱t c-xlacan sipi̱. Acxni̱ chú̱ ca̱xma̱mi̱ko̱lh Jesús c-xpu̱lacni̱ yama̱ lhucu, li̱huana̱ li̱lakatálalh anta̱ni̱ xlactanu̱cán c-lhucu̱ aktum tlanca chíhuix. ");
INSERT INTO tosNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hua̱mpi̱ huata yama̱ cha̱tuy lacchaján María Magdalena, chu̱ cha̱tum li̱tum María, antá̱ xlacán xuilakó̱ lacatzú̱ c-tahuaxni, chu̱ pacs xucxilhma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Li̱cha̱lí̱ chú̱ sábado acxni̱ xlakcha̱ni̱t quilhtamacú̱ la̱ntla̱ jaxcán, yama̱ xanapuxcun pa̱lijni, xa̱hua̱ fariseos macxtum lakanko̱lh Pilato, ");
INSERT INTO tosNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","chu̱ chuná̱ huaniko̱lh: —Señor gobernador, yama̱ aksani̱na̱ chixcú̱ hua̱nti̱ makni̱ni̱tahu, xlá̱ xli̱ta̱kalhchihui̱nanko̱y tachixcuhuí̱tat acxni̱ xlamajcú̱ pi̱ xli̱aktutu quilhtamacú̱ xlá̱ nalakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huá̱ cmimá̱n ca̱li̱huaniyá̱n pi̱ xma̱paksi̱kó̱ mintropa̱ laqui̱mpi̱ xanko̱lh maktakalhnanko̱y aktutu quilhtamacú̱, ni̱ xahua̱ xamaktum nascacaminko̱y xli̱ma̱kalhtahuáka̱t, a̱li̱sta̱lh chú̱ naquilhtzucupalako̱y c-xlacati̱ncán xli̱lhu̱hua̱ tachixcuhuí̱tat pi̱ lakastakuánalh ca̱li̱ní̱n. Pus a̱li̱sta̱lh chú̱ yuma̱ ta̱ksaní̱n luhua tlanca̱ naqui̱taxtuy ni̱ xahua̱ la̱ntla̱ xli̱kalhchihui̱nancán xapu̱lana̱. ");
INSERT INTO tosNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kalhti̱ko̱lh: —Pus lacapala̱ cama̱ca̱xkó̱tit tropa̱, chu̱ huixín ma̱n caca̱xtlahuátit la̱ntla̱ lacasquiná̱tit namaktakalhnanko̱y laqui̱mpi̱ ni̱tú̱ nakalhancán c-pu̱ta̱cnu̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yama̱ chixcuhuí̱n qui̱lako̱lh c-lhucu̱ anta̱ni̱ xma̱acnu̱cani̱t Jesús, luhua li̱huana̱ sellartlahuako̱lh xlacán yama̱ tahuaxni̱ anta̱ni̱ xuí̱ tlanca chíhuix hua̱ntu̱ xli̱lakatalacani̱t, chu̱ antá̱ makaxtakko̱ca̱ tropa̱ laqui̱mpi̱ xlacán namaktakalhnanko̱y tantacú̱, chu̱ tantascaca. ");
INSERT INTO tosNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Acxni̱ xti̱taxtuni̱ttá̱ sábado xli̱jaxatcan judíos, chu̱ aya xca̱xkakama̱ lacatzi̱sa̱ domingo, María Magdalena, chu̱ cha̱tum ti̱ na̱ María xuanicán qui̱lako̱lh anta̱ni̱ xma̱acnu̱cani̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hua̱mpi̱ acxni̱ ni̱ xa̱cha̱nko̱y caj xamaktum li̱pe̱cua̱ tzúculh tachiquiy tíyat sa̱mpi̱ cha̱tum xángel Dios ta̱ctachi̱ ca̱tiyatna, chu̱ antá̱ chilh c-lhucu̱ anta̱ni̱ xma̱acnu̱cani̱t Jesús. Xlá̱ talacatzúhui̱lh c-tahuaxni, chu̱ ma̱pá̱nu̱lh yuma̱ tlanca chíhuix hua̱ntu̱ xli̱lakatalacani̱t. A̱li̱sta̱lh chú̱ antá̱ culucs lactahui̱ c-xokspún. ");
INSERT INTO tosNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Luhua tlayajua̱ xtasiyuy xta̱chuná̱ la̱ntla̱ maklípit, chi̱nchu̱ xlháka̱t luhua snapapa̱ xtasiyuy xta̱chuná̱ la̱ntla̱ miqui, usu xaseda̱ lháka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Acxni̱ yama̱ tropa̱ ucxilhko̱lh, xli̱ca̱na̱ luhua pe̱cuanko̱lh caj xpa̱lacata̱ tu̱ xucxilhma̱kó̱, hasta caj xtape̱cuacán tzucuko̱lh lhpipiko̱y, chu̱ la̱mpala xta̱chuná̱ xaní̱n tama̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yama̱ ángel chuná̱ huaniko̱lh lacchaján: —Ni̱ cape̱cuántit, quit ccatzi̱y pi̱ huixín huá̱ putzayá̱tit Jesús hua̱nti̱ tipakaxtokohuacaca̱ c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hua̱mpi̱ u̱nú̱ nia̱lh tí̱ tanu̱ma̱, huata xlá̱ lakastakuánalh ca̱li̱ní̱n chuná̱ la̱ntla̱ tica̱huanín nalay. Lapi̱ ni̱ ca̱najlayá̱tit hasta ma̱squi catántit ucxilhá̱tit anta̱ni̱ xma̱mi̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chú̱ huata lacapala̱ capítit, cama̱catzi̱ni̱kó̱tit xli̱ma̱kalhtahuáka̱t pi̱ lakastakuanani̱t, chu̱ lama̱ xastacná, chu̱ xlá̱ ca̱pu̱lanimá̱n, chu̱ aya amajá c-Galilea laqui̱mpi̱ na̱ napiná̱tit huixín, chu̱ antá̱ ma̱n naucxilha̱pítit. Xma̱n huá̱ yuma̱ tachihuí̱n hua̱ntu̱ quit xacmini̱tán ca̱huaniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yama̱ lacchaján caj xtape̱cuacán, chu̱ xtapa̱xuhua̱ncán takosú̱n anko̱lh ma̱catzi̱ni̱nanko̱y hua̱ntu̱ xkantaxtuni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hua̱mpi̱ acxni̱ ni̱ xa̱cha̱nko̱y, chunacú̱ xkosnama̱kó̱ c-tiji, caj xamaktum antá̱ tasiyuniko̱lh Jesús, chu̱ xakatli̱ko̱lh. Xlacán lacapala̱ laktalacatzuhui̱ko̱lh, lakatatzokostako̱lh c-xlacatí̱n, chu̱ snat tlahuako̱lh c-xtantú̱n, chu̱ tzúculh ca̱cni̱naniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Cha̱nchu̱ Jesús chuná̱ huaniko̱lh: —Catatlihuáklhtit, ni̱ cape̱cuántit, huata caqui̱huanipítit tama̱ nata̱laní̱n pi̱ antá̱ cama̱ c-Galilea laqui̱mpi̱ antá̱ pu̱tum naquiucxilhko̱ya̱chá. ");
INSERT INTO tosNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Xli̱makua̱ cajcu c-tiji̱ xanko̱y lacchaján, yama̱ makapitzi̱n tropa̱ ti̱ xmaktakalhnama̱kó̱ c-tahuaxni̱ cha̱nko̱lh ca̱chiquí̱n, chu̱ acxni̱ lakcha̱nko̱lh xanapuxcun pa̱lijni, tzúculh li̱ta̱chihui̱nanko̱y xpa̱lacata xli̱pacs tu̱ xlani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huata yama̱ pa̱lijni̱ lacapala̱ ma̱macxtumi̱ko̱lh lakko̱lun ma̱paksi̱naní̱n, chu̱ lacxtum li̱tachihuini̱li̱ko̱lh tú̱ xatlá̱n natlahuako̱y. Pus lacxtum li̱catzi̱ko̱lh pi̱ nama̱xqui̱ko̱y lhu̱hua tumi̱n yama̱ tropa̱. ");
INSERT INTO tosNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Chuna̱ na̱má̱ huaniko̱ca̱: —Huixín kalhtum cahuántit pi̱ acxni̱ aclhtatahuilátit ca̱tzi̱sní, chinko̱lh xli̱ma̱kalhtahuaka̱t Jesús, chu̱ tze̱k kalhale̱nko̱lh xtiyatli̱hua. ");
INSERT INTO tosNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na̱ lapi̱ xamaktum nacatzi̱y gobernador yuma̱ tachihuí̱n, huixín ni̱ cali̱puhuántit sa̱mpi̱ quin nacma̱akatancsaya̱hu, hua̱mpi̱ huixín ni̱tú̱ catica̱lakchá̱n talakapútzi̱t. ");
INSERT INTO tosNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Cha̱nchu̱ xlacán maklhti̱nanko̱lh tumi̱n, chuná̱ tlahuako̱lh hua̱ la̱ntla̱ cstacya̱huako̱cani̱t. Pus caj hua̱ yumá̱ xpa̱lacata ma̱squi hasta la̱nchu̱ quilhtamacú̱ pacs judíos chuná̱ xlacán huanko̱y. Pus hua̱ yuma̱ tahuán, tita̱kahuani̱niko̱lh judíos hasta chú̱. ");
INSERT INTO tosNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Cha̱nchu̱ huá̱ xkalhaca̱huitucán li̱ma̱kalhtahuáka̱t, tianko̱lh c-Galilea chu̱ cha̱nko̱lh c-aktum ka̱stí̱n anta̱ni̱ xuaniko̱ni̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Acxni̱ xlacán ucxilhko̱lh, ca̱cni̱naniko̱lh; ma̱squi makapitzí̱n xlacán ni̱ luhua lay xca̱najlako̱y lapi̱ luhua xli̱ca̱na̱ hua̱ntu̱ xucxilhma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Acxni̱ chú̱ Jesús laktalacatzuhui̱ko̱lh anta̱ni̱ xtamakstokko̱ni̱t, xakatli̱ko̱lh, chuná̱ huaniko̱lh: —Dios quima̱xqui̱ni̱t xli̱pacs xli̱ma̱paksí̱n laqui̱mpi̱ quit nacma̱paksi̱ko̱y la̱ntla̱ caxatu̱cahuá̱ tu̱ anán c-akapú̱n xa̱huá̱ tu̱ anán ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chuna̱mpi̱ cca̱li̱ma̱paksi̱yá̱n pi̱ capítit xli̱ca̱tlanca̱ ca̱tuxá̱huat, xli̱pacs caxati̱cahuá̱ cali̱ta̱chihui̱nankó̱tit la̱ntla̱ luhua xli̱ca̱na̱ aksti̱tum naquili̱pa̱huanko̱y. Chu̱ nali̱akmunuko̱yá̱tit c-xtucuhuini Xatla̱t Dios, c-xtucuhuini xaCam, chu̱ c-xtucuhuini Espíritu Santo. ");
INSERT INTO tosNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chu̱ huixín luhua li̱huana̱ cama̱siyunikó̱tit la̱ntla̱ nama̱kantaxti̱ko̱y xli̱pacs li̱ma̱paksí̱n tu̱ cca̱li̱ma̱paksi̱ni̱tán. Xa̱hua̱ lacatancs cacatzí̱tit pi̱ xa̱li̱ankalhí̱n quit nacca̱ta̱latama̱yá̱n cha̱li̱ cha̱lí̱ hasta acxni̱ nasputa̱ ca̱tuxá̱huat.");
INSERT INTO tosNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yuma̱ li̱pa̱xuhu takalhchihuí̱n hua̱ntu̱ ctzokma̱ xpa̱lacata̱ Jesucristo xCam Dios la̱ntla̱ milh ma̱sta̱y laktáxtut, ");
INSERT INTO tosNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","antá̱ kalhi̱y xquilhtzúcut c-xamaka̱n xtatzoknu̱n profeta Isaías lacatum anta̱ni̱ Dios a̱li̱ma̱catzi̱ní̱nalh tu̱ natlahuay, chuná̱ na̱má̱ huá̱: “Quit nacma̱lakacha̱y quiakchihui̱ná̱ ti̱ napu̱laniyá̱n laqui̱mpi̱ naca̱xtlahuaniyá̱n mintiji. ");
INSERT INTO tosNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Namín quilhtamacú̱ acxni̱ natakaxmata̱ caj la̱mpala cha̱tum ti̱ quilhmima̱chá nahuán c-desierto anta̱ni̱ ni̱tí̱ lama̱, chu̱ chuná̱ nahuán: ‘Caca̱xtlahuanítit tiji̱ anta̱ni̱ luhua tla̱n nalacmín Mimpu̱chinacán; catlahuanítit kantum tiji̱ ni̱ma̱ tzajua.’” ");
INSERT INTO tosNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pus chuná̱ timinchá̱ Juan Bautista, tzúculh akchihui̱nán c-desierto, xuaniko̱y tachixcuhuí̱tat pi̱ calakpali̱ko̱lh xali̱xcajnit xtapuhua̱ncán, chu̱ cata̱kmunuko̱lh laqui̱mpi̱ Dios tla̱n nama̱tzanka̱naniko̱y xtala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Xminko̱y kaxmatniko̱y lhu̱hua̱ hua̱nti̱ xlama̱kó̱ c-xatiyat Judea, chu̱ hua̱nti̱ xala c-Jerusalén. Na̱ acxni̱ xlacán xkalhapalako̱y xtala̱kalhi̱ncán, maktum xuanko̱y pi̱ xli̱ca̱na̱ xtalakpali̱putunko̱y, Juan xakmunuko̱y c-xakalhtu̱choko̱ Jordán. ");
INSERT INTO tosNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Hua̱ntu̱ xlhaka̱y Juan xli̱tlahuani̱t xmacchixit camello, xli̱tampu̱lakchi̱cán kantum xli̱tampa̱chi xla xu̱hua, chu̱ xli̱hua̱yán lactzu̱ xtuqui, chu̱ táxca̱t hua̱ntu̱ xta̱ksa̱ c-sipi̱. ");
INSERT INTO tosNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Acxni̱ cxakatli̱y tachixcuhuí̱tat chuná̱ xuaniko̱y: “Nia̱lh maka̱s quilhtamacú̱ mima̱ a̱cha̱tum ti̱ a̱tzinú̱ tlak tlanca̱ xlacatzúcut ni̱ xahua̱ quit; hua̱nti̱ ni̱ pala tzinú̱ cmakalakchá̱n li̱lakaputza xtasa̱cua nacli̱tanu̱y ti̱ nacxcutniy xatasij xtatuhuanu.” ");
INSERT INTO tosNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Quit caj chúchut cca̱li̱akmununi̱tán, hua̱mpi̱ xlá̱ naca̱li̱akmunuyá̱n xli̱tlihuaka Espíritu Santo. ");
INSERT INTO tosNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na̱má̱ tílalh acxni̱ yama̱ quilhtamacú̱ pi̱ titáca̱xli̱ Jesús c-xca̱chiquí̱n huanicán Nazaret hua̱ntu̱ xma̱paksi̱y Galilea, chu̱ lákalh Juan laqui̱mpi̱ naakmunuy, chu̱ chuná Juan akmúnulh c-xakalhtu̱choko̱ Jordán. ");
INSERT INTO tosNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Acxni̱ xtacutma̱ c-chúchut, Jesús talacayá̱hualh talhmá̱n, chu̱ úcxilhli̱ pi̱ talácqui̱lh akapú̱n, chu̱ Espíritu Santo xta̱ctama̱chi̱ c-xokspún caj xta̱chuná̱ actzu̱ tijtímpu̱t, ");
INSERT INTO tosNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","na̱ acxnitiyá̱ takáxmatli̱ aktum tachihuí̱n minchá̱ c-akapú̱n, chuná̱ huánilh: “Huix Quincam ti̱ luhua cpa̱xqui̱y, luhua cli̱pa̱xuhuay caj mimpa̱lacata.” ");
INSERT INTO tosNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Acxni tuncán la̱ntla̱ ta̱kmunuko̱lh, Espíritu Santo le̱lh Jesús c-desierto anta̱ni̱ tzili̱s ca̱huán. ");
INSERT INTO tosNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Antá̱ xlama̱chá̱ ti̱puxam quilhtamacú̱ xacstu, xma̱n hua̱ takalhí̱n xala ca̱quihuí̱n xta̱lama̱kó̱. Akskahuiní̱ na̱ antá̱ xma̱tlahui̱putún tala̱kalhí̱n hua̱mpi̱ Jesús makatlájalh, chu̱ a̱li̱sta̱lh minko̱lh xángeles Dios, maktakalhko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ni̱ xli̱maka̱s quilhtamacú̱ acxni̱ Juan Bautista tamacanu̱ca̱ c-pu̱la̱chi̱n, acxnicú̱ Jesús taspitpá̱ c-Galilea laqui̱mpi̱ nalakatza̱lako̱y lactzu̱ ca̱chiquí̱n, chu̱ nali̱akchihui̱naniko̱y tachixcuhuí̱tat la̱ntla̱ Dios xma̱lacnu̱nima̱kó̱ tanuj tla̱n latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na̱má̱ xuaniko̱y: “Aya accha̱ni̱t quilhtamacú̱ acxni̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t c-milatama̱tcán. Calakpalí̱tit xali̱xcajnit mintalacapa̱stacnicán, chu̱ caca̱najlátit yuma̱ li̱pa̱xuhu xtama̱catzi̱ní̱n hua̱ntu̱ ma̱sta̱y laktáxtut.” ");
INSERT INTO tosNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Cha̱nchu̱ maktum acxni̱ Jesús xtla̱huama̱ c-xquilhtu̱n ta̱kayahuaná̱ c-Galilea ucxilhko̱lh cha̱tuy squi̱ti̱naní̱n xmuju̱ma̱kó̱ xtza̱lhcán c-chúchut, cha̱tum huanicán Simón, chu̱ xta̱lá̱ huanicán Andrés. ");
INSERT INTO tosNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hua̱mpi̱ Jesús huaniko̱lh: —Huixín tla̱n catzi̱yá̱tit chipayá̱tit squi̱ti, caquista̱lanítit, chu̱ quit nacca̱ma̱siyuniyá̱n la̱ntla̱ tla̱n nachipayá̱tit chixcuhuí̱n laqui̱mpi̱ naquili̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Xlacán tuncán makaxtakko̱lh xtza̱lhcán, chu̱ sta̱laniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Caj actzú̱ tla̱huampá̱ Jesús úcxilhli̱ Santiago xcam Zebedeo, xa̱hua̱ xta̱lá̱ xuanicán Juan; xlacán xtaju̱ma̱kó̱ c-aktum pu̱tacutnu, xlacachi̱ma̱kó̱ xtza̱lhcán. ");
INSERT INTO tosNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús na̱ huaniko̱lh casta̱laniko̱lh, chu̱ xlacán akxtakmi̱ko̱lh xtla̱tcan Zebedeo, chu̱ xmakta̱yananí̱n c-pu̱tacutnu, aya tista̱laniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Cha̱nko̱lh c-aktum ca̱chiquí̱n huanicán Capernaum, chu̱ acxni̱ lákcha̱lh quilhtamacú̱ sábado acxni̱ pacs judíos xjaxko̱y, Jesús tánu̱lh c-xpu̱kalhtahuakacán, chu̱ antá̱ tzúculh li̱akchihui̱naniko̱y xtachihui̱n Dios hua̱nti̱ antá̱ xtamakstokko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xli̱pacscán cacs xlacahuanko̱y acxni̱ kaxmatniko̱lh hua̱ntu̱ xlá̱ xli̱chihui̱nama̱, sa̱mpi̱ xlá, pacs hua̱ntu̱ xli̱ma̱paksi̱ko̱y, luhua kalhi̱y li̱tlihuaka̱ talulóktat, chu̱ li̱ma̱paksí̱n, ni̱ caj xta̱chuná̱ la̱ntla̱ xma̱siyuko̱y xma̱kalhtahuaka̱nacan judíos. ");
INSERT INTO tosNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chu̱ acxnitiyá̱ yama̱ quilhtamacú̱ na̱ antá̱ tánu̱lh cha̱tum chixcú̱ ti̱ xma̱xcajua̱li̱nini̱t xtalacapa̱stacni̱ akskahuiní. Xlá̱ chuná̱ quilhánilh: ");
INSERT INTO tosNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Huix Jesús xala c-Nazaret, ¿tú̱ chú̱ xpa̱lacata̱ quinca̱li̱ta̱la̱tlahuaya̱ huix? ¿Pi̱ huix huá̱ li̱tani̱ta̱ caj quinca̱ma̱sputuya? Sa̱mpi̱ quit clakapasá̱n, ccatzi̱y pi̱ huix hua̱nti̱ Dios lacsacni̱tán laqui̱mpi̱ nascujnaniya. ");
INSERT INTO tosNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hua̱mpi̱ Jesús lacaquílhni̱lh yama̱ cspiritu akskahuiní, chu̱ chuná̱ huánilh: —¡Cakátxtakti, chu̱ camakáxtakti̱ tama̱ chixcú! ");
INSERT INTO tosNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Yama̱ cspiritu akskahuiní̱ li̱cá̱snokli̱ chixcú, chu̱ luhua anán li̱tlihuaka̱ ca̱tásalh, chunachí̱ makáxtakli̱ cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Puschí̱ xli̱pacs hua̱nti̱ antá̱ xlaya̱kó̱ pe̱cuanko̱lh, chu̱ chuná̱ tzúculh la̱kalhasquinko̱y: —¿Lá̱ntla̱ yuma̱ qui̱taxtuy? ¿Tú̱ ya̱ xasa̱sti tacatzí̱n yumá̱ tu̱ luhua li̱kalhi̱y li̱tlihuaka? ¡Sa̱mpi̱ yuma̱ chixcú̱ tla̱n ma̱paksi̱ko̱y cspiritu akskahuiní, chu̱ xlacán kalhakaxmatko̱y! ");
INSERT INTO tosNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chuná̱ lacapala̱ ta̱kahuáni̱lh tachihuí̱n, chu̱ c-xli̱ca̱tlanca Galilea cani̱cahuá̱ tzucúcaj li̱chihui̱nancán tu̱ xlá̱ xtlahuay Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Acxni̱ qui̱taxtuko̱lh c-xpu̱kalhtahuacán, Jesús ta̱anko̱lh Santiago, chu̱ Juan c-xchic Simón, chu̱ Andrés. ");
INSERT INTO tosNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li̱xakatli̱ca̱ Jesús pi̱ xpu̱tiya̱tzi Simón xta̱tatlay, na̱ caj xmá̱ c-xpu̱tama, sa̱mpi̱ xkalhi̱y palha lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús laktalacatzúhui̱lh anta̱ni̱ xmá̱, macachípalh, chu̱ lacatzucu̱ má̱qui̱lh, acxni tuncán makáxtakli̱ lhcúya̱t. Yama̱ pusca̱t tá̱qui̱lh, chu̱ tzúculh ca̱xtlahuay pala tú̱ nata̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Acxni̱ tzúculh tzi̱suán yama̱ quilhtamacú̱ li̱minica̱ Jesús lhu̱hua ta̱tatlaní̱n, na̱ chuná̱ ti̱ xma̱xcajua̱li̱niko̱ni̱t xtalacapa̱stacni̱ cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Chu̱ xli̱pacs ti̱ xala yama̱ ca̱chiquí̱n tamacxtumi̱ko̱lh hasta nia̱lh lay xtanu̱ko̱y c-xchic Simón. ");
INSERT INTO tosNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús pacs ma̱pacsako̱lh ma̱squi caxatu̱cahua̱ tajátat tu̱ xpa̱ti̱ma̱kó̱, na̱ chuná̱ ti̱ xkalhi̱ko̱y cspiritu akskahuiní, xlá̱ tamacaxtuniko̱lh. Cha̱nchu̱ ma̱pacsako̱lh lhu̱hua̱ ti̱ catu̱hua̱ tajátat tu̱ xpa̱ti̱ma̱kó̱. Acxni̱ xtlakaxtuko̱y, xlá̱ ni̱ xma̱xqui̱ko̱y quilhtamacú̱ nachihui̱nanko̱y yama̱ akskahuinaní̱n, sa̱mpi̱ xlacán xcatzi̱ko̱y xatí̱ ya̱ chixcú xuani̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Acxni̱ ni̱ xa̱xkakako̱y, luhua tzisacú̱, chunacú̱ ca̱paklhtu̱taj xuani̱t, Jesús taca̱xtá̱qui̱lh, chu̱ alh tlahuay oración c-xquilhapa̱n ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Acxni̱ stácnalh Simón Pedro, chu̱ a̱makapitzi̱ xli̱ma̱kalhtahuáka̱t tzucuko̱lh putzako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chu̱ acxni̱ qui̱ta̱ksko̱lh, huaniko̱lh: —Lhu̱hua̱ putzama̱kó̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Hua̱mpi̱ xlá̱ kalhti̱ko̱lh: —Huata caanka̱hu a̱lacatanu̱ ca̱chiquí̱n ni̱ma̱ tlak lacatzú̱ huilakó̱ laqui̱mpi̱ na̱ antá̱ nali̱xakatli̱ko̱ya̱hu tachixcuhuí̱tit yuma̱ li̱pa̱xuhu tachihuí̱n xla laktáxtut hua̱ntu̱ Dios lacasquín nacatzi̱ko̱y, sa̱mpi̱ huá̱ xpa̱lacata quili̱macamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pus Jesús chuná̱ lakatza̱lako̱lh lhu̱hua lactzu̱ ca̱chiquí̱n hua̱ntu̱ xma̱paksi̱ko̱y Galilea. Acxni̱ xcha̱n c-aktum chuchutsipi̱, xlá̱ xtanu̱y c-xpu̱kalhtahuacan judíos laqui̱mpi̱ antá̱ nali̱akchihui̱naniko̱y tachixcuhuí̱tat xtachihui̱n Dios, chu̱ hua̱nti̱ xkalhi̱y cspiritu akskahuiní̱ xma̱pacsako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maktum laktalacatzúhui̱lh Jesús cha̱tum chixcú̱ ti̱ xpa̱ti̱ma̱ yama̱ li̱xcajnit tajátat huanicán lepra. Xlá̱ lakatatzokóstalh, chu̱ chuná̱ huánilh: —Quit ccatzi̱y pi̱ huix tla̱n naquima̱pacsaya, pala huix chuná̱ lacasquina, caquima̱pacsani̱ yuma̱ quintajátat. ");
INSERT INTO tosNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús lakalhámalh, xamánilh xmacni, na̱má̱ huánilh: —Chuná̱ clacasquín, la̱nchuj tuncán capacsti. ");
INSERT INTO tosNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tuncán la̱ntla̱ chuná̱ huaniko̱lh, yama̱ ta̱tatlá̱ tuncán pacsli. ");
INSERT INTO tosNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús huánilh pi̱ caalh c-xchic, hua̱mpi̱ li̱ma̱páksi̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Ni̱tí̱ cahuani̱ la̱ntla̱ huix pacsni̱ta; caj xma̱n caputza̱ cha̱tum pa̱li̱ laqui̱mpi̱ naucxilhá̱n, chu̱ cama̱xqui̱ milimu̱sna̱ hua̱ntu̱ Moisés li̱ma̱paksí̱nalh nama̱sta̱ko̱y acxni̱ pacsko̱y hua̱nti̱ xkalhi̱ko̱y yuma̱ tajátat, laqui̱mpi̱ acxni̱ xlá̱ naucxilhá̱n, nama̱luloka, chu̱ chuná̱ pacs nacatzi̱ko̱cán pi̱ aya pacsni̱ta̱ yama̱ li̱xcajnit mintajátat hua̱ntu̱ xkalhi̱ya. ");
INSERT INTO tosNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Hua̱mpi̱ yama̱ chixcú̱ cati̱huá̱ tzúculh li̱ta̱chihui̱nanko̱y la̱ntla̱ xma̱pacsani̱t Jesús. Pus caj huá̱ xpa̱lacata, Jesús nia̱lh lay xtanu̱ya̱chá̱ c-aktum ca̱chiquí̱n anta̱ni̱ lu̱hua̱ xtzamacán, pus huata caj c-xquilhapa̱ní̱n xtla̱huán anta̱ni̱ ni̱tí̱ xtzuhuá̱n chixcuhuí̱n. Hua̱mpi̱ ma̱squi chuná, xminko̱y cani̱hua̱ xalaní̱n laqui̱mpi̱ nakaxmatniko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni̱ li̱maka̱s tiampá̱ Jesús c-xaca̱chiqui̱n Capernaum, chu̱ lhu̱hua̱ catzi̱ca̱ pi̱ antá̱ xlá̱ xcha̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Luhua lhu̱hua tuncán tamacxtumi̱ko̱lh anta̱ni̱ xuí̱, hasta nia̱lh lay xtanu̱ko̱cán c-chiqui. Jesús xma̱siyunima̱kó̱ xtachihui̱n Dios la̱ntla̱ xlá̱ lacasquín nalatama̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chunacú̱ xta̱chihui̱nama̱kó̱ acxni̱ chinko̱lh kalhata̱ti chixcuhuí̱n, xpu̱li̱minko̱y pu̱chaxna̱ cha̱tum chixcú̱ hua̱nti̱ ni̱ lay xtla̱huán sa̱mpi̱ xli̱cha̱tumi̱nica̱ xlu̱ntu̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cha̱nchu̱ pi̱ ni̱ lay xlaktanu̱ko̱y anta̱ni̱ xuí̱ Jesús sa̱mpi̱ xtzamacán, huata tahuacako̱lh c-xaksti̱n chiqui, chu̱ ma̱pa̱nu̱ko̱lh pakstuy teja̱ xpa̱lacata̱ pi̱ antá̱ xuí̱ Jesús, chu̱ antá̱ lacma̱acti̱ko̱lh pu̱chaxna̱ hua̱ntu̱ xlacma̱ yama̱ ta̱tatlá. ");
INSERT INTO tosNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Acxni̱ ucxilhko̱lh Jesús pi̱ luhua xli̱pa̱huanko̱y pi̱ tla̱n nama̱pacsay, chuná̱ huánilh ta̱tatlá: —Tla̱ti, luhua clakalhamaná̱n, chu̱ la̱ntla̱ xli̱pacs mintala̱kalhí̱n cma̱tzanka̱naniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Hua̱mpi̱ na̱ antá̱ xlaya̱kó̱ makapitzi̱n xma̱kalhtahuaka̱nacan judíos, xlacán chuná̱ tzúculh lacpuhuanko̱y: ");
INSERT INTO tosNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tú̱ xpa̱lacata̱ chuná̱ kalhchihui̱nán yuma̱ chixcú? Pus ta̱la̱tlahuama̱ Dios; sa̱mpi̱ ni̱tí̱ anán ti̱ tla̱n ma̱tzanka̱nani̱nán tala̱kalhí̱n lapi̱ ni̱ xma̱n Dios.” ");
INSERT INTO tosNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hua̱mpi̱ Jesús xcatzi̱y tu̱ xlacán xpuhuama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Tú̱ xpa̱lacata chuná̱ lacapa̱stacá̱tit yuma̱ c-minacu̱cán? ");
INSERT INTO tosNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Pus caquihuanítit, ¿xatú̱ tlak tuhua̱ ma̱kantaxti̱cán, pá̱ acxni̱ nahuaniya̱ cha̱tum ta̱tatlá: ‘Mintala̱kalhí̱n pacs cma̱tzanka̱naniyá̱n’, usuchí̱ pala nahuaniya: ‘Lacapala̱ cata̱qui, chu̱ catlá̱huanti’? ");
INSERT INTO tosNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pus la̱nchú̱ nacca̱ma̱siyuniyá̱n pi̱ quit Xatalacsacni Chixcú, chu̱ na̱ chuna li̱tum pi̱ ckalhi̱y li̱tlihuaka̱ u̱nú̱ ca̱tiyatna, chu̱ caj quintachihuí̱n tla̱n cli̱ma̱tzanka̱ni̱nán tala̱kalhí̱n. Chu̱ na̱má̱ huánilh yama̱ ta̱tatlá: ");
INSERT INTO tosNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Huix cuaniyá̱n, cata̱qui, casacti̱ mimpu̱chaxna, chu̱ capit c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Puschí̱ yama̱ ta̱tatlá̱ lacapala̱ tá̱qui̱lh, sacli̱ xpu̱chaxna, chu̱ táxtulh. Lhu̱hua̱ hua̱nti̱ antá̱ xya̱kó̱ pacs ucxilhko̱lh, luhua xli̱pa̱xuhuama̱kó̱, xca̱cni̱nanima̱kó̱ Dios, chu̱ chuná̱ xuanko̱y: —Niucxni̱ a̱ucxilha̱hu xta̱chuná̱ yumá̱ tu̱ ucxilhma̱hu la̱nchú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A̱li̱sta̱lh Jesús ampá̱ c-xquilhtu̱n ta̱kaya̱huaná xala c-Galilea, antá̱ lakcha̱nko̱lh lhu̱hua̱ tachixcuhuí̱tat, chu̱ xlá̱ tzúculh ma̱siyuniko̱y xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Acxni̱ aya xtaspitma̱, úcxilhli̱ cha̱tum chixcú̱ xuanicán Leví, hua̱ xtla̱t xuanicán Alfeo. Leví xuí̱ c-xtanquilhti̱n chiqui̱ xma̱ta̱ji̱ko̱y hua̱nti̱ xlakaxoko̱naniko̱y gobierno xala c-Roma, chu̱ Jesús chuná̱ huánilh: —Caquista̱lani, quili̱ma̱kalhtahuáka̱t cahuanti. Leví lacapala̱ tá̱yalh, chu̱ sta̱lánilh. ");
INSERT INTO tosNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A̱li̱sta̱lh Jesús alh hua̱yán c-xchic Leví, na̱ ta̱anko̱lh xli̱ma̱kalhtahuáka̱t. Anta̱ni̱ ma̱hui̱ko̱ca̱ na̱ minko̱lh ta̱hua̱yanko̱y lhu̱hua xma̱ta̱ji̱nani̱n impuestos, xa̱hua̱ a̱makapitzí̱n hua̱nti̱ na̱ xpuhuaniko̱y judíos pi̱ maktum xaktzanka̱ta̱yako̱ni̱t, chu̱ ni̱tú̱ xli̱ucxilhko̱cán. Na̱ ni̱ lakati̱ko̱lh pi̱ cani̱huá̱ anta̱ni̱ xlapu̱lay Jesús, yuma̱ chixcuhuí̱n hua̱nti̱ csta̱laniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Makapitzi̱n xma̱kalhtahuaka̱nacan judíos, xa̱hua̱ fariseos acxni̱ ucxilhko̱lh pi̱ Jesús pu̱tum xta̱hua̱yama̱kó̱ yuma̱ chixcuhuí̱n, chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —¿Tú̱ xpa̱lacata̱ mima̱kalhtahuaka̱nacán lacxtum ta̱hua̱yama̱kó̱ hua̱nti̱ xma̱ta̱ji̱nani̱n impuestos, xa̱huá̱ hua̱nti̱ luhua lacli̱xcajnit makla̱kalhi̱nani̱n chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Acxni̱ kalhakaxmatko̱lh Jesu̱s hua̱ntu̱ xquilhuama̱kó̱, huaniko̱lh: —Ni̱ maclacasquinko̱y ma̱cuchi̱ná̱ hua̱nti̱ ni̱ ta̱tatlako̱y, xma̱n hua̱nti̱ ni̱tlá̱n makcatzi̱ko̱cán. Quit ni̱ cmini̱t huaniko̱y nalakpali̱ko̱y xlatama̱tcán hua̱nti̱ puhuanko̱y lactla̱n chixcuhuí̱n, huata hua̱nti̱ makcatzi̱ko̱cán pi̱ makla̱kalhi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maktum acxni̱ xli̱ma̱kalhtahuaka̱t Juan, xa̱hua̱ xlacan fariseos xmakalhkajnanko̱ni̱t laqui̱mpi̱ chuná̱ nali̱ca̱cni̱naniko̱y Dios, makapitzi̱n xlacán lakminko̱lh Jesús, chu̱ chuná̱ kalhasquinko̱lh: —¿Tú̱huan hua̱nti̱ ma̱kalhtahuaka̱ko̱ni̱t Juan Bautista, xa̱hua̱ xli̱ma̱kalhtahuaka̱tcan fariseos ankalhí̱n, makalhkajnanko̱y laqui̱mpi̱ naca̱cni̱naniko̱y Dios, chi̱nchu̱ hua̱nti̱ huix ma̱kalhtahuaka̱pa̱kó̱ ni̱ makalhkajnanko̱y laqui̱mpi̱ naca̱cni̱naniko̱y Dios? ");
INSERT INTO tosNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús kalhti̱ko̱lh: —¿Pi̱ puhuaná̱tit huixín pi̱ tla̱n namakalhkajnanko̱y makpa̱xuhuaní̱n c-tapu̱chuhuani, acxni̱ xli̱makua̱ antá̱ ta̱lahuilakó̱ yama̱ kahuasa hua̱nti̱ tapu̱chuhuama̱? Pala ta̱lahuilakó̱ kahuasa li̱ta̱tahuílat ni̱ lay namakalhkajnanko̱y, usu ni̱ nahua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Hua̱mpi̱ nachá̱n quilhtamacú̱ acxni̱ nasputa̱ pa̱scua̱, chu̱ yama̱ kahuasa naán mákat a̱lacatanu̱ xta̱chuná̱ la̱ntla̱ quit naquiakspulay, acxnicú̱ xlacán namakalhkajnanko̱y ma̱squi ni̱tí̱ xli̱ma̱paksi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Sa̱mpi̱ hua̱nti̱ kaxmatko̱y hua̱ntu̱ quit cli̱chihui̱nán, chu̱ quili̱pa̱huán, chuná̱ na̱má̱ qui̱taxtuy: Ni̱ anán ti̱ lactzapay mactum lakuan talhaká̱n, chu̱ nali̱lactzapay actzu̱ xasa̱sti lháka̱t, sa̱mpi̱ acxni̱ nachaka̱cán yama̱ lháka̱t, xasa̱sti̱ nata̱ktumi̱y, chu̱ a̱tzinú̱ tlak tlanca nataxti̱ta xalakuán ni̱ xahua̱ la̱ xapu̱lh xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Chu̱ na̱ chuna li̱tum, ni̱tí̱ pu̱muju̱y hua̱ntu̱ a̱cu lakchitcán vino c-xalakuan xmakxu̱hua calhni̱lu̱, sa̱mpi̱ xasa̱sti vino tzucuy catlán, chu̱ ma̱pankay xmakxu̱hua calhni̱lu̱, pus caj pá̱xcat huan vino, chu̱ xu̱hua. Huá̱ xpa̱lacata ankalhí̱n li̱muju̱cán xaskata vino c-xasa̱sti xmakxu̱hua calhni̱lu̱. ");
INSERT INTO tosNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Maktum quilhtamacu̱ sábado acxni̱ ni̱tí̱ cscujko̱y judíos, Jesús xti̱puntaxtuma̱ aktum ca̱tachaná̱n anta̱ni̱ xchancani̱t trigo, chu̱ xli̱ma̱kalhtahuáka̱t tzucuko̱lh puxko̱y xtahuácat. ");
INSERT INTO tosNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Makapitzi̱n fariseos hua̱nti̱ na̱ antá̱ xmaksta̱lama̱kó̱, xlacán ucxilhko̱lh hua̱ntu̱ xtlahuama̱kó̱, chu̱ chuná̱ huaniko̱lh Jesús: —Cakáxpatti, ¿tú̱huan puxma̱kó̱ trigo̱ mili̱ma̱kalhtahuáka̱t acxni̱ pi̱ ni̱tí̱ xli̱scújat chiyú̱? ");
INSERT INTO tosNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Hua̱mpi̱ Jesús chuná̱ kalhti̱ko̱lh: —Huixín ma̱x ni̱ a̱li̱kalhtahuakayá̱tit c-xtachihui̱n Dios pi̱ maká̱n, acxni̱ xapuxcu pa̱li̱ xuani̱t cha̱tum chixcú̱ xuanicán Abiatar, maktum, rey David xta̱tzincsni̱ma̱kó̱ xcompañeros. Pus catzi̱yá̱tit pi̱ xlá̱ tánu̱lh c-chiqui̱ anta̱ni̱ xlakataquilhpu̱tacán Dios, chu̱ ta̱huako̱lh xcompañeros xatasculuna̱tlahuan caxtala̱nchu̱ hua̱ntu̱ ni̱ xli̱huatcán xuani̱t, sa̱mpi̱ caj xma̱n pa̱lijni̱ xmini̱niko̱y xuakoy. ");
INSERT INTO tosNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús chuná̱ huanipalako̱lh: —Yuma̱ quilhtamacú̱ acxni̱ quili̱jaxatcán li̱ma̱xqui̱ko̱cani̱t tachixcuhuí̱tat laqui̱mpi̱ namaclacasquinko̱y, chu̱ ni̱ huá̱ li̱ma̱xqui̱ko̱cani̱t xpa̱lacata caj nali̱pa̱ti̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Chuná̱ pi̱ quit Xatalacsacni Chixcú̱, huá̱ xpu̱china hasta ma̱squi hua̱ quilhtamacu̱ li̱jáxat, laqui̱mpi̱ nacuán tu̱ tla̱n natlahuacán acxni̱ li̱jaxat quilhtamacu̱ sábado. ");
INSERT INTO tosNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Maktum li̱tum, acxni̱ Jesús tánu̱lh c-sinagoga huachá̱ xpu̱kalhtahuakacan judíos tu̱ xuí̱ c-Capernaum, antá̱ xlahui̱ cha̱tum chixcú̱ ti̱ csca̱cniko̱ni̱t xmacán. ");
INSERT INTO tosNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Hua̱mpi̱ makapitzi̱n fariseos luhua xquiclhcatzaniko̱y Jesús, chu̱ xlacán cskalama̱kó̱ pala tí̱ nama̱pacsay yama̱ quilhtamacu̱ sábado acxni̱ li̱huancán pala tí̱ nascuja, laqui̱mpi̱ huij nahuán tu̱ nali̱ya̱huako̱y, chu̱ tla̱n nali̱sta̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Hua̱mpi̱ Jesús aya xcatzi̱y tu̱ xlacán xlacapa̱stacma̱kó̱, chu̱ chuná̱ huánilh yama̱ chixcú̱ hua̱nti̱ csca̱cko̱ni̱t xmacán: —Unú̱ catat, calaklacanta̱yako. ");
INSERT INTO tosNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chu̱ chuná̱ kalhasquinko̱lh a̱makapitzí̱n hua̱nti̱ xquiclhcatzaniko̱y: —¿Tú̱ huixín puhuaná̱tit a̱tzinú̱ tlak tla̱n tlahuacán yuma̱ quilhtamacú̱ acxni̱ li̱huancán ti̱ nascuja, pá̱ huata hua̱ntu̱ tla̱n, usuchí̱ hua̱ntu̱ ni̱tlá̱n? Lapi̱ cha̱tum chixcú̱ nani̱y, ¿pi̱ tla̱n makta̱yanicán xli̱stacna, usuchí̱ calaktzanka̱ka̱lh ma̱squi ni̱tí̱ camaktá̱yalh? ");
INSERT INTO tosNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Hua̱mpi̱ xlacán cacs ta̱yako̱lh c-xtuntamacni, ni̱tú̱ li̱kalhti̱nanko̱lh. Jesús sí̱tzi̱lh hua̱mpi̱ xlakli̱puhualaca̱ma̱kó̱ sa̱mpi̱ xlacán ni̱ xakata̱ksko̱y pi̱ xali̱huaca̱ tla̱n namakta̱yako̱cán tachixcuhuí̱tat caxatu̱cahua̱ quilhtamacú̱. Chuná̱ huanipá̱ yama̱ chixcú: —Castonkti̱ mimacán. Yama̱ chixcú̱ stonkli̱ xmacán, chu̱ tuncán tatlá̱ni̱lh la̱ntla̱ xmacasca̱cni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseos taxtuko̱lh, chu̱ tuncán lacxtum ta̱tastokko̱lh yama̱ judíos hua̱nti̱ xta̱ta̱yako̱y ma̱paksi̱na Herodes, chu̱ tzucuko̱lh li̱tachihui̱nli̱ko̱y la̱ntla̱ natlahuako̱y laqui̱mpi̱ tla̱n namakni̱ko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ni̱ li̱maka̱s Jesús táca̱xli̱ antá, chu̱ ta̱anko̱lh xli̱ma̱kalhtahuáka̱t c-xquilhtu̱n ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Acxni̱ catzi̱ca̱ la̱ntla̱ xma̱pacsako̱y tatatlaní̱n, chu̱ la̱ntla̱ xtlahuay lactlanca li̱ca̱cni tatlahu, lhu̱hua chixcuhuí̱n lakminko̱lh, xala c-Judea, xala c-Jerusalén, xala c-Idumea, chu̱ hua̱nti̱ xlama̱ko̱chá̱ xa̱li̱quilhtu̱an kalhtu̱choko̱ Jordán, chu̱ xala c-Tiro, chu̱ Sidón; minko̱lh kaxmatniko̱y hua̱ntu̱ xlá̱ nahuán, chu̱ hua̱ntu̱ natlahuay xtascújut. ");
INSERT INTO tosNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cha̱nchu̱ Jesús huaniko̱lh xli̱ma̱kalhtahuáka̱t pi̱ a̱li̱sokcú̱ naputzako̱y aktum pu̱tacutnu̱ c-xquilhtu̱n chúchut anta̱ni̱ nataju̱y pala ta̱ji̱ nalacxquitiya̱huako̱y xli̱lhu̱hua tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa̱mpi̱ xma̱pacsako̱ni̱t li̱lhu̱hua, chuná̱ pi̱ hasta naklha xlactahuacako̱y pacs ti̱ xkalhi̱ko̱y tajátat caj xqui̱toklhma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cha̱nchu̱ hua̱nti̱ xma̱xcajua̱li̱ko̱ni̱t xtalacapa̱stacni cspiritu akskahuiní, acxni̱ xucxilhko̱y Jesús xlacán xlakatatzokostako̱y, chu̱ na̱má̱ xca̱tasako̱y: —Huix xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Hua̱mpi̱ Jesús xma̱quilhcacsako̱y laqui̱mpi̱ ni̱ nahuanko̱y xatí̱ ya̱ chixcú xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A̱li̱sta̱lh Jesús aksputtahui̱ c-aktum ka̱stí̱n, chu̱ antá̱ lacsactasaniko̱lh hua̱nti̱ chuná̱ puhuaniko̱lh pi̱ natamacxtumi̱ko̱y anta̱ni̱ xlá̱ xuí̱, chu̱ xlacán lakminko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Antá̱ li̱lhca̱ko̱lh kalhacu̱tuy ti̱ luhua ankalhí̱n nata̱latapu̱li̱ko̱y, chu̱ naán li̱chihui̱nanko̱y xasa̱sti xtapaksi̱t Dios tu̱ xuili̱putún ca̱tuxá̱huat. Hua̱ xlacán tili̱ma̱pa̱cuhui̱ko̱lh xapóstoles. (Yuma̱ c-xatachihui̱n griego huaniputún “xtama̱lakachá̱n” usu “xlacscujní̱n”.) ");
INSERT INTO tosNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Chu̱ xlá̱ ma̱xqui̱ko̱lh li̱ma̱paksí̱n, chu̱ li̱tlihuaka̱ laqui̱mpi̱ tla̱n natamacaxtuko̱y cspiritu akskahuiní̱ hua̱nti̱ xkalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Hua̱ yumá̱ xtucuhuinican kalhacu̱tuy hua̱nti̱ lacsacko̱lh: Simón hua̱nti̱ xlá̱ li̱ma̱pa̱cúhui̱lh Pedro, xa̱hua̱ xta̱lá̱ Andrés; ");
INSERT INTO tosNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago, xa̱hua̱ Juan, hua̱ yumá̱ xcamán ko̱lutzi̱n Zebedeo, chu̱ hua̱nti̱ Jesús ma̱xqui̱ko̱lh xtucuhuinicán Boanerges. (Yuma̱ c-xatachihui̱n arameo huaniputún “Xcaman Jilí”, usu “Chixcuhuí̱n Lacapala̱tnaní̱n”); ");
INSERT INTO tosNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xa̱hua̱ Andrés, chu̱ Felipe, chu̱ Bartolomé, chu̱ Mateo, chu̱ Tomás; xa̱hua̱ Santiago xkahuasa Alfeo; chu̱ Tadeo; xa̱hua̱ Simón, (yuma̱ chixcú̱ xapu̱lana̱ xta̱tapaksi̱y makapitzi̱n chixcuhuí̱n xuaniko̱cán cananistas); ");
INSERT INTO tosNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","xa̱hua̱ Judas Iscariote, hua̱nti̱ a̱li̱sta̱lh timacamá̱sta̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A̱li̱sta̱lh Jesús alh ta̱laktuncuhuiko̱y xli̱ma̱kalhtahuáka̱t c-aktum chiqui̱ anta̱ni̱ xmakuilakó̱. Luhua lhu̱hua li̱tum tastokpalaca̱, hasta ni̱ xkalhi̱ko̱y quilhtamacú̱ nahua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Acxni̱ catzi̱ko̱lh xnata̱lan Jesús tu̱ xtlahuama̱, lakminko̱lh laqui̱mpi̱ nale̱nko̱y, sa̱mpi̱ xpuhuanko̱y pi̱ caj ni̱ xaccatzi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Chu̱ na̱ chuná̱ xma̱kalhtahuaka̱nacan judíos hua̱nti̱ xminko̱ni̱tanchá̱ c-Jerusalén, chuná̱ xuanko̱y: “Yuma̱ chixcú huá̱ ta̱scujma̱ Beelzebú xapuxcu akskahuiní, chu̱ caj xli̱tlihuaka̱ li̱tamacaxtuy cspiritu akskahuiní.” ");
INSERT INTO tosNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hua̱mpi̱ Jesús huaniko̱lh catalacatzuhui̱niko̱lh, chu̱ tzúculh li̱xakatli̱ko̱y aktum takalhchihuí̱n, chuná̱ huaniko̱lh: “¿Lá̱ntla̱ huixín puhuaná̱tit pi̱ hua̱nti̱ ta̱scujma̱ akskahuiní, pa̱ tla̱n ta̱la̱makasi̱tzi̱y huatiya akskahuiní, chu̱ natlakaxtuy? ");
INSERT INTO tosNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","La̱ntla̱ hua̱ntu̱ quit quili̱ya̱huayá̱tit, chuná̱ qui̱taxtuy: Huixín catzi̱yá̱tit pi̱ caxati̱cahua̱ xanapuxcun ma̱paksi̱naní̱n xala c-aktum tlanca tíyat, lapi̱ xlacán caj natapa̱pitziko̱y hua̱nti̱ sta̱lanima̱kó̱, chu̱ naacstutzucuko̱y la̱makasi̱tzi̱tahuilako̱y, chu̱ la̱ta̱la̱tlahuako̱y, pus chuná̱ ni̱ lay tapalhi̱y yama̱ pu̱ma̱paksí̱n, huata caj nala̱lactlahuaya̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na̱ chuna li̱tum, lapi̱ aktum xala c-chiqui̱ anta̱ni̱ pu̱tum huilakó̱ xlakkahuasan cha̱tum chixcú, hua̱mpi̱ xlacán caj naacstutzucuko̱y la̱makasi̱tzi̱tahuilako̱y la̱ta̱la̱tlahuako̱y, pus xlacán ni̱ lay catitapalhi̱ko̱lh sa̱mpi̱ lacapala̱ nala̱tamacaxtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pus huá̱ cca̱li̱huaniyá̱n, lapi̱ akskahuinín natapa̱pitziko̱y, chu̱ naacstutzucuko̱y la̱ta̱la̱tlahuako̱y, ni̱ lay maka̱s catitapalhi̱ko̱lh, hua̱mpi̱ huata antá̱ nalaksputko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Na̱ ti̱ni̱ lay kalhaxtuy tu̱ kalhi̱y cha̱tum tlihuaka chixcú lapi̱ ni̱ xapu̱lana̱ namakatlajacán, chu̱ nachi̱huili̱cán, chu̱ acxni̱ aya makatlajacani̱t, tla̱n natanu̱cán c-xchic, chu̱ nakalhaxtunicán pacs tu̱ kalhi̱y, pus na̱ chuná̱ la̱ntla̱ quit ctlahuani̱t akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n, pi̱ Dios tla̱n ma̱tzanka̱naniko̱y tachixcuhuí̱tat pacs xtala̱kalhi̱ncán, chu̱ na̱ chuná̱ pala tú̱ li̱quilhanko̱y ni̱ lacuan tachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Hua̱mpi̱ hua̱nti̱ cala̱huá̱ nali̱kalhkama̱nán hua̱ntu̱ xlá̱ luhua tancs catzi̱y pi̱ huá̱ xtascujut Espíritu Santo, xlá̱ ni̱ lay catima̱tzanka̱nanica̱ xtala̱kalhí̱n huata caxani̱li̱huayaj xtihua̱ xlá̱ lakahui̱ li̱akastacya̱huán.” ");
INSERT INTO tosNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Huá̱ chuná̱ li̱huaniko̱lh sa̱mpi̱ xlacán xquilhuama̱kó̱ pi̱ xlá̱ xkalhi̱y cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Acxnitiyá̱ chinko̱lh xtzi Jesús, xa̱hua̱ xnata̱lán, hua̱mpi̱ xlacán quilhtí̱n ta̱yako̱lh, chu̱ caj ma̱tasani̱nanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chu̱ hua̱nti̱ antá̱ acxtum xta̱huilakó̱ anta̱ni̱ xlá̱ xuí̱ Jesús, chuná̱ huaniko̱lh: —Putzama̱kó̱n mintzí, xa̱hua̱ mili̱nata̱lán, antá̱ ya̱kó̱ quilhtí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Hua̱mpi̱ xlá̱ chuná̱ huaniko̱lh: —¿Tí̱ hua̱ quintzí, chu̱ tí̱ luhua quinata̱lán? ");
INSERT INTO tosNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Huata xlá̱ lacaucxilhko̱lh hua̱nti̱ antá̱ xuilakó̱ c-xtuntamacni, chu̱ chuná̱ chihui̱nampá̱: —Hua̱ yumá̱ ti̱ luhua quintzí, chu̱ quinata̱lán. ");
INSERT INTO tosNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sa̱mpi̱ caxati̱cahuá̱ ti̱ xtláhualh xtalacasquin Dios, hua̱ tamá̱ quintzí, xa̱hua̱ quinata̱lán. ");
INSERT INTO tosNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","A̱maktum Jesús alh c-xquilhtu̱n ta̱kaya̱huaná̱ laqui̱mpi̱ antá̱ nama̱siyuniko̱y tachixcuhuí̱tat xtachihui̱n Dios, chu̱ luhua lhu̱hua̱ laktastokca̱ anta̱ni̱ xlá̱ xuí̱. Pus huá̱ li̱táju̱lh c-aktum pu̱tacutnu̱ hua̱ntu̱ xuí̱ c-xquilhtu̱n chúchut; antá̱ culucs tahui̱, chu̱ a̱makapitzí̱n li̱lhu̱hua̱ antá̱ tahuilako̱lh c-xquilhtu̱n chúchut laqui̱mpi̱ nakaxmatniko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesús lhu̱hua̱ hua̱ntu̱ li̱xakatli̱ko̱lh caj lactzu̱ takalhchihuí̱n, chu̱ maktum chuná̱ ta̱chihui̱nanko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Luhua caakatá̱kstit hua̱ntu̱ nacca̱li̱xakatli̱yá̱n: Maktum xuí̱ cha̱tum chana̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chu̱ acxni̱ cxpuyuti̱lhay xtalhtzi xli̱chánat, makapitzi̱ tama̱chá̱ c-tiji, minko̱chá̱ lactzu̱ spu̱n, chu̱ pacs sacuaqui̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Hua̱ntu̱ tama̱chá̱ xli̱chánat ca̱chihuixni, anta̱ni̱ ni̱ lhu̱hua̱ xkalhi̱y tíyat, tuncán pulhli. ");
INSERT INTO tosNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Hua̱mpi̱ acxni̱ táxtulh chichiní chíchilh na̱ lacapala̱ sca̱cli sa̱mpi̱ ni̱ pu̱lhmá̱n xma̱tzanka̱ko̱ni̱t xtankaxe̱kcán. ");
INSERT INTO tosNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lhu̱hua̱ xli̱chánat tama̱ko̱chá̱ ca̱lhtucuní̱n, chu̱ ni̱ maka̱s quilhtamacú̱ yama̱ tachaná̱n punko̱lh, hua̱mpi̱ a̱tzinú̱ lhtucú̱n lacapala̱ stacli, ma̱aklankanu̱ko̱lh, chu̱ ni̱ má̱xqui̱lh quilhtamacú̱ nastacko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Hua̱mpi̱ makapitzi̱n xli̱chánat tama̱ko̱chá̱ c-xatla̱n tíyat, chu̱ luhua tla̱n stacko̱lh lactzu̱ li̱chánat, chu̱ lhu̱hua̱ ma̱sta̱ko̱lh xatahuácat. Huí̱ tu̱ má̱sta̱lh puxamaca̱hu xtalhtzi caj akatum, chu̱ huí̱ tu̱ má̱sta̱lh tutumpuxam, chu̱ makapitzí̱n hasta aktum ciento.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Acxni̱ huanko̱lh yuma̱ takalhchihuí̱n, Jesús chuná̱ huaniko̱lh hua̱nti̱ xkaxmatnima̱kó̱ xtachihuí̱n: “¡Lapi̱ huixín kalhi̱yá̱tit mintake̱ncán pus li̱huana̱ cakaxpáttit laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ cca̱ma̱akata̱ksni̱putuná̱n!” ");
INSERT INTO tosNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Acxni̱ caja xacstucán tamakaxtakko̱lh Jesús, xa̱hua̱ xli̱ma̱kalhtahuáka̱t, chu̱ makapitzí̱n hua̱nti̱ ankalhí̱n xta̱latla̱huanko̱y, xlacán laktalacatzuhui̱ko̱lh, chu̱ kalhasquinko̱lh xatú̱ xuamputún yama̱ takalhchihuí̱n xpa̱lacata chana̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús chuná̱ huaniko̱lh: “Xli̱ca̱na̱, huixín Dios ca̱ma̱akata̱ksni̱putuná̱n la̱ntla̱ xlá̱ lacasquín calatama̱ko̱lh hua̱nti̱ natapaksi̱niko̱y, hua̱mpi̱ hua̱ la̱ntla̱ makapitzi̱n tachixcuhuí̱tat, ma̱squi cli̱ma̱xtunima̱kó̱ hua̱ntu̱ xlacán lakapasko̱y, ni̱ pala chuná̱ catili̱lacputzako̱lh la̱ntla̱ naakatakskoy. ");
INSERT INTO tosNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chu̱ chuná ma̱squi lhu̱hua̱ hua̱ntu̱ caucxilhko̱lh tu̱ quit ctlahuako̱y, caj chunata natamakaxtakko̱y xta̱chuná̱ pala ni̱tú̱ ucxilhko̱lh; ma̱squi caquinkaxmatniko̱lh hua̱ntu̱ cli̱chihui̱nama̱, ni̱tú̱ catiakata̱ksko̱lh. Chu̱ lapi̱ ni̱ naca̱najlay la̱ntla̱ tu̱ Dios li̱xakatli̱ko̱y xtalakalhamá̱n, xlá̱ ni̱ lay catima̱tzanka̱naniko̱lh xtala̱kalhi̱ncán.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chu̱ Jesús huanipalako̱lh hua̱nti̱ kalhasquinko̱lh: “Lapi̱ huixín ni̱ akata̱ksá̱tit yuma̱ xatakalhchihui̱n chana̱ná̱ hua̱ntu̱ ni̱ pala tuhua̱, ¿lá̱ntla̱ chú̱ naakata̱ksá̱tit a̱makapitzí̱n tu̱ caj takalhchihuí̱n hua̱ntu̱ nactica̱huaniyá̱n a̱li̱sta̱lh? ");
INSERT INTO tosNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yama̱ chixcú̱ hua̱nti̱ alh chan xli̱chánat, huá̱ xta̱chuná̱ qui̱taxtuy hua̱nti̱ li̱akchihui̱nán xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yuma̱ tachaná̱n hua̱ntu̱ tama̱ko̱chá̱ c-tiji̱ li̱taxtuko̱y caxati̱cahuá̱ ti̱ kaxmatko̱y xtachihuí̱n la̱ntla̱ xlá̱ lacasquín nalatama̱ko̱y c-xasa̱sti xtapáksi̱t, hua̱mpi̱ mina̱chá̱ akskahuiní, chu̱ ma̱pa̱nu̱y yama̱ tachihuí̱n hua̱ntu̱ xchancani̱t c-xnacu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ c-ca̱chihuixni, na̱ chuná̱ li̱taxtuko̱y hua̱nti̱ acxni̱ kaxmatko̱y xtachihui̱n Dios, luhua aktum tapa̱xuhuá̱n ca̱najlako̱y, lakati̱ko̱y, chu̱ tla̱n tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Hua̱mpi̱ cumu ni̱ pu̱lhmá̱n xkalhi̱y xtankaxe̱kcán, ni̱ luhua maka̱s makapalako̱y, acxni̱ chú̱ min tu̱ nali̱talactuhuajko̱y, usu huí̱ ti̱ li̱aksanko̱y caj xpa̱lacata li̱pa̱huanko̱y xtachihui̱n Dios, tzucuko̱y li̱puhuanko̱y, huata tu̱ tlahuako̱y, xatlá̱n tuncán li̱makaxtakta̱yako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ ca̱lhtucuní̱n, na̱ chuná̱ qui̱li̱taxtuy hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, ");
INSERT INTO tosNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","hua̱mpi̱ cumu antá̱ c-xlatama̱tcán a̱tzinú̱ li̱ta̱katzanka̱ko̱y catu̱huá̱ hua̱ntu̱ huí̱ xala ca̱tuxá̱huat la̱ntla̱ nakalhi̱ko̱y lhu̱hua tumi̱n, chu̱ la̱ntla̱ li̱pa̱xuhu nalatama̱ko̱y, pus chuná̱ li̱ta̱kskahuitama̱ko̱y xli̱pacs hua̱ntu̱ xlacán lakati̱ko̱y, chu̱ na̱ chuná̱ chú̱ li̱ma̱aklankanu̱ko̱y tu̱ catzi̱ko̱y xtapaksi̱t Dios, chu̱ ni̱ ma̱xqui̱ko̱y quilhtamacú̱ nama̱sta̱ko̱y xtahuacatcán. ");
INSERT INTO tosNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Chu̱ yama̱ li̱chánat tu̱ tama̱ko̱chá̱ c-xatla̱n tíyat, chu̱ ma̱sta̱ko̱y xatahuácat li̱taxtuko̱y hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, ca̱najlako̱y, li̱pa̱huanko̱y, chu̱ li̱tzaksako̱y li̱scujko̱y c-xlatama̱tcán, chuná̱ ma̱sta̱ko̱y xtahuacatcán: huí̱ tu̱ ma̱sta̱ko̱y puxamaca̱hu, chu̱ huí̱ tu̱ ma̱sta̱ko̱y tutumpuxam, usu aktum ciento caj la̱ntla̱ cha̱tunu.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús na̱ huanipalako̱lh yuma̱ takalhchihuí̱n: “Acxni̱ cha̱tum ma̱pasi̱y aktum mákskot, ¿pi̱ caj la̱ntla̱ nama̱pasi̱y natamacanu̱y c-xtampi̱n xpu̱tama? ¿Usuchí̱ nali̱talahuili̱y aktum cajón? Pus hua̱nti̱ kalhi̱y aktum mákskot huata huili̱y ta̱lhmá̱n c-xpu̱táhui̱lh laqui̱mpi̱ mákat namakaxkaka̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na̱ chuná̱ ni̱ lay tú̱ tze̱k tlahuacán pala ni̱ fuerza̱ natasiyuy lacatzucu̱, chu̱ hua̱ntu̱ caj tze̱k li̱catzi̱cán pala ni̱ ca̱lakuá̱n natamakaxtaka. Pala aktum quintachihuí̱n ni̱ lay akata̱ksá̱tit, namín quilhtamacú̱ acxni̱ pacs naakata̱ksá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Huá̱ xpa̱lacata̱ cca̱li̱huaniyá̱n, pala huixín kalhi̱yá̱tit mintake̱ncán fuerza̱ catlahuanítit caakatá̱kstit quintachihuí̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús huanipalako̱lh: “Li̱huana̱ caakatá̱kstit hua̱ntu̱ quinkaxpatnipá̱tit, sa̱mpi̱ chuná̱ la̱ntla nali̱tzaksati̱lhayá̱tit akata̱ksá̱tit xatla̱n xtalacapa̱stacni Dios tu̱ cca̱ma̱siyuniti̱lhayá̱n, Dios na̱ xaa̱li̱huacá̱ naca̱ma̱xqui̱ti̱lhayá̱n talacapa̱stacni̱ laqui̱mpi̱ natiakata̱ksá̱tit tlakcu lhu̱hua xatla̱n xtalacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pus hua̱nti̱ laktzaksay akata̱ksa̱ hua̱ntu̱ kalhi̱y, a̱tzinú̱ natima̱xqui̱cancú ta̱kata̱ksni; hua̱mpi̱ hua̱nti̱ ni̱ li̱tzaksaputún maclacasquín ta̱kata̱ksni̱ hua̱ntu̱ kalhi̱y, xlá̱ namaklhti̱ko̱cán hasta ma̱squi xma̱n huá̱ hua̱ntu̱ kalhi̱y.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús chuná̱ huanipalako̱lh: “Xtapaksi̱t Dios na̱ xta̱chuná̱ qui̱taxtuy la̱ntla̱ cha̱tum chixcú̱ ti̱ an chan xtalhtzi xli̱chánat c-xpú̱cuxtu. ");
INSERT INTO tosNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","A̱li̱sta̱lh xlá̱ an c-xchic laqui̱mpi̱ najaxa, chu̱ nalhtatay. Maka̱s quilhtamacú̱ nalacatza̱lay, chu̱ yama̱ li̱chánat punta̱cxtuy, na̱ staca, hua̱mpi̱ xlá̱ ni̱ catzi̱y xatú̱ li̱stacma̱, sa̱mpi̱ hua̱ tíyat ma̱stacama̱. ");
INSERT INTO tosNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yama̱ li̱chánat lakpún, pulha, taxtuniy xtankáxe̱k, staca, xana̱y, chu̱ a̱li̱sta̱lh ma̱sta̱y xatahuácat, hua̱mpi̱ yuma̱ tachaná̱n pacs c-tíyat tíyalh hua̱ntu̱ lí̱stacli, chu̱ tíyat tu̱ ma̱láni̱lh xalí̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cha̱nchu̱ acxni̱ lakchá̱n xquilhtamacú̱ la̱ntla̱ catlán huata an qui̱y xtahuacat xtachaná̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús huampá̱: “¿La̱ntla̱ puhuaná̱tit natzucuy xtapaksi̱t Dios yunú̱ ca̱tuxá̱huat? Usuchí̱ ¿túcuya̱ takalhchihuí̱n tla̱n xta̱ma̱lacaxtumi̱hu? ");
INSERT INTO tosNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Puschí̱ xta̱chuná̱ natzucuy, chu̱ nastaca̱ la̱ntla̱ xtalhtzi mostaza acxni̱ chancán c-tíyat. Yuma̱ li̱chánat hua̱ntu̱ a̱tzinú̱ tlak lactzu̱ xatalhtzi quihui̱ ni̱ma̱ lacapala̱ staca, chu̱ tlanca quihui huan. ");
INSERT INTO tosNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Hua̱mpi̱ acxni̱ chancán xlá̱ tzucuy staca, chu̱ luhua ta̱lhmá̱n huan; chu̱ ni̱tú̱ makalakchá̱n, chu̱ hasta luhua laclhma̱n xpakaní̱n taxtuniy, hasta lactzu̱ spu̱n tla̱n tlahuako̱y antá̱ xma̱sakacán c-xpakaní̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús xliankalhí̱n xli̱xakatli̱ko̱y tachixcuhuí̱tat caj la̱ cuento c-xtakalhchihuí̱n laqui̱mpi̱ pacs naakata̱ksko̱y hua̱ntu̱ xuaniputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xlá̱ ni̱tú̱ xli̱ta̱chihui̱nanko̱y pala ni̱ fuerza̱ nali̱ma̱xtuniko̱y hua̱ntu̱ xlacán xlakapasko̱y; chu̱ lapi̱ xli̱ma̱kalhtahuáka̱t ni̱ pacs xakata̱ksko̱y, a̱li̱sta̱lh xlá̱ xli̱ma̱akata̱ksni̱ko̱y hua̱ntu̱ xuaniputún. ");
INSERT INTO tosNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yama̱ quilhtamacú̱ acxni̱ aya tzí̱sualh, chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Catacutui̱ caahu c-xa̱quilhtu̱tu ta̱kayahuaná. ");
INSERT INTO tosNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Puschí̱ makaxtakko̱lh li̱lhu̱hua̱ c-xquilhtu̱n chúchut, xli̱ma̱kalhtahuáka̱t taju̱ko̱lh c-pu̱tacutnu̱ anta̱ni̱ xtaju̱ma̱ Jesús hua̱ntu̱ aya xli̱kalhkalhi̱ma̱ca̱. A̱makapitzí̱n lactzu̱ pu̱tacutnu̱ na̱ sta̱laniko̱lh anta̱ni̱ xama̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Xlá̱ alh c-xtanka̱n pu̱tacutnu, chu̱ tíyalh aktum acxtícat, chu̱ antá̱ táma̱lh laqui̱mpi̱ nalhtatay. Hua̱mpi̱ caj li̱puntzú̱ taká̱talh palha u̱n, na̱ li̱pe̱cua̱ tzúculh ta̱kaya̱huay ta̱kaya̱huaná, tzúculh tanakataju̱y chúchut c-pu̱tacutnu, hasta xtakalhtzamamajá. Pus xli̱ma̱kalhtahuáka̱t lacapala̱ ma̱stacuani̱ko̱lh Jesús, chu̱ chuná̱ huaniko̱lh: —Ma̱kalhtahuaka̱ná, cata̱qui. ¿Tú̱ xpa̱lacata ni̱ cuí̱ntaj tlahuaya̱ sa̱mpi̱ namu̱xtuya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús tá̱qui̱lh, li̱ma̱páksi̱lh catácacsli̱ u̱n, chu̱ chuná̱ huánilh ta̱kaya̱huaná: —¡Cacs catahuila, chu̱ nia̱lh cata̱kaya̱hua! Puschí̱ yama̱ u̱n xa̱hua̱ ta̱kaya̱huaná cacs tahuilako̱lh. Xli̱ca̱na̱ luhua maktum tacá̱cacsli. ");
INSERT INTO tosNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —¿Tú̱huan taji̱ li̱pe̱cuaná̱tit? ¡Xli̱ca̱na̱ pi̱ huixín ni̱ luhua quili̱pa̱huaná̱tit! ");
INSERT INTO tosNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hua̱mpi̱ xlacán caj cacs xlacahuanko̱ni̱t, sa̱mpi̱ luhua tla̱n xmaka̱klhako̱ni̱t hua̱ntu̱ xtlahuani̱t Jesús, chu̱ xma̱n huá̱ tla̱n chuná̱ xla̱huaniko̱y xacstucán: —¿Pus tú̱ ya̱ li̱tlihuaka̱ kalhi̱y yuma̱ chixcú, pi̱ hasta ma̱squi hua̱ u̱n, chu̱ ta̱kaya̱huaná̱ kalhakaxmatko̱y acxni̱ xlá̱ ma̱paksi̱ko̱y? ");
INSERT INTO tosNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pus timinko̱chá̱ c-xa̱quilhtu̱tu ta̱kaya̱huaná̱, chu̱ cha̱nko̱lh c-aktum ca̱chiquí̱n huanicán Gadara. ");
INSERT INTO tosNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Acxni̱ tácutli̱ Jesús c-pu̱tacutnu, tuncán tímilh pa̱xtoka̱ cha̱tum chixcú̱ ti̱ xla̱kalhi̱nini̱t xtalacapa̱stacni akskahuiní, yama̱ chixcú̱ xlá̱ titáxtulh c-xtampi̱n sipi̱ c-lhucu̱ anta̱ni̱ xma̱nu̱ko̱cán ni̱ní̱n, ");
INSERT INTO tosNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","sa̱mpi̱ xkalhi̱y xpu̱táhui̱lh antá. Luhua li̱xcájnit xli̱catzi̱y, ni̱tí̱ lay xmacalay xli̱tlihuaka̱ laqui̱mpi̱ nachi̱huili̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Xli̱maklhu̱huatá̱ tzaksaca̱ li̱chi̱cán cadena, chu̱ li̱cá̱n, c-xtuhuán, chuj chí̱ c-xmacán, hua̱mpi̱ hua̱ cadena, lactzu̱ lactzú̱ xtlahuani̱t, xlacputxni̱t, chu̱ hua̱ li̱cá̱n, pacs xlactucxa, na̱ ti̱ ni̱ lay xma̱actu̱ju̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na̱ xli̱ankalhí̱n, ca̱cuhuiní, chu̱ ca̱tzi̱sní, xca̱tasapu̱lay ca̱ka̱sti̱ní̱n, chu̱ c-pu̱ta̱cnú̱n, chu̱ xacstuli̱ma̱sipa̱ni̱cán chíhuix. ");
INSERT INTO tosNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makatcú̱ xmina̱chá̱ Jesús acxni̱ úcxilhli, takosú̱n lákmilh, chu̱ acxni̱ cha̱lh anta̱ni̱ xyá̱, lakatatzokóstalh. ");
INSERT INTO tosNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Hua̱mpi̱ Jesús li̱ma̱páksi̱lh: —Huix cspiritu akskahuiní, camakáxtakti̱ tama̱ chixcú. La̱ xe̱k ca̱tásalh, chuná̱ kálhti̱lh: —Jesús, xCam Dios xala ta̱lhmá̱n, ¿Tú̱ huix quinca̱li̱ta̱talacastuca? Tlanca li̱tlá̱n cca̱squiniyá̱n pi̱ ni̱ naquinca̱ma̱pa̱ti̱ni̱ya. ");
INSERT INTO tosNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kalhásquilh: —¿Tú̱ huanicana? Yama̱ cspiritu akskahuiní̱ chuná̱ kalhtí̱nalh: —Cli̱tapa̱cuhui̱ya̱hu Legión sa̱mpi̱ quilhu̱huacán hua̱nti̱ cpuxcu̱naniya̱hu yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na̱ luhua tlanca li̱tlá̱n squiniko̱lh Jesús pi̱ ni̱ natlakale̱nko̱y a̱lacatanu̱ c-tíyat. ");
INSERT INTO tosNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chu̱ antá̱ lacatzú̱ c-ka̱stí̱n xlapu̱lako̱y kampu̱tum lhu̱hua paxni, xputxua̱yama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Acxni̱ cspiritu akskahuiní̱ ucxilhko̱lh lhu̱hua paxni, luhua tlanca li̱tlá̱n squiniko̱lh Jesús, chuná̱ huaniko̱lh: —Caquinca̱ma̱xqui̱ talacasquín nacpa̱laktaju̱ya̱hu yama̱ kampu̱tum paxni̱ laya̱kó̱ tanú̱ lacatzú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma̱n huá̱ lacasquiniko̱lh Jesús, taxtuko̱lh yama̱ lhu̱hua cspiritu akskahuinín, aya pa̱laktaju̱ko̱lh paxni. Pero yama̱ paxni̱ tzucuko̱lh kosnanko̱y, anko̱lh lacatum anta̱ni̱ luhua c-xuástat, antá̱ chú̱ taju̱ko̱chá̱ c-ta̱kaya̱huaná̱ anta̱ni̱ tijicsuako̱lh; ma̱x pala aktuy mi̱lh xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cha̱nchu̱ hua̱nti̱ xmaktakalhma̱kó̱ paxni, acxni̱ ucxilhko̱lh la̱ntla̱ ni̱ko̱lh paxni, takosú̱n tza̱lako̱lh, chu̱ cani̱huá̱ c-tiji, chu̱ anta̱ni̱ caj pu̱lahuilako̱ca̱ li̱chihui̱nanko̱lh hua̱ntu̱ xakspulako̱ni̱t. Puschí̱ lhu̱hua chixcuhuí̱n minko̱lh ucxilhko̱y yumá̱ tu̱ xlani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Acxni̱ chinko̱lh anta̱ni̱ xyá̱ Jesús, ucxilhko̱lh chixcú̱ ti̱ xapu̱lana̱ xkalhi̱y yama̱ kampu̱tum cspiritu akskahuinín, antá̱ xlá̱ cajá xuí̱, tla̱n xlhaka̱nani̱t, na̱ luhua actancsá xuí̱ c-xtalacapa̱stacni. Pero xlacán xpe̱cuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Makapitzí̱n ti̱ luhua xucxilhko̱ni̱t la̱ntla̱ xakspulani̱t chixcú̱ ti̱ xpa̱laktaju̱ni̱t akskahuiní, chuj chí̱ xpa̱lacata̱ paxni̱ la̱ntla̱ ni̱ko̱lh, tzucuko̱lh li̱chihui̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Hua̱mpi̱ acxni̱ tla̱n akata̱ksko̱lh hua̱ntu̱ xtlahuani̱t Jesús tzucuko̱lh huaniko̱y pi̱ catláhualh li̱tlá̱n, catatampú̱xtulh c-xca̱chiqui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Acxni̱ Jesús táju̱lh c-pu̱tacutnu, yuma̱ chixcú̱ ti̱ xapu̱lh xkalhi̱y xtalacapa̱stacni akskahuiní, chuná̱ huánilh: —Catlahua̱ li̱tlá̱n, caquima̱xqui̱ talacasquín nacsta̱laniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Hua̱mpi̱ Jesús ni̱ tla̱n tlahuánilh tu̱ csquinima̱, huata chuná̱ huánilh: —Catáspitti̱ c-mínchic, calakpinkó̱ mili̱nata̱chiquí̱n. Cali̱xakatli̱kó̱ la̱ntla̱ tlanca li̱tlá̱n tlahuanini̱tán Quimpu̱chinacán, chu̱ la̱ntla̱ kayaj catzanini̱tán acxni̱ ma̱pacsán. ");
INSERT INTO tosNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pus yama̱ chixcú̱ alh, xlá̱ tzúculh li̱chihui̱nán la̱ntla̱ Dios xmakta̱yani̱t, chu̱ hua̱nti̱ xkaxmatniko̱y, luhua xca̱cni̱naníko̱y Jesús caj xpa̱lacata xtascújut hua̱ntu̱ xlá̱ xtlahuani̱t, cani̱huá̱ xli̱chihui̱nancán Jesús c-akca̱hu lactzu̱ ca̱chiquí̱n tu̱ la̱ntla̱ xli̱pacscán xli̱tapa̱cuhui̱y Decápolis. ");
INSERT INTO tosNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Acxni̱ Jesús qui̱táspitli̱ c-xa̱quilhtu̱tu, chu̱ tácutli̱ c-pu̱tacutnu, lhu̱hua tuncán tilaktastokpalako̱lh anta̱ni̱ xlá̱ xlaya̱ c-xquilhtu̱n chúchut, chu̱ antá̱ xlá̱ tzúculh li̱xakatli̱palako̱y xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Caj li̱puntzú̱ chilh cha̱tum xapuxcu ma̱paksi̱ná̱ xala c-xpu̱kalhtahuakacan judíos xuanicán Jairo. Acxni̱ úcxilhli̱ Jesús, alh lakatatzokostay, ");
INSERT INTO tosNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","chu̱ chuná̱ huánilh: —Quintzuma̱t luhua snu̱n ta̱tatlay, chu̱ aya ni̱ma̱. Caquinta̱pi̱ c-quínchic laqui̱mpi̱ huix nali̱acchipaya̱ mimacán, chu̱ nama̱pacsaya, laqui̱mpi̱ li̱pa̱xuhu nalatama̱palay. ");
INSERT INTO tosNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pus Jesús tá̱alh, hua̱mpi̱ luhua xtzamacán c-tiji, hasta xla̱lacxquititi̱lhacán. ");
INSERT INTO tosNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cha̱nchu̱ c-xlaksti̱pa̱ncan li̱lhu̱hua̱ xmakmima̱ cha̱tum pusca̱t hua̱nti̱ aya xkalhi̱y akcu̱tuy ca̱ta̱ la̱ntla̱ xta̱tatlay, cstajmakama̱ kalhni, chu̱ niucxni̱ xtamakaxtekniy. ");
INSERT INTO tosNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Chu̱ lhu̱hua ma̱cuchi̱naní̱n xma̱cuchi̱ko̱ni̱t, hua̱mpi̱ caj tla̱n xma̱pa̱ti̱ni̱ko̱ni̱t sa̱mpi̱ ni̱tú̱ xmakta̱yako̱ni̱t, caj tla̱n xmaklhti̱ko̱ni̱t xtumi̱n hua̱ntu̱ xlá̱ xkalhi̱y, chu̱ li̱huacá̱ xtasnu̱ni̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Huá̱ xpa̱lacata, acxni̱ káxmatli̱ la̱ntla̱ xli̱chihui̱nancán Jesús xlá̱ chuná̱ puhua̱: “Huatiya̱ lapi̱ xacqui̱tóklhnilh tama̱ xlháka̱t, yuma̱ quintajátat napacsa.” Cha̱nchu̱ pi̱ luhua xtzamacán, xlá̱ lacatzucu̱ laktalacatzúhui̱lh c-xke̱n, chu̱ tze̱k xamánilh clhaka̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pus tuncán titachokónilh xkalhni̱ anta̱ni̱ cstajtamakama̱, chu̱ scayaj li̱cátzalh xtiyatli̱hua̱ pi̱ aya xpacsnini̱t xtajátat. ");
INSERT INTO tosNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Hua̱mpi̱ Jesús makcátzi̱lh tuncán pi̱ hua̱ tlanca xli̱tlihuaka̱ xli̱pacsni̱t cha̱tum. Xlá̱ talakáspitli, tzúculh lacaputza̱nán anta̱ni̱ xya̱kó̱ li̱lhu̱hua, chu̱ chuná̱ kalhasquiní̱nalh: —¿Tí̱ xámalh quilháka̱t? ");
INSERT INTO tosNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Cha̱nchu̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Huix ucxílhpa̱t pi̱ luhua tzamacán, chu̱ cati̱huá̱ qui̱toklhma̱kó̱n la̱ntla̱ lacxquitiko̱yá̱n, na̱ huana: ‘¿Tí̱ xámalh quilháka̱t?’ ");
INSERT INTO tosNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Hua̱mpi̱ Jesús ca̱x tzúculh lacaputza̱nán lacaxtum laqui̱mpi̱ naucxilha̱ tí̱ cxamanini̱t xlháka̱t, chu̱ xma̱pacsani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yama̱ pusca̱t xcatzi̱y pi̱ huá̱ xma̱pacsacani̱t, huá̱ xpa̱lacata tzúculh li̱pe̱cuán, clhpipima̱ talacatzúhui̱lh anta̱ni̱ xyá̱ Jesús, lakatatzokóstalh c-xlacatí̱n, huánilh pi̱ huá̱ xamanini̱t clháka̱t, chu̱ xma̱pacsani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús huánilh: —Na̱na̱, huix pacsni̱ta̱ sa̱mpi̱ ca̱najlani̱ta̱ pi̱ quit tla̱n nacma̱pacsayá̱n, li̱pa̱xuhu capit c-mínchic, sa̱mpi̱ la̱nchú̱ aya pacsni̱t mintajátat. ");
INSERT INTO tosNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús chunacú̱ xchihui̱nama̱ acxni̱ chinko̱lh makapitzí̱n, xlacán minko̱chá̱ c-xchic Jairo. Chuná̱ huaniko̱lh xtla̱t yama̱ tzuma̱t: —U̱cu ni̱lh mintzuma̱t. ¿Tú̱ taji̱ li̱ma̱acchichijui̱ya̱ ma̱kalhtahuaka̱na Jesús? ");
INSERT INTO tosNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Hua̱mpi̱ Jesús ni̱ cuí̱ntaj tlahuaniko̱lh hua̱ntu̱ xlacán xquilhuama̱kó̱, chu̱ chuná̱ huánilh Jairo: —Huix chunacú̱ caquili̱pá̱huanti, chu̱ ni̱ capé̱cuanti. ");
INSERT INTO tosNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ni̱ lacásquilh pacs nasta̱laniko̱y, caj xma̱n Pedro, Santiago, xa̱hua̱ Juan, xta̱la Santiago. ");
INSERT INTO tosNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Acxni̱ cha̱nko̱lh c-xchic Jairo, úcxilhli̱ pi̱ luhua tzamacán, chu̱ pacs xtasama̱kó̱, chu̱ xli̱puhuahuilako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús tánu̱lh c-chiqui, chu̱ huaniko̱lh: —¿Tú̱ xpa̱lacata acchilij tanu̱pá̱tit, chu̱ tasapá̱tit? Pus tama̱ tzuma̱t caj lhtatama̱, ni̱ xaní̱n la̱ntla̱ huixín puhuaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Puschí̱ huata caj tzúculh li̱li̱tzi̱nko̱y xtachihuí̱n. Jesús huaniko̱lh pi̱ pu̱tum cataxtuko̱lh, caj xma̱n xtzi, xa̱hua̱ xtla̱t yama̱ tzuma̱t, chu̱ hua̱nti̱ xta̱minko̱ni̱t ta̱tanu̱ko̱lh anta̱ni̱ xmá̱. ");
INSERT INTO tosNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chipánilh xmacan tzuma̱t, huánilh: —Talita cum (yuma̱ c-xatachihui̱n arameo xuaniputún: “Huix cuanimá̱n, tzuma̱t, cata̱qui.”) ");
INSERT INTO tosNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Yuma̱ tzuma̱t cajcu xakcu̱tuy ca̱ta xuani̱t, tuncán tá̱qui̱lh, chu̱ xlá̱ tzúculh tla̱huán. Chu̱ hua̱nti̱ xucxilhma̱kó̱ lhpipak li̱lacahuanko̱ni̱t li̱ca̱cni̱ tu̱ xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ali̱sta̱lh Jesús li̱pe̱cua̱ li̱ma̱lakapaksi̱ko̱lh Xtla̱tcán pi̱ ni̱tí̱ cacátzi̱lh la̱ntla̱ lakastakuánalh xtzuma̱tcán, chú na̱ huaniko̱lh cama̱hui̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A̱li̱sta̱lh Jesús titaxtupá̱, chu̱ ta̱anko̱lh xli̱ma̱kalhtahuáka̱t c-xca̱chiquí̱n anta̱ni̱ xlá̱ cstacni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Acxni̱ chilh sábado, acxni̱ pacs judíos xjaxko̱y, Jesús tánu̱lh c-xpu̱kalhtahuakacán, chu̱ tzúculh ma̱siyuniko̱y ti̱ xtamakstokko̱ni̱t xtachihui̱n Dios. Pacs ti̱ xkaxmatnima̱kó̱ li̱lhu̱hua, caj lanaj xli̱lacahuanko̱y xtachihuí̱n, sa̱mpi̱ ni̱ xakata̱ksko̱y ní̱ xtiyani̱t talacapa̱stacni. Makapitzí̱n chuná̱ tzúculh la̱huaniko̱y: —¿Ní̱ cahuá̱ catzí̱nilh pacs yuma̱ lanca talacapa̱stacni̱ hua̱ntu̱ catzi̱y yuma̱ chixcú? Usu ¿tí̱ má̱xqui̱lh li̱skálalh, chu̱ la̱ntla̱ kálhi̱lh li̱tlihuaka̱ nali̱tlahuay lactlanca li̱ca̱cni tatlahu hua̱ntu̱ tlahuako̱y? ");
INSERT INTO tosNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pus ¿tú̱ hua̱ yumá̱ carpintero, xkahuasa María, chu̱ na̱ xnata̱lán Santiago, chu̱ José, xa̱hua̱ Judas, chu̱ Simón, chu̱ xnata̱lan lactzumaján ti̱ na̱ antá̱ u̱nú̱ huilakó̱, chu̱ lakapasko̱ya̱hu? Antá̱ c-xca̱chiquí̱n chuná̱ xpuhuaniko̱y, huá̱ xpa̱lacata lhu̱hua̱ ni̱ xma̱tla̱ni̱ko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hua̱mpi̱ huaniko̱lh Jesús: —Pu̱tum tachixcuhuí̱tat li̱pa̱huanko̱y cha̱tum profeta pi̱ nali̱akchihui̱naniko̱y xtalacapa̱stacni Dios hua̱ lapi̱ xala a̱lacatanu̱ ca̱chiquí̱n, hua̱mpi̱ hua̱nti̱ antá̱ xala c-xca̱chiquí̱n hua̱nti̱ xli̱ta̱chiqui, chu̱ xli̱nata̱lán, ni̱ xma̱tla̱ni̱niko̱y hua̱ntu̱ li̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús ni̱ lalh li̱ma̱lacahua̱ni̱ko̱lh ti̱ xala c-Nazaret pala tú̱ tlanca li̱ca̱cni xtláhualh, sa̱mpi̱ xnata̱chiquí̱n ni̱ xca̱najlaniko̱y pi̱ xkalhi̱y li̱tlihuaka̱ nali̱tlahuay, caj xma̱n cha̱stuy ma̱tla̱ni̱ko̱lh naacuili̱ko̱y xmacán, chu̱ ma̱pacsaniko̱lh xtajatatcán. ");
INSERT INTO tosNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús luhua li̱pe̱cua̱ lilakapútzalh, chu̱ li̱puhua̱, sa̱mpi̱ xlacán ni̱ xca̱najlaniputunko̱y. Huata alh a̱lacatanu̱ lactzu̱ ca̱chiquí̱n laqui̱mpi̱ antá̱ nali̱akchihui̱nán xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Maktum ma̱makstokko̱lh kalhacu̱tuy xli̱ma̱kalhtahuáka̱t, chu̱ huaniko̱lh pi̱ naanko̱y li̱cha̱tiyú̱n li̱akchihui̱nanko̱y xtachihuí̱n. Ma̱xqui̱ko̱lh li̱tlihuaka, chu̱ tapáksi̱t pi̱ tla̱n natamacaxtuko̱y cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na̱ li̱ma̱paksi̱ko̱lh pi̱ ni̱tú̱ nale̱nko̱y xala c-xtijicán hua̱ntu̱ namaclacasquinko̱y pala pú̱xtoko, na̱ ni̱ pala caxtala̱nchu̱, na̱ ni̱ pala tumi̱n hua̱ntu̱ nali̱hua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Huaniko̱lh pi̱ tla̱n nale̱nko̱y xtatuhuanu̱ncán, hua̱mpi̱ xma̱n hua̱ntu̱ xtatuhuanu̱ko̱ni̱t, xa̱hua̱ xlhaka̱tcán caj hua̱ntu̱ xlhaka̱ko̱ni̱t, chu̱ kantuma xli̱xtokocán. ");
INSERT INTO tosNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chuná̱ huaniko̱lh: —Cani̱cahuá̱ anta̱ni̱ naca̱ma̱nu̱caná̱tit c-aktum chiqui, antá̱ natamakaxtaká̱tit hasta ni̱li̱huaya̱ nataxtuya̱pítit antá̱ yama̱ lacatum. ");
INSERT INTO tosNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lapi̱ c-aktum chiqui usu ca̱chiquí̱n ni̱tlá̱n naca̱tlahuacaná̱tit, chu̱ ni̱ nakaxmatputunko̱y hua̱ntu̱ huixín li̱chihui̱nampá̱tit, pus huata huixín cataxtútit, chu̱ acxni̱ nataxtuyá̱tit caca̱tantu̱tincxcántit pokxni̱ hua̱ntu̱ antá̱ ca̱lactahuacán laqui̱mpi̱ xlacán nacatzi̱ko̱y pi̱ huixín nia̱lh mincui̱ntajcán lapi̱ naaktzanka̱ko̱y tama̱ chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yama̱ xli̱ma̱kalhtahuáka̱t taca̱xko̱lh, chu̱ anko̱lh c-lactzu̱ ca̱chiquí̱n, tzucuko̱lh li̱akchihui̱naniko̱y tachixcuhuí̱tat pi̱ catalakaspita̱yako̱lh, chu̱ calakpali̱ko̱lh lacli̱xcajnit xtalacapa̱stacnicán tu̱ kalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na̱ lhu̱hua ta̱tatlaní̱n ma̱pacsako̱lh, caj aceite xli̱tlahuako̱y, na̱ lhu̱hua̱ hua̱nti̱ xkalhi̱ko̱y cspiritu akskahuiní̱ tamacaxtuniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Acxni̱ rey Herodes cátzi̱lh la̱ntla̱ xli̱chihui̱nancán xtascujut Jesús, sa̱mpi̱ cani̱cahuá̱ xta̱kahuani̱ni̱t tachihuí̱n, chuná̱ huá̱: —Hua̱ tama̱ chixcú, Juan Bautista, lakastakuánalh ca̱li̱ní̱n; huachá̱ chuná̱ tla̱n li̱tlahuay lactlanca li̱ca̱cni tatlahu, chu̱ li̱kalhi̱y li̱tlihuaka. ");
INSERT INTO tosNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Makapitzí̱n na̱má̱ xuanko̱y: —Tama̱ chixcú, ma̱x hua̱ Elías, usu ni̱ tzanká̱ xatí̱ ya̱ profeta hua̱nti̱ xpa̱lacachihui̱nanko̱y Dios maka̱n quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hua̱mpi̱ acxni̱ káxmatli̱ yuma̱ rey Herodes, chuná̱ xuan: —Tama̱ chixcú̱ luhua lacatancs pi̱ hua̱ Juan Bautista hua̱nti̱ quit cma̱pixca̱acti̱ní̱nalh xakxe̱ka, chu̱ la̱nchú̱ xlá̱ aya lakastakuanani̱t ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Sa̱mpi̱ na̱má̱ akspulani̱t acxni̱ ma̱makni̱ní̱nalh rey Herodes: Maktum quilhtamacú̱ Juan Bautista huánilh rey Herodes: “Ni̱tlá̱n la̱ntamá̱ lápa̱t, ni̱ mi̱li̱ta̱tahuílat xpusca̱t minta̱lá.” Pus huá̱ xpa̱lacata rey Herodes li̱ma̱tamacanu̱ní̱nalh c-pu̱la̱chi̱n, chu̱ li̱ma̱paksí̱nalh cali̱chi̱huili̱ca̱ cadena, sa̱mpi̱ ni̱tlá̱n tláhualh acxni̱ li̱huánilh pi̱ xta̱la̱maktakalhma̱ xpusca̱t xta̱la Felipe. ");
INSERT INTO tosNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Chu̱ na̱ chuná̱ yama̱ pusca̱t xuanicán Herodías, ni̱ xucxilhputún Juan sa̱mpi̱ xli̱huanini̱t la̱ntla̱ xta̱hui̱ xya̱stá, xliankalhí̱n xputzama̱ la̱ntla̱ natlahuay pi̱ tla̱n namakni̱y, hua̱mpi̱ ni̱ lay xta̱ksa̱ la̱ntla̱ natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Xa̱huachí̱ Herodes xcatzi̱y pi̱ Juan Bautista luhua tla̱n xcatzi̱y, chu̱ xli̱makapa̱xuhuay Dios xlatáma̱t. Lakachuní̱n hasta xlakati̱y xkaxmatniy xtachihuí̱n ma̱squi na̱ xli̱aklituanán tu̱ xli̱huanima̱. Huachá̱ xli̱macpuhuaniy tzinú̱, ni̱ xma̱xqui̱y quilhtamacú̱ Herodías pala tu̱ natlahuaniy. ");
INSERT INTO tosNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hua̱mpi̱ milh quilhtamacu̱ acxni̱ ta̱ksli̱ la̱ntla̱ natlahuay namakni̱y Juan, sa̱mpi̱ rey Herodes xma̱katzi̱ma̱ xca̱ta, chu̱ tláhualh aktum tahua̱y, chu̱ tica̱tasaniko̱lh xanapuxcun ma̱paksi̱naní̱n, chu̱ xanapuxcun tropa̱, chu̱ ti̱ calacatí̱n xya̱niko̱lh xala c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Cha̱nchu̱ xtzuma̱t Herodías caj li̱puntzú̱ tánu̱lh anta̱ni̱ xli̱pa̱xuhuama̱ca̱ xtucuhuiní, xlá̱ tzúculh tantli̱y. Pus Herodes, chu̱ xli̱pacs ti̱ antá̱ xuilakó̱ lakati̱ko̱lh la̱ntla̱ tántli̱lh. Rey Herodes na̱má̱ huánilh yama̱ tzuma̱t: —Huix caquisquini̱ hua̱ntu̱ a̱tzinú̱ lakati̱ya, chu̱ quit nacma̱xqui̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hasta tlak quilhpa̱tanú̱nilh, huanipá̱: —Ma̱squi luhua lhu̱hua tíyat xquisquini̱ hua̱ntu̱ quit cma̱paksi̱y, chu̱ quit nacmacama̱xqui̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pus táxtulh tzuma̱t, chu̱ kalhásquilh xtzi: —¿Tú̱ cahuá̱ xacsquínilh quintú̱tla̱t, pus huan pi̱ pacs tu̱ nacsquiniy xlá̱ naquima̱xqui̱y? Xtzi̱ chuná̱ huánilh: —Huá̱ casquini̱ xakxe̱ka̱ Juan Bautista. ");
INSERT INTO tosNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lacapala̱ chú̱ xlá̱ tánu̱lh anta̱ni̱ xuí̱ Rey, chu̱ chuná̱ huánilh: —Clacasquín pi̱ chuj tuncán naquimpu̱ma̱xqui̱ paktum pula̱tu̱ xakxe̱ka Juan Bautista. ");
INSERT INTO tosNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Acxni̱ chuná̱ káxmatli̱ rey Herodes hua̱ntu̱ xlacasquín yuma̱ tzuma̱t, cacs lacahua̱, chu̱ tali̱puhuá̱ni̱lh tzinú̱, hua̱mpi̱ ni̱ lay la̱ntla̱ nahuán lapi̱ ni̱ catimá̱xqui̱lh hua̱ntu̱ csquinima̱, sa̱mpi̱ aya xli̱ta̱yanini̱t nama̱xqui̱y, chu̱ pi̱ na̱ antá̱ c-xlacati̱ncán ti̱ antá̱ macxtum xta̱huilakó̱ c-pu̱hua̱y, ni̱ lactlahuapútulh. ");
INSERT INTO tosNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Puschí̱ tuncán ma̱lakácha̱lh rey cha̱tum tropa̱, li̱ma̱páksi̱lh pi̱ tuncán nali̱miniy xakxe̱ka Juan. ");
INSERT INTO tosNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tíalh tropa̱ c-pu̱la̱chi̱n, pixcá̱acti̱lh xakxe̱ka Juan, pu̱lí̱milh pula̱tu̱ la̱ntla̱ xli̱ma̱paksi̱cani̱t, chu̱ alh ma̱xqui̱y rey Herodes. Xlá̱ macamá̱xqui̱lh yama̱ tzuma̱t, chu̱ yama̱ tzuma̱t macamá̱xqui̱lh xtzi. ");
INSERT INTO tosNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Acxni̱ catzi̱ko̱lh hua̱nti̱ luhua csta̱lanipu̱lakoy Juan, anko̱lh tiyako̱y xtiyatli̱hua̱ laqui̱mpi̱ nama̱acnu̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","A̱li̱sta̱lh, ni̱ li̱maka̱s, xtalakacha̱ni̱n Jesús qui̱taspitko̱lh, chu̱ tzucuko̱lh li̱xakatli̱ko̱y xli̱pacs hua̱ntu̱ xtlahuako̱ni̱t, chu̱ la̱ntla̱ xma̱siyuniko̱ni̱t tachixcuhuí̱tat xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A̱li̱sta̱lh Jesús huaniko̱lh: —Catántit, caahu jaxa̱hu lacatum tlak ca̱tze̱k anta̱ni̱ tzili̱s ca̱huán laqui̱mpi̱ ni̱tí̱ naquinca̱akaxculiyá̱n. Chuná̱ huaniko̱lh sa̱mpi̱ nia̱lh lay aktziyaj xua̱yanko̱y, pus lhu̱hua̱ xminko̱y ucxilhko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pus ta̱taju̱ko̱lh c-aktum pu̱tacutnu, chu̱ anko̱lh lacatum anta̱ni̱ tzili̱s ca̱huán, caja ka̱nu̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Hua̱mpi̱ lhu̱hua̱ tiucxilhko̱lh acxni̱ táca̱xli̱ pu̱tacutnu, chu̱ lakapasko̱lh ti̱ antá̱ xtaju̱ma̱, chu̱ cani̱hua̱ xalaní̱n tuncán catzi̱ko̱lh ni̱ xcha̱ma̱kó̱, chu̱ huá̱ xapu̱lana̱ cha̱nko̱lh ni̱ xa̱chá̱n Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Acxni̱ tácutli̱ Jesús c-pu̱tacutnu, tiucxilhli̱ pi̱ lhu̱hua̱ chixcuhuí̱n xuilakó̱ xta̱chuná̱ la̱ntla̱ xaaktzanka̱n calhni̱lu̱ hua̱nti̱ ni̱tí̱ cui̱ntajlako̱y. Jesús kayaj catzaniko̱lh, chu̱ lhu̱hua̱ hua̱ntu̱ tzúculh ma̱siyuniko̱y lactla̱n talacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Acxni̱ chú̱ luhua aya xko̱tanu̱y, xli̱ma̱kalhtahuáka̱t lakminko̱lh anta̱ni̱ xuí̱, chu̱ chuná̱ huaniko̱lh: —Aya natzi̱suán, chu̱ u̱nú̱ lacatum tzili̱s ca̱huán, ni̱tí̱ huilako̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cahuanikó̱ pi̱ caanko̱lhá̱ c-lactzu̱ ca̱chiquí̱n, usu c-xchiccán hua̱nti̱ pu̱lahuilakó̱ lacatzú̱, chu̱ antá̱ catama̱huako̱lh caxtala̱nchu̱ hua̱ntu̱ nahuako̱y sa̱mpi̱ ni̱tú̱ li̱minko̱y tu̱ nahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Hua̱mpi̱ Jesús kalhti̱ko̱lh: —Huata xatlá̱n huixín cama̱hui̱kó̱tit. Xlacán chuná̱ kalhti̱nanko̱lh: —Hua̱mpi̱, ¿Ní̱ chú̱ nactiyaya̱hu yama̱ lhu̱hua tumi̱n tu̱ nacli̱tama̱huaya̱hu caxtala̱nchu̱ laqui̱mpi̱ xaacchá̱n nacma̱hui̱ko̱ya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús kalhasquinko̱lh: —¿Ní̱ macli̱t caxtala̱nchu̱ kalhi̱yá̱tit? Caqui̱ucxílhtit. Acxni̱ qui̱ucxilhko̱lh, huaniko̱lh: —Huí̱ macquitzis caxtala̱nchu̱, xa̱hua̱ tantuy squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús li̱ma̱paksí̱nalh pi̱ nahuaniko̱cán xli̱pacscán pi̱ natahuilako̱y antá̱ ca̱snapanka ca̱sakatna, caj kampu̱tu kampu̱tu. ");
INSERT INTO tosNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Puschí̱ titahuilako̱lh kampu̱tu, pala akatunu ciento, makapitzí̱n pala ita̱tna ciento tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús tíyalh yama̱ macquitzis caxtala̱nchu̱, xa̱hua̱ tantuy squi̱ti; talacayá̱hualh c-akapú̱n, pa̱xcatcatzí̱nilh Dios xlí̱huat. A̱li̱sta̱lh lakchákalh yama̱ caxtala̱nchu̱, chu̱ ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t laqui̱mpi̱ nama̱akpitziniko̱y xli̱pacs ti̱ antá̱ xuilakó̱. Na̱ chuna li̱tum ma̱akpitziniko̱ca̱ xli̱pacscán yama̱ tantuy squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pacs chí̱ tihua̱yanko̱lh, na̱ tikalhkasko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̱li̱sta̱lh xli̱ma̱kalhtahuáka̱t sacqui̱ko̱lh tu̱ akatá̱xtulh a̱pakatzuni̱n caxtala̱nchu̱, chu̱ squi̱ti̱ tu̱ ni̱ huako̱lh yama̱ tachixcuhuí̱tat, pa̱cu̱tuy pakxu̱ tima̱tzamako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Hua̱nti̱ tihua̱yanko̱lh, xkatzi̱ko̱y pala akquitzis mi̱lh chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A̱li̱sta̱lh Jesús ma̱lacapali̱ko̱lh xli̱ma̱kalhtahuáka̱t cataju̱ko̱lh c-pu̱tacutnu̱ laqui̱mpi̱ xlacán pu̱lh huá̱ napa̱tacutnanko̱ya̱chá, naanko̱y c-xa̱li̱quilhtu̱tu chúchut, c-aktum ca̱chiquí̱n huanicán Betsaida; huaniko̱lh Jesús pi̱ a̱li̱sta̱lh nalakcha̱nko̱y sa̱mpi̱ a̱cu xma̱quilhanu̱ma̱kó̱, xuanima̱kó̱ yama̱ tachixcuhuí̱tat pi̱ caanko̱lhá̱ c-xchiccán. ");
INSERT INTO tosNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Acxni̱ chú̱ pacs xma̱quilhanu̱ko̱ni̱t tachixcuhuí̱tat, tiaksputtahui̱ ka̱stí̱n caj c-xpa̱nú̱tat laqui̱mpi̱ xacstu natlahuay oración. ");
INSERT INTO tosNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Acxni̱ chú̱ luhua aya li̱huana̱ tzí̱sualh, yama̱ pu̱tacutnu̱ xama̱chá c-xlaquita̱t ta̱kaya̱huaná, chu̱ xacstu Jesús xtamakaxtakni̱t c-xquilhtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Puschí̱ tilacácha̱lh luhua mákat, úcxilhli̱ clhtokole̱nko̱y pu̱tacutnu. Xtlakuanko̱ni̱t, sa̱mpi̱ hua̱ u̱n, luhua xma̱pu̱spitma̱kó̱ la̱ntla̱ csnokmín. Chu pala a̱yujá xca̱xkakay tilakminko̱lh, xkalhtla̱hua̱nti̱lhama̱ chúchut; xtasiyuy la̱mpala aya xakapu̱laputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Acxni̱ ucxilhko̱lh xakatla̱huama̱ chúchut, puhuanko̱lh pi̱ ma̱x caj maka̱klhaná̱ xucxilhma̱kó̱, tzucuko̱lh ca̱tasako̱y, ");
INSERT INTO tosNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sa̱mpi̱ pacs ucxilhko̱lh, na̱ luhua pe̱cuanko̱lh. Hua̱mpi̱ tuncán xakatli̱ko̱lh Jesús, huaniko̱lh: —Cama̱tlihuaklhcántit, ni̱ cape̱cuántit; sa̱mpi̱ quit Jesús hua̱nti̱ cca̱lakama̱chá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A̱li̱sta̱lh laktaju̱ko̱lh c-pu̱tacutnu, chu̱ tuncán talakachókolh u̱n. Xli̱ma̱kalhtahuaka̱t Jesús lanaj xlacahuanko̱ni̱t, ni̱ xcatzi̱ko̱y tu̱ nahuanko̱y sa̱mpi̱ luhua li̱pe̱cua̱ xaklituananko̱ni̱t, ");
INSERT INTO tosNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sa̱mpi̱ ni̱ xakata̱ksko̱ni̱t yama̱ tlanca tascújut ni̱ma̱ xma̱siyuniko̱ni̱t, chu̱ ma̱squi aya xucxilhpalakoni̱t xtascújut acxni̱ ma̱hui̱ko̱lh caxtala̱nchu̱, xnacu̱cán ni̱ lay xakata̱ksko̱y la̱ntla̱ luhua nali̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Acxni̱ pa̱tacutko̱lh ta̱kaya̱huaná xala c-Galilea, chanko̱lh c-aktum tíyat huanicán Genesaret, chu̱ antá̱ chi̱huili̱ko̱lh xpu̱tacutnucán. ");
INSERT INTO tosNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cha̱nchu̱ acxni̱ tacutko̱lh, hua̱nti̱ antá̱ xalaní̱n lakapasko̱lh pi̱ hua̱ Jesús hua̱nti̱ xchini̱t, ");
INSERT INTO tosNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","xlacán tuncán li̱chihui̱nanko̱lh c-xli̱ca̱tlanca yama̱ tíyat, chu̱ xli̱pacs ta̱tatlaní̱n ti̱ antá̱ xuilakó̱ tzucuko̱lh pu̱li̱minko̱cán pu̱chaxna̱ anta̱ni̱ xkaxmatko̱y pi̱ xuí̱ Jesús laqui̱mpi̱ nama̱pacsako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na̱ chuná̱ cani̱cahuá̱ anta̱ni̱ xcha̱n Jesús, c-lactzu̱ ca̱chiquí̱n, usu anta̱ni̱ xtiji̱tla̱huán c-tlanca̱ti̱, usu anta̱ni̱ xti̱taxtuy anta̱ni̱ caj pu̱lahuilako̱ca̱, antá̱ xuili̱ko̱cán ta̱tatlaní̱n; na̱ csquiniko̱y li̱tlá̱n pi̱ cama̱xqui̱ko̱lh talacasquín caj natoklhko̱y, ca̱na̱ pi̱ xma̱n c-xtampaksta̱n xtalhaká̱n; pus lhu̱hua̱ ta̱tatlaní̱n pacs ma̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Maktum tilaktalacatzuhui̱ko̱lh Jesús makapitzi̱n fariseos, xa̱hua̱ xma̱kalhtahuaka̱nani̱n judíos, xlacán xminko̱ni̱tanchá̱ c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cumu aya xmakskalama̱kó̱ laqui̱mpi̱ nata̱ksko̱y hua̱ntu̱ nali̱ya̱huako̱y, ucxilhko̱lh pi̱ makapitzi̱n xli̱ma̱kalhtahuáka̱t, acxni̱ xua̱yanko̱y, ni̱ xmakachakanko̱y la̱ntla̱ xli̱smani̱ko̱ni̱t judíos xli̱ca̱cni̱naniko̱y Dios, huá̱ xpa̱lacata tzucúcaj li̱aksanko̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sa̱mpi̱ hua̱ fariseos, xa̱hua̱ xli̱pacs Judíos, xli̱smani̱ko̱ni̱t xquilhtiyako̱y la̱ntla̱ xminti̱lhani̱tanchá̱ lactzu̱ lactzu̱ xtahuilatcán xamaka̱n xnatla̱tnacán. Acxni̱ xlacán xua̱yanko̱y, pu̱lh tla̱n namacatahuacako̱y chúchut caj la̱mpala cali̱macasiculana̱tlahuacán laqui̱mpi̱ mat xlakachixcuhui̱ko̱y Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na̱ acxni̱ xqui̱tama̱huananko̱y c-pu̱tama̱huán, ni̱ catihua̱yanko̱lh pala ni̱ pu̱lh nali̱makachakanko̱y tzinú̱ chúchut. Na̱ lhu̱hua a̱makapitzí̱n xtahuilatcán anán tu̱ tiquilhtiyako̱lh nali̱makaxtakko̱y, na̱ chuná̱ pala xpu̱kotnucán, usu cxa̱lujcán, usu chu̱ xpu̱scujnicán xla li̱cá̱n, cu̱ hasta ma̱squi xpu̱tamacán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Makapitzi̱n fariseos, chu̱ xma̱kalhtahuaka̱nacan judíos lakminko̱lh Jesús, chu̱ kalhasquinko̱lh: —¿Tú̱huan ni̱ xta̱chuná̱ li̱tlahuako̱y mili̱ma̱kalhtahuáka̱t la̱ntla̱ minti̱lhani̱tanchá̱ xtahuilatcan quinatla̱tnacán, hua̱mpi̱ caj chunata macali̱xcajnit xmacancán li̱huako̱y xli̱huatcán? ");
INSERT INTO tosNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús chuná̱ kalhti̱ko̱lh: —Xli̱ca̱na̱ tu̱ tihua̱ profeta Isaías c-xlibro̱ acxni̱ xlá̱ aya xucxilhlacacha̱ma̱ la̱ntla̱ huixín xalakapu̱tiyu̱tnani̱n minta̱yatcán, sa̱mpi̱ xlá̱ chuná̱ títzokli̱ mimpa̱lacatacán: ‘Hua̱ yuma̱ tachixcuhuí̱tat, caj luhua xma̱n xquilhnicán li̱chihui̱nanko̱y acxni̱ huanko̱y pi̱ mat quili̱pa̱huanko̱y, chú quilakachixcuhui̱ko̱y, hua̱mpi̱ huata antá̱ c-xnacu̱cán luhua tunu̱ talacapa̱stacni̱ kalhi̱ko̱y quimpa̱lacata, chu̱ chuná̱ chú̱ quima̱makatli̱niko̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pus luhua xli̱ca̱na̱ pi̱ ni̱tu̱ xtápalh ma̱squi quili̱ma̱xqui̱ko̱y ca̱cni, sa̱mpi̱ xli̱pacs hua̱ntu̱ xlacán li̱ma̱paksi̱nanko̱y catlahuako̱lh tachixcuhuí̱tat pacs huá̱ caj xtasmani̱ncan chixcuhuí̱n, chu̱ ni̱ huá̱ hua̱ntu̱ quit cli̱ma̱paksi̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Sa̱mpi̱ huixín lakmakaná̱tit xli̱ma̱paksi̱n Dios la̱ntla̱ sta̱laniyá̱tit caj xtahuilatcan chixcuhuí̱n, chu̱ na̱maj chú̱ lakchaka̱pi̱ko̱yá̱tit mimpu̱kotnucán, chu̱ mixalujcán, xa̱hua̱ tu̱ maclacasquiná̱tit mimpu̱kotnucán, chu̱ lhu̱hua̱ a̱makapitzi̱ catu̱hua̱ xta̱chuná̱ huixín tlahuayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na̱ huaniko̱lh: —Huixín la̱ntla̱ tlahuayá̱tit mintahuilatcán lakachuní̱n hasta ni̱tú̱ xtápalh li̱ma̱xtuyá̱tit xli̱ma̱paksi̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Maká̱n quilhtamacú̱ Moisés chuná̱ ma̱puhuá̱ni̱lh Dios catzoklhi̱ xli̱ma̱paksí̱n: ‘Capa̱xqui, chu̱ calakalhámanti̱ mintla̱t, chu̱ mintzí. Pala cha̱tum nata̱la̱tlahuay xtla̱t, usu xtzi, chu̱ pala naxcajua̱xakatli̱y, tamá̱ luhua mini̱niy pi̱ maktum cani̱lh.’ ");
INSERT INTO tosNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Hua̱mpi̱ chi̱nchu̱ kalhtum ma̱luloká̱tit pi̱ ni̱ tlahuay talakalhí̱n acxni̱ pala tú̱ qui̱tzanka̱niko̱y mintla̱tcán, usu lacasquín namakta̱yako̱yá̱tit, chu̱ huixín chuná̱ nahuaniko̱yá̱tit: ‘La̱nchú̱ ni̱ lay cca̱makta̱yayá̱n ma̱squi xacca̱makta̱yaputún, sa̱mpi̱ xli̱pacs hua̱ntu̱ ckalhi̱y actzú̱, pacs huá̱ cma̱lacnu̱nini̱t Dios pi̱ nacli̱ca̱cni̱naniy, chu̱ huá̱ chú̱ nacma̱xqui̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Acxni̱ chuná̱ huixín huaná̱tit, luhua lacatancs huamputuná̱tit pi̱ nia̱lh niucxni̱ catimakta̱yátit mintla̱tcán, usu hua̱ mintzicán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chuná̱ huixín ni̱tú̱ xtapalh tlahuayá̱tit xli̱ma̱paksi̱n Dios hua̱ntu̱ huan la̱ntla̱ nala̱makta̱yayá̱tit, caj xpa̱lacata li̱smani̱ni̱tántit tlahuayá̱tit makapitzi̱n talacapa̱stacni̱ hua̱ntu̱ mini̱tanchá̱ xtahuilatcan minatla̱tnacán. Na̱ lhu̱hua̱ catu̱huá̱ ná̱ yuma̱ xta̱chuná̱ ni̱tla̱n tapuhuá̱n kalhi̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Acxni̱ la̱nchuná̱ huaniko̱lh fariseos, tasaniko̱lh chú̱ xli̱pacs li̱lhu̱hua̱ pi̱ catalacatzuhui̱ko̱lh, chu̱ chuná̱ huaniko̱lh: —Caquinkaxpatnítit mili̱pacscán, na̱ caakatá̱kstit tu̱ nacca̱huaniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Huixín catzi̱yá̱tit hua̱ntu̱ huay cha̱tum, an hasta c-xpu̱lacni, chu̱ ni̱ lakla̱kalhi̱niy xli̱stacna, hua̱ntu̱ lakla̱kalhi̱niy xli̱stacna hua̱ntu̱ mina̱chá̱ c-xpu̱lacni xnacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","¡Lapi̱ huixín kalhi̱yá̱tit mintake̱ncán pus li̱huana̱ cakaxpáttit laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ cca̱ma̱akata̱ksni̱putuná̱n! ");
INSERT INTO tosNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","A̱li̱sta̱lh acxni̱ Jesús tapa̱nu̱niko̱lh li̱lhu̱hua, na̱ ta̱tanu̱ko̱lh xli̱ma̱kalhtahuáka̱t c-xchic, xlacán tikalhasquinko̱lh xatú̱ xuaniputún yama̱ takalhchihuí̱n tu̱ xli̱xakatli̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Cha̱nchu̱ huaniko̱lh: —¿Tú̱huan ni̱ lay akata̱ksá̱tit huixín hua̱ntu̱ cca̱huaniputuná̱n? Huixín tla̱n catzi̱yá̱tit pi̱ xli̱pacs hua̱ntu̱ huay cha̱tum, ni̱ lay catima̱xcajua̱lí̱nilh xli̱stacna, ");
INSERT INTO tosNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","sa̱mpi̱ ni̱ antá̱ cha̱n c-xnacú̱, hua̱mpi̱ ma̱n antá̱ c-xpa̱lu̱hua, chu̱ a̱li̱sta̱lh makampalay c-xcajuá̱lat. Jesús acxni̱ chuná̱ huá̱, xuamputún pi̱ catu̱hua̱ tu̱ huacán, pacs tla̱n huacán, chu̱ ni̱ catima̱xcajuá̱li̱lh xlatama̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Cha̱nchu̱ chuná̱ huanipalako̱lh: —Hua̱mpi̱ ma̱xcajua̱li̱y xli̱stacna cha̱tum hua̱ntu̱ mina̱chá̱ xtapuhuá̱n c-xnacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sa̱mpi̱ antá̱ mina̱chá̱ c-xpu̱lacni, c-xnacu̱ cha̱tum, chuná̱ pala ni̱ lacuán tapuhuá̱n; antá̱ puhuán la̱ntla̱ nalakamaklhti̱y xpusca̱t achatum, la̱ntla̱ naxakatli̱y tanuj pusca̱t, usu chixcú, chu̱ la̱mákni̱t, la̱ntla̱ nakalha̱nán, ");
INSERT INTO tosNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","chu̱ la̱ntla̱ naaksani̱nán, usu nalakcatzán catu̱huá̱ tu̱ ni̱ xlá, naquiclhcatzaniy a̱chatum, usu nasitziniy, chu̱ catu̱huá̱ tu̱ ni̱ lacuan tapuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pacs hua̱ na̱ yumá̱ tu̱ ni̱tla̱n talacapa̱stacni̱ mina̱chá̱ c-xnacú, chu̱ ma̱xcajua̱li̱niy xli̱stacna c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ni̱ li̱maka̱s, taca̱xta̱qui̱chá̱ antá, tíalh latapu̱li̱y lacatzú̱ ca̱chiquí̱n huanicán Tiro chu̱ Sidón. Maktum acxni̱ tánu̱lh c-chiqui̱ anta̱ni̱ namaktahuilay, ti̱ni̱ cacátzi̱lh tipuhua̱, hua̱mpi̱ ni̱ lay tátze̱kli. ");
INSERT INTO tosNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Sa̱mpi̱ cha̱tum pusca̱t, ni̱ antá̱ xala c-Israel xuani̱t, xlá̱ xli̱chihui̱nán griego, xalacachín xuani̱t c-Sirofenicia, luhua xamakat tíyat. Xlá̱ xuí̱ cha̱tum xtzuma̱t hua̱nti̱ xma̱xcajua̱li̱nini̱t xtalacapa̱stacni cspiritu akskahuiní. Ma̱n huá̱ cátzi̱lh anta̱ni̱ xuí̱ Jesús, tuncán lákchilh, lakatatzokóstalh c-xlacatí̱n, huánilh pi̱ cama̱pácsalh, chu̱ catama̱xtúnilh cspiritu akskahuiní̱ hua̱ntu̱ xkalhi̱y xtzuma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Hua̱mpi̱ Jesús chuná̱ kálhti̱lh: —Caquima̱xqui̱ quilhtamacú̱ pu̱lh cacmakta̱yako̱lh xlakskata̱n Dios hua̱nti̱ yunú̱ xala c-Israel, sa̱mpi̱ ni̱ tla̱n maklhti̱ko̱cán xli̱huatcan camán laqui̱mpi̱ nama̱xqui̱ko̱cán lactzu̱ chichí̱n, hua̱nti̱ ni̱ napa̱xcatcatzi̱niko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Hua̱mpi̱ yama̱ pusca̱t akáta̱ksli̱ tu̱ xuaniputún, chu̱ chuná̱ kálhti̱lh: —Quimpuchiná, xli̱ca̱na̱ xlá̱ la̱ntla̱ huana, hua̱mpi̱ hasta lactzu̱ chichixni ni̱ma̱ tahuilako̱y c-xtampi̱n mesa sacuaqui̱ko̱y hua̱ntu̱ ni̱ huako̱y xli̱huatcan camán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús chuná̱ huánilh: —Luhua clakáti̱lh la̱ntla̱ chihui̱nani̱ta, tla̱n li̱pa̱xuhu napina̱ c-mínchic sa̱mpi̱ yama̱ cspiritu akskahuiní, aya makaxtakni̱t mintzuma̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Puschí̱ yama̱ pusca̱t, lacapala̱ alh c-xchic, chu̱ acxni̱ cha̱lh, xli̱ca̱na̱ ma̱nóklhulh xtzuma̱t, nia̱lh xkalhi̱y cspiritu akskahuiní, lacastalanca xuani̱t, chu̱ clhtatama̱ c-xpu̱tama. ");
INSERT INTO tosNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús acxni̱ taxtupá̱ c-xatiyat Tiro, antá̱ alh c-xatiyat Sidón, a̱li̱sta̱lh pacs lakatza̱lako̱lh makapitzi̱n lactzu̱ ca̱chiquí̱n hua̱ntu̱ xuí̱ c-Decápolis (hua̱ yuma̱ tachihuí̱n huamputún: “Akca̱hu Chuchutsipi̱”), chu hasta tícha̱lh c-xquilhtu̱n ta̱kaya̱huaná̱ c-xtapaksi̱n Galilea. ");
INSERT INTO tosNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Antá̱ li̱minica̱ Jesús cha̱tum akata̱pa̱ko̱ko, squinica̱ li̱tlá̱n pi̱ nahuili̱niy xmacán c-xokspú̱n laqui̱mpi̱ napacsa. ");
INSERT INTO tosNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús lacatanu̱ tá̱alh yama̱ chixcú̱ anta̱ni̱ ni̱ luhua lhu̱hua̱ xlaya̱kó̱ chixcuhuí̱n laqui̱mpi̱ ni̱tí̱ naucxilhko̱y. Antá̱ akamá̱nu̱lh lactzu̱ xmacán c-xtaká̱n; a̱li̱sta̱lh chujli, chu̱ huilí̱nilh xchújut csi̱máka̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Láca̱lh c-akapú̱n, jalhpá̱ni̱lh, chu̱ chuná̱ huánilh: “¡Efata!” (yuma̱ c-xatachihui̱n arameo huamputún: “¡Catakáxmatli̱ cmintaká̱n!”) ");
INSERT INTO tosNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tuncán akahuá̱nalh, li̱kaxmatko̱lh xtaka̱n yama̱ chixcú, xa̱hua̱ csi̱máka̱t tatlá̱ni̱lh, chu̱ tla̱n tzúculh chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pacs cha̱tunu̱ hua̱nti̱ xma̱pacsay Jesús xuaniko̱y pi̱ ni̱ nali̱chihui̱nanko̱y, hua̱mpi̱ la̱ntla̱ ca̱x chuná̱ xuaniko̱y, huata ca̱x xlacán xli̱chihui̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Xli̱pacs ti̱ xcatzi̱ko̱ni̱t hua̱ntu̱ xtlahuako̱y Jesús, lanaj xlacahuanko̱y, chu̱ chuná̱ xuanko̱y: “Catu̱huá̱, pacs tla̱n ma̱tla̱ni̱y, chu̱ hasta ma̱squi ko̱koní̱n, pacs tla̱n ma̱chihui̱ni̱ko̱y, chu̱ akata̱paní̱n ma̱akatla̱ni̱ko̱y.” ");
INSERT INTO tosNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ni̱ li̱maka̱s acxni̱ luhua lhu̱hua̱ xli̱tamakstokni̱t Jesús, la̱ntla̱ alh quilhtamacú̱ chú̱ xlacán nia̱lh xkalhi̱ko̱y tu̱ nahuako̱y li̱lhu̱hua, pus xlá̱ tasaniko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Luhua kayaj ccatzaniko̱y yuma̱ li̱lhu̱hua tachixcuhuí̱tat, sa̱mpi̱ aya tu̱xamatá̱ la̱ntla̱ta quinta̱lapu̱lako̱y, chu̱ nia̱lh kalhi̱ko̱y tu̱ xli̱minko̱ni̱t xli̱hua̱yancán, ");
INSERT INTO tosNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","chu̱ palapi̱ cha̱tzincsni̱ nacuaniko̱y pi̱ caanko̱lhá̱ c-xchiccán, naxlajuananta̱yako̱y c-tiji, sa̱mpi̱ makapitzi̱n xlacán, mákat minko̱ni̱tanchá. ");
INSERT INTO tosNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xli̱ma̱kalhtahuáka̱t kalhti̱ko̱lh: —Hua̱mpi̱ ¿lá̱ntla̱ natlahuaya̱hu u̱nú̱ anta̱ni̱ tzili̱s ca̱huán nama̱hui̱ko̱ya̱hu xli̱pacs yuma̱ li̱lhu̱hua? ");
INSERT INTO tosNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús kalhasquinko̱lh: —Chi̱nchu̱ huixín, ¿ní̱ macli̱t caxtala̱nchu̱ li̱tani̱tántit? Xlacán kalhti̱nanko̱lh: —Mactujún. ");
INSERT INTO tosNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Puschí̱ ma̱paksi̱ko̱lh pi̱ li̱lhu̱hua̱ catahuilako̱lh ca̱tiyatna, Jesús tíyalh yama̱ mactujun caxtala̱nchu̱; acxni̱ pa̱xcatcatzí̱nilh Dios xlí̱huat, a̱li̱sta̱lh lakchákalh, chu̱ ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, huá̱ chú̱ xlacán ma̱akpitziniko̱lh li̱lhu̱hua. ");
INSERT INTO tosNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Chu̱ na̱ chuná̱ xkalhi̱ko̱y caj stantuy squi̱ti; Jesús na̱ má̱sta̱lh pa̱xcatcatzí̱nit, chu̱ li̱ma̱paksi̱ko̱lh pi̱ na̱ nama̱akpitziniko̱cán xli̱pacscán. ");
INSERT INTO tosNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pacs hua̱yanko̱lh, na̱ tla̱n kalhkasko̱lh; a̱li̱sta̱lh ma̱tzamako̱lh pa̱tujun lactlanca pakxu a̱pakatzuní̱n tu̱ xakata̱xtuni̱t ni̱ huako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Hua̱nti̱ tihua̱yanko̱lh, ma̱x xkatzi̱y pala akta̱ti mi̱lh tachixcuhuí̱tat. A̱li̱sta̱lh Jesús huaniko̱lh pi̱ caanko̱lhá̱ c-xchiccán, ");
INSERT INTO tosNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","chu̱ xlá̱ ta̱taju̱ko̱lh xli̱ma̱kalhtahuáka̱t c-aktum pu̱tacutnu, chu̱ anko̱lh c-aktum ca̱chiquí̱n huanicán Dalmanuta. ");
INSERT INTO tosNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Maktum lakminko̱lh anta̱ni̱ xlaya̱ Jesús makapitzi̱n fariseos, chu̱ tzucuko̱lh ta̱la̱huaniko̱y; a̱li̱sta̱lh caj xli̱slakputunko̱y, huaniko̱lh pi̱ catláhualh aktum tlanca li̱ca̱cni tatlahu hua̱ntu̱ nali̱ma̱lolokniko̱y pi̱ xli̱ca̱na̱ Dios xmacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús luhua maka̱s jalhpá̱ni̱lh li̱puhua̱, chu̱ chuná̱ kalhti̱ko̱lh: —¿Tú̱ xpa̱lacata huixín li̱squiná̱tit aktum xali̱ucxílhti̱t li̱ca̱cni̱ tatlahu hua̱ntu̱ caj nali̱lakasta̱naná̱tit? Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ ni̱ cactica̱tlahuanín hua̱ntu̱ huixín lacasquiná̱tit, sa̱mpi̱ ni̱ ca̱mini̱niyá̱n naucxilhá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Cha̱nchu̱ makaxtakko̱lh, tita̱taju̱palako̱lh xli̱ma̱kalhtahuáka̱t c-pu̱tacutnu, anko̱lh c-xa̱quilhtu̱tu ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xli̱ma̱kalhtahuaka̱t Jesús xpa̱tzanka̱ko̱ni̱t nale̱nko̱y hua̱ntu̱ nahuako̱y, chu̱ caj xma̱n mactum caxtala̱nchu̱ xle̱nko̱y c-pu̱tacutnu. ");
INSERT INTO tosNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús caj xamaktum chuná̱ huaniko̱lh: —Ca̱na̱ huixín, cuí̱ntaj caca̱tlahuacántit pi̱ ni̱ naca̱ma̱pasi̱yá̱n xali̱ma̱xcuti̱n xlevadurajcán fariseos, xa̱hua̱ xlevadura̱ rey Herodes. ");
INSERT INTO tosNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Cha̱nchu̱ yuma̱ xli̱ma̱kalhtahuáka̱t cumu ni̱ akata̱ksko̱lh hua̱ntu̱ xlá̱ xli̱chihui̱nama̱, xlacán na̱má̱ tzucuko̱lh la̱huaniko̱y: —Ma̱x huá̱ chuná̱ quinca̱li̱huaniyá̱n caj xpa̱lacata ni̱tú̱ li̱mina̱hu caxtala̱nchu̱ hua̱ntu̱ nahuaya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús cátzi̱lh hua̱ntu̱ xlacán xquilhuama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Tú̱huan la̱ntamá̱ la̱li̱xakatli̱pá̱tit pi̱ ni̱tú̱ li̱taná̱tit caxtala̱nchu̱ hua̱ntu̱ nahuayá̱tit? ¿Pi̱ chunacú̱ ni̱ lay akata̱ksá̱tit hua̱ntu̱ quit cca̱ma̱siyunini̱tán? ¿Pi̱ chunacú̱ ni̱ lay ca̱najlayá̱tit hua̱ntu̱ quit tla̱n ctlahuay? ");
INSERT INTO tosNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ma̱squi kalhi̱yá̱tit milakastapucán, la̱mpala ni̱ li̱lacahua̱naná̱tit. Ma̱squi kalhi̱yá̱tit mili̱akahua̱ncán la̱mpala ni̱ li̱kaxpatá̱tit. ¿Lá̱ntla̱ pi̱ ni̱ lay lacapa̱stacá̱tit hua̱ntu̱ quit ctlahuanit? ");
INSERT INTO tosNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Acxni̱ clakchákalh yama̱ caj macquitzis caxtala̱nchu̱, chu̱ cli̱ma̱huiko̱lh akquitzis mi̱lh tachixcuhuí̱tat, ¿ní̱mpa̱li̱t pakxu̱ ma̱stóktit a̱pakatzuní̱n hua̱ntu̱ xlacán ni̱ huako̱lh? Xlacán kalhti̱nanko̱lh: —Pa̱cu̱tuy pakxu. ");
INSERT INTO tosNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Chi̱nchu̱ acxni̱ cma̱hui̱ko̱lh akta̱ti mi̱lh tachixcuhuí̱tat, huixín xli̱tani̱tántit caj mactujun caxtala̱nchu̱, ¿ní̱mpa̱li̱t pakxu̱ ma̱stóktit a̱pakatzuní̱n hua̱ntu̱ ni̱ huako̱lh hua̱nti̱ hua̱yanko̱lh? Xlacán kalhti̱nampalako̱lh: —Pa̱tujun pakxu. ");
INSERT INTO tosNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús huaniko̱lh: —¿Pi̱ hasta ni̱ naj akata̱ksá̱tit pi̱ tanu̱ tu̱ cca̱li̱ma̱siyuniputuná̱n xatakalhchihui̱n li̱ma̱xcuti̱n levadura? ");
INSERT INTO tosNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ni̱ xli̱maka̱s cha̱nko̱lh c-aktum ca̱chiquí̱n huanicán Betsaida. Acxni̱ tácutli̱ Jesu̱s c-pu̱tacutnu, li̱minica̱ cha̱tum lakatzí̱n, tisquinica̱ li̱tlá̱n pi̱ ca̱na̱ caj catóklhli̱ xmacni̱ laqui̱mpi̱ napacsa. ");
INSERT INTO tosNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pus Jesús pakáti̱lh yama̱ lakatzí̱n, le̱lh c-xquilhapa̱n ca̱chiquí̱n, antá̱ li̱lacatláhualh xchújut c-xlakastapu, chu̱ kalhásquilh pala tla̱n tzinú̱ lacahua̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yama̱ lakatzí̱n lacahuá̱nalh tzinú̱, chu̱ chuná̱ huánilh: —Cucxilhko̱y chixcuhuí̱n xta̱chuná̱ la̱ akatum quihui, la̱mpala tla̱huama̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús huili̱nipá̱ xmacán c-xlakastapu̱ yama̱ chixcú, caj puntzú̱ cacs tá̱yalh, chu̱ aya tancs talacatlá̱ni̱lh, sa̱mpi̱ luhua tla̱n lacahuá̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús huánilh caalhá̱ c-xchic, chu̱ chuná̱ li̱ma̱páksi̱lh: —Huata ni̱ naj capit c-xpu̱ita̱t ca̱chiquí̱n, chu̱ ni̱tí̱ cali̱ta̱chihuí̱nanti̱ la̱ntla̱ huix lacahua̱nani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cha̱nchu̱ a̱li̱sta̱lh titaca̱xchá̱ Jesús, chu̱ ta̱anko̱lh xli̱ma̱kalhtahuáka̱t c-lactzu̱ ca̱chiquí̱n tu̱ xma̱paksi̱ko̱y c-xatíyat huanicán Cesarea de Filipo, chu̱ acxni̱ xlati̱lhako̱y c-tiji, tzucuko̱lh kalhputzako̱y, chu̱ huaniko̱lh: —¿Xatí̱ chixcú̱ quili̱ya̱huako̱y acxni̱ quili̱chihui̱nanko̱y chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xlacán kalhti̱ko̱lh: —Huí̱ ti̱ huan pi̱ mat huix Juan Bautista, chu̱ huí̱ ti̱ huan pi̱ ma̱x huix profeta Elías, mat lakastakuánanti̱ ca̱li̱ní̱n, chu̱ tampalani̱ta̱ ca̱tuxá̱huat, chu̱ makapitzí̱n huanko̱y pi̱ mat huix ti̱ ni̱ tzanká̱ tí̱ ya̱ profeta hua̱nti̱ xlama̱kó̱ maka̱sa quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús kalhasquinko̱lh: —¿Chá̱ huixín, xatí̱ quit quili̱ma̱xtuyá̱tit? Pedro luhua lacatancs kálhti̱lh: —Huix Cristo hua̱nti̱ macamini̱t Dios laqui̱mpi̱ naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Acxni̱ chuná̱ káxmatli̱ Jesús hua̱ntu̱ xlá̱ xuanini̱t Pedro, huaniko̱lh pi̱ ni̱tí̱ nali̱ta̱chihui̱nanko̱y hua̱ntu̱ xlacán xcatzi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A̱li̱sta̱lh tzúculh li̱ta̱chihui̱nanko̱y la̱ntla̱ napa̱ti̱y, chu̱ chuná̱ huaniko̱lh: —Quit Xatalacsacni Chixcú̱ naquilakmakanko̱y lakko̱lun ma̱paksi̱naní̱n, xa̱hua̱ xanapuxcun pa̱lijni, chu̱ fariseos, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos, sa̱mpi̱ ni̱ lakati̱ko̱y hua̱ntu̱ cma̱siyuy. A̱li̱sta̱lh naquimakni̱ko̱y, hua̱mpi̱ xli̱aktutu quilhtamacú̱ quit naclakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Xlá̱ luhua lacatancs huaniko̱lh hua̱ntu̱ naakspulay. Puschí̱ Pedro caj tánuj tita̱tapá̱nu̱lh, chu̱ tzúculh li̱huaniy xatú̱ xpa̱lacata chuná̱ xli̱chihui̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Cha̱nchu̱ xlá̱ talakáspitli; láca̱lh anta̱ni̱ xuilakó̱ a̱makapitzi̱n xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huánilh Pedro: —Luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n, huix akskahuiní, catatampu̱xtu̱ anta̱ni̱ cyá̱, sa̱mpi̱ huix ni̱ akata̱ksa̱ hua̱ntu̱ xtalacasquin Dios, hua̱mpi̱ xma̱n hua̱ntu̱ xla cati̱hua̱ chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cha̱nchu̱ a̱li̱sta̱lh tasaniko̱lh xli̱ma̱kalhtahuáka̱t, xa̱hua̱ li̱lhu̱hua̱ ti̱ na̱ csta̱lanima̱kó̱, chu̱ chuná̱ huaniko̱lh: —Lapi̱ huí̱ ti̱ luhua quili̱pa̱huán, chu̱ quista̱laniputún, chu̱ quili̱ma̱kalhtahuáka̱t huamputún, pus huata xlacasquinca̱ capa̱tzánka̱lh hua̱ntu̱ caj xacstu lakati̱y li̱pa̱xuhuay, xatlá̱n cacúcalh xcruz laqui̱mpi̱ napa̱ti̱nán caj quimpa̱lacata, chu̱ caquista̱lánilh cani̱huá̱. ");
INSERT INTO tosNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa̱mpi̱ hua̱nti̱ luhua lakcatzán pala namakatzanka̱y xlatáma̱t, juerza̱ namakatzanka̱y tu̱ lakcatzán, hua̱mpi̱ hua̱nti̱ ni̱ nalakcatzán xlatáma̱t pala namakatzanka̱y caj quimpa̱lacata, usu caj xpa̱lacata nali̱chihui̱nán xtachihui̱n Dios, xlá̱ nama̱laktaxti̱y c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Sa̱mpi̱ ¿tú̱ xtápalh qui̱taxtuniy cha̱tum, lapi̱ tla̱n xkálhi̱lh pacs la̱ntla̱ tu̱ anán ca̱tuxá̱huat, chu̱ lapi̱ huata antá̱ c-xlacati̱n Dios namakatzanka̱y xli̱stacna? ");
INSERT INTO tosNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Sa̱mpi̱ ¿ní̱ntla̱ cahuá̱ tla̱n cxokóxtulh xlatáma̱t cha̱tum laqui̱mpi̱ ni̱ napa̱ti̱nán? ");
INSERT INTO tosNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Chu̱ na̱ chuna li̱tum, pala tí̱ huixín naquili̱ma̱xanán, usuchí̱ nali̱ma̱xanán quintachihuí̱n c-xlacati̱ncan hua̱nti̱ ni̱tla̱n xtapuhua̱ncán yunú̱ xala ca̱tuxá̱huat, pus quit Xatalacsacni Chixcú̱ na̱ nacli̱ma̱xanán acxni̱ nacmimpalay a̱maktum, chu̱ nacta̱minko̱y ángeles laqui̱mpi̱ xli̱pacs tachixcuhuí̱tat naucxilhko̱y la̱ntla̱ kalhi̱y xli̱tlihuaka̱ xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús chuná̱ huanipalako̱lh: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ makapitzi̱n huixín hua̱nti̱ la̱nchú̱ u̱nú̱ yá̱tit c-quilacatí̱n, ni̱ a̱ni̱yá̱tit nahuán acxni̱ naucxilhá̱tit la̱ntla̱ natzucuy lay xtapaksi̱t Dios ca̱tuxá̱huat, chu̱ la̱ntla̱ tlanca li̱tlihuaka̱ nali̱mín. ");
INSERT INTO tosNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","A̱li̱akcha̱xan quilhtamacu̱ a̱li̱sta̱lh, Jesús alh c-aktum tlanca ka̱stí̱n, chu̱ caj xma̱n huá̱ ta̱anko̱lh Pedro, Santiago, xa̱hua̱ Juan. Acxni̱ aya xcha̱nko̱ni̱t, c-xlacati̱ncán Jesús tzúculh talakpali̱y, nia̱lh chuná̱ la̱ntla̱ ankalhí̱n xtasiyuy. ");
INSERT INTO tosNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cha̱nchu̱ xlháka̱t, titalakpáli̱lh, luhua snapapa̱ xtasiyuy, chu̱ luhua tzayajna̱hua, xta̱chuná̱ miqui, hasta ti̱ni̱ anán ma̱squi luhua tla̱n chakanán, pi̱ nama̱lakcha̱ni̱y la̱ntla̱ xli̱snapapa̱ yama̱ xlháka̱t hua̱ntu̱ ucxilhko̱lh xli̱ma̱kalhtahuaka̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Caj xamaktum ucxilhko̱lh a̱makapitzí̱n hua̱nti̱ xalakmaka̱n chixcuhuí̱n xuanko̱ni̱t, Elías, chu̱ Moisés, pus xta̱la̱xakatli̱ma̱kó̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro chuná̱ huánilh Jesús: —Ma̱kalhtahuaka̱ná, huata ma̱x xali̱huaca̱ tla̱n antiyá̱ u̱nú̱ xtahuilahu, hua̱ lapi̱ huix chuná̱ lacasquina, u̱ctlahuaya̱hu aktutu lactzu̱ pu̱ni̱lhcha̱ chiqui, aktum milá, aktum xla Moisés, xa̱hua̱ aktum xla Elías. ");
INSERT INTO tosNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yama̱ xli̱ma̱kalhtahuaka̱t Jesús xpe̱cuaxni̱ko̱ni̱t, chu̱ Pedro, caj nia̱lh xcatzi̱y tu̱ xquilhuama̱. ");
INSERT INTO tosNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Chunacú̱ xchihui̱nama̱ Pedro, caj xamaktum tatu̱tzúhui̱lh aktum puclhni̱ tu̱ ma̱lakapa̱tze̱kko̱lh, chu̱ c-xlacni puclhni̱ kaxmatko̱lh pi̱ taxtuchi̱ aktum tachihuí̱n hua̱ntu̱ chuná̱ huá̱: “Hua̱ yumá̱ Quincam hua̱nti̱ luhua cpa̱xqui̱y, xma̱n luhua cakalhakaxpáttit hua̱ntu̱ xlá̱ naca̱li̱ma̱paksi̱yá̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Acxni̱ xlacán laca̱mpalako̱lh, tzucuko̱lh lacaputzako̱y, nia̱lh pala tí̱ ucxilhko̱lh, hua̱mpi̱ caja xta̱stum Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A̱li̱sta̱lh acxni̱ aya xtaspitma̱kó̱, xta̱ctati̱lhako̱y ka̱stí̱n, Jesús huaniko̱lh xkalhatutucán pi̱ ni̱tí̱ cali̱ta̱chihui̱nanko̱lh hua̱ntu̱ xucxilhko̱ni̱t hasta acxni̱ xlá̱ Xatalacsacni Chixcú̱ nalakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Puschí̱ caj acstuli̱catzi̱ko̱lh, ni̱tú̱ li̱chihui̱nanko̱lh hua̱ntu̱ xucxilhko̱ni̱t, huata caj tzucuko̱lh la̱kalhasquinko̱y xatú̱ cahuá̱ tama̱ talakastakuán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hua̱mpi̱ huata chuná̱ kalhasquinko̱lh Jesús: —¿Tú̱huan xma̱kalhtahuaka̱nacan judíos huanko̱y pi̱ mat hua̱ Elías xlacasquinca̱ pu̱lana̱ huá̱ namín ca̱tuxá̱huat, chu̱ a̱li̱sta̱lh namín Cristo? ");
INSERT INTO tosNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Cha̱nchu̱ xlá̱ chuná̱ kalhtí̱nalh: —Xli̱ca̱na̱ tu̱ huanko̱y, ni̱ caj li̱huanko̱y, sa̱mpi̱ profeta Elías pu̱lana̱ xli̱mínat xuani̱t, hua̱ xlá̱ ti̱ nama̱aksti̱tumi̱ko̱y tachixcuhuí̱tat laqui̱mpi̱ tla̱n nali̱pa̱huanko̱y acxni̱ namín mima̱akapu̱taxti̱nacán. Hua̱mpi̱ huata quit lacatancs cca̱huaniyá̱n pi̱ profeta Elías aya qui̱lani̱tanchi, hua̱mpi̱ lhu̱hua tachixcuhuí̱tat ni̱ tzinú̱ lakapasko̱lh pala huá̱, huata catu̱hua̱ tu̱ xlacán puhuaniko̱lh, chuná̱ chú̱ tlahuaniko̱lh, luhua xta̱chuná̱ la̱ntla̱ tatzokni̱t c-xtachihui̱n Dios pi̱ chuná̱ naakspulay. Hua̱mpi̱ chú̱ quit na̱ cca̱kalhasquiná̱n: ¿Tú̱ hua̱ yumá̱ la̱ntla̱ tatzokni̱t c-Li̱kalhtahuaka̱ xla quimpa̱lacata̱ Xatalacsacni Chixcú? Mili̱catzi̱tcán pi̱ luhua chuná̱ nalay xta̱chuná̱ la̱ntla̱ antá̱ huan pi̱ nacpa̱ti̱nán, chu̱ lhu̱hua̱ ti̱ naquilakmakanko̱y, chu̱ ni̱tú̱ naquili̱ucxilhko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Acxni̱ taspitko̱lh anta̱ni̱ xuilakó̱ a̱makapitzi̱n xli̱ma̱kalhtahuáka̱t, ucxilhko̱lh pi̱ lhu̱hua chixcuhuí̱n xtamakstokko̱ni̱t, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos, xlacán xli̱tamakspitma̱kó̱, chu̱ xta̱la̱ma̱aklhuhui̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Hua̱mpi̱ makapitzí̱n acxni̱ ucxilhko̱lh Jesús, luhua pa̱xuhuako̱lh, takosú̱n anko̱lh pa̱xtokko̱y laqui̱mpi̱ nata̱chihui̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús acxni̱ lakcha̱nko̱lh xli̱ma̱kalhtahuáka̱t, kalhasquinko̱lh: —¿Tú̱ li̱aklhu̱hua̱tnampá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cha̱tum hua̱nti̱ antá̱ lacatzú̱ xlaya̱, chuná̱ kálhti̱lh: —Ma̱kalhtahuaka̱ná, u̱cli̱mini̱t quinkahuasa ti̱ kalhi̱y cspiritu akskahuiní, chu̱ hasta nia̱lh lay chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pus caxani̱cahuá̱ anta̱ni̱ acxni̱ chipay, ma̱lakahuitiy, chu̱ ma̱lacuacami̱y, ma̱kalhpupi̱y, chu̱ na̱ la̱lacxcay xtatzán; caj huá̱ xpa̱lacata aya li̱sca̱ctamakama̱. Aya cuaniko̱lh mili̱ma̱kalhtahuáka̱t pi̱ catamacaxtuniko̱lh, hua̱mpi̱ ni̱ lay ma̱tla̱ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús chuná̱ huaniko̱lh: —Koxutaní̱n huixín hua̱nti̱ ni̱ ca̱najlaputuná̱tit quintachihuí̱n. ¿Hasta niajcu li̱huaya̱ nactica̱ta̱pa̱ti̱yá̱n? Chu̱ chuná̱ huampá̱: —Cali̱tántit tama̱ kahuasa. ");
INSERT INTO tosNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Puschí̱ li̱minica̱ anta̱ni̱ xyá̱ Jesús. Chu̱ yama̱ cspiritu akskahuiní, acxni̱ úcxilhli̱ Jesús, tuncán ma̱lactlahuáni̱lh u̱n yama̱ kahuasa, tama̱chá̱ ca̱tiyatna, tzúculh tapiliy, chu̱ kalhpupuy. ");
INSERT INTO tosNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kalhásquilh xtla̱t: —¿Pi̱ maka̱sá̱ chuná̱ na̱má̱ lay? Xatla̱t kalhtí̱nalh: —Hasta acxni̱ actzu̱cú̱ xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Luhua maklhu̱huatá̱ tama̱ cspiritu akskahuiní̱ makni̱putún acxni̱ tlakapu̱y c-lhcúya̱t, usu c-chúchut. Huá̱ xpa̱lacata̱ cli̱huaniyá̱n, lapi̱ tla̱n tu̱ xtlahua̱ xpa̱lacata, pus kayaj caquinca̱catzani, chu̱ caquinca̱makta̱ya. ");
INSERT INTO tosNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús chuná̱ kálhti̱lh: —Quit tla̱n cma̱pacsay, hua̱mpi̱ xma̱n tzanka̱niyá̱n pi̱ huix naca̱najlaya, sa̱mpi̱ cati̱huá̱ ti̱ ca̱najlay, chuná̱ lay pacs hua̱ntu̱ puhuán. ");
INSERT INTO tosNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tica̱tásalh tuncán xtla̱t kahuasa, tihua̱: —Cca̱najlaputún; caquimakta̱ya̱ laqui̱mpi̱ tla̱n xacca̱nájlalh. ");
INSERT INTO tosNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Acxni̱ úcxilhli̱ Jesús pi̱ luhua lhu̱hua̱ tzucuko̱lh tamakstokko̱y hasta xla̱lacxquitima̱kó̱, huánilh tuncán yama̱ akskahuiní: —Quit cli̱ma̱paksi̱yá̱n, camakáxtakti̱ tama̱ kahuasa, chu̱ nia̱lh ucxni̱ cama̱sipa̱ni, sa̱mpi̱ huix hua̱nti̱ ma̱ko̱ko̱ni̱ta, chu̱ ma̱akata̱pani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yama̱ cspiritu akskahuiní̱ ca̱tásalh, chu̱ li̱pe̱cua̱ li̱ca̱tálalh yama̱ kahuasa, hua̱mpi̱ makáxtakli. Hua̱mpi̱ yama̱ kahuasa ná̱ xaní̱n xmá̱; huachá̱ lhu̱hua̱ hua̱nti̱ antá̱ xlaya̱kó̱ tzucuko̱lh huanko̱y pi̱ xni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Hua̱mpi̱ Jesús pakchípalh, chu̱ lacatzucu̱ má̱qui̱lh. Puschí̱ yama̱ kahuasa acstutá̱yalh. ");
INSERT INTO tosNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A̱li̱sta̱lh Jesús alh c-chiqui̱ anta̱ni̱ xtamakaxtakko̱y, chu̱ antá̱ xli̱ma̱kalhtahuáka̱t kalhasquinko̱lh: —¿Tú̱ xpa̱lacata̱ quin ni̱ lalh ctamacaxtuhu yama̱ cspiritu akskahuiní? ");
INSERT INTO tosNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús kalhti̱ko̱lh: —Sa̱mpi̱ hua̱ yuma̱ ti̱pa̱tu cspiritu akskahuiní, xma̱n huá̱ li̱tlakaxtucán lapi̱ huixín nakalhxtaknaná̱tit, natlahuayá̱tit oración, chu̱ nasquiniyá̱tit Dios pi̱ huá̱ natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̱li̱sta̱lh Jesús ta̱anko̱lh xli̱ma̱kalhtahuáka̱t a̱lacatanu̱, tipunataxtuko̱lh anta̱ni̱ xma̱paksi̱y Galilea, hua̱mpi̱ ni̱ní̱ tachokoko̱lh sa̱mpi̱ ni̱ xlacasquín tí̱ nacatzi̱y pala antá̱ xlá̱ xti̱taxtuma̱. ");
INSERT INTO tosNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sa̱mpi̱ lhu̱hua̱ tu̱ xli̱ta̱chihui̱namputunko̱y xli̱ma̱kalhtahuáka̱t c-tiji. Pus huá̱ xli̱ta̱kalhchihui̱nanti̱lhako̱y la̱ntla̱ xlá, Xatalacsacni Chixcú, namacama̱sta̱cán c-xmacancan chixcuhuí̱n hua̱nti̱ ni̱ xucxilhputunko̱y; xlacán namakni̱ko̱y, hua̱mpi̱ caj xli̱aktutu quilhtamacú̱ xlá̱ nalakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Hua̱mpi̱ yama̱ xli̱ma̱kalhtahuáka̱t ni̱ xakata̱ksko̱y xlacán la̱ntla̱ luhua naqui̱taxtuy, hua̱mpi̱ na̱ xmacpuhuanko̱y tlak nakalhasquinko̱y xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Acxni̱ xlacán cha̱mpalako̱lh c-Capernaum, chu̱ acxni̱ tanu̱ko̱lh c-chiqui Jesús kalhasquinko̱lh xli̱ma̱kalhtahuáka̱t: —¿Tú̱ xla̱li̱ma̱klu̱hui̱pá̱tit c-tiji? ");
INSERT INTO tosNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Xlacán ni̱ kalhti̱nanko̱lh sa̱mpi̱ c-tiji̱ xli̱chihui̱nanti̱lhako̱y xatí̱ cahuá̱ xli̱ma̱kalhtahuaka̱t Jesús, xapuxcu nahuán, usu tali̱pa̱hu xli̱taxtuma̱. ");
INSERT INTO tosNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Hua̱mpi̱ cumu Jesús pacs xcatzi̱y xatú̱ xlacán xli̱chihui̱nanko̱ni̱t c-tiji, a̱li̱sta̱lh culucs tahui̱, chu̱ huaniko̱lh pi̱ calaktalacatzuhui̱ko̱lh xkalhacu̱tuycán, chuná̱ huaniko̱lh: —Lapi̱ huí̱ ti̱ huixín tlak kalhi̱y xlakasi, usu tali̱pa̱hu li̱taxtuni̱t, pus hua̱ yumá̱ ti̱ ni̱tú̱ putzani̱t la̱ntla̱ nakalhi̱y xlakasi, usu xapuxcu nahuán, huata xlá̱ tlak a̱huatiyá̱ namacasta̱lay laqui̱mpi̱ chuná̱ nali̱taxtuy la̱ milacscujnicán hua̱nti̱ xta̱chuná̱ catu̱cahuá̱ tascújut nama̱tlahui̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A̱li̱sta̱lh tasánilh cha̱tum actzu̱ kahuasa hua̱nti̱ c-xíta̱t ya̱huaniko̱lh, chaxli, chu̱ chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Hua̱nti̱ ni̱ nalakmakán cha̱tum actzu̱ kahuasa la̱ntla̱ u̱má̱, chu̱ napa̱xqui̱y caj xpa̱lacata catzi̱y pi̱ quit cpa̱xqui̱y, pus qui̱li̱taxtuy xta̱chuna̱ pala quittá̱ quimpa̱xqui̱ma̱, na̱ chuná̱ hua̱nti̱ quit quimpa̱xqui̱y, na̱ qui̱taxtuy pi̱ huatiya Dios pa̱xqui̱ma̱ hua̱nti̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Caj li̱tlanca̱liya̱ Juan chuná̱ huánilh Jesús: —Ma̱kalhtahuaka̱ná, cucxilhui̱ cha̱tum chixcú̱ hua̱nti̱ caj mintucuhuiní̱ xli̱quilhán, chu̱ xma̱pacsako̱y hua̱nti̱ xkalhi̱ko̱y cspiritu akskahuiní, hua̱mpi̱ cumu ni̱ acxtum quinca̱ta̱lapu̱layá̱n, pus cli̱huanihu pi̱ nia̱lh tí̱ chuná̱ cama̱pácsalh. ");
INSERT INTO tosNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús huánilh: —Ni̱ xtili̱huanítit, sa̱mpi̱ ti̱ni̱ cha̱tum tla̱n catitláhualh lactlanca li̱ca̱cni tatlahu c-quintucuhuiní̱ pala a̱li̱sta̱lh tuncán cala̱huá̱ naquili̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sa̱mpi̱ ma̱squi caxati̱cahua̱ chixcú, lapi̱ ni̱ quinca̱ta̱la̱tlahuayá̱n acxni̱ tla̱n tascújut tu̱ tlahuama̱, qui̱taxtuy pi̱ quinca̱ta̱ta̱yayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Na̱ caxati̱cahuá̱ ti̱ naca̱ta̱huayá̱n ca̱na̱ caj paktum vaso chúchut, caj xpa̱lacata catzi̱y pi̱ quit quilacscujnipá̱tit, mima̱ quilhtamacú̱ acxni̱ xlá̱ namaklhti̱nán xtaskahu. ");
INSERT INTO tosNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Caxati̱cahuá̱ ti̱ nama̱tlahui̱yá̱n tu̱ ni̱ tla̱n laqui̱mpi̱ naaktzanka̱ta̱yako̱y ná̱ yuma̱ cha̱tum ti̱ lactzu̱cú, ti̱ aya tzucuko̱ni̱t quili̱pa̱huanko̱y, tlak xatlá̱n xuá̱, xli̱makua̱ ni̱ a̱tlahuay, pi̱ pu̱lana̱ xpixchi̱huacaca̱ aktum tlanca chíhuix, chu̱ antá̱ xmaca̱nca̱ c-ta̱kaya̱huaná̱ laqui̱mpi̱ antá̱ xjícsualh. ");
INSERT INTO tosNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Usu lapi̱ catzi̱ya̱ pi̱ huá̱ mimacán ma̱lacatiji̱ni̱yá̱n pi̱ naaktzanka̱ta̱yaya, xatlá̱n cachucu̱cti, chu̱ camákanti; sa̱mpi̱ xali̱huaca̱ tla̱n pakastulu̱ nachipina̱ c-akapú̱n anta̱ni̱ nalakcha̱ná̱n latáma̱t hua̱ntu̱ xa̱li̱ankalhí̱n, ni̱ xahua̱ nakalhi̱ya̱ kantuy mimacán, napina̱ c-pu̱pa̱tí̱n, ");
INSERT INTO tosNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","c-lhcúya̱t, anta̱ni̱ niucxni̱ laksputa̱ tapa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Usu lapi̱ catzi̱ya̱ pi̱ huá̱ mintuhuán nama̱akchakxayá̱n pi̱ naaktzanka̱ta̱yaya, xatlá̱n cachucu̱cti, xali̱huaca̱ tla̱n tantu̱stulu̱ nachipina̱ c-akapú̱n anta̱ni̱ nalakcha̱ná̱n latáma̱t hua̱ntu̱ xa̱li̱ankalhí̱n, ni̱ xahua̱ nakalhi̱ya̱ kantuy mintuhuán, namacapincana̱ c-pu̱pa̱tí̱n, ");
INSERT INTO tosNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","c-lhcúya̱t anta̱ni̱ niucxni̱ laksputa̱ tapa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Usu lapi̱ catzi̱ya̱ pi̱ huá̱ milakastapu̱ nama̱lacatiji̱ni̱yá̱n laqui̱mpi̱ naaktzanka̱ta̱yaya, xali̱huacá̱ xatla̱n calacpi̱ma̱xtuca̱ sa̱mpi̱ tlak xatlá̱n lakatzí̱n nachipina̱ c-akapú̱n, ni̱ xahua̱ nakalhi̱ya̱ aktuy milakastapu, chu̱ namacapincana̱ c-pu̱pa̱tí̱n; ");
INSERT INTO tosNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","c-lhcúya̱t anta̱ni̱ niucxni̱ laksputa̱ tapa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sa̱mpi̱ namín quilhtamacú̱ acxni̱ xli̱pacs tachixcuhuí̱tat nali̱ucxlhko̱cán lhcúya̱t lapi̱ xli̱ca̱na̱ kalhi̱ko̱y mátzat (usu xatlá̱n tahuán: lapi̱ li̱pa̱huanko̱y Dios). ");
INSERT INTO tosNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pus xli̱ca̱na̱, mátzat luhua xlacasquinca, hua̱mpi̱ lapi̱ huá̱ mátzat cspútnilh xli̱skoko, ¿tú̱ nali̱ma̱skoka̱nampalaya? Ankalhí̱n huixín, c-milatama̱tcán, cakalhí̱tit mátzat, ni̱tí̱ cata̱la̱si̱tzi̱nítit, chu̱ cala̱pa̱xquí̱tit li̱macxtum cha̱tunu, chu̱ a̱makapitzí̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ni̱ li̱maka̱s Jesús taca̱xpá̱ c-Capernaum, cha̱lh c-Judea, chu̱ tímilh anta̱ni̱ xma̱paksi̱y xatiyat Judea, antachá̱ xli̱quilhtu̱án c-xakalhtu̱choko̱ Jordán. Lhu̱hua tachixcuhuí̱tat laktastokpalako̱lh anta̱ni̱ xuí̱ Jesús, chu̱ xlá̱ tzúculh li̱xakatli̱ko̱y xtachihui̱n Dios la̱ntla̱ta xli̱smani̱ni̱t xtlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Caj xamaktum lakchinko̱lh makapitzi̱n fariseos laqui̱mpi̱ nakalhputzako̱y pala tú̱ xlá̱ ni̱ tancs nahuán; chu̱ kalhasquinko̱lh palapi̱ kalhi̱y li̱ma̱paksí̱n cha̱tum pu̱chuhua̱ chixcú̱ namakaxtaka̱ xpusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús chuná̱ kálhti̱lh: —¿Tú̱ ca̱li̱ma̱paksí̱n xamaka̱n Moisés? ");
INSERT INTO tosNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xlacán kalhti̱nanko̱lh: —Hua̱ Moisés má̱sta̱lh talacasquín pi̱ cha̱tum chixcú̱ tla̱n namakaxtaka̱ xpusca̱t, hua̱mpi̱ nata̱lacca̱xlay c-pu̱ma̱paksí̱n, chu̱ nama̱xqui̱y xatalacca̱xlan cápsnat anta̱ni̱ nahuán xatú̱ xpa̱lacata̱ nali̱ta̱taxapaxtuy xpusca̱t, pus tla̱n chú̱ namakaxtaka. ");
INSERT INTO tosNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Cha̱nchu̱ kalhtí̱nalh Jesús, huaniko̱lh: —Moisés má̱sta̱lh tama̱ li̱ma̱paksí̱n, sa̱mpi̱ huixín xaktzanká̱n kalhi̱yá̱tit minacu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Hua̱mpi̱ hua̱ c-xquilhtzúcut acxni̱ tima̱lacatzucunanca̱, pus Dios tláhualh yama̱ xapu̱lh chixcú, xa̱hua̱ xapu̱lh pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Hua̱ yumá̱ xpa̱lacata̱ cha̱tum kahuasa, acxni̱ natapu̱chuhuay, tla̱n nali̱makaxtaka̱ xtla̱t, chu̱ xtzi, laqui̱mpi̱ xlá̱ nata̱talakxtumi̱y xpusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Cha̱nchu̱ yama̱ kahuasa, chu̱ tzuma̱t hua̱nti̱ xcha̱tuycán xuanko̱ni̱t, cha̱tumá̱ nali̱taxtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pus huá̱ xpa̱lacata̱ cca̱li̱huaniyá̱n pi̱ hua̱ntu̱ Dios ma̱lacxtumi̱ni̱t ni̱ lay catima̱pa̱pítzilh chixcú. ");
INSERT INTO tosNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A̱li̱sta̱lh acxni̱ cha̱nko̱lh c-chiqui̱ anta̱ni̱ xtamakaxtakko̱y, xli̱ma̱kalhtahuáka̱t kalhasquinko̱lh xatú̱ luhua xuaniputún yama̱ takalhchihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús huaniko̱lh: —Caxati̱cahuá̱ ti̱ namakaxtaka̱ xpusca̱t, na̱ nata̱tahuilay tanuj pusca̱t, lhu̱hua tala̱kalhí̱n kalhi̱y c-xlacati̱n Dios, xa̱hua̱ c-xlacati̱n xapu̱lh xma̱hui̱ná. ");
INSERT INTO tosNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na̱ chuna li̱tum, hua̱nti̱ makaxtaka̱ xchixcú̱ laqui̱mpi̱ nata̱án a̱tanuj chixcú, yama̱ pusca̱t kalhi̱y lhu̱hua tala̱kalhí̱n c-xlacati̱n Dios, xa̱hua̱ c-xlacati̱n xapu̱lh xchixcú. ");
INSERT INTO tosNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Maktum li̱minica̱ Jesús makapitzi̱n lactzu̱ camán laqui̱mpi̱ nasiculana̱tlahuako̱y, hua̱mpi̱ xli̱ma̱kalhtahuáka̱t tzucuko̱lh lacaquilhni̱ko̱y hua̱nti̱ xli̱minima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","15","Hua̱mpi̱ acxni̱ úcxilhli̱ Jesús hua̱ntu̱ xtlahuama̱kó̱, si̱tzi̱niko̱lh tzinú̱, chu̱ chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ catlahuátit li̱tlá̱n, ni̱ cali̱huanikó̱tit tama̱ lactzu̱ camán pi̱ naquilakminko̱y anta̱ni̱ cuí̱, sa̱mpi̱ caj xma̱n huá̱ hua̱nti̱ kalhi̱y xtalacapa̱stacni̱ xta̱chuná̱ la̱ntla̱ tu̱ kalhi̱y actzu̱ kahuasa, xlá̱ luhua mini̱niy pi̱ namakamaklhti̱nán hua̱ntu̱ Dios ma̱xqui̱putún, c-xasa̱sti xtapáksi̱t tu̱ ma̱quilhtzuqui̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Chu̱ a̱li̱sta̱lh tichaxko̱lh, tiakspu̱huili̱ko̱lh xmacán, chu̱ siculana̱tlahuako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Acxni̱ Jesús xtaca̱xma̱ naquilhta̱yapalay tiji, xkosnani̱t lákmilh cha̱tum kahuasa, lakatatzokóstalh c-xlacatí̱n, chu̱ chuná̱ kalhásquilh: —Ma̱kalhtahuaka̱ná, huix luhua tla̱n catzi̱ya, ¿xatú̱ luhua tla̱n tascújut quili̱tláhuat pi̱ tla̱n nackalhi̱y yama̱ li̱pa̱xuhu latáma̱t c-akapú̱n hua̱ntu̱ niucxni̱ nalaksputa? ");
INSERT INTO tosNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kálhti̱lh: —¿Tú̱ xpa̱lacata̱ quili̱huaniya̱ pi̱ quit luhua tla̱n ccatzi̱y? ¿Tú̱ catzi̱ya̱ pi̱ yunú̱ ni̱tí̱ anán hua̱nti̱ xli̱ca̱na̱ tla̱n, hua̱mpi̱ caj xma̱n cha̱tum, huachá̱ Dios? ");
INSERT INTO tosNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Huix catzi̱ya̱ la̱ntla̱ huí̱ kampa̱ca̱hu xli̱ma̱paksi̱n Dios hua̱ntu̱ ma̱xqui̱ni̱t Moisés: ‘Niucxni̱ tixakatli̱ya̱ tanuj pusca̱t lapi̱ huí̱ mimpusca̱t; niucxni̱ tí̱ timakni̱ya̱; niucxni̱ tí̱ tima̱xtuniya̱ ta̱ksaní̱n, niucxni̱ tí̱ timakkalha̱nana; niucxni̱ tí̱ tiakskahuipi̱ya; na̱ cama̱xqui̱ ca̱cni̱ mintzí, xa̱hua̱ mintla̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yama̱ kahuasa chuná̱ kálhti̱lh: —Quimpu̱chiná, hasta la̱ntla̱ tlak actzu̱cú̱ xacuani̱t ctzucuni̱t ma̱kantaxti̱y hua̱ntu̱ chú̱ huanípa̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Cha̱nchu̱ Jesús, la̱ntla̱ xucxilhma̱, lakcátzalh, huánilh: —Hua̱mpi̱ huí̱ a̱kampa̱tum hua̱ntu̱ tzanka̱niyá̱n mili̱tláhuat: capit, pacs casta̱t tu̱ kalhi̱ya, chu̱ cama̱akpitzinikó̱ lakli̱ma̱xkaní̱n mintumi̱n, a̱li̱sta̱lh caquilakta, chu̱ caquista̱lani; chuná xli̱ca̱na̱ luhua lhu̱hua̱ mintapa̱xuhuá̱n nali̱ma̱stoka̱ xta̱chuná̱ la̱ mintamacú̱n c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Acxni̱ káxmatli̱ yama̱ tachihuí̱n hua̱ntu̱ huánilh Jesús, yama̱ kahuasa cha̱li̱puhua̱na̱ alh, sa̱mpi̱ luhua ma̱tamacu̱nú̱ xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús laklaca̱nko̱lh anta̱ni̱ xya̱kó̱ xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: —Quit lacatancs cca̱huaniyá̱n pi̱ luhua tuhua̱ xpa̱lacata̱ ma̱tamacu̱naní̱n natanu̱ko̱y c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xli̱ma̱kalhtahuaka̱t Jesús ni̱ xakata̱ksko̱ni̱t hua̱ntu̱ xuaniko̱ni̱t, chu̱ cacs xli̱lacahuanko̱y, hua̱mpi̱ Jesús huanipalako̱lh: —Huixín quincamán, quit cca̱huaniyá̱n pi̱ ca̱na̱ tuhua̱ naqui̱taxtuniko̱y yamá̱ hua̱nti̱ li̱pa̱huanko̱y xtumi̱ncán, chu̱ catu̱cahuá̱ li̱lactlahuaya̱huako̱y xtalacapa̱stacnicán pi̱ tla̱n namakamaklhti̱nanko̱y xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Chu̱ huata ni̱ xatuhua̱ natanu̱y tantum camello c-xtzan kantum li̱tzapan, ni̱ xahua̱ cha̱tum ma̱tamacu̱nú̱ ti̱ lakcatzán xtumi̱n natanu̱y c-xtapaksi̱t Dios tu̱ huí̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Acxni̱ xli̱ma̱kalhtahuáka̱t kaxmatko̱lh yuma̱ takalhchihuí̱n, xaa̱i̱huacá̱ lanaj li̱lacahuanko̱lh, xacstula̱huaniko̱y: —Pus lapi̱ chuná, ¿tí̱ chú̱ luhua nalakma̱xtuy xli̱stacna̱ laqui̱mpi̱ natanu̱y c-akapú̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús kalhakaxmatko̱lh, chu̱ huaniko̱lh: —Lapi̱ caj xacstu cha̱tum luhua puhuán pi̱ tla̱n nalakma̱xtuy xli̱stacna, xlá̱ ni̱ lay tú̱ ma̱tla̱ni̱y; hua̱mpi̱ Dios pacs tla̱n ma̱tla̱ni̱y xli̱pacs tu̱ puhuán natlahuay, ni̱tú̱ tuhua̱ xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Cha̱nchu̱ Pedro, tzúculh huaniy: —Quimpu̱chinacán, quin cakxtakmakani̱tahu pacs tu̱ xackalhi̱ya̱hu laqui̱mpi̱ cca̱sta̱lanini̱tán, ¿tú̱ chi̱nchu̱ naquinca̱lakcha̱ná̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús kalhti̱ko̱lh: —Lacatancs cca̱huaniyá̱n, pi̱ ti̱ni̱ cha̱tum anán pala tí̱ makaxtakni̱t hua̱ntu̱ kalhi̱y, pala xchic, usu xnata̱lán, usu xtla̱t, usu xtzi, usu xpusca̱t, usuchí̱ xa̱hua̱ xcamán, usu xpú̱cuxtu, caj xpa̱lacata naquista̱laniy, usuchí̱ caj xpa̱lacata naán ma̱catzi̱ni̱ko̱y tachixcuhuí̱tat la̱ntla̱ Dios ma̱tzanka̱naniputunko̱y, chu̱ ma̱akapu̱taxti̱putunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Quit cca̱huaniyá̱n pi̱ yama̱ cha̱tum, luhua lhu̱hua chiqui̱ nakalhi̱y anta̱ni̱ nachá̱n, xta̱chuná̱ la̱ xnata̱lán, la̱ xnatla̱tna, usuchí̱ la̱ xcamán, la̱ xmakaaná̱nat. Luhua xli̱ca̱na̱ lhu̱hua̱ nata̱ksa, chu̱ ma̱squi luhua lhu̱hua̱ nasi̱tzi̱niko̱y yunú̱ ca̱tuxá̱huat, hua̱mpi̱ huá̱ chú̱ namín quilhtamacú̱ namaklhti̱nán xataluloktat latáma̱t hua̱ntu̱ niucxni̱ laksputa̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Hua̱mpi̱ lhu̱hua̱ hua̱nti̱ la̱nchú̱ lactali̱pa̱hu, chu̱ macapu̱lama̱kó̱, a̱li̱sta̱lh huata xlacán a̱huatá̱ huilakoj nahuán; chu̱ lhu̱hua̱ hua̱nti̱ la̱nchú̱ ni̱tú̱ xlakasicán li̱taxtuko̱y, luhua a̱huatá̱ qui̱taxtuma̱kó̱; hua̱mpi̱ acxni̱ chú̱ yama̱ quilhtamacú̱ huata pu̱lh huá̱ nama̱xqui̱ko̱cán xpu̱tahui̱lhcán c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Maktum la̱ntla̱ xtiji̱nama̱kó̱, xama̱kó̱ c-Jerusalén; Jesús xpu̱laniti̱lhako̱y xli̱ma̱kalhtahuáka̱t. Puschí̱ xaklituananko̱ni̱t, chu̱ a̱makapitzi̱n tachixcuhuí̱tat ti̱ na̱ a̱huatiyá̱ c-xcha̱ká̱n caj cha̱pe̱cua̱ csta̱lama̱kó̱, sa̱mpi̱ xpe̱cuanko̱y xatú̱ cahuá̱ naakspulay Jesús. Xamaktum Jesús caj tánuj ma̱macxtumi̱palako̱lh xkalhacu̱tuycán, chu̱ tzúculh a̱li̱huaniko̱y hua̱ntu̱ luhua naakspulay. ");
INSERT INTO tosNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na̱má̱ huaniko̱lh: “La̱ntla̱ ucxilhpá̱tit, ama̱hu c-Jerusalén anta̱ni̱ naquimacama̱sta̱cán, quit Xatalacsacni Chixcú, c-xmacancan xanapuxcun pa̱lijni, chu̱ xma̱kalhtahuaka̱nacan Judíos; xlacán naquili̱lhca̱ko̱y pi̱ naquimakni̱cán, chu̱ naquima̱lacapu̱ko̱y c-xlacati̱ncan ma̱paksi̱nani̱n romanos. ");
INSERT INTO tosNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xlacán tla̱n naquili̱kalhakama̱nanko̱y, naquisnokko̱y, naquinchujmani̱ko̱y, naquimakni̱ko̱y. Hua̱mpi̱ quit xli̱aktutu quilhtamacú̱ naclakastakuanán ca̱li̱ní̱n.” ");
INSERT INTO tosNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","A̱li̱sta̱lh Jacobo, chu̱ Juan, xcamán Zebedeo, laktalacatzuhui̱ko̱lh Jesús, chu̱ huaniko̱lh: —Ma̱kalhtahuaka̱ná, clacasquina̱hu xquinca̱tlahuani̱ aktum li̱tlá̱n hua̱ntu̱ cca̱squimputuná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús huaniko̱lh: —¿Tú̱ lacasquiná̱tit nactlahuay caj mimpa̱lacatacán? ");
INSERT INTO tosNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Xlacán huaniko̱lh: —Acxni̱ huix namakatlajako̱ya̱ xli̱pacs hua̱nti̱ si̱tzi̱nikoyá̱n, chu̱ natzucuya ma̱paksi̱nana̱ cumu tlanca Rey antá̱ c-li̱pa̱xuhu mimpu̱ma̱paksí̱n, xquinca̱ma̱xqui̱ talacasquín xactahuilacha̱hu c-mimpa̱xtú̱n laqui̱mpi̱ nacca̱ta̱ma̱paksi̱naná̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús kalhti̱ko̱lh: —Huixín ni̱ pala tzinú̱ catzi̱yá̱tit hua̱ntu̱ squimpá̱tit. ¿Pi̱ xli̱ca̱na̱ puhuaná̱tit pi̱ tla̱n nata̱yaniyá̱tit c-aktum tlanca tapa̱tí̱n xta̱chuná̱ la̱ntla̱ yama̱ tapa̱tí̱n tu̱ quit nacpa̱ti̱y? Usu ¿pi̱ nama̱tla̱ni̱yá̱tit pi̱ naca̱makni̱caná̱tit la̱ntla̱ naquimakni̱cán? ");
INSERT INTO tosNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Xlacán kalhti̱nanko̱lh: —Cpuhuana̱hu pi̱ ma̱x tla̱n nacta̱yaniya̱hu. Jesús huanipalako̱lh: —Xli̱ca̱na̱ xlá̱ pi̱ tla̱n nata̱yaniyá̱tit huixín, sa̱mpi̱ huixín fuerza̱ antá̱ nali̱taxtuya̱pítit lhu̱hua tapa̱tí̱n chuná̱ la̱ntla̱ hua̱ntu̱ quit naquiakspulay, chu̱ fuerza̱ nata̱yaniyá̱tit; na̱ chuna li̱tum naca̱makni̱caná̱tit makapitzi̱n huixín xta̱chuná̱ la̱ntla̱ naquimakni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Hua̱mpi̱ hua̱ chú̱ la̱ntla̱ huixín lacasquiná̱tit pi̱ nacca̱huili̱yá̱n c-quimpa̱xtú̱n acxni̱ nactzucuy ma̱paksi̱nán c-quimpu̱ma̱paksí̱n, pus quit lacatancs cca̱huaniyá̱n pi̱ ni̱ quilá̱ pala nacma̱sta̱y, huata xma̱n huá̱ lakchá̱n hua̱nti̱ lacsacko̱ni̱t Quintla̱t nama̱xqui̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Acxni̱ catzi̱ko̱lh a̱makapitzi̱n xli̱ma̱kalhtahuáka̱t hua̱ntu̱ xlacasquinko̱y Juan, chu̱ Santiago, li̱si̱tzi̱niko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pus Jesús pacs tasaniko̱lh natalacatzuhui̱ko̱y, chu̱ chuná̱ huaniko̱lh: —Huixín catzi̱yá̱tit pi̱ hua̱nti̱ xanapuxcun ma̱paksi̱naní̱n xala c-aktum ca̱chiquí̱n, xlacán pacs akchipako̱y la̱ntla̱ tu̱ huí̱ ca̱chiquí̱n, chu̱ luhua tlihuaka̱ huili̱ko̱y xli̱ma̱paksí̱n, na̱ chuná̱ hua̱nti̱ xalactali̱pa̱hu ma̱la̱naní̱n akskahuimaklhti̱ko̱y hua̱ntu̱ kalhi̱ko̱y ti̱ ni̱ lactali̱pa̱hu xnata̱chiqui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Hua̱mpi̱ hua̱ntu̱ mimpa̱lacatacán ni̱ chuná̱ catica̱qui̱taxtunín, sa̱mpi̱ hua̱nti̱ luhua tali̱pa̱hu xapuxcu li̱taxtuputún c-milaksti̱pa̱ncán, xlacasquinca̱ pi̱ cama̱tlá̱ni̱lh nali̱taxtuy xta̱chuná̱ la̱ntla̱ ti̱ caj milacscujnicán. ");
INSERT INTO tosNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chu̱ na̱ chuná̱ lapi̱ taxtuya̱chá̱ cha̱tum la̱ntla̱ huixín hua̱nti̱ xacalacán xuampútulh, chu̱ ma̱paksi̱putunko̱y a̱makapitzi̱n xta̱chixcuhuí̱n xta̱chuná̱ la̱ntla̱ xapuxcu, huata xlá̱ luhua mini̱niy nali̱taxtuy xta̱chuná̱ la̱ cha̱tum lacscujni̱ hua̱nti̱ na̱ caj nalakachixcuhui̱nán hua̱ntu̱ nali̱ma̱paksi̱ko̱y a̱makapitzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Xta̱chuná̱ la̱ntla̱ quit Xatalacsacni Chixcú̱ ni̱ huá̱ clakmini̱t ca̱tuxá̱huat laqui̱mpi̱ caj la̱ntla̱ cha̱tum tlanca̱ puxcu̱ naquiscujnanicán, huata huá̱ clakmini̱t laqui̱mpi̱ caj la̱ntla̱ xlacscujnicán nacli̱taxtuy nacmakta̱yako̱y a̱makapitzí̱n, chu̱ na̱ chuna li̱tum, laqui̱mpi̱ quit nacmacama̱sta̱y quilatáma̱t laqui̱mpi̱ chuná̱ tla̱n nacli̱ma̱akapu̱taxti̱ko̱y xlatama̱tcan xli̱lhu̱hua tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cha̱nko̱lh chú̱ c-aktum ca̱chiquí̱n huanicán Jericó, caj xti̱yapuntaxtuma̱kó̱, luhua lhu̱hua̱ chixcuhuí̱n csta̱lanima̱kó̱ Jesús. Acxni̱ aya xtaxtuma̱kó̱ ca̱chiquí̱n, cha̱tum lakatzí̱n huanicán Bartimeo, xkahuasa xuani̱t Timeo, antá̱ xuí̱ c-xquilhpa̱n tiji, csquima̱ limosna. ");
INSERT INTO tosNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Acxni̱ káxmatli̱ pi̱ hua̱ Jesús xala c-Nazaret ti̱ xti̱taxtuma̱, tzúculh ca̱tasay, xquilhuama̱: —Jesús, xquilhtzúcut xamaka̱n rey David, catlahua̱ li̱tlá̱n, caquinkalhi̱ni̱ talakalhamá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na̱ luhua cha̱lhu̱hua̱ ti̱ xquilhni̱ko̱y pi̱ nakatxtaka; cha̱nchu̱ xlá, huata ca̱x tzúculh ca̱tasay, huá̱: —Jesús, xquilhtzucut rey David, caquinkalhi̱ni̱ talakalhamá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Puschí̱ tachókolh Jesús, chu̱ huaniko̱lh a̱makapitzí̱n: —Cahuanítit camilh tama̱ lakatzí̱n. Pus cha̱tum alh tasaniy, chu̱ chuná̱ huánilh: —Caakpúhuanti, kahu; cata̱ya, sa̱mpi̱ Jesús tasanimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Xlá̱ lhkan ma̱kósulh xmactahuaca̱ ca̱tiyatna, aya lit tá̱yalh, chu̱ talacatzúhui̱lh anta̱ni̱ xyá̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús kalhásquilh: —¿Tú̱ lacasquina̱ xactláhualh mimpa̱lacata? Yama̱ lakatzí̱n chuná̱ kalhtí̱nalh: —Ma̱kalhtahuaka̱ná, quit clacahua̱namputún. ");
INSERT INTO tosNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús huánilh: —Tla̱ná̱ li̱pa̱xuhu napina̱ c-mínchic. Huix aya nalacahua̱nana sa̱mpi̱ quili̱pa̱huani̱ta. Puschí̱ yama̱ lakatzí̱n acxni tuncán lacahuá̱nalh, chu̱ na̱ sta̱lánilh Jesús anta̱ni̱ xlá̱ xama̱. ");
INSERT INTO tosNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","La̱ntla̱ xtalacatzuhui̱ma̱kó̱ c-Jerusalén, pu̱lana̱ antá̱ cha̱nko̱lh c-aktum ka̱stí̱n, huanicán Monte de los Olivos, c-xlacatí̱n xuilakó̱ aktuy lactzu̱ ca̱chiquí̱n huaniko̱cán Betfagé, chu̱ Betania; yuma̱ ca̱chiquí̱n ta̱pakstokuilakó̱ Jerusalén. Acxni̱ antá̱ xuilakó̱, Jesu̱s ma̱lakacha̱ko̱lh cha̱tuy xli̱ma̱kalhtahuáka̱t, ");
INSERT INTO tosNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","chu̱ huaniko̱lh: —Capimpítit c-lactzu̱ ca̱chiquí̱n tu̱ xapu̱lana̱ huilachi, ma̱n huá̱ natanu̱ya̱pítit, nachipiná̱tit c-aktum chiqui̱ anta̱ni̱ naucxilhá̱tit pi̱ chi̱ya̱huacani̱t tantum a̱xnu̱ hua̱ntu̱ ti̱ni̱ cha̱tum a̱ka̱tahuilay; naxcutá̱tit, chu̱ nali̱taná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Palapi̱ huí̱ ti̱ naca̱huaniyá̱n xatú̱ nali̱layá̱tit, huixín nahuaná̱tit: ‘Hua̱ Quimpu̱chinacán maclacasquimputún, chu̱ tuncán napu̱spitpalay.’ ");
INSERT INTO tosNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xlacán anko̱lh, chu̱ xli̱ca̱na̱ ma̱noklhuko̱lh tantum a̱xnu̱ xchi̱ya̱huacani̱t c-xtanquilhti̱n aktum chiqui̱ lacatzu̱ c-má̱laccha. Xlacán xcutko̱lh, ");
INSERT INTO tosNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","chu̱ hua̱nti̱ antá̱ xyakó̱ lacatzú̱, ucxilhko̱lh hua̱ntu̱ xtlahuama̱kó̱, chuná̱ huaniko̱ca̱: —¿Tú̱ tlahuaputuná̱tit? ¿Tú̱ li̱layá̱tit xcutá̱tit tama̱ a̱xnu̱? ");
INSERT INTO tosNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Cha̱nchu̱ xlacán, chuná̱ kalhti̱nanko̱lh la̱ntla̱ xuaniko̱ni̱t Jesús, chu̱ nia̱lh tú̱ huaniko̱ca̱, ma̱xqui̱ko̱ca̱ talacasquín nale̱nko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tili̱miniko̱lh actzu̱ a̱xnu̱ anta̱ni̱ xuí̱ Jesús, chu̱ li̱ka̱tlapaniko̱lh xlhaka̱tcán. Jesús ka̱tahui̱, chu̱ la̱li̱huán ta̱yako̱lh c-tiji̱ tu̱ an c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Luhua li̱lhu̱hua̱ tachixcuhuí̱tat xminko̱ni̱t pa̱xtokko̱y. Lhu̱hua̱ ti̱ tzucuko̱lh stonkmi̱ko̱y xlhaka̱tcán c-tiji, cha̱nchu̱ makapitzí̱n xtucxko̱y xpakani̱n quihui̱, na̱ antá̱ xma̱mi̱ma̱kó̱ c-tiji. ");
INSERT INTO tosNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hua̱nti̱ xpu̱laniti̱lhako̱y, xa̱hua̱ ti̱ a̱huán csta̱lati̱lhako̱y, tzucuko̱lh ca̱tasako̱y, chuná̱ xquilhuama̱kó̱: —¡Cama̱xqui̱hu ca̱cni̱ Dios! ¡Dios casiculana̱tláhualh yuma̱ chixcú̱ ti̱ xlá̱ macamima̱! ");
INSERT INTO tosNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Dios casiculana̱tláhualh xli̱ma̱paksí̱n hua̱nti̱ xlá̱ ma̱lakacha̱ni̱t laqui̱mpi̱ naquinca̱ma̱paksi̱yá̱n, na̱ chuná̱ la̱ntla̱ ma̱paksí̱nalh xamaka̱n quinquilhtzucutcán rey David! ¡Cama̱xqui̱hu ca̱cni̱ Dios hua̱nti̱ huilachá̱ ta̱lhmá̱n c-akapú̱n! ");
INSERT INTO tosNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pus chuná̱ tanu̱chá̱ Jesús c-Jerusalén, chu̱ a̱li̱sta̱lh alh c-tlanca xtemplo̱ Dios tu̱ xuí̱ c-Jerusalén. Acxni̱ xucxilhko̱ni̱ttá̱ xli̱pacs la̱ntla̱ xui̱ c-xpu̱lacni xapa̱tzaps templo, táxtulh, chu̱ ta̱ampalako̱lh xli̱ma̱kalhtahuáka̱t sa̱mpi̱ ko̱tanu̱yá xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Li̱cha̱li̱ tzi̱sa̱, Jesús taca̱xpá̱ c-Betania, chu̱ la̱ntla̱ xtla̱huama̱ xlá̱ tzúculh tzincsa. ");
INSERT INTO tosNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A̱li̱mákat úcxilhli̱ akatum xaquihui higo, luhua stakninqui xta̱ya̱ xatuhuá̱n; alh ucxilha̱ pala kalhi̱y xatahuácat. Hua̱mpi̱ acxni̱ lákcha̱lh, ni̱tú̱ ta̱ksli, xma̱n hua̱ xatuhuá̱n; sa̱mpi̱ ni̱ naj xquilhtamacú̱ xuani̱t nalay xatahuacat higo. ");
INSERT INTO tosNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús chuná̱ huánilh yama̱ quihui: —Quit clacasquín pi̱ nia̱lh pala cha̱tum nahuapalay mintahuácat. ");
INSERT INTO tosNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Caj li̱tlanca̱liya̱ cha̱nko̱lh c-Jerusalén; Jesús tuncán tánu̱lh c-tlanca templo, chu̱ tzúculh tamacaxtuko̱y hua̱nti̱ antá̱ csta̱nama̱kó̱, xa̱hua̱ ti̱ xtama̱huanama̱kó̱ c-xtanquilhti̱n templo. Ma̱akpu̱spitniko̱lh xmesajcán hua̱nti̱ xlakpali̱ma̱kó̱ tumi̱n, xa̱hua̱ ti̱ csillajcan csta̱lani̱n palomas, chu̱ csta̱ma̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na̱ nia̱lh xlacasquiniko̱y pala ti̱ nata̱tanu̱ya̱chá̱ xlí̱sta̱t c-xtanquilhti̱n templo. ");
INSERT INTO tosNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Cha̱nchu̱ chuná̱ tzucuko̱lh li̱huaniko̱y tachixcuhuí̱tat: —C-xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka, chuná̱ huan: ‘Yuma̱ quínchic, luhua caj xma̱n huá̱ nali̱ma̱xtucán pi̱ antá̱ naquintlahuaniko̱y oración xli̱pacs tachixcuhuí̱tat cani̱cahua̱ xalaní̱n’, hua̱mpi̱ hua̱ huixín aya li̱ma̱xtuni̱tántit xta̱chuná̱ la̱ xpu̱tatze̱knican kalha̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makapitzi̱n xma̱kalhtahuaka̱nacan judíos, xa̱hua̱ xanapuxcun pa̱lijni̱ kaxmatko̱lh hua̱ntu̱ xlá̱ xquilhuama̱, huata a̱li̱sta̱lh tzucuko̱lh lacputzako̱y la̱ntla̱ natlahuako̱y pi̱ tze̱k namakni̱ko̱y, sa̱mpi̱ xpe̱cuaniko̱y la̱ntla̱ xma̱siyuniko̱y tachixcuhuí̱tat huata pacsa tanu̱ xli̱catzi̱niko̱y, xlacán xca̱cni̱naniko̱y caj xpa̱lacata lactlanca talacapa̱stacni̱ tu̱ xma̱siyuniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Hua̱mpi̱ acxni̱ aya tzúculh ko̱tanu̱y, Jesús ca̱ta̱taca̱xpá̱ xli̱ma̱kalhtahuáka̱t, chu̱ ta̱ampalako̱lh c-Betania. ");
INSERT INTO tosNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Li̱cha̱li̱ tzi̱sa̱, lacatzú̱ ti̱taxtuko̱lh anta̱ni̱ xyá̱ yama̱ xaquihui higo hua̱ntu̱ lacaquílhni̱lh Jesús, chu̱ ucxilhko̱lh pi̱ pacs csca̱cko̱ni̱t la̱ntla̱ xakán hasta xtankaxe̱k. ");
INSERT INTO tosNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro lacapa̱stactá̱yalh, chu̱ chuná̱ huánilh Jesús: —Ma̱kalhtahuaka̱ná, caúcxilhti̱ yama̱ xaquihui higo hua̱ntu̱ lacaquilhni̱ kó̱tana, aya sca̱cko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tikalhtí̱nalh Jesús, tihuaniko̱lh: —Huá̱ lí̱lalh laqui̱mpi̱ xali̱ucxílhti̱t nahuán la̱ntla̱ mili̱pa̱huanat Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Pus luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n, pi̱ caxati̱cahuá̱ ti̱ xuánilh yuma̱ ka̱stí̱n: ‘Catapa̱nu̱ anta̱ni̱ huila, chu̱ capit taju̱ya̱ c-ta̱kaya̱huaná’, na̱ lapi̱ ni̱ macpuhuán, huata ca̱najlay, chu̱ catzi̱y pi̱ chuná̱ naqui̱taxtuy, xli̱ca̱na̱ chuná̱ nakantaxtuy. ");
INSERT INTO tosNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Huachá̱ cca̱li̱huaniyá̱n pi̱ xli̱pacs hua̱ntu̱ nasquiniyá̱tit Dios c-mioracioncán naca̱tlahuaniyá̱n, lapi̱ li̱pa̱huaná̱tit, chu̱ catzi̱yá̱tit pi̱ xlá̱ naca̱ma̱xqui̱yá̱n tu̱ squiniyá̱tit, xli̱ca̱na̱ chuná̱ naca̱qui̱kantaxtuniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Na̱ chuna li̱tum acxni̱ natlahuayá̱tit mioracioncán, palapi̱ huí̱ ti̱ tzinú̱ tu̱ ta̱la̱li̱makasi̱tzi̱ni̱tán, pus huata pu̱lana̱ cata̱pa̱ti, chu̱ cama̱tzanka̱nani, laqui̱mpi̱ hua̱ Mintla̱ticán ti̱ huilachá̱ c-akapú̱n, na̱ naca̱ma̱tzanka̱naniyá̱n mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Hua̱ palapi̱ huixín ni̱ nama̱tzanka̱naniyá̱tit hua̱ntu̱ ca̱tlahuaniyá̱n a̱makapitzí̱n, na̱ chuná̱ Mintla̱tican Dios ti̱ huilachá̱ c-akapú̱n, na̱ ni̱ catica̱ma̱tzanka̱nanín mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Titapu̱spitpalako̱lh c-Jerusalén, chu̱ acxni̱ xlatanu̱ma̱ Jesús c-templo, laktalacatzuhui̱ko̱lh xanapuxcun pa̱lijni, chu̱ xma̱kalhtahuaka̱nacan judíos, xa̱hua̱ lakko̱lutzi̱n ma̱paksi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chuná̱ kalhasquinko̱lh: —¿Tú̱huan huix li̱huaniko̱ya̱ hua̱ntu̱ tlahuama̱kó̱ c-templo? ¿Tí̱ ma̱xqui̱ni̱tán li̱ma̱paksí̱n pi̱ chuná̱ natana tlahuaya? ");
INSERT INTO tosNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Hua̱mpi̱ Jesús kalhti̱ko̱lh: —Pus quit na̱ huí̱ hua̱ntu̱ nacca̱kalhputzayá̱n, chu̱ lapi̱ huixín naquinkalhti̱yá̱tit, pus quit na̱ nacca̱huaniyá̱n tí̱ quima̱xqui̱ni̱t li̱ma̱paksí̱n xpa̱lacata hua̱ntu̱ ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","La̱nchuj tuncán caquihuanítit: ¿tí̱ má̱xqui̱lh li̱ma̱paksí̱n Juan Bautista pi̱ naakmunu̱nán, pá̱ huá̱ Dios, usu hua̱ chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xlacán tzucuko̱lh la̱li̱xakatli̱ko̱y, xla̱kalhasquinko̱y, chu̱ xla̱huaniko̱y: “Lapi̱ nahuaniya̱hu pi̱ Dios ma̱lakácha̱lh, xlá̱ naquinca̱huaniyá̱n: ‘¿Lá̱ntla̱ chi̱nchu̱ ni̱ li̱ca̱najlanítit hua̱ntu̱ ca̱li̱ta̱chihui̱nán?’ ");
INSERT INTO tosNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Hua̱mpi̱ na̱ ni̱ lay nahuaniya̱hu pi̱ huá̱ xacstu lacapá̱stacli̱ tu̱ nali̱chihui̱nán.” Pus ni̱ chuná̱ xli̱kalhti̱namputunko̱y sa̱mpi̱ xcatzi̱ko̱y pi̱ luhua lhu̱hua̱ xca̱najlanicani̱t pi̱ Dios xli̱ca̱na̱ xma̱lakacha̱ni̱t Juan Bautista nali̱akchihui̱nán xtalacapa̱stacni, huá̱ xli̱pe̱cuaniko̱y xli̱lhu̱hua̱ tachixcuhuí̱tat, chu̱ xlacán ni̱ catzi̱ko̱lh la̱ntla̱ nakalhti̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xalán chuná̱ kalhti̱nanko̱lh: —Pus ni̱ ccatzi̱ya̱hu tí̱ li̱ma̱páksi̱lh Juan pi̱ naakmunu̱nán. Jesús kalhti̱ko̱lh: —Pus na̱ ni̱ pala quit cactica̱huanín tí̱ quima̱xqui̱ni̱t li̱ma̱paksí̱n caj xpa̱lacata hua̱ntu̱ tla̱n ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Caj li̱tlanca̱liya̱ Jesús tzucupaj xakatli̱ko̱y tachixcuhuí̱tat, caj li̱ta̱chihui̱nanko̱lh aktum takalhchihuí̱n, chuná̱ huaniko̱lh: “Maktum xuí̱ cha̱tum chixcú, chalh c-xpú̱cuxtu̱ lhu̱hua xali̱chanat uva. Xlá̱ li̱huana̱ tipacánu̱lh, a̱li̱sta̱lh tláhualh aktum tlanca torre anta̱ni̱ natahuacay ti̱ namaktakalha̱ xtachaná̱n. Chu̱ na̱ tláhualh xpu̱chitni̱ laqui̱mpi̱ antá̱ nalakchita̱ xuvas acxni̱ nacha̱y. Ni̱ maka̱s quilhtamacú̱ xlá̱ ma̱sa̱cuani̱ko̱lh makapitzi̱n maktakalhnaní̱n laqui̱mpi̱ huá̱ chú̱ nali̱scujko̱y yuma̱ tlanca xca̱tacuxtu, sa̱mpi̱ xlá̱ alh mákat c-a̱lacatanu̱ ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Acxni̱ lákcha̱lh quilhtamacú̱ la̱ntla̱ tzucuy cha̱y, chu̱ lakchitcán uvas, yama̱ xma̱la̱na ca̱tacuxtu̱ ma̱lakácha̱lh cha̱tum xlacscujni̱ pi̱ nasquiniko̱cán hua̱ntu̱ xlakchá̱n xlá̱ nachipay xatachitni uvas. ");
INSERT INTO tosNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Hua̱mpi̱ xlacán chipako̱lh, tla̱n akkaximi̱ko̱lh, caj chunatá̱ maca̱mpalako̱lh, chu̱ ni̱tú̱ ma̱xqui̱ko̱lh tachitni. ");
INSERT INTO tosNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yama̱ xma̱la̱na pú̱cuxtu̱ ma̱lakacha̱pá̱ tanuj li̱tum cscujni, hua̱mpi̱ xlá̱ li̱actalami̱ko̱lh chíhuix, ma̱sipa̱ni̱ko̱lh c-xakxe̱ka, chu̱ cala̱huá̱ huaniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xma̱la̱na ca̱tacuxtu̱ ma̱lakacha̱pá̱ a̱cha̱tum cscujni, hua̱mpi̱ huá̱ yumá̱ makni̱canchá. Na̱ chuná̱ lhu̱hua̱ ma̱lakacha̱palako̱lh cscujní̱n; huí̱ ti̱ makni̱ko̱ca̱, chu̱ makapitzí̱n lakkaximi̱ko̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Yama̱ ko̱lutzí̱n a̱huatiyá̱ xakata̱xtunima̱ cha̱stum xcam ti̱ luhua xpa̱xqui̱y, xpuhuán: ‘Pala nacma̱lakacha̱y quinkahuasa, ma̱x nakaxmatniko̱y hua̱ntu̱ nahuaniko̱y.’ Xli̱ca̱na̱ ma̱lakácha̱lh xkahuasa. ");
INSERT INTO tosNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Cha̱nchu̱ acxni̱ lakcha̱nko̱lh yama̱ kahuasa, yama̱ xmaktakalhnani̱n xca̱uvasna̱ chuná̱ tzúculh la̱huaniko̱y: ‘Luhua catzi̱ya̱hu pi̱ hua̱ yuma̱ kahuasa̱ ti̱ nachipay pu̱tum yumá̱ hua̱ntu̱ quin li̱scujma̱hu, huata xatlá̱n camakni̱hu laqui̱mpi̱ quin nakalhi̱ya̱hu hua̱ntu̱ xli̱chípat.’ ");
INSERT INTO tosNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pus chipako̱lh, makni̱ko̱lh, chu̱ tiqui̱makanko̱lh c-xquilhapa̱n pú̱cuxtu.” ");
INSERT INTO tosNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús kalhasquinko̱lh hua̱nti̱ xkaxmatnima̱kó̱: “¿Tú̱ chú̱ huixín puhuaná̱tit natlahuay yama̱ xma̱la̱na pú̱cuxtu? Pus hua̱ yuma̱ xama̱la̱ná̱ namín, chu̱ namakni̱ko̱y yuma̱ ni̱ lacuan xmaktakalhnaní̱n, chu̱ xlá̱ nama̱cui̱ntajli̱ko̱y xpu̱chaná̱n tanuj maktakalhnaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Huixín ¿pi̱ hasta ni̱ a̱li̱kalhtahuaka̱yá̱tit ma̱squi hua̱ yumá̱ la̱ntla̱ tatzokni̱t xtachihui̱n Dios c-Li̱kalhtahuaka? Lacatum chuná̱ tatzokni̱t: ‘Yama̱ tlanca chíhuix hua̱ntu̱ tilakmakanko̱lh pa̱tzapsnaní̱n sa̱mpi̱ tipuhuanko̱lh pi̱ ni̱tu̱ xlakasi, huata la̱nchú̱ huá̱ luhua kalhi̱ma̱ xlakasi sa̱mpi̱ ani̱t li̱jaxko̱y la̱ntla̱ta xli̱tlanca chiqui. ");
INSERT INTO tosNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hua̱mpi̱ hua̱ Quimpu̱chinacan Dios hua̱nti̱ laclhca̱ni̱t pi̱ chuná̱ naqui̱taxtuy laqui̱mpi̱ quin caj cacs nali̱lacahuana̱hu acxni̱ ucxilha̱hu la̱ntla̱ tu̱ tlahuani̱t.’” ");
INSERT INTO tosNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Puschí̱ xlacán xchipaputunko̱y Jesús sa̱mpi̱ xakata̱ksko̱ni̱t pi̱ caj kas chuná xlacsacni̱t yuma̱ takalhchihuí̱n laqui̱mpi̱ nali̱ma̱lacahua̱ni̱ko̱y. Hua̱mpi̱ cumu li̱lhu̱hua̱ xlaya̱kó̱ tachixcuhuí̱tat hua̱nti̱ xca̱najlako̱ni̱t xtachihuí̱n, pus pe̱cuaniko̱lh, chicá̱ pala nasi̱tzi̱niko̱y, huata xatlá̱n caj makaxtakko̱lh, chu̱ anko̱lhá. ");
INSERT INTO tosNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Cha̱nchu̱ tima̱lakacha̱naniko̱ca̱ makapitzi̱n fariseos, xa̱hua̱ ti̱ xta̱ta̱ya̱ko̱y rey Herodes, laqui̱mpi̱ nakalhputzako̱y c-xtachihuí̱n la̱ntla̱ nama̱makuasi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Acxni̱ lakchinko̱lh, chuná̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, ccatzi̱ya̱hu pi̱ hua̱ntu̱ huix huana, luhua hua̱ talulóktat, chu̱ huix ni̱tí̱ li̱quilhpuhuana, chu̱ ni̱tí̱ lacsacpa̱xqui̱ya, huata huaniya̱ hua̱ntu̱ ni̱tlá̱n tlahuama̱, ma̱squi lhu̱hua̱ hua̱nti̱ ni̱ li̱ucxilhputunko̱yá̱n; huata lacasquina̱ pi̱ xli̱pu̱tum tachixcuhuí̱tat nalakapasko̱y la̱ntla̱ Dios lacasquín nalatama̱ko̱y. Pus quinca̱huani, ¿pá̱ tla̱n nacmakxoko̱nana̱hu gobierno xla Roma, usu ni̱ chuna xlí̱lat? ");
INSERT INTO tosNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús xcatzi̱y pi̱ caj xkalhputzama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Tú̱huan caj ma̱n quimputza̱nanipá̱tit hua̱ntu̱ tla̱n naquili̱ma̱makuasi̱yá̱tit? Caquili̱tanítit okxtum tumi̱n laqui̱mpi̱ nacucxilha. ");
INSERT INTO tosNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Puschí̱ li̱minica̱ okxtum tumi̱n; acxni̱ úcxilhli̱ Jesús kalhasquinko̱lh: —¿Tí̱ xlacapú̱n talhca̱ni̱t yumá̱? Chu̱ ¿tí̱ xtucuhuiní̱ tatzoktahuilani̱t c-xlacan tumi̱n? Xlacán kalhti̱nanko̱lh: —Huá̱ xlacapu̱n xapuxcu ma̱paksi̱na romano. ");
INSERT INTO tosNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús huaniko̱lh: —Pus cama̱xquí̱tit gobierno hua̱ntu̱ lakchá̱n gobierno, chu̱ na̱ chuná̱ cama̱xquí̱tit Dios hua̱ntu̱ lakchá̱n namacama̱xqui̱yá̱tit. Xlacán caj cacs lacahuanko̱lh, chu̱ nia̱lh xcatzi̱ko̱y tú̱ nakalhasquimpalako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","A̱li̱sta̱lh anko̱lh ta̱chihui̱nanko̱y Jesús makapitzi̱n saduceos. Yuma̱ chixcuhuí̱n huanko̱y pi̱ xli̱stacna cha̱tum ni̱ catilakastakuánalh acxni̱ nani̱y, pus huá̱ xpa̱lacata̱ li̱kalhasquinko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ma̱kalhtahuaka̱ná, hua̱ Moisés quinca̱makaxtaknini̱tán aktum li̱ma̱paksí̱n, palapi̱ cha̱tum chixcú̱ nani̱y, na̱ nani̱makán xpusca̱t, chu̱ ni̱tú̱ kalhi̱ko̱y xcamancán, tla̱n huatiya̱ cha̱tum xta̱lá̱ nata̱tapu̱chuhuay xya̱stá, chu̱ nakalhi̱ko̱y xcamancán laqui̱mpi̱ ni̱ nalaksputa̱yay xtucuhuini xta̱lá̱ hua̱nti̱ ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Maktum xuilakó̱ kalhatujun lakkahuasán li̱nata̱lán; xapuxcu̱ tapu̱chúhualh, chu̱ ni̱ li̱maka̱s ni̱lh, hua̱mpi̱ ni̱ kalhi̱ko̱lh xcamancán. ");
INSERT INTO tosNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xli̱cha̱tuy xta̱lá̱ ta̱tapu̱chúhualh xya̱sta, chu̱ ni̱ li̱maka̱s quilhtamacú̱ xlá̱ na̱ ni̱pá̱, chu̱ ni̱mpala huá̱ ta̱kálhi̱lh camán. Na̱ chuná̱ akspúlalh xli̱kalhatutu. ");
INSERT INTO tosNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cha̱nchu̱ pu̱tum xli̱kalhatujuncán, pacs ta̱tapu̱chuhuako̱lh yama̱ pusca̱t, chu̱ ni̱ pala cha̱tum ta̱kálhi̱lh camán. Cha̱nchu̱ ni̱ li̱maka̱s yama̱ pusca̱t na̱ ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Chi̱nchu̱ acxni̱ xli̱stacnacán nalakastakuananko̱y ca̱li̱ní̱n, ¿xatí̱ ya̱ chixcú̱ xpusca̱t nahuán, pus pacs ta̱tapu̱chuhuako̱lh xkalhatujuncán? ");
INSERT INTO tosNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús kalhti̱ko̱lh: —Huixín luhua xli̱ca̱na̱ aktzanka̱ta̱yani̱tántit, sa̱mpi̱ ni̱ catzi̱yá̱tit, chu̱ ni̱ akata̱ksá̱tit la̱ntla̱ huan xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka, chu̱ na̱ ni̱ pala catzi̱yá̱tit la̱ntla̱ kalhi̱y xli̱tlihuaka̱ Dios, la̱ntla̱ xlá̱ li̱kalhi̱ma̱ko̱chá̱ xli̱stacnacan ni̱ní̱n c-akapú̱n acxni̱ xlá̱ ma̱lakastakuani̱ko̱y ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sa̱mpi̱ acxni̱ ni̱ní̱n lakastakuananko̱y ca̱li̱ní̱n, pacs chixcuhuí̱n, xa̱hua̱ lacchaján, nia̱lh tí̱ catitapu̱chuhuako̱lhcú, sa̱mpi̱ nali̱taxtuko̱y caj xta̱chuná̱ la̱ntla̱ xángeles Dios hua̱nti̱ huilako̱chá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chu̱ hua̱ xpa̱lacata, lapi̱ nalakastakuananko̱y ni̱ní̱n, usuchí̱ ni̱ nalakastakuananko̱y, ¿pi̱ ni̱ akata̱ksá̱tit la̱ntla̱ huamputún Li̱kalhtahuaka̱ hua̱ntu̱ tzokli̱ Moisés acxni̱ xlá̱ la̱ntla̱ ta̱chihuí̱nalh Dios c-pu̱kalhtum huátzapu, acxni̱ xaclhcuta̱yama̱, chuná̱ huánilh: ‘Quit xDios Abraham, xa̱hua̱ xla Isaac, chu̱ xla Jacob.’ ");
INSERT INTO tosNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Antá̱ huamputún pi̱ hua̱nti̱ lama̱kó̱ xastacná̱ ca̱tuxá̱huat, chu̱ hua̱nti̱ aya ni̱ko̱ni̱t, lacxtum la̱mpala xastacnacú̱ lama̱kó̱, sa̱mpi̱ Dios ni̱ hua̱ xDioscán ni̱ní̱n, huata hua̱nti̱ lama̱kó̱ xastacná. ");
INSERT INTO tosNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cha̱tum xma̱kalhtahuaka̱nacan judíos, xlá̱ xkalhakaxmatma̱ la̱ntla̱ xta̱la̱huanima̱kó̱ Jesús yama̱ chixcuhuí̱n, chu̱ cumu akáta̱ksli̱ pi̱ tla̱n xkalhti̱nani̱t, na̱ laktalacatzúhui̱lh laqui̱mpi̱ nakalhputzay, chuná̱ kalhásquilh: —La̱ntla̱ xli̱pacs li̱ma̱paksí̱n hua̱ntu̱ Dios ma̱sta̱ni̱t natlahuaya̱hu, ¿xani̱ma̱ tlak xlacasquinca? ");
INSERT INTO tosNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kálhti̱lh: —Hua̱ntu̱ luhua tlak xlacasquinca nama̱kantaxti̱ya̱hu xli̱ma̱paksi̱n Dios, chuná̱ huan: ‘Cakaxpáttit cha̱tunu̱ huixín xala c-Israel, hua̱ Quimpu̱chinacán Dios, xta̱stum huá̱ Dios, ni̱tí̱ a̱cha̱tum anán, chu̱ xma̱n huá̱ Mimpu̱chiná̱ natlahuaya. ");
INSERT INTO tosNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huá̱ capa̱xqui, chu̱ cali̱pá̱huanti̱ Mimpu̱china Dios xli̱pacs minacú̱, xli̱pacs mili̱stacna, xli̱pacs mintalacapa̱stacni, chu̱ xli̱pacs mili̱tlihuaka.’ ");
INSERT INTO tosNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chi̱nchu̱ hua̱ xli̱pu̱lactuy hua̱ntu̱ na̱ caj xta̱chuná, chuná̱ huan: ‘Calakalhámanti̱ a̱makapitzí̱n minta̱tama̱lacatzucún la̱ntla̱ huix acstulakalhamancana.’ Hua̱ la̱ntla̱ yuma̱ kampa̱tuy li̱ma̱paksí̱n, ni̱ anán a̱pu̱lactum hua̱ntu̱ tlak xlacasquinca, usu hua̱ntu̱ Dios lacasquín nama̱kantaxti̱ya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yama̱ xma̱kalhtahuaka̱na judíos huánilh Jesús: —Ma̱kalhtahuaka̱ná, luhua cma̱tla̱ni̱y tu̱ huana, pus xli̱ca̱na̱ pi̱ caj xma̱n cha̱tum Dios kalhi̱ya̱hu, chu̱ ni̱tí̱ anán a̱cha̱tum. ");
INSERT INTO tosNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pus na̱ luhua xli̱ca̱na̱ pi̱ luhua quili̱pá̱xqui̱t Dios xli̱pacs quinacú̱, xli̱pacs quintalacapa̱stacni, xli̱pacs quili̱stacna, chu̱ xli̱pacs quili̱tlihuaka. Pus hua̱nti̱ tlahuay yuma̱ pu̱lactuy li̱ma̱paksí̱n c-xlatáma̱t, a̱tzinú̱ makapa̱xuhuay Dios ni̱ xahua̱ xli̱pacs li̱ca̱xtlahuá̱n tu̱ nahuili̱nicán, usu li̱ma̱jiní̱n tu̱ lhcuyunicán yuma̱ c-tlanca templo. ");
INSERT INTO tosNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Acxni̱ káxmatli̱ Jesús la̱ntla̱ aksti̱tum kálhti̱lh yama̱ chixcú, chuná̱ huánilh: —Pus huix akatá̱kspa̱t la̱ Dios ma̱paksi̱namputún c-milatáma̱t, chu̱ cpuhuán pi̱ huix la̱mpala nia̱lh mákat la̱ntla̱ natanu̱ya̱pi̱ c-xtapaksi̱t Dios. A̱li̱sta̱lh nia̱lh tí̱ xpuhua̱ pala tú̱ caj lakahuán nakalhasquín. ");
INSERT INTO tosNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Antacú̱ xlama̱ Jesús c-templo, chu̱ tzucupaj ma̱siyuniko̱y xtachihui̱n Dios ti̱ xminko̱ni̱t, chu̱ chuná̱ kalhasquinko̱lh: —¿Pi̱ kalhi̱ko̱y talulóktat tu̱ huanko̱y mima̱kalhtahuaka̱nacán acxni̱ huanko̱y pi̱ yama̱ Cristo hua̱nti̱ namín ca̱lakma̱xtuyá̱n, mat xquilhtzúcut xuani̱t yama̱ xamaka̱n rey David? ");
INSERT INTO tosNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa̱mpi̱ maktum huatiya David acxni̱ ma̱puhuá̱ni̱lh Espíritu Santo, chuná̱ tzokli̱ c-libro xla Salmos xpa̱lacata Cristo, huá̱: ‘Quimpu̱china Dios chuná̱ huánilh cha̱tum li̱tum ti̱ na̱ Quimpu̱chiná: Catahuila̱ c-quimpa̱xtú̱n laqui̱mpi̱ naquinta̱ma̱paksi̱nana, hasta acxni̱ quit cmakatlajako̱ni̱t xli̱pacs hua̱nti̱ si̱tzi̱niko̱yá̱n laqui̱mpi̱ li̱macxtum nalakachixcuhui̱ko̱yá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pus ¿lá̱ntla̱ chú̱ tla̱n napuhuaná̱tit pi̱ hua̱nti̱ namín Cristo xquilhtzúcut nahuán rey David acxni̱ huatiya David xca̱cni̱naniy, xli̱ma̱pa̱cuhui̱y Quimpu̱chiná? Yama̱ quilhtamacú̱ lhu̱hua̱ cha̱pa̱xuhua̱na̱ xkaxmatnima̱kó̱ Jesús xtama̱siyún. ");
INSERT INTO tosNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","La̱ntla̱ makcatzi xta̱chihui̱nama̱kó̱ tachixcuhuí̱tat, chuná̱ huanipalako̱lh: “Skálalh catahuilátit, ni̱ naca̱akskahuimi̱yá̱n yama̱ mima̱kalhtahuaka̱nacán hua̱nti̱ ma̱siyuy xli̱ma̱paksi̱n Moisés. Luhua lakati̱ko̱y la̱ntla̱ pu̱latama̱ko̱y laccha̱lhma̱nxlhaka̱tcán, chu̱ na̱ lakati̱ko̱y pi̱ pacs naca̱cni̱nanicán anta̱ni̱ naxakatli̱pa̱xtokko̱cán c-tiji. ");
INSERT INTO tosNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Acxni̱ anko̱y c-templo lacasquinko̱y nali̱kalhi̱ko̱cán tlak lacuan pu̱táhui̱lh anta̱ni̱ natahuilako̱y, chu̱ na̱ chuná̱ tlahuako̱y anta̱ni̱ huí̱ pu̱pa̱scua̱. ");
INSERT INTO tosNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Chu̱ hua̱nti̱ ni̱makanko̱cani̱t lacchaján akskahuimaklhti̱ko̱y xchiccán, chu̱ laqui̱mpi̱ ni̱tí̱ mat nacatzi̱y la̱ntla̱ xta̱yatcán, caj maclhca̱tlahuako̱y laclhma̱n xoracioncán. Hua̱mpi̱ ni̱ pala tzinú̱ catzi̱ko̱y pi̱ hua̱ xlacán ti̱ tlak li̱huacá̱ nali̱pa̱ti̱ko̱y xta̱kastacya̱huan Dios.” ");
INSERT INTO tosNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maktum Jesús xuí̱ lacatzú̱ anta̱ni̱ huilakó̱ xpu̱muju̱can limosna c-tlanca templo. Xlá̱ caj xucxilhma̱kó̱ la̱ntla̱ tachixcuhuí̱tat xmuju̱ma̱kó̱ tumi̱n, chu̱ lacricujni̱ xmuju̱ko̱y luhua lhu̱hua̱tna̱ xtumi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Caj li̱tlanca̱liya̱ chilh cha̱tum puni̱ni̱ pusca̱t, luhua xli̱ca̱na̱ li̱ma̱xkan xuani̱t, chu̱ c-aktum caja xlá̱ múju̱lh okxtuy tumi̱n xla cobre, ni̱tú̱ xtápalh xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús tasaniko̱lh xli̱ma̱kalhtahuáka̱t laqui̱mpi̱ na̱ naucxilhko̱y. Chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ hua̱ yuma̱ puni̱ni̱ pusca̱t xali̱ma̱xkan, tlak múju̱lh tumi̱n c-ca̱ja̱ ni̱ xahua̱ yama̱ lacricujni̱ hua̱nti̱ muju̱ko̱ni̱t lhu̱hua tumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pus xlacán ma̱sta̱ko̱ni̱t hua̱ntu̱ aya xakata̱xtuniko̱ni̱t, hua̱ xlá̱ la̱ntla̱ xca̱tali̱má̱xka̱t pacs ma̱sta̱ko̱ni̱t hua̱ntu̱ xkalhi̱y pala xli̱huá̱yalh. ");
INSERT INTO tosNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús aya xtaxtuma̱chi̱ c-tlanca templo xala c-Jerusalén acxni̱ cha̱tum xli̱ma̱kalhtahuáka̱t, chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, caucxilhkó̱ lakli̱lakati̱t chíhuix hua̱ntu̱ li̱ca̱xtlahuacani̱t yuma̱ pá̱tzaps xla tlanca xtemplo̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús kálhti̱lh: —Luhua tla̱n ucxílhpa̱t yuma̱ lactlanca chíhuix hua̱ntu̱ li̱ca̱xtlahuacani̱t yuma̱ tlanca templo, hua̱mpi̱ ni̱ catzi̱ya̱ pi̱ nia̱lh maka̱s quilhtamacú̱ pacs yuma̱ lactlanca chiqui nia̱lh catitasíyulh, sa̱mpi̱ nalactilhmi̱cán, chu̱ nia̱lh pala aktum chíhuix catitahui̱ anta̱ni̱ la̱kalhuili̱ko̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","A̱li̱sta̱lh ta̱anko̱lh xli̱ma̱kalhtahuáka̱t c-xaka̱stí̱n huanicán Monte de los Olivos. Yuma̱ ka̱stí̱n luhua xta̱lacatzajua̱ xta̱hui̱ anta̱ni̱ xyá̱ tlanca templo xala c-Jerusalén. Acxni̱ antá̱ cha̱nko̱lh Jesús, cúlucs tahui̱. Cha̱nchu̱ a̱li̱sta̱lh tilakminko̱lh Pedro, Santiago, Juan, xa̱hua̱ Andrés, chu̱ chuná̱ tze̱k kalhasquinko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Clacasquina̱hu xquinca̱huani, ¿ní̱ li̱huaya̱ chuná̱ nalay yumá̱ la̱ntla̱ nalactilhmi̱cán a̱ya̱chá̱ tlanca templo? ¿Tú̱ nali̱tasiyuy hua̱ntu̱ naclitaluloka̱hu laqui̱mpi̱ naccatzi̱ya̱hu pi̱ aya nakantaxtuy hua̱ntu̱ u̱cu quinca̱li̱ta̱chihuí̱nanti? ");
INSERT INTO tosNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Kalhti̱ko̱lh Jesús, tzúculh huan: “Cuí̱ntaj catlahuátit, ni̱tí̱ naca̱akskahuiyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sa̱mpi̱ lhu̱hua̱ ti̱ naminko̱y xta̱chuná̱ la̱ntla̱ quit nali̱taxtuputunko̱y, chu̱ nahuanko̱y: ‘Quit Cristo laqui̱mpi̱ nacca̱lakma̱xtuyá̱n’, chu̱ lhu̱hua̱ ti̱ nata̱kskahuiko̱y, chu̱ naca̱najlaniko̱y xtachihui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Na̱ chuna li̱tum, huixín nakaxpatá̱tit la̱ntla̱ nali̱chihui̱nancán cani̱huá̱ lama̱kó̱ la̱ta̱la̱tlahu, hua̱mpi̱ huixín ni̱ cape̱cuántit sa̱mpi̱ xlacasquinca̱ pi̱ pu̱lh chuná̱ nalay. Hua̱mpi̱ xli̱pacs yumá̱ cajcu xquilhtzúcut la̱ntla̱ nalay á̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Sa̱mpi̱ cani̱cahuá̱ ca̱tuxá̱huat xli̱lhu̱hua ca̱chiquí̱n nala̱lacata̱qui̱ko̱y akatunu ca̱chiquí̱n, chu̱ akatunu nación. Tíyat lacaxtum natachiquiy ca̱tuxá̱huat, chu̱ nalay tatzíncstat. Hua̱mpi̱ pacs yumá̱ cajcu li̱quilhtzucúmaj nahuán la̱ntla̱ tu̱ namín tlanca tapa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Hua̱mpi̱ huixín catatlihuáklhtit xpa̱lacata̱ tu̱ naca̱okspulayá̱n sa̱mpi̱ naca̱macama̱sta̱caná̱tit c-xpu̱ma̱paksi̱ncan lactlanca napuxcún, chu̱ naca̱ma̱pa̱ti̱ni̱caná̱tit c-xpu̱kalhtahuakacan judíos, naca̱li̱pincaná̱tit c-xlacati̱ncan reyes caj quimpa̱lacata; chuná̱ huixín tla̱n naquili̱chihui̱nana̱pítit pi̱ xli̱ca̱na̱ quili̱pa̱huaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pus la̱ntla̱ ni̱ a̱lakchá̱n nahuán quilhtamacú̱ la̱ntla̱ nakantaxtuy hua̱ntu̱ cca̱huanimá̱n, yuma̱ quintachihuí̱n hua̱ntu̱ ma̱sta̱y laktáxtut nali̱chihui̱nanko̱cán xli̱ca̱tlanca̱ ca̱tuxá̱huat, chu̱ pacs nalakapascán. ");
INSERT INTO tosNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chu̱ acxni̱ huixín naca̱li̱pincaná̱tit, naca̱macama̱sta̱caná̱tit, ni̱ cali̱puhuántit xpa̱lacata la̱ntla̱ nakalhti̱naná̱tit, ni̱ pala a̱li̱sok calacapa̱stáctit. Huixín chuná̱ nahuaná̱tit hua̱ntu̱ Dios naca̱ma̱catzi̱ni̱yá̱n yama̱ quilhtamacú̱, pus ni̱ huixín catichihui̱nántit huata hua̱ yama̱ Espíritu Santo nachihui̱nán mimpa̱lacatacán. ");
INSERT INTO tosNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Yama̱ quilhtamacú̱ xacstu li̱nata̱lán nala̱macama̱sta̱ko̱y laqui̱mpi̱ namakni̱ko̱cán, chu̱ natla̱tna̱ namacama̱sta̱ko̱y hasta ma̱squi xcamancán laqui̱mpi̱ namakni̱ko̱cán, chu̱ makapitzi̱n lakkahuasán namacama̱sta̱ko̱y hasta ma̱squi xtla̱tcán laqui̱mpi̱ na̱ namakni̱ko̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pacs tachixcuhuí̱tat naca̱li̱xcajniko̱yá̱n caj xpa̱lacata ca̱najlayá̱tit quintachihuí̱n, hua̱mpi̱ hua̱nti̱ nata̱yaniy, chu̱ ni̱ nali̱makaxtakta̱yay pi̱ quili̱pa̱huán hasta la̱ntla̱ nati̱taxtuko̱y yuma̱ ni̱ lacuan quilhtamacú̱, pus hua̱ tamá̱ nama̱akapu̱taxti̱y xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Acxni̱ huixín naucxilhá̱tit pi̱ kantaxtuma̱ hua̱ntu̱ títzokli̱ xamaka̱n profeta Daniel acxni̱ tili̱chihuí̱nalh la̱ntla̱ nali̱kama̱nancán, chu̱ li̱xcájnit nali̱ma̱xtucán yama̱ tlanca xtemplo̱ Dios xala c-Jerusalén, chu̱ antá̱ c-xpu̱lacni naya̱huacán dios xatatlahuamakxtu; acxnicú̱ huixín hua̱nti̱ lama̱ko̱chá nahuán c-xatiyat Judea catza̱látit tuncán ca̱lacsipijni. (Hua̱nti̱ li̱kalhtahuakay yuma̱ libro caakáta̱ksli̱ hua̱ntu̱ li̱chihui̱nama̱ Jesús.) ");
INSERT INTO tosNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chu̱ hua̱nti̱ huacachá nahuán c-xaksti̱n xchic, acxni̱ nata̱ctay laqui̱mpi̱ natza̱lay, huata xatlá̱n ni̱ catánu̱lh laqui̱mpi̱ nama̱xtuy pala tu̱ nalé̱n hua̱ntu̱ kalhi̱y c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na̱ chuná̱ hua̱nti̱ ani̱t nahuán c-xca̱tuhuá̱n, huata xatlá̱n ni̱ catáspitli̱ c-xchic laqui̱mpi̱ namín tiyay xtaka̱nu. ");
INSERT INTO tosNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Koxutaní̱n lacchaján hua̱nti̱ luhua acxni̱ yama̱ quilhtamacú̱ ta̱tatlako̱y, chu̱ nia̱lh xacstu lama̱koj nahuán, usuchí̱ hua̱nti̱ ma̱tziqui̱ko̱y nahuán cskatacán! ");
INSERT INTO tosNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cali̱squinítit Dios pi̱ ni̱ tica̱pu̱tlakacaná̱tit acxni̱ luhua xquilhtamacú̱ ca̱lonkni. ");
INSERT INTO tosNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sa̱mpi̱ lhu̱hua tapa̱tí̱n nalay yama̱ quilhtamacú̱ hua̱ntu̱ niucxni̱ a̱lay xta̱chuná̱ hasta acxni̱ Dios titláhualh ca̱tuxá̱huat, chu̱ nia̱lh pala catilapá̱ a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lapi̱ hua̱ quimpu̱chinacán ni̱ nama̱actzuhui̱y yama̱ quilhtamacú̱ la̱ntla̱ nalay tapa̱tí̱n, ni̱ pala cha̱stum catiakapu̱táxtulh, hua̱mpi̱ xlá̱ catzi̱y hua̱ntu̱ tlahuama̱, chu̱ nama̱chokoy sa̱mpi̱ lakalhamanko̱y hua̱nti̱ xlá̱ lacsacko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Chu̱ yama̱ quilhtamacú̱ pala huí̱ ti̱ naca̱huaniyá̱n: ‘Caucxílhtit yama̱ chixcú huá̱ Cristo’, usu tanu̱ ti̱ nahuán: ‘Yuma̱ chixcú hua̱ Cristo’, huixín ni̱ caca̱najlátit. ");
INSERT INTO tosNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sa̱mpi̱ naminko̱y hua̱nti̱ naca̱akskahuiko̱yá̱n, chu̱ nahuanko̱y pi̱ huá̱ Cristo, chu̱ tanu̱ ti̱ nahuanko̱y pi̱ Dios ma̱lakacha̱ko̱ni̱t nali̱chihui̱nanko̱y xtalacapa̱stacni. Xlacán natlahuako̱y lactlanca li̱ca̱cni tatlahu hua̱ntu̱ nali̱ucxilhcán pi̱ kalhi̱ko̱y li̱tlihuaka, chu̱ laqui̱mpi̱ tla̱n nali̱akskahuinanko̱y; hasta xalán na̱ chuná̱ naakskahuiputunko̱y hua̱nti̱ Dios lacsacko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huá̱ xpa̱lacata cca̱li̱huaniyá̱n, luhua skálalh catahuilátit sa̱mpi̱ a̱li̱sok cca̱huanimá̱n hua̱ntu̱ naqui̱taxtuy a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Hua̱mpi̱ yama̱ quilhtamacú̱ acxni̱ aya ti̱taxtuko̱ni̱t nahuán tacatzanájuat, natalakapaklhtu̱ti̱y chichiní, chu̱ hua̱ papá, nia̱lh catimakaxkaká̱nalh ca̱tzi̱sní. ");
INSERT INTO tosNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chuj chí̱ yama̱ stacu̱ hua̱ntu̱ huilakó̱ c-akapú̱n natamakuasko̱y, chu̱ pacs hua̱ntu̱ tasiyuko̱y c-akapú̱n natalacchiquiko̱y, chu̱ huilhaj nalako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Acxnitiyá̱ xli̱pacs tachixcuhuí̱tat naquiucxilhko̱y quit Xatalacsacni Chixcú la̱ntla̱ cmímaj nahuán c-xlacni puclhni, chu̱ natasiyuy tlanca quili̱tlihuaka, xa̱hua̱ quili̱ca̱cni. ");
INSERT INTO tosNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na̱ acxnicú̱ nacma̱lakacha̱ko̱y quiángeles xli̱ca̱tlanca̱ ca̱tuxá̱huat hasta anta̱ni̱ tlak xatanka̱nu̱y laqui̱mpi̱ nama̱macxtumi̱ko̱cán xli̱pacs cani̱hua̱ xalaní̱n xlakskata̱n Dios hua̱nti̱ lacsacko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Acxni̱ ucxilhá̱tit tzucuy akayuja̱ makapitzi̱n quihui, chu̱ tzucuy akaskatampalay, huixín catzi̱yá̱tit pi̱ aya talacatzuhui̱ni̱ttá̱ quilhtamacú̱ la̱ntla̱ nalhca̱cnán. ");
INSERT INTO tosNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pus na̱ chuna li̱tum acxni̱ naucxilhá̱tit kantaxtuma̱ hua̱ntu̱ ca̱la̱nchú̱ cca̱li̱ta̱chihui̱namá̱n, pus cacatzí̱tit pi̱ aya talacatzuhui̱majá̱ quilhtamacú̱ la̱ntla̱ nacmimpalay ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ ni̱ pacs ni̱ko̱ni̱t nahuán tachixcuhuí̱tat hua̱nti̱ ca̱la̱nchú̱ lama̱ko̱lhcú̱ pala ni̱ xapu̱lh nakantaxtuy xli̱pacs hua̱ntu̱ cca̱li̱ta̱chihui̱namá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Luhua lacatancs cca̱huaniyá̱n pi̱ pacs akapú̱n chu̱ ca̱tiyatna̱ ma̱squi caláksputli, hua̱mpi̱ quintachihuí̱n ni̱ lay catiláksputli̱ hasta nakantaxtuko̱y xli̱pacs tu̱ cli̱chihui̱nani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Hua̱mpi̱ acxni̱ yama̱ quilhtamacú̱ chuná̱ nalay, chu̱ xatú̱ hora nahuán, ti̱ni̱ catzi̱y, hasta ni̱ pala hua̱ ángeles ti̱ huilako̱chá̱ c-akapú̱n, chu̱ na̱ ni̱ pala quit Xacam ccatzi̱y, huata caj xma̱n Dios Xatla̱t catzi̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Pus huá̱ xpa̱lacata̱ cca̱li̱huaniyá̱n pi̱ luhua skálalh, chu̱ cha̱catzi̱ya̱ catahuilátit sa̱mpi̱ ni̱ catzi̱yá̱tit xatú̱ ya̱ quilhtamacú̱ nalakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na̱ chuná̱ naqui̱taxtuy xta̱chuná̱ la̱ntla̱ cha̱tum chixcú hua̱nti̱ an paxia̱lhnán mákat, hua̱mpi̱ acxni̱ ni̱ a̱taquilhanu̱y, ma̱cui̱ntajli̱ko̱y cscujní̱n xtascújut, chu̱ macama̱xqui̱ko̱y cha̱tunu̱ xtascujutcán, chu̱ ya̱huay cha̱tum c-tlanca má̱laccha laqui̱mpi̱ nama̱lacqui̱niy xpu̱chiná̱ acxni̱ namimpalay. ");
INSERT INTO tosNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pus na̱ chuná̱ huixín skálalh catahuilátit sa̱mpi̱ ni̱ catzi̱yá̱tit xatú̱ ya̱ quilhtamacú̱ nacmín quit Mimpu̱chinacán, pala acxni̱ tzi̱suama̱, usu pala ca̱ta̱ncánat, usu acxni̱ natasay pu̱yu̱, usu acxni̱ naspalhca̱huanko̱y, usu acxni̱ ca̱cuhuinitá. ");
INSERT INTO tosNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pus luhua skálalh catahuilátit sa̱mpi̱, ¿cha̱mpala xamaktum ni̱ li̱catzi̱huilátit nahuán acxni̱ nactaxtuya̱chi, chu̱ lhtatapá̱tit nahuán? ");
INSERT INTO tosNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yuma̱ tu̱ cca̱huanimá̱n huixín na̱ chuná̱ clacasquín pi̱ li̱macxtum cacatzi̱ko̱lh pacs a̱makapitzí̱n hua̱nti̱ naquinkalhkalhi̱ko̱y acxni̱ nacmín, pi̱ skálalh catahuilako̱lh.” ");
INSERT INTO tosNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Aaktuy quilhtamacú̱ xtzanka̱y la̱ntla̱ nalakchá̱n xpa̱scuajcan judíos xla ta̱kspuntza̱lí̱n, acxni̱ xli̱pacs hua̱nti̱ xala c-Israel xuako̱y caxtala̱nchu̱ hua̱ntu̱ ni̱tú̱ kalhi̱y levadura. Acxnicú̱ yama̱ xanapuxcun pa̱lijni, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos tzucuko̱lh li̱kalhchihui̱nanko̱y xpa̱lacata la̱ntla̱ naakskahuiko̱y Jesús laqui̱mpi̱ tla̱n nachipako̱y, chu̱ a̱li̱sta̱lh namakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Hua̱mpi̱ xlacán xquilhuama̱kó̱: —Ni̱ nachipaya̱hu acxni̱ luhua xquilhtamacu̱ xapa̱scuaj ta̱kspuntza̱lí̱n sa̱mpi̱ xamaktum yama̱ li̱lhu̱hua̱ hua̱nti̱ pa̱xqui̱ko̱y nasi̱tzi̱ko̱y, chu̱ nali̱aklhu̱hua̱tnanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús xani̱t lakapaxia̱lhnán Simón, yama̱ chixcú̱ hua̱nti̱ xma̱pacsani̱t acxni̱ xkalhi̱y aktum li̱xcajnit tajátat huanicán lepra, xlá̱ antá̱ xuilachá̱ c-Betania. Maktum xuí̱ Jesús xua̱yama̱ acxni̱ chi̱lh cha̱tum pusca̱t, xli̱mín pa̱tum lumi̱ta̱ xatla̱n perfume xla nardo xánat, luhua tapala̱xlá xuani̱t xtápalh yama̱ quilhtamacú̱. Talacatzúhui̱lh anta̱ni̱ xuí̱ Jesús, chu̱ ma̱kálhka̱lh lumi̱ta, chu̱ li̱akpaxi̱ko̱lh perfume c-xakxe̱ka Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Makapitzí̱n hua̱nti̱ antá̱ xuilakó̱ lacatzú̱, tzúculh si̱tzi̱niko̱y yama̱ pusca̱t, chu̱ chuná̱ xla̱huaniko̱y: —Camakaxtáktit. ¿Tú̱huan luhua caj pá̱xcat tláhualh yuma̱ xatapala̱xla perfume? ");
INSERT INTO tosNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Pus tla̱n xtili̱sta̱ca̱ aktutu ciento tumi̱n xla plata, chu̱ hua̱ntu̱ xtástokli̱ xatumi̱n xtili̱makta̱yako̱ca̱ lakli̱ma̱xkaní̱n. Na̱ catu̱huá̱ a̱ti̱pa̱tu̱ tu̱ xli̱huanima̱kó̱ yuma̱ koxuta pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Hua̱mpi̱ Jesús káxmatli̱ hua̱ntu̱ xlacán xquilhuama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Tú̱huan makali̱puhuaná̱tit, sa̱mpi̱ tla̱n tu̱ quintlahuanini̱t? ");
INSERT INTO tosNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pus hua̱nti̱ li̱ma̱xkaní̱n lama̱kó̱ xa̱li̱ankalhí̱n ca̱ta̱lamá̱n nahuán c-milaksti̱pa̱ncán, chu̱ tla̱n namakta̱yako̱yá̱tit acxni̱ huixín napuhuaná̱tit, hua̱mpi̱ quit nia̱lh maka̱s quilhtamacú̱ cactica̱ta̱latamá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hua̱ntu̱ xlá̱ tla̱n puhua̱, pus chuná̱ tláhualh, chu̱ ma̱squi ni̱ catzi̱y, xlá̱ a̱li̱ma̱lacmu̱clhuni̱ni̱t quintiyatli̱hua̱ laqui̱mpi̱ acxni̱ naquima̱acnu̱cán ma̱squi nia̱lh tú̱ caquili̱tlahuaca̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n, pi̱ caxani̱cahuá̱ anta̱ni̱ natali̱chihui̱nán yuma̱ xatla̱n tama̱catzi̱ní̱n xla akapu̱táxtut xli̱ca̱tlanca̱ ca̱tuxá̱huat, na̱ nali̱chihui̱nancán hua̱ntu̱ tláhualh yuma̱ pusca̱t laqui̱mpi̱ pacs nali̱lacapa̱staccán. ");
INSERT INTO tosNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, hua̱nti̱ xta̱tapaksi̱ko̱y kalhacu̱tuy xli̱ma̱kalhtahuaka̱t Jesús, alh ta̱chihui̱nanko̱y hua̱nti̱ xta̱la̱tlahuako̱y Jesús xanapuxcún pa̱lijni laqui̱mpi̱ nata̱lacca̱xlako̱y la̱ntla̱ tla̱n namacama̱xqui̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Acxni̱ xlacán kaxmatko̱lh hua̱ntu̱ xma̱lacnu̱nima̱ko̱ca̱ pa̱xuhuako̱lh, li̱kalhti̱ko̱lh nama̱xqui̱ko̱y tumi̱n; hasta acxni̱ Judas tzúculh putzay la̱ntla̱ natlahuay pi̱ namacama̱sta̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Acxni̱ lákcha̱lh yama̱ quilhtamacú̱ xtama̱ko̱tani̱n xpa̱scuajcan judíos xla ta̱kspuntza̱lí̱n, acxni̱ xlacán huako̱y caxtala̱nchu̱ hua̱ntu̱ ni̱tú̱ ta̱tlahuacani̱t li̱ma̱xcutí̱n, chu̱ acxni̱ c-akatunu chiqui makni̱ko̱cán lactzu̱ borrego laqui̱mpi̱ chuná̱ nali̱ca̱cni̱nanicán Dios yama̱ c-pa̱scua̱, xli̱ma̱kalhtahuaka̱t Jesús chuná̱ kalhasquinko̱lh: —¿Ní̱ lacasquina̱ nacana̱hu ca̱xuili̱ya̱hu pu̱hua̱y laqui̱mpi̱ nali̱hua̱yana̱hu xali̱hua̱y borrego yuma̱ xtama̱ko̱tani̱n pa̱scua̱ xla ta̱kspuntza̱lí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pus Jesús ma̱lakacha̱ko̱lh cha̱tuy xli̱ma̱kalhtahuáka̱t pi̱ naanko̱y ca̱xtlahuako̱y yama̱ lí̱huat, chu̱ chuná̱ huaniko̱lh: —Capimpítit c-tlanca ca̱chiquí̱n, chu̱ antá̱ huixín naucxilhá̱tit cha̱tum chixcú̱ cucale̱ma̱ pa̱tum stu̱n chúchut. Casta̱lanítit, ");
INSERT INTO tosNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","chu̱ anta̱ni̱ natanu̱ya̱chá, nahuaniyá̱tit chixcú̱ ti̱ c-xchic: ‘Huan quima̱kalhtahuaka̱nacán: ¿Ní̱ huí̱ pu̱lactum chiqui̱ anta̱ni̱ nacta̱huako̱y quili̱ma̱kalhtahuáka̱t tahua̱y xla ta̱kspuntza̱lí̱n yuma̱ ca̱tzi̱sní?’ ");
INSERT INTO tosNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Na̱ naca̱le̱ná̱n c-xli̱quilhmactuy chiqui̱ anta̱ni̱ naca̱ma̱siyuniyá̱n pu̱lactum tlanca chiqui, chu̱ pacs kalhi̱y tu̱ tamaclacasquín, antá̱ huixín caca̱xtlahuátit quintahua̱ycán hua̱ntu̱ nahuaya̱hu yuma̱ catzi̱sní. ");
INSERT INTO tosNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yama̱ xli̱ma̱kalhtahuáka̱t anko̱lh c-tlanca ca̱chiquí̱n, xli̱ca̱na̱ chuná̱ ma̱noklhuko̱lh xta̱chuná̱ la̱ntla̱ xuaniko̱ni̱t Jesús. Xlacán antá̱ ca̱xtlahuako̱lh lí̱huat tu̱ nali̱ca̱cni̱naniko̱y Dios pa̱scua̱ xla ta̱kspuntza̱lí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Acxni̱ aya tzí̱sualh, Jesús ta̱chinko̱lh a̱makapitzi̱n xli̱ma̱kalhtahuáka̱t, ");
INSERT INTO tosNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","chu̱ pu̱tum ta̱tahuilako̱lh laqui̱mpi̱ nahua̱yanko̱y. Acxni̱ aya xua̱yama̱kó̱ Jesús huaniko̱lh: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ cha̱tum ti̱ quinta̱hua̱yama̱ ti̱ naquimacama̱sta̱y c-xmacancan hua̱nti̱ quinta̱la̱tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Cha̱nchu̱ xlacán tzucuko̱lh tali̱puhua̱ni̱ko̱y, chu̱ tzucuko̱lh la̱kalhasquinko̱y cha̱tunu cha̱tunu: —¿Ma̱x quit nacmacama̱sta̱y? Cha̱nchu̱ a̱cha̱tum huampá̱: —¿Pi̱ quit cahuá̱? ");
INSERT INTO tosNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús kalhti̱ko̱lh: —La̱ntla̱ mili̱kalhacu̱tuycán, cha̱tum nataxtuya̱chá̱ hua̱nti̱ lakxtum quinta̱tamakaju̱ma̱ xcaxtala̱nchu̱ c-quimpula̱tucán. ");
INSERT INTO tosNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pus chuná li̱kantaxtuma̱ hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ hua̱ntu̱ naquiakspulay quit Xatalacsacni Chixcú; hua̱mpi̱ koxutá̱ yama̱ chixcú̱ hua̱nti̱ naquimacama̱sta̱y. ¡Xatlá̱n xtihua̱ pi̱ ni̱ xtitachixcuhuí̱lalh! ");
INSERT INTO tosNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Acxni̱ cajcu xua̱yama̱kó̱, Jesús tíyalh mactum caxtala̱nchu̱, pa̱xcatcatzí̱nilh Dios xlí̱huat, chu̱ acxni̱ lakchákalh ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: —Catiyátit, chu̱ cahuátit yuma̱ caxtala̱nchu̱, sa̱mpi̱ huá̱ li̱taxtuy quintiyatli̱hua. ");
INSERT INTO tosNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A̱li̱sta̱lh tiyapá̱ pa̱tum vaso xchuchut uva, pa̱xcatcatzí̱nilh Dios, ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ pacs li̱kotnanko̱lh tziní̱n hua̱ntu̱ xtaju̱ma̱ c-vaso. ");
INSERT INTO tosNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Chu̱ chuná̱ huaniko̱lh: —Hua̱ yuma̱ xchuchut uva li̱taxtuy quinkalhni̱ tu̱ nastajtamakán xpa̱lacatacan xli̱pacs tachixcuhuí̱tat laqui̱mpi̱ nacatzi̱cán li̱pu̱tum pi̱ Dios tlahuani̱t xasa̱sti xtalacca̱xlán la̱ntla̱ nama̱akapu̱taxti̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ nia̱lh maktum cactili̱kótnalh xchuchut uva hasta acxni̱ nama̱lakcha̱ni̱y quilhtamacú̱ la̱ntla̱ nacli̱kotnampalay tanu̱ xasa̱sti xchuchut uva c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Acxni̱ makasputko̱lh aktum tatlí̱n, aya titaxtuko̱lh, tianko̱lh c-xaka̱stí̱n huanicán Monte de los Olivos. ");
INSERT INTO tosNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chu̱ antá̱ huaniko̱lh Jesús: —Yuma̱ ca̱tzi̱sní, pacs huixín lhtuj naquimakaxtaká̱tit. Pus chuná nakantaxtuy la̱ntla̱ titzóknalh cha̱tum profeta acxni̱ ma̱puhuá̱ni̱lh Dios: ‘Quit nacma̱sta̱y quilhtamacú̱ camakni̱ca̱ xma̱putxuani̱nacán, chu̱ xli̱pacs calhni̱lu̱ nata̱kahuani̱ko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Hua̱mpi̱ acxni̱ quit clakastakuanani̱ttá nahuán ca̱li̱ní̱n pu̱lana̱ nacampalay c-Galilea laqui̱mpi̱ antá̱ natanoklha̱cha̱hu. ");
INSERT INTO tosNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro huánilh: —Ma̱squi pacs catza̱lamakankó̱n, quit ni̱ cactiakxtakmakán. ");
INSERT INTO tosNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hua̱mpi̱ Jesús huánilh: —Luhua xli̱ca̱na̱ tu̱ cuaniyá̱n, pi̱ huix chiyú̱ yuma̱ ca̱tzi̱sní, acxni̱ ni̱ a̱tasay nahuán xli̱maktuy pu̱yu̱, maktututá̱ huani̱ta nahuán pi̱ ni̱ quilakapasa. ");
INSERT INTO tosNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Hua̱mpi̱ Pedro kalhpa̱tlihuaklh xquilhuama̱ xlá̱ huampá̱: —Ma̱squi na̱ acxtum xquinta̱makni̱ca̱ hua̱mpi̱ ni̱ cactihua̱ pi̱ ni̱ clakapasá̱n. Cha̱nchu̱ a̱makapitzí̱n pacs chuná̱ huaniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Acxni̱ cha̱nko̱lh c-aktum ca̱quihuí̱n huanicán Getsemaní, Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Unú̱ catahuilaká̱tit xli̱makua u̱cán tlahuay oración. ");
INSERT INTO tosNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Xma̱n huá̱ ta̱anko̱lh Pedro, Santiago, chu̱ Juan, a̱lacatanu̱ le̱nko̱lh. Antá̱ cajmaktum tzúculh tali̱puhua̱ni̱y, chu̱ aklituanán. ");
INSERT INTO tosNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ cmakcatzi̱y aktum tali̱puhuá̱n c-quinacú̱, la̱mpala aya cli̱ni̱putún. Unú̱ caquinkalhkalhí̱tit, hua̱mpi̱ ni̱ calhtatátit. ");
INSERT INTO tosNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jesús tlá̱hualh actzú̱, tatzokóstalh ca̱tiyatna, squínilh li̱tlá̱n Dios palapi̱ tla̱n ni̱ xmá̱xqui̱lh tapa̱tí̱n hua̱ntu̱ nalakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Cha̱nchu̱ tláhualh xoracion, chuná̱ xquilhuama̱: —Ta̱ta̱ Dios, huix pacs tla̱n catu̱cahuá̱ tlahuaya, pus hua̱ lapi̱ huix lacasquina, ni̱ caquima̱xqui̱ yuma̱ tapa̱tí̱n, hua̱mpi̱ ni̱ calalh hua̱ntu̱ quit clacasquín hua̱mpi̱ huá̱ calalh mintalacasquín. ");
INSERT INTO tosNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Taspitpá̱ anta̱ni̱ xuilakó̱ xli̱ma̱kalhtahuáka̱t, hua̱mpi̱ xlacán pu̱tum clhtatama̱kó̱. Chuná̱ huánilh Pedro: —Pedro, ¿tú̱huan lhtatápa̱t? ¿Tú̱ lay macalaya̱ ni̱ nalhtataya̱ ca̱na̱ pi̱ caj aktum hora? ");
INSERT INTO tosNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Skálalh catahuilátit; chu̱ na̱ catlahuátit oración laqui̱mpi̱ ni̱ natatlaji̱yá̱tit acxni̱ naca̱li̱toklhcaná̱tit hua̱ntu̱ ni̱tlá̱n. Pus ma̱squi mili̱stacnacán luhua xli̱ca̱na̱ aksti̱tum li̱piná̱tit xtalacapa̱stacni, mintiyatli̱huacán ni̱ ta̱yaniy sa̱mpi̱ xaxlajuani, ni̱ kalhi̱y li̱tlihuaka. ");
INSERT INTO tosNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús ampá̱ tlahuay oración, chu̱ chuná li̱tum qui̱li̱xakátli̱lh tu̱ huatiya̱ tachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Acxni̱ tapú̱spitli̱ anta̱ni̱ xuilakó̱ xli̱ma̱kalhtahuáka̱t, lhtatako̱ni̱t ta̱kspalako̱lh, sa̱mpi̱ hua̱ xlakastapucán, luhuata xlakpi̱tlakuanko̱ni̱t, na̱ ni̱ xcatzi̱ko̱y tu̱ nali̱kalhti̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xlá̱ ampá̱ tlahuay oración xli̱maktutu, chu̱ acxni̱ qui̱táspitli, chuná̱ huaniko̱lh: —¿Pá̱ chunacú̱ lhtatapá̱tit, chu̱ jaxpá̱tit? Pus nia̱lh chuná̱ catlahuátit sa̱mpi̱ aya lakcha̱ni̱t quilhtamacú̱ acxni̱ naquimacama̱sta̱cán quit Xatalacsacni Chixcú̱ c-xmacancan makla̱kalhi̱naní̱n hua̱nti̱ quisi̱tzi̱niko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cataca̱xta̱quí̱tit; caahu. Caucxílhtit, hua̱nti̱ naquimacama̱sta̱y; lacatzuhuá̱ mín. ");
INSERT INTO tosNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús cajcu xchihui̱nama̱ acxni̱ lakchinko̱lh lhu̱hua chixcuhuí̱n, huá̱ xpu̱laniti̱lhako̱y xli̱ma̱kalhtahuáka̱t huanicán Judas. Catu̱huá̱ xli̱minko̱y tu̱ nali̱macapa̱huanko̱y, huí̱ ti̱ xli̱mín espada, makapitzí̱n quihui. Yuma̱ chixcuhuí̱n huá̱ xma̱lakacha̱ko̱ni̱t xanapuxcun pa̱lijni, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos, chu̱ lakko̱lun ma̱paksi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas hua̱nti̱ macamá̱sta̱lh xuaniko̱ni̱t la̱ntla̱ nali̱lakapasko̱y laqui̱mpi̱ nale̱nko̱y: “Hua̱nti̱ quit naclacatzu̱ca, huá̱ cachipátit, chu̱ li̱huana̱ tachí̱n cali̱pítit.” ");
INSERT INTO tosNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Acxni̱ lákcha̱lh, laktalacatzúhui̱lh, chu̱ chuná̱ huánilh: —Uclakmimá̱n, ma̱kalhtahuaka̱ná. La̱nchuná̱ huaniko̱lh, lacátzu̱cli. ");
INSERT INTO tosNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Puschí̱ a̱makapitzí̱n aya tichipako̱lh Jesús laqui̱mpi̱ nale̱nko̱y la̱ cha̱tum tachí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cha̱tum xli̱ma̱kalhtahuáka̱t xtat má̱xtulh cspada, chu̱ ca̱actí̱nilh xtaké̱n cha̱tum cscujnicán hua̱nti̱ xma̱lakacha̱ko̱ni̱t xanapuxcun pa̱lijni. ");
INSERT INTO tosNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús huaniko̱lh yama̱ chixcuhuí̱n: —¿Tú̱ xpa̱lacata huixín tani̱tántit quinchipayá̱tit xta̱chuná̱ la̱ cha̱tum kalha̱ná, chu̱ hasta li̱tani̱tántit spada̱, xa̱hua̱ quihui? ");
INSERT INTO tosNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cha̱li̱ cha̱lí̱ quit antá̱ xquiucxilhá̱tit acxni̱ xacma̱siyunima̱kó̱ tachixcuhuí̱tat xtachihui̱n Dios, hua̱mpi̱ niucxni̱ quinchi̱li̱pítit; hua̱mpi̱ juerza̱ huá̱ chuná̱ qui̱li̱táxtulh laqui̱mpi̱ nakantaxtuy hua̱ntu̱ tatzokni̱t c-Li̱kalhtahuaka̱ tu̱ naquiakspulay. ");
INSERT INTO tosNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cha̱nchu̱ lhtuj makaxtakko̱lh xli̱pacscan xli̱ma̱kalhtahuáka̱t, lactza̱latama̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Hua̱mpi̱ cha̱tum xli̱ma̱kalhtahuáka̱t csta̱lanima̱ anta̱ni̱ xlacle̱ma̱ca̱ Jesús c-pu̱ma̱paksí̱n; acxni̱ ucxilhca̱, na̱ xchipaputuncán. Hua̱mpi̱ cumu caj xli̱tamaktlapani̱t mactum tlanca sábana, caj xaspupulu xmacni, ");
INSERT INTO tosNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","acxni̱ chipaca̱, caj huá̱ chipanica̱ sábana, hua̱mpi̱ cumu caj xamactum xuani̱t, huata xlá̱ tapú̱xtulh xsábana, chu̱ xamaklhpupulu̱ tzá̱lalh. ");
INSERT INTO tosNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","Huata Pedro na̱ tista̱lánilh tlak tzinú̱ lakamákat hasta li̱cha̱nca̱ Jesús c-xpu̱ma̱paksi̱ncan pa̱lijni, chu̱ antá̱ xlá̱ tamakáxtakli̱ anta̱ni̱ xuilakó̱ policías, chu̱ tzúculh ta̱skonko̱y. Pu̱tum xanapuxcun pa̱lijni, xa̱hua̱ lakko̱lún, pacs tamacxtumi̱ko̱lh, xa̱hua̱ xma̱kalhtahuaka̱nacan judíos. Caj li̱tlanca̱liya̱ li̱minca̱ Jesús c-xlacati̱n xapuxcu pa̱li̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xanapuxcun pa̱lijni, xa̱hua̱ xli̱pacs hua̱nti̱ xtamakstokko̱ni̱t, tzucuko̱lh putza̱naniko̱y tasta̱huán la̱ntla̱ nali̱makstuntlahuako̱y Jesús laqui̱mpi̱ nama̱makni̱ni̱nanko̱y, hua̱mpi̱ ni̱tú̱ xta̱ksniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma̱squi makapitzí̱n catu̱cahuá̱ tzúculh huanko̱y hua̱ntu̱ nali̱sta̱huako̱y, hua̱mpi̱ a̱li̱sta̱lh xtzucupalako̱y li̱aklhu̱hua̱tnanko̱y, sa̱mpi̱ ni̱ acxtum xli̱catzi̱ko̱y hua̱ntu̱ xli̱sta̱huama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Puschí̱ makapitzí̱n tita̱yako̱lh, chuná̱ tili̱sta̱huakolh Jesús: ");
INSERT INTO tosNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Quin ckaxmatni̱tahu pi̱ chuná̱ tihua̱ tama̱ chixcú: ‘Quit naclactlahuay yuma̱ xtemplo̱ Dios hua̱ntu̱ caj tamacani̱tlahu hua̱mpi̱ caj xli̱aktutu quilhtamacú̱ quit nacya̱huapalay aktum tu̱ ni̱ caj tamacani̱tlahu.’ ");
INSERT INTO tosNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Hua̱mpi̱ hasta ni̱ pala chuná acxtum xli̱catzi̱ko̱y hua̱ntu̱ xli̱aksani̱nama̱kó̱, chu̱ ni̱tú̱ xma̱tla̱ni̱ko̱y hua̱ntu̱ xli̱sta̱huama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Huá̱ chú̱ tá̱yalh hua̱nti̱ luhua xapuxcu pa̱li̱, chuná̱ huánilh Jesús: —¿Lá̱ntla̱ pi̱ ni̱tú̱ catili̱kalhtí̱nanti? ¿Pi̱ ni̱ kaxpátpa̱t la̱ntla̱ li̱lhu̱hua̱ tu̱ li̱ya̱huama̱kó̱n yuma̱ chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ni̱tú̱ kalhtí̱nalh, caj xma̱n cacs tá̱yalh. Hua̱mpi̱ yama̱ xapuxcu pa̱li̱ a̱maktum kalhasquimpá̱, chu̱ huánilh: —¿Pi̱ xli̱ca̱na̱ huix Cristo hua̱nti̱ xCam Dios? ");
INSERT INTO tosNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús huánilh: —Xli̱ca̱na̱ quit Cristo. Chu̱ namín quilhtamacú̱ acxni̱ huixín naucxilhá̱tit la̱ntla̱ quit Xatalacsacni Chixcú̱ cuilachá nahuán c-xpa̱xtu̱n Dios, chu̱ na̱ chuná̱ la̱ntla̱ quit cmima̱palachá nahuán c-xlacni puclhni. ");
INSERT INTO tosNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cha̱nchu̱ xapuxcu pa̱li̱, xti̱tli̱ xlháka̱t laqui̱mpi̱ pacs nacatzi̱cán pi̱ sí̱tzi̱lh, chu̱ huaniko̱lh ti̱ xta̱tastokko̱ni̱t: —¿Tú̱ taji̱ tili̱lacasquina̱hu ma̱luloknaní̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Caj xpa̱lacata xtachihuí̱n yuma̱ chixcú ta̱la̱lacata̱qui̱ni̱t Dios, aya kaxpáttit. ¿Tú̱ natlahuaniya̱hu, huixín puhuaná̱tit? Xli̱pacs hua̱nti̱ antá̱ xuilakó̱ kalhti̱nanko̱lh: —¡Luhua macuacachá̱ tala̱kalhí̱n, xlí̱lat camakni̱ca̱! ");
INSERT INTO tosNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Makapitzí̱n tzucuko̱lh lacachujmani̱ko̱y, li̱lakachi̱ko̱lh mactum lháka̱t, lakakaxiko̱lh, chu̱ chuná̱ tzúculh huaniko̱y: —Cacatzi, ¿tí̱ chuná̱ lakakaxima̱n? La̱ntla̱ chuná̱ tlahuako̱lh macama̱xqui̱ko̱ca̱ policías, chu̱ xlacán na̱ chuná̱ tzucuko̱lh lakakaxiko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Anta̱ni̱ c-xtanquilhti̱n chiqui̱ xta̱skoma̱kó̱ Pedro makapitzi policías, chilh cha̱tum xmaksquiti xapuxcu pa̱li̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Acxni̱ úcxilhli̱ pi̱ antá̱ cskoma̱, cacs lacaúcxilhli, chu̱ chuná̱ huánilh: —Huix na̱ xta̱lapu̱laya̱ Jesús xala c-Nazaret. ");
INSERT INTO tosNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro ni̱ li̱tá̱yalh, kalhtátze̱kli, chu̱ kálhti̱lh: —Ni̱ quit, ni̱ clakapasa̱ tama̱ chixcú̱ hua̱nti̱ huix huanípa̱t. Táxtulh quilhtí̱n anta̱ni̱ lactanu̱cán c-xli̱pacan chiqui, acxnitiyá̱ tásalh tantum pu̱yu̱. ");
INSERT INTO tosNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cha̱nchu̱ maksquití, cacs lacaucxilhpá̱ Pedro, chu̱ tzúculh huaniko̱y hua̱nti̱ antá̱ xlaya̱kó̱: —Xli̱ca̱na̱ hua̱ yuma̱ chixcú̱ na̱ xli̱ma̱kalhtahuaka̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro kalhtatze̱kpá̱, ni̱ li̱ta̱yapá̱ pala xli̱ca̱na̱ lakapasa. Caj li̱tlanca̱liya̱, na̱má̱ huanipalako̱lh Pedro hua̱nti̱ xta̱huilakó̱ antá: —Luhua maktum xli̱ca̱na̱ pi̱ na̱ huix cha̱tum xlacán, sa̱mpi̱ xala c-Galilea huix, hua tuncán caj mintachihuí̱n tla̱n li̱lakapascana. ");
INSERT INTO tosNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Cha̱nchu̱ xlá̱ tzúculh li̱aklhu̱hua̱tnán, chu̱ li̱quilhán Dios pi̱ xli̱ca̱na̱ tu̱ xkalhti̱nama̱, chu̱ huanipalako̱lh: —Lacatancs cca̱huaniyá̱n pi̱ ni̱ clakapasa̱ quit tama̱ chixcú, chu̱ hasta ni̱ ccatzi̱y xatí̱ li̱chihui̱nampá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Acxni̱ káxmatli̱ pi̱ tásalh xli̱maktuy pu̱yu̱, xlá̱ lacapá̱stacli̱ hua̱ntu̱ xuanini̱t Jesús: “Acxni̱ ni̱ a̱tasay nahuán xli̱maktuy pu̱yu̱, huix maktututá̱ huani̱ta nahuán pi̱ ni̱ quilakapasa.” Pedro luhua xli̱ca̱na̱ li̱puhua̱ acxni̱ lacapa̱stacko̱lh pi̱ xli̱ca̱na̱ kantáxtulh hua̱ntu̱ xuanini̱t Jesús, chu̱ tzúculh tasay. ");
INSERT INTO tosNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Acxni̱ tzi̱sa ca̱xkákalh, tamacxtumi̱palako̱lh xanapuxcun pa̱lijni, chu̱ xma̱kalhtahuaka̱nacan judíos, xa̱hua̱ lakko̱lún, chu̱ tachí̱n le̱nko̱lh Jesús c-xlacati̱n ma̱paksi̱na Pilato. ");
INSERT INTO tosNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xlá̱ ma̱kalhapáli̱lh Jesús, chu̱ kalhásquilh: —¿Pi̱ xli̱ca̱na̱ huix xReycan judíos? Jesús kálhti̱lh: —Xli̱ca̱na̱ hua̱ntu̱ quilhuámpa̱t sa̱mpi̱ quit xli̱ca̱na̱ rey. ");
INSERT INTO tosNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Xanapuxcun pa̱lijni na̱ li̱pe̱cua̱ tu̱ tzúculh li̱ya̱huako̱y ta̱ksaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato tá̱yalh chu̱ huánilh Jesús: —¿Lá̱ntla̱ pi̱ ni̱tú̱ kalhi̱ya tu̱ li̱kalhti̱nana? ¿Pi̱ ni̱ kaxpata̱ pi̱ catu̱huá̱ li̱ya̱huama̱kó̱n yuma̱ chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Hua̱mpi̱ ni̱ pala chuná̱ tú̱ kalhtí̱nalh Jesús. Puschí̱ lanaj xli̱lacahuán Pilato, hasta nia̱lh cátzi̱lh tú̱ nakalhasquín. ");
INSERT INTO tosNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ca̱ta ca̱ta̱ acxni̱ xlakchá̱n xapa̱scuaj ta̱kspuntza̱lí̱n, xli̱smani̱ni̱t Pilato xmakaxtakniko̱y tachixcuhuí̱tat cha̱tum tachí̱n, caxati̱cahuá̱ ti̱ nasquiniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Acxni̱ yama̱ quilhtamacú̱ c-pu̱la̱chi̱n xtanu̱ma̱ cha̱tum tachí̱n xuanicán Barrabás, xta̱pa̱ti̱nama̱kó̱ xta̱makni̱naní̱n ti̱ lhu̱hua̱ xmakni̱ko̱ni̱t acxni̱ xma̱lacatzuqui̱ko̱ni̱t talacata̱quí̱n c-xca̱chiqui̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Puschí̱ luhua acxnicú̱ gobernador Pilato xma̱kalhapali̱ma̱ Jesús, chinko̱lh li̱lhu̱hua, chu̱ tzucuko̱lh squiniko̱y pi̱ namakaxtaknipalako̱y cha̱tum tachí̱n la̱ntla̱ xa̱li̱ankalhí̱n xtlahuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hua̱mpi̱ Pilato kalhasquinko̱lh: —¿Pi̱ lacasquiná̱tit huixín, cacmakáxtakli̱ xreycan judíos? ");
INSERT INTO tosNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sa̱mpi̱ Pilato xcatzi̱y pi̱ caj xquiclhcatzaniko̱y xanapuxcun pa̱lijni, chu̱ huá̱ xli̱macama̱xqui̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Hua̱mpi̱ xanapuxcun pa̱lijni̱ tzucuko̱lh quilhca̱xya̱huako̱y li̱lhu̱hua, pi̱ huata xatlá̱n casquinko̱lh pi̱ xalaktaxtún camakaxtakca̱ Barrabás. ");
INSERT INTO tosNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato kalhasquimpalako̱lh: —Hua̱mpi̱ ¿tú̱ lacasquiná̱tit nactlahuaniy yama̱ chixcú̱ hua̱nti̱ huixín huaniyá̱tit xreycan judíos? ");
INSERT INTO tosNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xli̱putumcan chixcuhuí̱n tzucuko̱lh quilhanko̱y: —¡Capakaxtokohuacaca̱ c-cruz! ");
INSERT INTO tosNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato huanipalakó̱: —Hua̱mpi̱ ¿tú̱ ni̱tlá̱n hua̱ntu̱ tlahuani̱t? Hua̱mpi̱ xlacán caj xaa̱li̱huacá̱ xquilhama̱kó̱: —¡Capakaxtokohuacaca̱ c-cruz! ");
INSERT INTO tosNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato pi̱ ni̱ xlacasquín tí̱ nasi̱tzi̱niy, pus huá̱ li̱makáxtakli̱ Barrabás, chu̱ ma̱paksí̱nalh pi̱ naka̱snokcán Jesús, a̱li̱sta̱lh macama̱xqui̱ko̱lh tropa̱ laqui̱mpi̱ xlacán napakaxtokohuacako̱y c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Yama̱ tropa̱ le̱nko̱lh Jesús ca̱lakuá̱n, hua̱mpi̱ antiyá̱ c-xpu̱lacni xpu̱ma̱paksí̱n Pilato anta̱ni̱ pu̱tum tropa̱ xtamacxtumi̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xlacán ma̱makxtuko̱lh xlháka̱t Jesús, chu̱ ma̱lhaka̱ko̱lh mactum xatzutzoko lháka̱t xta̱chuná̱ la̱ xla rey, chu̱ acuili̱ko̱lh c-xakxe̱ka aktum corona xla lhtucú̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chu̱ tzucuko̱lh ca̱tasako̱y, chuná̱ huanko̱lh: —¡Caxani̱li̱huayá̱ calatáma̱lh yuma̱ xReycan judíos! ");
INSERT INTO tosNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na̱ li̱aksnokmi̱ko̱lh kantum ká̱ti̱t, chu̱ lacachujmani̱ko̱lh, lakataquilhpu̱tako̱lh, chu̱ tatzokostaniko̱lh xta̱chuná̱ la̱ntla̱ tlahuacán c-xlacati̱n cha̱tum Rey. ");
INSERT INTO tosNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Acxni̱ xli̱kama̱nanko̱ni̱ttá, tima̱pu̱xtuko̱lh xlháka̱t xatzutzoko, chu̱ huá̱ ma̱lhaka̱ko̱lh tu̱ luhua xlháka̱t, chu̱ le̱nko̱lh anta̱ni̱ napakaxtokohuacacán c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cha̱tum chixcú xala c-Cirene xuanicán Simón, xlakkahuasán xuaniko̱cán Alejandro, chu̱ Rufo, xlá̱ xqui̱taspitma̱ c-xpú̱cuxtu, chu̱ antá̱ xti̱taxtuma̱ anta̱ni̱ xya̱kó̱ tropa̱ acxni̱ chipapa̱xtokko̱lh makapitzi̱n tropa̱, chu̱ akchú̱ ma̱le̱ni̱ko̱lh xcruz Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Antá̱ tile̱nko̱lh c-aktum ka̱stí̱n huanicán Gólgota. (Yuma̱ c-xatachihui̱n arameo huamputún C-xaclucut ni̱n.) ");
INSERT INTO tosNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Acxni̱ antá̱ li̱cha̱nca̱ Jesús, ma̱xqui̱ca̱ nahuay vino hua̱ntu̱ xta̱lacuilhacani̱t xaxu̱n lí̱cuchun laqui̱mpi̱ ni̱ namakcatzi̱y tapa̱tí̱n, huanicán mirra. Xlá̱ caj kalhuá̱nalh hua̱mpi̱ ni̱ hualh. ");
INSERT INTO tosNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ca̱maknaja̱tza hora tzí̱saj xuani̱t acxni̱ pakaxtokohuacaca̱ c-cruz. Yama̱ tropa̱ tzucuko̱lh li̱tlahuako̱y suerte xlhaka̱t Jesús xatí̱ tla̱n cha̱tunu̱ nalakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","C-xacpu̱n cruz xtokohuacaca̱ paktzu̱ tama, antá̱ xuan xatú̱ xpa̱lacata xli̱makni̱cani̱t, chu̱ c-tama̱ chuná̱ xtatzokni̱t: “Hua̱ yuma̱ chixcú xReycan judíos.” ");
INSERT INTO tosNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chu̱ na̱ antá̱ xta̱pakaxtokohuacako̱cani̱t cha̱tuy kalha̱naní̱n, cha̱tum c-xpakstácat, chu̱ hua̱ a̱cha̱tum c-xpakxuqui. ");
INSERT INTO tosNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Puschí̱ chuná̱ tili̱kantáxtulh hua̱ntu̱ xtatzoktahuilani̱t c-Li̱kalhtahuaka̱ la̱ntla̱ tu̱ naqui̱taxtuy sa̱mpi̱ lacatum huan pi̱: “Xta̱chuná̱ la̱ cha̱tum cala̱hua̱ xta̱yatcán li̱ma̱xtuca̱.” ");
INSERT INTO tosNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Cati̱huá̱ ti̱ antá̱ xti̱taxtuko̱y caj xli̱kalhakama̱nanko̱y, xli̱ta̱cchiquiko̱y, chu̱ chuná̱ xuanko̱y: —¡Na̱ chí̱ huix huana̱ pi̱ nama̱laksputuya̱ tlanca xtemplo̱ Dios, chu̱ na̱ caj li̱aktutu quilhtamacú̱ nali̱ya̱huapalaya! ");
INSERT INTO tosNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Tú̱ chú̱ lani? ¿Tú̱huan ni̱ lay chú̱ ta̱ctaya̱ c-cruz, chu̱ acstuma̱laktaxti̱cana̱? ");
INSERT INTO tosNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pus na̱ chuná̱ chu̱ makapitzi̱n xanapuxcun pa̱lijni, chu̱ xma̱kalhtahuaka̱nacan judíos xli̱kalhakama̱nanko̱y; chuná̱ xla̱huaniko̱y cha̱tunu cha̱tunu: —¡Caucxílhtit a̱huaca̱ ti̱ xuan pi̱ tla̱n nama̱laktaxti̱ko̱y a̱makapitzi̱n chixcuhuí̱n hua̱mpi̱ chú̱ hua̱ xlá̱, xacstu ni̱ lay ma̱laktaxti̱cán! ");
INSERT INTO tosNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Huá̱ lapi̱ xlá̱ xli̱ca̱na̱ hua̱ Cristo, usuchí̱ xreycan judíos, pus caacstutáactalh c-cruz laqui̱mpi̱ nali̱ucxilha̱hu, chu̱ chuná̱ naca̱najlaniya̱hu. Na̱ chuná̱ yama̱ cha̱tuy kalha̱naní̱n ti̱ xta̱pakaxtokohuacako̱cani̱t catu̱huá̱ xli̱huanima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Yama̱ quilhtamacú̱, ma̱x luhua ca̱tastúnut xuani̱t, acxni̱ tzí̱sualh xli̱ca̱tlanca̱ ca̱tuxá̱huat, hasta ca̱maktutu hora ca̱ko̱tanú̱n a̱cu ca̱xkakapá̱. ");
INSERT INTO tosNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na̱ luhua acxnitiyá̱ chú̱ yama̱ hora Jesús luhua pixtlanca̱ chuná̱ ca̱tásalh: “Eloi, Eloi, ¿lama sabactani?” (Yuma̱ c-xatachihui̱n arameo huamputún: “Tla̱ti Dios, Tla̱ti Dios, ¿tú̱huan lhtuj quimakaxtakni̱ta̱ yuma̱ quilhtamacú̱?”) ");
INSERT INTO tosNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Makapitzi̱n chixcuhuí̱n hua̱nti̱ antá̱ xlaya̱kó̱ kaxmatko̱lh, chu̱ chuná̱ tzucuko̱lh la̱huaniko̱y: —Cakaxpáttit, huá̱ tasanima̱ profeta Elías. ");
INSERT INTO tosNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cha̱tum takosú̱n alh li̱lupa̱ xaxcuta vino actzu̱ panáma̱c, chu̱ ma̱akánu̱lh c-kantum ká̱ti̱t, li̱tamacayá̱hualh laqui̱mpi̱ nahuay Jesús. Hua̱mpi̱ chuná̱ huaniko̱lh makapitzí̱n: —Calaka̱lh chú̱ pala namín ma̱acti̱y Elías. ");
INSERT INTO tosNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","A̱maktum luhua pixtlanca̱ tásalh Jesús, chu̱ aya tuncán jalhpá̱ni̱lh, ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Acxni̱ ni̱lh Jesús yama̱ tlanca lháka̱t li̱lakalhapá̱n ni̱ma̱ xma̱huacacani̱t c-tlanca templo xala c-Jerusalén pu̱makatuy tihua̱ la̱ntla̱ acstutalácxti̱tli, ta̱lhmá̱n hasta tu̱tzú̱. ");
INSERT INTO tosNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Cha̱tum capitán romano antá̱ xlaya̱ lacatzú̱ anta̱ni̱ xuaca̱ Jesús, xlá̱ pacs káxmatli̱ la̱ntla̱ chihuí̱nalh, chu̱ úcxilhli̱ acxni̱ ni̱lh. Xlá̱ chuná̱ huá̱: —Yuma̱ chixcú̱ xli̱ca̱na̱ luhua hua̱ Xcam Dios xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Cha̱nchu̱ antá̱ na̱ caj mákat xlacamiya̱kó̱ makapitzi̱n lacchaján. Hua̱nti̱ na̱ antá̱ xya̱kó̱, huá̱ María Magdalena chu̱ Salomé, chu̱ María xtzican Jacobo xli̱cha̱tuy kahuasa, chu̱ José. ");
INSERT INTO tosNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yuma̱ lacchaján huatiya̱ ti̱ csta̱lanitla̱huanko̱ni̱t Jesús acxni̱ cani̱huá̱ xan, chu̱ xlacán xmakta̱yako̱ni̱t acxni̱ xlama̱chá̱ c-Galilea. Xa̱hua̱ antá̱ xya̱kó̱ a̱makapitzi̱n lhu̱hua lacchaján hua̱nti̱ lacxtum xta̱minko̱ni̱t Jesús c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Acxni̱ xko̱tanu̱ma̱ yama̱ viernes xli̱makua tla̱ncú̱ scujcán sa̱mpi̱ xtama̱ko̱tani̱n quilhtamacú̱ sábado acxni̱ xli̱pacs judíos xjaxko̱y, ");
INSERT INTO tosNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","milh cha̱tum tali̱pa̱hu chixcú̱ hua̱nti̱ na̱ xmaktapaksi̱y c-xpu̱ma̱paksi̱ncan judíos c-Jerusalén xuanicán José, xlá̱ xala c-Arimatea. Yumá̱ tla̱n chixcú xuani̱t, xli̱pa̱huán Dios chu̱ xkalhkalhi̱ma̱ acxni̱ Dios nahuili̱y xasa̱sti xtapáksi̱t ca̱tuxá̱huat. José ni̱ anán talacapuhuá̱n laktánu̱lh Pilato c-xpu̱ma̱paksí̱n, huánilh pi̱ camá̱xqui̱lh quilhtamacú̱ naán ma̱acti̱y xtiyatli̱hua Jesús sa̱mpi̱ xma̱acnu̱putún. ");
INSERT INTO tosNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato lanaj tilacahua̱ acxni̱ cátzi̱lh pi̱ aya xni̱ni̱t Jesús, chu̱ ma̱tasani̱ní̱nalh capitán laqui̱mpi̱ nakalhasquín lapi̱ xli̱ca̱na̱ xni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Acxni̱ huánilh capitán pi̱ xli̱ca̱na̱ aya xni̱ni̱t, xlá̱ má̱xqui̱lh talacasquín José pi̱ cale̱lh xtiyatli̱hua̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tamá̱hualh mactum sábana, chu̱ alh ma̱acti̱y c-cruz xtiyatli̱hua Jesús, huá̱ li̱pu̱máksuitli; chu̱ a̱li̱sta̱lh máacnu̱lh c-aktum tahuaxni̱ tu̱ aya xuaxcani̱t c-xlacan sipi̱, chu̱ li̱huana̱ li̱lakatálalh aktum tlanca chíhuix anta̱ni̱ xlactanu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, chu̱ María xtzi José, xlacán ucxilhko̱lh anta̱ni̱ ma̱acnu̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ti̱yataxtuko̱lh sábado acxni̱ ni̱tí̱ cscuja, chu̱ acxni̱ tzí̱sualh huatiya̱ yama̱ quilhtamacú̱, María Magdalena, María xtzi José chu̱ Santiago, xa̱hua̱ Salomé, xlacán anko̱lh tama̱huako̱y xamu̱clhun lí̱cuchun laqui̱mpi̱ naanko̱y li̱lactlahuako̱y xtiyatli̱hua Jesús. ");
INSERT INTO tosNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Li̱cha̱li̱ domingo, luhua tzi̱sacú̱ ta̱qui̱ko̱lh, chu̱ anko̱lh anta̱ni̱ xma̱acnu̱cani̱t Jesús cajcu xtaxtuma̱chi̱ chichiní. ");
INSERT INTO tosNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Xacstucán chuná̱ xla̱huaniti̱lhako̱y: —¿Tí̱ chú̱ naquinca̱ma̱pa̱nu̱niyá̱n cahuá̱ yama̱ tlanca chíhuix hua̱ntu̱ li̱lakatalanancani̱t anta̱ni̱ ma̱nu̱cani̱t Jesús? ");
INSERT INTO tosNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Hua̱mpi̱ acxni̱ cha̱nko̱lh, ucxilhko̱lh pi̱ tama̱ tlanca chíhuix hua̱ntu̱ xli̱lakatalanancani̱t, aya xma̱pa̱nu̱cani̱t, na̱ luhua lakahuan lanca xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tanu̱ko̱lh tzinú̱ c-xpu̱lacni anta̱ni̱ xma̱mi̱cani̱t Jesús, chu̱ antá̱ ucxilhkolh c-xpakstácat pi̱ xuí̱ cha̱tum kahuasa hua̱nti̱ luhua snapapa̱ xlháka̱t. Puschí̱ xlacán luhua tipe̱cuanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Hua̱mpi̱ xlá̱ chuná̱ huaniko̱lh: —Ni̱ cape̱cuántit. Huixín putzayá̱tit Jesús xala c-Nazaret hua̱nti̱ pakaxtokohuacaca̱ c-cruz. Hua̱mpi̱ xlá̱ aya lakastakuánalh ca̱li̱ní̱n. Ma̱squi luhua caucxílhtit u̱nú, ni̱tí̱ anta̱ni̱ xma̱mi̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xatlá̱n capitittá, chu̱ cahuaniko̱pítit xli̱ma̱kalhtahuáka̱t, xa̱hua̱ Pedro, pi̱ Jesús naca̱a̱li̱pu̱laniyá̱n, naán c-Galilea, chu̱ antá̱ naucxilha̱pí̱tit sa̱mpi̱ chuná̱ tica̱huanín. ");
INSERT INTO tosNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yama̱ lacchaján xtape̱cuacán tzucuko̱lh lhpipiko̱y; lacapala̱ taxtuko̱lh, chu̱ takosú̱n anko̱lh. Hua̱mpi̱ ti̱ni̱ pala tú̱ tuncán li̱ta̱chihui̱nanko̱lh hua̱ntu̱ xucxilhko̱ni̱t sa̱mpi̱ xpe̱cuaxni̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Acxni̱ ni̱ xa̱ca̱xkakako̱y yama̱ quilhtamacu̱ domingo, Jesús xlakastakuanani̱ttá̱ ca̱li̱ní̱n; hua̱mpi̱ xapu̱lana̱ María Magdalena tasiyúnilh laqui̱mpi̱ xlá̱ naucxilha̱ pi̱ lama̱ xastacná. Hua̱ yuma̱ pusca̱t hua̱nti̱ xtamacaxtunini̱t kalhatujun cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Acxni̱ xlá̱ úcxilhli̱ Jesús, a̱li̱sta̱lh lakanko̱lh yama̱ xli̱ma̱kalhtahuáka̱t hua̱nti̱ maka̱s quilhtamacú̱ xta̱latapu̱la̱ko̱ni̱t, chu̱ huaniko̱lh la̱ntla̱ xucxilhni̱t; xlacán xli̱puhuama̱kó̱, chu̱ luhua xtasama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Hua̱mpi̱ acxni̱ María huaniko̱lh pi̱ Jesús xlakastakuanani̱t, chu̱ xlama̱ xastacná sa̱mpi̱ ma̱n xlakastapu̱ xli̱ucxilhni̱t, ni̱ ca̱najlaniko̱lh xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","A̱li̱sta̱lh na̱ tasiyuniko̱lh cha̱tuy li̱tum xli̱ma̱kalhtahuáka̱t, xlacán xtiji̱tla̱huama̱kó̱, xama̱kó̱ ca̱quihuí̱n, tasiyuniko̱lh laqui̱mpi̱ naucxilhko̱y pi̱ xlama̱ xastacná. ");
INSERT INTO tosNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Na̱ titaspitko̱lh xlacán, chu̱ anko̱lh li̱ta̱chihui̱nanko̱y a̱makapitzi̱n li̱ma̱kalhtahuáka̱t pi̱ xli̱ca̱na̱ xlakastakuanani̱t. Hua̱mpi̱ ni̱ pala chuná̱ ca̱najlako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","A̱li̱sta̱lh li̱tum na̱ tasiyuniko̱lh pacs kalhaca̱huitu xli̱ma̱kalhtahuáka̱t luhua acxni̱ xlacán xuilakó̱ c-mesa xua̱yama̱kó̱. Xlá̱ lacaquilhni̱ko̱lh tzinú̱ sa̱mpi̱ luhua ni̱ xca̱najlaputunko̱y pala xli̱ca̱na̱ xlama̱ xastacná, huata caj li̱aklhu̱hua̱tnanko̱lh acxni̱ xli̱chihui̱nancani̱t pi̱ xlakastakuanani̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A̱li̱sta̱lh chuná̱ huaniko̱lh: —Capítit xli̱ca̱tlanca̱ ca̱tuxá̱huat, nali̱akchihui̱naniko̱yá̱tit xli̱pacs caxani̱cahua̱ xalaní̱n yuma̱ li̱pa̱xuhu quintachihuí̱n tu̱ ma̱sta̱y akapu̱táxtut. ");
INSERT INTO tosNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Hua̱nti̱ naquili̱pa̱huanko̱y, chu̱ nata̱kmunuko̱y nalakma̱xtuko̱y xli̱stacnacán, hua̱mpi̱ hua̱nti̱ ni̱ naquili̱pa̱huanko̱y, pus namakatzanka̱ko̱y xli̱stacnacán c-xlacati̱n Dios acxni̱ nama̱xoko̱ni̱ko̱cán ni̱tlá̱n hua̱ntu̱ tlahuako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chu̱ laqui̱mpi̱ nacatzi̱cán pi̱ Dios huí̱ c-milatama̱tcán makapitzí̱n hua̱nti̱ naquili̱pa̱huanko̱y nama̱xqui̱ko̱cán li̱tlihuaka̱ pi̱ tla̱n nama̱pacsako̱y hua̱nti̱ kalhi̱ko̱y cspiritu akskahuiní, chu̱ tla̱n nali̱chihui̱nanko̱y ti̱pa̱lhu̱hua tachihuí̱n hua̱ntu̱ xlacán ni̱ catzi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Makapitzí̱n hasta tla̱n nachipako̱y lu̱hua, chu̱ ni̱tú̱ catitlahuaniko̱lh, usu lapi̱ nahuako̱y pala tu̱ li̱ni̱cán, ni̱tú̱ catili̱laniko̱lh, chu̱ makapitzí̱n caj xmacancán tla̱n nali̱ma̱pacsako̱y ta̱tatlaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cha̱nchu̱ Quimpu̱chinacán, acxni̱ aya xma̱katsputuni̱t xtachihuí̱n, tzúculh tata̱lhma̱ni̱y, chu̱ alh c-akapú̱n anta̱ni̱ tahuilachá̱ c-xpa̱xtu̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A̱li̱sta̱lh, yama̱ xli̱ma̱kalhtahuáka̱t taxtuko̱lh, chu̱ cani̱cahuá̱ anko̱lh li̱akchihui̱nanko̱y xtachihui̱n Cristo hua̱ntu̱ ma̱sta̱y laktáxtut. Cha̱nchu̱ pi̱ Dios xmakta̱yama̱kó̱, xlacán xtlahuako̱y lhu̱hua̱ lactlanca li̱ca̱cni tatlahu laqui̱mpi̱ chuná̱ nacatzi̱cán pi̱ Dios xta̱lama̱kó̱ c-xlatama̱tcán, chu̱ xli̱ca̱na̱ xli̱chihui̱nama̱kó̱ xtalacapa̱stacni.");
INSERT INTO tosNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Xli̱ca̱na̱ li̱pa̱xuhu ctzokniyá̱n yama̱ tachihuí̱n hua̱ntu̱ lhu̱hua̱ ti̱ tzaksako̱ni̱t li̱huana̱ aksti̱tum xtzokputunko̱y hua̱ntu̱ kantáxtulh c-xlatama̱t Jesucristo, chu̱ luhua li̱huana̱ xma̱lacti̱tumi̱putunko̱y, ");
INSERT INTO tosNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","xta̱chuná̱ la̱ntla̱ quintica̱ma̱siyunikó̱n hua̱nti̱ luhua ma̱n xlakastapucán tili̱ucxilhko̱lh la̱ntla̱ titzucuchá, chu̱ a̱li̱sta̱lh xlacán na̱ tzúculh li̱akchihui̱nanko̱y yuma̱ tachihuí̱n sa̱mpi̱ xcatzi̱ko̱y pi̱ xli̱ca̱na̱ hua̱ntu̱ xli̱chihui̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Quit na̱ luhua li̱huana̱ cputza̱nani̱t, chu̱ ckalhasquini̱nani̱t xli̱pacs hua̱ntu̱ tiakspúlalh hasta la̱ntla̱ luhua titzucuchá, chu̱ la̱mpala luhua tla̱n cpuhuán pi̱ nactzokniyá̱n, chu̱ nacma̱lacti̱tumi̱niyá̱n xli̱pacs hua̱ntu̱ akspulanit c-xlatama̱t Quimpu̱chinacán, ");
INSERT INTO tosNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","laqui̱mpi̱ chuná̱ huix, tali̱pa̱hu Teófilo, lacatancs nacatzi̱ya̱ hua̱ntu̱ aya li̱ta̱kalhchihui̱nancani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pus hua̱ chú̱ nacuaniyá̱n la̱ntla̱ mini̱tanchá̱ yuma̱ tachihuí̱n: Yama̱ maká̱n quilhtamacú̱ acxni̱ Herodes li̱gobernador xli̱hui̱ c-Judea, na̱ acxni̱ xlama̱ cha̱tum xpa̱lijnican judíos xuanicán Zacarías, xlá̱ antá̱ xta̱tapaksi̱ko̱y makapitzi̱n pa̱lijni̱ hua̱nti̱ maka̱n quilhtamacú̱ tima̱lacatzuqui̱chá̱ Abías. Xpusca̱t Zacarías xuanicán Elisabet, xlá̱ na̱ xamaka̱n xtla̱tcán xuani̱t a̱ma̱ hua̱nti̱ luhua xapu̱lh pa̱li̱ xuanicán Aarón. ");
INSERT INTO tosNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías, chu̱ Ilisabet luhua aksti̱tum xlama̱kó̱ c-xlacati̱n Dios chu̱ pacs nama̱kantaxti̱ko̱y xli̱ma̱paksi̱n Quimpu̱chinacán; xli̱ca̱na̱ luhua tla̱n xcatzi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Hua̱mpi̱ ni̱ xkalhi̱ko̱y xcamancán, sa̱mpi̱ Elisabet ni̱ lay xkalhi̱y camán, xa̱hua̱chí̱ xlacxtumcán aya xko̱luma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Maktum acxni̱ lákcha̱lh la̱ntla̱ natlahuako̱y xtascujut li̱pa̱li̱ a̱ma̱ kampu̱tum pa̱lijni̱ anta̱ni̱ xmaktapaksi̱y Zacarías, pus huata antá̱ álh tlanca xtemplo Dios xalac Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chu̱ la̱ntla̱ xli̱smani̱ko̱ni̱t pa̱lijni nalacsacko̱y xtascujut cha̱tunu, huá̱ lákcha̱lh Zacarías natanu̱y lacatum c-templo anta̱ni̱ nalhcuyuy li̱ma̱jiní̱n c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Cha̱nchu̱ xli̱makua̱ clhcuma̱ li̱ma̱jiní̱n, xli̱pacs a̱makapitzi̱n ca̱cni̱naní̱n xtlahuanima̱kó̱ oración Dios c-xaquilhtí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Caj xamaktum cha̱tum xangel quimpu̱chinacán tasiyúnilh Zacarías; antá̱ titá̱yalh c-xpakstacat altar anta̱ni̱ c-xokspún clhcuma̱ li̱ma̱jiní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Acxni̱ Zacarías úcxilhli̱ yama̱ ángel, pé̱cualh, chu̱ pi̱ xaklituanani̱t nia̱lh xcatzi̱y tu̱ natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Huampi̱ ángel chuná̱ huánilh: —Zacarías, ni̱ capé̱cuanti; sa̱mpi̱ luhua lakati̱y Dios la̱ntla̱ xakatli̱ni̱ta̱ c-mioración, xlá̱ aya kaxmatni̱t hua̱ntu̱ huix squini̱ta, chu̱ mimpusca̱t Elisabet nama̱chixcuhui̱li̱y cha̱tum actzu̱ skata, chu̱ huix nali̱ma̱pa̱cuhui̱ya̱ Juan. ");
INSERT INTO tosNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Huix luhua xli̱ca̱na̱ nali̱pa̱xuhuaya̱ minkahuasa, chu̱ na̱ chuná̱ a̱makapitzi̱n xli̱lhu̱hua̱ tachixcuhuí̱tat nali̱pa̱xuhuako̱y acxni̱ xlá̱ nalacachín; ");
INSERT INTO tosNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sa̱mpi̱ yama̱ minkahuasa luhua xli̱ca̱na̱ tlanca tascújut nakalhi̱y c-xlacati̱n Dios, na̱ ni̱ catíhualh cuchu, usu hua̱ntu̱ li̱kachi̱cán; chu̱ kalhi̱y nahuán xli̱tlihuaka Espíritu Santo hasta acxni̱ ni̱ a̱lacachín nahuán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cha̱nchu̱ lhu̱hua̱ minata̱chiquí̱n xala c-Israel hua̱nti̱ tamakatli̱niko̱ni̱t pi̱ nia̱lh luhua li̱pa̱huanko̱y Dios, xlá̱ nama̱akata̱ksni̱ko̱y pi̱ xma̱n huá̱ xli̱lakataquilhputatcán, chu̱ chuná̱ xlacán aksti̱tum nali̱pa̱huampalako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yama̱ minkahuasa Juan napu̱laniy yama̱ Mima̱akapu̱taxti̱nacán hua̱nti̱ kalhkalhi̱pá̱tit; chu̱ na̱ chuná̱ nakalhi̱y xtalacapa̱stacni, chu̱ xli̱tlihuaka hua̱ntu̱ xkalhi̱y xamaka̱n profeta Elías laqui̱mpi̱ nalakpali̱niko̱y xtalacapa̱stacnicán, xnacu̱can xanatla̱tna laqui̱mpi̱ napa̱xqui̱ko̱y xcamancán, chu̱ hua̱nti̱ luhua xalactzaca̱tna̱ xtalacapa̱stacnicán, xlá̱ nama̱siyuniko̱y la̱ntla̱ nakalhakaxmatni̱nán hua̱ntu̱ Dios li̱ma̱paksi̱putunko̱y. Chu̱ chuná̱ xlá̱ na̱má̱ naca̱xtlahuaniko̱y lhu̱hua̱ hua̱nti̱ cha̱catzi̱ya̱ nakalhkalhi̱ko̱y Quimpu̱chinacán hua̱nti̱ namín. ");
INSERT INTO tosNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías kalhásquilh yama̱ ángel: —Hua̱mpi̱, ¿lá̱ntla̱ chú̱ nacli̱catzi̱y lapi̱ xli̱ca̱na̱ hua̱ntu̱ quihuanípa̱t, sa̱mpi̱ quit aya ko̱lutá, chu̱ na̱ chuná̱ quimpusca̱t na̱ le̱ná̱ xca̱ta, tzicaná? ");
INSERT INTO tosNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yama̱ ángel chuná̱ kálhti̱lh: —Quit quihuanicán Gabriel, chu̱ quit cta̱scujma̱ Dios, xlá̱ quima̱lakacha̱ni̱t laqui̱mpi̱ nacminá̱n xakatli̱yá̱n, chu̱ nacma̱catzi̱ni̱yá̱n u̱ma̱ xatla̱n tama̱catzi̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pus chú̱ cumu huix ni̱ ca̱najla̱ hua̱ntu̱ cuanín, pus chú̱ ko̱ko nahuana; na̱ ni̱ lama̱ catichihuí̱nanti, hasta ni̱li̱huaya̱ naqui̱kantaxtuy hua̱ntu̱ cuanini̱tán, chu̱ nalacachín minkahuasa. Sa̱mpi̱ nakantaxtuy pacs hua̱ntu̱ cuanín. ");
INSERT INTO tosNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cha̱nchu̱ c-xaquilhti̱n yama̱ tlanca templo antá̱ tachixcuhuí̱tat xkalhkalhi̱ma̱kó̱ laqui̱mpi̱ nataxtuya̱chi̱ Zacarías; hua̱mpi̱ xlacán lanaj xlacahuama̱kó̱ pi̱ maka̱s xmakapalama̱ c-templo. ");
INSERT INTO tosNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hua̱mpi̱ acxni̱ chú̱ taxtuchi̱ Zacarías, xko̱ko̱ni̱t, chu̱ ni̱ lay xchihui̱nán, huata caj xmacahuaniko̱y acxni̱ xkalhti̱putún hua̱ntu̱ xuaniko̱y. Pus acxnicú̱ catzi̱ko̱lh pi̱ ma̱x ni̱ tzanka̱y tu̱ xli̱ma̱lacahua̱ni̱cani̱t c-xpu̱lacni templo. ");
INSERT INTO tosNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Acxni̱ lákcha̱lh quilhtamacú̱ la̱ntla̱ ma̱kátzi̱lh xtascújut li̱pa̱li̱ c-tlanca templo xala c-Jerusalén Zacarías táspitli̱ c-xca̱chiquí̱n nac xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chi̱nchu̱ Elisabet hua̱nti̱ xpusca̱t Zacarías, ni̱ xli̱maka̱s tzúculh makcatzi̱y pi̱ nia̱lh xacstu xlama̱, chu̱ ma̱x pala akquitzis papá nia̱lh ni̱ní̱ álh. Chu̱ xlá̱ chuná̱ xpuhuán: ");
INSERT INTO tosNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Huá̱ chuná̱ quili̱tlahuani̱t Quimpu̱chinacán laqui̱mpi̱ quinata̱chiquí̱n nia̱lh taji̱ naquili̱kalhakama̱nanko̱y pi̱ ni̱ lay kalhi̱y camán.” ");
INSERT INTO tosNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","A̱li̱akcha̱xan papá̱ chú̱ tima̱lakacha̱pá̱ Dios xángel Gabriel c-aktum ca̱chiquí̱n anta̱ni̱ huanicán Nazaret c-xtama̱paksi̱n Galilea. ");
INSERT INTO tosNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Huá̱ álh lakapaxia̱lhnán cha̱tum tzuma̱t xuanicán María, yuma̱ tzuma̱t aya xli̱kalhti̱ni̱t José pi̱ nata̱tapu̱chuhuay; yama̱ José na̱ xma̱quilhtzuqui̱ni̱tanchá̱ xamaka̱n rey David. ");
INSERT INTO tosNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yama̱ ángel laktanu̱chá̱ anta̱ni̱ xuí̱ María, chu̱ chuná̱ huánilh: —¡Luhua ca̱na̱ li̱pa̱xuhu clakchimá̱n huix tzuma̱t hua̱nti̱ Dios lacsacni̱tán! Dios Quimpu̱chinacán ankalhi̱ná̱ ta̱huilán, xa̱huachí̱ a̱tzinú̱ huix siculuna̱tlahuani̱tán ni̱ xahua̱ a̱makapitzi̱n lacchaján. ");
INSERT INTO tosNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Acxni̱ María úcxilhli̱ ángel, xlá̱ xli̱ca̱na̱ lanaj li̱lacahua̱ tu̱ xli̱xakatli̱ma̱, chu̱ xlá̱ xpuhuama̱ xatú̱ cahuá̱ chuná̱ xli̱huanima̱. ");
INSERT INTO tosNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Hua̱mpi̱ ángel tuncán huanipá̱: —María, ni̱ capé̱cuanti sa̱mpi̱ Dios ucxilhlacachini̱tán, chu̱ lacsacni̱tán laqui̱mpi̱ li̱pe̱cua̱ nalakalhamaná̱n, ");
INSERT INTO tosNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","sa̱mpi̱ la̱nchiyú̱ nia̱lh miacstu huix, chu̱ nama̱chixcuhui̱li̱ya̱ cha̱tum skata, acxni̱ yuma̱ quilhtamacú̱ nalacachín, huix nali̱ma̱pa̱cuhui̱ya̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Xlá̱ tlanca̱ xca̱cni̱ nakalhi̱y, luhua tali̱pa̱hu chixcú nahuán, chu̱ nali̱tapa̱cuhui̱y xCam Dios hua̱nti̱ tlanca xquilhtzúcut. Xa̱hua̱ a̱li̱sta̱lh Quimpu̱chinacán Dios, na̱ tlanca Rey nali̱ma̱xtuy hua̱nti̱ xta̱chuná̱ nakalhi̱y xli̱ma̱paksí̱n la̱ntla̱ tu̱ xkalhi̱y xamaka̱n xquilhtzúcut rey David ");
INSERT INTO tosNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","laqui̱mpi̱ nama̱paksi̱ko̱y xli̱pacs israelitas caxani̱li̱huayaj xtihua̱, xa̱huachí̱ xli̱ma̱paksí̱n niucxni̱ catiláksputli. ");
INSERT INTO tosNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María kalhásquilh yama̱ ángel: —Hua̱mpi̱ ¿lá̱ntla̱ chu̱ luhua naqui̱taxtuy yumá̱, sa̱mpi̱ quit ni̱tí̱ cta̱hui̱ chixcú? ");
INSERT INTO tosNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xlá̱ kálhti̱lh: —Espíritu Santo nalakminá̱n, chu̱ xli̱tlihuaka Dios naakmiliyá̱n xta̱chuná̱ puclhni, pus huá̱ xpalacata yama̱ xasa̱ntujlani skata̱ hua̱nti̱ nalacachín, xla Dios nahuán, chu̱ luhua xCam Dios nali̱ma̱pa̱cuhui̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na̱ chuná̱ cacatzi̱ pi̱ minta̱puxnimat Elisabet na̱ nama̱chixcuhui̱li̱y cha̱tum actzu̱ skata̱ ma̱squi aya tzicaná. Pus ma̱squi chuná̱ huancán pi̱ xlá̱ ni̱ lay koka̱nán, pus chú̱ aya le̱ma̱ xli̱akcha̱xan papá̱ la̱ntla̱ nia̱lh xacstu lama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sa̱mpi̱ xli̱pacs hua̱ntu̱ xtalacasquin Dios ni̱ lay catitamakáxtakli̱ pala ni̱ nakantaxtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Acxnitiyá̱ María chuná̱ huá̱: —Quit c-xmacan Quimpu̱chinacan ctamakaxtaka, pus chuná̱ cama̱kantáxti̱lh Dios c-quilatáma̱t la̱ntla̱ tu̱ huix quihuanini̱ta. Acxni̱ chuná̱ huanko̱lh María, yama̱ ángel alhá. ");
INSERT INTO tosNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ni̱ li̱maka̱s María táca̱xli, chu̱ lacapala̱ tíalh c-xatiyat Judea hasta c-aktum ca̱chiquí̱n hua̱ntu̱ xuí̱ ca̱sipijni. ");
INSERT INTO tosNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Acxni̱ cha̱lh c-xchic Zacarías, tuncán tánu̱lh, chu̱ xakátli̱lh xta̱puxnimat Elisabet. ");
INSERT INTO tosNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chu̱ acxni̱ káxmatli̱ Elisabet pi̱ xakátli̱lh María, tuncán makcátzi̱lh pi̱ tatzuhuáji̱lh cskata̱ c-xpu̱lacni, chu̱ lákchilh xli̱tlihuaka Espíritu Santo. ");
INSERT INTO tosNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Chu̱ luhua pixtlanca̱ chuná̱ huá̱: —¡Dios a̱tzinú̱ huix ucxilhlacachini̱tán nalakalhamaná̱n ni̱ xahua̱ a̱makapitzi̱n lacchaján, chu̱ na̱ chuná̱ ucxilhlacachini̱t nalakalhamán minkahuasa hua̱nti̱ nalacachín! ");
INSERT INTO tosNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tú̱ quilakasi̱ quit laqui̱mpi̱ namín quilakapaxia̱lhnán hua̱nti̱ xtzi nahuán Quimpu̱chinacán? ");
INSERT INTO tosNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sa̱mpi̱ caj la̱ ckáxmatli̱ pi̱ quixákatli, yama̱ quiskata caj la̱ntla̱ pa̱xúhualh tatzuhuáji̱lh c-quimpu̱lacni. ");
INSERT INTO tosNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xli̱ca̱na̱ luhua li̱pa̱xuhu lápa̱t nahuán sa̱mpi̱ ca̱najla̱ xtachihuí̱n tu̱ ma̱lacnu̱nín; pus luhua xli̱ca̱na̱ pi̱ chuná̱ nakantaxtuy hua̱ntu̱ ma̱catzi̱ni̱ni̱tán Quimpu̱chinacán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A̱li̱sta̱lh María na̱ tzúculh chihui̱nán, chuná̱ huá̱: “Xli̱pacs quili̱stacna̱ cli̱ma̱xqui̱y pa̱xcatcatzí̱nit Dios; ");
INSERT INTO tosNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","chi̱nchu̱ quinacú̱ luhua li̱pa̱xuhuay xpa̱lacata Dios hua̱nti̱ Quima̱akapu̱taxti̱ná. ");
INSERT INTO tosNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Sa̱mpi̱ xlá̱ quiucxilhlacachini̱t quit ma̱squi luhua li̱lakaputza̱ quit c-quilatáma̱t, sa̱mpi̱ cacatzi, chú̱ hasta naán quilhtamacú̱, xli̱pacs tachixcuhuí̱tat naquili̱chihui̱nanko̱y la̱ntla̱ Dios xli̱ca̱na̱ quisiculana̱tlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sa̱mpi̱ Dios hua̱nti̱ tlanca xlacatzúcut lactlanca li̱ca̱cni tascújut tlahuani̱t c-quilatáma̱t. ¡Luhua xli̱ca̱na̱ pi̱ xma̱nhuá̱ tla̱n catzi̱y xtapuhuá̱n! ");
INSERT INTO tosNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ankalhí̱n nalakalhamanko̱y hua̱nti̱ luhua xli̱ca̱na̱ aksti̱tum le̱mputunko̱y xlatama̱tcán c-xlacatí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ma̱siyuni̱t la̱ntla̱ tlanca̱ xlacatzúcut acxni̱ makatlajako̱lh, chu̱ ma̱actzuhui̱ko̱lh hua̱nti̱ lactlanca, chu̱ lactali̱pa̱hu xli̱taxtuputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Na̱ chuná̱ ma̱paksi̱naní̱n hua̱nti̱ xacstucán luhua lactali̱pa̱hu makcatzi̱ko̱cán, na̱ ma̱actzuhui̱ko̱lh, chu̱ huata hua̱nti̱ ni̱tú̱ xli̱tasiyuko̱y, chu̱ ni̱ tlanca̱ xcatzi̱ko̱y, huata huá̱ chú̱ luhua lactali̱pa̱hu tlahuako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hua̱nti̱ lakli̱ma̱xkaní̱n xtzincsni̱ma̱kó̱, xlá̱ ma̱xqui̱ko̱lh hua̱ntu̱ xlacán xmaclacasquima̱kó̱, chu̱ hua̱ lacricujni, maklhti̱ko̱lh hua̱ntu̱ xkalhi̱ko̱y, chu̱ caj macachuná̱ ma̱lakacha̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Makta̱yako̱lh xcamán xala c-Israel hua̱nti̱ xlacsacko̱ni̱t nascujniko̱y, chu̱ niucxni̱ chunatá̱ makaxtakko̱lh, huata juerza lakalhamanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Sa̱mpi̱ chuná̱ li̱ta̱yaniko̱ni̱t xamaka̱n quintla̱tcan Abraham, chu̱ xli̱pacs a̱makapitzi̱n quilhtzúcut. Tima̱lacnu̱niko̱lh pi̱ naucxilhlacacha̱nko̱y hua̱nti̱ xquilhtzucut Abraham ti̱ a̱li̱sta̱lh nalacachinko̱y caxani̱li̱huayaj xtihua̱.” ");
INSERT INTO tosNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pus ma̱x pala aktutu papá̱ ta̱tamakaxtakchá̱ xta̱puxnimat Elisabet, chu̱ a̱li̱sta̱lh María taspitpá̱ c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ni̱ li̱maka̱s quilhtamacú̱ takátzi̱lh acxni̱ Elisabet nata̱tatlay, chu̱ ma̱lakatuncúhui̱lh actzu̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xli̱pacs hua̱nti̱ xli̱nata̱lán, chu̱ hua̱nti̱ xta̱lacatzuní̱n, acxni̱ catzi̱ko̱lh la̱ntla̱ Quimpu̱chinacán xlakalhamani̱t, chu̱ xma̱xqui̱ni̱t cha̱tum cskata, xlacán qui̱lakapaxia̱lhnanko̱lh, chu̱ acxtum ta̱paxuhuako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cha̱nchu̱ li̱mixtujún tili̱minca̱ skata c-xpu̱kalhtahuakacan judíos tu̱ xuí̱ antá̱ laqui̱mpi̱ circuncidar natlahuacán, usu nachucunicán actzu̱ xtiyatli̱hua̱ la̱ntla̱ xli̱smani̱ko̱ni̱t judíos xtlahuako̱y xli̱pacs cskatacán lakkahuasán. Na̱ acxni̱ xma̱xqui̱putuncán xtucuhuiní̱ skata; pus Zacarías xli̱ma̱pacuhui̱putuncán, huachá̱ xtucuhuiní̱ xtla̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Hua̱mpi̱ xtzi̱ chuná̱ huá̱: —Ní̱nta, ni̱ hua̱ xtucuhuiní nakalhi̱y, huata Juan nahuanicán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Cha̱nchu̱ xamigos huaniko̱lh: —¿Tú̱huan? Ni̱tí̱ cha̱tum mili̱nata̱lán pala ti̱ chuná̱ huanicán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pus xtla̱t Zacarías cumu akata̱pa, chu̱ ko̱ko xuani̱t, caj tzúculh macahuaniko̱y acxni̱ xkalhasquima̱kó̱ tú̱ xlá̱ xli̱ma̱pa̱cuhui̱putún actzu̱ kahuasa. ");
INSERT INTO tosNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xlá̱ squilh paktzu̱ tama laqui̱mpi̱ antá̱ natzoknán, chu̱ antá̱ chuná̱ tzóknu̱lh: ‘Tama̱ kahuasa nali̱tapa̱cuhui̱y Juan.’ Cha̱nchu̱ xli̱pacs hua̱nti̱ antá̱ xlaya̱kó̱ luhua lanaj lacahuanko̱lh acxni̱ catzi̱ko̱lh pacs tu̱ xkantaxtuma̱. ");
INSERT INTO tosNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Acxnitiyá̱ yama̱ quilhtamacú̱ cá̱xlalh csi̱maka̱t Zacarías, chu̱ tla̱n chihui̱nampá̱, chu̱ tzúculh ma̱xqui̱y pa̱xcatcatzí̱nit Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xli̱pacs hua̱nti̱ antá̱ lacatzú̱ xuilakó̱, cacs xli̱lacahuanko̱y sa̱mpi̱ ni̱ xakata̱ksko̱y yuma̱ hua̱ntu̱ xkantaxtuma, chu̱ xli̱pacs ti̱ xuilakó̱ ca̱ka̱sti̱ní̱n la̱ntla̱ c-xtachipa Judea xli̱chihui̱nanko̱y la̱ntla̱ xlacachini̱t yama̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Cha̱nchu̱ xli̱pacs hua̱nti̱ xcatzi̱ko̱y la̱ntla̱ qui̱taxtuni̱t xtzucuko̱y lacapa̱stacko̱y, chu̱ chuná̱ xli̱chihui̱nanko̱y: “¿Tú̱ cahuá̱ nali̱taxtuy yuma̱ actzu̱ kahuasa?” Huá̱ chuná̱ xli̱huanko̱y sa̱mpi̱ xli̱ca̱na̱ xtasiyuy la̱ntla̱ Quimpuchinacán csiculana̱tlahuama̱ yama̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santo li̱tatzamako̱lh xtalacapa̱stacni Zacarías hua̱nti̱ xtla̱t yama̱ skata, chu̱ xla̱ tzúculh chuhuinán la̱ntla̱ Espíritu Santo xma̱puhua̱ni̱ma̱, chu̱ chuná̱ huá̱: ");
INSERT INTO tosNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Pa̱xcatcatzí̱nilh Quimpu̱chinacan Dios hua̱nti̱ xma̱n huá̱ li̱pa̱huana̱hu quin xala c-Israel, sa̱mpi̱ chú̱ xlá̱ quinca̱ucxilhlacachini̱tán quin xlakskatá̱n laqui̱mpi̱ naquinca̱lakma̱xtuyá̱n! ");
INSERT INTO tosNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xlá̱ nia̱lh maka̱s aya namacamín cha̱tum luhua tali̱pa̱hu chixcú̱ hua̱nti̱ tla̱n naquinca̱ma̱akapu̱taxti̱yá̱n. Yama̱ chixcú̱ ti̱ namín, xquilhtzúcut nahuán xamaka̱n rey David hua̱nti̱ na̱ scujnini̱t Dios c-xlatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pus hasta la̱ntla̱ta maka̱sa quilhtamacú̱ chuná̱ li̱chihui̱nanko̱ni̱t yama̱ profetas xpa̱lacachihui̱nani̱n Dios hua̱nti̱ xlá̱ tilacsacko̱lh laqui̱mpi̱ naquinca̱huaniyá̱n, ");
INSERT INTO tosNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","pi̱ xli̱ca̱na̱ naquinca̱ma̱laktaxti̱yá̱n c-xmacancán hua̱nti̱ quinca̱ta̱la̱tlahuayá̱n, chu̱ xli̱pacs hua̱nti̱ ni̱ quinca̱ucxilhputunko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Pus chú̱ Dios ma̱kantaxti̱ni̱t hua̱ntu̱ tihua̱ tima̱lácnu̱lh pi̱ juerza nalakalhamanko̱y xalakmaka̱n quinatla̱tnacán, chu̱ ni̱mpala maktum catipa̱tzánka̱lh pi̱ ta̱tlahuako̱ni̱t aktum talacca̱xlán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","Xlá̱ tihuánilh xamaka̱n quintla̱tcan Abraham pi̱ naquinca̱lakma̱xtuyá̱n qui̱n xlacatzúcut c-xmacancán hua̱nti̱ quinta̱la̱tlahuanacá̱n, laqui̱mpi̱ chuná̱ tla̱n xma̱n huá̱ nascujnaniya̱hu, chu̱ ni̱tí̱ catilacapuhuanihu. ");
INSERT INTO tosNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chu̱ na̱ chuná̱ laqui̱mpi̱ xa̱li̱ankalhí̱n aksti̱tum nali̱latama̱ya̱hu xli̱ma̱paksí̱n, chu̱ chuná̱ tla̱n nascujnaniya̱hu xma̱n hua̱ Quimpu̱chinacan Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chi̱nchu̱ huix koxuta actzu̱ kahuasa, nali̱taxtuya̱ tlanca xprofeta, usu xpa̱lacachunui̱na Dios ti̱ tlanca̱ xlacatzúcut; sa̱mpi̱ huix pu̱laniti̱lhaya nahuán yama̱ a̱cha̱tum Quimpu̱chinacán ti̱ namín, laqui̱mpi̱ huix naca̱xtlahuaniya̱ xtiji. ");
INSERT INTO tosNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Chu̱ na̱ nama̱catzi̱ni̱ko̱ya̱ xcaman Dios la̱ntla̱ xlá̱ nama̱tzanka̱naniko̱y xtala̱kalhi̱ncán, laqui̱mpi̱ chuná̱ tla̱n nama̱akapu̱taxti̱ko̱y xli̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sa̱mpi̱ xli̱ca̱na̱ Dios quinca̱pa̱xqui̱yá̱n, chu̱ quinca̱lakalhamaná̱n, pus yama̱ akapu̱táxtut tu̱ namacamina̱chá̱, li̱taxtuy xta̱chuná̱ xmakaxkaka̱nat chichiní̱ hua̱ntu̱ acxni̱ natzucuy makaxkaka̱nán nama̱tzuqui̱y aktum xasa̱sti quilhtamacú̱ c-quilatama̱tcán; ");
INSERT INTO tosNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chu̱ xli̱pacs hua̱nti̱ c-xaca̱paklhtu̱tá̱ lama̱kó̱, sa̱mpi̱ pe̱cuaniko̱y tu̱ naakspulako̱y acxni̱ nani̱ko̱y. Xlacán tla̱n chú̱ natalacatzuhui̱ko̱y anta̱ni̱ huí̱ yuma̱ xkakánat, chu̱ chuná̱ xlá̱ nama̱quilhanu̱ko̱y xtantu̱ncán c-xatiji tapa̱xuhuá̱n, chu̱ tatancsni.” ");
INSERT INTO tosNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Cha̱nchu̱ álh quilhtamacú̱, chu̱ yama̱ actzu̱ kahuasa Juan; lacapala̱ xlacacatzi̱ma̱, cstacma̱ xtiyatli̱hua, chu̱ na̱ chuná̱ xtalacapa̱stacni. A̱li̱sta̱lh acxni̱ cstacni̱ttá xlá̱ álh latama̱y c-desierto anta̱ni̱ ni̱tú̱ staca, chu̱ ni̱tí̱ lama̱ca̱. Chu̱ acxni̱ lákcha̱lh quilhtamacú̱ xlá̱ tzúculh siyuj ma̱lakapasni̱ko̱y xli̱nata̱chiqui̱n israelitas xasa̱sti xtama̱catzi̱ni̱n Dios tu̱ xli̱miniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na̱ acxnitiyá̱ yama̱ quilhtamacú̱ acxni̱ xuí̱ cha̱tum gobierno c-Roma xuanicán Augusto, xlá̱ luhua ma̱paksí̱nalh pi̱ nalay aktum censo, usu xtapu̱tlakan tachixcuhuí̱tat, chu̱ natatzoktanu̱ko̱y xli̱pacs tachixcuhuí̱tat hua̱nti̱ xlá̱ xma̱paksi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hua̱ yuma̱ xatatzoknu̱n censo, huacu xapu̱lana̱ tlahuacani̱t acxni̱ Cirenio gobernador xuani̱t c-Siria. ");
INSERT INTO tosNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Cha̱tunu chixcuhuí̱n xli̱anatcán xuani̱t c-xchuchutsipijcán anta̱ni̱ xtapaksi̱ko̱y laqui̱mpi̱ antá̱ natatzoktanu̱ko̱y c-censo. ");
INSERT INTO tosNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pus huá̱ xpalacata José táca̱xli̱ c-Nazaret, yuma̱ ca̱chiquí̱n xtapaksi̱y c-Galilea, chu̱ álh c-aktum actzu̱ ca̱chiquí̱n xuanicán Belén xmunicipio Judea, anta̱ni̱ na̱ xlacachini̱t xamaka̱n rey David, sa̱mpi̱ tama̱ José xquilhtzúcut xuani̱t xamaka̱n rey David, pus na̱ antá̱ xtapaksi̱y c-Belén. ");
INSERT INTO tosNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José lacxtum tá̱alh María, hua̱ yama̱ tzuma̱t hua̱nti̱ aya xli̱kalhti̱ni̱t pi̱ nata̱tapu̱chuhuay, hua̱mpi̱ chú̱ xlá̱ nia̱lh xacstu xlama̱, sa̱mpi̱ xkalhkalhi̱ti̱ma̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chu̱ luhua acxni̱ antá̱ xlama̱kó̱ c-Belén, lákcha̱lh quilhtamacú̱ la̱ntla̱ María xli̱ta̱tátlat xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cumu ni̱ xta̱ksko̱ni̱t xaní̱ nalaktuncuhuiko̱y c-mesón, huata antá̱ ma̱lakatuncúhui̱lh yama̱ actzu̱ xkahuasa̱ anta̱ni̱ xma̱nu̱ko̱cán takalhí̱n, chu̱ li̱pu̱máksuitli̱ lháka̱t, chu̱ antá̱ má̱mi̱lh c-xpu̱hua̱y cahua̱yu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na̱ antá̱ lacatzú̱ c-Belén, ca̱lakuá̱n xlaktuncuhuima̱kó̱ makapitzi̱n xmaktakalhnacan borrego ca̱tuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Caj xamaktum titasiyuniko̱lh cha̱tum xángel Quimpu̱chinacán; chu̱ xli̱ca̱tlanca̱ anta̱ni̱ xuilakó̱ tasíyulh xmakaxkaka̱nat Quintla̱tican Dios. Xlacán li̱pe̱cua̱ tipe̱cuanko̱lh, ");
INSERT INTO tosNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","hua̱mpi̱ yama̱ ángel chuná̱ huaniko̱lh: “Ni̱ cape̱cuántit sa̱mpi̱ cmimá̱n ca̱huaniyá̱n aktum tachihuí̱n hua̱ntu̱ luhua nali̱pa̱xuhuayá̱tit huixín, chu̱ xli̱pacs li̱macxtum tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pus la̱nchiyú̱ c-Belén, anta̱ni̱ xchuchutsipi̱ xuani̱t yama̱ xamaka̱n rey David, lacáchilh Cristo hua̱nti̱ luhua xli̱ca̱na̱ Mimpu̱chinacán hua̱nti̱ naca̱ma̱akapu̱taxti̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chu̱ laqui̱mpi̱ huixín luhua lacatancs naca̱najlayá̱tit hua̱ntu̱ cca̱huanimá̱n antá̱ nama̱noklhuyá̱tit actzu̱ skata, ma̱mi̱cani̱t nahuán c-xpu̱hua̱y cahua̱yu̱, chu̱ li̱maksuitcaní̱t lháka̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Caj xalán lhu̱hua̱ makapitzi̱n li̱tum ángeles xala c-akapú̱n minko̱lh anta̱ni̱ xlacán xuilakó̱, chu̱ luhua li̱pa̱xuhu tzúculh quilhtli̱ko̱y, xma̱xqui̱ko̱y ca̱cni̱ Dios, chuná̱ xquilhuama̱kó̱: ");
INSERT INTO tosNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Li̱pa̱xuhu cama̱xqui̱ko̱lh ca̱cni̱ Dios xli̱pacs ángeles ti̱ huilako̱chá̱ ta̱lhmá̱n c-akapú̱n! Na̱ chuná̱ u̱nú̱ ca̱tuxá̱huat caánalh tapa̱xuhuá̱n c-xlaksti̱pa̱ncan tachixcuhuí̱tat hua̱nti̱ pa̱xcatcatzi̱niko̱y xtalakalhamá̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Acxni̱ anko̱lh ángeles c-akapú̱n, yama̱ xmaktakalhnaní̱n borrego chuná̱ tzúculh la̱huaniko̱y: —Caáhu c-Belén, caáhu ucxilha̱hu tú̱ kantaxtuni̱t hua̱ntu̱ quinca̱qui̱ma̱catzi̱ni̱chín Quimpu̱chinacán. ");
INSERT INTO tosNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Luhua chí̱ lacapala̱ timinko̱lh, chu̱ caj puntzú̱ cha̱nko̱lh, chu̱ xli̱ca̱na̱ ucxilhko̱lh María, chu̱ José, chu̱ actzu̱ skata pi̱ xli̱ca̱na̱ antá̱ xmá̱ c-xpu̱hua̱y cahua̱yu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Acxni̱ xlacán ucxilhko̱lh pi̱ xli̱ca̱na̱, pus xlacán tzúculh li̱chihui̱nanko̱y hua̱ntu̱ ángeles xuaniko̱ni̱t la̱ntla̱ xlacachini̱t yama̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Cha̱nchu̱ xli̱pacscán hua̱nti̱ tikaxmatko̱lh, lanaj tili̱lacahuanko̱lh tu̱ xlacán xquilhuama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Na̱ chuná̱ María luhua pacs xlacapa̱stacma̱ hua̱ntu̱ xkantaxtuma̱, chu̱ pacs xma̱qui̱ma̱ c-xnacú̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A̱li̱sta̱lh yama̱ xma̱putxuani̱nani̱n borrego taspitko̱lh anta̱ni̱ xlacán xminko̱ni̱tanchá̱; xca̱cni̱nanima̱kó̱, chu̱ na̱ chuná̱ xpa̱xcatcatzi̱nima̱kó̱ caj xpa̱lacata̱ pi̱ xli̱ca̱na̱ pacs chuná̱ xqui̱taxtuni̱t hua̱ntu̱ xuaniko̱ni̱t ángeles. ");
INSERT INTO tosNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Li̱mixtujún áncaj circuncidar tlahuacán, usu chucunicán actzu̱ xtiyatli̱hua̱ yama̱ actzu̱ kahuasa, chu̱ acxnicú̱ li̱ma̱pa̱cuhui̱ca̱ xtucuhuiní Jesús, sa̱mpi̱ ángel chuná̱ xuanini̱t natlahuay María acxni̱ xlá̱ cajcu xacstu xlama, tzuma̱tcú̱ xuanit. ");
INSERT INTO tosNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","A̱li̱sta̱lh acxni̱ takátzi̱lh quilhtamacú̱ la̱ntla̱ xuí̱ xli̱ma̱paksi̱n Moisés pi̱ acxni̱ nalacachín cha̱tum skata, cale̱nica̱ Dios aktum li̱ca̱xtlahuá̱n laqui̱mpi̱ chuná̱ nachaka̱makán xtzi̱ hua̱ntu̱ xli̱xcajua̱lani̱t u̱nú̱ xala ca̱tuxá̱huat. La̱qui̱mpi̱ na̱ nama̱kantaxti̱ko̱y yuma̱ li̱ma̱paksí̱n, pus na̱ chuná̱ tlahuako̱lh José, chu̱ María, anko̱lh c-xaca̱chiqui̱n Jerusalén, chu̱ na̱ le̱nko̱lh yama̱ actzu̱ kahuasa laqui̱mpi̱ namacama̱xqui̱cán Quimpuchinacán ctlanca̱ templo antá. ");
INSERT INTO tosNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Hua̱ chuná̱ li̱tlahuako̱lh sa̱mpi̱ c-xli̱ma̱paksi̱n Dios chuná̱ tatzokni̱t: “Yama̱ kahuasa̱ hua̱nti̱ luhua pu̱lh nalacachín, xlá̱ Dios nali̱pu̱lhca̱cán.” ");
INSERT INTO tosNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pus ni̱ luhua lhu̱hua̱ tu̱ xlacán le̱nko̱lh, caj xma̱n hua̱ actzú̱ hua̱ntu̱ nali̱ca̱xtlahua̱nanko̱y chuná̱ la̱ntla̱ talhca̱ni̱t c-xli̱ma̱paksi̱n Dios nale̱nicán, pala tantuy ca̱na̱spu̱n, usuchí̱ tantuy paloma tu̱ namakni̱ko̱y c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na̱ acxni̱ yama̱ quilhtamacú̱ xuí̱ c-Jerusalén cha̱tum ko̱lutzí̱n xuanicán Simeón. Yama̱ chixcú luhua tla̱n xcatzi̱y, chu̱ luhua aksti̱tum xlama̱, chu̱ xma̱n hua̱ Dios xli̱pa̱huán, xa̱huachí̱ xlá̱ na̱ xkalhkalhi̱ma̱ a̱ma̱ quilhtamacú̱ la̱ntla̱ Dios namacamín ti̱ nalakma̱xtunán c-xtíyat Israel. Espíritu Santo xuí̱ c-xlatáma̱t Simeón, ");
INSERT INTO tosNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","chu̱ hua̱ xlá̱ xma̱catzi̱ni̱ni̱t pi̱ xlá̱ ni̱ catíni̱lh hasta acxni̱ luhua ma̱n xlakastapu̱ nali̱ucxilha̱ yama̱ Cristo hua̱nti̱ Dios namacamín laqui̱mpi̱ nalakma̱xtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Maktum quilhtamacú̱ Espíritu Santo ma̱puhuá̱ni̱lh pi̱ caalh c-tlanca templo tu̱ xuí̱ c-Jerusalén, chu̱ acxnitiyá̱ yama̱ quilhtamacú̱ acxni̱ actzu̱ kahuasa Jesús xli̱mincani̱t c-Jerusalén laqui̱mpi̱ na̱ chuná̱ natlahuaniko̱y hua̱ntu̱ Dios xlacasquín hua̱ la̱ntla̱ huan xli̱ma̱paksi̱n Moisés. ");
INSERT INTO tosNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Acxni̱ Simeón úcxilhli̱ yama̱ actzu̱ kahuasa, cha̱xli, chu̱ tzúculh ma̱xqui̱y pa̱xcatzí̱nit Dios, chuná̱ xquilhuama̱: ");
INSERT INTO tosNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Quintla̱tican Dios, chú̱ aya tla̱n li̱pa̱xuhu naquili̱makaxtaka̱ ma̱squi cacni̱lh sa̱mpi̱ huix aya ma̱kantaxti̱ni̱ta̱ chú̱ hua̱ntu̱ quintima̱lacnu̱ni̱ quit li̱lakaputza miscujni. ");
INSERT INTO tosNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sa̱mpi̱ quit luhua xli̱ca̱na̱ ma̱n quilakastapu cli̱ucxilhma̱ lakma̱xtuná̱ hua̱nti̱ huix macatani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Uma̱ actzu̱ kahuasa̱ ti̱ nama̱laktaxti̱ko̱y xli̱pacs cani̱hua̱ xalaní̱n hua̱nti̱ nali̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Na̱ hua̱ yuma̱ kahuasa ti̱ nale̱niko̱y yama̱ lakma̱xtuna mixkakánat xli̱pacs akmakat chixcuhuí̱n hua̱nti̱ ni̱ judíos, chu̱ na̱ nali̱ma̱lacahua̱ni̱ko̱y tlanca minca̱cni̱ milakskata̱n li̱Israel.” ");
INSERT INTO tosNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José, chu̱ María luhua cacs xkaxmatma̱kó̱ hua̱ntu̱ Simeón xquilhuama̱ xpa̱lacata yama̱ skata. ");
INSERT INTO tosNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Cha̱nchu̱ Simeón, tisiculuna̱tlahuako̱lh; chu̱ a̱li̱sta̱lh chuná̱ huánilh María xtzi yama̱ skata: —María, yuma̱ actzu̱ minkahuasa, huá̱ li̱pu̱lhca̱cani̱t pi̱ lhu̱hua̱ hua̱nti̱ u̱nú̱ xala c-Israel nalakmakanko̱y, chu̱ chuná̱ nali̱laktzanka̱ko̱y; hua̱mpi̱ na̱ chuná li̱tum lhu̱hua̱ hua̱nti̱ nali̱pa̱huanko̱y, chu̱ chuná̱ xlacán nalakma̱xtuko̱y xli̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chuná̱ nali̱tasiyuko̱y cha̱tunu a̱cha̱tunu̱ chixcuhuí̱n la̱ntla̱ lacapa̱stacko̱y c-xnacu̱cán; hua̱mpi̱ hua̱ chú̱ tu̱ huix mimpa̱lacata, luhua tlanca tali̱puhuá̱n nahuán sa̱mpi̱ chuná̱ naqui̱taxtuniyá̱n xta̱chuná̱ la̱ntla̱ aktum cuchilu̱ hua̱ntu̱ nama̱laktaxti̱ko̱y mili̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Na̱ antá̱ xlaya̱ c-tlanca templo cha̱tum pusca̱t hua̱nti̱ na̱ luhua xakata̱ksa̱ xtalacapa̱stacni Dios, yuma̱ pusca̱t xuanicán Ana; xtla̱t xuanicán Fanuel, yuma̱ chixcú̱ antá̱ xtapaksi̱y c-aktum ca̱chiquí̱n hua̱ntu̱ xma̱quilhtzuqui̱ni̱t yama̱ xamaka̱n ko̱lutzí̱n xuanicán Aser. Ana, luhua tzicaná xuani̱t; acxni̱ luhua tzuma̱tcú xuani̱t xlá̱ titapu̱chúhualh, luhua tla̱n aktujun ca̱ta̱ ta̱latáma̱lh xchixcú, hua̱mpi̱ xlá̱ ni̱lh, chu̱ chunatá̱ ca̱ta caj xacstu xlama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chu̱ aya xle̱ma̱ ta̱ti̱puxamata̱ti ca̱ta̱ la̱ntla̱ xni̱makancani̱t. Hua̱ u̱ma̱ tzicán niucxni̱ xtapa̱nu̱y c-tlanca templo, tantacú̱ tantascaca̱ antá̱ xlatanu̱ma̱ la̱ntla̱ xlakataquilhpu̱tanán, chu̱ la̱ntla̱ ni̱ xli̱maka̱sna̱ namakalhkajnán su xkalhxtaknán, chu̱ natlahuay xoración. ");
INSERT INTO tosNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na̱ acxnitiyá̱ chilh Ana anta̱ni̱ xlacán xlaya̱kó̱, chu̱ na̱ tzúculh pa̱xcatcatzi̱niy Dios caj xpa̱lacata yama̱ skata. A̱li̱sta̱lh, cani̱huá̱ anta̱ni̱ xma̱noklhuko̱y hua̱nti̱ na̱ xkalhkalhi̱ma̱kó̱ la̱ntla̱ Dios nalakma̱xtuko̱y xcamán xala c-Jerusalén, hua tuncán xli̱xakatli̱ko̱y yama̱ actzu̱ skata Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Cha̱nchu̱ a̱li̱sta̱lh pi̱ tima̱kantaxti̱ko̱lh xli̱pacs yama̱ hua̱ntu̱ xlacán xli̱smani̱ko̱ni̱t la̱ntla̱ xtalhca̱ni̱t c-xli̱ma̱paksi̱n Moisés, xlacán lacapala̱ taspitpalako̱lh c-Galilea anta̱ni̱ xuí̱ xchuchutsipi Nazaret. ");
INSERT INTO tosNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cha̱nchu̱ actzu̱ kahuasa, lacapala̱ xlacacatzi̱ma̱, chu̱ xtatlihuaklhma̱, xa̱hua̱ xkalhi̱ma̱ li̱akskálalh, sa̱mpi̱ Dios csiculana̱tlahuama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Xtla̱t Jesús, xa̱hua̱ xtzi luhua chuná̱ xli̱smani̱ko̱ni̱t xanko̱y ca̱ta ca̱ta c-Jerusalén acxni̱ xtaxtuy pa̱scua̱ xla ta̱kspuntza̱lí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pus acxni̱ Jesús ma̱kátzi̱lh xakcu̱tuy ca̱ta, pu̱tum anko̱lh antá̱ c-pascua̱ la̱ntla̱ xli̱smani̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Acxni̱ chu̱ tikátsputli̱ pa̱scua̱, xlacán lacapala̱ tiquilhta̱yako̱chá̱ tiji̱ laqui̱mpi̱ nataspitko̱y, hua̱mpi̱ Jesús tamakaxtakchá̱ c-Jerusalén, chu̱ María ni̱ xcatzi̱y, ni̱ pala josé. ");
INSERT INTO tosNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pus pi̱ xli̱pacs li̱lhu̱hua̱ xtaspitma̱kó̱ c-xchuchutsipijcán, xlacán xpuhuanko̱y pi̱ ma̱x antá̱ xmakmima̱ Jesús c-xlaksti̱pa̱ncán, pus tantacú̱ li̱tla̱huanko̱lh hua̱mpi̱ ca̱ko̱tanú̱n acxni̱ putzako̱lh, chu̱ kalhasquinko̱lh hua̱nti̱ xli̱nata̱lán, chu̱ hua̱nti xta̱la̱lakapasnicán, ");
INSERT INTO tosNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ni̱ pala cha̱tum ti̱ xkalhtasiyúnilh. Cha̱nchu̱ pi̱ ni̱ xta̱ksko̱y, huata lacapala̱ taspitpalako̱lh c-Jerusalén laqui̱mpi̱ antá̱ naputzako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xli̱aktutu quilhtamacú̱ la̱ xputzama̱kó̱ acxni̱ qui̱ta̱ksko̱lh, antá̱ xlá̱ xlahui̱ c-tlanca templo xta̱kalhchihui̱nama̱kó̱ laktzokqui̱naní̱n, xlá̱ luhua cacs xkaxkmatniko̱y, chu̱ xkalhasquinko̱y hua̱ntu̱ xlá xcatzi̱putún. ");
INSERT INTO tosNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Cha̱nchu̱ xli̱pacs hua̱nti̱ xkaxmatnima̱kó̱ xtachihuí̱n, luhua xli̱ca̱na̱ lhpipak xli̱lacahuanko̱y xtastácat sa̱mpi̱ xli̱ca̱na̱ xkalhi̱y tlanca xli̱skálalh, sa̱mpi̱ pacs hua̱ntu̱ xkalhasquincán luhua tancs xkalhti̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Acxni̱ chu̱ lakcha̱nko̱lh xtzi Jesús, chu̱ xtla̱t, luhua lanaj tilacahuanko̱lh caj xpa̱lacata hua̱ntu̱ xucxilhma̱kó̱, hua̱mpi̱ xtzí chuná̱ huánilh: —Ta̱ta̱, ¿tú̱huan chuná̱ na̱má̱ quinca̱tlahuani̱ta? Hua mintla̱t, chu̱ quit cca̱putzatla̱huaná̱n sa̱mpi̱ cca̱makacuaná̱n pala tú̱ lánilh cpuhuama̱hu quin. ");
INSERT INTO tosNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —Hua̱mpi̱ ¿tú̱huan chú̱ xquili̱putzapá̱tit? ¿Lá̱ntla̱ pi̱ ni̱ catzi̱yá̱tit pi̱ quit antá̱ u̱nú̱ c-xtemplo quintla̱t quimini̱niy nactahuilay? ");
INSERT INTO tosNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Hua̱mpi̱ huá̱ chú̱ xlacán, ni̱ tiakata̱ksko̱lh hua̱ntu̱ xlá̱ kalhti̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Xlá̱ ni̱ aklhu̱huá̱tnalh, chu̱ lacapala̱ ta̱taspitko̱lh, chu̱ acxtumá̱ ta̱minko̱lh c-Nazaret. Jesús ankalhí̱n xlakachixcuhui̱ko̱y xtla̱t, chu̱ xtzi, chu̱ xli̱pacs hua̱ntu̱ xli̱ma̱paksi̱ca̱ xlá̱ pacs xkalhakaxmatko̱y. Hua̱mpi̱ María pacs xma̱qui̱ma̱ c-xnacú̱ hua̱ntu̱ xakspulama̱ c-xlatama̱t yama̱ actzu̱ kahuasa. ");
INSERT INTO tosNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús la̱ntla̱ cstacma̱, na̱ xkalhi̱ma̱ tla̱n talacapa̱stacni, chu̱ xmakapa̱xuhuay Dios c-xlatáma̱t, chu̱ na̱ chuná̱ xli̱pacs hua̱nti̱ xlakapasko̱y luhua xpa̱xqui̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Acxni̱ aya akcu̱quitzis ca̱ta̱ xle̱ma̱ xli̱ma̱paksi̱ná̱ Tiberio c-Roma, chu̱ acxni̱ ma̱paksi̱ná xli̱hui̱ Poncio Pilato c-Judea, chi̱nchu̱ Herodes ma̱paksi̱ná xuani̱t c-Galilea, chu̱ xta̱la Felipe, na̱ ma̱paksi̱ná xuani̱t nac Iturea, chu̱ c-xtachipa Traconite; chu̱ Lisanías, na̱ ma̱paksi̱ná xuani̱t c-xatiyat Abilinia. ");
INSERT INTO tosNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Na̱ acxnitiya̱ yama̱ quilhtamacú̱ acxni̱ Anás, chu̱ Caifás lacxtum xanapuxcun pa̱lijni xuanko̱ni̱t c-Jerusalén, na̱ acxnitiyá̱ ni̱ maka̱s quilhtamacú̱ Dios ma̱catzí̱ni̱lh hua̱ntu̱ xli̱tláhuat Juan xkahuasa Zacarías, acxni̱ xlá̱ antá̱ xlapu̱laya̱chá̱ c-desierto anta̱ni̱ ni̱tí̱ lama̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Chu̱ chuná̱ xlá̱ Juan ca̱lakatza̱lako̱lh lactzu̱ ca̱chiquí̱n hua̱ntu̱ xuilakó̱ c-xquilhtu̱n kalhtu̱choko̱ huanicán Jordán, chu̱ xlá̱ xli̱akchihui̱nanima̱kó̱ chixcuhuí̱n, chu̱ xuanima̱kó̱ pi̱ calakpali̱ko̱lh xali̱xcajnit xlatama̱tcán, chu̱ xlá̱ naakmunuko̱y laqui̱mpi̱ chuná̱ tla̱n Dios nama̱tzanka̱naniko̱y xtala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Hua̱ chuná̱ li̱kantáxtulh hua̱ntu̱ xtzokni̱t c-xlibro profeta Isaías acxni̱ chuná̱ huá̱: “Takaxmata̱ xtachihuí̱n cha̱tum ti̱ ca̱tasama̱ c-desierto, chu̱ chuná̱ quilhuama̱: ‘Caca̱xtlahuanítit tiji̱ anta̱ni̱ luhua tla̱n nalacmín Quimpu̱chinacán; cama̱xtunítit kantum tiji hua̱ntu̱ tzajua. ");
INSERT INTO tosNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sa̱mpi̱ xli̱pacs anta̱ni̱ tapu̱lhma̱ni̱t, pacs nataca̱xtumi̱y, chu̱ na̱ chuná̱ anta̱ni̱ talhkahuini̱t tiji, pacs nama̱tzajuani̱yá̱tit chu̱ na̱ chuná̱ anta̱ni̱ ni̱ ca̱xtum, pacs nama̱ca̱xtupi̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na̱ chuná̱ xli̱ca̱tlanca̱ ca̱tuxá̱huat naucxilhko̱y ma̱akapu̱taxti̱ná̱ ti̱ Dios macamini̱t.’” ");
INSERT INTO tosNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Luhua lhu̱hua̱ xlakminko̱y Juan laqui̱mpi̱ xlá̱ naakmunuko̱y, chu̱ makapitzí̱n chuná̱ xlá̱ xuaniko̱y: “¡Huixín luhua xta̱chuná̱ lapá̱tit la̱ lako̱y yama̱ lacli̱xcajnit xcanani̱n lu̱hua̱ acxni̱ tzucuko̱y tza̱laniko̱y lhcúya̱t acxni̱ ca̱xkoyuma̱ca̱! ¿Tí̱ chú̱ ca̱ma̱catzi̱ní̱n pi̱ caj xman nata̱kmunuyá̱tit aya tla̱n naakapu̱taxtuniyá̱tit yama̱ tlanca tapa̱tí̱n hua̱ntu̱ Dios naca̱macaminiyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Huata tu̱ tla̱n nahuán pi̱ aksti̱tum calatapá̱tit laqui̱mpi̱ chuná̱ stalanca nali̱tasiyuyá̱tit pi̱ xli̱ca̱na̱ aya lakpali̱ni̱tántit ni̱tla̱n mintalacapa̱stacnicán. Sa̱mpi̱ lapi̱ huixín puhuaná̱tit pi̱ caj xpa̱lacata xquilhtzucut Abraham huixín, ni̱ lay tú̱ catica̱akspulán, pus nia̱lh chuná̱ capuhuántit. Pus lapi̱ huixín hua̱ li̱pa̱huaná̱tit, quit lacatancs cca̱huaniyá̱n pi̱ yuma̱ chíhuix Dios tla̱n nali̱ma̱xtuko̱y xquilhtzucut Abraham lapi̱ lacasquín. ");
INSERT INTO tosNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios ca̱li̱pu̱lhca̱yá̱n xta̱chuná̱ la̱ntla̱ akatum quihui, xlá aya cha̱catzi̱ya̱ chipani̱t xhacha laqui̱mpi̱ natanca̱mi̱ko̱y yama̱ quihui hua̱ntu̱ nia̱lh lacuán. Sa̱mpi̱ akatum quihui̱ hua̱ntu̱ ni̱ lacuán tahuacay xtahuácat tanca̱mi̱cán, chu̱ ma̱pu̱cán c-lhcúya̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Acxni̱ kaxmatko̱lh yuma̱ tachihuí̱n lhu̱hua̱ hua̱nti̱ chuná̱ kalhasquinko̱lh: —¿Tú̱ chú̱ chá̱ quili̱tlahuatcán? ");
INSERT INTO tosNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Cha̱nchu̱ xlá̱ kalhti̱ko̱lh: —Hua̱nti̱ kalhi̱y mactuy xtamaknu, catá̱qui̱lh mactum hua̱nti̱ ni̱tú̱ kalhi̱y ni̱ pala mactum; chu̱ hua̱nti̱ akata̱xtunima̱ hua̱ntu̱ huama̱, pus catá̱hualh hua̱nti̱ ni̱tú̱ kalhi̱y hua̱ntu̱ nahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Chu̱ na̱ chuná̱ makapitzi̱n chixcuhuí̱n hua̱nti̱ xma̱ta̱ji̱nanko̱y impuestos na̱ minko̱lh laqui̱mpi̱ na̱ nata̱kmunuko̱y, xlacán chuná̱ kalhasquinko̱lh Juan: —Ma̱kalhtahuaka̱ná, ¿tú̱ quin quili̱tlahuatcán? ");
INSERT INTO tosNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Cha̱nchu̱ xlá̱ huaniko̱lh: —Ni̱ luhua tapala̱xlá̱ cama̱ta̱ji̱nántit, chu̱ ni̱ calacatza̱látit hua̱ntu̱ tali̱ma̱paksi̱ni̱tántit. ");
INSERT INTO tosNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Makapitzi̱n tropa̱, xlacán na̱ chuná̱ kalhasquinko̱lh: —Chi̱nchu̱ quin, ¿tú̱ quili̱tlahuatcán? Juan chuná̱ kalhti̱ko̱lh: —Lapi̱ tú̱ kalhi̱y cha̱tum chixcú ni̱ aklakuá̱ timaklhti̱yá̱tit, xa̱huachí̱ ni̱ camaka̱klhátit, na̱ chuna li̱tum ni̱tú̱ cali̱ya̱huátit ta̱ksaní̱n laqui̱mpi̱ chuná̱ tla̱n nama̱lacapu̱yá̱tit, na̱ chuná̱ mintaskahucán, xatlá̱n cali̱pa̱xcatcatzi̱tittá̱ hua̱ntu̱ ca̱ma̱xqui̱caná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lhu̱hua̱ ti̱ xlakminko̱y xkalhkalhi̱ma̱kó̱ yama̱ quilhtamacú̱ acxni̱ namín Cristo hua̱nti̱ nalakma̱xtuko̱y, xlacán xtzucuni̱ttá̱ puhuanko̱y xpa̱lacata Juan Bautista, ¿chá̱ pala chú̱ huá̱ Cristo ti̱ naquinca̱lakma̱xtuyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan chuná̱ huaniko̱lh yama̱ chixcuhuí̱n: “Xli̱ca̱na̱ xlá̱ pi̱ quit caj chúchut cca̱li̱akmunumá̱n, hua̱mpi̱ nia̱lh maka̱s quilhtamacú̱ mima̱ cha̱tum chixcú̱ hua̱nti̱ naca̱li̱akmunuyá̱n xli̱tlihuaka Espíritu Santo, chu̱ lhcúya̱t. Xlá̱ xali̱huacá̱ kalhi̱y xlacatzúcut ni̱ xahua̱ quit, ni̱mpala tzinú̱ quimini̱niy nacli̱taxtuy hasta li̱lakaputza xtasa̱cua nacuán laqui̱mpi̱ nacxcutniy xatasij xtatuhuanu. ");
INSERT INTO tosNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xlá̱ aya li̱huana̱ lacapa̱stacni̱t la̱ntla̱ nama̱pa̱pitziko̱y tachixcuhuí̱tat, chuná̱ xlá̱ natlahuay xta̱chuná̱ la̱ntla̱ yama̱ hua̱nti̱ cha̱catzi̱ya̱ chipani̱t xli̱lacsunucan xtrigo laqui̱mpi̱ namakaniy xapalhma, chu̱ acxni̱ aya lacsunuko̱ni̱t nahuán, chú̱ yama̱ xlakstu xatalhtzi trigo antá̱ nama̱qui̱y c-xchic, chu̱ yama̱ xapalhma antá̱ nama̱pu̱y c-lhcúya̱t hua̱ntu̱ niucxni̱ lakmixa.” ");
INSERT INTO tosNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chu̱ na̱ chuná̱ lhu̱hua̱ makapitzi̱n tachihuí̱n hua̱ntu̱ Juan xli̱xakatli̱ko̱y ti̱ xlakminko̱y laqui̱mpi̱ chuná̱ naakata̱ksko̱y yama̱ xasa̱sti tama̱catzi̱ní̱n la̱ntla̱ Dios xma̱lacnu̱nima̱kó̱ xtapá̱xqui̱t, chu̱ tla̱n nalakma̱xtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hua̱mpi̱ milh quilhtamacú̱ acxni̱ Juan tamacanu̱ca̱ c-pu̱la̱chi̱n caj xpa̱lacata̱ pi̱ li̱huánilh yama̱ gobernador xuanicán Herodes pi̱ ni̱tlá̱n la̱ xta̱hui̱ Herodías xpusca̱t xta̱la Felipe, chu̱ na̱ chuná̱ li̱huánilh xli̱pacs hua̱ntu̱ xlá̱ ni̱tlá̱n xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hua̱mpi̱ yama̱ Herodes ni̱ pala tzinú̱ kalhakáxmatli̱ hua̱ntu̱ huánilh, huata xlá̱ tlahualhcú̱ hua̱ntu̱ ni̱tlá̱n sa̱mpi̱ caj xpa̱lacata makasí̱tzi̱lh ma̱tamacanu̱ní̱nalh c-pu̱la̱chi̱n Juan Bautista. ");
INSERT INTO tosNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Maktum acxni̱ Juan ni̱ xa̱tamacanu̱cán c-pu̱la̱chi̱n, chu̱ acxni̱ lhu̱hua chixcuhuí̱n xakmunuma̱kó̱, Jesús na̱ lákmilh laqui̱mpi̱ na̱ naakmunuy; chu̱ acxni̱ ta̱kmunuko̱lh, tzúculh tlahuaniy oración Dios. Caj xamaktum talácqui̱lh akapú̱n, ");
INSERT INTO tosNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","chu̱ Espíritu Santo ta̱ctachi̱ c-xokspún xta̱chuná̱ tijtímpu̱t xatantum laqui̱mpi̱ pacs naucxilhcán. Na̱ takáxmatli̱ aktum tachihuí̱n hua̱ntu̱ minchá̱ c-akapú̱n, chu̱ chuná̱ huá̱: —Huix quincam hua̱nti̱ luhua cpa̱xqui̱yá̱n, luhua cpa̱xuhuay caj mimpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús xkalhi̱y puxamaca̱hu ca̱ta̱ acxni̱ ma̱tzúqui̱lh xtascújut. Cumu xpuhuancán pi̱ hua̱ xtla̱t xuani̱t José, xlá̱ xkalhi̱y hua̱nti̱ xli̱minko̱ni̱tanchá̱ xalakmaka̱n xnatla̱tna, chu̱ chuná̱ xuaniko̱cán: Xtla̱t José xuanicán Elí, ");
INSERT INTO tosNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","xtla̱t Elí xuanicán Matat, xtla̱t Matat xuanicán Leví, xtla̱t Leví xuanicán Melqui, xtla̱t Melqui xuanicán Jana, a̱má xtla̱t Jana xuanicán José, ");
INSERT INTO tosNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","xtla̱t José xuanicán Matatías, yuma̱ xtla̱t Matatías xuanicán Amós, xtla̱t Amós xuanicán Nahum, xtla̱t Nahum xuanicán Esli, xtla̱t Esli xuanicán Nagai, ");
INSERT INTO tosNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","xtla̱t Nagai xuanicán Maat, xtla̱t Maat xuanicán Matatías, xtla̱t Matatías xuanicán Semei, xtla̱t Semei xuanicán José, xtla̱t José xuanicán Judá, ");
INSERT INTO tosNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","xtla̱t Judá xuanicán Joanán, xtla̱t Joanán xuanicán Resa, xtla̱t Resa xuanicán Zorobabel, xtla̱t Zorobabel xuanicán Salatiel, xtla̱t Salatiel xuanicán Neri, ");
INSERT INTO tosNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","xtla̱t Neri xuanicán Melqui, xtla̱t Melqui xuanicán Adi, xtla̱t Adi xuanicán Cosam, xtla̱t Cosam xuanicán Elmadam, xtla̱t Elmadam xuanicán Er, ");
INSERT INTO tosNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","xtla̱t Er xuanicán Josué, xtla̱t Josué xuanicán Eliezer, xtla̱t Eliezer xuanicán Jorim, xtla̱t Jorim xuanicán Matat, ");
INSERT INTO tosNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","xtla̱t Matat xuanicán Leví, xtla̱t Leví xuanicán Simeón, xtla̱t Simeón xuanicán Judá, xtla̱t Judá xuanicán José, xtla̱t José xuanicán Jonán, xtla̱t Jonán xuanicán Eliaquim, ");
INSERT INTO tosNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","xtla̱t Eliaquim xuanicán Melea, xtla̱t Melea xuanicán Mainán, xtla̱t Mainán xuanicán Matata, xtla̱t Matata xuanicán Natán, ");
INSERT INTO tosNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","xtla̱t Natán xuanicán David, xtla̱t David xuanicán Isaí, xtla̱t Isaí xuanicán Obed, xtla̱t Obed xuanicán Booz, xtla̱t Booz xuanicán Salmón, xtla̱t Salmón xuanicán Naasón, ");
INSERT INTO tosNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","xtla̱t Naasón xuanicán Aminadab, xtla̱t Aminadab xuanicán Aram, xtla̱t Aram xuanicán Esrom, xtla̱t Esrom xuanicán Fares, xtla̱t Fares xuanicán Judá, ");
INSERT INTO tosNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","xtla̱t Judá xuanicán Jacob, xtla̱t Jacob xuanicán Isaac, xtla̱t Isaac xuanicán Abraham, xtla̱t Abraham xuanicán Taré, xtla̱t Taré xuanicán Nacor, ");
INSERT INTO tosNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","xtla̱t Nacor xuanicán Serug, xtla̱t Serug xuanicán Ragau, xtla̱t Ragau xuanicán Peleg, xtla̱t Peleg xuanicán Heber, xtla̱t Heber xuanicán Sala, ");
INSERT INTO tosNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","xtla̱t Sala xuanicán Cainán, xtla̱t Cainán xuanicán Arfaxad, xtla̱t Arfaxad xuanicán Sem, xtla̱t Sem xuanicán Noé, xtla̱t Noé xuanicán Lamec, ");
INSERT INTO tosNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","xtla̱t Lamec xuanicán Matusalén, xtla̱t Matusalén xuanicán Enoc, xtla̱t Enoc xuanicán Jared, xtla̱t Jared xuanicán Mahalaleel, xtla̱t Mahalaleel xuanicán Cainán, ");
INSERT INTO tosNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","xtla̱t Cainán xuanicán Enoc, xtla̱t Enoc xuanicán Set, xtla̱t Set xuanicán Adán, xtla̱t Adán hua̱ Dios porque hua̱ Adán xapu̱lh chixcú ti̱ tláhualh. ");
INSERT INTO tosNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Acxni̱ Jesús ta̱kmunuko̱lh luhua xli̱taxajni̱t Espíritu Santo, chu̱ táca̱xli̱ c-xquilhtu̱n kalhtu̱choko̱ hua̱ntu̱ xuanicán Jordán, chu̱ antá̱ álh c-desierto anta̱ni̱ ni̱tí̱ lama̱, sa̱mpi̱ chuná̱ ma̱puhuá̱ni̱lh Espíritu Santo natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Antá̱ xlama̱chá̱ ti̱puxam quilhtamacú̱ xacstu, chu̱ ni̱tú̱ huá̱yalh, hua̱mpi̱ tzúculh tzincsa. Minchá̱ akskahuiní, chú̱ tzúculh toklha, ");
INSERT INTO tosNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","chu̱ chuná̱ huánilh: —Lapi̱ xli̱ca̱na̱ huix xCam Dios, pus chú̱ catiya̱ yuma̱ chíhuix, chu̱ cali̱ma̱paksí̱nanti̱ laqui̱mpi̱ caxtala̱nchuj cahuá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús chuná̱ kálhti̱lh: —Nac Li̱kalhtahuaka̱ chuná̱ tatzoktahuilani̱t huan: ‘Ni̱ luhua caj xma̱n xlí̱huat catili̱latáma̱lh cha̱tum, pus na̱ luhua xlacasquinca̱ nali̱latama̱y a̱ma̱ xtachihui̱n Dios hua̱ntu̱ xlá̱ li̱ma̱paksi̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A̱li̱sta̱lh yama̱ akskahuiní̱ tá̱alh c-aktum tlanca ka̱stí̱n, chu̱ antá̱ caj puntzú̱ ma̱ucxílhni̱lh xli̱pacs lactlanca ca̱chiquí̱n hua̱ntu̱ huilakó̱ catuxá̱huat, chu̱ xli̱pacs la̱ntla̱ tu̱ kalhi̱ko̱y li̱lakáti̱t, chu̱ hua̱ntu̱ xtapalh tumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Antá̱ yama̱ akskahuiní̱ chuná̱ huánilh: —Xli̱pacs yuma̱ lactlanca pu̱ma̱paksí̱n hua̱ntu̱ ucxílhpa̱t, quit quima̱xqui̱cani̱t, chu̱ na̱ chuná̱ ckalhi̱y li̱ma̱paksí̱n, chu̱ tla̱n nacmacama̱xqui̱y hua̱nti̱ quit chuná̱ nacpuhuaniy. ");
INSERT INTO tosNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pus hua̱ pala pi̱ xquilakataquilhpu̱ta, chu̱ naquilakachixcuhui̱ya̱ la̱ mimpu̱chiná, pacs milá nahuán yumá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hua̱mpi̱ Jesús chuná̱ kálhti̱lh: —Huix akskahuiní luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n caquintapa̱nu̱ni, sa̱mpi̱ c-xtachihui̱n Dios hua̱ntu̱ tatzokni̱t c-Li̱kalhtahuaka̱ chuná̱ huan: ‘Xma̱n hua̱ Mimpu̱china Dios nalakataquilhpu̱taya, chu̱ na̱ xma̱n huá̱ hua̱nti̱ nalakachixcuhui̱ya.’ ");
INSERT INTO tosNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A̱li̱sta̱lh li̱tum yama̱ akskahuini̱ tá̱alh Jesús c-xaca̱chiqui̱n Jerusalén, chu̱ antá̱ ta̱tahuácalh c-xaksti̱n xatorre tlanca templo, chu̱ chuná̱ huánilh: —Pus hua̱ lapi̱ xli̱ca̱na̱ huix xCam Dios, u̱nú̱ lhkan catamákuasti̱ hasta ca̱tu̱tzú̱. ");
INSERT INTO tosNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sa̱mpi̱ c-xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ chuná̱ huan: ‘Dios nama̱paksi̱ko̱y xángeles pi̱ nacui̱ntajtlahuayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xlacán lacapala̱ nali̱chipapa̱xtokko̱yá̱n xmacancán laqui̱mpi̱ mintantú̱n ni̱mpala aktum chíhuix nali̱akchakxa.’ ");
INSERT INTO tosNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús tuncán kálhti̱lh: —Hua̱mpi̱ na̱ luhua mili̱cátzi̱t pi̱ hua̱ntu̱ tatzoktahuilani̱t xtachihui̱n Dios, na̱ chuná̱ huan: ‘Niucxni̱ caj chunatá̱ cali̱kalhakamánanti̱ Mimpu̱china Dios laqui̱mpi̱ natlahuay hua̱ntu̱ huix lacasquina catláhualh mintapa̱xuhuá̱n hua̱ntu̱ ni̱ pala tzinú̱ mini̱niyá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pus acxni̱ yama̱ akskahuiní̱ nia̱lh cátzi̱lh xatú̱ luhua natili̱tlahuaniy tatoklhni Jesús, pus huata xatlá̱n caj tatampú̱xtulh, chu̱ luhua maka̱s quilhtamacú̱ lacatzá̱lalh, chu̱ nia̱lh tzáksalh laqui̱mpi̱ nama̱tlahui̱y tala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Acxni̱ Jesús qui̱táspitli̱ c-desierto, álh c-xatiyat Galilea, hua̱mpi̱ luhua xli̱ca̱na̱ xkalhi̱y xli̱tlihuaka Espíritu Santo, chu̱ cani̱huá̱ lacatum c-xli̱ca̱tlanca̱ yama̱ tíyat xli̱chihui̱nancán xtascújut hua̱ntu̱ xlá̱ xtlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Cani̱huá̱ anta̱ni̱ xchá̱n actzu̱ ca̱chiquí̱n, xtanu̱ya̱chá̱ c-xpu̱kalhtahuakacan judíos, chu̱ xli̱xakatli̱ko̱y tachixcuhuí̱tat xasa̱sti xtapaksi̱t Dios, chu̱ xli̱pu̱tum hua̱nti̱ xkaxmatniko̱y luhua xli̱pa̱xuhuako̱y hua̱ntu̱ xuan. ");
INSERT INTO tosNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ni̱ li̱maka̱s Jesús álh paxia̱lhnán c-Nazaret, hua̱ yama̱ xca̱chiquí̱n anta̱ni̱ xlá̱ cstacni̱tanchá. Cha̱nchu̱ hua̱ la̱ntla̱ta tali̱smaní̱n, acxni̱ cha̱lh quilhtamacú̱ sábado, acxni̱ ni̱tí̱ cscuja judíos, xlá̱ tánu̱lh c-xpu̱kalhtahuakacan judíos. Caj li̱puntzú̱ álh ta̱yay calacán laqui̱mpi̱ nali̱kalhtahuakay xtachihui̱n Dios hua̱ntu̱ tatzokni̱t c-Li̱kalhtahuaka. ");
INSERT INTO tosNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pus xmaktakalhna sinagoga má̱xqui̱lh mactum libro hua̱ntu̱ xtzokni̱t xamaka̱n profeta Isaías, chu̱ acxni̱ ma̱lakapítzilh, luhua antá̱ ma̱nóklhulh anta̱ni̱ chuná̱ tatzokni̱t: ");
INSERT INTO tosNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hua̱ cspiritu Quimpu̱chinacán huí̱ c-quilatáma̱t, huachá̱ quili̱lacsacuíli̱lh laqui̱mpi̱ nacli̱xakatli̱ko̱y hua̱nti̱ lakli̱ma̱xkaní̱n yama̱ li̱pa̱xuhu xasa̱sti xtama̱catzi̱ní̱n. Na̱ luhua huá̱ quili̱macamini̱t laqui̱mpi̱ nacuaniko̱y pi̱ huí̱ xlaktaxtutcán hua̱nti̱ xta̱chuná̱ la̱ tachí̱n lama̱kó̱ caj xpa̱lacata xtala̱kalhi̱ncán, chu̱ na̱ chuna li̱tum laqui̱mpi̱ nacma̱lacahua̱ni̱ko̱y hua̱nti̱ lakatzí̱n lama̱kó̱, chu̱ laqui̱mpi̱ tla̱n nacma̱laktaxti̱ko̱y hua̱nti̱ ma̱catzajuani̱ma̱ko̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Quit luhua quimacamini̱t laqui̱mpi̱ nacmakapa̱xuhuako̱y tachixcuhuí̱tat sa̱mpi̱ nacuaniko̱y la̱ntla̱ Dios xli̱ca̱na̱ lakalhamanko̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Acxni̱ li̱kalhtahuakako̱lh yama̱ tachihuí̱n ma̱lakachúhualh libro, chu̱ macamá̱xqui̱lh chixcú̱ hua̱nti̱ antá̱ xmakta̱yani̱nán c-pu̱kalhtahuaka, titahui̱. Hua̱mpi̱ cumu xli̱lhu̱hua hua̱nti̱ antá̱ xuilakó̱ luhua cacs xlaklaca̱nko̱ni̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","puschí̱ tzúculh huaniko̱y: —Chiyú̱ luhua c-milacati̱ncán kantaxtuni̱t yuma̱ xtachihui̱n Dios hua̱ntu̱ quit cca̱li̱kalhtahuakanini̱tán. ");
INSERT INTO tosNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Xli̱pacs hua̱nti̱ xkaxmatnima̱kó̱ xtachihuí̱n luhua xli̱ca̱na̱ xlakati̱ko̱y hua̱ntu̱ xuan, chu̱ lanaj xli̱lacahuanko̱y sa̱mpi̱ yama̱ xtachihuí̱n hua̱ntu̱ xlá̱ xuan luhua xli̱ca̱na̱ tla̱n. Hua̱mpi̱ makapitzí̱n luhua caj xli̱aklhu̱hua̱tnanko̱y, chu̱ chuná̱ xla̱huaniko̱y: —¿Lá̱ntla̱ lay yumá? ¿Pa̱ ni̱ hua̱ yuma̱ xcam quili̱ta̱chiquican José? ");
INSERT INTO tosNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús chuná̱ huaniko̱lh yama̱ chixcuhuí̱n: —Quit ccatzi̱y pi̱ ni̱ anán tamacpuhuá̱n huixín naquihuaniyá̱tit yama̱ hua̱ntu̱ chuná̱ huan: ‘Huix hua̱nti̱ tla̱n cuchi̱nana, pus chú̱ na̱ cacuchí̱canti̱ miacstu lapi̱ tla̱n.’ Chu̱ na̱ chuna li̱tum naquihuaniyá̱tit: ‘Quin ckaxmatni̱tahu la̱ntla̱ mat tlahuani̱ta̱ lactlanca tascújut c-Capernaum, pus lapi̱ xli̱ca̱na̱, chiyú̱ na̱ chuná catlahua̱ u̱nú̱ c-minca̱chiquí̱n lapi̱ tla̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xlá̱ chunacú̱ xchihui̱nama̱, chu̱ chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ luhua tuhua naqui̱taxtuniy cha̱tum profeta hua̱nti̱ li̱chihui̱nama̱ xtalacapa̱stacni Dios pala xli̱ca̱na̱ nali̱pa̱huamputunko̱y ti̱ xala c-xca̱chiquí̱n yama̱ tachihui̱n hua̱ntu̱ quilhuama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Xa̱huachí̱ luhua caj calacapa̱stáctit pi̱ na̱ chuná̱ akspúlalh xamaka̱n profeta Elías acxni̱ u̱nú̱ c-quintiyatcan Israel luhua aktutu ca̱ta a̱íta̱t ni̱ pala tzinú̱ milh se̱n, chu̱ lalh tlanca tatzíncstat la̱ntla̱ c-xli̱ca̱tlanca̱ u̱nú̱ c-quintiyatcán, chu̱ antá̱ xlama̱kó̱ lhu̱hua lacchaján hua̱nti̱ xni̱makanko̱ni̱t xchixcucán, xlacán luhua li̱pe̱cua̱ xpa̱ti̱ma̱kó̱, sa̱mpi̱ ni̱ xkalhi̱koy hua̱ntu̱ nahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Hua̱mpi̱ Dios ni̱tú̱ li̱ma̱páksi̱lh Elías pi̱ naán makta̱yako̱y a̱ma̱ lacchaján xala c-Israel, pus huata Dios ma̱lakácha̱lh Elías anta̱ni̱ cha̱tum pusca̱t pu̱huani̱ní̱ xuilachá̱ c-actzu̱ chuchutsipi̱ huanicán Sarepta c-xtama̱paksi̱n Sidón. ");
INSERT INTO tosNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na̱ chuna li̱tum calacapa̱stáctit acxni̱ xlama̱ xamaka̱n profeta Eliseo, anta li̱tum c-Israel xlama̱kó̱ lhu̱hua chixcuhuí̱n hua̱nti̱ xkalhi̱ko̱y yama̱ luhua li̱xcajnit tzitzi huanicán lepra, hua̱mpi̱ yama̱ Eliseo ni̱ pala cha̱tum ma̱pacsako̱lh yama̱ ta̱tatlaní̱n, pus huata xlá̱ ma̱pácsalh xma̱n cha̱tum chixcú xuanicán Naamán luhua xala makat tíyat hua̱ntu̱ huanicán Siria. ");
INSERT INTO tosNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Acxni̱ chuná̱ tikaxmatko̱lh yuma̱ tachihuí̱n hua̱ntu̱ xlá̱ xquilhuama̱, hua̱nti̱ xtamakstokko̱ni̱t c-pu̱kalhtahuaka̱ luhua li̱pe̱cua̱ tzúculh si̱tzi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lacapala̱tnanko̱lh, chipako̱lh Jesús, chu̱ titamacaxtuko̱lh c-xquilhapa̱n ca̱chiquí̱n anta̱ni̱ xuí̱ c-xuástat laqui̱mpi̱ antá̱ nama̱makuasi̱ko̱y, chu̱ laqui̱mpi̱ chuná tla̱n namakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Hua̱mpi̱ Jesús titáxtulh, xlá̱ laksti̱pa̱tanu̱ko̱lh xli̱lhu̱hua̱ chixcuhuí̱n, antá̱ akxtakya̱huako̱lh, chu̱ álh. ");
INSERT INTO tosNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A̱li̱sta̱lh Jesús cha̱lh c-xaca̱chiqui̱n Capernaum antá̱ c-xatiyat Galilea. Maktum quilhtamacu̱ sábado, acxni̱ pacs judíos jaxko̱y, xlá̱ álh li̱akchihui̱nán xtachihui̱n Dios c-xpu̱kalhtahuakacan judíos tu̱ xuí̱ antá. ");
INSERT INTO tosNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na̱ lhpipak xli̱lacahuanko̱y hua̱nti̱ xkaxmatnima̱kó̱ xtama̱siyún, sa̱mpi̱ pacs tu̱ xma̱siyuniko̱y, chuná̱ xuaniko̱y xta̱chuná̱ la̱ntla̱ ti̱ xli̱ca̱na̱ kalhi̱y li̱ma̱paksí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anta̱ni̱ pu̱tum xtamakstokko̱ni̱t tachixcuhuí̱tat hua̱nti̱ xkaxmatnima̱kó̱ xtachihui̱n Jesús, na̱ antá̱ xuí̱ cha̱tum chixcú̱ hua̱nti̱ xma̱xcajua̱li̱nini̱t xtalacapa̱stacni cspiritu akskahuiní. Xlá̱ chuná̱ quilhánilh: ");
INSERT INTO tosNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Huix, Jesús xala c-Nazaret, ¿tú̱ xpa̱lacata quinca̱laksoka̱li̱ya̱ anta̱ni̱ quin clama̱hu? ¿Pa̱ huix caj tani̱ta quinca̱ma̱sputuya? Catlahua̱ li̱tlá̱n caquinca̱makáxtakti, chu̱ ni̱tú̱ caquinca̱tlahuani, sa̱mpi̱ quin cca̱lakapasá̱n, xa̱huachí̱ quin ccatzi̱ya̱hu pi̱ huix hua̱nti̱ Dios lacsacni̱t laqui̱mpi̱ nascujnaniya. ");
INSERT INTO tosNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús kálhti̱lh yama̱ cspiritu akskahuiní, chu̱ chuná̱ huánilh: —¡Cakátxtakti; xa̱huachí̱ cataxtuni̱ tama̱ chixcú! Yama̱ cspiritu akskahuiní li̱ca̱tálalh yama̱ chixcú, chu̱ li̱ca̱tálalh ca̱tiyatna, chu̱ la̱ntla̱ pu̱tum xucxilhma̱kó̱ makáxtakli̱ yama̱ chixcú, hua̱mpi̱ ni̱ pala tzinú̱ xma̱sipá̱ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Xli̱pacs hua̱nti̱ ucxilhma̱kó̱, pe̱cuanko̱lh, chu̱ chuná̱ xla̱huaniko̱y: —¿Xatú̱ ya̱ li̱tlihuaka cahuá̱ kalhi̱y xtachihuí̱n? Pus tama̱ chixcú̱ ma̱paksi̱ko̱y cspiritucan akskahuiní, chu̱ cumu xlá̱ kalhi̱y li̱tlihuaka̱ xlacán tuncán taxtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yama̱ lactlanca li̱ca̱cni tascújut tu̱ xtlahuay Jesús cani̱huá̱ xli̱chihui̱nancán c-xli̱ca̱tlanca̱ yama̱ tíyat. ");
INSERT INTO tosNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Acxni̱ chu̱ táxtulh Jesús cpu̱kalhtahuaka̱ álh c-xchic Simón Pedro. Hua̱mpi̱ xpu̱tiya̱tzi Simón xta̱tatlay, luhua palha lhcúya̱t xuani̱t, puschí̱ squiniko̱lh li̱tlá̱n Jesús pi̱ xlá̱ cama̱pácsalh. ");
INSERT INTO tosNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Xlá̱ laktalacatzúhui̱lh, taquilhpú̱talh ca̱tu̱tzú̱ anta̱ni̱ xlá̱ xmá̱, chu̱ huánilh yama̱ tajátat pi̱ camakáxtakli. Chu̱ xli̱ca̱na̱ yama̱ lhcúya̱t lacapala̱ makáxtakli. Yama̱ pusca̱t la̱li̱huán tá̱qui̱lh, chu̱ xlá̱ tzúculh ca̱xtlahuay lí̱huat hua̱ntu̱ nata̱li̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Acxni̱ chú̱ aya xtzanka̱y chichiní, xli̱pacs hua̱nti̱ xkalhi̱y xta̱tatlaní̱n, ma̱squi pala tú̱ tajátat xkalhi̱y, hua̱mpi̱ li̱miniko̱lh anta̱ni̱ xuí̱ Jesús. Xlá̱ li̱acchipako̱lh xmacán cha̱tunu, chu̱ chuná̱ pacs ma̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hua̱mpi̱ na̱ chuna li̱tum lhu̱hua̱ ta̱tatlaní̱n xma̱pacsako̱y hua̱nti̱ xkalhikoy cspiritu akskahuiní. Makapitzí̱n acxni̱ xtamacataxtuy ti̱ xpa̱laktaju̱ko̱ni̱t, xtzucuy ca̱tasako̱y, chu̱ chuná̱ xuaniko̱y: —¡Huix xCam Dios! Hua̱mpi̱ Jesús xma̱quilhcacsako̱y, chu̱ ni̱ xma̱xqui̱ko̱y talacasquín nachihui̱nanko̱y, sa̱mpi̱ xlacán xcatzi̱ko̱y pi̱ Jesús xli̱ca̱na̱ hua̱ Cristo hua̱nti̱ xmini̱t lakma̱xtuko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Li̱cha̱lí̱, acxni̱ titzúculh ca̱xkakay, Jesús álh c-xquilhapa̱n a̱ma̱ ca̱chiquí̱n anta̱ni̱ luhua ca̱tze̱k, hua̱mpi̱ cumu lhu̱hua̱ hua̱nti̱ xputzama̱kó̱, juerza lakcha̱nko̱lh anta̱ni̱ xlá̱ xcha̱ni̱t, chu̱ luhua juerza̱ xuanima̱kó̱ pi̱ catachókolh antá, chu̱ ni̱ caalh a̱lacatanuj ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —Hua̱mpi̱ na̱ chuna li̱tum luhua xlacasquinca̱ quit nacán li̱xakatli̱ko̱y a̱makapitzí̱n hua̱nti̱ huilakó̱ alacatanuj ca̱chiquí̱n yuma̱ luhua li̱pa̱xuhu xtachihui̱n Dios la̱ntla̱ xlá̱ ma̱tzuqui̱putún xasa̱sti xtapáksi̱t ca̱tuxá̱huat, sa̱mpi̱ luhua caj xma̱n hua̱ tama̱ quintascújut xlá̱ quili̱macamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pus chuná̱ Jesús xlatla̱huán, xli̱akchihui̱nampu̱lay xtachihui̱n Dios xli̱pacs c-xpu̱kalhtahuakacan judíos hua̱ntu̱ xuilakó̱ yama̱ c-lactzu̱ ca̱chiqui̱n hua̱ntu̱ xma̱paksi̱ko̱y xamunicipio Judea. ");
INSERT INTO tosNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Maktum Jesús antá̱ xlaya̱chá, xakchihui̱nama̱ c-xquilhtu̱n ta̱kaya̱huaná̱ huanicán Genesaret; luhua li̱lhu̱hua̱ ti̱ xli̱tamacxtumi̱ni̱t, hasta tzucuko̱lh la̱lacxquitiya̱huako̱y sa̱mpi̱ xkaxmatputunko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús úcxilhli̱ c-xquilhtu̱n chúchut pi̱ antá̱ xuilakó̱ aktuy pu̱tacutnu, hua̱mpi̱ xma̱la̱nacán ni̱tí̱ xtajuma̱kó̱, pus xlacán xlakachaka̱ma̱kó̱ xtza̱lhcán. ");
INSERT INTO tosNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Antá̱ xlá̱ táju̱lh c-aktum pu̱tacutnu, xma̱la̱na yama̱ pu̱tacutnu xuanicán Simón, chu̱ huánilh pi̱ cama̱lakamakátli̱lh tzinú̱ c-xquilhtú̱n; chu̱ antá̱ culucs tahui̱, chu̱ tzúculh xakatli̱ko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Acxni̱ ma̱katspútulh xta̱kchihuí̱n chuná̱ huánilh Simón: —Chú̱ anta̱ni̱ tlak xapu̱lhmá̱n huí̱ chúchut cali̱pi̱ mimpu̱tacutnu, laqui̱mpi̱ namuju̱yá̱tit mintza̱lhcán, chu̱ nachipayá̱tit squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón chuná̱ kálhti̱lh: —Ma̱kalhtahuaka̱ná, sa̱mpi̱ tantascacatá̱ cscujni̱tahu, chu̱ ni̱tú̱ cchipaya̱hu; hua̱mpi̱ caj xpalacata pi̱ huix quihuanípa̱t, nacmaca̱mpalaya̱hu quintza̱lhcán. ");
INSERT INTO tosNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Acxni̱ chú̱ maca̱nko̱lh tza̱lh, lhu̱hua̱ squi̱ti̱ chipako̱lh, chu̱ a̱tzinú̱ xuani̱t aya xtalacaxti̱tputún xtza̱lhcán caj la̱ntla̱ xli̱tzinca̱ squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Xlacán tzucuko̱lh pakalhcatniko̱y a̱makapitzi̱n xta̱squi̱ti̱naní̱n ti̱ xtaju̱ma̱kó̱ c-a̱aktum pu̱tacutnu laqui̱mpi̱ namincán makta̱yako̱cán. Xlacán lacapala̱ li̱minko̱lh xpu̱tacutnucán, chu̱ li̱ma̱tzamako̱lh squi̱ti̱ pacs pa̱tuy pu̱tacutnu; hua̱mpi̱ luhua chí̱ aya xlaktzanka̱putunko̱y c-chúchut caj xpa̱lacata xli̱tzincacán. ");
INSERT INTO tosNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Acxni̱ úcxilhli̱ Simón Pedro hua̱ntu̱ xtlahuani̱t, tilakatatzokóstalh Jesús, chu̱ chuná̱ huánilh: —Quimpu̱chiná, luhua catlahua̱ li̱tlá̱n capit, sa̱mpi̱ quit luhua xli̱ca̱na̱ makla̱kalhi̱na̱ chixcú, ni̱ quimini̱niy pala chuná̱ naquimakta̱yaya. ");
INSERT INTO tosNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Huá̱ chuná̱ xli̱huán sa̱mpi̱ xlá̱ xpe̱cuaxni̱ni̱t, na̱ chuná̱ a̱makapitzí̱n hua̱nti̱ xucxilhko̱ni̱t xpe̱cuanko̱ni̱t caj xpa̱lacata̱ pi̱ li̱ma̱lacahua̱ni̱ko̱lh aktum tlanca li̱ca̱cni tatlahu. ");
INSERT INTO tosNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na̱ chuná̱ xpe̱cuama̱kó̱ makapitzi̱n li̱tum xta̱squi̱ti̱nani̱n Simón Pedro, hua̱nti̱ xuaniko̱cán Santiago, chu̱ Juan cha̱tuy xcamana̱n Zebedeo, hua̱mpi̱ Jesús chuná̱ huanipá̱: —Ni̱ cape̱cuántit, sa̱mpi̱ chuná̱ la̱ntla̱ huixín xuataju̱naná̱tit laqui̱mpi̱ nachipayá̱tit squi̱ti, la̱nchú̱ quit nacca̱ma̱siyuniyá̱n la̱ntla̱ naputzayá̱tit yama̱ minta̱chixcuhui̱ncán hua̱nti̱ aktzanka̱tama̱ko̱ni̱t, ni̱ xahua̱ squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pus yama̱ squi̱ti̱naní̱n acxni̱ li̱chinko̱lh xpu̱tacutnucán c-xquilhtu̱n ta̱kaya̱huaná, pu̱tum akxtakuili̱ko̱lh, chu̱ sta̱laniko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maktum tílalh pi̱ acxni̱ Jesús xcha̱ni̱t c-aktum ca̱chiquí̱n, caj li̱puntzú̱ chilh cha̱tum chixcú, xlá̱ xta̱tatlay, chu̱ xkalhi̱y aktum li̱lakaputza tzitzi huanicán lepra. Acxni̱ yama̱ chixcú̱ úcxilhli̱ Jesús, xlá̱ laktalacatzúhui̱lh, chu̱ lakatatzokóstalh hasta ca̱tiyatna, chu̱ chuná̱ squínilh li̱tlá̱n: —Quimpu̱chiná, lapi̱ huix chuná̱ lacasquina, pus caquima̱pacsani̱ u̱ma̱ li̱xcajnit quintzitzi. ");
INSERT INTO tosNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús li̱xamánilh xmacán c-xmacni̱ yama̱ chixcú, chu̱ chuná̱ huánilh: —Chuná̱ clacasquín, la̱nchuj tuncán capacsti. Acxni̱ chuná̱ huanko̱lh Jesús, yama̱ chixcú̱ tuncán pácsnilh xtzitzi. ");
INSERT INTO tosNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱li̱sta̱lh Jesús ma̱páksi̱lh yama̱ chixcú̱ pi̱ ni̱tí̱ nahuaniy la̱ntla̱ pacsli, hua̱mpi̱ chuná̱ huánilh hua̱ntu̱ xlá̱ xli̱tláhuat: —Caj xma̱n huá̱ tu̱ cuaniyá̱n, tuncán calakpimpi̱ cha̱tum pa̱li̱ laqui̱mpi̱ xlá̱ nacatzi̱y pi̱ nia̱lh tú̱ kalhi̱yá̱n mintajátat, xa̱huachí̱ cali̱sa̱huani̱ Dios mili̱ca̱xtlahuá̱n xta̱chuná̱ la̱ntla̱ tili̱ma̱paksí̱nalh Moisés nama̱sta̱ko̱y hua̱nti̱ napacsko̱y ti̱ xkalhi̱ko̱y tama̱ tajátat, chu̱ laqui̱mpi̱ chuná̱ pu̱tum nacatzi̱cán pi̱ xli̱ca̱na̱ aya pacsni̱ta. ");
INSERT INTO tosNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Hua̱mpi̱ xli̱ca̱tlanca̱ yama̱ tíyat xta̱kahuani̱ma̱ la̱ntla̱ xli̱chihui̱nancán xtascujut Jesús, chu̱ luhua lhu̱hua̱ xlakminko̱y laqui̱mpi̱ nakaxmatniko̱y xtachihuí̱n, chu̱ nama̱pacsako̱y hua̱nti̱ xkalhi̱ko̱y tajátat. ");
INSERT INTO tosNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Hua̱mpi̱ Jesús ankalhí̱n xtatampu̱xtuniko̱y, chu̱ antá̱ xán anta̱ni̱ tzili̱s ca̱huán, chu̱ ni̱tí̱ lama̱, laqui̱mpi̱ chuná̱ xlá̱ tla̱n natlahuay xoración. ");
INSERT INTO tosNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cha̱nchu̱ tílalh maktum, acxni̱ Jesús xma̱siyuma̱ xtachihui̱n Dios pi̱ na̱ antá̱ xkaxmatnima̱kó̱ makapitzi̱n fariseos, chu̱ laktzokni̱naní̱n, xlacán xminko̱ni̱tanchá̱ c-lactzu̱ ca̱chiquí̱n hua̱nti̱ xma̱paksi̱ko̱y Galilea, chu̱ Judea, chu̱ hasta makapitzí̱n xminko̱ni̱t xala c-Jerusalén. Chu̱ caj la̱ntla̱ xma̱pacsako̱y ta̱tatlaní̱n Jesús, pus antá̱ xli̱tasiyuy xli̱pacs xli̱makatlihuaka Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chu̱ na̱ acxnitiyá̱ chinko̱lh makapitzi̱n chixcuhuí̱n, xlacán xpu̱le̱ma̱kó̱ pu̱chaxna cha̱tum chixcú sa̱mpi̱ xli̱cha̱tumi̱nica̱ xaní̱n xuani̱t c-xnújut, chu̱ ni̱ lay xtla̱huán. ");
INSERT INTO tosNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Hua̱mpi̱ xlacán ni̱ lalh tanu̱ko̱lh sa̱mpi̱ luhua lhu̱hua̱ xtzamacán c-má̱laccha. Huata tu̱ tlahuako̱lh, tahuacako̱lh c-xaksti̱n chiqui, acsti̱xtatko̱lh; antá̱ chú̱ pu̱lacma̱acti̱ko̱lh tu̱ xpu̱lacma̱ yama̱ ta̱tatlá, chu̱ ma̱squi lhu̱hua̱ xtzamacán, luhua antá̱ tzaj ta̱ctachá̱ anta̱ni̱ xuí̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Acxni̱ Jesús ucxilhko̱lh pi̱ luhua xli̱ca̱na̱ xli̱pa̱huanko̱y pi̱ xlá̱ tla̱n nama̱pacsay, chuná̱ huánilh ta̱tatlá: —Chixcú, la̱ntla̱ xli̱pacs mintala̱kalhí̱n cma̱tzanka̱naniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hua̱mpi̱ yama̱ laktzokni̱naní̱n, xa̱hua̱ fariseos, chuná̱ tzúculh puhuanko̱y: “¿Tú̱ xtá̱yat tama̱ chixcú? Pus caj xtachihuí̱n li̱lacata̱qui̱ma̱ Dios, sa̱mpi̱ ni̱ pala cha̱tum anán hua̱nti̱ tla̱n nama̱tzanka̱nani̱nán tala̱kalhí̱n, lapi̱ ni̱ xma̱n hua̱ Dios.” ");
INSERT INTO tosNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Hua̱mpi̱ Jesús pacs xcatzi̱y hua̱ntu̱ xlacán xpuhuama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Tú̱huan chuná̱ la̱ntamá̱ lacapa̱stacá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Caquihuanítit, ¿xatú̱ tlak tuhua̱ ma̱kantaxti̱cán? ¿Pi̱ acxni̱ nahuanicán cha̱tum ta̱tatlá: ‘Mintala̱kalhí̱n pacs cma̱tzanka̱naniyá̱n’, usuchí̱ pala nahuanicán: ‘Lacapala̱ cata̱qui, chu̱ catlá̱huanti’? ");
INSERT INTO tosNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pus la̱nchú̱ huixín nacatzi̱yá̱tit pi̱ quit, Xatalacsacni Chixcú, chu̱ quima̱xqui̱cani̱t li̱ma̱paksí̱n, chu̱ li̱tlihuaka̱ laqui̱mpi̱ caj quintachihuí̱n tla̱n nacli̱ma̱tzanka̱nani̱nán tala̱kalhí̱n u̱nú̱ cca̱tuxá̱huat. Pus xlá̱ xakátli̱lh yama̱ chixcú̱ hua̱nti̱ ni̱ lay xtla̱huán, chu̱ chuná̱ huánilh: —Huix cuanimá̱n, lacapala̱ cata̱qui, casacti̱ mimpu̱chaxna, chu̱ capittá̱ c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Pus yama̱ chixcú lacapala̱ tá̱qui̱lh, sacli̱ xpu̱chaxna hua̱ntu̱ xlá̱ xlacma̱, chu̱ álh c-xchic, xpa̱xcatcatzi̱niti̱lhama̱ Dios caj xpa̱lacata pi̱ xma̱pacsani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pacs ti̱ ucxilhko̱lh la̱ntla̱ ma̱pácsalh Jesús yama̱ chixcú, lanaj li̱lacahuanko̱lh xtascújut, chu̱ na̱ tzucuko̱lh pa̱xcatcatzi̱niy Dios; chu̱ cumu tla̱n xpe̱cuanko̱ni̱t chuná̱ tzucuko̱lh la̱huaniko̱y: —Xli̱ca̱na̱ la̱nchú̱ cucxilhni̱tahu lactlanca li̱ca̱cni xtascujut Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A̱li̱sta̱lh Jesús táxtulh c-chiqui, chu̱ la̱ntla̱ xtla̱huama̱ c-tiji̱ xlá̱ ma̱nóklhulh cha̱tum chixcú̱ hua̱nti̱ xma̱ta̱ji̱ko̱y chixcuhuí̱n laqui̱mpi̱ nalakaxoko̱naniko̱y gobierno xala c-Roma. Uma̱ chixcú̱ xuanicán Leví, antá̱ xlá̱ caj xuí̱ c-xlacati̱n chiqui̱ anta̱ni̱ luhua xlakaxoko̱nancán. Jesús chuná̱ huánilh: —Huix na̱ caquista̱lani. ");
INSERT INTO tosNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yama̱ Leví tuncán tá̱yalh, xli̱pacs hua̱ntu̱ xlá̱ xlakahui̱ akxtakuili̱ko̱lh, chu̱ sta̱lánilh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A̱li̱sta̱lh Leví tláhualh c-xchic aktum taca̱tani, laqui̱mpi̱ chuná̱ nali̱makapa̱xuhuay Jesús, hua̱mpi̱ na̱ chuná̱ lhu̱hua̱ xcompañeros minko̱lh hua̱nti̱ na̱ xma̱ta̱ji̱ko̱y tachixcuhuí̱tat nalakaxoko̱nanko̱y, chu̱ lhu̱hua̱ a̱makapitzi̱n chixcuhuí̱n hua̱nti̱ judíos xpuhuanko̱y pi̱ pacs xaktzanka̱ko̱ni̱t, chu̱ ni̱tú̱ xli̱ucxilhko̱cán, xlacán na̱ antá̱ pu̱tum xmakuilakó̱ c-pu̱hua̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hua̱mpi̱ makapitzi̱n fariseos, chu̱ laktzokni̱naní̱n hua̱nti̱ na̱ chuná̱ xta̱li̱catzi̱ko̱y, acxni̱ ucxilhko̱lh pu̱tum hua̱nti̱ xlá̱ xta̱hua̱ya̱ma̱kó̱ Jesús, xlacán tzucuko̱lh aksanko̱y, chu̱ chuná̱ huaniko̱lh xli̱ma̱kalhtahuaka̱t Jesús: —¿Tú̱huan huixín ta̱talakxtupi̱ko̱yá̱tit, chu̱ lacxtum ta̱hua̱yanko̱yá̱tit yama̱ xma̱ta̱ji̱nani̱n impuestos, xa̱hua̱ tama̱ makapitzi̱n lactlanca makla̱kalhi̱nani̱n chixcuhuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Hua̱mpi̱ Jesús xkaxmatma̱ hua̱ntu̱ xlacán xquilhuama̱kó̱, xlá̱ chuná̱ kalhti̱ko̱lh: —Ni̱tú̱ maclacasquima̱kó̱ ma̱cuchi̱ná̱ hua̱nti̱ tla̱n lama̱kó̱, hua̱nti̱ ni̱tú̱ kalhi̱ko̱y tajátat; pus huata huá̱ maclacasquinko̱y ma̱cuchi̱ná̱ hua̱nti ta̱tatlako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Pus quit ni̱ cmini̱t huaniko̱y nalakpali̱ko̱y xtalacapa̱stacnicán, chu̱ aksti̱tum nalatama̱ko̱y hua̱nti̱ puhuanko̱y lacuan chixcuhuí̱n, pus huata huá̱ cmini̱t huaniko̱y hua̱nti̱ catzi̱ko̱y pi̱ luhua makla̱kalhi̱naní̱n la̱ntla̱ aksti̱tum nalatama̱ko̱y c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Maktum makapitzí̱n chuná̱ kalhasquinko̱lh Jesús: —¿Tú̱huan hua̱nti̱ xli̱ma̱kalhtahuaka̱t Juan Bautista, xa̱hua̱ xli̱ma̱kalhtahuaka̱t fariseos ankalhí̱n makalhkajnanko̱y su kalhxtaknanko̱y, chu̱ lhu̱hua̱ tlahuako̱y xoración laqui̱mpi̱ chuná̱ li̱huana̱ naca̱cni̱naniko̱y Dios, hua̱mpi̱ hua̱nti̱ huix mili̱ma̱kalhtahuáka̱t ankalhí̱n hua̱ya̱ma̱kó̱, chu̱ ni̱ makalhkajnanko̱y? ");
INSERT INTO tosNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús chuná̱ kalhti̱ko̱lh: —¿Pi̱ cahuá̱ tla̱n nama̱makalhkajni̱ko̱yá̱tit makpa̱xuhuaní̱n nacpu̱tapu̱chuhu acxni̱ xli̱makua ta̱huilako̱lhcú̱ kahuasa li̱ta̱tahuílat? ");
INSERT INTO tosNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Hua̱mpi̱ namín quilhtamacu̱ acxni̱ nasputa̱ taca̱tani, chu̱ yama̱ kahuasa̱ nama̱pa̱nu̱cán, xta̱chuná̱ la̱ntla̱ quit naquiakspulay; pus acxnicú̱ a̱ma̱ quilhtamacú̱ xli̱ca̱na̱ xlacán namakalhkajnanko̱y ma̱squi ni̱tí̱ cali̱ma̱paksi̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chu̱ na̱ li̱xakatli̱ko̱lh aktum takalhchihuí̱n laqui̱mpi̱ nama̱lacatancsaniko̱y hua̱ntu̱ xlá̱ xuaniputunko̱y, chu̱ chuná̱ huaniko̱lh: —Ni̱ pala cha̱tum lama̱ hua̱nti̱ xti̱ta̱ mactum sasa̱sti lháka̱t laqui̱mpi̱ nali̱laktzapay mactum xalakuan talhaká̱n; sa̱mpi̱ lapi̱ chuná̱ natlahuay, caj nama̱laktzanka̱y xalakuan talhaká̱n, xa̱huachí̱ yama̱ xasa̱sti lháka̱t naactzu̱huanán, chu̱ luhua ni̱tlá̱n catitasíyulh hua̱ntu̱ nalaktzapacán. ");
INSERT INTO tosNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na̱ ti̱ni̱ muju̱y xasa̱sti vino c-xalakuan xmakxu̱hua borrego, sa̱mpi̱ hua̱ntu̱ nalay, yama̱ vino natzucuy catlán, chu̱ nama̱pankay yama̱ xalakuan xu̱hua, pus caj pá̱xcat nahuán xu̱hua, chu̱ na̱ chuna vino. ");
INSERT INTO tosNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pus huata xatlá̱n muju̱cán xaskata vino c-xasa̱sti xmakxu̱hua borrego, chu̱ chuná̱ lacxtum nata̱yaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Cha̱nchu̱ na̱ chuna li̱tum hua̱nti̱ li̱smani̱ni̱t ankalhí̱n huay xacatla vino, pus a̱li̱sta̱lh nia̱lh huaputún xaskata vino, chu̱ chuná̱ huan: ‘Luhua a̱tzinú̱ tla̱n xacatla vino.’ ");
INSERT INTO tosNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Maktum quilhtamacú̱, sábado xuani̱t, acxni̱ pacs judíos xjaxko̱y, Jesús xti̱yapuntaxtuma̱ anta̱ni̱ luhua tla̱n xchancani̱t trigo, hua̱mpi̱ xli̱ma̱kalhtahuáka̱t tzucuko̱lh puxti̱lhako̱y xatahuacat trigo, xlakpakxko̱y, chu̱ xuani̱niko̱y xatalhtzi. ");
INSERT INTO tosNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Makapitzi̱n fariseos ucxilhko̱lh, chu̱ chuná̱ kalhasquinko̱lh: —¿Tú̱huan huixín ni̱tú̱ li̱ucxilhni̱naná̱tit sa̱mpi̱ tlahuapá̱tit tama̱ tascújut acxni̱ pu̱tum quili̱jaxatcán? ");
INSERT INTO tosNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús kalhti̱ko̱lh: —¿Pi̱ hasta ni̱ pala hua̱ yuma̱ a̱li̱kalhtahuakayá̱tit la̱ntla̱ ti̱yataxtuni̱t xamaka̱n quilhtamacú̱? Luhua mili̱catzi̱tcán pi̱ maktum tílalh acxni̱ rey David xa̱hua̱ xcompañeros xtzincsni̱ma̱kó̱, ");
INSERT INTO tosNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","xlá̱ tánu̱lh c-xtemplo Dios, chu̱ tiyako̱lh xatasiculana̱tlahu caxtala̱nchu̱, chu̱ pu̱tum ta̱huako̱lh compañeros ma̱squi yama̱ caxtala̱nchu̱ ni̱ xli̱huatcán xuani̱t sa̱mpi̱ xma̱n hua̱ pa̱lijni̱ xmini̱niko̱y nahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús chuná̱ huanipalako̱lh yama̱ chixcuhuí̱n: —Chu̱ na̱ chuná̱ mili̱catzi̱tcán pi̱ quit, Xatalacsacni Chixcú, ckalhi̱y li̱ma̱paksí̱n laqui̱mpi̱ nacuaniko̱y tachixcuhuí̱tat hua̱ntu̱ xli̱tlahuatcán acxni̱ lakcha̱ni̱t sábado acxni̱ pacs jaxko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ni̱ li̱maka̱s li̱tum lakcha̱mpá̱ yama̱ quilhtamacu̱ sábado acxni̱ xli̱huancán pala tí̱ nascuja, Jesús tanu̱chá̱ c-aktum xpu̱kalhtahuakacan judíos, antá̱ xlá̱ tzúculh li̱akchihui̱nán xtachihui̱n Dios. Na̱ antá̱ xtanu̱ma̱ cha̱tum chixcú̱ hua̱nti̱ csca̱cniko̱ni̱t c-xpakstacat xmacán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hua̱mpi̱ na̱ antá̱ xtanu̱ma̱kó̱ makapitzi̱n fariseos, xa̱hua̱ laktzokni̱naní̱n, xlacán xmakskalama̱kó̱ Jesús laqui̱mpi̱ naucxilhko̱y pala nama̱pacsay yama̱ chixcú̱ acxni̱ xli̱huancán pala ti̱ nascuja, chu̱ laqui̱mpi̱ chuná̱ huij nahuán hua̱ntu̱ nali̱sta̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Hua̱mpi̱ xcatzi̱y xlá̱ hua̱ntu̱ xlacán xlacapa̱stacma̱kó̱, pus huá̱ xpalacata̱ chuná̱ li̱huánilh yama̱ hua̱nti̱ csca̱cniko̱ni̱t xmacán: —Cata̱ya, catát, chu̱ u̱nú̱ cata̱ya. Yama̱ chixcú̱ lali̱huán suácaj tá̱yalh, chu̱ talacatzúhui̱lh anta̱ni̱ xlaya̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesús chuná̱ huaniko̱lh makapitzi̱n chixcuhuí̱n: —Ucca̱kalhasquiná̱n kalhtum tachihuí̱n: ¿Tú̱ puhuaná̱tit tlak tla̱n tlahuacán sábado acxni̱ jaxcán? ¿Pi̱ hua̱ntu̱ tla̱n tatatlahu, usu huata hua̱ntu̱ ni̱tlá̱n? ¿Pi̱ tla̱n cahuá̱ namakta̱yaya̱hu pala tí̱ luhua tatlaji̱ma̱, usu ni̱ makta̱yama̱hu ma̱squi cani̱lh? ");
INSERT INTO tosNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús cacs lacaucxilhko̱lh pu̱tum hua̱nti̱ antá̱ xtanu̱ma̱kó̱ c-pu̱kalhtahuaka, chu̱ a̱li̱sta̱lh chuná̱ huánilh yama̱ chixcú: —Castonkti̱ mimacán. Yama̱ chixcú̱ chuná̱ stonkli, chu̱ acxnitiya tuncán cá̱xlalh la̱ntla̱ xmacasca̱cni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hua̱mpi̱ yama̱ chixcuhuí̱n ni̱ ma̱tla̱ni̱ko̱lh, chu̱ luhua tla̱n si̱tzi̱ko̱lh, chu̱ tzucuko̱lh la̱li̱xakatli̱ko̱y xatú̱ cahuá̱ tla̱n natlahuaniko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ni̱ maka̱s li̱tum maktum Jesús álh c-aktum ka̱stí̱n laqui̱mpi̱ antá̱ natlahuay oración, chu̱ tantascaca̱ antá̱ xakatli̱láca̱lh Dios la̱ntla̱ tláhualh xoración. ");
INSERT INTO tosNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Acxni̱ ca̱xkakako̱lh, Jesús tasaniko̱lh calakminko̱lh pu̱tum hua̱nti̱ csta̱lanima̱kó̱, chu̱ acxni̱ pu̱tum minko̱lh antá̱ xlá̱ lacsacko̱lh kalhacu̱tuy hua̱nti̱ li̱ma̱pa̱cuhui̱ko̱lh xapóstoles usu xtalakacha̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Yama̱ kalhacu̱tuy apóstoles hua̱nti̱ xlá̱ li̱lhca̱ko̱lh, chuná̱ xuaniko̱cán: Simón hua̱nti̱ Jesús li̱ma̱pa̱cúhui̱lh Pedro; Andrés xta̱la Simón; Santiago, chu̱ Juan; Felipe, xa̱hua̱ Bartolomé; ");
INSERT INTO tosNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, chu̱ Tomás; Santiago xkahuasa Alfeo; Simón hua̱nti̱ xta̱tapaksi̱ko̱y makapitzi̱n chixcuhuí̱n xuaniko̱cán Cananistas; ");
INSERT INTO tosNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas hua̱nti̱ xta̱la Santiago; chu̱ a̱cha̱tum Judas Iscariote hua̱nti̱ a̱li̱sta̱lh macamá̱sta̱lh Quimpu̱chinacan Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Acxni̱ Jesús takalhaju̱tahuilachi c-ka̱stí̱n, pu̱tum ta̱minko̱lh xli̱ma̱kalhtahuáka̱t c-aktum pu̱scan, hua̱mpi̱ li̱lhu̱hua tachixcuhuí̱tit cani̱huá̱ xalaní̱n antá̱ xminko̱ni̱t: makapitzí̱n xala c-Judea, xala c-Jerusalén, xa̱hua̱ hua̱nti̱ lahuilakó̱ c-xquilhtu̱n ta̱kaya̱huaná c-tíyat hua̱ntu̱ xuaniko̱cán Tiro, chu̱ Sidón. Pacs yuma̱ li̱lhu̱hua̱ caj xminko̱ni̱t kaxmatniko̱y xtachihuí̱n, chu̱ xa̱huachí̱ laqui̱mpi̱ nama̱pacsanicán xtajatatcán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesús na̱ xma̱pacsako̱y xli̱pacs hua̱nti̱ xpa̱laktaju̱ko̱ni̱t akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hua̱mpi̱ na̱ chuna li̱tum pi̱ Jesús xkalhi̱y li̱tlihuaka c-xmacni, xli̱pacs c-xamaniputunko̱y c-lháka̱t, chu̱ caxati̱cahuá̱ ti̱ macxamako̱lh, pacs pacsko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","A̱li̱sta̱lh Jesús cacs lacaucxilhko̱lh anta̱ni̱ xuilakó̱ xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: “Luhua li̱pa̱xuhu caca̱makcatzi̱cántit huixín hua̱nti̱ la̱nchú̱ lakli̱maxkaní̱n lapá̱tit ni̱tú̱ kalhi̱yá̱tit, sa̱mpi̱ namín quilhtamacú̱ acxni̱ pacs hua̱ntu̱ huilachá̱ antá̱ c-xtapaksi̱t Dios naca̱tapaksi̱niyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Luhua li̱pa̱xuhu caca̱makcatzi̱cántit huixín hua̱nti̱ la̱nchú̱ tzincstamakampá̱tit, sa̱mpi̱ namín quilhtamacú̱ acxni̱ huixín tla̱n nakalhkasá̱tit. “Luhua li̱pa̱xuhu caca̱makcatzi̱cántit huixín hua̱nti̱ la̱nchú̱ tasayá̱tit, sa̱mpi̱ namín quilhtamacú̱ acxni̱ huixín luhua tla̱n nali̱tzi̱ná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Luhua li̱pa̱xuhu caca̱makcatzi̱cántit huixín acxni̱ naca̱si̱tzi̱nicaná̱tit, acxni̱ cala̱hua̱ naca̱huanicaná̱tit, chu̱ naca̱lakmakancaná̱tit, chu̱ naca̱xcajnicaná̱tit acxni̱ naca̱lakmakanko̱yá̱n, chu̱ acxni̱ naxcajnicán mintucuhuinicán xta̱chuná̱ pala ni̱tla̱n chixcuhuí̱n huixín caj xpa̱lacata quili̱pa̱huaná̱tit quit, Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Huixín luhua capa̱xuhuátit yama̱ quilhtamacú̱ acxni̱ chuná̱ naca̱tlahuacaná̱tit, chu̱ ni̱ cali̱puhuántit, sa̱mpi̱ c-akapú̱n huixín naca̱ma̱skahui̱caná̱tit; pus luhua caj calacapa̱stáctit pi̱ na̱ chuná̱ xalakmaka̱n xquilhtzucutcán tlahuaniko̱lh profetas. ");
INSERT INTO tosNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Hua̱mpi̱ koxutaní̱n huixín ma̱tamacu̱naní̱n hua̱nti̱ huata huá̱ putzako̱y la̱ntla̱ nali̱pa̱xuhuako̱y xtumi̱ncán u̱nú̱ ca̱tuxá̱huat sa̱mpi̱ caj antiyá̱ naqui̱ta̱yay mintapa̱xuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Koxutaní̱n huixín hua̱nti̱ la̱nchú̱ li̱pa̱xuhuayá̱tit pi̱ kalhkaspá̱tit, sa̱mpi̱ namín quilhtamacú̱ acxni̱ natzincsá̱tit. “Koxutaní̱n huixín hua̱nti̱ la̱nchú̱ li̱pa̱xuhuayá̱tit pi̱ luhua tla̱n li̱tzi̱ná̱tit, sa̱mpi̱ namín quilhtamacú̱ acxni̱ caj xpa̱lacata mintali̱puhua̱ncán tla̱n natasayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Koxutaní̱n huixín hua̱nti̱ la̱nchú̱ lakatiyá̱tit pacs luhua lactla̱n chixcuhuí̱n naca̱li̱pu̱lhca̱caná̱tit acxni̱ ni̱ chuná̱ li̱taxtuyá̱tit, sa̱mpi̱ calacapa̱stáctit pi̱ hua̱nti̱ xalakmaka̱n minquilhtzucutcán na̱ chuná̱ xli̱pu̱lhca̱ko̱y yama̱ makapitzi̱n akskahuinani̱n profetas. ");
INSERT INTO tosNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Xli̱pacs huixín hua̱nti̱ kaxpatpá̱tit quintachihuí̱n, pus luhua caakatá̱kstit hua̱ntu̱ nacca̱huaniyá̱n: Huixín luhua capa̱xqui̱kó̱tit hua̱nti̱ ca̱ta̱la̱tlahuayá̱n, tla̱n cacatzi̱nikó̱tit, ma̱squi hua̱nti̱ naca̱xcajniko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cama̱tzanka̱nanikó̱tit, chu̱ tapa̱xuhuá̱n caca̱xakatlí̱tit hua̱nti̱ cala̱huá̱ naca̱huaniyá̱n, chu̱ na̱ capa̱lacasquinkó̱tit c-mioración pi̱ Dios calakalhamanko̱lh yama̱ hua̱nti̱ naca̱li̱kalhakama̱nanko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Lapi̱ tí̱ huix nalakxti̱kaxiyá̱n, ni̱ catamakapu̱spitni, huata xatlá̱n calakxti̱pinipala̱ mia̱lakxti̱tu̱ laqui̱mpi̱ nalakxti̱kaxipalayá̱n lapi̱ luhua chuná̱ puhuán. Chu̱ na̱ chuna li̱tum lapi̱ tí̱ namaklhti̱yá̱n mintamaknu, pus na̱ cama̱xqui̱ quilhtamacú̱ na̱ cale̱lh ma̱squi hua̱ mincamisa̱, ni̱ tilakcatzana. ");
INSERT INTO tosNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lapi̱ tú̱ nasquiniyá̱n cha̱tum, pus lapi̱ kalhi̱ya, cama̱xqui; chu̱ lapi̱ tí̱ namaklhti̱yá̱n hua̱ntu̱ milá, ni̱ cali̱huani. ");
INSERT INTO tosNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pus lacatancs cca̱huaniyá̱n pi̱ xli̱ankalhí̱n catlahuanikó̱tit li̱tlá̱n a̱makapitzí̱n xta̱chuná̱ la̱ntla huixín xlacasquíntit xca̱tlahuanikó̱n li̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Caquinca̱huanítit, lapi̱ huixín caj xma̱n huá̱ pa̱xqui̱ko̱yá̱tit hua̱nti̱ na̱ ca̱pa̱xqui̱ko̱yá̱n, ¿tú̱ chú̱ ya̱ li̱tlá̱n tlahuapá̱tit? Pus hasta ma̱squi hua̱nti̱ luhua lacli̱xcájnit xtapuhua̱ncán na̱ chuná̱ xlacán la̱ta̱lako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Usuchí̱ lapi̱ huixín caj xma̱n huá̱ tla̱n catzi̱niko̱yá̱tit hua̱nti̱ na̱ tla̱n ca̱catzi̱niyá̱n, ¿tú̱ ca̱cni̱ nali̱kalhi̱yá̱tit? Pus na̱ chuná̱ la̱ta̱lako̱y hua̱nti̱ luhua lacli̱xcájnit xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na̱ chuna li̱tum lapi̱ huixín xma̱n huá̱ ma̱sa̱cuani̱ko̱yá̱tit tumi̱n a̱má̱ hua̱nti̱ luhua catzi̱niyá̱tit pi̱ naca̱lakaxoko̱ni̱yá̱n, ¿tú̱ ca̱cni̱ nali̱kalhi̱yá̱tit? Pus na̱ chuná̱ xlacán la̱ma̱sa̱cuani̱ko̱y tumi̱n hua̱nti̱ luhua lacli̱xcájnit xtapuhua̱ncán, sa̱mpi̱ lacatancs catzi̱ko̱y pi̱ huí̱ tu̱ nama̱xqui̱ko̱cán a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Chí̱ hua̱mpi̱ capa̱xqui̱kó̱tit ma̱squi hua̱nti̱ luhua ca̱ta̱la̱tlahuayá̱n, chu̱ luhua tla̱n cacatzi̱nikó̱tit; chu̱ na̱ chuná̱ acxni̱ pala tú̱ nama̱sa̱cuani̱ko̱yá̱tit li̱ma̱xkaní̱n, ni̱ huá̱ calacapa̱stacnítit pala tú̱ luhua naca̱li̱xoko̱nanicaná̱tit. Pus chuná̱ huixín tla̱n namakamaklhti̱naná̱tit mintatlajancán c-akapú̱n, chu̱ Quintla̱tican Dios naca̱li̱pu̱lhca̱yá̱n la̱ xli̱ca̱na̱ xcamán. Sa̱mpi̱ Dios luhua tla̱n catzi̱niko̱y hasta ma̱squi hua̱nti̱ niucxni̱ pa̱xcatcatzi̱niko̱y hua̱ntu̱ xlá̱ ma̱xqui̱ko̱y, chu̱ na̱ chuná̱ hua̱nti̱ luhua lacli̱xcájnit xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pus na̱ chuná̱ huixín luhua tla̱n cacatzi̱nikó̱tit xli̱pacs tachixcuhuí̱tat, na̱ xta̱chuná̱ la̱ntla̱ Mintla̱tican Dios luhua tla̱n catzi̱niko̱y cati̱huá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Huixín ni̱ ankalhí̱n caputza̱nanítit xtala̱kalhí̱n a̱makapitzí̱n laqui̱mpi̱ tla̱n nali̱huaniko̱yá̱tit, laqui̱mpi̱ a̱li̱sta̱lh Dios na̱ ni̱ chuná̱ naca̱li̱putza̱naniyá̱n xli̱pacs hua̱ntu̱ tlahuani̱tántit mintala̱kalhi̱ncán, chu̱ na̱ chuná̱ chú̱ naca̱ma̱xoko̱ni̱yá̱n. Cala̱ma̱tzanka̱nanítit ni̱tlá̱n tu̱ la̱tlahuaniyá̱tit laqui̱mpi̱ Dios na̱ naca̱ma̱tzanka̱naniyá̱n mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Lapi̱ huí̱ cha̱tum tú̱ qui̱tzanka̱niy, chu̱ lapi̱ huix kalhi̱ya, pus cama̱xqui, chu̱ chuná̱ Dios na̱ naca̱ma̱xqui̱yá̱n hua̱ntu̱ huixín maclacasquiná̱tit. Xlá̱ tla̱n xatapu̱lhcá̱n naca̱pu̱ma̱xqui̱yá̱n hua̱ntu̱ tlanca mimpu̱xtokocán, tla̱n xatalhitjú̱n, na̱ xataxajni hasta natakalhmakán, chu̱ naca̱chiquiju̱niyá̱n, sa̱mpi̱ chuná̱ la̱ntla̱ xli̱lhu̱hua̱ nama̱xqui̱yá̱tit a̱makapitzí̱n acxni̱ tú̱ qui̱tzanka̱nima̱kó̱, Dios na̱ chuná̱ naca̱ma̱xqui̱yá̱n hua̱ntu̱ ca̱lakcha̱ná̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","A̱li̱sta̱lh Jesús li̱xakatli̱palako̱lh aktum talacapa̱stacni, chu̱ chuná̱ huaniko̱lh: “¿Lá̱ huixín puhuaná̱tit? ¿Pa̱ tla̱n cahuá̱ cha̱tum lakatzí̱n napakachipalé̱n cha̱tum xta̱lakatzí̱n? ¿Pi̱ ni̱ acxtum cahuá̱ catitantu̱huasko̱lh pu̱lhmá̱n pala naakchakxko̱y anta̱ni̱ ca̱li̱xcájnit? ");
INSERT INTO tosNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na̱ chuna li̱tum, cha̱tum hua̱nti̱ kalhtahuakamajcú̱ ni̱ lay a̱tzinu̱ li̱huacá̱ kalhi̱y xli̱skalala ni̱ xahuá̱ hua̱nti̱ xma̱kalhtahuaka̱ná, ma̱squi luhua xli̱ca̱na̱ acxni̱ xlá̱ nakalhtahuakako̱y ma̱x na̱ chuná̱ nakalhi̱y xli̱skalala xta̱chuná̱ la̱ntla̱ xma̱kalhtahuaka̱ná. ");
INSERT INTO tosNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Tú̱huan ucxilhniya̱ minta̱lá̱ palhma̱ tu̱ lacpi̱tanu̱ma̱, na̱ huata huix ni̱ tzinú̱ makcatzi̱ya̱ pala c-milakastapu̱ lacatanumá̱n tzinú̱ tlak tlanca palhma? ");
INSERT INTO tosNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Usu ¿lá̱ntla̱ nahuaniya̱ minta̱lá: ‘Ta̱lá, cakalkhakalhi, ucma̱xtuniyá̱n palhma̱ tu̱ tu̱ lacpi̱tanu̱má̱n, na̱ ni̱ cui̱ntaj tlahuaya̱ huix lhtacala̱ tu̱ lacpi̱tanu̱má̱n’? ¡Aksni̱ná! Pu̱lana̱ cama̱xtu̱ lhtacala̱ tu̱ lacpi̱tanu̱má̱n, laqui̱mpi̱ chuná̱ tla̱n nalacahuanana, chuna chi̱nchu̱ tla̱n nama̱xtuniya̱ palhma̱ minta̱lá̱ tu̱ lacpi̱tanu̱ma̱. Pus cumu ni̱ pala tzinú̱ catzi̱ya̱ pi̱ na̱ huí̱ hua̱ntu̱ lacatanu̱má̱n c-milakastapu, ¿lá̱ntla̱ chú̱ tla̱n nali̱huaniya̱ cha̱tum minta̱lá: ‘Ta̱lá, cakalhkalhi, uclacama̱xtuyá̱n tama̱ actzu̱ pokxni hua̱ntu̱ lacatanu̱má̱n c-milakastapu’? ¡Pus huix luhua aksani̱na̱ chixcú! Huata xatlá̱n pu̱laná̱ calacama̱xtuca̱ hua̱ntu̱ lacpi̱tanu̱má̱n, laqui̱mpi̱ chuná̱ tla̱n naucxilha, chu̱ chuná chi̱nchu̱ tla̱n nalacama̱xtuya̱ yama̱ pokxni̱ hua̱ntu̱ lacatanu̱ma̱ minta̱lá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pus na̱ chuna li̱tum, caj cali̱lacapa̱stáctit xtahuacatcan akatunu quihui: ni̱ pala aktum quihui̱ anán hua̱ntu̱ luhua xli̱ca̱na̱ tla̱n, pala natzucuy tahuacay xtahuácat hua̱ntu̱ ni̱ lacuán; chu̱ ni̱ pala akatum quihui hua̱ntu̱ ni̱ xatlá̱n, chu̱ natzucuy tahuacay hua̱ntu̱ luhua xalacuan xtahuácat. ");
INSERT INTO tosNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pus caj la̱ntla̱ akatunu quihui huá̱ li̱talakapasko̱y xtahuacatcán; sa̱mpi̱ ni̱ pala maktum tahuacay higo ca̱lhtucu̱ní̱n, ni̱ pala puxko̱cán uvas anta̱ni̱ lhnapako̱ni̱t huátzapu. ");
INSERT INTO tosNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pus na̱ chuná̱ chú̱ chixcuhuí̱n: hua̱nti̱ tla̱n xtapuhuá̱n cha̱tum chixcú, pus hua̱ li̱chihui̱nán hua̱ntu̱ lacuan tachihuí̱n, sa̱mpi̱ pacs huá̱ huí̱ c-xnacú̱; hua̱mpi̱ hua̱nti̱ ni̱tlá̱n xtapuhuá̱n, hua̱ xlá̱ li̱chihui̱nán hua̱ntu̱ luhua lacli̱xcajnit xtachihuí̱n, sa̱mpi̱ pacs huan tu̱ li̱xcájnit huí̱ c-xnacú̱. Sa̱mpi̱ hua̱ntu̱ li̱xcájnit huí̱ c-xnacú̱ cha̱tum chixcú, juerza nali̱chihui̱nán c-xquilhni. ");
INSERT INTO tosNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Tú̱ xlakasi̱ caj minquilhnicán quihuaniyá̱tit, ‘Huix Quimpu̱chiná’, acxni̱ ni̱ pala tzinú̱ tlahuayá̱tit hua̱ntu̱ quit cca̱li̱ma̱paksi̱yá̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chú̱ nacca̱huaniyá̱n hua̱ntu̱ xta̱chuná̱ yama̱ chixcú̱ hua̱nti̱ quista̱laniy, chu̱ li̱tzaksay tlahuay hua̱ntu̱ cuaniy: ");
INSERT INTO tosNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","pus luhua xta̱chuná̱ qui̱taxtuy la̱ cha̱tum chixcú̱ hua̱nti̱ tlahuay xchic, pu̱lana̱ huáxnalh pu̱lhmá̱n, chu̱ li̱huana̱ lacslamahuíli̱lh chíhuix anta̱ni̱ yá̱hualh xtalaya̱hu, chu̱ acxni̱ li̱pe̱cua̱ milh tlancaná, yama̱ chiqui̱ ni̱ pala tzinú̱ lacpa̱le̱nca̱, pus ni̱ lay nalacachiquiy sa̱mpi̱ pacs chíhuix xli̱ma̱quilhtzuquicanit xtalaya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Hua̱mpi̱ na̱ huilapalako̱lh makapitzi̱n chixcuhuí̱n hua̱nti̱ na̱ kaxmatko̱y hua̱ntu̱ cuan hua̱mpi̱ ni̱ li̱tzaksako̱y, xlacán luhua xta̱chuná qui̱taxtuy la̱ yama̱ chixcú̱ hua̱nti̱ tláhualh xchic, chu̱ ni̱ pala tlak pu̱lhmá̱n ma̱tí̱ju̱lh xtalaya̱hu, hua̱mpi̱ acxni̱ lákchilh tlihuaka tlancaná, yama̱ chiqui̱ lakapulonklhtáma̱lh, chu̱ nia̱lh tzinú̱ tasíyulh pala antá̱ xyá̱ chiqui.” ");
INSERT INTO tosNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cha̱nchu̱ pi̱ tima̱katspútulh xtachihuí̱n tu̱ xli̱chihui̱nanima̱kó̱ a̱ma̱ tachixcuhuí̱tat, xlá̱ alh c-Capernaum. ");
INSERT INTO tosNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Antá̱ ca̱chiquí̱n xlama̱ cha̱tum capitán hua̱nti̱ xpuxcucan tropa̱; hua̱ yuma̱ tropa̱ xuí̱ cha̱tum cscujni hua̱nti̱ luhua xpa̱xqui̱y, hua̱mpi̱ chú̱ a̱ma̱ scujni̱ luhua xta̱tatlay, snu̱n xuani̱t, luhua aya xni̱putún. ");
INSERT INTO tosNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Acxni̱ yama̱ tropa̱ makkáxmatli̱ li̱chihui̱nancán hua̱ntu̱ xtlahuay Jesús, pus xlá̱ ma̱lakacha̱ko̱lh judíos lakko̱lún, pi̱ naanko̱y huaniko̱y Jesús pi̱ luhua catláhualh li̱tlá̱n camilh ma̱pacsay cscujni. ");
INSERT INTO tosNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Cha̱nchu̱ xlacán, acxni̱ laktalacatzuhui̱ko̱lh Jesús, lacapala̱ squiniko̱lh li̱tlá̱n; huaniko̱lh: —Catlahua̱ li̱tlá̱n calakpi, sa̱mpi̱ tama̱ xapuxcu tropa̱ luhua mini̱niy pi̱ namakta̱yaya. ");
INSERT INTO tosNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Sa̱mpi̱ xlá̱ luhua akli̱huán ti̱ quin judíos, chu̱ xa̱huachí̱ hasta ma̱tlahuí̱nalh aktum quimpu̱kalhtahuakacán. ");
INSERT INTO tosNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús tla̱n tláhualh hua̱ntu̱ huaniko̱lh, chu̱ sta̱laniko̱lh. Hua̱mpi̱ acxni̱ aya xcha̱nko̱yá̱ c-chiqui, yama̱ xapuxcu tropa̱ macaminko̱lh makapitzí̱n xamigos pi̱ namincán pa̱xtokcán, chu̱ chuná̱ nahuanicán Jesús: “Quimpu̱chiná, xli̱ca̱na̱ huix luhua tla̱n catzi̱ya, hua̱mpi̱ ni̱ caacchichíjuanti, sa̱mpi̱ quit ni̱ pala tzinú̱ quimini̱niy natanu̱ya̱pi̱ c-quínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pus hasta huá̱ xpalacata ni̱ quit ma̱n clakanchá̱n. Pala xli̱ca̱na̱ quimakta̱yaputuna, huata caj xma̱n cali̱ma̱paksí̱nanti̱ laqui̱mpi̱ yama̱ quiscujni̱ napacsa. ");
INSERT INTO tosNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Sa̱mpi̱ luhua quit ckalhi̱y lactlanca quinapuxcún hua̱nti̱ ckalhakaxmatko̱y hua̱ntu̱ quili̱ma̱paksi̱ko̱y, hua̱mpi̱ na̱ chuná chú̱ quit na̱ huilakó̱ quintropa̱ hua̱nti̱ cma̱paksi̱ko̱y. Acxni̱ cuaniy cha̱tum: ‘Capimpi̱ a̱nú̱’, xlá̱ naán; chu̱ lapi̱ cha̱tum cuanipalay: ‘Lacapala̱ u̱nú̱ catat’, xlá̱ namín; chu̱ lapi̱ tú̱ nacli̱ma̱scujuy cha̱tum quintasa̱cua, xlá̱ chuná̱ natlahuay.” ");
INSERT INTO tosNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Acxni̱ káxmatli̱ Jesús yuma̱ tachihuí̱n, cacs lacaucxilhko̱lh pu̱tum hua̱nti̱ csta̱lanima̱kó̱, chu̱ chuná̱ huaniko̱lh: —Luhua lacatancs pi̱ la̱ntla̱ xli̱ca̱tlanca̱ yuma̱ xatiyat Israel, ni̱ ca̱ma̱noklhuy cha̱tum hua̱nti̱ luhua xli̱ca̱na̱ naquili̱pa̱huán xta̱chuná̱ la̱ntla̱ quili̱pa̱huán yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yama̱ chixcuhuí̱n hua̱nti̱ lacscujní̱n taspitko̱lh c-xchic xapuxcu tropa̱, hua̱mpi̱ acxni̱ cha̱nko̱lh ucxilhko̱lh pi̱ aya xtatla̱ni̱ni̱t yama̱ ta̱tatlá. ");
INSERT INTO tosNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A̱li̱sta̱lh Jesús xama̱ c-aktum ca̱chiquí̱n huanicán Naín, pacs xta̱ama̱kó̱ xli̱ma̱kalhtahuáka̱t, chu̱ na̱ chuná̱ csta̱lanima̱kó̱ lhu̱hua chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Acxni̱ aya xcha̱nko̱y lacatzú̱ ca̱chiquí̱n, úcxilhli̱ pi̱ xama̱ca̱ ma̱acnu̱cán cha̱tum ni̱n. Hua̱nti̱ xtzi̱ yuma̱ ni̱n puhuani̱ní̱ xuani̱t, xa̱huachí̱ a̱ma̱ pusca̱t caj luhua xma̱n hua̱ cha̱tum xkahuasa xuani̱t. Luhua lhu̱hua̱ ti̱ xala yama̱ ca̱chiqui̱n csta̱lanima̱kó̱ yama̱ pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Acxni̱ Quimpu̱chinacan Jesús úcxilhli, xli̱ca̱na̱ luhua snu̱n lakalhámalh, chu̱ chuná̱ huánilh: —Ni̱ catasa. ");
INSERT INTO tosNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús talacatzúhui̱lh anta̱ni̱ xle̱ma̱ca̱ yama̱ páklha̱t, chu̱ xámalh; chu̱ hua̱nti̱ xcucako̱ni̱t tachokoko̱lh. Jesús xakátli̱lh yama̱ ni̱n, chu̱ chuná̱ huánilh: —Kahuasa, quit cuanimá̱n: ¡Calakastakuánanti! ¡Cata̱qui! ");
INSERT INTO tosNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yama̱ kahuasa̱ hua̱nti̱ xni̱ni̱t, tahui̱ c-xpáklha̱t, chu̱ tzúculh chihui̱nán. A̱li̱sta̱lh Jesús qui̱pakatíyalh, chu̱ macamá̱xqui̱lh xtzi. ");
INSERT INTO tosNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Acxni̱ pacs li̱lhu̱hua̱ ucxilhko̱lh hua̱ntu̱ tláhualh Jesús tla̱n pe̱cuaxni̱ko̱lh, chu̱ tzucuko̱lh pa̱xcatcatzi̱niy Dios, makapitzí̱n chuná̱ xuanko̱y: —Luhua tlanca tali̱pa̱hu profeta yuma̱ chixcú̱ ti̱ quinca̱ta̱lamá̱n. Hua̱mpi̱ a̱makapitzí̱n chuná̱ xuanko̱y: —Dios quinca̱ucxilhlacachini̱tán quin xcamán, chu̱ macamini̱t ti̱ naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Puschí̱ xli̱pacs xli̱ca̱tlanca̱ c-xatiyat Judea, tuncán catzi̱ca̱ li̱ca̱cni tatlahu hua̱ntu̱ tlahuani̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautista cátzi̱lh la̱ntla̱ xli̱chihui̱nancán xtascujut Jesús, sa̱mpi̱ hua̱ xli̱ma̱kalhtahuáka̱t chuná̱ li̱xakatli̱ko̱lh. Xlá̱ xtanu̱ma̱ c-pu̱la̱chi̱n, chu̱ tasaniko̱lh cha̱tuy hua̱nti̱ xta̱lapu̱lako̱ni̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma̱lakacha̱naniko̱lh anta̱ni̱ xlama̱chá̱ Jesús laqui̱mpi̱ nakalhasquinko̱y lapi̱ xli̱ca̱na̱ huá̱ Cristo, hua̱nti̱ xli̱mínat xuani̱t, usuchí̱ natikalhi̱ko̱ycú̱ pala namincú̱ a̱cha̱tum. ");
INSERT INTO tosNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pus yama̱ chixcuhuí̱n acxni̱ lakcha̱nko̱lh, chuná̱ kalhasquinko̱lh: —Quinca̱macamimá̱n Juan Bautista laqui̱mpi̱ nacca̱kalhasquiná̱n pala mat xli̱ca̱na̱ huix Cristo hua̱nti̱ namín quinca̱lakma̱xtuyá̱n, usu natimincú̱ a̱li̱sta̱lh hua̱nti̱ luhua xli̱ca̱na̱ Cristo. ");
INSERT INTO tosNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Huatiya̱ yuma̱ quilhtamacú̱ acxni̱ xlacán chinko̱lh, xlacán xucxilhma̱kó̱ la̱ntla̱ Jesús xma̱pacsama̱kó̱ lhu̱hua ta̱tatlaní̱n, chu̱ na̱ chuná̱ hua̱nti̱ xkalhi̱ko̱y pala tú̱ tasoka̱lí̱n, xa̱hua̱ ti̱ xpa̱laktaju̱ko̱ni̱t cspiritu akskahuiní, chu̱ chuna li̱tum la̱ xma̱lacahua̱ni̱ma̱kó̱ lhu̱hua lakatzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A̱li̱sta̱lh acxni̱ tla̱n xucxilhko̱ni̱t li̱ca̱cni̱ xtascújut, pus chuná̱ huaniko̱lh Jesús hua̱ntu̱ luhua xcatziputunko̱y: —Capimpítit, chu̱ cali̱ta̱chihui̱nántit Juan hua̱ntu̱ huixín ucxílhtit, chu̱ hua̱ntu̱ kaxpáttit. Luhua pacs cama̱catzi̱ní̱tit Juan yuma̱ hua̱ntu̱ ucxilhni̱tántit, chu̱ kaxpatni̱tántit: pi̱ hua̱nti̱ lakatzi̱ní̱n xlama̱kó̱ chú̱ tla̱n lacahua̱nanko̱y; chu̱ hua̱nti̱ lu̱ntu̱nín xuanko̱ni̱t pacs tla̱n tla̱huanko̱y. Hua̱nti̱ xkalhi̱ko̱y yama̱ lacli̱xcajnit tzitzi huanicán lepra chú̱ pacs pacsma̱kó̱; na̱ chuná̱ hua̱nti̱ akata̱pa̱ xlama̱kó̱, pacs tla̱n kaxmatko̱y; chu̱ hasta makapitzi̱n hua̱nti̱ aya xni̱ko̱ni̱t lakastakuanama̱kó̱ ca̱li̱ní̱n, chu̱ hua̱nti̱ lakli̱ma̱xkaní̱n lama̱kó̱ li̱akchihui̱nanima̱ko̱ca̱ xtachihui̱n Dios hua̱ntu̱ nalakma̱xtuniko̱y xli̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hua̱mpi̱ na̱ cahuanítit pi̱ luhua li̱pa̱xuhu nalatama̱y yama̱ chixcú̱ hua̱nti̱ ni̱ naxlajuanán c-xtali̱pa̱huán acxni̱ aya catzi̱y xatí̱ luhua quit. ");
INSERT INTO tosNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Acxni̱ anko̱lhá̱ yama̱ chixcuhuí̱n hua̱nti̱ Juan Bautista xmacaminko̱ni̱t, Jesús tzúculh li̱chihui̱nán xpa̱lacata Juan, chuná̱ huaniko̱lh li̱lhu̱hua: “Acxni̱ tiqui̱laklátit Juan anta̱ni̱ xakchihui̱nama̱ c-desierto, ¿tú̱ luhua tiqui̱putzátit, usu xatú̱ luhua qui̱ucxilhputúntit? ¿Pi̱ qui̱ucxilhputúntit cha̱tum chixcú̱ ti̱ xta̱chuná̱ la̱ntla̱ kantum ká̱ti̱t tu̱ ni̱ tuhua̱ akxmu̱tya̱huama̱ u̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pus lapi̱ ni̱ chuná̱, ¿túcu chi̱nchu̱ qui̱ucxilhputúntit? ¿Pi̱ qui̱ucxilhputúntit cha̱tum chixcú̱ hua̱nti̱ luhua lacuán lháka̱t lhaka̱ni̱t? Tamá̱ ni̱ chuná, sa̱mpi̱ huixín catzi̱yá̱tit pi̱ hua̱nti̱ xalactapala̱xlá, chu̱ lacuan lháka̱t lhaka̱ko̱y, chu̱ luhua lakli̱lakáti̱t tasiyuko̱y, pus xlacán antá̱ huilakó̱ c-xchiccan lactlanca ma̱paksi̱naní̱n anta̱ni̱ ca̱tlá̱n nalatama̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Xalán ¿xatú̱ chi̱nchu̱ luhua qui̱putzátit? ¿Pa̱ hua̱ xucxilhputuná̱tit cha̱tum profeta? Lapi̱ huá̱ qui̱putzátit, pus li̱huaca̱ tla̱n sa̱mpi̱ quit luhua lacatancs cca̱huaniyá̱n pi̱ xli̱ca̱na̱ tama̱ aksti̱tum chixcú̱ hua̱nti̱ huixín qui̱ucxílhtit a̱tzinu̱ tlak tlanca xma̱xqui̱cani̱t xtascújut ni̱ xahua̱ la̱ xma̱xqui̱ko̱cani̱t xtascujutcan xli̱pacs xalakmaka̱n profetas. ");
INSERT INTO tosNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pus huatiya̱ tama̱ Juan Bautista hua̱nti̱ li̱chihui̱nán Dios c-xtachihuí̱n hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ anta̱ni̱ chuná̱ huan: ‘Pu̱lana̱ nacma̱lakacha̱y cha̱tum hua̱nti̱ napu̱laniyá̱n laqui̱mpi̱ xlá̱ naca̱xtlahuaniti̱lhayá̱n mintiji.’ ");
INSERT INTO tosNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Luhua xli̱ca̱na̱ quit cca̱huaniyá̱n pi̱ la̱ntla̱ xli̱pu̱tum chixcuhuí̱n hua̱nti̱ lacachinko̱ni̱t ca̱tuxá̱huat, ni̱ pala cha̱tum anani̱t hua̱nti̱ ma̱accha̱ni̱ni̱t xli̱tlanca Juan Bautista caj xpa̱lacata tlanca xtascújut tu̱ xma̱xqui̱cani̱t; hua̱mpi̱ ma̱squi chuná̱, na̱ mili̱catzi̱tcán pi̱ cati̱huá̱, ma̱squi ti̱ ni̱tu̱ xlakasi̱ hua̱nti̱ Dios namakamaklhti̱nán c-xasa̱sti xtapaksi̱t tu̱ namín, pus huata namakatlajapalacán Juan sa̱mpi̱ xlá̱ a̱tzinú̱ xali̱huacá̱ nali̱tapu̱tlakay xtascújut tu̱ ma̱xqui̱cani̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Cha̱nchu̱ xli̱pacs tachixcuhuí̱tat, hasta ma̱squi xma̱ta̱ji̱nani̱n impuestos hua̱nti̱ kaxmatniko̱lh xtachihui̱n Juan, chu̱ lacasquinko̱lh pi̱ naakmunuko̱y, chuná̱ li̱ma̱siyuko̱lh pi̱ hua̱ntu̱ Dios xlacasquín xpa̱lacatacán luhua talulóktat. ");
INSERT INTO tosNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Huampi̱ hua̱ fariseos, chu̱ laktzokni̱naní̱n hua̱nti̱ ni̱ xlacasquinko̱y naakmunuko̱cán, xlacán ni̱ ma̱tla̱ni̱ko̱lh hua̱ntu̱ Dios xma̱lacnu̱nima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Huanipalako̱lh: “¿Tú̱ cahuá̱ tla̱n nacta̱ma̱lacxtumi̱ko̱y yuma̱ tachixcuhuí̱tat hua̱nti̱ la̱nchiyu̱ quilhtamacú̱ lama̱kó̱? Usuchí̱, ¿xatú xta̱chuna̱ qui̱taxtuy? ");
INSERT INTO tosNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xlacán caj xta̱chuná̱ li̱taxtuko̱y la̱ntla̱ yama̱ lactzu̱ camán hua̱nti̱ ni̱ kalhakaxmatni̱nanko̱y, chu̱ hua̱nti̱ kama̱nantahuilako̱y c-tlanca̱ti̱, chu̱ chuná̱ quilhaniko̱y xta̱camán: ‘Pus ¿tú̱ luhua lacasquiná̱tit? Quin aya cca̱li̱skolinín lí̱skolh xtatlaknicán hua̱ntu̱ luhua lacli̱pa̱xuhu tantlí̱n, hua̱mpi̱ huixín ni̱ tantli̱yá̱tit; cca̱li̱quilhtli̱nín aktum tatlí̱n tu̱ li̱tli̱niko̱cán ni̱ní̱n, hua̱mpi̱ huixín ni̱ tasátit.’ ");
INSERT INTO tosNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Luhua xta̱chuná̱ li̱taxtuyá̱tit huixín, sa̱mpi̱ qui̱lachi̱ Juan Bautista c-milaksti̱pa̱ncán, xlá̱ ni̱ xlakati̱y án anta̱ni̱ xmakua̱yancán usu xmakkotnancán, cha̱nchu̱ huixín huaná̱tit pi̱ xkalhi̱y cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ni̱ li̱maka̱s quilhtamacú̱ cmimpá̱ quit, Xatalacsacni Chixcú, quit ctzúculh ta̱talakxtumi̱ko̱y hua̱nti̱ lakati̱ko̱y makua̱yanko̱y, chu̱ makkotnanko̱y, hua̱mpi̱ huata chú̱ huixín huampalayá̱tit pi̱ quit luhua tlanca xakotni, chu̱ caj luhua xma̱n hua̱ clacapa̱staca̱ la̱ntla̱ nacua̱yán, xa̱hua̱ quiamigos nactlahuako̱y hua̱nti̱ ma̱ta̱ji̱nanko̱y impuestos, chu̱ hua̱nti̱ luhua makla̱kalhi̱nani̱n chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Hua̱mpi̱ quit cca̱huaniyá̱n pi̱ la̱ntla̱ huí̱ xli̱skalalh Dios, antá̱ lacatancs li̱tasiyuma̱ xtascújut c-xlatáma̱t hua̱nti̱ xli̱ca̱na̱ akata̱ksma̱.” ");
INSERT INTO tosNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Maktum cha̱tum fariseo huánilh Jesús pi̱ caalh c-xchic laqui̱mpi̱ antá̱ nata̱hua̱yana̱chá. Jesús álh, chu̱ acxni̱ cha̱lh xlá̱ tahui̱ c-pu̱hua̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na̱ antá̱ ca̱chiquí̱n xlama̱ cha̱tum pusca̱t, hua̱mpi̱ xaaktzanka̱ta̱yán xuani̱t. Acxni̱ xlá̱ cátzi̱lh pi̱ Jesús xani̱t lakapaxia̱lhnán yama̱ fariseo, a̱ma̱ pusca̱t lacapala̱ má̱ca̱xli̱ pa̱tum lumi̱ta̱ xatla̱n perfume, chu̱ lí̱cha̱lh anta̱ni̱ xuí̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yama̱ koxuta pusca̱t lakatatzokóstalh c-xtantu̱n Jesús, chu̱ tzúculh lakatasay caj la̱ntla̱ xtali̱puhuá̱n, chu̱ la̱ntla̱ xtasama xlakpi̱xtájat xli̱lakchaka̱ma̱, chu̱ xacchíxit xli̱ma̱lacsca̱cama̱, chu̱ tzúculh tantu̱tzu̱ca; chu̱ a̱li̱sta̱lh li̱lactlahuapú̱xtulh c-xtuhuán yama̱ xatla̱n perfume. ");
INSERT INTO tosNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Uma̱ fariseo hua̱nti̱ xlakancani̱t c-xchic, xlá̱ xucxilhma̱ hua̱ntu̱ xtlahuama̱ yama̱ pusca̱t, chuná̱ xla̱ acstulacapá̱stacli: “Lapi̱ xli̱ca̱na̱ cahuá̱ Jesús hua̱ Dios macamini̱t, xlá̱ aya xcátzi̱lh xatú̱ ya̱ xtá̱yat yuma̱ pusca̱t hua̱nti̱ tantu̱xamama̱, sa̱mpi̱ tama̱ pusca̱t luhua xaaktzanka̱ta̱yán, chu̱ cati̱hua̱ chixcú̱ xakatli̱ko̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Hua̱mpi̱ Jesús chuná̱ huánilh yama̱ fariseo: —Simón, huí̱ actzu̱ tachihuí̱n hua̱ntu̱ cuaniputuná̱n. —Pus caquihuani, ma̱kalhtahuaka̱ná —kalhtí̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús chuná̱ huánilh: —Maktum xuí̱ cha̱tum chixcú, ma̱tamacu̱nú, hua̱nti̱ xma̱sa̱cuani̱nán tumi̱n, chu̱ cha̱tuy chixcuhuí̱n xma̱sa̱cuani̱ko̱ni̱t xtumi̱n; cha̱tum xlakahuilánilh akquitzis mi̱lh, chu̱ cha̱tum xlakahuilanipá̱ akquitzis ciento. ");
INSERT INTO tosNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hua̱mpi̱ cumu yama̱ chixcuhuí̱n ni̱ xanán tu̱ nali̱xoko̱naniko̱y, a̱ma̱ ma̱tamacu̱nú̱ ma̱tzanka̱naniko̱lh, chu̱ nia̱lh ma̱ta̱ji̱ko̱lh. Chú̱ huix, caquihuani, ¿xatí cahuá̱ a̱tzinú̱ tlak napa̱xqui̱y, napa̱xcatcatzi̱niy yama̱ chixcú̱ caj xpa̱lacata ma̱tzanka̱naniko̱lh? ");
INSERT INTO tosNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón chuná̱ kálhti̱lh: —Quit cpuhuán pi̱ ma̱x hua̱ yama̱ chixcú̱ hua̱ntu̱ a̱tzinú̱ luhua lhu̱hua̱ xlakahuilánilh, chu̱ ma̱tzanka̱nánilh. —Simón, luhua xli̱ca̱na̱ la̱ntla̱ huana —kálhti̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús cacs lakláca̱lh yama̱ pusca̱t, chu̱ chuná̱ huanipá̱ Simón: —Huix ucxílhpa̱t yuma̱ pusca̱t, hua̱mpi̱, ¿pi̱ xli̱ca̱na̱ akatá̱kspa̱t hua̱ntu̱ tlahuani̱t? Hua̱ xlá̱ lhu̱hua̱ tu̱ quimpa̱xcatzi̱nima̱. Hua̱mpi̱ ni̱ chuná̱ huix, sa̱mpi̱ acxni̱ ctitanu̱chi̱ c-mínchic, ni̱ pala tzinú̱ ma̱sta̱ chúchut tu̱ nacli̱cha̱chakán, hua̱mpi̱ xlá̱ aya quili̱cha̱chaka̱ni̱t xlakpi̱xtájat, chu̱ quili̱cha̱xacani̱t xacchíxit. ");
INSERT INTO tosNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huix ni̱ pala tzinú̱ púhuanti̱ pala naquilacatzu̱ca̱ acxni̱ cchilh, hua̱mpi̱ hasta acxni̱ xlá̱ tanu̱ni̱tanchi̱ c-mínchic tzucuni̱t quilactzu̱ca̱ quintantú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huix ni̱tú̱ quili̱actlahuápa̱t aceite c-quiakxe̱ka; hua̱mpi̱ hua̱ u̱ma̱ pusca̱t quili̱lactlahuapú̱xtulh xalacuan perfume c-quintantú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pus huá̱ xpalacata cli̱huaniyá̱n pi̱ la̱ntla̱ xli̱pu̱laclhu̱hua̱ hua̱ntu̱ xlá̱ li̱ma̱siyuma̱ xtapa̱xquí̱n, pus na̱ chuná̱ li̱tasiyuma̱ pi̱ la̱ntla̱ xli̱lhu̱hua̱ xtala̱kalhí̱n pacs ma̱tzanka̱nanicani̱t; hua̱mpi̱ hua̱nti̱ ni̱ luhua lhu̱hua̱ xtala̱kalhí̱n ma̱tzanka̱nanicán ni̱ luhua lhu̱hua̱ lakalhamán, chu̱ li̱pa̱xcatcatzi̱niy hua̱nti̱ ma̱tzanka̱nánilh. ");
INSERT INTO tosNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús chuná̱ huánilh yama̱ pusca̱t: —Xli̱pacs mintala̱kalhí̱n, quit cma̱tzanka̱naniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xli̱pacs hua̱nti̱ antá̱ xmakua̱ya̱ma̱kó̱ c-pu̱hua̱y, xlacán chuná̱ tzúculh la̱huaniy xacstucán: —¿Tú̱ xlakasi tama̱ chixcú? ¿Tú̱huan chuná̱ quilhpa̱tanu̱y pi̱ tla̱n ma̱tzanka̱nán tala̱kalhí̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Hua̱mpi̱ Jesús huanipá̱ yama̱ pusca̱t: —Luhua xli̱ca̱na̱ cuaniyá̱n, huix aya ma̱akapu̱taxtini̱ta̱ mili̱stacna sa̱mpi̱ quili̱pa̱huani̱ta, pus la̱nchú̱ luhua li̱pa̱xuhu capit c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A̱li̱sta̱lh Jesús álh latapu̱li̱y yama̱ lhu̱hua lactzu̱ ca̱chiquí̱n hua̱ntu̱ xuilakó̱ antá̱ lacatzú̱, xli̱akchihui̱nampu̱lay la̱ntla̱ Dios xuili̱putún xasa̱sti xtapáksi̱t ca̱tuxá̱huat, chu̱ pacs xta̱lapu̱lako̱y xkalhacu̱tuycan xapo̱stoles. ");
INSERT INTO tosNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Hua̱mpi̱ na̱ xta̱lapu̱lako̱y makapitzi̱n lacchaján hua̱nti̱ xlá̱ xma̱pacsaniko̱ni̱t xtajatatcán, chu̱ makapitzí̱n xca̱ma̱pacsani̱t acxni̱ xpa̱laktaju̱ko̱ni̱t cspiritu akskahuiní. Antá̱ xmaklatla̱huán María hua̱nti̱ xli̱ma̱pa̱cuhui̱cán Magdalena, hua̱ yuma̱ pusca̱t ti̱ xkalhiy xapu̱lana̱ kalhatujun cspiritu akskahuiní, hua̱mpi̱ Jesús xtamacaxtunini̱t; ");
INSERT INTO tosNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","chu̱ Juana hua̱nti̱ xpusca̱t xuani̱t Chuza, yuma̱ chixcú̱ hua̱ luhua xta̱scuja gobernador Herodes, xa̱hua̱ Susana, chu̱ lhu̱hua makapitzi̱n lacchaján hua̱nti̱ xlacán xli̱maktayale̱mako̱lh pala tú̱ xlacán xkalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cani̱hua̱ xalaní̱n hua̱nti̱ tamacxtumi̱ko̱lh laqui̱mpi̱ naucxilhko̱y Jesús, hua̱mpi̱ acxni̱ luhua lhu̱huatá̱ xtastokko̱ni̱t xlá̱ ca̱li̱xakatli̱ko̱lh aktum takalhchihuí̱n, chu̱ chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Maktum cha̱tum chana̱ná̱ álh chan xtalhtzi xli̱chánat. Acxni̱ xlá̱ cxpuyumakama̱ xli̱chánat, makapitzí̱n tama̱ko̱chá̱ c-tiji, hua̱mpi̱ cumu luhua lhu̱hua̱ ti̱ xtla̱huanko̱y antá, tla̱n lacta̱yami̱ko̱lh, chu̱ na̱ mimpalako̱chá̱ xlacán lactzu̱ spu̱n sacuaqui̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Makapitzi̱n xli̱chánat tama̱ko̱chá̱ ca̱chihuixni; acxni̱ xlacán pulhko̱lh, ni̱ ta̱yaniko̱lh, lacapálaj sca̱cko̱lh sa̱mpi̱ ni̱ xkalhi̱ko̱y chúchut hua̱ntu̱ nali̱stakanta̱yako̱y laqui̱mpi̱ tla̱n nastacko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Makapitzi̱n xli̱chánat tama̱ko̱chá̱ ca̱lhtacuní̱n, hua̱mpi̱ acxni̱ xlá̱ pulhli, chu̱ stacko̱lh lhtucú̱n, ma̱aklankanu̱ko̱lh sa̱mpi̱ luhua lhu̱hua̱ a̱ma̱ lhtucú̱n hua̱ntu̱ pulhko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hua̱mpi̱ makapitzi̱n xli̱chánat tama̱ko̱chá̱ c-xatla̱n tíyat, chu̱ acxni̱ stacko̱lh, luhua lhu̱hua̱ tahuácalh xtahuacatcán; huí̱ tu̱ xkalhi̱y aktum ciento caj la̱ntla̱ akatum quihui.” Acxni̱ huanko̱lh yuma̱ tachihuí̱n Jesús luhua pixtlanca̱ chuná̱ huaniko̱lh tachixcuhuí̱tat: “¡Lapi̱ huixín kaxpatpá̱tit quintachihuí̱n, pus caakatá̱kstit hua̱ntu̱ cuaniputún!” ");
INSERT INTO tosNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Caj li̱puntzú̱ xli̱ma̱kalhtahuaka̱t Jesús kalhasquinko̱lh xatú̱ luhua xuaniputún yama̱ xali̱ucxilhti̱t takalhchihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Xlá̱ chuná̱ kalhti̱ko̱lh: “Huixín xli̱ca̱na̱ pi̱ Dios ca̱ma̱catzi̱ni̱putuná̱n laqui̱mpi̱ naakata̱ksá̱tit hua̱ntu̱ ni̱tí̱ a̱catziy la̱ntla̱ lacapa̱stacni̱t nahuili̱y xasa̱sti xtapáksi̱t u̱nú̱ ca̱tuxá̱huat, hua̱mpi̱ hua̱ a̱makapitzi̱n tachixcuhuí̱tat acxni̱ cta̱ma̱lacastucni̱ko̱y hua̱ntu̱ tzinu̱ tuhua̱ akata̱kscán hua̱mpi̱ hua̱ntu̱ xlacán lakapasko̱y, xlacán ma̱squi caucxilhko̱lh hua̱ntu̱ nakantaxtuy chunatiyá̱ natamakaxtakko̱y xta̱chuná̱ la̱ ni̱tú̱ ucxilhma̱kó̱, chu̱ acxni̱ nakaxmatko̱y quintachihuí̱n ni̱tí̱ catiakata̱ksko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Pus chú̱ luhua li̱huana̱ cui̱ntaj catlahuátit, hua̱ na̱má̱ huaniputún a̱ma̱ takalhchihuí̱n hua̱ntu̱ cca̱huanín: Yama̱ li̱chánat, hua̱ huaniputún xtachihui̱n Dios; ");
INSERT INTO tosNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","chu̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ c-tiji, hua̱ li̱taxtuko̱y hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, hua̱mpi̱ acxni̱ mina̱chá̱ akskahuiní, pacs ma̱pa̱nu̱y yama̱ tachihuí̱n hua̱ntu̱ xuí̱ c-xnacu̱cán laqui̱mpi̱ ni̱ naca̱najlako̱y, chu̱ chuná̱ ni̱ naakapu̱taxtuko̱y xli̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Chi̱nchu̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ ca̱chihuixni, hua̱ li̱taxtuko̱y yama̱ hua̱nti̱ acxni̱ kaxmatko̱y xtachihui̱n Dios, luhua xli̱ca̱na̱ aktum tapa̱xuhuá̱n ca̱najlako̱y, lakati̱ko̱y, chu̱ tla̱n tlahuako̱y, hua̱mpi̱ cumu ni̱ pu̱lhmá̱n kalhi̱ko̱y xtankáxe̱ka̱ c-tíyat, chu̱ acxni̱ huí̱ tu̱ li̱talactuhuajko̱y, huata mejor caj talacapa̱nu̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Chi̱nchu̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ ca̱lhtucu̱ní̱n, huá̱ li̱taxtuko̱y hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, hua̱mpi̱ cumu tla̱n c-xlatama̱tcán, chunatiyá̱ xma̱n hua̱ li̱ta̱katzanka̱ko̱y catu̱huá̱ hua̱ntu̱ huí̱ xala ca̱tuxá̱huat, la̱ntla̱ nakalhi̱ko̱y lhu̱hua tumi̱n, usuchí̱ la̱ntla̱ xlacán a̱tzinú̱ luhua tla̱n li̱pa̱xuhu nalatama̱ko̱y, chu̱ na̱ chuná̱ chú̱ li̱ma̱aklankanu̱ko̱y tu̱ ca̱najlako̱ni̱t xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hua̱mpi̱ yama̱ li̱chánat hua̱ntu̱ tama̱ko̱chá̱ c-xatla̱n tíyat, pus xlacán huá̱ li̱taxtuko̱y yama̱ hua̱nti̱ luhua xli̱pacs xnacu̱cán li̱ca̱najlako̱y xtachihui̱n Dios, hua̱mpi̱ na̱ chuná̱ luhua maktum li̱tanu̱ko̱y pi̱ nama̱kantaxti̱ko̱y, chu̱ chuná̱ tzucuko̱y li̱tzaksako̱y, chu̱ pi̱ tla̱n xtalacapa̱stacnicán, pus chuná̱ li̱ma̱sta̱ko̱y lhu̱hua xtahuacatcán. ");
INSERT INTO tosNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Na̱ chuna li̱tum, la̱ntla̱ huixín catzi̱yá̱tit, ni̱ pala cha̱tum anán hua̱nti̱ la̱ nama̱pasi̱y aktum mákskot pala nali̱akpulonkxuili̱y tláminc, usu pala c-xtampi̱n pu̱tama̱ natamacanu̱y; hua̱mpi̱ huata tu̱ natlahuay, nahuili̱y anta̱ni̱ ta̱lhmá̱n laqui̱mpi̱ xli̱pacs hua̱nti̱ natanu̱ko̱y c-chiqui naucxilhko̱y mákskot. ");
INSERT INTO tosNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na̱ chuná̱ ni̱tú̱ anán pala tú̱ caj tze̱k huí̱ xpa̱lacata xtapáksi̱t Dios pala ni̱ juerza pacs nacatzi̱cán, chu̱ na̱ chuná̱ pala tu̱ tze̱k li̱tacatzi̱y hua̱ lapi̱ ni̱ huá̱ xpalacata lacatzucu̱ natacatzi̱y, chu̱ pala ni̱ ca̱lakuá̱n natahuilay. ");
INSERT INTO tosNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Pus huá̱ cca̱li̱huaniyá̱n, luhua xli̱ca̱na̱ cui̱ntaj catlahuátit hua̱ntu̱ la̱nchú̱ cca̱huanimá̱n, sa̱mpi̱ hua̱nti̱ laktzaksay akata̱ksa̱ hua̱ntu̱ kalhi̱y, a̱tzinú̱ natima̱xqui̱cancú̱ ta̱kata̱ksni; hua̱mpi̱ hua̱nti̱ ni̱ tzaksaputún maclacasquín hua̱ntu̱ kalhi̱y, xlá̱ namaklhti̱ko̱cán hasta ma̱squi xma̱n hua̱ hua̱ntu̱ xlá̱ kalhi̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Maktum acxni̱ Jesús xkalhchihui̱nama̱ c-aktum chiqui, chinko̱lh xtzi, xa̱hua̱ xnata̱lán, hua̱mpi̱ xlacán ni̱ lay xtanu̱ko̱ya̱chá̱ sa̱mpi̱ luhua lhu̱hua̱ xtzamacán. ");
INSERT INTO tosNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Cha̱tum huánilh Jesús: —Mintzí, xa̱hua̱ minata̱lán putzama̱kó̱n, sa̱mpi̱ mat ta̱chihui̱namputunko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús chuná̱ huaniko̱lh hua̱nti̱ antá̱ xta̱tanu̱ma̱kó̱: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ xli̱pacs hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, chu̱ li̱tzaksako̱y hua̱ntu̱ xlá̱ li̱ma̱paksi̱ko̱y, pus xli̱ca̱na̱ hua̱ tamá̱ quintzí, xa̱hua̱ quinata̱lán. ");
INSERT INTO tosNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tílalh maktum pi̱ Jesús ta̱taju̱ko̱lh xli̱ma̱kalhtahuáka̱t c-aktum pu̱tacutnu, sa̱mpi̱ xlá̱ huaniko̱lh pi̱ xamputún c-xa̱quilhtu̱tu ta̱kaya̱huaná, chu̱ lacapala̱ taca̱xko̱lh, chu̱ anko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cha̱nchu̱ pi̱ xli̱makua xpa̱tacutnama̱kó̱ c-chúchut, Jesús lhtatatáma̱lh c-pu̱tacutnu. Chu̱ acxni̱ aya c-xíta̱t xanko̱ya̱chá̱ c-ta̱kaya̱huaná luhua palha u̱n tahuilachi̱ hasta tzúculh taju̱y chúchut, chu̱ a̱tzinú xuani̱t aya xtakalhtzamay, chu̱ xlaktzanka̱putún c-chúchut. ");
INSERT INTO tosNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yama̱ xli̱ma̱kalhtahuáka̱t lakanko̱lh anta̱ni̱ xmá̱; ma̱lakastakuani̱ko̱lh, chu̱ chuná̱ huaniko̱lh: —¡Ma̱kalhtahuaka̱ná, cata̱qui sa̱mpi̱ mu̱xtuma̱hu! Jesús tá̱qui̱lh, chu̱ li̱ma̱paksi̱ko̱lh yama̱ ú̱n, chu̱ ta̱kaya̱huaná̱ pi̱ catácacsli, pus pu̱tum cacs tahuilako̱lh, chu̱ na̱ luhua tácacsli̱ chúchut. ");
INSERT INTO tosNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —¿Ní chú̱ álh mintaca̱najlacán pi̱ huixín huaná̱tit pi̱ xli̱ca̱na̱ quili̱pa̱huaná̱tit? Hua̱mpi̱ cumu xlacán luhua tla̱n xpe̱cuankoni̱t, caj cacs xli̱lacahuanko̱y, chu̱ xacstucán chuná̱ xla̱kalhasquinko̱y: —Pus ¿tú̱ cahuá̱ li̱tlihuaka̱ kalhi̱y yuma̱ chixcú̱ pi̱ ma̱squi hua̱ u̱n, chu̱ ta̱kaya̱huaná lakachixcuhui̱ko̱y acxni̱ xlá̱ ma̱paksi̱ko̱y? ");
INSERT INTO tosNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Acxni̱ pa̱tacutko̱lh ta̱kaya̱huaná, cha̱nko̱lh c-aktum tíyat huanicán Gadara, pi̱ li̱quilhtu̱án xuilachá xata̱kaya̱huana Galilea. ");
INSERT INTO tosNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Acxni̱ Jesús tácutli̱ c-pu̱tacutnu, tuncán milh pa̱xtoka̱ cha̱tum chixcú̱ antá̱ xalá. Yama̱ chixcú maka̱sá la̱ntla̱ xma̱lakahuiti̱ni̱t cspiritu akskahuiní, xa̱huachí̱ xlá̱ ni̱ xlhaka̱nán, chu̱ ni̱ pala maktum lacatum xtahuilay c-aktum chiqui, huata caj xca̱tasatapu̱li̱y c-xtampi̱n sipi̱ anta̱ni̱ xma̱acnu̱ko̱cán ni̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Maklhu̱hua̱ tzaksako̱lh ti̱ antá̱ xalaní̱n, xchi̱huili̱putunko̱y a̱ma̱ chixcú̱ laqui̱mpi̱ lacatum natahuilay, chu̱ xli̱chi̱huili̱ko̱y cadenas c-xca̱macaní̱n, xa̱hua̱ c-xca̱tantu̱ni̱n, hua̱mpi̱ cumu yama̱ cspiritu akskahuiní xma̱xqui̱y xli̱tlihuaka, pacs xlacputxko̱y, chu̱ mákat xtza̱lay, xán c-desierto anta̱ni̱ tzili̱s ca̱huán. Acxni̱ xlá̱ lákcha̱lh Jesús, xlá̱ tuncán huánilh yama̱ cspiritu akskahuiní̱ pi̱ camakáxtakli̱ yama̱ chixcú, hua̱mpi̱ xlá̱ lakatatzokóstalh Jesús, chu̱ chuná̱ huánilh: —¿Tú̱ xpa̱lacata quinca̱li̱soka̱li̱ya? Quit ccatzi̱y pi̱ huix Jesús xkahuasa tlanca xlacatzucut Dios, xa̱huachí̱ huix caj quinca̱ma̱pa̱ti̱ni̱putuna; pus luhua catlahua̱ tlanca li̱tlá̱n ni̱ caquinca̱ma̱pa̱ti̱ni. ");
INSERT INTO tosNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús chuná̱ kalhásquilh yama̱ cspiritu akskahuiní: —¿Tú̱ mintucuhuiní̱ kalhi̱ya? Xlá̱ kalhtí̱nalh: —Quinca̱li̱ma̱pa̱cuhui̱caná̱n Legión. Huá̱ chuná̱ xlá̱ li̱kalhtí̱nalh sa̱mpi̱ yama̱ cspiritu akskahuiní̱ luhua clhu̱huacán xuanko̱ni̱t hua̱nti̱ xpuxcu̱naniko̱ni̱t yama̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yama̱ cspiritucan akskahuiní squiniko̱lh li̱tlá̱n Jesús pi̱ ni̱ namaca̱nko̱y c-pu̱pa̱tí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Antá̱ lacatzú̱ c-ka̱stí̱n xputxua̱yantla̱huanko̱y lhu̱hua paxni, pus xlacán huaniko̱lh pi̱ cama̱xqui̱ko̱lh talacasquín napa̱laktaju̱ko̱y yama̱ paxni. Jesús ma̱xqui̱ko̱lh talacasquín. ");
INSERT INTO tosNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ma̱n hua̱ lacasquiniko̱lh Jesús, taxtuko̱lh yama̱ lhu̱hua̱ cspiritu akskahuiní, aya pa̱laktaju̱ko̱lh paxni, pero yuma̱ kampu̱tum paxni tzucuko̱lh kosnanko̱y, anko̱lh lacatum anta̱ni̱ luhua c-xuástat, antá̱ chu̱ taju̱ko̱chá̱ c-chúchut, chu̱ jicsuako̱lh c-ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cha̱nchu̱ hua̱nti̱ xmaktakalhma̱kó̱ paxni, acxni̱ ucxilhko̱lh hua̱ntu̱ xlani̱t, caj la̱ xtape̱cuacán takosú̱n tza̱lako̱lh, chu̱ cati̱huá̱ tzucuko̱lh ta̱li̱chihui̱nanko̱y ti̱ xlacán xma̱noklhuko̱y ca̱chiquí̱n, chu̱ ca̱pu̱cuxtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Puschí̱ lhu̱hua̱ ti̱ anko̱lh ucxilhko̱y hua̱ntu̱ xqui̱taxtuni̱t. Acxni̱ xlacán cha̱nko̱lh anta̱ni̱ xuí̱ Jesús, ucxilhko̱lh chixcú̱ ti̱ xapu̱lana̱ xkalhi̱y yama̱ kampu̱tum cspiritu akskahuiní, antá̱ xlá̱ cajá xuí̱ c-xtuhuan Jesús, tla̱n xlhaka̱nani̱t, na̱ luhua actancsá xuí̱ c-xtalacapa̱stacni. Hua̱mpi̱ xlacán pe̱cuanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Makapitzí̱n hua̱nti̱ luhua xucxilhko̱ni̱t hua̱ntu̱ xlani̱t, tzucuko̱lh li̱chihui̱nanko̱y la̱ntla̱ Jesús xma̱pacsani̱t chixcú̱ hua̱nti̱ xkalhiy cspiritu akskahuiní, chu̱ xpa̱lacatacan paxni. ");
INSERT INTO tosNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pus huá̱ xpalacata, yama̱ chixcuhuí̱n hua̱nti̱ xala c-Gadara squiniko̱lh li̱tlá̱n Jesús pi̱ catatampú̱xtulh c-xtiyatcán sa̱mpi̱ luhua xpe̱cuaniko̱y. Jesús juerza táju̱lh c-pu̱tacutnu, chu̱ álh a̱lacatanu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Cha̱nchu̱ yama̱ chixcú̱ hua̱nti̱ xtaxtuniko̱ni̱t akskahuiní̱n, huánilh Jesús pi̱ camá̱xqui̱lh talacasquín na̱ nasta̱laniy, hua̱mpi̱ Jesús li̱ma̱páksi̱lh pi̱ catamakáxtakli̱, chu̱ chuná̱ huánilh: ");
INSERT INTO tosNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Huata xatlá̱n huix catáspitti̱ c-mínchic, chu̱ cati̱huá̱ cali̱xakatli̱kó̱ xpa̱lacata tlanca li̱tlá̱n tu̱ tlahuanini̱tán Dios. Yama̱ chixcú̱ xlá̱ álh, chu̱ cati̱huá̱ li̱xakatli̱ko̱lh la̱ntla̱ Jesús xma̱pacsani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Acxni̱ Jesús tacutpalachá̱ c-xa̱quilhtu̱tu ta̱kayahuaná, la̱ntla̱ xli̱lhu̱hua tachixcuhuí̱tat luhua cha̱pa̱xuhua̱na̱ qui̱pa̱xtokko̱lh sa̱mpi̱ xlacán aya xkalhkalhi̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na̱ acxnitiyá̱ chilh cha̱tum chixcú̱ xuanicán Jairo; yuma̱ chixcú̱ luhua tali̱pa̱hu xuani̱t, chu̱ na̱ luhua xpuxcu̱naniko̱y c-xpu̱kalhtahuacan judíos hua̱ntu̱ xuí̱ c-Capernaum. Acxni̱ xlá̱ lákcha̱lh, lakatatzokóstalh c-xlacati̱n Jesús, chu̱ huánilh pi̱ catláhualh li̱tlá̱n catá̱alh c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sa̱mpi̱ xuí̱ caj xma̱n cha̱stum xtzuma̱t, xlá̱ cajcu̱ akcu̱tuy ca̱ta̱ xkalhi̱y, hua̱mpi̱ chú̱ xta̱tatlay, chu̱ luhua snu̱n xuaní̱t, xni̱majá. Acxni̱ Jesús xta̱amajá, luhua li̱lhu̱hua̱ sta̱laniko̱lh c-tiji, chu̱ hasta xla̱lacxquititi̱lhako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cha̱nchu̱ na̱ antá̱ csta̱lama̱ cha̱tum pusca̱t, hua̱mpi̱ xlá̱ xkalhi̱y aktum tajátat, chu̱ cstajmakama̱ kalhni, ma̱x pala aya xle̱ma̱ xli̱akcu̱tuy ca̱ta̱ la̱ntla̱ xlá̱ chuná̱ xtzucuni̱t, chu̱ pacs tu̱ xkalhi̱y xtumi̱n aya xli̱lactlahuami̱ko̱ni̱t caj la̱ntla̱ xma̱cuchi̱ma̱kó̱ ma̱cuchi̱naní̱n; hua̱mpi̱ ni̱ pala cha̱tumá̱ ti̱ luhua xma̱pacsalh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yama̱ pusca̱t c-xcha̱ka̱n Jesús tze̱k minchá̱, chu̱ xamánilh c-xtampaksta̱n xlháka̱t, pus acxnitiyá tuncán tachókolh la̱ntla̱ xlá̱ cstajmakama̱ kalhni. ");
INSERT INTO tosNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús tachókolh, chu̱ chuná̱ kalhasquiní̱nalh: —¿Tí̱ xámalh quilháka̱t? Hua̱mpi̱ cumu ni̱ pala cha̱tum kalhtasiyúnilh pala tí̱ xámalh, Pedro chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, huix ucxílhpa̱t pi̱ luhua tzamacán, chu̱ la̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat lacatum lacatum toklhma̱kó̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hua̱mpi̱ Jesús chuná̱ huá̱: —Hua̱mpi̱ huí̱ cha̱tum hua̱nti̱ kas chuná̱ tze̱k quintoklhni̱t, sa̱mpi̱ tla̱n cmakcátzi̱lh pi̱ huí̱ hua̱nti̱ cli̱ma̱pácsalh quili̱tlihuaka la̱nchiyú̱. ");
INSERT INTO tosNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yama̱ pusca̱t acxni̱ xlá̱ cátzi̱lh pi̱ xma̱noklhucani̱t, laktalacatzúhui̱lh, hua̱mpi̱ caj clhpipiti̱lhay milh, lakatatzokóstalh c-xlacati̱n Jesús, chu̱ talaksiyúnilh c-xlacati̱ncán xli̱pacs tachixcuhuí̱tat xatú̱ xpa̱lacata̱ xli̱xamanini̱t xlháka̱t; chu̱ huánilh pi̱ la̱ xamánilh xlháka̱t tuncán tatlá̱ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús chuná̱ huánilh: —Na̱na̱, huix aya tatla̱ni̱ni̱ta, sa̱mpi̱ luhua xli̱ca̱na̱ quili̱pá̱huanti, pus chu̱ luhua cha̱pa̱xuhua̱na̱ capit c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús chunacú̱ xchihui̱nama̱ acxni̱ chilh cha̱tum lacscujni, xlá̱ antá̱ minchá̱ c-xchic Jairo, chu̱ chuná̱ huánilh: —Huata ma̱x nia̱lh xma̱makapali̱ Quimpu̱chinacán, sa̱mpi̱ mintzuma̱t aya ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Hua̱mpi̱ káxmatli̱ Jesús tu̱ xquilhuama̱, chu̱ chuná̱ huánilh Jairo: —Huix luhua xli̱ca̱na̱ caquili̱pá̱huanti, chu̱ ni̱ capé̱cuanti, sa̱mpi̱ yama̱ mintzuma̱t natatla̱ni̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Acxni̱ cha̱nko̱lh cchiqui, ti̱ni̱ xatí̱ lacasquínilh nata̱tanu̱y, huata caj xma̱n huá̱ ta̱tanu̱ko̱lh Pedro, Santiago, chu̱ Juan, xa̱hua̱ xtzi, chu̱ xtla̱t yama̱ tzuma̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","La̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat pacs xtasama̱kó̱, chu̱ xli̱puhuama̱kó̱, hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —Ni̱ catasátit sa̱mpi̱ tama̱ tzuma̱t ni̱tú̱ ni̱ma̱, pus xlá̱ caj lhtatama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Hua̱mpi̱ xlacán caj li̱li̱tzi̱nko̱lh hua̱ntu̱ huaniko̱lh sa̱mpi̱ xlacán lacatancs xcatzi̱ko̱y pi̱ xni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Acxni̱ cha̱lh anta̱ni̱ xlá̱ xmá̱ yama̱ tzuma̱t, xlá̱ macachípalh, chu̱ palha̱ chuná̱ huánilh: —¡Tzuma̱t, cata̱qui! ");
INSERT INTO tosNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Caj la̱ntla xakátli̱lh, yama̱ tzuma̱t lakastakuánalh, chu̱ tuncán tá̱qui̱lh. A̱li̱sta̱lh Jesús huaniko̱lh pi̱ cama̱hui̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Cha̱nchu̱ xtla̱t, chu̱ xtzi, caj luhua cacs xli̱lacahuanko̱y hua̱ntu̱ xtlahuani̱t, hua̱mpi̱ Jesús tili̱ma̱paksi̱ko̱lh pi̱ ti̱ni̱ nahuaniko̱y hua̱ntu̱ xlá̱ xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maktum Jesús ma̱makstokko̱lh kalhacu̱tuy xli̱ma̱kalhtahuáka̱t, chu̱ macama̱xqui̱ko̱lh li̱tlihuaka, chu̱ li̱ma̱paksí̱n laqui̱mpi̱ tla̱n nama̱pacsako̱y ti̱pa̱lhu̱hua tajátat, chu̱ natamacaxtuko̱y cspiritu akskahuiní c-xtiyatli̱huacan hua̱nti̱ xakchipako̱ni̱t xtalacapa̱stacnicán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Huá̱ luhua li̱ma̱lakacha̱ko̱lh laqui̱mpi̱ nali̱akchihui̱nanko̱y la̱ntla̱ Dios xma̱tzuqui̱putún xasa̱sti xtapáksi̱t ca̱tuxá̱huat, chu̱ laqui̱mpi̱ nama̱pacsako̱y pacs hua̱nti̱ ta̱tatlako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Acxni̱ ni̱ xa̱anko̱y chuná̱ huaniko̱lh: —Ni̱tú̱ tili̱piná̱tit hua̱ntu̱ namaclacasquiná̱tit c-tiji, xta̱chuna̱ pala mili̱xtokocán, na̱ ni̱ pala mimpu̱xtokocán, ni̱ pala hua̱ntu̱ nahuayá̱tit, ni̱ pala mintumi̱ncán. Caj xma̱n hua̱ cali̱pítit milhaka̱tcán hua̱ntu̱ lhaka̱ni̱tántit, chu̱ ni̱ cali̱pítit macatiyú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chu̱ anta̱ni̱ nachipiná̱tit c-aktum ca̱chiquí̱n caputzátit huixín aktum chiqui̱ anta̱ni̱ naca̱ma̱nu̱caná̱tit, antá̱ natamakaxtaká̱tit hasta ni̱li̱huayá̱ nataca̱xpalayá̱tit napiná̱tit a̱lacatanu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Hua̱mpi̱ anta̱ni̱ ni̱ naca̱makamaklhti̱nancaná̱tit, pus lacapala̱ cataxtútit yama̱ ca̱chiquí̱n, chu̱ acxni̱ nataxtuyá̱tit catincxmakántit pokxni̱ hua̱ntu̱ ca̱lactahuacán c-mintantu̱ncán laqui̱mpi̱ chuná̱ naucxilhko̱y yama̱ chixcuhuí̱n pi̱ nia̱lh mincuentajcán lapi̱ naaktzanka̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Cha̱nchu̱ xlacán taca̱xko̱lh, chu̱ lacaxtum anko̱lh c-lactzu̱ ca̱chiquí̱n, xli̱akchihui̱nampu̱lako̱y xtachihui̱n Dios la̱ntla̱ xlá̱ xlakma̱xtuputunko̱y tachixcuhuí̱tat, chu̱ na̱ chuná̱ xma̱pacsako̱y cati̱huá̱ hua̱nti̱ xkalhi̱ko̱y caxatu̱cahua̱ tajátat. ");
INSERT INTO tosNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Milh quilhtamacú̱ acxni̱ yama̱ tlanca ma̱paksi̱na Herodes cátzi̱lh la̱ntla̱ xli̱chihui̱nancán lhu̱hua̱ lactlanca tascújut tu̱ xtlahuama̱ Jesús, hua̱mpi̱ xlá̱ ni̱ xcatzi̱y xatú̱ luhua naca̱najlay sa̱mpi̱ huí̱ ti̱ xuan pi̱ mat Juan Bautista xlakastakuanani̱t ca̱li̱ní̱n, ");
INSERT INTO tosNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","hua̱mpi̱ makapitzí̱n huí̱ ti̱ xuanko̱y pi̱ mat huá̱ profeta Elías, xastacna xmimpalani̱t ca̱tuxá̱huat, chu̱ makapitzí̱n xuampalako̱y pi̱ ma̱x ni̱ tzanka̱y tí̱ profeta hua̱nti̱ xlama̱kó̱ xamaká̱n quilhtamacú̱, hua̱mpi̱ chú̱ mat xlá̱ xlakastakuanani̱t ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hua̱mpi̱ gobernador Herodes chuná̱ xuán: —Pus ¿tí̱ cahuá̱ tama̱ chixcú hua̱nti̱ huancán pi̱ mat luhua tlahuako̱y lactlanca, chu̱ li̱ca̱cni tatlahu? Sampi̱ yama̱ Juan Bautista quit luhua ma̱n cma̱pixca̱acti̱nani̱t xakxeka. Chu̱ cumu Herodes ni̱ xlakapasa̱ Jesús, luhua juerza xlakapasputún. ");
INSERT INTO tosNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Acxni̱ yama̱ kalhacu̱tuy apóstoles, usu tama̱lakachá̱n qui̱taspitko̱lh, tzucuko̱lh li̱ta̱kalhchihui̱nán Jesús pacs hua̱ntu̱ xtlahuako̱ni̱t, chu̱ qui̱taxtuko̱ni̱t, hua̱mpi̱ xlá̱ lacatanu̱ le̱nko̱lh, caj c-xpa̱nú̱tat, lacatum anta̱ni̱ tzili̱s ca̱huán, pus antá̱ cha̱nko̱lh lacatzú̱ c-aktum ca̱chiquí̱n huanicán Betsaida. ");
INSERT INTO tosNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Hua̱mpi̱ acxni̱ xli̱lhu̱hua tachixcuhuí̱tat catzi̱ko̱lh anta̱ni̱ nacha̱nko̱y sta̱laniko̱lh. La̱ntla̱ xlakcha̱nti̱lhako̱y anta̱ni̱ xuí̱ Jesús, xlá̱ li̱pa̱xuhu xakatli̱ko̱lh, chu̱ tzúculh li̱ta̱chihui̱nampalako̱y la̱ntla̱ Dios xlacasquín calatama̱ko̱lh c-xasa̱sti xtapáksi̱t hua̱ntu̱ nahuili̱y ca̱tuxá̱huat, chu̱ hua̱nti̱ lakminko̱lh ta̱tatlaní̱n, xlá̱ ma̱pacsako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Acxni̱ chu̱ luhua aya xko̱tanu̱y, tilaktalacatzuhui̱ko̱lh a̱ma̱ kalhacu̱tuy xapóstoles, chu̱ chuná̱ huaniko̱lh: —Hua̱ u̱nú̱ anta̱ni̱ huilahu, tzili̱s ca̱huán, ni̱tú̱ ya̱kó̱ chiqui, huata xatlá̱n cahuanikó̱ yuma̱ tachixcuhuí̱tat caanko̱lhá̱ c-xchiccán, usuchí̱ anta̱ni̱ huilakó̱ lactzu̱ ca̱chiquí̱n laqui̱mpi̱ antá̱ namaklaktuncuhuiko̱y, chu̱ antá̱ naputzako̱y pala tú̱ nahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hua̱mpi̱ Jesús huaniko̱lh: —Huata xatlá̱n huixiná̱ cama̱hui̱kó̱tit. —Hua̱mpi̱ na̱ ni̱ pala quin ni̱tú̱ ckalhi̱ya̱hu lhu̱hua caxtala̱nchu̱, caj xma̱n macquitzis, xa̱hua̱ tantuy squi̱ti. Ma̱n chá̱ hua̱ lapi̱ nacana̱hu tama̱huaya̱hu hua̱ntu̱ nata̱hua̱ko̱ya̱hu yuma̱ tachixcuhuí̱tat —kalhti̱nanko̱lh xlacán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Huá̱ chuná̱ xlacán li̱huaniko̱lh sa̱mpi̱ luhua lhu̱hua tachixcuhuí̱tat xuani̱t, ma̱x pala akquitzis mi̱lh xma̱n hua̱ chixcuhuí̱n, tanuj cuenta̱ lacchaján, chu̱ lactzu̱ camán. Hua̱mpi̱ Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Cahuanikó̱tit pi̱ natahuilako̱y caj kampu̱tu kampu̱tu̱ pala ita̱tna ciento kampu̱tunu. ");
INSERT INTO tosNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pus xlacán chuná tlahuako̱lh, chu̱ pacs tahuilako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Cha̱nchu̱ Jesús tíyalh yama̱ macquitzis caxtala̱nchu̱, chu̱ tantuy squi̱ti, láca̱lh c-akapú̱n, pa̱xcatcatzí̱nilh Dios xlí̱huat, chu̱ acxni̱ lakchakako̱lh macama̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t laqui̱mpi̱ xlacán nama̱akpitziniko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pacs chí̱ tihua̱yanko̱lh, na̱ tla̱n tikalhkasko̱lh; a̱li̱sta̱lh ma̱macxtumi̱palako̱lh hua̱ntu̱ akatá̱xtulh, ma̱tzamako̱lh pa̱cu̱tuy pakxu̱ xatalakchakatamá̱n caxtala̱nchu̱, chu̱ squi̱ti. ");
INSERT INTO tosNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cha̱nchu̱ tílalh maktum, acxni̱ xacstutlahuama̱ xoración Jesús, antá̱ xta̱huilako̱y xli̱ma̱kalhtahuáke̱t, xamaktum xlá̱ tikalhasquinko̱lh huaniko̱lh: —¿Xatí̱ quit quili̱quilhanko̱y tachixcuhuí̱tat? ");
INSERT INTO tosNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xlacán chuná̱ kalhti̱ko̱lh: —Huí̱ ti̱ huan pi̱ mat huix Juan Bautista; a̱makapitzí̱n huanko̱y pi̱ mat huix profeta Elías, hua̱mpi̱ a̱makapitzí̱n huampalako̱y pi̱ ma̱x huix ti̱ cha̱tum profeta hua̱nti̱ xlama̱kó̱ xamaka̱n quilhtamacú̱, hua̱mpi̱ chú̱ mat lakastakuanani̱ta̱ ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—Tla̱n, hua̱mpi̱ ¿chá̱ huixín? ¿Tí̱ luhua quit quili̱quilhpiná̱tit! —kalhasquinko̱lh Jesús. Pedro chuná̱ kálhti̱lh: —Quit ccatzi̱y pi̱ huix Cristo hua̱nti̱ Dios lacsacni̱t pi̱ naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Cha̱nchu̱ xlá̱ li̱huaniko̱lh, na̱ li̱ma̱paksi̱ko̱lh pi̱ ti̱ni̱ nahuaniy yumá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na̱ chuná̱ xlá̱ huanipalako̱lh: —Huixín na̱ cacatzí̱tit pi̱ quit, Xatalacsacni Chixcú, xlacasquinca̱ pi̱ lhu̱hua̱ tu̱ nacpa̱ti̱y, chu̱ luhua maktum xli̱ca̱na̱ naquilakmakanko̱y lakko̱lún, chu̱ xanapuxcun pa̱lijni, chu̱ laktzokni̱naní̱n. Naquimakni̱cán, hua̱mpi̱ xli̱aktutu quilhtamacú̱ quit naclakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A̱li̱sta̱lh xli̱pacscán chuná̱ huaniko̱lh: —Pus lapi̱ huí̱ cha̱tum huixín ti̱ luhua xli̱ca̱na̱ maktum quista̱laniputún, capa̱tzánka̱lh hua̱ntu̱ xlá̱ xkalhi̱y xtalacapa̱stacni, chu̱ nia̱lh calacapá̱stacli̱ tu̱ xacstutalacasquín, chu̱ calé̱lh xcru̱z cha̱li̱ cha̱lí̱, chu̱ caquista̱lánilh hasta ma̱squi chuna tla̱n cali̱macamá̱sta̱lh xlatáma̱t caj quimpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa̱mpi̱ caxati̱cahuá̱ ti̱ puhuán nama̱laktaxti̱y xlatáma̱t u̱nú̱ ca̱tuxá̱huat, pus huata luhua lacatancs pi̱ namakatzanka̱y; hua̱mpi̱ caxati̱cahuá̱ ti̱ nama̱laktzanka̱y xlatáma̱t caj quimpa̱lacata, huata xlá̱ cha̱catzi̱ya̱ nama̱laktaxti̱y c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Na̱ chuna li̱tum, ¿tú̱ xtápalh qui̱taxtuniy cha̱tum lapi̱ tla̱n xkálhi̱lh pacs tu̱ anán ca̱tuxá̱huat, hua̱mpi̱ lapi̱ chuná̱ nali̱makatzanka̱y xlatáma̱t c-xlacati̱n Dios? ");
INSERT INTO tosNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pus na̱ chuna li̱tum, lapi̱ hua̱ cha̱tum ti̱ naquili̱ma̱xanán, usuchí̱ nali̱ma̱xanán quintachihuí̱n, na̱ chuná̱ quit, Xatalacsacni Chixcú, na̱ nacli̱ma̱xanán acxni̱ nacmimpalay cca̱tuxá̱huat la̱ cha̱tum li̱ca̱cni rey, cli̱mímaj nahuán xli̱pacs xli̱makatlihuaka Quintla̱tican Dios, xa̱hua̱ xángeles. ");
INSERT INTO tosNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na̱ luhua xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ makapitzí̱n hua̱nti̱ lama̱kó̱ la̱nchiyú̱, chu̱ hua̱nti̱ u̱nú̱ laya̱kó̱, hasta ni̱ a̱ni̱ko̱y nahuán acxni̱ xli̱ca̱na̱ naucxilhko̱y la̱ntla̱ Dios nahuili̱y xasa̱sti xtapáksi̱t ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ma̱x pala aktzayan quilhtamacú̱ xlacatza̱lani̱t la̱ntla̱ chuná̱ xta̱kalhchihui̱nanko̱ni̱t Jesús, ta̱talaca̱cxtuko̱lh kalhatutu xli̱ma̱kalhtahuáka̱t c-aktum ka̱stí̱n laqui̱mpi̱ antá̱ natlahuay oración, xma̱n hua̱ ta̱anko̱lh Pedro, Santiago, chu̱ Juan. ");
INSERT INTO tosNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cha̱nchu̱ xli̱makua xtlahuama̱ xoración, la̱ntla̱ c-xlacán, luhua tanu̱ tasíyulh, xa̱huachí̱ la̱ntla̱ xli̱tlanca xlháka̱t, luhua snapapa huanko̱lh, chu̱ luhua stalanka xmakaxkaka̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Acxnitiyá̱ caj xamaktum tasiyuko̱lh cha̱tuy chixcuhuí̱n hua̱nti̱ tzucuko̱lh ta̱la̱xakatli̱ko̱y; cha̱tum Moisés xuani̱t, chu̱ cha̱tum xamaka̱n profeta Elías. ");
INSERT INTO tosNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Anta̱ni̱ xlacán xlaya̱kó̱, xli̱stiliko̱ni̱t aktum li̱lakati̱t xkakánat; hua̱ xlacán xli̱chihui̱nama̱kó̱ la̱ntla̱ napa̱ti̱nán Jesús c-Jerusalén, chu̱ la̱ntla̱ namakni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ma̱squi Pedro, chu̱ a̱makapitzí̱n, luhua clhtataputuxni̱ko̱yá, juerza lacata̱yaniko̱lh, sa̱mpi̱ xucxilhma̱kó̱ la̱ntla̱ xkalhi̱y li̱tlihuaka Jesús, xa̱hua̱ a̱makapitzí̱n hua̱nti̱ xta̱laya̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cha̱nchu̱ tílalh pi̱ acxni̱ yama̱ chixcuhuí̱n aya xama̱kó̱, Pedro chuná̱ huánilh Jesús: —Ma̱kalhtahuaka̱ná Jesús, ¡luhua xali̱huaca̱ tla̱n pi̱ u̱nú̱ macxtum huiláhu! Uctlahuaya̱hu aktutu lactzu̱ chiqui, aktum milá, aktum xla Moisés, chu̱ aktum xla Elías. Hua̱ chuná̱ xlá̱ li̱hua̱ Pedro sa̱mpi̱ caj la̱ntla̱ xpe̱cuaxni̱ko̱ni̱t, ni̱ xcatzi̱y tu̱ xquilhuama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chunacú̱ xquilhuama̱ yumá̱, acxni̱ minchá̱ c-akapú̱n luhua tlanca puclhni akmiliko̱lh, chu̱ hasta ma̱lakapa̱tze̱kko̱lh; acxni̱ xlacán catzi̱ko̱lh pi̱ xtanu̱ma̱kó̱ c-xlacni, luhua pe̱cuanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chu̱ antá̱ c-xlacni puclhni kaxmatko̱lh xtachihui̱n Dios, chuná̱ huá̱: “Hua̱ yumá̱ quincam ti̱ luhua cpa̱xqui̱y, xma̱n huá̱ cakalhakaxpáttit.” ");
INSERT INTO tosNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A̱li̱sta̱lh acxni̱ nia̱lh takáxmatli̱ yuma̱ tachihuí̱n, ucxilhko̱lh pi̱ ca̱ta xacstu Jesús xlacahuaya̱. A̱li̱sta̱lh la̱ntla̱ lacatzá̱lalh quilhtamacú̱, a̱ma̱ kalhatutu xli̱ma̱kalhtahuáka̱t ni̱tí̱ li̱ta̱chihui̱nanko̱lh hua̱ntu̱ xlacán xucxilhko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cha̱nchu̱ tílalh li̱cha̱lí̱, acxni̱ qui̱taspitko̱lh c-ka̱stí̱n, li̱lhu̱hua̱ tachixcuhuí̱tat minko̱lh pa̱xtokko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cha̱tum chixcú̱ hua̱nti̱ antá̱ xmakmima̱, luhua palha tzúculh quilhán, chu̱ chuná̱ huánilh Jesús: —Ma̱kalhtahuaka̱na Jesús, luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n, camakta̱ya̱ quinkahuasa sa̱mpi̱ luhua xma̱n hua̱ cha̱stum quincám, ");
INSERT INTO tosNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","hua̱mpi̱ cspiritu akskahuiní̱ niucxni̱ makaxtaka, ankalhí̱n makatasay, ma̱snokni̱y u̱n, chu̱ tzucuy kalhpupuy; ankalhí̱n chuná̱ ma̱pa̱ti̱ni̱ma̱, chu̱ ni̱ makaxtakma̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Quit aya cuaniko̱lh mili̱ma̱kalhtahuáka̱t pi̱ catamacaxtúnilh tama̱ cspiritu akskahuiní, hua̱mpi̱ xlacán ni̱ lay ma̱makaxtakniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús chuná̱ kalhtí̱nalh: —Koxutaní̱n huixín hua̱nti̱ ni̱ ca̱najlaputuná̱tit pi̱ quit ckalhi̱y li̱tlihuaka. ¿Hasta niajcu li̱huayá̱ makcatzi nactica̱ta̱pa̱ti̱yá̱n la̱qui̱mpi̱ huixín tla̱n natlahuayá̱tit aktum tascújut? Lacapala̱ huix cali̱ta̱ minkahuasa u̱nú. ");
INSERT INTO tosNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Acxni̱ yama̱ kahuasa tzúculh talacatzuhui̱y, cspiritu akskahuiní tu̱ xpa̱laktaju̱ma̱ li̱cá̱snokli̱ ca̱tiyatna, chu̱ ma̱lactlahuáni̱lh u̱n, hua̱mpi̱ Jesús li̱ma̱páksi̱lh akskahuiní̱ pi̱ camakáxtakli, chu̱ yama̱ kahuasa̱ pacsli, chu̱ chuná̱ chú̱ macamá̱xqui̱lh xtla̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pus xli̱lhu̱hua̱ pa̱xuhuako̱lh sa̱mpi̱ xlacán xucxilhko̱ni̱t la̱ntla̱ luhua xkalhi̱y xli̱makatlihuaka Dios. Chunacú̱ luhua cacs xli̱tamakaxtakko̱ni̱t tlanca li̱ca̱cni̱ tu̱ xtlahuani̱t Jesús acxni̱ xlá̱ chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: ");
INSERT INTO tosNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Luhua li̱huana̱ cakaxpáttit hua̱ntu̱ nacca̱huaniyá̱n, chu̱ niucxni̱ napa̱tzanka̱yá̱tit, pi̱ quit, Xatalacsacni Chixcú, naquimacama̱sta̱cán c-xlacati̱ncán hua̱nti̱ naquimakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Hua̱mpi̱ xlacán ni̱tú̱ xakata̱ksko̱y hua̱ntu̱ xlá̱ xuanima̱kó̱, sa̱mpi̱ Dios ni̱ xa̱ma̱xqui̱ko̱y xtalacapa̱stacni̱ hua̱ntu̱ nali̱akata̱ksko̱y, xa̱huachí̱ xmacpuhuaniko̱y nakalhasquimpalako̱y xatú̱ luhua xuaniputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Maktum xacstucan xli̱ma̱kalhtahuaka̱t Jesús tzucuko̱lh li̱chihui̱nanko̱y xatí̱ cahuá̱ a̱tzinú̱ tlak xkalhi̱y xlakasi usu tali̱pa̱hu. ");
INSERT INTO tosNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Acxni̱ Jesús cátzi̱lh hua̱ntu̱ xlacán xlacapa̱stacma̱kó̱, hua̱ntu̱ xlá̱ tláhualh, tasánilh cha̱tum actzu̱ kahuasa, chu̱ antá̱ yá̱hualh c-xpa̱xtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","A̱li̱sta̱lh xakatli̱ko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: —Hua̱nti̱ ni̱ lakmakán cha̱tum actzu kahuasa ti̱ ni̱tu̱ xlakasi̱, xta̱chuná̱ yumá, chu̱ luhua xli̱ca̱na̱ napa̱xqui̱y caj xpa̱lacata pi̱ quit cpa̱xqui̱y, pus li̱taxtuy pi̱ la̱mpala quit quimpa̱xqui̱ma̱, chu̱ na̱ chuna li̱tum, hua̱nti̱ quit quimpa̱xqui̱y, pus na̱ chuná̱ pa̱xqui̱ma̱ Dios hua̱nti̱ quimacamini̱t. Sa̱mpi̱ hua̱nti̱ nata̱ctu̱ju̱y, chu̱ ni̱tú̱ naputzay la̱ntla̱ nama̱xqui̱cán ca̱cni, hua̱ xlá̱ ti̱ tlak kalhi̱y xlakasi, usu tali̱pa̱hu cli̱ma̱xtuy c-milaksti̱pa̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Caj li̱puntzú̱ Juan chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, xacucxilhma̱hu cha̱tum chixcú̱ hua̱nti̱ caj mintucuhuiní̱ xli̱quilhán, chu̱ tla̱n xtamacaxtuy cspiritu akskahuiní, hua̱mpi̱ cli̱huanihu pi̱ nia̱lh tí̱ chuná̱ cali̱ma̱pácsalh, sa̱mpi̱ ni̱ acxtum quinca̱ta̱lapu̱layá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús chuná̱ huánilh: —Ni̱ xtili̱huanítit, sa̱mpi̱ hua̱nti̱ quinca̱macasta̱layá̱n, pus huata na̱ lakati̱y hua̱ntu̱ li̱scujma̱hu, chu̱ quinca̱ta̱ta̱yayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Acxni̱ aya xtalacatzuhui̱ma̱ quilhtamacú̱ la̱ntla̱ Jesús xli̱ánat xuani̱t c-akapú̱n, xlá̱ ni̱ pala tzinú̱ lakpé̱cualh, huata xlá̱ aktum huíli̱lh xtapuhuá̱n pi̱ naán lakata̱yay Jerusalén hua̱ntu̱ clhca̱huili̱nicani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma̱lakacha̱ko̱lh makapitzi̱n xlacscujní̱n laqui̱mpi̱ napu̱laniko̱y, chu̱ naanko̱y c-aktum actzu̱ ca̱chiquí̱n hua̱ntu̱ xma̱paksi̱y Samaria laqui̱mpi̱ antá̱ naputzako̱y anta̱ni̱ nalaktuncuhuiko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hua̱mpi̱ hua̱nti̱ xala yama̱ chuchutsipi̱ acxni̱ catzi̱ko̱lh pi̱ Jesús judío, chu̱ pi̱ xama̱ c-Jerusalén, pus ni̱ ma̱xqui̱ko̱lh talacasquín antá̱ nalaktuncuhuiko̱y c-xchuchutsipijcán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jacobo, chu̱ Juan, acxni̱ chu̱ catzi̱ko̱lh la̱ntla̱ xkalhti̱nanko̱ni̱tanchá̱, xlacán si̱tzi̱ko̱lh, chu̱ acxni̱ taspitko̱lh, chuná̱ huaniko̱lh Jesús: —Quimpu̱chinacán, ¿pi̱ lacasquina̱ pi̱ nacli̱ma̱paksi̱nana̱hu catáactalh lhcúya̱t c-akapú̱n laqui̱mpi̱ huá̱ nama̱sputuko̱y xta̱chuná̱ la̱ntla̱ titláhualh maktum profeta Elías? ");
INSERT INTO tosNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús cacs lacaucxilhko̱lh, chu̱ lacaquilhni̱ko̱lh sa̱mpi̱ chuná̱ huaniko̱lh: —Koxutaní̱n huixín, ni̱ pala tzinú̱ catzi̱yá̱tit xatí̱ luhua scujnipá̱tit, chu̱ ca̱ma̱xqui̱putuná̱n tla̱n mintalacapa̱stacnicán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Sa̱mpi̱ quit ni̱ caj cmini̱t ma̱laktzanka̱niko̱y xli̱stacnacan tachixcuhuí̱tat, pus huata caj cmini̱t lakma̱xtuniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Acxni̱ xtla̱huama̱kó̱ c-tiji, cha̱tum chixcú̱ lákmilh Jesús, chu̱ chuná̱ huánilh: —Quimpu̱chiná, quit na̱ csta̱laniputuná̱n cani̱cahuá̱ anta̱ni̱ huix napina. ");
INSERT INTO tosNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús chuná̱ kálhti̱lh: —Xli̱pacs hue̱kni̱ hua̱ntu̱ lama̱kó̱ ca̱quihuí̱n kalhi̱ko̱y c-lhucucán anta̱ni̱ lhtatako̱y, chu̱ lactzu̱ spu̱n na̱ kalhi̱ko̱y xma̱sakacán, hua̱mpi̱ quit, Xatalacsacni Chixcú, ni̱tú̱ ckalhi̱y anta̱ni̱ nacma̱jaxay quiakxe̱ka̱ acxni̱ ctlakuán. ");
INSERT INTO tosNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Caj li̱puntzú̱ Jesús chuná̱ huánilh cha̱tum chixcú: —Huix na̱ caquista̱lani. Hua̱mpi̱ xlá̱ chuná̱ kálhti̱lh: —Quimpu̱chiná, quit na̱ nacsta̱laniyá̱n, hua̱mpi̱ caquili̱kalhkalhi̱ hasta acxni̱ nani̱y quintla̱t laqui̱mpi̱ nacma̱acnu̱ta̱qui̱y, chu̱ nacsta̱laniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús chuná̱ kálhti̱lh: —Camakáxtakti̱ hua̱nti̱ la̱ xaní̱n lama̱kó̱ laqui̱mpi̱ hua̱ nama̱acnu̱ko̱y xta̱ni̱ni̱ncán, hua̱mpi̱ huix luhua mini̱niyá̱n nali̱xakatli̱ko̱ya̱ tachixcuhuí̱tat la̱ntla̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pus na̱ tihuanipá̱ a̱cha̱tum: —Quimpu̱chiná, quit xlá̱ luhua xli̱ca̱na̱ csta̱laniputuná̱n, hua̱mpi̱ caquima̱xqui̱ quilhtamacú̱ pu̱lana̱ nacán xakatli̱ta̱qui̱ko̱y hua̱nti̱ cta̱huilakó̱ c-quínchic pi̱ luhua maktum tu̱ xli̱ca̱na̱. ");
INSERT INTO tosNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Cha̱nchu̱ Jesús, huánilh: —Hua̱nti̱ lakata̱yani̱ttá̱ xtascújut hua̱ntu̱ Dios ma̱xqui̱ni̱t, xlá̱ ni̱ mini̱niy nalakcatzalacá̱n hua̱ntu̱ xli̱lama̱ xapu̱lana̱ xlatáma̱t, sa̱mpi̱ xta̱chuná̱ li̱taxtuy la̱ntla ti̱ li̱lakuaxnama̱ arado, chu̱ pala puntzu̱ puntzú̱ talakaspita, ni̱ lay tzajua catíscujli, xta̱chuná̱ pi̱ tanu̱ tu̱ luhua li̱ta̱katzanka̱putún, ni̱ lay catima̱kantáxti̱lh yama̱ tascújut hua̱ntu̱ ma̱xqui̱cani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A̱li̱sta̱lh Quimpu̱chinacan Jesús lacsacko̱lh tutumpuxamacu̱tuy chixcuhuí̱n hua̱nti̱ luhua xli̱ca̱na̱ xli̱pa̱huanko̱y, chu̱ ma̱lakacha̱ko̱lh li̱cha̱tiyú̱n c-lactzu̱ ca̱chiquí̱n anta̱ni̱ xlá̱ xli̱ánat xuani̱t a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na̱ xuaniko̱y: “Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ yuma̱ mintascujutcán xta̱chuná̱ li̱taxtuy la̱ntla̱ tlanca li̱xká̱nat, hua̱mpi̱ hua̱ chú̱ ti̱ scujma̱kó̱, luhua ni̱ pala tzinú̱ clhu̱huacán; huata xatlá̱n casquinítit Dios hua̱nti̱ xpu̱china yuma̱ hua̱ntu̱ xali̱má̱qui̱t pi̱ xlá̱ camacámilh lhu̱hua̱ cscujní̱n laqui̱mpi̱ pacs nama̱macxtumi̱ko̱cán laná̱nat. ");
INSERT INTO tosNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Chi̱nchu̱ huixín capítit anta̱ni̱ cca̱ma̱lakacha̱má̱n, hua̱mpi̱ na̱ cacatzí̱tit pi̱ cca̱maca̱má̱n luhua xta̱chuná̱ lactzu̱ borrego c-xlaksti̱pa̱ncan lacli̱pe̱cua huananí̱n la̱páni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni̱ tili̱piná̱tit mimpu̱xtokocán, ni̱ pala anta̱ni̱ ma̱qui̱yá̱tit mintumi̱ncán, ni̱ pala a̱pu̱tum mintatuhuanucán; chu̱ luhua ti̱tum cachipítit anta̱ni̱ pimpá̱tit, chu̱ ni̱tú̱ natachokoyá̱tit c-tiji̱ pala tí̱ nata̱chihui̱naná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Acxni̱ nachipiná̱tit c-aktum chiqui̱ anta̱ni̱ huixín natahuilayá̱tit, chu̱ acxni̱ natanu̱ya̱pítit, chu̱ naxakatli̱yá̱tit hua̱nti̱ xpu̱china chiqui, chuná̱ nahuaniyá̱tit: ‘Dios caca̱siculana̱tlahuán huixín hua̱nti̱ huilátit yuma̱ c-chiqui.’ ");
INSERT INTO tosNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lapi̱ yama̱ c-chiqui, huilakó̱ hua̱nti̱ tla̱n natlahuako̱y mintachihui̱ncán, pus xli̱ca̱na̱ Dios nasiculana̱tlahuako̱y chuná̱ la̱ntla̱ huixín nahuaniko̱yá̱tit, hua̱mpi̱ lapi̱ ni̱ huí̱ ti̱ tla̱n xtapuhua̱ncán, huata xatlá̱n catapa̱nu̱niko̱lh yama̱ tasiculana̱tlahu hua̱ntu̱ li̱chipinikó̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Anta̱ni̱ tla̱n naca̱tlahuacaná̱tit c-aktum chiqui, pus antá̱ catamakaxtáktit, ni̱ lacatum lacatum capítit c-akatunu chiqui; chu̱ na̱ nahua̱yaná̱tit, chu̱ capa̱xcatcatzí̱tit hua̱ntu̱ naca̱ma̱xqui̱caná̱tit, sa̱mpi̱ hua̱nti̱ scujma̱ juerza lakchá̱n pi̱ nama̱skahuicán. ");
INSERT INTO tosNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Na̱ cani̱cahuá̱ anta̱ni̱ nachipiná̱tit c-akatunu chuchutsipi̱ anta̱ni̱ naca̱makamaklhti̱nancaná̱tit, tla̱n catlahuátit hua̱mpi̱ nahuayá̱tit hua̱ntu̱ naca̱lakahuili̱caná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pacs nama̱pacsayá̱tit ta̱tatlaní̱n hua̱nti̱ antá̱ huilakó̱; chuná̱ nahuaniko̱yá̱tit tachixcuhuí̱tat: ‘Chú̱ aya lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t c-milaksti̱pa̱ncán.’ ");
INSERT INTO tosNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Hua̱mpi̱ lapi̱ nachipiná̱tit c-aktum ca̱chiquí̱n, chu̱ ni̱ naca̱makamaklhti̱nancaná̱tit, cataxtútit c-xca̱tiji̱ní̱n yama̱ ca̱chiquí̱n laqui̱mpi̱ pacs nakaxmatko̱y, chu̱ chuná̱ naquilhaniko̱yá̱tit: ");
INSERT INTO tosNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Xli̱pacs huixín caucxílhtit la̱ntla̱ cca̱tincxmakaniyá̱n pokxni̱ hua̱ntu̱ quinca̱lactahuacán c-minchuchutsipi̱cán, laqui̱mpi̱ huixín nacatzi̱yá̱tit pi̱ nia̱lh quincui̱ntajcán tu̱ naca̱okspulayá̱n. Hua̱mpi̱ ma̱squi chuná, luhua caakatá̱kstit huixín pi̱ luhua caj hua̱ cli̱mini̱tahu laqui̱mpi̱ nacca̱huaniyá̱n pi̱ aya lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t c-milaksti̱pa̱ncán.’ ");
INSERT INTO tosNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ yama̱ quilhtamacú̱ acxni̱ pacs tachixcuhuí̱tat nama̱sta̱ko̱y cuenta̱ c-xlacati̱n Dios, yama̱ ca̱chiquí̱n anta̱ni̱ ni̱ naca̱makamaklhti̱nancaná̱tit, pus a̱tzinú̱ luhua tlanca xtapa̱tí̱n nalakchá̱n, ni̱ xahua̱ hua̱ntu̱ nalakcha̱nko̱y yama̱ lacli̱xcajnit tachixcuhuí̱tat hua̱nti̱ maká̱n xuilakó̱ c-xaca̱chiqui̱n Sodoma. ");
INSERT INTO tosNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Koxutaní̱n huixín ti̱ huilátit c-xaca̱chiquí̱n Corazín, chu̱ na̱ chuná̱ huixín hua̱nti̱ huilátit c-Betsaida! Sa̱mpi̱ lapi̱ yuma̱ lactlanca quintascújut hua̱ntu̱ ctlahuako̱ni̱t c-milaksti̱pa̱ncán chuná̱ xtlahuako̱ca̱ xamaka̱n quilhtamacú̱ c-xaca̱chiqui̱n Tiro, chu̱ Sidón, pus xlacán maka̱sa quilhtamacú̱ xlakpali̱ko̱ni̱t xali̱xcajnit xtalacapa̱stacnicán, chu̱ xli̱ma̱siyuko̱lh c-xlatama̱tcán, sa̱mpi̱ xtili̱lhaka̱nanko̱lh xahuachichi xlhaka̱tcán, chu̱ xtili̱actlahuako̱ca̱ lhcaca̱ caj la̱ntla̱ xtali̱puhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hua̱mpi̱ acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ Dios nata̱tlahuako̱y cuenta̱ xli̱pacs tachixcuhuí̱tat, pus huixín tlak luhua tla̱n napa̱ti̱naná̱tit ni̱ xahua̱ yama̱ tachixcuhuí̱tat hua̱nti̱ maká̱n xuilakó̱ c-Tiro, chu̱ c-Sidón. ");
INSERT INTO tosNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chi̱nchu̱ huixín hua̱nti̱ huilátit c-xaca̱chiqui̱n Capernaum, lapi̱ luhua puhuaná̱tit pi̱ Dios ca̱li̱kalhi̱má̱n tlanca mimpu̱tahui̱lhcán c-akapú̱n, pus luhua aktzanka̱ni̱tántit, sa̱mpi̱ huixín naca̱macapincaná̱tit c-pu̱pa̱tí̱n laqui̱mpi̱ antá̱ naxoko̱naná̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús chuná̱ huanipalako̱lh xli̱ma̱kalhtahuáka̱t: “Hua̱nti̱ huixín naca̱kaxmatniyá̱n mintachuhui̱cán, pus xta̱chuná̱ li̱taxtuy la̱ quit quinkaxmatnima̱, hua̱mpi̱ hua̱nti̱ caj naca̱lakmakaná̱n, pus na̱ quit quilakmakama̱; chu̱ hua̱nti̱ quit naquilakmakán, pus na̱ lakmakama̱ Quintla̱t hua̱nti̱ quimacamini̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ni̱ li̱maka̱s quilhtamacú̱ yama̱ hua̱nti̱ xmaca̱nko̱ni̱t Jesús tutumpuxamacu̱tuy xakchihui̱naní̱n, luhua cha̱pa̱xuhua̱na̱ qui̱taspitko̱lh, chu̱ chuná̱ huaniko̱lh Jesús: —Quimpu̱chinacán, luhua xli̱ca̱na̱ hasta ma̱squi cspiritu akskahuiní pacs xquinca̱kalhakaxmatá̱n acxni̱ c-mintucuhuiní̱ xacli̱ma̱paksi̱ko̱ya̱hu xpa̱lacata̱ cataxtuko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús chuná̱ kalhti̱ko̱lh: —Xli̱ca̱na̱ sa̱mpi̱ quit xacucxilha̱ akskahuiní xta̱ctama̱chi̱ cakapú̱n xta̱chuná̱ maklípit. ");
INSERT INTO tosNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pus quit cca̱ma̱xqui̱ni̱tán li̱tlihuaka laqui̱mpi̱ tla̱n namakatlajayá̱tit xli̱tlihuaka akskahuiní hua̱nti̱ luhua ca̱si̱tzi̱niyá̱n, chu̱ xlá̱ ni̱tú̱ catica̱tlahuanín. ");
INSERT INTO tosNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Hua̱mpi̱ ni̱ caj hua̱ luhua cali̱pa̱xuhuátit pi̱ ca̱kalhakaxmatni̱ cspiritucan akskahuiní, hua̱mpi̱ huata hua̱ cali̱pa̱xuhuátit pi̱ c-akapú̱n aya talhca̱ni̱tanchitá̱ mintucuhuinicán. ");
INSERT INTO tosNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Acxnitiya tuncán Espíritu Santo má̱xqui̱lh Jesús aktum tlanca tapa̱xuhuá̱n, chu̱ chuná̱ kalhtahuakánilh Dios: “Tla̱ti Dios, huix ti̱ xma̱la̱na akapú̱n, chu̱ ca̱tiyatna, cpa̱xcatcatzi̱niyá̱n pi̱ huix ma̱aktze̱kuili̱ni̱ xatla̱n mintalacapa̱staci̱ hua̱nti̱ puhuanko̱y pi̱ luhua acastaca̱n chixcuhuí̱n, laqui̱mpi̱ xlacán ni̱ naakata̱ksko̱y, chu̱ li̱makáxtakti̱ pi̱ naakata̱ksko̱y hua̱nti̱ caj xachunatá, chu̱ ni̱ pala tú̱ tali̱pa̱hu makcatzi̱ko̱cán laqui̱mpi̱ xlacán nali̱pa̱huanko̱yá̱n. Luhua chuna tla̱n, ta̱ta̱, sa̱mpi̱ huix chuná̱ lacásquinti, chu̱ chuná̱ lalh.” ");
INSERT INTO tosNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A̱li̱sta̱lh chuná̱ huaniko̱lh tachixcuhuí̱tat: “Xli̱pacs catu̱hua̱ talacapa̱stacni̱ tu̱ anán, Quintla̱t pacs quimacama̱xqui̱ni̱t; quit xCam Dios, chu̱ ni̱tí̱ luhua quilakapasa̱ xatí̱ luhua quit, huata caj xma̱n hua̱ Dios catzi̱y pi̱ xli̱ca̱na̱ quit xCam; chu̱ na̱ chuna li̱tum ni̱tí̱ luhua catzi̱y la̱ntla̱ xlá̱ xtalacapa̱stacni Dios, caj xma̱n quit ccatzi̱y sa̱mpi̱ quit xCam, chu̱ caj xma̱n hua̱ tla̱n nalakapasa̱ hua̱nti̱ quit nacma̱lakapasni̱putún.” ");
INSERT INTO tosNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A̱li̱sta̱lh caj tanu̱ xakatli̱ko̱lh Jesús xli̱ma̱kalhtahuáka̱t, huaniko̱lh: “Luhua ca̱na̱ li̱pa̱xuhu huixín caj xpa̱lacata tu̱ Dios ca̱ma̱ucxilhni̱má̱n ca̱li̱ma̱lacahua̱ni̱má̱n la̱nchuj quilhtamacú̱.” ");
INSERT INTO tosNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lhu̱hua̱ xalakmaka̱n profetas, chu̱ lactlanca reyes xucxilhputunko̱y hua̱ntu̱ la̱nchiyú̱ huixín ucxilhpá̱tit, hua̱mpi̱ xlacán ni̱ lay ucxilhko̱lh, chu̱ na̱ xkaxmatputunko̱y hua̱ntu̱ la̱nchiyú̱ huixín kaxpatpá̱tit, hua̱mpi̱ xlacán ni̱ lay kaxmatko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Maktum cha̱tum acstaca̱ judío laktalacatzúhui̱lh Jesús laqui̱mpi̱ nata̱chihui̱nán, hua̱mpi̱ caj xli̱kalhtzaksama̱ sa̱mpi̱ chuná̱ kalhásquilh: —Ma̱kalhtahuaka̱ná, ¿xatú̱ luhua quili̱tláhuat laqui̱mpi̱ Dios naquima̱xqui̱y yama̱ li̱pa̱xuhu la̱táma̱t xala c-akapú̱n hua̱ntu̱ niucxni̱ nalaksputa? ");
INSERT INTO tosNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús chuná̱ kálhti̱lh: —¿Lá̱ huan Li̱kalhtahuaka anta̱ni̱ tatzoktahuilani̱t xli̱ma̱paksi̱n Dios? ¿Lá̱ntla̱ li̱kalhtahuakani̱ta̱ xpa̱lacata tu̱ quili̱tlahuatcán? ");
INSERT INTO tosNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yama̱ acstaca̱ judío chuná̱ kálhti̱lh: —Antá̱ chuná̱ tatzokni̱t: ‘Capa̱xqui̱ Mimpu̱china miDios xli̱pacs minacú̱, xli̱pacs mili̱stacna, xli̱pacs mili̱tlihuaka, chu̱ xli̱pacs mintalacapa̱stacni; chu̱ na̱ capa̱xqui̱ hua̱nti̱ lacatzú̱ li̱ta̱huila̱ la̱ntla̱ta huix acstupa̱xqui̱cana.’ ");
INSERT INTO tosNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Cha̱nchu̱ huánilh Jesús: —Luhua lacatancs la̱ huana. Lapi̱ huix chuná̱ natlahuaya̱ hua̱ntu̱ chihuí̱nanti, pus huix nakalhi̱ya̱ yama̱ xa̱li̱ankalhi̱n latáma̱t c-xpa̱xtu̱n Dios hua̱ntu̱ huix putzápa̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Hua̱mpi̱ hua̱ chú̱ xlá̱ pi̱ tla̱n xtaxtuputún, juerza kalhasquimpá̱ Jesús: —¿Xatí̱ hua̱ yamá̱ ti̱ lacatzú̱ cli̱ta̱hui, huachá̱ ti̱ luhua quili̱pá̱xqui̱t? ");
INSERT INTO tosNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Puschí̱ chuná̱ kálhti̱lh Jesús: —Luhua cui̱ntaj catlahua̱ yuma̱ takalhchihuí̱n hua̱ntu̱ nacuaniyá̱n: Maktum cha̱tum chixcú̱ minchá̱ c-Jerusalén xama̱ c-Jericó, hua̱mpi̱ c-tiji̱ li̱pa̱taxtuko̱lh makapitzi̱n kalha̱naní̱n. Makkalhanko̱lh, hasta ma̱squi xlháka̱t hua̱ntu̱ xlá̱ xlhaka̱ni̱t, pacs maklhti̱ko̱lh, tla̱n akkaximi̱ko̱lh, chu̱ ma̱lakahuitiko̱lh; a̱tzinú̱ xuani̱t aya xmakni̱ko̱y a̱cu makaxtakko̱lh, chu̱ anko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hua̱mpi̱ na̱ antiyá̱ yama̱ c-tiji̱ xlacmima̱ cha̱tum pa̱li̱ judío, hua̱mpi̱ acxni̱ xlá̱ úcxilhli anta̱ni̱ xmá̱, huata caj pa̱xtu̱tzá̱lalh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hua̱mpi̱ caj li̱puntzu̱ li̱tum, na̱ antá̱ lácmilh cha̱tum chixcú̱ hua̱nti̱ xta̱tapaksi̱ko̱y levitas; acxni̱ xlá̱ na̱ ucxilhpá̱, huata na̱ ti̱tum álh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Hua̱mpi̱ hua̱ cha̱tum chixcú xala c-Samaria na̱ antá̱ xlá̱ xlactla̱huama̱ yama̱ c-tiji; acxni̱ xlá̱ úcxilhli, luhua kayaj catzánilh, chu̱ lakalhámalh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xlá̱ laktalacatzúhui̱lh anta̱ni̱ xmá̱ yama̱ chixcú̱ hua̱nti̱ xma̱sipa̱ni̱cani̱t; ma̱cuchí̱nilh xtasipa̱ní̱n, na̱ li̱tláhualh aceite, chu̱ vino. Chu̱ a̱li̱sta̱lh ka̱huíli̱lh c-xa̱xnu̱, le̱lh c-aktum chiqui̱ hua̱ntu̱ xlá̱ sá̱cualh, chu̱ antá̱ maktákalhli. ");
INSERT INTO tosNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Li̱cha̱lí̱ acxni̱ xkákalh, yama̱ samaritano acxni̱ aya xamajá, ma̱cútulh okxtuy tumi̱n xla plata, má̱xqui̱lh xpu̱china yama̱ chiqui, chu̱ chuná̱ huánilh: ‘Luhua cui̱ntaj catlahua̱ yuma̱ koxuta chixcú, chu̱ pala tú̱ huix nali̱makasputacú̱, ni̱ cali̱púhuanti sa̱mpi̱ quit nacxokoniyá̱n acxni̱ nacmimpalay.’ ");
INSERT INTO tosNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pus chuná̱ yumá̱ titláhualh; chú̱ huix luhua caj caquihuani, la̱ntla̱ xli̱kalhatutucan yama̱ chixcuhuí̱n, ¿xatí̱ cahuá̱ chú̱ luhua li̱úcxilhli̱ xta̱chuná̱ lacatzú̱ li̱ta̱hui̱ hua̱nti̱ luhua xli̱pá̱xqui̱t yama̱ chixcú̱ hua̱nti̱ tali̱pa̱táxtulh kalha̱naní̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yama̱ acstaca̱ judío chuná̱ kalhtí̱nalh: —Pus quit cpuhuán pi̱ ma̱x hua̱nti̱ lakalhámalh, chu̱ maktá̱yalh. —Pus huix na̱ chuná̱ catlahua̱, chu̱ camakta̱yakó̱ ma̱squi cati̱hua̱ minta̱chixcú̱ hua̱nti̱ maclacasquima̱kó̱n —huánilh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ta̱taca̱xpalako̱lh xli̱ma̱kalhtahuáka̱t, chu̱ tzúculh tla̱huán c-tiji, chu̱ cha̱lh c-aktum actzu̱ ca̱chiquí̱n, antá̱ xuí̱ cha̱tum pusca̱t, xlá̱ luhua li̱pa̱xuhu makamaklhtí̱nalh c-xchic, yama̱ pusca̱t xuanicán Marta. ");
INSERT INTO tosNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yama̱ Marta xuí̱ cha̱tum xta̱lá̱ xuanicán María, chu̱ anta̱ni̱ xlá̱ tahui̱ Jesús, na̱ antá̱ lacatzú̱ c-xtantú̱n táhui̱ laqui̱mpi̱ xlá̱ nakaxmatniy xtachihuí̱n hua̱ntu̱ xlá̱ nali̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Chi̱nchu̱ hua̱ Marta, hua̱ xlá̱ xli̱tascújut xli̱acchichijuani̱t. Pus xlá̱ laktalacatzúhui̱lh Jesús, chu̱ chuná̱ huánilh: —Quimpu̱chiná, ¿tu̱ tzinú̱ puhuana̱ pi̱ quit ctlahuama̱ tascújut hua̱ntu̱ na̱ xli̱tláhuat quinta̱la María? Pus cahuani̱ caquimaktá̱yalh. ");
INSERT INTO tosNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Hua̱mpi̱ Jesús chuná̱ kálhti̱lh: —Marta, koxutá̱ huix Marta, huix xli̱ca̱na̱ luhua a̱huán mi̱ntascújut li̱akapini̱ta, chu̱ catu̱huá̱ li̱akalituanani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Hua̱mpi̱ caj xma̱n ti̱pa̱tu̱ hua̱ntu̱ luhua a̱tzinú̱ xlacasquinca, hua̱ xlá̱ lacsacni̱t María, chu̱ ni̱tí̱ catima̱lactláhui̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tílalh maktum pi̱ xtlahuama̱ Jesús xoración lacatum, chu̱ acxni̱ tima̱spútulh, cha̱tum xli̱ma̱kalhtahuáka̱t chuná̱ huánilh: —Quimpu̱chinacán, caquinca̱ma̱siyuni̱ la̱ntla̱ nactlahuaya̱hu quioracioncán xta̱chuná̱ la̱ntla̱ Juan Bautista ma̱siyuniko̱lh hua̱nti̱ xkaxmatniko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús chuná̱ huaniko̱lh: —Acxni̱ huixín natlahuaniyá̱tit oración Dios chuná̱ nahuaniyá̱tit: ‘Quintla̱ticán hua̱nti̱ huix huilapi̱ c-akapú̱n, caj xma̱n huix mini̱niyá̱n nama̱xqui̱cán ca̱cni̱ xasa̱ntujlani mintucuhuiní. Camilh mili̱ma̱paksí̱n u̱nú̱ c-quilaksti̱pa̱ncán. Chu̱ chuná̱ u̱nú̱ ca̱tiyatna cakantáxtulh mili̱ma̱paksí̱n, chuná̱ la̱ntla kantaxtuma̱chá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caquinca̱ma̱xqui̱ quili̱huatcán tu̱ nacli̱latama̱ya̱hu cha̱li̱ cha̱lí̱. ");
INSERT INTO tosNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na̱ caquinca̱ma̱tzanka̱nani̱ quintala̱kalhi̱ncán, sa̱mpi̱ quin na̱ cma̱tzanka̱naniko̱ya̱hu hua̱nti̱ quinca̱tlahuaniyá̱n ni̱tlá̱n. Na̱ ni̱ caquinca̱makáxtakti̱ pi̱ nactamakuasa̱hu acxni̱ naquinca̱toklhcaná̱n, huata caquinca̱ma̱pa̱nu̱ni̱ hua̱ntu̱ juerza naquinca̱ma̱tlahui̱yá̱n tala̱kalhí̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús huanipalako̱lh yuma̱ takalhchihuí̱n: —Lapi̱ cha̱tum huixín kalhi̱y cha̱tum xamigo, chu̱ nascacalakchá̱n c-xita̱t ca̱tzi̱sní̱ xchic, chu̱ chuná̱ nahuaniy: ‘Amigo, catlahua̱ li̱tlá̱n caquima̱pa̱huani̱ mactutu mincaxtala̱nchu̱, ");
INSERT INTO tosNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sa̱mpi̱ quilákchilh cha̱tum quiamigo tiji̱tla̱huani, na̱ quit ni̱tú̱ ckalhi̱y tu̱ nacta̱huay.’ ");
INSERT INTO tosNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Quit cpuhuán pi̱ yama̱ xamigo hua̱nti̱ ancani̱t makpa̱huacán caxtala̱nchu̱ ti̱ xlá̱ antá̱ tanu̱ma̱ c-xchic, chuná̱ nakalhti̱nán c-xpu̱lacni chiqui: ‘Luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n ni̱ caquima̱akatzanka, sa̱mpi̱ quimá̱laccha̱ li̱huana̱ lacchuhuayá, xa̱huachí̱ quinta̱lhtatama̱ko̱lhá̱ lactzu̱ quincamán c-pu̱tama, chu̱ ni̱ lay nacta̱qui̱y laqui̱mpi̱ nacma̱xqui̱yá̱n hua̱ntu̱ huix quisquinípa̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hua̱mpi̱ cca̱huaniyá̱n, pi̱ lapi̱ yama̱ chixcú hua̱nti̱ pa̱huanama̱ ni̱ makaxtaka, chunatiyá̱ li̱ma̱akatzanka̱ma̱ xamigo, quit cca̱huaniyá̱n pi̱ ma̱squi ni̱ xta̱qui̱pútulh laqui̱mpi̱ nama̱xqui̱y hua̱ntu̱ maclacasquima̱ xamigo, pus juerza nata̱qui̱y, chu̱ nama̱xqui̱y laqui̱mpi̱ nia̱lh makcatzi nama̱akatzanka̱y, chu̱ nama̱xqui̱ko̱y xli̱pacs hua̱ntu̱ xlá̱ namaclacasquín. ");
INSERT INTO tosNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Quit cca̱huaniyá̱n pi̱ na̱ chuná̱ huixín catlahuátit: Casquinítit Dios hua̱ntu̱ maclacasquimpá̱tit, xlá̱ naca̱ma̱xqui̱yá̱n; caputzátit hua̱ntu̱ maclacasquiná̱tit, chu̱ nata̱ksá̱tit; calakatláktit má̱laccha, chu̱ xlá̱ naca̱ma̱lacqui̱niyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sa̱mpi̱ xli̱pacs hua̱nti̱ yama̱ squin hua̱ntu̱ maclacasquima̱, nama̱xqui̱cán; chu̱ hua̱nti̱ putzay hua̱ntu̱ qui̱tzanka̱nima̱, nata̱ksa; chu̱ hua̱nti̱ lakatlaka̱ má̱laccha, ma̱lacqui̱nicán. ");
INSERT INTO tosNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Na̱ chuna li̱tum xatí̱ xatla̱t huixín hua̱nti̱ kalhi̱ko̱y xcamancán, chu̱ pala hua̱ xcam nasquiniy mactum caxtala̱nchu̱, ¿pi̱ nama̱xqui̱y aktum chíhuix? Usuchí̱ acxni̱ nasquiniy tantum squi̱ti, ¿pi̱ nali̱akskahuiy tantum lu̱hua? ");
INSERT INTO tosNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Usuchí̱ acxni̱ nasquiniy aktum ká̱lhua̱t, ¿pi̱ huata nama̱xqui̱y tantum sta̱lúcut? ");
INSERT INTO tosNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pus hua̱ pala pi̱ hua̱ huixín chuná̱, ni̱ lacuán chixcuhuí̱n, catzi̱yá̱tit la̱ntla̱ tu̱ tla̱n ma̱xqui̱ko̱yá̱tit lacuan xtata̱qui̱ncán milakskata̱ncán, ¿pi̱ xali̱huacá̱ chú̱ mintla̱tican Dios hua̱nti̱ huí̱ c-akapú̱n ni̱ catima̱xqui̱ko̱lh xli̱tlihuaka Espíritu Santo hua̱nti̱ nasquiniko̱y?” ");
INSERT INTO tosNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Maktum Jesús xtamacaxtunima̱ cspiritu akskahuiní̱ cha̱tum chixcú̱ hua̱nti̱ luhua xmakatlajani̱t, chu̱ xma̱ko̱ko̱ni̱t. Acxni̱ yama̱ cspiritu akskahuiní̱ táxtunilh yama̱ chixcú̱ hua̱nti̱ xko̱ko̱ni̱t tla̱n tzúculh chihui̱nán. Xli̱pacs ti̱ ucxilhko̱lh, luhua cacs li̱lacahuanko̱lh hua̱ntu̱ Jesús xlá̱ xtlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Hua̱mpi̱ makapitzí̱n chuná̱ tzucuko̱lh huanko̱y: “Uma̱ chixcú̱ hua̱ li̱tamacaxtuy cspiritu akskahuiní̱ sa̱mpi̱ Beelzebú hua̱nti̱ luhua xapuxcu akskahuiní ma̱xqui̱ni̱t xli̱tlihuaka̱ pi̱ chuná̱ tla̱n natlahuay.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Cha̱nchu̱ makapitzí̱n, na̱ caj xmaktzaksama̱kó̱, csquiniko̱y pi̱ catláhualh aktum tlanca li̱ca̱cni tascújut laqui̱mpi̱ chuná̱ tancs nali̱catzi̱ko̱y pi̱ xli̱ca̱na̱ Dios macamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cha̱nchu̱ xlá̱ pi̱ xcatzi̱y hua̱ntu̱ xlacán xpuhuama̱kó̱, xlá̱ chuná̱ huaniko̱lh: “Huixín catzi̱yá̱tit pi̱ caxati̱cahua̱ xanapuxcun ma̱paksi̱naní̱n xala c-aktum tíyat, lapi̱ xlacán caj natapa̱pitziko̱y hua̱nti̱ ta̱ta̱yako̱y, chu̱ xacstucán natzucuy la̱lacatahuacako̱y, pus chuná̱ ni̱ lay tapalhi̱y a̱ma̱ pu̱ma̱paksí̱n, huata caj nala̱lactlahuaya̱huako̱y. Chu̱ na̱ chuná̱ lapi̱ c-aktum pu̱táhui̱lh anta̱ni̱ huí̱ cha̱tum chixcú, chu̱ huilakó̱ xcamán, chu̱ lapi̱ caj natzucuy la̱lacata̱qui̱y, pus ni̱ lay maka̱s catitapálhi̱lh huata caj xli̱pacs nala̱lactlahuaya̱huay. ");
INSERT INTO tosNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pus na̱ chuná̱ chú̱, pala akskahuiní, chu̱ hua̱nti̱ ta̱scujma̱kó̱ natapa̱pitziko̱y, chu̱ natzucuy la̱lacatahuacako̱y, ¿pi̱ tla̱n cahuá̱ chú̱ maka̱s nakalhi̱y xli̱tlihuaka? Huá̱ chuná̱ cli̱quilhuama sa̱mpi̱ huixín huaná̱tit pi̱ quit ctamacaxtuy cspiritu akskahuiní sa̱mpi̱ mat quit cta̱scujma̱, chu̱ ckalhi̱y xli̱tlihuaka Beelzebú, chu̱ mat hua̱ xli̱tlihuaka̱ cli̱tamacaxtuko̱y cspiritu akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pus hua̱ lapi̱ xli̱ca̱na̱ quit ckalhi̱y xli̱tlihuaka Beelzebú, chu̱ hua̱ xpa̱lacata tla̱n cli̱tamacaxtuy cspiritu akskahuiní, ¿chá̱ hua̱nti̱ ca̱sta̱laniko̱yá̱n, chu̱ na̱ tamacaxtuko̱y akskahuinaní̱n? ¿Tí̱ chú̱ xma̱xqui̱ma̱kó̱ xli̱tlihuaka̱ chuná̱ tla̱n nali̱tlahuako̱y? Huá̱ xpa̱lacata̱ anta tuncán li̱ta̱kata̱ksa pi̱ ni̱ pala tzinú̱ catzi̱yá̱tit hua̱ntu̱ aklakuá̱ huaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pus quit hua̱ xli̱tlihuaka Dios cca̱li̱tamacaxtuy cspiritucan akskahuiní̱n laqui̱mpi̱ chuná̱ huixín nali̱catzi̱yá̱tit pi̱ yama̱ xasa̱sti xtapaksi̱t Dios hua̱ntu̱ nahuili̱y u̱nú̱ cca̱tiyatna, aya tzucuni̱t kantaxtuy c-milatama̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Huixín catzi̱yá̱tit pi̱ cha̱tum tlihuaka chixcú̱ hua̱nti̱ tla̱n ca̱xtahuilay sa̱mpi̱ kalhi̱y luhua tla̱n xli̱tala̱tna, chuná̱ tla̱n maktakalha̱ xchic, chu̱ ni̱ makacuán pacs hua̱ntu̱ kalhi̱y c-xchic, sampi aktziyaj tahuilay. ");
INSERT INTO tosNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Hua̱mpi̱ pala nalakchín cha̱tum li̱tum chixcú̱ hua̱nti̱ a̱tzinú̱ luhua tlihuaka ni̱ xahua̱ xlá, chu̱ pala namakatlajay, pus chuná̱ tla̱n namakkalhanko̱y hua̱ntu̱ xlá̱ xkalhi̱y; pus na̱ xta̱chuná̱ la̱ntla̱ quit ctlahuani̱t akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Na̱ chuná̱ chú̱ hua̱nti̱ ni̱ quit quinta̱ta̱yay, tamá̱ caj quilaksi̱tzi̱niy hua̱ntu̱ quit, cli̱scujma̱, chu̱ na̱ chuná̱ hua̱nti̱ ni̱ macxtum quinta̱ma̱macxtumi̱ko̱y tachixcuhuí̱tat laqui̱mpi̱ quit naclakma̱xtuko̱y, pus huata xlá̱ caj ma̱pa̱pitzima̱ laqui̱mpi̱ li̱huacá̱ naaktzanka̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Acxni̱ hua̱ cspiritu akskahuiní̱ ma̱makaxtaknicán cha̱tum chixcú, mákat án latapu̱li̱y, chu̱ lacaputzay xaní̱ luhua najaxa; hua̱mpi̱ acxni̱ ni̱ ta̱ksa, chuná̱ napuhuán: ‘Huata xatlá̱n uctaspitpalay c-quínchic anta̱ni̱ ctaxtuchá.’ ");
INSERT INTO tosNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Acxni̱ chú̱ nachín, ma̱noklhuy yama̱ chixcú xta̱chuná̱ la̱ aktum chiqui hua̱ntu̱ luhua tla̱n ca̱xya̱huacani̱t, chu̱ li̱huana̱ ca̱palhcani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Chu̱ lacapala̱ xlá̱ naán tiyako̱y a̱kalhatujun akskahuininí̱n hua̱nti̱ na̱ luhua lacli̱xcájnit li̱catzi̱ko̱y, chu̱ pu̱tum puxcu̱nanikoy a̱ma̱ chixcú̱ hua̱nti̱ xlá̱ aya xtatla̱ni̱ni̱t, pus yama̱ chixcú a̱tzinu̱ luhua li̱xcájnit huan xtapuhuá̱n ni̱ xahua̱ la̱ntla̱ xakasiya̱ xuani̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús chunacú̱ xchihui̱nama̱ acxni̱ cha̱tum pusca̱t, hua̱nti̱ antá̱ c-xlaksti̱pa̱n li̱lhu̱hua xkaxmatma̱ xtachihuí̱n, palha̱ chuná̱ quilhminchá: —¡Li̱pa̱xuhu lama̱ yama̱ pusca̱t hua̱nti̱ tima̱chixcuhui̱lí̱n, chu̱ ma̱tziquí̱n! ");
INSERT INTO tosNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hua̱mpi̱ xlá̱ chuná̱ kalhtí̱nalh: —Xli̱ca̱na̱ tu̱ huana, hua̱mpi̱ xali̱huaca li̱pa̱xuhu lama̱kó̱ hua̱nti̱ kaxmatko̱y xtachihui̱n Dios, chu̱ ma̱qui̱ko̱y c-xnacu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Cha̱nchu̱ pi̱ lhu̱hua tachixcuhuí̱tat xtamacxtumi̱ma̱kó̱ anta̱ni̱ xlaya̱ Jesús, xlá̱ chuná̱ tzúculh li̱xakatli̱ko̱y: “Koxutaní̱n yama̱ tachixcuhuí̱tat hua̱nti̱ lama̱kó̱ la̱nchiyú̱ quilhtamacú̱ sa̱mpi̱ luhua lacli̱xcájnit xtapuhua̱ncán, chu̱ ankalhí̱n quisquinima̱kó̱ cactláhualh aktum tlanca li̱ca̱cni tascújut laqui̱mpi̱ naquili̱ca̱najlaniko̱y pala xli̱ca̱na̱ Dios quimacamini̱t; hua̱mpi̱ huata xatlá̱n nacli̱ma̱lacahua̱ni̱ko̱y aktum tascújut xta̱chuná̱ la̱ntla̱ tu̱ Dios titláhualh maká̱n c-xlatama̱t profeta Jonás. ");
INSERT INTO tosNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xlá̱ caj xlatáma̱t li̱ma̱lacahua̱ni̱ko̱lh yama̱ xalakmaka̱n tachixcuhuí̱tat hua̱nti̱ xuilakó̱ c-Nínive pi̱ xli̱ca̱na̱ Dios xmacamini̱t; pus na̱ chuná̱ chú̱ quit, Xatalacsacni Chixcú, nacli̱ma̱lacahua̱ni̱ko̱y quilatáma̱t a̱ma̱ tachixcuhuí̱tat hua̱nti̱ lama̱kó̱ la̱nchú̱ yuma̱ quilhtamacú̱ pi̱ xli̱ca̱na̱ Dios quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ Dios nata̱tlahuako̱y cuenta̱ xli̱pacs tachixcuhuí̱tat, yama̱ pusca̱t hua̱nti̱ la̱ reina xma̱paksi̱nán xamaká̱n c-xaca̱chiqui̱n Seba, xlá̱ nata̱yay laqui̱mpi̱ naca̱ma̱lacapu̱yá̱n c-xlacati̱n Dios, huixín tachixcuhuí̱tat hua̱nti̱ huilátit ca̱la̱nchu̱ quilhtamacú̱; sa̱mpi̱ xlá̱ ma̱squi luhua mákat xuani̱t c-xca̱chiquí̱n, milh kaxmatniy xtachihui̱n yama̱ acstaca̱ rey Salomón, hua̱mpi̱ caucxílhtit, huixín ni̱ quinkaxpatniyá̱tit ma̱squi u̱nú̱ ca̱ta̱chihui̱namá̱n cha̱tum hua̱nti̱ tlak tlanca xlacatzúcut, chu̱ tastácat ni̱ xahua̱ rey Salomón. ");
INSERT INTO tosNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Hua̱ tachixcuhuí̱tat hua̱nti̱ maká̱n xuilakó̱ c-xaca̱chiqui̱n Nínive, na̱ nata̱yako̱y, chu̱ naca̱ma̱lacapu̱yá̱n c-xlacati̱n Dios acxni̱ nalakchá̱n quilhtamacú̱ acxni̱ xlá̱ nama̱xoko̱ni̱ko̱y tachixcuhuí̱tat, sa̱mpi̱ xlacán xli̱ca̱na̱ lakpali̱ko̱lh xali̱xcajnit xtalacapa̱stacnicán acxni̱ Jonás li̱xakatli̱ko̱lh xli̱ma̱paksi̱n Dios, hua̱mpi̱ huixín ni̱ pala tzinú̱ quinca̱najlaniputuná̱tit ma̱squi la̱nchú̱ ca̱ta̱chihui̱namá̱n cha̱tum ti̱ tlak tlanca̱ xlacatzúcut ni̱ xahua̱ profeta Jonás.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesús chuná̱ huampá̱: “Huixín catzi̱yá̱tit pi̱ ni̱tí̱ anán hua̱nti̱ nama̱pasi̱y aktum mákskot, chu̱ caj la̱ntla̱ nama̱pasi̱y chú̱ nama̱tze̱ka, usu nali̱akpulonkxuili̱y aktum caju̱n, pi̱ huata antá̱ nahuili̱y ta̱lhmá̱n c-xpu̱táhui̱lh laqui̱mpi̱ hua̱nti̱ natanu̱ko̱y c-chiqui̱ tla̱n naucxilhko̱y xkakánat. ");
INSERT INTO tosNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mintiyatli̱huacán na̱ kalhi̱y xli̱maksko, pus hua̱ milakastapu. Pala milakastapu̱ tla̱n lacahua̱nán xli̱pu̱tum mintiyatli̱hua̱ pacs tla̱n sampi̱ kalhi̱y xkakánat, hua̱mpi̱ lapi̱ milakastapu ni̱tlá̱n lacahua̱nán, xli̱pacs tu̱ huí̱ c-mintiyatli̱hua̱ xalakapoklhua li̱lama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pus luhua cui̱ntaj catlahuátit yama̱ xkakánat hua̱ntu̱ huaná̱tit pi̱ li̱lacahua̱naná̱tit laqui̱mpi̱ ni̱ xamaktum xalakaca̱poklhua nahuán. ");
INSERT INTO tosNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Chunachí̱ pi̱ lapi̱ mimacni kalhi̱y tla̱n xmakaxkaká̱nat, ni̱ xalakapoklhua li̱lama̱ nahuán, chu̱ chuná̱ tla̱n stalanca catu̱huá̱ naucxilha, xta̱chuná̱ la̱ntla̱ aktum mákskot acxni̱ ma̱pasi̱cán, lacaxtum li̱makskoy xli̱pacs xmakaxkaká̱nat.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Acxni̱ Jesús akchihui̱nanko̱lh, cha̱tum fariseo huánilh pi̱ naán ta̱hua̱yán c-xchic. Jesús álh, chu̱ acxni̱ tanu̱chá̱ c-chiqui, tuncán tahui̱ anta̱ni̱ xuí̱ pu̱hua̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yama̱ fariseo luhua xli̱ca̱na̱ caj cacs li̱lacahua̱ acxni̱ úcxilhli̱ pi̱ ni̱ chuná̱ xma̱kantaxti̱ma̱ la̱ntla̱ xli̱smani̱cani̱t xtlahuacán, sa̱mpi̱ xli̱pacs judíos pu̱lh xli̱makachakanko̱y tzinu̱ chúchut acxni̱ ni̱ a̱hua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hua̱mpi̱ Quimpu̱chinacán xcatzi̱y tu̱ xlacapa̱stacma̱, chu̱ chuná̱ huánilh: —Huixín fariseos luhua caj xma̱n chaka̱ko̱yá̱tit c-xmacni mivaso̱cán, chu̱ mimpula̱tucán, hua̱mpi̱ c-mimpu̱lacnicán, antá̱ c-minacu̱cán luhua li̱xcájnit huilachá̱ caj xpa̱lacata̱ hua̱ntu̱ tlahuayá̱tit pala takalhá̱n, usu pala lacli̱xcajnit talacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xli̱ca̱na̱ pi̱ luhua xalactzaca̱tna̱ huixín, ¿tú̱ catzi̱yá̱tit pi̱ Dios, hua̱nti̱ tlahuani̱t hua̱ntu̱ chaka̱makaná̱tit xala c-mimacnicán, na̱ huá̱ tlahuani̱t xala c-mimpu̱lacnicán, chu̱ xlá̱ pacs ucxilhma̱ hua̱ntu̱ antá̱ kalhi̱yá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huata tu̱ mili̱tlahuatcán: xapu̱lh nachaka̱yá̱tit tu̱ huí̱ nac mimpu̱lacnicán hasta c-minacu̱cán, chu̱ hua̱ namacama̱xqui̱yá̱tit Dios xta̱chuná̱ la̱ mili̱mosnajcán, chu̱ xli̱pacs hua̱ntu̱ kalhi̱yá̱tit c-mimacnicán na̱ xatachaká̱n nahuán c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Hua̱mpi̱, ¡koxutaní̱n huixín fariseos! Sa̱mpi̱ ma̱squi xli̱ca̱na̱ ma̱pa̱pitziyá̱tit, chu̱ la̱ midiezmojcán ma̱xqui̱yá̱tit Dios hua̱ntu̱ huixín makalayá̱tit pala yama̱ caca̱ huanicán menta, chu̱ ruda, chu̱ ti̱pa̱lhu̱hua̱ yama̱ lactzu̱ tachaná̱n, chu̱ mat hua̱ midiezmojcán, hua̱mpi̱ cumu ni̱ pala tzinú̱ cui̱ntaj tlahuayá̱tit hua̱ntu̱ Dios ca̱li̱ma̱paksi̱putuná̱n la̱ntla̱ luhua aksti̱tum nalatapa̱yá̱tit, pus huata hua̱ tamá̱ luhua xli̱ca̱na̱ mili̱tlahuatcán, chu̱ ma̱squi na̱ ni̱ nali̱makaxtaká̱tit tlahuayá̱tit hua̱ yamá̱ tu̱ a̱makapitzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Koxutaní̱n huixín fariseos! Sa̱mpi̱ anta̱ni̱ huixín tastoká̱tit, lacasquiná̱tit pi̱ naca̱ma̱xqui̱caná̱tit xacalacan lactáhui̱lh, chu̱ xa̱hua̱ lacasquiná̱tit pi̱ luhua tla̱n naca̱xakatli̱pa̱xtokcaná̱tit c-tiji̱ anta̱ni̱ huixín tla̱huaná̱tit la̱ lactali̱pa̱hu chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Koxutaní̱n huixín laktzokqui̱naní̱n chu̱ fariseos sa̱mpi̱ luhua xaaksani̱naní̱n, xta̱chuná̱ li̱taxtuyá̱tit la̱ aktum tahuaxni̱ anta̱ni̱ ma̱acnu̱cani̱t cha̱tum ni̱n, hua̱mpi̱ cumu ni̱ tasiyuy, chixcuhuí̱n ni̱ catzi̱ko̱y la̱ntla̱ lactla̱huanko̱y, chu̱ aklhtampusko̱y hua̱ntu̱ ni̱tlá̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Cha̱tum xcatzi̱na xli̱ma̱paksi̱n Dios chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, tamá̱ hua̱ntu̱ huix quilhuámpa̱t, la̱mpala na̱ xa̱ pacs quin quinca̱ma̱ma̱xani̱putuna. ");
INSERT INTO tosNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús chuná̱ kálhti̱lh: —¡Chu̱ xa̱ huixín ma̱kalhtahuaka̱naní̱n hua̱nti̱ ma̱siyuyá̱tit xli̱ma̱paksi̱n Moisés! ¡Koxutaní̱n huixín, sa̱mpi̱ juerza ma̱tlahui̱putunko̱yá̱tit tachixcuhuí̱tat, chu̱ huaniko̱yá̱tit cama̱kantaxti̱ko̱lh c-xlacati̱n Dios pacs lactzu̱ lactzú̱ tu̱ huan xli̱ma̱paksí̱n li̱tláhuat, hua̱mpi̱ huixín ni̱ pala tzinu̱ puhuaná̱tit nama̱kantaxti̱yá̱tit c-milatama̱tcán, chu̱ qui̱taxtuy lactzinca tacuca hua̱ntu̱ tu̱ huixín ni̱ lacchaxputuná̱tit! ");
INSERT INTO tosNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Koxutaní̱n huixín! Sa̱mpi̱ ma̱pulhuyá̱tit, chu̱ stla̱n ca̱xtlahua̱naniyá̱tit xpa̱tzapscan anta̱ni̱ acnu̱ko̱y yama̱ profetas hua̱nti̱ maká̱n timacaminko̱lh Dios, chu̱ hua̱nti̱ makni̱ko̱ni̱t xalakmaka̱n minatla̱tnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Xli̱ca̱na̱ catzi̱yá̱tit pi̱ hua̱ xlacán makni̱ko̱lh, chu̱ huá̱ xpa̱lacata huixín li̱ma̱pulhuyá̱tit xpa̱tzapscán anta̱ni̱ acnu̱ko̱y, hua̱mpi̱ huata c-milatama̱tcán luhua makli̱catzi̱yá̱tit hua̱ntu̱ xlacán tlahuako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Huachá̱ yuma̱ xpa̱lacata, hua̱ la̱ntla̱ Dios makaacchá̱n xtastácat xlá̱ chuná̱ tima̱tzokní̱nalh c-Li̱kalhtahuaka: ‘Quit nacmaca̱niko̱y profetas, chu̱ a̱makapitzi̱n quilacscujní̱n hua̱nti̱ nama̱catzi̱ni̱ko̱y quintalacapa̱stacni, hua̱mpi̱ xlacán makapitzí̱n namakni̱cán, chu̱ makapitzí̱n naputzasta̱lacán.’ ");
INSERT INTO tosNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ huixín makli̱catzi̱yá̱tit tu̱ tlahuako̱lh, Dios chú̱ naca̱ma̱xoko̱ni̱yá̱n huixín hua̱nti̱ lapá̱tit la̱nchiyú̱ yuma̱ quilhtamacú̱ caj xpa̱lacata xli̱stacnacan xli̱pacs profetas hua̱nti̱ makni̱ko̱cani̱t hasta la̱ntla̱ tzucuni̱t ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Li̱macatzucuy Abel ti̱ timakni̱ca̱, chu̱ hasta la̱ntla̱ timakni̱ca̱ Zacarías ti̱ ntíni̱lh c-xlacati̱n altar c-templo. Luhua chuná̱ cca̱huaniyá̱n pi̱ natasquinko̱y cui̱nta̱ tachixcuhuí̱tat xla yuma̱ quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Koxutaní̱n huixín xcatzi̱nani̱n xli̱ma̱paksi̱n Dios! Sa̱mpi̱ huixín ma̱lacchuhuaniko̱yá̱tit má̱laccha̱ yama̱ hua̱nti̱ putzako̱y la̱ntla̱ nalakapasko̱y xtalacapa̱stacni Dios; na̱ ni̱ pala huixín ma̱kantaxti̱pá̱tit, chu̱ ni̱ lacasquiná̱tit pala tí̱ luhua nalitzaksay, chu̱ nama̱kantaxti̱y a̱tanu̱ chixcuhuí̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Acxni̱ Jesús chuná̱ huanko̱lh yuma̱ tachihuí̱n, fariseos, chu̱ laktzokni̱naní̱n si̱tzi̱ko̱lh, chu̱ catu̱huá̱ tzúculh kalhasquinko̱y huantu caj xli̱akslokoko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Caj xli̱ucxilhputunko̱y pala tú̱ ni̱tlá̱n nahuán, chu̱ huá̱ nali̱sta̱huako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yama̱ quilhtamacú̱ luhua lhu̱hua tachixcuhuí̱tat xtamacxtumi̱ko̱ni̱t laqui̱mpi̱ nakaxmatniko̱y xtachihui̱n Jesús; na̱ xchinti̱lhako̱y hasta xla̱lacxquitiya̱huama̱kó̱. Hua̱mpi̱ Jesús tasaniko̱lh xli̱ma̱kalhtahuáka̱t sa̱mpi̱ huí̱ tu̱ xuaniputunko̱y, chu̱ chuná̱ huaniko̱lh: “Ca̱na̱ huixín, cui̱ntaj catlahuátit ni̱tú̱ naca̱ma̱pasi̱yá̱n ni̱tla̱n xta̱yatcan yama̱ xalakapu̱tiyu̱nani̱n fariseos, sa̱mpi̱ luhua xta̱chuná̱ caj la̱ntla̱ levadura acxni̱ cajcu actzú̱, chu̱ lakmaca̱ncán xasquitit harina pacs ma̱xcuti̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Sa̱mpi̱ ni̱tú̱ anán hua̱ntu̱ caj tze̱k tatlahu, usu talacapa̱stacni pala Dios ni̱ ca̱lakuá̱n nahuili̱y, chu̱ na̱ ni̱ anán tu̱ caj tze̱k li̱catzi̱cán pala ni̱ juerza ca̱lakuá̱n natamakaxtaka. ");
INSERT INTO tosNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Huachá̱ mili̱catzi̱tcán pi̱ hua̱ntu̱ xlacán ma̱squi tze̱k li̱chihui̱nanko̱y pala ca̱tzi̱sní, xli̱ca̱na̱ pi̱ nacatzi̱cán, chu̱ nali̱chihui̱nanko̱y acxni̱ ca̱cuhuiní; chu̱ ma̱squi pala tú̱ caj luhua lacatzucu̱ xli̱chihui̱nantanu̱ma̱kó̱ aktum tachihuí̱n c-aktum chiqui, pus a̱li̱sta̱lh namín quilhtamacú̱ nacatzi̱cán, chu̱ nali̱ca̱tasacán hasta c-xca̱aksti̱ní̱n lactlanca ta̱lhma̱n chiqui̱ laqui̱mpi̱ pacs nacatzi̱cán.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesús huanipalako̱lh: “Cca̱huaniyá̱n huixín ti̱ luhua cca̱pa̱xqui̱yá̱n: Ni̱ tipe̱cuaniko̱yá̱tit hua̱nti̱ ca̱makni̱putuná̱n, sa̱mpi̱ xlacán tla̱n makni̱ko̱y xtiyatli̱hua cha̱tum, hua̱mpi̱ a̱li̱sta̱lh nia̱lh lay tu̱ tla̱n natitlahuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Hua̱mpi̱ quit nacca̱huaniyá̱n hua̱nti̱ luhua quili̱pe̱cuanitcán: Huata huá̱ cape̱cuanítit Dios, sa̱mpi̱ xlá̱ la̱ntla̱ namakni̱ko̱y mintiyatlihua kalhi̱palay li̱tlihuaka̱ laqui̱mpi̱ namacá̱n mili̱stacnacán c-pu̱pa̱tí̱n lapi̱ xlá̱ chuná̱ lacasquín, pus huata huá̱ luhua cape̱cuanítit. ");
INSERT INTO tosNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Caj luhua caquihuanítit, ¿ní̱ntla̱ xtápalh tanquitzis lactzu̱ spu̱n? ¿Tú̱ chuná̱ pi̱ caj okxtuy tumi̱n li̱sta̱cán? Hua̱mpi̱ ma̱squi chuná, ni̱ pala tantum actzu̱ spu̱n pala tapa̱tzanka̱ni̱t c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pus hua̱ a̱nú̱ yuma̱ xpa̱lacata̱ cca̱li̱huaniyá̱n, pi̱ niucxni̱ tipe̱cuaná̱tit pala Dios ni̱ cui̱ntaj tlahuama̱ tu̱ ca̱akspulayá̱n, sa̱mpi̱ c-xlacati̱n Dios hasta ma̱squi minchixitcán hua̱ntu̱ ya̱kó̱ c-miakxe̱kacán, pacs tapu̱tlakaya̱huani̱t la̱ntla̱ kanatunu; chu̱ pi̱ huixín xcamán, ni̱ cali̱puhuántit sa̱mpi̱ tlak xali̱huacá̱ kalhi̱yá̱tit mixtapalhcán ni̱ xahua̱ pacs yama̱ lactzu̱ spu̱n hua̱ntu̱ kosma̱kó̱ ca̱u̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na̱ luhua cca̱huaniyá̱n pi̱ caxati̱cahuá̱ ti̱ nali̱ta̱yay c-xlaksti̱pa̱ncan li̱lhu̱hua̱ pi̱ xli̱ca̱na̱ quili̱pa̱huán, pus na̱ chuná̱ chú̱ quit na̱ nacli̱ta̱yaya̱chá̱ pi̱ xli̱ca̱na̱ huá̱ quilacscujni̱ c-xlacati̱n ángeles hua̱nti̱ ta̱lama̱ko̱chá̱ Dios c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Hua̱mpi̱ caxati̱cahuá̱ ti̱ ni̱ nali̱ta̱yaputún c-xlacati̱n li̱lhu̱hua̱ pi̱ xli̱ca̱na̱ quili̱pa̱huán, pus na̱ chuná̱ chú̱ quit ni̱ cactili̱ta̱yapútulh c-xlacati̱n ángeles hua̱nti̱ ta̱huilako̱chá̱ Dios c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Na̱ chuna li̱tum caxati̱cahuá̱ hua̱nti̱ cala̱huá̱ xquili̱kalhakamá̱nalh quit, Xatalacsacni Chixcú, Dios nama̱tzanka̱naniy xtala̱kalhí̱n, sa̱mpi̱ caj ni̱ catzi̱y; hua̱mpi̱ hua̱nti̱ cala̱huá̱ nali̱kalhakama̱nán, chu̱ nalakmakán hua̱ntu̱ xlá̱ luhua lacatancs catzi̱y pi̱ hua̱ xtatlahu Espíritu Santo, xlá̱ ni̱ lay catima̱tzanka̱nanica̱ xtala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Acxni̱ huixín naca̱li̱pincaná̱tit c-xpu̱kalhtahuakacan judíos, usu c-xlacati̱ncan ma̱paksi̱naní̱n, usu c-xlacati̱ncan xalactlanca napuxcún, ni̱ cali̱lakaputzátit xpa̱lacata la̱ntla̱ nakalhti̱naná̱tit acxni̱ natakalhmakta̱yayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sa̱mpi̱ acxni̱ nalakchá̱n yama̱ quilhtamacú̱ la̱ntla̱ nachihui̱naná̱tit, Espíritu Santo naca̱ma̱catzi̱ni̱yá̱n la̱ntla̱ nakalhti̱naná̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cha̱nchu̱ la̱ntla̱ xtzamacán cha̱tum chixcú̱ chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, cahuani̱ quinta̱lá̱ pi̱ luhua lacxtum caquinta̱ma̱pa̱pitzínilh makaaná̱nat hua̱ntu̱ quinca̱makaxtaknini̱tán quintla̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Hua̱mpi̱ Jesús chuná̱ kálhti̱lh: —Chixcú, ¿tú̱ xpa̱lacata quili̱putzaya̱ quit? Usuchí̱ ¿tí̱ quihuili̱ni̱t li̱juez c-milaksti̱pa̱ncán laqui̱mpi̱ nacca̱ma̱pa̱pitziniyá̱n hua̱ntu̱ ca̱lakcha̱ná̱n makaaná̱nat? ");
INSERT INTO tosNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Xlá̱ chuná̱ huanipalako̱lh: —Luhua cui̱ntaj catlahuátit ni̱ tiaktzanka̱yá̱tit, chu̱ nalakati̱yá̱tit nakalhi̱putuná̱tit luhua lhu̱hua tumi̱n; sa̱mpi̱ yama̱ xaxli̱ca̱na̱ li̱pa̱xuhu xlatama̱t cha̱tum, ni̱ antá̱ li̱quilhtzucuy hua̱ntu̱ xli̱lhu̱hua xtumi̱n, usu xmakaaná̱nat hua̱ntu̱ kalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na̱ li̱xakatli̱ko̱lh yuma̱ aktum xali̱ucxílhti̱t takalhchihuí̱n: “Maktum xuí̱ cha̱tum chixcú, hua̱mpi̱ luhua xli̱ca̱na̱ ma̱tamacu̱nú xuani̱t, xkalhi̱y lakatum xpú̱cuxtu, hua̱mpi̱ luhua xcátzi̱t xlana̱nán, chu̱ anta̱ni̱ chaná̱nalh luhua tlak makalaná̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chú̱ pi̱ luhua lhu̱hua̱ hua̱ntu̱ xmakalana̱nani̱t, a̱ma̱ ma̱tamacu̱nú̱ chuná̱ tzúculh lacapa̱staca: ‘¿Tú̱ cahuá̱ nactlahuay, sa̱mpi̱ chú̱ nia̱lh anán anta̱ni̱ nacma̱qui̱y quimakalaná̱nat?’ ");
INSERT INTO tosNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Puschí̱ chuná̱ puhua̱: ‘Huata xatlá̱n naclactilha̱ xpu̱tahui̱lh quimakalaná̱nat, chu̱ tanu̱ nactlahuay hua̱ntu̱ tlak tlanca laqui̱mpi̱ pacs antá̱ nacma̱qui̱y quincuxi, chu̱ pu̱tum hua̱ntu̱ ckalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Cha̱nchu̱ a̱li̱sta̱lh chuná̱ nacuaniy quili̱stacna: Chú̱ luhua lhu̱hua̱ kalhi̱ya̱hu tumi̱n hua̱ntu̱ namaclacasquina̱hu aklhu̱hua ca̱ta, sa̱mpi̱ tla̱n ma̱stokuili̱ko̱ni̱tahu. Ni̱tú̱ cali̱ta̱katzanka, huata xatlá̱n chú̱ caj cajaxui, tla̱n cahua̱yahu, chu̱ luhua li̱pa̱xuhu calatama̱hu.’ ");
INSERT INTO tosNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Hua̱mpi̱ Dios xakátli̱lh yama̱ chixcú, chu̱ chuná̱ huánilh: ‘Xatzaca̱t chixcú̱ huix, ni̱ pala tzinú̱ catzi̱ya̱ hua̱ntu̱ naakspulayá̱n, huatiya yuma̱ ca̱tzi̱sní̱ nani̱ya, chi̱nchu̱ la̱ntla̱ xli̱lhu̱hua̱ hua̱ntu̱ ma̱qui̱ni̱ta, ¿tí̱ chú̱ xlá̱ nahuán?’ ");
INSERT INTO tosNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pus xli̱ca̱na̱ chuná̱ na̱ma̱ akspulay hua̱nti̱ luhua lhu̱hua̱ acstuma̱akstokuili̱putún xtumi̱n u̱nú̱ ca̱tiyatna, hua̱mpi̱ c-xlacati̱n Dios ni̱tú̱ kalhi̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A̱li̱sta̱lh Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: “Luhua caakatá̱kstit hua̱ntu̱ nacca̱huaniyá̱n: Ni̱ luhua taji̱ cali̱ta̱katzanká̱tit pala tu̱ nahuayá̱tit cha̱li̱ cha̱lí̱ laqui̱mpi̱ tla̱n nali̱latapa̱yá̱tit, usu xpa̱lacata mimacnicán pala tu̱ nalhaka̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sa̱mpi̱ luhua tlak lhu̱hua̱ xtápalh quili̱stacnacán ni̱ xahua̱ quili̱stakuancán, chu̱ tlak xlacasquinca̱ quintiyatli̱huacán ni̱ xahua̱ quilhaka̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Caj luhua caucxílhtit lactzu̱ spu̱n hua̱ntu̱ kosko̱y ta̱lhmá̱n ca̱u̱ní̱n, xlacán ni̱ chana̱nanko̱y, chu̱ na̱ ni̱ pala xka̱nanko̱y, chu̱ na̱ ni̱ pala tú̱ kalhi̱ko̱y xpu̱ma̱qui̱cán; hua̱mpi̱ ma̱squi chuná̱ Dios ankalhí̱n makta̱yako̱y, chu̱ ma̱hui̱ko̱y. ¿A poco ni̱ xaa̱li̱huaca lhu̱hua̱ xtápalh huixín ni̱ xahua̱ lactzu̱ spu̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Caquihuanítit, ¿xatí̱ cahuá̱ huixín hua̱ caj xpa̱lacata nali̱ta̱akatzanka̱y tla̱n nama̱tla̱ni̱y nama̱li̱huaca̱y ca̱na̱ caj aktum hora xlatáma̱t pala aya ni̱majá? ");
INSERT INTO tosNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pus hua̱ lapi̱ ni̱ lay ma̱tla̱ni̱yá̱tit hua̱ntu̱ luhua ni̱ pala tuhuaj tuncán, ¿tú̱ chú̱ luhua li̱layá̱tit li̱acchichijuaná̱tit ca̱ta catu̱huá̱? ");
INSERT INTO tosNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Caj luhua caucxílhtit lakli̱lakáti̱t xánat la̱ntla̱ stacko̱y ca̱pu̱cuxtú̱n. Xlacán ni̱ scujko̱y, ni̱ pala tlahuako̱y hua̱ntu̱ nali̱lhaka̱nanko̱y, hua̱mpi̱ luhua lacatancs cca̱huaniyá̱n pi̱ hasta ni̱ pala hua̱ yama̱ xamaka̱n rey Salomón, ma̱squi luhua lhu̱hua̱ hua̱ntu̱ xkalhi̱y lakli̱lakati̱t xli̱taca̱xta̱y, niucxni̱ chuná̱ li̱lakáti̱t lhaká̱nalh xta̱chuná̱ la̱ntla̱ tasiyuko̱y yuma̱ xaxanat ca̱pu̱cuxtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pus chú̱ luhua capuhuántit, hua̱ lapi̱ Dios chuná̱ ca̱xya̱huako̱y xánat, chu̱ xli̱pacs lactzu̱ tuhuá̱n hua̱ntu̱ ananko̱y ca̱tuhuá̱n, ma̱squi xlá̱ catzi̱y pi̱ la̱nchiyú̱ luhua lakli̱lakáti̱t stakuanaya̱, hua̱mpi̱ caj li̱cha̱lí̱ naxnakkoy, chu̱ nama̱pu̱cán c-lhcúya̱t, ¿tú̱ xali̱huacá̱ chú̱ huixín hua̱nti̱ xcamán ni̱ catica̱ma̱xquí̱n hua̱ntu̱ nali̱lhaka̱naná̱tit? ¿Tú̱ luhua xpa̱lacata ni̱ lay li̱pa̱huaná̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chuná̱ pi̱ ni̱ a̱huan huá̱ tili̱lakaputzayá̱tit xpa̱lacata tu̱ nahuayá̱tit, usuchí̱ hua̱ntu̱ nali̱kotnaná̱tit, chu̱ ni̱ caj huá̱ tili̱lacapa̱stacá̱tit, na̱ ni̱ caj hua̱ tili̱acchichijuananá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sa̱mpi̱ xli̱pacs tachixcuhuí̱tat hua̱nti̱ lama̱kó̱ u̱nú̱ ca̱tuxá̱huat, chu̱ ni̱ li̱pa̱huanko̱y Dios, xlacán caj luhua xma̱n huá̱ li̱ta̱katzanka̱ma̱kó̱, hua̱mpi̱ ni̱ hua̱ huixín camaklhtasti̱kó̱tit hua̱ntu̱ xlacán tlahuako̱y, sa̱mpi̱ huixín kalhi̱yá̱tit cha̱tum Mintla̱ticán hua̱nti̱ ca̱maktakalhá̱n, xa̱huachí̱ xlá̱ aya catzi̱y hua̱ntu̱ huixín ca̱tzanka̱nimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Huata xatlá̱n tu̱ cca̱huaniyá̱n, xapu̱lana̱ huá̱ caputzátit xli̱ma̱paksi̱n Dios, chu̱ xlá̱ catzi̱y la̱ntla̱ naca̱maktakalhá̱n, chu̱ naca̱ma̱xqui̱yá̱n hua̱ntu̱ namaclacasquiná̱tit.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Chuná̱ huanipalako̱lh: “Koxutaní̱n huixín quiamigos, ni̱ camacpuhuántit, ma̱squi ni̱ milhu̱huacán, hua̱mpi̱ Mintla̱tican Dios luhua li̱pa̱xuhuay pi̱ hua̱ naca̱ma̱paksi̱yá̱n xli̱ankalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pacs hua̱ntu̱ kalhi̱yá̱tit castá̱tit, chu̱ xatumi̱n cali̱makta̱yakó̱tit hua̱nti̱ luhua qui̱tzanka̱niko̱y, chu̱ chuná̱ chú̱ huixín nali̱tlahuayá̱tit xta̱chuná̱ la̱ntla̱ anta̱ni̱ nama̱qui̱yá̱tit mintumi̱ncán hua̱ntu̱ niucxni̱ lakuán, chu̱ chuná̱ huixín nakalhi̱yá̱tit xta̱chuna la̱ mintamacu̱ncán hua̱ntu̱ nali̱pa̱xuhuayá̱tit c-akapú̱n, xa̱huachí̱ niucxni̱ catiláksputli, chu̱ ni̱ pala kalha̱ná̱ tla̱n catimaklhtí̱n, ni̱ pala xalu̱hua catipásalh hua̱ntu̱ nama̱laksputuy. ");
INSERT INTO tosNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sa̱mpi̱ anta̱ antani̱ huixín nahuili̱yá̱tit mintapa̱xuhua̱ncán, chuná̱ pala lhu̱hua mintumi̱ncán ma̱stokqui̱yá̱tit c-milatama̱tcán, pus na̱ antá̱ namakaxtaká̱tit mili̱stacnacán.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús chuná̱ huanipalako̱lh: “Luhua xli̱ca̱na̱ skálalh cata̱tahuilátit xapasán mimakskotcán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xta̱chuná cali̱taxtútit la̱ yama̱ lacuan scujní̱n hua̱nti̱ kalhkalhi̱ma̱kó̱ xma̱la̱nacán acxni̱ naqui̱taspita̱ c-aktum pu̱tapu̱chuhu, laqui̱mpi̱ tuncán nama̱lacqui̱niko̱y acxni̱ xlá̱ nachín, chu̱ natzucuy lakatlaka̱ má̱laccha. ");
INSERT INTO tosNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Luhua xli̱ca̱na̱ namakapa̱xuhuako̱y xma̱la̱nacan yama̱ scujní̱n hua̱nti̱ chunatiyá̱ lacahua̱nama̱kó̱, chu̱ ni̱tu̱ lhtatatama̱kó̱ naca̱lakchincán; chu̱ huata hua̱ xma̱la̱nacán nahuaniko̱y pi̱ catahuilako̱lh anta̱ni̱ huí̱ pu̱hua̱y, chu̱ natzucuy lakahuili̱ko̱y xli̱huatcán laqui̱mpi̱ acxtum nata̱hua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sa̱mpi̱ ma̱squi acxni̱ xmilh acxni̱ makcu̱tuy ca̱tzi̱sní, usu acxni̱ aya xkakay cachilh, hua̱mpi̱ hua̱ lapi̱ xta̱ksko̱lh pi̱ ni̱tú̱ lhtatama̱kó̱, pus luhua xli̱ca̱na̱ napa̱xuhuako̱y yuma̱ scujní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Chu̱ na̱ chuna li̱tum, luhua cacatzítit, pi̱ lapi̱ xcátzi̱lh xpu̱china chiqui xatú̱ ya̱ quilhtamacú̱ nalaktanu̱y kalha̱ná, xli̱ca̱na̱ pi̱ luhua skálalh xtahui̱, chunatiyá̱ xlacahua̱nantahui̱, chu̱ ni̱ clhtátalh laqui̱mpi̱ ni̱ xmá̱sta̱lh talacasquín nalaktanu̱cán, chu̱ namakkalha̱nancán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pus na̱ chuná̱ chú̱ huixín, skálalh catahuilátit, sa̱mpi̱ acxni̱ luhua ni̱ li̱catzi̱huilátit nacmimpalay quit, Xatalacsacni Chixcú.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Acxni̱ Jesús chihui̱nanko̱lh, Pedro chuná̱ kalhásquilh: —Quimpu̱chiná, yuma̱ takalhchihuí̱n hua̱ntu̱ huix huanti, ¿pi̱ caj xma̱n quin quinca̱huanípa̱t hua̱nti̱ cca̱ta̱lapu̱layá̱n, chipi̱ na̱ xa̱huá̱ huanipa̱kó̱ cati̱huá̱? ");
INSERT INTO tosNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Quimpu̱chinacán chuná̱ kálhti̱lh: “Pus quit pu̱tum cuanima̱kó̱ hua̱nti̱ tla̱n xtapuhua̱ncán, chu̱ hua̱nti̱ scujnima̱kó̱ Dios, na̱ luhua xta̱chuná̱ la̱ cha̱tum ma̱la̱ná acxni̱ ma̱puxcu̱ni̱y cha̱tum cscujni̱ laqui̱mpi̱ xlá̱ namaktakalhko̱y, chu̱ nama̱hui̱ko̱y acxni̱ natzincsko̱y a̱makapitzi̱n scujní̱n, sa̱mpi̱ xlá̱ mákat anta̱ni̱ naán paxia̱lhnán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Hua̱mpi̱ xli̱ca̱na̱ luhua li̱pa̱xuhu naqui̱taxtuniy yama̱ scujni acxni̱ nachín xma̱la̱ná, chu̱ chuná̱ xlá̱ ma̱kantaxti̱ma̱ yama̱ tascújut hua̱ntu̱ tili̱ma̱paksi̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pus luhua lacatancs cca̱huaniyá̱n pi̱ yama̱ xama̱la̱ná̱ huata huá̱ nama̱cui̱ntajli̱ko̱y xli̱pacs hua̱ntu̱ xlá̱ kalhi̱y c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Hua̱mpi̱ luhua ni̱ pala tzinú̱ tla̱n hua̱ntu̱ naakspulay hua̱nti̱ ni̱tla̱n xtapuhua̱n cha̱tum scujni, xlá̱ napuhuán pi̱ ni̱ naj lacapala̱ catíchilh xma̱la̱ná sa̱mpi̱ ma̱x namakapalay; huata tu̱ xla̱ natlahuay caj natzucuy ma̱pa̱ti̱ni̱ko̱y makapitzi̱n scujní̱n, na̱ chuná̱ squitiní̱n lacchaján, xa̱huachí̱ caj natzucuy li̱huana̱ hua̱yán, chu̱ natzucuy kota, chu̱ tla̱n nakachi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Acxni̱ yama̱ scujni chuná̱ xlá̱ lama̱, yama̱ ma̱la̱ná caj xamaktum acxni̱ xlá̱ nachín, hua̱mpi̱ cumu xlá̱ ni̱ pala tzinú̱ xpuhuán pala naminá, xlá̱ ni̱ xkalhi̱ma̱, chu̱ ni̱ xli̱a̱catzi̱hui̱ pala aya nalakchincán, pus chuná̱ xlá̱ nama̱pa̱ti̱ni̱cán xta̱chuná̱ la̱ntla̱ ma̱pa̱ti̱ni̱ko̱cán pacs hua̱nti̱ kalhakaxmatmakanko̱y Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Yama̱ scujni̱ ti̱ catzi̱y hua̱ntu̱ lakati̱y xma̱la̱ná, hua̱mpi̱ na̱ ni̱ skálalh huí̱, xa̱huachí̱ na̱ ni̱ li̱scujputún hua̱ntu̱ xlá̱ li̱ma̱paksi̱cán, pus tla̱n nama̱pa̱ti̱ni̱cán, chu̱ nalaksnokuili̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Hua̱mpi̱ yama̱ scujni̱ hua̱nti̱ ni̱ catzi̱y pala ni̱tlá̱n hua̱ntu̱ tlahuama̱, chu̱ natlahuay hua̱ntu̱ mini̱niy nali̱ma̱pa̱ti̱ni̱cán, pus ni̱ luhua xta̱chuná̱ catilaksnokuili̱ca̱. Sa̱mpi̱ yama̱ scujni hua̱nti̱ a̱tzinú̱ lhu̱hua̱ ma̱xqui̱cani̱t talacapa̱stacni̱ laqui̱mpi̱ tla̱n lhu̱hua̱ nama̱maktakalhni̱cán hua̱ntu̱ xlá̱ nacui̱ntajlay, pus na̱ a̱tzinú̱ luhua lhu̱hua̱ namakputzacán hua̱ntu̱ xlá̱ namacama̱sta̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús chuná̱ huanipalako̱lh: “Quit cmini̱t ma̱lacpasi̱y lhcúya̱t u̱nú̱ ca̱tiyatna, sa̱mpi̱ caj xpa̱lacata quintachihuí̱n, chu̱ quintapáksi̱t nali̱tzucuy tasi̱tzi, chu̱ luhua clacasquín xlacpasalhá̱ yuma̱ lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Hua̱mpi̱ pu̱laná̱ naquili̱ucxilhcán aktum tapa̱tí̱n pala xli̱ca̱na̱ nacta̱yaniy, hua̱mpi̱ cli̱puhuán, chu̱ cpuhuán pi̱ luhua ca̱na̱ calakcha̱lhá̱ a̱ma̱ quilhtamacú̱ acxni̱ pacs nakantaxtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Huixín ma̱x puhuaná̱tit pi̱ quit cmini̱t makaxtaka̱ tatancsni, chu̱ tapa̱xuhuá̱n ca̱tuxá̱huat, pus huata luhua cca̱huaniyá̱n pi̱ ni̱ chuná, sa̱mpi̱ caj quimpa̱lacata̱ nali̱tzucuy tasi̱tzi, chu̱ natapa̱pitziko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sa̱mpi̱ c-aktum chiqui̱ anta̱ni̱ huilaca̱, li̱kalhaquitzis pu̱lactuy natapa̱pitziko̱y caj quimpa̱lacata, pu̱lactum li̱cha̱tuy, chu̱ pu̱lactum li̱kalhatutu, chu̱ natzucuy la̱makasi̱tzi̱ko̱y, chu̱ nala̱lacata̱qui̱y xacstucán. ");
INSERT INTO tosNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cha̱tum kahuasa nata̱la̱makasi̱tzi̱y xtla̱t, chu̱ xatla̱t na̱ nata̱la̱lacatahuacay xkahuasa; na̱ chuná cha̱tum pusca̱t nata̱la̱makasi̱tzi̱y xtzuma̱t, chi̱nchu̱ yama̱ tzuma̱t na̱ nata̱la̱lacatahuacay xtzi; chu̱ cha̱tum pusca̱t nata̱la̱makasi̱tzi̱y xpusca̱t xkahuasa, chi̱nchu̱ yama̱ xapu̱huiti̱ na̱ nata̱la̱lacata̱qui̱y xpu̱tiya̱tzí.” ");
INSERT INTO tosNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús huanipalako̱lh tachixcuhuí̱tat: “Acxni̱ huixín ucxilhá̱tit pi̱ tzucuy tapucsa̱chá̱ anta̱ni̱ pulha̱chá̱ chichiní, chuná̱ huaná̱tit: ‘Chú̱ luhua caj nasenán’, chu̱ ca̱na̱ chuná̱ qui̱taxtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chu̱ acxni̱ smilli mina̱chá̱ xachichi u̱n pa̱kalhajú̱, huaná̱tit: ‘Chú̱ luhua tla̱n nalhca̱cnán’, chu̱ ca̱na̱ chuná̱ qui̱taxtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Aksani̱nani̱n! ¡Lakapu̱tiyu̱naní̱n! Lapi̱ xli̱ca̱na̱ huixín tla̱n ma̱lakchipiniyá̱tit la̱ntla̱ natahuilay tantacú̱ quilhtamacú̱ acxni̱ talacaya̱huayá̱tit, chu̱ ucxilhá̱tit la̱ntla̱ tasiyuy akapú̱n, chu̱ ca̱quilhtamacú̱; cumu pala xli̱ca̱na̱ tla̱n akata̱ksá̱tit yumá̱, ¿tú̱huan chá̱ ma̱squi ucxilhá̱tit hua̱ntu̱ cca̱li̱ma̱lacahua̱ni̱yá̱n ni̱ li̱catzi̱yá̱tit li̱huana̱ naakata̱ksá̱tit hua̱ntu̱ aya ca̱lakchini̱tán?” ");
INSERT INTO tosNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesús huanipalako̱lh yama̱ tachixcuhuí̱tat: “¿Tú̱huan chi̱nchu̱ ni̱ li̱putzayá̱tit huixín hua̱ntu̱ luhua xli̱ca̱na̱ xlí̱lat c-milatama̱tcán? ");
INSERT INTO tosNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pus pala cha̱tum minta̱chixcú̱, catzi̱ya̱ pi̱ si̱tzi̱niyá̱n, chu̱ catzi̱ya̱ pi̱ aya nama̱lacapu̱yá̱n c-xlacati̱n ma̱paksi̱naní̱n, huata xatla̱n huix lacapalaj tuncán cata̱lacca̱xla̱, xli̱makua̱ ni̱ a̱ma̱lacapu̱yá̱n c-pu̱ma̱paksí̱n; la̱qui̱mpi̱ ni̱ huá̱ pala namakstuntlahuayá̱n nac xmacan juez, cha̱nchu̱ hua̱ juez nac xmacán máyu̱lh namacama̱sta̱yá̱n pi̱ napa̱ti̱nana̱ c-pu̱la̱chi̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Luhua cca̱huaniyá̱n pi̱ pala antá̱ nama̱nu̱cana, ni̱ catitamacaxtuca̱ hasta ni̱ li̱huaya̱ naxokoya̱ mimu̱lhta̱ hua̱ntu̱ antá̱ nasquinicana.” ");
INSERT INTO tosNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Caj li̱puntzú̱ laktalacatzúhui̱lh anta̱ni̱ xyá̱ Jesús makapitzi̱n chixcuhuí̱n hua̱nti̱ tzucuko̱lh li̱xakatli̱ko̱y la̱ntla̱ gobernador Pilato xma̱makni̱nanko̱ni̱t makapitzi̱n chixcuhuí̱n xala c-Galilea. Xlacán makni̱ko̱ca̱ c-tlanca templo xala c-Jerusalén luhua anta̱ni̱ pa̱lijni̱ xmakni̱ko̱y xtakalhi̱ncán tu̱ li̱ca̱xtlahua̱naniko̱y Dios, chu̱ luhua lacxtum tama̱stajako̱lh xkalhnicán la̱ntla̱ xla yama̱ chixcuhuí̱n, chu̱ xla lactzu̱ takalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús chuná̱ kalhti̱ko̱lh: “¿Huixín ma̱x puhuaná̱tit pi̱ Dios huá̱ chuná̱ li̱ma̱akspuli̱ko̱lh yama̱ chixcuhuí̱n xala c-Galilea caj xpa̱lacata xlacán tlak luhua lhu̱hua̱ xtala̱kalhi̱ncán ni̱ xahua̱ a̱makapitzi̱n xta̱chiquican xalac Galilea? ");
INSERT INTO tosNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pus luhua xli̱ca̱na̱ pi̱ ni̱ huá̱ xpa̱lacata, hua̱mpi̱ cca̱huaniyá̱n pi̱ ma̱squi cati̱hua̱ huixín, lapi̱ ni̱ nalakpali̱yá̱tit xali̱xcajnit mintalacapa̱stacnicán, na̱ chuná̱ naca̱akspulayá̱n napa̱ti̱naná̱tit mili̱pacscán c-xlacati̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Huixín na̱ catzi̱yá̱tit la̱ntla̱ ni̱ko̱lh yama̱ kalhacu̱tzayan chixcuhuí̱n acxni̱ lacxticako̱lh xapa̱tzaps yama̱ torre xala c-Siloé. ¿Na̱ ma̱x puhuaná̱tit pi̱ chuná̱ ma̱akspuli̱ko̱lh Dios sa̱mpi̱ xlacán a̱tzinú̱ luhua lhu̱hua̱ xkalhi̱ko̱y xtala̱kalhi̱ncán, ni̱ xachuná̱ makapitzi̱n xta̱chiquicán hua̱nti̱ xuilakó̱ c-Jerusalén? ");
INSERT INTO tosNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pus ni̱ hua̱ chuná̱ li̱akspulako̱lh, hua̱mpi̱ lapi̱ huixín na̱ ni̱ nalakpali̱yá̱tit xali̱xcajnit mintalacapa̱stacnicán, pus mili̱pacscán na̱ chuná namín quilhtamacú̱ acxni̱ napa̱ti̱naná̱tit c-xlacati̱n Dios.” ");
INSERT INTO tosNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na̱ tihuaniko̱lh yuma̱ takalhchihuí̱n: “Maktum cha̱tum chixcú̱ xchani̱t c-xpú̱cuxtu akatum xaquihui higo, chu̱ ca̱ta ca̱ta̱ xan ucxilha̱ pala aya huaca̱ xtahuácat; hua̱mpi̱ acxni̱ xlá̱ xqui̱chá̱n ni̱tú̱ títa̱ksli. ");
INSERT INTO tosNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Maktum huánilh xtasa̱cua̱ hua̱nti̱ xmaktakalha̱ yama̱ pú̱cuxtu: ‘Kahu, chiyú̱ aya xli̱aktututa ca̱ta̱ la̱ntla̱ xankalhí̱n cmin makputzay pala huaca̱ xtahuácat, hua̱mpi̱ niucxni̱ cta̱ksniko̱y. Huata xatlá̱n maktum catanca̱pi. ¿Tú̱huan caj xma̱n chuná̱ akchipani̱t ca̱tiyatna?’ ");
INSERT INTO tosNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Hua̱mpi̱ yama̱ chixcú̱ hua̱nti̱ xmaktakalhma̱ yama̱ pú̱cuxtu, chuná̱ kálhti̱lh: ‘Tla̱ti, huata xatlá̱n camakaxtakka̱ya̱ ca̱na̱ pi̱ a̱huan huá̱ yuma̱ ca̱ta; nactanti̱huaxa, na̱ nacuili̱niy xamasni palhma̱ tu̱ xatla̱n tíyat. ");
INSERT INTO tosNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chicá̱ pala xamaktum chuná̱ natahuacay xtahuácat, chu̱ a̱ca̱ta̱ pala ni̱ natahuacay xtahuácat, pus tuncán nactanca̱mi̱y.’” ");
INSERT INTO tosNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aktum quilhtamacu̱ sábado, acxni̱ pacs judíos xjaxko̱y, Jesús xma̱kalhtahuaka̱ma̱kó̱ tachixcuhuí̱tat c-aktum xpu̱kalhtahuakacan judíos. ");
INSERT INTO tosNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pus na̱ antá̱ xtanu̱ma̱ cha̱tum pusca̱t, xlá̱ aya xkalhi̱yá̱ akcu̱tzayan ca̱ta̱ la̱ntla̱ xma̱chipi̱ni̱t tajátat cspiritu akskahuiní, chu̱ chunatiyá̱ xlama̱ ni̱ lay xta̱ctzaja̱ la̱ntla̱ aklhcha̱puncsua xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Acxni̱ úcxilhli̱ Jesús, tasánilh, chu̱ chuná̱ huánilh: —Pusca̱t, xli̱pacs mintajátat la̱nchú̱ quit nacma̱pacsaniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Li̱macachípalh xmacán, chu̱ tuncán yama̱ pusca̱t tla̱n táactzajli, chu̱ pacsli; xlá̱ tzúculh pa̱xcatcatzi̱niy Dios hua̱ntu̱ xtlahuani̱t xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Cha̱nchu̱ xapuxcu xala c-pu̱kalhtahuaka tisí̱tzi̱lh xpa̱lacata̱ pi̱ xma̱pacsanani̱t Jesús yama̱ quilhtamacú̱ acxni̱ xli̱pacs judíos xjaxko̱y, chu̱ chuná̱ huaniko̱lh ti̱ antá̱ tamakstokko̱ni̱t: —Kalhi̱yá̱tit akcha̱xan quilhtamacú̱ acxni̱ pacs tla̱n nascuja̱hu, huata xatlá̱n acxni̱ nataná̱tit laqui̱mpi̱ tla̱n naca̱ma̱pacsacaná̱tit mintajatatcán, chu̱ ni̱ huata acxni̱ nataná̱tit acxni̱ lakcha̱ni̱t quilhtamacú̱ acxni̱ jaxcán. ");
INSERT INTO tosNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hua̱mpi̱ Quimpu̱chinacán chuná̱ kálhti̱lh: —¡Lakapu̱tiyu̱naní̱n pacs huixín hua̱nti̱ chuná̱ lacapa̱stacá̱tit! Chú̱ caquihuanítit, ¿pi̱ ni̱ xcutá̱tit huixín mia̱xnujcán, usu mintorojcán acxni̱ lakcha̱ni̱t quilhtamacu̱ sábado acxni̱ ni̱tí̱ scuja laqui̱mpi̱ nama̱kotni̱yá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pus chú̱ li̱huana̱ calacapa̱stáctit, sa̱mpi̱ yuma̱ pusca̱t na̱ hua̱ xquilhtzucut xamaka̱n quintla̱tcan Abraham xta̱chuná̱ la̱ntla̱ huixín, hua̱mpi̱ xlá̱ aya xkalhi̱y akcu̱tzayan ca̱ta la̱ntla̱ cspiritu akskahuiní̱ xmakapa̱ti̱ma̱, ¿lá̱ntla̱ pi̱ ni̱tlá̱n chú̱ quit nacxcutmakaniy xli̱tlihuaka akskahuiní̱ yuma̱ quilhtamacú̱ acxni̱ li̱huancán pala tí̱ nascuja? ");
INSERT INTO tosNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Acxni̱ chuná̱ huanko̱lh tachihuí̱n, yama̱ chixcuhuí̱n hua̱nti̱ xta̱la̱tlahuama̱kó̱ Jesús, luhua tla̱n xma̱ma̱xani̱ko̱ni̱t; hua̱mpi̱ la̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat, luhua tzucuko̱lh li̱pa̱xuhuako̱y hua̱ntu̱ xlá̱ xtlahuama̱ lactlanca̱ xtascújut. ");
INSERT INTO tosNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Chuná̱ xla̱ huanipalako̱lh: “¿Tú̱ luhua xta̱chuná̱ tla̱n nata̱ma̱lacastuca̱hu xasa̱sti xtapaksi̱t Dios hua̱ntu̱ ma̱tzuqui̱putún ca̱tiyatna? Usu ¿tú̱ ya̱ takalhchihuí̱n tla̱n ta̱ma̱lacxtumi̱ya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ma̱x luhua xta̱chuná̱ naqui̱taxtuy la̱ntla̱ acxni̱ cha̱tum chixcú̱ án chan c-xli̱pacán aktum xatalhtzi mostaza. La̱ntla̱ xli̱pacs quihui̱ hua̱ xlá̱ tlak luhua actzú̱ ma̱sta̱y xtalhtzi, hua̱mpi̱ xlá̱ acxni̱ tzucuy staca, luhua tlanca quihui huan, chu̱ lhu̱hua lactzu̱ spu̱n hua̱ntu̱ kosko̱y ca̱u̱ní̱n, c-xakaní̱n tla̱n tlahuako̱y xma̱sakacán.” ");
INSERT INTO tosNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tihuampá̱ a̱maktum: “¿Tú̱ cahuá̱ tla̱n nata̱ma̱lacxtumi̱ya̱hu xasa̱sti xtapaksi̱t Dios hua̱ntu̱ xlá̱ ma̱tzuqui̱ma̱? ");
INSERT INTO tosNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ma̱x xta̱chuná̱ nata̱kahuani̱y la̱ntla̱ lay actzu̱ levadura acxni̱ cha̱tum pusca̱t ta̱lakkochipa̱spita̱ lhu̱hua̱ xcaxtala̱squítit tu̱ tipú̱lhca̱lh pa̱tutu; yama̱ levadura lacatzucu̱ tzucuy tlahuay xtascújut hasta acxni̱ nama̱lhu̱hui̱ko̱y xli̱pacs xli̱tlanca̱ yama̱ xatalakmun xcaxtala̱squítit.” ");
INSERT INTO tosNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","A̱li̱sta̱lh acxni̱ Jesús xtiji̱tla̱huama̱ xama̱ c-Jerusalén, la̱ntla̱ c-akatunu ca̱chiquí̱n, chu̱ anta̱ni̱ xuilako̱lh lactzu̱ ca̱tuhuá̱n anta̱ni̱ xlá̱ xlactla̱huama̱, xlá̱ xli̱xakatli̱ko̱y xtapaksi̱t Dios hua̱nti̱ antá̱ xuilakó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Maktum cha̱tum chixcú̱ chuná̱ kalhásquilh: —Tla̱ti, ¿pi̱ ni̱ luhua lhu̱hua̱ hua̱nti̱ catilakma̱xtuko̱lh xli̱stacnacán c-xlacati̱n Dios? Jesús chuná̱ huaniko̱lh li̱lhu̱hua̱ ti̱ xli̱tamakstokko̱ni̱t: ");
INSERT INTO tosNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Luhua lacatancs cca̱huaniyá̱n, pi̱ hua̱nti̱ lakma̱xtuputún xli̱stacna, luhua juerza catlahuánilh, catzáksalh antá̱ nalactanu̱y c-xati̱tzu̱ ma̱laccha, sa̱mpi̱ xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lhu̱hua̱ hua̱nti̱ natanu̱putunko̱y, hua̱mpi̱ ni̱ lay catima̱tla̱ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sa̱mpi̱ acxni̱ xapu̱china xala c-chiqui̱ nama̱lacchuhuay ma̱laccha, nia̱lh lay catitanú̱tit. Cha̱nchu̱ huixín hua̱nti̱ layá̱tit nahuán c-quilhtí̱n nalakatlaká̱tit má̱laccha, chu̱ chuná̱ nahuaná̱tit: ‘Tla̱ti, catlahua̱ li̱tlá̱n caquinca̱ma̱lacqui̱ni.’ Hua̱mpi̱ xlá̱ chuná̱ naca̱kalhti̱yá̱n: ‘Quit ni̱ pala tzinú̱ cca̱lakapasá̱n xatí̱ huixín.’ ");
INSERT INTO tosNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Cha̱nchu̱ huixín chuná̱ natzucuyá̱tit huaniyá̱tit: ‘Quin lacxtum cca̱ta̱hua̱yani̱tán, chu̱ na̱ xackaxmata̱hu mintachihuí̱n acxni̱ huix cxakatli̱pa̱kó̱ tachixcuhuí̱tat c-quinchuchutsipijcán.’ ");
INSERT INTO tosNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hua̱mpi̱ xlá̱ chuná̱ naca̱kalhti̱yá̱n: ‘¡Catatampu̱xtútit u̱nú̱ xli̱pacs huixín hua̱nti̱ li̱scujpá̱tit hua̱ntu̱ ni̱tlá̱n! Aya cca̱huanín pi̱ ni̱ cca̱lakapasá̱n pala quili̱pa̱huaná̱tit.’ ");
INSERT INTO tosNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Anta̱ni̱ huixín naca̱macapincaná̱tit, nala̱li̱lacxcay mintatzancán caj xpa̱lacata tlanca tapa̱tí̱n, chu̱ antá̱ pu̱tum natasayá̱tit acxni̱ a̱li̱mákat naucxilhá̱tit yama̱ xalakmaka̱n minquilhtzucutcan Abraham, Isaac, Jacob, chu̱ xli̱pacs profetas, xlacán antá̱ huilako̱chá nahuán c-xpa̱xtu̱n Dios c-akapú̱n, chi̱nchu̱ huixín ca̱tamacaxtucani̱tántit nahuán c-quilhtí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Cha̱nchu̱ na̱ chuná̱ nali̱puhuaná̱tit acxni̱ huixín naucxilhá̱tit c-akapú̱n ti̱pa̱lhuhua tachixcuhuí̱tat xala cani̱hua̱ xli̱ca̱tlanca ca̱tuxá̱huat cha̱nko̱ni̱t nahuán, laqui̱mpi̱ antá̱ quilhxtum namaktahuilako̱y c-pu̱makca̱tani̱ tu̱ natlahuacán c-akapú̱n anta̱ni̱ ma̱paksi̱nama̱ Dios c-xtapáksi̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Antacú̱ luhua lhu̱hua tachixcuhuí̱tat hua̱nti̱ la̱nchiyú̱ ni̱tú̱ xlakasicán yunú̱ ca̱tiyatna, luhua lactali̱pa̱huá̱ nali̱taxtuko̱ya̱chá̱ c-xlacati̱n Dios, chu̱ na̱ chuna li̱tum, lhu̱hua̱ hua̱nti̱ la̱nchiyú̱ luhua lactali̱pa̱hu u̱nú̱ ca̱tiyatna, hua̱mpi̱ c-xlacati̱n Dios ni̱tú̱ xlakasicán catili̱taxtuko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Huatiya̱ acxni̱ yama̱ quilhtamacu̱ tichinko̱lh makapitzi̱n li̱fariseos, chu̱ chuná̱ huaniko̱lh Jesús: —Huata xatlá̱n nahuán catatampu̱xtu, capit a̱lacatanu ca̱chiquí̱n, sa̱mpi̱ rey Herodes makni̱putuná̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hua̱mpi̱ xlá̱ chuná̱ kalhti̱ko̱lh: —Huata xatlá̱n caqui̱huanipítit tama̱ akskalalh akskahuina chixcú̱ pi̱ la̱nchú̱ quit hua̱ la̱ntla̱ta cmakaacchá̱n makcatzi nactamacaxtuniko̱y cspiritu akskahuiní̱ hua̱nti̱ pa̱laktaju̱ko̱ni̱t, chu̱ na̱ chuná̱ nacma̱pacsako̱y hua̱nti̱ ta̱tatlako̱y, xli̱makua la̱nchiyú̱ tla̱n, sa̱mpi̱ cha̱lí̱ tu̱xama̱ cma̱katsputuni̱t nahuán xli̱pacs quintascújut. ");
INSERT INTO tosNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Hua̱mpi̱ cumu xlacasquinca̱ nacchá̱n anta̱ni̱ cama̱, pus huá̱ xpa̱lacata la̱nchú̱, chu̱ cha̱lí̱, chu̱ hasta ma̱x tu̱xama̱ ctla̱huama̱ nahuán laqui̱mpi̱ nacchá̱n c-Jerusalén, sa̱mpi̱ mat ni̱ lakchá̱n namakni̱cán cha̱tum profeta xta̱chuná̱ la̱ntla̱ quit lapi̱ ni̱ juerza antá. ");
INSERT INTO tosNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús tzúculh li̱puhuán c-xnacú̱, chu̱ chuná̱ chihuí̱nalh: “¡Jerusalén! ¡Koxutá̱ quinca̱chiquí̱n Jerusalén! Antá̱ u̱nú̱ makni̱ko̱cani̱t lhu̱hua luhua lactali̱pa̱hu profetas, chu̱ na̱ actalamakni̱ko̱cani̱t lhu̱hua̱ xakchihui̱naní̱n hua̱nti̱ Dios xmacaminko̱ni̱t. Quit maklhu̱hua̱ ctzaksani̱t cma̱macxtumi̱putunko̱y c-quimpa̱xtú̱n laqui̱mpi̱ tla̱n nacmakta̱yako̱y xli̱pacs hua̱nti̱ u̱nú huilakó̱, xta̱chuná̱ la̱ntla̱ lactzu̱ xalakskata xti̱la̱n pu̱skokako̱y xtzi̱ c-xtampi̱n xpakan, hua̱mpi̱ xlacán niucxni̱ lacasquinko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pus hua̱ chú̱ nia̱lh maka̱s quilhtamacú̱ huata c-tlanca templo antá̱ xalá, ca̱ta caj chunatá̱ natamakaxtaka, chu̱ nia̱lh tí̱ tanu̱maj cati̱hua̱ antá. Huá̱ chuná̱ cca̱li̱huaniyá̱n pi̱ chú̱ la̱ntla̱ naán quilhtamacú̱ nia̱lh caquintiucxílhtit huixín hua̱nti̱ u̱nú̱ huilátit hasta acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ huixín nahuaná̱tit: ‘¡Luhua li̱pa̱xuhu cmakamaklhti̱ma̱hu hua̱nti̱ Quimpu̱chinacan Dios quinca̱ma̱lakacha̱nini̱tán!’” ");
INSERT INTO tosNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cha̱nchu̱ tílalh pi̱ aktum quilhtamacu̱ li̱jáxat, Jesús alh makua̱yán c-xchic cha̱tum xapuxcu fariseo; hua̱mpi̱ makapitzi̱n li̱tum fariseos xmakskalama̱kó̱ pala nama̱pacsanán yama̱ quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pus antá̱ lacatzú̱ xlakahui̱ Jesús cha̱tum chixcú ti̱ xkalhi̱y tzalhua tajátat, chu̱ xli̱cha̱tumi̱nica̱ c-xmacni xcunko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús xcatzi̱y hua̱ntu̱ xlacán xpuhuama̱kó̱, chu̱ chuná̱ kalhasquinko̱lh fariseos, chu̱ laktzokni̱naní̱n hua̱nti̱ antá̱ xlatanu̱ma̱kó̱: —¿Lá̱ huixín huaná̱tit? ¿Pi̱ xlí̱lat cahuá̱ pi̱ tla̱n nama̱pacsacán cha̱tum ta̱tatlá̱ acxni̱ lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ jaxcán, usu ni̱tlá̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hua̱mpi̱ yama̱ fariseos cacs tahuilako̱lh, nia̱lh chihui̱nanko̱lh. Puschí̱ xlá̱ li̱macchípalh xmacán yama̱ ta̱tatlá, acxni̱ tuncán xlá̱ pacsli. A̱li̱sta̱lh huánilh pi̱ caalhá̱ c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Cha̱nchu̱ yama̱ fariseos chuná̱ huanipalako̱lh: —Chú̱ caquihuanítit, pala huixín kalhi̱yá̱tit mia̱xnu̱, usu mihuá̱cax, chu̱ pala nataju̱ya̱chá̱ ca̱pu̱lhmá̱n, ¿a poco ni̱ lacapálaj tuncán catima̱cutútit laqui̱mpi̱ ni̱ najicsuay, chu̱ nani̱y, ma̱squi luhua lakcha̱ni̱t quilhtamacu̱ sábado acxni̱ li̱huancán pala tí̱ nascuja? ");
INSERT INTO tosNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hua̱mpi̱ xlacán ni̱ catzi̱ko̱lh la̱ntla̱ nakalhti̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Acxni̱ Jesús ucxilhko̱lh makapitzí̱n hua̱nti̱ minko̱ni̱t makua̱yanko̱y, la̱ntla̱ xlacán xlacsacma̱kó̱ xalacuan pu̱táhui̱lh anta̱ni̱ xya̱huacani̱t mesa, xlá̱ ma̱xqui̱ko̱lh aktum tastacya̱hu, chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Quit luhua lacatancs cca̱huaniyá̱n, acxni̱ huixín naca̱tasanicaná̱tit laqui̱mpi̱ napiná̱tit c-aktum pu̱makca̱tani anta̱ni̱ tapu̱chuhuama̱ca̱, huix ni̱ calacán camaktahuila̱ anta̱ni̱ huilako̱lh xalacuan pu̱táhui̱lh, sa̱mpi̱ chá̱ pala xamaktum nachín cha̱tum li̱tum hua̱nti̱ tlak li̱lakapascán, usu kalhi̱y xca̱cni̱ ni̱ xahua̱ huix. ");
INSERT INTO tosNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yama̱ chixcú̱ hua̱nti̱ tasanini̱tán nalakpina, aya namina̱chá̱n huaniyá̱n: ‘Catlahua̱ li̱tlá̱n cata̱ya la̱ntla̱ huila, chu̱ cama̱xqui̱ milactáhui̱lh u̱ma̱ cha̱tum li̱tum ti̱ na̱ ctasanini̱t.’ Cha̱nchu̱ huix cha̱ma̱xaná̱ nata̱yaya, juerza napina lactahuilaya̱ hua̱ntu̱ a̱huatiyá̱ huilachá̱ lactáhui̱lh c-xka̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Huata xatlá̱n acxni̱ xtasanica̱ c-pu̱makca̱tani, capit, hua̱mpi̱ antá̱ catahuila̱ hua̱ntu̱ mákat huilako̱chá̱ lactáhui̱lh laqui̱mpi̱ acxni̱ namín hua̱nti̱ huanini̱tán pi̱ nalakpina̱ c-pu̱makca̱tani, chu̱ chuná̱ nahuaniyá̱n: ‘Amigo, catlahua̱ li̱tlá̱n, catalacatzuhui, chu̱ calacán catahuila̱ anta̱ni̱ huí̱ tlak tla̱n lactáhui̱lh.’ Pus huata huix na̱ luhua tali̱pa̱hu nali̱ma̱xtuko̱yá̱n hua̱nti̱ huilakó̱ c-pu̱hua̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Hua̱ chuná̱ cca̱li̱huanimá̱n sa̱mpi̱ hua̱nti̱ caj xacstu putzama̱ la̱ntla̱ nama̱tlanqui̱cán xalán ni̱ maka̱s tama̱ma̱xani̱y, chu̱ ma̱tu̱tzuhui̱cán; huata hua̱nti̱ ni̱tú̱ putzama̱ ma̱squi caj la̱ntla̱ ni̱tu̱ xlakasi li̱taxtuma̱, huata huá̱ chú̱ luhua tali̱pa̱hu li̱taxtuy a̱li̱sta̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Chu̱ yama̱ xapuxcu fariseo hua̱nti̱ xtasanini̱t nalakán c-xchic, chuná̱ má̱xqui̱lh tastacya̱hu: —Acxni̱ tlahuaya̱ taca̱tani, usu tahua̱y, ni̱ hua̱ cahuanikó̱ calakminkó̱n caj xma̱n mintalakapasni, usu pala minata̱lán, usu mili̱nata̱lán, usu pala miamigos hua̱nti̱ lacatzú̱ li̱ta̱huilakó̱, chu̱ hua̱nti̱ na̱ ma̱tamacu̱naní̱n xta̱chuná̱ la̱ huix, sa̱mpi̱ acxni̱ xlacán natlahuako̱y aktum taca̱tani̱ pus na̱ nahuaniko̱yá̱n pi̱ calakpinkó, chu̱ chuná̱ chú̱ huix namakapu̱xokocana. ");
INSERT INTO tosNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Hua̱mpi̱ acxni̱ huix natlahuaya̱ taca̱tani, xatlá̱n huá̱ cahuanikó̱ hua̱nti̱ li̱ma̱xkaní̱n, hua̱nti̱ ni̱ lay scujko̱y, hua̱nti̱ luntuní̱n, xa̱hua̱ xli̱pacs hua̱nti̱ lakatzí̱n lama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chuna chí̱ Dios aktziyaj nama̱latama̱ni̱yá̱n; sa̱mpi̱ ni̱ lama̱ xlacán catixoko̱nanikó̱n, hua̱mpi̱ Dios ucxilhmá̱n, chu̱ huá̱ nama̱xqui̱yá̱n mintaskahu acxni̱ nalakchá̱n yama̱ quilhtamacú̱ la̱ntla̱ xlá̱ nama̱lakastakuani̱ko̱y ca̱li̱ní̱n xli̱pacs xcamán hua̱nti̱ tla̱n xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cha̱tum chixcú̱ hua̱nti̱ antá̱ macxtum xta̱huilakó̱ c-pu̱hua̱y, acxni̱ chuná̱ kaxmatko̱lh yuma̱ tachihuí̱n, chuná̱ huánilh Jesús: —Hua̱mpi̱ luhua ca̱na̱ aktziyaj lama̱ hua̱nti̱ tla̱n nata̱ca̱taniko̱y ti̱ nacha̱nko̱y c-xtapaksi̱t Dios anta̱ni̱ ma̱paksi̱nama̱chá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Hua̱mpi̱ Jesús chuná̱ kálhti̱lh, usu huánilh aktum caj takalhchihuí̱n: —Maktum xuí̱ cha̱tum chixcú, tláhualh tlanca taca̱tani, na̱ luhua lhu̱hua̱ ti̱ tima̱ca̱tzi̱ni̱ko̱lh pi̱ caminko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Acxni̱ aya accha̱ná̱ xuí̱ xtahua̱y, ma̱lakacha̱naniko̱lh xlacscujni, pi̱ naancán huaniko̱cán hua̱nti̱ ma̱catzi̱ni̱ko̱cani̱t pi̱ lacapala̱ caminko̱lhá̱ sa̱mpi̱ pacsá xalanitá̱ xuí̱ tahua̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Hua̱mpi̱ hua̱nti̱ qui̱laklako̱ca̱ tzucuko̱lh talhta̱ni̱ko̱y, pacs tzucuko̱lh squinko̱y xma̱tzanka̱nanicacán. Cha̱tum hua̱nti̱ xakasiya̱ lakcha̱nca̱ chuná̱ huá̱: ‘Luhua xli̱ca̱na̱ cahuanipi̱ pi̱ catláhualh li̱tlá̱n caquima̱tzanka̱nánilh, hua̱mpi̱ a̱cu ctamá̱hualh aktum pú̱cuxtu, pus la̱nchú̱ xlacasquinca̱ nacán ucxilha.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Cha̱tum li̱tum chuná̱ huampá̱: ‘Puntzujcú̱ ctama̱huako̱lh pu̱quitzis quintoro̱, la̱nchú̱ nacán li̱tzaksako̱y nacucxilha̱ pala tla̱n lakuaxnanko̱y, luhua hasta csquiniyá̱n pi̱ caquima̱tzanka̱nani sa̱mpi̱ ni̱ lay cana̱chá.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Cha̱nchu̱ a̱cha̱tum chuná̱ huampá̱: ‘Luhua ctapu̱chuhualhcú̱, chu̱ xli̱ca̱na̱ ni̱ lay chú̱ clakana̱chá̱n, pus caquima̱tzanka̱nani.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Acxni̱ táspitli̱ lacscujni, pacs huánilh xma̱la̱ná̱ la̱ntla̱ huanicanchá. Yama̱ xma̱la̱ná̱ tla̱n sí̱tzi̱lh, chu̱ chuná̱ huánilh xlacscujni: ‘Lacapala̱ capimpi̱ c-xli̱ca̱tlanca ca̱chiquí̱n, chu̱ ca̱tlanca̱tijni, chu̱ ma̱squi ca̱lhka̱na̱tijni, na̱ cali̱tankó̱ li̱ma̱xkaní̱n, chu̱ ti̱ ni̱ lay scujko̱y, chu̱ lu̱ntu̱ní̱n, chu̱ lakatzi̱ní̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Caj li̱puntzú̱ acxni̱ yama̱ xlacscujni qui̱táspitli, chuná̱ huánilh xma̱la̱ná: ‘Tla̱ti, chuná̱ chú̱ ctláhualh la̱ntla̱ huix quihuani, hua̱mpi̱ luhua lhu̱huacú̱ tzanka̱y hua̱nti̱ tla̱n xua̱yanko̱lh.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yama̱ xma̱la̱ná̱ chuná̱ huanipá̱ xlacscujni: ‘Pus capimpalapi̱ ca̱tijí̱n, chu̱ c-xquilhapa̱n ca̱chiquí̱n, ma̱squi anta̱ni̱ caj actzu̱ tiji, chu̱ juerza caca̱huanítit a̱makapitzi̱n cati̱huá̱ ti̱ nata̱ksko̱ya̱ pi̱ caminko̱lh laqui̱mpi̱ chuná̱ pacs nali̱tahuilako̱cán xli̱ca̱tlanca c-quínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sa̱mpi̱ xli̱ca̱na̱ cca̱huaniyá̱n pi̱ nia̱lh clacasquín ni̱ pala cha̱tum hua̱nti̱ quit xapu̱lana̱ ctima̱catzi̱ni̱ko̱lh pi̱ caquilakminko̱lh, chu̱ nia̱lh catihuako̱lh yuma̱ quintahua̱y hua̱ntu̱ quit la̱nchiyú̱ cca̱xtlahuani̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Maktum acxni̱ luhua lhu̱hua̱ csta̱lanima̱kó̱ Jesús c-tiji, Jesús huata maktum xlá̱ lacatancs huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Lapi̱ huí̱ ti̱ luhua quista̱laniputún, chu̱ quilacscujni nahuán, luhua xli̱cátzi̱t pi̱ lapi̱ ni̱ aktum catzi̱y pi̱ tlak naquilakcatzán ni̱ xahua̱ xtla̱t, chu̱ xtzi, usu xpusca̱t, usu xcamán, usu xnata̱lán, usu hasta catu̱huá̱ tu̱ tla̱n xkálhi̱lh c-xlatáma̱t, ni̱ lay catili̱tánu̱lh la̱ quili̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chu̱ hua̱nti̱ ni̱ aktum catzi̱y cha̱li̱ cha̱lí̱ nalé̱n xcruz, chu̱ naquista̱laniy, xlá̱ ni̱ lay li̱tapu̱lhca̱y la̱ quili̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Huata pu̱lana̱ tla̱n calacapá̱stacli̱ hua̱nti̱ quista̱laniputún, na̱ luhua xta̱chuná̱ qui̱taxtuy acxni̱ cha̱tum chixcú̱ tlahuaputún aktum tlanca xchic, huata pu̱lana̱ natahuilay laqui̱mpi̱ natlahuay xcuenta̱ pala namakaacchá̱n xtumi̱n hua̱ntu̱ nali̱ma̱akasputuy. ");
INSERT INTO tosNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Huá̱ chuná̱ li̱tlahuay laqui̱mpi̱ ni̱ a̱li̱sta̱lh acxni̱ aya ma̱pulhuni̱ttá nahuán xpá̱tzaps nia̱lh lay catima̱akaspútulh, chu̱ xli̱pacs hua̱nti̱ naucxilhko̱y caj nali̱kalhkama̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Chuná̱ nahuanko̱y: ‘Tama̱ chixcú, luhua tla̱n tima̱tzúqui̱lh xpá̱tzaps, hua̱mpi̱ chú̱ nia̱lh lay ma̱akasputuy xchic.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chu̱ na̱ chuna li̱tum pala cha̱tum gobierno nata̱tlahuacán guerra, chu̱ mima̱ cha̱tum gobierno a̱lacatanuj xalá, ¿tú̱ pu̱lana̱ tla̱n nalacapa̱staca̱ lapi̱ tla̱n nali̱makatlajay caj akca̱hu mi̱lh tropa̱ hua̱ntu̱ xlá̱ kalhi̱y, sa̱mpi̱ hua̱nti̱ mima̱ xlá̱ li̱mín akpuxam mi̱lh? ");
INSERT INTO tosNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chu̱ lapi̱ xlá̱ lacatancs nacatzi̱y pi̱ ni̱ lay catimakatlájalh, pus acxni̱ makatcú̱ mima̱chá nahuán hua̱nti̱ mímaj lacata̱qui̱y tasi̱tzi, huata a̱ma̱ gobierno namaca̱nko̱y xlacscujni̱ laqui̱mpi̱ naancán huanicán hua̱nti̱ mima̱: ‘Huata xatlá̱n caláclalh tasi̱tzi, acxtum calacca̱xlahu, chu̱ ni̱ cala̱si̱tzi̱nihu.’ ");
INSERT INTO tosNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Puschí̱ na̱ chuná̱ chú̱ huixín hua̱nti̱ xli̱ca̱na̱ quista̱laniputún, pu̱lana̱ lacatancs cacatzí̱tit pi̱ hua̱nti̱ ni̱ namakaxtaka̱ hua̱ntu̱ kalhi̱y u̱nú̱ nac ca̱tiyatna, pus ni̱ lay li̱tapa̱cuhui̱y luhua xli̱ca̱na̱ quili̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Huixín catzi̱yá̱tit pi̱ mátzat, luhua tla̱n sa̱mpi̱ li̱ma̱sko̱ka̱nancán, hua̱mpi̱ hua̱ lapi̱ tama̱ mátzat cspútnilh xli̱skoko, nia̱lh tú̱ catili̱laca̱, ¿lá̱ntla̱ cahuá̱ chú̱ natili̱ma̱skoka̱nancán? ");
INSERT INTO tosNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pus nia̱lh tí̱ tu̱ li̱lay, ni pala ma̱squi luhua tíyat nia̱lh xuay, usu abono. Pus pi̱ nia̱lh tú̱ li̱lacán, luhua lacatancs pi̱ caj namakancán. ¡Huixín hua̱nti̱ li̱kaxpatpá̱tit mintake̱ncán, luhua caakatá̱kstit quintachihuí̱n!” ");
INSERT INTO tosNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Anta̱ni̱ xakchihui̱nán Jesús, lhu̱hua̱ hua̱nti̱ xminko̱y kaxmatniko̱y xtachihuí̱n, xma̱ta̱ji̱nani̱n impuestos, xa̱hua̱ makapitzi̱n chixcuhuí̱n hua̱nti̱ judíos xpuhuanko̱y pi̱ luhua a̱tzinú̱ makla̱kalhi̱naní̱n xuanko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Caj luhua huá̱ xpa̱lacata̱, yama̱ fariseos, chu̱ laktzokni̱naní̱n xli̱aksanko̱y, chu̱ chuná̱ xuanko̱y: —Uma̱ chixcú̱ pacs ta̱talakxtumi̱ko̱y ma̱squi hua̱nti̱ makla̱kalhi̱naní̱n, xa̱huachí̱ acxtum ta̱hua̱yanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesús xcatzi̱y tu̱ xli̱aksama̱kó̱, chu̱ laqui̱mpi̱ naakata̱ksko̱y xatú̱ xpa̱lacata̱ xlá̱ tla̱n xta̱lako̱y yama̱ chixcuhuí̱n, Jesús li̱xakatli̱ko̱lh u̱ma̱ aktum takalhchihuí̱n: ");
INSERT INTO tosNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Lapi̱ cha̱tum chixcú̱ kalhi̱y aktum ciento xborrego, na̱ pala xamaktum namakatzanka̱y tantum, ¿xatú cahuá̱ natlahuay? ¿Tú̱ catimakaxtakko̱lh lacatum a̱makapitzi̱n ta̱tipuxamacu̱naja̱tza̱ laqui̱mpi̱ tuncán lacapala̱ naán putzay yama̱ koxuta borrego hua̱nti̱ makatzanka̱ni̱t, chu̱ ni̱ catitáspitli̱ c-xchic hasta ni̱li̱huaya̱ nata̱ksa? ");
INSERT INTO tosNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Acxni̱ chú̱ naqui̱ta̱ksa, antá̱ c-xaklhtampixni nahuili̱y, chu̱ cha̱pa̱xuhua̱na̱ nalé̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Cha̱nchu̱ acxni̱ nachá̱n c-xchic pu̱tum nama̱stokko̱y xamigos, chu̱ hua̱nti̱ lacatzú̱ li̱ta̱huilakó̱, chu̱ chuná̱ nahuaniko̱y: ‘Catlahuátit li̱tlá̱n, caquinta̱pa̱xuhuátit la̱nchú̱ pi̱ cta̱ksni̱t quinborrego hua̱nti̱ xtzanka̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pus xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ na̱ chuná̱ qui̱taxtuy c-akapú̱n acxni̱ lama̱kó̱ ca̱tuxá̱huat aktum ciento xlakskata̱n Dios, chu̱ pala cha̱tum nachipay hua̱ntu̱ ni̱ xatla̱n tiji anta̱ni̱ nalaktzanka̱y, acxni̱ talakaspitta̱yaniy xtala̱kalhí̱n, chu̱ li̱pa̱huampalay Dios, antá̱ c-akapú̱n luhua lhu̱hua̱ anán tapa̱xuhuá̱n caj xpa̱lacata yuma̱ cha̱tum hua̱nti̱ qui̱táspitli̱ anta̱ni̱ ni̱tlá̱n, ni̱ xahua̱ caj xpa̱lacatacán yama̱ hua̱nti̱ xata̱tipuxamacu̱naja̱tza̱ hua̱nti̱ tla̱ná̱ xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Pus na̱ chuna li̱tum acxni̱ cha̱tum pusca̱t kalhi̱y xtapixnu tu̱ li̱tatlahuani̱t okxca̱hu tumi̱n xla plata tu̱ luhua lakcatzán, chu̱ pala namakatzanka̱y okxtum, ¿lá̱ huixín puhuaná̱tit, tú̱ catima̱pási̱lh cahuá̱ xpu̱maksko, chu̱ luhua li̱huana̱ napalhnán, chu̱ naputzay c-xli̱ca̱tlanca chiqui̱ hasta ni̱li̱huaya̱ naqui̱ta̱ksa? ");
INSERT INTO tosNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Acxni̱ chú̱ nata̱ksa, pu̱tum nama̱makstoka̱ xamigos hua̱nti̱ lacatzú̱ li̱ta̱huilakó̱, chu̱ chuná̱ nahuaniko̱y: ‘Luhua catlahuátit li̱tlá̱n, caquinta̱pa̱xuhuátit sa̱mpi̱ aya cta̱ksni̱t yama̱ paktum quintumi̱n hua̱ntu̱ xacmakatzanka̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pus quit cca̱huaniyá̱n, pi̱ xta̱chuná̱ anán tapa̱xuhuá̱n c-xlacati̱n xangeles Dios xpa̱lacata̱ cha̱tum makla̱kalhi̱ná̱ hua̱nti̱ talakaspitta̱yaniy xtala̱kalhí̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús na̱ li̱xakatli̱palako̱lh yuma̱ aktum takalhchihuí̱n, tihua̱: “Cha̱tum chixcú, xkalhi̱ko̱y cha̱tuy xlakkahuasán. ");
INSERT INTO tosNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Maktum xatajú̱ chuná̱ huánilh xtla̱t: ‘Tla̱ti, huata cumu la̱nchú̱ tla̱ncú̱ lápa̱t, xatlá̱n caquima̱xquitá̱ mimakaaná̱nat hua̱ntu̱ quit quilakchá̱n naquima̱xqui̱ya.’ Yama̱ ko̱lutzí̱n ma̱tlá̱ni̱lh hua̱ntu̱ huánilh, chu̱ ma̱pa̱pitziniko̱lh xlakkahuasán xmakaaná̱nat. ");
INSERT INTO tosNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ni̱ li̱maka̱s quilhtamacu̱ yama̱ xataju xkahuasa̱ sta̱makanko̱lh hua̱ntu̱ xma̱xqui̱cani̱t xmakaaná̱nat, chu̱ yama̱ tumi̱n hua̱ntu̱ xlá̱ makamaklhtí̱nalh, acxni̱ stá̱nalh, alh li̱lacahuantapu̱li̱y mákat a̱lacatanu̱ ca̱chiquí̱n. Antá̱ lactlahuami̱ko̱lh, sa̱mpi̱ luhua caj xali̱xcajnit tapuhuá̱n chípalh. ");
INSERT INTO tosNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Acxni̱ aya xlactlahuami̱ko̱ni̱t xtumi̱n, huatiya yama̱ ca̱chiquí̱n anta̱ni̱ xlá̱ xcha̱ni̱t, milh aktum tlihuaka tatzíncstat, chu̱ sputko̱lh hua̱ntu̱ xuacán, chu̱ yama̱ kahuasa na̱ tzúculh pa̱ti̱nán sa̱mpi̱ nia̱lh tú̱ xkalhi̱y hua̱ntu̱ nali̱hua̱yán. ");
INSERT INTO tosNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huata xlá̱ alh putzay tascújut, chu̱ lákcha̱lh cha̱tum chixcú̱ antá̱ xala yama̱ ca̱chiquí̱n, cha̱nchu̱ xlá̱ antá̱ ma̱lakácha̱lh c-xpú̱cuxtu laqui̱mpi̱ namaktakalhniy xpaxni. ");
INSERT INTO tosNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Xlá̱ aya xtzincsni̱y, xpuhuán caj u̱cú xli̱kálhkasli̱ talhtzi hua̱ntu̱ xuako̱y paxni̱ hua̱ntu̱ xma̱xqui̱cán, hua̱mpi̱ xlá̱ ni̱ pala huá̱ xma̱xqui̱cán talacasquín nahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pus yama̱ kahuasa̱ tiakáchilh hua̱ntu̱ xatlá̱n, chu̱ chuná̱ tzúculh lacapa̱staca: ‘Nac xchic quintla̱t lhu̱hua̱ scujní̱n, xlacán pacs kalhi̱ko̱y hua̱ntu̱ nahuako̱y, chu̱ hasta akata̱xtunima̱kó̱, ¡chi̱nchu̱ quit u̱nú, aya cni̱y, ctzincstamakama̱ hasta ni̱tú̱ cuay! ");
INSERT INTO tosNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Huata xatlá̱n nactaca̱xta̱qui̱y, nacampalay c-xchic quintla̱t, chu̱ acxni̱ nacchá̱n, chuná̱ nacuaniy: Tla̱ti, luhua lhu̱hua quintala̱kalhí̱n hua̱ntu̱ cli̱makali̱puhuani̱t Dios, chu̱ na̱ chuná̱ huix na̱ cmakali̱puhuani̱tán. ");
INSERT INTO tosNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Caj huá̱ xpalacata quit nia̱lh quimini̱niy naquili̱pu̱lhca̱ya̱ la̱ minkahuasa, huata xatlá̱n la̱nchú̱ caquima̱scuju, chu̱ caquili̱pu̱lhca̱ la̱ cha̱tum mintasa̱cua.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xli̱ca̱na̱ yama̱ kahuasa taca̱xtá̱qui̱lh, chu̱ ampá̱ c-xchic xtlá̱t. “Acxni̱ yama̱ kahuasa̱ makatcú̱ xminachá, yama̱ ko̱lutzí̱n úcxilhli pi̱ mima̱ xkahuasa. Xli̱ca̱na̱ luhua kayaj catzánilh, chu̱ takosú̱n alh pa̱xtoka; acxni̱ lákcha̱lh aklhcha̱chípalh, chu̱ lacátzu̱cli. ");
INSERT INTO tosNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Cha̱nchu̱ xkahuasa huánilh: ‘Tla̱ti, luhua lhu̱hua̱ quintala̱kalhí̱n hua̱ntu̱ cli̱makali̱puhuani̱t Dios, chu̱ na̱ chuná̱ huix na̱ cmakali̱puhuani̱tán; pus quit nia̱lh quimini̱niy naquili̱pu̱lhca̱ya la̱ minkahuasa.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Hua̱mpi̱ yama̱ ko̱lutzí̱n chuná̱ huaniko̱lh cscujní̱n: ‘Lacapala̱ cama̱cutútit a̱tzinu̱ xatla̱n lháka̱t, chu̱ cama̱lhaká̱tit quinkahuasa. Na̱ cama̱makanú̱tit aktum xa̱ni̱yu̱ c-xmacán, chu̱ na̱ cama̱tuhuanú̱tit czapato. ");
INSERT INTO tosNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xa̱huachí̱ lacapala̱ cali̱tántit xakon quintoro̱, camakní̱tit, sa̱mpi̱ la̱nchú̱ nahua̱yana̱hu, chu̱ natlahuaya̱hu tapa̱xuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sa̱mpi̱ hua̱ yuma̱ quinkahuasa, quit xacli̱pu̱lhca̱y la̱mpala xni̱ni̱t, chu̱ aya lakastakuanani̱t, chu̱ mimpalani̱t ca̱tuxá̱huat; sa̱mpi̱ xacmakatzanka̱ni̱t, chu̱ la̱nchú̱ aya cta̱ksni̱t.’ Chu̱ ni̱ pala maka̱s tzucuca̱ pa̱xuhuacán c-xchic yama̱ ko̱lutzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Hua̱ chú̱ hua̱ xapuxcu xkahuasa, xlá̱ scujma̱chá̱ c-pú̱cuxtu. Acxni̱ aya xtaspitma̱, chu̱ xcha̱ma̱ c-xchic, káxmatli̱ pi̱ luhua li̱pa̱xuhu xtlaknama̱ca̱, chu̱ xtantli̱ma̱ko̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tasánilh cha̱tum tasa̱cua, chu̱ kalhásquilh: ‘¿Tú̱ xpa̱lacata li̱tlahuama̱ca̱ tapa̱xuhuá̱n c-quínchic?’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Cha̱nchu̱ xlá̱ huánilh: ‘Huá̱ li̱pa̱scuajnama̱ca̱ sa̱mpi̱ luhua chunatiyá̱ tla̱n qui̱táspitli̱ minta̱lá̱ hua̱nti̱ xaktzanka̱ta̱yani̱t, ni̱tú̱ lanini̱t, chu̱ caj huá̱ xpa̱lacata̱ li̱ma̱paksí̱nalh mintla̱t laqui̱mpi̱ namakni̱cán xakon xtoro.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Hua̱mpi̱ yama̱ xapuxcu kahuasa luhua li̱pe̱cua̱ sí̱tzi̱lh, chu̱ pi̱ ni̱ xtanu̱putún c-xchic, juerza taxtuchi̱ xtla̱t, chu̱ maklhu̱hua̱ huánilh pi̱ catánu̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Huata yama̱ kahuasa̱ chuná̱ huánilh xtla̱t: ‘Huix stalanca catzi̱ya̱ la̱ntla̱ lhu̱hua ca̱ta̱ xankalhí̱n cta̱scujmá̱n, chu̱ ni̱ pala maktum caj chunatá̱ xackalhakaxmatmakán, hua̱mpi̱ huix ni̱ pala maktum xquima̱xqui̱ ca̱na̱ caj tantum xaskata minborrego laqui̱mpi̱ nacmakni̱y, chu̱ nacta̱li̱ca̱taniko̱y quiamigos. ");
INSERT INTO tosNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Hua̱mpi̱ acxni̱ lakchini̱tán hua̱ yuma̱ quintajú̱ hua̱nti̱ ta̱ma̱laksputuko̱ni̱t xaaktzanka̱ta̱yani̱n lacchaján mimakaaná̱nat, ma̱makni̱ni̱nani̱ xakon toro̱, chu̱ tlahuápa̱t tapa̱xuhuá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Hua̱mpi̱ yama̱ ko̱lutzí̱n chuná̱ huánilh xkahuasa: ‘Tla̱ti, huix ankalhi̱ná̱ u̱nú̱ lacxtum quinta̱huila, chu̱ xli̱pacs hua̱ntu̱ ckalhi̱y na̱ pacs milá. ");
INSERT INTO tosNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Hua̱mpi̱ la̱nchú̱ luhua xli̱ca̱na̱ xlacasquinca̱ pi̱ juerza napa̱xuhuaya̱hu, chu̱ naca̱taniya̱hu sa̱mpi̱ tama̱ mintajú̱ qui̱taxtuy xta̱chuná̱ la̱mpala xni̱ni̱t, na̱ lakastakuanampalani̱t; la̱mpala xmakatzanka̱ni̱tahu, hua̱mpi̱ la̱nchú̱ aya ta̱ksni̱tahu.’” ");
INSERT INTO tosNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Maktum Jesús li̱xakatli̱ko̱lh xli̱ma̱kalhtahuáka̱t yuma̱ takalhchihuí̱n: “Xuí̱ cha̱tum chixcú, luhua ma̱tamacu̱nú xuani̱t. Hua̱ yuma̱ chixcú̱ xkalhi̱y cha̱tum xapuxcu xtasa̱cua̱ hua̱nti̱ luhua xli̱pa̱huán, chu̱ pacs huá̱ xma̱maktakalhni̱y xli̱pacs hua̱ntu̱ xlá̱ xkalhi̱y. Hua̱mpi̱ maktum áncaj huanicán pi̱ yama̱ xapuxcu xtasa̱cua lhu̱hua̱ antá̱ xakskahuixtunima̱ xtumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pus yama̱ chixcú̱ tasánilh xtasa̱cua, chu̱ chuná̱ huánilh: ‘¿Pa̱ xli̱ca̱na̱ hua̱ntu̱ quihuanima̱ca̱ pi̱ mat huix akskahuixtúpa̱t quintumi̱n? Pus la̱nchú̱ caquima̱xqui̱kó̱ cuenta̱ hua̱ntu̱ xlakáya̱t tascújut mili̱puxcu, chu̱ hua̱nti̱ quilakahuilaniko̱lh, sa̱mpi̱ chú̱ nia̱lh cactima̱xquí̱n tascújut xpa̱lacata huix nacui̱ntajlaya̱ pu̱tum la̱ntla̱ xapuxcu tasa̱cua.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pus hua̱ chú̱ yuma̱ xapuxcu tasa̱cua, chuná̱ tzúculh puhuán: ‘¿Tú̱ cahuá̱ chú̱ nactlahuay pi̱ huá̱ quima̱la̱ná̱ naquimaklhti̱y quintascújut? Sa̱mpi̱ quit nia̱lh ckalhi̱y li̱tlihuaka pi̱ nacmakcuxtuy, chu̱ na̱ chuná̱ cma̱xanán pala caj nacsquihua̱yanta̱kchokoy. ");
INSERT INTO tosNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Hua̱mpi̱ aya ccátzi̱lh hua̱ntu̱ nactlahuay! Nacta̱lacca̱xlay hua̱nti̱ lakahuilaniko̱lh quima̱la̱ná̱ laqui̱mpi̱ xlacán naquimakta̱yako̱y acxni̱ quit naquimaklhti̱cán yama̱ quintascújut.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pus chuná̱ xlá̱ tláhualh, chu̱ cha̱tunu cha̱tunu̱ tzúculh tasaniko̱y hua̱nti̱ xlakahuilaniko̱lh xma̱la̱ná. Hua̱nti̱ pu̱lana̱ milh kalhásquilh: ‘¿Ní̱ntla̱ li̱piniya̱ quima̱la̱ná?’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Xlá̱ kalhtí̱nalh: ‘Pus quit clakahuilánilh aktum ciento barril aceite.’ Yama̱ xapuxcu tasa̱cua̱ chuná̱ huánilh: ‘Xli̱ca̱na̱ huana, sa̱mpi̱ chuná̱ talhca̱ni̱t c-mirecibo hua̱ntu̱ firmartlahuani̱ta; huata xatlá̱n calácxti̱tti̱ hua̱ntu̱ aya firmartlahuani̱ta, chu̱ tanu̱ catlahua̱ anta̱ni̱ nahuán pi̱ caj íta̱t ciento barril lakahuilani.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A̱li̱sta̱lh kalhasquimpá̱ a̱cha̱tum: ‘¿Chá̱ huix, ní̱ntla̱ li̱piniya̱ quima̱la̱ná?’ Yama̱ chixcú̱ kalhtí̱nalh: ‘Aktum ciento cúxta̱lh trigo.’ Yama̱ xapuxcu tasa̱cua̱ huánilh: ‘Xli̱ca̱na̱, sa̱mpi̱ huilachá̱ mirecibo, lacapala̱ calácxti̱tti, chu̱ tanu̱ catlahua̱ laqui̱mpi̱ antá̱ nahuán pi̱ caj ta̱tipuxam cúxta̱lh li̱piniya.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Acxni̱ cátzi̱lh xma̱la̱ná hua̱ntu̱ xtlahuama̱, xli̱ca̱na̱ hasta luhua cacs li̱lacahua̱ caj la̱ntla̱ luhua akskálalh tu̱ xtlahuani̱t acxni̱ pútzalh la̱ntla̱ tla̱n nalatama̱y a̱li̱sta̱lh yama̱ akskahuina tasa̱cua. Pus xli̱ca̱na̱ lhu̱hua̱ hua̱nti̱ xala ca̱tuxá̱huat, luhua lakskalalán huanko̱y acxni̱ la̱ntla̱ putzako̱y pala tú̱ ni̱tlá̱n natlahuako̱y hasta luhua makatlajako̱cán hua̱nti̱ luhua aksti̱tum scujma̱kó̱ cxkakanat Dios.” ");
INSERT INTO tosNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pus Jesús chuná̱ na̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: “Cca̱huaniyá̱n pi̱ tla̱n naputzayá̱tit la̱ntla̱ nakalhi̱yá̱tit miamigoscán ti̱ naca̱makta̱yayá̱n hua̱mpi̱ ni̱ chuná̱ hua̱ntu̱ ni̱ aksti̱tum, sa̱mpi̱ lapi̱ hua̱ mintamacú̱n tu̱ kalhi̱yá̱tit yunú̱ ca̱tuxá̱huat, anta̱ni̱ lhu̱hua̱ anán tala̱kalhi̱n, nali̱makta̱yako̱yá̱tit a̱makapitzí̱n, xli̱ca̱na̱ lhu̱hua miamigoscán nakalhi̱yá̱tit ti̱ naca̱maklhti̱naná̱n c-xasa̱sti mimpu̱tahui̱lhcán tu̱ nakalhi̱yá̱tit c-akapú̱n anta̱ni̱ xli̱pa̱án natahuilayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Sa̱mpi̱ hua̱nti̱ ma̱cui̱ntajli̱cán hua̱ntu̱ ni̱ luhua lhu̱hua tamacú̱n usu tascújut, chu̱ pala xlá̱ luhua aksti̱tum cui̱ntaj natlahuay, chuná̱ li̱ma̱siyuy pi̱ tali̱pa̱hu laqui̱mpi̱ acxni̱ nama̱maktakalhni̱cán hua̱ntu̱ luhua lhu̱hua tumi̱n, pus na̱ huá̱ luhua aksti̱tum cui̱ntaj natlahuay; hua̱mpi̱ hua̱nti̱ luhua ni̱ cui̱ntaj tlahuay hua̱ntu̱ ma̱squi ni̱ lhu̱hua tumi̱n hua̱ntu̱ ma̱maktakalhni̱cán, pus na̱ chuná̱ ni̱ li̱huana̱ catimaktákalhli̱ acxni̱ pala nama̱xqui̱cán lhu̱hua xli̱maktakálhat. ");
INSERT INTO tosNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pus pala huixín ni̱ tla̱n maktakalhá̱tit hua̱ntu̱ nama̱cui̱ntajli̱caná̱tit tamacú̱n xala u̱nú̱ ca̱tuxá̱huat ma̱squi hua̱ntu̱ ni̱ luhua lhu̱hua, ¿pa̱ li̱huacá̱ chú̱ tla̱n namaktakalhá̱tit hua̱ntu̱ Dios naca̱ma̱xqui̱yá̱n xtalacapa̱stacni? ");
INSERT INTO tosNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na̱ chuna li̱tum, pala huixín ni̱tlá̱n namaktakalhá̱tit hua̱ntu̱ Dios ca̱ma̱cui̱ntajli̱ni̱tán, chu̱ ni̱ milacán, ¿pi̱ li̱huacá̱ chú̱ naca̱ma̱xqui̱yá̱n hua̱ntu̱ xlá̱ aya laclhca̱huili̱ni̱t pi̱ naca̱ma̱xqui̱yá̱n cha̱tunu̱ huixín? ");
INSERT INTO tosNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Huixín catzi̱yá̱tit pi̱ ni̱ pala cha̱tum scujni̱ ma̱tla̱ni̱y nata̱scujko̱y cha̱tuy xma̱la̱ná aktuma quilhtamacú̱, sa̱mpi̱ acxni̱ nakalhakaxmata̱ cha̱tum, huá̱ chú̱ acha̱tum li̱tum juerza nalakmakán; usuchí̱ acxni̱ natlahuaputún hua̱ntu̱ nali̱ma̱paksi̱y cha̱tum, juerza nakalhakaxmatmakán acha̱tum. Pus quit clacasquín luhua li̱huana̱ caakatá̱kstit hua̱ntu̱ cuaniputún: Cha̱tum chixcú̱ ni̱ lay li̱pa̱huán Dios xli̱pacs xnacú̱, chu̱ na̱ huatiya̱ yama̱ quilhtamacú̱ luhua nali̱pa̱huán xtumi̱n pi̱ huá̱ tla̱n catu̱huá̱ nali̱ma̱tla̱ni̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Makapitzi̱n fariseos hua̱nti̱ na̱ antá̱ xlaya̱kó̱, pacs xkaxmatma̱kó̱ hua̱ntu̱ xlá̱ xquilhuama̱, huata tzúculh li̱kalhakama̱nanko̱y Jesús sa̱mpi̱ xlacán luhua xlakati̱ko̱y nakalhi̱ko̱y lhu̱hua tumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Huata Jesús chuná̱ huaniko̱lh: “Huixín hua̱nti̱ c-xlacati̱ncan chixcuhuí̱n li̱tasiyuputuná̱tit xta̱chuná̱ la̱ntla̱ hua̱nti̱ luhua lactla̱n chixcuhuí̱n, hua̱mpi̱ Dios pacs lakapasa̱ hua̱ntu̱ xali̱xcájnit huí̱ c-minacu̱cán. Sa̱mpi̱ na̱ luhua mili̱catzi̱tcán pi̱ hua̱ntu̱ huixín puhuaná̱tit pi̱ luhua lhu̱hua xtápalh c-xlaksti̱pa̱ncan tachixcuhuí̱tat, xli̱ca̱na̱ cca̱huaniyá̱n pi̱ Dios ni̱ ucxilhputún, huata xlá̱ lakmakán. ");
INSERT INTO tosNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Acxni̱ Juan Bautista ni̱ xa̱ma̱tzuqui̱y xtascújut caj xma̱n hua̱ tla̱n xkalhi̱yá̱tit xli̱ma̱paksi̱n Moises nali̱kalhtahuakayá̱tit, chu̱ nama̱kantaxti̱yá̱tit, chu̱ hua̱ntu̱ xtzokko̱ni̱t c-xlibrojcan xalakmaka̱n profetas; hua̱mpi̱ acxni̱ Juan tzúculh li̱chihui̱nán yama̱ xasa̱sti xtama̱catzi̱ni̱n Dios la̱ntla̱ xlá̱ nama̱tzuqui̱y xasa̱sti xtapaksi̱t ca̱tuxá̱huat, chu̱ acxnitiyá̱ yama̱ quilhtamacú̱ lhu̱hua̱ tachixcuhuí̱tat juerza tzaksama̱kó̱ namaklhti̱nanko̱y yama̱ laktáxtut hua̱ntu̱ xlá̱ ma̱lacnu̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Hua̱mpi̱ quit luhua lacatancs cca̱huaniyá̱n pi̱ akapú̱n, chu̱ ca̱tuxá̱huat tla̱n xlaktzánka̱lh, hua̱mpi̱ hua̱ntu̱ xamaká̱n tatzoktahuilani̱ttá̱ xtachihui̱n Dios c-Li̱kalhtahuaka ni̱ pala pu̱lactum caj chunatá̱ catitamakáxtakli̱ pala ni̱ juerza nakantaxtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pala cha̱tum chixcú̱ makaxtaka̱ xpusca̱t caj xpa̱lacata pi̱ tanu̱ hua̱nti̱ nata̱tapu̱chuhuay, pus tama̱ chixcú̱ tlahuay tlanca tala̱kalhí̱n c-xlacati̱n Dios; chu̱ yama̱ chixcú̱ hua̱nti̱ chú̱ nata̱tapu̱chuhuay yama̱ pusca̱t hua̱nti̱ makaxtakcanit, na̱ chuná̱ luhua lhu̱hua tala̱kalhí̱n tlahuay.” ");
INSERT INTO tosNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús na̱ huaniko̱lh yuma̱ takalhchihuí̱n: “Maktum xuí̱ cha̱tum chixcú hua̱mpi̱ luhua ma̱tamacu̱nú xuani̱t. Ni̱tú̱ xtzanka̱niy pala tú̱ namaclacasquín, chu̱ hua̱ntu̱ luhua xalacuan lháka̱t xlá̱ xli̱lhaka̱nán, chu̱ ankalhí̱n xtlahuay taca̱tani, hua̱mpi̱ pacs xalacuan lí̱huat hua̱ntu̱ xlá̱ xuakoy. ");
INSERT INTO tosNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chu̱ na̱ antiyá̱ yama̱ ca̱chiquí̱n xlama̱ cha̱tum chixcú hua̱mpi̱ luhua snu̱n li̱ma̱xkan xuani̱t, xlá̱ huanicán Lázaro. Yuma̱ koxuta chixcú̱ xli̱pu̱nu̱y xli̱cha̱tumi̱nica̱ c-xmacni̱ xtzitzi, antá̱ xlá̱ xan tahuilay ca̱tiyatna, c-xtanquilhti̱n xchic yama̱ ma̱tamacu̱nú. ");
INSERT INTO tosNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Caj u̱cu tla̱n xli̱kálhkasli̱ xpuhuán hua̱ntu̱ natamakuasa̱ c-xmesa ma̱tamacu̱nú hua̱ntu̱ xlá̱ xkalhxtakmakama̱, hua̱mpi̱ ni̱ pala actzú̱ caj xta̱huacán, pus hasta huata xatlá̱n chichi̱xni̱ xminko̱y macslipiko̱y la̱ntla̱ xka̱lhi̱y xtzitzi. ");
INSERT INTO tosNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Cha̱nchu̱ tílalh pi̱ yama̱ koxuta li̱ma̱xkan La̱zaro ni̱lh, huata xángeles Dios luhua li̱pa̱xuhu le̱nko̱lh c-xpa̱xtu̱n Abraham anta̱ni̱ xlá̱ huilachá̱ c-akapú̱n. Chu̱ ni̱ li̱maka̱s quilhtamacú̱ yama̱ ma̱tamacu̱nú̱ na̱ tíni̱lh, chu̱ tima̱acnu̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Acxni̱ antá̱ xuilachá̱ c-xpu̱tahui̱lhcan ni̱ní̱n, luhua li̱pe̱cua̱ la̱ntla̱ xpa̱ti̱nama̱, talacayá̱hualh c-akapú̱n, úcxilhli̱ xuí̱ c-xpu̱tahui̱lh Abraham, chu̱ Lázaro antá̱ xuí̱ c-xpa̱xtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Acxnicú̱ chú̱ pixtlanca̱ tzúculh ca̱tasay, chu̱ chuná̱ quilhánilh: ‘Tla̱ti Abraham, luhua catlahua̱ li̱tlá̱n, caquinkalhi̱ni̱ talakalhamá̱n, camacatampi̱ Lázaro laqui̱mpi̱ nama̱stajay c-xokspun xmacán, chu̱ na̱ camilh ma̱skahuihui̱y quisi̱máka̱t, sa̱mpi̱ luhua li̱pe̱cua̱ ctatlakajma̱ u̱nú̱ c-lhcúya̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hua̱mpi̱ Abraham chuná̱ kálhti̱lh: ‘Amigo, luhua xli̱ca̱na̱ calacapá̱stacti̱ pi̱ luhua tla̱n huix xlápa̱t c-mintalatamá̱n, chu̱ ni̱tú̱ xtzanka̱niyá̱n hua̱ntu̱ xmaclacasquina, chi̱nchu̱ yuma̱ koxuta Lázaro luhua xli̱ca̱na̱ xlá̱ ni̱tú̱ xkalhi̱y. Pus la̱nchú̱ xlá̱ luhua li̱pa̱xuhu lama̱, cha̱nchu̱ huix tatlakájpa̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Xa̱hua̱ masqui chuná, huí̱ lacatum pu̱lhmá̱n, luhua ca̱u̱ní̱n hua̱ntu̱ quinca̱stokopitziyá̱n, caj huá̱ xpalacata ni̱ lay anko̱ya̱chá̱ hua̱nti̱ yunú̱ huilakó̱, chu̱ na̱ ni̱ pala hua̱nti̱ huilako̱chá̱ tanú, ni̱ lay minko̱y u̱nú.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Yama̱ chixcú̱ hua̱nti̱ ma̱tamacu̱nú xuani̱t, chuná̱ huanipá̱: ‘Lapi̱ ni̱ lay puhuana̱ hua̱ntu̱ csquiniyá̱n, pus ca̱na̱ caj cama̱lakacha̱pi̱ Lázaro c-xchic quintla̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sa̱mpi̱ kalhaquitzis ckalhi̱y quinata̱lán, chu̱ clacasquín pi̱ luhua nama̱akata̱ksni̱ko̱y laqui̱mpi̱ xlacán ni̱ naminko̱y u̱nú, sa̱mpi̱ luhua xli̱ca̱na̱ li̱pe̱cua̱ la̱ntla̱ huí̱ tapa̱tí̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham chuná̱ kalhti̱pá̱: ‘Xlacán aya kalhi̱ko̱y xli̱ma̱paksí̱n hua̱ntu̱ títzokli̱ Moisés, chu̱ makapi-tzi̱n profetas c-Li̱kalhtahuaka, pus huata xatlá̱n huá̱ cama̱kanta̱xti̱ko̱chá.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Cha̱nchu̱ yama̱ ma̱tamacu̱nú̱ huá̱: ‘Quintla̱tican Abraham, luhua xli̱ca̱na̱ hua̱ntu̱ huix quilhuámpa̱t, hua̱mpi̱ lapi̱ nalakanko̱y hua̱nti̱ aya qui̱taspitni̱ttá̱ ca̱li̱ní̱n, cha̱catzi̱ya̱ xlacán natalakaspitta̱yako̱y, chu̱ nalakpali̱ko̱y xali̱xcajnit xtalacapa̱stacnicán.’ ");
INSERT INTO tosNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Hua̱ lapi̱ xlacán ni̱ kalhakaxmatniko̱y hua̱ntu̱ tzokko̱ni̱t Moisés, chu̱ xli̱pacs profetas, ¿pi̱ li̱huacá̱ chú̱ nakaxmatniko̱y lapi̱ nalakastakuanán cha̱tum ni̱n ca̱li̱ní̱n?’, kálhti̱lh Abraham.” ");
INSERT INTO tosNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Maktum Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: “Unú̱ ca̱tuxá̱huat ankalhí̱n lama̱kó̱ nahuán hua̱nti̱ nama̱tlahui̱nanko̱y tala̱kalhí̱n, hua̱mpi̱ koxutá̱ yamá̱ hua̱nti̱ chuná̱ natlahuay laqui̱mpi̱ nama̱ktzanka̱ya̱huay hua̱nti̱ aya tzucuni̱t quintali̱pa̱huán. Huata xali̱huacá̱ tla̱n xuá̱, acxni̱ ni̱ a̱tlahuay, pi̱ xpixchi̱huacaca̱ aktum tlanca xachihuix pu̱squiti, chu̱ xmaca̱nca̱ c-ta̱kaya̱huaná̱ laqui̱mpi̱ antá̱ nalaktzanka̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Pus luhua cui̱ntaj catlahuátit pi̱ ni̱ chuná̱ natlahuayá̱tit! “Pus lapi̱ ni̱tlá̱n tu̱ xtlahuanín minta̱lá, acxni̱ tuncán cali̱huani; na̱ lapi̱ xtalakaspittá̱yalh, chu̱ nahuán pi̱ nia̱lh chuná̱ catitláhualh, pus huix cama̱tzanka̱nani̱ hua̱ntu̱ tlahuanín. ");
INSERT INTO tosNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma̱squi hasta maktujún la̱ntla̱ tantacú̱ catlahuanín hua̱ntu̱ ni̱tlá̱n, chu̱ pala maktujún naminá̱n huaniyá̱n: ‘Chú̱ nia̱lh chuná̱ cactitláhualh’, huix cama̱tzanka̱nani̱ hua̱ntu̱ tlahuanín.” ");
INSERT INTO tosNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Maktum xli̱ma̱kalhtahuákat chuná̱ huaniko̱lh Jesús: —Caquinca̱ma̱siyuni̱ la̱ntla̱ nakalhi̱ya̱hu tlihuaka̱ quintaca̱najlacán laqui̱mpi̱ li̱huana̱ nali̱pa̱huana̱hu Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Puschí̱ huaniko̱lh Quimpu̱chinacán: —Hua̱ lapi̱ caj xtzucútit kalhi̱yá̱tit mintaca̱najlacán ca̱na̱ caj la̱ntla̱ xli̱acti̱ná̱ la̱ntla̱ xatalhtzi mostaza, chu̱ caj la̱ntla̱ huixín xuanítit u̱ya̱ akatum tlanca quihui: ‘Catapulhu̱ la̱ u̱ya̱t, chu̱ capit tati̱ju̱ta̱yaya̱ c-xlaquita̱t ta̱kaya̱huaná’, chu̱ quit tancs cca̱huaniyá̱n pi̱ yama̱ quihui xca̱kalhakaxmatni̱ hua̱ntu̱ xli̱ma̱paksí̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Lapi̱ huí̱ cha̱tum caj tasa̱cua ti̱ acxni̱ naqui̱taspita̱ ca̱tuhuá̱n pala antá̱ xlakuaxnama̱, usuchí̱ xmaktakalhnima̱kó̱ xua̱cax xma̱la̱ná, acxni̱ xlá̱ nachín, ¿pi̱ puhuaná̱tit huixín pi̱ chuná̱ nahuaniy: ‘Tla̱n pi̱ tani̱ta, catanu, catahuila̱ la̱ntla̱ u̱yá̱ mesa la̱qui̱mpi̱ nacma̱xqui̱yá̱n tu̱ nahuaya’? ");
INSERT INTO tosNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pus quit lacatancs cca̱huaniyá̱n pi̱ xma̱la̱ná̱ ni̱ chuná catihuánilh, huata chuná̱ nahuaniy: ‘Lacapala̱ catanu, chu̱ caca̱xtlahua̱ tu̱ nacuay, na̱ calakpalí̱nanti̱ laqui̱mpi̱ tla̱n naquimuju̱niya̱ quilí̱huat. A̱li̱sta̱lh acxnicú̱ ni̱li̱huaya̱ cua̱yanko̱ni̱t nahuán, acxnicú̱ chú̱ na̱ nahua̱yana̱ huix.’ ");
INSERT INTO tosNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma̱squi xli̱ca̱na̱ tama̱ tasa̱cua luhua tla̱n scujni̱t tantacú, hua̱mpi̱ ni̱ capuhuántit pala xli̱lakchá̱nat napa̱xcatcatzi̱nicán hua̱ntu̱ xlá̱ qui̱lí̱scujli, sa̱mpi̱ xlá̱ luhua caj xmá̱n hua̱ tla̱n ma̱kantaxti̱ni̱t hua̱ntu̱ xli̱tláhuat xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pus na̱ chuná̱ huixín, acxni̱ natlahuako̱yá̱tit aktum tascújut hua̱ntu̱ Dios naca̱ma̱tlahui̱yá̱n, na̱ chuná̱ cahuántit: ‘Quin caj li̱lakaputza scujní̱n hua̱nti̱ ni̱ pala tzinú̱ quinca̱mini̱niyá̱n naquinca̱pa̱xcatcatzi̱nicaná̱n hua̱ntu̱ xli̱scujma̱hu, caj xma̱n huá̱ cma̱kantaxti̱ni̱tahu hua̱ntu̱ quili̱tlahuatcán xuani̱t.’” ");
INSERT INTO tosNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Cha̱nchu̱ tílalh pi̱ maktum la̱ntla̱ xtla̱huama̱ c-tiji, ti̱tum xama̱ c-Jerusalén, chu̱ xpuntaxtuma̱kó̱ lacalhu̱hua lactzu̱ ca̱chiquí̱n hua̱ntu̱ ma̱paksi̱ko̱y Samaria, chu̱ Galilea, ");
INSERT INTO tosNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","cha̱lh c-aktum actzu̱ ca̱chiquí̱n anta̱ni̱ ucxilhko̱lh kalhaca̱hu chixcuhuí̱n hua̱nti̱ xpasako̱ni̱t pu̱lactum li̱xcajnit tzitzi̱ huanicán lepra̱, xlacán caj lakamákat ta̱yako̱chá. ");
INSERT INTO tosNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Huata caj taquílhmilh, chu̱ chuná̱ huaniko̱lh: —¡Luhua xli̱ca̱na̱ catlahua̱ tlanca li̱tlá̱n caquinca̱lakalhámanti! ");
INSERT INTO tosNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Acxni̱ xlá̱ ucxilhko̱lh, chuná̱ huaniko̱lh: —Tla̱n, hua̱mpi̱ lacapala̱ chú̱ capítit ma̱siyuniyá̱tit mimacnicán cha̱tum pa̱li̱ c-templo laqui̱mpi̱ xlá̱ nama̱luloka̱ pi̱ aya ca̱makaxtakni̱tán mintajatatcán. Acxni̱ xlacán kaxmatko̱lh hua̱ntu̱ huaniko̱ca̱ lacapala̱ anko̱lh, hua̱mpi̱ acxni̱ xtla̱huama̱kó̱ c-tiji pacsniko̱lh tuncán yama̱ xtajatatcán hua̱ntu̱ xkalhi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cha̱nchu̱ cha̱tum xlacán, hua̱nti̱ xala c-Samaria, xlá̱ ni̱ judío xuani̱t, acxni̱ makcátzi̱lh pi̱ aya xtatla̱ni̱ni̱t, huata lacapala̱ talákspitli, chu̱ luhua pixtlanca̱ la̱ntla̱ xca̱tasati̱lhay xpa̱xcatcatzi̱nima̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yama̱ samaritano acxni̱ cha̱lh c-xlacati̱n Jesús lakatatzokóstalh laqui̱mpi̱ chuná̱ napa̱xcatcatzi̱niy, chu̱ taquilhpú̱talh hasta lí̱cha̱lh xlacán ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hua̱mpi̱ Jesús chuná̱ chihuí̱nalh: —¿Tú̱ kalhaca̱hu xuanko̱ni̱t hua̱nti̱ xkalhi̱ko̱y yama̱ li̱xcajnit tajátat, chu̱ pacs pacsko̱lh? ¿Ní chú̱ ya̱kó̱ a̱makapitzi̱n kalhanaja̱tza? ");
INSERT INTO tosNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Lá̱ntla̱ pi̱ caj xma̱n hua̱ yuma̱ chixcú̱, hua̱nti̱ ni̱ judío, huata huá̱ táspitli̱ laqui̱mpi̱ napa̱xcatcatzi̱niy Dios? ");
INSERT INTO tosNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱li̱sta̱lh chuná̱ li̱ma̱paksí̱lh yuma̱ chixcú: —Cata̱qui, chu̱ capittá̱ li̱pa̱xuhu c-mínchic. Huix luhua xli̱ca̱na̱ pacsni̱ta̱ sa̱mpi̱ chuná̱ quili̱pá̱huanti. ");
INSERT INTO tosNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Maktum makapitzi̱n fariseos kalhasquinko̱lh Jesús ni̱li̱huaya̱ luhua nachín yama̱ xtapaksi̱t Dios hua̱ntu̱ nama̱tzuqui̱y. Xlá̱ chuná̱ kalhti̱ko̱lh: —Acxni̱ nachín xtapaksi̱t Dios ni̱ capuhuántit naucxilhcán pala tú̱ tlanca xali̱ucxílhti̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Chu̱ na̱ ni̱ naca̱najlayá̱tit pala tí̱ naca̱huaniyá̱n: ‘Unú̱ huí̱’, usuchí̱ ‘A̱huilachá’; sa̱mpi̱ yama̱ xtapaksi̱t Dios hua̱ntu̱ cli̱chihui̱nani̱t aya antiyá̱ lama̱ c-milaksti̱pa̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A̱li̱sta̱lh xlá̱ chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Nalakchá̱n quilhtamacú̱ acxni̱ huixín naucxilhputuná̱tit na̱pi̱ makstum la̱ntla̱ quit, Xatalacsacni Chixcú̱, nacmimpalay laqui̱mpi̱ nactzucuy ma̱paksi̱nán, hua̱mpi̱ ni̱ naj caquintiucxílhtit. ");
INSERT INTO tosNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Huí̱ ti̱ naca̱akskahuiputuná̱n acxni̱ naca̱huaniyá̱n: ‘Unú̱ huí̱’, usu naca̱huanicaná̱tit: ‘Ajtiyán huilachá’, hua̱mpi̱ huixín ni̱ tita̱piná̱tit putzayá̱tit, chu̱ na̱ ni̱ naca̱najlayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sa̱mpi̱ na̱ xta̱chuná̱ la̱ntla̱ caj xamaktum xli̱ca̱tlanca̱ c-xtampi̱n akapú̱n tasiyuy xmakaxkaka̱nat maklípit, pus na̱ chuná̱ chú̱ quit, Xatalacsacni Chixcú, caj xalán nalakchá̱n quilhtamacú̱ acxni̱ nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Hua̱mpi̱ xapu̱laná̱ xlacasquinca̱ li̱pe̱cua nacpa̱ti̱nán u̱nú̱ ca̱tiyatna, sa̱mpi̱ yuma̱ tachixcuhuí̱tat hua̱nti̱ lama̱kó̱ la̱nchiyu̱ quilhtamacú̱ maktum naquilakmakanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Na̱ xta̱chuná̱ la̱ntla̱ akspulako̱lh tachixcuhuí̱tat yama̱ quilhtamacú̱ acxni̱ xlama̱ Noé, chu̱ sputca̱ ca̱tiyatna, pus na̱ luhua xta̱chuná̱ nalakchá̱n yama̱ quilhtamacú̱ acxni̱ nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Yama̱ tachixcuhuí̱tat luhua li̱pa̱xuhu xlama̱kó̱, xua̱ya̱ma̱kó̱, makapitzí̱n xca̱tanima̱kó̱, xtapu̱chuhuama̱kó̱, chu̱ xmacama̱sta̱ma̱kó̱ xlactzumajancán, hasta acxni̱ lákcha̱lh quilhtamacú̱ la̱ntla̱ Noé táju̱lh c-páklha̱t hua̱ntu̱ huanicán arca, chu̱ chuná tílalh muncá̱clat, chu̱ xli̱pacs tachixcuhuí̱tat tini̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chu̱ na̱ xta̱chuná̱ tilapá̱ acxni̱ xlama̱ Lot: xli̱pacs hua̱nti̱ xlama̱kó̱ c-Sodoma, luhua li̱pa̱xuhu xlama̱kó̱, xua̱ya̱ma̱kó̱, xkotnama̱kó̱, xtama̱huanama̱kó̱, xya̱huama̱kó̱ xchiccán, chu̱ xchana̱nama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Hua̱mpi̱ acxni̱ chú̱ titaxtuchá̱ Lot c-Sodoma, sa̱mpi̱ chuná̱ xuanini̱t Dios catláhualh, pus ta̱ctachi̱ lhcúya̱t c-akapú̱n, chu̱ azufre hua̱ntu̱ clhcuma̱, chu̱ pu̱tum pacs makni̱ko̱lh tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pus na̱ chuná̱ chú̱ ni̱ cha̱catzi̱ya̱ nalatama̱ko̱y tachixcuhuí̱tat a̱ma̱ quilhtamacú̱ acxni̱ quit, Xatalacsacni Chixcú, nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Acxni̱ nalakchá̱n yama̱ quilhtamacú̱, pala tí̱ huacachá nahuán c-xaksti̱n ta̱lhma̱na chiqui, chu̱ lapi̱ antá̱ huili̱ni̱t nahuán c-xpu̱lacni xchic xmaclacasquínat, nia̱lh calacapá̱stacli̱ pala tú̱ namín tamacaxtuy, huata xatlá̱n caj catzá̱lalh; chu̱ pala tí̱ la̱ma̱chá nahuán ca̱tuhuá̱n, nia̱lh catáspitli̱ c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Caj luhua calacapa̱stáctit hua̱ntu̱ lánilh xpusca̱t Lot, caj xpa̱lacata pi̱ xlakli̱puhuán hua̱ntu̱ xakxtakmakani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Sa̱mpi̱ hua̱nti̱ lakli̱puhuán, chu̱ luhua nalakma̱xtuputún xlatáma̱t u̱nú̱ ca̱tiyatna, pus huata aktum cacátzi̱lh pi̱ namakatzanka̱y, hua̱mpi̱ hua̱nti̱ namakatzanka̱y xlatáma̱t huata huá̱ nalakma̱xtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Quit xli̱ca̱na̱ cca̱huaniyá̱n pi̱ acxni̱ yama̱ ca̱tzi̱sní, cha̱tuy hua̱nti̱ lhtatama̱kó̱ nahuán c-aktuma pu̱tama, cha̱tum nale̱ncán, chu̱ hua̱ a̱cha̱tum namakaxtakcán. ");
INSERT INTO tosNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cha̱tuy lacchaján, lacxtum squitima̱kó̱ nahuán; hua̱ cha̱tum nale̱ncán, chi̱nchu̱ hua a̱cha̱tum, namakaxtakcán. ");
INSERT INTO tosNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cha̱tuy chixcuhuí̱n, lacxtum scujma̱kó̱ nahuán c-aktuma pú̱cuxtu; hua̱ cha̱tum nale̱ncán, chi̱nchu̱ hua̱ a̱cha̱tum namakaxtakcán.” ");
INSERT INTO tosNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yama̱ xli̱ma̱kalhtahuáka̱t acxni̱ chuná̱ kaxmatko̱lh yuma̱ tachihuí̱n hua̱ntu̱ Jesús huá̱, chuná̱ kalhasquinko̱lh: —¿Ní li̱huaya̱ chuná̱ nakantaxtuy hua̱ntu̱ quilhuámpa̱t? Xlá̱ chuná̱ kalhti̱ko̱lh: —Huixín catzi̱yá̱tit pi̱ anta̱ni̱ ni̱y tantum takalhí̱n, pacs tuncán catzi̱ko̱y, chu̱ tamacxtumi̱ko̱y chu̱n, pus na̱ chuná̱ chu̱ acxni̱ nacmimpalay, tuncán cani̱huá̱ nacatzi̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Maktum Jesús li̱xakatli̱ko̱lh aktum takalhchihuí̱n xpa̱lacata oración, pi̱ xlacasquinca xli̱tatláhuat ankalhí̱n, hua̱mpi̱ ni̱ nalakacha̱niko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xlá̱ chuná̱ huaniko̱lh: “Maktum xuí̱ cha̱tum juez c-aktum ca̱chiquí̱n, xlá̱ ni̱ pala tzinú̱ xlacapuhuaniy Dios, xa̱huachí̱ xlá̱ ni̱tí̱ xma̱xqui̱y ca̱cni. ");
INSERT INTO tosNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chu̱ na̱ antiyá̱ yama̱ ca̱chiquí̱n xuí̱ cha̱tum puhuani̱ni̱ pusca̱t, xlá̱ ankalhí̱n xlakán yama̱ juez laqui̱mpi̱ natlahuaniy justicia sa̱mpi̱ xlá̱ xkalhi̱y aktum xtalakapútzit, pus huata xlacasquín nakalhmakta̱yacán c-xlacatí̱n hua̱nti̱ xta̱la̱tlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Hua̱mpi̱ la̱ntla̱ ni̱ xli̱makli̱t xqui̱laklacani̱ttá, yama̱ juez ni̱ xtlahuaputún hua̱ntu̱ xli̱ma̱katzanka̱ma̱ pusca̱t. Hua̱mpi̱ a̱li̱sta̱lh xlá̱ chuná̱ lacapá̱stacli: ‘Ma̱squi xli̱ca̱na̱ ni̱ cpe̱cuaniy Dios, chu̱ na̱ ni̱ quincui̱nta̱ hua̱ntu̱ akspulako̱y tachixcuhuí̱tat, ");
INSERT INTO tosNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","hua̱mpi̱ xali̱huacajcú̱ hua̱ yuma̱ pusca̱t, pi̱ tza̱pu̱ quima̱akatzanka̱tla̱huán, huata xatlá̱n nacmakta̱yay laqui̱mpi̱ chuná̱ nia̱lh namín quima̱aklhu̱hui̱y, chu̱ taji̱ naquima̱acchichijui̱y.’” ");
INSERT INTO tosNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús chuná̱ huanipalako̱lh xli̱ma̱kalhtahuáka̱t: “Ma̱squi yama̱ Juez luhua ni̱ pala tzinú̱ tla̱n xtapuhuá̱n, fuerza chuná̱ tlahuánilh yama̱ pusca̱t laqui̱mpi̱ nia̱lh nama̱acchichijui̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pus lapi̱ tama̱ juez maktá̱yalh yama̱ pusca̱t, tlahuánilh justicia, ¿lá̱ntla̱ pi̱ ni̱ lay chú̱ ca̱najlayá̱tit pi̱ Dios namakta̱yako̱y xcamán hua̱nti̱ xlá̱ lacsacko̱ni̱t, acxni̱ tza̱pu̱ squiniko̱y xtamakta̱y tantacú tantascaca? Usu ¿pi̱ huata chá̱ puhuaná̱tit pi̱ nama̱makapali̱ko̱y tzinú̱? ");
INSERT INTO tosNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pus quit luhua lacatancs cca̱huaniyá̱n pi̱ lacapala̱ namakta̱yako̱y, ni̱ catima̱makapali̱ko̱lh. Hua̱mpi̱ hua̱ acxni̱ quit, Xatalacsacni Chixcú, nacmimpalay ca̱tiyatna, ¿pi̱ nacta̱ksa cahuá̱ hua̱nti̱ xli̱ca̱na̱ ca̱najlako̱y nahuán?” ");
INSERT INTO tosNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Cumu Jesús xcatzi̱y pi̱ makapitzí̱n hua̱nti̱ antá̱ xkaxmatnima̱kó̱ xtachihuí̱n, xlacán xpuhuanko̱y pi̱ luhua tla̱n xtapuhua̱ncán, chu̱ huata ni̱tú̱ xli̱ucxilhko̱y a̱makapitzí̱n, pus caj huá̱ xpa̱lacata̱ Jesús li̱xakatli̱ko̱lh u̱ma̱ takalhchihuí̱n: ");
INSERT INTO tosNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Maktum cha̱tuy chixcuhuí̱n anko̱lh tlahuako̱y xoracioncán c-tlanca templo c-Jerusalén. Cha̱tum, fariseo xuani̱t hua̱nti̱ xli̱taxtuy luhua tla̱n judío sa̱mpi̱ pacs xma̱kantaxti̱y xli̱ma̱paksi̱n Moisés, chi̱nchu̱ hua̱ a̱cha̱tum caj xma̱ta̱ji̱na impuestos, chu̱ huá̱ xpalacata̱ xli̱puhuanicán pi̱ xlá̱ ni̱ tla̱n judío xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yama̱ fariseo antá̱ xlacahuaya̱ lacatzú̱ anta̱ni̱ luhua lakataquilhpu̱tacán Dios, chu̱ chuná̱ xtlahuanima̱ oración Dios: ‘Quintla̱tican Dios, luhua cpa̱xcatcatzi̱niyá̱n pi̱ quit luhua tla̱n chixcú, chu̱ ni̱ chuná̱ cli̱catzi̱y la̱ntla̱ yama̱ hua̱nti̱ kalha̱nán, chu̱ hua̱nti̱ luhua lacli̱xcajnit xtapuhua̱ncán, usuchí̱ la̱ntla̱ hua̱nti̱ xakatli̱ko̱y tanuj lacchaján, xa̱huachí̱ quit ni̱ li̱xcájnit clama̱ ni̱ xta̱chuná̱ la̱ntla̱ u̱laya̱ xma̱ta̱ji̱na impuestos. ");
INSERT INTO tosNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Quit maktuy cmakalhkajnán su kalhxtaknán aktum semana laqui̱mpi̱ chuná̱ cli̱ca̱cni̱naniyá̱n, chu̱ quit pacs cma̱sta̱y hua̱ntu̱ quili̱má̱sta̱t diezmo xla lhu̱hua quintumi̱n hua̱ntu̱ ctlajay.’ ");
INSERT INTO tosNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cha̱nchu̱ yama̱ cha̱tum chixcú hua̱nti̱ xpu̱qui̱na impuestos, huata xlá̱ mákat quilhpu̱taj tá̱yalh, hasta ni̱ pala tzinú̱ xtalacaya̱huaputún ta̱lhmá̱n, chu̱ chuná̱ xtlahuama̱ oración, xquilhuama̱: ‘Tla̱ti Dios, catlahua̱ li̱tlá̱n caquilakalhámanti, chu̱ caquima̱tzanka̱nani sa̱mpi̱ luhua makla̱kalhi̱ná̱ cmakcatzi̱cán, caj xpa̱lacata lhu̱hua̱ hua̱ntu̱ ctlahuani̱t quintala̱kalhí̱n.’” ");
INSERT INTO tosNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesús huaniko̱lh li̱lhu̱hua̱ hua̱nti̱ antá̱ xkaxmatma̱kó̱ xtachihuí̱n: “Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ yama̱ chixcú̱ hua̱nti̱ xpu̱qui̱na impuestos, acxni̱ yama̱ quilhtamacú̱ xlá̱ chilh c-xchic, Dios aya xma̱tzanka̱nanini̱t xtala̱kalhí̱n hua̱ntu̱ xlá̱ xtlahuani̱t, chu̱ ni̱ xahua̱ yama̱ fariseo hua̱nti̱ caj tlanca̱ xcatzi̱y c-xlacati̱n Dios. Sa̱mpi̱ hua̱nti̱ luhua xli̱ca̱na̱ tla̱n cristiano li̱ma̱xtucán xacstu, huata xlá̱ nalakmakancán; hua̱mpi̱ hua̱nti̱ li̱ta̱yay pi̱ ni̱tu̱ xlakasi, chu̱ kalhapalay pi̱ makla̱kalhi̱ná, huata xlá̱ nama̱tlanqui̱cán. Huá̱ chuná̱ cca̱li̱huanimá̱n sa̱mpi̱ hua̱nti̱ caj xacstu putzama̱ la̱ntla̱ natatlanqui̱y c-xlacati̱n Dios xalán ni̱ maka̱s tama̱ma̱xani̱y, chu̱ ma̱tu̱tzuhui̱cán; hua̱mpi̱ hua̱nti̱ ni̱tú̱ putzama̱ la̱ntla̱ natalacatla̱ni̱y huata caj li̱ta̱yay pi̱ ni̱tu̱ xlakasi, huata huá̱ chú̱ ti̱ Dios nama̱tlanqui̱y.” ");
INSERT INTO tosNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Maktum makapitzí̱n xli̱miniko̱y lactzu̱ xcamancán laqui̱mpi̱ Jesús naokspu̱huili̱ko̱y xmacán, chu̱ nasiculana̱tlahuako̱y; hua̱mpi̱ acxni̱ xli̱ma̱kalhtahuáka̱t ucxilhko̱lh, tzucuko̱lh lacaquilhni̱ko̱y hua̱nti̱ xli̱mima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Hua̱mpi̱ Jesús tasaniko̱lh lactzu̱ camán pi̱ calakminko̱lh, chu̱ chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Luhua xli̱ca̱na̱ catlahuátit li̱tlá̱n, ni̱ cali̱huanikó̱tit tama̱ lactzu̱ camán naquilakminko̱y; sa̱mpi̱ Dios caj xma̱n huá̱ ma̱xqui̱ko̱y talacasquín natapaksi̱niko̱y c-xasa̱sti xtapáksi̱t hua̱nti̱ kalhi̱ko̱y xtalacapa̱stacnicán xta̱chuná̱ la̱ntla̱ lactzu̱ camán. ");
INSERT INTO tosNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Luhua xli̱ca̱na̱ cca̱huaniyá̱n, pi̱ caxati̱cahuá̱ hua̱nti̱ ni̱tlá̱n xtláhualh nama̱paksi̱y Dios la̱ cha̱tum xasma̱lhua actzu̱ kahuasa, ni̱ lay xlá̱ catitapaksí̱nilh c-xasa̱sti xtapáksi̱t tu̱ huili̱putún ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Maktum cha̱tum luhua tali̱pa̱hu chixcú̱ kalhásquilh Jesús: —Ma̱kalhtahuaka̱ná, huix luhua xli̱ca̱na̱ tla̱n catzi̱ya, ¿tú̱ luhua tla̱n tatlahu quili̱tláhuat laqui̱mpi̱ tla̱n nackalhi̱y yama̱ li̱pa̱xuhu latáma̱t c-akapú̱n hua̱ntu̱ niucxni̱ nalaksputa? ");
INSERT INTO tosNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Cha̱nchu̱ Jesús huánilh: —¿Tú̱huan quihuaniya̱ pi̱ quit luhua tla̱n ccatzi̱y? ¿Tú̱ catzi̱ya̱ pi̱ u̱nú̱ ni̱tí̱ anán hua̱nti̱ xli̱ca̱na̱ tla̱n huata caj xma̱n cha̱tum, huá̱ Dios? ");
INSERT INTO tosNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","¿Tú̱huan chi̱nchu̱ quili̱kalhasquina̱ xpa̱lacata tú̱ mili̱tláhuat? Sa̱mpi̱ huix catzi̱yatá̱ la̱ntla̱ huí̱ kampa̱ca̱hu li̱ma̱paksí̱n hua̱ntu̱ Dios macamá̱xqui̱lh Moisés; chuná̱ huan: ‘Ni̱ caxakatli̱ tanuj pusca̱t lapi̱ huí̱ mimpusca̱t; niucxni̱ tí̱ timakni̱ya; niucxni̱ tí̱ tili̱ya̱huaya̱ ta̱ksaní̱n; niucxni̱ tí̱ timakkalha̱nana; na̱ cama̱xqui̱kó̱ ca̱cni̱ mintzí, xa̱hua̱ mintla̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yama̱ chixcú chuná̱ kalhtí̱nalh, huá̱: —Xli̱pacs tama̱ hua̱ntu̱ huix quihuanípa̱t, hasta la̱ntla̱ actzu̱cú̱ xacuani̱t ctzucuni̱t ma̱kantaxti̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Acxni̱ káxmatli̱ Jesús yumá̱, chuná̱ huánilh: —Tla̱n la̱ntla̱ huana, hua̱mpi̱ huí̱ a̱kampa̱tum hua̱ntu̱ tzanka̱nimá̱n mili̱tláhuat, casta̱t xli̱pacs tu̱ kalhi̱ya, chu̱ cama̱xqui̱kó̱ mintumi̱n hua̱nti̱ lakli̱ma̱xkaní̱n, laqui̱mpi̱ chuná̱ huix nakalhi̱ya̱ lhu̱hua̱ mintamacú̱n c-akapú̱n. Acxni̱ chú̱ chuná̱ natlahuako̱ya, tuncán natana laqui̱mpi̱ xli̱pa̱án naquista̱laniya. ");
INSERT INTO tosNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hua̱mpi̱ acxni̱ xlá̱ káxmatli̱ hua̱ntu̱ huánilh Jesús, yama̱ chixcú̱ luhua li̱puhua̱, sa̱mpi̱ luhua ma̱tamacu̱nú xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Acxni̱ úcxilhli̱ Jesús pi̱ li̱pe̱cua̱ xtali̱puhua̱ni̱ni̱t, chuná̱ huá̱: —¡Ca̱na̱ li̱pe̱cua̱ tuhua̱ xpalacata̱ hua̱nti̱ ma̱tamacu̱nú̱ natanu̱y c-xtapaksi̱t Dios! ");
INSERT INTO tosNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Huata ni̱ xatuhua̱ xtánu̱lh tantum camello c-xlhucu li̱tzapan, ni̱ caj la̱ntla̱ pala cha̱tum ma̱tamacu̱nú̱ ti̱ lakcatzán xtumi̱n tla̱n natanu̱y c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Makapitzí̱n ti̱ xkaxmatko̱y hua̱ntu̱ xlá̱ huá̱, chuná̱ quilhtzucuko̱lh: —Lapi̱ chuná, ¿tí̱ chú̱ luhua naakapu̱taxtuy? ");
INSERT INTO tosNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús chuná̱ huaniko̱lh: —Xli̱ca̱na̱, hua̱ntu̱ xpa̱lacatacan chixcuhuí̱n, ni̱ lay ma̱tla̱ni̱ko̱y hua̱ntu̱ quit cquilhuama̱, hua̱mpi̱ hua̱ntu̱ xpa̱lacata Dios, pacs ma̱tla̱ni̱y xli̱pacs hua̱ntu̱ puhuán natlahuay, ni̱tú̱ tuhua̱ xpalacata. ");
INSERT INTO tosNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro chuná̱ huánilh: —Quimpu̱chinacán, quin pacs cakxtakmakani̱tahu hua̱ntu̱ xackalhi̱ya̱hu caj xpa̱lacata cca̱sta̱lanimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Puschí̱ Jesús chuná̱ kálhti̱lh: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ xli̱pacs hua̱nti̱ naakxtakmakán xchic, usu xtla̱t, chu̱ xtzi, usu xnata̱lán, usuchí̱ xpusca̱t, usu pala xcamán, caj xpa̱lacata kalhakaxmatputún Dios c-xtapáksi̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","pus huata tlak luhua lhu̱hua̱ hua̱ntu̱ nama̱xqui̱cán ni̱ xahua̱ la̱ tu̱ xkalhi̱y u̱nú̱ ca̱tiyatna, chu̱ na̱ nama̱xqui̱cán yama̱ latáma̱t c-akapú̱n hua̱ntu̱ niucxni̱ nalaksputa. ");
INSERT INTO tosNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maktum Jesús caj tánu̱ ta̱anko̱lh kalhacu̱tuy xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: “Huixín catzi̱yá̱tit pi̱ la̱nchú̱ ama̱hu c-Jerusalén laqui̱mpi̱ antá̱ nakantaxtuya̱chá̱ xli̱pacs hua̱ntu̱ tili̱chihui̱nanko̱lh profetas acxni̱ titzokko̱lh c-Li̱kalhtahuaka̱ hua̱ntu̱ naquiakspulay quit, Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pus antá̱ naquimacama̱sta̱cán c-xmacancan chixcuhuí̱n hua̱nti̱ a̱lacatanuj xalaní̱n hua̱nti̱ ni̱ judíos; xlacán naquili̱kalhakama̱nanko̱y, chu̱ cala̱huá̱ naquintlahuaniko̱y hasta naquilacachujmani̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Tla̱n naquihuili̱niko̱y, chu̱ a̱li̱sta̱lh naquimakni̱ko̱y; hua̱mpi̱ caj xli̱aktutu quilhtamacú̱ naclakastakuanán ca̱li̱ní̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yama̱ xli̱ma̱kalhtahuaka̱t Jesús ni̱tú̱ xatú̱ xakata̱ksko̱y hua̱ntu̱ xuaniputún xtachihuí̱n; xa̱huachí̱ hasta ni̱ pala tzinú̱ xcatzi̱ko̱y xatú̱ xpa̱lacata̱ chuná̱ xli̱ta̱chihui̱nama̱kó̱, sa̱mpi̱ yama̱ xtakalhchihuí̱n caj la̱ xatze̱k tachihuí̱n qui̱taxtuniko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Acxni̱ Jesús lacatzuhuá̱ xlati̱lhay c-xaca̱chiqui̱n Jericó, cha̱tum lakatzí̱n xuí̱ c-xquilhpa̱n tiji, csquinima̱kó̱ limosna hua̱nti̱ antá̱ xlactla̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Acxni̱ xlá̱ káxmatli̱ pi̱ luhua li̱lhu̱hua̱ xtla̱huama̱kó̱, kalhasquiní̱nalh xatú̱ tla̱n xlama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pus huanica̱ pi̱ Jesús xala c-Nazaret antá̱ xlactla̱huama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Acxni̱ xlá̱ káxmatli̱ hua̱ntu̱ huanica̱, chuná̱ quilhánilh: —¡Jesús, xquilhtzucut xamaka̱n rey David, caquinkalhi̱ni̱ talakalhamá̱n! ");
INSERT INTO tosNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hua̱nti̱ xpu̱lati̱lhako̱y c-tiji̱ tzucuko̱lh lacaquilhni̱ko̱y laqui̱mpi̱ nakatxtaka. Hua̱mpi̱ xlá̱ a̱tzinú̱ luhua li̱huacá̱ tzúculh quilhaniy: —¡Jesús, xquilhtzucut xamaka̱n rey David, catlahua̱ li̱tlá̱n caquilakalhámanti! ");
INSERT INTO tosNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús tachókolh, chu̱ ma̱tiyí̱nalh c-xlacatí̱n. Acxni̱ antiyá̱ lacatzú̱ xlakalaya̱, chuná̱ kalhásquilh: ");
INSERT INTO tosNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Tú̱ lacasquina̱ nactlahuay mimpa̱lacata? Xlá̱ chuná̱ huánilh: —Quimpuchiná, quit clacasquín xaclacahuá̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús chuná̱ huánilh: —¡Pus la̱nchuj tuncán calacahuá̱nanti! Huix aya talacatla̱ni̱ni̱ta̱ sa̱mpi̱ xli̱ca̱na̱ ca̱najla, chu̱ quili̱pá̱huanti pi̱ tla̱n nacma̱pacsayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pus acxni tuncán yama̱ lakatzí̱n tla̱n lacahuá̱nalh, chu̱ sta̱lánilh Jesús, xpa̱xcatcatzi̱niti̱lhay Dios. Xli̱pacs ti̱ ucxilhko̱lh xtascujut Jesús na̱ chuná̱ xpa̱xcatcatzi̱nima̱kó̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús cha̱lh c-Jericó, chu̱ antá̱ xti̱pu̱lacpuntaxtuma̱ ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na̱ antá̱ yama̱ ca̱chiquí̱n xuí̱ cha̱tum chixcú, luhua ma̱tamacu̱nú, xuanicán Zaqueo. Hua̱ xlá̱ xpuxcucán xuani̱t hua̱nti̱ xma̱ta̱ji̱nanko̱y impuestos. ");
INSERT INTO tosNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xlá̱ luhua xlakapasputún Jesús, hua̱mpi̱ ni̱ lay xucxilha sa̱mpi̱ luhua lhu̱hua̱ xtzamacán, xa̱huachí̱ Zaqueo actzu̱ chixcú xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huata laqui̱mpi̱ tla̱n xlá̱ naucxilha, takosú̱n pú̱lalh, chu̱ lacapala̱ tahuácalh c-akatum quihui anta̱ni̱ xlá̱ nati̱taxtuy Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Acxni̱ luhua antá̱ xti̱taxtuma̱ Jesús yama̱ lacatum, titalacayá̱hualh c-xakan quihui, li̱ma̱pa̱cúhui̱lh xtucuhuiní, chu̱ chuná̱ huánilh: —Zaqueo, lacapala̱ cata̱cta, sa̱mpi̱ luhua xlacasquinca̱ pi̱ chiyú̱ antá̱ naclaktuncuhuiy c-mínchic. ");
INSERT INTO tosNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Cha̱nchu̱ xlá̱ lacapala̱ tá̱ctalh, chu̱ luhua cha̱pa̱xuhua̱na̱ tá̱alh Jesús c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Makapitzi̱n chixcuhuí̱n, acxni̱ ucxilhko̱lh tzucuko̱lh aksanko̱y Jesús, chu̱ chuná̱ xuanko̱y: “Ani̱t lakapaxia̱lhnán yama̱ li̱xcajnit chixcú̱ hua̱nti̱ ni̱ ma̱kantaxti̱ma̱ xli̱ma̱paksí̱n Moisés c-xlatáma̱t.” ");
INSERT INTO tosNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","A̱li̱sta̱lh c-xchic acxni̱ xua̱ya̱ma̱kó̱, Zaqueo tá̱yalh, chu̱ chuná̱ huánilh Jesús: —Quimpu̱chiná, hua̱nti̱ lakli̱ma̱xkaní̱n, íta̱t nacma̱pa̱pitziniko̱y quimakaaná̱nat; chu̱ lapi̱ huí̱ ti̱ ca̱ta catu̱huá̱ cakskahuimaklhti̱ni̱t, pus la̱nchú̱ a̱acta̱ti nacli̱pu̱xokoniy. ");
INSERT INTO tosNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Cha̱nchu̱ Jesús huánilh: —Chú̱ u̱nú̱ c-chiqui chini̱t akapu̱táxtut, sa̱mpi̱ yuma̱ chixcú caj xpa̱lacata tu̱ ma̱lacnu̱ni̱t tlahuay li̱tasiyuy pi̱ xlá̱ na̱ luhua mini̱niy tapaksi̱niko̱y judíos ti̱ luhua xaxli̱ca̱na̱ li̱tapa̱cuhui̱ko̱y xquilhtzucut Abraham. ");
INSERT INTO tosNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sa̱mpi̱ quit, Xatalacsacni Chixcú, cmini̱t putzay, chu̱ cmini̱t ma̱akapu̱taxti̱ko̱y hua̱nti̱ aya xaktzanka̱ta̱yako̱ni̱t la̱ yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pus aya xtalacatzuhui̱ma̱ c-xaca̱chiqui̱n Jerusalén, chu̱ tachixcuhuí̱tat xpuhuanko̱y pi̱ ma̱x ni̱ li̱maka̱s xlá̱ antá̱ nama̱lacatzuqui̱y xasa̱sti xtapaksi̱t Dios tu̱ xlá̱ ankalhí̱n xli̱xakatli̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pus chí̱ tihua̱: “Cha̱tum chixcú̱ ti̱ luhua xkalhi̱y xca̱cni, tialh c-aktum tíyat luhuata mákat, laqui̱mpi̱ naán kalhi̱y aktum li̱ma̱peksí̱n, na̱ namimpalay. ");
INSERT INTO tosNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Acxni̱ aya xamajá̱, tasaniko̱lh kalhaca̱hu cscujní̱n, chu̱ cha̱tunu̱ ma̱xqui̱ko̱lh lhu̱hua tumi̱n laqui̱mpi̱ xlacán nama̱scujuko̱y, chu̱ chuná̱ huaniko̱lh: ‘Cali̱scújtit yuma̱ quintumi̱n, chu̱ cama̱skatí̱tit hasta acxni̱ quit nacmimpalay.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Hua̱mpi̱ lhu̱hua chixcuhuí̱n hua̱nti̱ xnata̱chiquí̱n, ni̱ xucxilhputunko̱y, luhua csi̱tzi̱niko̱y. Acxni̱ xlá̱ alh na̱ pu̱tum anko̱lh yama̱ ca̱chiquí̱n anta̱ni̱ xtapaksi̱y xtiyatcán laqui̱mpi̱ nahuanko̱y: ‘Ni̱ clacasquina̱hu huá̱ nalakchá̱n li̱gobierno laqui̱mpi̱ naquinca̱ma̱paksi̱yá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Hua̱mpi̱ xlá̱ ni̱tú̱ li̱makatlajaca̱, chu̱ huá̱ juerza lákcha̱lh li̱gobierno; chu̱ ni̱ li̱maka̱s xlá̱ táspitli̱ c-xca̱chiquí̱n. Chu̱ acxni̱ xlá̱ chilh ma̱tasani̱nanko̱lh yama̱ cscujní̱n hua̱nti̱ xma̱xqui̱ko̱ni̱t xtumi̱n laqui̱mpi̱ xlá̱ nacatzi̱y ni̱ntla̱ xma̱tlaji̱ko̱ni̱t la̱ntla̱ cha̱tunu. ");
INSERT INTO tosNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hua̱nti̱ xakasiya̱ chilh ti̱tum lákcha̱lh, chu̱ chuná̱ huánilh: ‘Tla̱ti, yama̱ mintumi̱n hua̱ntu̱ quintima̱xqui, la̱nchú̱ ma̱x makca̱hu a̱chuná̱ la̱ntla̱ cma̱skati̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Yama̱ gobierno chuná̱ huánilh: ‘Li̱huacá̱ tla̱n, huix luhua xli̱ca̱na̱ tla̱n scujni; pus hua̱ chú̱ pi̱ luhua tla̱n cui̱ntaj tlahua̱ hua̱ntu̱ ni̱ luhua lhu̱hua, pus la̱nchú̱ quit nacuili̱yá̱n ligobernador laqui̱mpi̱ nama̱paksi̱ko̱ya̱ akca̱hu ca̱chiquí̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na̱ mimpá̱ xli̱cha̱tuy cscujni, chu̱ chuná̱ huánilh: ‘Tla̱ti, mintumi̱n hua̱ntu̱ quintima̱xqui, makquitzis a̱chuná̱ cma̱skati̱ni̱t.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Yama̱ gobierno chuná̱ huánilh: ‘Pus huix na̱ nacuili̱yá̱n li̱gobernador nama̱paksi̱ko̱ya̱ akquitzis ca̱chiquí̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mimpá̱ a̱cha̱tum, chu̱ chuná̱ huánilh: ‘Tla̱ti, u̱huí̱ chú̱ mintumi̱n hua̱ntu̱ quintima̱xqui. Quit ni̱tú̱ cma̱scujuni̱t, huata caj cmá̱qui̱lh laqui̱mpi̱ ni̱ natzanka̱y, c-quiaktlápat li̱huana̱ xacchi̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pus quit cpe̱cuanín sa̱mpi̱ ccatzi̱y pi̱ huix scalajua̱ mintá̱yat, chu̱ ccatzi̱y la̱ntla̱ akchipako̱ya̱ hua̱ntu̱ ni̱ milá, chu̱ c-xka̱nana̱ anta̱ni̱ huix ni̱tú̱ chana̱nani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yama̱ gobierno chuná̱ huánilh: ‘Huix luhua xli̱ca̱na̱ ni̱tla̱n scujni, caj tuncán mintachihuí̱n miacstu li̱talacapu̱ya, pus pala xli̱ca̱na̱ xcatzi̱ya̱ pi̱ quit luhua scalajua̱ quintá̱yat, chu̱ pala xcatzi̱ya̱ pi̱ cakchipay hua̱ntu̱ ni̱ quilá, chu̱ na̱ cxka̱nán anta̱ni̱ quit ni̱tú̱ chana̱nani̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿tú̱huan chá̱ ni̱ huata xatlá̱n pit li̱huili̱ya̱ quintumi̱n c-banco laqui̱mpi̱ acxni̱ quit xactímilh xquintiakxokonica̱ acxni̱ xactíalh tiyay?’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Yama̱ gobierno chuná̱ huaniko̱lh hua̱nti̱ antá̱ xlaya̱kó̱: ‘Lacapala̱ camaklhtí̱tit tumi̱n, chu̱ huata hua̱ cama̱xquí̱tit hua̱nti̱ kalhi̱y okxca̱hu.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Xlacán chuná̱ huaniko̱lh: ‘Tla̱ti, hua̱mpi̱ xlá̱ aya kalhi̱y okxca̱hu tumi̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yama̱ gobierno chuná̱ kalhtí̱nalh: ‘Pus xli̱ca̱na̱ cca̱huaniyá̱n pi̱ hua̱nti̱ lhu̱hua̱ kalhi̱y hua̱ntu̱ maclacasquín, a̱tzinú̱ li̱huacá̱ nama̱xqui̱cán, hua̱mpi̱ hua̱nti̱ ni̱ lhu̱hua̱ kalhi̱y hua̱ntu̱ maclacasquín namaklhti̱ko̱cán hasta ma̱squi ni̱ lhu̱hua̱ hua̱ntu̱ xlá̱ kalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Xa̱huachí̱ yama̱ chixcuhuí̱n hua̱nti̱ quisi̱tzi̱niko̱y hua̱nti̱ ni̱ xlacasquinko̱y quit nactahuilay li̱gobierno, lacapala̱ cali̱tankó̱tit, chu̱ antá̱ u̱nú̱ c-quilacatí̱n camakni̱kó̱tit.’” ");
INSERT INTO tosNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Acxni̱ chuná̱ huanko̱lh yuma̱ tachihuí̱n, Jesús ta̱yapá̱ c-tiji̱ laqui̱mpi̱ ti̱tum nachá̱n c-xaca̱chiqui̱n Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Acxni̱ aya xtalacatzuhui̱ko̱ni̱t yama̱ aktuy lactzu̱ ca̱chiquí̱n huaniko̱cán Betfagé, chu̱ Betania, lacatzú̱ yama̱ c-ka̱stí̱n hua̱ntu̱ xuanicán monte de los Olivos, xlá̱ ma̱lakacha̱ko̱lh cha̱tuy xli̱ma̱kalhtahuáka̱t, ");
INSERT INTO tosNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","chu̱ chuná̱ huaniko̱lh: —Capítit c-actzu̱ ca̱chiquí̱n anta̱ni̱ calacán huí̱; chu̱ acxni̱ antá̱ nachipiná̱tit naucxilhá̱tit tantum a̱xnu̱, xlá̱ antá̱ chi̱ya̱huacani̱t, chu̱ ni̱ pala cha̱tum chixcú̱ a̱ka̱tahuilay. Huixín naxcutá̱tit, chu̱ nali̱taná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Na̱ palapi̱ huí̱ ti̱ naca̱kalhasquiná̱n: ‘¿Tú̱ li̱layá̱tit xcutá̱tit?’, huixín cahuanikó̱tit pi̱ hua̱ Mimpu̱chinacán maclacasquimputún. ");
INSERT INTO tosNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yama̱ xli̱ma̱kalhtahuáka̱t anko̱lh, chu̱ xli̱ca̱na̱ chuná̱ ma̱noklhuko̱lh hua̱ la̱ntla̱ Jesús xuaniko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Acxni̱ luhua xcutma̱kó̱ yama̱ actzu̱ a̱xnu̱, taxtuchi̱ hua̱nti̱ xpu̱chiná, chu̱ chuná̱ kalhasquinko̱lh: —¿Tú̱huan li̱xcutpá̱tit tama̱ quia̱xnu̱? ");
INSERT INTO tosNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Kalhti̱nanko̱lh xlacán: —Sa̱mpi̱ Quimpu̱chinacán maclacasquimputún. ");
INSERT INTO tosNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Puschí̱ yama̱ xpu̱china a̱xnu̱, nia̱lh tú̱ huaniko̱lh, chu̱ xlacán le̱niko̱lh anta̱ni̱ xuilachá̱ Jesús, tali̱ka̱tlápalh clhaka̱tcán, chu̱ ka̱huili̱ko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Acxni̱ tzucuko̱lh takalhaju̱nanko̱y yama̱ ka̱stí̱n huanicán monte de los Olivos lhu̱hua̱ tachixcuhuí̱tat hua̱nti̱ cstonkmi̱ma̱kó̱ clhaka̱tcán c-tiji̱ laqui̱mpi̱ antá̱ nalactla̱huán Jesús, chu̱ xli̱pacs hua̱nti̱ xca̱najlaniko̱ni̱t Jesús tzucuko̱lh pa̱xcatcatzi̱niko̱y Dios caj xpa̱lacata lactlanca li̱ca̱cni xtatlahu hua̱ntu̱ xlacán xucxilhko̱ni̱t, chu̱ xlacán tzucuko̱lh tli̱niko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Chuná̱ xuanko̱y: —¡Tla̱n caqui̱taxtúnilh yuma̱ tlanca Quireycán hua̱nti̱ la̱nchú̱ quinca̱macaminini̱tán Quimpu̱chinacan! Caánalh tapa̱xuhuá̱n c-akapú̱n, chu̱ xli̱pacs caca̱cni̱nanica̱ Dios hua̱nti̱ huí̱ ta̱lhmá̱n c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Makapitzi̱n fariseos hua̱nti̱ na̱ antá̱ xmaksta̱lama̱kó̱ c-xlaksti̱pa̱ncan tachixcuhuí̱tat, chuná̱ tzúculh huaniko̱y Jesús: —Ma̱kalhtahuaka̱ná, catlahua̱ li̱tlá̱n, cahuanikó̱ mili̱ma̱kalhtahuáka̱t pi̱ nia̱lh chuná̱ cahuanko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Xlá̱ chuná̱ kalhti̱ko̱lh: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lapi̱ xkatxtakko̱lh xlacán, pus yuma̱ chíhuix hua̱ntu̱ ma̱kó̱ c-xpa̱xtu̱n tiji̱ xtzucuko̱lh ca̱tasako̱y xpu̱xokocán. ");
INSERT INTO tosNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Cha̱nchu̱ cha̱lh Jesús anta̱ni̱ tancs laklacacha̱ncán c-Jerusalén, acxni̱ úcxilhli̱ yama̱ tlanca ca̱chiquí̱n luhua li̱puhua̱, chu̱ tzúculh tasay. ");
INSERT INTO tosNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","La̱ntla̱ xtasáma̱ chuná̱ huá̱: “¡Koxutaní̱n huixín hua̱nti̱ huilapítit antá̱ c-Jerusalén! ¡La̱pi̱ akata̱ksá̱tit cahuá̱ ca̱na̱ caj xma̱n hua̱ la̱nchú̱ yuma̱ quilhtamacú̱ pi̱ ca̱lakchini̱tán hua̱ntu̱ xli̱ca̱na̱ xca̱ma̱xquí̱n yama̱ xacacsua latáma̱t hua̱ntu̱ Dios ca̱ma̱xqui̱putuná̱n! Hua̱mpi̱ cumu huixín ni̱ ucxilhputuná̱tit hua̱ntu̱ Dios ca̱ma̱ucxilhni̱putuná̱n, nia̱lh ucxni̱ catiucxílhtit. ");
INSERT INTO tosNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sa̱mpi̱ naca̱lakcha̱ná̱n quilhtamacú̱ hua̱ acxni̱ huixín li̱pe̱cua̱ la̱ntla̱ naca̱ma̱pa̱ti̱ni̱caná̱tit caj luhua mimpa̱lacatacán, sa̱mpi̱ ni̱ maka̱s hua̱nti̱ luhua ca̱si̱tzi̱niko̱yá̱n cani̱huá̱ nataxtuko̱ya̱chi, chu̱ naca̱makstilihuili̱ko̱yá̱n laqui̱mpi̱ ni̱tí̱ natza̱lay, ");
INSERT INTO tosNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","chu̱ maktum naca̱ma̱sputuko̱yá̱n pacs huixín hua̱nti̱ huilátit c-Jerusalén. Na̱ ca̱tu̱tzú̱ nama̱laca̱ni̱ko̱y xapa̱tzaps minchiccán, chu̱ ni̱ pala aktum chíhuix catitamakáxtakli̱ anta̱ni̱ xuili̱ko̱cani̱t hua̱ntu̱ xli̱tlahuako̱cani̱t chiqui. Hua̱mpi̱ ma̱squi chuná, pacs huixín li̱piná̱tit cuenta̱, sa̱mpi̱ ni̱ akata̱ksputuná̱tit pi̱ Dios ca̱macaminini̱tán la̱nchú̱ hua̱nti̱ naca̱lakma̱xtuko̱yá̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Acxni̱ luhua cha̱lh Jesús c-Jerusalén, tanu̱chá̱ c-xali̱pacan tlanca templo, chu̱ cha̱lh lacatum anta̱ni̱ xuilakó̱ hua̱nti̱ csta̱nama̱kó̱. Xlá̱ tlakaxtuko̱lh yama̱ hua̱nti̱ antá̱ csta̱nama̱kó̱, chu̱ xtama̱huanama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Chuná̱ huaniko̱lh: —Nac Xasa̱ntujlani Li̱kalhtahuaka anta̱ni̱ tatzokni̱t xtachihui̱n Dios chuná̱ na̱má̱ huan: ‘Hua̱ quínchic, caj xma̱n huá̱ luhua nali̱ma̱xtucán laqui̱mpi̱ antá̱ tla̱n naminko̱y quintlahuaniko̱y oración xli̱pacs tachixcuhuí̱tat cani̱hua̱ xalaní̱n’, hua̱mpi̱ chi̱nchu̱ huixín aya li̱ma̱xtuni̱tántit xta̱chuná̱ la̱ xpu̱tatze̱knican kalha̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A̱li̱sta̱lh Jesús cha̱li̱ cha̱lí̱ xmin xakatli̱ko̱y tachixcuhuí̱tat c-tlanca templo; hua̱mpi̱ xanapuxcun pa̱lijni, chu̱ laktzokni̱naní̱n, chu̱ na̱ xa̱hua̱ hua̱nti̱ xanapuxcun judíos, xlacán aya xputzama̱kó̱ la̱ntla̱ natlahuako̱y laqui̱mpi̱ tla̱n namakni̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Hua̱mpi̱ ma̱squi chuná, xlacán ni̱ lay xma̱tla̱ni̱ko̱y la̱ntla̱ natlahuako̱y sa̱mpi̱ lhu̱hua tachixcuhuí̱tat cacs xkaxmatniko̱y, chu̱ luhua xlakati̱ko̱y hua̱ntu̱ xlá̱ xli̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maktum Jesús xli̱akchihui̱nanima̱kó̱ tachixcuhuí̱tat li̱pa̱xuhu xtama̱lacnu̱n Dios la̱ntla̱ ma̱akapu̱taxti̱putunko̱y hua̱nti̱ nali̱pa̱huanko̱y, na̱ acxni̱ chinko̱lh xanapuxcun pa̱lijni, chu̱ laktzokni̱naní̱n, xa̱hua̱ lakko̱lun ma̱paksi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xlacán chuná̱ kalhasquinko̱lh: —Catlahua̱ li̱tlá̱n, caquinca̱huani̱ xatú̱ xpa̱lacata huix u̱nú̱ li̱tanu̱ni̱tanchita̱ c-templo, chu̱ tlakaxtuko̱ni̱ta̱ hua̱nti̱ sta̱nanko̱y. ¿Tú̱ ya̱ li̱ma̱paksí̱n huix kalhi̱ya? Usuchí̱ ¿tí̱ ma̱xqui̱ni̱tán tama̱ li̱ma̱paksí̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús chuná̱ kalhti̱ko̱lh: —Tla̱n nacca̱huaniyá̱n, hua̱mpi̱ pu̱laná̱ na̱ huí̱ hua̱ntu̱ cca̱kalhasquimputuná̱n, chu̱ huixín caquihuanítit: ");
INSERT INTO tosNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tí̱ má̱xqui̱lh li̱ma̱paksí̱n Juan Bautista pi̱ tla̱n naakmunu̱nán? ¿Pi̱ hua̱ Dios, usuchí̱ huí̱ cha̱tum chixcú̱ ti̱ má̱xqui̱lh? ");
INSERT INTO tosNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xlacán ni̱ naj tuncán kalhti̱nanko̱lh, huata caj xacstucán tzucuko̱lh la̱li̱ta̱kalhchihui̱nanko̱y, xla̱kalhasquinko̱y, chu̱ xla̱huaniko̱y: “Lapi̱ nahuaniya̱hu pi̱ hua̱ Dios macámilh, xlá̱ naquinca̱huaniyá̱n: ‘¿Tú̱huan chá̱ ni̱ tica̱najlanítit?’ ");
INSERT INTO tosNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chí̱ lapi̱ nahuaniya̱hu pi̱ hua̱ chixcuhuí̱n xli̱ma̱paksi̱ko̱ni̱t, xlacán ma̱x naquinca̱actalamakni̱putunko̱yá̱n, sa̱mpi̱ xlacán catzi̱ko̱y pi̱ Juan Bautista huá̱ xli̱akchihui̱nantla̱huán hua̱ntu̱ xaxli̱ca̱na̱ xtalacapa̱stacni Dios.” ");
INSERT INTO tosNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hua̱mpi̱ huata xatlá̱n xlacán kalhti̱nanko̱lh pi̱ ni̱ xcatzi̱ko̱y xatí̱ xli̱ma̱paksi̱ni̱t Juan pi̱ naakmunu̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús na̱ chuná̱ huaniko̱lh: —Pus lapi̱ huixín ni̱ catzi̱yá̱tit hua̱ntu̱ cca̱kalhasquimá̱n, na̱ ni̱ pala quit cactica̱huanín xatí̱ quima̱xqui̱ni̱t li̱ma̱paksí̱n caj xpa̱lacata hua̱ntu̱ quit ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A̱li̱sta̱lh Jesús tzucupaj ta̱kalhchihui̱nanko̱y tachixcuhuí̱tat, chu̱ ca̱li̱xakatli̱ko̱lh yuma̱ takalhchihuí̱n: “Maktum xuí̱ cha̱tum chixcú̱ hua̱nti̱ chalh c-xpú̱cuxtu̱ lhu̱hua xali̱chanat uvas, chu̱ a̱li̱sta̱lh xlá̱ a medias rentajma̱xqui̱ko̱lh makapitzí̱n cscujní̱n, sa̱mpi̱ xlá̱ álh latama̱y mákat ca̱lacatanu̱ ca̱chiquí̱n, chu̱ luhua maka̱s antá̱ xlama̱chá. ");
INSERT INTO tosNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Acxni̱ lákcha̱lh quilhtamacú̱ la̱ntla̱ta tzucuy cha̱ko̱y uvas, a̱ma̱ pu̱chiná̱ máca̱lh cha̱tum cscujni̱ laqui̱mpi̱ naancán squiniko̱cán ti̱ xli̱scujma̱kó̱ ca̱uvasna̱ hua̱ntu̱ xlá̱ xlakchá̱n nachipay xatachitni uvas. Hua̱mpi̱ xlacán huata caj chipako̱lh, chu̱ tla̱n huili̱niko̱lh, caj chunatá̱ maca̱nko̱lh, chu̱ ni̱tú̱ ma̱le̱ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chu̱ hua̱nti̱ xpu̱china yama̱ tachaná̱n maca̱mpá̱ a̱cha̱tum li̱tum cscujni; xlá̱ na̱ chuná̱ tlahuako̱lh, cala̱huá̱ huaniko̱lh, chu̱ na̱ huili̱niko̱lh, chu̱ ni̱tú̱ ma̱le̱ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pus yama̱ chixcú juerza maca̱mpá̱ xli̱kalhatutu cscujni, hua̱mpi̱ a̱ma̱ ni̱tla̱n chixcuhuí̱n hua̱nti̱ antá̱ cscujma̱kó̱ yama̱ c-xpú̱cuxtu, snu̱n ma̱sipa̱ni̱ko̱lh, lhkan tamacaxtuko̱lh, chu̱ ni̱tú̱ ma̱xqui̱ko̱lh hua̱ntu̱ xlakmini̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Chu̱ hua̱nti̱ xpu̱chiná̱ yama̱ tachaná̱n xlá̱ chuná̱ lacpuhua̱: ‘¿Tú̱ chú̱ nactlahuay? Huata xatlá̱n nacmacá̱n quinkahuasa̱ hua̱nti̱ luhua cpa̱xqui̱y, chá̱ pala acxni̱ xlacán naucxilhko̱y ma̱x tzinú̱ nalacapuhuaniko̱y, chu̱ nakalhakaxmatko̱y hua̱ntu̱ nahuaniko̱y.’ ");
INSERT INTO tosNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pus ma̱lakacha̱chá̱ xkahuasa, hua̱mpi̱ yama̱ xmaktakalhnani̱n ca̱uvasna̱ acxni̱ ucxilhko̱lh, chuná̱ tzúculh la̱huaniko̱y: ‘Hua̱ yumá̱ xkahuasa̱ hua̱nti̱ xpu̱chiná yuma̱ tachaná̱n, pus huá̱ naakata̱xtunicán xli̱pacs hua̱ntu̱ quin la̱nchú̱ li̱scujma̱hu, huata tu̱ natlahuaya̱hu camakni̱hu laqui̱mpi̱ pacs quin naquinca̱tamakaxtakniyá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pus chuná̱ tlahuako̱lh, tamacaxtuko̱lh c-xquilhapa̱n pú̱cuxtu, chu̱ antá̱ makni̱ko̱lh.” Jesús chuná̱ kalhasquinko̱lh hua̱nti̱ xkaxmatma̱kó̱: —¿Tú̱ chú̱ huixín puhuaná̱tit natlahuaniko̱y xpu̱china pú̱cuxtu̱ a̱ma̱ hua̱nti̱ ni̱tla̱n xtapuhua̱ncan scujní̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pus luhua xli̱ca̱na̱ pi̱ namín, chu̱ namakni̱ko̱y pacs yama̱ hua̱nti̱ ni̱ lacuan scujní̱n, chu̱ huata huá̱ namacama̱xqui̱ko̱y xpú̱cuxtu̱ a̱makapitzi̱n cscujní̱n hua̱nti̱ aksti̱tum scujko̱y. Makapitzí̱n hua̱nti̱ xakata̱ksma̱kó̱ hua̱ntu̱ luhua xuaniputún xtakalhchihuí̱n, acxni̱ kaxmatko̱lh chuná̱ tzúculh huaniko̱y: —¡Ni̱ calacásquilh Dios pala chuná̱ naqui̱taxtuy! ");
INSERT INTO tosNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesús cacs lacaucxilhko̱lh, chu̱ chuná̱ huaniko̱lh: —Pus cumu pala huixín ni̱ ca̱najlayá̱tit pi̱ chuná̱ naqui̱taxtuy, caquihuanítit: ¿Tú̱ chá̱ chí̱ huaniputún c-xasa̱ntujlani Li̱kalhtahuaka? Sa̱mpi̱ lacatum anta̱ni̱ tatzokni̱t chuná̱ huan: ‘Yama̱ chíhuix hua̱ntu̱ tzapsnaní̱n lakmakanko̱lh, tipuhuanko̱lh pi̱ ni̱tu̱ xlakasi, a̱li̱sta̱lh huata huá̱ a̱tzinú̱ luhua kálhi̱lh xlakasi sa̱mpi̱ antá̱ li̱tzinca̱snanko̱ni̱t la̱ntla̱ xli̱tlanca chiqui.’ ");
INSERT INTO tosNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Caxati̱cahuá̱ hua̱nti̱ xtamákuasli, xtahuacachá̱ c-xokspun yuma̱ chíhuix, lactzu̱ lactzu̱ nahuán; hua̱mpi̱ hua̱ caxati̱cahuá̱ ti̱ xactahui̱ chíhuix, xta̱chuná̱ pokxni natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yama̱ xanapuxcun pa̱lijni, chu̱ laktzokni̱naní̱n xchi̱le̱mputunko̱y Jesús pi̱ xakata̱ksko̱ni̱t pi̱ caj huá̱ xpalacatacán ma̱squi chuná̱ xlá̱ xli̱xakatli̱ko̱ni̱t yama̱ takalhchihuí̱n. Hua̱mpi̱ ni̱tú̱ tlahuanipalako̱lh chú̱, sa̱mpi̱ xpe̱cuaniko̱y la̱ntla̱ xli̱lhu̱hua̱ tachixcuhuí̱tat, chicá̱ xamaktum nalaksi̱tzi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Cumu xlacán ni̱ xma̱tla̱ni̱ko̱ni̱t, pus maca̱nko̱lh makapitzi̱n chixcuhuí̱n hua̱nti̱ luhua lacuan chixcuhuí̱n xli̱taxtuputunko̱y laqui̱mpi̱ nakalhputza̱naniko̱y, chu̱ pala tú̱ ni̱ tancs nakalhti̱nán, chuná̱ chú̱ nakalhi̱ko̱y tu̱ nali̱sta̱huako̱y c-xlacati̱n gobernador romano. ");
INSERT INTO tosNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Acxni̱ lakcha̱nko̱lh, chuná̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, quin ccatzi̱ya̱hu pi̱ huix ma̱siyuya̱ hua̱ntu̱ luhua xli̱ca̱na̱ aksti̱tum talacapa̱stacni, chu̱ ni̱ pala tzinú̱ li̱aklhu̱hua̱tnana̱ ma̱squi lhu̱hua̱ hua̱nti̱ ni̱ li̱ucxilhputunko̱yá̱n, huata huix lacasquina̱ xli̱pacs tachixcuhuí̱tat nalakapasko̱y la̱ntla̱ Dios lacasquín nalatama̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pus clacasquina̱hu la̱nchú̱ xquinca̱huani, ¿pi̱ tla̱n cahuá̱ la̱ntla̱ clakaxoko̱nanima̱hu xapuxcu ma̱paksi̱na romano, usuchí̱ ni̱tlá̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús cátzi̱lh pi̱ caj chunatá̱ xli̱kalhputzama̱kó̱, chu̱ chuná̱ huaniko̱lh: —¿Xatú̱ xpa̱lacata huatiyá̱ chuná quili̱kalhputzayá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Caquima̱siyunítit okxtum tumi̱n. ¿Xatí̱ xlacapú̱n kalhi̱y yuma̱ tumi̱n? Chu̱ ¿xatí̱ xtucuhuiní̱ yuma̱ hua̱ntu̱ talhca̱ni̱t c-tumi̱n? Xlacán chuná̱ kalhti̱nanko̱lh: —Hua̱ tama̱ xlacapu̱n tlanca ma̱paksi̱na gobierno romano. ");
INSERT INTO tosNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús huanipalako̱lh: —Pus huata huá̱ camacama̱xquí̱tit gobierno hua̱ntu̱ ma̱paksi̱y gobierno; chu̱ na̱ chuna li̱tum huá̱ camacama̱xquí̱tit Dios hua̱ntu̱ lakchá̱n namacama̱xqui̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yama̱ chixcuhuí̱n cacs lacahuanko̱lh, chu̱ ni̱alh lalh catu̱huá̱ tu̱ kalhasquinko̱lh, sa̱mpi̱ pacs hua̱ntu̱ xlá̱ xkalhasquincán Jesús, luhua tancs hua̱ntu̱ xkalhti̱nán. Chu̱ la̱ntla̱ xli̱lhu̱hua tachixcuhuí̱tat caj xli̱pa̱xuhuako̱y hua̱ntu̱ xlá̱ xli̱xakatli̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A̱li̱sta̱lh lakchinko̱lh anta̱ni̱ xlaya̱ Jesús makapitzi̱n chixcuhuí̱n hua̱nti̱ xuaniko̱cán laktzokni̱naní̱n (xlacán ni̱ xca̱najlako̱y pala xli̱ca̱na̱ lakastakuananko̱y ni̱ní̱n ca̱li̱ní̱n), chu̱ chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ma̱kalhtahuaka̱ná, hua̱ Moisés, quinca̱makaxtaknini̱tán c-xli̱ma̱paksí̱n pi̱ lapi̱ cha̱tum chixcú̱ nani̱y naakxtakmakán xpusca̱t, chu̱ lapi̱ ni̱tú̱ kalhi̱ko̱lh xcamancán, pus pala huí̱ chú̱ xta̱la kahuasa yama̱ chixcú, xlá̱ tla̱n nata̱tahuilay xya̱stá puhuani̱ni̱ pusca̱t, laqui̱mpi̱ chuná̱ niucxni̱ nalaksputa̱ xtucuhuiní̱ xta̱lá hua̱ntu̱ aya ni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pus maktum xuilakó̱ kalhatujun lakkahuasán, pacs li̱nata̱lán. Cha̱nchu̱ hua̱nti̱ xapuxcu, tapu̱chúhualh, hua̱mpi̱ ni̱ li̱maka̱s ni̱lh, chu̱ akxtakmákalh xpusca̱t, chu̱ ni̱ pala cha̱tum kalhi̱ko̱lh xcamancán. ");
INSERT INTO tosNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hua̱nti̱ xli̱cha̱tuy xta̱lá̱ ta̱tahuílalh xya̱stá, na̱ ni̱ maka̱s li̱tum xlá̱ na̱ ni̱pá̱, chu̱ na̱ ni̱ pala huá̱ ta̱kálhi̱lh xcamancán. ");
INSERT INTO tosNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Xli̱kalhatutu xta̱lá̱ na̱ chuná̱ ta̱tahuílalh xya̱stá, chu̱ la̱ntla̱ xa̱makapitzí̱n, pacs chuná̱ tlahuako̱lh, chu̱ pacs ni̱ko̱lh xkalhatujuncán, chu̱ ni̱ pala cha̱tum ti̱ luhua ta̱kálhi̱lh xcamancán. ");
INSERT INTO tosNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chu̱ ni̱ li̱maka̱s yama̱ pusca̱t, na̱ ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pus chi̱nchu̱ acxni̱ nalakastakuananko̱y ni̱ní̱n ca̱li̱ní̱n, ¿xatí̱ cahuá̱ luhua xpusca̱t nahuán, pus pacs xkalhatujuncán xpusca̱tcán xtlahuako̱ni̱t yama̱ pusca̱t? ");
INSERT INTO tosNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús chuná̱ kalhti̱ko̱lh: —Huixín catzi̱yá̱tit pi̱ u̱nú̱ ca̱tuxá̱huat, chixcuhuí̱n, chu̱ lacchaján tapu̱chuhuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Hua̱mpi̱ chú̱ hua̱nti̱ Dios lacsacko̱ni̱t laqui̱mpi̱ nakalhi̱ko̱y a̱ma̱ xasa̱sti latáma̱t hua̱ntu̱ niucxni̱ nasputa, acxni̱ nalakastakuananko̱y ca̱li̱ní̱n, xlacán nia̱lh catitapu̱chuhuako̱lh, chu̱ ni̱ pala catiánalh tapu̱chúhuat. ");
INSERT INTO tosNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Huata xlacán nalatama̱ko̱y caxani̱li̱huaya̱ xta̱chunata la̱ntla̱ ángeles, sa̱mpi̱ xli̱ca̱na̱ hua̱ xcaman Dios nahuanko̱y pi̱ huá̱ nama̱lakastakuani̱ko̱y ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Hua̱ chú̱ caj xpa̱lacata̱ pala nalakastakuananko̱y ni̱ní̱n, pus luhua calacapa̱stáctit pi̱ hasta hua̱ Moisés ma̱lúlokli̱ acxni̱ xlá̱ tzokli̱ la̱ ta̱chihuí̱nalh Dios anta̱ni̱ xakxkota̱yama̱ pu̱kalhtum huátzapu, sa̱mpi̱ xlá̱ li̱chihuí̱nalh Dios pi̱ huá̱ xDios Abraham, xa̱hua̱ xla Isaac, chu̱ xla Jacob, chu̱ xli̱pacs a̱makapitzí̱n hua̱nti̱ ni̱ko̱ni̱ttá. ");
INSERT INTO tosNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pus antá̱ huaniputún pi̱ Dios li̱ma̱xtuko̱y yama̱ chixcuhuí̱n xta̱chuná̱ la̱ntla̱ xastacná̱ xlama̱kó̱ ma̱squi aya xni̱ko̱ni̱ttá; pus caj hua̱ntu̱ xlá̱ xpa̱lacata, ni̱tú̱ lama̱ pala ni̱ pacs xastacná. ");
INSERT INTO tosNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cha̱nchu̱ cha̱tum saduceo chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, luhua lacatancs hua̱ntu̱ huix quilhuámpa̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pus nia̱lh pala tí̱ tlahuánilh takalhputzá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Xli̱makua antá̱ xlayakó̱ pacs yama̱ tachixcuhuí̱tat, Jesús kalhasquinko̱lh: —¿Pa̱ kalhi̱ko̱y talulóktat tu̱ huanko̱y mima̱kalhtahuaka̱nacán acxni̱ huanko̱y pi̱ Cristo hua̱nti̱ naminá̱n ca̱lakma̱xtuyá̱n, mat huá̱ xquilhtzúcut nahuán xamaka̱n rey David? ");
INSERT INTO tosNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sa̱mpi̱ maktum, huatiya David chuná̱ na̱má̱ títzokli̱ c-Salmos xpa̱lacata Cristo: ‘Quimpu̱china Dios chuná̱ huánilh cha̱tum li̱tum ti̱ na̱ Quimpu̱chiná: Catahuila̱ c-quimpa̱xtú̱n laqui̱mpi̱ naquinta̱ma̱paksi̱nana, ");
INSERT INTO tosNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta acxni̱ nactimakatlajako̱y xli̱pacs hua̱nti̱ si̱tzi̱niko̱yá̱n laqui̱mpi̱ li̱macxtum nalakachixcuhui̱ko̱yá̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Pus la̱ntla̱ chú̱ tla̱n napuhuaná̱tit pi̱ hua̱nti̱ namín Cristo, xquilhtzúcut nahuán rey David acxni̱ huatiya̱ David xca̱cni̱naniy, xli̱ma̱pa̱cuhui̱y Quimpu̱chiná? ");
INSERT INTO tosNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Cha̱nchu̱ xkaxmatnima̱kó̱ tachixcuhuí̱tat, chuná̱ huaniko̱lh xli̱ma̱kalhtahuáke̱t: ");
INSERT INTO tosNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Luhua cui̱ntaj catlahuátit ni̱ chuná̱ huixín natzaksayá̱tit la̱ li̱catzi̱ko̱y laktzokni̱naní̱n. Xlacán luhua lakati̱ko̱y lhaka̱ko̱y cha̱lhma̱n clhaka̱tcán, chu̱ na̱ lacasquinko̱y pi̱ luhua naca̱cni̱nanicán c-tlanca̱ti̱ acxni̱ xakatli̱pa̱xtokko̱cán. Na̱ acxni̱ anko̱y c-mimpu̱kalhtahuakacán tzucuko̱y lacsacko̱y xalacuan pu̱táhui̱lh, chu̱ hua̱ntu̱ calacán huilakó̱, na̱ lacasquinko̱y pi̱ pu̱lh huá̱ nama̱hui̱ko̱cán c-pu̱makca̱tani. ");
INSERT INTO tosNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chu̱ hua̱nti̱ ni̱makanko̱cani̱t lacchaján akskahuimaklhti̱ko̱y xchiccán, chu̱ laqui̱mpi̱ ni̱tí̱ mat nacatzi̱y la̱ntla̱ xta̱yatcán, caj maclhca̱tlahuako̱y laclhma̱n xoracioncán. Hua̱mpi̱ ni̱ pala tzinú̱ catzi̱ko̱y pi̱ hua̱ xlacán ti̱ tlak li̱huacá̱ nali̱pa̱ti̱ko̱y xta̱kastacya̱huan Dios.” ");
INSERT INTO tosNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Maktum acxni̱ Jesús xucxilhma̱ la̱ntla̱ ma̱tamacu̱naní̱n xmuju̱ma̱kó̱ luhua lhu̱hua̱tna xtumi̱ncán anta̱ni̱ huilakó̱ xpu̱muju̱can ofrenda c-tlanca templo c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Caj li̱puntzú̱ na̱ chilh cha̱tum li̱ma̱xkan puhuani̱ni̱ pusca̱t, xlá̱ na̱ múju̱lh okxtuy tumi̱n xla cobre, ni̱tú̱ xtápalh xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ c-xlacati̱n Dios, yuma̱ koxuta li̱ma̱xkan pusca̱t, a̱tzinu tlak lhu̱hua̱ muju̱ni̱t xtumi̱n, ni̱ xahua̱ a̱makapitzí̱n hua̱nti̱ luhua lhu̱hua̱ muju̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sa̱mpi̱ makapitzí̱n hua̱ ma̱sta̱ma̱kó̱ xofrendacán hua̱ntu̱ aya xakata̱xtuniko̱ni̱t, pus huata xlá̱ huá̱ xpa̱lacata xtali̱má̱xkat ma̱sta̱ni̱t a̱ma̱ actzu̱ tumi̱n hua̱ntu̱ xtili̱huá̱yalh laqui̱mpi̱ tla̱n nalatama̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maktum yama̱ xli̱ma̱kalhtahuaka̱t Jesús xli̱chihui̱nama̱kó̱ tlanca templo la̱ntla̱ lacsuan chíhuix xtali̱ca̱xtlahuani̱t, chu̱ lakli̱lakati̱t tata̱quí̱n tu̱ xli̱ca̱xya̱huacani̱t. Hua̱mpi̱ huata Jesús chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Xli̱pacs yuma̱ lakli̱lakati̱t chíhuix, chu̱ tlanca pá̱tzaps hua̱ntu̱ huixín ucxilhpá̱tit, aya talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ nalakpaklhmi̱cán, chu̱ nia̱lh pala aktum chíhuix catitahui̱ anta̱ni̱ xuili̱cani̱t, sa̱mpi̱ pacs nama̱laksputucán. ");
INSERT INTO tosNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Huata xlacán chuná̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, ¿ní̱ li̱huaya̱ luhua nakantaxtuy hua̱ntu̱ quinca̱huanípa̱t la̱nchú̱? ¿Tú̱ xali̱ucxílhti̱t luhua natasiyuy laqui̱mpi̱ nacatzi̱cán pi̱ aya kantaxtuma̱ mintachihuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús chuná̱ kalhti̱ko̱lh: “Huixín xli̱ca̱na̱ luhua skálalh calatapá̱tit, chu̱ ni̱tí̱ naca̱akskahuiyá̱n, sa̱mpi̱ luhua lhu̱hua̱ naminko̱y hua̱nti̱ naakskahuinanko̱y, chu̱ xta̱chuná̱ la̱ quit nali̱taxtuputunko̱y, chu̱ nahuanko̱y: ‘Quit hua̱nti̱ naca̱lakma̱xtuyá̱n’, usuchí̱ nahuanko̱y: ‘Lanchú̱ aya lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ nasputcán.’ Hua̱mpi̱ huixín ni̱ nali̱pa̱huanko̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chu̱ acxni̱ huixín nacatzi̱yá̱tit pi̱ cani̱huá̱ lama̱ la̱ta̱la̱tlahu, chu̱ la̱ntla̱ la̱makni̱ma̱kó̱ tachixcuhuí̱tat, huixín ni̱ cape̱cuántit, sa̱mpi̱ ni̱ naj acxni̱ catisputca̱.” ");
INSERT INTO tosNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús chuná̱ huanipalako̱lh: “Hua̱nti̱ huilakó̱ c-aktum tlanca ca̱chiquí̱n nata̱la̱makni̱ko̱y hua̱nti̱ huilakó̱ a̱tanuj ca̱chiquí̱n, chu̱ la̱ntla̱ xli̱lhu̱hua̱ ca̱chiqui̱ní̱n nala̱si̱tzi̱niko̱y, chu̱ nala̱lacata̱qui̱ko̱y, natlahuako̱y guerra. ");
INSERT INTO tosNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Unú̱ ca̱tiyatna̱ luhua lacalhu̱hua̱ anta̱ni̱ natachiquiy tíyat, chu̱ nalaktzanka̱nán, chu̱ lacaxtum nalay tatzíncstat, ti̱pa̱lhu̱hua tajátat, chu̱ pucsnú̱ hua̱ntu̱ namín. Chi̱nchu̱ c-akapú̱n catu̱huá̱ tu̱ lacli̱pe̱cua, chu̱ tu̱ maka̱klhanán natasiyuy, chu̱ na̱ lhu̱hua̱ hua̱ntu̱ ni̱ pala tzinú̱ li̱ca̱najlaputu̱ natasiyuy. ");
INSERT INTO tosNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Hua̱mpi̱ acxni̱ ni̱ a̱ti̱taxtuy hua̱ntu̱ la̱nchú̱ cca̱huanimá̱n; huixín naca̱putzasta̱lacaná̱tit, chu̱ naca̱chipacaná̱tit, antá̱ naca̱ma̱kalhapali̱caná̱tit c-xpu̱tamakstoknican judíos, naca̱tamacanu̱caná̱tit c-pu̱la̱chi̱n, chu̱ caj quimpa̱lacata̱ naca̱li̱pincaná̱tit c-xlacati̱ncan ma̱paksi̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pus chuná̱ chú̱ huixín nali̱kalhi̱yá̱tit quilhtamacú̱ laqui̱mpi̱ tla̱n naquili̱chihui̱naná̱tit pi̱ xli̱ca̱na̱ quili̱pa̱huaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xa̱huachí̱ huixín ni̱ caa̱li̱ta̱katzanká̱tit xpa̱lacata la̱ntla̱ nakalhti̱naná̱tit, nali̱takalhmakta̱yayá̱tit acxni̱ naca̱ma̱kalhapali̱caná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sa̱mpi̱ quit ti̱ nacca̱ma̱xqui̱yá̱n talacapa̱stacni̱ laqui̱mpi̱ hua̱ntu̱ huixín nachihui̱naná̱tit ni̱tí̱ lay catica̱kalhti̱pa̱xtokni, usuchí̱ naca̱ta̱la̱huaniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Makapitzí̱n la̱ huixín hua̱nti̱ quili̱pa̱huaná̱tit naca̱li̱akskahuinancaná̱tit, hasta ma̱squi mintla̱tcán naca̱macama̱sta̱yá̱n, usuchí̱ hua̱nti̱ minta̱lacán, usu hua̱nti̱ mili̱nata̱lancán, usu miamigo; chu̱ huí̱ makapitzí̱n huixín ti̱ naca̱makni̱caná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xli̱pacs tachixcuhuí̱tat naca̱xcajniko̱yá̱n caj quimpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Hua̱mpi̱ ni̱ cali̱puhuántit, sa̱mpi̱ Dios pacs catzi̱y hua̱ntu̱ akspulayá̱tit, chu̱ ni̱ pala kantum miacchixitcán hua̱ntu̱ yá̱ c-miakxe̱kacán catitzánka̱lh pala xlá̱ ni̱ nalacasquín. ");
INSERT INTO tosNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pus acxni̱ yama̱ quilhtamacú̱, aksti̱tum cali̱pa̱huántit Dios laqui̱mpi̱ chuná̱ tla̱n nama̱laktaxti̱yá̱tit mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Acxni̱ naucxilhá̱tit pi̱ luhua lhu̱hua tropa̱ stilihuili̱ko̱ni̱t nahuán Jerusalén, pus luhua lacatancs chú̱ cacatzí̱tit pi̱ acxni̱ nama̱sputucán. ");
INSERT INTO tosNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pus huá̱ chú̱ ti̱ huilako̱lh nahuán c-xatiyat Judea, catza̱lako̱lh, chu̱ caanko̱lh ca̱ka̱sti̱ní̱n. Hua̱nti̱ huilakó̱ nahuán c-xaca̱chiqui̱n Jerusalén, huata xatlá̱n cataxtuko̱lh, chu̱ mákat caanko̱lh, chu̱ hua̱nti̱ scujma̱kó̱ nahuán c-xpú̱cuxtu, xatlá̱n nia̱lh cataspitko̱lh c-xchiccán. ");
INSERT INTO tosNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sa̱mpi̱ acxni̱ yama̱ quilhtamacú̱ Dios nama̱pa̱ti̱ni̱ko̱y tachixcuhuí̱tat laqui̱mpi̱ naxoko̱nanko̱y xli̱pacs hua̱ntu̱ ni̱tlá̱n tlahuako̱ni̱t, chu̱ na̱ acxni̱ nakantaxtuy xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka caj hua̱ntu̱ xpa̱lacata Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Koxutaní̱n lacchaján hua̱nti̱ acxni̱ yama̱ quilhtamacú̱ ta̱tatlako̱y nahuán, usuchí̱ ma̱tziqui̱nanko̱y nahuán! Sa̱mpi̱ acxni̱ xli̱ca̱na̱ naanán lhu̱hua tapa̱tí̱n u̱nú̱ c-mintiyatcán, chu̱ acxni̱ lhu̱hua̱ tu̱ nama̱pa̱ti̱ni̱cán hua̱nti̱ huilakó̱ u̱nú̱ c-xaca̱chiqui̱n Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lhu̱hua̱ xala u̱nú̱ tachixcuhuí̱tat nali̱makni̱ko̱cán espada, chu̱ makapitzí̱n nachipako̱cán, chu̱ tachí̱n nale̱nko̱cán cani̱hua̱ a̱lacatanuj ca̱chiquí̱n. Yama̱ chixcuhuí̱n a̱lacatanuj xalaní̱n hua̱nti̱ ni̱ judíos, chu̱ ni̱ ca̱najlaniko̱y Dios nali̱kama̱nanko̱y xaca̱chiqui̱n Jerusalén hasta acxni̱ pacs nakantaxtuko̱y la̱ntla̱ lhca̱huili̱ni̱t Dios napa̱ti̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Yama̱ quilhtamacú̱ acxni̱ nacmimpalay, catu̱huá̱ natasiyuy c-chichiní hua̱ntu̱ niucxni̱ tasiyuni̱t, chu̱ c-papá, xa̱hua̱ c-stacu; chu̱ xli̱putum tachixcuhuí̱tat hua̱nti̱ huilakó̱ c-xli̱ca̱tlanca ca̱tuxá̱huat naaklituananko̱y, chu̱ nape̱cuanko̱y, sa̱mpi̱ c-ta̱kaya̱huaná̱ li̱pe̱cua̱ la̱ntla natzucuy macasa̱nán, chu̱ la̱ntla̱ tanakamín. ");
INSERT INTO tosNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lhu̱hua̱ caj la̱ntla̱ xtape̱cuacán nalakahuitiko̱y acxni̱ nacatzi̱ko̱y pi̱ lhu̱hua tapa̱tí̱n namín ca̱tiyatna, pus hasta xli̱pacs hua̱ntu̱ huí̱ c-akapú̱n lacuilha̱ nalay. ");
INSERT INTO tosNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Acxnicú̱ chú̱ natasiyuy la̱ntla̱ quit, Xatalacsacni Chixcú, cta̱ctama̱chi nahuán c-akapú̱n c-xlacni aktum puclhni, chu̱ na̱ cli̱mímaj nahuán xli̱pacs quili̱makatlihuaka, chu̱ tlanca xkakánat. ");
INSERT INTO tosNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Acxni̱ chuná̱ natzucuy kantaxtuy hua̱ntu̱ cca̱huanimá̱n, huixín ni̱ cali̱puhuántit, huata cala̱ma̱akpuhuanti̱ní̱tit, chu̱ li̱pa̱xuhu catalacaya̱huátit, sa̱mpi̱ acxnitiyá̱ lakcha̱ni̱t nahuán quilhtamacú̱ la̱ntla̱ nacminá̱n ca̱tiyayá̱n laqui̱mpi̱ nacca̱lakma̱xtuyá̱n.” ");
INSERT INTO tosNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús li̱ta̱kalhchihui̱nampalako̱lh aktum talacapa̱stacni, chu̱ chuná̱ huaniko̱lh: “Pus caj luhua caucxilhkó̱tit la̱ntla̱ catu̱ya̱hua̱ quihui. ");
INSERT INTO tosNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Acxni̱ ucxilhá̱tit akayuja̱ makapitzi̱n quihui, chu̱ tzucuy akaskatampalay, huixín catzi̱yá̱tit pi̱ aya talacatzuhui̱ma̱ quilhtamacú̱ la̱ntla̱ natzucuy lhca̱cnán. ");
INSERT INTO tosNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pus na̱ chuna li̱tum acxni̱ chuná̱ huixín naucxilhá̱tit pi̱ kantaxtumaj nahuán hua̱ntu̱ la̱nchú̱ cca̱huanimá̱n, pus cacatzí̱tit pi̱ aya lakcha̱ni̱t quilhtamacú̱ la̱ntla̱ Dios laclhca̱huili̱ni̱t naca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na̱ luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ makapitzí̱n hua̱nti̱ la̱nchú̱ lama̱kó̱, ni̱ a̱ni̱ko̱y catihuanko̱lh acxni̱ natzucuy kantaxtuy hua̱ntu̱ la̱nchú̱ cca̱huanimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pacs hua̱ntu̱ anán c-akapú̱n, chu̱ c-tíyat tla̱n nalaksputko̱y; hua̱mpi̱ hua̱ quintachihuí̱n, ni̱ chunatá̱ catitamakáxtakli̱ pala ni̱ nakantaxtuy. ");
INSERT INTO tosNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Luhua xli̱ca̱na̱ cui̱ntaj catlahuátit minquilhtamacujcán, ni̱tú̱ tili̱makaxtaká̱tit minacu̱cán pi̱ hua̱ naca̱makatlajayá̱n hua̱ntu̱ xalacli̱xcajnit tapuhuá̱n, ni̱ caj naakkottapa̱yá̱tit, xa̱huachí̱ ni̱ ca̱ta catu̱huá̱ calakatí̱tit hua̱ntu̱ u̱nú̱ xala ca̱tiyatna, huata skálalh calatapá̱tit laqui̱mpi̱ acxni̱ quit nacmimpalay, ni̱tú̱ naca̱lakchiná̱n acxni̱ ni̱ li̱catzi̱huilátit. ");
INSERT INTO tosNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sa̱mpi̱ ni̱tlá̱n pala chuná̱ naca̱qui̱taxtuniyá̱n yama̱ quilhtamacú̱ la̱ akspulay tantum takalhí̱n acxni̱ tahuacaya̱chá̱ c-aktum li̱aksiyún, acxni̱ catzi̱y, aya pa̱ti̱ni̱t, pus na̱ chuná̱ c-xli̱ca̱tlanca̱ ca̱tuxá̱huat ni̱ li̱catzi̱huilako̱lh nahuán tachixcuhuí̱tat acxni̱ nalakchá̱n yama̱ quilhtamacú̱ la̱ntla quit nacmimpalay. ");
INSERT INTO tosNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chí̱ hua̱mpi̱ skálalh catahuilátit; ankalhí̱n nasquiniyá̱tit Dios c-mioracioncán pi̱ naca̱ma̱xqui̱yá̱n li̱tlihuaka̱ laqui̱mpi̱ tla̱n namacalayá̱tit tlanca tapa̱tí̱n hua̱ntu̱ namín, xa̱huachí̱ ni̱ anán tu̱ naca̱makstuntlahuayá̱n tu̱ ni̱tlá̱n tlahuayá̱tit acxni̱ quit nacmimpalay.” ");
INSERT INTO tosNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús ankalhí̱n acxni̱ ca̱cuhuiní̱ cxakatli̱ko̱y tachixcuhuí̱tat, chu̱ ca̱tzi̱sní̱ xan laktuncuhuiy c-ka̱stí̱n hua̱ntu̱ huanicán monte de los Olivos. ");
INSERT INTO tosNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na̱ cha̱li̱ cha̱lí̱ sokcú tzi̱sa̱ xchinko̱y c-tlanca templo laqui̱mpi̱ nakaxmatniko̱y xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aya xtalacatzuhui̱ma̱ quilhtamacu̱ la̱ntla̱ nalakchá̱n xapa̱scua̱ ta̱kspuntza̱lí̱n, acxni̱ xli̱pu̱tum judíos xuako̱y caxtala̱nchu̱ hua̱ntu̱ ni̱tú̱ kalhi̱y li̱ma̱xcuti̱n levadura. ");
INSERT INTO tosNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Yama̱ xanapuxcun pa̱lijni, xa̱hua̱ laktzokni̱naní̱n aya xputzama̱kó̱ la̱ntla̱ namakni̱ko̱y Jesús. Hua̱mpi̱ cumu luhua lhu̱hua̱ ti̱ xli̱pa̱huanko̱y, xlacán xpe̱cuaniko̱y pala nasi̱tzi̱niko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hua̱mpi̱ akskahuiní̱ tánu̱lh c-xtalacapa̱stacni Judas Iscariote; hua̱ yuma̱ Judas na̱ xta̱tapaksi̱ko̱y xli̱kalhacu̱tuy xli̱ma̱kalhtahuaka̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xlá̱ lacapala̱ álh xakatli̱ko̱y xanapuxcun pa̱lijni, chu̱ hua̱nti̱ xma̱paksi̱nanko̱y c-tlanca templo, laqui̱mpi̱ nata̱lacca̱xlako̱y, chu̱ namacama̱xqui̱ko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Acxni̱ xlacán catzi̱ko̱lh hua̱ntu̱ xma̱lacnu̱nima̱ko̱ca̱, luhua li̱pa̱xuhuako̱lh, chu̱ ta̱tlahuako̱lh tachihuí̱n nama̱xqui̱ko̱y tumi̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas na̱ tla̱n tláhualh, chu̱ tzúculh putzay la̱ntla̱ tla̱n namacama̱xqui̱ko̱y Jesús, hua̱mpi̱ acxni̱ ni̱ nacatzi̱ko̱y tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Acxni̱ lákcha̱lh quilhtamacú̱ c-xapa̱scua̱ ta̱kspuntza̱lí̱n, acxni̱ pu̱tum judíos xuako̱y caxtala̱nchu̱ hua̱ntu̱ ni̱tú̱ ta̱tlahuacani̱t levadura, chu̱ na̱ acxni̱ xmakni̱ko̱cán xalactzu̱ borrego hua̱ntu̱ nahuacán, laqui̱mpi̱ chuná̱ nali̱lakachixcuhui̱nancán yama̱ c-pa̱scua̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pus Jesús ma̱lakacha̱ko̱lh Pedro, chu̱ Juan, huaniko̱lh: —Lacapala̱ capimpítit, caqui̱ca̱xtlahuátit quili̱huatcán hua̱ntu̱ nahuaya̱hu la̱nchú̱ ca̱tzi̱sní̱ c-xapascua̱ ta̱kspuntza̱lí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—¿Ní̱ lacasquina̱ nacana̱huá ca̱xtlahuaya̱hu! —kalhti̱nanko̱lh xlacán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús chuná̱ kalhti̱ko̱lh: —Acxni̱ huixín nachipiná̱tit ca̱chiquí̱n, naucxilhá̱tit cha̱tum chixcú̱ cucale̱ma̱ pa̱tum stu̱n chúchut. Huixín casta̱lanítit hasta c-chiqui̱ anta̱ni̱ xlá̱ natanu̱ya̱chá, ");
INSERT INTO tosNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","chu̱ chuná̱ nahuaniyá̱tit xpu̱china chiqui: ‘Huan Quimpu̱chinacán: ¿Ni̱ huí̱ yama̱ pu̱lactum chiqui anta̱ni̱ nacta̱hua̱yanko̱y quili̱ma̱kalhtahuáka̱t u̱ma̱ catzi̱sní̱ c-xapa̱scua̱ ta̱kspuntza̱lí̱n?’ ");
INSERT INTO tosNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chu̱ antá̱ naca̱ma̱siyunicaná̱tit pu̱lactum chiqui̱ tzinú̱ tlak ca̱laktlanca c-xli̱quilhmactuy chiqui, antá̱ aya li̱huana̱ ma̱ca̱qui̱cani̱t; pus antá̱ caca̱xtlahuátit quili̱huatcán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xlacán lacapala̱ anko̱lh, chu̱ xli̱ca̱na̱ chuná̱ ma̱noklhuko̱lh xta̱chuná̱ la̱ntla̱ Jesús xuaniko̱ni̱t, chu̱ antá̱ ca̱xtlahuako̱lh lí̱huat hua̱ntu̱ huacán acxni̱ xapa̱scua̱ ta̱kspuntza̱lí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ca̱ko̱tanú̱n acxni̱ áccha̱lh hora, Jesús chu̱ xapóstoles pu̱tum cha̱nko̱lh; chu̱ acxni̱ tahuilako̱lh c-mesa ");
INSERT INTO tosNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús chuná̱ huaniko̱lh: —Maklhu̱huatá̱ cpuhuani̱t pi̱ pu̱tum lacxtum nacca̱ta̱hua̱yaná̱n acxni̱ yuma̱ xapa̱scua̱ ta̱kspuntza̱lí̱n xli̱makua ni̱ ca̱ni̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sa̱mpi̱ xli̱ca̱na̱ lacatancs cca̱huaniyá̱n pi̱ nia̱lh maktum chuná̱ cactihuá̱yalh hasta acxni̱ pacs kantaxtuko̱ni̱t nahuán hua̱ntu̱ huaniputún c-xtapaksi̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A̱li̱sta̱lh tíyalh pa̱tum vaso̱ xchuchut uva, pa̱xcatcatzí̱nilh Dios, xlí̱huat, chu̱ chuná̱ huaniko̱lh: —Cahuapítit yumá̱ acatzuní̱n, chu̱ mili̱pacscán cali̱takatzí̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Sa̱mpi̱ xli̱ca̱na̱ cca̱huaniyá̱n pi̱ nia̱lh cactili̱kótnalh xchuchut uva hasta acxni̱ nalakchá̱n quilhtamacú̱ acxni̱ ni̱li̱huaya̱ Dios huili̱ni̱t nahuán xtapáksi̱t c-xli̱ca̱tlanca. ");
INSERT INTO tosNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A̱li̱sta̱lh tíyalh caxtala̱nchu̱, pa̱xcatcatzí̱nilh Dios, chu̱ lakchákalh, ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ chuná̱ huaniko̱lh: —Hua̱ yuma̱ caxtala̱nchu̱ li̱taxtuy quintiyatli̱hua hua̱ntu̱ cmacama̱sta̱y caj mimpa̱lacatacán laqui̱mpi̱ chuná̱ tla̱n nacca̱lakma̱xtuyá̱n. Chuná̱ huixín catlahuapítit hua̱ntu̱ la̱nchiyú̱ ctlahuama̱ laqui̱mpi̱ ankalhi̱ná̱ naquili̱lacapa̱stacá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chu̱ na̱ chuná̱ tlahuapá̱ acxni̱ pi̱ xua̱yanko̱ni̱ttá, tíyalh yama̱ pu̱kotnu hua̱ntu̱ xpu̱taju̱ma̱ xchuchut uva, chu̱ chuná̱ huaniko̱lh: —Hua̱ yuma̱ xchuchut uva, ankalhí̱n naca̱ma̱lacapa̱stacayá̱n pi̱ Dios ca̱ta̱tlahuani̱tán aktum xasa̱sti talacca̱xlán la̱ntla̱ nalakma̱xtuko̱y tachixcuhuí̱tat, sa̱mpi̱ yama̱ quinkalhni̱ hua̱ntu̱ nastajtamakán, caj mimpa̱lacatacán luhua nama̱luloka̱ pi̱ xli̱ca̱na̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Hua̱mpi̱ lacatancs cacatzí̱tit pi̱ yama̱ chixcú̱ hua̱nti̱ naquimacama̱sta̱y, la̱nchú̱ lacxtum macahuácaj quinta̱hui̱ c-mesa. ");
INSERT INTO tosNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sa̱mpi̱ quit nacni̱y chuná̱ la̱ntla̱ Dios laclhca̱huili̱ni̱t quimpa̱lacata, hua̱mpi̱ koxutá̱ yama̱ chixcú hua̱nti̱ naquimacamasta̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yama̱ xli̱ma̱kalhtahuáka̱t tzúculh la̱kalhasquinko̱y xacstucán, chu̱ chuná̱ xla̱huaniko̱y: —¿Xatí̱ cahuá̱ namacama̱sta̱y? ");
INSERT INTO tosNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A̱li̱sta̱lh xlacán tzúculh la̱li̱akslokoko̱y caj xpa̱lacata xatí̱ a̱tzinú̱ tlak tali̱pa̱hu nali̱taxtuy, chu̱ nama̱paksi̱ko̱y a̱makapitzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesús xkaxmatma̱ xtachihui̱ncán, chu̱ chuná̱ huaniko̱lh: “Huixín catzi̱yá̱tit pi̱ c-xlaksti̱pa̱ncán ti̱ ni̱ li̱pa̱huanko̱y Dios, lactlanca xreyescán tlanca̱ catzi̱niko̱y hua̱nti̱ ma̱paksi̱ko̱y, chu̱ hua̱nti̱ puxcunko̱y, ma̱squi xali̱kamá̱n tlahuako̱y hua̱nti̱ ma̱paksi̱ko̱y, xlacán li̱taxtuputunko̱y la̱mpala luhua lacuan cristianos hua̱nti̱ xli̱ca̱na̱ tlahuako̱y li̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Hua̱mpi̱ huixín hua̱nti̱ quili̱pa̱huaná̱tit, ni̱ chuná̱ catica̱qui̱taxtunín, sa̱mpi̱ hua̱nti̱ tlak le̱ná̱ quilhtamacu̱, chu̱ a̱tzinú̱ tali̱pa̱huá̱ makcatzi̱cán huata xatlá̱n xta̱chuná̱ cali̱táxtulh ti̱ tatlaji̱ycú; chu̱ hua̱nti̱ luhua ma̱paksi̱nán huata xlá̱ xta̱chuná cahuá̱ la̱ntla̱ cha̱tum caj scujni. ");
INSERT INTO tosNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na̱ chuná̱ la̱ntla̱ huixín catzi̱yá̱tit pi̱ yama̱ hua̱nti̱ tali̱pa̱hu chixcú, acxni̱ tahuilay c-mesa laqui̱mpi̱ nahua̱yán, lhu̱hua̱ xtasa̱cua̱ antá̱ ya̱kó̱ laqui̱mpi̱ namuju̱niko̱y xlí̱huat, chu̱ nali̱scujko̱y. Hua̱mpi̱ huata tu̱ quit quimpa̱lacata, ni̱ chuná qui̱taxtuma̱, sa̱mpi̱ quit clama̱ c-milaksti̱pa̱ncán la̱ntla̱ hua̱nti̱ xli̱ca̱na̱ ca̱li̱scujmá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Pacs hua̱ntu̱ quit quiakspulama̱, chu̱ hua̱ntu̱ cli̱li̱puhuán, huixín ankalhí̱n quinta̱lapu̱layá̱tit, chu̱ na̱ quinta̱pa̱ti̱pá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huá̱ xpa̱lacata cca̱li̱huaniyá̱n, xta̱chuná̱ la̱ntla̱ Quintla̱t quima̱xqui̱y quintapáksi̱t laqui̱mpi̱ nacli̱ma̱paksi̱ko̱y xlakskatá̱n, pus na̱ chuná̱ nacca̱ma̱xqui̱yá̱n mintapáksi̱t hua̱ntu̱ nali̱ma̱paksi̱naná̱tit, ");
INSERT INTO tosNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","laqui̱mpi̱ antá̱ lacxtum naquinca̱taniyá̱tit, naquinta̱pa̱xuhuayá̱tit c-quimpu̱ma̱paksí̱n, chu̱ laqui̱mpi̱ na̱ natahuilayá̱tit cha̱tunu̱ c-mimpu̱ma̱paksi̱ncán anta̱ni̱ namakma̱paksi̱yá̱tit yama̱ pu̱laccu̱tuy xquilhtzucut Israel.” ");
INSERT INTO tosNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A̱li̱sta̱lh quimpu̱chinacan Jesús chuná̱ huánilh Pedro: —Simón, huix luhua cakáxpatti̱ hua̱ntu̱ cuanimá̱n, sa̱mpi̱ akskahuiní̱ aya ma̱xqui̱cani̱t quilhtamacú̱ laqui̱mpi̱ chú̱ nali̱ucxilhá̱n c-milatáma̱t lapi̱ ca̱na̱ quili̱pa̱huana, chu̱ tla̱n naca̱lactincxá̱n mili̱pacscán xta̱chuná̱ la̱ tlahuacán trigo acxni̱ lacsacmakanicán palhma̱ tu̱ kalhi̱y laqui̱mpi̱ xlakstu trigo natamakaxtaka. ");
INSERT INTO tosNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Hua̱mpi̱ quit cpa̱lacasquini̱tán c-quioración laqui̱mpi̱ yama̱ mintaca̱najla̱cán hua̱ntu̱ quinkalhi̱niyá̱tit niucxni̱ natatlaji̱y, chi̱nchu̱ acxni̱ huix aya laktaxtunini̱tatá nahuán hua̱ntu̱ xli̱aktzanka̱ta̱yápa̱t, pus chú̱ huata camakta̱ya̱kó̱ a̱makapitzi̱n minta̱ca̱jlaní̱n acxni̱ xlacán na̱ natoklhko̱cán c-xlatama̱tcán xta̱chuná̱ la̱ntla̱ huix toklhcani̱tatá nahuán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, quit luhua aktum ccatzi̱y, ma̱squi lacxtum caquinta̱li̱pinca̱ c-pu̱la̱chi̱n, chu̱ ma̱squi lacxtum quinta̱makni̱ca̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús chuná̱ kálhti̱lh: —Pedro, huata luhua lacatancs cuaniputuná̱n, la̱nchú̱ acxni̱ ni̱ a̱tasay nahuán pu̱yu̱ huix aya huani̱tatá nahuán xli̱maktutu pi̱ ni̱ quilakapasa acxni̱ nakalhasquincana. ");
INSERT INTO tosNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús chuná̱ kalhasquinko̱lh xli̱ma̱kalhtahuáka̱t: —Acxni̱ yama̱ quilhtamacú̱ ctica̱ma̱lakachá̱n li̱cha̱tiyú̱n, na̱ ni̱ cca̱ma̱le̱ní̱n xpu̱muju̱can mintumi̱ncán, chu̱ ni̱ pala hua̱ mimpu̱xtokocán, chu̱ ni̱ pala hua̱ mintatuhuanu̱ncán, ¿pi̱ huí̱ tu̱ tica̱qui̱tzanka̱nín? —Ni̱tú̱ quinca̱tzanka̱nini̱tán —kalhti̱nanko̱lh xlacán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Puschí̱ cca̱huaniyá̱n la̱nchú̱, pi̱ hua̱nti̱ kalhi̱y xpu̱muju̱can xtumi̱n cale̱lh, chu̱ hua̱nti̱ kalhi̱y xpú̱xtoko, pus huata na̱ cale̱lh; chu̱ hua̱nti̱ ni̱tú̱ kalhi̱y xcuchi̱lu̱, catamá̱hualh, hasta ma̱squi luhua xlacasquinca̱ casta̱lh xtamaknu laqui̱mpi̱ chuná̱ nakalhi̱y tumi̱n, chu̱ natama̱huay hua̱ntu̱ tzanka̱nima̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sa̱mpi̱ lacatancs cca̱huaniyá̱n pi̱ la̱nchiyú̱ nakantaxtuy c-quilatáma̱t hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ anta̱ni̱ chuná̱ huan: ‘Chuná̱ li̱ma̱xtuca̱ xta̱chuná̱ la̱ cha̱tum makni̱na chixcú, chu̱ xli̱tamaklhtúmi̱t.’ Pus chuná̱ pacs nakantaxtuy hua̱ntu̱ tatzoktahuilani̱t c-xtachihui̱n Dios caj quimpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xlacán chuná̱ kalhti̱nanko̱lh: —Quimpu̱chinacán, u̱huí̱ kantuy cuchi̱lu̱. Huata xlá̱ kalhti̱ko̱lh: —Aya tla̱n, cala̱huantama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A̱li̱sta̱lh Jesús táxtulh c-xaca̱chiqui̱n Jerusalén, chu̱ antá̱ álh c-monte de los Olivos la̱ntla̱ maklhu̱huatá̱ chuná̱ xla̱ xli̱smani̱ni̱t, chu̱ na̱ sta̱laniko̱lh xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Acxni̱ antá̱ cha̱nko̱lh, chuná̱ huaniko̱lh: —Clacasquín pi̱ chú̱ pacs natlahuaniyá̱tit oración Dios, chu̱ casquinítit pi̱ ni̱ natatlaji̱yá̱tit acxni̱ ca̱makatlajaputuná̱n ni̱tla̱n tapuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús aya titapa̱nu̱niko̱lh, tzinú̱ álh tlak lakamákat, chu̱ antá̱ tatzokóstalh laqui̱mpi̱ natlahuaniy oración Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Chuná̱ kalhtahuakánilh, huánilh: “Tla̱ti Dios, lapi̱ huix chuná̱ lacasquina, pus huata catlahua̱ li̱tlá̱n caquima̱pa̱nu̱ni̱ yuma̱ tapa̱tí̱n hua̱ntu̱ quit naquiakspulay. Hua̱mpi̱ ni̱ huá̱ calalh quintalacasquín, huata xatlá̱n huá̱ cakantáxtulh mintalacasquín.” ");
INSERT INTO tosNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chu̱ acxnitiyá̱ titasiyúnilh cha̱tum ángel xala c-akapú̱n laqui̱mpi̱ nama̱tlihuaklha. ");
INSERT INTO tosNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Chu̱ acxni̱ luhua li̱pe̱cua̱ la̱ntla̱ xli̱puhuama a̱tzinú̱ tlak li̱tlihuaka xtlahuaniy oració̱n Dios; hasta tzúculh xunuy, chu̱ cxúnut tu̱ stajtamákalh la̱ xkalhni̱ chaklh chaklh xta̱ctama̱ hasta ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Acxni̱ chuná̱ tlahuaniko̱lh oración Dios, tá̱yalh, chu̱ lakanko̱lh xli̱ma̱kalhtahuáka̱t, pus pacs xalhtatán ma̱noklhuko̱lh sa̱mpi̱ luhua xmakatlajako̱ni̱t xtali̱puhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Puschí̱ huaniko̱lh: —¿Tú̱huan luhua lhtatapá̱tit? Lacapala̱ cata̱quí̱tit, chu̱ makcatzi catlahuanítit oración Dios laqui̱mpi̱ ni̱ natatlaji̱yá̱tit acxni̱ naca̱makatlajaputuná̱n ni̱tla̱n talacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chunacú xchihui̱nama̱ Jesús acxni̱ pu̱tum táchilh lhu̱hua tachixcuhuí̱tat. Huá̱ xpu̱laniti̱lhako̱y Judas hua̱nti̱ na̱ xta̱tapaksi̱ko̱y xli̱kalhacu̱tuycan xli̱ma̱kalhtahuaka̱t Jesús. Xlá̱ laktalacatzúhui̱lh laqui̱mpi̱ naxakatli̱y, chu̱ tla̱n nalacatzu̱ca. ");
INSERT INTO tosNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Acxni̱ chuná̱ tlahuako̱lh, Jesús huánilh: —Judas, ¿caj la̱ntla̱ huix quilacátzu̱cti, huá̱ chuná̱ quili̱macama̱stá̱pa̱t quit, Xatalacsacni Chixcú? ");
INSERT INTO tosNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Chu̱ hua̱nti̱ antá̱ pu̱tum xta̱ya̱kó̱ Jesús, acxni̱ xlacán ucxilhko̱lh hua̱ntu̱ xlama̱, chuná̱ huaniko̱lh: —Quimpu̱chinacán, ¿lá̱ huix huana, pá̱ cli̱ma̱sipa̱ni̱nana̱hu quispada̱cán? ");
INSERT INTO tosNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Judas ni̱ xa̱kalhti̱nán acxni̱ cha̱tum xli̱ma̱kalhtahuaka̱t Jesús, lacapala̱ xtat má̱xtulh cspa̱da̱, chu̱ ca̱actí̱nilh xtaka̱n cha̱tum xcscujni xapuxcu pa̱li̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Hua̱mpi̱ Jesús huánilh: —Caj antá̱ catamakaxtáktit, nia̱lh tú̱ catlahuátit. Cha̱nchu̱ xlá̱ xamánilh xtaká̱n yama̱ cscujnican pa̱lijni, chu̱ ma̱akapácsalh. ");
INSERT INTO tosNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","A̱li̱sta̱lh Jesús cacs lacaucxilhko̱lh yama̱ xanapuxcun pa̱lijni̱, chu̱ mayu̱lhnu̱ hua̱nti̱ xmaktakalhnanko̱y c-tlanca templo, xa̱hua̱ lakko̱lutzi̱nni ma̱paksi̱naní̱n hua̱nti̱ xminko̱ni̱t chipako̱y, chu̱ chuná̱ huaniko̱lh: —¿Pi̱ cha̱tum tlanca makkalha̱na̱ chixcú̱ quit, la̱ntla̱ li̱taná̱tit spada hua̱ntu̱ naquili̱chipayá̱tit xta̱chuná̱ la̱ cha̱tum kalha̱ná? ");
INSERT INTO tosNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Acxni̱ quit xacca̱ta̱lamá̱n cha̱li̱ cha̱lí̱ c-tlanca templo, huixín ni̱ pala maktum xquinchipátit, hua̱mpi̱ hua̱ chú̱ hua̱ huixín ca̱lakcha̱ná̱n tu̱ natlahuayá̱tit, sa̱mpi̱ ca̱tzi̱sní̱ ca̱makta̱yayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Cha̱nchu̱ chipaca̱ Jesús, tachí̱n le̱nca̱ antá̱ c-xchic xapuxcu pa̱li̱, chu̱ Pedro csta̱laniti̱lhay tzinú̱ tlak lakamákat. ");
INSERT INTO tosNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Acxni̱ antá̱ cha̱nko̱lh c-pu̱chihuí̱n, antá̱ ma̱lhcuyuca̱ c-xtanquilhti̱n chiqui, chu̱ pacs policías tahuilako̱lh c-xli̱kalhtlanca̱ a̱ma̱ lhcúya̱t, chu̱ na̱ antá̱ maktahui̱ Pedro. ");
INSERT INTO tosNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Caj puntzú̱ aya milh cha̱tum tzuma̱t maksquití, acxni̱ xlá̱ úcxilhli̱ pi̱ antá̱ xmaklahui̱ anta̱ni̱ xma̱lhcuyucani̱t, cacs lacaúcxilhli̱ puntzú̱, chu̱ chuná̱ huaniko̱lh a̱makapitzí̱n: —Huá̱ chicá̱ yuma̱ chixcú̱ na̱ xta̱latla̱huán Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Huata Pedro ni̱ kalhtasiyuniko̱lh, chu̱ chuná̱ huánilh: —Pusca̱t, quit lacatancs cuaniyá̱n pi̱ ni̱ pala tzinú̱ clakapasa̱ hua̱nti̱ huix huanípa̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Caj tzinú̱ chú̱ a̱li̱sta̱lh, tiucxilhpá̱ a̱cha̱tum, chu̱ na̱ lakápasli, chuná̱ huánilh: —Xli̱ca̱na̱ cuan huix na̱ xta̱lapu̱laya̱ yama̱ chixcu Jesús. Hua̱mpi̱ Pedro huánilh: —Huix aktzanka̱ni̱ta, sa̱mpi̱ ni̱ quit xlá̱ tamá̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Cajcu ma̱x aktum hora xlacatza̱lani̱t, acxni̱ xma̱lulokma̱pá̱ a̱cha̱tum, xquilhuama̱: —Luhua xli̱ca̱na̱ pi̱ na̱ xa̱hua̱ yuma̱ chixcú, na̱ lacxtum xta̱lapu̱lay Jesús, pus tuncán talakapasa, sa̱mpi̱ xlá̱ na̱ xta̱chuná̱ chihui̱nán la̱ntla̱ ti̱ xala c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Cha̱nchu̱ Pedro tuncán kálhti̱lh: —Hua̱mpi̱ xli̱ca̱na̱ cuaniyá̱n pi̱ ni̱ pala tzinú̱ ccatzi̱y hua̱ntu̱ li̱chihui̱námpa̱t. Acxnitiya̱ a̱má̱, acxni̱ Pedro xchihui̱namajcú, tásalh tantum pu̱yu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Cha̱nchu̱ Quimpu̱chinacán ti̱ ma̱squi xtanu̱ma̱ c-chiqui, laktalakáspitli̱ anta̱ni̱ xyá̱, chu̱ la̱ntla̱ xli̱lakamákat lacú̱cxilhli̱ Pedro, chu̱ huata xlá̱ lacapá̱stacli̱ hua̱ntu̱ xlá̱ xuaniní̱t: “Acxni̱ ni̱ a̱tasay nahuán pu̱yu̱, huix aya huanini̱tatá nahuán maktutu pi̱ ni̱ quilakapasa.” ");
INSERT INTO tosNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pedro lacapala̱ táxtulh c-quilhtí̱n, chu̱ caj cha̱li̱puhua̱na̱ antá̱ tzúculh tasay. ");
INSERT INTO tosNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huá̱ chú̱ chixcuhuí̱n hua̱nti̱ xmaktakalhma̱kó̱ Jesús tzúculh li̱kama̱nanko̱y, chu̱ tla̱n huili̱niko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Li̱lakachi̱ko̱lh mactum lháka̱t, chu̱ tzúculh lakasnokko̱y c-xlacán, chu̱ chuná̱ xuaniko̱y: —Cahuanti̱ tí̱ huili̱nín. ");
INSERT INTO tosNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chu̱ lhu̱hua̱ catu̱huá̱ hua̱ntu̱ xuaniko̱y caj la̱ntla̱ xli̱kalhkama̱nanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Acxni̱ chu̱ tituncúhuilh, pacs tamakstokko̱lh xalakko̱lun ma̱paksi̱naní̱n, chu̱ xanapuxcun pa̱lijni, xa̱hua̱ laktzokni̱naní̱n, c-xpu̱ma̱paksi̱ncán; antá̱ chú̱ le̱nca̱ Jesús c-xlacati̱ncán, chu̱ xlacán chuná̱ kalhasquinko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Caquinca̱huani, ¿pi̱ xli̱ca̱na̱ huix yama̱ Cristo hua̱nti̱ quin judíos kalhkalhi̱ma̱hu namín quinca̱lakma̱xtuyá̱n? Xlá̱ chuná̱ kalhti̱ko̱lh: —Hua̱ lapi̱ nacca̱huaniyá̱n pi̱ xli̱ca̱na̱, huixín ni̱ catica̱najlátit. ");
INSERT INTO tosNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chu̱ na̱ lapi̱ quit nacca̱tlahuaniyá̱n aktum takalhasquiní̱n hua̱ntu̱ quit xacli̱tamaktá̱yalh, huixín ni̱ caquintikalhtí̱tit, chu̱ ni̱ pala caquintimakaxtáktit. ");
INSERT INTO tosNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Hua̱mpi̱ aya talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ quit, Xatalacsacni Chixcú, cuilachá nahuán c-xpa̱xtu̱n Quintla̱tican Dios, hua̱nti̱ tlanca xlacatzúcut, laqui̱mpi̱ lacxtum nacta̱ma̱paksi̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Cha̱nchu̱ xli̱pacscán, chuná̱ kalhasquinko̱lh: —Acxni̱ chuná̱ huana, ¿pi̱ hua̱ li̱huamputuna̱ pi̱ xli̱ca̱na̱ huix xCam Dios? —Xli̱ca̱na̱ quit xCam Dios chuná̱ la̱ntla̱ huixín quilhuampá̱tit —kalhti̱ko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xlacán chuná̱ huanko̱lh: —¿Tú̱ taji̱ tilacasquina̱hu ma̱luloknaní̱n, sa̱mpi̱ chú̱ quin ma̱n kalhakaxmatni̱tahu la̱ntla̱ li̱kalhakama̱nani̱t Dios? ");
INSERT INTO tosNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A̱li̱sta̱lh pu̱tum pacs ta̱yako̱lh, chu̱ le̱nko̱lh Jesús c-xlacati̱n ma̱paksi̱na Pilato. ");
INSERT INTO tosNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Acxni̱ antá̱ cha̱nko̱lh, catu̱huá̱ tzucuko̱lh li̱sta̱huako̱y, chu̱ chuná̱ xuanko̱y: —Quin cma̱noklhuni̱tahu yuma̱ chixcú̱ acxni̱ xlá̱ xma̱lakaspitya̱huama̱kó̱ tachixcuhuí̱tat, xlá̱ huan pi̱ mat ni̱tlá̱n la̱ntla̱ clakaxoko̱nanima̱hu gobierno xala c-Roma, xa̱huachí̱ huampalay pi̱ mat huá̱ ma̱laktaxti̱ná, huá̱ li̱taxtuputún yama̱ rey hua̱nti̱ namín quinca̱ma̱paksi̱yá̱n quin judíos. ");
INSERT INTO tosNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Cha̱nchu̱ Pilato chuná̱ kalhásquilh: —¿Pi̱ xli̱ca̱na̱ chuná̱ la̱ntla̱ huanko̱y pi̱ huix xreycan judíos li̱taxtuputuna? —Xli̱ca̱na̱ tla̱n lapi̱ chuná cahuá̱ la̱ntla̱ huix huana —kálhti̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato huaniko̱lh xanapuxcun pa̱lijni, chu̱ xli̱pacs tachixcuhuí̱tat hua̱nti̱ antá̱ xya̱kó̱: —Quit ni̱tú̱ cta̱ksniy xtala̱kalhí̱n hua̱ntu̱ nacli̱ya̱huay yuma̱ chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pus huata xlacán a̱tzinú̱ luhua palha tzucuko̱lh quilhaniko̱y: —Hua̱mpi̱ tama̱ chixcú̱ quilhca̱xya̱huako̱y tachixcuhuí̱tat caj xpa̱lacata hua̱ntu̱ xlá̱ li̱akchihui̱nanima̱kó̱, chunatá̱ la̱ntla̱ tima̱tzuqui̱chá̱ c-Galilea, chu̱ aya chini̱t u̱nú. ");
INSERT INTO tosNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Acxni̱ Pilato káxmatli̱ hua̱ntu̱ xlacán xquilhuama̱kó̱, kalhasquiní̱nalh lapi̱ xli̱ca̱na̱ Jesús xala c-Galilea xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Cha̱nchu̱ acxni̱ huani̱ca̱ pi̱ xli̱ca̱na̱ Jesús xala c-Galilea xuani̱t, huata xlá̱ huá̱ ma̱lakachá̱nilh rey Herodes laqui̱mpi̱ huata huá̱ nama̱kalhapali̱y, sa̱mpi̱ hua̱ xlá̱ xuí̱ ligobernador c-Galilea, hua̱mpi̱ acxni̱ yama̱ quilhtamacú̱ xlá̱ xmini̱t paxia̱lhnán c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Yama̱ rey Herodes aya xkaxmatni̱t la̱ntla̱ xli̱chihui̱nancán xtascujut Jesús, chu̱ acxni̱ chú̱ úcxilhli, luhua pa̱xúhualh sa̱mpi̱ xlá̱ xlacasquín pi̱ antá̱ c-xlacati̱n natlahuay aktum tlanca li̱ca̱cni tascújut. ");
INSERT INTO tosNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Catu̱huá̱ hua̱ntu̱ xlá̱ kalhásquilh, hua̱mpi̱ Jesús ni̱tú̱ kálhti̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chu̱ na̱ antá̱ xuilakó̱ xanapuxcún pa̱lijni, chu̱ laktzokni̱naní̱n hua̱nti̱ ca̱ta catu̱hua̱ xli̱ma̱lacapu̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Chi̱nchu̱ yama̱ Herodes tzúculh si̱tzi̱niy, xa̱hua̱ xli̱putum xtropa̱ hua̱nti̱ na̱ tzucuko̱lh li̱kalhakama̱nanko̱y; chu̱ la̱ntla̱ li̱kama̱nanko̱lh ma̱lhaka̱ko̱lh mactum xatla̱n lháka̱t xta̱chuná̱ la̱ xla rey; chu̱ a̱li̱sta̱lh Herodes ma̱lakacha̱nipá̱ Pilato. ");
INSERT INTO tosNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Puschí̱ huatiyá̱ yama̱ quilhtamacú̱ rey Herodes, chu̱ gobernador Pilato luhua xli̱ca̱na̱ amigos la̱tlahuapalako̱lh sa̱mpi̱ xali̱pu̱lana̱ luhua xla̱makasi̱tzi̱y, chu̱ ni̱ xla̱ucxilhputún. ");
INSERT INTO tosNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Cha̱nchu̱ Pilato, tasaniko̱lh, ma̱makstokko̱lh xanapuxcun pa̱lijni, chu̱ hua̱nti̱ xma̱paksi̱ko̱y judíos, chu̱ tachixcuhuí̱tat xala ca̱chiquí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chuná̱ huaniko̱lh: —Huixín quili̱minini̱tántit yuma̱ chixcú, sa̱mpi̱ huaná̱tit pi̱ ma̱lakaspitya̱huako̱y tachixcuhuí̱tat; hua̱mpi̱ quit aya ckalhputza̱nanini̱t c-milacati̱ncán, chu̱ ni̱tú̱ cmaklhta̱ksni̱t tala̱kalhí̱n la̱ntla̱ tu̱ huixín li̱sta̱huayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pus na̱ chuná̱ Herodes, na̱ ni̱tú̱ tá̱ksnilh xtala̱kalhí̱n hua̱ntu̱ nali̱ya̱huay, pus hua̱ quinca̱li̱ma̱lakacha̱nipalán. Pus antá̱ chú̱ lacatancs li̱tasiyuy pi̱ yuma̱ chixcú̱ ni̱tú̱ tlahuani̱t hua̱ntu̱ ni̱tlá̱n, chu̱ hua̱ntu̱ mini̱niy nacli̱ma̱makni̱ni̱nán. ");
INSERT INTO tosNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Chí̱ hua̱mpi̱ tu̱ nactlahuay nacma̱pa̱ti̱ni̱y tzinú̱, chu̱ acxni̱ naka̱snokko̱cán, nacmakaxtaka. ");
INSERT INTO tosNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Hua̱mpi̱ acxni̱ xlacán kaxmatko̱lh pi̱ namakaxtaka̱ Jesús xli̱pacscán quilhxtum anko̱y tzucuko̱lh quilhaniko̱y, huanko̱y: —¡Tama̱ chixcú, camakni! ¡Huata xatlá̱n caquinca̱makaxtakni̱ Barrabás! Pus acxni̱ makatunu xlay xpa̱scuajcan judíos xla ta̱kspuntza̱lí̱n, gobernador Pilato, ankalhí̱n ca̱ta ca̱ta̱ xmakaxtakniko̱y tachixcuhuí̱tat cha̱tum tachí̱n, sa̱mpi̱ xlacán luhua chuná̱ csquiniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yama̱ Barrabás, xlá̱ xtamacanu̱cani̱t c-pu̱la̱chi̱n sa̱mpi̱ huá̱ xlá̱ xlacata̱qui̱nani̱t, chu̱ na̱ makni̱ná xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato juerza xmakaxtakputún Jesús, chu̱ xakatli̱palako̱lh a̱maktum tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Hua̱mpi̱ huata xlacán a̱tzinú̱ palha̱ tzucuko̱lh ca̱tasapalako̱y, huanko̱y: —¡Capakaxtokohuaca̱ c-cruz! ¡Capakaxtokohuaca̱ c-cruz! ");
INSERT INTO tosNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Xli̱maktutu̱ Pilato chuná̱ huanipalako̱lh: —Hua̱mpi̱ ¿tú̱ tala̱kalhí̱n tlahuani̱t? Sa̱mpi̱ quit ni̱tú̱ cta̱ksniy pala tú̱ nacli̱ma̱lulokniy pi̱ tla̱n nacmakni̱y. Huata caj nacakastacya̱huay puntzú̱, chu̱ nacmakaxtaka. ");
INSERT INTO tosNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Hua̱mpi̱ xlacán ni̱tlá̱n tlahuako̱lh, chu̱ ca̱x pixtlanca̱ ca̱tasako̱lh, fuerza csquinima̱kó̱ pi̱ Jesús capakaxtokohuacaca̱ c-cruz; chu̱ na̱ chuná̱ xquilhuama̱kó̱ xanapuxcún pa̱lijni, laqui̱mpi̱ tla̱n cakantáxtulh hua̱ntu̱ xlacán xlacasquinko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Acxni̱ nia̱lh cátzi̱lh tu̱ natlahuay, Pilato li̱ma̱paksí̱nalh natlahuacán hua̱ntu̱ xlacán csquima̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Puschí̱ huá̱ makaxtakniko̱lh yama̱ chixcú̱ hua̱nti̱ xtanu̱ma̱ c-pu̱la̱chi̱n xuanicán Barrabás, caj lacata̱qui̱ná xuani̱t, chu̱ xmakni̱nani̱t, chi̱nchu̱ huata macama̱xqui̱ko̱lh Jesús laqui̱mpi̱ natlahuaniko̱ hua̱ntu̱ xlacapa̱stacniko̱nit. ");
INSERT INTO tosNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Acxni̱ tropa̱ xle̱ma̱kó̱ Jesús laqui̱mpi̱ napakaxtokohuacako̱y, c-tiji̱ pa̱xtokko̱lh cha̱tum chixcú̱ xala c-Cirene, xuanicán Simón; xlá̱ quí̱lalh ca̱tuhuá̱n, chipako̱lh tropa̱, chu̱ juerza tlahuaniko̱lh, ma̱pakxtu̱koka̱ko̱lh pi̱ nata̱lé̱n Jesús xcruz c-xka̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhu̱hua tachixcuhuí̱tat csta̱lama̱kó̱ anta̱ni̱ namakni̱cán Jesús, chu̱ lhu̱hua lacchaján xtasama̱kó̱ caj la̱ntla̱ xlakli̱puhuama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Cha̱nchu̱ talakaspitniko̱lh Jesús, huaniko̱lh: —Huixín lacchaján xala c-Jerusalén, ni̱ caquilaktasátit quit, huata xatlá̱n miacstucán caca̱lakli̱puhuancántit, chu̱ mincamancán, caj xpa̱lacata̱ hua̱ntu̱ naca̱akspulayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sa̱mpi̱ namín quilhtamacú̱ acxni̱ nahuancán: ‘Cha̱pa̱xuhua̱na̱ lama̱kó̱ hua̱nti̱ ni̱tú̱ kalhi̱ko̱y xcamancán, yama̱ lacchaján hua̱nti̱ luhua caj chuná̱ ni̱ lalh ma̱lakatuncuhuí̱nalh, chu̱ hua̱nti̱ ni̱ ma̱tziqui̱nanko̱lh.’ ");
INSERT INTO tosNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa̱mpi̱ acxni̱ yama̱ quilhtamacú̱ lhu̱hua̱ hua̱nti̱ nahuanko̱y: ‘Huata xatlá̱n xquinca̱aktalamín ka̱sti̱ní̱n, usuchí̱ xquinca̱matzékni̱ tlanca sipi̱ laqui̱mpi̱ ni̱ naquinca̱lakcha̱ná̱n yama̱ tapa̱tí̱n hua̱ntu̱ talacatzuhui̱ma̱.’ ");
INSERT INTO tosNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pus luhua caj caucxílhtit, lapi̱ chuná̱ quima̱pa̱ti̱ni̱cán quit ti̱ ni̱tú̱ ctlahuani̱t tu̱ ni̱tlá̱n, ¿tú ni̱ natlahuaniko̱y hua̱nti̱ ni̱tlá̱n tu̱ tlahuako̱ni̱t? ");
INSERT INTO tosNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na̱ xta̱le̱ma̱ca̱ a̱cha̱tuy makni̱naní̱n laqui̱mpi̱ lacxtum nata̱pakaxtokohuacako̱cán Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Acxni̱ li̱cha̱nko̱ca̱ c-aktum ka̱stí̱n huanicán La Calavera; antá̱ pakaxtokohuacaca̱ Jesús, xa̱hua̱ yama̱ cha̱tuy chixcuhuí̱n, cha̱tum c-xpakstácat, chi̱nchu̱ hua̱ a̱cha̱tum c-xpakxuqui. ");
INSERT INTO tosNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Acxni̱ luhua xpakaxtokohuacama̱ca̱ Jesús, xlá̱ chuná̱ huá̱: —Tla̱ti Dios, cama̱tzanka̱nanikó̱ hua̱ntu̱ quintlahuanima̱kó̱, sa̱mpi̱ xlacán ni̱ catzi̱ko̱y tlanca tala̱kalhí̱n hua̱ntu̱ la̱nchiyú̱ ma̱kantaxti̱ma̱kó̱. Yama̱ tropa̱ tzucuko̱lh caj li̱maca̱nko̱y suerte xatí̱ luhua nalakchá̱n nalé̱n xlhaka̱t Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lhu̱hua tachixcuhuí̱tat antá̱ xucxilhma̱kó̱, chu̱ hasta na̱ chuná̱ a̱ma̱ xanapuxcun judíos xminko̱ni̱t li̱kalhakama̱nanko̱y, chu̱ chuná̱ xuanko̱y: —Tama̱ chixcú, mat tla̱n lakma̱xtuko̱ni̱t lhu̱hua a̱makapitzí̱n, pus huata chú̱ xacstu calakma̱xtuca̱, chu̱ catáactalh c-cruz lapi̱ xli̱ca̱na̱ chú̱ hua̱ yamá̱ lakma̱xtuná, usu Mesías hua̱nti̱ lacsacni̱t Dios naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Na̱ chuná̱ tropa̱ xali̱kamá̱n xtlahuako̱y; xlaktalacatzuhui̱ko̱y laqui̱mpi̱ nali̱kalhtoklhko̱y nama̱hui̱ko̱y vinagre. ");
INSERT INTO tosNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chuná̱ xuaniko̱y: —Hua̱ lapi̱ xli̱ca̱na̱ huix xreycan judíos, pus chiyú̱ caacstulakma̱xtuca. ");
INSERT INTO tosNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nac xacpu̱n cruz anta̱ni̱ xuaca̱ Jesús, cxtokohuacacani̱t ti̱tzu̱ tama, antá̱ xtzokcani̱t xatachihui̱n hebreo, latín, chu̱ griego, chu̱ chuná̱ xuan: “Hua̱ yuma̱ chixcú, xreycan judíos.” ");
INSERT INTO tosNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cha̱nchu̱ cha̱tum ti̱ antá̱ lacxtum xta̱pakaxtokohuacacani̱t, xlacaquilhni̱huacama̱, xuanima̱: —¡Hua̱ lapi̱ xli̱ca̱na̱ huix yuma̱ Cristo hua̱nti̱ namín quinca̱lakma̱xtuyá̱n, pus chú̱ caacstulakma̱xtuca, chu̱ na̱ caquinca̱lakma̱xtu! ");
INSERT INTO tosNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hua̱mpi̱ kalhtí̱nalh a̱cha̱tum, quílhni̱lh; huánilh: —¿Pi̱ ni̱ tzinú̱ huix lacapuhuaniya̱ Dios, ma̱squi na̱ antá̱ ma̱n ta̱pa̱ti̱námpa̱t, chu̱ ní̱pa̱t? ");
INSERT INTO tosNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Quin ma̱squi chuná̱ pa̱ti̱nama̱hu luhua catzi̱ya̱hu pi̱ chuná̱ quinca̱mini̱niyá̱n, sa̱mpi̱ chuná̱ li̱xoko̱nama̱hu hua̱ntu̱ tlahuani̱tahu, hua̱mpi̱ yuma̱ chixcú̱ ni̱tú̱ tlahuama̱ pala tú̱ ni̱tlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Xlá̱ lakláca̱lh Jesús, chu̱ chuná̱ huánilh: —Quimpu̱china Jesús, xtlahua̱ tlanca li̱tlá̱n xquilacapa̱stacpi̱ acxni̱ huix natzucuya̱ ma̱paksi̱nana̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kálhti̱lh: —Luhua xli̱ca̱na̱ cuaniyá̱n, pi̱ chuj tuncán yuma̱ quilhtamacú̱ lacxtum quinta̱huilapi nahuán yama̱ ca̱li̱lakáti̱t pu̱táhui̱lh anta̱ni̱ huí̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ma̱x pala ca̱tastúnut xuani̱t acxni̱ titapaklhtú̱ti̱lh xli̱ca̱tlanca̱ ca̱tuxá̱huat, hasta pala ca̱maktutu hora ca̱ko̱tanú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tama̱ chichiní, titalakapaklhtú̱ti̱lh, chu̱ yama̱ tlanca lháka̱t tu̱ xli̱lakatlapa̱nancán c-tlanca templo pu̱makatuy tihua̱ la̱ntla̱ titalácxti̱tli̱ xacstu. ");
INSERT INTO tosNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chu̱ luhua acxni̱ Jesús chuná̱ tásalh: —¡Tla̱ti Dios, chú̱ antá̱ c-mimacán cmakaxtaka̱ quili̱stacna! Acxni̱ chuná̱ tichihui̱nanko̱lh, aya ni̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yama̱ capitán romano, acxni̱ úcxilhli̱ hua̱ntu̱ xqui̱taxtuni̱t, xlá̱ lacapá̱stacli̱ Dios, chu̱ chuná̱ huá̱: —Xli̱ca̱na̱ yuma̱ chixcú̱ ni̱tú̱ xkalhi̱y cuenta̱. ");
INSERT INTO tosNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Xli̱pacs li̱lhu̱hua̱ hua̱nti̱ antá̱ xlaya̱kó̱, chu̱ hua̱nti̱ ucxilhko̱lh pacs tu̱ xkantaxtuni̱t, lacapala̱ tapa̱nu̱ko̱lh, taspitko̱lh c-xchiccán, chu̱ caj la̱ntla̱ xtali̱puhua̱ncán xcuxmu̱kaxiti̱lhako̱cán. ");
INSERT INTO tosNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hua̱ chú̱ xli̱pacs xta̱la̱lakapasní̱n, chu̱ makapitzi̱n lacchaján ti̱ lacxtum cta̱minko̱ni̱tanchá̱ c-Galilea, xlacán antá̱ tzinu̱ tlak lakamákat xlacaya̱kó̱, chu̱ xucxilhma̱kó̱ pacs hua̱ntu̱ xqui̱taxtuma̱. ");
INSERT INTO tosNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Antá̱ xlama̱ cha̱tum chixcú̱ hua̱nti̱ na̱ xta̱tapaksi̱ko̱y judíos hua̱nti̱ xmakma̱paksi̱nanko̱y c-Jerusalén, xlá̱ luhua tla̱n xcatzi̱y, chu̱ luhua aksti̱tum xlama̱ c-xlacati̱n Dios, xlá̱ xuanicán José xala c-Arimatea, u̱ma̱ ca̱chiquí̱n antá̱ xtapaksi̱y c-Judea. ");
INSERT INTO tosNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Hua̱ yuma̱ chixcú̱ ni̱tlá̱n tláhualh hua̱ntu̱ xta̱makma̱paksi̱naní̱n xtlahuaniko̱ni̱t Jesús, sa̱mpi̱ xlá̱ na̱ aya xkalhkalhi̱ma̱ acxni̱ la̱ntla̱ Dios nama̱tzuqui̱y xasa̱sti xtapáksi̱t ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pus hua̱ chú̱ tzaj lákalh Pilato, chu̱ squínilh li̱tlá̱n pi̱ camacamá̱xqui̱lh xtiyatli̱hua Jesús laqui̱mpi̱ nama̱acnu̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato tla̱n tláhualh hua̱ntu̱ huánilh, chu̱ xlá̱ álh anta̱ni̱ cxtokohuacacani̱t, chu̱ acxni̱ ma̱acti̱ko̱lh c-cruz, pu̱máksuitli̱ mactum tlanca lháka̱t, chu̱ le̱lh c-aktum tahuaxni̱ anta̱ni̱ ni̱tí̱ xa̱ma̱nu̱cán ni̱n. Yama̱ tahuaxni, c-xlacan chíhuix xpaklhcani̱t, chu̱ antá̱ pu̱huíli̱lh xtiyatli̱hua̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hua̱ yama̱ quilhtamacú̱ acxni̱ chuná̱ ti̱táxtulh viernes xuani̱t, ca̱ko̱tanú̱n acxni̱ aya xlakcha̱ma̱ quilhtamacú̱ la̱ntla̱ jaxcán. ");
INSERT INTO tosNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cha̱nchu̱ hua̱ lacchaján hua̱nti̱ xta̱minko̱ni̱tanchá̱ Jesús c-Galilea, xlacán sta̱laniko̱lh José, chu̱ ucxilhko̱lh anta̱ni̱ ma̱acnu̱ca̱ xtiyatli̱hua. ");
INSERT INTO tosNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Acxni̱ chu̱ qui̱tapu̱spitko̱lh, chinko̱lh c-chiqui, chu̱ antá̱ lakca̱xtlahuako̱lh xamu̱clhun lí̱cuchun, chu̱ perfume, chu̱ li̱cha̱lí̱ jaxko̱lh sa̱mpi̱ luhua chuná̱ xuí̱ li̱ma̱paksí̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Luhua tzi̱sacu domingo, yama̱ lacchaján lacapala̱ anko̱lh c-lhucu̱ anta̱ni̱ xma̱acnu̱cani̱t ni̱n, chu̱ xle̱ma̱kó̱ xamu̱clhun lí̱cuchun tu̱ xlakca̱xtlahuako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Acxni̱ antá̱ cha̱nko̱lh c-lhucu, ucxilhko̱lh pi̱ anta̱ni̱ xuili̱cani̱t nia̱lh antá̱ xuí̱ yama̱ chíhuix hua̱ntu̱ xli̱lakatalacani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xlacán lacapala̱ tanu̱ko̱lh c-lhucu, hua̱mpi̱ ni̱tú̱ ucxilhko̱lh xtiyatli̱hua Quimpuchinacan Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xlacán xpe̱cuaxni̱ko̱ni̱t, chu̱ hasta ni̱ xcatzi̱ko̱y xatú̱ luhua xlani̱t, caj xalán acxni̱ la̱ntla̱ lakata̱yako̱chi̱ cha̱tuy chixcuhuí̱n, hua̱mpi̱ luhua laksnapapán, chu̱ lakstalankán xlha̱ka̱tcán hua̱ntu̱ xlhaka̱ko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Caj la̱ntla̱ xlacán xtape̱cuacán lakatatzokostako̱lh hasta ca̱tiyatna, hua̱mpi̱ yama̱ chixcuhuí̱n chuná̱ huaniko̱lh: —¿Tú̱ xpa̱lacata putzayá̱tit c-xlaksti̱pa̱ncan ni̱ní̱n hua̱nti̱ lama̱ xastacná? ");
INSERT INTO tosNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús u̱nú̱ xlá̱ ni̱tí̱ acxnu̱y, sa̱mpi̱ lakastakuanani̱t ca̱li̱ní̱n. ¿Lá̱ntla̱ pi̱ nia̱lh lacapa̱stacá̱tit hua̱ntu̱ xlá̱ ca̱huanín acxni̱ lacxtum xca̱ta̱lamá̱n c-Galilea? ");
INSERT INTO tosNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xlá̱ tica̱huanín pi̱ namacama̱sta̱cán c-xmacancan lacli̱xcajnit chixcuhuí̱n. Xlacán napakaxtokohuacako̱y c-cruz, hua̱mpi̱ caj xliaktutu quilhtamacú̱ xlá̱ nalakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yama̱ lacchaján acxnicú̱ chú̱ lacapa̱stacko̱lh xtachihui̱n Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Acxni̱ qui̱taspitko̱lh c-lhucu, tuncán tzucuko̱lh li̱ta̱chihui̱nanko̱y xkalhaca̱huitucan apóstoles, chu̱ a̱makapitzí̱n xpa̱lacata xli̱pacs hua̱ntu̱ xqui̱ucxilhko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hua̱ yuma̱ lacchaján hua̱nti̱ anko̱lh ma̱catzi̱ni̱ko̱y apóstoles hua̱ntu̱ xlacán xqui̱ucxilhko̱ni̱t chuná̱ xuaniko̱cán: María Magdalena, Juana, María xtzi Santiago, chu̱ a̱makapitzi̱n lacchaján. ");
INSERT INTO tosNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Hua̱mpi̱ huata xapóstoles Jesús, ni̱ pala tzinú̱ ca̱najlako̱lh hua̱ntu̱ xlacán xquilhuama̱kó̱, sa̱mpi̱ xpuhuanko̱y pi̱ ma̱x caj xakuitiko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Huata Pedro lacapala̱ táxtulh, chu̱ takosú̱n álh c-lhucu̱ anta̱ni̱ xma̱nu̱cani̱t xtiyatli̱hua Jesús. Acxni̱ talacánu̱lh c-xpu̱lacni, ni̱tú̱ úcxilhli̱ xacha̱tumi̱nica Jesús, caj xma̱n huá̱ xma̱kó̱ lháka̱t hua̱ntu̱ xli̱maksuitcani̱t. Luhua chí̱ lanaj lacahuani̱t taspitpá̱ c-chiqui, luhua xlacapa̱stacti̱lhay hua̱ntu̱ xkantaxtuni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Huatiya̱ yama̱ quilhtamacú̱, cha̱tuy hua̱nti̱ xli̱pa̱huanko̱y Jesús, xtiji̱tla̱huama̱kó̱ xama̱kó̱ c-aktum actzu̱ ca̱chiquí̱n anta̱ni̱ huanicán Emaús, juerza tzinu̱ lakamákat xuani̱t, ma̱x pala akca̱huitu kilómetro hasta la̱ntla̱ c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xlacán huá̱ xli̱kalhchihui̱nanti̱lhako̱y yama̱ catu̱huá̱ hua̱ntu̱ xlani̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tílalh pi̱ la̱ntla̱ xlacán xKalhchihui̱nanti̱lhako̱y, luhua huatiyá̱ Jesús ma̱ta̱xtucko̱lh, chu̱ lacxtum tzúculh ta̱tla̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Hua̱mpi̱ ma̱squi xucxilhma̱kó̱, ni̱ lalh lakapasko̱lh pi̱ hua Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Puschí̱ Jesús chuná̱ kalhasquinko̱lh: —¿Tú̱ tachihuí̱n yumá̱ hua̱ntu̱ huixín la̱li̱xakatli̱ti̱lhayá̱tit? ¿Túcu li̱li̱puhuampá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cha̱nchu̱ cha̱tum hua̱nti̱ xuanicán Cleofas, chuná̱ kálhti̱lh: —Xli̱pacs catzi̱cán hua̱ntu̱ lani̱t ni̱ naj máka̱s c-Jerusalén. ¿Lá̱ntla̱ pi̱ ca̱ta caj miacstu chú̱ antá̱ tampi, chu̱ ni̱ catzi̱ya̱ hua̱ntu̱ antá̱ li̱chihui̱nama̱ca̱? ");
INSERT INTO tosNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús huaniko̱lh: —Hua̱mpi̱ caquihuanítit, ¿tú̱ chi̱nchu̱ lani̱t? Xlacán chuná̱ huaniko̱lh: —Hua̱ntu̱ akspúlalh Jesús xala c-Nazaret. Quin xacli̱pu̱lhca̱ya̱hu la̱ntla̱ xli̱ca̱na̱ tlanca, chu̱ tali̱pa̱hu xakchihui̱na Dios, caj xpa̱lacata̱ pi̱ luhua lacatancs xchihui̱nán, chu̱ na̱ xkalhi̱y li̱tlihuaka, chu̱ tla̱n xtlahuako̱y lactlanca li̱ca̱cni tatatlahu c-xlacati̱ncan tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hua̱mpi̱ xanapuxcun pa̱lijni, chu̱ quima̱paksi̱nacán ma̱lacapu̱ko̱lh laqui̱mpi̱ nama̱pa̱ti̱ni̱cán, chu̱ chuná̱ namakni̱cán, chu̱ hasta tu̱xamata viernes la̱ntla̱ pakaxtokohuacaca̱ c-cruz. ");
INSERT INTO tosNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Quin luhua xacli̱pa̱huana̱hu, sa̱mpi̱ xacpuhuana̱hu pi̱ hua̱ Cristo hua̱nti̱ naquinca̱lakma̱xtuyá̱n xli̱pacs quin hua̱nti̱ xala c-Israel. ");
INSERT INTO tosNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma̱squi chá̱ huatiya̱ yuma̱ quilhtamacu̱ acxni̱ spalh ca̱xkakako̱lh, makapitzi̱n lacchaján hua̱nti̱ qui̱lako̱lh c-lhucu̱ anta̱ni̱ xma̱cnu̱cani̱t Jesús, tla̱n quinca̱maka̱klhán. ");
INSERT INTO tosNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Sa̱mpi̱ acxni̱ qui̱taspitko̱lh quinca̱huanín pi̱ mat ni̱tú̱ xtanu̱ma̱ xtiyatli̱hua Jesús, chu̱ xa̱huachí̱ mat cha̱tuy ángeles xtasiyuniko̱ni̱t, hua̱ chú̱ chuná̱ huaniko̱lh pi̱ mat xlama xastacná̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na̱ caj li̱puntzú̱ qui̱lako̱lh makapitzí̱n quinta̱ca̱najlani̱ncán hasta c-lhucu̱ anta̱ni̱ ma̱nu̱ca̱ xtiyatli̱hua̱, hua̱mpi̱ xli̱ca̱na̱ chuná̱ ma̱noklhuko̱lh la̱ntla̱ xuanko̱ni̱t yama̱ lacchaján, hua̱mpi̱ hua̱ chú̱ Jesús, ni̱tí̱ ucxilhko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Cha̱nchu̱ Jesús chuná̱ huaniko̱lh yama̱ xli̱ma̱kalhtahuáka̱t. —¡Koxutaní̱n huixín, luhua xli̱ca̱na̱ lhu̱hua̱ ca̱tzanka̱niyá̱n talacapa̱stacni! Xli̱ca̱na̱ pi̱ ni̱ lay ca̱najlayá̱tit hua̱ntu̱ tili̱chihui̱nanko̱lh xalakmaka̱n profetas acxni̱ tzokko̱lh hua̱ntu̱ naakspulay tama̱ Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Lá̱ntla̱ pi̱ ni̱ catzi̱yá̱tit pi̱ luhua xlacasquinca xuani̱t chuná̱ nalakchá̱n yama̱ Cristo hua̱nti̱ naminá̱n ca̱lakma̱xtuyá̱n? Sa̱mpi̱ chuná̱ xlaclhca̱huili̱cani̱t pi̱ xlá̱ pu̱laná̱ napa̱ti̱y hua̱ntu̱ aya pá̱ti̱lh, chú̱ laqui̱mpi̱ chuná̱ tla̱n namacama̱xqui̱cán yama̱ tlanca pu̱táhui̱lh c-akapú̱n hua̱ntu̱ nakalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Cha̱nchu̱ tzúculh ma̱lacti̱tumi̱niko̱y hua̱ntu̱ huan c-Li̱kalhtahuaka̱ anta̱ni̱ li̱chihui̱nán xlatama̱t ti̱ namín Cristo, ma̱tzuqui̱niko̱lh c-xlibro Moisés, chu̱ li̱ma̱sputuniko̱lh hua̱ntu̱ huanko̱y c-xtalaktzokqui̱ncan xalakmaka̱n profetas xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Acxni̱ cha̱nko̱lh c-Emaús, Jesús kas tlahuaniko̱lh la̱mpala ti̱tum xama̱. ");
INSERT INTO tosNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Hua̱mpi̱ xlacán fuerza squiniko̱lh pi̱ cata̱tamakaxtakko̱lh, chu̱ chuná̱ huaniko̱lh: —Catlahua̱ li̱tlá̱n, caquinca̱ta̱tamakáxtakti̱ u̱nú̱ ca̱chiquí̱n, sa̱mpi̱ la̱nchú̱ aya ko̱tanu̱y, aya ani̱t quilhtamacú̱. Puschí̱ xlá̱ ta̱tanu̱ko̱lh c-chiqui̱ anta̱ni̱ nalaktuncuhuiko̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Cha̱nchu̱ tílalh, pi̱ acxni̱ tahuilako̱lh c-pu̱hua̱y, Jesús tíyalh mactum caxtala̱nchu̱, pa̱xcatcatzí̱nilh Dios xlí̱huat, lakchákalh, chu̱ ma̱xqui̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Luhua acxnitiyá̱ xlakastapucán actancs tili̱lacahuá̱nanko̱lh, chu̱ lakapasko̱lh pi̱ hua̱ Jesús; hua̱mpi̱ acxnitiyá̱ xlá̱ caj xalán nia̱lh tasíyulh. ");
INSERT INTO tosNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xacstucán chuná̱ tzucuko̱lh la̱huaniko̱y cha̱tunu cha̱tunu: —Luhua xli̱ca̱na̱ pi̱ c-quinacu̱cán hasta aktziyaj xcatzán acxni̱ xlá̱ xquinca̱xakatli̱ti̱lhayá̱n c-tiji, chu̱ xquinca̱ma̱lacatancsaniyá̱n hua̱ntu̱ tatzoktahuilani̱t xtachihui̱n Dios c-Li̱kalhtahuaka. ");
INSERT INTO tosNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Cha̱nchu̱ ni̱tú̱ makakalhi̱ko̱lh, lacapala̱ titaca̱xko̱lh huatiya̱ a̱ma̱ hora, chu̱ ampalako̱lh c-Jerusalén, chu̱ antá̱ lakcha̱nko̱lh anta̱ni̱ xtamakstokko̱ni̱t xakalhaca̱huitu̱ apóstoles, chu̱ a̱makapitzí̱n hua̱nti̱ xli̱pa̱huanko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Huata xlacán chuná̱ huaniko̱lh: —Xli̱ca̱na̱ pi̱ lakastakuanani̱t ca̱li̱ní̱n Quimpu̱chinacán sa̱mpi̱ tasiyúnilh Simón Pedro. ");
INSERT INTO tosNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cha̱nchu̱ yama̱ cha̱tuy hua̱nti̱ a̱cu cha̱nko̱lh c-Jerusalén, na̱ tzucuko̱lh huanko̱y la̱ntla̱ ta̱tanoklhko̱lh c-tiji̱ cha̱tum chixcú, chu̱ na̱ huanko̱lh la̱ntla̱ lakapasko̱lh Jesús acxni̱ xlá̱ lakchákalh caxtala̱nchu̱. ");
INSERT INTO tosNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Xlacán chunacú̱ xchihui̱nama̱kó̱ acxni̱ Jesús íta̱t ca̱lakata̱yachá̱, chu̱ chuná̱ xakatli̱ko̱lh: —¡Cakalhí̱tit huixín tapa̱xuhuá̱n! ");
INSERT INTO tosNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pacs li̱pe̱cua̱ tipe̱cuanko̱lh, xpuhuanko̱y pi̱ ma̱x caj ni̱n xucxilhma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —¿Tú̱huan aklituanani̱tántit, chu̱ lhpipak layá̱tit? ¿Tú̱huan ni̱ lay li̱ca̱najlayá̱tit minacu̱cán pi̱ quit clama̱ xastacná? ");
INSERT INTO tosNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xa̱huachí̱ caucxílhtit quimacán, chu̱ quintuhuaní̱n, pi̱ xli̱ca̱na̱ quit. Ma̱squi luhua caquixamátit, chu̱ caquiucxílhtit sa̱mpi̱ cha̱tum ni̱n ni̱tú̱ kalhi̱y xli̱hua, ni̱ pala xlúcut la̱ntla̱ ucxilhá̱tit quit ckalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Acxni̱ chuná̱ huaniko̱lh, ma̱siyuniko̱lh xmacaní̱n, chu̱ xtuhuaní̱n laqui̱mpi̱ naca̱najlako̱y pi̱ xli̱ca̱na̱ xastacná. ");
INSERT INTO tosNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hua̱mpi̱ caj la̱ntla̱ xlacán xpa̱xuhuama̱kó̱, ni̱ lay xca̱najlako̱y hua̱ntu̱ xucxilhma̱kó̱, Jesús kalhasquinko̱lh: —¿Tú̱ kalhi̱yá̱tit u̱nú̱ pala tú̱ actzu̱ lí̱huat? ");
INSERT INTO tosNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Puschí̱ cha̱tum má̱xqui̱lh actzu̱ xataxpupu squi̱ti, chu̱ pakchu̱ cera̱. ");
INSERT INTO tosNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xlá̱ maklhtí̱nalh, chu̱ antá̱ c-xlacati̱ncán hualh. ");
INSERT INTO tosNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A̱li̱sta̱lh chuná̱ huaniko̱lh: —Umá̱ hua̱ntu̱ quit quiakspulani̱t, pus hasta huatiyá̱ yamá̱ hua̱ntu̱ ctica̱huanín acxni̱ lacxtum xacca̱ta̱lapu̱layá̱n, xpa̱lacata̱ pi̱ juerza xli̱kantáxtut xuani̱t hua̱ntu̱ tatzoktahuilani̱t caj quimpa̱lacata c-xtatzoknu̱n Moisés, chu̱ c-xlibrojcan profetas, xa̱hua̱ c-Salmos. ");
INSERT INTO tosNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cha̱nchu̱ pacs ma̱akata̱ksni̱ko̱lh hua̱ntu̱ xtatzoktahuilani̱t xtachihui̱n Dios c-Li̱kalhtahuaka̱ xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A̱li̱sta̱lh chuná̱ huaniko̱lh: —Pus chuná̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ pi̱ quit Cristo, juerza quilí̱ni̱t xuani̱t, hua̱mpi̱ caj xliaktutu quilhtamacú̱ naclakastakuanán ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Chu̱ na̱ chuná̱ tatzokni̱t pi̱ nama̱akahuani̱cán quintachihuí̱n c-xli̱ca̱tlanca̱ ca̱tuxá̱huat, nama̱tzuqui̱cán c-Jerusalén. Nali̱akchihui̱nancán pi̱ xlacasquinca̱ pacs tachixcuhuí̱tat nalakpali̱ko̱y xali̱xcajnit xtalacapa̱stacnicán laqui̱mpi̱ chuná tla̱n nama̱tzanka̱naniko̱cán xtala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Huixín testigos, chu̱ nama̱luloká̱tit cani̱huá̱ pi̱ xli̱ca̱na̱ chuná̱ qui̱taxtuni̱t. ");
INSERT INTO tosNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xa̱huachí̱ quit nacmacamín c-milatama̱tcán hua̱ntu̱ Quintla̱t ma̱lacnu̱ni̱t; hua̱mpi̱ ni̱ napiná̱tit a̱lacatanu̱ ca̱chiquí̱n, antá̱ u̱nú̱ c-Jerusalén natamakaxtaká̱tit hasta acxni̱ namaklhti̱naná̱tit yama̱ tlanca li̱tlihuaka̱ hua̱ntu̱ namina̱chá̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A̱li̱sta̱lh Jesús le̱nko̱lh c-Betania, chu̱ acxni̱ antá̱ cha̱nko̱lh xlá̱ chaxli̱ xmacán laqui̱mpi̱ nasiculana̱tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cha̱nchu̱ tílalh pi̱ la̱ntla̱ csiculana̱tlahuama̱kó̱ tzúculh tata̱lhma̱ni̱y, chu̱ le̱nca̱ c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","A̱li̱sta̱lh acxni̱ xlacán xca̱cni̱naniko̱ni̱ttá, titapu̱spitko̱lh c-Jerusalén, hua̱mpi̱ luhua xpa̱xuhuama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ankalhí̱n xanko̱y c-tlanca templo laqui̱mpi̱ antá̱ natastokko̱y, chu̱ xankalhin macxtum xmakapa̱xuhuako̱y Dios.");
INSERT INTO tosNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Acxni̱ ni̱ naj tú̱ xanán, yama̱ hua̱nti̱ huanicán Tachihuí̱n na̱ xlamajá, pus yama̱ Tachihuí̱n na̱ lacxtum xta̱lama̱ Quintla̱tican Dios, sa̱mpi̱ xlá̱ na̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pus acxnicú̱ pacs pu̱tum quilhtzúculh, xlá̱ antiyá̱ lacxtum xta̱lama̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xlá̱ pacs maktlahuani̱t hua̱ntu̱ anán, chu̱ ni̱tú̱ anán lapi̱ xlá̱ ni̱ maktlahuani̱t hua̱ntu̱ ma̱lacatzucuni̱t Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hua̱ tama̱ Tachihuí̱n, caj huá̱ xpa̱lacata ma̱squi kalhi̱ko̱lh latáma̱t caxatu̱cahuá̱ tu̱ xanán, chu̱ huatiya̱ tamá̱ ti̱ má̱sta̱lh aktum li̱stacna̱ li̱táxtulh xkakánat ti̱ namakskoniko̱y tachixcuhuí̱tat laqui̱mpi̱ xaxli̱ca̱na̱ nali̱lacahua̱nanko̱y c-xlatama̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Xlá̱ milh ta̱latama̱ko̱y hua̱nti̱ ca̱paklhtu̱tá̱ xlama̱kó̱ laqui̱mpi̱ namakskoniko̱y cxkakánat, huata xlacán tzaksako̱lh xma̱mixiputunko̱y, hua̱mpi̱ ni̱ lay ma̱mixiko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios macámilh yuma̱ cscujni̱ hua̱nti̱ xuanicán Juan, ");
INSERT INTO tosNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","laqui̱mpi̱ xlá̱ nali̱chihui̱nán tama̱ xkakánat, chu̱ laqui̱mpi̱ hua̱nti̱ nakaxmatniko̱y xtachihuí̱n naca̱najlaniko̱y hua̱ntu̱ nahuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ni̱ huá̱ lí̱milh pi̱ la̱ xkakánat nali̱taxtuy ca̱tuxá̱huat, pus xlá̱ caj xma̱lakacha̱cani̱t laqui̱mpi̱ nali̱chihui̱nán yama̱ xkakánat hua̱nti̱ namín laqui̱mpi̱ pacs nalakapasko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hua̱ tama̱ Tachihuí̱n hua̱nti̱ xli̱ca̱na̱ kalhi̱y yama̱ xkakánat hua̱ntu̱ ma̱xqui̱ko̱y stalanca talacapa̱stacni̱ xli̱pacs tachixcuhuí̱tat, hua̱ xlá̱ ti̱ xmima̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Antá̱ ca̱tuxá̱huat xlama̱, hua̱mpi̱ ma̱squi huá̱ titláhualh ca̱tuxá̱huat, hua̱mpi̱ chunatá ni̱ tilakapasko̱lh hua̱nti̱ xala ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cha̱nchu̱ yama̱ ca̱chiquí̱n hua̱ntu̱ xlacsacni̱t laqui̱mpi̱ antá̱ nalacachín, hua̱nti̱ antá̱ xuilakó̱, huachá̱ ti̱ xnata̱chiquí̱n, ni̱ makamaklhti̱nanko̱lh c-xnacu̱cán. ");
INSERT INTO tosNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Hua̱mpi̱ yama̱ makapitzí̱n hua̱nti̱ li̱pa̱huanko̱lh xtachihuí̱n, chu̱ ma̱xqui̱ko̱lh xpu̱táhui̱lh c-xli̱stacnacán, xta̱chuná̱ pala lacachimpalako̱lh a̱maktum, chu̱ chuná̱ luhua xcaman Dios li̱ma̱xtuko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hua̱ yumá̱ hua̱nti̱ lacachinko̱lh xli̱maktuy laqui̱mpi̱ xcaman Dios nahuanko̱y, huá̱ chuná̱ li̱lacachinko̱lh xli̱maktuy sa̱mpi̱ huá̱ Dios ma̱xqui̱ko̱lh aktum xasa̱sti xlatama̱tcán hua̱ntu̱ chú̱ kalhi̱ko̱y, hua̱mpi̱ ni̱ xta̱chuná̱ qui̱táxtulh la̱ acxni̱ xtzi, chu̱ xtla̱tcán ma̱xqui̱ko̱lh xlatama̱tcán hua̱ntu̱ xala yuma̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yama̱ Tachihuí̱n qui̱tachixcuhuili̱chi̱ xta̱chuná̱ cha̱tum skata, chu̱ c-quilaksti̱pa̱ncán qui̱latama̱chi̱ la̱ntla̱ caj cha̱tum chixcú, xlá̱ qui̱ma̱siyuchi̱ c-xlatáma̱t xtalakalhamá̱n Dios, chu̱ la̱ntla̱ luhua tali̱pa̱hu xlá. Cha̱nchu̱ quin cucxilhui̱ tlanca xli̱ca̱cni̱ tu̱ xkalhi̱y, chu̱ ccatzi̱ya̱hu pi̱ hua̱ Dios ma̱xqui̱ni̱t yuma̱ xli̱ca̱cni̱ xta̱chuná̱ la̱ntla̱ tu̱ mini̱niy kalhi̱y hua̱nti̱ xma̱n hua̱ xta̱stum xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan maktum acxni̱ xli̱chihui̱nama̱ c-xlacati̱ncan tachixcuhuí̱tat, acxni̱ úcxilhli̱ xmima̱ Jesús, pixtlanca̱ quílhalh, chu̱ na̱má̱ huá̱: “Hua̱ tama̱ chixcú̱ hua̱nti̱ xacli̱chihui̱nama̱ acxni̱ chuná̱ cuá̱: ‘A̱li̱sta̱lh mima̱ a̱cha̱tum ti̱ tlak kalhi̱y tlanca xlacatzúcut ni̱ xahua̱ la̱ quit, sa̱mpi̱ xlá̱ aya xlama̱ hasta acxni̱ quit ni̱ naj tí̱ xaclama̱.’” ");
INSERT INTO tosNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Caj xpa̱lacata yama̱ tlanca xtalakalhamá̱n, chu̱ xtapá̱xqui̱t tu̱ xkalhi̱y li̱pe̱cua̱ quinca̱makta̱yani̱tán la̱ntla̱ li̱pa̱xuhu, chu̱ aktziyaj quinca̱huili̱ni̱tán c-quilatama̱tcán, chu̱ ni̱ caj maktum sa̱mpi̱ caj xpa̱lacata tlanca xtalakalhamá̱n makcatzi xquinca̱siculana̱tlahuati̱lhayá̱n maklhu̱hua. ");
INSERT INTO tosNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Hua̱ xamaka̱n Moisés quinca̱tzokta̱qui̱nini̱tán yama̱ li̱pe̱cua xli̱ma̱paksi̱n Dios laqui̱mpi̱ ma̱squi tuhua̱ quin li̱huana̱ quili̱ma̱kantaxti̱tcán xuani̱t, hua̱mpi̱ Jesucristo quinca̱li̱minini̱tán xtapa̱xqui̱t Dios la̱ntla̱ quinca̱lakalhamamputuná̱n chu̱ quinca̱ma̱tzanka̱naniputuná̱n quintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Na̱ chuná̱ ma̱squi ni̱ pala cha̱tum a̱ucxilha Dios, hua̱mpi̱ huí̱ ti̱ quinca̱ma̱lakapasni̱ni̱tán, hua̱ tama̱ cha̱stum xCam, sa̱mpi̱ xlá̱ na̱ Dios, chu̱ luhua lacxtum ucxla̱ta ta̱kalhi̱y xtalacapa̱stacni Quintla̱tican Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yamá̱ xanapuxcun judíos xala c-Jerusalén ma̱lakacha̱ko̱lh makapitzi̱n xpa̱lijnican judíos, xa̱huá̱ hua̱nti̱ huaniko̱cán levitas laqui̱mpi̱ nakalhasquinko̱y Juan xatú̱ xlá̱ xli̱taxtuy. ");
INSERT INTO tosNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Xlá̱ ni̱tú̱ kalhtátze̱kli, huata luhua lacatancs huaniko̱lh: —Quit ni̱ huá̱ Cristo hua̱nti̱ huixín kalhkalhi̱pá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xlacán tikalhasquimpalako̱lh: —¿Tí̱ chá̱ chí̱ huix? ¿Pi̱ huix chí̱ yama̱ ti̱ xamaka̱n profeta Elías xuani̱t? Juan na̱má̱ huaniko̱lh: —Ni̱ quit. Xlacán kalhasquimpalako̱lh: —Pus, ¿pi̱ huix yama̱ profeta ti̱ pu̱lana̱ xli̱mínat laqui̱mpi̱ a̱li̱sta̱lh namín Cristo? —Ni̱ quit. ");
INSERT INTO tosNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Xlacán na̱má̱ huanipalako̱lh: —Pus ¿tí̱ chí̱ huix? Hua̱nti̱ quinca̱ma̱lakacha̱ni̱tán nacatzi̱putunko̱y tí̱ huix. ¿Lá̱ huix huana̱ mimpa̱lacata? ");
INSERT INTO tosNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan kalhti̱ko̱lh: —Quit yama̱ hua̱nti̱ tili̱chihuí̱nalh profeta Isaías acxni̱ na̱má̱ títzokli̱ xlibro̱: ‘Natakaxmata̱ c-desierto la̱ naakchihui̱nán cha̱tum chixcú, chu̱ na̱má̱ nahuán: Caca̱xtlahuanítit kantum tiji̱ hua̱ntu̱ luhua tzajua̱ anta̱ni̱ nalactla̱huán Quimpu̱chinacán ti̱ namín.’ ");
INSERT INTO tosNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yama̱ chixcuhuí̱n hua̱nti̱ xma̱lakacha̱ko̱ni̱t fariseos, acxni̱ kaxmatko̱lh xtachihui̱n Juan, ");
INSERT INTO tosNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kalhasquimpalako̱lh: —Pala ni̱ huix Cristo, ni̱ pala tama̱ xamaka̱n Elías, chu̱ ni̱ pala yama̱ profeta hua̱nti̱ namín, ¿tú̱ xpa̱lacata chá̱ li̱akmunupa̱kó̱ tachixcuhuí̱tat? ");
INSERT INTO tosNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan chuná̱ huaniko̱lh: —Quit caj xma̱n hua̱ quintascújut pi̱ cli̱akmunu̱nán chúchut, hua̱mpi̱ u̱nú̱ c-milaksti̱pa̱ncán ca̱ta̱lamá̱n cha̱tum chixcú̱ hua̱nti̱ ni̱ lakapasá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xlá̱ a̱cu̱ nama̱tzuqui̱y xtascújut, chu̱ tlak luhua tlanca xlacatzúcut ni̱ xahua̱ quit; pus quit ni̱tú̱ quilakasi hasta ni̱ quimini̱niy nacli̱taxtuy xtasa̱cua nacuán hua̱nti̱ naxcutniy xatasi̱ xtatuhuanu. ");
INSERT INTO tosNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pacs yuma̱ antá̱ qui̱táxtulh lacatzú̱ c-xaca̱chiqui̱n huanicán Betania, a̱li̱quilhtu̱an kalhtu̱choko̱ Jordán anta̱ni̱ xakmunuma̱kó̱ tachixcuhuí̱tat Juan. ");
INSERT INTO tosNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Cha̱nchu̱ li̱cha̱lí̱ yama̱ quilhtamacú̱ Juan úcxilhli̱ Jesús pi̱ xlaktalacatzu̱hui̱ma̱, chu̱ chuná̱ huaniko̱lh hua̱nti̱ antá̱ xta̱ya̱kó̱: “Caucxílhtit, hua̱ a̱ya̱ chixcú̱ ti̱ mima̱, xlá̱ li̱taxtuy xta̱chuná̱ la̱ yama̱ li̱makni̱t borrego hua̱nti̱ Dios lacasquín naxoko̱nán xpa̱lacata̱ tala̱kalhí̱n, chu̱ chuná̱ nali̱chaka̱makaniko̱y tachixcuhuí̱tat xli̱pacs xtala̱kalhi̱ncán hua̱ntu̱ tlahuako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hua̱ tama̱ chixcú̱ hua̱nti̱ quit xacli̱chihui̱nama̱ acxni̱ chuná̱ ctili̱quílhalh: ‘A̱li̱sta̱lh mima̱ a̱cha̱tum hua̱nti̱ tlak kalhi̱y tlanca xlacatzúcut ni̱ xahua̱ quit, sa̱mpi̱ xlá̱ aya xlama̱ acxni̱ quit ni̱ naj xaca̱lacachín.’ ");
INSERT INTO tosNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xli̱ca̱na̱ xlá̱ pi̱ xapu̱lana̱ ni̱ pala quit xaccatzi̱y xatú̱ nali̱taxtuy yamá̱ ti̱ Dios macamini̱t, ma̱squi quit quimacaminca̱ pi̱ nacli̱akmunu̱nán chúchut laqui̱mpi̱ nacma̱catzi̱ni̱nán pi̱ huí̱ ti̱ mima̱, chu̱ acxni̱ naccatzi̱y xatí̱ xlá, chuna chí̱ nacma̱lakapasni̱ko̱y ti̱ xala c-Israel.” ");
INSERT INTO tosNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Cha̱nchu̱ Juan tzúculh huaniko̱y la̱ntla̱ xucxilhni̱t acxni̱ Espíritu Santo xta̱ctama̱chi̱ c-akapú̱n la̱ actzu̱ paloma, chu̱ antá̱ tahuilachi̱ c-xokspun Jesús, chu̱ tapaksí̱nilh. ");
INSERT INTO tosNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Chuná̱ huaniko̱lh: “Quit xapu̱lana̱ ni̱ naj xaccatzi̱y xatí̱ luhua xlá̱ nahuán, hua̱mpi̱ Dios acxni̱ quimacámilh laqui̱mpi̱ nacli̱akmunu̱nán chúchut, chuná̱ quihuánilh: ‘Acxni̱ naucxilha̱ Espíritu Santo ta̱ctama̱chi̱ c-xokspun cha̱tum chixcú, chu̱ antá̱ natamakaxtaka, pus hua̱ tamá̱ ti̱ nali̱akmunu̱nán xli̱tlihuaka Espíritu Santo.’ ");
INSERT INTO tosNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pus quit aya cucxilhni̱t, chu̱ cma̱luloka̱ pi̱ xli̱ca̱na̱ huá̱ xCam Dios.” ");
INSERT INTO tosNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Li̱cha̱li̱ tuncán Juan xta̱laya̱kó̱ cha̱tuy xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cha̱nchu̱ pi̱ antá̱ lacatzú̱ xti̱taxtuma̱ Jesús, Juan cacs lakláca̱lh, chu̱ chuná̱ huaniko̱lh: —Caucxílhtit, hua̱ yama̱ chixcú̱ ti̱ ti̱taxtuma̱, xlá̱ li̱taxtuy xta̱chuná̱ la̱ yama̱ borrego hua̱nti̱ Dios lacasquín naxoko̱nán xpa̱lacata tala̱kalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yama̱ cha̱tuy xli̱ma̱kalhtahuaka̱t Juan acxni̱ kaxmatko̱lh hua̱ntu̱ xlá̱ huá̱, sta̱laniko̱lh Jesús. ");
INSERT INTO tosNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Cha̱nchu̱ acxni̱ talakáspitli̱ Jesús, chu̱ acxni̱ ucxilhko̱lh pi̱ csta̱lanima̱ca̱, chuná̱ huaniko̱lh: —¿Tú̱ putzapá̱tit? Xlacán kalhti̱nanko̱lh: —Ma̱kalhtahuaka̱ná, ¿ní̱ huilapi? ");
INSERT INTO tosNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús kalhti̱ko̱lh: —Catántit, ca̱hu laqui̱mpi̱ nalakapasnaná̱tit. Xlacán ta̱anko̱lh Jesús, chu̱ pi̱ ko̱tanu̱ya xuani̱t acxni̱ cha̱nko̱lh, ma̱x pala ca̱makta̱ti hora, yama̱ chixcuhuí̱n antá̱ tamakaxtakko̱chá. ");
INSERT INTO tosNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yama̱ chixcuhuí̱n hua̱nti̱ kaxmatko̱lh xtachihui̱n Juan, chu̱ hua̱nti̱ sta̱laniko̱lh Jesús, cha̱tum xuanicán Andrés, xta̱la Simón Pedro. ");
INSERT INTO tosNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Huata Andrés pu̱lh alh putzay xta̱la Simón, chu̱ na̱má̱ huánilh: —¡Cta̱ksni̱tahu Mesías hua̱nti̱ naquinca̱lakma̱xtuyá̱n! ");
INSERT INTO tosNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrés tuncán le̱lh Simón anta̱ni̱ xuilachá̱ Jesús, chu̱ acxni̱ Jesús úcxilhli, chuná̱ huánilh: —Huix huanicana̱ Simón xkahuasa Jonás, hua̱mpi̱ quit nacli̱ma̱pa̱cuhui̱yá̱n Cefas (yuma̱ c-xatachihui̱n arameo huamputún Pedro, usu chíhuix). ");
INSERT INTO tosNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Li̱cha̱lí̱ Jesús alh c-xatiyat Galilea, chu̱ antá̱ ta̱tanoklhchá̱ Felipe, chu̱ na̱má̱ huánilh: —Caquista̱lani. ");
INSERT INTO tosNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Hua̱ yuma̱ Felipe, antá̱ xala c-Betsaida xuani̱t, anta̱ni̱ na̱ xuilako̱chá̱ Andrés, chu̱ Pedro. ");
INSERT INTO tosNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Cha̱nchu̱ Felipe, tuncán alh putzay Natanael, chu̱ acxni̱ ta̱ksli chuná̱ huánilh: —Cucxilhni̱tahu yama̱ chixcú̱ hua̱nti̱ tili̱chihui̱nanko̱lh xalakmaka̱n profetas, xa̱hua̱ Moisés, xlá̱ huanicán Jesús xkahuasa José xala c-Nazaret. ");
INSERT INTO tosNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael kalhtí̱nalh: —Ni̱ pala tzinú̱ cca̱najlay. ¿Lá̱ntla̱ nalay chú̱ pi̱ huí̱ ti̱ tla̱n nataxtuya̱chá̱ cha̱tum tali̱pa̱hu chixcú̱ yama̱ c-li̱lakaputza ca̱chiqui̱n Nazaret? Hua̱mpi̱ Felipe chuná̱ huanipá̱: —Pus catat ucxilha̱ laqui̱mpi̱ naca̱najlaya. ");
INSERT INTO tosNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Acxni̱ úcxilhli̱ Jesús pi̱ xlaktalacatzuhui̱ma̱ Natanael, na̱má̱ huá̱: —U̱mín cha̱tum chixcú̱ hua̱nti̱ xli̱ca̱na̱ luhua mini̱niy li̱tapa̱cuhui̱y israelita sa̱mpi̱ xlá̱ niucxni̱ nahuaniyá̱n ta̱ksaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Puschí̱ kalhásquilh Natanael: —¿Lá̱ntla̱ quilakapasa? Jesús huánilh: —Quit pu̱lh cucxilhni̱ acxni̱ xya̱t c-xtampi̱n xaquihui higo, acxni̱ ni̱ xa̱tasaniyá̱n Felipe. ");
INSERT INTO tosNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pus Natanael huánilh: —Ma̱kalhtahuaka̱ná, ¡xli̱ca̱na̱ huix xCam Dios! ¡Huix yama̱ tlanca quireycán ti̱ xli̱mínat xuani̱t laqui̱mpi̱ naquinca̱ma̱paksi̱yá̱n quin hua̱nti̱ xala c-Israel! ");
INSERT INTO tosNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús kálhti̱lh: —Huix quinca̱najlaniya̱ caj xpa̱lacata̱ pi̱ cuanín pi̱ pu̱lh quit cucxilhni̱ acxni̱ xya̱t c-xtampi̱n xaquihui higo. Pus namín quilhtamacú̱ acxni̱ naucxilha̱ huix a̱tzinú̱ lactlanca li̱ca̱cni tascújut hua̱ntu̱ nactlahuay, ni̱ xahua̱ hua̱ntu̱ káxpatti̱ ca̱la̱nchú̱. ");
INSERT INTO tosNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús chuná̱ huampá̱: —Caca̱najlátit tu̱ cca̱huaniyá̱n pi̱ nalakchá̱n quilhtamacú̱ acxni̱ huixín naucxilhá̱tit pi̱ lacqui̱y nahuán akapú̱n, chu̱ xangeles Dios ta̱ctama̱ko̱chi, chu̱ tahuacama̱palako̱y nahuán la̱ntla̱ naquilakataquilhpu̱tako̱y quit Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Cha̱nchu̱ li̱tu̱xama̱, c-xaca̱chiquí̱n huanicán Caná c-xmunicipio Galilea, titlahuaca̱ aktum taca̱tani̱ c-pu̱tapuchuhu. Xtzi Jesús na̱ xani̱t ");
INSERT INTO tosNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","chú̱ tapu̱chuhuanín, na̱ xtasaniko̱cani̱t Jesús, xa̱hua̱ xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Cha̱nchu̱ acxni̱ makasputko̱lh xvino̱cán hua̱ntu̱ xli̱ko̱tnama̱kó̱, xtzi Jesús chuná̱ huánilh: —Nia̱lh tú̱ xvino̱cán hua̱ntu̱ nahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús chuná̱ kálhti̱lh: —Na̱n, ¿tú̱huan chuná̱ quili̱huaniya? Pus quit ni̱ lay tú̱ nactlahuay xpa̱lacatacán sa̱mpi̱ ni̱ a̱lakchá̱n quilhtamacú̱ la̱ntla̱ nacma̱tzuqui̱y quintascújut. ");
INSERT INTO tosNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Hua̱mpi̱ xtzi Jesús chuná̱ huaniko̱lh hua̱nti̱ xmacascujma̱kó̱: —Pala tú̱ naca̱li̱ma̱scujuyá̱n, pacs cakalhakaxpáttit. ");
INSERT INTO tosNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Antá̱ lacatzú̱ xuilakó̱ pa̱cha̱xán lactlanca pu̱akxkatuilí̱n xla chíhuix tu̱ xli̱huilakó̱ la̱ntla̱ xtahuilatcan judíos xli̱makachakanko̱y c-xlacati̱n Dios xpa̱lacata̱ pala tu̱ ni̱tlá̱n xpasako̱ni̱t xala ca̱tuxá̱huat. Tla̱n xtaju̱y pa̱tunu̱ ma̱x li̱huaca ita̱t ciento litro chúchut. ");
INSERT INTO tosNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús chuná̱ huaniko̱lh macascujní̱n: —Cali̱ma̱tzamátit chúchut tama̱ tláminc. Cha̱nchu̱ xlacán li̱ma̱tzamako̱lh hasta c-xkalhni. ");
INSERT INTO tosNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesús huanipalako̱lh: —Chú̱ cama̱cutútit tzinú̱, chu̱ cali̱pinipítit hua̱nti̱ ma̱puxcu̱ni̱cani̱t yuma̱ c-pu̱makca̱tani. Xlacán chuná̱ tlahuako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Cha̱nchu̱ acxni̱ kalhuá̱nalh puxcu̱ná yama̱ chúchut tu̱ xlakpali̱cani̱t xatla̱n vino xtlahuacani̱t; ni̱ xcatzi̱y anta̱ni̱ xli̱mincani̱tanchá, caj xma̱n huá̱ macascujní̱n xcatzi̱ko̱y sa̱mpi̱ hua̱ xlacán xma̱cutuko̱ni̱t yama̱ chúchut. Cha̱nchu̱ tasánilh kahuasa̱ hua̱nti̱ xtapu̱chuhuama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Chuná̱ na̱má̱ huánilh: —Cani̱huá̱ anta̱ni̱ pa̱scuajnancán pu̱lana̱ hua̱ xatla̱n vino ta̱huanancán, chu̱ acxni̱ lhu̱huatá̱ huako̱ni̱t, acxnicú̱ a̱huatiyá ta̱huanancán yama̱ vino hua̱ntu̱ caj pa̱ita̱t xatlá̱n. Hua̱mpi̱ huix huata a̱huatá̱ ma̱stá̱pa̱t yama̱ vino hua̱ntu̱ tlak xatlá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hua̱ yuma̱ chúchut hua̱ntu̱ lakpáli̱lh Jesús c-Caná c-xtapáksi̱t Galilea, hua̱ntu̱ luhua pu̱lh tláhualh tlanca li̱ca̱cni xtatlahu, chu̱ hua̱ yumá̱ tzúculh li̱ma̱siyuy pi̱ tlanca xlacatzúcut, chu̱ yama̱ xli̱ma̱kalhtahuáka̱t ca̱najlaniko̱lh pi̱ xli̱ca̱na̱ xlá̱ Cristo hua̱nti̱ xmini̱t lakma̱xtuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A̱li̱sta̱lh Jesús ta̱anko̱lh xtzi, chu̱ xli̱nata̱lán, xa̱hua̱ xli̱ma̱kalhtahuáka̱t c-aktum ca̱chiquí̱n xuanicán Capernaum, hua̱mpi̱ ni̱ luhua maka̱s quilhtamacú̱ antá̱ xlama̱ko̱chá. ");
INSERT INTO tosNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Acxni̱ xtalacatzuhui̱majá̱ xpa̱scuajcan judíos xla ta̱kspuntza̱lí̱n, Jesús alh c-xaca̱chiqui̱n Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Acxni̱ tanu̱chá̱ c-tlanca xtemplo̱ Dios ma̱noklhuko̱lh c-xtanquilhtí̱n hua̱nti̱ csta̱nama̱kó̱ huá̱cax, chu̱ borrego, chu̱ paloma, xa̱huá̱ hua̱nti̱ antá̱ xuilakó̱ ti̱ xlakpali̱niko̱y xtumi̱ncan tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Acxni̱ ucxilhko̱lh Jesús, li̱huana̱ ca̱xtláhualh kantum tasí̱, chu̱ tzúculh li̱tlakaxtuko̱y pu̱tum sta̱naní̱n, na̱ chuná̱ lactzu̱ xborregojcán, chu̱ xua̱caxcán; cha̱nchu̱ hua̱nti̱ xlakpali̱ko̱y tumi̱n ma̱akpu̱spitniko̱lh xmesajcán, chu̱ ca̱tiyatna̱ makaniko̱lh xtumi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Cha̱nchu̱ hua̱nti̱ csta̱ma̱kó̱ paloma chuná̱ huaniko̱lh: —Pu̱tum tamá̱ catamacaxtukó̱tit u̱nú, chu̱ ni̱ cali̱ma̱xtútit xchic Quintla̱t xta̱chuná̱ aktum pu̱stá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Puschí̱ xli̱ma̱kalhtahuáka̱t lacapa̱stacko̱lh hua̱ntu̱ huan lacatum c-Li̱kalhtahuaka̱ anta̱ni̱ chuná̱ huan: “Xli̱pacs quinacú̱ cli̱lakcatzán tlanca templo xala c-Jerusalén sa̱mpi̱ huá̱ mínchic anta̱ni̱ huila, chu̱ ni̱ cma̱tla̱ni̱y pala tú̱ ni̱tlá̱n antá̱ tlahuacán.” ");
INSERT INTO tosNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Cha̱nchu̱ makapitzi̱n xanapuxcun judíos kalhasquinko̱lh: —¿Xatú̱ ya̱ tlanca li̱ca̱cni xali̱ucxílhti̱t tla̱n natlahuaya̱ hua̱ntu̱ nacucxilha̱hu laqui̱mpi̱ naccatzi̱ya̱hu pi̱ xli̱ca̱na̱ kalhi̱ya̱ li̱ma̱paksí̱n xpa̱lacata̱ hua̱ntu̱ tlahua? ");
INSERT INTO tosNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús kalhti̱ko̱lh: —Cama̱laksputútit yuma̱ xtemplo̱ Dios, na̱ caj xli̱aktutu quilhtamacú̱ quit nactlahuapalay tanu̱, xasa̱sti. ");
INSERT INTO tosNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Entonces yama̱ xanapuxcun judíos huaniko̱lh: —Ti̱puxamacha̱xán ca̱ta̱ li̱makapalacani̱t la̱ntla̱ tlahuama̱ca̱ yuma̱ tlanca xtemplo̱ Dios. ¿Ní̱ nchú̱ huix natzucuniya̱ pi̱ caj aktutu quilhtamacú̱ nali̱tlahuaya̱ tanu̱ xasa̱sti? ");
INSERT INTO tosNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Hua̱mpi̱ xlacán ni̱ akata̱ksko̱lh, sa̱mpi̱ yama̱ templo hua̱ntu̱ xlá̱ xli̱chihui̱nama̱ Jesús pus xlá̱ xtiyatli̱hua xuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pus acxnicú̱ Jesús ni̱lh, chu̱ lakastakuánalh ca̱li̱ní̱n xli̱ma̱kalhtahuáka̱t lacapa̱stacko̱lh yuma̱ tachihuí̱n, chu̱ ca̱najlako̱lh, sa̱mpi̱ luhua chuná̱ xqui̱kantaxtuni̱t xta̱chuná̱ la̱ntla̱ xuaniko̱ni̱t, chu̱ na̱ chuná̱ la̱ntla̱ huan c-Li̱kalhtahuaka̱ hua̱ntu̱ tatzoktahuilani̱t xpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Acxni̱ Jesús xlama̱chacú̱ c-Jerusalén c-xapa̱scua ta̱kspuntza̱lí̱n, lhu̱hua̱ ca̱najlaniko̱lh sa̱mpi̱ ucxilhniko̱lh lactlanca li̱ca̱cni xtascújut hua̱ntu̱ xlá̱ xtlahuama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Hua̱mpi̱ hua̱ Jesús xpa̱lacata, cumu xlá̱ xlakapasko̱y cha̱tunu̱ la̱ntla̱ xtapuhua̱ncán, ni̱ pacs xca̱najlay la̱ntla̱ xlacán xuaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Xlá̱ pacs xlakapasko̱y la̱ntla̱ xlacán xta̱yatcán cha̱tunu, pus Jesús ni̱ xlacasquima̱ pala tí̱ nali̱ta̱chihui̱nán la̱ntla̱ xlacán xtapuhua̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Xuí̱ cha̱tum chixcú li̱fariseo, xuanicán Nicodemo. Xlá̱ luhua tali̱pa̱hu chixcú c-xlaksti̱pa̱ncan judíos. ");
INSERT INTO tosNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aktum tzi̱sní̱ Nicodemo alh lakapaxia̱lhnán Jesús, chu̱ chuná̱ huánilh: —Ma̱kalhtahuaka̱ná, quin ccatzi̱ya̱hu pi̱ Dios macamini̱tán, sa̱mpi̱ ni̱ pala cha̱tum ti̱ tla̱n ma̱siyuy lactlanca li̱ca̱cni tascújut xta̱chuná̱ la̱ntla̱ huix tlahuako̱ya̱ pala ni̱ hua̱ Dios xma̱xqui̱y xli̱tlihuaka. ");
INSERT INTO tosNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús huánilh: —Xli̱ca̱na̱ cuaniyá̱n, pala tí̱ ni̱ nasa̱sti̱tachixcuhui̱palay a̱maktum ni̱ lay catimakcátzi̱lh xtapaksi̱t Dios la̱ntla̱ ma̱la̱nama̱ nahuán c-xlatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Cha̱nchu̱ huánilh Nicodemo: —Hua̱mpi̱ ¿lá̱ntla̱ pi̱ tla̱n nalay nasa̱sti̱tachixcuhui̱palay cha̱tum chixcú pala aya ko̱lutá? ¿Lá̱ntla̱ chá̱ pi̱ tla̱n natanu̱palay c-xpu̱lacni̱ xtzi̱ laqui̱mpi̱ natachixcuhui̱palay? ");
INSERT INTO tosNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús kalhti̱pá̱: —Xli̱ca̱na̱ cuaniyá̱n, hua̱nti̱ ni̱ nali̱lacachín chúchut, xa̱hua̱ xEspíritu Dios, ni̱ lay catimaktapáksi̱lh hua̱ntu̱ Dios tlahuama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sa̱mpi̱ yama̱ hua̱nti̱ lacachín caj xpa̱lacata pi̱ xtzi, chu̱ xtla̱t ma̱xqui̱ko̱y xtiyatli̱hua, pus xlá̱ chuná̱ kalhi̱y xtalacapa̱stacni xta̱chuná̱ la̱ntla̱ tu̱ kalhi̱ko̱y hua̱nti̱ xala yuma̱ ca̱tuxá̱huat; hua̱mpi̱ hua̱nti̱ li̱lacachín cspiritu Dios, pus xlá̱ chuná̱ kalhi̱y xtalacapa̱stacni̱ xta̱chuná̱ la̱ntla̱ tu̱ kalhi̱y cspiritu Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ni̱ cali̱pé̱cuanti̱ hua̱ntu̱ cuanimá̱n hua̱mpi̱ mili̱catzi̱tcán pi̱ Dios luhua lacasquín pi̱ pacs tachixcuhuí̱tat nasa̱sti̱lacachimpalako̱y c-xlata̱ma̱tcán. ");
INSERT INTO tosNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yumá̱ hua̱ntu̱ cuanimá̱n xta̱chuná̱ qui̱taxtuy acxni̱ huix kaxpata̱ macasa̱nán u̱n, hua̱mpi̱ ni̱ catzi̱ya̱ xaní̱ luhua ama̱, chu̱ xaní̱ luhua mima̱chá sa̱mpi̱ ni̱ tasiyuy. Pus na̱ chuná̱ yama̱ xli̱pacs ti̱ Dios ma̱xqui̱ko̱y xasa̱sti xtalacapa̱stacni̱ acxni̱ li̱lacachín xEspíritu. ");
INSERT INTO tosNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo kalhasquimpá̱: —Luhua ni̱ cakata̱ksa̱ la̱ntla̱ luhua naqui̱taxtuy tamá̱. ");
INSERT INTO tosNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús huánilh: —Huix luhua skálalh ma̱kalhtahuaka̱ná̱ u̱nú̱ xala c-Israel, ¿chu̱ ni̱ akata̱ksa̱ hua̱ntu̱ cuanimá̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Xli̱ca̱na̱ cuaniyá̱n, quit cli̱ta̱chihui̱namá̱n hua̱ntu̱ ccatzi̱y, chu̱ cma̱luloka̱ hua̱ntu̱ cucxilhni̱t, hua̱mpi̱ huix ni̱ ca̱najlaya̱ hua̱ntu̱ quit cuanimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Lapi̱ huixín judíos ni̱ ca̱najlayá̱tit acxni̱ cca̱li̱ta̱kalhchihui̱naná̱n hua̱ntu̱ anán u̱nú̱ ca̱tuxá̱huat, ¿pi̱ li̱huacá̱ chú̱ naca̱najlayá̱tit lapi̱ nacca̱li̱ta̱kalhchihui̱naná̱n hua̱ntu̱ anán c-akapú̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","C-akapú̱n ni̱tí̱ catzi̱y la̱ntla̱ tasiyuy tu̱ anán antá, caj xma̱n quit Xatalacsacni Chixcú̱ ccatzi̱y sa̱mpi̱ c-akapú̱n cmini̱tanchá. ");
INSERT INTO tosNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Huixín catzi̱yá̱tit pi̱ maka̱n quilhtamacú̱ acxni̱ quinatla̱tnacán xlama̱kó̱ c-tlanca desierto, Moisés xtokohuácalh c-kantum quihui tantum lu̱hua xla bronce, chu̱ ma̱ti̱ju̱yá̱hualh laqui̱mpi̱ pacs yama̱ ta̱tatlaní̱n hua̱nti̱ naucxilhko̱y ni̱ catíni̱lh, pus na̱ chuná̱ chú̱ quit Xatalacsacni Chixcú̱ naquixtokohuacacán ta̱lhmá̱n ");
INSERT INTO tosNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","laqui̱mpi̱ xli̱pacs hua̱nti̱ naquili̱pa̱huán ni̱ catilaktzánka̱lh huata nakalhi̱ya̱chá̱ yama̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ niucxni̱ nalaksputa. ");
INSERT INTO tosNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Sa̱mpi̱ Dios luhua pa̱xqui̱ko̱lh tachixcuhuí̱tat, pus huá̱ tili̱macamá̱sta̱lh xma̱n cha̱stum xCam laqui̱mpi̱ napa̱lacani̱ko̱y, chu̱ chuná, cati̱huá̱ hua̱nti̱ nali̱pa̱huán, ni̱ catíni̱lh xli̱stacna huata nakalhi̱ya̱chá̱ c-xpa̱xtu̱n Dios yama̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ niucxni̱ nalaksputa. ");
INSERT INTO tosNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Sa̱mpi̱ Dios ni̱ huá̱ li̱macámilh xCam ca̱tuxá̱huat pala caj nama̱laktzanka̱nán, huata li̱macámilh laqui̱mpi̱ nalakma̱xtunán. ");
INSERT INTO tosNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Hua̱nti̱ li̱pa̱huán xCam Dios niucxni̱ catitamaklhtúmi̱lh laqui̱mpi̱ fuerza̱ naxoko̱nán xpa̱lacata xtala̱kalhí̱n, hua̱mpi̱ hua̱nti̱ ni̱ li̱pa̱huamputún fuerza̱ tamakstuntlahuani̱t sa̱mpi̱ ni̱ ca̱najlaniputún yamá̱ hua̱nti̱ xma̱n hua̱ cha̱stum xCam Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hua̱nti̱ ni̱ ca̱najlaniputunko̱y xtachihuí̱n hua̱ yumá̱ li̱tamakstuntlahuako̱ni̱t pi̱ milh xkakánat ca̱tuxá̱huat, chu̱ xlacán tlak lakati̱ko̱lh latapu̱li̱ko̱y c-xaca̱paklhtu̱tá̱ ni̱ xahua̱ c-xaca̱xkakánat, laqui̱mpi̱ ni̱tí̱ nacatzi̱y pala li̱xcájnit hua̱ntu̱ xtlahuama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sa̱mpi̱ xli̱pacs hua̱nti̱ ni̱tlá̱n xtalacapa̱stacnicán ni̱ ucxilhputunko̱y xkakánat laqui̱mpi̱ ni̱ nali̱tasiyuko̱y xta̱yatcán, chu̱ ni̱ laktalacatzuhui̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hua̱mpi̱ hua̱nti̱ tla̱n xtalacapa̱stacnicán, chu̱ tlahuako̱y hua̱ntu̱ catzi̱ko̱y pi̱ aksti̱tum tatlahu, talacatzuhui̱ko̱y ca̱xkakaná, laqui̱mpi̱ nali̱tasiyuko̱y pi̱ Dios ta̱lama̱kó̱ c-xlatáma̱t, chu̱ tla̱n hua̱ntu̱ tlahuama̱kó̱.” ");
INSERT INTO tosNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","A̱li̱sta̱lh Jesús, chu̱ xli̱ma̱kalhtahuáka̱t taca̱xko̱lh c-Jerusalén, chu̱ anko̱lh lacatum c-xatiyat Judea anta̱ni̱ tla̱n naakmunuko̱y tachixcuhuí̱tat, chu̱ fuerza̱ maka̱s tzinú̱ antá̱ xlama̱ko̱chá. ");
INSERT INTO tosNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan na̱ antá̱ lacatzú̱ xakmunu̱nama̱ c-xaca̱chiqui̱n Enón, xta̱lacaxtum Salim, sa̱mpi̱ antá̱ lhu̱hua̱ xuí̱ chúchut. Antá̱ xminko̱y lhu̱hua̱ tachixcuhuí̱tat, chu̱ xta̱kmunuko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pacs yuma̱ chuná̱ qui̱táxtulh acxni̱ ni̱ xa̱tamacanu̱cán c-pu̱la̱chi̱n Juan. ");
INSERT INTO tosNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yama̱ quilhtamacú̱ xli̱ma̱kalhtahuaka̱t Juan, chu̱ a̱tanu̱ judío tzucuko̱lh li̱aklhu̱hua̱tnanko̱y xpa̱lacata̱ la̱ntla̱ tlak xatlá̱n nachaka̱makán cha̱tum hua̱ntu̱ li̱xcajua̱lay u̱nú̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","A̱li̱sta̱lh lakminko̱lh Juan, chu̱ chuná̱ huaniko̱lh: —Ma̱kalhtahuaka̱ná, yama̱ chixcú̱ hua̱nti̱ maktum qui̱laklán c-xa̱lakapu̱tu xakalhtu̱choko̱ Jordán, hua̱nti̱ huix li̱chihuí̱nanti̱ pi̱ mini̱tán quinca̱lakma̱xtuyá̱n, chú̱ na̱ aya akmunu̱nama̱, na̱ pacs huá̱ chú̱ lakanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pus Juan chuná̱ huaniko̱lh: —Ni̱ pala cha̱tum lay tu̱ kalhi̱y lapi̱ ni̱ hua̱ Dios nama̱xqui̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sa̱mpi̱ huixín luhua lacatancs kaxpatni̱tántit acxni̱ chuná̱ cuá̱: ‘Quit ni̱ yama̱ Cristo hua̱nti̱ kalhkalhi̱pá̱tit.’ Pus quit yama̱ chixcú̱ hua̱nti̱ ma̱lakacha̱ca̱ laqui̱mpi̱ nacpu̱laniy Cristo, chu̱ naca̱li̱ma̱catzi̱ni̱ko̱y tachixcuhuí̱tat pi̱ mimajá. ");
INSERT INTO tosNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huixín catzi̱yá̱tit pi̱ c-aktum pu̱tapu̱chuhu yama̱ kahuasa̱ hua̱nti̱ ta̱tahui̱ tzuma̱t, pus huá̱ tapu̱chuhuama̱, chu̱ yama̱ cha̱tum li̱tum hua̱nti̱ antá̱ lacatzú̱ tahui̱ xlá̱ caj xamigo, chu̱ luhua li̱pa̱xuhu kalhakaxmata̱ hua̱ntu̱ xlá̱ li̱chihui̱nama̱. Pus na̱ chuná̱ chú̱ quit luhua cli̱pa̱xuhuay pi̱ pacs huá̱ sta̱lanima̱kó̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Cha̱li̱ cha̱lí̱ xlá̱ a̱tzinú̱ lhu̱hua̱ nali̱pa̱huancán, chu̱ luhua a̱tzinu̱ tali̱pa̱hu nahuán, chu̱ quit nia̱lh tú̱ cactili̱táxtulh, huata cha̱li̱ cha̱lí̱ nacli̱tatu̱tzuhui̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesucristo xCam Dios hua̱nti̱ mini̱tanchá̱ c-akapú̱n huá̱ xta̱stum ti̱ kalhi̱y xlacatzúcut. Yamá̱ hua̱nti̱ u̱nú̱ lacachinko̱ni̱t ca̱tiyatna, pus xlacán xma̱n huá̱ tla̱n li̱chihui̱nán hua̱ntu̱ anán ca̱tiyatna, chu̱ ma̱n hua̱ntu̱ lakapasko̱y. Hua̱mpi̱ hua̱nti̱ mini̱tanchá̱ c-akapú̱n xlá̱ akspuntza̱lako̱y xtalacapa̱stacnicán sa̱mpi̱ tla̱n ma̱sta̱y talulóktat hua̱ntu̱ anán antá. ");
INSERT INTO tosNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hua̱ xlá̱ li̱chihui̱nán hua̱ntu̱ ucxnilhni̱t, chu̱ kaxmatni̱t; hua̱mpi̱ ma̱squi chuná, hua̱ntu̱ xlá̱ li̱chihui̱nán, lhu̱hua̱ ti̱ ni̱ tla̱n tlahuay xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Hua̱mpi̱ yama̱ makapitzí̱n hua̱nti̱ ca̱najlaniko̱y chuná̱ xlacán ma̱lulokko̱y c-xlatama̱tcán pi̱ xli̱ca̱na̱ xtalacapa̱stacni Dios hua̱ntu̱ xlá̱ li̱chihui̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pus yama̱ chixcú̱ hua̱nti̱ Dios macámilh ca̱tiyatna̱ laqui̱mpi̱ xlá̱ naquinca̱ma̱catzi̱ni̱yá̱n tachihuí̱n, xma̱n hua̱ xlá̱ tla̱n li̱chihui̱nán xtalacapa̱stacni, sa̱mpi̱ Dios ni̱ caj talhcá̱n ma̱xqui̱ni̱t xEspíritu. ");
INSERT INTO tosNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Quintla̱ticán Dios pa̱xqui̱y xCam Jesucristo, chu̱ xli̱pacs catu̱huá̱ tu̱ anán, xlá̱ pacs macama̱xqui̱ni̱t pi̱ nama̱paksi̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Hua̱nti̱ li̱pa̱huán xCam Dios maklhti̱nán yama̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ xa̱liankalhí̱n kalhi̱ma̱ nahuán, hua̱mpi̱ hua̱nti̱ ni̱ kalhakaxmatputún laqui̱mpi̱ nali̱pa̱huán, xlá̱ niucxni̱ catikálhi̱lh yama̱ latáma̱t, huata juerza̱ napa̱ti̱y yama̱ li̱pe̱cua tapa̱tí̱n chuná̱ la̱ntla̱ Dios lhca̱huili̱ni̱t nalakchá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Acxni̱ Jesús cátzi̱lh pi̱ fariseos kaxmatko̱ni̱t pi̱ tlak lhu̱hua̱ csta̱lanima̱kó̱ Jesús, xa̱huachí̱ tlak lhu̱hua̱ xakmunu̱nama̱kó̱ xli̱ma̱kalhtahuáka̱t ni̱ xahua̱ Juan, ");
INSERT INTO tosNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ma̱squi xli̱ca̱na̱ pi̱ ni̱ hua̱ Jesús xakmunuko̱y, pus huata xli̱ma̱kalhtahuáka̱t xakmunu̱nanko̱y). ");
INSERT INTO tosNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Acxni̱ Jesús cátzi̱lh yumá̱, huata xatlá̱n táca̱xli̱ c-xatiyat Judea laqui̱mpi̱ naampalay c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hua̱mpi̱ yama̱ tiji̱ ni̱ma̱ chípalh xti̱taxtuy c-aktum tíyat huanicán Samaria. ");
INSERT INTO tosNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","La̱ntla̱ xtla̱huama̱ Jesús cha̱lh c-aktum actzu̱ ca̱chiquí̱n tu̱ xma̱paksi̱y Samaria huanicán Sicar, lacatzú̱ c-pú̱cuxtu̱ hua̱ntu̱ xma̱paksi̱y xamaka̱n ko̱lutzi̱n Jacob hua̱ntu̱ xakata̱xtunini̱t xkahuasa José. ");
INSERT INTO tosNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Na̱ antá̱ yuma̱ c-pú̱cuxtu̱ xuí̱ pu̱lhma̱n chuchut taxtunú̱ tu̱ tipu̱huaxácxtulh tama̱ xamaka̱n ko̱lutzi̱n Jacob. Ma̱x pala tastúnut xuani̱t, chu̱ pi̱ luhua xchichinama̱, Jesús xmakatlakuani̱ttá̱ tiji, pus huata xlá̱ antá̱ tahui̱ c-xquilhpa̱n pozo xacstu. ");
INSERT INTO tosNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Pus xli̱ma̱kalhtahuáka̱t xanko̱ni̱t ca̱chiquí̱n laqui̱mpi̱ natama̱huako̱y hua̱ntu̱ nahuako̱y. Li̱puntzú̱ chilh cha̱tum pusca̱t samaritana laqui̱mpi̱ nama̱cutuy chúchut. Cha̱nchu̱ Jesús chuná̱ huánilh: —Xtlahua̱ li̱tlá̱n xquinta̱hua̱ actzu̱ minchúchut. ");
INSERT INTO tosNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hua̱mpi̱ yama̱ pusca̱t samaritana chuná̱ kálhti̱lh: —¿Tú̱ xpa̱lacata quit quili̱squiniya̱ chúchut pi̱ ni̱ judía quit? Pus quit antá̱ xala u̱nú̱ c-Samaria. Huá̱ chuná̱ li̱huánilh sa̱mpi̱ judíos ni̱ xta̱la̱le̱nko̱y samaritanos. ");
INSERT INTO tosNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús chuná̱ kálhti̱lh: —Xli̱ca̱na̱ pi̱ huix ni̱ tzinú̱ catzi̱ya̱ tu̱ Dios ma̱xqui̱putuná̱n, chu̱ na̱ ni̱ pala catzi̱ya̱ xatí̱ ya̱ chixcú̱ hua̱nti̱ squinimá̱n chúchut. Sa̱mpi̱ lapi̱ huix xcatzi, tancs cuaniyá̱n pi̱ csquini̱ yama̱ chúchut hua̱ntu̱ ma̱sta̱y aktum xataluloktat latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yama̱ pusca̱t chuná̱ huánilh: —Hua̱mpi̱ ni̱ pala xli̱ma̱cutucan chúchut kalhi̱ya, chi̱nchu̱ yuma̱ taxtunú luhua pu̱lhmá̱n, ¿lá̱ntla̱ chú̱ natlahuaya̱ laqui̱mpi̱ tla̱n naquima̱xqui̱ya̱ yama̱ chúchut hua̱ntu̱ ma̱sta̱y tama̱ latáma̱t tu̱ li̱chihui̱námpa̱t? ");
INSERT INTO tosNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yuma̱ pu̱lhma̱n chúchut hua̱ntu̱ taju̱ma̱ u̱nú̱ c-pozo xli̱ca̱na̱ pi̱ luhua tla̱n sa̱mpi̱ hua̱ xamaka̱n quintla̱tcan Jacob hua̱nti̱ quinca̱makaxtaknini̱tán. Antá̱ xlá̱ xkotnán, xa̱hua̱ xli̱pacs xcamán, chu̱ xli̱pacs xtakalhí̱n antá̱ xma̱kotni̱ko̱y. Chi̱nchu̱ huix, ¿pi̱ a̱tzinú̱ luhua tlak tali̱pa̱hu li̱taxtuputuna̱ ni̱ xahua̱ xlá? ");
INSERT INTO tosNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús chuná̱ kálhti̱lh: —Caxati̱cahuá̱ ti̱ li̱kotnanko̱y yuma̱ chúchut ni̱ li̱maka̱s tzucupalay kalhpu̱ti̱ko̱y, ");
INSERT INTO tosNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","hua̱mpi̱ hua̱nti̱ nali̱kotnán yuma̱ chúchut hua̱ntu̱ quit cma̱sta̱y xli̱pa̱án nia̱lh catikalhpu̱ti̱ko̱lh. Hua̱mpi̱ hua̱ chúchut hua̱ntu̱ quit cma̱sta̱y, antá̱ c-xnacú̱ natapalhi̱niy xta̱chuná̱ chuchut taxtunú̱ hua̱ la̱ntla̱ panktaxtuma̱ nahuán laqui̱mpi̱ chuná̱ nakalhi̱y aktum xasa̱sti latáma̱t hua̱ntu̱ niucxnicú̱ nalaksputa. ");
INSERT INTO tosNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yamá̱ pusca̱t chuná̱ huánilh: —Pus luhua catlahua̱ li̱tlá̱n, caquinta̱li̱kótnanti̱ tama̱ chúchut laqui̱mpi̱ nia̱lh nackalhpu̱ti̱y, chu̱ laqui̱mpi̱ nia̱lh nacmín tiyay chúchut u̱nú̱ c-pozo. ");
INSERT INTO tosNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús chuná̱ huanipá̱: —Huata xatlá̱n pu̱lh caqui̱tasani̱ minchixcú, chu̱ acxtum nata̱tana. ");
INSERT INTO tosNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Cha̱nchu̱ yama̱ pusca̱t chuná̱ huánilh: —Quit ni̱tí̱ quinchixcú. Cha̱nchu̱ Jesús kálhti̱lh: —Luhua xli̱ca̱na̱ la̱ntla̱ huana̱ pi̱ ni̱tí̱ minchixcú, ");
INSERT INTO tosNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","sa̱mpi̱ aya kalhaquitzis chixcuhuí̱n hua̱nti̱ huix ta̱tahuilakó, chu̱ hua̱nti̱ ta̱huilán la̱nchiyú̱ na̱ ni̱ ta̱tapu̱chuhua, hua̱ yumá̱ luhua talulóktat hua̱ntu̱ chihui̱nani̱ta. ");
INSERT INTO tosNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Acxni̱ yama̱ pusca̱t káxmatli̱ yuma̱ tachihuí̱n, chuná̱ huánilh: —Pus hasta la̱nchú̱ ccatzi̱ma̱ pi̱ huix luhua tlanca tali̱pa̱hu profeta. ");
INSERT INTO tosNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pus xtlahua̱ li̱tlá̱n xquihuani̱ aktum tachihuí̱n hua̱ntu̱ quit ccatzi̱putún: xalakmaka̱n quinatla̱tnacán quin samaritanos xminko̱y lakataquilhpu̱tako̱y Dios antá̱ u̱nú̱ c-ka̱stí̱n, hua̱mpi̱ huixin judíos huaná̱tit pi̱ xma̱n huá̱ mini̱niy pi̱ antá̱ c-Jerusalén nalakataquilhpu̱taya̱hu Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús kálhti̱lh: —Pusca̱t, cacatzi̱ huix chú̱ pi̱ talacatzuhui̱ma̱ quilhtamacú̱ acxni̱ huixín tla̱n nalakataquilhpu̱tayá̱tit Quintla̱tican Dios ma̱squi ni̱ catántit u̱nú̱ c-ka̱stí̱n, chu̱ ma̱squi ni̱ capítit c-Jerusalén. ");
INSERT INTO tosNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Huixín samaritanos ni̱ pala tzinú̱ catzi̱yá̱tit xtapuhuá̱n hua̱nti̱ lakataquilhpu̱tayá̱tit, sa̱mpi̱ xma̱n hua̱ quin judíos ccatzi̱ya̱hu la̱ntla̱ puhuani̱t Dios nalakma̱xtuko̱y xli̱stacnacan tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Hua̱mpi̱ hua̱ quilhtamacú̱ nalakchá̱n, chu̱ la̱nchiyú̱ huá̱ aya lakcha̱ni̱t, acxni̱ hua̱nti̱ xli̱ca̱na̱ lakataquilhpu̱taputunko̱y Dios, tla̱n cani̱huá̱ natlahuako̱y, hua̱mpi̱ luhua xli̱ca̱na̱ aksti̱tum xta̱chuná̱ la̱ nama̱lacapa̱stacni̱ko̱y Espíritu Santo, sa̱mpi̱ Dios putzama̱kó̱ hua̱nti̱ nalakataquilhpu̱tako̱y la̱ntla̱ cuanimá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios huá̱ xlakli̱ma̱n spíritu, chu̱ ni̱ caj lacatum huí̱ la̱ntla̱ huixín puhuaná̱tit, huá̱ xpa̱lacata, xma̱n hua̱ la̱ntla̱ ma̱n cspiritu Dios nama̱siyuniyá̱n la̱ntla̱ xlá̱ xli̱ca̱na̱ lacasquín tla̱n aksti̱tum nalakataquilhpu̱taya̱. ");
INSERT INTO tosNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yama̱ pusca̱t chuná̱ huánilh: —Quit ccatzi̱y pi̱ namín cha̱tum hua̱nti̱ quinca̱ma̱lacnu̱nini̱tán Dios laqui̱mpi̱ naquinca̱lakma̱xtuyá̱n, hua̱nti̱ huanicán Cristo usu ma̱akapu̱taxti̱ná, chu̱ acxni̱ xlá̱ namín, pacs naquinca̱ma̱akataksniyá̱n hua̱ntu̱ quili̱catzi̱tcán xpa̱lacata Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús huanipi̱ yama̱ pusca̱t: —Pus chú̱ luhua lacatancs cuaniyá̱n pi̱ quit tama̱ chixcú̱ hua̱nti̱ huix li̱chihui̱námpa̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hua̱mpi̱ acxnitiyá̱ chuná̱ xchihui̱nama̱ko̱lh chinko̱lh xli̱ma̱kalhtahuáka̱t, chu̱ xlacán cacs tilacahuanko̱lh acxni̱ ucxilhko̱lh Jesús pi̱ xta̱chihui̱nama̱ yama̱ pusca̱t samaritana. Hua̱mpi̱ ni̱ pala cha̱tum xkalhásquilh xatú̱ xlacasquín, usuchí̱ xatú̱ xli̱chihui̱nama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Cha̱nchu̱ pusca̱t, antá̱ akxtakuíli̱lh xaksá̱huat, chu̱ lacapala̱ alh c-xca̱chiquí̱n, chu̱ antá̱ chuná̱ huaniko̱lh xnata̱chiquí̱n: ");
INSERT INTO tosNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Catántit ucxilhá̱tit cha̱tum chixcú, xlá̱ luhua lacatancs quihuanini̱t xli̱pacs tu̱ ctlahuani̱ttá̱ c-quilatáma̱t. ¿Chá̱ huixín, la̱ huaná̱tit, ni̱ hua cahuá̱ Cristo hua̱nti̱ namín quinca̱lakma̱xtuyá̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Puschí̱ yama̱ chixcuhuí̱n lacapala̱ minko̱chá̱ ca̱chiquí̱n, chu̱ anko̱lh anta̱ni̱ xuilachá̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cha̱nchu̱ antá̱ c-pozo li̱ma̱kalhtahuaka̱t tzucuko̱lh li̱ma̱akatzanka̱ko̱y Jesús pi̱ nahua̱yán, chu̱ chuná̱ xuanima̱kó̱: —Ma̱kalhtahuaka̱ná, cahuá̱yanti. ");
INSERT INTO tosNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hua̱mpi̱ xlá̱ chuná̱ kalhti̱ko̱lh: —Quit aya ckalhi̱y hua̱ntu̱ nacuay, chu̱ huixín ni̱ lakapasá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Cha̱nchu̱ xli̱ma̱kalhtahuáka̱t xacstucán chuná̱ tzucuko̱lh la̱huaniko̱y: —¿Pi̱ cahuá̱ huí̱ ti̱ li̱minini̱t pala tú̱ lí̱huat? ");
INSERT INTO tosNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Hua̱mpi̱ Jesús huaniko̱lh: —Acxni̱ quit ctlahuay xtalacasquin Dios la̱mpala quilí̱huat cli̱ma̱xtuy hasta acxni̱ nacma̱sputuy. ");
INSERT INTO tosNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Acxni̱ huixín ucxilhá̱tit xatahuacat tachaná̱n, huaná̱tit: ‘Ma̱squi ni̱ luhua calacapalahu sa̱mpi̱ tzanka̱ycú̱ akta̱ti papi̱ la̱ntla̱ tla̱n naxka̱nancán’; hua̱mpi̱ quit cca̱huaniyá̱n pi̱ calacapítit, chu̱ na̱ caucxilhkó̱tit anta̱ni̱ huilakó̱ a̱tanu̱ tachaná̱n, antá̱ aya lhmucucuma̱kó̱, chu̱ tla̱ná̱ natzucuyá̱tit xka̱naná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pus huixín hua̱nti̱ namakxka̱naná̱tit na̱ naca̱ma̱skahui̱caná̱tit, chu̱ yamá̱ hua̱ntu̱ nama̱macxtupi̱yá̱tit huá̱ xli̱stacnacán hua̱nti̱ caxani̱li̱huayá̱ kalhi̱ma̱ nahuán li̱pa̱xuhu latáma̱t c-akapú̱n. Tanu̱ huilakó̱ hua̱nti̱ chanko̱ni̱t yuma̱ tachaná̱n, chu̱ huixín chú̱ nama̱macxtupi̱yá̱tit laqui̱mpi̱ huixín chu̱ xlacán acxtum nali̱pa̱xuhuayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chu̱ luhua lacatancs chuná̱ ca̱qui̱taxtunimá̱n yama̱ tachihuí̱n hua̱ntu̱ chuná̱ huan: ‘Tanu̱ chixcú̱ hua̱nti̱ chana̱nán, chu̱ tanu̱ hua̱nti̱ xka̱nán.’ ");
INSERT INTO tosNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Quit cca̱ma̱lakacha̱má̱n huixín laqui̱mpi̱ nama̱macxtupi̱yá̱tit xatahuácat yama̱ tachaná̱n hua̱ntu̱ tichanko̱lh yuma̱ a̱tanu̱ chixcuhuí̱n, pus tanu̱ hua̱nti̱ li̱scujko̱ni̱t, chi̱nchu̱ huixín ca̱ta caj ma̱macxtupi̱yá̱tit hua̱ntu̱ xlacán li̱scujko̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Puschí̱ lhu̱hua̱ samaritanos hua̱nti̱ antá̱ xuilakó̱ c-xaca̱chiquí̱n Sicar na̱ tzucuko̱lh ca̱najlaniko̱y Jesús pi̱ xli̱ca̱na̱ xlá̱ yama̱ Cristo hua̱nti̱ xkalhkalhi̱ma̱kó̱ caj xpa̱lacata̱ hua̱ntu̱ xuanini̱t yama̱ pusca̱t acxni̱ xlá̱ huaniko̱lh pi̱ xuanini̱t xli̱pacs hua̱ntu̱ xlá̱ xtlahuani̱ttá̱ c-xlatáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Chuná̱ pi̱ a̱li̱sta̱lh yama̱ samaritanos lakchinko̱lh Jesús, ta̱chihui̱nanko̱lh, chu̱ huaniko̱lh pi̱ catamakáxtakli̱ c-xca̱chiqui̱ncán. Xlá̱ ma̱tlá̱ni̱lh, chu̱ ta̱tamakaxtakko̱lh aktuy quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cha̱nchu̱ na̱ tlak lhu̱hua̱ antá̱ tica̱najlaniko̱lh xpa̱lacata̱ hua̱ntu̱ luhua xtachihui̱n Cristo. ");
INSERT INTO tosNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A̱li̱sta̱lh chuná̱ huaniko̱lh yama̱ pusca̱t: —Hua̱ chú̱ quin na̱ cca̱najlaya̱hu ni̱ xpa̱lacata̱ pi̱ caj huix quinca̱li̱ta̱chihui̱nani̱ta, hua̱mpi̱ ma̱n quintaka̱ncán quin cli̱kaxmatni̱tahu, chu̱ quin ctaluloka̱hu pi̱ luhua maktum xli̱ca̱na̱ huá̱ Cristo ti̱ xma̱akapu̱taxti̱nacán tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Acxni̱ a̱li̱aktuy quilhtamacú̱, titaca̱xchá̱ antá, chu̱ quilhta̱yapi̱ xtiji̱ laqui̱mpi̱ nachá̱n c-xatiyat Galilea. ");
INSERT INTO tosNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ma̱squi xapu̱lana̱ chuná̱ tihua̱ Jesús pi̱ cha̱tum profeta ni̱ li̱pa̱huancán hua̱ntu̱ li̱chihui̱nán c-xca̱chiquí̱n anta̱ni̱ stacni̱t ");
INSERT INTO tosNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","hua̱mpi̱ ni̱ ankalhí̱n chuná̱ qui̱táxtulh sa̱mpi̱ acxni̱ cha̱mpi̱ c-lactzu̱ ca̱chiquí̱n hua̱ntu̱ xca̱ma̱paksi̱y Galilea cani̱huá̱ luhua li̱pa̱xuhu makamaklhti̱nanko̱lh ti̱ antá̱ xalaní̱n, sa̱mpi̱ lhu̱hua̱ xlacán na̱ xqui̱lako̱ni̱t c-xapa̱scua ta̱kspuntza̱lí̱n c-Jerusalén, chu̱ xlacán pacs xucxilhko̱ni̱t hua̱ntu̱ antá̱ Jesús xtlahuani̱t lactlanca li̱ca̱cni tascújut. ");
INSERT INTO tosNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","La̱ntla̱ xtiji̱tla̱huama̱ Jesús timimpi̱ ca̱chiquí̱n huanicán Caná tu̱ ma̱paksi̱y Galilea, anta̱ni̱ maktum caj chúchut tilakpáli̱lh luhua xatla̱n vino titláhualh. Antá̱ xlama̱chá̱ cha̱tum luhua tali̱pa̱hu chixcú̱ hua̱nti̱ na̱ luhua lacxtum xta̱ma̱paksi̱nán Rey, xlá̱ antá̱ xuilachá̱ c-Capernaum, chu̱ xkalhi̱y cha̱tum xkahuasa hua̱nti̱ luhua xta̱tatlay. ");
INSERT INTO tosNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Hua̱ xlá̱ acxni̱ cátzi̱lh pi̱ Jesús xmini̱tanchá̱ c-Judea, chu̱ xchini̱t c-Galilea, lacapala̱ alh squiniy li̱tlá̱n pi̱ catá̱alh c-xchic, chu̱ cama̱pácsalh xkahuasa sa̱mpi̱ a̱tzinú̱ cstacnama̱, aya xni̱ma̱. ");
INSERT INTO tosNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús chuná̱ huánilh: —Huixín ni̱ luhua quili̱pa̱huaná̱tit lapi̱ ni̱ pu̱lh naucxilhá̱tit aktum luhua li̱ca̱cni tascújut hua̱ntu̱ ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Hua̱mpi̱ yama̱ tali̱pa̱hu cscujni gobierno chuná̱ huánilh: —Tla̱ti, luhua xli̱ca̱na̱ catlahua̱ li̱tlá̱n, lacapala̱ caquinta̱pi̱ c-quínchic xli̱makua̱ ni̱ a̱ni̱y quinkahuasa. ");
INSERT INTO tosNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hua̱mpi̱ huata Jesús huánilh: —Luhua li̱pa̱xuhu capi̱t c-mínchic sa̱mpi̱ yama̱ minkahuasa̱ aya pacsni̱t. Cha̱nchu̱ chixcú̱ ca̱nájlalh hua̱ntu̱ huánilh Jesús, chu̱ lacapala̱ alh c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Acxni̱ aya xcha̱ma̱ c-xchic lacapala̱ minko̱lh pa̱xtokko̱y makapitzí̱n cscujní̱n, chu̱ chuná̱ huaniko̱lh: —Minkahuasa̱ aya pacsni̱t, luhua tla̱na huí̱. ");
INSERT INTO tosNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Xlá̱ kalhasquinko̱lh xatú̱ hora tzucuni̱t tatla̱ni̱y xkahuasa. Xlacán chuná̱ huaniko̱lh: —Ko̱taná̱ ma̱x pala ca̱maktum hora xuani̱t acxni̱ makáxtakli̱ lhcúya̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pus lacapá̱stacli̱ xtla̱t pi̱ huatiya̱ yuma̱ hora acxni̱ Jesús huánilh: “Minkahuasa̱ aya tatla̱ni̱ni̱t”; chu̱ yuma̱ chixcú̱ li̱pa̱hua̱ Jesús xa̱hua̱ xli̱pu̱tum hua̱nti̱ xala c-xchic na̱ li̱ca̱najlánilh caj xpa̱lacata li̱ca̱cni hua̱ntu̱ tláhualh. ");
INSERT INTO tosNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Pus huá̱ chú̱ yuma̱ xli̱aktuy lactlanca li̱ca̱cni xtatlahu hua̱ntu̱ tláhualh Jesús acxni̱ qui̱talákspitli c-Judea, chu̱ chimpi̱ c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ni̱ li̱maka̱s quilhtamacú̱ xtaxtuma̱ aktum xpa̱scuajcan judíos c-Jerusalén, chu̱ Jesús na̱ alh c-pa̱scua̱. ");
INSERT INTO tosNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","C-lacatum má̱laccha̱ anta̱ni̱ xlactanu̱cán ca̱chiquí̱n xuanicán Puerta de las Ovejas, antá̱ lacatzú̱ xuí̱ aktum tlanca taxtunú, c-xatachihui̱n hebreo xuanicán Betesda, antá̱ chú̱ xli̱makstiliya̱huacani̱t akquitzis tamakantí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Antá̱ chu̱ c-xtampi̱n tamakantí̱n, luhua li̱lhu̱hua̱ xma̱kó̱ ta̱tatlantí̱n, lakatzi̱ní̱n, lu̱ntu̱ní̱n, xasca̱cní̱n, ti̱ xkalhkalhi̱ma̱kó̱ natanakay chúchut. ");
INSERT INTO tosNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Sa̱mpi̱ huancán pi̱ caj nicu li̱huaya̱ xta̱ctaya̱chi̱ cha̱tum ángel c-pi̱la̱, chu̱ xlacuilhay chúchut, na̱ mat hua̱nti̱ xapu̱lana̱ xtaju̱y c-pi̱la̱ acxni̱ xtanakama̱ chúchut pus tuncán xpacsa̱ ma̱squi catu̱cahua̱ tajátat xkalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pus antá̱ xmá̱ cha̱tum chixcú, xlá̱ aya xle̱ma̱ xli̱puxamacu̱tzayán ca̱ta̱ la̱ntla̱ xta̱tatlay. ");
INSERT INTO tosNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Acxni̱ úcxilhli̱ Jesús pi̱ antá̱ xmá̱ yama̱ chixcú, chu̱ cátzi̱lh pi̱ maka̱sa quilhtamacú̱ la̱ntla̱ xlá̱ xpa̱ti̱ma̱, pus huá̱ chuná̱ li̱kalhásquilh: —¿Pi̱ huix na̱ pacsputuna? ");
INSERT INTO tosNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yama̱ ta̱tatlá̱ kalhtí̱nalh: —Tla̱ti, luhua cpacsputún hua̱mpi̱ ni̱tí̱ hua̱nti̱ naquimakta̱yay naquimuju̱y c-chúchut acxni̱ tzucuy tanakay. La̱ntla̱ makatunu̱ ctaju̱putún tanuja tuncán hua̱nti̱ quilakataju̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hua̱mpi̱ Jesús huánilh: —Cata̱qui, casacti̱ mixtícat, chu̱ catlá̱huanti. ");
INSERT INTO tosNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Puschí̱ acxni tuncán pacsli̱ yuma̱ chixcú, na̱ má̱qui̱lh xtícat, chu̱ tzúculh tla̱huán. Hua̱mpi̱ cumu sábado xuani̱t yama̱ quilhtamacú̱, xli̱huancán pala tí̱ nascuja̱ usu pala tú̱ nacucalé̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Huá̱ xpa̱lacata c-tiji̱ makapitzi̱n judíos hua̱nti̱ ucxilhko̱lh pi̱ xcucani̱t cxtícat, chuná̱ huaniko̱lh: —Sa̱mpi̱ yuma̱ quilhtamacú̱ luhua caj li̱jáxat, chú̱ ni̱ mili̱cúcat mixtícat. ");
INSERT INTO tosNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Hua̱mpi̱ yama̱ chixcú̱ kalhti̱ko̱lh: —Hua̱nti̱ quima̱pácsalh quihuánilh: ‘Casacti̱ mixtícat, chu̱ catlá̱huanti.’ ");
INSERT INTO tosNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Puschí̱ xlacán kalhasquimpalako̱lh: —¿Xatí̱ yama̱ chixcú̱ hua̱nti̱ huanín: ‘Casacti̱ mixtícat, chu̱ catlá̱huanti’? ");
INSERT INTO tosNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hua̱mpi̱ hua̱nti̱ xpacsni̱t ni̱ kalhtí̱nalh sa̱mpi̱ ni̱ xcatzi̱y xatí̱, sa̱mpi̱ Jesús xlaksti̱pa̱tanu̱ni̱t anta̱ni̱ luhua lhu̱hua̱ xlaya̱kó̱ chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","A̱li̱sta̱lh Jesús ma̱noklhuchá̱ c-tlanca xtemplo̱ Dios, chu̱ chuná̱ huánilh: —Ca̱na̱ huix, luhua tla̱n pi̱ aya pacsni̱ta, hua̱mpi̱ chú̱ nia̱lh catlahua̱ tala̱kalhí̱n xta̱chuná̱ la̱ntla̱ xtlahuaya̱ xapu̱lana̱, laqui̱mpi̱ nia̱lh nachipayá̱n hasta luhua tlak xali̱pe̱cua̱ tajátat. ");
INSERT INTO tosNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yama̱ chixcú pi̱ aya xcatzi̱y xatí̱ ya̱ chixcú̱ hua̱nti̱ xma̱pacsani̱t, huata xlá̱ lacapala̱ alh huaniko̱y xanapuxcun judíos pi̱ Jesús xuanicán yama̱ chixcú̱ hua̱nti̱ xma̱pacsani̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Puschí̱ yuma̱ xma̱paksi̱nani̱n judíos tzucuko̱lh putzako̱y la̱ntla̱ nata̱la̱tlahuako̱y Jesús caj xpa̱lacata̱ pi̱ xtlahuay catu̱huá̱ ná̱ yuma̱ tascújut acxni̱ quilhtamacu̱ li̱jáxat. ");
INSERT INTO tosNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero pala tí̱ xkalhasquín Jesús xatú̱ xpa̱lacata chuná̱ xtlahuay, na̱má̱ xkalhti̱y: —Dios hua̱nti̱ luhua xli̱ca̱na̱ quintla̱t, ma̱squi catu̱hua̱ quilhtamacú̱ scujma̱ xlá̱ la̱ntla̱ makta̱yako̱y tachixcuhuí̱tit, chu̱ na̱ chuná̱ quit xa̱li̱ankalhí̱n cscujma̱. ");
INSERT INTO tosNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Huá̱ xpa̱lacata yuma̱ xanapuxcun judíos xli̱makni̱putunko̱y, sa̱mpi̱ ni̱ caj xma̱n pi̱ ni̱ xca̱cni̱naniy yama̱ quilhtamacú̱ acxni̱ jaxcán, hua̱mpi̱ na̱ pacs xa̱ huatiyá̱ xpa̱lacata̱ pi̱ na̱ luhua Dios xli̱tapu̱lhca̱y acxni̱ xuan pi̱ huá̱ luhua xtla̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús na̱ chuná̱ huaniko̱lh yama̱ xanapuxcun judíos: “Xli̱ca̱na̱ quit xCam Dios, chu̱ luhua lacatancs cca̱huaniyá̱n pi̱ ni̱ lay pala tú̱ ctlahuay hua̱ntu̱ caj quiacstu quimpa̱lacata, huata caj xma̱n huá̱ ctlahuay hua̱ntu̱ cmakucxilha̱ tlahuay Dios sa̱mpi̱ huá̱ quintla̱t; sa̱mpi̱ xli̱pacs hua̱ntu̱ xlá̱ tlahuay, na̱ hua̱ yumá̱ macxtum cta̱tlahuay. ");
INSERT INTO tosNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Dios luhua xli̱ca̱na̱ quimpa̱xqui̱y sa̱mpi̱ quit xCam, chu̱ quima̱siyuniy xli̱pacs tu̱ xlá̱ tlahuama̱; chu̱ naquintima̱siyuniycú̱ a̱tzinú̱ tlak lactlanca tascújut hua̱ntu̱ quit nactlahuay hasta lhpipak nali̱lacahuaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pus chuná̱ la̱ntla̱ Dios quintla̱t ma̱lakastakuani̱ko̱y ni̱ní̱n, chu̱ ma̱xqui̱ko̱y latáma̱t, pus na̱ chuná̱ chú̱ quit na̱ tla̱n nacma̱xqui̱y sa̱sti latáma̱t hua̱nti̱ quit nacma̱xqui̱putún. ");
INSERT INTO tosNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dios quintla̱t ni̱tí̱ putza̱nanima̱, chú̱ squinima̱ cuenta xpa̱lacata xtala̱kalhí̱n, hua̱mpi̱ huá̱ quit xCam quima̱xqui̱ni̱t li̱ma̱paksí̱n pi̱ quit nacsquiniko̱y cuenta̱ xpa̱lacata xtala̱kalhi̱ncan tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chuná̱ laclhca̱huili̱ni̱t Dios laqui̱mpi̱ xli̱pacs tachixcuhuí̱tat naquinca̱cni̱naniko̱y quit xCam Dios xta̱chuná̱ la̱ntla̱ ca̱cni̱nanicán Dios hua̱nti̱ luhua Quintla̱t. Hua̱nti̱ ni̱ quinca̱cni̱naniy quit xCam Dios qui̱taxtuy pi̱ na̱ ni̱ xli̱ca̱na̱ ca̱cni̱nanima̱ Quintla̱t hua̱nti̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n pi̱ hua̱nti̱ quinkaxmatniy hua̱ntu̱ cli̱akchihui̱nama̱, chu̱ na̱ chuna li̱tum chú̱ ca̱najalanini̱t hua̱nti̱ quimacamini̱t, xlá̱ maklhti̱nán yama̱ latáma̱t xasa̱sti̱ hua̱ntu̱ caxani̱li̱huayá̱ nakalhi̱y. Xlá̱ nia̱lh ucxni̱ catima̱pa̱ti̱ni̱ca̱ xpa̱lacata xtala̱kalhí̱n, pus xlá̱ ti̱taxtuni̱t c-xatiji ca̱li̱ní̱n, chu̱ aya tzucuni̱t chú̱ lactla̱huán c-xatiji xa̱li̱ankalhi̱n latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ lakcha̱ma̱ quilhtamacú̱, chu̱ la̱ chiyuhuá̱ aya lakcha̱ni̱t acxni̱ yama̱ hua̱nti̱ xta̱chuná̱ ni̱ní̱n latama̱kó̱, la̱ nakaxmatko̱y xtachihui̱n xCam Dios, chu̱ nali̱pa̱huanko̱y, xa̱li̱ankalhí̱n li̱pa̱xuhu nalatama̱ko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Sa̱mpi̱ xta̱chuná̱ la̱ntla̱ Quintla̱t Dios xacstu kalhi̱y li̱tlihuaka̱ nama̱sta̱y yuma̱ xasa̱sti latáma̱t sa̱mpi̱ tlanca xlacatzúcut, pus na̱ chuná̱ chú̱ quit xCam quima̱xqui̱ni̱t li̱tlihuaka̱ laqui̱mpi̱ nacma̱sta̱y yama̱ latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na̱ chuna li̱tum quima̱xqui̱ni̱t yama̱ li̱tlihuaka̱ laqui̱mpi̱ quit nacta̱tlahuako̱ya̱chá̱ taxokó̱n tachixcuhuí̱tat caj xpa̱lacata xtala̱kalhi̱ncán cha̱tunu, sa̱mpi̱ quit xli̱ca̱na̱ Xatalacsacni Chixcú. ");
INSERT INTO tosNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ni̱ lhpipak cali̱lacahuántit yuma̱ hua̱ntu̱ cca̱huanimá̱n, sa̱mpi̱ luhua xli̱ca̱na̱ namín quilhtamacu̱ acxni̱ xli̱pacs ni̱ní̱n ti̱ acnu̱ko̱y, naquinkaxmatniko̱y quintachihuí̱n, ");
INSERT INTO tosNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","chu̱ cha̱tunu̱ nata̱cxtuko̱ya̱chi̱ anta̱ni̱ xma̱acnu̱ko̱cani̱t. Hua̱nti̱ tla̱n xuani̱t xtapuhua̱ncán nalakastakuananko̱y ca̱li̱ní̱n laqui̱mpi̱ nakalhi̱ko̱y li̱pa̱xuhu latáma̱t, hua̱mpi̱ hua̱nti̱ ni̱tla̱n xtapuhua̱ncán xuanko̱ni̱t, xlacán nalakastakuananko̱y ca̱li̱ní̱n laqui̱mpi̱ xastacná̱ nama̱xoko̱ni̱ko̱cán xli̱pacs hua̱ntu̱ ni̱tlá̱n tlahuako̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Quit ni̱ lay pala tú̱ ctlahuay hua̱ntu̱ caj quiacstu quimpa̱lacata, huata acxni̱ quit cpu̱tza̱naniy chixcuhuí̱n hua̱ntu̱ ni̱tlá̱n tlahuako̱ni̱t, luhua aksti̱tum quintaputzá̱n sa̱mpi̱ chuná̱ ctlahuay la̱ quili̱ma̱paksi̱ni̱t Quintla̱t hua̱nti̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Lapi̱ quit caj xacacstutatlánqui̱lh c-xlacati̱n tachixcuhuí̱tat, luhua xli̱ca̱na̱ pi̱ ni̱tú̱ xlakasi̱ quintachihuí̱n, chu̱ tla̱n ni̱ xca̱najlátit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hua̱mpi̱ huí̱ cha̱tum ti̱ quima̱tlanqui̱y, chu̱ quinta̱ta̱yay, chu̱ quit stalanca ccatzi̱y pi̱ hua̱ntu̱ xlá̱ huan caj quimpa̱lacata li̱ca̱nájlat sa̱mpi̱ talulóktat. ");
INSERT INTO tosNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Huixín qui̱ma̱kalhasquini̱nántit Juan Bautista caj quimpa̱lacata, chu̱ hua̱ntu̱ xlá̱ kalhti̱nanchá̱ luhua xli̱ca̱na̱ chuná. ");
INSERT INTO tosNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Hua̱mpi̱ quit ni̱ li̱lacá̱n pala tú̱ nahuán cha̱tum chixcú̱ caj quimpa̱lacata, usuchí̱ pala tú̱ nama̱siyuy; huata quit caj cca̱ma̱lacapa̱stacamá̱n taluloktat tu̱ ma̱sta̱lh Juan quimpa̱lacata̱ laqui̱mpi̱ naquili̱pa̱huaná̱tit, chu̱ nama̱akapu̱taxti̱yá̱tit mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Xtachihui̱n Juan Bautista, li̱táxtulh xta̱chuná̱ la̱ mákskot laqui̱mpi̱ xlá̱ naca̱makskoniyá̱n, chu̱ huixín luhua aktum tapa̱xuhuá̱n makamaklhti̱nántit cxkakánat, hua̱mpi̱ ni̱ luhua maka̱s quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan má̱sta̱lh talulóktat pi̱ Dios quimacamini̱t, hua̱mpi̱ huilapi̱ chú̱ hua̱ntu̱ tlak tla̱n naca̱ma̱lulokniyá̱n ni̱ xahua̱ xtachihui̱n Juan, pus huá̱ cua̱ni̱ma̱ yama̱ li̱ca̱cni quintatlahu hua̱ntu̱ quit ctlahuako̱y. Pus pacs yuma̱ lactlanca tatlahu hua̱ntu̱ quili̱ma̱tlahui̱ni̱t Quintla̱t laqui̱mpi̱ nacma̱kantaxti̱y, pus caj yuma̱ xli̱ca̱na̱ li̱tasiyuy pi̱ huá̱ Quintla̱t Dios quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chu̱ na̱ chuna li̱tum huatiya Quintla̱t hua̱nti̱ quimacamini̱t aya ma̱sta̱ni̱t talulóktat caj quimpa̱lacata, ma̱squi chá̱ niucxni̱ a̱ lacania̱ xakatli̱ni̱tántit, chu̱ ni̱mpala maktum a̱ucxilhá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Hua̱mpi̱ huá̱ li̱lay sa̱mpi̱ xtachihuí̱n ni̱ a̱chá̱n c-minacu̱cán, sa̱mpi̱ ni̱ ca̱najlaputuná̱tit pi̱ xli̱ca̱na̱ Quintla̱t Dios, chu̱ pi̱ huá̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Huixín luhua ankalhí̱n li̱huana̱ li̱kalhtahuakayá̱tit hua̱ntu̱ tatzokni̱t c-Li̱kalhtahuaka, sa̱mpi̱ huixín puhuaná̱tit pi̱ antá̱ tla̱n nata̱ksá̱tit xlaktáxtut mili̱stacnacán, hua̱mpi̱ ni̱ lay akata̱ksá̱tit pi̱ quit yama̱ hua̱nti̱ li̱chihui̱nama̱ xtachihui̱n Dios pi̱ tla̱n naca̱ma̱xqui̱yá̱n hua̱ntu̱ putzapá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Huá̱ chú̱ xpa̱lacata, huixín ni̱ quilaktalacatzuhui̱putuná̱tit laqui̱mpi̱ nakalhi̱yá̱tit laktáxtut c-mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Acxni̱ chuná̱ cca̱xakatli̱yá̱n ni̱ cui̱ntaj ctlahuay pi̱ naquili̱si̱tzi̱niyá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Sa̱mpi̱ quit cca̱lakapasá̱n, chu̱ ccatzi̱y pi̱ ni̱ kalhi̱yá̱tit xtapa̱xqui̱t Dios c-minacu̱cán ");
INSERT INTO tosNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Quit cmini̱tanchá̱ c-xpa̱xtu̱n Quintla̱t laqui̱mpi̱ chuná̱ tla̱n nacli̱chihui̱nán xtachihuí̱n, hua̱mpi̱ huata huixín ni̱ quili̱pa̱huaná̱tit; hua̱mpi̱ pala tanu̱ ti̱ xca̱lakmín hua̱nti̱ xli̱chihui̱nanca̱ caj xacstu xpa̱lacata, huata huá̱ luhua lacapala̱ xca̱najlanítit, chu̱ xmakamaklhti̱nántit. ");
INSERT INTO tosNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Lapi̱ huixín caj xma̱n huá̱ putzayá̱tit tlahuayá̱tit hua̱ntu̱ naca̱li̱ma̱tlanqui̱yá̱n a̱makapitzi̱n chixcuhuí̱n, na̱ ni̱ tzinú̱ putzayá̱tit tlahuayá̱tit hua̱ntu̱ nali̱makapa̱xuhuayá̱tit yama̱ xta̱stum miDioscán, ¿lá̱ntla̱ cha̱nú̱ naquili̱pa̱huaná̱tit? ");
INSERT INTO tosNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Hua̱mpi̱ ni̱ capuhuántit pala quit nacca̱sta̱huayá̱n c-xlacati̱n Dios; huí̱ xlá̱ tanu̱ hua̱nti̱ chuná̱ natlahuay, hua̱ xamaka̱n Moisés xuani̱t, ma̱squi huixín huaná̱tit pi̱ huá̱ li̱pa̱huaná̱tit xtachihuí̱n, hua̱mpi̱ ni̱ xli̱ca̱na̱. ");
INSERT INTO tosNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pus pala xli̱ca̱na̱ huixín xca̱najlátit hua̱ntu̱ Moisés títzokli̱ c-Li̱kalhtahuaka, na̱ xquinca̱najlanítit quit, sa̱mpi̱ c-Li̱kalhtahuaka̱ xlá̱ títzokli̱ quimpa̱lacata. ");
INSERT INTO tosNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hua̱mpi̱ cumu ni̱ luhua xli̱ca̱na̱ ca̱najlayá̱tit hua̱ntu̱ xlá̱ tzokni̱t, ¿pá̱ li̱huacá̱ chú̱ naca̱najlayá̱tit hua̱ntu̱ quit cca̱huanimá̱n?” ");
INSERT INTO tosNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","A̱li̱sta̱lh acxni̱ nia̱lh maka̱s quilhtamacu̱ xtzanka̱y la̱ntla̱ nalakchá̱n xpa̱scuajcan judíos xla ta̱kspuntza̱lí̱n, Jesús pa̱tácutli̱ a̱li̱quilhtu̱tu xata̱kaya̱huana Galilea, usuchí̱ na̱ huanicán xata̱kaya̱huana Tiberias, sa̱mpi̱ huí̱ ti̱ chuná̱ xli̱ma̱pa̱cuhui̱ko̱y. Cha̱nchu̱ acxni̱ antá̱ cha̱lh talacaacxtutahui̱ c-aktum ka̱stí̱n, chu̱ antá̱ ta̱tahuilako̱lh xli̱ma̱kalhtahuáka̱t. Hua̱mpi̱ anta̱ni̱ xan Jesús luhua lhu̱hua csta̱laniko̱y sa̱mpi̱ xlakati̱ko̱y xucxilhko̱y lactlanca li̱ca̱cni tatlahu hua̱ntu̱ xlá̱ xli̱ma̱lacahua̱ni̱ko̱y acxni̱ xma̱pacsako̱y ta̱tatlaní̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Cha̱nchu̱ pi̱ xalán talacayá̱hualh, úcxilhli̱ pi̱ luhua lhu̱hua̱ tachixcuhuí̱tat xlakminko̱ni̱t anta̱ni̱ xlá̱ xuí̱. Pus chuná̱ huánilh Felipe: —Felipe, ¿ní̱ chú̱ natama̱huaya̱hu lhu̱hua caxtala̱nchu̱ laqui̱mpi̱ nata̱huako̱ya̱hu xli̱pacs yuma̱ ti̱ minko̱ni̱t? ");
INSERT INTO tosNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús caj chunatá̱ huánilh laqui̱mpi̱ nali̱ucxilha̱ la̱ntla̱ nahuán, sa̱mpi̱ xlá̱ luhua lacatancs xcatzi̱yá̱ hua̱ntu̱ natlahuay. ");
INSERT INTO tosNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe chuná̱ kálhti̱lh: —Ma̱squi luhua aktuy ciento denario tumi̱n xli̱tama̱huahu caxtala̱nchu̱, ni̱ catiáccha̱lh laqui̱mpi̱ nali̱ma̱hui̱ko̱ya̱hu xli̱pacs yuma̱ tachixcuhuí̱tat. ");
INSERT INTO tosNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Cha̱tum li̱tum xli̱ma̱kalhtahuáka̱t xuanicán Andrés, xta̱la Simón, chuná̱ huánilh: ");
INSERT INTO tosNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Unú̱ na̱ mini̱t cha̱tum kahuasa, xlá̱ li̱mín macquitzis caxtala̱nchu̱, xa̱hua̱ tantuy squi̱ti, hua̱mpi̱ ¿tú̱ chuj chá̱ xtápalh yuma̱ xpa̱lacata li̱lhu̱hua? ");
INSERT INTO tosNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —Cahuanikó̱tit tachixcuhuí̱tat pi̱ pacs natahuilako̱y. Na̱ Luhua ca̱sakatna xuani̱t yama̱ lacatum, pus antá̱ tahuilako̱lh ma̱x pala akquitzis mi̱lh chixcuhuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús tíyalh yama̱ caxtala̱nchu̱ tu̱ li̱milh kahuasa, pa̱xcatcatzí̱nilh Dios, lakchákalh, chu̱ ma̱xqui̱ko̱lh xli̱ma̱kalhtahuáka̱t laqui̱mpi̱ xlacán nama̱akpitziniko̱y xli̱pacs hua̱nti̱ antá̱ xuilakó̱. Chu̱ na̱ chuna li̱tum tlahuako̱lh yama̱ tantuy squi̱ti, chu̱ pacs ma̱xqui̱ca̱ pacs tu̱ xlacán huaputunko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Acxni̱ aya tla̱n xkalhkasko̱ni̱t Jesús chuná̱ huaniko̱lh xli̱ma̱kalhtahuáka̱t: —Chú̱ cama̱macxtupí̱tit caxtala̱nchu̱ hua̱ntu̱ akatá̱xtulh a̱pakatzuní̱n laqui̱mpi̱ ni̱tú̱ pá̱xcat nahuán. ");
INSERT INTO tosNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xlacán ma̱macxtumi̱ko̱lh, chu̱ ma̱tzamako̱lh pa̱cu̱tuy pakxu xatalakchakatama̱n caxtala̱nchu̱ tu̱ xkatxtakmakanko̱ni̱t xla yama̱ macquitzis caxtala̱nchu̱ xla cebada. ");
INSERT INTO tosNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cha̱nchu̱ xli̱pacs yama̱ li̱lhu̱hua̱ acxni̱ ucxilhko̱lh yuma̱ tlanca li̱ca̱cni tatlahu hua̱ntu̱ Jesús tláhualh, chuná̱ quilhtzucuko̱lh: —Hua̱ yuma̱ chixcú̱ luhua maktum xli̱ca̱na̱ hua̱ profeta hua̱nti̱ xli̱mínat xuani̱t ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cha̱nchu̱ pi̱ Jesús cátzi̱lh hua̱ntu̱ xlacán xtlahuaputunko̱y pi̱ nale̱nko̱y a̱li̱fuerza laqui̱mpi̱ xreycán natlahuako̱y, huata xatlá̱n xlá̱ tatampú̱xtulh, chu̱ xta̱stum áksputli̱ a̱tzinú̱ xata̱lhmá̱n yama̱ ka̱stí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Acxni̱ ko̱tánu̱lh, xli̱ma̱kalhtahuaka̱t Jesús takalhaju̱tahuilako̱chi̱ c-xquilhtu̱n ta̱kahuahuaná. ");
INSERT INTO tosNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hua̱mpi̱ cumu chú̱ aya xtzi̱suani̱ttá, chu̱ Jesús ni̱ naj xa̱qui̱taspita, huata xlacán taju̱ko̱lh c-aktum pu̱tacutnu, chu̱ tzúculh ma̱tla̱huani̱ko̱y laqui̱mpi̱ antá̱ nacha̱nko̱y c-Capernaum hua̱ntu̱ xuí̱ c-xa̱quilhtu̱tu ta̱kaya̱huaná. ");
INSERT INTO tosNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hua̱mpi̱ ni̱ pala maka̱s tlihuaka tzúculh u̱nán, chu̱ li̱pe̱cua̱ tzúculh ta̱kaya̱huay chúchut. ");
INSERT INTO tosNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma̱x aya xanko̱ni̱ttá̱ pala akquitzis, usu akcha̱xan kilómetro acxni̱ ucxilhko̱lh Jesús pi̱ xtalacatzuhui̱ma̱ c-pu̱tacutnu, xlá̱ xkalhtla̱huanti̱lhay chúchut, huata xli̱ma̱kalhtahuáka̱t ni̱ xlakapasma̱kó̱, chu̱ li̱pe̱cua̱ tzucuko̱lh pe̱cuanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Hua̱mpi̱ xlá̱ chuná̱ ca̱tasaniko̱lh: —¡Ni̱ cape̱cuántit sa̱mpi̱ quit Jesús, tacama̱chá! ");
INSERT INTO tosNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Xlacán kalhi̱ko̱lh ta̱kpuhuantí̱n, chu̱ acxni̱ cha̱lh ta̱taju̱ko̱lh c-pu̱tacutnu; na̱ luhua acxnitiyá̱ aya cha̱nko̱lh c-tíyat anta̱ni̱ xama̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yana̱ li̱lhu̱hua tachixcuhuí̱tat ti̱ xtamakaxtakko̱ni̱tanchá̱ c-xa̱quilhtu̱tu ta̱kaya̱huaná, xcatzi̱ko̱y pi̱ xli̱ma̱kalhtahuáka̱t xpu̱anko̱ni̱t xma̱n hua̱ntu̱ xuí̱ aktum pu̱tacutnu, hua̱mpi̱ na̱ xcatzi̱ko̱y pi̱ Jesús ni̱ xta̱anko̱ni̱t. Hua̱mpi̱ li̱cha̱lí̱ ");
INSERT INTO tosNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","chinko̱lh tanuj pu̱tacutnu, antá̱ minko̱chá̱ c-aktum ca̱chiquí̱n huanicán Tiberias, chu̱ antá̱ xuilakó̱ c-chúchut lacatzú̱ anta̱ni̱ Jesús xma̱lhu̱hui̱ni̱t caxtala̱nchu̱, acxni̱ pu̱lh pa̱xcatcatzí̱nilh Dios yama̱ lí̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pus cumu ni̱tí̱ xlama̱ antá̱ Jesús, ni̱ pala xli̱ma̱kalhtahuáka̱t, yama̱ li̱lhu̱hua huata lacapala̱ taju̱ko̱lh c-pu̱tacutnu̱ tu̱ xminko̱ni̱t, chu̱ anko̱lh putzako̱y Jesús c-xa̱lakapu̱tu̱ c-Capernaum. ");
INSERT INTO tosNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Acxni̱ xlacán cha̱nko̱lh c-xa̱lakapu̱tu ta̱kaya̱huaná̱ antá̱ ma̱noklhuko̱lh Jesús, chu̱ chuná̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, ¿ni̱ li̱huayajá̱ chita̱ u̱nú? ");
INSERT INTO tosNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús kalhti̱ko̱lh: —Li̱huana̱ cakaxpáttit hua̱ntu̱ nacca̱huaniyá̱n: huixín quimputzapá̱tit sa̱mpi̱ ko̱tana̱ tla̱n hua̱yántit, chu̱ tla̱n kalhkástit, hua̱mpi̱ ni̱ huá̱ quili̱putzapá̱tit laqui̱mpi̱ naquili̱pa̱huaná̱tit acxni̱ ucxilhá̱tit ctlahuako̱y lactlanca quintatlahu. ");
INSERT INTO tosNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ni̱ caj luhua huá̱ cali̱scujtamakántit xli̱stakuán mintiyatlihuacán hua̱ntu̱ laksputa, huata xatlá̱n huá̱ cali̱scújtit xli̱huat mili̱stacnacán hua̱ntu̱ niucxni̱ laksputa̱ laqui̱mpi̱ chuná̱ nali̱latapa̱yá̱tit c-xpa̱xtu̱n Dios xa̱liankalhi̱n quilhtamacú̱. Quit Xatalacsacni Chixcú̱ tla̱n nacca̱ma̱xqui̱yá̱n yama̱ lihua̱t, sa̱mpi̱ Quintla̱t Dios luhua caj huá̱ quili̱lacsacni̱t laqui̱mpi̱ chuná̱ nacca̱ma̱xqui̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xlacán chuná̱ kalhasquinko̱lh: —¿Tú̱ quili̱tlahuatcán laqui̱mpi̱ nacma̱kantaxti̱ya̱hu hua̱ntu̱ Dios lacasquín nactlahuaya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús kalhti̱ko̱lh: —Hua̱ntu̱ xlá̱ lacasquín Dios natlahuayá̱tit, caj xma̱n caca̱najlanítit hua̱nti̱ xlá̱ macamini̱t, huachá̱ quit. ");
INSERT INTO tosNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Hua̱mpi̱ xlacán kalhasquimpalako̱lh: —¿Xatú̱ ya̱ li̱ca̱cni tatlahu chá̱ huix natlahuaya̱ laqui̱mpi̱ nacli̱ucxilha̱hu pi̱ xli̱ca̱na̱ Dios macamini̱tán, chu̱ laqui̱mpi̱ chuná̱ tla̱n nacca̱ca̱najlaniyá̱n? Cucxilhputuna̱hu pala tla̱n nama̱lakcha̱ni̱ya yama̱ lactlanca tatlahu hua̱ntu̱ titláhualh kolutzi̱n Moisés. Sa̱mpi̱ xalakmaka̱n quinatla̱tnacán tihuako̱lh yama̱ lí̱huat, xta̱chuná̱ lactzu̱ caxtala̱nchu̱ huanicán maná antá̱ c-desierto chuná̱ la̱ntla̱ tatzokni̱t c-Li̱kalhtahuaka̱ anta̱ni̱ na̱má̱ huan: ‘Moisés ma̱xqui̱ko̱lh laqui̱mpi̱ nahuako̱y caxtalá̱nchu̱ xala c-akapú̱n.’ ");
INSERT INTO tosNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús chuná̱ kalhti̱ko̱lh: —Luhua xli̱ca̱na̱ tancs cca̱huaniyá̱n pi̱ ni̱ hua̱ Moisés ma̱xqui̱ko̱lh yama̱ lí̱huat xala c-akapú̱n tu̱ li̱chuhui̱naná̱tit, hua̱ Quintla̱t, chu̱ huata hua̱ Quintla̱t hua̱nti̱ chiyú̱ ca̱ma̱xqui̱putuná̱n aktum hua̱ntu̱ luhua xaxli̱ca̱na̱ lí̱huat xala c-akapú̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sa̱mpi̱ yama̱ lí̱huat hua̱ntu̱ Dios ma̱sta̱y pus hua̱ yamá̱ hua̱nti̱ ta̱ctani̱tanchi̱ c-akapú̱n laqui̱mpi̱ nama̱xqui̱ko̱y latáma̱t tachixcuhuí̱tat hua̱ntu̱ niucxni̱ laksputa. ");
INSERT INTO tosNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yama̱ chixcuhuí̱n chuná̱ huaniko̱lh: —Tla̱ti, catlahua̱ li̱tlá̱n xli̱ankalhi̱ná̱ caquinca̱ma̱xqui̱ yama̱ lí̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús chuná̱ huaniko̱lh: —Quit yama̱ lí̱huat hua̱ntu̱ ma̱sta̱y xaxli̱ca̱na̱ latáma̱t. Yamá̱ hua̱nti̱ quilakmín, chu̱ quili̱hua̱yán, nia̱lh ucxni̱ catítzincsli, chu̱ hua̱nti̱ luhua quinca̱najlaniy niucxni̱ catikalhpú̱ti̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Hua̱mpi̱ chuná̱ la̱ cca̱huanini̱taná, huixín ni̱ quinca̱najlaniputuná̱tit ma̱squi aya ucxilhni̱tántit hua̱ntu̱ quit ctlahuay. ");
INSERT INTO tosNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","La̱ntla̱ xli̱pacs hua̱nti̱ quima̱xqui̱ni̱t quintla̱t laqui̱mpi̱ naquili̱pa̱huanko̱y, pacs quilakchinko̱y laqui̱mpi̱ xankalhí̱n naquista̱laniko̱y; chu̱ pacs chá̱ hua̱nti̱ quit naquilakminko̱y niucxni̱ cactilakmákalh. ");
INSERT INTO tosNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Xa̱huachí̱, quit cmini̱t ca̱tuxá̱huat laqui̱mpi̱ nactlahuaniy xtalacasquin Quintla̱t hua̱nti̱ quimacamini̱t, chu̱ ni̱ caj huá̱ cli̱mini̱t laqui̱mpi̱ nactlahuay hua̱ntu̱ caj quiacstu quintapa̱xuhuá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hua̱ntu̱ xlá̱ xtalacasquin Quintla̱t hua̱nti̱ quimacamini̱t, xlá̱ lacasquín pi̱ li̱huana̱ nacmaktakalhko̱y laqui̱mpi̱ ni̱ pala cha̱tum nalaktzanka̱y hua̱nti̱ xlá̱ quimacama̱xqui̱ni̱t naquili̱pa̱huán, laqui̱mpi̱ acxni̱ nalakchá̱n quilhtamacú̱ la̱ntla̱ xlá̱ laclhca̱huili̱ni̱t, quit pacs nacma̱lakastakuani̱ko̱y ca̱li̱ní̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pus xli̱ca̱na̱ huá̱ luhua xtalacasquin Quintla̱t pi̱ xli̱pacs hua̱nti̱ naakata̱ksa̱ xatí̱ luhua quit, chu̱ naquinca̱najlaniy pi̱ quit xCam, xa̱li̱ankalhí̱n nakalhi̱ko̱y yama̱ li̱pa̱xuhu latáma̱t hua̱ntu̱ niucxni̱ nalaksputa, chu̱ hua̱ xlacán hua̱nti̱ nacma̱lakastakuani̱ko̱y acxni̱ nalakchá̱n yama̱ a̱huatiya quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Acxni̱ yama̱ li̱lhu̱hua judíos kaxmatko̱lh xtachihuí̱n tzucuko̱lh xli̱aklhu̱hua̱tnanko̱y Jesús sa̱mpi̱ xlá̱ chuná̱ huá̱: “Quit yama̱ caxtala̱nchu̱ hua̱ntu̱ ta̱ctani̱tanchi̱ c-akapú̱n.” ");
INSERT INTO tosNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xlacán chuná̱ huanko̱lh: —¿Tú̱ hua̱ yuma̱ Jesús, xkahuasa José? Pus quin lakapasa̱hu xtzi, chu̱ xtla̱t. ¿Lá̱ntla̱ chá̱ xlá̱ huán pi̱ mini̱tanchá̱ c-akapú̱n?” ");
INSERT INTO tosNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ ni̱ cali̱aklhu̱hua̱tnántit quintachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sa̱mpi̱ ni̱ pala cha̱tum tla̱n natzucuputún quili̱pa̱huanko̱y, lapi̱ ni̱ pu̱lh huá̱ nama̱puhua̱ni̱y Quintla̱t hua̱nti̱ quimacamini̱t. Chu̱ hua̱nti̱ naquili̱pa̱huanko̱y, xlacán ma̱squi nani̱ko̱y quit nacma̱lakastakuani̱ko̱y acxni̱ nalakchá̱n a̱huatiya quilhtamacú̱ xla taputzá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Lacatum c-Li̱kalhtahuaka̱ cha̱tum profeta tzokli̱ la̱ntla̱ Dios tihua̱ maktum pi̱ nama̱siyuniko̱y xtalacapa̱stacni̱ xli̱pacs ti̱ nakaxmatputunko̱y. Pus yama̱ tachihuí̱n xli̱ca̱na̱ huani̱t quimpa̱lacata sa̱mpi̱ xli̱pacs hua̱nti̱ nakaxmatniko̱y Quintla̱t Dios hua̱ntu̱ xlá̱ huanima̱kó̱, chu̱ antá̱ nachá̱n c-xnacu̱cán yama̱ tachihuí̱n, pus huá̱ chú̱ xlacán na̱ naquili̱pa̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Hua̱mpi̱ ni̱ huá̱ huamputún pala tí̱ ucxilhni̱t Dios, huata caj xma̱n quit cucxilhni̱t, sa̱mpi̱ antá̱ quit cmini̱tanchá̱ c-xpa̱xtú̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Caca̱najlátit tu̱ cca̱huaniyá̱n, sa̱mpi̱ hua̱nti̱ quili̱pa̱huán, xlá̱ aya kalhi̱y yama̱ latáma̱t hua̱ntu̱ xa̱li̱ankalhí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sa̱mpi̱ quit yama̱ xaxli̱ca̱na̱ caxtala̱nchu̱ hua̱ntu̱ ma̱sta̱y xli̱pa̱án latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xalakmaka̱n minatla̱tnacán huako̱ni̱t yama̱ lihua̱t huanicán maná tu̱ Dios ma̱hui̱ko̱lh acxni̱ xlapu̱lako̱y c-desierto, hua̱mpi̱ ma̱squi chuná, fuerza̱ ko̱lunko̱lh, chu̱ ni̱ko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hua̱mpi̱ ni̱ chuná̱ yuma̱ caxtala̱nchu̱ hua̱ntu̱ cli̱chihui̱nama̱, xlá̱ ta̱ctani̱tanchi̱ c-akapú̱n, laqui̱mpi̱ hua̱nti̱ xlá̱ nahuay nia̱lh ucxni̱ catíni̱lh xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Pus aya cca̱huanín pi̱ quit yama̱ caxtala̱nchu̱ hua̱ntu̱ ta̱ctani̱tanchi̱ c-akapú̱n, chu̱ hua̱ntu̱ ma̱sta̱y hua̱ntu̱ xaxli̱ca̱na̱ latáma̱t. Hua̱nti̱ nahuay yuma̱ lihua̱t xli̱ca̱na̱ pi̱ xli̱pa̱án nalatama̱y. Yama̱ lihua̱t hua̱ntu̱ quit cca̱ma̱lacnu̱niyá̱n pus huatiya̱ huá̱ quintiyatli̱hua, nacma̱sta̱y quit nacni̱y xpa̱lacatacan tachixcuhuí̱tat xala ca̱tuxá̱huat laqui̱mpi̱ chuná̱ nakalhi̱ko̱y xli̱pa̱án latáma̱t.” ");
INSERT INTO tosNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Cha̱nchu̱ yama̱ judíos, xacstucán tzucuko̱lh aklhuhua̱tnanko̱y, hua̱ chuná̱ tzucuko̱lh huanko̱y: —¿Lá̱ntla̱ natlahuay laqui̱mpi̱ tla̱n naquinca̱ma̱hui̱yá̱n xtiyatli̱hua? ");
INSERT INTO tosNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús chuná̱ huaniko̱lh: —Luhua xli̱ca̱na̱ cca̱huaniyá̱n pi̱ quit Xatalacsacni Chixcú, chu̱ lapi̱ huixín ni̱ nali̱hua̱yaná̱tit quintiyatli̱hua, chu̱ lapi̱ ni̱ nali̱kotnaná̱tit quinkalhni, ni̱ catikalhí̱tit yama̱ xaxli̱ca̱na̱ latáma̱t c-mili̱stacna̱cán hua̱ntu̱ cli̱chihui̱nán. ");
INSERT INTO tosNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Hua̱nti̱ nahuay quintiyatli̱hua, chu̱ nali̱kotnán quinkalhni nakalhi̱y latáma̱t hua̱ntu̱ niucxni̱ laksputa, chu̱ chuná̱ ma̱squi nani̱y quit nacma̱lakastakuani̱y ca̱li̱ní̱n acxni̱ nalakchá̱n xli̱a̱huatiya̱ yama̱ quilhtamacú̱ acxni̱ nasputa̱ ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sa̱mpi̱ hua̱ quintiyatli̱hua̱ tu̱ c-ma̱sta̱y acxni̱ nacca̱pa̱lacani̱yá̱n, luhua xaxli̱ca̱na̱ caxtala̱nchu̱, chu̱ quinkalhni̱ tu̱ nastajtamakán mimpa̱lacatacán, luhua xaxli̱ca̱na̱ li̱kotna̱ tu̱ li̱stakuanán mili̱stacnacán. ");
INSERT INTO tosNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hua̱nti̱ nali̱hua̱yán quintiyatli̱hua, chu̱ nali̱kotnán quinkalhni, li̱taxtuy la̱mpala macxtum quinta̱huani̱t, chu̱ quit na̱ huá̱ macxtum cta̱huani̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hua̱ Quintla̱t hua̱nti̱ quimacamini̱t, ni̱ kalhi̱ni̱t xquilhtzúcut, ankalhí̱n ucxla̱ta xastacná láma, chu̱ xastacná lámaj nahuán, chu̱ yama̱ xaxli̱ca̱na̱ latáma̱t hua̱ntu̱ kalhi̱y, na̱ huá̱ quima̱xqui̱ni̱t laqui̱mpi̱ quit na̱ ankalhí̱n cli̱lámaj nahuán, pus na̱ chuná̱ chú̱ hua̱nti̱ naquili̱hua̱yán, chu̱ naquili̱kalhkasa̱ c-xli̱stacna, quit nacma̱xqui̱y yama̱ xaxli̱ca̱na̱ latáma̱t tu̱ quit ckalhi̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Huá̱ luhua cca̱huaniputuná̱n pi̱ quit yama̱ xaxli̱ca̱na̱ caxtala̱nchu̱ hua̱ntu̱ ta̱ctani̱tanchi̱ c-akapú̱n. Yuma̱ lihua̱t ni̱ huá̱ xta̱chuná̱ la̱ntla̱ yama̱ maná hua̱ntu̱ tihuako̱lh xalakmaka̱n minatla̱tnacán c-desierto, sa̱mpi̱ xlacán ma̱squi cha̱li̱ cha̱lí̱ xuati̱lhako̱y fuerza̱ ko̱lunko̱lh ni̱ko̱lh, hua̱mpi̱ hua̱nti̱ nali̱kalhkasa̱ yuma̱ caxtala̱nchu̱ hua̱ntu̱ quintiyatli̱hua, xli̱pa̱án nalatama̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús chuná̱ li̱xakatli̱ko̱lh yuma̱ tachihuí̱n acxni̱ xli̱lhu̱huacán judíos xtanu̱ma̱kó̱ c-aktum xpu̱kalhtahuakacán c-xaca̱chiqui̱n Capernaum. ");
INSERT INTO tosNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Acxni̱ kaxmatko̱lh hua̱ntu̱ huaniko̱ca̱, lhu̱hua̱ xlacán hua̱nti̱ csta̱laniputunko̱y Jesús chuná̱ huanko̱lh: —Yumá̱ hua̱ntu̱ xlá̱ quilhuama̱, luhua xli̱ca̱na̱ luhua tuhua̱ ma̱tla̱ni̱cán, ¿tí̱ chá̱ luhua tla̱n natlahuaniy, chu̱ tí̱ chá̱ luhua nakaxmatniy xtachihuí̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Hua̱mpi̱ Jesús xcatzi̱y pi̱ xlacán xli̱aklhuhua̱tnama̱kó̱ yama̱ chixcuhuí̱n hua̱ntu̱ xlá̱ xuaniko̱ni̱t, pus chuná̱ kalhasquinko̱lh: —Lapi̱ yumá̱ hua̱ntu̱ cca̱huanín ni̱ luhua li̱ca̱najlaputu mimpa̱lacatacán ");
INSERT INTO tosNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","pus ¿lá̱ntla̱ chú̱ luhua xqui̱táxtulh pala xquiucxílhtit quit Xatalacsacni Chixcú̱ ctaspitma̱pi̱ cahuá̱ c-akapú̱n anta̱ni̱ pu̱lh xacuilachá? ");
INSERT INTO tosNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Chuná̱ qui̱taxtuy sa̱mpi̱ xma̱n hua̱ cspiritu Dios tla̱n naca̱ma̱xqui̱yá̱n yuma̱ xli̱pa̱án latáma̱t tu̱ cli̱chihui̱nama̱. La̱ntla̱ xli̱pacs mili̱skalalacán tu̱ caj xla̱ chixcuhuí̱n kalhi̱yá̱tit ni̱ lay ca̱makta̱yayá̱n naakata̱ksá̱tit xli̱pacs tu̱ quit cca̱huanini̱tán sa̱mpi̱ pacs huá̱ xtalacapa̱stacni cspiritu Dios, chu̱ xma̱n huá̱ xlá̱ naca̱ma̱xqui̱yá̱n yama̱ xasa̱sti milatama̱tcán, chu̱ mintalacapa̱stacnicán tu̱ nali̱akata̱ksá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Huachá̱ xpa̱lacata ma̱squi catu̱cahuá̱ xacca̱huanín xpa̱lacata yumá̱, ccatzi̱y pi̱ huijcu nahuán makapitzi̱n huixín ti̱ nalakmakaná̱tit, chu̱ ni̱ catica̱najlaputúntit. Huá̱ chuná̱ Jesús li̱huaniko̱lh sa̱mpi̱ xlá̱ xcatzi̱y tuncán hua̱nti̱ ni̱ xca̱najlaniy, chu̱ na̱ chuná̱ xcatzi̱y hua̱nti̱ a̱li̱sta̱lh nali̱akskahuinán, chu̱ namacama̱sta̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A̱li̱sta̱lh chuná̱ huá̱: —Pus huachá̱ xpa̱lacata quit cca̱li̱huanini̱tán pi̱ ni̱ pala cha̱tum tla̱n naquili̱pa̱huamputunko̱y lapi̱ ni̱ hua̱ Quintla̱t pu̱lh nama̱puhua̱ni̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Hasta acxnitiyá̱ yama̱ quilhtamacú̱ lhu̱hua̱ hua̱nti̱ csta̱lanima̱kó̱ Jesús, titalakaspitta̱yako̱lh, chu̱ nia̱lh acxtum xta̱latla̱huanko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Huá̱ xpa̱lacata, Jesús na̱má̱ kalhasquinko̱lh yama̱ kalhacu̱tuy xli̱ma̱kalhtahuáka̱t hua̱nti̱ xa̱liankalhí̱n xta̱lapu̱lako̱y: —¿Chá̱ huixín? ¿Pi̱ na̱ quiakxtakmakamputuná̱tit? ");
INSERT INTO tosNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Hua̱mpi̱ huata Simón Pedro chuná̱ kálhti̱lh: —Quimpu̱chinacán, ¿xatí̱ chú̱ a̱tanu̱ luhua nactilakana̱hu? Sa̱mpi̱ xma̱n hua̱ mintachihuí̱n ma̱lacnu̱y yama̱ xaxli̱ca̱na̱ latáma̱t hua̱ntu̱ ankalhí̱n nakalhi̱ya̱hu c-xpa̱xtu̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Quin aya cca̱ca̱najlanini̱tán sa̱mpi̱ ccatzi̱ya̱hu pi̱ huix Xatalacsacni xCam Dios hua̱nti̱ naquinca̱lakma̱xtuya. ");
INSERT INTO tosNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús chuná̱ kalhti̱ko̱lh: —Huixín catzi̱yá̱tit pi̱ ma̱n quit cca̱lacsacni̱tán laqui̱mpi̱ ankalhí̱n naquinta̱latapu̱li̱yá̱tit, hua̱mpi̱ ma̱squi chuná, c-milaksti̱pa̱ncán huí̱ cha̱tum hua̱nti̱ makatlajani̱t xtalacapa̱stacni̱ akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Acxni̱ chuná̱ huá̱ Jesús, huá̱ xlá̱ xli̱chihui̱nama̱ Judas Iscariote xkahuasa Simón, sa̱mpi̱ hua̱ Judas ti̱ namacama̱sta̱y, ma̱squi xlá̱ acxtum xta̱tapaksi̱ko̱y xli̱kalhacu̱tuy xli̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A̱li̱sta̱lh Jesús antá̱ xlapu̱lay c-xatiyat Galilea. Xlá̱ ni̱ xtahuilaputuna̱chá̱ c-Judea sa̱mpi̱ xanapuxcun judíos xmakni̱putunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hua̱mpi̱ acxni̱ aya xtalacatzuhui̱majá̱ xpa̱scuajcan judíos, acxni̱ li̱pa̱scuajnanca̱ pu̱ni̱lhca̱ chiqui. ");
INSERT INTO tosNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","hua̱nti̱ xli̱nata̱lan Jesús chuná̱ huaniko̱lh: —Nia̱lh catamakáxtakti̱ u̱nú, huata xatlá̱n na̱ capit makpa̱scuajnana̱ c-Judea anta̱ni̱ tzamacán laqui̱mpi̱ chuná̱ lhu̱hua̱ nama̱ucxilhni̱ko̱ya̱ tlanca̱ li̱ca̱cni tatlahu hua̱ntu̱ huix tla̱n tlahuaya, chu̱ nasta̱laniko̱yá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Lapi̱ xli̱ca̱na̱ lacasquina̱ huix pacs nalakapascana, pus ni̱tú̱ caj lakatze̱k catlahua̱ catu̱huá̱. Pus lapi̱ huix xli̱ca̱na̱ tla̱n tlahuako̱ya̱ catu̱hua̱ lactlanca li̱ca̱cni tatlahu, chuná̱ antá̱ catlahuakó̱ laqui̱mpi̱ pacs naucxilhcán. ");
INSERT INTO tosNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Sa̱mpi̱ hasta ma̱squi hua̱nti̱ luhua xnata̱lán, ni̱ xca̱najlaniko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesús chuná̱ huaniko̱lh: —Ni̱ naj a̱lakchá̱n quilhtamacú̱ acxni̱ antá̱ nacán, hua̱mpi̱ hua̱ntu̱ huixín mimpa̱lacatacán, xa̱li̱ankalhí̱n tla̱n natlahuayá̱tit hua̱ntu̱ napuhuaná̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xa̱huá̱ huixín ni̱tí̱ ca̱si̱tzi̱niyá̱n, hua̱mpi̱ quit lhu̱hua̱ ni̱ quiucxilhputunko̱y, sa̱mpi̱ quit ni̱ cli̱quilhpuhuaniko̱y, chu̱ lacatancs cma̱laksiyuniko̱y, cuaniko̱y hua̱ntu̱ ni̱ tla̱n tlahuako̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Huata capimpítit huixín c-pa̱scua̱, quit ni̱ naj cama̱, sa̱mpi̱ ni̱ a̱lakchá̱n quilhtamacú̱. ");
INSERT INTO tosNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Cha̱nchu̱ acxni̱ huaniko̱lh yumá̱, xlacán anko̱lh c-pa̱scua̱, chu̱ Jesús tamakáxtakli̱ c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Hua̱mpi̱ acxni̱ xanko̱nittá̱ xnata̱lá̱n, Jesús na̱ alh c-pa̱scua̱, ma̱squi xlá̱ ni̱ tasiyuniko̱lh xli̱lhu̱hua̱ tachixcuhuí̱tat, huata caj tze̱k xlapu̱lay. ");
INSERT INTO tosNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Xanapuxcun judíos xlacaputzama̱kó̱ c-pa̱scua̱, chicá̱ pala na̱ xani̱t, xlacán xkalhasquini̱nánko̱y, chicá̱ pala tí̱ xucxilhni̱t, chu̱ chuná̱ xuanko̱y: —¿Ní̱ lama̱ cahuá̱ yama̱ chixcú? ");
INSERT INTO tosNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Na̱ luhua lhu̱hua̱ hua̱nti̱ catu̱huá̱ xli̱aksama̱kó̱, chu̱ chuná̱ xuanko̱y: “Tama̱ chixcú̱ luhua tla̱n xtapuhuá̱n”; hua̱mpi̱ a̱makapitzí̱n chuná̱ xuanko̱y: “Tama̱ chixcú̱ ni̱ xli̱ca̱na̱ luhua tla̱n catzi̱y, sa̱mpi̱ caj akskahuimi̱ko̱y tachixcuhuí̱tat.” ");
INSERT INTO tosNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Hua̱mpi̱ ti̱ni̱ siyuj chuná̱ xli̱chihui̱nán xpa̱lacata, pi̱ xpe̱cuaniko̱y xanapuxcun judíos. ");
INSERT INTO tosNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Acxni̱ aya xita̱tlani̱t pa̱scua̱ Jesús tánu̱lh c-tlanca xtemplo̱ Dios xala c-Jerusalén, chu̱ tzúculh akchihui̱naniko̱y li̱lhu̱hua̱ hua̱nti̱ antá̱ xtanu̱ma̱kó̱. ");
INSERT INTO tosNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yama̱ xanapuxcun judíos hua̱nti̱ antá̱ xkaxmatnima̱kó̱ xtachihuí̱n, luhua caj cacs xli̱lacahuanko̱y, chu̱ chuná̱ xuanko̱y: —¿Ní̱ xlá̱ luhua catzí̱nilh yuma̱ tu̱ ma̱siyuy, sa̱mpi̱ xlá̱ ni̱ kalhtahuakani̱t? ");
INSERT INTO tosNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Huá̱ chu̱ pi̱ Jesús kalhakaxmatko̱lh, chuná̱ kalhti̱ko̱lh: —Yuma̱ quintachihuí̱n hua̱ntu̱ quit cma̱siyuma̱, ni̱ caj quiacstu quintalacapa̱stacni, pus huá̱ xtalacapa̱stacni̱ yama̱ hua̱nti̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Lapi̱ huí̱ ti̱ huixín xtlahuapútulh xtalacasquin Dios hua̱ntu̱ xlá̱ lacasquín, pus huata xlá̱ naakata̱ksa̱ yuma̱ talacapa̱stacni̱ hua̱ntu̱ quit cquilhuama̱, lapi̱ huá̱ Dios macamima̱chá, usuchí̱ lapi̱ caj quiacstu quintalacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yama̱ chixcú̱ hua̱nti̱ li̱chihui̱nán hua̱ntu̱ caj xacstu xtalacapa̱stacni, hua̱ xlá̱ chuná̱ li̱tlahuay laqui̱mpi̱ luhua naca̱cni̱naniko̱y tachixcuhuí̱tat; hua̱mpi̱ cumu quit xma̱n huá̱ cli̱ta̱katzanka̱y pi̱ naca̱cni̱nanicán Dios hua̱nti̱ quimacamini̱t, pus chuná̱ cli̱ma̱siyuy pi̱ talulóktat hua̱ntu̱ cquilhuama̱, chu̱ ni̱tú̱ caj caksani̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ma̱squi huixín pacs catzi̱yá̱tit pi̱ Moisés huá̱ ca̱li̱ma̱xquí̱n xli̱ma̱paksi̱n Dios laqui̱mpi̱ nama̱kantaxti̱yá̱tit, hua̱mpi̱ ma̱squi chuná̱ ni̱ pala cha̱tum huixín ti̱ luhua li̱tzaksapá̱tit laqui̱mpi̱ nama̱kantaxti̱yá̱tit. Sa̱mpi̱ pala chuná cahuá̱, ¿tú̱ huan quimpuhuaniyá̱tit naquimakni̱yá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Xlacán chuná̱ kalhti̱ko̱lh: —Akskahuiní̱ kalhi̱ya. ¿Tí̱ chú̱ puhuaniyá̱n namakni̱yá̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús chuná̱ huaniko̱lh: —Maktum quilhtamacú̱ acxni̱ pacs jaxcán, quit ctláhualh aktum luhua tla̱n tatlahu, na̱ pacs lhpipak li̱lacahuani̱tántit, chu̱ hasta chunacú̱ tili̱aklhu̱hua̱tnampá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Huixín huá̱ circuncidar li̱tlahuako̱yá̱tit lactzu̱ milakkahuasancán sa̱mpi̱ chuná̱ tica̱li̱ma̱paksí̱n Moisés (ma̱squi chá̱ luhua xli̱ca̱na̱ pi̱ ni̱ hua̱ Moisés ma̱quilhtzuqui̱ni̱tanchá̱ yuma̱ hua̱ntu̱ li̱ca̱cni̱naniyá̱tit Dios, hua̱mpi̱ huá̱ xamaka̱n mintla̱tcan Abraham), hua̱mpi̱ huixín fuerza̱ ma̱chuqui̱naná̱tit actzu̱ xtiyatli̱hua̱ lactzu̱ milakkahuasancán acxni̱ a̱cu lacachinko̱y ma̱squi acxni̱ lakcha̱ni̱t sábado acxni̱ li̱huancán pala tí̱ nascuja. ");
INSERT INTO tosNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pus lapi̱ huixín caj xpa̱lacata ni̱ lacatza̱laputuná̱tit xli̱ma̱paksí̱n Moisés, pus circuncidar tlahuako̱yá̱tit lactzu̱ lakkahuasán ma̱squi sábado acxni̱ ni̱tí̱ scuja, ¿tú̱huan chi̱nchu̱ luhua quili̱si̱tzi̱niyá̱tit acxni̱ pi̱ cma̱pácsalh cha̱tum ta̱tatlá̱ acxni̱ yama̱ quilhtamacú̱ li̱huancán pala tí̱ nascuja? ");
INSERT INTO tosNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ni̱ luhua caj aklakuá̱ caquimputza̱nanítit hua̱ntu̱ ctlahuay. Acxni̱ pala naquimputza̱naniputuná̱tit hua̱ntu̱ ctlahuani̱t, hua̱mpi̱ hua̱ntu̱ luhua aksti̱tum catlahuátit. ");
INSERT INTO tosNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Cha̱nchu̱ makapitzí̱n hua̱nti̱ xuilako̱chá̱ c-Jerusalén acxni̱ kaxmatko̱lh yuma̱ tachihuí̱n, chuná̱ tzúculh kalhasquini̱nanko̱y: —¿Tú̱ hua̱ yumá̱ ti̱ putzama̱ca̱ laqui̱mpi̱ namakni̱cán? ");
INSERT INTO tosNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pus caucxílhtit la̱ntla̱ siyuj akchihui̱nama̱, na̱ ni̱tí̱ pala tí̱ xaklhu̱huá̱tnalh. Ma̱x luhua akata̱ksko̱ni̱t quinapuxcuncán pi̱ yuma̱ chixcú̱ hua̱ Cristo ti̱ naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Hua̱mpi̱ quin catzi̱ya̱hu ní̱ xlá̱ mini̱tanchá, chu̱ na̱ catzi̱ya̱huá̱ anta̱ni̱ lacachini̱t. Pus ni̱ chuná̱ catiqui̱táxtulh acxni̱ Cristo namín ca̱tuxá̱huat, sa̱mpi̱ ni̱tí̱ caticátzi̱lh ní̱ luhua xlá̱ naminachá. ");
INSERT INTO tosNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Cha̱nchu̱ Jesús, maktum la̱ntla̱ xma̱siyuma̱ c-templo, palha̱ tzúculh chihui̱nán, chuná̱ xquilhuama̱: —Huixín huaná̱tit pi̱ quilakapasá̱tit quit, na̱ mat catzi̱yá̱tit anta̱ni̱ xalá̱ quit, hua̱mpi̱ huí̱ kampa̱tum hua̱ntu̱ ni̱ catzi̱yá̱tit: quit ni̱ caj quiacstu quimpa̱lacata̱ ma̱squi cmini̱t, sa̱mpi̱ huí̱ cha̱tum hua̱nti̱ quimacamini̱t, chu̱ huá̱ xlá̱ luhua tali̱pa̱hu xtachihuí̱n, hua̱mpi̱ huixín ni̱ lakapasá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Quit xlá̱ clakapasa, sa̱mpi̱ antá̱ c-xpa̱xtú̱n cminchá, chu̱ xa̱huachí̱ xlá̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pus hua chí̱ xli̱puhuaniko̱y nachipako̱y, hua̱mpi̱ ti̱ ni̱ xatí̱ máca̱lh xmacán, sa̱mpi̱ ni̱ naj chuná̱ xlakchá̱n quilhtamacú̱ la̱ntla̱ xlá̱ namakni̱cán. ");
INSERT INTO tosNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hua̱mpi̱ yuma̱ li̱lhu̱hua̱ ti̱ xkaxmatnima̱kó̱ xtachihui̱n, na̱ lhu̱hua̱ hua̱nti̱ tica̱najlaniko̱lh, cha̱nchu̱ chuná̱ xuanko̱y: —Chi̱nchu̱ acxni̱ namín Cristo quima̱akapu̱taxti̱nacán, ¿pi̱ tlak xali̱huaca̱ lactlanca li̱ca̱cni tatlahu natlahuay ni̱ xahua̱ tu̱ tlahuay yuma̱ chixcú? ");
INSERT INTO tosNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yama̱ chixcuhuí̱n hua̱nti̱ xuaniko̱cán fariseos, chu̱ xanapuxcun xpa̱lijnican judíos, xlacán tzucuko̱lh kaxmatko̱y la̱ntla̱ xli̱chihui̱nanko̱y tachixcuhuí̱tat hua̱ntu̱ xlá̱ xtlahuay Jesús, huata xlacán maca̱nko̱lh makapitzi̱n policías c-tlanca templo laqui̱mpi̱ tachí̱n nale̱nko̱y Jesús. ");
INSERT INTO tosNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xlacán anko̱lh hua̱mpi̱ Jesús chuná̱ huaniko̱lh: —Nia̱lh luhua maka̱s quilhtamacú̱ cca̱ta̱lamá̱n quit, sa̱mpi̱ nactaspitpalay c-xpa̱xtu̱n hua̱nti̱ quimacamini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yama̱ quilhtamacú̱ huixín naquimputzayá̱tit, hua̱mpi̱ nia̱lh caquintitá̱kstit, sa̱mpi̱ huixín ni̱ lay catipítit anta̱ni̱ quit nactahuilaya̱chá. ");
INSERT INTO tosNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yama̱ xanapuxcun judíos xacstucán tzucuko̱lh la̱kalhasquinko̱y: —¿Ní̱ chú̱ naán yumá̱ pi̱ ni̱ nata̱ksa̱hu? ¿Pi̱ cahuá̱ huá̱ nalakanko̱y judíos ti̱ makat huilako̱chá̱ c-xtiyatcan griegos, laqui̱mpi̱ huá̱ naxakatli̱ko̱y? ");
INSERT INTO tosNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tú̱ chú̱ luhua huaniputún acxni̱ chuná̱ quinca̱huanín: ‘Huixín naquimputzayá̱tit, hua̱mpi̱ nia̱lh caquintitá̱kstit, sa̱mpi̱ huixín ni̱ lay catipítit anta̱ni̱ quit nactahuilaya̱chá’? ");
INSERT INTO tosNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Acxnitiyá̱ yama̱ quilhtamacú̱, c-xli̱katsputni pa̱scua̱, acxni̱ a̱tzinú̱ luhua lhu̱hua̱ xtatzamacán, Jesús tá̱yalh lacatum anta̱ni̱ tla̱n naakchihui̱naniko̱y tachixcuhuí̱tat, chu̱ chuná̱ pixtlanca̱ tzúculh quilhaniko̱y: —Lapi̱ huí̱ ti̱ kalhpu̱ti̱ma̱ c-xlatáma̱t, caquilákmilh, chu̱ quit nacma̱kotni̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pus chuná̱ nali̱kantaxtuy hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka̱ anta̱ni̱ chuná̱ huan pi̱ c-xnacu̱ hua̱nti̱ naquili̱pa̱huán natahuilay xta̱chuná̱ la̱ aktum taxtunú anta̱ni̱ ankalhí̱n taxtuma̱ nahuán chúchut tu̱ ma̱sta̱y xaxli̱ca̱na̱ latáma̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Caj xpa̱lacata̱ yuma̱ xtachihuí̱n, Jesús xli̱ma̱xtuma̱ yama̱ taxtunú̱ chú̱ Espíritu Santo: hua̱ xlá̱ xuaniputún pi̱ hua̱nti̱ nali̱pa̱huán namaklhti̱nán xli̱tlihuaka Espíritu Santo; ma̱squi yama̱ quilhtamacú̱ ni̱ xa̱mín sa̱mpi̱ Jesús ni̱ xa̱cha̱mpalay c-akapú̱n anta̱ni̱ xapu̱lh xuí̱. ");
INSERT INTO tosNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Cha̱nchu̱ makapitzi̱n li̱lhu̱hua̱ acxni̱ kaxmatko̱lh xtachihuí̱n, chuná̱ tzucuko̱lh huanko̱y: —Luhua maktum xli̱ca̱na̱, hua̱ tama̱ chixcú̱ profeta hua̱nti̱ xli̱mínat xuani̱t ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hua̱mpi̱ a̱makapitzí̱n chuná̱ xuanko̱y: —Ni̱ xli̱ca̱na̱, sa̱mpi̱ hua̱ Cristo hua̱nti̱ mini̱tán quinca̱ma̱akapu̱taxti̱yá̱n. Huí̱ ti̱ xuampalay: —Hua̱mpi̱ ¿lá̱ntla̱ nataxtuya̱chá̱ c-xatiyat Galilea hua̱nti̱ luhua xli̱ca̱na̱ Cristo? ");
INSERT INTO tosNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","C-xtachihui̱n Dios hua̱ntu̱ tatzokni̱t huan pi̱ tama̱ Cristo xquilhtzúcut nahuán yama̱ xamaka̱n rey David, chu̱ xala c-Belén nahuán sa̱mpi̱ antá̱ xchuchutsipij xuani̱t David. ");
INSERT INTO tosNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Puschí̱ caj xpa̱lacata Jesús li̱lhu̱hua̱ hua̱nti̱ xkaxmatnima̱kó̱ xtachihuí̱n tapa̱pitziko̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huata makapitzi̱n xchipaputunko̱y Jesús c-pu̱la̱chi̱n, hua̱mpi̱ ni̱ cha̱tum hua̱nti̱ chípalh. ");
INSERT INTO tosNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yama̱ policías taspitpalako̱lh, chu̱ antá̱ ampalako̱lh anta̱ni̱ xtamacxtumi̱ko̱ni̱t xanapuxcun pa̱lijni, chu̱ acxni̱ cha̱nko̱lh, chuná̱ kalhasquinko̱ca̱: —¿Tú̱huan ni̱ li̱taná̱tit? ");
INSERT INTO tosNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xlacán kalhti̱nanko̱lh: —Ti̱ ni̱ cha̱tum chixcú̱ a̱chihui̱nán xta̱chuná̱ la̱ntla̱ yuma̱ chixcú̱ chihui̱nama̱. ");
INSERT INTO tosNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Huata yama̱ fariseos chuná̱ huaniko̱lh: —¿Lá̱ntla̱ pi̱ na̱ aya ta̱kskahuitittá̱ huixín? ");
INSERT INTO tosNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Pi̱ huí̱ ti̱ ca̱najlanini̱t makapitzí̱n quinapuxcuncán, xa̱hua̱ li̱fariseos? ");
INSERT INTO tosNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Hua̱mpi̱ hua̱ yumá̱ ti̱ caj xalacchunatá, ti̱ ni̱ akata̱ksko̱y hua̱ntu̱ huamputún xtachihui̱n Dios hua̱ntu̱ tatzoktahuilani̱t c-Li̱kalhtahuaka pus cala̱ntla̱lako̱lh. ");
INSERT INTO tosNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Chi̱nchu̱ Nicodemo huachá̱ ti̱ maktum ca̱tzi̱sní̱ tiqui̱lakapaxiá̱lhnalh Jesús, xlá̱ na̱ fariseo xuani̱t, chuná̱ huaniko̱lh: ");
INSERT INTO tosNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Pus la̱ntla̱ tatzoktahuilani̱t xli̱ma̱paksi̱n Moisés, huan pi̱ ni̱ pala cha̱tum tla̱n catima̱lacapu̱hu pala ni̱ pu̱lh catiputza̱nanihu, chu̱ li̱huana̱ nacatzi̱ya̱hu hua̱ntu̱ xlá̱ tlahuani̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hua̱mpi̱ huata xlacán caj li̱kalhakama̱nanko̱lh, chu̱ chuná̱ kalhti̱nanko̱lh: —¿Pi̱ na̱ li̱lakaputza galileo huix? Pus huata luhua li̱huana̱ cali̱kalhtahuaka̱ yama̱ libros anta̱ni̱ tatzoktahuilani̱t xtachihui̱n Dios, antá̱ calacputza, chu̱ niucxni̱ catíta̱ksti̱ anta̱ni̱ huan pala cha̱tum profeta mini̱tanchá̱ c-Galilea. ");
INSERT INTO tosNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pus acxni̱ chuná̱ chihui̱nanko̱lh yama̱ fariseos cha̱tunu̱ cha̱tunu̱ alh c-xchic. ");
INSERT INTO tosNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Cha̱nchu̱ yama̱ ca̱ko̱tanú̱n, Jesús táspitli̱ c-xaka̱stí̱n hua̱ntu̱ huanicán Cerro de los olivos. ");
INSERT INTO tosNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Li̱tzi̱sa̱ li̱tum acxni̱ tzúculh xkakay, tiampi̱ c-tlanca templo, na̱ luhua lhu̱hua̱ tachixcuhuí̱tat laktalacatzúhui̱lh, chu̱ xlá̱ titahui̱ laqui̱mpi̱ nama̱siyunipalako̱y xtachihui̱n Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","La̱ntla̱ xchihui̱nama̱ makapitzí̱n fariseos, chu̱ makatzoknaní̱n li̱minko̱lh cha̱tum pusca̱t hua̱nti̱ xma̱noklhuko̱ni̱t cxakatli̱ma̱, xta̱tanu̱ma̱ hua̱nti̱ ni̱ hua̱ xchixcú. Antá̱ xlacán ya̱huako̱lh c-xlacati̱ncan xli̱pacs yama̱ li̱lhu̱hua̱ luhua anta̱ni̱ xuí̱ Jesús. ");
INSERT INTO tosNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Xlacán chuná̱ huaniko̱lh Jesús: —Ma̱kalhtahuaka̱ná, yuma̱ pusca̱t cma̱noklhuni̱tahu acxni̱ luhua cxakatli̱ma̱ tanuj chixcú, chu̱ xakskahuima̱ xchixcú. ");
INSERT INTO tosNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","C-xli̱ma̱paksi̱n Moisés, quinca̱li̱ma̱paksi̱yá̱n pala tí̱ chuná̱ pusca̱t nacma̱noklhuya̱hu, tla̱n nacli̱actalamakni̱ko̱ya̱hu chíhuix. Cha̱nchu̱ huix ¿lá̱ huana? ¿Pi̱ tla̱n chuná̱ nactlahuaya̱hu? ");
INSERT INTO tosNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na̱ chí̱ xlacán caj chunatá̱ xli̱kalhputzama̱kó̱ laqui̱mpi̱ pala tú̱ xlá̱ ni̱ tancs nakalhti̱nán, chu̱ chuná chú̱ tla̱n nali̱sta̱huako̱y. Huata Jesús taquilhpú̱talh, chu̱ tzúculh li̱tzoknán kantum actzu̱ xmacán ca̱tiyatna. ");
INSERT INTO tosNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Cha̱nchu̱ pi̱ yama̱ chixcuhuí̱n makcatzi xkalhasquima̱kó̱, puschí̱ Jesús táactzajli, chu̱ chuná̱ huaniko̱lh: —La̱ntla̱ macxtum yá̱tit, pala taxtuya̱chá̱ cha̱tum hua̱nti̱ ni̱tú̱ tlahuani̱t tala̱kalhí̱n, pus huata hua̱ xlá̱ luhua mini̱niy casacli̱ aktum chíhuix, chu̱ camacapú̱lalh laqui̱mpi̱ naactalamakni̱yá̱tit tama̱ pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús taquilhpu̱tapi̱ ca̱tu̱tzú̱, chu̱ tzucupaj tzoknán c-tíyat. ");
INSERT INTO tosNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Acxni̱ xlacán kaxmatko̱lh yama̱ tachihuí̱n ni̱tú̱ kalhti̱nanko̱lh, huata lacatzucu̱ tzucuko̱lh tza̱lako̱y, cha̱tunu̱ cha̱tunu̱ anko̱lh, macatzucuko̱lh ti̱ tlakaya lakko̱lún, chu̱ a̱li̱sta̱lh anko̱lh hua̱nti̱ tlakcu lakkahuasán. Acxni̱ anko̱lh, caja xta̱stum Jesús tamakáxtakli, chu̱ yama̱ pusca̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Acxni̱ chu̱ taquilhpú̱qui̱lh Jesús, nia̱lh tí̱ úcxilhli, caj xma̱n hua̱ yama̱ pusca̱t xyá̱, xlá̱ chuná̱ huánilh: —Pusca̱t, ¿ní̱ chú̱ ya̱kó̱ ti̱ csta̱huama̱kó̱n? ¿Tú̱ a̱lh ti̱ makstuntlahuayá̱n? ");
INSERT INTO tosNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Xlá̱ chuná̱ kalhtí̱nalh: —Quimpu̱chinacán, nia̱lh tí̱ quima̱lacapu̱ma̱. Cha̱nchu̱ Jesús chuná̱ huánilh: Pus na̱ ni̱ pala quit clacasquín nacmakstuntlahuayá̱n caj xpa̱lacata̱ hua̱ntu̱ ni̱tlá̱n tlahuani̱ta̱ mintala̱kalhí̱n. La̱nchú̱ capittá̱ c-mínchic, chu̱ nia̱lh makcatzi timakla̱kalhi̱nana. ");
INSERT INTO tosNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cha̱nchu̱ Jesús tzúculh xakatli̱palako̱y tachixcuhuí̱tat, huaniko̱lh: —Quit cli̱taxtuy xkakánat hua̱ntu̱ makaxkaka̱nán ca̱tuxá̱huat; hua̱nti̱ quili̱pa̱huán, chu̱ quista̱laniy, nakalhi̱y xkakánat c-xlatáma̱t, chu̱ niucxni̱ catilatáma̱lh ca̱paklhtu̱tá̱. ");
INSERT INTO tosNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Makapitzi̱n fariseos chuná̱ huaniko̱lh: —Caj huix ti̱ acstuli̱chihui̱nampa̱ca̱, caj huá̱ xpa̱lacata tama̱ mintachihuí̱n ni̱tu̱ xlakasi, chu̱ ni̱ lay cca̱najlaya̱hu. ");
INSERT INTO tosNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús chuná̱ kálhti̱lh: —Quit ni̱ cakskahuinán, ma̱squi luhua caj cacstuli̱chihui̱nanca̱, hua̱mpi̱ quintachihuí̱n kalhi̱y xlakasi̱ sa̱mpi̱ quit ccatzi̱y anta̱ni̱ cminchá, chu̱ na̱ ccatzi̱y anta̱ni̱ naccha̱mpalay. Hua̱mpi̱ huixín ni̱ catzi̱yá̱tit anta̱ni̱ cminchá, chu̱ na̱ ni̱ pala catzi̱yá̱tit anta̱ni̱ naccha̱mpalay. ");
INSERT INTO tosNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Huixín aklakuá̱ quimakstuntlahuayá̱tit sa̱mpi̱ xta̱chuná̱ putza̱naná̱tit la̱ntla̱ li̱smani̱ko̱ni̱t putza̱nanko̱y ti̱ caj cati̱hua̱ chixcuhuí̱n ti̱ lacachinko̱ni̱t ca̱tuxá̱huat. Huata quit ni̱tí̱ aklakuá̱ nacmakstuntlahuay, ");
INSERT INTO tosNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","hua̱mpi̱ lapi̱ xacma̱lacapu̱ko̱lh minta̱yatcán, hua̱ntu̱ xacca̱huanín pacs xli̱ca̱na̱, sa̱mpi̱ quit ni̱ quiacstu̱ pala tí̱ cputza̱naniy xtala̱kalhí̱n, huata huá̱ Quintla̱t hua̱nti̱ quimacamini̱t quima̱xqui̱y xtalacapa̱stacni̱ xatú̱ nacli̱ya̱huayá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","C-xli̱ma̱paksi̱n Moisés hua̱ntu̱ tica̱makaxtaknín, antá̱ tatzokni̱t pi̱ acxni̱ cha̱tuy testigo ti̱ ma̱sta̱y talulóktat, luhua acxtum nachihui̱nanko̱y, pus naca̱najlaniko̱cán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Quit ti̱ cacstuma̱sta̱nicán talulóktat, chu̱ na̱ quima̱sta̱niy talulóktat Xatla̱t ti̱ quima̱lakácha̱lh yunú. ");
INSERT INTO tosNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xlacán chuná̱ kalhasquinko̱lh: —¿Ní̱ huilachá̱ mintla̱t? Jesús huaniko̱lh: —Huixín ni̱ lakapasá̱tit Quintla̱t, sa̱mpi̱ ni̱ catzi̱yá̱tit xatí̱ ya̱ chixcú̱ quit; lapi̱ xcatzí̱tit xatí̱ ya̱ chixcú̱ quit na̱ xlakapástit quintla̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús chuná̱ ta̱chihui̱nanko̱lh yama̱ fariseos acxni̱ xlá̱ xakchihui̱nama̱ lacatzú̱ c-xama̱laccha tlanca templo anta̱ni̱ xpu̱muju̱cán limosna, hua̱mpi̱ ni̱tí̱ chípalh laqui̱mpi̱ nale̱ncán c-pu̱la̱chi̱n sa̱mpi̱ ni̱ xa̱lakchá̱n xquilhtamacú̱ la̱ namacama̱sta̱cán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","A̱li̱sta̱lh Jesús huanipalako̱lh yuma̱ tachihuí̱n: —Quit cama̱ a̱lacatanu̱, chu̱ naquimputzayá̱tit, hua̱mpi̱ huixín ni̱ caquintitá̱kstit, pus anta̱ni̱ quit nacchá̱n huixín ni̱ lay catipítit, sa̱mpi̱ ma̱squi nani̱yá̱tit, chunacú̱ ni̱ a̱ma̱tzanka̱nanicani̱tántit nahuán mintala̱kalhi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Cha̱nchu̱ yama̱ xanapuxcun judíos chuná̱ tzúculh la̱huaniko̱y: —Yuma̱ chixcú̱ ma̱x caj naacstumakni̱cán, huá̱ chuná̱ li̱huán pi̱ ni̱ lay caticha̱hu anta̱ni̱ xlá̱ nachá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Cha̱nchu̱ Jesús huaniko̱lh: —Huixín kalhi̱yá̱tit mimpu̱tahui̱lhcán antá̱ u̱nú̱ ca̱tu̱tzú̱, hua̱mpi̱ quimpu̱táhui̱lh huí̱ ta̱lhmá̱n; huixín u̱nú̱ xala ca̱tuxá̱huat, hua̱mpi̱ quit ni̱ antá̱ u̱nú̱ xala ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Huachá̱ xpa̱lacata̱ cca̱li̱huanín pi̱ chunacú kalhi̱yá̱tit mintala̱kalhí̱n nani̱yá̱tit; sa̱mpi̱ lapi̱ ni̱ xca̱najlátit pi̱ quit yama̱ ti̱ naca̱lakma̱xtuyá̱n, chunacú ni̱ a̱ma̱tzanka̱nanicani̱tántit nahuán acxni̱ nani̱yá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xlacán chuná̱ huaniko̱lh: —Xli̱ca̱na̱, ¿xatí̱ ya̱ chixcú̱ huix? Jesús kalhti̱ko̱lh: —Huixín catzi̱yá̱tit pi̱ hasta la̱ntla̱ta xakasiyaj tuncán cca̱huanini̱tán xatí̱ quit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Quit tla̱n lhu̱hua̱ xacca̱li̱chihui̱nán, chu̱ xacca̱li̱ya̱huán hua̱ntu̱ ni̱tlá̱n tlahuayá̱tit, hua̱mpi̱ huata huá̱ nacca̱ma̱siyuniyá̱n, huixín ti̱ xala ca̱tuxá̱huat, hua̱ntu̱ lacasquín hua̱nti̱ quimacamini̱t, chu̱ hua̱ntu̱ ckaxmatnini̱t; pus xlá̱ luhua aksti̱tum xtalacapa̱stacni. ");
INSERT INTO tosNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Hua̱mpi̱ xlacán ni̱ akata̱ksko̱lh pi̱ Jesús xli̱xakatli̱ma̱kó̱ Dios hua̱nti̱ Xtla̱t, ");
INSERT INTO tosNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","chu̱ huá̱ chuná̱ li̱huanipalako̱lh: —Hasta acxni̱ huixín naquima̱ta̱lhma̱ni̱yá̱tit quit Xatalacsacni Chixcú̱ c-cruz, pus acxnicú̱ luhua naakata̱ksá̱tit xatí̱ quit; chu̱ na̱ acxnicú̱ nacatzi̱yá̱tit pi̱ quit ni̱tú̱ ctlahuay hua̱ntu̱ caj quiacstu quimpa̱lacata, huata caj xma̱n huá̱ cuan hua̱ntu̱ quima̱siyunini̱t Quintla̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Sa̱mpi̱ Dios, hua̱nti̱ quit quimacamini̱t, ankalhí̱n quinta̱lapu̱lay, niucxni̱ naquiakxtakmakán sa̱mpi̱ ankalhí̱n quit ctlahuay hua̱ntu̱ xlá̱ lakati̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Acxni̱ chuná̱ chihui̱nanko̱lh Jesús, luhua lhu̱hua̱ ti̱ ca̱najlaniko̱lh, chu̱ csta̱laniputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hua̱mpi̱ Jesús chuná̱ huanikolh hua̱nti̱ xca̱najlaniko̱ni̱t: —Pus lapi̱ huixín luhua aksti̱tumá̱ nama̱kantaxti̱yá̱tit hua̱ntu̱ cca̱li̱ma̱paksi̱yá̱n, chuná̱ tla̱n nali̱taxtuyá̱tit la̱ xaxli̱ca̱na̱ quili̱ma̱kalhtahuáka̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chu̱ chuná̱ huixín tla̱n nalakapasá̱tit hua̱ntu̱ xtaluloktat xtalacapa̱stacni Dios, chu̱ hua̱ yama̱ talacapa̱stacni̱ naca̱ma̱xqui̱yá̱n laktáxtut, sa̱mpi̱ caj la̱ tachí̱n huixín lapá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Makapitzí̱n chuná̱ kalhti̱ko̱lh: —Yama̱ kolutzi̱n Abraham hua̱nti̱ maka̱n quilhtamacú̱ xlama̱ xatali̱pa̱hu quinquilhtzucutcán xuani̱t quin, chu̱ niucxni̱ a̱quinca̱chi̱caná̱n laqui̱mpi̱ pala tí̱ caj la̱ tachí̱n naquinca̱ma̱scujuyá̱n. ¿Lá̱ntla̱ chú̱ huix huana̱ pi̱ nackalhi̱ya̱hu laktáxtut? ");
INSERT INTO tosNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús huaniko̱lh: —Xli̱ca̱na̱ cca̱huaniyá̱n pi̱ xli̱pacs hua̱nti̱ tlahuako̱y tala̱kalhí̱n, xlacán li̱taxtuko̱y xta̱chuná̱ la̱ xtasa̱cuacan tala̱kalhí̱n, usuchí̱ la̱ xtachi̱ncán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cha̱tum tasa̱cua̱ hua̱nti̱ caj la̱ tachí̱n ma̱scujucán, xlá̱ ni̱ lay tlahuay tu̱ lacasquín, huata huá̱ tlahuay hua̱ntu̱ huaniy xma̱la̱ná, hua̱mpi̱ quit xCam Dios ni̱tí̱ quima̱scujuy la̱ xtachí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Huá̱ cca̱li̱huaniyá̱n, lapi̱ quit xCam Dios cca̱ma̱xqui̱yá̱n laktáxtut, yama̱ tala̱kalhí̱n nia̱lh lay catica̱ma̱scujún xta̱chuná̱ la̱ xtachí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Xli̱ca̱na̱ aya ccatzi̱y pi̱ huixín minquilhtzucutcán xuani̱t yama̱ xamaka̱n kolutzi̱n Abraham, hua̱mpi̱ chunacú̱ huixín quimakni̱putuná̱tit sa̱mpi̱ ni̱ ma̱tla̱ni̱yá̱tit hua̱ntu̱ quit cca̱huaniyá̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quit ckalhi̱y xtalacapa̱stacni Quintla̱t, chu̱ huá̱ cli̱chihui̱nán hua̱ntu̱ quima̱siyunini̱t, hua̱mpi̱ huixín kalhi̱yá̱tit tanu̱ mintla̱tcán, chu̱ huá̱ tlahuayá̱tit hua̱ntu̱ xlá̱ ca̱ma̱siyunini̱tán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Xlacán chuná̱ kalhti̱nanko̱lh: —Quin hua̱ quintla̱tcán xuani̱t yama̱ xamaka̱n Abraham. Jesús chuná̱ huaniko̱lh: —Lapi̱ xli̱ca̱na̱ huixín xcamán cahuá̱ kolutzi̱n Abraham, pus na̱ chuná̱ xmacasta̱lá̱tit la̱ xlá̱ tilatáma̱lh ca̱tuxá̱huat. ");
INSERT INTO tosNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma̱squi quit aya cca̱huanín yama̱ talacapa̱stacni̱ hua̱ntu̱ Dios quima̱siyunini̱t, huixín ni̱ ca̱najlayá̱tit, chu̱ fuerza̱ quimakni̱putuná̱tit. Abraham niucxni̱ xtlahuay hua̱ntu̱ huixín tlahuayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Huixín huá̱ tlahuayá̱tit hua̱ntu̱ tlahuay hua̱nti̱ xli̱ca̱na̱ mintla̱tcán. Xlacán chuná̱ huanipalako̱lh: —Ni̱ xli̱ca̱na̱, sa̱mpi̱ quin caj xma̱n cha̱tum quintla̱ticán huí̱, hua̱ Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús chuná̱ huaniko̱lh: —Lapi̱ xli̱ca̱na̱ cahuá̱ Dios mintla̱ticán, huixín xquimpa̱xquí̱tit, sa̱mpi̱ antá̱ cmini̱tanchá̱ c-xpa̱xtú̱n anta̱ni̱ xlá̱ huilachá. Pus quit ni̱ caj quintapa̱xuhuá̱n ma̱squi cmini̱t u̱nú̱ ca̱tuxá̱huat, huata huá̱ quimacamini̱t Dios hua̱nti̱ Quintla̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tú̱huan huixín ni̱ lay akata̱ksá̱tit hua̱ntu̱ cca̱huaniyá̱n? Huá̱ li̱lay sa̱mpi̱ huixín ni̱ kaxpatputuná̱tit hua̱ntu̱ quit quintachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Hua̱ huixín mintla̱tcán akskahuiní; huixín huá̱ tapaksi̱niyá̱tit, chu̱ huá̱ tlahuaputuná̱tit hua̱ntu̱ xlá̱ lakati̱y. Tama̱ akskahuiní̱ luhua ankalhí̱n xamakni̱ná̱ xkalhi̱y xtapuhuá̱n hasta la̱ntla̱ xquilhtzucut ca̱tuxá̱huat. Xlá̱ niucxni̱ lakati̱ni̱t hua̱ntu̱ talulóktat, chu̱ ni̱ pala hua̱ntu̱ lacati̱tum. Acxni̱ xlá̱ ma̱tzuqui̱y xta̱ksaní̱n, anta tuncán li̱tasiyuy hua̱ntu̱ xlá̱ xtapuhuá̱n, sa̱mpi̱ luhua xaaksani̱ná, chu̱ hua̱ xlá̱ xtla̱tcan pacs aksani̱naní̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Hua̱ xpa̱lacata, ma̱squi quit cuan luhua xli̱ca̱na̱ talulóktat, huixín ni̱ lay quinca̱najlaniyá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Caquihuanítit, ¿xatí̱ huixín tla̱n naquili̱makstuntlahuay ma̱squi pala tú̱ tala̱kalhí̱n? Hua̱mpi̱ ma̱squi catzi̱yá̱tit pi̱ quit ankalhí̱n cli̱chihui̱nani̱t xtalacapa̱stacni Dios, ¿Tú̱ chú̱ xpa̱lacata ni̱ quili̱ca̱najlaniyá̱tit? ");
INSERT INTO tosNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Hua̱nti̱ xli̱ca̱na̱ li̱pa̱huanko̱y Dios, chu̱ tapaksi̱niko̱y, xlacán kaxmatniko̱y xtachihuí̱n, hua̱mpi̱ cumu huixín ni̱ tapaksi̱niyá̱tit Dios, huá̱ ni̱ li̱kaxpatputuná̱tit xtachihuí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Cha̱nchu̱ yama̱ xanapuxcun judíos chuná̱ huaniko̱lh: —Luhua actancs acxni̱ cuana̱hu pi̱ huix kalhi̱ya̱ ni̱tla̱n mintá̱yat la̱ hua̱nti̱ xala c-Samaria. Ni̱ cakskahuinana̱hu acxni̱ cuanahu pi̱ makatlajani̱tán xtalacapa̱stacni akskahuiní. ");
INSERT INTO tosNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Kalhtí̱nalh Jesús: —Quit ni̱ quimakatlajama̱ xtalacapa̱stacni akskahuiní, huata yama̱ lactlanca tatlahu hua̱ntu̱ quit ctlahuako̱y, chuná̱ cli̱ma̱xqui̱ma̱ ca̱cni̱ Quintla̱t, hua̱mpi̱ huata huixín ni̱ tzinú̱ quili̱ma̱xqui̱yá̱tit ca̱cni̱ tu̱ quili̱ya̱huayá̱tit. ");
INSERT INTO tosNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Hua̱mpi̱ ni̱ huá̱ huamputún pi̱ quit luhua clacasquima̱ pi̱ pacs naquinca̱cni̱nanicán, ma̱squi xli̱ca̱na̱ huí̱ cha̱tum hua̱nti̱ lacasquín naquinca̱cni̱nanicán, chu̱ xlá̱ aksti̱tum naputza̱naniko̱y, chu̱ namaksquinko̱y cuenta̱ hua̱nti̱ ni̱ quili̱pa̱huamputunko̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Luhua xli̱ca̱na̱ tu̱ cca̱huaniyá̱n, pi̱ hua̱nti̱ nacui̱ntajtlahuay hua̱ntu̱ quit cli̱chihui̱nán, xlá̱ niucxni̱ catíni̱lh xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xlacán huanipalako̱lh: —Xli̱ca̱na̱ la̱nchú̱ luhua ctaluloka̱hu pi̱ ca̱na̱ makatlajani̱tán xtalacapa̱stacni akskahuiní, sa̱mpi̱ hua̱ xalakmaka̱n profetas, chu̱ yama̱ hua̱nti̱ quinquilhtzucutcan Abraham, xlacán pacs ni̱ko̱ni̱t; chi̱nchu̱ huix huana̱ pi̱ hua̱nti̱ nacui̱ntajtlahuay hua̱ntu̱ huix li̱chihui̱nana, niucxni̱ catíni̱lh xli̱stacna. ");
INSERT INTO tosNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Pi̱ xali̱huacá̱ chú̱ huix tlanca̱ milacatzúcut, ni̱ xahua̱ la̱ yama̱ xamaka̱n quintla̱tcan Abraham? Sa̱mpi̱ xlá̱ na̱ ni̱lh, chu̱ xli̱pacs profetas. ¿Tí̱ chú̱ huix li̱taxtuputuna? ");
INSERT INTO tosNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Kalhtí̱nalh Jesús: —Lapi̱ caj quit cacstulacasquín pi̱ naquinca̱cni̱naniyá̱tit, yama̱ quintachihuí̱n hua̱ntu̱ quit xacca̱huanín ni̱tú̱ xtápalh. Hua̱mpi̱ huata huí̱ cha̱tum hua̱nti̱ lacasquín pi̱ naquinca̱cni̱naniyá̱tit, pus hua̱ quintla̱t, huatiya̱ tamá̱ hua̱nti̱ huixín li̱ma̱xtuyá̱tit pi̱ huá̱ miDioscán. ");
INSERT INTO tosNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ma̱squi luhua chuná̱ chú̱ huixín ni̱ lakapasá̱tit xtalacapa̱stacni, hua̱mpi̱ quit xlá̱ clakapasa. Lapi̱ xackalhtátze̱kli, xacuá̱ pi̱ ni̱ clakapasa, pus na̱ luhua xaaksani̱ná̱ xacli̱táxtulh xta̱chuná̱ la̱ huixín. Hua̱mpi̱ cumu quit xli̱ca̱na̱ clakapasa, huá̱ cli̱tlahuako̱y hua̱ntu̱ xlá̱ quili̱ma̱paksi̱y. ");
INSERT INTO tosNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hua̱ yama̱ Abraham hua̱nti̱ xamaka̱n minquilhtzucutcán, xli̱ca̱na̱ luhua li̱pa̱xúhualh acxni̱ xlá̱ cajcu xpuhuama̱ pi̱ quit nacmín ca̱tuxá̱huat, huata xli̱ca̱na̱ xlá̱ ucxilhlacáchilh yuma̱ quilhtamacú̱ c-xtalacapa̱stacni, chu̱ luhua li̱pa̱xúhualh. ");
INSERT INTO tosNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yuma̱ judíos chuná̱ huaniko̱lh Jesús: —Hua̱mpi̱ huix ni̱ naj pala kalhi̱ya̱ ita̱t ciento ca̱ta̱ la̱ntla̱ lápa̱t, ¿lá̱ntla̱ chi̱nchu̱ huana̱ pi̱ ucxilhni̱ta̱ yama̱ xamaka̱n quinquilhtzucutcan Abraham? ");
INSERT INTO tosNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús chuná̱ kalhti̱ko̱lh: —Xli̱ca̱na̱ luhua lacatancs cca̱huaniyá̱n, pi̱ hasta la̱ntla̱ ni̱ naj tí̱ xlama̱ Abraham, quit xacuijá. ");
INSERT INTO tosNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Puschí̱ yama̱ judíos huakaj sacqui̱ko̱lh chíhuix laqui̱mpi̱ nali̱actalanchipako̱y Jesús; hua̱mpi̱ xlá̱ tátze̱kli̱ c-tlanca templo, tilaksti̱pa̱taxtuko̱lh tachixcuhuí̱tat, chu̱ tatampú̱xtulh. ");
INSERT INTO tosNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hua̱ la̱ntla̱ xti̱taxtuma̱ Jesús c-tiji, úcxilhli̱ cha̱tum chixcú pi̱ luhua chuna tuncán lakatzí̱n xlacachini̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Xli̱ma̱kalhtahuáka̱t chuná̱ kalhasquinko̱lh: —Ma̱kalhtahuaka̱ná, ¿lá̱ntla̱ luhua lakatzi̱n tuncán li̱lacachini̱t yuma̱ chixcú? ¿Xatí̱ cahuá̱ luhua tlahuani̱t tala̱kalhí̱n, pi̱ hua cahuá̱ xtla̱t, usuchí̱ luhua ma̱n xtala̱kalhí̱n pi̱ chuná̱ lakatzí̱n lacachini̱t? ");
INSERT INTO tosNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús chuná̱ huaniko̱lh: —Ni̱ caj huá̱ xpa̱lacata xtala̱kalhí̱n, chu̱ ni̱ pala xtala̱kalhi̱ncan xtla̱t, huata caj luhua chuná̱ lani̱t laqui̱mpi̱ antá̱ nali̱tasiyuy la̱ntla̱ tu̱ tla̱n tlahuay Dios. ");
INSERT INTO tosNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Xli̱makua ca̱cuhuinicú̱, catlahuanihu xtascújut hua̱nti̱ quimacamini̱t, sa̱mpi̱ aya talacatzuhui̱ma̱ ca̱tzi̱sní̱ acxni̱ nia̱lh lay catiscujca̱. ");
INSERT INTO tosNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quit cli̱taxtuy xkakánat hua̱ntu̱ li̱lacahua̱nanko̱y tachixcuhuí̱tat, chu̱ xli̱makua̱ clama̱ ca̱tuxá̱huat nacma̱sta̱y quixkakánat. ");
INSERT INTO tosNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Acxni̱ huá̱ yumá̱, Jesús chujli̱ ca̱tiyatna, chu̱ huá̱ li̱tláhualh actzu̱ pu̱tlú̱n xchújut, chu̱ a̱li̱sta̱lh li̱lacpi̱tláhualh c-xlakastapu̱ yama̱ lakatzí̱n. ");
INSERT INTO tosNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Cha̱nchu̱ huánilh: —Lacapala̱ capit lakachakana̱ c-taxtunú̱ anta̱ni̱ huí̱ tlanca pila̱ hua̱ntu̱ huanicán Siloé (yuma̱ tachihuí̱n c-xatachihui̱n hebreo huamputún: “Tama̱lakachá̱n”). Yama̱ lakatzí̱n lacapala̱ alh, chu̱ lakachákalh; acxni̱ chú̱ aya qui̱táspitli, tla̱ná̱ xlacahua̱nán. ");
INSERT INTO tosNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hua̱nti̱ xlakapasko̱y, chu̱ hua̱nti̱ xta̱lacatzuní̱n, chuná̱ tzúculh huanko̱y: —¿Pi̱ ni̱ hua̱ yuma̱ chixcú̱ hua̱nti̱ xtahuilay laqui̱mpi̱ nasquihua̱yán? ");
INSERT INTO tosNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Makapitzí̱n xuanko̱y: —Xli̱ca̱na̱ cuan, huá. Cha̱nchu̱ a̱makapitzí̱n xuanko̱y: —Ni̱ huá̱, hua̱mpi̱ luhua xta̱chuná̱ tasiyuy. Hua̱mpi̱ huata yama̱ chixcú̱ ma̱n xuaniko̱y: —Xli̱ca̱na̱ pi̱ quit yama̱ chixcú̱ hua̱nti̱ xacsquihua̱yán. ");
INSERT INTO tosNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Pus xlacán kalhasquinko̱lh: —¿Lá̱ntla̱ chi̱nchu̱ tla̱n lacahua̱nana? ");
INSERT INTO tosNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Xlá̱ chuná̱ huaniko̱lh: —Yama̱ chixcú̱ hua̱nti̱ huanicán Jesús caj xchújut li̱tláhualh actzu̱ pu̱tlú̱n, chu̱ quili̱lacpi̱tláhualh c-quilakastapu, chu̱ chuná̱ quihuánilh: ‘Lacapala̱ capi̱t lakachakana̱ c-pila̱ hua̱ntu̱ huanicán Siloé.’ Quit xlá̱ calh, chu̱ acxni̱ clakachakanko̱lh, aya tla̱n clacahuá̱nalh. ");
INSERT INTO tosNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Cha̱nchu̱ kalhasquimpalako̱lh: —¿Ní̱ chú̱ huí̱ yuma̱ chixcú? —Ni̱ ccatzi̱y —huaniko̱lh xlá. ");
INSERT INTO tosNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Sa̱mpi̱ yama̱ quilhtamacu̱ sábado acxni̱ Jesús tláhualh actzu̱ pu̱tlú̱n, chu̱ huá̱ li̱ma̱pácsalh yama̱ lakatzí̱n, pus luhua acxni̱ xli̱huancán pala tí̱ nascuja, huá̱ xpa̱lacata li̱le̱nca̱ c-xlacati̱ncan fariseos yama̱ chixcú̱ hua̱nti̱ xma̱lacahua̱ni̱ni̱t. ");
INSERT INTO tosNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yama̱ fariseos tzúculh kalhasquinko̱y la̱ntla̱ chú̱ tla̱ná̱ xli̱lacahua̱nán. Xlá̱ chuná̱ huaniko̱lh: —Cha̱tum chixcú̱ quili̱lacpi̱tláhualh actzu̱ pu̱tlú̱n, chu̱ acxni̱ clakachákalh, tuncán aya tla̱n clacahua̱nán. ");
INSERT INTO tosNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Makapitzi̱n fariseos chuná̱ huanko̱lh: —Yama̱ chixcú̱ hua̱nti̱ chuná̱ tláhualh, ni̱ Dios tapaksi̱niy, sa̱mpi̱ xlá̱ ni̱ ca̱cni̱naniy yama̱ quilhtamacú̱ acxni̱ jaxcán. Hua̱mpi̱ makapitzí̱n xuanko̱y: —Lapi̱ ca̱na̱ makla̱kalhi̱na cahuá̱, ¿lá̱ntla̱ chú̱ tla̱n tlahuako̱y lactlanca li̱ca̱cni tatlahu? Huata xlacán luhua lakapu̱tiyu̱ tahuilako̱lh. ");
INSERT INTO t