﻿USE sofia;
DROP TABLE IF EXISTS sofia.topNT_vpl;
CREATE TABLE topNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES topNT_vpl WRITE;
INSERT INTO topNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ixli̱talakapasnicán Jesús maká̱n ca̱ma̱lacatzuqui̱ni̱t Abraham y rey David. Ixtacuhui̱nicán jaé lacchixcuhuí̱n tí tali̱mini̱tanchá hasta tilakáhualh Jesucristo ixca̱huanicán: ");
INSERT INTO topNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ixti̱cú huá Isaac, Isaac ixti̱cú huá Jacob, y Jacob ixti̱cú huá Judá (ixca̱kalhí ma̱s ixnata̱camán). ");
INSERT INTO topNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ixti̱cú huá Fares y Zara (ixna̱najcán ixuanicán Tamar). Fares ixti̱cú huá Esrom, y Esrom ixti̱cú huá Aram. ");
INSERT INTO topNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ixti̱cú huá Aminadab, y xlá ixti̱cú huá Naasón, y Naasón ixti̱cú huá Salmón. ");
INSERT INTO topNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ixti̱cú huá Booz (ixna̱na ixuanicán Rahab), y Booz ixti̱cú huá Obed (ixna̱na ixuanicán Rut), y Obed ixti̱cú huá Isaí. ");
INSERT INTO topNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí ixti̱cú huá rey David, y rey David ta̱tamakáxtokli ixta̱cha̱t Urías y takálhi̱lh ixkahuasacán Salomón. ");
INSERT INTO topNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón ixti̱cú huá Roboam, y Roboam ixti̱cú huá Abías, y Abías ixti̱cú huá Asa ");
INSERT INTO topNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","y Asa ixti̱cú huá Josafat, y Josafat ixti̱cú huá Joram, y Joram ixti̱cú huá Uzías. ");
INSERT INTO topNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías ixti̱cú huá Jotam, Jotam ixti̱cú huá Acaz, y Acaz ixti̱cú huá Ezequías, ");
INSERT INTO topNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","y xlá ixti̱cú huá Manasés, y Manasés ixti̱cú huá Amón, y Amón ixti̱cú huá Josías. ");
INSERT INTO topNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías ixti̱cú huá Jeconías (ixca̱kalhí tunuj ixcamán). Huá jaé quilhtamacú acxni tí ixtalama̱na nac Israel ca̱li̱nca la̱ tachí̱n chu̱ta natascuja nac aktum pu̱latama̱n huanicán Babilonia. ");
INSERT INTO topNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Acxni ixtalama̱najcú ní ixca̱li̱ncani̱t, Jeconías ixti̱cú huá Salatiel, y Salatiel ixti̱cú huá Zorobabel. ");
INSERT INTO topNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel ixti̱cú huá Abiud, y Abiud ixti̱cú huá Eliaquim, y Eliaquim ixti̱cú huá Azor. ");
INSERT INTO topNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ixti̱cú huá Sadoc, Sadoc ixti̱cú huá Aquim y Aquim ixti̱cú huá Eliud. ");
INSERT INTO topNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ixti̱cú huá Eleazar, Eleazar ixti̱cú huá Matán, y xlá ixti̱cú huá Jacob. ");
INSERT INTO topNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ixti̱cú huá José, huá jaé chixcú tí a̱stá̱n ta̱tamakáxtokli María ixna̱na Jesús tí li̱maca̱ncán Cristo ixama ca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chuná jaé la̱ta tica̱ma̱lacatzúqui̱lh Abraham hasta tilakáhualh rey David talácstacli cha̱cu̱ta̱ti ixlacata lakko̱lún; y la̱ta tilatama̱lh rey David hasta tica̱li̱nca la̱ tachí̱n nac Babilonia talacstacpá cha̱cu̱ta̱ti ixlacata lakko̱lún, y cha̱cu̱ta̱ti talacstacpá la̱ta tica̱li̱nca la̱ tachí̱n hasta tilakáhualh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cama li̱chihui̱nán la̱ qui̱táxtulh acxni tilakáhualh Jesús ca̱quilhtamacú: María, ixna̱na Jesús, ixtasquín ixuí ixama ta̱tamakaxtoka José; pero la̱ta ya̱ ixta̱latamá, y ni̱ para tí ixmacxamani̱t, Dios ma̱lakachá̱nilh María camactánulh ixli̱tlihueke Espíritu Santo y xlá maklhcátzi̱lh acxni ta̱tá̱yalh cha̱tum skata. ");
INSERT INTO topNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Acxni cátzi̱lh José xlacata ixlí̱i̱t María ixta̱yajá skata, ni̱ ma̱lacápu̱lh xlacata ni̱ nali̱kalhkama̱nancán pero tze̱k ixama makxtaka, ixama lactlahuakó ixtachihuí̱n ni̱ma̱ ixlacca̱xtlahuani̱t, pues xlá ti̱tum ixlama tla̱n chixcú ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Chuná jaé ixlacpuhuán, y maktum la̱ta itlhtatama li̱ma̱níxnalh cha̱tum ángel xla Dios, xlá lakata̱yachi y huánilh: ―José ixli̱talakapasni rey David, ni̱ cama̱pálajti mintapuhuá̱n, cata̱tamakáxtokti María y cata̱latapa porque namá skata ni̱ma̱ ta̱yajá ixli̱tlihueke Espíritu Santo ta̱ya̱huani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Y acxni nalakahuán namá skata, nahuili̱niya ixtacuhui̱ní Jesús. Jaé tachihuí̱n huamputún “tí quinca̱lakma̱xtuyá̱n”, porque xlá ama ca̱ma̱ke̱nu̱ní ixtala̱kalhi̱ncán hua̱k ixcamán Dios. ");
INSERT INTO topNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Huá jaé qui̱táxtulh xlacata María nama̱kantaxtí tú ma̱lacpuhuá̱ni̱lh Dios cha̱tum profeta; xlá chuné chihuí̱nalh: ");
INSERT INTO topNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Cha̱tum tzuma̱t la̱ta ni̱ macxamani̱t chixcú ama ta̱ta̱yá cha̱tum skata, y ama̱ca li̱ma̱pa̱cuhui̱cán Emanuel. (Jaé tachihuín huamputún: “Dios quinca̱ta̱lamá̱n.”) ");
INSERT INTO topNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Acxni stácnalh José, ma̱kantáxti̱lh tú huánilh amá ángel, ta̱tamakáxtokli María y ta̱latáma̱lh la̱ ixta̱cha̱t. ");
INSERT INTO topNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ni̱ lakxtum ta̱lhtátalh hasta lakáhualh xla̱huán itskata María, y José huilínilh ixtacuhui̱ní Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús lakáhualh nac actzú ca̱chiquí̱n huanicán Belén ixli̱tapaksí Judea, y aná jaé lanca pu̱latama̱n ixma̱paksi̱nán rey Herodes jaé quilhtamacú. Ni̱ ixli̱maka̱s táchilh nac Jerusalén makapitzi lacchixcuhuín huanicán magos tí ixtali̱kalhtahuaká la̱ tla̱huán stacu, ixtamín nac aktum pu̱latama̱n pakán ní ixlactaxtú chichiní. ");
INSERT INTO topNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Xlacán tzúculh takalasquini̱nán: ―¿Nicu huí amá actzú rey ni̱ma̱ lakahuani̱t y ama ma̱lacatzuquí ixtapáksi̱t nac Israel? Nac quimpu̱latama̱ncán cacxilhui la̱ tzúculh lakaskoy itstacu nac akapú̱n, y huá cli̱mini̱táu lakachixcuhui̱yá̱u. ");
INSERT INTO topNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","4","Hua̱k cristianos xalac Jerusalén tzúculh ta̱katuyún, ixtacatzi̱putún ticu yá skata ixlakahuani̱t ixama ca̱ma̱paksí. Rey Herodes na̱ chuná tzúculh tatlaká, y lacapala ca̱ma̱makstokko̱lh xanapuxcun curas y ixma̱kalhtahuake̱nacán judíos. Ca̱kalasquínilh: ―Quila̱huaníu, ¿ni̱ catzi̱yá̱tit para profetas tancs tali̱lhca̱ni̱t lihua neje yá ca̱chi̱quín ama lakahuán Cristo tí huaná̱tit ama ca̱lakma̱xtuyá̱n? ");
INSERT INTO topNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xlacán takálhti̱lh: ―Amá Cristo ama lakahuán nac Belén porque cha̱tum namá profetas, Dios chuné ma̱lacpuhuá̱ni̱lh natzoka nac ixlibro: ");
INSERT INTO topNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Huix li̱xcájnit actzú ca̱chiquí̱n Belén, ni̱tú cali̱púhuanti, ma̱squi nac pu̱latama̱n Judea lakmakancana aná jaé ca̱chiquín ama lakahuán cha̱tum xapuxcu chixcú tí ama ca̱maktakalha quincamán xalac Israel. ");
INSERT INTO topNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Astá̱n Herodes tze̱k ca̱tasánilh amá magos y ca̱kalhpútzalh lihua xnicu ixta̱cxilhni̱t tzúculh lakskoy itstacu Cristo. ");
INSERT INTO topNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y la̱ ca̱li̱cxilhko̱lh, ca̱huánilh: ―Capítit nac Belén y calacaputzátit namá skata; y acxni nataka̱sá̱tit nataná̱tit quila̱huaniyá̱u lihua nicu huí xlacata na̱ nacán lakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","La̱ ca̱ta̱chihui̱nanko̱lh rey Herodes xlacán tata̱yapá nac tijia, y amá stacu tzucupá ca̱pu̱laní ní ixtatla̱huama̱na hasta tácha̱lh nac Belén. Y acxni tatalacatzúhui̱lh ní ixlakahuani̱t Jesús, amá stacu tancs ta̱tá̱yalh ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Xlacán tali̱pa̱xahuako̱lh tú ixta̱cxilhma̱na, ");
INSERT INTO topNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","y tatziyanti̱lhá tatánu̱lh nac ákxtaka y tá̱cxilhli amá skata ixkokama ixna̱na María. Tuncán tatatzokóstalh y talakachixcúhui̱lh. Astá̱n tama̱kálhke̱lh cajas ní ixtamuju̱ni̱t la̱ta tú ixtali̱mín, y tama̱squíhui̱lh amá actzú skata: oro, incienso y xamu̱csún mirra. ");
INSERT INTO topNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Astá̱n acxni talhtátalh, cha̱tum ángel ca̱ma̱ma̱níxni̱lh ni̱ catalactáspitli nac Jerusalén ní ixlama rey Herodes xlacata ni̱tú catali̱ma̱kalhchihuí̱ni̱lh; y talácalh ixpu̱latama̱ncán a̱lacatunu tijia. ");
INSERT INTO topNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","La̱ ta̱nko̱lh amá paxia̱lhnaní̱n, cha̱tum ixángel Dios ma̱ma̱níxni̱lh José acxni itlhtatama, y huánilh: ―La̱ta chí tuncán cata̱qui y cata̱tza̱la namá skata na̱ chuná ixna̱na; caca̱li̱pi nac pu̱latama̱n Egipto. Aná calatapa hasta xní nacuaniparayá̱n tú mili̱tláhuat, porque rey Herodes ama tzaksá makní jaé skata. ");
INSERT INTO topNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","José pi̱huá amá ca̱tzisní ca̱ta̱tzá̱lalh amá skata y na̱ chuná María pakán nac Egipto. ");
INSERT INTO topNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aná talatáma̱lh hasta tíni̱lh rey Herodes. Chuná jaé kantáxtulh ixtachihuí̱n Dios ni̱ma̱ tima̱lacpuhuá̱ni̱lh profeta Josías natzoka nac ixlibro, y xlá huá: “Cli̱ma̱paksí̱nalh cali̱minca quinkahuasa catáxtulh ní latamá cEgipto.” ");
INSERT INTO topNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes li̱cuánit sí̱tzi̱lh acxni ma̱kachákxi̱lh la̱ ixta̱kskahuini̱t amá magos pues ni̱ ixtalactaspitni̱t ní ixca̱huanini̱t. Xlá ca̱li̱ma̱páksi̱lh soldados catáalh nac Belén y catamákni̱lh hua̱k lactzú lakkahuasán ni̱ma̱ ya̱ ixtama̱sputú aktuy ca̱ta, pues amá magos tí ixca̱ta̱chihui̱nani̱t ixtahuanini̱t xlacata ixkalhí como aktuy ca̱ta la̱ta xla̱huán titá̱cxilhli itstacu Cristo. ");
INSERT INTO topNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jaé tamakní̱n ni̱ma̱ tláhualh rey Herodes li̱ma̱kantáxti̱lh tú istzokni̱t profeta Jeremías, xlá huá: ");
INSERT INTO topNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Aná nac aktum actzú ca̱chiquín huanicán Ramá, takaxmatí la̱ ta̱ktasá tí ta̱kxtakajnán; mákat taquilhchá̱n la̱ta tatasá, pues ixlacchajancán talaktasá, la̱ta tali̱puhuán ixcamancán ni̱ma̱ tamakatzanka̱ni̱t; y ni̱ talacasquín tí naca̱ta̱chihui̱nán li̱pa̱xáu. ");
INSERT INTO topNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Táalh quilhtamacú rey Herodes ni̱lh y maktum acxni itlhtatama José, cha̱tum ixángel Dios ma̱ma̱níxni̱lh y huánilh: ");
INSERT INTO topNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Cata̱qui, caca̱ta̱taspitpara namá actzú kahuasa y na̱ chuná ixna̱na nac mimpu̱latama̱ncán Israel porque tí ixtamakni̱putún chí tani̱lhá. ");
INSERT INTO topNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José ta̱yapá nac tijia ca̱ta̱ampá Jesús y María pakán ixpu̱latama̱ncán Israel. ");
INSERT INTO topNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","La̱ta ya̱ ixchá̱n nac Judea catzi̱tá̱yalh nac tijia xlacata acxni ni̱lh rey Herodes tzúculh ma̱paksi̱nán ixlakapu̱xoko ixkahuasa ixuanicán Arquelao. José jícualh tziná y ni̱ cha̱mpútulh aná, pero maktum acxni itlhtatama, cha̱tum ixángel Dios ma̱ma̱níxni̱lh y huánilh caalh latamá nac Galilea. ");
INSERT INTO topNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ti̱tum tácha̱lh amá pu̱latama̱n Galilea y táalh talatamá nac aktum actzú ca̱chiquí̱n huanicán Nazaret. Profetas taquílhcha̱lh acxni tali̱chihuí̱nalh xlacata Cristo tí ixama ca̱lakma̱xtú cristianos ixama li̱ma̱pa̱cuhui̱cán nazareno. ");
INSERT INTO topNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Juan Bautista acxni lákcha̱lh ixquilhtamacú nama̱lacatzuquí ixtascújut, alh aná ní ni̱tí talama̱na nac desierto ni̱ma̱ ixuí nac pu̱latama̱n Judea. Xlá tzúculh tzaksá ca̱ma̱tancsá cristianos, ");
INSERT INTO topNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","y ca̱li̱tlá̱n ixca̱huaní: ―Catalakxta̱palí̱tit ni̱ tla̱n milatama̱tcán y cali̱pa̱huántit Dios porque accha̱ni̱t ixquilhtamacú acxni Dios nama̱lacatzuquí sa̱sti ixtapáksi̱t nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Profeta Isaías maká̱n ixli̱chihui̱nani̱t ixtascújut Juan, y lacatum chuné istzokni̱t ixlacata: Nac desierto ama takaxmatí la̱ aktasá acxni ma̱kalhchihui̱ni̱nán cha̱tum chixcú: “Catacá̱xtit, tancs calatapá̱tit, ti̱tum catrapí̱tit ixtijia milatama̱tcán, pues mima ca̱lakpaxia̱lhnaná̱n Mimpu̱chinacán.” ");
INSERT INTO topNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan ixli̱tlahuani̱t ixlháka̱t ixmakxu̱hua camello, ixli̱tampu̱lakchi̱cani̱t aktum cinturón xla xu̱hua; ixli̱hua̱yán lactzú xtuqui y táxca̱t xala ca̱quihuí̱n ni̱ma̱ ixca̱taka̱sa. ");
INSERT INTO topNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ixtaán takaxmata Juan nac desierto lhu̱hua cristianos xala ca̱chiquí̱n xla Jerusalén y tí ixtalama̱na ixli̱ti̱lanca pu̱latama̱n Judea, y na chuná tí ixtalama̱na ixquilhpa̱ni̱tni kalhtuchoko Jordán. ");
INSERT INTO topNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tí ixtali̱ta̱yá ixtala̱kalhi̱ncán ixli̱hua̱k ixnacujcán xlá ixca̱kmunú nac kalhtu̱choko Jordán. ");
INSERT INTO topNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero namá judíos tí ixca̱huanicán fariseos y tí ixca̱huanicán saduceos na̱ tzúculh tamín na̱ naca̱kmunucán. Xlá ixca̱lakakahuaní, ixca̱ta̱ma̱lacastuca ixkasatcán lacli̱cuánit lu̱hua; chuné ixca̱huaní: ―Huixín la̱ ixli̱talakapasnicán xcananí̱n lu̱hua. ¿Ticu ca̱huanín para ta̱kmunuyá̱tit pa̱t taxtuniyá̱tit ta̱kxtakajni ni̱ma̱ talacatzuhui̱ma? ");
INSERT INTO topNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ma̱s ca̱macuaniyá̱n pu̱la calakxta̱palí̱tit milatama̱tcán y cama̱sí̱tit xli̱ca̱na lapa̱nántit la̱ lactlá̱n cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","¿A poco puhuaná̱tit huixín ni̱tú ama ca̱pa̱xtoká̱n porque li̱tanu̱yá̱tit ixli̱talakapasni Abraham? Namá ni̱tú li̱macuán porque aquit tancs cca̱huaniyá̱n, Dios para ixlacásquilh tla̱n ca̱lakxta̱palí catu̱ya̱huá chíhuix y ixli̱talakapasni Abraham ca̱tlahuá. ");
INSERT INTO topNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Dios ca̱cxilhni̱t lhu̱hua cristianos la̱ quihui ni̱ma̱ yaj tú tali̱macuán; ixhacha ma̱kapu̱ya̱huani̱ttá ama ca̱ma̱xoko̱ní. Namá cristianos tí ca̱li̱macá̱n quihui ni̱ma̱ yaj tama̱stá tla̱n ixtahuácat nac ixlatama̱tcán ama ca̱tancá y ama ca̱ma̱pú nac lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Tí talakmakán ixtala̱kalhi̱ncán aquit cca̱liakmunú chúchut xlacata naca̱li̱lakapascán talakxta̱pali̱ni̱t ixlatama̱tcán, pero amajá chin cha̱tum tí cpu̱lanima y huá tí kalhí li̱tlihueke que ni̱ siquiera cma̱ta̱xtuca ixtasa̱cua nacuán tí nakatxcuta nama̱xtuní ixtatu̱nu. Xlá ama ca̱liakmunuyá̱n ixli̱tlihueke Espíritu Santo y ama ca̱li̱cxila mintapuhua̱ncán nac lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y jaé tí ama ca̱lacsaca cristianos, lacpuhuani̱ttá la̱ ama ca̱ma̱pitzí, naca̱tlahuá la̱ tí ma̱lakkosú itstapu. Ama ma̱xtú hua̱k palhma ni̱ma̱ ta̱lani̱t, ama ma̱pú nac lhcúya̱t ni̱ma̱ ni̱cxni laksputa; y hua̱k xalacscarancua ixtalhtzi ixtachaná̱n ama ma̱quí nac ixchic xlacata ni̱tú nalaní. ");
INSERT INTO topNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ni̱ ixli̱maka̱s quilhtamacú Jesús taxtutá̱qui̱lh ixca̱chiquí̱n nac Galilea y alh pakán nac kalhtu̱choko Jordán xlacata naakmunú Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero xlá ni̱ akmunupútulh y huánilh: ―¿Hua̱nchi quilaktana xlacata aquit nacakmunuyá̱n? Aquit chá clacasquín huix naquiakmunuya porque huix ma̱s tali̱pa̱u. ");
INSERT INTO topNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús kálhti̱lh: ―Ni̱tú cahuanti huix; caquiakmunu. Chí tamaclacasquiní cama̱kantaxti̱huí tú laclhca̱ni̱t Dios natlahuayá̱u nac quilacatacán. ");
INSERT INTO topNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan yaj ma̱s tú huánilh y akmúnulh Jesús nac kalhtu̱choko Jordán; y acxni tzúculh tacuta nac ixquilhtú̱n chúchut, tási̱lh la̱ akapú̱n talácqui̱lh y tá̱ctalh Ixespíritu Dios la̱ tantum paloma y akchipánilh ixtalacapa̱stacni Jesús y chuná jaé maklhtí̱nalh ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nac akapú̱n takaxmáti̱lh jaé tachihuí̱n: ―Huá jaé quinkahuasa ni̱ma̱ clakalhamán y snu̱n cli̱pa̱xahuá la̱ ckalhí. ");
INSERT INTO topNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","La̱ ta̱kmunuko̱lh Jesús Espíritu Santo ma̱cxcatzí̱ni̱lh naán latamá nac desierto xlacata tlajaná nali̱cxila ixtapuhuá̱n para tla̱n nama̱tlahuí tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Xlá ni̱tú li̱huá̱yalh la̱ta latáma̱lh nac desierto ti̱puxum chichiní y ti̱puxum ca̱tzisní, pero acxni tzincsli tlajaná tuncán ma̱laktzanke̱pútulh ixtapuhuá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ni̱ para cátzi̱lh la̱ lakata̱yachi y huánilh: ―Para xli̱ca̱na huix Ixkahuasa Dios y kalhi̱ya li̱tlihueke, jaé chíhuix, simita caca̱tlahua. ");
INSERT INTO topNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Xlá kálhti̱lh: ―¡To! Pues nac Escrituras huan: “Ni̱ huata simita tla̱n li̱latamá cha̱tum chixcú, na̱ tamaclacasquiní nali̱kalhkasa ixli̱stacni xli̱hua̱k ixtachihuí̱n Dios ni̱ma̱ li̱ma̱paksi̱nán.” ");
INSERT INTO topNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Astá̱n tlajaná tá̱alh Jesús nac ixakstí̱n lanca pu̱siculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y aná kalhputzapá: ―Para xli̱ca̱na huix Ixkahuasa Dios capa̱tasta la̱ta ixli̱ta̱lhmá̱n jaé pu̱siculan, pues nac Escrituras tatzokni̱t: Dios ama ca̱ma̱lakachá ixángeles natamaktakalhá̱n, y natali̱chipapa̱xtoká̱n ixmacán xlacata ni̱ nata̱cuacaya y natalaxtapa̱ya nac ca̱chihuixni. ");
INSERT INTO topNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Xlá kalhti̱pá: ―Pero nac Escrituras tatzokni̱t: “Mimpu̱chiná Dios ni̱cxni chu̱ta cali̱kalhkamá̱nanti xlacata natlahuá milacata tú ni̱ macuaniyá̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tlajaná ta̱ampá Jesús nac ixakstí̱n aktum lanca sipi y ma̱lacahuá̱ni̱ko̱lh hua̱k pu̱ma̱paksi̱n xala ca̱quilhtamacú y la̱ li̱cá̱cni̱t tahuila̱na. ");
INSERT INTO topNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y amá tlajaná huánilh: ―Aquit nacmacama̱xqui̱yá̱n hua̱k jaé pu̱latama̱n para quintatzokostaniya y quilakachixcuhui̱ya la̱ mimpu̱chiná. ");
INSERT INTO topNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero Jesús kálhti̱lh: ―¡Catake̱nu ní cyá tlajaná! Porque nac Escrituras huan: “Huata Dios Mimpu̱chiná calakachixcuhui y huata huá cakaxpatni tú li̱ma̱paksi̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Amá tlajaná yaj tú tá̱yalh y akxtakyá̱hualh Jesús; a̱stá̱n támilh ángeles xalac akapú̱n y tamá̱xqui̱lh tú ixmaclacasquín nali̱latamá. ");
INSERT INTO topNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ni̱ ixli̱maka̱s Juan Bautista ma̱nu̱ca nac pu̱la̱chi̱n; acxni cátzi̱lh Jesús ampá nac Galilea y cha̱lh nac Nazaret ana ní itstacni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero ni̱ maka̱s tamákxtakli juú y alh latamá nac Capernaum; jaé ca̱chiquí̱n ixuí ixquilhtú̱n pupunú Galilea ixca̱ta̱kalhpa̱xtoka aktuy pu̱latama̱n ca̱huanicán Zabulón y Neftalí. ");
INSERT INTO topNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chuná jaé Jesús ma̱kantáxti̱lh tú istzokni̱t ixlacata profeta Isaías: ");
INSERT INTO topNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nac ixacpún kalhtu̱choko Jordán ana ní lacatzucú lanca pu̱latama̱n Galilea, nac tijia ni̱ma̱ an nac pupunú, tahuila̱na aktuy actzú ca̱chiquí̱n Zabulón y Neftalí, y tí talama̱na juú ca̱lakmakancán porque ni̱ judíos; ");
INSERT INTO topNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","xlacán ca̱paklhtu̱tá ixtalama̱na pero ca̱lákchilh lanca taxkáket tú natali̱lacahua̱nán; y ma̱squi ixamajá ta̱kchakxa y talaktzanká, tla̱n tali̱lacahuá̱nalh amá taxkáket. ");
INSERT INTO topNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","La̱ta amá quilhtamacú Jesús tzúculh ca̱ma̱kalhchihui̱ní cristianos, ixca̱huaní: ―Calakxta̱palí̱tit ni̱ tla̱n milatama̱tcán y cali̱pa̱huántit Dios porque accha̱ni̱t quilhtamacú ama ma̱lacatzuquí sa̱sti ixtapáksi̱t nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Maktum quilhtamacú Jesús ixtla̱huama ixquilhtú̱n pupunú xla Galilea acxni cá̱cxilhli cha̱tuy chakananí̱n ixtamuju̱ma̱na istza̱lhcán nac chúchut, cha̱tum ixuanicán Simón y a̱stá̱n li̱tapa̱cúhui̱lh Pedro, ixta̱cam ixuanicán Andrés. ");
INSERT INTO topNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús ca̱huánilh: ―Huixín xchipananí̱n tamakní, ¡quila̱takokéu y aquit nacca̱ma̱si̱niyá̱n la̱ ca̱chipacán cristianos tí ta̱ktzanka̱ni̱t! ");
INSERT INTO topNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Xlacán ni̱ para tla̱n takaxmatko̱lh, tuncán ta̱kxtakmákalh istza̱lhcán y tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tla̱huampá a̱laktzú y ca̱cxilhpá cha̱tuy li̱ta̱camán Jacobo y Juan, xlacán ixtata̱taju̱ma̱na ixti̱cucán huanicán Zebedeo nac aktum barco, ixtalakaxtokoma̱na istza̱lhcán ni̱ma̱ ixtapu̱chakanán. Jesús na̱ ca̱huánilh catatakókelh; ");
INSERT INTO topNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","y na̱ chuná ni̱ para tla̱n takaxmatko̱lh ta̱kxtakmákalh ixti̱cucán, istza̱lhcán, y tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ca̱ta̱lakatza̱lako̱lh ixdiscípulos amá pu̱latama̱n Galilea y la̱ta ní ixchá̱n ixtanú nac ixpu̱tamakstoknicán judíos ni̱ma̱ ixuí nac ca̱chiquí̱n y aná ixca̱ma̱kalhchihui̱ní cristianos, ixca̱huaní la̱ Dios ixma̱lacatzuqui̱putún sa̱sti ixtapáksi̱t nac ixlatama̱tcán. Y na̱ chuná ixca̱ma̱ksa̱ní cristianos ni̱ma̱ ixtakalhí xatu̱ta yá tá̱tat o tasipá̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hua̱k ixtascújut Jesús ni̱ma̱ ixca̱tlahuáy ixca̱li̱chihui̱nancán cani̱huá mákat pu̱latama̱n y lhu̱hua tzúculh tali̱mín ixta̱tatlaní̱n, hasta tí xtalama̱na nac aktum mákat pu̱latama̱n huanicán Siria na̱ tacátzi̱lh. Ixca̱li̱mincán tí ixtakalhí ti̱pa̱katzi tá̱tat, tasipá̱ni̱t, para tí xca̱makatlajani̱t tlajaná, para tí ixtastaka̱ni̱ni̱t, para tí ixtalaclu̱nchu̱ni̱t; Jesús hua̱k ixca̱ma̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","La̱ta ní ixán ixtatakoké lhu̱hua cristianos xala cani̱huá pu̱latama̱n para xalac Galilea, Decápolis, Jerusalén, Judea y hasta tí ixtalama̱na ixli̱quilhtu̱na̱chá kalhtu̱choko Jordán. ");
INSERT INTO topNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Maktum tunuj quilhtamacú Jesús ácxilhli la̱ ixtatakokeni̱t lhu̱hua cristianos. Xlá talacá̱cxtulh aktum sipi y acxni cha̱lh ní ca̱xtum tziná, aná curucs ca̱ta̱tahuilako̱lh ixdiscípulos ");
INSERT INTO topNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","y tzúculh ca̱huaní jaé laclanca talacapa̱stacni la̱ ixli̱latama̱tcán: ");
INSERT INTO topNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Catapa̱xáhualh ni̱ cata̱katúyulh amá tí tali̱ta̱yá huí tú ca̱tzanka̱ní nac ixnacujcán, pues tí chuná jaé takalhí ixtalacapa̱stacnicán Dios lakatí ca̱maklhti̱nán nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí laccamama talaktasá tú tapa̱xtoka cristianos, porque Dios ama ca̱ma̱xquí li̱camama natatziyán. ");
INSERT INTO topNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí ni̱ talakatí talactlancán, pues nac ixpa̱xtú̱n Dios ama ca̱maklhti̱nán hua̱k tú cama̱lacnu̱ni̱t naca̱ma̱xquí tí tali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí xli̱hua̱k ixnacujcán talacputzá la̱ tancs natalatamá, porque Dios ama ca̱ma̱xquí tú taputzá. ");
INSERT INTO topNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí tla̱n tacatzí y ca̱lakalhamán xa̱makapitzi cristianos, porque Dios na̱ ama ca̱lakalhamán. ");
INSERT INTO topNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí aktum tahuili̱ni̱t ixtapuhua̱ncán natamacuaní Dios nac ixlatama̱tcán, porque xlá ama ca̱ma̱cxcatzi̱ní ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Catapa̱xáhualh ni̱ cata̱katúlh amá tí tama̱koxumixí cristianos ni̱ catará̱slakli, porque Dios ama ca̱li̱macá̱n xli̱ca̱na ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Catapa̱xáhualh ni̱ cata̱katúyulh amá tí tancs talama̱na ni̱tú ixlakxtucán, pero ca̱liakskahuinancán y ca̱ta̱ra̱slakcán, pues la̱ jaé tí Dios lakatí ca̱maklhti̱nán nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Capa̱xahuátit ni̱ ca̱katuyúntit huixín tí caj quilacata ca̱li̱ya̱huacaná̱tit tú ni̱ ca̱na, ca̱pu̱tlakacaná̱tit y ca̱ma̱kxtakajni̱caná̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","¡Cama̱tla̱ní̱tit tú ca̱lakcha̱ni̱tán y ni̱tú cali̱puhuántit! Porque Dios Minticucán ama ca̱ma̱xqui̱yá̱n mintaxoko̱ncán nac akapú̱n. Ca̱ksántit profetas ni̱ma̱ talatáma̱lh maká̱n, na̱ chuná ca̱pu̱tlakaca y ca̱ma̱kxtakajni̱ca ma̱squi Dios ixca̱ma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Aquit cca̱li̱ma̱nu̱yá̱n ca̱quilhtamacú la̱ mátzat ni̱ma̱ li̱ma̱skoke̱nancán; huixín pa̱t ca̱ma̱ta̱yani̱yá̱tit cristianos xlacata ni̱ natalaktzanká. Huixín catzi̱yá̱tit la̱ mátzat li̱ma̱skoke̱cán li̱hua xlacata nata̱yaní; pero para namá mátzat yaj ma̱skoke̱nán a̱huata maka̱ncán y cati̱huá tla̱n lacta̱yamí. ");
INSERT INTO topNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Chuná li̱tum, ixlacati̱ncán cristianos huixín ixtaxkaketcán tú ama tali̱lacahua̱nán ca̱quilhtamacú, na̱ chuná la̱ aktum ca̱chiquí̱n ni̱ma̱ huí ixakstí̱n sipi, cati̱huá ma̱squi mákat tla̱n li̱lacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nac aktum ákxtaka ni̱cxni aktlapanu̱cán pu̱skon, siempre huili̱cán ta̱lhmá̱n xlacata hua̱k cristianos natalacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Y huixín na̱ chuná caca̱li̱ma̱lacahuaní̱tit xa̱makapitzi cristianos milatama̱tcán, y la̱ta tú tlahuayá̱tit xlacán tla̱n natali̱lacahua̱nán mintaxkaketcán y nata̱cxila la̱ Dios ca̱makskoyuli̱ná̱n, y acxni natasí mintascujutcán natali̱lakachixcuhuí Mimpu̱chinacán Dios xalac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ni̱ capuhuántit huixín xlacata cmini̱t cca̱ma̱ke̱nú tú li̱ma̱paksi̱nani̱t Dios ca̱quilhtamacú, la̱ namá tapáksi̱t ni̱ma̱ má̱xqui̱lh Dios profeta Moisés y na̱ chuná tú tama̱si̱ni̱t xa̱makapitzi profetas; aquit cmini̱t ca̱ma̱tancsá la̱ta tú ni̱ chuná ma̱kachakxi̱ni̱tántit y ni̱ chuná tlahuayá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ixli̱hua̱k quinacú cca̱huaniyá̱n ni̱ huí tí ama ma̱ke̱nú ni̱ para akstum tachihuí̱n tú li̱ma̱paksi̱nani̱t Dios nac Escrituras; tamaclacasquiní cakantáxtulh hua̱k ixtapuhuá̱n ni̱ma̱ laclhca̱ni̱t ca̱quilhtamacú y nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Cati̱huá tí lakmakán y ni̱ ma̱kantaxtí nac ixlatáma̱t ma̱squi caj actzú ixtapáksi̱t Dios porque puhuán ni̱tú li̱macuán y ca̱ma̱si̱ní xa̱makapitzi catamakslihuékelh, nac ixtapáksi̱t Dios namá chixcú ama̱ca li̱maca̱ncán la̱ cha̱tum takalhí̱n chixcú. Pero tí ca̱ma̱kantaxtí nac ixlatáma̱t ma̱squi caj lactzú ixtapáksi̱t Dios y ca̱ma̱si̱ní xa̱makapitzi catamakslihuékelh, nac ixtapáksi̱t Dios ama̱ca li̱maca̱ncán cha̱tum tali̱pa̱u chixcú. ");
INSERT INTO topNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Xa̱huá, para huixín ni̱ lacputzayá̱tit la̱ naca̱liakapu̱layá̱tit lactlá̱n tapuhuá̱n namá fariseos y ixma̱kalhtahuake̱nacán judíos y ca̱makslihuekeyá̱tit ixkasatcán, ni̱ lá pa̱t li̱pa̱xahuayá̱tit tú Dios ma̱lacnu̱ni̱t naca̱ma̱xquí tí xli̱ca̱na tali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Huixín catzi̱yá̱tit la̱ huan amá ixtapáksi̱t Moisés ni̱ma̱ maká̱n quinca̱ma̱xquí̱n: “Ni̱cxni tí camákni̱lh ixta̱cristiano”, y na̱ huan: “Tí makní ixta̱cristiano cama̱lacapu̱ca xlacata naxoko̱nán.” ");
INSERT INTO topNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero chí cca̱huaniyá̱n ma̱s tancs tachihuí̱n: Cati̱huá tí tara̱si̱tzi̱ní ixta̱cristiano y ni̱ ma̱tzanke̱naní, na̱ mini̱ní nama̱lacapu̱cán xlacata naxoko̱nán. Tí huaní ixta̱cristiano: “Huix takalhí̱n”, mini̱ní nama̱lacapu̱cán ixlacati̱ncán lactali̱pa̱u ma̱paksi̱naní̱n xlacata xlacán natama̱xoko̱ní. Y amá tí cuchu̱huí ixta̱cristiano o lacpuhuaní calaktzánka̱lh, namá tla̱n ama̱ca maca̱ncán nac puakxtakajni ana ní ma̱s tapala̱xlá ama akxtakajnán. ");
INSERT INTO topNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Xa̱huá para huix li̱pina mili̱lakachixcuhui̱n nac pusiculan, y lihua pa̱t lakachixcuhui̱ya Dios acxni aksana xlacata ta̱ra̱makasi̱tzi̱ni̱ta minta̱cristiano, ");
INSERT INTO topNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","camákxtakti nac ixpa̱xtú̱n pu̱lakachixcuhui̱n tú li̱pina y pu̱la capit ta̱lacca̱xlaya minta̱cristiano xlacata nama̱tzanke̱naniyá̱n tú li̱makatzanka̱ni̱ta, y a̱stá̱n nataspita y li̱pa̱xáu namacama̱sta̱ya mili̱lakachixcuhui̱n ixli̱hua̱k minacú. ");
INSERT INTO topNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Chuná li̱tum, para tí ta̱ra̱makasi̱tzi̱yá̱n y huaniyá̱n ama ma̱lacapu̱yá̱n, la̱ta ya̱ ma̱laksi̱yá̱n cata̱lacca̱xla ca̱li̱tlá̱n xlacata ni̱ natasanicana nac pu̱ma̱paksí̱n y nama̱nu̱cana nac pu̱la̱chí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pues para tanu̱ya aná, pa̱t xokoko̱ya la̱ta tú nali̱ma̱lacapu̱cana. ");
INSERT INTO topNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Huixín catzi̱yá̱tit la̱ huan amá li̱ma̱paksí̱n ni̱ma̱ maká̱n quinca̱ma̱xqui̱ca: “Ni̱cxni tí calakamáklhti̱lh ixpusca̱t ixta̱cristiano.” ");
INSERT INTO topNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero chí cca̱huaniyá̱n ma̱s tancs tachihuí̱n: Cati̱huá tí ma̱squi laca̱ní cha̱tum pusca̱t y kalhi̱putún tuncán, pues nac ixnacú tlahuá tala̱kalhí̱n ixlacatí̱n Dios y na̱ mini̱ní naxoko̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Para aktum milakastapu ma̱laktzanke̱yá̱n natlahuaya tala̱kalhí̱n, ¡cama̱xtu y catramákanti mákat! Pues ma̱s macuaniyá̱n camakatzanka aktum milakastapu y ni̱ la̱ta katzi̱ya namacapincana nac pu̱pa̱tí̱n ana ní naakxtakajnana. ");
INSERT INTO topNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuná li̱tum para aktum mimacán ma̱laktzanke̱yá̱n natlahuaya tala̱kalhí̱n, ¡caca̱cti y catramákanti mákat! Pues ma̱s macuaniyá̱n camakatzanka aktum mimacán y ni̱ la̱ta katzi̱ya namacapincana nac puakxtakajni. ");
INSERT INTO topNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Huixín catzi̱yá̱tit la̱ huan amá li̱ma̱paksi̱n ni̱ma̱ maká̱n quinca̱ma̱xqui̱ca: “Tí tamakaxtokni̱t y makxtakputún ixta̱cha̱t, huata camá̱xqui̱lh ixpusca̱t aktum cápsnat tla̱n xaca̱xlán ixlacatí̱n pu̱ma̱paksí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero chí aquit cca̱huaniyá̱n ma̱s tancs tachihuí̱n: Cha̱tum chixcú tí makxtaka ixta̱cha̱t tlahuá quilhmactuy tala̱kalhí̱n ixlacatí̱n Dios, pues namá pusca̱t ma̱squi ni̱ ixkalhí tunuj chixcú, xlá aktlakahuacá naputzá ixta̱tahuila, y xa̱cha̱tum pusca̱t tí ta̱tahuilá na̱ huá ma̱tlahuí tala̱kalhí̱n ixlacatí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Huixín na̱ catzi̱yá̱tit la̱ huan amá li̱ma̱paksí̱n ni̱ma̱ maká̱n quinca̱ma̱xqui̱ca: “Siempre cama̱kantaxti mintachihuí̱n acxni li̱ma̱lacnu̱ya ixtacuhui̱ní Mimpu̱chiná Dios.” ");
INSERT INTO topNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero aquit chí cca̱huaniyá̱n ma̱s tancs tachihuí̱n: Ni̱cxni tú cali̱ma̱lacnu mintachihuí̱n acxni ni̱ pa̱t ma̱kantaxti̱ya tú ma̱lacnu̱ya. Ni̱ cali̱kalhkamá̱nanti akapú̱n y huá cali̱ma̱lacnu mintachihuí̱n, pues akapú̱n ixpu̱latama̱n Dios; ");
INSERT INTO topNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni̱ cali̱kalhkamá̱nanti ca̱quilhtamacú y huá cali̱ma̱lacnu mintachihuí̱n, porque juú ixpu̱lacta̱y Mimpu̱chinacán Dios; ni̱ para Jerusalén cali̱kalhkamá̱nanti y huá cali̱ma̱lacnu mintachihuí̱n, porque aná jaé ca̱chiquí̱n huí ixpu̱ma̱paksí̱n Mimpu̱chinacán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ni̱ para miakxa̱ka tú cali̱ma̱lacnu mintachihuí̱n nama̱kantaxti̱ya, porque ni̱ huix ma̱paksi̱ya; ni̱ lá ma̱tzitzekeya o ma̱starankeya ca̱na kanstum minchíxit. ");
INSERT INTO topNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Huixín acxni tú li̱chihui̱naná̱tit huata cahuántit: “Je, nacma̱kantaxtí” o “Tó, ni̱ cactima̱kantáxti̱lh”; pues tí ma̱s ma̱tancsaputún ixtachihuí̱n y li̱ma̱lacnú tú li̱pa̱huán xlacata ma̱s naca̱najlanicán, namá, tlajaná ma̱xquí ixtapuhuá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Huixín catzi̱yá̱tit la̱ huan amá li̱ma̱paksí̱n ni̱ma̱ maká̱n quinca̱ma̱xqui̱ca: “Tí ma̱xtuní ixlakastapu ixta̱cristiano, na̱ capu̱spitnica tú tláhualh; y tí ma̱pa̱tasti̱ní ixtatzán ixta̱cristiano, na̱ cama̱pa̱tasti̱nica ixtatzán.” ");
INSERT INTO topNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero aquit chí cca̱huaniyá̱n ma̱s tancs tachihuí̱n: para cha̱tum minta̱cristiano tlahuaniyá̱n tú ni̱ tla̱n o la̱kalhi̱yá̱n, huix ni̱ capu̱spitni ixtaxokó̱n, ma̱s chá catamakxtakni; y tí lakakaxiyá̱n lakatu, na̱ cama̱lacnu̱ni calakakaxín xa̱lakatu milacán. ");
INSERT INTO topNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Para tí ma̱lacapu̱yá̱n caj xlacata maklhti̱putuná̱n xala ixkalhni milháka̱t, ¡cali̱mákxtakti na̱ cali̱lh xala ixtancá̱n milháka̱t! ");
INSERT INTO topNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Para huí tí xafuerza ma̱li̱ni̱yá̱n cacucani ixtacuca aktum kilómetro ixli̱lakamákat, huix ca̱li̱tlá̱n cali̱pini ixtacuca aktuy kilómetro. ");
INSERT INTO topNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chuná li̱tum ni̱ calakcatzani amá tí maksquiná̱n tú maclacasquín, cama̱xqui, y ni̱ calacatza̱la amá minta̱cristiano ni̱ma̱ maksquiná̱n, cama̱sa̱cuani tú maclacasquín, ¡cama̱xqui para kalhi̱ya! ");
INSERT INTO topNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Huixín na̱ catzi̱yá̱tit jaé li̱ma̱paksí̱n: “Calakalhámanti tí miamigo y casi̱tzi̱ni tí mienemigo.” ");
INSERT INTO topNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chí aquit cca̱huaniyá̱n tú mili̱tlahuatcán: Calakalhámanti mienemigo, cama̱tzanke̱nani, y catlahuani li̱tlá̱n amá tí ni̱ ca̱cxilhputuná̱n y ca̱si̱tzi̱niyá̱n; huixín caca̱li̱kalhtahuakátit ixlacatí̱n Dios xlacata ni̱ natapa̱xtoka tú ni̱ tla̱n. ");
INSERT INTO topNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Para chuná jaé latapa̱yá̱tit, Minti̱cucán xalac akapú̱n ama ca̱li̱maca̱ná̱n lactlá̱n ixcamán; porque xlá quilhpa̱xtum ca̱ma̱xquí ixtaxkáket chichiní tí lactlá̱n cristianos, y hasta tí lacsnú̱n talani̱t na̱ tali̱lacahua̱nán; y acxni ma̱lakachá se̱n na̱ tamaklhti̱nán tí lactlá̱n tacatzí, y hasta tí lacsnú̱n talani̱t na̱ tamaclacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aquit cca̱huaniyá̱n, para huixín huata lakalhamaná̱tit tí na̱ ca̱lakalhamaná̱n, ¿tucu ca̱li̱macuaniyá̱n? Pues hasta tí lacsnú̱n talani̱t na̱ talakalhamán tí ca̱pa̱xquí. ");
INSERT INTO topNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chuná li̱tum, para huata ca̱huaniyá̱tit kalhé̱n mili̱talakapasnicán y miamigoscán, ¿nicu naca̱li̱lakapascaná̱tit tlahuapa̱nántit tú tla̱n? Pues tí ni̱ tali̱pa̱huán Dios na̱ chuná tara̱li̱kalhí. ");
INSERT INTO topNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Huá cca̱li̱huaniyá̱n, huixín caca̱kapu̱látit ixkasatcán y cala̱pa̱xquí̱tit mili̱hua̱kcán na̱ chuná la̱ Minti̱cucán xalac akapú̱n acxtum ca̱pa̱xquí ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Ni̱cxni calacputzátit tlahuayá̱tit aktum li̱tlá̱n ana ní tzamacán caj xlacata naca̱li̱pa̱huancaná̱tit y naca̱li̱kalhi̱caná̱tit la̱ lactlá̱n cristianos, pues Dios catzí mintapuhua̱ncán y ni̱tú ama ca̱ma̱xqui̱yá̱n mintaxokó̱n nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Acxni huix natlahuaya aktum li̱tlá̱n o nama̱sta̱ya milimosna, ni̱tí cali̱ma̱kalhchihui̱ni tú tlahuani̱ta la̱ talá makapitzi tí talakatí ta̱kskahuinán. Xlacán tali̱chihui̱nán nac mimpu̱tamakstoknicán y ana ní tzamacán tú tatlahuani̱t xlacata naca̱li̱kalhi̱cán la̱ lactali̱pa̱u lacchixcuhuí̱n, ¡pero ta̱ktzanka̱ni̱t! Porque Dios yaj tú ama ca̱ma̱xquí ixtaxoko̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aquit cama ca̱huaniyá̱n la̱ mili̱tlahuatcán aktum li̱tlá̱n: acxni huix makta̱yaya minta̱cristianos, tze̱k catlahua, ni̱ para ma̱s xatali̱pa̱u miamigo cali̱ma̱kalhchihui̱ni tí makta̱yani̱ta. ");
INSERT INTO topNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pero Minti̱cú xalac akapú̱n acxilhmá̱n y catzí tú tlahuápa̱t, xlá sí ama ma̱xqui̱yá̱n lanca mintaxokó̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Acxni huixín kalhtahuakaniyá̱tit Dios ni̱ caca̱makslihuekétit namá tí talakatí ta̱kskahuinán. Xlacán takalhtahuaká nac ca̱lactijyí̱n, nac mimpu̱tamakstoknicán, ana ní tzamacán xlacata na̱cxilhcán y napuhuancán xli̱ca̱na lactlá̱n cristianos; pero ixacstucán talaktzanka̱ni̱t, pues Dios catzí ixtapuhua̱ncán y ni̱ ama ca̱ma̱xquí tú tamaksquín. ");
INSERT INTO topNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Huix acxni kalhtahuakaya, catanu mi̱cstu nac mínchic, cama̱lacchahua pu̱hui̱lhta y cakalhtahuakani Mimpu̱chiná Dios; xlá na̱cxilá̱n y como catzí tú maclacasquina nama̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Huix ni̱ caca̱makslihueke namá cristianos tí ni̱ talakapasa ixtalacapa̱stacni Dios; xlacán acxni takalhtahuakaní Dios tahuán pi̱hua pi̱huá akstum tachihuí̱n porque tapuhuán para lhu̱hua tachihuí̱n tali̱kalhtahuaká, sok ama ca̱ma̱xqui̱cán tú taxcalama̱na. ");
INSERT INTO topNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Huix cahuani Dios tú taxtú nac minacú porque xlá catzi̱yá tú maclacasquinátit la̱ta ya̱ para huaniyá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Aquit cama ca̱ma̱si̱niyá̱n la̱ nahuaniyá̱tit Dios acxni nakalhtahuakaniyá̱tit, y cakaxpáttit: Dios Quinti̱cucán huix lápa̱t nac akapú̱n, y huata huix mini̱ní nacca̱lakachixcuhui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cama̱lacatzuqui mintapáksi̱t nac quinacujcán, cama̱kantaxti tú laclhca̱ni̱ta nac ca̱quilhtamacú na̱ chuná la̱ kantaxtú nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Quila̱ma̱xquí̱u quintahuajcán tú nacli̱latama̱yá̱u cha̱li cha̱lí. ");
INSERT INTO topNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Quila̱ma̱tzanke̱naníu tú cli̱makatzanka̱yá̱u na̱ chuná la̱ aquín cca̱ma̱tzanke̱naniyá̱u xa̱makapitzi tú quinca̱li̱makatzanka̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ni̱cxni quila̱kxtakmakáu xlacata ni̱ naquinca̱ma̱tlahui̱yá̱n tala̱kalhí̱n. Porque huata huix mini̱ní naquila̱cpuxcuná̱u nac quilatama̱tcán y ni̱tí ma̱ta̱xtuca mili̱tlihueke, y huata huix mini̱ní nacca̱lakachixcuhui̱yá̱n cani̱cxnihuá quilhtamacú. Chú calalh, amén. ");
INSERT INTO topNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Mimpu̱chinacán xalac akapú̱n ―ca̱huanipá Jesús― naca̱ma̱tzanke̱naniyá̱n mintala̱kalhi̱ncán para huixín na̱ ca̱ma̱tzanke̱naniyá̱tit minta̱cristianos tú ni̱ tla̱n ca̱tlahuaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero xlá ni̱ catica̱ma̱tzanke̱nanín mintala̱kalhi̱ncán para huixín na̱ ni̱ ca̱ma̱tzanke̱naniyá̱tit xa̱makapitzi tú ni̱ tla̱n ca̱tlahuaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Tí katxtaknán xlacata nalakachixcuhuí Dios, ni̱ camá̱si̱lh nac ixlacán lakaputzama la̱ talá namá tí talakatí ta̱kskahuinán; xlacán con takatxtaknán taán ní tzamacán xlacata naca̱cxilhcán talakaputzama̱na porque takatxtaknama̱na, pero Dios ni̱tú ama ca̱li̱ma̱nuní ixtakatxtaknicán. ");
INSERT INTO topNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cama ca̱huaniyá̱n tú mili̱tlahuatcán: Tí katxtaknán tla̱n calakachákalh y tla̱n cataca̱xtá̱yalh ");
INSERT INTO topNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","xlacata ni̱tí nacatzí para katxtaknama. Pero Minti̱cú xalac akapú̱n tí tze̱k acxilhmá̱n nali̱pa̱xahuayá̱n, y xlá nama̱xqui̱yá̱n mintaxokó̱n ni̱ma̱ mini̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Ni̱ pucuta calacputzátit ma̱kstoká̱tit lhu̱hua tumi̱n, lactlá̱n li̱taca̱xta̱y, y tú li̱latama̱cán ca̱quilhtamacú porque juú talaktzanká, ca̱lacuacán, y kalha̱naní̱n skálalh tahuila̱na tú tla̱n natakalhán. ");
INSERT INTO topNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Huixín calacputzátit ma̱kstoká̱tit laclanca talacapa̱stacni, tla̱n pa̱t li̱piná̱tit pues huá sí ama ca̱macuaniyá̱n li̱pa̱xáu nali̱latapa̱yá̱tit nac akapú̱n. Aná ni̱tú laktzanká, ni̱ para kalha̱naní̱n tla̱n tamaklhti̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Y ana ní nama̱kstoká̱tit la̱ta tú nali̱scujá̱tit ca̱quilhtamacú, aná ama tamakxtaka minacujcán y mili̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ca̱huanipá Jesús: ―Aquit cca̱ta̱ma̱lacastucniyá̱n milakastapucán la̱ aktuy lámpara tú li̱lacahua̱nán mintalacapa̱stacnicán. Para tla̱n talakskoy huix kalhi̱ya staranca taxkáket y tancs latapu̱li̱ya. ");
INSERT INTO topNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero para milakastapu ni̱ takalhí staranca taxkáket, ¡laktzanka̱nita! Pues nac milatáma̱t ni̱ tancs latapa̱ya y la̱ ca̱paklhtu̱tá latapu̱li̱ya, y tí ca̱paklhtu̱taj tla̱huán, ¡tuhua ama huani̱ní nalakchá̱n Dios, pues ni̱ kalhí tú li̱lacahua̱nán ixmacni! ");
INSERT INTO topNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Tí li̱pa̱huán Dios y tí li̱pa̱huán huata ixtumi̱n, cama ca̱ta̱ma̱lacastucniyá̱n cha̱tum tasa̱cua. Xlá ni̱ lá ca̱ta̱scuja cha̱tuy patrón pi̱huá quilhtamacú, porque nata̱ra̱lí̱n y nakaxmatní cha̱tum, y nasi̱tzi̱ní y nata̱ra̱tlahuá xa̱cha̱tum; y na̱ chuná tí kalhí tumi̱n para ma̱laktzanke̱ní ixtalacapa̱stacni aktzonksuá Dios. ");
INSERT INTO topNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ca̱huanipá Jesús: ―Ni̱ pucuta cali̱puhuántit tú nali̱taxtuniyá̱tit cha̱li cha̱lí, y tú nali̱lhaka̱naná̱tit. Quila̱huaníu, ¿a poco ni̱ ma̱s macuán mili̱stacnicán que mintahuajcán? ¿Ni̱ li̱pa̱xahuayá̱tit la̱ katzí mimacnicán ma̱squi ni̱ kalhi̱yá̱tit milhaka̱tcán? ");
INSERT INTO topNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Huata caca̱li̱lacahua̱nántit la̱ talama̱na lactzú spitu. Xlacán ni̱ tacha̱lhca̱tnán, ni̱ para tatama̱huá, ni̱ para tama̱quí ixtahuajcán; y Mimpu̱chinacán Dios ni̱cxni ca̱kxtakmakán cha̱li cha̱lí ca̱ma̱xquí ixtahuajcán tú natali̱latamá. Para xlá ni̱ ca̱ktzonksuá lactzú spitu, ¿nicu li̱puhuana naca̱ktzonksuayá̱n huixín ixcamán? ");
INSERT INTO topNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Quila̱huaníu, ¿nicu yá cristiano ma̱squi pucuta li̱puhuán tla̱n li̱ma̱huacá a̱laktzú ixlatáma̱t? ");
INSERT INTO topNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Hua̱nchi pucuta li̱puhuaná̱tit milhaka̱tcán tú nahuili̱yá̱tit? Cali̱lacahua̱nántit lactzú xánat ni̱ma̱ tastaca ca̱quihuí̱n. Xlacán ni̱ talakaxtokó, ni̱ para tatama̱huá ixlhaka̱tcán; ");
INSERT INTO topNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","y ma̱squi rey Salomón cahuíli̱lh lhu̱hua lactlá̱n ixlháka̱t, ni̱cxni ma̱cchá̱ni̱lh la̱ talhaka̱nán lactzú xánat xala ca̱quihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mimpu̱chinacán Dios ca̱ma̱lhaké hua̱k li̱cúxtut y lactzú xánat ma̱squi catzí xlacata ni̱ ixli̱maka̱s ca̱tanca̱cán, tasca̱ca y ca̱lhcuyucán. Y para huixín ixma̱xquí̱tit mili̱stacnicán ixli̱hua̱k minacujcán, ¡tucu ni̱ ixtláhualh milacatacán laktakalhí̱n lacchixcuhuí̱n! ");
INSERT INTO topNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","32","Huixín ni̱ caca̱makslihuekétit ixkasatcán namá tí ni̱ tali̱pa̱huán Dios. Xlacán cha̱li cha̱lí talacputzama̱na la̱ natalaktaxtutamá; pero huixín yaj cali̱puhuántit mintahuajcán y milhaka̱tcán y tú nali̱latapa̱yá̱tit pues Mimpu̱chinacán Dios ni̱ma̱ kalhi̱yá̱tit catzí la̱ta tú maclacasquiná̱tit y xlá naca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pero pu̱la cama̱kantaxti̱nítit Dios tú lacasquín milacatacán, y hua̱k la̱ta tú namaclacasquiná̱tit nac milatama̱tcán ixacstu naca̱macama̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aquit cca̱huaniyá̱n, yaj cali̱puhuántit la̱ pa̱t lakaxkakayá̱tit ixli̱cha̱lí, huata Dios catzí tú mili̱tláhuat nahuán pues katunu chichiní Dios li̱lhca̱ni̱t tú lacasquín naqui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Huix ni̱ scarancua caputzani la̱ nataka̱sniya ixtala̱kalhí̱n minta̱cristiano, xlacata a̱stá̱n na̱ ni̱ quilhpa̱xtum nama̱xoko̱ni̱cana mintala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pues Dios ama lhcuyuya̱huayá̱n na̱ chuná la̱ ca̱lhcuyuya̱huaya minta̱cristiano, y ama ma̱xqui̱yá̱n mintaxokó̱n na̱ chuná la̱ ma̱xqui̱ya ixtaxokó̱n minta̱cristiano. ");
INSERT INTO topNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aquit cca̱kalasquiniyá̱n, ¿nicu li̱cxila actzú palhma ni̱ma̱ lacatanu̱ma minta̱cristiano nac ixlakastapu pero ni̱ maklhcatzi̱ya xlacata nac milakastapu lacatanu̱má̱n ma̱s lanca actzú quihui? ");
INSERT INTO topNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chí na̱ cca̱huaniyá̱n, ¿nicu tiyaya li̱camama huaniya minta̱cristiano: “Cama lacama̱xtuyá̱n namá palhma ni̱ma̱ lacatanu̱má̱n nac milakastapu”, y huix ni̱ maklhcatzi̱ya xlacata lacatanu̱má̱n ma̱s lanca actzú quihui nac milakastapu? ");
INSERT INTO topNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Akskahuiná chixcú! Pu̱la cama̱xtu namá quihui ni̱ma̱ lacatanu̱má̱n y ni̱ ma̱lacahua̱ni̱yá̱n, y a̱stá̱n tla̱n nalacama̱xtuya palhma nac ixlakastapu minta̱cristiano. ");
INSERT INTO topNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tla̱n cali̱lacpúhuanti acxni ca̱ma̱xqui̱putuna chichí lactasicuna̱tláu tahuá; na̱ chuná ni̱ para caca̱lakmacapi paxni mintapixnu xla oro pues ni̱ talakapasa, tla̱n huata natama̱lakxpalaké y hasta tla̱n li̱takalhpu̱spitá̱n xlacata naxcayá̱n. Jaé qui̱taxtú laclanca ixtalacapa̱stacni Dios ni̱ ca̱mini̱ní ca̱ma̱xqui̱cán amá cristianos tí ni̱ tama̱ccha̱ní ixtalacpuhua̱ncán y caj natali̱kalhkama̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ca̱huanipá Jesús: ―Acxni tú maclacasquina, camáksquinti Mimpu̱chiná Dios, y xlá nama̱xqui̱yá̱n. Calacaputza tú makatzanka̱ya y nataka̱sa; calakátlakti puhui̱lhta y nama̱lacqui̱nicana para ni̱ tatlaji̱ya. ");
INSERT INTO topNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porque amá tí squin tú maclacasquín ma̱xqui̱cán, y tí putzá tú makatzanká taka̱sa, y tí lakatlaka puhui̱lhta ma̱lacqui̱nicán. ");
INSERT INTO topNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Huixín ca̱lakapasá̱tit cristianos, quila̱huaníu, ¿ticu yá xati̱cú ma̱xquí ixkahuasa actzú chíhuix acxni maksquín actzú simi̱ta? ");
INSERT INTO topNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ¿ticu ma̱xquí ixkahuasa tantum lu̱hua para maksquín actzú xali̱hua tamakní? ");
INSERT INTO topNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Huixín catzi̱yá̱tit ma̱squi cha̱tum chixcú snu̱n lani̱t, ma̱xquí ixkahuasa tú maclacasquín. Entonces ¿nicu li̱puhuaná̱tit xlacata Mimpu̱chinacán Dios ni̱ catica̱ma̱xquí̱n tú huixín maclacasquiná̱tit para maksquiná̱tit? ");
INSERT INTO topNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chí tancs cama ca̱lacspi̱tniyá̱n tú huamputún ixtapáksi̱t Moisés y la̱ta tú tamá̱si̱lh profetas: catlahua ixlacatacán cristianos na̱ chuná la̱ta tú huix ixlacásquinti catatláhualh milacata xa̱makapitzi. ");
INSERT INTO topNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Tí talakcha̱mputún Dios catapútzalh talactanú namá ti̱tzú puhui̱lhta. Porque huí xaktum ti̱lanca puhui̱lhta y tijia ni̱ma̱ li̱cha̱ncán nac puakxtakajni; jaé snu̱n ti̱lanca y tla̱n tlahuacán la̱ta lacasquincán y lhu̱hua talactla̱huán ma̱squi ma̱laktzanke̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero huixín ni̱ caca̱takokétit, ¡catatlihuéklhtit calactanú̱tit ti̱tzú puhui̱lhta y calactla̱huántit jaé ti̱tzú tijia ni̱ma̱ li̱lakcha̱ncán Dios pues lhuhua cristianos ni̱cxni talakataka̱sa! ");
INSERT INTO topNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Nac milatama̱tcán skálalh catla̱huántit xlacata ni̱ aktziyaj natachipayá̱n namá tí talakatí ta̱kskahuinán. Xlacán tama̱kalhchihui̱ni̱nán la̱ lacmanso borregos, pero ixnacujcán la̱ xla la̱páni̱t; y para li̱tamakxtaká̱tit tali̱ná̱n nac lacli̱xcájnit tijia xlacata nama̱laktzanke̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Huixín catzi̱yá̱tit xlacata akatum lhtucú̱n ni̱ ma̱stá ixtahuácat uvas, y akatum kajni ni̱ ma̱stá ixtahuácat skatan; pues na̱ chuná jaé akskahuinaní̱n lacchixcuhuí̱n tla̱n ca̱li̱lakapascán ixkasatcán ixtascujutcán ni̱ma̱ tatlahuá. ");
INSERT INTO topNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Akatum quihui tla̱n li̱lakapascán ixtahuácat ni̱ma̱ ma̱stá; ni̱ma̱ tla̱n quihui ma̱stá tla̱n ixtahuácat y ni̱ma̱ ni̱ tla̱n quihui ma̱stá ni̱ tla̱n ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Amá quihui ni̱ma̱ ma̱stá laksaksi y lakkama ixtahuácat ni̱cxni talakxta̱palí y ni̱ma̱ ma̱stá lacxcuta y lacli̱xcájnit ixtahuácat na̱ chuná ni̱cxni talakxta̱palí. ");
INSERT INTO topNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Hua̱k jaé quihui ni̱ma̱ tama̱stá lacli̱xcájnit ixtahuacatcán ca̱tanca̱cán y ca̱ma̱pu̱cán nac lhcúya̱t, y jaé akskahuinaní̱n lacchixcuhuí̱n na̱ chuná nata̱kspulá. ");
INSERT INTO topNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aquit hua̱k cca̱lacspi̱tnini̱tán la̱ naca̱li̱lakapasá̱tit ixkasatcán jaé cristianos acxni naca̱kskahuiputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ni̱ hua̱k cristianos tí tali̱tanú quintali̱pa̱huán natachá̱n nac ixpa̱xtún Dios ma̱squi quintali̱macá̱n aquit Ixpu̱chinacán. Aquit cca̱huaniyá̱n huata ta̱má̱n tachá̱n nac akapu̱n amá tí xli̱ca̱na tama̱kantaxtí nac ixlatama̱tcán tú li̱ma̱paksi̱nán Quinti̱cú Dios. ");
INSERT INTO topNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ixcamán, lhu̱hua ta̱má̱n quintahuaní: “Huix Quimpu̱chinacán, aquín cca̱li̱chihui̱nán ixlacati̱ncán cristianos y mili̱tlihueke cca̱li̱macma̱xtúu tí ixca̱makatlajani̱t tlajaná y lhu̱hua laclanca tascújut cca̱li̱tlahuáu mintacuhui̱ní.” ");
INSERT INTO topNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Y como aquit cca̱lakapasa ixnacujcán cama ca̱kalhtí: “Catake̱nú̱tit ní cyá porque aquit ni̱cxni cca̱li̱macá̱n la̱ xli̱ca̱na quila̱li̱pa̱huaná̱u, huixín ixliakskahuinaná̱tit quintacuhui̱ní ixli̱tlahuayá̱tit tú ni̱ tla̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Tí kaxmata tú cca̱li̱ma̱paksi̱ni̱tán y ma̱kantaxtí nac ixlatámat, cama li̱macá̱n la̱ cha̱tum skalala chixcú tí tláhualh ixchic y ma̱tí̱ju̱lh xacha̱ya nac ca̱chihuixni. ");
INSERT INTO topNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Acxni tzúculh se̱nán, tatlancánalh y milh akxtulú̱n, ixchic amá chixcú ni̱ táma̱lh, ni̱ para tú lánilh porque xacha̱ya tla̱n ixti̱jú nac ca̱chihuixni. ");
INSERT INTO topNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero tí kaxmata tú cca̱li̱ma̱paksi̱ni̱tán y ni̱ ma̱kantaxtí nac ixlatáma̱t cama li̱macá̱n la̱ cha̱tum takalhí̱n chixcú tí tláhualh ixchic y ma̱tí̱ju̱lh xacha̱ya nac stilhua tíyat. ");
INSERT INTO topNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Y acxni tatlancánalh y milh akxtulú̱n, ixchic amá chixcú tuncán táma̱lh porque xacha̱ya ni̱ tla̱n ixma̱ti̱ju̱ni̱t, ¡ixacstu laktzánka̱lh! ");
INSERT INTO topNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús ca̱li̱chihuí̱nalh jaé talacapa̱stacni la̱ ixli̱latama̱tcán cristianos, y la̱ takaxmatko̱lh ixtachihuí̱n ni̱ ixtacatzí tú natahuán ");
INSERT INTO topNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pues la̱ta tú ixca̱li̱ma̱paksi̱ni̱t ixca̱huanini̱t la̱ cha̱tum chixcú tí xli̱ca̱na ma̱ccha̱ní talacapa̱stacni, y ni̱ la̱ xa̱makapitzi tí na̱ ixtama̱sí ixtachihuí̱n Dios nac ixpu̱tamakstoknicán judíos. ");
INSERT INTO topNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús tzúculh talaca̱ctá amá sipi ní ixca̱ma̱kalhchihui̱ni̱ni̱t cristianos y hua̱k tatakókelh. ");
INSERT INTO topNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y ya̱ para ixchá̱n ní ixama acxni cha̱tum chixcú tí ixkalhí lepra tá̱tat tatzokóstalh ní ixtla̱huama y huánilh: ―Quimpu̱chiná, ccatzí tla̱n quincuchi̱ya, para lacasquina caquima̱ksa̱ni. ");
INSERT INTO topNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Xlá lakasu̱t macxámalh amá chixcú y kálhti̱lh: ―Clacasquín, y ca̱ksá̱nanti tuncán. Huata chihuí̱nalh Jesús, amá chixcú tuncán take̱nú̱nilh ixtá̱tat. ");
INSERT INTO topNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pero antes na̱kxtakya̱huá li̱ma̱páksi̱lh: ―Ni̱tí cali̱ma̱kalhchihui̱ni la̱ aksa̱nani̱ta; pu̱la capit putzaya cha̱tum cura xlacata na̱cxilá̱n y na̱ cama̱sta mili̱lakachixcuhui̱n la̱ huani̱t Moisés ixli̱ma̱sta̱tcán acxni ta̱ksa̱nán tí takalhí namá tá̱tat, y xa̱huá chuná cati̱huá yaj najicuaniyá̱n nama̱lacatzuhui̱yá̱n porque yaj kalhi̱yá̱n tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús ti̱tum ta̱yapá nachá̱n nac Capernaum y lihua ixcha̱majá nac ca̱chiquí̱n acxni ma̱lacatzúhui̱lh cha̱tum capitán romano, ");
INSERT INTO topNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","y máksquilh aktum li̱tlá̱n huánilh: ―Señor, clacasquín nama̱ksa̱ni̱ya quintasa̱cua. Xlá ke̱tá nac tama porque ni̱ lá tla̱huán laclu̱nchu̱ni̱t y snu̱n akxtakajnama. ");
INSERT INTO topNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","―Ni̱tú cali̱púhuanti, aquit nacán ma̱ksa̱ní mintasa̱cua ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero xlá huanipá: ―Señor, aquit ni̱ cma̱ta̱xtuca natanú nac quínchic cha̱tum tali̱pa̱u tla̱n chixcú la̱ huix; para ma̱ksa̱ni̱putuna quintasa̱cua huata cali̱ma̱paksí̱nanti mintachihuí̱n xlacata na̱ksa̱nán y ccatzí quintasa̱cua na̱ksa̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pues huix catzi̱ya xlacata aquit soldado y na̱ quintama̱paksí tunuj ma̱s xalactali̱pa̱u lacchixcuhuí̱n, pero na̱ tahuila̱na soldados tí tla̱n cca̱ma̱paksí y xlacán quintakaxmatní. Acxní cuaní cha̱tum: “Capit ní cama ma̱lakacha̱yá̱n”, xlá tuncán an; y para cuaní cha̱tum: “Catat juú”, xlá tuncán min; y xani̱ma̱tá quintasa̱cua tú cli̱ma̱paksí catláhualh, xlá tuncán tlahuá. Huá cli̱huaniyá̱n aquit cli̱pa̱huán mintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","La̱ kaxmatko̱lh amá tachihuí̱n Jesús cá̱cni̱lh amá capitán romano y ca̱huánilh amá tí ixtatakokeni̱t: ―La̱ta clatapu̱li̱ni̱t nac Israel ni̱ xactaka̱sni̱t ni̱ para xackaxmatni̱t cha̱tum chixcú tí li̱pahuani̱t quintachihuí̱n ixli̱hua̱k ixnacú la̱ jaé capitán. ");
INSERT INTO topNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chí tancs cama ca̱huaniyá̱n tú ama qui̱taxtú: la̱ta ixli̱ti̱lanca ca̱quilhtamacú lhu̱hua cristianos tí ca̱lakmakancán porque ni̱ judíos tla̱n ama tachá̱n ana ní huí Dios nac akapú̱n y ama tata̱pa̱xahuá nac ixpu̱latama̱ncán ni̱ma̱ ca̱ma̱xqui̱ni̱t Dios xalakmaká̱n quili̱talakapasnicán Abraham, Isaac y Jacob. ");
INSERT INTO topNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Hua̱k israelitas tí ixca̱ma̱lacnu̱ni̱t Dios ama ca̱ma̱xquí ixpu̱tahui̱lhcán nac ixtapáksi̱t ama̱ca ca̱maca̱ncán a̱lacatunu ní ca̱paklhtu̱tá nac puakxtakajni ana ní nataxoko̱nán. ¡Koxitaní̱n, aná ama tatasá y tatatlanca̱ní la̱ta tali̱puhuán ixta̱kxtakajnicán! ");
INSERT INTO topNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesús ca̱li̱tlá̱n huánilh amá capitán: ―Capit nac mínchic y yaj ca̱katúyunti; huix li̱pá̱huanti quintachihuí̱n y mintasa̱cua aksa̱nani̱ttá. ¡Xli̱ca̱na pi̱huá amá quilhtamacú ixtasa̱cua amá capitán tuncán aksá̱nalh! ");
INSERT INTO topNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Astá̱n Jesús alh nac ixchic Simón Pedro, y ácxilhli ixpuhuiticha̱t Pedro ixke̱tá nac ixpu̱tama ixkalhí palha lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xlá lakasu̱t li̱macxámalh ixmacán amá cha̱t y tuncán take̱nú̱nilh amá palha lhcúya̱t ni̱ma̱ ixpu̱ti̱ma. Astá̱n uyu tá̱qui̱lh y tzúculh tlahuá tahuá tú naca̱li̱ta̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ixli̱puntzú acxni tzuculhá tapaklhtu̱tá, ca̱li̱minca ana ní ixuí Jesús lhu̱hua ta̱tatlaní̱n tí ixca̱mactanu̱ma ixespiritucán tlajananí̱n y tí ixtakalhí ti̱pa̱katzi tá̱tat. Xlá huata ixli̱ma̱paksi̱nán ixtachihuí̱n y hua̱k tlajananí̱n ixtataxtú y tá̱tat ixtatake̱nú ixmacnicán cristianos, y ni̱ cha̱tum ta̱tatlá tamákxtakli. ");
INSERT INTO topNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Huá jaé ixtascújut Jesús li̱ma̱kantáxti̱lh tú ixtzokni̱t ixlacata profeta Isaías: “Huá macpa̱ti̱ko̱lh y ca̱ma̱laktzánke̱lh quintasipa̱ni̱tcán y quinta̱tatcán ni̱ma̱ ixquinca̱pu̱ti̱má̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Como ma̱s lhu̱hua cristianos ixtachima̱na ní ixuí Jesús, xlá ca̱huánilh ixdiscípulos catatáca̱xli porque ixama taán ixa̱quilhtu̱tu chúchut Galilea. ");
INSERT INTO topNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pero cha̱tum skalala ixma̱kalhtahuake̱nacán judíos ma̱lacatzúhui̱lh y huánilh: ―Maestro Jesús, aquit ctakokeputuná̱n la̱ta ní huix napina latapu̱li̱ya. ");
INSERT INTO topNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xlá kálhti̱lh: ―Aquit ni̱tú ckalhí, lactzú zorras takalhí ixpu̱lhtatacán nac lhucu, y lactzú spitu ixma̱sekecán, pero aquit Xatalacsacni Chixcú ni̱ para ckalhí tú cliacxtica̱tnán acxni clhtatá. ");
INSERT INTO topNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cha̱tum tí na̱ ixtakokeputún na̱ huánilh: ―Quimpu̱chinacán Jesús, aquit nactakokeyá̱n pero quili̱kalhi hasta xní naní quinti̱cú y tla̱n nacmujú. ");
INSERT INTO topNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","―Tó ―kálhti̱lh Jesús―. Para quintakokeputuna, chí tuncán caquintakoke y caca̱li̱mákxtakti tí la̱ xaní̱n talama̱na pi̱huá tí catamúju̱lh ixni̱ncán; pero huix ma̱s macuaniyá̱n caquintakoke. ");
INSERT INTO topNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","La̱ ca̱ta̱chihui̱nanko̱lh jaé lacchixcuhuí̱n, Jesús ca̱ta̱táju̱lh ixdiscípulos nac aktum barco xlacata natachá̱n ixa̱quilhtu̱tu amá chúchut. ");
INSERT INTO topNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ni̱ mákat ixtatla̱huani̱t acxni také̱talh akxtulú̱n nac chúchut y tzúculh li̱tatzamá chúchut ixbarcojcán. Pero Jesús ni̱ ixcatzí porque itlhtatani̱t ixtanké̱n barco. ");
INSERT INTO topNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ixdiscípulos lacapala tama̱stácni̱lh y tahuánilh: ―Quimpu̱chinacán Jesús, quila̱lakma̱xtúu. ¡Ama ta̱ktzí jaé barco y ama̱naj mu̱xtuyá̱u! ");
INSERT INTO topNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús ca̱kálhti̱lh: ―¿Nicu alh mili̱camamacán la̱ huaná̱tit quila̱li̱pa̱huaná̱u? Jesús tá̱yalh y ca̱li̱ma̱páksi̱lh ixtachihuí̱n cataké̱nu̱lh amá akxtulú̱n, y tuncán acs tatu̱tako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Xlacán huata tzúculh tara̱laca̱cxila, y ixtara̱huaní: ―¿Chá ticu yá chixcú jaé? ¡Hasta na̱ tla̱n takaxmatní u̱n y pupunú acxni ca̱ta̱chihui̱nán! ");
INSERT INTO topNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tácha̱lh ixa̱quilhtu̱tu chúchut lacatum pu̱latama̱n huanicán Gadara, y acxni tá̱ctalh tali̱pa̱táxtulh cha̱tuy lacchixcuhuí̱n tí ixca̱mactanu̱ni̱t pu̱tum ixespiritucán tlajananí̱n. Xlacán ixtalama̱na nac lhucu ni̱ma̱ ixlacahuaxcani̱t nac talhpá̱n ní ixca̱pu̱muju̱cán ni̱n; snu̱n lacli̱cuánit ixtahuani̱t y huá xlacata ni̱tí ixlactla̱huán ní ixtalatapu̱lí. ");
INSERT INTO topNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tatalacatzúhui̱lh, y acxni tá̱cxilhli Jesús tzúculh tama̱ktasí: ―Huix Ixkahuasa Dios, ¿hua̱na tani̱ta quila̱paktanu̱yá̱u? ¡Ni̱ caquila̱ma̱kxtakajní̱u pues ya̱ acchá̱n quilhtamacú nacxoko̱naná̱u! ");
INSERT INTO topNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Como ixtahua̱yampu̱lá pu̱tum lhu̱hua paxni aná lacatzú, ");
INSERT INTO topNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","amá ixespiritucán tlajananí̱n ca̱li̱tlá̱n tahuánilh Jesús: ―Para quila̱tamacxtuyá̱u ixmacnicán jaé lacchixcuhuí̱n quila̱ma̱xquí̱u li̱tlá̱n nacca̱mactanu̱yá̱u ixmacnicán namá paxni. ");
INSERT INTO topNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Xlá ca̱huánilh: ―Pues capítit. Amá tlajananí̱n tamactáxtulh amá lacchixcuhuí̱n y tamactánu̱lh amá paxni; pero huata tatánu̱lh hua̱k tzúculh talactza̱lanán la̱ catachíyalh, y lacatum ní ca̱kalhpulujua tapa̱tástako̱lh y aná tamu̱xtuko̱lh amá paxni nac chúchut. ");
INSERT INTO topNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tí ixtamaktakalhma̱na amá paxni caj la̱ ni̱tú tácha̱lh nac ca̱chiquí̱n y tali̱chihuí̱nalh tú ixta̱kspulani̱t ixpaxnicán y amá lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lhu̱hua cristianos táalh ta̱cxila tú ixqui̱taxtuni̱t y a̱stá̱n tahuánilh Jesús ni̱ catamákxtakli ixpu̱latama̱ncán y caalh a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús ca̱ta̱taju̱pá ixdiscípulos nac barco y tacha̱mpá ixa̱quilhtu̱tu chúchut y táalh amá ca̱chiquí̱n ana ní ixani̱t latamá. ");
INSERT INTO topNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aná ixlama acxni li̱chinca cha̱tum chixcú tí ixlaclu̱nchu̱ni̱t; ixpu̱li̱mincán camilla porque ni̱ lá ixtla̱huán. Jesús acxcátzi̱lh tuncán xlacata amá lacchixcuhuí̱n ixtali̱pa̱huán huá tla̱n nama̱ksa̱ní ixta̱tatlacán, y huá li̱huánilh amá ta̱tatlá: ―Ti̱cú, yaj tú cali̱púhuanti, hua̱k mintala̱kalhí̱n aquit cma̱tzanke̱naniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Makapitzi lakskalala ixma̱kalhtahuake̱nacán judíos como na̱ aná ixtahuila̱na takáxmatli ixtachihuí̱n y tzúculh talacpuhuán: “Jaé chixcú li̱kalhkama̱nama ta̱ra̱lacata̱qui̱ma Dios.” ");
INSERT INTO topNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesús acxcátzi̱lh tú tze̱k ixtalacpuhuama̱na y chuné ca̱ta̱chihuí̱nalh: ―¿Hua̱nchi siempre kalhi̱yá̱tit ni̱ lactlá̱n mintalacapa̱stacnicán? ");
INSERT INTO topNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Quila̱huaníu, ¿tucu ma̱s tuhua ma̱kantaxti̱cán, huanicán cha̱tum chixcú: “Hua̱k mintala̱kalhí̱n cma̱tzanke̱naniyá̱n”, o huanicán: “Cata̱qui, casacti mincamilla y catlá̱huanti”? ");
INSERT INTO topNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aquit Xatalacsacni Chixcú cama ca̱li̱ma̱lacahua̱ni̱yá̱n ixli̱tlihueke quintachihuí̱n; para cma̱ksa̱ní jaé chixcú ni̱ lá huaná̱tit ni̱ ckalhí li̱tlihueke nacma̱tzanke̱nán tala̱kalhí̱n ca̱quilhtamacú. Jesús huánilh amá ta̱tatlá: ―Aquit cli̱ma̱paksi̱yá̱n, cata̱qui, casacti mincamilla y capít nac mínchic. ");
INSERT INTO topNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Amá chixcú tí ni̱ lá ixtla̱huán tuncán tá̱qui̱lh, tzúculh tla̱huán y ixacstu alh nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hua̱k cristianos tí ixtá̱cxilhli tú tláhualh Jesús tapa̱xcatcatzí̱nilh Dios la̱ ixma̱xqui̱ni̱t ixli̱tlihueke amá chixcú xlacata naca̱li̱ma̱lacahua̱ní ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús alh a̱lacatunu y ti̱táxtulh ana ní ixca̱ma̱taji̱cán cristianos tú ixli̱lakaxokotcán. Aná ixuí cha̱tum chixcú huanicán Mateo ixma̱taji̱nama. Jesús huánilh: ―Huix na̱ caquintakoke ana ní cama an. Xlá akxtakuíli̱lh la̱ta tú ixtlahuama y tuncán takókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maktum Jesús alh hua̱yán nac ixchic Mateo, xlá ca̱tá̱alh ixdiscípulos, y ana ní ca̱ma̱hui̱ca na̱ támilh tahua̱yán lhu̱hua tí ni̱ ixca̱cxilhputuncán ixma̱lakaxoke̱naní̱n tumi̱n, na̱ chuná lhu̱hua tí ixtalaktzanka̱ni̱t y ni̱tú ixca̱li̱cxilhcán. ");
INSERT INTO topNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Makapitzi fariseos tí scarancua ixtama̱kantaxtí ixley Moisés tá̱cxilhli tí ixca̱ta̱hua̱yama Jesús; ni̱ tama̱tlá̱ni̱lh y huá tali̱huánilh ixdiscípulos: ―¿Hua̱na mima̱kalhtahuake̱nacán ca̱ta̱talakxtumí namá ixma̱lakaxoke̱nacán tumi̱n y tí talaktzanka̱ni̱t? ");
INSERT INTO topNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús ca̱káxmatli tú ixtaquilhuama̱na y ca̱kálhti̱lh: ―Aquit cca̱ta̱talakxtumí porque huata tamaclacasquín doctor tí takalhí tá̱tat, y tí ni̱ lá tacatzán y tapuhuán tla̱n talama̱na ni̱ tamaclacasquín cuchi̱ná. ");
INSERT INTO topNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Tla̱n cama̱kachakxí̱tit jaé ixtapási̱t Dios ni̱ma̱ ma̱tzokónalh nac Escrituras: “Ni̱ clacasquín quintali̱lakachixcúhui̱lh quincamán ixquitzistancaní̱n, ma̱s cma̱tla̱ní quilhpa̱xtum catara̱lakalhámalh.” Huá cca̱li̱huaniyá̱n, aquit ni̱ cca̱lakmini̱t tí tapuhuán tla̱n talama̱na, aquit cca̱lakmini̱t tí tacatzí talaktzanka̱ni̱t xlacata natalakxta̱palí ni̱ tla̱n ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Maktum li̱tum makapitzi tí ixtatakoké Juan Bautista tama̱lacatzúhui̱lh Jesús y takalasquínilh: ―Aquín y namá fariseos tza̱pu cli̱lakachixcuhui̱yá̱u Dios quintakatxtaknicán, pero huix tí takaxmatá̱n, ¿hua̱nchi ni̱ takatxtaknán? ");
INSERT INTO topNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús ca̱li̱ta̱chihuí̱nalh la̱ ixqui̱taxtú tí ixtatakoké: ―Para cha̱tum kahuasa tamakaxtoka y ca̱huanini̱t ixamigos natata̱pa̱xahuá nac fiesta, ni̱ ma̱tla̱ní tí nakatxtaknán y ni̱ nahua̱yán; pero acxni nachá̱n quilhtamacú naán amá xalí̱i̱t kahuasa, na̱ chuná la̱ aquit cama an a̱lacatunu, entonces quidiscípulos na̱ ama takatxtaknán. ");
INSERT INTO topNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’La̱ta tú cca̱ma̱si̱nimá̱n hua̱k sa̱sti takalhchihuí̱n, huá cca̱li̱huaniyá̱n ni̱ mini̱ní tí nali̱lakuilí aklhchú ixká̱n nac actzú sa̱sti lháka̱t porque acxni nacheké nata̱ctzuhuí y ma̱s lanca talacaxti̱ta que la̱ xapu̱lh ixtalacaxti̱tni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ni̱ para mini̱ní muju̱cán sa̱sti pulque acxni tlihuekema nac aklhchú ixmakxu̱hua borrego, porque namá sa̱sti pulque tla̱n ma̱pa̱panká y acxtum talaktzanká. Huá xlacata mini̱ní muju̱cán sa̱sti pulque nac sa̱sti ixmakxu̱hua borrego xlacata acxtum natatatlihueklha y natata̱yaní. ");
INSERT INTO topNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Maktum la̱ta ixca̱ta̱chihui̱namajcú cristianos chilh ní ixyá Jesús cha̱tum xapuxcu tí ixtama̱kalhtahuake̱nán nac sinagoga ixuanicán Jairo. Xlá tatzokostánilh y huánilh: ―Quintzuma̱t puntzujcú ni̱ko̱lh, pero ccatzí nalacastacuanán para huix li̱macxamaya mimacán. ");
INSERT INTO topNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús ma̱tlá̱ni̱lh y ca̱tá̱alh ixdiscípulos nac ixchic Jairo. ");
INSERT INTO topNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Pero ixca̱takokeni̱t cha̱tum pusca̱t tí ixkalhi̱yá akcu̱tuy ca̱ta la̱ta ixmakstajma ni̱ lá ixaksa̱nán. Xlá ma̱lacatzúhui̱lh Jesús y quilhpa̱xamánilh ixtláka̱t; ");
INSERT INTO topNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","porque ixpuhuán: “Para cxamaní ixlháka̱t Jesús ccatzí nacaksa̱nán.” ");
INSERT INTO topNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús acxcátzi̱lh tú ixtlahuani̱t y talakáspitli, huánilh: ―Na̱na, yaj tú cali̱púhuanti, huix pa̱t aksa̱nana porque quili̱pa̱huani̱ta; tla̱n cma̱ksa̱ni̱yá̱n. La̱ chihui̱nanko̱lh tuncán aksá̱nalh amá pusca̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ixli̱puntzú tácha̱lh nac ixchic Jairo, y Jesús acxni cá̱cxilhli músicos li̱lakaputza ixtatlaknama̱najá y lhu̱hua ixtatasama̱na, ");
INSERT INTO topNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ca̱huánilh: ―Hua̱k cataxtútit porque jaé tzuma̱t ni̱ xaní̱n la̱ puhuaná̱tit, xlá huata lhtatama. Xlacán tzúculh tali̱kalhkama̱nán y tali̱tziyá̱n; ");
INSERT INTO topNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","pero Jesús ca̱huanipá catatáxtulh, y acxni tataxtuko̱lh xlá tánu̱lh ní ixmá amá xaní̱n tzuma̱t. Makachípalh, lakasu̱t má̱qui̱lh, y tuncán lacastacuánalh. ");
INSERT INTO topNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","La̱ta ixli̱ti̱lanca amá pu̱latama̱n hua̱k cristianos tzúculh tali̱chihui̱nán la̱ ixma̱lacastacni̱ni̱t amá tzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Acxni qui̱táspitli nac ixchic amá chixcú, cha̱tuy lakatzí̱n tatakókelh y tzúculh tama̱ktasí: ―Ixli̱talakapasni rey David, ¡caquila̱lakalhamáu! ");
INSERT INTO topNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Xlá ni̱ tá̱yalh, pero la̱ cha̱lh nac ákxtaka ní ixtamakxtaka ca̱kalasquínilh: ―Huixín quila̱takokeni̱táu, ¿puhuaná̱tit tla̱n nacca̱ma̱lacahua̱ni̱yá̱n? ―Jé, Quimpu̱chinacán. Cca̱najlayá̱u mintachihuí̱n y cca̱li̱pa̱huaná̱n ―takálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jesús ca̱li̱lacaxámalh ixmacán nac ixlakastapucán, y ca̱huanipá: ―Para ca̱najlayá̱tit tla̱n cca̱ma̱lacahua̱ni̱yá̱n ¡catalakáke̱lh milakastapucán! ");
INSERT INTO topNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Amá lakatzí̱n caj la̱ ni̱tú talacahuá̱nalh. Pero Jesús ca̱li̱ma̱páksi̱lh ni̱tí catali̱ma̱kalhchihuí̱ni̱lh para huá ixca̱ma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Xlacán ni̱ takáxmatli y la̱ tatáxtulh amá ákxtaka tzúculh tali̱chihui̱nán amá pu̱latama̱n tí ixca̱ma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Apenas ixta̱ni̱t amá lacchixcuhuí̱n acxni táchilh makapitzi cristianos ixtali̱mín cha̱tum ko̱ko, ixespíritu tlajaná chú ixtlahuani̱t pues ixmakatlajani̱t ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús li̱ma̱páksi̱lh amá tlajaná catáxtulh ixmacni amá ko̱ko, y la̱ makxtakko̱lh xlá tuncán tla̱n chihuí̱nalh. Lhu̱hua cristianos tapa̱xahuako̱lh; ixtahuán: ―Juú nac quimpu̱latama̱ncán Israel ni̱cxni ixacxilhni̱táu cha̱tum chixcú tí tla̱n ca̱tlahuá tascújut la̱ jaé. ");
INSERT INTO topNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tí ni̱ ixtama̱tla̱ní ixtascújut Jesús huá fariseos porque ixtahuán: ―Namá chixcú tla̱n ca̱macma̱xtú cristianos ixespiritucán tlajaná porque ta̱scuja y li̱pa̱huán pi̱ huá xapuxcu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús tzucupá ca̱lakatza̱lá amá ca̱lacchiquí̱n xala amá pu̱latama̱n; nac ixpu̱tamakstoknicán judíos ixca̱ma̱kalhchihui̱ní cristianos la̱ Dios ixma̱lacatzuqui̱putún ixtapáksi̱t nac ixlatama̱tcán. Ixca̱ma̱ksa̱ní tí ixta̱tatlá, ixtakalhí ti̱pa̱katzi tá̱tat y tasipá̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Xlá acxni ixca̱cxila lhu̱hua cristianos ixca̱li̱lakaputzá la̱ ixtalama̱na; ixca̱li̱macá̱n la̱ xata̱ktzanká̱n borregos ni̱ma̱ ni̱ takalhí ixpu̱chinacán tí naca̱cuentaja, ¡hua̱k ixtalaktzanka̱ni̱t! ");
INSERT INTO topNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ixnacú ixli̱puhuán la̱ naca̱makta̱yá cristianos, huá ca̱li̱huánilh ixdiscípulos: ―Xli̱ca̱na huí lhu̱hua cristianos xata̱ktzanká̱n, y qui̱taxtú la̱ acxni huí lhu̱hua li̱xká̱nat y ni̱tú lhu̱hua cha̱lhca̱tnaní̱n tí natama̱quí tachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huixín camaksquíntit Mimpu̱chinacán Dios caca̱ma̱lakácha̱lh ixli̱ti̱lanca ca̱quilhtamacú ma̱s cha̱lhca̱tnaní̱n tí natama̱quí ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Maktum Jesús ca̱ma̱mákstokli amá cha̱cu̱tuy ixdiscípulos tí ixca̱li̱lhca̱ni̱t natali̱chihui̱nán y ca̱má̱xqui̱lh li̱tlihueke natama̱ksa̱ní tí takalhí ti̱pa̱katzi tá̱tat y tasipá̱ni̱t, na̱ chuná tla̱n natamacma̱xtú cristianos tí ixca̱makatlajani̱t tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jaé cha̱cu̱tuy ixdiscípulos tí ca̱lí̱lhca̱lh ixca̱huanicán: Simón, pero Jesús li̱ma̱pa̱cúhui̱lh Pedro; Andrés ixta̱cam Simón; Jacobo y Juan ixlakkahuasán Zebedeo; ");
INSERT INTO topNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé y Tomás; Mateo, tí ixma̱lakaxoke̱nán tumi̱n; Jacobo, ixkahuasa Alfeo; Lebeo, tí na̱ ixli̱ma̱pa̱cuhui̱cán Tadeo; ");
INSERT INTO topNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, tí xapu̱lh ixca̱ta̱lapu̱lá pu̱tum cristianos ixtali̱tapa̱cuhuí cananistas; Judas Iscariote, tí a̱stá̱n macamá̱sta̱lh Jesús ixmacancán ixenemigos. ");
INSERT INTO topNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","La̱ta ya̱ ixtataxtú ní ixama ca̱ma̱lakachá, xlá ca̱huánilh la̱ natali̱chihui̱nán y la̱ natalá ana ní natachá̱n: ―Ni̱ capítit ca̱ma̱kalhchihui̱ni̱yá̱tit ixpu̱latama̱ncán tí ni̱ judíos, ni̱ para caca̱lakpítit namá tí talama̱na nac Samaria; ");
INSERT INTO topNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","huixín huata caca̱ma̱kalhchihui̱ní̱tit tí la̱ xata̱ktzanká̱n borregos talama̱na juú nac quimpu̱latama̱ncán Israel. ");
INSERT INTO topNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Caca̱huanítit la̱ Dios ca̱cxilhlacachá̱n y chí ma̱lacatzuqui̱putún ixtapáksi̱t nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Caca̱ma̱ksa̱ní̱tit tí takalhí lepra, tí takalhí xatu̱ta yá tá̱tat; caca̱macma̱xtútit cristianos tlajananí̱n ni̱ma̱ ca̱makatlajani̱t y caca̱ma̱lacastacuaní̱tit tí apenas tani̱ko̱ni̱t. Aquit cca̱ma̱xqui̱yá̱n jaé li̱tlihueke tú nali̱scujá̱tit ni̱tú cca̱ma̱tají̱n, y huixín acxni nali̱ma̱ksa̱ni̱yá̱tit tí ta̱tatlá na̱ ni̱tú cama̱tají̱tit mintascujutcán. ");
INSERT INTO topNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’La̱ta ní napiná̱tit ni̱ cali̱pítit tumi̱n tú namaclacasquiná̱tit nac tijia; ");
INSERT INTO topNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ni̱ para cacucátit mintahuajcán tú nali̱hua̱yaná̱tit; ni̱ para cali̱pítit tunuj lí̱xtoko; cataxtútit la̱ta ya̱nántit huata milhaka̱tcán y mintatu̱nucán ni̱ma̱ huili̱ni̱tántit. Pues amá tí naca̱ma̱kalhchihui̱ni̱yá̱tit ca̱mini̱ní naca̱ma̱hui̱yá̱n porque cha̱tum tasa̱cua ca̱na ixchau siempre lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nac aktum ca̱chiquí̱n ní nachipiná̱tit, caputzátit ixchic cha̱tum chixcú tí tla̱n catzí y aná calatapá̱tit hasta xní napiná̱tit a̱lacatunu ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Acxni natanu̱yá̱tit, ca̱li̱tlá̱n cachihui̱nántit y caca̱huanítit tú li̱puhuaná̱tit tí talatanu̱ma̱na. ");
INSERT INTO topNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Para lactlá̱n tacatzí, camaksquíntit Dios caca̱sicuna̱tláhualh y ni̱tú caca̱tzanká̱nilh; pero tí ca̱lakmakaná̱n, cali̱makxtáktit, ni̱tú camaksquíntit Dios ixlacatacán. ");
INSERT INTO topNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Para nac aktum ákxtaka o aktum ca̱chiquí̱n ni̱ takaxmata mintachihuí̱n y ni̱ ca̱ma̱hui̱caná̱tit, nac ixlacati̱ncán caca̱tu̱tincxcántit pokxni ni̱ma̱ ca̱tantu̱tahuacán xlacata nata̱cxila ni̱ lakati̱yá̱tit ixkasatcán, y tuncán cataxtútit. ");
INSERT INTO topNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ni̱tú ma̱s caca̱huanítit, ixacstucán talaktzanka̱ni̱t; porque acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ixcamán namá cristianos ama takalhí ma̱s li̱cuánit castigo que amá lacli̱xcájnit cristianos tí ixtalama̱na maká̱n nac ca̱chiquí̱n Sodoma y Gomorra. ");
INSERT INTO topNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Aquit cca̱ma̱lakacha̱má̱n la̱ lacmanso lactzú borregos nac ixpu̱latama̱ncán lacli̱cuánit coyotes. Huixín, ¡skálalh calatapu̱lí̱tit la̱ tla̱huán tantum lu̱hua, pero acs catamakxtáktit tú naca̱tlahuanicaná̱tit la̱ tantum actzú paloma! ");
INSERT INTO topNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ni̱ caca̱maka̱klhán tú ama ca̱qui̱taxtuniyá̱n pues pa̱t ca̱macama̱sta̱caná̱tit ixlacati̱ncán ma̱paksi̱naní̱n judíos y hasta pa̱t ca̱ma̱kxtakajni̱caná̱tit nac ixpu̱tamakstoknicán. ");
INSERT INTO topNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ama cha̱n quilhtamacú pa̱t ca̱li̱pincaná̱tit caj quilacata ixlacati̱ncán reyes y laclanca ma̱paksi̱naní̱n. Xlacán ama ca̱ma̱kalhapali̱yá̱n, pero chuná jaé tla̱n naquila̱li̱chihui̱naná̱u ixlacati̱ncán gobernadores, ixlacati̱ncán cristianos tí ni̱ talakapasa Dios para xli̱ca̱na quila̱li̱pa̱huaná̱u. ");
INSERT INTO topNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huixín ni̱tú cali̱puhuántit tú pa̱t kalhti̱naná̱tit y tú pa̱t huaná̱tit acxni tú naca̱kalasquiniyá̱n tí naca̱ma̱kalhapali̱yá̱n pues Mimpu̱chinacán Dios ama akchipá mintalacapa̱stacnicán y huá ama chihui̱nán milacatacán; ");
INSERT INTO topNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","y minquilhnicán huata ama chihui̱nán tú naca̱ma̱cxcatzi̱ni̱yá̱n ixtalacapa̱stacni ixespíritu Minti̱cucán tí huí nac akapú̱n, y ni̱ mi̱cstucán pa̱t laktaxtuyá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ama cha̱n quilhtamacú acxni cha̱tum chixcú ama macama̱stá ixta̱cam xlacata namakni̱cán, cha̱tum xati̱cú ama liakskahuinán ixkahuasa xlacata nama̱kxtakajni̱cán, y cha̱tum kahuasa ama ta̱ra̱lacata̱quí ixti̱cú y hasta namacama̱stá xlacata namakni̱cán. ");
INSERT INTO topNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chí cca̱huaniyá̱n, caj quilacata lhu̱hua ama ca̱lakmakaná̱n, pero amá tí ni̱ tachokó y ta̱yaní hasta xní nati̱taxtukó jaé ni̱ lactlá̱n quilhtamacú, namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Para nac aktum ca̱chiquí̱n ni̱ ca̱cxilhputuncaná̱tit y ca̱pu̱tlakacaná̱tit, catza̱látit a̱lacatunu ca̱chiquí̱n, ni̱ catatlají̱tit. Pues aquit Xatalacsacni chixcú cca̱ma̱lacnu̱niyá̱n xlacata cama ca̱lakchiná̱n la̱ta ya̱ para lakatza̱lako̱yá̱tit nahuán ca̱lacchiquí̱n xalac Israel. ");
INSERT INTO topNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Cama̱kachakxí̱tit quintachihuí̱n: cha̱tum li̱ma̱kalhtahuáke̱t tí kalhtahuakamajcú ni̱ lá akapu̱lá ixma̱kalhtahuake̱ná, y cha̱tum tasa̱cua ni̱ lá ma̱s lanca huan la̱ ixpatrón tí liscuja. ");
INSERT INTO topNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Huá cca̱li̱huaniyá̱n, cha̱tum li̱ma̱kalhtahuáke̱t camakslihuékelh la lama ixma̱kalhtahuake̱ná, y cha̱tum tasa̱cua catakókelh ixlatáma̱t ixpu̱chiná. Pues aquit cli̱tanú mima̱kalhtahuake̱nacán y la̱ mimpu̱chinacán, y quili̱maca̱ncán cta̱scuja tlajaná. Calacpuhuántit, ¿tucu ni̱ naca̱li̱ya̱huacaná̱tit huixín tí quidiscípulos y tí quila̱li̱scujá̱u? ");
INSERT INTO topNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Pero huixín ni̱ cajicuántit tú napa̱xtoká̱tit porque aktum tancs tachihuí̱n siempre ta̱yaní, y tú tze̱k tlahuacán siempre catzi̱cán ixli̱maka̱s. ");
INSERT INTO topNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tú aquit cca̱huaniyá̱n ca̱tzi̱sní, huixín cali̱chihui̱nántit ca̱cuhuiní, y tú tze̱k cca̱huaniyá̱n, huixín cali̱chihui̱nántit ana ní tzamacán. ");
INSERT INTO topNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ni̱ caca̱maka̱klhán namá cristianos tí tla̱n tamakní y tala̱kalhí ixmacni cha̱tum cristiano, pero ni̱ lá tama̱laksputún, ni̱ para tala̱kalhí ixespíritu cha̱tum cristiano. Huixín ma̱s cajicuanítit Mimpuchinacán Dios porque xlá tla̱n ma̱laksputú y lactlahuá mili̱stacnicán y mimacnicán nac ca̱li̱ní̱n para lacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Minti̱cucán ni̱cxni ama ca̱kxtakmakaná̱n. Caca̱li̱lacahua̱nántit tantuy lactzú spitu, ca̱li̱sta̱cán ni̱ lhu̱hua ixtapalh, pero ¿a poco Dios ni̱ catzí acxni tapa̱tastá y taní? ");
INSERT INTO topNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xlá hua̱k catzí tú tapa̱xtoka tú tatlahuani̱t, hasta xachíxit miakxa̱kacán hua̱k tapu̱tlekén kanatunu. ");
INSERT INTO topNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Huá xlacata ni̱tú cali̱puhuántit tú pa̱xtoká̱tit, pues huixín ixcamán y ma̱s ixtapalh que lhu̱hua lactzú spitu. ");
INSERT INTO topNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Amá tí li̱pa̱xáu li̱ta̱yá quili̱pa̱huán ixlacati̱ncán cristianos, aquit na̱ li̱pa̱xáu cama ma̱luloka ixlacatí̱n Quinti̱cú xalac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero amá tí ni̱ li̱ta̱yá qui̱li̱pa̱huán ixlacati̱ncán cristianos, aquit na̱ ni̱ cama li̱ta̱yá clakapasa ixlacatí̱n Quinti̱cú xalac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Para puhuaná̱tit cmini̱t ca̱li̱ma̱tancsá quintachihuí̱n ixlatama̱tcán cristianos, ni̱ chú ama qui̱taxtú porque, ma̱squi ni̱ clacasquín, caj quilacata ama li̱tzucú tasi̱tzi. ");
INSERT INTO topNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pues caj quilacata cha̱tum kahuasa ama ta̱ra̱makasi̱tzí ixti̱cú; cha̱tum tzuma̱t ama ta̱ra̱makasi̱tzí ixna̱na; y cha̱tum puhuiti̱ní ama ta̱ra̱makasi̱tzí ixpuhuiticha̱t. ");
INSERT INTO topNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Y lhu̱hua li̱talakapasni ma̱squi lakxtum talama̱na ama tama̱lacatzuquí tasi̱tzi y tara̱lakmakán caj ixlacata quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Aquit tancs cca̱huaniyá̱n, huata cama li̱macá̱n xli̱ca̱na quintakoké amá tí pu̱la aquit quilakalhamán y ca̱li̱makxtaka a̱li̱stá̱n ixna̱na, ixti̱cú, ixkahuasa, istzuma̱t; y amá tí ni̱ ma̱tla̱ní tú cca̱huanín catlahuátit, mejor ni̱ caquilákmilh. ");
INSERT INTO topNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Porque tí quintakoké ni̱ lakcatzán ixli̱stacni para makatzanká caj quilacata, y tí ni̱ ma̱tla̱ní tú cma̱lacnú, ¡ni̱ caquintakókelh! ");
INSERT INTO topNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Amá tí makli̱huán lakma̱xtputún ixli̱stacni ama makatzanká tú lakcatzán, pero tí ni̱ lakcatzán makatzanká ixli̱stacni caj quilacata namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Amá cristiano tí ca̱maklhti̱naná̱n nac ixchic, capa̱xáhualh porque la̱ aquit caquimaklhtí̱nalh, y tí aquit quinta̱latamá na̱ ta̱latamá Dios tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amá tí pa̱xcatcatzi̱ní la̱ Dios ma̱lakachá̱nilh cha̱tum profeta y ta̱hua̱yán nac ixchic, a̱stá̱n xlá ama ma̱xquí ixtaxokó̱n la̱ ni̱ma̱ ama ma̱xquí cha̱tum profeta; y tí maklhti̱nán nac ixchic cha̱tum tí tla̱n catzí chixcú, caj xlacata lakapasa ni̱tú ixkásat, Dios acxtum ama ca̱ma̱xquí ixtaxoko̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Na̱ chuná tí ta̱kota ca̱na akstum poke chúchut amá ma̱s ni̱ xtali̱pa̱u quidiscípulo tí quintakoké, caj xlacata catzí quimacuaní, tancs cca̱huaniyá̱n ama cha̱n quilhtamacú Dios ama ca̱ma̱xquí ixtaxoko̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","La̱ ca̱ma̱kalhchihui̱ni̱ko̱lh Jesús cha̱cu̱tuy ixdiscípulos tú ixli̱tlahuatcán xlacán táalh tali̱chihui̱nán ana ní ca̱ma̱lakácha̱lh; y xlá na̱ alh ixacstu ca̱ma̱kalhchihui̱ní cristianos xala amá pu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista ixtanu̱majcú nac pu̱la̱chi̱n, pero hua̱k ixli̱ma̱kalhchihui̱ni̱cán ixtascújut Jesús, y huá ca̱li̱ma̱lakácha̱lh cha̱tuy ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Xlacán takalasquínilh: ―¿Xli̱ca̱na huix Cristo tí ma̱lacnu̱cani̱t ama quinca̱lakma̱xtuyá̱n, o amajcú min tunu ma̱s tali̱pa̱u? ");
INSERT INTO topNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús ca̱kálhti̱lh: ―Cali̱ma̱kalhchihui̱ní̱tit Juan tú huixín acxilá̱tit cca̱tlahuá, y tú kaxpatá̱tit cli̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Calacspi̱tnítit la̱ cca̱ma̱lacahua̱ní lakatzí̱n, la̱ tatla̱huán tí ixtatala̱kalhi̱ni̱t, la̱ tatake̱nú ixta̱tatcán leprosos, la̱ ta̱kahua̱nán tí ixtata̱kata̱pani̱t, la̱ talacastacuanán tí apenas tani̱ko̱ni̱t; cahuanítit la̱ cca̱ma̱lacnu̱ní tunuj tla̱n latáma̱t tí tali̱ta̱yá huí tú ca̱tzanka̱ní nac ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Na̱ cahuanítit aquit cli̱pa̱xahuá amá tí ni̱ huilhaj huilí ixtapuhuá̱n y ni̱ li̱makxtaka ca̱najlá aquit amá tí ma̱lacnu̱cani̱t ama ca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Acxni táalh amá lacchixcuhuí̱n Jesús tzúculh li̱chihui̱nán Juan, ca̱huánilh cristianos: ―Huixín qui̱látit nac desierto; chí quila̱huaníu, ¿tucu qui̱acxílhtit? ¿Qui̱li̱lacahua̱nántit la̱ ca̱ma̱tzahuají u̱n ká̱ti̱t ni̱ma̱ tatzamá aná? ");
INSERT INTO topNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O ¿ixlacaputzayá̱tit cha̱tum chixcú tí tla̱n lhaka̱nani̱t la̱ ni̱ma̱ tahuila̱na nac pu̱ma̱paksí̱n? ¡Namá ni̱ taxtú! O ¿ixacxilhputuná̱tit cha̱tum chixcú tí ma̱lakacha̱ni̱t Dios? ");
INSERT INTO topNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Para chuná qui̱táxtulh li̱huacá tla̱n porque qui̱kaxpáttit cha̱tum chixcú tí li̱macamincani̱t ma̱s lanca que la̱ cha̱tum profeta. ");
INSERT INTO topNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan huá namá chixcú tí li̱chihuí̱nalh chuné Dios nac Escrituras: Pu̱la cama ma̱lakacha̱niyá̱n cha̱tum chixcú tí napu̱laniyá̱n, xlacata naca̱xtlahuaniyá̱n tijia ní nalactla̱huana. ");
INSERT INTO topNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Aquit tancs cca̱huaniyá̱n, la̱ta ixli̱hua̱kcán cristianos tí talakahuani̱t ca̱quilhtamacú, ni̱tí ma̱ccha̱ní ixli̱lanca Juan Bautista. Pero chí na̱ tancs cca̱huaniyá̱n, namá cristiano ma̱s ni̱ xatali̱pa̱u nac ixtapáksi̱t Dios ama̱ca li̱maca̱ncán ma̱s lanca que Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’La̱ta Juan titzúculh ca̱ma̱kalhchihui̱ní ca̱kmunú cristianos, lhu̱hua talacputzani̱t la̱ natama̱laksputú tú laclhca̱ni̱t Dios ca̱quilhtamacú, y huata tatanu̱ni̱t nac ixtapáksi̱t amá tí ni̱ tatachokoni̱t y takalhi̱ni̱t li̱camama. ");
INSERT INTO topNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Acxni Juan Bautista ya̱ ixma̱tzuquí ixtascújut, hua̱k profetas y na̱ chuná Moisés tali̱chihui̱nani̱t nac ixlibrojcán jaé quilhtamacú la̱ Dios ama ma̱lacatzuquí ixtapáksi̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Y para ni̱ ixcatzi̱yá̱tit, Juan huá namá Elías tí ixtama̱lacnu̱ni̱t profetas ama min antes nalacatzucú ixtapáksi̱t Dios nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tí takalhí ixtake̱ncán, ¡catakáxmatli tú cca̱huanimá̱n! ");
INSERT INTO topNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tucu xacta̱ma̱lacástucli cristianos tí talama̱na jaé quilhtamacú? Aquit cama ca̱li̱macá̱n namá lactzáca̱t lactzú camán ni̱ma̱ takama̱nán nac li̱tamá̱u, y tí ta̱cpuxcún jaé takamá̱n tasi̱tzí y tahuaní xa̱makapitzi: ");
INSERT INTO topNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“¿Tucu lacasquiná̱tit, cca̱tlaknaniyá̱n li̱pa̱xáu tatlí̱n y ni̱ tantli̱yá̱tit, cca̱tli̱niyá̱n li̱lakaputza alabanzas y ni̱ tasayá̱tit? ¡Huixín ni̱tú ma̱tla̱ni̱yá̱tit!” ");
INSERT INTO topNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Porque milh Juan Bautista; xlá ni̱ ixca̱ta̱pa̱xahuá, ni̱ para ixca̱ta̱talakxtumí ca̱ta̱hua̱yán cristianos, y huixín ixuaná̱tit: “Namá chixcú actanu̱ni̱t tlajaná.” ");
INSERT INTO topNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Astá̱n cmilh aquit Xatalacsacni Chixcú tí cca̱ta̱talakxtumí cca̱ta̱hua̱yán hua̱k cristianos y huaná̱tit: “Namá chixcú laktzanka̱ni̱t porque ca̱ta̱hua̱yán y ca̱ta̱latapu̱lí ixma̱lakaxoke̱naní̱n tumi̱n y tí takalhí lhu̱hua tala̱kalhí̱n.” Pero tancs cca̱huaniyá̱n, Dios catzí tú laclhca̱ni̱t y ni̱ lá tí lakxtapalí ixtalacapa̱stacni ma̱squi ni̱ ma̱kachakxi̱yá̱tit hasta xní nakantaxtú ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesús ixca̱li̱lakaputzá amá ca̱chiquín ní ixca̱tlahuanini̱t ma̱s lhu̱hua laclanca ixtascújut, pero tí ixtalama̱na aná ni̱tú ixca̱li̱macuanini̱t pues ni̱ ixtalakxta̱pali̱ni̱t ixlatama̱tcán. Xlá chuné ca̱lhcuyuyá̱hualh: ");
INSERT INTO topNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Koxitaní̱n tí talama̱na nac ca̱chiquí̱n Corazín! ¡Koxitaní̱n tí talama̱na nac ca̱chiquí̱n Betsaida! Porque para quintascújut ni̱ma̱ cca̱li̱ma̱lacahua̱ni̱ni̱tán xactica̱tláhualh nac ca̱chiquí̱n Tiro y Sidón, xlacán maka̱sá ixtitalakxtapáli̱lh ixlatama̱tcán, ixtitahuíli̱lh tzitzeke lháka̱t, ixtica̱li̱lakatzokca lhcaca xlacata naca̱li̱lakapascán tali̱lakaputzama̱na tú ixtatlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huá cca̱li̱huaniyá̱n, acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ixcamán, huixín pa̱t kalhi̱yá̱tit ma̱s li̱cuánit castigo que tí ixtalama̱na nac Tiro y Sidón. ");
INSERT INTO topNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¡Koxitaní̱n huixín tí lapa̱nántit nac Capernaum! Para puhuaná̱tit Dios ixca̱li̱lhca̱ni̱tán lanca nakalhi̱yá̱tit mimpu̱tahui̱lhcán nac akapú̱n, ¡aktzanka̱ni̱tántit! Porque pa̱t ca̱macapincaná̱tit nac puakxtakajni ní naxoko̱naná̱tit. Pero para quintascújut ni̱ma̱ acxilhni̱tántit xactica̱li̱ma̱lacahuá̱ni̱lh amá cristianos tí ixtalama̱na nac Sodoma, xlacán ixtitalakxta̱páli̱lh ixlatama̱tcán y Dios ni̱ ixtica̱lactláhualh. ");
INSERT INTO topNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Huá cca̱li̱huaniyá̱n, acxni natlahuacán taxokó̱n, xlacán ama takalhí li̱ctá castigo que huixín xalac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La̱ chihui̱nanko̱lh Jesús kalhtahuakánilh Dios, huá: ―Ta̱ta, clakachixcuhui̱yá̱n porque huix Ixpu̱chiná ca̱quilhtamacú y akapú̱n; cpa̱xcatcatzi̱niyá̱n la̱ ca̱ma̱tze̱kni tze̱k mintalacapa̱stacni amá lactali̱pa̱u y lakskalala lacchixcuhuí̱n, y li̱mákxtakti natama̱kachakxí mintalacapa̱stacni amá cristianos tí ni̱ talactlancán takaxmatá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ta̱ta, huix chú lacasquini̱ta, y chú qui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Astá̱n ca̱huánilh cristianos: ―Quinti̱cú Dios quima̱xqui̱ni̱t hua̱k la̱ta tú ckalhí. Aquit ni̱ tí quilakapasa huata Dios catzí aquit Ixkahuasa, y aquit na̱ ccatzí huá Quinti̱cú; y na̱ tla̱n talakapasa amá tí cca̱ma̱xquí quintalacapa̱stacni natalakapasa Quinti̱cú Dios. ");
INSERT INTO topNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Aquit cca̱tasaniyá̱n: caquintalákmilh hua̱k tí taliakatzanka̱ni̱t la̱ta taliakxtakajnán ixlatama̱t, aquit nacca̱ma̱xquí li̱camama tú natali̱ma̱jaxá ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Camaklhti̱nántit tú cca̱ma̱lacnu̱niyá̱n y camakslihuekétit quilatáma̱t; aquit hua̱k cpa̱tí ni̱tí cta̱ra̱si̱tzi̱ní y acxtum cca̱lakalhamán cristianos. Para chuná jaé latapa̱yá̱tit pa̱t ma̱jaxayá̱tit miespiritucán la̱ pa̱t ta̱yaniyá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Catlahuátit tú cca̱huaniyá̱n nac milatama̱tcán y namaklhcatzi̱yá̱tit la̱ ni̱ tuhua nama̱kantaxti̱yá̱tit pues quitaxtú caj la̱ cali̱pi aktum ni̱ tzinca tacuca. ");
INSERT INTO topNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Maktum quilhtamacú acxni hua̱k ixjaxcán Jesús ica̱ta̱tla̱huama ixdiscípulos nac aktum ca̱tucuxtu ixpu̱chancán trigo. Xlacán tá̱cxilhli trigo y como ixtatzincsma̱na tzúculh ta̱kaxlita y tahuani̱ní ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Makapitzi fariseos tí aná ixtalapu̱lá ca̱ma̱nóklhulh, y tuncán tahuánilh Jesús: ―Cacá̱cxilhti midiscípulos la̱ ta̱kaxlitma̱na ixtahuácat trigo jaé quilhtamacú acxni ni̱ mini̱ní tí tú nali̱scuja. ");
INSERT INTO topNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Xlá ca̱lacati̱tá̱yalh ixdiscípulos y kalhtí̱nalh: ―¿A poco amá̱n quila̱huaniyá̱u ni̱ li̱kalhtahuakani̱tántit tú titláhualh rey David maktum quilhtamacú acxni ca̱tá̱tzincsli ixcompañeros? ");
INSERT INTO topNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aná huan xlacata rey David tánu̱lh nac ixpu̱siculan Dios y cá̱cxilhli tasicuna̱tláu simi̱ta ni̱ma̱ huata curas ixca̱mini̱ní na̱tali̱hua̱yán, pero xlá ca̱tíyalh y ca̱ta̱huako̱lh ixcompañeros. ");
INSERT INTO topNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Na̱ chuná lacatum nac ixlibro Moisés li̱chihui̱nán la̱ curas tí tamacuaní Dios nac pu̱siculan siempre tascuja ma̱squi xa̱makapitzi tajaxa. Chí quila̱huaníu, ¿a poco xlacán takalhí ma̱s tala̱kalhí̱n porque ni̱ tama̱kantaxtí tú li̱ma̱paksi̱nán Dios? ");
INSERT INTO topNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Huá cca̱li̱huaniyá̱n, para xlacán ca̱li̱mákxtakli Dios catáscujli jaé chichiní y ni̱tí ca̱li̱huaní, juú ca̱ta̱chihui̱namá̱n cha̱tum ma̱s lanca chixcú que la̱ namá tí tascuja nac pu̱siculan. ");
INSERT INTO topNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Huixín ni̱ ma̱kachakxi̱yá̱tit namá ixtapáksi̱t Dios ni̱ma̱ tatzokni̱t nac Escrituras: “Ni̱ clacasquín quintali̱lakachixcúhui̱lh quincamán ixquitzistancaní̱n, ma̱s cma̱tla̱ní acxtum catara̱lakalhámalh.” Para ixma̱kachakxí̱tit ixtalacpuhuá̱n ni̱tí ixma̱lacapú̱tit, ni̱ para tú ixli̱ya̱huátit tú ni̱tú tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Xa̱huá, mili̱catzi̱tcán xlacata aquit Xatalacsacni Chixcú y Dios quimacama̱xqui̱ni̱t jaé chichiní y tla̱n tatlahuá cristianos tú talacasquín para aquit ni̱ cli̱huán. ");
INSERT INTO topNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","La̱ chihui̱nanko̱lh Jesús cha̱lh nac ca̱chiquí̱n y alh ca̱ma̱kalhchihui̱ní cristianos nac ixpu̱tamakstoknicán judíos. ");
INSERT INTO topNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na̱ aná ixtanu̱ma cha̱tum chixcú itsca̱cko̱ni̱t ixmacán ni̱ lá tú ixli̱tlahuá. Ixenemigos ixtalacputzá la̱ tla̱n natakalhtoklha Jesús xlacata tla̱n natama̱lacapú nac pu̱ma̱paksí̱n y huá tali̱kalásquilh: ―¿Puhuana tla̱n qui̱taxtú ma̱ksa̱ni̱cán cha̱tum ta̱tatlá jaé chichiní acxni hua̱k quili̱jaxatcán y li̱huancán tí nascuja? ");
INSERT INTO topNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús ca̱kálhti̱lh: ―La̱ta mili̱hua̱kcán, ¿ticu li̱makxtaka cani̱lh ixborrego para pa̱tastá nac pozo aktum chichiní acxni li̱huancán tí nascuja? Aquit ccatzí piná̱tit ma̱cutuyá̱tit xlacata ni̱ nalaktzanká. ");
INSERT INTO topNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Entonces, ¿hua̱nchi ni̱ ma̱tla̱ni̱yá̱tit ca̱ksá̱nalh cha̱tum chixcú acxni li̱ma̱paksi̱nancani̱t najaxcán? ¿A poco ni̱ ma̱s ixtapalh cha̱tum cristiano que tantum actzú quitzistanca? Aquit cca̱huaniyá̱n ni̱ huí tí tlahuá tala̱kalhí̱n ixlacatí̱n Dios jaé chichiní para tlahuaní aktum li̱tlá̱n ixta̱cristiano. ");
INSERT INTO topNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesús ca̱li̱ma̱lacahua̱ni̱pútulh tú ixca̱huanini̱t y huá li̱ta̱chihuí̱nalh amá chixcú tí itsca̱cko̱ni̱t ixmacán: ―Cata̱ya, y castonkti mimacán. Amá chixcú stonkli ixmacán y tuncán tatzamako̱lh xali̱hua ixmacxpá̱n la̱ xa̱makatu, ¡tla̱n aksá̱nalh! ");
INSERT INTO topNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Amá fariseos ixenemigos Jesús lacapala tatáxtulh la̱ta tasí̱tzi̱lh y a̱stá̱n tzúculh talacchihui̱nán la̱ tla̱n natamakní Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús acxcátzi̱lh tú ixtalaclhca̱nima̱na ixenemigos y huá xlacata lí̱alh a̱lacatunu pu̱latama̱n. Lhu̱hua cristianos tatakókelh y tí ixtakalhí tá̱tat xlá ca̱ma̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero tí ixca̱ma̱ke̱nu̱ní ixta̱tatcán tla̱n ixca̱li̱ma̱paksí ni̱ catali̱chihuí̱nalh para xlá ixca̱ma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ixlatáma̱t Jesús li̱ma̱kantáxti̱lh tú istzokni̱t ixlacata nac ixlibro profeta Isaías: ");
INSERT INTO topNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Cca̱ma̱lakacha̱nimá̱n tí clacsacni̱t, xlá ama quimacuaní y quinkaxmatní tú cli̱ma̱paksí. Aquit clakalhamán y cli̱pa̱xahuá la̱ ckalhí. Cama ma̱xquí hua̱k ixli̱tlihueke quintalacapa̱stacni, porque xlá ama li̱chihui̱nán la̱ aquit cama ca̱lakma̱xtú hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xlá ni̱tí ama ta̱ra̱makasi̱tzí, ni̱ para tí ama quilhní, y ni̱cxni ama aktasá nac ca̱lactijyí̱n xlacata nakaxmatcán ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xlá ni̱ ama ca̱li̱chiyá tí talaktzanka̱ni̱t, ni̱ para ama lactlahuá ixtalacapa̱stacnicán tí tancs talatama̱putún. Pero ama kalhí li̱tlihueke nama̱lacatzuquí ixtapáksi̱t ixli̱ti̱lanca ca̱quilhtamacú, ");
INSERT INTO topNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","y hua̱k cristianos xala cani̱huá ca̱lacchiquí̱n huata huá ama tali̱pa̱huán y talakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maktum quilhtamacú li̱minica Jesús cha̱tum chixcú tí ixmakatlajani̱t tlajaná, ko̱ko y lakatzí̱n ixtlahuani̱t. Xlá macmá̱xtulh amá tlajaná y a̱stá̱n amá chixcú tla̱n lacahuá̱nalh y tla̱n chihuí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hua̱k cristianos tí tá̱cxilhli tú tláhualh tapa̱xahuako̱lh. Ixtahuán: ―¿Chá huá jaé ixli̱talakapasni rey David tí ma̱lacnu̱cani̱t ama quinca̱lakma̱xtuyá̱n? ");
INSERT INTO topNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Makapitzi fariseos tí ixtalaya̱na aná takáxmatli ixtachihui̱ncán y na̱ tachihuí̱nalh: ―Jaé chixcú tla̱n ca̱macma̱xtú cristianos tlajananí̱n porque li̱pa̱huán Beelzebú xapuxcu tlajananí̱n, huá ta̱scuja. ");
INSERT INTO topNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ma̱kachákxi̱lh tú ixtali̱chihui̱nama̱na y ca̱huánilh amá lacchixcuhuí̱n: ―Huixín catzi̱yá̱tit para xanapuxcún ixma̱paksi̱naní̱n aktum lanca pu̱latama̱n tatapitzí pu̱tunu ni̱ maka̱s tata̱yaní y tara̱lactlahuakó; na̱ chuná para tí talama̱na nac aktum ca̱chiquí̱n o aktum nac pu̱táhui̱lh tzucú tara̱nica ixacstucán ni̱ tamakapalá maka̱s, ¡tara̱lactlahuakó y tata̱kahuani̱kó! ");
INSERT INTO topNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aquit cca̱ta̱ma̱lacastucniyá̱n jaé takalhchihuí̱n con ixtapáksi̱t tlajaná: para aquit xactá̱scujli, ¿nicu li̱puhuaná̱tit nacta̱ra̱si̱tzi̱ní pi̱huá quinta̱tlajaná? ¡Sok ixlaclako̱lh ixtapáksi̱t! ");
INSERT INTO topNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Huixín quila̱li̱ya̱huayá̱u xlacata tlajaná quima̱xquí ixli̱tlihueke y huá tla̱n cca̱li̱macma̱xtú cristianos ixespiritucán tlajananí̱n pero makapitzi tí takaxmata mintachihui̱ncán na̱ takalhí li̱tlihueke ca̱macma̱xtú cristianos tlajananín. Quila̱huaníu, ¿ticu ca̱ma̱xquí namá li̱tlihueke, Dios o Beelzebú? Aquit cca̱huaniyá̱n, nac ixlacatí̱n Dios pi̱huá ixtascujutcán ama ca̱ma̱lacapu̱yá̱n xlacata naxokoyá̱tit tú quila̱li̱ya̱huama̱náu. ");
INSERT INTO topNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Huixín ni̱ ma̱kachakxi̱yá̱tit tú huaná̱tit; aquit cca̱tamacxtú tlajananí̱n porque Dios quima̱xquí li̱tlihueke, y huá jaé cca̱li̱ma̱lacahua̱ni̱yá̱n ixtapáksi̱t Dios ca̱lakchini̱tán nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Nicu li̱puhuaná̱tit tla̱n maklhti̱cán tú ma̱paksí cha̱tum tlihueke chixcú nac ixchic, para ni̱ pu̱la tla̱n akchi̱huili̱cán? Aquit cmakatlajani̱t amá tlihueke chixcú y huá tla̱n cli̱maklhtí tú clacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Aquit cca̱huaniyá̱n, amá tí ni̱ quinta̱ta̱yá nac quintascújut cli̱macá̱n quisi̱tzi̱ní, y tí ni̱ quinta̱ma̱makstoka cristianos natatanú nac quintapáksi̱t ca̱ma̱kahuaní cata̱ktzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","’Chí aquit tancs cca̱huaniyá̱n xlacata Dios tla̱n ca̱ma̱tzanke̱naní cristianos hua̱k ixtala̱kalhi̱ncán, na̱ chuná acxni tali̱quilhán lhu̱hua lacli̱xcájnit tachihuí̱n, hasta amá cristianos tí ni̱tú quili̱cxila ni̱ tla̱n quili̱chihui̱nán na̱ tla̱n nama̱tzanke̱nanicán ixtala̱kalhí̱n; pero amá tí li̱kalhkama̱nán tú ca̱li̱ma̱lacahuani̱má̱n ixlitlihueke Espíritu Santo huan xlacata ixtascújut tlajaná, ni̱ catima̱tzanke̱nanica ixtala̱kalhi̱ncán, ni̱ para juú ca̱quilhtamacú, ni̱ para nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Siempre akatum tla̱n quihui ma̱stá tla̱n ixtahuácat, y akatum ni̱ tla̱n quihui ma̱stá ni̱ tla̱n ixtahuácat pues akatunu quihui ca̱li̱lakapascán ixtahuacatcán. ");
INSERT INTO topNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Quila̱huaníu, ¿puhuaná̱tit huixín ma̱sta̱yá̱tit lactlá̱n mintahuacatcán? ¡Huixín la̱ akskahuinaní̱n lu̱hua! Ca̱huaná̱tit lacli̱xcájnit tachihuí̱n porque li̱xcájnit talacapa̱stacni kalhí minacujcán pues cha̱tunu cristiano li̱chihui̱nán ixquilhni la̱ kalhí ixtalacapa̱stacni ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Cha̱tum tí tla̱n catzí li̱chihui̱nán ixquilhni lactlá̱n ixtalacapa̱stacni ixnacú, y cha̱tum tí snu̱n lani̱t li̱chihui̱nán ixquilhni lacli̱xcájnit ixtapuhuá̱n ni̱ma̱ kalhí nac ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ixcamán, cha̱tunu ama xokoní la̱ta tú li̱tláhualh ixtachihuí̱n ni̱ma̱ li̱chihuí̱nalh ixquilhni. ");
INSERT INTO topNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kastunu ixtachihuí̱n cha̱tum chixcú ni̱ma̱ ca̱huán ama li̱ma̱ctí ixtala̱kalhí̱n o li̱ma̱cxtú ixtala̱kalhí̱n xlacata naxoko̱nán o nataxtuní. ");
INSERT INTO topNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Maktum quilhtamacú makapitzi fariseos y ixma̱kalhtahuake̱nacán judíos tama̱lacatzúhui̱lh Jesús, y tahuánilh: ―Maestro, para huix namá tí ma̱lacnu̱cani̱t ama min quinca̱lakma̱xtuyá̱n y kalhí ixli̱tlihueke Dios catlahua tunu mintascújut. ");
INSERT INTO topNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Xlá ca̱kálhti̱lh: ―Huixín tí lapa̱nántit jaé quilhtamacú ni̱ lá pa̱ti̱cán minkasatcán; snu̱n li̱xcájnit mintalacpuhua̱ncán huá ni̱ li̱ca̱najlayá̱tit tú ctlahuá. Tza̱pu quila̱maksquiná̱u cacca̱li̱ma̱lacahua̱ní̱n lanca quintascújut, y chí lacasquiná̱tit cactláhualh aaktum. Tó, ni̱ cama tlahuá, y huata pa̱t li̱lacahua̱naná̱tit aktum tascújut la̱ amá ni̱ma̱ Dios titláhualh nac ixlatáma̱t profeta Jonás. ");
INSERT INTO topNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Xlá tipa̱táju̱lh tantum lanca tamakní aktutu chichiní y aktutu tzisní, y aquit Xatalacsacni Chixcú na̱ chuná cama ca̱talakatze̱kniyá̱n ca̱quilhtamacú aktutu chichiní y aktutu tzisní. ");
INSERT INTO topNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","La̱ tipa̱tácutli Jonás amá tamakní alh ca̱li̱ma̱kalhchihuí̱ni̱lh cristianos tí ixtalama̱na nac Nínive tú ixlacasquín Dios catatláhualh y xlacán talakxta̱páli̱lh ixlatama̱tcán, pero huixín ma̱s lactlancaná̱tit; y acxni Dios naca̱ta̱tlahuayá̱n taxokó̱n, xlacán ama ca̱ma̱lacapu̱yá̱n nac ixlacatí̱n. Porque juú ca̱ta̱chihui̱namá̱n cha̱tum ma̱s lanca chixcú que profeta Jonás, pero huixín ni̱ para chú lakxta̱pali̱yá̱tit milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y nac ixlacatí̱n Dios na ama ca̱ma̱lacapu̱yá̱n amá reina xalac Sur porque xlá ma̱squi mákat ixuani̱t ixpu̱latama̱n, milh kaxmata ixtachihuí̱n amá skalala rey Salomón, y juú ca̱ta̱chihui̱namá̱n cha̱tum ma̱s skalala que rey Salomón y ni̱ para chú ma̱palajá̱tit minkasatcán. ");
INSERT INTO topNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Tí talama̱na jaé quilhtamacú cama ca̱ta̱ma̱lacastuca jaé takalhchihuí̱n: Cha̱tum tlajaná acxni ma̱xtucán nac ixmacni cha̱tum chixcú an latapu̱lí ní nataka̱sa tí tla̱n na̱kchipaní ixtapuhuá̱n. Y para ni̱ taka̱sa lacapa̱staca ní ixlama, y puhuán: ");
INSERT INTO topNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cama taspita nac quínchic ní ctáxtulh.” Xlá an lacahua̱nán y acxila ixtapuhuá̱n amá chixcú la̱ aktum ákxtaka ni̱ma̱ tla̱n taca̱palhni̱t y ni̱tí pu̱lama. ");
INSERT INTO topNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Entonces an ca̱putzá a̱cha̱tujún ma̱s lacli̱cuánit ixta̱tlajananí̱n y acxtum tata̱latamá amá chixcú. Para jaé chixcú snu̱n ixma̱kxtakajní caj cha̱tum tlajaná, pues ¿niculá naca̱ta̱ta̱yaní cha̱tujún? Huá cca̱li̱huaniyá̱n huixín na̱ tla̱n akspulayá̱tit chuná para ni̱ kaxpatá̱tit quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chu̱tacú ixchihui̱nama acxni táchilh ixna̱na ixnata̱camán; xlacán tatamákxtakli nac quilhtí̱n porque istzamacán y huata tali̱kalasquiní̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cha̱tum huánilh Jesús: ―Mina̱na y minata̱camán taya̱na nac quilhtí̱n tata̱chihui̱namputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús ca̱kálhti̱lh: ―¿Ticu yá quina̱na y quinata̱camán? ");
INSERT INTO topNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Astá̱n acs ca̱lacá̱nilh ixdiscípulos y chihui̱nampá: ―Huá jaé cristianos la̱ quina̱na y quinata̱camán. ");
INSERT INTO topNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pues aquit cca̱huaniyá̱n xlacata tí tlahuá y latamá la̱ lacasquín Dios natalatamá cristianos, huá namá cli̱macá̱n la̱ quina̱na y la̱ quinta̱camán cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Xalakasmalankán amá chichiní Jesús táxtulh amá ákxtaka y alh nac ixquilhtú̱n chúchut xla Galilea. ");
INSERT INTO topNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ixli̱puntzú lhu̱hua cristianos tatamákstokli y huá xlacata li̱táju̱lh nac aktum akpáklha̱t y alh tziná lakamákat, hua̱k xa̱makapitzi tatamákxtakli nac ixquilhtú̱n chúchut. ");
INSERT INTO topNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","La̱ta ixtaju̱ma nac akpáklha̱t tzúculh lacpuhuán la̱ naca̱ta̱ma̱lacastucní ixtakalhchihuí̱n tú xlacán ixtalakapasa xlacata natama̱kachakxí ixtachihuí̱n; ca̱huánilh: ―Maktum quilhtamacú cha̱tum chixcú alh chan ixtalhtzi trigo nac ixpu̱chaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Xlá tzúculh spuyumí ixli̱chánat; lhu̱hua ixtalhtzi tama̱chá nac tijia y huata tá̱cxilhli lactzú spitu, hua̱k tasacuako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Makapitzi ixli̱chánat tama̱chá nac ca̱chihuixni caj tzinú ixta̱lani̱t tíyat nac ixkalhni. Ni̱ pasá̱rlalh lhu̱hua chichiní sok ta̱kpunko̱lh porque ni̱ pu̱lhmá̱n ixuí tíyat. ");
INSERT INTO topNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero acxni táxtulh chichiní ca̱xkoyuko̱lh ixpakán y tasca̱cko̱lh pues ni̱ pu̱lhmá̱n ixtamaca̱ni̱t ixtankaxekcán. ");
INSERT INTO topNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Makapitzi ixtachaná̱n tama̱chá nac ca̱xpayatni. Ni̱ ixli̱maka̱s chichiní uyu ta̱kpunko̱lh, pero ma̱s lacapala tástacli kajni y tama̱ksni̱ko̱lh ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Huata tata̱yánilh ixtachaná̱n ni̱ma̱ tatama̱chá nac tla̱n tíyat, jaé hua̱k tástacli y tamá̱sta̱lh lhu̱hua ixtahuacatcán. Huí ni̱ma̱ la̱ta akstum ixtalhtzi chalh tahuácalh aktum ciento ixtalhtzi, huí ni̱ma̱ sesenta, y huí ni̱ma̱ caj treinta má̱sta̱lh ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Para huixín kalhi̱yá̱tit mintake̱ncán, ¡cama̱kachakxí̱tit y cakaxpáttit tú cca̱huanimá̱n! ");
INSERT INTO topNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ixli̱puntzú ixdiscípulos tama̱lacatzúhui̱lh y takalasquínilh: ―¿Hua̱nchi ca̱ta̱ma̱lacastuca mintakalhchihuí̱n tú clakapasá̱u aquín, pues ni̱ para hua̱k cma̱kachakxi̱yá̱u? ");
INSERT INTO topNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús ca̱kálhti̱lh: ―Huixín Quinti̱cú ca̱ma̱cxcatzi̱ni̱yá̱n la̱ cama ma̱lacatzuquí quintapáksi̱t ca̱quilhtamacú, pero xa̱makapitzi cristianos ni̱ tama̱kachakxi̱ni̱t la̱ ama qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tí ma̱ta̱xtucni̱t jaé talacapa̱stacni ma̱s ama̱ca ma̱xqui̱cán hua̱k nama̱kachakxí, pero tí caj tziná tú ma̱kachakxí ama̱ca maklhti̱cán hasta ni̱ma̱ ixli̱skalhma̱ca. ");
INSERT INTO topNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aquit cca̱ta̱ma̱lacastucní quintakalhchihuí̱n tú xlacán talakapasa y la̱tiyá ma̱squi talacahua̱nán la̱ ni̱tú catá̱cxilhli y ma̱squi takaxmata la̱ ni̱ cata̱kahuá̱nalh pues ni̱tú tama̱kachakxí. ");
INSERT INTO topNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Huá jaé cristianos ca̱lakcha̱ni̱t tú ma̱lacpuhuá̱ni̱lh Dios profeta Isaías catzokli nac Escrituras. Aná huan: Xlacán ta̱ma̱n takaxmata tachihuí̱n, pero ni̱tú ama tama̱kachakxí; ama̱ca ma̱lacahua̱ni̱cán, pero ni̱ ama tacatzí tú ta̱cxilhma̱na. ");
INSERT INTO topNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Amá cristianos ni̱tú ama taca̱najlaputún porque ama tama̱lacchahuá xapuhui̱lhta ixnacujcán, ni̱ ama takaxmatputún lactlá̱n tapuhuá̱n, y la̱ lakatzí̱n ama talatama̱putún. Y para ni̱ lá tali̱lacahua̱nán ixlakastapucán, y ni̱ lá taliakahua̱nán ixtake̱ncán, pues ni̱tú catama̱kachákxi̱lh ixnacujcán xlacata nataca̱najlá y naquintalakmín xlacata aquit nacca̱ma̱ksa̱ní ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero capa̱xahuátit huixín porque kalhi̱yá̱tit milakastapucán y li̱lacahua̱naná̱tit, kalhi̱yá̱tit mintake̱ncán y li̱kaxpatá̱tit quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Xli̱ca̱na cca̱huaniyá̱n, lhu̱hua profetas y lactlá̱n lacchixcuhuí̱n xalakmaká̱n ta̱cxilhpútulh tú huixín li̱lacahua̱nampa̱nántit jaé quilhtamacú y ni̱ tá̱cxilhli; takaxmatpútulh quintachihuí̱n y ni̱ takáxmatli tú huixín ca̱lakchini̱tán. ");
INSERT INTO topNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Cama ca̱lacspi̱tniyá̱n la̱ qui̱taxtú xatakalhchihuí̱n chana̱ná. ¡Tla̱n cama̱kachakxí̱tit! ");
INSERT INTO topNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amá ixtalhtzi tachaná̱n ni̱ma̱ tama̱chá nac tijia y tasacuako̱lh lactzú spitu cca̱ma̱lacastuca tú qui̱taxtuní cha̱tum cristiano tí li̱ta̱chihui̱nancán ixtachihuí̱n Dios; xlá kaxmata, pero mina̱chá tlajaná y ma̱xtukó jaé talacapa̱stacni ni̱ma̱ ma̱nu̱ca nac ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amá ixtalhtzi tachaná̱n ni̱ma̱ tama̱chá nac ca̱chihuixni y ca̱makni̱ko̱lh chichiní cca̱ta̱ma̱lacastuca cristiano tí kaxmata ixtachihuí̱n Dios y ni̱ para tuhua li̱pa̱huán ixnacú; ");
INSERT INTO topNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero an quilhtamacú y tzucú akspulá tú ni̱ tla̱n, tzucú akxtakajnán, tzucú li̱chihui̱nancán xlacata li̱pa̱huán Dios, y como ixnacú ni̱ tla̱n li̱ma̱tzamani̱t ixtalacapa̱stacni Dios li̱makxtaka tuncán y yaj li̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amá ixtalhtzi tachaná̱n ni̱ma̱ tama̱chá nac ca̱xpayatni y tama̱ksni̱ko̱lh kajni, cta̱ma̱lacastuca cha̱tum cristiano tí kaxmata ixtachihuí̱n Dios y li̱pa̱huán, pero la̱ta li̱án ixlatama̱tcán tzucú ta̱katuyún, tzucú tali̱pa̱huán huata ixtumi̱ncán y la̱ li̱pa̱xáu natalatamá, y chuná tama̱ksni̱kó tú ixtali̱pa̱huán y ni̱ tama̱stá ixtahuacatcán. ");
INSERT INTO topNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Amá ixtalhtzi tachaná̱n ni̱ma̱ tama̱chá nac tla̱n tíyat y tamá̱sta̱lh ixtahuácat, cca̱ta̱ma̱lacastuca cristianos tí takaxmata ixtachihuí̱n Dios; xlacán tali̱pa̱huán y kastunu tachihuí̱n ni̱ma̱ tánu̱lh nac ixnacujcán tali̱ma̱stá ixtahuacatcán; huí ni̱ma̱ aktum ciento ixlacata, huí ni̱ma̱ sesenta, y huí ni̱ma̱ treinta ixlacata. ");
INSERT INTO topNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús ca̱ta̱ma̱lacastúcnilh ixtapáksi̱t Dios tunuj takalhchihuí̱n y ca̱huánilh: ―Aquit cma̱lacatzuqui̱ni̱t sa̱sti ixtapáksi̱t Dios ca̱quilhtamacú, pero la̱ta naán quilhtamacú ama lakchá̱n tú qui̱taxtuní ixca̱tucuxtu cha̱tum chixcú ni̱ma̱ chani̱t trigo. ");
INSERT INTO topNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Acxni hua̱k talhtatama̱na cha̱tum tí si̱tzi̱ní jaé xapu̱chiná min spuyumí nac ixca̱tucuxtu ixtalhtzi ni̱ lactlá̱n li̱cúxtut y tza̱lá tuncán. ");
INSERT INTO topNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jaé trigo tzucú staca, xaná y catlán ixtahuácat; y amá ni̱ lactlá̱n li̱cúxtut na̱ lakxtum ta̱staca tachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ixtasa̱cua jaé xapu̱chiná acxni tá̱cxilhli jaé li̱cúxtut tahuánilh ixpatroncán: “Señor, huix cá̱chanti nac minca̱tucuxtu puru xatalacsacni trigo, entonces ¿hua̱nchi na̱ tá̱stacli ni̱ lactlá̱n li̱cúxtut?” ");
INSERT INTO topNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Xlá ca̱kálhti̱lh: “Cha̱tum tí quisi̱tzi̱ní milh spuyumí nac quinca̱tucuxtu namá ixtalhtzi ni̱ lactlá̱n li̱cúxtut.” Xlacán tahuanipá: “Para lacasquina, chí tuncán nacaná̱u ca̱tampulhuyá̱u namá ni̱ lactlá̱n li̱cúxtut.” ");
INSERT INTO topNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Tó”, ca̱huánilh, “porque para ca̱tampulhuyá̱tit namá ni̱ lactlá̱n li̱cúxtut, na̱ tla̱n ca̱tampulhuyá̱tit lactlá̱n quintachaná̱n xla trigo. ");
INSERT INTO topNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Caca̱li̱makxtáktit lakxtum catacatlanke̱lh, y acxni naca̱tanca̱cán cama ca̱li̱ma̱paksí hua̱k quintasa̱cua lacatum catamá̱kstokli namá ni̱ lactlá̱n li̱cúxtut y catalhcúyulh, y a̱lacatunu catama̱mákstokli ixtahuácat quintachaná̱n xlacata nacma̱quí ní cca̱xtlahuani̱t ixpu̱ma̱qui̱cán.” ");
INSERT INTO topNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","’Ixtapáksi̱t Dios ni̱ma̱ cma̱lacatzuqui̱ni̱t ca̱quilhtamacú, ama staca la̱ staca akatum mostaza acxni chan nac ixca̱tucuxtu cha̱tum chixcú. ");
INSERT INTO topNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","La̱ta ixli̱hua̱k li̱cúxtut ni̱ma̱ ma̱s laclanca tastaca, huá ixtalhtzi mostaza ma̱s xalactzú, pero acxni akpún tzucú staca lacapala y hasta lactzú spitu tla̱n tlahuá ixma̱sekecán nac ixakán porque snu̱n lanca pakastaca. ");
INSERT INTO topNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","’Ixtapáksi̱t Dios ni̱ma̱ cma̱lacatzuqui̱ni̱t ca̱quilhtamacú na̱ cama ca̱ta̱ma̱lacastucniyá̱n ama staca la̱ acxni cha̱tum pusca̱t li̱ma̱xcutí ixharina caj actzú levadura, ixacstu xcutankó hua̱k itsquítit y tachixa. ");
INSERT INTO topNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús ca̱huánilh hua̱k ixtakalhchihuí̱n y ca̱ta̱ma̱lacastúcnilh tú xlacán ixtalakapasa. Ni̱cxni tú ixca̱huaní para ni̱ ixca̱ta̱ma̱lacastucní tú ixtali̱smani̱ni̱t ta̱cxila xlacata natama̱kachakxí ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chuná jaé kantáxtulh la̱ ixli̱chihui̱nani̱t Jesús cha̱tum profeta. Xlá huá: Acxni nacca̱ta̱chihui̱nán cristianos cama ca̱ta̱ma̱lacastucní tú xlacán talakapasa, xlacata natama̱kachakxí tze̱k quintalacpuhuá̱n ni̱ma̱ xacma̱qui̱ni̱t la̱ta tilacatzúculh ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús ca̱huánilh cata̱lhá nac ixchiccán hua̱k cristianos y xlá na̱ alh ní ixca̱ta̱tamakxtaka ixdiscípulos. Acxni tácha̱lh xlacán tahuánilh caca̱lacspí̱tniih la̱ ixqui̱taxtú amá xatakalhchihuí̱n ni̱ lactlá̱n li̱cúxtut ni̱ma̱ tá̱kpulh nac ixpu̱chancán trigo. ");
INSERT INTO topNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Xlá ca̱kálhti̱lh: ―Amá chixcú tí alh chana̱nán cli̱ma̱nú aquit Xtalacsacni Chixcú, ");
INSERT INTO topNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ixca̱tucuxtu ní alh chan ixtrigo cli̱ma̱nú ca̱quilhtamacú, y amá lactlá̱n ixtalhtzi trigo ni̱ma̱ tástacli cca̱li̱macá̱n cristianos tí taca̱najlani̱t quintachihuí̱n, y amá ni̱ lactlá̱n li̱cúxtut cca̱li̱macá̱n tí tatlahuá tú ca̱li̱ma̱paksí tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amá tí spuyúmi̱lh ni̱ lactlá̱n li̱cúxtut nac quinca̱tucuxtu cli̱macá̱n tlajaná. Amá tachaná̱n ni̱ma̱ catlán y ca̱tanca̱cán, cli̱macá̱n taxokó̱n ni̱ma̱ ama̱ca ca̱ta̱tlahuacán hua̱k cristianos. Tasa̱cua tí tascuja cca̱li̱macá̱n ángeles tí cama ca̱li̱ma̱paksí natama̱makstoka cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Amá quilhtamacú cama ca̱ma̱pitzí pu̱tunu cristianos na̱ chuná la̱ ma̱pitzicán ni̱ lactlá̱n li̱cúxtut y xalactlá̱n trigo. ");
INSERT INTO topNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aquit Xatalacsacni Chixcú cama ca̱li̱ma̱paksí ángeles pu̱tum catama̱makstokko̱lh cristianos tí ni̱ tla̱n tacatzí pues tama̱laktzanke̱ni̱t xa̱makapitzi y hua̱k tí tatlahuani̱t tú li̱xcájnit. ");
INSERT INTO topNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jaé cristianos ama̱ca ca̱maca̱ncán nac puakxtakajni ana ní nataxoko̱nán. ¡Koxitaní̱n, ama tatasá y tatatlanca̱ní la̱ta tali̱puhuán! ");
INSERT INTO topNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Amá tí tatlahuani̱t tú li̱ma̱paksi̱nán Dios porque xli̱ca̱na quintali̱pa̱huán, ¡catapaxáhualh porque ama talakaskoy la̱ aktum chichiní nac ixpu̱ma̱paksí̱n Quinti̱cú xalac akapú̱n! ¡Para kalhi̱yá̱tit mintake̱ncán cakaxpáttit tú cca̱huanimá̱n! ");
INSERT INTO topNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Amá tí xla̱huán kaxmata ixtachihuí̱n Dios y tanu̱putún nac quintapáksi̱t, qui̱taxtuní la̱ cha̱tum chixcú ni̱ma̱ taka̱sa aktum xa̱lu tumi̱n nac aktum ca̱quihuí̱n, y xlacata ni̱tí nacatzí aná tuncán ma̱tze̱kpará. Y la̱ta li̱pa̱xáu tú ta̱ksni̱t sta̱kó la̱ta tú kalhí y tama̱huá amá ca̱quihuí̱n xlacata ni̱tí nalakamaklhtí. ");
INSERT INTO topNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Chuná li̱tum, amá tí xla̱huán kaxmata ixtachihuí̱n Dios y tanu̱putún ixtapáksi̱t catunu la̱ cha̱tum ixtama̱huaná lactlá̱n li̱taca̱xta̱y; xlá putzatapu̱lí tí namaktama̱huanán, ");
INSERT INTO topNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","y acxni taka̱sa aktum tapixnu xla perlas ni̱ma̱ lhu̱hua ixtapalh, sta̱kó la̱ta tú kalhí y tama̱huá amá tapixnu ni̱ma̱ acxilhni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ixtapáksi̱t Dios na̱ ama qui̱taxtú la̱ acxni cha̱tum chixcú macá̱n istza̱lh nac chúchut y tahuacá lhu̱hua ti̱pa̱katzi tamakní, xalactlá̱n y ni̱ xalactlá̱n tamakní. ");
INSERT INTO topNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Xlá ca̱huaní ixtasa̱cua catamaktá̱yalh catata̱ma̱cútulh istza̱lh nac ixquilhtú̱n chúchut y aná tzucú ca̱lacsaca hua̱k tamakní. Xalactlá̱n tamakní ca̱muju̱cán nac canastas y ni̱ma̱ ni̱ xalactlá̱n ca̱tramakancán xlacata natalaktzanká. ");
INSERT INTO topNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na̱ chuná acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ixcamán, ángeles ama tama̱pitzí cristianos; pu̱tum ama̱ca ca̱maca̱ncán tí talaktzanka̱ni̱t y pu̱tum tí tataxtunini̱t. ");
INSERT INTO topNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Amá cristianos tí talaktzanka̱ni̱t ama̱ca ca̱maca̱ncán nac puakxtakajni ana ní nataxoko̱nán. ¡Koxitaní̱n, aná ama tatasá y tatatlanca̱ní la̱ta tali̱puhuán! ");
INSERT INTO topNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ca̱kalasquínilh Jesús la̱ ca̱chihui̱nanko̱lh: ―¿Ma̱kachakxi̱yá̱tit la̱ta tú cca̱huanini̱tán? ―Jé, cma̱kachakxi̱yá̱u ―takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Cahuanipá Jesús: ―Para xli̱ca̱na ma̱kachakxi̱yá̱tit nacca̱ta̱ma̱cstucniyá̱n jaé tachihuí̱n: Amá skalala chixcú tí tla̱n lacspi̱ta ixli̱ma̱paksí̱n Dios tú maká̱n ma̱xqui̱ni̱t y li̱tanú quidiscípulo, ma̱ta̱xtuca aktuy laclanca talacapa̱stacni, porque lakapasa ixtapuhuá̱n Dios ni̱ma̱ li̱ma̱paksi̱nán nac Escrituras, y li̱ma̱cstuca ixli̱skalala lacsa̱sti quintakalhchihuí̱n ni̱ma̱ cca̱li̱ma̱paksi̱má̱n. ");
INSERT INTO topNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","La̱ li̱chihui̱nanko̱lh jaé ixtalacapa̱stacni Jesús alh nac ca̱chiquí̱n Nazaret ana ní itstacni̱t. Maktum tánu̱lh nac sinagoga y tzúculh ca̱ma̱kalhchihui̱ní cristianos. Xlacán ni̱ ixtacatzí ní ixtiyani̱t ixli̱skalala y hua̱k ixli̱tlihueke ni̱ma̱ ixca̱li̱tlahuá ixtascújut. Ixtahuán: ―¿Nicu li̱ma̱tá̱xtucli jaé chixcú naskalalán y nakalhí li̱tlihueke? ");
INSERT INTO topNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Huá jaé ixkahuasacán María y José carpintero. Ca̱lakapasá̱u ixnata̱camán Jacobo, José, Simón y Judas. ");
INSERT INTO topNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ixnapi̱pín na̱ juú talama̱na y ca̱lakapasá̱u. Entonces, ¿ticu má̱xqui̱lh ixli̱skalala tú naquinca̱li̱ma̱kalhchihui̱ni̱yá̱n? ");
INSERT INTO topNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lhu̱hua cristianos xalac Nazaret ni̱ taca̱nájlalh ixtachihuí̱n, huá ca̱li̱huánilh Jesús: ―Cha̱tum profeta ni̱cxni lakalhamancán nac ixca̱chiquí̱n, ni̱ para tali̱pa̱huán ixta̱pakanatcán o ixli̱talakapasnicán, ma̱s li̱pa̱huancán skalala chixcú xala mákat. ");
INSERT INTO topNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Como ni̱ lhu̱hua taca̱nájlalh ixtachihuí̱n Jesús huata ca̱ma̱ksá̱ni̱lh makapitzi ta̱tatlaní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Rey Herodes tí ixma̱paksi̱nama amá pu̱latama̱n Galilea, acxni tzúculh kaxmata la̱ ixli̱chihui̱nancán cani̱huá tú ixtlahuá Jesús, ");
INSERT INTO topNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ca̱huánilh tí ixtata̱ma̱paksi̱nán: ―La̱ta cpuhuán namá chixcú ma̱x Juan Bautista, lacastacuánalh ca̱li̱ní̱n y mimpá ca̱quilhtamacú; huá tla̱n ca̱li̱tlahuá laclanca tascújut. ");
INSERT INTO topNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Rey Herodes ixli̱ma̱paksi̱nani̱t cachipaca Juan y cali̱chi̱huili̱ca cadenas nac pu̱la̱chi̱n porque ni̱ ixma̱tla̱ni̱ni̱t tú huánilh maktum: ―Ni̱ tla̱n la̱ lakamaklhti ixta̱cha̱t minta̱cam y ta̱tahuila miya̱sta. Herodes ixlakamaklhti̱ni̱t ixta̱cha̱t ixta̱cam Felipe y como Juan ni̱ li̱quilhpúhualh li̱huánilh ni̱ tla̱n la̱ ixta̱lama Herodías xlacán ni̱ ixta̱cxilhputún. ");
INSERT INTO topNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Xlá lacpútzalh la̱ tuncán namakní, pero ixca̱jicuaní cristianos para natata̱ra̱tlahuá caj ixlacata porque lhu̱hua ixtaca̱najlani̱t Dios ixma̱lakacha̱ni̱t jaé profeta Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero acxni ma̱spútulh ca̱ta Herodes tláhualh lanca fiesta; istzuma̱t Herodías tzúculh tantlí la̱ta istzamacán, y Herodes snu̱n lakáti̱lh la̱ tántli̱lh ");
INSERT INTO topNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","hasta ma̱lacnú̱nilh nama̱xquí xatu̱ta ixlacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Xlá ni̱ cátzi̱lh tú namaksquín, pero ixna̱na huánilh camáksquilh rey Herodes camacamá̱xqui̱lh ixakxa̱ka Juan Bautista nac aktum tina. ");
INSERT INTO topNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes acxni káxmatli tú ixlacasquín ni̱ lakáti̱lh, pero como tú ixma̱lacnu̱ni̱t nama̱stá hua̱k ixtakaxmatni̱t ni̱ takalhpúspitli y li̱tánu̱lh nama̱kantaxtí ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma̱lakácha̱lh cha̱tum soldado ní ixtanu̱ma Juan xlacata namakní; ");
INSERT INTO topNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","y tuncán pixca̱cti̱ca Juan nac pu̱la̱chi̱n; a̱stá̱n muju̱ca ixakxa̱ka nac aktum tina y ma̱xqui̱ca amá tzuma̱t tú itsquini̱t, y xlá má̱xqui̱lh ixna̱na. ");
INSERT INTO topNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Makapitzi tí ixtakaxmatni̱t ixtachihuí̱n Juan acxni tacátzi̱lh tú ixpa̱xtokni̱t támilh tatiyá nac pu̱la̱chi̱n y tla̱n tamúju̱lh; y a̱stá̱n táalh tali̱ma̱kalhchihui̱ní Jesús tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","La̱ kaxmatko̱lh Jesús tú huanica táju̱lh nac aktum barco y ca̱tá̱alh ixdiscípulos lacatum ní ni̱ tzamacán xlacata ni̱tí na̱kaxculí. Pero lhu̱hua cristianos xala cani̱huá ca̱lacchiquí̱n tacátzi̱lh ní ixama cha̱n y ca̱tujún táalh ní ixama tacuta. ");
INSERT INTO topNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Acxni tá̱ctalh ixquilhtú̱n chúchut cá̱cxilhli lhu̱hua cristianos ixtakalhi̱ma̱na. Xlá ca̱lakalhámalh cristianos y ca̱ma̱ksá̱ni̱lh ta̱tatlaní̱n ni̱ma̱ ixca̱li̱mincani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Acxni istzucuma smalankanán ixdiscípulos tama̱lacatzúhui̱lh y tahuánilh: ―Smalankaná y ni̱tí lama juú, caca̱huani jaé cristianos catáalh juú lacatzú ca̱lacchiquí̱n xlacata natatama̱huá tú natali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús ca̱kálhti̱lh: ―Ni̱ clacasquín ní catáalh; huixín caca̱ma̱huí̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xlacán takalhti̱nampá: ―¿Niculá nacca̱ma̱hui̱yá̱u si huata ckalhi̱yá̱u macquitzis simi̱ta y tantuy tamakní? ");
INSERT INTO topNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―A ver caquila̱li̱miníu namá tahuá ―ca̱huaniko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús ca̱li̱ma̱páksi̱lh hua̱k cristianos catatahuilako̱lh nac ca̱tiyatni pues ixti̱hui li̱cúxtut. La maklhtí̱nalh amá macquitzis simi̱ta y tantuy tamakní láca̱lh nac akapú̱n, pa̱xcatcatzí̱nilh Dios amá tahuá; a̱stá̱n ca̱lakchékelh, ca̱má̱xqui̱lh ixdiscípulos xlacata xlacán natama̱kpitzí y natama̱xquí̱ tí ixlacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Hua̱k cristianos tla̱n tahuá̱yalh y takálhkasli, y todavía kalhtá̱xtulh akcu̱tuy canasta simi̱ta y tamakní. ");
INSERT INTO topNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Huata lacchixcuhuí̱n tí tahuá̱yalh cha̱quitzis mi̱lh ixtahuani̱t aparte lacchaján y lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesús ca̱huánilh ixdiscípulos catatáju̱lh nac barco xlacata pu̱la natachá̱n ixa̱quilhtu̱tu chúchut; a̱stá̱n na̱ tzúculh ca̱huaní hua̱k cristianos cataalhá nac ixchiccán. ");
INSERT INTO topNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","La̱ ta̱nko̱lh cristianos Jesús talacá̱cxtulh ixacstu nac sipi y aná kalhtahuakánilh Dios. Acxni tla̱n tzi̱suanko̱lh xlá ya̱ ixtalaca̱ctá; ");
INSERT INTO topNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ixdiscípulos ixtaani̱ttá lakamákat ma̱squi ni̱ lá ixtachá̱n porque také̱talh u̱n y ni̱ ixca̱ma̱xquí quilhtamacú natama̱tla̱hualí̱n ixbarcojcán ma̱s chá ixtapu̱spitputún. ");
INSERT INTO topNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Li̱huacá tzisa ixuani̱t Jesús ca̱ma̱lacatzúhui̱lh ixdiscípulos ixtla̱huama ixkalhni nac chúchut. ");
INSERT INTO topNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Xlacán acxni tá̱cxilhli Jesús ixtla̱huama ixkalhni chúchut, tajicuanko̱lh y yaj takálhi̱lh li̱camama y chuné ta̱ktásalh: ―¡Mimá̱n quinca̱maka̱klhayá̱n cha̱tum xaní̱n chixcú! ");
INSERT INTO topNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero xlá ca̱huánilh: ―¡Ni̱ cajicuántit! ¡Cakalhí̱tit li̱camama, aquit, Jesús! ");
INSERT INTO topNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Huánilh Pedro: ―Para xli̱ca̱na huix, Quimpu̱chinacán, caquima̱tla̱huani nac chúchut xlacata naclakana̱chá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Pues catat tuncán ―huaniko̱lh Jesús. Pedro tá̱ctalh nac barco y tzáksalh tla̱huán ixkalhni chúchut pakán ní ixyá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero huata tatú̱talh nac chúchut anko̱lh ixli̱camama pues u̱n y chúchut puxmani̱ko̱lh, y como maklhcátzi̱lh ixama ta̱ktzí ma̱ktási̱lh Jesús: ―Quimpu̱chiná Jesús, ¡cama mu̱xtú; caquimakachipa! ");
INSERT INTO topNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Xlá makachípalh y huánilh: ―¿Hua̱nchi ni̱ quili̱pá̱huanti tla̱n nacma̱tla̱huani̱yá̱n nac chúchut? ");
INSERT INTO topNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","La̱ tatáju̱lh ixcha̱tuycán nac barco, u̱n ni̱ma̱ ixtake̱tani̱t, caj la̱ ni̱tú také̱nu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hua̱k xa̱makapitzi ixdiscípulos tatatzokostánilh y tahuánilh: ―¡Xli̱ca̱na huix Ixkahuasa Dios! ");
INSERT INTO topNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ixli̱punchú talakatza̱lako̱lh amá chúchut xla Galilea y tácha̱lh nac aktum ca̱chiquí̱n huanicán Genesaret. ");
INSERT INTO topNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ni̱ para tuhua tacatzi̱ko̱lh cristianos xala ca̱chiquí̱n xlacata ixca̱lakmini̱t Jesús. Lhu̱hua xala amá pu̱latama̱n na̱ tacátzi̱lh y tzúculh tali̱mín ixta̱tatlaní̱n xlacata naca̱ma̱ksa̱ní Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Makapitzi ixtahuaní caca̱má̱xqui̱lh quilhtamacú nataquilhpa̱xamaní siquiera ixlháka̱t, y hua̱k ta̱tatlaní̱n tí taxamánilh ixlháka̱t Jesús hua̱k ta̱ksa̱nanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Maktum quilhtamacú támilh xalac Jerusalén makapitzi fariseos y ixma̱kalhtahuake̱nacán judíos; xlacán tama̱lacatzúhui̱lh Jesús y takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Ccatzi̱putuná̱u, ¿hua̱nchi midiscípulos ni̱ tama̱kantaxtí tú tali̱ma̱paksi̱nani̱t lakko̱lún quili̱tlahuatcán? Pues ni̱ talakachixcuhuí Dios, ni̱ tamakachaká maklhu̱hua acxni tahua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Xlá ca̱kálhti̱lh: ―Aquit na̱ ccatzi̱putún, ¿hua̱nchi lakmakaná̱tit tú ca̱li̱ma̱paksi̱ni̱tán Dios mili̱tlahuatcán nac milatama̱tcán? ¿Hua̱na ma̱s li̱lakachixcuhui̱yá̱tit Dios tú lacsacxtuni̱tántit? ");
INSERT INTO topNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios li̱ma̱paksí̱nalh: “Calakalhámanti minti̱cú y mina̱na, y amá tí lakmakán ixti̱cú o ixna̱na cama̱lacapu̱ca xlacata namakni̱cán.” ");
INSERT INTO topNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero huixín huaná̱tit xlacata cha̱tum chixcú tla̱n kalhtí ixti̱cú acxni tú maclacasquín: “Ni̱ lá cmakta̱yayá̱n porque la̱ta tú ckalhí cma̱lacnu̱nini̱t Dios cama li̱lakachixcuhuí nac pu̱siculan.” ");
INSERT INTO topNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","¡Takalhí̱n lacchixcuhuí̱n! Huixín tlahuapa̱nántit tú puhuaná̱tit ma̱s ca̱macuaniyá̱n y lakmakampa̱nántit tú ca̱li̱ma̱paksí̱n Dios xlacata pu̱la caca̱lakalhamántit minati̱cún. ");
INSERT INTO topNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Akskahuinaní̱n lacchixcuhuí̱n! Tancs ma̱kantaxti̱pa̱nántit ixtachihuí̱n profeta Isaías tú tzokli milacatacán nac Escrituras: ");
INSERT INTO topNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Jaé cristianos quintali̱lakachixcuhuí ixtachihuí̱n ixquilhnicán, pero ixnacujcán tunuj tú talacpuhuán. ");
INSERT INTO topNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ni̱tú ca̱li̱macuaní quintalakachixcúhui̱lh pues tú tali̱chihui̱nán hua̱k pi̱huá talacsacxtuni̱t y tali̱macá̱n aquit cca̱ma̱paksi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Astá̱n Jesús ca̱tasánilh catama̱lacatzúhui̱lh hua̱k cristianos y ca̱huánilh: ―Tla̱n quila̱li̱kaxmatui mintake̱ncán y cama̱kachakxí̱tit tú cama ca̱huaniyá̱n: ");
INSERT INTO topNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Catu̱huá tahuá tú quilhtanú cha̱tum chixcú ni̱ la̱kalhí ixtalacapa̱stacni; tú ma̱tlahuí tala̱kalhí̱n ixlacatí̱n Dios huá tú quilhtaxtú ixquilhni acxni chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ixdiscípulos a̱stá̱n tama̱lacatzúhui̱lh y tahuánilh: ―Namá fariseos ni̱ tama̱tlá̱ni̱lh tú ca̱huani, tasí̱tzi̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Xlá ca̱kálhti̱lh: ―Hua̱k quihui ni̱ma̱ ixacstucán tapulhni̱t y ni̱ Quinti̱cú tí huí nac akapú̱n ca̱chani̱t ama ca̱tampulhú. ");
INSERT INTO topNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cali̱makxtakuí catatláhualh tú tatlahuaputún porque xlacán la̱ lakatzí̱n talama̱na, ¡y todavía tali̱tanú tamakachipalí̱n tunuj lakatzí̱n! Talaktzanka̱ni̱t porque para ta̱kchakxa, acxtum ama talhtuja. ");
INSERT INTO topNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","―Ni̱ cma̱kachakxi̱yá̱u la̱ namá qui̱taxtú; catlahua li̱tlá̱n quila̱lacspi̱tníu ―huánilh Pedro. ");
INSERT INTO topNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","―¿A poco ni̱ para huixín ma̱kachakxi̱yá̱tit tú cca̱huaniputuná̱n? ");
INSERT INTO topNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ni̱ catzi̱yá̱tit xlacata amá tahuá ni̱ma̱ quilhtanú cha̱tum chixcú an nac ixpa̱lu̱hua y a̱stá̱n makampará? ");
INSERT INTO topNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","¡Namá ni̱ ma̱tlahuí tala̱kalhí̱n! Tú ma̱laktzanké huá ixtalacapa̱stacni ni̱ma̱ li̱chihui̱nán ixquilhni. ");
INSERT INTO topNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porque ixquilhni ca̱li̱huán ni̱ lactlá̱n ixtalacapa̱stacni ni̱ma̱ tataxtú nac ixnacú. Aná lacpuhuán la̱ namakni̱nán, la̱ nalakamaklhtí ixpusca̱t ixta̱chixcú, la̱ naca̱putzá lhu̱hua pusca̱t, la̱ nakalha̱nán, la̱ naakskahuinán, y la̱ naaksani̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Huá jaé talacapa̱stacni ma̱tlahuí tala̱kalhí̱n cha̱tum cristiano; pero ni̱ tlahuá tala̱kalhí̱n para ni̱ ma̱kantaxtí li̱lakachixcuhui̱n acxni hua̱yán y makachaká maklhu̱hua. ");
INSERT INTO topNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús alh ca̱ma̱kalhchihui̱ní cristianos tí ixtalama̱na nac aktuy pu̱latama̱n ca̱huanicán Tiro y Sidón. ");
INSERT INTO topNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Aná ixlama cha̱tum pusca̱t xala mákat pu̱latama̱n huanicán Canaán, ni̱ israelita ixuani̱t. Xlá ma̱lacatzúhui̱lh y ca̱li̱tlá̱n huánilh: ―Quimpu̱chinacán, ixli̱talakapasni rey David, caquilakalhámanti; quintzuma̱t mactanu̱ma ixespíritu tlajaná y snu̱n ma̱kxtakajní. ");
INSERT INTO topNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús ni̱ kálhti̱lh. Ixdiscípulos tama̱lacatzúhui̱lh y tahuánilh xlacata cama̱quilhácsli̱lh porque snu̱n ixma̱ktasi̱ma amá pusca̱t la̱ ixca̱ke̱sta̱lati̱lhá. ");
INSERT INTO topNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús tá̱yalh y huánilh: ―Dios quima̱lakacha̱ni̱t huata nacca̱lakma̱xtú tí talaktzanka̱ni̱t nac quimpu̱latama̱n Israel. ¡Ni̱ lá cmakta̱yayá̱n, huix ni̱ xalac Israel! ");
INSERT INTO topNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Acxni tuncán amá pusca̱t ma̱lacatzúhui̱lh Jesús, tatzokostánilh y huanipá: ―Quimpu̱chinacán, ni̱ snu̱n calat, ¡caquimakta̱ya! ");
INSERT INTO topNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","―Ni̱ tla̱n qui̱taxtú ca̱maklhti̱cán ixtahuajcán camaná̱n xalac Israel y ca̱ma̱xqui̱cán lactzú chichí. ");
INSERT INTO topNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","―Quimpu̱chinacán Jesús, xli̱ca̱na tú huana, pero hasta lactzú chichí tla̱n taquilhsacuá katxtakma ni̱ma̱ ni̱ talacasquín xapu̱chinaní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amá pusca̱t ixma̱kachakxi̱ni̱t la̱ ixkalhputzani̱t Jesús y huá chú li̱kalhtí̱nalh. Jesús lakáti̱lh y huanipá: ―Huix quili̱pa̱huani̱ta ixli̱hua̱k minacú y clacasquín cakantáxtulh tú quimáksquinti. Istzuma̱t amá pusca̱t pi̱huá amá quilhtamacú tuncán aksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús taxtupá amá pu̱latama̱n Tiro y Sidón y lactáspitli quilhtu̱tum chúchut xla Galilea y acxni cha̱lh lacatum talacá̱cxtulh nac aktum sipi y aná curucs tahui y tzúculh ca̱ma̱kalhchihui̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lhu̱hua ta̱tatlaní̱n ca̱li̱chinca xlacata naca̱ma̱ksa̱ní. Xlá ca̱ma̱ke̱nu̱niko̱lh ixta̱tatcán y ca̱ca̱xtláhualh tí ni̱ lá ixtatla̱huán, makaputu, lakatzi̱ní̱n, ko̱ko̱ní̱n, y lhu̱hua ma̱s ti̱pa̱katzi tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hua̱k tali̱pa̱xahuako̱lh tú ixta̱cxilhma̱na: ko̱ko tla̱n ixtachihui̱nán, lakatzí̱n tla̱n ixta̱cxila tú huí ca̱quilhtamacú, tí ixtala̱kalhi̱ni̱t nac ixmacxpa̱ncán tla̱n ixta̱ksa̱nán, tí ni̱ lá ixtatla̱huán tla̱n ixtaca̱xlá. Hua̱k tzúculh talakachixcuhuí Dios porque ixca̱cxilhlacacha̱ni̱t ixcamán tí xalac Israel. ");
INSERT INTO topNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús ca̱tasánilh ixdiscípulos y ca̱huánilh: ―Cca̱lakalhamán jaé cristianos porque kalhi̱yá aktutu chichiní la̱ta tachini̱t juú y ni̱ takalhí tú natali̱hua̱yán. Cpuhuán xacca̱ma̱lakacha̱lhá ixchiccán, pero ¿qué tal nata̱kuitita̱yá nac tijia? ");
INSERT INTO topNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","―Snu̱n lhu̱hua cristianos y juú ni̱tú tú li̱hua̱yancán, ¿nicu ixtiyáu tahuá tú naca̱li̱ma̱hui̱yá̱u? ―takálhti̱lh ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―¿Nicu macli̱t simi̱ta li̱taná̱tit? ―Mactujún simi̱ta y makapitzi lactzú tamakní. ―A ver caquila̱li̱miníu ―ca̱huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Astá̱n ca̱li̱ma̱páksi̱lh hua̱k cristianos curucs catatahuilako̱lh ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","La̱ maklhtí̱nalh amá simi̱ta y lactzú tamakní, pa̱xcatcatzí̱nilh Dios ixtahuá, ca̱lakchékelh y ca̱má̱xqui̱lh ixdiscípulos catama̱kpítzilh y catamá̱xqui̱lh la̱ta tí ixlacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hua̱k cristianos tla̱n takálhkasli y todavía kalhtá̱xtulh aktujún canasta simi̱ta y lactzú tamakní. ");
INSERT INTO topNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huata lacchixcuhuí̱n tahuá̱yalh cha̱ta̱ti mi̱lh aparte lacchaján y lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","La̱ tahua̱yanko̱lh ca̱huánilh cataalhá ixpu̱latama̱ncán. Xlá na̱ ca̱ta̱táju̱lh ixdiscípulos nac aktum barco y táalh pakán aktum pu̱latama̱n huanicán Magdala. ");
INSERT INTO topNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Makapitzi fariseos y ixma̱kalhtahuake̱nacán judíos ixtakalhputzaputún Jesús huá tali̱ma̱lacatzúhui̱lh y tahuánilh: ―Caquila̱li̱ma̱lacahua̱ní̱u aktum mintascújut nac akapú̱n para xli̱ca̱na Dios ma̱lakacha̱ni̱tán. ");
INSERT INTO topNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Xlá ca̱kálhti̱lh: ―¡Xli̱ca̱na ni̱ lacapuhuaná̱tit! Huixín tla̱n quilhchipiná̱tit acxni tla̱n ama huan quilhtamacú o ni̱ tla̱n ama huan. Para smalankán suanc huí akapú̱n huaná̱tit: “Cha̱lí tla̱n ama huan quilhtamacú.” ");
INSERT INTO topNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y para tzisa tatapuni̱t y snu̱n lhca̱cnán, huaná̱tit: “Chí ni̱ tla̱n ama huan quilhtamacú, ama min se̱n.” ¡Takalhí̱n lacchixcuhuí̱n chí como ni̱ acxcatzi̱yá̱tit tú ca̱li̱ma̱lacahua̱ni̱má̱n Dios jaé quilhtamacú! ");
INSERT INTO topNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ni̱ lá pa̱ti̱cán minkasatcán, snu̱n li̱xcájnit mintalacpuhua̱ncán huá ni̱ ca̱najlayá̱tit tú ctlahuá, tza̱pu quila̱maksquiná̱u cacca̱li̱ma̱lacahua̱ní̱n lanca quintascújut, y chí lacasquiná̱tit cactláhualh a̱ktum. Tó, ni̱ cama tlahuá y huata pa̱t li̱lacahua̱naná̱tit a̱stá̱n aktum tascújut la̱ amá ni̱ma̱ Dios titláhualh nac ixlatáma̱t profeta Jonás. La̱ ca̱ta̱chihui̱nanko̱lh jaé lacchixcuhuí̱n ca̱kxtakyá̱hualh y alh ixquilhtú̱n pupunú. ");
INSERT INTO topNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Acxni tácha̱lh ixa̱quilhtu̱tu chúchut ixdiscípulos tá̱cxilhli xlacata ni̱ ixtali̱ni̱t simi̱ta tú natali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús ca̱huánilh: ―Skálalh calatapá̱tit xlacata ni̱ naca̱pasayá̱n ixlevadurajcán fariseos y saduceos. ");
INSERT INTO topNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xlacán ni̱ tama̱kachákxi̱lh y tzúculh tara̱huaní: ―Quinca̱li̱huanimá̱n la̱ ni̱ li̱miná̱u simi̱ta. ");
INSERT INTO topNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús cátzi̱lh tú ixtaquilhuama̱na y ca̱huanipá: ―¿A poco puhuaná̱tit cca̱li̱huanimá̱n xlacata ni̱ li̱taná̱tit simi̱ta? ¡Huata mintahuajcán lacapa̱stacá̱tit! ¿Aquit nicu quila̱maca̱ná̱u? ");
INSERT INTO topNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Yaj aksaná̱tit tú cca̱li̱ma̱lacahua̱ni̱tán? Quila̱huaníu, acxni cca̱li̱má̱hui̱lh cha̱quitzis mi̱lh lacchixcuhuí̱n caj macquitzis simi̱ta, ¿ni̱ kalhtá̱xtulh lhu̱hua canastas? ");
INSERT INTO topNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Y acxni tali̱huá̱yalh cha̱ta̱ti mi̱lh lacchixcuhuí̱n caj mactujún simi̱ta, ¿na̱ ni̱ kalhtá̱xtulh lhu̱hua canastas simi̱ta? ");
INSERT INTO topNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿A poco xli̱ca̱na ni̱ ma̱kachakxi̱yá̱tit xlacata aquit ni̱ cli̱chihui̱nama simita acxni cca̱huanín skálalh calatapá̱tit ni̱ naca̱pasayá̱n ixlevadurajcán fariseos y saduceos? ");
INSERT INTO topNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ixdiscípulos tama̱kachakxi̱lhcú xlacata Jesús ixta̱ma̱lacastucni̱t levadura ni̱ lactlá̱n ixtakalhchihui̱ncán fariseos y saduceos, porque xlacán hua̱k akspitaj tama̱sí ixtachihui̱ncán y tí ca̱makslihueké na̱ talaktzanká. ");
INSERT INTO topNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesús ca̱tá̱alh ixdiscípulos nac aktum pu̱latama̱n huanicán Cesarea de Filipo, y aná ca̱kalasquínilh: ―¿Ticu quintali̱macá̱n cristianos aquit Xatalacsacni Chixcú? ");
INSERT INTO topNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Takálhti̱lh: ―Makapitzi tali̱maca̱ná̱n Juan Bautista, pu̱tum tali̱maca̱ná̱n profeta Elías, y tunuj tali̱maca̱ná̱n Jeremías, y tunuj tahuán huix cha̱tum tali̱pa̱u profeta la̱ ni̱ma̱ taqui̱lani̱tanchi xapu̱lh nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","―Y huixín, ¿ticu yá chixcú quila̱li̱maca̱ná̱u? ―ca̱kalasquínilh. ");
INSERT INTO topNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pedro kálhti̱lh: ―Huix Cristo Ixkahuasa Dios xastacnán tí mini̱t quinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Huánilh Jesús: ―¡Dios acxilhlacacha̱ni̱tán! Capa̱xahua porque tú acxcatzi̱ya ni̱ cha̱tum chixcú tí huanini̱tán sino que Quinti̱cú Dios ni̱ma̱ huí nac akapú̱n ma̱cxcatzi̱ni̱ni̱tán. ");
INSERT INTO topNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Huix Simón ixkahuasa Jonás, aquit cli̱ma̱pa̱cuhui̱yá̱n Pedro, huamputún chíhuix; ixakspú̱n aktum lanca chíhuix cama ma̱lacatzuquí tí naquintali̱pa̱huán; y tú aquit cma̱lacatzuquí ama ta̱yaní y ni̱ para ixpu̱chiná ca̱li̱ní̱n ama lactlahuá. ");
INSERT INTO topNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Aquit camá̱n macama̱xqui̱yá̱n xallave ixli̱lanca quintapáksi̱t ni̱ma̱ cma̱lacatzuqui̱ni̱t. Aquit cma̱lacnu̱niyá̱n xlacata tú huix nachi̱ya juú caquilhtamacú huá namá tú tachi̱ni̱t nahuán nac akapú̱n; y la̱ta tú huix naxucta juú ca̱quilhtamacú huá namá tú na̱ taxcutni̱t nahuán nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","La̱ ta̱chihui̱nanko̱lh Pedro, hua̱k ca̱li̱ma̱páksi̱lh ixdiscípulos ni̱ catali̱chihuí̱nalh para huá Cristo ixuani̱t tí ixama ca̱lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","La̱ta amá quilhtamacú Jesús tzúculh ca̱lacspi̱tní ixdiscípulos tú ixama pa̱xtoka. Ca̱huánilh la̱ ixama an nac Jerusalén, la̱ ixama talakmakán xalakko̱lún ma̱paksi̱naní̱n, xanapuxcun curas y xma̱kalhtahuake̱nacán judíos; hasta ixama tamakní, pero ixliaktutu chichiní ixama lacastacuanán nac ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","La̱ kaxmatko̱lh ixtachihuí̱n Pedro tá̱alh tziná lakamákat y huánilh: ―¿Hua̱nchi quila̱huaníu namá takalhchihuí̱n? Dios ni̱ lá li̱makxtaká̱n tú napa̱xtoka. Ni̱ cma̱tla̱ní tí namakni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesús talakáspitli pakán ní ixtahuila̱na xa̱makapitzi ixdiscípulos y huánilh Pedro: ―Catake̱nú ní cyá tlajaná, huix lacpuhuana la̱ xa̱makapitzi lacchixcuhuí̱n y ni̱ lacpuhuana tú laclhca̱ni̱t Dios quilacata. ");
INSERT INTO topNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Astá̱n ca̱huaniko̱lh ixdiscípulos: ―Amá tí quintakokeputún pu̱la ca̱ktzónksualh la̱ta tú kalhí y tú lakatí ca̱quilhtamacú, ni̱ cajicuánilh akxtakajnán caj quilacata, ¡a̱stá̱n caquintakókelh cani̱huá! ");
INSERT INTO topNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Amá tí makli̱huán lakma̱xtuputún ixli̱stacni ama makatzanká tú lakcatzán, pero tí ni̱ lakcatzán makatzanká ixli̱stacni caj quilacata namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Quila̱huaníu, ¿tucu li̱macuaní cha̱tum chixcú para ixkálhi̱lh lhu̱hua tumi̱n y lhu̱hua tíyat ca̱quilhtamacú, y a̱stá̱n laktzanká ixli̱stacni? ¿Puhuaná̱tit huixín cha̱tum cristiano a̱stá̱n tla̱n ma̱lacnu̱ní Dios ixtumi̱n xlacata nalakma̱xtú ixli̱stacni y ni̱ naxoko̱nán? ");
INSERT INTO topNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Ama cha̱n quilhtamacú acxni cama ca̱ma̱si̱niyá̱n ixli̱tlihueke ni̱ma̱ quima̱xqui̱ni̱t Quinti̱cú; aquit Xatalacsacni Chixcú cama ca̱ta̱mín hua̱k ángeles xlacata nacca̱ta̱tlahuá taxokó̱n hua̱k cristianos y cha̱tunu cama ma̱xoko̱ní tú tlahuani̱t nac ixlatáma̱t. ");
INSERT INTO topNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Xli̱ca̱na cca̱huaniyá̱n, makapitzi tí talaya̱na juú ya̱ taní nahuán acxni xlacán ama quinta̱cxila nacmín ma̱paksi̱nán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ixliakcha̱xán chichiní a̱stá̱n Jesús talacá̱cxtulh aktum lanca sipi huata ca̱tá̱alh cha̱tutu ixdiscípulos, Pedro, Jacobo y ixta̱cam Juan. ");
INSERT INTO topNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nac ixlacati̱ncán ixdiscípulos xlá tzúculh tapalaja la̱ ixtasí siempre. Ixlacán ixlakaskoy la̱ lakaskoy chichiní; ixlháka̱t snapapa lako̱lh, ¡slipua ixtasí! ");
INSERT INTO topNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y talákchilh Moisés y profeta Elías y tzúculh tata̱chihui̱nán (jaé lacchixcuhuí̱n maká̱n ixtalatama̱ni̱t). ");
INSERT INTO topNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pedro la̱ta ixpa̱xahuani̱t kalhchiyá̱nalh y huánilh Jesús: ―Quimpu̱chinacán Jesús, juú tla̱n ixtamakxtakui; y para lacasquina xactlahuáu aktutu chiqui, aktum milá, aktum xla Moisés y xa̱ktum xla Elías. ");
INSERT INTO topNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro ixchihui̱namajcú acxni tá̱ctalh aktum staranka y slipua puclhni nac ixítat ca̱ta̱yánilh, y takaxmáti̱lh jaé tachihuí̱n: ―Jaé Quinkahuasa snu̱n clakalhamán y cli̱pa̱xahuá la̱ ckalhí. ¡Cakaxpáttit tú ca̱li̱ma̱paksi̱yá̱n! ");
INSERT INTO topNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pedro, Jacobo y Juan tajicuanko̱lh, tuncán tatatzokóstalh hasta tatalacátalh ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesús ca̱ma̱lacatzúhui̱lh, ca̱lí̱toklhli ixmacán, y ca̱huánilh: ―Ni̱ cajicuántit; cata̱yátit. ");
INSERT INTO topNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Xlacán tatá̱yalh y talacapútzalh tí ixtata̱chui̱nani̱t Jesús, pero ni̱tí tá̱cxilhli hasta Jesús ixacstu ixyá. ");
INSERT INTO topNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Xlá tzúculh ca̱ta̱talaca̱ctá, y ca̱li̱ma̱páksi̱lh: ―Tú huixín acxílhtit ni̱tí cali̱ma̱kalhchihui̱ní̱tit, tla̱n nahuaná̱tit hasta acxni aquit Xtalacsacni Chixcú naclacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Amá cha̱tuy ixdiscípulos takalasquínilh: ―¿Hua̱nchi tí tama̱sí ixtachihuí̱n Dios ni̱ma̱ tatzokni̱t nac Escrituras tahuán xlacata antes namín Cristo profeta Elías ama pu̱laní? ");
INSERT INTO topNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Xlá ca̱kálhti̱lh: ―Xlacán tancs tachihuí̱nalh ni̱ ta̱ktzanka̱ni̱t pues Elías pu̱la ama min ca̱ma̱tancsaní ixtalacapa̱stacnicán cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero aquit cca̱huaniyá̱n Elías qui̱lachitá ca̱quilhtamacú y cristianos ni̱ taca̱nájlalh Dios ixma̱lakacha̱ni̱t y tama̱kxtakájni̱lh; aquit na̱ chuná cama akxtakajnán ixmacancán pues xlacán lacsnú̱n talani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","La̱ ca̱lacspi̱tniko̱lh ixtachihuí̱n ixdiscípulos tama̱kachákxi̱lh xlacata ixca̱li̱ta̱chihui̱nani̱t Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ixli̱puntzú tácha̱lh ní ixtahuila̱na xa̱makapitzi ixdiscípulos, lhu̱hua cristianos ixtalaya̱na aná. Cha̱tum chixcú ma̱lacatzúhui̱lh, tatzokostánilh, y huánilh: ");
INSERT INTO topNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Quimpu̱chinacán Jesús, cama̱ksa̱ni quinkahuasa; xlá staka̱ní y snu̱n akxtakajnán pues catunu tama̱ya̱chá nac chúchut o nac lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cca̱huánilh midiscípulos catama̱ksá̱ni̱lh pero xlacán ni̱ lá taca̱xtláhualh. ");
INSERT INTO topNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Xlá acs ca̱laca̱niko̱lh cristianos y ca̱huánilh: ―¡Koxitaní̱n huixín takalhí̱n cristianos tí ni̱tú ca̱najlayá̱tit! ¿Hasta xnicu camá̱n ca̱ta̱latama̱yá̱n y ca̱pa̱ti̱niyá̱n minkasatcán? A ver quila̱li̱miníu namá kahuasa. ");
INSERT INTO topNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesús li̱ma̱páksi̱lh camactáxtulh amá kahuasa ixespíritu tlajaná ni̱ma̱ ixmakatlajani̱t, y la̱ táxtulh xlá tuncán aksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Astá̱n ixdiscípulos tze̱k takalasquínilh: ―¿Hua̱nchi aquín ni̱ lá cmacma̱xtúu namá kahuasa ixespíritu tlajaná? ");
INSERT INTO topNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ca̱kálhti̱lh Jesús: ―Huixín ni̱ kalhi̱yá̱tit li̱tlihueke nac mintalacapa̱stacnicán tancs li̱pa̱huaná̱tit Dios. Para huixín ixca̱najlátit ixli̱hua̱k mintapuhua̱ncán Dios ama tlahuá tú maksquiná̱tit ma̱squi caj la̱ actzú ixtalhtzi tachaná̱n tú nastaca, tla̱n ixuanítit jaé sipi: “Catake̱nu juú y capit a̱lacatunu”, namá sipi xli̱ca̱na ixtaké̱nu̱lh, y la̱ta tú tlahuaputuná̱tit para tancs ixli̱pa̱huántit Dios y aktum ixuilí̱tit mintalacapa̱stacnicán, ni̱ tuhua ixkantáxtulh tú lacpuhuaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Xa̱huá jaé xta̱lá tlajananí̱n ni̱ lá ca̱tamacxtucán para ni̱ tza̱pu kalhtahuakanicán Dios y nakatxtaknancán. ");
INSERT INTO topNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Maktum la̱ta ixtalapu̱lajcú nac Galilea, ca̱huánilh ixdiscípulos: ―Aquit Xatalacsacni Chixcú huí tí ama quiliakskahuinán y ama quimacama̱stá ixmacancán tí quintasi̱tzi̱ní. ");
INSERT INTO topNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xlacán ama quintamakní, pero ixliaktutu chichiní aquit cama lacastacuanán. Ixdiscípulos acxni ixca̱li̱ta̱chihui̱nán la̱ ixama̱ca makni̱cán snu̱n ixtalakaputzá. ");
INSERT INTO topNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús ca̱tá̱cha̱lh ixdiscípulos nac Capernaum y aná cha̱tum tí ixma̱qui̱tapu̱lí limosna xalac pu̱siculan huánilh Pedro: ―Mimaestrojcán, ¿ni̱ ama lakaxoko̱nán nac lanca pu̱siculan xla Jerusalén? ―Como chí na̱ ama lakaxoko̱nán ―kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Entonces Pedro alh acxila Jesús nac ákxtaka ní ixtalama̱na, pero antes nata̱chihui̱nán xlá ixcatzi̱yá, y huánilh: ―Pedro, laclanca reyes xala ca̱quilhtamacú, ¿ticu tama̱lakaxoké tumi̱n? Quihuani, ¿tama̱lakaxoké tí tama̱paksí, o tama̱lakaxoké ixli̱talakapasni? ");
INSERT INTO topNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Ca̱ma̱lakaxoke̱cán tí ca̱ma̱paksi̱cán ―kálhti̱lh Pedro. ―Ixli̱talakapasnicán tu̱calh ni̱ tama̱lakaxoké. ");
INSERT INTO topNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero xlacata ni̱ naquinca̱li̱huanicaná̱n chí tuncán capit nac pupunú, camuju aktum anzuelo, y xla̱huán tamakní ni̱ma̱ tahuacá cama̱cutu. Pa̱t taka̱sa nac ixquilhni mactum tumi̱n, ama acchá̱n nali̱lakaxokoya tumi̱n xalac pu̱siculan quilacata y milacata. ");
INSERT INTO topNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maktum tunuj quilhtamacú ixdiscípulos Jesús tama̱lacatzúhui̱lh y takalasquínilh xlacata la̱ta ixli̱hua̱kcán ticu ma̱s tali̱pa̱u ixama huan nac ixtapáksi̱t ni̱ma̱ ixama ma̱lacatzuquí ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Xlá tasánilh cha̱tum actzú kahuasa, yá̱hualh nac ixíta̱t, ");
INSERT INTO topNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","y chuné tzúculh ca̱ma̱kalhchihui̱ní: ―Tancs cca̱huaniyá̱n, nac quintapáksi̱t ni̱ lá pa̱t tanu̱yá̱tit para ni̱ lakxta̱pali̱yá̱tit minkasatcán y makslihuekeyá̱tit la̱ jaé actzú kahuasa. ");
INSERT INTO topNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jaé qui̱taxtú, tí ni̱ lactlancán la̱ jaé cha̱tum actzú kahuasa, xli̱ca̱na lanca ama huan nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chí cca̱huaniyá̱n, amá tí lakalhamán cha̱tum actzú kahuasa la̱ jaé porque catzí aquit clakalhamán la̱ aquit caquilakalhámalh. ");
INSERT INTO topNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Cati̱huá cristiano tí ca̱ma̱tunujní y ca̱ma̱laktzanke̱ní ixtalacapa̱stacnicán jaé lactzú camán tí tatzucuni̱t quintali̱pa̱huán, ma̱s ixmacuánilh ixpixchi̱huacaca aktum lanca chíhuix ixmaca̱nca nac pupunú xlacata namu̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Li̱lakaputza latama̱cán ca̱quilhtamacú porque la̱ta tú anán hua̱k tla̱n li̱laktzanka̱cán; siempre chú lama nahuán, pero ma̱s li̱lakaputza tú ama pa̱xtoka tí ma̱lacatzuquí tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Huá cca̱li̱ma̱paksi̱yá̱n, para mintujún o mimacán makta̱yayá̱n natlahuaya tala̱kalhí̱n ixlacatí̱n Dios ma̱s macuaniyá̱n cachúcu̱cti y camákanti mákat pues ma̱s tla̱n nachipina nac akapú̱n tantu̱putu o makaputu, y ni̱ la̱ta katzi̱ya namacapincana nac puakxtakajni. ");
INSERT INTO topNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Para milakastapu ma̱tlahui̱yá̱n tala̱kalhí̱n y ma̱laktzanke̱yá̱n ma̱s macuaniyá̱n cama̱xtu y catramákanti mákat pues ma̱s tla̱n nachipina nac akapú̱n con akstum milakastapu y ni la̱ta katzi̱ya natamacapincana nac puakxtakajni. ");
INSERT INTO topNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Huixín ni̱cxni caca̱lakmakántit jaé ni̱ lactali̱pa̱u cristianos tí quintali̱pa̱huán; porque tancs cca̱huaniyá̱n, nac akapú̱n cha̱tunu takalhí cha̱tum ángel tí tata̱chihui̱nán Dios la̱ nataakskalhlí̱n ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Xa̱huá aquit Xtalacsacni Chixcú cmini̱t ca̱lakma̱xtú tí ixtalaktzanka̱ni̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’Para cha̱tum chixcú ca̱kalhí aktum ciento ixborregos y maktum makatzanká tantum, quila̱huaníu, ¿a poco ni̱ ca̱makxtaka lacatum amá noventa y nueve ixborregos y an lacaputzá nac ca̱lacsipijni amá tantum ni̱ma̱ tzanka̱ni̱t? ");
INSERT INTO topNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Cati̱huá chuná jaé lá, y acxni qui̱taka̱sa amá tancstum ixborrego ma̱s li̱pa̱xahuá porque tási̱lh ni̱ma̱ istzanka̱ni̱t, y xa̱makapitzi como ni̱ tatzánka̱lh ni̱ snu̱n ca̱li̱puhuán. ");
INSERT INTO topNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aquit cca̱ta̱ma̱lacastucnín jaé borregos con cristianos porque Quinti̱cú xalac akapú̱n ni̱ lacasquín natalaktzanká jaé tí la̱ lactzú camán quintali̱pa̱huani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Para cha̱tum minta̱cristiano ta̱ra̱slaká̱n y tlahuaniyá̱n tú ni̱ tla̱n, tze̱k catasani y cahuani xlacata aktzanka̱ni̱t ni̱ tla̱n tú tlahuani̱t; para ta̱lacca̱xlayá̱n namá minta̱cristiano siempre ama ta̱ra̱li̱ná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Para ni̱ kaxmatniyá̱n la̱ ta̱lacca̱xlaputuna, caca̱ta̱pi a̱cha̱tum o cha̱tuy lacchixcuhuí̱n xlacata xlacán natama̱luloka tancs ma̱kalhchihui̱ni pero xlá ni̱ kaxmatputún. ");
INSERT INTO topNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Para la̱tiyá ni̱ tati̱tumi̱putún cama̱lacapu ixlacati̱ncán minata̱camán tí tatamakstoka natalakachixcuhuí Dios xlacata xlacán natama̱kalhchihui̱ní. Y para na̱ ni̱ ca̱kaxmatní cali̱macapítit la̱ cha̱tum chixcú tí ni̱ li̱pa̱huán Dios, o la̱ cha̱tum tí laktzanka̱ni̱t porque snu̱n lani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Cakaxpáttit tú tancs cca̱ma̱lacnu̱niyá̱n: Hua̱k tú huixín ni̱ naca̱li̱makxtaká̱tit tatlahuá cristianos juú ca̱quilhtamacú huá namá tú na̱ ni̱ ca̱li̱makxtakcani̱t tatlahuá nac akapú̱n; y la̱ta tú huixín naca̱li̱makxtaká̱tit tatlahuá cristianos juú ca̱quilhtamacú huá namá tú na̱ ca̱li̱makxtakcani̱t tatlahuá nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Na̱ cca̱huaniyá̱n, para cha̱tuy cristianos aktum tahuilí ixtapuhua̱ncán, y tú tamaclacasquín acxtum tali̱kalhtahuakaní Dios, aquit cca̱ma̱lacnu̱niyá̱n xlacata Quinti̱cú xalac akapú̱n ama ca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porque para cha̱tuy o cha̱tutu cristianos quintali̱pa̱huán y lacatum tatamakstoka xlacata naquintakalhtahuakaní, aquit cama kaxmata nac ixíta̱t cama tahuilá. ");
INSERT INTO topNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pedro kalasquínilh: ―Quimpu̱chinacán, ¿nicu makli̱t mini̱ní nacma̱tzanke̱naní quinta̱cristiano acxni quinta̱ra̱slaka y quintlahuaní tú ni̱ tla̱n? Aquit cpuhuán maktujún tla̱n cma̱tzanke̱naní. ");
INSERT INTO topNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kálhti̱lh: ―¡Tó! Aquit cuaniyá̱n cama̱tzanke̱nani minta̱cristiano ni̱ caj maktujún, para ixta̱ra̱slakni makquitzis ciento ixlacata huix cama̱tzanke̱nani para tamaclacasquiní. ");
INSERT INTO topNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Huá xlacata, quintapáksi̱t ni̱ma̱ cma̱lacatzuqui̱ni̱t cama ta̱ma̱lacastuca cha̱tum rey ni̱ma̱ ca̱ta̱tlahuá taxokó̱n hua̱k tí ixtata̱ma̱paksi̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Acxni tzúculh ca̱ta̱tlahuá taxokó̱n chilh cha̱tum tí ixli̱ní lhu̱hua, pero lhu̱hua tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Xlá ni̱ lá xokónilh tú ixli̱ní amá rey, huá li̱ma̱paksí̱nalh caca̱sta̱ko̱ca amá chixcú, ixta̱cha̱t, ixcamán y la̱ta tú ixkalhí xlacata nalakma̱xtú ixtumi̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Xlá tatzokostánilh rey y ca̱li̱tlá̱n tzúculh huaní: “Señor, catlahua li̱tlá̱n caquili̱kalhi a̱laktzú; aquit nacxokoniyá̱n hua̱k mintumi̱n, pero ni̱ caquila̱stá̱u.” ");
INSERT INTO topNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Amá rey lakalhámalh, li̱mákxtakli y ma̱tzanke̱nánilh la̱ta tú ixli̱ní. ");
INSERT INTO topNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Xlá táxtulh, pero nac tijia taka̱stá̱yalh cha̱tum chixcú tí na̱ ixli̱ní tumi̱n; acxni ácxilhli spim li̱kósnalh y ca̱tasi̱tzi huánilh: “Chí tuncán caquixokoni aktum ciento peso ni̱ma quili̱piniya o pa̱t lakapasa ticu aquit.” ");
INSERT INTO topNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Xa̱cha̱tum chixcú tatzokostánilh y ca̱li̱tlá̱n huánilh: “Catlahua li̱tlá̱n, caquili̱kalhi a̱laktzú, aquit nacxokoniyá̱n hua̱k mintumi̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amá chixcú ni̱ caso tláhualh y tuncán ma̱ma̱nu̱ní̱nalh nac pu̱la̱chí̱n xlacata naxokonicán hua̱k ixtumi̱n ni̱ma̱ ixli̱nicán. ");
INSERT INTO topNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Xa̱makapitzi ixcompañeros acxni tacátzi̱lh tú ixtlahuani̱t amá chixcú tasí̱tzi̱lh y talakapútzalh, taalh tali̱ta̱chihui̱nán amá rey tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Xlá lacapala ma̱tasani̱ní̱nalh amá chixcú tí ixma̱tzanke̱nanini̱t tú ixli̱ní, y chuné lacaquílhni̱lh: “¡Takalhí̱n chixcú, huix ni̱ mini̱niyá̱n nalatapa̱ya! Aquit cma̱tzanke̱nanín la̱ta tú ixquili̱piniya porque ca̱li̱tlá̱n quihuani caclakalhamán, ");
INSERT INTO topNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","y ¿cómo chí huix ni̱ lá ma̱tzanke̱nani minta̱cristiano tí ixli̱niyá̱n li̱ctá tumi̱n?” ");
INSERT INTO topNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Amá rey snu̱n sí̱tzi̱lh y li̱ma̱paksí̱nalh caca̱stigartlahuaca amá chixcú xlacata naxoko̱nán hua̱k tú ixtlahuani̱t y tú ixlí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús ca̱huaniko̱lh ixdiscípulos: ―Quinti̱cú xalac akapú̱n na̱ chuná ama ca̱ma̱xoko̱ni̱yá̱n para huixín ni̱ ca̱ma̱tzanke̱naniyá̱tit minta̱cristianos ixli̱hua̱k minacujcán tú ni̱ tla̱n ca̱tlahuaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","La̱ ca̱ta̱chihui̱nanko̱lh Jesús táxtulh nac Galilea y alh ixa̱quilhtu̱tu kalhtu̱choko Jordán nac aktum pu̱latama̱n tú ma̱paksí Judea. ");
INSERT INTO topNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Aná ca̱ma̱ksá̱ni̱lh lhu̱hua ta̱tatlaní̱n pues lhu̱hua cristianos ixtatakoké. ");
INSERT INTO topNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Maktum makapitzi fariseos tali̱kalhpútzalh ixtachihuí̱n xlacata nahuán tú natali̱ma̱laktzanké, takalasquínilh: ―¿Puhuana tla̱n qui̱taxtú para cha̱tum chixcú makxtaka ixta̱cha̱t ma̱squi ni̱ lanca tú la̱makasi̱tzi̱ni̱t? ");
INSERT INTO topNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Xlá ca̱kálhti̱lh: ―¿A poco ni̱ li̱kalhtahuakayá̱tit Escrituras? Aná huan xlacata la̱ta tilacatzúculh ca̱quilhtamacú Dios tláhualh cha̱tum chixcú y cha̱tum pusca̱t; ");
INSERT INTO topNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","y li̱ma̱paksí̱nalh xlacata cha̱tum kahuasa tla̱n akxtakmakán ixti̱cú ixna̱na y nata̱talakxtumí ixta̱cha̱t y nata̱latamá cani̱cxnihuá. ");
INSERT INTO topNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","La̱ta ya̱ ixtatamakaxtoka ixcha̱tuycán ixtahuani̱t, pero acxni tatamakxtoka la̱ cha̱tum tahuán y yaj ixcha̱tuycán. Huá cca̱li̱huaniyá̱n ni̱ huí cristiano tí mini̱ní nama̱pitzí tú ma̱lakxtumi̱ni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","―Entonces ¿hua̱nchi Moisés huan xlacata cha̱tum chixcú tla̱n makxtaka ixta̱cha̱t para ma̱xquí aktum cápsnat tla̱n xaca̱xlán ixlacatí̱n pu̱ma̱paksí̱n? ―takalasquínilh. ");
INSERT INTO topNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Xlá ca̱kálhti̱lh: ―Moisés ma̱tlá̱ni̱lh natara̱makxtaka tí tatamakaxtokni̱t porque huixín li̱xcájnit minkasatcán y ni̱tú kaxpatá̱tit; pero Dios ni̱cxni lacasquini̱t catara̱mákxtakli tí tatamakaxtokni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Aquit cca̱huaniyá̱n, para cha̱tum chixcú makxtaka ixta̱cha̱t ma̱squi ni̱ kalhí tunu chixcú, y xlá ta̱tamakaxtoka tunuj pusca̱t, tlahuá quilhmactuy tala̱kalhí̱n porque na̱ ma̱tlahuí tala̱kalhí̱n ixlacatí̱n Dios amá chixcú tí ta̱tahuilá ixpusca̱t ni̱ma̱ makxtakni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ixdiscípulos tahuánilh: ―Para chuná jaé ixli̱kálhi̱t ixpusca̱t cha̱tum chixcú, ma̱s tla̱n ni̱ tamakaxtokcán. ");
INSERT INTO topNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús ca̱kálhti̱lh: ―Pero ni̱ hua̱k ca̱mini̱ní ni̱ natatamakaxtoka, huata tama̱kachakxí tí ca̱lacsacni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Xa̱huá nac ca̱quilhtamacú talama̱na cristianos tí la̱ta titalakáhualh ni̱ lá tatamakaxtoka, y tunu ixta̱cristianos tala̱kalhi̱ni̱t ixmacnicán y yaj lá tatamakaxtoka, y makapitzi ni̱ tatamakaxtoka porque tamacama̱xquí Dios ixlatama̱tcán xlacata huata huá natamacuaní. Tí ma̱tla̱ní latamá la̱ cca̱huanín, catláhualh. ");
INSERT INTO topNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ana ní ixuí Jesús táchilh makapitzi cristianos ixtali̱mín ixcamancán xlacata naca̱mu̱sicuna̱tlahuá y naca̱li̱kalhtahuaká ixlacatí̱n Dios. Pero ixdiscípulos tzúculh tahuán: ―Ni̱ ca̱kaxculítit Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Xlá ca̱káxmatli y ca̱huánilh: ―Tó, ni̱ quinta̱kaxculí; caca̱li̱makxtáktit caquintalákmilh namá lactzú camán, porque nac ixtapáksi̱t Dios lacasquín catatánu̱lh cristianos tí tama̱tla̱ní talatamá la̱ jaé lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Astá̱n Jesús ca̱li̱mu̱sicuna̱tláhualh ixmacán. Astá̱n táxtulh amá pu̱latama̱n y alh a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Maktum cha̱tum kahuasa kalasquínilh Jesús: ―Maestro, huix tla̱n catzi̱ya, ¿niculá quili̱latáma̱t xlacata naclakma̱xtú quili̱stacni nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kálhti̱lh Jesús: ―¿Hua̱nchi quili̱ma̱tla̱ni̱ya mintachihuí̱n? Huata Dios tla̱n catzí. Chí cama kalhti̱yá̱n tú quinkalasquini, para lakma̱xtuputuna mili̱stacni nac akapú̱n catlahua nac milatáma̱t hua̱k ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―¿Neje yá ixtapáksi̱t? ―kalhtí̱nalh. Jesús huánilh: ―Ni̱ camakní̱nanti; ni̱ cakalhá̱nanti; ni̱tí caliakskahuínanti; ni̱ calakámaklhti ixta̱cha̱t minta̱chixcú; ");
INSERT INTO topNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","caca̱lakalhámanti minati̱cún; y caca̱lakalhámanti minati̱cún; y caca̱lakalhámanti minta̱cristiano na̱ chuná la̱ huix lacasquina calakalhamanca. ");
INSERT INTO topNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―La̱ta namá tú quihuani hua̱k cma̱kantaxti̱ni̱t la̱ta quili̱ctzú ―kalhtí̱nalh amá kahuasa―. Pero quihuani, ¿tucu quintzanka̱ní quili̱tláhuat? ");
INSERT INTO topNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","―Para xli̱ca̱na ―huanipá Jesús― tancs chipimputuna nac akapú̱n catlahua tú cama li̱ma̱paksi̱yá̱n, casta̱t la̱ta tú kalhi̱ya, caca̱ma̱xqui pobres, a̱stá̱n naquilaktana y naquintakokeya. Para tlahuaya tú cuanimá̱n pa̱t li̱kalhi̱cana mimpu̱táhui̱lh nac akapú̱n, pa̱t tlajaya li̱pa̱xáu milatáma̱t. ");
INSERT INTO topNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","La̱ kaxmatko̱lh ixtachihuí̱n Jesús lakaputzako̱lh porque snu̱n rico ixuani̱t; yaj para tú huá alh nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Xlá ca̱huánilh ixdiscípulos: ―¡Xli̱ca̱na snu̱n tuhua ca̱huani̱ní ricos tama̱tla̱ní la̱ ma̱lacnú Dios ma̱paksi̱namputún nac ixlatama̱tcán! ");
INSERT INTO topNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cca̱huaniparayá̱n xlacata ma̱s ni̱ tuhua tanú tantum camello nac istzán kantum li̱xtokon que para cha̱tum rico natanú nac ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ixdiscípulos tali̱puhuanko̱lh tú ca̱huánilh Jesús, y takalasquínilh: ―Para chú ama qui̱taxtú, ¿ticu tancs ama lakma̱xtú ixli̱stacni nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús acs ca̱lacá̱cxilhli y ca̱kálhti̱lh: ―Para cha̱tum chixcú ixacstu li̱tanú nata̱yaní nalakma̱xtú ixli̱stacni, ¡ni̱ lá ama tlahuá! Pero Dios hua̱k tla̱n tlahuá tú lacasquín. ");
INSERT INTO topNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro na̱ kalasquínilh: ―Quimpu̱chinacán, aquín cakxtakmakani̱táu la̱ta tú xackalhi̱yá̱u y ctakokeni̱táu cani̱huá. Quila̱huaníu, ¿tucu yá taxokó̱n ama quinca̱ma̱xqui̱caná̱n? ");
INSERT INTO topNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús ca̱kálhti̱lh: ―Tancs cca̱ma̱lacnu̱niyá̱n, acxni ama cha̱n quilhtamacú hua̱k cristianos puru lacsa̱sti y lactlá̱n talacapa̱stacni ama takalhí y aquit Xatalacsacni Chixcú cama tahuilá nac quimpu̱ma̱paksi̱n, cha̱tunu huixín quidiscípulos na̱ pa̱t tahuilayá̱tit nac mimpu̱ma̱paksi̱ncán xlacata naca̱ta̱tlahuayá̱tit taxokó̱n pu̱cu̱tuy cristianos tí tama̱lacatzúqui̱lh pu̱latama̱n Israel. ");
INSERT INTO topNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Cati̱huá tí caj quilacata akxtakmakán ixchic, ixnata̱camán, ixnati̱cún, ixcamán, ixca̱quihuí̱n y huata aquit quimacuaní, cma̱lacnu̱ní ama maklhti̱nán aktum ciento ixlacata li̱huacá la̱ta tú ixkalhí xapu̱lh, y nac akapú̱n ama maklhti̱nán li̱pa̱xáu latáma̱t. ");
INSERT INTO topNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amá quilhtamacú lhu̱hua cristianos tí ca̱lakmakancán juú ca̱quilhtamacú ixpakstá̱n ca̱maca̱ncán, aná pu̱la ama̱ca ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán; y na̱ chuná lhu̱hua tí ca̱ma̱pu̱li̱cán juú ca̱quilhtamacú pu̱la ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán, aná ixpakstá̱n ama̱ca ca̱maca̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Acxni nacmín ca̱ta̱tlahuá taxokó̱n tí tatanu̱ni̱t nac quintapáksi̱t ni̱ma̱ cma̱lacatzuqui̱ni̱t ca̱quilhtamacú, cama ca̱ta̱ma̱lacastucniyá̱n ixpu̱chiná aktum lanca ca̱tucuxtu. ");
INSERT INTO topNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xlá tzisa táxtulh ca̱putzá tasa̱cua tí nataxka̱nán. Tí xla̱huán ca̱táka̱sli ca̱ta̱laccá̱xlalh naca̱xokoní mactum denario tumi̱n aktum chichiní. ");
INSERT INTO topNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ma̱x como a las nueve cá̱cxilhli makapitzi lacchixcuhuí̱n ni̱ ixtakalhí ixtascújut chu̱ta ixtalahuila̱na nac li̱tamá̱u. ");
INSERT INTO topNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xlá ca̱ta̱laccá̱xlalh naca̱xokoní ixtascujutcán para nataxka̱nán, y na̱ ca̱ma̱lakácha̱lh nac ixca̱tucuxtu. ");
INSERT INTO topNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lacatzú tastúnut ca̱taka̱spá tasa̱cua y na̱ ca̱ma̱lakácha̱lh ixca̱tucuxtu; y como aktutu hora ixli̱smalankán chuná li̱tum ca̱ma̱lakacha̱pá makapitzi tasa̱cua. ");
INSERT INTO topNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xalakasmalankán como a las cinco ampá nac li̱tamá̱u y ca̱cxilhpá makapitzi chu̱ta ixtalahuila̱na y xlá ca̱huanipá: “¿Hua̱nchi ni̱ scujpa̱nántit jaé chichiní?” ");
INSERT INTO topNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Xlacán takálhti̱lh: “Porque ni̱tí quinca̱ma̱xqui̱ni̱tán tascújut.” “Para xli̱ca̱na scujputuná̱tit, chí tuncán capítit nac quinca̱tucuxtu, nacca̱xokoniyá̱n tú mili̱tlajatcán”, ca̱huánilh amá patrón. ");
INSERT INTO topNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","9","Acxni tascujko̱lh tzúculh tapaklhtu̱tá, amá tí ixacpuxcún tascújut tzúculh ca̱ma̱xquí cha̱tunu tasa̱cua ixtaskaucán, pero pu̱la ca̱xokónilh tí táchilh a las cinco de la tarde y ca̱má̱xqui̱lh mactum denario tumi̱n pues chú li̱ma̱páksi̱lh ixpatrón aktum chichiní ixlacata. ");
INSERT INTO topNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Acxni ca̱xokonica tí ixtatzucuni̱t tascuja lacatzisa xlacán ixtapuhuán ma̱s ixama̱ca ca̱ma̱skahui̱cán, pero na̱ ca̱ma̱xqui̱ca mactum denario huatiyá. ");
INSERT INTO topNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Acxni tamaklhtí̱nalh ixtaskaucán tzúculh tali̱chihui̱nán amá xapu̱chiná xlacata hua̱nchi chú ixca̱tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Cha̱tum tasa̱cua huánilh amá patrón: “Jaé lacchixcuhuí̱n táchilh a las cinco y huata táscujli aktum hora huix ca̱xokoni̱ta na̱ chuná la̱ ctlajani̱táu aquín y aquín ta̱lakó̱u chichiní tantacú.” ");
INSERT INTO topNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amá patrón kálhti̱lh tí ni̱ ixma̱tla̱ni̱ni̱t la̱ ca̱xokónilh: “Amigo, aquit ni̱ cakskahuini̱tán pues cta̱lacca̱xlán cama xokoniyá̱n mactum denario tumi̱n aktum chichiní mintascújut. ");
INSERT INTO topNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Camaklhtí̱nanti mintaskáu y ni̱ casi̱tzi. Huix ni̱ mincuenta para acxtum cca̱xokoniputún quintasa̱cua, ");
INSERT INTO topNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","pues quintumi̱n aquit cma̱paksí y tla̱n cli̱tlahuá tú clacasquín. ¿A poco lakcatzana acxtum cca̱lakalhámalh cristianos?” ");
INSERT INTO topNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","La̱ takaxmatko̱lh jaé takalhchihuí̱n Jesús ca̱huanipá: ―Dios quilhpa̱xtum ca̱lakalhamán hua̱k tí tama̱tla̱ní tatanú nac ixtapáksi̱t; huá cca̱li̱huaniyá̱n, lhu̱hua tí pu̱la tatanu̱ni̱t ixpakstá̱n ama ca̱maca̱ncán, y tí a̱stá̱n tatanu̱ni̱t pu̱la ama ca̱ma̱xqui̱cán tú ca̱ma̱lacnu̱nicani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús ixchipani̱ttá tijia a̱huatiyá ti̱huán ixama nac Jerusalén acxni tze̱k cá̱li̱lh ixdiscípulos lacatum y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Huixín catzi̱yá̱tit ama̱náu pakán nac Jerusalén ana ní ama̱ca quimacama̱sta̱cán ixmacancán xanapuxcun curas y ixma̱kalhtahuake̱nacán judíos; xlacán ama quintali̱lhcá naquimakni̱cán, ");
INSERT INTO topNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","y amá quintamacama̱stá ixmacancán xanapuxcun ma̱paksi̱naní̱n romanos; xlacán ama quintali̱chiyá, quintasnoka, y quintamakní nac culu̱s; pero ixliaktutu chichiní a̱stá̱n cama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ixta̱cha̱t Zebedeo ca̱ta̱talacatzúhui̱lh ní ixyá Jesús cha̱tuy ixlakkahuasán Jacobo y Juan; huí tú ca̱li̱tlá̱n ixmaksquimputún y tatzokostánilh ixlacatí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","―¿Tucu lacasquina? ―kalasquínilh Jesús. ―Aquit clacasquín xlacata acxni natzucuya ma̱paksi̱nana, cha̱tunu quilakkahuasán natatahuilá nac mimpa̱xtú̱n xlacata natata̱ma̱paksi̱naná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","―Huix ni̱ catzi̱ya tú ca̱ta̱squímpa̱t milakkahuasán ―kalhtí̱nalh. Entonces Jesús ca̱lacá̱nilh amá cha̱tuy ixdiscípulos y ca̱kalasquínilh: ―¿Puhuaná̱tit tla̱n nata̱layá̱tit nakotá̱tit amá xu̱n chúchut xla ta̱kxtakajni ni̱ma̱ ama̱ca quima̱koti̱cán? ¿Na̱ tla̱n nata̱layá̱tit nac mimacnicán amá ta̱kxtakajni ni̱ma̱ cama macpa̱tí aquit? ―Tla̱n nacta̱yaniyá̱u ―takálhti̱lh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús ca̱huanipá: ―Pues xli̱ca̱na na̱ pa̱t kotá̱tit amá xu̱n chúchut ni̱ma̱ ama̱ca quima̱koti̱cán, y na̱ pa̱t macpa̱ti̱yá̱tit ta̱kxtakajni ni̱ma̱ ama̱ca quili̱cxilhcán, pero aquit ni̱ lá cca̱macama̱xqui̱yá̱n mimpu̱tahui̱lhcán nac ixpa̱xtú̱n quimpu̱ma̱paksi̱n, porque huata Quinti̱cú catzí tí ca̱lacsacni̱t ama ca̱ma̱xquí ixpu̱tahui̱lhcán nac quimpa̱xtú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Acxni tacátzi̱lh tú ixtalacasquín Jacobo y Juan, xa̱makapitzi discípulos tasi̱tzi̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús ca̱tasánilh y ca̱huánilh: ―Nac aktum pu̱latama̱n hua̱k xanapuxcun ma̱paksi̱naní̱n tatlahuaní xa̱makapitzi cristianos tú talacasquín porque tapuhuán xlacata huata huá tama̱paksi̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero huixín akspitaj ama ca̱qui̱taxtuniyá̱n porque tí ma̱s tali̱pa̱u lactaxtú ama ma̱tla̱ní naca̱kaxmatní xa̱makapitzi tú natali̱ma̱paksí; ");
INSERT INTO topNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","y la̱ta mili̱hua̱kcán tí xapuxcu lactaxtuputún xlacata naca̱ma̱paksí xa̱makapitzi, ama ma̱tla̱ní nali̱tamakxtaka la̱ cha̱tum tasa̱cua tí ma̱paksi̱cán. ");
INSERT INTO topNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aquit Xatalacsacni Chixcú ni̱ cmini̱t lactlancán xlacata naquintamacuaní cristianos tú nacca̱li̱ma̱paksí, aquit chá cmini̱t ca̱macuaní cristianos acxni huí tú tamaclacasquín, y na̱ cama ca̱lacati̱ta̱yá ixlacatí̱n Dios xlacata nacxoko̱nán ixtala̱kalhi̱ncán ni̱ma̱ tatlahuani̱t, aquit cama ní ixlacatacán. ");
INSERT INTO topNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús ta̱yapá nac tijia y cha̱lh nac Jericó lhu̱hua cristianos ixtakokeni̱t. Xlá huata ti̱lakatzá̱lalh ixtaxtumajá amá ca̱chiquí̱n, ");
INSERT INTO topNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","pero cha̱tuy lakatzí̱n tí ixtahuila̱na nac ixpa̱xtú̱n tijia acxni tacátzi̱lh ixmima Jesús tzúculh tama̱ktasí: ―¡Señor, ixli̱talakapasni rey David, quila̱lakalhamáu! ");
INSERT INTO topNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Makapitzi cristianos ca̱lacaquílhni̱lh xlacata acs catatahui, pero xlacán ni̱ takáxmatli y ma̱s chá ixtama̱ktasí Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xlá tá̱yalh puntzú y ca̱tasánilh: ―¿Tucu lacasquiná̱tit cactláhualh milacatacán? ―ca̱kalasquínilh. ");
INSERT INTO topNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","―Quimpu̱chinacán, aquín clacahua̱namputuná̱u ―takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús ca̱lakalhámalh amá lakatzí̱n, ca̱li̱lacaxámalh ixmacán ixlakastapucán, y tuncán tla̱n talacahuá̱nalh; a̱stá̱n na̱ tatakókelh pakán nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús cha̱lh lacatzú nac Jerusalén nac aktum actzú ca̱chiquí̱n huanicán Betfagé, tamákxtakli nac aktum ca̱quihuí̱n huanicán Cerro de los Olivos. ");
INSERT INTO topNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Xlá ca̱ma̱páksi̱lh cha̱tuy ixdiscípulos: ―Capítit namá nac actzú ca̱chiquí̱n y nac aktum ákxtaka pa̱t acxilá̱tit ca̱chi̱ya̱huacani̱t tantum cha̱t burro con actzú ixkahuasa; huixín caxcúttit y quila̱li̱miníu. ");
INSERT INTO topNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Para tí ca̱li̱huaniyá̱n hua̱nchi xcutpa̱nántit, cahuanítit xlacata Mimpu̱chinacán maclacasquín y acxni nali̱lakó ama xtakpará tuncán. ");
INSERT INTO topNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jesús chuná jaé li̱ma̱kantáxti̱lh tú istzokni̱t ixlacata nac Escrituras cha̱tum profeta: ");
INSERT INTO topNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Caca̱huanítit tí talama̱na nac ca̱chiquí̱n xla Jerusalén: “Ca̱cxílhtit rey tí ama ca̱ma̱paksi̱yá̱n, pu̱huaca tantum actzú burro xlacata hua̱k nata̱cxila ni̱ lactlancán; ca̱lakmimá̱n y pu̱tahuacani̱t tantum actzú cuca̱na burro.” ");
INSERT INTO topNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ixdiscípulos taalh y hua̱k tatláhualh la̱ta tú ca̱li̱ma̱páksi̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ixli̱puntzú talí̱chilh amá quitzistancaní̱n y tali̱ke̱tlápalh ixlhaka̱tcán amá actzú burro xlacata capu̱tahuácalh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","La̱ pu̱tahuacako̱lh tzúculh tla̱huán pakán nac Jerusalén; entonces lhu̱hua cristianos tatrámi̱lh ixlhaka̱tcán nac tijia ní ixlactla̱huama; makapitzi ixtaquí ixakán quihui tzú̱csuat y na̱ ixtatramí nac tijia. ");
INSERT INTO topNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","La̱ta tí ixtapu̱lá y tí ixtasta̱lá ixta̱ktasá: ―¡Siempre calatáma̱lh ixli̱talakapasni rey David! ¡Clakachixcuhui̱yá̱u tí ma̱lakacha̱ni̱t Dios naquinca̱ma̱paksi̱yá̱n! ¡Cpa̱xcatcatzi̱niyá̱u Dios tú tlahuani̱t! ");
INSERT INTO topNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Acxni tánu̱lh nac ca̱chiquí̱n xla Jerusalén lhu̱hua ixtara̱kalasquiní: ―¿Ticu yá chixcú jaé? ");
INSERT INTO topNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","―Namá chixcú Jesús, profeta xalac Nazaret ni̱ma̱ li̱tapaksí Galilea ―ixtakalhti̱nán makapitzi. ");
INSERT INTO topNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Astá̱n Jesús tánu̱lh nac lanca pu̱siculan xla Jerusalén. Xlá tzúculh ca̱tamacxtú hua̱k cristianos tí ixtasta̱nama̱na y tí ixtatama̱huanama̱na. Ca̱ma̱kpu̱spítnilh ixmesajcán tí ixtalakxta̱palí tumi̱n, ca̱tramákalh itsillajcán tí ixtastá palomas. ");
INSERT INTO topNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na̱ ca̱huánilh: ―Nac Escrituras Dios ma̱lacpuhua̱ní̱nalh natzokcán: “Nac quínchic tla̱n naquinkalhtahuakaní hua̱k cristianos.” Pero huixín lakxta̱pali̱ni̱tántit y li̱ma̱nu̱ni̱tántit ixpu̱sta̱cán kalha̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aná nac ixlacaquilhtí̱n pu̱siculan makapitzi lakatzí̱n y tí ni̱ lá ixtatla̱huán tama̱lacatzúhui̱lh xlacata caca̱ma̱ksá̱ni̱lh y xlá ca̱ca̱xtláhualh. ");
INSERT INTO topNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jaé ixtascújut Jesús tá̱cxilhli xanapuxcun curas y lactali̱pa̱u lacchixcuhuí̱n, na̱ chuná cani̱huá ixtakaxmatí la̱ lactzú camán ixta̱ktasá: “¡Clakachixcuhui̱yá̱u ixli̱talakapasni rey David!” Xlacán ni̱ para tziná tama̱tlá̱ni̱lh ma̱s chá tasí̱tzi̱lh, ");
INSERT INTO topNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","y huá tali̱huánilh Jesús: ―¿Ni̱ kaxpata la̱ tama̱ktasi̱má̱n namá lactzú camá̱n? ―Jé, cca̱kaxmata. ¿Hua̱nchi? ¿A poco ni̱ li̱kalhtahuakani̱tántit nac Escrituras ní tatzokni̱t? Chuné huan: Hasta lactzú camán tí tatziquijcú y ni̱ lá tla̱n chihui̱nán, huix ca̱ma̱xqui tapuhuá̱n xlacata tancs natali̱lakachixcuhui̱yá̱n ixtachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Amá lacchixcuhuí̱n yaj tú takalhtí̱nalh y Jesús ca̱kxtakyá̱hualh y alh tamakxtaka amá ca̱tzisní nac actzú ca̱chiquí̱n Betania. ");
INSERT INTO topNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ixli̱cha̱lí tzisa táspitli nac Jerusalén. Jesús tzincsli y ácxilhli katum suja ixpa̱xtú̱n tijia. Xlá lákalh pero ni̱tú ixkalhí ixtahuácat huata lhu̱hua ixpakán. ");
INSERT INTO topNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","―¡Clacasquín ya̱cxni cakalhi mintahuácat! ―huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Amá suja tuncán sca̱cli, ixdiscípulos tacá̱cni̱lh tú ixtlahuani̱t y takalasquínilh: ―¿Niculá tlahua ma̱sca̱ca jaé suja caj puntzú? ");
INSERT INTO topNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xlá ca̱kálhti̱lh: ―Aquit cca̱huaniyá̱n para huixín xli̱ca̱na ixli̱pa̱huántit Dios y aktum ixuilí̱tit mintalacapa̱stacnicán, na̱ tla̱n ixma̱sca̱cátit katum suja; y hasta tla̱n ixuanítit jaé sipi: “Catake̱nu juú y cataju nac pupunú”, y xli̱ca̱na chú ixqui̱táxtulh. ");
INSERT INTO topNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na̱ chuná li̱tum cca̱huaniyá̱n, la̱ta tú li̱kalhtahuakaniyá̱tit Dios caca̱ma̱xquí̱n, xlá ama ca̱ma̱kantaxti̱niyá̱n para tancs ca̱najlayá̱tit ama ca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesús cha̱mpá nac pu̱siculan y tzúculh ca̱ma̱kalhchihui̱ní cristianos; pero ixli̱puntzú táchilh xanapuxcun curas y xalactali̱pa̱u ma̱paksi̱naní̱n. Xlacán takalasquínilh: ―¿Tucu xlacata li̱paktanu̱ni̱ta tú tlahuani̱ta nac pu̱siculan? ¿Ticu ma̱xqui̱ni̱tán tapáksi̱t natlahuaya la̱ta tú huix lacasquina? ");
INSERT INTO topNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús ca̱kálhti̱lh: ―Aquit na̱ huí tú camá̱n ca̱kalasquiniyá̱n, y para huixín quila̱kalhti̱yá̱u aquit na̱ nacca̱kalhti̱yá̱n tí quili̱ma̱paksi̱ni̱t tú ctlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Chí tuncán quila̱huaníu, ¿ticu li̱ma̱páksi̱lh Juan Bautista caca̱kmúnulh cristianos, Dios, o lacchixcuhuí̱n? Xlacán tzúculh talacchihui̱nán la̱ natakalhtí, y chuné ixtara̱kalasquiní: ―Para huaniyá̱u Dios li̱ma̱páksi̱lh, ama quinca̱huaniyá̱n hua̱na ni̱ ca̱najláu ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y para huaniyá̱u lacchixcuhuí̱n tali̱ma̱páksi̱lh tla̱n tasi̱tzí cristianos porque lhu̱hua taca̱najlani̱t xlacata Dios ma̱lakacha̱ni̱t nali̱chihui̱nán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","La̱ talacchihui̱nanko̱lh takálhti̱lh: ―Aquín ni̱ ccatzi̱yá̱u tí li̱ma̱páksi̱lh. Jesús na̱ ca̱huánilh: ―Para huixín ni̱ catzi̱yá̱tit, ni̱ para aquit cama ca̱huaniyá̱n tí quili̱ma̱paksi̱ni̱t nactlahuá tú acxilá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Astá̱n Jesús chuné tzúculh ca̱ma̱kalhchihui̱ní amá lacchixcuhuí̱n: ―Tla̱n cakaxpáttit tú cama ca̱huaniyá̱n: Cha̱tum chixcú ixkalhí cha̱tuy ixlakkahuasán; maktum huánilh xapuxcu: “Ti̱cu, capit scuja jaé chichiní nac quinca̱tucuxtu ana ní cchani̱t uvas.” ");
INSERT INTO topNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Chí ni̱ camputún scuja”, kálhti̱lh ixti̱cú. Pero a̱stá̱n ma̱túnujli ixtapuhuá̱n y alh scuja nac ixca̱tucuxtu ixti̱cú. ");
INSERT INTO topNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Amá chixcú huánilh xatajú ixkahuasa: “Chí huix capit scuja nac quinca̱tucuxtu.” “Tla̱n nacán scuja nac minca̱tucuxtu”, kálhti̱lh ixti̱cú. Pero amá kahuasa ni̱ alh scuja la̱ ma̱lácnu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Chí quila̱huaníu, ¿la̱ta ixli̱cha̱tuycán, ticu ma̱kantáxti̱lh tú ma̱páksi̱lh ixti̱cucán? ―Pues xla̱huán ixkahuasa ―takalhtí̱nalh. Huanipá Jesús: ―Xli̱ca̱na, tí ni̱ lactali̱pa̱u y ni̱ma̱ chu̱ta ta̱clapu̱lá lacchaján pu̱la ama tatanú nac ixtapáksi̱t Dios y huixín pa̱t tamakxtaká̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porque Juan Bautista milh ca̱ma̱kalhchihui̱ni̱yá̱n la̱ natati̱tumi̱yá̱tit, pero huixín ni̱ ca̱najlátit ixtachihuí̱n. Tí takáxmatli ixtachihuí̱n y talakxta̱páli̱lh ixlatama̱tcán huá namá ní̱ lactali̱pa̱u lacchixcuhuí̱n y tí chu̱ta ta̱clapu̱lá lacchaján, y huixín ma̱squi ca̱cxílhtit la̱ tama̱táncsalh ixlatama̱tcán, ni̱ para tziná ma̱tunújtit minkasatcán. ");
INSERT INTO topNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Cama ta̱ma̱lacastucpará minkasatcán jaé takalhchihuí̱n: Ixpu̱chiná aktum lanca ca̱tucuxtu chalh lhu̱hua li̱chánat uvas nac ixpu̱chaná̱n. Tla̱n maccorralhko̱lh; aná lacatzú tláhualh ixpu̱chitcán, na̱ tláhualh aktum lanca torre xlacata tla̱n namaktakalha ixtachaná̱n. Astá̱n ca̱ma̱sa̱cuáni̱lh ixca̱tucuxtu makapitzi lacchixcuhuí̱n y alh latamá a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Acxni tzúculh catlán ixtahuácat ca̱ma̱lakácha̱lh makapitzi ixtasa̱cua xlacata nama̱xqui̱cán tú ixtocarlí la̱ ixca̱ta̱lacca̱xlani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero amá lacchixcuhuí̱n tachípalh ixtasa̱cua ixpatroncán, makapitzi ta̱kkaxími̱lh, makapitzi tamákni̱lh y tunuj taliactaláli̱lh chíhuix. ");
INSERT INTO topNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amá ixpu̱chiná ca̱tucuxtu ca̱ma̱lakácha̱lh ma̱s ixtasa̱cua, pero amá ni̱ lactlá̱n lacchixcuhuí̱n na̱ chuná tama̱kxtakájni̱lh la̱ ixtatlahuani̱t xa̱makapitzi tasa̱cua tí ixca̱ma̱lakacha̱cani̱t xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Xlá ixkalhí cha̱tum ixkahuasa y tzúculh lacpuhuán: “Para cma̱lakachá quinkahuasa natakaxmatní y naquintama̱xquí tú quimini̱ní.” ");
INSERT INTO topNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Xli̱ca̱na ma̱lakácha̱lh, pero amá lacchixcuhuí̱n acxni tá̱cxilhli amá kahuasa tzúculh talacchihui̱nán: “Huá jaé ama ta̱tamakxtaka hua̱k herencia, para makni̱yá̱u aquín nata̱tamakxtaká̱u jaé ca̱tucuxtu.” ");
INSERT INTO topNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xlacán talí̱lhca̱lh natama̱laksputú amá kahuasa, tachípalh táli̱lh ixquilhpá̱n ca̱tucuxtu y aná tamákni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","La̱ chihui̱nanko̱lh Jesús ca̱kalasquínilh amá xanapuxcun judíos: ―Chí quila̱huaníu, ¿tucu puhuaná̱tit naca̱tlahuaní ixpu̱chiná jaé ca̱tucuxtu amá ni̱ lactlá̱n lacchixcuhuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Xlacán takalhtí̱nalh: ―Pues nacmakní amá ni̱ lactlá̱n cha̱lhca̱tnaní̱n, y naca̱macama̱xquí ixca̱tucuxtu tunuj lacchixcuhuí̱n tí nataxokoní y natamacama̱xquí ixquilhta cosecha ni̱ma̱ xlá mini̱ní. ");
INSERT INTO topNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús ca̱huaniko̱lh: ―Nac Escrituras lacatum li̱chihui̱nán minkasatcán, pues tatzokni̱t: Amá lanca chíhuix ni̱ma̱ talakmákalh xtlahuananí̱n chiqui ixtapuhuán ni̱tú li̱macuán, a̱stá̱n milh tamakxtaka ma̱s tali̱pa̱u pues ya̱huaca nac ixcha̱stú̱n la̱ xacha̱ya y aná ixli̱tzinca̱snanko̱ni̱t chiqui. Tú acxilá̱u hua̱k Dios lacsacxtuni̱t, y pa̱xahuayá̱u masqui ni̱ ma̱kachakxi̱yá̱u lanca ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Aquit tancs cca̱huaniyá̱n, Dios ama ca̱maklhti̱yá̱n mimpu̱tahui̱lhcán ni̱ma̱ ixca̱lacsacnini̱tán nac ixtapáksi̱t y ama ca̱ma̱xquí amá tí ni̱ lactali̱pa̱u cristianos puhuaná̱tit xlacata xlacán natama̱xquí ixtahuácat ixtascújut para tatlahuá ixtapáksi̱t nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Amá tí liakchakxa jaé chíhuix y tahuacaya̱chá ixakspu̱n ixacstu ama laktzanká; y tí actahuilá jaé chíhuix ama lacchatamí. ");
INSERT INTO topNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Amá xanapuxcun curas y lactali̱pa̱u saduceos tama̱kachákxi̱lh xlacata Jesús ixca̱li̱ta̱ma̱lacastucni̱t ixkasatcán amá ixtakalhchihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Xlacán li̱cuánit tasí̱tzi̱lh y tachipaputún Jesús xlacata natama̱laksputú, pero tajicuánilh cristianos porque xlacán ixtali̱macá̱n Jesús cha̱tum profeta tí ixma̱lakacha̱ni̱t Dios nali̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ca̱li̱ta̱ma̱lacastucpá tunuj ixtakalhchihuí̱n amá cristianos tí ixama tatanú, y tí ixama talakmakán ixtapáksi̱t ni̱ma̱ ixma̱lacatzuqui̱putún nac ixlatama̱tcán; y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Cha̱tum rey ixlaclhca̱ni̱t ama tlahuá lanca fiesta porque ixama tamakaxtoka ixkahuasa. ");
INSERT INTO topNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Acxni lihua lákcha̱lh chichiní xlá ca̱ma̱lakácha̱lh ixtasa̱cua catama̱kpítzilh tachihuí̱n catachilhá nac pu̱tamakaxtokni amá lacchixcuhuí̱n tí ixlacasquín natata̱pa̱xahuá; pero xlacán ni̱ ta̱mpútulh amá nac fiesta. ");
INSERT INTO topNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pero xlá ca̱ma̱lakacha̱pá ixtasa̱cua y ca̱huanica amá lacchixcuhuí̱n: “Huan rey yaj tú cali̱makapalátit, ca̱makni̱cajá quitzistancaní̱n y tahuá ca̱xtlahuacani̱ttá; a̱huata huixín ca̱kalhi̱má̱n nac pu̱tamakaxtokni.” ");
INSERT INTO topNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero amá lactali̱pa̱u lacchixcuhuí̱n tasí̱tzi̱lh y ni̱ táalh nac pu̱tamakaxtokni. Makapitzi taalh nac ixca̱tucuxtucán, tunuj táalh nac ixpu̱sta̱ncán ");
INSERT INTO topNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","y makapitzi tachípalh amá ixtasa̱cua rey ta̱kkaxími̱lh, tama̱kxtakájni̱lh hasta tamákni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Amá rey acxni cátzi̱lh tú ixca̱tlahuanicani̱t ixtasa̱cua snu̱n sí̱tzi̱lh y ca̱ma̱lakácha̱lh itsoldados xlacata naca̱makni̱cán amá lacchixcuhuí̱n y ca̱lhcuyunicán ixca̱chiqui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Amá rey ca̱huánilh tunuj ixtasa̱cua: “Nac ixpu̱tamakaxtokni quinkahuasa hua̱k ca̱xlani̱t tahuá y tú tamaclacasquiní, pero amá tí xaclacasquín naquintalakmín ca̱ma̱laktzánke̱lh ixkasatcán. ");
INSERT INTO topNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Chí mejor capítit nac li̱tamá̱u, y nac ca̱lactijyí̱n ní tzamacán; caca̱huanítit hua̱k cristianos tí ca̱taka̱sá̱tit catámilh nac ixpu̱tamakaxtokni quinkahuasa.” ");
INSERT INTO topNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Xlacán tatláhualh tú ca̱huánilh amá rey; ixli̱punchú nac pu̱tamakaxtokni ixtachini̱t lhu̱hua cristianos, tí lactlá̱n ixtacatzí y hasta tí lacsnú̱n ixtalani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ixli̱puntzú amá rey tánu̱lh ca̱cxila hua̱k tí ixtamini̱t, pero ni̱ ma̱tlá̱ni̱lh la̱ cha̱tum chixcú ni̱ ixuili̱ni̱t lháka̱t ni̱ma̱ ma̱sta̱ca acxni tatánu̱lh nac pu̱tamakaxtokni. ");
INSERT INTO topNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Xlá ta̱chihuí̱nalh: “Amigo, ¿tucu xlacata ni̱ li̱huili namá lháka̱t ni̱ma̱ ca̱ma̱xqui̱ca tí tatánu̱lh juú nac pu̱tamakaxtokni?” Xlá ni̱ cátzi̱lh tú nakalhti̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Entonces li̱ma̱paksí̱nalh: “Jaé chixcú camakachí̱tit, catantu̱chí̱tit y catamacxtútit nac quilhtí̱n ní ca̱paklhtu̱tá. ¡Koxitá laktzanka̱ni̱t, aná ama tasá y tatlanca̱ní la̱ta li̱puhuán!” ");
INSERT INTO topNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesús ca̱huaniko̱lh: ―Lhu̱hua cristianos ca̱tasanicán natatanú nac ixtapáksi̱t Dios, pero huata ca̱lacsaccán amá makapitzi tí takaxmata. ");
INSERT INTO topNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Makapitzi fariseos tzúculh talacchihui̱nán la̱ natali̱kalhputzá ixtachihui̱ncán Jesús xlacata nahuán tú tla̱n natali̱ma̱lacapú. ");
INSERT INTO topNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xlacán tama̱lakácha̱lh makapitzi ixcompañeros y tí ixtata̱ta̱yá rey Herodes. Acxni talákcha̱lh takalasquínilh: ―Maestro, ccatzi̱yá̱u xlacata huix tancs ma̱si̱ya ixtachihuí̱n Dios la̱ quili̱latama̱tcán, ni̱tí li̱quilhpuhuana li̱huaniya ixkásat para ni̱ chuná lama ma̱squi casí̱tzi̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Quila̱huaníu, ¿chá tla̱n qui̱taxtú la̱ clakaxokoniyá̱u tumi̱n xapuxcu ma̱paksi̱na romano o ni̱ mini̱ní naclakaxoko̱naná̱u? ");
INSERT INTO topNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús acxcátzi̱lh caj ixtakalhputzama̱na y huá ca̱li̱kálhti̱lh: ―¡Laktakalhí̱n akskahuinaní̱n huixín! ¿Ticu puhuaná̱tit kalhputzapa̱nántit? ");
INSERT INTO topNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Quila̱ma̱si̱níu mactum tumi̱n ni̱ma̱ li̱lakaxoko̱naná̱tit. Xlacán tali̱mínilh mactum denario tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Acxni ácxilhli Jesús ca̱kalasquínilh: ―Quila̱huaníu, ¿ticu ixretrato, y ticu yá ixtacuhui̱ní tali̱lakatzokni̱t jaé tumi̱n? ");
INSERT INTO topNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Pues tali̱lakatzokni̱t ixretrato ixtacuhui̱ní xapuxcu ma̱paksi̱na romano ―takalhtí̱nalh xlacán. Jesús ca̱huaniko̱lh: ―Pues cama̱xquí̱tit xapuxcu ma̱paksi̱na romano tú xlá tlahuani̱t, y cama̱xquí̱tit Dios tú xlá lacasquín milacatacán. ");
INSERT INTO topNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","La̱ takaxmatko̱lh tú ca̱kálhti̱lh Jesús xlacán yaj tacátzi̱lh tú natahuán y ta̱kxtakyá̱hualh. ");
INSERT INTO topNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Saduceos ni̱ taca̱najlá para ni̱n talacastacuanán nac ca̱li̱ní̱n y pi̱huá amá chichiní taalh takalasquiní Jesús: ");
INSERT INTO topNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maestro, Moisés li̱ma̱paksi̱nán para cha̱tum chixcú tamakaxtokni̱t y la̱ta ni̱ takalhi̱ni̱t ixcamán, con xlá ní, ixta̱cam mini̱ní nata̱tamakaxtoka ixya̱stá xlacata natakalhí ixcamancán y ni̱ nalaksputa ixta̱cam ni̱ma̱ ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chí cakáxpatti tú qui̱táxtulh: Maktum ixtalama̱na cha̱tujún li̱ta̱camán; xla̱huán tamakáxtokli y ni̱lh la̱ta ni̱ ca̱kálhi̱lh ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ixli̱cha̱tuy ixta̱cam ta̱tamakáxtokli ixya̱stá y ya̱ para ixtakalhí ixcamancán acxni na̱ ni̱lh. Xa̱makapitzi na̱ tata̱tamakáxtokli amá pusca̱t y acxtum chuná tapá̱xtokli ni̱ takálhi̱lh ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Pero cha̱lh quilhtamacú amá pusca̱t na̱ ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Chí quila̱huaníu, acxni natalacastacuanán nac ca̱li̱ní̱n, la̱ta ixli̱cha̱tujuncán, ¿ticu ama ta̱tamakxtaka amá pusca̱t pues hua̱k ixtata̱tahuilani̱t? ");
INSERT INTO topNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús ca̱kálhti̱lh amá saduceos: ―Huixín aktzanka̱ni̱tántit porque ni̱ ma̱kachakxi̱yá̱tit ixtachihuí̱n Dios nac Escrituras, ni̱ para catzi̱yá̱tit la̱ kalhí ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Acxni natalacastacuanán cristianos nac ca̱li̱ní̱n yaj ta̱má̱n tatamakaxtoka, ni̱ para ama tama̱makaxtoka ixcamancán pues ama talatamá la̱ ángeles ni̱ma̱ talama̱na nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Huixín na̱ aktzanka̱ni̱tántit para puhuaná̱tit ni̱cxni talacastacuanán ni̱n porque ni̱ tla̱n ma̱kachakxi̱ni̱tántit ana ní ma̱tzokónalh Dios nac Escrituras: ");
INSERT INTO topNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Aquit Dios tí tali̱pa̱huani̱t y tali̱pa̱huancú Abraham, Isaac y Jacob.” Jaé qui̱taxtú xlacata tí talatáma̱lh y táni̱lh la̱ xastacnancú talama̱na porque huata tí xastacnán talama̱na tla̱n tali̱pa̱huancú Dios. ");
INSERT INTO topNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hua̱k cristianos tí takáxmatli tú ca̱kálhti̱lh Jesús amá lactali̱pa̱u saduceos huata tacá̱cni̱lh ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Amá fariseos acxni tacátzi̱lh la̱ Jesús ca̱li̱makatlájalh ixtachihuí̱n amá saduceos tzucupá talacchihui̱nán la̱ natakalhputzá, ");
INSERT INTO topNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","y tama̱lakácha̱lh cha̱tum tí ixma̱sí ixtachihuí̱n Dios nac sinagoga. ");
INSERT INTO topNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Xlá kalasquínilh: ―Maestro, la̱ta ixli̱hua̱k ixtapáksi̱t Moisés ni̱ma̱ má̱xqui̱lh Dios, ¿neje ma̱s quili̱tlahuatcán? ");
INSERT INTO topNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús kálhti̱lh: ―Xla̱huán ixtapáksi̱t Dios huan: “Cali̱pá̱huanti Mimpu̱chinacán Dios ixli̱hua̱k minacú, ixli̱hua̱k mili̱stacni, ixli̱hua̱k mintalacapa̱stacni.” ");
INSERT INTO topNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Huá jaé ixtapáksi̱t Dios ma̱s ixli̱tlahuatcán hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ixliaktuy ixtapáksi̱t na̱ acxtumatiyá qui̱taxtú y chuné li̱chihui̱nán: “Caca̱lakalhámanti hua̱k minta̱cristianos na̱ chuná la̱ huix lacasquina calakalhamanca.” ");
INSERT INTO topNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","La̱ta tú li̱chihui̱nani̱t Moisés y profetas huá jaé ixtapáksi̱t Dios tama̱si̱putuni̱t, y aquit caj aktuy cca̱tlahuani̱t. ¡Tí ma̱kantaxtí tú cuanín nac ixlatámat yaj tú cali̱púhualh! ");
INSERT INTO topNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Amá lactali̱pa̱u fariseos aná ixtalaya̱najcú, ");
INSERT INTO topNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","huá ca̱li̱kalasquínilh Jesús: ―Quila̱huaníu, ¿niculá puhuaná̱tit ama min Cristo tí ama ca̱lakma̱xtuyá̱n? ¿Nicu ama taxtú? ―Aquín ccatzi̱yá̱u xlacata ixli̱talakapasni rey David ama huan ―takálhti̱lh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús ca̱huanipá: ―Entonces, ¿hua̱nchi acxni rey David ma̱lacpuhuá̱ni̱lh ixli̱tlihueke Espíritu Santo xlá li̱ma̱pa̱cúhui̱lh Ixpu̱chiná? Lacatum nac Escrituras tzokni̱t: ");
INSERT INTO topNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Quimpu̱chinacán Dios huánilh Quimpu̱chiná tí ama quilakma̱xtú: “Catahuila ixpa̱xtún quimpu̱ma̱paksi̱n hasta xní nacca̱makatlajá mienemigos xlacata acxtum natalakachixcuhui̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Huá cca̱li̱huaniyá̱n, ¿nicu li̱puhuaná̱tit xlacata Cristo ixli̱talakapasni rey David nahuán si pi̱huá rey David li̱macá̱n Ixpu̱chiná tí ama lakma̱xtú? ");
INSERT INTO topNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Amá lacchixcuhuí̱n ni̱ tacátzi̱lh tú natakalhti̱nán y la̱ta amá quilhtamacú yaj tí tú tali̱kalhpútzalh ixtachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús ca̱talakaspítnilh ní ixtaya̱na hua̱k cristianos y ixdiscípulos, y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Fariseos y mima̱kalhtahuake̱nacán tapuhuán xlacata hua̱k ixtapáksi̱t Moisés huata xlacán tla̱n tali̱ma̱paksi̱nán tú ixli̱tlahuatcán cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huixín cakaxpáttit y catlahuátit tú tali̱ma̱paksi̱nán, pero ni̱cxni caca̱makslihuekétit ixkasatcán porque xlacán tú tali̱ma̱paksi̱nán ni̱ tama̱kantaxtí nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xlacán tali̱ma̱paksí cristianos lactzú lactzú tachihuí̱n tú ixli̱tlahuatcán la̱ catama̱cúqui̱lh lactzinca tacuca, pero xlacán ni̱ tali̱xamaputún ixmacancán porque talakatí tama̱cuqui̱nán y ni̱ talakatí tacuca̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Acxni tatlahuá aktum li̱tlá̱n taán ní tzamacán xlacata naca̱cxilhcán y naca̱li̱kalhi̱cán lactlá̱n cristianos. Nac ixmacxpa̱ncán tali̱taca̱xta̱yá lactzú cápsnat ní tatzokni̱t ixtachihuí̱n Dios, y taca̱xya̱huá ixlhaka̱tcán ma̱s laclhmá̱n xlacata naca̱lakapascán cani̱huá. ");
INSERT INTO topNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nac fiestas talakatí caca̱ma̱xqui̱ca lactlá̱n pu̱táhui̱lh y nac sinagogas tatahuilá nac ixlacatí̱n xlacata naca̱li̱kalhi̱cán la̱ lactali̱pa̱u lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Acxni tataxtú nac li̱tamá̱u y ní tzamacán talakatí caca̱ma̱pa̱cuhui̱ca lactali̱pa̱u maestros acxni ca̱huanicán kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero huixín ni̱ calactlancántit la̱ talá xlacán porque acxtum li̱ta̱camán huixín, y ni̱ cama̱tla̱ní̱tit tí naca̱li̱ma̱pa̱cuhui̱yá̱n lactali̱pa̱u maestro porque hua̱k huixín kalhi̱yá̱tit cha̱tum tali̱pa̱u maestro y huá aquit Cristo. ");
INSERT INTO topNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Juú nac ca̱quilhtamacú ni̱tí cali̱ma̱pa̱cuhuí̱tit minti̱cucán porque namá tacuhui̱ní huata ma̱ccha̱ní Dios Minti̱cucán ni̱ma̱ huí nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Huixín ni̱cxni cali̱tanú̱tit naca̱li̱lhca̱caná̱tit xanapuxcun cristianos porque huata Cristo ma̱ccha̱ní nali̱ma̱nu̱yá̱tit mimpuxcucán. ");
INSERT INTO topNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Namá tí ma̱s nali̱tamakxtaka naca̱macuaní xa̱makapitzi, huá namá ma̱s lanca ama huan nac quintapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amá tí lanca lactaxtú ama̱ca ma̱cti̱cán hasta tu̱tzú, y amá tí tu̱tzú tamakxtaka ama̱ca ma̱cxtucán ta̱lhmá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Koxitaní̱n huixín akskahuinaní̱n fariseos y ixma̱kalhtahuake̱nacá̱n judíos, ¡ni̱ catzi̱yá̱tit tú pa̱t pa̱xtoká̱tit! Laktzanka̱ni̱tántit porque ni̱ tanu̱putuná̱tit nac ixtapáksi̱t Dios ni̱ para li̱makxtaká̱tit tí catánu̱lh pues siempre tzakasayá̱tit ma̱lacchahuaniyá̱tit puhui̱lhta tí tanu̱putún. ");
INSERT INTO topNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Laktzanka̱ni̱tántit huixín akskahuinaní̱n fariseos y ma̱kalhtahuake̱naní̱n! Porque ca̱kskahuimaklhti̱yá̱tit ixchiccán viudas, y xlacata ni̱tí nacatzí minkasatcán li̱catzi lhu̱hua kalhtahuakaniyá̱tit Dios, pero ni̱ lá pa̱t taxtuniyá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Laktzanka̱ni̱tántit porque lakatza̱layá̱tit lhu̱hua pu̱latama̱n hasta xní naqui̱taka̱sá̱tit cha̱tum cristiano tí ni̱ li̱pa̱huán Dios; pero acxni tzucuyá̱tit makaca̱najlayá̱tit la̱ huixín ca̱najlayá̱tit, ma̱s ma̱laktzanke̱yá̱tit pues li̱ma̱huacayá̱tit tú ma̱si̱yá̱tit y li̱lhca̱yá̱tit ma̱s ni̱ tuhua namaca̱ncán nac lhcúya̱t que la̱ ixlama xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Laktzanka̱ni̱tántit lakatzi̱ní̱n lacchixcuhuí̱n! Huixín huaná̱tit: “Amá tí ni̱ ma̱kantaxtí ixtachihuí̱n ma̱squi ixpu̱siculan Dios li̱ma̱lácnu̱lh ni̱ kalhí tala̱kalhí̱n, pero amá tí ni̱ ma̱kantaxtí ixtachihuí̱n y li̱ma̱lácnu̱lh oro ni̱ma̱ huí ixpu̱lacni pu̱siculan, namá sí kalhí tala̱kalhí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Takalhi̱ní̱n lakatzi̱ní̱n! Quila̱huaníu, ¿tucu ma̱s ixtapalh, amá oro, o ma̱s ixtapalh ixpu̱siculan Dios ní ma̱nu̱cani̱t amá oro? ");
INSERT INTO topNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huixín na̱ ma̱tla̱ni̱yá̱tit: “Amá tí ni̱ ma̱kantaxtí ixtachihuí̱n ma̱squi li̱ma̱lácnu̱lh ixpu̱lakachixcuhui̱cán Dios nac pu̱siculan ni̱ kalhí tala̱kalhi̱n, pero amá tí ni̱ ma̱kantaxtí ixtachihuí̱n y li̱ma̱lácnu̱lh tú li̱lakachixcuhui̱cani̱t Dios ixakspú̱n amá pu̱lakachixcuhui̱n, namá sí kalhí tala̱kalhí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Takalhi̱ní̱n lakatzi̱ní̱n! Quila̱huaníu, ¿ma̱s ixtapalh amá li̱lakachixcuhui̱n, o ma̱s ixtapalh ixpu̱lakachixcuhui̱cán Dios ana ní huili̱cán tú ma̱lacnu̱nicán? ");
INSERT INTO topNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Aquit tancs cca̱huaniyá̱n, amá tí ni̱ ma̱kantaxtí ixtachihuí̱n y li̱ma̱lacnú ixpu̱lakachixcuhui̱cán Dios ma̱s kalhí tala̱kalhí̱n porque na̱ ta̱ma̱lacnu̱ma li̱lakachixcuhui̱n ni̱ma̱ huí ixakspú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Y amá tí ni̱ ma̱kantaxtí ixtachihuí̱n y li̱ma̱lacnú ixpu̱siculan Dios ma̱s kalhí tala̱kalhí̱n porque na̱ ta̱ma̱lácnu̱lh tú tanu̱ma ixpu̱lacni pues Dios la̱ ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Amá tí ni̱ ma̱kantaxtí ixtachihuí̱n y li̱ma̱lacnú akapú̱n ma̱s kalhí tala̱kalhí̱n porque na̱ ta̱ma̱lacnú ixpu̱táhui̱lh Dios pues akapú̱n ixpu̱latama̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Laktzanka̱ni̱tántit akskahuinaní̱n fariseos y ixma̱kalhtahuake̱nacán judíos! Porque ni̱ tzanka̱yá̱tit ma̱sta̱yá̱tit la̱ li̱lhca̱cani̱t tú makalayá̱tit nac minca̱tucuxtucán, hasta tú chaná̱tit nac lacaquilhti̱n na̱ ma̱sta̱yá̱tit para anis y menta, pero aktzonksuayá̱tit tú pu̱la mili̱tlahuatcán xlacata acxtum ixca̱lakalhamántit cristianos, acxtum ixca̱li̱kalhí̱tit, y aktum ixuilí̱tit mintalacapa̱stacnicán ixlacatí̱n Dios. Aquit ni̱ cca̱huanimá̱n ni̱ cama̱stá̱tit tú makalayá̱tit, pero pu̱la mili̱tlahuatcán nac milatama̱tcán tú ma̱s ca̱macuaniyá̱n ixlacatí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Lakatzi̱ní̱n lacchixcuhuí̱n huixín pues scarancua lacsacá̱tit ni̱ naquilhtanu̱yá̱tit tantum actzú chinchi, pero ni̱ acxcatzi̱yá̱tit acxni huayá̱tit tantum tzi̱ya! ");
INSERT INTO topNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Laktzanka̱ni̱tántit huixín akskahuinaní̱n ixma̱kalhtahuake̱nacán judíos y na̱ chuná huixín fariseos! Porque tla̱n ca̱lakcheke̱yá̱tit mimpu̱hua̱ycán, pero amá tahuá ni̱ma̱ ca̱li̱ma̱tzamayá̱tit li̱tama̱huani̱tántit tú kalhani̱tántit y tú ca̱kskahuimaklhti̱ni̱tántit xa̱makapitzi. ");
INSERT INTO topNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lakatzi̱ní̱n huixín fariseos, ma̱s ca̱macuaniyá̱n yaj cakalhántit tú ca̱li̱ma̱tzamayá̱tit mimpu̱hua̱ycán, y chuná acxni naca̱lacxiquiyá̱tit xli̱ca̱na lactlá̱n natahuán. ");
INSERT INTO topNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ni̱ pa̱t taxtuniyá̱tit huixín akskahuinaní̱n ixma̱kalhtahuake̱nacán judíos y fariseos! Porque milatama̱tcán cca̱ta̱ma̱lacastuca la̱ laclá̱n gavetas xalac campúsa̱ntu; ixmacnicán tla̱n ca̱ca̱xya̱huacani̱t, pero ixpu̱lacni puro lacli̱xcájnit lúcut taju̱ma. ");
INSERT INTO topNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chuná jaé huixín ixlacati̱ncán cristianos, li̱tanu̱yá̱tit lactlá̱n cristianos, pero minacujcán li̱xcájnit ixkásat pues lhu̱hua tú ni̱ tla̱n huaná̱tit y tlahuayá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Laktzanka̱ni̱tántit huixín akskahuinaní̱n ixma̱kalhtahuake̱nacán judíos y fariseos! Porque profetas ni̱ma̱ tamákni̱lh xalakmaká̱n mili̱talakapasnicán, huixín ca̱tlahuaniyá̱tit monumentos ixca̱li̱lacapa̱staccán, y amá lactlá̱n cristianos tla̱n ca̱ca̱xya̱huaniyá̱tit ixpu̱taju̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y nac ixlacati̱ncán tatla̱ni̱yá̱tit y huaná̱tit: “Para aquín xactilatamá̱u amá quilhtamacú, ni̱ xactica̱li̱makxtakui caca̱makni̱ca.” ");
INSERT INTO topNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","¡Akskahuinaní̱n lacchixcuhuí̱n! Pi̱huá mintachihui̱ncán tla̱n ca̱li̱lakapascaná̱tit xlacata huixín ixmakslihuekenaní̱n amá tí tamákni̱lh profetas. ");
INSERT INTO topNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Chí cama̱tancsputútit huixín tú tama̱lacatzuqui̱ni̱t xalakmaká̱n mili̱talakapasnicán! ");
INSERT INTO topNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ni̱ catachokótit porque huixín la̱ akskahuinaní̱n lu̱hua; ni̱tú cali̱puhuántit, acxtumatiyá ni̱ pa̱t taxtuniyá̱tit nachipiná̱tit nac puakxtakajni ní naxoko̱naná̱tit! ");
INSERT INTO topNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Para ni̱ ca̱najlayá̱tit aquit cama ca̱ma̱lakacha̱niyá̱n profetas tí tali̱chihui̱nán Dios, lakskalala lacchixcuhuí̱n tí ca̱ma̱xquí ixtapuhua̱ncán Espíritu Santo, y huixín pa̱t ca̱snoká̱tit y ca̱ma̱kxtakajni̱yá̱tit nac sinagogas y makapitzi pa̱t ca̱makni̱yá̱tit nac culu̱s, y tunuj pa̱t ca̱pu̱tlakayá̱tit katunu ca̱chiquí̱n ní natalatama̱putún. ");
INSERT INTO topNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pero huá jaé cristianos tí talama̱na jaé quilhtamacú ama taxoko̱naní Dios ixli̱stacnicán amá lacchixcuhuí̱n tí ca̱ma̱lakacha̱ni̱t y ca̱makni̱cani̱t la̱ta xla̱huán timakni̱ca amá tla̱n chixcú Abel hasta ixli̱stacni Zacarías ixkahuasa Berequías amá profeta tí tamákni̱lh mili̱talakapasnicán lacatzú ixpu̱lakachixcuhui̱cán Dios nac pu̱siculan. ");
INSERT INTO topNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Hua̱k ixli̱stacnicán profetas Dios ca̱ma̱cstucni̱t y ama ca̱ma̱tají nataxoko̱nán huá jaé cristianos tí talama̱na jaé quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Jerusalén! ¡Koxitá quinca̱chiquí̱n Jerusalén! Juú ca̱makni̱cani̱t hua̱k lactali̱pa̱u profetas y ca̱ctalali̱ncán lacchixcuhuí̱n tí ca̱ma̱lakacha̱ni̱t Dios namakta̱yayá̱n. Ni̱ caj maktum aquit cca̱ma̱makstokpútulh quincamán xala jaé ca̱chiquí̱n na̱ chuná la̱ tantum cha̱t xti̱la̱n ca̱pa̱tanú ca̱maklhti̱nán hua̱k lactzú itskatá̱n, pero xlacán ni̱ tama̱tlá̱ni̱lh tú cca̱ma̱lacnú̱nilh. ");
INSERT INTO topNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pero talaktzanka̱ni̱t porque yaj maka̱s tzanká acxni hua̱k ákxtaka ama̱ca ca̱kxtakmakancán. ");
INSERT INTO topNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y cca̱huaniyá̱n, yaj amá̱n quila̱cxilá̱u hasta xní nachá̱n quilhtamacú acxni huixín huaná̱tit: “Chí yaj camá̱n lakmakaná̱u y camá̱n li̱pa̱huaná̱u namá chixcú tí quinca̱ma̱lakacha̱nini̱tán Quimpu̱chinacán Dios.” ");
INSERT INTO topNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","La̱ ca̱li̱chihui̱nanko̱lh Jesús amá lacchixcuhuí̱n, ca̱ta̱táxtulh ixdiscípulos nac pu̱siculan táalh pakán ní ixtalhtatá. Acxni lihua tataxtuko̱lh makapitzi ixdiscípulos tzúculh tali̱ta̱chihui̱nán xlacata cacá̱cxilhli amá laclá̱n pu̱laclhu̱hua chiqui ni̱ma̱ ixca̱li̱tlahuacani̱t amá lanca pu̱siculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesús huata ca̱káxmatli y chuné ca̱kálhti̱lh: ―Huixín ca̱cxilá̱tit la̱ ixli̱laclá̱n ca̱ca̱xya̱huacani̱t namá pu̱siculan pero ni̱ catzi̱yá̱tit xlacata ni̱ ixli̱maka̱s quilhtamacú ni̱ ama tamakxtaka ni̱ para akstum chíhuix nac ixpu̱ta̱y hua̱k pá̱tzaps, ¡hua̱k ama ca̱lactlahuako̱cán! ");
INSERT INTO topNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Astá̱n ti̱tum tácha̱lh nac Monte de los Olivos ana ní ixtatamakxtaka. Jesús curucs ixuí acxni makapitzi ixdiscípulos ca̱tze̱k takalasquínilh: ―Quila̱huaníu, ¿xnicu ama qui̱taxtú jaé tú quila̱li̱ta̱chihui̱náu? ¿Niculá pa̱t tamparaya ixli̱maktuy ca̱quilhtamacú? ¿Tucu xla̱huán ama tasí acxni amá a̱huatiyá quilhtamacú nachitamparaya? ");
INSERT INTO topNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús ca̱huañilh tú ixtacatzi̱putún: ―Skálalh calatapá̱tit ni̱tí naca̱kskahuiyá̱n, ");
INSERT INTO topNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","porque lhu̱hua tamá̱n tamín y ama tali̱tanú xlacán Cristo tí mimá̱n ca̱lakma̱xtuyá̱n, y como na̱ tancs ama tachihui̱nán, lhu̱hua ama taca̱najlá ixtachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pa̱t kaxpatá̱tit la̱ li̱chihui̱nancán guerras y la̱ tla̱n natara̱makní cristianos, pero ni̱ cajicuántit pues tamaclacasquiní pu̱la chú naqui̱taxtú, y jaé cajcú ixquilhtzúcut tú ama lá a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Aktum ca̱chiquí̱n ama ta̱ra̱nica tunuj ca̱chiquí̱n, aktum pu̱latama̱n ama ta̱ra̱nica tunuj pu̱latama̱n. Ama lá tatzíncsnit y ama min ti̱pa̱katzi tá̱tat cani̱huá ca̱quilhtamacú, y tíyat ama tatlaná cani̱huá ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","La̱ta jaé tú na̱cxilá̱tit ta̱kxtakajni cajcú ixquilhtzúcut tú ama min a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Caj quilacata lhu̱hua ama ca̱si̱tzi̱niyá̱n hasta pa̱t ca̱ma̱kxtakajni̱caná̱tit y ca̱makni̱caná̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Amá quilhtamacú lhu̱hua ama ca̱tzanka̱ní li̱camama natali̱pa̱huán Dios, y ama tara̱si̱tzi̱ní hasta ta̱má̱n tara̱liakskahuinán y tara̱macama̱stá nac pu̱ma̱paksi̱n. ");
INSERT INTO topNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na̱ lhu̱hua akskahuinaní̱n lacchixcuhuí̱n ama tali̱chihui̱nán Dios xlacata naca̱li̱pa̱huancán y lhu̱hua ama tali̱pa̱huán ixtachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Makapitzi tí ama tali̱pa̱huán Dios ama tamakslihueké li̱xcájnit ixkasatcán cristianos y yaj ama tara̱lakalhamán. ");
INSERT INTO topNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero amá tí ni̱ tachokó y ta̱yaní hasta xní nati̱taxtukó jaé ni̱ lactlá̱n quilhtamacú namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Porque ixtapáksi̱t Dios ni̱ma̱ cma̱lacatzuqui̱ni̱t ama̱ca li̱chihui̱nancán ixli̱ti̱lanca ca̱quilhtamacú xlacata hua̱k cristianos natalakapasa ixtachihuí̱n Dios; y entonces ama lá spútut. ");
INSERT INTO topNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Aquit cca̱huaniyá̱n, acxni na̱cxilá̱tit kantaxtuma amá tú tzokli profeta Daniel la̱ tali̱chiyá ixpu̱lakachixcuhui̱cán Dios amá lacli̱xcájnit cristianos ni̱ma̱ ta̱má̱n tamín xala mákat (¡Tla̱n cakáxmatli tí li̱kalhtahuakama tú li̱chihuí̱nalh Jesús!), ");
INSERT INTO topNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","tí talama̱na nac pu̱latama̱n Judea catatzá̱lalh nac ca̱lacsipijni y nac ca̱quihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tí ta̱cxtuni̱t nahuán ixakstí̱n ixchic, ¡catzá̱lalh la̱ta yá y ni̱tú camá̱xtulh; ");
INSERT INTO topNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","y amá tí ani̱t ixca̱tucuxtu ni̱ calaktáspitli ixlháka̱t! ");
INSERT INTO topNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Koxitaní̱n lacchaján tí takalhí nahuán itskatacán y ya̱ talakahuán, o tatziquijcú; snu̱n ama ta̱kxtakajnán! ");
INSERT INTO topNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Camaksquíntit Dios ni̱ caca̱lakchá̱n jaé ta̱kxtakajni acxni lonknán, o aktum quilhtamacú hua̱k jaxpa̱nántit nahuán. ");
INSERT INTO topNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque pa̱t maklhcatzi̱yá̱tit ta̱kxtakajni la̱ ni̱ma̱ ni̱cxni ca̱ma̱kxtakajni̱ni̱t Dios ixcamán, ni̱ para ama mimpará ta̱kxtakajni la̱ amá ni̱ma̱ pa̱t acxilá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dios ma̱ctzuhui̱ni̱t jaé ixquilhta ta̱kxtakajni xlacata natataxtuní tí xlá ca̱lacsacni̱t pues para ni̱ chú ixtláhualh hua̱k cristianos ixtalaktzanka̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Amá quilhtamacú para tí ca̱huaniyá̱n xlacata Cristo chini̱t nac aktum pu̱latama̱n o mini̱t latamá nac aktum ca̱chiquí̱n, huixín ni̱ caca̱najlátit. ");
INSERT INTO topNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porque ama talactaxtú lacchixcuhuí̱n tí natahuán xlacán Cristo, y makapitzi jaé lacchixcuhuí̱n ama tali̱tanú tali̱chihui̱nán Dios, y ama tali̱ma̱lacahua̱ní cristianos laclanca tascújut xlacata tla̱n nata̱kskahuí hasta amá tí ca̱lacsacni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aquit tla̱n cca̱lacspi̱tnimá̱n tú ama qui̱taxtú jaé quilhtamacú, ");
INSERT INTO topNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","y para tí ca̱kskahuiputuná̱n y ca̱huaniyá̱n: “Cristo taspitni̱t y chihui̱nampu̱lá nac desierto”, huixín ni̱ capítit acxilá̱tit; y para tí ca̱huaniyá̱n: “Cristo chini̱t y tatze̱kni̱t nac aktum ákxtaka”, huixín ni̱ caca̱najlátit. ");
INSERT INTO topNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Aquit cca̱huaniyá̱n, acxni nacmín ixli̱maktuy cama tasí la̱ acxni jilí y maklipa cani̱huá lacacha̱nkó, chuná aquit Xatalacsacni Chixcú ama̱ca qui̱cxilhcán ixli̱ti̱lanca ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chuná li̱tum ama̱ca quintalakapascán la̱ acxni ní tantum quitzistanca hua̱k chu̱n ixacstucán tatamakstoka. ");
INSERT INTO topNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’La̱ nakantaxtukó jaé ta̱kxtakajni ni̱ma̱ cca̱li̱ta̱chihui̱nán chichiní yaj ama ma̱xkake̱nán, papá yaj ama lacahua̱nán ca̱tzisní, stacu ama tatasí la̱ ama tapa̱tastá, y la̱ta tú anán ixli̱ti̱lanca ca̱quilhtamacú na̱ ama tatatlaná acxni naquinta̱cxila nacmín ixli̱maktuy ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nac akapún ama tasí la̱ aquit Xatalacsacni Chixcú cama taxtuya̱chi, y hua̱k cristianos xala ca̱quilhtamacú acxni naquinta̱cxila la̱ cta̱ctama nac akapú̱n y la̱ ixli̱lanca ckalhí quili̱tlihueke y quili̱ma̱paksí̱n, ama tzucú tatasá la̱ta tali̱puhuán tú tatlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Entonces cani̱huá ama takaxmatí la̱ macahuán amá lanca ixtrompeta Dios acxni aquit cama ca̱li̱ma̱paksí ángeles catama̱mákstokli hua̱k ixcamán Dios tí ca̱lacsacni̱t la̱ta hua̱k ixli̱ti̱lanca ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Huixín tla̱n ca̱cxílhtit tú pa̱xtoka akatum suja, acxni akayujni̱t y tzucú taxtuní laksnapanka ixpakán huixín tancs catzi̱yá̱tit xlacata yaj maka̱s ama lacatzucú ixquilhta lhca̱cna. ");
INSERT INTO topNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pues aquit cca̱huaniyá̱n, acxni na̱cxilá̱tit natzucú kantaxtú la̱ta tú cca̱li̱ma̱kalhchihui̱ní̱n cacatzí̱tit xlacata yaj maka̱s tzanká nactaspita ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Xli̱ca̱na cca̱huaniyá̱n, jaé tú cca̱li̱ta̱chihui̱nán hua̱k ama kantaxtú ya̱ para tani̱kó nahuán cristianos xala jaé quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ca̱quilhtamacú y akapú̱n ama laktzanká, pero quintachihuí̱n ni̱ ama laktzanká hasta xní nakantaxtukó tú cca̱huanín. ");
INSERT INTO topNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Pero ni̱tí catzí tucu yá hora ama lakchá̱n jaé chichiní, ni̱ para ángeles, ni̱ para aquit Ixkahuasa Dios; huata Quinti̱cú catzí tucu yá quilhtamacú nalá spútut ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Acxni aquit Xatalacsacni Chixcú nacmín ixli̱maktuy lhu̱hua ama tapa̱xtoka la̱ ca̱qui̱taxtúnilh amá cristianos tí ixtalama̱na acxni latáma̱lh Noé. ");
INSERT INTO topNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Amá quilhtamacú acxni ya̱ ixkantaxtú amá spútut ni̱tú ixtali̱puhuán y ma̱s chá ixtatamakaxtoka ixtali̱pa̱xahuá tú ixtakalhí. ");
INSERT INTO topNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pero acxni lákcha̱lh spútut quilhpa̱xtum tani̱ko̱lh, y acxni na̱ nacmín aquit Xatalacsacni Chixcú lhu̱hua aktziyaj cama ca̱lakchín porque ni̱ taca̱najlani̱t tú cli̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Amá quilhtamacú para cha̱tuy lacchixcuhuí̱n acxtum tascujma̱na ixca̱tucuxtucán cha̱tum ama̱ca makxtakcán y xa̱cha̱tum ama̱ca lakma̱xtucán. ");
INSERT INTO topNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Para cha̱tuy lacchaján tasquitima̱na cha̱tum ama̱ca lakma̱xtucán y xa̱cha̱tum ama̱ca makxtakcán. ");
INSERT INTO topNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Aquit camá̱n ca̱ma̱macqui̱yá̱n tú mili̱tlahuatcán, ¡siempre skálalh calatapá̱tit porque ni̱ catzi̱yá̱tit xnicu cama ca̱lakchiná̱n aquit Mimpu̱chinacán! ");
INSERT INTO topNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Huixín skálalh calatapá̱tit la̱ cha̱tum chixcú tí skálalh lhtatá xlacata ni̱ natatanú kalha̱naní̱n, porque para aktziyaj tachipá kalha̱naní̱n tla̱n tamakkalha̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Acxni aquit Xatalacsacni Chixcú nacmín ixli̱maktuy ni̱tí aktziyaj cma̱noklhuputún; huá cca̱li̱huaniyá̱n, ni̱ ca̱ktzonksuátit tú cca̱huanín, ¡skálalh catahuilátit! ");
INSERT INTO topNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Aquit clacasquín camakslihuekétit amá tasa̱cua tí makxtaka ixpatrón nac ixchic xlacata naca̱ma̱huí y naca̱cuentaja ixcamán y xa̱makapitzi ixtasa̱cua. ");
INSERT INTO topNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","¡Snu̱n cama li̱pa̱xahuá namá cristiano tí nacma̱noklhú tlahuama tú cli̱ma̱páksi̱lh! ");
INSERT INTO topNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tancs cma̱lacnu̱ní cama macama̱xquí tú ckalhí xlacata xlá naquincuetajní, ");
INSERT INTO topNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","na̱ chuná la̱ amá patrón li̱pa̱xahuá tí kaxmatní tú li̱ma̱páksi̱lh ixtasa̱cua; pero para amá tasa̱cua li̱xcájnit ixkásat y puhuán ixpatrón ni̱ sok ama min, ");
INSERT INTO topNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","entonces tzucú ca̱ma̱kxtakajní xa̱makapitzi ixta̱tasa̱cua y xlá tzucú ca̱ta̱kachí y ca̱ta̱pa̱xahuá tí na̱ talaktzanka̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pero ni̱ para catzí acxni taspita ixpatrón y aktziyaj ma̱noklhú tú tlahuama. Xlá castigartlahuá pues ni̱ káxmatli tú li̱ma̱páksi̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","¡Koxitaní̱n huixín para na̱ chuná cca̱ma̱noklhuyá̱n! Porque pa̱t ca̱macapincaná̱tit nac puakxtakajni, y aná pa̱t tasayá̱tit y tatlanca̱ni̱yá̱tit la̱ta li̱puhuaná̱tit tú tlahuátit. ");
INSERT INTO topNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Amá quilhtamacú acxni nacmimpará ixli̱maktuy lhu̱hua ama ca̱qui̱taxtuní la̱ jaé cha̱cá̱u lactzumaján ni̱ma̱ ca̱huanica nataán tamakskoyutiyá cha̱tum kahuasa ni̱ma̱ ixama tamakaxtoka. ");
INSERT INTO topNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Cha̱quitzis akspitaj ixtalama̱na, la̱ tama̱tzamako̱lh ixlámparajcán táli̱lh gas aparte xlacata naca̱li̱skalhcán para ixlako̱lh nac tijia. Xa̱makapitzi takalhí̱n ixtahuani̱t porque ni̱ táli̱lh gas aparte para ixtamakasputa nac tijia. ");
INSERT INTO topNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Amá xalí̱i̱t kahuasa makapálalh ni̱ sok chilh, y amá lactzumaján talhtátalh lacapunchú. ");
INSERT INTO topNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lacatzú tzi̱sa makapitzi cristianos tzúculh ta̱ktasá: “¡Mimajá namá kahuasa tí ama tamakaxtoka, capítit lakapa̱xtoká̱tit!” ");
INSERT INTO topNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hua̱k amá lactzumaján lacapala tatá̱qui̱lh y tzúculh tla̱n tama̱tzamá ixpu̱skoncán. ");
INSERT INTO topNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero amá cha̱quitzis tí ni̱tú ixtali̱mín tahuánilh xa̱makapitzi: “Quila̱ma̱squihuí̱u actzú gas porque quilámparajcán tamixma̱najá y yaj talacahua̱nán.” ");
INSERT INTO topNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Xlacán takalhtí̱nalh: “Ni̱ ama quinca̱ccha̱niyá̱n para cca̱ma̱xqui̱yá̱n, mejor capítit tama̱huayá̱tit ana ní sta̱cán.” ");
INSERT INTO topNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Amá takalhi̱ní̱n lactzumaján táalh talacaputzá gas y ya̱ para ixtachín acxni chilh xalí̱i̱t kahuasa y xa̱makapitzi lactzumaján como tla̱n ixtaca̱xtlahuani̱t ixlámparajcán tamakskoyúli̱lh amá kahuasa y tatánu̱lh nac ákxtaka ní ixtlahuama̱ca fiesta y ma̱lacchahuaca puhui̱lhta. ");
INSERT INTO topNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Acxni táchilh xa̱makapitzi lactzumaján, tzúculh talakatlaka puhui̱lhta; ixtahuán: “¡Señor, señor, quila̱ma̱lacqui̱níu!” ");
INSERT INTO topNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero amá kahuasa ca̱kálhti̱lh: “Ni̱ lá cca̱ma̱lacqui̱niyá̱n porque ni̱ cca̱lakapasá̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","La̱ ca̱huaniko̱lh jaé takalhchihuí̱n Jesús ca̱huanipá: ―Aquit cca̱li̱lacspi̱tnín jaé takalhchihuí̱n la̱ mili̱latama̱tcán. ¡Skálalh catahuilátit porque ni̱ catzi̱yá̱tit tucu yá hora o tucu yá chichiní aquit Xatalacsacni Chixcú cama ca̱lakchiná̱n ixli̱maktuy ca̱quilhtamacú! ");
INSERT INTO topNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Amá quilhtamacú makapitzi ama ca̱qui̱taxtuní la̱ ixtasa̱cua cha̱tum patrón tí an paxia̱lhnán mákat pu̱latama̱n, pero antes nataxtú ca̱tasánilh ixtasa̱cua y ca̱má̱xqui̱lh cha̱tunu tumi̱n xlacata natama̱scujuní y natama̱stacaní. ");
INSERT INTO topNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Cha̱tum má̱xqui̱lh akquitzis mi̱lh tumi̱n, cha̱tum má̱xqui̱lh aktuy mi̱lh tumi̱n y xa̱cha̱tum má̱xqui̱lh aktum mi̱lh tumi̱n, pues cha̱tunu ixca̱lakapasa la̱ ixtascuja. La̱ ca̱ta̱lacca̱xlako̱lh ixtasa̱cua amá chixcú alh paxia̱lhnán la̱ ixlaclhca̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Amá tí maklhtí̱nalh akquitzis mi̱lh tumi̱n tzúculh tama̱huanán y tláhualh negocio, chuná tlájalh akquitzis mi̱lh li̱huacá. ");
INSERT INTO topNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amá tí maklhtí̱nalh aktuy mi̱lh na̱ ma̱scújulh y tlájalh pi̱ta chuná li̱tum. ");
INSERT INTO topNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero amá tí maklhtí̱nalh aktum mi̱lh ni̱ ma̱scújulh huata cá̱huaxli ca̱tiyatni y aná múju̱lh ixtumi̱n ixpatrón xlacata ni̱ natzanká. ");
INSERT INTO topNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Pasárlalh quilhtamacú y maktum amá patrón tí ixani̱t paxia̱lhnán qui̱táspitli y tuncán ca̱tasánilh ixtasa̱cua xlacata naca̱ta̱tlahuá taxokó̱n. ");
INSERT INTO topNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Amá tí maklhtí̱nalh akquitzis mi̱lh tumi̱n ixtlajani̱t li̱huacá huánilh ixpatrón: “Señor, huix quima̱xqui akquitzis mi̱lh, chí uchu huí a̱kquitzis mi̱lh li̱huacá ni̱ma̱ ctlajani̱t la̱ta cma̱scújulh mintumi̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kalhtí̱nalh ixpatrón: “¡Clakatí mintascújut! Huix tali̱pa̱u tasa̱cua pues caj actzú cma̱xquí̱n y huix ma̱stacani̱ta quintumi̱n; camá̱n ma̱xqui̱yá̱n ma̱s lhu̱hua xlacata naquimaktakalhniya. Chí catanu nac quínchic xlacata acxtum nali̱pa̱xahuayá̱u mintascújut.” ");
INSERT INTO topNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Acxni tocárli̱lh amá tí maklhtí̱nalh aktuy mi̱lh huánilh ixpatrón: “Señor, huix quima̱xqui aktuy mi̱lh, chí uchu huí aktuy mi̱lh li̱huacá ni̱ma̱ ctlajani̱t.” ");
INSERT INTO topNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kálhti̱lh ixpatrón: “¡Snu̱n cli̱pa̱xahuayá̱n! Huix tali̱pa̱u tasa̱cua pues caj actzú cma̱xquí̱n y huix li̱tlajani̱ta quintumi̱n; camá̱n ma̱xqui̱yá̱n ma̱s xlacata naquima̱scujuniya. Pero chí catanu nac quínchic xlacata acxtum napa̱xahuayá̱u.” ");
INSERT INTO topNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ixli̱puntzú na̱ chilh amá tí ixmaklhti̱nani̱t aktum mi̱lh tumi̱n, xlá huánilh ixpatrón: “Señor, aquit ccatzí xlacata huix lakati̱ya akchipaya y ta̱tamakxtaka tú ni̱ li̱scujni̱ta, y para xactitlájalh na̱ ixquintímaklhti. ");
INSERT INTO topNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Huá xlacata cli̱má̱qui̱lh mintumi̱n, uchu huí mintumi̱n ni̱ma̱ quima̱xqui, ni̱tú tzanká ni̱ para macstum.” ");
INSERT INTO topNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Amá patrón kálhti̱lh: “¡Takalhí̱n tasa̱cua! Para ixcatzi̱ya aquit cta̱tamakxtaka y cakchipá tú ni̱ cli̱scujni̱t, ");
INSERT INTO topNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","pues ixtima̱nu quintumi̱n nac banco xlacata acxni xactiqui̱táspitli ixquintima̱xqui xaskata ni̱ma̱ tlajani̱t.” ");
INSERT INTO topNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amá patrón li̱ma̱paksí̱nalh: “¡Camaklhtí̱tit jaé chixcú namá tumi̱n ni̱ma̱ chipani̱t y cama̱xquí̱tit tí kalhí akcá̱u mi̱lh! ");
INSERT INTO topNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque tí kalhi̱yá tú maclacasquín ma̱s ama̱ca ma̱xqui̱cán xlacata nakalhta̱xtuní, pero tí caj actzú kalhí ama̱ca maklhti̱cán hasta tú ixli̱skalhma̱ca. ");
INSERT INTO topNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y jaé chixcú camacapítit ní naxoko̱nán ixli̱takalhí̱n; aná ama tasá y tatlanca̱ní la̱ta li̱puhuán tú tlahuani̱t.” ");
INSERT INTO topNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Amá quilhtamacú acxni nacmimpará ixli̱maktuy, aquit Xatalacsacni Chixcú cama tahuilá nac quimpu̱ma̱paksi̱n la̱ cha̱tum rey hua̱k ángeles ama quintali̱tamakspita; ");
INSERT INTO topNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","y cristianos xala ca̱quilhtamacú ama quintalakchín nac quilacatí̱n. Aquit pu̱tuy cama ca̱ma̱pitzí hua̱k cristianos, tí takaxmatni̱t quintachihuí̱n, y tí takaxmatmakani̱t, nacca̱tlahuá na̱ chuná la̱ cha̱tum chixcú tí pu̱tum ca̱macá̱n ixborregos y pu̱tum ca̱macá̱n chivos. ");
INSERT INTO topNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pu̱tum cristianos tí ixtakaxmatni̱t quintachihuí̱n cama ca̱macá̱n pakán nac quimpakca̱na, y xa̱pu̱tum tí ni̱ takaxmatni̱t quintachihuí̱n cama ca̱macá̱n pakán nac quimpakxuiqui. ");
INSERT INTO topNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Amá pu̱tum cristianos tí taya̱na pakán quimpakca̱na cama ca̱huaní: “Capa̱xahuátit huixín tí ca̱lacsacni̱tán Quinti̱cú pues chí pa̱t tanu̱yá̱tit nac mimpu̱tahui̱lhcán ni̱ma̱ ca̱li̱kalhi̱ni̱tán la̱ta titláhualh ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Acxni ctzincsli huixín quila̱ma̱huí̱u; acxni ckálhtilh huixín quila̱ma̱kotí̱u; acxni xacaktzanka̱ni̱t huixín quila̱ta̱maklhtatáu. ");
INSERT INTO topNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Acxni ni̱ xakalhí quilháka̱t huixín quila̱ma̱squihuí̱u; acxni xacta̱tatlá y xactanu̱ma nac pu̱la̱chí̱n huixín quila̱lakpaxia̱lhnáu.” ");
INSERT INTO topNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Entonces amá tí takaxmatni̱t quintachihuí̱n ama quintakalasquiní: “Quimpu̱chinacán, ¿xnicu ixkalhtípa̱t y aquín cca̱ta̱kotnán? ");
INSERT INTO topNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Xnicu ixaktzanka̱ni̱ta y cca̱ta̱maklhtatán? ¿Xnicu ni̱ ixkalhi̱ya milháka̱t y cca̱ma̱squihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ni̱ para caksaná̱u, ¿xnicu ixta̱tatlaya o ixtanú̱pa̱t nac pu̱la̱chí̱n y aquín cca̱lakpaxia̱lhnán?” ");
INSERT INTO topNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Amá quilhtamacú aquit cama ca̱kalhtí: “Huixín ni̱ acxcatzí̱tit acxni quila̱makta̱yáu, pero la̱ta tú tlahuátit ixlacatacán amá quinata̱camán tí ni̱tú ixtakalhí ca̱quilhtamacú la̱ aquit quila̱makta̱yani̱táu y quila̱lakalhamani̱táu.” ");
INSERT INTO topNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Entonces cama talakaspita ní taya̱na amá pu̱tum cristianos nac quimpakxuiqui y cama ca̱huaní: “¡Huixín ni̱ quila̱ma̱lacatzuhuí̱u! Mimpu̱tahui̱lhcán na̱ ca̱xlani̱ttá, pa̱t ca̱ta̱xoko̱naná̱tit tlajaná xa̱huá tí tali̱scuja; xlacán tatlahuá tú ni̱ tla̱n y huixín ca̱makslihuekétit, pues chí cata̱látit ta̱kxtakajni tú ca̱lakcha̱má̱n. ");
INSERT INTO topNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aquit cca̱maksquín chau y ni̱ quila̱ma̱huí̱u; cca̱maksquín chúchut y ni̱ quila̱ta̱kotnáu; ");
INSERT INTO topNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","cmaksquín quila̱ta̱maklhtatáu acxni xacaktzanka̱ni̱t y quila̱pu̱tlakaxtúu cminchiccán; lako̱lh quilháka̱t y ni̱ quila̱ma̱xquí̱u; ctáma̱lh nac tama la̱ta xacta̱tatlá y quima̱nu̱ca nac pu̱la̱chí̱n y huixín ni̱ quila̱lakpaxia̱lhnáu.” ");
INSERT INTO topNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Xlacán ama quintakalhtí: “Quimpu̱chinacán, ¿xnicu ni̱ cca̱makta̱yán acxni huix istzíncspa̱t, ixkalhtípa̱t, ixaktzanka̱ni̱ta, ni̱ ixkalhi̱ya milháka̱t, ixta̱tatlaya, ixtanú̱pa̱t nac pu̱la̱chí̱n? Ni̱ para tziná caksaná̱u acxni cca̱lakatza̱lán.” ");
INSERT INTO topNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aquit cama ca̱kalhtí: “Makatunu xní ca̱lakatza̱látit amá quinata̱camán tí ixtalacasquín caca̱makta̱yátit aquit quila̱lakmakáu.” ");
INSERT INTO topNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jaé cristianos ama̱ca ca̱maca̱ncán nac puakxtakajni ní taxoko̱nama̱na nahuán cani̱cxnihuá quilhtamacú; y tí takaxmatni̱t quintachihuí̱n ama tatahuilá ixpu̱tahui̱lhcán nac akapú̱n ana ní natalatamá hua̱k namina̱chá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","La̱ ca̱huaniko̱lh Jesús jaé laclanca talacapa̱stacni, xlá ca̱ma̱lacapa̱stácalh ixdiscípulos ");
INSERT INTO topNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","xlacata istzanká aktuy chichiní natlahuacán li̱lakachixcuhui̱n xla ixpa̱xcuajcán judíos ni̱ma̱ ixtama̱kantaxtí ca̱ta ca̱ta, y pi̱ huá amá chichiní xlá ixama̱ca macama̱sta̱cán ixmacancán ixenemigos ixama̱ca makni̱cán nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesús tancs ixquilhcha̱ni̱t porque nac ixlacaquilhti̱n ixchic lihua xapuxcu cura Caifás ixtatamakstokni̱t xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos y lactali̱pa̱u ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Xlacán talacchihuí̱nalh la̱ nataliakskahuinán xlacata natama̱nú nac pu̱la̱chí̱n y tla̱n natamakní. ");
INSERT INTO topNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Huata ixca̱tzanka̱ní natalaclhcá tuya chichiní pues ixtahuán: ―Ni̱ cachipahuí la̱ta jaé cha̱ma tacuhui̱ní xla quimpa̱xcuajcán porque tla̱n tasi̱tzí y tamaklhti̱nán cristianos tí tali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús alh lakpaxia̱lhnán Simón amá tí tima̱ksá̱ni̱lh acxni ixkalhí lepra, xlá ixlama nac Betania. ");
INSERT INTO topNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aná ta̱hualhtataca, y la̱ta ixua̱yama cha̱tum pusca̱t ma̱lacatzúhui̱lh, ma̱kálhke̱lh aktum frasco perfume lhu̱hua ixtapalh ixuani̱t, y tzúculh acuilí nac ixakxa̱ka amá perfume. ");
INSERT INTO topNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ixdiscípulos ni̱ tama̱tlá̱ni̱lh tú tláhualh jaé pusca̱t, tasí̱tzi̱lh y tachihuí̱nalh: ―¿Hua̱nchi pa̱xcat tlahuaca namá perfume? ");
INSERT INTO topNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma̱s tla̱n ixtísta̱lh y xatumi̱n ixtica̱li̱maktá̱yalh pobres. ");
INSERT INTO topNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús hua̱k ixcatzí tú ixtachihui̱nama̱na y huá ca̱li̱huánilh: ―¿Hua̱nchi hua̱k li̱chihui̱naná̱tit? Tú tláhualh jaé pusca̱t aquit cma̱tla̱ní, ");
INSERT INTO topNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","porque pobres siempre ca̱ta̱lapa̱nántit nahuán, y aquit yaj maka̱s camá̱n ca̱ta̱latama̱yá̱n ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Xa̱huá jaé perfume ni̱ma̱ quimacuíli̱lh jaé pusca̱t ama quimacuaní xlacata naquimuju̱cán. ");
INSERT INTO topNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na̱ cca̱huaniyá̱n acxni nali̱chihui̱nancán ixtachihuí̱n Dios cani̱huá ca̱quilhtamacú na̱ ama̱ca li̱chihui̱nancán tú tláhualh quilacata jaé pusca̱t xlacata siempre naaksancán. ");
INSERT INTO topNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote cha̱tum ixdiscípulo tí na̱ ixli̱lhca̱ni̱t nata̱scuja Jesús acxni ca̱lácsacli ixcha̱cu̱tuycán, alh ca̱ta̱chihui̱nán xanapuxcun curas la̱ naca̱macama̱xquí, ");
INSERT INTO topNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y ca̱kalasquínilh: ―¿Niculá naquila̱xokoniyá̱u para cca̱macama̱xqui̱yá̱n Jesús? ―Macpuxumacá̱u tumi̱n xla plata ―takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Xlá ma̱tlá̱ni̱lh y la̱ maklhtí̱nalh tzúculh lacputzá lihua xnicu tla̱n namacama̱stá Jesús ixmacán ixenemigos. ");
INSERT INTO topNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Amá xla̱huán chichiní acxni ixtatzucú talakachixcuhui̱nán judíos nac xatacuhui̱ní pa̱xcua, ixtahuá simi̱ta la̱ta ni̱ kalhí levadura; ixdiscípulos Jesús takalasquínilh: ―¿Nicu lacasquina nacca̱xtlahuayá̱u li̱hualhtata jaé pa̱xcua tú nali̱lakachixcuhui̱nanáu jaé ca̱tzisni? ");
INSERT INTO topNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ca̱kálhti̱lh Jesús: ―Capítit nac ixchic cha̱tum chixcú ni̱ma̱ cca̱li̱ta̱chihui̱nani̱tán y cahuanítit xlacata mimaestrojcán yaj lhu̱hua quilhtamacú ama latamá y ca̱ta̱hualhtataputún ixdiscípulos nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Xlacán takáxmatli tú ca̱li̱ma̱páksi̱lh Jesús y aná taca̱xtláhualh tú natahualhtatá amá pa̱xcua. ");
INSERT INTO topNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ixli̱ca̱tzisní xlá ca̱ta̱tahuilako̱lh ixdiscípulos y tzúculh tahualhtatá; ");
INSERT INTO topNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","y la̱ta ixtahua̱yama̱na ca̱huánilh: ―Aquit ccatzí xlacata cha̱tum la̱ta mili̱hua̱kcán ama quiliakskahuinán. ");
INSERT INTO topNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Acxni takáxmatli la̱ ixli̱chihui̱nán Jesús cha̱tum ixama liakskahuinán xlacán talakaputzako̱lh y tzúculh takalasquiní cha̱tum cha̱tum: ―Quimpu̱chinacán Jesús, ¿cha̱ aquit cama liakskahuinaná̱n? ");
INSERT INTO topNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Xlá ca̱kálhti̱lh cha̱tunu: ―Tí ama quiliakskahuinán huá tí lakxtum quinta̱tiyá tahuá nac pula̱tu. ");
INSERT INTO topNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chí lakcha̱ni̱t quilhtamacú ni̱ma̱ tali̱chihui̱nani̱t profetas nac Escrituras la̱ ama̱ca makni̱cán Xatalacsacni Chixcú, pero ¡koxitá tí ama quimacama̱stá! Ma̱s ixtimacuánilh ni̱cxni ixtilakáhualh. ");
INSERT INTO topNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Entonces Judas tí ixma̱lacnu̱ni̱ttá namacama̱stá ixmaestro tíyalh li̱camama y na̱ kalasquínilh: ―Maestro, ¿aquit amá tí ama liakskahuinaná̱n? ―Jé, huix namá chixcú ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","La̱ta ya̱ ixtahualhtatakó Jesús tíyalh mactum simi̱ta, pa̱xcatcatzí̱nilh Dios, lakchékelh, y acxni ca̱má̱xqui̱lh ixdiscípulos ca̱huánilh: ―Camaklhti̱nántit jaé simi̱ta y cahuátit porque huá namá quimacni. ");
INSERT INTO topNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chuná li̱tum tíyalh aktum lanca vaso ni̱ma̱ ixtaju̱ma ixchúchut uva, pa̱xcatcatzí̱nilh Dios y acxni ca̱ma̱kalhuá̱ni̱lh ixdiscípulos ca̱huánilh: ―Cakóttit jaé ixchúchut uva ");
INSERT INTO topNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","porque huá namá quinkalhni ni̱ma̱ cama ma̱stajá milacatacán xlacata nama̱luloka Dios tlahuani̱t sa̱sti ixtalacca̱xlán la̱ naca̱lakma̱xtú cristianos. Aquit cama ma̱stajá quinkalhni xlacata nacxoko̱nán hua̱k ixtala̱kalhi̱ncán lhu̱hua cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chí cca̱huaniyá̱n, ya̱cxni camá̱n ca̱ta̱hua̱yán ixchúchut uva hasta nachipiná̱tit ixpu̱táhui̱lh Quinti̱cú nac akapú̱n nacca̱ta̱huaparayá̱n tunuj yaj la̱ jaé. ");
INSERT INTO topNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","La̱ tahualhtatako̱lh tatlí̱nilh Dios aktum alabanza y a̱stá̱n táalh aná ní ixtajaxa nac Cerro de los Olivos. ");
INSERT INTO topNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aná Jesús ca̱huánilh hua̱k ixdiscípulos: ―Jaé ca̱tzisní ama ta̱kahuaní mintalacapa̱stacnicán caj quilacata, ¡ni̱ ama qui̱taxtú la̱ ixlacpuhuaná̱tit! Porque nac Escrituras huan: “Cama li̱makxtaka camakni̱ca tí ixca̱maktakalha borregos y xlacán ama tatza̱lakó cani̱huá.” ");
INSERT INTO topNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero acxni naclacastacuanán ca̱li̱ni̱n pu̱la cama cha̱n nac Galilea xlacata aná natanoklha̱chá̱u. ");
INSERT INTO topNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro kálhi̱lh Jesús: ―Para xa̱makapitzi ta̱kxtakmakaná̱n aquit ni̱cxni cama lakmakaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús tancs kálhti̱lh: ―Pedro, ni̱ catzi̱ya tú chihui̱námpa̱t porque pi̱huá jaé ca̱tzisní acxni ya̱ tasaj nahuán tantum pu̱yu, huix ni̱ pa̱t quinkalhtasi̱ya maktutu tí nakalasquiniyá̱n quilacata. ");
INSERT INTO topNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","―Ma̱squi caquimakni̱ca caj milacata ni̱cxni cama huan ni̱ clakapasá̱n ―kalhtí̱nalh Pedro. Y xa̱makapitzi ixdiscípulos na̱ chuná tama̱lacnú̱nilh ixmaestrojcán. ");
INSERT INTO topNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús ca̱tá̱alh ixdiscípulos ma̱s tziná lakamákat lacatum ní ixuanicán Getsemaní; aná ca̱huánilh: ―Juú catamakxtáktit, aquit cama kalhtahuakaní Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Huata Pedro y amá cha̱tuy ixlakkahuasán Zebedeo Jacobo y Juan ca̱tá̱alh. Jesús tzúculh akatuyún, ixnacú ixakxtakajnán la̱ta ixli̱puhuán tú ixlakcha̱ma. ");
INSERT INTO topNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ca̱huánilh ixdiscípulos: ―¡Yaj lá cta̱lá ta̱kxtakajni nac quinacú! ¡Snu̱n clakaputzá la̱mpara cni̱majá ccatzí! Juú catamakxtáktit, ni̱ calhtatátit. ");
INSERT INTO topNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Xlá alh tziná lakamákat; aná tatzokóstalh hasta talacátalh ca̱tiyatni y kalhtahuakánilh Dios: ―Ta̱ta, para ma̱tla̱ni̱ya quilakma̱xtu ni̱ nackota namá ta̱kxtakajni ni̱ma clakcha̱ma; pero ni̱ clacasquín calalh quintapuhuá̱n, huix catlahua tú catzi̱ya ma̱s quimacuaní. ");
INSERT INTO topNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Astá̱n ca̱lákalh ní ixtahuila̱na cha̱tutu ixdiscípulos, xlacán ixtalhtatama̱na. Entonces huánilh Pedro: ―Pedro, ¿hua̱nchi huixín ni̱ ta̱yanítit ni̱ lhtatayá̱tit ca̱na aktum hora huitiyá? ");
INSERT INTO topNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Calacastacuanántit y cakalhtahuakanítit Dios xlacata ni̱ natatlaji̱yá̱tit y naca̱makatlajayá̱n tlajaná. Porque ma̱squi miespiritucán ti̱tum ya̱huani̱t ixtalacapa̱stacni, mimacnicán ni̱ ta̱yaní y ni̱ tuhua makatlajacán. ");
INSERT INTO topNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús ampá kalhtahuakaní Dios: ―Ta̱ta, para ni̱ lacasquina nactaxtuní jaé ta̱kxtakajni ni̱ma̱ clakcha̱ma, catlahua quilacata tú laclhca̱ni̱ta. ");
INSERT INTO topNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Xlá ca̱laktaspitpá ixdiscípulos y la̱tiyá ixtalhtatama̱na porque yaj lá ixtalacata̱lá ixtatalakatzí ixlakastapucán. ");
INSERT INTO topNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesús yaj tú ca̱huánilh y ampá kalhtahuakaní Dios, y pi̱ta chuná huánilh la̱ ixkalhtahuakani̱t xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ixli̱maktutu qui̱táspitli ca̱huánilh ixdiscípulos: ―Chí tla̱n lhtatayá̱tit xlacata najaxá̱tit porque accha̱ni̱t quilhtamacú aquit Xatalacsacni Chixcú ama̱ca quimacama̱sta̱cán ixmacancán ni̱ lactla̱n cristianos. ");
INSERT INTO topNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Tó! Mejor ni̱ catapá̱tit; cata̱yátit tuncán porque nachú mimajá namá tí ama quimacama̱stá. ");
INSERT INTO topNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Chu̱ta ya̱ tla̱n ixchihui̱nankó acxni lakápasli cha̱tum ixdiscípulo Judas Iscariote; ixca̱cpuxcuni̱t lhu̱hua cristianos tí ixtali̱mín espadas, quihui y catu̱huá li̱makni̱n; ixtama̱lakacha̱ni̱t xanapuxcun curas tí ixca̱ta̱lacca̱xlani̱t xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas ixca̱huanini̱t xlacata ixmaestro tí ixama macama̱stá pu̱la ixama lacaspu̱ta xlacata nalakapascán y nachipacán. ");
INSERT INTO topNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huata ácxilhli Jesús Judas ma̱lacatzúhui̱lh, lacáspu̱tli y huánilh: ―Maestro, ¿tucu tlahuápa̱t? ");
INSERT INTO topNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kálhti̱lh: ―Amigo, cama̱kantaxti tuncán tú ma̱lacnu. ");
INSERT INTO topNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Makapitzi tama̱lacatzúhui̱lh Jesús y tatzáksalh tachipá pero cha̱tum ixdiscípulo kalhpú̱xtulh ixespada y ca̱ctí̱nilh ixtaké̱n ixtasa̱cuacán xanapuxcun curas. ");
INSERT INTO topNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pero li̱ma̱páksi̱lh Jesús: ―¡Cama̱kalhpu̱nu miespada, porque amá tí li̱makni̱nán espada, na̱ espada li̱makni̱cán! ");
INSERT INTO topNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xa̱huá huix ni̱ catzi̱ya xlacata tla̱n xacmáksquilh Quinti̱cú pu̱cu̱tuy ángeles tí naquintamaklhti̱nán, y xlá tuncán ixquima̱lakachá̱nilh. ");
INSERT INTO topNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero para chuná xactláhualh ni̱ ixkantáxtulh tú tatzokni̱t quilacata nac Escrituras cama akspulá. ");
INSERT INTO topNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Astá̱n ca̱ta̱chihuí̱nalh amá cristianos: ―¿A poco quila̱li̱maca̱ná̱u cha̱tum kalha̱ná o makni̱ná? ¿Hua̱nchi li̱taná̱tit quihui y espadas? Cha̱li cha̱lí xacca̱ma̱kalhchihui̱ni̱yá̱n ixlacaquilhti̱n pu̱siculan y ni̱ quila̱chipáu. ");
INSERT INTO topNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero chuná jaé ma̱kantaxti̱yá̱tit tú tatzokni̱t profetas quilacata. La̱ ca̱ta̱chihui̱nanko̱lh amá lacchixcuhuí̱n tachípalh Jesús. Ixdiscípulos hua̱k tatza̱lako̱lh cani̱huá y ta̱kxtakmákalh ixmaestrojcán. ");
INSERT INTO topNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Xlacán táli̱lh nac ixpu̱ma̱paksí̱n xapuxcu cura Caifás; aná ixtatamakstokni̱t hua̱k ixma̱kalhtahuake̱nacán judíos y xalactali̱pa̱u lakko̱lún ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro tze̱k ixtakokeni̱t la̱ta ní li̱nca Jesús, y acxni cha̱lh nac ixlacaquilhti̱n ixpu̱ma̱paksí̱n Caifás tamákxtakli ní ixtalaya̱na soldados pues ixcatzi̱putún tú ixama pa̱xtoka ixmaestro. ");
INSERT INTO topNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Amá xanapuxcun curas, xanapuxcun ma̱paksi̱naní̱n y xalactali̱pa̱u lakko̱lún tí pu̱tum ixtali̱tapa̱cuhuí Junta Suprema tzúculh taputzá cristianos tí nataliakskahuinán Jesús xlacata tla̱n natali̱ya̱huá tala̱kalhí̱n y natamakní. ");
INSERT INTO topNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lhu̱hua lacchixcuhuí̱n tatalácnu̱lh y taliakskahuínalh, pero ni̱ lá ixtama̱luloka ixtachihui̱ncán. Nac ixpu̱latama̱ncán judíos huata ixtaca̱najlá tú ixtahuán acxtum cha̱tuy cristianos. Ixli̱puntzú cha̱tuy taliakskahuínalh: ");
INSERT INTO topNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","―Jaé chixcú huá maktum xlacata tla̱n ixlactláhualh ixpu̱siculan Dios ixliaktutu chichiní tlahuako̱ni̱t tunuj xasa̱sti. ");
INSERT INTO topNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Amá xapuxcu cura tuncán tá̱yalh y kalasquínilh: ―¿Xli̱ca̱na tú tahuán jaé lacchixcuhuí̱n? ¿Huix huanti namá tachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús la̱ ni̱ cakáxmatli, ni̱tú kálhti̱lh. Amá xapuxcu cura huanipá: ―Dios xastacnán calhcuyuya̱huán para quila̱kskahuiyá̱u, quila̱huaníu, ¿xli̱ca̱na huix Cristo Ixkahuasa Dios? ");
INSERT INTO topNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ca̱kálhti̱lh Jesús: ―Jé, aquit Cristo Ixkahuasa Dios. Y na̱ cca̱huaniyán xlacata huixín pa̱t acxilá̱tit la̱ aquit Xatalacsacni Chixcú cama tahuilá nac ixpa̱xtú̱n ixpu̱ma̱paksi̱n Dios nac akapú̱n, y ma̱squi ni̱ ca̱najlayá̱tit ama cha̱n quilhtamacú acxni nacta̱ctapará nac akapú̱n y nacmimpará ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Amá chixcú la̱ta sí̱tzi̱lh pá̱xti̱tli ixlháka̱t ixacstu y ca̱huánilh ixcompañeros: ―¡Jaé chixcú chiyani̱t! Huixín kaxpatni̱tántit la̱ ta̱ra̱lacata̱qui̱ni̱t y ta̱talacastuca Dios Ixti̱cú. ¿Tucu yá taputzá̱n ma̱s natlahuayá̱u? ¡Ixacstu talaksi̱ni̱t! ");
INSERT INTO topNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tucu tlahuaniyá̱u? ―¡Camakni̱ca! ¡Mini̱ní camakni̱ca! ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hua̱k tzúculh tali̱chiyá Jesús, talacachúcxui̱lh, ta̱kkáxilh, talakakáxilh. ");
INSERT INTO topNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y xlacata ma̱s natali̱kalhkama̱nán ixtahuaní: ―Para huix xli̱ca̱na Cristo, caquilhchipi ¿ticu ma̱xquí̱n? ");
INSERT INTO topNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro curucs ixuí nac lacaquilhti̱n ní ixtamakxtakni̱t; aná ma̱lacatzúhui̱lh cha̱tum squití y huánilh: ―Huix na̱ ixta̱lapu̱laya Jesús xalac Galilea. ");
INSERT INTO topNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","―Aquit ni̱ clakapasa ticu namá chixcú ―kalhtí̱nalh Pedro, y hua̱k amá cristianos ixtakaxmatma̱na. ");
INSERT INTO topNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Astá̱n táxtulh nac quilhtí̱n, lihua ixcha̱majá nac puhui̱lhta acxni cha̱tum squití acxilhpá y ca̱huánilh xa̱makapitzi: ―Jaé chixcú na̱ ixta̱lapu̱lá namá Jesús xalac Nazaret. ");
INSERT INTO topNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro tzúculh li̱quilhán Dios xlacata xli̱ca̱na tú ixkalhti̱nama y ca̱huánilh: ―Aquit ni̱ clakapasa namá chixcú. ");
INSERT INTO topNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ixli̱puntzú makapitzi tí ixtalapu̱lá aná lacatzú tama̱lacatzúhui̱lh Pedro y tahuánilh: ―Xli̱ca̱na huix na̱ ixta̱lapu̱laya Jesús, hasta mintachihuí̱n tla̱n li̱lakapascana, huix xalac Galilea. ");
INSERT INTO topNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro ta̱klhú̱hui̱lh y tzúculh li̱quilhán Dios xlacata caca̱najlanica tancs ixchihui̱nama, ca̱huanipá: ―Aquit ni̱ clakapasa namá chixcú. Chu̱tacú ixkalhchiya̱nama acxni káxmatli la̱ tli̱lh tantum pu̱yu. ");
INSERT INTO topNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Acxni tuncán áksalh tú ixuanini̱t Jesús: “Acxni ya̱ tasaj nahuán tantum pu̱yu huix ni̱ pa̱t quinkalhtasi̱ya maktutu tí nakalasquiniyá̱n quilacata.” Pedro lacapala táxtulh y tásalh la̱ta li̱puhuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","2","Amá ca̱tzisní acxni tzúculh spalh ca̱huán hua̱k amá xanapuxcun curas y xalactali̱pa̱u lakko̱lún ma̱paksi̱naní̱n judíos tí ixtama̱kalhapali̱ni̱t Jesús tzúculh talacputzá la̱ nataliakskahuinán ixlacatí̱n Pilato xapuxcu ma̱paksi̱na romano; y la̱ talacchihui̱nanko̱lh táli̱lh nac ixpu̱ma̱paksí̱n xlacata xlá nali̱ma̱paksi̱nán la̱ namakni̱cán. ");
INSERT INTO topNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","4","Judas Iscariote tí ixmacama̱sta̱ni̱t, acxni cátzi̱lh la̱ ixli̱lhca̱cani̱t Jesús ama̱ca makni̱cán snu̱n lakapútzalh ca̱xtlahuapútulh tú ixtlahuani̱t; lacapala ca̱lákalh amá lacchixcuhuí̱n tí ixca̱ta̱lacca̱xlani̱t y ca̱huánilh: ―Cmima ca̱pu̱spitniyá̱n macpuxumacá̱u mintumi̱ncán ni̱ma̱ quila̱ma̱xquí̱u. Aquit cmacama̱sta̱ni̱t cha̱tum chixcú tí ni̱tú ixkásat, xlá ni̱tú li̱n. ¡Claktzanka̱ni̱t, ni̱ tla̱n tú ctlahuani̱t! ―Para tú laniya, namá aquín ni̱ quincuentajcán ―takálhti̱lh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas la̱ cachíyalh lhken máca̱lh amá tumi̱n pakán ní ixlakachixcuhui̱nancán nac pu̱siculan y tuncán táxtulh y alh lacatum ana ní ta̱kpíxchi̱lh ixacstu makni̱ca. ");
INSERT INTO topNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Amá xanapuxcun curas tásacli amá tumi̱n y tzúculh tara̱huaní: ―Jaé tumi̱n li̱tama̱huacani̱t ixli̱stacni cha̱tum chixcú, ni̱ camuju̱huí nac ixpu̱lakachixcuhui̱cán Dios porque naquinca̱li̱huanicaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","8","Mejor cali̱tama̱huahuí aktum ca̱quihuí̱n y aná ixcampusa̱ntujcán nahuán namá cristianos xala mákat tí tamín talakachixcuhui̱nán nac Jerusalén y juú taní. Xa̱makapitzi hua̱k tama̱tlá̱ni̱lh y tali̱tamá̱hualh aktum ca̱quihuí̱n ní istzamá li̱lhtámat ixli̱tapa̱cuhuí Campo del Alfarero y xlacán campúsa̱ntu tatláhualh y tali̱ma̱pa̱cúhui̱lh Campo de Sangre. Chú huanicán hasta la̱ta chí. ");
INSERT INTO topNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chuná jaé tama̱kantáxti̱lh tú istzokni̱t profeta Jeremías: “Amá tali̱pa̱u chixcú tí lhu̱hua ixtapalh kalhí, cristianos xalac Israel tahuilí̱nilh ixtapalh caj macpuxumacá̱u tumi̱n xla plata; ");
INSERT INTO topNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","y huá tali̱tama̱huánilh ixca̱quihuí̱n cha̱tum alfarero. Hua̱k Dios quihuánilh jaé tachihuí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Amá xanapuxcun ma̱paksi̱naní̱n talí̱cha̱lh Jesús ixlacatí̱n Pilato, y xlá kalasquínilh: ―¿Xli̱ca̱na huix rey xalac Israel? ―Jé, xli̱ca̱na aquit rey ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Entonces amá lacchixcuhuí̱n tzúculh taliakskahuinán Jesús ixlacatí̱n Pilato. Pero xlá ni̱ akstum tachihuí̱n kalhtí̱nalh tú ixtali̱ma̱lacapú. ");
INSERT INTO topNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Huá xlacata Pilato li̱huánilh: ―¿Hua̱nchi ni̱ kalhti̱nana? Cachihuí̱nanti. Jaé lacchixcuhuí̱n lhu̱hua tú tali̱ma̱lacapu̱má̱n. ");
INSERT INTO topNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús ma̱s chá acs tá̱yalh ni̱ ixchihui̱nán. Pilato ixca̱cní amá chixcú, xlá ni̱tú kalhti̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pilato ixli̱smani̱ni̱t makxtaka cha̱tum tachí̱n ni̱ma̱ ixtalacasquín cristianos amá xatacuhui̱ní pa̱xcua. ");
INSERT INTO topNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nac pu̱la̱chi̱n ixtanu̱ma cha̱tum li̱cuánit chixcú ixuanicán Barrabás. ");
INSERT INTO topNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Por eso acxni táchilh hua̱k cristianos y tatamákstokli ixlacatí̱n ixpu̱ma̱paksí̱n xlá ca̱kalasquínilh: ―¿Ticu lacasquiná̱tit cacmákxtakli: Barrabás, o Jesús tí li̱tanú rey xalac Israel? ");
INSERT INTO topNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato ixlakma̱xtuputún Jesús porque ixma̱kachakxi̱ni̱t xlacata ixenemigos ixtalakcatzaní ixtascújut, y huá ixtali̱ma̱lacapu̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Xlá ixuijcú nac itsilla ya̱ tú ixlacca̱xtlahuá acxni chilh cha̱tum tí milh huaní jaé ixtachihuí̱n ixpusca̱t: “Ni̱tú cali̱ya̱hua namá chixcú, xlá ni̱tú ixkásat; xa̱huá ca̱tzisní lhu̱hua tú quili̱ma̱ma̱níxni̱lh.” ");
INSERT INTO topNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amá xanapuxcun judíos acxni takáxmatli tú ca̱kalasquínilh Pilato hua̱k cristianos, tzúculh ta̱kastacya̱huá xlacata catahuánilh camákxtakli Barrabás y Jesús camakni̱ca. ");
INSERT INTO topNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato gobernador romano ca̱kalasquinipá ixli̱maktuy ticu ixtalacasquín camákxtakli, Barrabás o Jesús. Hua̱k cristianos ta̱ktásalh: ―Camákxtakti Barrabás. ");
INSERT INTO topNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","―¿Barrabás? ―ca̱kálhti̱lh Pilato―. Entonces, ¿tucu ctlahuaní Jesús tí li̱tanú rey xalac Israel? ―¡Camakni nac culu̱s! ―ta̱ktasako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―¿Hua̱nchi? ¿Tucu yá tala̱kalhí̱n tlahuani̱t? ―ca̱huánilh Pilato. Pero xlacán ma̱s ta̱ktásalh: ―¡Camakni nac culu̱s! ¡Camakni nac culu̱s! ");
INSERT INTO topNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato ma̱kachákxi̱lh xlacata tú ixlacpuhuani̱t ni̱ ixtaxtuni̱t pues hua̱k cristianos ixtasi̱tzi̱ma̱najá; huá xlacata li̱ma̱tiyí̱nalh aktum tina chúchut y acxni tzúculh makachaká ca̱huánilh: ―Para tú tlahuaniyá̱tit jaé chixcú, huixín amá̱n ca̱li̱tahuacayá̱n ixli̱stacni. Aquit ni̱ cama xoko̱nán porque ni̱tú cli̱ma̱lacapu̱ni̱t, ¡xlá ni̱ kalhí tala̱kalhí̱n! ");
INSERT INTO topNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xlacán takálhti̱lh: ―Aquín y quincamancán cli̱tanu̱yá̱u nacxokoniyá̱u tí naquinca̱li̱ya̱huayá̱n ixli̱stacni jaé chixcú. ");
INSERT INTO topNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilato mákxtakli Barrabás y li̱ma̱paksí̱nalh casnokca Jesús, a̱stá̱n ca̱macamá̱xqui̱lh soldados xlacata xlacán natamakní nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amá soldados romanos tali̱lh Jesús nac ixlacaquilhti̱n ixpu̱ma̱paksí̱n Pilato y tama̱mákstokli pu̱tum soldados. ");
INSERT INTO topNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xlacán tzúculh tali̱chiyá, tama̱lákxtulh ixlháka̱t y tahuilí̱nilh aktum tzutzoko lhma̱n lháka̱t la̱ xla rey. ");
INSERT INTO topNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Cha̱tum huilí̱nilh aktum corona xla lhtucú̱n y tama̱chípi̱lh kantum ká̱ti̱t la̱ xla rey. La̱ taca̱xya̱huako̱lh tzúculh tatazokostaní la̱ catalakachixcúhui̱lh cha̱tum rey y xlacata natali̱kalhkama̱nán ixtahuaní: ―Siempre calatáma̱lh ixreycán judíos. ");
INSERT INTO topNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Makapitzi ixtalacachucxuí, ixtamaklhtí amá ká̱ti̱t y pi̱huá ixtaliacma̱xquí. ");
INSERT INTO topNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","La̱ tali̱chiyako̱lh jaé soldados romanos tama̱xtúnilh amá lháka̱t ni̱ma̱ ixtahuili̱nini̱t y tama̱lhake̱pá lihua ixlháka̱t. ");
INSERT INTO topNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Astá̱n amá soldados tamá̱xtulh Jesús, tama̱cúqui̱lh ixculu̱s y táli̱lh pakán ní ixama tamakní. Ixtataxtuma̱najá ca̱chiquí̱n acxni talakapá̱xtokli cha̱tum ixuanicán Simón, xalac Cirene ixuani̱t y xafuerza tama̱lí̱ni̱lh ixculu̱s Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Acxni tacha̱lh lacatum ní ixuanicán Gólgota, jaé tachihuí̱n huamputún Ixpu̱latama̱n ixaclúcut Ni̱n. ");
INSERT INTO topNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ma̱lacnu̱nica Jesús cahualh chúchut la̱ cuchu ixuani̱t ixta̱tlahuacán li̱cuchu ni̱ma̱ ma̱kuitinán. Xlá kalhuá̱nalh pero ni̱ kotli. ");
INSERT INTO topNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Amá soldados ta̱kxtokohuácalh Jesús nac culu̱s y a̱stá̱n tzúculh tama̱kpitzí ixlháka̱t a ver neje nata̱tamakxtaka cha̱tunu. ");
INSERT INTO topNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","La̱ tama̱kpitziko̱lh ixlháka̱t Jesús curucs tatahui aná lacatzú xlacata natamaktakalha. ");
INSERT INTO topNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Nac ixakspú̱n ixculu̱s ixtatzokni̱t jaé tachihuí̱n tú xlacata ixli̱makni̱cani̱t: “Huá jaé Jesús ixreycán judíos.” ");
INSERT INTO topNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Cha̱tuy kalha̱naní̱n na̱ ca̱makni̱ca nac culu̱s amá quilhtamacú cha̱tunu ca̱ya̱huaca ixpa̱xtu̱ni̱tni Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Makapitzi tí ixtapasarlá aná lacatzú huata ixtama̱tzahuají ixakxa̱kacán, ixtali̱kalhkama̱nán: ");
INSERT INTO topNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―¿La̱mpara huana xlacata tla̱n lactlahuaya pu̱siculan ixliaktutu chichiní tlahuaya tunuj xasa̱sti? ¿Chí tucu lanípa̱t? ¿Hua̱nchi ni̱ lá lakma̱xtucana mi̱cstu? ¡Cata̱cta ní huaca para xli̱ca̱na huix Ixkahuasa Dios! ");
INSERT INTO topNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Xanapuxcun curas, xanapuxcun ma̱paksi̱naní̱n, ixma̱kalhtahuake̱nacán judíos y fariseos na̱ ixtali̱kalhkama̱nán: ");
INSERT INTO topNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Para tla̱n ca̱ma̱ksá̱ni̱lh xa̱makapitzi cristianos, chí, ¿hua̱nchi ni̱ lá lakma̱xtucán ixacstu? Para xli̱ca̱na huá rey tí ama quinca̱ma̱paksi̱yá̱n nac Israel, ¡catá̱ctalh nac culu̱s y aquín na̱ nali̱pa̱huaná ixtachihuí̱n! ");
INSERT INTO topNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ixli̱tanú Ixkahuasa Dios xlacata huata huá ixli̱pa̱huán, entonces chí, ¿hua̱nchi ni̱ min lakma̱xtú? ");
INSERT INTO topNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Amá kalha̱naní̱n tí ixca̱ma̱huacacani̱t ixpa̱xtu̱ni̱tni na̱ chuná ixtali̱kalhkama̱nán. ");
INSERT INTO topNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Amá chichiní acxni cha̱lh lacatastúnut, tapaklhtu̱tako̱lh ca̱quilhtamacú ixli̱ti̱lanca y qui̱tá̱yalh hasta maktutu hora xalakasmalankán. ");
INSERT INTO topNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Acxni tuncán Jesús aktásalh: ―Elí, Elí, ¿lama sabactani? ―huamputún: QuiDios, quiDios, ¿hua̱nchi quiakxtakmakani̱ta? ");
INSERT INTO topNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Makapitzi tí ixtahuila̱na aná lacatzú ni̱ tama̱kachákxi̱lh ixtachihuí̱n y tzúculh tara̱huaní: ―Cakaxpáttit la̱ ma̱tasi̱ma profeta Elías. ");
INSERT INTO topNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cha̱tum lacapala alh li̱ma̱cahuí xaxcuta vino aktum lháka̱t, ma̱kánu̱lh nac kantum ká̱ti̱t y ma̱lacatzuhuí̱nilh nac ixquilhni xlacata naquilhcahuá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero xa̱makapitzi tahuánilh: ―¡Cali̱makxtáktit! A ver para xli̱ca̱na profeta Elías min lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús ixli̱puntzú aktasapá ixli̱hua̱k ixtachihuí̱n y acxni tuncán ni̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huata láksputli Jesús, nac lanca pu̱siculan xla Jerusalén ana ní ixtalakachixcuhui̱nán curas ca̱ta ca̱ta, amá lanca li̱lakalhapá̱n ni̱ma ixtahuacani̱t ixacstu táxti̱tli, ¡tapacapítzilh la̱ta ta̱lhmá̱n hasta tu̱tzú! ¡Tíyat tzúculh tachiquí! ¡Lanca chíhuix tatáska̱lh! ");
INSERT INTO topNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lhu̱hua cristianos tí ixtani̱ni̱t maká̱n ixtali̱pa̱huani̱t Dios talacastacuánalh ca̱li̱ni̱n. ");
INSERT INTO topNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tatalácqui̱lh aná ní ixca̱muju̱cani̱t y acxni lacastacuánalh Jesús nac ca̱li̱ní̱n tatáxtulh nac campúsa̱ntu y taalh nac ca̱chiquí̱n xla Jerusalén; lhu̱hua cristianos tá̱cxilhli la̱ ixtalacastacuanani̱t. ");
INSERT INTO topNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Amá soldados tí ixtamaktakalhma̱na Jesús acxni tá̱cxilhli la̱ tatlanako̱lh tíyat y la̱ta tú qui̱táxtulh acxni ni̱ko̱lh Jesús snu̱n tajicuanko̱lh. Ixcapitancán chihuí̱nalh: ―¡Xli̱ca̱na jaé chixcú Ixkahuasa Dios! ");
INSERT INTO topNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Makapitzi lacchaján tí a̱huata tica̱ta̱táxtulh Jesús nac Galilea ixtaya̱na aná lacatzú ní ixmakni̱cani̱t Jesús y hua̱k ixta̱cxilhni̱t tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Amá lacchaján tí ma̱s ixtamakta̱yani̱t Jesús ixca̱huanicán María Magdalena, y tunuj María ixna̱najcán Jacobo y José, y tunuj pusca̱t ixta̱cha̱t Zebedeo. ");
INSERT INTO topNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Acxni lihua smalankánalh amá chichiní cha̱tum rico chixcú xalac Arimatea ixuanicán José alh ta̱chihui̱nán gobernador Pilato camá̱xqui̱lh li̱tlá̱n camá̱cti̱lh xaní̱n Jesús, y xlá ma̱tlá̱ni̱lh. José na̱ ixli̱pa̱huán ixtachihuí̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Xlá alh ma̱ctí Jesús nac culu̱s, ca̱xtrámi̱lh y li̱máksui̱tli aktum sa̱sti sábana. ");
INSERT INTO topNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Astá̱n má̱nu̱lh nac aktum ixpu̱ma̱nu̱cán ni̱n ni̱ma̱ ixlacahuaxcani̱t nac ixlacán chíhuix y ni̱ naj tí ixma̱nu̱cani̱t. La̱ ca̱xtrami̱ko̱lh Jesús li̱ma̱paksí̱nalh calacahuili̱ca ní ixlactanu̱cán aktum lanca chíhuix y tuncán alhá nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena y xa̱cha̱tum María ixtahuila̱na lacatzú ní ixma̱nu̱cani̱t Jesús y hua̱k ixta̱cxilhni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pi̱huá amá smalankán judíos ixtatlahuako̱ni̱t tahuá tú natali̱lakachixcuhui̱nán ixtacuhui̱ní pa̱xcua, y sábado acxni ni̱tí itscuja, amá xalactali̱pa̱u ma̱paksi̱naní̱n curas y fariseos talákalh gobernador Pilato ");
INSERT INTO topNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","y tahuánilh: ―Señor, amá akskahuiná chixcú acxni ixca̱ma̱kalhchihui̱ní cristianos ixuán ixama lacastacuanán ca̱li̱ní̱n ixliaktutu chichiní. ");
INSERT INTO topNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huá cli̱lacasquiná̱u caca̱ma̱lakacha soldados natamaktakalha ní ma̱nu̱cani̱t pues camá̱n sellartlahuayá̱u xlacata ni̱ natamín ixdiscípulos ca̱tzisní natakalhán xanín y a̱stá̱n natama̱kahuaní tachihuí̱n xlacata lacastacuánalh ca̱li̱ní̱n, y jaé ta̱kskahuí̱n ma̱s li̱xcájnit ixqui̱táxtulh que tú ixuán xapu̱lh ixmaestrojcán. ");
INSERT INTO topNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","―Pues cali̱pítit pu̱tum soldados y caca̱xtlahuátit la̱ min mintalacapa̱stacnicán ―ca̱kálhti̱lh Pilato. ");
INSERT INTO topNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xlacán táalh ní ixma̱nu̱cani̱t Jesús, tasellartláhualh y talakáchi̱lh amá chíhuix ni̱ma̱ ixli̱talakatalán ní ixlactanu̱cán, y aná tatamákxtali pu̱tum soldados tí natamaktakalhnán. ");
INSERT INTO topNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Amá chichiní domingo acxni tzúculh spalh ca̱huán, María Magdalena y xa̱cha̱tum María taalh aná ní ixma̱nu̱cani̱t Jesús; ");
INSERT INTO topNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","y ya̱ tla̱n ixtachá̱n acxni tachíquilh tíyat Dios ma̱lakácha̱lh cha̱tum ángel ní ixma̱nu̱cani̱t Jesús. Xlá ma̱ké̱nu̱lh chíhuix ni̱ma̱ ixli̱talakatalán y aná curucs tahui. ");
INSERT INTO topNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ixlacán ixlakskoy la̱ acxni maklipa, ixlháka̱t slipua ixuani̱t la̱ seda. ");
INSERT INTO topNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Amá soldados ca̱maka̱klhako̱lh tú ixta̱cxilhni̱t y la̱ xaní̱n tatahuilako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Amá ángel ca̱huánilh lacchaján tí ixta̱ni̱t ta̱cxila Jesús: ―Aquit ccatzí acxilhputuná̱tit Jesús tí makni̱ca nac culu̱s. ¡Ni̱ cajicuántit! ");
INSERT INTO topNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xlá ni̱ tanu̱ma juú ní ixma̱nu̱cani̱t pues lacastacuánalh ca̱li̱ní̱n la̱ ixca̱huanini̱tán. Catanú̱tit y ca̱cxílhtit ní ixtrami̱cani̱t, ¡ni̱tú má! ");
INSERT INTO topNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chí tuncán cataspíttit ní tahuila̱na ixdiscípulos y caca̱huanítit tú quili̱ma̱paksi̱cani̱t: “Xlá lacastacuanani̱t ca̱li̱ní̱n y lama xastacnán; chí amajá nac Galilea, aná ama ca̱kalhi̱yá̱n y naca̱cxilá̱n la̱ ixca̱huanini̱tán.” ");
INSERT INTO topNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amá lacchaján ixtajicuani̱t pero na̱ ixtapa̱xahuani̱t y tatza̱lh taalh talacaputzá ixdiscípulos Jesús xlacata natahuaní tú ixca̱li̱ma̱paksi̱ni̱t amá ángel. ");
INSERT INTO topNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","La̱ta ya̱ ixtachá̱n ixtatza̱lanama̱na Jesús ca̱li̱pa̱táxtulh nac tijia y ca̱huánilh kalhé̱n. Xlacán tatazokostánilh y talakachixcúhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús ca̱huanipá: ―Ni̱ cajicuántit y capítit ca̱huaniyá̱tit quinata̱camán tuncán catatá̱yalh nac tijia pakán nac Galilea; aná cama ca̱ta̱tamakstoka. ");
INSERT INTO topNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","La̱ taanko̱lh amá lacchaján makapitzi amá soldados tí ixtamaktakalhma̱na pu̱taju̱n na̱ lacapala táalh nac Jerusalén y tali̱ma̱kalhchihuí̱ni̱lh xanapuxcun curas la̱ta tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xlacán tama̱makstokko̱lh lakko̱lún ma̱paksi̱naní̱n y talacchihuí̱nalh. Hua̱k tama̱tlá̱ni̱lh catamá̱xqui̱lh tumi̱n soldados ");
INSERT INTO topNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","xlacata natahuán ta̱clhtataalh ca̱tzisní y ni̱ para tacátzi̱lh acxni támilh ixdiscípulos Jesús y táli̱lh xaní̱n. Hua̱k caxokonica nata̱kskahuinán. ");
INSERT INTO topNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Na̱ tama̱lácnu̱lh para xní ixcatzí Pilato amá ta̱kskahuí̱n, xlacán ixama talacati̱ta̱yá y tamaklhti̱nán ni̱tú naca̱tlahuanicán amá soldados. ");
INSERT INTO topNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","La̱ tamaklhtí̱nalh ixtumi̱ncán tzúculh tama̱kahuaní cani̱huá amá ta̱kskahuín y lhu̱hua judíos taca̱najlá hasta la̱ta chí. ");
INSERT INTO topNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ixdiscípulos táalh nac Galilea y tácha̱lh nac aktum sipi ní ixca̱li̱ma̱paksi̱ni̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús ca̱tasí̱nilh ixdiscípulos y acxni tá̱cxilhli xlacán talakachixcúhui̱lh ma̱squi makapitzi ni̱ tla̱n ixtaca̱najlaputún para xlá ixlama xastacnán. ");
INSERT INTO topNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ca̱ma̱lacatzúhui̱lh hua̱k ixdiscípulos y chuné ca̱ta̱chihuí̱nalh: ―Dios quimacama̱xqui̱lhá hua̱k ixtapáksi̱t ca̱quilhtamacú y nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chí cca̱li̱ma̱paksi̱yá̱n capítit ixli̱ti̱lanca ca̱quilhtamacú, caca̱li̱ta̱chihui̱nántit hua̱k cristianos la̱ tancs naquintali̱pa̱huán; caca̱liakmunútit nac ixtapáksi̱t Quinti̱cú, nac ixtapáksi̱t Ixkahuasa, y nac ixtapáksi̱t Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Caca̱li̱ma̱paksí̱tit cristianos catakáxmatli y catatláhualh hua̱k ixtapáksi̱t. Huixín ni̱tú cali̱puhuántit porque camá̱n ca̱maktakalhá̱n cha̱li cha̱lí hasta xní nalakó ca̱quilhtamacú. Chuná calalh, amén.");
INSERT INTO topNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Chuná jaé li̱quilhtzucú la̱ta tú tláhualh y la̱ta tú má̱si̱lh nac ixtachihuí̱n Jesucristo Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Cha̱tum ixquilhcha̱na ixtalacpuhuá̱n Dios huanicán profeta Isaías ma̱lacpuhuá̱ni̱lh Dios xlacata catzokli la̱ ixama latamá cha̱tum lanca chixcú y chuné ma̱cxcatzí̱ni̱lh: Pu̱la cama ma̱lakachá cha̱tum chixcú xlacata napu̱laniyá̱n y xlá naca̱xtlahuaniyá̱n tijia ní pa̱t lactla̱huana. ");
INSERT INTO topNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nac desierto ama takaxmatí la̱ aktasá acxni ma̱kalhchihui̱ni̱nán cha̱tum chixcú: “Catacá̱xtit, tancs calatapá̱tit, ti̱tum catrapí̱tit ixtijia milatama̱tcán, pues mima ca̱lakpaxia̱lhnaná̱n Mimpu̱chinacán.” ");
INSERT INTO topNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chuná jaé hua̱k qui̱táxtulh la̱ ixtatzokni̱t porque a̱stá̱n milh ca̱quilhtamacú Juan Bautista; xlá tzúculh ca̱ma̱kalhchihui̱ní cristianos nac desierto xlacata natalakxta̱palí ixlatama̱tcán ni̱ma̱ ixtakalhí y natata̱kmunú, y chuná Dios tla̱n naca̱ma̱tzanke̱naní la̱ta tú ni̱ tla̱n ixtlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tí ixtaxapaputún ixtala̱kalhi̱ncán ixli̱hua̱k ixnacujcán xlá ixca̱kmunú nac kalhtu̱choko huanicán Jordán. Ixtaán takaxmata Juan lhu̱hua cristianos xala ca̱chiquí̱n xla Jerusalén y tí ixtalama̱na nac pu̱latama̱n huanicán Judea. ");
INSERT INTO topNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ixlháka̱t Juan ixli̱tlahuani̱t ixmakxu̱hua camello, na̱ ixli̱tampu̱lakchi̱cani̱t aktum cinturón xla xu̱hua; ixli̱hua̱yán táxca̱t xala ca̱quihuí̱n y lactzu̱ xtuqui ni̱ma̱ ixca̱taka̱sa. ");
INSERT INTO topNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Acxni ixca̱ma̱kalhchihui̱ní cristianos, chuné ixca̱huaní: ―Amajá chin cha̱tum tí snu̱n lanca chixcú y ma̱s kalhí ixli̱tlihueke que ni̱ siquiera cma̱ta̱xtuca ixtasa̱cua nacuán tí nackatxcuta nacma̱xtuní ixtatu̱nu. ");
INSERT INTO topNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Aquit huata cmini̱t ca̱xtlahuaní ixtijia y huá cca̱liakmunuyá̱n chúchut, pero xlá amá̱n ca̱liakmunuyá̱n ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na̱ pi̱huá amá quilhtamacú Jesús taxtutá̱qui̱lh ixca̱chiquí̱n Nazaret ni̱ma̱ ixli̱tapaksí Galilea y lákalh Juan Bautista xlacata na̱kmunú, y chuná amá Juan akmúnulh nac kalhtu̱choko Jordán. ");
INSERT INTO topNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pero acxni ixtacutma nac ixquilhtú̱n ácxilhli la̱ talácqui̱lh akapú̱n y tá̱ctalh ixespíritu Dios la̱ tantum paloma y akchipako̱lh ixtalacapa̱stacni Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Entonces takaxmáti̱lh ixtachihuí̱n Dios nac akapú̱n y chuné ta̱chihuí̱nalh: ―Huix Quinkahuasa ni̱ma̱ clakalhamán y snu̱n cli̱pa̱xahuá la̱ ckalhi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","La̱ ta̱kmunuko̱lh Jesús Espíritu Santo ma̱cxcatzí̱ni̱lh caalh latamá nac desierto. ");
INSERT INTO topNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aná latáma̱lh ti̱puxum chichiní ixacstu, huata laclanca la̱páni̱t ixtalakmín. Tlajaná na̱ chuná tzúculh li̱cxila ixtapuhuá̱n para tla̱n nama̱tlahuí tala̱kalhí̱n. Pero Jesús siempre makatlájalh, y a̱stá̱n talákmilh ángeles xalac akapú̱n y talakachixcúhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ni̱ ixli̱maka̱s Juan Bautista ma̱nu̱ca nac pu̱la̱chi̱n, entonces Jesús táspitli nac Galilea xlacata naca̱lakatza̱lá lactzu̱ ca̱chiquí̱n y tla̱n naca̱li̱ta̱chihui̱nán cristianos la̱ Dios ixma̱lacatzuqui̱putún ixtapáksi̱t nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chuné tzúculh ca̱ma̱kalhchihui̱ní: ―Calakxta̱palí̱tit milatama̱tcán y caca̱najlátit ixtachihuí̱n Dios porque accha̱ni̱t quilhtamacú y talacatzuhui̱ma chichiní acxni Dios ama kantaxtú la̱ ma̱paksi̱namputún nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Maktum quilhtamacú Jesús ixtla̱huama ixquilhtu̱n pupunú xla Galilea acxni cá̱cxilhli cha̱tuy chakananí̱n tamuju̱ma̱na tza̱lh tachipama̱na tamakní, cha̱tum huanicán Simón y ixta̱cam huanicán Andrés. ");
INSERT INTO topNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús ca̱huánilh: ―Huixín ixchipanani̱n tamakní, quila̱takokéu y aquit nacca̱ma̱si̱niyá̱n la̱ ca̱chipacán cristianos tí ta̱ktzanka̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Xlacán ni̱ para tla̱n takaxmatko̱lh, uyu ta̱kxtakmákalh ixtza̱lhcán y tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús tatla̱huampá a̱laktzú y ca̱cxilhpá ixlakkahuasán Zebedeo, ixca̱huanicán Jacobo y Juan; ixtata̱taju̱ma̱na ixti̱cucán nac barco, talakaxtokoma̱na istza̱lhcán ni̱ma̱ ixtapu̱chakanán. ");
INSERT INTO topNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús na̱ ca̱huánilh catatakókelh, y na̱ chuná ni̱ para tla̱n talacpúhualh ta̱kxtakmákalh ixti̱cucán y ixtasa̱cua nac barco y tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tácha̱lh aktum ca̱chiquí̱n huanicán Capernaum y acxni ni̱tí itscuja Jesús alh ca̱ma̱kalhchihui̱ní cristianos nac ixpu̱tamakstoknican judíos huanicán sinagoga. ");
INSERT INTO topNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ca̱ta̱chihuí̱nalh la̱ cha̱tum lanca chixcú ni̱ma̱ pucuta kalhí tapáksi̱t, y la̱ takaxmatko̱lh ixtachihuí̱n ni̱ ixtacatzí tú natahuán pues la̱ta tú ixca̱li̱ma̱paksi̱ni̱t ixca̱huanini̱t la̱ tí xli̱ca̱na ma̱ccha̱ní talacapa̱stacni y ni̱ la̱ xa̱makapitzi tí na̱ ixtama̱sí ixtachihuín Dios nac ixpu̱tamakstoknicán. ");
INSERT INTO topNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na̱ aná ixtanu̱ma cha̱tum chixcú tí ixactanu̱ma ixespíritu tlajaná. Jaé li̱xcájnit talacapa̱stacni tzúculh ma̱lacpuhua̱ní xlacata cama̱ktási̱lh Jesús y chuné huánilh: ");
INSERT INTO topNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús xalac Nazaret, ¡capit a̱lacatunu! ¿Hua̱nchi tani̱ta quila̱paktanu̱ya̱u juú? Huix tani̱ta quila̱lactlahuayá̱u porque aquit clakapasá̱n y ccatzí xlacata Dios lacsacni̱tán nali̱scuja. ");
INSERT INTO topNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús ca̱tasi̱tzi ta̱chihuí̱nalh amá tí ixma̱lacpuhua̱ní tlajaná: ―¡Acs cata̱ya huix tlajaná, y camactaxtu namá chixcú! ");
INSERT INTO topNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Amá ixespíritu tlajaná ma̱kuítilh amá chixcú pero mactáxtulh aktasama la̱ cachíyalh. ");
INSERT INTO topNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Hua̱k cristianos tajicuanko̱lh acxni tá̱cxilhli tú pá̱xtokli. Tzúculh tara̱huaní entre xlacán: ―¿Tucu jaé qui̱taxtú? ¿Tucu yá sa̱sti tacatzí̱n jaé? ¡Jaé chixcú tla̱n ca̱ma̱paksí tlajananí̱n y takaxmatní! ");
INSERT INTO topNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Chuná amá lhu̱hua cristianos xalac Galilea tzúculh tali̱chihui̱nán la̱ta tú ixtlahuá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Acxni tatáxtulh amá nac sinagoga, Jesús ca̱tá̱alh Jacobo y Juan nac ixchiccán Simón y Andrés. ");
INSERT INTO topNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Li̱ta̱chihui̱nanca Jesús xlacata ixpuhuiticha̱t Simón ta̱tatlá ke̱tá nac tama porque kalhí palha lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús lákalh ana ní ixmá, makachípalh má̱qui̱lh lakasu̱t y tuncan mákxtakli lhcúya̱t amá cha̱t. Uyu sok tá̱qui̱lh y tzúculh tlahuá tú naca̱ta̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Acxni istzucuma tapaklhtu̱tá amá chichiní li̱minica Jesús lhu̱hua ta̱tatlaní̱n na̱ chuná tí ixca̱ctanu̱ma ixespíritu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lhu̱hua cristianos xala amá ca̱chiquí̱n támilh hasta yaj lá ixtatanu̱kó nac ixchic Simón. ");
INSERT INTO topNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús ca̱ma̱ksa̱ni̱ko̱lh hua̱k la̱ta tú yá tá̱tat ixtakalhí, y na̱ chú ca̱cmá̱xtulh cristianos tí ixca̱ma̱lacpuhua̱ní ixespíritu tlajaná. Pero acxni ixtataxtú Jesús ni̱ ixca̱ma̱xquí quilhtamacú natachihui̱nán amá tlajananí̱n porque xlacán ixtacatzí ticu yá chixcú ixuani̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Acxni ya̱ itxkaká amá ca̱tzisní chu̱tacú ixpaklhtutá Jesús tá̱qui̱lh y alh kalhtahuakaní Dios nac quilhapá̱n amá ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Acxni tá̱qui̱lh Simón y xa̱makapitzi tí ixtata̱lapu̱layá Jesús talacapútzalh cani̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Acxni taqui̱táka̱sli chuné tahuánilh: ―Lhu̱hua cristianos taputzamá̱n ta̱cxilhputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesús ca̱kálhti̱lh: ―Chí ama̱na aná̱u a̱lacatunu ca̱lacchiquí̱n ni̱ma̱ tahuila̱na juú lacatzú xlacata na̱ tla̱n nacca̱li̱ta̱chihui̱nán Dios amá cristianos porque huá xlacata aquit cli̱mini̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Chuná amá Jesús lakatza̱lako̱lh ca̱lacchiquí̱n xalac Galilea. Acxni ixchá̱n aktum ca̱chiquí̱n ixtanú nac sinagoga y aná ixli̱chihui̱nán Dios, na̱ chuná ca̱ma̱ksá̱ni̱lh tí ixca̱ctanu̱ma ixespiritucán tlajananí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Maktum talacatzúhui̱lh ní ixyá Jesús cha̱tum chixcú ixkalhí lepra tá̱tat. Acxni lákchilh tatzokostánilh y chuné ta̱chihuí̱nalh: ―Ccatzí xlacata tla̱n quincuchi̱ya, para lacasquina caquima̱ksa̱ni. ");
INSERT INTO topNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús lakalhámalh, huilí̱nilh ixmacán nac ixmacni y chuné kálhti̱lh: ―Clacasquín, ca̱ksá̱nanti tuncán. ");
INSERT INTO topNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","La̱ chihui̱nanko̱lh, amá chixcú tuncan mákxtakli ixtá̱tat y tla̱n aksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Acxni ixamajá Jesús li̱ma̱páksi̱lh: ");
INSERT INTO topNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ni̱tí cali̱ma̱kalhchihui̱ni la̱ aksa̱nani̱ta, huata pu̱la capit putzaya cha̱tum cura xlacata na̱cxilá̱n, y na̱ cama̱xqui mili̱lakachixcuhui̱n la̱ huani̱t Moisés ixli̱ma̱sta̱tcán acxni ta̱ksa̱nán tí takalhí namá tá̱tat, y xa̱huá chuná cati̱huá yaj najicuaniyá̱n nama̱lacatzuhui̱yá̱n porque yaj kalhi̱yá̱n tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amá chixcú alh, pero tzúculh ca̱li̱ta̱kalhchihui̱nán cati̱huá la̱ ixaksa̱nani̱t. Huá jaé xlacata a̱stá̱n Jesús yaj lá ixtanú aktum ca̱chiquí̱n ní istzamacán porque tuncan ixlakapascán, mejor ixtamakxtaka nac quilhapa̱n ca̱chiquí̱n ana ní ni̱ ixlama lhu̱hua cristianos. Pero latiyá ixtamín takaxmata lhu̱hua xala cani̱hua̱ ca̱lacchiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ni̱ tapasá̱rlalh lhu̱hua chichiní Jesús taspitpá nac Capernaum y acxni tacátzi̱lh cristianos xlacata xlá ixchimparani̱t nac ixchic ");
INSERT INTO topNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","lhu̱hua támilh ta̱cxila, y yaj lá tatanu̱ko̱lh ni̱ para ixlacaquilhti̱n ákxtaka; pero Jesús ca̱ma̱sí̱nilh ixtachihui̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Chu̱tacú ixchihui̱nama acxni táchilh cha̱ta̱ti lacchixcuhuí̱n tacucali̱mín cha̱tum chixcú ni̱ lá tla̱huán porque ixlaclu̱nchu̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Como snu̱n istzamacán ni̱ lá tapasá̱rlalh. Tú tatláhualh mejor tatá̱cxtulh ixaksti̱n ákxtaka, a̱ksti̱má̱cti̱lh ti̱tzú xachíhuix y aná talacmá̱cti̱lh amá ta̱tatlá nac aktum camilla y tamá̱pi̱lh lihua ní ixyá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Acxni cá̱cxilhli Jesús xlacata xli̱ca̱na ixtali̱pa̱huán ixtachihuí̱n, ixtapuhuán huá tla̱n nama̱ksa̱ní amá chixcú chuné huánilh: ―Hua̱k mintala̱kalhí̱n aquit cma̱tzanke̱naniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Makapitzi ixma̱kalhtahuake̱nacan judíos aná ixtaya̱na y acxni takáxmatli ixtachihuí̱n Jesús chuné talacpuhua: ");
INSERT INTO topNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Hua̱nchi chú chihui̱nán jaé chixcú? Li̱kalhkama̱nama tara̱lacata̱qui̱ma Dios, porque ni̱ huí cristiano tí tla̱n ma̱tzanke̱nán tala̱kalhí̱n y huata Quinti̱cucán Dios tla̱n chuná nahuán.” ");
INSERT INTO topNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús acxcátzi̱lh tú tze̱k ixtalacpuhuama̱na y chuné ca̱huánilh: ―¿Hua̱nchi lacpuhuaná̱tit xlacata ni̱ lá cma̱tzanke̱nán tala̱kalhí̱n? ");
INSERT INTO topNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Quila̱huaníu, ¿tucu ma̱s tuhua ma̱kantaxti̱cán: huanicán cha̱tum chixcú: “Hua̱k mintalakalhí̱n cma̱tzanke̱naniyá̱n”, o huanicán: “Cata̱qui, casacti mincamilla y catlá̱huanti”? ");
INSERT INTO topNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aquit Xatalacsacni Chixcú camá̱n ca̱li̱ma̱lacahua̱ni̱yá̱n ixli̱tlihueke quintachihuí̱n, para cma̱ksa̱ní jaé chixcú entonces na̱ ckalhí li̱ma̱paksí̱n cma̱tzanke̱nán tala̱kalhí̱n ca̱quilhtamacú. Jesús huanipá amá ta̱tatlá: ");
INSERT INTO topNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Aquit cli̱ma̱paksi̱yá̱n, cata̱qui, casacti mincamilla y capit nac mínchic. ");
INSERT INTO topNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Amá chixcú tá̱qui̱lh, sacli ixcamilla ní ixpu̱li̱mincani̱t y táxtulh la̱ta hua̱k ta̱cxilhko̱ma̱na. Lhu̱hua cristianos tapa̱xahuako̱lh y talakachixcúhui̱lh Dios. Ixtahuán entre xlacán: ―Ni̱cxni ixacxilhni̱táu tú acxilhma̱náu jaé quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","A̱stá̱n Jesús ampá ixquilhtu̱n pupunú Galilea; lhu̱hua cristianos talákcha̱lh aná y xlá tzúculh ca̱ma̱kalhchihui̱ní. ");
INSERT INTO topNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Acxni ixtaspitma ácxilhli ixkahuasa Alfeo huanicán Leví, ixuí nac tijia ca̱ma̱taji̱ma tí talakaxokó impuestos; Jesús huánilh: ―Huix na̱ caquintakoke ana ní cama an. Entonces Leví ni̱ ma̱s tú lacpúhualh y na̱ tuncan takókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús alh hua̱yán nac ixchic Leví, xlá ca̱tá̱alh ixdiscípulos, y ana ní ca̱ma̱hui̱ca na̱ támilh tahua̱yán lhu̱hua tí ni̱ ixca̱cxilhputuncán ixma̱lakaxoke̱naní̱n tumi̱n, na̱ chuná lhu̱hua tí ixtalaktzanka̱ni̱t y ni̱tú ixca̱li̱cxilhcán. ");
INSERT INTO topNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Makapitzi ixma̱kalhtahuake̱nacan judíos y fariseos acxni tá̱cxilhli tí ixca̱ta̱hua̱yama Jesús ni̱ ma̱tlá̱ni̱lh y huá tali̱huánilh ixdiscípulos: ―¿Como chí huixín mima̱kalhtahuake̱nacán ca̱ta̱hua̱yán ixma̱lakaxoke̱nani̱n tumi̱n y tí talaktzanka̱ni̱t? ");
INSERT INTO topNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús ca̱káxmatli tú ixtaquilhuama̱na y chuné ca̱ta̱chihuí̱nalh amá lacchixcuhuí̱n: ―Aquit cca̱ta̱talakxtumí porque huata tamaclacasquín doctor tí takalhí tá̱tat, y tí tapuhuán ni̱ ta̱tatlá y tla̱n talama̱na ni̱ tamaclacasquín cuchi̱ná. Aquit cca̱lakmini̱t tí takalhí tala̱kalhí̱n xlacata natalakxta̱palí ixlatama̱tcán, y ni̱ cca̱lakmini̱t tí catzí tla̱n talama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maktum quilhtamacú acxni ixta̱má̱n takatxtaknán fariseos y tí ixtakaxmatni̱t ixtachihuí̱n Juan Bautista, makapitzi talákmilh Jesús y takalasquínilh: ―¿Hua̱nchi tí takaxmatni̱t tú ca̱li̱ma̱páksi̱lh Juan Bautista y na̱ chuná fariseos takatxtaknán jaé chichiní, y tí huix takokeyá̱n ni̱ takatxtaknán? ");
INSERT INTO topNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús ca̱kálhti̱lh: ―¿Puhuaná̱tit huixín ca̱mini̱ní natakatxtaknán tí ca̱huanicani̱t nataán nac aktum pu̱tamakáxtokni mientras aná ca̱ta̱lahui xalí̱i̱t kahuasa? Ni̱ capuhuántit xlacata amá kahuasa nama̱tla̱ní tí nakatxtaknán o ni̱ nahua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero nachá̱n quilhtamacú nalakó fiesta y amá kahuasa naán a̱lacatunu, na̱ chuná la̱ aquit cama akspulá, entonces na̱ natakatxtaknán ma̱squi ni̱tí caca̱li̱ma̱páksi̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Porque tí kaxmata tú aquit cli̱chihui̱nán y quili̱pa̱huán, na̱ chuné qui̱taxtú quintama̱sí̱n: Ni̱ huí cristiano tí lakuilí aktum aklhchú luxu con actzú sa̱sti lháka̱t, porque acxni tachaké, tla̱n ma̱s lanca talacaxti̱ta que la̱ xapu̱lh ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na̱ chuná ni̱ lá muju̱cán pulque acxni tlihuekema nac aklhchú ixmakxu̱hua borrego porque tla̱n pa̱panka y laktzanká ixmakxu̱hua borrego y pulque. Huá xlacata mini̱ní siempre muju̱cán sa̱sti pulque nac sa̱sti ixmakxu̱hua borrego. ");
INSERT INTO topNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aktum chichiní acxni hua̱k ixjaxcán Jesús ixca̱ta̱tla̱huama ixdiscípulos nac ca̱tucuxtu ixpu̱chancán trigo. Xlacán tzúculh taquí ixtahuácat la̱ta tatla̱huama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Makapitzi fariseos tí aná ixtalapu̱lá ca̱ma̱nóklhulh y chuné tahuánilh Jesús: ―Amá, cá̱cxilhti. ¿Como chí midiscípulos taqui̱ma̱na ixtahuácat trigo jaé quilhtamacú acxni ni̱ quili̱scujutcán? ");
INSERT INTO topNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús ca̱kálhti̱lh: ―¿Huixín ni̱cxni li̱kalhtahuakani̱tántit tú tláhualh rey David maktum quilhtamacú acxni ca̱tá̱tzincxli ixcompañeros? ");
INSERT INTO topNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Mili̱catzi̱tcán xlacata rey David tánu̱lh nac pu̱siculan, tíyalh tasicuna̱tlau simita ni̱ma̱ huata tla̱n ixtahuá curas, pero xlá ca̱ta̱huako̱lh ixcompañeros. Jaé quilhtamacú ixca̱puxcún cha̱tum cura ni̱ma̱ ixuanicán Abiatar. ");
INSERT INTO topNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús ca̱huanipá: ―Dios li̱ma̱paksí̱nalh jaé chichiní xlacata natajaxa cristianos y naca̱macuaní, ni̱ xlacata nata̱kxtakajnán jaé quilhtamacú para tú tamaclacasquiní ixli̱tlahuatcán. ");
INSERT INTO topNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Huá xlacata aquit Xatalacsacni Chixcú na̱ ckalhí tapáksi̱t nacca̱huaní natatlahuá cristianos tú ma̱s ca̱mini̱ní jaé quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Maktum quilhtamacú acxni ixjaxcán Jesús tanu̱pá nac sinagoga ca̱ma̱kalhchihui̱ní cristianos. Na̱ aná ixtanu̱ma cha̱tum chixcú, itsca̱cko̱ni̱t ixmacán ni̱ lá tú ixli̱tlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ixenemigos ixtatzucuni̱ttá tascalí Jesús para huí tí nama̱ksa̱ní amá chichiní acxni hua̱k ixli̱huancán tí tú nali̱scuja, y chuná xlacán tla̱n tú natali̱ma̱lacapú. ");
INSERT INTO topNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús acxcátzi̱lh y ta̱chihuí̱nalh amá chixcú tí ixmacasca̱cko̱ni̱t: ―Cata̱ya xlacata hua̱k cristianos nata̱cxilá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tí ixtascali̱ma̱na chuné ca̱ta̱chihuí̱nalh: ―¿Tucu puhuaná̱tit ma̱s macuán tlahuacán jaé chichiní acxni hua̱k li̱huancán tí nascuja? ¿Tú tla̱n, o tú ni̱ tla̱n? ¿Lakma̱xtunicán ixli̱stacni cha̱tum cristiano, o li̱makxtakcán cani̱lh? Xlacán huata acs tatá̱yalh y ni̱ takalhtí̱nalh tú ca̱huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús lakapútzalh y sí̱tzi̱lh tziná porque xlacán ni̱ ixtama̱kachakxi̱putún xlacata ma̱s macuán ca̱makta̱yacán cristianos catu̱ya̱huá quilhtamacú. Entonces huanipá amá chixcú: ―Castonkti mimacán. Xlá stonkli ixmacán y tuncán cá̱xlalh la̱ ixmacasca̱cni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Amá fariseos ixenemigos Jesús tatáxtulh y a̱stá̱n tzúculh tata̱lacchihui̱nán cristianos tí ixtata̱ya̱na rey Herodes xlacata natalacputzá la̱ tla̱n natamakní Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","A̱stá̱n Jesús ca̱tá̱alh ixdiscípulos ixquilhtu̱n pupunú, lhu̱hua cristianos xalac Galilea tatakókelh. ");
INSERT INTO topNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Na̱ chuná tí mákat ixtalama̱nanchá acxni ixtacatzí la̱ ixca̱ma̱ksa̱ní Jesús ta̱tatlaní̱n y la̱ ixchihui̱nán ixtamín ta̱cxila, xalac Judea, xalac Jerusalén, xalac Tiro, Sidón, Idumea y tí ixtalama̱nanchá ixtampakán kalhtu̱choko Jordán. ");
INSERT INTO topNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huá jaé xlacata ca̱huánilh ixdiscípulos catama̱cá̱xnilh aktum akpáklha̱t, y aná natajú xlacata ni̱ natata̱ra̱slaka o natalacxquití cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Porque acxni ixta̱cxila tí ixca̱ma̱ksa̱ni̱ni̱t hua̱k ixtamakachipaputún. ");
INSERT INTO topNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na̱ ixtamín cristianos tí ixca̱ma̱lacpuhua̱ní ixespíritu tlajaná; acxni ixta̱cxila ixtatatzokostaní y chuné ixtama̱ktasí xlacata natama̱laksí: ―Huix Cristo Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús ca̱tasi̱tzi ixca̱ma̱quilhacslí xlacata ni̱ natama̱laksí y ni̱ natahuán ticu yá chixcú ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Maktum Jesús talacá̱cxtulh nac aktum sipi y aná ca̱ma̱mákstokli makapitzi lacchixcuhuí̱n tí xlá ixlacasquín, y acxni talakminko̱lh ");
INSERT INTO topNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesús ca̱lí̱lhca̱lh cha̱cu̱tuy ixlacata tí ma̱s ca̱li̱pá̱hualh xlacata siempre natatakoké y naca̱ma̱lakachá ca̱lacchiquí̱n xlacata natali̱chihui̱nán ixtachihui̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xlá ca̱má̱xqui̱lh tapáksi̱t tla̱n natama̱ksa̱ní tí takalhí tá̱tat, na̱ chuná natamacma̱xtú tí ca̱makatlajani̱t ixespíritu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jaé cha̱cu̱tuy apóstoles tí ca̱lí̱lhca̱lh Jesús chuné ixca̱huanicán: Simón, pero Jesús huilí̱nilh ixliaktuy ixtacuhui̱ní Pedro; ");
INSERT INTO topNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo y Juan ixlakkahuasán Zebedeo tí na̱ ca̱li̱ma̱pa̱cúhui̱lh “Boanerges” (jaé tachihuí̱n huamputún “ixlakkahuasán tají̱n”); ");
INSERT INTO topNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo y Tomás; Jacobo ixkahuasa Alfeo; Tadeo; Simón tí xapu̱lh ixca̱ta̱lapu̱lá pu̱tum tí ixtali̱tapa̱cuhuí cananistas; ");
INSERT INTO topNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote tí a̱stá̱n macamá̱sta̱lh Jesús. Jesús ca̱ta̱taspitpá ixdiscípulos nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ixta̱má̱n tahua̱yán, pero lhu̱hua cristianos tachimpá y yaj lá tahuá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Makapitzi ixli̱talakapasni Jesús na̱ tacátzi̱lh y támilh xlacata natalí̱n, porque xlacán na̱ ixtapuhuán Jesús ixchiyani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Makapitzi ixma̱kalhtahuake̱nacan judíos na̱ táchilh ixtamina̱chá nac Jerusalén, y tzúculh tali̱chihui̱nán Jesús: ―Jaé chixcú ta̱scuja y li̱pa̱huán Beelzebú ixpuxcucan tlajananí̱n, huá xlacata tla̱n ca̱li̱macma̱xtú cristianos ixespiritucan tlajananí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús ca̱tasánilh y tzúculh ca̱ma̱kalhchihui̱ní amá lacchixcuhuí̱n: ―¿Hua̱nchi puhuaná̱tit huixín xlacata tí ta̱scuja tlajaná tla̱n ta̱ra̱si̱tzi̱ní pi̱huá tlajaná tí makta̱yama? ");
INSERT INTO topNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tú quila̱li̱ya̱huayá̱u huixín na̱ chuné qui̱taxtú, para nac aktum ca̱chiquí̱n hua̱k ma̱paksi̱naní̱n tatapitzí y tara̱nica, ni̱ para maka̱s tata̱yaní tara̱lactlahuakó. ");
INSERT INTO topNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Na̱ chuné qui̱taxtupará, para tí talama̱na nac aktum pu̱táhui̱lh tzucú tara̱nictahuilá entre li̱talakapasni, ni̱ maka̱s quilhtamacú tla̱n tata̱kahuani̱kó. ");
INSERT INTO topNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Huá xlacata cca̱li̱huaniyá̱n para hua̱k tlajaná tatapitzí y tara̱lacata̱quí entre compañeros, ni̱lá tamakapalá maka̱s porque sok natara̱lactlahuakó entre xlacán. ");
INSERT INTO topNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Huixín na̱ capuhuántit xlacata ni̱ huí cristiano tí tla̱n makkalha̱nán cha̱tum tlihueke chixcú para ni̱ pu̱la tla̱n akchi̱huilí, huata chuná tla̱n makkalhán tú kalhí nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Aquit cca̱huaniyá̱n xlacata Dios tla̱n ca̱ma̱tzanke̱naní cristianos hua̱k ixtala̱kalhi̱ncán na̱ chuná para tali̱quilhán ni̱ lactlá̱n tachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tí acxila ixtascújut Espíritu Santo y huan xlacata ixtascújut tlajaná, ni̱lá catica̱ma̱tzanke̱nánilh y siempre takalhí nahuán ixtala̱kalhi̱ncán cani̱cxnihuá. ");
INSERT INTO topNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús ca̱huánilh jaé takalhchihuí̱n porque xlacán ixtaquilhuama̱na xlacata xlá ixta̱scuja y ixli̱pa̱huán tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Acxni táchilh ixna̱na ixnata̱camán Jesús tatamákxtakli nac quilhtí̱n huata tama̱tasaní̱nalh xlacata nataxtú porque snu̱n istzamacán. ");
INSERT INTO topNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tí lacatzú ixtahuila̱na ní ixuí Jesús chuné tahuánilh: ―Mina̱na y minata̱camán taya̱na nac quilhtí̱n tata̱chihuinamputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Jesús ca̱kálhti̱lh: ―¿Ticu yá quina̱na y quinata̱camán? ");
INSERT INTO topNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Entonces acs ca̱laca̱cxilhko̱lh hua̱k cristianos tí ixtahuila̱na aná lacatzú y chuné ca̱huanipá: ―Aquit ccatzí xlacata hua̱k huixín la̱ quina̱na y quinata̱camán, ");
INSERT INTO topNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","porque aquit cca̱huaniyá̱n xlacata tí tlahuá y latamá la̱ lacasquín Dios natalatamá cristianos, huá namá cli̱macá̱n la̱ quina̱na y la̱ quinta̱cam cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Maktum quilhtamacú Jesús ampá chihui̱nán ixquilhtu̱n pupunú. Lhu̱hua cristianos tatamákstokli huá xlacata Jesús li̱táju̱lh nac aktum barco y tatampú̱xtulh ixquilhtu̱n pupunú hua̱k cristianos tatamákxtakli ixquilhtú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tzúculh ca̱ma̱kalhchihui̱ní caj la̱ xacuento takalhchihuí̱n xlacata tla̱n natama̱kachakxi̱ní tú ixca̱huaniputún, y chuné tzúculh ca̱ta̱chihui̱nán: ");
INSERT INTO topNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Tla̱n cama̱kachakxí̱tit tú camá̱n ca̱huaniyá̱n: Maktum quilhtamacú cha̱tum chixcú alh chan ixtalhtzi trigo nac ixpu̱chaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","La̱ta itspuyuti̱lhama ixli̱chánat lhu̱hua ixtalhtzi ixtachaná̱n tama̱chá nac tijia; acxni tá̱cxilhli lactzu̱ spitu hua̱k tasacuako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Makapitzi ixli̱chánat tama̱chá nac ca̱chihuixni huata ixkalhí tziná tla̱n tíyat. Ni̱ lhu̱hua chichiní tapasá̱rlalh uyu sok ta̱kpunko̱lh porque ni̱ pu̱lhma̱n ixuí tla̱n tíyat. ");
INSERT INTO topNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero acxni táxtulh chichiní ca̱xkoyuko̱lh ixpakén y tasca̱cko̱lh porque ni̱ pu̱lhmá̱n ixtamaca̱ni̱t ixtankaxe̱kcán. ");
INSERT INTO topNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Makapitzi ixtachán tama̱chá nac ca̱xpayatni. Ni̱ ixli̱maka̱s quilhtamacú uyu ta̱kpunko̱lh, pero ma̱s lacapala tástacli kajni, tama̱ksniko̱lh y ni̱tú tástacli ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero lhu̱hua ixtachaná̱n tama̱chá nac tla̱n tíyat, jaé hua̱k tástacli y tamá̱sta̱lh lhu̱hua ixtahuácat. Huí ni̱ma̱ tamá̱sta̱lh puxumacá̱u, tutumpuxum, y aktum ciento ixtahuacatcán la̱ta akatunu xatalhtzi ni̱ma̱ ca̱chanca. ");
INSERT INTO topNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús chuné ca̱huánilh acxni ca̱ta̱chihui̱nanko̱lh: ―Tí kalhí ixtakén cakáxmatli tú cca̱huanimá̱n y tla̱n cama̱kachákxi̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Acxni ixacstu tamákxtakli Jesús, ixdiscípulos y xa̱makapitzi tí siempre ixtatakoké tama̱lacatzúhui̱lh y takalasquínilh tucu ixuamputún amá takalhchihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús ca̱kálhti̱lh: ―Huixín Dios ca̱ma̱cxcatzi̱ni̱yá̱n la̱ xlá ama huilí ixtapáksi̱t ca̱quilhtamacú y la̱ lacasquín natalatamá cristianos, pero xa̱makapitzi tiene que nacca̱ta̱ma̱lacastucní tú talakapasa, y ni̱ para chú ama taputzá natama̱kachakxí. ");
INSERT INTO topNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Porque xlacán masqui lhu̱hua tú ctlahuá xlacata nacca̱ma̱lacahua̱ní la̱ ni̱ catalacahuá̱nalh; ma̱squi quintakaxmata la̱ ni̱tú catama̱kachákxi̱lh. Y para ni̱ lá taca̱najlá la̱ cca̱li̱ta̱chihui̱nán Dios, xlá ni̱ catica̱ma̱tzanke̱nánilh ixtala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús ca̱ta̱chihui̱nampá tí takalasquínilh: ―Para huixín ni̱ ma̱kachakxi̱yá̱tit jaé ixtakalhchihui̱n chana̱ná y ni̱ tuhua, ¿niculá naca̱ma̱kachakxi̱yá̱tit xa̱makapitzi takalhchihuí̱n ni̱ma̱ camá̱n ca̱huaniyá̱n a̱stá̱n? ");
INSERT INTO topNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jaé chixcú tí alh chana̱nán na̱ chuná la̱ cha̱tum chixcú tí li̱chihui̱nán ixtachihui̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tachaná̱n ni̱ma̱ tama̱chá nac tijia na̱ chuná qui̱taxtú la̱ acxni cristianos takaxmata ixtachihui̱n Dios, pero mina̱chá tlajaná y ma̱xtukó jaé talacapa̱stacni ni̱ma̱ ma̱nu̱ca nac ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tachaná̱n ni̱ma̱ tama̱chá nac ca̱chihuixni na̱ chuná qui̱taxtú la̱ makapitzi cristianos acxni takaxmata ixtachihui̱n Dios tuncán talakatí y tali̱pa̱huán Dios. ");
INSERT INTO topNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero con ta̱kspulá tú ni̱ tla̱n, o ca̱li̱chihui̱nancán xlacata tali̱pa̱huán Dios, y como ixnacujcán ni̱ tla̱n tali̱ma̱tzamani̱t ixtalacapa̱stacni Dios tali̱makxtaka tuncán y yaj tali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Amá li̱chánat ni̱ma̱ tama̱chá ca̱xpayatni na̱ chuná la̱ lhu̱hua cristianos acxni takaxmata ixtachihui̱n Dios taca̱najlá y tali̱pa̱huán Dios. ");
INSERT INTO topNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero la̱ta li̱án ixlatama̱tcán tzucú ta̱katuyún, tzucú tali̱pa̱huán huata ixtumi̱ncán y la̱ li̱pa̱xáu natalatamá y chuná tama̱ksni̱kó tú ixtali̱pa̱huán y ni̱ tama̱stá ixtahuacatcán. ");
INSERT INTO topNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Li̱chánat ni̱ma̱ tama̱chá nac tla̱n tíyat y tamá̱stalh ixtahuacatcán na̱ chuná la̱ cristianos tí takaxmata ixtachihui̱n Dios, taca̱najlá y tali̱pa̱huán Dios y tatlahuá tú ca̱li̱ta̱chihui̱nancán na̱ chuná la̱ catamá̱sta̱lh ixtahuacatcán; huí ni̱ma̱ tama̱stá puxumacá̱u, tutumpuxum, o aktum ciento ixlacata ixtahuácat la̱ta akstum tachihuí̱n ni̱ma̱ takáxmatli. ");
INSERT INTO topNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús ca̱li̱ma̱kalhchihuí̱ni̱lh aktum lámpara y chuné ca̱huánilh; ―¿Puhuaná̱tit huixín xlacata tí kalhí aktum lámpara huilí ixtampi̱n ixpu̱tama, o ma̱kalhchuhuajú nac aktum caju̱n? Ni̱ huí cristiano tí chú tlahuá, porque huixín catzi̱yá̱tit xlacata aktum lámpara siempre huili̱cán ta̱lhmá̱n xlacata nalacacha̱nkó cani̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ni̱ lá tú tze̱k tlahuacán y ni̱ lá catitacátzi̱lh xa̱makapitzi ixli̱maka̱s quilhtamacú; y lhu̱hua la̱ta tú cca̱huaniyá̱n para chí ni̱ ma̱kachakxi̱yá̱tit tzanka̱xní hua̱k pa̱t ma̱kachakxi̱yá̱tit. ");
INSERT INTO topNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Huá xlacata cca̱li̱huaniyá̱n para kalhi̱yá̱tit mintake̱ncán, cakaxpáttit quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús ca̱huanipá: ―Tla̱n cama̱kachakxí̱tit tú kaxpatá̱tit porque na̱ chuná la̱ lacasquiná̱tit tú ixtatláhualh cristianos milacatacán, o la̱ huixín la̱makta̱yayá̱tit, Dios na̱ chuná ama ca̱li̱kalhi̱yá̱n huixín y ma̱s cha̱ naca̱ma̱xqui̱yá̱n para kaxpatá̱tit ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porque tí tlahuá tú kaxmata, Dios ma̱s ama ma̱xquí tla̱n talacapa̱stacni ma̱squi kalhi̱yá, pero tí ni̱ lhu̱hua tú kalhí Dios ama maklhtí hasta ni̱ma̱ ixli̱skalhma̱ca. ");
INSERT INTO topNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús ca̱huanipá: ―Ixtapáksi̱t Dios nac ca̱quilhtamacú ama lacatzucú na̱ chuná la̱ acxni cha̱tum chixcú an spuyumí ixli̱chánat ixca̱tucuxtu ni̱ma̱ tla̱n ca̱xtlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Xlá an latahuilá nac ixchic xlacata a̱stá̱n naampará a̱huata naquí ixtahuácat. Tapasa̱rlá chichiní y ca̱tzisní, xlá ni̱ li̱puhuán ixtachaná̱n porque catzí ama staca. ");
INSERT INTO topNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Amá li̱chánat pu̱la taxtuní ixtankáxe̱k, ixpakán, xaxánat, y a̱stá̱n ma̱stá ixtahuácat; jaé tachaná̱n hua̱k tíyat má̱xqui̱lh tú nali̱staca o nali̱latamá. ");
INSERT INTO topNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Acxni cha̱n ixquilhta nacatlán ixtahuácat a̱huata an xlacata naquí ixtahuácat ixtrigo. ");
INSERT INTO topNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","’¿Niculá puhuaná̱tit huixín ama lacatzucú ixtapáksi̱t Dios nac ca̱quilhtamacú, o tucu ya̱ takalhchihuí̱n tla̱n ixli̱ma̱lacastucui? ");
INSERT INTO topNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tla̱n puhuaná̱tit xlacata ama lacatzucú la̱ pa̱xtoka aktum ixtalhtzi mostaza acxni chancán nac tíyat. Huá jaé ma̱s xalactzú ixtalhtzi quihui ni̱ma̱ lacapala tastaca nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero acxni chancani̱ttá, tzucú staca y lanca quihui huan ni̱ la̱ xa̱makapitzi quihui ni̱ma̱ na̱ lacapala tastaca nac ixakán tla̱n taske̱ka y tajaxa lactzu̱ spitu ni̱ma̱ takospu̱lá porque snu̱n lanca pakastaca. ");
INSERT INTO topNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús acxni ixca̱ta̱chihui̱nán cristianos siempre ixca̱li̱ta̱chihui̱nán la̱ cuentos xlacata natama̱kachakxí ixtachihui̱n Dios ni̱ma̱ ixca̱ma̱si̱niputún. ");
INSERT INTO topNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ni̱cxni chu̱ta ixma̱kalhchihui̱ní para ni̱ ixca̱ta̱ma̱lacastucní tú xlacán ixtalakapasa o ixtacatzí; y para ixdiscípulos ni̱ tla̱n ixtama̱kachakxí tú ixca̱huaní a̱stá̱n tla̱n ixca̱lacspi̱tní tú ixca̱huaniputún. ");
INSERT INTO topNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Amá chichiní acxni tzúculh tapaklhtu̱tá Jesús ca̱huánilh ixdiscípulos: ―Chí ca̱huí ixa̱quilhtu̱tu pupunú. ");
INSERT INTO topNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lhu̱hua cristianos tatamákxtakli ixquilhtu̱n pupunú, ixdiscípulos tatáju̱lh nac barco ní ixtaju̱majá Jesús; makapitzi barcos na̱ tatakókelh pakán ní ixama. ");
INSERT INTO topNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Jesús táma̱lh ixtanke̱n barco xlacata nalhtatá acxtícalh aktum cojín. Ixli̱puntzú také̱talh akxtulú̱n, chúchut tanu̱ko̱lh nac barco y actzú ni̱ má̱ktzi̱lh. Entonces ixdiscípulos lacapala tama̱stácni̱lh Jesús y tahuánilh: ―¡Maestro! ¿Huix ni̱ caso tlahuaya la̱ amá̱n mu̱xtuyáu? ");
INSERT INTO topNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús tá̱qui̱lh y acxni ca̱li̱ma̱páksi̱lh ixtachihuí̱n amá u̱n y pupunú, chuné ca̱huánilh: ―¡Acs catahuilátit y catake̱nú̱tit! Amá akxtulú̱n také̱nu̱lh tuncán acs tatu̱tako̱lh, na̱ chuná pupunú. ");
INSERT INTO topNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ixdiscípulos ca̱huánilh: ―¿Hua̱nchi pucuta jicuaná̱tit? ¿Nicu alh milicamamacán la̱ huaná̱tit quila̱li̱pa̱huaná̱u? ");
INSERT INTO topNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xlacán ma̱s tajicuanko̱lh ixtara̱huaní entre xlacán: ―¿Cha̱ ticu yá chixcú jaé tí quinca̱ta̱lapu̱layá̱n? ¡Hasta na̱ tla̱n takaxmatní u̱n y pupunú acxni ca̱ta̱chihui̱nán! ");
INSERT INTO topNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tácha̱lh aktum ca̱chiquí̱n huanicán Gadara xa̱quilhtu̱tu pupunú. ");
INSERT INTO topNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Acxni tá̱ctalh Jesús talacatzúhui̱lh cha̱tum chixcú ixactanu̱ma ixespíritu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jaé chiyajua chixcú ixlama nac campúsantu y ni̱ lá tí ixmakatlajá xlacata nachi̱huilí. ");
INSERT INTO topNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Maklhu̱hua li̱chi̱huili̱ca cadenas nac ixmacán ixtantú̱n, pero ni̱tú ixli̱macuán porque siempre ixca̱lacpucha cadenas, ni̱cxni tí makatlájalh. ");
INSERT INTO topNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ca̱cuhuiní y ca̱tzisní siempre ixán aktasatapu̱lí ca̱lacsipijni y ní ca̱muju̱cani̱t ni̱n. Catunu ixacstu ixli̱ma̱xqui̱cán xlacata nala̱kalhi̱cán. ");
INSERT INTO topNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Huá xlacata acxni ácxilhli Jesús lákmilh, tatzokostánilh ixlacatí̱n y chuné ta̱chihuí̱nalh: ");
INSERT INTO topNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","―Jesús Ixkahuasa Dios, ¿hua̱nchi tani̱ta quila̱paktanu̱yá̱u? ");
INSERT INTO topNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesús huánilh amá chixcú tí ixma̱lacpuhua̱ní ixespíritu tlajaná: ―¡Ixespíritu tlajaná, camactaxtu tuncán namá chixcú! Xlá chuné kálhti̱lh: ―Catlahua li̱tlá̱n, ni̱ caquila̱ma̱kxtakajní̱u. ");
INSERT INTO topNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kalasquinipá: ―¿Niculá huanicana? Xlá kalhtí̱nalh: ―Cli̱tapa̱cuhui̱yá̱u “Legión”, porque quincha̱lhu̱huacán tí cmactanu̱ma̱náu jaé chixcú. ");
INSERT INTO topNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ca̱li̱tlá̱n tamáksquilh Jesús xlacata ni̱ caca̱ma̱lakácha̱lh a̱lacatunu pu̱latama̱n; ");
INSERT INTO topNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","y acxni tá̱cxilhli ixtahua̱yampu̱lá pakán nac sipi ma̱x como aktuy mi̱lh paxni, ");
INSERT INTO topNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ca̱li̱tlá̱n tahuánilh Jesús amá ixespiritucán tlajananí̱n: ―Quila̱ma̱xquí̱u li̱tlá̱n nactanu̱yá̱u siquiera ixmacnicán namá paxni ni̱ma̱ talaya̱na nanú lacatzú. ");
INSERT INTO topNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús ca̱má̱xqui̱lh li̱tlá̱n y amá ixespiritucán tlajananí̱n tamactáxtulh amá chixcú y tatánu̱lh ixmacnicán paxni. Pero acxni tatánu̱lh amá paxni tzúculh talactza̱lanán cani̱huá la̱ catachiyalh, huá xlacata tali̱pa̱tástalh lacatum ca̱kalhpu̱lhma̱n tataju̱chá nac chuchut pupunú y aná hua̱k tamu̱xtuko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tí ixtamaktakalhma̱na paxni acxni tá̱cxilhli la̱ tani̱ko̱lh ixpaxnicán tajicuanko̱lh y táalh tatza̱lh tahuán tú ixta̱kspulani̱t nac ca̱chiquí̱n y tí ixtalama̱na ca̱tucuxtu; lhu̱hua cristianos támilh talacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Acxni táchilh ní ixyá Jesús, tá̱cxilhli amá chixcú tí xapu̱lh ixactanu̱ma ixespíritu tlajaná, aná curucs ixuí ixlhaka̱nani̱t y yaj la̱ cachíyalh ixtasí; xlacán tajicuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tí tla̱n ixta̱cxilhni̱t la̱ ixqui̱taxtuni̱t talacspí̱tnilh xa̱makapitzi la̱ tamactáxtulh tlajananí̱n amá chixcú y tatánu̱lh ixmacnicán paxni. ");
INSERT INTO topNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Acxni tla̱n tama̱kachákxi̱lh tzúculh tahuaní Jesús xlacata ni̱ catamákxtakli ixpu̱latama̱ncán y caalh a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús ca̱kaxmátnilh taju̱pá nac barco, entonces amá chixcú tí ma̱ksá̱ni̱lh huánilh xlacata ixtakokeputún la̱ta ní pakán ixama Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús ni̱ ma̱tlá̱ni̱lh tú ixmaksquín y chuné huánilh: ―Mejor capit ca̱cxila mili̱talakapasni cmínchic, caca̱li̱ma̱kalhchihui̱ni la̱ lakalhamani̱tán y ma̱ksa̱ni̱ni̱tán Dios. ");
INSERT INTO topNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Amá chixcú alh pero tzúculh li̱chihui̱nán Jesús la̱ ixma̱ksa̱ni̱ni̱t, y acxni tí ixtakaxmata ixtaca̱cní Jesús la̱ ixca̱tlahuá ixtascújut. Chuná ixli̱chihui̱nancán Jesús nac lactzu̱ ca̱lacchiquí̱n xala amá pu̱latama̱n huanicán Decápolis. ");
INSERT INTO topNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús cha̱mpá ixa̱quilhtu̱tu pupunú ní ixmini̱tanchá, pero lhu̱hua cristianos ixtatamakstokni̱t ana ní cha̱lh y xlá ca̱ta̱tamákxtakli ixquilhu̱n pupunú. ");
INSERT INTO topNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ixli̱puntzú chilh cha̱tum xapuxcu tí ixtama̱paksi̱nán nac sinagoga xala ca̱chiquí̱n ixuanicán Jairo. Acxni lákchilh Jesús tatzokostánilh, ");
INSERT INTO topNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","y chuné huánilh ca̱li̱tlá̱n: ―Catlahua li̱tlá̱n capit li̱macxamaya mimacán quintzuma̱t porqui ni̱majá, pero huix tla̱n ma̱ksa̱ni̱ya xlacata tla̱n nalatama̱pará. ");
INSERT INTO topNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús ma̱tlá̱ni̱lh y tá̱alh amá chixcú nac ixchic, lhu̱hua cristianos tatakókelh hasta ixtalacxquititi̱lhá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na̱ aná ixán cha̱tum puxca̱t ta̱tatlá, ixkalhi̱yá akcu̱tuy ca̱ta la̱ta ixmakstajma y ni̱cxni itxuncní ní ixtala̱kalhi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Doctores snu̱n ixtama̱kxtakajni̱ni̱t y ni̱ lá ixtama̱ksa̱ni̱ni̱t; ixli̱lactlahuani̱t ixtá̱tat hua̱k ixtumi̱n y ni̱tú ixmacuanini̱t ma̱s cha̱ itsnu̱nama y snu̱n ixakxtakajnán. ");
INSERT INTO topNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Huá xlacata acxni káxmatli la̱ li̱chihui̱nancán Jesús lacpúhualh: “Ccatzí para xacchipánilh tziná ixlháka̱t Jesús tla̱n nacaksa̱nán.” La̱ta tzamacán lakasu̱t talacatzúhui̱lh ní ixama Jesús y chipánilh tziná ixlháka̱t. ");
INSERT INTO topNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tuncan maklhcátzi̱lh xlacata xuncli ixkalhni la̱ ixmakstajma y tla̱n aksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús acxcátzi̱lh xlacata huí tí ma̱ksá̱ni̱lh, talákspitli lacapala y kalasquiní̱nalh: ―¿Ticu xámalh quilháka̱t? ");
INSERT INTO topNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ixdiscípulos takálhti̱lh: ―Huix acxílhpa̱t la̱ cati̱huá li̱tamacuacamá̱n y kalasquini̱nana: “¿Ticu xámalh quilháka̱t?” ");
INSERT INTO topNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús tzúculh lacá̱n cani̱huá ixlakataka̱sputún tí ixma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Amá pusca̱t ixcatzí xlacata huá chú ixlani̱t huá li̱jicuanko̱lh y tzúculh talhpipí. Lákalh Jesús, tatzokostánilh y huánilh xlacata huá ixli̱tamacuacani̱t ixlháka̱t. ");
INSERT INTO topNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús chuné kálhti̱lh: ―Huix aksa̱nani̱ta porque ca̱najlani̱ta xlacata aquit tla̱n cma̱ksa̱ni̱yá̱n. Capit li̱pa̱xáu y tla̱n ca̱ksa̱nanko. ");
INSERT INTO topNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Xlá ixchihui̱namajcú acxni táchilh makapitzi cristianos, ixtamina̱chá nac ixchic Jairo y chuné tahuánilh: ―Apenas ni̱ko̱lh mintzuma̱t ma̱squi yajtú caliakaxculi maestro Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús ni̱ caso tláhualh tú ixtaquilhuama̱na y huanipá amá ixti̱cu tzuma̱t: ―Ni̱tú cali̱púhuanti huix, huata caca̱najla tú cuaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A̱stá̱n ca̱huánilh ixdiscípulos huata catatakókelh Pedro, Jacobo y Juan ixta̱cam Andrés, xa̱makapitzi ni̱ lacásquilh natatakoké. ");
INSERT INTO topNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Acxni tácha̱lh nac ixchic Jairo lhu̱hua ixtatasama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús tánu̱lh nac ákxtaka y ca̱huánilh: ―¿Hua̱nchi tasapa̱nántit y tlakaj layá̱tit? Namá tzuma̱t huata lhtatama, ni̱ xaní̱n la̱ puhuaná̱tit huixín. ");
INSERT INTO topNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lhu̱hua tali̱tzíyalh ixtachihuí̱n. Entonces ca̱huánilh xlacata hua̱k catatáxtulh huata xanati̱cún y ixdiscípulos catáalh ana ní ixmá xaní̱n amá tzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesús makachípalh amá tzuma̱t y chuné ta̱chihuí̱nalh: ―Talita cumi ―jaé tachihuí̱n huamputún: Huix cuanimá̱n tzuma̱t, cata̱qui. ");
INSERT INTO topNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Amá tzuma̱t apenas ixkalhí akcu̱tuy ca̱ta, tuncán tá̱qui̱lh, tla̱n tlá̱hualh y hua̱k tapa̱xahuako̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A̱stá̱n ca̱huánilh xanati̱cún catamá̱hui̱lh y ni̱ catali̱chihuí̱nalh la̱ ma̱lacastacuáni̱lh istzumatcán. ");
INSERT INTO topNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A̱stá̱n Jesús ca̱tá̱alh ixdiscípulos ca̱chiquí̱n ní itstacni̱tanchá huanicán Nazaret. ");
INSERT INTO topNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Maktum quilhtamacú acxni hua̱k judíos ixtajaxa Jesús tánu̱lh nac sinagoga y tzúculh ca̱ma̱si̱ní cristianos ixtachihui̱n Dios. Lhu̱hua ixtapa̱xahuá acxni ixtakaxmata la̱ ixca̱ta̱chihui̱nán Jesús, pero makapitzi ixtara̱kalasquiní: ―¿Cha̱ nicu catzí̱nilh jaé Jesús tú tla̱n catzí? ¿Ticu má̱xqui̱lh ixtapuhuá̱n y niculá tlahuá ca̱ma̱ksa̱ní cristianos con ixtachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jaé chixcú carpintero ixuani̱t juú ixquinca̱ta̱lamá̱n lacatzú; ixkahuasa María, ixnata̱camán ca̱huanicán Jacobo, Judas, José y Simón; ixnapi̱pín na̱ chuná hua̱k ca̱lakapasá̱u. Chuná jaé ixtalacpuhuán y huá xlacata ixpu̱latama̱n lhu̱hua ni̱ ixtaca̱najlá tú ixca̱li̱ta̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús ma̱kachákxi̱lh y chuné ca̱huánilh: ―Cati̱hua cristiano tali̱pa̱huán cha̱tum lanca chixcú acxni xala mákat, pero acxni ixta̱lacatzujcán ixta̱pakanatcán o ixli̱takapasnicán, ni̱ tali̱pa̱huán tú ca̱li̱ta̱chihui̱nancán. ");
INSERT INTO topNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Makapitzi tí taca̱nájlalh ixtachihui̱n Jesús ca̱li̱macxámalh ixmacán xlacata nata̱ksa̱nán, pero ni̱ cha̱lhu̱hua cristianos taca̱nájlalh ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús snu̱n lakapútzalh na̱ chú ixli̱puhuán porque ni̱ ixma̱kachakxí hua̱nchi tí ixta̱pakánat ni̱ ixtaca̱najlá tú ixca̱li̱ta̱chihui̱nán, huá xlacata mejor alh ca̱ma̱kalhchihui̱ní tí ixtalama̱na nac lactzu̱ ca̱chiquí̱n ni̱ma̱ tahuila̱na lacatzú nac Nazaret. ");
INSERT INTO topNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Maktum quilhtamacú Jesús ca̱ma̱makstokko̱lh cha̱cu̱tuy ixdiscípulos y ca̱huánilh xlacata nataán cha̱tuy cha̱túy tama̱kahuaní ixtachihuí̱n. Ca̱má̱xqui̱lh li̱tlihueke y tapáksi̱t xlacata tla̱n natama̱ksa̱ní cristianos tí ca̱mactanu̱ma ixespíritu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na̱ ca̱huánilh ni̱ catáli̱lh tú naca̱macuaní nac tijia para la̱ múrralh, simi̱ta o tumi̱n tú natali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Huata ca̱huánilh catáli̱lh aktum lí̱xtoko, pu̱tum tatu̱nu y pu̱tum lháka̱t. ");
INSERT INTO topNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Chuné ca̱li̱ma̱páksi̱lh natalá acxni ní natachá̱n: ―Acxni nachipiná̱tit aktum ca̱chiquí̱n naputzayá̱tit chiqui ní natamakxtaká̱tit; aná nalatapa̱yá̱tit hasta xní napiná̱tit a̱lacatunu ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Para nac aktum pu̱latama̱n ni̱ ca̱maklhti̱nancaná̱tit y ni̱ takaxmatputún tú ca̱li̱ta̱chihui̱naná̱tit, tuncán cataxtútit, ixlacati̱ncán caca̱tantu̱tincxcántit pokxni ni̱ma̱ ca̱tantu̱tahuacán xlacata natacatzí huixín ni̱ lakati̱yá̱tit ixkasatcán. Aquit cca̱huaniyá̱n xlacata acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k ni̱ lactlá̱n cristianos tí ixtalama̱na xapu̱lh nac ca̱chiquí̱n Sodoma y Gomorra, liactá castigo ama takalhí que tí talama̱na nac ca̱chiquí̱n ní nachipiná̱tit y ni̱ ca̱maklhti̱nancaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xlacán tatáca̱xli y táalh nac ca̱lacchiquí̱n y tzúculh tama̱kalhchihui̱ní cristianos xlacata natalakxta̱palí ni̱ tla̱n ixlatama̱tcán ni̱ma̱ ixtakalhí. ");
INSERT INTO topNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhu̱hua ta̱tatlaní̱n tama̱ksá̱ni̱lh acxni ixtamacuilí aceite na̱ chuná tamacmá̱xtulh cristianos tí ixca̱makatlajani̱t ixespíritu tlajaná. ");
INSERT INTO topNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Acxni cátzi̱lh rey Herodes la̱ ixtali̱chihui̱nán Jesús hua̱k cristianos, chuné huá: ―La̱ta cpuhuán, namá chixcú ma̱x Juan Bautista ni̱ma̱ cma̱pixca̱ctí̱nalh, pero chí lacastacuanampá y mimpá ca̱quilhtamacú, huá tla̱n ca̱li̱tlahuá laclanca tascújut. ");
INSERT INTO topNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Makapitzi cristianos ixtahuán: ―Namá chixcú ma̱x tunu profeta la̱ ni̱ma̱ tamini̱t tali̱chihui̱nán Dios maká̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero rey Herodes siempre ixuán: ―La̱ta cpuhuán jaé chixcú Juan Bautista tí aquit cma̱makni̱ní̱nalh, pero xlá lacastacuanampá ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porque tú ixtlahuani̱t rey Herodes ma̱ma̱nu̱ní̱nalh Juan Bautista nac pu̱la̱chi̱n y ma̱paksí̱nalh cali̱chi̱huili̱ca cadenas, porque ni̱ talakáti̱lh acxni li̱huánilh la̱ ixlakamaklhti̱ni̱t ixta̱cha̱t ixta̱cam Felipe. ");
INSERT INTO topNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Maktum quilhtamacú Juan Bautista huánilh rey Herodes: ―Ni̱ tla̱n la̱ ta̱huila ixta̱cha̱t minta̱cam ni̱ma̱ lakámaklhti. ");
INSERT INTO topNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jaé pusca̱t ixuanicán Herodías y ni̱ ixacxilhputún Juan Bautista xlacata ixli̱huanini̱t la̱ ixta̱lama ixya̱stá. Siempre ixlacputzá la̱ tla̱n ixmákni̱lh, pero ni̱ ixtaka̱sa la̱ natlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Xa̱huá Herodes ixcatzí xlacata Juan Bautista tla̱n cristiano ixuani̱t y ni̱tú ixkásat porque Dios ixma̱lakacha̱ni̱t. Ixlakatí ixkaxmata ixtachihuí̱n ma̱squi ni̱ lihua ixma̱kachakxí tú ixli̱chihui̱nán. Por eso ixli̱jucuaní tziná y ni̱ ixmakxtaka tú natlahuaní ixta̱cha̱t. ");
INSERT INTO topNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Maktum quilhtamacú amá pusca̱t táka̱sli tú tla̱n ixputzama porque Herodes ca̱tlahuánilh aktum li̱lakastá̱n xanapuxcun ma̱paksi̱naní̱n y xalactali̱pa̱u lacchixcuhuí̱n tí ixtalama̱na nac Galilea. ");
INSERT INTO topNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ixli̱puntzú na̱ tánu̱lh nac fiesta istzuma̱t, tzúculh tantlí. Hua̱k tí ixtaya̱na aná talakáti̱lh la̱ tántli̱lh amá tzuma̱t. Entonces rey Herodes chuné huánilh: ―Caquimáksquinti la̱ta tú huix ma̱s lakati̱ya y nacma̱xqui̱yá̱n ");
INSERT INTO topNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ma̱squi ixquimáksquinti lhu̱hua tíyat ni̱ma̱ cca̱ma̱paksí. La̱ta istzamacán tla̱n ma̱lacnú̱nilh nama̱xquí tú namaksquín y hua̱k takaxmatko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Amá tzuma̱t táxtulh y kalasquínilh ixna̱na: ―¿Tucu tla̱n xacmáksquilh quintu̱ti̱cú, pues hua̱k quima̱lacnú̱nilh? Xlá kálhti̱lh: ―Camáksquinti cama̱xquí̱n ixakxaka Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Amá tzuma̱t tanu̱pá y huánilh rey Herodes: ―Clacasquín chí tuncán quima̱xqui nac aktum pula̱tu ixakxa̱ka Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes lakapútzalh pero ni̱ lá takalhpú̱spitli porque tla̱n ixli̱ta̱yani̱t nama̱xquí tú ixmaksquín, xa̱huá ixamigos hua̱k ixtakaxmatni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma̱lakácha̱lh cha̱tum soldado xlacata nali̱miní ixakxa̱ka Juan. ");
INSERT INTO topNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Amá soldado alh cpu̱la̱chi̱n ní ixtanu̱ma Juan y pixcá̱cti̱lh. Acxni makni̱ko̱lh múju̱lh ixakxa̱ka nac aktum pula̱tu la̱ ixma̱paksi̱cani̱t, alh ma̱xquí rey Herodes, y xlá má̱xqui̱lh amá tzuma̱t, y xlá ma̱xqui̱pá ixna̱na la̱ ixuanini̱t. ");
INSERT INTO topNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Acxni tacátzi̱lh tí ixtakaxmatni̱t la̱ ixca̱ta̱chihui̱nani̱t Juan Bautista, támilh tatiyá xaní̱n y tamúju̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ni̱ ixli̱maka̱s ixapóstoles Jesús taqui̱táspitli y tali̱ma̱kalhchihuí̱ni̱lh la̱ta tú ixtatlahuani̱t y la̱ta tú ixtali̱chihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","A̱stá̱n Jesús ca̱huánilh: ―Chí ca̱huí jaxá̱u a̱lacatunu ana ní ni̱tí naquinca̱kaxculiyá̱n. Yaj lá li̱pa̱xáu ixtahua̱yán porque puntzuntín ixmincán acxilhcán Jesús y ma̱squi lhu̱hua ixtaaná, tunu ixtachimpará. ");
INSERT INTO topNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesús ca̱ta̱táju̱lh ixdiscípulos nac barco y táalh pakán ní ni̱ lama cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero lhu̱hua talakápasli Jesús acxni alh y ta̱xcátzi̱lh pakán ní ixama cha̱n. Lhu̱hua tatakókelh xala cani̱hua ca̱lacchiquí̱n y xlacán pu̱la tácha̱lh ya̱ para ixchá̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Acxni tácutli nac barco cá̱cxilhli aná tahuila̱na cristianos la̱ lactzu̱ borregos xata̱ktzanká̱n y ni̱ takalhí tí naca̱cuentaja. Xlá ca̱lakalhámalh y lhu̱hua tú ca̱li̱ma̱kalhchihuí̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cha̱lh smalankán ixdiscípulos talákmilh y chuné tahuánilh: ―Smalankaná y ni̱tí lama juú. ");
INSERT INTO topNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Caca̱huani jaé cristianos catáalh taputzá tú natahuá juú lacatzú ca̱lacchiquí̱n, o tí talama̱na nac ixca̱tucuxtucán. Catatamá̱hualh simi̱ta porque ni̱ takalhí tú natahuá. ");
INSERT INTO topNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Xlá ca̱kálhti̱lh: ―Mejor huixín caca̱ma̱huí̱tit. Xlacán takalhti̱nampá: ―Pero, ¿nicu nactiyayá̱u aktuy ciento denario tumi̱n xlacata nacli̱tama̱huayá̱u simi̱ta y nacca̱ma̱hui̱yá̱u? ");
INSERT INTO topNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ca̱kalasquimpá: ―Capítit acxilá̱tit. ¿Nicu macli̱t simi̱ta li̱taná̱tit? Acxni tá̱cxilhli takálhti̱lh: ―Cli̱miná̱u macquitzis simi̱ta y tantuy tamakní. ");
INSERT INTO topNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesús ca̱huánilh cristianos catatahui pu̱tunu nac ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Huí tí tatahui íta̱t ciento cristianos la̱ta pu̱tunu y huí tí katunu ciento. ");
INSERT INTO topNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ca̱chípalh amá macquitzis simi̱ta y tantuy tamakní, láca̱lh nac akapú̱n, pa̱xcatcatzí̱nilh Dios amá tahuá. A̱stá̱n ca̱lakchékelh y ca̱má̱xqui̱lh ixdiscípulos xlacata natama̱kpitziní cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Hua̱k táhualh simita y tla̱n takálhkasli. ");
INSERT INTO topNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","A̱stá̱n ixdiscípulos tama̱tzámalh akcu̱tuy canasta simita y tamakní ni̱ma̱ kalhta̱xtulhcú. ");
INSERT INTO topNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Huata lacchixcuhuí̱n tahuá̱yalh ma̱x cha̱quitzis mi̱lh aparte lacchaján y lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A̱stá̱n Jesús ca̱huánilh ixdiscípulos catatáju̱lh nac barco y ca̱tá̱alh ixa̱quilhtu̱tu pupunú nac aktum ca̱chiquí̱n huanicán Betsaida, xlá a̱stá̱n ixama ca̱lakchá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Porque ixca̱huanima cristianos xlacata na̱ cataalhá ixca̱chiqui̱ncán o ixchiccán. La̱ taanko̱lh amá cristianos, xlá talacá̱cxtulh aktum sipi y aná kalhtahuakánilh Dios. ");
INSERT INTO topNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Acxni tzúculh tla̱n tzi̱suán amá barco ixama̱chitá nac ixíta̱t pupunú y Jesús ixacstu ixtamakxtakni̱t ixquilhtu̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Li̱huacá tzi̱sa ixuani̱t acxni Jesús tzúculh tla̱huán ixkalhni chúchut ca̱ma̱lacatzúhui̱lh ixdiscípulos. Ixama ca̱kapu̱lá pero cá̱cxilhli xlacata yaj ixtama̱tla̱hualí̱n ixbarcojcán porque u̱n ni̱ ixama pakán ní ixta̱ma̱na. ");
INSERT INTO topNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ixdiscípulos acxni tá̱cxilhli cha̱tum chixcú tla̱huama ixkalhni chúchut tajicuanko̱lh porque talacpuhua xlacata cha̱tum ni̱n ixuani̱t o maka̱klhaná, y hua̱k ta̱ktásalh. Pero Jesús ca̱huánilh: ―Ni̱ cajicuántit, cakalhí̱tit li̱camama. Aquit, Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A̱stá̱n xlá tá̱cxtulh nac barco; u̱n ni̱ma̱ ixmima tuncán xuncli. Xlacán ni̱ taca̱tzi̱lh tú natalacpuhuán acxni tá̱cxilhli tú ixtlahuani̱t Jesús, ");
INSERT INTO topNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","porque ma̱squi ixta̱cxilhni̱t laclanca ixtascújut Jesús, na̱ chuná la̱ ixma̱lhu̱hui̱ni̱t simi̱ta, ixnacujcán ya̱ ixma̱kachakxí la̱ tla̱n natali̱pa̱huán ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ixli̱punchú talakatza̱lako̱lh amá chúchut xla Galilea y tácha̱lh nac aktum pu̱latama̱n huanicán Genesaret. ");
INSERT INTO topNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Acxni tácutli Jesús lhu̱hua talakápasli y tuncán talákmilh. ");
INSERT INTO topNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Hua̱k ta̱tatlaní̱n xala amá pu̱latama̱n tzucuca ca̱li̱mincán ana ní ixchihui̱nama xlacata naca̱ma̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na̱ chuná nac tijia ca̱chiquí̱n o ixtijia ca̱tucuxtu ixca̱huili̱cán ta̱tatlaní̱n ana ní ixtapuhuán ama lacpasa̱rlá Jesús y xa̱makapitzi ixtahuaní xlacata caca̱má̱xqui̱lh li̱tlá̱n nataxamaní ixlháka̱t, hua̱k ta̱tatlaní̱n tí taxámalh ixlháka̱t Jesús hua̱ ta̱ksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Maktum tatalacatzúhui̱lh makapitzi fariseos ixma̱kalhtahuake̱nacán judíos ana ní ixyá Jesús, ixtamina̱chá nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Como ixtascali̱pu̱layá Jesús tá̱cxilhli xlacata ixdiscípulos ni̱ ixca̱makasnekecán maklhu̱hua acxni ixtahua̱yán la̱ ixtali̱smani̱ni̱t judíos talakachixcuhuí Dios, xlacán tzúculh tali̱chihui̱nán ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Hua̱k judíos y fariseos ixtatlahuá tú ixtama̱si̱ni̱t lakko̱lún, xlacán ni̱ tahua̱yán para ni̱ pu̱la ca̱li̱makasnekecán maklhu̱hua chúchut caj la̱ caca̱macasicuna̱tlahuaca xlacata natalakachixcuhuí Dios. ");
INSERT INTO topNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Acxni ixtaqui̱lakó nac pu̱tama̱huán, na̱ chuná ni̱tú ixtahuá para ni̱ tla̱n ixca̱li̱makasnekecán chúchut. Vaso ixpu̱kotnicán, xa̱lu y tú ixtamaclacasquín nac cocina, na̱ chú ixtatlahuá. Hasta ixpu̱tamacán na̱ ixtapuxmaní y lhu̱hua ma̱s li̱lakachixcuhuí̱n ixca̱ma̱si̱nicani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Amá lacchixcuhuí̱n takalasquínilh Jesús: ―¿Hua̱nchi midiscípulos ni̱ talakachixcuhuí Dios? Xlacán ni̱ ca̱macapuxmani̱cán maklhu̱hua acxni tahua̱yán la̱ tama̱si̱ni̱t lakko̱lún. ");
INSERT INTO topNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús ca̱kálhti̱lh: ―Xli̱ca̱na profeta Isaías quílhcha̱lh acxni tzokli la̱ minkasatcán huixín. Xlá chuné huá: Jaé cristianos quintali̱lakachixcuhuí ixtachihuí̱n ixquilhnicán, pero ixnacujcán tunuj tú lacpuhuán. ");
INSERT INTO topNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ni̱tú ca̱li̱macuaní quintalakachixcúhui̱lh pues tú tali̱chihui̱nán hua̱k pi̱huá talacsacxtuni̱t y tali̱macá̱n aquit cca̱ma̱paksi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Huixín ni̱ tlahuayá̱tit la̱ lacasquín Dios nalatapa̱yá̱tit huata tlahuayá̱tit tú puhuaná̱tit ma̱s ca̱mini̱niyá̱n. Huixín ca̱puxmani̱yá̱tit mimpu̱kotnicán mimpu̱hua̱ycán, y lhu̱hua ma̱s tú tlahuayá̱tit, pero ni̱tú li̱macuán. ");
INSERT INTO topNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Lakati̱yá̱tit tlahuayá̱tit tú ca̱ma̱si̱nicani̱tántit y catunu lakmakaná̱tit tú ca̱li̱ma̱paksi̱ni̱tán Dios mili̱tlahuatcán. ");
INSERT INTO topNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Profeta Moisés ma̱lacpuhuá̱ni̱lh Dios natzoka tú natlahuayá̱tit: “Calakalhámanti mina̱na y minti̱cú. Para cha̱tum cristiano kalhtaxtoktí ixna̱na o ta̱ra̱lacata̱quí ixti̱cú, mejor cani̱lh.” ");
INSERT INTO topNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero huixín puhuaná̱tit cha̱tum cristiano tla̱n huaní ixna̱na o ixti̱cú acxni tú maclacasquín: “Ni̱ lá cmakta̱yayá̱n porque lhu̱hua la̱ta tú ckalhí hua̱k xla Corbán.” (Jaé tachihuí̱n huamputún: Quilimosna ni̱ma̱ quili̱má̱xqui̱t Dios.) ");
INSERT INTO topNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Para chuná jaé kalhi̱yá̱tit minati̱cún puhuaná̱tit xlacata yaj mincuentajcán para ni̱ ca̱makta̱yayá̱tit acxni lakko̱luná o acxni tú tamaclacasquín. ");
INSERT INTO topNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chuná jaé huixín lakmakaná̱tit la̱ ca̱li̱ma̱paksi̱ni̱tán Dios nalatapa̱yá̱tit y mejor tlahuayá̱tit tú ca̱ma̱si̱nicaná̱tit. Y mincamancán na̱ chú ca̱huaniyá̱tit natalá y ni̱cxni lakó jaé ni̱ lactlá̱n tapuhuá̱n. Lhu̱hua ma̱s la̱ta tlahuayá̱tit na̱ chuná ni̱tú ca̱li̱macuaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A̱stá̱n la̱ ca̱ta̱chihui̱nanko̱lh fariseos ca̱tasánilh hua̱k cristianos y chuné ca̱huánilh: ―Hua̱k huixín quila̱kaxmatui y cama̱kachakxí̱tit tú camá̱n ca̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Huixín catzi̱yá̱tit xlacata tú huá cha̱tum chixcú an nac ixpu̱lacni y ni̱ la̱kalhí ixtapuhuá̱n, tú la̱kalhí ixtapuhuá̱n huá tú taxtú ixpu̱lacni ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Para kalhi̱yá̱tit mintake̱ncán cakaxpátit tú ma̱s ca̱mini̱niyá̱n mili̱tlahuatcán. ");
INSERT INTO topNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús ca̱kxtakyá̱hualh cristianos y ca̱ta̱tánu̱lh ixdiscípulos nac ixchic. Xlacán takalasquínilh tú ixuamputún amá takalhchihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús ca̱kálhti̱lh: ―¿A poco huixín na̱ ni̱ ma̱kachakxi̱yá̱tit? ¿Ni̱ catzi̱yá̱tit xlacata tú huá cha̱tum chixcú ni̱ la̱kalhí ixtapuhuá̱n? ");
INSERT INTO topNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porque tú huá huata cha̱n nac ixpa̱lu̱hua y a̱stá̱n makampará, pero ni̱cxni cha̱n ixnacú. Jesús ixuamputún xlacata hua̱k li̱hua̱y tla̱n huacán la̱ta lacasquincán. ");
INSERT INTO topNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xlá ca̱huanipá: ―Tú ma̱s la̱kalhí ixtalacapa̱stacni cha̱tum chixcú huá tú lacpuhuama̱xtú ixnacú. ");
INSERT INTO topNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque aná tataxtú hua̱k ni̱ lactlá̱n tapuhuá̱n: hua̱nchi lakamaklhti̱cán ixpusca̱t tunu chixcú, hua̱nchi ca̱kalhi̱cán cati̱hua pusca̱t o chixcú, hua̱nchi la̱makni̱cán, ");
INSERT INTO topNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kalha̱nancán, la̱kskahuicán, lakcatzancán catu̱huá, la̱ksancán, o la̱li̱chihui̱nancán quinta̱cristianoscán, hua̱nchi ca̱lactlahuacán xa̱makapitzi, ca̱lakamaklhti̱cán ixtascujutcán tunu cristianos, tú ixlacata lactlancancán, y lhu̱hua ma̱s ni̱ lactlá̱n talacapa̱stacni tataxtú nac quinacujcán. ");
INSERT INTO topNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hua̱k jaé ni̱ lactlá̱n tapuhuá̱n ni̱ma̱ tamina̱chá ixpu̱lacni cristianos ca̱la̱kalhi̱ní ixtalacapa̱stacnicán ixlacati̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús alh latapu̱lí nac aktuy pu̱latama̱n ixca̱huanicán Tiro y Sidón. Maktum tánu̱lh nac ákxtaka ana ní ixama latamá laktzú ni̱ ixlacasquín tí na̱cxila, pero ni̱ lá tla̱n tátze̱kli. ");
INSERT INTO topNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cha̱tum pusca̱t ni̱ israelita ixuani̱t mákat ní ixlakahuani̱tanchá ixuanicán Sirofenicia, ixkalhí cha̱tum istzuma̱t ni̱ma̱ ixactanu̱ma ixespíritu tlajaná. Xlá cátzi̱lh ana ní ixuí Jesús, ");
INSERT INTO topNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","tuncán lákmilh, y acxni lákchilh tatzokostánilh ixlacatí̱n y huánilh xlacata cama̱ksá̱ni̱lh istzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús tzúculh li̱kalhputzá tachihuí̱n y chuné huánilh: ―Caca̱ma̱xqui quilhtamacú pu̱la cacca̱maktá̱yalh quili̱talakapasni, porque ni̱ tla̱n qui̱taxtú ca̱maklhti̱cán ixtahuajcán camaná̱n xalac Israel y ca̱ma̱xqui̱cán lactzu̱ chichí. ");
INSERT INTO topNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Xlá ma̱kachákxi̱lh ixtachihuí̱n y chuné kalhtí̱nalh: ―Quimpu̱chinacán, xli̱ca̱na tú huana, pero hasta lactzu̱ chichí tla̱n taquilhsacuá lactzu̱ katxtakma ni̱ma̱ tamakxtaka o ni̱ talacasquín lactzu̱ camán. ");
INSERT INTO topNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús kalhti̱pá: ―Clakatí la̱ chihui̱nani̱ta, tla̱n pina mínchic li̱pa̱xáu porque amá ni̱ tla̱n espíritu yaj actanu̱ma mintzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Xli̱ca̱na, acxni cha̱lh ixchic amá pusca̱t ácxilhli istzuma̱t yaj actanu̱ma amá espíritu y majá nac ixpú̱lhtata. ");
INSERT INTO topNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús táxtulh amá pu̱latama̱n huanicán Tiro, tilakatza̱lako̱lh pu̱latama̱n huanicán Sidón na̱ chuná hua̱k lactzu̱ ca̱lacchiquí̱n ni̱ma̱ ixtahuila̱na nac Decápolis y cha̱mpá nac pupunú xla Galilea. ");
INSERT INTO topNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aná li̱minica cha̱tum ko̱ko chixcú, xa̱makapitzi tahuánilh Jesús catláhualh li̱tlá̱n cahuíli̱lh ixmacán nac ixtaké̱n xlacata na̱kahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús tá̱alh amá chixcú lakamákat ana ni̱tí naca̱cxila y aná ma̱nú̱nilh ixmacán lacatuy ixtaké̱n, chujli y xamánilh itsimakat. ");
INSERT INTO topNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A̱stá̱n láca̱lh nac akapú̱n, kalhpá̱ni̱lh y huánilh amá ko̱ko chixcú: ―¡Efata! ―jaé tachihuí̱n huamputún: Caakahuá̱nalh mintaké̱n. ");
INSERT INTO topNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Amá chixcú tuncán cá̱xlalh ixtaké̱n y tla̱n akahuá̱nalh; itsi̱máka̱t na̱ cá̱xlalh y tla̱n chihuí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Hua̱k tí ixca̱ma̱ksa̱ní Jesús ixca̱huaní ni̱ catali̱chihuí̱nalh, pero xlacán ma̱s ixtali̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tí ixtakaxmata la̱ li̱chihui̱nancán ixtapa̱xahuá porque ixtahuán: ―Namá chixcú hua̱k tla̱n tlahuá tú lacasquín, ca̱ma̱chihui̱ní tí ni̱ lá tachihui̱nán ko̱ko, y tí ta̱kata̱pani̱t ca̱ma̱kahua̱ní. ");
INSERT INTO topNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Maktum quilhtamacú tatamákstokli lhu̱hua cristianos ana ní ixuí Jesús ni̱ ixtakalhí tú natahuá. Entonces ca̱tasánilh ixdiscípulos y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Cca̱lakalhamán jaé cristianos porque kalhi̱yá aktutu chichiní la̱ta tahuila̱na y ni̱ takalhí tú natahuá. ");
INSERT INTO topNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ni̱ para lá cca̱huaní cataalhá nac ixchiccán la̱ta ni̱ tahua̱yani̱t porque tla̱n ta̱kuitita̱yá nac tijia pues makapitzi mákat ní tamini̱tanchá. ");
INSERT INTO topNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xlacán takálhti̱lh: ―¿Niculá ixtlahuáu ixca̱ma̱huí̱u porque juú lacatzú ni̱ tahuila̱na ixpu̱sta̱ncan simi̱ta? ");
INSERT INTO topNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Xlá ca̱kalasquínilh: ―¿Nicu macli̱t simi̱ta li̱taná̱tit? ―Mactujún ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A̱stá̱n ca̱huánilh hua̱k cristianos catatahui pu̱tunu nac ca̱tiyatni; ca̱chípalh amá mactujún simi̱ta, pa̱xcatcatzí̱nilh Dios ixtahuá; a̱stá̱n ca̱lakchékelh y ca̱má̱xqui̱lh ixdiscípulos natama̱kpitziní ixli̱hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Makapitzi tamakní na̱ ixtakalhí, xlá na̱ ca̱sicuna̱tláhualh y ca̱ma̱kpitzinica ixli̱hua̱kcán. ");
INSERT INTO topNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Huata lacchixcuhuí̱n ma̱x cha̱ta̱ti mi̱lh ixtahuani̱t, hua̱k takálhkasli y kalhta̱xtulhcú aktujún canasta simi̱ta y tamakní. Acxni tahua̱yanko̱lh Jesús ca̱huánilh cataalhá ixchiccán. ");
INSERT INTO topNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y xlá ca̱ta̱táju̱lh ixdiscípulos nac barco y táalh aktum pu̱latama̱n huanicán Dalmanuta. ");
INSERT INTO topNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Maktum támilh makapitzi fariseos ní ixyá Jesús y tzúculh tata̱ra̱huaní; a̱stá̱n tahuánilh catláhualh aktum tascújut ni̱ma̱ naca̱ma̱lacahua̱ní para xli̱ca̱na Dios ixma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Xlá kalhpá̱ni̱lh li̱lakaputza y chuné ca̱kálhti̱lh: ―¿Hua̱nchi squiná̱tit aktum tascújut naquima̱tlahuí Dios caj xlacata li̱cxilhputuná̱tit? Xli̱ca̱na cca̱huaniyá̱n, ni̱ cama tlahuá tú lacasquiná̱tit ma̱squi tla̱n ctlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Xli̱puntzú ca̱kxtakyá̱hualh, taju̱pá nac aktum barco y ampá ixa̱quilhtu̱tu pupunú. ");
INSERT INTO topNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ixdiscípulos ta̱ktzónksualh natalí̱n tú natahuá y huata ixtakalhí macstum simi̱ta. ");
INSERT INTO topNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","La̱ ixtla̱huama barco Jesús tzúculh ca̱ma̱kalhchihui̱ní ixdiscípulos y ca̱huánilh: ―Skalalh calatapá̱tit xlacata ni̱ naca̱pasayá̱n ixlevadurajcán fariseos y rey Herodes. ");
INSERT INTO topNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Xlacán ni̱ tama̱kachákxi̱lh tucu yá levadura ixca̱li̱ta̱chihui̱nama̱ca y tzúculh tara̱huaní: ―Huá chú quinca̱li̱huanimá̱n porque ni̱ li̱miná̱u simi̱ta tú nahuayá̱u. ");
INSERT INTO topNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús cátzi̱lh tú ixtaquilhuama̱na y ca̱huanipá: ―¿Hua̱nchi huaná̱tit ni̱ li̱taná̱tit simi̱ta tú nahuayá̱tit? ¿Xli̱cana ni̱ ma̱kachakxi̱yá̱tit tú cca̱ma̱si̱niputuná̱n? ¿Minacujcán ni̱ lá ca̱najlá tú aquit tla̱n ctlahuá? ");
INSERT INTO topNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kalhi̱yá̱tit lakastapu y la̱ ni̱ calacahua̱nántit; kalhi̱yá̱tit mintake̱ncán y la̱ ni̱ cakaxpátit y yaj lacapa̱stacá̱tit tú ctláhualh xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Acxni tahuá̱yalh cha̱quitzis mi̱lh cristianos y huata macquitzis simi̱ta ixkalhi̱yá̱tit, ¿nicu akli̱t canastas kalhtá̱xtulh? Xlacán takalhtí̱nalh: ―Akcu̱tuy canastas. ");
INSERT INTO topNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Y acxni tahuá̱yalh cha̱ta̱ti mi̱lh ixkalhi̱yá̱tit mactujún simi̱ta, ¿nicu akli̱t canasta ma̱makstóktit? ―Aktujún ―takalhti̱nampá. ");
INSERT INTO topNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Entonces Jesús ca̱huánilh: ―Hasta chí ya̱ ma̱kachakxi̱yá̱tit xlacata tunu tú cca̱li̱ta̱chihui̱namá̱n porque aquit ni̱ cli̱puhuán tú nacuá cha̱li cha̱lí. ");
INSERT INTO topNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tácha̱lh aktum ca̱chiquí̱n huanicán Betsaida. Acxni tá̱ctalh Jesús li̱minica cha̱tum lakatzí̱n y huanica catláhualh li̱tlá̱n cama̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús li̱lh amá lakatzí̱n ixquilhpa̱n ca̱chiquí̱n, aná lacahuíli̱lh ixchújut ixlakastapu y kalasquínilh para tla̱ná lacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Xlá kalhtí̱nalh: ―Cca̱cxila lacchixcuhuí̱n la̱ quihui huata porque tatla̱huán. ");
INSERT INTO topNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús huili̱nipá ixmacán ixlakastapu amá chixcú; acs tá̱yalh puntzú uyu tla̱n aksa̱nanko̱lh porque tla̱n lacahuá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma̱lakácha̱lh ixchic y chuné ma̱páksi̱lh: ―Chí ni̱ naj capit ixpu̱lacni ca̱chiquí̱n y ni̱tí cali̱ma̱kalhchihui̱ni la̱ aksa̱nani̱ta. ");
INSERT INTO topNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A̱stá̱n ca̱tá̱alh ixdiscípulos lactzu ca̱lacchiquí̱n xalac aktum pu̱latama̱n huanicán Cesarea de Filipo. Nac tijia ca̱kalhpútzalh ixdiscípulos y chuné ca̱kalasquínilh: ―¿Ticu yá chixcú quintali̱macá̱n cristianos? ");
INSERT INTO topNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xlacán takalhtí̱nalh: ―Makapitzi tahuán xlacata huix Juan Bautista, tunu tahuán huix Elías lacastacuanampá ca̱quilhtamacú, y tahuila̱na tunu tí tahuán xlacata huix ma̱x cha̱tum la̱ ni̱ma̱ taqui̱lani̱tanchi xapu̱lh nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Y huixín, ¿ticu yá chixcú quila̱li̱maca̱náu? ―ca̱kalasquínilh. Pedro tancs kálhti̱lh: ―Huix Cristo tí ma̱lakacha̱ni̱t Dios ama quinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Acxni káxmatli Jesús ixquilhcha̱ni̱t Pedro hua̱k ca̱huánilh ni̱ catali̱chihuí̱nalh tú ixtacatzí. ");
INSERT INTO topNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A̱stá̱n tzúculh ca̱li̱ta̱chihui̱nán la̱ ixama tama̱kxtakajní xalakko̱rojtzi̱n judíos, xanapuxcun curas, ixma̱kalhtahuake̱nacan judíos, porque xlacán ni̱ ixta̱má̱n taca̱najlá la̱ ixama ca̱li̱ta̱chihui̱nán Dios, hasta ixta̱má̱n tamakní, pero xlá ixliaktutu chichiní ixama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Staranca ca̱huánilh tú ixama pa̱xtoka, entonces Pedro li̱lh lakamákat tziná y tzúculh li̱huaní hua̱nchi chú ixchihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Xlá talakáspitli pakán ní ixtahuila̱na xa̱makapitzi ixdiscípulos y chuné kahuánilh Pedro: ―Catake̱nu ní cyá chixcú tí ma̱lacpuhua̱ní tlajaná, porque huix lacpuhuana la̱ xa̱makapitzi tapuhuán cama ma̱paksi̱nán y ni̱ la̱ quima̱lakacha̱ni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A̱stá̱n ca̱ma̱mákstokli hua̱k cristianos na̱ chuná ixdiscípulos y chuná ca̱ta̱chihuí̱nalh: ―Amá tí quintakokeputún pu̱la ca̱ktzónksualh la̱ta tú kalhí y tú lakatí ca̱quilhtamacú, ni̱ cajicuánilh akxtakajnán cquimpa̱xtú̱n caj quilacata, a̱stá̱n caquintakókelh cani̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Amá tí makli̱huán lakma̱xtuputún ixli̱stacni ama makatzanká tú lakcatzán, pero tí ni̱ lakcatzán makatzanká ixli̱stacni caj quilacata o xlacata ixtachihuí̱n Dios li̱chihui̱nán, namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Quila̱huaníu, ¿tucu li̱macuaní cha̱tum chixcú ixkálhi̱lh lhu̱hua tumi̱n y lhu̱hua tíyat ca̱quilhtamacú para ixacstu lactlahuá ixli̱stacni y nalaktzanká? ");
INSERT INTO topNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O, ¿puhuaná̱tit huixín cha̱tum cristiano a̱stá̱n tla̱n ma̱lacnu̱ní Dios ixtumi̱n xlacata nalakma̱xtú ixli̱stacni y ni̱ na̱kxtakajnán? ");
INSERT INTO topNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na̱ chuná la̱ta tú cca̱li̱ta̱chihui̱naná̱n y cca̱huaniyá̱n la̱ nalatapa̱yá̱tit, para huixín quila̱li̱ma̱xananá̱u ixlacati̱ncán jaé ni̱ lactlá̱n cristianos xala ca̱quilhtamacú porque xlacán ni̱ taca̱najlá xlacata Dios quima̱lakacha̱ni̱t, aquit Xatalacsacni Chixcú na̱ cama li̱ma̱xanán ixlacatí̱n Quinti̱cú Dios acxni aquit nacmimpará y nacca̱ta̱mín ángeles xlacata hua̱k nata̱cxila la̱ ixli̱lanca kalhí ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Chuné ca̱ta̱chihui̱nanko̱lh: ―Xli̱ca̱na cca̱huaniyá̱n, lhu̱hua la̱ta tí taya̱na juú ya̱ taní nahuán acxni nata̱cxila la̱ ama quilhtzucú ixtapáksi̱t Dios nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ixliakcha̱xán chichiní a̱stá̱n Jesús ca̱tá̱alh ixdiscípulos Pedro, Jacobo y Juan nac aktum lanca sipi. Acxni tácha̱lh Jesús tzúculh tapalaja la̱ ixtasí siempre. ");
INSERT INTO topNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ixlháka̱t staranka lako̱lh y slipua la̱ nieve; ni̱ huí ca̱quilhtamacú tí tla̱n ixma̱staránke̱lh lháka̱t ma̱squi tla̱n ixcháke̱lh la̱ ni̱ma̱ tá̱cxilhli ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ixli̱puntzú tá̱cxilhli la̱ talákchilh ní ixyá Jesús profeta Moisés y profeta Elías y tzúculh tata̱chihui̱nán. Jaé profetas maka̱sá ixtani̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro chuné huánilh Jesús: ―Maestro, tla̱nia̱ tla̱n la̱ cmiu porque tla̱n xactlahuáu aktutu chiqui, aktum milá, xa̱ktum xla Moisés, y xa̱ktum xla Elías. ");
INSERT INTO topNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ixdiscípulos ixtajicuankṉo̱ni̱t y Pedro ni̱ ixcatzí tú ixchihui̱nama. ");
INSERT INTO topNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A̱stá̱n tá̱cxilhli la̱ tá̱ctalh aktum puclhni nac ixíta̱t ca̱ta̱yánilh, y takaxmáti̱lh jaé tachihuí̱n ni̱ma̱ minchá nac akapú̱n: ―Huá jaé quinkahuasa ni̱ma̱ aquit clakalhamán, cakaxpáttit tú ca̱li̱ma̱paksi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Acxni talaca̱mpá yaj tú ixtaya̱na tí ixtata̱chihui̱nani̱t a̱huata ixacstu ixyá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","A̱stá̱n Jesús ca̱ta̱talacá̱ctalh ixdiscípulos y ca̱huánilh ni̱tí catahuánilh tú xlacán ixta̱cxilhni̱t hasta xní xlá nalacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xlacán ni̱ tali̱chihuí̱nalh tú ixta̱cxilhni̱t y huata ixtara̱kalasquiní: ―¿Cha̱ tucu huamputún, o niculá qui̱taxtú nalacastacuanán ca̱li̱ní̱n? ");
INSERT INTO topNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Huá xlacata chuné takalasquínilh Jesús: ―¿Hua̱nchi tí tama̱sí ixley Moisés tahuán xlacata antes namín Cristo pu̱la ama min ca̱quilhtamacú profeta Elías? ");
INSERT INTO topNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jesús ca̱kálhti̱lh: ―Xli̱ca̱na tú tahuán ni̱ ta̱ktzanka̱ni̱t, pues Elías pu̱la ama min ca̱xtlahuá y ma̱tancsá tijia. Pero aquit cca̱huaniyá̱n, Elías qui̱lachitá ca̱quilhtamacú y lhu̱hua ni̱ talakápasli porque tlahuanica tú lacasquinca la̱ ixuán nac Escrituras ama pa̱xtoka. Chí aquit na̱ cca̱kalasquiniyá̱n: ¿Tucu huan Escrituras ama pa̱xtoka Xatalacsacni Chixcú? ¿Ni̱ catzi̱yá̱tit la̱ huan cama akxtakajnán, lhu̱hua tamá̱n quintalakmakán, porque ni̱ tamá̱n quintali̱pa̱huán? ");
INSERT INTO topNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ixli̱puntzú talákcha̱lh ní ixtahuila̱na xa̱makapitzi ixdiscípulos. Tá̱cxilhli lhu̱hua cristianos y makapitzi ixma̱kalhtahuake̱nacan judíos tali̱makspitya̱na y tata̱ra̱huanima̱na. ");
INSERT INTO topNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Makapitzi cristianos acxni tá̱cxilhli Jesús tapa̱xahuako̱lh y tatza̱lh táalh tahuaní kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús ca̱kalasquínilh: ―¿Tucu li̱chihui̱nampa̱nántit? ");
INSERT INTO topNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tí ma̱s lacatzú ixyá kalhtí̱nalh: ―Maestro, cli̱mín quinkahuasa actanu̱ma ixespíritu tlajaná yaj lá chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","La̱ta cani̱huá lapu̱lá ma̱kuití y trami̱ya̱chá ca̱tiyatni y tzucú quilhpupú y quitxui̱cnán. Huá xlacata ke̱tzú lako̱ma. Cca̱huánilh midiscípulos catamacmá̱xtulh pero ni̱ lá tama̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús chuné ca̱ta̱chihuí̱nalh: ―Koxitaní̱n huixín cristianos. ¿Hua̱nchi ni̱ lá ca̱najlayá̱tit tú cca̱li̱ma̱kalhchihui̱ni̱yá̱n? ¿Hasta xnicu camá̱n ca̱ta̱latama̱yá̱n y ca̱pa̱ti̱niyá̱n la̱ ni̱ lá quila̱li̱pa̱huaná̱u? Cali̱tántit namá kahuasa. ");
INSERT INTO topNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Li̱minica amá kahuasa y acxni ácxilhli Jesús amá tlajaná ma̱kuítilh y tama̱chá ca̱tiyatni, tatlanama y quilhpupuma amá kahuasa. ");
INSERT INTO topNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kalasquínilh ixti̱cú: ―¿Nicu akli̱t quilhtamacú kalhí la̱ta jaé chú lá minkahuasa? ―La̱ta ixli̱ctzú ―kalhtí̱nalh xati̱cú―, ");
INSERT INTO topNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","y maklhu̱hua jaé tlajaná aktlakanú nac lhcúya̱t, o nac chúchut porque makni̱putún. Huá cli̱huaniyá̱n para tla̱n ma̱ksa̱ni̱ya, quila̱lakalhamáu y quila̱makta̱yáu. ");
INSERT INTO topNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús kálhti̱lh: ―Para xli̱ca̱na ca̱najlaya na̱ksa̱nán, porque tí xli̱ca̱na ca̱najlá tú lacasquín hua̱k tla̱n tlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Amá chixcú kalhtí̱nalh: ―Xli̱ca̱na cca̱najlá tú clacasquín, pero quimakta̱ya la̱ ma̱s nacli̱pa̱huaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús acxni ácxilhli lhu̱hua tzúculh tatamakstoka huánilh tuncán amá tlajaná: ―Aquit cli̱ma̱paksi̱yá̱n, camactáxtu namá kahuasa y ya̱cxni camactanu, porque huix yaj ma̱kahua̱ni̱ya y yaj lá ma̱chihui̱ni̱ya. ");
INSERT INTO topNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Amá espíritu aktásalh y ma̱kuitipá, pero mactáxtulh; xlá tama̱chá ca̱tiyatni la̱ xaní̱n, lhu̱hua tapuhuanko̱lh xlacata ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús makachípalh, má̱qui̱lh lakasu̱t y tla̱n aksa̱nanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A̱stá̱n Jesús alh nac ákxtaka ní ixtamakxtaka ixdiscípulos takalasquínilh: ―¿Hua̱nchi aquín ni̱ lá cacma̱xtúu amá kahuasa ixespíritu tlajaná? ");
INSERT INTO topNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Xlá ca̱kálhti̱lh: ―Huixín ni̱ kalhtahuakaniyá̱tit Dios, ni̱ para katxtaknaná̱tit la̱ aquit pues huata chuná tla̱n ca̱tamacxtucán jaé xta̱lá tlajananí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A̱stá̱n ca̱tá̱alh ixdiscípulos a̱lacatunu; tati̱lakatzá̱lalh Galilea pero ni̱ lacásquilh tí na̱cxila. ");
INSERT INTO topNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque lhu̱hua tú ixca̱ma̱si̱niputún huata ixdiscípulos; na̱ ca̱li̱ma̱kalhchihuí̱ni̱lh la̱ ixama tama̱kxtakajní ixenemigos, la̱ ixama tamakní pero ixliaktutu chichiní xlá ixama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Xlacán ni̱ ixtama̱kchakxí la̱ jaé ixama qui̱taxtú pero ixtama̱xanán tza̱pu tza̱pu natakalasquiní. ");
INSERT INTO topNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Nac tijia ixdiscípulos ixtara̱huaniti̱lhá ticu yá ixdiscípulos ma̱s ixli̱pa̱huán Jesús. Acxni tácha̱lh nac Capernaum tatánu̱lh ixakxtakacán y chuné ca̱kalasquínilh Jesús: ―¿Tucu la̱n ixli̱chihui̱nanti̱lhayá̱tit nac tijia? Xlacán ni̱ takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pero Jesús ixcatzi̱yá tú ixtachihui̱nani̱t. A̱stá̱n curucs tahui y ca̱tasaniko̱lh ixdiscípulos catatahui ma̱s lacatzú y chuné ca̱huánilh: ―La̱ta huixín tí ma̱s xatali̱pa̱u huamputún y ca̱ma̱paksi̱putún xa̱makapitzi, ixpakstá̱n ama tamakxtaka y naca̱macuaní ixcompañeros xatu̱ta yá tascújut natama̱tlahuí. ");
INSERT INTO topNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A̱stá̱n tasánilh cha̱tum actzu kahuasa, yá̱hualh nac ixíta̱t, chixli y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Tí lakalhamán cha̱tum actzu kahuasa la̱ jaé porque catzí aquit clakalhamán, na̱ chuná la̱ aquit caquilakalhámalh y na̱ chuná la̱ capá̱xqui̱lh Dios tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ixli̱puntzú Juan huánilh Jesús: ―Quimpu̱chinacán, cca̱cxilhui cha̱tum chixcú mintacuhui̱ní li̱quilhán y ca̱ma̱ksa̱ni̱ma tí ca̱ctanu̱ma ixespiritucán tlajananí̱n. Como ni̱ quinca̱ta̱lapu̱layá̱n cuaníu yaj tí cama̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús huánilh: ―Ni̱ ixtili̱huanítit porque tí ca̱ma̱ksa̱ní cristianos y quintacuhui̱ní li̱quilhán ni̱ lá quiliakskahuinán a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Xa̱huá para cha̱tum cristiano ni̱ quinca̱lakmakaná̱n, lakatí quintascujutcán. ");
INSERT INTO topNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aquit cca̱huaniyá̱n, cati̱huá tí ixca̱ma̱xquí̱n ca̱na aktum poke chúchut caj xlacata catzí aquit quila̱ta̱lapu̱layá̱u, xli̱ca̱na cca̱huaniyá̱n, tzanka̱xni ama maklhti̱nán ixtaxokó̱n. ");
INSERT INTO topNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Cati̱hua cristiano tí akastacya̱huá natlahuá tala̱kalhí̱n xlacata naquinta̱ktzonksuá jaé lactzú camán tí quintalakalhamán y tzucuni̱t quintali̱pa̱huán, ma̱s tla̱n ixuá ixpixchi̱huacaca aktum lanca chíhuix ixtáju̱lh nac pupunú xlacata namu̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Cca̱huaniyá̱n, para mimacán makta̱yayá̱n natlahuaya tala̱kalhí̱n ixlacati̱n Dios ma̱s macuaniyá̱n cachúcu̱cti y camákanti mákat pues ma̱s tla̱n nachipina nac akapú̱n makaputu que nakalhi̱ya aktuy mimacán namacapincana nac puakxtakajni, ");
INSERT INTO topNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","nac lhcúya̱t ni̱ma̱ siempre pasama y ta̱kxtakajni ni̱cxni laksputa. ");
INSERT INTO topNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Para mintantú̱n makta̱yayá̱n natlahuaya tala̱kalhí̱n catantu̱ca̱cti̱ca porque ma̱s macuaniyá̱n nachipina tantu̱putu nac akpú̱n que nakalhi̱ya hua̱k mintantú̱n y chú namacapincana nac pu̱pa̱ti̱n, ");
INSERT INTO topNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","nac lhcúya̱t y cani̱cxnihuá akxtakajnámpa̱t nahuán. ");
INSERT INTO topNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y para milakastapu ma̱laktzanke̱yá̱n, cama̱xtu; ma̱s macuaniyá̱n nachipina lakatzí̱n ixlacati̱n Dios lakatu que la̱ta lactlá̱n milakastapu namaca̱ná̱n nac pu̱pa̱ti̱n, ");
INSERT INTO topNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nac lhcúya̱t ana ní ni̱cxni catilako̱lh minta̱kxtakajni. ");
INSERT INTO topNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Hua̱k cristianos ama̱ca ca̱li̱cxilhcán lhcúya̱t para takalhí mátzat la̱ aktum tahuá. Mátzat snu̱n la̱n porque ma̱skoké tahuá xlacata kama nahuán. ");
INSERT INTO topNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na̱ chuná huixín caputzátit ta̱layá̱tit tla̱n mátzat milatama̱tcán, ni̱tí casi̱tzi̱nítit xlacata li̱pa̱xáu y tla̱n naca̱ta̱latapa̱yá̱tit minta̱cristianoscán. ");
INSERT INTO topNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús taxtupá nac Capernaum ca̱ti̱lakatza̱lako̱lh tí ixtalama̱na ixli̱quilhtu̱nchá kalhtu̱choko Jordán y cha̱lh aktum pu̱latama̱n huanicán Judea. La̱ta ní ixchá̱n lhu̱hua cristianos ixtatamakstoka y xlá ixca̱ma̱kalhchihui̱ní la̱ siempre ixcatzi̱ní. ");
INSERT INTO topNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Maktum táchilh makapitzi fariseos caj ixtakalhputzaputún xlacata nahuán tú ni̱ chú qui̱taxtú, y takalasquínilh para cha̱tum chixcú mini̱ní na̱kxtakmakán ixta̱cha̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús ca̱kálhti̱lh: ―¿Niculá ca̱li̱ma̱paksí̱n profeta Moisés? ");
INSERT INTO topNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","―Xlá li̱ma̱paksí̱nalh xlacata cha̱tum chixcú tla̱n makxtaka ixta̱cha̱t para talacca̱xlá cpu̱ma̱paksi̱n y ma̱xquí aktum xatalacca̱xlán cápsnat ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Xlá ca̱huanipá: ―Moisés má̱sta̱lh namá tapaksí̱n porque minacujcán snu̱n lani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero acxni Dios ma̱lacatzúqui̱lh y tláhualh la̱ta tú huilako̱lh ca̱quilhtamacú huata tláhualh cha̱tum pusca̱t y cha̱tum chixcú. ");
INSERT INTO topNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Huá xlacata cha̱tum kahuasa naca̱makxtaka ixnati̱cún y nata̱tamakaxtoka ixta̱cha̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ixcha̱tuycán la̱ cha̱tum cristiano natahuán porque acxtum natahuán, porque acxtum natama̱paksi̱nán y natara̱lakalhamán. ");
INSERT INTO topNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Huá cca̱li̱huaniyá̱n, ni̱ huí cristiano tí nama̱pitzí tú Dios ma̱lakxtumi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","A̱stá̱n la̱ ca̱ta̱chihui̱nanko̱lh amá fariseos Jesús tánu̱lh ní ixtatamakxtaka y ixdiscípulos takalasquínilh tú ixuamputún amá takalhchihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Xlá ca̱huánilh: ―Tí akxtakmakán ixta̱cha̱t caj xlacata ta̱tamakaxtoka tunu pusca̱t lhu̱hua tala̱kalhí̱n kalhí ixlacati̱n Dios con xla̱huán ixma̱hui̱ná. ");
INSERT INTO topNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na̱ chuná tí makxtaka ixta̱ko̱lú caj xlacata tunu chixcú ta̱án namá pusca̱t lhu̱hua tala̱kalhí̱n tlahuaní xla̱huán ixta̱ko̱lú. ");
INSERT INTO topNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ixli̱puntzú li̱minca makapitzi lactzú camán xlacata naca̱mu̱sicuna̱tlahuá, pero ixdiscípulos tzúculh takahuaní amá tí ixtali̱mín lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Acxni cá̱cxilhli Jesús sí̱tzi̱lh tziná y chuné ca̱huánilh ixdiscípulos: ―Caca̱makxtáktit catalí̱milh namá lactzu camán y ni̱ caca̱li̱huanítit porque Dios lakatí ca̱maktakalha tí ni̱ lá talatamá ixacstucán y tamaclacasquín tí naca̱makta̱yá la̱ jaé lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xli̱ca̱na cca̱huaniyá̱n, nac akapú̱n huata ta̱má̱n tatanú cristianos tí tamaclacasquín naca̱makta̱yá Dios ixlatama̱tcán na̱ chuná la̱ cha̱tum kahuasa maclacasquín naca̱najlá tú li̱ta̱chihui̱nancán. ");
INSERT INTO topNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A̱stá̱n cá̱chixli amá lactzu camán y ca̱li̱mu̱sicuna̱tláhualh ixmacán. ");
INSERT INTO topNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús alh a̱lacatunu y acxni ixtla̱huama tatza̱lh lákmilh cha̱tum kahuasa; tatzokostánilh ixlacatí̱n y chuné huánilh: ―Maestro, huix tla̱n catzi̱ya, quihuani, ¿tucu nactlahuá xlacata naquimacuaní nacli̱lakma̱xtú quili̱stacni nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kálhti̱lh: ―¿Hua̱nchi quihuaniya tla̱n ccatzí? Huata Dios tla̱n catzí ni̱ma̱ huí nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Para catzi̱ya catlahua tú li̱chihui̱nán ti̱pa̱katzi ixtapáksi̱t Moisés: “Ni̱ cata̱chihuí̱nanti tunu pusca̱t para kalhi̱ya minta̱cha̱t; ni̱ camakni minta̱cristiano; ni̱tí camakkálhanti tú kalhí; ni̱tí caliakskahuínanti tú ni̱ ca̱na; y caca̱lakalhámanti minti̱cu y mina̱na.” ");
INSERT INTO topNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Xlá kalhtí̱nalh: ―La̱ta quili̱ctzú ctlahuani̱t cquilatáma̱t namá tú tali̱chihui̱nán ixtapáksi̱t Moisés. ");
INSERT INTO topNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús huanipá: ―Pero huí tú tzanka̱niyá̱n: casta̱t la̱ta tú kalhi̱ya, caca̱ma̱xqui pobres; a̱stá̱n naquilaktana naquintakokeya xlacata lakasu̱t nali̱pina minta̱kxtakajni quimpa̱xtú̱n; y chuná xli̱ca̱na rico pa̱t huana nac akapu̱n para lakma̱xtuya mili̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Acxni káxmatli tú huánilh Jesús alh ixchic lakaputzati̱lhá porque snu̱n rico ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús láca̱lh cani̱huá y ca̱huánilh ixdiscípulos: ―Xli̱ca̱na cca̱huaniyá̱n, tuhua ama ca̱qui̱taxtuní ricos natachá̱n nac akapú̱n ní huí Dios. ");
INSERT INTO topNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xlacán ni̱ tacátzi̱lh hua̱nchi chú ixca̱ta̱chihui̱nani̱t pero xlá ca̱huanipá: ―Huixín la̱ quincamán y cca̱huaniyá̱n, hua̱k cristianos tí takalhí lhu̱hua tumi̱n y ca̱ma̱laktzanke̱ní ixtalacapa̱stacnicán, tuhua ama ca̱qui̱taxtuní natachá̱n ixpa̱xtú̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ma̱s ni̱ tuhua tla̱n tanú tantum camello nac istzán li̱xtokon que cha̱tum rico nama̱tla̱ní tú ma̱lacnú Dios nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ixdiscípulos tali̱puhuanko̱lh, ni̱ ixtacatzí tú natahuán porque ni̱ tama̱kachákxi̱lh. Huá xlacata ixtara̱kalasquiní: ―Para chú ama qui̱taxtú, ¿ticu tancs ama lakma̱xtú ixli̱stacni nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús ca̱káxmatli y chuné ca̱ta̱chihuí̱nalh: ―Para cha̱tum chixcú ixacstu li̱tanú nata̱yaní nalakma̱xtú ixli̱stacni, ni̱ lá ama tlahuá. Pero Dios hua̱k tla̱n tlahuá tú lacasquín. ");
INSERT INTO topNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Entonces Pedro kalasquínilh: ―Quimpu̱chinacán, aquín cakxtakmakani̱táu hua̱k la̱ta tú xackalhi̱yá̱u y cca̱takokeni̱tán, ¿tucu amá̱n quinca̱toca̱rli̱yá̱n? ");
INSERT INTO topNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús kálhti̱lh: ―Xli̱ca̱na cca̱huaniyá̱n, cati̱hua cristiano tí akxtakmakán la̱ta tú kalhí para ixchic, ixnata̱camán, ixta̱cha̱t, ixcamán, o ixca̱quihuí̱n ní ixcha̱lhca̱tnán caj xlacata quintakoké, o xlacata ca̱ma̱kalhchihui̱ní cristianos la̱ naca̱ma̱tzanke̱naní Dios ixtala̱kalhi̱ncán, ");
INSERT INTO topNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aquit cca̱huaniyá̱n xlacata ama kalhí ma̱s lhu̱hua la̱ ixchic la̱ta ní nachá̱n, lhu̱hua la̱ ixnata̱camán, la̱ ixnati̱cún, lhu̱hua la̱ ixcamán, y lhu̱hua la̱ ixca̱quihuí̱n ama taka̱sa; ma̱squi lhu̱hua tamá̱n tasi̱tzi̱ní caj quilacata, ama ca̱lakmakancán y ca̱pu̱tlakami̱cán cani̱huá, pero xlacán nac akapú̱n tamá̱n takalhí li̱pa̱xau latáma̱t. ");
INSERT INTO topNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amá quilhtamacú lhu̱hua cristianos tí ca̱lakmakancán juú ca̱quilhtamacú ixpakstá̱n ca̱maca̱ncán, aná pu̱la ama̱ca ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán; y tí ca̱ma̱pu̱li̱cán juú ca̱quilhtamacú pu̱la ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán, aná ixpakstá̱n ama̱ca ca̱maca̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Cha̱lh quilhtamacú acxni Jesús a̱huata tica̱tá̱alh ixdiscípulos nac ca̱chiquí̱n xla Jerusalén. Xlacán ixtajicuanti̱lhá ixta̱katuyunti̱lhá porque ya̱ tla̱n ixtama̱kachaxí tú ixama pa̱xtoka Jesús. Acxni tácha̱lh lacatum tze̱k ca̱tá̱alh tziná lakamákat y tzúculh tla̱n ca̱li̱ta̱chihui̱nán tú ixama akspulá. ");
INSERT INTO topNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Chuné ca̱huánilh ixdiscípulos: ―Huixín catzi̱yá̱tit xlacata ama̱náu nac Jerusalén ana ní aquit Xatalacsacni Chixcú ama̱ca quimacama̱sta̱cán ixmacancán quienemigos xanapuxcun curas y ixma̱kalhtahuake̱nacán judíos; xlacán ta̱má̱n tali̱ma̱paksi̱nán naquili̱ncán ixlacati̱ncan xanapuxcun ma̱paksi̱naní̱n romanos xlacata naquintama̱kalhapalí. ");
INSERT INTO topNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Xlacán ta̱má̱n quintalacachucxuí, quintasnoka y catu̱huá ta̱má̱n quintali̱chiyá hasta xli̱ca̱na quintamakní; pero ixliaktutu chichiní aquit cama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ixlakkahuasán Zebedeo, Jacobo y Juan, tama̱lacatzúhui̱lh Jesús y chuné tahuánilh: ―Quimpu̱chinacán, clacasquiná̱u quila̱tlahuaníu aktum li̱tlá̱n ni̱ma̱ camá̱n ca̱maksquiná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","―¿Tucu lacasquiná̱tit cactláhualh milacatacán? ―ca̱huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","―Acxni naca̱makatlajaya mienemigos y natahuilaya cmimpu̱ma̱paksi̱n clacasquiná̱u cha̱tunu aquín nactahuilayá̱u mimpa̱xtú̱n xlacata nacca̱ta̱ma̱paksi̱naná̱n ―ta̱chihui̱nanko̱lh xlacán. ");
INSERT INTO topNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús ca̱huanipá: ―Huixín ni̱ catzi̱yá̱tit tú squimpa̱nántit. ¿A poco tla̱n nata̱yaniyá̱tit nakotá̱tit amá xu̱n chúchut xla ta̱kxtakajni ni̱ma̱ ama̱ca quima̱xqui̱cán? ");
INSERT INTO topNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Tla̱n nacta̱yaniyá̱u ―takalhti̱nampá. Entonces Jesús chuné ca̱ta̱chihuí̱nalh: ―Xli̱ca̱na na̱ pa̱t kotá̱tit namá xu̱n chúchut ni̱ma̱ cama kota, na̱ chuná ta̱kxtakajni ni̱ma̱ ama̱ca quima̱xqui̱cán, huixín tiene que nata̱yaniyá̱tit; ");
INSERT INTO topNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","pero la̱ huixín tahuilaputuná̱tit quimpa̱xtú̱n acxni nacma̱paksi̱nán ni̱ lá cca̱huaniyá̱n para tla̱n porque huata Dios catzí naca̱ma̱xquí tí ca̱mini̱ní y aquit ni̱ lá cma̱stá pu̱táhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Acxni tacátzi̱lh xa̱makapitzi ixdiscípulos tú ixtalacasquín Jacobo y Juan, hua̱k tasi̱tzí̱nilh xa̱makapitzi discípulos. ");
INSERT INTO topNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús hua̱k ca̱tasánilh catatalacatzúhui̱lh, y chuné ca̱huánilh: ―Huixín catzi̱yá̱tit xlacata xanapuxcun ma̱paksi̱naní̱n tí tama̱paksi̱nán aktum pu̱latama̱n hua̱k ta̱kchipá la̱ta tú huí ca̱chiquí̱n, y tí xalactali̱pau ta̱kskahuimaklhtí tú talacasquín tí ni̱ lactali̱pa̱u cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","La̱ta huixín tí quila̱takokeyá̱u ni̱ chú catica̱qui̱taxtunín, porque tí ma̱s tali̱pa̱u lactaxtú ama ma̱tla̱ní naca̱macuaní xa̱makapitzi tú natama̱tlahuí. ");
INSERT INTO topNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y tí xapuxcu lactaxtuputún xlacata naca̱ma̱paksí xa̱makapitzi ama ma̱tla̱ní nali̱tamakxtaka la̱ cha̱tum tasa̱cua tí ma̱paksi̱cán. ");
INSERT INTO topNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aquit Xatalacsacni Chixcú ni̱ cmini̱t lactlancán xlacata naquintamacuaní cristianos, aquit cha̱ cmini̱t ca̱macuaní cristianos tú naquintali̱ma̱paksí, y na̱ cama ca̱lacati̱ta̱yá ixlacati̱n Dios xlacata nacxoko̱nán ixtala̱kalhi̱ncán ni̱ma̱ tatlahuanit, aquit cama ní ixlacatacán. ");
INSERT INTO topNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tácha̱lh aktum ca̱chiquí̱n huanicán Jericó huata tati̱lakatzá̱lalh, lhu̱hua ixtatakokeni̱t Jesús. Acxni ixtataxtuma̱na cha̱tum lakatzí̱n huanicán Bartimeo ixkahuasa Timeo ixuani̱t, ixuí nac ixpa̱xtu̱n tijia squima limosna. ");
INSERT INTO topNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Acxni cátzi̱lh talacatzuhui̱ma Jesús tzúculh ma̱ktasí: ―¡Jesús, ixkahuasa rey David, catlahua li̱tlá̱n, caquima̱ksa̱ni! ");
INSERT INTO topNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lhu̱hua tzúculh talacaquilhní xlacata acs catahui, pero xlá ma̱s chá tzúculh ma̱tasí: ―¡Jesús ixkahuasa rey David, caquilakalhámanti! ");
INSERT INTO topNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús tá̱yalh puntzú y ca̱huánilh xa̱makapitzi: ―Cahuani camilh namá lakatzí̱n. Cha̱tum alh tasaní y chuné huánilh: ―Capa̱xahua y cata̱ya porque Jesús tasanimá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Xlá tramákalh ixpilísa̱lh, lacapala tá̱yalh y talacatzúhui̱lh ní ixyá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Xlá kalasquínilh: ―¿Tucu lacasquina cactláhualh milacata? ―Quimpu̱chinacán, aquit clacahua̱namputún ―kálhti̱lh amá lakatzí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","―Tla̱n pina ní lacasquina, huix pa̱t lacahua̱nana porque quili̱pa̱huani̱ta ―huaniko̱lh Jesús. Amá chixcú tuncán lacahuá̱nalh. A̱stá̱n na̱ takókelh Jesús ní ixama. ");
INSERT INTO topNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tácha̱lh aktum sipi huanicán Monte de los Olivos lacatzú aktuy ca̱chiquí̱n ca̱huanicán Betfagé y Betania; jaé ca̱chiquí̱n ixtata̱pakxtoka Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Aná Jesús chuné ca̱ma̱páksi̱lh cha̱tuy ixdiscípulos: ―Capítit amá ca̱chiquí̱n ni̱ma̱ ca̱cxilhma̱náu juú lacatzú. Acxni nachipiná̱tit nac aktum ákxtaka pa̱t taka̱sá̱tit tantum sa̱sti burro ni̱ naj tí pu̱tahuacani̱t; naxcutá̱tit y nali̱taná̱tit. ");
INSERT INTO topNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Para tí ca̱kalasquiniyá̱n tucu li̱tlahuayá̱tit, cahuanítit: “Quimaestrojcán maclacasquín; a̱stá̱n ama xtakpará tuncán la̱ namaclacasquinkó.” ");
INSERT INTO topNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xlacán táalh y xli̱ca̱n tatáka̱sli tantum burro tachí̱n lacatzú nac puhui̱lhta pakán nac tijia. Lihua ixtaxcutma̱na ");
INSERT INTO topNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","acxni makapitzi tí ixtalaya̱na lacatzú tá̱cxilhli y chuné ca̱huanica: ―¿Tucu li̱tlahuayá̱tit namá burro? ¿Hua̱nchi xcutpa̱nántit? ");
INSERT INTO topNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Xlacán takalhtí̱nalh la̱ ixca̱huanini̱t Jesús natahuán; a̱stá̱n yaj tú ca̱huanica y ca̱makxtakca natalí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Acxni talí̱cha̱lh ní ixuí Jesús tali̱ke̱tlápalh ixpilisa̱lhcán y xlá pu̱tahuácalh. ");
INSERT INTO topNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tuncán táalh pakán nac Jerusalén. La̱ta ní ixlactla̱huama Jesús lhu̱hua ixtatramí ixpilisa̱lhcán nac tijia y makapitzi ixtaquí itxánat, ixpakán ke̱ske y na̱ chuná ixtatramí. ");
INSERT INTO topNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Hua̱k cristianos tí ixtasta̱lá o ixtapu̱lá tzúculh tama̱ktasí Jesús: ―¡Clakachixcuhui̱yá̱u Dios! ¡Siempre calatáma̱lh nahuán namá chixcú tí ma̱lakacha̱ni̱t Dios! ");
INSERT INTO topNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Camakapa̱xáhualh Dios namá xapuxcu chixcú ni̱ma̱ ama ma̱paksi̱nán la̱ tima̱lacnú̱nilh Dios rey David! ¡Cpa̱xcatcatzi̱niyá̱u Dios tú tlahuani̱t! ");
INSERT INTO topNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Chuná amá Jesús tánu̱lh nac Jerusalén. A̱stá̱n alh cpu̱siculan xla Jerusalén. Smalankán ca̱ta̱ampá ixdiscípulos nac Betania. ");
INSERT INTO topNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ixli̱cha̱lí tzisa Jesús táxtulh cBetania ampá cJerusalén y nac tijia tzincstá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Acxilhli ixli̱mákat katum suja ni̱ma̱ ixkalhí lhu̱hua ixpakán; lákalh lacatzú y ni̱ taká̱snilh ixtahuácat porque ni̱ ixquilhta ixuani̱t nama̱stá ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús huánilh amá suja: ―Clacasquín ni̱cxni tí nahuapará mintahuácat. Hua̱k ixdiscípulos takáxmatli la̱ ta̱chihuí̱nalh amá suja. ");
INSERT INTO topNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tácha̱lh Jesús nac lanca pu̱siculan xla Jerusalén, tánu̱lh y tzúculh ca̱tamacxtú tí ixtasta̱nama̱na o ixtatama̱huama̱na ixlacaquilhti̱n ixpu̱lacni pu̱siculan; ca̱ma̱kpu̱spítnilh ixmesajcán tí ixtalakxta̱palí tumi̱n y tí ixtakalhí ixpa̱lokoyu tantzásna̱t, ");
INSERT INTO topNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","y yaj tí má̱xqui̱lh quilhtamacú nata̱tanú ixlí̱sta̱t ixpu̱lacni pu̱siculan xlacata nasta̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chuné ca̱ma̱kalhchihuí̱ni̱lh hua̱k cristianos: ―Nac Escrituras huan: “Nac quínchic tla̱n naquintakalhtahuakaní hua̱k ti̱pa̱katzi cristianos xala cani̱huá pu̱latama̱n”, y huixín tlahuani̱tántit ixpu̱sta̱ncán kalha̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makapitzi ixma̱kalhtahuake̱nacán judíos y xanapuxcun curas takáxmatli tú ixquilhuama, tzúculh talacputzá la̱ tze̱k natamakní porque ixtajicuaní la̱ ixca̱ta̱chihui̱nán cristianos y xlacán ixtaca̱najlá tú ixca̱huaní Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Acxni tzúculh tapaklhtu̱tá ca̱ta̱táxtulh ixdiscípulos amá ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ixli̱cha̱lí tapasá̱rlalh lacatzú ní ixyá amá suja ni̱ma̱ ta̱chihuí̱nalh Jesús y tá̱cxilhli xlacata itsca̱cko̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro áksalh la̱ ixuanini̱t amá suja y huánilh Jesús: ―Quimpu̱chinacán, cá̱cxilhti amá suja ni̱ma̱ ta̱chihuí̱nanti, sca̱cko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Xlá kálhti̱lh: ―Huá xlacata cca̱li̱huaniyá̱n huixín cali̱pa̱huántit Dios. ");
INSERT INTO topNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Xli̱ca̱na cca̱huaniyá̱n, cati̱huá tí ixuánilh jaé sipi: “Catake̱nu juú y capit taju̱ya nac pupunú”, para xli̱ca̱na ixca̱nájlalh ixnacú tú lacpuhuán chú ama qui̱taxtú xli̱ca̱na ixlákcha̱lh tú lacasquín o tú lacpuhuán ama tlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na̱ cca̱huaniyá̱n para tú ixmaksquíntit Dios ixpuhuántit xli̱ca̱na amá̱n ca̱ma̱xqui̱yá̱n chú ixmaklhti̱nántit nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","’Na̱ chuná acxni pa̱t kalhtahuakaniyá̱tit Dios, para cha̱tum cristiano ta̱ra̱makasi̱tzi̱ni̱tántit, pu̱la cama̱tzanke̱nanítit tú ni̱ tla̱n ca̱tlahuanín xlacata Minticucán Dios na̱ naca̱ma̱tzanke̱naniyá̱n hua̱k mintala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Aquit cca̱huaniyá̱n, para huixín ni̱ ca̱ma̱tzanke̱naniyá̱tit tú ni̱ tla̱n ca̱tlahuanín minta̱cristianoscán, Minticucán Dios xalac akapú̱n na̱ ni̱ catica̱ma̱tzanke̱nanín tú tlahuani̱tántit. ");
INSERT INTO topNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tacha̱mpá nac Jerusalén tanu̱pá cpu̱siculan. Aná ixlapu̱lá Jesús acxni tatalacatzúhui̱lh makapitzi xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos y lakko̱lún ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Chuné takalasquínilh Jesús: ―¿Tucu xlacata ca̱li̱lactalahuaya tú lama cpu̱siculan? ¿Ticu ma̱xqui̱ni̱tán tapáksi̱t chú natana tlahuaya? ");
INSERT INTO topNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xlá ca̱kálhti̱lh: ―Aquit na̱ huí tú camá̱n ca̱kalasquiniyá̱n, y para quila̱kalhti̱yá̱u, aquit na̱ nacca̱huaniyá̱n ticu quili̱ma̱paksi̱ni̱t tú nactlahuá. ");
INSERT INTO topNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Quila̱huaníu tuncán: ¿Ticu li̱ma̱páksi̱lh Juan Bautista na̱kmunu̱nán, Dios, o cristianos? ");
INSERT INTO topNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xlacán tzúculh talacchihui̱nán y chuné ixtara̱kalasquiní: ―Para huaniyá̱u Dios ma̱lakácha̱lh, amá̱n quinca̱huaniyá̱n: “Entonces, ¿hua̱nchi ni̱ ca̱najlátit tú ca̱li̱ta̱chihui̱nán?” ");
INSERT INTO topNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y para huaniyá̱u xlacata cristianos tama̱paksí, na̱ chunatiyá qui̱taxtú. Jaé lacchixcuhuí̱n ixtacatzí xlacata lhu̱hua ixtaca̱najlani̱t xli̱ca̱na Dios ixma̱lakacha̱ni̱t Juan Bautista, huá xlacata ixtali̱jicuaní cristianos y ni̱ tacátzi̱lh tú natakalhti̱nán, ");
INSERT INTO topNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","y tahuánilh Jesús: ―Ni̱ ccatzi̱yá̱u ticu li̱ma̱páksi̱lh na̱kmunu̱nán. ―Pues ni̱ para aquit camá̱n ca̱huaniyá̱n tí quili̱ma̱paksi̱ni̱t nactlahuá tú tla̱n ctlahuá ―ca̱kalhti̱ko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","A̱stá̱n Jesús tzúculh ca̱ma̱kalhchihui̱ní amá lacchixcuhuí̱n: ―Maktum quilhtamacú cha̱tum chixcú chalh ixca̱tucuxtu lhu̱hua li̱chánat uvas. Tla̱n maccurra̱lhko̱lh; tláhualh aktum torre xlacata namaktakalhkó ixtachaná̱n; na̱ tláhualh ixpu̱chitni ní nalacchita uvas acxni nachá. Xlá alh latamá mákat pero ca̱má̱xqui̱lh ixca̱tucuxtu makapitzi cha̱lhca̱tnaní̱n xlacata natacuentajní ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Acxni cha̱lh ixquilhta nachitcán uvas, ma̱lakácha̱lh cha̱tum ixtasa̱cua naca̱maksquín amá cha̱lhca̱tnaní̱n tú ixtocarlí tachitni. ");
INSERT INTO topNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero xlacán tachípalh, ta̱kkaxími̱lh y ni̱tú tamá̱xqui̱lh tachitni. ");
INSERT INTO topNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Amá xapu̱chiná ma̱lakacha̱pá a̱cha̱tum ixtasa̱cua, y na̱ chuná taliactaláli̱lh chíhuix, tamá̱xqui̱lh ixakxa̱ka y tahuánilh la̱ta tú talacásquilh. ");
INSERT INTO topNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Todavía ma̱lakacha̱pá a̱cha̱tum ixtasa̱cua y jaé tamákni̱lh. A̱stá̱n ca̱ma̱lakácha̱lh ma̱s ixtasa̱cua y huí tí tamákni̱lh y huí tí huata ta̱kkaxími̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Amá ko̱lú ixkalhí cha̱tum ixkahuasa snu̱n ixlakalhamán, y chuné ixlacpuhuán: “Para cma̱lakachá quinkahuasa natakaxmatní tú naca̱huaní.” Xli̱ca̱na ma̱lakácha̱lh ixkahuasa. ");
INSERT INTO topNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Acxni ca̱lákcha̱lh amá kahuasa xlacán tzúculh tara̱huaní: “Huá namá kahuasa tí ama ta̱tamakxtaka hua̱k herencia acxni naní ixti̱cú. Chí tuncán camakni̱huí xlacata aquín ixpu̱chinaní̱n nahuaná̱u jaé ca̱quihuí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Amá ixkahuasa xapu̱chiná na̱ tachípalh, tamákni̱lh y táalh tamakán ixquilhpá̱n ca̱tucuxtu. ");
INSERT INTO topNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesús ca̱kalasquínilh amá lacchixcuhuí̱n: ―¿Tucu puhuaná̱tit huixín natlahuá ixpu̱chiná jaé ca̱tucuxtu? Capuhuántit xlacata jaé patrón ama min, ama ca̱makní tí ca̱má̱xqui̱lh ixca̱tucuxtu y tunu tí ama ca̱ma̱xquí ixpu̱chaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Huixín ni̱ li̱kalhtahuakani̱tántit tú huan Escrituras? Lacatum chuné tatzokni̱t: Amá lanca chíhuix ni̱ma̱ talakmákalh ixtlahuaní̱n chiqui ixtapuhuán ni̱tú li̱macuán, a̱stá̱n milh tamakxtaka ma̱s tali̱pa̱u pues ya̱huaca nac ixcha̱stú̱n la̱ xacha̱ya y aná ixli̱tzinca̱snanko̱ni̱t chiqui. ");
INSERT INTO topNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tú acxilá̱u hua̱k Dios lacsacxtuni̱t y pa̱xahuayá̱u la̱ tlahuani̱t, ma̱squi ni̱ ma̱kachakxi̱yá̱u lanca ixtalacapa̱stacni y hua̱nchi chú tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","La̱ chihui̱nanko̱lh Jesús xlacán tasí̱tzi̱lh porque tama̱kachákxi̱lh huá ixca̱li̱chihui̱nani̱t y talacpuhua la̱ tla̱n natalí̱n cpu̱la̱chi̱n. Pero lhu̱hua ixtaya̱na tí ixtali̱pa̱huán ixtachihuí̱n Jesús y tajicuánilh para natamaklhti̱nán. Huá xlacata mejor ta̱kxtakyá̱hualh y táalh. ");
INSERT INTO topNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ixli̱puntzú ixenemigos Jesús tama̱lakácha̱lh makapitzi fariseos y tí ixtata̱ya̱na rey Herodes caj natakalhputzá para ni̱ tla̱n naca̱li̱chihui̱nán ma̱paksi̱naní̱n y tla̱n natalí̱n nac pu̱la̱chi̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Acxni talákchilh takalasquínilh: ―Maestro, ccatzi̱yá̱u xlacata tú huix li̱chihui̱nana xli̱ca̱na ma̱squi lhu̱hua ni̱ taca̱najlá mintachihuí̱n, pero huix ni̱ putzaya tú ixlakxtucán cristianos y huata lacasquina tla̱n catalatáma̱lh xlacata natalakapasa y natalakchá̱n Dios. Quila̱huaníu para tla̱n la̱ clakaxokoniyá̱u impuestos xapuxcu ma̱paksi̱na romano. ¿Mini̱ní naclakaxoko̱naná̱u, o ni̱ tla̱n la̱ clakaxoko̱nama̱náu? ");
INSERT INTO topNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús acxcátzi̱lh xlacata caj ixtakalhputzama̱na y chuné ca̱huánilh: ―¿Hua̱nchi quila̱li̱kalhputzayá̱u ta̱kskahuí̱n? Quila̱li̱miníu mactum tumi̱n xlacata nacacxila. ");
INSERT INTO topNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Li̱minica mactum tumi̱n. Acxni ácxilhli ca̱kalasquínilh: ―¿Ticu ixretrato talakatzokni, y ticu ixtacuhui̱ní kalhí jaé tumi̱n? Xlacán takalhtí̱nalh: ―Ixretrato ixtacuhui̱ní lanca xapuxcu ma̱paksi̱na romano. ");
INSERT INTO topNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","―Pues cama̱xquí̱tit ma̱paksi̱na romano tú xlá mini̱ní y cama̱xquí̱tit Dios tú xlá lacasquín milacatacán ―huanko̱lh Jesús. A̱stá̱n xlacán yaj tacátzi̱lh tú natahuaní. ");
INSERT INTO topNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Talakchimpá ixli̱puntzú makapitzi saduceos; jaé cristianos tapuhuán xlacata ixespíritu cha̱tum cristiano yaj lacastacuanán acxni ní. Huá tali̱kalasquínilh Jesús: ");
INSERT INTO topNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, Moisés quinca̱li̱ma̱paksí̱n para cha̱tum chixcú ní y makxtaka ixta̱cha̱t y ni̱ takalhí ixcamancán, xa̱cha̱tum ixta̱cam tla̱n ta̱tamakaxtoka ixya̱stá y takalhí ixcamancán xlacata ni̱ nalaksputa ixta̱cam ni̱ma̱ ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pues maktum ixtalama̱na cha̱tujún lacchixcuhuí̱n. Xla̱huán tamakáxtokli y ni̱ ixli̱maka̱s quilhtamacú ni̱lh y ni̱ takálhi̱lh ixcamancán. ");
INSERT INTO topNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ixli̱cha̱tuy ixta̱cam ta̱tamakáxtokli ixya̱stá; ni̱ para maka̱s na̱ ni̱lh y ni̱ takálhi̱lh camán. Ixli̱cha̱tutu na̱ ta̱tamakáxtokli ixya̱stá y na̱ chuná akspúlalh. ");
INSERT INTO topNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Xa̱makapitzi lacchixcuhuí̱n hua̱k tata̱tamakáxtokli amá pusca̱t y ni̱ cha̱tum tí takálhi̱lh camán, y cha̱lh quilhtamacú amá pusca̱t na̱ ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Entonces acxni ixespiritucán nalacastacuanán ca̱li̱ní̱n, ¿ticu yá chixcú ixta̱cha̱t ama huan pues hua̱k ta̱tamakáxtokli ixcha̱tujuncán? ");
INSERT INTO topNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús ca̱huánilh: ―Huixín aktzanka̱ni̱tántit porque ni̱ ma̱kachakxi̱ni̱tántit ixtachihuí̱n Dios nac Escrituras, ni̱ para lakapasá̱tit ixli̱tlihueke la̱ ca̱ma̱lacastacuaní ni̱n y ni̱ catzi̱yá̱tit la̱ ca̱li̱kalhí ixespiritucán nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Huixín ni̱ catzi̱yá̱tit xlacata acxni natalacastacuanán ca̱li̱ní̱n yaj tí ama tamakaxtoka, ni̱ para ama takalhí ixlactzumajancán tí natama̱makaxtoka porque la̱ ángeles ta̱má̱n tahuán ni̱ma̱ tahuila̱na nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Huixín na̱ aktzanka̱ni̱tántit para puhuaná̱tit ni̱cxni talacastacuanán ni̱n porque ni̱ tla̱n ma̱kachakxi̱yá̱tit tú huan ixlibro Moisés. Xlá tzokli la̱ maktum Dios ta̱chihuí̱nalh nac akatum actzu quihui la̱ta lhcuta̱yama y chuné huánilh Dios: “Aquit Dios tí tali̱pa̱huani̱t y tali̱pa̱huancú Abraham, Isaac y Jacob.” ");
INSERT INTO topNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Huá cca̱li̱huaniyá̱n huixín aktzanka̱ni̱tántit para puhuaná̱tit xlacata tí talatáma̱lh y táni̱lh yaj takalhí Dios tí natali̱pa̱huán, porque la̱ta chí Dios lama xastacnán cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cha̱tum chixcú tí ixma̱sí ixley Moisés kaxmatko̱lh la̱ ca̱ta̱chihuí̱nalh Jesús amá lacchixcuhuí̱n y ma̱kachákxi̱lh xlacata xli̱ca̱na tú ixca̱huanini̱t. Xlá na̱ talacatzúhui̱lh y chuné kalasquínilh: ―¿Neje yá tapáksi̱t pu̱la quili̱tlahuatcán y ma̱s quinca̱macuaniyá̱n nac quilatama̱tcán? ");
INSERT INTO topNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kálhti̱lh: ―Xla̱huán tapáksi̱t ni̱ma̱ pu̱la quili̱tlahuatcán chuné huan: “Cakaxpáttit cha̱tunu huixín xalac Israel, huata huí cha̱tum lanca Dios ca̱quilhtamacú, y huata huá Quimpu̱chinacan natlahuayá̱u. ");
INSERT INTO topNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huá cali̱pá̱huanti Mimpu̱chiná ixli̱hua̱k minacú, ixli̱hua̱k mili̱stacni, ixli̱hua̱k mintapuhuá̱n, ixli̱hua̱k mili̱tlihueke.” Huá jaé xla̱huán tapáksi̱t lakatí Dios natatlahuá ixcamán. ");
INSERT INTO topNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ixliaktuy ixtapáksi̱t na̱ acxtumatiyá qui̱taxtú y chuné li̱chihui̱nán: “Caca̱lakalhámanti hua̱k minta̱cristianos na̱ chuná la̱ huix lacasquina calakalhamanca.” Huá jaé lanca tapáksi̱t y ma̱s macuán nac quilatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Amá chixcú huánilh Jesús: ―Maestro, clakatí la̱ chihuí̱nanti. Xli̱ca̱na la̱ huana huata huí cha̱tum Dios ca̱quilhtamacú y ni̱ huí tunu ma̱s tali̱pa̱u. ");
INSERT INTO topNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Xlá ni̱ lakatí cahuili̱nica lhu̱hua li̱lakachixcuhuí̱n cpu̱siculan, o caca̱makni̱ca quitzistancaní̱n caj li̱lakachixcuhui̱cán, xlá ma̱s lakatí cali̱pa̱huanca ixli̱hua̱k quintapuhua̱ncán, ixli̱hua̱k quinacujcán, ixli̱hua̱k quili̱stacnicán, ixli̱hua̱k quili̱pa̱xqui̱ncán, y cha̱tum cristiano caca̱lakalhámalh xa̱makapitzi na̱ chuná la̱ ixacstu lakalhamancán. ");
INSERT INTO topNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Acxni káxmatli Jesús la̱ chihuí̱nalh amá chixcú chuné huánilh: ―Huix xli̱ca̱na catzi̱ya tú lakatí Dios natlahuayá̱u, y aquit cpuhuán huix tla̱n ma̱kachakxi̱pa̱ttá la̱ Dios ma̱paksi̱namputún nac mili̱stacni. A̱stá̱n yaj tí kálhi̱lh li̱camama tú nakalasquini Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús ixlapu̱lajcú nac pu̱siculan y tzucupá ca̱ma̱kalhchihui̱ní cristianos y chuné ca̱huánilh: ―¿Como chí ixma̱kalhtahuake̱nacán judíos tahuán xlacata Cristo tí ama ca̱lakma̱xtuyá̱n ixli̱talakapasni xamaká̱n rey David ama huan? ");
INSERT INTO topNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Y maktum acxni rey David ma̱lacpuhuá̱ni̱lh Espíritu Santo chuné huá: Quinti̱cucán Dios huánilh Quimpu̱chiná tí ama quilakma̱xtú: “Catahuila nac quimpa̱xtú̱n quinta̱ma̱paksí̱nanti hasta xní nacca̱makatlajá hua̱k mienemigos xlacata acxtum natalakachixcuhui̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Huá cca̱li̱huaniyá̱n, ¿nicu li̱puhuaná̱tit xlacata Cristo ixli̱talakapasni rey David nahuán si pi̱huá rey David li̱macá̱n Ixpu̱chiná tí ama lakma̱xtú? Lhu̱hua cristianos ixtalakatí takaxmata la̱ ixca̱kalhtí Jesús acxni tú ixkalasquinicán. ");
INSERT INTO topNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ca̱ta̱chihui̱nanko̱lh hua̱k cristianos y chuné ca̱huánilh: ―Hua̱k skalalh caca̱tahuilanítit tí tama̱sí ixley Moisés. Xlacán talakatí mactlá̱n talhaka̱nán xlacata cani̱huá naca̱huanicán kalhé̱n la̱ lactali̱pa̱u lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Xlacán taputzá lactali̱pa̱u pu̱táhui̱lh nac sinagogas, nac fiestas talacasquín pu̱la tla̱n caca̱ma̱hui̱ca. ");
INSERT INTO topNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Viudas ta̱kskahuimaklhtí ixchiccán y xlacata ni̱tí tú naca̱huaní li̱catzi lhu̱hua tú takalhtahuakaní Dios, pero ni̱ para talacpuhuán xlacata xlacán ma̱s lhu̱hua castigo ama̱ca ca̱ma̱xqui̱cán. ");
INSERT INTO topNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Maktum Jesús ixuí lacatzú ní tahuila̱na cajas xla limosna, ixca̱cxilhma la̱ cristianos ixtamuju̱ma̱na ixlimosnajcán, y makapitzi ricos ixtamujú lhu̱hua tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ixli̱puntzú talacatzúhui̱lh cha̱tum viuda snu̱n pobre y múju̱lh nac caja aktuy tumi̱n xla cobre ni̱ lhu̱hua ixtapalh ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús ca̱tasániko̱lh ixdiscípulos y chuné ca̱huánilh: ―Aquit tancs cca̱huaniyá̱n, jaé puhuani̱ná múju̱lh ma̱s lhu̱hua tumi̱n ixlacati̱n Dios que hua̱k namá ricos tí tamúju̱lh lhu̱hua tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porque ricos tamúju̱lh ixlimosnajcán tumi̱n ni̱ma̱ ca̱kalhta̱xtuní, pero xlá múju̱lh ixtumi̱n ni̱ma̱ a̱huata ixkalhí ixama li̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús ixtaxtumajá amá lanca pu̱siculan xla Jerusalén acxni cha̱tum ixdiscípulos huánilh: ―Maestro, cá̱cxilhti la̱ tahuila̱na laclá̱n chíhuix ni̱ma̱ ca̱li̱tlahuacani̱t jaé lanca pu̱siculan. ");
INSERT INTO topNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Xlá kálhti̱lh: ―Huix ca̱cxila la̱ ixli̱laclá̱n ca̱ca̱xya̱huacani̱t namá pu̱siculan pero ni̱ catzi̱ya xlacata ni̱ xli̱maka̱s quilhtamacú ni̱ ama tamakxtaka ni̱ para akstum chíhuix nac ixpu̱ta̱y hua̱k pá̱tzaps, ¡hua̱k ama ca̱lactlahuako̱cán! ");
INSERT INTO topNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús ca̱ta̱ampá ixdiscípulos nac Monte de los Olivos; jaé sipi ixli̱lacacha̱ncán lanca pu̱siculan nac Jerusalén. Acxni tácha̱lh Jesús curucs tahui, entonces Pedro, Jacobo y Juan tze̱k takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Clacasquiná̱u quila̱huaníu niculá ama laclakó pu̱siculan. ¿Tucu xla̱huán ama tasí xlacata naccatzi̱yá̱u ama kantaxtú tú li̱chihuí̱nanti? ");
INSERT INTO topNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús tzúculh ca̱ma̱kalhchihui̱ní: ―Skálalh pa̱t tahuilayá̱tit ni̱tí tica̱kskahuiyá̱n, ");
INSERT INTO topNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","porque lhu̱hua tamá̱n tamín y natahuán: “Aquit Cristo tí cama ca̱lakma̱xtú cristianos”, y lhu̱hua tamá̱n tamakacanajlá ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na̱ pa̱t kaxpatá̱tit la̱ ama̱ca tzucucán li̱chihui̱nancán guerras, o la̱ tla̱n natara̱makní cristianos. Huixín ni̱ cajicuántit pues tamaclacasquiní pu̱la chú naqui̱taxtú, y jaé cajcú ixquilhtzúcut tú ama lá a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aktum lanca pu̱latama̱n ama ta̱ra̱nica tunu pu̱latami̱n, y aktum ca̱chiquí̱n ama putzá la̱ tla̱n nata̱ra̱nica xa̱ktum ca̱chiquí̱n. Tíyat ama tatlaná cani̱huá ca̱quilhtamacú. Ama min tatzínsnit cani̱hua ca̱chiquí̱n. Lhu̱hua cristianos tamá̱n tara̱lacata̱quí xlacata tara̱nicputún. La̱ta jaé tú xla̱huán pa̱t acxilá̱tit cajcú ixquilhtzúcut la̱ ama min ta̱kxtakajni a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Huixín mi̱cstucán natamaktakalhá̱tit porque pa̱t ca̱macama̱sta̱caná̱tit ixpu̱ma̱paksi̱ncán xanapuxcun; pa̱t ca̱ma̱kxtakajni̱caná̱tit nac itsinagogajcán judíos; naca̱li̱pincaná̱tit ixlacati̱ncán reyes caj quilacata y chuná huixín tla̱n naquila̱li̱chihui̱naná̱u para xli̱ca̱na quila̱li̱pa̱huaná̱u. ");
INSERT INTO topNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Antes nakantaxtukó jaé tú cca̱huanimá̱n ama̱ca li̱chihui̱nanko̱cán hua̱k ca̱lacchiquí̱n xala ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y acxni naca̱ma̱kalhapali̱caná̱tit ixlacati̱ncán ma̱paksi̱naní̱n ni̱tú cali̱pu̱huántit tú pa̱t huaná̱tit porque Espíritu Santo ama kalhti̱nán milacatacán y ni̱ huixín pa̱t chihui̱naná̱tit amá quilhtamacú, porque Dios hua̱k amá̱n ca̱ma̱cxcatzi̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Amá quilhtamacú lhu̱hua tamá̱n taliakskahuinán ixnata̱camán xlacata naca̱makni̱cán, xanati̱cún na̱ ta̱má̱n taliakskahuinán ixcamancán, y xlacán na̱ ta̱má̱n tata̱ra̱lacata̱quí ixti̱cucán, y para tla̱n, ama tara̱makní. ");
INSERT INTO topNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lhu̱hua amá̱n ca̱si̱tzi̱niyá̱n huixín caj xlacata ca̱najlayá̱tit quintachihuí̱n. Pero tí nata̱yaní hasta xní nati̱taxtukó jaé ni̱ lactlá̱n quilhtamacú namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Acxni na̱cxilá̱tit kantaxtuma tú tzokli profeta Daniel, la̱ ama tali̱chiyá ixpu̱lakachixcuhui̱cán Dios amá lacli̱xcájnit lacchixcuhuí̱n ni̱ma̱ ta̱má̱n tamín xala mákat y ama taya̱huá tú talakachixcuhui̱putún xlacán ―tí tla̱n li̱kalhtahuaká jaé tachihuí̱n cama̱kachákxi̱lh tú li̱chihuí̱nalh Jesús―, entonces tí talama̱na nahuán nac Judea catatzá̱lalh tuncán ca̱quihuí̱n y ca̱lacsipijni. ");
INSERT INTO topNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tí ta̱cxtuni̱t nahuán ixakstí̱n ixákxtaka acxni nata̱ctá xlacata natza̱lá mejor ni̱ catánu̱lh nama̱xtú tú kalhí nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tí ani̱t nahuán ixca̱tucuxtu, mejor ni̱ camilh tiyá ixlháka̱t ni̱ma̱ akxtakuili̱ni̱t nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Koxitaní̱n lacchaján tí takalhí nahuán ixcamancán y ya̱ talakahuán, o tatziquijcú! ");
INSERT INTO topNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Camaksquíntit Dios ni̱ tica̱pu̱tlakacaná̱tit ixquilhta lonkni amá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lhu̱hua ta̱kxtakajni ama lá amá quilhtamacú la̱ ni̱cxni ta̱cxilhni̱t cristianos la̱ta titláhualh Dios ca̱quilhtamacú y yaj ama lapará tunu ta̱kxtakajni a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y para Dios ni̱ ixma̱ctzúhui̱lh jaé quilhtamacú ta̱kxtakajni ni̱ ixtataxtúnilh cristianos tí xlá ca̱lakalhamán, pero xlá catzí tú tlahuá porque ca̱lakalhamán cristianos tí ca̱lacsacni̱t. ");
INSERT INTO topNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Para tí ca̱huaniyá̱n amá quilhtamacú: “Namá, ca̱cxílhtit nachú yá Cristo”, o tunu tí nahuán: “Uchú yá Cristo”, huixín ni̱ caca̱najlátit. ");
INSERT INTO topNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Lhu̱hua ta̱má̱n tahuán xlacata xlacán Cristo y Dios ca̱ma̱lakacha̱ni̱t porque huá tali̱chihui̱nán; na̱ ama tatlahuá laclanca tascújut o tama̱ksa̱ní ta̱tatlaní̱n; y para tla̱n, ama tamakaca̱najlá ixtachihui̱ncán hasta tí ca̱lacsacni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huá xlacata cca̱li̱huaniyá̱n huixín, skálalh catahuilanítit porque aquit hua̱k cca̱ma̱cxcatzi̱ni̱ni̱tán tú ama qui̱taxtú a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Na̱ cca̱huaniyá̱n: Acxni nalakó jaé ta̱kxtakajni ni̱ma̱ cca̱li̱ta̱chihui̱namá̱n, chichiní yaj ama ma̱xkake̱nán y papá yaj ama lacahuán ca̱tzisní. ");
INSERT INTO topNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hua̱k stacu xala akapú̱n ama tapa̱tastá, na̱ chuná ama ta̱kahuani̱kó la̱ta tú huí ixli̱ti̱lanca akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Hua̱k cristianos ama quinta̱cxila la̱ aquit Xatalacsacni Chixcú cama ta̱ctá nac akapú̱n la̱ cha̱tum lanca chixcú, y hua̱k ama quintalakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Entonces aquit cama ca̱li̱ma̱paksí ángeles catama̱mákstokli hua̱k ixcamán Dios tí quintali̱pa̱huani̱t la̱ta hua̱k ixli̱ti̱lanca ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Tla̱n ca̱cxílhtit tú pa̱xtoka katum suja: Huixín catzi̱ya̱tit talacatzuhui̱ma ixquilhta lhca̱cná acxni acxilá̱tit tzucú akasnapankán y tataxtuní ixpakán. ");
INSERT INTO topNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na̱ chuná acxni na̱cxilá̱tit tzucú kantaxtú tú cca̱li̱ta̱chihui̱namá̱n cacatzí̱tit talacatzuhui̱ma spútut y talacatzuhui̱ma quilhtamacú xlacata nacmimpará ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Xli̱ca̱na cca̱huaniyá̱n, jaé tú cca̱li̱ta̱chihui̱nán hua̱k ama kantaxtú ya̱ para tani̱kó nahuán cristianos xala jaé quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na̱ cca̱huaniyá̱n: Ca̱quilhtamacú y akapú̱n ama talaktzanká, pero quintachihuí̱n ni̱ ama talaktzanká hasta xní nakantaxtukó tú cca̱li̱ta̱chihui̱namá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pero ni̱tí catzí tú yá hora o tú yá chichiní lihua ama lakchá̱n, ni̱ para aquit Ixkahuasa Dios, ni para ángeles tacatzí huata Quinti̱cucán Dios catzí. ");
INSERT INTO topNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Huá cca̱li̱huaniyá̱n, skálalh catahuilátit, tla̱n calacahua̱nántit y ni̱ cali̱makxtáktit kalhtahuakaniyá̱tit Dios, porque ni̱ catzi̱yá̱tit tú yá chichiní ama ca̱lakchiná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na̱ chuná ama qui̱taxtú la̱ acxni cha̱tum chixcú an latapu̱lí mákat. Nac ixchic ca̱makxtaka makapitzi ixtasa̱cua cha̱tunu ca̱ma̱xquí ixtascujutcán, y cha̱tum makxtaka nac puhui̱lhta xlacata skálalh natahuilá nama̱lacqui̱ní acxni nachín ixpatrón. ");
INSERT INTO topNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Na̱ chuná huixín skálalh catahuilátit porque ni̱ catzi̱yá̱tit lihua xnicu cama chin aquit Mimpu̱chinacán, para nacmín ca̱tzisní, tzi̱sa, spalh ca̱huama, o acxni xkakani̱ttá. ");
INSERT INTO topNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","¿Qué tal xacca̱lakchín ca̱tzisní xacca̱ma̱noklhún lhtatapa̱nántit? ");
INSERT INTO topNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jaé tú cca̱huanín huixín na̱ chuná naca̱ma̱catzi̱ni̱yá̱tit hua̱k cristianos tí amajcú quintali̱pa̱huán xlacata skálalh catatahui cani̱cxnihuá quilhtamacú takalhi̱ma̱na Ixpu̱chinacán. ");
INSERT INTO topNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Istzanká aktuy chichiní nalakchá̱n ixtacuhui̱ní pa̱scua acxni israelitas ixtahuá simi̱ta la̱ta ni̱ kalhí levadura; ixca̱makni̱cán borregos. Entonces xanapuxcun curas ixma̱kalhtahuake̱nacán judíos tzúculh talacchihui̱nán la̱ nataliakskahuinán Jesús xlacata natalí̱n cpu̱ma̱paksí̱n y tla̱n natamakní. ");
INSERT INTO topNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero xlacán ixtalacpuhuán: ―Ni̱ lá chipayá̱u acxni lama nahuán tacuhui̱ní xla pa̱scua porque tla̱n tasi̱tzí y tamaklhti̱nán cristianos tí tali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús alh lakpaxia̱lhnán Simón amá tí tima̱ksá̱ni̱lh acxni ixkalhí lepra; xlá ixlama nac Betania. Jesús ixua̱yama acxni chilh cha̱tum pusca̱t ixli̱mín aktum frasco perfume xla nardo xánat, snu̱n ixtapalh ixuani̱t amá quilhtamacú. Ma̱kálhke̱lh y tzúculh acuilí Jesús amá perfume. ");
INSERT INTO topNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Makapitzi tí ixtahuila̱na lacatzú tasi̱tzí̱nilh amá pusca̱t y tzúculh tahuán: ―¿Hua̱nchi pa̱xcat tlahuaca jaé perfume? ");
INSERT INTO topNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma̱s tla̱n ixtili̱sta̱ca li̱huacá aktutu ciento denario tumi̱n, y xatumi̱n tla̱n ixtica̱li̱makta̱yaca pobres. ");
INSERT INTO topNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús ca̱káxmatli y chuné ca̱huánilh: ―¿Hua̱nchi ta̱ra̱slaká̱tit jaé pusca̱t? Ni̱tú cahuanítit porque tú tlahuani̱t snu̱n tla̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pobres siempre ca̱ta̱lapa̱nántit nahuán y tla̱n ca̱makta̱yayá̱tit xni̱ta lacasquiná̱tit, pero aquit yaj maka̱s quilhtamacú camá̱n ca̱ta̱latama̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Xlá tláhualh tú lacpúhualh naquimacuaní y naclakatí; xa̱huá a̱li̱quimacuíli̱lh perfume y acxni naquimuju̱cán ma̱squi yaj tú quimacuili̱ca. ");
INSERT INTO topNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na̱ cca̱huaniyá̱n, cani̱huá ca̱lacchiquí̱n ní nali̱chihui̱nancán ixtachihuí̱n Dios na̱ ama̱ca li̱chihui̱nancán tú tláhualh jaé pusca̱t xlacata hua̱k nalacapa̱staccán. ");
INSERT INTO topNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote cha̱tum ixdiscípulo tí na̱ ixli̱lhca̱ni̱t nata̱scuja Jesús acxni ca̱lácsacli ixcha̱cu̱tuycán, alh ca̱ta̱chihui̱nán ixenemigos xanapuxcun curas xlacata naca̱ta̱lacca̱xlá la̱ tla̱n naca̱macama̱xquí Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Acxni takáxmatli tú ixca̱ma̱lacnu̱nicán xlacán tapa̱xahuako̱lh y tama̱lacnú̱nilh natama̱xquí tumi̱n. Entonces Judas tzúculh lacputzá la̱ namacama̱stá Jesús ixmacancán ixenemigos. ");
INSERT INTO topNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xla̱huán chichiní ixtacuhui̱ní xla pa̱scua acxni judíos ixtali̱hualhtatá simi̱ta ni̱ kalhí levadura ixmakni̱cán tantum borrego, huá jaé tahuá ixtali̱lakachixcuhui̱nán pa̱xcua. Ixdiscípulos takalasquínilh: ―¿Nicu lacasquina nacaná̱u ca̱xtlahuayá̱u tahuá tú nali̱hualhtatayá̱u jaé ca̱tzisní pa̱xcua? ");
INSERT INTO topNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Xlá ca̱huánilh cha̱tuy ixdiscípulos: ―Capítit ca̱chiquí̱n; aná pa̱t acxilá̱tit cha̱tum chixcú cucalí̱n aktum xa̱lu chúchut. ");
INSERT INTO topNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Catakokétit; ana ní natanú nata̱chihui̱naná̱tit ixpu̱china chiqui y chuné nahuaniyá̱tit: “Huan quimaestrojcán: ¿Nicu huí chiqui ní ama ca̱ta̱hualhtatá ixdiscípulos jaé ca̱tzisní?” ");
INSERT INTO topNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Xlá amá̱n ca̱ma̱si̱niyá̱n aktum lanca cuarto ixakstí̱n ixchic hua̱katá xaca̱xlán yá. Huixín aná naca̱xtlahuayá̱tit tahuá tú nali̱hualhtatayá̱u jaé pa̱scua. ");
INSERT INTO topNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ixdiscípulos táalh ca̱chiquí̱n y xli̱ca̱na chú tatáka̱sli la̱ ixca̱huanini̱t Jesús ama qui̱taxtú, y xlacán taca̱xtlahuako̱lh tahuá tú natali̱lakachixcuhui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ca̱tzisní Jesús ca̱tá̱alh xa̱makapitzi ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Hua̱k tatahuilako̱lh tahua̱yán. Acxni lihua ixtahua̱yama̱na Jesús ca̱huánilh: ―Xli̱ca̱na cca̱huaniyá̱n, cha̱tum la̱ta mili̱hua̱kcán tí quila̱ta̱hua̱yama̱náu ama quimacama̱stá ixmacancán quienemigos. ");
INSERT INTO topNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xlacán talakaputzako̱lh y tzúculh tara̱kalasquiní cha̱tum chá̱tum: ―¿Cha̱ aquit cama macama̱stá? Y xa̱cha̱tum na̱ ixpuhuán: ―¿Ma̱x aquit cama liakskahuinán? ");
INSERT INTO topNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pero xlá ca̱huanipá: ―Huata cha̱tum la̱ta mili̱cha̱cu̱tuycán, y huá tí lakxtum quinta̱hua̱yama nac pula̱tu. ");
INSERT INTO topNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chuná kantaxtuma tú huan Escrituras cama pa̱xtoka aquit Xatalacsacni Chixcú. ¡Pero koxitá namá chixcú tí ama quimacama̱stá! Ma̱s tla̱n ixtihua ni̱cxni ixtilakahua. ");
INSERT INTO topNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","La̱ta ixtahua̱yama̱najcú Jesús tíyalh mactum simi̱ta; pa̱xcatcatzí̱nilh Dios ixtahuá; a̱stá̱n lakchékelh, ca̱má̱xqui̱lh ixdiscípulos y chuné ca̱huánilh: ―Cahuátit jaé simi̱ta porque qui̱taxtú la̱ camaklhti̱nántit quimacni. ");
INSERT INTO topNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","24","A̱stá̱n tiyapá aktum vaso ixchúchut uva; pa̱xcatcatzínilh Dios, ca̱má̱xqui̱lh ixdiscípulos y ca̱huánilh: ―Cahuátit actzú jaé ixchúchut uva porque huá namá quinkalhni ni̱ma̱ Dios ama ca̱li̱ma̱lacnu̱ní cristianos aktum sa̱sti ixtalacca̱xlán la̱ naca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Xli̱ca̱na cca̱huaniyá̱n, ya̱cxni cama huá ixchúchut uva la̱ jaé, acxni nacchá̱n ní huí Dios cama huá tunu xasa̱sti ni̱ma̱ ni̱cxni lakó. ");
INSERT INTO topNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","La̱ tahua̱yanko̱lh tatlí̱nilh Dios aktum alabanza, a̱stá̱n taampá nac Monte de los Olivos. ");
INSERT INTO topNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Acxni tácha̱lh Jesús ca̱ta̱chihuí̱nalh ixdiscípulos: ―Hua̱k huixín pa̱t lakaputzayá̱tit jaé ca̱tzisní caj quilacata porque nac Escrituras tatzokni̱t la̱ ma̱lacpuhuá̱ni̱lh Dios cha̱tum profeta: “Cama makxtaka namakni̱cán tí ixca̱maktakalha borregos y xlacán ta̱má̱n tata̱kahuani̱kó cani̱huá.” ");
INSERT INTO topNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero acxni naclacastacuanampará ca̱li̱ní̱n pu̱la cama cha̱n nac Galilea xlacata aná natanokhla̱chá̱u. ");
INSERT INTO topNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro huánilh Jesús: ―Quimpu̱chinacán, ma̱squi hua̱k catalakaputzako̱lh aquit ni̱ camá̱n akxtakamakaná̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús kálhti̱lh: ―Aquit cuaniyá̱n, Pedro, xlacata pi̱huá jaé ca̱tzisní acxni ya̱ xkakaj nahuán y natlí maktuy tantum pu̱yu huix pa̱t huana maktutu xlacata ni̱ quilakapasa la̱ta tí nakalasquiniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero xlá maklhu̱hua huanipá Jesús: ―Ma̱squi caquimakni̱ca caj milacata ni̱cxni cama huan xlacata ni̱ clakapasá̱n. Xa̱makapitzi ixdiscípulos Jesús na̱ chuná tahuánilh. ");
INSERT INTO topNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","A̱stá̱n ca̱tá̱alh ixdiscípulos lacatum huanicán Getsemaní. Acxni tácha̱lh Jesús ca̱huánilh ixdiscípulos: ―Juú catamakxtáktit, aquit cama kalhtahuakaní Dios. ");
INSERT INTO topNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedro, Jacobo y Juan ca̱tá̱alh tziná ma̱s lakamákat. Xlá tzúculh akatuyún ixnacú ixakxtakajnán la̱ta ixli̱puhuán tú ixlakcha̱ma. ");
INSERT INTO topNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chuné ca̱huánilh: ―Snu̱n clakaputzá cquinacú, la̱mpara cacxcatzí camajá ní. Juú catamakxtáktit huixín y ni̱ calhtatátit. ");
INSERT INTO topNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Xlá alh ma̱s lakamákat; aná tatzokóstalh ca̱tiyatni y huánilh Dios para tla̱n ni̱ camá̱xqui̱lh ta̱kxtakajni ni̱ma̱ ixlakcha̱ma. ");
INSERT INTO topNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chuné kalhtahuakánilh: ―Ta̱ta, huix hua̱k tla̱n tlahuaya; para lacasquina ni̱ quima̱xqui jaé ta̱kxtakajni ni̱ma̱ cama lakchá̱n. Pero ni̱ ctlahuaputún tú aquit clacasquín, huix catlahua tú lacpuhuana ma̱s quimacuaní. ");
INSERT INTO topNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A̱stá̱n táspitli ní ixtahuila̱na ixdiscípulos. Ca̱lákcha̱lh talhtatama̱na. Entonces huánilh Pedro: ―Simón, ¿ni̱ lá ta̱la ni̱ lhtataya ca̱na aktum hora huatiyá? ");
INSERT INTO topNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Calacastacuanántit y cakalhtahuakanítit Dios xlacata ni̱ natatlaji̱yá̱tit y naca̱makatlajayá̱n tlajaná. Porque ma̱squi miespíritucán ti̱tum ya̱huani̱t ixtalacapa̱stacni mimacnicán ni̱ ta̱yaní y ni̱ tuhua makatlajacán. ");
INSERT INTO topNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús ampá kalhtahuakaní Dios y chú huanipá la̱ xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Qui̱taspitpá, ixdiscípulos ixtalhtatama̱nampá porque yaj lá ixtata̱lá ixlakastapucán. Xlacán ni̱ ixtacatzí tú natakalhtí acxni ixca̱ta̱chihui̱nán Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xlá ampá kalhtahuakaní Dios ixli̱maktutu y acxni qui̱táspitli ca̱huánilh: ―Chí calhtatátit y cajáxtit para lacasquiná̱tit porque accha̱ni̱t quilhtamacú naquimacama̱sta̱cán aquit Xatalacsacni Chixcú ixmacancán quienemigos. ");
INSERT INTO topNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡To̱! Mejor ni̱ calhtatátit, cata̱yátit tuncán porque nachú mimajá tí ama quimacama̱stá. ");
INSERT INTO topNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ixchihuinamajcú acxni talákchilh lhu̱hua cristianos, ixca̱cpuxcuni̱t ixdiscípulo Judas Iscariote. Makapitzi ixtali̱mín espadas, quihui y xatu̱tá. Jaé ixtama̱lakacha̱ni̱t xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos y lakko̱rojtzi̱n mapaksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas tí sta̱lh Jesús ca̱huánilh la̱ natali̱lakapasa xlacata natalí̱n cpu̱la̱chi̱n: ―Tí aquit naclacaspu̱ta cachipátit, cali̱pítit y tla̱n camaktakálhtit. ");
INSERT INTO topNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Acxni chilh ní ixyá Jesús huánilh: ―Maestro, clakmimá̱n. Y Judas lacáspu̱tli la̱ calakalhámalh. ");
INSERT INTO topNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Makapitzi tachípalh Jesús xlacata natalí̱n la̱ cha̱tum tachí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Entonces cha̱tum ixdiscípulo má̱xtulh ixespada y ca̱ctí̱nilh ixtaké̱n ixtasa̱cuacán tí ixtama̱lakacha̱ni̱t curas. ");
INSERT INTO topNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús ca̱huánilh amá lacchixcuhuí̱n: ―Huixín tani̱tántit quila̱chipayá̱u la̱ cha̱tum kalha̱ná li̱taná̱tit quihui y espadas. ");
INSERT INTO topNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cha̱li cha̱lí ixquila̱cxilá̱u acxni xacca̱ma̱kalhchihui̱ni̱yá̱n nac pu̱siculan y ni̱ quila̱chipáu, pero chuná tamaclacasquiní nakantaxtú tú tahuán Escrituras cama pa̱xtoka. ");
INSERT INTO topNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","A̱stá̱n hua̱k ixdiscípulos ta̱kxtakmákalh y tatza̱lako̱lh cani̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero cha̱tum ixdiscípulos Jesús takókelh la̱ta ní ixlacli̱ma̱ca nac pu̱ma̱paksí̱n. Amá kahuasa acxni acxilhca ixama̱ca chipacán, ");
INSERT INTO topNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero tzúculh tza̱lanán y huata ixlháka̱t maklhti̱ca y xlá tzá̱lalh la̱ta ta̱lhtitili. ");
INSERT INTO topNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","54","Pedro ca̱takókelh ixli̱mákat hasta li̱cha̱nca Jesús ixpu̱ma̱paksi̱ncán curas. Xlá tamákxtakli quilhtí̱n ní ixtahuila̱na policías, y tzúculh ca̱ta̱skón. Hua̱k xanapuxcun curas, lactali̱pa̱u lakko̱lún, ixma̱kalhtahuake̱nacán judíos, tatamákstokli y la̱ pu̱tum ma̱paksi̱naní̱n tatahuilako̱lh. Ixli̱puntzú li̱minca Jesús ixlacatí̱n lihua xapuxcu ma̱paksi̱na cura. ");
INSERT INTO topNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xa̱makapitzi lacchixcuhuí̱n tzúculh talacpuhuán tú natali̱ya̱huá Jesús xlacata natamakní, pero ni̱ ixtataka̱sa tú natali̱ya̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tunu lacchixcuhuí̱n ixtaliakskahuinán y ni̱ para chuná de acuerdo ixtatahuilá tú nataliakskahuima̱xtú. ");
INSERT INTO topNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Makapitzi tatá̱yalh y chuné taliakskahuínalh Jesús: ");
INSERT INTO topNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Aquín ckaxmatui namá chixcú huá: “Aquit cama lactlahuakó jaé ixpu̱siculan Dios ni̱ma̱ taya̱huani̱t lacchixcuhuí̱n y ixliaktutu chichiní cama tlahuá tunu ma̱s la̱n ni̱ la̱ jaé ni̱ma̱ tatlahuani̱t lacchixcuhuí̱n.” ");
INSERT INTO topNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Y ni̱ para chuná acxtum ixtali̱chihui̱nán tú ixtaliakskahuinama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Acxni tá̱yalh lihua xapuxcu ixma̱paksi̱nacán curas, kalasquínilh Jesús: ―¿Hua̱nchi ni̱tú kalhti̱nana? ¿Ni̱ kaxpata la̱ lhu̱hua tú tali̱ya̱huamá̱n jaé lacchixcuhuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ni̱ kálhti̱lh ma̱s chá acs tá̱yalh. Amá chixcú ixli̱maktuy kalasquinipá: ―¿Xli̱ca̱na huix Cristo ixkahuasa Dios? ");
INSERT INTO topNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús acxnicú kalhtí̱nalh: ―Xli̱ca̱na aquit Cristo, y huixín pa̱t acxilá̱tit la̱ aquit Xatalacsacni Chixcú cama tahuilá ixpa̱xtú̱n ixpu̱ma̱paksi̱n Dios, y acxni nachá̱n quilhtamacú cama ta̱ctapará nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Amá xapuxcu ma̱paksi̱ná xti̱tli ixlháka̱t ixacstu xlacata hua̱k nata̱cxila xli̱ca̱na sí̱tzi̱lh, y chuné ca̱huánilh ixcompañeros: ―¿Tucu ma̱s taputzá̱n lacasquiná̱u? ");
INSERT INTO topNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Huixín kaxpatni̱tántit la̱ ta̱ra̱lacata̱qui̱ni̱t Dios jaé chixcú la̱ta chihui̱nán. ¿Tucu puhuaná̱tit tla̱n tlahuanicán? Xa̱makapitzi takalhtí̱nalh xlacata camakni̱ca. ");
INSERT INTO topNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Makapitzi tzúculh talacachucxuí, tali̱lakáchi̱lh lháka̱t ixtalakakaxí ixlacán. Uyu ixtakalasquiní: ―Caquilhchipi, ¿ticu lakakaxín? A̱stá̱n macama̱sta̱ca ixmacán policías y xlacán na̱ chuná tali̱chíyalh. ");
INSERT INTO topNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","La̱ta ní ixca̱ta̱skoma Pedro xa̱makapitzi policías chilh cha̱tum itsquití xapuxcu cura. ");
INSERT INTO topNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Acxni ácxilhli aná skoma, acs lacá̱nilh y huánilh: ―Huix na̱ ixta̱lapu̱laya Jesús xalac Nazaret. ");
INSERT INTO topNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro kálhti̱lh: ―Aquit ni̱ clakapasa namá chixcú ni̱ma̱ quili̱ta̱chihui̱námpa̱t. Pedro táxtulh nac lacaquilhtí̱n acxni tásalh tantum pu̱yu. ");
INSERT INTO topNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Amá pusca̱t laca̱nipá Pedro y ca̱huánilh xa̱makapitzi: ―Jaé chixcú ixta̱lapu̱lá Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro kalhti̱nampá xlacata ni̱ ixlakapasa tí ixli̱ta̱chihui̱nama̱ca. Ixli̱puntzú tahuanipá policías tí ixtahuila̱na aná lacatzú: ―Xli̱ca̱na ixta̱lapu̱laya Jesús porque huix xalac Galilea, hasta mintachihuí̱n tla̱n li̱lakapascana. ");
INSERT INTO topNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro tzúculh li̱quilhán Dios xlacata xli̱ca̱na tú ixkalhti̱nama y ca̱huanipá: ―Aquit ni̱ clakapasa namá chixcú Jesús ni̱ma̱ quila̱li̱ta̱chihui̱nama̱náu. ");
INSERT INTO topNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Acxni káxmatli tasapá tantum pu̱yu y lacapá̱stacli tú ixuanini̱t Jesús: “Acxni ya̱ tasaj nahuán ixli̱maktuy tantum pu̱yu huix pa̱t huana maktutu xlacata ni̱ quilakapasa.” Pedro lakapútzalh y tzúculh tasá acxni catzi̱ko̱lh la̱ lákcha̱lh ixtachihuí̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Acxni ya̱ itxkaká amá ca̱tzisní xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos y lakko̱lún táli̱lh Jesús tachí̱n ixlacatí̱n ixpu̱ma̱paksi̱n Poncio Pilato. ");
INSERT INTO topNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Xlá ma̱kalhapáli̱lh Jesús y chuné kalasquínilh: ―¿Xli̱ca̱na huix ixreycan judíos? ―Huix quilhchipini̱ta porque xli̱ca̱na aquit rey ―kalhtí̱nalh Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ixenemigos lhu̱hua tú tzucupá taliakskahuinán ixlacati̱n Pilato. ");
INSERT INTO topNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xlá huanipá Jesús: ―¿Hua̱nchi ni̱tú kalhti̱nana? ¿Ni̱ kaxpata la̱ lhu̱hua tú tali̱ya̱huamá̱n jaé lacchixcuhuí̱n? ");
INSERT INTO topNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Xlá ni̱tú kalhtí̱nalh y Pilato yaj cátzi̱lh tú nakalasquiní, o tú nali̱ya̱huá. ");
INSERT INTO topNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Nac pu̱la̱chi̱n ixtanu̱ma cha̱tum chixcú ixuanicán Barrabás na̱ chuná ixcompañeros tí ixca̱ta̱makni̱nani̱t nac aktum tara̱nicni. Pilato ixli̱smani̱ni̱t makxtaka cha̱tum tachí̱n amá tacuhui̱ní xla pa̱xcua xani̱ma̱ta ixtalacasquín o ixtasquín cristianos. ");
INSERT INTO topNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ixli̱puntzú táchilh nac ixpu̱ma̱paksí̱n lhu̱hua cristianos y tahuánilh caca̱má̱xqui̱lh cha̱tum tachí̱n la̱ siempre ixmakxtaka. ");
INSERT INTO topNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ca̱kalasquínilh: ―¿Lacasquiná̱tit huixín cacmákxtakli jaé chixcú tí huaná̱tit xlacata ixreycán judíos? ");
INSERT INTO topNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato chú ca̱huánilh porque ixma̱kachakxi̱ni̱ttá xlacata ixenemigos Jesús ixtama̱lacapu̱ni̱t ixtamakni̱putún porque ixtalakcatzaní tú ixtlahuá y tú ixli̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Xanapuxcun curas ixenemigos Jesús tuncán tzúculh ta̱kastacya̱huá hua̱k cristianos xlacata catásquilh camakxtakca Barrabás. ");
INSERT INTO topNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ca̱kalasquinipá: ―¿Y tucu lacasquiná̱tit cactlahuánilh jaé chixcú ixreycán judíos? ");
INSERT INTO topNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Hua̱k cristianos ta̱ktásalh: ―¡Camakni̱ca nac culu̱s! ");
INSERT INTO topNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―Pues, ¿tucu tlahuani̱t ni̱ tlá̱n jaé chixcú? ―ca̱huanipá Pilato. Pero xlacán ta̱ktasapá: ―¡Camakni̱ca nac culu̱s! ");
INSERT INTO topNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Como Pilato ni̱ ixca̱makasi̱tzi̱putún cristianos tí ixtata̱ya̱na ixli̱ma̱paksí̱n, mákxtakli Barrabás y li̱ma̱paksí̱nalh casnokca Jesús; a̱stá̱n ca̱macamá̱xqui̱lh soldados xlacata xlacán natamakní nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Amá soldados táli̱lh Jesús ixlacaquilhti̱n ixchic Pilato, hua̱k xa̱makapitzi tatamakstokko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xlacán tama̱xtúnilh ixlháka̱t Jesús y tahuilí̱nilh aktum tzutzoko lhma̱n lháka̱t la̱ xla rey y aktum corona xla lhtucú̱n. ");
INSERT INTO topNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Tzúculh tali̱chiyá, ixtalacachucxuí, ixtali̱lakasnoka lasasa, ixtatatzokostaní la̱ catalakachixcúhui̱lh cha̱tum rey y chuné ixtahuaní: ―¡Siempre calatáma̱lh ixreycan judíos! ");
INSERT INTO topNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Acxni tali̱chiyako̱lh la̱ta talacásquilh tama̱xtunipá lháka̱t tzutzoko y tahuili̱nipá lihua ixlháka̱t Jesús. A̱stá̱n táli̱lh a̱lacatunu xlacata natamakní nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cha̱tum chixcú xalac Cirene ixuanicán Simón, ixlakkahuasán ixca̱huanicán Alejandro y Rufo, ixtaspitma ixca̱tucuxtu acxni ixlacpasa̱rlama lacatzú ní ixtalaya̱na soldados; tachipatá̱yalh y xafuerza tama̱lí̱ni̱lh laktzú ixculu̱s Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ca̱li̱nca pakán ixquilhpa̱n ca̱chiquí̱n lacatum ní ixuanicán Gólgota; jaé tachihuí̱n huamputún Ixpu̱latama̱n ixaclucut Ni̱n. ");
INSERT INTO topNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Acxni táchilh Jesús ma̱lacnu̱nica cahualh cuchu ni̱ma̱ ixta̱lani̱t xu̱n lí̱cuchu, pero xlá ni̱ kalhuá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Ma̱x aknaja̱tza hora lacatzisa ixuani̱t acxni Jesús akxtokohuacaca nac culu̱s. La̱ tama̱huacako̱lh nac culu̱s soldados tzúculh tara̱li̱slaká ixlháka̱t Jesús a ver ticu natoca̱rlí. ");
INSERT INTO topNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ixakspú̱n culu̱s ana ní istzokcán tú xlacata ixca̱li̱makni̱cán chuné tzoknica ixculu̱s Jesús: “Jesús xalac Nazaret ixreycan judíos.” ");
INSERT INTO topNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ixpa̱xtu̱ni̱tni na̱ ca̱makni̱ca cha̱tuy kalha̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chuná jaé kantáxtulh tú ixuán Escrituras ama pa̱xtoka Cristo: “Li̱maca̱nca la̱ cha̱tum ni̱ tla̱n chixcú.” ");
INSERT INTO topNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na̱ chuná tí ixtapasa̱rlá lacatzú ní ixma̱huacacani̱t Jesús ixtali̱kalhkama̱nán y chuné ixtahuaní: ―¿La̱mpara huana xlacata tla̱n lactlahuaya pu̱siculan, ixli̱aktutu chichiní tlahuaya tunuj xasa̱sti? ");
INSERT INTO topNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Chí tucu lanípa̱t? ¿Hua̱nchi ni̱ lá ta̱ctaya ní huaca y lakma̱xtucana mi̱cstu? ");
INSERT INTO topNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Makapitzi xanapuxcun curas, ixma̱kalhtahuake̱nacan judíos na̱ chuná ixtali̱kalhkama̱nán: ―¿Para tla̱n ca̱ma̱ksá̱ni̱lh xa̱makapitzi cristianos, chí hua̱nchi ni̱ lá lakma̱xtucán ixacstu? ");
INSERT INTO topNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Para acxilá̱u la̱ta chí tuncán ta̱ctá nac culu̱s namá chixcú tí li̱ta̱yá rey xalac Israel, entonces aquín na̱ naca̱najlayá̱u xlacata huá Cristo tí ama min. Amá kalha̱naní̱n tí na̱ ixca̱kxtokohuacacani̱t nac culu̱s na̱ chuná ixtali̱kalhkama̱nán. ");
INSERT INTO topNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Acxni tastúnulh ca̱quilhtamacú tapaklhtu̱tako̱lh y qui̱tá̱yalh ma̱x aktutu hora ixuani̱t xalakasmalankán. ");
INSERT INTO topNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Acxni Jesús chuné aktásalh: ―Eloi, Eloi, ¿lama sabactani? ―Jaé tachihuí̱n huamputún: Dios huix quinti̱cú, ¿hua̱nchi quiakxtakmakani̱ta jaé quilhtamacú? ");
INSERT INTO topNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Makapitzi tí ixtaya̱na lacatzú takáxmatli y tara̱huánilh: ―Cakaxpáttit la̱ ma̱tasi̱ma profeta Elías. ");
INSERT INTO topNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cha̱tum chixcú tatza̱lh alh tiyá aktum lháka̱t, tla̱n ma̱chú̱hui̱lh ixchuchut vinagre, ma̱kánu̱lh nac quihui y ma̱lacatzúhui̱lh ixquilhni Jesús, y chuné ca̱huánilh xa̱makapitzi: ―¡Ni̱tú cahuántit! A ver para xli̱ca̱na min lakma̱xtú profeta Elías. ");
INSERT INTO topNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús aktasapá a̱maktum uyu tuncán ni̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huata ni̱ko̱lh Jesús, nac lanca pu̱siculan xla Jerusalén ana ní ixtalakachixcuhui̱nán curas ca̱ta cá̱ta, amá lanca li̱lakalhapá̱n ni̱ma ixtahuacani̱t ixacstu táxti̱tli. ¡Tapakapítzilh la̱ta tu̱tzú hasta ta̱lhmá̱n! ");
INSERT INTO topNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Xacapitán soldados ni̱ma̱ ixyá lacatzú ní ixuaca Jesú̱s, acxni káxmatli la̱ chihuí̱nalh y ácxilhli la̱ ni̱ko̱lh, chuné huá: ―¡Xli̱ca̱na jaé chixcú Ixkahuasa Dios! ");
INSERT INTO topNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Makapitzi lacchaján tí a̱huata tica̱ta̱táxtulh Jesús nac Galilea acxni milh nac Jerusalén, ixtaya̱na aná lacatzú ní ixmakni̱cani̱t Jesús y hua̱k ixta̱cxilhni̱t tú ixqui̱taxtuni̱t. Amá lacchaján tí ma̱s ixtamakta̱yani̱t Jesús ixca̱huanicán María Magdalena, y tunuj María ixna̱najcán Jacobo y José, y na̱ chuná Salomé. ");
INSERT INTO topNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Amá smalankán acxni hua̱k cristianos ixtatlahuá ixtahuajcán porque ixli̱cha̱lí ni̱ lá tí itscuja, ");
INSERT INTO topNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","milh ma̱ctí xaní̱n Jesús cha̱tum chixcú tí na̱ ixca̱ta̱ma̱paksi̱nán curas nac Jerusalén ixuanicán José ixlama nac Arimatea. Pero José tla̱n chixcú ixuani̱t ixkalhi̱ma nalacatzucú ixtapáksi̱t Dios ca̱quilhtamacú. Xlá kálhi̱lh li̱camama alh acxila Pilato xlacata camá̱xqui̱lh xaní̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Acxni káxmatli Pilato tú ixmaclacasquín ni̱ ca̱nájlalh para Jesús xli̱ca̱na ixni̱ni̱ttá y kalasquínilh capitán. ");
INSERT INTO topNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amá capitán huánilh xli̱ca̱na ixni̱ni̱ttá Jesús. Entonces huánilh cali̱lh xaní̱n para ixlacasquín. ");
INSERT INTO topNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José tamá̱hualh aktum tla̱n lháka̱t y alh ma̱ctí xani̱n Jesús nac culu̱s. A̱stá̱n tla̱n máksuitli nac lháka̱t; li̱lh lacatum ixpu̱muju̱can ni̱n ni̱ma̱ ixtahuaxni̱ttá ixlacapu̱n talhpá̱n y puru chíhuix ixkalhí; aná má̱nu̱lh xaní̱n Jesús. A̱stá̱n lacahuíli̱lh aktum lanca chíhuix ixlacatí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena y María ixna̱na José tla̱n tá̱cxilhli ana ní ma̱nu̱ca Jesús. ");
INSERT INTO topNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","La̱ tipasa̱rlako̱lh amá chichiní acxni ni̱tí itscuja, xaca̱tzisní pi̱huá amá chichiní, Maria Magdalena, María ixna̱na José, Jacobo y Salomé táalh tatama̱huá perfumes tú natamacuilí Jesús la̱ta xaní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ixli̱cha̱li domingo la̱ta spalh ca̱huama táalh ní ixma̱nu̱cani̱t Jesús. Acxni tácha̱lh istzucuni̱ttá taxtú chichiní. ");
INSERT INTO topNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ixtara̱huaní ixcha̱tuycán: ―¿Chá ticu tla̱n nama̱ke̱nú namá chíhuix ni̱ma̱ tali̱lakatalán ní tanu̱ma Jesús? ");
INSERT INTO topNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero acxni tla̱n caso tatláhualh tá̱cxilhli amá chíhuix ni̱ma̱ ixli̱talakatalán yaj ixkalhí ixlacatí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tatánu̱lh tziná y tá̱cxilhli ixpa̱xtú̱n curucs huí cha̱tum kahuasa ixuili̱ni̱t lhma̱n y staranka lháka̱t; xlacán tajicuanko̱lh. Pero amá kahuasa ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","―Ni cajicuántit, ccatzí xlacata putzayá̱tit Jesús xalac Nazaret ni̱ma̱ makni̱ca nac culu̱s. Pero xlá yaj tanu̱ma juú porque lacastacuanamparani̱t ca̱li̱ní̱n y chí lama̱pajá xastacnán. Para ni̱ ca̱najlayá̱tit tla̱n ca̱cxílhtit ní ixma̱nu̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Capítit ca̱huaniyá̱tit ixdiscípulos, y Pedro na̱ chuná, xlacata Jesús pu̱la ama cha̱n nac Galilea la̱ ixca̱huanini̱tán; aná ama ca̱kalhi̱yá̱n y naca̱cxilá̱n. ");
INSERT INTO topNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Xlacán tzúculh tatatlaná la̱ta tajicuanko̱lh y tatáxtulh tatza̱lh y táalh; pero ni̱tí tali̱ma̱kalhchihuí̱ni̱lh nac tijia tú ixta̱cxilhni̱t porque ixtajicuama̱na, y na̱ chuná ixtapa̱xahuama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Acxni ya̱ itxkaká amá chichiní, Jesús ixlacastacuanani̱ttá ca̱li̱ní̱n, ma̱lacahuá̱ni̱lh María Magdalena xlacata na̱cxila la̱ ixlamajá xastacnán. Jaé pusca̱t huá tí ixma̱ksa̱ni̱ni̱t acxni ixmactanu̱ma cha̱tujún ixespíritu tlajananí̱n. ");
INSERT INTO topNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","La̱ acxilhko̱lh Jesús xlá ca̱lákalh ixdiscípulos y ca̱huánilh la̱ ixacxilhni̱t Jesús xastacnán; xlacán ixtalakaputzama̱na ixtatasama̱na. ");
INSERT INTO topNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero acxni ca̱huanica Jesús lacastacuanani̱t y lapu̱lá xastacnán, xlacán ni̱ taca̱nájlalh. ");
INSERT INTO topNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ixli̱punchú cha̱tuy ixdiscípulos ixta̱ma̱na pakán aktum pu̱latama̱n lacatzú cJerusalén; nac tijia Jesús ca̱ma̱lacahuá̱ni̱lh xlacata nata̱cxila y nataca̱najlá la̱ ixlacastacuanani̱t ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Xlacán tuncán tatáspitli y tali̱ma̱kalhchihuí̱ni̱lh xa̱makapitzi la̱ ixta̱cxilhni̱t Jesús xastacnán, pero xlacán ni̱ para chú taca̱nájlalh. ");
INSERT INTO topNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jesús a̱stá̱n ca̱ma̱lacahuá̱ni̱lh ixcha̱ca̱huitucán ixdiscípulos xlacata nata̱cxila la̱ ixlama xastacnán. Xlacán ixtahua̱yama̱na nac mesa y ca̱kahuánilh tziná xlacata ni̱ ixtaca̱najlani̱t la̱ ixta̱cxilhni̱t xastacnán xa̱makapitzi, porque snu̱n palha ixtakalhí ixnacujcán y ni̱ lá ixtaca̱najlani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A̱stá̱n chuné ca̱huánilh hua̱k ixdiscípulos: ―Capítit hua̱k ca̱lacchiquí̱n xala ca̱quilhtamacú y caca̱li̱ta̱chihui̱nántit hua̱k cristianos la̱ ca̱ma̱lacnu̱ní Dios naca̱lakma̱xtú ixli̱stacnicán nac akapú̱n para aquit quintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tí naquintali̱pa̱huán y natata̱kmunú ta̱má̱n tataxtuní nac akapú̱n, pero tí ni̱ quintali̱pa̱huán ixacstucán talaktzanka̱ni̱t y ama taxoko̱nán tú ni̱ tla̱n tatlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","’Makapitzi cristianos tí naquintali̱pa̱huán, Dios ama ca̱ma̱xquí li̱tlihueke xlacata natama̱ksa̱ní tí ca̱ctanu̱ma ixespíritu tlajaná, na̱ tla̱n ama tachihui̱nán ti̱pa̱katzi tachihuí̱n ni̱ma̱ ni̱ ixtacatzí. ");
INSERT INTO topNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tla̱n ama tachipá lu̱hua y ni̱tú catica̱tlahuánilh, y para tahuá veneno ni̱ catica̱pú̱ti̱lh y tla̱n ama tali̱ma̱ksa̱ní cristianos ixmacancán; y chuná jaé huixín nacatzi̱yá̱tit Dios ca̱ta̱lamá̱n cmilatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","La̱ ca̱ta̱chihui̱nanko̱lh ixdiscípulos ixlacati̱ncán Jesús tá̱cxtulh nac akapú̱n ana ní huí Dios. ");
INSERT INTO topNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A̱stá̱n xlacán tatáxtulh cani̱huá ca̱lacchiquí̱n y tama̱kalhchihuí̱ni̱lh cristianos la̱ Dios ca̱ma̱lacnu̱ní naca̱lakma̱xtú. Xlacán tatláhualh laclanca tascújut porque lhu̱hua tí tama̱ksá̱ni̱lh y la̱ta ní ixtali̱chihui̱nán Jesús xlá siempre ixca̱makta̱yá xlacata natacatzí Dios ixca̱ta̱lama nac ixlatama̱tcán. Chuná calalh, amén.");
INSERT INTO topNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lhu̱hua cristianos talacsacxtuni̱t tancs tatzoka tú xli̱ca̱na qui̱taxtuni̱t nac ixlatáma̱t Jesucristo ");
INSERT INTO topNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","y tla̱n cma̱luloka hua̱k xli̱ca̱na la̱ tali̱chihui̱nani̱t tí xla̱huán ta̱cxilhni̱t tú qui̱táxtulh la̱ta tilacatzúculh ixlatáma̱t y na̱ xla̱huán tzúculh tali̱chihui̱nán la̱ Dios ma̱lacnú ca̱ma̱paksi̱putún cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Aquit na̱ tla̱n clacputzani̱t y cli̱kalasquini̱nani̱t hua̱k tú qui̱táxtulh la̱ta tilacatzúculh ixlatáma̱t, y cpuhuán namacuaniyá̱n, tali̱pa̱u quiamigo Teófilo, la̱ aquit clacsacxtuni̱t nactzoka, ");
INSERT INTO topNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","xlacata tancs nama̱kachakxi̱ya namá talacapa̱stacni ni̱ma̱ li̱ma̱kalhchihui̱ni̱cani̱ta naca̱najlaya. ");
INSERT INTO topNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chí camá̱n huaniyá̱n la̱ li̱mini̱tanchá jae takalhchihuí̱n: acxni ixma̱paksi̱nán nac pu̱latama̱n Judea cha̱tum rey huanicán Herodes na̱ ixlama cha̱tum cura huanicán Zacarías. Xlá ixca̱ta̱lakachixcuhui̱nán nac lanca pu̱siculan xla Jerusalén pu̱tum curas tí ixca̱ma̱lacatzuqui̱ni̱t Abías. Ixta̱cha̱t Zacarías ixuanicán Elisabet y xlá na̱ ixli̱talakapasni ixuani̱t Aarón amá tali̱pa̱u chixcú ti̱ xla̱huán tili̱ma̱pa̱cuhui̱ca cura nalakachixcuhui̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías y Elisabet tancs ixtalama̱na ṉi̱ ixtali̱makxtaka talakachixcuhuí Dios ixtama̱kantaxtí hua̱k ixtapáksi̱t Dios nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero ni̱ ixtakalhí ixcamancán porque snu̱n lakko̱luná ixtahuani̱t, y xa̱huá Elisabet ni̱ lá ixkalhi̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Maktum quilhtamacú Zacarías y tí ixca̱ta̱lakachixcuhui̱nán ca̱tocá̱rli̱lh natalakachixuhuí Dios aktum xama̱na nac lanca pu̱xiculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Xlacán tali̱máca̱lh suerte tí lihua natanú nac ixpu̱lakachixcuhui̱cán Dios nac pu̱siculan, y tocá̱rli̱lh Zacarías nalhcuyú incienso. ");
INSERT INTO topNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Acxni tánu̱lh tzúculh lhcuyú incienso, y hua̱k cristianos tzúculh takalhtahuakaní Dios nac lacaquilhti̱n. ");
INSERT INTO topNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","La̱ta ixkalhtahuakanima Dios lakata̱yachi cha̱tum ángel nac ixpa̱xtú̱n ní itlhcuyucán incienso. ");
INSERT INTO topNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Acxni ácxilhli xlá jicuanko̱lh y ni̱ cátzi̱lh tú nahuán y tú natlahuá. ");
INSERT INTO topNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero amá ángel huánilh: ―Zacarías, ni̱ cajícuanti. Dios kaxmatni̱t la̱ kalhtahuakaniya y minta̱cha̱t Elisabet ama ta̱ta̱yá cha̱tum ska̱ta, nahuili̱niya ixtacuhui̱ní Juan. ");
INSERT INTO topNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Huix snu̱n pa̱t li̱pa̱xahuaya minkahuasa y na̱ chuná lhu̱hua cristianos ama tali̱pa̱xahuá acxni nalacachín ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porque minkahuasa lacsacnit Dios y snu̱n tali̱pa̱u ama huan. Xlá ni̱cxni ama kalhua̱nán cuchu ni̱ para pulque. Dios lacasquín cama̱kantáxti̱lh ixtascújut y ama ma̱xquí ixli̱tlihueke Espíritu Santo la̱ta ya̱ para lakahuán nahuán. ");
INSERT INTO topNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Acxni natachixcuhuí ama ca̱ma̱kalhchihui̱ní cristianos xalac Israel xlacata natali̱pa̱huampará Ixpuchinacán Dios. ");
INSERT INTO topNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Xlá ama pu̱laní Ixpu̱chinacán tí takalhi̱ma̱na ama min ca̱lakmaxtú xlacata natalakapasa ticu xlá; ama kalhí ixli̱tlihueke y ixtapuhuá̱n la̱ amá profeta tí maká̱n tilatáma̱lh ixuanicán Elías xlacata xanati̱cún natalakalhamampará ixcamancán, tí ni̱ ta̱kahua̱nán natali̱lacahua̱nán ixlatama̱tcán tí tla̱n tacatzí, y hua̱k cristianos natacatzí la ixli̱latama̱tcán xlacata ni̱tú natali̱ma̱xanán acxni naca̱lakchín Ixpuchinacán. ");
INSERT INTO topNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías huánilh amá ángel: ―¿Nicu nacli̱catzí para xli̱ca̱na tú quihuanípa̱t? Porque aquit snu̱n ko̱lutá y quinta̱cha̱t na̱ chuná. ");
INSERT INTO topNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Amá ángel kálhti̱lh: ―Aquit quihuanicán Gabriel y clama ixpa̱xtú̱n Dios cma̱kantaxtí tú quili̱ma̱paksí. Xlá quima̱lakácha̱lh nacuaniyá̱n jaé lactlá̱n takalhchihuí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","pero como huix ni̱ ca̱najla quintachihuí̱n chí tuncán pa̱t ko̱ko̱nana y yaj lá pa̱t chihui̱nana hasta xní nalakahuán minkahuasa. La̱ta jaé tú cuanín hua̱k ama kantaxtú. ");
INSERT INTO topNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Amá cristianos tí ixtakalhtahuakama̱na nac lacaquilhti̱n tzúculh ta̱katuyún pues ni̱ ixtama̱kachakxí hua̱nchi Zacarías snu̱n ixmakapalama nac pu̱lakachixcuhui̱n. ");
INSERT INTO topNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pero acxni táxtulh Zacarías yaj lá ixchihui̱nán ixko̱ko̱ni̱t, huata ixca̱li̱macahuaní ixmacán tú ixca̱huaniputún y xlacán tama̱kachákxi̱lh xlacata Dios ma̱lakachiyá̱ni̱lh acxni lakachixcuhuí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Acxni sputli chichiní nalakachixcuhui̱nán Zacarías nac lanca pu̱siculan xla Jerusalén táspitli nac ixca̱chiquí̱n ní ixlama. ");
INSERT INTO topNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","A̱stá̱n Elisabet ixta̱cha̱t Zacarías tzúculh maklhcatzí ixta̱ta̱yama skata y ni̱ táxtulh nac ixchic akquitzis papá. ");
INSERT INTO topNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Huata ixlacpuhuán: “Quimpu̱china Dios quiacxilhlacachini̱t quima̱lakachá̱nilh cha̱tum skata xlacata cristianos yaj naquintali̱kalhkama̱nán.” ");
INSERT INTO topNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ixliakcha̱xán papá a̱stá̱n Dios ma̱lakácha̱lh ángel Gabriel nac aktum ca̱chiquí̱n huanicán Nazaret ixli̱tapaksí Galilea ");
INSERT INTO topNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","xlacata nalakpaxia̱lhnán cha̱tum tzuma̱t huanicán María, xlá ixtasquín ixuí ama ta̱tamakaxtoka cha̱tum ixli̱talakapasni rey David ixuanicán José. ");
INSERT INTO topNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Amá ángel laktánu̱lh ní ixuí María y huánilh: ―¡Cli̱pa̱xahuayán tla̱n tzuma̱t la̱ lakalhamani̱tán Dios! Quimpu̱chinacán akskalhi̱mán. Ixli̱hua̱k lacchaján huix ma̱s acxilhlacachini̱tán nalakalhamaná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Acxni María ácxilhli amá ángel snu̱n tzúculh liakatuyún tú ixuaniti̱t. Ni̱ ixma̱kachakxí hua̱nchi chú ixta̱chihui̱nani̱t amá ángel. ");
INSERT INTO topNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pero xlá tuncán huanipá: ―María, ni cajícuanti. Dios acxilhlacachini̱tán lakalhamani̱tán nama̱kantaxti̱ya tú laclhca̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Yaj maka̱s pa̱t ta̱ta̱yaya cha̱tum skata y acxni nalakahuán nahuili̱niya ixtacuhui̱ní Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Xlá snu̱n tali̱pa̱u ama huan y ama̱ca li̱maca̱ncán Ixkahuasa Dios tí ni̱tí ma̱ccha̱ní ixli̱tlihueke y ama maklhti̱nán ixpu̱táhui̱lh ní nama̱paksi̱nán la̱ tima̱lacnú̱nilh Dios ixli̱talakapasni rey David. ");
INSERT INTO topNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jesús rey ama huan jaé pu̱latama̱n Israel cani̱cxnihuá, ixtapáksi̱t ni̱cxni ama lakó ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María kalasquínilh amá ángel: ―¿Niculá ama qui̱taxtú jaé tú quihuaniya pues aquit ni̱ cta̱latama̱ni̱t chixcú? ");
INSERT INTO topNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Xlá kálhti̱lh: ―Ni̱tú cali̱púhuanti, Espíritu Santo ama ma̱xquí mimacni tú makatzanka̱ya y pa̱t maklhcatzi̱ya ixli̱tlihueke Dios nac mimacni la̱ acxni puclhni ta̱ta̱yá se̱n. Huá xlacata namá skata Dios ama ma̱tunuja namacuaní y ama̱ca li̱ma̱pa̱cuhui̱cán Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mili̱talakapasni Elisabet, amá tí ixli̱kalhkama̱nancán ni̱ lá makastacnán, ma̱squi cha̱ttá na̱ ama ma̱lakahuaní cha̱tum skata y chí kalhi̱yá akcha̱xán papá la̱ta titzúculh ta̱ta̱yá itskata. ");
INSERT INTO topNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porque Dios hua̱k tla̱n tlahuá tú lacasquín. ");
INSERT INTO topNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","María huanipá: ―Aquit siempre nackaxmata tú li̱ma̱paksi̱nán Dios, catláhualh quilacata tú lacasquín y caqui̱táxtulh tú quihuanini̱ta cama pa̱xtoka. La̱ ta̱chihui̱nanko̱lh María amá ángel ampá ní ixmini̱tanchá. ");
INSERT INTO topNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ni̱ ixli̱maka̱s quilhtamacú María lacapala taxtutá̱qui̱lh ixchic y alh nac aktum ca̱chiquí̱n ni̱ma̱ ixuí ca̱lacsipijni amá pu̱latama̱n Judea. ");
INSERT INTO topNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cha̱lh nac ixákxtaka Zacarías y acxni tánu̱lh huánilh kalhé̱n Elisabet. ");
INSERT INTO topNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Y acxni káxmatli la̱ huánilh kalhé̱n María, Elisabet tuncán maklhcátzi̱lh la̱ itskata tapítilh nac ixpu̱lacni; y Espíritu Santo akchipánilh ixtalacapa̱stacni ");
INSERT INTO topNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","y chuné li̱pa̱xáu ma̱ktási̱lh María: ―Ixli̱hua̱k lacchaján huix ma̱s acxilhlacachini̱tán lakalhamani̱tán Dios, y na̱ chuná acxilhlacachini̱t namá skata ni̱ma̱ tá̱ya̱t. ");
INSERT INTO topNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¡Snu̱n pa̱xahuá quinacú porque mini̱t quilakpaxia̱lhnán ixna̱na tí ama quinca̱lakma̱xtuyá̱n ca̱quilhtamacú! ");
INSERT INTO topNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porque huata quihuani kalhé̱n, quinkahuasa ni̱ma̱ cta̱yajá na̱ pa̱xáhualh y tapítilh nac quimpu̱lacni. ");
INSERT INTO topNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios xli̱ca̱na ama ma̱kantaxtí tú ma̱lacnu̱nín. ¡Capa̱xáhualh minacú porque huix ca̱najla ixtachihuí̱n! ");
INSERT INTO topNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","A̱stá̱n María na̱ tzúculh chihui̱nán: Quili̱stacni lakachixcuhuí Quimpu̱chiná, ");
INSERT INTO topNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","y quinacú li̱pa̱xahuá Dios porque quilakma̱xtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios quilacachínilh aquit ma̱squi ni̱ tali̱pa̱u tzuma̱t, y la̱ta chí hua̱k cristianos ama quintali̱pa̱xahuá cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Lanca tlihueke Dios tlahuani̱t quilacata lhu̱hua ixtascújut, huá cli̱lakachixcuhuí ixtacuhui̱ní. ");
INSERT INTO topNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Xlá ca̱lakalhamán cristianos cani̱cxnihuá tí ti̱tum talatamá takaxmata ixtachihuí̱n nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ixlitlihueke li̱tlahuani̱t laclanca ixtascújut ca̱quilhtamacú ca̱makatlájalh ca̱ma̱ktzúhui̱lh tí ixtalactlancán nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ca̱lactláhualh ixli̱ma̱paksi̱ncán tí ixtali̱tanú lactali̱pa̱u ma̱paksi̱naní̱n, y tí ni̱ lactali̱pa̱u cristianos ca̱má̱xqui̱lh ixpu̱tahui̱lhcán. ");
INSERT INTO topNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tí ixtatzincsa ixli̱stacnicán ca̱má̱xqui̱lh tú ixtamaclacasquín, y ricos ni̱ ca̱li̱mákxtakli catali̱pa̱xáhualh tú takalhí nac ixmacancán. ");
INSERT INTO topNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ca̱maktá̱yalh ixcamán xalac Israel tí ca̱lacsacni̱t, ni̱ ca̱ktzónksualh ca̱cxilhlacachá̱n tí tama̱kantaxtí ixli̱ma̱paksí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","la̱ tica̱ma̱lacnú̱nilh Dios Abraham y xalakmaká̱n quili̱takapasnicán xlacata ixama ca̱lakalhamán y ca̱makta̱yá ixcamán xalac Israel cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María ta̱latámalh Elisabet ma̱x aktutu papá a̱stá̱n tástitli nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ni̱ ixli̱maka̱s Elisabet acchá̱nilh ixquilhtamacú nata̱tatlá y lakáhualh itskata cha̱tum actzú kahuasa. ");
INSERT INTO topNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hua̱k ixta̱pakánat ixli̱talakapasni acxni tacátzi̱lh la̱ Dios ixacxilhlacacha̱ni̱t ixma̱lakacha̱nini̱t cha̱tum itskata ta̱lh talakpaxia̱lhnán y tata̱pa̱xáhualh. ");
INSERT INTO topNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ixli̱tu̱má ixnati̱cún tama̱kantáxti̱lh la̱ ixtali̱smani̱ni̱t judíos tatlahuá xalakkahuasán itskatacán. Ixuili̱niputuncán ixtacuhui̱ní Zacarías la̱ ixti̱cú. ");
INSERT INTO topNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero ixna̱na ca̱huánilh: ―¡Tó̱! Catapa̱cúhui̱lh Juan. ");
INSERT INTO topNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","―¿Hua̱nchi chú natapa̱cuhuí? Ni̱ cha̱tum mili̱talakapasni tí chuná huanicán ―takalhtí̱nalh makapitzi. ");
INSERT INTO topNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Y tzúculh tamacahuaní Zacarías caca̱huánílh tucu yá tacuhui̱ní ixlacasquín cali̱tapa̱cúhui̱lh ixkahuasa. ");
INSERT INTO topNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xlá squilh aktum lhtacala y chuné tzokli: “Cali̱tapa̱cúhui̱lh Juan.” Amá cristianos tí ixtalaya̱na lacatzú ni̱ tama̱kachákxi̱lh hua̱na ixlacasquín cali̱tapa̱cúhui̱lh Juan. ");
INSERT INTO topNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na̱ acxni tuncán Zacarías cá̱xlalh istzi̱máka̱t. ¡Tla̱n chihui̱nampá y tzúculh lakachixcuhuí Dios! ");
INSERT INTO topNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Hua̱k cristianos tí lacatzú ixtalama̱na ni̱ ixtama̱kachakxí tú ixqui̱taxtuma y hua̱k tí ixtalama̱na nac pu̱latama̱n ni̱ma̱ ixuí ca̱lacsipijni nac Judea tzúculh tali̱chihui̱nán la̱ta tú ixqui̱taxtuni̱t acxni lacáchilh amá skata ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tí ixtakaxmata istzucú ta̱katuyún, ixtara̱kalasquiní: ―¿Cha̱ tucu yá chixcú ama huan namá skata? Pues xli̱ca̱na ixmacán Dios ixtasí la̱ ixmaktakalha amá skata. ");
INSERT INTO topNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Espíritu Santo akchipánilh ixtalacapa̱stacni Zacarías ixti̱cú amá skata y chuné tzúculh chihui̱nán: ");
INSERT INTO topNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Siempre cata̱yánilh Quimpu̱chinacán Dios tí ca̱maktakalha ixcamán xalac Israel, porque quinca̱lakmini̱tán aquín tí quinca̱lacsacni̱tán y quinca̱cxilhlacachini̱tán naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quinca̱ma̱lakacha̱nín cha̱tum tlihueke chixcú tí ama quinca̱lakma̱xtuyá̱n, y jaé chixcú ixli̱talakapasni rey David ama huan tí macuanini̱t. ");
INSERT INTO topNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pues la̱ta maka̱sa quilhtamacú chú ca̱ma̱lacnú̱nilh profetas tí ixca̱lacsacni̱t naquinca̱huaniyá̱n ");
INSERT INTO topNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","xlacata ixama ma̱lakachá cha̱tum tí ixama quinca̱lakma̱xtuyá̱n ixmacancán amá cristianos tí quinca̱si̱tzi̱niyá̱n y ama quinca̱ma̱ke̱nu̱yá̱n ixmacancán tí ni̱ quinca̱cxilhputuná̱n aquín judíos. ");
INSERT INTO topNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dios na̱ ma̱lácnu̱lh ixama ca̱lakalhamán xalakmaká̱n quili̱talakapasnicán y ni̱ ixama aktzonksuá nama̱kantaxtí tú ca̱ma̱lacnú̱nilh ixama ca̱ma̱xquí. ");
INSERT INTO topNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios tancs ma̱lacnú̱nilh quinticucán Abraham ixama ma̱lakachá tí naquinca̱maktakalhá̱n, ");
INSERT INTO topNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","xlacata ni̱tú naquinca̱tlahuaniyá̱n tí quinca̱sitzi̱niyá̱n, y tla̱n li̱pa̱xáu namacuaniyá̱u ixli̱hua̱k quinacujcán, ");
INSERT INTO topNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","tancs nalatama̱yáu ixlacatí̱n y tla̱n namacuaniyá̱u cha̱li cha̱lí huata Quimpuchinacán Dios. ");
INSERT INTO topNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huix quinkahuasa Juan, acxni nastaca pa̱t li̱tanu̱ya ixprofeta lanca Quinti̱cucán Dios tí ama pu̱laní Quimpu̱chinacán tí ama min; huix pa̱t ca̱ma̱lakapasni̱ya cristianos xalac Israel amá chixcú tí ama ca̱lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Huix pa̱t ca̱huaniya ixcamán tí ca̱lacsacni̱t la̱ naca̱ma̱tzanke̱nanicán ixtala̱kalhi̱ncán xlacata natalakma̱xtú ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quimpu̱chinacán Dios xalac akapún quinca̱pa̱xqui̱yá̱n y quinca̱ma̱lacnu̱niyá̱n ama macachín cha̱tum chixcú tí ta̱talacastuca ixtaxkáke̱t aktum la̱n chichiní, ");
INSERT INTO topNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","xlacata natalacahua̱nán tí ca̱paklhtu̱tá talapu̱lá y la̱ ca̱li̱ní̱n catalatáma̱lh porque ni̱tú tama̱kachakxí. Xlá ama makskoyulí̱n ixtatlá̱u quilatama̱tcán xlacata ca̱li̱tlá̱n nalatama̱yá̱u. Chuná jaé chihuí̱nalh Zacarías. ");
INSERT INTO topNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Amá actzú kahuasa Juan li̱pa̱xáu tzúculh staca; ixnacú na̱ chuná ma̱s ixma̱kachakxí la̱ nakalhí li̱camama li̱pa̱huán Dios. A̱stá̱n alh latamá ana ní ni̱tí ixtalama̱na, y acxni lákcha̱lh ixquilhtamacú tzúculh ca̱ma̱kalhchihui̱ní cristianos xalac Israel. ");
INSERT INTO topNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Amá quilhtamacú lanca ma̱paksi̱na César Augusto li̱ma̱paksí̱nalh caca̱tzokca hua̱k cristianos tí ixtalama̱na nac pu̱latama̱n ana ní ixma̱paksi̱nán xlacata nacatzi̱cán nicu cha̱li̱t natalakaxoko̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nac pu̱latama̱n Siria ixma̱paksi̱nán Cirenio y huá xla̱huán tí ma̱tzúqui̱lh ca̱tzokcán cristianos; ");
INSERT INTO topNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","y cha̱tunu ixlianatcán ixca̱chiqui̱ncán ní ixtalakahuani̱t xlacata aná naca̱tzokcán. ");
INSERT INTO topNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Como José ixli̱talakapasni ixuani̱t rey David, táxtulh ixca̱chiquí̱n Nazaret ní ixlama ixli̱tapaksí Galilea, y alh nac aktum actzu ca̱chiquí̱n huanicán Belén ixli̱tapaksí Judea pues juú ixlakahuani̱t rey David tí ixca̱ma̱lacatzuqui̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José tá̱alh María amá tzuma̱t ni̱ma̱ ixama ta̱tamakaxtoka, pero xlá ixaccha̱nimajá ixchichiní nalakahuán itskata. ");
INSERT INTO topNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Apenas ixtacha̱nit nac Belén acxni María acchá̱nilh ixquilhtamacú nata̱tatlá lakahuán itskata. ");
INSERT INTO topNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Como ni̱ tatáka̱sli ní natatamakxtaka ta̱lh lacatum ní ixca̱ma̱nu̱cán quitzistancaní̱n y aná lakáhualh xla̱huán itskata María. A̱stá̱n li̱tánksuitli tánchut y trámi̱lh ana ní ixtahua̱yán quitzistancaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Lacatzú nac Belén makapitzi lacchixcuhuí̱n ixtatamakxtaka cquilhapá̱n ca̱chiquí̱n xlacata natamaktakalha ixborregoscán ca̱tzisní. ");
INSERT INTO topNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Y ni̱ para tacátzi̱lh la̱ ca̱lakata̱yachi cha̱tum ángel tí ma̱lakácha̱lh Dios. Xlacán stalanca tali̱lacahuá̱nalh ixli̱tlihueke Dios porque taranc tatu̱tako̱lh ca̱tzisní y tzúculh tatatlaná la̱ta tajicuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero amá ángel ca̱huánilh: ―Ni̱ cajicuántit, aquit cmini̱t cca̱huaniyá̱n laclá̱n tachihuí̱n ni̱ma̱ snu̱n ama li̱pa̱xahuá minacujcán y hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Nac Belén ixca̱chiquí̱n rey David lakahuani̱t jaé ca̱tzisní tí ama ca̱lakma̱xtuyá̱n, huá Mimpu̱chinacán Cristo tí kalhi̱pa̱nántit. ");
INSERT INTO topNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Capítit acxilá̱tit. Camá̱n ca̱huaniyá̱n la̱ nalakapasá̱tit, li̱tanksuitcani̱t tánchut y trami̱cani̱t ixpu̱hua̱ycán quitzistancaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Acxni tuncán tali̱lacahua̱nampá pu̱lhu̱hua ángeles xalac akapú̱n y tzúculh tatlí alabanzas ixtalakachixcuhuí Dios, ixtahuán: ");
INSERT INTO topNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Clakachixcuhui̱yá̱u ixli̱lanca Dios nac akapú̱n y nac ca̱quilhtamacú cca̱li̱pa̱xahuayá̱u cristianos tí ca̱lacsacni̱t li̱pa̱xáu ca̱litlá̱n natalatamá. ");
INSERT INTO topNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ixli̱puntzú hua̱k ángeles ta̱mparako̱lh nac akapú̱n y amá ixmaktakalhnani̱n borregos tara̱huánilh: ―Chí tuncán ca̱huí acxilá̱u tú qui̱taxtuni̱t nac Belén a ver para xli̱ca̱na tú quinca̱ma̱cxcatzi̱ní̱n Quimpu̱chinacán. ");
INSERT INTO topNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Xlacán lacapala ta̱lh nac Belén y xli̱ca̱na tatáka̱sli María y José, na̱ tá̱cxilhli amá skata trami̱cani̱t nac ixpu̱hua̱ycán quitzistancaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","A̱stá̱n tzúculh talacspi̱ta la̱ cha̱tum ángel ixca̱li̱ta̱chihui̱nani̱t amá skata. ");
INSERT INTO topNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y hua̱k tí takáxmatli ixtachihui̱ncán ni̱ tama̱kachákxi̱lh hua̱nchi chú ixtachihui̱nani̱t amá ixmaktakalhnaní̱n borregos. ");
INSERT INTO topNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María ixli̱puhuán ixnacú la̱ta tú ixqui̱taxtuni̱t, pero ni̱tí ixuaní huata xlá ixcatzí ixtalacapastacni. ");
INSERT INTO topNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Amá lacchixcuhuí̱n tatáspitli ní ixtahuila̱na ixborregoscán ixtalakachixcuhui̱ti̱lhá Dios ixtapa̱xcatcatzi̱ní la̱ ixma̱kantaxti̱ni̱t tú ca̱huánilh amá ángel ama ta̱cxila. ");
INSERT INTO topNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ixli̱tu̱má ixnati̱cún tama̱kantáxti̱lh la̱ ixtali̱smani̱ni̱t judíos tatlahuá xalakkahuasán skatá̱n y huili̱nica ixtacuhui̱ní Jesús la̱ ixuani̱t amá ángel tí lakpaxiá̱lhnalh María acxni ya̱ ixta̱ta̱yá itskata. ");
INSERT INTO topNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ixley Moisés ixli̱ma̱paksi̱nán, acxni nalakahuán cha̱tum skata cali̱nica Dios aktum li̱lakachixcuhui̱n xlacata nali̱pa̱xcatcatzi̱nicán ixtalakalhamá̱n. María y José táli̱lh Jesús nac lanca pu̱siculan xla Jerusalén y tama̱lácnu̱lh ama li̱scuja Dios. ");
INSERT INTO topNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Porque nac ixtapáksi̱t Moisés tatzokni̱t: “Xla̱huán actzu̱ kahuasa ni̱ma̱ nama̱lakahuaní cha̱tum pusca̱t, cama̱tunujca xlacata namacuaní Dios.” ");
INSERT INTO topNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xlacán talakachixcuhuí̱nalh la̱ ixli̱ma̱paksi̱nán Dios nalakachixcuhui̱cán, tla̱n ixmakni̱cán tantuy tantzásna̱t o tantuy lactzu pichón. ");
INSERT INTO topNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Amá quilhtamacú ixlama nac Jerusalén cha̱tum chixcú ixuanicán Simeón. Xlá tancs ixlama ixli̱pa̱huán Dios ixli̱hua̱k ixnacú ixkalhi̱ma Dios nama̱kantaxtí la̱ ixma̱lacnu̱ni̱t ama calakma̱xtú tí xalac Israel. Espíritu Santo ixlama nac ixnacú ");
INSERT INTO topNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","y huá ixma̱cxcatzi̱ni̱ni̱t xlacata ni̱ ixama ní hasta xní nali̱lakapasa ixlakastapu Cristo tí ixama ma̱lakachá Dios naca̱lakma̱xtú cristianos xalac Israel. ");
INSERT INTO topNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pi̱huá Espíritu Santo ma̱lacpuhuá̱ni̱lh Simeón caalh nac pu̱siculan amá chichiní y acxni cá̱cxilhli la̱ José y María ixtali̱mín Jesús xlacata natalakachixcuhuí Dios ixlacata Jesús la̱ huan ixley Moisés, ");
INSERT INTO topNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón chixli amá skata, pa̱xcatcatzí̱nilh Dios tú ixtlahuani̱t y chuné tzúculh chihui̱nán: ");
INSERT INTO topNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Quimpu̱chinacán Dios, tla̱ná quili̱makxtaka cacni̱lh li̱pa̱xáu porque ma̱kantaxti tú quima̱lacnu̱ni cama acxila. ");
INSERT INTO topNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Chí cli̱lakapasni̱t quilakastapu amá tí ma̱lakacha̱ni̱ta ca̱quilhtamacú naca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Huix li̱lhca̱ni̱ta naca̱cpuxcún hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Xlá la̱ ixtaxkáke̱t chichiní ama huan tí ama ca̱ma̱lacahua̱ní hua̱k cristianos xala ca̱quilhtamacú tí ni̱ talakapasá̱n. ¡Ama ma̱lakapasni̱nán lanca mintacuhui̱ní ixli̱ti̱lanca pu̱latama̱n Israel! ");
INSERT INTO topNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José y María huata acs tatá̱yalh ni̱ tama̱kachákxi̱lh hua̱nchi Simeón mákat ixli̱lacacha̱ni̱t ixlatáma̱t amá skata. ");
INSERT INTO topNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","A̱stá̱n Simeón ca̱sicuna̱tláhualh y chuné ta̱chihuí̱nalh ixna̱na amá skata: ―María, huix snu̱n pa̱t li̱puhuana porque jaé skata li̱lhca̱cani̱t nac Israel lhu̱hua ama taliakchakxa y talhtuja, pero na̱ lhu̱hua ama tali̱pa̱xahuá tata̱tla̱huán. Ni̱ caj maktum xlá ama ma̱lakapasni̱nán Dios, pero lhu̱hua ama talakmakán. ");
INSERT INTO topNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ni̱ caj maktum nac minacú huix pa̱t maklhcatzi̱ya la̱ cali̱makni̱ca espada porque lhu̱hua ni̱ ama ta̱cxilhputún acxni naca̱li̱ya̱huá cristianos tú tze̱k talacpuhuán nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nac pu̱siculan na̱ chilh cha̱tum pusca̱t tí tla̱n ixacxcatzí ixtalacpuhuá̱n Dios ixuanicán Ana, ixti̱cú ixuanicán Fanuel, y jaé chixcú tica̱ma̱lacatzúqui̱lh cha̱tum ko̱rutzi̱n ixuanicán Aser maká̱n quilhtamacú. Ana tamakáxtokli acxni snu̱ncu tzuma̱t ixuani̱t y ta̱latáma̱lh ixta̱kolú huata aktujún ca̱ta porque ni̱lh y chí snu̱n cha̱ttá ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ixkalhi̱yá ochenta y cuatro años la̱ta viuda ixtamakxtakni̱t. Yaj ixtaxtú nac pu̱siculan, ca̱cuhuiní y ca̱tzisní ixli̱scuja Dios tza̱pu ixkatxtaknán y ni̱ ixli̱makxtaka kalhtahuakaní Dios. ");
INSERT INTO topNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Acxni tuncán chilh Ana y pa̱xcatcatzí̱nilh Dios tú ixtlahuani̱t y tzúculh ca̱li̱ta̱chihui̱nán Jesús amá cristianos tí ixtakalhi̱ma̱na nac Jerusalén naca̱lakma̱xtú Cristo acxni namín. ");
INSERT INTO topNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José y María talakachixcuhui̱nanko̱lh nac pu̱siculan xla Jerusalén la ixli̱ma̱paksi̱nán Moisés, a̱stá̱n tatáspitli nac ixca̱chiqui̱ncán Nazaret, jaé ca̱chiquí̱n ixli̱tapaksí Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y juú tzúculh li̱pa̱xáu staca Jesús ixtiyama ma̱s li̱camama, y ixli̱skalala na̱ ixli̱tahuacá, y Dios siempre ixacxilhlacachín ixlatáma̱t. ");
INSERT INTO topNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","José y María ixtali̱smani̱ni̱t ca̱ta cá̱ta ixtá̱n talakachixcuhui̱nán xatacuhui̱ní pa̱xcua nac lanca pu̱siculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Acxni Jesús ma̱spútulh akcu̱tuy ca̱ta na̱ li̱nca nac xatacuhui̱ní pa̱xcua la̱ ixli̱smani̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amá tacuhui̱ní kantaxtuko̱lh, José y María pu̱tum tatáspitli ixca̱chiqui̱ncán Nazaret y ni̱ para caso tatláhualh xlacata Jesús ixtamakxtakni̱t nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Pues como hua̱k cristianos pu̱tum ixtataspita ixca̱chiqui̱ncán xlacán ixtapuhuán Jesús ixca̱ta̱mín ixamigos. Pero smalankán acxni tali̱kalasquínilh ixta̱pakánat ixli̱talakapasni, ");
INSERT INTO topNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ni̱ cha̱tum tí kalhtási̱lh. Huá xlacata tali̱táspitli nac Jerusalén xlacata natalacaputzá aná porque ixtaliakatuyún. ");
INSERT INTO topNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aktutu chichiní talacapútzalh y acxnicú taqui̱táka̱sli nac pu̱siculan. Jesús ixuí nac ixita̱tcán amá lakskalala lacchixcuhuí̱n tí ixtama̱sí ixtapáksit Moisés ixca̱kaxmatma y ixca̱kalasquiní tú ixcatzi̱putún. ");
INSERT INTO topNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xlacán ixtaca̱cní ixli̱skalala porque tancs ixkalhti̱nán. ¡Ixma̱ccha̱ní laclanca talacapa̱stacni ma̱squi actzu kahuasacú ixuani̱t! ");
INSERT INTO topNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ixnati̱cún acxni tá̱cxilhli tí ixca̱ta̱chihui̱nama ixkahuasacán a̱huata acs tatá̱yalh. María ixna̱na huánilh: ―Ti̱cu, ¿hua̱nchi chú quila̱tlahuani̱táu? Aquit y minti̱cú cca̱lacaputzani̱tán y xacca̱li̱puhuamá̱n para tú ixpa̱xtokni̱ta. ");
INSERT INTO topNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús ca̱kálhti̱lh: ―¿Hua̱nchi quila̱lacaputzáu a̱lacatunu? ¿Ni para tziná lacpuhuántit xlacata xactanu̱ma nac pu̱siculan ana ní quili̱tláhuat tú quili̱ma̱paksi̱ni̱t Quinti̱cú? ");
INSERT INTO topNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Xlacán ni̱ tama̱kachákxi̱lh ixtachihuí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","pero María ixli̱puhuán ixnacú la̱ta tú ixqui̱taxtú nac ixlatáma̱t ixkahuasa. Jesús ca̱ta̱taspitpá ixnati̱cún nac Nazaret y hua̱k ixca̱kaxmatní tú ixtahuaní catláhualh. ");
INSERT INTO topNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Lakasu̱t tzúculh tachixcuhuí, ixli̱skalala ma̱s y ma̱s ixli̱tahuacá cha̱li cha̱lí. Dios ixlakatí ixlatáma̱t y na̱ chuná hua̱k cristianos ixtali̱pa̱xahuá la̱ tancs ixlama. ");
INSERT INTO topNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nac Roma ixkalhí akcu̱quitzis ca̱ta la̱ta istzucuni̱t ma̱paksi̱nán emperador Tiberio César, nac Judea ixma̱paksi̱nán gobernador Poncio Pilato, nac Galilea ixma̱pakdi̱nán rey Herodes, nac Iturea y Traconite ixma̱paksi̱nán Felipe ixta̱cam Herodes y nac Abilinia ixma̱paksi̱nán Lisanias. ");
INSERT INTO topNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Nac Jerusalén xanapuxcun curas ixca̱huanicán Anás y Caifás. Na̱ huá jaé quilhtamacú acxni Juan ixkahuasa Zacarías ixlama nac desierto ana ní ni̱tí ixtalama̱na, Dios ma̱cxcatzí̱ni̱lh cali̱chihuí̱nalh la̱ ma̱lacatzuqui̱putún ixtapáksi̱t nac ixlatama̱tcán cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Xlá tzúculh lakatza̱lá ixquilhpa̱n kalhtu̱choko Jordán, ixca̱ma̱kalhchihui̱ní cristianos catalakxta̱páli̱lh ni̱ tla̱n ixlatama̱tcán y naca̱kmunucán xlacata Dios naca̱ma̱tzanke̱naní ixtala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chuná jaé kantáxtulh tú istzokni̱t nac Escrituras profeta Isaías ixlacata Juan: Nac desierto takaxmatí la̱ aktasá acxni ma̱kalhchihui̱ni̱nán cha̱tum chixcú: “Catacá̱xtit, tancs calatapá̱tit, ti̱tum catrapí̱tit ixtijia milatama̱tcán, pues mima ca̱lakpaxia̱lhnaná̱n Mimpu̱chinacán. ");
INSERT INTO topNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Namá tí ni̱ tali̱pa̱huán Dios tali̱tanú la̱ ca̱kalhpu̱lhma̱n, pero ama̱ca li̱ma̱tzamacán lactlá̱n tapuhuá̱n. Namá tí talactlancán tali̱tanú la̱ sipi y talhpá̱n, pero ama̱ca ca̱li̱ma̱ca̱xtumi̱cán lactlá̱n talacapastacni. Namá tí ni̱ tancs talama̱na tali̱tanú la̱ laklhkahuili tijia, pero ama̱ca ca̱ma̱tancsacán; na̱ tali̱tanú la̱ ca̱tliliqui tijia, pero ama̱ca ca̱ca̱tacscán. ");
INSERT INTO topNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y hua̱k cristianos xala ca̱quilhtamacú ama ta̱cxila amá chixcú tí ma̱lakacha̱ni̱t Dios naxoko̱nán ixtala̱kalhi̱ncán ixcamán.” ");
INSERT INTO topNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lhu̱hua cristianos tzúculh talakán Juan xlacata naca̱kmunú. Xlá chuné ixca̱ta̱chihui̱nán: ―¡Huixín la̱ xcananí̱n lu̱hua! ¿Ticu ca̱huanín para ta̱kmunuyá̱tit pa̱t taxtuniyá̱tit ta̱kxtakajni ni̱ma̱ talacatzuhui̱ma? ");
INSERT INTO topNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ma̱s ca̱macuaniyá̱n pu̱la̱ calakxta̱palí̱tit milatama̱tcán y cama̱sí̱tit xli̱ca̱na lapa̱nántit la̱ lactla̱n cristianos. ¿A poco puhuaná̱tit huixín ni̱tú ama ca̱pa̱xtoká̱n porque li̱tanu̱yá̱tit ixli̱talakapasni Abraham? Namá ni̱tú li̱macuán porque aquit tancs cca̱huaniyá̱n, Dios para ixlacásquilh tla̱n ca̱lakxta̱palí catu̱ya̱hua chíhuix y ixli̱talakapasni Abraham ca̱tlahuá. ");
INSERT INTO topNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Dios ca̱cxilhni̱t lhu̱hua cristianos la̱ quihui ni̱ma̱ yaj tú tali̱macuán; ixhacha ma̱kapu̱ya̱huani̱ttá ama ca̱ma̱xoko̱ní. Namá cristianos tí ca̱li̱macá̱n quihui ni̱ma̱ yaj tama̱stá tla̱n ixtahuácat nac ixlatama̱tcán ama ca̱tancá, y ama ca̱ma̱pú nac lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Acxni ixtakaxmata jaé tachihuí̱n xlacán ixtakalasquiní: ―¿Tucu quili̱tlahuatcán xlacata nactaxtuniyá̱u? ");
INSERT INTO topNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ixca̱kalhtí: ―Tí kalhí aktuy ixlhákat, cama̱squíhui̱lh aktum tí ni̱tú kalhí, amá tí kalhta̱xtuní ixtahuá cata̱huá̱yalh tí ni̱ kalhí tú nali̱huayán. ");
INSERT INTO topNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Makapitzi ixma̱lakaxoke̱naní̱n tumi̱n tí ixca̱li̱maca̱ncán lacsnú̱n talani̱t na̱ talákmilh Juan xlacata naca̱kmunú y takalasquínilh: ―Maestro, aquín, ¿tucu quili̱tlahuatcán xlacata natasí clakxta̱pali̱ni̱táu quilatama̱tcán? ");
INSERT INTO topNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Xlá ca̱kálhti̱lh: ―Ni̱ caca̱ma̱lakaxoké̱tit cristianos li̱huacá la̱ ca̱li̱ma̱paksi̱cani̱tántit. ");
INSERT INTO topNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","―¿Y aquín, tucu quili̱tlahuatcán? ―na̱ ixtakalasquiní makapitzi soldados. ―Ni̱tí camaklhtí̱tit xafuerza ixtumi̱n. Ni̱ caliakskahuinántit tí ni̱tú tlahuani̱t xlacata nama̱lacapu̱cán. Camaklhti̱nántit mintaskaucán y ni̱ calacputzátit la̱ nakalha̱naná̱tit ―ixca̱kalhtí Juan. ");
INSERT INTO topNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Hua̱k cristianos ixtakalhi̱ma̱na namín Cristo ca̱quilhtamacú tí naca̱lakma̱xtú, y makapitzi ixtapuhuán para Juan Cristo ixuani̱t, o ni̱ huá. ");
INSERT INTO topNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan acxcátzi̱lh tú ixtalacpuhuán y ca̱huánilh: ―Aquit cca̱liakmunuyá̱n chúchut, pero amajá chin cha̱tum tí snu̱n kalhí li̱tlihueke y aquit ni̱ para cma̱ta̱xtuca ixtasa̱cua nacuán tí nakatxcuta nama̱xtuní ixtanu̱nu. Xlá ama ca̱liakmunuyá̱n ixli̱tlihueke Espíritu Santo y ama ca̱li̱cxila mintapuhua̱ncán nac lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xlá lacpuhuani̱ttá la̱ ama ca̱ma̱pitzí cristianos, y naca̱tlahuá la̱ tí lacsaca ixtachaná̱n, ama ma̱xtú hua̱k palhma ni̱ma̱ ta̱lani̱t lactla̱n ixtachaná̱n y ama ma̱pú nac lhcúya̱t ni̱ma̱ ni̱cxni mixa, y xascarancua ixtachaná̱n ama ma̱quí nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Juan chuná jaé ixca̱ma̱kalhchihui̱ní cristianos y na̱ ixca̱huán tunu takalhchihuí̱n xlacata natama̱kachakxí la̱ Dios ixca̱ma̱lacnu̱nima ama ca̱lakalhamán naca̱lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Maktum la̱ta tzamacán li̱chihuínalh rey Herodes li̱huánilh xlacata ixta̱lama Herodías, amá pusca̱t ixya̱stá ixuani̱t ixta̱cha̱t Felipe. Herodes lhu̱hua tú ni̱ tla̱n ixtlahuani̱t, ");
INSERT INTO topNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","pero ma̱s li̱ma̱huácalh ixtala̱kalhí̱n porque la̱ta sí̱tzi̱lh tamácnu̱lh Juan nac pu̱la̱chi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","La̱ta ya̱ tú ixpa̱xtoka Juan xlá ixca̱kmunupu̱lá cristianos, y maktum Jesús na̱ lákalh xlacata na̱kmunucán. La̱ ta̱kmunuko̱lh Jesús tzúculh kalhtahuakaní Dios y acxni tuncán talácqui̱lh akapú̱n; ");
INSERT INTO topNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tási̱lh la̱ tá̱ctalh Espíritu Santo la̱ tantum paloma, ¡akchipako̱lh ixtalacapa̱stacni Jesús! Entonces takaxmáti̱lh jaé tachihuí̱n nac akpú̱n: ―Huix Quinkahuasa ni̱ma̱ clakalhamán y snu̱n cli̱pa̱xahuá la̱ ckalhi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús ixkalhí puxumacá̱u ca̱ta acxni ma̱tzúqui̱lh ixtascújut ca̱ma̱kalhchihui̱ní cristianos. Como ixpuhuancán ixti̱cú ixuanit José, xlá ixca̱kalhí xalakmaká̱n ixli̱talakapasni tí ixca̱ma̱lacatzuqui̱ni̱t y chuné ixca̱huanicán jaé lacchixcuhuí̱n: Ixti̱cu José ixuanicán Elí, ");
INSERT INTO topNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ixti̱cu Elí ixuanicán Matat, ixti̱cu Matat ixuanicán Leví, ixti̱cu Leví ixuanicán Melqui, ixti̱cu Melqui ixuanicán Jana, ixti̱cu Jana ixuanicán José, ");
INSERT INTO topNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ixti̱cu José ixuanicán Matatías, ixti̱cu Matatías ixuanicán Amós, ixti̱cu Amós ixuanicán Nahum, ixti̱cu Nahum ixuanicán Esli, ixti̱cu Esli ixuanicán Nagai, ");
INSERT INTO topNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ixti̱cu Nagai ixuanicán Maat, ixti̱cu Maat ixuanicán Matatías, ixti̱cu Matatías ixuanicán Semei, ixti̱cu Semei ixuanicán José, ixti̱cu José ixuanicán Judá. ");
INSERT INTO topNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ixti̱cu Judá ixuanicán Joana, ixti̱cu Joana ixuanicán Resa, ixti̱cu Resa ixuanicán Zorobabel, ixti̱cu Zorobabel ixuanicán Salatiel, ixti̱cu Salatiel ixuanicán Neri, ");
INSERT INTO topNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ixti̱cu Neri ixuanicán Melqui, ixti̱cu Melqui ixuanicán Adi, ixti̱cu Adi ixuanicán Cosam, ixti̱cu Cosam ixuanicán Elmodam, ixti̱cu Elmodam ixuanicán Er, ");
INSERT INTO topNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ixti̱cu Er ixuanicán Josué, ixti̱cu Josué ixuanicán Eliezer, ixti̱cu Eliezer ixuanicán Jorim, ixti̱cu Jorim ixuanicán Matat, ");
INSERT INTO topNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ixti̱cu Matat ixuanicán Leví, ixti̱cu Leví ixuanicán Simeón, ixti̱cu Simeón ixuanicán Judá, ixti̱cu Judá ixuanicán José, ixti̱cu José ixuanicán Jonán, ixti̱cu Jonán ixuanicán Eliaquim, ");
INSERT INTO topNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ixti̱cu Eliaquim ixuanicán Melea, ixti̱cu Melea ixuanicán Mainán, ixti̱cu Mainán ixuanicán Matata, ixti̱cu Matata ixuanicán Natán, ");
INSERT INTO topNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ixti̱cu Natán ixuanicán David, ixti̱cu David ixuanicán Isaí, ixti̱cu Isaí ixuanicán Obed, ixti̱cu Obed ixuanicán Booz, ixti̱cu Booz ixuanicán Salmón, ixti̱cu Salmón ixuanicán Naasón, ");
INSERT INTO topNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ixti̱cu Naasón ixuanicán Aminadab, ixti̱cu Aminadab ixuanicán Aram, ixti̱cu Aram ixuanicán Esrom, ixti̱cu Esrom ixuanicán Fares, ixti̱cu Fares ixuanicán Judá, ");
INSERT INTO topNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ixti̱cu Judá ixuanicán Jacob, ixti̱cu Jacob ixuanicán Isaac, ixti̱cú Isaac ixuanicán Abraham, ixti̱cú Abraham ixuanicán Taré ixti̱cu Taré ixuanicán Nacor, ");
INSERT INTO topNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ixti̱cu Nacor ixuanicán Serug, ixti̱cu Serug ixuanicán Ragau, ixti̱cu Ragau ixuanicán Peleg, ixti̱cu Peleg ixuanicán Heber, ixti̱cu Heber ixuanicán Sala, ");
INSERT INTO topNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ixti̱cu Sala ixuanicán Cainán, ixti̱cu Cainán ixuanicán Arfaxad, ixti̱cu Arfaxad ixuanicán Sem, ixti̱cu Sem ixuanicán Noé, ixti̱cu Noé ixuanicán Lamec, ");
INSERT INTO topNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ixti̱cu Lamec ixuanicán Matusalén, ixti̱cu Matusalén ixuanicán Enoc, ixti̱cu Enoc ixuanicán Jared, ixti̱cu Jared ixuanicán Mahalaleel, ixti̱cu Mahalaleel ixuanicán Cainán, ");
INSERT INTO topNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ixti̱cu Cainán ixuanicán Enós, ixti̱cu Enós ixuanicán Set, ixti̱cu Set ixuanicán Adán, y Adán huá namá chixcú tí xla̱huán titláhualh Dios ca̱quilhtamadú. ");
INSERT INTO topNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","La̱ maklhti̱nanko̱lh Jesús ixli̱tlihueke Espíritu Santo tácutli nac kalhtu̱choko Jordán y ma̱cxcatzí̱ni̱lh caalh latamá lacatum pu̱latama̱n nac Judea ní ni̱tú ixlama cristianos nac desierto. ");
INSERT INTO topNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aná latáma̱lh ti̱puxum chichiní y ni̱ para makstum kalhuá̱nalh tahuá amá quilhtamacú, pero acxni tzincsli tlajaná tzúculh li̱cxila ixtapuhuá̱n para tla̱n nama̱tlahuí talakalhí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","y huánilh: ―Para xli̱ca̱na huix Ixkahuasa Dios y kalhi̱ya li̱tlihueke, jaé chíhuix simi̱ta catlahua. ");
INSERT INTO topNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Xlá kálhti̱lh: ―¡Tó̱! Pues nac Escrituras huan: “¡Ni̱ huata simi̱ta tla̱n li̱latamá cha̱tum chixcú, na̱ tamaclacasquiní nali̱kalhkasa ixli̱stacni ixli̱ma̱paksi̱n Dios!” ");
INSERT INTO topNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A̱stá̱n tlajaná tá̱alh Jesús nac ixakstí̱n aktum lanca sipi y caj puntzú li̱ma̱lacahua̱ni̱ko̱lh hua̱k pu̱ma̱paksín xala ca̱quilhtamacú y la̱ li̱cá̱cni̱t tahuila̱na. ");
INSERT INTO topNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y amá tlajaná huánilh: ―Aquit tla̱n cmacama̱xqui̱yán li̱tlihueke naca̱ma̱paksi̱ya jaé laclanca pu̱ma̱paksí̱n y naca̱li̱pa̱xahuaya, porque aquit quimacama̱xqui̱cani̱t la̱ta tú huí ca̱quilhtamacú, y tla̱n cma̱xquí tí clacasquín. ");
INSERT INTO topNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pero tamaclacasquiní naquintatzokostaniya quilakachixcuhuiya la̱ mimpu̱chiná, y hua̱k mila nahuán namá pu̱ma̱paksí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús na̱ kalhti̱pá: ―Catake̱nu ní cyá tlajaná, porque nac Escrituras huan: “Huata Dios Mimpu̱chiná calakachixcuhui, y huata huá cakaxpatni tú li̱ma̱paksi̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A̱stá̱n tlajaná ta̱ampá nac ixakstí̱n xatorre lanca pu̱siculan xla Jerusalén, y huánilh: ―Para xli̱ca̱na huix ixkahuasa Dios capa̱tasta la̱ta ixli̱ta̱lhmá̱n jaé pu̱siculan. ");
INSERT INTO topNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pues nac Escrituras tatzokni̱t: Dios ama ca̱ma̱lakachá ixángeles natamaktakalhá̱n, ");
INSERT INTO topNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","y natali̱chipapa̱xtoká̱n ixmacán xlacata ni̱ nata̱cuacaya y natalaxtapa̱ya nac ca̱chihuixni. ");
INSERT INTO topNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús kálhti̱lh: ―Pero nac Escrituras tatzokni̱t: “Mimpu̱chiná Dios ni̱cxni chu̱ta cali̱kalhkamá̱nanti xlacata natlahuá milacata tú ni̱ macuaniyá̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Como amá tlajaná ni̱ cátzi̱lh la̱ nama̱tlahuí tala̱kalhí̱n Jesús li̱mákxtakli maka̱s quilhtamacú ni̱ ta̱rá̱slakli. ");
INSERT INTO topNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Como Jesús ixkalhí ixli̱tlihueke Espíritu Santo táspitli nac Galilea y tzúculh ca̱ma̱kalhchihui̱ní cristianos nac sinagogas ni̱ma̱ ixtahuila̱na ca̱chiquí̱n, y hua̱k ixtalakatí takaxmata ixtachihuí̱n. Ni̱ para maka̱s quilhtamacú tzucuca li̱chihui̱nancán ixtascújut hua̱k ixli̱ti̱lanca amá pu̱latama̱n Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús alh nac Nazaret ixca̱chiquí̱n ní itstacni̱t. Sábado acxni ni̱tí itscuja tánu̱lh nac sinagoga la̱ ixli̱smani̱ni̱t. Ixli̱puntzú tá̱yalh xlacata nali̱kalhtahuaká ixtachihuí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ma̱xqui̱ca ixlibro profeta Isaías, ma̱lácqui̱lh amá libro y li̱kalhtahuákalh lacatum ní chuné ixtatzokni̱t: ");
INSERT INTO topNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Quintalacapa̱stacni akchipani̱t ixtalacapa̱stacni Quimpu̱chinacán, quilacsacni̱t nacca̱huaní li̱pa̱xáu lactlá̱n y tancs takalhchihuí̱n amá ni̱ lactali̱pa̱u cristianos. Quima̱lakacha̱ni̱t nacca̱ma̱xquí li̱camama tí snu̱n talakaputzá nac ixnacujcán. Quima̱lakacha̱ni̱t nacca̱huaní la̱ natataxtuní amá cristianos tí la̱ tachí̱n ca̱kalhí ixtala̱kalhi̱ncán. Tí lakatzí̱n talama̱na tla̱n nacca̱ma̱lacahua̱ní; tí ta̱kxtakajnán cama ca̱makapa̱xahuá porque ama tataxtuní. ");
INSERT INTO topNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Cama ca̱ma̱cxcatzi̱ní cristianos la̱ Dios ama ma̱lacatzuquí quilhtamacú ca̱lakalhamán tí tali̱pa̱huán nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","La̱ li̱kalhtahuakako̱lh amá libro ma̱lakacháhualh y ma̱xqui̱pá tí ixcuentajnán nac sinagoga; a̱stá̱n curucs tahui. Pero como hua̱k cristianos acs ixtalaca̱nini̱t ");
INSERT INTO topNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","xlá chuné ca̱ta̱chihuí̱nalh: ―Nac milacati̱ncán chí kantaxtuni̱t tú cca̱li̱kalhtahuakanín nac Escrituras. ");
INSERT INTO topNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hua̱k amá cristianos talakáti̱lh la̱ ca̱ta̱chihuí̱nalh Jesús porque ni̱ ixtacatzí nicu ixli̱ma̱kachakxí laclanca talacapa̱stacni ni̱ma̱ ixca̱huaní. Makapitzi tzúculh tara̱huaní: ―¿Ni̱ huá jaé chixcú ixkahuasa José? ");
INSERT INTO topNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús ca̱huánilh: ―Aquit ccatzí amá̱n quila̱huaniyá̱u amá tachihuí̱n: “Para huix cuchi̱ná na̱ cama̱ksa̱ni̱ca mi̱cstu.” Y na̱ amá̱n quila̱huaniyá̱u: “Aquín ccatzi̱yá̱u la̱ ca̱tlahuani̱ta mintascújut nac Capernaum, para xli̱ca̱na, chí na̱ caca̱tlahua mintascújut juú nac mimpu̱latama̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesús ca̱huaniko̱lh: ―Aquit cama ca̱huaniyá̱n la̱ qui̱taxtú, ni̱ huí cha̱tum profeta tí li̱pa̱huancán y lakalhamancán nac ixpu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ca̱ksántit amá quilhtamacú acxni latáma̱lh profeta Elías, juú nac Israel ni̱ sé̱nalh aktutu ca̱ta a̱íta̱t y milh lhu̱hua tatzíncsnit ixli̱ti̱lanca pu̱latama̱n. Lhu̱hua viudas xalac Israel ni̱ ixtakalhí tú natahuá, ");
INSERT INTO topNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero Dios ni̱ ma̱lakácha̱lh Elías caca̱maktá̱yalh. Xlá ma̱lakáchalh amá mákat ca̱chiquí̱n huanicán Sarepta ixli̱tapaksí pu̱latama̱n Sidón, camaktá̱yalh cha̱tum viuda xala aná. ");
INSERT INTO topNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na̱ ca̱ksántit acxni latáma̱lh profeta Eliseo, xlá ma̱ke̱nú̱nilh ixlepra tá̱tat amá xala mákat chixcú xalac Siria ixuanicán Naamán, y juú nac Israel na̱ ixtalama̱na lhu̱hua ta̱tatlaní̱n tí ixtakalhí lepra tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Acxni takáxmatli jaé tachihuí̱n hua̱k tí ixtatanu̱ma̱na nac sinagoga tasi̱tzi̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Tatá̱yalh, tachípalh Jesús y táli̱lh nac quilhapa̱n ca̱chiquí̱n. Como amá ca̱chiquí̱n ixuí nac aktum sipi, táli̱lh nac aktum lacatalhpa̱n; aná ixtatanlakli̱mputún xlacata natamakní. ");
INSERT INTO topNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús ca̱ma̱ktzánke̱lh y pasá̱rlalh ixlacati̱ncán y alh a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús cha̱lh nac Capernaum jaé ca̱chiquí̱n ixli̱tapaksí Galilea, y acxni hua̱k ixjaxcán xlá alh ca̱ma̱kalhchihui̱ní cristianos nac sinagoga. ");
INSERT INTO topNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Xlacán ni̱ ixtacatzí tú natahuán acxni ixtakaxmata la̱ ixmasí ixtalacapa̱stacni porque acxni ixchihui̱nán xli̱ca̱na ixma̱ccha̱ní ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nac sinagoga ixtanu̱ma cha̱tum chixcú ni̱ma̱ ixmakatlajani̱t ixespíritu tlajaná, y tzúculh ma̱ktasí Jesús: ");
INSERT INTO topNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Jesús xalac Nazaret, ¡capit a̱lacatunu! Huix tani̱ta quila̱lactlahuayá̱u porque aquit clakapasá̱n y ccatzí xlacata Dios lacsacni̱tán nali̱scuja. ");
INSERT INTO topNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús ca̱tasi̱tzi ta̱chihuí̱nalh: ―¡Acs cata̱ya, tlajaná, y camactaxtu namá chixcú! Amá ixespíritu tlajaná ma̱kuíti̱lh amá chixcú y tama̱chá ca̱tiyatni, pero mactáxtulh y yaj ma̱s ma̱kxtakájni̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hua̱k cristianos tajicuanko̱lh, ixtara̱huaní: ―¿Tucu yá li̱tlihueke kalhí ixtachihuí̱n jaé chixcú? ¡Ca̱cxílhtit la̱ kalhí li̱tlihueke ca̱ma̱paksí tlajananí̱n y tataxtú! ");
INSERT INTO topNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tú ixtlahuani̱t Jesús tzucuca li̱chihui̱nancán hua̱k lactzú ca̱chiquí̱n xala amá pu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús tá̱yalh y táxtulh nac sinagoga y alh nac ixchic Simón. Makapitzi taxcalánilh Jesús cama̱ksá̱ni̱lh ixpuhuiticha̱t Simón porque ixta̱tatlá ixkalhí lhu̱hua palha lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús lákalh ní ixmá y li̱ma̱paksí̱nalh camákxtakli amá lhcúya̱t y xli̱ca̱na caj la̱ ni̱tú take̱nú̱nilh. Ixli̱puntzú tá̱qui̱lh amá cha̱t y tzúculh tlahuá tú naca̱ta̱huá. ");
INSERT INTO topNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Acxni smalankánalh lhu̱hua tí ixtakalhí ti̱pa̱katzi tá̱tat y tasipá̱ni̱t ca̱li̱minca ní ixuí Jesús. Xlá cha̱tunu ca̱li̱macxámalh ixmacán y hua̱k ca̱ma̱ksa̱ni̱ko̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Makapitzi tlajananí̱n tí ca̱tamácxtulh Jesús ta̱cxcátzi̱lh ixquilhtzúcut y tzúculh tama̱ktasí: ―¡Huix Ixkahuasa Dios! Pero xlá ixca̱ma̱quilhacslí ni̱ catachihuí̱nalh porque xlacán ixtacatzí xlacata Jesús Cristo ixuani̱t tí ixmini̱t ca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","La̱ta ya̱ itxkaká amá ca̱tzisní Jesús alh ixquilhpa̱n ca̱chiquí̱n xlacata ni̱tí na̱cxila, pero lhu̱hua cristianos talacapútzalh. Acxni taqui̱táka̱sli tahuánilh catamákxtakli nac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Xlá ca̱huánilh: ―Na̱ tamaclacasquiní nacca̱huaní xa̱makapitzi tí talama̱na a̱lacatunu ca̱lacchiquí̱n Dios ca̱ma̱paksi̱putún cristianos. Huá namá quintascújut quili̱macamincani̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Chuná amá Jesús ixakchihui̱nantapu̱lí nac itsinagogajcán judíos ni̱ma̱ ixtahuila̱na nac ca̱lacchiquí̱n ixtali̱tapaksí Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Maktum quilhtamacú acxni Jesús ixakchihui̱nama ixquilhtu̱n chúchut huanicán Genesaret támilh lhu̱hua cristianos takaxmata la̱ ixli̱chihui̱nán Dios, hasta ixtalacxquití. ");
INSERT INTO topNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Xlá láca̱lh ixquilhtu̱n chúchut y cá̱cxilhli aktuy barco ni̱tí ixtaju̱ma, ixpu̱chinaní̱n ixtacutni̱t ixtalakacheke̱ma̱na istza̱lhcán aná lacatzú. ");
INSERT INTO topNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús táju̱lh nac aktum barco ixpu̱chiná ixuanicán Simón, y huánilh cali̱lh tziná lakamákat; aná curucs tahui y tzúculh ca̱ma̱kalhchihui̱ní cristianos la̱ta taju̱ma nac barco. ");
INSERT INTO topNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Acxni akchihui̱nanko̱lh huánilh Simón: ―Cali̱pi mibarco ma̱s xapu̱lhmá̱n y aná camuju mintza̱lh xlacata nachipaya tamakní. ");
INSERT INTO topNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón kálhti̱lh: ―Maestro, aktum tzisní cscujni̱táu cmuju̱ni̱táu quintza̱lhcán y ni̱tú cchipani̱táu, pero como huix quili̱ma̱paksí̱pa̱t cama li̱cxilhpará, a ver tucu tahuacá. ");
INSERT INTO topNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Simón múju̱lh istza̱lh y tahuácalh lhu̱hua tamakní hasta ixtalacaxti̱tputún la̱ta istzamá. ");
INSERT INTO topNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Como snu̱n istzincán ca̱tasánilh xa̱makapitzi ixcompañeros tí ixtataju̱ma̱na nac xa̱ktum barco xlacata catámilh tamakta̱yá. Acxni táchilh xlacán na̱ tzúculh tama̱tzamá ixbarcojcán, y caj puntzú tatatzámalh amá aktuy barco hasta ixtata̱ktzi̱putún. ");
INSERT INTO topNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Acxni Simón ácxilhli tú ixtlahuani̱t Jesús ixacstu li̱ma̱xánalh ni̱ tla̱n ixkásat; tuncán tatzokostánilh, chuné kalhapálalh: ―Quimpu̱chiná, ni̱ lá cta̱talacastucá̱n hasta cma̱xanán la̱ clakayá̱n porque aquit ckalhí tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón chú ixchihui̱nani̱t porque ixmaka̱klhani̱t la̱ ixca̱ma̱chipi̱ni̱t Jesús lhu̱hua tamakní, y xa̱makapitzi na̱ chuná ixtajicuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ixlakkahuasan Zebedeo, Jacobo y Juan, ixcompañeros Simón na̱ ixca̱maka̱klhani̱t tú ixtali̱lacahua̱nani̱t. Jesús huanipá Simón: ―Ni̱ cajícuanti, porque chí camá̱n ma̱si̱niyá̱n la̱ ca̱chipacán cristianos tí ta̱ktzanka̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Amá chakananí̱n acxni talí̱cha̱lh ixbarcojcán nac ixquilhtú̱n ta̱kxtakmákalh la̱ta tú ixtakalhí y tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Maktum quilhtamacú nac aktum ca̱chiquí̱n ní cha̱lh Jesús ixlama cha̱tum chixcú ixkalhí lepra tá̱tat. Acxni ácxilhli Jesús xlá ma̱lacatzúhui̱lh y tatzokostánilh hasta talacátalh ca̱tiyatni y chuné akaxcúlilh Jesús: ―Quimpu̱chiná, ccatzí tla̱n quincuchi̱ya para lacasquina caquima̱ksa̱ni. ");
INSERT INTO topNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús li̱macxámalh ixmacán y kálhti̱lh: ―Clacasquín, y ca̱ksá̱nanti tuncán. Huata chihui̱nanko̱lh Jesús amá chixcú tuncán mákxtakli ixtá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A̱stá̱n akastacyá̱hualh ni̱tí cali̱ma̱kalhchihuí̱ni̱lh tí ixma̱ksa̱ni̱ni̱t, y li̱ma̱páksi̱lh tú ixli̱tláhuat: ―Capit putzaya cha̱tum cura tí nama̱luloka makxtakni̱tán mintá̱tat, y cama̱sta li̱lakachixcuhuí̱n la̱ huani̱t Moisés mili̱ma̱sta̱tcán huixín tí ca̱kalhi̱yán namá tá̱tat, y xa̱huá chuná cati̱huá na̱cxilá̱n yaj kalhiyá̱n tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero la̱ta ixli̱ama quilhtamacú ma̱s y ma̱s ixli̱chihui̱nancán amá pu̱latama̱m tú ixtlahuá Jesús y ma̱s ixtali̱pa̱huán. Na̱ chuná ma̱s y ma̱s ixtali̱tahuacá cristianos tí ixtamín takaxmata ixtachihuí̱n y xlacata naca̱ma̱ke̱nu̱ní ixta̱tatcán. ");
INSERT INTO topNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús tza̱pu tza̱pu ixán ana ní ni̱ lama cristiano xlacata tla̱n nakalhtahuakaní Dios. ");
INSERT INTO topNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Maktum quilhtamacú acxni Jesús ixca̱ma̱kalhchihui̱ni̱ma cristianos na̱ ixtamini̱t makapitzi ixma̱kalhtahuake̱nacán judíos y ixma̱kantaxti̱naní̱n ixley Moisés xalac Galilea, Judea y Jerusalén. Dios li̱mákxtakli Jesús caca̱li̱ma̱lacahuá̱ni̱lh ixli̱tlihueke pues ca̱ma̱ksá̱ni̱lh cristianos tí ixta̱tatlá. ");
INSERT INTO topNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ixli̱puntzú na̱ táchilh pu̱tum lacchixcuhuí̱n ixtacucali̱mín nac ixcamilla cha̱tum chixcú tí ni̱ lá ixtla̱huán ixlaclu̱nchu̱ni̱t. Xlacán ixtatanu̱putún xlacata natatramí ixta̱tatlacán ixlacatí̱n Jesús y nama̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero como snu̱n istzamacán ni̱ lá tatánu̱lh mejor tatá̱cxtulh nac ixaksti̱n chiqui, tama̱ke̱nú̱nilh ti̱tzu̱ xateja y aná talacmá̱cti̱lh amá ta̱tatlá y tamá̱pi̱lh lihua ní ixyá Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús ma̱kachákxi̱lh amá lacchixcuhuí̱n xli̱ca̱na ixtali̱pa̱huán ixtachihuí̱n huá li̱huánilh amá ta̱tatlá: ―Hua̱k mintala̱kalhí̱n aquit cma̱tzanke̱naniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Amá fariseos y ixma̱kalhtahuake̱nacán judíos tzúculh tara̱huaní: “¿Ticu namá chixcú tí li̱kalhkama̱nama ta̱ra̱lacata̱qui̱ma Dios? Juú ca̱quilhtamacú ni̱ huí cristiano tí tla̱n ma̱tzanke̱nán tala̱kalhí̱n huata Dios tla̱n ma̱tzanke̱nán.” ");
INSERT INTO topNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús acxcátzi̱lh tú tze̱k ixtalacpuhuama̱na y chuné ca̱ta̱chihuí̱nalh: ―¿Hua̱nchi puhuaná̱tit ckalhkama̱nama? ");
INSERT INTO topNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Quila̱huaníu, ¿tucu ma̱s tuhua ma̱kantaxti̱cán, huanicán cha̱tum chixcú: “Hua̱k mintala̱kalhí̱n cma̱tzanke̱naniyá̱n”, o huanicán: “Cata̱qui, casacti mincamilla y catlá̱huanti”? ");
INSERT INTO topNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Aquit Xatalacsacni Chixcú camá̱n ca̱li̱ma̱lacahua̱ni̱yá̱n ixli̱tlihueke quintachihuí̱n: para cma̱ksa̱ní jaé chixcú ni̱ lá huaná̱tit ni̱ ckalhí li̱tlihueke cma̱tzanke̱nán tala̱kalhí̱n ca̱quilhtamacú. Jesús huánilh amá chixcú tí ixta̱tatlá: ―Aquit cli̱ma̱paksi̱yá̱n cata̱qui, casacti mincamilla y capit nac mínchic. ");
INSERT INTO topNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Amá chixcú tuncán aksá̱nalh, tá̱qui̱lh, sacli ixcamilla ní ixli̱mincani̱t y alh nac ixchic pa̱xcatcatzi̱niti̱lhá ixli̱tlanca Dios la̱ ixaksa̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hua̱k tí tá̱cxilhli la̱ cúchi̱lh Jesús amá chixcú ixtaca̱cní ixtascújut hasta tajicuanko̱lh y tzúculh tapa̱xcatcatzi̱ní ixli̱lanca Dios la̱ ixca̱ma̱lacahua̱ni̱ni̱t. Ixtahuán: ―Jaé quilhtamacú acxilhni̱táu laclanca tascújut. ");
INSERT INTO topNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A̱stá̱n Jesús táxtulh amá ca̱chiquí̱n y ta̱tánoklhli cha̱tum chixcú ixma̱lakaxoke̱na tumi̱n huanicán Leví; xlá curucs ixuí ana ní ixma̱taji̱nán. Jesús huánilh: ―Huix na̱ caquintakoke ana ní cama an. ");
INSERT INTO topNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví tuncán tá̱yalh, akxtakuíli̱lh la̱ta tú ixkalhí y na̱ takókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ni̱ alh lhu̱hua chichiní tláhualh aktum fiesta ixlacata Jesús. Xlá lakxtum ca̱ta̱huá̱yalh lhu̱hua ixma̱lakaxoke̱naní̱n tumin y lhu̱hua cristianos tí ni̱ ixtama̱kantaxtí ixley Moisés. ");
INSERT INTO topNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Makapitzi ixma̱kalhtahuake̱nacán judíos y fariseos acxni tá̱cxilhli tí ixca̱ta̱hua̱yama Jesús tzúculh tali̱chihui̱nán y tahuánilh ixdiscípulos: ―¿Hua̱nchi mima̱kalhtahuake̱nacán y huixín lakxtum ca̱ta̱hua̱yaná̱tit ixma̱lakaxoke̱naní̱n tumi̱n y namá ixtlahuananí̱n tala̱kalhí̱n tí ni̱ tama̱kantaxtí ixley Moisés? ");
INSERT INTO topNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ca̱huánilh: ―Ni̱ tamaclacasquín doctor tí tapuhuán ni̱ ta̱tatlá y tla̱n talama̱na, huata tamaclacasquín cuchi̱ná tí takalhí tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aquit cca̱lakmini̱t tí tacatzí takalhí tala̱kalhí̱n xlacata natalakxta̱palí ixlatama̱tcámn, y ni̱ cca̱lakmini̱t tí tla̱n talama̱na tapuhuán. ");
INSERT INTO topNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Makapitzi na̱ takalasquínilh: ―¿Hua̱nchi tí takaxmatni̱t tú ca̱li̱ma̱páksi̱lh Juan Bautista y na̱ chuná fariseos tza̱pu takatxtaknán xlacata ma̱s tla̱n natakalhtahuakaní Dios y tí huix takokeyá̱n tahua̱yán catu̱ya̱huá quilhtamacú? ");
INSERT INTO topNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ca̱kálhti̱lh: ―Quila̱huaníu, ¿puhuanátit huixín mini̱ní natakatxtaknán tí ca̱huanicani̱t natá̱n nac aktum pu̱tamakaxtokni mientras aná ca̱ta̱lahui xalí̱i̱t kahuasa? Ni̱ capuhuántit xlacata amá kahuasa nama̱tla̱ní tí nakatxtaknán y ni̱ nahua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero nachá̱n quilhtamacú nalakó fiesta y amá kahuasa naán a̱lacatunu, na̱ chuná la̱ aquit cama akspulán, entonces quidiscípulos na̱ natakatxtaknán ma̱squi ni̱tí caca̱li̱ma̱páksi̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesús ca̱huanipá jaé takalhchihuí̱n: ―Cha̱tum cristiano ni̱ mini̱ní nachucú actzu̱ sa̱sti lhákat, la̱ sa̱sti quintama̱sí̱n, y li̱lakuilí aklhchu̱ ixlháka̱t la̱ ixley Moisés; porque entonces pá̱xcat tlahuá sa̱sti ixlháka̱t ni̱ma̱ kalhí y ni̱tú li̱macuán porque actzu̱ sa̱sti lháka̱t ni̱ lá tla̱n ta̱taxtokó namá xa̱klhchu̱ ixlháka̱t. ");
INSERT INTO topNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chuná li̱tum ni̱ mini̱ní muju̱cán sa̱sti pulque acxni tlihuekema nac aklhchu̱ ixmakxu̱hua borrego porque namá sa̱sti pulque tla̱n ma̱pa̱panká laklhchu̱ ixmakxu̱hua borrego y acxtum talaktzanká. ");
INSERT INTO topNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Huá xlacata siempre mini̱ní muju̱cán sa̱sti pulque nac sa̱sti ixmakxu̱hua borrego xlacata acxtum nata̱tatlihueklha y nata̱ta̱yaní. ");
INSERT INTO topNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chí cca̱huaniyá̱n amá tí kalhua̱nán pulque ni̱ma̱ maká̱n tlihuekeni̱t acxni kalhua̱nán xasa̱sti ni̱ lakatí porque cati̱huá huan: “Pulque ni̱ma̱ maká̱n tlihuekeni̱t ma̱s tla̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Maktum quilhtamacú acxni ixli̱huancán tí nascuja, Jesús ixca̱ta̱tla̱huama ixdiscípulos nac ixpu̱chancan trigo. Xlacán tápuxli ixtahuácat trigo tzúculh tali̱paksa ixmacancán xlacata natahuani̱ní ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Makapitzi fariseos tí scarancua ixtama̱kantaxtí ixley Moisés ca̱ma̱nóklhulh y tahuánilh Jesús: ―¿Hua̱nchi scujá̱tit jaé quilhtamacú acxni ni̱tú quili̱tlahuatcán? ");
INSERT INTO topNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús ca̱lacati̱tá̱yalh ixdiscípulos y ca̱huánilh amá fariseos: ―¿A poco amá̱n quila̱huaniyá̱u ni̱ li̱kalhtahuakani̱tántit tú titláhualh rey David maktum quilhtamacú acxni ca̱tá̱tzincsli ixcompañeros? ");
INSERT INTO topNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Mili̱catzi̱tcán xlacata rey David tánu̱lh nac ixpu̱siculan Dios y ca̱tíyalh tasicuna̱tlau simita ni̱ma̱ huata curas ixca̱li̱makxtakcán natahuá. Xlá tzúculh li̱hua̱yán y na̱ ca̱tá̱hualh ixcompañeros tí ixtatakokeni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesús ca̱huaniko̱lh: ―Xa̱huá, mili̱catzi̱tcán xlacata aquit Xatalacsacni Chixcú y Dios quimacama̱xqui̱ni̱t jaé chichiní, y tla̱n tatlahuá cristianos tú talacasquín para aquit ni̱ cli̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Maktum quilhtamacú acxni ixjaxcán Jesús ixca̱ma̱kalhchihui̱ni̱ma cristianos nac aktum sinagoga y aná ixtanu̱ma cha̱tum chixcú itsca̱cko̱ni̱t ixpakca̱na̱ ixmacán. ");
INSERT INTO topNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","La̱ta maka̱sa quilhtamacú makapitzi ixma̱kalhtahuake̱nacan judíos y fariseos ixtatzucuni̱t tascalí Jesús para nama̱ksa̱ninán acxni ixli̱huancán tí nascuja, y chuná tla̱n natama̱lacapú. ");
INSERT INTO topNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús hua̱k ixcatzí tú ixtalaclhca̱nini̱t amá lacchixcuhuí̱n huá li̱huánilh amá chixcú tí ixmacata̱tatlá: ―Cata̱ya xlacata hua̱k nata̱cxilá̱n. Xlá tá̱yalh y lákalh la̱ li̱ma̱páksi̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Y ca̱huánilh amá lacchixcuhuí̱n tí ixtascalima̱na: ―Quila̱kalhtí̱u tú cama ca̱kalasquiniyá̱n: ¿Tucu ma̱s macuán tlahuacán jaé quilhtamacú acxni li̱huancán tí nascuja, tú tla̱n, o tú ni̱ tla̱n? ¿Lakma̱xtunicán ixli̱stacni cha̱tum cristiano, o li̱makxtakcán cani̱lh? ");
INSERT INTO topNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesús acs ca̱laca̱niko̱lh amá tí ixtatanu̱mana nac sinagoga y li̱ma̱páksi̱lh amá chixcú: ―Castonkti mimacán. Huata stonkli ixmacán tuncán caj la̱ ni̱tú tatzámalh ixli̱hua y tla̱n aksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amá lacchixcuhuí̱n li̱cuánit tasí̱tzi̱lh y tzúculh tali̱chihui̱nán tucu tla̱n natatlahuaní Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Maktum quilhtamacú Jesús talacá̱cxtulh aktum sipi xlacata nakalhtahuaká y aná kalhtahuakánilh Dios aktum tzisní. ");
INSERT INTO topNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Acxni xkákalh ca̱tasánilh makapitzi lacchixcuhuí̱n tí siempre ixtatakokeni̱t y ca̱lácsacli cha̱cu̱tuy ca̱li̱ma̱pa̱cúhui̱lh apóstoles. ");
INSERT INTO topNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jaé cha̱cu̱tuy apóstoles tí ca̱lí̱lhca̱lh chuné ixcahuanicán: Simón, pero Jesús li̱ma̱pa̱cúhui̱lh Pedro, Andrés ixta̱cam Simón, Jacobo y Juan, Felipe, Bartolomé, ");
INSERT INTO topNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo ixkahuasa Alfeo, Simón, jaé chixcú xapu̱lh ixca̱ta̱lapu̱lá pu̱tum tí ixtali̱tapa̱cuhuí cananistas, ");
INSERT INTO topNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ixta̱cam Jacobo y xa̱cha̱tum Judas Iscariote tí a̱stá̱n macamá̱sta̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","A̱stá̱n Jesús ca̱ta̱talacá̱ctalh ixapóstoles amá sipi y tatá̱yalh lacatum ní ca̱xtum tziná pues lhu̱hua cristianos xalac Judea, Jerusalén y hasta tí ixtalama̱na ixquilhtu̱n pupunú nac ca̱chiquí̱n ixca̱huanicán Tiro y Sidón, ixtamini̱t takaxmata ixtachihui̱n Jesús, y makapitzi ixtamín porque ixtalacasquín caca̱ma̱ksá̱ni̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y na̱ ixca̱ma̱ksa̱ní tí ixca̱makatlajani̱t tlajananí̱n ca̱ma̱kxtakajní ixmacnican cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na̱ chuná ni̱ caj cha̱tum ixma̱lacatzuhuí xlacata namacxamá porque xlá ixkalhí li̱tlihueke nac ixmacni y amá ta̱tatlaní̱n tí tamacxámalh hua̱k ta̱ksá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús acs ca̱lacá̱cxilhli hua̱k ixdiscípulos tí ixtatakoké y ca̱huánilh: ―Capa̱xahuátit ni̱ ca̱katuyúntit huixín tí li̱ta̱yayá̱tit huí tú ca̱tzanka̱niyá̱n nac minacujcán pues la̱ jaé tí Dios lakatí ca̱maklhti̱nán nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Capa̱xahuátit ni̱ ca̱katunúntit huixín tí xli̱hua̱k minacujcán lacputzayá̱tit la̱ tancs nalatapa̱yá̱tit la̱ tí talakatí tali̱kalhkasa aktum la̱n tahuá, porque Dios ama ca̱ma̱xqui̱yá̱n tú nali̱kalhkasa mili̱stacnicán. ’Capa̱xahuátit ni̱ ca̱katuyúntit huixín tí ni̱ laccamama laktasayá̱tit tú tapa̱xtoka cristianos porque Dios ama ca̱ma̱xqui̱yá̱n li̱camama natziyaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Capa̱xahuátit ni̱ ca̱katuyúntit huixín acxni caj quilacata aquit Xatalacsacni Chixcú cristianos xala ca̱quilhtamacú naca̱si̱tzi̱niyá̱n naca̱ktlakali̱pincaná̱tit naca̱li̱kalhkama̱naná̱n y naca̱lakmakancaná̱tit la̱ lacli̱xcájnit cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","¡Capa̱xahuátit y ni̱ calakaputzátit namá chichiní! Porque ama cha̱n quilhtamacú pa̱t ca̱ma̱katzi̱nicaná̱tit mintaxoko̱ncán nac akapú̱n. Ni̱ cajicuántit, ca̱ksántit la̱ namá cristianos na̱ tama̱kxtakájni̱lh xalakmaká̱n profetas tí talatáma̱lh xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero snu̱n cca̱li̱lakaputzá namá ricos tí huata talacputzá la̱ natali̱pa̱xahuá ixtumi̱ncán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Koxitaní̱n huixín tí ni̱tú ca̱tzanka̱niyá̱n chí ca̱quilhtamacú porque ama cha̱n quilhtamacú ama tzincsa mili̱stacnicán. Koxitaní̱n huixín tí li̱paxáu tziyaná̱tit porque ama cha̱n quilhtamacú pa̱t tasayá̱tit la̱ta li̱puhuán minacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Koxitaní̱n huixín tí ma̱tla̱ni̱yá̱tit caca̱li̱ma̱tla̱ni̱cántit laclá̱n tachihuí̱n porque xalakmaka̱n judíos na̱ chuná ixtama̱tla̱ní namá makapitzi akskahuinani̱n profetas. ");
INSERT INTO topNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Huixín tí quila̱takokeyá̱u, tla̱n cakaxpáttit tú camá̱n ca̱huaniyá̱n: Huixín caca̱lakalhamántit tí ca̱si̱tzi̱niyá̱n, caca̱tlahuanítit li̱tlá̱n tí ni̱ ca̱cxilhputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Caca̱lakalhamántit amá tí ca̱sipaacxilá̱n y caca̱li̱kalhtahuakátit ixlacati̱n Dios xlacata ni̱tú natapa̱xtoka tú ni̱ tla̱n amá tí ca̱ma̱kxtakajni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Para cha̱tum cristiano lakakaxiyá̱n milacán cali̱mákxtakti na̱ calakakaxín nac milakatu, y para tí maklhti̱yá̱n minchamarra na̱ cama̱xqui milháka̱t. ");
INSERT INTO topNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Para cha̱tum cristiano huí tú maclacasquín y maksquiná̱n para kalhi̱ya cama̱xqui; y para tí maklhti̱yá̱n tú ixmaclacasquina ni̱ catlahua fuerza camaklhti, ¡cata̱tamákxtakli! ");
INSERT INTO topNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Huix caca̱tlahuani li̱tlá̱n xa̱makapitzi cristianos na̱ chuná la̱ ixlakati catatlahuanín li̱tlá̱n xlacán. ");
INSERT INTO topNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Calacpuhuántit tú cama ca̱huaniyá̱n: Para huix huata ca̱pa̱xqui̱ya tí na̱ tapa̱xqui̱yá̱n, ¿nicu nali̱lakapascana tlahuápa̱t tú tla̱n? Pues tí ni̱ tali̱pa̱huán Dios na̱ talakalhamán tí ca̱pa̱xquí. ");
INSERT INTO topNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Para huix huata ca̱tlahuaniya li̱tlá̱n tí na̱ tatlahuaniyá̱n li̱tlá̱n, ¿nicu nali̱lakapascana tlahuápa̱t tú tla̱n? Pues tí lacsnú̱n talani̱t na̱ tamakta̱yá tí ca̱tlahuaní li̱tlá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chuná li̱tum para huata ca̱ma̱sa̱cuani̱ya tumi̱n tí nataxokoniyá̱n, ¿nicu nali̱lakapascana tlahuápa̱t tú tla̱n? Pues hasta namá lacli̱xcájnit lacchixcuhuí̱n na̱ tama̱sa̱cuaní tumi̱n tí tancs tacatzí ama ca̱xokoní. ");
INSERT INTO topNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Huixín tí quila̱li̱pa̱huaná̱u, caca̱lakalhamántit tí ca̱si̱tzi̱niyá̱n. Para cha̱tum huí tú maclacasquín, camakta̱yátit y cama̱sa̱cuaní̱tit para kalhi̱yá̱tit ma̱squi tancs catzi̱yá̱tit ni̱cxni ama ca̱xokoniyá̱n, y Dios tí ni̱tí ma̱ccha̱ní ixli̱tlihueke ama ca̱ma̱xqui̱yá̱n mintaxoko̱ncán, y nac ca̱quilhtamacú cati̱huá ama ca̱li̱ma̱nu̱yá̱n xli̱ca̱na huixín ixcamán Dios, pues xlá quilhpa̱xtum ca̱lakalhamán cristianos, la̱ tí ni̱cxni tapa̱xcatcatzi̱ní tú ca̱ma̱xquí, y la̱ tí lacsnú̱n talani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Huixín caca̱lakalhamántit hua̱k cristianos na̱ chuná la̱ Mimpu̱chinacan Dios ca̱lakalhamán hua̱k ixcamán. ");
INSERT INTO topNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Huixín ni̱ huata caputzátit li̱chihui̱naná̱tit tú ni̱ tla̱n tatlahuá tunu cristiano xlacata Dios na̱ ni̱ naputzaniyá̱n huata tú ni̱ tla̱n tlahuani̱ta. Na̱ chuná ni̱ huata cama̱lacapú̱tit tú ni̱ tla̱n takalhí xa̱makapitzi xlacata Dios na̱ ni̱ huata naca̱li̱ma̱lapu̱yá̱n tú ni̱ tla̱n kalhi̱yá̱tit. Cama̱tzanke̱nanítit tú ni̱ tla̱n ca̱tlahuaniyá̱n minta̱cristianoscán xlacata Dios na̱ naca̱ma̱tzanke̱naniyá̱n tú ni̱ tla̱n tlahuani̱tántit. ");
INSERT INTO topNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Huixín caca̱ma̱xqutit minta̱cristianoscán tú tamaclacasquín y Dios ni̱ ama aktzonksuá ca̱pu̱spitniyá̱n mintaxoko̱ncán; ama ca̱ma̱tzamaniyá̱n mimorralhcán, a̱ctzu̱cú ama huilí hasta ama takalhmakán xlacata naca̱kalhta̱xtuniyá̱n. La̱ta ixli̱lhu̱hua tú nama̱xqui̱yá̱tit minta̱cristianoscán acxni tú maclacasquín, Dios na̱ chuná ixli̱lhu̱hua ama ca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús na̱ ca̱huánilh jaé takalhchihuí̱n: ―¿Puhuaná̱tit huixín cha̱tum lakatzí̱n tla̱n makachipalí̱n tunú ixta̱lakatzí̱n? ¿Ni̱ puhuaná̱tit para tatla̱huán caj laktzú taán talhtuja ixcha̱tuycán? ");
INSERT INTO topNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na̱ chuná cha̱tum kahuasa tí kalhtahuakamajcú, ¿a poco tla̱n makatlajá ixma̱kalhtahuake̱ná? Pero para li̱ta̱yá ixtakalhtahuaka tla̱n ta̱talacastuca ixma̱kalhtahuake̱ná. ");
INSERT INTO topNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Chí na̱ cca̱huaniyá̱n, ¿nicu li̱cxila actzu palhma ni̱ma̱ lacatanu̱ma minta̱cristiano nac ixlakastapu, pero ni̱ maklhcatzi̱ya xlacata nac milakastapu lacatanu̱má̱n ma̱s lanca actzu̱ quihui? ");
INSERT INTO topNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Nicu li̱kalhi̱ya li̱camama huaniya minta̱cristiano: “Cama lacama̱xtuyá̱n namá actzu̱ palhma ni̱ma̱ lacatanu̱má̱n”, y huix ni̱ maklhcatzi̱ya lacatanu̱má̱n ma̱s lanca actzu̱ quihui? ¡Akskahuina chixcú! ¡Pu̱la̱ cama̱xtu namá actzu̱ quihui ni̱ma̱ lacatanu̱má̱n y ni̱ ma̱lacahua̱ni̱yá̱n y a̱stá̱n tla̱n nalacama̱xtuya palhma minta̱cristiano! ");
INSERT INTO topNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Aquit cca̱huaniyá̱n cali̱lacpuhuántit ixtahuácat quihui: Ni̱ huí katum tla̱n quihui mi̱ma̱ ma̱stá ni̱ tla̱n ixtahuácat, ni̱ para huí ni̱ tla̱n quihui ni̱ma̱ ma̱stá tla̱n ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porque katunu quihui ca̱li̱lakapascán ixtahuácat ni̱ma̱ ma̱stá. Ni̱cxni puxcán ixtahuácat skatan nac akatum lhtucú̱n, ni̱ para puxcán ixtahuácat uvas nac akatum xpáyat. ");
INSERT INTO topNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jaé quihui cca̱ta̱ma̱lacastuca cristianos, cha̱tum tla̱n chixcú siempre ca̱huán lactlá̱n tapuhuá̱n porque tla̱n catzí ixnacú, y cha̱tum ni̱ tla̱n chixcú ca̱huán ni̱ lactlá̱n talacpuhuá̱n porque snu̱n lani̱t ixnacú. Tú li̱chihui̱nán ixquilhni cha̱tum chixcú tla̱n li̱lakapascán ixtapuhuá̱n ixnacú. ");
INSERT INTO topNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tucu li̱macuán tza̱pu quila̱huaniyá̱u: “Huix Quimpu̱chinacán, huix Quimpu̱chinacán”, para ni̱ tlahuayá̱tit tú cca̱li̱ma̱paksi̱yá̱n? ");
INSERT INTO topNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amá tí quili̱pa̱huán y kaxmata y tlahuá tú cli̱ma̱paksi̱nán cama ta̱ma̱lacastuca jaé takalhchihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Cha̱tum chixcú tláhualh ixchic, pu̱la ca̱huáxnalh pu̱lhmá̱n hasta táka̱sli chíhuix y aná ma̱tí̱ju̱lh ixcha̱ya. Acxni stacli kalhtu̱choko, lákcha̱lh chúchut pero ni̱tú tlahuánilh porque xacha̱ya tla̱n ixti̱jú nac chíhuix. ");
INSERT INTO topNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero amá tí quinkaxmata y ni̱ tlahuá tú cli̱ma̱paksi̱nán cli̱macá̱n la̱ cha̱tum chixcú ni̱ma̱ tláhualh ixchic, pero caj pu̱tzú ma̱tí̱ju̱lh ixcha̱ya, y acxni stacli kalhtu̱choko lákcha̱lh chúchut ni̱ para tuhua ma̱ti̱cútulh amá chiqui, caj la̱ ni̱tú lactláhualh porque ni̱ tla̱n ixti̱jú xacha̱ya. ");
INSERT INTO topNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Acxni ca̱ta̱chihui̱nanko̱lh amá cristianos tí ixtakaxmatma̱na Jesús ampá nac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aná ixlama cha̱tum capitán romano, ixkalhí cha̱tum ixtasa̱cua ixni̱majá la̱ta ixta̱tatlá y snu̱n ixlakalhamán. ");
INSERT INTO topNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Amá capitán acxni cátzi̱lh la̱ ixli̱chihui̱nancán ixtascújut Jesús ca̱ma̱lakácha̱lh makapitzi lakko̱lún judíos cata̱lh tahuaní Jesús catláhualh li̱tlá̱n camilh ma̱ksa̱ní ixtasa̱cua. ");
INSERT INTO topNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xlacán tama̱lacatzúhui̱lh Jesús y chuné tzúculh taxcalaní: ―Namá capitán mini̱ní camakta̱ya, ");
INSERT INTO topNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porque xlá snu̱n quinca̱lakma̱xtuni̱tán y xa̱huá huá ma̱tlahui̱nani̱t aktum quisinagogajcán. ");
INSERT INTO topNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús ma̱tla̱ni̱lh y ca̱tá̱alh. A̱laktzú ixca̱tzanka̱ní natachá̱n acxni támilh talakapa̱xtoka makapitzi ixamigos amá capitán tí ixca̱ma̱lakacha̱ni̱t y tahuánilh: ―Maestro, yaj snu̱n calácscujti quilacata. Huix snu̱n tali̱pa̱u y ni̱ mini̱ní natanu̱ya nac quiákxtaka porque aquit li̱xcájnit quinkásat. ");
INSERT INTO topNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Huá xlacata ni̱ ckálhi̱lh li̱camama aquit nacaná̱n lacaputzayá̱n. Para quimakta̱yaputuna huata cali̱ma̱paksí̱nanti ixli̱tlihueke mintachihuí̱n y quintasacua na̱ksa̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pues huix catzi̱ya xlacata aquit na̱ quintama̱paksí ma̱s xalactali̱pa̱u, pero aquit na̱ cca̱kalhí soldados tí quintakaxmatní tú cca̱li̱ma̱paksí. Acxni cuaní cha̱tum: “Capit ní cama ma̱lakacha̱yá̱n”, xlá tuncán an. Acxni cuaní cha̱tum: “Caní juú”, xlá tuncán min, y la̱ta tú cli̱ma̱paksí quintasa̱cua xlá tuncán tlahuá. Huá cli̱huaniyá̱n aquit cli̱pa̱huán mintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","La̱ kaxmatko̱lh amá tachihuí̱n Jesús cá̱cni̱lh amá capitán y acs ca̱lacá̱cxilhli hua̱k tí ixtatakokeni̱t y ca̱huánilh: ―La̱ta ixli̱ti̱lanca jaé pu̱latama̱n Israel ni̱ xactaka̱sni̱t tí quili̱pa̱huani̱t la̱ jaé chixcú romano. ");
INSERT INTO topNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Amá lacchixcuhuí̱n tatáspitli nac ixchic amá capitán romano y tá̱cxilhli ixaksa̱nani̱ttá amá chixcú tí ixta̱tatlá. ");
INSERT INTO topNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A̱stá̱n Jesús ca̱tá̱alh ixdiscípulos nac aktum ca̱chiquí̱n huanicán Naín y lhu̱hua cristianos ixtatakokeni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lihua ixtacha̱ma̱najá ca̱chiquí̱n acxni ácxilhli ixli̱ncán nac campúsa̱ntu cha̱tum ni̱n. Ixkahuasa ixuani̱t cha̱tum viuda y huata amá tancstum ixkahuasa ixkalhí tí ixni̱ni̱t. Lhu̱hua cristianos xala amá ca̱chiquí̱n ixtatakokeni̱t amá pusca̱t. ");
INSERT INTO topNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Acxni ácxilhli Jesús li̱lakapútzalh amá viuda y huánilh: ―Yaj catasa. ");
INSERT INTO topNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesús ca̱ma̱lacatzúhui̱lh tí ixtalí̱n caja y ¡tucs tláhualh! Amá lacchixcuhuí̱n tí ixtacucani̱t tatá̱yalh y Jesús ta̱chihuí̱nalh amá xani̱n kahuasa: ―Kahuasa, aquit cli̱ma̱paksi̱yá̱n, ¡calacastacuánanti! ");
INSERT INTO topNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Amá kahuasa tuncán lacastacuánalh, curucs tahui y tzúculh chihui̱nán. A̱stá̱n Jesús macamá̱xqui̱lh ixna̱na amá kahuasa. ");
INSERT INTO topNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hua̱k cristianos ca̱maká̱klhalh tú ixta̱cxilhni̱t y tzúculh tapa̱xcatcatzi̱ní Dios tú ixtlahuani̱t. Makapitzi ixtahuán: ―Cha̱tum lanca profeta quinca̱ta̱lamá̱n jaé quilhtamacú y Dios quinca̱cxilhlacachini̱tán mini̱t quinca̱li̱scujá̱n aquín ixcamán. ");
INSERT INTO topNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tú xtlahuani̱t Jesús lacapala tacatzi̱ko̱lh cristianos xala amá pu̱latama̱n Judea y ni̱ma̱ ixtata̱tapakxtoka. ");
INSERT INTO topNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ixdiscípulos Juan tali̱ma̱kalhchihuí̱ni̱lh jaé ixtascújut Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Entonces xlá ca̱tasánilh cha̱tuy ixdiscípulos y ca̱ma̱lakácha̱lh ixlacati̱n Jesús porque xlá tancs ixcatzi̱putún para xli̱ca̱na Jesús huá Cristo ixuani̱t tí ixmini̱t ca̱lakma̱xtú cristianos, o ixamajcú takalhí namín a̱stá̱n tunu. ");
INSERT INTO topNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Acxni talákcha̱lh xlacán tama̱lacatzúhui̱lh y tahuánilh: ―Juan Bautista quinca̱ma̱lakacha̱ni̱tán xlacata nacca̱kalasquiniyá̱n para huix Cristo tí ama min quinca̱lakma̱xtuyá̱n, o cama̱najcú kalhi̱yá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Xlá acs ca̱lacá̱cxilhli y tzúculh ca̱ma̱ksa̱ní makapitzi ta̱tatlaní̱n tí ixtakalhí ti̱pa̱katzi tá̱tat y tasipá̱ni̱t, ca̱tamácxtulh ixespiritucan tlajananí̱n ixmacnican cristianos y ca̱ma̱lacahuá̱ni̱lh lakatzí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","La̱ tlahuako̱lh ixtascújut ca̱huánilh: ―Capítit huaniyá̱tit Juan la̱ta tú acxilhni̱tántit y tú kaxpatni̱tántit. Cali̱ma̱kalhchihui̱ní̱tit la̱ talacahua̱nán lakatzí̱n, la̱ tatla̱huán tí ixtacha̱la̱kalhi̱ni̱t, la̱ ta̱ksa̱nán tí takalhí lepra, la̱ ta̱kahua̱nán akata̱paní̱n, la̱ talacastacuanán tí apenas tani̱ko̱ni̱t, la̱ ca̱li̱ta̱chihui̱nancán tí ni̱ lactali̱pa̱u ixtalakalhamá̱n Dios ni̱ma̱ ma̱lacnú. ");
INSERT INTO topNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Na̱ cahuanítit xlacata aquit cli̱pa̱xahuá tí tancs quili̱pa̱huán porque ni̱ ama lakaputzaxní. ");
INSERT INTO topNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","La̱ ta̱nko̱lh amá lacchixcuhuí̱n tí ixca̱ma̱lakacha̱ni̱t Juan, Jesús tzúculh li̱chihui̱nán Juan, ca̱huánilh cristianos: ―Quila̱huaníu, ¿tucu qui̱cxílhtit acxni qui̱látit nac desierto? ¿Qui̱li̱lacahua̱nántit la̱ ma̱tzahuají u̱n amá ká̱tit ni̱ma̱ tatzamá nac desierto? ");
INSERT INTO topNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Quila̱huaníu, ¿tucu qui̱cxílhtit? ¿Ixlacaputzayá̱tit cha̱tum chixcú tí tla̱n lhaka̱nani̱t la̱ namá ni̱ma̱ tahuila̱na nac pu̱ma̱paksi̱n? Huixín catzi̱yá̱tit namá lacchixcuhuí̱n tí tla̱n talhaka̱nán y li̱ca̱cni̱t talama̱na tahuila̱na nac ixchiccán reyes. ");
INSERT INTO topNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Tucu ixputzayá̱tit? ¿Ixacxilhputuná̱tit cha̱tum profeta tí ma̱lakacha̱ni̱t Dios? Para huá qui̱putzátit li̱huacá tla̱n porque Juan li̱macamincani̱t ma̱s lanca que la̱ cha̱tum profeta. ");
INSERT INTO topNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan huá namá chixcú tí chuné li̱chihuí̱nalh Dios nac Escrituras: Pu̱la cama ma̱lakacha̱niyá̱n cha̱tum chixcú tí napu̱laniyá̱n xlacata naca̱xtlahuaniyá̱n tijia ní nalacpasa̱rlaya. ");
INSERT INTO topNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aquit tancs cca̱huaniyá̱n la̱ta ixli̱hua̱kcán cristianos tí tama̱lakahuani̱ni̱t lacchaján ca̱quilhtamacú ni̱tí ma̱ccha̱ní ixli̱lanca Juan Bautista, pero na̱ cacatzí̱tit xlacata nac ixtapáksi̱t Dios namá ma̱s ni̱ xatali̱pa̱u cristiano li̱maca̱ncán ma̱s lanca que Juan Bautista. ");
INSERT INTO topNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hua̱k cristianos tí takáxmatli hasta ixma̱lakaxoke̱nani̱n tumi̱n tí ixca̱kmununi̱t Juan tama̱kachákxi̱lh xlacata Dios ca̱ma̱xquí ixcamán stalhca taxokó̱n. ");
INSERT INTO topNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ixma̱kalhtahuake̱nacán judíos y fariseos tí ni̱ ixtali̱tamakxtakni̱t caca̱kmúnulh Juan, ni̱ tama̱tlá̱ni̱lh tú ixca̱ma̱lacnu̱nini̱t Dios ama ca̱ma̱xquí. ");
INSERT INTO topNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesús ca̱huanipá jaé takalhchihuí̱n: ―¿Niculá xacca̱li̱chihuí̱nalh cristianos tí talama̱na jaé quilhtamacú, o tucu xacta̱ma̱lacástucli? ");
INSERT INTO topNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xlacán tamakslihueké namá lactzáca̱t lactzu̱ camán ni̱ma̱ takama̱nán nac li̱tamá̱u y ni̱tú tama̱tla̱ní hasta ixcompañeros tahuán: “¿Tucu lacasquiná̱tit? Ctlaká̱u tatlí̱n, pero huixín ni̱ tantli̱yá̱tit; ctli̱yá̱u li̱lakaputza alabanza ni̱ para chú tasayá̱tit.” ");
INSERT INTO topNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jaé cristianos chuná tapa̱xtoka porque qui̱lachi ca̱quilhtamacú Juan Bautista; xlá ni̱ ixca̱ta̱hua̱yán, ni̱ para ixca̱ta̱pa̱xahuá ca̱ta̱huá vino cristianos y huancán xlacata kalhí ni̱ tla̱n espíritu. ");
INSERT INTO topNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A̱stá̱n cmilh aquit Xatalacsacni Chixcú tí cca̱ta̱hua̱yán y acxtum cca̱ta̱pa̱xahuá cca̱ta̱huá vino cristianos y huancán: “Ca̱cxílhtit namá la̱ huata li̱puhuán nahua̱yán y ca̱ta̱kachí cristianos, amigos ca̱tlahuá tí tama̱lakaxoke̱nán tumi̱n y tí takalhí lhu̱hua tala̱kalhí̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ixtalacapa̱stacni Dios tla̱n ta̱cxcatzí tí ca̱laclhca̱nini̱t natacatzí la̱ ama ca̱lakma̱xtú ixcamán. ");
INSERT INTO topNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cha̱tum ixma̱kantaxti̱ná ixley Moisés huánilh Jesús caalh ta̱hua̱yán nac ixchic. Acxni cha̱lh xlá pasá̱rlalh nac mesa y tzúculh ca̱ta̱hua̱yán la̱ta tí ixtahuila̱na. ");
INSERT INTO topNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nac ca̱chiquí̱n ixlama cha̱tum pusca̱t mi̱ma̱ chu̱ta ixaclapu̱lá; acxni cátzi̱lh xlacata Jesús ixani̱t hua̱yán nac ixchic amá fariseo lí̱milh aktum frasco xatlá̱n perfume. ");
INSERT INTO topNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tatzokostánilh y tzúculh tasá la̱ta ixli̱puhuán ixnacú; ixlakaxtájat li̱tu̱chéke̱lh ixtujún Jesús y li̱tu̱ma̱scá̱calh ixchíxit; ixtu̱spu̱ta ixtujún ixuili̱niti̱lhá perfume nac ixtujún. ");
INSERT INTO topNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amá fariseo tzúculh lacpuhuán: “Para jaé chixcú xli̱ca̱na profeta ixuá ixacxcátzi̱lh tucu ixkásat namá pusca̱t tí tu̱cheke̱ma pues chu̱ta aclapu̱lá.” ");
INSERT INTO topNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesús cátzi̱lh ixtapuhuá̱n y huánilh: ―Simón, huí tú cuaniputuná̱n. ―Quihuani tú lacasquina, Maestro ―kalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús huá: ―Maktum quilhtamacú cha̱tum ixma̱sa̱cuani̱na tumi̱n ixtali̱ní tumi̱n cha̱tuy lacchixcuhuí̱n. Cha̱tum ixli̱ní cinco mi̱lh pesos y xa̱cha̱tum ixli̱ní íta̱t mi̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Como xlacán ni̱ lá ixtaxoko̱nán amá ixma̱sa̱cuani̱na tumi̱n ca̱lakalhámalh ca̱ma̱tzanke̱nánilh tú ixtali̱ní. Chí quihuani, la̱ta ixli̱cha̱tuycán, ¿ticu ma̱s nalakalhamán napa̱xcatcatzi̱ní amá chixcú tú ma̱tzanke̱nánilh? ");
INSERT INTO topNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón kálhti̱lh: ―Tí ma̱s nalakalhamán huá amá tí ma̱tzanke̱nánilh ma̱s lhu̱hua tumi̱n. ―Xli̱ca̱na tú huana, Simón ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesús acs lacá̱nilh amá pusca̱t y huanipá Simón: ―Chí tla̱n calacpúhuanti tú qui̱taxtunini̱t jaé pusca̱t. Acxni ctánu̱lh nac mínchic huix ni̱ áksanti quima̱xqui̱ya chúchut tú nacli̱tu̱chaká, pero jaé pusca̱t quili̱tu̱chéke̱lh ixlakaxtájat y quili̱tu̱ma̱scá̱calh ixchíxit. ");
INSERT INTO topNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huix ni̱ quimacáspu̱tti acxni cchilh, pero xlá la̱ta ctitánu̱lh spu̱tma quintujún. ");
INSERT INTO topNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huix ni̱ quihuili̱ni aceite nac quiákxa̱ka la̱ li̱smani̱ni̱táu aquín judíos, pero xlá quihuilí̱nilh xatlá̱n perfume nac quintujún. ");
INSERT INTO topNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","La̱ta tú tlahuani̱t quilacata tla̱n li̱lakapascán xlacata lhu̱hua tala̱kalhí̱n kalhí pero aquit cma̱tzanke̱naní hua̱k ixtala̱kalhí̱n. Porque amá tí caj actzú ma̱tzanke̱nanicán ixtala̱kalhí̱n na̱ caj actzú pa̱xcatcatzi̱ní tí ma̱tzanke̱nánilh. ");
INSERT INTO topNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesús huánilh amá pusca̱t: ―Hua̱k mintala̱kalhí̱n aquit cma̱tzanke̱naniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Amá cristianos tí ixtahuila̱na aná tzu̱culh tahuán: ―¿Cha̱ ticu yá chixcú jaé? ¿Hua̱nchi li̱tanú tla̱n ma̱tzanke̱nán tala̱kalhí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús huaniko̱lh amá pusca̱t: ―Huix taxtunini̱ta porque quili̱pa̱huani̱ta; capit li̱pa̱xáu, yaj tú cali̱púhuanti. ");
INSERT INTO topNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A̱stá̱n ni̱ ixli̱maka̱s Jesús alh akchihuinantapu̱lí amá ca̱lacchiquí̱n y ca̱tucuxtú̱n xalac Galilea, ixca̱huaní la̱ Dios ca̱ma̱lacnu̱ní ca̱ma̱paksi̱putún cristianos; ixcha̱cu̱tuycán ixdiscípulos ni̱cxni ixta̱kxtakmakán. ");
INSERT INTO topNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Na̱ ixtatakoké makapitzi lacchaján tí ixca̱ma̱ksa̱ni̱ni̱t acxni ixta̱tatlá, o ixca̱macma̱xtuni̱t ixespiritucan tlajaná. Jaé lacchaján tí ma̱s ixtamakta̱yá ixca̱huanicán María ixli̱lakapascán Magdalena y Jesús ixmacma̱xtuni̱t cha̱tujún tlajananí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Susana, Juana ixta̱cha̱t Chuza jaé chixcú ixacpuxcún ixchic rey Herodes y lhu̱hua ma̱s lacchaján ixtali̱makta̱yá tú ixtakalhí. ");
INSERT INTO topNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Lhu̱hua cristianos xala cani̱hua ca̱lacchiquí̱n ixtamín takaxmata ixtachihuí̱n Jesús. Lacatum acxni tatamákstokli lhu̱hua cristianos xlá ca̱huánilh jaé takalhchihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Maktum quilhtamacú cha̱tum chixcú alh spuyumí ixtalhtzi ixtachaná̱n nac ixca̱tucuxtu. Lhu̱hua ixtalhtzi ixli̱chánat tama̱chá nac tijia; aná lacta̱yami̱ca y lactzu̱ spitu na̱ chuná tzúculh tasacuá ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Makapitzi ixli̱chánat tama̱chá nac ca̱chihuixni caj tziná ixta̱lani̱t tíyat; sok tá̱kpulh pero tuncán tasca̱cko̱lh porque ni̱ ixtakalhí chúchut tú natali̱latamá. ");
INSERT INTO topNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Makapitzi ixli̱chánat tatama̱chá nac ca̱xpayatni. Ni̱ ixli̱maka̱s sok ta̱kpunko̱lh pero tama̱ksni̱ko̱lh amá kajni porque ma̱s lacapala tástacli. ");
INSERT INTO topNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero lhu̱hua ixli̱chánat tama̱chá nac tla̱n tíyat; jaé hua̱k tástacli y makapitzi tamá̱sta̱lh ixtahuacatcán hasta aktum ciento ixtalhtzicán la̱ta akstum li̱chánat. La̱ chihui̱nanko̱lh la̱ta ixli̱pixcha̱lanca ca̱huánilh cristianos jaé tachihuí̱n: ―Para huixín kalhi̱yá̱tit mintake̱ncán cakaxpáttit tú cca̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ixdiscípulos takalasquínilh tú ixuamputún amá takalhchihuí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","y Jesús ca̱huánilh: ―Huixín Quinti̱cu Dios ca̱ma̱cxcatzi̱ni̱yá̱n la̱ xlá ca̱ma̱lacnu̱ní cristianos ama ca̱ma̱paksí pero xa̱makapitzi cristianos tiene que nacca̱ta̱ma̱lacastucní tú talakapasa, y ni̱ para chú ama taputzá natama̱kachakxí. Ama talacahua̱nán, pero la̱ ni̱tú catá̱cxilhli; ta̱kahua̱nán, pero ni̱tú tama̱kachakxí. ");
INSERT INTO topNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Chí tla̱n cama̱kachakxí̱tit la̱ cama lacspi̱ta namá xatakalhchihuí̱n chana̱ná: Amá ixtalhtzi tachaná̱n chi̱malacastuca ixtachihuí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amá tijia ana ní tatama̱chá makapitzi ixtalhtzi tachaná̱n cca̱li̱ma̱lacastuca cristianos tí takaxmata ixtachihuí̱n Dios pero tlajaná min ma̱ke̱nú tachihuí̱n mi̱ma takáxmatli ixnacujcán xlacata ni̱ nataca̱najlá y ni̱ natalakma̱xtú ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amá ca̱chihuixni ní tatama̱chá makapitzi tachaná̱n cca̱li̱ma̱lacastuca cristianos tí talakatí takaxmata ixtachihuí̱n Dios y hasta taca̱najlá laktzu̱ quilhtamacú, pero con ta̱kspulá tú ni̱ tlá̱n y ca̱li̱chihui̱nancán yaj tali̱pa̱huán porque ni̱ pu̱lhmá̱n tamaca̱ni̱t ixtankaxe̱kcán. ");
INSERT INTO topNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amá ca̱xpayatni ana ní sok tá̱kpulh tachaná̱n cca̱li̱ma̱lacastuca cristianos tí takaxmata ixtachihuí̱n Dios y taca̱najlá, pero la̱ta li̱án ixlatama̱tcán tzucú ta̱katuyún, tzucú tali̱pa̱huán huata ixtumi̱ncán y la̱ li̱pa̱xau natalatamá y chuná tama̱ksni̱kó tú ixtali̱pa̱huán y ni̱ tama̱stá ixtahuacatcán. ");
INSERT INTO topNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amá tla̱n tíyat ní tatama̱chá lhu̱hua tachaná̱n y tamá̱sta̱lh ixtahuacatcán cca̱li̱ma̱lacastuca cristianos tí takaxmata ixtachihuí̱n Dios y tama̱quí nac ixnacujcán y tatzaksá tama̱sí ixtahuácat nac ixlatama̱tcán tú tama̱kachakxi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesús ca̱huanipá cristianos: ―Ni̱ huí cristiano tí ma̱pasí aktum pu̱skon y ma̱kalhchahuajú nac caju̱n o ma̱nú nac ixtampi̱n ixpu̱tama. Huixín catzi̱yá̱tit aktum pu̱skon siempre huili̱cán ta̱lhmá̱n xlacata hua̱k natali̱lacahua̱nán ixtaxkáke̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na̱ chuná siempre taka̱scán tú tla̱n tze̱k ma̱qui̱cán, y tú tze̱k tlahuacán siempre qui̱catzi̱cán ixli̱maka̱s y ca̱lakuá̱n tamakxtaka tú ixma̱tze̱kma̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Chí cakaxpáttit tú cama ca̱huaniyá̱n: amá tí kalhi̱yá tla̱n talacpuhuá̱n ma̱s ama̱ca ma̱xqui̱cán talacapa̱stacni hua̱k nama̱kachakxí, pero tí caj actzú kalhí ama̱ca maklhti̱cán hasta ni̱ma̱ ixli̱skalhma̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Maktum quilhtamacú ixna̱na ixnata̱camán Jesús támilh talacaputzá ana ní ixchihui̱nama, pero como snu̱n istzamacán ni̱ lá tama̱lacatzúhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Cha̱tum cristiano huánilh: ―Mina̱na y minata̱camán taya̱na nac quilhtí̱n tata̱chihui̱namputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús ca̱huánilh hua̱k cristianos: ―Quina̱na y quinata̱camán huá namá cristianos tí takaxmata ixtachihuí̱n Dios y tama̱kantaxtí tú li̱ma̱paksi̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Maktum quilhtamacú a̱lacatunu pu̱latama̱n Jesús ca̱ta̱táju̱lh ixapóstoles nac aktum barco y ca̱huánilh: ―Ca̱huí ixa̱quilhtu̱tu pupunú. Xlacán tzúculh tama̱tla̱hualí̱n amá barco nac chúchut, ");
INSERT INTO topNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","y la̱ta ixtatla̱huama̱na Jesús lhtátalh. Ni̱ mákat ixta̱ni̱t acxni také̱talh akxtulú̱n nac chúchut y tzúculh li̱tatzamá chúchut ixbarcojcán hasta ixta̱ktzi̱putún. ");
INSERT INTO topNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xlacán tajicuanko̱lh, lacapala ta̱lh tama̱stacní Jesús y tahuánilh: ―¡Maestro, Maestro, jaé barco ta̱ktzi̱ma, amá̱n mu̱xtuyá̱u! Jesús tá̱qui̱lh, ca̱li̱ma̱páksi̱lh ixtachihuín amá u̱n y pupunú, y tuncán také̱nu̱lh; a̱stá̱n acs tatu̱tako̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Entonces ca̱huánilh ixdiscípulos: ―¿Nicu alh mili̱camamacán la̱ huaná̱tit quila̱li̱pa̱huaná̱u? Xlacán ni̱ ixtacatzí tú natahuán la̱ta ixtajicuani̱t, huata ixtara̱kalasquiní: ―¿Cha̱ tucu ixkásat jaé chixcú tí quinca̱ta̱lapu̱layá̱n hasta tla̱n ca̱ma̱paksí u̱n y pupunú y takaxmatní? ");
INSERT INTO topNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesús ca̱tá̱chalh ixdiscípulos ixa̱quilhtu̱tu pupunú nac aktum pu̱latama̱n huanicán Gadara ixta̱kalhpa̱xtoka pu̱latama̱n Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amá nac ca̱chiquí̱n ixlama cha̱tum chixcú ni̱ma̱ maká̱n ixtamactanu̱ma̱na ixespiritucán tlajananí̱n. Xlá yaj ixlhaka̱nán; ni̱ ixtahuilá nac ixchic ixlatamá nac lhucu ni̱ma̱ ixlacahuaxcani̱t nac talhpá̱n ní ixca̱pu̱ma̱nu̱cán ni̱n. Acxni tá̱ctalh Jesús xlá ni̱ alh lakapa̱xtoka, ");
INSERT INTO topNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","y acxni ácxilhli aktásalh, tatzokóstalh ixlacatí̱n y chuné ma̱ktási̱lh: ―Jesús Ixkahuasa lanca Dios, ¿hua̱nchi tana quila̱paktanu̱yá̱u? Catlahua li̱tlá̱n ni̱ caquila̱ma̱kxtakajní̱u. ");
INSERT INTO topNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jaé chixcú chú ixchihui̱nani̱t porque Jesús li̱ma̱páksi̱lh amá ixespíritu tlajaná camactáxtulh amá chixcú. Maklhu̱hua ixli̱makachi̱cán, ixli̱tantu̱chi̱cán cadenas xlacata ni̱ natza̱lá, pero acxni ixmactanú amá tlajaná ixma̱xquí li̱tlihueke caca̱lácputxli y ixaktlakahuaká caalh latamá ana ní ni̱ lama cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús kalasquínilh: ―¿Niculá huanicana? Xlá kalhtínalh: ―Cli̱tapa̱cuhui̱yá̱u “Legión”. Chuná jaé ixtali̱tapa̱cuhuí porque ixcha̱lhu̱huacán tí ixtamactanu̱ma̱na amá chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y tamáksquilh Jesús catláhualh li̱tlá̱n ni̱ caca̱ma̱lakácha̱lh nata̱kxtakajnán. ");
INSERT INTO topNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Como tá̱cxilhli lhu̱hua paxni ixtahua̱yampu̱lá lacatzú nac sipi, amá tlajananí̱n tahuánilh caca̱má̱xqui̱lh li̱tlá̱n catamactánu̱lh amá paxni y Jesús ma̱tlá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Amá ixespiritucán tlajananí̱n tuncán tamactáxtulh amá chixcú y tatánu̱lh ixmacnicán paxni. Pero huata tamactánu̱lh tzúculh talactza̱lanán la̱ catachíyalh y tapa̱tástalh lacatum ca̱kalhpu̱lhma̱n y aná tamu̱xtuko̱lh nac pupunú amá paxni. ");
INSERT INTO topNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ixmaktakalhnani̱n paxni acxni tá̱cxilhli la̱ táni̱lh ixpaxnicán tatza̱lh ta̱lh tahuán nac ca̱chiquí̱n y nac ca̱tucuxtú̱n tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lhu̱hua cristianos támilh tá̱cxila tú ixlani̱t. Acxni táchilh tá̱cxilhli Jesús y amá chixcú tí ixmactaxtuni̱t tlajaná curucs ixuí ixpa̱xtu̱n Jesús; ixlhaka̱nani̱t, yaj ixchiyani̱t, xlacán tajicuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Makapitzi tí tla̱n ixta̱cxilhni̱t la̱ aksá̱nalh amá chixcú tzúculh talacspi̱ta la̱ ixtamactaxtuni̱t tlajananí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Acxni tama̱kachakxi̱ko̱lh amá cristianos xalac Gadara y tí ixtalama̱na lacatzú, tahuánilh Jesús caalh a̱lacatunu porque ixtajicuán para tú naqui̱taxtupará. Xlá taju̱pá nac barco xlacata naán a̱lacatunu, ");
INSERT INTO topNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","pero amá chixcú tí ma̱ksá̱ni̱lh mactáxtulh tlajananí̱n tzúculh huaní camá̱xqui̱lh li̱tlá̱n catakókelh pakán ní ixama. Jesús ni̱ ma̱tlá̱ni̱lh y huánilh: ");
INSERT INTO topNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Mejor catamákxtakti, capit nac mínchic y caca̱li̱ma̱kalhchihui̱ni xa̱makapitzi la̱ Dios lakalhamani̱tán y ma̱ksa̱ni̱ni̱tán. Amá chixcú alh y tzúculh li̱chihui̱nán amá ca̱chiquí̱n tú ixtlahuani̱t Jesús ixlacata. ");
INSERT INTO topNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús cha̱mpá ixa̱quilhtu̱tu pupunú, hua̱k cristianos tapa̱xahuako̱lh acxni tá̱cxilhli porque hua̱k ixtakalhi̱ma̱na. ");
INSERT INTO topNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Cha̱tum chixcú huanicán Jairo ixacpuxcún akchihui̱nán nac sinagoga xla amá cachiquí̱n lacapala ma̱lacatzúhui̱lh Jesús, tatzokostánilh y xcalánilh caalh nac ixchic, ");
INSERT INTO topNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porque cha̱stum istzuma̱t xa̱kcu̱tuy ca̱ta ixta̱tatlá ixni̱majá. Jesús tá̱alh, lhu̱hua cristianos tatakókelh hasta ixtalacxquití la̱ta istzamacán. ");
INSERT INTO topNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na̱ aná ixán cha̱tum pusca̱t ni̱ma̱ ixkalhi̱yá akcu̱tuy ca̱ta la̱ta itstajma ixkalhni; doctores ixca̱li̱lactlahuani̱t hua̱k la̱ta tú ixkalhí, pero ni̱tí ixca̱xtlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Xlá ma̱lacatzúhui̱lh Jesús y quilhpa̱xamánilh ixlháka̱t, y tuncán maklhcátzi̱lh la̱ aksá̱nalh porque xúncnilh ní ixtala̱kalhi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús acxcátzi̱lh xlacata huí tí ma̱ksá̱ni̱lh y kalasquiní̱nalh: ―¿Ticu xámalh quilháka̱t? Como ni̱ cha̱tum tí li̱tá̱yalh entonces Pedro y ixcompañeros tahuánilh: ―Maestro, cati̱huá lacxquitiyá̱n y tanlakli̱ná̱n, y huix kalasquini̱nana: “¿Ticu xámalh quilháka̱t?” ");
INSERT INTO topNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesús ca̱huánilh: ―Huí tí quili̱tamacuácalh porque aquit tla̱n cmaklhcátzi̱lh xlacata huí tí cli̱ma̱ksá̱ni̱lh quili̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Como amá pusca̱t ixcatzí tú ixtlahuani̱t, tzúculh tatlaná y ma̱lacatzúhui̱lh Jesús, y la̱ta tzamacán kalhapálalh hua̱nchi ixquilhpa̱xamani̱t ixlháka̱t y la̱ tuncán ixaksa̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Xlá kálhti̱lh: ―Huix aksa̱nani̱ta porque quili̱pa̱huani̱ta, tla̱n cma̱ksa̱ni̱yá̱n. Capit li̱pa̱xáu, yaj tú cali̱púhuanti. ");
INSERT INTO topNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chu̱tacú ya̱ tla̱n ixchihui̱nankó acxni chilh cha̱tum chixcú ixmina̱chá ixchic Jairo amá tí ixacpuxcún akchihui̱nán nac sinagoga y huánilh: ―Mintzuma̱t apenas ni̱ko̱lh; yaj tú caliakaxculi maestro Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús káxmatli y huánilh Jairo: ―Huix ni̱tú cali̱púhuanti, huata quili̱pá̱huanti y mintzuma̱t nalatama̱pará. ");
INSERT INTO topNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Caj puntzú tácha̱lh nac ákxtaka Jesús ni̱ lacásquilh natatanú lhu̱hua cristianos ní ixmá xaní̱n amá tzuma̱t huata catatánu̱lh Pedro, Juan, Jacobo, ixna̱na, ixti̱cú amá tzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hua̱k ixtalakaputzama̱na ixtalaktasama̱na amá tzuma̱t, Jesús ca̱huánilh: ―Ni̱ catasátit, jaé tzuma̱t ni̱ xaní̱n huata lhtatama. ");
INSERT INTO topNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Xlacán tali̱tzíyalh ixtachihuí̱n porque ixta̱cxilhni̱t la̱ ixni̱ni̱t amá tzuma̱t. ");
INSERT INTO topNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesús chipánilh ixmacán amá xaní̱n tzuma̱t y chuné ta̱chihuí̱nalh: ―Tzuma̱t, cli̱ma̱paksi̱yá̱n, calacastacuánanti. ");
INSERT INTO topNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ixespíritu amá tzuma̱t taspitpá y tuncán lacastacuánalh ca̱li̱ní̱n. A̱stá̱n li̱ma̱paksí̱nalh cama̱xqui̱ca tú nali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ixnati̱cún tacá̱cni̱lh tú ixtlahuani̱t Jesús, pero xlá ca̱huánilh ni̱tí catali̱ma̱kalhchihuí̱ni̱lh tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Maktum quilhtamacú Jesús ca̱ma̱makstokko̱lh cha̱cu̱tuy ixdiscípulos y ca̱má̱xqui̱lh li̱tlihueke tla̱n natatamacxtú tlajananí̱n ixmacnicán cristianos y tla̱n natama̱ke̱nú xatu̱ta yá tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Porque ixca̱li̱lhca̱ni̱t ama ca̱ma̱lakachá natali̱chihui̱nán la̱ Dios ca̱cxilhlacachá̱n y chí ma̱lacatzuqui̱putún ixtapáksi̱t nac ixlatama̱tcán cristianos, y natama̱ksa̱ní ta̱tatlaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","La̱ta ya̱ ixtaán cahuánilh: ―Huata cali̱pítit milhaka̱tcán mi̱ma̱ huili̱ni̱tántit, ni̱ cali̱pítit lí̱xtoko, morral, simi̱ta, o tumi̱n tú namaclacasquiná̱tit nac tijia. ");
INSERT INTO topNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nac ca̱chiquí̱n ní nachipiná̱tit natamakxtaká̱tit huitiyá nac aktum ákxtaka hasta xní napimparayá̱tit a̱lacatunu. ");
INSERT INTO topNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Para chipiná̱tit aktum ca̱chiquí̱n y amá cristianos ni̱ takaxmatputún ixtachihuí̱n Dios, tuncán cataxtútit y caca̱tu̱tincxcántit pokxni ni̱ma̱ ca̱tantu̱tahuacán xlacata natacatzí namá cristianos ni̱ lakati̱yá̱tit ixkasatcán. ");
INSERT INTO topNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Amá cha̱cu̱tuy apóstoles tatáxtulh y táalh cani̱hua ca̱lacchiquí̱n, tama̱kalhchihuí̱ni̱lh cristianos la̱ Dios ca̱lakma̱xtú tí tali̱pa̱huán y tama̱ksá̱ni̱lh lhu̱hua ta̱tatlaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herodes cátzi̱lh la̱ ixca̱li̱chihui̱nancán ixtascújut Jesús y tzúculh aklhu̱hua̱tnán porque makapitzi ixtahuán xlacata amá chixcú ma̱x Juan ixuani̱t tí ixlacastacuanani̱t ca̱li̱ní̱n, ");
INSERT INTO topNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","y tunu ixtahuán ma̱x profeta Elías ixmimparani̱t ca̱quilhtamacú y makapitzi ixtapuhuán ma̱x cha̱tum xalakmaká̱n profeta ixlacastacuanani̱t ca̱li̱ní̱n ixmimparani̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes ixpuhuán y chú ixuán: ―¿Cha̱ ticu yá chixcú jaé tí quili̱ta̱chihui̱nancán tla̱n ca̱tlahuá laclanca tascújut? Ni̱ cca̱najlaputún para Juan porque Juan aquit cli̱ma̱paksí̱nalh capixca̱ctica. Como ni̱ ixlakapasa Jesús ixlacputzá la̱ na̱cxila. ");
INSERT INTO topNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ni̱ ixli̱maka̱s ixapóstoles Jesús tí ca̱ma̱lakácha̱lh natali̱chihui̱nán Dios taqui̱táspitli y tali̱ma̱kalhchihuí̱ni̱lh la̱ta tú ixtatlahuani̱t. A̱stá̱n ca̱tá̱alh lacatum ana ní ni̱tí lama cristianos lacatzú nac Betsaida. ");
INSERT INTO topNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lhu̱hua cristianos tacátzi̱lh ana ní cha̱lh y talákalh. Xlá lakáti̱lh y ca̱li̱ta̱chihuí̱nalh ixtachihuí̱n Dios, na̱ chuná ca̱ma̱ksá̱ni̱lh ta̱tatlaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Acxni tzúculh smalankanán amá cha̱cu̱tuy ixapóstoles tama̱lacatzúhui̱lh y tahuánilh: ―Juú ní huila̱náu ni̱tí lama, caca̱huani jaé cristianos cata̱lh juú lacatzú ca̱lacchiquí̱n y nac ixchiccán tí talama̱na ixca̱tucuxtucán xlacata nataputzá ní natatamakxtaka y natatama̱huá ixtahuajcán. ");
INSERT INTO topNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús ca̱kálhti̱lh: ―Huixín caca̱ma̱huí̱tit. Xlacán tahuánilh: ―¿Niculá nacca̱ma̱hui̱yá̱u aquín, huata ckalhi̱yá̱u tantuy tamakní y macquitzis simi̱ta? O, ¿sólo para lacasquina nacaná̱u tama̱huayá̱u tahuá tú natali̱hua̱yán jaé cristianos? ");
INSERT INTO topNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ixtalaya̱na como cha̱quitzis mi̱lh huata lacchixcuhuí̱n. Jesús ca̱huánilh ixdiscípulos: ―Caca̱huanítit hua̱k cristianos catatahui ca̱tiyatni íta̱t ciento pu̱tunu. ");
INSERT INTO topNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Caj puntzú ixtatahuilako̱ni̱t hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesús ca̱chípalh nac ixmacán amá macquitzis simi̱ta y tantuy tamakní, láca̱lh nac akapú̱n y pa̱xcatcatzí̱nilh Dios ixtahuá. A̱stá̱n ca̱lakchékelh y ca̱ma̱xqui̱lh ixdiscípulos xlacata natama̱kpitzí ixli̱hua̱kcán cristianos tí ixtahuila̱na. ");
INSERT INTO topNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hua̱k cristianos tahuá̱yalh y takálhkaxli, y todavía tatzámalh akcu̱tuy canasta simi̱ta y tamakní ni̱ma̱ kalhtá̱xtulh. ");
INSERT INTO topNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maktum quilhtamacú Jesús alh kalhtahuaká ixacstu lacatzú ní ixtahuila̱na ixdiscípulos a̱stá̱n ca̱kalasquínilh: ―¿Ticu yá chixcú quintali̱macá̱n cristianos? ");
INSERT INTO topNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ixapóstoles takálhti̱lh: ―Makapitzi tahuán xlacata huix Juan Bautista, tunu tahuán huix Elías, y tahuila̱na tunu tí tahuán xlacata huix ma̱x cha̱tum xalakmaká̱n profeta tí lacastacuanani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Y huixín, ¿ticu yá chixcú quila̱li̱maca̱ná̱u? ―ca̱kalasquínilh. Pedro tancs kálhti̱lh: ―Huix Cristo tí ma̱lakacha̱ni̱t Dios ama quinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús tla̱n ca̱li̱ma̱páksi̱lh ixapóstoles: ―Ni̱tí cali̱ma̱kalhchihui̱ní̱tit para catzi̱yá̱tit aquit Cristo tí mini̱t cca̱lakma̱xtuyá̱n, ");
INSERT INTO topNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","porque aquit Xatalacsacni Chixcú quili̱lhca̱cani̱t pu̱la cama akxtakajnán. Namá xalakko̱rutzí̱n judíos, xanapuxcun curas y tí tama̱sí ixley Moisés ama quintalakmakán, hasta ama quintamakní. Pero ixliaktutu chichiní aquit cama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesús ixlacasquín catama̱kachákxi̱lh ixtalacapa̱stacni huá ca̱li̱huánilh: ―Amá cristiano tí quili̱pa̱huamputún, cali̱tá̱yalh yaj li̱puhuán ixmacni y catáca̱xli macpa̱tí ixta̱kxtakajni cha̱li cha̱lí la̱ cacúcalh ixculu̱s y caquintakókelh. ");
INSERT INTO topNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porque amá tí makli̱huán lakma̱xtuputún ixli̱stacni ama makatzanká tú lakcatzán, pero tí ni̱ lakcatzán makatzanká ixli̱stacni caj quilacata namá ama maklhcatzí la̱ macuani̱t ixlatama̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pues, ¿tucu puhuaná̱tit li̱macuaní cha̱tum chixcú para ixlájalh hua̱k tumi̱n y tíyat caquilhtamacú para ixacstu lactlahuá ixli̱stacni y nalaktzanká? ");
INSERT INTO topNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","’Ama cha̱n chichiní acxni aquit Xatalacsacni Chixcú cama mimpará ca̱quilhtamacú xlacata nacca̱ma̱si̱niyá̱n ixli̱lanca quili̱ma̱paksí̱n; camá̱n ca̱li̱ma̱lacahua̱ni̱yá̱n lanca ixli̱cá̱cni̱t Dios y ángeles tí tata̱lama̱na. Y chí cca̱huaniyá̱n, amá cristiano tí quili̱pa̱huán y li̱ma̱xanán tlahuá tú cli̱ma̱paksi̱nán, aquit na̱ cama li̱ma̱xanán ixlacati̱n Quinti̱cu Dios. ");
INSERT INTO topNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na̱ cca̱ma̱lacnu̱niyá̱n, makapitzi tí talaya̱na juú y quintakaxmatma̱na ya̱ taní nahuán acxni ama ta̱cxila la̱ nalacatzucú ixtapáksi̱t Dios ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ixli̱tu̱má la̱ ca̱huánilh jaé takalhchihuí̱n, Jesús alh kalhtahuakaní Dios nac aktum sipi; ca̱tá̱alh Pedro, Jacobo y Juan. ");
INSERT INTO topNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","La̱ta ixkalhtahuakama Jesús ixlacán tzúculh tapalaja; ixlháka̱t staranka y slipua lako̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y talákchilh cha̱tuy profetas ni̱ma̱ maká̱n ixtalatama̱ni̱t, Elías y Moisés. ");
INSERT INTO topNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Xlacán na̱ makslipuán ixtatasí. Tzúculh tali̱ta̱chihui̱nán Jesús la̱ ixamajá an nac akapú̱n porque ixaccha̱majá quilhtamacú nama̱kantaxtí nac Jerusalén tú ixli̱lhca̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, Jacobo y Juan ixca̱makatlajani̱t ixtalhtatacán pero acxni tla̱n talacastacuánalh tá̱cxilhli xli̱lanca Jesús y amá cha̱tuy profetas tí ixtata̱chihui̱nama. ");
INSERT INTO topNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amá profetas tzúculh ta̱kxtakya̱huá ní ixyá Jesús, entonces Pedro huánilh: ―Maestro, lihua tla̱n la̱ cmini̱táu; para lacasquina nactlahuayá̱u aktutu lactzu pu̱ca̱sni: aktum milá, aktum xla Moisés y xa̱ktum xla Elías. Pedro chihuí̱nalh caj la̱ cakalhchiyá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Chu̱tacú ixchihui̱nama acxni aktum puclhni ca̱lákchilh y hua̱k ca̱laktlapako̱lh. Xlacán ma̱s tajicuanko̱lh porque ixpu̱lacni tatamákxtakli. ");
INSERT INTO topNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Entonces nac puclhni takaxmáti̱lh jaé tachihuí̱n: ―Huá jaé quinkahuasa ni̱ma̱ clakalhamán; cakaxpáttit tú ca̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A̱stá̱n yaj tú takaxmáti̱lh acs tatu̱taparako̱lh, a̱huata ixacstu ixyá Jesús. Talí̱alh lhu̱hua quilhtamacú y xlacán ni̱ tali̱chihuí̱nalh tú ixta̱cxilhni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ixli̱cha̱li tzisa tatalacá̱ctalh amá sipi, lhu̱hua cristianos ta̱lh talakapa̱xtoka Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","La̱ta ixli̱hua̱kcan cristianos cha̱tum chixcú chuné ma̱ktási̱lh: ―Maestro, catlahua li̱tlá̱n cama̱ksa̱ni jaé tancstum quinkahuasa ni̱ma̱ ckalhí, ");
INSERT INTO topNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","pues cha̱tum ixespíritu tlajaná mactanú ixmacni y li̱cuánit tzucú aktasá; tzucú tapití la̱ castaká̱ni̱lh y quilhtaxtú quilhpúput. Huata acxni la̱n ma̱kxtakajni̱ni̱t li̱makxtaka tziná. ");
INSERT INTO topNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Cca̱kaxcúlilh midiscípulus catama̱ksá̱ni̱lh, pero xlacán ni̱ lá tamá̱xtulh namá tlajaná. ");
INSERT INTO topNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús chuné chihuí̱nalh: ―Koxitaní̱n huixín takalhí̱n cristianos tí ni̱tú ca̱najlayá̱tit. ¿Hasta xnicu camá̱n ca̱ta̱latama̱yá̱n y ca̱pa̱ti̱niyá̱n tú tlahuayá̱tit? A ver cali̱ta namá minkahuasa. ");
INSERT INTO topNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Amá kahuasa tzúculh talacatzuhuí ní ixyá Jesús, pero amá tlajaná ma̱kuíti̱lh, trami̱chá ca̱tiyatni y tzúculh tapití. Jesús li̱ma̱páksi̱lh camactáxtulh amá kahuasa, y caj la̱ ni̱tú aksá̱nalh y a̱stá̱n macamá̱xqui̱lh ixti̱cú. ");
INSERT INTO topNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hua̱k cristianos tapa̱xahuako̱lh porque ixta̱cxilhni̱t la̱ Jesús ixca̱li̱ma̱lacahua̱ni̱ni̱t ixli̱tlihueke Dios. A̱stá̱n ca̱huanipá ixdiscípulos: ");
INSERT INTO topNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Tla̱n cakaxpáttit y ni̱ ca̱ktzonksuátit tú cama ca̱huaniyá̱n, aquit Xatalacsacni Chixcú ama̱ca quimacama̱sta̱cán ixmacancán lacli̱xcájnit lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Xlacán ni̱ tla̱n ixtama̱kachakxí tú ixca̱huaniputún porque Dios ni̱ ixca̱li̱makxtakni̱t natama̱ccha̱ní ixtalacapa̱stacni y xa̱huá ixtama̱xanán tza̱pu tzá̱pu natakalasquiní tú ixca̱li̱ta̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tunu chichiní ixdiscípulos Jesús tzúculh tara̱li̱huaní ticu yá ixdiscípulos ma̱s ixli̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Xlá acxcátzilh tú tze̱k ixtalacpuhuama̱na nac ixnacujcán huá li̱tasánilh cha̱tum actzú kahuasa, yá̱hualh nac ixíta̱t, ");
INSERT INTO topNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","y ca̱huánilh: ―Tí acxilhlacachá̱n cha̱tum actzu̱ kahuasa la̱ jaé ni̱ma̱ cchixni̱t na̱ chuná la̱ aquit caquilakalhámalh; y tí quilakalhamán na̱ lakalhamán tí quima̱lakacha̱ni̱t. Porque amá tí ma̱tla̱ní li̱tamakxtaka ni̱ xatali̱pa̱u ca̱li̱scuja xa̱makapitzi, huá namá ma̱s xatali̱pa̱u li̱ma̱nú Dios. ");
INSERT INTO topNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan na̱ ma̱lacatzúhui̱lh y huánilh: ―Maestro, ca̱cxilhui cha̱tum chixcú tí li̱quilhán mintacuhui̱ní ca̱tamacxtú tlajananí̱n ixmacnicán cristianos, pero como ni̱ quinca̱ta̱lapu̱layá̱n cli̱huaníu yaj tí cama̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","―Ni̱ ixtili̱huanítit porque cati̱huá tí ni̱ quinca̱si̱tzi̱niyá̱n namá lakatí quintascujutcán y aquín quinca̱ta̱ta̱yayá̱n ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Acxni tzúculh talacatzuhuí quilhtamacú naán Jesús nac akapú̱n, xlá ni̱ jícualh alh lakata̱yá nac Jerusalén tú ixlaclhca̱nicani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ca̱ma̱lakácha̱lh cha̱tuy cristianos nac aktum actzu̱ ca̱chiquí̱n ni̱ma̱ ixli̱tapaksí Samaria xlacata nataputzaní ní natatamakxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero amá samaritanos acxni tacátzi̱lh Jesús judío ixuani̱t ixama pakán nac Jerusalén, ni̱ tamá̱xqui̱lh ákxtaka ní natamakxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jacobo y Juan acxni tacátzi̱lh la̱ takalhtí̱nalh amá samaritanos, tahuánilh Jesús: ―Quimpu̱chinacán, para lacasquina cli̱ma̱paksi̱naná̱u catá̱ctalh lhcúya̱t nac akapú̱n xlacata naca̱lactlahuakó jaé cristianos na̱ chuná la̱ titláhualh profeta Elías. ");
INSERT INTO topNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesús acs ca̱lacá̱cxilhli y ca̱kálhti̱lh: ―Huixín ni̱ catzi̱yá̱tit ticu li̱scujpa̱nántit y ca̱ma̱xqui̱yá̱n talacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aquit Xatalacsacni Chixcú ni̱ cmini̱t ca̱lactlahuaní ixli̱stacnicán cristianos ca̱quilhtamacú, ¡cha̱ cmini̱t cca̱lakma̱xtuní ixli̱stacnicán! A̱stá̱n ca̱tá̱alh ixapóstoles a̱lacatunu ca̱chiquí̱n ní natatamakxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nac tijia ní ixtatla̱huama, cha̱tum chixcú huánilh Jesús: ―Quimpu̱chinacán, aquit ctakokeputuná̱n cani̱huá ní huix napina. ");
INSERT INTO topNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús kálhti̱lh: ―Hua̱k zorras takalhí ixlhucucán ní talhtatá, spitu takalhí ixma̱sekecán, pero aquit Xatalacsacni Chixcú ni̱ ckalhí ní cma̱jaxa quiakxa̱ka acxni cakatzanká. ");
INSERT INTO topNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús huánilh cha̱tum tunu chixcú catakókelh, pero xlá kálhti̱lh: ―Quimpu̱chinacán, nactakokeyán, pero quili̱kalhi hasta xní naní quinti̱cú y tla̱n nacmujú. ");
INSERT INTO topNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero Jesús kálhti̱lh: ―Para quintakokeputuna chí tuncán caquintakoke, y caca̱li̱mákxtakti tí la̱ xaní̱n talama̱na pi̱huá tí catamúju̱lh ixni̱ncán, pero huix ma̱s macuaniyá̱n capit ca̱ma̱kalhchihui̱ni̱ya cristianos la̱ ma̱lacnú Dios ca̱lakma̱xtuputún ixcamán. ");
INSERT INTO topNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tunu chixcú chuné talacatlá̱ni̱lh: ―Quimpu̱chinacán, aquit nactakokeyá̱n, pero pu̱la quima̱xqui quilhtamacú nacán ca̱huaní quili̱talakapasni tí tahuila̱na nac quínchic cama ca̱makxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús kálhti̱lh: ―Nac ixtapáksi̱t Dios tí chipá ixtascújut ni̱ mini̱ní nali̱makxtaka na̱ chuná la̱ tí chipá ma̱scujú arado ni̱ puntzu puntzú akxtakya̱huá ixcahua̱yu. ");
INSERT INTO topNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A̱stá̱n Jesús ca̱lácsacli setenta lacchixcuhuí̱n y ca̱ma̱lakácha̱lh cha̱tuy cha̱túy katunu ca̱chiquí̱n y pu̱latama̱n ana ní xlá ixama lacpasa̱rlá a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chuná ca̱li̱ma̱páksi̱lh natalá: ―Camaksquíntit Mimpu̱chinacan Dios caca̱ma̱lakácha̱lh ma̱s cha̱lhca̱tnaní̱n nac ixca̱tucuxtu xlacata nataxka̱nán porque huí lhu̱hua li̱xká̱nat, pero cha̱lhca̱tnaní̱n ni̱ takatzí. ");
INSERT INTO topNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Capítit ní cca̱huanimá̱n. Aquit cca̱ma̱lakacha̱má̱n la̱ lacma̱nsu borregos nac ixpu̱latama̱ncan lacli̱cuanit coyotes. ");
INSERT INTO topNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ni̱ cacucátit mintahuajcán nac mu̱rralh, ni̱ cali̱pítit tumi̱n, ni̱ cali̱pítit a̱pu̱tum mintatu̱nucán; cataxtútit la̱ta ya̱nántit. Y ti̱tum cachipítit ní pimpa̱nántit. ");
INSERT INTO topNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Acxni nachipiná̱tit aktum ákxtaka, ca̱li̱tlá̱n cahuántit: “Li̱pa̱xáu catalatáma̱lh tí tatanu̱ma̱na jaé ákxtaka.” ");
INSERT INTO topNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Para tanu̱ma cha̱tum tí tla̱n catzí ama li̱pa̱xahuá mintachihuí̱ncán ama ca̱maklhti̱naná̱n, pero para ni̱tí ca̱kalhti̱yá̱n yaj tú cahuántit. ");
INSERT INTO topNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nac ákxtaka ní ca̱maklhti̱nancaná̱tit aná catamakxtáktit, ni̱ caputzátit tunuj túnu chiqui; cahuátit y cakóttit la̱ta tú tali̱hua̱yán xlacán. Pues cha̱tum cha̱lhca̱tná mini̱ní nama̱xqui̱cán ixtaskáu. ");
INSERT INTO topNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Nac aktum ca̱chiquí̱n ní chipiná̱tit y ca̱maklhti̱nancaná̱tit, cama̱tla̱ní̱tit la̱ naca̱ta̱hua̱yancaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cama̱ksa̱ní̱tit ta̱tatlaní̱n ni̱ma̱ tahuila̱na y caca̱huanítit cristianos: “Talacatzuhui̱ma ixquilhtamacú nacatzi̱yá̱tit la̱ Dios ma̱lacnú ama ca̱lakma̱xtú ixcamán.” ");
INSERT INTO topNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Para nac aktum ca̱chiquí̱n ní chipiná̱tit ni̱ ca̱maklhti̱nancaná̱tit, tuncán cataxtútit y cahuántit nac tijia xlacata hua̱k natakaxmata: ");
INSERT INTO topNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hasta pokxni ni̱ma̱ quinca̱tu̱tahuacán nac minca̱chiqui̱ncán tuncán tla̱n quinca̱tu̱tincxcaná̱n xlacata nacatzi̱yá̱tit ni̱ clakati̱yá̱u minkasatcán. Pero cca̱huaniyá̱n, ni̱ catzí̱tit tú makatzanká̱tit porque Dios ca̱cxilhlacachín naca̱lakma̱xtuyá̱n y huixín lakmakántit.” ");
INSERT INTO topNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jesús ca̱ma̱lulóknilh: ―Acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k cristianos, xlacán ama takalhí ma̱s li̱cuánit castigo que tí ixtalama̱na maká̱n amá nac li̱xcájnit ca̱chiquí̱n Sodoma. ");
INSERT INTO topNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Koxitaní̱n huixín cristianos tí lapa̱nántit nac Corazín y nac Betsaida! Porque para laclanca ixtascújut Dios ni̱ma̱ ca̱li̱ma̱lacahua̱ni̱ni̱tán ixtica̱tláhualh nac ca̱chiquí̱n Tiro y Sidón, la̱ta maka̱sa quilhtamacú ixtitali̱mákxtakli tú ni̱ tla̱n ixtatlahuá, ixtitahuíli̱lh tzitzeke lhákat, ixtica̱li̱lakatzokca lhcaca xlacata naca̱li̱lakapascán talakaputzama̱na nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero acxni Dios naca̱ta̱tlahuá taxokó̱n hua̱k cristianos huixín pa̱t kalhi̱yá̱tit ma̱s li̱cuánit castigo que tí ixtalama̱na nac Tiro y Sidón. ");
INSERT INTO topNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¡Koxitaní̱n huixín tí lapa̱nántit nac Capernaum! Para ixpuhuaná̱tit hua̱k pa̱t chipiná̱tit nac akapú̱n, ¡aktzanka̱ni̱tántit! Porque pa̱t ca̱macapincaná̱tit lacatum ní na̱kxtakajnaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Cati̱hua cristiano tí naca̱kaxmatá̱n, la̱ aquit caquinkáxmatli, y tí naca̱lakmakaná̱n la̱ aquit caquilakmákalh; y amá cristiano tí ni̱ quimaklhti̱nán na̱ la̱ calakmákalh Dios tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ni̱ ixli̱maka̱s amá setenta lacchixcuhuí̱n tí ixca̱ma̱lakacha̱ni̱t Jesús natali̱chihui̱nán taqui̱táspitli y li̱pa̱xáu tahuánilh: ―Quimpu̱chinacán, ixespiritucán tlajananí̱n quinca̱kaxmatniyá̱n y tataxtú acxni mintacuhui̱ní cli̱quilhaná̱u. ");
INSERT INTO topNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ca̱kálhti̱lh: ―Xli̱ca̱na, pues aquit cácxilhli la̱ xapuxcu tlajaná pa̱tástalh nac akapú̱n la̱ acxni take̱tá tají̱n. ");
INSERT INTO topNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Aquit cca̱ma̱xqui̱ni̱tán li̱tlihueke namakatlajayá̱tit ixli̱tlihueke tlajaná tí quinca̱si̱tzi̱niyá̱n y ni̱tú naca̱tlahuaniyá̱n na̱ chuná ma̱squi calacta̱yátit lu̱hua y tá̱scuyu, ni̱tú ama ca̱pu̱ti̱yá̱n ixveneno. ");
INSERT INTO topNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ni̱ calactlancántit porque kalhi̱yá̱tit li̱tlihueke naca̱kaxmatniyá̱n tlajananí̱n. ¡Tó! Huixín ma̱s cali̱pa̱xahuátit la̱ mintacuhui̱nicán tatzokni̱t nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Acxni tuncán Espíritu Santo má̱xqui̱lh li̱pa̱xáu ixtalacapa̱stacni y chuné ta̱chihuí̱nalh Dios: ―Ta̱ta, clakachixcuhui̱yá̱n porque huix ixpu̱china ca̱quilhtamacú y akapú̱n. Cpa̱xcatcatzi̱niyá̱n la̱ ca̱ma̱tze̱kni tze̱k mintalacapa̱stacni amá lactali̱pa̱u y lakskalala lacchixcuhuí̱n y li̱mákxtakti natama̱kachakxí tze̱k mintalacapa̱stacni amá cristianos tí la̱ lactzu̱ camán tali̱tanú. Huix chú lacasquini̱ta y chú qui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","A̱stá̱n ca̱huánilh cristianos: ―Quinti̱cu Dios ixpu̱chiná hua̱k la̱ta tú ckalhí. Aquit ni̱tí quilakapasa huata Dios catzí aquit Ixkahuasa y aquit na̱ ccatzí huá Quinti̱cú, y na̱ tla̱n talakapasa amá tí cca̱ma̱xquí quintalacapa̱stacni natalakapasa Quinti̱cu Dios. ");
INSERT INTO topNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesús ca̱huánilh cha̱cu̱tuy ixdiscípulos: ―Capa̱xahuátit huixín porque liacxilhni̱tántit milakastapucán laclanca tascújut ");
INSERT INTO topNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ni̱ma̱ ta̱cxilhpútulh lhu̱hua profetas y laclanca reyes; xlacán ta̱cxilhpútulh tú huixín li̱lacahua̱nampa̱nántit y ni̱ tá̱cxilhli quintascújut; takaxmatpútulh quintachihuí̱n la̱ huixín kaxpatá̱ttit pero ni̱ talákcha̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cha̱tum tali̱pa̱u ixma̱kalhtahuake̱nacan judíos lákmilh Jesús xlacata nali̱kalhputzá ixtachihuí̱n y kalasquínilh: ―Maestro, ¿tucu quili̱tláhuat xlacata tla̱n naclakma̱xtú quili̱stacni nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús kálhti̱lh: ―¿Niculá ma̱kachakxi̱ya tú li̱ma̱paksi̱nán Dios? ¿Niculá li̱kalhtahuakaya nac Escrituras? ");
INSERT INTO topNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Amá chixcú huá: ―Aná huan: “Cali̱pá̱huanti Dios Mimpu̱chiná ixli̱hua̱k minacú, ixli̱hua̱k mili̱stacni, ixli̱hua̱k mili̱tlihueke, ixli̱hua̱k mintalacapa̱stacni, y na̱ chuná caca̱lakalhámanti hua̱k minta̱cristianos na̱ chuná la̱ lacasquina calakalhamanca.” ");
INSERT INTO topNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús huánilh: ―Tancs kalhti̱nani̱ta. Para latapa̱ya la̱ quihuanini̱ta, xli̱ca̱na pa̱t lakma̱xtuya mili̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero amá chixcú taquilhtla̱ni̱pútulh y kalasquinipá: ―¿Y ticu yá quinta̱cristianos quimini̱ní nacca̱lakalhamán? ");
INSERT INTO topNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús kálhti̱lh: ―Cama̱kachakxi jaé takalhchihuí̱n ni̱ma̱ cama huaniyá̱n: Maktum quilhtamacú cha̱tum tali̱pa̱u judío táxtulh nac Jerusalén, ixama pakán nac Jericó; pero nac tijia tali̱pa̱táxtulh makapitzi kalha̱naní̱n y hua̱k tamáklhti̱lh tú ixlí̱n y todavía ta̱kkaxími̱lh y ta̱kxtákmi̱lh la̱ xaní̱n aná nac tijia. ");
INSERT INTO topNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ixli̱punchú pasá̱rlalh cha̱tum cura xalac Jerusalén; huata acxílhmi̱lh y ni̱ maktá̱yalh, ti̱tum alh. ");
INSERT INTO topNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ixli̱punchú na̱ pasá̱rlalh cha̱tum levita tí itscuja nac pu̱siculan; na̱ huata acxílhmi̱lh y ti̱tum alh. ");
INSERT INTO topNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero ixli̱punchú pasá̱rlalh cha̱tum chixcú xalac Samaria; acxni ácxilhli lakalhámalh la̱ ixtlahuacani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xlá ma̱lacatzúhui̱lh, tzúculh cuchí ana ní ixla̱kalhi̱cani̱t, huilí̱nilh aceite y cuchu y tla̱n li̱chí̱nilh lháka̱t. A̱stá̱n má̱cxtulh nac ixquitzistanca tá̱alh nac ca̱chiquí̱n y amá ca̱tzisní huá cuéntajli. ");
INSERT INTO topNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ixli̱cha̱lí amá samaritano má̱xtulh mactuy tumi̱n y má̱xqui̱lh ixpu̱chiná amá ákxtaka y huánilh: “Camaktákalhti jaé chixcú y para tú ma̱s li̱lactlahuaya, aquit nacxokoniyá̱n acxni nacqui̱taspita.” ");
INSERT INTO topNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chí huix quihuani, la̱ta ixli̱cha̱tutucán, ¿ticu puhuana li̱máca̱lh ixta̱cristiano tí nalakalhamán amá chixcú tí ixtala̱kalhi̱ni̱t kalha̱naní̱n? ");
INSERT INTO topNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Amá skalala chixcú kálhti̱lh Jesús: ―Tí li̱máca̱lh ixta̱cristiano huá amá tí maktá̱yalh. ―Pues na̱ camakslihueke namá samaritano y caca̱makta̱ya minta̱cristiano tí tamaclacasquín ―huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ca̱ta̱ta̱yapá ixapóstoles nac tijia y cha̱lh nac aktum actzu̱ ca̱chiquí̱n; aná ca̱ta̱maklhtátalh cha̱tum pusca̱t huanicán Marta. ");
INSERT INTO topNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Xlá ixta̱lama ixta̱cam ixuanicán María. Jaé pusca̱t curucs tahui lacatzú ní ixuí Jesús xlacata nakaxmata ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ixlacapalama ixca̱xtlahuama tahuá nac cocina. Entonces ma̱lacatzúhui̱lh Jesús y huánilh: ―Quimpu̱chinacán, ¿puhuana tla̱n la̱ quinta̱makxtaka quinta̱cam aquit nacactahuacakó tascújut? Cahuani catláhualh li̱tlá̱n caquimaktá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús kálhti̱lh: ―Marta, koxitá huix Marta, huix li̱ta̱yaya mintascújut y huata li̱puhuana tú mili̱tláhuat jaé chichiní, ");
INSERT INTO topNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero María ma̱s ta̱yanini̱t porque taka̱sni̱t tla̱n tijia. Xlá kaxmatni̱t quintachihuí̱n y aquit ni̱ cama li̱huaní camákxtakli tijia ni̱ma̱ taka̱sni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maktum quilhtamacú Jesús ixkalhtahuakanima Dios; la̱ kalhtahuakako̱lh cha̱tum ixdiscípulo huánilh: ―Quimpu̱chinacán, quila̱ma̱si̱níu la̱ nackalhtahuakaniyá̱u Dios na̱ chuná la̱ Juan ixca̱ma̱si̱ní tí ixtakaxmata ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús ca̱kálhti̱lh: ―Acxni nakalhtahuakaniyá̱tit Dios chuné nahuaná̱tit: Quinti̱cucan Dios, huix lápa̱t nac akapú̱n, huata huix mini̱ní nacca̱lakachixcuhui̱yá̱n. Cama̱lacatzuqui mintapáksi̱t nac quinacujcán. Cama̱kantaxti tú laclhca̱ni̱ta nac ca̱quilhtamacú na̱ chuná la̱ kantaxtú nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Quila̱ma̱xquí̱u quintahuajcán tú nacli̱latama̱yá̱u cha̱li cha̱lí. ");
INSERT INTO topNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Quila̱ma̱tzanke̱naníu quintala̱kalhi̱ncán na̱ chuná la̱ aquín cca̱ma̱tzanke̱naniyá̱u xa̱makapitzi tí quinca̱tlahuaniyá̱n tú ni̱ tla̱n. Ni̱cxni quila̱kxtakmakáu xlacata tlajaná ni̱ naquinca̱ma̱tlahui̱yá̱n tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús na̱ huánilh jaé takalhchihuí̱n: ―Para cha̱tum chixcú kalhí ixamigo y punchú tzisuani̱t lacatzú tzi̱sa lakán y huaní: “Amigo, quima̱xqui mactutu simi̱ta ");
INSERT INTO topNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porque apenas chilh cha̱tum quili̱talakapasni xala mákat y ni̱ ckalhí tú nacta̱huá.” ");
INSERT INTO topNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","¿Tucu puhuaná̱tit nakalhti̱cán? Amá ixamigo nakalhtí: “Ni̱ caquiakaxculi. Xapuhui̱lhta quínchic tla̱n taxtucún, quincamán y aquit clhtatama̱nahuá. Ni̱ lá cta̱quí xlacata nacma̱xqui̱yá̱n tú quimaksquina.” ");
INSERT INTO topNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pero amá chixcú ni̱ li̱makxtaka lakatlaka puhui̱lhta hasta xní ta̱quí ixamigo y ma̱liqui̱ní puhui̱lhta y ma̱xquí tú maclacasquín xlacata yaj na̱kaxculí. ");
INSERT INTO topNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Aquit xli̱ca̱na cca̱huaniyá̱n, camakslihuekétit jaé chixcú; camaksquíntit Dios tú maclacasquiná̱tit y xlá naca̱ma̱xqui̱yá̱n; caputzátit tú lacasquiná̱tit y pa̱t taka̱sá̱tit; calakatláktit puhui̱lhta y xlá naca̱ma̱lacqui̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque cati̱huá tí squin tú lacasquín, ma̱xqui̱cán; tí putzá tú makatzanká, taka̱sa; y tí lakatlaka pu̱hui̱lhta, ma̱lacqui̱nicán. ");
INSERT INTO topNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Chí quila̱huaníu, ¿ticu yá xati̱cú ma̱xquí ixkahuasa actzu̱ chíhuix para maksquín actzu̱ simi̱ta? O, ¿para maksquín tamakní puhuaná̱tit nama̱xquí tantum lu̱hua? ");
INSERT INTO topNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, ¿para maksquín aktum kálhua̱t puhuaná̱tit nama̱xquí tantum tá̱scuyu? ");
INSERT INTO topNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Huixín catzi̱yá̱tit ma̱squi cristianos lacsnú̱n talani̱t tama̱xquí ixcamancán tú lactlá̱n. Huá cca̱li̱huaniyá̱n, ¿nicu li̱puhuaná̱tit Dios ni̱ naca̱ma̱xqui̱yá̱n tú maclacasquiná̱tit? Hasta ama ca̱ma̱xqui̱yá̱n ixli̱tlihueke Espíritu Santo para huixín maksquiná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Cha̱tum chixcú ixmactanu̱ni̱t ixespíritu tlajaná y ko̱ko ixtlahuani̱t. Jesús macmá̱xtulh amá ixespíritu tlajaná y amá chixcú tuncán tzúculh tla̱n chihui̱nán. Lhu̱hua cristianos tacá̱cni̱lh ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero makapitzi ixtahuán: ―Namá chixcú tla̱n ca̱tamacxtú tlajananí̱n porque Beelzebú xapuxcu tlajananí̱n ma̱xquí ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Makapitzi ixtali̱cxilhputún Jesús y tahuánilh caca̱li̱ma̱lacahuá̱ni̱lh aktum ixtascújut nac akapú̱n para xli̱ca̱na huá Cristo. ");
INSERT INTO topNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero como xlá ixca̱lakapasa ixtalacpuhua̱ncán ca̱huánilh: ―Para nac aktum pu̱latama̱n hua̱k ma̱paksi̱naní̱n tatapitzí y tara̱nica, ni̱ para maka̱s tata̱yaní tara̱lactlahuakó. Na̱ chuná para nac aktum pu̱táhui̱lh tzucú tara̱nica entre li̱talakapasni, ni̱ para maka̱s tata̱kahuani̱kó. ");
INSERT INTO topNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Huá cca̱li̱huaniyá̱n calacpuhuántit para tlajaná ca̱ta̱tapitzí ixcompañeros, ¿niculá nata̱yaní ixli̱ma̱paksí̱n? Huixín huaná̱tit cca̱tamacxtú tlajananí̱n porque cli̱pa̱huán Beelzebú; ");
INSERT INTO topNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","entonces namá mili̱talakapasnicán judíos tí na̱ tatamacxtú tlajananí̱n, ¿na̱ tali̱pa̱huán Beelzebú? Huá cca̱li̱huaniyá̱n, xlacán ama ca̱ma̱lacapu̱yá̱n tú quila̱li̱ya̱huama̱náu. ");
INSERT INTO topNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Aquit cca̱tamacxtú tlajananí̱n porque Dios quima̱xquí ixli̱tlihueke xlacata nacca̱li̱ma̱lacahua̱ni̱yá̱n ixtapaksit Dios ca̱lakchini̱tán nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Huixín catzi̱yá̱tit cha̱tum tlihueke chixcú tla̱n ca̱xtahuilá xlacata namaktakalha tú kalhí nac ixchic y ni̱tí namakkalha̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero para lactaxtú cha̱tum tunu ma̱s tlihueke, an ta̱ra̱nica y makatlajá, maklhti̱kó tú ixli̱maktakalhma ixchic y ma̱kpitzí tú akchípalh. ");
INSERT INTO topNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Chí cca̱huaniyá̱n, tí ni̱ quinta̱ta̱yá nac quintascújut cli̱macá̱n quisi̱tzi̱ní, y tí ni̱ quinta̱ma̱makstoka cristianos natatanú nac quintapáksi̱t, ca̱ma̱kahuaní cata̱ktzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús na̱ ca̱huánilh: ―Acxni cha̱tum ixespíritu tlajaná ma̱xtucán ixmacni cha̱tum chixcú, an latapu̱lí mákat putzá tí namactanú; y para ni̱ taka̱sa lacpuhuán: “Cama taspita nac quínchic ní ctáxtulh.” ");
INSERT INTO topNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Acxni taspita acxila amá chixcú la̱ aktum ákxtaka ni̱ma̱ tla̱n ca̱xya̱huacani̱t y tla̱n taca̱palhni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Entonces an ca̱putzá a̱cha̱tujún tlajananí̱n ni̱ma̱ ma̱s lacli̱cuánit, y pu̱tum tamactanú tata̱latamá amá chixcú. Jaé cristiano ni̱ma̱ ixaksa̱nani̱t ma̱s li̱cuánit huan que la̱ xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Chu̱tacu ixchihui̱nama Jesús la̱ta tzamacán, cha̱tum pusca̱t ma̱ktási̱lh: ―¡Cli̱pa̱xahuá namá pusca̱t tí ma̱lakahuaní̱n y ma̱tziquí̱n! ");
INSERT INTO topNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús kálhti̱lh: ―¡Ma̱s catapa̱xáhualh cristianos tí takaxmata ixtachihuí̱n Dios y tatlahuá tú li̱ma̱paksi̱nán! ");
INSERT INTO topNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Como ma̱s lhu̱hua cristianos tzúculh tatamakstoka ní ixyá Jesús xlá ca̱huánilh jaé takalhchihuí̱n: ―Cca̱li̱lakaputzá namá lacli̱cuánit cristianos tí talama̱na jaé quilhtamacú porque tza̱pu quintamaksquín cacca̱li̱ma̱lacahuá̱ni̱lh quintascújut para xli̱ca̱na aquit Cristo tí ama ca̱lakma̱xtú. Pero huata ama tali̱lacahua̱nán aktum tascújut la̱ amá ni̱ma̱ titláhualh profeta Jonás. ");
INSERT INTO topNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Xlá ca̱li̱ma̱lacahuá̱ni̱lh ixlatáma̱t tí ixtalama̱na nac Nínive xlacata Dios ixma̱lakacha̱ni̱t, pues aquit Xatalacsacni Chixcú na̱ chuná cama ca̱li̱ma̱lacahua̱ní quilatáma̱t cristianos xala jaé quilhtamacú xlacata Dios quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Acxni Dios naca̱ta̱tlahuá taxokó̱n jaé cristianos amá reina xalac Sur ni̱ma̱ milh kaxmata ixtachihuí̱n skalala rey Salomón ama ta̱yá y ama ca̱ma̱lacapu̱yá̱n ixlacati̱n Dios porque huixín ni̱ quila̱kaxmatá̱u ma̱squi juú ca̱ta̱chihui̱namá̱n cha̱tum tí ma̱s skalala que rey Salomón. ");
INSERT INTO topNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na̱ chuná amá cristianos xalac Nínive na̱ ama ca̱ma̱lacapu̱yá̱n ixlacati̱n Dios acxni naca̱ta̱tlahuayá̱n taxokó̱n porque xlacán talakxta̱páli̱lh ni̱ tla̱n ixlatama̱tcán acxni ca̱ma̱kalhchihuí̱ni̱lh profeta Jonás, pero huixín ni̱ quila̱li̱pa̱huaná̱u ma̱squi aquit ma̱s tali̱pa̱u que profeta Jonás. ");
INSERT INTO topNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Huixín catzi̱yá̱tit xlacata ni̱ huí tí ma̱pasí aktum pu̱skon y tla̱n ma̱tze̱ka, o ma̱kalhchahuajú nac cáju̱n, siempre huili̱cán ta̱lhmá̱n xlacata hua̱k natali̱lacahua̱nán ixtaxkáke̱t tí talatanu̱ma̱na nac ákxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mimacnicán kalhí la̱ aktum lámpara y huá milakastapucán. Para milakastapu tla̱n lacahua̱nán, catzi̱ya tú tla̱n y tú ni̱ tla̱n la̱ cakalhi taxkáket. Pero para milakastapu ni̱ tla̱n, aktzanka̱ya tlahuaya tú ni̱ tla̱n la̱ calatapu̱li ca̱paklhtu̱tá. ");
INSERT INTO topNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Huá cca̱li̱huaniyá̱n tla̱n cali̱lacahua̱nántit milakastapucán la̱ aktum lámpara ni̱ma̱ skoyucán ca̱paklhtu̱tá. ");
INSERT INTO topNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Porque para mimacni kalhí tla̱n lakastapu tú li̱lacahua̱nán, ni̱ ca̱paklhtu̱tá lápa̱t, cha̱ ma̱si̱ya ixtaxkáte̱t mintalacapa̱stacni na̱ chuná la̱ aktum lámpara li̱lacahua̱nancán ixtaxkáke̱t. ");
INSERT INTO topNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tunu quilhtamacú cha̱tum fariseo huánilh Jesús caalh hua̱yán nac ixchic. Acxni cha̱lh xlá tuncán pasá̱rlalh nac mesa y tzúculh hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Amá fariseo ni̱ ixcatzí tú nahuán porque Jesús ni̱ makachákalh maklhu̱hua la̱ ixtali̱smani̱ni̱t judíos natalakachixcuhuí Dios antes natahua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Jesús huánilh: ―Huixín ixma̱kantaxti̱naní̱n ixley Moisés scarancua tla̱n chekeyá̱tit mivasojcán y mimpula̱tucán, pero nac mimpu̱lacnicán kalhi̱yá̱tit ni̱ lactlá̱n talacapa̱stacni la̱ nakalha̱naná̱tit y tú li̱xcájnit tlahuayá̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Takalhí̱n lacchixcuhuí̱n! ¿A poco ni̱ catzi̱yá̱tit xlacata tí tláhualh tú cheke̱yá̱tit na̱ tlahuani̱t xala ixpu̱lacni mimacnicán? ");
INSERT INTO topNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ma̱s ixca̱macuanín ixma̱stá̱tit tú tla̱n kalhi̱yá̱tit nac minacujcán la̱ limosna y chuná la̱ta tú cheke̱yá̱tit Dios ixca̱li̱ma̱nu̱nín tla̱n. ");
INSERT INTO topNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Koxitaní̱n huixín ixma̱kantaxti̱nani̱n ixley Moisés! Ma̱xqui̱yá̱tit Dios milimosnajcán hasta tú makalayá̱tit nac minquilhti̱ncán para menta, ruda y ti̱pa̱lhu̱hua ma̱s mintachana̱ncán. Pero ni̱ lacputzayá̱tit la̱ tancs nalatapa̱yá̱tit ixlacati̱n Dios y nala̱lakalhamaná̱tit la̱ huan Dios. Ma̱s ixca̱macuanín ixtlahuátit ixtapáksi̱t Dios nac milatama̱tcán, ma̱squi na̱ mili̱ma̱sta̱tcán milimosnajcán. ");
INSERT INTO topNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Koxitaní̱n huixín fariseos porque siempre lacasquiná̱tit caca̱ma̱xqui̱cántit lactla̱n pu̱táhui̱lh nac sinagoga y lakati̱yá̱tit cati̱huá caca̱huanín kalhé̱n la̱ lactali̱pa̱u cristianos ní tzamacan! ");
INSERT INTO topNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Koxitaní̱n huixín fariseos tí ti̱tanu̱yá̱tit scarancua ma̱kantaxti̱yátit ixley Moisés! Huixín li̱tanu̱yá̱tit la̱ ixpu̱taju̱ncan ni̱n ni̱ma̱ yaj tasí la̱ta li̱punko̱ni̱t li̱cúxtut, y acxni ta̱kspuntza̱lá cristianos ni̱ para tacatzí la̱ ca̱pasá ca̱lakchá̱n tú li̱xcájnit taju̱ma. ");
INSERT INTO topNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Cha̱tum ixma̱kalhtahuake̱nacan judíos kalhpaktánu̱lh Jesús y huánilh: ―Maestro, tú ca̱li̱ya̱huápa̱t namá lacchixcuhuí̱n na̱ quinca̱lakcha̱ná̱n aquín. ");
INSERT INTO topNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Xlá kálhti̱lh: ―¡Xli̱ca̱na! ¡Na̱ koxitaní̱n huixín ma̱kalhtahuake̱naní̱n tí ma̱si̱yá̱tit ixley Moisés! Porque ni̱ caj maktum ca̱ma̱cuqui̱yá̱tit ca̱huaniyá̱tit cristianos catama̱kantáxti̱lh ixlacati̱n Dios lactzu̱ lactzu̱ ixtapáksi̱t, pero huixín ni̱ para tziná puhuaná̱tit ixma̱kantaxti̱yá̱tit nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Koxitaní̱n huixín ixma̱kalhtahuake̱nacan judíos! Porque ca̱makslihuekeyá̱tit amá xalakmaká̱n mili̱talakapasnicán tí tamákni̱lh profetas y huixín ca̱ca̱xya̱huaniyá̱tit ní tataju̱ma̱na. ");
INSERT INTO topNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tú tlahuayá̱tit tla̱n ca̱li̱lakapascaná̱tit xlacata ma̱tla̱ni̱yá̱tit tú tama̱kantáxti̱lh mili̱talakapasnicán. Xlacán tamákni̱lh profetas, y huixín laclá̱n ca̱ca̱xya̱huaniyá̱tit ixpu̱taju̱ncán. ");
INSERT INTO topNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Ixtalacapa̱stacni Dios ni̱tí ma̱ccha̱ní y la̱ta maká̱n tima̱tzokónalh: “Cama ca̱ma̱lakacha̱ní profetas y tí natama̱kahuaní quintachihuí̱n, pero makapitzi ama̱ca ca̱makni̱cán y tunu ama̱ca ca̱ktlakali̱ncán.” ");
INSERT INTO topNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chí cca̱huaniyá̱n, Dios ama ca̱ma̱xoko̱ní jaé cristianos tí talama̱na jaé quilhtamacú ixli̱stacnican hua̱k profetas ni̱ma̱ ca̱makni̱cani̱t la̱ta titláhualh ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ama ca̱ma̱taji̱yá̱n ixli̱stacni profeta Abel hasta ixli̱stacni profeta Zacarías amá tí makni̱ca ixlacatí̱n ixpu̱lakachixcuhui̱can Dios nac pu̱siculan. Aquit cca̱huaniyá̱n xlacata hua̱k huixín pa̱t xoko̱naná̱tit nac milatama̱tcán tú tatlahuani̱t mili̱talakapasnicán. ");
INSERT INTO topNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Koxitaní̱n huixín lakskalala ma̱kalhtahuake̱naní̱n tí ma̱si̱yá̱tit ixley Moisés! Porque li̱kalhtahuakayá̱tit ixtachihuí̱n Dios, pero ni̱ tancs ma̱si̱yá̱tit ixtalacapa̱stacni. Huixín ni̱ ca̱najlayá̱tit ni̱ma̱ cca̱huaniyá̱n y ni̱ para ca̱li̱makxtaká̱tit cataca̱nájlalh xa̱makapitzi cristianos tí quintali̱pa̱huamputún. ");
INSERT INTO topNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","La̱ chihui̱nanko̱lh Jesús amá ixma̱kalhtahuake̱nacan judíos y fariseos tzúculh takalasquiní Jesús ti̱pa̱katzi talacapa̱stacni xlacata natakalhputzá para nali̱chihui̱nán tú ni̱ chuná qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ixtalacasquín ixacstu cali̱taláksi̱lh ixtachihuí̱n xlacata tla̱n natama̱lacapú. ");
INSERT INTO topNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","La̱ta ixchihui̱nama Jesús tzúculh tachín cha̱lhu̱hua mi̱lh cristianos hasta ixtara̱lacxquití. Xlá pu̱la ca̱ta̱chihuí̱nalh ixapóstoles y ca̱huánilh: ―Skálalh cali̱lacahua̱nántit namá fariseos, tí ni̱ ma̱xanán tatalacatla̱ní y lhu̱hua tamakslihueké na̱ chuná la̱ acxni levadura ma̱xcutí squítit. ");
INSERT INTO topNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero tú tze̱k ma̱qui̱cán siempre taka̱scán ixli̱maka̱s, y tú tze̱k tlahuacán siempre catzi̱cán ixli̱maka̱s. ");
INSERT INTO topNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Chí tú huixín tze̱k li̱chihui̱naná̱tit ca̱tzisní, a̱stá̱n ama̱ca li̱chihui̱nancán ca̱cuhui̱ní, y tú scapa scápa chihui̱naná̱tit nac aktum ákxtaka a̱stá̱n ama̱ca li̱chihui̱nancán ixaksti̱n ákxtaka xlacata hua̱k natakaxmata. ");
INSERT INTO topNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Chí cca̱huaniyá̱n huixín ni̱ caca̱jicuanítit cristianos tí ca̱makni̱putuná̱n pues xlacán tla̱n tamakní ixmacni cha̱tum cristiano, pero ni̱ lá tú ma̱s tama̱laksputú. ");
INSERT INTO topNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Aquit camá̱n ca̱huaniyá̱n tí najicuaniyá̱tit: huixín cajicuanítit Dios porque xlá tla̱n makní mimacnicán y na̱ kalhí li̱tlihueke namacá̱n miespiritucán nac puakxtakajni para lacasquín. ¡Huá cajicuanítit! ");
INSERT INTO topNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Chí quila̱huaníu, ¿niculá ixtapalh tanquitzis lactzú spitu? ¿Ni̱ catzi̱yá̱tit xlacata ca̱li̱sta̱cán caj mactuy tumi̱n? Pero Dios ni̱cxni ca̱ktzonksuá y siempre ca̱makta̱yá. ");
INSERT INTO topNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Huá cca̱li̱huaniyá̱n ni̱ cajicuántit. Dios ca̱pu̱tlekeni̱t kanatunu chíxit ni̱ma̱ kalhí miakxa̱kacán. Ni̱ cali̱puhuántit tú pa̱xtoká̱tit pues huixín ixcamán y ma̱s ixtapalh que lhu̱hua lactzu̱ spitu. ");
INSERT INTO topNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Chí cca̱ma̱lacnu̱niyá̱n, amá cristianos tí tali̱ta̱yá quintali̱pa̱huán ixlacati̱ncán cristianos, aquit Xatalacsacni Chixcú na̱ cama li̱ta̱yá huá quidiscípulos ixlacati̱ncán ángeles tí tata̱lama̱na Dios nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero amá cristianos tí ni̱ tama̱luloka quintali̱pa̱huán ixlacati̱ncán lacchixcuhuí̱n, aquit Xatalacsacni Chixcú na̱ ni̱ cama ma̱luloka ixlacati̱ncán ángeles tí tata̱lama̱na Dios nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Chí cca̱huaniyá̱n, amá cristianos tí ni̱tú quili̱cxila ni̱ tla̱n quili̱chihui̱nán tla̱n nama̱tzanke̱nanicán ixtala̱kalhí̱n; pero amá tí li̱kalhkama̱nán tú ca̱li̱ma̱lacahua̱ni̱má̱n ixli̱tlihueke Espíritu Santo ni̱ catima̱tzanke̱nanica ixtala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Acxni naca̱li̱pincaná̱tit nac ixpu̱tamakstoknican judíos, ixlacati̱ncán xanapuxcun ma̱paksi̱naní̱n, o ixlacati̱ncán gobernadores, ni̱tú cali̱puhuántit tú pa̱t huaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porque amá quilhtamacú Espíritu Santo ama ca̱lacati̱ta̱yayá̱n y ama ca̱ma̱cxcatzi̱ni̱yá̱n kastunu tachihuí̱n ni̱ma̱ nakalhti̱naná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","La̱ta tzamacán cha̱tum chixcú huánilh Jesús: ―Maestro, cahuani quinta̱cam caquinta̱tapítzilh herencia ni̱ma̱ quinca̱ta̱makxtakni quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús kálhti̱lh: ―¿Hua̱nchi quila̱putzayá̱u aquit nacli̱tanú juez tí tla̱n nacca̱ma̱pitziniyá̱n herencia ni̱ma̱ kalhi̱yá̱tit? ");
INSERT INTO topNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","A̱stá̱n ca̱ta̱chihuí̱nalh hua̱k cristianos: ―Skálalh calatapá̱tit ni̱ catzaksátit lacputzayá̱tit kalhi̱yá̱tit li̱huacá la̱ tla̱n ma̱ta̱xtucá̱tit, porque quilatama̱tcán ni̱ aná quilhtzucú la̱ta ixli̱lhu̱hua quintumi̱ncán tú tla̱n nama̱ta̱xtucá̱u kalhi̱yá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","’Cakaxpátit tú clacasquín cama̱kachakxí̱tit: Maktum ixlama cha̱tum rico chixcú ixkalhí ixca̱quihuí̱n ni̱ma̱ ixma̱stá lhu̱hua ixtachaná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Como ma̱s y ma̱s ixli̱tahuacama ixtachaná̱n tzúculh lacputzá ní nama̱nu̱kó ixtachaná̱n porque yaj lá ixtanu̱kó nac ixpú̱cuxi. ");
INSERT INTO topNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chuné lacpúhualh: “Cama lactilha namá xalactzú quimpú̱cuxi y cama tlahuá tunu ma̱s xalanca xlacata tla̱n natanu̱kó quintachaná̱n y la̱ta tú cma̱kstokni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Entonces nacuaní quili̱stacni: Chí kalhi̱yá̱u lhu̱hua tumi̱n tú nali̱taxtuniyá̱u maka̱s quilhtamacú. Chí huata cajaxui, cahua̱yáu, cakotui y capa̱xahuáu.” ");
INSERT INTO topNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios huánilh amá chixcú: “Takalhí̱n, pi̱huá jaé ca̱tzisní pa̱t macama̱sta̱ya mili̱stacni. ¿Ticu ama ta̱tamakxtaka y li̱pa̱xahuá la̱ta tú ma̱kstokni̱ta?” ");
INSERT INTO topNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesús ca̱huaniko̱lh: ―Chuná jaé pa̱xtoka cha̱tum chixcú tí ma̱kstoka lhu̱hua tumi̱n ixlacata ca̱quilhtamacú, pero nac ixlacatí̱n Dios la̱ ni̱tú cakálhi̱lh porque ni̱tú li̱macuaní. ");
INSERT INTO topNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A̱stá̱n Jesús ca̱huánilh ixdiscípulos: ―Aquit cca̱ma̱tancsaniyá̱n, huixín ni̱ cali̱puhuántit tú pa̱t huayá̱tit xlacata nali̱latapa̱yá̱tit, ni̱ para milhaka̱tcán tú nahuili̱yá̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Cama̱kachakxí̱tit xlacata mili̱stacnicán ma̱s ixtapalh que mintahuajcán y mimacnicán ma̱s ixtapalh que milhaka̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Huata caca̱li̱lacahua̱nántit la̱ talama̱na lactzú spitu, xlacán ni̱ tachana̱nán, ni̱ para taxka̱nán, ni̱ para tatlahuá ixpu̱cuxicán, ni̱ para tama̱quí ixtahuajcán. Pero Dios siempre ca̱makta̱yá y ca̱ma̱huí. ¡Huixín ixcamán y ma̱s ixtapalh que hua̱k lactzú spitu! ");
INSERT INTO topNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","’Quila̱huaníu, ¿ticu yá cristiano ma̱squi pucuta li̱puhuán tla̱n li̱ma̱huacá a̱laktzú ixlatáma̱t? ");
INSERT INTO topNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Para huixín ni̱ lá li̱ma̱huacayá̱tit ca̱na̱ caj actzú tú lacasquiná̱tit, ¿hua̱nchi li̱puhuaná̱tit tú pa̱t pa̱xtoká̱tit cha̱li cha̱lí? ");
INSERT INTO topNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Caca̱li̱lacahua̱nántit la̱ tastaca lirio xánat; xlacán ni̱ tascuja, ni̱ tatlahuá ixlhaka̱tcán, pero Dios ca̱ma̱lheké; y ma̱squi rey Salomón cakálhi̱lh lhu̱hua lacla̱n ixlháka̱t ni̱cxni ma̱cchá̱ni̱lh lhaka̱nán la̱ tama̱sa̱sti̱nán namá lactzú xánat. ");
INSERT INTO topNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Chí calacpuhuántit, para Dios ca̱ma̱lheké hua̱k li̱cúxtut ma̱squi catzí xlacata chí laclá̱n taya̱na y cha̱lí tasca̱cni̱t xlacata naca̱lhcuyucán, ¿nicu li̱puhuaná̱tit ni̱ catica̱ma̱xquí̱n tú maclacasquiná̱tit huixín ixcamán para li̱pa̱huaná̱tit ixli̱hua̱k minacujcán? ");
INSERT INTO topNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na̱ chuná, ni̱ pucuta caliakatuyúntit tú nali̱hua̱yaná̱tit, o tú nakotá̱tit cha̱li cha̱lí. ");
INSERT INTO topNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ni̱ caca̱makslihuekétit namá cristianos tí ni̱ tali̱pa̱huán Dios. Xlacán tali̱tatlaká ixtahuajcán cha̱li cha̱lí, pero huixín kalhi̱yá̱tit Minti̱cucán tí ca̱maktakalhá̱n y catzí tú maclacasquiná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Chí cca̱huaniyá̱n pu̱la caputzátit li̱pa̱huaná̱tit tú ca̱ma̱lacnu̱nini̱t ixcamán y xlá ixacstu naca̱ma̱xqui̱yá̱n la̱ta tú maclacasquiná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Pu̱tum huixín la̱ quiborregos tí cca̱maktakalha. Ni̱ ca̱katuyúntit porque Dios ma̱tla̱ni̱ni̱t nacca̱ma̱nu̱yá̱n nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Castá̱tit tú kalhi̱yá̱tit y caca̱li̱makta̱yátit xatumi̱n tí ma̱s tamaclacasquín. Ca̱cxilhlacachipítit ma̱stoká̱tit tú ni̱cxni lakó; cama̱stacátit tú nali̱pa̱xahuayá̱tit nac akapú̱n. Aná ni̱cxni catilako̱lh, ni̱ para ama̱ca kalhancán, ni̱ para xumpi̱pi ama ma̱laksputú. ");
INSERT INTO topNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porque huá tú liscuja cha̱tum chixcú ixli̱hua̱k ixnacú nac ixlatáma̱t, aná ama tamakxtaka ixespíritu. ");
INSERT INTO topNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús ca̱huanipá: ―Huixín skálalh catahuilátit ni̱ cama̱mixítit mintaxkake̱tcán ");
INSERT INTO topNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","la̱ amá tasa̱cua tí takalhi̱ma̱na ixpatroncán tí táspitli nac pu̱tamakaxtokni xlacata natama̱lacqui̱ní acxni nachín y nalakatlaka puhui̱lhta. ");
INSERT INTO topNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Amá tasa̱cua tí skálalh tahuila̱na takalhi̱ma̱na ixpatroncán, snu̱n ama tamakapa̱xahuá para ca̱lakchín y ca̱ma̱noklhú ni̱ talhtatama̱na. Pi̱huá ixpatroncán ama ca̱li̱scuja, ama ca̱ma̱xquí ixpu̱tahui̱lhcán nac mesa, ama ca̱ma̱xquí ixtahuajcán y ca̱ta̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jaé patrón tla̱n chin xatu̱ta yá hora, tzi̱sa o xkakama. ¡Catapa̱xáhualh amá tasa̱cua tí ca̱ma̱noklhucán staranc talacahuán! ");
INSERT INTO topNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","40","Na̱ chuná huixín, ¡skálalh catahuilátit quila̱kalhi̱ma̱náu porque ni̱ catzi̱yá̱tit tucu yá hora cama ca̱lakchiná̱n aquit Xatalacsacni Chixcú! Para ixcatzí̱tit tú yá quilhtamacú cama min ixmakslihuekétit amá chixcú tí catzí tú yá hora ama min kalha̱ná, skálalh tahuilá ni̱ lhtatá xlacata ni̱tí natanú namakkalha̱nán nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","La̱ chihui̱nanko̱lh Pedro kalasquínilh: ―Quimpu̱chinacán, ¿jaé takalhchihuí̱n ca̱huanípa̱t hua̱k cristianos xala ca̱quilhtamacú, o huata aquín quinca̱lakcha̱ná̱n tí cca̱ta̱lapu̱layá̱n? ");
INSERT INTO topNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús kálhti̱lh: ―Aquit cca̱li̱chihui̱nama hua̱k cristianos tí ca̱ma̱xqui̱ni̱t Dios aktum tascújut. Na̱ chuná la̱ acxni cha̱tum patrón ma̱cpuxquí cha̱tum tasa̱cua naca̱ma̱huí acxni tatzincsa xa̱makapitzi ixtasa̱cua. Para namá tasa̱cua kaxmata y tlahuá tú li̱ma̱páksi̱lh ixpatrón, ");
INSERT INTO topNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","capa̱xáhualh para ma̱noklhú ixpatrón acxni qui̱taspita tlahuama tú li̱ma̱paksi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Xli̱ca̱na cca̱huaniyá̱n, namá patrón ama macama̱xquí nacuentajní hua̱k la̱ta tú kalhí nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","’Pero ni̱ tla̱n tú ama pa̱xtoka amá tasa̱cua ni̱ma̱ lacpuhuán xlacata ni̱ sok ama taspita ixpatrón y tzucú ca̱ma̱kxtakajní amá tasa̱cua ni̱ma̱ ma̱macqui̱ca naca̱cuentaja la̱ lacchixcuhuí̱n y la̱ lacchaján, y huata li̱puhuán nahua̱yán, nakotnán y nakachí. ");
INSERT INTO topNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Para chuná jaé lama acxni aktziyaj chin ixpatrón y ni̱ para ixpuhuán ama min y ma̱noklhú ni̱ tlahuani̱t tú li̱ma̱páksi̱lh, ama castigartlahuá ma̱lakachá ana ní taxoko̱nán tí ni̱ ta̱kahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Lhu̱hua cristianos ama ca̱ma̱xoko̱ni̱cán ca̱snokcán la̱ jaé tasa̱cua porque ixcatzí tú li̱ma̱páksi̱lh ixpatrón pero ni̱ kaxmatpútulh y ni̱ tláhualh tú huanica. ");
INSERT INTO topNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero amá tasa̱cua tí ni̱ catzí tú li̱ma̱páksi̱lh ixpatrón y tlahuá tú mini̱ní naxoko̱nán ama̱ca li̱ma̱cti̱nicán castigo nasnokcán. Porque amá cristiano tí macama̱xqui̱cani̱t ma̱s lanca tascújut, ma̱s ama xoko̱nán para ni̱ ma̱kantaxtí tú ma̱paksi̱cani̱t; ma̱s ama maksquincán tí ma̱s macama̱xqui̱cani̱t talacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús ca̱huanipá: ―Aquit cmini̱t ma̱pasí lhcúya̱t ca̱quilhtamacú porque quintapáksi̱t ni̱ma̱ cama ma̱lacatzuquí ama li̱tzucú tasi̱tzi y ¡clacasquín ixpasalhá jaé lhcúya̱t! ");
INSERT INTO topNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero pu̱la ama̱ca quili̱cxilhcán aktum ta̱kxtakajni a ver para cta̱yaní y quinacú akxtakajnama nahuán hasta xní nakantaxtukó tú quilaclhca̱nicani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Quila̱huaníu, ¿puhuaná̱tit huixín cmini̱t ca̱ma̱xquí li̱pa̱xáu latáma̱t cristianos ca̱quilhtamacú? ¡Tó! Porque caj quilacata ama li̱tzucú tasi̱tzi. ");
INSERT INTO topNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nac aktum pu̱táhui̱lh para talama̱na cha̱quitzis li̱talakapasni, cha̱tutu ama quintalakalhamán y cha̱tuy ni̱ ama quintali̱pa̱huán, chuná jaé cha̱tuy ama tata̱ra̱nica xa̱cha̱tutu. ");
INSERT INTO topNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Cha̱tum xati̱cú ama si̱tzi̱ní ixkahuasa para ni̱ quili̱pa̱huán, y xakahuasa ama si̱tzi̱ní ixti̱cú para xlá ni̱ quili̱pa̱huán. Cha̱tum xana̱na ama si̱tzi̱ní istzuma̱t y xatzuma̱t ama si̱tzi̱ní ixna̱na; xapuhuiticha̱t ama ta̱ra̱makasi̱tzí ixpuhuiti̱ní y xapuhuiti̱ní ama si̱tzi̱ní ixpuhuiticha̱t para ni̱ quili̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ca̱huanipá: ―Huixín acxni acxilá̱tit tzucú taxtú tzitzeke puclhni pakán ixtampaján huaná̱tit: “Chí ama min se̱n”, y xli̱ca̱na chú qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Acxni suanc tatu̱tá y tzucú min skahuihui u̱n huixín huaná̱tit: “Chí ama lhca̱cnán”, y xli̱ca̱na chú qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Laktakalhí̱n lacchixcuhuí̱n! Huixín tla̱n quilhchipiná̱tit niculá ama min quilhtamacú acxni talacaya̱huayá̱tit acxilá̱tit akapú̱n y quilhtamacú; pero chí, ¿hua̱nchi ma̱squi acxilá̱tit tú cca̱li̱ma̱lacahuani̱yá̱n ni̱ acxcatzi̱yá̱tit tú ca̱lakchini̱tán? ");
INSERT INTO topNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Hua̱nchi ni̱ lacputzayá̱tit mi̱cstucán ca̱li̱tlá̱n lacca̱xtlahuayá̱tit tú ma̱s ca̱mini̱niyá̱n nac milatama̱tcán? ");
INSERT INTO topNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Para cha̱tum cristiano ni̱ acxilhputuná̱n y ama ma̱lacapu̱yá̱n nac pu̱ma̱paksi̱n, nac tijia ca̱li̱tlá̱n cata̱lacca̱xla xlacata ni̱ namacama̱sta̱yá̱n ixmacán juez porque xlá tla̱n macama̱sta̱yá̱n ixmacán policías, y policías natamacanu̱yá̱n nac pu̱la̱chi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y para chú qui̱taxtú aná pa̱t tanu̱ya hasta xní naxoko̱nana hua̱k la̱ta tú li̱pina. ");
INSERT INTO topNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Maktum quilhtamacú Jesús li̱ta̱chihui̱nanca la̱ Pilato ixli̱ma̱paksi̱nani̱t caca̱makni̱ca makapitzi lacchixcuhuí̱n xalac Galilea acxni ixca̱makni̱ma̱ca quitzistancaní̱n tú nali̱lakachixcuhui̱nancán nac lanca pu̱siculan xla Jerusalén y lakxtum tama̱stájalh ixkalhnicán. ");
INSERT INTO topNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ca̱kálhti̱lh: ―¿Puhuaná̱tit huixín namá lacchixcuhuí̱n chú ta̱kspúlalh porque ixtakalhí ma̱s tala̱kalhí̱n que xa̱makapitzi lacchixcuhuí̱n xalac Galilea? ");
INSERT INTO topNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Tó! Ni̱ huá xlacata; xlacán ni̱ ixtakalhí ma̱s tala̱kalhí̱n, pero huixín na̱ chuná tla̱n akspulayá̱tit para ni̱ lakxta̱pali̱yá̱tit ni̱ tla̱n milatama̱tcán y li̱pa̱huaná̱tit Dios. ");
INSERT INTO topNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Na̱ ca̱ksántit amá cha̱cu̱tzayán cristianos tí ca̱ctáma̱lh torre nac Siloé y hua̱k ca̱makni̱ko̱lh. ¿A poco xlacán ixtakalhí ma̱s takalhí̱n que tí ixtalama̱na nac Jerusalén? ");
INSERT INTO topNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Tó! Ni̱ huá xlacata chú taliakspúlalh; pero chí cca̱huaniyá̱n, huixín na̱ chuná tla̱n akspulayá̱tit para ni̱ lakmakaná̱tit mintala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ca̱huánilh jaé takalhchihuí̱n: ―Cha̱tum chixcú chalh nac ixca̱tucuxtu akatum suja y ca̱ta cá̱ta ixán acxila para kalhi̱yá ixtahuácat, pero ni̱tú ixtaka̱sní. Hasta liakatzánka̱lh ");
INSERT INTO topNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","y maktum huánilh ixtasa̱cua tí ixmaktakalhní ixtachaná̱n: “Kalhí aktutu ca̱ta la̱ta ctíchalh jaé suja y ni̱cxni ctaka̱snini̱t ixtahuácat. ¡Chí tuncán catanca porque huata chu̱tá akchipama tíyat!” ");
INSERT INTO topNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ixtasa̱cua kálhti̱lh: “Cali̱makxtakuí a̱ktum ca̱ta; tla̱n cama lakcuxtú y cama huili̱ní abono, ");
INSERT INTO topNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","a ver para chú nama̱stá ixtahuácat, y xa̱ktum ca̱ta para ni̱ tahuacá entonces nactancá tuncán.” ");
INSERT INTO topNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Maktum quilhtamacú sábado Jesús alh ca̱ma̱kalhchihui̱ní cristianos nac ixpu̱tamakstoknicán judíos, ");
INSERT INTO topNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","y aná ixtanu̱ma cha̱tum pusca̱t ixkalhi̱yá akcu̱tzayán ca̱ta la̱ta cha̱tum ixespíritu tlajaná ixma̱lacatzuqui̱ni̱t tá̱tat, yaj lá ixtatancsa a̱huata puncs puncs ixtla̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Acxni ácxilhli Jesús tasánilh amá pusca̱t y huánilh: ―Chí tuncán cama ma̱ke̱nu̱niyá̱n mintá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Huilí̱nilh ixmacán nac ixmacni amá pusca̱t y tuncán aksá̱nalh. ¡Tla̱n tátancsli! A̱stá̱n tzúculh pa̱xcatcatzi̱ní Dios tú ixtlahuani̱t ixlacata. ");
INSERT INTO topNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero amá xapuxcu chixcú tí ixakchihui̱nán nac ixpu̱tamakstoknicán judíos sí̱tzi̱lh xlacata Jesús ixma̱ksa̱ni̱nani̱t amá chichiní acxni ixli̱huancán tí nascuja y chuné ca̱huánilh cristianos: ―Kalhi̱yá̱tit akcha̱xán chichiní xlacata nascujá̱tit tlahuayá̱tit tú lacasquiná̱tit. Acxni calaktántit jaé chixcú xlacata naca̱ma̱ksa̱ni̱yá̱n ni̱ calaktántit jaé quilhtamacú acxni ni̱tú quili̱tlahuatcán. ");
INSERT INTO topNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús kalhpaktánu̱lh: ―¡Huixín ni̱ lacama̱xananá̱tit akskahuinaní̱n lacchixuhuí̱n! Quila̱huaníu, ¿ticu ni̱ xcuta ixburro, o ixuá̱cax jaé chichiní acxni li̱huancán tí nascuja y an ma̱kotí? ");
INSERT INTO topNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Chí calacpuhuántit, jaé pusca̱t ixli̱talakapasni Abraham, pero la̱ta akcu̱tzayán ca̱ta tlajaná ixmactanu̱ni̱t ixma̱lacatzuqui̱nini̱t tá̱tat, y ¿puhuaná̱tit ni̱ mini̱ní namacma̱xtucán tlajaná jaé chichiní acxni li̱huancán tí nascuja? ");
INSERT INTO topNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesús ca̱li̱ma̱ma̱xáni̱lh ixtachihuí̱n amá ixenemigos ixlacati̱ncán cristianos y hua̱k cristianos ixtali̱pa̱xahuá laclanca ixtascújut ni̱ma̱ ixca̱li̱ma̱lacahua̱ní Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús na̱ ca̱huánilh: ―Quintapáksi̱t ni̱ma̱ quimacama̱xqui̱ni̱t Dios nacma̱lacatzuquí ca̱quilhtamacú camá̱n ca̱li̱ma̱lacastucniyá̱n jaé takalhchihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ama qui̱taxtú la̱ acxni cha̱tum chixcú an chan nac ixca̱tucuxtu aktum ixtalhtzi mostaza. Jaé actzu̱ talhtzi tzucú staca y staca, y lanca quihui huan hasta lactzú spitu ni̱ma̱ cani̱huá takospu̱lá tla̱n tatlahuá ixma̱sekecán nac ixakán. ");
INSERT INTO topNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na̱ cama ca̱ta̱ma̱lacastucniyá̱n ixtapáksi̱t Dios ni̱ma̱ cama ma̱lacatzuquí ");
INSERT INTO topNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","la̱ levadura ni̱ma̱ ta̱tlahuá cha̱tum pusca̱t ixharina. Levadura lakasu̱t tzucú scuja hasta tachixkó hua̱k itsquítit. ");
INSERT INTO topNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús a̱huatiyá ti̱huán chípalh tijia ni̱ma̱ ixán pakán nac Jerusalén. Katunu ca̱chiquí̱n y ca̱tucuxtu ní ixti̱taxtú ixtamakxtaka laktzu quilhtamacú xlacata naca̱ma̱kalhchihui̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Maktum cha̱tum chixcú kalasquínilh: ―Quimpu̱chinacán, ¿caj actzu cristianos ama talakma̱xtú ixli̱stacnicán? ");
INSERT INTO topNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Xlá kálhti̱lh: ―Tí tataxtuniputún catapútzalh talactanú namá ti̱tzú puhui̱lhta, porque ama cha̱n quilhtamacú acxni lhu̱hua cristianos ama tatanu̱putún, pero yaj lá ama tatanú ");
INSERT INTO topNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","porque ixpu̱chiná mili̱stacnicán ma̱lacchahuani̱ttá nahuán puhui̱lhta. Ama tzucú talakatlaka puhui̱lhta y natahuaní: “Quimpu̱chinacán, caquila̱ma̱lacqui̱níu.” Pero xlá ama ca̱kalhtí: “Aquit ni̱ cca̱lakapasá̱n ticu huixín.” ");
INSERT INTO topNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Entonces ama takalhti̱nán: “¿Hua̱nchi huana ni̱ quila̱lakapasá̱u, aquín lakxtum cca̱ta̱hua̱yani̱tán y xackaxmatá̱u mintachihuí̱n nac quinca̱chiqui̱ncán?” ");
INSERT INTO topNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Xlá ama ca̱huaní: “¡Catake̱nú̱tit ní cyá lacli̱xcájnit ixtlahuananí̱n tala̱kalhí̱n! ¡Tancs cca̱huaniyá̱n aquit ni̱ cca̱lakapasá̱n!” ");
INSERT INTO topNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Lhu̱hua ama ta̱cxila Abraham, Isaac, Jacob y xa̱makapitzi profetas tahuila̱na nac lactlá̱n ixpu̱tahui̱lhcán ni̱ma̱ ca̱ma̱xqui̱ni̱t Dios y huixín pa̱t ca̱ma̱kxtakajni̱caná̱tit a̱lacatunu. Aná pa̱t lakaputzayá̱tit y tasayá̱tit la̱ta li̱puhuaná̱tit tú ni̱ tla̱n tlahuani̱tántit. ");
INSERT INTO topNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na̱ chuná pa̱t lakaputzayá̱tit acxni naca̱cxilá̱tit nac akapú̱n ti̱pa̱katzi cristianos xala cani̱huá ca̱quilhtamacú tapa̱xahuama̱na tahuila̱na nac ixpu̱tahui̱lhcán ni̱ma̱ ca̱ma̱xqui̱ni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Aná lhu̱hua cristianos tí ca̱lakmakancán juú ca̱quilhtamacú ixpakstá̱n ca̱maca̱ncán, aná pu̱la ama̱ca ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán; y tí ca̱ma̱pu̱li̱cán juú ca̱quilhtamacú pu̱la ca̱ma̱xqui̱cán ixpu̱tahui̱lhcán, aná ixpakstá̱n ama̱ca ca̱maca̱ncán. ");
INSERT INTO topNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Makapitzi fari̱seos talákchilh Jesús y tahuánilh: ―Cataxtu capit a̱lacatunu porque rey Herodes makni̱putumá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús ca̱kálhti̱lh: ―Capítit huaniyá̱tit namá mañoso chixcú xlacata chí y cha̱lí cca̱tamacxtuma nahuán tlajananí̱n xmacnicán cristianos y cca̱ma̱ksa̱ní ta̱tatlaní̱n pero ni̱ ccatzí para tu̱xama clako̱ni̱t nahuán quintascújut. ");
INSERT INTO topNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Porque tamaclacasquiní naclakchá̱n tijia ni̱ma̱ clactanu̱ni̱t chí, cha̱lí, li̱tu̱xama porque hua̱k lactali̱pa̱u profetas tama̱kantaxtí ca̱makni̱cán nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jesús lakaputzako̱lh ixnacú y chuné chihuí̱nalh: ―¡Jerusalén! ¡Koxita quinca̱chiqui̱n Jerusalén! Juú ca̱makni̱cani̱t hua̱k lactali̱pa̱u profetas y ca̱ctalali̱ncán lacchixcuhuí̱n tí ca̱ma̱lakacha̱ni̱t Dios namakta̱yayá̱n. Ni̱ caj maktum aquit cca̱ma̱makstokpútulh quincamán xala jaé ca̱chiquí̱n, na̱ chuná la̱ tantum cha̱t xti̱la̱n ca̱ma̱makstoka itskatá̱n ca̱pa̱tanú y lacatum ca̱ta̱tahuilá. ¡Xlacán ni̱ tama̱tlá̱ni̱lh tú cca̱ma̱lacnú̱nilh! ");
INSERT INTO topNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pero talaktzanka̱ni̱t porque yaj maka̱s tzanká acxni hua̱k ákxtaka ama̱ca ca̱kxtakmakancán. Y cca̱huaniyá̱n, yaj amá̱n quila̱cxilá̱u asta xní nachá̱n quilhtamacú huixín naquila̱maklhti̱naná̱u y nahuaná̱tit: “Clakachixcuhui̱yá̱u namá chixcú tí ma̱lakacha̱ni̱t Quimpu̱chinacán.” ");
INSERT INTO topNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Maktum quilhtamacú acxni ni̱tí itscuja, Jesús alh hua̱yán nac ixchic cha̱tum xapuxcu fariseo. Pero makapitzi ixtascalima̱na ");
INSERT INTO topNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","para nama̱ksa̱ní cha̱tum chixcú ni̱ma̱ ixlaccuni̱t y aná ixyá lacatzú. ");
INSERT INTO topNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xlá ixcatzí ixtalacpuhua̱ncán y ca̱kalasquínilh amá fariseos y ixma̱kalhtahuake̱nacán judíos: ―¿Puhuaná̱tit huixín mini̱ní ma̱ksa̱ni̱cán, o ni̱ ma̱ksa̱ni̱cán cha̱tum chixcú acxni li̱huancán tí nascuja? ");
INSERT INTO topNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Como xlacán ni̱ takálhti̱lh, Jesús li̱macxámalh ixmacán amá ta̱tatlá y tuncán aksá̱nalh; a̱stá̱n huánilh caalh nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pero amá ixma̱kantaxti̱nani̱n ixley Moisés ca̱kalasquínilh: ―¿Huixín ni̱ tatza̱lh piná̱tit ma̱cutuyá̱tit xlacata ni̱ cani̱lh tantum miburrojcán o mihua̱caxcán para pa̱tastá nac aktum pozo namá chichiní acxni li̱huancán tí nascuja? ");
INSERT INTO topNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Xlacán ni̱ para chú takálhti̱lh ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús ca̱li̱lacahuá̱nalh xa̱makapitzi lacchixcuhuí̱n la̱ ixtaputzá lactla̱n pu̱táhui̱lh nac mesa ní ixama tahua̱yán. Xlá ca̱huánilh jaé takalhchihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Aquit cca̱huaniyá̱n, acxni pina nac aktum pu̱tamakaxtokni, ni̱ caputza tahuilaya nac tla̱n pu̱táhui̱lh porque qué tal para chin cha̱tum ma̱s tali̱pa̱u que huix. ");
INSERT INTO topNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Entonces xapu̱chiná nahuaniyá̱n: “Catlahua li̱tlá̱n catake̱nu y cama̱xqui mimpu̱táhui̱lh jaé chixcú.” ¡Snu̱n li̱ma̱xaná naqui̱taxtuniyá̱n la̱ta tzamacán napina tahuilaya hasta ixpakstá̱n! ");
INSERT INTO topNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Huá cca̱li̱huaniyá̱n huix siempre catahuila hasta ixpakstá̱n pu̱táhui̱lh y xapu̱china ákxtaka acxni na̱cxilá̱n naminá̱n huaniyá̱n: “Amigo, catalacatzu̱hui, juú huí ma̱s tla̱n pu̱táhui̱lh milacata.” Chuná hua̱k tí tahuila̱na nac mesa nata̱cxila la̱ li̱pa̱huaná̱n xapu̱chiná. ");
INSERT INTO topNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aquit cca̱huaniyá̱n, amá tí ixacstu lactaxtú tali̱pa̱u ama̱ca makxtakcán hasta ixpakstá̱n, y amá tí acs tamakxtaka ni̱ lactlancán ama̱ca ma̱xqui̱cán tla̱n ixpu̱táhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","A̱stá̱n ta̱chihuí̱nalh amá fariseo tí ixuanini̱t caalh hua̱yán nac ixchic: ―Acxni natlahuaya li̱lakastá̱n, ni̱ caca̱huani catámilh xalacricos mivecinos, xalactali̱pa̱u miamigos, minata̱camán, o mili̱talakapasni, porque xlacán na̱ natata̱hua̱yaná̱n y chuná nataxokoniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Huix acxni tlahuaya li̱lakastá̱n ma̱s macuaniyá̱n caca̱ta̱huá̱yanti pobres, tí ni̱tú takalhí, tí lakatzí̱n y tí tatakalhi̱ni̱t nac ixmacxpa̱ncán o nac ixcha̱xpa̱ncán ni̱lá tascuja. ");
INSERT INTO topNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huix capa̱xahua ni̱ ca̱katúyunti para ni̱ lá taxokoniyá̱n, pero Dios acxilhmá̱n y hua̱k ama lakapu̱xokoniyá̱n amá quilhtamacú acxni naca̱ma̱lacastacuaní ixcamán tí ca̱lacsacni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cha̱tum chixcú tí ixtahua̱yama̱na nac mesa acxni káxmatli jaé tachihuí̱n huá: ―Ama pa̱xahuá ni̱ ama aktuyún namá cristiano tí tla̱n naca̱ta̱hua̱yán tí natachá̱n nac akapu̱n ixpa̱xtu̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero Jesús chuné kálhti̱lh: ―Cha̱tum chixcú tláhualh li̱lakastá̱n, ca̱ma̱lakachá̱nilh tachihuí̱n catámilh hua̱k xalactali̱pa̱u ixamigos. ");
INSERT INTO topNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Acxni ixca̱xlako̱ni̱t tahuá huánilh ixtasa̱cua caalh ca̱huaní amá lacchixcuhuí̱n xlacata catamilhá tahua̱yán porque ixca̱xlako̱ni̱ttá tahuá. ");
INSERT INTO topNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero xlacán tzúculh tataquilhtla̱ní xlacata ni̱ lá ixtaán. Cha̱tum kalhtí̱nalh: “Apenas ctamá̱hualh quinca̱quihuí̱n y cama acxila, huá ni̱ lá cli̱án.” ");
INSERT INTO topNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Xa̱cha̱tum huá: “Apenas ctama̱huani̱t tanquitzis quihuá̱cax cama ca̱li̱cxila para tla̱n tacha̱lhca̱tnán. Quima̱tzanke̱nani ni̱ lá can.” ");
INSERT INTO topNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A̱cha̱tum huá: “Apenas ctamakaxtokni̱t y huá xlacata ni̱ lá cli̱án nac fiesta.” ");
INSERT INTO topNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Amá tasa̱cua táspitli y li̱ma̱kalhchihuí̱ni̱lh ixpatrón la̱ ixtakalhti̱ni̱t amá ixamigos. Xlá li̱cuánit sí̱tzi̱lh y li̱ma̱páksi̱lh ixtasa̱cua: “Capit nac ca̱lactijyí̱n y nac li̱tamá̱u xala ca̱chiquí̱n y caca̱huani catámilh nac fiesta tí pobres ni̱tú takalhí, tí ni̱ lá tacha̱lhca̱tnán, tí lakatzí̱n y tí ni̱ lá tatla̱huán.” ");
INSERT INTO topNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jaé tasa̱cua ca̱lí̱milh nac fiesta hua̱k cristianos tí ca̱táka̱sli cani̱huá, pero todavía kalhtá̱xtulh lhu̱hua pu̱táhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ixpatrón huanipá: “Chí capit nac ca̱lactijyí̱n y ana ní tzamacán y caca̱ktlakahuaca hua̱k cristianos tí ca̱taka̱sa y ca̱cxila catámilh quintata̱pa̱xahuá nac quiákxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","¡Yaj clacasquín catámilh tahua̱yán namá quiamigos ni̱ma̱ xacca̱ma̱tunujnini̱t ixpu̱tahui̱lhcán nac quiákxtaka!” ");
INSERT INTO topNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Como lhu̱hua cristianos ixtatakoké cha̱li cha̱lí maktum ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Amá cristiano tí quintakokeputún li̱tanu̱putún quidiscípulo, tamaclacasquiní naca̱li̱makxtaka acxni tamaclacasquiní ixti̱cú, ixna̱na, ixta̱cha̱t, ixcamán, ixnata̱camán, y ni̱ para ixli̱stacni calakcátzalh para makatzanká caj quilacata. ");
INSERT INTO topNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Porque aquit huata cli̱macá̱n quidiscípulo amá cristiano tí li̱tamakxtaka akxtakajnán quilacata la̱ cacúcalh aktum culu̱s. ");
INSERT INTO topNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Amá tí quintakokeputún pu̱la tla̱n calacapa̱stácnalh para ma̱tla̱ní tú cma̱lacnú na̱ chuná la̱ acxni cha̱tum chixcú tlahuaputún aktum ákxtaka, pu̱la tla̱n pu̱tlaké ixtumi̱n para accha̱ní nali̱ma̱sputú. ");
INSERT INTO topNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pues para huata ma̱tzuquí xacimiento y ni̱ tlahuakó xala ta̱lhmá̱n, hua̱k xa̱makapitzi acxni nata̱cxila chuné natali̱kalhkama̱nán: ");
INSERT INTO topNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Namá chixcú ma̱tzúqui̱lh ixchic, pero ni̱ lá ma̱sputú.” ");
INSERT INTO topNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Na̱ cca̱ta̱ma̱lacastucniyá̱n jaé takalhchihuí̱n: ¿Puhuaná̱tit huixín cha̱tum rey sok ta̱ra̱nica ixenemigo para huata kalhí cha̱ca̱u mi̱lh soldados y xa̱cha̱tum rey kalhí cha̱puxum mi̱lh soldados? Pu̱la lacpuhuán para tla̱n nata̱yaní; ");
INSERT INTO topNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","para ni̱ macxpa̱chá̱n la̱ta ya̱ chin xa̱cha̱tum rey ca̱ma̱lakachá makapitzi soldados xlacata natalacca̱xlá ni̱ catará̱nicli. ");
INSERT INTO topNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Huá cca̱li̱huaniyá̱n amá tí li̱tanu̱putún quidiscípulo pu̱la cali̱mákxtakli li̱puhuán la̱ta tú kalhí ca̱quilhtamacú xlacata aquit nacma̱xquí tú nali̱ta̱yaní. ");
INSERT INTO topNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Huixín catzi̱yá̱tit mátzat macuán li̱ma̱skoke̱nancán, pero para namá mátzat makatzanká ixli̱skoke̱n, ¿tucu li̱macuán? ");
INSERT INTO topNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ni̱ para ixli̱ca̱xtlahuacan tíyat macuán, ni̱ para li̱ta̱tlahuacán abono. ¡Ahuata makancán! Na̱ chuná tla̱n ca̱qui̱taxtuniyá̱n huixín huá cca̱li̱huaniyá̱n tí kalhí ixteké̱n cama̱kachákxi̱lh tú cca̱huanimá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana ní ixakchihui̱nán Jesús ixtamín takaxmata ixma̱lakaxoke̱nani̱n tumi̱n y tí ixca̱li̱ma̱nu̱cán tzaca̱tnaní̱n porque ni̱ ixtama̱kantaxtí hua̱k ixley Moisés. ");
INSERT INTO topNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ixma̱kalhtahuake̱nacán judíos y fariseos tí scarancua ixtama̱kantaxtí ixley Moisés ixtali̱chihui̱nán Jesús: ―¿Hua̱na ca̱ta̱talakxtumí namá chixcú tí takalhí tala̱kalhí̱n y hasta ca̱ta̱hua̱yán? ");
INSERT INTO topNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Xlá ca̱huánilh jaé takalhchihuí̱n xlacata natama̱kachakxí hua̱nchi ixca̱ta̱talakxtumí amá cristianos: ");
INSERT INTO topNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Para cha̱tum chixcú kalhí aktum ciento ixborrego y maktum makatzanká tantum, xlá lacatum ca̱makxtaka noventa y nueve ixborrego y lacapala tzucú lacaputzá amá ni̱ma̱ tzánka̱lh hasta xní nama̱noklhú. ");
INSERT INTO topNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y acxni qui̱taka̱sa snu̱n li̱pa̱xahuá hasta akxpakatahuacalí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Acxni cha̱n nac ixchic, ca̱ma̱makstoka ixamigos ixvecinos y ca̱huaní: “Caquila̱ta̱pa̱xahuáu porque ctáka̱sli quiborrego ni̱ma̱ xacmakatzanka̱ni̱t.” ");
INSERT INTO topNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pues na̱ chuná qui̱taxtú nac akapú̱n para juú ca̱quilhtamacú talama̱na aktum ciento cristianos y cha̱tum chipá ni̱ tla̱n tijia, acxni lakxta̱palí ixlatáma̱t y li̱pa̱huampará Dios nac akapú̱n ma̱s li̱pa̱xahuacán jaé chixcú que xa̱makapitzi cristianos ni̱ma̱ ni̱ ta̱ktzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Na̱ cca̱ta̱ma̱lacastucniyá̱n jaé takalhchihuí̱n: Para cha̱tum pusca̱t kalhí maccá̱u lactzu̱ tumi̱n xla plata, acxni makatzanká mactum lacapala ma̱pasí ixpu̱skon y tzucú lactilhnán nac ixchic, quilhpa̱xtum ca̱palha hasta xní qui̱taka̱sa tú makatzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Entonces ca̱huaní ixamigos ixvecinos: “Quila̱ta̱pa̱xahuáu porque ctáka̱sli mactum quintumi̱n ni̱ma̱ xacmakatzanka̱ni̱t.” ");
INSERT INTO topNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na̱ chuná tapa̱xahuá ángeles xalac akapú̱n acxni cha̱tum li̱xcájnit chixcú lakxta̱palí ixlatáma̱t. ");
INSERT INTO topNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ixlacasquín tla̱n catama̱kachákxi̱lh tú ixca̱ma̱si̱niputún y ca̱li̱huanipá jaé takalhchihuí̱n: ―Cha̱tum chixcú ixca̱kalhí cha̱tuy ixlakkahuasán. ");
INSERT INTO topNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Maktum xatajó ixkahuasa huánilh: “Ta̱ta, la̱ta lapa̱tcú clacasquín quima̱xqui quiherencia ni̱ma̱ quintoca̱rlí.” Amá ko̱lú ma̱tlá̱ni̱lh y ca̱ma̱xqui̱lh ixlakkahuasán ixherenciajcán. ");
INSERT INTO topNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ni̱ ixli̱maka̱s amá xatajo ixkahuasa sta̱ko̱lh la̱ta tú maklhtí̱nalh y alh makat pu̱latama̱n. Aná li̱pa̱xáu tzúculh lakasta̱nán, chu̱ta cati̱huá ca̱li̱lactlahuako̱lh hua̱k ixtumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Acxni makásputli ixtumi̱n amá pu̱latama̱n milh tatzíncsnit y tzúculh akxtakajnán porque ni̱ xkalhí tú nali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Alh maksquín tascújut cha̱tum chixcú xala amá pu̱latama̱n y xlá ma̱lakácha̱lh nac ixca̱tucuxtu xlacata namaktakalhní ixpaxni. ");
INSERT INTO topNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Xlá istzincsa hasta ixca̱makuaputún ixtahuajcán paxni ni̱ma̱ ixca̱ma̱hui̱cán huanicán “algarrobas”, pero ni̱tí ixli̱makxtaka cali̱huá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Alh quilhtamacú y tzúculh lacpuhuán: “Nac ixchic quinti̱cú hua̱k tasa̱cua takalhí tú tali̱hua̱yán hasta ca̱kalhta̱xtuní y aquit juú ctzincsni̱ma ni̱ ckalhí tú nacuá. ");
INSERT INTO topNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Para xactáspitli nac quínchic xacuánilh quinti̱cú: Ta̱ta, lhu̱hua quintala̱kalhí̱n cli̱makali̱puhuani̱t Dios nac akapú̱n y na̱ chuná huix cmakali̱puhuani̱tán, ");
INSERT INTO topNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","huá xlacata yaj clacasquín caquili̱ma̱nu la̱ minkahuasa, caquinta̱latapa la̱ cha̱tum mintasa̱cua.” ");
INSERT INTO topNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Xli̱ca̱na amá kahuasa taxtutá̱qui̱lh táspitli nac ixchic ní ixlama ixti̱cú. Alaktzú istzanka̱ní nachá̱n acxni ácxilhli ixti̱cú y tatza̱lh milh lakapa̱xtoka. Akapíxti̱lh lacáspu̱tli ixkahuasa; ¡snu̱n li̱lakapútzalh tú ixpa̱xtokni̱t ixkahuasa! ");
INSERT INTO topNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Xlá huánilh ixti̱cú: “Ta̱ta, lhu̱hua quintala̱kalhí̱n cli̱makali̱puhuani̱t Dios nac akapú̱n na̱ chuná huix lhu̱hua tú cli̱makali̱puhuani̱tán; yaj quimini̱ní naquili̱ma̱nu̱ya la̱ minkahuasa.” ");
INSERT INTO topNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero amá ko̱lú ca̱huánilh ixtasa̱cua: “Lacapala cama̱lheké̱tit quinkahuasa xatla̱n lháka̱t ni̱ma̱ taka̱sá̱tit, cama̱makanú̱tit aktum anillo y cahuili̱nítit ixtatu̱nu nac ixtujún. ");
INSERT INTO topNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Na̱ camakní̱tit tantum ma̱s xakon quihuá̱cax porque amá̱n tlahuayá̱u li̱lakastá̱n amá̱n li̱pa̱xahuayá̱u ");
INSERT INTO topNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","quinkahuasa ni̱ma̱ lacastacuanamparani̱t, pues aquit xacli̱kalhí la̱ xaní̱n porque istzanka̱ni̱t y chí ctaka̱sparani̱t.” Ni̱ para maka̱s tzúculh li̱lakastá̱n nac ixchic amá ko̱lú. ");
INSERT INTO topNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Xapuxcu ixkahuasa ixani̱t scuja ca̱tucuxtu, acxni táspitli ixcha̱majá nac ixchic, káxmatli ixtlaknama̱ca li̱pa̱xáu ixlama tantlí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tuncán kalasquínilh cha̱tum tasa̱cua: “¿Hua̱nchi lama li̱lakastá̱n?” ");
INSERT INTO topNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xlá kálhti̱lh: “Porque taspitni̱t minta̱cam ni̱ma̱ istzanka̱ni̱t y ni̱tú lanini̱t huá xlacata minti̱cú li̱ma̱makni̱ní̱nalh xakon ixuá̱cax.” ");
INSERT INTO topNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Xlá li̱cuánit sí̱tzi̱lh y ni̱ tanu̱pútulh nac fiesta. Ixti̱cú táxtulh y maklhu̱hua huánilh catánu̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero xlá kálhti̱lh ixti̱cú: “Aquit cta̱scujni̱tán lhu̱hua ca̱ta, siempre ckaxmatni̱t tú quili̱ma̱paksi̱ya, pero ni̱cxni quima̱xqui̱ni̱ta ca̱na̱ tantum actzu borrego xlacata nacmakní y nacca̱ta̱pa̱xahuá quiamigos. ");
INSERT INTO topNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero chí acxni lakchiná̱n quintajó tí ca̱li̱lactlahuako̱lh ixtumi̱n cati̱huá lacchaján, huix makni̱ya xakon huá̱cax xlacata natlahuaniya li̱lakastá̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Amá xati̱cú kálhti̱lh: “Tla̱n calacpúhuanti, ti̱cu, huix siempre quinta̱latapa̱ni̱ta y la̱ta tú ckalhí hua̱k tla̱n ma̱paksi̱ya. ");
INSERT INTO topNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero mintajó la̱ xaní̱n ixlama y chí lacastacuanani̱t; istzanka̱ni̱t y chí tasi̱parani̱t. ¡Yaj cata̱klhu̱hui, cali̱pa̱xahuahuí la̱ táspitli mintajó!” ");
INSERT INTO topNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ca̱huánilh ixdiscípulos jaé takalhchihuí̱n: ―Cha̱tum rico chixcú ixkalhí xapuxcu ixtasa̱cua tí ixmaktakalhní ixtascújut y la̱ta tú ixma̱paksí. Pero maktum tzucuca huanicán xlacata amá tasa̱cua ixacma̱xtuma tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Xlá tasánilh y huánilh: “¿Xli̱ca̱na la̱ quihuanicán xlacata huix acma̱xtúpa̱t tumi̱n? Chí tuncán caquintlahuani cuenta la̱ta tú ckalhí porque yaj camá̱n li̱ma̱nu̱yá̱n xapuxcu quintasa̱cua tí quiscujní.” ");
INSERT INTO topNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Jaé tasa̱cua tzúculh lacpuhuán: “¿Tucu cama tlahuá para quimpatrón quimaklhtí quintascújut? Aquit yaj ckalhí li̱tlihueke nacli̱cha̱lhca̱tnán palha tascújut, y cma̱xanán para nacsquihua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pero ccatzi̱yá tú cama tlahuá, cama ca̱ta̱lacca̱xlá namá lacchixcuhuí̱n tí tali̱ní tumi̱n quimpatrón xlacata acxni naquimaklhti̱cán quintascújut tla̱n naquintamakta̱yá xlacán.” ");
INSERT INTO topNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Chuná amá tzúculh ca̱tasaní tí ixtali̱ní ixpatrón. Xla̱huán kalasquínilh: “Huix, ¿niculá li̱piniya quimpatrón?” ");
INSERT INTO topNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Amá chixcú kálhtílh: “Aquit cli̱ní aktum ciento barril xla aceite.” Amá tasa̱cua huánilh: “Xli̱ca̱na, uchu huí mirecibo ni̱ma̱ firmarli, pero calácxti̱tti y catlahua tunu ana ní ma̱luloka xlacata li̱piniya íta̱t ciento huitiyá.” ");
INSERT INTO topNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Acxni chilh xa̱cha̱tum na̱ kalasquínilh niculá ixlí̱n, y xlá kalhtí̱nalh ixlí̱n ixpatrón aktum ciento cúxta̱lh xla trigo. Entonces huánilh: “Xli̱ca̱na chú huan nac recibo ni̱ma̱ firmarli, pero chí catlahua tunu recibo xlacata huata li̱pina íta̱t ciento a̱puxumacá̱u cúxta̱lh.” ");
INSERT INTO topNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Amá patrón hasta cá̱cni̱lh ixli̱skalala amá ni̱ tla̱n ixtasa̱cua la̱ ixlacputzani̱t tla̱n nalatamá a̱stá̱n. Jesús ca̱huaniko̱lh ixdiscípulos: ―Jaé takalhchihuí̱n tla̱n li̱ma̱kachakxi̱yá̱tit xlacata cristianos xala ca̱quilhtamacú tama̱xtú liakskalala acxni talacputzá la̱ natatlahuá tú ni̱ tla̱n hasta tamakatlajá tí tali̱pa̱huán Dios. ");
INSERT INTO topNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Huixín na̱ chuná ca̱macama̱xqui̱cani̱tántit tú namaktakalhá̱tit ca̱quilhtamacú; pues cali̱putzátit tú kalhi̱yá̱tit amigos tí naca̱maklhti̱naná̱n a̱stá̱n nac akapú̱n acxni nalakó tú ca̱macama̱xqui̱cani̱tántit nacuentajá̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Porque amá tí macama̱xqui̱cán actzú tascújut y cuentaja, acxni macama̱xqui̱cán lhu̱hua tascújut na̱ chuná cuentaja. Pero amá tí ni̱ cuentaja actzú tascújut na̱ chuná ni̱ maktakalha acxni ma̱xqui̱cán lhu̱hua tascújut. ");
INSERT INTO topNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Para huixín ni̱ tancs maktakalhá̱tit la̱ ca̱mini̱niyá̱n actzú tú ca̱macama̱xqui̱cani̱tántit nakalhi̱yá̱tit ca̱quilhtamacú, ¿niculá naca̱ma̱xqui̱yá̱n Dios laclanca ixtalacpuhuá̱n ni̱ma̱ laclhca̱ni̱t? ");
INSERT INTO topNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Chuna li̱tum para huixín ni̱ maktakalhá̱tit tú ni̱ milacán ca̱macama̱xqui̱ni̱tán Dios nacuentajniyá̱tit, ¿niculá naca̱macama̱xqui̱yá̱n tú laclhca̱ni̱t ama ca̱toca̱rli̱yá̱n huixín? ");
INSERT INTO topNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Chí cca̱huaniyá̱n, cha̱tum tasa̱cua ni̱ lá ca̱macuaní cha̱tuy patrón porque cha̱tum nalakalhamán y xa̱cha̱tum nasi̱tzi̱ní; natlahuá tú li̱ma̱paksí cha̱tum y na̱kskahuí xa̱cha̱tum. Aquit clacasquín cama̱kachakxí̱tit: cha̱tum chixcú ni̱ lá li̱pa̱huán Dios ixli̱hua̱k ixnacú, y pi̱huá quilhtamacú li̱pa̱huán ixtumi̱n ma̱s na̱ tla̱n namakta̱yá. ");
INSERT INTO topNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Makapitzi ixma̱kantaxti̱nani̱n ixley Moisés tí takáxmatli ixtachihuí̱n tzúculh tali̱kalhkama̱nán Jesús porque xlacán snu̱n ixtalakatí takalhí tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús ca̱huánilh: ―Huixín ixma̱kantaxti̱naní̱n ixley Moisés ixlacati̱ncán cristianos lacputzayá̱tit caca̱li̱kalhi̱cántit lactlá̱n lacchixcuhuí̱n, pero Dios lakapasa ixkasatcán minacujcán. Porque tú puhuaná̱tit huixín ca̱macuaniyá̱n tlahuayá̱tit ixlacatí̱n Dios, Dios ni̱ ca̱li̱ma̱nu̱yá̱n tla̱n tú tlahuayátit, ¡lakmakán! ");
INSERT INTO topNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Acxni Juan Bautista ya̱ istzucú ixli̱chihui̱nán Dios ixca̱mini̱niyá̱n nakaxpatá̱tit ixley Moisés y tú tatzokni̱t profetas. Pero Juan ma̱tzuqui̱lhá li̱chihui̱nán la̱ Dios ma̱lacnú ca̱ma̱paksi̱putún cristianos ca̱quilhtamacú y la̱ta amá quilhtamacú lhu̱hua cristianos tatzaksama̱na tatanú nac ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Aquit cca̱ma̱lacapa̱stacayá̱n xlacata akapú̱n y ca̱quilhtamacú tla̱n talaksputa pero tú lactzu lactzú laclhca̱ni̱t Dios ni̱ ama li̱tamakxtaka ni̱ ama kantaxtú. ");
INSERT INTO topNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Huixín lacsacxtuyá̱tit nac ixley Moisés tú ca̱mini̱niyá̱n porque ma̱tla̱ni̱yá̱tit cha̱tum chixcú camákxtakli ixta̱cha̱t y cata̱tamakáxtokli tunu pusca̱t, pero namá chixcú tlahuá tala̱kalhí̱n ixlacatí̱n Dios. Na̱ chuná amá tí ta̱tamakaxtoka pusca̱t ni̱ma̱ makxtakni̱t ixta̱ko̱lú na̱ tlahuá tala̱kalhí̱n ixlacatí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús na̱ ca̱huánilh: ―Maktum latáma̱lh cha̱tum rico chixcú ni̱ma̱ hua̱k ixkalhí ni̱tú istzanka̱ní; tla̱n ixlhaka̱nán y tza̱pu ixtlahuá li̱lakastá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Amá nac ca̱chiquí̱n na̱ ixlama cha̱tum pobre ixuanicán Lázaro, snu̱n ixta̱tatlá, ixtahuilá ca̱tiyatni lacatzú nac puhui̱lhta ixchic amá rico ");
INSERT INTO topNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","xlacata naca̱huati̱lhá katxtakma ni̱ma̱ ixtapa̱tastá nac mesa; lactzú chichí ixtama̱lacatzuhuí hasta ixtamacslipí. ");
INSERT INTO topNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Cha̱lh quilhtamacú ni̱lh Lázaro y ángeles táli̱lh nac ixpu̱táhui̱lh Abraham ni̱ma̱ ixma̱xqui̱ni̱t Dios. Ni̱ ixli̱maka̱s amá rico na̱ ni̱lh y muju̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nac ixpu̱latama̱ncán ni̱n ní ixakxtakajnama amá rico talacayá̱hualh ácxilhli Lázaro li̱pa̱xáu ixlama nac ixpu̱táhui̱lh Abraham. ");
INSERT INTO topNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ma̱ktási̱lh: “Ta̱ta Abraham, ¡caquilakalhámanti! Cama̱lakacha Lázaro namín quima̱cahui̱ní ca̱na tziná ixquincán quisi̱máka̱t porque yaj lá cta̱lá la̱ cakxtakajnama juú nac lhcúya̱t.” ");
INSERT INTO topNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham kálhti̱lh: “Cá̱ksanti huix la̱ li̱pa̱xáu ixlápa̱t nac ca̱quilhtamacú y Lázaro ni̱tú ixkalhí. Chí juú talakxta̱pali̱ni̱t, huix akxtakajnámpa̱t y Lázaro li̱pa̱xáu lama. ");
INSERT INTO topNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Xa̱huá tí talama̱na juú ni̱ lá ta̱ksputza̱lá tú quinca̱ma̱pitziyá̱n, y ni̱ lá ta̱na̱chá ní tanú̱pa̱t, y tí talama̱na nanú na̱ ni̱ lá ta̱ksputza̱lá tú quinca̱ma̱pitziyá̱n y ni̱ lá tamín juú.” ");
INSERT INTO topNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Amá chixcú huanipá: “Para ni̱ lá tlahuaya tú cuaniyán siquiera cama̱lakacha nac ixchic quinti̱cú, ");
INSERT INTO topNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","porque cca̱kalhí cha̱quitzis quinata̱camán y clacasquín caca̱huanica catalakxta̱páli̱lh ixlatama̱tcán xlacata ni̱ natamín ta̱kxtakajnán juú la̱ aquit.” ");
INSERT INTO topNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Xlá kalhti̱pá: “Para xlacán talakxta̱pali̱putún ixlatama̱tcán cata̱kahuá̱nalh tú li̱ma̱paksi̱nán Dios pues Moisés y profetas hua̱k tatzokni̱t nac Escrituras. ¡Catakáxmatli para talacasquín!” ");
INSERT INTO topNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Amá rico kalhtí̱nalh: “¡Tó! Ni̱ ama takaxmata, ta̱ta Abraham, porque ni̱ ta̱kahuanán tú tali̱kalhtahuaká. Pero para ixca̱lákalh cha̱tum chixcú tí talakapasa y maká̱n ni̱ni̱t, xlacán ixtalakxta̱páli̱lh ixlatama̱tcán.” ");
INSERT INTO topNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham huaniko̱lh amá rico chixcú: “Ma̱squi ixca̱lákalh cha̱tum ni̱n ni̱ para chú tamá̱n ta̱kahua̱nán. Moisés y lhu̱hua profetas taqui̱lani̱t y ni̱ takaxmata.” ");
INSERT INTO topNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Maktum Jesús ca̱huánilh ixdiscípulos: ―Juú nac ca̱quilhtamacú siempre talama̱na nahuán tí tama̱tlahui̱nán tala̱kalhí̱n, pero ¡koxitá namá chixcú tí ca̱ma̱laktzanke̱ní ixtalacapa̱stacnicán catatzacá̱tnalh tí tzucuni̱t quintali̱pa̱huán! ");
INSERT INTO topNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma̱s ixmacuánilh para ixli̱pixchi̱ca aktum lanca chíhuix xla molino ixmuju̱ca nac pupunú xlacata namu̱xtú que lacputzá ca̱ma̱tlahuí tala̱kalhí̱n namá tí tzucuni̱t quintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tla̱n calacputzátit catlahuátit tú ma̱s ca̱mini̱niyá̱n. Para minta̱cam tlahuaniyá̱n tú ni̱ tlá̱n cakahuani, y para lakxta̱palí ixkásat, ¡cama̱tzanke̱nani tú tlahuanín! ");
INSERT INTO topNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Para aktum chichiní makasi̱tzi̱yá̱n maktujún y makatunu huaniyá̱n cama̱tzanke̱nani yaj chú amá̱n tlahuayá̱n, huix cama̱tzanke̱nani tú tlahuanín. ");
INSERT INTO topNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Maktum ixapóstoles tamáksquilh Jesús: ―Quimpu̱chinacán, quila̱ma̱si̱níu la̱ nacca̱najlayá̱u tú tla̱n tlahuá Dios. ");
INSERT INTO topNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Xlá ca̱kálhti̱lh: ―Para huixín ixca̱najlátit ixli̱hua̱k mintapuhua̱ncán Dios ama tlahuá tú maksquiná̱tit ma̱squi caj actzú la̱ ixtalhtzi aktum a̱cuncali̱n ixli̱lanca, tla̱n ixuanítit katum quihui: “Catake̱nu ní ya̱t y cataju nac pupunú”, y namá quihui xli̱ca̱na ixca̱kaxmatnín. ");
INSERT INTO topNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Huixín catzi̱yá̱tit xlacata cha̱tum tasa̱cua acxni qui̱scujkó ixca̱tucuxtu ixpatrón o qui̱maktakálhnilh ixquitzistancaní̱n, acxni taspita, ni̱ capuhuántit huaní ixpatrón: “Catanu, cahuá̱yanti tuncán.” ");
INSERT INTO topNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cha̱ huaní ixpatrón: “Casokti catalakxtúnanti y catlahua quili̱hualhtata xlacata nacua̱yán. Y la̱ nacualhtatakó entonces na̱ natzucuya hua̱yana huix.” ");
INSERT INTO topNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma̱squi namá tasa̱cua ma̱s scujni̱t, ni̱ capuhuántit pa̱xcatcatzi̱nicán tú tlahuani̱t pues huata ma̱kantaxti̱ni̱t ixtascújut ni̱ma̱ li̱tanu̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Aquit cca̱huaniyá̱n para Dios ca̱ma̱macqui̱yá̱n aktum tascújut y huixín tlahuayá̱tit, ni̱ capuhuántit ma̱s lactali̱pa̱u ama ca̱li̱maca̱ná̱n porque huata tlahuani̱tántit ixtascújut ni̱ma̱ ca̱mini̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús ti̱tum ixyá nac tijia nachá̱n nac Jerusalén ca̱ti̱lakatzá̱lalh pu̱latama̱n Samaria y Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Acxni cha̱lh nac aktum actzú ca̱chiquí̱n tá̱cxilhli cha̱cá̱u lacchixuhuí̱n tí ixtakalhí lepra tá̱tat. ");
INSERT INTO topNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","La̱ta li̱lakamákat tama̱ktási̱lh: ―¡Maestro Jesús! ¡Caquila̱lakalhamáu! ¡Quila̱ma̱ksa̱ní̱u! ");
INSERT INTO topNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xlá tá̱yalh, acs ca̱lacá̱nilh y ca̱huánilh: ―Tla̱n, pero capítit putzayá̱tit cha̱tum cura tí nama̱luloka ca̱makxtakni̱tán minta̱tatcán. Tatlá̱hualh lakchú y acxni tamaklhcátzi̱lh caj la̱ ni̱tú catake̱nú̱nilh ixta̱tatcán. ");
INSERT INTO topNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cha̱tum xalac Samaria ixuani̱t, acxni ácxilhli la̱ aksá̱nalh tzúculh aktasá pa̱xcatcatzi̱ní Dios la̱ ixma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jaé samaritano tuncán lákalh Jesús, tatzokostánilh hasta talacátalh ca̱tiyatni y huánilh: ―¡Cpa̱xcatcatzi̱niyá̱n tú tlahuani̱ta quilacata! ");
INSERT INTO topNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús kálhti̱lh: ―La̱mpara cha̱cá̱u ixuani̱tántit, ¿a poco ni̱ hua̱k ta̱ksa̱nani̱t? ¿Nicu ta̱lh xa̱makapitzi? ");
INSERT INTO topNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Hua̱nchi huata jaé xala mákat chixcú tí ni̱ judío táspitli pa̱xcatcatzi̱ní Dios tú tláhualh ixlacata? ");
INSERT INTO topNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A̱stá̱n li̱ma̱páksi̱lh amá chixcú: ―Cata̱ya capit li̱pa̱xáu. Huix aksa̱nani̱ta porque quili̱pa̱huani̱ta tla̱n cma̱ksa̱ni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Maktum quilhtamacú makapitzi ixma̱kantaxti̱naní̱n ixley Moisés takalasquínilh Jesús lihua xnicu ixama lacatzucú ixtapáksi̱t Dios ca̱quilhtamacú. Xlá ca̱kálhti̱lh: ―Acxni nalacatzucú ixtapáksi̱t Dios ca̱quilhtamacú ni̱ lá pa̱t acxilá̱tit la̱ li̱lacahua̱naná̱tit tú huí ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ni̱ lá tí ama huan: “Juú huí”, o “Anú cácxilhli.” Aquit cca̱huaniyá̱n jaé tachihuí̱n porque huixín ni̱ ma̱kachakxi̱ni̱tántit xlacata ixtapáksi̱t Dios ca̱lakchini̱taná nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A̱stá̱n ca̱huánilh ixdiscípulos: ―Ama cha̱n quilhtamacú acxni huixín na̱ pa̱t acxilhputuná̱tit ca̱na makstum la̱ cama ma̱paksi̱nán aquit Xatalacsacni Chixcú, pero ya̱ lá amá̱n quila̱cxilá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Makapitzi naca̱huaniyá̱n: “Juú chini̱t Mimpu̱chinacán”, o “Anú cacxilhui lapu̱lá.” Huixín ni̱ caca̱najlátit ni̱ para capítit quila̱lacaputzayá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","’Acxni aquit Xatalacsacni Chixcú nacmín ca̱quilhtamacú ixli̱maktuy, ni̱tí ama ta̱kskahuí porque cama taxtuya̱chi na̱ chuná la̱ tasí acxni maklipa cani̱huá lacacha̱nkó. ¡Aquit cama tasí ixli̱ti̱lanca ca̱quilhtamacú! ");
INSERT INTO topNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero pu̱la lhu̱hua tú cama liakxtakajnán pues namá cristianos tí talama̱na jaé quilhtamacú ama quintalakmakán. ");
INSERT INTO topNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Acxni aquit Xatalacsacni Chixcú nacca̱lakchiná̱n ixli̱maktuy, lhu̱hua ama ta̱kspulá la̱ ca̱qui̱taxtúnilh amá cristianos tí ixtalama̱na acxni tilatáma̱lh Noé. ");
INSERT INTO topNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Amá cristianos ni̱tú ixtali̱puhuán, ixtahua̱yán, ixtakachí, ixtatamakaxtoka, ixtali̱pa̱xahuá tú ixtakalhí. Ni̱ para tziná caso tatláhualh tú ca̱huánilh Noé, pero huata táju̱lh nac barco ni̱ma̱ ixtlahuani̱t tzúculh tatlancanán, milh spútut y hua̱k tani̱lo̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Na̱ chuná qui̱táxtulh nac ca̱chiquí̱n Sodoma ana ní ixlama Lot. Hua̱k cristianos ixtahua̱yán, ixtakotnán, ixtasta̱nán, ixtatama̱huanán, ixtachana̱nán, ixtachiqui̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na̱ ni̱ taca̱nájlalh tú ca̱li̱ta̱chihuí̱nalh Lot, pero huata táxtulh nac Sodoma tzúculh pa̱tastá lhcúya̱t y azufre nac akapú̱n, hua̱k ca̱makni̱ko̱lh amá cristianos tí ixtalama̱na nac Sodoma. ");
INSERT INTO topNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","’Lhu̱hua cristianos chuná jaé talama̱naj nahuán acxni nacmimpará ca̱quilhtamacú aquit Xatalacsacni Chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Amá quilhtamacú para cha̱tum cristiano ta̱cxtuni̱t nahuán ixakstí̱n ixchic, ni̱ catláhualh fuerza ma̱xtú tú kalhí nac ixchic, la̱ta yá catzá̱lalh. Para cha̱tum cristiano ani̱t nahuán nac ixca̱tucuxtu, yaj catáspitli nac ixchic tiyá ixlháka̱t. ");
INSERT INTO topNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pues ca̱ksántit la̱ timakatzánka̱lh ixli̱stacni ixta̱cha̱t Lot caj xlacata ixli̱puhuán tú ixakxtakmakani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Porque amá quilhtamacú tí lakcatzán lakma̱xtuputún ixli̱stacni ama makatzanká, pero tí akxtakmakán li̱puhuán la̱ta tú kalhí ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Amá quilhtamacú para cha̱tuy cristianos talhtatama̱na nac ixpu̱tamacán, cha̱tum ama̱ca lakma̱xtucán y xa̱cha̱tum ama̱ca makxtakcán. ");
INSERT INTO topNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Para cha̱tuy lacchaján tasquitima̱na, cha̱tum ama̱ca lakma̱xtucán y xa̱cha̱tum ama̱ca makxtakcán. ");
INSERT INTO topNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Para cha̱tuy lacchixcuyuí̱n tascujma̱na nac ixca̱tucuxtucán, cha̱tum ama̱ca lakma̱xtucán y xa̱cha̱tum ama̱ca makxtakcán. ");
INSERT INTO topNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","La̱ takaxmatko̱lh ixapóstoles ixtachihuí̱n takalasquínilh: ―Quimpu̱chinacán, ¿nicu ama̱ca ca̱li̱ncán jaé tí naca̱lakma̱xtucán? Jesús ca̱kálhti̱lh: ―Xlacán ama tacatzí nicu na̱ chuná la̱ chu̱n tataka̱sa xaní̱n quitzistanca. ");
INSERT INTO topNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ixlacasquín catama̱kachákxi̱lh ixdiscípulos ni̱ catali̱mákxtakli takalhtahuakaní Dios ma̱squi ni̱ sok caca̱má̱xqui̱lh tú tamaksquín. ");
INSERT INTO topNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ixtalacapa̱stacni ca̱li̱ta̱ma̱lacastúcnilh jaé takalhchihuí̱n: ―Nac aktum ca̱chiquí̱n ixlama cha̱tum juez, ixli̱lakapascán ni̱ ixli̱pa̱huán Dios, ni̱ para ixca̱lakalhamán cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na̱ aná ixlama cha̱tum viuda pusca̱t ni̱ma̱ tza̱pu ixán ta̱chihui̱nán caca̱stigartláhualh cha̱tum cristiano ni̱ma̱ siempre ixta̱ra̱slaka. ");
INSERT INTO topNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Maka̱s quilhtamacú jaé juez ni̱ caso tláhualh tú huánilh amá pusca̱t. Pero xlá ni̱ ixli̱makxtaka min ta̱chihui̱nán hasta maktum qui̱lacpúhualh: “Aquit ni̱ cli̱pa̱huán Dios, ni̱ para quincuenta tú tapa̱xtoka cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero jaé pusca̱t tza̱pu min quiakaxculí, quimakasi̱tzi̱majá la̱ lá; mejor cama tlahuá tú quimaksquín xlacata yaj namín quima̱cchichijuí.” ");
INSERT INTO topNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús ca̱huánilh ixdiscípulos: ―Para jaé juez tí ni̱ ca̱sipa̱cxila cristianos tlahuánilh justicia amá pusca̱t xlacata yaj namín akaxculí, ");
INSERT INTO topNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿nicu li̱puhuaná̱tit Dios ni̱ sok catica̱má̱xqui̱lh ixcamán tí ca̱lacsacni̱t tú tamaksquín para cha̱li cha̱lí takalhtahuakaní? ");
INSERT INTO topNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Aquit tancs cca̱huaniyá̱n, Dios sok ca̱makta̱yá y ca̱ma̱xquí ixcamán tú talacasquín. Pero cli̱puhuán aquit Xatalacsacni Chixcú tú ama tapa̱xtoka amá cristianos acxni nacchimpará ixli̱maktuy ca̱quilhtamacú. ¿Nicu cha̱li̱t nacca̱ma̱noklhú ni̱ tali̱makxtakni̱t quintali̱pa̱huán? ");
INSERT INTO topNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Como makapitzi lacchixcuhuí̱n ixacstucán ixtali̱tanú lactlá̱n cristianos ixtalakmakán xa̱makapitzi cristianos, Jesús ca̱huánilh jaé takalhchihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Cha̱tuy lacchixcuhuí̱n ta̱lh takalhtahuakaní Dios nac pu̱siculan; cha̱tum ixma̱kantaxti̱ná ixley Moisés ixuani̱t ixli̱tanú tla̱n cristiano, y xa̱cha̱tum ixma̱lakaxoke̱ná tumi̱n ixuani̱t ixli̱ta̱yá li̱xcájnit chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Amá ixma̱kantaxti̱ná ixley Moisés chuné kalhtahuakánilh Dios: “Quimpu̱chiná Dios, cpa̱xcatcatzi̱niyá̱n porque aquit ni̱ li̱xcájnit quinkásat la̱ xa̱makapitzi. Aquit ni̱ cakskahuinán, ni̱ ctlahuá tú li̱xcájnit, ni̱ clakamaklhti̱nán pusca̱t, ni̱ para cta̱talacastuca namá chixcú tí ma̱lakaxoke̱nán tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aquit ckatxtaknán maktuy katunu xama̱na xlacata naclakachixcuhui̱yá̱n y cma̱stá limosna catzuntín tumi̱n ni̱ma̱ ctlajá.” ");
INSERT INTO topNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","A̱lacatunu amá chixcú tí ixma̱lakaxoke̱nán tumi̱n ni̱ para ixtalacatzuhui̱putún ixpu̱lakachixcuhui̱cán Dios la̱ta ixma̱xanán ixlacati̱n Dios, ma̱kat tamákxtakli, acpu̱taj tá̱yalh ni̱ para ixlacá̱n ta̱lhmá̱n. Huata ixcuxmu̱ma̱xqui̱cán ixuán: “Quimpu̱chiná Dios, caquilakalhámanti, caquima̱tzanke̱nani lhu̱hua quintala̱kalhí̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesús ca̱huaniko̱lh cristianos: ―Tancs cca̱huaniyá̱n, Dios ma̱tzanke̱nánilh tú ixtlahuani̱t amá ixma̱lakaxoke̱na tumi̱n, y ni̱ ma̱tlá̱ni̱lh tú huánilh amá ixma̱kantaxti̱na ixley Moisés. Porque tí lactlancán li̱tanú ixacstu tla̱n cristiano ama̱ca lakmakancán, pero tí li̱ta̱yá kalhí tala̱kalhí̱n ama̱ca ma̱camajcán. ");
INSERT INTO topNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Makapitzi lacchaján tatzáksalh tama̱lacatzuhuí Jesús xlacata naca̱mu̱sicuna̱tlahuá lactzú itskatacán ni̱ma̱ ixtali̱mín, pero ixdiscípulos talacaquílhni̱lh amá lacchaján tí ixtali̱mín itskatacán. ");
INSERT INTO topNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Como Jesús ca̱káxmatli ca̱huánilh: ―Ni̱ caca̱li̱huanítit caquintama̱lacatzúhui̱lh namá lactzú camán porque nac ixtapáksi̱t Dios huata ama̱ca ca̱maklhti̱nancán amá cristianos tí tali̱tanú la̱ lactzú camán. ");
INSERT INTO topNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Xli̱ca̱na cca̱huaniyá̱n amá cristianos tí ni̱ li̱tamakxtaka hua̱k ca̱najlá la̱ cha̱tum actzú kahuasa, ni̱ lá ama maklhti̱nán la̱ ma̱lacnú Dios ca̱ma̱paksi̱putún cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Maktum quilhtamacú cha̱tum tali̱pa̱u chixcú kalasquínilh Jesús: ―Maestro, huix tla̱n catzi̱ya, quihuani, ¿tucu quili̱tláhuat xlacata tla̱n nacchá̱n nac akapú̱n ní huí Dios? ");
INSERT INTO topNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Xlá kálhti̱lh: ―¿Hua̱nchi quihuaniya tla̱n ccatzí? Huata huí cha̱tum tí tla̱n catzí y huá Quinti̱cucán Dios. ");
INSERT INTO topNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Chí cama kalhti̱yá̱n tú quinkalasquini. Catlahua nac milatáma̱t tú li̱ma̱paksi̱nán Dios: “Ni̱ calakámaklhti ixpusca̱t minta̱chixcú, ni̱ camakni minta̱cristiano, ni̱ cakalhá̱nanti, ni̱tí caliakskahuínanti tú ni̱ ca̱na, y caca̱lakalhámanti minti̱cú mina̱na.” ");
INSERT INTO topNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Amá chixcú kalhpaktánu̱lh Jesús: ―Namá tú quihuanípa̱t la̱ta quiliactzú cma̱kantaxti̱ni̱t nac quilatáma̱t. ");
INSERT INTO topNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","―Pero huí tú tzanka̱niyá̱n: casta̱t la̱ta tú kalhi̱ya y caca̱ma̱xqui xatumi̱n tí pobres talama̱na. A̱stá̱n naquilaktana xlacata naquintakokeya cani̱huá. Para tlahuaya tú cuanimá̱n tancs pa̱t chipina nac akapú̱n ní huí Dios ―huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Amá chixcú acxni káxmatli tú huánilh Jesús lakaputzako̱lh porque snu̱n rico ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús ca̱huánilh ixdiscípulos: ―¡Xli̱ca̱na snu̱n tuhua ca̱huani̱ní ricos tama̱tla̱ní tú ma̱lacnú Dios nac ixtapáksi̱t! ");
INSERT INTO topNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma̱s ni̱ tuhua tanú tantum camello nac istzán li̱xtokon que cha̱tum rico nama̱tla̱ní tú ma̱lacnú Dios nac ixtapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ixdiscípulos tí taka̱xmatli takalasquínilh: ―Entonces, ¿ticu ama lakma̱xtú ixli̱stacni? ");
INSERT INTO topNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ca̱kálhti̱lh: ―Lacchixcuhuí̱n huí lhu̱hua tú ni̱lá tatlahuá, pero Dios hua̱k tla̱n tlahuá tú lacasquín. ");
INSERT INTO topNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro na̱ kalasquínilh: ―Entonces aquín tí cakxtakmakani̱táu la̱ta tú xackalhi̱yá̱u xlacata nacca̱takokeyá̱n, ¿nicu camá̱n qui̱ta̱yayá̱u? ");
INSERT INTO topNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús chuné chihuí̱nalh: ―Xli̱ca̱na cca̱huaniyá̱n, amá tí akxtakmakán ixchic, ixta̱cha̱t, ixnati̱cún, ixnata̱camán o ixcamán xlacata nali̱chihui̱nán la̱ ma̱lacnú Dios ca̱ma̱paksi̱putún cristianos, ");
INSERT INTO topNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","xlá ama pu̱spitní ma̱s lhu̱hua que la̱ta tú ixkalhí xapu̱lh ca̱quilhtamacú, y acxni Dios naca̱ta̱tlahuá taxokó̱n cristianos ama maklhti̱nán li̱pa̱xáu ixlatáma̱t nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Maktum Jesús ca̱tá̱alh aparte cha̱cu̱tuy ixapóstoles, y ca̱huánilh: ―Huixín catzi̱yá̱tit xlacata ama̱náu pakán nac Jerusalén; aná ama kantaxtú la̱ta tú tali̱chihui̱nani̱t profetas cama pa̱xtoka aquit Xatalacsacni Chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Aná ama̱ca quimacama̱sta̱cán ixmacancán xala mákat lacchixcuhuí̱n, xlacán ama quintali̱chiyá, quintali̱kalhkama̱nán, quintalacachucxuí; ");
INSERT INTO topNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","y acxni naquintasnokkó, ama quintamakní. Pero ixliaktutu chichiní a̱stá̱n aquit cama lacastacuanán ca̱li̱ná̱n. ");
INSERT INTO topNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ixapóstoles ni̱ ixtacatzí ni̱ para ixtama̱kachakxí tú ixca̱huaniputún porque Dios ni̱ ixca̱li̱makxtakni̱t nata̱cxcatzí ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús cha̱lh ixquilhapá̱n aktum ca̱chiquí̱n huanicán Jericó. Nac ixpa̱xtú̱n tijia ixuí cha̱tum lakatzi̱n chixcú itsquima limosna. ");
INSERT INTO topNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Acxni káxmatli jilij ixtachihui̱nán cristianos, kalasquiní̱nalh tú ixqui̱taxtuma. ");
INSERT INTO topNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Cha̱tum huánilh: ―Jesús xalac Nazaret lacpasa̱rlama juú lacatzú. ");
INSERT INTO topNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ni̱ para tla̱n kaxmatko̱lh amá lakatzí̱n tzúculh aktasá: ―¡Jesús, ixli̱talakapasni rey David! ¡Caquilakalhámanti; caquima̱ksa̱ni! ");
INSERT INTO topNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Makapitzi tí ixtapu̱lanini̱t Jesús talacaquílhni̱lh xlacata acs catahui, pero xlá ma̱s tzúculh aktasá: ―¡Jesús ixli̱talakapasni rey David! ¡Caquilakalhámanti! ");
INSERT INTO topNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús tá̱yalh puntzú, li̱ma̱paksí̱nalh cali̱minca ixlacatí̱n, y acxni chilh kalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tucu lacasquina cactláhualh milacata? Xlá huá: ―Quimpu̱chinacán, clacasquín cama̱lakake quilakastapu xlacata naclacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús huánilh: ―¡Pues catalakáke̱lh milakastapu xlacata nalacahua̱nana! Huix aksa̱nani̱ta porque quili̱pa̱huani̱ta tla̱n cma̱ksa̱ni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Amá lakatzí̱n tuncán lacahuá̱nalh y takókelh Jesús pa̱xcatcatzi̱niti̱lhá Dios tú ixtlahuani̱t ixlacata. Amá tí tá̱cxilhli ixtascújut Jesús na̱ ixtalakachixcuhuí Dios. ");
INSERT INTO topNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús cha̱lh nac Jericó y tánu̱lh ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aná ixlama cha̱tum xapuxcu ixma̱lakaxoke̱naní̱n tumi̱n ixuanicán Zaqueo, y snu̱n rico ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Xlá ixlakapasputún Jesús, pero como snu̱n actzú ixuani̱t ni̱ lá ixacxila pues istzamacán. ");
INSERT INTO topNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tú tláhualh tá̱cxtulh nac akatum quihui huanicán sicómoro, aná ixama lacpasa̱rlá Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Acxni chilh aná, xlá talacayá̱hualh ta̱lhmá̱n, li̱ma̱pa̱cúhui̱lh ixtacuhui̱ní y huánilh: ―Zaqueo, lacapala cata̱cta, porque jaé chichiní cama lakpaxia̱lhnaná̱n nac mínchic. ");
INSERT INTO topNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Xlá lacapala tuncán tá̱ctalh y pa̱xahuati̱lhá tá̱alh Jesús nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lhu̱hua cristianos tzúculh tahuán: ―Ani̱t lakpaxia̱lhnán namá li̱xcájnit chixcú tí kalhí lhu̱hua tala̱kalhí̱n porque ni̱ ma̱kantaxtí ixley Moisés. ");
INSERT INTO topNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Nac ixpu̱lacni ákxtaka Zaqueo tá̱yalh y huánilh Jesús: ―Quimpu̱chiná, la̱ta tú cma̱paksí íta̱t cama ca̱ma̱xquí pobres, y para tí cma̱táji̱lh li̱huacá, cama pu̱spitní makta̱ti ixlacata li̱huacá. ");
INSERT INTO topNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús na̱ huánilh: ―Jaé quilhtamacú Dios mini̱t ca̱lakma̱xtú tí talama̱na jaé ákxtaka porque jaé chixcú na̱ cli̱ma̱nú ixli̱talakapasni Abraham. ");
INSERT INTO topNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chí taxtunini̱t pues aquit Xatalacsacni Chixcú cmini̱t putzá y lakma̱xtú tú ixlaktzanka̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","La̱ ta̱chihui̱nanko̱lh Zaqueo, Jesús ca̱huanipá tunu takalhchihuí̱n pues como ixcha̱majá nac Jerusalén lhu̱hua cristianos ixtapuhuán aná ixama ma̱lacatzuquí ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xla ca̱huánilh jaé takalhchihuí̱n xlacata natama̱kachakxí la̱ ixama qui̱taxtú: ―Nac aktum pu̱latama̱n ixlama cha̱tum tali̱pa̱u chixcú. Maktum lákchilh tachihuí̱n caalh nac ca̱chiquí̱n ni̱ma̱ ixli̱tapaksí ixpu̱latama̱n porque ixama̱ca li̱lhca̱cán rey. ");
INSERT INTO topNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Acxni táxtulh ca̱tasánilh cha̱cá̱u ixtasa̱cua y ca̱má̱xqui̱lh lhu̱hua tumi̱n cha̱tunu xlacata catama̱scujúnilh hasta xní naqui̱taspita. ");
INSERT INTO topNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Lhu̱hua cristianos nac ixpu̱latama̱n ni̱ ixtama̱tla̱ní amá chixcú nali̱lhca̱cán rey tí naca̱ma̱paksí y tama̱lakácha̱lh pu̱tum lacchixcuhuí̱n nac ca̱chiquí̱n ni̱ma ixli̱tapaksí ixpu̱latama̱ncán xlacata tunu tí nali̱lhca̱cán. ");
INSERT INTO topNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero ni̱tú tatá̱yalh pues siempretá li̱lhca̱ca rey. Xlá táspitli y ca̱tasánilh amá ixtasa̱cua tí ixca̱ma̱xqui̱ni̱t tumi̱n xlacata naca̱ta̱tlahuá taxokó̱n niculá ixtatlajani̱t cha̱tunu. ");
INSERT INTO topNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xla̱huán tí ta̱tláhualh cuenta huánilh: “Uchu huí mintumi̱n; aquit cma̱stacani̱t makcá̱u ixlacata li̱huacá la̱ quima̱xqui.” ");
INSERT INTO topNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Amá rey kálhti̱lh: “Clakatí mintascújut, huix sculujua pues ma̱stacani̱ta actzú quintumi̱n ni̱ma̱ cma̱xquí̱n. La̱ta chí tuncán cmacama̱xqui̱yá̱n akcá̱u ca̱chiquí̱n xlacata huix naca̱ma̱paksi̱ya.” ");
INSERT INTO topNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ixli̱cha̱tuy ixtasa̱cua huánilh xlacata ixtlajani̱t makquitzis li̱huacá tumi̱n la̱ timá̱xqui̱lh amá rey. ");
INSERT INTO topNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Xlá kálhti̱lh: “Huix na̱ lakati̱ya cha̱lhca̱tnana; la̱ta chí cmacama̱xqui̱yá̱n akquitzis ca̱chiquí̱n xlacata huix naca̱ma̱paksi̱ya.” ");
INSERT INTO topNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chuná amá ca̱ta̱tláhualh cuenta ixtasa̱cua. Pero cha̱tum huánilh: “Uchu huí mintumi̱n la̱ta quima̱xqui. Aquit cmákchi̱lh nac luxu xlacata nacma̱quí ni̱ natzanká. ");
INSERT INTO topNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pues xacjicuaniyá̱n porque huix scarancua tlahuaya taxokó̱n; ccatzí la̱ akchipaya tú ni̱ li̱scujni̱ta y ca̱maklhti̱ya ixtachana̱ncán ni̱ma̱ tali̱scujni̱t xa̱makapitzi.” ");
INSERT INTO topNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Amá rey huánilh: “¡Takalhí̱n chixcú, mi̱cstu mintachihuí̱n li̱talacapu̱ya! Para xcatzi̱ya scatancua ctlahuá taxokó̱n, cakchipá tú ni̱ cli̱scujni̱t y cca̱maklhtí ixtachana̱ncán xa̱makapitzi, entonces, ");
INSERT INTO topNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿hua̱nchi ni̱ ma̱nu quintumi̱n nac banco xlacata acxni xactiqui̱táspitli siquiera ixquintima̱xqui xaskata ni̱ma̱ tlajani̱t quintumi̱n?” ");
INSERT INTO topNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Amá rey ca̱huánilh xa̱makapitzi cristianos: “Camaklhtí̱tit ixtumi̱n jaé chixcú y cama̱xquí̱tit namá tí tlájalh makcá̱u ixlacata li̱huacá.” ");
INSERT INTO topNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Xlacán tahuánilh: “Pero señor, xlá kalhi̱yá lhu̱hua tumi̱n, li̱huacá makcá̱u.” ");
INSERT INTO topNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Amá rey ca̱kálhti̱lh: “Xli̱ca̱na cca̱huaniyá̱n, amá tí kalhi̱yá tú maclacasquín, ma̱s ama̱ca ma̱xqui̱cán, y tí caj actzú kalhí, ama̱ca maklhti̱cán hasta ni̱ma̱ ixli̱skalhma̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Y namá quienemigos ni̱ma̱ ni̱ ixquinta̱cxilhputún caca̱li̱tántit tuncán y nac quilacatí̱n caca̱makní̱tit.” ");
INSERT INTO topNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","La̱ chihui̱nanko̱lh Jesús, ti̱tum tá̱yalh nachá̱n nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Cha̱lh nac aktum sipi huanicán Cerro de los Olivos, lacatzú ixtahuila̱na aktuy ca̱chiqí̱n huanicán Betfagé y Betania. Xlá ca̱ma̱páksi̱lh cha̱tuy ixdiscípulos: ");
INSERT INTO topNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Capítit namá nac ca̱chiquí̱n ni̱ma̱ li̱lacacha̱ni̱táu, y nac aktum ákxtaka pa̱t taka̱sá̱tit tachi̱ya̱huán tantum burro ni̱ma̱ ni̱ naj tí pu̱tahuacani̱t. Caxcúttit y naquila̱li̱miniyá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Para tí ca̱huaniyá̱n hua̱nchi xcutpa̱nántit, huixín cahuanítit xlacata Mimpu̱chinacán maclacasquín. ");
INSERT INTO topNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xlacán ta̱lh y xli̱ca̱na tatáka̱sli amá burro la̱ cahuánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lihua ixtaxcutma̱na amá burro acxni táxtulh xapu̱chiná y ca̱huánilh: ―¿Hua̱nchi xcutpa̱nántit namá burro? ");
INSERT INTO topNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","―Porque Quimpu̱chinacán maclacasquín ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Amá chixcú yaj tú ca̱huánilh y táli̱lh amá burro; tali̱ke̱tlápalh ixlhaka̱tcán y pu̱tahuácalh Jesús; ");
INSERT INTO topNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","y tzúculh talaca̱ctá amá Sipi de los Olivos. Lhu̱hua cristianos tatrámi̱lh ixpilisa̱lhcán nac tijia xlacata nalactla̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hua̱k tí ixtatakokeni̱t tzúculh tatlí alabanzas ixtapa̱xcatcatzi̱ní Dios ixtascújut Jesús ni̱ma̱ ixca̱li̱ma̱lacahua̱ni̱ni̱t. Ni̱ caj maktum ixtakaxmatí la̱ ixta̱ktasá cristianos la̱ta ixtali̱pa̱xahuá tú ixqui̱taxtuma; ");
INSERT INTO topNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ixtahuán: ―¡Clakachixcuhui̱yá̱u rey ni̱ma̱ ma̱lakacha̱ni̱t Dios Quimpu̱chinacán! ¡Quinca̱cxilhlacachín Dios nac akapú̱n! ¡Capa̱xcatcatzi̱níu ixli̱tlihueke ni̱ma̱ ma̱si̱ni̱t! ");
INSERT INTO topNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Makapitzi ixma̱kantaxti̱naní̱n ixley Moisés na̱ aná ixtaán, tahuánilh Jesús: ―Maestro, caca̱huani namá tí tali̱pa̱huaná̱n acs catatá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Xlá ca̱kálhti̱lh: ―Para xlacán acs ixtatá̱yalh, chíhuix ixtatzúculh quintalakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Acxni li̱lacácha̱lh Jerusalén, ixnacú Jesús lakaputzako̱lh hasta tásalh, ");
INSERT INTO topNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y la̱ta lakaxtajma chuné chihuí̱nalh: ―¡Jerusalén! ¿Niculá xactláhualh ixma̱kachakxi jaé chichiní xlacata Dios ma̱lacnu̱nimá̱n li̱pa̱xáu latáma̱t? Pero huix ni̱ acxcatzi̱ya porque siempre talakatze̱ka. ");
INSERT INTO topNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chí talaclhca̱ni̱ttá la̱ pa̱t akxtakajnana. Mienemigos ama tastiliyá̱n, ama tama̱makspitá̱n, cani̱huá ama tataxtuya̱chi ");
INSERT INTO topNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","namá tí ama tatrami̱yá̱n ca̱tiyatni, ama ca̱makni̱cán mincamán tí talama̱na juú ca̱chiquí̱n. Ni̱ ama tamakxtaka ni̱ para akstum chíhuix nac ixpu̱ta̱y ni̱ma̱ ca̱li̱tlahuacani̱t chiqui. ¡La̱ta tú ama qui̱taxtuniyá̱n huix li̱pina cuenta porque ni̱ li̱pá̱huanti amá tí ma̱lakacha̱nín Dios nalakma̱xtuyá̱n! ");
INSERT INTO topNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesús alh nac pu̱siculan xla Jerusalén y acxni cha̱lh lacatum ní ixtatahuilá sta̱naní̱n tzúculh ca̱tamacxtú hua̱k cristianos tí ixtasta̱nán, ");
INSERT INTO topNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","y chuné ca̱ma̱kalhchihuí̱ni̱lh: ―Dios ma̱tzokónalh nac Escrituras: “Nac quínchic tla̱n naquintakalhtahuakaní hua̱k cristianos.” Y huixín tlahuani̱tántit ixpu̱sta̱ncán kalha̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Chuná amá Jesús cha̱li cha̱lí tzúculh ca̱ma̱kalhchihui̱ní cristianos nac pu̱siculan. Pero xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos y tí ixtama̱paksi̱nán nac ca̱chiquí̱n ni̱ ixta̱cxilhputún y tzúculh talacputzá tla̱n natamakní. ");
INSERT INTO topNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ma̱squi ixca̱makasi̱tzí, ni̱ lá tú ixtatlahuaní porque hua̱k cristianos ixtalakalhamán Jesús ixtalakatí takaxmata la̱ ixca̱ma̱kalhchihui̱ní. ");
INSERT INTO topNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Maktum chichiní acxni Jesús ixca̱li̱ta̱chihui̱nama cristianos ixtachihuí̱n Dios y la̱ tla̱n tataxtuní táchilh makapitzi xanapuxcun curas, ixma̱kalhtahuake̱naní̱n judíos y lakko̱lún ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Tata̱chihuí̱nalh, y takalasquínilh: ―Quila̱huaníu, ¿tucu xlacata li̱paktanu̱ni̱ta tú tlahuani̱ta nac pu̱siculan? ¿Ticu ma̱xqui̱ni̱tán li̱ma̱paksí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús ca̱kálhti̱lh, y ca̱huánilh: ―Tla̱n nacca̱huaniyá̱n, pero pu̱la na̱ quila̱huaníu: ");
INSERT INTO topNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿ticu li̱ma̱páksi̱lh Juan Bautista naca̱kmunú cristianos, Dios, o cristianos? ");
INSERT INTO topNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xlacán tzúculh talacpuhuán la̱ natakalhtí; ixtara̱huaní: ―Para huaniyá̱u Dios ma̱lakácha̱lh, xlá ama quinca̱huaniyá̱n: “¿Hua̱nchi ni̱ ca̱najlátit ixtachihuí̱n?” ");
INSERT INTO topNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y para huaniyá̱u xlacata lacchixcuhuí̱n tali̱ma̱páksi̱lh, tla̱n natasi̱tzí cristianos y naquinca̱ctalayá̱n porque xlacán tacanajlá xlacata Dios ma̱lakácha̱lh Juan nali̱chihui̱nán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Como ni̱ lá tama̱táncsalh ixtachihui̱ncán, tahuánilh: ―Ni ccatzi̱yá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesús na̱ ca̱huánilh: ―Para huixín ni̱ catzi̱yá̱tit, ni̱ para aquit cama ca̱huaniyá̱n tí quili̱ma̱paksi̱ni̱t nactlahuá tú acxilá̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesús acs ca̱lacá̱nilh hua̱k cristianos y ca̱huánilh jaé takalhchihuí̱n: ―Cha̱tum chixcú chalh nac ixca̱tucuxtu lhu̱hua uvas, pero como alh latamá mákat pu̱latama̱n ca̱rrentartlahuánilh ixtachaná̱n makapitzi cha̱lhca̱tnaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Acxni cha̱lh ixquilhta napuxnancán, ma̱lakácha̱lh cha̱tum ixtasa̱cua xlacata naca̱ma̱tají amá cha̱lhca̱tnaní̱n tú ixtali̱ní. Pero xlacán ta̱kkaxími̱lh y ni̱tú tamá̱xqui̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Amá xapu̱chiná ma̱lakacha̱pá a̱cha̱tum ixtasa̱cua y na̱ chuná ta̱kkaxími̱lh, tali̱kalhkamá̱nalh y ni̱tú tamá̱xqui̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Todavía ma̱lakácha̱lh a̱cha̱tum, pero na̱ chuná tala̱kalhí̱nilh ixtasa̱cua y ta̱ktlakáli̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Amá ko̱lú ixkalhí cha̱tum ixkahuasa, y tzúculh lacpuhuán: “¿Tucu xactláhualh? Mejor cama ma̱lakachá quinkahuasa tí snu̱n clakalhamán. Cpuhuán natakaxmata tú naca̱huaní namá lacli̱xcajnit lacchixcuhuí̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Xlá ma̱lakácha̱lh ixkahuasa y amá lacchixcuhuí̱n acxni tá̱cxilhli tzúculh tata̱huaní: “Huá namá kahuasa tí ama ta̱tamakxtaka hua̱k herencia acxni naní ixti̱cú. Chí tuncán camakni̱huí xlacata aquín ixpu̱chinaní̱n nahuaná̱u jaé ca̱quihuí̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Amá cha̱lhca̱tnaní̱n táli̱lh amá kahuasa lacatum ní lakamákat y aná tamákni̱lh. La̱ huanko̱lh jaé takalhchihuí̱n, Jesús ca̱kalasquínilh cristianos: ―Chí quila̱huaníu, ¿tucu puhuaná̱tit natlahuá ixpu̱chiná amá ca̱quihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","¿Ni̱ puhuaná̱tit xlacata namín ca̱makní amá lacli̱xcájnit cha̱lhca̱tnaní̱n y tunu tí naca̱ma̱xquí ixca̱quihuí̱n? Tí ixtakaxmatma̱na tahuánilh: ―¡Ni̱ calacásquilh Dios, ni̱cxni chú caqui̱táxtulh! ");
INSERT INTO topNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Xlá acs ca̱lacá̱cxilhli y ca̱huánilh: ―Para ni̱ ca̱najlayá̱tit chú ama qui̱taxtú. Quila̱huaníu, ¿tucu huamputún amá ixtalacpuhuá̱n Dios ni̱ma̱ chuné ma̱tzokónalh nac Escrituras: “Amá lanca chíhuix ni̱ma̱ talakmákalh albañiles, a̱stá̱n ya̱huaca nac ixcha̱stú̱n chiqui xlacata aná nali̱tahuacakó hua̱k ixakstí̱n ákxtaka”? ");
INSERT INTO topNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Para cha̱tum cristiano li̱ta̱cuacá jaé chíhuix ixacstu ama talactucxa, y para cha̱tum actamá jaé chíhuix ama lakchatamí. ");
INSERT INTO topNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xanapuxcun curas y ixma̱kalhtahuake̱nacan judíos la̱ takaxmatko̱lh ixtachihuí̱n Jesús tama̱kachákxi̱lh xlacata huá ixca̱li̱chihui̱nani̱t. Ana tuncán tachipapútulh xlacata natalí̱n nac pu̱ma̱paksi̱n pero como snu̱n istzamacán tajicuánilh cristianos para natali̱kahuá y natamaklhti̱nán Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Tzúculh tascalí tama̱lakácha̱lh makapitzi lacchixcuhuí̱n tí li̱catzi ixtali̱tanú lactlá̱n cristianos xlacata nata̱kskahuí Jesús y nahuán tú ni̱ chuná qui̱taxtú y tla̱n natama̱lacapú ixlacatí̱n ma̱paksi̱na romano. ");
INSERT INTO topNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jaé lacchixcuhuí̱n maktum takalasquínilh: ―Maestro, ccatzi̱yá̱u xlacata huix li̱chihui̱nana y ma̱si̱ya tancs talacapa̱stacni la̱ quili̱latama̱tcán ma̱squi caj huá xlacata tali̱lakmakaná̱n cristianos y na̱ tancs ma̱si̱ya la̱ cristianos tla̱n talakchá̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Chí clacasquiná̱u quila̱huaníu, ¿cha̱ tla̱n qui̱taxtú la̱ clakaxokoniyá̱u tumi̱n xapuxcu ma̱paksi̱na romano, o ni̱ mini̱ní naclakaxoko̱naná̱u? ");
INSERT INTO topNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús acxcátzi̱lh caj ixtakalhputzama̱na y ca̱huánilh: ―¿Hua̱nchi huixín lacasquiná̱tit cacliákchakxli quintachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Quila̱ma̱si̱níu mactum tumi̱n. Chí quila̱huaníu, ¿ticu ixretrato y ticu ixtacuhui̱ní tatzokni̱t ixlacán jaé tumi̱n? Xlacán takálhti̱lh: ―Tatzokni̱t ixtacuhui̱ní ixretrato lanca ma̱paksi̱na romano. ");
INSERT INTO topNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ca̱huánilh: ―Pues cama̱xquí̱tit lanca ma̱paksi̱na romano tú xlá mini̱ní y cama̱xquí̱tit Dios tú xlá lacasquín milacatacán. ");
INSERT INTO topNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Xlacán a̱huata acs tatá̱yalh, yaj tacátzi̱lh tú natakalasquiní porque Jesús ni̱cxni ixaktzanká. ¡Tancs ixkalhti̱nán ixlacati̱ncán cristianos! ");
INSERT INTO topNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A̱stá̱n talákalh Jesús makapitzi tí tahuán ni̱ talacastacuanán ni̱n nac ca̱li̱ní̱n y takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, nac ixtapáksi̱t Moisés huan, para cha̱tum chixcú tamakaxtokni̱t y ní, la̱ta ni̱ ca̱kalhi̱ni̱t ixcamán, xatajó ixta̱cam cata̱tamakáxtokli ixya̱stá y catakálhi̱lh ixcamancán xlacata ni̱ nalaksputa ixtacuhui̱ní ixta̱cam. ");
INSERT INTO topNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Maktum ixtalama̱na cha̱tujún li̱ta̱camán. Xapuxcu tamakáxtokli y ni̱lh ni̱ para takálhi̱lh ixcamancán. ");
INSERT INTO topNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ixli̱cha̱tuy ixta̱cam ta̱tamakáxtokli ixya̱stá, pero na̱ ni̱lh y ni̱ takálhi̱lh ixcamancán. ");
INSERT INTO topNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ixli̱cha̱tutu ixta̱cam na̱ ta̱tamakáxtokli ixya̱stá, y hua̱k xa̱makapitzi na̱ chuná. Pero hua̱k táni̱lh y ni̱ cha̱tum tí kálhi̱lh ixcamán. ");
INSERT INTO topNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Hasta cha̱lh quilhtamacú amá pusca̱t na̱ ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chí quila̱huaníu, acxni natalacastacuanán nac ca̱li̱ní̱n, ¿ticu ixta̱cha̱t nahuán pues hua̱k ixcha̱tujuncán li̱ta̱camán ta̱tamakáxtokli amá pusca̱t? ");
INSERT INTO topNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús ca̱kálhti̱lh: ―Huixín catzi̱yá̱tit juú ca̱quilhtamacú, hua̱k lacchixcuhuí̱n y lacchaján tatamakaxtoka. ");
INSERT INTO topNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero amá cristianos tí ca̱lacsacni̱t Dios natalacastacuanán ca̱li̱ní̱n y natalatamá nac akapú̱n, ya̱cxni ama tatamakaxtoka, ni̱ para tama̱makaxtoka ixcamancán. ");
INSERT INTO topNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ama talatamá cani̱cxnihuá quilhtamacú la̱ ángeles, pues tí lacastacuanán ca̱li̱ní̱n li̱ma̱nu̱cán xli̱ca̱na ixcam Dios. ");
INSERT INTO topNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","¿Pero huixín catzi̱putuná̱tit para talacastacuanán ni̱n? Calacapa̱stáctit tú tzokli Moisés nac Escrituras, xlá huan la̱ ta̱chihuí̱nalh Dios la̱ta itlhcuta̱yama akatum quihui y huánilh la̱ Dios ixca̱maktakalhmajcú Abraham, Isaac y Jacob, ma̱squi xlacán maká̱n ixtani̱ni̱ttá. ");
INSERT INTO topNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios lama xastacnán huá tla̱n ca̱li̱ma̱lacastacuaní ni̱n nac ca̱li̱ní̱n. Hua̱k tí tastacnán y tí tani̱ti̱lhá ca̱quilhtamacú tamacuaní namá xastacnán Dios. ");
INSERT INTO topNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Makapitzi ixma̱kalhtahuake̱nacán judíos tí ixtalaya̱na aná tahuánilh Jesús: ―¡Maestro, xli̱ca̱na tancs kalhti̱nani̱ta! ");
INSERT INTO topNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","A̱stá̱n yaj tí kálhi̱lh li̱camama tí nakalhputzá Jesús xlacata ixacstu natalaksí. ");
INSERT INTO topNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ca̱kalasquínilh hua̱k cristianos: ―¿Hua̱nchi huancán xlacata Cristo tí ama ca̱lakma̱xtuyá̱n, ixli̱talakapasni xamaká̱n rey David ama huan? ");
INSERT INTO topNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ca̱ksántit la̱ David tzokli lacatum nac ixlibro huanicán Salmos: Dios huánilh Quimpu̱chiná tí ama quilakma̱xtú: “Catahuila nac quimpa̱xtú̱n quinta̱ma̱paksí̱nanti, ");
INSERT INTO topNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta xní nacca̱makatlajá hua̱k mienemigos xlacata acxtum natalakachixcuhui̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Huá cca̱li̱huaniyá̱n, ¿nicu li̱puhuaná̱tit xlacata Cristo ixli̱talakapasni rey David nahuán si pi̱huá rey David li̱macá̱n ixpu̱chiná tí ama lakma̱xtú? ");
INSERT INTO topNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesús ca̱huánilh ixdiscípulos la̱ta takaxmatma̱na hua̱k cristianos: ");
INSERT INTO topNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Huixín ni̱ caca̱makslihuekétit ixkasatcán namá ixma̱kalhtahuake̱nacán judíos tí tama̱sí ixtachihuí̱n Dios. Xlacán talakatí tahuilí lactla̱n laclhmá̱n lháka̱t, nac li̱tamá̱u talacasquín caca̱huanica kalhé̱n la̱ lactali̱pa̱u lacchixcuhuí̱n. Nac ixpu̱tamakstoknicán judíos talakatí tatahuilá nac lactlá̱n pu̱táhui̱lh y nac fiestas talacasquín pu̱la caca̱ma̱hui̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Na̱ chuná ta̱kskahuimaklhtí ixchiccán viudas, y xlacata ni̱tí tú naca̱li̱ya̱huá li̱catzi lhu̱hua tú tali̱kalhtahuake̱ní Dios. Pero ni̱ para talacpuhuán xlacata xlacán ma̱s lhu̱hua castigo ama̱ca ca̱ma̱xqui̱cán. ");
INSERT INTO topNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ácxilhli nac pu̱siculan la̱ lhu̱hua lacricos lacchixcuhuí̱n ixtamujú lhu̱hua tumi̱n nac ixpu̱muju̱cán limosna. ");
INSERT INTO topNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ixli̱puntzú na̱ talacatzúhui̱lh cha̱tum viuda pusca̱t y huata múju̱lh mactuy lactzú tumi̱n xla cobre, casi ni̱tú ixtapalh ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús ca̱huánilh ixdiscípulos: ―Aquit tancs cca̱huaniyá̱n, namá koxitá viuda pusca̱t, má̱sta̱lh ma̱s lhu̱hua ixlimosna ixlacati̱n Dios que hua̱k namá ricos tí tamúju̱lh lhu̱hua tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porque ricos tamúju̱lh ixlimosnajcán tumi̱n ni̱ma̱ ca̱kalhta̱xtuní, pero namá viuda má̱sta̱lh actzú ixtumi̱n ni̱ma̱ ixama macuaní nali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maktum chichiní makapitzi ixdiscípulos Jesús tzúculh tali̱chihui̱nán laclá̱n chíhuix y tú ixtama̱squihui̱nani̱t cristianos xlacata nali̱ca̱xya̱huacán amá lanca pu̱siculan xla Jerusalén. Jesús ca̱kalhpaktánu̱lh y ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Talacatzuhui̱ma quilhtamacú ama̱ca lactlahuako̱cán hua̱k jaé ixli̱taca̱xta̱y pu̱siculan ni̱ma̱ acxilhpa̱nántit, ni̱ ama tamakxtaka ni̱ para akstum chíhuix nac ixpu̱ta̱y hua̱k pá̱tzaps. ¡Hua̱k ama̱ca lactilhcán! ");
INSERT INTO topNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xlacán takalasquínilh: ―Maestro, ¿xnicu ama qui̱taxtú tú huana? ¿Tucu xla̱huán camá̱n acxilhá̱u xlacata naccatzi̱yá̱u kantaxtuma mintachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús ca̱kálhti̱lh: ―Huixín skálalh calatapá̱tit ni̱tí naca̱kskahuiyá̱n. Porque lhu̱hua lacchixcuhuí̱n ta̱má̱n tali̱tanú quilakapu̱xoko y tahuán: “Aquit Cristo”, y “Accha̱ni̱t quilhtamacú camá̱n ca̱lakma̱xtuyá̱n.” Huixín ni̱ caca̱najlátit. ");
INSERT INTO topNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Acxni nakaxpatá̱tit li̱chihui̱nancán guerras y la̱ tara̱makní cristianos, ni̱ cajicuántit pues tamaclacasquiní pu̱la chú naqui̱taxtú y jaé cajcu ixquilhtzúcut tú ama lá a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aktum pu̱latama̱n ama ta̱ra̱nica xa̱ktum pu̱latama̱n y aktum ca̱chiquí̱n ama ta̱ra̱nica xa̱ktum ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cani̱huá pu̱latama̱n xala ca̱quilhtamacú ama tachiquí tíyat, ama lá tatzíncsnit, ama min ti̱pa̱katzi tá̱tat y ama ca̱makní cristianos. Nac akapú̱n li̱cuánit pa̱t acxilá̱tit tú ni̱cxni ixtasi̱ni̱t y tú li̱xcájnit pa̱t li̱lacahua̱naná̱tit ni̱ para li̱ca̱najlaputu. ");
INSERT INTO topNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero antes nalakchá̱n tú jaé cca̱huanimá̱n, huixín pa̱t ca̱ma̱kxtakajni̱caná̱tit caj quilacata, pa̱t tza̱latapu̱li̱yá̱tit, pa̱t ca̱ma̱nu̱caná̱tit nac pu̱la̱chi̱n, pa̱t ca̱ma̱kalhapali̱caná̱tit nac ixpu̱tamakstoknicán judíos y ca̱li̱pincaná̱tit ixlacati̱ncán reyes y xanapuxcun ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chuná huixín tla̱n nama̱luloká̱tit para xli̱ca̱na quila̱li̱puhuaná̱u. ");
INSERT INTO topNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pero huixín ni̱ cali̱puhuántit liaklhu̱hua̱tnaná̱tit tú pa̱t kalhti̱naná̱tit acxni naca̱ma̱kalhapali̱caná̱tit; ");
INSERT INTO topNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","porque aquit cama ca̱ma̱xqui̱yá̱n tachihuí̱n y li̱skala ni̱ma̱ naca̱kalhti̱yá̱tit mienemigos, y xlacán ni̱ para lá ama ca̱ta̱ra̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Huixín tí li̱tanu̱yá̱tit quidiscípulos amá̱n ca̱macama̱sta̱yá̱n ixmacán mienemigos ma̱squi minati̱cún, minata̱camán, miamigos y mili̱talakapasni, y makapitzi huixín pa̱t ca̱makni̱caná̱tit. ");
INSERT INTO topNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Cati̱huá ama ca̱si̱tzi̱niyá̱n caj xlacata quila̱li̱pa̱huaná̱u tlahuayá̱tit tú cca̱li̱ma̱paksi̱ni̱tán. ");
INSERT INTO topNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ni̱ para kanstum minchixitcán xalac miakxa̱kacán ama laktzanká. ");
INSERT INTO topNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Porque amá tí ni̱ li̱tzonkcatzán li̱scuja tú lactanu̱ni̱t, huá namá ama lakma̱xtú ixli̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Acxni naca̱cxilá̱tit soldados tastilima̱na ca̱chiquí̱n Jerusalén, cacatzí̱tit accha̱ni̱t quilhtamacú ama̱ca ma̱kxtakajni̱cán y lactlahuacán. ");
INSERT INTO topNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Amá quilhtamacú tí talama̱na nahuán nac Judea, catatzá̱lalh tuncán nac ca̱lacsipijni; tí talama̱na nac Jerusalén catatzáksalh tataxtú xlacata ni̱ naca̱kchipanu̱cán. Tí ta̱ni̱t nahuán ixca̱tucuxtucán catatzá̱lalh la̱ta taya̱na, ni̱ catatáspitli nac ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Huá jaé quilhtamacú ama ca̱ma̱xoko̱ní Dios jaé cristianos tú tatlahuani̱t. Ama kantaxtukó tú tali̱chihui̱nani̱t profetas nac Escrituras. ");
INSERT INTO topNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","’¡Koxitani̱n lacchaján tí takalhí nahuán itskatá̱n y ya̱ talakahuán, o tatziquijcú! ¡Li̱cuánit ama ca̱ma̱kxtakajni̱cán cristianos xala jaé pu̱latama̱n! ¡Pero yaj lá tú ama tatlahuá a̱huata ama tamacpa̱tí tú naca̱lakchá̱n! ");
INSERT INTO topNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lhu̱hua cristianos ama̱ca ca̱makni̱cán nac tara̱nicni y lhu̱hua ama ca̱li̱ncán la̱ tachí̱n cani̱hua a̱lacatunu pu̱latama̱n. Namá lacchixcuhuí̱n tí ni̱ tali̱pa̱huán Dios ama tali̱chiyá talacta̱yamí Jerusalén hasta xní nakantaxtukó la̱ laclhca̱ni̱t Dios nata̱kxtakajnán. ");
INSERT INTO topNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Amá quilhtamacú acxni nacmimpará cristianos ta̱má̱n ta̱cxila nac chichiní, nac papá, nac stacu tú ni̱cxni ixtasi̱ni̱t. Cristianos xala ca̱quilhtamacú ama ta̱klhu̱hua̱tnán y ca̱maka̱klhá acxni nata̱cxila la̱ tatlanca̱ní chúchut nac pupunú y tali̱lacahua̱nán tú ni̱cxni ixtapuhuán tla̱n qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lhu̱hua cristianos hasta ama ta̱kuití la̱ta ama talakaputzá y tajicuán acxni natzucú tali̱lacahua̱nán tú ama qui̱taxtú ca̱quilhtamacú pues hasta la̱ta tú huí nac akapú̱n ama tachiquí. ");
INSERT INTO topNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Entonces hua̱k cristianos xala ca̱quilhtamacú ama quinta̱cxila aquit Xatalacsacni Chixcú cama ta̱ctá nac puclhni nac akapú̱n xlacata nacma̱sí ixli̱lanca quili̱ma̱paksí̱n y quili̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Acxni na̱cxilá̱tit tzucú kantaxtú tú cca̱huanimá̱n capa̱xahuátit y catalacaya̱huátit li̱pa̱xáu porque talacatzuhui̱ma quilhtamacú nacmín ca̱tiyayá̱n aquit tí cama ca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús ca̱li̱ma̱lacastúcnilh ixtalacapa̱stacni jaé takalhchihuí̱n: ―Cali̱lacahua̱nántit tú pa̱xtoka katum suja o catu̱ya̱hua quihui; ");
INSERT INTO topNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","acxni acxilá̱tit tzucú akasnapankán taxtuní lactzu ixpakán, huixín catzi̱yá̱tit xlacata talacatzuhui̱ma ixquilhta lhca̱cná. ");
INSERT INTO topNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na̱ chuná acxni huixín na̱cxilá̱tit tzucú kantaxtú tú cca̱huanín, cama̱kachakxí̱tit talacatzuhui̱ma quilhtamacú la̱ nama̱kantaxtí Dios tú ma̱lacnu̱ni̱t nama̱paksi̱nán ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ixli̱hua̱k quinacú cca̱huaniyá̱n, lhu̱hua cristianos tí talaya̱na juú ama ta̱cxila la̱ ama kantaxtú tú cca̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Porque akapú̱n y ca̱quilhtamacú ama laklakó, pero quintachihuí̱n ni̱ chu̱ta ama laktzanká, ¡kastunu ama kantaxtú tú cca̱huanín! ");
INSERT INTO topNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Huixín siempre skálalh calatapá̱tit y ni̱ cali̱makxtáktit minacujcán catachípalh ni̱ lactlá̱n tijia, o huata cachipa̱nántit, o huata li̱puhuaná̱tit milatama̱tcán. ¡Porque ni̱ clacasquín aktziyaj nacca̱chipayá̱n amá quilhtamacú la̱ tí huili̱cán trampa y tahuacaya̱chá! ");
INSERT INTO topNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porque chuná cama ca̱lakchín amá quilhtamacú hua̱k cristianos xala cani̱huá pu̱latma̱n xala ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chí ixli̱maklhu̱hua cca̱huaniparayá̱n: skálalh calatapá̱tit siempre cakalhtahuakanítit Dios xlacata nakalhi̱yá̱tit li̱camama ta̱layá̱tit namá ta̱kxtakajni ni̱ma̱ ca̱laclhca̱nicani̱t cristianos, y chuná ni̱ li̱ma̱xaná naquila̱ma̱lacatzuhui̱yá̱u acxni nacmín aquit Xatalacsacni Chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Chuná amá Jesús ca̱cuhui̱ní ixca̱ma̱kalhchihui̱ní cristianos nac pu̱siculan xla Jerusalén, y ca̱tzisní ixtaxtú ixán lhtatá nac Cerro de los Olivos. ");
INSERT INTO topNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Cha̱li cha̱lí tzisa ixtachín lhu̱hua cristianos xlacata natakaxmata ixtachihuí̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Chuná amá tzúculh talacatzuhuí chichiní nalakchá̱n xatacuhui̱ní pa̱xcua acxni judíos ixtahuá simi̱ta ni̱ kalhí levadura. ");
INSERT INTO topNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Xanapuxcun curas y ixma̱kalhtahuake̱nacán judíos tzúculh talacputzá la̱ tze̱k natamakní Jesús, pues como lhu̱hua cristianos ixtali̱pa̱huán Jesús ixtajicuán para natamaklhti̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Cha̱tum ixapóstol tí na̱ ixli̱lhca̱ni̱t nata̱scuja acxni ca̱lácsacli ixcha̱cu̱tuycán ixuanicán Judas Iscariote. Xlá makatlájalh ixtalacpuhuá̱n tlajaná, ");
INSERT INTO topNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","alh ca̱ta̱chihui̱nán xanapuxcun curas y tí ixtama̱paksi̱nán nac pu̱siculan, y ca̱ta̱laccá̱xlalh la̱ tze̱k naca̱macama̱xquí Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Acxni takáxmatli tú ca̱ma̱lacnú̱nilh Judas xlacán tapa̱xáhualh y tamá̱xqui̱lh tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas maklhtí̱nalh y la̱ta amá quilhtamacú tzúculh lacputzá la̱ namacama̱stá Jesús acxni ixacstu ixuí xlacata ni̱ natamaklhti̱nán cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Cha̱lh chichiní xatacuhui̱ní pa̱xcua acxni judíos ixtahuá simi̱ta ni̱ kalhí levadura, ixmakni̱cán tantum borrego ni̱ma̱ ixtali̱lakachixcuhui̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús ca̱li̱ma̱páksi̱lh Pedro y Juan catá̱lh taca̱xtlahuá li̱hualhtata tú natali̱lakachixcuhui̱nán amá xatacuhui̱ní pa̱xcua. ");
INSERT INTO topNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","―¿Nicu lacasquina nacaná̱u ca̱xtlahuayá̱u? ―takalasquínilh xlacán. ");
INSERT INTO topNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ca̱kálhti̱lh: ―Capítit nac Jerusalén, acxni nachipiná̱tit pa̱t acxilá̱tit cha̱tum chixcú cucalí̱n aktum xa̱lu chúchut. Catakokétit hasta xní natanú nac ákxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Huixín na̱ catanú̱tit y cahuanítit xapu̱china ákxtaka: “Huan quimaestrojcán, ¿nicu huí amá cuarto ní cama ca̱ta̱hualhtatá quidiscípulos jaé xatacuhui̱ní pa̱xcua?” ");
INSERT INTO topNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Xlá ama ca̱li̱ná̱n nac ixli̱quilhmactuy ixákxtaka, hua̱katá ca̱xlani̱t; aná huixín caca̱xtlahuátit li̱hualhtata. ");
INSERT INTO topNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xlacán ta̱lh y xli̱ca̱na hua̱k tatáka̱sli la̱ ca̱huánilh Jesús ama qui̱taxtú. Aná taca̱xtláhualh tahuá tú natali̱lakachixcuhui̱nán amá pa̱xcua. ");
INSERT INTO topNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Xalakasmalankán acxni áccha̱lh hora, Jesús ca̱tá̱alh xa̱makapitzi ixapóstoles, y acxni hua̱k tatahuilako̱lh nac mesa ");
INSERT INTO topNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús ca̱huánilh: ―Maká̱n xaclacpuhuani̱t nacca̱ta̱hualhtatayá̱n jaé pa̱xcua antes naquima̱kxtakajni̱cán quimakni̱cán. ");
INSERT INTO topNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porque chí cca̱huaniyá̱n yaj camá̱n ca̱ta̱hua̱yaná̱n la̱ chí cca̱ta̱hualhtatamá̱n. Nacca̱ta̱hua̱yamparayá̱n hasta acxni Dios nama̱kantaxtí tú xlacata quili̱ma̱lakacha̱cani̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A̱stá̱n tíyalh aktum vaso ni̱ma̱ ixtaju̱ma ixchúchut uva, pa̱xcatcatzí̱nilh Dios, ca̱má̱xqui̱lh ixdiscípulos y ca̱huánilh: ―Cahuátit catzuntín y cala̱ma̱kpitzítit mili̱hua̱kcán. ");
INSERT INTO topNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Xli̱ca̱na cca̱huaniyá̱n, chí a̱huatiyá tihuán ckalhuá̱nalh jaé ixchúchut uva ni̱ma̱ tamakalani̱t lacchixcuhuí̱n; acxni nactahuilá nac quimpu̱ma̱paksi̱n nac akapú̱n cama kalhua̱nán tunu xasa̱sti yaj la̱ jaé. ");
INSERT INTO topNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A̱stá̱n tíyalh simi̱ta, pa̱xcatcatzí̱nilh Dios, lakchékelh, ca̱má̱xqui̱lh ixapóstoles y ca̱huánilh: ―Cahuátit jaé simi̱ta porque huá namá quimacni ni̱ma̱ cama macama̱stá xlacata nacca̱lakma̱xtuyá̱n. Huixín catlahuátit xni̱ta lacasquiná̱tit xlacata naquila̱li̱lacapa̱stacá̱u. ");
INSERT INTO topNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","La̱ tahualhtatako̱lh tíyalh amá vaso ni̱ma̱ ixtapu̱kotnama̱na y ca̱huánilh: ―Jaé ixchúchut uva huá quinkalhni ni̱ma̱ cama ma̱stajá milacatacán xlacata nama̱luloka Dios tlahuani̱t sa̱sti ixtalacca̱xlán la̱ naca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero pu̱la ama quimacama̱stá cha̱tum chixcú tí quinca̱ta̱hua̱yamá̱n juú nac mesa. ");
INSERT INTO topNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Aquit Xatalacsacni Chixcú ctzucuni̱t clactla̱huán jaé ta̱kxtakajni ni̱ma̱ li̱lhca̱ni̱t Dios quilacata. ¡Pero koxitá namá chixcú tí ama quiliakskahuinán! ");
INSERT INTO topNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hua̱k ixapóstoles tzúculh tara̱kalasquiní cha̱tum cha̱tum cha̱ ticu ixama liakskahuinán. ");
INSERT INTO topNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A̱stá̱n tzúculh tara̱li̱huaní ticu yá ixapóstol ma̱s ixli̱pa̱huán Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Xlá chuné ca̱ma̱kalhchihuí̱ni̱lh: ―Huixín catzi̱yá̱tit xlacata reyes tí tama̱paksí aktum pu̱latama̱n tatlahuaní tú talacasquín amá cristianos tí tama̱paksí, y tí ta̱cpuxcún tama̱paksi̱nán ca̱li̱maca̱ncán lactla̱n lacchixuhuí̱n tí tatlahuá li̱tlá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero huixín nac milatama̱tcán ni̱ chuná ama qui̱taxtú porque tí ma̱s xatali̱pa̱u, cali̱tánu̱lh la̱ cha̱tum kahuasa tí ma̱paksi̱cán; y tí ma̱paksi̱nán, cali̱tamákxtakli la̱ cha̱tum tasa̱cua tí ma̱cha̱lhca̱tni̱cán. ");
INSERT INTO topNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Na̱ chuná catzi̱yá̱tit amá tí tali̱pa̱u chixcú, acxni hua̱yán, hua̱k ixtasa̱cua tamuju̱ní ixtahuá. Pero cali̱lacahua̱nántit la̱ aquit tali̱pa̱u chixcú siempre cca̱macuanini̱t cristianos tú quintali̱ma̱paksí. ");
INSERT INTO topNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Huixín siempre quila̱takokeni̱táu cani̱huá y akxtakajnani̱tántit nac quimpa̱xtú̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Como Quinti̱cú Dios quima̱xqui̱ni̱t quili̱ma̱paksí̱n, aquit na̱ cama ca̱ma̱xqui̱yá̱n li̱tlá̱n ");
INSERT INTO topNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","natahuilayá̱tit nac quimpu̱táhui̱lh xlacata lakxtum naquila̱ta̱hua̱yaná̱u y naquila̱ta̱pa̱xahuayá̱u. Huixín pa̱t tahuilayá̱tit nac mimpu̱ma̱paksi̱ncán xlacata naca̱ta̱tlahuayá̱tit taxokó̱n pu̱cu̱tuy cristianos tí tama̱lacatzúqui̱lh pu̱latama̱n Israel. ");
INSERT INTO topNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesús huánilh Pedro: ―Simón, cakáxpatti tú cuaniyá̱n: Tlajaná ma̱xqui̱cani̱t li̱tlá̱n nali̱cxila mintapuhua̱ncán na̱ chuná la̱ u̱n ma̱tzahuají katum actzú quihui y tlahuá la̱ lacasquín. ");
INSERT INTO topNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero aquit cli̱kalhtahuakani̱tán xlacata Dios ni̱ nali̱makxtaka nalakaputzaxni̱ya yaj nama̱lacatzuhui̱ya, y acxni nama̱kachakxi̱ya tú liaktzanka pa̱t li̱stacta̱yaya y tla̱n naca̱makta̱yaya ca̱ma̱camaja minata̱camán. ");
INSERT INTO topNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pedro huánilh: ―Quimpu̱chinacán, aquit hua̱k tla̱n cta̱yaní. ¡Hasta xacta̱tanú̱n nac pu̱la̱chi̱n para ixli̱pinca y xacta̱ní̱n para tamaclacasquiní! ");
INSERT INTO topNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús huánilh: ―Pedro, xli̱ca̱na cuaniyá̱n pi̱huá jaé ca̱tzisní antes natlí xla̱huán tantum pu̱yu, huix pa̱t huana maktutu xlacata ni̱ quilakapasa tí nakalasquiniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús ca̱kalasquínilh ixapóstoles: ―Acxni cca̱ma̱lakachá̱n naquila̱li̱chihui̱naná̱u y ni̱ ixli̱piná̱ntit morral, ni̱ para tumi̱n, ni̱ para mintatu̱nucán, ¿tucu ca̱tzanka̱nín? ―Ni̱tú quinca̱tzanka̱nín ―takálhti̱lh xlacán. ");
INSERT INTO topNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesús ca̱ta̱chihuí̱nalh: ―Pues chí cca̱huaniyá̱n: Tí kalhí morral, cacúcalh; tí kalhí tumi̱n cali̱lh; y tí ni̱ kalhí ixma̱chi̱ta, casta̱lh ixlháka̱t y catamá̱hualh. ");
INSERT INTO topNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque talacatzuhui̱ma quilhtamacú nakantaxtú amá tachihuí̱n ni̱ma̱ tatzokni̱t quilacata nac Escrituras: “Li̱maca̱nca ma̱lacapu̱cán la̱ cha̱tum makni̱ná.” La̱ta tú tali̱chihui̱nani̱t profetas quilacata, hua̱k ama kantaxtú. ");
INSERT INTO topNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ixapóstoles tahuánilh: ―Quimpu̱chinacán, aquín ckalhi̱yá̱u aktuy espada. ―¡Acs cata̱ya, chu̱ta cca̱li̱cxilhmá̱n! ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","A̱stá̱n ca̱ta̱táxtulh ixdiscípulos nac Jerusalén y ca̱tá̱alh nac Cerro de los Olivos la̱ ixli̱smani̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Acxni ca̱tá̱cha̱lh, ca̱huánilh: ―Cakalhtahuakanítit Dios xlacata ni̱ naca̱makatlahayá̱n ni̱ lactlá̱n talacpuhuá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Xlá alh ixli̱lakamákat la̱ li̱macatala̱tnancán aktum chíhuix. Aná tatzokóstalh, ");
INSERT INTO topNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","y chuné kalhtahuákalh: ―Quinti̱cú Dios, para lacasquina caquilakma̱xtu ni̱ cackalhuá̱nalh jaé ta̱kxtakajni ni̱ma̱ clakcha̱ma. Pero ni̱ clacasquín calalh tú clacpuhuán, huix catlahua quilacata tú catzi̱ya ma̱s quimini̱ní. ");
INSERT INTO topNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","La̱ta ixkalhtahuakama, cha̱tum ángel xalac akapú̱n lákchilh y má̱xqui̱lh li̱camama cata̱yánilh ixta̱kxtakajni. ");
INSERT INTO topNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","¡Ixnacú Jesús li̱cuánit ixakxtakajnán! ¡Aktum ixuili̱ni̱t ixtapuhuá̱n kalhtahuakanima Dios, hasta tzúculh xka̱ka la̱ kalhni! Katunu itxká̱kat ixtama̱ya̱chi ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Acxni kalhtahuakako̱lh tá̱yalh y ca̱lákalh ixdiscípulos, y ca̱ma̱nóklhulh talhtatama̱na, ixca̱makatlajani̱t ixtalakaputzi̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xlá ca̱huánilh: ―¿Hua̱nchi lhtatapa̱nántit? Calacastacuántit y cakalhtahuakanítit Dios xlacata ni̱ naca̱makatlajayá̱n ni̱ lactlá̱n talacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chu̱tacú ixchihui̱nama Jesús acxni cá̱cxilhli pu̱tum ixtamima̱na cristianos, ixca̱cpuxcún Judas amá ixapóstol tí ixca̱ta̱lacsacni̱t xa̱cha̱cu̱tuy natali̱scuja. Xlá ma̱lacatzúhui̱lh y lacáspu̱tli la̱ calakalhámalh cahuánilh kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús huánilh: ―Judas, ¿quilacáspu̱tti xlacata naquimacama̱sta̱ya aquit Xatalacsacni Chixcú? ");
INSERT INTO topNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Xa̱makapitzi ixdiscípulos acxni tá̱cxilhli tú ixakspulama Jesús takalasquínilh: ―Quimpu̱chinacán, ¿cca̱maklhti̱naná̱n con quiespadajcán ni̱ma̱ ckalhi̱yá̱u? ");
INSERT INTO topNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Antes nakalhti̱nán cha̱tum ixapóstoles ca̱ctí̱nilh xapakca̱na ixteké̱n ixtasa̱cua cha̱tum xapuxcu cura. ");
INSERT INTO topNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús huánilh: ―Ni̱ caquila̱maklhti̱náu. ¡Caca̱makxtáktit! A̱stá̱n li̱xámalh ixmacán ixtaké̱n amá tasa̱cua y tuncán cá̱xlalh la̱ ni̱tú calánilh. ");
INSERT INTO topNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús acs ca̱lacá̱nilh amá xanapuxcun curas, lakko̱lún ma̱paksi̱naní̱n y xanapuxcun policías tí ixtamaktakalhnán nac pu̱siculan. Xlá ca̱huánilh amá tí ixta̱ni̱t tachipá: ―Huixín li̱taná̱tit espadas y quihui la̱ catántit chipayá̱tit cha̱tum kalha̱ná. ");
INSERT INTO topNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿Hua̱nchi ni̱ quila̱chipáu nac pu̱siculan ní ixquila̱cxilá̱u cha̱li cha̱lí? Pero como ixtalacpuhuá̱n tlajaná ca̱makatlajani̱tán jaé quilhtamacú huixín ma̱kantaxti̱yá̱tit tú ca̱li̱ma̱paksi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Amá xanapuxcun policías tachípalh Jesús y táli̱lh nac ixpu̱ma̱paksi̱n xapuxcu cura. Pedro ca̱takókelh ixli̱lakamákat pakán ní ta̱lh. ");
INSERT INTO topNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Acxni tácha̱lh nac pu̱ma̱paksi̱n tamákxtakli nac lacaquilhti̱n ana ní soldados ixtama̱kstokni̱t lhcúya̱t ixtaskoma̱na. ");
INSERT INTO topNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cha̱tum squiti acxni ácxilhli aná itskoma Pedro ma̱lacatzúhui̱lh, acs lacá̱cxilhli y ca̱huánilh xa̱makapitzi: ―Jaé chixcú ixta̱lapu̱lá Jesús namá chixcú tí ma̱nu̱ca nac pu̱la̱chin. ");
INSERT INTO topNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro kalhtí̱nalh: ―Pusca̱t, aquit ni̱ para tziná clakapasa namá chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ixli̱puntzú tunu na̱ lakápasli y huánilh: ―Huix ixta̱lapu̱laya namá chixcú Jesús tí ma̱nu̱ca nac pu̱la̱chi̱n. Pero Pedro huá ixli̱maktuy: ―Huix aktzanka̱ni̱ta porque aquit ni̱ xacta̱lapu̱lá. ");
INSERT INTO topNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Alh ma̱x aktum hora acxni cha̱tum tancs ca̱ma̱lulóknilh xa̱makapitzi: ―Xli̱ca̱na jaé chixcú na̱ ixta̱lapu̱lá Jesús, pues talakapasá porque xlá na̱ xalac Galilea. ");
INSERT INTO topNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ixli̱maktutu Pedro ca̱huánilh: ―Huixín akskahuinampa̱nántit porque aquit ni̱ clakapasa namá tí quila̱li̱ta̱chihui̱nama̱náu. Chu̱ta ixchihui̱namajcú acxni káxmatli la̱ tli̱lh tantum pu̱yu. ");
INSERT INTO topNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesús ixli̱lakamákat talakáspitli, ¡acs lacamínilh Pedro! Acxni tuncán lacapá̱stacli tú ixuanini̱t amá ca̱tzisní: “Pi̱huá jaé ca̱tzisní antes natlí tantum pu̱yu huix pa̱t huana maktutu ni̱ quilakapasa tí nakalasquiniyá̱n.” ");
INSERT INTO topNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lacapala táxtulh y tzúculh tasá la̱ta ixli̱puhuán ixnacú tú ixqui̱taxtunini̱t. ");
INSERT INTO topNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Amá lacchixcuhuí̱n tí ixtamaktakalhma̱na Jesús tzúculh tali̱chiyá, ixtalakakaxí, ");
INSERT INTO topNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","tali̱lakáchi̱lh lháka̱t, y a̱stá̱n ixtahuaní: ―Para xli̱ca̱na huix profeta, caquilhchipi ticu ma̱xquí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lhu̱hua ma̱s tú tatlahuánilh xlacata natali̱kalhkama̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Acxni spalh ca̱huanko̱lh pu̱tum tatamákstokli xanapuxcun ma̱paksi̱naní̱n, xanapuxcun curas, ixma̱kalhtahuake̱nacán judíos, y táli̱lh Jesús ixlacatí̱n xanapuxcun ixma̱kalhapali̱naní̱n tachi̱ní̱n. Xlacán takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Quila̱huaníu, ¿xli̱ca̱na huix Cristo tí ama quinca̱lakma̱xtuyá̱n? Jesús ca̱kálhti̱lh: ―Para cca̱huaniyá̱n xli̱ca̱na huixín ni̱ ama quila̱ca̱najlaniyá̱u, ");
INSERT INTO topNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","y para cca̱kalasquiniyá̱n tucu xlacata, ni̱ ama quila̱kalhti̱yá̱u, ni̱ para ama quila̱makxtaká̱u. ");
INSERT INTO topNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero talacatzuhui̱ma quilhtamacú xlacata aquit Xatalacsacni Chixcú nactahuilá ixpa̱xtú̱n ixpu̱ma̱paksi̱n lanca Quinti̱cu Dios. ");
INSERT INTO topNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hua̱k takalasquínilh: ―Entonces, ¿xli̱ca̱na huix Ixkahuasa Dios? ―Xli̱ca̱na aquit Ixkahuasa Dios ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Amá xanapuxcun ixma̱kalhapali̱naní̱n tachí̱n tzúculh tara̱huaní: ―Hua̱k aquín kaxmatni̱táu la̱ liakskahuinani̱t ixquilhni. ¿Tucu ma̱s taputzá̱n lacasquiná̱u xlacata nama̱xoko̱ni̱yá̱u ixtala̱kalhí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","A̱stá̱n amá xanapuxcun ixma̱kalhapali̱naní̱n tachí̱n táli̱lh Jesús nac ixpu̱ma̱paksi̱n Pilato, ");
INSERT INTO topNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","y nac ixlacatí̱n tzúculh tali̱ya̱huá ta̱kskahuín ixtahuán: ―Aquín cma̱lacapu̱yá̱u jaé chixcú porque ca̱kastacya̱huama cristianos xalac quimpu̱latama̱ncán catalacatá̱qui̱lh. Huan xlacata ni̱ mini̱ní naclakaxokoniyá̱u tumi̱n lanca ma̱paksi̱na romano, y xa̱huá li̱tanú Cristo rey tí ama quinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kalasquínilh: ―¿Xli̱ca̱na huix ixreycán judíos? ―Xli̱ca̱na la̱ huana aquit rey ―kalhtí̱nalh Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilato ca̱lacá̱nilh amá xanapuxcun ma̱kalhapali̱naní̱n curas y hua̱k cristianos, y ca̱huánilh: ―Aquit ni̱ ctaka̱sa tú nacli̱ya̱huá jaé chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Xlacán maklhu̱hua takálhti̱lh: ―Namá chixcú ca̱kastacya̱huá cristianos cani̱huá pu̱latama̱n catalacatá̱qui̱lh. Tzúculh ma̱sí ixtachihuí̱n nac Galilea, a̱stá̱n nac Judea y chí chini̱t juú nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Acxni káxmatli Pilato jaé tachihuí̱n kalasquiní̱nalh para Jesús xalac Galilea ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Como xlacán tahuánilh Jesús xalac Galilea ixuani̱t, gobernador Pilato áksalh xlacata rey Herodes ixmini̱t paxia̱lhnán nac Jerusalén, y como huá ixma̱paksí Galilea, ca̱huánilh catalí̱nilh rey Herodes xlacata huá nama̱kalhapalí. ");
INSERT INTO topNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Rey Herodes maká̱n ixkaxmatni̱t la̱ ixli̱chihui̱nancán tú ixtlahuá Jesús, ixlakapasputún. Huá xlacata acxni ácxilhli pa̱xahuako̱lh porque ixlacasquín cali̱ma̱lacahuá̱ni̱lh aktum ixtascújut Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pero xlá ni̱ para akstum tachihuí̱n kálhti̱lh la̱ta tú kalasquínilh acxni ma̱kalhapáli̱lh; ");
INSERT INTO topNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","porque amá xanapuxcun curas y ixma̱kalhtahuake̱nacán judíos lhu̱hua tú tali̱yá̱hualh Jesús ixlacatí̱n Herodes. ");
INSERT INTO topNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Xlá li̱cuánit sí̱tzi̱lh; itsoldados na̱ chuná tzúculh tali̱chiyá tali̱kalhkama̱nán, tama̱lhéke̱lh aktum lhma̱n lháka̱t la̱ xla rey. A̱stá̱n ma̱lakacha̱nipá gobernador Pilato. ");
INSERT INTO topNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Amá chichiní rey Herodes y gobernador Pilato talaccá̱xlalh amigos natahuán porque xapu̱lh ixtara̱si̱tzi̱ní ni̱ ixtara̱cxilhputún. ");
INSERT INTO topNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ca̱ma̱makstokpá xanapuxcun curas, xalactali̱pa̱u ma̱paksi̱naní̱n y hua̱k cristianos xala ca̱chiquí̱n, ");
INSERT INTO topNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","y ca̱huánilh: ―Huixín ma̱lacapú̱tit jaé chixcú y li̱ya̱huayá̱tit ca̱kastacya̱huá cristianos catalacatá̱qui̱lh; pero aquit cma̱kalhapáli̱lh cmilacati̱ncán y ni̱ ctaka̱sni̱t tala̱kalhí̱n tú nacli̱ya̱huá la̱ huaná̱tit huixín. ");
INSERT INTO topNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes na̱ chuná ni̱ táka̱sli tú nali̱ya̱huá, huá quili̱ma̱lakacha̱nipá. Jaé chixcú ni̱ tlahuani̱t tú mini̱ní namakni̱cán. ");
INSERT INTO topNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Huata cama castigartlahuá tziná y cama makxtaka caalh. ");
INSERT INTO topNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Amá xatacuhui̱ní pa̱xcua Pilato siempre ixmakxtaka cha̱tum tachí̱n xlacata naca̱lakalhamán cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilato ni̱ para cátzi̱lh acxni pu̱tum tama̱ktási̱lh hua̱k cristianos: ―¡Camakni namá chixcú y camákxtakti Barrabás! ");
INSERT INTO topNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jaé chixcú Barrabás ixma̱nu̱cani̱t nac pu̱la̱chi̱n porque ixma̱lacatzuqui̱ni̱t tara̱nicni nac ca̱chiquí̱n, y xa̱huá ixmakni̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ixmakxtakputún Jesús y chú ca̱huanipá cristianos xlacata ni̱tú ixtlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero xlacán ni̱ ixtali̱makxtaka ta̱ktasá: ―¡Camakni nac culu̱s! ¡Camakni nac culu̱s! ");
INSERT INTO topNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato ixli̱maktutu ca̱huánilh: ―¿Hua̱nchi? ¿Tucu yá tala̱kalhí̱n tlahuani̱t jaé chixcú? Aquit ni̱ ctaka̱sa tú nacli̱ya̱huá xlacata nacli̱ma̱paksi̱nán namakni̱cán. Huata cama li̱ma̱paksi̱nán camaksnokca y cama makxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero xlacán ma̱schá tzúculh ta̱ktasá camakni̱ca nac culu̱s, y lakasu̱t tzúculh tamakatlajá Pilato la̱ta ixta̱ktasá. ");
INSERT INTO topNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Acxni yaj cátzi̱lh tú natlahuá, Pilato ma̱tlá̱nilh namakni̱cán Jesús la̱ ixtalacasquín amá cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A̱stá̱n mákxtakli Barrabás amá chixcú tí ixtanu̱ma nac pu̱la̱chi̱n xlacata ixma̱lacatzuqui̱ni̱t tara̱nicni nac ca̱chiquí̱n y ixmakni̱nani̱t, y li̱ma̱paksí̱nalh camakni̱ca Jesús la̱ ixtalacasquín amá xanapuxcun curas. ");
INSERT INTO topNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesús ma̱cuqui̱ca ixculu̱s y li̱nca pakán ní ixama̱ca makni̱cán. Nac tijia ta̱tanoklhca cha̱tum chixcú xalac Cirene ixuanicán Simón, ixtaspitma ixca̱tucuxtu; xafuerza tlahuaca camaktá̱yalh catá̱li̱lh ixculu̱s Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhu̱hua cristianos ixtatakokeni̱t pakán ní ixama makni̱cán nac culu̱s; lhu̱hua lacchaján ixtalaktasá y ixtalakaputzá la̱ ixma̱kxtakajni̱ma̱ca Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Xlá acs ca̱lacá̱nilh y ca̱huánilh: ―Lacchaján xalac Jerusalén, ni̱ catasátit quilacata, ma̱s cali̱lakaputzátit tú pa̱t pa̱xtoká̱tit huixín y mincamancán. ");
INSERT INTO topNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque ama cha̱n quilhtamacú acxni pa̱t puhuaná̱tit: “Catapa̱xáhualh namá lacchaján tí ni̱ takálhi̱lh ixcamancán, tí ni̱ talakáhualh itskatacán, tí ni̱cxni tama̱tziquí̱nalh.” ");
INSERT INTO topNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lhu̱hua ama tahuán: “Ma̱s tla̱n ixquinca̱ctamá̱n aktum sipi, caquinca̱ma̱tze̱kni tijia xlacata ni̱ naquinca̱lakcha̱ná̱n ta̱kxtakajni.” ");
INSERT INTO topNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aquit cli̱tanú xastaka quihui y ca̱cxílhtit tú quintlahuanima̱ca. Calacpuhuántit, ¿tucu ni̱ natlahuanicán amá xascahuahua quihui? ");
INSERT INTO topNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Cha̱tuy makni̱naní̱n na̱ ixca̱ta̱li̱ncán Jesús na̱ ixama̱ca ca̱makni̱cán amá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Acxni tácha̱lh lacatum ní ixuanicán La Calavera, akxtokohuacaca Jesús nac culu̱s, y amá lacchixcuhuí̱n na̱ ca̱kxtokohuacaca y ca̱ma̱huacaca cha̱tunu nac ixpa̱xtu̱ni̱tni. ");
INSERT INTO topNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Acxni lihua ixtama̱huacama̱na nac culu̱s Jesús chuné chihuí̱nalh: ―Quinti̱cu Dios, caca̱ma̱tzanke̱nani tú quintatlahuánilh jaé lacchixcuhuí̱n porque ni̱ tacatzí tú tama̱kantáxti̱lh. Amá soldados tzúculh tara̱li̱slaka ticu nata̱tamakxtaka ixlháka̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lhu̱hua cristianos xala amá ca̱chiquí̱n ixta̱cxilhma̱na la̱ ixtlahuacani̱t Jesús y xanapuxcun curas ixtali̱kalhkama̱nán: ―Ca̱maktá̱yalh lhu̱hua cristianos, ca̱lakma̱xtúnilh ixli̱stacnicán; chí catá̱ctalh ixacstu nac culu̱s ní huaca xlacata naquinca̱ma̱si̱niyá̱n huá Cristo tí lacsacni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Makapitzi soldados na̱ tzúculh tali̱chiyá tama̱lacnú̱nilh vinagre xla uva. ");
INSERT INTO topNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ixtali̱kalhkama̱nán: ―Para xli̱ca̱na huix ixreycán judíos, chí mi̱cstu calakma̱xtu mili̱stacni. ");
INSERT INTO topNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Nac ixakspú̱n ixculu̱s Jesús ixtatzokni̱t tachihuí̱n nac griego, latín y hebreo tachihuí̱n; ixuán: “Jaé chixcú ixreycán judíos.” ");
INSERT INTO topNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cha̱tum makni̱ná tí na̱ ixakxtokohuacacani̱t ixya̱huacani̱t nac ixpa̱xtú̱n, na̱ tzúculh li̱kalhkama̱nán, ixuán: ―Para xli̱ca̱na huix Cristo, calakma̱xtu mili̱stacni y na̱ caquila̱lakma̱xtúu aquín. ");
INSERT INTO topNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Xa̱cha̱tum ixcompañero lakakahuánilh y huánilh: ―¡Acs cata̱ya! Huix xli̱ca̱na ni̱ jicuaniya Dios ma̱squi huaca nac culu̱s xoko̱námpa̱t mintala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aquín quinca̱mini̱niyá̱n caakxtakajnáu porque xokoma̱náu quintala̱kalhi̱ncán ni̱ma̱ tlahuani̱táu, pero jaé chixcú akxtakajnama ma̱squi ni̱tú tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A̱stá̱n lacá̱nilh Jesús y huánilh: ―Caquilacapá̱stacti acxni natzucuya ma̱paksi̱nana nac mintapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kálhti̱lh: ―Xli̱ca̱na cuaniyá̱n, la̱ta chí tuncán li̱pa̱xáu pa̱t quinta̱latapa̱ya nac quimpu̱latama̱n ni̱ma̱ cama maklhti̱nán. ");
INSERT INTO topNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Acxni cha̱lh lacatastúnut chichiní talakátze̱kli y hua̱k ca̱quilhtamacú tapaklhtu̱tako̱lh. Qui̱tá̱yalh hasta como aktutu hora xalakasmalankán. Ixli̱lakalhapá̱n pu̱siculan xla Jerusalén ní ixtalakachixcuhui̱nán curas ca̱ta ca̱ta táxti̱tli nac ixíta̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na̱ acxni tuncán Jesús aktásalh: ―Quinti̱cu Dios, huix cmacama̱xqui̱yá̱n quili̱stacni. La̱ huanko̱lh jaé tachihuí̱n Jesús tuncán ni̱ko̱lh nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Amá xacapitán soldados acxni ácxilhli tú ixqui̱taxtunini̱t Jesús, lacapá̱stacli Dios y chuné chihuí̱nalh: ―Xli̱ca̱na jaé chixcú ni̱tú ixkásat ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hua̱k cristianos tí ixtamini̱t ta̱cxila amá tamakní̱n, acxni ta̱cxilhko̱lh la̱ta tú ixpa̱xtokni̱t Jesús ta̱lh nac ixchiccán ixtali̱puhuanti̱lhá tú ixtatlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ixamigos Jesús tí ixtalakapasa y amá lacchaján tí ixtatakokeni̱t acxni a̱huata titáxtulh nac Galilea, lakamákat ixtaya̱na ixta̱cxilhko̱ni̱t la̱ta tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cha̱tum chixcú tí na̱ ixca̱ta̱ma̱paksi̱nán ixma̱kalhapali̱naní̱n tachí̱n nac Jerusalén ixuanicán José ixlama nac Arimatea, jaé ca̱chiquí̱n ixli̱tapaksí Judea. Xlá tla̱n ixcatzí y tancs ixlama ixlacatí̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José ixkalhi̱ma nalacatzucú ixtapáksi̱t Dios ca̱quilhtamacú y ni̱ ixma̱tla̱ni̱ni̱t tú ixtatlahuani̱t ixcompañeros. ");
INSERT INTO topNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Lákalh gobernador Pilato y huánilh camacamá̱xqui̱lh xaní̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pilato ma̱tlá̱ni̱lh y xlá alh ma̱ctí Jesús nac ixculu̱s. Tla̱n li̱máksuitli aktum sábana y a̱stá̱n má̱nu̱lh nac aktum ixpu̱ma̱nu̱cán ni̱n ni̱ma̱ ixtalacahuaxni̱t nac lacatalhpa̱n y ni̱ naj tí ixma̱nu̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pi̱huá amá lakasmalankán viernes judíos ixtaca̱xuilí ixtahuajcán porque istzucú chichiní ixli̱jaxatcán. ");
INSERT INTO topNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amá lacchaján tí ixtata̱mini̱t Jesús nac Galilea, tatakókelh José y tá̱cxilhli amá ixpu̱ma̱nu̱cán ni̱n ní ná̱nu̱lh xaní̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lacapala ta̱lh nac ixchiccán y tzúculh talacca̱xtlahuá perfume tú natamacuilí Jesús acxni nati̱taxtukó quilhtamacú ixli̱jaxatcán. Xlacán na̱ tájaxli amá chichiní la̱ ixtali̱smani̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ixli̱tu̱xama domingo tzisa, acxni ixlacatzucú xama̱na, amá lacchaján ta̱lh ana ní ixma̱nu̱cani̱t Jesús; ixtalí̱n perfumes ni̱ma̱ ixtalacca̱xtlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Acxni tácha̱lh tá̱cxilhli ixma̱ke̱nu̱cani̱t chíhuix ni̱ma̱ ixli̱talakatalán ní ixma̱nu̱cani̱t xaní̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Y acxni tatánu̱lh tá̱cxilhli ¡ni̱tú ixtanu̱ma ixmacni Ixpu̱chinacán Jesús! ");
INSERT INTO topNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xlacán tajicuanko̱lh ni̱ ixtama̱kachakxí tú ixqui̱taxtuni̱t. Ni̱ para tacátzi̱lh la̱ ca̱lakata̱yachi cha̱tuy lacchixuhuí̱n makslipua ixtatasí ixlhaka̱tcán. ");
INSERT INTO topNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Acxni tá̱cxilhli tatatzokóstalh hasta tatalacátalh ca̱tiyatni la̱ta ixca̱maka̱klhani̱t. Pero amá lacchixcuhuí̱n ca̱huánilh: ―¿Hua̱nchi putzayá̱tit nac ixpu̱muju̱can ni̱n amá tí lama xastacnán? ");
INSERT INTO topNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡Jesús yaj juú tanu̱ma porque lacastacuanani̱t ca̱li̱ni̱n! ¿A poco yaj aksaná̱tit la̱ ixca̱huaniyá̱n nac Galilea ");
INSERT INTO topNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","xlacata Cristo Xatalacsacni Chixcú ixama̱ca macama̱sta̱cán ixmacancán lacli̱xcájnit lacchixcuhuí̱n; xlacán ixama tamakní nac cúlu̱s, pero ixliaktutu chichiní a̱stá̱n xlá ixama lacastacuanán ca̱li̱ní̱n? ");
INSERT INTO topNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jaé lacchaján tá̱ksalh xli̱ca̱na chú ixca̱huanini̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lacapala tatáspitli ní ixtahuila̱na xacha̱ca̱huitu ixapóstoles Jesús y xa̱makapitzi ixdiscípulos, y tali̱chihuí̱nalh la̱ta tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jaé lacchaján tí tata̱chihuí̱nalh apóstoles ixca̱huanicán María Magdalena, Juana, María ixna̱na Jacobo y makapitzi lacchaján li̱huacá. ");
INSERT INTO topNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ixapóstoles Jesús ni̱ para tziná taca̱nájlalh porque ixtapuhuán caj ixtakalhchiya̱nama̱na. ");
INSERT INTO topNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Huata Pedro táxtulh tatza̱lh alh ana ní ixma̱nu̱cani̱t Jesús. Acxni cha̱lh, tápuncsli y tla̱n talacánu̱lh y huata cá̱cxilhli sábanas ni̱ma̱ ixli̱maksuitcani̱t. Xlá taspitpá nac ixchic ixlacpuhuanti̱lhá tú ixqui̱taxtuni̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pi̱huá amá chichiní domingo cha̱tuy ixdiscípulos ixta̱ma̱na pakán nac Emaús, jaé ca̱chiquí̱n ixtamakxtaka como aktuy hora ixli̱lakamákat nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xlacán ixtali̱chihui̱nanti̱lhá la̱ ixmakni̱cani̱t Jesús nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","La̱ta ixtachihui̱nanti̱lhá ni̱ para caso tatláhualh la̱ ca̱ma̱lacatzúhui̱lh cha̱tum chixcú y tzúculh ca̱ta̱tla̱huán. ¡Jesús xastacnán ixca̱tasi̱nini̱t! ");
INSERT INTO topNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero Dios ni̱ ca̱li̱mákxtakli catalakápasli. ");
INSERT INTO topNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús ca̱kalasquínilh: ―¿Tucu huixín li̱chihui̱nampa̱nántit juú nac tijia? ¿Hua̱nchi lakaputzapa̱nántit? ");
INSERT INTO topNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cha̱tum tí ixuanicán Cleofas kálhti̱lh: ―¿A poco amá̱n quila̱huaniyá̱u ni̱ nac Jerusalén tana̱pi y ni̱ catzi̱ya tú hua̱k cristianos tali̱chihui̱nán qui̱taxtuni̱t? ");
INSERT INTO topNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús ca̱huánilh: ―Quila̱huaníu, ¿tucu qui̱taxtuni̱t? Xlacán takálhti̱lh: ―Namá chixcú xalac Nazaret huanicán Jesús xacli̱maca̱ná̱u tali̱pa̱u profeta porque tancs ixli̱chihui̱nán Dios, ixkalhí li̱tlihueke ca̱tlahuá laclanca ixtascújut Dios ni̱ma̱ ixca̱li̱ma̱lacahua̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero xanapuxcun curas y lactali̱pa̱u ma̱paksi̱naní̱n tama̱lacápu̱lh ixlacati̱ncán ma̱paksi̱naní̱n romanos xlacata natamakní y tu̱xamatá viernes akxtokohuacaca nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aquín xacpuhuaná̱u xlacata huá Cristo tí ixama quinca̱lakma̱xtuyá̱n hua̱k tí clama̱náu juú nac Israel. Pero laclako̱lh tú xacacxilhlacacha̱náu porque kalhi̱yá aktuy chichiní la̱ta timakni̱ca. ");
INSERT INTO topNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma̱squi jaé chichiní acxni spalh ixca̱huama makapitzi lacchaján taquí̱lalh ní ixma̱nu̱cani̱t xaní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ixli̱punchú tatáspitli y tzúculh tahuán xlacata ni̱tú ixtanu̱ma xaní̱n Jesús y cha̱tuy ángeles ixca̱ta̱chihui̱nani̱t ixca̱huanini̱t xlacata Jesús ixlama xastacnán. ");
INSERT INTO topNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aquín ni̱ ccatzi̱yá̱u para xli̱ca̱na porque a̱stá̱n na̱ ta̱lh makapitzi quincompañeroscán ana ní ixma̱nu̱cani̱t y xli̱ca̱na yaj tú ixtanu̱ma ixmacni xaní̱n Jesús la̱ quinca̱huanín amá lacchaján, pero ni̱ tá̱cxilhli xastacnán Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesús ca̱huánilh amá ixdiscípulos: ―¡Koxitaní̱n huixín lacchixcuhuí̱n! Ca̱tzanka̱niyá̱n talacapa̱stacni. Ni̱ lá ca̱najlayá̱tit tú tali̱chihui̱nani̱t profetas ixama pa̱xtoka namá chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿A poco ni̱ catzi̱yá̱tit aná huan la̱ Cristo tí ama ca̱lakma̱xtuyá̱n pu̱la ama akxtakajnán xlacata tla̱n namacama̱xqui̱cán lanca ixli̱ma̱paksí̱n? ");
INSERT INTO topNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A̱stá̱n tzúculh ca̱lacspi̱tní ixtachihuí̱n Dios, li̱tzúculh tú huan ixlibro Moisés y li̱ma̱spútulh tú tahuán ixlibrojcán profetas xlacata natama̱kachakxí la̱ ixqui̱taxtuni̱t tú ixtali̱chihui̱nani̱t ama akspulá nac ixlatáma̱t Cristo tí ixama ca̱lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Acxni tácha̱lh nac Emaús Jesús li̱catzi lalh ti̱tum ixama an. ");
INSERT INTO topNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Xlacán tahuánilh: ―Catamákxtakti jaé ca̱chiquí̱n pues smalankaná y amajá tanú ca̱tzisní. Xlá ca̱ta̱tánu̱lh ana ní ixama tatamakxtaka. ");
INSERT INTO topNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ta̱tahui nac mesa xlacata natahualhtatá. Jesús tíyalh mactum simi̱ta, sicuna̱tláhualh, lakchékelh y ca̱má̱xqui̱lh cha̱tunu. ");
INSERT INTO topNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Acxni tuncán staranca talacapa̱stácnalh la̱ caca̱ma̱lakake̱ca natalacahua̱nán ¡y talakápasli Jesús! Pero xlá la̱ caláksputli alh a̱lacatunu y yaj tá̱cxilhli. ");
INSERT INTO topNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tzúculh tara̱huaní: ―¿A poco ni̱ scayaj ixcatzán quinacujcán acxni ixquinca̱ta̱chihui̱namá̱n nac tijia, ixquinca̱lacspi̱tnimá̱n tú ixlaclhca̱ni̱t Dios? ");
INSERT INTO topNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tuncán tata̱yapá nac tijia y ta̱mpá pakán nac Jerusalén. Acxni tácha̱lh tá̱cxilhli cha̱ca̱huitu apóstoles y xa̱makapitzi discípulos. ");
INSERT INTO topNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lacapala ca̱huanica: ―¡Jesús lama xastacnán! ¡Pedro ácxilhli! ");
INSERT INTO topNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Xlacán na̱ tzúculh tali̱chihui̱nán la̱ ca̱takókelh nac tijia cha̱tum chixcú, y la̱ talakápasli Jesús acxni ca̱lakchekénilh simi̱ta. ");
INSERT INTO topNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chu̱tacú ixtachihui̱nama̱na acxni Jesús ta̱yachi nac ixíta̱t ní ixtahuila̱na y ca̱huánilh kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Hua̱k tzúculh ta̱katuyún tajicuanko̱lh, ixtapuhuán ixta̱cxilhma̱na ixespíritu cha̱tum xaní̱n chixcú. ");
INSERT INTO topNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesús ca̱huánilh: ―¿Hua̱nchi jicuaná̱tit y aklhu̱hua̱tnaná̱tit ca̱najlayá̱tit nac minacujcán xlacata aquit clama xastacnán? ");
INSERT INTO topNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ca̱cxílhtit quimacán y quintujún. Caxamátit y ca̱cxílhtit quimacni xlacata naquila̱lakapasá̱u. Aquit ckalhí li̱hua y lúcut, cha̱tum ixespíritu ni̱n ni̱ kalhí li̱hua y lúcut. ");
INSERT INTO topNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ca̱ma̱sí̱nilh ixmacán ixtujún ana ní itxtokocani̱t xlacata nataca̱najlá. ");
INSERT INTO topNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Y como xlacán ixtaca̱cni̱ma̱na, ni̱ ixtaca̱najlaputún tú ixta̱cxilhma̱na la̱ta ixtapa̱xahuama̱na. Jesús ca̱kalasquínilh: ―¿Ni̱ kalhi̱yá̱tit actzu tahuá? ");
INSERT INTO topNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Cha̱tum li̱mínilh actzu xascún tamakní y actzú táxca̱t. ");
INSERT INTO topNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Xlá maklhtí̱nalh y nac ixlacati̱ncán tzúculh hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A̱stá̱n ca̱huánilh: ―Huixín quila̱cxilhma̱náu y ni̱ ma̱kachakxi̱yá̱tit xlacata acxni xacca̱ta̱lapu̱layá̱n cca̱huanín ixmini̱ní nakantaxtú nac quilatáma̱t la̱ta tú li̱chihui̱nani̱t quilacata profeta Moisés y na̱ chuná ixlibrojcán xa̱makapitzi profetas y nac salmos. ");
INSERT INTO topNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Acxni tuncán ca̱lákchilh la̱ aktum taxkáke̱t y tama̱kachákxi̱lh tú ixca̱huanini̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pero todavía ca̱lacspí̱tnilh: ―Chú ixtalaclhca̱ni̱t ixama ma̱kxtakajni̱cán Cristo, ¡ixama̱ca makni̱cán! Pero ixliaktutu chichiní a̱stá̱n ixama lacastacuanán ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na̱ talaclhca̱ni̱t ama ta̱kahuaní quintachihuí̱n. Ama lacatzucú juú nac Jerusalén y lakasu̱t ama taspuyumí ixli̱ti̱lanca ca̱quilhtamacú xlacata hua̱k cristianos natalakxta̱palí ixlatama̱tcán y Dios tla̱n naca̱ma̱tzanke̱naní ixtala̱kalhi̱ncán para quintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Huixín tla̱n ma̱luloká̱tit hua̱k qui̱taxtuni̱t nac quilatáma̱t tú laclhca̱ni̱t Dios quilacata. ");
INSERT INTO topNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chí ni̱ capítit a̱lacatunu juú catamakxtáktit nac Jerusalén; pues aquit cama an nac akapú̱n ní huí Quinti̱cú y cama ca̱ma̱lakacha̱niyá̱n ixli̱tlihueke Espíritu Santo la̱ ma̱lacnu̱ni̱t Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","A̱stá̱n Jesús cá̱li̱lh hua̱k tí ixtali̱pa̱huán lacatzú nac Betania. Acxni tácha̱lh xlá tamacayá̱hualh y ca̱li̱sicuna̱tláhualh ixmacán. ");
INSERT INTO topNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","La̱ta tamacaya̱huani̱t ana tuncán tzúculh ta̱cxtú nac akapú̱n, ¡caj la̱ cakosli ixani̱t nac akapú̱n! ");
INSERT INTO topNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xlacán tapa̱xcatcatzí̱nilh Dios tú ixtlahuani̱t y tatáspitli nac Jerusalén, tapa̱xahuati̱lhá nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","La̱ta amá quilhtamacú cha̱li cha̱lí ixtá̱n talakachixcuhuí y tapa̱xcatcatzi̱ní Dios nac lanca pu̱siculan xla Jerusalén tú ixtlahuá ixlacatacán. Chuná calalh, amén.");
INSERT INTO topNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Dios ni̱ kalhí ixlacatzúcut, y la̱ta ni̱ naj tú ixanán, porque ya̱ ixtatlahuá ca̱quilhtamacú, ixlamajá ixpa̱xtú̱n cha̱tum ixma̱su̱y; xlá na̱ ni̱ kalhí ixquilhtzúcut pues la̱ Dios ixuani̱t y acxtum ixta̱ma̱paksi̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Xlá maktláhualh la̱ta tú anán ca̱quilhtamacú y ni̱ huí ca̱quilhtamacú tú ni̱ catzini̱t la̱ lacatzucuni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jaé ixma̱su̱y Dios ca̱ma̱xqui̱ni̱t ixli̱stacnicán la̱ta tú anán y pi̱huá jaé li̱latáma̱t ma̱pálajli y li̱ma̱lacatzúquilh taxkáket tú natali̱lacahua̱nán cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaé ixma̱su̱y Dios li̱tánu̱lh taxkáket ni̱ma̱ milh ca̱li̱lakaskoyú ixlatama̱tcán tí ca̱paklhtu̱tá ixtalama̱na, y como la̱ ca̱tzisní ca̱ta̱latáma̱lh tatzáksalh tama̱mixí y ni̱ lá tama̱míxilh. ");
INSERT INTO topNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios ma̱lakácha̱lh cha̱tum chixcú huanicán Juan ");
INSERT INTO topNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","xlacata nama̱luloka ticu amá lanca taxkáket. Xlá milh ca̱ma̱tancsaní ixtapuhua̱ncan cristianos xlacata natali̱pa̱huán amá ixma̱suy̱ Dios tí ixli̱mín taxkáket. ");
INSERT INTO topNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ni̱ ixkalhí taxkáket y huata milh mactzupa tí ixli̱mín li̱lacahuá̱n ca̱quilhtamacú xlacata nalakapascán. ");
INSERT INTO topNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huata amá ixma̱suy̱ Dios ixkalhí staranca talacapastacni tú naca̱li̱ma̱lacahua̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Xlá milh ca̱quilhtamacú xlacata nalatamá nac ixca̱quilhtamacú ni̱ma̱ ixtlahuanit, pero tí ca̱lákmilh ni̱ talakápasli. ");
INSERT INTO topNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ni̱ para ixta̱pakánat tamaklhtí̱nalh, amá pu̱latama̱n ni̱ma̱ ixlacsacni̱t napu̱lakahuán. Huata makapitzi tali̱pá̱hualh y tamaklhtínalh nac ixnacujcán. ");
INSERT INTO topNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Y jaé cristianos tí taca̱nájlalh ixtachihuí̱n ca̱li̱má̱nu̱lh ixcamán Dios tí tlan natama̱lacatzuhuí. ");
INSERT INTO topNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Xlacán talakáhualh ixli̱maktuy porque Dios ca̱má̱xqui̱lh sa̱sti ixtalacapa̱stacni y tali̱máca̱lh ixticucán Dios. Jaé tí lakahuán ixli̱maktuy ni̱ quitaxtú la̱ xcam cha̱tum chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Amá ixma̱suy̱ Dios tí ixtalatama̱ni̱t tapálajli y la̱ cha̱tum cristiano lakáhualh ca̱quilhtamacú. Xlá quinca̱ta̱latamá̱n la̱ cati̱hua chixcú y huata ixli̱chihui̱nán ixtalakalhamá̱n Dios y laclanca talacapa̱stacni la̱ quili̱latama̱tcán. Aquín cacxilhni̱táu la̱ Dios má̱xqui̱lh ixli̱tlihueke y ccatziyá̱u xlacata huá Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan li̱chihuí̱nalh ixlacati̱ncán cristianos y chuné ixma̱tla̱ní: ―Huá jaé chixcú xacli̱chihui̱nán acxni cca̱huanín: “Quinke̱sta̱lati̱lhá tunuj chixcú ma̱s tali̱pa̱u ma̱squi xlá siempre quiacli̱ni̱t porque latama̱ni̱t la̱ta ya̱ para xaclakahuán.” ");
INSERT INTO topNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quilacatacán lhu̱hua tú tlahuani̱t y hua̱k pa̱xcatcatzi̱niyá̱u porque xlá ni̱ lakcatzán ma̱stá ixtalakalhamá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés quinca̱maxquí̱n lacli̱cuánit ixtapáksi̱t Dios y scarancua lacasquín cakantáxtulh, pero Jesucristo quinca̱ma̱si̱nín la̱ tancs nalakcha̱ná̱u ixpa̱xtu̱n Dios y como quinca̱pa̱xqui̱yá̱n quinca̱ma̱tzanke̱naniyá̱n quintala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni̱ huí cristiano tí acxilhni̱t Dios pero cha̱stum ixkahuasa ni̱ma̱ táxtulh nac ixpaxtú̱n quinca̱huanín la̱ kalhí ixtalacapa̱stacni pues xlá la̱ Dios y acxtum ta̱huili̱ni̱t ixtalacapa̱stacni ixti̱cú. ");
INSERT INTO topNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Xanapuxcún ma̱paksi̱naní̱n curas xalac Jerusalén tama̱lakácha̱lh makapitzi lactali̱pa̱u lacchixcuhuí̱n xlacata natakalasquiní Juan: ―¿Xli̱ca̱na huix Cristo tí ama quinca̱lakma̱xtuyá̱n? ");
INSERT INTO topNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan ni̱ ta̱takalhtátokli y tancs ca̱kálhti̱lh: ―Aquit ni̱ huá. ");
INSERT INTO topNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xlacán takalasquinipá: ―Pues, ¿ticu huix? O ¿huix profeta Elías? ―¡Tó̱! Aquit ni̱ Elías ―ca̱kálhti̱lh Juan. ―¿Entonces huix amá profeta tí ama lactaxtú nac Israel? ―¡Tó̱! Ni̱ para huá. ");
INSERT INTO topNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","―Catlahua li̱tlá̱n quila̱huaníu ticu huix. Pues tí quinca̱ma̱lakacha̱ni̱tán tacatzi̱putún ticu huix. ¿Tucu cca̱huaniyá̱u milacata? ¡Quila̱huaníu! ―tahuanipá amá lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan ca̱kálhti̱lh: ―Aquit ama tí li̱chihuí̱nalh profeta Isaías: Nac desierto ama takaxmatí la̱ aktasá acxni ma̱kalhchihui̱ni̱nán cha̱tum chixcú: “Catacá̱xtit, tancs calatapá̱tit, ti̱tum catrapí̱tit ixtijia milatama̱tcán, porque mima ca̱lakpaxialhnaná̱n Mimpu̱chinacán.” ");
INSERT INTO topNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","La̱ takaxmatko̱lh ixtachihuín Juan amá tí ixtama̱lakacha̱ni̱t fariseos takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","―Para huix ni̱ Cristo, ni̱ para profeta Elías, ni̱ para amá profeta tí ama lactaxtú nac Israel, ¿hua̱nchi ca̱kmunu̱ya cristianos? ");
INSERT INTO topNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","―Porque aquit huata quili̱ma̱paksi̱ca nacliakmunu̱nán chúchut, pero juú nac mimpu̱latama̱ncán ca̱ta̱lamá̱n cha̱tum tí ni̱ lakapasá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xlá yaj maka̱s ama ma̱lacatzuquí ixtascújut y snu̱n tali̱pa̱u, aquit ni̱ para cma̱ta̱xtuca ixtasa̱cua nacuán tí nackatxcuta nacma̱xtuní ixtatu̱nu ―ca̱kalhti̱ko̱lh Juan. ");
INSERT INTO topNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jaé takalhchihuí̱n qui̱táxtulh nac Betania ixtampaján kalhtuchoko Jordán ana ní Juan ixca̱kmunú cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ixli̱cha̱lí acxni Juan ácxilhli la̱ Jesús tzúculh talacatzuhuí pakán ní ixyá, ca̱huánilh xa̱makapitzi: ―¡Ca̱cxílhtit! Huá namá chixcú ama ma̱ke̱nú tala̱kalhí̱n nac ca̱quilhtamacú pues xlá ama li̱tanú borrego tí ama xoko̱nán ixlacati̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Huá namá tí chuné xacli̱chihui̱nán: “Yaj maka̱s ama ma̱lacatzuquí lanca ixtascújut namá tí quinke̱stalati̱lhá, ma̱squi xlá quiacpu̱lani̱t porque latama̱ni̱t cani̱cxnihuá la̱ta ni̱ para xaclakahuán.” ");
INSERT INTO topNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Aquit na̱ ni̱ xacacxcatzí para huá namá tí ixquinca̱lakmimá̱n, pero quima̱lakacha̱ca nacliakmunu̱nán chúchut xlacata tí talama̱na nac Israel natalakapasa tí ama ca̱lakmaxtú acxni naca̱lakchín. ");
INSERT INTO topNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pero chí aquit tancs cma̱luloka cacxilhni̱t la̱ tá̱ctalh nac akapú̱n Espíritu Santo la̱ tantum paloma y akchipaniko̱lh ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Amá quilhtamacú ni̱ naj xaccatzí para huá namá chixcú tí ixmima quinca̱lakmaxtuyá̱n, pero tí quili̱mapáksi̱lh nacliakmunu̱nán chúchut quihuánilh xlacata tí nacacxila nalakta̱ctá Espíritu Santo y na̱kchipaní ixtalacapa̱stacni huá namá chixcú tí putzama̱náu y ama quinca̱ma̱xqui̱yá̱n ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Aquit tancs cma̱luloka xlacata jaé chixcú Ixkahuasa Dios porque cacxilhni̱t la̱ actánu̱lh Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ixli̱cha̱li li̱tum, Juan pi̱ aná ixca̱ta̱laya cha̱tuy ixdiscípulos, ");
INSERT INTO topNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","y como Jesús aná pasa̱rlapá lacatzú xlá acs lacá̱nilh y ca̱huánilh: ―Huá namá ama li̱tanú la̱ borrego y ama xoko̱nán quilacatacán ixlacati̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Amá lacchixcuhuí̱n la̱ takaxmatko̱lh tú ca̱huánilh Juan, tatakókelh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Pero Jesús acxni cá̱cxilhli tí ixtakokema̱na talakáspitli y ca̱kalasquínilh: ―¿Tucu lacasquiná̱tit? ―Maestro, ¿nicu lápa̱t? ―takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","―Juú lacatzú; para catzi̱putuná̱tit ca̱huí xlacata nalakapasá̱tit ―ca̱kalhti̱ko̱lh Jesús. Xlacán tatá̱alh ní ixlama Jesús y como ma̱x las cuatro ixuani̱ttá aná tatamákxtakli amá catzisní. ");
INSERT INTO topNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jaé lakkahuasán cha̱tum ixuanicán Andrés y xa̱cha̱tum tunuj chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés alh lacaputzá ixta̱cam ixuanicán Simón y acxni táka̱sli huánilh: ―Ctaka̱sni̱táu Cristo tí ama quinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Simón tá̱alh Andrés ana ní ixuí Jesús y acxni ácxilhli Jesús ixtalacatzuhui̱ma acs lacá̱nilh y huánilh: ―Huix huanicana Simón ixkahuasa Jonás, pero aquit cli̱ma̱pa̱cuhui̱yá̱n Pedro (jaé tachihuí̱n huamputún chíhuix). ");
INSERT INTO topNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ixli̱cha̱lí Jesús táxtulh amá pu̱latama̱n y alh nac Galilea. Aná ta̱tánoklhli cha̱tum huanicán Felipe y huánilh: ―Huix caquintakoke ní cama an. ");
INSERT INTO topNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ixlama nac Betsaida y na̱ aná ixtalama̱na Pedro y Andrés. ");
INSERT INTO topNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe antes natakoké alh lacaputzá ixamigo Natanael y huánilh: ―Ctaka̱sni̱táu tí ama quinca̱lakma̱xtuyá̱n, amá tí tali̱chihui̱nán ixlibrojcán Moisés y profetas; huanicán Jesús ixkahuasa José, xlá xalac Nazaret. ");
INSERT INTO topNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael kálhti̱lh: ―Ni̱ para cca̱najlá para nac Nazaret taxtuni̱t cha̱tum tali̱pa̱u chixcú. ―Pues catat acxila xlacata nata̱kskahui̱ya. ");
INSERT INTO topNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","A̱stá̱n ixcha̱tuycán talákalh Jesús y acxni ixtatalacatzuhui̱ma̱na Jesús chihuí̱nalh: ―Nachu min cha̱tum tali̱pa̱u chixcú xalac Israel, xlá xli̱ca̱na ma̱ccha̱ní ixtalacapa̱stacni y ni̱ caj chu̱ta li̱tanú skalala chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","―¿Hua̱nchi quima̱tla̱ni̱ya si ni̱ quilakapasa? ―kálhti̱lh Natanael. Jesús huánilh: ―Aquit cacxilhni acxni ixya̱t ixtampi̱n suja y Felipe ya̱ ixta̱chihui̱naná̱n. ");
INSERT INTO topNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","―¡Maestro! ¡Huix xli̱ca̱na Ixkahuasa Dios, huix pa̱t quila̱ma̱paksi̱yá̱u aquín xalac Israel! ―kalhtí̱nalh Natanael. ");
INSERT INTO topNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","―¿A poco ca̱najla caj xlacata cuanín cacxilhni ixtampi̱n suja? Pues la̱ta chí cuaniyá̱n xlacata pa̱t ca̱cxila ma̱s laclanca quintascújut ni̱ la̱ jaé. ");
INSERT INTO topNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ama cha̱n quilhtamacú pa̱t li̱lacahua̱nana la̱ ama taliquí akapú̱n y aná ama talacta̱ctá ixángeles Dios xlacata naquintalakachixcuhuí aquit Xatalacsacni Chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nac pu̱latama̱n xla Galilea ixuí aktum actzu ca̱chiquí̱n huanicán Caná y aná tlahuaca aktum pu̱tamakaxtokni ixliaktutu chichiní a̱stá̱n. Ixna̱na Jesús na̱ alh, ");
INSERT INTO topNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","y xlá na̱ huanica caca̱tá̱alh ixdiscípulos y acxtum ta̱lh nac pu̱tamakaxtokni. ");
INSERT INTO topNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ixna̱na Jesús acxni ácxilhli ixlako̱ma vino tú ixtali̱kotnán huánilh ixkahuasa: ―Tamakásputli ixvinojcán. ");
INSERT INTO topNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero Jesús kálti̱lh: ―Na̱na, ni̱ lá tú ctlahuá ixlacatacán porque ya̱ acchá̱n quilhtamacú nacma̱tzuquí quintascújut. ");
INSERT INTO topNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ixna̱na ni̱ caso tláhualh y ca̱huánilh amá tí ixtama̱kpitzima̱na vino: ―Huixín catlahuátit la̱ta tú naca̱huaniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aná lacatzú ixtahuila̱na akcha̱xán la̱ tlámanc xla chíhuix ni̱ma̱ ixtamaclacasquín judíos acxni ixtalakachixcuhui̱nán. Katunu jaé tlámanc ixtajú como ochenta o cien litros. ");
INSERT INTO topNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús ca̱huánilh amá tasa̱cua xlacata hua̱k catali̱ma̱tzámalh chúchut, ");
INSERT INTO topNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","y la̱ spalh tahuíli̱lh amá laclanca tlámanc ca̱li̱ma̱páksi̱lh: ―Cakalhtiyátit actzú y capítit ma̱kalhua̱ni̱yá̱tit tí ma̱cpuxqui̱cani̱t jaé fiesta. ");
INSERT INTO topNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Amá tasa̱cua ixtacatzí xlacata xlacán ixtamuju̱ni̱t chúchut, pero acxni kalhuá̱nalh amá chúchut xapuxcu tasa̱cua, ¡ixtalakxta̱pali̱ni̱t y vino ixlani̱t! Como xlá ni̱ ixcatzí ní ixtaxtuni̱t, alh lacaputzá xalí̱i̱t kahuasa y huánilh: ");
INSERT INTO topNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","―Lihua kama jaé vino, huix ni̱ ca̱makslihuekeni̱ta la̱ talá xa̱makapitzi pues cani̱huá nac pu̱tamakaxtokni pu̱la ma̱kpitzicán xatlá̱n vino y acxni tla̱n takalhkasni̱t ma̱sta̱cán ni̱ma̱ yaj xatlá̱n. Pero huix ixmaqui̱ni̱ta jaé ni̱ma̱ ma̱s itxtapalh. ");
INSERT INTO topNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jaé chúchut ni̱ma̱ lakxta̱páli̱lh Jesús nac Caná de Galilea huá xla̱huán ixtascújut ni̱ma̱ tláhualh, ixdiscípulos taca̱nájlalh xlacata xlá Cristo ixuanit tí ixama ca̱lakmaxtú. ");
INSERT INTO topNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Acxni lako̱lh jaé pu̱tamakaxtokni Jesús ca̱tá̱alh ixna̱na ixnata̱camán y na̱ chuná ixdiscípulos nac aktum ca̱chiquí̱n huanicán Capernaum y aná latáma̱lh laktzu quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tzúculh talacatzuhuí ixtacuhui̱nicán judíos ni̱ma̱ ixtama̱kantaxtí ca̱ta cá̱ta, ixtali̱ma̱pa̱cuhuí pa̱scua y Jesús na̱ alh nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Acxni cha̱lh tánu̱lh nac pu̱siculan y nac lacaquilhtin cá̱cxilhli la̱ ixtahuila̱na itsta̱nanin huá̱cax, borregos y palomas tú ixli̱lakachixcuhui̱cán Dios, y tí ixtalakxta̱palí tumi̱n na̱ ixtahuila̱na nac ixmesajcán. ");
INSERT INTO topNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús ni̱ ma̱tlá̱ni̱lh y tláhualh aktum cuarta xla xu̱hua y huá tzúculh ca̱li̱pu̱tlakaxtú hua̱k sta̱naní̱n na̱ chuná ixua̱caxcán, ixborregojcán; y tí ixtalakxta̱palí tumi̱n, ca̱tramakánilh ixtumi̱ncán y ca̱ma̱kpu̱spítnilh ixmesajcán. ");
INSERT INTO topNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tí ixtastá palomas ca̱huánilh: ―Caca̱tamacxtútit jaé palomas. ¡Ni̱ mimpu̱stancán catlahuátit ixchic Quinticú! ");
INSERT INTO topNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ixdiscípulos talacapá̱stacli amá tachihuí̱n ni̱ma̱ ixtatzokni̱t lacatum nac Escrituras: “Ni̱ cma̱tla̱ní la̱ li̱kama̱nancán ixchic Dios.” ");
INSERT INTO topNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Makapitzi xanapuxcún judíos tí tá̱cxilhli tú tláhualh ni̱ tama̱tlá̱ni̱lh y takalasquínilh: ―¿Hua̱nchi ca̱tamacxtu jaé cristianos? Para Dios ma̱xqui̱ni̱tán jaé tapáksit catlahua aktum lanca tascújut xlacata nacca̱najlayá̱u. ");
INSERT INTO topNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","―Para chú lacasquiná̱tit, caquili̱cxilhui: Calactlahuátit jaé ixpu̱siculan Dios, ixliaktutu chichiní aquit ctlahuako̱nit tunuj xasa̱sti. ");
INSERT INTO topNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","―¡Huix chiyani̱ta! Pues cuarenta y seis años li̱tlahuacani̱t jaé pu̱siculan, ¿nicu li̱puhuana huix nali̱tlahuaya caj aktutu chichiní? ");
INSERT INTO topNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amá lacchixcuhuí̱n ni̱ tama̱kachákxi̱lh xlacata Jesús ca̱li̱ta̱chihuí̱nalh ixmacni acxni ca̱huánilh: “Calactlahuátit jaé ixpu̱siculan Dios.” ");
INSERT INTO topNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pero acxni makni̱ca Jesús y lacastacuánalh ca̱li̱ní̱n ixdiscípulos talacapástacli jaé ixtachihuí̱n y taca̱nájlalh xlacata ixqui̱taxtuni̱t tú ixli̱chihui̱nani̱t Dios ixlacata nac Escrituras. ");
INSERT INTO topNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús ca̱tláhualh lhu̱hua laclanca ixtascújut jaé nac xatacuhui̱ní pa̱scua y lhu̱hua cristianos taca̱nájlalh xlacata xlá xli̱ca̱na Dios ixma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero como xlá ixca̱lakapasa cha̱tunu ixtalacpuhua̱ncán, ni̱ hua̱k ixca̱ca̱najlaní tú ixtahuaní. ");
INSERT INTO topNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesús ixcatzí tú ixtalacpuhuá̱n cha̱tunu nac ixnacujcán y ni̱ ixmaclacasquín tí nali̱ma̱kalhchihui̱ní la ixtakalhí ixta̱yatcán. ");
INSERT INTO topNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ixlama cha̱tum fariseo ni̱ma̱ ixca̱ta̱ma̱paksi̱nán xanapuxcun judíos ixuanicán Nicodemo. ");
INSERT INTO topNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Maktum ca̱tzisní xlá alh lakpaxia̱lhnán Jesús y huánilh: ―Maestro, ccatzí xlacata Dios ma̱lakacha̱ni̱tán naquila̱ma̱kalhchihui̱ni̱yá̱u porque ni̱ huí tí tla̱n li̱ma̱lacahua̱ni̱nán laclanca ixtascújut la̱ huix ca̱tlahuaya para ni̱ Dios ma̱xquí ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús ni̱ ma̱chihui̱ni̱ko̱lh y huánilh: ―Nicodemo, xli̱ca̱na cuaniyá̱n amá tí ni̱ lakahuán ixli̱maktuy ni̱ lá ama tanú nac ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","―¿Niculá nalakahuán ixli̱maktuy cha̱tum ko̱lú? ¿Niculá namá qui̱taxtú? ¿A poco cha̱tum chixcú tla̱n tanu̱pará nac ixpu̱lacni ixna̱na xlacata nalakahuán ixli̱maktuy? ―kálhti̱lh Nicodemo. ");
INSERT INTO topNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","―¡Tó̱! Aquit clacasquín cama̱kachakxi xlacata ni̱tú li̱macuán la̱ ma̱lakahuaní̱n mintzé y mas tamaclacasquiní calakxta̱pali̱nín Dios mintalacapa̱stacni y qui̱taxtú la̱ calakáhuanti ixli̱maktuy, pues chuná tla̱n tanu̱ya nac ixtapáksi̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Huix catzi̱ya la̱ cha̱tum chixcú y cha̱tum pusca̱t tama̱xquí ixmacnicán itskatacán y aná qui̱tayá ixtascujutcán. Pero amá tí Dios ma̱xquí ixtalacapa̱stacni, ¡lakahuán ixli̱stacni ixli̱maktuy! ");
INSERT INTO topNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Huix ni̱ cajícuanti para cuaniyán: “Tamaclacasquiní hua̱k natalakahuán ixli̱maktuy.” ");
INSERT INTO topNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Porque jaé qui̱taxtú la̱ acxni u̱nán, huix kaxpata la̱ maca̱csa̱nán pero ni̱ catzi̱ya nicu pakán ama, ni̱ para ní pakán mima, pues na̱ chuná cristiano tí Dios ma̱xquí ixtalacapa̱stacni, ni̱ tasí acxni lakahuán ixli̱maktuy, ¡pero lakahuán! ");
INSERT INTO topNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―Ni̱ cma̱kachakxí la̱ ama qui̱taxtú tú quihuaniya ―kalasquiní̱nalh Nicodemo. ");
INSERT INTO topNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús kálhti̱lh: ―Huix skalala chixcú juú nac Israel, ¿y ni̱ ma̱kachakxi̱ya tú cuanimá̱n? ");
INSERT INTO topNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aquit cli̱ta̱chihui̱namá̱n tú ccatzí y tú cacxilhni̱t la̱ qui̱taxtuni̱t, pero huix ni̱ ca̱najlaya. ");
INSERT INTO topNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Para huix ni̱ ma̱kachakxi̱ya la̱ ixli̱lakxta̱pali̱tcan ixlatama̱tcan cristianos ca̱quilhtamacú, ¿nicu nali̱ma̱kachakxi̱ya para cli̱ta̱chihui̱naná̱n la̱ tu̱tanán nac akapú̱n? ");
INSERT INTO topNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nac akapú̱n ni̱tí catzí la̱ tu̱tanán huata aquit Ixkahuasa Dios ccatzí tú anán porque nac akapú̱n cta̱ctani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","’Huixín catzi̱yá̱tit xlacata nac desierto Moisés akxtokohuácalh ixakspu̱n kantum quihui tantum lu̱hua xla bronce xlacata huak nata̱cxila, y aquit Xatalacsacni Chixcú na̱ chuná ama̱ca quiakxtokohuacacán ");
INSERT INTO topNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","xlacata cati̱huá tí naquili̱pa̱huán nama̱lacatzuquí aktum sa̱sti li̱pa̱xáu latáma̱t ni̱ma̱ ni̱cxni lakó. ");
INSERT INTO topNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Porque Dios snu̱n ca̱lakalhámalh ixcamán y ni̱ para lakcátzalh Ixkahuasa namacamín ca̱quilhtamacú xlacata ni̱tí nalaktzanká, y amá tí nali̱pa̱huán tla̱n nalakma̱xtú ixli̱stacni y nama̱lacatzuquí amá li̱pa̱xáu latáma̱t ni̱ma̱ ma̱lacnú y ni̱cxni lakó. ");
INSERT INTO topNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ma̱lakácha̱lh cha̱stum Ixkahuasa ca̱quilhtamacú xlacata naca̱lakma̱xtú tí ixtalaktzanka̱ni̱t, y ni̱ milh cama̱xoko̱ní ixtala̱kalhi̱ncán cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Amá cristiano tí tancs canajlá tla̱n xapaní ixtala̱kalhín Ixkahuasa Dios yaj ama xoko̱nán; pero amá tí ni̱ ca̱najlá ixtachihuí̱n ixacstu laktzanka̱ni̱t porque ama xoko̱nán tú ni̱ tla̱n tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nac ca̱quilhtamacú milh ca̱ma̱lacahua̱ní lanca taxkáket, pero lhu̱hua cristianos ni̱ tatalacatzúhui̱lh y ta̱lh ní ca̱paklhtu̱tá xlacata ni̱tí nacatzí ni̱ tla̱n ixkasatcán. ");
INSERT INTO topNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Amá tí tlahuá tú ni̱ tla̱n ni̱ tatalacatzuhuí ní taxtuma taxkáket y huata aksputzalá xlacata ni̱ nalakxtalá ixkásat y natasí ixtala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero amá tí tancs lama talacatzuhuí ní taxtuma taxkáket xlacata cati̱huá na̱cxila Dios ma̱xquini̱t ixtalacapa̱stacni acxni tlahuá aktum li̱tlá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","La̱ ta̱chihui̱nankolh Jesús amá chixcú ca̱ta̱táxtulh ixdiscípulos nac Jerusalén y ca̱tá̱alh nac aktum pu̱latama̱n huanicán Judea, y laktzu quilhtamacú aná ca̱kmúnulh cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","La̱ta ya̱ ixma̱nu̱cán Juan Bautista nac pu̱lachin xlá ixca̱kmunú cristianos lacatum taxtunú ní istzamá chúchut huanicán Enón lacatzú nac Salim. ");
INSERT INTO topNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Maktum quilhtamacú ixdiscípulos Juan y cha̱tum tunuj chixcú tzúculh tali̱chihuinán xlacata Jesús ma̱s tla̱n ixakmunu̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xlacán talákalh y tahuánilh: ―Maestro, amá tí ixli̱chihui̱naná̱u y ta̱tánoklhti ixtampajan kalhtu̱choko Jordán chí na̱ tzucuni̱t akmunu̱nán y ma̱s lhu̱hua cristianos talakán. ");
INSERT INTO topNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan ca̱kálhti̱lh: ―Dios la̱ta nac ixpu̱táhui̱lh ca̱ma̱xqui̱ni̱t ixtascujutcán cha̱tunu cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aquit huata cmilh ca̱xtlahuaní ixtijia xlacata hua̱k natalakapasa y natatakoké; pues ni̱ ca̱ktzonksuátit acxni cca̱huanín: “Aquit ni̱ Cristo huata cmini̱t ca̱xtlahuaní ixtijia.” ");
INSERT INTO topNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huixín catzi̱yá̱tit xlacata acxni tamakaxtoka cha̱tum kahuasa huata huá ca̱cnicán y takokecán, pero ixamigo tí pa̱xquí pa̱xahuá ma̱squi xlá lakmakancán. Aquit cca̱huaniyá̱n, aquit namá ixamigo tali̱pa̱u chixcú y clakatí la̱ takokecán. ");
INSERT INTO topNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Xa̱huá huixín ni̱ catzi̱yá̱tit xlacata la̱ta ama tali̱án quilhtamacú xlá ma̱s amaca li̱pa̱huancán y aquit lakasú̱t ama̱ca quiaktzonksuacán. ");
INSERT INTO topNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Amá tí lakahuán ca̱quilhtamacú lakapasa tú anán juú tu̱tzú y huata tla̱n li̱chihui̱nán tú acxilhni̱t ca̱quilhtamacú; pero tí mini̱tanchá ta̱lhmán ca̱ksputza̱lakó ixtalacapa̱stacnicán cristianos y tla̱n li̱chihui̱nán tú anán nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Xlá tancs li̱chihui̱nán tú acxilhni̱t y tú kaxmatni̱t nac akapú̱n, pero lhu̱hua ni̱ taca̱najlá ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Y amá tí taca̱najlá ixtachihuí̱n tama̱luloka xlacata Dios ni̱cxni akskahuinán y tancs ma̱stá ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jaé chixcú ma̱lakacha̱ca ca̱quilhtamacú xlacata tla̱n naquinca̱ma̱cxcatzi̱ni̱yá̱n ixtalacapa̱stacni Dios porque Dios ni̱ lakcatzánilh ma̱xquí ixli̱skalala. ");
INSERT INTO topNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Quinti̱cucán Dios lakalhámalh Ixkahuasa y macamá̱xqui̱lh hua̱k ixli̱tlihueke ixtalacapa̱stacni ni̱ma̱ kalhí. ");
INSERT INTO topNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Cati̱huá tí li̱pa̱huán Ixkahuasa ni̱ma̱ ma̱lakácha̱lh ama lakchá̱n Dios nac akapú̱n, pero tí ni̱ li̱pa̱huán Ixkahuasa ama makasi̱tzí y ni̱ ama lakchá̱n nac ixpaxtú̱n y pi̱huá Dios ama ma̱xoko̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tapasá̱rlalh quilhtamacú y Jesús ixtatakoké ma̱s cristianos porque ixakmunu̱nán ma̱s que Juan, ");
INSERT INTO topNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ma̱squi tí lihua ixta̱kmunu̱nán huá ixdiscípulos. Y como fariseos ixtata̱raslakputún acxni tacátzilh la̱ itstacma ixtascújut, ");
INSERT INTO topNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesús táxtulh amá pu̱latama̱n Judea y alh pakán nac Galilea. ");
INSERT INTO topNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pero tijia ni̱ma̱ chípalh ixti̱taxtú aktum pu̱latama̱n huanicán Samaria. Tí ixtalama̱na jaé pu̱latama̱n ixtasitziní judíos y ni̱ ixtara̱cxilhputún. ");
INSERT INTO topNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Jesús cha̱lh nac aktum actzú ca̱chiquí̱n huanicán Sicar ixli̱tapaksí Samaria. Y como tastúnut ixuanit chichiní lihua ixmactá xlá ixakatzanka̱ni̱t la̱ta ixtla̱huani̱t y huá xlacata lí̱alh nac ixca̱quihuí̱n José ni̱ma̱ maká̱n quilhtamacú ixma̱squihui̱ni̱t ixti̱cú ixuanicán Jacob. Aná ixuí aktum pozo ixli̱tapa̱cuhuí Ixpu̱kotni Jacob; Jesús curucs tahui nac ixquilhpá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ixdiscípulos ta̱lh nac ca̱chiquí̱n xlacata natatama̱huá tú natali̱hua̱yán. Ixli̱puntzú milh puju̱nán nac pozo cha̱tum pusca̱t xalac Samaria. Xlá huánilh: ―¿Ni̱ ixtlahua li̱tlá̱n ixquintá̱kotti actzú minchúchut? ");
INSERT INTO topNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Amá puscat kálhtilh: ―Huixín judíos ni̱ quila̱cxilhputuná̱u tí clama̱náu nac Samaria, ¿hua̱nchi aquit quimaksquina cacta̱kotnán? ");
INSERT INTO topNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","―Huix ni̱ lakapasa tí huanimá̱n ca̱quintá̱kotti chúchut. Porque para ixcatzi tú li̱ma̱lacahua̱ni̱má̱n Dios y tú li̱kalhi̱má̱n, huix cha̱ ixquimáksquinti xacta̱kotni chúchut ni̱ma̱ ni̱cxni li̱kalhticán. ");
INSERT INTO topNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","―Señor, pozo snu̱n pu̱lhmá̱n y ni̱ kalhi̱ya ixli̱ma̱cutucán, ¿nicu pa̱t tiyaya chúchut ni̱ma̱ ni̱cxni li̱kalhticán? ");
INSERT INTO topNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Xa̱huá huix ni̱ ma̱cchipiniya ixli̱lanca quili̱talakapasnicán Jacob tí quinca̱ta̱makxtakni jaé pozo. ¿A poco huí ma̱s tla̱n chúchut que jaé ni̱ma̱ ixca̱ma̱kotí ixcamán ixquitzistancanín? ―huanipá amá puscat. ");
INSERT INTO topNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús huánilh: ―Hua̱k tí tali̱kotnán jaé chúchut ni̱ ixli̱maka̱s tali̱kalhtipará. ");
INSERT INTO topNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero tí li̱kotnán amá chúchut ni̱ma̱ aquit cma̱koti̱nán ya̱cxni catikálhtilh porque ixnacú ama ta̱talacastuca la̱ aktum taxtunú ni̱ma̱ taxtú staranca chúchut y para stalanca huan ixtalacapa̱stacni ama lakchá̱n Dios. ¡Ya̱cxni ama kalhtí! ");
INSERT INTO topNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","―Señor, caquintá̱kotti namá chúchut xlacata ya̱cxni cactikálhtilh y yaj nacmín tiyá chúchut juú nac pozo ―huanipá amá puscat. ");
INSERT INTO topNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","―Pues capit acxila pu̱la minta̱ko̱lú y na̱ cali̱ta juú. ");
INSERT INTO topNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","―Ni̱ ckalhí quinta̱ko̱lú. ―Xli̱ca̱na la̱ huana, ");
INSERT INTO topNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","porque namá chixcú ni̱ma̱ ta̱lamá̱n la̱ ni̱ minta̱ko̱lú pues ni̱ ta̱makaxtoká̱n. Pero huix cakalhi̱ni̱ta cha̱quítzis lacchixcuhuí̱n. ¡Tancs huanti la̱ ni̱ kalhi̱ya minta̱ko̱lú! ");
INSERT INTO topNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","―Xli̱ca̱na huix cha̱tum profeta. ");
INSERT INTO topNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Chí quima̱tancsani tú ccatzi̱putún, xalakmaka̱n quilitalakapasnicán ixtalakachixcuhuí Dios juú nac sipi, pero huixín judíos huaná̱tit xlacata Dios mini̱ní huata nalakachixcuhui̱cán nac lanca pu̱siculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús tancs kálhti̱lh: ―Talacatzuhui̱ma quilhtamacú xlacata tí xli̱ca̱na li̱pa̱huán Dios tla̱n nalakachixcuhuí xani̱ta lacasquín, ni̱ huata juú nac sipi o nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","24","Huá jaé quilhtamacú lakcha̱ni̱t nalacatzucú tunuj tapáksi̱t ca̱quilhtamacú y amá tí xli̱ca̱na li̱pa̱huán Dios cali̱lakachixcúhui̱lh ixli̱hua̱k ixtalacapa̱stacni, pues Quinti̱cucán Dios ca̱putzama cristianos tí natalakachixcuhuí la̱ cuanimá̱n. Cha̱tum cristiano mini̱ní nali̱lakachixcuhuí Dios ixespíritu porque Dios la̱ cha̱tum Espíritu y ni̱ lacatum huí la̱ puhuaná̱tit huixín samaritanos. Huixín ni̱ lakapasá̱tit ixtapuhuá̱n, pero aquín judíos ccatzi̱yá̱u la̱ clakachixcuhui̱yá̱u porque huata Quinti̱cucán Dios ama ca̱lakmaxtú cristianos ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","―Clakatí mintachihuí̱n, pero ccatzí xlacata ama min ca̱quilhtamacú Cristo tí ama quinca̱lakmaxtuyá̱n, y acxni nachín xlá ama quinca̱ma̱tancsaniyá̱n tú ni̱ cma̱kachakxi̱yá̱u. ");
INSERT INTO topNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","―Aquit namá chixcú tí mimá̱n ca̱lakma̱xtuyá̱n ―kalhti̱ko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Chu̱tacú ixchihui̱nama acxni táchilh ixdiscípulos. Xlacán ni̱ tacátzi̱lh hua̱nchi ixta̱chihui̱nani̱t Jesús amá samaritana, pero ni̱ cha̱tum kalasquínilh tú ixlacasquín o tú ixli̱ta̱chihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Amá puscat aná akxtakuíli̱lh ixaksá̱huat y lacapala alh nac ca̱chiquí̱n. Acxni cha̱lh ca̱huánilh cristianos: ");
INSERT INTO topNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Cacxilhnit chatum chixcú tí quihuánilh la̱ xaclatama̱ni̱t xapu̱lh. Aquit cpuhuán huá jaé Cristo tí mimá̱n quinca̱lakma̱xtuyá̱n. ¡Ca̱huí acxilhá̱u! ");
INSERT INTO topNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Amá cristianos tatakókelh amá pusca̱t y ta̱lh pakán ní ixuí Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nac pozo ixdiscípulos Jesús tahuánilh cahuá̱yalh ca̱na actzú, ");
INSERT INTO topNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","pero xlá ca̱kálhti̱lh: ―Tó̱, ni̱ ctzincsa; aquit cli̱hua̱yalhá tú huixín ni̱ lakapasá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","―¿Cha̱ ticu li̱mínilh tú li̱huá̱yalh? ―tara̱kalasquínilh ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Como Jesús ixcatzí ni̱ ixtama̱kachakxi̱ni̱t ixtachihuí̱n, ca̱huánilh: ―Aquit quintahuá huá ixtascújut Quinti̱cú ni̱ma̱ quili̱ma̱páksi̱lh cacma̱kantáxti̱lh, y acxni ctlahuá tú quili̱ma̱páksi̱lh la̱ cackálhkasli ccatzí. ");
INSERT INTO topNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Huixín acxilá̱tit ixtahuácat tachaná̱n y huanátit: “Tzanká akta̱ti papá para nacatlán.” Pero aquit cca̱huaniyá̱n, caca̱li̱lacahua̱nántit cristianos, xlacán tatanu̱putún ixtapáksi̱t Dios cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Huixín a̱huata pa̱t xka̱naná̱tit y ma̱qui̱yá̱tit cosecha, pero pa̱t ca̱xokonicaná̱tit na̱ chuná la̱ tí tachaná̱nalh xlacata acxtum napa̱xahuayá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Xli̱ca̱na pa̱t ma̱kantaxti̱yá̱tit amá tachihuí̱n ni̱ma̱ huan: “Cha̱tum chana̱nán y tunu tí xka̱nán.” ");
INSERT INTO topNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Aquit cca̱ma̱lakachamá̱n nama̱kstoká̱tit amá cosecha ni̱ma̱ tali̱scujni̱t tunu lacchixcuhuí̱n; tunu tí tachaná̱nalh y huixín a̱huata pa̱t ma̱ta̱sputuyá̱tit tú xlacán tama̱tzuqui̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Amá cristianos xalac Samaria ixtakalhputzaputún Jesús porque amá pusca̱t ca̱huánilh xlacata ixquilhcha̱ni̱t la̱ ixlatama̱ni̱t xapu̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Acxni talákchilh tata̱chihuí̱nalh Jesús y tahuánilh caca̱ta̱latáma̱lh laktzú. ");
INSERT INTO topNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Xlá ma̱tlá̱ni̱lh y lhu̱hua tú ca̱li̱ma̱kalhchihuí̱ni̱lh. Xlacán xli̱ca̱na taca̱nájlalh ixtachihuí̱n, pero Jesús huata aktuy chichiní tamákxtakli aná. ");
INSERT INTO topNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A̱stá̱n makapitzi tahuánilh amá pusca̱t: ―Acxni quila̱li̱ma̱kalhchihui̱ní̱u namá chixcú cca̱najláu tziná, pero chí aquín na̱ ckaxmatni̱táu y tla̱n cma̱luloká̱u xlacata huá namá chixcú tí ama quinca̱lakma̱xtuyá̱n ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","45","Jesús ixuán xlacata cha̱tum profeta ni̱cxni lakalhamancán nac ixpu̱latama̱n, pero xlá ni̱ chú qui̱taxtúnilh. Pues la̱ táxtulh nac Samaria alh pakán nac ixpu̱latama̱n Galilea, y como lhu̱hua cristianos ixta̱cxilhni̱t la̱ ixca̱tlahuani̱t laclanca ixtascújut nac pa̱scua xla Jerusalén xlacán tapa̱xáhua̱lh acxni cha̱lh y tla̱n tamaklhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús alh nac Caná amá ca̱chiquí̱n ní ixma̱palajni̱t chúchut y vino ixtlahuani̱t. Aná ixlama cha̱tum tali̱pa̱u chixcú tí ixta̱ma̱paksi̱nán rey, ixkalhí ixkahuasa nac Capernaum y snu̱n ixta̱tatlá. ");
INSERT INTO topNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Acxni cátzi̱lh xlacata Jesús ixmini̱tanchá nac Judea y chi̱lh nac Galilea lacapala alh huaní Jesús catá̱alh nac Capernaum xlacata nama̱ksa̱ní ixkahuasa porque ixni̱majá. ");
INSERT INTO topNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Xlá kálhti̱lh: ―¿A poco xlacata naquila̱li̱pa̱huaná̱u tamaclacasquiní nacca̱tlahuá tzapu laclanca quintascújut? ");
INSERT INTO topNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","―Señor, ni̱tú quihuani. ¡Casokti, porque si no quinkahuasa ama ní! ");
INSERT INTO topNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús tancs huánilh: ―Ni̱tú cali̱púhuanti, capit nac mínchic pues minkahuasa yaj tú kalhí. ");
INSERT INTO topNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Amá chixcú ca̱nájlalh ixtachihuí̱n Jesús y alh nac ixchic, pero la̱ta ya̱ ixchá̱n cha̱tum ixtasa̱cua milh lakapa̱xtoka y huánilh xlacata ixkahuasa ixaksa̱nanit. ");
INSERT INTO topNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Entonces xlá kalasquínilh: ―¿Xnicu tzúculh tatla̱ní quinkahuasa? ―Ko̱tán ma̱x como aktum hora xala akpu̱tú take̱nú̱nilh lhcúya̱t. ");
INSERT INTO topNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","La̱ kaxmatko̱lh tú huánilh ixtasa̱cua amá chixcú áksalh xlacata pi̱huá quilhtamacú acxni Jesús huánilh: “Minkahuasa yaj tú kalhí.” Amá chixcú li̱pá̱hualh Jesús y na̱ chuná hua̱k ixli̱talakapasni. ");
INSERT INTO topNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","La̱ta ti̱táxtulh Jesús nac Judea hasta Galilea huá jaé ixliaktuy lanca ixtascújut ni̱ma̱ tláhualh. ");
INSERT INTO topNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ni̱ ixli̱maka̱s kantaxtupá aktum tacuhui̱ní nac Jerusalén y Jesús na̱ alh. ");
INSERT INTO topNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lacatum ní ixlactanu̱cán ca̱chiquí̱n xla Jerusalén ixuanicán Puerta de las Ovejas, y aná lacatzú ixuí aktum lanca taxtunú ixli̱tapa̱cuhuí nac hebreo tachihuí̱n Betesda, ixli̱ca̱xya̱hucani̱t akquitzis arco la̱ puhui̱lhta ní ixlacatanu̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Aná jaé nac taxtunú ixuancán xlacata ixta̱ctá caj xní cha̱tum ángel ixlakuilhá chúchut, y xla̱huán ta̱tatlá tí ixtajú la̱ ixlakuilhakó ixtake̱nu̱ní xani̱ma̱ta tá̱tat ni̱ma̱ ixkalhí. Huá xlacata ixtali̱huila̱na lacatzú makapitzi lakatzí̱n, tí ni̱ lá ixtatla̱huán y tunuj ta̱tatlanín. ");
INSERT INTO topNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Xlacán ixtakalhi̱ma̱na tí pu̱la natajú; y na̱ aná ixuí cha̱tum tí ni̱ lá ixtla̱huán ixkalhi̱yá treinta y ocho años la̱ta ixta̱tatlá. ");
INSERT INTO topNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús tuncán ma̱kachákxi̱lh la̱ ixakxtakajnani̱t huá li̱kalasquínilh: ―¿Huix na̱ aksa̱namputuna? ");
INSERT INTO topNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Señor, ni̱ lá tí quimaktayá xlacata nactajú acxni natalakuilhá chúchut, pues acxni cli̱tzaksá xa̱makapitzi quintamakatlajá ―kalhtí̱nalh amá chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús li̱ma̱páksi̱lh: ―¡Cata̱ya, casacti mimpilísa̱lh, mixtícat y catlá̱huanti! ");
INSERT INTO topNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Amá chixcú tuncán aksá̱nalh, sacli tú ixlactamá, y akxpakatahuácalh y alh nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Amá chichiní ixli̱huancán tí nascuja huá xlacata acxni ácxilhli cha̱tum tali̱pa̱u xapuxcu cura la̱ ixcuca̱nani̱t, huánilh: ―¿Hua̱nchi cuca̱nani̱ta jaé quilhtamacú acxni quili̱jaxatcán? ¡Ni̱ tla̱n tú tlahuápa̱t! ");
INSERT INTO topNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","―Aquit ni̱ ccatzí, pero amá tí quima̱ksá̱ni̱lh quihuánilh cacsacli tú xaclactamá y cactlá̱hualh. ");
INSERT INTO topNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","―¿Ticu yá chixcú li̱ma̱paksí̱n catlahua namá tascújut jaé quilhtamacú? ―kalasquinipá amá tali̱pa̱u cura. ");
INSERT INTO topNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero xlá ni̱ kalhtí̱nalh porque ni̱ ixaksán tí ma̱ksá̱ni̱lh, pues como snu̱n istzamacán Jesús talakátze̱kli. ");
INSERT INTO topNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Y hasta astán ta̱tánoklhli nac pu̱siculan y huánilh: ―Chí aksa̱nani̱ta, yaj catlahua tala̱kalhín xlacata ni̱ napa̱xtoka tú mas li̱xcájnit. ");
INSERT INTO topNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","La̱ ta̱chihui̱nanko̱lh Jesús amá chixcú alh ca̱huaní xanapuxcun curas tí ixma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Xlacán tasí̱tzi̱lh y tzúculh talacputzá la̱ natama̱lacapú Jesús porque xlá siempre ixca̱tlahuá ixtascújut acxni ixli̱huancán. ");
INSERT INTO topNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Y para ixtakalasquiní tú xlacata chú ixli̱lá xlá ixca̱kalhtí: ―Quinticú Dios ni̱ aktum quilhtamacú jaxa siempre scuja, y aquit huata cmakslihueké. ");
INSERT INTO topNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Amá xanapuxcun judíos ni̱ ixtama̱tla̱ní tú ixkalhti̱nán Jesús, itscuja acxni ixli̱huancán, y ma̱s ni̱ ixtama̱tla̱ní porque ixli̱tanú Ixkahuasa Dios. Xlacán ixtama̱laksputuputún Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús na̱ ca̱huánilh amá xanapuxcun curas: ―Aquit Ixkahuasa Dios y huata cmakslihueké tú cacxila tlahuá Quinticú. Ni̱ capuhuántit qui̱cstu claclhca̱ni̱t tú cca̱li̱ma̱lacahua̱ni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Quinticú quimpa̱xquí y quima̱si̱nini̱t la̱ta tú catzí y todavía amajcú quima̱xquí ma̱s ixli̱tlihueke xlacata nacca̱li̱ma̱lacahua̱ni̱yá̱n quintascújut ni̱ la̱ jaé, y huixín hasta ni̱ pa̱t ca̱najlaputuná̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aquit na̱ tlan cca̱ma̱xquí tí clacasquín ixlatamatcán amá cristianos na̱ chuná la̱ Quinti̱cú ca̱ma̱lacastacuaní tí lacasquín. ");
INSERT INTO topNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Quinti̱cú quima̱xqui̱ni̱t ixli̱ma̱paksí̱n aquit nacca̱ta̱tlahuá taxokó̱n hua̱k cristianos tí tatlahuani̱t tala̱kalhí̱n ");
INSERT INTO topNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","xlacata acxtum naquinca̱lakachixcuhui̱caná̱n. Y ama tí huan li̱pa̱huán Quinti̱cú y aquit ni̱ quili̱pahuán, ¡akskahuinán! Pues tancs cca̱huaniyán, tí xli̱ca̱na li̱pa̱huán Quinti̱cú Dios ni̱ ta̱klhuhuí na̱ quili̱pa̱huán aquit. ");
INSERT INTO topNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Aquit cca̱ma̱lacnu̱niyá̱n amá tí quili̱pa̱huán y ca̱najlá xli̱ca̱na̱ Dios quima̱lakacha̱ni̱t, namá cristiano ama lakchá̱n ixpa̱xtú̱n Dios y yaj ama̱ca ma̱xoko̱ni̱cán ixtala̱kalhí̱n porque aquit cama lacati̱ta̱yá nalakma̱xtú ixlistacni. ");
INSERT INTO topNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na̱ cca̱huaniyá̱n, accha̱ni̱t hora y huá jaé quilhtamacú ama tapu̱taxtuní cristianos tí talaktzanka̱ni̱t para xli̱ca̱na tatlahuá tú cli̱ma̱paksi̱nán y taca̱najlá aquit Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Quinti̱cú kalhí li̱tlihueke ma̱lacatzúqui̱lh la̱ta tú anán, y aquit Ixkahuasa na̱ ckalhí li̱tlihueke nactlahuá tú clacasquín. ");
INSERT INTO topNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aquit Xatalacsacni Chixcú y ckalhí ixli̱ma̱paksí̱n nacca̱ma̱xoko̱ní ixtala̱kalhi̱ncán cristianos xala ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","’Ni̱ caca̱maka̱klhán quintachihuí̱n porque ama cha̱n quilhtamacú acxni hua̱k tí tani̱ni̱t ama tatacuta nac ixpu̱taju̱ncán acxni natakaxmata la̱ nacca̱li̱ma̱tasí quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Hua̱k ama talacastacuanán, y tí lactlá̱n cristianos ixtahuani̱t ama tapa̱xahuá pues cama ca̱ma̱xquí lactlá̱n ixpu̱tahui̱lhcán, pero tí lacsnú̱n ixtalanit ama talakaputzá pues cama ca̱macá̱n nac ixpu̱latama̱ncán ní nataxoko̱nán tú tatlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Cha̱tunu cristianos stalhca cama ma̱xquí ixtaxokó̱n la̱ quili̱ma̱paksi̱ni̱t Dios pues aquit ni̱ qui̱cstu cta̱clhcá nacma̱xoko̱ni̱nán, huá Dios tí quima̱lakacha̱ni̱t quihuaní la̱ naclá. ");
INSERT INTO topNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jesús ni̱ juú qui̱yá̱hualh ixtachihuí̱n y ca̱huanipá: ―Para qui̱cstu xactatlá̱ni̱lh cmilacati̱ncán, tú xacca̱huanín ni̱tú li̱macuán, tla̱n ni̱ ixca̱najlátit. ");
INSERT INTO topNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero huixín lakapasá̱tit Juan Bautista y xlá hua̱k li̱chihui̱nani̱t tú acxilhpa̱nántit. ");
INSERT INTO topNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Huixín ta̱chihui̱nántit y ca̱li̱ta̱chihui̱nán quilacata y la̱ta tú ca̱huanín ni̱ aktzánka̱lh hua̱k qui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Aquit cca̱ma̱lacapa̱stacayá̱n Juan Bautista xlacata yaj na̱ktzanka̱yá̱tit y nataxtuniyá̱tit para quila̱li̱pa̱huaná̱u, pero aquit ni̱ ixlacata xackalhi̱ma naquima̱tla̱ní nac milacati̱ncán, pues ni̱ cha̱tum chixcú quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ixtachihui̱n Juan ca̱li̱lakaskoyún la̱ aktum lámpara xlacata nalacahua̱naná̱tit, huixín caj laktzú li̱pa̱xahuá̱tit y ma̱tla̱ní̱tit ixtaxkáket. ");
INSERT INTO topNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan stalanca ca̱li̱ta̱chihui̱nán quilacata, pero chí huixín acxilhpa̱nántit quintascújut ni̱ma̱ quima̱tlahui̱ni̱t Quinti̱cú tí quima̱lakácha̱lh, y hua̱k quintascújut ni̱ma̱ cca̱li̱ma̱lacahua̱ni̱yán tama̱luloka xlacata Dios quimacamini̱t. ");
INSERT INTO topNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Huixín ni̱cxni acxilhni̱tántit ca̱lacán Quinti̱cú Dios ni̱ para kaxpatni̱tántit ixtachihuí̱n, pero xlá ma̱luloknín nac Escrituras xlacata huá quima̱lakacha̱ni̱t; ");
INSERT INTO topNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma̱squi huixín ni̱ kaxpatá̱tit ixtachihuí̱n porque ni̱ ta̱ktzuhui̱yá̱tit quila̱li̱pa̱huaná̱u ni̱ ca̱najlayá̱tit xlacata xlá quima̱lakácha̱lh nacca̱ma̱si̱niyá̱n ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","’Huixín li̱kalhtahuakayá̱tit ixtalacapa̱stacni Dios ni̱ma̱ tzokcani̱t nac Escrituras porque puhuaná̱tit chuná tla̱n nalakma̱xtuyá̱tit mili̱stacnicán, y ni̱ ma̱kachakxi̱yá̱tit la̱ Dios quili̱chihui̱nán xlacata aquit amá tí ama ca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Y ni̱ ca̱najlayá̱tit quintachihuí̱n ni̱ puhuaná̱tit xlacata tla̱n nacca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Aquit cca̱lakapasá̱n y ccatzí xlacata ni̱ li̱pa̱huaná̱tit Dios xli̱hua̱k minacujcán huá xlacata ni̱ caso ctlahuá para quila̱li̱pa̱huaná̱u o ni̱ quila̱li̱pa̱huaná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aquit cmini̱tanchá ixpa̱xtu̱n Quinticú Dios, pero huixín tatlanca̱ni̱yá̱tit y ni̱ quila̱li̱pa̱huaná̱u. Aquit ccatzí para ixca̱lakmín cha̱tum skalala chixcú ixca̱li̱lactlancanín ixtachihuí̱n, huixín ixli̱pa̱huántit. ");
INSERT INTO topNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Hua̱nchi ca̱najlayá̱tit ixtachihui̱n cati̱hua chixcú? ¿Hua̱nchi ni̱ quila̱ma̱lacatzuhui̱yá̱u aquit xlacata nacca̱ma̱si̱niyá̱n ixtalacapa̱stacni Dios? ");
INSERT INTO topNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Aquit ni̱ camá̱n ca̱ma̱lacapu̱yá̱n ixlacati̱n Dios la̱ kalhi̱yá̱tit minkasatcán, pero huí tú tzokni̱t Moisés huixín li̱kalhtahuakayá̱tit pues puhuaná̱tit chuná tancs nachipiná̱tit nac akapú̱n; y chí cca̱huaniyá̱n, xlá ama ca̱ma̱lacapu̱yá̱n, ¡pues ni̱ ca̱najlayá̱tit tú li̱chihui̱nán! ");
INSERT INTO topNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nac ixlibros tancs tzokni̱t tachihuí̱n quilacata y huixín huaná̱tit ca̱najlayá̱tit ixtachihuí̱n, pero chí cca̱lakchini̱tán y ni̱ ca̱najlayá̱tit quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aquit cpuhuán xlacata ni̱ ca̱najlayá̱tit tú tzokni̱t huá xlacata ni̱ quila̱li̱pa̱huaná̱u aquit tí mini̱t ca̱ma̱kalhchihui̱ni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","A̱stá̱n Jesús ca̱tá̱alh ixdiscípulos ixa̱quilhtu̱tu chúchut xla Galilea o de Tiberias la̱ ixtama̱pa̱cuhuí makapitzi. ");
INSERT INTO topNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","La̱ta ní ixán lhu̱hua cristianos ixtatakoké pues ixtalakatí ta̱cxila la̱ ixca̱ma̱ksa̱ní ta̱tatlaní̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Ixtalacatzuhui̱ma ixtacuhui̱nican judíos xla pa̱scua acxni Jesús ca̱ta̱talacá̱cxtulh ixdiscípulos nac aktum sipi y aná curucs tatahuilako̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pero acxni talacayá̱hualh cá̱cxilhli pu̱tum cristianos ixtamima̱na pakán ní ixuí. Entonces huánilh Felipe: ―¿Tucu ixli̱tama̱huáu tahuá xlacata natahua̱yán hua̱k jaé cristianos? ");
INSERT INTO topNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús caj chu̱ta ixkalhputzama porque xlá ixcatzí tú ixama ca̱li̱ma̱lacahua̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pero como Felipe ni̱ ma̱kachákxi̱lh kálhti̱lh: ―Ma̱squi ixtama̱huáu aktuy ciento denario tumi̱n ixlacata simi̱ta ni̱ ixáccha̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ixta̱cam Pedro tí ixuanicán Andrés kalhpaktánu̱lh: ");
INSERT INTO topNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Maestro, nanú lapu̱lá cha̱tum actzu kahuasa li̱mín macquitzis simi̱ta y tantuy tamakní, pero ni̱ acchá̱n ni̱ para ixca̱li̱quilhtlahuaca, pues lhu̱hua cristianos tahuila̱na. ");
INSERT INTO topNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","―Ni̱tú cali̱puhuántit. Caca̱huanítit curucs catatahuilako̱lh hua̱k cristianos ―ca̱li̱ma̱páksi̱lh Jesús ixdiscípulos. Hua̱k cristianos tatahuilako̱lh nac ca̱tiyatni pues ixuí lhu̱hua li̱cúxtut, y huata lacchixcuhuí̱n como cha̱quitzis mi̱lh ixtahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús maklhtí̱nalh amá simi̱ta, pa̱xcatcatzí̱nilh Dios y ca̱má̱xqui̱lh ixdiscípulos xlacata catama̱kpítzilh y catamá̱xqui̱lh la̱ta tí ixlacasquín; y amá tamakní na̱ chuná ma̱kpítzilh. ");
INSERT INTO topNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hua̱k cristianos tla̱n tahuá̱yalh y la̱ talako̱lh Jesús ca̱li̱ma̱páksi̱lh ixdiscípulos catamá̱kstokli hua̱k tahuá ni̱ma̱ kalhtá̱xtulh xlacata ni̱tú nalaktzanká. ");
INSERT INTO topNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xlacán tzúculh tama̱kstoka y tama̱tzámalh akcu̱tuy cana̱sta simi̱ta y tamakní ni̱ma̱ tama̱kalhtá̱xti̱lh amá tí tahuá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amá cristianos ni̱ tama̱kachákxi̱lh la̱ ixtlahuani̱t Jesús, pero ixta̱cxilhni̱t la̱ ixma̱lhu̱hui̱ni̱t simi̱ta y huá tzúculh tali̱chihui̱nán: ―Jaé chixcú huá amá profeta tí ma̱lacnu̱cani̱t ama quinca̱lakminá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Xlacán tze̱k taláclhca̱lh ixama tali̱ma̱pa̱cuhuí Jesús rey xala amá pu̱latama̱n, pero como Jesús acxcátzi̱lh talacá̱cxtulh ixakstí̱n amá sipi xlacata ni̱tí nata̱ra̱slaka. ");
INSERT INTO topNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Ixdiscípulos Jesús tatalacá̱ctalh amá sipi y takálhi̱lh nac ixquilhtu̱n chúchut. Pero como tzuculhá tapaklhtu̱tá y xlá ya̱ ixtaspita tatáju̱lh nac barco ni̱ma̱ ixtapu̱tla̱huán y ta̱lh pakán nac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pero ixli̱punchú také̱talh aktum akxtulú̱n y chúchut li̱cuánit ixta̱kstampu̱ya̱huá huá xlacata lakasu̱t ixtali̱ama̱na. ");
INSERT INTO topNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ixtatla̱huani̱ttá como akquitzis o akcha̱xán kilómetro acxni tá̱cxilhli cha̱tum chixcú ixtla̱huama ixkalhni chúchut ixmima pakán ixbarcojcán. Xlacán ni̱ talakápasli y tajicuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jaé chixcú Jesús ixuani̱t y ca̱ma̱ktási̱lh: ―Ni̱ cajicuántit, aquit Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Acxnicú xlacán talakápasli y tata̱tájulh nac barco, y a̱stá̱n ni̱ para tuhua tácha̱lh nac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Amá cristianos tí ixca̱ma̱hui̱ni̱t Jesús ixli̱chalí ta̱lh talacaputzá ana ní ixca̱ta̱hua̱yani̱t pues ixtacatzí xlacata lakxtum ixca̱ta̱cha̱ni̱t ixdiscípulos, pero amá smalankán xlacán tatájulh nac barco y Jesús ni̱tú ixán. ");
INSERT INTO topNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","24","Xlacán tla̱n talacapútzalh Jesús na̱ chuná ixdiscípulos, y como ni̱ tatáka̱sli tatáju̱lh nac barco ni̱ma̱ ixtamini̱t xalac Tiberias y ta̱lh talacaputzá Jesús nac Capernaum. ");
INSERT INTO topNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Acxni tácha̱lh aná tá̱cxilhli Jesús; entonces takalasquínilh: ―Maestro, ¿niculá tlahua xlacata nachitana juú? ");
INSERT INTO topNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús ca̱kálhti̱lh: ―Huixín quila̱lacaputzayá̱u ni̱ xlacata quila̱li̱pa̱huaná̱u, quila̱lacaputzayá̱u porque ko̱tán cca̱ma̱kalhkasán. ");
INSERT INTO topNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","¡Ni̱ cali̱tatlakátit mintahuajcán ni̱ma̱ li̱kalhkasá̱tit caj punchú! ¡Ma̱s ca̱li̱tatlakátit mintahuajcán ni̱ma̱ nali̱latapa̱yá̱tit cani̱cxnihuá cxpaxtu̱n Dios! Y namá tahuá huata aquit Xatalacsacni Chixcú tla̱n cca̱ma̱xqui̱yá̱n porque Dios Quinti̱cú quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","―¿Tucu quili̱tlahuatcán xlacata nacma̱kantaxti̱yá̱u tú lacasquín Dios quilacatacán? ―takalasquínilh xlacán. ");
INSERT INTO topNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y Jesús ca̱kálhti̱lh: ―Dios lacasquín caca̱najlátit ixtachihuí̱n amá tí ma̱lakacha̱ni̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xlacán tahuánilh: ―Para xli̱ca̱na huix amá tí ma̱lacnu̱ni̱t Quinticucán Dios ama quinca̱lakma̱xtuyá̱n, catlahua aktum lanca mintascújut xlacata nacca̱li̱pa̱huaná̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xa̱huá para li̱tanu̱ya Cristo camakatlaja Moisés pues nac desierto xlá ca̱má̱hui̱lh cha̱li cha̱lí quinati̱cún tí quinca̱ma̱lacatzuqui̱ni̱tán. Nac Escrituras huan xlacata Dios ca̱má̱hui̱lh “maná”, jaé tahuá xalac akapún. ");
INSERT INTO topNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","―Aquit tancs cca̱huaniyá̱n, Moisés ni̱ ca̱má̱xqui̱lh tahuá xalac akapú̱n pues huata Quinti̱cú Dios tla̱n ma̱lakachá tahuá ni̱ma̱ li̱pa̱xá̱u li̱latama̱cán cani̱cxnihuá. ");
INSERT INTO topNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Xlá quima̱lakácha̱lh ca̱quilhtamacú xlacata nacca̱ma̱hui̱yá̱n tahuá ni̱ma̱ nali̱ma̱kalhkasayá̱tit mili̱stacnicán cani̱cxnihuá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","―Señor, quila̱ma̱xquí̱u namá tahuá ni̱ma̱ huix ma̱lacnu̱ya ―tahuánilh amá lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y Jesús ca̱kálhti̱lh: ―Aquit namá tahuá tí tla̱n nali̱kalhkasá̱tit xlacata li̱pa̱xáu nalatapa̱yá̱tit nac akapú̱n. Amá tí quilakmín y quili̱hua̱yán ya̱cxni ama tzincsa ixli̱stacni y tí quintali̱pa̱huán ya̱cxni ama takalhtí. ");
INSERT INTO topNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aquit lhu̱hua tú cca̱li̱ma̱lacahua̱ni̱ni̱tán pero snu̱n clakaputzá porque huixín ni̱ quila̱li̱pa̱huaná̱u la̱ cca̱huanini̱tán ni̱ caj maktum. ");
INSERT INTO topNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pero ni̱ hua̱k talaktzanka̱ni̱t, pues amá cristianos tí Dios ca̱ma̱xquí ixtalacapa̱stacni naquintalakmín, aquit li̱pa̱xáu cca̱makamaklhti̱nán acxni quintalakchín. ");
INSERT INTO topNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","’Dios quima̱lakacha̱ni̱t xlacata nacma̱kantaxtí tú xlá lacasquín nacatzi̱yá̱tit y ni̱ qui̱cstu cta̱clhca̱ni̱t nacca̱lakminá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aquit tancs cca̱huaniyá̱n, Dios lacasquín ni̱ cha̱tum cristiano calaktzánka̱lh tí xlá quimacama̱xqui̱ni̱t naccuentajní, cha̱ lacasquín hua̱k li̱pa̱xáu catalatáma̱lh nac akapú̱n para aquit cca̱ma̱xquí quintalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Dios lacasquín amá cristiano tí quinkaxmata y quili̱pa̱huán aquit Ixkahuasa, tla̱n cma̱xquí quintalacapa̱stacni xlacata a̱stá̱n natalacastacuanán cquimpa̱xtú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Makapitzi xanapuxcun judíos la takaxmatko̱lh ixtachihuí̱n Jesús ni̱ tama̱tlá̱ni̱lh porque xlá ixuani̱t: “Aquit amá tahuá tí nali̱kalhkasá̱tit y nac akapú̱n cmini̱tanchá.” ");
INSERT INTO topNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xlacán tzúculh tahuán: ―¿Ni̱ huá jaé chixcú ixkahuasa José carpintero? Hua̱k ca̱lakapasá̱u ixti̱cú ixna̱na; entonces, ¿hua̱nchi huan xlacata nac akapú̱n mini̱tanchá? ");
INSERT INTO topNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesús ca̱huánilh: ―Yaj cali̱chihui̱nántit la̱ aquit cli̱mini̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","45","Huixín ni̱ catzi̱yá̱tit xlacata huata quintalakmín amá cristianos tí Dios ca̱ma̱xquí ixtalacapa̱stacni la̱ tatzokni̱t lacatum nac Escrituras: “Quimpu̱chinacán ama ma̱sí ixtalacapa̱stacni.” Jaé cristianos tí takaxmata ixtachihuí̱n tatlahuá ixtapáksi̱t y xlacán quintalakmín xlacata nacca̱ma̱lacastacuaní acxni nalakó ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xlacán ni̱ ta̱cxilhnit Dios, pero tacatzí ixtalacpuhuá̱n porque aquit cca̱ma̱si̱nini̱t pues aquit ctaxtuni̱t ixpa̱xtu̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Caca̱najlátit tú cca̱huaniyá̱n, amá tí quili̱pa̱huán namá cristiano kalhi̱yá ixlakapú̱xoko ixtala̱kalhí̱n pues tancs ama lakchá̱n ixpa̱xtu̱n Dios nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Porque aquit namá simi̱ta ni̱ma̱ cta̱ctani̱t nac akapú̱n xlacata tla̱n natali̱laktaxtú tí quintali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Amá tahuá ni̱ma̱ ca̱má̱hui̱lh Moisés nac desierto hua̱k mili̱talakapasnicán ni̱tú ta̱yánilh porque hua̱k táni̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero chí xli̱ca̱na ca̱lakchini̱tán tahuá xalac akapú̱n ni̱ma̱ ama ma̱ta̱yaní mili̱stacnicán xlacata ni̱ nalaktzanka̱yá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Amá tí quili̱kalhkasa ya̱cxni ama ní porque aquit namá tahuá ni̱ma̱ milh nac akapú̱n y amá tí quili̱hua̱yán li̱pa̱xáu ama latamá nac akapú̱n. Jaé tahuá ni̱ma̱ cca̱ma̱lacnu̱niyá̱n huá quimacni ni̱ma̱ cama ma̱stá milakapu̱xokocán nama̱laksputucán xlacata cristianos tla̱n natalakma̱xtú ixli̱stacnicán nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Amá xanapuxcun judíos la̱ takaxmatko̱lh ixtachihui̱n Jesús, tzúculh tara̱huaní: ―Jaé chixcú chiyani̱t. ¿Niculá naquinca̱ma̱hui̱yá̱n ixmacni? ");
INSERT INTO topNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","―Xli̱ca̱na cca̱huaniyá̱n, amá tí ni̱ li̱kalhkasa quimacni, ni̱ para li̱kotnán quinkalhni, ni̱ ama lakchá̱n nac akapú̱n ixpu̱táhui̱lh nac ixpaxtu̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pues huata cama ca̱ma̱xquí ixpu̱táhui̱lhcán y cca̱ma̱lacastacuaní amá cristianos tí tali̱ma̱nú quimacni la̱ ixtahuá y quinkalhni tali̱ma̱nú ixchuchutcán ni̱ma̱ tali̱kotnán nac ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ixli̱hua̱k quinacú cca̱huaniyá̱n, huata quimacni y quinkalhni ama ca̱lacati̱ta̱yayá̱n xlacata tancs nachipiná̱tit ixpaxtu̱n Dios nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Amá cristiano tí li̱hua̱yán quimacni y li̱kotnán quinkalhni ma̱lakxtumí ixtalacapa̱stacni con quintalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quinti̱cú quima̱lakácha̱lh y xlá quimá̱xqui̱lh hua̱k ixtalacapa̱stacni xlacata nactlahuá tú xlá lacasquín, y amá tí quili̱hua̱yán na̱ chuná cma̱xquí quintalacapa̱stacni xlacata ni̱ nalaktzanká ");
INSERT INTO topNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","la̱ táni̱lh mili̱talakapasnicán acxni tali̱huá̱yalh maná. ¡Aquit namá tahuá tí ma̱lacnú tancs latáma̱t porque nac akapú̱n cmini̱tanchá! Amá tí quili̱kalhkasa cma̱xquí sa̱sti ixlatáma̱t xlacata ni̱cxni nalaksputa. ");
INSERT INTO topNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ca̱huánilh cristianos jaé takalhchihuí̱n acxni ixtanu̱ma nac sinagoga xla Capernaum. ");
INSERT INTO topNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","La̱ takaxmatko̱lh ixtachihuí̱n Jesús, amá cristianos tí ixtatakoké la̱ta ní ixán, tzúculh tahuán: ―Ni̱ para li̱ca̱najlaputu tú li̱chihui̱nán jaé chixcú. ¿Cha̱ ticu lihua ama li̱pa̱huán ixtachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús ma̱kachákxi̱lh tú ixtali̱chihui̱nama̱na amá cristianos y ca̱huánilh: ―Huixín ni̱ ca̱najlaputuná̱tit la̱ta tú cca̱huanín. ");
INSERT INTO topNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Pues, ¿tucu ixqui̱táxtulh para ixquila̱cxilhui cta̱cxtuma nac akapú̱n ana ní cmini̱tanchá? ");
INSERT INTO topNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na̱ mili̱catzi̱tcán xlacata ixmacni cha̱tum cristiano ni̱tú li̱macuán porque laksputa, y tú ma̱s ixli̱maktakálhat huá ixespíritu ni̱ma̱ ni̱cxni ama ní. ");
INSERT INTO topNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Hua̱k quintachihuí̱n ni̱ma̱ cca̱huaniyá̱n huata miespiritucán tla̱n maclacasquín xlacata ni̱ nalaktzanká, porque quintachihuí̱n ma̱lacnu̱ní miespiritucán tla̱n latáma̱t ma̱squi lhu̱hua ni̱ taca̱najlá tú cli̱chihui̱nán. Jesús ixca̱lakapasa tí ixtali̱pa̱huán y tí ni̱ ixtali̱pa̱huán na̱ chuná tí ixama liakskahuinán. ");
INSERT INTO topNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","A̱stá̱n ca̱huaniko̱lh: ―Chí cca̱ma̱lacapastacaparayá̱n, huata quintalakmín amá cristianos tí Dios ca̱ma̱xquí ixtalacpuhuá̱n naquintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","La̱ta amá quilhtamacú lhu̱hua tí ixtatakoké Jesús tzúculh ta̱kxtakmakán y yaj ní ixtatakoké. ");
INSERT INTO topNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Huá xlacata ca̱li̱kalasquínilh cha̱cu̱tuy ixdiscípulos: ―¿Huixín la̱tiyá amá̱n quila̱takokeyá̱u, o na̱ amá̱n quila̱kxtakmakaná̱u? ");
INSERT INTO topNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro kálhti̱lh: ―Maestro, huix Quimpu̱chinacán, ni̱tí ma̱stá stalanca talacapa̱stacni la̱ huix; huata mintachihuí̱n ma̱lacnú li̱pa̱xáu latáma̱t nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Y aquín cca̱li̱pa̱huaná̱n porque ccatzi̱yá̱u xlacata huix Cristo Ixkahuasa Dios xastacnán. ");
INSERT INTO topNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","―Aquit cca̱lacsacni̱tán mincha̱cu̱tuycán, pero cha̱tum la̱ta mili̱hua̱kcán makatlajani̱t tlajaná ―ca̱huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús itlhcuyuya̱huama Judas Iscariote ixkahuasa Simón amá ixdiscípulo tí ixama macamastá a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","A̱stá̱n Jesús alh ca̱ma̱kalhchihui̱ní cristianos tí ixtalama̱na nac lactzu ca̱lacchiquí̱n amá pu̱latama̱n xla Galilea. Xlá ni̱ ampútulh nac Judea porque aná xanapuxcun judíos ixtamakni̱putún. ");
INSERT INTO topNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jaé quilhtamacú ixtalacatzuhui̱ma nakantaxtú tunu ixtacuhui̱nican judíos ixtali̱ma̱pa̱cuhuí “fiesta de tabernáculos”. ");
INSERT INTO topNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","5","Ixtalakapasni Jesús na̱ ni̱ ixtacatzí ticu yá chixcú ixuani̱t y como ni̱ ixtali̱pa̱huán xlacán tahuánilh: ―Ni̱ catamákxtakti juú, capit nac Judea ana ní tzamacán xlacata tí tali̱pa̱huaná̱n aná nata̱cxila la̱ ca̱tlahuaya laclanca mintascújut. Huix kalhi̱ya li̱tlihueke y tlahuaya tú lacasquina, ¿hua̱nchi ni̱ li̱lactlancana mintascújut ixlacati̱ncan cristianos? Pues tí lacasquín nali̱pa̱huancán ni̱ tzek scuja siempre an ana ní tzamacán. ");
INSERT INTO topNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","―Para milacatacán ixuá cani̱cxnihuá tla̱n lactlancaná̱tit, pero aquit ya̱ clakchá̱n quilhtamacú nacma̱si̱kó quili̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xa̱huá huixín ni̱tí ca̱si̱tzi̱niyá̱n, pero aquit lhu̱hua ni̱ quinta̱cxilhputún porque aquit ni̱ cca̱li̱quilhpuhuán cca̱ma̱laksi̱ní ixtala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Capítit huixín nac fiesta, aquit ni̱ lá can porque ya̱ acchán quinquilhtamacú nacma̱kantaxtí tú clakmini̱t. ");
INSERT INTO topNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","10","La̱ ca̱ta̱chihui̱nanko̱lh xlacán ta̱lh nac fiesta y Jesús li̱catzi tamákxtakli nac Galilea, pero a̱stá̱n na̱ tze̱k alh nac fiesta porque ni̱ ixlacasquín acxilhcán la̱ta tzamacán. ");
INSERT INTO topNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nac fiesta xanapuxcun judíos talacapútzalh Jesús para na̱ ixani̱t, ixtakalasquini̱nán tí ixacxilhni̱t o nicu ixani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Xa̱makapitzi cristianos tze̱k ixtali̱chihui̱nán Jesús xlacata ni̱ natakaxmata xanapuxcun judíos porque ixtajicuán para naca̱ma̱kalhapali̱cán. Makapitzi cristianos ixtahuán: ―Namá chixcú tla̱n catzí. Pero tunu ixtahuán: ―Namá chixcú huata ca̱kskahuí cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Akta̱ti chichiní ixkalhí la̱ta ixlacatzucuni̱t tacuhui̱ní acxni Jesús alh ixlacaquilhti̱n pu̱siculan y tzúculh ca̱ma̱kalhchihui̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Xanapuxcun judíos ni̱ ixtacatzí nicu ixma̱xtú ixli̱skalala Jesús y huata ixtahuán: ―¿Nicu li̱ma̱kachakxí jaé chixcú ixtachihui̱n Dios ni̱ma̱ ca̱ma̱xqui̱ni̱t quili̱talakapasnicán para ni̱ kalhtahuakani̱t? ");
INSERT INTO topNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús ca̱káxmatli y ca̱kálhti̱lh: ―La̱ta tú cli̱chihui̱nán ni̱ aquit clacsacxtuni̱t, tú cca̱ma̱si̱niyá̱n huá tú quili̱ma̱paksi̱ni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Para cha̱tum cristiano xli̱ca̱na ixtláhualh tú li̱mapaksi̱nán Dios tuncán ixma̱kachákxi̱lh para xlá quima̱lakacha̱ni̱t nacca̱ma̱si̱niyá̱n ixtalacapa̱stacni, o caj qui̱cstu cta̱clhca̱ni̱t la̱ta tú cca̱ma̱si̱niyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Amá cristiano tí ixacstu lacsaca ixtalacapa̱stacni y ca̱ma̱kalhchihui̱ní xa̱makapitzi lacasquín cali̱pa̱huanca, pero tí ma̱sí ixtalacapa̱stacni tunu ma̱s tali̱pa̱u lanca tlahuá tí ma̱lakácha̱lh y tancs chihui̱nán y ni̱ akskahuinán. ");
INSERT INTO topNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés ca̱ma̱xquí̱n hua̱k ixtapáksi̱t Dios y ni̱ tlahuayá̱tit tú ca̱li̱ma̱paksí̱n, huá xlacata ni̱ cma̱kachakxí hua̱nchi quila̱makni̱putuná̱u para ni̱ scarancua cma̱kantaxtí tú li̱ma̱paksí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","―¡Huix chiyani̱ta! ¿Ticu makni̱pununá̱n? ―takálhti̱lh amá lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero Jesús ca̱huánilh: ―Huixín ni̱ quila̱cxilhputuná̱u porque ni̱ ma̱tla̱ni̱yá̱tit la̱ cca̱tlahuá quintascújut acxni hua̱k jaxcán. ");
INSERT INTO topNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Dios li̱ma̱paksi̱nani̱t caca̱circuncidartlahuaca lactzu camán, pero hasta ixli̱maka̱s quilhtamacú Moisés tancs ca̱li̱ma̱paksí̱n siempre ca̱ma̱kantaxtí̱tit jaé ixli̱lakachixcuhui̱cán Dios, ");
INSERT INTO topNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","y para jaé chichiní lakchá̱n sábado huixín ma̱tla̱ni̱yá̱tit catáscujli tí ama circuncidartlahuá lactzu camán xlacata ni̱ nalakmakaná̱tit ixli̱ma̱paksí̱n Moisés. Chí cca̱kalasquiniyá̱n, ¿hua̱nchi quila̱sitzi̱niyá̱u aquit caj xlacata cma̱ksá̱ni̱lh hua̱k ixmacni cha̱tum chixcú acxni li̱huancán tí nascuja? ");
INSERT INTO topNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tla̱n calacpuhuántit quintachihuí̱n y quila̱huaníu para ni̱ chuná qui̱taxtú tú cca̱huanín. ");
INSERT INTO topNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Makapitzi xanapuxcún judíos tí ixtaminit xalac Jerusalén tzúculh tahuán: ―¿Ni huá jaé chixcú putzamaca xlacata namaknicán? ");
INSERT INTO topNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xlá chihuinama juú ní tzamacán y nití lihuaní. ¿A poco xanapuxcún curas na tacanajlalhá xlacata huá jaé Cristo tí ama quincalakmaxtuyán? ");
INSERT INTO topNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero aquín catziyáu ní lakahuanit y ní stacnit namá chixcú, y acxni namín Cristo caquilhtamacú nití ama catzí ní ama taxtú. ");
INSERT INTO topNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús caliakchihuínalh cristianos acxni ixtanuma nac ixlacaquilhtín pusiculan, cahuánilh: ―Huixín catziyátit ní cstacnit y quilalakapasáu, pero huí tú ni catziyátit aquit cminitanchá ixpaxtún chatum tí huixín ni lakapasátit y xlá tancs mastá ixtalacapastacni. ");
INSERT INTO topNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Aquit clakapasa porque huá cta̱latamani̱t y xlá quima̱lakacha̱nít. ");
INSERT INTO topNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Amá lactali̱pa̱u judíos talimpútulh nac pulachín pero ni chatum tí chípalh porque ya ixlakchán ixquilhtamacú natamacamastá. ");
INSERT INTO topNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lhuhua cristianos tí ixtanit nac pusiculan tacanájlalh ixtachihuí̱n Jesús, ixtahuán: ―Acxni naquinca̱lakminá̱n Cristo tí ama quinca̱lakma̱xtuyá̱n, ¿cha̱ naquinca̱li̱ma̱lacahua̱ni̱yá̱n ma̱s laclanca ixtascújut la̱ ca̱tlahuá jaé chixcú? ");
INSERT INTO topNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Makapitzi fariseos acxni takáxmatli tú ixtaquilhuama̱na amá cristianos tzúculh tata̱lacchihui̱nán xanapuxcun curas y tama̱lakácha̱lh makapitzi soldados xlacata catachípalh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xlacán ta̱lh pero Jesús ca̱huánilh: ―¡Huixín ni̱ amá̱n quila̱chipayá̱u! Porque ya̱ lakchá̱n quilhtamacú naclakán tí quima̱lakacha̱ni̱t. ¡Camajcú ca̱ta̱latama̱yá̱n a̱laktzú! ");
INSERT INTO topNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A̱stá̱n huixín amá̱n quila̱lacaputzayá̱u y ni̱ amán quila̱takasá̱u porque ana ní cama an huixín ni̱ lá pa̱t chipiná̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Amá xanapuxcun judíos ni̱ tama̱kachákxi̱lh ixtachihuí̱n y tzúculh tara̱kalasquiní: ―Jaé chixcú huan ni̱ amá̱n taka̱sá̱u ana ní ama an. ¿Cha̱ nicu ama an? Ma̱x ama ca̱lakán judíos tí talama̱na nac Grecia xlacata na naca̱li̱ma̱kalhchihui̱ní ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tucu lacasquín cama̱kachakxí̱u hua̱nchi quinca̱huaniyá̱n xlacata amá̱n lacaputzayá̱u y ni̱ amá̱n taka̱sá̱u porque ana ní xlá ama an ni̱ lá amá̱n lakcha̱ná̱u? ");
INSERT INTO topNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ixactu̱májat amá fiesta acxni ixlakó ma̱s ixtatzamacán, Jesús ca̱huánilh cristianos: ―Cati̱huá tí kalhtí caquilákmilh aquit nacma̱kotí. ");
INSERT INTO topNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Pues chí kantaxtuma tú huan Escrituras: “Nac ixnacujcán cristianos ama takalhí aktum taxtunú tú natali̱latamá.” ");
INSERT INTO topNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús ta̱ma̱lacástucli jaé taxtunú Espíritu Santo ni̱ma̱ ixama ca̱ma̱xquí tí natali̱pa̱huán. Pero como ya ixlakán ixti̱cú ya̱ ixma̱lakachá ixespíritu. ");
INSERT INTO topNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","La̱ takaxmatko̱lh ixtachihuí̱n, makapitzi tzúculh tahuán: ―Xli̱ca̱na huá jaé profeta tí ixama̱ca ma̱lakacha̱cán napu̱laní Cristo. ");
INSERT INTO topNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","―Tó̱, jaé ni̱ profeta, jaé chixcú huá Cristo tí ama quinca̱lakma̱xtuyá̱n ―ixtakalhti̱nán tunu. ");
INSERT INTO topNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Pero huí tí ixtahuán: ―¿Nicu li̱puhuaná̱tit xlacata Cristo xalac Galilea ama huan? Dios ca̱ma̱cxcatzí̱ni̱lh profetas xlacata Cristo ama lakahuán nac Belén ixca̱chiquí̱n rey David porque ixli̱talakapasni ama huan. ");
INSERT INTO topNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Amá cristianos pu̱tuy tatapítzilh ixtalacapa̱stacnicán caj ixlacata Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amá soldados tali̱mpútulh Jesús nac pu̱la̱chi̱n pero ni̱ cha̱tum tí chípalh. ");
INSERT INTO topNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xlacán talakampá tí ixca̱ma̱lakacha̱ni̱t y amá xanapuxcun ma̱paksi̱nanín takalasquínilh: ―¿Hua̱nchi ni̱ chipátit namá chixcú? ");
INSERT INTO topNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","―Porque stalanca ixtalacapa̱stacni kalhí. ¡Ni̱cxni xackaxmatni̱táu tí chihui̱nán la̱ jaé chixcú! ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","―¿A poco huixín na̱ ca̱makaca̱najlani̱tán ixtachihuí̱n namá akskahuina chixcú? ");
INSERT INTO topNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Huak aquín xanapuxcun ma̱paksi̱naní̱n ni̱ cha̱tum tí li̱pa̱huani̱t ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Huata tali̱pa̱huani̱t namá laktakalhí̱n lacchixcuhuí̱n. ¡Xlacán ni̱tú tama̱kachakxí y talaktzanka̱ni̱t! ―tali̱kalhkamá̱nalh amá lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Na̱ aná ixtanu̱ma Nicodemo amá ko̱lú tí alh ta̱chihui̱nán Jesús aktum ca̱tzisní. Xlá ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Nac ley ni̱ma̱ li̱ma̱paksi̱naná̱u huan xlacata ni̱ lá ma̱lacapu̱yá̱u cha̱tum chixcú para ni̱ pu̱la kaxmatá̱u ixtachihuí̱n xlacata nacatzi̱yá̱u tú tlahuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","―¡Takalhí̱n huix! Na̱ xalac Galilea. Tla̱n cali̱kalhtahuaka ixtachihuí̱n Dios nac Escrituras xlacata nacatzi̱ya ni̱ cha̱tum tali̱pa̱u profeta lakahuani̱t nac Galilea ―takálhti̱lh makapitzi. ");
INSERT INTO topNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","La̱ talacchihui̱nanko̱lh amá lactali̱pa̱u lacchixcuhuí̱n cha̱tum cha̱túm ta̱lh nac ixchiccán. ");
INSERT INTO topNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús alh tamakxtaka nac Monte de los Olivos, ");
INSERT INTO topNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","pero ixli̱cha̱lí tzisa taspitpá nac pu̱siculan, y como lhu̱hua cristianos tama̱lacatzúhui̱lh xlá curucs tahui y tzúculh ca̱ma̱kalhchihui̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","La̱ta ixchihui̱nama tama̱lacatzúhui̱lh makapitzi xanapuxcun judíos y fariseos ixtali̱mín cha̱tum pusca̱t ni̱ma̱ ixta̱ma̱noklhucani̱t ixta̱lhtatama tunuj chixcú ni̱ huá ixtakolú. Xlacán tayá̱hualh nac ixlacatí̱n ");
INSERT INTO topNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y takalasquínilh: ―Maestro, jaé pusca̱t ta̱ma̱noklhuca tunuj chixcú ixakskahuima ixta̱ko̱lú. ");
INSERT INTO topNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nac ixley Moisés li̱ma̱paksi̱nán cacli̱makní̱u chíhuix tí tlahuá jaé talakalhí̱n. ¿Huix tucu huana cactlahuaníu? ");
INSERT INTO topNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xlacán ixtalacasquín cahuá tú ni̱ chuná qui̱taxtú xlacata ixacstu natalaksí y tla̱n natama̱lacapú. Pero Jesús ni̱tú kalhtí̱nalh y li̱catzi tzúculh ca̱li̱lhti̱ta ixmacán nac ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Xlacán ni̱ tali̱mákxtakli y ma̱schá takalasquínilh hasta xní Jesús yaj lá tá̱lalh, y ca̱huánilh: ―¡Para lacasquiná̱tit camakní̱tit! Pero pu̱la caliactálalh chíhuix amá tí ni̱ tlahuani̱t talakalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesús tuncán taquilhpu̱tapá y tzucupá ca̱lhti̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Amá lacchixcuhuí̱n tí ixtama̱lacapu̱ni̱t amá pusca̱t tzúculh talacapa̱staca tú ixtatlahuanit, ¡ixacstucán tataláksi̱lh! Lakasu̱t tzúculh ta̱kxtakya̱huá tí ixtama̱lacapu̱ni̱t, pu̱la ta̱lh xalakko̱lún y a̱stá̱n xalakkahuasán. Acxni talacaya̱huapá Jesús a̱huata ixacstu ixyá amá pusca̱t. ");
INSERT INTO topNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Xlá tá̱yalh y huánilh: ―¿Nicu ta̱lh tí ixtama̱lacapu̱má̱n? ¿Ni̱tí li̱lhcuyuya̱huán mintala̱kalhí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―Tó̱, yaj tí quima̱lacápu̱lh ―kalhtí̱nalh amá pusca̱t. ―Pues ni̱ para aquit tú camá̱n li̱ya̱huayá̱n. Pero yaj catlahua tala̱kalhí̱n, capit nac mínchic ―huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","A̱stá̱n Jesús huá jaé takalhchihuí̱n: ―Aquit taxkáket tí lakskoy ca̱quilhtamacú. Amá tí quintakoké ni̱ ama akchakxa ní ca̱paklhtutá porque aquit cama makskoyulí̱n xlacata tancs nalakchá̱n lipa̱xá̱u latáma̱t. ");
INSERT INTO topNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Makapitzi fariseos tí takáxmatli ta̱ktásalh: ―¡Huix akskahuiná porque mi̱cstu tatla̱ni̱ya ixlacati̱ncan cristianos, ni̱tú li̱macuán mintachihuí̱n! ");
INSERT INTO topNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","―Aquit ni̱ cakskahuinán ma̱squi qui̱cstu ctatla̱ní, porque aquit ccatzí ní cmini̱tanchá y ccatzí ní cama cha̱n, y huixín ma̱squi ni̱ catzi̱yá̱tit tú quilakxtu ni̱ para ticu yá chixcú aquit ");
INSERT INTO topNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","quila̱li̱ya̱huama̱náu tú lacasquiná̱tit porque la̱ cati̱hua chixcú quila̱li̱macaná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aquit ni̱tú cca̱li̱ya̱huayá̱n, pero para xacca̱ma̱lacápu̱lh minkasatcán, tú xacca̱huanín hua̱k xli̱ca̱na porque Quinti̱cú tí quima̱lakacha̱ni̱t quima̱xquí ixtalacapa̱stacni tú nacuán. ");
INSERT INTO topNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nac ley ni̱ma̱ li̱ma̱paksi̱naná̱tit huan para cha̱tuy lacchixcuhuí̱n acxtum tú tali̱chihui̱nán tla̱n ca̱ca̱najlanicán tú tahuán. ");
INSERT INTO topNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aquit cca̱huaniyá̱n, quintachihuí̱n kalhí cha̱tuy testigo, aquit y Quinti̱cú tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","―¿Nicu huí minti̱cú? ―takalasquínilh amá lacchixcuhuí̱n. ―Huixín ni̱ lakapasá̱tit quinti̱cú porque ni̱ catziyá̱tit ticu yá chixcú aquit; para ixcatzí̱tit ticu yá chixcú aquit na̱ ixlakapástit quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús ca̱ta̱chihuí̱nalh jaé fariseos acxni ixchihui̱nama ixlacaquilhti̱n pu̱siculan ní ixtahuila̱na cajas ixca̱pu̱muju̱cán li̱mosnas, pero ni̱ táli̱lh nac pu̱la̱chi̱n porque ya̱ ixlakchá̱n ixhora natamacama̱stá. ");
INSERT INTO topNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ni̱ ixli̱maka̱s Jesús ca̱huanipá jaé takalhchihuí̱n: ―Huixín amá̱n quila̱lacaputzayá̱u ana ní cama an pero ni̱ lá pa̱t chipiná̱tit ní cama cha̱n porque antes naquila̱taka̱sá̱u pa̱t ta̱ni̱yá̱tit mintala̱kalhi̱ncán nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Amá lactali̱pa̱u lacchixcuhuí̱n tzúculh tara̱huaní: ―Jaé chixcú ma̱x ama̱ca makni̱cán ixacstu, huá quinca̱li̱huaniyá̱n ni̱ lá catichá̱u ana ní ama cha̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","―Mimpu̱latama̱ncán huí tu̱tzú y aquit quimpu̱latama̱n huí talhmá̱n. Huixín xala ca̱quilhtamacú y aquit ni̱ xala ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Aquit cca̱huanín pa̱t ta̱ni̱yá̱tit mintala̱kalhi̱ncán nac milatama̱tcán para ni̱ ca̱najlayá̱tit aquit amá chixcú tí mini̱tán ca̱lakma̱xtuyá̱n. ¡Xli̱ca̱na ama ca̱ma̱kni̱yá̱n mintala̱kalhi̱ncán para ni̱ quila̱li̱pa̱huaná̱u! ");
INSERT INTO topNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","―Quila̱huaníu, ¿ticu yá chixcú xli̱ca̱na huix? ―takalasquinipá. ");
INSERT INTO topNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","―Ni̱ caj maktum cca̱huanini̱tán. Aquit tla̱n xacca̱li̱chihui̱nán y xacca̱li̱ya̱huán tú ni̱ tla̱n tlahuayá̱tit, pero tí quima̱lakacha̱ni̱t lacasquín cacmá̱si̱lh tú xlá lacasquín. Xlá tancs kalhí ixtalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Xlacán ni̱ tama̱kachákxi̱lh xlacata Jesús ixca̱li̱ta̱chihui̱nama Dios, ");
INSERT INTO topNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","huá ca̱li̱huanipá: ―Huixín pa̱t akxtokohuahuacayá̱tit talhmá̱n Ixkahuasa Dios y hasta acxnicú pa̱t ma̱kachakxi̱yá̱tit ticu yá chixcú xli̱ca̱na aquit. Na̱ pa̱t catziyá̱tit xlacata tú cca̱ma̱si̱niyá̱n huá tú quihuanini̱t Quinti̱cú y ni̱ qui̱cstu clacputzani̱t nacca̱ma̱kalhchihui̱ni̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Dios quima̱lakacha̱ni̱t y xlá ni̱cxni quiakxtakmakán, siempre quima̱xquí ixtalacapa̱stacni porque huata ctlahuá tú lakatí. ");
INSERT INTO topNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Acxni takaxmatko̱lh ixtachihuí̱n Jesús makapitzi amá lactali̱pa̱u lacchixcuhuí̱n tzúculh taca̱najlá xlacata Jesús huá Cristo ixuani̱t tí ixma̱lacnu̱cani̱t ama ca̱lakma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pero Jesús ca̱huánilh: ―Aquit camá̱n ca̱li̱maca̱ná̱n quidiscípulos tí quintakaxmatní, para xli̱ca̱na latapa̱yá̱tit y ma̱kantaxti̱yá̱tit tú cca̱li̱ma̱paksi̱yá̱n; ");
INSERT INTO topNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","y chuná pa̱t acxcatzi̱yá̱tit stalanca talacapa̱stacni, y jaé stalanca talacapa̱stacni ama lakma̱xtú mili̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","―Aquín ixli̱talakapasnicán Abraham y ni̱cxni tí quinca̱li̱ni̱tán la̱ tachí̱n chu̱ta nacscujá̱u. ¿Tucu lacasquina cacli̱ma̱kachakxí̱u namá mintachihuí̱n: “Jaé stalanca talacapa̱stacni ama lakma̱xtú mili̱stacnicán”? ");
INSERT INTO topNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ca̱huánilh: ―Amá tí tlahuá tala̱kalhín la̱ ixtachín tala̱kalhín li̱tamakxtaka. ");
INSERT INTO topNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Cha̱tum tachí̱n ni̱ lá tlahuá tú lacasquín, pero aquit Ixkahuasa Dios ni̱ tachí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Huá cca̱li̱huaniyá̱n huata aquit tla̱n cca̱lakma̱xtuyá̱n. ¡Tí ma̱tla̱ní caclakmá̱xtulh yaj ixtachí̱n ixtala̱kalhí̱n ama tamakxtaka! ");
INSERT INTO topNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aquit ccatzí xlacata Abraham ca̱ma̱lacatzuqui̱ni̱tán, pero ni̱ makslihuekeyá̱tit ixtalacapa̱stacni porque lhu̱hua huixín ni̱ ma̱tla̱ni̱yá̱tit tú cca̱ma̱si̱niyá̱n y huá xlacata quila̱li̱makni̱putuná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Aquit cca̱ma̱si̱niyá̱n y ctlahuá tú cacxilhni̱t y ckaxmatni̱t nac ixpaxtu̱n Quinti̱cú, y huixín na̱ tlahuayá̱tit tú ca̱ma̱lacpuhua̱ni̱yá̱n minti̱cucán xala jaé ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","―Aquín quinti̱cucán Abraham ―tahuánilh Jesús. Pero xlá ca̱huánilh: ―¡Ni̱ para cca̱najlá! Porque Abraham ni̱ ixtláhualh tú tlahuayá̱tit huixín. ");
INSERT INTO topNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aquit cca̱ma̱si̱niyá̱n ixtalacapa̱stacni Dios ni̱ma̱ quima̱sí̱nilh, pero huixín ni̱ ca̱najlayá̱tit y huá quila̱li̱makni̱putuná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","¡Huixín tlahuayá̱tit tú ca̱li̱ma̱paksi̱yá̱n minti̱cucán xala jaé ca̱quilhtamacú! ―¿Niculá quila̱li̱macama̱náu? Aquín ckalhiyá̱u cha̱tum Quinti̱cucán, huá Dios. ¡Aquín ni̱ clakahuani̱táu nac ca̱lactijyí̱n, Dios quinca̱lacsacni̱tán! ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","―Para Dios Minti̱cucán, ¿hua̱nchi ni̱ quila̱li̱pa̱huaná̱u? Aquit cmini̱tanchá ixpa̱stu̱n Dios; xlá quima̱lakácha̱lh ni̱ qui̱cstu cta̱clhca̱ni̱t nacca̱lakminá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Aquit ccatzí huixín ni̱ ma̱kachakxi̱yá̱tit quintachihuí̱n porque huí tí ca̱ma̱lakatzi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xlá lakatí akskahuinán, y la̱ta tilacatzúculh ca̱quilhtamacú ca̱ma̱xquí cristianos li̱xcájnit ixtapuhuá̱n xlacata ni̱ natama̱tancsá ixlatama̱tcán. Jaé tí ca̱ma̱lakatzi̱yá̱n huá tlajaná, huixín la̱ ixcamán pues xlá acpuxcún catu̱ya̱huá ta̱kskahuín. ");
INSERT INTO topNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Huá xlacata ma̱squi aquit cca̱ma̱si̱niyá̱n ixtalacapa̱stacni Dios huixín ni̱cxni lá ca̱najlayá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Para tí catzí ckalhí tala̱kalhí̱n, caquihuánilh. ¡La̱ta mili̱hua̱kcán ni̱ lá tí quima̱lulokní ctlahuani̱t aktum tala̱kalhí̱n! Aquit Ixkahuasa Dios y cca̱ma̱xqui̱yá̱n ixtalacapa̱stacni huá xlacata cli̱puhuán la̱ ni̱ quila̱li̱pa̱huaná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Amá cristianos tí xli̱ca̱na tali̱pa̱huán Dios tapa̱xahuá acxni takaxmata ixtachihuí̱n, y huixín ni̱ li̱pa̱huaná̱tit Dios huá ni̱ li̱ca̱najlayá̱tit quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Amá xanapuxcun judíos tali̱kalhkamá̱nalh Jesús: ―¡Takalhí̱n chixcú! La̱ xalac Samaria chihui̱nana; ni̱ cakskahuinaná̱u acxni cca̱huanín xlacata makatlajani̱tán tlajaná. ");
INSERT INTO topNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","―Tó̱, aquit ni̱ quimakatlajani̱t tlajaná. ¿Cacatzi hua̱na ni̱ ma̱kachakxi̱yá̱tit xlacata huata clakachixcuhuí Quinti̱cú? Huixín chá̱ li̱kalhchiya̱nampa̱nántit ixtacuhui̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Aquit ni̱ lanca cuamputún nac milacati̱ncán, ¡ni̱ clactlancán! Pero tí quima̱lakachani̱t lacasquín naquilakachixcuhui̱cán, y huá amá ca̱ma̱lacapú tí ni̱ quintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","¡Pero tí tlahuá tú cli̱ma̱paksi̱nán ni̱cxni ama ní siempre ama latamá! ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xlacán tahuanipá: ―Chí tla̱n cma̱luloká̱u makachiyani̱tán tlajaná, porque Abraham y hua̱k profetas siempre táni̱lh y huix huana xlacata tí tlahuá mintapáksi̱t ni̱ ama ní. ");
INSERT INTO topNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Para Abraham y profetas táni̱lh, ¿ticu huix ta̱talacastúcpa̱t? ¿A poco huix makatlajaya quinti̱cucán Abraham? ");
INSERT INTO topNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús ca̱kálhti̱lh: ―Para qui̱cstu xaclacpútzalh la̱ naclactlancán cmilacati̱ncán tú xacca̱huanín ni̱tú li̱macuán. Pero Quinti̱cú tí li̱macapiná̱tit Dios, ca̱li̱ma̱lacahua̱ni̱má̱n ticu yá chixcú aquit. ");
INSERT INTO topNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Huata aquit clakapasa Dios, huixín ni lakapasá̱tit. Pero la̱ta tú cca̱huaniyá̱n huak xli̱ca̱na, y para xacca̱huanín akspita tachihuí̱n na̱ akskahuiná xacuá la̱ huixín. Aquit ccatzí tí Quinti̱cú huá cli̱ma̱kantaxtí tú quili̱ma̱paksí. ");
INSERT INTO topNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mili̱talakapasnicán Abraham pa̱xáhualh acxni cajcú ixlacpuhuán la̱ cama kalhí quili̱tlihueke; xlá ácxilhli jaé quilhtamacú nac ixtalacpuhuá̱n y ma̱s pa̱xahuako̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Amá lacchixcuhuí̱n takalasquínilh: ―¿Nicu liacxilhni̱ta quili̱talakapasnicán Abraham ixuani̱t si ni̱ para ítat ciento ca̱ta kalhi̱yá̱n? ");
INSERT INTO topNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","―¡Huixín ni̱ catziyá̱tit xlacata aquit clatama̱ni̱t la̱ta ya̱ para ixlakahuán Abraham! ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Amá lactali̱pa̱u lacchixcuhuí̱n la̱ta tasí̱tzi̱lh tásacli chíhuix xlacata nata̱ctalalí̱n Jesús, pero xlá ca̱tatzé̱knilh y táxtulh amá lanca pu̱siculan xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús taka̱stá̱yalh cha̱tum lakatzí̱n; ");
INSERT INTO topNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ixdiscípulos takalasquínilh: ―¿Hua̱nchi lakatzí̱n lakáhualh namá chixcú? ¿Chá̱ li̱n lhu̱hua tala̱kalhí̱n? o ¿xanati̱cún ixtatlahuani̱t lhu̱hua tala̱kalhí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","―Ni̱ para huá, ni̱ para xanati̱cún talí̱n cuenta. Xlá lakáhualh lakatzí̱n porque Dios li̱lhca̱ni̱t ama ma̱sí ixli̱tlihueke nac ixmacni namá chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Quili̱tlahuatcán ixtascújut amá tí quima̱lakacha̱ni̱t la̱ta ca̱cuhui̱ní porque amajá tanú ca̱tzisní y yaj lá tí ama scuja. ");
INSERT INTO topNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pero la̱ta clama nahuán ca̱quilhtamacú aquit ni̱ cama li̱makxtaka cma̱stá quintaxkáket ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","A̱stá̱n Jesús li̱lhkómalh ixchújut actzu tíyat y lacahuíli̱lh nac ixlakastapu amá lakatzí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Xlá li̱ma̱páksi̱lh: ―Capit lakachakaya nac taxtunú ni̱ma̱ huanicán Siloé (jaé tachihuí̱n huamputún: “tí ma̱lakacha̱ncani̱t”). ");
INSERT INTO topNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Amá lakatzí̱n alh lakachaká y tuncán lacahuá̱nalh. Makapitzi tí ixca̱ta̱squihua̱yán y tí ixtalakapasa tzúculh tahuán: ―¿Ni̱ huá jaé lakatzí̱n tí squihua̱yán? ");
INSERT INTO topNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Makapitzi ixtakalhti̱nán: ―Huá namá lakatzí̱n. Y tunu ixtahuán: ―Ni̱ huá, pero na̱ chú tasí. Xlá ca̱huánilh: ―Aquit namá tí li̱chihui̱nampa̱nántit. ");
INSERT INTO topNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","―¿Niculá tlahuán xlacata tla̱n nalacahua̱nana? ―ixtakalasquiní. ");
INSERT INTO topNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","―Namá chixcú tí huanicán Jesús, laklhkómalh actzu tíyat quilacahuíli̱lh nac quilakastapu y quihuánilh cacalh lakachaká nac taxtunú xla Siloé. Aquit ckaxmátnilh y chí tla̱n clacahua̱nán ―ca̱kálhti̱lh amá chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―¿Nicu alh namá chixcú? ―takalasquinipá. ―Ni̱ ccatzí ní alh ―kalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jaé chichiní acxni ma̱ksá̱ni̱lh Jesús amá lakatzí̱n sábado ixuani̱t y como ixli̱huancán makapitzi tali̱lh amá lakatzí̱n ixlacati̱ncan fariseos. ");
INSERT INTO topNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Xlacán takalásquilh la̱ ixaksa̱nani̱t y lakasu̱t ca̱lacspí̱tnilh la̱ Jesús laklhkómalh tíyat, a̱stá̱n lacahuíli̱lh y acxni lakachákalh tla̱n lacahuá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","La̱ takaxmatko̱lh tú ca̱huánilh amá lakatzí̱n, makapitzí̱n tzúculh tahuán: ―Namá chixcú ni̱ li̱pa̱huán Dios lakmakán ixtapáksi̱t huá li̱scuja jaé chichiní. ―¿Puhuaná̱tit para ixkálhi̱lh tala̱kalhí̱n tla̱n ixca̱tláhualh jaé lanca tascújut? ―ixtakalhti̱nán makapitzi. Y ni̱ lá ixtalacca̱xlá. ");
INSERT INTO topNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","A ver ticu ixuán tú xli̱ca̱na mejor ta̱mpá takalasquínilh amá lakatzí̱n: ―Huix, ¿niculá li̱macapina namá chixcú tí ma̱lacahua̱ní̱n? ―Aquit cli̱macá̱n cha̱tum profeta tí ma̱lakacha̱ni̱t Dios ―ca̱kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Xlacán ni̱ ixta̱canajlá para lakatzí̱n ixuani̱t amá chixcú y hasta tama̱tasani̱ní̱nalh ixnati̱cún y takalasquínilh: ");
INSERT INTO topNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","―¿Xli̱ca̱na huá jaé minkahuasacán? Xlá huan lakatzí̱n lakáhualh y ccatziputuná̱u, ¿nicu li̱lacahua̱nán chí? ");
INSERT INTO topNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","―Huá jaé quinkahuasacán, xlá lakatzí̱n lakáhualh, ");
INSERT INTO topNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","pero ni̱ ccatzi̱yá̱u niculá tláhualh xlacata nalacahua̱nán, y ni̱ para ccatzi̱yá̱u tí ma̱lacahuá̱ni̱lh. ¿Hua̱nchi ni̱ huá kalasquiniyá̱tit, pues xlá chixcutá y yaj mini̱ní naclacati̱ta̱yayá̱u? ");
INSERT INTO topNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Amá lakko̱lún chuná jaé takalhtí̱nalh porque ixtajicuaní amá fariseos. Pues xlacán ixtali̱ma̱paksi̱nani̱t caca̱tamacxtuca nac sinagogas amá cristianos tí ixtahuán xlacata Jesús huá Cristo tí ximini̱t ca̱lakmaxtú. ");
INSERT INTO topNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Amá fariseos tatasanipá amá lakatzí̱n ixli̱maktu̱y, y tahuánilh: ―Capa̱xcatcatzi̱ni Dios tú tlahuani̱t milacata y ni̱ cali̱pá̱huanti Jesús porque namá chixcú kalhí lhu̱hua tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","―Aquit ni̱ ccatzí para kalhí tala̱kalhí̱n o ni̱tú ixkásat, aquit huata ccatzí xlacata lakatzí̱n xacuani̱t y chí tla̱n clacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","―Pero, ¿niculá tlahuán? ¿Tucu tlahuanín xlacata nama̱lacahua̱ni̱yá̱n? ―takalasquinipá ixli̱maktuy. ");
INSERT INTO topNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Amá chixcú ca̱ta̱ra̱huánilh: ―Ccahuanini̱taná ni̱ caj maktum y ni̱ ca̱najlayá̱tit. ¿Hua̱nchi lacasquiná̱tit cacca̱huaniparán? ¿A poco na̱ pa̱t li̱pa̱huaná̱tit ixtachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Xlacán tzúculh tali̱kalhkama̱nán, y a̱stá̱n tahuánilh: ―Huix li̱pa̱huana namá chixcú y aquín cca̱najlayá̱u ixtachihui̱n Moisés ");
INSERT INTO topNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","porque ccatzi̱yá̱u la̱ Dios ta̱chihuí̱nalh, y namá chixcú ni̱ para ccatzi̱yá̱u ní mini̱tanchá. ");
INSERT INTO topNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","―¡Aná chí aktzanka̱ni̱tántit! Huixín ni̱ catzi̱yá̱tit ní mini̱tanchá, pero acxilhpa̱nántit la̱ ca̱ma̱lacahua̱ní lakatzí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Cati̱huá catzí xlacata Dios ca̱ma̱xquí ixtapuhuá̱n tí tlahuá ixtapáksi̱t y ni̱ takalhí tala̱kalhí̱n, y tí tatlahuá tala̱kalhí̱n ni̱tú ca̱ma̱xquí. ");
INSERT INTO topNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","La̱ta tilacatzúculh ca̱quilhtamacú ni̱ latama̱ni̱t cha̱tum chixcú tí li̱ma̱lacahua̱ní ixli̱tlihueke cha̱tum lakatzí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Huá cca̱li̱huaniyá̱n calacpuhuántit: para jaé chixcú ixkálhi̱lh tala̱kalhí̱n, ¿puhuaná̱tit tla̱n ixma̱lacahuá̱ni̱lh cha̱tum lakatzí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amá fariseos yaj lá tatá̱lalh y tahuánilh: ―¡Acs cata̱ya takalhi̱n chixcú! La̱ta tilakáhuanti kalhi̱ya tala̱kalhí̱n huá liakxtakájnanti. ¿Nicu li̱puhuana chí huix naquila̱huaniyá̱u tú quili̱tlahuatcán? Amá fariseos tamá̱xtulh nac sinagoga. ");
INSERT INTO topNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús cátzi̱lh tú ixpa̱xtokni̱t amá chixcú y acxni ta̱tánoklhli huánilh: ―¿Huix ixca̱najla ixtachihui̱n Xatalacsacni Chixcú? ");
INSERT INTO topNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","―Señor, quihuani ticu namá chixcú, aquit cca̱najlaputún ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","―Pi̱huá tí acxílhpa̱t y ta̱chihui̱namá̱n. Aquit namá tí mini̱tán ca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","―Quimpu̱chinacán, aquit cli̱pa̱huaná̱n ―huaniko̱lh amá chixcú Jesús y tatzokostánilh ixlacatí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Xlá chihui̱nampá: ―Aquit cmini̱t ca̱li̱lacahua̱nán ixkasatcán cristianos ca̱quilhtamacú. Amá tí la̱ lakatzí̱n ixtalama̱na porque ni̱tú ixtama̱kachakxí tla̱n talacahua̱nán, y tí talacahua̱nán tapuhuán porque lakskalala ni̱ ama quintakaxmata. ");
INSERT INTO topNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Aná ixtalaya̱na lacatzú makapitzi fariseos y xlacán tahuánilh: ―¿Huix puhuana xlacata laktzí̱n clama̱náu? ");
INSERT INTO topNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús ca̱kálhti̱lh: ―Aquit cca̱huaniyá̱n, para huixín ixli̱tanú̱tit lakatzí̱n tí ni̱tú ma̱kachakxí, ni̱tí ixca̱ma̱xoko̱ní̱n mintala̱kalhi̱ncán, pero como huaná̱tit hua̱k ma̱kachakxi̱yá̱tit porque lacahua̱naná̱tit, pa̱t xoko̱naná̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Amá tí kalhpa̱kosa ixcorra̱lhcan borregos li̱maca̱ncán cha̱tum kalha̱ná porque tí ni̱ kalha̱ná siempre lactanú nac puhui̱lhta. ");
INSERT INTO topNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cha̱tum ixpu̱china borregos lactanú nac puhui̱lhta y ma̱liqui̱ní tí makxtakcani̱t namaktakalhnán nac corra̱l. ");
INSERT INTO topNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Xlá ca̱tasaní ixborregos y acxni takaxmata la̱ ca̱ma̱pa̱cuhuí ixpu̱chinacán, tuncán takalhlakapasa y pu̱tum ca̱tamacxtukó. ");
INSERT INTO topNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Xlá ca̱cpu̱laní ixborregos y hua̱k tatakoké porque talakapasa ixpu̱chinacán. ");
INSERT INTO topNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero para ca̱tasaní tunu cristiano ni̱ tatakoké, ma̱s cha̱ tatza̱laní porque ni̱ takalhlakapasa ixtachihuí̱n tunuj chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jaé takalhchihuí̱n ni̱ tama̱kachákxi̱lh amá fariseos ni̱ tacátzi̱lh tú ixca̱li̱ma̱si̱niputún ");
INSERT INTO topNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","y huá ca̱li̱huánilh: ―Tancs cca̱huaniyá̱n, aquit namá puhui̱lhta ní lactanu̱cán ca̱ma̱xtucán borregos. ");
INSERT INTO topNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La̱ta ya̱ xacmín tamini̱t lhu̱hua kalha̱naní̱n y makni̱naní̱n tí ta̱klhpa̱kosni̱t corra̱l, pero quiborregos ni̱ tatakokeni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Aquit cli̱tanú namá puhui̱lhta ní lactanu̱cán nac corra̱l. Amá tí lactanú jaé puhui̱lhta ama taxtuní, pues tla̱n tanú y taxtú ca̱li̱tlá̱n y ama taka̱sa sákat tú nali̱hua̱yán, y nali̱kalhkasa. ");
INSERT INTO topNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cha̱tum kalha̱ná huata min kalhán, makni̱nán y lactlahuá tú tanu̱ma nac corral, pero aquit cmini̱t ca̱ma̱camaja ixnacujcán quiborregos xlacata ni̱tú naca̱tzanka̱ní ixlatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jesús como ti̱tum ixya̱huani̱t ixtalacpa̱stacni, ca̱huaniko̱lh: ―Aquit na̱ cli̱tanú ixmaktakalhnacan borregos, y cha̱tum tla̱n ixmaktakalhna borregos tí ca̱lakalhamán ixquitzistancaní̱n ni̱ laccatzán ixli̱stacni ma̱squi ixmakni̱ca ixlacatacán. ");
INSERT INTO topNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero amá tasa̱cua tí ma̱cuentajni̱cán borregos y huata xokonicán acxni acxila mima la̱páni̱t ca̱kxtakmakán borregos y tza̱lá, entonces amá la̱páni̱t ca̱li̱kosnán, ca̱pu̱tlaká y ca̱huá. ");
INSERT INTO topNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jaé tasa̱cua tí xokonicán, tza̱lá porque amá borregos ni̱ xlá huá ni̱ ca̱li̱lakcatzán. ");
INSERT INTO topNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Aquit ixmaktakalhna borregos y cca̱lakapasa tanatunu tí quintakoké, y xlacán na̱ quintalakapasa; y ma̱squi ni̱ ca̱najlayá̱tit chuná jaé clakapasa aquit Quinti̱cú, y xlá na̱ chuná quilakapasa. ");
INSERT INTO topNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Hasta quili̱stacni cama li̱xoko̱nán ixlacatacán quiborregos. ");
INSERT INTO topNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","’Chí cca̱huaniyá̱n, na̱ cca̱kalhí tunuj quiborregos a̱lacatunu, pero cama ca̱li̱mín y lakxtum cama ca̱tlahuá xlacata pu̱tum natahuán y huata quintachihuí̱n natakaxmata porque aquit ixmaktakalhnacan borregos. ");
INSERT INTO topNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Quinti̱cú quilakalhamán porque ni̱ cama tatuhuaja cma̱stá quili̱stacni ixlacatacán, pero ni̱ para ixli̱maka̱s cama maklhti̱nampará quili̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ni̱ lá tí quima̱laksputú para ni̱ cma̱tla̱ní, aquit cama ma̱stá quili̱stacni porque clacasquín. Xa̱huá ckalhí li̱tlihueke nacmacama̱stá quili̱stacni nacní, y na̱ ckalhí li̱tlihueke naclacastacuanán xni̱ta clacasquín. Quinti̱cú quima̱xqui̱ni̱t jaé li̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","La̱ takaxmatko̱lh ixtachihui̱n Jesús amá fariseos tzucupá tara̱li̱huaní ticu ixaktzanka̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Makapitzi ixtahuán: ―Jaé chixcú chiyani̱t makatlajani̱t tlajaná. ¿Hua̱nchi caso tlahuayá̱tit? ");
INSERT INTO topNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","―Tí makatlajani̱t tlajaná ni̱ chihuiná̱n la̱ jaé chixcú. Xa̱huá, ¿puhuaná̱tit cha̱tum tlajaná tla̱n ma̱lacahua̱ní cha̱tum lakatzí̱n? ―ixtakalhti̱nán tunu. ");
INSERT INTO topNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Amá quilhtamacú tánu̱lh ixquilhta ca̱lonkni y nac Jerusalén lákcha̱lh ixtacuhui̱ní “ixchichiní pu̱siculan”. ");
INSERT INTO topNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ixlapu̱lá nac pu̱siculan lacatum ní ixli̱ma̱pa̱cuhui̱cán Portal de Salomón, ");
INSERT INTO topNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","y aná tama̱lacatzúhui̱lh makapitzi xanapuxcun judíos y takalasquínilh: ―¿Hasta xnicu quila̱liakskahuima̱náu nahuán mintachihuí̱n? Para xli̱ca̱na huix Cristo tí ama quinca̱lakma̱xtuyá̱n, ¡tancs quila̱huaníu! ");
INSERT INTO topNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","―Ni̱ caj maktum cca̱huanini̱tán y ni̱ ca̱najlayá̱tit. Xa̱huá hua̱k quintascújut ni̱ma̱ cca̱li̱ma̱lacahua̱ni̱yá̱n, Quinti̱cú quima̱tlahuí y huá tama̱luloka ticu yá chixcú aquit. ");
INSERT INTO topNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Huixín ni̱ ca̱najlayá̱tit porque ni̱ ca̱ta̱tamakstoká̱tit quiborregos tí cca̱cuentaja. ");
INSERT INTO topNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Amá cristianos tí tali̱tanú quiborregos cca̱lakapasa y xlacán na̱ quintalakapasa, y acxni takaxmata quintachihuí̱n quintakoké. ");
INSERT INTO topNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Aquit cama ca̱ma̱lacastacuaní ixli̱stacnicán xlacata ni̱ natalaktzanká y siempre natalatamá nac quimpa̱xtú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Quinti̱cú ni̱tí makatlajá y huá quimacamaxqui̱ni̱t jaé borregos tí ca̱lacsacni̱t nacca̱cuentaja, y ni̱ lá tí ama quimakamaklhtí nac quimacán, na̱ chuná ni̱ lá tí makamaklhtí Quinti̱cú, ");
INSERT INTO topNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","porque aquit y xlá acxtum ckalhi̱yá̱u quili̱ma̱paksi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Amá lacchixcuhuí̱n tásacli chíhuix xlacata nata̱ctalalí̱n Jesús, ");
INSERT INTO topNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","pero xlá ca̱kalasquínilh: ―Dios quima̱tlahui̱ni̱t lhu̱hua laclanca tascújut ixlacatacán cristianos. ¿Chí neje ni̱ ma̱tla̱ni̱yá̱tit y huá ama quila̱liactalali̱ná̱u? ");
INSERT INTO topNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","―Ni̱ xlacata mintascújut camá̱n ca̱li̱ma̱xqui̱yá̱n, camá̱n ca̱ctalali̱ná̱n porque li̱kalhkama̱nana Dios ta̱ra̱lacata̱qui̱ya, y huix cha̱tum chixcú ―takalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","―Lacatum ní tatzokni̱t ixtapáksi̱t Dios huan: “Huixín la̱ Dios.” ");
INSERT INTO topNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Xlá ca̱li̱máca̱lh Dios amá cristianos tí takáxmatli y tatláhualh ixtapáksi̱t, y tú huan nac Escrituras ni̱ akskahuinán. ");
INSERT INTO topNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Aquit cca̱huanini̱tán xlacata Dios quilacsacni̱t y quima̱lakacha̱ni̱t ca̱quilhtamacú, entonces, ¿hua̱nchi puhuaná̱tit cta̱ra̱lacata̱qui̱ma para cca̱huaniyá̱n: “Ixkahuasa Dios aquit”? ");
INSERT INTO topNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Para aquit ni̱ xacca̱li̱ma̱lacahua̱ní̱n ixtascújut Dios tla̱n ni̱ ixquila̱ca̱najlaníu tú xacca̱huanín. ");
INSERT INTO topNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero chí acxilhni̱tántit, ¡pues siquiera cali̱pa̱huántit tí quima̱tlahuí namá tascújut ma̱squi aquit ni̱ caquila̱li̱pa̱huáu! Aquit huata clacasquín cama̱kachakxí̱tit xlacata Quinti̱cú lama nac quintalacapa̱stacni y aquit na̱ clama nac ixtalacapa̱stacni ―ca̱kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Xlacán tali̱mpútulh nac pu̱la̱chi̱n pero Jesús ca̱tza̱lánilh ");
INSERT INTO topNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","y alh ixa̱quilhtu̱tu kalhtu̱choko Jordán pakán ní Juan Bautista ixca̱kmunú cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Aná latáma̱lh laktzú y lhu̱hua xala amá pu̱lataman ixtahuán: ―Juan ni̱ ca̱tláhualh laclanca tascújut, pero la̱ta tú ixli̱chihui̱nán jaé chixcú hua̱k qui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lhu̱hua cristianos taca̱nájlalh xlacata Jesús huá Cristo ixuani̱t tí ixama ca̱lakmaxtú. ");
INSERT INTO topNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Nac aktum actzu cachiquín huanicán Betania ixlama María amá pusca̱t tí a̱stá̱n li̱tu̱chéke̱lh perfume Jesús y li̱tu̱ma̱scá̱calh ixchíxit. Xlá ixca̱ta̱lama ixta̱cam huanicán Marta y xachixcu ixta̱cam Lázaro snu̱n ixta̱tatlá. ");
INSERT INTO topNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Marta y María tama̱lakachá̱nilh tachihuí̱n Jesús xlacata cahuanica: “Miamigo Lázaro snu̱n ta̱tatlá.” ");
INSERT INTO topNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Acxni huanica jaé tachihuí̱n Jesús huá: ―Namá tá̱tat ni̱ ama pu̱tí, Dios ama li̱tlahuá ixtascújut y chuná aquit Ixkahuasa camán ca̱li̱ma̱lacahua̱ni̱yá̱n quintascújut ixmacni jaé chixcú xlacata naquilakachixcuhui̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús snu̱n ixca̱lakalhamán María, Marta y Lázaro, ");
INSERT INTO topNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","pero ni̱ sok ca̱lákalh y tamákxtakli aktuy chichiní amá pu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pero ixli̱tu̱xama ca̱huánilh ixdiscípulos: ―Chí ama̱náu nac Judea. ");
INSERT INTO topNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","―Maestro, ¿hua̱nchi pímpa̱t aná? Pues ni̱ kalhí lhu̱hua quilhtamacú acxni xanapuxcun judíos xala aná ixtali̱makni̱putuná̱n chíhuix ―tahuánilh. ");
INSERT INTO topNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","―Huixín catzi̱yá̱tit xlacata aktum chichiní kalhí akcu̱tuy hora y tí tla̱huán ca̱cuhui̱ní ni̱ akchakxa porque li̱lacahua̱nán taxkáket ni̱ma̱ huí ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tí tla̱huán ca̱tzisní tla̱n akchakxa porque ca̱paklhtu̱tá y ni̱ lacahua̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Xa̱huá huixín ni̱ catziyá̱tit xlacata quiamigo Lázaro lhtatani̱t y chí aquit cama ma̱lacastacuaní ―ca̱huánilh ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xlacán ixtapuhuán Lázaro caj ixjaxma huá ixli̱lhtatani̱t huá xlacata tali̱huánilh Jesús: ―Para caj lhtatani̱t entonces ama aksa̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Como ni̱ tama̱kachákxi̱lh xlacata Lázaro ixni̱ni̱t ");
INSERT INTO topNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","xlá tancs ca̱huánilh: ―Lázaro ni̱lh, ");
INSERT INTO topNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","y cpa̱xahuá la̱ ni̱ ctamákxtakli aná pues tú pa̱t acxilá̱tit ama ca̱macuaniyá̱n xlacata ma̱s naca̱najlayá̱tit ticu yá chixcú aquit. Chí tuncán ama̱náu acxilá̱u quiamigojcán. ");
INSERT INTO topNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ixdiscípulos Jesús tí ixuanicán Tomás ixtali̱ma̱pa̱cuhuí “Gemelo”, ca̱huánilh xa̱makapitzi discípulos: ―Aquín na̱ cata̱ahuí quimaestrojcán xlacata acxtum nata̱ni̱yá̱u para tamaclacasquiní. ");
INSERT INTO topNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","La̱ta nac Betania hasta nac Jerusalén ixkalhí aktuy kilómetro a̱ítat ixli̱lakamákat y huá xlacata lhu̱hua lactali̱pa̱u judíos ixtamini̱t ixchic María y Marta xlacata natama̱xquí li̱camama la̱ ixtamakatzanka̱ni̱t ixta̱camcán. Lázaro ixkalhi̱yá akta̱ti chichiní la̱ta ixmuju̱cani̱t acxni cha̱lh Jesús nac Betania. ");
INSERT INTO topNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Istzanka̱ní a̱laktzú nachá̱n nac ákxtaka acxni Marta huanica ixmima Jesús. Xlá lacapala alh lakapa̱xtoka, pero María ni̱ táxtulh. ");
INSERT INTO topNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","―Señor, para juú lápa̱t ixtihua quinta̱camcán ni̱ ixtíni̱lh ");
INSERT INTO topNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","porque ccatzí xlacata Dios ixtima̱lacastacuáni̱lh para huix ixtimáksquinti ―huánilh Marta. ");
INSERT INTO topNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","―Minta̱cam ama latama̱pará ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","―Jé, ama latama̱pará acxni natalacastacuanán hua̱k cristianos tí tani̱ni̱t ―kalhtí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesús tancs huánilh: ―Aquit cma̱lacatzuqui̱ni̱t latáma̱t y ckalhí li̱tlihueke cca̱ma̱lacastacuaní ixli̱stacni tí quili̱pa̱huán. Amá tí quili̱pa̱huán ma̱squi cani̱lh cama pu̱spitnipará ixli̱stacni, ");
INSERT INTO topNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","porque amá tí ca̱najlá quintachihuí̱n cma̱xquí sa̱sti ixlatáma̱t xlacata ni̱cxni nalaksputa. Jesús kalasquínilh Marta: ―¿Huix ca̱najlaya quintachihuí̱n ni̱ma̱ cuanini̱tán? ");
INSERT INTO topNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Quimpu̱chinacán, aquit cli̱pa̱huaná̱n y cca̱najlá huix Cristo Ixkahuasa Dios tí xackalhi̱ma̱náu ama quinca̱lakma̱xtuyá̱n ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","A̱stá̱n Marta alh ma̱ta̱sí ixpi̱pí María y chuné tze̱k huánilh: ―Apenas chilh quimaestrojcán y ta̱chihui̱namputuná̱n. ");
INSERT INTO topNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María tuncán tá̱yalh y lákalh Jesús, ");
INSERT INTO topNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","pues xlá ixlayajcú ana ní ixta̱tanoklhni̱t Marta. ");
INSERT INTO topNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Amá lactali̱pa̱u judios tí ixtamini̱t tama̱xquí li̱camama María y Marta, acxni tá̱cxilhli tá̱yalh y táxtulh lacapala, xlacán tatakókelh pues ixtapuhuán ixama laktasá ixta̱cam ana ní ixmuju̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María lákcha̱lh Jesús, tatzokostánilh y huánilh: ―Quimpu̱chinacán, para juú lápa̱t ixtihua quinta̱camcán chí lamajcú cahuá. ");
INSERT INTO topNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","María li̱cuánit ixlaktasá ixta̱cam, y amá judíos tí ixtatakokeni̱t na̱ ni̱ lá tatá̱lalh y talakáxtajli tziná. Jesús na̱ ni̱ lá tá̱lalh ixnacú y snun lakapútzalh. ");
INSERT INTO topNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Pero a̱stá̱n ca̱kalasquínilh: ―¿Nicu muju̱cani̱t minta̱camcán? ―Catat acxila xlacata nacatzi̱ya ―tahuánilh. ");
INSERT INTO topNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús cha̱lh ní ixmuju̱cani̱t y aná laktásalh ixamigo. ");
INSERT INTO topNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Amá lacchixcuhuí̱n tzúculh tahuán: ―Snu̱n ixta̱ra̱pa̱xquí huá li̱laktasá. ");
INSERT INTO topNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","―Xlá ma̱lacahuá̱ni̱lh cha̱tum lakatzí̱n, ¿cha̱ ni̱ lá ixtima̱lacastacuáni̱lh Lázaro xlacata ni̱ ixtíni̱lh? ―ixtahuán makapitzi. ");
INSERT INTO topNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús la̱tiyá ixlakaputzani̱t y chuná cha̱lh ana ní ixma̱nu̱cani̱t Lázaro ixlacahuaxcani̱t nac talhpá̱n, ixlacahuili̱cani̱t aktum lanca chíhuix. ");
INSERT INTO topNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","―Cama̱ke̱nú̱tit namá chíhuix ―li̱ma̱paksí̱nalh Jesús. ―Quimpu̱chinacán, chí quincalayá pues kalhí akta̱ti chichiní la̱ta tíni̱lh ―kalhpaktánu̱lh Marta. ");
INSERT INTO topNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","―Aquit cuanín para quili̱pa̱huana pa̱t li̱lacahua̱nana la̱ kalhí ixli̱tlihueke Dios ―kalhti̱ko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yaj ma̱s tí chihuí̱nalh y ma̱ke̱nu̱ca amá chíhuix, y Jesús talacayá̱hualh nac akapú̱n y chuné kalhtahuakánilh Dios: ");
INSERT INTO topNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","―Ta̱ta, cpa̱xcatcatzi̱niyá̱n la̱ siempre tlahuaya tú cmaksquiná̱n. Aquit ccatzí xlacata huix ni̱cxni quinkaxmatmakana, pero ckalhtahuakanimá̱n xlacata natakaxmata jaé cristianos y nataca̱najlá huix quima̱lakacha̱ni̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","La̱ kalhtahuakako̱lh aktásalh: ―¡Lázaro, cataxtu ní tanú̱pa̱t! ");
INSERT INTO topNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Amá ni̱n táxtulh la̱ta ixca̱xya̱huacani̱t acxni muju̱ca, ixmakachi̱cani̱t ixtatantu̱chí̱n, ixli̱talakatlapán lháka̱t. Jesús ca̱li̱ma̱páksi̱lh: ―Caxcúttit xlacata tla̱n natla̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lhu̱hua amá judíos tí ixta̱ni̱t talakpaxia̱lhnán María acxni tá̱cxilhli la̱ Jesús ma̱lacastacuáni̱lh Lázaro tali̱pá̱hualh xlacata Dios ixma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero makapitzi lacapala talákalh fariseos y tahuánilh la̱ta tú ixtlahuani̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Xlacán tata̱tamákstokli xanapuxcun curas y tzúculh talacchihui̱nán: ―¿Tucu tlahuayá̱u? Jaé chixcú xli̱ca̱na ca̱tlahuá laclanca ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Para li̱makxtaká̱u calatáma̱lh ma̱s lhu̱hua cristianos ama tali̱pa̱huán y entonces xanapuxcun romanos ama tapuhuán ama ca̱ta̱ra̱nicá̱u y natamín talactlahuá jaé pu̱siculan y quimpu̱latama̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amá ca̱ta ixma̱paksi̱nán Caifás, xlá lihua xapuxcu cura ixuani̱t y ni̱ ixma̱kachakxí para Dios ixma̱quilhcha̱ni̱ma tú nali̱chihui̱nán y caj la̱ cakalhchiyá̱nalh ca̱huánilh ixcompañeros: ―¡Huixín ni̱tú catzi̱yá̱tit! ");
INSERT INTO topNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pues ni̱ ma̱kachakxi̱yá̱tit xlacata ma̱s quinca̱macuaniyá̱n cani̱lh cha̱tum chixcú y ni̱ hua̱k quimpu̱latama̱ncán calaktzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Chuná jaé Caifás ni̱ acxcátzi̱lh para ixquilhcha̱ni̱t la̱ Jesús ixama̱ca makni̱cán ixlakapu̱xokocán cristianos xlacata nataxtuní ixpu̱latama̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Xlá na̱ ca̱huánilh ni̱ huata judíos ixama ca̱lakma̱xtú sino que hua̱k ixcamán Dios tí ixtalakahuani̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","La̱ta amá quilhtamacú xanapuxcun judíos talí̱lhca̱lh y talacpútzalh la̱ natamakní Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Xlá táxtulh amá pu̱latama̱n Judea y alh lacatzú nac desierto aktum actzu ca̱chiquí̱n huanicán Efraín; aná ca̱ta̱latáma̱lh ixdiscípulos y yaj ixán ana ní istzamacán. ");
INSERT INTO topNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ni̱ ixli̱maka̱s talacatzuhui̱pá ixpa̱scuajcán judíos ni̱ma̱ ixtama̱kantaxtí ca̱ta cá̱ta. Xa̱maka̱s lhu̱hua cristianos xala cani̱huá pu̱latama̱n tzúculh ta̱n nac Jerusalén; pu̱la ixtacha̱mputún xlacata naca̱spalhcán y natalakachixcuhui̱nán la̱ta ya̱ ixlakchá̱n lihua tacuhui̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Xanapuxcun curas y fariseos ixtama̱sta̱ni̱t tachihuí̱n xlacata tí ixcatzí ní huí Jesús cama̱láksi̱lh xlacata nama̱nu̱cán nac pu̱la̱chi̱n. Huá xlacata lhu̱hua nac fiesta ixtalacaputzá nac pu̱siculan. Ixtara̱kalasquiní: ―¿Tucu puhuaná̱tit, cha̱ namín nac fiesta, o ni̱ catímilh? ");
INSERT INTO topNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Istzanká akcha̱xán chichiní nalakchá̱n pa̱scua nac Jerusalén acxni Jesús cha̱lh nac Betania ana ní ixlama Lázaro amá chixcú tí ma̱lacastacuáni̱lh ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nac ixchic tahualhtátalh Jesús; Lázaro lakxtum ca̱ta̱huá̱yalh y María ixca̱muju̱nima ixtahuajcán. ");
INSERT INTO topNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ixli̱puntzú María lí̱milh aktum lanca frasco perfume xla xánat huanicán nardo snu̱n ixtapalh ixuani̱t. Xlá tla̱n li̱tu̱chéke̱lh Jesús y a̱stá̱n li̱tu̱ma̱scá̱calh ixchíxit. Amá perfume aktum li̱tama̱ko̱lh ákxtaka. ");
INSERT INTO topNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amá ixdiscípulo tí ixama macama̱stá huanicán Judas Iscariote ca̱huánilh xa̱makapitzi: ");
INSERT INTO topNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Hua̱nchi pa̱xcat tlahuaca jaé perfume? Mejor ixtista̱ca y xatumi̱n ixtica̱li̱makta̱yaca pobres. ");
INSERT INTO topNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ni̱ xlacata ixca̱lakalhamán pobres chú ixchihui̱nani̱t porque ixlakcatzán tumi̱n, como huá ixma̱cpuxqui̱cán nama̱quí tumi̱n siempre ixacma̱xtú. ");
INSERT INTO topNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesús ta̱chihuí̱nalh: ―¡Cali̱makxtáktit tú tlahuama! Porque xlá ca̱xtlahuamajá quimacni acxni naquimuju̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xa̱huá pobres siempre ca̱ta̱lapa̱nántit nahuán y tla̱n naca̱makta̱yayá̱tit, pero aquit yaj maka̱s camá̱n ca̱ta̱latama̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lhu̱hua cristianos tí ixta̱ni̱ttá nac Jerusalén tacátzi̱lh xlacata Jesús ixchini̱t nac Betania y ta̱lh ta̱cxila, y na̱ ixtalakapasputún Lázaro amá tí ma̱lacastacuáni̱lh nac ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Acxni ixta̱cxila ixtali̱pa̱huán Jesús Dios ixma̱lakacha̱ni̱t, xanapuxcun judíos talí̱lhca̱lh na̱ ixama tamakní Lázaro ");
INSERT INTO topNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","porque caj xlacata yaj ixca̱li̱pa̱huancán ixtachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ixli̱cha̱lí amá cristianos tí ixtamini̱t nac tacuhui̱ní xla pa̱scua acxni tacátzi̱lh xlacata Jesús ixmima nac Jerusalén, ");
INSERT INTO topNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","tzúculh taquí ixpakán tzú̱csuat y ta̱lh tali̱lakapa̱xtoka Jesús. Xlacán ixtama̱ktasí: ―¡Clakachixcuhui̱yá̱u Dios! ¡Tasicuna̱tláu cahuá namá chixcú tí ma̱lakacha̱ni̱t Quinti̱cucán Dios! ¡Clakachixcuhui̱yá̱u namá rey tí nama̱paksi̱nán nac Israel! ");
INSERT INTO topNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ixpu̱huaca tantum burro y chuná jaé ma̱kantáxti̱lh amá tachihuí̱n ni̱ma̱ ixtatzokni̱t ixlacata: ");
INSERT INTO topNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Capa̱xahuátit y ni̱ ca̱katuyúntit tí lapa̱nántit nac ca̱chiquí̱n xla Jerusalén; ca̱cxílhtit rey tí ama ca̱ma̱paksi̱yá̱n ca̱lakmimá̱n y pu̱tahuacani̱t tantum burro. ");
INSERT INTO topNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ixdiscípulos ni̱ sok tama̱kachákxi̱lh tú ixqui̱taxtuni̱t, acxni lacastacuánalh y alh nac akapú̱n tacátzi̱lh la̱ ixta̱cxilhni̱t lhu̱hua tú ixtatzokni̱t ixlacata Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Amá lhu̱hua cristianos tí taquí̱lalh cBetania nac ixchic María ixta̱cxilhni̱t la̱ Jesús ma̱lacastacuáni̱lh Lázaro nac ca̱li̱ní̱n, ixtali̱chihui̱nán tú ixtlahuani̱t Jesús ana ní istzamacán. ");
INSERT INTO topNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Amá cristianos tí ta̱lh talakapa̱xtoka Jesús ixta̱ni̱t porque ixca̱li̱ta̱chihui̱nancani̱t la̱ ixtlahuani̱t ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero amá fariseos ni̱ talakáti̱lh y tzúculh tahuán: ―¡Ca̱cxílhtit chí laktzanka̱ni̱táu! Hua̱k cristianos tali̱pa̱huama̱na namá chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Makapitzi lacchixcuhuí̱n xalac aktum pu̱latama̱n huanicán Grecia na̱ ixtamini̱t talakachixcuhui̱nán nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xlacán tama̱lacatzúhui̱lh Felipe xalac Betsaida y tahuánilh xlacata ixtalakapasputún ixtata̱chihui̱namputún Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe alh huaní Andrés ixcha̱tuycán talákalh Jesús y tahuánilh tú ixtalacasquín amá griegos. ");
INSERT INTO topNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesús ca̱kálhti̱lh: ―Accha̱ni̱t quilhtamacú ama̱ca quili̱cxilhcán para cma̱ccha̱ní quili̱tlihueke aquit Xatalacsacni Chixcú ama̱ca quima̱laksputucán xlacata tla̱n nacca̱ma̱xquí ixli̱latama̱tcán cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Cama ca̱ta̱ma̱lacastucniyá̱n tú cama pa̱xtoka: Ixtalhtzi cuxi acxni tama̱ya̱chá ca̱tiyatni ní ixnacú, acpún y ma̱stá ixtahuácat; y para ni ixnilh ixnacú nicxni ixlhúhualh ixtahuácat. ");
INSERT INTO topNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Amá tí quimakslihuekeputún lakmakán tú li̱pa̱xahuá ca̱quilhtamacú y xli̱ca̱na ama lakma̱xtú ixli̱stacni; pero amá tí lakcatzán akxtakmakán tú kalhí ama makatzanká tú lakcatzán. ");
INSERT INTO topNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pues tí li̱tanú quidiscípulo naquintakoké nac ixlatáma̱t yaj li̱puhuán tú kalhí ca̱quilhtamacú huata quintakoké xlacata aquit nacta̱latamá; y amá tí quimacuaní, Quinti̱cú ama lakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Chí huilhaj huilako̱lh quintapuhuá̱n nac quili̱stacni, ma̱x tla̱n xacuá: “Ta̱ta, caquilakma̱xtu tú cama lakchá̱n”, pero, ¿hua̱na chú nackalhtahuaká si huá cli̱mini̱t ca̱quilhtamacú? ");
INSERT INTO topNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jesús kalhtahuakánilh Dios ixli̱hua̱k ixtapuhuá̱n: ―Ta̱ta, catlahua quilacata tú lacasquina xlacata naca̱najlacán la̱ kalhi̱ya mili̱tlihueke. Nac akapú̱n takaxmáti̱lh jaé tachihuí̱n: ―Aquit cma̱si̱ni̱t nac milacata tú clacasquín, pero cama ma̱si̱pará ma̱s lanca quili̱tlihueke xlacata hua̱k naquintali̱lakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lhu̱hua cristianos tí takáxmatli jaé tachihuí̱n tzúculh tahuán xlacata ixjilini̱t y tunu ixtahuán xlacata cha̱tum ixángelh Dios ixchihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús ca̱huánilh: ―Namá tachihuí̱n huixín ca̱lakmín nakaxpatá̱tit, aquit ni̱tú quili̱macuaní. ");
INSERT INTO topNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Accha̱ni̱t quilhtamacú ama̱ca ca̱ta̱xoko̱nancán cristianos, y tlajaná tí ma̱paksi̱nán ca̱quilhtamacú accha̱nini̱t ixhora ama makatzanká ixli̱ma̱paksí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na̱ accha̱ma quilhtamacú ama̱ca quiakxtokohuacacán nac culu̱s, pero huá jaé culu̱s ama quintali̱lakmín hua̱k cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesús ixli̱chihuinani̱t la̱ ixama̱ca makni̱cán nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Amá cristianos takalasquínilh: ―¿A poco huix pa̱t ni̱ya? Nac ixlibro Moisés cli̱catzini̱táu xlacata Cristo tí ama quinca̱lakma̱xtuyá̱n ni̱cxni ama ní siempre ama latamá, y para huix xli̱ca̱na Xatalacsacni Chixcú ¿hua̱nchi huana pa̱t ni̱ya? O ¿ticu li̱chihui̱námpa̱t? ");
INSERT INTO topNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús cakálhti̱lh: ―Aquit camajcú ca̱li̱lakaskoyuyá̱n quintaxkáket a̱laktzu quilhtamacú. Chí catla̱huántit y calatapu̱lí̱tit pues staranc tu̱tanán. A̱stá̱n ama min ca̱tzisní y tí tla̱huamputún ca̱paklhtu̱tá ni̱ lá ama taka̱sa tijia. ");
INSERT INTO topNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chí kalhi̱yá̱tit taxkáket, cali̱pa̱huántit tí ca̱lakaskoyumá̱n xlacata na̱ nakalhi̱yá̱tit taxkáket y nalakaskoyuyá̱tit cmilatama̱tcán. La̱ chihui̱nanko̱lh Jesús ca̱kxtakyá̱hualh amá cristianos y ca̱tza̱lánilh. ");
INSERT INTO topNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesús ca̱li̱ma̱lacahuá̱ni̱lh lhu̱hua laclanca ixtascújut Dios amá judíos pero xlacán ni̱ ixtaca̱najlani̱t para xlá Cristo ixuani̱t tí ixama ca̱lakmaxtú. ");
INSERT INTO topNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jesús ni̱ istzi̱tzí pues profeta Isaías ixli̱chihui̱nani̱t ixkasatcán jaé cristianos; chuné ixtzokni̱t: Quimpu̱chinacán, ¿ticu taca̱najlani̱t quintachihui̱ncán? Lhu̱hua tascújut ca̱li̱ma̱lacahuá̱ni̱lh Dios, pero ni̱ hua̱k taca̱najlani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Amá cristianos ni̱ hua̱k ixtali̱pa̱huán Jesús y profeta Isaías chuné ixca̱li̱chihui̱nani̱t: ");
INSERT INTO topNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Xlacán la̱ lakatzí̱n ixtalama̱na y snu̱n ixlani̱t ixnacujcán, huá ni̱ ixtali̱lacahua̱nán ixlakastapucán, ni̱tú ixtali̱ca̱najlá ixnacujcán y ni̱ talákalh tí tla̱n ca̱ma̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Profeta Isaías ma̱squi maká̱n ixlatama̱ni̱t ixlacachini̱t la ixama ma̱lacatzuquí lanca ixtapáksi̱t Cristo. ");
INSERT INTO topNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero ni̱ hua̱k ixca̱lakchá̱n jaé tachihuí̱n porque lhu̱hua xli̱ca̱na ixtali̱pa̱huá̱n Jesús hasta makapitzi xalactali̱pa̱u judíos na̱ ixtali̱pa̱huán, pero ni̱ ixtama̱luloka ní tzamacán pues ixtajicuaní fariseos para naca̱tamacxtucán nac sinagogas. ");
INSERT INTO topNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jaé lacchixcuhuí̱n ma̱s ixtalakatí tali̱tanú lactali̱pa̱u ixlacati̱ncan cristianos, y ni̱ ixtama̱tla̱ní Dios caca̱li̱kálhi̱lh lactali̱pa̱u lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús ca̱huánilh hua̱k cristianos: ―Amá cristiano tí quili̱pa̱huán na̱ li̱pa̱huán Quinti̱cú tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","¡Amá chixcú tí quili̱lacahua̱nán la̱ cali̱lacahuá̱nalh ixtalacapa̱stacni Quinti̱cú! ");
INSERT INTO topNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Aquit cmini̱t ca̱li̱ma̱lacahua̱ní cristianos quintaxkáket xlacata tí naquili̱pa̱huán yaj ca̱paklhtu̱tá nalatapu̱lí ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aquit ni̱ cmini̱t ca̱ma̱lacapú cristianos, cmini̱t ca̱lakma̱xtú tí talaktzanka̱ni̱t y amá tí kaxmata quintachihuí̱n y tlahuá tú cli̱ma̱paksi̱nán ni̱tú ama xoko̱nán acxni nalakó ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero amá tí ni̱ tlahuá nac ixlatáma̱t tú cli̱mapaksi̱nán, ¡ixacstu laktzanka̱ni̱t! Quintapáksi̱t ni̱ma̱ cma̱sta̱ni̱t ama tama̱lacapú tú ni̱ kaxmatni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","La̱ta tú cca̱li̱ma̱paksi̱ni̱tán hua̱k Quinti̱cú quili̱ma̱paksi̱ni̱t nacca̱huaniyá̱n; aquit ni̱tú cli̱ma̱huacani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Quinti̱cú kalhí talacapa̱stacni ni̱ma̱ tla̱n tancs li̱cha̱ncán nac akapú̱n y jaé talacapastacni hua̱k cca̱huanini̱tán pues xlá quima̱cxcatzi̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ixtacuhui̱nican ixpa̱scuajcan judíos ixlakcha̱ma amá ca̱tzisní y Jesús na̱ ixcatzí xlacata ixlakcha̱ma quilhtamacú namakxtaka ca̱quilhtamacú y nalakán Ixti̱cú nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tlajaná ixma̱xqui̱ni̱ttá ixtalacpuhuá̱n Judas Iscariote ixkahuasa Simón xlacata namacama̱stá Jesús ixmacancán ixenemigos. ");
INSERT INTO topNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús ixcatzí xlacata hua̱k ixli̱tlihueke ni̱ma̱ ixkalhí Dios ixma̱xqui̱ni̱t porque nac ixpa̱xtú̱n ixtaxtuni̱t y chí ixlakama̱pá Ixti̱cú nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","¡Jesús snu̱n ixca̱lakalhamán ixdiscípulos tí ixca̱lacsacni̱t! Y acxni ixca̱tahualhtatama ca̱ma̱sí̱nilh ixli̱lanca ixtapa̱xquín pues Jesús tá̱yalh, talákxtulh xala ixkalhni ixlháka̱t y li̱tampu̱lakchi̱ca aktum toalla. ");
INSERT INTO topNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A̱stá̱n múju̱lh chúchut nac aktum ti̱na y tzúculh ca̱tu̱cheké ixdiscípulos ixca̱li̱tu̱ma̱sca̱cá amá toalla. ");
INSERT INTO topNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ixama tu̱cheké Pedro xlá ni̱ ma̱tlá̱ni̱lh y huánilh: ―¿Hua̱nchi quila̱tu̱cheke̱ma̱náu si huix Quimpu̱chinacán? ");
INSERT INTO topNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","―Chí huix ni̱ ma̱kachakxi̱ya tú ctlahuani̱t pero nachá̱n quilhtamacú huix pa̱t ma̱kachakxi̱ya ni̱ chu̱ta cca̱li̱scujni̱tán ―kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―Huix ni̱ caquintu̱cheke. Ni̱ cma̱tla̱ní naquili̱scuja ―huánilh Pedro. ―Para ni̱ ctu̱cheke̱yá̱n, ni̱ lá pa̱t li̱tanu̱ya quidiscípulo tí quili̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","―Para chú qui̱taxtú ni̱ huata quintu̱cheke, ¡cacheke̱ko hua̱k quimacni! ");
INSERT INTO topNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","―Tí apenas paxko̱ni̱t huata ixtujún pu̱la xpalakán y tamaclacasquiní catu̱chákalh xlacata maclá̱n nahuán. Huixín hua̱k maclá̱n ma̱squi ccatzí cha̱tum li̱xpalakani̱t tala̱kalhí̱n ixnacú. ");
INSERT INTO topNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús ixcatzí tí ixama macamastá huá ca̱li̱huánilh: “Cha̱tum li̱xpalakani̱t tala̱kalhín ixnacú.” ");
INSERT INTO topNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","La̱ ca̱tu̱cheke̱ko̱lh ixdiscípulos lhaka̱pá xala ixkalhni ixlháka̱t, curucs tahuilapá y ca̱kalasquínilh: ―¿Ma̱kachakxí̱tit tú ixlacata cca̱li̱tu̱cheke̱ni̱tán? ");
INSERT INTO topNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Huixín quila̱ma̱pa̱cuhui̱yá̱u Mimaestrojcán y Mimpu̱chinacán, y xli̱ca̱na tú huaná̱tit porque aquit cma̱ccha̱ní tú quila̱li̱maca̱ná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Para aquit Mimaestrojcán y Mimpu̱chinacán ni̱ clactlancán y cca̱li̱scujni̱tán huixín quidiscípulos, ma̱s ca̱mini̱niyá̱n nalali̱scujá̱tit cha̱tum cha̱túm. ");
INSERT INTO topNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Aquit ma̱s lanca que huixín y cacpuxcuni̱t cca̱li̱scujni̱tán, huixín quila̱makslihuekéu y ma̱s caca̱li̱scújtit xa̱makapitzi cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tla̱n calacpuhuántit tú cama ca̱huaniyá̱n, para cha̱tum patrón ca̱li̱scuja ixtasa̱cua, cha̱tum tasa̱cua ma̱s mini̱ní naca̱li̱scuja xa̱makapitzi. Chuna li̱tum, tí li̱n aktum tachihuí̱n a̱lacatunu, ¿ticu ma̱s tali̱pa̱u, tí li̱n amá tachihuí̱n, o tí má̱sta̱lh amá tachihuí̱n? ");
INSERT INTO topNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Para huixín tlahuayá̱tit tú cca̱li̱ma̱paksi̱ni̱tán ni̱cxni pa̱t akatuyuná̱tit nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Chí camá̱n ca̱huaniyá̱n aktum tachihuí̱n pero ni̱ hua̱k ca̱lakcha̱ná̱n, aquit cca̱lakapasa cha̱tunu mintalacapa̱stacnicán, pero ama kantaxtú nac quilatáma̱t amá tú li̱chihuí̱nalh Dios nac Escrituras: “Tí lakxtum ixquinta̱huayán ama quimacama̱stá.” ");
INSERT INTO topNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jaé tachihuí̱n sok ama kantaxtú huá cca̱li̱huanini̱tán xlacata ni̱ napuhuaná̱tit cca̱kskahuini̱tán y yaj naquila̱li̱pa̱huaná̱u. ¡Huixín ni̱ cama̱palájtit mintapuhua̱ncán quilacata! ");
INSERT INTO topNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","’Chí na̱ cca̱huaniyá̱n amá tí maklhti̱nán nac ixchic tí cama ma̱lakachá naquili̱chihui̱nán, namá cristiano la̱ aquit caquimaklhtí̱nalh, y tí quimaklhti̱nán na̱ la̱ camaklhtí̱nalh Quinti̱cú tí quima̱lakacha̱ni̱t ―huá ca̱huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Acxni tuncán ixnacu Jesús tzúculh li̱puhuán tú ixqui̱taxtuma y chuné ca̱ta̱chihuí̱nalh ixdiscípulos: ―Xli̱ca̱na cli̱puhuán tú cca̱huanimá̱n, cha̱tum la̱ta mili̱hua̱kcán ama quimacama̱stá ixmacancan quienemigos. ");
INSERT INTO topNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hua̱k ixdiscípulos tzúculh tara̱laca̱cxila. Xlacán ni̱ ixtacatzí tí ixli̱chihui̱nama, ");
INSERT INTO topNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","y como nac ixpa̱xtú̱n ixuí amá ixdiscípulo tí snu̱n ixlakalhamán Jesús ixuili̱ni̱t ixakxaka lacatzú nac ixcuxmú̱n; ");
INSERT INTO topNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro tzúculh li̱macahuaní ixmacán cakalasquínilh tí ixli̱chihui̱nama, ");
INSERT INTO topNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","y jaé discípulo tí ixuí ma̱s lacatzú kalasquínilh Jesús: ―Quimpu̱chinacán, ¿ticu li̱chihui̱námpa̱t? ");
INSERT INTO topNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","―Para catzi̱putuna cá̱cxilhti tí cama ma̱xquí jaé actzu simi̱ta ni̱ma̱ cama li̱ma̱cahuí tahuá ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Xlá chékelh actzu simi̱ta li̱ma̱cáhui̱lh tahuá y má̱xqui̱lh Judas Iscariote ixkahuasa Simón; y huata hualh amá simi̱ta tlajaná acmá̱nu̱lh ixtalacapa̱stacni. ―¡Lacapala catlahua tú pa̱t ma̱kantaxti̱ya! ―huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Xa̱makapitzi ixdiscípulos tí takáxmatli ixtachihuí̱n ni̱ tama̱kachákxi̱lh tú ixli̱chihui̱nama, ");
INSERT INTO topNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","y como Judas ixma̱quí tumi̱n talacpúhualh ixli̱ma̱paksi̱ni̱t caalh xokó ixtahuajcán, o huí tú ixama ma̱squihuí cha̱tum pobre. ");
INSERT INTO topNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas lacapala táxtulh, y como punchu̱huá istzisuani̱t ni̱ tacátzi̱lh ní alh. ");
INSERT INTO topNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","La̱ taxtuko̱lh Judas, Jesús ca̱huánilh xa̱makapitzi ixdiscípulos: ―Accha̱ni̱t quilhtamacú Dios ama ma̱si̱pará ixli̱tlihueke nac quimacni; ma̱squi aquit cca̱ma̱si̱nini̱tán ixli̱tlihueke, tzanká naca̱li̱ma̱lacahua̱ni̱yá̱n ixli̱tlihueke ixli̱ma̱paksí̱n nac quimacni xlacata hua̱k nalakachixcuhui̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","¡Aquit na cama kalhí quili̱tlihueke la̱ xlá kalhí! ");
INSERT INTO topNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","¡Koxitaní̱n huixín quincamán! Casi ca̱ta laktzú cca̱ta̱lamá̱n camajá an nac quimpu̱táhui̱lh, y chí nacca̱huaniyá̱n tú cca̱huaniko̱lh chijcú amá judíos: Amá̱n quila̱lacaputzayá̱u y ni̱ amá̱n quila̱taka̱sá̱u pues ni̱ lá pa̱t chipiná̱tit ní cama cha̱n. ");
INSERT INTO topNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Huixín catzi̱yá̱tt la̱ cca̱pa̱xqui̱ni̱tán y chí cca̱ma̱xqui̱yá̱n sa̱sti tapáksi̱t: Caquila̱makslihuekéu y cala̱paxquí̱tit cha̱tum cha̱túm ixli̱hua̱k minacujcán. ");
INSERT INTO topNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Para huixín la̱paxqui̱yá̱tit la̱ cca̱huanini̱tán nac ca̱quilhtamacú pa̱t ca̱li̱kalhi̱caná̱tit xli̱ca̱na quidiscípulos tí quintatakokeni̱t y quintakaxmatni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","―Quimpu̱chinacán, ¿nicu pímpa̱t? ―kalasquínilh Pedro. ―Ana ní cama an huix ni̱ lá pa̱t quintakokeya, pero a̱stá̱n pa̱t quilakchipina ―kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","―Quimpu̱chiná, ¿chí hua̱nchi ni̱ lá ctakokeyá̱n? Hasta quili̱stacni xacmá̱sta̱lh li̱pa̱xáu caj milacata. ");
INSERT INTO topNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","―Pedro, ¿xli̱ca̱na ixma̱sta mili̱stacni quilacata? Ni̱ cca̱najlá porque pi̱huá jaé ca̱tzisní antes nakaxpata natasá tantum pu̱yu huix pa̱t huana maktutu ni̱ quilakapasa tí nakalasquiniyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús ca̱huanipá: ―Ni̱tú cali̱puhuántit nac minacujcán. Ccatzí li̱pa̱huaná̱tit Dios, huá cca̱li̱huaniyá̱n na̱ quila̱li̱pa̱huáu aquit. ");
INSERT INTO topNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Aquit cca̱huaniyá̱n, nac ixpu̱latama̱n Quinti̱cú tahuila̱na lhu̱hua pu̱táhui̱lh. Para ni̱tú ixtahui aquit tancs xacca̱huanín, pero aquit ni̱ cca̱kskahuiyá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Cama ca̱ca̱xtlahuaniyá̱n ní nalatapa̱yá̱tit, y acxni nactlahuakó cama min ca̱tiyayá̱n xlacata acxtum naquila̱ta̱latama̱yá̱u nac quimpu̱táhui̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Huixín catzi̱yá̱tit ana ní cama cha̱n y lakapasá̱tit tijia ní laccha̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás kalhpaktánu̱lh y huánilh: ―Aquín ni̱ ccatzi̱yá̱u ní pa̱t chipina, y para ni̱ ccatzi̱yá̱u ní pímpa̱t, ¿nicu nacli̱lakapasá̱u tijia ní laccha̱ncán? ");
INSERT INTO topNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","―Aquit namá tijia, aquit ckalhí tancs talacapa̱stacni, aquit ckalhí li̱latáma̱t; amá tí ni̱ quilactla̱huán ni̱ lá tancs ama lakchá̱n Quinti̱cú Dios. ");
INSERT INTO topNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Quila̱huaníu, ¿ni̱ lakapasá̱tit Dios? Aquit cpuhuán lakapasá̱tit porque chí acxilhni̱tántit ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","―Quimpu̱chinacán, aquín ni̱ clakapasá̱u. Caquila̱ma̱lakapasáu Minti̱cú y yaj cactica̱kalhputzán ―huánilh Felipe. ");
INSERT INTO topNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","―Felipe, maká̱n cca̱ta̱lapu̱layá̱n y ya̱ lakapasá̱tit Quinti̱cú. ¿Hua̱nchi quihuaniya: “quila̱ma̱lakapasáu Minti̱cú”? ");
INSERT INTO topNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿A poco ni̱ ca̱najlaya para Quinti̱cú lama nac quilatáma̱t, y aquit na̱ clama nac ixlatáma̱t? Quinti̱cú quimaclacasquín nacca̱huaniyá̱n hua̱k ixtapáksi̱t y la̱ta tú cca̱huanini̱tán huá quili̱ma̱paksi̱ni̱t, ni̱ qui̱cstu cta̱clhca̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Para huixín ni̱ ca̱najlayá̱tit acxtum cta̱tla̱huán Quinti̱cú y xlá na̱ acxtum quinta̱tla̱huán siquiera caca̱najlátit ixtascújut ni̱ma̱ quima̱tlahui̱ni̱t nac milatama̱tcán. ");
INSERT INTO topNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Xli̱ca̱na cca̱huaniyá̱n, amá tí quili̱pa̱huán na̱ tlan ama ca̱tlahuá jaé tascújut ni̱ma̱ cca̱tlahuá, y ma̱schá laclanca ama ca̱tlahuá porque aquit cama lakchá̱n Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Y la̱ta tú nali̱maksquiná̱tit quilacata, aquit cama ca̱lacati̱ta̱yayá̱n xlacata naca̱ma̱xqui̱yá̱n tú nasquiná̱tit; Dios ama quili̱pa̱xahuá pues ama acxila la̱ tlahuayá̱tit li̱tlá̱n quilacata. ");
INSERT INTO topNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aquit cca̱ma̱lacnu̱niyá̱n cali̱maksquíntit Dios quilacata tú maclacasquiná̱tit y aquit nacca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Para huixín quila̱pa̱xqui̱yá̱u catlahuátit nac milatama̱tcán tú cca̱li̱ma̱paksi̱ni̱tán, ");
INSERT INTO topNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","y acxni naclakchá̱n Quinti̱cú cama huaní naca̱ma̱lakacha̱niyá̱n cha̱tum Akskalhi̱ná Espíritu. Xlá ama ca̱ma̱lakacha̱niyán Espíritu Santo xlacata naca̱maklhti̱naná̱n y ca̱ma̱xqui̱yá̱n li̱camama. ");
INSERT INTO topNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Xlá ama ma̱stá stalanca talacapa̱stacni ca̱quilhtamacú, pero lhu̱hua cristianos ni̱ ama talakapasa porque ni̱cxni taputzani̱t, ni̱ para ama tali̱lacahua̱nán ixli̱tlihueke. Huixín amá̱n ca̱ta̱latama̱yá̱n porque pa̱t lakapasá̱tit acxni nalakchiná̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Aquit ni̱ camá̱n ca̱kxtakmakaná̱n la̱ li̱ma̱xkan ca̱quilhtamacú, camá̱n ca̱ta̱latama̱yá̱n cani̱cxnihuá; ");
INSERT INTO topNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ma̱squi camajá ní y ni̱tí naquiacxila huixín naquila̱cxilhparayá̱u porque naclatama̱pará; y para aquit naclatama̱pará na̱ chuná huixín nalatama̱parayá̱tit acxni nani̱yá̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Acxni naclatama̱pará ixli̱maktuy pa̱t ma̱kachakxi̱yá̱tit xlacata Dios ni̱ quiakxtakmakani̱t, siempre quinta̱latama̱ni̱t. Huixín na̱ chuná pa̱t latapa̱yá̱tit nac quili̱stacni, y quili̱stacni ama ca̱ta̱latama̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Amá cristiano tí quilakalhamán tlahuá tú cli̱ma̱paksi̱nán, y tí kaxmata tú cli̱ma̱paksi̱nán Quinti̱cú ama pa̱xquí, y aquit cama ma̱si̱ní ixnacú la̱ tancs nalatamá y ni̱cxni cama li̱makxtaka ―ca̱huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Cha̱tum ixdiscípulo Jesús na̱ ixuanicán Judas, ni̱ huá tí macamá̱sta̱lh; xlá huánilh: ―Quimpu̱chinacán, ¿hua̱na huata aquín ama quila̱tasi̱niyá̱u? ¿Hua̱nchi ni̱ pa̱t ca̱tasi̱niya hua̱k cristianos? ");
INSERT INTO topNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús ca̱kálhti̱lh: ―Aquit cama ca̱tasi̱ní hua̱k cristianos tí quintapa̱xquí y tatlahuá quintapáksi̱t. Tí ma̱kantaxtí jaé tachihuí̱n Quinti̱cú ama pa̱xquí y quincha̱tuycán camá̱n lakminá̱u y acxtum cta̱latamayá̱u. ");
INSERT INTO topNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Amá tí ni̱ tlahuá tú cli̱ma̱paksi̱nán ni̱ quimpa̱xquí; jaé tú cca̱li̱ma̱paksi̱má̱n chí ni̱ aquit clacsacxtuni̱t, Quinti̱cú quima̱cxcatzí̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’La̱ta ctitzúculh ca̱ta̱latapuli̱yá̱n cca̱huanini̱tán jaé tachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amá quilhtamacú acxni Quinti̱cú naca̱ma̱lakacha̱niyá̱n Espíritu Santo tí naca̱ma̱xqui̱yá̱n li̱camama y naca̱maktakalhá̱n, ama ca̱ma̱lacapa̱stacayá̱n y ca̱ma̱si̱niyá̱n para yaj aksaná̱tit la̱ta tú cca̱li̱ma̱paksi̱ni̱tán. ");
INSERT INTO topNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Aquit ni̱ lanca tú cca̱ta̱makxtakmá̱n huata quintalacapa̱stacni cca̱ma̱xqui̱yá̱n, pero ma̱s ama ca̱makapa̱xahuayá̱n pues nac ca̱quilhtamacú ni̱tí ma̱ccha̱ní la̱ aquit cmakapa̱xahuani̱tán. ");
INSERT INTO topNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ni̱tú ca̱li̱puhuántit, ni̱ para calakaputzátit pues aquit cca̱huanini̱tán xlacata cama ca̱makxtaká̱n, pero cama ca̱lakmimparayá̱n. Para huixín xli̱ca̱na quila̱pa̱xqui̱yá̱u ca̱li̱pa̱xahuátit la̱ clakama Quinti̱cú nac akapú̱n y Quinti̱cú ma̱s lanca que aquit. ");
INSERT INTO topNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Aquit cca̱huanini̱tán tú amaj quinqui̱taxtuní xlacata acxni lihua nalakchá̱n la̱tiyá naquila̱li̱pa̱huaná̱u ni̱ napuhuaná̱tit cca̱kskahuini̱tán. ");
INSERT INTO topNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ca̱ta tziná cca̱ta̱chihui̱namá̱n porque amá tí ma̱stá li̱xcájnit tapuhuá̱n ca̱quilhtamacú accha̱nima hora ama quili̱kama̱nán. Xlá ni̱ lá quimakatlajá para ni̱ cma̱tla̱ní, ");
INSERT INTO topNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","pero cama li̱tamakxtaka xlacata nacma̱kantaxtí tú laclhca̱ni̱t Quinti̱cú, y xa̱huá chuná cristianos xala ca̱quilhtamacú nata̱cxila la̱ clakalhamán y ctlahuá tú lacasquín ―Jesús a̱stá̱n ca̱li̱ma̱páksi̱lh ixdiscípulos catatá̱yalh y catatakókelh. ");
INSERT INTO topNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A̱stá̱n Jesús ca̱huánilh: ―Aquit cta̱talacastuca pu̱kalhtum uva, y Quinti̱cú cta̱ma̱lacastuca xlá ixquinchani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Y quiakán cca̱ta̱ma̱lacastucá̱n tí tlahuayá̱tit quintapáksi̱t. Tí kaxmata quintachihuí̱n xlá ama podartlahuá xlacata nama̱stá ma̱s ixtahuácat, pero tí ni̱ ma̱stá ixtahuácat ama ca̱ctí namá quiakán. ");
INSERT INTO topNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","’Quinticú ca̱li̱podartlahuani̱tán quintachihuí̱n pues aquit cca̱ma̱si̱nini̱tán la̱ nama̱sta̱yá̱tit mintahuacatcán. ");
INSERT INTO topNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Kantum ixakán uva ni̱ ma̱stá ixtahuácat para ni̱ quilhtá nac xatzé pu̱kalhtum uva y huixín para na̱ ni̱ taquilhtayá̱tit nac quintachihuí̱n ni̱ pa̱t ma̱sta̱yá̱tit mintahuacatcán. Siempre cali̱tatlihuéklhtit quilacata y aquit nacca̱ma̱tlihueklhá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Porque aquit cli̱tanú pu̱kalhtum uva y huixín quidiscípulos cca̱li̱ma̱nu̱yá̱n quiakán. Amá quiakán tí quili̱taquilhuacá xlacata nacma̱ta̱yaní y nacma̱tlihueklha ama ma̱stá lhu̱hua ixtahuácat; pero amá tí ni̱ quili̱taquilhuacá ni̱cxni ama ma̱stá ixtahuácat, ");
INSERT INTO topNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","y como quilakmakán y ni̱ lacasquín quili̱tlihueke ama qui̱taxtuní la̱ kantum ixakán uva ni̱ma̱ scaca, ¡ca̱cti̱cán y ma̱pu̱cán nac lhcúya̱t! ");
INSERT INTO topNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Huixín para tlahuayá̱tit tú cca̱li̱ma̱paksi̱yá̱n y ni̱ quila̱tamacxtuyá̱u nac minacujcán, la̱ta tú namaksquiná̱tit Quinti̱cú ama ca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","’Tí xli̱ca̱na li̱tanú quidiscípulo na̱ quintakoké cani̱cxnihuá ama ma̱stá lhu̱hua ixtahuácat para ca̱tlahuá li̱tlá̱n, y Quinti̱cú ama quili̱pa̱xahuá. ");
INSERT INTO topNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","’Cali̱latapá̱tit quintachihuí̱n xlacata cati̱huá nacatzí lakapasá̱tit Dios pues aquit cca̱lakalhamaná̱n xli̱hua̱k quinacú na̱ chuná la̱ Quinti̱cú quilakalhamán. ");
INSERT INTO topNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Para huixín tlahuayá̱tit tú cca̱li̱ma̱paksi̱yá̱n, ma̱si̱yá̱tit la̱ quila̱lakalhamaná̱u na̱ chuná la̱ acxni aquit ctlahuá tú quili̱ma̱paksi̱ni̱t Quinti̱cú, cma̱sí xli̱ca̱na clakalhamán. ");
INSERT INTO topNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Aquit cca̱ma̱camajá̱n huá cca̱li̱huanín jaé tachihuí̱n. ¡Ni̱tú cali̱púhualh minacujcán capaxahuátit! ");
INSERT INTO topNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Aquit clacasquín cala̱pa̱xquí̱tit cha̱tum cha̱túm la̱ aquit cca̱pa̱xqui̱ni̱tán. Amá tí huan ca̱pa̱xquí ixamigos y ni̱tú tlahuá ixlacatacán acxni talaktzanka̱nit, ¡akskahuinán! ");
INSERT INTO topNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","14","Aquit camá̱n ca̱ma̱si̱niyá̱n la̱ cca̱pa̱xqui̱yá̱n y camá̱n ca̱li̱maca̱ná̱n huixín xli̱ca̱na quiamigos y mini̱ní nacxoko̱nán milacatacán para tlahuayá̱tit tú cca̱li̱ma̱paksi̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aquit ni̱ cca̱li̱maca̱ná̱n tasa̱cua porque cha̱tum patrón ni̱ huaní ixtasa̱cua tú ama tlahuá huata ma̱paksí; chí cca̱li̱maca̱ná̱n quiamigos porque aquit cca̱ta̱catzi̱ni̱tán tú quima̱cxcatzí̱ni̱lh Quinti̱cú, ¡ni̱tú ccama̱tze̱knini̱tán! ");
INSERT INTO topNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Huixín ni̱ quila̱lacsacni̱táu, aquit cca̱lacsacni naquila̱takokeyá̱u porque clacasquín nama̱sta̱yá̱tit lhu̱hua mintahuacatcán, y para ni̱ aktzanka̱yá̱tit la̱ta tú nali̱maksquiná̱tit Quinti̱cú quilacata xlá ama ca̱ma̱xqui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Aquit ni̱ clacasquín cala̱si̱tzi̱nítit, ¡siempre cala̱pa̱xquí̱tit! ");
INSERT INTO topNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Lhu̱hua cristianos xala ca̱quilhtamacú quintalakmakán y huixín ma̱schá ama ca̱lakmakaná̱n porque aquit cca̱tamacxtún ca̱quilhtamacú ní ixlaktzanka̱pa̱nántit. ");
INSERT INTO topNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Para huixín ixca̱makslihuekétit ixkasatcán cati̱huá ixca̱lakalhamán, pero como lakmakaná̱tit tú tatlahuá ca̱si̱tzi̱nicaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chí ca̱ksántit tú cca̱huanín chijcú: cha̱tum tasa̱cua ni̱ lá ta̱talacastuca ixpatrón, xlá siempre liactá ixtascújut. Aquit cta̱talacastuca cha̱tum patrón y quisi̱tzi̱nicán y quimpu̱tlakacán, entonces, ¿puhuaná̱tit quintasa̱cua ni̱ naca̱si̱tzi̱nicán y naca̱pu̱tlakacán? Pero ni̱ cli̱puhuán porque lhu̱hua takaxmatni̱t quintachihuí̱n y na̱ chuná huixín lhu̱hua ama takaxmata mintachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","’Amá cristianos tí ama ca̱si̱tzi̱niyá̱n caj quilacata talaktzanka̱ni̱t pues xlacán ni̱ talakapasa Dios tí quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Para aquit ni̱ xactímilh ca̱ma̱kalhchihui̱ní ca̱quilhtamacú ni̱tí tú ixtica̱li̱yá̱hualh tú ni̱ tla̱n tatlahuani̱t. Pero chí ni̱ lá ama ta̱kskahuinán y tataquilhtla̱ní porque cmini̱t ca̱ma̱lacahua̱ní; ");
INSERT INTO topNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","y amá tí quisi̱tzi̱ní na̱ si̱tzi̱ní Quinti̱cú pues hua̱k quintascújut ni̱ma̱ cca̱li̱ma̱lacahuá̱ni̱lh tama̱luloka tí quima̱tlahui̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Pero xlacán ma̱squi tá̱cxilhni̱t ni̱ taca̱nájlalh huá tali̱kalhí lhu̱hua mas tala̱kalhí̱n. ¡Talakmákalh Quinti̱cú y aquit na̱ quintalakmákalh! ");
INSERT INTO topNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","’Xlacán ni̱ tacatzí para huá tama̱kantáxti̱lh amá tú ixtali̱chihui̱nani̱t profetas quilacata, lacatum nac Escrituras huan: “Ni̱ tacátzi̱lh tú xlacata quintali̱si̱tzí̱nilh.” ");
INSERT INTO topNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Yaj maka̱s tzanká Quinti̱cú ama ca̱ma̱lakacha̱niyá̱n amá Espíritu Santo tí ama ca̱maktakalhá̱n y ca̱ma̱xqui̱yá̱n li̱camama. Acxni naca̱lakchiná̱n ama ca̱ma̱xqui̱yá̱n stalanca quintalacapa̱stacni y ama ca̱li̱ta̱chihui̱naná̱n quilacata. ");
INSERT INTO topNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Huixín na̱ amá̱n quila̱li̱chihui̱naná̱u ixlacati̱ncan hua̱k cristianos xala ca̱quilhtamacú porque huixín quila̱ta̱latapu̱li̱ni̱táu la̱ta ctima̱lacatzúqui̱lh quintascújut y catzi̱yá̱tit tú cli̱mini̱t ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nac ixnacú Jesús táxtulh ma̱s tachihuí̱n y ca̱huanipá: ―Aquit cca̱huanín jaé takalhchihuí̱n xlacata ni̱ naca̱maka̱klhayá̱n tú ama ca̱lakcha̱ná̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pues pa̱t ca̱tamacxtucaná̱tit nac sinagogas y hasta ama cha̱n quilhtamacú pa̱t ca̱maknicaná̱tit caj quilacata, y tí naca̱makni̱yá̱n ama puhuán tlahuanima aktum li̱tlá̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Xlacán ama ca̱makni̱yá̱n porque ni̱ talakapasni̱t Dios ni̱ para aquit quintalakapasni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","’Acxni nalakchipiná̱tit jaé ni̱ tlan quilhtamacú ca̱ksántit xlacata aquit cca̱ma̱cxcatzi̱ní̱n tú ixlakaya̱nántit. Ni̱tú xacca̱huanini̱tán la̱ta cca̱ta̱lapu̱layá̱n porque xaccatzí cca̱ta̱lamá̱n y cca̱maktakalhá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero chí clakamajá ta̱latamá Quinti̱cú tí quima̱lakacha̱ni̱t; huixín quila̱kalasquiníu nicu cama, pero ni̱ quila̱kalasquiníu tucu xlacata cli̱ama. ");
INSERT INTO topNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chí cca̱huanini̱tán tú ixcatzi̱putuná̱tit y minacujcán snu̱n talakaputzani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","’Ixli̱hua̱k quinacú cca̱huaniyá̱n para aquit ni̱ can nac akapú̱n amá Espíritu tí naca̱ma̱xqui̱yá̱n li̱camama ni̱ ama ca̱lakminá̱n, huá li̱tamaclacasquiní nacca̱kxtakmakaná̱n xlacata nacca̱ma̱lakacha̱niyá̱n Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Acxni nachín ca̱quilhtamacú ama ca̱ma̱cxcatzi̱ni̱nán tí kalhí tala̱kalhí̱n, ama ma̱cxcatzi̱ni̱nán la̱ Dios hua̱k ca̱ya̱huaputún ixtijia, na̱ ama ma̱cxcatzi̱ni̱nán tí ama taxoko̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ama ma̱sí tí ama aksti̱lí̱n ixtala̱kalhí̱n para ni̱ quili̱pa̱huani̱t, ");
INSERT INTO topNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ama ca̱ma̱si̱ní cristianos tí kalhí tijia xlacata tancs natalakchá̱n Dios pues aquit clakama Quinti̱cú y huá ama scuja quimpú̱xoko, ");
INSERT INTO topNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","y ama ma̱sí tí ama xoko̱nán porque amá tí tamakslihueké tlajaná li̱puaktum amaca ca̱ma̱kxtakajni̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Huí lhu̱hua ma̱s tú cca̱huaniputuná̱n pero chí ni̱ ixma̱kachakxí̱tit hua̱k quintachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mejor cakalhí̱tit acxni naca̱lakchiná̱n amá Espíritu tí ama ca̱ma̱camajá̱n y ama ca̱ma̱xqui̱yá̱n tancs talacapastacni. Xlá ni̱ ama ca̱kskahuiyá̱n y ama ca̱ma̱cxcatzi̱ni̱yá̱n hua̱k tú ama lá a̱stá̱n porque huata ama ca̱huaniyá̱n tú kaxmatni̱t nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jaé Espíritu ama quima̱tla̱ní cmilacati̱ncán y snu̱n cama li̱pa̱xahuá pues ama ca̱ma̱si̱niyá̱n la̱ ixli̱lanca ckalhí quili̱ma̱paksí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quinti̱cú quima̱xqui̱ni̱t ixli̱tlihueke y acxtum kalhi̱yá̱u quili̱ma̱paksi̱ncán huá cca̱li̱huaniyá̱n cama li̱pa̱xahuá pues hua̱k aquit cama ma̱xquí quintalacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yaj maka̱s cama an y ni̱ ama quila̱cxilá̱u, pero a̱stá̱n ama quila̱cxilhparayá̱u pues antes naclakán Quinti̱cú cama ca̱ta̱chihui̱naná̱n ―huanko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ixdiscípulos ni tama̱kchákxi̱lh jaé tachihuí̱n y tzúculh tara̱kalasquiní: ―¿Hua̱nchi huan ama an y ni̱ ama acxilá̱u, y a̱stá̱n ama acxilhparayá̱u pues ama lakán Ixti̱cú? ");
INSERT INTO topNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tucu quinca̱huaniputuná̱n quimaestrojcán? ¿Niculá ama lakán Ixti̱cú? ");
INSERT INTO topNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús ma̱kachákxi̱lh xlacata ixdiscípulos huí tú ni̱ ixtama̱kachakxini̱t huá ca̱li̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","―Huixín catzi̱putuná̱tit la̱ qui̱taxtú tú cca̱huanín pues ixli̱hua̱k quinacú cca̱ma̱cxcatzi̱ni̱yá̱n: Huixín pa̱t lakaputzayá̱tit y tasayá̱tit, y xa̱makapitzi cristianos ama tali̱pa̱xahuá tú cama pa̱xtoka. Ma̱squi ca̱kxtakajnántit ni̱tú cali̱puhuántit porque acxni naquila̱cxilhparayá̱u ¡cama ca̱makapaxahuayá̱n la̱ ni̱cxni ixpa̱xahuani̱tántit! ");
INSERT INTO topNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Cha̱tum puscat snu̱n lakaputzá y akxtakajnán acxni ama lakahuán itskata, pero la̱ taxtunikó aktzonksuá tú akxtakájnalh y ma̱s pa̱xahuá porque catzí xlacata ma̱lakahuáni̱lh cha̱tum skata ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chí huixín lakaputzayá̱tit, pero acxni naquila̱cxilhparayá̱u li̱cuánit pa̱t pa̱xahuayá̱tit y ni̱ lá tí ama ca̱maklhti̱yá̱n mintapa̱xahua̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Acxni nachá̱n jaé quilhtamacú nacta̱latamá Quinti̱cú nac akapún huixín yaj tú ama quila̱maksquiná̱u juú ca̱quilhtamacú, pero la̱ta tú nali̱maksquiná̱tit quilacata Quinti̱cú xlá ama ca̱ma̱xqui̱yá̱n. Aquit cama ca̱lacati̱ta̱yayá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta chí ni̱ li̱cxilhni̱tántit Quinti̱cú para tú naca̱ma̱xqui̱yá̱n quilacata. ¡Cali̱cxílhtit! Camaksquíntit Quinti̱cú quilacata y naca̱ma̱xqui̱yá̱n y amá̱n quila̱li̱pa̱xahuayá̱u la̱ quila̱li̱pa̱huaná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ni̱ ccatzí para ma̱kachakxini̱tántit tú̱ cca̱huanini̱tán pues cca̱ta̱ma̱lacastucnini̱tán tú lakapasá̱tit, pero accha̱ma quilhtamacú tancs nacca̱li̱ta̱chihui̱naná̱n Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","’Aquit cca̱ma̱lacnu̱niyá̱n para tú li̱maksquiná̱tit Quinti̱cú quilacata ama ca̱ma̱xqui̱yá̱n, ni̱ ama takalhpu̱spita pues xlá ca̱lakapasa tí quintali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Quinti̱cú ca̱lakalhamaná̱n y hua̱k ama ca̱ma̱xqui̱yá̱n porque huixín quila̱lakalhamani̱táu y ca̱najlani̱tántit xlá quima̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Aquit ctá̱ctalh nac akapú̱n y cmilh ca̱quilhtamacú, chí cama akxtakmakán ca̱quilhtamacú y cama̱pá nac akapú̱n ní huí Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ixdiscípulos tahuánilh: ―Chí stalanca cma̱kachakxi̱ni̱táu mintachihuí̱n porque tancs quila̱ta̱chihui̱náu, ");
INSERT INTO topNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","y ccatzi̱ni̱táu xlacata huix hua̱k ca̱lakapasa ixtapuhua̱ncan cristianos y ni̱ maclacasquina tí nahuaniyá̱n tú lacpuhuán, huá cli̱ca̱najlayá̱u Dios ma̱lakacha̱ni̱tán. ");
INSERT INTO topNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","―¡Hasta apenas ca̱najlayátit Dios quima̱lakacha̱ni̱t! ");
INSERT INTO topNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Talacatzuhui̱ma quilhtamacú casi accha̱ni̱t hora huixín pa̱t ta̱kahuani̱yá̱tit y cha̱tum cha̱túm ama chipá ixtijia, y aquit ama quila̱kxtakmakaná̱u, ma̱squi aquit ni̱cxni qui̱cstu ctamakxtaka pues Quinti̱cú quinta̱tla̱huán. ");
INSERT INTO topNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Aquit cca̱huanín jaé takalhchihuí̱n xlacata ni̱tú nali̱puhuaná̱tit y natiyayá̱tit li̱camama quilacata. Para quila̱li̱pa̱huaná̱u pues nac ca̱quilhtamacú pa̱t akxtakajnaná̱tit y huí tí ama ca̱ma̱tlahui̱putuná̱n tala̱kalhí̱n, pero ni̱tú capuhuántit, aquit cmakatlajani̱t tú ma̱tlahui̱nán tala̱kalhí̱n juú ca̱quilhtamacú y nacca̱ma̱xqui̱yá̱n quili̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","La̱ ca̱ta̱chihui̱nanko̱lh ixdiscípulos láca̱lh nac akapú̱n y chuné kalhtahuakánilh Dios: ―Ta̱ta, aquit Minkahuasa; accha̱ni̱t quilhtamacú caca̱ma̱si̱ni cristianos la̱ ckalhí quili̱tlihueke xlacata hua̱k natalakachixcuhui̱yá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Huix quima̱xqui li̱tlihueke nacca̱ma̱xquí hua̱k cristianos tí quintali̱pa̱huán ixli̱latama̱tcán tú natali̱pa̱xahuá nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amá tí lacasquín nacma̱xquí ixlatáma̱t huata maclacasquín cali̱pa̱huán huix Dios xastacnán tí ma̱paksi̱nán cani̱cxnihuá y caquili̱pá̱hualh aquit Jesucristo tí ma̱lakacha naca̱lakma̱xtú ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Aquit lanca ctlahuani̱tán ixlacati̱ncan huak cristianos pues cca̱li̱ma̱lacahua̱ni̱ni̱t quintascújut ni̱ma̱ quili̱ma̱paksi. ");
INSERT INTO topNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ta̱ta, clacasquín xaccha̱nchitá nac mimpa̱xtú̱n xlacata naclakaskoy cani̱cxnihuá pues caj laktzú cmakxtakni̱t quimpu̱táhui̱lh ni̱ma̱ quima̱xqui̱ni̱ta la̱ta ya̱ para ixlacatzucú ca̱quilhtamacú. ¡Caquinkalhi a̱laktzú! ");
INSERT INTO topNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Aquit cca̱ma̱si̱nini̱t jaé cristianos la̱ kalhi̱ya mintalacapa̱stacni; xlacán ixtalaktzanka̱ni̱t ca̱quilhtamacú, pero huix ca̱lácsacti y quimacama̱xqui xlacata nacca̱maktakalhniyá̱n, y como huix ixpu̱chinacán takaxmatni̱t tú cca̱li̱ma̱páksi̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pues xlacán taca̱najlani̱t xlacata hua̱k quili̱tlihueke y tú̱ cli̱ma̱paksi̱nán huix quima̱xqui̱ni̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Aquit cca̱huanini̱t hua̱k tú quili̱ma̱paksi y taca̱nájlalh quinta̱chihuín y tacatzí xlacata nac akapú̱n cmini̱tanchá y huix quima̱lakacha̱ni̱ta ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amá tí ni̱ taca̱najlá quintachihuí̱n ni̱ cca̱li̱kalhtahuakaniyá̱n, aquit cmaksquiná̱n ixlacatacán jaé cristianos tí tali̱maca̱ná̱n huix Ixti̱cucán. ");
INSERT INTO topNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Xlacán quintalákmilh porque huix quimacama̱xqui, chí aquit cca̱ma̱paksí, pues la̱ta tú ma̱paksi̱ya na̱ tla̱n cma̱paksí, aquín acxtum ma̱paksi̱naná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ta̱ta, yaj maka̱s cama lakana̱chá̱n nac akapú̱n y xlacán ama tatamakxtaka ca̱quilhtamacú. Xli̱hua̱k quinacú cmaksquiná̱n caca̱maktákalhti y caca̱ma̱xqui li̱camama jaé cristianos tí quimacama̱xqui y quintali̱pahuani̱t xlacata ni̱ natalaktzanká. ¡Clacasquín lakxtum catatla̱hualh na̱ chuná la̱ aquín lakxtum tla̱huaná̱u! ");
INSERT INTO topNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jaé lacchixcuhuí̱n tí quima̱maktakalhni ni̱ talaktzánka̱lh la̱ta cca̱ta̱latapú̱li̱lh y huata laktzánkalh amá tí ixli̱lhca̱ni̱ttá namakatlajá tlajaná. Escrituras chú li̱chihui̱nán: “¡Cha̱tum ixama laktzanká!” ");
INSERT INTO topNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Aquit cca̱huanini̱t jaé takalhchihuí̱n xlacata naquintata̱paxahuá la clakama̱chá̱n nac akapún, pero ¡la̱mpara ni̱ tapa̱xahuá la̱ clakama̱chá̱n! ");
INSERT INTO topNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cca̱ma̱xqui̱ni̱t hua̱k mintapáksi̱t y takaxmatni̱t, huá ca̱li̱si̱tzi̱nicán ca̱quilhtamacú porque xlacán la̱ yaj xala ca̱quilhtamacú na̱ chuná la̱ aquit ni̱ xala ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ta̱ta, ni̱ cmaksquiná̱n caca̱tamacxtu ca̱quilhtamacú huata clacasquín caca̱maktákalhti ni̱tí caca̱ma̱tláhui̱lh tala̱kalhí̱n, ");
INSERT INTO topNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","pues xlacán talakmakani̱t tala̱kalhí̱n ni̱ma̱ ixca̱ma̱laktzanké na̱ chuná la̱ aquit clakmakani̱t tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nac ixnacujcán cama̱nu stalanca mintalacapa̱stacni xlacata natakalhí li̱camama pues tí ma̱quí mintachihuí̱n nac ixnacú ni̱cxni ama laktzanká. ");
INSERT INTO topNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","19","Huix quima̱lakacha ca̱quilhtamacú y como chí camajá aquit cama ca̱makxtaka quilakapú̱xoko xlacata natali̱latamá tú cca̱ma̱si̱nini̱t y nataputzá stalanca talacapa̱stacni ni̱ma̱ huix kalhi̱ya na̱ chuna la̱ aquit cma̱kantaxti̱ni̱t. ¡Clacasquín lakxtum quintata̱tlá̱hualh! ");
INSERT INTO topNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Chí cca̱li̱kalhtahuakaniyá̱n amá cristianos tí naquintali̱pa̱huán a̱stá̱n ca̱quilhtamacú acxni natakaxmata la̱ naquintali̱chihui̱nán jaé quidiscípulos tí cama ca̱ma̱lakachá. ");
INSERT INTO topNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ta̱ta, cmaksquiná̱n tí naquintali̱pa̱huán lakxtum catahuíli̱lh ixtalacapa̱stacnicán xlacata pu̱tum natahuán y lakxtum naquinca̱ta̱tla̱huaná̱n na̱ chuná la̱ aquín lakxtum ma̱paksi̱naná̱u; para xlacán ni̱cxni tata̱kahuaní tí naca̱cxila ca̱quilhtamacú ama catzí huix quima̱lakachá y ni̱ chu̱ta cma̱lacatzuqui̱ni̱t quintapáksi̱t. ");
INSERT INTO topNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Aquit cca̱ma̱xqui̱ni̱t stalanca quintalacapa̱stacni la̱ lakxtum natalatamá na̱ chuná la̱ aquín aktum huili̱ni̱táu quintalacapa̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Aquín lakxtum tla̱huanáu, y para xlacán na̱ lakxtum quintata̱tla̱huán cati̱huá xala ca̱quilhtamacú ama tacatzí xlacata huix quima̱lakacha ca̱quilhtamacú y ca̱lakalhamani̱ta na̱ chuná la̱ aquit quilakalhámanti. ");
INSERT INTO topNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ta̱ta, clacasquín caca̱ma̱xqui li̱tlá̱n jaé tí quimacama̱xqui̱ni̱ta y ca̱lacsacni̱ta xlacata lakxtum quintata̱latáma̱lh ní cama latamá xlacata nata̱cxila la̱ ckalhí quili̱ma̱paksí̱n nac mimpa̱xtú̱n. ¡Xlacán ni̱ tacatzí para ckalhí quimpu̱táhui̱lh nac mimpa̱xtú̱n la̱ta ni̱ para tú ixanán ca̱quilhtamacú! ");
INSERT INTO topNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","’Ta̱ta, cristianos ni̱ talakapasá̱n, pero aquit clakapasá̱n y cama ca̱li̱pa̱xahuá cristianos tí naquintakoké nac ixlatama̱tcán para taca̱najlá huix quima̱lakachani̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Aquit cca̱ma̱si̱ni̱t lacstalanca mintalacapa̱stacni y lhu̱hua tú camajcú ca̱ma̱catzi̱ní xlacata natacatzí huix ca̱lakalhamani̱ta na̱ chuná la̱ aquit cca̱lakalhamani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús la̱ cahuaniko̱lh jaé takalhchihuí̱n ca̱ta̱taxtuchá ixdiscípulos nac aktum pu̱xka huanicán Cedrón lacatzú ixuí aktum ixpu̱chancan quihui; xlá aná ca̱ta̱tánu̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas tí ixama macamastá ixcatzí jaé ixpu̱jaxni Jesús porque maklhu̱hua aná ixca̱ta̱tamakstokni̱t ixdiscípulos. ");
INSERT INTO topNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ni̱ para ixli̱maka̱s Judas pu̱tum ca̱tá̱chilh soldados y policías ni̱ma̱ ixtama̱lakacha̱ni̱t xanapuxcun curas y fariseos hua̱k ixtali̱mín tú ixtali̱lakaskoy ca̱tzisní y na̱ chuná ixli̱makni̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesús ni̱ ixjicuaní tú ixlakcha̱ma y antes natalakchín alh ca̱lakapa̱xtoka y ca̱huánilh: ―¿Ticu putzayá̱tit? ");
INSERT INTO topNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","―Jesús xalac Nazaret ―takálhti̱lh. ―Aquit namá. Acxni ca̱huánilh: “Aquit namá”, xlacán tatatampú̱xtulh y tatama̱chá ca̱tiyatni. Judas hua̱k ixca̱cxilhma tú ixqui̱taxtuma. ");
INSERT INTO topNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Entonces Jesús ca̱kalasquinipá: ―¿Pues ticu putzayá̱tit? ―Jesús xalac Nazaret. ");
INSERT INTO topNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","―Cca̱huaniná aquit namá chixcú y para aquit quila̱putzayá̱u caca̱li̱makxtáktit cata̱lh jaé lacchixcuhuí̱n tí quintata̱lapu̱lá. ");
INSERT INTO topNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chuná jaé kantáxtulh ixtachihuí̱n Jesús ni̱ma̱ huá acxni kalhtahuakánilh Ixti̱cú: “Aquit hua̱k cca̱maktakalhni̱t y ni̱ cha̱tum laktzánka̱lh.” ");
INSERT INTO topNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pedro maklhti̱nampútulh Jesús y kalhpú̱xtulh ixma̱chi̱ta, caj maktum ca̱ctí̱nilh ixtaké̱n cha̱tum huanicán Malco. Jaé chixcú ixtasa̱cua ixuani̱t xapuxcu cura. ");
INSERT INTO topNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","―¡Cama̱kalhpu̱nu mima̱chi̱ta Pedro! ―ma̱ktási̱lh Jesús―. ¿A poco puhuana ni̱ cama ta̱yaní nacmaklhti̱nán jaé ta̱kxtakajni ni̱ma̱ lacasquín Quinti̱cú nacmacpa̱tí? ");
INSERT INTO topNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Makapitzi lactali̱pa̱u soldados tamaktá̱yalh amá policías tí ixtama̱lakacha̱ni̱t xanapuxcun curas y táchi̱lh Jesús la̱ cha̱tum ni̱ tla̱n chixcú. ");
INSERT INTO topNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","A̱stá̱n táli̱lh y talí̱cha̱lh nac ixchic Anás, jaé chixcú ixpuhuitiko̱lú ixuani̱t Caifás tí ixma̱paksi̱nán amá ca̱ta pues xapuxcu cura ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Y pi̱huá tí ixca̱huanini̱t ixcompañeros jaé consejo: “Ma̱s quinca̱macuaniyá̱n cani̱lh cha̱tum chixcú y ni̱ hua̱k quimpu̱latama̱ncán calaktzánka̱lh.” ");
INSERT INTO topNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro ca̱takókelh amá tí tali̱lh Jesús, ixta̱án xacha̱tum ixdiscípulo Jesús tí ixta̱ra̱lakapasa xapuxcu cura, li̱makxtakca catánu̱lh ní li̱cha̱nca Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero ixli̱puntzú ta̱chihuí̱nalh amá squití tí ixyá nac puhui̱lhta cali̱mákxtakli na̱ catánu̱lh Pedro pues como xlá ni̱ ixlakapascán ixtamakxtakni̱t nac quilhtí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Amá pusca̱t huata ácxilhli kalasquínilh: ―¿Huix la̱mpara na̱ ixdiscípulo namá chixcú tí li̱chinca? ―Tó̱, aquit ni̱ ixdiscípulo ―kalhtí̱nalh Pedro. ");
INSERT INTO topNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jaé quilhtamacú ixlonknán ca̱tzisní huá xlacata policías y hua̱k tasa̱cua tí ixta̱scuja ixtama̱kstokni̱t lhcúya̱t ixtaskoma̱na y Pedro na̱ aná tamákxtakli y tzúculh skon. ");
INSERT INTO topNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nac ixpu̱lacni ákxtaka ní ixtanu̱ma Jesús amá xapuxcu cura tzúculh ma̱kalhapalí Jesús. Kalasquínilh tú ixca̱ta̱tlahuá ixdiscípulos y tú ixca̱ma̱si̱ní cristianos. ");
INSERT INTO topNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Xlá kálhti̱lh: ―La̱ta tú cca̱ma̱si̱nini̱t cristianos ni̱ tzek cca̱huani̱t pues cchihui̱nani̱t nac sinagogas ní tzamacán y nac pu̱siculan ní tatamakstoka hua̱k xalactali̱pa̱u judíos. ");
INSERT INTO topNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Xlacán tacatzí tú cli̱chihui̱nani̱t. ¿Hua̱nchi quinkalasquiniya aquit? ¿Hua̱nchi ni̱ cakalasquiniya tí quintakaxmatni̱t tú cli̱chihui̱nani̱t? ");
INSERT INTO topNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Cha̱tum policía acxni káxmatli la̱ kalhtí̱nalh ¡lass lacatláhualh! Y huánilh: ―¡Xlacata xa̱maktum yaj chú nakalhti̱ya cha̱tum xapuxcu cura! ");
INSERT INTO topNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","―Para cakskahuinama quihuani ní caktzánka̱lh. Y para tancs cchihui̱nani̱t, ¿hua̱nchi quilakakaxiya? ―huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesús ixtamakachi̱ni̱t acxni ma̱kalhapali̱ca y Anás chú ma̱lakachá̱nilh ixpuhuiti kahuasa Caifás xapuxcu cura amá ca̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ana ní ixyá Pedro itskoma cha̱tum kalasquínilh: ―¿Huix ixdiscípulo namá chixcú tí ma̱nu̱ca nac pu̱la̱chi̱n? ―Aquit ni̱ huá ―kalhtí̱nalh Pedro. ");
INSERT INTO topNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Aná lacatzú ixyá cha̱tum ixpariente amá chixcú tí Pedro ca̱ctí̱nilh ixtaké̱n y xlá na̱ huánilh: ―Caksán la̱ huix amá tí ixta̱láya̱t Jesús acxni cqui̱chipáu. ");
INSERT INTO topNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro si̱tzi̱lhá y ca̱huánilh: ―¡Aquit ni̱ clakapasa namá chixcú! Pedro maktutu ni̱ kalhtási̱lh Jesús y acxni tuncán káxmatli la̱ tásalh tantum pu̱yu. ");
INSERT INTO topNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Istzucumajá xkaká acxni Caifás ma̱kalhapali̱ko̱lh Jesús; a̱stá̱n táli̱lh nac ixpu̱ma̱paksí̱n gobernador romano ixuanicán Pilato. Xlacán ni̱ tatánu̱lh nac ixpu̱ma̱paksí̱n pues ni̱ ixtali̱maclaputún tala̱kalhí̱n porque si no ni̱ ixca̱li̱makxtakcán natalakachixcuhui̱nán amá ixli̱hualhtata xatacuhui̱ní pa̱xcua. ");
INSERT INTO topNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Huá xlacata Pilato li̱táxtulh nac lacaquilhti̱n y ca̱kalasquínilh: ―¿Tucu tláhualh jaé chixcú? ¿Hua̱nchi ma̱lacapu̱yá̱tit? ");
INSERT INTO topNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","―Jaé chixcú tlahuanit lanca tala̱kalhí̱n huá cli̱li̱mini̱táu xlacata nali̱lhca̱ya la̱ naxoko̱nán ―takalhtí̱nalh xlacán. ");
INSERT INTO topNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","―¿A poco ni̱ kalhi̱yá̱tit ley ni̱ma̱ li̱ma̱paksi̱naná̱tit? Cali̱pítit y huixín cama̱xoko̱ní̱tit tú tlahuani̱t ―ca̱kálhti̱lh Pilato. ―Ckalhi̱yá̱u quili̱ma̱paksi̱ncán pero como cmakni̱putuná̱u tamaclacasquiní huix nama̱sta̱ya li̱tlá̱n ―tahuanipá. ");
INSERT INTO topNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesús lákcha̱lh ixtachihuí̱n la̱ ixca̱huanini̱t ixdiscípulos ama̱ca makni̱cán nac culu̱s pues romanos chú ixtali̱smani̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato tánu̱lh nac ixpu̱ma̱paksi̱n y li̱ma̱paksí̱nalh catánu̱lh Jesús. Aná kalasquínilh: ―¿Xli̱ca̱na huix ixreycan judíos? ");
INSERT INTO topNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","―Pu̱la quinkalhti tú cama kalasquiniyá̱n. ¿Quili̱macapina rey xala ca̱quilhtamacú la̱ huixín, o quili̱macapina rey ni̱ma̱ ca̱ma̱lacnu̱nicani̱t judíos? ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","―Aquit ni̱ judío. ¿Nicu li̱puhuana naclacpuhuán la̱ huixín? Tí tali̱maca̱ná̱n rey huá namá tí tali̱mín y tama̱lacapu̱má̱n. ¿Tucu tlahuani̱ta? ¿Hua̱nchi tasi̱tzi̱niyá̱n? ―kalasquínilh Pilato. ");
INSERT INTO topNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","―Aquit ckalhí quili̱ma̱paksí̱n ni̱ juú ca̱quilhtamacú. Para juú xacma̱paksi̱nampútulh amá tí quintata̱ya̱na ixquintamaklhtí̱nalh ni̱ naquinchipacán. Aquit rey pero quintapáksi̱t ni̱ juú huí ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","―¿Entonces huix xli̱ca̱na rey? Jesús kálhti̱lh: ―Xli̱ca̱na aquit rey cmilh lakahuán ca̱quilhtamacú xlacata nacma̱sí stalanca talacapastacni. Aquit ixreycán namá tí takaxmata stalanca talacapa̱stacni. ");
INSERT INTO topNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","―¿Neje namá stalanaca talacapa̱stacni ni̱ma̱ ma̱si̱ya? ―kalasquínilh Pilato. Ixamajcú kalhtí Jesús acxni táxtulh nac quilhtí̱n y ca̱huánilh amá xanapuxcun judíos tí ixtama̱lacapu̱ma̱na Jesús: ");
INSERT INTO topNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","―Aquit ni̱ ctaka̱sa tú nacli̱ya̱huá jaé chixcú; ¡ni̱ lá cma̱lacapú! Huixín ca̱ta cá̱ta lacasquiná̱tit cacmákxtakli cha̱tum tachí̱n nac xatacuhui̱ní pa̱scua, para lacasquiná̱tit nacmakxtaka jaé chixcú tí li̱macapiná̱tit mireycán. ");
INSERT INTO topNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","―¡Tó̱! Mejor camákxtakti Barrabás ―tama̱ktási̱lh hua̱k cristianos. Jaé chixcú ixtanu̱ma nac pu̱la̱chi̱n porque kalha̱ná ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilato cali̱ma̱páksi̱lh soldados catásnokli Jesús nac ixaklhchá̱n. ");
INSERT INTO topNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pero xlacán ma̱s tali̱kamá̱nalh, tahuilí̱nilh aktum corona xla lhtucú̱n, tamaklháke̱lh lhma̱n tzutzoko lháka̱t la̱ xla cha̱tum rey y tzúculh tatatzokostaní xlacata natali̱kalhkama̱nán. ");
INSERT INTO topNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ixtahuaní: ―¡Siempre calatámalh ixreycán judíos! ―y acxni ixtata̱chihuinán ixtalakakaxí ixlacán. ");
INSERT INTO topNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Taxtupá ca̱ta̱chihui̱nán Pilato amá xanapuxcun judíos y ca̱huánilh: ―Tancs cca̱huaniyá̱n, ni̱ ccatzí tú nacli̱ya̱huá jaé chixcú. ¡Ca̱cxílhtit, nachu̱ min! ");
INSERT INTO topNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús táxtulh, ixuili̱ni̱t amá tzutzoko lhma̱n lháka̱t, ixaknú amá corona xla lhtucú̱n. Pilato ca̱huánilh: ―Nachu yá. ¡Cca̱macama̱xqui̱yá̱n! ");
INSERT INTO topNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Amá xanapuxcun judíos ni̱tú talí̱cxilhli Jesús y tzúculh ta̱ktasá: ―¡Camakni nac culu̱s! ¡Camakni nac culu̱s! ―Para chú lacasquiná̱tit huixín camakní̱tit porque aquit ni̱ ctaka̱sní tala̱kalhí̱n tú nacli̱ma̱lacapú ―ca̱kálhti̱lh Pilato. ");
INSERT INTO topNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","―Chú cama tlahuayá̱u pues ley ni̱ma̱ cli̱tapaksi̱yá̱u huan xlacata amá tí ta̱ra̱lacata̱quí Dios mini̱ní naní y jaé chixcú li̱tanú Ixkahuasa Dios. ");
INSERT INTO topNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Acxni Pilato káxmatli ticu yá chixcú ixtali̱macá̱n Jesús, ma̱s jícualh. ");
INSERT INTO topNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Huá xlacata li̱tasanipá nac ixpu̱ma̱paksí̱n y kalasquínilh: ―Quihuani, ¿nicu tani̱tampi huix? ");
INSERT INTO topNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jesús ni̱ kálhti̱lh tú kalasquínilh huá li̱huanipá: ―¿Hua̱nchi ni̱ quinkalhti̱ya? ¿Ni̱ catzi̱ya xlacata tla̱n cli̱ma̱paksi̱nán camakxtakca o camakni̱ca nac culu̱s? ");
INSERT INTO topNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","―Para ni̱ nac akapú̱n ixtiminchá mili̱ma̱paksí̱n ni̱ma̱ kalhi̱ya chí ni̱ lá ixquihuani tla̱n quimakxtaka o li̱ma̱paksi̱nana quimakni̱ca. Amá tí quintalí̱milh cmilacatí̱n naquima̱kalhapali̱ya, ma̱s takalhí tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","La̱ kaxmatko̱lh ixtachihuí̱n Jesús Pilato lacpútzalh la̱ namakxtaka. Pero amá lactali̱pa̱u judíos tahuánilh: ―Para makxtaka namá chixcú huix ni̱ ta̱ta̱yaya miamigo emperador romano pues amá tí li̱tanú rey ta̱ra̱lacata̱qui̱ma ixli̱ma̱paksi̱n emperador. ");
INSERT INTO topNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato cátzi̱lh tú tla̱n ixtali̱malacapú amá lacchixcuhuí̱n y mejor ma̱xtupá Jesús y curucs tahui nac ixpu̱táhui̱lh ní ixca̱li̱lhca taxokón tí ixca̱ma̱lacapu̱cán. Jaé pu̱táhui̱lh ixuanicán nac hebreo tachihuí̱n Gabata y huamputún “ca̱talaktzapsni”. ");
INSERT INTO topNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Istzanká aktum chichiní nalakchá̱n xatacuhui̱ní pa̱xcua y ma̱x tastúnut ixuani̱t acxni Pilato ca̱huánilh amá lacchixcuhuí̱n: ―¡Nachu yá, cca̱macama̱xqui̱yán mireycán! ");
INSERT INTO topNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","―¡Cani̱lh! ¡Cani̱lh! ¡Camakni nac culu̱s! ―ta̱ktásalh. ―Pero, ¿hua̱nchi nacmakní tí li̱tanú mireycán? ―ca̱huanipá. ―¡Aquín huata ckalhi̱yá̱u cha̱tum rey y huá namá emperador César! ");
INSERT INTO topNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato yaj cátzi̱lh tú nahuán y ca̱macamá̱xqui̱lh Jesús xlacata xlacán natamakní nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Amá xanapuxcun judíos tamá̱xtulh Jesús, tama̱cúqui̱lh aktum culu̱s y táli̱lh lacatum ní ixuanicán La Calavera y nac hebreo tachihuín Gólgota. ");
INSERT INTO topNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jesús aná akxtokohuacaca nac culu̱s; pero cha̱tuy tachí̱n na̱ ca̱makni̱ca nac culu̱s y ca̱ya̱huaca cha̱tunu ixpa̱xtu̱ni̱tni. ");
INSERT INTO topNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ma̱tzokónalh aktum letrero y ya̱huaca ixakspú̱n ixculu̱s Jesús. Aná ixuán: “Jesús xalac Nazaret ixreycan judíos.” ");
INSERT INTO topNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ixtatzokni̱t nac hebreo, griego y latín tachihuí̱n xlacata hua̱k cristianos tla̱n natali̱kalhtahuaká porque ana ní makni̱ca Jesús lacatzú ixuani̱t ca̱chiquí̱n xla Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Amá xanapuxcun judíos ni̱ tama̱tlá̱ni̱lh la̱ tzokli Pilato y ta̱lh tahuaní: ―¿Hua̱nchi tzokti xlacata xlá ixreycan judíos? Ixtítzokti xlacata xlá ixli̱tanú ixreycan judíos, pero ni̱ huá. ");
INSERT INTO topNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","―Tú ctzokni̱t ni̱tí ama xapá. ¡Chú catamakxtakke̱lh! ―ca̱kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Amá soldados tí ta̱kxtokohuácalh Jesús nac culu̱s quilhmacta̱ti tamá̱xtulh xala ixkalhni ixlháka̱t cha̱tunu ta̱tamákxtakli quilhmactum. Pero xala ixtancá̱n ixlháka̱t aktum ixlani̱t la̱ tejido ixuanicán túnica. ");
INSERT INTO topNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xlacán tzúculh tara̱huaní: ―Para lacxti̱tá̱u jaé pá̱xcat ama tlahuayá̱u. Mejor cali̱maca̱huí suerte a ver ticu nata̱tamakxtaka. Amá soldados tama̱kantáxti̱lh tú ixma̱tzokonani̱t Dios ixlacata Jesús nac Escrituras, aná ixuán: “Pu̱la tama̱kpítzilh quilháka̱t, y xalhma̱n túnica talimáca̱lh suerte.” ");
INSERT INTO topNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lacatzú nac ixculu̱s Jesús ixtaya̱na ixna̱na, cha̱tum ixlitalakapasni ixna̱na, María ixta̱cha̱t Cleofas y María Magdalena. ");
INSERT INTO topNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ixna̱na ixyá ixpa̱xtu̱n ixdiscípulo tí snu̱n ixlakalhamán; acxni cá̱cxilhli huánilh ixna̱na: ―Na̱na, chí huá namá la̱ minkahuasa. ");
INSERT INTO topNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Amá ixdiscípulo tí ixlakalhamán huánilh: ―Chí huá namá la̱ mintzé. La̱tá amá quilhtamacú jaé ixdiscípulo maktakálhnilh ixna̱na Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesús ixcatzí xlacata ixlako̱ma ixli̱stacni; hua̱k ixtlahuani̱t pero xlacata ni̱ natzanká tú ixtatzokni̱t ixlacata nac Escrituras ca̱huánil: ―Aquit ckalhtí. ");
INSERT INTO topNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aná lacatzú ixuí aktum xa̱lu vinagre tú ixtali̱kotnán; cha̱tum qui̱tíyalh aktum esponja, li̱ma̱cáhui̱lh vinagre, ma̱kánu̱lh nac kantum la̱ cháncat huanicán hisopo y ma̱lacatzuhuí̱nilh nac ixquilhni Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Xlá kotli actzú amá vinagre y chihui̱nampá: ―¡Chí hua̱k kantaxtuni̱t! Acxni tuncán ta̱cpú̱talh, macamá̱sta̱lh ixli̱stacni y láksputli Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Amá sábado ixli̱jaxatcan judíos ixlakcha̱majá, y na̱ pi̱huá amá chichiní ixpu̱lakcha̱ma xatacuhui̱ní pa̱scua y xanapuxcun judíos ni̱ ixtalacasquín natahuacá nac culu̱s cha̱tum ni̱n porque snu̱n lanca chichiní ixuani̱t. Xlacán ta̱lh tahuaní Pilato caca̱li̱ma̱páksi̱lh itsoldados caca̱tucxnica ixcha̱xpa̱ncán amá tachi̱ní̱n xlacata sok nataní y tla̱n naca̱ma̱cti̱cán. ");
INSERT INTO topNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amá soldados pu̱la tachá̱tucxli tí ixca̱ma̱huacacani̱t ixpa̱xtu̱ni̱tni Jesús, ");
INSERT INTO topNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","y acxni ixama tacha̱tucxa Jesús tá̱cxilhli xlacata xlá ixni̱ni̱ttá y yaj tú tatlahuánilh. ");
INSERT INTO topNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero cha̱tum soldado li̱ta̱pa̱lhtúculh ixlanza, y nac ixta̱pá̱n Jesús ní ma̱nú̱nilh li̱cá̱n tzúculh taxtú kalhni y chúchut. ");
INSERT INTO topNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Aquit tí ctzokma jaé tachihuí̱n tla̱n cma̱luloka cacxilhni̱t tú tlahuanica Jesús, y tancs cca̱huanini̱tán la̱ qui̱táxtulh xlacata huixín naca̱najlayá̱tit ticu yá chixcú ixuani̱t xlá. ");
INSERT INTO topNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jaé soldados ni̱ tacátzi̱lh xlacata xlacán tama̱kantáxti̱lh tú huan ixlacata Jesús nac Escrituras lacatum huan: “Ni̱ ama̱ca tucxnicán ni̱ para akstum ixlúcut.” ");
INSERT INTO topNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y a̱lacatum huan: “Ama̱ca acxilhcán la̱ ta̱pa̱lhtucuca.” ");
INSERT INTO topNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Cha̱tum tali̱pa̱u chixcú xalac Arimatea huanicán José tze̱k ixli̱pa̱huani̱t Jesús porque ixca̱jicuaní tú natatlahuaní xanapuxcun curas. Pero acxni makni̱ca kálhi̱lh li̱camama namaksquín li̱tlá̱n Pilato camacamá̱xquí̱lh xani̱n Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pilato ma̱tlá̱ni̱lh y José alh ma̱ctí xani̱n Jesús y na̱ takókelh Nicodemo amá chixcú tí alh ta̱chihui̱nán Jesús maktum ca̱tzisní. Xlá ixlí̱n li̱huacá cuarenta y cinco kilos áloe y mirra xlacata natamacuilí Jesús y ni̱ li̱xcájnit naquincalá. ");
INSERT INTO topNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ixli̱cha̱tuycán tamá̱cti̱lh y tzúculh tali̱maksuita lháka̱t y tamacuili̱ti̱lhá amá áloe y mirra. Jaé li̱ca̱xtlahua̱n snu̱n ixtamu̱csún y chú ixtali̱smani̱ni̱t judíos tamujú ixni̱ncán. ");
INSERT INTO topNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ana ní makni̱ca Jesús ixuí lacatzú aktum ixpu̱chancán quihui y na̱ ixlacahuaxcani̱t nac sipi aktum ixpu̱mujucan ni̱n y ni̱ naj tí ixma̱nu̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Xlacán aná tamá̱nu̱lh Jesús porque lacatzú ixuani̱t y xa̱huá ixamajá lacatzucú xatacuhui̱ni pa̱xcua amá smalankán. ");
INSERT INTO topNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ixli̱tu̱xama domingo la̱ta ya̱ itxkaká lihua spalh ixca̱huama María Magdalena alh ana ní ixma̱nu̱cani̱t Jesús y ácxilhli xlacata ixma̱ke̱nu̱cani̱t chíhuix ni̱ma̱ ixlacahuili̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Xlá tatza̱lh ca̱lákalh Simón Pedro y amá discípulo tí ma̱s ixlakalhamán Jesús, ca̱huánilh: ―Ma̱xtucani̱t Quimpu̱chinacán ní ixma̱nu̱cani̱t y cacatzi ní li̱nca. ");
INSERT INTO topNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro y xa̱chatum discípulo tatza̱lh ta̱lh ní ixma̱nu̱cani̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pero akxtakli̱nca Pedro y xa̱chatum pu̱la cha̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xlá talacánu̱lh y ácxilhli lháka̱t ni̱ma̱ ixli̱maksuitcani̱t Jesús nac ca̱tiyatni ixtama̱na pero ni̱ tánu̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ixli̱puntzú Pedro na̱ uyu cha̱lh; xlá, sí, tánu̱lh y na̱ ácxilhli tú ixmá ca̱tiyatni, ");
INSERT INTO topNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","y amá tú ixliakchi̱cani̱t Jesús tla̱n ixlakkapsni̱t y lacatzú ixpa̱xtú̱n ixuili̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Amá discípulo tí pu̱la ixcha̱ni̱t na̱ tánu̱lh y acxni ácxilhli tú ixqui̱taxtuni̱t, ixnacú acxcátzi̱lh tziná xlacata Jesús ixlacastacuanani̱t, ");
INSERT INTO topNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ma̱squi ya̱ ixtama̱kachakxí ixcha̱tuycán xlacata Dios ixli̱chihui̱nán la̱ Jesús ama lacastacuanán ca̱li̱ní̱n y ama latamá xastacnán. ");
INSERT INTO topNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A̱stá̱n xlacán tatáspitli ní ixtahuila̱na xa̱makapitzi. ");
INSERT INTO topNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María Magdalena táspitli ní ixma̱nu̱cani̱t Jesús y tzúculh tasá nac lacaquilhtí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ixli̱puntzú talacánu̱lh nac ixpu̱lacni y cá̱cxilhli cha̱tuy ángeles makstarankán ixtalhaka̱nani̱t; cha̱tum ixuí pakán ní ixma̱pi̱cani̱t ixakxaka Jesús y xa̱chatum pakán ní ixuí ixtujún. ");
INSERT INTO topNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","―¿Hua̱nchi tasápa̱t? ―takalasquínilh amá ángeles. ―Porque kalhancani̱t Quimpu̱chiná y ni̱ ccatzí ní li̱cha̱ncani̱t ―ca̱kálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Y la̱ta quilhpu̱taj ixyá talakáspitli porque acxcatzi̱lh la̱ tí catá̱yalh ixken. ¡Jesús ixuani̱t pero xlá ni̱ lakápasli para huá! ");
INSERT INTO topNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","―¿Hua̱nchi tasápa̱t? ¿Ticu putzaya? ―kalasquínilh. ―Chixcú, para huix li̱pini̱ta Quimpu̱chiná quihuani ní li̱chipini̱ta xlacata nacán tiyá ―kálhti̱lh. Chuná jaé kálhti̱lh porque xlá ixpuhuán ixta̱chihui̱nama cha̱tum tasa̱cua tí ixmaktakalhnán amá ca̱quihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Entonces Jesús huánilh jaé tachihuí̱n: ―María, ¿ni̱ quilakapasa? Xlá acxnicú tla̱n lacá̱nilh lakápasli y huánilh: ―¡Maestro! ");
INSERT INTO topNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","―¡Ni̱ caquimacxama! Porque ya̱ clakán Quinti̱cú nac akapú̱n. Chí cli̱ma̱paksi̱yá̱n capit ca̱putzaya quinata̱camán y caca̱huani clakama Quinti̱cú pero huixín na̱ Minti̱cucán, clakama Quimpu̱chiná Dios tí cli̱pa̱huani̱t pero huixín na̱ miDioscán porque li̱pa̱huaná̱tit. ");
INSERT INTO topNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","María tatza̱lh alh ca̱lacaputzá ixdiscípulos Jesús y ca̱huánilh: ―¡Cacxilhni̱t xastacnán Quimpu̱chinacán! A̱stá̱n na̱ ca̱lacspí̱tnilh tú ixma̱macqui̱ni̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pi̱huá amá xaca̱tzisni domingo ixdiscípulos Jesús tla̱n take̱xtúculh ní ixtatanuma̱na xlacata ni̱tí natanú pues ixtajicuaní xanapuxcun judíos. Pero ma̱squi ni̱tí ma̱liquí̱nilh Jesús tánu̱lh, ca̱lakatá̱yalh ní ixtahuila̱na, ca̱huánilh kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ca̱ma̱sí̱nilh ixmacán y ana ní ixta̱pa̱lhtucucani̱t. ¡Xlacán snu̱n tali̱pa̱xáhualh la̱ ixta̱cxilhni̱t Ixpu̱chinacán Jesús xastacnán! ");
INSERT INTO topNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús ca̱huánilh ixdiscípulos: ―Quinti̱cú quima̱lakácha̱lh ca̱quilhtamacú y chí accha̱ni̱t hora aquit na̱ camá̱n ca̱ma̱lakacha̱yá̱n naquila̱li̱chihui̱naná̱u. ");
INSERT INTO topNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesús ca̱jajmáni̱lh ixdiscípulos y ca̱huánilh: ―¡Camaklhti̱nántit cha̱tunu ixli̱tlihueke Espíritu Santo! ");
INSERT INTO topNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Amá cristianos tí ma̱tzanke̱naniyá̱tit ixtala̱kalhi̱n na̱ ni̱ ama xoko̱nán nac ca̱li̱ní̱n, pero tí ni̱ ma̱tzanke̱naniyá̱tit ama xoko̱nán nac ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Acxni ca̱ta̱chihuí̱nalh Jesús cha̱tum ixdiscípulos tí ixuanicán Tomás ni̱ lakxtum ixca̱ta̱hui xa̱makapitzi ");
INSERT INTO topNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","y acxni chilh tali̱ma̱kalhchihuí̱ni̱lh la̱ ixta̱cxilhni̱t xastacnán Jesús. Pero xlá ca̱huánilh: ―¡Aquit ni̱ cca̱najlá! Nacca̱najlá hasta xní nacxamá y nacacxila ní li̱xtokocani̱t clavos y nacma̱nú quimacán ní ta̱pa̱lhtucucani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ixli̱tu̱xama li̱tum ixdiscípulos Jesús tatamákstokli y tla̱n ixtaxtucuni̱t, y Tomás na̱ aná ixuí. Jesús tanu̱pá la̱ ixtanu̱ni̱t xapu̱lh ni̱tí ma̱liquí̱nilh, ca̱lakatá̱yalh y ca̱huánilh kalhé̱n. ");
INSERT INTO topNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Como Jesús ixcatzí tú ixlacpuhuán Tomás huánilh: ―¡Huix ni̱ ca̱najlaya para clama xastacnán! Pues cá̱cxilhti y caxama ní quili̱xtokoca clavos y cama̱nu mimacán ní quinta̱pa̱lhtucuca. ¡Yaj cata̱klhuhui, caca̱najla! ");
INSERT INTO topNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","―¡Yaj cama ta̱klhuhuí; huix Quimpu̱chiná quiDios xastacnán! ―kalhtí̱nalh Tomás. ");
INSERT INTO topNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","―Huix quili̱pa̱huani̱ta porque quiacxilhni̱ta. ¡Aquit ma̱s cama ca̱li̱pa̱xahuá cristianos tí naquintali̱pa̱huán ma̱squi ni̱ quinta̱cxilhni̱t xastacnán! ―huaniko̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ixdiscípulos Jesús ta̱cxilhni̱t lhu̱hua ma̱s laclanca ixtascújut ni̱ma̱ ca̱li̱ma̱lacahuá̱ni̱lh y ni̱ hua̱k tatatzokni̱t juú nac libro. ");
INSERT INTO topNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Aquit cca̱lacsacni̱t ni̱ma̱ talactáxtulh xlacata naca̱lakapasá̱tit y naca̱najlayá̱tit Jesús Ixkahuasa Dios; huá Cristo tí ixma̱lacnu̱cani̱t ama ca̱lakma̱xtú cristianos y amá tí nali̱pa̱huán ama ma̱xquí li̱pa̱xáu ixlatáma̱t nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ni̱ ixli̱maka̱s quilhtamacú nac ixquilhtu̱n chúchut xla Galilea tatamákstokli makapitzi ixdiscípulos Jesús; ");
INSERT INTO topNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","aná ixtahuila̱na Simón Pedro, Tomás el Gemelo, Natanael xalac Caná de Galilea, ixlakkahuasan Zebedeo, Jacobo y Juan, y cha̱tuy ixdiscípulos li̱huacá. ");
INSERT INTO topNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro ca̱huánilh xa̱makapitzi: ―Cama chakanán. ―Aquín na̱ nacca̱ta̱aná̱n ―tahuánilh xa̱makapitzi. Hua̱k tatáju̱lh nac barco y ta̱lh. Pero ni̱tú tachípalh tamakní. ");
INSERT INTO topNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Itxkakamajá acxni tatáspitli ixquilhtú̱n y tá̱cxilhli cha̱tum chixcú aná ixyá. ¡Como ca̱paklhtutá ni̱ talakápasli para Jesús ixuani̱t! ");
INSERT INTO topNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xlá ca̱kalasquínilh: ―¿Chipátit tamakní lakkahuasán? ―Tó̱, ni̱tú cchipáu ―takálhti̱lh. ");
INSERT INTO topNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","―Pues camacapítit mintza̱lhcán pakán ixpakca̱na mibarcojcán y pa̱t chipayá̱tit lhu̱hua tamakní. Xlacán tamáca̱lh istza̱lhcán ní ixca̱huanicani̱t y tahuácalh lhu̱hua tamakní hasta yaj lá ixtama̱cutú. ");
INSERT INTO topNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","8","Amá ixdiscípulo tí ixlakalhamán Jesús acxcátzi̱lh tí ixca̱ta̱chihui̱nama y huánilh Pedro: ―¡Quimpu̱chinacán namá quinca̱tachihui̱nán! Ixca̱tzanka̱ní lacatzu aktum ciento metro natachá̱n ixquilhtú̱n Pedro huíli̱lh xala ixkalhni ixlháka̱t pues huata xala ixtancá̱n ixuili̱ni̱t y tzúculh xquihua̱tnán pakán ní ixyá Jesús. Xa̱makapitzi lakasu̱t taxuatáli̱lh istza̱lhcán la̱ta ixtataju̱ma̱na nac barco. ");
INSERT INTO topNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Acxni tácha̱lh nac ixquilhtú̱n tá̱cxilhli ixma̱kstokcani̱t lhcúya̱t itscuma tantum tamakní y na̱ ixuí simi̱ta. ");
INSERT INTO topNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","―Cali̱tántit makapitzi tamakní ni̱ma̱ apenas ca̱chipátit ―ca̱huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro lacapala ca̱ta̱lí̱milh istza̱lhcán nac ixquilhtú̱n y ca̱pu̱tlékelh ciento cincuenta y tres laclanca tamakní ixtatahuacani̱t y ni̱ talacáxti̱tli istza̱lhcán ma̱squi lhu̱hua tamakní ixuani̱t. ");
INSERT INTO topNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","―Catántit hua̱yanátit ―ca̱huánilh Jesús. Xlacán talakápasli xlacata Jesús ixuani̱t pero ni̱tí kalasquínilh ní ixmini̱tanchá. ");
INSERT INTO topNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús tíyalh amá simi̱ta y tamakní y tzúculh ca̱ma̱xquí ixdiscípulos xlacata natahua̱yán. ");
INSERT INTO topNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Juú nac chúchut ca̱tasí̱nilh Jesús ixli̱maktutu ixdiscípulos la̱ta tilacastacuánalh ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","La̱ tahua̱yanko̱lh Jesús huánilh Simón Pedro: ―Simón ixkahuasa Jonás, ¿xli̱ca̱na quilakalhamana ni̱ la̱ jaé xa̱makapitzi? ―Jé, clakalhamaná̱n, huix quilakapasa ―kalhtí̱nalh. ―Entonces clacasquín caca̱maktákalhti tí cca̱li̱ma̱nú quiborregos. ");
INSERT INTO topNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","―Tancs quihuani, ¿quilakalhamana Simón ixkahuasa Jonás? ―kalasquínilh Jesús ixli̱maktuy. Y xlá kalhti̱pá: ―Quimpu̱chiná, huix catzi̱ya la̱ clakalhamanán. ¡Ni̱ cakskahuimá̱n! ―Pues caca̱maktákalhti quiborregos. ");
INSERT INTO topNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ixli̱maktutu huanipá: ―Simón ixkahuasa Jonás, ¿xli̱ca̱na huix quilakalhamana? Pedro lakapútzalh porque maktutu kalasquínilh para xli̱ca̱na ixlakalhamán. ―Quimpu̱chiná, huix lakapasa quintapuhuá̱n y catzi̱ya la̱ clakalhamaná̱n ―xlá kalhti̱pá. ");
INSERT INTO topNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","―Para chuná la̱ quihuaniya caca̱maktákalhti quiborregos. Acxni kahuasa ixuani̱t ixtlahuaya ixpina ní ixlacasquina ni̱tí ixli̱huaniyá̱n, pero acxni nako̱luna pa̱t ca̱stonka y ma̱sta̱ya mimacxpá̱n xlacata tunu natacuentajá̱n y natali̱ná̱n ana ní huix ni̱ pimputuna ―huánilh Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús li̱ma̱ma̱kachakxí̱ni̱lh Pedro la̱ ixama liakxtakajnán acxni naní ixlacata, pero chuná ixama ma̱sí la̱ pa̱xquí Jesús ixama lakachixcuhuí Dios. ―Siempre quili̱pá̱huanti ―huanipá Jesús. ");
INSERT INTO topNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro talakáspitli y ácxilhli na̱ ixtakokeni̱t Jesús amá ixdiscípulo tí kalasquínilh tí ixama macama̱stá acxni a̱huata tica̱ta̱hualhtátalh. ");
INSERT INTO topNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedro kalasquínilh Jesús: ―Quimpu̱chinacán, y jaé, ¿niculá ama ní? ¿Tucu ama akspulá? ");
INSERT INTO topNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","―¿Hua̱nchi quinkalasquiniya? Huix ni̱ mincuenta para xaclacásquilh tla̱n ixlatáma̱lh hasta xacqui̱táspitli. ¡Ni̱ caquinkalhtáxtokti, caquintakoke huatiyá! ―kálhtilh. ");
INSERT INTO topNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jaé quilhtamacú tí xla̱huán tzúculh tali̱pa̱huán Jesús, ixtahuán xlacata jaé ixdiscípulo Jesús ni̱cxni ixama ní. Pero Jesús ni̱ huá xlacata ni̱ ama ní, xlá huá: “Huix ni̱ mincuenta para xaclacásquilh tla̱n ixlatáma̱lh hasta xacqui̱táspitli.” ");
INSERT INTO topNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Aquit namá discípulo tí ixpuhuancán ni̱ ama ní. Pi̱huá aquit ctzokli tú li̱kalhtahuakani̱tántit juú nac libro; hua̱k cacxilhni̱t la̱ qui̱táxtulh y ccatzí ni̱ cakskahuinani̱t. ¡Tancs cchihui̱nani̱t! ");
INSERT INTO topNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús ca̱tláhualh ma̱s laclanca ixtascújut, pero ni̱ hua̱k ca̱tzokcani̱t, y para hua̱k ixca̱tzokca cpuhuán ni̱ ixtatanu̱ko̱lh nac ca̱quilhtamacú amá libros ni̱ma̱ ixtali̱chihuí̱nalh Jesús. Chuná calalh, amén.");
INSERT INTO topNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tali̱pa̱u quiamigo Teófilo: Xla̱huan libro ni̱ma̱ ctzokli y cma̱lakacha̱nín, cli̱ta̱chihui̱nán la̱ta tú tláhualh y má̱si̱lh Jesús la̱ta tima̱lacatzúqui̱lh ixtascújut ca̱quilhtamacú ");
INSERT INTO topNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta acxni alh nac akapú̱n. Huix catzi̱ya la̱ makni̱ca, pero xlá lacastacuánalh ca̱li̱ní̱n y ti̱puxum chichiní ca̱tasí̱nilh ixdiscípulos ca̱quilhtamacú xlacata nata̱cxila y natama̱luloka la̱ ixlama xastacnán. ");
INSERT INTO topNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Como ixca̱lacsacni̱t ixapóstoles antes naán nac akapú̱n tla̱n ca̱lacspí̱tnilh la̱ ixama lacatzucú ixtapaksi̱t Dios y ca̱li̱ma̱cxcatzí̱ni̱lh Espíritu Santo tú ixli̱tlahuatcán a̱stá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Maktum acxni ca̱tasi̱nipá, ca̱huánilh: ―Ni̱ cataxtútit jaé ca̱chiquí̱n xla Jerusalén; juú catamakxtáktit; cakalhí̱tit naca̱ma̱xqui̱caná̱tit ixli̱tlihueke Espíritu Santo la̱ ca̱ma̱lacnu̱nín Quinti̱cú. ");
INSERT INTO topNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pues huixín catzi̱yá̱tit xlacata Juan Bautista ixliakmunu̱nán chúchut pero huixín pa̱t ca̱liakmunucaná̱tit ixli̱tlihueke Espíritu Santo yaj maka̱s chichiní. ");
INSERT INTO topNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Maktum tunu quilhtamacú acxni ca̱tasi̱nipá ixdiscípulos, xlacán takalasquínilh: ―Quimpu̱chinacán Jesús, ¿huá jaé quilhtamacú pa̱t lakma̱xtuya quimpu̱latama̱ncán Israel la̱ ta̱kchipani̱t romanos? ");
INSERT INTO topNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús ca̱kálhti̱lh: ―Huixín ni̱ ca̱mini̱niyá̱n nacatzi̱yá̱tit tú yá quilhtamacú o tú yá chichiní ama ma̱kantaxtí Quinti̱cú Dios tú xlá laclhca̱ni̱t ama tlahuá a̱stá̱n ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero acxni namaklhti̱naná̱tit ixli̱tlihueke Espíritu Santo huixín pa̱t kalhi̱yá̱tit li̱camama naquila̱li̱chihui̱naná̱u juú nac Jerusalén, nac pu̱latama̱n Judea, nac Samaria y na̱ chuná hua̱k lactzú y laclanca pu̱latama̱n ni̱ma̱ tahuila̱na ixli̱ti̱lanca ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Maktum ixdiscípulos Jesús hua̱k ixtatamakstokni̱t, y ¡ana tuncán Jesús aktlapako̱lh la̱ puclhni y tzúculh ta̱cxtú nac akapú̱n caj la̱ cakosli! ");
INSERT INTO topNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Hua̱k acs ixtalaca̱ni̱t la̱ ixta̱cxtuma Jesús y lakasu̱t tzúculh talakatzanká; hasta ni̱ para tá̱cxilhli la̱ calakata̱yachi cha̱tuy lacchixcuhuí̱n makstarankán ixtalhaka̱nani̱t, ");
INSERT INTO topNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","y chuné tachihuí̱nalh: ―Lacchixcuhuí̱n xalac Galilea, huixín acxilhni̱tántit la̱ ani̱t Jesús nac akapú̱n, pero ni̱tú capuhuántit porque la̱ acxílhtit tá̱cxtulh nac akapú̱n, chuná namimpará y ta̱ctapará ixli̱maktuy ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aná jaé ní ixtatamakstokni̱t cristianos ixuanicán Monte de los Olivos. A̱stá̱n táalh nac ca̱chiquí̱n xla Jerusalén ní ixtatamakxtaka, tatlá̱hualh como aktum kilómetro. ");
INSERT INTO topNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","A̱stá̱n tatá̱cxtulh nac ixli̱quilhmactuy chiqui ni̱ma̱ ixtapu̱huila̱na. Juú ixtatamakxtaka Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago ixkahuasa Alfeo, Simón el cananista y Judas ixta̱cam Jacobo. ");
INSERT INTO topNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Xlacán siempre ixtatamakstoka xlacata acxtum natakalhtahuakaní Dios con ixli̱talakapasni Jesús, ixna̱na na̱ chuná y makapitzi lacchaján ni̱ma̱ na̱ ixtamín. ");
INSERT INTO topNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Maklhu̱hua chuná jaé ixtakalhtahuaká y maktum ixtatamakstokni̱t ma̱x como ciento veinte cristianos, Pedro tá̱yalh y chuné ca̱ta̱chihuí̱nalh: ");
INSERT INTO topNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Li̱ta̱caman, ixtamaclacasquiní naqui̱taxtú tú ixlaclhca̱ni̱t Dios, ca̱ksántit la̱ ma̱lacpuhuá̱ni̱lh Espíritu Santo rey David catzokli nac ixlibro tú ixama akspulá amá chixcú tí ca̱cpúxculh cristianos natachipá y natalí̱n Jesús nac pu̱la̱chi̱n. ");
INSERT INTO topNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ma̱kachakxi̱tittá xlacata cca̱li̱ta̱chihui̱namá̱n Judas Iscariote amá tí na̱ ixlacsaccani̱t naquinca̱ta̱scujá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero como liakskahuínalh Quimpu̱chinacán ma̱xqui̱ca tumi̱n y huá li̱tamá̱hualh aktum ca̱quihuí̱n. Pero, ¿tucu li̱macuánilh? Ixacstu ta̱kpíxchi̱lh y acxni pa̱tástalh hua̱k ixpa̱lu̱hua ta̱kahuani̱ko̱lh ca̱tiyatni. ");
INSERT INTO topNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tú pá̱xtokli Judas tuncán tacatzi̱ko̱lh cristianos tí talama̱na nac Jerusalén y tali̱ma̱pa̱cúhui̱lh jaé ca̱quihuí̱n Campo de Sangre. ");
INSERT INTO topNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nac ixlibro xla Salmos rey David na̱ tzokli ixlacatacán namá cristianos tú ca̱pa̱xtoka acxni tachipá jaé tijia, pues lacatum tzokli: Akxtakmákalh ixchic, yaj tí capu̱latáma̱lh. A̱lacatunu huan: Tunu tí cachípalh ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Huá cca̱li̱huaniyá̱n, calacputzáu tí nali̱lhca̱yá̱u natanú ixlakapu̱xoko Judas. ");
INSERT INTO topNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juú tahuila̱na makapitzi lacchixcuhuí̱n tí tata̱latapu̱li̱ni̱t Jesús la̱ta tiakmúnulh Juan hasta acxni alh nac akapú̱n cquilacati̱ncán. Calacsacuí tí ma̱s ma̱ccha̱ní talacapa̱stacni xlacata naquinca̱ta̱latapu̱li̱yá̱n y naquinca̱ta̱ma̱luloká̱n Jesús lacastacuánalh ca̱li̱ní̱n y lama xastacnán. ");
INSERT INTO topNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Amá cristianos tama̱pa̱cúhui̱lh cha̱tuy lacchixcuhuí̱n ma̱s xalactali̱pa̱u: cha̱tum ixuanicán José ixli̱lakapascán Barsabás y xa̱cha̱tum ixuanicán Matías. ");
INSERT INTO topNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","A̱stá̱n pu̱tum tzúculh takalhtahuakaní Dios, ixtahuán: ―Quimpu̱chinacán, huix hua̱k ca̱lakapasa ixtapuhua̱n quinacujcán. ");
INSERT INTO topNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Aquín cca̱lacsacui jaé cha̱tuy lacchixcuhuí̱n, quila̱ma̱cxcatzi̱níu ticu li̱lhca̱ni̱ta natanú ixpu̱xoko Judas, pues xlá laktzánka̱lh y alh akxtakajnán ní ixmini̱ní. ");
INSERT INTO topNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","La̱ takalhtahuakako̱lh ca̱li̱maca̱nca suerte ixcha̱tuycán y tocá̱rli̱lh Matías natanú ixlakapu̱xoko Judas, y la̱ta amá quilhtamacú ca̱ta̱ma̱paksí̱nalh cha̱ca̱huitu apóstoles. ");
INSERT INTO topNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ni̱ lhu̱hua quilhtamacú alh acxni lakcha̱mpá tunu ixtacuhuinican judíos ixuanicán Pentecostés y hua̱k amá tí ixtali̱pa̱huani̱t Jesús ixtatamakstokni̱t nac aktum ákxtaka. ");
INSERT INTO topNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aná ixtatanu̱ma̱na acxni takáxmatli nac akapú̱n la̱ cajílilh y ¡suannc ca̱laktánu̱lh la̱ aktum akxtulú̱n, ixtasí la̱ aktum maclanca lhcúya̱t! ");
INSERT INTO topNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ya̱ para ixtama̱kachakxí tú ixqui̱taxtuma acxni tzúculh tapitzí catzuntín amá lhcúya̱t la̱ capíricxli, y ca̱ctánu̱lh cha̱tum cha̱túm nac ixtalacapa̱stacnicán. ¡Chuná jaé ixca̱liakmunucani̱t ixli̱tlihueke Espíritu Santo! ");
INSERT INTO topNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","La̱ tamaklhti̱nako̱lh ixli̱tlihueke Espíritu Santo tla̱n tachihuí̱nalh ti̱pa̱katzi tachihuí̱n ni̱ma̱ ni̱cxni ixtakaxmatni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nac Jerusalén ixtamini̱t talakachixcuhui̱nán lhu̱hua judíos ni̱ma̱ ixtalama̱na katunu ca̱chiquí̱n y pu̱latama̱n amá quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Acxni takáxmatli maca̱csá̱nalh nac akapú̱n amá la̱ akxtulú̱n lacapala táalh nac ákxtaka ní ixtatanu̱ma̱na apóstoles. Acxni tácha̱lh, ni̱ ixtaca̱najlaputún tú ixqui̱taxtuma, pues cha̱tunu apóstoles ixchihui̱nán nac ixtachihui̱ncán ni̱ma̱ ixchihui̱nancán nac ixpu̱latama̱ncán. ");
INSERT INTO topNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","A̱huata acs tatá̱yalh, ixtahuán: ―Jaé lacchixcuhuí̱n xalac Galilea, ¿tucu ixkasatcán? ");
INSERT INTO topNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Hua̱nchi tla̱n tachihui̱nán quintachihui̱ncán ni̱ma̱ aquín chihui̱naná̱u nac quimpu̱latama̱ncán? ");
INSERT INTO topNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","¿Nicu tali̱ma̱kachakxí ixtachihui̱ncán tí tamini̱t juú? Pues juú talaya̱na cristianos xalac Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, ");
INSERT INTO topNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Asia, Frigia, Panfilia, Egipto, Africa amá pu̱latama̱n ni̱ma̱ huilachá pakana̱chá nac Cirene. ");
INSERT INTO topNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Na̱ tamini̱t cristianos xalac Creta y Arabia, y hasta cristianos romanos na̱ talaya̱na juú, makapitzi juú talakahuani̱t y tunu caj tapaktanu̱ni̱t judíos natali̱pa̱huán Dios ni̱ma̱ talakachixcuhuí xlacán. ¡Ni̱ para li̱ca̱najlaputu la̱ tali̱chihui̱nán namá cristianos ixtascújut Dios nac quintachihui̱ncán! ");
INSERT INTO topNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Lhu̱hua ni̱ ixtacatzí tú natalacpuhuán y huata ixtara̱kalasquiní: ―¿Cha̱ nicu ama qui̱ta̱yá jaé tú kaxmatma̱náu? ");
INSERT INTO topNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","―¡Ni̱ caso catlahuátit, takachí namá lacchixcuhuí̱n! ―ixtakalhti̱nán makapitzi. ");
INSERT INTO topNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Entonces hua̱k apóstoles tatá̱yalh ixlacati̱ncán y Pedro chuné ca̱ta̱chihuí̱nalh cristianos: ―Huixín cristianos xalac Jerusalén y huixín tí tani̱tántit xala mákat y quila̱kaxmatma̱náu, ");
INSERT INTO topNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","cama̱kachakxí̱tit tú cama ca̱huaniyá̱n: Makapitzi huixín huaná̱tit xlacata aquín ckachi̱yá̱u. ¡Nicu li̱puhuaná̱tit ckachi̱yá̱u si apenas las nueve de la mañana! ");
INSERT INTO topNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Huixín ni̱ ma̱kachakxi̱ni̱nántit xlacata nac milacati̱ncán kantaxtuni̱t amá tú tima̱cxcatzí̱ni̱lh Dios profeta Joel maká̱n quilhtamacú. Xlá chuná tzokli ixtapuhua̱n Dios: ");
INSERT INTO topNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ama cha̱n quilhtamacú acxni hua̱k cristianos cama ma̱xquí quintalacapa̱stacni. Lacchixcuhuí̱n y lacchaján ama ta̱cxcatzí y tali̱chihui̱nán quintapuhuá̱n, lakkahuasán y lactzumaján cama ca̱li̱ma̱lacahua̱ní quintascújut, y lakko̱lún lhu̱hua tú cama ca̱li̱ma̱ma̱nixní. ");
INSERT INTO topNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Hua̱k lacchixcuhuí̱n y lacchaján tí quintamacuaní ama ca̱kchipaní ixtalacapa̱stacnicán Quiespíritu xlacata naquintali̱chihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nac akapú̱n pa̱t acxilá̱tit tú ni̱cxni ixtasi̱ni̱t, y nac ca̱quilhtamacú cama li̱ma̱lacahua̱ni̱nán la̱ kalhni, la̱ lhcúya̱t y la̱ jin. ");
INSERT INTO topNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Chichiní ama talakapaklhtu̱tá y papá ama tasí la̱ cakálhi̱lh kalhni; y huá jaé quilhtamacú acxni ama min Mimpu̱chinacán xlacata naca̱ma̱si̱niyá̱n la̱ kalhí ixli̱tlihueke ixli̱ma̱paksí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amá cristianos tí tamaksquín Dios caca̱lakalhámalh ama talakma̱xtú ixli̱stacnicán. ");
INSERT INTO topNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro la̱ta ixma̱ti̱tumi̱ni̱t ixtalacapa̱stacni, ca̱huanipá: ―¡Tla̱n cama̱kachakxí̱tit tú camá̱n ca̱huaniyá̱n huixín lacchixcuhuí̱n xalac Israel! Huixín catzi̱yá̱tit la̱ latáma̱lh namá chixcú Jesús xalac Nazaret, Dios ixlacsacni̱t y má̱xqui̱lh hua̱k ixli̱tlihueke xlacata naca̱tlahuá laclanca ixtascújut y chuná ca̱li̱ma̱lacahua̱ní̱n la̱ kalhí ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dios maká̱n ixlaclhca̱ni̱t tú ixama qui̱taxtú huá li̱mákxtakli cama̱lacapú̱tit nac ixpu̱ma̱paksi̱ncán romanos y chuná tla̱n makní̱tit nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ni̱cxni lacpuhuántit xlacata ixpu̱china ca̱li̱ní̱n ni̱ lá makatlájalh pues ixliaktutu chichiní a̱stá̱n lacastacuánalh porque Dios ixma̱xqui̱ni̱t ixli̱tlihueke. ");
INSERT INTO topNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Calacapa̱stáctit la̱ rey David tzokli xlacata Ixpu̱chiná Cristo, chuné ta̱chihuí̱nalh Dios: Cacxila la̱ quinta̱tla̱huán Quimpu̱chiná, cacxcatzí la̱ quimakta̱yá xlacata ni̱tú naquima̱laktzanké. ");
INSERT INTO topNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Huá xlacata snu̱n li̱pa̱xahuá quinacú, y quisi̱máka̱t cli̱huán lacla̱n tachihuí̱n xlacata naclakachixcuhuí. Pues ccatzí ma̱squi quimacni ama ní cama lacastacuanampará. ");
INSERT INTO topNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porque ni̱ pa̱t akxtakmakana quili̱stacni nac ca̱li̱ní̱n, ni̱ para pa̱t li̱makxtaka napu̱chí̱n ixmacni Minkahuasa tí macuanini̱tán. ");
INSERT INTO topNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Huix quima̱si̱nini̱ta tijia ni̱ma̱ tancs nacli̱chá̱n nac akapú̱n, xlacata nacli̱pa̱xahuayá̱n acxni naclakcha̱ná̱n nac mimpa̱xtú̱n huix Quimpu̱chiná. ");
INSERT INTO topNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Li̱ta̱camán, ¿ticu ixli̱chihui̱nama rey David? Xlá latáma̱lh, ni̱lh y muju̱ca la̱ cati̱hua chixcú y hua̱k aquín catzi̱yá̱u ní taju̱ma. ");
INSERT INTO topNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Li̱ta̱camán, rey David ixli̱chihui̱nama cha̱tum ixli̱talakapasni ni̱ma̱ ixama lakahuán, ixama tanú ixlakapu̱xoko ixpu̱ma̱paksí̱n, pues xlá na̱ profeta ixuani̱t y Dios chú tancs ma̱lacnú̱nilh. ");
INSERT INTO topNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Rey David maká̱n tili̱lacahuá̱nalh xlacata Cristo tí ixama ca̱lakma̱xtuyá̱n ixama lacastacuanán ca̱li̱ní̱n, ni̱ ixama tamakxtaka ixli̱stacni nac ca̱li̱ní̱n, ni̱ para ixmacni ixama pu̱chí̱n nac tíyat. ");
INSERT INTO topNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","’Aquín cacxilhni̱táu Jesús xastacnán y tla̱n cma̱luloká̱u xlacata Dios ma̱lacastacuáni̱lh ca̱li̱ní̱n. ");
INSERT INTO topNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Acxni alh nac akapú̱n ní ixama ta̱ma̱paksi̱nán Ixti̱cú, maklhtí̱nalh hua̱k ixli̱tlihueke y quinca̱ma̱lacnu̱nín ixama quinca̱ma̱lakacha̱niyá̱n Espíritu Santo. Chí huixín acxilhni̱tántit y kaxpatni̱tántit la̱ quinca̱ma̱lakacha̱nini̱tán ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ah, xacaktzonksuama cca̱huaniyá̱n, Dios ni̱ ma̱lacnú̱nilh rey David nata̱ma̱paksi̱nán pues xlá na̱ huá: Quinti̱cú Dios huánilh Quimpu̱chiná tí ixama quilakma̱xtú: “Catahuila nac quimpa̱xtú̱n, ");
INSERT INTO topNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta xní nacca̱ma̱ktzuhuí hua̱k mienemigos xlacata natalakachixcuhui̱yá̱n.” ");
INSERT INTO topNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Hua̱k huixín cristianos xalac Israel tí quila̱kaxmatma̱náu, aquit tancs cma̱luloka xlacata jaé chixcú Jesús tí huixín makní̱tit nac culu̱s Dios li̱lhca̱ni̱t Quimpu̱chinacán nahuán tí naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","La̱ takaxmatko̱lh ixtachihui̱n Pedro amá cristianos tzúculh tali̱puhuán ixnacujcán tú ixtatlahuani̱t y takalasquínilh Pedro y xa̱makapitzi apóstoles: ―Li̱ta̱camán, ¿tucu quili̱tlahuatcán? ");
INSERT INTO topNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro ca̱kálhti̱lh: ―Cakalhapalanítit Jesucristo tú ni̱ tla̱n tlahuani̱tántit ixlacati̱n Dios y cha̱tunu cata̱kmúnulh nac ixtacuhui̱ni Jesucristo xlacata nama̱tzanke̱naní ixtala̱kalhí̱n y Dios nama̱xquí ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pues Jesús ma̱lácnu̱lh Dios ama ca̱ma̱xqui̱yá̱n ixli̱tlihueke Espíritu Santo hua̱k huixín y mincamancán y na̱ chuná hua̱k cristianos xala cani̱huá ca̱quilhtamacú tí ca̱tasaní Dios natali̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro lhu̱hua ma̱s la̱ ca̱li̱ta̱chihuí̱nalh Jesús, na̱ ca̱lacspí̱tnilh la̱ ixli̱latama̱tcán. Ca̱huánilh ni̱ catamakslihuékelh ixkasatcán amá ni̱ lactla̱n cristianos xala ca̱quilhtamacú, para xli̱ca̱na ixtacha̱mputún ixpa̱xtu̱n Dios nac akapú̱n. ");
INSERT INTO topNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","La̱ chihui̱nanko̱lh Pedro, amá chichiní tali̱pá̱hualh Jesús como cha̱tutu mi̱lh cristianos y cha̱tunu cristianos tata̱kmúnulh. ");
INSERT INTO topNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Amá cristianos tí ixtali̱pa̱huani̱t Jesús ixtalakatí tama̱kantaxtí tú ixtama̱sí apóstoles, acxtum ixtalacchihui̱nán tú ixtatlahuá, macxtum ixtakalhtahuakaní Dios, ixtama̱kpitzí ixtahuajcán. ");
INSERT INTO topNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Dios ca̱ma̱tláhui̱lh apóstoles lhu̱hua laclanca tascújut y hua̱k cristianos ixtaca̱cní tú ixta̱cxila. ");
INSERT INTO topNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jaé cristianos tí ixtali̱pa̱huani̱t Jesús ni̱ ixtalactlancán, quilhpa̱xtum ixtara̱lakalhamán, ixtara̱makta̱yá acxni tú ixmaclacasquín cha̱tum cristiano. ");
INSERT INTO topNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ni̱ caj cha̱tum sta̱lh la̱ta tú ixkalhí, ixmacama̱stá xatumi̱n xlacata nama̱kpitzicán y naca̱ma̱xqui̱cán tí ixca̱tzanka̱ní ixtamaclacasquín. ");
INSERT INTO topNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cha̱li cha̱lí ixtatamakstoka nac lanca pu̱siculan xalac Jerusalén ixtalakachixcuhuí Dios. A̱stá̱n ixtatamakstoka nac aktum ákxtaka y aná li̱pa̱xáu lakxtum ixtahua̱yán la̱ li̱ta̱camán; ixtapa̱xcatcatzi̱ní Dios tú ixtlahuani̱t ixlacatacán. ");
INSERT INTO topNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Hua̱k cristianos xala amá ca̱chiquí̱n ixtalakatí la̱ ti̱tum ixtaya̱huani̱t ixtalacapa̱stacnicán y ca̱li̱tlá̱n ixtalama̱na, y Dios na̱ chuná cha̱li cha̱lí ixca̱lakxta̱palí ixkasatcán cristianos, ixtapaktanú amá cristianos tí ixtali̱pa̱huán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Maktum Pedro y Juan ixta̱ma̱na talakachixcuhui̱nán nac lanca ixpu̱siculancan judíos xalac Jerusalén como a las tres de la tarde pues hua̱k cristianos tí ixtali̱pa̱huani̱t Jesús chú ixtali̱smani̱ni̱t talakachixcuhui̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cha̱li cha̱lí ixtahuilá nac lacapuhui̱lhta cha̱tum chixcú tí ni̱ lá ixtla̱huán la̱ta tilakáhualh. Huí tí ixmín huilí nac puhui̱lhta pu̱siculan huanicán la Hermosa xlacata naca̱maksquín limosna judíos tí ixtatanú. ");
INSERT INTO topNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Acxni cá̱cxilhli Pedro y Juan ixama tatanú nac pu̱siculan ca̱huánilh: ―Quila̱ma̱xquí̱u actzu limosna. ");
INSERT INTO topNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Xlacán acs talacá̱nilh y Pedro kálhti̱lh: ―Pu̱la tla̱n quila̱laca̱cxilhui. ");
INSERT INTO topNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Xlá ixpuhuán ama̱ca ma̱xqui̱cán tumi̱n. ");
INSERT INTO topNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedro tuncán huanipá: ―Aquit ni̱ cli̱mín tumi̱n pero camá̱n ma̱xqui̱yá̱n tú ma̱s ama macuaniyá̱n. ¡Ixli̱tlihueke Jesucristo xalac Nazaret camakta̱yán y catlá̱huanti tuncán! ");
INSERT INTO topNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Amá chixcú scayaj catzanko̱lh y maklhcátzi̱lh la̱ tzúculh tatlihueklha ixtujún ixcha̱xpá̱n. Tzáksalh ta̱yá; Pedro makachípalh, ¡chixx yá̱hualh y stucaj ta̱yachá la̱ta kósnalh. A̱stá̱n tzúculh tla̱huán. Pedro y Juan tatánu̱lh nac lanca pu̱siculan; xlá ca̱takókelh hasta ixkosnanti̱lhá la̱ta ixpa̱xahuama, ixpa̱xcatcatzi̱niti̱lhá Dios la̱ ixma̱ksa̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Hua̱k cristianos tí ixtatanu̱ma̱na nac pu̱siculan acxni tá̱cxilhli amá chixcú talakápasli xlacata huá amá tí itsquihua̱yán. ");
INSERT INTO topNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Xlacán tajicuanko̱lh porque ni̱ ixtacatzí tú ixqui̱taxtunini̱t amá chixcú tí ixtahuilá cha̱li cha̱lí nac lacapuhui̱lhta la Hermosa. ");
INSERT INTO topNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amá chixcú tí ixaksa̱nani̱t ixca̱pakchipalí̱n Pedro y Juan y ni̱ ixca̱makxtakputún. Xlacán tácha̱lh lacatum ní huanicán Portal de Salomón y hua̱k cristianos táalh aná porque ixtacatzi̱putún tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro ni̱ makatzánka̱lh quilhtamacú y chuné tzúculh ca̱ta̱chihui̱nán cristianos: ―Huixín lacchixcuhuí̱n xalac Israel, ¿hua̱nchi ca̱maka̱klhayá̱n tú qui̱taxtuni̱t? Huixín quila̱ca̱cni̱yá̱u la̱mpara aquín ckalhi̱yá̱u li̱tlihueke tú cli̱ma̱ksa̱ní̱u jaé chixcú tí ni̱ lá ixtla̱huán. ");
INSERT INTO topNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mili̱catzi̱tcán xlacata amá Dios tí tali̱pa̱huani̱t Abraham, Isaac, Jacob y hua̱k xalakmaká̱n quili̱tlakapasnicán, ma̱xqui̱ni̱t Ixkahuasa ixpu̱táhui̱lh nac ixpa̱xtú̱n. Amá chixcú tí huixín ma̱lacapú̱tit nac pu̱ma̱paksí̱n y acxni Pilato ixmakxtakputún huixín ni̱ ma̱tla̱ní̱tit. ");
INSERT INTO topNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","¡Cacatzi tucu xlacata huixín ni̱ ma̱tla̱ní̱tit camakxtakca amá tla̱n chixcú tí tancs ixlama y cha̱ ma̱tla̱ní̱tit camakxtakca cha̱tum makni̱ná! ");
INSERT INTO topNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Chuná jaé makní̱tit amá chixcú tí ixmacama̱xqui̱cani̱t hua̱k quili̱stacnicán. Pero Dios ma̱lacastacuáni̱lh ca̱li̱ní̱n y aquín tla̱n cma̱luloká̱u lama xastacnán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Aquín cli̱pa̱huani̱táu Jesús ixli̱hua̱k quintapuhua̱ncán y jaé chixcú ni̱ma̱ lakapasá̱tit ni̱ lá ixtla̱huán aksa̱nani̱t porque cli̱quilhani̱táu ixli̱tlihueke Jesús y chí huixín acxilhni̱tántit la̱ ma̱ksá̱ni̱lh. ");
INSERT INTO topNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Huixín y xanapuxcun judíos makní̱tit Jesús pero ccatzí xlacata ni̱cxni ma̱kachakxí̱tit tú xlacata chú li̱tlahuátit. ");
INSERT INTO topNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios ca̱maclacasquín huixín pues chuná ma̱kantáxti̱lh la̱ ca̱ma̱cxcatzí̱ni̱lh profetas ixama akxtakajnán Cristo tí ixama ma̱lakachá naca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chí tamaclacasquiní calakxta̱palí̱tit milatama̱tcán ixlacati̱n Dios y cali̱pa̱huántit ixli̱hua̱k minacujcán xlacata naca̱xapaniyá̱n mintala̱kalhi̱ncán y naca̱makapa̱xahuayá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pues naca̱lakacha̱niyá̱n Cristo tí naca̱lakma̱xtuyá̱n la̱ ixlaclhca̱ni̱t milacatacán maká̱n quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero chí amajcú latama̱pará Jesús nac akapú̱n maka̱s quilhtamacú hasta nalacca̱xtlahuakó Dios tú laclhca̱ni̱t pues xalakmaka̱n profetas chú tali̱chihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aquit ni̱ chu̱ta cchihui̱nama, ca̱ksántit tú ca̱huánilh Moisés xalakmaka̱n quili̱talakapasnicán: “Quimpu̱chinacán Dios quilácsacli nacca̱cpuxcuná̱n, pero ama cha̱n quilhtamacú juú nac quimpu̱latama̱ncán ama lactaxtú tunu ma̱s tali̱pa̱u tí ama ma̱xquí ixli̱ma̱paksí̱n. Cakaxpáttit tú naca̱huaniyá̱n ");
INSERT INTO topNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","porque tí ni̱ tlahuá tú li̱ma̱paksi̱nán ni̱ ama li̱pa̱xahuá tú naca̱ma̱xquí Dios ixcamán y hasta ama̱ca ma̱laksputucán.” ");
INSERT INTO topNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Huá cca̱li̱huaniyá̱n, ¿hua̱nchi ni̱ ma̱kachakxi̱yá̱tit tú qui̱taxtuma jaé quilhtamacú? Samuel y xa̱makapitzi profetas hua̱k tali̱chihui̱nani̱t tú acxilhma̱náu. ");
INSERT INTO topNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dios ma̱lakácha̱lh profetas xlacata naca̱ma̱lacnu̱niyá̱n ixama ca̱ma̱lakacha̱niyá̱n cha̱tum tí naca̱lakma̱xtuyá̱n. Huixín namá judíos tí Dios ca̱li̱chihuí̱nalh acxni huánilh Abraham: “Hua̱k cristianos xala ca̱quilhtamacú cama ca̱ma̱xquí quintalakalhamá̱n caj ixlacatacán mili̱talakapasni xala a̱stá̱n.” ");
INSERT INTO topNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Dios ca̱ma̱lakacha̱nín Jesús Ixkahuasa pu̱la huixín xalac Israel xlacata naca̱xapaniyá̱n mintala̱kalhi̱ncán y naca̱ma̱xqui̱yá̱n li̱pa̱xau latáma̱t. ");
INSERT INTO topNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","La̱ta istzamacán, Pedro y Juan talácspi̱tli la̱ ama talacastacuanán ni̱n nac ca̱li̱ní̱n; ixtahuán xlacata Jesús ixtaxtunini̱t ca̱li̱ní̱n ixlama xastacnán. Pero xanapuxcun curas y saduceos tali̱sí̱tzi̱lh la̱ ixtachihui̱nán; ixli̱puntzú tatá̱chilh xapuxcu policía tí ixmaktakalhnán nac pu̱siculan, ca̱chipaca ixcha̱tuycán, ");
INSERT INTO topNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ca̱li̱nca nac pu̱la̱chi̱n, y como smalankaná ixuani̱t aná talakaxkákalh amá tzisni. ");
INSERT INTO topNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero lhu̱hua cristianos tí takáxmatli ixtachihui̱ncan Pedro y Juan taca̱nájlalh y amá chichiní tali̱pá̱hualh Jesús cha̱quitzis mi̱lh cristianos huata lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ixli̱cha̱lí nac Jerusalén tatamákstokli nac ixpu̱ma̱paksi̱ncán hua̱k xanapuxcun ma̱paksi̱naní̱n, xalactali̱pa̱u ixli̱talakapasnican xanapuxcun curas, xalactali̱pa̱u lakko̱rutzi̱n, ixma̱kalhtahuake̱nacan judíos. ");
INSERT INTO topNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Aná ixtatanu̱ma̱na Anás, lihua xako̱rutzi̱n cura Caifás, Juan y Alejandro. ");
INSERT INTO topNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xlacán tali̱ma̱paksí̱nalh caca̱li̱minca Pedro y Juan xlacata naca̱ma̱kalhapali̱cán. Acxni ca̱li̱chinca ca̱kalasquinica: ―¿Tucu ca̱li̱ma̱paksi̱ni̱tán, y ticu ca̱ma̱xqui̱ni̱tán li̱tlihueke nama̱ksa̱ni̱yá̱tit jaé chixcú? ");
INSERT INTO topNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro ni̱ para tziná ixjicuán porque Espíritu Santo hua̱k ixma̱lacpuhua̱ní y ca̱kálhti̱lh: ―Lactali̱pa̱u ma̱paksi̱naní̱n y lakko̱lún tí quila̱ma̱kalhapali̱ma̱náu, ");
INSERT INTO topNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿huixín catzi̱putuná̱tit nicu liaksá̱nalh namá chixcú tí ni̱ lá ixtla̱huán? ");
INSERT INTO topNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pues tla̱n ni̱ cjicuaná̱u cca̱huaniyá̱n nacmilacati̱ncán y cani̱hua pu̱latama̱n xlacata jaé chixcú ma̱ksá̱ni̱lh ixli̱tlihueke Jesucristo namá chixcú xalac Nazaret ni̱ma̱ huixín makní̱tit nac culu̱s. Pero Dios ma̱lacastacuáni̱lh y lama xastacnán, ¡huá ma̱ksá̱ni̱lh jaé chixcú! ");
INSERT INTO topNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Nac Escrituras Dios huan xlacata Jesús huá namá chíhuix ni̱ma̱ ixli̱lhca̱ni̱t nata̱yá nac ixcha̱stu̱n chiqui la̱ cha̱ya xlacata aná natzinca̱snankó ákxtaka, pero huixín lakmakántit. ");
INSERT INTO topNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Huata Jesús tla̱n lakma̱xtunán; Dios ni̱ ma̱lakacha̱ni̱t tunu chixcú tí natali̱pa̱huán y naca̱lakma̱xtú cristianos ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amá lacchixcuhuí̱n ixtaca̱cní la̱ ixtachihui̱nán Pedro y Juan porque xlacán ni̱ ixtakalhtahuakani̱t, ni̱ para ixtaskalalani̱t pero ti̱tum ixtaya̱huá ixtalacapa̱stacnicán acxni ixtachihui̱nán. Talacpúhualh xlacata Jesús ni̱ chu̱ta ixmínit, pues xlacán tla̱n ixtama̱kachakxi̱ni̱t tú ixca̱ma̱si̱nini̱t. ");
INSERT INTO topNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Como aná ixyá amá chixcú tí ixaksa̱nani̱t, yaj tacátzi̱lh tú natakalhti̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Mejor tali̱ma̱paksí̱nalh caca̱tamacxtuca Pedro y Juan y tzúculh tara̱kalasquiní entre xlacán: ");
INSERT INTO topNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","―¿Tucu ca̱tlahuaniyá̱u jaé lacchixcuhuí̱n? Juú nac Jerusalén lacapala ta̱kahuani̱ni̱t tachihuí̱n la̱ tama̱ksá̱ni̱lh namá chixcú y aquín ni̱ lá akskahuinaná̱u y huaná̱u xlacata ni̱ ca̱na tú tatláhualh pues ¡nachu yá namá chixcú! ");
INSERT INTO topNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma̱x tú quili̱tláhuatcán, caca̱maka̱klhahuí xlacata yaj catali̱chihuí̱nalh namá chixcú Jesús, porque para ni̱ takaxmata tapala̱xlá ama ca̱qui̱taxtuní. ");
INSERT INTO topNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ixli̱puntzú ca̱li̱mimparaca Pedro y Juan ixlacati̱ncán y tahuánilh tú ixtalacpuhuani̱t y la̱ ixtalacchihui̱nani̱t. ");
INSERT INTO topNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedro ca̱kálhti̱lh: ―Quila̱huaníu, ¿ticu ckaxmatniyá̱u tú quinca̱li̱ma̱paksi̱yá̱n nactlahuayá̱u, Dios o huixín? ");
INSERT INTO topNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aquín ni̱ lá cli̱makxtaká̱u cli̱chihui̱naná̱u tú cacxilhui y ckaxmatui acxni xacta̱lapu̱layá̱u Jesús ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Amá lacchixcuhuí̱n takalhtí̱nalh: ―Pues para ni̱ tlahuayá̱tit tú cca̱li̱ma̱paksi̱yá̱n huixín mincuentajcán tú ca̱qui̱taxtuniyá̱n a̱stá̱n. Pero ca̱makxtakca porque ni̱ lanca tú ixtatlahuani̱t y xa̱huá tajícualh porque cani̱huá lhu̱hua cristianos ixtapa̱xcatcatzi̱nima̱na Dios la̱ ixma̱ksa̱ni̱ni̱t ");
INSERT INTO topNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","amá chixcú tí ixkalhi̱yá ti̱puxum ca̱ta la̱ta ni̱ lá ixtla̱huán. ");
INSERT INTO topNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","La̱ tatáxtulh nacpu̱la̱chi̱n Pedro y Juan talákalh xa̱makapitzi discípulos y tali̱ma̱kalhchihuí̱ni̱lh la̱ ixca̱kastacya̱huani̱t amá xanapuxcun ma̱paksi̱naní̱n; ");
INSERT INTO topNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","y aná tuncán chuné tzúculh takalhtahuakaní Dios: ―Lanca Quimpu̱chinacán Dios tí tlahuani̱ta akapú̱n, tíyat, pupunú y la̱ta tú anán, ¡quila̱kaxmatui! ");
INSERT INTO topNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Huix ma̱lakacha Espíritu Santo cama̱lacpuhuá̱ni̱lh rey David catzokli ixkasatcan cristianos y xlá huá: ¿Hua̱nchi tí ni̱ tali̱pa̱huán Dios tata̱ra̱lacata̱quí Quimpu̱chinacán? ¡Pero ni̱tú ca̱li̱macuaní! ");
INSERT INTO topNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nac ca̱quilhtamacú reyes tama̱lakxtúmi̱lh ixtalacpuhua̱ncán xlacata natata̱ra̱lacata̱quí Ixpu̱chinacán y tata̱rá̱nicli Cristo tí xlá ma̱lakácha̱lh. ");
INSERT INTO topNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Quimpu̱chinacán Dios, xli̱ca̱na chú qui̱táxtulh juú nac Jerusalén pues tatalakxtúmi̱lh rey Herodes, Poncio Pilato, lactali̱pa̱u ma̱paksi̱naní̱n xala mákat y cristianos xalac Israel y acxtum tata̱ra̱lacatá̱qui̱lh Minkahuasa Jesús tí huix ixlacsacni̱ta namacuaniyá̱n cani̱cxnihua quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Xlacán ni̱ tatatúhuajli tama̱kantáxti̱lh tú ixlaclhca̱ni̱ta ixama qui̱taxtú. ");
INSERT INTO topNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Chí acxilhparani̱ta la̱ quinca̱maka̱klhacani̱tán. Cca̱maksquiná̱n caca̱ma̱xqui li̱camama cha̱tunu tí tali̱chihui̱nán mintachihuí̱n xlacata ni̱cxni catatachókolh, ");
INSERT INTO topNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","y caca̱ma̱xqui li̱tlá̱n catatláhualh laclanca tascújut natama̱ksa̱ni̱nán xlacata cati̱huá nacatzí, tí li̱pa̱huán Minkahuasa Jesús ma̱xquí ixli̱tlihueke y chuná natalakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","La̱ takalhtahuakako̱lh, amá chiqui ní ixtatanu̱ma̱na tatlánalh y ta̱cxcátzi̱lh la̱ Dios ixca̱ma̱lakacha̱nini̱t Espíritu Santo. A̱stá̱n tatíyalh li̱camama y ni̱ ixtaquilhpuhuán tali̱chihui̱nán Dios ní tzamacán. ");
INSERT INTO topNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Hua̱k cristianos tí ixtali̱pa̱huán Jesús aktum ixtahuili̱ni̱t ixtalacapa̱stacnicán, la̱ta tú ixtakalhí ixtara̱ma̱kpitziní ixli̱hua̱kcán, ixca̱ma̱xqui̱cán tí ma̱s ixca̱tzanka̱ní tú natali̱hua̱yán. ");
INSERT INTO topNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apóstoles na̱ chuná tancs ixtama̱luloka, ixtalacspi̱ta la̱ ixlacastacuanani̱t Jesús ixlama xastacnán y lhu̱hua ixtali̱pa̱huán Jesús acxni ixtachihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Dios ixca̱maktakalha porque acxtum la̱ li̱ta̱caman ixtara̱li̱cxila, ni̱ cha̱tum tí ixlactlancán ma̱s kalhí. Cha̱ tí ixtakalhí ixca̱quihui̱ncán, ixchiccán, ixtastá, ");
INSERT INTO topNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y xatumi̱n ixtamacama̱xquí apóstoles xlacata xlacán natama̱kpitzi y natama̱xquí tú ixca̱tzanka̱ní cha̱tum cha̱tum; ");
INSERT INTO topNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","y na̱ chuná tláhualh cha̱tum chixcú tí levita xuani̱t y pu̱la xlama nac Chipre ixuanicán José, xlacán ixtali̱ma̱pa̱cuhuí Bernabé (jaé tacuhui̱ní huamputún “tí ca̱ma̱camaja cristianos”). ");
INSERT INTO topNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Xlá ixkalhí aktum ca̱quihuí̱n, pero sta̱lh y xatumi̱n ca̱macamá̱xqui̱lh apóstoles xlacata xlacán natama̱kpitzí. ");
INSERT INTO topNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Cha̱tum chixcú huanicán Ananías ixta̱cha̱t ixuanicán Safira na̱ tásta̱lh ixca̱quihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pero acxtum talacchihuí̱nalh y ta̱cmá̱xtulh actzu tumi̱n, y ni̱ma̱ kalhtá̱xtulh tamacamá̱xqui̱lh apóstoles y tahuánilh xlacata chú ixtali̱sta̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro acxcátzi̱lh tú ixtatlahuani̱t y huánilh Ananías: ―Ananías, ¿hua̱nchi li̱mákxtakti camakatlaján ixtapuhua̱n tlajaná nac minacú? Huix li̱cxilhni̱ta para tla̱n akskahuiya Espíritu Santo porque ni̱ katzí jaé tumi̱n la̱ li̱sta minca̱quihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ananías, ¿tucu lani? ¿A poco ni̱ milá ixuani̱t namá ca̱quihuí̱n? Huix tla̱n ixquintila̱ma̱xquí̱u la̱ lacasquina porque huix ixma̱paksi̱ya mintumi̱n. Ma̱x tilacpúhuanti aquín ama quila̱kskahuiyá̱u, pero ni̱ chuná qui̱taxtuni̱t, ¡huix akskahuini̱ta Dios! ");
INSERT INTO topNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","La̱ kaxmatko̱lh ixtachihui̱n Pedro, Ananías tama̱chá ca̱tiyatni, ¡uyu tuncán ni̱lh! Hua̱k cristianos tí tá̱cxilhli y tacátzi̱lh tú ixpa̱xtokni̱t tajicuanko̱lh. ");
INSERT INTO topNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Makapitzi lakkahuasán tali̱máksuitli aktum sábana xani̱n Ananías xlacata nataán tamujú. ");
INSERT INTO topNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Pasá̱rlalh ma̱x aktutu hora acxni chilh ixta̱cha̱t, xlá ni̱ ixcatzí tú ixqui̱taxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Huá li̱kalasquínilh Pedro: ―¿Huá jaé ixtapalh li̱stá̱tit minca̱quihui̱ncán la̱ quimá̱xqui̱lh minta̱ko̱lú? ―Je, chuná cli̱stá̱u ―kalhtí̱nalh Safira. ");
INSERT INTO topNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro kálhti̱lh: ―¿Hua̱nchi li̱cxílhtit para tla̱n naakskahuiyá̱tit Espíritu Santo? Xlá ni̱ lá tí akskahuí, hua̱k acxcatzí. ¡Cá̱cxilhti, nachu tamín namá lakkahuasán tí taqui̱múju̱lh minta̱ko̱lú y na̱ pi̱huá ama tali̱ná̱n huix caj xlacata minta̱kskahuín! ");
INSERT INTO topNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Amá pusca̱t na̱ ¡pumm! tama̱chá ca̱tiyatni xaní̱n y amá lakkahuasán tásacli y táalh tamujú lacatzú ní ixtamuju̱ni̱t ixta̱ko̱lú. ");
INSERT INTO topNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Hua̱k cristianos tí ixtali̱pa̱huani̱t Jesús acxni tacátzi̱lh tú ixtapa̱xtokni̱t Ananías y Safira ca̱maká̱klhalh tú ixta̱kspulani̱t. ");
INSERT INTO topNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apóstoles ni̱ ixtali̱makxtaka tatamakstoka nac Portal de Salomón ní ixtali̱chihui̱nán Dios y lhu̱hua tí ixtama̱ksa̱ní amá ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ixtalama̱na tunu cristianos tí tze̱k ixtali̱pa̱huán Jesús y ni̱ ixta̱tamakstoka xa̱makapitzi ma̱squi ixtalakatí tú ixtatlahuá y la̱ ixtalama̱na. ");
INSERT INTO topNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Cha̱li cha̱lí ixtali̱tahuacá lacchixcuhuí̱n y lacchaján tí ixtali̱pa̱huán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ni̱ caj maktum ixca̱ma̱pi̱cán ta̱tatlaní̱n nac tijia ní ixama lacpasa̱rlá Pedro xlacata naca̱chipá ixma̱spíle̱k y nata̱ksa̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Na̱ ixtali̱mín lhu̱hua ta̱tatlaní̱n y tí ixca̱makatlajani̱t tlajaná amá cristianos tí ixtalama̱na lacatzú nac Jerusalén y hua̱k ixca̱ma̱ksa̱ni̱cán. ");
INSERT INTO topNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Xapuxcu ma̱paksi̱na cura y saduceos ca̱makasí̱tzi̱lh tú ixtatlahuá apóstoles, ");
INSERT INTO topNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","y como ni̱ ixtama̱tla̱ní tali̱ma̱paksí̱nalh caca̱ma̱nu̱paraca nac pu̱la̱chi̱n Pedro y Juan. ");
INSERT INTO topNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ca̱tzisní Dios ma̱lakácha̱lh cha̱tum ángel, xlá ma̱líqui̱lh puhui̱lhta y ca̱huánilh catatáxtulh; chuné ca̱li̱ma̱páksi̱lh: ");
INSERT INTO topNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Capítit nac pu̱siculan, ni̱ cajicuántit cali̱chihui̱nántit namá tla̱n latáma̱t ni̱ma̱ ca̱ma̱xqui̱ni̱tán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Xlacán takáxmatli tú ca̱huánilh amá ángel y chu̱ta tzisa táalh nac pu̱siculan tama̱kalhchihui̱ní cristianos. Na̱ pi̱huá amá chichiní xalacatzisa, lihua xapuxcu cura ca̱ma̱makstokko̱lh hua̱k lakko̱lún tí ixtata̱ma̱paksi̱nán. Acxni pu̱tum tatahuilako̱lh tali̱ma̱paksí̱nalh caca̱li̱minca Pedro y Juan xlacata naca̱ma̱kalhapali̱cán. ");
INSERT INTO topNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Makapitzi policías táalh nac pu̱la̱chi̱n y como ni̱tú ixtatanu̱ma̱na tachi̱ní̱n lacapala táalh tahuaní amá lactali̱pa̱u ma̱paksi̱naní̱n: ");
INSERT INTO topNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Ccha̱u nac pu̱la̱chi̱n, nac lacaquilhti̱n ixtahuila̱na amá soldados tí ixtamaktakalhnama̱na, pero acxni cma̱liquí̱u puhui̱lhta ni̱ cha̱tum tí ixtanu̱ma. ¡Tuchi talánilh! ");
INSERT INTO topNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Amá lactali̱pa̱u lacchixcuhuí̱n y xapuxcu policías a̱huata acs ixtara̱laca̱cxila. ¡Huitiyá ixtara̱kalasquiní nicu ixama qui̱ta̱yá amá tú ixquilhtzucuni̱t! ");
INSERT INTO topNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Chú ixtachihui̱nama̱najcú acxni chilh cha̱tum chixcú y ca̱huánilh: ―Namá lacchixcuhuí̱n ni̱ma̱ ca̱ma̱nú̱tit nac pu̱la̱chi̱n, tama̱kalhchihui̱nama̱na cristianos nac pu̱siculan. ");
INSERT INTO topNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Amá comandante lacapala ca̱tá̱alh ixpolicías ní ixtalaya̱na Pedro y Juan y ca̱li̱tlá̱n ca̱chípalh porque ixtajicuán para natasi̱tzí cristianos y naca̱ctahuacacán. ");
INSERT INTO topNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Acxni ca̱li̱cha̱nca ixlacati̱ncán amá ma̱paksi̱naní̱n, lihua xapuxcu cura ca̱huánilh: ");
INSERT INTO topNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Huixín kaxmatmakántit la̱ cca̱li̱huanín yaj cali̱chihui̱nántit namá chixcú Jesús. ¿Hua̱nchi la̱tiyá li̱chihui̱nampa̱nántit juú nac Jerusalén? ¡La̱mpara caj lacasquiná̱tit caquinca̱li̱ya̱huacán aquín cmakní̱u! ");
INSERT INTO topNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro kálhti̱lh (ma̱squi xa̱makapitzi apóstoles na̱ ixtakalhpaktanú): ―Aquín ma̱s ckaxmatniyá̱u tú quinca̱li̱ma̱paksi̱yá̱n Dios, ni̱ huá tú quinca̱li̱ma̱paksi̱yá̱n lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Namá tali̱pa̱u Dios tí tali̱pa̱huani̱t xalakmaka̱n quili̱talakapasnicán, ma̱lacastacuáni̱lh Jesús nac ca̱li̱ní̱n ma̱squi huixín makní̱tit nac culu̱s. ");
INSERT INTO topNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pi̱huá namá Dios má̱xqui̱lh hua̱k ixli̱tlihueke Jesús xlacata natama̱paksi̱nán la̱ cha̱tum rey tí tla̱n ca̱lakma̱xtú hua̱k cristianos xalac Israel para talakmakán tú ni̱ tla̱n tatlahuani̱t pues xlá naca̱ma̱tzanke̱naní hua̱k ixtala̱kalhi̱ncán. ");
INSERT INTO topNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aquín tla̱n cma̱luloká̱u xli̱ca̱na chú qui̱taxtú, xa̱huá Espíritu Santo tí ca̱ma̱xquí Dios amá cristianos tí tatlahuá ixtapáksi̱t na̱ tla̱n ma̱luloka quintachihui̱ncán. ");
INSERT INTO topNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amá lacchixcuhuí̱n li̱cuánit tasí̱tzi̱lh y taláclhca̱lh mejor caca̱makni̱ca apóstoles. ");
INSERT INTO topNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero cha̱tum skalala ko̱rutzi̱n fariseo ixuanicán Gamaliel li̱ma̱paksí̱nalh caca̱ma̱xtuca puntzú amá apóstoles. Jaé ko̱lú ixma̱ccha̱ní talacapa̱stacni tancs ixchihui̱nán, cati̱huá ixkaxmata tú ixuán. ");
INSERT INTO topNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Xlá ca̱huánilh ixcompañeros: ―Lactali̱pa̱u lacchixcuhuí̱n, tla̱n calacpuhuántit tú pa̱t ca̱tlahuaniyá̱tit jaé lacchixcuhuí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ca̱ksántit la̱ li̱mini̱táu nac quimpu̱latama̱ncán ni̱ lhu̱hua ca̱ta kalhí acxni tilactáxtulh amá chixcú ixuanicán Teudas. Xlá ixli̱tanú lanca y skalala chixcú, tatakókelh ma̱x cha̱cu̱ta̱ti ciento cristianos. Pero acxni makni̱ca tata̱kahuani̱ko̱lh tí ixtatakoké y aná láksputli tú ixtalaclhca̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ni̱ ixli̱maka̱s acxni ca̱tzokca cristianos tí natalakaxoko̱nán, lactaxtupá cha̱tum chixcú xalac Galilea ixuanicán Judas. Lhu̱hua tata̱tá̱yalh, pero ni̱ alh quilhtamacú makni̱ca y aná qui̱tá̱yalh ixtascújut. ");
INSERT INTO topNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Chí talactaxtuni̱t jaé lacchixcuhuí̱n, pero ¿hua̱nchi acchichijuaná̱u aquín? Para caj xlacán talaclhca̱ni̱t tú tali̱chihui̱nán, ixacstu ama laksputa. ");
INSERT INTO topNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tla̱n calacpuhuántit, ¡qué tal para Dios ma̱lacatzuqui̱ni̱t jaé tascújut, huixín ni̱ lá pa̱t ca̱ma̱chokoyá̱tit! ¡Ni̱ tili̱puhuaná̱tit a̱stá̱n caj xlacata ta̱ra̱lacata̱qui̱yá̱tit Dios! ");
INSERT INTO topNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Xlacán tama̱tlá̱ni̱lh tú ca̱huánilh Gamaliel; ca̱tasaniparaca apóstoles; ca̱maka̱klhaparaca ya̱cxni catali̱chihuí̱nalh Jesús; a̱stá̱n ca̱sti̱mu̱snokca pero ca̱tamacxtuca. ");
INSERT INTO topNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","La̱ tataxtuko̱lh nac pula̱chi̱n xlacán ni̱ ixtalakaputzati̱lhá, ma̱s cha̱ ixtapa̱xahuati̱lhá porque caj xlacata ixtali̱pa̱huán Jesús ixca̱ma̱kxtakajni̱cani̱t. ");
INSERT INTO topNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma̱squi ixca̱li̱huanicani̱t catalakmákalh amá tú ixtalactanu̱ni̱t, xlacán la̱tiyá ixtali̱chihui̱nán Dios nac pu̱siculan y nac ixakxtakacan cristianos; ixtahuán xlacata Jesús huá tí ixma̱lakacha̱ni̱t Dios naca̱lakma̱xtú cristianos. ");
INSERT INTO topNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Como cristianos tí ixtali̱pa̱huán Jesús cha̱li cha̱lí ixtali̱tahuacama̱na quilhtzúculh aktum tasi̱tzi, judíos tí ixtachihui̱nán griego tzúculh tatalacapú xlacata ixviudascán ni̱ acxtum ixca̱ma̱xqui̱cán tahuá cha̱liyá̱n la̱ ixca̱ma̱xqui̱cán viudas tí ixtachihui̱nán hebreo. ");
INSERT INTO topNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Amá cha̱cu̱tuy apóstoles tama̱makstokko̱lh cristianos y tahuánilh: ―Aquín ni̱ lá cli̱makxtaká̱u cli̱chihui̱naná̱u ixtachihui̱n Dios caj xlacata nacma̱kpitziyá̱u tahuá cha̱li cha̱lí. ");
INSERT INTO topNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pero huí tú tla̱n tlahuayá̱tit, caputzátit cha̱tujún lakskalala lacchixcuhuí̱n tí tancs talama̱na y taputzá caca̱maktá̱yalh Espíritu Santo, xlacata xlacán nata̱cpuxcún tama̱kpitzí tahuá, ");
INSERT INTO topNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","y chuná aquín tla̱n ti̱tum nacta̱yayá̱u cli̱chihui̱naná̱u ixtapaksi̱t Dios y cca̱li̱kalhtahuakayá̱u cristianos. ");
INSERT INTO topNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Hua̱k tama̱tlá̱ni̱lh tú tama̱lácnu̱lh y talácsacli jaé lacchixcuhuí̱n: xla̱huán Esteban (jaé chixcú tancs ixlama ixputzá camaktá̱yalh Espíritu Santo nac ixlatáma̱t), Felipe, Prócoro, Nicanor, Timón, Parmenas y Nicolás xalac Antioquía (jaé chixcú ni̱ judío ixuani̱t pero ixli̱pa̱huani̱t Dios y Jesús). ");
INSERT INTO topNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Hua̱k tatalacatzúhui̱lh ixlacati̱ncan apóstoles; xlacán tali̱kalhtahuákalh amá lacchixcuhuí̱n y taliáclhitli ixmacancán. ");
INSERT INTO topNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ixtachihui̱n Dios ma̱s y ma̱s ixca̱lakchá̱n cristianos nac Jerusalén hasta makapitzi curas na̱ tali̱pá̱hualh Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Como Dios ixma̱xqui̱ni̱t Esteban ixli̱tlihueke Espíritu Santo tla̱n ixca̱tlahuá laclanca tascújut y lhu̱hua cristianos ixca̱ma̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Maktum ca̱ta̱tánokli makapitzi cristianos tí ixtaán nac aktum sinagoga ixli̱tapa̱cuhuá “Esclavos Libertados”. Xlacán tzúculh tata̱ra̱huaní Esteban; na̱ tapaktánu̱lh makapitzi judíos xalac Cirene, Alejandría, Cilica y Asia. ");
INSERT INTO topNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero ni̱ cha̱tum tí akstí̱li̱lh ixtalacapa̱stacni porque hua̱k Espíritu Santo ixma̱xquí ixli̱skalala la̱ naca̱kalhtí. ");
INSERT INTO topNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Xlacán ni̱ tama̱tlá̱ni̱lh la̱ ca̱makatlájalh Esteban y taxokónilh makapitzi lacchixcuhuí̱n cataliakskahuínalh y xlacán tzúculh ta̱ktasá: ―Namá chixcú li̱kalhkama̱nán tú má̱si̱lh Moisés y li̱chiyama Dios. ");
INSERT INTO topNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Hua̱k cristianos taca̱nájlalh la̱ ixliakskahuinancán Esteban; ixma̱kalhtahuake̱nacan judíos y xanapuxcun lakko̱lún tachípalh y táli̱n nac ixlacati̱ncán ma̱paksi̱naní̱n. ");
INSERT INTO topNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Amá lacchixcuhuí̱n tí ixca̱xokonicani̱t nata̱kskahuinán tzucupá tali̱ya̱huá xlacata Esteban ixli̱kalhkama̱nán ixley Moisés y ixpu̱siculan Dios; ixtahuán: ");
INSERT INTO topNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","―Namá chixcú huan xlacata Jesús xalac Nazaret ama lactlahuakó jaé pu̱siculan; na̱ huan xlacata ama ma̱ke̱nú tú li̱ma̱paksí̱nalh Moisés. ");
INSERT INTO topNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Amá lactali̱pa̱u lacchixcuhuí̱n tí ixtama̱kalhapali̱ma̱na Esteban acs talacá̱nilh y caj la̱ catalakachiyá̱nalh tá̱cxilhli la̱ ixlacán Esteban ixlakaskoy la̱ xla cha̱tum ángel. ");
INSERT INTO topNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Xapuxcu cura kalasquínilh Esteban: ―¿Xli̱ca̱na tú tali̱ya̱huamá̱n jaé lacchixcuhuí̱n? ");
INSERT INTO topNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban chuné tzúculh ca̱ta̱chihui̱nán: ―Quili̱ta̱camán y lakko̱lún tí quila̱kaxmatma̱náu, tla̱n cama̱kachakxí̱tit tú cama ca̱huaniyá̱n. Quili̱talakapasnicán Abraham ixlama nac Mesopotamia, ixpu̱latama̱ncán amá cristianos tí ca̱li̱ma̱pa̱cuhui̱cán caldeos, acxni lanca Quimpu̱chinacán Dios tasí̱nilh, ");
INSERT INTO topNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","y huánilh caakxtakmákalh la̱ta tú kalhí hasta ixli̱talakapasni, porque ixama ma̱si̱ní aktum sa̱sti pu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Abraham táxtulh nac Mesopotamia y Dios lí̱milh nac ca̱chiquí̱n Harán, ixli̱tapaksí pu̱latama̱n Siria. Juú latáma̱lh hasta acxni ni̱lh ixti̱cú. A̱stá̱n Dios li̱lh pakán nac Canaán juú ní lama̱náu aquín. ");
INSERT INTO topNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero amá quilhtamacú Dios ni̱ li̱mákxtakli cakálhi̱lh ca̱na actzu ixca̱quihuí̱n tú nama̱paksí, huata ma̱lacnú̱nilh xlacata ixcamán ixama tama̱paksí jaé pu̱latama̱n acxni xlá naní, y Abraham ni̱ naj ixkalhí ni̱ para cha̱tum ixkahuasa. ");
INSERT INTO topNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios na̱ huánilh Abraham xlacata ixcamán ixama ca̱li̱ncán la̱ tachí̱n nac aktum mákat pu̱latama̱n y aná ixama ca̱ma̱kxtakajni̱cán akta̱ti ciento ca̱ta. ");
INSERT INTO topNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero huánilh xlacata ixama ca̱ma̱xoko̱ní amá cristianos tú ixama tatlahuá, y tancs ma̱lacnú̱nilh xlacata amá judíos tí ixca̱lacsacni̱t ixama tataspitpará nac Canaán ana ní natalakachixcuhuí cani̱cxnihuá. ");
INSERT INTO topNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Como Dios ni̱ ixlacasquín tí naaktzonksuá tú ixma̱lacnu̱ni̱t, li̱ma̱paksí̱nalh caca̱circuncidartlahuaca hua̱k lactzu camán judíos tí natalakahuán a̱stá̱n. Chuná jaé acxni lakáhualh ixkahuasa Abraham Isaac circuncidartláhualh; xlá a̱stá̱n na̱ chuná tláhualh ixkahuasa tí ixuanicán Jacob, y Jacob na̱ chuná ca̱tláhualh cha̱cu̱tuy ixlakkahuasán. Jaé lacchixcuhuí̱n tama̱lacatzúqui̱lh pu̱cu̱tuy cristianos tí talama̱na nac Israel. ");
INSERT INTO topNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Xapaksta̱n ixta̱camancán ixuanicán José. Snu̱n akskalala ixuani̱t y como hua̱k ixtalakcatzaní ixli̱skalala, mejor tásta̱lh ixnata̱camán la̱ cha̱tum tachí̱n y li̱ncán nac Egipto. Pero Dios siempre maktákalhli José, ");
INSERT INTO topNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hasta Faraón rey xalac Egipto lakáti̱lh ixli̱skalala y li̱ma̱pa̱cúhui̱lh ma̱paksi̱ná xalac Egipto, na̱ macamá̱xqui̱lh cacuentájnilh la̱ta tú ixkalhí nac ixchic. ");
INSERT INTO topNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Huá jaé quilhtamacú acxni milh tatzíncsnit juú nac Canaán y nac Egipto; quili̱talakapasnicán yaj ixtacatzí tú natahuá. ");
INSERT INTO topNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Y como ixlamajcú ko̱rutzi̱n Jacob, acxni li̱ta̱chihui̱nanca ixuí trigo nac Egipto, ca̱ma̱lakácha̱lh ixlakkahuasán nataán tasquín trigo. ");
INSERT INTO topNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xlacán ni̱ ixtacatzí para ma̱paksi̱ná ixta̱camcán ixuani̱t tí ixtasta̱ni̱t, pero xlá ca̱lakápasli y acxni táalh ixli̱maktuy ca̱huánilh tú ixqui̱taxtuni̱t y Faraón rey xalac Egipto cátzi̱lh la̱ ixli̱mini̱tanchá José. ");
INSERT INTO topNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","José ma̱tiyí̱nalh ixti̱cú Jacob y hua̱k ixli̱talakapasni y chuná jaé tácha̱lh nac Egipto setenta y cinco cristianos ixli̱hua̱kcán. ");
INSERT INTO topNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Táalh quilhtamacú y juú nac Egipto ni̱lh Jacob. Ixlakkahuasán o sea quili̱talakapasnicán, na̱ tzúculh tani̱ti̱lhá. ");
INSERT INTO topNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pero ixca̱li̱ncán nac Siquem xlacata naca̱muju̱cán nac ca̱quihuí̱n ni̱ma̱ ixca̱maktama̱huani̱t Abraham ixlakkahuasan Hamor. ");
INSERT INTO topNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Dios ixamajá ma̱kantaxtí la̱ tima̱lacnú̱nilh Abraham ama ca̱ma̱xtú amá pu̱latama̱n ní chu̱ta ixca̱ma̱scujucán ixcamán, porque la̱ta ixtaliani̱t quilhtamacú snu̱n ixtalhu̱huani̱t judíos nac Egipto. ");
INSERT INTO topNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Entonces tzúculh ma̱paksi̱nán cha̱tum rey nac Egipto tí ni̱ xcatzi̱ni̱t la̱ ixca̱makta̱yani̱t José. ");
INSERT INTO topNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Xlá ni̱ ixca̱cxilhputún quili̱talakapasnicán y la̱ta ixca̱si̱tzi̱ní li̱ma̱paksí̱nalh cata̱kxtakmákalh itskatacán cani̱huá xlacata ni̱ catástacli. ");
INSERT INTO topNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","’Chuná jaé ixqui̱taxtuma nac Egipto acxni lakáhualh cha̱tum actzu skata ixuanicán Moisés. Ixnati̱cún tamá̱tze̱kli aktutu papá, ");
INSERT INTO topNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","pero como ixtajicuán para naca̱catzi̱nicán na̱ ta̱kxtakmákalh itskatacán. Pero Dios ixmaktakalhni̱t jaé skata porque táka̱sli istzuma̱t rey xalac Egipto y makástacli la̱ lihua ixkahuasa. ");
INSERT INTO topNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Huá xlacata Moisés skalálalh y catzi̱niko̱lh tú ixtacatzí egipcios; lhu̱hua tú tla̱n ixtlahuá, ixli̱pa̱huancán acxni ixchihui̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Acxni ma̱spútulh Moisés cuarenta años ca̱lakpaxiá̱lhnalh ixli̱talakapasni judíos tí ixtalakahuani̱t nac Egipto. ");
INSERT INTO topNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Aná ácxilhli la̱ cha̱tum chixcú xalac Egipto ixma̱kxtakajni̱ma̱ cha̱tum judío; xlá ni̱ lá tá̱lalh y mákni̱lh amá egipcio. ");
INSERT INTO topNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ixpuhuán: “Tla̱n la̱ cmákni̱lh porque quili̱talakapasni ama tama̱kachakxí xlacata Dios quili̱lhca̱ni̱t nacca̱tamacxtú jaé pu̱latama̱n.” Pero xlacán ni̱tú tama̱kachákxi̱lh, ");
INSERT INTO topNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","porque ixli̱cha̱lí acxni ca̱cxilhpá tara̱nicma̱na cha̱tuy judíos, xlá ca̱la̱ma̱makxtakapútulh y ca̱huánilh: “Huixín li̱ta̱camán, ¿hua̱nchi la̱nicá̱tit? ¡Ni̱ tla̱n tú tlahuapa̱nántit!” ");
INSERT INTO topNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero tí ma̱s xatlihueke ixmakatlajani̱t xa̱cha̱tum kálhti̱lh: ");
INSERT INTO topNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","“¿Ticu tasanini̱tán naquila̱huaniyá̱u tú quili̱tlahuatcán? ¿Huix juez o ma̱paksi̱ná? O ¿puhuana na̱ pa̱t quimakni̱ya la̱ makni ko̱tán cha̱tum egipcio?” ");
INSERT INTO topNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moisés jícualh y tzá̱lalh nac aktum pu̱latama̱n huanicán Madián; juú latáma̱lh la̱ tí caj makcha̱ni̱t; pero tamakáxtokli y ca̱kálhi̱lh cha̱tuy ixcamán. ");
INSERT INTO topNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Moisés ixkalhí ochenta años acxni ixlapu̱lá nac desierto lacatzú nac Monte de Sinaí. Aná ácxilhli katum quihui lhcuta̱yama y nac ixíta̱t lhcúya̱t tási̱lh cha̱tum ángel. ");
INSERT INTO topNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Xlá ma̱lacatzúhui̱lh xlacata tla̱n naca̱cní tú ixtasi̱ma; pero acxni tuncán káxmatli jaé tachihuí̱n: ");
INSERT INTO topNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Aquit Dios tí tali̱pa̱huani̱t mili̱talakapasni Abraham, Isaac y Jacob.” Moisés jicuanko̱lh acxni káxmatli amá tachihuí̱n, a̱huata quilhpu̱taj tá̱yalh. ");
INSERT INTO topNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pero Dios huanipá: “Cama̱xtu mintatu̱nu porque jaé tíyat ni̱ma̱ lácya̱t aquit cma̱tunujni̱t quilacata. ");
INSERT INTO topNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Chí cmini̱t ca̱lakma̱xtú quincamán tí cca̱lacsacni̱t y huix camá̱n ma̱lakacha̱yá̱n nac Egipto naca̱tamacxtuya, porque cca̱cxilhni̱t la̱ talakaputzá y cca̱kaxmatni̱t la̱ tahuantlija acxni ta̱kxtakajnán.” ");
INSERT INTO topNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Moisés táspitli nac Egipto porque Dios li̱ma̱páksi̱lh caca̱cpúxculh y caca̱tamácxtulh ixcamán tí ixca̱li̱ncani̱t nac Egipto ma̱squi xlacán ixtalakmakani̱t pues ixtahuanini̱t: “¿Ticu tasanini̱tán naquila̱huaniyá̱u tú quili̱tlahuatcán? ¿Huix juez o ma̱paksi̱ná?” Dios ma̱lakácha̱lh amá ángel tí ta̱chihuí̱nalh Moisés. ");
INSERT INTO topNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ca̱maktá̱yalh xlacata naca̱cpuxcún judíos catatzá̱lalh nac Egipto, y chuná tla̱n tapuntzá̱lalh amá pupunú Mar Rojo, ti̱puxum ca̱ta ca̱ta̱latapú̱li̱lh ana ní ni̱tí ixtalama̱na nac desierto xalakmaka̱n quili̱talakapasnicán, y lhu̱hua laclanca tascújut ca̱tláhualh tú ca̱li̱ma̱lacahuá̱ni̱lh xlacata natacatzí hua̱k Dios ixli̱ma̱paksi̱ni̱t tú ixtlahuá. ");
INSERT INTO topNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pi̱huá jaé Moisés ca̱huánilh judíos tí ixtatakokeni̱t: “Dios ama ca̱ma̱lakacha̱niyá̱n cha̱tum profeta la̱ aquit. Xlá ama ca̱lakma̱xtú mili̱talakapasnicán tí natalakahuán a̱stá̱n y aná nac mimpu̱latama̱ncán ama lactaxtú. Cakaxpáttit tú naca̱huaniyá̱n.” ");
INSERT INTO topNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Acxni ixca̱ta̱lapu̱lá quili̱talakapasnicán nac desierto, amá ángel tí ta̱chihuí̱nalh Moisés nac Monte de Sinaí na̱ macamá̱xqui̱lh hua̱k ixtapaksi̱t Dios la̱ ixli̱latama̱tcán judíos tí ixca̱tamacxtuni̱t nac Egipto. ");
INSERT INTO topNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero ni̱ hua̱k judíos takáxmatli y tama̱tlá̱ni̱lh tú ca̱ma̱lacnú̱nilh Moisés, y lhu̱hua ixtaspitputumpará nac Egipto ní ixtataxtuni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Huá tali̱huánilh Aarón: “Aquín ctaspitputumparayá̱u nac Egipto. Quila̱tlahuaníu aktum pu̱laktumi̱n tí naquinca̱maktakalhá̱n y naquinca̱pu̱laniyá̱n porque namá Moisés tí quinca̱tamacxtún nac Egipto aktzanka̱ni̱t.” ");
INSERT INTO topNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aarón ma̱tlá̱ni̱lh y hua̱k tamaktláhualh tantum pu̱laktumi̱n becerro. A̱stá̱n tamákni̱lh quitzistancaní̱n xlacata natali̱lakachixcuhuí. ¡Hua̱k ixtali̱pa̱xahuá tú ixtatlahuani̱t! ");
INSERT INTO topNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dios ni̱ lakáti̱lh y ca̱kxtakmákalh; ca̱li̱mákxtakli catalakachixcúhui̱lh tú ixtalacasquín, chichiní, papá y makapitzi stacu. Profeta Amós tzokli nac ixlibro la̱ ca̱li̱chihuí̱nalh Dios jaé cristianos: Ti̱puxum ca̱ta latapu̱lí̱tit nac desierto. ¿Nicu makli̱t makní̱tit quitzistancaní̱n xlacata naquila̱li̱lakachixcuhui̱yá̱u? ");
INSERT INTO topNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","¡Ni̱cxni! Pero huixín ca̱tlahuátit pu̱laktumi̱n tí naca̱cucayá̱tit. Ca̱lakachixcuhuí̱tit pu̱laktumi̱n ni̱ma̱ ca̱tlahuátit y ni̱ tastacnán ca̱cucátit: Dios Moloc, itstacu Renfán y lhu̱hua ma̱s. Huá xlacata cama ca̱macama̱sta̱yá̱n la̱ tachí̱n nac aktum pu̱latama̱n huanicán Babilonia. ");
INSERT INTO topNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Amá xalakmaka̱n quili̱talakapasnicán acxni ixtalapu̱lá cani̱huá nac desierto, cha̱tum ángel lacspí̱tnilh Moisés la̱ ixlacasquín catláhualh aktum ixpu̱lakachixcuhui̱n Dios huanicán tabernáculo; amá la̱ pu̱siculan ni̱ma̱ lacapala tla̱n ixma̱lakxtucán, ixli̱ncán cani̱huá. Aná jaé ixca̱ma̱qui̱cán chíhuix ní ixca̱tzokcani̱t ixtapaksi̱t Dios ni̱ma̱ ixma̱xqui̱ni̱t Moisés. ");
INSERT INTO topNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Cha̱lh quilhtamacú acxni judíos tata̱rá̱nicli cristianos xala a̱lacatunu pu̱latama̱n, y la̱ta ní ixtatlajá chú ixtalí̱n amá tabernáculo. Ixca̱cpuxcún Josué y chuná jaé amá pu̱lakachixcuhui̱n tamaklhti̱nantí̱lhalh la̱ herencia pu̱tunu talacstacni xalakmaka̱n quili̱talakapasnicán hasta acxni David ca̱cpúxculh judíos. ");
INSERT INTO topNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios ma̱tlá̱ni̱lh ixlatama̱t David y xlá máksquilh li̱tlá̱n para ixlacasquín catlahuánilh aktum pu̱siculan ní lacatum nalakachixcuhui̱cán Dios tí ixli̱pa̱huani̱t ixli̱talakapasnicán Jacob. ");
INSERT INTO topNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Rey David láclhca̱lh jaé talacapa̱stacni pero huá ixkahuasa Salomón xli̱ca̱na tí tlahuánilh ixpu̱siculan Dios. ");
INSERT INTO topNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ma̱squi lanca Quimpu̱chinacán Dios ni̱ lacatum tanu̱ma nac aktum pu̱siculan porque cha̱tum profeta ma̱lacpuhuá̱ni̱lh caca̱huánilh cristianos la̱ ixlacpuhuán ixlacatacán: ");
INSERT INTO topNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","¿Tucu yá chiqui ama quila̱tlahuaniyá̱u? ¿A poco ni̱ aquit ctlahuani̱t la̱ta tú anán ca̱quilhtamacú? ");
INSERT INTO topNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ni̱ catzi̱yá̱tit xlacata akapú̱n quimpu̱táhui̱lh y nac tíyat ca̱quilhtamacú cca̱ya̱huani̱t quintujún? ¿Tucu yá quimpu̱jaxni ama quila̱tlahuaniyá̱u huixín lacchixcuhuí̱n? ");
INSERT INTO topNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban ni̱ ca̱li̱quilhpúhualh amá tí ixtama̱kalhapali̱ma̱na, y ca̱huánilh: ―¿Tucu ca̱li̱macuaniyá̱n mintake̱ncán y minacujcán laktakalhi̱n lacchixcuhuí̱n? Huixín li̱tamakxtaká̱tit la̱ namá cristianos tí ni̱ talakapasa Dios porque ni̱ kaxpatá̱tit. Pues siempre ta̱ra̱lacata̱qui̱yá̱tit ixli̱tlihueke Espíritu Santo tí ma̱lakachá Dios nali̱chihui̱nán ixtalakalhamá̱n. Huixín tantum lhkamani̱tántit ixkasatcan minti̱cucán. ");
INSERT INTO topNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Xlacán tapu̱tlákalh hua̱k profetas tí ca̱ma̱lakácha̱lh Dios natali̱chihui̱nán Cristo tí ixama ca̱lakma̱xtuyá̱n. Y huixín, ¿tucu tlahuanítit Jesús tí ixlacsacni̱t Dios? ¡Liakskahuinántit y makní̱tit! ");
INSERT INTO topNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Dios ca̱ma̱lakacha̱nín ángeles xlacata naca̱huaniyá̱n hua̱k ixtapáksi̱t, pero huixín kaxpatmakaná̱tit ixtachihuí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","―¡Acs cata̱ya, chixcú! ―takalhpaktánu̱lh amá lacchixcuhuí̱n acxni takáxmatli tú ixca̱li̱ya̱huama Esteban, hasta ixtatatlaná la̱ta tasi̱tzí. ");
INSERT INTO topNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Espíritu Santo ixakchipanini̱t ixtalacapa̱stacni Esteban. Talacayá̱hualh ta̱lhmá̱n y ácxilhli ixli̱lanca Dios nac akapú̱n y Jesús ixuí nac ixpa̱xtú̱n. ");
INSERT INTO topNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Esteban ca̱huánilh amá lacchixcuhuí̱n: ―¡Chí cacxilhma la̱ lacquí akapú̱n y Jesús Xatalacsacni Chixcú huí nac ixpa̱xtu̱n Quimpu̱chinacán Dios! ");
INSERT INTO topNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aná qui̱tá̱yalh chihui̱nán Esteban porque amá lacchixcuhuí̱n pu̱tum ta̱ctahuácalh la̱ catachíyalh xlacata natama̱quilhacslí y yaj natakxmata. ");
INSERT INTO topNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Amá ma̱paksi̱naní̱n táli̱lh Esteban nac quilhapa̱n ca̱chiquí̱n; aná tatalákxtulh xala ixkalhni ixlhaka̱tcán y ca̱maktakálhnilh cha̱tum kahuasa ixuanicán Saulo. A̱stá̱n jaé lacchixcuhuí̱n tí ixtapuhuán ixkalhchiya̱nani̱t Esteban tzúculh tasaca chíhuix y tali̱ma̱xquí xlacata natamakní. ");
INSERT INTO topNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ixmacni Esteban huata ixtali̱macahuán amá chíhuix pero xlá chuné kalhtahuakánilh Dios: ―Quimpu̱chiná Jesús, lakama̱chá̱n quili̱stacni. ¡Camaklhtí̱nanti! ");
INSERT INTO topNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Acxni tuncán tzokostaj tama̱chá ca̱tiyatni y aktásalh: ―¡Quimpu̱chiná Dios, caca̱ma̱tzanke̱nani tú quintatlahuánilh jaé lacchixcuhuí̱n! Acxni tuncán ni̱ko̱lh Esteban. ");
INSERT INTO topNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Amá kahuasa Saulo ixlakatí la̱ ixmakni̱cani̱t Esteban. A̱stá̱n makapitzi judíos tí tla̱n ixtacatzí, tásacli Esteban y tamúju̱lh la̱ ixmini̱ní. Snu̱n ixtali̱lakaputzá, ixtalaktasá la̱ ixma̱kxtakajni̱cani̱t. La̱ta amá quilhtamacú tzucuca ca̱pu̱tlakacán tí ixtali̱pa̱huán Jesús. Hua̱k tzúculh tatza̱lá a̱lacatunu pu̱latama̱n; makapitzi táalh nac Judea y nac Samaria y a̱huata apóstoles tatamákxtakli nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Tí lihua ixca̱pu̱tlaká amá tí ixtali̱pa̱huán Jesús huá amá kahuasa Saulo; ¡ni̱ ixca̱cxilhputún! Ni̱ caj maktum tánu̱lh nac ixakxtakacán, ixca̱xuataxtú lacchixcuhuí̱n y lacchaján, ixca̱ma̱nú nac pu̱la̱chi̱n. ");
INSERT INTO topNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero amá cristianos tí tatzá̱lalh a̱lacatunu pu̱latama̱n la̱ta ní ixtachá̱n ixtali̱chihui̱nán la̱ Jesús ixma̱tzanke̱nán tala̱kalhí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Chuná jaé amá chixcú Felipe cha̱lh nac aktum actzú ca̱chiquí̱n ni̱ma̱ ixli̱tapaksí Samaria y aná tzúculh li̱chihui̱nán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lhu̱hua cristianos ixtatamakstoka, ixtalakatí takaxmata la̱ ixchihui̱nán, pero ni̱ caj maktum ca̱li̱ma̱lacahuá̱ni̱lh laclanca ixtascújut Dios. ");
INSERT INTO topNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Porque ixca̱ma̱ksa̱ní tí ixca̱ctanu̱ma tlajaná y acxni ixtataxtú jaé tlajananí̱n ixta̱ktasá la̱ catachíyalh. Na̱ ixca̱ma̱ksa̱ní tí ni̱ lá ixtatla̱huán o ixtalaclu̱nchu̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Amá nac ca̱chiquí̱n ni̱ ixuí cha̱tum cristiano tí ni̱ ixli̱pa̱xahuá la̱ta tú ixtlahuá Felipe. ");
INSERT INTO topNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Amá nac ca̱chiquí̱n ixlama cha̱tum brujo ixuanicán Simón. Xlá ixca̱kskahuini̱t lhu̱hua cristianos nac Samaria y xa̱huá ixli̱tanú lanca chixcú tí tla̱n ixca̱tlahuá laclanca tascújut. ");
INSERT INTO topNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Huá xlacata hua̱k cristianos ixtali̱pa̱huán hasta ixtahuán xlacata amá chixcú ma̱x Dios ixma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Maka̱s quilhtamacú amá cristianos xalac Samaria ixtakaxmatni̱t tú ixca̱huaní Simón. ");
INSERT INTO topNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero acxni tzúculh takaxmata Felipe la̱ ixli̱chihui̱nán Dios ixma̱lakacha̱ni̱t Ixkahuasa Jesucristo, tali̱pa̱hualh y lhu̱hua tata̱kmúnulh la̱ lacchixcuhuí̱n y la̱ lacchaján. ");
INSERT INTO topNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Hasta Simón na̱ ca̱nájlalh y ta̱kmúnulh, y la̱ta amá quilhtamacú tzúculh takoké Felipe xlacata naacxila la̱ ixca̱tlahuá ixtascújut pues xlá lhu̱hua tí ixca̱ma̱ksa̱ní. ");
INSERT INTO topNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nac Jerusalén ní ixtatamakxtakni̱t cha̱cu̱tuy apóstoles, acxni tacátzi̱lh xlacata cristianos xalac Samaria na̱ ixtali̱pa̱huani̱t Jesús, tama̱lakácha̱lh Pedro y Juan xlacata ma̱s natalacspi̱ta ixtachihui̱n Dios. ");
INSERT INTO topNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Acxni tácha̱lh nac Samaria tzúculh tali̱kalhtahuaká ixlacati̱n Dios amá cristianos tí ixtali̱pa̱huani̱t Jesús nac Samaria xlacata natamaklhti̱nán ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque xlacán ni̱ ixtamaklhti̱nani̱t ixli̱tlihueke Espíritu Santo huata ixtata̱kmununi̱t nac ixtacuhui̱ní Jesucristo. ");
INSERT INTO topNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","A̱stá̱n Pedro y Juan taliáclhitli ixmacancán cha̱tunu cristianos tí ixtata̱kmununi̱t y hua̱k tamaklhtí̱nalh ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Amá brujo Simón ácxilhli la̱ cristianos tamaklhtí̱nalh Espíritu Santo acxni taliáclhitli ixmacancan apóstoles. ");
INSERT INTO topNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Xlá ca̱li̱makachípalh tumi̱n y ca̱huánilh: ―Na̱ quila̱ma̱xquí̱u namá li̱tlihueke o li̱catzí̱n xlacata acxni nacliaclhita quimacán cha̱tum cristiano tla̱n namaklhti̱nán ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro kálhti̱lh: ―¡Mintumi̱n cata̱laktzanká̱n nac ca̱li̱ní̱n, tala̱kalhi̱n chixcú! ¿Nicu li̱puhuana xlacata tla̱n tama̱huacán ixli̱tlihueke Dios? ");
INSERT INTO topNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Dios ni̱ lá tú ma̱xqui̱yá̱n porque huix ni̱ tla̱n tú tlahuaya nac ixlacatí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","¿Hua̱nchi ni̱ lakmakana mintala̱kalhí̱n? Cpuhuán Dios tla̱n ixma̱tzanke̱nanín namá ni̱ lactlá̱n mintalacapa̱stacni ni̱ma̱ kalhi̱ya nac minacú. ");
INSERT INTO topNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porque puro lacli̱xcájni tapuhuá̱n kalhi̱ya y mintala̱kalhí̱n ixtachí̱n tlahuani̱tán. ¡Camáksquinti cama̱tzanke̱nanín! ");
INSERT INTO topNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón kálhti̱lh Pedro: ―Catlahuátit li̱tlá̱n quila̱li̱kalhtahuakáu ixlacati̱n Dios porque ni̱ clacasquín caquimpá̱xtokli tú quila̱huaníu. ");
INSERT INTO topNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro y Juan la̱ tatlahuako̱lh tú ixca̱ma̱macqui̱cani̱t amá ca̱chiquí̱n, tatáxtulh lhu̱hua nac lactzu̱ ca̱chiquí̱n xalac Samaria y tali̱chihuí̱nalh Jesús, y a̱stá̱n tatáspitli nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Maktum cha̱tum ángel laktá̱ctalh Felipe y huánilh: ―Nac Jerusalén taxtú kantum tijia, ti̱taxtú nac desierto y cha̱n nac ca̱chiquí̱n huanicán Gaza. ¡Chí tuncán cata̱ya y capit amá nac tijia! ");
INSERT INTO topNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe alh amá nac tijia y aná taka̱stá̱yalh cha̱tum tali̱pa̱u eunuco chixcú tí ixmini̱t lakachixcuhui̱nán nac Jerusalén. Jaé chixcú ixta̱ma̱paksi̱nán reina Candace nac ixpu̱latama̱n Etiopía, la̱ istsecretario ixuani̱t, ");
INSERT INTO topNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","y chí ixtaspitma nac ixpu̱latama̱n. Xlá curucs ixuí nac carreta ni̱ma̱ ixtama̱tla̱hualí̱n cahua̱yu, ixli̱kalhtahuakati̱lhá ixlibro profeta Isaías. ");
INSERT INTO topNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu Santo ma̱cxcatzí̱ni̱lh Felipe cama̱tá̱xtucli ixpu̱chiná amá carro y cata̱chihuí̱nalh. ");
INSERT INTO topNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Acxni ma̱lacatzúhui̱lh káxmatli tú ixli̱kalhtahuakama amá chixcú, y kalasquínilh: ―¿Ma̱kachakxi̱ya tú li̱chihui̱nán namá libro? ");
INSERT INTO topNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","―Tó̱, ni̱ cma̱kachakxí porque ni̱tí quilacspi̱tní la̱ qui̱taxtú ―kalhtí̱nalh amá chixcú, y huánilh catá̱cxtulh nac carro. ");
INSERT INTO topNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ana ní ixli̱kalhtahuakama ixlibro Isaías chuné ixuán: Li̱nca nac ixpu̱maknicán la̱ tantum manso borrego. Ni̱ para tziná takalhpítzilh xlacata natatlanca̱ní ixlacati̱ncán tí tamákni̱lh, na̱ chuná la̱ ni̱ tasá tantum borrego acxni maksitcán ixchíxit. ");
INSERT INTO topNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ni̱ cha̱tum tí maklhtí̱nalh tama̱xokó̱ni̱lh tú ni̱ ixlí̱n, ni̱ para li̱chihui̱namputu tú tatlahuánilh ixli̱talakapasni. ¿Ticu ama taquilhtla̱ní? Pues acxtum tama̱lakspútulh ixli̱stacni nac ca̱quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Amá chixcú xalac Etiopía kalasquínilh Felipe: ―¿Niculá jaé qui̱taxtú? ¿Isaías ixli̱chihui̱nama ixli̱stacni, o ixli̱chihui̱nama tunu chixcú? ");
INSERT INTO topNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","―Cama lacspi̱tniyá̱n la̱ qui̱taxtú ―kálhti̱lh Felipe. Y tzúculh li̱ta̱chihui̱nán y lacspi̱tní la̱ta tú ixqui̱taxtunini̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Acxni ixtalakatza̱lama̱na aktum actzu taxtunú amá chixcú huánilh Felipe: ―Juú huí chúchut. ¿Hua̱nchi ni̱ quiakmunuya chí tuncán? ");
INSERT INTO topNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","―Tla̱n cakmunuyá̱n para xli̱ca̱na li̱pa̱huana Jesús ixli̱hua̱k minacú. ―Jé, aquit cca̱najlá xlacata Jesucristo Ixkahuasa Dios ―kalhtí̱nalh amá chixcú. ");
INSERT INTO topNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Amá chixcú li̱ma̱paksí̱nalh caya̱huaca carreta y tatá̱ctalh ixcha̱tuycán y aná amá nac actzu taxtunú Felipe akmúnulh amá tali̱pa̱u chixcú xalac Etiopía. ");
INSERT INTO topNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Acxni tapa̱táxtulh nac tijia, Espíritu Santo li̱lh a̱lacatunu Felipe y amá chixcú yaj ácxilhli, pero pa̱xahuati̱lhá alh nac ixpu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe cha̱lh nac Azoto y tzúculh li̱chihui̱nán Jesús hua̱k nac lactzu ca̱chiquí̱n ni̱ma̱ ca̱lakatzá̱lalh hasta cha̱lh nac Cesarea. ");
INSERT INTO topNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nac Jerusalén Saulo ni̱ ixca̱li̱makxtaka ixca̱maka̱klhá cristianos tí ixtali̱pa̱huán Jesús xlacata ixama ca̱makní. Hasta alh ca̱ta̱chihui̱nán xanapuxcun ma̱paksi̱naní̱n curas ");
INSERT INTO topNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","y ca̱máksquilh li̱ma̱paksí̱n xatatzokni xlacata naán nac Damasco ca̱xuataxtú nac sinagogas hua̱k lacchixcuhuí̱n y lacchaján tí ixtali̱pa̱huán Jesús y tla̱n naca̱li̱mín tachí̱n nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hua̱k tama̱tlá̱ni̱lh y alh pakán amá ca̱chiquí̱n Damasco. Pero acxni lihua ixcha̱majá tási̱lh nac akapú̱n la̱ camáklipli, y ¡taranc! li̱tama̱ko̱lh taxkáket ní ixtla̱huama. ");
INSERT INTO topNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo pa̱tástalh nac ixcahua̱yu y takaxmáti̱lh jaé tachihuí̱n: ―Saulo, Saulo, ¿hua̱nchi quisi̱tzi̱niya? ");
INSERT INTO topNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","―¿Ticu huix quinta̱chihui̱námpa̱t? ―kalasquiní̱nalh Saulo. Amá tí ixchihui̱nani̱t kalhtí̱nalh: ―Aquit Jesús tí huix si̱tzi̱niya. ");
INSERT INTO topNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Saulo li̱cuánit jícualh, pero chihui̱nampá: ―Quimpu̱chinacán, ¿tucu lacasquina cactláhualh? ―Aquit cli̱ma̱paksi̱yá̱n cachipi nac Damasco ní ixpímpa̱t; aná pa̱t huanicana tú mili̱tláhuat ―kálhti̱lh Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Amá soldados tí ixtata̱án Saulo na̱ ixtajicuanko̱ni̱t porque ixtakaxmata amá tachihuí̱n pero ni̱ ixta̱cxila tí ixchihui̱nama. ");
INSERT INTO topNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saulo lakasu̱t tzúculh ta̱yá y tzáksalh lacahua̱nán pero lakatzí̱n ixlani̱t. Ixcompañero tamakachipáli̱lh hasta nac Damasco, talí̱cha̱lh nac ixchic cha̱tum chixcú huanicán Judas. ");
INSERT INTO topNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aná tahui aktutu chichiní la̱ta ni̱ ixlacahua̱nán, ni̱ para ixua̱yán, ni̱ para ixkotnán. ");
INSERT INTO topNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Juú nac Damasco ixlama cha̱tum chixcú tí ixli̱pa̱huán Jesús ixuanicán Ananías. Xlá tasí̱nilh Jesús y huánilh: ―¡Ananías! ―Uchu cuí, ¿tucu quili̱tlahuaya? ―kalhtí̱nalh Ananías. ");
INSERT INTO topNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jesús kálhti̱lh: ―Juú nac Damasco huí kantum calle li̱tapa̱cuhuí Derecha, aná pakán yá ixchic cha̱tum chixcú huanicán Judas. Chí tuncán calakpi y cali̱kalasquini Saulo xalac Tarso. ");
INSERT INTO topNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aquit cma̱ma̱nixni̱ni̱t Saulo y xlá acxila la̱ lakmín cha̱tum chixcú huanicán Ananías, liaclhita ixmacán y tuncán lacahua̱nán porque chí lakatzí̱n lama. ");
INSERT INTO topNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","La̱ kaxmatko̱lh tú li̱ma̱páksi̱lh Jesús, Ananías huánilh: ―Aquit ni̱ clakamputún namá chixcú la̱ quihuaniya porque ckaxmatni̱t la̱ li̱chihui̱nancán ca̱ma̱kxtakajní tí tali̱pa̱huaná̱n nac Jerusalén. ");
INSERT INTO topNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Xa̱huá ccatzi̱yá̱u xlacata huá li̱mini̱t juú nac Damasco ama ca̱chipá hua̱k tí tali̱pa̱huaná̱n y ama ca̱lí̱n nac Jerusalén pues xanapuxcun curas chú tali̱ma̱paksi̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jesús huanipá: ―Huix cakáxpatti tú cli̱ma̱paksi̱má̱n porque aquit clacsacni̱t namá chixcú xlacata naquili̱chihui̱nán ixlacati̱ncan ma̱paksi̱naní̱n, ixlacati̱ncan cristianos xalac Israel, ixlacati̱ncan cristianos xala a̱lacatunu pu̱latama̱n. ");
INSERT INTO topNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Aquit cama ma̱si̱ní la̱ ama akxtakajnán quilacata. ");
INSERT INTO topNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías tláhualh tú li̱ma̱páksi̱lh Jesús; acxni lákcha̱lh liáclhitli ixmacán y huánilh: ―Saulo, Quimpu̱chiná Dios ni̱ma̱ tasi̱nín nac tijia quima̱lakacha̱ni̱t xlacata tla̱n nalacahua̱namparaya y namaklhti̱nana ixli̱tlihueke Espíritu Santo. ");
INSERT INTO topNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Acxni tuncán Saulo maklhcátzi̱lh la̱ calacatá̱ctalh tú ixlacahuaca y tla̱n lacahuá̱nalh. ");
INSERT INTO topNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","A̱stá̱n Ananías li̱lh lacatum ana ní akmúnulh Saulo y tzucupá hua̱yán xlacata natatlihueklha. Saulo ca̱ta̱talakxtúmi̱lh cristianos tí ixtali̱pa̱huán Jesús nac Damasco, y aná ca̱ta̱latáma̱lh laktzu quilhtamacú. ");
INSERT INTO topNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Pero ni̱ ixli̱maka̱s quilhtamacú na̱ tzúculh ca̱ma̱kalhchihui̱ní cristianos nac sinagogas, ixca̱huaní: ―Jesús huá namá tí ma̱lakacha̱ni̱t Dios naquinca̱lakma̱xtuyá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tí ixtakaxmata ni̱ ixtama̱kachakxí tú ixpa̱xtokni̱t Saulo, ixtahuán: ―¡Namá chixcú chiyani̱t! ¿Ni̱ huá namá tí ni̱ ixca̱cxilhputún tí tali̱pa̱huán Jesús? ¿La̱mpara huá ixli̱mini̱t nac Damasco xlacata naca̱chipá y naca̱macama̱stá ixmacancán xanapuxcun curas nac Jerusalén? ");
INSERT INTO topNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo ni̱ ixca̱jicuaní tí ixtali̱chihui̱nán y ma̱s tancs ixli̱chihui̱nán xlacata Jesús huá Cristo tí ixma̱lakacha̱ni̱t Dios naca̱lakma̱xtú cristianos, hasta judíos tí ixtalama̱na nac Damasco ni̱ ixtacatzí tú natakalhtí. ");
INSERT INTO topNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Táalh quilhtamacú y makapitzi judíos tzúculh talaclhcá la̱ natamakní Saulo. ");
INSERT INTO topNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ca̱cuhuiní y ca̱tzisní tzúculh tascalí ní ixlactla̱huán y ní ixlactaxtucán ca̱chiquí̱n. ");
INSERT INTO topNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero Saulo acxcátzi̱lh la̱ ixmakni̱putuncán y maktum ca̱tzisní tamaktá̱yalh tí ixtali̱pa̱huán Jesús xlacata catzá̱lalh. Tamúju̱lh nac aktum lanca canasta y talacmá̱cti̱lh nac pá̱tzaps xla chíhuix ni̱ma̱ ixli̱corra̱lhcani̱t ca̱chiquí̱n. Chuná jaé tzá̱lalh y taxtúnilh Saulo. ");
INSERT INTO topNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ni̱ ixli̱maka̱s cha̱lh nac Jerusalén y ca̱lákalh cristianos tí ixtali̱pa̱huán Jesús. Xlacán ixtajicuaní para caj ixca̱kskahuiputún xlacata naca̱chipá; ni̱ ixtaca̱najlá para ixli̱pa̱huani̱t Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero Bernabé lacati̱tá̱yalh y li̱lh ixlacati̱ncan apóstoles xlacata natalakapasa. Ca̱huánilh la̱ ixtasi̱nini̱t Jesús nac tijia acxni ixama nac Damasco y la̱ ixli̱ma̱paksi̱ni̱t tú ixli̱tláhuat y a̱stá̱n ixkalhi̱ni̱t li̱camama tancs li̱chihui̱nán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Hua̱k tama̱tlá̱ni̱lh caca̱ta̱tamákxtakli Saulo nac Jerusalén y tzúculh ca̱ta̱latapu̱lí tí ixtali̱pa̱huán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Como Saulo na̱ ixma̱kachakxí tachihuí̱n griego ixca̱lacspi̱tní ixtachihui̱n Jesús, y hasta ixca̱ta̱ra̱huaní amá judíos tí ixtachihui̱nán griego; pero xlacán ni̱ ixtama̱tla̱ní, ixtamakni̱putún. ");
INSERT INTO topNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Acxni ta̱cxcátzi̱lh tú ixlaclhca̱nicani̱t Saulo, tí ixtali̱pa̱huán Jesús tama̱tzá̱li̱lh y táalh talakaxtaka nac ca̱chiquí̱n Cesarea y tama̱lakácha̱lh nac ixca̱chiquí̱n ixuanicán Tarso. ");
INSERT INTO topNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Amá cristianos xalac Judea, Galilea y Samaria tí ixtali̱pa̱huani̱t Jesús, li̱pa̱xáu ixtalama̱na porque yaj tí ixca̱ta̱ra̱slaka y ma̱s ixtali̱tahuacá cristianos; ti̱tum ixtalama̱na ixlacati̱n Dios y Espíritu Santo ixca̱makta̱yá ni̱ cata̱ktzánka̱lh. ");
INSERT INTO topNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro tza̱pu ixán nac akatunu ca̱chiquí̱n ní ixtalama̱na cristianos tí ixtali̱pa̱huán Jesús y maktum cha̱lh nac ca̱chiquí̱n huanicán Lida. ");
INSERT INTO topNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aná ta̱tánoklhli cha̱tum chixcú tí ni̱ lá ixtla̱huán ixlaclu̱nchu̱ni̱t, ixuanicán Eneas; ixkalhi̱yá aktzayán ca̱ta la̱ta ixke̱tá nac tama. ");
INSERT INTO topNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro chuné ta̱chihuí̱nalh: ―Eneas, ixli̱tlihueke Jesucristo cama̱ksa̱ní̱n. Cli̱ma̱paksi̱yá̱n catlá̱huanti y cama̱qui mixtícat. Amá chixcú tuncán aksá̱nalh y tla̱n tlá̱hualh. ");
INSERT INTO topNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Hua̱k cristianos xalac Sarón y Lida tí tacátzi̱lh la̱ aksá̱nalh Eneas, tali̱pa̱hualh Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Lacatzú nac Lida ixuí aktum ca̱chiquí̱n ixuanicán Jope. Juú ixlama cha̱tum pusca̱t tí na̱ ixli̱pa̱huán Jesús ixuanicán Tabita y nac griego tachihuí̱n ixuanicán Dorcas. Xlá ixca̱lakalhamán pobres ixca̱makta̱yá acxni tla̱n. ");
INSERT INTO topNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Xlá chípalh tá̱tat lacapala y ni̱lh. Makapitzi tapáxi̱lh y tama̱lháke̱lh ixlháka̱t y táli̱lh nac ixli̱quilhmactuy ixchic y aná tamá̱pi̱lh nac ca̱punchaká̱n. ");
INSERT INTO topNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jaé cristianos ixtacatzí xlacata Pedro ixmini̱t nac Lida y tama̱lakácha̱lh makapitzi lacchixcuhuí̱n xlacata catahuánilh camilh nac Jope. ");
INSERT INTO topNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro ca̱tá̱alh y acxni cha̱lh li̱nca ana ní ixmá amá xani̱n pusca̱t. Lhu̱hua lacchaján ixtatasama̱na y tama̱sí̱nilh Pedro lháka̱t ni̱ma̱ ixca̱ma̱squihui̱ni̱t acxni ixlamajcú. ");
INSERT INTO topNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro ca̱huánilh catatáxtulh hua̱k cristianos; a̱stá̱n tatzokóstalh y tzúculh kalhtahuakaní Dios. La̱ kalhtahuakako̱lh li̱ma̱páksi̱lh amá xani̱n pusca̱t: ―¡Dorcas, calacastacuánanti! ¡Dorcas lacastacuánalh ca̱li̱ní̱n! Lakasu̱t tzúculh ma̱lakaké ixlakastapu y pu̱la Pedro ácxilhli. Tzáksalh ta̱quí; ");
INSERT INTO topNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","xlá makachípalh y yá̱hualh. A̱stá̱n ca̱tasánilh hua̱k cristianos y viudas xlacata nata̱cxila Dorcas xastacnán. ");
INSERT INTO topNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tú ixtlahuani̱t Pedro tacátzi̱lh hua̱k cristianos xala amá ca̱chiquí̱n y lhu̱hua tali̱pá̱hualh Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro latáma̱lh nac Jope laktzu quilhtamacú nac ixchic cha̱tum chixcú huanicán Simón ixli̱scuja ixca̱ma̱sca̱cá ixmakxu̱hua quitzistancaní̱n. ");
INSERT INTO topNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nac ca̱chiquí̱n Cesarea ixlama cha̱tum tali̱pa̱u capitán ixuanicán Cornelio ixca̱cpuxcún pu̱tum soldados tí ixtali̱tapa̱cuhuí “Italianos”. ");
INSERT INTO topNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio y hua̱k ixli̱talakapasni ixtatzaksá talatamá la̱ ixli̱ma̱paksi̱nán Dios; xlá ixca̱makta̱yá tí ni̱tú ixtakalhí y ni̱ ixli̱makxtaka kalhtahuakaní Dios. ");
INSERT INTO topNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Maktum smalankán como a las tres de la tarde acxni ixkalhtahuakanima Dios, staranca ácxilhli la̱ lakata̱yachi cha̱tum ángel y huánilh: ―¡Cornelio! ");
INSERT INTO topNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Xlá jicuanko̱lh y huata acs lacá̱nilh, pero tíyalh li̱camama y kalasquínilh: ―Señor, ¿tucu quili̱tlahuaya? Amá ángel kálhti̱lh: ―Dios lakati̱ni̱t la̱ kalhtahuakaniya y la̱ ca̱makta̱yaya xa̱makapitzi tí ma̱s ca̱tzanka̱ní. ");
INSERT INTO topNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Huá xlacata li̱ma̱paksi̱yá̱n caca̱ma̱lakacha makapitzi lacchixcuhuí̱n nac ca̱chiquí̱n xla Jope y catali̱kalasquiní̱nalh Simón pero li̱lakapascán Pedro. ");
INSERT INTO topNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Xlá lama nac ixchic cha̱tum chixcú huanicán Simón y li̱scuja ma̱sca̱cá ixmakxu̱hua quitzistancaní̱n y yá ixchic ixquilhtu̱n pupunú. Catahuánilh camilh lakapaxia̱lhnaná̱n y xlá ama huaniyá̱n tú mili̱tláhuat. ");
INSERT INTO topNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","La̱ anko̱lh amá ángel Cornelio ca̱tasánilh cha̱tuy ixtasa̱cua y cha̱tum soldados tí tla̱n ixcatzí y ma̱s ixca̱li̱pa̱huán. ");
INSERT INTO topNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Tla̱n ca̱lacspí̱tnilh tú ixacxilhni̱t y tú ixli̱ma̱paksi̱cani̱t y tuncán ca̱ma̱lakácha̱lh nac Jope. ");
INSERT INTO topNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Ixli̱cha̱lí tastúnut ya̱ ixtachá̱n amá lacchixcuhuí̱n tí ixca̱ma̱lakacha̱ni̱t Cornelio, Pedro istzucumajá tzincsa y li̱huán ixtlahuama̱ca ixtahuá; tá̱cxtulh ixaksti̱n chiqui pues xlá chíhuix ixuani̱t; aná tzúculh kalhtahuakaní Dios. ");
INSERT INTO topNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Pero acxni tuncán la̱ calakachiyá̱nalh ácxilhli la̱ talácqui̱lh akapú̱n y tzúculh ta̱ctá aktum paklanca lháka̱t ixtachi̱ni̱t ixcha̱stu̱ni̱tni. ");
INSERT INTO topNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ixtatanu̱ma̱na ti̱pa̱katzi quitzistancaní̱n ni̱ma̱ ixca̱li̱huanicán catáhualh judíos; ixtataju̱ma̱na catu̱ya̱huá quitzistancaní̱n hasta ni̱ma̱ ixtali̱tla̱huán ixpa̱ncán y ni̱ma̱ takosa. ");
INSERT INTO topNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pedro káxmatli jaé tachihuí̱n: ―Pedro, camakni xani̱ma̱ta quitzistanca lacasquina y cali̱huá̱yanti. ");
INSERT INTO topNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro kálhti̱lh: ―To̱, aquit ni̱cxni cuani̱t li̱xcájnit quitzistanca. ");
INSERT INTO topNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Amá tí ixchihui̱nama huanipá: ―Ni̱ cali̱macapi li̱xcájnit tú ma̱tla̱ni̱ni̱t Dios. ");
INSERT INTO topNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pedro maktutu li̱lacahuá̱nalh istzaksacán ma̱hui̱cán amá quitzistancaní̱n; a̱stá̱n ta̱cxtupá nac akapú̱n amá paklanca lháka̱t. ");
INSERT INTO topNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro tzúculh liakatuyún tú ixli̱lacahua̱nani̱t. Ixlacpuhuán tucu ixuamputún umá tú li̱ma̱lacahuá̱ni̱lh Dios o tucu ixlacasquín catláhualh. Amá lacchixcuhuí̱n tí ixca̱ma̱lakacha̱ni̱t Cornelio ixtataka̱sni̱t ákxtaka, ixtaya̱na nac puhui̱lhta. ");
INSERT INTO topNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ixtali̱kalasquini̱nama̱na para aná ixlama Pedro. ");
INSERT INTO topNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nac ixaksti̱n chiqui Pedro ni̱ ixcatzí tú ixuamputún amá tú ixli̱lacahua̱nani̱t, acxni huánilh Espíritu Santo: ―Cha̱tutu lacchixcuhuí̱n tamini̱t talacaputzayá̱n. ");
INSERT INTO topNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lacapala cata̱cta, caca̱ta̱chihuí̱nanti y caca̱ta̱pi ní natahuaniyá̱n porque aquit cca̱ma̱lakacha̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xlá tá̱ctalh y acxni ca̱ta̱tánoklhli amá lacchixcuhuí̱n ca̱huánilh: ―Aquit namá chixcú tí putzapa̱nántit. ¿Tucu quila̱li̱tlahuayá̱u? ");
INSERT INTO topNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Xlacán takálhti̱lh: ―Quinca̱ma̱lakachá̱n capitán Cornelio. Namá chixcú tzaksá tancs latamá ixlacati̱n Dios y lhu̱hua judíos xalac Cesarea talakalhamán. Pero ko̱tán acxni ixkalhtahuakanima Dios ma̱lakachá̱nilh cha̱tum ángel y li̱ma̱páksi̱lh cacmíu ca̱lacaputzayá̱n y cacca̱ta̱án nac ixchic xlacata nakaxmata tú pa̱t huaniya. ");
INSERT INTO topNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","―Para chuná qui̱taxtuni̱t cha̱lí nacca̱ta̱aná̱n, pero jaé ca̱tzisní juú catamakxtáktit ―ca̱huaniko̱lh Pedro. Ixli̱cha̱li tzisa tatáxtulh nac Jope, na̱ tatakókelh makapitzi tí ixtali̱pa̱huán Jesús. ");
INSERT INTO topNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pero hasta ixli̱cha̱lí tácha̱lh nac Cesarea. Cornelio ixca̱kalhi̱ma, ixca̱ma̱makstokni̱t hua̱k ixli̱talakapasni y xalactali̱pa̱u ixamigos xlacata natalakapasa Pedro. ");
INSERT INTO topNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Acxni cha̱lh Pedro nac ixchic Cornelio, xlá táxtulh y tatzokostánilh xlacata nalakachixcuhuí. ");
INSERT INTO topNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Pedro yá̱hualh y huánilh: ―Ni̱ caquintatzokostani, aquit ni̱ Dios, aquit chixcú la̱ huix. ");
INSERT INTO topNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Cornelio tá̱yalh y la̱ta takalhchihui̱nanti̱lhá tatánu̱lh ní ixtahuila̱na xa̱makapitzi. ");
INSERT INTO topNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pedro chuné chihuí̱nalh: ―Aquit ni̱cxni cca̱lakpaxia̱lhnani̱t nac ixchiccán tí ni̱ judíos porque huixín catzi̱yá̱tit xlacata QuiDioscán chú quinca̱li̱ma̱paksi̱yá̱n. Pero chí pi̱huá namá QuiDios quima̱cxcatzí̱nilh xlacata ni̱ cacli̱máca̱lh li̱xcájnit cati̱hua cristiano ni̱ma̱ xlá ma̱tla̱ni̱ni̱t. ");
INSERT INTO topNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Huá xlacata acxni pítit quila̱lacaputzayá̱u sok cca̱lakmín. Chí quila̱huaníu, ¿tucu quila̱li̱tlahuayá̱u? ");
INSERT INTO topNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio kálhti̱lh: ―Ta̱timayá chichiní la̱ chí aquit xackalhtahuakanima Dios la̱ cli̱smani̱ni̱t como a las tres de la tarde acxni quilakata̱yachi la̱ cha̱tum chixcú makslipua ixlháka̱t, ");
INSERT INTO topNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","y quihuánilh: “Cornelio, Dios lakati̱ni̱t la̱ kalhtahuakaniya y la̱ ca̱makta̱yaya xa̱makapitzi tí ma̱s ca̱tzanka̱ní. ");
INSERT INTO topNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Huá xlacata li̱ma̱paksi̱yá̱n caca̱ma̱lakacha makapitzi lacchixcuhuí̱n nac Jope, y catali̱kalasquiní̱nalh Simón y li̱lakapascán Pedro. Xlá lama nac ixchic cha̱tum chixcú huanicán Simón y yá ixchic ixquilhtu̱n pupunú li̱scuja ma̱sca̱cá ixmakxu̱hua quitzistancaní̱n. Catahuánilh camilh lakpaxia̱lhnaná̱n, xlá ama huaniyá̱n tú mili̱tláhuat.” ");
INSERT INTO topNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aquit tuncán cca̱ma̱lakácha̱lh quintasa̱cua nata̱ná̱n talacaputzayá̱n y cli̱pa̱xahuá la̱ sok tani̱ta nac quínchic. Chí clacasquiná̱u quila̱huaníu tú li̱ma̱paksi̱ni̱tán Dios, porque aquín aktum cuili̱ni̱táu quintapuhua̱ncán. ");
INSERT INTO topNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pedro chuné tzúculh ca̱ma̱kalhchihui̱ní: ―Chí tancs cma̱kachakxi̱ni̱t xlacata Dios ca̱lakalhamán ni̱ huata cristianos judíos, ");
INSERT INTO topNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","xlá na̱ ca̱lakalhamán hua̱k cristianos xala cani̱hua pu̱latama̱n para lactlá̱n tacatzí y tama̱kantaxtí tú li̱ma̱paksi̱nán. ");
INSERT INTO topNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Huixín ma̱x catzi̱yá̱tit xlacata Dios ca̱ma̱lacnú̱nilh xalakmaká̱n quili̱talakapasnicán xalac Israel ixama ma̱lakachá cha̱tum tí ixa