﻿USE sofia;
DROP TABLE IF EXISTS sofia.tooNT_vpl;
CREATE TABLE tooNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tooNT_vpl WRITE;
INSERT INTO tooNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Huā'mā' lista ū'tza' ixnapapna' Jesucristo lā' xla' ixtā'nat David lā' nā Abraham. ");
INSERT INTO tooNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Lā' Abraham ixtāta' Isaac ixuanī't lā' ū'tza' ixtāta' Jacob lā' ū'tza' ixtāta'ca'n Judá lā' ixtā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Lā' Judá ixtāta'ca'n Fares lā' Zara ixuanī't lā' ixtzī'tca'n ixuanican Tamar. Lā' Fares ixtāta' Esrom ixuanī't lā' ū'tza' ixtāta' Aram. ");
INSERT INTO tooNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lā' Aram ixtāta' Aminadab ixuanī't lā' ū'tza' ixtāta' Naasón a'ntī ixtāta' Salmón. ");
INSERT INTO tooNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Lā' Salmón ixtāta' Booz ixuanī't lā' ixtzī't Booz ū'tza' Rahab. Lā' Booz ixtāta' Obed ixuanī't lā' ixtzī't Obed ixuanican Rut. Lā' Obed ixtāta' Isaí ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Lā' Isaí ixtāta' huan rey David ixuanī't. Lā' huan rey David lā' huan puscāt a'ntī pū'la ixpuscāt Urías ixuanī't, xlaca'n xanatātana' Salomón ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Lā' Salomón ixtāta' Roboam ixuanī't lā' ū'tza' ixtāta' Abías a'ntī ixtāta' Asa. ");
INSERT INTO tooNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Lā' Asa ixtāta' Josafat ixuanī't lā' Josafat ixtāta' Joram lā' ū'tza' ixtāta' Uzías. ");
INSERT INTO tooNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Lā' Uzías ixtāta' Jotam ixuanī't lā' ū'tza' ixtāta' Acaz lā' ū'tza' ixtāta' Ezequías. ");
INSERT INTO tooNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Lā' Ezequías ixtāta' Manasés ixuanī't lā' ū'tza' ixtāta' Amón a'ntī ixtāta' Josías. ");
INSERT INTO tooNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Lā' Josías ixtāta'ca'n Jeconías lā' ixtā'timīn ixuanī't lā' a'xni'ca' ixcāchī'canī't lā' cālē'nca huan israelitas nac ti'ya't a'nlhā huanican Babilonia. ");
INSERT INTO tooNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Lā' a'xni'ca' cālē'ncanī'ttza' a'xni'ca' Jeconías ixka'lhī ixcaman Salatiel lā' ū'tza' ixtāta' Zorobabel ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Lā' Zorobabel ixtāta' Abiud ixuanī't lā' ū'tza' ixtāta' Eliaquim a'ntī ixtāta' Azor. ");
INSERT INTO tooNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Lā' Azor ixtāta' Sadoc ixuanī't lā' ū'tza' ixtāta' Aquim a'ntī ixtāta' Eliud. ");
INSERT INTO tooNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Lā' Eliud ixtāta' Eleazar ixuanī't lā' ū'tza' ixtāta' Matán a'ntī ixtāta' Jacob. ");
INSERT INTO tooNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Lā' Jacob ixtāta' ixuanī't huan José a'ntī ixkōlu' huan María. Lā' María, xla' ixtzī't Jesús ixuanī't, ū'tza' a'ntī huanican huan Cristo. ");
INSERT INTO tooNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Lā' chuntza' ixlīkalhacāujtā'ti' ī'xū'yātā'natna' Abraham a'xni'ca' tahuī'lh David. Lā' ixlīkalhacāujtā'ti' ī'xū'yātā'natna' David a'xni'ca' ixcālē'ncanī't israelitas nac huan ti'ya't a'nlhā huanican Babilonia. Lā' ixlīkalhacāujtā'ti' ī'xū'yātā'natna' huampala a'xni'ca' lacatuncuī'lh Cristo. ");
INSERT INTO tooNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Lā' a'xni'ca' tahuī'lh Jesucristo, chuntza' pātle'kelh. Ixtzī't ixuanican María lā' xla' ixtalacāxlanī'ttza' para natā'tapūchahua huan José. Lā' a'xni'ca' tūna'j ixtalātā'tahui'la a'xni'ca' María ixcamalanī'ttza' lā' por ixlīmāpa'ksīn huan Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lā' a'xni'ca' José ca'tzīlh que María ixcamalanī't, xla' ixmakxtekcu'tun. Pero como tzeyā chi'xcu' ixuanī't, tū' ixmālacapū'cu'tun na ixlacapūnca'n tachi'xcuhuī't como tū' ixmāmāxanī'cu'tun. Xmān tzē'k ixmakxtekcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Lā' a'xni'ca' José ixpāstacmā' a'nchī nalīlacāxtlahua, a'xni'ca' lakahuāna'lh lā' tasu'yuni'lh kalhatin ángel a'ntī macamilh huan Māpa'ksīni' Dios lā' xla' huanilh: ―José, hui'x a'ntī ī'xū'yātā'nat David, tū' catilīmā'xa'na' natā'tapūchahua'ya' huan María como ka'lhīni'lh por ixpālacata huan Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Naka'lhī ixcaman xachi'xcu' lā' nahui'lī'ni'ya' ixtacuīni' Jesús. Chuntza' namāpācuhuī'can como xla' nacāmāpūtaxtū ixtachi'xcuhuī't ―huanilh huan ángel. ");
INSERT INTO tooNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lā' huāk huā'mā' pātle'kelh para natlōkentaxtū a'ntū hualh huan Māpa'ksīni' Dios por ixpālacata huan a'cta'sana'. Chuntza' tzo'kli: ");
INSERT INTO tooNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Huan tzu'ma'jāt naka'lhīni'n lā' naka'lhī ixcaman lā' namāpācuhuīcan Emanuel, lā' huā'mā' tacuīni' huanicu'tun: Dios quincātā'lahui'lani'. ");
INSERT INTO tooNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lā' a'xni'ca' lakahualh José, tlahualh ixlīhuāk a'ntū māpa'ksīlh huan ixángel huan Māpa'ksīni' lā' tā'tapūchahualh María. ");
INSERT INTO tooNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero tū' xa'malh hasta a'xni'ca' xla' tahuī'lh ī'ska'ta' ixlīmaksāsti'. Lā' hui'līni'lh ixtacuīni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lā' a'xni'ca' Herodes rey ixuanī't nac ti'ya't a'nlhā huanican Judea a'xni'ca' Jesús lacatuncuīlh a'ntza'. Lacatuncuīlh huan nac cā'lacchicni' a'nlhā huanican Belén. Lā' tachā'lh magosnu' huan nac xcānsipej a'nlhā huanican Jerusalén lā' xlaca'n tamincha' na ixtankēn ");
INSERT INTO tooNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","lā' takalhasqui'nīlh: ―¿Lhachū huī' huan ixreyca'n israelitas a'ntīn tahuī'lhtza'? Quina'n iclaktzī'nī'tauj lakatin sta'cu na ixtankēn. Lā' ū'tza' quincāmāsu'ni'nī'ta'ni' palh tahuī'lhtza'. Lā' ū'tza' iclīmiujtza' huā'tzā' para na'icmācā'tanīyāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lā' a'xni'ca' kaxmatli huā'mā' tachihuīn, huan rey Herodes lej ixpāta'lamā' lā' nā chuntza' ixlīhuākca'n xalanī'n nac Jerusalén nā ixcāpāta'lamā'. ");
INSERT INTO tooNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Lā' huan rey cāmāta'satīnīni'lh lā' cāmākēstokli ixlīhuākca'n xanapuxcu'nu' sacerdotes israelitas lā' a'ntī tamāsu'yulh huan ley. Lā' cākalhasqui'nīca lhachū natahui'la huan Cristo ");
INSERT INTO tooNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","lā' takalhtīni'lh: ―Natahui'la nac Belén xala' nac estado de Judea. Chuntza' tzo'kli huan a'cta'sana': ");
INSERT INTO tooNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Lā' Belén xala' huan ti'ya't a'nlhā huanican Judá, a'yuj lej xati'na'j na ixlaclhni'ca'n huan municipios nac huā'mā' ti'ya't, pero līhua'ca' tasqui'nī como nalacatuncuīyācha' a'ntza' kalhatin māpa'ksīni'. Lā' xla' nacāmaktaka'lha quintachi'xcuhuī't a'ntī cāhuanican israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lā' Herodes lakatzē'k cāmāta'satīnīni'lh huan magosnu' lā' cākalhasqui'nīlh lhānīn tasu'yulh huan sta'cu lā' tūyā chi'chini' lā' tūyā mālhcuyu'. ");
INSERT INTO tooNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lā' cāmacā'lh nac Belén lā' cāhuanilh: ―Capinchipitit lā' nalīhui'lī'yā'tit naputzayā'tit huan ska'ta'. Lā' a'xni'ca' nakaksā'tit, naquilāmāca'tzīnīyāuj para que quit nā tzē na'ica'n na'icmācā'tanī ―chuntza' cāhuanilh Herodes. ");
INSERT INTO tooNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Lā' a'xni'ca' cātā'chihuīna'nkō'lh huan rey, ta'a'lh huan magosnu'. Lā' huan sta'cu a'ntū ixtalaktzī'nī't ixtankēn, ū'tza' cāpū'lani'lh lā' cāmāsu'ni'lh huan tej hasta lhā tāyalh tālhmā'n a'nlhā ixuī' huan ska'ta'. ");
INSERT INTO tooNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Lā' a'xni'ca' huan magosnu' talaktzī'lh a'nchī tāyalh huan sta'cu, lej tapāxuhualh xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lā' a'xni'ca' tatanūlh huan nac chic, talaktzī'lh huan ska'ta' lā' María a'ntī ixtzī't. Lā' tatatzokostani'lh lā' tataquilhpūtani'lh lā' tamācā'tanīlh huan ska'ta'. Lā' tamakxcutli huan a'ntū ixtalē'ni' lā' ta'a'ksajli oro lā' pūm lā' perfume a'ntū huanican mirra. ");
INSERT INTO tooNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Lā' ā'calīstān tataspi'tchokolh por ā'kantin tej como ixtalakahuāna'nī't lā' chuntza' cālīmāca'tzīnīca que tū' catatētaxtulh a'ntza' na ixchic Herodes. ");
INSERT INTO tooNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","A'xni'ca' ixta'a'nī'ttza' huan magosnu', José lakahuāna'lh lā' tasu'yuni'lh kalhatin ángel a'ntū macamilh huan Māpa'ksīni' Dios. Lā' huan ángel huanilh: ―Catāqui'. Cacālī'pi huan ska'ta' lā' ixtzī't lā' catzā'la'tit nac huan país a'nlhā huanican Egipto. A'ntza' natachokoyā'tit hasta a'xni'ca' na'icmāca'tzīnīyāni' porque huan Herodes, xla' naputza huan ska'ta' como maknīcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Lā' José tāquī'lh a'xni'ca' tzī'sacus ixuanī't lā' a'lh. Cālē'lh huan ska'ta' lā' ixtzī't. Ta'a'lh huan nac ti'ya't a'nlhā huanican Egipto. ");
INSERT INTO tooNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A'ntza' tatachokolh hasta a'xni'ca' nīlh huan Herodes. Huā'mā' pātle'kelh para natlōkentaxtū a'ntū huan Māpa'ksīni' Dios ixuanī't por ixpālacata huan a'cta'sana'. Chuntza' hualh: “Ixuī' nac Egipto qui'O'kxa' lā' icmāta'sīlh”. ");
INSERT INTO tooNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lā' a'xni'ca' Herodes ca'tzīlh palh ixta'a'kxokonī't huan magosnu', xla' lej a'kchā'lh. Lā' māpa'ksīni'lh que cacāmaknīca huan lakska'tā'n a'ntī xachi'xcu'. Cāmāmaknīnīni'lh ixlīhuākca'n huan camana' xachi'xcu' xalanī'n nac Belén lā' ixlīka'tla' huan cālacchicni'. Cāmāmaknīnīni'lh ixlīhuākca'n a'ntīn tūna'j ixtaka'lhī lakatu' cā'ta. Chuntza' māpa'ksīlh como ixtlahuanī'ttza' hua'chi lakatu' cā'ta desde a'xni'ca' ixlacatuncuīnī't huan ska'ta' chu a'nchī tahualh huan magosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chuntza' tlōkentaxtūlh a'ntū tzo'kli huan a'cta'sana' a'ntī ixuanican Jeremías. Chuntza' tzo'kli: ");
INSERT INTO tooNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kaxmatcan a'nchī calhuancan huan nac cā'lacchicni' a'nlhā huanican Ramá lā' lej ta'sacan. Raquel ū'tza' a'ntī calhuamā' ixpālacata ixcamana'. Lā' tūla māko'xamixīcan como ixtanīnī'ttza'. Chuntza' tzo'kli. ");
INSERT INTO tooNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero a'xni'ca' ixnīnī'ttza' huan Herodes, José lakahuāna'mpā a'nlhā ixuī' nac Egipto. Lā' tasu'yuni'lh kalhatin ángel a'ntī macamilh huan Māpa'ksīni' Dios lā' huanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Catāqui' lā' cacālī'pi huan ska'ta' lā' ixtzī't. Lā' cataspi'ttit huan nac ti'ya't a'nlhā huanican Israel porque tanīlhtza' xlaca'n a'ntī ixtamaknīcu'tun huan ska'ta' ―hualh huan ángel. ");
INSERT INTO tooNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Lā' José tāquī'lh lā' a'lh lā' cālē'lh huan ska'ta' lā' ixtzī't hasta nac Israel. ");
INSERT INTO tooNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero Arquelao a'ntī ixlaktapalh ixtāta' Herodes ixuanī't lā' ixmāpa'ksīni'mā' a'nlhā huanican Judea. Lā' a'xni'ca' José ca'tzīlh huā'mā', ixjicua'n lā' tū' ixa'ncu'tun a'ntza'. Lā' a'xni'ca' lakahuāna'mpā, māca'tzīnīca a'nlhā ixta'a'lh lā' ū'tza' talī'a'lh huan nac ti'ya't a'nlhā huanican Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lā' a'xni'ca' tachā'lh a'ntza' nac Galilea, ta'a'lh huan nac cā'lacchicni' a'nlhā huanican Nazaret para natalatahui'la. Chuntza' pātle'kelh para natlōkentaxtū a'ntū tahualh huan a'cta'sana'nī'n. Tahualh: “Jesús namāpācuhuīcan nazareno”. ");
INSERT INTO tooNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lā' huanmā'na quilhtamacuj milh nac cā'lhpi'mpi'li' ti'ya't nac Judea huan Juan a'ntī ixmā'kpaxīni'n. Ixa'cta'sana'mā' ");
INSERT INTO tooNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","lā' ixcāhuani huan tachi'xcuhuī't: ―Caxtāpalī'tit mintapāstacna'ca'n lā' camakxtektit mintalaclē'i'ca'n porque tapajtzūmā' a'xni'ca' Dios nacāmāpa'ksīkō' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Lā' huan a'cta'sana' Isaías tzo'kli a'nchī huan tachi'xcuhuī't nataxtāpalī ixtapāstacna'ca'n lā' natakalhlaka'ī'. Lā' tzo'kli ixpālacata huā'mā' Juan a'nlhā huan chuntza': A'ntza' a'nlhā cā'lhpi'mpi'li' ti'ya't, nakaxmatcan catīhuā a'ntī palha' nachihuīna'n lā' nahuan: “Cacāxtlahua'tit huan tej como mimā' huan Māpa'ksīni'. Stu'nc camālakstu'nctit huan tej”. ");
INSERT INTO tooNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Lā' ixlu'xu' huā'mā' Juan līcāxtlahualh ixchi'xit camello lā' ixlīchī'can de ko'xka' ixuanī't. Lā' xla' ixua' hui'qui'lī't lā' ta'xcāt xala' nac cā'qui'huī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Lā' huan tachi'xcuhuī't xalanī'n nac xcānsipej Jerusalén tamilh takaxmata. Lā' nā lhūhua' tachi'xcuhuī't xalanī'n chu xalhā huan nac estado de Judea lā' xalanī'n pajtzu huan pūxka Jordán nā tamilh takaxmata. ");
INSERT INTO tooNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Lā' a'xni'ca' tatako'xaspi'tni'lh Dios ixtalaclē'i'ca'n, Juan cāmā'kpaxīlh kalhatunu' huan nac pūxka Jordán. ");
INSERT INTO tooNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Lā' lhūhua' fariseosnu' lā' ixsacerdotes israelitas tamilh ta'a'kpaxa. Lā' a'xni'ca' Juan cālaktzī'lh, xla' cāhuanilh: ―¡Ca'tzanca'tzīyā'tit hui'xina'n! ¿Tichū cāmāca'tzīnīni' hui'xina'n que ixtzā'la'ni'tit huan ixtā'kcha Dios a'ntū mimā'? ");
INSERT INTO tooNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Catlahua'tit a'ntūn tzey para que natasu'yu palh stu'ncua' xtāpalīnī'ta'ntittza' mintapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Lā' tū' cahuantit mē'cstuca'n: “Quina'n ī'xū'yātā'natna' Abraham. U'tza' iclīpāhuanāuj lā' tū' icjicua'ni'yāuj ixtā'kcha Dios”. Hui'xina'n tū' chuntza' ixua'ntit. Quit iccāhuaniyāni' que Dios tzē nacāxtāpalī huā'mā' chihuixni' lā' natala ī'xū'yātā'natna' Abraham. ");
INSERT INTO tooNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hua'chilh xacacanī'ttza' huan ā'chaj lā' natzucucan natancā'can huan qui'hui'. Lā' chuxatūya qui'hui' a'ntūn tū' māstā' ixtō'ca't xatzey, ū'tza' natancā'can lā' nalhcuyucan. Huan tachi'xcuhuī't a'ntīn tū' tatasu'yu palh takalhlaka'ī', xlaca'n hua'chi huan qui'hui' a'ntūn tū' tō'ca'. ");
INSERT INTO tooNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Lā' stu'ncua' quit iccālīmā'kpaxīyāni' con xcān. Lā' ū'tza' nalītasu'yu a'nchī līlakaputzayā'tit ixpālacata huan talaclē'i' a'ntūn tlahuanī'ta'ntit. Huan a'ntī namin ā'calīstān, xla' makapitzīn de hui'xina'n nacātalīmā'kpaxīyāni' huan Espíritu Santo lā' ā'makapitzīn huampala con macscut. Xla' ā'līhua'ca' māpa'ksīni'n que quit. Quit tūla icmālacastuca xla'. Ixtasācua' a'ntī naxcuta ixuarachi līhua'ca' tasqui'nī que quit. ");
INSERT INTO tooNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Xla' hua'chi kalhatin chi'xcu' a'ntī chi'panī'ttza' ixpūmālakosūn lā' nalacsu'nu huan trigo a'ntū lītlahuacan harina. Huan xati'ni' trigo namānū a'nlhā māquī'can, pero huan xapa'lhma' nalhcuyu huan nac macscut a'ntūn tūla catimāmixīlh ―cāhuanilh Juan. ");
INSERT INTO tooNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Lā' ā'calīstān Jesús taxtulh de huan estado de Galilea lā' lakchā'lh Juan a'nlhā ixmā'kpaxīni'mā' na ixquilhtūn huan pūxka Jordán. Jesús milh a'kpaxa. ");
INSERT INTO tooNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pū'la Juan tū' ixmā'kpaxīcu'tun Jesús lā' huanilh: ―Quit icmaclacasqui'n que hui'x ixquimā'kpaxi'. Hui'x tū' maclacasqui'na' quit na'icmā'kpaxīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesús kalhtīlh: ―Chuhua'j calalh chu a'nchī icsqui'ni'yāni' porque quincāminīni'yāni' lā' chuntza' natlahuakō'yāuj a'ntū Dios māpa'ksīlh. Lā' Juan a'kahuāna'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Lā' Jesús, a'xni'ca' mā'kpaxīca, tacutli huan nac xcān. Lā' chu līmaktin talaquī'lh huan a'kapūn lā' Jesús laktzī'lh huan Espíritu Santo. Lā' ixtasu'yu hua'chi tantzasnān. Lā' yujchi ixlakstu'nc a'nlhā ixyā Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Lā' kaxmatca lakatin tachihuīn nac a'kapūn lā' hualh: ―U'tza' huā'mā' qui'O'kxa'. Lej icpāxquī' lā' lej quimakapāxuhua. ");
INSERT INTO tooNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Lā' tuncan huan Espíritu Santo lē'lh Jesús huan nac cā'lhpi'mpi'li' ti'ya't para que huan ko'ti'ti' nalīlaktzī'n a ver palh tzē ixtlajalh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Lā' a'ntza' tu'pu'xam chi'chini' Jesús tū' huā'yalh tintacuj lā' tintascac. Lā' lejtza' ixtzi'ncsa. ");
INSERT INTO tooNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Lā' huan ko'ti'ti' laktapajtzūlh Jesús lā' huanilh: ―Palh hui'x ixO'kxa' Dios, cacāmāpa'ksi' huā' tamā'na chihuixni' catalalh pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Lā' Jesús kalhtīlh: ―Tatzo'kni' na ixtachihuīn Dios: “Tū' xmān pāntzi catipūlatā'kchokoca nac huā'mā' cā'quilhtamacuj. Ixlīhuāk a'ntū Dios huan, ū'tza' a'ntū quincālīmaxquī'yāni' quinquilhtamacujca'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tuncan huan ko'ti'ti' lē'lh Jesús huan nac Jerusalén a'nlhā nā māpācuhuīcan huan xcānsipej santo. Lā' hui'līca tālhmā'n na ixa'kstīn huan xaka'tla' lītokpān ");
INSERT INTO tooNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","lā' huanica: ―Palh hui'x ixO'kxa' Dios, cata'nchi como tatzo'kni' na ixtachihuīn Dios: Dios nacāmāpa'ksī ixángeles que natamaktaka'lhāni'. Natamā'kaquī'yāni' para que tū' natakāhuī'ya' nīn kantin mintojon nac chihuix. ");
INSERT INTO tooNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Lā' Jesús kalhtīlh: ―Nā chuntza' tatzo'kni' na ixtachihuīn Dios: “Tū' tilīlaktzī'na' huan Māpa'ksīni' Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lā' huan ko'ti'ti' lē'mpā nac lakatin kēstīn a'nlhā lej tālhmā'n. Lā' a'ntza' māsu'ni'kō'lh chu xalhā a'nlhā cāmāpa'ksīcan xalanī'n huā'mā' cā'quilhtamacuj lā' a'nchī lej tzēhuanī't ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Lā' huan ko'ti'ti' huanilh: ―Huāk huā'mā' na'icmaxquī'yāni' xmān naquintatzokostani'ya' lā' naquimācā'tanī'ya' ―huanica Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Lā' Jesús kalhtīni'lh: ―Catapānu', ko'ti'ti', porque tatzo'kni' na ixtachihuīn Dios: “Natatzokostani'ya' lā' namācā'tanī'ya' miMāpa'ksīni' Dios lā' natlahua'ya' xmān a'ntū xla' lacasqui'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lā' tuncan huan ko'ti'ti' a'kxtekui'līlh. Lā' makapitzīn ángeles tamilh lā' tamaktaka'lhli Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lā' Jesús a'xni'ca' māca'tzīnīca a'nchī ixchī'canī't Juan, tuncan a'lh nac estado de Galilea ");
INSERT INTO tooNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","lā' tū' tachokolh nac Nazaret. A'lh tahui'la huan nac cā'lacchicni' Capernaum pajtzu na ixquilhtūn huan xcān. Lā' nā huā'mā' ti'ya't ixmāpācuhuīcan ixti'ya'tca'n Zabulón lā' Neftalí. ");
INSERT INTO tooNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Huā'mā' pātle'kelh para natlōkentaxtū a'ntū tzo'kli huan profeta Isaías na ixtachihuīn Dios. Chuntza' tzo'kli: ");
INSERT INTO tooNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Huan ti'ya't a'nlhā māpācuhuīcan Zabulón lā' a'nlhā māpācuhuīcan Neftalí, a'ntza' tētaxtu huan tej a'ntū a'n hasta nac mar. Lā' nā a'ntza' tintacut huan pūxka Jordán nac estado de Galilea a'nlhā tahui'lāna' huan a'ntīn tū' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Huan tachi'xcuhuī't hua'chilh ixtahui'lāna' a'nlhā cā'pucsua' lā' chuhua'j talaktzī'lh huan ka'tla' pūmaksko. Lā' xlaca'n a'ntī hua'chilh ixtanīmā'na lā' huāk lej cā'skē'k ixtahuanī't. Lā' chuhua'j talaktzī'lh a'nchī lej xkaka. Chuntza' tzo'kli Isaías. ");
INSERT INTO tooNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lā' tuncan Jesús tzuculh a'cta'sana'ntā'kchoko lā' hualh: ―Calīlakaputza'tit ixpālacata huan talaclē'i' a'ntūn tlahuanī'ta'ntit lā' caxtāpalī'tit mintapāstacna'ca'n porque tapajtzūmā'tza' a'xni'ca' Dios nacāmāpa'ksīkō' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lā' a'xni'ca' Jesús ixlatlā'huan na ixquilhtūn xaka'tla' xcān a'ntū huanican Lago de Galilea, cālaktzī'lh kalhatu' chi'xcuhuī'n a'ntī lītā'timīn ixtahuanī't. Kalhatin Simón ixuanican lā' ixlītāpātu' ixtacuīni' Pedro. Huan ā'kalhatin Andrés ixuanican. Xlaca'n squī'tī'ni'nī'n ixtahuanī't lā' ixtamojōmā'na ixpūxuākna'ca'n nac xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tuncan Jesús cāhuanilh: ―Caquilāstālani'uj lā' na'iccāmāsu'ni'yāni' a'nchī nacālīmākalhlaka'ī'nī'yā'tit tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Chu tuncan tamakxtekli ixpūxuākna'ca'n lā' tatā'a'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lā' a'xni'ca' a'lh ā'lacatin, cālaktzī'lh ā'kalhatu' huampala lītā'timīn. Xlaca'n ixo'kxa'n Zebedeo ixtahuanī't lā' ixtacuīni' kalhatin Jacobo lā' ā'kalhatin Juan. Ixtatā'hui'lāna' ixtāta'ca'n huan nac barco lā' ixtalacachī'mā'na ixpūxuākna'ca'n. Lā' Jesús cāmāta'sīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Lā' chu līmaktin xlaca'n tatacutli huan nac barco lā' ta'a'kxtekui'līlh ixtāta'ca'n lā' ta'a'lh tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Lā' Jesús ixtlā'huantēlha chu xalhā nac estado de Galilea lā' ixcāmāsu'ni'mā' tachi'xcuhuī't na ixlītokpānca'n israelitas nac lakatunu' cā'lacchicni'. Ixcāmāsu'ni'mā' a'nchī nala a'nlhā Dios māpa'ksīni'n lā' ixcāmātzeyīmā' ixlīhuākca'n huan tāpālhūhua' ta'jatat a'ntū ixcāpasanī't tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Chuxalhā nac huan ti'ya't a'nlhā huanican Siria cāmāca'tzīnīca ixpālacata Jesús. Lā' cālīmini'ca ixlīhuākca'n huan ī'tzaca'nī'n. Cālīmini'ca a'ntī ixtapātīmā'na chuxatūya ta'jatat lā' chuxatūya taca'tzāt. Lā' cālīmini'ca a'ntī ixtaka'lhī huan tlajana'nī'n lā' huan a'ntī ixtaxtacnānī lā' huan a'ntī ixtalū'ntū'lanī't. Lā' Jesús cāmātzeyīkō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lā' līlhūhua' xalanī'n nac estado de Galilea tastālani'lh lā' nā xalanī'n nac huan cā'lacchicni' Decápolis lā' Jerusalén. Lā' nā tastālani'lh xalanī'n nac estado de Judea lā' xalanī'n nac huan ti'ya't tintacut huan pūxka Jordán. ");
INSERT INTO tooNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lā' a'xni'ca' Jesús cālaktzī'lh a'nchī tamilh lhūhua' tachi'xcuhuī't, xla' tā'cxtulh huan nac ti'na'j kēstīn lā' a'ntza' tahui'lalh. Lā' ī'sca'txtunu'nī'n tuncan talītamacxti'li'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Lā' Jesús tzuculh cāmāsu'ni'. Lā' chuntza' Jesús cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n palh u'cxca'tzīyā'tit que tū' tzey hui'xina'n lā' lej tzey a'nchī Dios cālakalhu'manāni' a'yuj tū' tzey hui'xina'n. Nalīpāxuhua'yā'tit porque Dios cāmāpa'ksīmā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n palh lakaputza'yā'tit ixpālacata huan mintalaclē'i'ca'n o ixpālacata chuxatū catūhuā porque Dios nacāmāko'xamāka'tlī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'ntīn tū' līka'tla'jca'tzīyā'tit nīn tuntū' porque ixlīhuāk huan ti'ya't milaca'n nahuan. ");
INSERT INTO tooNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'ntī lej lacuan lacu'tunā'tit na ixlacapūn Dios hua'chi huan a'ntī tzi'ncsa putza ixtahua'. Dios nacāmaktāyayāni' lā' chuntza' lej lacuan nala'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'ntī cālakalhu'manā'tit ā'makapitzīn porque nā Dios nacālakalhu'manāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'ntī xmān lakatin mintapāstacna'ca'n lā' ū'tza' a'nchī nalīmakapāxuhua'yā'tit Dios. Nalīpāxuhua'yā'tit porque nac a'kapūn nalaktzī'nā'tit Dios calacan. ");
INSERT INTO tooNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'ntī cāmāko'xamixī'yā'tit tachi'xcuhuī't a'ntīn talā'a'kchā'ni'. Nalīpāxuhua'yā'tit porque nacātamā'pācuhuī'yāni' ixcamana' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'yuj pātīni'mpā'na'ntit xmān porque tlahua'pā'na'ntit ixtapuhuān Dios. Nalīpāxuhua'yā'tit porque Dios cāmāpa'ksīmā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Ka'lhī'yā'tit a'ntū nalīpāxuhua'yā'tit hui'xina'n a'xni'ca' tachi'xcuhuī't cātalakapalayāni' lā' cātamātakāhuī'yāni' lā' lej cātalē'ksa'nīni'nāni' tāpālhūhua' a'ntūn tū' stu'ncua'. Capāxuhua'tit a'xni'ca' cātatlahuani'yāni' chuntza' xmān porque quilāstālani'uj. ");
INSERT INTO tooNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lej capāxuhua'tit como nac a'kapūn māquī'canī't a'ntū mila'ca'n nala lā' ū'tza' lej lhūhua' ixtapalh. Nā chu a'cxtim cāmāpātīnīca huan ixa'cta'sana'nī'n Dios xalanī'n makāntza'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lā' Jesús cāhuanipā: ―Hui'xina'n hui'lā'na'ntit nac huā'mā' quilhtamacuj para nacāmāsuni'yā'tit huan tachi'xcuhuī't a'nchī tzey natala. U'tza' hua'chi matzat a'ntū lītlahuacan quinī't para que tzey nala lā' tū' napu'csan. Palh huan matzat tū'tza' ka'lhī ixlīsko'ko' tūlatza' catimāsko'kō'palaca. Tū'tza' tzey para nīn tuntū'. Xmān namaka'ncan lā' nalacchi'ntacan. ");
INSERT INTO tooNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nā hui'xina'n hui'lā'na'ntit nac huā'mā' quilhtamacuj para nacāmāsca'tīyā'tit tachi'xcuhuī't a'nchī natalīlatā'kchoko. Hui'xina'n hua'chi pūmaksko a'ntū māxkakē huan nac cā'quilhtamacuj. Lakatin xcānsipej tālhmā'n huan nac kēstīn tū' catimātzē'kca. ");
INSERT INTO tooNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Lā' nīn tū' catimāquilhtīca huan pūmaksko lā' tuncan nalē'kchocan lakatin chā'xta. Más tzey mā'ca'can tālhmā'n lā' chuntza' tzē nacāmāxkakē ixlīhuākca'n a'ntīn tatanūmā'na huan nac chic. ");
INSERT INTO tooNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chuntza' hui'xina'n xa'nca nalatā'kchokoyā'tit na ixlacapūnca'n tachi'xcuhuī't para que xlaca'n natamācā'tanī quinTāta'ca'n nac a'kapūn ixpālacata huan xatzey a'ntū tlahua'pā'na'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Lā' Jesús cāhuanipā: ―Tū' capuhua'ntit palh icminī't na'icmāpānū huan ley a'ntū maxquī'ca Moisés nīn a'ntūn tatzo'kli huan profetas. Tū' chuntza' ictitlahualh. Quit iccāmāsu'ni'cu'tunāni' a'nchī natlōkentaxtūyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Stu'ncua' a'ntū iccāhuaniyāni' que līhuan tahui'lāna'cus huan a'kapūn lā' huan ti'ya't, tū' catixapaca nīn macsti'na'j huan ley. Tū' catixapaca nīn tuntū' a'xni'ca' tūna'j natlōkentaxtūkō'can ixlīhuāk a'ntū napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Chuntza' palh catīhuā namākēnū macsti'na'j a'ntū māpa'ksī huan ley como puhuan que tū' lej tasqui'nī, xla' nala xastancu a'nlhā Dios māpa'ksīkō' ixlīhuāk. Lā' palh chuxatī a'ntī nacāmāsu'ni' ā'makapitzīn que tzē natamākēnū lakatin ley como tū' tasqui'nī, nā xla' nala xastancu a'nlhā Dios māpa'ksīkō' ixlīhuāk. Lā' palh catīhuā na'a'kahuāna'ni' huan ley lā' nā nacāmāsu'ni' ā'makapitzīn a'nchī xlaca'n nata'a'kahuāna'ni', xla' lej tasqui'nī a'nlhā Dios māpa'ksīni'n nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chuntza' iccāhuaniyāni' que maclacasqui'n natlahua'yā'tit a'ntū stu'ncua' ixtapuhuān Dios. Lā' palh tū' tasu'yu que cā'a'kapalhkā'yā'tit a'nchī ixlītzey huan xamākalhtō'kē'ni'nī'n huan ley lā' huan fariseosnu', hui'xina'n tū' catitanū'tit a'nlhā Dios māpa'ksīkō' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Lā' Jesús cāhuanipā: ―Hui'xina'n kaxpa'tnī'ta'ntittza' a'nchī cāhuanica xalanī'n makāntza': “Tū' catima'knī'ni'. Lā' palh catīhuā a'ntī namaknīni'n nalīyāhuacan lā' xla' namāpala con Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Lā' quit iccāhuaniyāni' que palh catīhuā na'a'kchā'ni' ā'chā'tin, nalīyāhuacan. Lā' xla' namāpala con Dios. Lā' catīhuā a'ntī nalakapala ā'kalhatin nā xla' namāpala con Dios. Lā' catīhuā a'ntī namacapulhca ā'kalhatin lā' nahuani: “Idiota”, xla' tzē nalhcuyucan nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Chuntza' a'xni'ca' lī'pimpā't a'ntū na'a'ksajuī'ya' Dios lā' palh napāstaca a'nchī tlahuani'nī'ta' a'ntūn tū' tzey ā'kalhatin, ");
INSERT INTO tooNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","namakxteka'chi nac pūmacamāstā'n huan lē'ksajna'. Pū'la napina' namāko'xami'xī'ya' huan ā'kalhatin lā' ā'calīstān nataspi'ta' para na'a'ksajuī'ya' a'ntū ixlī'pimpā't. ");
INSERT INTO tooNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Lā' palh catīhuā mālacapū'yāni' lā' lē'ncu'tunāni' nac pūchihuīn, lej tzey palh palaj nalacāxla'yā'tit līhuancus pimpā'na'ntit nac tej. Lā' palh tū' chuntza' natlahua'ya', a'xni'ca' mintu'ca'n nachipinā'tittza', nalē'nāni' na ixlacapūn huan juez. Lā' ū'tza' nacāmacamaxquī'yāni' policía lā' xlaca'n natachī'yāni' lā' natamānūyāni' nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Icuaniyāni' que tū' nataxtuyāchi hasta a'xni'ca' namāpalakō'ya' ixlīhuāk huan tumīn. ");
INSERT INTO tooNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Lā' Jesús cāhuanipā: ―Hui'xina'n kaxpa'tnī'ta'ntittza' a'nchī ixuancan pū'la: “Tū' catimakpuscātīni'”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Lā' quit iccāhuaniyāni' que chuxatī a'ntī lej nalaktzī'n kalhatin puscāt para napuhuan que natā'lhtatacu'tun, ū'tza' chu a'cxtim hua'chilh ixtā'lhtatanī'ttza' como chuntza' pāstacna'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Palh milakastapun xala' milacacāna'j nalaktzī'n catīhua' lā' ū'tza' nalīmātlahuīyāni' talaclē'i', namaxtuya' lā' namaka'na'. Tū' tzey palh napina' nac pūpātin ixpālacata milakastapun. Más tzey ī'sputni'ni' milakastapun lā' namāpūtaxtūca'na'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Lā' palh mimacacāna'j natlahua talaclē'i', cacā'tē't lā' cama'ka'. Tū' tzey palh napina' nac pūpātīn ixpālacata mimacan. Más tzey ī'sputni'ni' mimacan lā' namāpūtaxtūca'na'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Lā' Jesús cāhuanipā: ―Nā pū'la ixuancan: “Catīhuā a'ntī namakxteka ixpuscāt maclacasqui'n naxapa huan nac registro”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Lā' quit iccāhuaniyāni' que a'xni'ca' naxapacan huan nac registro lā' palh huan puscāt tū' ka'lhī ixtatā'chihuīn, ū'tza' tū' tzey. Chuntza' mātlahuī makchi'xcunu'n huan puscāt a'xni'ca' natapūchahuapala. Lā' huan chi'xcu' a'ntī natā'tapūchahua huanmā' puscāt, xla' namakpuscātīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Lā' Jesús cāhuanipā: ―Nā kaxpa'tnī'ta'ntittza' a'nchī ixcāhuanican xalanī'n makāntza': “A'xni'ca' lej stu'ncua' hua'na' para nalacāxtlahua'ya' huan catūhuā, Dios laktzī'mā'ni' lā' tasqui'nī natlōkentaxtūya'”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero quit iccāhuaniyāni' que tū' catihua'ntit: “Por Dios”, ixpālacata ā'catūhuā. Makapitzīn tahuan: “Por los cielos”, a'xni'ca' talacāxtlahua catūhuā. Chuntza' tū' tzey como huan a'kapūn, ū'tza' a'nlhā Dios huī'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lā' ā'makapitzīn tahuan: “Por la tierra”. Chuntza' tū' tzey como huan ti'ya't hua'chilh a'nlhā Dios cāmājaxī ixtojon. Lā' ā'makapitzīn huampala tahuan: “Por Jerusalén”. Chuntza' tū' tzey como Jerusalén ū'tza' ixā'lacchicni' huan Rey más xaka'tla'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Lā' ā'makapitzīn huampala tahuan: “Por mi cabeza”. Chuntza' tū' tzey como xmān Dios ca'tzi lhānīn napu'n ixmūsasatca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Stu'ncua' calalh a'xni'ca' nahua'nā'tit “u'huē” o “tū'”. Lā' chuntza' tū' maclacasqui'n nahua'nā'tit ā'catūhuā huampala. Huan tamā'na ā'makapitzīn tachihuīn nacāquilhtaxtuyāni' ixpālacata huan ko'ti'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Lā' Jesús cāhuanipā: ―Hui'xina'n kaxpa'tnī'ta'ntittza' a'nchī pū'la ixuancan: “Palh namātakāhuī'ya' ixlakastapun ā'chā'tin, nalīmāpala'ya' milakastapun. Lā' nalīmāpala'ya' mintatzan ixtatzan ā'kalhatin a'ntū māyujū'ni'”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Lā' quit iccāhuaniyāni': Tū' catitapalāna'ni'lh huan a'ntīn tlahuani'nī'ta'ni' a'ntūn tū' tzey. Palh catīhuā ixlacala'sni' mimpāxtūcāna'j, natamakxteka' nalacala'sāni' mimpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Lā' palh catīhuā ixmālacapū'ni' lā' namaklhtīcu'tunāni' mincamisa, nā natamakxteka' nalē'n mintakēnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Lā' palh catīhuā ixsāmācu'quī'ni' ixmaleta lakatin kilómetro, nacu'ca'pala'ya' ā'lakatin kilómetro. ");
INSERT INTO tooNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","A'xni'ca' catīhuā nasqui'ni'yāni' catūhuā, namaxquī'ya' lā' tū' catikē'pini' catīhuā a'ntī maksācua'cu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Lā' Jesús cāhuanipā: ―Nā kaxpatnī'ta'ntittza' a'nchī pū'la ixuancan: “Nacāpāxquī'ya' mi'amigos pero tū' maclacasqui'n nacāpāxquī'ya' mintā'ca'tza”. ");
INSERT INTO tooNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Lā' quit iccāhuaniyāni': Cacāpāxquī'tit mintā'ca'tzaca'n lā' nasqui'ni'yā'tit Dios que cacāsicua'lanālīlh xlaca'n a'ntī cātamacapūlhcayāni'. Cacāmaktāya'tit xlaca'n a'ntīn tū' cātalaktzī'ncu'tunāni' lā' catā'chihuīna'tit Dios ixpālacataca'n xlaca'n a'ntī cātalakapalayāni' lā' cātamāpātīnīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chuntza' tasu'yu que hui'xina'n ixcamana' quinTāta'ca'n xala' nac a'kapūn. Dios māchi'chinīni'n huan chi'chini'. Lā' chu a'cxtim talaktzī'n huan chi'chini' ixlīhuākca'n tachi'xcuhuī't, a'yuj tzey lā' a'yuj tū' tzey xlaca'n. Lā' Dios macamin xcān para ixlīhuākca'n tachi'xcuhuī't a'yuj ta'a'kahuāna'ni' lā' a'yuj tū' ta'a'kahuāna'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Lā' palh xmān nacāpāxquī'yā'tit xlaca'n a'ntī cātapāxquī'yāni', ¿tichū cuenta natlahua huā'mā'? Chuntza' tatlahua chuxatīyā ā'makapitzīn a'ntīn tū' tzey hua'chi huan mātā'jīni'nī'n impuesto. ");
INSERT INTO tooNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Lā' palh xmān nacāmālakacuhuīnī'yā'tit mintā'macchicca'n, ¿chu ka'tla' catūhuā tlahua'nī'ta'ntit? Xlaca'n a'ntīn tū' tastālani' ixtej Dios nā chuntza' tatlahua. ");
INSERT INTO tooNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Lā' chuntza' hui'xina'n cala'tit xalacuan chu a'cxtim hua'chi quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Lā' Jesús cāhuanipā: ―Lā' a'xni'ca' natlahua'yā'tit a'ntūn tzey o namaktāya'yā'tit ā'kalhatin para natlōkentaxtūyā'tit ixtapuhuān Dios, tzē'k natlahua'yā'tit. Tū' catitlahua'tit cā'lacapūlhūhua' para nacātalaktzī'nāni'. Palh cā'lacapūlhūhua' natlahua'yā'tit, quinTāta'ca'n xala' nac a'kapūn tū' caticāmaxquī'ni' nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chuntza' a'xni'ca' nacāmaktāya'yā'tit huan a'ntīn tamaclacasqui'n, tū' caticāhua'ni'tit ā'makapitzīn a'ntūn tlahua'pā'na'ntit. Xlaca'n a'ntīn tatlahua lakatu' ixlacanca'n tatlahua a'ntūn tzey nac cā'tejen lā' na ixlītokpānca'n israelitas. Chuntza' tatlahua para que tachi'xcuhuī't nacāmāka'tlī'. Stu'ncua' a'ntū iccāhuaniyāni que a'xni'ca' cālaktzī'ncan, ū'tza' hua'chi ixtatlajca'n a'ntū natamaklhtīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Lā' hui'xina'n, a'xni'ca' nacāmaktāya'yā'tit huan a'ntīn tamaclacasqui'n, tū' catimakxtektit nīn tintī' naca'tzī a'nchī cāmaktāya'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Más tzey tzē'k nacāmaktāya'yā'tit. Lā' quinTāta'ca'n nalaktzī'n a'ntūn tzē'k tlahua'yā'tit lā' xla' nacāmaxquī'yāni' mintatlajca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Lā' Jesús cāhuanipā: ―Lā' makatunu' nakalhtō'ka'ni'yā'tit Dios, tū' catitla'hua'tit chu a'nchīn tatlahua xlaca'n a'ntīn tatlahua lakatu' ixlacanca'n. Xlaca'n tatāya na ixlītokpānca'n israelitas lā' nac cā'tejen a'nlhā nacālaktzī'ncan a'xni'ca' takalhtō'ka'mā'na. Stu'ncua' a'ntū iccāhuaniyāni' que a'xni'ca' cālaktzī'ncan, ū'tza' hua'chi ixtatlajca'n a'ntū natamaklhtīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero a'xni'ca' hui'xina'n nakalhtō'ka'yā'tit, catanū'tit na minchicca'n lā' camālacchō'tit lā' mē'cstuca'n nakalhtō'ka'yā'tit lā' natā'chihuīna'nā'tit quinTāta'ca'n a'ntīn tū' laktzī'ncan. Lā' quinTāta'ca'n xala' nac a'kapūn nalaktzī'n a'ntūn tzē'k natlahua'yā'tit lā' xla' nacāmaxquī'yāni' mintatlajca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Lā' capāstactit a'xni'ca' natlahua'yā'tit mi'oracionca'n, lā' tū' maklhūhua' nahua'nā'tit a'ntū hua'nī'ta'ntittza'. Chuntza' tatlahua huan tamā'na a'ntīn tū' talakapasa Dios. Tapuhuan palh Dios nacākaxmata ixpālacata huan lhūhua' tachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tū' catila'tit hua'chi xlaca'n. QuinTāta'ca'n nac a'kapūn ca'tzītza' a'ntū hui'xina'n maclacasqui'nā'tit a'xni'ca' tūna'j squi'ni'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Chuntza' natā'chihuīna'nā'tit Dios: QuinTāta'ca'n a'ntī hui'lachi' nac a'kapūn, ca'a'cnīni'ni'ca'. ");
INSERT INTO tooNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Camilh a'xni'ca' natzucuya' nacāmāpa'ksī'kō'ya' huan tachi'xcuhuī't. Catlahuaca mintapuhuān huā'tzā' nac ti'ya't chu a'cxtim hua'chi nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Caquilāmaxquī'uj chuhua'j quilīhua'tca'n a'ntū icmaclacasqui'nāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Caquilāmāsputūnu'ni'uj a'ntū iccālaclē'ni'yāni' como iccāmāsputūnu'ni'yāuj huan tamā'na' a'ntī quincātalaclē'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tū' camakxtekti naquincāpātle'keni'yāni' a'ntū naquincāmātlahuīyāni' talaclē'i'. Xmān hui'x xaMāpa'ksīni' lā' mila' ixlīhuāk huan līmāpa'ksīn lā' ixlīhuākca'n natamācā'tanīyāni' para pō'ktu. Amén. ");
INSERT INTO tooNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Palh hui'xina'n nacāmāsputūnu'ni'yā'tit ā'makapitzīn a'ntī cātatlahuani'yāni' a'ntūn tū' tzey, nā quinTāta'ca'n xala' nac a'kapūn nā nacāmāsputūnu'ni'yāni' a'ntūn tlahuanī'ta'ntit a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Lā' palh hui'xina'n tū' nacāmāsputūnu'ni'yā'tit ā'makapitzīn, lā' tū' caticāmāsputūnu'ni'ni' mintalaclē'i'ca'n quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Lā' Jesús cāhuanipā: ―Lā' a'xni'ca' tū' nahuā'ya'nā'tit tintacuj para natā'chihuīna'nā'tit Dios, tū' catila'tit hua'chi xlaca'n a'ntīn tatlahua lakatu' ixlacanca'n. Xlaca'n ta'a'cpūtō'ca' lhca'ca'n lā' tū' talakacha'ka'n para que nacālaktzī'ncan lā' naca'tzīcan palh tū' tahuā'yan. Stu'ncua' a'ntū iccāhuaniyāni' que xlaca'n taka'lhītza' ixtatlajca'n a'xni'ca' tasu'yu que tū' tahuā'yalh. ");
INSERT INTO tooNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Hui'xina'n tū' catitla'hua'tit chuntza'. A'xni'ca' tū' huā'ya'nā'tit tintacuj para natā'chihuīna'nā'tit Dios, calakacha'ka'ntit lā' xa'nca caxqui'ttit miya'jca'n ");
INSERT INTO tooNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","lā' chuntza tū' catica'tzīca palh tū' huā'ya'nā'tit. Xmān quinTāta'ca'n xala' nac a'kapūn naca'tzī a'ntūn tzē'k tla'hua'yā'tit lā' xla' nacāmaxquī'yāni' mintatlajca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Lā' Jesús cāhuanipā: ―Tū' catilacasqui'ntit lhūhua' tumīn lā' ā'catūhuā xala' nac huā'mā' quilhtamacuj. Huan tzī'ya' lā' huan xumpepe tzē natamālakuanī a'ntū xala' nac quilhtamacuj. Lā' tzē naka'lhancan mintumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más tzey calacasqui'ntit a'ntū nala milaca'n nac a'kapūn. A'ntza' huan tzī'ya' lā' huan xumpepe tūlalh catitamāsputūlh lā' tūlalh catitatanūlh ka'lhāna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Lā' pō'ktu pāstaclacapinā'tit a'nlhā huī' huan a'ntū lej tasqui'nīni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Lā' Jesús cāhuanipā: ―Milakastapunca'n hua'chi lakatin ixpūmaksko mimacni'ca'n. Palh tū' tampi'lhīni'nā'tit lā' palh laktzī'nā'tit a'ntūn tamaclacasqui'n ā'makapitzīn, ū'tza' hua'chilh tzey milakastapunca'n lā' hua'chilh huāk xkakana' na mimacni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Lā' palh xmān laktzī'nā'tit a'ntū maclacasqui'nā'tit hui'xina'n mē'cstuca'n, lej lactampi'lhni' lanī'ta'ntit. U'tza' hua'chilh tū' tzey milakastapunca'n lā' hua'chilh huāk cā'pucsua' na mimacni'ca'n. Palh tū' tzey ixpūmaksko mimacni'ca'n, ā'chulā' cā'pucsua' nala. Lā' a'nlhā cā'pucsua' tū' ca'tzīcan lhā a'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Lā' Jesús cāhuanipā: ―Nīn tintī' tzē natā'scuja kalhatu' ixpatrón como nalaca'ī' kalhatin lā' tū' catilaca'ī'lh ā'kalhatin. Lā' na'a'kahuāna'ni' kalhatin lā' nalakmaka'n ā'kalhatin. Lā' nā chuntza' hui'xina'n tūla nalīpāhua'nā'tit Dios palh nalīpāhua'nā'tit huan mintumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Lā' Jesús cāhuanipā: ―U'tza' iccālīhuaniyāni' chuhua'j: Tū' ticāpāta'layāni' ixpālacata huan līhua't a'ntū maclacasqui'nā'tit para nalatahui'layā'tit. Lā' tū' tilē'capinā'tit ixpālacata huan lu'xu' a'ntū maclacasqui'n mimacni'ca'n. Dios cāmaxquī'ni' minquilhtamacujca'n lā' mimacni'ca'n a'ntū napūscujā'tit. Lā' ū'tza' nacālīmaxquī'yāni' chuxatū a'ntū namaclacasqui'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Cuenta catlahua'tit huan spūnnu' a'ntūn takosnū'n. Xlaca'n tū' tacha'n nīn tuntū', nīn tamakalana'n lā' tū' taka'lhī ixpūcuxi'ca'n. Lā' quinTāta'ca'n xala' nac a'kapūn cāmāhuī'. Lā' hui'xina'n līhua'ca' mintapalhca'n que huan spūnnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Lā' ¿tichū na milaclhpu'nanca'n tzē natahui'la más makān xmān porque lej nalē'ca'a'n? ");
INSERT INTO tooNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Lā' ¿a'chī' cāpāta'layā'ni' ixpālacata a'ntū nalhakā'yā'tit? Camaksca'ttit huan xa'nat a'nchīn talīstaca nac cā'tacuxtu. Tū' tascuja lā' tū' tatza'pa' ixlu'xu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Lej tzēhuanī't tastaca a'yuj tuntū' tatlahua. Lā' iccāhuaniyāni' que huan rey Salomón tūlalh cāmālacastucli ixlītzēhuanī't huan xa'nat. Lā' xla' lej rico ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","A'nan chi'tin nac cā'tacuxtu a'ntūn tzēhuanī't pero lakalī tū'xama'n nacā'ī'can lā' nacālhcuyucan. Lā' como Dios cāmaktaka'lha lā' cāmakastaca huan chi'tin a'ntū palaj nascōhuan, ā'chulā' nacāmaktaka'lhāni' hui'xina'n. Lā' ¿a'chī' tū' kalhlaka'ī'yā'tit huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Chuntza' tū' tilē'capinā'tit lā' tū' catihuantit: “¿Tuchū nahua'yāuj? Lā' ¿tuchū nalīko'tnūnāuj? Lā' ¿chichū na'iclīlhakā'nanāuj?” ");
INSERT INTO tooNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Huan a'ntī xalanī'n huā'mā' cā'quilhtamacuj pō'ktu chuntza' tahuan lā' pō'ktu chuntza' tapuhuan. Pero hui'xina'n ka'lhī'yā'tit kalhatin minTāta'ca'n nac a'kapūn lā' xla' xa'nca ca'tzī a'ntū maclacasqui'nā'tit lakalīyān. ");
INSERT INTO tooNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Xapū'la nalē'capinā'tit a'nchī namakxtekā'tit Dios nacāmāpa'ksīkō'yāni' lā' nalē'capinā'tit a'nchī nalīmakapāxuhua'yā'tit Dios. Xla' nacāmaxquī'yāni' ixlīhuāk a'ntū maclacasqui'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lakatunu' chi'chini' naka'lhī'yā'tit a'ntū nacāpāta'layāni'. Chuntza' tū' catitamakchuyī'tit chuhua'j a'ntū nacāpātle'keni'yāni' lakalī como chuntza' tūla xa'nca cuenta tlahua'yā'tit huā'mā' chi'chini'. Lā' ixlīlakalī nacāpāta'lapalayāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Lā' Jesús cāhuanipā: ―Tū' caticā'a'ksa'ntit ā'makapitzīn lā' Dios tū' nacājuzgarlīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chu a'nchī hui'xina'n cā'a'ksa'nā'tit ā'makapitzīn, chu a'cxtim Dios nacājuzgarlīyāni'. Palh hui'xina'n nalāmāsputūnu'ni'yā'tit, nā Dios nacāmāsputūnu'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chichū tzē nalaktzī'na' huan ti'na'j pa'lhma' na ixlakastapun mintā'tin palh tanūma' hua'chi kentin qui'hui' na milakastapun? ");
INSERT INTO tooNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Palh tū' pū'la maxtuya' huan qui'hui' na milakastapun, tūlalh catima'xtuni' huan pa'lhma' na ixlakastapun mintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Tlahua'pā't lakatu' milacan! Palh hui'x tlahua'ya' a'ntūn tū' tzey, tūlalh catimaktāya' ā'kalhatin a'ntīn tlahua a'ntūn tū' tzey. Maclacasqui'n cuenta natlahua'ya' pū'la a'nchī latā'kchokoya' hui'x lā' chuntza' tzē namaktāya'ya' ā'kalhatin para que xa'nca nalatā'kchoko. ");
INSERT INTO tooNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’A'nan tachi'xcuhuī't a'ntī ixlaktaca'n lej ko'hua'jua' ixtapāstacna'ca'n. Lā' palh xlaca'n tū' tlakaj takaxmatcu'tun ixtachihuīn Dios, tū' caticāmāsu'ni'tit. Xmān nata'a'kchā'n lā' nacātatucscu'tunāni' hua'chi chichi' a'ntū lej xcana'n. Santo ixtachihuīn Dios. Lā' palh tachi'xcuhuī't tū' takaxmatcu'tun, tū' caticāmāsu'ni'tit xlaca'n. Tū' catita'a'cnīni'ni'lh ixtachihuīn Dios. Xlaca'n hua'chi lakatin pa'xni' a'ntū nalacchi'nta a'ntū lej tapala. ");
INSERT INTO tooNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lā' Jesús cāhuanipā: ―Casqui'ni'tit Dios lā' xla' nacāmaxquī'yāni'. Caputzatit a'ntū Dios cāmaxquī'cu'tunāni' lā' nakaksā'tit. Cakē'kō'lhtit huan mākalhcha lā' chuntza' nacātamālaquī'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Huan a'ntī nasqui'ni' Dios, ū'tza' namaklhtīni'n lā' huan a'ntī putza a'ntū Dios namaxquī', xla' nakaksa. Lā' huan a'ntī nakē'kō'lha huan mākalhcha, Dios namālaquī'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Hui'xina'n ka'lhī'yā'tit mincamana'ca'n. Lā' palh kalhatin mincaman nasqui'ni'yāni' pāntzi, ¿chu namaxquī'ya' lakatin chihuix? ");
INSERT INTO tooNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Lā' palh nasqui'ni'yāni' squī'ti', ¿chu namaxquī'ya' lūhua'? ");
INSERT INTO tooNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hui'xina'n chi'xcuhuī'n lā' milaktaca'n tū' tzey. Lā' a'yuj tū' tzey hui'xina'n, pero ca'tzīyā'tit a'ntūn tzey para mincamana'ca'n lā' nacāmaxquī'yā'tit. QuinTāta'ca'n xala' nac a'kapūn lej tzey, lā' chuntza' ā'chulā' nacāmaxquī' a'ntū xatzey huan a'ntīn tasqui'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Chuntza' cacātlahua'ni'tit ā'makapitzīn chu a'cxtim hua'chi lacasqui'nā'tit xlaca'n nacātatlahuani'yāni'. U'tza' huā'mā' a'ntū huanicu'tun huan ixley Moisés lā' ū'tza' ixlīmāsca'tīnca'n huan profetasna' chu a'nchīn tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Lā' Jesús cāhuanipā: ―A'nan lakatu' mākalhcha lā' kantu' tej. Natanū'yā'tit nac xapītzina'j mākalhcha a'nlhā mā' huan pītzina'j tej. Lā' pēka'tla' mā' huan tej a'ntū a'n nac pūpātīn lā' pēka'tla' xamākalhcha. Lā' līlhūhua' a'ntī natatanūyācha'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Huan pītzina'j tej a'n nac a'kapūn a'nlhā natahui'layāuj para pō'ktu. Lā' jicslīhua' a'ncan. Nā pītzina'j xamākalhcha. Lā' tū' a'nan lhūhua' a'ntī natatanūyācha'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Lā' Jesús cāhuanipā: ―Catamaktaka'lhtit de a'ntīn tahuan palh ixa'cta'sana'nī'n Dios lā' xmān ta'a'kxokonu'n. Xlaca'n hua'chi lobo a'ntū lej taputzamā'na ixlīhua'tca'n lā' talhakā'nanī't hua'chi borregos. ");
INSERT INTO tooNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tzē nacālakapasā'tit ixpālacata a'nchī natalatā'kchoko. Tū' cāpu'xcan uvas nac lhtucū'n lā' nīn tū' cāpu'xcan higos nac huan lhtucū' qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chuntza' huan xatzey qui'hui' namāstā' xatzey ixtō'ca't lā' tzēhuanī't. Lā' tū' tzey ixtō'ca't huan qui'hui' a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Huan xatzey qui'hui' tū' catimāstā'lh ixtō'ca't a'ntūn tū' tzey. Lā' nīn huan tū' tzey qui'hui' tūla namāstā' xatzey ixtō'ca't. ");
INSERT INTO tooNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Palh huan qui'hui' tū' namāstā' xatzey ixtō'ca't, nacā'can lā' nalhcuyucan. ");
INSERT INTO tooNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Chuntza' hui'xina'n nacālīlakapasā'tit huan a'cta'sana'nī'n a'ntīn ta'a'kxokonu'n como xlaca'n tū' xa'nca talatā'kchoko. ");
INSERT INTO tooNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Lā' Jesús cāhuanipā: ―Lhūhua' a'nan a'ntī naquintamāpācuhuī: “QuiMāpa'ksīni'”. U'tza' tū' huanicu'tun que natatanū a'nlhā Dios māpa'ksīkō' ixlīhuāk. Xmān tzē natatanūyācha' xlaca'n a'ntīn tatlahua ixtapuhuān quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","A'xni'ca' namin ā'xmān chi'chini', līlhūhua' naquintahuani: “QuiMāpa'ksīni'ca'n, quina'n icmāsu'yūj ixtachihuīn Dios ixpālacata milīmāpa'ksīn. Lā' milīmāpa'ksīn iccālīmāxtūj huan tlajana'nī'n. Lā' nā lhūhua' lē'cnīn iccālītlahuáuj milīmāpa'ksīn”, natahuan. ");
INSERT INTO tooNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Lā' tuncan na'iccāhuani': “Tū' iccālakapasāni'. Catapānū'tit. Hui'xina'n tlahua'tit a'ntūn tū' tzey”. ");
INSERT INTO tooNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Lā' Jesús cāhuanipā: ―Chuntza' huan a'ntī quinkaxmata lā' xla' a'kahuāna'ni' a'ntū icmāsu'yu, xla' xa'nca tlā'huan na ixtej Dios lā' natāyani' a'yuj napātīni'n. Nala hua'chi kalhatin chi'xcu' a'ntī pūlhmā'n yāhualh xatantūn ixchic. ");
INSERT INTO tooNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Lā' a'yuj milh lhūhua' xcān lā' huan palha' ū'ni' sno'kli huan chic, pero tāyani'lh lā' tū' a'kā'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero huan a'ntī quinkaxmata lā' xla' tū' a'kahuāna'ni' a'ntū icmāsu'yu, xla' tūlalh catitāyani'lh. Nala hua'chi kalhatin chi'xcu' a'ntīn tonto ixuanī't lā' tū' pūlhmā'n yāhualh xatantūn. ");
INSERT INTO tooNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","A'xni'ca' lej lalh xcān lā' milh palha' ū'ni' a'ntū sno'kli huan chic, tū' tāyani'lh. Mākā'nīlh lā' laclakō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lā' a'xni'ca' Jesús cāhuanikō'lh huā' tamā'na, huan tachi'xcuhuī't lej talē'cnīlh ixpālacata huan līmāsca'tīn. ");
INSERT INTO tooNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Xla' cāmāsu'ni'lh hua'chi a'ntī ka'lhī līmāpa'ksīn, lā' tū' hua'chi huan xamākalhtō'kē'ni'nī'n ley. Xlaca'n xmān tamāsu'yu a'ntūn tamaksca'tli. ");
INSERT INTO tooNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lā' a'xni'ca' Jesús lacyujli huan nac kēstīn, lhūhua' tachi'xcuhuī't tastālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Lā' laktapajtzūlh kalhatin ī'tza'ca'. Ixka'lhī huan ta'jatat a'ntū huanican lepra lā' ū'tza' a'ntū māmasī quinquinītca'n. Huan ī'tza'ca' tatzokostani'lh Jesús lā' huanilh: ―Māpa'ksīni', palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Lā' tuncan Jesús xa'malh lā' huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. Lā' a'xni'ca' huanilh huā'mā', tapānūni'lh ixta'jatat huan ī'tza'ca'. Tzeytza' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Lā' Jesús huanilh: ―Catamaktaka'lhti lā' tū' tihua'ni'ya' nīn tintī'. Xmān calakpi huan ixcuraca'n israelitas lā' camā'su'ni' mimacni' para nalaktzī'n palh tzeyanī'ta'tza'. Lā' na'a'ksa'juī'ni'na' chu a'nchī māpa'ksīni'lh Moisés. Chuntza' nataca'tzī tachi'xcuhuī't que tzeyanī'ta'tza'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lā' a'xni'ca' Jesús tanūlh huan nac cā'lacchicni' Capernaum, laktapajtzūlh kalhatin ixcapitanca'n de huan tropasna' romanos. Squi'ni'lh que camaktāyalh ");
INSERT INTO tooNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","lā' huanilh: ―Māpa'ksīni', lej ī'tzaca'n quintasācua' lā' mā' na quinchic. Lhtuculu' lā' lej pātīni'mā'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús huanilh: ―Na'ica'n na'icmātzeyī. ");
INSERT INTO tooNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Lā' huan capitán kalhtīlh: ―Māpa'ksīni', hui'x lej ka'lhī'ya' līmāpa'ksīn lā' tū' minī'ni' natanū'ya' nac quinchic. Xmān namāpa'ksī'ya' lā' natzeyan quintasācua'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Māni' quit nā quintamāpa'ksī huan xalaka'tla' lā' nā quit iccāmāpa'ksī huan quintropasna'. A'xni'ca' na'icuani kalhatin tropa que ca'a'lh, xla' na'a'n. Lā' a'xni'ca' na'icuani ā'kalhatin que camilh, xla' namin. Lā' a'xni'ca' na'icuani quintasācua' que catlahualh catūhuā, xla' natlahua a'ntū icuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lā' a'xni'ca' Jesús kaxmatli huā'mā' tachihuīn, lē'cnīlh. Lā' cāhuanilh huan a'ntī ixtastālani'tēlha: ―Stu'ncua' a'ntū iccāhuaniyāni'. Tū' iclakapasa nīn tintī' israelita a'ntī quinkalhlaka'ī' hua'chi huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nā iccāhuaniyāni' que natamin lhūhua' xalanī'n ixtankēn lā' nā lhūhua' xalanī'n na ixlītā'cnun. Lā' xlaca'n, a'yuj tū' israelitas, xlaca'n nacātā'huā'yan Abraham lā' Isaac lā' Jacob a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Lā' ā'makapitzīn a'yuj israelitas, xlaca'n nacāmacā'ncan kēpūn a'nlhā cā'pucsua'. A'ntza' natacalhuan lā' natalaxca ixtatzanca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Lā' tuncan Jesús huanilh huan capitán: ―Capit na minchic. Chu a'nchī kalhlaka'ī'nī'ta', chuntza' natlahuani'ca'na'. Lā' huanmā' ka'tlā'tus mātzeyīlh huan tasācua'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lā' Jesús a'lh na ixchic Pedro lā' a'ntza' laktzī'lh ixpuhuiti'. Ixchi'chīxni'n lā' ixmā'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús xa'malh na ixmacan lā' tapānūni'lh huan tachi'chīxni'. Tā'kaquī'lh huan puscāt lā' tzuculh cāmāhuī'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lā' a'xni'ca' ī'smalanka'namā'tza', cālīmini'ca Jesús lhūhua' a'ntī ixtaka'lhī huan tlajana'nī'n. Lā' xla' xmān māpa'ksīlh lā' chuntza' cāmāxtulh huan tlajana'nī'n. Lā' nā cāmātzeyīlh lhūhua' ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","U'tza' huā'mā' pātle'kelh para natlōkentaxtū chu a'nchī a'cta'sana'lh huan profeta Isaías a'xni'ca' hualh huā'mā': “Xla' māpānūlh a'nchī ī'tza'cā'hua' ixuanī'ta'uj quina'n lā' nā a'nchī ī'xlejua'nanāuj lā' quincāmaklhtīni' quinta'jatatca'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lā' a'xni'ca' Jesús cālaktzī'lh huan lhūhua' tachi'xcuhuī't a'ntī ixtalītamacxti'li'mā'na, māpa'ksīlh que calē'nca tintacut huan ka'tla' xcān huan nac barco. ");
INSERT INTO tooNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Lā' kalhatin xamākalhtō'kē'ni' huan ley laktapajtzūlh Jesús lā' huanilh: ―Mākalhtō'kē'ni', ictā'a'ncu'tunāni' chuxalhā napina'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Lā' Jesús kalhtīlh: ―Huan tanqui'hui' taka'lhī ixlhu'cu'ca'n lā' huan spūnnu' taka'lhī ixmāsekca'n. Lā' quit huan Chi'xcu' xala' Tālhmā'n; pero quit tū' icka'lhī quinchic a'nlhā na'iclhtata. ");
INSERT INTO tooNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Lā' ā'kalhatin a'ntī ī'sca'txtunu' ixuanī't, xla' huanilh: ―Māpa'ksīni', caquimakxtekti na'ictachoko nac quinchic hasta a'xni'ca' namā'cnūcan quintāta'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Lā' Jesús kalhtīlh: ―Caquistāla'ni'. Xlaca'n a'ntīn tū' takalhlaka'ī' tzē natamā'cnū huan nīn. ");
INSERT INTO tooNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Lā' tuncan Jesús tojōlh nac lakatin barco lā' tatā'tojōlh ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Lā' līhuan ixtatacutmā'na, tzuculh lakatin palha' ū'ni' lā' ixlītatzumamā'tza' de xcān huan barco. Lā' Jesús ī'lhtatamā'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lā' tuncan ta'a'lh tamālakahuānī lā' tahuanilh: ―¡Māpa'ksīni', caquilāmāpūtaxtūj! ¡Tā'cnūmā'nauj! ");
INSERT INTO tooNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Lā' Jesús cākalhtīlh: ―Lā' ¿a'chī' lej jicua'nā'tit? ¡Tū' xa'nca kalhlaka'ī'yā'tit! Tuncan tā'kaquī'lh lā' cālacaquilhnīlh huan ū'ni' lā' huan xasipej xcān. Lā' chuntza' ca'cslalh. ");
INSERT INTO tooNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lā' huan chi'xcuhuī'n talē'cnīlh lā' tahualh: ―¿Tichūyā chi'xcu' xla'? ¡Hasta tzē cāmāpa'ksī huan ū'ni' lā' huan xasipej xcān lā' nata'a'kahuāna'ni'! ");
INSERT INTO tooNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tintacut huan xcān ixuī' lakatin ti'ya't a'nlhā huanican Gadara. Lā' a'xni'ca' Jesús chā'lh a'ntza', tatapajtzūlh kalhatu' chi'xcuhuī'n a'ntī ixtahui'lāna'ncha' nac lhu'cu'. Ixtu'ca'n ixtaka'lhī huan tlajana'nī'n lā' ixtachuyā lā' ixtaca'tzanca'tzī. Nīn tintī' ixtatētaxtucu'tun a'ntza' ixpālacataca'n huan tamā'na kalhatu'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Lā' tatzuculh tata'sa lā' tahualh: ―Icca'tzīyāuj palh hui'x ixO'kxa' Dios, pero quina'n tūna'j ictimāpalanauj con Dios. ¿Chā ta't para naquilāmāpātīnīyāuj a'xni'ca' tūna'j min huan chi'chini' a'ntū lhcācanī't? ");
INSERT INTO tooNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lā' tū' lej makat de a'ntza' ixtahuā'yamā'na lhūhua' pa'xni'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Lā' huan tlajana'nī'n tasqui'ni'lh Jesús: ―Palh naquilāmāxtuyāuj na ixchakānca'n huan chi'xcuhuī'n, caquilāmakxtekui na'ictanūyāuj na ixchakānca'n huan tamā'na pa'xni'. ");
INSERT INTO tooNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Lā' tuncan Jesús cāhuanilh: ―Capitittza'. Lā' huan tlajana'nī'n tataxtukō'lh de huan chi'xcuhuī'n lā' tatanūlh huan na ixchakānca'n huan lhūhua' pa'xni'. Lā' chu tuncan huan lhūhua' pa'xni' tatu'jnun ta'a'lh nac cā'pūtatonkopūn lā' tatojōcha' nac xcān lā' a'ntza' tajicsua'kō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lā' huan chi'xcuhuī'n a'ntī ixtamaktaka'lhmā'na huan lhūhua' pa'xni', xlaca'n tajicua'lh lā' tatu'jnulh huan nac cā'lacchicni'. Lā' a'xni'ca' tachā'lh, tahuankō'lh ixlīhuāk a'ntū cāpātle'keni'lh huan chi'xcuhuī'n a'ntī ixtaka'lhī huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lā' tuncan ixlīhuākca'n xalanī'n huanmā' cā'lacchicni' talaka'lh Jesús a'nlhā ixuī'. Lā' a'xni'ca' tachā'lh a'ntza', lej tasqui'ni'lh Jesús que ca'a'lh de na ixti'ya'tca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Lā' tuncan Jesús tojōlh nac lakatin barco lā' a'lh tintacut lā' chā'lh nac Capernaum a'nlhā ixā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Lā' līmini'cancha' kalhatin chi'xcu' a'ntī ixlū'ntū'lanī't lā' a'ntī ixmā' na ixlaklaj. Lā' a'xni'ca' Jesús laktzī'lh a'nchīn takalhlaka'ī'lh que ixka'lhlī līmāpa'ksīn, xla' huanilh huan ī'tza'ca': ―Cahui'xcāna'jca'tzi, quincaman. Quit icmāsputūnu'ni'yāni' mintalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lā' tuncan makapitzīn xamākalhtō'kē'ni'nī'n ley tapuhualh: “¿A'chī' chihuīna'n chuntza' huā'mā' chi'xcu'? Tā'talacastuccu'tun Dios. Nīn tintī' tzē naquincāmāsputūnu'ni'yāni' quintalaclē'i'ca'n, xmān Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Lā' Jesús, como ixca'tzī a'nchī ixtapuhuamā'na, cāhuanilh: ―¿A'chī' puhua'nā'tit chuntza' na mi'a'clhcunucca'n? ");
INSERT INTO tooNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Icuanilhtza' huan ī'tza'ca': “Iccāmāsputūnu'ni'ni' mintalaclē'i'”, pero tū' tasu'yu a'yuj māsputūnu'ni'ca. Palh xa'icuanilh: “Catā'kaqui' lā' casmi'li' mixti'cat lā' catlā'hua'”, chuntza' ixtasu'yulh palh natzeyan o tū'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Quit huan Chi'xcu' xala' Tālhmā'n. Lā' chuhua'j na'iccāmāsu'ni'yāni' a'nchī icka'lhī līmāpa'ksīn nac huā'mā' cā'quilhtamacuj lā' tzē na'iccāmāsputūnu'ni' ixtalaclē'i'ca'n tachi'xcuhuī't. Lā' tuncan Jesús huanilh huan chi'xcu' a'ntī ixlū'ntū'lanī't: ―Catā'kaqui' lā' casmi'li' mixti'cat lā' capit na minchic. ");
INSERT INTO tooNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Lā' tuncan huan chi'xcu' tā'kaquī'lh lā' lē'lh ī'xti'cat lā' a'lh na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lā' huan tachi'xcuhuī't, a'xni'ca' talaktzī'lh huā'mā', tajicua'lh. Lā' tamāpāxuhuīlh Dios como ixcāmaxquī'nī't huā'mā' līmāpa'ksīn huan chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lā' a'xni'ca' Jesús ixtaxtumā' de a'ntza', laktzī'lh kalhatin chi'xcu' a'ntī ixuanican Mateo. Xla' ixuī' a'nlhā ixmātā'jīni'ncan impuestos lā' huanica: ―Caquistāla'ni'. Lā' tuncan Mateo tāyalh lā' stālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Lā' a'xni'ca' Jesús ixuā'yamā' nac lakatin chic, tachā'lh lhūhua' mātā'jīni'nī'n impuestos lā' ā'makapitzīn a'ntīn tū' tzeyā chi'xcuhuī'n. Lā' ixlīhuākca'n ixcātā'huā'yamā' Jesús lā' ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lā' a'xni'ca' makapitzīn fariseosnu' talaktzī'lh huā'mā', xlaca'n takalhasqui'nīlh huan ī'sca'txtunu'nī'n Jesús: ―Lā' ¿a'chī' mimākalhtō'kē'ni'ca'n cātā'huā'yan huan mātā'jīni'nī'n impuestos lā' ā'makapitzīn a'ntīn tū' tzey? ");
INSERT INTO tooNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lā' Jesús kaxmatli huā'mā' tachihuīn lā' cāhuanilh: ―Huan a'ntīn tū' ta'ī'tza'ca'n, xlaca'n tū' tamaclacasqui'n huan doctor, xmān huan ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Capittit lā' casca'ttit a'ntū huanicu'tun huā'mā' a'ntūn tzo'kcanī't na ixtachihuīn Dios: “Quit ā'chulā' iclacasqui'n nacālakalhu'ma'nā'tit ā'makapitzīn. Lā' tū' tanto iclacasqui'n naquilā'a'ksajuī'yāuj huan animalhna'”. Chuntza' tzo'kcanī't. Quit tū' icmilh iccāputza a'ntīn tapuhuan palh xlaca'n xalacuan. Icmilh iccāputza huan tachi'xcuhuī't a'ntīn taca'tzī palh tū' tzey xlaca'n como iclacasqui'n que nataxtāpalī ixtapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lā' ā'calīstān huan a'ntī ixtastālani' Juan huan Mā'kpaxīni', xlaca'n talakmilh Jesús. Lā' takalhasqui'nīlh: ―Quina'n lā' huan fariseosnu' maklhūhua' ictasca'jayāuj lā' tū' icuā'yanāuj tintacuj ixpālacata Dios. Lā' ¿a'chī' misca'txtunu'nī'n pō'ktu tahuā'yan? ");
INSERT INTO tooNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Lā' Jesús cākalhtīlh: ―¿Chā natalakaputza huan a'ntī cākantāyacan a'nlhā tapūchahuamā'ca? Līhuan huī' huan squi'nīni', tū' talakaputza. Namin lakatin chi'chini' a'xni'ca' nalē'ncan huan squi'nīni' lā' a'xni'ca' natalakaputza lā' tū' catitahuā'yalh ixamigos―a'xni'ca' Jesús cāhuanilh huā'mā', ixlīchihuīna'mā'ca māni' xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Lā' Jesús cāhuanipā: ―Nīn tintī' nachu'cu huan xasāsti' lu'xu' para nalīlactza'pa' huan xamasni'. Huan xasāsti' lu'xu' natatimī lā' ā'chulā' naxtī'ta huan xamasni'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Lā' huan xaxcān uva a'ntūn tūna'j xcu'tan nīn tintī' catimojōlh nac xakōlūhua' xako'xka' borrego. Namojōcan nac xasāsti' ko'xka' lā' a'xni'ca' naxcu'tan, tū' catipankli huan ko'xka'. Chuntza' tū' catipāxcatlīlalh huan ko'xka' lā' tū' catitaxtulh huan xaxcān uva ―cāhuanilh Jesús. U'tza' huā'mā' līchihuīna'mā' ixlīmāsca'tīnca'n israelitas lā' ixlīmāsca'tīn Jesús a'ntū xasāsti'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Lā' līhuan Jesús ixcāhuanimā' huā'mā', chā'lh kalhatin xapuxcu' de huan israelitas. Xla' tatzokostani'lh na ixlacapūn Jesús lā' huanilh: ―Nīlhcus quintzu'ma'jāt. Lā' a'yuj nīlhtza', palh hui'x napina' lā' naxa'ma'ya', xla' nalakahuanchoko. ");
INSERT INTO tooNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Lā' Jesús tāyalh lā' tā'a'lh huan chi'xcu'. Nā ī'sca'txtunu'nī'n nā tatā'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tuncan milh kalhatin puscāt a'ntī ixī'tza'ca'n. Lā' ixka'lhītza' lakacāujtu' cā'ta ī'sta'ja ixka'lhni'. Tapajtzūlh ixkēn Jesús lā' xa'malh ixtampān ixlu'xu' ");
INSERT INTO tooNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","como puhualh chuntza': “Xmān ca'icxa'malh ixlu'xu' lā' na'ictzeyan”, puhualh. ");
INSERT INTO tooNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Lā' Jesús talakspi'tli lā' laktzī'lh huan puscāt lā' huanilh: ―Cahui'xcāna'jca'tzi, quincaman. Tzeyanī'ta'tza' como kalhlaka'ī'nī'ta'. Lā' huanmā' ka'tlā'tus ixtzeyanī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lā' a'xni'ca' Jesús chā'lh na ixchic huan xapuxcu' israelitas, cālaktzī'lh huan músicos a'ntī natatā'a'n a'xni'ca' namā'cnūcan. Lā' huan tachi'xcuhuī't lej ixtata'samā'na. ");
INSERT INTO tooNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Lā' Jesús cāhuanilh: ―Catapānū'tit de huā'tzā'. Huan tzu'ma'jāt tū' nīnī't. Xmān lhtatamā'. Lā' xlaca'n talītzī'nli. ");
INSERT INTO tooNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Lā' a'xni'ca' Jesús cāmāxtukō'lh huan tachi'xcuhuī't, xla' tanūlh a'nlhā ixmā' huan tzu'ma'jāt lā' macachi'palh. Lā' huan tzu'ma'jāt tā'kaquī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Lā' chuxalhā nac huanmā' ti'ya't a'kahualh a'ntū pātle'keni'lh huan tzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Lā' a'xni'ca' Jesús ixtaxtumā' de a'ntza', tatzuculh tastālani' kalhatu' lakatzī'nī'n. Lā' palha' tahuanilh: ―¡Caquilālakalhu'mauj, hui'x a'ntī ixtā'nat David! ");
INSERT INTO tooNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lā' a'xni'ca' Jesús tanūlh huan nac chic, huan lakatzī'nī'n tatapajtzūlh. Lā' xla' cākalhasqui'nīlh: ―¿Chā kalhlaka'ī'yā'tit palh tzē na'iccāmālacahuānīpalayāni'? Lā' takalhtīlh: ―Chuntza' ickalhlaka'ī'yāuj, Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lā' tuncan Jesús cāxa'mani'lh ixlakastapunca'n lā' cāhuanilh: ―Calalh chu a'nchī kalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Lā' tatzeyalh ixlakastapunca'n lā' talacahuāna'lh. Lā' tuncan Jesús lej cāmāpa'ksīlh: ―Calī'hui'lī'tit nīn tintī' namāca'tzīnī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Lā' a'yuj chuntza' cāhuanica, a'xni'ca' tataxtulh xlaca'n tatzuculh tahuani chā'tin chā'tin a'ntū cātlahuani'lh Jesús. Lā' ū'tza' talīca'tzīkō'lh lakachu nac huā'mā' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Lā' a'xni'ca' tūna'j ixtataxtu huan a'ntī lakatzī'nī'n ixtahuanī't, a'xni'ca' līmini'ca Jesús kalhatin kō'ko'. Lā' huan kō'ko ixka'lhī huan tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lā' a'xni'ca' Jesús māxtulh huan tlajana', chu tuncan tzuculh chihuīna'n huan kō'ko'. Lā' huan tachi'xcuhuī't talē'cnīlh lā' tahualh: ―Tū' maktin tasu'yunī't hua'chi ixtā'chuntza' huā'mā' catūhuā na quinti'ya'tca'n quina'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Lā' huan fariseosnu', xlaca'n ixtahuan: ―Huā'mā' chi'xcu' ka'lhī ixlīmāpa'ksīn huan ko'ti'ti' a'ntī xapuxcu' tlajana'nī'n. U'tza' cālīmāxtuni'lh huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ixtētaxtutēlha lakatunu' cā'lacchicni' lā' huan ranchosnu'. Lā' ixtētanūtēlha nac lakatunu' na ixlītokpānca'n israelitas lā' ixmāsu'yu. Lā' ixcā'a'cta'sana'ni' a'nchī nala a'nlhā Dios namāpa'ksīni'n. Lā' nā ixcāmātzeyī chuxatūyā ta'jatat lā' taca'tzāt. ");
INSERT INTO tooNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lā' a'xni'ca' cālaktzī'lh huan tachi'xcuhuī't, lej cālakalhu'malh como ixcāpāta'lamā' lā' ixtalakachā'ni'. Cālaktzī'lh hua'chi borregos a'ntīn tū' ixtaka'lhī ixmaktaka'lhna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Stu'ncua' lhūhua' a'nan a'ntīn takalhlaka'ī'cu'tun. Xlaca'n hua'chi a'nlhā lej lana'lh lā' tisputa tasācua'nī'n para na'ī'can. ");
INSERT INTO tooNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Dios ū'tza' ixtēcu' huan a'nlhā lej lana'lh. U'tza' nalīsqui'ni'yā'tit Dios que cacāmacamilh chi'xcuhuī'n a'ntī nacāmāsu'ni' huan xatzey tachihuīn huan a'ntīn takalhlaka'ī'cu'tun ―cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Lā' tuncan Jesús cāmāta'sīlh huan kalhacāujtu' ī'sca'txtunu'nī'n. Lā' cāmaxquī'lh līmāpa'ksīn para natamāxtu huan tlajana'nī'n lā' para nacāmātzeyī chuxatūyā ta'jatat lā' taca'tzāt. ");
INSERT INTO tooNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Huā' tamā'na ixtacuīni'ca'n huan kalhacāujtu' sca'txtunu'nī'n lā' xlaca'n a'ntī cāmāpacuhuīcan apóstoles: huan xapū'la, xla' Simón a'ntī ixlītāpātu' ixtacuīni' Pedro, lā' ī'stancu Andrés; lā' nā Jacobo lā' Juan a'ntī ixo'kxa'n huan Zebedeo ixtahuanī't; ");
INSERT INTO tooNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","lā' nā Felipe lā' Bartolomé lā' Tomás lā' huan Mateo a'ntī mātā'jīni' impuestos ixuanī't; lā' nā Jacobo a'ntī ixo'kxa' Alfeo; lā' Lebeo a'ntī ixmāpācuhuīcan Tadeo; ");
INSERT INTO tooNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","lā' nā Simón a'ntī ixtapa'ksī con huan cananistasna'; lā' nā Judas Iscariote a'ntī ā'calīstān namacamāstā' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Lā' a'xni'ca' Jesús cāmacā'lh huā' tamā'na kalhacāujtu', xla' chuntza' cāmāpa'ksīlh lā' cāhuanilh: ―Tū' catipintit timāsu'yu'yā'tit a'nlhā talahui'lāna'ncha' xlaca'n a'ntīn tū' israelitas lā' tū' titanū'yā'tit huan na ixā'lacchicni'ca'n huan samaritanosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Napinā'tit nacāmāsu'ni'yā'tit huan xalanī'n nac Israel. Xlaca'n hua'chi borregos a'ntīn tatza'nkānī't. ");
INSERT INTO tooNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Capintit lā' na'a'cta'sana'nā'tit chuntza': “Tapajtzūmā'tza' a'xni'ca' natasu'yu a'nchī Dios nacāmāpa'ksīkō' tachi'xcuhuī't”. ");
INSERT INTO tooNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cacāmātzeyī'tit huan ī'tza'ca'nī'n lā' cacāmālakahuanīchoko'tit huan nīnī'n. Cacāmātzeyī'tit huan leprosos a'ntīn tamasmā'na ixquinītca'n lā' cacāmāxtutit huan tlajana'nī'n. Hui'xina'n tū' catimāpala'tit huā'mā' līmāpa'ksīn a'ntū iccāmaxquī'yāni' lā' chuntza' tū' caticāmātā'jī'tit a'xni'ca' nacālīmātzeyī'yā'tit quilīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Tū' camojō'tit tumīn de oro nīn de plata nīn de cobre na mimbolsaca'n a'xni'ca' napinā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Lā' tū' calī'pintit mimorralhca'n nīn pūtu' milu'xu'ca'n. Xmān nalī'pinā'tit milu'xu'ca'n a'ntū lhakā'nī'ta'ntit. Tū' nalī'pinā'tit nīn zapato nīn mimpāla'cca'n. Huan a'ntī māsu'yumā' ixtachihuīn Dios maclacasqui'n namāhuī'can a'nlhā māsu'yumā'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’A'xni'ca' nachipinā'tit nac lakatin cā'lacchicni' o nac lakatin rancho, naputzayā'tit kalhatin tzeyā chi'xcu' a'ntī nacāmānūyāni' na ixchic. Lā' natachokoyā'chipintit hasta a'xni'ca' nataxtuyā'tit de huanmā' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lā' a'xni'ca' natanū'yā'tit huan nac chic, nacāhuaniyā'tit: “Dios cacāsicua'lanālīlh a'ntīn tahui'lāna' nac huā'mā' chic”. ");
INSERT INTO tooNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Palh con tapāxuhuān cātamānūyāni' na ixchicca'n, Dios nacāsicua'lanālī xlaca'n. Lā' palh tū' cātamānūyāni' na ixchicca'n, tū' caticāsicua'lanālīca. ");
INSERT INTO tooNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Lā' palh tū' cātamānūyāni' nac pātin chic o lakatin cā'lacchicni', lā' palh tū' cātakaxmatāni', tuncan cataxtutit. Lā' a'xni'ca' nataxtuyā'tit, catincxtit huan pokxni' de mintojonca'n. Chuntza' nalīmāsu'yu'yā'tit que xlaca'n natalē'n cuenta como tū' takaxmatcu'tulh. ");
INSERT INTO tooNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ixlīstu'ncua' a'ntū iccāhuaniyāni'. A'xni'ca' namin huan chi'chini' lā' Dios nalacāxtlahuakō', xlaca'n lej natapātīni'n. Dios ā'chulā' nacālakalhu'man xlaca'n xalanī'n nac Sodomo lā' Gomorra que xalanī'n huanmā' cā'lacchicni' a'ntīn tū' takaxmatcu'tun ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lā' Jesús cāhuanipā: ―¡Cuenta catlahua'tit! Quit iccāmacā'nāni' lā' nala'yā'tit hua'chi borregos na ixlaclhni'ca'n huan lobos. Lej skalalh cala'tit hua'chi huan lūhua'. Lā' cala'tit hua'chi tantzasnān a'ntūn tū' lāsta'la. ");
INSERT INTO tooNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Catamaktaka'lhtit como chi'xcuhuī'n nacātamacamaxquī'cu'tunāni' huan māpa'ksīni'nī'n lā' nacātatucsāni' na ixlītokpānca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Lā' nacātamālacapū'yāni' na ixlacapūnca'n gobernadores lā' reyes xmān por quimpālacata. Chuntza' tzē nacāhuaniyā'tit huan xatzey tachihuīn calacan xlaca'n lā' nā nacāhuani'yā'tit huan a'ntīn tū' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero tū' catilē'capintit a'nchī nalītamaktāyayā'tit nīn a'ntū nacākalhtīyā'tit a'xni'ca' nacāmacamaxquī'yāni' huan māpa'ksīni'nī'n. A'xni'ca' nachipinā'tit a'ntza', Dios nacāmāca'tzīnīyāni' a'ntū nacāhua'ni'yā'tit xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tū' māni' mintachihuīnca'n a'ntū nachihuīna'nā'tit. Huan Espíritu Santo, ū'tza' a'ntī nacāmāchihuīnīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Huan chi'xcuhuī'n natamacamāstā' ixtā'timīnca'n para nacāmaknīcan lā' huan xanatātana' natamacamāstā' ixcamana'ca'n. Huan o'kxa'n natatā'kaquī' contra ixnatātana'ca'n lā' natamāmaknīnīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ixlīhuākca'n tachi'xcuhuī't nacātaca'tzalaktzī'nāni' como tapa'ksī'yā'tit con quit. Lā' huan a'ntīn tzancs natatāya lā' tū' natataxtutāya na quintej a'yuj lej tapātīni'mā'na, ū'tunu'n nacāmāputaxtūcan. ");
INSERT INTO tooNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","’Lā' a'xni'ca' nacātamacaputzayāni' nac lakatin cā'lacchicni', cataxtutit lā' capintit ā'lacatin. Stu'ncua' a'ntū iccāhuaniyāni' que tū' catitētaxtukō'tit ixlīhuākca'n ixā'lacchicni'ca'n israelitas para namāsu'yuyā'tit quintachihuīn a'xni'ca' namimpala huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Huan sca'txtunu' tū' tasqui'nī hua'chi ixmākalhtō'kē'ni'. Lā' huan tasācua' tū' tasqui'nī hua'chi ixpatrón. ");
INSERT INTO tooNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Līpāxūj huan sca'txtunu' a'ntīn tzē namālacastuca ixmākalhtō'kē'ni' lā' nā huan tasācua' a'ntīn tzē namālacastuca ixpatrón. Palh lakapalacanī'ttza' huan a'ntī māpa'ksīni'n huan nac chic lā' māpācuhuīcanī'ttza' Beelzebú, ā'chulā' nacālakapalacan ā'makapitzīn xalanī'n nac huā'mā' chic ―cāhuanilh Jesús. U'tza' a'ntū līchihuīna'mā' Jesús lā' nā ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Lā' Jesús cāhuanipā: ―Chuntza' tū' caticājicua'ni'tit tachi'xcuhuī't. Ixlīhuāk a'ntūn tatzē'knī't, ū'tza' nalaktzī'ncan. Lā' a'ntū lakatzē'kcus, naca'tzīkō'can. ");
INSERT INTO tooNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Huan a'ntū quit iccāhuanini' a'nlhā quē'stuca'n, ū'tza' nacāhuaniyā'tit cā'lacapūlhūhua'. Lā' huan a'ntū quit lakatzē'k iccāhuaniyāni', ū'tza' lej palha' nahuanā'tit chuxalhā. ");
INSERT INTO tooNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tū' caticājicua'ni'tit chi'xcuhuī'n a'ntīn tzē natamaknī mimacni'ca'n pero tūla tamāpa'ksī milīca'tzīnca'n. Najicua'ni'yā'tit Dios a'ntīn tzē nacāmāsputū mimacni'ca'n lā' milīca'tzīnca'n nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Chī ixtapalh huan tantzictzi? Stā'can tantu' por macsti'na'j tumīn. Lā' quinTāta'ca'n nac a'kapūn cuenta natlahua a'xni'ca' minācha' lakatin tantzictzi. ");
INSERT INTO tooNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Lā' chā'tunu' de hui'xina'n hasta cātapūtle'keni'ni' kanatunu' miya'jca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","U'tza' tū' tilījicua'nā'tit. Līhua'ca' tasqui'nī'yā'tit hui'xina'n que lhūhua' tantzictzi ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Lā' Jesús cāhuanipā: ―Lā' huan a'ntī natahuan cā'lacapūlhūhua' palh tatapa'ksī con quit, xlaca'n quit na'iccālakapasa a'xni'ca' natatāya na ixlacapūn quinTāta'ca'n nac a'kapūn. Lā' chuntza' quit nā na'icuan palh xlaca'n tatapa'ksī con quit. ");
INSERT INTO tooNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Lā' huan a'ntī naquintakalhtatzē'ka cā'lacapūlhūhua', xlaca'n quit na'iccākalhtatzē'ka a'xni'ca' natatāya na ixlacapūn quinTāta'ca'n xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Lā' Jesús cāhuanipā: ―Tū' tipuhua'nā'tit palh quit icmilh para que chu lakatin nala ixtapāstacna'ca'n tachi'xcuhuī't lā' chuntza' tū' catalāsta'lalh nac huā'mā' quilhtamacuj. Tū' ū'tza' quilītlōt. Na'iccāmā'kapitzīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Icmilh icmā'kaquī' huan o'kxa' contra ixtāta' lā' na'icmā'kaquī' huan tzu'ma'jāt contra ixtzī't lā' nā huan puscāt contra ixtzī't ixkōlu'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lā' ū'tza' natalīla lītā'ca'tza xalanī'n na ixchakān huan lakatin chic. ");
INSERT INTO tooNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Huan a'ntī līhua'ca' natapāxquī' ixtzī'tca'n o ixtāta'ca'n que quit, xlaca'n tū' minī'ni' natatapa'ksī con quit. Lā' nā huan a'ntī līhua'ca' natapāxquī' ixo'kxa'ca'n o ixtzu'ma'jātca'n que quit, xlaca'n tū' minī'ni' natatapa'ksī con quit. ");
INSERT INTO tooNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Lā' huan a'ntīn tūla tatāyani' a'ntū nacāpātle'keni' por quimpālacata, xlaca'n tū' minī'ni' natatapa'ksī con quit. ");
INSERT INTO tooNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Huan a'ntī natataxtutāya de na quintej como tū' tapātīni'ncu'tun por quimpālacata, xlaca'n tū' catitaka'lhīlh ixquilhtamacujca'n nac a'kapūn. Lā' huan a'ntī natapātīni'n a'yuj ixtanīlh por quimpālacata, xlaca'n nacāmāpūtaxtūcan. ");
INSERT INTO tooNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Lā' Jesús cāhuanipā: ―Palh catīhuā nata'a'ka'ī' a'ntū hui'xina'n nacāhuani'yā'tit, nā chuntza' nata'a'ka'ī' a'ntū quit icuan. Lā' palh catīhuā nata'a'ka'ī' a'ntū icuan, nā chuntza' nata'a'ka'ī' huan a'ntī quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lā' palh catīhuā nata'a'cnīni'ni' kalhatin a'cta'sana' como taca'tzī palh Dios macaminī't, chuntza' ū'tunu'n natatlaja chu a'cxtim hua'chi huan a'cta'sana'. Lā' palh catīhuā nata'a'cnīni'ni' kalhatin tzeyā chi'xcu' xmān porque tzey xla', chuntza' ū'tunu'n chu a'cxtim natatlaja hua'chi huan tzeyā chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lā' catīhuā a'ntī natā'hua' macsti'na'j xcān ā'kalhatin a'yuj catīhuāyā chi'xcu', lā' palh natā'hua' ā'kalhatin porque tapa'ksī con quit, ixlīstu'ncua' Dios namāpala ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lā' a'xni'ca' Jesús cāmāsu'ni'kō'lh ī'sca'txtunu'nī'n, taxtulh de a'ntza' lā' a'lh. Ixtētaxtutlā'huan ā'makapitzīn cā'lacchicni' a'nlhā pajatzu para namāsu'yu lā' na'a'cta'sana'n. ");
INSERT INTO tooNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Lā' Juan huan Mā'kpaxīni' ixtanūma' nac pūlāchī'n. Lā' a'xni'ca' māca'tzīnīca a'ntū ixtlahuamā' Jesús, tuncan cāmacā'lh kalhatu' ī'sca'txtunu'nī'n para natalaka'n Jesús ");
INSERT INTO tooNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","lā' natakalhasqui'nī: ―¿Chā hui'x huan Cristo a'ntī namin o maclacasqui'n na'icka'lhīyāujcus ā'kalhatin? ");
INSERT INTO tooNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Lā' Jesús cākalhtīlh: ―Cataspi'ttit lā' nahuaniyā'tit Juan a'ntū laktzī'nī'ta'ntit lā' a'ntū kaxpatnī'ta'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nahuaniyā'tit a'nchī huan lakatzī'nī'n talacahuāna'n lā' huan lū'ntū'lanī'n talatlā'huan. Lā' nā huan a'ntī ixcāmasni'mā' ixquinītca'n, xlaca'n tatzeyanli. Lā' huan a'ntīn tū' ixta'a'kahuāna'n, chuhua'j takaxmata. Lā' nā cāmālakahuanīchokocanī't huan a'ntī ixtanīnī'ttza'. Lā' cāmāsu'ni'can a'nchī nacālīmāpūtaxtūcan a'ntī līpānīn talahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Līpāxūj huan a'ntī pō'ktu quilīpāhuan ―cāhuanica ī'sca'txtunu'nī'n Juan. ");
INSERT INTO tooNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Lā' a'xni'ca' xlaca'n ixta'a'nī't, Jesús tzuculh cātā'kalhachihuīna'n huan tachi'xcuhuī't ixpālacata Juan. Lā' cākalhasqui'nīlh: ―A'xni'ca' quīla'tit nac cā'lhpi'mpi'li' ti'ya't, ¿tichū ixlaktzī'ncu'tunā'tit? Tū' quīla'tit para nalaktzī'nā'tit kalhatin chi'xcu' a'ntī hua'chi kantin chi'tin a'ntū xakā'līlh huan ū'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿A'chī' quīla'tit? Tū' quīla'tit para nalaktzī'nā'tit kalhatin chi'xcu' a'ntī lej tzēhuanī't lhakā'nanī't. Hui'xina'n ca'tzīyā'tit que huan a'ntī pō'ktu lej tzēhuanī't talhakā'nanī't, xlaca'n tahui'lāna' na ixchicca'n reyes. ");
INSERT INTO tooNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pues ¿a'chī' quīla'tit nac cā'lhpi'mpi'li' ti'ya't? ¿Chu tū' quīla'tit para nalaktzī'nā'tit kalhatin a'cta'sana'? Stu'ncua', ixlaktzī'ncu'tunā'tit kalhatin a'cta'sana'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lā' huā'mā' a'cta'sana' ixtacuīni' Juan. Lā' ixpālacata huā'mā' Juan tatzo'knī't chuntza' na ixtachihuīn Dios: Na'icmacā'n qui'a'cta'sana' a'ntī napū'lani'yāni' para nacāxmāpī' mintej. ");
INSERT INTO tooNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Stu'ncua' huā'mā' a'ntū iccāhuaniyāni' que na ixlaclhni'ca'n tachi'xcuhuī't tintī' kalhatin a'cta'sana' más xaka'tla' que Juan. Pero huan a'ntī līhua'ca' xamakstancu a'nlhā Dios māpa'ksīkō' ixlīhuāk, xla' más xaka'tla' que Juan. ");
INSERT INTO tooNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde a'xni'ca' tzuculh a'cta'sana'n Juan huan Mā'kpaxīni', maklhūhua' tatanūcu'tulh a'nlhā Dios māpa'ksīkō' ixlīhuāk. Lā' hua'chilh palha' talāpi'ta'mā'na para que natasātanū. ");
INSERT INTO tooNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ixlīhuākca'n huan a'cta'sana'nī'n ixtalīchihuīna'mā'na a'nchī namin lakatin chi'chini' a'xni'ca' Dios namāpa'ksīni'n huā'tzā' nac cā'ti'ya'tna'. Lā' nā chuntza' tatzo'kni' na ixley Moisés. Lā' talīchihuīna'lh hasta a'xni'ca' milh Juan. ");
INSERT INTO tooNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Lā' a'yuj tū' nakalhlaka'ī'cu'tunā'tit a'ntūn taquilhchā'lh, pero huā'mā' Juan ū'tza' huan a'cta'sana' Elías a'ntī ixka'lhīpā'na'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Cuenta catlahua'tit a'ntū kaxpatā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Chichū na'iccālīmālacastucāuj huan chi'xcuhuī'n a'ntīn tahui'lāna' chuhua'j? Tatasu'yu hua'chi camana' a'ntīn takamāna'mā'na nac lītamāuj. Lā' cātā'ta'sa ixtā'camana' lā' tahuani: ");
INSERT INTO tooNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“A'xni'ca' quina'n icmakata'sauj huan līskoli', hui'xina'n tū' lakatītit lā' tū' lu'cxtit. Lā' a'xni'ca' ictlī'uj hua'chi līlakaputzani', hui'xina'n tū' lakatītit lā' tū' calhua'ntit. ¿Tuchū lacasqui'nā'tit?” tahuan. ");
INSERT INTO tooNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Milh Juan lā' tū' ko'tli lā' a'katunu' tū' huā'yalh tintacuj. Lā' hui'xina'n lē'ksa'nā'tit lā' hua'nā'tit palh xla' ka'lhī huan tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lā' ā'calīstān quit icmilh. Quit huan Chi'xcu' xala' Tālhmā'n lā' icua' xcān lā' chuxatū quimālacnūni'can lā' pō'ktu icuā'yan. Lā' nā quilālē'ksa'nāuj lā' hua'nā'tit palh quit lhūhua' icuā'yan lā' lej icko'ta. Lā' hua'nā'tit que quit ixamigoca'n huan mātā'jīni'nī'n impuestos lā' huan a'ntīn tatlahua talaclē'i'. Pero huan a'ntīn takalhlaka'ī', xlaca'n tamāchekxī que Dios macamilh Juan lā' nā quit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lā' tuncan Jesús tzuculh cālacaquilhnī huan xalanī'n huan tamā'na cā'lacchicni' a'nlhā tlahualh lhūhua' lē'cnīn. Cālacaquilhnīlh huan tachi'xcuhuī't como tū' ixtaxtāpalīcu'tun ixtapāstacna'ca'n. Lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Xānti la'yā'tit hui'xina'n xalanī'n nac Corazín lā' xalanī'n nac Betsaida. Nalakaputzayā'tit porque tū' kalhlaka'ī'tit. Lej tlahuacanī't lē'cnīn na milaclhpu'nanca'n. Lā' palh ixcātlahuacancha' cahuā huā' tamā'na lē'cnīn nac huan cā'lacchicni' Tiro lā' nac Sidón, makāntza' ixtaxtāpalīlh ixtapāstacna'ca'n. Lā' xlaca'n ixtalhakā'lh tzi'tze'ke ixlu'xu'ca'n lā' ixcā'a'cpūmā'ca'ca lhca'ca'n lā' chuntza' ixtatasu'yulh que lej talakaputzalh ixpālacata ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Lā' iccāhuaniyāni' que a'xni'ca' Dios nalacāxtlahuakō', ā'chulā' nacācastigarlīyāni' hui'xina'n que xlaca'n xalanī'n nac Tiro lā' Sidón. ");
INSERT INTO tooNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Lā' hui'xina'n xalanī'n nac Capernaum puhua'nā'tit palh napinā'tit nac a'kapūn. Tū' stū'ncua'. Napinā'tit nac pūpātīn. Palh ixcātlahuacancha' cahuā huan lē'cnīn nac huan cā'lacchicni' Sodoma a'ntū cātlahuacanī't na milaclhpu'nanca'n, ixtaxtāpalīlh ixtapāstacna'ca'n. Lā' chuntza' Dios tū' ixmāsputūlh huan cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lā' iccāhuaniyāni' que a'xni'ca' Dios nalacāxtlahuakō', ā'chulā' nacācastigarlīyāni' hui'xina'n que xlaca'n xalanī'n nac Sodoma lā' ā'makapitzīn cā'lacchicni' pajtzu nac Sodoma ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lā' tuncan Jesús kalhtō'ka'lh lā' hualh: ―QuinTāta', hui'x māpa'ksīni'na' nac a'kapūn lā' nac ti'ya't. Icmaxquī'yāni' pāxcatca'tzī como cāmāsu'ni'nī'ta' huan a'ntīn tasca'tcu'tun ū'tza' a'ntū ixcāmātzē'kni'nī'ta' huan a'ntī lej lakskalalhna'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chuntza' tla'hua' chu a'nchī mintapuhuān. ");
INSERT INTO tooNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Lā' cāhuanilh huan tachi'xcuhuī't: ―QuinTāta' quimacamaxquī'kō'lh ixlīhuāk a'ntū a'nan. Lā' tintī' ca'tzī a'nchī huanī't ixO'kxa' Dios, xmān Dios xaTāta'. Lā' tintī' ca'tzī a'nchī huanī't quinTāta' Dios, xmān quit a'ntī ixO'kxa' icca'tzī. Nā nataca'tzī xlaca'n a'ntī na'iccāmālacsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Cata'ntit milīhuākca'n hui'xina'n a'ntī u'cxca'tzīyā'tit que tzi'nca huan tūn tū' tzey a'ntūn tlahuanī'ta'ntit lā' palha' scujpā'na'ntit para namakapāxua'yā'tit Dios. Cata'ntit lā' quit na'iccāmājaxīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Caquilā'a'kahuāna'ni'uj lā' caquilāmaksca'tui. Līlacatzucu na'iccāhuanilē'nāni' lā' quit tū' icka'tla'jca'tzī. Lā' quit tzē icmātza'ta'tī mi'a'clhcunucca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tū' jicslīhua' quilīmāsca'tīn lā' tzē natlōkentaxtūyā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lā' ā'calīstān Jesús ixtlā'huantēlha nac cā'tacuxtu. Lā' huan chi'chini' a'ntū pūjaxcan ixuanī't. Lā' ī'sca'txtunu'nī'n ixtatzi'ncsa lā' tatzuculh ta'ī' macstina'j huan trigo lā' tahua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lā' a'xni'ca' huan fariseosnu' cālaktzī'lh, tahuanilh Jesús: ―Cala'ktzi'. Tascujmā'na misca'txtunu'nī'n lā' chuhua'j huan chi'chini' a'ntū pūjaxcan. Tū' ta'a'kahuāna'ni' huan ixley Moisés ―tahuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Lā' Jesús cākalhtīlh lā' cāhuanilh: ―¿Chā tū' lakapūtle'kenī'ta'ntit a'ntūn tlahualh David maktin huā? Ixtzi'ncsa xla' lā' a'ntī ixcātā'a'mā'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Lā' tatanūlh na ixchic Dios lā' tahua'lh huan pāntzi a'ntū ixmālacnūni'canī't Dios. Lā' tū' līmakuan ixtahua'lh huā'mā' pāntzi. Xmān huan curasna' tzē natahua'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Lā' ¿chā tū' lakapūtle'kenī'ta'ntit huan nac ley a'ntūn tzo'kli Moisés? Huan palh huan curasna' a'ntīn tascuja nac xaka'tla' lītokpān pō'ktu tatlōkentaxtū ixlītlōtca'n. Lā' a'yuj tatlahua a'ntūn tū' līmakuan tlahuacan huan chi'chini' a'ntū pūjaxcan, lā' tū' puhuancan palh xlaca'n tatlahua talaclē'i'. Lā' tū' puhuancan palh xlaca'n tū' ta'a'kahuāna'ni' huan ley. ");
INSERT INTO tooNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lā' iccāhuaniyāni' que huā'tzā' a'nan catīhuā a'ntī līhua'ca' tasqui'nī que huan xaka'tla' lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Hui'xina'n tū' māchekxīnī'ta'ntit a'ntū huanicu'tun a'nlhā tatzo'kni' na ixtachihuīn Dios: “Quit lej iclacasqui'n nacālakalhu'manā'tit ā'makapitzīn lā' tū' tanto iclacasqui'n naquilā'a'ksajuī'yāuj huan animalhna'”. Palh ixmāchekxī'tit cahuā huā'mā' tachihuīn ixpālacata cālakalhu'mancan, tū' ixcālē'ksa'nīni'ntit quisca'txtunu'nī'n a'ntīn tū' tatlahuamā'na talaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quit huan Chi'xcu' xala' Tālhmā'n lā' tzē na'icmāpa'ksī a'ntū natlahuacan huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Lā' tuncan Jesús taxtulh de a'ntza' lā' tanūlh nac lakatin ixlītokpānca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Lā' ixuī' a'ntza' kalhatin chi'xcu' a'ntī ixpekescōhuanī't. Lā' como ixputzamā'ca a'nchī nalē'ksa'nīni'ncan Jesús, kalhasqui'nīca: ―¿Chā makxtekcan namātzeyīcan huan ī'tza'ca' huan chi'chini' a'ntū pūjaxcan? ");
INSERT INTO tooNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Lā' Jesús cākalhtīlh: ―Palh kalhatin de hui'xina'n ixka'lhī'tit mimborregoca'n a'ntū ixtojōlh huan nac pūlhmā'n taponkni', ¿chā tū' ixmāxtutit a'yuj huan chi'chini' a'ntū pūjaxcan? ");
INSERT INTO tooNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Lā' más ixtapalh kalhatin chi'xcu' que lakatin borrego. Chuntza' tzē tlahuani'can ā'kalhatin a'ntū xatzey lā' maktāyacan huan ā'kalhatin a'yuj huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Lā' tuncan huanilh huan chi'xcu': ―Castu'ncti mimpeken. Lā' a'xni'ca' stu'ncli ixpeken, ixtzeyanī'ttza' lā' ixtā'chuntza' ixuanī't kentin ixpeken. ");
INSERT INTO tooNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tuncan tataxtulh huan fariseosnu' lā' māni' ū'tunu'n tapāstacli a'nchī natalīmāmaknīnīni'n Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lā' a'xni'ca' Jesús ixca'tzī a'ntū ixtapuhuamā'na, lā' a'lh ā'lacatin lā' līlhūhua' tastālani'lh. Lā' Jesús cāmātzeyīkō'lh huan ī'tza'ca'nī'n ");
INSERT INTO tooNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","lā' cāmāpa'ksīlh que tū' catahualh tichū ū'tza'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chuntza' tlahualh para natlōkentaxtū a'nchī a'cta'sana'lh huan profeta Isaías a'xni'ca' tzo'kli a'ntū hualh Dios: ");
INSERT INTO tooNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Huā'mā' quintasācua' a'ntī iclacsacli lā' lej icpāxquī' lā' xla' lej quimakapāxuhua. QuiEspíritu natā'a'n lā' nacāmāsu'ni' huan a'ntīn tū' israelitas a'nchī xa'nca na'iclacāxtlahuakō'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Xla' tū' nalacaquilhnīni'n lā' tū' nata'sa. Lā' tū' palha' nachihuīna'n nac cā'tejen para que cuenta natlahuacan xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xla' nacāmaktāya huan a'ntīn tū' lactli'hui'qui a'ntī hua'chi xkoli' a'ntū xmū'tcanī't. Lā' tū' nacālakmaka'n huan a'ntīn tū' xa'nca takalhlaka'ī'. Xlaca'n hua'chi pūmaksko a'ntūn tū' xa'nca maksko lā' slam slam la. Nacāmaktāya hasta a'xni'ca' xla' nacāmāpa'ksīkō' ixlīhuākca'n tachi'xcuhuī't nac cā'ti'ya'tna'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Lā' ixlīhuākca'n tachi'xcuhuī't nataka'lhītī para nacāmaktāya. Chuntza' tzo'kli huan profeta Isaías. ");
INSERT INTO tooNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lā' tuncan lē'ni'ca Jesús kalhatin chi'xcu' a'ntī lakatzī'n lā' kō'ko' ixuanī't porque ixka'lhī huan tlajana'. Lā' Jesús mātzeyīlh lā' xa'nca ixlaktzī'n lā' tzuculh chihuīna'n. ");
INSERT INTO tooNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lā' ixlīhuākca'n tachi'xcuhuī't talē'cnīlh lā' tahualh: ―¿Chā ū'tza' huā'mā' ixtā'nat David a'ntī xa'icka'lhīmā'nauj? ");
INSERT INTO tooNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lā' a'xni'ca' huan fariseosnu' takaxmatli huā'mā' tachihuīn, tahualh: ―Huā'mā' chi'xcu' ka'lhī ixlīmāpa'ksīn huan Beelzebú a'ntī xapuxcu' huan tlajana'nī'n. Lā' ū'tza' cālīmāxtuni'lh huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ixca'tzī a'ntū ixtapuhuamā'na lā' cāhuanilh: ―Palh huan pūchihuīna'nī'n tatapitzi lā' talāsta'la, tūla tamāpa'ksīni'n makān. Natalāmāsputūkō'. Lā' palh xalanī'n lakatin cā'lacchicni' o lakatin familia tatapitzi lā' talātucsa, tū' catitatāyani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Lā' palh ixlīmāpa'ksīn huan xapuxcu' tlajana'nī'n a'ntū iclīmāxtu ā'lakatin tlajana', chuntza' talacpitzi huan līmāpa'ksīn. Lā' tū' catitāyani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hui'xina'n hua'nā'tit palh quit iccālīmāxtu huan tlajana'nī'n con ixlīmāpa'ksīn huan Beelzebú. Lā' ¿tichū ixlīmāpa'ksīn a'ntū cālīmāxtu huan tlajana'nī'n xlaca'n a'ntīn tatapa'ksī con hui'xina'n? Chuntza' māni' xlaca'n tamāsu'yu palh tū' stu'ncua' a'ntū quilālē'ksa'nīni'nāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A'ntū quit iccālīmāxtu huan tlajana'nī'n, ū'tza' ixlīmāpa'ksīn Espíritu Santo. U'tza' huanicu'tun palh Dios cāmāsu'ni'yāni' a'nchīn tzuculhtza' māpa'ksīni'n huā'tzā' nac cā'ti'ya'tna'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Tūla tanūcan para namakka'lhancan catūhuā na ixchic huan tli'hui'qui chi'xcu' palh tū' pū'la nachī'can huanmā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’A'ntīn tū' tapa'ksīcu'tun con quit, xla' quintā'ca'tza. Lā' a'ntīn tū' quintā'scuja, ū'tza' lactlahuana'n. ");
INSERT INTO tooNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’U'tza' iccālīhuaniyāni' palh tzē nacāmāsputūnu'ni'can ixlīhuākca'n ixtalaclē'i'ca'n tachi'xcuhuī't lā' chuxatū tū' tzey a'ntūn tahuan. Lā' palh catīhuā nahuan que tū' tzey a'ntūn tlahua huan Espíritu Santo, xla' tūlalh catimāsputūnu'ni'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lā' palh catīhuā nalīchihuīna'n contra huan Chi'xcu' xala' Tālhmā'n, namāsputūnu'ni'can. Lā' palh catīhuā nahuan que tū' tzey a'ntūn tlahua huan Espíritu Santo, xla' tū' catimāsputūnu'ni'ca nīn huā'tzā' nac huā'mā' quilhtamacuj nīn a'ntza' nac ā'lakatin quilhtamacuj a'ntū namin ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Lā' Jesús cāhuanipā: ―Palh tzey huan qui'hui', namāstā' tzey ixtō'ca't. Lā' palh tū' tzey huan qui'hui', tū' tzey nala ixtō'ca't. Chu a'nchī māstā' ixtō'ca't, chuntza' līlakapascan huan qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Hui'xina'n hua'chi lūhua' a'ntūn tzēhuanī't tasu'yu pero ka'lhī līlaknīn. ¿Chichū tzey nala huan tachihuīn a'ntū cāquilhtaxtuyāni' a'xni'ca' tū' tzey mintapāstacna'ca'n? Chu a'nchī pāstacā'tit, chuntza' nachihuīna'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tzey nala a'ntū nahuan kalhatin tzeyā chi'xcu' como tzey ixtapāstacna'. Lā' tū' tzey catihualh a'ntū nahuan kalhatin tū' tzeyā chi'xcu' como ko'hua'jua' ixtapāstacna'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Lā' iccāhuaniyāni' que namin lakatin chi'chini' a'xni'ca' Dios nacālacāxtlahuakō'. Lā' a'xni'ca' nala, maclacasqui'n ixlīhuākca'n tachi'xcuhuī't natahuani Dios tuchū ixpālacata chuxatūyā tachihuīn a'ntū chu tlakaj tahualh. ");
INSERT INTO tooNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chu a'nchī chihuīna'nī'ta'ntit, chuntza' nahuancan palh cātalīyāhuayāni' o palh lacuan hui'xina'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Lā' tuncan makapitzīn fariseosnu' lā' xamākalhtō'kē'ni'nī'n ley tahuanilh Jesús: ―Mākalhtō'kē'ni', quina'n iclaktzī'ncu'tunāuj lakatin ka'tla' lē'cnīn para naquilāmālacstū'ncni'yāuj palh stu'ncua' Dios macaminī'ta'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Lā' Jesús cākalhtīlh: ―Huan tachi'xcuhuī't a'ntīn tū' tzey lā' a'ntīn tū' takalhlaka'ī'cu'tun, xlaca'n tasqui'n lakatin ka'tla' lē'cnīn. Lā' xmān nacāmāsu'ni'can huan lē'cnīn hua'chi a'ntū pātle'keni'lh Jonás. ");
INSERT INTO tooNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Lakatu'tun chi'chini' lā' lakatu'tun tzī'sa Jonás ixtojōma' na ixchakān huan ka'tla' squī'ti' lā' xalakahuan taxtulh. Nā chuntza' quit huan Chi'xcu' xala' Tālhmā'n nā na'ictachoko lakatu'tun chi'chini' lā' lakatu'tun tzī'sa na ixchakān huā'mā' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Namin lakatin chi'chini' a'xni'ca' nalacāxtlahuakō'can. Lā' a'xni'ca' nala huā'mā', xlaca'n a'ntī ixtahui'lāna' huan nac cā'lacchicni' a'nlhā huanican Nínive natatāya lā' nacātalē'ksa'nīni'nāni' hui'xina'n a'ntī hui'lāna'ntit chuhua'j. Nacātalē'ksa'nīni'nāni' como xlaca'n taxtāpalīlh ixtapāstacna'ca'n a'xni'ca' milh Jonás lā' lī'a'cta'sana'lh ixtachihuīn Dios. Lā' hui'xina'n tū' xtāpalī'tit mintapāstacna'ca'n a'xni'ca' quit ica'cta'sana'lh. Lā' quit ā'chulā' ictasqui'nī que Jonás. ");
INSERT INTO tooNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Lā' nā huan reina a'ntī ixmāpa'ksīni'n nac Saba natāya lā' nacālē'ksa'nīni'nāni' a'xni'ca' namin huan chi'chini' a'ntū napūlacāxtlahuakō'. Nacālē'ksā'nīni'nāni' porque xla' kaxmatli a'ntū hualh Salomón. Makat ixuanī't ixchic huan reina lā' milh kaxmata Salomón. Quit ā'chulā' ictasqui'nī que Salomón lā' tū' quilākaxmatni'cu'tunāuj ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Lā' Jesús cāhuanipā: ―Lā' a'xni'ca' lakatin tlajana' nataxtu de huan chi'xcu', nalatā'kchoko a'nlhā cā'scōhua lā' naputza a'nlhā najaxa. Lā' a'xni'ca' tū' nakaksa a'nlhā najaxa, napuhuan: ");
INSERT INTO tooNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Na'ictaspi'tchokopala a'nlhā ictaxtulh”. Lā' a'xni'ca' naquītaspi'ta, nakaksa huan chi'xcu' hua'chi lakatin chic a'ntū scaya'ncyā lā' xa'nca pa'lhnancanī't, lā' a'nlhā nīn tintī' a'nan. ");
INSERT INTO tooNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Lā' tuncan na'a'n nacātē ā'kalhatojon tlajana'nī'n lā' más xaca'tzanca'tzīnī'n. Lā' ixlīhuākca'n natatanū natalatahui'la na ixchakān huan chi'xcu'. Lā' chuntza' más ko'hua'jua' nala huan chi'xcu' que a'xni'ca' ixka'lhī xmān kalhatin tlajana'. Lā' nā chuntza' nacāpātle'keni' xlaca'n a'ntīn tū' tzey lā' tahui'lāna' chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Lā' Jesús ixcātā'chihuīna'mā'cus huan tachi'xcuhuī't a'xni'ca' tachā'lh ixtzī't lā' ixtā'timīn. Ixtatachoko kēpūn lā' ixtatā'chihuīna'ncu'tun Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Lā' huanica Jesús: ―Tayāna' kēpūn mintzī't lā' mintā'timīn lā' mat tatā'chihuīna'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Lā' Jesús kalhtīlh huan a'ntī ixmāca'tzīnīnī't: ―¿Tichū quintzī't? Lā' ¿tichū quintā'timīn? ");
INSERT INTO tooNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Lā' tuncan Jesús cāmacahuanilh ī'sca'txtunu'nī'n lā' hualh: ―Huā' tamā'na, ū'tunu'n quintzī't lā' quintā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Lā' ixlīhuākca'n a'ntī natatlahua a'ntū lacasqui'n quinTāta' xala' nac a'kapūn, ū'tza' quintā'tin lā' ū'tza' quintzī't. ");
INSERT INTO tooNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Huā'mā' chi'chini' Jesús taxtulh de huan nac chic lā' a'lh na ixquilhtūn huan ka'tla' xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Lā' como lhūhua' tachi'xcuhuī't tatakēstokli a'nlhā ixuī', Jesús tojōlh nac lakatin barco lā' tahui'lalh. Lā' ixlīhuākca'n tachi'xcuhuī't tatachokolh nac huan ixquilhtūn huan xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Lā' tuncan cāhuanilh a'ntū hua'chi lītalacastuca para nacāmāsu'ni'. Chuntza cāhuanilh: ―Ixuī' kalhatin cha'nāna' lā' taxtulh nacha'n ixti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Lā' a'xni'ca' ī'xua'ya'maka'mā' ixti'ni', makapitzīn tayujli nac tej. Lā' tamilh huan spūnnu' lā' tasacua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Lā' ā'makapitzīn tayujli nac cā'chihuixni' a'nlhān tū' lhūhua' ixka'lhī huan ti'ya't. Palaj pu'nli huā'mā' ti'ni' como tū' lhūhua' ixka'lhī huan ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lā' a'xni'ca' chi'chini'lh, xachi'tin scōhualh como tūlalh tlahualh ixtankāxē'k lā' tīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Lā' ā'makapitzīn ti'ni' huampala tayujli nac cā'lhtucū'nnu'. Lā' huan lhtucū'n tastacli lā' tamā'ktzī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Lā' ā'makapitzīn ti'ni' tayujli a'nlhā tzey huan ti'ya't lā' lana'lh. Lā' makapitzīn ti'ni' tamāstā'lh cien lā' ā'makapitzīn tamāstā'lh tu'tumpu'xam lā' ā'makapitzīn tamāstā'lh pu'xamacāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Palh kaxpatnī'ta'ntit, cuenta catlahua'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lā' tuncan ī'sca'txtunu'nī'n talaktapajtzūlh Jesús lā' takalhasqui'nīlh: ―Lā' ¿a'chī' pō'ktu tā'mālacastuca' para nacāmāsu'ni'ya' huan tachi'xcuhuī't? ");
INSERT INTO tooNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Lā' Jesús cākalhtīlh: ―Dios cāmāsca'tīnī'ta'ni' hui'xina'n a'ntūn tatzē'knī't ixpālacata a'nchī nala ixlīmāpa'ksīn Dios. Pero xlaca'n tūlalh catitaca'tzīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Lā' huan a'ntī natakalhlaka'ī', xlaca'n natasca'ta lā' chuntza' natamāchekxī lā' ā'chulā' natakalhlaka'ī'. Pero huan a'ntīn tū' takalhlaka'ī'cu'tun, xlaca'n tū' catitasca'tli lā' natapātza'nkā a'ntū ixtaca'tzī. ");
INSERT INTO tooNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","U'tza' iccālīmāsu'ni' a'ntū tā'mālacastuccan. Xlaca'n talaktzī'n pero tū' tamāchekxī a'ntū huanicu'tun a'ntūn talaktzī'n. Nā takaxmata pero tū' tamāchekxī a'ntūn takaxmata. ");
INSERT INTO tooNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chuntza' xlaca'n tatlōkentaxtū chu a'nchī hualh huan profeta Isaías a'nlhān tzo'kli chuntza': Ixlīstu'ncua' que nakaxpa'tā'tit pero tū' catimāchekxī'tit. Lā' ixlīstu'ncua' que nalaktzī'nā'tit pero tū' cuenta catitlahua'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Huan tachi'xcuhuī't hua'chilh tū' taka'lhī ixtapāstacna'ca'n lā' cā'a'kachi'pacan lā' cālakachi'pacan. Chuntza' tū' catitalacahuāna'lh lā' tū' catita'a'kahuāna'lh lā' tū' catitamāchekxīlh para nataxtāpalī huan ixtapāstacna'ca'n. Lā' quit xa'iccāmāsputūnu'ni'lh lā' xa'iccāmātzeyīlh. Chuntza' tzo'kli Isaías a'nchī Dios hualh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Lā' Jesús huampā: ―Līpāxuhua'yā'tit como tzē lacahuāna'nā'tit lā' tzē a'kahuāna'nā'tit lā' nā tzē namāchekxī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Stu'ncua' a'ntū iccāhuaniyāni' que huā' tamā'na a'ntū cālaktzī'mpā'na'ntit, ū'tza' ixtalaktzī'ncu'tun lhūhua' a'cta'sana'nī'n lā' lhūhua' tzeyā tachi'xcuhuī't lā' tū' talaktzī'lh. Lā' nā chuntza' huā' tamā'na a'ntū hui'xina'n kaxpa'tā'tit, ū'tza' xlaca'n ixtakaxmatcu'tun lā' tū' takaxmatli. ");
INSERT INTO tooNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Lā' Jesús cāhuanipā: ―Chuhua'j cakaxpa'ttit a'ntū huanicu'tun huan a'ntū tā'mālacastuccan ixpālacata huan cha'nāna'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Huan a'ntīn takaxmata a'nchī nala a'xni'ca' Dios namāpa'ksīni'n lā' tū' tamāchekxī, xlaca'n hua'chi huan ti'ni' a'ntū yujli nac tej. Namin huan ko'ti'ti' lā' nacāmāpātza'nkānī a'ntūn tasca'tli. ");
INSERT INTO tooNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Lā' huan ti'ni' a'ntū yujli nac cā'chihuixni', ū'tza' tasu'yu hua'chi huan a'ntīn takaxmata huan tachihuīn lā' lej talakatī. ");
INSERT INTO tooNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Huā'mā' ti'ni' tū' ixka'lhī pūlhmā'n ixtankāxē'k lā' tū' tāyani'lh. Nā chuntza' huan tachi'xcuhuī't a'ntīn tū' xa'nca tamāchekxī, xlaca'n tū' makān tatāyani'. A'xni'ca' tapātī catūhuā o cāmacaputzacan por ixpālacata a'ntūn takalhlaka'ī'lh, tū'tza' talakatī lā' tamakxteka. ");
INSERT INTO tooNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lā' huan ti'ni' a'ntū yujli nac cā'lhtucū'nnu', ū'tza' tasu'yu hua'chi huan a'ntīn takaxmata lā' tamāchekxī. Pero lej tapāstaca a'nchī natatlaja ixlīhua'tca'n lā' a'nchī ricosnu' natalīla. Ixlīhuāk huā'mā' cāmāmakchuyī lā' tū' cāmakxteka natapāstaca a'ntūn takaxmatli. Tū'tza' tatasu'yu palh takalhlaka'ī' lā' ū'tza' huā'mā' hua'chi a'xni'ca' huan lhtucū'n tamā'ktzī'lh huan ti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Lā' huan ti'ni' a'ntū yujli a'nlhān tzey ti'ya't, ū'tza' hua'chi huan a'ntīn takaxmata huan xatzey tachihuīn lā' tamāchekxī. Lā' xa'nca tatasu'yu palh takalhlaka'ī'. Ixlīhuākca'n taka'lhī a'ntū natalīmāpāxuhuī Dios lā' makapitzīn lej taca'tzī tamāpāxuhuī hua'chi huan ti'ni' a'ntū māstā'lh cien ixtō'ca't ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Lā' Jesús tā'mālacastucpā: ―A'nchī Dios cāmāpa'ksīkō' tachi'xcuhuī't nala hua'chi a'xni'ca' kalhatin chi'xcu' cha'nli huan ti'ni' na ixtacuxtu. ");
INSERT INTO tooNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Lā' lakatin tzī'sa a'xni'ca' ī'lhtatamā' huan chi'xcu', ixtā'ca'tza quīxua'ya'maka'lh huan tūn tū' tzeyā ti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lā' a'xni'ca' ī'stacmā'tza' huan tacha'ni' a'xni'ca' tasu'yulh huan tūn tū' tzey tacha'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Lā' tuncan talakmilh ixtasācua'nī'n huan chi'xcu' lā' takalhasqui'nīlh huan ixpatronca'n: “¿Chā tū' huāk xatzey ti'ni' cha'nti na mintacuxtu? Lā' ¿chī līpu'nli huā'mā' tūn tū' tzeyā tacha'ni'?” ");
INSERT INTO tooNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Lā' huan patrón cākalhtīlh: “Kalhatin quintā'ca'tza quintlahuani'lh huā'mā'”. Lā' tuncan huan tasācua'nī'n takalhasqui'nīlh: “¿Chā lacasqui'na' na'ica'nāuj na'iccāpu'lhuyāuj huan tū' tzey chi'tin?” ");
INSERT INTO tooNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lā' xla' cākalhtīlh: “Tū', como lāsā' nacāpu'lhu'yā'tit nā huan xatzey tacha'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mejor nacāmakxtekāuj chu a'cxtim catastacli hasta a'xni'ca' na'ī'can. Lā' na'iccāhuani huan tasācua'nī'n a'ntī nata'ī' que pū'la natataya huan tū' tzey chi'tin lā' natachī' pixtunu' para nalhcuyucan. Lā' ā'calīstān nata'ī' huan xatzey tacha'ni' lā' natamāquī' na quimbodega”. ");
INSERT INTO tooNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Lā' Jesús tā'mālacastucpā: ―A'nchī natalīlhūhua'n a'ntī natakalhlaka'ī' Dios, ū'tza' nala hua'chi lakatin ti'ni' de mostaza a'ntū cha'nli kalhatin chi'xcu' nac ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Huā'mā' ti'ni' stu'ncua' līhua'ca' xamactzi'na'j que ixlīhuākca'n ā'makapitzīn ti'ni'. Lā' a'xni'ca' nastackō', lej ka'tla' nala hasta ixtā'chuntza' a'katin qui'hui'. Lā' huan spūnnu' natatlahua ixmāsekca'n na ixpekenī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Lā' Jesús tā'mālacastucpā: ―A'nchī Dios nalīmāpa'ksīni'n nala hua'chi levadura a'ntū huan puscāt namojō nac maktu'tun xatapūlhcān harina. Lā' naxcu'tankō' huan tasquit. ");
INSERT INTO tooNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Huāk huā'mā' Jesús cāhuanilh huan tachi'xcuhuī't lā' cālītā'chihuīna'lh a'ntū tā'mālacastuccan. Lā' xmān chuntza' ixcā'tā'chihuīna'n. ");
INSERT INTO tooNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chuntza' tlahualh lā' ū'tza' lītlōkentaxtūlh a'ntū hualh huan profeta a'xni'ca' tzo'kli huā'mā': Na'iccālītā'chihuīna'nāni' huan a'ntūn tā'mālacastuccan; na'icuan catūhuā a'ntūn tatzē'knī't desde a'xni'ca' tzuculh huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lā' tuncan Jesús cāmakxtekli huan tachi'xcuhuī't lā' xla' tanūlh huan nac chic. Lā' ī'sca'txtunu'nī'n talaktapajtzūlh lā' tahuanilh: ―Caquilāhuaniuj tuchū huanicu'tun huan a'ntūn tā'mā'lacastucti huan tū' tzeyā ti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lā' tuncan Jesús cāhuanilh: ―Huan a'ntī cha'nli huan xatzey ti'ni', ū'tza' huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lā' huan ixtacuxtu, ū'tza' huā'mā' quilhtamacuj. Huan xatzey ti'ni' cāmālacastuca xlaca'n a'ntīn tatapa'ksī con Dios. Lā' huan a'ntūn tū' tzey ti'ni' cāmālacastuca xlaca'n a'ntīn tatapa'ksī con huan ko'ti'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Huan tā'ca'tza a'ntī xua'ya'maka'lh huan tū' tzeyā ti'ni', ū'tza' māni' huan ko'ti'ti'. Lā' a'xni'ca' ī'can, ū'tza' huanicu'tun a'xni'ca' nasputa huā'mā' quilhtamacuj. Lā' huan tasācua'nī'n a'ntī nata'ī' huan chi'tin, ū'tunu'n huan ángeles. ");
INSERT INTO tooNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Lā' chu a'nchī nacātayacan huan tū' tzey chi'tin lā' nacālhcuyucan, chu a'cxtim napātle'ke a'xni'ca' nasputa huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Huan Chi'xcu' xala' Tālhmā'n nacāmāpa'ksī huan ixángeles para nacātaya ixlīhuākca'n huan a'ntīn tatlahua talaclē'i' lā' ixlīhuākca'n a'ntī tamāsu'ni' ā'makapitzīn natatlahua talaclē'i'. Lā' nacāmaxtukō' de a'nlhā xla' māpa'ksīni'n ");
INSERT INTO tooNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","lā' nacāmānū a'nlhā nacālhcuyucan. A'ntza' natacalhuan lā' natalāxca ixtatzanca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Lā' xlaca'n a'ntīn tatlahua ixlīmāpa'ksīn Dios, xlaca'n natatasu'yu a'nlhā Dios māpa'ksīni'n. Lā' lej tzēhuanī't natatasu'yu hua'chi a'xni'ca' lej xkaka huan chi'chini'. Palh kaxpa'tā'tit, cuenta catlahua'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Lā' Jesús cāhuanipā: ―Huan tachihuīn ixpālacata a'nchī Dios cālīmāpa'ksī ixtachi'xcuhuī't tzē nalīmālacastuccan lhūhua' tumīn a'ntū mā'cnūcanī't nac ti'ya't. Lā' namin kalhatin chi'xcu' lā' nakaksa huā'mā' tumīn. Lā' xla' namā'cnūpala a'nlhā ixuī'. Lā' lej līpāxūj na'a'n nastā'kō' ixlīhuāk a'ntū ka'lhī para natamāhua huā'mā' ti'ya't a'nlhā mā'cnūca huan tumīn. ");
INSERT INTO tooNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Lā' Jesús cāhuanipā: ―Nā huan tachihuīn ixpālacata a'nchī Dios līmāpa'ksīni'n, ū'tza' hua'chi kalhatin tamāhuana' a'ntī cāputzatēlha chihuix xalactzey a'ntū huanican perlas lā' a'ntū nacāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Lā' a'xni'ca' nakaksa lakatin a'ntū lej xatzey lā' lej tapala, nastā'kō' ixlīhuāk a'ntū ka'lhī lā' na'a'n natamāhua huanmā' perla. ");
INSERT INTO tooNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Lā' Jesús cāhuanipā: ―Nā a'nchī Dios cāmāpa'ksīkō' tachi'xcuhuī't ū'tza' hua'chi lakatin pūxuākna' a'ntū mojōcan nac mar lā' nacātaya tāpālhūhua' squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lā' a'xni'ca' tzuma huan pūxuākna', huan squī'ti'ni'nī'n natalē'n na ixquilhtūn mar lā' a'ntza' natatahui'la lā' natalacsaca huan squī'ti'. Huan xatzey squī'ti' nacāmojōcan nac chā'xta lā' huan a'ntūn tū' taka'lhī ixtapalh, nacāmaka'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chuntza' nala a'xni'ca' nasputa huā'mā' quilhtamacuj. Natataxtu huan ángeles lā' nacālaclhmāxtu huan tū' tzey tachi'xcuhuī't na ixlaclhpu'nanca'n xalactzey. ");
INSERT INTO tooNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Lā' huan tū' tzey tachi'xcuhuī't nacāmānūcan a'nlhā nacālhcuyucan lā' a'ntza' natacalhuan lā' natalāxca ixtatzanca'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tuncan Jesús cākalhasqui'nīlh: ―¿Chā māchekxīyā'tit ixlīhuāk huā'mā' a'ntū iccāhuanini'? Lā' xlaca'n takalhtīlh: ―U'huē, Māpa'ksīni', iccāmāchekxīni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Lā' tuncan cāhuanilh: ―A'xni'ca' kalhatin xamākalhtō'kē'ni' huan ley nala quisca'txtunu', xla' nala hua'chi kalhatin patrón. Nala hua'chi kalhatin patrón a'ntī cāka'lhī lhūhua' maclacasqui' lā' ca'tzī a'xni'ca' minī'ni' namāxtu catūhuā xala' makān lā' a'xni'ca' minī'ni' namāxtu catūhuā a'ntū sāsti'cus para nacāmaktāya ixfamilia. Chuntza' nala kalhatin a'ntīn tū' namakxteka huan līmāsca'tīn a'ntū xakōlūhua' lā' xastu'ncua' lā' nā xla' nasca'ta quilīmāsca'tīn a'ntū xasāsti'. ");
INSERT INTO tooNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lā' a'xni'ca' Jesús cāhuanikō'lh ixlīhuākca'n huan a'ntū tā'mālacastuccan, a'lh ā'lacatin ");
INSERT INTO tooNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","lā' chā'lh nac Nazaret a'nlhā stacli. A'ntza' ixmāsu'yu na ixlītokpānca'n israelitas. Lā' huan a'ntīn takaxmatli talē'cnīlh lā' talāhuanilh: ―Lā' huā'mā' chi'xcu', ¿lhachū sca'tli huā'mā' tapāstacna'? ¿Chichū tzē nacātlahua huā' tamā'na lē'cnīn? ");
INSERT INTO tooNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","U'tza' huā'mā' ixo'kxa' huan sitni' lā' nā María ixtzī't. Lā' ixtā'timīn cāhuanican Jacobo lā' José lā' Simón lā' Judas. ");
INSERT INTO tooNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Lā' ixlīhuākca'n ixtā'timīn xapuscan nā huā'tzā' tahui'lāna' na quilaclhpu'nanca'n. ¿Lhachū sca'tli ixlīhuāk huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Lā' chuntza' talakmaka'lh Jesús, pero xla' cāhuanilh: ―Kalhatin a'cta'sana' na'a'cnīni'ni'can chu xalhā na'a'n. Xmān xalanī'n na ixchic lā' xalanī'n ixā'lacchicni' tū' catita'a'cnīni'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Lā' a'ntza' na ixā'lacchicni' tū' lhūhua' lē'cnīn tlahualh Jesús xmān porque tū' takalhlaka'ī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lā' huā'mā' quilhtamacuj Herodes gobernador ixuanī't huan nac estado de Galilea. Lā' māca'tzīnīca ixpālacata Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Lā' Herodes cāhuanilh ixpūchihuīna'nī'n: ―U'tza' huā'mā' Juan huan Mā'kpaxīni'. Lakahuanchokonī't ixlaclhpu'nanca'n nīnī'n. U'tza' līka'lhī līmāpa'ksīn a'ntū lītlahua huan lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes ixmāpa'ksīnī't que cachi'paca huan Juan lā' calē'nca nac pūlāchī'n para nachī'can. Chuntza' māpa'ksīlh ixpālacata huan Herodías a'ntī ixpuscāt ixtā'tin Felipe ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan ixuanimā' Herodes: ―Tū' tzey a'nchī lī'pini'ya' huan Herodías hua'chi mimpuscāt. ");
INSERT INTO tooNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Lā' ū'tza' Herodes ixlīmaknīcu'tun huan Juan pero cājicua'ni'lh tachi'xcuhuī't como xlaca'n tapuhualh palh Juan ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lā' a'xni'ca' Herodes tlahuakō'lh ixcā'ta, tlahualh cā'tani'. Lā' ixtzu'ma'jāt Herodías lu'cxli na ixlacapūnca'n huan a'ntī ixcākantāyacanī't. Lej tanto makapāxualh huan Herodes ");
INSERT INTO tooNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","que lej huanilh palh ixmaxquī'lh huan tzu'ma'jāt chuxatū nasqui'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lā' tuncan huan xatzī't maxquī'lh tapāstacna' lā' huan tzu'ma'jāt squi'ni'lh Herodes chuntza': ―Caquima'xqui' chuhua'j ixa'kxāk Juan huan Mā'kpaxīni'. Calī'ta' nac lakatin pulātu. ");
INSERT INTO tooNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","U'tza' līlakaputzalh huan Herodes. Lā' como lej mālacnūni'canī't huan tzu'ma'jāt lā' como huan a'ntī ixcākantāyacanī't takaxmatli a'ntū ixuanicanī't, lā' ū'tza' huan Herodes līmāpa'ksīni'lh que camaxquī'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Lā' chuntza' macā'lh huan līmāpa'ksīn huan nac pūlāchī'n lā' māmāyujūnīni'lh ixa'kxāk Juan. ");
INSERT INTO tooNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Lā' tuncan līminca huan a'kxāk nac lakatin pulātu lā' maxquī'ca huan tzu'ma'jāt lā' xla' macamaxquī'lh ixtzī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Lā' tuncan tamilh ī'sca'txtunu'nī'n Juan lā' talē'lh ixmacni' lā' tamā'cnūlh. Lā' ā'calīstān ta'a'lh tamāca'tzīnī Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lā' a'xni'ca' māca'tzīnīca Jesús, xla' tojōlh nac lakatin barco lā' a'lh tintacut a'nlhā tintī' ixa'nan. Lā' a'xni'ca' ca'tzīca a'nlhā ixuī', lhūhua' tachi'xcuhuī't tataxtulh de ixā'lacchicni'ca'n lā' tastālani'lh catojon na ixquilhtūn huan xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lā' a'xni'ca' Jesús tacutli de huan nac barco, cālaktzī'lh huan lhūhua' tachi'xcuhuī't lā' cālakalhu'malh. Lā' cāmātzeyīlh huan ī'tza'ca'nī'n a'ntī ixcālīmini'canī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lā' a'xni'ca' ī'smalanka'namā', ī'sca'txtunu'nī'n Jesús talakmilh lā' tahuanilh: ―Kōtanūtza' lā' tū' nac cā'lacchicni' huā'tzā'. Cacāmacapi huan tachi'xcuhuī't para nata'a'n natatamāhua ixlīhua'tca'n nac huan cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Lā' Jesús cākalhtīlh: ―Tū' maclacasqui'n nata'a'n; cacāmāhuī'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Lā' xlaca'n tahuanilh: ―Quina'n tuntū' icka'lhīyāuj xmān macquitzis pāntzi lā' tantu' squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Lā' Jesús cāhuanilh: ―Cacālī'ta'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Lā' tuncan cāmāpa'ksīlh que catatahui'lalh huan tachi'xcuhuī't nac cāseketni'. Lā' chu tuncan Jesús cātayalh huan macquitzis pāntzi lā' huan tantu' squī'ti' lā' talacayāhualh nac a'kapūn lā' maxquī'lh pāxcatca'tzī Dios. Lā' cāche'keni'lh huan pāntzi lā' huan squī'ti' lā' cāmaxquī'lh ī'sca'txtunu'nī'n. Lā' xlaca'n tamālacpitzilh na ixlaclhni'ca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Lā' ixlīhuākca'n tachi'xcuhuī't tahuā'yalh lā' taka'sli. Lā' a'xni'ca' tahuā'yankō'lh huan sca'txtunu'nī'n tamākēstokli lhūhua' xalacpitzin hasta tatzumalh pācāujtu' chā'xta de huan a'ntū a'katāxtūlh. ");
INSERT INTO tooNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Lā' huan chi'xcuhuī'n a'ntīn tahuā'yalh xlaca'n lakaquitzis mil lā' nā tahuā'yalh puscan lā' camana'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lā' chu tuncan Jesús cāhuanilh ī'sca'txtunu'nī'n catatojōlh huan nac barco lā' catapū'lani'lh tintacut huan mar līhuan xla' cāmacā'lh huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Lā' a'xni'ca' ixcāmacā'nkō'nī't, Jesús ixa'cstu tā'cxtunu'lh huan nac kēstīn para natā'chihuīna'n Dios. Lā' a'xni'ca' tzī'sualh, ixa'cstu ixuī' a'ntza' ");
INSERT INTO tooNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","līhuan ī'sca'txtunu'nī'n ixtatētaxtumā'na huan nac xcān nac barco. Lā' lej ū'nulh lā' xasipej xcān ixtatā'kayāhuamā'na lā' tasno'kli huan barco. ");
INSERT INTO tooNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lā' a'xni'ca' tuncuīlh, Jesús ixcālaktapajtzūtēlha xlaca'n. Ixkalhtlā'huantēlha huan xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lā' a'xni'ca' huan sca'txtunu'nī'n talaktzī'lh kalhatin a'ntī ixkalhtlā'huantēlha huan xcān, cāmakē'klhalh lā' tajicuani'lh lā' palha' tahualh: ―¡Lakachuyayāuj! ");
INSERT INTO tooNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Lā' Jesús cāhuanilh: ―Cahuixcāna'jca'tzītit lā' tū' cajicua'ntit. Xmān quit. ");
INSERT INTO tooNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Lā' tuncan Pedro huanilh: ―Māpa'ksīni', palh stu'ncua' hui'x, caquihua'ni' na'ickalhtlā'huan huan xcān para na'icpāxtokāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Lā' Jesús huanilh: ―Pues cata't. Lā' tuncan Pedro tacutli de nac barco lā' tzuculh kalhtlā'huan huan xcān para napāxtoka Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Lā' a'xni'ca' cuenta tlahualh huan palha' ū'ni', tajicua'lh lā' tzuculh tā'cnū lā' palha' hualh: ―¡Caquimāpūtaxtu, Māpa'ksīni'! ");
INSERT INTO tooNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lā' chu tuncan Jesús makachi'palh lā' huanilh: ―Xmān macsti'na'j kalhlaka'ī'ya'. ¿A'chī' tū' quilīpāhua'na'? ");
INSERT INTO tooNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Lā' a'xni'ca' xlaca'n tatojōlh nac barco, ca'cs lalh huan ū'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lā' tuncan xlaca'n a'ntī ixtahui'lāna' nac barco tamācā'tanīlh Jesús lā' tahuanilh: ―Stu'ncua' hui'x ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lā' ta'a'lh tintacut huan xcān lā' tachā'lh huan nac ti'ya't a'nlhā huanican Genesaret. ");
INSERT INTO tooNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Lā' a'xni'ca' huan tachi'xcuhuī't xalanī'n a'ntza' talakapasli Jesús, tamāca'tzīnīni'lh chuxalhā nac huā'mā' ti'ya't. Lā' cālīmini'ca lhūhua' ī'tza'ca'nī'n a'nlhā ixuī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lā' tasqui'ni'lh que cāmakxtekli xmān ixtaxa'malh ixtampān ixlu'xu'. Lā' tatzeyalh ixlīhuākca'n a'ntīn taxa'malh. ");
INSERT INTO tooNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lā' tuncan makapitzīn fariseosnu' lā' xamākalhtō'kē'ni'nī'n huan ley talaktapajtzūlh Jesús. Ixtaminī'ta'ncha' de huan xcānsipej Jerusalén lā' takalhasqui'nīlh: ");
INSERT INTO tooNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Lā' misca'txtunu'nī'n, ¿a'chī' tū' ta'a'kahuāna'ni' ixtalanānca'n huan xanapuxcu'nu' lītokpān xalanī'n makāntza'? Tū' tamakacha'ka'n a'nchī maclacasquī'n a'xni'ca' natahuā'yan ―tahuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Lā' Jesús cākalhasqui'nīlh: ―Nā hui'xina'n, ¿a'chī' mākēnū'yā'tit ixlīmāpa'ksīn Dios para nacātlōkentaxtūyā'tit mintalanānca'n? ");
INSERT INTO tooNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios hualh: “Nacā'a'kahuāna'ni'ya' mintāta' lā' mintzī't”. Lā' nā hualh: “Camāmaknīnīni'nca huan a'ntī cāmacapūlhca ixtāta' o ixtzī't”. ");
INSERT INTO tooNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Lā' hui'xina'n xtunc hua'nā'tit. Lā' hui'xina'n māsu'yu'yā'tit palh kalhatin chi'xcu' tzē nahuani ixtāta' o ixtzī't: “Tūla icmaktāyayāni' como ixlīhuāk a'ntū icka'lhī icmālacnūni'nī'ttza' Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Lā' hui'xina'n māsu'yu'yā'tit que palh kalhatin chuntza' nahuan, tū'tza' maclacasqui'n xla' namaktāya ixtāta' o ixtzī't. Chuntza' hui'xina'n māpānū'yā'tit ixlīmāpa'ksīn Dios para natlōkentaxtūyā'tit mintalanānca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Tlahua'pā'na'ntit lakatu' milacanca'n! Stu'ncua' a'nchī cālīchihuīna'ni' hui'xina'n huan profeta Isaías a'xni'ca' tzo'kli huā'mā': ");
INSERT INTO tooNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Huā' tamā'na tachi'xcuhuī't xmān tahuan palh quinta'a'cnīni'ni' pero tū' tapāstaca a'ntū iccālīmāpa'ksīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chu tlakaj quintamāca'tanī como a'ntūn tamāsu'yu hua'chilh quilīmāpa'ksīn, ū'tza' xmān ixtapuhuānca'n huan chi'xcuhuī'n. Chuntza' tzo'kli Isaías a'nchī hualh Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Lā' tuncan Jesús cāmāta'sīlh huan tachi'xcuhuī't lā' cāhuanilh: ―Cakaxpa'ttit lā' camāchekxī'tit: ");
INSERT INTO tooNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Huan a'ntū naquilhtanū huan chi'xcu' tū' ū'tza' a'ntū nalīla ko'hua'jua'. Pero huan tūn tū' tzey tachihuīn a'ntū quilhtaxtu huan chi'xcu', ū'tza' nalīla ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Lā' tuncan huan sca'txtunu'nī'n talaktapajtzūlh lā' tahuanilh Jesús: ―¿Chā ca'tzīya' palh cālīmakā'kchipina' huan fariseosnu' a'nchī hua'na'? ");
INSERT INTO tooNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Lā' xla' cākalhtīlh: ―Chuxatūyā ti'ni' a'ntūn tū' cha'nli quinTāta' xala' nac a'kapūn, ū'tza' napu'lhucan lā' con ixtankāxē'k. ");
INSERT INTO tooNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Cacāma'kxtektit huan fariseosnu'. Xlaca'n hua'chi lakatzī'nī'n a'ntīn talē'n ā'makapitzīn lakatzī'nī'n. Lā' palh kalhatin lakatzī'n namakachi'palē'n ixtā'lakatzī'n, ixtu'ca'n natamokōsa a'nlhā ponknu'ncanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Lā' tuncan Pedro huanilh Jesús: ―Caquilāhuaniuj a'ntū huanicu'tun huā'mā' a'ntū tā'mālacastucti. ");
INSERT INTO tooNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Lā' Jesús huanilh: ―¿Chā tū' māchekxī'yā'tit nīn hui'xina'n? ");
INSERT INTO tooNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ca'tzīyā'tit que chuxatū a'ntū naquincāquilhtanūyāni', ū'tza' nayuja na quimpānca'n lā' ā'calīstān nataxtu. ");
INSERT INTO tooNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Lā' huan tachihuīn a'ntū naquincāquilhtaxtuyāni', ū'tza' a'ntū pāstacnī'tauj pū'la. Lā' ū'tza' nalītasu'yu palh tzey quina'n o tū'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chu a'nchī pāstacna'n huan chi'xcu', chuntza' natlahua: namaknīni'n, o namakpuscatīni'n, o naka'lhī ixtatā'chihuīn, o naka'lhāna'n, o na'a'kxokonu'n, o na'a'ksa'nan. ");
INSERT INTO tooNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Huāk huā' tamā'na palh ixtlahualh cahuā huan chi'xcu', ū'tza' nalīla ko'hua'jua'. Pero palh nahuā'yan a'xni'ca' tū' makacha'ka'nī't chu a'nchī huan talanān, ū'tza' tūla nalīla ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús taxtulh de a'ntza' lā' a'lh ā'lacatin a'nlhā tahui'lāna' huan lakatu' cā'lacchicni' a'ntū huanican Tiro lā' Sidón. ");
INSERT INTO tooNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Lā' ixui'lacha' kalhatin puscāt xala' nac huanmā' ti'ya't a'nlhā huanican Canaán. Xla' tū' israelita ixuanī't. Lā' lakmilh Jesús lā' huanilh: ―Māpa'ksīni', hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj; caquilakalhu'ma'nti. Quintzu'ma'jāt ka'lhī huan tlajana' lā' lej palha' pātīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Lā' Jesús nīn tuntū' kalhtīlh. Lā' tuncan tamilh ī'sca'txtunu'nī'n lā' tasqui'nli: ―Cama'capi huan puscāt a'jnanu' como quincāstālani'yāni' lā' ta'satēlha. ");
INSERT INTO tooNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Lā' tuncan Jesús hualh: ―Dios quimacaminī't para na'iccāmāpūtaxtū xmān a'ntī israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Lā' huan puscāt laktapajtzūlh lā' tatzokostani'lh Jesús lā' huanilh: ―¡Māpa'ksīni', caquimaktāya'! ");
INSERT INTO tooNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Lā' Jesús kalhtīlh: ―Tū' līmakuan maklhtīcan ixlīhua'tca'n huan camana' lā' nacāmaxquī'can huan chichīn―chuntza' huanilh como huan israelitas tū' ixta'a'cnīni'ni' huan a'ntīn tū' israelitas lā' ixcāmāpācuhuī chichīn. ");
INSERT INTO tooNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lā' xla' huanilh: ―U'huē, ū'tza' icca'tzī, Māpa'ksīni'. Pero huan chichīn tzē natahua' huan lacpītzin a'ntū nataminācha' na ixmesa ixtēcu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tuncan Jesús kalhtīlh: ―Lej kalhlaka'ī'ya', puscāt. Calalh hua'chi quisqui'ni'ya'. Lā' huanmā' ka'tlā'tus tzeyalh ixtzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Lā' Jesús taxtulh de a'ntza' lā' tētaxtulh ixquilhtūn huan lago Galilea. A'calīstān tā'cxtunu'lh nac kēstīn lā' a'ntza' tahui'lalh. ");
INSERT INTO tooNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lā' līlhūhua' tachā'lh a'nlhā ixuī' lā' talīmini'lh lū'ntū'lani'nī'n lā' lakatzī'nī'n lā' kō'ko'nī'n lā' huan a'ntī macamōcho lā' lhūhua' ā'makapitzīn ī'tza'ca'nī'n. Cāmāpī'ca nac ti'ya't pajtzu ixtojon Jesús lā' xla' cāmātzeyīlh ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lā' huan tachi'xcuhuī't talē'cnīlh a'nchīn tachihuīna'lh huan a'ntī kō'ko' ixtahuanī't lā' a'nchī tzey ixtalanī't ixmacanca'n huan macamōcho. Lā' huan lū'ntū'lanī'n xa'nca tatlā'hualh lā' huan lakatzī'nī'n talacahuāna'lh. U'tza' talīlē'cnīlh huan tachi'xcuhuī't. Lā' tatzuculh tamācā'tanī Dios a'ntī nā ixDiosca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Lā' tuncan Jesús cāta'sani'lh ī'sca'txtunu'nī'n lā' cāhuanilh: ―Iccālakalhu'man huan tachi'xcuhuī't. Tu'tuma'jtza' quintatā'lahui'lāna' huā'tzā' lā' tū'tza' taka'lhī a'ntūn tahua'. Lā' palh na'icmacā'n na ixchicca'n lā' tū' tahuā'yanī't, tzēlasā' nataxlejua'nan nac tej. ");
INSERT INTO tooNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lā' tuncan ī'sca'txtunu'nī'n tahuanilh: ―¿Chichū nalīka'lhīyāuj līhua't a'ntū natalīka'sa? Lej lhūhua' tachi'xcuhuī't lā' tintī' lahuī' huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Lā' Jesús cākalhasqui'nīlh: ―¿Lhā maclā't pāntzi ka'lhī'yā'tit? Lā' xlaca'n takalhtīlh: ―Mactojon lā' makapitzīn ti'na'j squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Lā' tuncan Jesús cāmāpa'ksīlh que catatahui'lalh huan tachi'xcuhuī't nac ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Xla' cātayalh huan mactojon pāntzi lā' huan squī'ti' lā' maxquī'lh pāxcatca'tzī Dios. Lā' chu tuncan cāmālacpitzini'lh lā' cāmaxquī'lh ī'sca'txtunu'nī'n lā' xlaca'n cāmaxquī'lh huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lā' ixlīhuākca'n tahuā'yalh lā' taka'sli. Lā' ā'calīstān xalacpītzin a'ntūn ta'a'katāxtūlh cāmātzumalh pātojon chā'xta. ");
INSERT INTO tooNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huan a'ntīn tahuā'yalh, xlaca'n lakatā'ti' mil chi'xcuhuī'n. Lā' nā tahuā'yalh puscan lā' camana'. ");
INSERT INTO tooNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lā' ā'calīstān Jesús cāmacā'lh huan tachi'xcuhuī't lā' tojōlh huan nac barco lā' a'lh nac lakatin ti'ya't a'nlhā huanican Magdala. ");
INSERT INTO tooNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Huan fariseosnu' lā' huan saduceosnu' talaka'lh Jesús. Lā' como ixtalīlaktzī'ncu'tun, tasqui'nli lakatin lē'cnīn a'ntū lītasu'yu que Jesús xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Lā' xla' cākalhtīlh: ―A'xni'ca' tā'cnūmā' huan chi'chini', hui'xina'n hua'nā'tit: “Tū' catimilh xcān como spi'nenke' huan a'kapūn”. ");
INSERT INTO tooNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Lā' palh tzi'sāt, hua'nā'tit: “Chuhua'j namin xcān como spi'nenke' huan a'kapūn lā' pucsuī'”. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Tzē naquilhchipinā'tit palh namin xcān a'xni'ca' laktzī'nā'tit huan a'kapūn. Lā' a'yuj laktzī'nā'tit huan lē'cnīn a'ntū ictlahua, pero tū' kalhlaka'ī'yā'tit que Dios quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Huan tachi'xcuhuī't a'ntīn tahui'lāna' chuhua'j tū' tzey lā' tū' takalhlaka'ī' lā' xlaca'n tasqui'n lē'cnīn. Lā' tū' nacāmāsu'ni'can lē'cnīn; xmān naquimpātle'keni' hua'chi a'ntū pātle'keni'lh huan Jonás ―hualh Jesús. Lā' cāmakxtekli lā' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Lā' a'xni'ca' huan sca'txtunu'nī'n ta'a'lh tintacut huan lago, tū' talē'lh pāntzi. Tapātza'nkālh. ");
INSERT INTO tooNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Lā' tuncan Jesús cāhuanilh: ―Catamaktaka'lhtit de ixlevaduraca'n huan fariseosnu' lā' huan saduceosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Huan sca'txtunu'nī'n tatzuculh talāhuani: ―Chuntza' hualh como tū' līmiuj pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Lā' Jesús ixca'tzī a'ntū ixtalāhuanimā'na lā' cāhuanilh: ―¿A'chī' cāpāta'layāni' ixpālacata huan pāntzi a'ntūn tū' līta'ntit? ¡Xmān macsti'na'j kalhla'ka'ī'yā'tit! ");
INSERT INTO tooNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Chā tūna'j machekxī'yā'tit? ¿Chā tū'tza' pāstacā'tit huan macquitzis pāntzi a'ntū iccāmālacpitzini'lh na ixlaclhpu'nanca'n lakaquitzis mil chi'xcuhuī'n? Lā' ¿lhām pālā't chā'xta cālīmātzumaca huan xalacpītzin? ");
INSERT INTO tooNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Lā' capāstactit huan mactojon pāntzi a'ntū iccāmālacpitzini'lh na ixlaclhpu'nanca'n huan lakatā'ti' mil chi'xcuhuī'n. Lā' ¿lhām pālā't chā'xta cālīmātzumaca huan xalacpītzin? ");
INSERT INTO tooNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿A'chī' tū' māchekxī'yā'tit palh tū' xa'icuanicu'tun pāntzi a'xni'ca' iccāhuanini' ixtamaktaka'lhtit de ixlevaduraca'n huan fariseosnu' lā' huan saduceosnu'? ");
INSERT INTO tooNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lā' tuncan tamāchekxīlh que Jesús tū' ixcāhuaninī't que ixtamaktaka'lhli huan ixlevadura pāntzi. Ixcāhuanicu'tun palh ixtamaktaka'lhli ixlīmāsca'tīnca'n huan fariseosnu' lā' huan saduceosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Lā' a'xni'ca' Jesús chā'lh a'nlhā huanican Cesarea de Filipo, cākalhasqui'nīlh ī'sca'txtunu'nī'n: ―Lā' huan tachi'xcuhuī't, ¿chichū tahuan quimpālacata quit a'ntī huan Chi'xcu' xala' Tālhmā'n? ");
INSERT INTO tooNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xlaca'n takalhtīlh: ―Makapitzīn tahuan palh hui'x Juan huan Mā'kpaxīni'. Lā' ā'makapitzīn tahuan palh hui'x huan Elías. Lā' ā'makapitzīn huampala tahuan palh hui'x Jeremías o ā'kalhatin a'cta'sana'. ");
INSERT INTO tooNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Lā' tuncan cākalhasqui'nīlh: ―Lā' ¿chī hua'nā'tit? ¿Tichū quit? ");
INSERT INTO tooNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lā' tuncan Simón Pedro huanilh: ―Hui'x huan Cristo a'ntī xa'icka'lhīmā'nauj lā' ixO'kxa' huan scana'nca Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Lā' Jesús kalhtīlh: ―Līpāxūj hui'x, Simón ixo'kxa' Jonás. Huā'mā' tapāstacna' tū' tamāsu'ni'ni' chi'xcuhuī'n. Xmān Dios māca'tzīnīni'. ");
INSERT INTO tooNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Lā' quit icuaniyāni' que hui'x Pedro lā' ū'tza' mintacuīni' huanicu'tun “chihuix”. Lā' hui'x nala hua'chi huan chihuix a'ntū xalītzucuni' huan quilītokpān. Lā' ixlīhuākca'n a'ntīn takalhlaka'ī' chuntza', tū' caticātlajaca; nīn huan līnīn tūla nacātlaja. ");
INSERT INTO tooNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Quit na'icmaxquī'yāni' līmāpa'ksīn lā' nacāmāpa'ksī'ya' xlaca'n a'ntīn tatapa'ksī con Dios. Lā' a'ntū hui'x makxteka tlahuacan na ixlaclhpu'nanca'n a'ntīn takalhlaka'ī' ixtachihuīn Dios huā'tzā' nac cā'quilhtamacuj, nā nac a'kapūn nā chuntza' nahuancan. Lā' a'ntū hui'x tū' makxteka tlahuacan na ixlaclhpu'nanca'n a'ntīn takalhlaka'ī' ixtachihuīn Dios huā'tzā' nac cā'quilhtamacuj, nā nac a'kapūn nā chuntza' nahuancan. ");
INSERT INTO tooNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Lā' tuncan Jesús cāmāpa'ksīlh ī'sca'txtunu'nī'n que tū' catitahuanilh nīn tintī' palh ū'tza' huan Cristo a'ntī ixka'lhīmā'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lā' tuncan Jesús tzuculh cāmāsu'ni' ī'sca'txtunu'nī'n chuntza': ―Maclacasqui'n na'ica'n nac Jerusalén. Lā' a'ntza' huan xanapuxcu'nu' lītokpān lā' huan xanapuxcu'nu' curasna' lā' huan xamākalhtō'kē'ni'nī'n huan ley, xlaca'n lej naquintamāpātīnī. Lā' naquintamaknī. Lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko. ");
INSERT INTO tooNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Lā' tuncan Pedro lē'lh lacachuna'j lā' tzuculh tā'lāsta'la lā' tzē'k huanilh: ―¡Māpa'ksīni', tū' camakxtekli Dios! ¡Tū' catipātle'keni'ni' chuntza'! ");
INSERT INTO tooNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús talakspi'tli lā' huanilh Pedro: ―¡Catakēnu'! Hui'x puhua'na' hua'chi huan ko'ti'ti'. Lā' hui'x quimāmakchu'yī'ya'. Hui'x tū' puhua'na' hua'chi Dios lacasqui'n; puhua'na' chuntza' hua'chi chi'xcuhuī'n tapuhuan. ");
INSERT INTO tooNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Lā' tuncan Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Palh catīhuā tapa'ksīcu'tun con quit, tūlatza' pāstaca xmān a'nchī xla' lacasqui'n. Calīhui'līlh natlahua quintapuhuān a'yuj capātīni'lh hua'chi quit na'icpātīni'n lā' caquistālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huan a'ntīn tapūtaxtucu'tun de huan a'ntū natapātīni'n por quimpālacata, tū' catitaka'lhīlh ixquilhtamacuj para pō'ktu. Lā' huan a'ntī natapātīni'n a'yuj natanī por quimpālacata, xlaca'n nataka'lhī ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Lā' palh huan chi'xcu' ixtlajalh cahuā ixlīhuāk xala' huā'mā' quilhtamacuj, tuntū' ixtapalh palh tū' ka'lhī ixquilhtamacuj para pō'ktu. Tū' a'nan a'ntū xla' tzē namāstā' para naka'lhī ixquilhtamacuj para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quit huan Chi'xcu' xala' Tālhmā'n lā' na'icmimpala con ixlīmāpa'ksīn xaTāta' lā' lej na'icxkaka hua'chi quinTāta' nac a'kapūn lej xkaka. Lā' naquintatā'min qui'ángeles. Lā' a'xni'ca' na'icmin, chā'tunu' namāpala chu a'nchī tlahuanī't palh tzey o tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Stu'ncua' a'ntū iccāhuaniyāni'. A'nan makapitzīn a'ntīn tahui'lāna' huā'tzā' chuhua'j lā' xlaca'n tū' catitanīlh a'xni'ca' tūna'j naquilaktzī'ncan quit huan Chi'xcu' xala' Tālhmā'n a'xni'ca' na'icmimpala para na'icmāpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Lā' ixlīlakachāxan chi'chini' a'xni'ca' Jesús cālē'lh Pedro lā' Jacobo lā' Juan a'ntī ixtā'tin Jacobo lā' a'lh. Xmān ixkalhatā'ti'ca'n ta'a'lh nac lakatin kēstīn tālhmā'n lā' tā'cxtulh. ");
INSERT INTO tooNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Lā' a'ntza' taxtāpalīlh Jesús lā' xtunc ixtasu'yu na ixlacapūnca'n. Ixlacan Jesús lā' ixlu'xu' taxkakalh hua'chi xkaka huan chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lā' chu tuncan cātasu'yuni'lh Moisés lā' Elías a'ntī ixtatā'chihuīna'mā'na Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lā' tuncan Pedro huanilh Jesús: ―Māpa'ksīni', xalītzey hui'lāna'uj huā'tzā'. Palh lacasqui'na', quina'n na'icyāhuayāuj lakatu'tun mū'xta'ka'. Lakatin nala mila' lā' lakatin nala ixla' Moisés lā' ā'lakatin nala ixla' Elías. ");
INSERT INTO tooNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ixchihuīna'mā'cus Pedro lā' milh lakatin poklhnu' a'ntū slamama lā' cālītamacxti'li'lh. Lā' kaxmatca lakatin tachihuīn nac poklhnu' lā' hualh: ―U'tza' huā'mā' qui'O'kxa' lā' lej icpāxquī'. Lā' xla' lej quimakapāxuhua. Cakaxpa'ttit a'ntū huan. ");
INSERT INTO tooNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","A'xni'ca' huan sca'txtunu'nī'n takaxmatli huā'mā' tachihuīn, lacataj tatamā'lh lā' lej tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Lā' tuncan Jesús cālaktapajtzūlh lā' cāxa'malh lā' cāhuanilh: ―Catāquī'tit lā' tū' cajicua'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lā' a'xni'ca' tatāquī'lh lā' talaktzī'lh, nīn tintī' ixa'nan, xmān Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lā' a'xni'ca' ixta'a'mā'na na ixtatokopūn huan kēstīn, Jesús cāmāpa'ksīlh: ―Tū' catihua'ni'tit nīn tintī' a'ntū laktzī'ntitcus. Tū' catihua'ntit hasta a'xni'ca' tū' nalakahuanchoko de na ixlaclhpu'nanca'n nīnī'n huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lā' tuncan huan sca'txtunu'nī'n takalhasqui'nīlh Jesús: ―Lā' ¿a'chī' tahuan huan xamākalhtō'kē'ni'nī'n huan ley palh huan Elías ka'lhī napū'lani' huan a'ntī Dios namacamin? ");
INSERT INTO tooNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Lā' Jesús cākalhtīlh: ―Stu'ncua' huā'mā'. Pū'la namin Elías lā' nacāxtlahuakō' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Lā' iccāhuaniyāni' palh milhtza' huan Elías lā' tū' lakapascanī't. Tū' ta'a'kahuāna'ni'lh lā' tamaknīlh. Lā' nā chuntza' huan Chi'xcu' xala' Tālhmā'n namāpātīnīcan ixpālacataca'n xlaca'n ―cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lā' tuncan huan sca'txtunu'nī'n tamāchekxīlh que a'xni'ca' Jesús hualh ixminī'ttza' Elías, ixlīchihuīna'mā' Juan huan Mā'kpaxīni'. ");
INSERT INTO tooNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lā' a'xni'ca' tachā'lh a'nlhā ixtahui'lāna' huan tachi'xcuhuī't, kalhatin chi'xcu' laktapajtzūlh lā' tatzokostani'lh Jesús lā' huanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Māpa'ksīni', calakalhu'ma'nti quincaman. Lej xtacnānī lā' lej palha' pātīni'n. Maklhūhua'tza' tapū' nac macscut o tojō nac xcān. ");
INSERT INTO tooNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Iccālīmini'lh misca'txtunu'nī'n pero tūlalh tamātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Lā' Jesús cāhuanilh: ―¡Hui'xina'n tachi'xcuhuī't a'ntīn tū' xa'nca pāstacna'nā'tit lā' tū' kalhlaka'ī'yā'tit! ¿Hasta lhānīn na'iccātā'latahui'layāni' hui'xina'n para que namāchekxī'yā'tit? Lā' ¿hasta lhānīn na'iccātāyani'yāni' hui'xina'n a'nchī huanī'ta'ntit? Caquilī'ta'ni' huan ka'hua'chu. ");
INSERT INTO tooNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Lā' tuncan Jesús lacaquilhnīlh huan tlajana' lā' tuncan taxtuni'lh huan ka'hua'chu. Lā' chu līmaktin tzeyalh. ");
INSERT INTO tooNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Lā' ā'calīstān huan sca'txtunu'nī'n ixa'cstuca'n ixtatā'chihuīna'mā'na Jesús lā' takalhasqui'nīlh: ―Lā' ¿a'chī' tūlalh quina'n icmāxtuni'uj huan ka'hua'chu huan tlajana'? ");
INSERT INTO tooNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Lā' Jesús cākalhtīlh: ―Como hui'xina'n tū' lej kalhlaka'ī'yā'tit. Stu'ncua' a'ntū iccāhuaniyāni'. Palh kalhlaka'ī'yā'tit con ixlīhuāk mi'a'clhcunucca'n a'yuj tzucupā'na'ntitcus kalhlaka'ī'yā'tit, tzē ixua'ni'tit huā'mā' kēstīn: “Catapānu' de huā'tzā' lā' capit ā'lacatin”, lā' huan kēstīn natapānū. Tū' a'nan nīn tuntū' a'ntūn tūla catitlahua'tit palh stu'ncua' kalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Huan tlajana' hua'chi huā'mā' tūla māxtucan. Xmān tzē māxtucan palh natlahua'yā'tit oración lā' palh nalīhui'līyā'tit namakxtekā'tit de nahuā'yanā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Līhuan ixtalatlā'huantēlha nac estado de Galilea, Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Naquimacamāstā'can quit, huan Chi'xcu' xala' Tālhmā'n, lā' naquimacamaxquī'can ixlīmāpa'ksīnca'n chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Lā' xlaca'n naquintamaknī pero ixlīlakatu'tun chi'chini' na'iclakahuanchoko ―cāhuanilh. Lā' huā'mā' tachihuīn lej cāmālakaputzīlh xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lā' a'xni'ca' Jesús lā' ī'sca'txtunu'nī'n tachā'lh huan nac cālacchicni' Capernaum, talakmilh Pedro huan a'ntī ixtamātā'jīni'n ixpālacata lītokpān. Lā' takalhasqui'nīlh: ―¿Chā tū' māpala ixcuota lītokpān mimākalhtō'kē'ni'? ");
INSERT INTO tooNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Lā' Pedro cākalhtīlh: ―U'huē, māpala. Lā' tuncan a'xni'ca' Pedro tanūlh huan nac chic, Jesús pū'la chihuīna'lh lā' huanilh: ―¿Chī puhua'na', Simón? Huan reyes xalanī'n huā'mā' quilhtamacuj, ¿tichū cāmātā'jī huan impuesto lā' huan cuota? ¿Chā cāmātā'jī huan a'ntīn tatapa'ksī con xlaca'n o cāmātā'jī huan makatiyāti'? ");
INSERT INTO tooNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Lā' Pedro kalhtīlh: ―Mātā'jīcan huan makatiyāti'. Lā' Jesús huanilh: ―Lā' tū' tamāpala xlaca'n a'ntīn tatapa'ksī con huan rey. Lā' quinTāta' nac a'kapūn hua'chi huan rey. Lā' quina'n tapa'ksīyāuj con xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Lā' como tū' cāmakā'kchā'ncu'tunāuj a'ntīn tamātā'jīni'n, capit huan nac lago lā' camojo' milīmā'kslokotuī'n. Lā' huan squī'ti' a'ntū pū'la namācutuya', namākalhpitziya' lā' nakaksa' lakatin tumīn. U'tza' na'a'cchā'n para huan cuota. Calī'pi lā' nalīmāpala'ya' para quintu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lā' tuncan huan sca'txtunu'nī'n talaktapajtzūlh Jesús lā' takalhasqui'nīlh: ―¿Tichū līhua'ca' tasqui'nī a'nlhā Dios māpa'ksīkō' ixlīhuāk? ");
INSERT INTO tooNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Lā' tuncan Jesús māta'sīlh kalhatin ti'na'j ka'hua'chu lā' yāhualh na ixlaclhpu'nanca'n ");
INSERT INTO tooNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","lā' hualh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Palh hui'xina'n tū' taxtāpalī'yā'tit lā' nala'yā'tit hua'chi kalhatin ti'na'j ka'hua'chu, tū' catitanū'tit a'nlhā Dios māpa'ksīkō' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Lā' chuntza' chuxatī a'ntī līhua'ca' tasqui'nī a'nlhā Dios māpa'ksīkō' ixlīhuāk, ū'tza' huā'mā' a'ntīn tū' ka'tla'jca'tzī lā' nakalhlaka'ī' hua'chi camana' takalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Lā' chuxatī a'ntīn tapa'ksī con quit lā' ū'tza' nalīpāxquī' kalhatin ti'na'j ka'hua'chu hua'chi huā'yā, ū'tza' chu a'cxtim hua'chilh ixquimpāxquī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Lā' Jesús cāhuanipā: ―Palh catīhuā chihuīna'maxquī' kalhatin ti'na'j ka'hua'chu a'ntī quinkalhlaka'ī' lā' ū'tza' huan ka'hua'chu nalītlahua talaclē'i', huā'mā' chi'xcu' tū' tzey. Xalītzey palh pū'la ixpixchī'hua'ca'ca lakatin ka'tla' chihuix lā' ixmojōca nac mar a'nlhā lej pūlhmā'n para que najicsua'. Chuntza' tūlalh ixa'kxokolh huan ka'hua'chu. ");
INSERT INTO tooNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Xānti tala tachi'xcuhuī't xalanī'n huā'mā' quilhtamacuj ixpālacata huan tū' tzey a'ntū cālīlaktzī'n! Pō'ktu a'nan a'ntū nacāmātonkopū tachi'xcuhuī't. Pero ¡xānti tala xlaca'n a'ntīn tamātonkopū ā'makapitzīn lā' tamātlahuī talaclē'i'! ");
INSERT INTO tooNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Lā' chuntza' palh ixtlahua' talaclē'i' ixpālacata mimacan o ixpālacata mintojon, mejor ixmacacā'taya'ca' o ixtantucā'taya'ca' lā' tū' ixtlahua' talaclē'i' ixpālacataca'n mimacan o mintojon. Līhua'ca' tzey palh naka'lhī'ya' minquilhtamacuj para pō'ktu a'yuj macamōcho hui'x; lā' tū' tzey palh namacapinca'na' nac macscut para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Lā' palh milakastapun nalaktzī'n catūhuā lā' chuntza' natlahuacu'tuna' a'ntūn tū' tzey, tū' catitlahua' a'ntū lacasqui'n milakastapun. Mejor ixmā'xtu lā' ixmaka' lā' tū' ixtlahua' talaclē'i' ixpālacata milakastapun. Līhua'ca' tzey palh naka'lhī'ya' minquilhtamacuj para pō'ktu a'yuj lakaxō'ko' hui'x; lā' tū' tzey palh namacapinca'na' nac macscut para pō'ktu con lakatu' milakastapun ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Lā' Jesús cāhuanipā: ―Tū' catilakmaka' nīn kalhatin ti'na'j ka'hua'chu. Iccāhuaniyāni' que nac a'kapūn ixángelesca'n huan camana' pō'ktu tatāya na ixlacapūn quinTāta' xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Lā' quit huan Chi'xcu' xala' Tālhmā'n lā' icmilh iccāmāpūtaxtū huan a'ntīn tū' ixtaka'lhī ixquilhtamacujca'n para pō'ktu. Xlaca'n hua'chi borregos a'ntū xatza'nkān ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Chichū puhua'nā'tit? Palh kalhatin chi'xcu' cāka'lhī cien borregos lā' palh lakatin natza'nkā, ¿tuchū natlahua? Nacāmakxteka huan ā'makapitzīn noventa y nueve a'nlhā tahuā'yamā'na nac cā'seketni'. Lā' na'a'n naputza huan borrego a'ntūn tza'nkālh. ");
INSERT INTO tooNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Lā' a'xni'ca' nakaksa, stu'ncua' līhua'ca' nalīpāxuhua ixpālacata huā'mā' borrego a'ntū kaksli que ā'makapitzīn huan noventa y nueve a'ntūn tū' tatza'nkālh. ");
INSERT INTO tooNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lā' minTāta'ca'n xala' nac a'kapūn nā chuntza' tū' lacasqui'n natza'nkā nīn kalhatin ti'na'j ka'hua'chu. Lacasqui'n nataka'lhī ixquilhtamacuj para pō'ktu ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Lā' Jesús cāhuanipā: ―Palh mintā'tin tlahuani'yāni' a'ntūn tū' tzey, catā'chihuīna' ixa'cstu lā' namāca'tzīnī'ya'. Palh xla' cuenta tlahua, chuntza' hui'x maktāyanī'ta' para que tū' natlahuapala a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero palh mintā'tin tū' cuenta tlahua a'xni'ca' tā'chihuīna'na', cacāmāta'si' ā'kalhatin ā'kalhatu' a'ntī nacātā'lakpina' lā' natakaxmata tuchū ixpālacata lītā'chihuīna'na' mintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Lā' palh tūna'j cuenta tlahua, nacāhuani'ya' xlaca'n a'ntīn takalhlaka'ī' a'xni'ca' tatakēstoka. Lā' palh nīn chuntza' tū' cuenta natlahua, maclacasqui'n nalaktzī'na' hua'chi kalhatin a'ntīn tū' kalhlaka'ī' Dios o hua'chi kalhatin a'kxokonu' mātā'jīni' de impuestos. ");
INSERT INTO tooNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Stu'ncua' a'ntū iccāhuaniyāni'. A'ntū hui'xina'n tū' namakxtekā'tit natlahuacan huā'tzā' nac cā'quilhtamacuj, nā chuntza' nahuancan nac a'kapūn. Lā' a'ntū hui'xina'n namakxtekā'tit natlahuacan huā'tzā' nac cā'quilhtamacuj, nā chuntza' nahuancan nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Nā iccāhuanipalayāni' que palh kalhatu' de hui'xina'n huā'tzā' nac ti'ya't lā' chu a'cxtim puhua'nā'tit a'ntū nasqui'ni'yā'tit Dios a'xni'ca' nakalhtō'ka'yā'tit, quinTāta'ca'n Dios xala' nac a'kapūn nacāmaxquī'yāni' a'ntū squi'ni'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Lā' chuntza' a'nlhā natatakēstoka kalhatu' o kalhatu'tun por quimpālacata, a'ntza' quit na'ictahui'la na ixlaclhpu'nanca'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Lā' tuncan Pedro laktapajtzūlh Jesús lā' kalhasqui'nīlh: ―Māpa'ksīni', ¿lhā maklā't na'icmāsputūnu'ni' quintā'tin a'xni'ca' naquintlahuani' a'ntūn tū' tzey? ¿Chā maktojon na'icmāsputūnu'ni'? ");
INSERT INTO tooNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Lā' Jesús kalhtīlh: ―Quit tū' icuaniyāni' xmān maktojon; quit icuaniyāni' maklhūhua' namāsputūnu'ni'ya', hasta maktu'tumpu'xamacāuj por maktojon. ");
INSERT INTO tooNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lā' Jesús cāhuanipā: ―Lā' chuntza' a'nchī Dios nalīmāpa'ksīni'n tzē natā'mālacastuccan hua'chi kalhatin rey a'ntī cāmāpalacu'tulh ixtasācua'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ixtzucumā'cus a'xni'ca' līmini'ca kalhatin a'ntī ixlaclē'ni' lej lhūhua' tumīn. ");
INSERT INTO tooNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Lā' como huan tasācua' tū' ixka'lhī a'ntū nalīmāpala, huan rey māpa'ksīlh cacāstā'maxquī'ca ā'kalhatin ixtēcu' huan tasācua' lā' ixpuscāt lā' ixcamana' lā' ixlīhuāk a'ntū ixka'lhī. Lā' chuntza' ixa'nan a'ntū nalīmāpala a'ntū ixlaclē'n. ");
INSERT INTO tooNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Lā' tuncan huan tasācua' tatzokostani'lh ixpatrón lā' squi'ni'lh: “Caquilakalhu'ma', quimpatrón, lā' na'icmāpalana'ni'kō'yāni'”. ");
INSERT INTO tooNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Lā' huan ixpatrón lakalhu'malh lā' māsputūnu'ni'lh ixtalaclē'i' lā' makxtekli ca'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Lā' xmān taxtulh huan tasācua' lā' pāxtokli ixtā'tasācua' a'ntī ixlaclē'ni' xmān macsti'na'j tumīn. Lā' tzuculh pixpi'ta' lā' huanilh: “¡Caquimā'pala'ni' a'ntū quilaclī'pini'ya'!” ");
INSERT INTO tooNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lā' tuncan huan a'ntī ixtā'tasācua' tatzokostani'lh lā' squi'ni'lh: “Caquilakalhu'ma' lā' na'icmāpalana'ni'yāni'”. ");
INSERT INTO tooNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Lā' huan ā'kalhatin tū' lacasqui'lh lā' mālacapū'lh lā' māmānūnīni'lh nac pūlāchī'n hasta namāpalakō' huan talaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lā' ā'makapitzīn tasācua'nī'n lej tamāmakchuyīlh a'xni'ca' talaktzī'lh a'nchīn tlahualh ixtā'tasācua'. Lā' ta'a'lh tamāca'tzīnīkō' ixpatronca'n a'nchī pātle'kelh. ");
INSERT INTO tooNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Lā' tuncan huan patrón māta'satīnīni'lh ixtasācua' lā' huanilh: “¡Hui'x ca'tzanca'tzīni'yā tasācua'! Quit icmāsputūnu'ni'kō'ni' ixlīhuāk huanmā' mintalaclē'i' como quisqui'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nā hui'x ixlakalhu'ma' mintā'tasācua' chu a'nchī quit iclakalhu'mani'”. ");
INSERT INTO tooNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Lā' tanto a'kchā'lh huan ixpatrón que māpa'ksīni'lh que namāpātīnīcan nac pūlāchī'n hasta a'xni'ca' namāpalakō' ixlīhuāk a'ntū ixlaclē'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Lā' Jesús a'xmān hualh: ―Nā chuntza' quinTāta' xala' nac a'kapūn nacātlahuani'yāni' palh hui'xina'n tū' cāmāsputūnu'ni'yā'tit mintā'tinca'n con tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lā' a'xni'ca' Jesús chihuīna'nkō'lh, taxtulh de nac Galilea lā' a'lh huan nac ti'ya't a'nlhā huanican Judea. U'tza' a'ntū hui'lacha' tintacut huan pūxka Jordán, a'ntza' na ixquilhtūn a'nlhā tā'cxtuyacha' huan chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Līlhūhua' tastālani'lh lā' xla' cāmātzeyīlh ixlīhuākca'n a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lā' tuncan makapitzīn fariseosnu' talaktapajtzūlh Jesús. Ixtalīlaktzī'ncu'tun lā' ū'tza' talīkalhasqui'nīlh: ―¿Chā tzē makxtekcan quimpuscātca'n lā' xapacan ixtacuīni' ixpālacata chuxatūya catūhuā? ");
INSERT INTO tooNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Lā' Jesús cākalhtīlh: ―¿Chā tū' lakapūtle'kenī'ta'ntit na ixtachihuīn Dios? Chuntza' huan: “Dios cātlahualh chi'xcu' lā' puscāt”. Lā' chuntza' tlahualh a'xni'ca' tzuculh huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nā huan: “U'tza' nacālīmakxteka ixtāta' lā' ixtzī't kalhatin chi'xcu'. Lā' natā'takēxtimī ixpuscāt lā' ixtu'ca'n natala hua'chilh xmān kalhatin”. ");
INSERT INTO tooNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chuntza' tū'tza' kalhatu' xlaca'n; xmān kalhatin. Lā' chuntza' tū' līmakuan palh chi'xcuhuī'n cālāmāmakxtekē a'ntī Dios cātlahualh chu lakatin. ");
INSERT INTO tooNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Lā' tuncan takalhasqui'nīlh: ―Lā' ¿a'chī' māpa'ksīlh Moisés que catzo'kca ca'psnat lā' chuntza' tzē namakxtekāuj quimpuscātca'n? ");
INSERT INTO tooNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Lā' Jesús cāhuanilh: ―Chuntza' tlahualh Moisés ixpālacata mintapāstacna'ca'n a'ntūn tū' tzey. Tū' chuntza' ixuanī't a'xni'ca' tzuculh huan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Lā' quit iccāhuaniyāni' que chu a'ntī namakxteka ixpuscāt lā' palh xla' tū' ka'lhī ixtatā'chihuīn, lā' palh natā'tapūchahua ā'kalhatin puscāt, huā'mā' chi'xcu' makpuscātīni'n. Lā' huan a'ntī natā'tapuchahua kalhatin puscāt a'ntī makxtekcanī't, nā xla' makpuscātīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lā' tuncan ī'sca'txtunu'nī'n tahuanilh: ―Palh chuntza' naquincāpātle'keni'yāni' ixpālacata quimpuscātca'n, tū' quincāminī'ni'ya'ni' natapūchahuayāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Lā' Jesús cākalhtīlh: ―Ixlīhuākca'n tūla catitamāchekxīlh huā'mā'. Xmān tamāchekxī xlaca'n a'ntī Dios nacāmāsu'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Huan a'ntīn tū' tapūchahua ca'tzī a'chī' tū' catitapūchahualh. A'nan a'ntī ixlaktaca'n tū' catitatapūchahualh; ā'makapitzīn tū' catitatapūchahualh ixpālacata a'ntū cātlahuani'ca ixmacni'ca'n, lā' ā'makapitzīn tū' catitatapūchahualh como tatā'scujcu'tun Dios. A'ntīn tzē namāchekxī huā'mā', camāchekxīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Lā' tuncan cālīmini'ca Jesús makapitzīn camana' para nacā'a'cpūxa'ma lā' natlahua oración. Lā' huan sca'txtunu'nī'n tatzuculh talacaquilhnī a'ntī ixtalīmin. ");
INSERT INTO tooNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús hualh: ―Cacāmakxtektit caquintalakmilh huan camana' lā' tū' cacāmāmakchuyī'tit como huan a'ntī natatapa'ksī con Dios a'nlhā māpa'ksīni'n, xlaca'n a'ntī naquintalīpāhuan hua'chi huan tamā'na camana'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lā' Jesús cā'a'cpūxa'malh huan camana' lā' ā'calīstān a'lh ā'lacatin. ");
INSERT INTO tooNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Lā' kalhatin o'kxa' laka'lh Jesús lā' kalhasqui'nīlh: ―Hui'x tzeyā Mākalhtō'kē'ni'. Lā' ¿tuchū maclacasqui'n na'ictlahua a'ntū lej tzey para na'icka'lhī quinquilhtamacuj para pō'ktu? ");
INSERT INTO tooNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Lā' Jesús huanilh: ―¿A'chī' quihuani'ya' palh tzey quit? Xmān kalhatin a'ntī xatzey lā' ū'tza' māni' Dios. Lā' palh ka'lhīcu'tuna' minquilhtamacuj para pō'ktu, nacā'a'kahuāna'ni'ya' ixlīmāpa'ksīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lā' huan o'kxa' kalhasqui'nīlh: ―¿Tuchūyā līmāpa'ksīn? Lā' Jesús kalhtīlh: ―Tū' timaknī'ni'na'; tū' timakpuscātīni'na'; tū' tika'lhāna'na'; tū' tilīchihuīna'na' ā'kalhatin a'ntūn tū' stu'ncua; ");
INSERT INTO tooNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cacā'a'kahuā'na'ni' mintāta' lā' mintzī't; lā' cacāpāxqui' ā'makapitzīn chu a'nchī pāxquī'ca'na' mē'cstu. ");
INSERT INTO tooNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Lā' huan o'kxa' kalhtīni'lh: ―Huāk huā' tamā'na ictlōkentaxtūkō'nī'ttza' desde quilīti'na'j. ¿Tuchū quisputni'cus? ");
INSERT INTO tooNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Lā' Jesús huanilh: ―Palh la'cu'tuna' lej tzey, capit lā' nastā'kō'ya' ixlīhuāk a'ntū ka'lhī'ya' lā' nacāmāpitzini'ya' huan pobresni' lā' chuntza' naka'lhī'ya' a'nchī rico nalīla'ya' nac a'kapūn. Lā' cata't lā' caquistāla'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lā' a'xni'ca' huan o'kxa' kaxmatli huā'mā' tachihuīn, līlakaputzalh lā' a'lh como lej rico ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Lā' tuncan Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Stu'ncua' a'ntū iccāhuaniyāni'. Lej jicslīhua' natatā'tapa'ksī con Dios xlaca'n a'ntī lej lacricosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iccāhuanipalayāni' que lej jicslīhua' natanū lakatin camello na ixtani' līxtokon. Más jicslīhua' natanū kalhatin rico a'nlhā māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","A'xni'ca' takaxmatli huā'mā' tachihuīn, huan ī'sca'txtunu'nī'n lej talē'cnīlh lā' talākalhasqui'nīlh ixlaclhpu'nanca'n: ―Lā' ¿tichū tzē namāpūtaxtūcan? ");
INSERT INTO tooNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Lā' Jesús cālakalaktzī'lh lā' cākalhtīlh: ―Huan chi'xcuhuī'n tūlalh catitatlahualh nīn tuntū' para natapūtaxtu; xmān Dios tzē nacāmāpūtaxtū. ");
INSERT INTO tooNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lā' tuncan Pedro huanilh: ―Māpa'ksīni', quina'n ica'kxtekui'līkō'uj ixlīhuāk a'ntū xa'icka'lhīyāuj lā' iccāstālani'mā'ni'. Lā' ¿tuchū na'icka'lhīyāuj? ");
INSERT INTO tooNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Lā' Jesús cākalhtīlh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Namin lakatin chi'chini' a'xni'ca' nala xasāsti' quilhtamacuj lā' a'xni'ca' quit a'ntī huan Chi'xcu' xala' Tālhmā'n na'ictahui'la a'nlhā māpa'ksīni'ncan. Lā' quit na'icmāpa'ksīni'n. Lā' hui'xina'n a'ntī quilāstālani'nī'taujtza' nā naquilātā'māpa'ksīni'nāuj. Kalhatunu' natahui'layā'tit a'nlhā namāpa'ksīni'nā'tit. Lā' nahua'nā'tit palh tzey o tū' tzey huan xalanī'n huan kalhacāujtu' tribu a'ntī israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Lā' ixlīhuākca'n a'ntīn ta'a'kxtekui'līlh ixchicca'n o ixtā'timīnca'n o ixtāta'ca'n o ixtzī'tca'n o ixpuscātca'n o ixcamana'ca'n o ixti'ya'tca'n, lā' palh ta'a'kxtekui'līlh por quimpālacata, ā'chulā' nataka'lhī. Chuxatū a'ntū ta'a'kxtekui'līlh por quimpālacata, ā'chulā' nataka'lhī. Hua'chi cien veces līhua'ca' nataka'lhī lā' nataka'lhī xasāsti' ixquilhtamacujca'n a'ntū natāyani' para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lā' lhūhua' a'nan a'ntī lej tatasqui'nī huā'tzā'; pero a'nlhā Dios māpa'ksīni'n, tū' lej natatasqui'nī. Lā' lhūhua' a'nan a'ntīn tū' tatasqui'nī huā'tzā'; pero a'nlhā Dios māpa'ksīni'n, lej natatasqui'nī ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Lā' Jesús cāhuanipā: ―Lā' a'nchī Dios līmāpa'ksīni'n tzē natā'mālacastuccan hua'chi kalhatin ixtēcu' pū'uva. Cā'cuhuīni' taxtulh cāputza tasācua' a'ntī natapu'xa uvas. ");
INSERT INTO tooNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cāhuanilh palh natatlaja ixchi'chini'ca'n lā' cāmacā'lh natascuja na ixpū'uva. ");
INSERT INTO tooNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Lā' ā'calīstān taxtupā hua'chi makna'jās cuhuīni'. Lā' cālaktzī'lh ā'makapitzīn nac lītamāuj a'ntīn tū' ixtakaksnī't ixlīmakscujatca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Lā' cāhuanilh: “Nā capintit nascujā'tit na quimpū'uva lā' na'iccāmāpalayāni' a'nchī natlaja'yā'tit”. Lā' xlaca'n ta'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Lā' huampala taxtulh hua'chi tastu'nūta lā' nā huampala hua'chi maktu'tun kōtanū lā' cāmacā'lh huan tasācua'nī'n nac huan pū'uva para natascuja. ");
INSERT INTO tooNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lā' hua'chi makquitzis kōtanū a'mpā nac lītamāuj lā' cāpāxtokli ā'makapitzīn a'ntīn tū' ixtascujmā'na. Lā' cāhuanilh: “Lā' ¿a'chī' xmān tāya'yā'tit tintacuj lā' tū' scujpā'na'ntit?” ");
INSERT INTO tooNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Lā' takalhtīni'lh: “Tū' icka'lhīyāuj quimpatronca'n”. Lā' tuncan cāhuanilh: “Capintit nā hui'xina'n lā' nascujā'tit na quimpū'uva lā' quit na'iccāmāpalayāni' a'nchī tlajacan”. ");
INSERT INTO tooNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Lā' a'xni'ca' tā'cnūlh huan chi'chini', huan patrón huanilh xapuxcu' tasācua'nī'n: “Cacāmāta'satīnīni' huan tasācua'nī'n lā' cacāmāpala'. Pū'la nacāmāpala'ya' huan a'ntī chū'cus tatanūlh lā' ā'calīstān nacāmāpala'ya' huan a'ntī xapū'latza' tascujmā'na”. ");
INSERT INTO tooNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Lā' tuncan tatakextimīlh xlaca'n a'ntīn tatzuculh tascuja hua'chi makquitzis lā' tatlajalh ixchi'chini'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lā' ā'calīstān a'xni'ca' tatakextimīlh xlaca'n a'ntīn tatzuculh tascuja tzi'sāt, tapuhualh palh līhua'ca' ixtatlajca'n. Lā' xmān tatlajalh ixchi'chini'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Lā' a'xni'ca' tamaklhtīni'lh ixtumīnca'n, tatzuculh ta'a'ksa'n huan patrón ");
INSERT INTO tooNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","lā' tahualh: “Huan tamā'na kōtanūtza' tamilh; xmān tascujli lakatin hora. Lā' chu a'cxtim cāmāpalacanī't hua'chi quina'n. Lā' quina'n icscujui tintacuj nac chi'chini'”. ");
INSERT INTO tooNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Lā' huan patrón kalhtīlh kalhatin de xlaca'n lā' huanilh: “Qui'amigo, quit tū' ictlahuani'ni' nīn tuntū' a'ntūn tū' līmakuan. ¿Chu tū' icuanini' palh natlaja'ya' minchi'chini'? ");
INSERT INTO tooNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Calī'pi mintumīn lā' capit. Quit icmāpalacu'tun huanyā chi'xcu' a'ntī chū'cus tanūlh chu a'cxtim hua'chi icmāpalayāni' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Chā tū' quila' huan tumīn? Lā' tzē na'icmāpala chu a'nchī quintapāxuhuān. ¿Chā hui'x a'kchipina' ixpālacata quit tū' tampi'lh?” ");
INSERT INTO tooNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Chuntza' huan a'ntī ā'xmān ixtahuanī't, natala xapū'la. Lā' huan a'ntī xapū'la ixtahuanī't, xlaca'n natala xamakstancu ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lā' a'xni'ca' Jesús ixtā'cxtunu'mā' nac Jerusalén, cālē'lh ī'sca'txtunu'nī'n lacachuna'j lā' ixa'cstuca'n cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Ca'tzīyā'tit que a'mā'nauj para nac Jerusalén. Lā' a'ntza' quit a'ntī huan Chi'xcu' xala' Tālhmā'n naquintamacamāstā' con huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley. Lā' xlaca'n natahuan que caquimaknīca. ");
INSERT INTO tooNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Lā' nā xlaca'n naquintamacamaxquī' huan makatiyātī'n. Lā' naquintalakapala, lā' naquintakēsnoka lā' naquintaxtokohua'ca'. Lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko de na ixlaclhpu'nanca'n huan nīnī'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lā' tuncan laktapajtzūlh Jesús ixtzī'tca'n Jacobo lā' Juan, ixo'kxa'n Zebedeo. Lā' huan puscāt cālīmilh ixo'kxa'n na ixlacapūn Jesús lā' tatzokostani'lh lā' squi'ni'lh lakatin talakalhu'mān. ");
INSERT INTO tooNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Lā' Jesús kalhasqui'nīlh: ―¿Tuchū lacasqui'na'? Lā' huan puscāt huanilh: ―Camāpa'ksi' que huā' tamā'na kalhatu' quincamana' natapāxtūtahui'layāni' a'nlhā namāpa'ksī'ni'na', kalhatin na mimpāxtūcāna'j lā' ā'kalhatin na mimpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Lā' Jesús cākalhtīlh: ―Hui'xina'n tū' māchekxī'yā'tit a'ntū quilāsqui'ni'mā'nauj. ¿Chā tzē natāyani'yā'tit palh napātīni'nā'tit hua'chi quit na'icpātīni'n? U'tza' hua'chilh pōko'tnū'nā'tit quintaza. Lā' xlaca'n tahualh: ―Tzē na'ictāyani'yāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Lā' Jesús cāhuanilh: ―Stu'ncua' que napātīni'nā'tit hua'chi quit. Pero ū'tza' huā'mā' naquilāpāxtūtahui'layāuj, quit tūla icmāpa'ksī. Xmān quinTāta' ca'tzī tichū naquimpāxtūtahui'la. Huā'mā' pūtahuī'lh cāxui'līni'lh xmān para huan a'ntī Dios lacsacli. ");
INSERT INTO tooNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lā' a'xni'ca' huan kalhacāuj sca'txtunu'nī'n taca'tzīlh a'ntū kalhasqui'nīca Jesús, xlaca'n ta'lī'a'kchā'ni'lh huan kalhatu' tā'timīn ixpālacata huan pūtahuī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lā' Jesús cāmāta'satīnīni'lh ixlīhuākca'n lā' cāhuanilh: ―Hui'xina'n ca'tzīyā'tit a'nchīn tahuanī't huan a'ntīn tamāpa'ksīnī'n nac cā'ti'ya'tna'. Xlaca'n hua'chi ixtēcu'ca'n a'ntīn tatapa'ksī con xlaca'n. Lā' lej palha' tamāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tū' chuntza' catilalh na milaclhpu'nanca'n. Chuxatī a'ntī lacu'tun xapuxcu' na milaclhpu'nanca'n, maclacasqui'n que xla' nala hua'chi ixmaktāyana' ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Lā' chuxatī a'ntī naputza a'nchī līhua'ca' natasqui'nī na milaclhpu'nanca'n, maclacasqui'n que xla' nala hua'chi ixtasācua'ca'n ā'makapitzīn de hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Lā' chuntza' nacāmaktāya ā'makapitzīn chuntza' hua'chi quit huan Chi'xcu' xala' Tālhmā'n. Quit tū' icmilh para na'icla hua'chi xapatrón; quit icmilh para na'icscuja lā' para na'iccāmaktāya ā'makapitzīn. Lā' na'icmacamāstā' quinquilhtamacuj para na'iccāmāpūtaxtū līlhūhua' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lā' Jesús lā' ī'sca'txtunu'nī'n ixtataxtumā'na de nac Jericó. Lā' lhūhua' tachi'xcuhuī't ixtastālani'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Lā' ixtahui'lāna' pajtzu nac tej kalhatu' lakatzī'nī'n. Lā' a'xni'ca' takaxmatli a'nchī ixpātle'kemā'cha' Jesús, xlaca'n tatzuculh tata'sa lā' tahualh: ―Māpa'ksīni', hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj. ¡Caquilālakalhu'mauj! ");
INSERT INTO tooNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Lā' huan tachi'xcuhuī't talacaquilhnīlh lā' tahuanilh que cataquilhca'cslalh. Lā' xlaca'n ā'chulā' tata'salh lā' tahuampā: ―Māpa'ksīni', hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj. ¡Caquilālakalhu'mauj! ");
INSERT INTO tooNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Lā' tuncan Jesús tāyalh lā' cāmāta'sīlh huan lakatzī'nī'n lā' cākalhasqui'nīlh: ―¿Tuchū lacasqui'nā'tit na'iccātlahuani'yāni'? ");
INSERT INTO tooNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Lā' xlaca'n takalhtīni'lh: ―Māpa'ksīni', iclacahuāna'ncu'tanāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Lā' tuncan Jesús cālakalhu'malh lā' cāxa'mani'lh ixlakastapunca'n. Lā' chu tuncan lacapalh huan lakatzī'nī'n talacahuāna'lh lā' tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lā' a'xni'ca' ixtatapajtzūtēlhamā'natza' nac Jerusalén, tachā'lh huan nac cā'lacchicni' a'nlhā ixuanican Betfagé. A'ntza' pajtzu huan o'kspū'n a'nlhā huanican Olivos. Lā' Jesús cāmāpū'līlh kalhatu' ī'sca'txtunu'nī'n ");
INSERT INTO tooNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","lā' cāhuanilh: ―Capintit huan nac cā'lacchicni' a'ntūn tasu'yu na milacapūnca'n. A'ntza' nalaktzī'nā'tit lakatin burro xatzī't a'ntū chī'yāhuacanī't lā' nā yā ixcaman. Caxcuttit lā' caquilālīmini'uj. ");
INSERT INTO tooNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Lā' palh catīhuā nacākalhasqui'nīyāni': “¿A'chī' xcutpā'na'ntit?”, nahuaniyā'tit: “Huan Māpa'ksīni' cāmaclacasqui'n”. Lā' chuntza' nacāmakxtekāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chuntza' pātle'kelh para natlōkentaxtū ixtachihuīn huan profeta a'nlhān tzo'kcanī't chuntza': ");
INSERT INTO tooNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cacāhua'ni' xalanī'n huan nac xcānsipej a'nlhā huanican Sión: “Calaktzī'ntit. Mimā' miReyca'n. Xla' tū' ka'tla'jca'tzī. Kēhuī' huan burro mimā'. Kēhuī' ixcaman huan animal a'ntū mācu'quī'can”. ");
INSERT INTO tooNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Lā' tuncan huan sca'txtunu'nī'n ta'a'lh lā' tatlahualh a'ntū Jesús cālīmāpa'ksīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Talīmini'lh huan xatzī't burro lā' ixcaman lā' talīkētlapalh ixtakēnu'ca'n lā' Jesús kētahuī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lā' lhūhua' tachi'xcuhuī't ixa'nan. Lā' xlaca'n taxta'nka'lh ixtakēnu'ca'n nac tej. Lā' makapitzīn tacā'lh xalacti'na'j ixpeken qui'hui' lā' taquilhmāpī'lh nac tej. ");
INSERT INTO tooNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Lā' a'ntī ixtapū'lani'tēlha lā' a'ntī ixtastālani'tēlha tatzuculh tata'sa lā' tahualh: ―¡Camācā'tanīca ixtā'nat huan rey David a'ntī ixkalhīmā'nauj! ¡Dios casicua'lanālīlh a'ntī mimā' por ixlīmāpa'ksīn huan Māpa'ksīni'! ¡Camācā'tanīca Dios! ");
INSERT INTO tooNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lā' a'xni'ca' Jesús tanūlh huan nac Jerusalén, ixlīhuākca'n a'ntī ixtahui'lāna'ncha' tatamakchuyīkō'lh lā' takalhasqui'nīni'lh: ―¿Tichū ū'tza' huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Lā' tachi'xcuhuī't cākalhtīlh: ―Huā'mā' huan a'cta'sana' Jesús a'ntī xala' nac Nazaret nac estado de Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Lā' ā'calīstān Jesús a'lh huan nac xaka'tla' lītokpān lā' tanūlh lā' cātlakaxtukō'lh ixlīhuākca'n a'ntī ixtastā'namā'na lā' huan a'ntī ixtatamāhuana'mā'na na ixtanquilhni' lītokpān. Lā' cāmakpūspi'tni'kō'lh ixmesaca'n huan a'ntī ixtaxtāpalīmā'na ixtumīnca'n tachi'xcuhuī't. Lā' nā cāmakpūspi'tni'lh ixpūtahuī'lhca'n huan a'ntī ixtastā'mā'na pālumax. ");
INSERT INTO tooNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Lā' cāhuanilh: ―Tatzo'kni' na ixtachihuīn Dios: “Quinchic namāpācuhuī'can: Chic a'nlhā Tlahuacan Oración”. Lā' a'nchīn tlahuapā'na'ntit, hui'xina'n tlahuanī'ta'ntit hua'chi ixpūtatzē'kni'ca'n ka'lhāna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lā' a'ntza' huan nac lītokpān talaktapajtzūlh Jesús makapitzīn lakatzī'nī'n lā' lū'ntū'lanī'n. Lā' xla' cāmātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Lā' huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley a'xni'ca' talaktzī'lh huan lē'cnīn a'ntū Jesús cātlahualh, xlaca'n ta'a'kchā'lh. Lā' nā ta'a'kchā'lh ixpālacata a'nchī huan camana' na ixchakān lītokpān tata'salh lā' tahualh: “¡Camācā'tanīca ixtā'nat huan rey David a'ntī ixka'lhīmā'nauj”! ");
INSERT INTO tooNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Lā' xlaca'n tahuanilh Jesús: ―¿A'chī' tū' cālacaquilhni'ya' huā' tamā'na camana'? ¿Chā tū' kaxpa'ta' a'ntūn tahuanimā'ni'? Lā' Jesús cākalhtīlh: ―U'huē, ickaxmata. Lā' ¿chu hui'xina'n tū' lakapūtle'kenī'ta'ntit na ixtachihuīn Dios ixpālacata huā'mā'? Chuntza' tatzo'kni': Hui'x cāmāsu'ni'nī'ta' huan lakska'tā'n lā' huan a'ntīn tatzi'quī'cus a'nchī lej xa'nca natamāca'tanīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Lā' tuncan Jesús cā'akxtekui'līlh lā' taxtulh de huan xcānsipej lā' a'lh nac Betania a'nlhā tachokolh huanmā' tzī'sa. ");
INSERT INTO tooNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lā' ixlīlakalī a'xni'ca' ixminchokopā nac Jerusalén, Jesús ixtzi'ncsa. ");
INSERT INTO tooNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lā' laktzī'lh a'katin xaqui'hui' higo na ixquilhtūn tej lā' tapajtzūlh huan nac qui'hui'. Lā' huan qui'hui' tū' ixka'lhī ixtō'ca't; xmān ixka'lhī xachi'tin. Lā' tuncan Jesús huanilh huan xaqui'hui' higo: ―¡Tū'tza' ā'maktin catitō'ca'! Lā' chu līmaktin tīlh huan xaqui'hui' higo. ");
INSERT INTO tooNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lā' a'xni'ca' huan sca'txtunu'nī'n talaktzī'lh huā'mā', lej talē'cnīlh lā' takalhasqui'nīlh Jesús: ―¿A'chī' lej palaj tīlh huan qui'hui'? ");
INSERT INTO tooNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Lā' Jesús cākalhtīlh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Palh xa'nca nakalhlaka'ī'yā'tit lā' palh tū' napuhua'nā'tit que Dios tūla natlahua, nā tzē natlahua'yā'tit chu a'cxtim hua'chi quit ictlahuani'lh huan qui'hui'. Lā' nā tzē nahuaniyā'tit huā'huī' kēstīn: “Catapānu' de ā'tzā' lā' catojo' nac xcān”; lā' nā chuntza' napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Lā' ixlīhuāk a'ntū nasqui'ni'yā'tit a'xni'ca' tā'chihuīna'mpā'na'ntit Dios, ixlīhuāk namaklhtīni'nā'tit, xmān calīpāhua'ntit Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Lā' tuncan Jesús tanūlh huan nac xaka'tla' lītokpān. Lā' līhuan ixmāsu'yumā', talaktapajtzūlh huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' israelitas. Lā' xlaca'n takalhasqui'nīlh: ―¿Tichū ixquilhtampān cālītlahua'pā't huā' tamā'na catūhuā? ¿Tichū maxquī'ni' huā'mā' līmāpa'ksīn? ");
INSERT INTO tooNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Lā' Jesús cākalhtīlh: ―Lā' quit nā na'iccākalhasqui'nīyāni' catūhuā. Lā' palh naquilākalhtīyāuj, nā quit na'iccāhuaniyāni' tichū ixquilhtampān iccālītlahuamā' huā' tamā'na catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tichū ixquilhtampān ixlīmā'kpaxīni'n Juan? ¿Ixquilhtampān Dios o ixquilhtampānca'n tachi'xcuhuī't? Caquilākalhtīuj. Lā' xlaca'n tatzuculh talacchihuīna'n xmān ixa'cstuca'n lā' talāhuanilh: ―¿Chichū nahuaniyāuj? Palh nahuaniyāuj que Dios māpa'ksīlh huan Juan, naquincākalhasqui'nīyāni': “Lā' ¿a'chī' tū' kalhlaka'ī'nī'ta'ntit?” ");
INSERT INTO tooNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Lā' tūla nahuaniyāuj que chi'xcuhuī'n tamāpa'ksīlh, como cājicua'ni'yāuj tachi'xcuhuī't como ixlīhuākca'n takalhlaka'ī' palh Juan stu'ncua' ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lā' ū'tza' talīkalhtīlh Jesús: ―Tū' icca'tzīyāuj tichū ixquilhtampān. Lā' tuncan Jesús cāhuanilh: ―Nīn quit tū' icticāhuanini' tichū ixquilhtampān iccālītlahuamā' huā'mā' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Lā' Jesús cāhuanilh: ―¿Tuchū puhua'nā'tit? Ixuī' kalhatin chi'xcu' lā' ixka'lhī kalhatu' ixo'kxa'n. Lā' huanilh huan xapuxcu': “Jayi', capit scu'ja' na quimpū'uva chuhua'j”. ");
INSERT INTO tooNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Lā' huan ixo'kxa' kalhtīlh: “Tū' ica'ncu'tun”. Lā' ā'calīstān līlakaputzalh ixpālacata a'nchī ixkalhtīnī't ixtāta' lā' a'lh scuja. ");
INSERT INTO tooNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Lā' ā'calīstān huan xatāta' laka'lh xastancu ixo'kxa' lā' chu a'cxtim huanilh. Lā' huā'mā' kalhtīlh: “Tzey, tāta', na'ica'n”. Pero tū' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Lā' ¿chichū puhua'nā'tit hui'xina'n? ¿Tichūyā o'kxa' tlahualh ixtapuhuān ixtāta'? Lā' xlaca'n tahualh: ―Huan a'ntī pū'la chihuīna'lh. Lā' tuncan Jesús cāhuanilh: ―Lā' quit iccāhuaniyāni' huā'mā'. Huan mātā'jīni'nī'n impuestos lā' huan puscan xalanī'n nac cā'tejen, xlaca'n chō'la natatanū a'nlhā Dios māpa'ksīni'n. Lā' hui'xina'n tūlalh catitanū'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chuntza' iccāhuaniyāni' como Juan huan Mā'kpaxīni' milh lā' cāmāsu'ni'ni' a'nchī maclacasqui'n nalatā'kchokoyā'tit lā' tū' kalhlaka'ī'nī'ta'ntit. Lā' huan mātā'jīni'nī'n impuestos lā' huan puscan xalanī'n nac cā'tejen takalhlaka'ī'nī't. Lā' a'yuj laktzī'nī'ta'ntit a'nchīn takalhlaka'ī'lh xlaca'n, pero hui'xina'n tū' xtāpalīnī'ta'ntit mintapāstacna'ca'n lā' tū' kalhlaka'ī'nī'ta'ntit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Lā' Jesús cāhuanilh: ―Cakaxpa'ttit huā' ā'lakatin a'ntū tā'mālacastuccan: Ixuī' kalhatin ixtēcu' huan ka'tla' ti'ya't lā' cācha'nli mayāc a'ntū māstā' uvas na ixti'ya't. Lā' līcorralhui'līlh chihuix ixti'ya't lā' cāxtlahualh ixpūchi'tni' lā' yāhualh lakatin torre a'ntū napūmaktaka'lha ixpū'uva. ’Lā' ā'calīstān cāmāsācua'nīlh huan ti'ya't huan tasācua'nī'n para natascuja i'tātna'. Lā' xla' a'lh tachoko makat. ");
INSERT INTO tooNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lā' a'xni'ca' chilhtza' ixpūlani' uvas, cāmacā'lh ā'makapitzīn tasācua'nī'n na ixpū'uva. Ta'a'lh tasqui'ni' huan tasācua'nī'n cacāmaxquī'ca uvas a'ntū ixla' ixtēcu' huan ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Lā' huan tasācua'nī'n nac pū'uva tachi'palh huan a'ntīn ixta'a'nī't lā' lej tatucsli kalhatin lā' tamaknīlh ā'kalhatin lā' talīta'lalh chihuix ā'kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Lā' huan ixtēcu' ti'ya't cāmacā'mpā ā'makapitzīn tasācua'nī'n lā' más lhūhua' cāmacā'lh que pū'la. Lā' chu a'cxtim cātlahuani'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Lā' ā'xmān macā'lh māni' ixo'kxa'. Lā' puhualh: “Ka'lhī que na'a'cnīni'ni'can qui'o'kxa'”. ");
INSERT INTO tooNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Lā' a'xni'ca' chā'lh nac pū'uva huan o'kxa', huan tasācua'nī'n talāhuanilh ixa'cstuca'n: “U'tza' huan a'ntī nalītachoko ixlīhuāk a'ntū ka'lhī ixtāta'. Camaknīuj lā' chuntza' quilaca'n nala huan pū'uva”. ");
INSERT INTO tooNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Lā' chuntza' tachi'palh lā' tamāxtulh nac huan pū'uva lā' tamaknīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Lā' Jesús cākalhasqui'nīlh: ―A'xni'ca' na'a'nācha' ixtēcu' huan ti'ya't, ¿tuchū nacātlahuani' huan tamā'na a'ntīn tamaksācua'lh? ¿Chī puhua'nā'tit? ");
INSERT INTO tooNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Lā' tahuanilh: ―Stu'ncua' nacāmaknī. Lā' nacāmāsācua'nī huan pū'uva ā'makapitzīn xtunc tasācua'nī'n. Lā' xlaca'n a'xni'ca' natapu'xa huan uva, natamacamaxquī' a'ntū ixla' nala huan ixtēcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Lā' tuncan Jesús cāhuanilh: ―¿Chā tū' maktin lakapūtle'kenī'ta'ntit na ixtachihuīn Dios ixpālacata ixO'kxa'? Xla' hua'chi huan chihuix a'ntū lītzo'kcanī't lā' chuntza' huan: Huan xakana'nī'n talakmaka'lh huan chihuix lā' māni' ū'tza' huanmā' chihuix a'ntū más tasqui'nī. Chuntza' tlahualh huan Māpa'ksīni' lā' quina'n iclīlē'cnīyāuj. ");
INSERT INTO tooNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Lā' chuntza' iccāhuaniyāni' que a'ntū mila' ixuanī't a'nlhā Dios māpa'ksīni'n, nacātamaklhtīyāni' lā' nacāmaxquī'can ā'makapitzīn a'ntī natatlahua ixtapuhuān Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Lā' a'ntīn tū' xa'nca tamāchekxī quintachihuīn, xlaca'n hua'chi a'ntīn tapū'a'kchekxlalh huan chihuix lā' chuntza' tatakāhuī'lh. Lā' a'ntīn tū' takalhlaka'ī' quintachihuīn, xlaca'n hua'chi a'ntī cā'a'klhta'lalh huan ka'tla' chihuix lā' cāka'nkxli lā' tanīlh ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lā' a'xni'ca' huan xanapuxcu'nu' curasna' lā' huan fariseosnu' takaxmatli a'ntū tā'mālacastucli Jesús, tamāchekxīlh que Jesús ixcālīchihuīna'mā' māni' xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lā' chuntza' titachi'pacu'tulh Jesús pero tajicua'ni'lh tachi'xcuhuī't como tachi'xcuhuī't tapuhualh palh Jesús ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Lā' Jesús tzucupā cātā'chihuīna'n a'ntū tā'mālacastuccan lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―A'xni'ca' Dios nacāmāpa'ksīkō' tachi'xcuhuī't, ū'tza' nala hua'chi a'xni'ca' kalhatin rey tlahualh huan cā'tani' a'xni'ca' tapūchahualh ixo'kxa'. ");
INSERT INTO tooNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cāmacā'lh ixtasācua'nī'n lā' ta'a'lh cāmāta'sī huan a'ntī ixcākantāyanī't, pero xlaca'n tū' ixta'a'ncu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Lā' cāmacā'mpā ā'makapitzīn tasācua'nī'n lā' cāhuanilh: “Cacāhua'ni'tit huan a'ntī iccākantāyanī't palh cāxni'jtza' huī' huan tahua'. Iccāmaknīlhtza' lhūhua' huācax lā' huan xako'ntin xaska'ta' huācax lā' iccāxtlahualīkō'lhtza' para natapūchahuacan. Catamilh huan qui'amigos”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Lā' huan a'ntī ixcākantāyanī't tū' cuenta tatlahualh. Kalhatin a'lh na ixā'tacuxtu lā' ā'kalhatin a'lh stā'nan. ");
INSERT INTO tooNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Lā' ā'makapitzīn cāchi'palh ixtasācua'nī'n huan rey. Tatu'csli lā' tamaknīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Lā' tuncan lej a'kchā'lh huan rey lā' cāmacā'lh huan tropa para nacāmaknī huan maknīni'nī'n lā' mālhcuyunīni'lh ixā'lacchicni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Lā' tuncan cāhuanilh ixtasācua'nī'n: “Ixlīhuāk cāxni'jtza' huī' para natapūchahua qui'o'kxa' pero tasu'yu que xlaca'n a'ntī iccākantāyanī't tū' lacuan a'nchī maclacasqui'n para natamin. ");
INSERT INTO tooNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Capintit chuhua'j nac cā'tejen lā' cacākantāya'tit ixlīhuākca'n a'ntī nacāpāxtokā'tit. Catamilh como natapūchahua qui'o'kxa'”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Huan tasācua'nī'n tataxtulh lā' ta'a'lh nac cā'tejen. Lā' ixlīhuakca'n a'ntīn tapāxtokli tatakēstokli lā' huan a'ntī xatzey lā' a'ntīn tū' xatzey. Lā' chuntza' lītatzumaca huan chic. ");
INSERT INTO tooNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Lā' tuncan tanūlh huan rey lā' cālaktzī'lh huan a'ntīn tamilh. Lā' laktzī'lh kalhatin chi'xcu' a'ntīn tū' ixlhakā'na'nī't hua'chi minī'ni' a'nlhā tapūchahuamā'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lā' huanilh: “Qui'amigo, ¿a'chī' tanū'nī'ta' huā'tzā' lā' tū' lhakā'nī'ta' huan lu'xu' a'ntū minī'ni?” Lā' xla' tuntū' huanilh; xmān ca'cs tāyalh. ");
INSERT INTO tooNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Lā' tuncan huan rey cāhuanilh huan a'ntī ixtamaktāyamā'na: “Camacachī'tit lā' catantūchī'tit lā' camāxtutit kēpun a'nlhā cā'pucsua'. A'ntza' nacalhuan lā' nalāxca ixtatzan”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Lā' Jesús huampā: ―Līlhūhua' a'ntī cāmāta'sīca lā' tū' lhūhua' a'ntī cālacsacca. ");
INSERT INTO tooNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lā' tuncan huan fariseosnu' ta'a'lh lā' talacchihuīna'lh a'nchīn tzē ixtalē'ksa'nīni'lh Jesús ixpālacata a'ntū hualh. ");
INSERT INTO tooNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Chuntza' cāmacā'lh makapitzīn ixchi'xcuhuī'n lā' tatā'a'lh ixchi'xcuhuī'n Herodes a'ntī rey ixuanī't. Talaka'lh Jesús lā' tahuanilh: ―Mākalhtō'kē'ni', icca'tzīyāuj palh hui'x hua'na' a'ntū stu'ncua' lā' nā xa'nca māsu'yu'ya' a'nchī Dios lacasqui'n. Hui'x tū' cātlahua'ni'ya' cuenta a'nchī talīchihuīna'nāni' tachi'xcuhuī't. Lā' chu a'cxtim cālaktzī'na' ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Tuchū puhua'na' ixpālacata huan a'ntū māta'jīni'n huan emperador romano? ¿Chā tzey palh na'icmāpalayāuj o tū' tzey? ");
INSERT INTO tooNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Lā' Jesús ixca'tzī que xmān ixtalīlaktzī'ncu'tun lā' cāhuanilh: ―Hui'xina'n tlahua'pā'na'ntit lakatu' milacanca'n. Lā' ¿a'chī' quilālīlaktzī'ncu'tunāuj? ");
INSERT INTO tooNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Caquilāmāsu'ni'uj huan tumīn a'ntū līmāpalacan a'ntū māta'jīni'ncan. Lā' līmini'ca lakatin denario a'ntū ixtumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Lā' a'xni'ca' Jesús laktzī'lh huan tumīn, cākalhasqui'nīlh: ―¿Tichū ixlacan tasu'yu nac huā'mā' tumīn lā' tichū ixtacuīni' tatzo'kni'? ");
INSERT INTO tooNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Lā' takalhtīlh: ―Ixla' huan emperador. Lā' tuncan Jesús cāhuanilh: ―Camacamaxquī'tit huan emperador a'ntū ixla' lā' camacamaxquī'tit Dios a'ntū ixla'. ");
INSERT INTO tooNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lā' a'xni'ca' takaxmatli huā'mā' tachihuīn, talē'cnīlh. Lā' tamakxtekli lā' ta'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lā' māni' huā'mā' chi'chini' makapitzīn saduceosnu' talakmilh Jesús. Lā' huan saduceosnu' ixtahuan que tū' catilakahuanchokoca. Lā' ū'tza' talīhuanilh chuntza': ");
INSERT INTO tooNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mākalhtō'kē'ni', huan Moisés māsu'yulh palh nanī kalhatin chi'xcu' a'ntīn tapūchahuanī'ttza' lā' palh tū' ka'lhī ixcaman, tasqui'nī que ī'stancu natā'tapūchahua huan lakapūt. Lā' huan xapū'la o'kxa' a'ntī nalacatuncuī nala ixo'kxa' huan xapuxcu' a'ntī nīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ixa'nan na quilaclhpu'nanca'n kalhatojon lītā'timīn. Lā' huan xapuxcu' tapūchahualh lā' ā'calīstān nīlh. Lā' como tū' ixka'lhī ixcaman, māchokoni'lh huan lakapūt huan ī'stancu. ");
INSERT INTO tooNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lā' nā xla' nīlh lā' tū' ixka'lhī ixcaman. Lā' chuntza' pātle'keni'lh ā'kalhatin xastancu lā' nā ā'kalhatin hasta ā'xmān xastancu. Lā' nā xla' nīlh lā' tū' ixka'lhī ixcaman. ");
INSERT INTO tooNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Lā' a'xni'ca' ixtanīkō'nī'ttza' huan lītā'timīn, ā'xmān nīlh huan puscāt. ");
INSERT INTO tooNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lā' a'xni'ca' nalakahuanchokocan, ¿tichū ixla' nala huan puscāt? Ixkalhatojonca'n ixtatā'tō'lanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Lā' Jesús cākalhtīlh: ―Hui'xina'n tā'kxokonī'ta'ntit mē'cstuca'n como tū' ca'tzīyā'tit a'ntūn tatzo'kni' na ixtachihuīn Dios lā' nīn tū' māchekxī'yā'tit chī huanī't ixlīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Lā' a'xni'ca' huan nīnī'n natalakahuanchoko, tū' catitapūchahuaca lā' nīn tū' catitamāstā'lh ixtzu'ma'janca'n para natatapūchahua. Xlaca'n natala hua'chi ixángeles Dios xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Chā tū' lakapūtle'kenī'ta'ntit a'ntū māni' Dios cāhuanini' ixpālacata huan a'ntī natalakahuanchoko? Chuntza' hualh: ");
INSERT INTO tooNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Quit ixDiosca'n Abraham lā' Isaac lā' Jacob”, hualh. U'tza' huanicu'tun que xlaca'n lakahuan a'yuj tanīlh makāntza' lā' Dios ū'tza' ixDiosca'n xalakahuan lā' tū' huan xanīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lā' a'xni'ca' huan tachi'xcuhuī't takaxmatli huā'mā' tachihuīn, ixlīhuākca'n talē'cnīlh ixpālacata ixlīmāsca'tīn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lā' huan fariseosnu' tatakēxtimīlh a'xni'ca' takaxmatli a'nchī Jesús cāmāca'cslīlh huan saduceosnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Lā' kalhatin de xlaca'n xamākalhtō'kē'ni' huan ley ixuanī't. Lā' xla' ixca'tzīcu'tun palh Jesús ixca'tzī huan ixley Moisés lā' kalhasqui'nīlh: ");
INSERT INTO tooNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mākalhtō'kē'ni', ¿tuchūyā līmāpa'ksīn más tasqui'nī de a'ntū māsu'yulh Moisés? ");
INSERT INTO tooNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Lā' Jesús huanilh: ―“Capāxqui' huan Māpa'ksīni' a'ntī minDios con ixlīhuāk mi'a'clhcunuc lā' con ixlīhuāk mintapāstacna'”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","U'tza' huā'mā' huan līmāpa'ksīn a'ntū līhua'ca' xaka'tla' lā' a'ntū más tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lā' ā'lakatin casi chu a'cxtim a'nchī lej tasqui'nī lā' huan: “Capāxqui' ā'kalhatin chu a'cxtim mē'cstu pāxquī'ca'na'”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ixtuca'n līmāpa'ksīn hua'chi ixlītzucuni' huan ixley Moisés lā' ixlīmāsca'tīnca'n huan a'cta'sana'nī'n xalanī'n makāntza'. ");
INSERT INTO tooNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lā' huan fariseosnu' tūna'j ixta'a'n. ");
INSERT INTO tooNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Lā' Jesús cākalhasqui'nīlh: ―¿Tuchū līpāstacā'tit Cristo a'ntī ka'lhīpā'na'ntit? ¿Tichū ī'xū'yāpapna'? Lā' tahuanilh: ―Xla' ī'xū'yātā'nat David. ");
INSERT INTO tooNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Lā' tuncan Jesús cāhuanilh: ―Lā' ¿a'chī' David māpācuhuīlh Māpa'ksīni' chu a'nchī māsu'ni'lh huan Espíritu Santo? David hualh: ");
INSERT INTO tooNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Huan Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' quimpāxtūcāna'j hasta a'xni'ca' na'iccātlajakō' ixlīhuākca'n mintā'ca'tza”. ");
INSERT INTO tooNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Lā' palh Cristo xmān ī'xū'yātā'nat David ixuanī't, tū' ixmāpācuhuīlh Māpa'ksīni'. Chuntza' līca'tzīyāuj que Cristo nā ixMāpa'ksīni' ixuanī't ―Jesús cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Lā' nīn tintī' tzē ixkalhtī lā' nīn lakatin tachihuīn. Lā' desde huā'mā' chi'chini' nīn tintī' tzē ixlīhui'lī kalhasqui'nīpala nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Lā' tuncan Jesús cāhuanilh ī'sca'txtunu'nī'n lā' huan tachi'xcuhuī't: ");
INSERT INTO tooNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Huan mākalhtō'kē'ni'nī'n huan ley lā' huan fariseosnu' taka'lhī talacasqui' para natahuan a'ntū huanicu'tun ixley Moisés. ");
INSERT INTO tooNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lā' chuntza' tasqui'nī natlahua'yā'tit a'ntūn tahuan lā' nacā'a'kahuāna'ni'yā'tit. Lā' hui'xina'n, tū' catitlahua'tit a'nchī xlaca'n tatlahua como tahuan catūhuā lā' xtunc tatlahua. ");
INSERT INTO tooNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xlaca'n hua'chi a'ntīn tacāxtlahualh huan tacu'ca'. Lej tzinca huan tacu'ca' lā' tintī' tzē natāyani'. Lā' xlaca'n nīn tū' tacāxtlahuacu'tun para que tzē nacu'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Talacasqui'n que tachi'xcuhuī't natalaktzī'n ixlīhuāk a'ntūn tatlahua. Cātankāmā'ca'canī't lā' cāpekxtūmāca'canī't lakpēka'tla'n cintaj a'nlhā tatzo'knī't macsti'na'j ixtachihuīn Dios. Lā' nā līhua'ca' lhmā'n taka'lhī ixquini' na ixtampān ixlu'xu'ca'n que ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Talacasqui'n cacā'a'cnīni'ni'ca xlaca'n a'nlhā tlahuamā'ca cā'tani'. Lā' na ixlītokpānca'n israelitas, xlaca'n taputza pūtahuī'lhni' a'ntū quilhpū'layāna'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Lā' talacasqui'n que nacātā'chihuīna'ncan lā' nacā'a'cnīni'ni'can nac cā'tejen lā' nacāmāpācuhuīcan mākalhtō'kē'ni'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Lā' hui'xina'n tū' maclacasqui'nā'tit que nacātamāpācuhuīyāni' mākalhtō'kē'ni'nī'n como chu a'cxtim milīhuākca'n lā' lītā'timīn lanī'ta'ntit lā' xmān kalhatin miMākalhtō'kē'ni'ca'n lā' ū'tza' māni' Cristo. ");
INSERT INTO tooNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Lā' huā'tzā' nac cā'ti'ya'tna', tū' catihua'ni'tit mintā'chi'xcu': “Quintāta'”, como xmān kalhatin minTāta'ca'n lā' ū'tza' māni' a'ntī hui'lacha' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Lā' tū' catimakxtektit nacātamāpācuhuīyāni' māpa'ksīni'nī'n, como xmān Cristo ixlī'a'cstu miMāpa'ksīni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Lā' huan a'ntī na'a'kapalhkā a'nchī xla' tasqui'nī na milaclhpu'na'nca'n, maclacasqui'n nala hua'chi tasācua'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chuxatī a'ntī ixa'cstu putza a'nchī lej tasqui'nī, xla' namāmāxanī'can. Lā' huan a'ntīn tū' ka'tla'jca'tzī', ū'tza' na'a'cnīni'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' hui'xina'n xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hua'chilh mālacchōnī'ta'ntit huan mākalhcha a'nlhā lactanūcan a'nlhā Dios cāmāpa'ksīkō' tachi'xcuhuī't. Lā' hui'xina'n tū' tanū'yā'tit nīn tū' cāmakxtekā'tit natatanū ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' hui'xina'n xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n a'kxokomaklhtīyā'tit ixchicca'n huan lakapūtnu' lā' ā'calīstān lej xlīt kalhtō'ka'yā'tit a'nlhā tzē cātalaktzī'nāni' lā' chuntza' lī'a'kxokonu'nā'tit. U'tza' nacātalīcastigarlīyāni' lej palha'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' hui'xina'n xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n tlahua'yā'tit chuxatū para namākalhlaka'ī'nī'yā'tit ā'kalhatin milīmāsca'tīnca'n. Lā' nā pinā'tit tintacut mar lā' nac xtunc ti'ya't. Lā' a'xni'ca' nakalhlaka'ī', hui'xina'n namātlahuī'yā'tit ā'chulā' a'ntūn tū' tzey que hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Nalakaputzayā'tit hui'xina'n a'ntī hua'chi lakatzī'nī'n lā' cāhuanilīpincu'tunā'tit ā'makapitzīn. Hua'nā'tit: “Palh catīhuā natlahua ixpromesa ixpālacata huan xaka'tla' lītokpān, tuntū' catipātle'keni'lh a'yuj tū' tlōkentaxtū. Lā' palh natlahua ixpromesa ixpālacata huan ixoro huan lītokpān, xla' nasātlahua para natlōkentaxtū”. ");
INSERT INTO tooNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lej lacxumpi hui'xina'n lā' tū' māchekxī'yā'tit. Līhua'ca' tasqui'nī huan lītokpān. U'tza' ixpālacata līsicua'lanālanī't huan oro. Chuntza' maclacasqui'n que nasātlōkentaxtū huan promesa a'ntūn tlahualh ixpālacata huan xaka'tla' lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Lā' nā hua'nā'tit: “Palh catīhuā natlahua ixpromesa ixpālacata huan pūmacamāstā'n, tuntū' catipātle'keni'lh a'yuj tū' tlōkentaxtū. Lā' palh natlahua ixpromesa ixpālacata huan lē'ksajuī'n a'ntū huī' nac pūmacamāstā'n, xla' nasātlahua para natlōkentaxtū”. ");
INSERT INTO tooNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Hui'xina'n tū' māchekxī'yā'tit. Līhua'ca' tasqui'nī huan pūmacamāstā'n. U'tza' ixpālacata līsicua'lanālanī't huan lē'ksajuī'n a'ntū huī' a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Chuntza' huan a'ntī natlahua ixpromesa ixpālacata huan pūmacamāstā'n nā natlahua ixpālacata ixlīhuāk huan lē'ksajuī'n a'ntū huī' nac pūmacamāstā'n lā' tasqui'nī que nasātlōkentaxtū. ");
INSERT INTO tooNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kalhatin a'ntī nahuan que stu'ncua' ixpromesa como hualh ixpālacata huan lītokpān, xla' tū' xmān līchihuīna'n huan lītokpān. Nā līchihuīna'n Dios a'ntī huī' nac huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Lā' nā kalhatin a'ntī nahuan huan ixpromesa ixpālacata huan a'kapūn, xla' tū' xmān līchihuīna'n huan a'kapūn. Nā līchihuīna'n ixpūtahuī'lh Dios a'nlhā māpa'ksīni'n lā' nā ixpālacata Dios a'ntīn tahui'la huan nac pūtahuī'lhni'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' hui'xina'n xamākalhtō'ke'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n cuenta tlahua'yā'tit lā' macamaxquī'yā'tit Dios macsti'na'j milīhua'tca'n hua'chi ā'lhmūhuēn lā' anís lā' cominos. Lā' chuntza' tasqui'nī. Lā' tū' cuenta tlahua'yā'tit huan ixlīmāsca'tīn huan ley lā' ū'tza' līhua'ca' tasqui'nī. Lā' huan ley māsu'yu que līlacatejtin nalatā'kchokoyā'tit, lā' tū' na'a'kxokonu'nā'tit. Nā huan ley māsu'yu que nacālakalhu'ma'nā'tit ā'makapitzīn. Lā' tasqui'nī que tachi'xcuhuī't tzē natakalhlaka'ī' a'ntū hua'nā'tit hui'xina'n. Lā' tasqui'nī namāstā'yā'tit huan macsti'na'j līhua't lā' nā maclacasqui'n natlōkentaxtūyā'tit huan līmāsca'tīn a'ntū tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Hui'xina'n hua'chi lakatzī'nī'n a'ntī cālē'ncu'tun ā'makapitzīn. Hua'chilh mācutuyā'tit de na milīhua'tca'n huan ti'na'j kosnu' lā' tū' cuenta tlahua'yā'tit huan ka'tla' xumpepe. ");
INSERT INTO tooNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n hua'chi a'ntī xmān makche'kē' huan vaso lā' pulātu. Tasu'yu palh tzeyā chi'xcuhuī'n hui'xina'n pero ko'hua'jua' mintapāstacna'ca'n. Hui'xina'n tampi'lhlīni'nā'tit lā' ka'lhāna'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hui'xina'n fariseosnu' lakatzī'nī'n, pū'la napūche'kē'yā'tit huan pulātu lā' chuntza' nā namakche'kē'yā'tit ixmacni'. Lā' palh tzey mintapāstacna'ca'n, natasu'yu palh tzeyā chi'xcuhuī'n hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' nā hui'xina'n xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n hua'chi taponkni' a'ntū cālīmanīcanī't kaxtaj. Lej smu'yonko' lā' tzēhuanī't tatasu'yu lā' na ixchakānca'n huāk ixlucutca'n nīnī'n lā' a'ntū ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nā hui'xina'n chu a'cxtim. Na ixlacapūnca'n tachi'xcuhuī't tasu'yu'yā'tit palh tzey hui'xina'n a'yuj ko'hua'jua' mintapāstacna'ca'n. Lā' chuntza' hui'xina'n pō'ktu a'kxokonu'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Nalakaputzayā'tit hui'xina'n fariseosnu' lā' xamākalhtō'kē'ni'nī'n huan ley. ¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Hui'xina'n cācāxtlahua'yā'tit ixa'cchicca'n huan a'cta'sana'nī'n lā' cācāxtlahualī'yā'tit ixtaponkni'ca'n huan nīnī'n a'ntīn tzeyā chi'xcuhuī'n ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Lā' hua'nā'tit: “Palh quina'n xa'ictahui'lauj cahuā a'xni'ca' ixtahui'lāna' quixū'yāpapna'ca'n, quina'n tū' xa'iccāmaktāyauj a'xni'ca' tamaknīlh huan a'cta'sana'nī'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lā' chuntza' māni' hui'xina'n hua'nā'tit palh hui'xina'n ixtā'natna'ca'n huan a'ntīn tamaknīlh huan a'cta'sana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Catlahua'tit huā'mā' a'ntū xlaca'n talītzuculh lā' tūlalh tatlahuakō'lh, como tasu'yu que ū'tza' a'ntū hui'xina'n tlahuacu'tunā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Hui'xina'n hua'chi lūhua' a'ntū lej tzēhuanī't tasu'yu lā' ka'lhī līlaknīn. ¿Chichū nalīpūtaxtuyā'tit de huan pūpātīn? ");
INSERT INTO tooNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Chuntza' iccāmacamini'yāni' huan a'cta'sana'nī'n lā' chi'xcuhuī'n a'ntī lej taca'tzī lā' mākalhtō'kē'ni'nī'n. Makapitzīn nacāmaknī'yā'tit lā' nacāxtokohua'ca'yā'tit. Lā' ā'makapitzīn nacākēsnokā'tit na milītokpānca'n lā' nacāmacaputzayā'tit pūtunu' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lā' nalī'pinā'tit cuenta ixpālacata xlaca'n. Nā hui'xina'n ca'tzīyā'tit que Abel tū' tlahualh talaclē'i' lā' xla' maknīcanī't. Lā' ca'tzīyā'tit a'nchī maknīcanī't huan Zacarías a'ntī ixo'kxa' huan Berequías ixuanī't. Maknīcanī't ixpu'nan huan lītokpān lā' na ixlacapūn huan pūmacamāstā'n. Lā' hui'xina'n nalī'pinā'tit cuenta ixpālacata ixlīhuākca'n xatzey chi'xcuhuī'n a'ntī cāmaknīca desde a'xni'ca' maknīcanī't huan Abel hasta a'xni'ca' maknīcanī't huan Zacarías. Nalī'pinā'tit cuenta como hui'xina'n tlahua'yā'tit hua'chi tatlahualh xlaca'n a'ntīn tamaknīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Stu'ncua' a'ntū iccāhuaniyāni'. Hui'xina'n a'ntī hui'lā'na'ntit chuhua'j nalī'pinā'tit cuenta ixpālacata ixlīhuākca'n xlaca'n a'ntī cāmaknīcanī't ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Lā' Jesús cāhuanipā: ―¡Xānti la'yā'tit hui'xina'n xalanī'n nac Jerusalén! Hui'xina'n cāmaknī'yā'tit huan a'cta'sana'nī'n lā' cāmūta'la'yā'tit huan ixlacscujni'nī'n Dios a'ntī cāmacamini'yāni'. Maklhūhua' xa'iccāmākēstokcu'tunāni' para na'iccāmaktaka'lhāni' hua'chi lakatin caxli cā'a'ktlapa con ixpeken ī'scamanīn. Lā' hui'xina'n tū' lacasqui'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Stu'ncua' nacā'a'kxtekyāhuacan minchicca'n lā' ca'cs natatāyana'n. ");
INSERT INTO tooNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Lā' nā iccāhuaniyāni' que tū' naquilālaktzī'mpalayāuj hasta a'xni'ca' tū' namin huan chi'chini' a'xni'ca' nahua'nā'tit: “Sicua'lanālanī't huan a'ntī min por ixlīmāpa'ksīn huan Māpa'ksīni' Dios” ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lā' Jesús taxtulh de nac huan lītokpān. Lā' ixa'mā' ā'lacatin a'xni'ca' talaktapajtzūlh ī'sca'txtunu'nī'n. Lā' xlaca'n tatzuculh tahuani que cuenta ixtlahualh a'nchī ixyāhuacanī't huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Lā' Jesús cāhuanilh: ―Calaktzī'ntit ixlīhuāk huā'mā' a'ntū ixla' huan lītokpān. Stu'ncua' a'ntū iccāhuaniyāni'. Tū' catitachokolh nīn lakatin chihuix nac taxaka. Ixlīhuākca'n natapa'nckō' lā' huan taxaka nalacla. ");
INSERT INTO tooNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesús lā' ī'sca'txtunu'nī'n ta'a'lh nac o'kspū'n a'nlhā huanican Olivos. Lā' a'xni'ca' Jesús ixui'lacha', talaka'lh ī'sca'txtunu'nī'n lā' tzē'k tahuanilh: ―Quina'n iclacasqui'nāuj naquilāhuaniyāuj lhānīn napātle'ke huā' tamā'na. ¿Chichū na'iclīca'tzīyāuj palh hui'x palaj nata'mpala'ya' lā' nasputa huan quilhtamacuj? ");
INSERT INTO tooNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Lā' Jesús cākalhtīlh: ―Catamaktaka'lhtit para que tintī' nacā'a'kxokoyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Lhūhua' chi'xcuhuī'n natahuan palh taka'lhī quilīmāpa'ksīn. Lā' chā'tunu' natahuan: “Quit huan Cristo a'ntī Dios lacsacui'līlh”, lā' chuntza' līlhūhua' nacā'a'kxokocan. ");
INSERT INTO tooNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nakaxpa'tā'tit a'nchī sā'nan pajtzu a'nlhā tlahuamā'ca guerra lā' nacātamāca'tzīnīyāni' a'nchīn tlahuamā'ca guerra makat. Tū' catijicua'ntit; chuntza' ka'lhī napātle'ke. Lā' tuna'j cati'a'ksputli. ");
INSERT INTO tooNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Lā' kalhatin gobierno natā'kaquī' contra ā'lakatin lā' lakatin país natlahua guerra contra ā'lakatin. Na'a'nan tatzi'ncsta lā' ta'jatat lā' natachiqui ti'ya't. Lā' nā lakachu nala nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lā' ixlīhuāk huā'mā' xmān ixlītzucuni' a'nchī napātīni'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Lā' nacātamacamaxquī'yāni' para nacātamāpātīnīyāni'. Lā' nacātamaknīyāni' lā' ixlīhuākca'n tachi'xcuhuī't chuxalhā nac quilhtamacuj nacātaca'tzalaktzī'nāni' lā' xmān por quimpālacata. ");
INSERT INTO tooNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lā' a'xni'ca' namin huanmā' quilhtamacuj, lhūhua' natataxtutāya na ixtej Dios lā' natalāca'tzalaktzī'n lā' natalāmacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lā' natala lhūhua' a'cta'sana'nī'n a'ntī nata'a'kxokonu'n. Natahuan palh tachihuīna'n ixpālacata Dios lā' nata'a'kxoko lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Lā' huan tūn tū' tzey na'a'kahuan chuxalhā lā' ū'tza' tū'tza' natalālīpāxquī' lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Lā' huan a'ntīn tū' catitataxtutāyalh na ixtej Dios lā' chuntza' natatachoko hasta a'xni'ca' na'a'ksputa, xlaca'n nacāmāpūtaxtūcan. ");
INSERT INTO tooNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Lā' huan xatzey tachihuīn ixpālacata a'nchī nala a'nlhā Dios namāpa'ksīni'n, ū'tza' huā'mā' nalī'a'cta'sana'ncan chuxalhā nac cā'quilhtamacuj para que ixlīhuākca'n xalanī'n nac cā'quilhtamacuj natamāchekxī. Lā' ā'calīstān a'xni'ca' na'a'ksputa. ");
INSERT INTO tooNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Huan a'cta'sana' Daniel tzo'kli ixpālacata catūhuā a'ntū hua'chi jalhmanīni'n lā' tū' tzey līlacan. Lā' nac lugar a'nlhā ixsicua'lanālīcanī't, a'ntza' nalaktzī'nātit huanmā' catūhuā a'nchī tayāna'. Quit a'ntī ictzo'kmā' huā'mā', quit iccāhuaniyāni' hui'xina'n a'ntī lakapūtle'kepā'na'ntit que cuenta catlahua'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","A'xni'ca' nalaktzī'nā'tit huanmā', a'xni'ca' maclacasqui'n que natatzā'la hasta nac o'kspūn xlaca'n a'ntīn tahui'lāna' nac estado de Judea. ");
INSERT INTO tooNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Lā' huā'mā' chi'chini' a'xni'ca' natayuja a'ntīn tahui'lāna' na ixa'kstīn ixchicca'n, tū' catatanūlh huan nac chic para natamaxtu ixmaclacasqui'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lā' huan a'ntīn tascujmā'na nac cā'tacuxtu, tū' catataspi'tli para na ixchicca'n para natataya ixtakēnu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Xānti tala huan puscan huanmā'na chi'chini' palh tacamalanī't o palh tamātzi'quī'nincus. ");
INSERT INTO tooNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Casqui'ni'tit Dios que tū' tasqui'nī natzā'la'yā'tit a'xni'ca' lonknu'n lā' nīn huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Lā' lej napātīni'ncan a'xni'ca' nala huā'mā'. Desde a'xni'ca' tzuculh huan quilhtamacuj, tū' maktin pātīni'ncanī't a'nchī napātīni'ncan huanmā' chi'chini'. Lā' tū' maktin catilalh ixtā'chuntza' ā'calīstān. ");
INSERT INTO tooNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Lā' palh Dios tū' ixmāti'na'jīlh huanmā' tiempo, tū' ixtapūtaxtulh nīn tintī'. Dios namāti'na'jī como lej cālakalhu'man xlaca'n a'ntī cālacsacnī't. ");
INSERT INTO tooNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Lā' a'xni'ca' namin huanmā' līpātīn lā' palh catīhuā ixcāhuanini': “Chā cala'ktzī'ntit. A' huī' huan Cristo a'ntī Dios lacsacui'līlh”, tū' cakalhlaka'ī'tit. Lā' palh catīhuā ixcāhuanini': “Chā cala'ktzī'ntit. A'j huī' xla'”, tū' cakalhlaka'ī'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Natamin lhūhua' a'kxokonu'nī'n lā' makapitzīn natahuan que māni' xlaca'n Cristo. Lā' ā'makapitzīn natahuan que māni' xlaca'n ixa'cta'sana'nī'n Dios. Lā' xlaca'n nā natatlahua lē'cnīn como nata'a'kxokocu'tun māni' huan xlaca'n a'ntīn Dios cālacsacli. Tūlalh catita'a'kxokolh a'ntīn Dios cālacsacli, pero nacā'a'kxokocan ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Iccāhuanini'tza' huā'mā' para que tū' nacāta'a'kxokoyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Chuntza' palh nacātahuaniyāni': “Cala'ktzī'ntit. A'ntza' huī' Cristo nac cā'lhpi'mpi'li' ti'ya't”, tū' capintit. Lā' palh nacātahuaniyāni': “Cala'ktzī'ntit. A'tzā' huī' nac huan cuarto”, tū' cakalhlaka'ī'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","A'xni'ca' quit na'icmimpala, nala hua'chi huan makli'pni' a'ntū māxkakēkō' huan nac a'kapūn desde a'nlhā tā'cxtu hasta a'nlhān tā'cnū huan chi'chini'. Lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Chuxalhā naca'tzīcan a'xni'ca' na'icmin hua'chi huan chū'ni' taca'tzī a'nlhā mā' catūhuā a'ntū nīnī't ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Lā' Jesús cāhuanipā: ―Lā' xmān capātle'kekō'lh huā'mā' līpātīn, huan chi'chini' lā' huan mālhcuyu' tū' catitamāxkakēni'lh. Lā' huan sta'cu nataminācha' de nac a'kapūn lā' māni' huan a'kapūn natachiqui. ");
INSERT INTO tooNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Lā' nalaktzī'ncan nac a'kapūn lakatin señal a'ntū quila' quit huan Chi'xcu' xala' Tālhmā'n. Lā' xalanī'n ixlīhuākca'n huā' cā'lacchicni' huā'tzā' nac cā'quilhtamacuj, xlaca'n natacalhuan. Lā' naquintalaktzī'n quit huan Chi'xcu' xala' Tālhmā'n a'nchī na'ictaxtu de nac a'kapūn lā' na'icpūmin huan poklhnu'. Lej na'icka'lhī līmāpa'ksīn lā' lej tzēhuanī't na'icxkaka. ");
INSERT INTO tooNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Lā' a'xni'ca' lej namacasā'nan huan līskoli', na'iccāmacamin qui'ángeles lā' natamākēstoka huan a'ntīn cālacsaccanī't. Natamin a'ntī cālacsaccanī't xalanī'n chuxalhā nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Camaksca'ttit catūhuā de huan xaqui'hui' higo: A'xni'ca' tza'la'nka' ixpeken lā' tzucumā'na tapu'n xachi'tin, hui'xina'n ca'tzīyā'tit que tapajtzumā'tza' a'xni'ca' lej naxu'nu. ");
INSERT INTO tooNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Lā' chuntza' a'xni'ca' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuaniyāni', naca'tzīyā'tit palh tapajtzūmā'tza' a'xni'ca' nasputa huan quilhtamacuj. Tapajtzūmā'tza' hua'chi a'xni'ca' kalhatin a'ntī ka'lhīmā'ca lā' yātza' na ixlacapūn mākalhcha. ");
INSERT INTO tooNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Stu'ncua' a'ntū iccāhuaniyāni'. Xlaca'n a'ntīn tahui'lāna'cus tū' catitanīkō'lh hasta a'xni'ca' tū' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuanini'. ");
INSERT INTO tooNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nasputa huan a'kapūn lā' nasputa huan ti'ya't pero tū' maktin catisputli quintachihuīn; natlōkentaxtūkō'can. ");
INSERT INTO tooNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Nīn tintī' ca'tzī lhānīn namin huā'mā' chi'chini' lā' huā'mā' hora; nīn huan ángeles xalanī'n nac a'kapūn tū' taca'tzī. Lā' nā ixO'kxa' Dios tū' ca'tzī. Xmān Dios xaTāta' ca'tzī lhānīn mero napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Lā' chu a'nchī pātle'kelh a'xni'ca' ixui' Noé, nā chuntza' napātle'ke a'xni'ca' namin huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","A'xni'ca' tūna'j ixmin huan lakuat de xcān, huan tachi'xcuhuī't ixtahuā'yamā'na lā' ixtako'tnūmā'na. Lā' ixtatapūchahua lā' ixtamāstā' ixtzu'ma'janca'n para natatapūchahua hasta a'xni'ca' Noé tanūlh huan nac barco. Tū' ixtapuhuan palh namin lakuat, ");
INSERT INTO tooNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","lā' tū' cuenta tatlahualh hasta a'xni'ca' milh huan xcān lā' cālē'nkō'lh. Chuntza' nala a'xni'ca' namin huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","A'xni'ca' namin huanmā' chi'chini', palh talamā'na kalhatu' chi'xcuhuī'n nac cā'tacuxtu, nalē'ncan kalhatin lā' namāchokocan kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Lā' palh tatanūma' kalhatu' puscan a'ntīn tasquitimā'na, nalē'ncan kalhatin lā' namāchokocan ā'kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Skalalh cala'tit como tū' ca'tzīyā'tit lhānīn namin miMāpa'ksīni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Lā' caca'tzītit huā'mā': Palh ixtēcu' huan chic ixca'tzīlh cahuā tuyā hora cā'tzī'sa nachā'n huan ka'lhāna', ixka'lhīlh lā' tū' ī'lhtatalh lā' tū' ixmakxtekli natanū naka'lhāna'n na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nā chuntza' hui'xina'n cāxni'j catahui'la'tit como namin huan Chi'xcu' xala' Tālhmā'n a'xni'ca' tū' puhua'nā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Lā' Jesús cāhuanipā: ―¿Chī huanī't huan xatzey tasācua' a'ntī xa'nca māchekxī? Xla' ū'tza' a'ntī huan patrón nalīmāmacū' huan chic para nacāmāhuī' ixtā'tasācua'nī'n a'xni'ca' maclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nalīpāxuhua huan tasācua' palh tlōkentaxtūmā' ixlītlōt a'xni'ca' nataspi'ta ixpatrón. ");
INSERT INTO tooNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Stu'ncua' a'ntū iccāhuaniyāni'. Huan patrón nalīmāmacū' huā'mā' tasācua' ixlīhuāk a'ntū ka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Lā' palh tū' tzey huā'mā' tasācua', xla' napuhuan que natakoxī huan ixpatrón. ");
INSERT INTO tooNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Lā' chuntza' natzucu cālactucsa ā'makapitzīn tasācua'nī'n lā' natā'huā'yan lā' nacātā'ko'ta huan ka'chīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Lā' chu līmaktin nataspi'ta huan patrón. Namin lakatin chi'chini' a'xni'ca' huan tū' tzeyā tasācua' tū' ca'tzī lā' tū' ka'lhīmā'. ");
INSERT INTO tooNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lā' huan patrón lej palha' nacastigarlī huan tasācua' lā' namāpātīnī hua'chi natapātīni'n xlaca'n a'ntī līhua tahuan palh takalhlaka'ī'. Lā' xla' nacalhuan lā' nalāxca ixtatzan ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Lā' Jesús cāhuanipā: ―Lā' a'xni'ca' na'icmimpala a'xni'ca' Dios natzucu namāpa'ksīkō' ixlīhuāk nac huā'mā' cā'ti'ya'tna'. Lā' nala hua'chi a'xni'ca' kalhacāuj tzu'ma'jan ixta'a'mā'na a'nlhā natapūchahuacan. Ixtalē'mā'na ixpūmakskoca'n lā' ta'a'lh taka'lhī huan squi'nīni'. ");
INSERT INTO tooNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Lā' kalhaquitzis lakskalalh ixtahuanī't lā' ā'kalhaquitzis tū'. ");
INSERT INTO tooNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Huan a'ntīn tū' lakskalalh xmān talē'lh ixpūmakskoca'n lā' tū' tapāstacli natalē'n macsti'na'j gas para natamojō na ixpūmakskoca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Lā' huan a'ntī lakskalalh, xlaca'n talē'lh ixpūmakskoca'n lā' nā talē'lh ā'macsti'na'j gas. ");
INSERT INTO tooNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Lā' como takoxīlh huan squi'nīni', ixlīhuākca'n ixtalakalhtatahui'lāna' lā' ā'calīstān talhtatalh. ");
INSERT INTO tooNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Lā' hua'chi i'tāt tzī'sa takaxmatli a'nchī kalhatin ta'salh lā' hualh: “¡Mimā' huan squi'nīni'; capintit pāxtokā'tit!” ");
INSERT INTO tooNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Lā' ixlīhuākca'n huan tzu'ma'jan talakahualh. Tatā'kaquī'lh lā' tacāxtlahualh ixpūmakskoca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Lā' tuncan huan kalhaquitzis a'ntīn tū' talīmilh gas tahuanilh huan ā'kalhaquitzis: “Caquilāmaxquī'uj macsti'na'j mingasca'n como tamixmā'na huā' quimpūmakskoca'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Lā' huan a'ntī lakskalalh takalhtīlh: “O tū', como chuntza' tū' cati'a'cchā'lh para quina'n nīn para hui'xina'n. Mejor capintit tamāhua'yā'tit a'nlhā stā'can”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Lā' līhuan huan kalhaquitzis ixta'a'mā'na tatamāhua huan gas, chilh huan squi'nīni'. Lā' huan tzu'ma'jan a'ntī cāxni'j ixtahui'lāna' tatā'tanūlh huan squi'nīni' nac chic lā' mālacchahuaca huan mākalhcha. ");
INSERT INTO tooNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Lā' ā'calīstān tachā'lh huan ā'kalhaquitzis tzu'ma'jan lā' tahualh: “Māpa'ksīni', caquilāmālaquī'ni'uj”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Lā' xla' cākalhtīlh: “Quit tū' iccālakapasāni'”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lā' Jesús cāhuanilh: ―Skalalh catahui'la'tit como tū' ca'tzīyā'tit tuyā hora nīn tuyā chi'chini' na'icmimpala quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Lā' Jesús cāhuanipā: ―Lā' a'nchī huanī't a'nlhā Dios nacāmāpa'ksīkō' huan tachi'xcuhuī't, ū'tza' hua'chi kalhatin chi'xcu' a'ntī ixa'mā' ā'lacatin. Lā' cāmāta'sīlh ixtasācua'nī'n lā' cāmacamaxquī'lh ixtumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Chu a'nchī ixlīskalalhca'n chā'tunu', chuntza' maxquī'ca. Lakaquitzis mil maxquī'ca kalhatin lā' lakatu' mil maxquī'ca ā'kalhatin lā' lakatin mil huan ā'kalhatin. Lā' tuncan a'lh makat. ");
INSERT INTO tooNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Huan tasācua' a'ntī ixmaxquī'canī't huan lakaquitzis mil, xla' ixtamāhuana'mā' lā' ī'stā'namā' lā' chuntza' tlajalh ā'lakaquitzis mil huampala. ");
INSERT INTO tooNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Lā' huan a'ntī maklhtīni'lh lakatu' mil, nā chu a'cxtim tlajalh ā'lakatu' mil. ");
INSERT INTO tooNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Lā' huan a'ntī maklhtīni'lh lakatin mil, xla' a'lh lā' ponknu'lh lā' mātzē'kli ixtumīn huan ixpatrón. ");
INSERT INTO tooNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Lā' makān takoxīlh huan patrón. Lā' a'xni'ca' taspi'tli, ixtlahuacu'tun ixcuenta. ");
INSERT INTO tooNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pū'la lakmilh huan a'ntī ixmaklhtīni'nī't lakaquitzis mil lā' nā macamaxquī'lh ixpatrón huan ā'lakaquitzis mil a'ntū ixtlajanī't. Lā' huanilh: “Quimpatrón, hui'x quimaxqui' lakaquitzis mil lā' ā' iclīmimpala ā'lakaquitzis mil a'ntū ictlajanī't”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Lā' huan patrón huanilh: “Tzey. Lej tzeyā tasācua' hui'x. Xa'nca tlahua' milītlōt. Lā' como xa'nca scujti con huā'mā' tumīn, chuhua'j nalītō'ca'ya' lā' ā'chulā' na'icmaxquī'yāni'. Cata't lā' naquintā'pāxuhua'ya'”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Lā' ā'calīstān lakmilh huan tasācua' a'ntī ixmaklhtīni'nī't lakatu' mil lā' huanilh: “Quimpatrón, hui'x quimaxqui' lakatu' mil lā' ā' iclīmimpala ā'lakatu' mil a'ntū ictlajanī't”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Lā' huan patrón huanilh: “Tzey. Lej tzeyā tasācua' hui'x. Xa'nca tlahua' milītlōt. Lā' como xa'nca scujti con huā'mā' tumīn, chuhua'j nalītō'ca'ya' lā' ā'chulā' na'icmaxquī'yāni'. Cata't lā' naquintā'pāxuhua'ya'”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Lā' ā'calīstān lakmilh huan tasācua' a'ntī ixmaklhtīni'nī't lakatin mil. Lā' xla' huanilh ixpatrón: “Quimpatrón, xa'icca'tzī palh hui'x ca'tzanca'tzīn. Hui'x ī'ya' a'nlhā tū' cha'nti lā' nacā'ya a'nlhā tū' xua'ya'ma'ka'. ");
INSERT INTO tooNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","U'tza' iclījicua'ni'ni' lā' quit icponknu'lh nac ti'ya't lā' icmā'cnūlh mintumīn. Lā' ā' iclīmin a'ntū mila' ixuanī't”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Lā' huan patrón kalhtīlh: “Tū' tzey hui'x. Lej lhquitit tasācua' hui'x. Hui'x puhua'na' palh quit ic'ī' a'nlhā tū' iccha'nli lā' iccā' a'nlhā tū' icxua'ya'maka'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Como chuntza' puhua'na', ixmā'nu' quintumīn nac banco lā' a'xni'ca' xa'ictaspi'tli xa'icmaklhtīni'lh quintumīn lā' huan xaska'ta'”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Lā' cāhuanilh huan a'ntī ixtayāna'ncha': “Camaklhtītit huan lakatin mil a'ntū ka'lhī lā' camaxquī'tit huan a'ntī ka'lhī lakacāuj mil”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Lā' Jesús cāhuanipā: ―A'chulā' namaxquī'can huan a'ntī ka'lhī lā' na'a'katāxtūni'. Lā' huan a'ntīn tū' ka'lhī, namaklhtīcan huan macsti'na'j a'ntū ixka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Lā' huā'mā' tasācua' a'ntīn tū' tzey, catamacaxtutit a'nlhā cā'pucsua'. A'ntza' nacalhuan lā' nalāxca ixtatzan. ");
INSERT INTO tooNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Lā' Jesús huampā: ―Quit huan Chi'xcu' xala' Tālhmā'n. Lā' a'xni'ca' na'ictanū quilīRey, qui'ángeles naquintalītamacxti'li'. Lā' quit na'ictahui'la na quimpūtahuī'lh a'nlhā na'iclacāxtlahua lā' na'icmāpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Lā' tachi'xcuhuī't xalanī'n chuxalhā nac cā'quilhtamacuj natatakēxtimī na quilacapūn. Lā' quit na'iccāmā'kapitzī hua'chi huan pastor cāmā'kapitzī huan borregos lā' huan chivos. ");
INSERT INTO tooNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lā' na'iccāhui'lī huan borregos na quimpāxtūcāna'j lā' na'iccāhui'lī huan chivos na quimpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Lā' quit huan Rey na'iccāhuani huan a'ntīn tahui'lāna' na quimpāxtūcāna'j: “Cata'ntit hui'xina'n. QuinTāta' Dios cāsicua'lanālīnī'ta'ni'. Camaklhtītit huan līmāpa'ksīn a'ntū mila'ca'n nala. Cāxtlahuacanī't para hui'xina'n desde a'xni'ca' Dios tlahualh huan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Dios cāsicua'lanālīnī'ta'ni' como hui'xina'n quilāmāhuī'uj a'xni'ca' quit xa'ictzi'ncsa. Lā' hui'xina'n quilātā'hua'uj mixcānca'n a'xni'ca' quit xa'ickalhpūtī. Hua'chi makatiyāti' quit lā' quilāmānūj na minchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tū'tza' tzey ixuanī't quilu'xu' lā' hui'xina'n quilāmaxquī'uj xasāsti'. Lā' xa'ic'ī'tza'ca'n lā' quilāmaktāyauj. Lā' tachī'n xa'icuanī't lā' quilālakpaxialhna'uj”. Chuntza' na'iccāhuani. ");
INSERT INTO tooNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Lā' huan a'ntī xalacuan natahuan: “Māpa'ksīni', ¿lhānīn iccālaktzī'ni' a'xni'ca' ixtzi'ncsa' lā' iccāmāhuīni'? Lā' ¿lhānīn iccātā'hua'ni' xcān a'xni'ca' ixkalhpūtīya'? ");
INSERT INTO tooNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Lā' ¿lhānīn iccāmānūni' na quinchicca'n a'xni'ca' ixlatlā'hua'na' hua'chi makatiyāti'? Lā' ¿lhānīn iccāmaxquī'ni' milu'xu'? ");
INSERT INTO tooNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Lā' ¿lhānīn iccāmaktāyani' a'xni'ca' ixī'tza'ca'na' o tachī'n ixua'nī'ta'?” ");
INSERT INTO tooNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Lā' māni' quit huanmā' Rey na'iccākalhtī: “Stu'ncua' a'ntū iccāhuaniyāni'. Catūhuā a'ntūn tlahua'ni'tit kalhatin quintā'timīn, a'yuj más xamakstancu xla', ū'tza' hua'chilh quilātlahuani'uj quit”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Lā' quit huanmā' Rey na'iccāhuani huan a'ntīn tahui'lāna' na quimpāxtūxuc: “Catapānū'tit. Hui'xina'n cātamālaclē'nīnī'ta'ni'. Capintit a'nlhā tūlalh catimixli huan macscut. Capintit a'nlhā cāxtlahuacanī't para huan ko'ti'ti' lā' ixmaktāyana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Cātamālaclē'nīnī'ta'ni' como tū' quilāmāhuī'uj a'xni'ca' quit xa'ictzi'ncsa. Lā' tū' quilātā'hua'uj mixcānca'n a'xni'ca' xa'ickalhpūtī. ");
INSERT INTO tooNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Quit hua'chi makatiyāti' xa'iclatlā'huan lā' hui'xina'n tū' quilāmānūj na minchicca'n. Tū'tza' tzey ixuanī't quilu'xu' lā' tū' quilāmaxquī'uj xasāsti'. Xa'ic'ī'tza'ca'n lā' tachī'n xa'icuanī't. Lā' hui'xina'n tū' quilālakpaxialhna'uj”. Chuntza' na'iccāhuani. ");
INSERT INTO tooNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Lā' xlaca'n natahuan: “Māpa'ksīni', ¿lhānīn iccālaktzī'ni' a'xni'ca' ixtzi'ncsa', o ixkalhpūtīya', o hua'chi makatiyāti' lā' quina'n tū' iccāmaktāyani'? Lā' ¿lhānīn iccālaktzī'ni' a'xni'ca' tū'tza' tzey ixuanī't milu'xu' o ixī'tza'ca'na' o tachī'n ixua'nī'ta' lā' quina'n tū' iccāmaktāyani'?” ");
INSERT INTO tooNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Lā' quit huanmā' Rey na'iccākalhtī: “Stu'ncua' a'ntū iccāhuaniyāni'. Catuhuā a'ntūn tū' tlahua'ni'tit kalhatin quintā'timīn, a'yuj más xamakstancu xla', chuntza' hua'chilh tū' quilātlahuani'uj quit”. ");
INSERT INTO tooNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Lā' Jesús cāhuanipā: ―Lā' tuncan huā' tamā'na nata'a'n nac pūpātīn para pō'ktu. Lā' huan xalacuan nataka'lhī ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lā' a'xni'ca' Jesús cāhuanikō'lh huā'mā', cāhuanilh ī'sca'txtunu'nī'n: ");
INSERT INTO tooNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Hui'xina'n ca'tzīyā'tittza' que sputacus lakatu' chi'chini' a'xni'ca' nala cā'tani' de pascua. Lā' quit huan Chi'xcu' xala' Tālhmā'n. Lā' iccāhuaniyāni' que naquimacamāstā'can para naquixtokohua'ca'can ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lā' huan xanapuxcu'nu' curasna' lā' huan xamākalhtō'kē'ni'nī'n huan ley lā' huan xanapuxcu'nu' israelitas, xlaca'n tatakēstokli na ixtanquilhni' huan ixpalacio Caifás. Xla' mero a'ntī xapuxcu' curasna' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Lā' a'ntza' talacchihuīna'lh a'nchī tzē nata'a'kxoko Jesús para natachi'pa lā' chuntza' natamāmaknīnīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Lā' ixtalāhuani: ―Palh natlahuayāuj catūhuā līhuan lamā' cātani', huan tachi'xcuhuī't natatā'kaquī'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús ixuī' nac Betania na ixchic Simón. Lā' huā'mā' Simón ixmasni'mā' ixquinīt lā' ixtzeyanī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lā' kalhatin puscāt laktapajtzūlh Jesús. Ixlē'mā' pātin frasco a'ntū ixtzuma de aceite a'ntū lej xatapala lā' lej mu'csa. Lā' līhuan Jesús ixuā'yamā', huan puscāt mūmā'ca'lh Jesús huan aceite. ");
INSERT INTO tooNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lā' a'xni'ca' huan sca'txtunu'nī'n talaktzī'lh a'ntū tlahualh, ta'a'kchā'lh lā' tatzuculh talāhuani: ―Lā' ¿a'chī' pāxca't lanī't huā'mā' aceite? ");
INSERT INTO tooNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tzē ī'stā'ca como lej tapala lā' huan tumīn tzē ixcāmaxquī'ca huan pobresni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Lā' Jesús ixca'tzī a'ntū ixtalīchihuīna'mā'na lā' cāhuanilh: ―Lā' ¿a'chī' mājiclhuī'yā'tit huā'mā' puscāt? Quintlahuani'lh a'ntū lej tzey. ");
INSERT INTO tooNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pō'ktu na'a'nan pobresni' na milaclhpu'nanca'n pero quit tū' pō'ktu na'iccātā'latahui'layāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lā' chu a'nchī huā'yā puscāt quimūmā'ca'lh huā'mā' aceite, ū'tza' hua'chilh ixquincāxtlahualīlh para naquimā'cnūcan. ");
INSERT INTO tooNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Stu'ncua' a'ntū iccāhuaniyāni'. Chuxalhā nac cā'quilhtamacuj a'nlhā namāca'tzīnīni'ncan huan xatzey tachihuīn ixpālacata Cristo, a'ntza' nahuancan a'ntū tlahualh huā'mā' puscāt. Lā' ixlīhuākca'n natapāstaca xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Lā' kalhatin de huan kalhacāujtu' sca'txtunu'nī'n xla' ixuanican Judas Iscariote. Xla' a'lh cātā'chihuīna'n huan xanapuxcu'nu' curasna' ");
INSERT INTO tooNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","lā' cāhuanilh: ―¿Lhānchula' naquilāmāpalayāuj palh na'iccāmacamaxquī'yāni' Jesús? Lā' xlaca'n tamāpalalh pu'xamacāuj tumīn de plata. ");
INSERT INTO tooNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lā' desde a'xni'ca', Judas putzalh a'nchīn tzē nacāmacamaxquī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lā' milh huan xapū'lh chi'chini' huan cā'tani' a'ntū huanican Pascua a'xni'ca' hua'can pāntzi a'ntūn tū' ka'lhī levadura. Lā' huā'mā' xapū'lh chi'chini' huan sca'txtunu'nī'n talaktapajtzūlh Jesús lā' takalhasqui'nīlh: ―¿Lhachū lacasqui'na' na'iccāxtlahualīyāuj para nahua'yāuj xalīhua't huan cā'tani'? ");
INSERT INTO tooNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Lā' xla' cāhuanilh: ―Capintit huan nac xcānsipej lā' natanū'yā'tit na ixchic chā'tin chi'xcu' lā' nahuaniyā'tit: “Huan Mākalhtō'kē'ni' huan: Pajtzutza' quimpūnīn lā' icua'cu'tun huan xalīhua't cā'tani' na minchic. Lā' na'iccātā'huā'yan quisca'txtunu'nī'n”. ");
INSERT INTO tooNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Lā' huan sca'txtunu'nī'n ta'a'lh lā' tatlahualh chu a'nchī Jesús cāmāpa'ksīlh lā' tacāxtlahualīlh huan xalīhua't cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lā' a'xni'ca' ixtzī'suamā', Jesús lā' huan kalhacāujtu' ī'sca'txtunu'nī'n ixtahuā'yahui'lāna' nac mesa. ");
INSERT INTO tooNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Lā' līhuan ixtahuā'yamā'na, Jesús cāhuanilh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Kalhatin de hui'xina'n naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Lā' xlaca'n talakaputzalh lā' tatzuculh takalhasqui'nī chā'tunu': ―¿Chu quit, quiMāpa'ksīni'? ");
INSERT INTO tooNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Lā' Jesús cākalhtīlh: ―U'tza' a'ntī quintā'pūhuā'yan pulātu, ū'tza' naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Quit huan Chi'xcu' xala' Tālhmā'n lā' naquimpātle'keni' ixlīhuāk chu a'nchī tzo'kcanī't quimpālacata na ixtachihuīn Dios. Pero xānti la huan chi'xcu' a'ntī naquimacamāstā'; nalīlakaputza. Más tzey para xla' palh tū' ixlacatuncuīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Lā' Judas, ū'tza' a'ntī namacamāstā', lā' xla' huanilh: ―Mākalhtō'kē'ni', ¿chu tzēlasā' quit? Jesús kalhtīlh: ―Chuntza' hui'x hua'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Lā' līhuan ixtahuā'yamā'na, Jesús tayalh huan pāntzi lā' maxquī'lh pāxcatca'tzī Dios. Lā' a'xni'ca' che'kelh, cāmaxquī'lh ī'sca'txtunu'nī'n lā' cāhuanilh: ―Cahua'tit. U'tza' huā'mā' quimacni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Lā' tuncan tayalh huan taza lā' maxquī'lh pāxcatca'tzī Dios. Lā' macasti'n cāmaxquī'lh xlaca'n lā' cāhuanilh: ―Cahua'tit macasti'n chā'tunu' ");
INSERT INTO tooNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","como ū'tza' huā'mā' quinka'lhni'. Lā' ū'tza' a'ntū līcāxtlahuaca huan xasāsti' convenio ixpālacata a'nchī Dios nacālīmāpūtaxtū tachi'xcuhuī't. Lā' quinka'lhni' ū'tza' a'ntū na'icmaka'n para nacāmāsputūnu'ni' ixtalaclē'i'ca'n lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Lā' iccāhuaniyāni' que tū' ictihua'lh xaxcān uva hasta a'xni'ca' na'iccātā'hua'yāni' ā'tāpātin xaxcān uva xasāsti' a'nlhā ixlīhuāk catūhuā xasāsti' lā' xtunc a'nlhā namāpa'ksīni'n quinTāta' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Lā' a'xni'ca' ixtatlī'nī't lakatin himno, tataxtulh lā' ta'a'lh huan nac o'kspū'n a'nlhā huanican Olivos. ");
INSERT INTO tooNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Lā' Jesús cāhuanilh: ―Huā'mā' tzī'sa milīhuākca'n naquilā'a'kxtekmaka'nāuj ixpālacata a'ntū naquimpātle'keni' como tatzo'kni' na ixtachihuīn Dios: “Na'icmaknī huan pastor lā' nata'a'kahuankō' huan borregos”, tatzo'kni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Lā' a'xni'ca' naquimālakahuanīchokocan, pū'la na'ica'n que hui'xina'n nac estado de Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Lā' Pedro huanilh: ―A'yuj ixlīhuākca'n ā'makapitzīn nata'a'kxtekmaka'nāni', pero quit tū' maktin ictimakxtekni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Lā' Jesús huanilh: ―Stu'ncua' a'ntū icuaniyāni': Huā'mā' tzī'sa a'xni'ca' tūna'j nata'sa huan gallo, hui'x naquinkalhtatzē'ka' maktu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Lā' Pedro huanilh: ―A'yuj naquintā'maknīca'na', pero quit tū' ictikalhtatzē'kni'. Lā' chu a'cxtim tahualh ixlīhuākca'n huan sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lā' Jesús lā' ī'sca'txtunu'nī'n tachā'lh nac lakatin lugar a'nlhā huanican Getsemaní. Lā' xla' cāhuanilh: ―Catahui'la'tit hui'xina'n huā'tzā' līhuan quit na'ica'n na'ictā'chihuīna'n Dios a'jnanu'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lā' cālē'lh lacachuna'j Pedro lā' kalhatu' ixo'kxa'n Zebedeo lā' tzuculh lej lakaputza lā' lej ixpāta'lamā'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Lā' cāhuanilh: ―Lej iclakaputza hasta tzē na'iclaknī huan talakaputzīt. Catachokotit huā'tzā' lā' naquilā'o'kska'lhīyāuj. Tū' calhtatatit. ");
INSERT INTO tooNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lā' Jesús a'lh lacachuna'j lā' tatzokostalh nac ti'ya't lā' lej squi'ni'lh Dios lā' huanilh: ―QuinTāta', palh tzē na'icpūtaxtu de huā' a'ntū na'icpātīni'n, camakxtekti chuntza' nala. Pero calalh a'ntū hui'x lacasqui'na' lā' tū' calalh a'ntū xmān quit iclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lā' tuncan taspi'tli a'nlhā ixcāmāchokonī't huan sca'txtunu'nī'n lā' cālaktzī'lh xlaca'n ixtalhtatahui'lāna'. Lā' huanilh Pedro: ―¿Chā mintu'tunca'n tūlalh tāyani'tit mintalhtataca'n nīn lakatin hora? ");
INSERT INTO tooNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Lakahuan catahui'la'tit lā' casqui'ni'tit Dios para que tū' nacātatlajayāni' a'xni'ca' cātalīlaktzī'nāni'. Stu'ncua' mi'a'clhcunucca'n tatlahuacu'tun xatzey pero mimacni'ca'n tū' taka'lhī tahuixcān ―cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Lā' ixlīmaktu' Jesús a'lh lā' squi'ni'lh Dios chuntza': ―QuinTāta', palh tasqui'nī na'icpātīni'n para na'ictlōkentaxtū mintapuhuān, chuntza' calalh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Lā' tuncan taspi'tpā a'nlhā cāmāchokolh huan sca'txtunu'nī'n lā' ixtalhtatamā'nampā como tanto ixtalhtatacu'tun que ixtalakalhtatahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Lā' cāmāchokopā lā' ixlīmaktu'tun a'lh lā' squi'ni'lh Dios. Lā' chu a'cxtim huanilh hua'chi ixuanī't xapū'la. ");
INSERT INTO tooNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lā' taspi'tpā a'nlhā cāmāchokolh huan sca'txtunu'nī'n lā' cāhuanilh: ―¿Chā lhtatapā'na'ntitcus lā' jaxpā'na'ntitcus? Chilhtza' huan hora a'ntū lhcācanī't. Quit huan Chi'xcu' xala' Tālhmā'n lā' naquimacamāstā'can na ixlīmāpa'ksīnca'n huan tūn tū' tzeyā chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Catāya'tit lā' cāhuitit; mimā'tza' huan a'ntī naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Lā' ixcātā'chihuīna'mā'cus Jesús a'xni'ca' chā'lh Judas. Xla' kalhatin de huan kalhacāujtu' sca'txtunu'nī'n ixuanī't. Lā' cātā'chā'lh lhūhua' tachi'xcuhuī't lā' ixtalē'n machīta lā' qui'hui'. Lā' tachā'lh por ixquilhtampānca'n huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Lā' Judas ū'tza' huan a'ntī ixmacamāstā'mā' lā' xla' ixcāhuaninī'ttza' a'nchī natalīlakapasa tichū Jesús. Ixcāhuaninī't: ―Na'iclacamu'su kalhatin; lā' xla' ū'tza' Jesús. Nachi'payā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lā' a'xni'ca' chilh Judas, laktapajtzūlh Jesús lā' huanilh: ―Tzī'sua, Mākalhtō'kē'ni'. Lā' lacamu'sulh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Lā' Jesús kalhtīlh: ―Amigo, lā' ¿a'chī' ta'na'? Lā' huan tachi'xcuhuī't a'ntīn tatā'milh Judas talaktapajtzūlh Jesús lā' tachi'palh para natalē'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Lā' chu tuncan kalhatin a'ntī ixtā'minī't Jesús, māxtulh ixmachīta lā' mātakāhuī'lh ixtasācua' huan xamāpa'ksīni' curasna' lā' a'kasityujulh ixa'ka'xko'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Lā' Jesús huanilh: ―Camāqui' mimachīta. A'ntī nalīlāsta'la ixmachīta, chuntza' namaknīcan xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Chā tū' ca'tzīya' que quit tzē na'icsqui'ni' quinTāta' Dios caquimaktāyalh lā' xla' chu līmaktin naquimacamini' lakacāujtu' mil ángeles? ");
INSERT INTO tooNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero palh xa'ictlahualh cahuā chuntza', ¿chichū nalītlōkentaxtūcan a'ntū huan ixtachihuīn Dios a'nlhā tatzo'kni' que tasqui'nī napātle'ke chuntza' chu a'nchī pātle'kemā'? ");
INSERT INTO tooNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lā' Jesús cāhuanilh huan tachi'xcuhuī't: ―¿A'chī' līta'ntit mimachītaca'n lā' minqui'hui'ca'n? Hua'chilh chi'pacu'tunā'tit kalhatin ka'lhāna'. A'xni'ca' xa'iccātā'latlā'huanāni' lakalīyān nac lītokpān, ¿a'chī' tūlalh quilāchi'pauj a'xni'ca'? ");
INSERT INTO tooNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ixlīhuāk huā'mā' pātle'kelh para natlōkentaxtū a'ntū tatzo'kli huan profetas na ixtachihuīn Dios ―cāhuanilh. Lā' ixlīhuākca'n huan sca'txtunu'nī'n ta'a'kxtekui'līlh Jesús lā' tatzā'lalh. ");
INSERT INTO tooNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Huan a'ntīn tachi'palh Jesús talē'lh na ixchic Caifás a'ntī xamāpa'ksīni' huan curasna' ixuanī't. A'ntza' ixtatakēstoknī't xamākalhtō'kē'ni'nī'n huan ley lā' xanapuxcu'nu' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Lā' Pedro lakamakat stālani'lh hasta chā'lh na ixtanquilhni' ixchic huan xamāpa'ksīni' curasna'. Lā' tanūlh na ixcorral huan chic lā' cātā'tahui'lh huan policíasna' para nalaktzī'n a'nchī nalīlacāxtlahuacan. ");
INSERT INTO tooNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Huan xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas lā' ixlīhuākca'n huan xalaka'tla'n pūchihuīna'nī'n ixtaputzamā'na a'nchī natalē'ksa'nīni'n Jesús para natalīmāmaknīnīni'n. Ixtaputzamā'na catūhuā a'yuj tū' stu'ncua' a'ntū nalē'ksa'nīni'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lā' tūla ixtamāstū'ncni' nīn tuntū' a'yuj lhūhua' chi'xcuhuī'n ixtalaka'n lā' talīchihuīna'lh a'ntūn tū' stu'ncua' ixpālacata Jesús. Lā' ā'calīstān tamilh kalhatu' a'ntī chu a'cxtim ixtachihuīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Lā' xlaca'n tahualh: ―Huā'mā' chi'xcu' hualh: “Quit tzē na'icmāsputūkō' huan xaka'tla' ixlītokpān Dios lā' ixlīlakatu'tun chi'chini' na'icyāhuapala”. ");
INSERT INTO tooNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Lā' huan xamāpa'ksīni' curasna' tāyalh lā' huanilh Jesús: ―¿Chu tuntū' nakalhtīni'na'? ¿Tuchū talī'a'ksa'nīni'mā'ni' huā' tayāna' chi'xcuhuī'n? ");
INSERT INTO tooNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Lā' Jesús ca'cs tāyalh. Lā' huan xamāpa'ksīni' curasna' chihuīna'mpā lā' huanilh: ―Dios a'ntī lakahuan, ū'tza' kaxmatāni'. Chuhua'j naquihuani'ya' a'ntū stu'ncua'. Caquilāhuaniuj palh hui'x Cristo a'ntī ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Lā' Jesús kalhtīlh: ―U'huē, quit ū'tza' chu a'nchī hua'na'. Lā' nā iccāhuaniyāni' huā'mā'. Desde chuhua'j hui'xina'n naquilālaktzī'nāuj quit huan Chi'xcu' xala' Tālhmā'n na'ictahui'la na ixpāxtūcāna'j Dios a'ntī māpa'ksīni'mā'. Lā' nā na'icminācha' nac a'kapūn ixlaclhni' poklhnu'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lā' huan xamāpa'ksīni' curasna' xtī'tli ixlu'xu' māni' xla' para namāsu'yu que lej ixa'kchā'n lā' hualh: ―Huā'mā' chi'xcu' tā'talacastuccu'tun Dios. Tū'tza' maclacasqui'nāuj ā'catīhuā para naquincāhuaniyāni' palh tū' tzey xla'. Hui'xina'n kaxpa'tnī'ta'ntit a'nchī xla' hualh que xla' ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Chī puhua'nā'tit? Lā' tahualh: ―Xla' lē'n cuenta lā' maclacasqui'n nanī. ");
INSERT INTO tooNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Lā' tuncan talakachojmanīlh Jesús lā' tatucsli. Lā' ā'makapitzīn talacala'sli ");
INSERT INTO tooNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","lā' tahuanilh: ―Como hua'na' que hui'x Cristo, caquilhchi'pi a'ntī lacala'sni'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Lā' līhuan Pedro ixuī' kēpūn nac tanquilhni' lā' kalhatin squiti' laktapajtzūlh lā' huanilh: ―Nā hui'x ixtā'latlā'hua'na' Jesús xala' nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Lā' Pedro kalhtatzē'kli na ixlacapūnca'n ixlīhuākca'n lā' hualh: ―Tū' icca'tzī tuchū huanicu'tuna'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lā' Pedro tatampūxtulh macsti'na'j lā' ā'kalhatin huampala tzu'ma'jāt laktzī'lh. Lā' xla' cāhuanilh huan a'ntī ixtayāna'ncha': ―Huā'mā' chi'xcu' nā ixtā'latlā'huan Jesús xala' nac Nazaret. ");
INSERT INTO tooNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Lā' Pedro kalhtatzē'kpā lā' stu'tu'lu' hualh: ―Quit tū' iclakapasa huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Lā' ixlīka'tlā'tus xlaca'n a'ntī ixtatā'layāna' talaktapajtzūlh Pedro lā' tahuanilh: ―Stu'ncua' hui'x kalhatin de xlaca'n como mintachihuīn hua'chi xlaca'n a'ntī xalanī'n nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lā' Pedro tzuculh macapūlhcacan xa'cstu lā' stu'tu'lu' hualh: ―Dios ca'tzī palh tū' iclakapasa huā'mā' chi'xcu'. Lā' chu tuncan lacapalh ta'salh huan gallo. ");
INSERT INTO tooNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Lā' ū'tza' līmāpāstaquīlh Pedro a'nchī Jesús ixuaninī't: “A'xni'ca' tūna'j nata'sa huan gallo, hui'x naquinkalhtatzē'ka' maktu'tun”. Lā' Pedro taxtulh de a'ntza' lā' lej māxana'j lakaputzaj calhualh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lā' a'xni'ca' tuncuīlh, ixlīhuākca'n xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas talacchihuīna'lh lā' tacāxtlahualh ixpātunca'tzīca'n a'nchī natamāmaknīnīni'n Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Lā' ixmacachī'canī't lā' talē'lh lā' tamacamaxquī'lh Poncio Pilato a'ntī gobernador ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lā' Judas ū'tza' a'ntī macamāstā'lh Jesús. Lā' a'xni'ca' Judas laktzī'lh a'nchī māpa'ksīca que namāmaknīnīni'ncan Jesús, lakaputzalh lā' xtunc pāstacna'lh lā' cāmāspi'tni'lh huan pu'xamacāuj tumīn de plata huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' israelitas, ");
INSERT INTO tooNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","lā' cāhuanilh: ―Quit ictlahualh talaclē'i' como icmacamāstā'lh huan chi'xcu' a'ntīn tuntū' ixlaclē'n. Lā' xlaca'n takalhtīni'lh: ―Huā'mā' tū' quimaca'tzica'n. Cuenta catlahua' māni' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Lā' Judas a'lh nac lītokpān lā' tilhquītamacanūlh na ixchakān huan lītokpān huan tumīn lā' a'lh tā'kpixchī' nac a'katin qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Lā' huan xanapuxcu'nu' curasna' tasacli huan tumīn lā' talāhuanilh: ―Tūla namojōyāuj a'nlhā mojōcan tumīn a'ntū mālacnūni'can Dios como huā'mā' tumīn līmāpalacanī't para namāmaknīnīni'ncan kalhatin chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Lā' talacchihuīna'lh lā' talacāxtlahualh a'nchī natalītamāhua huan pītzina'j ti'ya't. Huā'mā' ti'ya't ixmāpācuhuīcan Ixti'ya't huan Alfarero lā' a'ntza' ixcāmā'cnūcan huan makatiyātī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Lā' como lītamāhuaca huan tumīn a'ntū ixlīmāpalacanī't para namāmaknīnīni'ncan kalhatin chi'xcu', chuhua'j māpācuhuīcan huan Ti'ya't a'ntū Pasakō'nī't Ka'lhni'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Lā' chuntza' tlōkentaxtūca huā'mā' a'ntū hualh huan profeta Jeremías a'nlhā tzo'kli na ixtachihuīn Dios: “Cātēca huan pu'xamacāuj tumīn de plata (ū'tza' ixtapalh kalhatin chi'xcu' chu a'nchī lacāxtlahualh makapitzīn israelitas). ");
INSERT INTO tooNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Lā' huā'mā' tumīn lītamāhualh Ixti'ya't huan Alfarero chu a'nchī quimāpa'ksīlh huan Māpa'ksīni' Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lā' a'xni'ca' Jesús ixyā na ixlacapūn huan gobernador Pilato, lā' ū'tza' kalhasqui'nīlh Jesús: ―¿Chā hui'x ixReyca'n huan israelitas? Lā' Jesús huanilh: ―Chu chuntza' a'nchī hua'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lā' a'xni'ca' huan xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas ixtalē'ksa'nīni'n, Jesús tū' kalhtīni'lh nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Lā' Pilato kalhasqui'nīpā Jesús: ―¿Chu tū' kaxpa'ta' ixlīhuāk a'ntūn talē'ksa'nīni'nāni' tachi'xcuhuī't? ");
INSERT INTO tooNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Lā' Jesús tū' kalhtīlh nīn tuntū'. Lā' ū'tza' līlē'cnīlh huan gobernador. ");
INSERT INTO tooNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lā' ixa'nan lakatin talanān lā' a'xni'ca' ixlamā' cā'tani', huan gobernador ixmakxteka kalhatin tachī'n. Lā' huan tachi'xcuhuī't ixtalacsaca huan tachī'n a'ntī namakxtekcan. ");
INSERT INTO tooNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lā' ixtanūma' kalhatin tachī'n a'ntī ixuanican Barrabás. Chuxalhā ixlakapascan huā'mā' Barrabás. ");
INSERT INTO tooNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lā' a'xni'ca' ixtatakēxtimīnī't huan tachi'xcuhuī't, Pilato cākalhasqui'nīlh: ―¿Tichūyā tachī'n lacasqui'nā'tit na'icmakxteka? ¿Chā na'icmakxteka huan Barrabás o na'icmakxteka Jesús a'ntī māpācuhuīcan huan Cristo? ");
INSERT INTO tooNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chuntza' hualh Pilato como xla' māchekxīlh a'nchī huan xanapuxcu'nu' curasna' ixtalakca'tzani' Jesús lā' ū'tza' talīmacamāstā'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Lā' līhuan Pilato ixuī' a'nlhā ixtlahuacan justicia, ixpuscāt macā'ni'lh tachihuīn lā' huanilh: “Tū' timaktanū'ya' ixpālacata huā'mā' tzeyā chi'xcu' como lej ko'hua'jua' iclakahuālaktzī'lh kōtan tzī'sa ixpālacata xla'”. ");
INSERT INTO tooNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Lā' huan xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas ixtacuccha'xnī't huan tachi'xcuhuī't lā' ū'tza' talīsqui'nli que camakxtekca huan Barrabás lā' tasqui'nli que camaknīca Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lā' huampala cātā'chihuīna'lh huan gobernador lā' cākalhasqui'nīlh: ―¿Tichū de huan kalhatu' tachī'n lacasqui'nā'tit na'icmakxteka? Lā' xlaca'n tahualh: ―Iclacasqui'nāuj Barrabás. ");
INSERT INTO tooNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Lā' Pilato cākalhasqui'nīlh: ―Lā' ¿tuchū lacasqui'nā'tit na'ictlahuani' Jesús a'ntī māpācuhuīcan huan Cristo? Lā' ixlīhuākca'n takalhtīlh: ―¡Caxtokohua'ca'ca! ");
INSERT INTO tooNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Lā' Pilato cāhuanilh: ―Lā' ¿a'chī'? ¿Tuchū tlahuanī't xla' a'ntūn tū' tzey? Lā' xlaca'n ā'chulā' tata'salh lā' palha' tahuanilh: ―¡Caxtokohua'ca'ca! ");
INSERT INTO tooNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lā' a'xni'ca' Pilato cuenta tlahualh que tūla ixcāmāko'xamixī lā' ā'chulā' ixtatā'kaquī'mā'na lā' tūlalh cātlajalh, xla' squi'nli xcān. Lā' na ixlacapūnca'n huan tachi'xcuhuī't Pilato makacha'ka'lh lā' cāhuanilh: ―Quit tū' iclē'n cuenta ixpālacata huā'mā' chi'xcu' lā' a'nchī nanī. Tū' tlahuanī't nīn tuntū' a'ntūn tū' tzey. Hui'xina'n nalī'pinā'tit cuenta. ");
INSERT INTO tooNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Lā' ixlīhuākca'n tachi'xcuhuī't takalhtīlh: ―¡Quina'n lā' quincamana'ca'n na'iclē'nāuj cuenta ixpālacata huā'mā' chi'xcu' lā' a'nchī nanī! ");
INSERT INTO tooNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lā' chuntza' Pilato māxtulh Barrabás lā' makxtekli. Lā' tuncan māpa'ksīlh cakēsno'kca Jesús lā' macamāstā'lh para naxtokohua'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lā' ā'calīstān ixtropa huan gobernador, Pilato, talē'lh Jesús huan nac pūchihuīn lā' tamākēxtimīlh lhūhua' tropasna' lā' talītamacxti'li'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Lā' tuncan tamāmakxtulh ixlu'xu' lā' tamālhakē'lh xaspi'nenke' lu'xu'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lā' tatlahualh lakatin corona de lhtucū'n lā' tamūhui'līlh. Lā' tamaxquī'lh qui'hui' a'ntū chi'palh na ixmacacāna'j. Lā' tatatzokostani'lh lā' talīlītzī'nli lā' tahuanilh: ―¡Ca'a'cnīni'ni'ca ixReyca'n huan israelitas! ");
INSERT INTO tooNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Lā' nā tachojmanīlh lā' tachi'palh ixqui'hui' lā' talīmūnicli. ");
INSERT INTO tooNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A'xni'ca' talīlītzī'nkō'lh chuntza', tamāmakxtulh ixlu'xu' xaspi'nenke' lā' tamālhakē'chokolh ixlu'xu' a'ntū ixla' ixuanī't. Lā' tuncan talē'lh para naxtokohua'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lā' līhuan ixta'a'mā'na, tapāxtokli kalhatin chi'xcu' xala' nac Cirene lā' ixtacuīni' Simón. Lā' sāmācu'quī'ca ixcruz Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Lā' chuntza' ta'a'lh lā' tachā'lh nac lakatin lugar a'nlhā huanican Gólgota a'ntū huanicu'tun Ixa'kxāk Nīn. ");
INSERT INTO tooNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lā' a'ntza' mālacnūni'ca Jesús vinagre a'ntū ixmojōni'canī't catūhuā a'ntū xū'ni' hua'chi huan xī'cxi' para que ixua'lh lā' tū' ixu'cxca'tzī'lh a'nchī napātīni'n. Lā' a'xni'ca' xla' quilhca'tzīlh, tū' ixua'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Lā' a'xni'ca' ixtaxtokohua'ca'nī'ttza', huan tropa tamālacpitzilh ixlu'xu' Jesús na ixlaclhni'ca'n lā' tapūmāxtulh suerte para natasu'yu a'ntī natachokoni'. Chuntza' tlōkentaxtūca a'ntū hualh huan profeta a'nlhā tzo'kli: “Tamālacpitzilh quilu'xu' na ixlaclhni'ca'n por huan suerte a'ntūn tamāxtulh”. ");
INSERT INTO tooNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Lā' tuncan tatahui'lalh para natamaktaka'lha. ");
INSERT INTO tooNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Lā' hui'līca nac cruz lakatin letrero na ixa'cpūn Jesús. Lā' a'ntza' ixtzo'kcanī't a'ntū ixpālacata līxtokohua'ca'ca. Lā' ixtzo'kcanī't: U'tza' Jesús a'ntī ixReyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Lā' nā cātā'xtokohua'ca'ca kalhatu' ka'lhāna'nī'n; kalhatin na ixpāxtūcāna'j lā' ā'kalhatin na ixpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lā' huan a'ntī ixtatētaxtumā'na taxakā'līlh ixa'kxākca'n lā' talakapalalh ");
INSERT INTO tooNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","lā' tahualh: ―Hui'x ixlactlahuacu'tuna' huan xaka'tla' lītokpān lā' ixyāhuapala' ixlīlakatu'tun chi'chini'. Lā' chuhua'j capūtaxtu. Palh hui'x ixO'kxa' Dios, cata'nchi huan nac cruz. ");
INSERT INTO tooNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lā' nā chuntza' ixtalīlītzī'n huan xanapuxcu'nu' curasna' lā' huan xamākalhtō'kē'ni'nī'n huan ley. Lā' huan fariseosnu' lā' huan xanapuxcu'nu' israelitas ixtatā'līlītzī'n lā' ixtalāhuanimā'na na ixlaclhni'ca'n: ");
INSERT INTO tooNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Xla' cāmāpūtaxtūlh ā'makapitzīn pero tūla pūtaxtu ixa'cstu. Palh stu'ncua' xla' ixReyca'n israelitas, cayujli de huan nac cruz chuhua'j lā' chuntza' nakalhlaka'ī'yāuj xla'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Xla' līpāhuan Dios; chuhua'j Dios camāpūtaxtūlh palh stu'ncua' pāxquī', como quincāhuanini' palh xla' ixO'kxa' Dios ―tahualh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Lā' nā huan ka'lhāna'nī'n a'ntī ixcātā'xtokohua'ca'canī't, nā xlaca'n talakapalalh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lā' tuncan cā'pucsua' lalh chuxalhā nac cā'ti'ya'tna'. Tzuculh hua'chi tastu'nūta lā' takoxīlh lakatu'tun hora. ");
INSERT INTO tooNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lā' hua'chi maktu'tun kōtanū, Jesús lej palha' ta'salh lā' hualh: ―Elí, Elí, ¿lama sabactani? ―lā' ū'tza' huanicu'tun: QuinDios, quinDios, ¿a'chī' qui'a'kxtekui'līnī'ta'? ");
INSERT INTO tooNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Lā' takaxmatli huā'mā' makapitzīn a'ntī ixtayāna'ncha' lā' xlaca'n talāhuanilh: ―Huā'mā' chi'xcu' māta'sīmā' huan a'cta'sana' Elías. ");
INSERT INTO tooNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lā' chu līmaktin kalhatin tatu'jnu'n quītē'lh catūhuā hua'chi panamāc. Lā' līmāchū'huī'lh vinagre lā' o'ksmā'ca'lh kentin qui'hui' lā' quilhyāhualh Jesús para nahua'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Lā' ā'makapitzīn tahualh: ―Camakxtekti. Nalaktzī'nāuj palh Elías namin namāpūtaxtū. ");
INSERT INTO tooNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Lā' huampala Jesús ta'salh lej palha' lā' tuncan nīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lā' māni' huā'mā' ka'tlā'tus taxtī'tpitzilh huan lu'xu' nac xaka'tla' lītokpān. U'tza' huā'mā' lu'xu' a'ntū ixmāpitzi huan lītokpān. Tzuculh a'cxtu lā' tapūpitzilh hasta huan nac ti'ya't. Lā' huan ti'ya't tachiquilh lā' huan chihuix tataxkālh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Lā' tatalaquī'lh huan taponkni' lā' talakahuanchokolh lhūhua' a'ntī ixtakalhlaka'ī'nī't Dios a'ntī ixtanīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xlaca'n tataxtulh huan nac taponkni' lā' a'xni'ca' ixlakahuanchokonī'ttza' Jesús, tatanūlh huan nac sicua'lanālanī't xcānsipej a'nlhā huanican Jerusalén. Lā' a'ntza' cātasu'yuni'lh lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lā' huan capitán romano lā' huan tropasna' a'ntī ixtatā'maktaka'lhmā'na Jesús, lej tajicua'lh a'xni'ca' tachiquilh huan ti'ya't lā' a'xni'ca' talaktzī'lh ā'catūhuā a'ntū pātle'kelh. Lā' xlaca'n tahualh: ―Stu'ncua' huā'mā' chi'xcu' huan ixO'kxa' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Lā' lhūhua' puscan ixtalaktzī'mā'na de makat. Ixtastālani'nī't Jesús desde a'xni'ca' taxtulh huan nac estado de Galilea lā' ixtamaktāyanī't. ");
INSERT INTO tooNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Lā' na ixlaclhni'ca'n huan puscan nā ixtayāna' María Magdalena lā' María a'ntī ixtzī'tca'n Jacobo lā' José lā' nā ixuī' ixtzī'tca'n ixo'kxa'n Zebedeo. ");
INSERT INTO tooNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lā' a'xni'ca' ī'smalanka'namā'tza', milh kalhatin chi'xcu' a'ntī ixuanican José lā' xala' nac cā'lacchicni' Arimatea. Lej rico ixuanī't lā' nā ixkalhlaka'ī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Lā' xla' laka'lh Pilato lā' squi'ni'lh ixmacni' Jesús. Lā' Pilato māpa'ksīni'lh que camaxquī'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Lā' José lē'lh huan ixmacni' Jesús lā' līmaksna'tli stala'nka' lu'xu'. ");
INSERT INTO tooNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Lā' māpī'lh nac lakatin xasāsti' lhu'cu' a'ntū ixcāxtlahuacanī'ttza' nac talhpān. Lā' huan lhu'cu' ixla' José ixuanī't. Lā' a'xni'ca' kalhui'līlh lakatin ka'tla' chihuix huan lhu'cu', xla' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Lā' na ixlacapūn huan lhu'cu' ixtahui'lāna' María Magdalena lā' ā'kalhatin María. ");
INSERT INTO tooNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Lā' ixlīlakalī a'xni'ca' ixpātle'kenī'ttza' huan chi'chini' a'ntū cāxui'līkō'can para huan chi'chini' a'ntū pūjaxcan, huan xanapuxcu'nu' curasna' lā' huan fariseosnu' talaka'lh Pilato. ");
INSERT INTO tooNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Lā' tahuanilh: ―Señor gobernador, quina'n icpāstacāuj a'ntū hualh huanmā' a'kxokonu' a'xni'ca' lakahuancus ixuanī't. Hualh chuntza': “Ixlīlakatu'tun chi'chini' na'iclakahuanchoko de na ixlaclhni'ca'n nīnī'n”, hualh. ");
INSERT INTO tooNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Chuntza' camāpa'ksi'ni' que xa'nca camaktaka'lhca huan taponkni' hasta napātleketza' lakatu'tun chi'chini'. Tzēlasā' ī'sca'txtunu'nī'n natamin nataka'lhan huan macni'. Lā' tzē natahuani huan tachi'xcuhuī't palh lakahuanchokonī't de na ixlaclhni'ca'n nīnī'n. Lā' chuntza' ā'chulā' tzē nata'a'kxoko huan tachi'xcuhuī't que xapū'la. ");
INSERT INTO tooNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Lā' Pilato cāhuanilh: ―A' tayāna' huan tropasna'. Cacālī'pintit lā' cacāxtlahua'tit hui'xina'n chu a'nchī namaktaka'lhcan. ");
INSERT INTO tooNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Lā' xlaca'n ta'a'lh lā' xa'nca tacāxtlahualh huan taponkni' lā' hui'līca sello nac huan chihuix a'ntū kalhui'līca. Lā' cāmāchokocancha' huan tropasna' para natamaktaka'lha. ");
INSERT INTO tooNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lā' ixpātle'kenī'ttza' huan chi'chini' a'ntū pūjaxcan lā' ixtuncuīmā' huan domingo a'xni'ca' María Magdalena lā' ā'kalhatin María ta'a'lh nac taponkni'. ");
INSERT INTO tooNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lā' chu līmaktin lej palha' tachiquilh huan ti'ya't. Lā' kalhatin ixángel huan Māpa'ksīni' Dios ixyujnī'ta'nchi de nac a'kapūn. Lā' a'xni'ca' chilh nac taponkni', māpānūlh huan chihuix a'ntū ixkalhui'līcanī't lā' pūtahui'lh. ");
INSERT INTO tooNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lā' huan ángel lej xkakalh hua'chi makli'pni' lā' ixlu'xu' lej smu'yonko' ixuanī't hua'chi panamāc lā' miqui. ");
INSERT INTO tooNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Lā' a'xni'ca' huan tropasna' talaktzī'lh, lej tajicua'ni'lh lā' taxpipilh lā' taxtacnānīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lā' huan ángel cāhuanilh huan puscan: ―Tū' cajicua'ntit. Quit icca'tzī palh hui'xina'n putzapā'na'ntit huan Jesús a'ntī xtokohua'ca'ca. ");
INSERT INTO tooNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Xla' tū' huī' huā'tzā' como lakahuanchokonī't chu a'nchī hualh. Catanū'tit lā' calaktzī'ntit a'nlhā ixmāpī'canī't. ");
INSERT INTO tooNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lā' lacapalh capintit lā' cacāhuani'tit ī'sca'txtunu'nī'n palh lakahuanchokonī'ttza' de na ixlaclhni'ca'n nīnī'n. Lā' chuhua'j xla' cāpū'lani'yāni' huan nac estado de Galilea. A'ntza' natā'lāpāxtokā'tit. Cuenta catlahua'tit a'ntū iccāhuanini'. ");
INSERT INTO tooNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Lā' tuncan lacapalh huan puscan tatapānūlh de huan nac taponkni'. Ixtajicua'n lā' nā ixtapāxuhua. Lā' tatu'jnu'n ta'a'lh cāhuani huan sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Lā' chu līmaktin Jesús cātalacsu'yuni'lh lā' cāmālakacuhuī'ni'lh. Lā' xlaca'n talaktapajtzūlh Jesús. Tachi'palh ixtojon lā' tamācā'tanīlh lā' tamāpāxuhuīlh. ");
INSERT INTO tooNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Lā' xla' cāhuanilh: ―Tū' cajicua'ntit. Capintit cacāmāca'tzīnī'tit quintā'timīn palh tasqui'nī cata'a'lh nac estado de Galilea lā' a'ntza' naquintalakchā'n lā' naquintalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lā' līhuan ixta'a'mā'na huan puscan, makapitzīn tropasna' a'ntī ixtamaktaka'lhnī't huan taponkni' lā' xlaca'n ta'a'lh huan nac xcānsipej a'nlhā huanican Jerusalén. Lā' tahuanilh huan xanapuxcu'nu' curasna' ixlīhuāk a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Lā' huan tamā'na xanapuxcu'nu' talaka'lh huan xanapuxcu'nu' israelitas para natalacchihuīna'n. Lā' lhūhua' tumīn cāmaxquī'ca huan tropasna' ");
INSERT INTO tooNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","lā' cāhuanica: ―Hui'xina'n nahua'nā'tit palh cā'tzī'sa tamilh ī'sca'txtunu'nī'n Jesús līhuan ī'lhtatapā'na'ntit lā' xlaca'n taka'lhalh huan ixmacni'. ");
INSERT INTO tooNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Lā' palh namāca'tzīnīcan huan gobernador que ī'lhtatapā'na'ntit, quina'n na'iclacāxtlahuayāuj para que tū' nacātamaknīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Lā' huan tropasna' tamaklhtīni'lh huan tumīn lā' ta'a'lh lā' tahualh chu a'nchī ixcāhuanicanī't. Lā' chuntza' huan israelitas tahuan hasta chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lā' huan kalhacāujtin sca'txtunu'nī'n ta'a'lh nac estado de Galilea nac lakatin o'kspū'n a'ntū Jesús lacsacli. ");
INSERT INTO tooNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lā' a'xni'ca' talaktzī'lh Jesús, tamācā'tanīlh a'yuj makapitzīn tū' ixtakalhlaka'ī'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Lā' Jesús cālaktapajtzūlh xlaca'n lā' cāhuanilh: ―Quit quimaxquī'canī't ixlīhuāk huan līmāpa'ksīn para que na'iccāmāpa'ksī ixlīhuākca'n a'ntīn ta'a'nan huan nac cā'ti'ya'tna' lā' huan nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Chuntza' capintit chuxalhā nac cā'quilhtamacuj lā' cacāmākalhlaka'ī'nīkō'tit ixlīhuākca'n para que natala quisca'txtunu'nī'n. Lā' nacāmā'kpaxī'yā'tit por ixlīmāpa'ksīn xaTāta' Dios lā' ixO'kxa' lā' huan Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lā' nacāmāsu'ni'yā'tit a'nchī natalatā'kchoko lā' a'nchī nata'a'kahuāna'ni' ixlīhuāk a'ntū quit iccālīmāpa'ksīni'nī'ta'ni' hui'xina'n. Lā' caca'tzītit palh quit pō'ktu iccā'o'kska'lhīyāni' hasta a'xni'ca' nasputa huan quilhtamacuj. Amén.");
INSERT INTO tooNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Huā'mā' huan xatzey tachihuīn a'ntū māsu'yucan ixpālacata Jesucristo a'ntī ixcaman Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kalhatin profeta tzo'knulh a'nchī Dios huanilh ixO'kxa'. Chuntza' hualh: Cakaxpa'tti. Quit na'icmaca'n quilacscujni' milacapūn a'ntī napū'lani'yāni' hui'x para nacāxtlahualī mintej. ");
INSERT INTO tooNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Lā' nā huan profeta Isaías tzo'knulh chuntza': A'ntza' a'nlhā cā'lhpi'mpi'li' ti'ya't, nakaxmatcan catīhuā a'ntī palha' chihuīna'n lā' nahuan: “Cacāxtlahua'tit huan tej como mimā' huan Māpa'ksīni'. Camālakstu'nctit huan tej”. Chuntza' tzo'knulh Isaías. ");
INSERT INTO tooNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Huā' tamā'na tlōkentaxtūca a'xni'ca' Juan a'ntī ixmā'kpaxīni'n ixtasu'yu nac cā'lhpi'mpi'li' ti'ya't. Lā' ixa'cta'sana'n lā' ixcāhuani huan tachi'xcuhuī't: ―Calīlakaputzatit ixpālacata mintalaclē'i'ca'n lā' cacā'a'kxtekui'lī'tit para nacātamāsputūnu'ni'yāni'. Lā' ca'a'kpaxtit. ");
INSERT INTO tooNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Lā' huan tachi'xcuhuī't xalanī'n chuxalhā nac estado de Judea lā' xalanī'n nac huan cā'lacchicni' Jerusalén, ixlīhuākca'n tamilh takaxmata a'ntū hualh Juan. Lā' a'xni'ca' takalhtasu'yuni'lh Dios ixtalaclē'i'ca'n, Juan cāmā'kpaxīlh kalhatunu' huan nac pūxka Jordán. ");
INSERT INTO tooNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Lā' Juan ī'lhakā'nī't lu'xu' a'ntū ixlīcāxtlahuacanī't ixchi'xit camello lā' ixlīchī'can de ko'xka' ixuanī't. Lā' ixua' hui'qui'lī't lā' ta'xcāt xala' nac cā'qui'huī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Lā' ixa'cta'sana'n lā' ixcāhuani tachi'xcuhuī't: ―A'calīstān namin ā'kalhatin a'ntī ā'līhua'ca' tasqui'nī que quit. Quit tūla icmālacastuca xla'. Ixtasācua' a'ntī naxcuta ixuarachi līhua'ca' tasqui'nī que quit. ");
INSERT INTO tooNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Quit iccālīmā'kpaxīnī'ta'ni' xcān pero xla' nacāmacamini'yāni' Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lā' huan tamā'na chi'chini' Jesús taxtulh huan nac xcānsipej Nazaret de estado de Galilea lā' lakmilh Juan a'nlhā ixmā'kpaxīni'mā'. Lā' Juan mā'kpaxīlh Jesús nac pūxka Jordán. ");
INSERT INTO tooNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Lā' a'xni'ca' Jesús tacutli de nac xcān, chu līmaktin laktzī'lh a'nchī talaquī'lh huan a'kapūn lā' mincha' huan Espíritu Santo lā' ixtasu'yu hua'chi tantzasnān a'xni'ca' ixyujmā'chi. Lā' chilh na ixa'kxāk Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Lā' kaxmatca lakatin tachihuīn nac a'kapūn lā' hualh: ―Hui'x qui'O'kxa' lā' lej icpāxquī'yāni'. Hui'x lej quimaxquī'ya' tapāxuhuān ―hualh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Lā' chu tuncan huan Espíritu Santo macā'lh Jesús nac cā'lhpi'mpi'li' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Lā' ixuī' a'ntza' nac cā'lhpi'mpi'li' ti'ya't tu'pu'xam chi'chini'. Lā' a'ntza' huan ko'ti'ti' a'ntī huanican Satanás, xla' ixputza a'nchī Jesús tū' ixa'kahuāna'ni'lh Dios. Lā' nā a'ntza' ixa'nan animal a'ntū ixtahua'nan. Lā' ixángeles Dios ixtamaktaka'lha. ");
INSERT INTO tooNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lā' a'xni'ca' ixchī'canī't Juan, Jesús a'lh nac Galilea lā' ixlī'a'cta'sana'n huan xatzey tachihuīn a'ntū Dios māca'tzīnīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Lā' ixuan: ―Chilhtza' huan chi'chini' a'ntū lhcāni'canī't lā' tapajtzūmā'tza' a'xni'ca' nalaktzī'ncan que stu'ncua' Dios māpa'ksīni'n. Calīlakaputzatit ixpālacata huan mintalaclē'i'ca'n a'ntū tlahuanī'ta'ntit lā' caxtāpalī'tit mintapāstacna'ca'n. Lā' cakalhlaka'ī'tit huan xatzey tachihuīn a'ntū Dios māca'tzīnīni'nī't. ");
INSERT INTO tooNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Lā' a'xni'ca' Jesús ixlatlā'huan na ixquilhtūn xaka'tla' xcān a'ntū huanican Mar de Galilea, xla' cālaktzī'lh Simón lā' ixtā'tin Andrés. Ixtamojōmā'na ixpūxuākna'ca'n nac xcān como xlaca'n squī'tī'ni'nī'n ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Lā' Jesús cāhuanilh: ―Caquilātā'a'uj lā' na'iccāmāsu'ni'yāni' a'nchī nacālīmākalhlaka'ī'nī'yā'tit tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lā' chu tuncan tamakxtekli ixpūxuākna'ca'n lā' tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lā' a'xni'ca' Jesús a'lh lacachuna'j, cālaktzī'lh Jacobo lā' Juan ixo'kxa'n Zebedeo. Xlaca'n ixtahui'lāna' nac barco lā' ixtalacachī'mā'na ixpūxuākna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lā' tuncan Jesús cāmāta'sīlh lā' xlaca'n ta'a'kxtekyāhualh ixtāta'ca'n Zebedeo con ixtasācua'nī'n nac barco lā' ta'a'lh lā' tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lā' ta'a'lh huan nac cā'lacchicni' Capernaum. Lā' tuncan huan chi'chini' de pūjaxni', lā' Jesús tanūlh na ixlītokpānca'n israelitas lā' cāmāsca'tīlh huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lā' ixtalīlē'cnī a'nchī ixcāmāsu'ni'mā' porque ixcāmāsu'ni'mā' hua'chi kalhatin a'ntī ka'lhī līmāpa'ksīn lā' tū' hua'chi tamāsu'yu huan xamākalhtō'kē'ni'nī'n huan ley. ");
INSERT INTO tooNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Lā' tuncan tanūlh huan nac lītokpān kalhatin chi'xcu' a'ntī ixka'lhī huan tlajana'. Lā' xla' ta'salh lā' hualh: ");
INSERT INTO tooNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús xala' nac Nazaret, ¿a'chī' quilālaktanū'j quina'n? ¿Chā ta'nī'ta' para naquilāmālaksputūyāuj? Quit iclakapasāni'. Hui'x ixla' Dios lā' Santo hui'x. ");
INSERT INTO tooNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Lā' Jesús lacaquilhnīlh huan tlajana' lā' huanilh: ―¡Caquilhca'csla'! ¡Camakxtekti huā'mā' chi'xcu'! ");
INSERT INTO tooNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Lā' huan chi'xcu' xtacnānīlh lā' huan tlajana' palha' ta'salh lā' taxtuni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Lā' ixlīhuākca'n lej talē'cnīlh lā' talākalhasqui'nīlh: ―Lā' ¿tuchū huā'mā' a'ntū quincāmāsu'ni'mā'ni' quina'n? Sāsti' huā'mā'. Huā'mā' chi'xcu' chihuīna'n con līmāpa'ksīn. Hasta huan tlajana'nī'n ta'a'kahuāna'ni' a'xni'ca' xla' cāmāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lā' tuncan a'kahualh chu xalhā nac estado de Galilea ixpālacata a'ntū tlahualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lā' a'xni'ca' Jesús taxtulh de na ixlītokpānca'n israelitas, tuncan a'lh lā' tanūlh na ixchicca'n Simón lā' Andrés. Lā' tatā'a'lh Jacobo lā' Juan. ");
INSERT INTO tooNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lā' ixpuhuiti' Simón ixchi'chīxni'mā' lā' ixmā'. Lā' tuncan māca'tzīnīca Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Lā' xla' a'lh lā' macachi'palh lā' mā'kaquī'lh lā' tuncan tapānūni'lh ixtachi'chīxni'. Lā' tuncan huan puscāt cāmāhuī'lh huan ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Lā' kōtanūtza' a'xni'ca' ixtā'cnūmā'tza' huan chi'chini', cālīmini'ca Jesús ixlīhuākca'n a'ntī ixta'ī'tza'ca'n lā' a'ntī ixtaka'lhī huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Lā' ixlīhuākca'n xalanī'n huan cā'lacchicni' tatakēstokli na ixtanquilhni' huan chic. ");
INSERT INTO tooNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lā' cāmātzeyīlh lhūhua' a'ntī ixta'ī'tza'ca'n de chuxatūyā ta'jatat ixtaka'lhī chā'tunu'. Lā' cāmāxtuni'lh lhūhua' tlajana'nī'n. Lā' tū' cāmakxtekli natachihuīna'n huan tlajana'nī'n como tū' ixlacasqui'n que xlaca'n ixtahualh tichū xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lā' ixlīlakalī lej tzi'sāt Jesús tāquī'lh lā' taxtulh lā' a'lh nac lakatin lugar a'nlhā tintī' ixa'nan. Lā' a'ntza' kalhtō'ka'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Lā' Simón a'lh putza lā' ā'makapitzīn tatā'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lā' a'xni'ca' takaksli Jesús, tahuanilh: ―Ixlīhuākca'n huan tachi'xcuhuī't lej taputzayāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Lā' xla' cāhuanilh: ―Cāhui huan nac ā'makapitzīn cā'lacchicni' a'ntūn tahui'lāna' pajtzu lā' quit na'icmāsu'yu a'ntza' ixtachihuīn Dios. U'tza' iclīminī't. ");
INSERT INTO tooNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Lā' chu xalhā nac estado de Galilea ixmāsu'yu na ixlītokpānca'n israelitas. Lā' cāmāxtulh huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lakchā'lh Jesús kalhatin chi'xcu' a'ntī ixka'lhī ta'jatat a'ntū māmasī quinquinītca'n lā' a'ntū huanican lepra. Xla' tatzokostani'lh Jesús lā' lej squi'ni'lh: ―Palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tooNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Lā' Jesús lakalhu'malh lā' stu'ncli ixmacan lā' xa'malh lā' huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. ");
INSERT INTO tooNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lā' a'xni'ca' huanilh huā'mā', tapānūni'lh ixta'jatat huan ī'tza'ca' lā' tzeyalh. ");
INSERT INTO tooNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lā' a'xni'ca' Jesús macā'lh, stu'tu'lu' huanilh: ");
INSERT INTO tooNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Catamaktaka'lhti lā' tū' tihua'ni'ya' nīn tintī'. Xmān nalakpina' huan ixcuraca'n israelitas lā' namāsu'ni'ya' mimacni' para nalaktzī'n palh tzeyanī'ta'tza'. Lā' na'a'ksa'juī'ni'na' chuntza' hua'chi māpa'ksīni'lh Moisés para a'ntī ixtatzeyanī'ttza' de huanmā' ta'jatat. Chuntza' nacālīmāca'tzīnī'ya' tachi'xcuhuī't que tzeyanī'ta'tza'. ");
INSERT INTO tooNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero xla' tuncan taxtulh lā' tzuculh cāhuanitā'kchoko līlhūhua' lā' cāhuanilh a'ntū ixpātle'keni'nī't. Lā' chuntza' Jesús tūlatza' ixtanū huan nac cā'lacchicni' na ixlacapūnca'n tachi'xcuhuī't, como tū' ixlacasqui'n que lej ixtatakēstokli. Lā' chuntza' xmān tachokolh na ixquilhtūn cā'lacchicni'. Lā' tachi'xcuhuī't xalanī'n lakachu ixtalaka'n. ");
INSERT INTO tooNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lā' ixlīlātma'j Jesús taspi'tli lā' tanūpā huan nac Capernaum. Lā' tachi'xcuhuī't takaxmatli que ixuī' nac chic. ");
INSERT INTO tooNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Lā' tuncan līlhūhua' talaktakēstokli hasta tū'tza' ixtatanūkō' ixchakān huan chic. Lā' nā tatzumalh huan tanquilhni'. Lā' ixcāmāsu'ni' ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Lā' talakmilh ā'makapitzīn lā' na ixlaclhpu'nanca'n kalhatā'ti' chi'xcuhuīn ixtapūlīmimā'na laklaj. Lā' huan nac laklaj ixmā' kalhatin ī'tza'ca' a'ntī lhtuculu' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Lā' como tūlalh talakchā'lh Jesús ixpālacata huan lhūhua' tachi'xcuhuī't a'nlhā ixtzuma huan chic, tapūtō'ca'lh huan escalera lā' ta'a'kstīlhuakli huan chic ixlakstu'nc Jesús. Lā' a'xni'ca' xa'nca tamālaquī'lh, tamāyujūlh huan ī'tza'ca' con ixlaklaj. ");
INSERT INTO tooNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lā' a'xni'ca' Jesús laktzī'lh a'nchī ixtakalhlaka'ī' ixlīmāpa'ksīn, xla' huanilh huan ī'tza'ca': ―Quincaman, icmāsputūnu'ni'kō'ni'tza' ixlīhuāk mintalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lā' ixtakaxmatui'lāna' ā'makapitzīn xamākalhtō'kē'ni'nī'n huan ley lā' tapuhualh ixa'cstuca'n: ");
INSERT INTO tooNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿A'chī' chihuīna'n chuntza' huā'mā' chi'xcu'? Xla' tā'talacastucmā' Dios a'nchī chihuīna'lh. Nīn tintī' tzē naquincāmāsputūnu'ni'yāni' quintalaclē'i'ca'n, xmān Dios”. ");
INSERT INTO tooNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Lā' tuncan Jesús ixa'cstu ca'tzīlh a'nchī xlaca'n ixtapuhuamā'na lā' cāhuanilh: ―Lā' ¿a'chī' puhua'nā'tit chuntza' na mi'a'clhcunucca'n? ");
INSERT INTO tooNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Icuanilhtza' huan ī'tza'ca': “Icmāsputūnu'ni'kō'ni'tza' ixlīhuāk mintalaclē'i'”, pero tuntū' tasu'yu a'yuj māsputūnu'ni'ca. Palh xa'icuanilh: “Catā'kaqui' lā' casmi'li' mixti'cat lā' catlā'hua'”, chuntza' ixtasu'yulh palh natzeyan o tū'. ");
INSERT INTO tooNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Quit huan Chi'xcu' xala' Tālhmā'n. Lā' chuhua'j na'iccāmāsu'ni'yāni' a'nchī icka'lhī līmāpa'ksīn nac huā'mā' cā'quilhtamacuj lā' tzē na'iccāmāsputūnu'ni' ixtalaclē'i'ca'n tachi'xcuhuī't. Lā' tuncan Jesús huanilh huan lhtuculu' chi'xcu': ");
INSERT INTO tooNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Icuaniyāni', catā'kaqui' lā' casmi'li' mixti'cat lā' capit na minchic. ");
INSERT INTO tooNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Lā' tuncan tā'kaqui'lh na ixlacapūnca'n ixlīhuākca'n a'ntī ixtahui'lāna' lā' sacli ī'xti'cat lā' taxtulh. Lā' ū'tza' talīlē'cnīlh ixlīhuākca'n lā' tamācā'tanīlh Dios lā' tahualh: ―Tū' maktin laktzī'nī'ta'uj a'ntū laktzī'uj chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tuncan Jesús a'mpā na ixquilhtūn huan mar. Lā' ixlīhuākca'n tachi'xcuhuī't talaka'lh. Lā' ixcāmāsu'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lā' a'xni'ca' Jesús ixa'mā', tētaxtulh a'nlhā ixmātā'jīni'ncan impuestos lā' laktzī'lh Leví ixo'kxa' Alfeo. Lā' Jesús huanilh: ―Caqui'o'kska'lhi'. Lā' xla' tāyalh lā' stālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Lā' milh lakatin chi'chini' a'xni'ca' Jesús ixuā'yamā' na ixchic Leví. Lā' tachā'lh lhūhua' mātā'jīni'nī'n impuestos lā' ā'makapitzīn a'ntī ixcālakmaka'ncan. Lā' xlaca'n ixcātā'huā'yamā' Jesús lā' ī'sca'txtunu'nī'n como lhūhua' ixtastālani'. ");
INSERT INTO tooNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Lā' a'xni'ca' huan xamākalhtō'kē'ni'nī'n huan ley lā' huan fariseosnu' talaktzī'lh que ixcātā'huā'yan mātā'jīni'nī'n lā' ā'makapitzīn a'ntī ixcālakmaka'ncan, tahuanilh ī'sca'txtunu'nī'n Jesús: ―¿A'chī' cātā'huā'yan Jesús mātā'jīni'nī'n lā' a'ntīn tū' tzeyā chi'xcuhuī'n? ");
INSERT INTO tooNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Lā' a'xni'ca' Jesús kaxmatli huā'mā' tachihuīn, cāhuanilh: ―Huan a'ntīn tū' ta'ī'tza'ca'n, xlaca'n tū' tamaclacasqui'n huan doctor. Xmān huan a'ntīn ta'ī'tza'ca'n tamaclacasqui'n. Quit tū' icmilh iccāputza a'ntīn tapuhuan que xlaca'n xalacuan. Icmilh iccāputza xlaca'n a'ntīn taka'lhī ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lā' ī'sca'txtunu'nī'n Juan lā' huan fariseosnu' a'katunu' ixtalīhui'lī tū' natahuā'yan. Lā' makapitzīn chi'xcuhuīn talakmilh Jesús lā' tahuanilh: ―I'sca'txtunu'nī'n Juan lā' nā ī'sca'txtunu'nī'n huan fariseosnu' a'katunu' talīhui'lī tū' natahuā'yan. Lā' misca'txtunu'nī'n, ¿a'chī' pō'ktu tahuā'yan? ");
INSERT INTO tooNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Lā' Jesús cāhuanilh: ―Xlaca'n a'ntī cākantāyacanī't a'nlhā tapūchahuamā'ca, ¿chā natalīhui'lī tū' natahua' līhua't? Līhuan cātā'lahuī'cus huan squi'nīni', natahuā'yan ixamigos. ");
INSERT INTO tooNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero namin lakatin chi'chini' a'xni'ca' nalē'ncan huan squi'nīni'. Lā' a'xni'ca' namin huanmā' chi'chini', tū' catitahuā'yalh ixamigos porque natalakaputza. Lā' Jesús cāhuanipā: ");
INSERT INTO tooNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","―Huā'mā' a'ntū quit icmāsu'yu, ū'tza' xasāsti'. Lā' palh catīhuā natlōkentaxtū lā' nā tlōkentaxtūcu'tun ixtalanānca'n mixū'yāpapnaca'n, xla' nala hua'chi kalhatin a'ntī nachu'cu xasāsti' lu'xu' para nalīlactza'pa' huan xamasni'. Huan xasāsti' lu'xu' natatimī lā' nastanca xamasni' lā' lhān taxtī'tli más ka'tla' nala. ");
INSERT INTO tooNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Lā' huan xaxcān uva a'ntū tūna'j xcu'tan, nīn tintī' catimojōlh nac xakōlūhua' ixko'xka' borrego. Palh chuntza' ixtlahuaca, ixpankli huan ko'xka' a'xni'ca' naxcu'tan huan xaxcān uva. Namojōcan nac xasāsti' ko'xka'. Lā' a'xni'ca' naxcu'tan, tū' catipankli huan ko'xka'. Chuntza' tū' pāxcat catilalh huan ko'xka' lā' tū' catitaxtuni'lh huan xaxcān uva ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lā' lakatin chi'chini' a'ntū pūjaxcan, Jesús ixcātā'tlā'huantēlha ī'sca'txtunu'nī'n nac lakatin cā'tacuxtu. Lā' xlaca'n tatzuculh ta'ī' macsti'na'j huan trigo. ");
INSERT INTO tooNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Lā' tuncan tahuanilh Jesús huan fariseosnu': ―Cala'ktzi'. Misca'txtunu'nī'n tascujmā'na lā' chuhua'j huan chi'chini' a'ntū pūjaxcan. Chuntza' tū' ta'a'kahuāna'ni' huan ixley Moisés ―tahuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Lā' Jesús cākalhtīlh: ―¿Chā tū' lakapūtlekenī'ta'ntit a'ntūn tlahualh David maktin huā? Xla' lā' a'ntī ixtatā'a'n ixtatzi'ncsa lā' cāsputni'lh līhua't. ");
INSERT INTO tooNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lā' David tanūlh na ixchic Dios. Lā' Abiatar xapuxcu' sacerdote ixuanī't. Lā' David hua'lh huan pāntzi a'ntū ixmālacnūni'canī't Dios. Lā' tū' līmakuan ixua'lh huā'mā' pāntzi. Xmān huan curasna' taka'lhī talacasqui' para natahua'. Lā' nā David cāmaxquī'lh huan chi'xcuhuī'n a'ntī ixta'o'kska'lhī. ");
INSERT INTO tooNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nā Jesús cāhuanilh: ―Dios tlahualh huan chi'chini' a'ntū pūjaxcan por ixpālacataca'n tachi'xcuhuī't lā' tū' tlahualh tachi'xcuhuī't para chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Lā' chuntza' quit huan Chi'xcu' xala' Tālhmā'n lā' nā tzē na'icmāpa'ksī a'ntū natlahuacan huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Lā' Jesús tanūpā na ixlītokpānca'n israelitas. Lā' ixuī' a'ntza' kalhatin chi'xcu' a'ntī ixmacascōhuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Lā' huan tachi'xcuhuī't ixtamaktaka'lhmā'na Jesús a ver palh ixmātzeyīni'lh huanmā' chi'chini' a'ntū pūjaxcan como ixtalē'ksa'nīni'ncu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Lā' Jesús huanilh huan chi'xcu' a'ntī ixmacascōhuanī't: ―Cata't lā' catāya' na quilaclhpu'nanca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Lā' cāhuanilh huan tachi'xcuhuī't: ―¿Tuchū más minī'ni' tlahuacan huan chi'chini' a'ntū pūjaxcan? ¿Chā na'ictlahua a'ntū tzey o a'ntūn tū' tzey? ¿Chā līmakuan na'icmāpūtaxtū huan chi'xcu' o na'icmaknī? Pero xlaca'n ca'cs ixtahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Lā' Jesús cālaktzī'lh ixlīhuākca'n a'ntī ixtalītamacxti'li'nī't lā' ixa'kchā'yā. Lā' Jesús ixlīlakaputzayā como tū' ixtalakalhu'man huan ī'tza'ca' lā' huanilh huan chi'xcu': ―Castu'ncti mimacan. Lā' a'xni'ca' stu'ncli ixmacan, tzeytza' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lā' tuncan huan fariseosnu' tataxtulh lā' tatā'lacchihuīna'lh ixchi'xcuhuī'n Herodes a'nchī natalīmaknī Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pero Jesús a'lh na ixquilhtūn huan lago lā' ī'sca'txtunu'nī'n tatā'a'lh. Lā' lhūhua' tachi'xcuhuī't xalanī'n nac estado de Galilea tastālani'lh Jesús. Lā' a'xni'ca' takaxmatli huāk a'ntū tlahualh Jesús, talakmilh nā xlaca'n xalanī'n nac estado de Judea. ");
INSERT INTO tooNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Lā' xalanī'n nac Jerusalén lā' xalanī'n nac Idumea talakmilh Jesús. Lā' xlaca'n xalanī'n tintacut nac pūxka Jordán lā' xalanī'n pajtzu huan cā'lacchicni' Tiro lā' Sidón nā talakmilh. Lhūhuā' tachi'xcuhuī't talakmilh Jesús a'xni'ca' takaxmatli a'ntūn tlahualh. ");
INSERT INTO tooNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Lā' cāhuanilh ī'sca'txtunu'nī'n que cāxni'j cahui'līlh lakatin barco a'nlhā natojō lā' chuntza' huan lhūhua' tachi'xcuhuī't tūlalh catitapi'ta'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lej lhūhua' ixcāmātzeyīnī't lā' huāk a'ntī ixta'ī'tza'ca'n ixtalaktapajtzū lā' ixtalāpi'ta'mā'na para nataxa'ma Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Lā' a'xni'ca' xlaca'n a'ntī ixtaka'lhī huan tlajana' talaktzī'lh Jesús, xlaca'n tatatzokostani'lh lā' palha' tahualh: ―Hui'x ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero xla' lej cāmāpa'ksīlh lā' cāhuanilh que tū' ixtahualh tichū xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lā' Jesús a'lh nac o'kspū'n lā' cāta'sani'lh a'ntī cālacasqui'lh lā' talakmilh xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Lā' cālacsacli kalhacāujtu' a'ntī natatā'latā'kchoko lā' nacāmaca'n natamāsu'yu ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Lā' nā xlaca'n cāmaxquī'ca līmāpa'ksīn para natamātzeyī chuxatūyā ta'jatat lā' natamāxtu huan tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Huan tamā'na kalhacāujtu': Simón a'ntí hui'līni'ca ixtacuīni' Pedro, ");
INSERT INTO tooNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","lā' nā Jacobo lā' Juan ixtā'tin a'ntī ixo'kxa'n Zebedeo ixtahuanī't lā' xlaca'n cāhui'līni'ca ixtacuīni' Boanerges a'ntū huanicu'tun hua'chi jilini'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Lā' nā Andrés lā' Felipe lā' Bartolomé lā' Mateo lā' Tomás lā' Jacobo ixo'kxa' Alfeo lā' Tadeo lā' Simón. Huā'mā' Simón ixtapa'ksī con huan partido cananistasna'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Lā' Judas Iscariote, xla' a'ntī ā'calīstān macamāstā'lh Jesús. Jesús a'lh na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Lā' tatakēstokpā lej lhūhua' tachi'xcuhuī't hasta tūla ixtahuā'yan Jesús lā' ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lā' a'xni'ca' ixtalakapasnī'n taca'tzīlh huā'mā', xlaca'n talakmilh para natachi'pa como ixtahuan que xla' hua'chilh chuyani' līlalh. ");
INSERT INTO tooNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lā' xamākalhtō'kē'ni'nī'n huan ley a'ntī ixtaminī'ta'ncha' de nac Jerusalén ixtahuan: ―Huan ko'ti'ti', Beelzebú, a'ntī xapuxcu' huan tlajana'nī'n, xla' tanūni'nī't huan Jesús lā' por ixlīmāpa'ksīn ko'ti'ti' tzē cāmāxtu huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lā' Jesús cāta'sani'lh lā' cāhuanilh huan a'ntū lītalacastuca: ―¿Chichū nalīmāxtucan Satanás palh māni' ū'tza' tanūma'? ");
INSERT INTO tooNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Lā' palh huan pūchihuīna'nī'n natatapitzi lā' natalātucsa, tū' catitatāyani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Lā' palh lakatin familia natatapitzi lā' natalātucsa, tū' catitatāyani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Lā' palh Satanás natā'kaquī' contra māni' xla', chuntza' tapitzi lā' tūlalh catitāyani'lh; ka'lhī nasputa. ");
INSERT INTO tooNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nīn tintī' tūlalh catitanūlh para naka'lhāna'n na ixchic kalhatin a'ntī lej tli'hui'qui palh tū' pū'la nachī'can huan ixtēcu' chic. A'xni'ca' chī'hui'līcanī'ttza', a'xni'ca' tzētza' namakka'lhancan. ");
INSERT INTO tooNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Lā' stu'ncua' a'ntū iccāhuaniyāni': Tzē nacāmāsputūnu'ni'can ixlīhuāk ixtalaclē'i'ca'n tachi'xcuhuī't lā' chuxatū tū' tzey a'ntūn tahuan. ");
INSERT INTO tooNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero catīhuā a'ntī nahuan que tū' tzey a'ntūn tlahua huan Espíritu Santo, xla' tūla catimāsputūnu'ni'ca. Xla' naka'lhī ixtalaclē'i' para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús hualh huā'mā' como ixtahuan: “Xla' ka'lhī huan tlajana'”. ");
INSERT INTO tooNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Lā' a'calīstān tachā'lh ixtzī't lā' ixtā'timīn Jesús. Tatāyalh kēpūn lā' māta'satīnīni'nca xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Lā' tachi'xcuhuī't ixtalītaxti'li'nī't lā' tahuanilh: ―Mintzī't lā' mintā'timīn tayāna' kēpūn lā' tatā'chihuīna'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Lā' xla' cākalhtīlh: ―¿Chā ca'tzīyā'tit tichū iccālaktzī'n hua'chilh quintzī't lā' quintā'timīn? ");
INSERT INTO tooNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Lā' ixcālaktzī'nkō' ixlīhuākca'n a'ntī ixtahui'lāna' lā' ixtalītaxti'li'nī't lā' cāhuanilh: ―Huā' tamā'na, ū'tunu'n quintzī't lā' quintā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Lā' ixlīhuākca'n a'ntī natatlahua a'ntū lacasqui'n Dios, ū'tunu'n quintzī't lā' quintā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Lā' tuncan Jesús tzucupā māsu'yu na ixquilhtūn huan mar. Lā' talaktakēstokli lhūhua' tachi'xcuhuī't lā' ū'tza' lītojōlh nac lakatin barco. Lā' tahui'lalh huan nac barco a'ntū ixuī' na ixkalhni' xcān. Lā' ixlīhuākca'n huan tachi'xcuhuī't tatachokolh na ixquilhtūn huan xcān. ");
INSERT INTO tooNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lā' lhūhua' catūhuā ixcālīmāsca'tī huan a'ntū lītalacastuca. Lā' a'xni'ca' ixcāmāsca'tīmā', cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Cakaxpa'ttit. Ixuī' kalhatin cha'nāna' lā' taxtulh para nacha'n huan ixti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Lā' a'xni'ca' ī'xua'ya'maka'mā' huan ti'ni', makapitzīn tayujli nac tej. Lā' tamilh huan spūnnu' lā' tasacua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Lā' ā'makapitzīn tayujli nac cā'chihuixni' a'nlhā tū' pūlhmā'n huan ti'ya't. Lā' palaj pu'nli huā'mā' ti'ni' como tū' pūlhmā'n huan ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Lā' a'xni'ca' chi'chini'lh, scōhualh xachi'tin como tūlalh tā'cnūlh ixtankāxē'k lā' tīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lā' ā'makapitzīn ti'ni' huampala tayujli nac cā'lhtucū'nnu' lā' huan lhtucu'n tastacli lā' tamā'ktzī'lh lā' nīn tuntū' tō'ca'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Lā' ā'makapitzīn ti'ni' tayujli a'nlhā tzey huan ti'ya't lā' pu'nli lā' stacli lā' lana'lh. Lā' makapitzīn ti'ni' tamāstā'lh pu'xamacāuj lā' ā'makapitzīn tamāstā'lh tu'tumpu'xam lā' ā'makapitzīn tamāstā'lh cien. ");
INSERT INTO tooNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Lā' Jesús cāhuanilh: ―Palh kaxpa'tnī'ta'ntit, cuenta catlahua'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Lā' a'xni'ca' ixta'a'nī'ttza' huan lhūhua' tachi'xcuhuī't, xmān tatachokolh Jesús lā' huan kalhacāujtu' lā' ā'makapitzīn huampala. Lā' huan kalhacāujtu' takalhasqui'nīlh ixpālacata huan a'ntū lītalacastuca. ");
INSERT INTO tooNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Lā' Jesús cāhuanilh: ―Dios cāmāsca'tīnī'ta'ni' hui'xina'n a'ntūn tatzē'knī't ixpālacata a'nchī nala ixlīmāpa'ksīn Dios. A'makapitzīn iccālīchihuīna'n xmān a'nchī lītalacastuca. ");
INSERT INTO tooNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Lā' chuntza' natalaktzī'n pero tū' natamāchekxī a'ntū huanicu'tun a'ntūn talaktzī'n. Lā' nā natakaxmata pero tū' catitamāchekxīlh a'ntūn takaxmata. Lā' chuntza' tū' catitaxtāpalīlh huan ixtapāstacna'ca'n lā' tū' caticāmāsputūnu'ni'ca ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Lā' Jesús cāhuanilh: ―Palh tū' māchekxī'yā'tit huā'mā' a'ntū lītalacastuca, tū' caticāmāchekxī'tit ixlīhuāk ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Huan cha'nāna' cha'nli ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lā' a'nlhā yujli huan ti'ni' nac tej, ū'tza' hua'chi tachi'xcuhuī't a'ntīn takaxmatli lā' palaj milh huan ko'ti'ti' lā' cāmāpātza'nkānīlh a'ntū ixtasca'tnī't. ");
INSERT INTO tooNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","’Lā' nā chuntza' a'nlhā yujli huan ti'ni' nac cā'chihuixni', ū'tza' hua'chi a'ntīn takaxmata ixtachihuīn Dios lā' lej talakatī. ");
INSERT INTO tooNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero hua'chi huan ti'ni' a'ntūn tū' ixka'lhī pūlhmā'n ixtankaxē'kca'n, tū' tāyani'lh, nā xlaca'n tū' makān tatāyani'. Tū' xa'nca tamāchekxī huan tachihuīn, lā' a'xni'ca' tapātī catūhuā o a'xni'ca' cāmacaputzacan por ixpālacata a'ntūn takalhlaka'ī'lh, tū'tza' talakatī lā' tamakxtekcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Lā' a'nlhā yujli huan ti'ni' nac cā'lhtucū'n, ū'tza' hua'chi xlaca'n a'ntīn takaxmata huan tachihuīn lā' tamāchekxī. ");
INSERT INTO tooNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero lej tapāstaca a'nchī natalītlaja ixlīhua'tca'n lā' a'nchī lacricosnu' natalīla. Lā' nā lej talacasqui'n lhūhua' catūhuā. Ixlīhuāk huā'mā' cāmāmakchuyī lā' tū' cāmakxteka natapāstaca a'ntūn takaxmatli. Tū'tza' tatasu'yu palh takalhlaka'ī'. Lā' chuntza' huan tamā'na hua'chi huan lhtucū'n a'ntūn tamā'ktzī'lh huan ti'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Lā' a'nlhā yujli huan ti'ni' nac tzey ti'ya't, ū'tza' hua'chi xlaca'n a'ntīn takaxmata huan tachihuīn lā' tamāchekxī lā' xa'nca tatasu'yu palh takalhlaka'ī'. Ixlīhuākca'n taka'lhī a'ntū natalīmāpāxuhuī Dios lā' makapitzīn lej taca'tzī tamāpāxuhuī hua'chi huan ti'ni' a'ntū māstā'lh cien ixtō'ca't. ");
INSERT INTO tooNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Lā' Jesús cāhuanilh: ―Nīn tintī' līmin huan pūmaksko lā' natampīmānū huan chā'xta o na ixtampīn tama'. Hui'līcan nac lakatin mesa o nac lakatin cajón. ");
INSERT INTO tooNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Huāk a'ntūn tatzē'knī't chuhua'j, huāk namālacsu'yukō'can. Lā' a'ntū lakatzē'kcus, ū'tza' naca'tzīkō'can. ");
INSERT INTO tooNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Palh kaxpa'tnī'ta'ntit, cuenta catlahua'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Lā' chuntza' cāhuanilh Jesús: ―Cuenta catlahua'tit a'ntū kaxpa'tā'tit. Palh nalīhui'lī'yā'tit nasca'tā'tit, Dios nacāmaktāyayāni' lā' ā'chulā' nasca'tā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Huan a'ntī cuenta tlahua ixtachihuīn Dios, más namāchekxī. Lā' huan a'ntīn tū' cuenta tlahua, napātza'nkākō' a'ntū kaxmatnī't. ");
INSERT INTO tooNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Lā' Jesús hualh: ―A'nchī Dios cāmāpa'ksīkō' tachi'xcuhuī't, ū'tza' hua'chi a'xni'ca' kalhatin chi'xcu' nacha'n ti'ni' nac ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Xla' nalhtata de tzī'sa lā' natā'kaquī' cā'tzi'sāt. Lā' huan ti'ni' napu'n lā' nastaca lā' xla' tū' ca'tzī chī līpu'nli lā' chī līstacli. ");
INSERT INTO tooNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Huan ti'ya't ixa'cstu māpu'nū; pū'la tasu'yu huan xachi'tin lā' tuncan xaxihuī't lā' ā'calīstān huan tza'ktza'. ");
INSERT INTO tooNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A'xni'ca' scōhualhtza' lā' cuxi'tza' lanī't, tuncan ī'can como chilhtza' huan chi'chini' a'ntū napū'ī'can. ");
INSERT INTO tooNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Lā' Jesús hualh: ―¿Tuchū nahuanāuj para namāsu'yuyāuj a'nchī natalīlhūhua'n a'ntī natakalhlaka'ī' Dios? ¿Chichū nacālīmālacastucāuj a'nchī natalhūhua'n? ");
INSERT INTO tooNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Natalhūhua'n hua'chi lakatin ti'ni' a'ntū huanican mostaza. Huā'mā' ti'ni' līhua'ca' xamactzina'j que ixlīhuākca'n ā'makapitzīn ti'ni' a'ntū cha'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Lā' a'xni'ca' cha'ncanī'ttza', lā' nastaca, lej ka'tla' nala lā' lhūhua' ixpekenī'n naka'lhī. Lā' chuntza' huan spūnnu' tzē natatlahua ixmāsekca'n a'nlhā skē'knin. ");
INSERT INTO tooNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lā' chuntza' ixcālīmāsu'ni' lhūhua' a'ntū lītalacastuca lā' lacatzucu cāmāsu'ni'lh chu a'nchī tzē ixtasca'ta. ");
INSERT INTO tooNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Lā' xmān a'ntū lītalacastuca ixcālītā'chihuīna'n huan tachi'xcuhuī't. Pero a'xni'ca' ixa'cstuca'n xla' lā' ī'sca'txtunu'nī'n, xa'nca ixcāmāstū'ncni' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lā' kōtanūtza' ixuanī't huanmā' chi'chini' lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Cāhuitit tintacut. ");
INSERT INTO tooNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Lā' como Jesús ixuī'cus nac barco, lā' chuntza' talīlē'lh nac barco lā' cāmakxtekli huan lhūhua' tachi'xcuhuī't. Lā' ā'makapitzīn barco nā tatā'a'lh tintacut. ");
INSERT INTO tooNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Lā' līhuan ixtatacutmā'na lej palha' tzuculh ū'nun. Lā' huan xasipej xcān tasno'kli huan barco lā' ixlītatzumamā' de xcān. ");
INSERT INTO tooNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lā' Jesús xtunc ixmā' nac barco lā' ī'lhtatamā' lā' ixa'ktzi'mā' nac lakatin ixa'ktzi'. Lā' tamālakahuanīlh lā' tahuanilh: ―Mākalhtō'kē'ni', tā'cnūmā'nauj lā' hui'x tū' cuenta tlahua'ya'. ");
INSERT INTO tooNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Lā' Jesús tā'kaquī'lh lā' lacaquilhnīlh huan ū'ni' lā' huanilh huan mar: ―Caca'csla' lā' tzē'k cala't. Lā' ca'cslalh huan ū'ni'. Lā' tzē'k tamā'lh huan mar. ");
INSERT INTO tooNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ―¿A'chī' jicua'nā'tit? Tū' lej quilālīpāhuanāuj. ");
INSERT INTO tooNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Lā' lej talē'cnīlh lā' talāhuanilh chā'tunu' de xlaca'n: ―¿Tichūyā chi'xcu' huā'mā'? Hasta cāmāpa'ksī huan ū'ni' lā' huan xasipej xcān lā' ta'a'kahuāna'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Lā' tachā'lh xlaca'n tintacut huan mar nac lakatin ti'ya't a'nlhā huanican Gadara. ");
INSERT INTO tooNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Lā' a'xni'ca' Jesús tacutli de huan barco, tuncan pāxtokli kalhatin chi'xcu' a'ntī taxtulh na ixpu'nan de huan taponkni'. Ixka'lhī huan tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Lā' xla' ixlahuī' nac lhu'cu' a'nlhā ixcāmā'cnūcanī't huan nīnī'n. Nīn tintī' tzē ixchī' lā' a'yuj ixlīchī'can cadenas. ");
INSERT INTO tooNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Maklhūhua' ixtūpixchī'canī't lā' ixmacatūpixchī'canī't con līcā'n lā' cadenas pero xla' lactu'cxli huan cadenas lā' lactzina'j tlahualh huan līcā'n lā' nīn tintī' tzē ixtlaja. ");
INSERT INTO tooNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lā' tzī'sa lā' tuncuj a'nlhā tayāna' lhu'cu' lā' cā'o'kspū'yān pō'ktu ixa'cta'satā'kchoko lā' ixlīmātakāhuī'can chihuix. ");
INSERT INTO tooNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makatcus ixmimā'cha' Jesús a'xni'ca' huan chi'xcu' laktzī'lh lā' laktu'jnulh lā' a'cnīni'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Lā' tā'chihuīna'lh palha' lā' hualh: ―¿A'chī' ta'na' hui'x a'nlhā icuī', Jesús? Hui'x ixO'kxa' Dios xala' tālhmā'n. ¿Chu quit mimaca'tzi? Lej icsqui'ni'yāni' que tū' naquimāpātīnī'ya'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chuntza' ī'squi'ni'mā'ca Jesús como xla' ixuaninī't huan tlajana': ―Cataxtu de huā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Lā' Jesús kalhasqui'nīlh: ―¿Chī mintacuīni'? Lā' xla' kalhtīlh: ―Quihuanican Legión como quina'n lhūhua' tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Lā' lej ixtasqui'ni'mā'na Jesús que tū' cacāmacā'lh makat. ");
INSERT INTO tooNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Lā' lhūhua' pa'xnī'n ixtahuā'yamā'na pajtzu a'ntza' na ixlacapān kēstīn. ");
INSERT INTO tooNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Lā' huan tlajana'nī'n tasqui'ni'lh Jesús: ―Caquilāmacamini'uj huan lhūhua' pa'xni' para que tzē na'ictanūpalayāuj na ixchakānca'n huan tamā'na pa'xni'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Lā' tuncan cāmakxtekli natatanū. Lā' huan tlajana'nī'n tataxtukō'lh de huan chi'xcu' lā' tatanūlh ixchakānca'n huan pa'xni'. Lā' xlaca'n tatu'jnulh nac cā'pūtatonkopūn lā' tatojōcha' nac xcān lā' tajicsua'kō'lh. Lā' hua'chi lakatu' mil pa'xnī'n ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Lā' huan chi'xcuhuī'n a'ntī ixtamaktaka'lhmā'na huan pa'xnī'n lā' tatzā'lalh lā' tamāca'tzīnīni'lh nac cā'lacchicni' lā' pajtzu huanmā' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lā' a'xni'ca' ā'makapitzīn tachā'lh a'nlhā ixuī' Jesús, xlaca'n talaktzī'lh huan chi'xcu' a'ntīn tū'tza' ixka'lhī huan tlajana'nī'n. Lā' xla' tzē'k ixuī' lā' ixlhakā'nanī'ttza'. Lā' xlaca'n tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Lā' huan a'ntī ixtalaktzī'nī't tahuanilh a'ntū ixpātle'keni'nī't huan chi'xcu' a'ntī ixka'lhīnī't huan tlajana'nī'n lā' nā a'ntū ixcāpātle'keni'nī't huan pa'xnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Lā' tuncan tatzuculh tasqui'ni' Jesús que nataxtu de a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Lā' a'xni'ca' Jesús ixtojōmā' huan nac barco, milh huan chi'xcu' a'ntī ixka'lhīnī't huan tlajana'nī'n lā' squi'ni'lh camakxtekli que natā'a'n. ");
INSERT INTO tooNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús tū' makxtekli natā'a'n lā' huanilh: ―Cataspi'tti' na minchic lā' nacāhua'ni'kō'ya' mifamilia lā' mi'amigos huanmā' laka'tla'n catūhuā a'ntū huan Māpa'ksīni' tlahuani'nī'ta'ni' lā' a'nchī lakalhu'manī'ta'ni' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Huan chi'xcu' a'lh lā' lakachu nac cā'lacchicni' a'nlhā huanican Decápolis xla' tzuculh līchihuīna'n a'ntū Jesús tlahuani'lh. Lā' ixlīhuākca'n huan tachi'xcuhuī't talē'cnīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Lā' a'xni'ca' Jesús pūtacutchokopā tintacut nac barco, talaktakēstokli lhūhua' tachi'xcuhuī't a'nlhā xla' ixuī' pajtzu nac mar. ");
INSERT INTO tooNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Lā' milh kalhatin xapuxcu' de ixlītokpānca'n israelitas lā' ixtacuīni' Jairo. Lā' a'xni'ca' laktzī'lh Jesús, tatzokostani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Lā' lej squi'ni'lh lā' huanilh: ―Quintzu'ma'jāt nīmā'tza'. Cata't lā' namacaxa'ma'ya' para que natzeyan lā' nalatahui'lapala. ");
INSERT INTO tooNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Lā' Jesús tā'a'lh. Lā' ixtastālani' lhūhua' tachi'xcuhuī't lā' ixtalāpi'ta'tēlha. ");
INSERT INTO tooNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Lā' na ixlaclhni'ca'n ixuī' kalhatin puscāt a'ntī ixī'tza'can. Ixka'lhītza' lakacāujtu' cā'ta tūla ixcāsni' ixka'lhni'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lā' lhūhua' doctornu' ixtamāpātīnīnī't lā' ixmakasputkō'nī'ttza' ixtumīn lā' nīn tuntū' macuani'lh pero ā'chulā' ixlamā'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ixkaxmatnī't a'nchī ixtlahua Jesús lā' laktapajtzūlh na ixkēn na ixlaclhni'ca'n lhūhua' tachi'xcuhuī't lā' xa'malh ixlu'xu'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chuntza' tlahualh como puhualh: “Xmān ca'icxa'malh ixlu'xu' lā' na'ictzeyan”. ");
INSERT INTO tooNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lā' chuntza' chu tuncan tzeyalh. Lā' u'cxca'tzīlh na ixmacni' que ixtzeyanī'ttza' de ixta'jatat. ");
INSERT INTO tooNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lā' tuncan Jesús u'cxca'tzī'lh a'nchī ixlīmātzeyīni'nī't ixlīmāpa'ksīn. Cālaktalakspi'tli huan tachi'xcuhuī't lā' cāhuanilh: ―¿Tichū xa'malh quilu'xu'? ");
INSERT INTO tooNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lā' tahuanilh ī'sca'txtunu'nī'n: ―Laktzī'na' a'nchī lhūhua' tachi'xcuhuī't tapi'ta'yāni'. Lā' ¿a'chī' hua'na'?: “¿Tichū quixa'malh?” ");
INSERT INTO tooNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Lā' xla' lakachu ixlacaputza para nalaktzī'n a'ntī ī'xa'manī't. ");
INSERT INTO tooNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Lā' huan puscāt ixca'tzī a'ntū ixpātle'keni'nī't māni' ū'tza' lā' a'nchī ixtzeyanī'ttza' lā' xla' ixjicua'n. Lā' ixpipitēlha laka'lh lā' tatzokostani'lh Jesús lā' huanikō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Lā' xla' huanilh: ―Quintzu'ma'jāt, tzeyanī'ta' como kalhlaka'ī'nī'ta'. Capit lā' Dios calē'n. Tzeyanī'ta' de minta'jatat. ");
INSERT INTO tooNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ixchihuīna'mā'cus Jesús a'xni'ca' tamilh makapitzīn de na ixchic Jairo. Lā' tahuanilh Jairo: ―Mintzu'ma'jāt nīlhtza'. ¿A'chī' māmakchu'yī'ya'cus huan mākalhtō'kē'ni'? ");
INSERT INTO tooNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús tū' cuenta cātlahuani'lh a'ntū ixtahuan. Lā' huanilh huan xapuxcu' de huan lītokpān: ―Tū' caji'cua', xmān cakalhlaka'i'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Lā' Jesús tū' makxtekli nīn tintī' nastālani', xmān Pedro lā' Jacobo lā' Juan ixtā'tin Jacobo. ");
INSERT INTO tooNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ta'a'lh na ixchic huan xapuxcu' ixlītokpānca'n israelitas. Lā' a'xni'ca' tachā'lh, Jesús laktzī'lh lhūhua' tachi'xcuhuī't. Lā' ixtacalhuamā'na lā' ixtata'samā'na. ");
INSERT INTO tooNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lā' Jesús a'xni'ca' tanūlh, cāhuanilh: ―¿A'chī' ta'sayā'tit lā' calhua'nā'tit? Huan tzu'ma'jāt tū' nīnī't, xmān lhtatamā'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Lā' xmān talīlītzī'nli. Lā' a'xni'ca' Jesús cāmāxtukō'lh ixlīhuākca'n, cālē'lh ixtāta' huan tzu'ma'jāt lā' ixtzī't lā' a'ntī ixtatā'minī't. Lā' tatanūlh a'nlhā ixmā' huan tzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Lā' macachi'palh huan tzu'ma'jāt lā' huanilh: ―Talita cumi ―huā'mā' tachihuīn huanicu'tun: Tzu'ma'jāt, icuaniyāni' catā'kaqui'. ");
INSERT INTO tooNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Lā' chu tuncan tā'kaquī'lh huan tzu'ma'jāt lā' xla' ixlatlā'huan como ixka'lhī lakacāujtu' cā'ta. Lā' huan tachi'xcuhuī't talē'cnīlh lā' lej tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Lā' Jesús lej stu'tu'lu' cāhuanilh que nīn tintī' ixtamāca'tzīnīlh lā' cāhuanilh: ―Camā'huī'tit huan tzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Lā' Jesús taxtulh de a'ntza' lā' a'lh na ixā'lacchicni' a'nlhā ī'stacnī't lā' tastālani'lh ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lā' a'xni'ca' chilh huan chi'chini' a'ntū pūjaxcan, tanūlh na ixlītokpānca'n israelitas lā' tzuculh māsu'yu. Lā' lhūhua' tachi'xcuhuī't a'ntīn takaxmatli lā' talē'cnīlh lā' tahualh: ―¿Lhachū sca'tli huā'mā' chi'xcu' huan tamā'na catūhuā? Lā' ¿tuchūyā tapāstacna' maxquī'canī't? Lā' ¿chichū tzē lītlahua huan tamā'na? ");
INSERT INTO tooNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","U'tza' huā'mā' huan sitni' lā' María ixtzī't. Lā' nā xla' ixpuxcu'ca'n Jacobo lā' José lā' Judas lā' Simón. Lā' tahui'lāna' huā'tzā' xanastancunu' puscan. Lā' ta'a'kchā'lh por ixpālacata lā' talakmaka'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero xla' cāhuanilh: ―Kalhatin a'cta'sana' na'a'cnīni'ni'can chuxalhā na'a'n. Xmān xalanī'n na ixā'lacchicni' lā' ixfamiliares tū' ta'a'cnīni'ni'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Lā' a'ntza' na ixā'lacchicni' Jesús tūlalh tlahualh lē'cnīn. Xmān cāxa'malh makapitzīn ī'tza'ca'nī'n lā' cāmātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lā' Jesús lej lē'cnīlh como tū' ixtakalhlaka'ī' ixlīmāpa'ksīn. Lā' ixmāsu'yutēlha nac lakatunu' lacti'na'j cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lā' Jesús cāmāta'sīlh huan kalhacāujtu' ī'sca'txtunu'nī'n lā' tzuculh cāmacā'n kalhatu'yūn lā' cāmaxquī'lh līmāpa'ksīn para natamāxtu huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Lā' cāhuanilh: ―Tū' tilī'pinā'tit nīn tuntū' huan nac tej, nīn morralh, nīn pāntzi, nīn tumīn na mimbolsaca'n. Xmān nalī'pinā'tit mimpāla'cca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Lā' natatūnū'yā'tit mihuarachica'n pero tū' nalhakā'yā'tit kalhtu' milu'xu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Lā' Jesús cāhuanipā: ―Chuxatūya chic a'nlhā nachipinā'tit, a'ntza' natachokoyā'tit hasta a'xni'ca' nataxtuyā'tit de huanmā' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Lā' palh calhāhuā tū' cātamānūyāni' nac chakān chic lā' palh tū' cātakaxmatni'cu'tunāni' a'ntū hua'nā'tit, cataxtutit de huanmā' cā'lacchicni'. Lā' a'xni'ca' nataxtuyā'tit, catincxtit mintojonca'n para que nayuja huan pokxni' na ixlakxtampūn mintojonca'n. Chuntza' nalīmāsu'yu'yā'tit que xlaca'n natalē'n cuenta como tū' takaxmatcu'tulh. Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Lā' a'xni'ca' namin huan chi'chini' a'xni'ca' Dios nalacāxtlahuakō', xlaca'n lej natapātīni'n como tū' takaxmatcu'tulh. A'chulā' natapātīni'n xlaca'n que huan tū' tzeyā tachi'xcuhuī't xalanī'n nac Sodoma lā' Gomorra ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ta'a'lh huan sca'txtunu'nī'n lā' ixtamāsu'ni' tachi'xcuhuī't que tasqui'nī nataxtāpalī ixtapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lā' tamāxtulh lhūhua' tlajana'nī'n. Lā' ixcālīmūtlahua aceite lhūhua' ī'tza'ca'nī'n lā' cāmātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Lā' huan rey Herodes kaxmatli ixpālacata Jesús como lhūhua' a'ntī ixtalīchihuīna'mā'na Jesús lā' a'ntū ixtlahua. Lā' Herodes hualh: ―Juan a'ntī ixmā'kpaxīni'n lakahuanchokonī't de huan līnīn. U'tza' līka'lhī līmāpa'ksīn a'ntū lītlahua huan lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lā' makapitzīn ixtahuan: ―U'tza' Elías a'ntī ixa'cta'sana' Dios xala' makāntza'. Lā' ā'makapitzīn ixtahuampala: ―U'tza' a'cta'sana' hua'chi huan xala' makāntza'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Lā' a'xni'ca' huanica Herodes a'ntū tlahualh Jesús, xla' hualh: ―U'tza' Juan a'ntī icmā'a'cchu'cunīni'lh. Xla' lakahuanchokonī't lā' taxtulh na ixlaclhni' nīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Huan Herodes māni' ū'tza' māpa'ksīlh lā' māchi'panīni'lh Juan lā' māchī'nīni'lh nac pūlāchī'n por ixpālacata Herodías a'ntī ixpuscāt Felipe ixuanī't. Lā' huā'mā' Felipe ixtā'tin Herodes. Lā' Herodes ixtā'tahui'lanī't huanmā' puscāt. ");
INSERT INTO tooNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Lā' Juan ixuaninī't Herodes: ―Tū' līmakuan a'nchī tā'tō'la'nī'ta' ixpuscāt mintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","U'tza' Herodías līlalh ixtā'ca'tza Juan lā' ixmaknīcu'tun. Lā' tūla ixmaknī ");
INSERT INTO tooNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porque Herodes ixjicua'ni' Juan. Ixca'tzī que lej tzeyā chi'xcu' ixuanī't Juan lā' līlacatejtin ixlatlā'huan. Lā' Herodes tū' makxtekli Herodías natlahuani' Juan nīn tuntū'. Lā' a'yuj Herodes māmakchuyīlh ixpālacata a'ntū māsu'yulh Juan, pero ixkaxmatcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero milh lakatin chi'chini' a'xni'ca' Herodías tlahualh a'ntū ixtlahuacu'tun. Herodes tlahualh ixcā'tani' a'xni'ca' chā'lh ixcā'ta. Cākantāyalh para nacātā'huā'yan na ixchic xanapuxcu'nu' lā' xamāpa'ksīni'nī'n lā' generales a'ntī ixtatā'scuja nac estado de Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Lā' ixtzu'ma'jāt Herodías tanūlh lā' lu'cxli lā' cāmakapāxuhualh Herodes lā' a'ntī ixcākantāyacanī't. Lā' huan rey huanilh huan tzu'ma'jāt: ―Caquisqui'ni' chu a'ntū lacasqui'na' lā' quit na'icmaxquī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lā' stu'tu'lu' huanilh: ―Lej stu'ncua' a'ntū icuanini'. Na'icmaxquī'yāni' a'ntū naquisqui'ni'ya' a'yuj i'tāt a'nlhā quit icmāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Lā' huan tzu'ma'jāt taxtulh lā' kalhasqui'nīlh ixtzī't: ―¿Tuchū na'icsqui'n? Lā' xla' huanilh: ―Nasqui'na' ixa'kxāk Juan huan Mā'kpaxīni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lā' huan tzu'ma'jāt tuncan tanūlh a'nlhā ixuī' huan rey lā' hualh: ―Iclacasqui'n ixa'kxāk Juan huan Mā'kpaxīni'. Chuhua'j tuncan naquimaxquī'ya' nac lakatin pulātu. ");
INSERT INTO tooNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Lā' ū'tza' lej līlakaputzalh huan rey pero como stu'tu'lu' ixuanicanī't huan tzu'ma'jāt lā' como huan a'ntī ixcākantāyacanī't takaxmatli a'ntū ixuanicanī't, tūlalh xtāpalīlh ixtachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lā' tuncan huan rey māpa'ksīlh kalhatin mayūlh para nalīmin ixa'kxāk Juan. Lā' xla' a'lh nac pūlāchī'n lā' a'cchu'culh. ");
INSERT INTO tooNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Lā' līminca ixa'kxāk nac lakatin pulātu lā' maxquī'ca huan tzu'ma'jāt. Lā' huan tzu'ma'jāt maxquī'lh ixtzī't. ");
INSERT INTO tooNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Lā' a'xni'ca' cāmācatzīnīca ī'sca'txtunu'nī'n Juan, xlaca'n tamilh lā' tasacli ixmacni' lā' tamā'cnūlh nac lakatin taponkni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lā' a'xni'ca' ī'sca'txtunu'nī'n Jesús talaktaspi'tli, tahuanikō'lh huāk a'ntū ixtatlahuanī't lā' a'ntū ixtamāsu'yunī't. ");
INSERT INTO tooNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lā' Jesús cāhuanilh: ―Cata'ntit xmān hui'xina'n lā' caquilātā'miuj a'nlhā nīn tintī' a'nan lā' najaxāujtit macsti'na'j. Lej lhūhua' tachi'xcuhuī't ixtaquīlakla Jesús lā' chuntza' ī'sca'txtunu'nī'n tūla ixtahuā'yan. ");
INSERT INTO tooNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Lā' tatojōlh nac lakatin barco xmān xlaca'n lā' ixta'a'mā'na a'nlhā tintī' ixa'nan. ");
INSERT INTO tooNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Lā' lhūhua' tachi'xcuhuī't talaktzī'lh a'xni'ca' ixta'a'mā'na lā' talakapasli. Lā' xalanī'n lakatunu' cā'lacchicni' catojon tatu'jnulh a'ntza' lā' tachā'lh pū'la. ");
INSERT INTO tooNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lā' a'xni'ca' Jesús taxtulh de huan barco, cālaktzī'lh lhūhua' tachi'xcuhuī't lā' cālakalhu'malh como tatasu'yulh hua'chi borregos a'ntūn tū' ixtaka'lhī a'ntī nacāmaktaka'lha. Lā' tzuculh cāmāsu'ni' lhūhua' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Lā' a'xni'ca' ī'smalanka'namā', huan sca'txtunu'nī'n talakmilh Jesús lā' tahuanilh: ―Kōtanūtza' lā' huā'tzā' tū' nac cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cacāmacapi huan tachi'xcuhuī't para que nata'a'n natatamāhua ixlīhua'tca'n nac cā'ranchujnu' lā' nac cā'lacchicni' como tū' taka'lhī a'ntū natahua' xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Jesús cākalhtīlh: ―Hui'xina'n cacāmāhuī'tit. Lā' tahuanilh: ―Lej lhūhua' huan tachi'xcuhuī't. Lā' tasqui'nī lej makān namakscujcan lā' chuntza' tzē nalītamāhuacan pāntzi a'ntū na'iccāmāhuī'yāuj xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Lā' Jesús cāhuanilh: ―¿Lhā maclā't pāntzi ka'lhī'yā'tit? Caquīlaktzī'ntit. Lā' taquīlaktzī'lh lā' a'xni'ca' taca'tzīlh, tahuanilh: ―Macquitzis pāntzi lā' tantu' squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Lā' xla' cāmāpa'ksīlh ī'sca'txtunu'nī'n: ―Cacāmālacpitzitit lā' xtuncnu' catatahui'lh pūlacatunu' nac cā'seketni'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Lā' ixa'nan pūlacatunu' a'nlhā tatahui'lh lakatin ciento. Lā' nā ixa'nan ā'makapitzīn pūlacatunu' a'nlhā tatahui'lh tu'pu'xamacāuj. ");
INSERT INTO tooNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Lā' Jesús cātayalh huan macquitzis pāntzi lā' huan tantu' squī'ti' lā' talacayāhualh nac a'kapūn lā' maxquī'lh pāxcatca'tzī Dios lā' che'kelh huan pāntzi lā' cāmaxquī'lh ī'sca'txtunu'nī'n. Lā' xlaca'n tamālacpitzini'lh na ixlaclhni'ca'n tachi'xcuhuī't. Lā' nā cāmālacpitzini'lh huan tantu' squī'ti' ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Lā' tahua'lh ixlīhuākca'n lā' taka'sli. ");
INSERT INTO tooNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lā' a'xni'ca' tahuā'yankō'lh, tamākēstokli huan sca'txtunu'nī'n xalacpītzin pāntzi lā' squī'ti'. Lā' lītatzumalh pācāujtu' cha'xta a'ntū a'katāxtūni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lā' a'ntīn tahuā'yalh lakaquitzis mil chi'xcuhuī'n ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lā' chu tuncan Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Catojō'tit nac barco lā' capū'la'tit tintacut huan mar para nac Betsaida līhuan quit na'iccāmacā'n huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Lā' a'xni'ca' ixcāmacā'nkō'nī'ttza', xla' a'lh huan nac kēstīn para nakalhtō'ka'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lā' a'xni'ca' tā'cnūlh huan chi'chini', Jesús ixa'cstu ixuī' nac ti'ya't līhuan ī'sca'txtunu'nī'n ixta'a'mā'na nac barco ixpu'nan mar. ");
INSERT INTO tooNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Lā' Jesús laktzī'lh a'nchī tūlalh xa'nca ixa'n huan barco como lej ixū'numā'. Lā' a'xni'ca' ixtuncuīni'mā'tza', Jesús cālakmilh. Lā' ixtlā'huantēlha na ixkalhni' huan xcān lā' ixcātēlakataxtumā'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Lā' xlaca'n talaktzī'lh lā' tajicua'lh lā' tata'salh. Como ixlīhuākca'n talaktzī'lh catīhuā ixkalhtlā'huantēlha huan xcān, tapuhualh ixtalakachuyamā'na lā' ū'tza' lej talījicua'lh. Lā' chu tuncan Jesús cātā'chihuīna'lh xlaca'n lā' cāhuanilh: ―Huixcāna'j caca'tzītit lā' tū' cajicua'ntit. Quit a'ntī icmimā'. ");
INSERT INTO tooNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lā' tojōlh nac barco a'nlhā ixtahui'lāna' xlaca'n lā' ca'cslalh huan ū'ni'. Lā' xlaca'n lej talē'cnīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Lā' a'yuj ixtalaktzī'nī't a'nchī Jesús mālhuhuīlh huan pāntzi, lā' tū' ixtamāchekxī tichū Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lā' a'xni'ca' Jesús lā' ī'sca'txtunu'nī'n ta'a'lh tintacut huan xcān, lā' tachā'lh huan nac ti'ya't a'nlhā huanican Genesaret lā' tachī'jūlh ixbarcoca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Lā' a'xni'ca' tataxtulh de nac barco, huan tachi'xcuhuī't talakapasli Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Lā' palaj ta'a'lh lakachu lā' tzucuca cālīmincan ī'tza'ca'nī'n nac laclajna'. Cālē'nca chu a'nlhā huanca que ixuī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Lā' chu calhāhuā tanūlh nac lacti'na'j cā'lacchicni' lā' nac xcānsipejni' lā' cā'ranchujnu', ixcāmāpī'can huan ī'tza'ca'nī'n nac lītamāuj lā' ī'squi'ni'can Jesús que cacāmakxtekli xmān taxa'ma ixtampān ixlu'xu'. Lā' ixlīhuākca'n a'ntīn taxa'malh ixlu'xu' tatzeyankō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lā' talaktakēstokli Jesús fariseosnu' lā' xamākalhtō'kē'ni'nī'n huan ley xalanī'n nac Jerusalén a'ntī ixtalakminī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ixtalaktzī'nī't makapitzīn ī'sca'txtunu'nī'n Jesús a'ntī ixtahuā'yamā'na lā' tū' xa'nca ixtamakacha'ka'nī't pū'la. ");
INSERT INTO tooNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tū' chuntza' ixtatlahua huan fariseosnu' lā' ixlīhuākca'n huan ā'makapitzīn israelitas. Palh xlaca'n tū' pū'la ixtamakacha'ka'n chu a'nchī tasqui'nī, tū' ixtahuā'yan como ixta'a'cnīni'ni' ixtalanānca'n ī'xū'yāpapna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Lā' a'xni'ca' ixtaquītaspi'ta de nac lītamāuj, tū' ixtahuā'yan palh tū' xa'nca ixtamakacha'ka'n pū'la. Lā' ixtatlōkentaxtū lhūhua' ixtalanānca'n ī'xū'yāpapna'ca'n hua'chi a'nchī talīpūche'kē' vasos lā' xālu lā' tamacatzucun de līcā'n lā' ī'xti'catca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Lā' takalhasqui'ni'lh Jesús huan fariseosnu' lā' huan xamākalhtō'kē'ni'nī'n ley: ―¿A'chī' misca'txtunu'nī'n tū' tatlōkentaxtū a'ntū quixū'yāpapna'ca'n quincātamāsu'ni'n? Chu tahuā'yan lā' tū' pū'la tamakacha'ka'n a'nchī tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Lā' Jesús cākalhtīlh: ―Hui'xina'n tlahua'yā'tit lakatu' milacanca'n. Mimpālacataca'n lītzo'kli huan profeta Isaías a'nlhā tatzo'kni': Huā' tamā'na tachi'xcuhuī't xmān tahuan palh quinta'a'cnīni'ni' pero tū' tapāstaca a'ntū iccālīmāpa'ksīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chu tlakaj quintamācā'tanī como a'ntūn tamāsu'yu hua'chilh quilīmāpa'ksīn, ū'tza' xmān ixtapuhuānca'n huan chi'xcuhuī'n. Chuntza' tzo'kli Isaías. ");
INSERT INTO tooNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Lā' Jesús cāhuanipā: ―Lā' hui'xina'n mākēnū'yā'tit ixlīmāpa'ksīn Dios para natlōkentaxtūyā'tit ixtalanānca'n mixū'yāpapna'ca'n. Hui'xina'n pūche'kē'yā'tit xālusnu' lā' vasosnu' a'nchī tasqui'nī lā' tlahua'yā'tit lhūhua' ā'makapitzīn talanān. ");
INSERT INTO tooNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lā' nā cāhuanilh: ―Puhua'nā'tit que tzey a'nchī mākēnū'yā'tit ixlīmāpa'ksīn Dios para natlōkentaxtūyā'tit mintalanānca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","A'nlhā tzo'kli Moisés, chuntza' hualh: Cacā'a'cnīni'ni' mintāta' lā' mintzī't. Lā' Moisés nā hualh: Camāmaknīnīni'nca huan a'ntīn tamacapūlhca ixtāta' o ixtzī't. ");
INSERT INTO tooNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero hui'xina'n xtunc hua'nā'tit. Lā' hui'xina'n māsu'yu'yā'tit palh kalhatin chi'xcu' tzē nahuani ixtāta' o ixtzī't: “Tūla icmaktāyayāni' porque ixlīhuāk a'ntū icka'lhī, ū'tza' Corbán” ―huā'mā' tachihuīn huanicu'tun: icmālacnūni'nī'ttza' Dios―. ");
INSERT INTO tooNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lā' chuntza' tū' makxtekā'tit nacāmaktāya ixtāta' lā' ixtzī't. ");
INSERT INTO tooNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hui'xina'n mākēnū'yā'tit ixlīmāpa'ksīn Dios como māsu'yu'yā'tit que tasqui'nī natlōkentaxtūcan ixtalanānca'n mixū'yāpapna'ca'n. Lā' lhūhua' ā'catūhuā tlahua'yā'tit hua'chi huan tamā'na ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Lā' Jesús cāmāta'sīlh huan tachi'xcuhuī't lā' cāhuanilh: ―Caquilākaxmatui milīhuākca'n lā' camāchekxī'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tū' a'nan nīn tuntū' a'ntū naquilhtanū huan chi'xcu' hua'chi līhua't lā' chuntza' nalīka'lhī ixtalaclē'i'. Pero a'ntū naquilhtaxtu de kalhatin chi'xcu' hua'chi tū' tzey tachihuīn, ū'tza' nalīka'lhī ixtalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Cuenta catlahua'tit a'ntū kaxpa'tā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Lā' a'xni'ca' Jesús ixtanūnī't nac chic, tū'tza' ixa'nan lhūhua' tachi'xcuhuī't. Lā' ī'sca'txtunu'nī'n takalhasqui'nīlh tuchū ixuanicu'tun huan a'ntū lītalacastuca. ");
INSERT INTO tooNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Lā' Jesús cāhuanilh: ―Nā hui'xina'n ¿chā tū' māchekxī'yā'tit? Ca'tzīyā'tit que chuxatū a'ntū naquilhtanū kalhatin chi'xcu', xla' tū' catilīlalh ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","U'tza' xmān tanū na ixpān lā' chuntza' taxtu. Tū' catitanūlh na ixtapāstacna'. Chuntza' līmāsu'yulh que huāk tzey a'ntū hua'yāuj. ");
INSERT INTO tooNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Lā' Jesús huampā: ―A'ntū quilhtaxtu kalhatin chi'xcu', ū'tza' ko'hua'jua' nalīla. ");
INSERT INTO tooNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Palh tū' tzey ixtapāstacna' kalhatin chi'xcu', xla' napuhuan a'ntūn tū' tzey. Lā' ū'tza' nalīmakpuscātīni'n lā' nalītlahua talākalhī'n lā' nalīmaknīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Lā' naka'lhāna'n lā' naka'lhīcu'tun a'ntū ixla' ā'chā'tin lā' natlahua a'ntūn tū' tzey. Lā' natampi'lhīni'n lā' na'a'kxokonu'n lā' natlahua a'ntūn ko'hua'jua' lā' nalakca'tzana'n lā' na'a'ksa'nan lā' lej naka'tla'jca'tzī lā' tū' tzey ixtapāstacna' naka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Huāk huā' tamā'na tū' tzey lā' tamātlahuī ko'hua'jua' kalhatin chi'xcu'. Nā huā' tamā'na tataxtu de ixchakān kalhatin chi'xcu' como tū' tzey ixtapāstacna' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Lā' a'xni'ca' Jesús huankō'lh, xla' taxtulh lā' a'lh ā'lacatin a'nlhā tahui'lāna' huan lakatu' cā'lacchicni' a'ntū huanican Tiro lā' Sidón. Lā' tanūlh nac lakatin chic. Ixlacasqui'n que nīn tintī' ixca'tzīlh que ixuī' a'ntza' pero tūlalh tatzē'kli. ");
INSERT INTO tooNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tuncan milh kalhatin puscāt. Lā' ixtzu'ma'jāt huan puscāt ixka'lhī huan tlajana'. Lā' como māca'tzīnīca que ixchinī't Jesús, lakmilh lā' tatzokostani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Lā' huan puscāt tū' israelita ixuanī't; xla' sirofenicia ixuanī't. Lā' lej ī'squi'ni' talakalhu'mān que camāxtuni'lh ixtzu'ma'jāt huan tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús huanilh: ―Pū'la cataka'sli huan camana'. Tū' līmakuan maklhtīcan ixpāntzica'n huan camana' lā' nacāmaxquī'can huan chichīn. ");
INSERT INTO tooNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Lā' huan puscāt kalhtīlh: ―Stu'ncua', Māpa'ksīni'. U'tza' icca'tzī. Pero huan chichīn tzēn tasacua' ixkalhspulamca'n camana' na ixtampīn mesa. ");
INSERT INTO tooNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Lā' tuncan Jesús huanilh: ―Xa'nca māchekxī'ya'. Tzētza' napina' na minchic. Huan tlajana' taxtuni'lhtza' mintzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Lā' huan puscāt a'lh na ixchic. Lā' ixtzu'ma'jāt ixmā' nac tama' lā' ixtasu'yutza' que huan tlajana' ixtaxtuni'nī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lā' Jesús taxtulh de nac cā'lacchicni' a'ntū huanican Tiro lā' tētaxtulh nac Sidón lā' a'nlhā ixmāpa'ksī Decápolis. Lā' taspi'tli huan nac mar a'ntū huanican Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Lā' līmini'ca kalhatin chi'xcu' a'ntīn tū' ixa'kahuāna'n lā' tūla ixchihuīna'n xa'nca. Lā' lej squi'ni'ca que caxa'malh. ");
INSERT INTO tooNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Lā' Jesús lē'lh lacachuna'j huan chi'xcu' de a'nlhā ixtatakēstoka tachi'xcuhuī't lā' mānūni'lh ixmakspulh na ixa'ka'xko'lh. Lā' chojmanīlh ixmacan lā' nā xa'malh na ī'sī'makā't huan chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Lā' Jesús talacayāhualh nac a'kapūn. Pānīlh lā' hualh: ―¡Efata! ―huā'mā' tachihuīn huanicu'tun: ¡Catalaquī'lh! ");
INSERT INTO tooNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Lā' chu tuncan tatzeyalh ixa'ka'chakān huan chi'xcu' lā' kaxmatli. Lā' tzeyalh ī'sī'makā't lā' tzētza' ixchihuīna'n xa'nca. ");
INSERT INTO tooNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Lā' Jesús stu'tu'lu' cāhuanilh huan tachi'xcuhuī't: ―Nīn tintī' tihua'ni'yā'tit. Pero tū' ta'a'kahuāna'ni'lh, lā' ā'chulā' tamāca'tzīnīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lā' xlaca'n a'ntī cāmāca'tzīnīca lej ixtalē'cnī lā' tahualh: ―Huāk a'ntū tlahuanī't, huāk tzey. U'tza' cāmā'a'kahuanī a'ntī sordo lā' cāmāchihuīnī a'ntī kō'ko'. ");
INSERT INTO tooNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lā' huā' tamā'na chi'chini' ixtatakēstoknī't huan tachi'xcuhuī't lā' tū' ixa'nan a'ntū natahua'. Lā' Jesús cāta'sani'lh ī'sca'txtunu'nī'n lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Iccālakalhu'man huan tachi'xcuhuī't. Tu'tuma'jtza' quintatā'lahui'lāna' huā'tzā' lā' tū'tza' taka'lhī a'ntūn tahua'. ");
INSERT INTO tooNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Lā' palh xa'iccāmacā'lh na ixchicca'n lā' tū' tahuā'yanī't, lej ixtaxlejua'nalh nac tej lā' tū' ixtatāyani'lh. Lā' makapitzīn de xlaca'n taminī'ta'ncha' lej makat. ");
INSERT INTO tooNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lā' ī'sca'txtunu'nī'n takalhtīlh: ―Lā' ¿chichū nacālīmāhuī'yāuj huan tachi'xcuhuī't huā'tzā' a'nlhā tintī' lahuī'? ");
INSERT INTO tooNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Lā' xla' cākalhasqui'nīlh: ―¿Lhā maclā't pāntzi ka'lhī'yā'tit? Lā' xlaca'n takalhtīlh: ―Mactojon. ");
INSERT INTO tooNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Lā' tuncan Jesús māpa'ksīlh catatahui'lalh huan tachi'xcuhuī't nac ti'ya't. Lā' cātayalh huan mactojon pāntzi lā' maxquī'lh pāxcatca'tzī Dios. Lā' cāmālacpitzini'lh lā' cāmaxquī'lh ī'sca'txtunu'nī'n para natamaxquī' huan tachi'xcuhuī't. Lā' chuntza' tatlahualh. ");
INSERT INTO tooNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Lā' nā ixtaka'lhī makapitzīn ti'na'j squī'ti' lā' Jesús maxquī'lh pāxcatca'tzī Dios por huan squī'ti'. Lā' cāhuanilh ī'sca'txtunu'nī'n: ―Cacāmālacpitzini'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Lā' ixlīhuākca'n tahuā'yalh lā' talēka'sli. Lā' tamākēstokli xalacpītzin a'ntūn ta'a'katāxtūlh lā' tamātzumalh pātojon chā'xta. ");
INSERT INTO tooNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lā' a'ntīn tahuā'yalh hua'chi lakatā'ti' mil ixtahuanī't. Lā' Jesús cāmacā'lh huan tachi'xcuhuī't na ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Lā' tuncan xla' lā' ī'sca'txtunu'nī'n tatojōlh nac barco lā' tachā'lh a'nlhā ixmāpa'ksī huan cā'lacchicni' Dalmanuta. ");
INSERT INTO tooNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lā' huan fariseosnu' talakmilh lā' tatzuculh tatā'lāsta'la Jesús. Lā' tasqui'nli lakatin lē'cnīn a'ntū nalītasu'yu que xla' xala' nac a'kapūn. Tasqui'nli como xmān ixtalīlaktzī'ncu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lā' Jesús pānīlh con pō'ktu ixa'clhcunuc lā' hualh: ―¿A'chī' huan a'ntīn tahui'lāna' chuhua'j tasqui'n lē'cnīn? Lej stu'ncua' a'ntū iccāhuaniyāni'. Hui'xina'n a'ntī hui'lāna'ntit chuhua'j tū' caticātamāsu'ni'ni' huan lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Lā' cāmakxtekli lā' tojōpā huan nac barco lā' a'lh tintacut. ");
INSERT INTO tooNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lā' xmān ixa'nan mactin pāntzi nac barco como ixtapātza'nkānī't lā' tū' talē'lh pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Lā' Jesús cāmaxquī'lh tapāstacna' lā' cāhuanilh: ―Cuenta catlahua'tit lā' catamaktaka'lhtit de ixlevaduraca'n huan fariseosnu' lā' huan Herodes. ");
INSERT INTO tooNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Lā' huan sca'txtunu'nī'n talātā'chihuīna'lh lā' talāhuanilh: ―Chō'la ū'tza' līhualh chuntza' como tū' līmiuj pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Lā' Jesús ixca'tzī que xlaca'n tū' ixtamāchekxī a'nchī ixlīchihuīna'mā' ixpālacata a'ntūn tamāsu'yu huan fariseosnu' lā' cāhuanilh ī'sca'txtunu'nī'n: ―¿A'chī' cāpāta'layāni' ixpālacata huan pāntzi a'ntūn tū' līta'ntit? ¿Chu tū' cuenta tlahua'yā'tit nīn māchekxī'yā'tit? ¿Chu tū' ka'lhī'yā'tit mi'a'clhcunucca'n para napūpāstacna'nā'tit? ");
INSERT INTO tooNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ka'lhī'yā'tit milakastapunca'n. ¿Chu tū' laktzī'nā'tit? Ka'lhī'yā'tit mi'a'ka'xko'lhca'n. ¿Chu tū' a'kahuā'na'nā'tit? ¿Chu tūla pāstacna'nā'tit? ");
INSERT INTO tooNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","A'xni'ca' iccāche'kelh huan macquitzis pāntzi lā' ū'tza' iccālīmāhuī'lh lakaquitzis mil chi'xcuhuī'n, ¿lhā lakalā't chā'xta līmātzuma'tit xalacpītzin a'ntū mākēstoktit? Lā' xlaca'n takalhtīlh: ―Pācāujtu'. ");
INSERT INTO tooNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Lā' xla' hualh: ―Lā' a'xni'ca' iccāche'kelh huan mactojon pāntzi lā' ū'tza' iccālīmāhuī'lh lakatā'ti' mil, ¿lhā lakalā't chā'xta līmātzuma'tit xalacpītzin a'ntū mākēstoktit? Lā' xlaca'n takalhtīlh: ―Pātojon. ");
INSERT INTO tooNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Lā' cāhuanilh: ―Lā' ¿chu tūna'j māchekxī'yā'tit? ");
INSERT INTO tooNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lā' Jesús lā' ī'sca'txtunu'nī'n tachā'lh huan nac cā'lacchicni' a'ntū huanican Betsaida lā' līmini'ca Jesús kalhatin lakatzī'n lā' lej squi'ni'ca que caxa'malh huan chi'xcu' xalakatzī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Lā' makachi'palh lā' makachi'palē'lh huan lakatzī'n na ixquilhtūn cā'lacchicni'. Chojmanīlh ixlakastapun lā' xa'mani'lh na ixlakastapun lā' kalhasqui'nīlh: ―¿Tuchū la'ktzī'na'? ");
INSERT INTO tooNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Lā' xla' talakapākē'lh lā' hualh: ―Iccālaktzī'n chi'xcuhuī'n a'ntīn talatlā'huan. Tatasu'yu hua'chi xakalhanna' qui'huī'n como tūna'j xa'nca iclacahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Lā' tuncan xa'mani'pā na ixlakastapun. Lā' huan chi'xcu' talakapākē'pā lā' tzeyalh lā' xa'nca lacahuāna'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Lā' Jesús huanilh: ―Stu'nc capit na minchic lā' tū' titētanū'ya' huan nac cā'lacchicni'. Nīn tintī' nacāhuani'ya' xala' nac huan cā'lacchicni' a'nchī lītzeya'nti. ");
INSERT INTO tooNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lā' Jesús lā' ī'sca'txtunu'nī'n ta'a'lh huan nac makapitzīn cā'lacchicni' a'ntza' a'nlhā huanican Cesarea de Filipo. Lā' līhuan ixta'a'mā'na, xla' cākalhasqui'nīlh ī'sca'txtunu'nī'n: ―Lā' tachi'xcuhuī't, ¿chichūn tahuan de quimpālacata? ");
INSERT INTO tooNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Lā' xlaca'n takalhtīni'lh: ―Makapitzīn tahuan palh hui'x Juan huan Mā'kpaxīni' lā' ā'makapitzīn tahuan palh hui'x huan Elías lā' ā'makapitzīn huampala tahuan palh hui'x chō'la kalhatin a'cta'sana'. ");
INSERT INTO tooNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Lā' tuncan cāhuanilh: ―Lā' hui'xina'n, ¿chichū hua'nā'tit tichūn quit? Lā' Pedro kalhtīni'lh: ―Hui'x Cristo a'ntī Dios lacsacli. ");
INSERT INTO tooNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Lā' cāmāpa'ksīlh que tū' catitahuanilh nīn tintī' palh ū'tza' huan Cristo a'ntī Dios lacsacli. ");
INSERT INTO tooNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Lā' Jesús tzuculh cāmāsu'ni' chuntza': ―Quit huan Chi'xcu' xala' Tālhmā'n lā' tasqui'nī lej naquimāpātīnīcan. Huan xanapuxcu'nu' de huan lītokpān lā' xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley, xlaca'n naquintalakmaka'n lā' naquintamaknī. Lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko. ");
INSERT INTO tooNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Lā' lacastu'nc hualh huā'mā' tachihuīn. Lā' tuncan Pedro lē'lh lacachuna'j lā' tzē'k huanilh que tū' cahualh chuntza'. ");
INSERT INTO tooNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Lā' Jesús cālaktalakspi'tli lā' cālaktzī'lh ī'sca'txtunu'nī'n lā' lacaquilhnīlh Pedro lā' huanilh: ―Catakēnu'. Hui'x pāstacna'na' ixtapāstacna' huan ko'ti'ti'. Lā' tū' pāstacna'na' ixtapāstacna' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Lā' Jesús cāta'sani'lh huan tachi'xcuhuī't lā' ī'sca'txtunu'nī'n lā' Jesús cāhuanilh: ―Palh catīhuā tapa'ksīcu'tun con quit, tūlatza' catipāstacli xmān a'nchī xla' lacasqui'n. Calīhui'līlh natlahua quintapuhuān a'yuj capātīni'lh hua'chi quit na'icpātīni'n lā' caquistālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Huan a'ntīn tapūtaxtucu'tun de huan a'ntū natapātīni'n por quimpālacata, tū' catitaka'lhīlh ixquilhtamacujca'n para pō'ktu. Lā' huan a'ntī natapātīni'n a'yuj natanī por quimpālacata lā' ixpālacata huan xatzey tachihuīn, xlaca'n nataka'lhī ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Lā' palh kalhatin chi'xcu' ixtlajalh ixlīhuāk xala' nac huā'mā' quilhtamacuj, nīn tuntū' ixtapalh huā'mā' palh tū' ka'lhī ixquilhtamacuj para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tū' a'nan a'ntū xla' tzē namāstā' para naka'lhī ixquilhtamacuj para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Huan tachi'xcuhuī't a'ntīn tahui'lāna' chuhua'j taputza ā'makxtum dios. Palh chuxatī de hui'xina'n nalīmāxana'nā'tit na ixlacapūnca'n tachi'xcuhuī't lā' nalīmāxana'nā'tit quimpālacata lā' ixpālacata a'ntū icmāsu'yu, ū'tza' na'iclīmāxana'n a'xni'ca' na'icmimpala. Quit huan Chi'xcu' xala' Tālhmā'n lā' na'icka'lhī ixlīmāpa'ksīn quinTāta' Dios lā' naquintatā'min huan ixángeles a'ntī lej tzey. ");
INSERT INTO tooNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Lā' Jesús cāhuanipā: ―Stu'ncua' a'ntū iccāhuaniyāni'. A'nan makapitzīn a'ntīn tahui'lāna' huā'tzā' chuhua'j lā' xlaca'n tū' catitanīlh a'xni'ca' tūna'j natalaktzī'n ixlīmāpa'ksīn Dios lā' a'nchī namāpa'ksīni'nkō'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lā' ixlīlakachāxan chi'chini' Jesús cālē'lh Pedro lā' Jacobo lā' Juan lā' tatā'a'lh. Xmān ixkalhatā'ti'ca'n ta'a'lh huan nac tālhmā'n kēstīn lā' tā'cxtulh. Lā' a'ntza' taxtāpalīlh Jesús lā' xtunc ixtasu'yu na ixlacapūnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lā' ixlu'xu' lej xkakalh lā' lej smu'yonko' lalh hasta ixlakachi'pana'n. Lā' tū' a'nan ā'catīhuā nac cā'ti'ya'tna' a'ntī mālacastuca a'nchī lakche'kē'canī't. ");
INSERT INTO tooNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Lā' cātasu'yuni'lh Elías lā' Moisés lā' ixtatā'chihuīna'mā'na Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Lā' Pedro huanilh Jesús: ―Mākalhtō'kē'ni', xalītzey hui'lāna'uj huā'tzā'. Na'ictlahuayāuj huā'tzā' lakatu'tun mū'xta'ka'; lakatin mila' nala lā' ā'lakatin ixla' Moisés lā' ā'lakatin ixla' Elías. ");
INSERT INTO tooNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Chuntza' hualh Pedro como tū' ixca'tzī a'nchī ixualh como ixtu'tunca'n lej tajicua'lh. Lā' ū'tza' līhualh chuntza'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Lā' milh lakatin poklhnu' lā' cālītamacxti'li'lh. Lā' takaxmatli lakatin tachihuīn nac huan poklhnu' a'ntū hualh: ―U'tza' huā'mā' qui'O'kxa' lā' lej icpāxquī'. Cakaxpa'ttit a'ntū huan. ");
INSERT INTO tooNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Lā' tuncan lacapalh talaktzī'lh lā' nīn tintī' ixa'nan ā'chā'tin; xmān Jesús ixa'cstu talaktzī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Lā' a'xni'ca' ixtayujmā'na nac huan kēstīn, Jesús cāmāpa'ksīlh lā' cāhuanilh: ―Nīn tintī' tihua'ni'yā'tit a'ntū laktzī'nī'ta'ntit. Tū' catihua'ntit hasta a'xni'ca' huan Chi'xcu' xala' Tālhmā'n nalakahuanchoko de na ixlaclhpu'nanca'n nīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lā' tzē'k taca'tzīlh huā'mā' tachihuīn lā' ixtalākalhasqui'nī: ―¿Tuchū huanicu'tun huā' lakahuanchokocan de na ixlaclhpu'nanca'n nīnī'n? ");
INSERT INTO tooNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Lā' takalhasqui'nīlh Jesús: ―¿A'chī' tahuan huan xamākalhtō'kē'ni'nī'n huan ley palh tasqui'nī que xapū'la namin Elías lā' ā'calīstān namin huan Cristo a'ntī Dios lacsacui'līnī't? ");
INSERT INTO tooNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Lā' Jesús cākalhtīlh: ―Stu'ncua' huā'mā'. Pū'la namin Elías lā' nacāxtlahuakō' ixlīhuāk. ¿Chu tū' tatzo'kni' ixpālacata huan Chi'xcu' xala' Tālhmā'n que napātīni'n lhūhua' lā' nalakmaka'ncan? ");
INSERT INTO tooNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero quit iccāhuaniyāni' palh milhtza' huan a'ntī huancan palh xla' Elías lā' makapitzīn chi'xcuhuī'n tatlahuani'lh chu a'nchī ixtalacasqui'n. Pātle'keni'lh chu a'nchī tatzo'kni' ixpālacata xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lā' a'xni'ca' ixkalhatā'ti'ca'n tachā'lh a'nlhā ixtahui'lāna' huan ā'makapitzīn sca'txtunu'nī'n, talaktzī'lh a'nchī lhūhua' tachi'xcuhuī't ixtalītamacxti'li'nī't. Lā' xamākalhtō'kē'ni'nī'n ley ixtatā'lāhuanimā'na huan sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Lā' a'xni'ca' huan tachi'xcuhuī't talaktzīlh Jesús, talē'cnīlh lā' tuncan talaktu'jnulh lā' tatā'chihuīna'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Lā' Jesús cākalhasqui'nīlh: ―¿Tuchū līchihuīna'nā'tit? ");
INSERT INTO tooNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Lā' kalhtīlh kalhatin na ixlaclhpu'nanca'n lā' hualh: ―Mākalhtō'kē'ni', iclīmini'ni' quincaman. Ka'lhī huan tlajana' a'ntū makakō'ko'nīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chu a'nlhā chi'pa lā' a'ntza' māyujū nac ti'ya't lā' tzucu kalhpupu lā' māsā'nī ixtatzan lā' lhtuculu' la. Lā' iccāsqui'ni'lhtza' misca'txtunu'nī'n que catamāxtuni'lh. Lā' xlaca'n tūlalh tamāxtuni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Lā' Jesús cāhuanilh: ―Hui'xina'n tū' kalhlaka'ī'yā'tit. ¿Hasta lhānīn na'iccātā'latahui'layāni' hui'xina'n para que namāchekxī'yā'tit? Lā' ¿hasta lhānīn na'iccātāyani'yāni' hui'xina'n a'nchī hua'nā'tit? Caquilī'ta'ni' huan ka'hua'chu. ");
INSERT INTO tooNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Lā' talīmini'lh lā' a'xni'ca' laktzī'lh Jesús, huan tlajana' makaxtacnānīlh huan ka'hua'chu lā' a'kā'lh nac ti'ya't lā' tapi'li'lh lā' kalhpupulh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Lā' Jesús kalhasqui'nīlh ixtāta' huan ka'hua'chu: ―¿Lhā lakalā't cā'ta ka'lhīnī't huā'mā' ta'jatat? Lā' xla' kalhtīni'lh: ―Desde ixlīti'na'j tzuculh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Lā' maklhūhua' māpū'lh nac macscut lā' nac xcān para namaknī. Lā' palh tzē natlahua'ya' catūhuā, caquilālakalhu'mauj quina'n lā' caquilāmaktāyauj. ");
INSERT INTO tooNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Lā' Jesús huanilh: ―Lā' ¿a'chī' quihua'ni': “Palh tzē natlahua'ya' catūhuā”? Huan a'ntī kalhlaka'ī' Dios lā' līpāhuan Dios, ū'tza' tzēn tlahua chu a'ntūyā catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Lā' tuncan ixtāta' huan ka'hua'chu ta'salh lā' hualh: ―Quit ickalhlaka'ī'. Caquimaktāya' porque quisputni'cus a'nchī xa'nca na'ickalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lā' a'xni'ca' Jesús cuenta tlahualh a'nchī ixtalaktu'jnumā'na ixtalaktakēstokmā'na, xla' lacaquilhnīlh huan tlajana' lā' huanilh: ―Icmāpa'ksīyāni' hui'x a'ntī māsordujlīnī'ta' lā' makakō'ko'nī'ta' huan ka'hua'chu. Icmāpa'ksīyāni' que cataxtu de xla' lā' tū' maktin titanūpala'ya' na ixchakān. ");
INSERT INTO tooNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Lā' huan tlajana' ta'salh lā' makaxtacnānīlh huan ka'hua'chu lā' taxtulh. Lā' huan ka'hua'chu ixtasu'yu hua'chi xanīn ixuanī't. U'tza' lhūhua' talīhualh ixpālacata huan ka'hua'chu: ―Nīlhtza'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús makachi'palh lā' maktāyalh lā' huan ka'hua'chu tā'kaquī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Lā' a'xni'ca' Jesús lā' ī'sca'txtunu'nī'n tatanūlh nac chic, lā' ixa'cstuca'n ixtahui'lāna' lā' takalhasqui'nīlh: ―¿A'chī' quina'n tūlalh icmāxtuni'uj huan ka'hua'chu huan tlajana'? ");
INSERT INTO tooNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Lā' cāhuanilh: ―Huan tlajana' hua'chi huā'mā' tūla māxtucan. Xmān tzē māxtucan palh natlahua'yā'tit oración lā' palh nalīhui'lī'yā'tit tū' nahuā'ya'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lā' tataxtulh de a'ntza' lā' ta'a'lh lā' ixtalatlā'huan huan nac estado de Galilea. Lā' Jesús tū' ixlacasqui'n que naca'tzīcan que ixuī' a'ntza' ");
INSERT INTO tooNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","porque ixcāmāsu'ni'mā' ī'sca'txtunu'nī'n. Lā' ixcāhuani: ―Naquimacamāstā'can quit, huan Chi'xcu' xala' Tālhmā'n, lā' naquimacamāstā'can con ixlīmāpa'ksīnca'n chi'xcuhuī'n. Lā' xlaca'n naquintamaknī lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko ―cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero xlaca'n tū' tamāchekxīlh huā'mā' tachihuīn lā' tū' ixtakalhasqui'nīcu'tun como ixtajicua'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lā' tachā'lh nac huan cā'lacchicni' a'nlhā huanican Capernaum. Lā' a'xni'ca' tatanūlhtza' nac chic, Jesús cākalhasqui'nīlh: ―¿Tuchū ixlālīsta'la'yā'tit a'xni'ca' ixta'mpā'na'ntit nac tej? ");
INSERT INTO tooNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Xlaca'n taquilhca'cslalh como līhuan ixtatlā'huantēlha nac tej, ixtalālīsta'lamā'na ixpālacata tichū más tasqui'nī na ixlaclhpu'nanca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Lā' Jesús tahuī'lh lā' cāta'sani'lh ixkalhacāujtu'ca'n lā' cāhuanilh: ―Palh catīhuā lacu'tun xapuxcu' de hui'xina'n, calalh hua'chi ixtasācua'ca'n ā'makapitzīn lā' calalh hua'chi xastancu. ");
INSERT INTO tooNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Lā' makachi'palh kalhatin ti'na'j ka'hua'chu lā' yāhualh na ixlaclhpu'nanca'n. Lā' cha'xli lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Chuxatī a'ntīn tapa'ksī con quit lā' ū'tza' nalīpāxquī' kalhatin ti'na'j ka'hua'chu hua'chi huā'yā, ū'tza' chu a'cxtim hua'chilh quit quimpāxquī'. Lā' chuxatī a'ntī quimpāxquī' quit, nā paxquī' huan a'ntī quimacamilh lā' tū' xmān quit. ");
INSERT INTO tooNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Lā' Juan huanilh: ―Mākalhtō'kē'ni', iclaktzī'nī'tauj kalhatin chi'xcu' a'ntī ixmāpācuhuī mintacuīni' lā' ū'tza' ixcālīmāxtumā' huan tlajana'nī'n. Lā' icuaninī'tauj que tū'tza' catlahualh chuntza' como xla' tū' quincātā'latlā'huanāni' quina'n. ");
INSERT INTO tooNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Lā' Jesús hualh: ―Camakxtektit lā' tū' timāmakchuyīyā'tit. Tū' a'nan a'ntī natlahua lē'cnīn a'xni'ca' namāpācuhuī quintacuīni' lā' chu tuncan tzē naquilakapala. ");
INSERT INTO tooNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Lā' a'ntīn tū' quintā'ca'tzaca'n, ū'tza' quincāmaktāyayāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Stu'ncua' a'ntū iccāhuaniyāni' que chuxatī nacātā'hua'yāni' xcān por ixpālacata hui'xina'n tapa'ksī'yā'tit con Cristo, ū'tza' Dios namāpala. ");
INSERT INTO tooNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Lā' Jesús huampā: ―Lā' palh catīhuā chihuīna'maxquī' kalhatin ti'na'j ka'hua'chu a'ntī quinkalhlaka'ī' lā' ū'tza' huan ka'hua'chu nalītlahua talaclē'i', huā'mā' chi'xcu' tū' tzey. Xatzey palh pū'la ixpixchī'hua'ca'ca lakatin ka'tla' chihuix lā' ixmojōca nac mar para najicsua'. Chuntza' tū' ixa'kxokolh huan ka'hua'chu. ");
INSERT INTO tooNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Lā' palh mimacan napūtlahua'yā'tit talaclē'i', huā'mā' tū' tzey. Xalītzey macamōcho ixla'tit lā' ixka'lhī'tit minquilhtamacujca'n para pō'ktu. Tū' tzey palh ka'lhī'yā'tit kantu' mimacanca'n a'ntū pūtlahua'yā'tit talaclē'i' lā' ū'tza' nacātalīmacā'nāni' hui'xina'n nac pūpātīn. A'ntza' huan macscut tūla māmixīcan. ");
INSERT INTO tooNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","A'ntza' huan xtokonu'lūhua' tū' maktin catihua'kō'lh huan xamasni' ixquinītca'n a'ntī natapātīni'n lā' tū' catimixli huan macscut. ");
INSERT INTO tooNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","’Lā' palh mintojonca'n napūtlahua'yā'tit talaclē'i', huā'mā' tū' tzey. Xatzey palh lacmōcho ixla'tit lā' ixka'lhī'tit minquilhtamacujca'n para pō'ktu. Tū' tzey palh ka'lhī'yā'tit kantu' mintojonca'n a'ntū pūtlahua'yā'tit talaclē'i' lā' ū'tza' nacātalīmacā'nāni' hui'xina'n nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","A'ntza' huan xtokonu'lūhua' tū' maktin catihua'kō'lh huan xamasni' ixquinītca'n a'ntī natapātīni'n lā' tū' catimixli huan macscut. ");
INSERT INTO tooNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","’Lā' palh tlahua'cu'tunā'tit talaclē'i' ixpālacata catūhuā a'ntūn talaktzī'n milakastapunca'n, huā'mā' tū' tzey. Xatzey lakaxō'ko' ixla'tit lā' ixka'lhī'tit minquilhtamacujca'n para pō'ktu. Tū' tzey palh ka'lhī'yā'tit lakatu' milakastapunca'n a'ntū nacāmātlahuīyāni' talaclē'i' lā' ū'tza' nacātalīmacā'nāni' hui'xina'n nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","A'ntza' huan xtokonu'lūhua' tū' maktin catitahua'kō'lh huan xamasni' ixquinītca'n a'ntī natapātīni'n lā' tū' catimixli huan macscut. ");
INSERT INTO tooNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Tasqui'nī que ixlīhuākca'n natapātīni'n para que más tzey natala. U'tza' hua'chi macscut lā' maclacasqui'n chuntza' hua'chi līhua't maclacasqui'n matzat. Lā' a'ntū a'ksajuī'can Dios, huāk nalīmāsko'kō'can matzat. ");
INSERT INTO tooNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Matzat tzey; pero palh matzat tū'tza' sko'ko', ¿chichū nalīmāsko'kō'nuncan? Caka'lhī'tit hua'chi matzat na minquilhtamacujca'n. Lā' ū'tza' huanicu'tun que xa'nca' nalatā'kchokoyā'tit. Lā' ca'cs nalātahui'la'yā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Lā' Jesús taxtulh de Capernaum lā' a'lh huan nac ti'ya't a'nlhā huanican Judea. U'tza' a'ntū hui'lacha' tintacut huan pūxka Jordán. Lā' tatzucupā tatakēstoka tachi'xcuhuī't. Lā' Jesús tzucupā cāmāsu'ni' como chuntza' ixlīsmanīnī't. ");
INSERT INTO tooNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lā' talaktapajtzūlh Jesús makapitzīn fariseosnu'. Ixtalīlaktzī'ncu'tun lā' ū'tza' talīkalhasqui'nīlh: ―¿Chā tzē makxtekcan quimpuscātca'n lā' xapacan ixtacuīni'? ");
INSERT INTO tooNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Lā' Jesús cākalhtīlh: ―¿Chichūn cāmāpa'ksīni' Moisés hui'xina'n a'nlhā tatzo'kni' huan nac ley? ");
INSERT INTO tooNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Lā' xlaca'n tahualh: ―Moisés hualh: “Tzēn tzo'kcan lakatin acta lā' chuntza' tzē namakxteka' mimpuscāt”. ");
INSERT INTO tooNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Lā' Jesús cāhuanilh: ―Lej lacxumpi hui'xina'n lā' tū' tzey mintapāstacna'ca'n. U'tza' lītzo'kli Moisés huā'mā' līmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero a'xni'ca' tzuculh huan quilhtamacuj, tatzo'kni' chuntza': Dios tlahualh chi'xcu' lā' puscāt. ");
INSERT INTO tooNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","U'tza' nacālīmakxteka ixtāta' lā' ixtzī't kalhatin chi'xcu' lā' natā'takēxtimī ixpuscāt. ");
INSERT INTO tooNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Lā' ixtu'ca'n natala hua'chilh xmān kalhatin. Chuntza' tatzo'kni'. Lā' chuntza' tū'tza' kalhatu' xlaca'n; xmān kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lā' chuntza' tū' līmakuan palh chi'xcuhuī'n cālāmāmakxtekē a'ntī Dios cātlahuanī't chu lakatin. ");
INSERT INTO tooNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lā' a'xni'ca' tatanūpā nac chic, takalhasqui'nīlh ī'sca'txtunu'nī'n ixpālacata a'ntū hualh. ");
INSERT INTO tooNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Lā' Jesús cāhuanilh: ―Chu a'ntī namakxteka ixpuscāt lā' palh natā'tapūchahua ā'kalhatin puscāt, huā'mā' chi'xcu' makpuscātīni'n. Lā' chuntza' tlahuani' huan xapū'la ixpuscāt a'ntūn tū' līmakuan. ");
INSERT INTO tooNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Lā' palh kalhatin puscāt namakxteka ixkōlu' lā' natā'tapūchahua ā'kalhatin chi'xcu', chuntza' huā'mā' puscāt naka'lhī ixmakchi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lā' cālīmini'ca Jesús camana' para que ixcā'a'cpūxa'malh. Lā' ī'sca'txtunu'nī'n tatzuculh talacaquilhnī a'ntī ixtalīmin. ");
INSERT INTO tooNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lā' a'xni'ca' Jesús ca'tzīlh a'ntū ixtatlahuamā'na, xacā'lh lā' cāhuanilh ī'sca'txtunu'nī'n: ―Cacāmakxtektit quintalakmin huan camana' lā' tū' cacāmāmakchuyī'tit como huan a'ntī natatapa'ksī con Dios a'nlhā māpa'ksīni'n, xlaca'n a'ntī naquintalīpāhuan hua'chi huan tamā'na camana'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ixlīstu'ncua' iccāhuaniyāni' que a'ntīn tū' takalhlaka'ī' hua'chi lakska'tā'n takalhlaka'ī', tū' maktin catitatanūlh a'nlhā māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Lā' Jesús cācha'xli huan camana' lā' cāmūspa'lhli con ixmacan lā' cāsicua'lanālīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Lā' Jesús a'mpā, lā' ixtlā'huantēlha nac tej. Lā' laktu'jnulh kalhatin chi'xcu' lā' tatzokostani'lh Jesús lā' kalhasqui'nīlh: ―Tzeyā Mākalhtō'kē'ni' hui'x. ¿Tuchū na'ictlahua para na'icka'lhī quinquilhtamacuj para pō'ktu? ");
INSERT INTO tooNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Lā' Jesús huanilh: ―¿Chā māchekxī'ya' a'ntū huanicu'tun a'xni'ca' quihua'ni'ya' palh tzey quit? Xmān kalhatin a'ntī tzey lā' ū'tza' Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hui'x ca'tzīya' ixlīmāpa'ksīn Dios a'ntū huan chuntza': Tū' timakpuscātīni'na'. Tū' timaknīni'na'. Tū' tika'lhāna'na'. Tū' tilīchihuina'na' ā'kalhatin a'ntūn tū' stu'ncua'. Tū' ti'a'kxokonu'na' para natlaja'ya'. Cacā'a'kahuā'na'ni' mintāta' lā' mintzī't. ");
INSERT INTO tooNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Lā' xla' kalhtīlh: ―Mākalhtō'kē'ni', huāk huā' tamā'na ictlōkentaxtūkō'nī'ttza' desde quilīti'na'j. ");
INSERT INTO tooNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Entonces Jesús laktzī'lh lā' pāxquī'lh lā' huanilh: ―Xmān lakatin catūhuā sputni'yāni' a'ntū natlahua'ya'. Caquīstā'kō'j huāk a'ntū ka'lhī'ya' lā' nacāmālacpitzi'ni'ya' huan tumīn huan pobresni' lā' naka'lhī'ya' a'nchī rico nalīla'ya' nac a'kapūn. Lā' ā'calīstān naquintā'pina', a'yuj napātīni'na'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lā' a'xni'ca' huan chi'xcu' kaxmatli huā'mā' tachihuīn, lej līlakaputzalh lā' a'lh como lej rico ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Lā' Jesús lakachu cālaktzī'lh tachi'xcuhuī't lā' cāhuanilh ī'sca'txtunu'nī'n: ―Lej jicslīhua' para xlaca'n a'ntī lacricosnu' natatamakxteka que Dios nacāmāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Lā' ī'sca'txtunu'nī'n talīlē'cnīlh ixtachihuīn. Lā' Jesús cāhuanipā: ―Qui'amigos, iccāhuaniyāni' que xlaca'n a'ntīn talīpāhuan ixtumīnca'n, lej jicslīhua' natatamakxteka que Dios nacāmāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ca'tzīyā'tit que tūlalh catitanūlh lakatin camello na ixtani' līxtokon. Más jicslīhua' para kalhatin rico natamakxteka que Dios namāpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Lā' xlaca'n lej lhūhua' talē'cnīlh lā' talāhuanilh: ―Lā' ¿tichūn tzē namāpūtaxtūcan? ");
INSERT INTO tooNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Lā' Jesús cālaktzī'lh lā' cāhuanilh: ―Huan chi'xcuhuī'n tūlalh catitatlahualh nīn tuntū' para natapūtaxtu, xmān Dios tzē nacāmāpūtaxtū como Dios tzēn tlahua huāk catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Lā' Pedro tzuculh chihuīna'n lā' huanilh Jesús: ―Ica'kxtekui'līkō'uj ixlīhuāk a'ntū xa'icka'lhīyāuj lā' iccāstālani'mā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Lā' Jesús kalhtīni'lh: ―Stu'ncua' a'ntū iccāhuaniyāni'. A'nan a'ntī nata'a'kxtekui'lī catūhuā por quimpālacata lā' ixpālacata kalhlaka'ī' xatzey tachihuīn. Nata'a'kxtekui'lī ixā'lacchicni'ca'n, o ixtā'timīnca'n, o ixtzī'tca'n, o ixtāta'ca'n, o ixcamana'ca'n, o ixā'tacuxtuca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Xlaca'n a'ntī nata'a'kxtekui'lī, ā'chulā' nataka'lhī nac huā'mā' quilhtamacuj. Hua'chi cien veces līhua'ca' nataka'lhī ixā'lacchicni'ca'n lā' nā lhūhua' ixtā'timīnca'n lā' ixtzī'tca'n lā' ixtāta'ca'n lā' ixcamana'ca'n lā' ixā'tacuxtuca'n. Lā' nā nacāmāpātīnīcan. Lā' nataka'lhī ixquilhtamacujca'n para pō'ktu a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lā' lhūhua' a'nan a'ntī lej tatasqui'nī huā'tzā'; pero a'nlhā Dios māpa'ksīni'n, tū' lej catitatasqui'nīlh. Lā' lhūhua' a'nan a'ntīn tū' tatasqui'nī huā'tzā'; pero a'nlhā Dios māpa'ksīni'n, lej natatasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús lā' ī'sca'txtunu'nī'n ixtatā'cxtunu'ntēlha para nac Jerusalén lā' Jesús ixcāpū'lani'tēlha lā' xlaca'n talē'cnīlh. Lā' huan a'ntī ixtastālani' ixtajicua'n. Lā' chu cālē'mpā lacachuna'j huan kalhacāujtu' ī'sca'txtunu'nī'n lā' tzucupā cāhuani a'ntū napātle'keni'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lā' Jesús cāhuanilh: ―Ca'tzīyā'tit que a'mā'nauj para nac Jerusalén. Lā' a'ntza' naquimacamāstā'can como quit huan Chi'xcu' xala' Tālhmā'n. Naquimacamāstā'can con huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley. Lā' xlaca'n natahuan que caquimaknīca. Lā' xlaca'n naquintamacamāstā' con huan maktiyātī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Lā' naquintalakapala lā' naquintakēsnoka lā' naquintachojmanī lā' naquintamaknī. Lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko de na ixlaclhpu'nanca'n huan nīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Lā' Jacobo lā' Juan, ixo'kxa'n Zebedeo, talaktapajtzūlh Jesús lā' tahuanilh: ―Mākalhtō'kē'ni', iclacasqui'nāuj naquilātlahua'ni'yāuj a'ntū na'iccāsqui'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Lā' xla' cākalhasqui'nīlh: ―¿Tuchū lacasqui'nā'tit na'iccātlahua'ni'yāni'? ");
INSERT INTO tooNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Lā' xlaca'n tahuanilh: ―A'xni'ca' hui'x namāpa'ksīni'nkō'ya', quina'n iclacasqui'nāuj na'iccāpāxtūtahui'layāni', kalhatin na mimpāxtūcāna'j lā' ā'kalhatin na mimpāxtuxuc. ");
INSERT INTO tooNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero Jesús cāhuanilh: ―Hui'xina'n tū' māchekxī'yā'tit a'ntū quilāsqui'ni'mā'nauj. ¿Chā tzē natāyani'yā'tit palh napātīni'nā'tit hua'chi quit na'icpātīni'n? U'tza' hua'chilh pōko'tnū'nā'tit quintaza lā' hua'chilh quintā'a'kpaxā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Lā' xlaca'n tahualh: ―Tzē na'ictlahuayāuj; tzē na'ictāyani'yāuj. Lā' Jesús cāhuanilh: ―Stu'ncua' que napātīni'nā'tit hua'chi quit. ");
INSERT INTO tooNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ū'tza' huā'mā' naquilāpāxtūtahui'layāuj, quit tūla icmāpa'ksī. Huā'mā' pūtahuī'lh cāxui'līca xmān para huan a'ntī Dios lacsacli. ");
INSERT INTO tooNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lā' a'xni'ca' huan kalhacāuj sca'txtunu'nī'n taca'tzīlh a'ntū kalhasqui'nīca Jesús, tatzuculh ta'a'kchā'n ixpālacata Jacobo lā' Juan. ");
INSERT INTO tooNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Lā' Jesús cāta'sani'lh ixlīhuākca'n lā' cāhuanilh: ―Hui'xina'n ca'tzīyā'tit a'nchīn tahuanī't huan a'ntīn tamāpa'ksīni'n nac cā'ti'ya'tna'. Xlaca'n hua'chi ixtēcu'nī'n a'ntīn tatapa'ksī con xlaca'n. Lā' lej palha' tamāpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tū' chuntza' catilalh na milaclhpu'nanca'n. Chuxatī a'ntī lacu'tun xamāpa'ksīni' na milaclhpu'nanca'n, maclacasqui'n que xla' nala hua'chi ixlacscujni'ca'n ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chuxatī a'ntī naputza a'nchī līhua'ca' natasqui'nī na milaclhpu'nanca'n, maclacasqui'n que xla' nala hua'chi ixtasācua'ca'n ā'makapitzīn de hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quit māni' huan Chi'xcu' xala' Tālhmā'n. Lā' quit tū' icmilh para na'icla hua'chi xapatrón; quit icmilh para na'icscuja lā' para na'iccāmaktāya ā'makapitzīn. Lā' na'icmacamāstā' quinquilhtamacuj para na'iccāmāpūtaxtū līlhūhua' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lā' tachā'lh huan nac cā'lacchicni' a'nlhā huanican Jericó. Lā' a'xni'ca' Jesús ixtaxtumā' nac Jericó, tatā'a'lh ī'sca'txtunu'nī'n lā' lhūhua' tachi'xcuhuī't. Lā' na ixquilhtūn tej ī'squi'nīhuā'yahuī' huan lakatzī'n a'ntī ixuanican Bartimeo ixo'kxa' Timeo. ");
INSERT INTO tooNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lā' a'xni'ca' ca'tzīlh que ixtētaxtumā' Jesús xala' nac Nazaret, tzuculh ta'sa lā' hualh: ―Jesús, hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj. Caquilakalhu'ma' quit. ");
INSERT INTO tooNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lā' lhūhua' chi'xcuhuī'n talacaquilhnīlh lā' tahuanilh: ―Caquilhca'csla'. Lā' Bartimeo ā'chulā' ixta'sa lā' hualh: ―Hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj, caquilakalhu'ma' quit. ");
INSERT INTO tooNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Lā' Jesús tāyalh lā' cāhuanilh ī'sca'txtunu'nī'n: ―Cata'sa'ni'tit. Lā' tata'sani'lh huan lakatzī'n lā' tahuanilh: ―Capāxu'hua' lā' catāya'. Jesús ta'sani'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lā' xla' tamakxtulh ixtakēnu' lā' tāyalh lā' lakmilh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Lā' Jesús kalhasqui'nīlh: ―¿Tuchū lacasqui'na' na'ictlahuani'yāni'? Lā' huan lakatzī'n huanilh: ―Mākalhtō'kē'ni', caquimālacahuā'nī'pala'. ");
INSERT INTO tooNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Lā' Jesús huanilh: ―Tzētza' napina'. Hui'x kalhlaka'ī'nī'ta' que quit na'icmālacahuānīyāni' lā' ū'tza' lītzeya'ntitza'. Lā' chu līmaktin lacahuāna'lh lā' stālani'lh Jesús nac tej. ");
INSERT INTO tooNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lā' a'xni'ca' ixtapajtzūtēlhatza' nac Jerusalén, tachā'lh huan nac o'kspū'n a'nlhā huanican Olivos, lā' ū'tza' pajtzu huan cā'lacchicni' a'nlhā huanican Betfagé lā' a'nlhā huanican Betania. Lā' Jesús cāmāpū'līlh kalhatu' ī'sca'txtunu'nī'n ");
INSERT INTO tooNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","lā' cāhuanilh: ―Capintit huan nac cā'lacchicni' a'ntūn tasu'yu na milacapūnca'n. Lā' a'xni'ca' nachipinā'tit nalaktzī'nā'tit lakatin xaska'ta' burro a'ntū chī'yāhuacanī't. Nīn tintī'na'j kētahui'lanī't. Caxcuttit lā' caquilālīmini'uj huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Lā' palh catīhuā nacākalhasqui'ni'yāni': “¿A'chī' xcutpā'na'ntit huan burrito?”, hui'xina'n nakalhtīni'nā'tit: “Huan Māpa'ksīni' maclacasqui'n lā' tuncan namacamimpala huā'tzā'”. ");
INSERT INTO tooNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Lā' ta'a'lh lā' takaksli lakatin xati'na'jcus burro a'ntū ixchī'yāhuacanī't. Ixyā nac tej pajtzu xamākalhcha lakatin chic. Lā' tatzuculh taxcuta. ");
INSERT INTO tooNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Lā' makapitzīn chi'xcuhuī'n a'ntī ixtayāna' takalhasqui'nīlh: ―¿Tuchū tlahua'pā'na'ntit? ¿A'chī' xcutpā'na'ntit huan burro? ");
INSERT INTO tooNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Lā' huan sca'txtunu'nī'n takalhtīni'lh chu a'nchī Jesús ixcāhuaninī't. Lā' huan chi'xcuhuī'n tamakxtekli ta'a'n huan sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lā' talīmini'lh Jesús huan xati'na'jcus burro lā' talīkētlapalh ixtakēnu'ca'n lā' xla' kētō'lalh. ");
INSERT INTO tooNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lā' lhūhua' tachi'xcuhuī't tamāpī'lh ixtakēnu'can nac tej. Lā' ā'makapitzīn ixtacā' xati'na'j ixpeken qui'hui' para natamāpī' nac tej. Chuntza' talīmāsu'yulh palh ixta'a'cnīni'ni'mā'na Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Lā' a'ntī ixtapū'lani'tēlha lā' a'ntī ixtastālani'tēlha tatzuculh tata'sa lā' tahualh: ―¡Camācā'tanīca Dios! Dios casicua'lanālīlh a'ntī mimā' por ixlīmāpa'ksīn huan Māpa'ksīni' quinDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Dios casicua'lanālīlh huan līmāpa'ksīn a'ntū nala, lā' ū'tza' hua'chi ixlīmāpa'ksīn quixū'yāpapca'n David. ");
INSERT INTO tooNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Lā' a'xni'ca' Jesús chā'lh nac Jerusalén, tanūlh nac xaka'tla' lītokpān. Lā' como kōtanūtza' ixuanī't, a'xni'ca' lakachu lacahuāna'lh na ixchakān lītokpān, taxtulh lā' cātā'a'lh huan kalhacāujtu' sca'txtunu'nī'n nac Betania. ");
INSERT INTO tooNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lā' ixlīlakalī a'xni'ca' tataxtulh de nac Betania, Jesús ixtzi'ncsa. ");
INSERT INTO tooNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Lā' de makat laktzī'lh a'katin xaqui'hui' higo lā' ixtaxtuni'nī'ttza' xachi'tin huan qui'hui'. Lā' Jesús tapajtzūlh para nalaktzī'n palh ixua'ca'tza' xatō'ca't. Lā' a'xni'ca' chā'lh a'nlhā ixyā huan qui'hui', tū' ixka'lhī ixtō'ca't. Xmān xachi'tin ixka'lhī como tūna'j ixchā'n ixpūlan higo. ");
INSERT INTO tooNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Lā' Jesús huanilh huan qui'hui': ―Tū' maktin catihua'ca' mintō'ca't. Lā' ī'sca'txtunu'nī'n takaxmatli a'ntū huanilh huan qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lā' a'xni'ca' tachā'lh nac Jerusalén, Jesús tanūlh nac xaka'tla' lītokpān lā' tzuculh cātlakaxtu huan a'ntī ixtastā'namā'na lā' huan a'ntī ixtatamāhuana'mā'na na ixtanquilhni' huan lītokpān. Lā' cāmakpūspi'tni'kō'lh ixmesaca'n huan a'ntī ixtaxtāpalīmā'na ixtumīnca'n tachi'xcuhuī't lā' nā ixpūtahui'lhca'n huan a'ntī ixtastā'mā'na pālūmax. ");
INSERT INTO tooNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Lā' tū' makxtekli que nīn tintī' natētaxtu na ixtanquilhni' huan lītokpān palh ixlē'mā' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Lā' ixcāmāsu'ni' huan tachi'xcuhuī't lā' hualh: ―¿Chu tū' tatzo'kni' chuntza'?: “Quinchic namāpācuhuī'can chic a'nlhā tlahuacan oración. Huan tachi'xcuhuī't xalanī'n calhāhuā natamin tatlahua oración”. Lā' a'nchīn tlahuapā'na'ntit, lītlahuacanī't hua'chi ixpūtatzē'kni'ca'n ka'lhāna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lā' cāmāca'tzīnīca xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley. Lā' xlaca'n ixtaputzamā'na a'nchī natalīmaknī Jesús. Ixtajicua'ni' Jesús como ixlīhuākca'n huan tachi'xcuhuī't ixtalē'cnī a'nchī ixmāsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lā' a'xni'ca' ixtā'cnūnī'ttza' huan chi'chini', Jesús lā' ī'sca'txtunu'nī'n tataxtulh de nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Lā' ixlīlakalī cā'tzi'sāt tatētaxtulh a'nlhā ixyā huan xaqui'hui' higo lā' talaktzī'lh a'nchī ī'scōhuankō'nī'ttza' hasta ixtankāxē'k. ");
INSERT INTO tooNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Lā' Pedro pāstacli a'ntū pātle'kelh lā' huanilh Jesús: ―Mākalhtō'kē'ni', cala'ktzi'. Huan qui'hui' scōhuantāyakō'lhtza'; huan a'ntū macapūlhca'. ");
INSERT INTO tooNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Lā' Jesús cākalhtīlh: ―Cakalhlaka'ī'tit Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Stu'ncua' a'ntū iccāhuaniyāni'. Chuxatī a'ntī xa'nca nakalhlaka'ī' lā' tū' naka'lhī lakatu' ixtapāstacna', natlahuani'can chu a'ntū xla' nasqui'n. Palh nahuani huan kēstīn: “Catapānu' de ā'tzā' lā' catojo' nac xcān”, chuntza' napātle'ke, xmān tū' caka'lhīlh lakatu' ixtapāstacna'. ");
INSERT INTO tooNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","U'tza' iccālīhuaniyāni' que ixlīhuāk a'ntū nasqui'ni'yā'tit a'xni'ca' tā'chihuīna'mpā'na'ntit Dios, caka'lhlaka'ī'tit que ka'lhīyā'tittza'. Lā' namaklhtīni'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Lā' a'xni'ca' natāya'yā'tit lā' tlahua'pā'na'ntit oración, namāsputūnu'ni'yā'tit catīhuā palh cātlahuani'nī'ta'ni' a'ntūn tū' tzey. Chuntza' minTāta'ca'n nac a'kapūn tzē nacāmāsputūnu'ni'yāni' mintalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Lā' palh hui'xina'n tū' cāmāsputūnu'ni'yā'tit ā'makapitzīn, minTāta'ca'n nac a'kapūn tū' caticāmāsputūnu'ni'ni' mintalaclē'i'ca'n hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lā' tachā'lh nac Jerusalén. Lā' a'xni'ca' Jesús ixlatlā'huan nac xaka'tla' lītokpān, talaktapajtzūlh xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley lā' xalacpapatzīni'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Lā' takalhasqui'nīlh: ―¿Tichū ixquilhtampān lītlahua'pā't huā'mā'na catūhuā? ¿Tichū maxquī'ni' huā'mā' līmāpa'ksīn? ");
INSERT INTO tooNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Lā' Jesús cākalhtīlh: ―Nā quit na'iccākalhasqui'nīyāni' catūhuā. Lā' palh naquilākalhtīyāuj, nā quit na'iccāhuaniyāni' tichū ixquilhtampān iclītlahuamā' huā'mā'na catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Tichū ixquilhtampān ixlīmā'kpaxīni'n Juan? ¿Ixquilhtampān Dios o ixquilhtampān tachi'xcuhuī't? Caquilākalhtīuj. ");
INSERT INTO tooNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Lā' xlaca'n tatzuculh talacchihuīna'n ixa'cstuca'n lā' talāhuanilh: ―¿Chichū nahuaniyāuj? Palh nahuaniyāuj que Dios māpa'ksīlh huan Juan, naquincākalhasqui'nīyāni': “Lā' ¿a'chī' tū' kalhlaka'ī'nī'ta'ntit?” ");
INSERT INTO tooNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Lā' tūla catihuaniuj que chi'xcuhuī'n tamāpa'ksīlh como cājicua'ni'yāuj tachi'xcuhuī't ―talāhuanilh. Ixtajicua'n que tachi'xcuhuī't nata'a'kchā'n como ixlīhuākca'n ixtakalhlaka'ī' que Juan stu'ncua' ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Lā' ū'tza' talīkalhtīlh Jesús: ―Tū' iccā'tzīyāuj tichū ixquilhtampān. Lā' Jesús cāhuanilh: ―Nīn quit tū' icticāhuanini' tichū ixquilhtampān iclītlahuamā' huā'mā'na catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Lā' Jesús tzuculh cālītā'chihuīna'n huan tachi'xcuhuī't con a'ntū lītalacastuca lā' cāhuanilh: ―Ixuī' kalhatin chi'xcu' a'ntī cha'nli mayāc a'ntū māstā' uvas. Lā' līcorralhui'līlh chihuix ixti'ya't lā' cāxtlahualh ixpūchi'tni' lā' yāhualh lakatin torre a'ntū napūmaktaka'lha ixpū'uva. ’Lā' ā'calīstān cāmāsācua'nīlh ixti'ya't makapitzīn tasācua'nī'n para natascuja i'tātna'. Lā' xla' a'lh tachoko makat. ");
INSERT INTO tooNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lā' a'xni'ca' chilhtza' ixpūlan uvas, macā'lh ixlacscujni' na ixpū'uva. A'lh cāsqui'ni' huan tasācua'nī'n catamacamaxquī'lh huan a'ntūn tamakalanī't a'ntū ixla' ixtēcu' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero huan tasācua'nī'n tachi'palh huan lacscujni' lā' tatucsli lā' chu chuntza' tamāspi'tchokolh. Tū' maxquī'ca nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Lā' huan ixtēcu' pū'uva chu macā'mpā ā'kalhatin ixlacscujni'. Lā' huan tasācua'nī'n tamūta'lalh lā' talakapalalh lā' chu chuntza' tamacā'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Lā' huan ixtēcu' macā'mpā ā'chā'tin lā' tamaknīlh xla'. Lā' huan ixtēcu' cāmacā'mpā lhūhua' ā'makapitzīn. Huan tasācua'nī'n talacnicui'līlh makapitzīn lā' tamaknīlh ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’A'xmān kalhatin ixuī'cus a'ntīn tzē namacā'ncan, lā' ū'tza' ixo'kxa' a'ntī lej ixpāxquī'. Lā' xla' ā'xmān macā'lh lā' hualh: “Ka'lhī que nata'a'cnīni'ni' qui'o'kxa'”. ");
INSERT INTO tooNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero huan tasācua'nī'n talāhuanilh: “U'tza' huan a'ntī nalītachoko ixlīhuāk a'ntū ka'lhī ixtāta'. Camaknīuj lā' chuntza' quilaca'n nala huan pū'uva”. ");
INSERT INTO tooNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Lā' tachi'palh lā' tamaknīlh lā' tamaka'lh ixquilhtūn huan pū'uva. ");
INSERT INTO tooNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Lā' Jesús cākalhasqui'nīlh: ―¿Chī puhua'nā'tit? ¿Tuchū nacātlahuani' huan tamā'na' a'ntīn tamaksācua'lh? Na'a'n lā' nacāmāsputūkō' huā' tamā'na tasācua'nī'n lā' nacāmāsācua'nī huan pū'uva ā'makapitzīn xtunc tasācua'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Chā tū' maktin lakapūtle'kenī'ta'ntit na ixtachihuīn Dios ixpālacata ixO'kxa'? Xla' hua'chi huan chihuix a'ntū lītzo'kcanī't lā' chuntza' huan: Huan xakana'nī'n talakmaka'lh huan chihuix lā' māni' ū'tza' lanī't huan chihuix a'ntū más tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Chuntza' tlahualh huan Māpa'ksīni' lā' quina'n iclē'cnīyāuj. ");
INSERT INTO tooNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Lā' ixtā'ca'tza Jesús titachi'pacu'tulh como tamāchekxīlh que xlaca'n ixtalītalacastuca hua'chi huan tasācua'nī'n nac pū'uva. Lā' como ixtajicua'ni' tachi'xcuhuī't, ū'tza' talīmakxtekli lā' ta'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lā' cālakmacā'nca Jesús ā'makapitzīn fariseosnu' lā' ixchi'xcuhuī'n Herodes. Cālakmacā'nca para natakaxmatxtu catūhuā a'ntūn tzē natalē'ksa'nīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Lā' a'xni'ca' talakchā'lh, tahuanilh: ―Mākalhtō'kē'ni', icca'tzīyāuj que hui'x hua'na' a'ntū stu'ncua'. Hui'x tū' tlahua'ni'ya' cuenta a'nchī talīchihuīna'nāni' tachi'xcuhuī't. Lā' chu a'cxtim cālaktzī'na' ixlīhuākca'n tachi'xcuhuī't. Lā' hui'x xa'nca māsu'yu'ya' a'nchī Dios lacasqui'n. ¿Chā līmakuan na'icmāpalayāuj a'ntū māta'jīni'n huan emperador o tū' tasqui'nī? ");
INSERT INTO tooNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Lā' Jesús ixca'tzī que xmān ixtalīlaktzī'ncu'tun lā' cākalhasqui'nīlh: ―¿A'chī' quilālīlaktzī'ncu'tunāuj? Caquilālīmini'uj lakatin tumīn para na'iclaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Lā' talīmini'lh lakatin denario a'ntū ixtumīnca'n lā' Jesús cākalhasqui'nīlh: ―¿Tichū ixlacan tasu'yu nac huā'mā' tumīn lā' tichū ixtacuīni' tatzo'kni'? Lā' xlaca'n tahuanilh: ―Ixla' huan emperador. ");
INSERT INTO tooNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Lā' tuncan Jesús cāhuanilh: ―Pues camacamaxquī'tit huan emperador a'ntū ixla' lā' camacamaxquī'tit Dios a'ntū ixla'. Lā' xlaca'n lej talē'cnīlh a'nchī cākalhtīlh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lā' talakmilh Jesús saduceosnu'. Xlaca'n tamāsu'yu que tū' catilakahuanchokoca. Lā' ū'tza' talīhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mākalhtō'kē'ni', Moisés quincāmāchokoni'ni' huā'mā' tatzo'kni': Palh nanī kalhatin chi'xcu' a'ntīn tapūchahuanī'ttza', lā' palh nīmaka'n ixpuscāt lā' palh tintī' ixcaman, maclacasqui'n que huan lakapūt natā'tapuchahua ixyāsta' a'ntī xastancu. Lā' huan xapū'la o'kxa' a'ntī nalacatuncuī nala ixo'kxa' huan xapuxcu' a'ntī nīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ixa'nan kalhatojon lītā'timīn. Lā' xapuxcu' tapūchahualh lā' tū' ixka'lhī ixcaman a'xni'ca' nīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lā' kalhatin ī'stancu tā'tapūchahualh huan lakapūt lā' nā xla' nīlh lā' tū' ka'lhīlh ixcaman. Lā' chuntza' pātle'keni'lh ā'kalhatin ī'stancu a'xni'ca' tā'tapūchahualh huan lakapūt. ");
INSERT INTO tooNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chuntza' kalhatunu' de ixkalhatojonca'n tatā'tapūchahualh huan puscāt lā' tū' taka'lhīlh ixcamanca'n a'xni'ca' tanīlh. Lā' a'xmān nīlh huan puscāt. ");
INSERT INTO tooNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lā' a'xni'ca' nalakahuanchokocan, ¿tichū ixla' nala huanmā' puscāt? Ixkalhatojonca'n ixtatā'tapūchahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Lā' Jesús cākalhtīlh: ―U'tza' līta'a'kxokonī'ta'ntit mē'cstuca'n como tū' ca'tzīyā'tit a'ntūn tatzo'kni' huan na ixtachihuīn Dios lā' nīn tū' māchekxī'yā'tit chī huanī't ixlīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lā' a'xni'ca' huan nīnī'n natalakahuanchoko, tū' catitapūchahuaca lā' nīn tū' catitamāstā'lh ixtzu'ma'janca'n para natatapūchahua. Xlaca'n natala hua'chi ixángeles Dios xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lā' Moisés tzo'kli ixpālacata a'ntī natalakahuanchoko a'xni'ca' tzo'kli ixpālacata huan pūtzina'j qui'hui' a'ntū ixlamamā'. ¿Chu tū' lakapūtle'kenī'ta'ntit a'ntū Dios huanilh Moisés? Chuntza' hualh: “Quit ixDiosca'n Abraham lā' Isaac lā' Jacob”, hualh. ");
INSERT INTO tooNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","U'tza' huanicu'tun que xlaca'n lakahuan a'yuj tanīlh de makāntza' lā' Dios ū'tza' ixDiosca'n xalakahuan lā' tū' huan xanīnī'n. Hui'xina'n lej ta'a'kxokoyā'tit mē'cstuca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lā' cālakmilh Jesús kalhatin xamākalhtō'kē'ni' huan ley lā' cākaxmatli a'ntī ixtalāsta'lamā'na. Lā' ca'tzīlh que Jesús xa'nca cākalhtīlh. Lā' tuncan kalhasqui'nīlh: ―¿Tuchūyā līmāpa'ksīn más tasqui'nī? ");
INSERT INTO tooNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Lā' Jesús kalhtīlh: ―Huan līmāpa'ksīn a'ntū más tasqui'nī, ū'tza' huā'mā': “Cakaxpa'ttit hui'xina'n israelitas. Huan Māpa'ksīni' quinDiosca'n xmān ū'tza' Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Lā' napāxquī'ya' huan Māpa'ksīni' a'ntī minDios con ixlīhuāk mi'a'clhcunuc lā' con ixlīhuāk mintapāstacna' lā' mintahuixcān”. ");
INSERT INTO tooNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lā' ixlīlakatu' līmāpa'ksīn ū'tza' huā'mā': “Napāxquī'ya' ā'kalhatin chu a'cxtim hua'chi mē'cstu pāxquī'ca'na'”. Tū' a'nan ā'lakatin līmāpa'ksīn a'ntū más tasqui'nī que huā' tamā'na. ");
INSERT INTO tooNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Lā' tuncan xamākalhtō'kē'ni' huan ley huanilh: ―Lej stu'ncua' a'ntū' hua'na', Mākalhtō'kē'ni'. Huī' kalhatin Dios lā' xla' xmān ixa'cstu Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Lā' tasqui'nī napāxquī'yāuj con ixlīhuāk qui'a'clhcunucca'n lā' con ixlīhuāk quintapāstacna'ca'n lā' quintahuixcānca'n. Nā tasqui'nī napāxquī'yāuj ā'kalhatin chu a'cxtim hua'chi quē'cstuca'n quincātapāxquī'yāni'. Palh chuntza' natlahuayāuj, ū'tza' līhua'ca' xatzey que na'a'ksajuī'yāuj Dios a'ntū lhcuyucan o maknīcan. ");
INSERT INTO tooNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Lā' Jesús cuenta tlahualh a'nchī xa'nca pāstacli lā' kalhtīlh xamākalhtō'kē'ni' huan ley. Lā' Jesús huanilh: ―Tisputni'yāni' xmān macsti'na'j para natapa'ksī'ya' con Dios. Lā' tintī'tza' ixkalhasqui'nīcu'tun nīn tuntū' como ixtajicua'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lā' Jesús ixcāmāsu'ni'mā' huan tachi'xcuhuī't nac xaka'tla' lītokpān lā' cāhuanilh: ―Cristo ū'tza' a'ntī Dios hui'līlh ixlīmāpūtaxtunu'. Lā' ¿a'chī' tahuan huan xamākalhtō'kē'ni'nī'n huan ley que Cristo ī'xū'yātā'nat David? ");
INSERT INTO tooNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Māni' David hualh chu a'nchī māsu'ni'lh Espíritu Santo lā' chuntza' tzo'kli: Huan Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' quimpāxtūcāna'j hasta a'xni'ca' na'iccātlajakō' ixlīhuākca'n mintā'ca'tza” ―huan pāxtūcāna'j a'nlhā a'cnīni'ni'can―. ");
INSERT INTO tooNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Palh David līchihuīna'lh ī'xū'yātā'nat lā' māpācuhuīlh ixMāpa'ksīni', ū'tza' huanicu'tun que xla' līhua'ca' xaka'tla' nala ―hualh Jesús. Lā' chu catīhuāyā tachi'xcuhuī't līpāxūj takaxmatli. ");
INSERT INTO tooNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Lā' a'xni'ca' Jesús ixcāmāsu'ni'mā' huan tachi'xcuhuī't, ixcāhuani': ―Catamaktaka'lhtit lā' tū' nacāta'a'kxokoyāni' huan xamākalhtō'kē'ni'nī'n ley a'ntīn tapūlatā'kchokocu'tun pūlhmā'n ixtakēnu'ca'n hua'chi a'ntī lej taca'tzī. Nā talacasqui'n que cacātā'chihuīna'nca lā' cacā'a'cnīni'ni'ca nac cā'tejen. ");
INSERT INTO tooNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lā' na ixlītokpānca'n israelitas xlaca'n taputza pūtahuī'lh a'ntū tahui'lāna' calacan lā' talacasqui'n que cacā'a'cnīni'ni'ca a'nlhā tlahuacan cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Lā' xlaca'n ta'a'kxokomaklhtī ixchicca'n lakapūtnu' lā' ā'calīstān lej xlīt takalhtō'ka' a'nlhā nacālaktzī'ncan lā' chuntza' talī'a'kxokonu'n. A'chulā' natapātīni'n que ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lā' Jesús tahuī'lh na ixlacapūn a'nlhā ixmojōcan tumīn a'ntū a'ksajcan Dios. Lā' ixcālaktzī'mā' huan tachi'xcuhuī't a'xni'ca' ixtamojō ixtumīnca'n. Lā' lhūhua' ricosnu' tamojōlh lhūhua' ixtumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Lā' milh kalhatin lakapūt; lej pobre ixuanī't. Lā' xla' cāmojōlh lakatu' ixtumīn de cobre; xmān macsti'na'j ixtapalh. ");
INSERT INTO tooNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Lā' Jesús cāta'sani'lh ī'sca'txtunu'nī'n lā' cāhuanilh: ―Ixlīstu'ncua' iccāhuaniyāni' que a'ntū mojōlh huā'mā' pobre lakapūt līhua'ca' ixtapalh na ixlacapūn Dios que a'ntū tamojōlh huan ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Xlaca'n tamojōlh xmān a'ntū ixcā'a'katāxtūni'nī'ttza' como xlaca'n lacricos. Lā' huan puscāt, xla' a'yuj sputni' ixlīhua't, pero māstā'kō'lh ixlīhuāk a'ntū ixpūlatahuī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Lā' a'xni'ca' Jesús ixtaxtumā' de nac xaka'tla' lītokpān, kalhatin de ī'sca'txtunu'nī'n huanilh: ―Mākalhtō'kē'ni', cala'ktzi'. Lej tzēhuanī't huan chihuix a'ntū lītlahuacanī't huā'mā' xaka'tla' lītokpān. Lej xa'nca taxtucha'. ");
INSERT INTO tooNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Lā' Jesús kalhtīlh: ―Calaktzī'ntit ixlīhuāk huā'mā' a'ntū ixla' huan lītokpān. Tū' catitachokolh nīn lakatin chihuix nac taxaka. Ixlīhuākca'n natapanckō' lā' huan taxaka nalacla. ");
INSERT INTO tooNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Lā' Jesús tahuī'lh na ixtūtzā'n huan o'kspū'n a'nlhā huanican Olivos lā' na ixlacapūn xaka'tla' lītokpān. Lā' Pedro lā' Jacobo lā' Juan lā' Andrés tzē'k takalhasqui'nīlh: ");
INSERT INTO tooNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Iclacasqui'nāuj naquilāhuaniyāuj lhānīn napātle'ke huā' tamā'na. ¿Chichū na'iclīca'tzīyāuj palh palaj napātle'ke a'ntū hua'nti? ");
INSERT INTO tooNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Lā' Jesús tzuculh cāhuani: ―Catamaktaka'lhtit para que nīn tintī' nacā'a'kxokoyāni' ");
INSERT INTO tooNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","como lhūhua' chi'xcuhuī'n natahuan palh taka'lhī quilīmāpa'ksīn. Lā' chā'tunu' natahuan: “Quit Cristo a'ntī Dios lacsacui'līlh”. Lā' chuntza' lhūhua' a'ntī nacā'a'kxokocan. ");
INSERT INTO tooNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Lā' nakaxpa'tā'tit a'nchī sā'nan a'nlhā pajtzu tlahuamā'ca guerra lā' nacātamāca'tzīnīyāni' a'nchī lamā'cha' guerra makat. Tū' tijicua'nā'tit. Chuntza' ka'lhī que napātle'ke. Lā' tūna'j cati'a'ksputli. ");
INSERT INTO tooNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lakatin gobierno natā'kaquī' contra ā'kalhatin. Lā' kalhatin māpa'ksīni' natlajacu'tun ā'kalhatin. Lā' lakachu natachiqui huan ti'ya't lā' na'a'nan tatzi'ncsta. Lā' ixlīhuāk huā'mā' xmān ixlītzucuni' a'nchī napātīni'ncan. ");
INSERT INTO tooNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Cuenta catlahua'tit como nacātamacamāstā'yāni' con huan pūchihuīna'nī'n lā' nacātakēsno'kāni' nac lītokpānna'. Lā' por quimpālacata nacātalē'nāni' na ixlacapūnca'n huan gobernadores lā' na ixlacapūnca'n māpa'ksīni'nī'n. Chuntza' nachihuīna'nā'tit por quimpālacata. ");
INSERT INTO tooNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","’A'xni'ca' tūna'j nasputa huā'mā' quilhtamacuj, tasqui'nī nacāmāsu'ni'can huan xatzey tachihuīn huan tachi'xcuhuī't chuxalhā nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Lā' a'xni'ca' nacātachi'payāni' lā' nacātamacamāstā'yāni' con huan pūchihuīna'nī'n, tū' catilē'capintit pū'la a'nchī nalītamaktāyayā'tit. Nahua'nā'tit a'ntū puhua'nā'tit a'xni'ca' nachā'n huanmā' hora. Tū' māni' hui'xina'n catichihuīna'ntit. Huan Espíritu Santo nacāmāchihuīnīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Lā' a'ntī quintakalhlaka'ī' nacāmacamāstā'can con huan pūchihuīna'nī'n. Lā' māni' ixtā'tinca'n a'ntī natamacamāstā' para nacāmaknīcan. Lā' huan xanatātana' natamacamāstā' ixcamana'ca'n a'ntīn takalhlaka'ī' para nacāmaknīcan. Lā' huan camana' nata'a'kchā'ni' ixtāta'ca'n lā' ixtzī'tca'n a'ntīn takalhlaka'ī' lā' natamāmaknīnīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lā' ixlīhuākca'n tachi'xcuhuī't nacātaca'tzalaktzī'nāni' lā' xmān por quimpālacata. Lā' huan a'ntī natatāyani' hasta a'xni'ca' natanī, xlaca'n nacāmāpūtaxtūcan. ");
INSERT INTO tooNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nalaktzī'nā'tit huā' xako'hua'jua' a'ntū nalactlahuakō' lā' natāya a'nlhā tū' līmakuan chu a'nchī tzo'knulh huan profeta Daniel. Lā' quit a'ntī ictzo'kmā' huā'mā', iccāhuaniyāni' hui'xina'n a'ntī lakapūtle'kepā'na'ntit que cuenta catlahua'tit. A'xni'ca' nalaktzī'nā'tit huanmā', a'xni'ca' maclacasqui'n que natatzā'la hasta nac o'kspū'n xlaca'n a'ntīn tahui'lāna' nac estado de Judea. ");
INSERT INTO tooNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lā' huanmā' chi'chini' a'xni'ca' natayuja huan a'ntīn tahui'lāna' na ixa'kstīn ixchicca'n, tū' catitatanūlh huan nac chic para natamāxtu catūhuā a'ntū ixla'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lā' huan a'ntīn tascujmā'na nac cā'tacuxtu tū' catitataspi'tli na ixchicca'n para natataya ixtakēnu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Xānti tala huan puscan huan tamā'na chi'chini' palh tacamalanī't o palh tamātzi'quī'ni'ncus. ");
INSERT INTO tooNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","’Casqui'ni'tit Dios que tū' tasqui'nī natzā'la'yā'tit a'xni'ca' lonknu'n. ");
INSERT INTO tooNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Lā' lej napātīni'ncan a'xni'ca' nala huā'mā'. Desde a'xni'ca' Dios mā'a'nanīlh huā'mā' quilhtamacuj, tū' maktin pātīni'ncanī't a'nchī napātīni'ncan huanmā' chi'chini'. Lā' tū'tza' maktin catilalh ixtā'chuntza' ā'calīstān. ");
INSERT INTO tooNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lā' palh Dios tū' ixmāti'na'jīlh huā'mā' tiempo, tū' ixtapūtaxtulh nīn tintī'. Dios namāti'na'jī como lej cālakalhu'man xlaca'n a'ntī cālacsacnī't. ");
INSERT INTO tooNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Lā' a'xni'ca' namin huanmā' līpātīn lā' palh catīhuā ixcāhuanini': “Chā calaktzī'ntit. A' huī' huan Cristo a'ntī Dios lacsacui'līlh”, tū' catikalhlaka'ī'tit. Lā' palh catīhuā ixcāhuanini': “Chā calaktzī'ntit. A'jnanu' yā”, tū' catikalhlaka'ī'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Natamin lhūhua' a'kxokonu'nī'n lā' makapitzīn natahuan que māni' xlaca'n Cristo lā' ā'makapitzīn natahuan que māni' xlaca'n ixa'cta'sana'nī'n Dios. Lā' nā natatlahua lē'cnīn como nata'a'kxokocu'tun māni' xlaca'n a'ntīn Dios cālacsacli. Tūlalh catita'a'kxokolh a'ntī Dios cālacsacli pero nacā'a'kxokocan ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Skalalh cala'tit. Iccāhuanini'tza' ixlīhuāk huā'mā' para que tū' nacāta'a'kxokoyāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lā' Jesús cāhuanipā: ―Lā' huan tamā'na chi'chini' a'xni'ca' napātle'ketza' huā'mā' līpātīn, huan chi'chini' lā' huan mālhcuyu' tū' catitamāxkakēni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lā' huan sta'cu nataminācha' de nac a'kapūn lā' māni' huan a'kapūn natachiqui. ");
INSERT INTO tooNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Lā' tuncan nalaktzī'ncan huan Chi'xcu' xala' Tālhmā'n a'nchī napūmin huan poklhnu'. Lej naka'lhī līmāpa'ksīn lā' tzēhuanī't naxkaka. ");
INSERT INTO tooNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lā' tuncan nacāmacamin ixángeles lā' natamākēstoka a'ntī cālacsaccanī't. Natamin a'ntī cālacsaccanī't xalanī'n cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Camaksca'ttit catūhuā de huan xaqui'hui' higo. A'xni'ca' tza'la'nka' ixpeken lā' tzucumā' tapu'n xachi'tin, hui'xina'n ca'tzīyā'tit que tapajtzūmā'tza' a'xni'ca' lej naxu'nu. ");
INSERT INTO tooNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lā' chuntza' a'xni'ca' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuaniyāni', naca'tzīyā'tit que tapajtzūmā'tza' a'xni'ca' nasputa huan quilhtamacuj. Tapajtzūmā'tza' hua'chi kalhatin a'ntī ka'lhīmā'ca lā' yātza' na ixlacapūn huan mākalhcha. ");
INSERT INTO tooNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Stu'ncua' a'ntū iccāhuaniyāni'. Xlaca'n a'ntīn tahui'lāna'cus tū' catitanīkō'lh hasta a'xni'ca' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuanini'. ");
INSERT INTO tooNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nasputa huan a'kapūn lā' nasputa huan ti'ya't pero tū' maktin catisputli quintachihuīn; natlōkentaxtūkō'can. ");
INSERT INTO tooNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Nīn tintī' ca'tzī lhānīn namin huā'mā' chi'chini' o huā'mā' hora; nīn huan ángeles xalanī'n nac a'kapūn tū' taca'tzī. Lā' nīn ixO'kxa' Dios tū' ca'tzī. Xmān Dios xaTāta' ca'tzī lhānīn mero napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Skalalh cala'tit como tū' ca'tzīyā'tit lhānīn napātle'ke huā'mā'. ");
INSERT INTO tooNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","U'tza' hua'chi kalhatin chi'xcu' a'ntī na'a'n latā'kchoko makat. Lā' cālīmāmacū'tā'quī' ixchic huan ixtasācua'nī'n lā' cāmaxquī' ixlītlōtca'n chā'tunu'. Lā' yāhua kalhatin maktaka'lhna' nac tanquilhni' lā' māpa'ksī que skalalh nala. ");
INSERT INTO tooNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chuntza' hui'xina'n skalalh cala'tit como tū' ca'tzīyā'tit lhānīn namin ixtēcu' chic. Tzēlasā' namin cā'smalanka'n, o a'xni'ca' chū'cus nata'sa huan gallo, o i'tāt tzī'sa, o tuncuīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","U'tza' skalalh calīla'tit para que tū' lhtatapā'na'ntit a'xni'ca' chu līmaktin namin. ");
INSERT INTO tooNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iccāhuaniyāni' hui'xina'n: Skalalh cala'tit. Lā' nā skalalh catalalh ixlīhuākca'n tachi'xcuhuī't ―cāhuanilh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I'sputacus lakatu' chi'chini' para huan cā'tani' a'ntū huanican pascua a'xni'ca' hua'can pāntzi a'ntūn tū' ka'lhī levadura. Lā' xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley ixtaputzamā'na a'nchī natalī'a'kxoko Jesús para natachi'pa lā' natamāmaknīnīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Lā' talāhuanilh: ―Palh natlahuayāuj catūhuā līhuan lamā' cā'tani', huan tachi'xcuhuī't natatā'kaquī'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Lā' Jesús ixuī' nac Betania na ixchic Simón. U'tza' huā'mā' Simón a'ntī ixmasni'mā' ixquinī't lā' ixtzeyanī'ttza'. Lā' a'xni'ca' Jesús ixuā'yamā' a'ntza', kalhatin puscāt laktapajtzūlh. Ixlē'mā' pātin frasco a'ntū ixlītzuma aceite a'ntū lej xatapala lā' lej mu'csa ixuanī't. Lā' ū'tza' a'ntū huanican nardo. Huan puscāt pa'klhli huan frasco lā' mūmā'ca'lh Jesús huan aceite. ");
INSERT INTO tooNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Lā' makapitzīn a'ntī ixtahui'lāna' talī'a'kchā'lh lā' talāhuanilh: ―Lā' ¿a'chī' pāxcat līlalh huā'mā' aceite? ");
INSERT INTO tooNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ixtapalh hua'chi ixtatlaj kalhatin chi'xcu' xatascujāt de lakatin cā'ta. Tzē ī'stā'ca lā' huan tumīn tzē ixcāmaxquī'ca huan pobresni'. Lā' taquilhnīlh huan puscāt. ");
INSERT INTO tooNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Lā' Jesús cāhuanilh: ―Camakxtektit. ¿A'chī' mājiclhuī'yā'tit huā'mā' puscāt? Quintlahuani'lh a'ntū lej tzey. ");
INSERT INTO tooNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pō'ktu na'a'nan pobresni' na milaclhpu'nanca'n. Lā' a'xni'ca' lacasqui'nā'tit, tzē nacātlahuani'yā'tit a'ntūn tzey. Pero quit tū' pō'ktu na'iccātā'latahui'layāni'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Huan puscāt tlahualh a'ntūn tzē ixtlahua. Quimūmā'ca'lh aceite lā' chuntza' quincāxtlahualīlhtza' como naquimā'cnūcan. ");
INSERT INTO tooNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Stu'ncua' a'ntū iccāhuaniyāni'. Chuxalhā nac cā'quilhtamacuj a'nlhā namāca'tzīnīni'ncan huan xatzey tachihuīn ixpālacata Cristo, a'ntza' nahuancan a'ntūn tlahualh huā'mā' puscāt. Lā' ū'tza' ixlīhuākca'n natalīpāstaca xla' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote kalhatin de huan ixlīkalhacāujtu' sca'txtunu'nī'n ixuanī't. Lā' xla' cālaka'lh xanapuxcu'nu' curasna' para nacāhuani que ixcāmacamaxquī'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lā' a'xni'ca' takaxmatli a'ntū cāhuanica, tapāxuhualh lā' tahuanilh palh natamaxquī' tumīn. Lā' Judas ixputza a'nchī ixlīmacamāstā'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Milh huan xapū'lh chi'chini' de huan cā'tani' a'xni'ca' hua'can pāntzi a'ntūn tū' ka'lhī levadura. Huā'mā' chi'chini' a'xni'ca' maknīcan huan borrego a'ntū nahua'can para huā'mā' cā'tani' a'ntū huanican pascua. Lā' ī'sca'txtunu'nī'n takalhasqui'nīlh Jesús: ―¿Lhachū lacasqui'na' na'ica'nāuj na'iccāxtlahuayāuj para nahua'yāuj huan xalīhua't huan cā'tani'? ");
INSERT INTO tooNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Lā' cāmacā'lh kalhatu' ī'sca'txtunu'nī'n lā' cāhuanilh: ―Capintit huan nac cā'lacchicni' lā' napāxtokā'tit kalhatin chi'xcu' a'ntī lē'mā' ixpūxka'tni'. Nastālani'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Lā' a'nlhā xla' natanū, nā natanū'yā'tit lā' nahuaniyā'tit ixtēcu' huan chic: “Huan Mākalhtō'kē'ni' huan: ¿Lhachū yā huan cuarto a'nlhā tzē na'iccātā'hua' quisca'txtunu'nī'n huan xalīhua't cā'tani' de pascua?” ");
INSERT INTO tooNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Lā' māni' xla' nacāmāsu'ni'yāni' lakatin cuarto ixlītanca'cstu' chic. Lā' ka'tla' huan cuarto lā' cāxni'j yātza'. A'ntza' nacāxtlahua'yā'tit quilīhua'tca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Lā' ta'a'lh ī'sca'txtunu'nī'n lā' tatanūlh nac cā'lacchicni'. Lā' pātle'kelh chu a'nchī Jesús ixcāhuaninī't lā' tacāxtlahualh huan līhua't. ");
INSERT INTO tooNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lā' a'xni'ca' ixtā'cnūmā'tza' huan chi'chini', Jesús cātā'chā'lh ī'sca'txtunu'nī'n a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lā' līhuan ixtahuā'yamā'na, Jesús cāhuanilh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Kalhatin de hui'xina'n a'ntī quilātā'huā'yamā'nauj huā'tzā' naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lā' xlaca'n tatzuculh talakaputza lā' chā'tunu' de xlaca'n takalhasqui'nīlh: ―¿Chu quit? ");
INSERT INTO tooNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Lā' Jesús cākalhtīlh: ―Kalhatin de hui'xina'n de milīkalhacāujtu'ca'n māni' xla'. U'tza' a'ntīn quintā'pūhuā'yan huā' pulātu. ");
INSERT INTO tooNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Quit huan Chi'xcu' xala' Tālhmā'n lā' naquimpātle'keni' chu a'nchī tatzo'kni' quimpālacata na ixtachihuīn Dios. Pero xānti la huan chi'xcu' a'ntī naquimacamāstā'; nalīlakaputza. Más tzey para xla' palh tū' ixlacatuncuīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Lā' līhuan ixtahuā'yamā'na, Jesús tayalh huan pāntzi lā' maxquī'lh pāxcatca'tzī Dios lā' mālacpitzilh lā' cāmaxquī'lh ī'sca'txtunu'nī'n. Lā' cāhuanilh: ―Cahua'tit. U'tza' huā'mā' quimacni'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Lā' tayalh huan taza lā' maxquī'lh pāxcatca'tzī Dios. Lā' macastī'n cāmaxquī'lh ī'sca'txtunu'nī'n lā' ixlīhuākca'n tapūko'tnūnkō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Lā' cāhuanilh: ―U'tza' huā'mā' quinka'lhni'. Lā' ū'tza' a'ntū līcāxtlahuacan huan xasāsti' convenio ixpālacata a'nchī Dios nacālīmāpūtaxtū tachi'xcuhuī't. Lā' quinka'lhni' ū'tza' a'ntū na'icmaka'n para nacāmāsputūnu'ni' ixtalaclē'i'ca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Stu'ncua' a'ntū iccāhuaniyāni'. Tū' ictihua'lh xaxcān uva hasta a'xni'ca' na'icua' ā'tāpātin xaxcān uva xasāsti' a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lā' a'xni'ca' ixtatlī'nī't lakatin himno, tataxtulh lā' ta'a'lh huan nac o'kspū'n a'nlhā huanican Olivos. ");
INSERT INTO tooNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Lā' Jesús cāhuanilh: ―Milīhuākca'n naquilā'a'kxtekmaka'nāuj ixpālacata a'ntū naquimpātle'keni' como chuntza' tatzo'kni' na ixtachihuīn Dios: “Na'icmaknī huan pastor lā' nata'a'kahuankō' huan borregos”, tatzo'kni'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Lā' a'xni'ca' naquimālakahuanīchokocan, xapū'la na'ica'n quit nac estado de Galilea. Lā' a'ntza' nalāpāxtokāuj. ");
INSERT INTO tooNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Lā' Pedro huanilh: ―A'yuj ixlīhuākca'n ā'makapitzīn nata'a'kxtekmaka'nāni', pero quit tū' ictimakxtekni'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Lā' Jesús huanilh: ―Stu'ncua' a'ntū icuaniyāni'. Chuhua'j huā'mā' tzī'sa a'xni'ca' tūna'j nata'sa ixlīmaktu' huan gallo, māni' hui'x naquinkalhtatzē'ka' maktu'tun. ");
INSERT INTO tooNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Lā' Pedro ā'chulā' stu'tu'lu' hualh: ―A'yuj naquintā'maknīca'na', pero quit tū' ictikalhtatzē'kni'. Lā' ixlīhuākca'n ā'makapitzīn chu a'cxtim tahualh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Lā' Jesús lā' ī'sca'txtunu'nī'n ta'a'lh nac lakatin lugar a'nlhā huanican Getsemaní. Lā' cāhuanilh: ―Catahui'la'tit hui'xina'n huā'tzā' līhuan quit na'ictā'chihuīna'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Lā' cālē'lh lacachuna'j Pedro lā' Jacobo lā' Juan. Lā' tzuculh tamakchuyī lā' lej pāta'lalh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Lā' cāhuanilh: ―Lej iclakaputza hasta tzē na'iclaknī huan talakaputzīt. Catachokotit huā'tzā' lā' skalalh catahui'la'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lā' Jesús a'lh lacachuna'j lā' tatzokostalh nac ti'ya't lā' squi'ni'lh Dios palh tzē ixpūtaxtulh de a'ntū napātle'keni' ");
INSERT INTO tooNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","lā' hualh: ―QuinTāta', palh tzē na'icpūtaxtu de huā' a'ntū na'icpātī, camakxtekti chuntza' nala. Pero calalh a'ntū hui'x lacasqui'na' lā' tū' calalh a'ntū xmān quit iclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lā' taspi'tchokolh a'nlhā ixcāmāchokonī't ī'sca'txtunu'nī'n lā' cālaktzī'lh lā' ixtalhtatahui'lāna'. Lā' huanilh Pedro: ―¿Chā lhtatahui'la', Simón? ¿Chu tūlalh tāyani'tit mintalhtataca'n nīn lakatin hora? ");
INSERT INTO tooNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Lakahuan catahui'la'tit lā' casqui'ni'tit Dios para que tū' nacātatlajayāni' a'xni'ca' nacātalīlaktzī'nāni'. Stu'ncua' mi'a'clhcunucca'n tatlahuacu'tun xatzey pero mimacni'ca'n tū' taka'lhī tahuixcān. ");
INSERT INTO tooNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lā' ixlīmaktu' a'lh lacachuna'j lā' chu a'cxtim squi'ni'lh Dios. ");
INSERT INTO tooNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lā' taspi'tchokopā a'nlhā ixcāmāchokonī't ī'sca'txtunu'nī'n lā' cālaktzī'lh lā' ixtalhtatahui'lāna'. Tūlalh tatāyani'lh ixtalhtataca'n lā' tū' ixtaca'tzī a'nchī natakalhtī. ");
INSERT INTO tooNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lā' a'xni'ca' ixlīmaktu'tun taspi'tchokolh a'nlhā ixcāmāchokonī't, cāhuanilh: ―¿Chā lhtatapā'na'ntitcus lā' jaxpā'na'ntitcus? Tzeytza'. Chilhtza' huan hora a'ntū lhcācanī't. Quit huan Chi'xcu' xala' Tālhmā'n lā' naquimacamāstā'can na ixlīmāpa'ksīnca'n huan tūn tū' tzeyā chi'xcuhuīn. ");
INSERT INTO tooNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Catāya'tit lā' cāhuitit; mimā'tza' huan a'ntī naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Lā' tuncan a'xni'ca' Jesús ixchihuīna'mā'cus, chā'lh Judas. Xla' kalhatin de huan kalhacāujtu' scā'txtunu'nī'n ixuanī't. Lā' tatā'chā'lh lhūhua' tachi'xcuhuī't lā' ixtalē'n ixmachītaca'n lā' qui'hui'. Lā' tachā'lh por ixquilhtampānca'n xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley lā' xanapuxcu'nu' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Lā' Judas ū'tza' a'ntī ixmacamāstā'mā' lā' xla' ixcāhuaninī'ttza' a'nchī natalīlakapasa tichū Jesús. Ixcāhuani'nī't: ―A'ntī na'iclacamu'su ū'tza' Jesús. Nachi'payā'tit lā' nalīpinā'tit lā' namaktaka'lhā'tit. ");
INSERT INTO tooNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Lā' a'xni'ca' chā'lh Judas, tuncan laktapajtzūlh Jesús lā' huanilh: ―Mākalhtō'kē'ni'. Lā' lacamu'sulh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Lā' huan tachi'xcuhuī't talaktapajtzūlh Jesús lā' tachi'palh para natalē'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Lā' ixyā kalhatin a'ntī ixtā'minī't Jesús. Xla' māxtulh ixmachīta lā' mātakāhuī'lh ixtasācua' huan xamāpa'ksīni' curasna' lā' a'kasityujulh ixa'ka'xkō'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Lā' Jesús cākalhasqui'nīlh: ―¿A'chī' līta'ntit mimachītaca'n lā' minqui'hui'ca'n? Hua'chilh chi'pacu'tunā'tit kalhatin ka'lhāna'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","A'xni'ca' xa'iccātā'latlā'huanāni' lakalīyān nac lītokpān, ¿a'chī' tūlalh quilāchi'pauj a'xni'ca'? Pero chuntza' naquimpātle'keni' para natlōkentaxtū a'ntū tzo'kcanī't na ixtachihuīn Dios ―cāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Lā' ixlīhuākca'n huan sca'txtunu'nī'n tatzā'lalh lā' chuntza' talī'a'kxtekmaka'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Lā' kalhatin o'kxa' stālani'lh. Tū' ixlhakā'nī't ixlu'xu'; xmān ixlītamaksna'tnī't kalhtin sábana. Lā' a'xni'ca' huan tachi'xcuhuī't tachi'palh, ");
INSERT INTO tooNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","lhka'lo'ko tzā'lalh lā' maka'lh huan sábana. ");
INSERT INTO tooNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lā' xlaca'n a'ntīn tachi'palh Jesús, talē'lh a'nlhā ixuī' huan xamāpa'ksīni' curasna'. Lā' talaktakēstokli ixlīhuākca'n xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas lā' xamākalhtō'kē'ni'nī'n ley. ");
INSERT INTO tooNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Lā' Pedro lakamakat stālani'lh lā' chā'lh hasta ixtanquilhni' huan ixchic xamāpa'ksīni' curasna'. Lā' tanūlh na ixcorral huan chic lā' cātā'tahuī'lh huan policíasna'. Lā' ixcātā'sko'huī' nac macscut con xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Huan xanapuxcu'nu' curasna' lā' ixlīhuākca'n xalaka'tla'n pūchihuīna'nī'n a'ntī ixtalacāxtlahua, xlaca'n ixtaputzamā'na a'nchī natalē'ksa'nīni'n Jesús para natalīmāmaknīnīni'n. Lā' tū' ixtakaksa a'ntūn tzē natalē'ksa'nīni'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Līlhūhua' talīchihuīna'lh a'ntūn tū' stu'ncua' ixpālacata Jesús, pero tū' chu a'cxtim tahualh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Lā' makapitzīn tatāyalh lā' ta'a'ksa'nīni'lh lā' tahualh a'ntūn tū' stu'ncua'. Chuntza' tahualh: ");
INSERT INTO tooNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Quina'n ickaxmatui a'nchī hualh: “Quit na'icmāsputūkō' ixlīhuāk huā'mā' xaka'tla' lītokpān a'ntū ixtatlaujca'n chi'xcuhuī'n. Lā' ixlīlakatu'tun chi'chini' na'ictlahua ā'lakatin a'ntūn tū' ixtatlaujca'n chi'xcuhuī'n”. ");
INSERT INTO tooNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nīn xlaca'n tū' chu a'cxtim tahualh. ");
INSERT INTO tooNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Lā' huan xamāpa'ksīni' curasna' tāyalh na ixlaclhpu'nanca'n lā' kalhasqui'nīlh Jesús: ―Huā' tayāna' chi'xcuhuī'n talī'a'ksa'nīni'mā'ni'. Lā' ¿chu tū' nakalhtīni'na'? ");
INSERT INTO tooNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Lā' Jesús ca'cs tāyalh lā' tuntū' kalhtīni'lh. Lā' huan xamāpa'ksīni' curasna' kalhasqui'nīpā: ―¿Chā hui'x huan Cristo a'ntī Dios lacsacnī't? ¿Chā hui'x ixO'kxa' Dios a'ntī quina'n ica'cnīni'ni'yāuj? ");
INSERT INTO tooNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Lā' Jesús kalhtīlh: ―U'huē. Quit Cristo. Lā' hui'xina'n naquilālaktzī'nāuj quit huan Chi'xcu' xala' Tālhmā'n na'ictahui'la na ixpāxtūcāna'j Dios a'ntī māpa'ksīni'mā'. Lā' na'icminācha' nac a'kapūn ixlaclhni' poklhnu'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lā' huan xamāpa'ksīni' curasna', māni' xla' xtī'tli ixlu'xu' lā' chuntza' līmāsu'yulh que lej ixa'kchā'n lā' hualh: ―Tū'tza' maclacasqui'nāuj ā'catīhuā para naquincāhuaniyāni' palh tū' tzey xla'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Hui'xina'n kaxpā'tnī'ta'ntit a'nchī tā'talacastuccu'tulh Dios. ¿Chī puhua'nā'tit? Lā' ixlīhuākca'n tamālaclē'nīlh para namaknīcan. ");
INSERT INTO tooNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lā' makapitzīn tatzuculh talakachojmanī. Lā' xlaca'n talacatlapalh lā' tatucsli lā' tahuanilh: ―Caquilhchipi tichū tucsni'. Lā' huan tropasna' a'ntī ixtamaktaka'lhmā'na nā xlaca'n tatucsli. ");
INSERT INTO tooNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Lā' Pedro ixyā na ixtanquilhni' huan chic lā' milh kalhatin tzu'ma'jāt a'ntī ixmaksquiti na ixchic huan xamāpa'ksīni' curasna'. ");
INSERT INTO tooNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Lā' a'xni'ca' laktzī'lh Pedro a'nlhā ī'sko'huī', huan tzu'ma'jāt lakalaktzī'lh lā' huanilh: ―Nā hui'x ixtā'latlā'hua'na' Jesús xala' nac Nazaret. ");
INSERT INTO tooNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero xla' kalhtatzē'kli lā' huanilh: ―Tū' icca'tzī tuchū huanicu'tuna'. Tū' icmāchekxī. Lā' a'lh lacachuna'j. Lā' ta'salh huan gallo. ");
INSERT INTO tooNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lā' huan tzu'ma'jāt chu laktzī'mpā lā' tzuculh cāhuani huan a'ntī ixtatā'yāna'ncha': ―U'tza' huā'mā' kalhatin de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Lā' Pedro kalhtatzē'kpā. Lā' ixlīka'tlā'tus huan a'ntī ixtatā'yāna'ncha' tahuanilh Pedro: ―Stu'ncua' hui'x kalhatin de xlaca'n como hui'x xala' nac estado de Galilea. Mintachihuīn ixtā'chuntza' a'ntī xalanī'n nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Lā' Pedro tzuculh macapūlhcācan ixa'cstu lā' stu'tu'lu' hualh: ―Dios naquimāpātīnī palh tū' stu'ncua' a'ntū icuanimā'ni'. Tū' iclakapasa huā'mā' chi'xcu' a'ntī līchihuīna'mpā'na'ntit. ");
INSERT INTO tooNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Lā' huan gallo ta'sapā ixlīmaktu'. Lā' ū'tza' līmāpāstaquīlh Pedro a'nchī Jesús ixuaninī't: “A'xni'ca' tūna'j nata'sa ixlīmaktu' huan gallo, hui'x naquinkalhtatzē'ka' maktu'tun”. Lā' a'xni'ca' Pedro pāstacli chuntza', tzuculh calhuan. ");
INSERT INTO tooNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Lā' a'xni'ca' tuncuīlh, huan xanapuxcu'nu' curasna' lā' xanapuxcu'nu' israelitas lā' xamākalhtō'kē'ni'nī'n huan ley lā' ā'makapitzīn pūchihuīna'nī'n tatakēstokli lā' talacchihuīna'lh. Lā' tapekechī'lh Jesús lā' talē'lh lā' tamacamaxquī'lh huan Pilato a'ntī gobernador ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Lā' Pilato kalhasqui'nīlh: ―¿Chu hui'x ixReyca'n israelitas? Lā' xla' kalhtīlh: ―Chu chuntza' a'nchī hua'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lā' xanapuxcu'nu' curasna' ixtalē'ksa'nīni'n de lhūhua' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Lā' Pilato kalhasqui'nīpā: ―¿A'chī' tū' kalhtīni'na' nīn tuntū'? Kaxpa'tti ixlīhuāk a'ntūn talē'ksa'nīni'ni'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús tū'tza' kalhtīlh. Lā' ū'tza' līlē'cnīlh Pilato. ");
INSERT INTO tooNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Lā' ixa'nan lakatin talanān a'xni'ca' ixla cā'tani'. Pilato ixmakxteka kalhatin tachī'n. Lā' huan tachi'xcuhuī't ixtalacsaca huan tachī'n a'ntī namakxtekcan. ");
INSERT INTO tooNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Lā' ixtatanūmā'na nac pūlāchī'n makapitzīn a'ntī ixtatā'kaquī'nī't contra huan gobierno lā' ixtamaknīni'nī't a'xni'ca' tatā'kaquī'lh. Lā' kalhatin de huan tachī'nī'n ixuanican Barrabás. ");
INSERT INTO tooNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huan lhūhua' tachi'xcuhuī't talaktapajtzūlh Pilato lā' tatzuculh tasqui'ni' que catlahualh chu a'nchī lanān ixtlahua līhuan ixlamā' cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Lā' Pilato cākalhtīlh: ―¿Chā lacasqui'nā'tit na'iccāmakxtekni'yāni' ixReyca'n israelitas? ");
INSERT INTO tooNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato māchekxīlh a'nchī huan xanapuxcu'nu' curasna' ixtalakca'tzani' Jesús lā' ū'tza' talīmacamāstā'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Lā' huan xanapuxcu'nu' curasna' ixtacuccha'xnī't huan tachi'xcuhuī't lā' ū'tza' talīsqui'nli Barrabás. ");
INSERT INTO tooNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Lā' Pilato cākalhtīpā lā' cākalhasqui'nīlh: ―Lā' ¿tuchū lacasqui'nā'tit na'ictlahua con xla' a'ntī māpācuhuī'yā'tit ixReyca'n israelitas? ");
INSERT INTO tooNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Lā' xlaca'n tata'salh lā' palha' tahuanilh: ―¡Caxtokohua'ca'ca nac cruz! ");
INSERT INTO tooNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Lā' Pilato cākalhasqui'nīlh: ―Lā' ¿a'chī'? ¿Tuchū tlahuanī't? Pero xlaca'n ā'chulā' tata'salh lā' palha' tahuanilh: ―¡Caxtokohua'ca'ca nac cruz! ");
INSERT INTO tooNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Lā' como Pilato ixcāmāko'xamixīcu'tun huan lhūhua' tachi'xcuhuī't, cāmakxtekni'lh huan Barrabás. Lā' māpa'ksīni'lh que cakēsno'kca huan Jesús lā' macamāstā'lh para naxtokohua'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lā' tuncan ixtropasna' huan gobernador talē'lh Jesús na ixchakān pūchihuīn a'nlhā huanican pretorio. Lā' cāmākēstokca ā'makapitzīn tropasna'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lā' tamālhakē'lh lakatin ixlu'xu' xasmumonko' lā' tatlahualh lakatin corona de lhtucū'n lā' tamūhui'līlh. ");
INSERT INTO tooNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Lā' tatzuculh tahuani: ―Ca'a'cnīni'ni'ca ixReyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Lā' talīmūnicli qui'hui' lā' tachojmanīlh. Lā' tatatzokostani'lh hua'chilh ixta'a'cnīni'ni'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Lā' a'xni'ca talīlītzī'nkō'lh chuntza', tamāmakxtulh ixlu'xu' xasmumonko' lā' tamālhakē'chokolh ixlu'xu' a'ntū ixla' ixuanī't. Lā' talē'lh para naxtokohua'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Lā' a'xni'ca' ixta'a'mā'na, ixtētaxtumā' kalhatin chi'xcu' xala' nac Cirene a'ntī ixtacuīni' Simón. Xla' ixtāta'ca'n Alejandro lā' Rufo lā' ixmimā'cha' de nac rancho. Lā' huan tropasna' tasāmācu'quī'lh ixcruz Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Lā' ta'a'lh lā' tachā'lh nac lakatin lugar a'nlhā huanican Gólgota a'ntū huanicu'tun Ixa'kxāk Nīn. ");
INSERT INTO tooNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Lā' Jesús mālacnūni'ca vino para nahua'. Lā' ixtā'tlahuapāspi'tcanī't līcu'chu'ni' a'ntū huanican mirra. U'tza' ixlīmālhtatīcu'tuncan. Lā' Jesús tū' maklhtīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Lā' a'xni'ca' ī'xtokohua'ca'canī'ttza', huan tropasna' tamālacpitzilh ixlu'xu' Jesús lā' tapūmāxtulh ī'suerteca'n para nataca'tzī tuchū nacātachokoni' chā'tunu' de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lā' hua'chi makna'jās cuhuīni' ixuanī't a'xni'ca' xtokohua'ca'ca. ");
INSERT INTO tooNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Lā' ixtzo'kcanī't a'ntū ixpālacata līxtokohua'ca'ca lā' ixuan chuntza: IxReyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Lā' nā cātā'xtokohua'ca'ca kalhatu' ka'lhāna'nī'n; kalhatin na ixpāxtūcāna'j lā' ā'kalhatin na ixpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Chuntza' tlōkentaxtūca a'ntū tzo'kcanī't na ixtachihuīn Dios a'nlhā huan: “Xla' ixpūtle'kecanī't na ixlaclhpu'nanca'n a'ntīn tatlahua a'ntūn tū' tzey”. ");
INSERT INTO tooNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lā' xlaca'n a'ntī ixtatētaxtumā'na talakapalalh lā' taxakā'līlh ixa'kxākca'n lā' tahuanilh: ―¡A! Hui'x ixlactlahua'cu'tuna' huan xaka'tla' lītokpān lā' ixyāhuapala' ixlīlakatu'tun chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chuhua'j capūtaxtu mē'cstu lā' cayu'jti de huan nac cruz. ");
INSERT INTO tooNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lā' nā chuntza' xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n huan ley ixtalīlītzī'n Jesús lā' ixtalāhuanimā'na: ―Xla' cāmāpūtaxtūlh ā'makapitzīn pero tūla pūtaxtu ixa'cstu. ");
INSERT INTO tooNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cayujli chuhua'j de huan nac cruz huan Cristo a'ntī ixReyca'n israelitas. Nalaktzī'nāuj nayuja de huan cruz lā' chuntza' nakalhlaka'ī'yāuj xla'. Lā' xlaca'n a'ntī ixcātā'xtokohua'ca'canī't nā talakapalalh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lā' a'xni'ca' tastu'nūtatza' ixuanī't, cā'pucsua' lalh chuxalhā nac cā'ti'yatna' hasta maktu'tun kōtanū. ");
INSERT INTO tooNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Lā' hua'chi maktu'tun kōtanū Jesús palha' ta'salh lā' hualh: ―Eloi, Eloi, ¿lama sabactani? ―lā' ū'tza' huanicu'tun: QuinDios, quinDios, ¿a'chī' qui'a'kxtekui'līnī'ta' quē'cstu? ");
INSERT INTO tooNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lā' takaxmatli huā'mā' makapitzīn a'ntī ixtayāna'ncha'. Lā' xlaca'n talāhuanilh: ―Cakaxpa'ttit. Xla' māta'sīmā' huan a'cta'sana' Elías. ");
INSERT INTO tooNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Lā' tu'jnulh kalhatin lā' līmāchū'huī'lh vinagre nac lakatin catūhuā a'ntū hua'chi panamāc. Lā' o'ksmā'ca'lh kantin qui'hui' lā' quilhyāhualh Jesús para nahua' lā' hualh: ―Camakxtekui; nalaktzī'nāuj palh Elías namin namāyujū de nac cruz. ");
INSERT INTO tooNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Lā' Jesús lej palha' ta'salh lā' tuncan nīlh. ");
INSERT INTO tooNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lā' huā'mā' ka'tlā'tus huan lu'xu' nac xaka'tla' lītokpān taxtī'tpitzilh desde ixquilhtūn xala' tālhmā'n hasta na ixtampān. U'tza' huā'mā' lu'xu' a'ntū ixmāpitzi huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lā' huan capitán romano ixyā na ixlacapūn Jesús. Lā' a'xni'ca' laktzī'lh a'nchī Jesús ta'salh lā' nīlh, lā' huan capitán hualh: ―Stu'ncua' huā'mā' chi'xcu' huan ixO'kxa' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nā huan puscan ixtalaktzī'mā'na de makat; na ixlaclhni'ca'n ixtayāna' María Magdalena lā' Salomé lā' María ixtzī'tca'n Jacobo huan xastancu lā' José. ");
INSERT INTO tooNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Xlaca'n ixtastālani'tlā'huan Jesús a'xni'ca' ixuī' nac estado de Galilea lā' ixtamaktāya. Lā' nā ixtahui'lāna' ā'makapitzīn lhūhua' puscan a'ntī ixcātā'minī't a'ntza' nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kōtanūtza' ixuanī't huanmā' chi'chini' a'ntū ixpūcāxtlahuakō'can huan chi'chini' a'ntū pūjaxcan. Lā' ū'tza' ixlīlakalī ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Lā' lakmilh huan Pilato kalhatin chi'xcu' xala' huan nac cā'lacchicni' Arimatea. Huanmā' chi'xcu' ixtacuīni' José lā' ixka'lhīmā' hasta a'xni'ca' Dios namāpa'ksīkō' ixlīhuāk. Lā' xla' chā'tin de huan pūchihuīna'nī'n israelitas a'ntī más ixtamāpa'ksīni'n. Lā' huā'mā' chi'xcu' lej ixa'cnīni'ni'can. Lā' xla' ixa'cstu tahuixcānīlh lā' squi'ni'lh Pilato camaxquī'lh ixmacni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Lā' Pilato lē'cnīlh como puhualh que tūna'j ixnī. Lā' māta'sīlh huan capitán lā' kalhasqui'nīlh palh stu'ncua' ixnīnī'ttza' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lā' a'xni'ca' huan capitán māca'tzīnīlh que ixnīnī'ttza', Pilato makxtekli José nalē'n huan macni'. ");
INSERT INTO tooNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Lā' José tamāhualh kalhtin stala'nka' lu'xu' xatzey. Lā' a'xni'ca' ixmāyujūnī'ttza' huan ixmacni' Jesús, līpāsna'tli huan lu'xu' lā' māpī'lh nac lakatin lhu'cu' a'ntū ixcāxtlahuacanī'ttza' nac talhpān. Lā' līmālacchahuayāhualh lakatin ka'tla' chihuix. ");
INSERT INTO tooNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Lā' María Magdalena lā' María ixtzī't José talaktzī'lh a'nlhā ixmāpī'canī't ixmacni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lā' a'xni'ca' ixpātle'kenī'ttza' huan chi'chini' a'ntū pūjaxcan, María Magdalena lā' María ixtzī't Jacobo lā' Salomé tatamāhualh pomada a'ntū lej xamu'csa para natalīmactlahua ixmacni' huan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Lā' cā'tzi'sāt huan domingo a'xni'ca' tā'cxtulhcus huan chi'chini', ta'a'lh nac taponkni' ");
INSERT INTO tooNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","lā' ixtalāhuani: ―¿Tichū naquincāmāpānūni'yāni' huan chihuix a'ntū līmālacchōcanī't huan lhu'cu'? ");
INSERT INTO tooNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lā' a'xni'ca' talaca'a'lh, talaktzī'lh que ixmāpānūcanī'ttza' huan chihuix como ka'tla' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Lā' tatanūlh nac taponkni' lā' talaktzī'lh kalhatin ángel a'ntī ixtasu'yu hua'chi chi'xcu'. Ixuī' na ixa'cacāna'j huan lhu'cu' lā' smu'yonko ixlu'xu' lā' pūlhmā'n ixuanī't. Lā' xlaca'n lej tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Lā' huan ángel cāhuanilh: ―Tū' cajicua'ntit. Hui'xina'n putzapā'na'ntit Jesús xala' nac Nazaret a'ntī xtokohua'ca'canī't. Xla' tū'tza' huī' huā'tzā'; xla' lakahuanchokolhtza'. Chā calaktzī'ntit a'nlhā ixmāpī'canī't. ");
INSERT INTO tooNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Capintit lā' cacāhua'ni'tit Pedro lā' ā'makapitzīn ī'sca'txtunu'nī'n Jesús. Nahua'ni'yā'tit que xla' nacāpū'lani'yāni' para nac estado de Galilea. A'ntza' napāxtokā'tit chu a'nchī cāhuanini'. ");
INSERT INTO tooNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lā' huan puscan tataxtulh de nac lhu'cu' lā' tatzā'lalh. Lej ixtaxpipitēlha lā' ixtalē'cnītēlha. Lā' como lej ixtajicua'n, tuntū' ixtahuani nīn tintī'. ");
INSERT INTO tooNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Huanmā' domingo lej tzi'sāt Jesús lakahuanchokolh. Lā' pū'la tasu'yuni'lh María Magdalena a'ntī ixmāxtuni'nī't lakatojon tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Lā' María cālakchā'lh xlaca'n a'ntī ixcātā'latlā'huan Jesús. Ixtalakaputzahui'lāna' lā' ixtacalhuahui'lāna'. Lā' cāmāca'tzīnīlh a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Lā' a'yuj xlaca'n takaxmatli a'nchī ixlakahuanchokonī't Jesús, lā' a'nchī María Magdalena ixlaktzī'nī't, pero xlaca'n tū' takalhlaka'ī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Lā' ā'calīstān Jesús xtunc cātasu'yuni'lh kalhatu' ī'sca'txtunu'nī'n a'xni'ca' ixta'a'mā'na lacachuna'j nac tej. ");
INSERT INTO tooNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lā' xlaca'n tataspi'tli lā' tamāca'tzīnīlh ā'makapitzīn sca'txtunu'nī'n, pero xlaca'n tū' takalhlaka'ī'lh. ");
INSERT INTO tooNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Lā' ā'calīstān huampala Jesús cātasu'yuni'lh huan kalhacāujtin sca'txtunu'nī'n a'xni'ca' ixtahuā'yamā'na. Lā' cālacaquilhnīlh porque tū' ixtakalhlaka'ī'cu'tun. Tū' takalhlaka'ī'lh a'nchī tahualh xlaca'n a'ntī ixtalaktzī'nī't Jesús a'xni'ca' ixlakahuanchokonī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Lā' Jesús cāhuanilh: ―Capintit chuxalhā nac cā'quilhtamacuj lā' nacāmāsu'ni'yā'tit huan xatzey tachihuīn ixlīhuākca'n huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Chuxatī a'ntī nakalhlaka'ī' huan xatzey tachihuīn ixpālacata Jesucristo lā' na'a'kpaxa, xla' namāpūtaxtūcan. Lā' chuxatī a'ntīn tū' nakalhlaka'ī' huan xatzey tachihuīn, xla' naka'lhīcus ixtalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Lā' nalīlakapascan a'ntīn takalhlaka'ī' huan xatzey tachihuīn chuntza'. Natalīmāxtu huan tlajana'nī'n con quilīmāpa'ksīn. Tzē natachihuīna'n xasāsti' tachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Lā' a'yuj catachi'palh huan lūhua' lā' a'yuj catalīko'tnūlh catūhuā a'ntū ka'lhī līlaknīn, tū' catitalaknīlh. Lā' xmān nataxa'ma huan ī'tza'ca'nī'n lā' xlaca'n natatzeyan. ");
INSERT INTO tooNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lā' a'xni'ca' huan Māpa'ksīni' Jesús chuntza' ixcāhuaninī't ī'sca'txtunu'nī'n, xla' tā'kayāhualh lā' a'lh nac a'kapūn. Lā' tahui'lh na ixpāxtucāna'j Dios a'nlhā a'cnīni'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Lā' huan sca'txtunu'nī'n ta'a'lh lā' lakachu ixta'a'cta'sana'n. Lā' huan Māpa'ksīni' ixcāmaktāya. Lā' chuntza' tzē ixtalītlahua lē'cnīn. Lā' ū'tza' ixlīca'tzīcan que stu'ncua' a'ntū ixtamāsu'yumā'na. Amén.");
INSERT INTO tooNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lhūhua' a'nan a'ntī tatzo'kli a'ntū pātle'kelh na quilaclhpu'nanca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Lā' a'ntū quincātahuanin ixpālacata Cristo lā' huan tū laktzī'nca desde xalītzucuni' hasta chuhua'j, ū'tza' tatzo'kli. Nā a'ntīn talaktzī'lh xalītzucuni' nā tamāsu'yulh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nā chuntza' quiminī'ni'lh ictzo'knun. Xa'nca ictlahualh cuenta desde makān para que xa'nca na'icca'tzī a'nchī na'ictzo'knuni'yāni' en orden ");
INSERT INTO tooNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para que naca'tzīya' que stu'ncua' a'ntū māsu'nīcanī'ta', Teofilo. ");
INSERT INTO tooNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lā' a'xni'ca' Herodes rey ixuanī't nac Judea, ixuī' ka'lhatin sacerdote; ixtacuīni' Zacarías. Lā' xla' tā'tapa'ksī'lh sacerdotes a'ntī ixcāmāpācuhuīcan Abías. Nā ixpuscāt Zacarías ixuanican Elisabet lā' xla' ī'xū'yātā'nat Aarón. ");
INSERT INTO tooNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ixtu'ca'n lacuan na ixlacapūn Dios. Tū' tatlahualh a'ntūn tū' tzey como tatlōkentaxtūlh ixlīmāpa'ksīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tū' ixtaka'lhī ixcamanca'n como Elisabet tūlalh ka'lhīlh lā' nā lacpapatzīntza'tza' ixtahuanī't ixtu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lā' milh huan chi'chini' a'xni'ca' Zacarías lā' ixtā'sacerdotes ixtatlahuamā'na ixlītlōtca'n na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lā' como chuntza' ixtahui'latca'n, por suerte lacsacca Zacarías para natanū nac lītokpān para nalhcuyu huan pūm. ");
INSERT INTO tooNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Līhuan ī'lhcuyucan huan pūm, ixlīhuākca'n a'ntī ixtatakēxtimīnī't tatachokolh nac tanquilhni' lā' ixta'orarlīmā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lā' tuncan tasu'yu'ni'lh Zacarías kalhatin ixángel Dios. Ixyā ixpekcāna'j huan altar a'nlhā ī'lhcuyucan pūm. ");
INSERT INTO tooNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lā' a'xni'ca' Zacarías laktzī'lh, tamakchuyīlh lā' lej jicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Lā' huan ángel huanilh: ―Zacarías, tū' cajicua' porque Dios kaxmatli a'ntū kalhasqui'nīnī'ta'. Lā' mimpuscāt Elisabet naka'lhī ixcaman lā' namāpācuhuī'ya' Juan. ");
INSERT INTO tooNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lej nalīpāxuhua'ya' lā' lhūhua' tachi'xcuhuī't natalīpāxuhua ixpālacata huan ska'ta' ");
INSERT INTO tooNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","como lej natasqui'nī na ixlacapūn Dios. Lā' tū' maktin nako'ta nīn cu'chu' nīn ā'catūhuā hua'chi cerveza lā' pulque a'ntū līka'chīcan. Lā' nalītatzuma ixa'clhcunuc huan Espíritu Santo desde a'xni'ca' tūna'j tahui'la. ");
INSERT INTO tooNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Lā' nacāxtāpalīni' ixtapāstacnaca'n lhūhua' israelitas para natatzucupala nata'a'kahuāna'ni' ixMāpa'ksīni'ca'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Lā' huā'mā' chi'xcu' napū'lani' huan Māpa'ksīni'. Lā' naka'lhī ixespíritu lā' ixlīmāpa'ksīn hua'chi' ixla' Elías. Lā' nacāmāspi'tni' ixa'clhcunucca'n huan tachi'xcuhuī't para natapāxquī' ixcamana'ca'n. Lā' xla' nacāmāputzī xatzey tapāstacna' a'ntī tū' ta'a'kahuāna'n. Chuntza' cāxni'j natatahui'la tachi'xcuhuī't a'xni'ca' namin huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Lā' Zacarías kalhasqui'nīlh huan ángel: ―¿Chichū na'iclīca'tzī palh stu'ncua' huā'mā'? Quit papatzīntza' lā' nā quimpuscāt to'kotzīntza'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Lā' huan ángel kalhtīni'lh: ―Quit Gabriel lā' icyā na ixlacapūn Dios. Lā' quimacamilh para na'ictā'chihuīna'nāni' lā' para na'icmaxquī'yāni' huā'mā' xatzey tachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Lā' chuhua'j hui'x nakō'ko'na'. Lā' tūlalh catichihuī'na' hasta que natahui'la huan ska'ta' como tū' ka'lhlaka'i' quintachihuīn a'ntū natlōkentaxtū a'xni'ca' nachā'n huan mālhcuyu'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A'xni'ca' takoxīlh Zacarías, huan a'ntī ixtaka'lhīmā'na na ixtanquilhni' lītokpān talē'cnīlh como tū' taxtulh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lā' a'xni'ca' taxtulh, huan Zacarías tūla ixcātā'chihuīna'n. Lā' chuntza' tamāchekxīlh que ixlakachuyanī't na ixchakān līto'kpān. Xmān ixcāmacahuani' como tūlalh cātā'chihuīna'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lā' a'xni'ca' sputkō'lh ixlītlōt nac lītokpān, Zacarías taspi'tli na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Lā' ā'calīstān ka'lhīni'lh huan ixpuscāt Elisabet. Lā' tū' taxtulh de huan chic hasta ixlīlakaquitzis mālhcuyu'. Lā' puhualh: ");
INSERT INTO tooNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Huan Māpa'ksīni' quintlahuanī't chuntza' para que tū'tza' naquintalakmaka'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Lā' ixka'lhītza' lakachāxan mālhcuyu' a'xni'ca' Zacarías ixlakachuyanīt, lā' Dios macamilh huan ángel Gabriel nac lakatin cā'lacchicni' a'nlhā huanican Nazaret ");
INSERT INTO tooNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","para nalakmin kalhatin tzu'ma'jāt a'ntī ixuanican María. Xla' ixlacāxlanī'ttza' para natā'tapūchahua kalhatin chi'xcu' a'ntī ī'xū'yātā'nat David lā' a'ntī ixuanican José. ");
INSERT INTO tooNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lā' huan ángel tanūlh a'nlhā ixuī' María lā' huanilh: ―¡Icmālakacuhuīnī'yāni' hui'x a'ntī lej sicua'lanālīcanī'ta! Huan Māpa'ksīni' maktaka'lhāni'; Dios lej sicua'lanālīnī'ta'ni' que ixlīhuākca'n huan ā'makapitzīn puscan. ");
INSERT INTO tooNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lā' a'xni'ca' María laktzī'lh huan ángel, lej līlē'cnīlh huā'mā' tachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Lā' huan ángel kalhtīlh: ―María, tū' cajicua' porque Dios lej pāxquī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chuhua'j naka'lhīni'na' lā' naka'lhī'ya' kalhatin ska'ta' xachi'xcu'. Lā' namāpācuhuīya' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lej tasqui'nī lā' namāpācuhuīcan ixO'kxa' Dios a'ntī más xaka'tla'. Lā' huan Māpa'ksīni' Dios nahui'lī ixlīrey hua'chi ixpap David ");
INSERT INTO tooNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","para que pō'ktu nacāmāpa'ksī ixlīhuāk israelitas. Lā' ixlīmāpa'ksīn tū' maktin catisputli. ");
INSERT INTO tooNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Lā' tuncan María kalhasqui'nīlh huan ángel: ―¿Chichū nalīla huā'mā'? Quit tūna'j ictapūchahua. ");
INSERT INTO tooNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Lā' huan ángel kalhtīlh: ―Huan Espíritu Santo namin lā' nalakmināni' lā' ixlīmāpa'ksīn Dios Xaka'tla' nalīmacxti'li'yāni' hua'chi poklhnu'. U'tza' nalīla para que huan ska'ta' a'ntī natahui'la nala xmān ixla' Dios lā' namāpācuhuīcan ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Lā' nā mintalakapasni' Elisabet nā naka'lhī ixcaman xachi'xcu' a'yuj to'kotzīntza' lā' a'yuj huancan que tū'tza' catika'lhīlh ixcaman. Ka'lhītza' lakachāxan mālhcuyu' desde a'xni'ca ka'lhīni'lh ");
INSERT INTO tooNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","porque Dios tzē natlahua ixlīhuāk catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Lā' a'xni'ca' María kalhtīlh lā' huanilh: ―Quit ixla' Dios para natlōkentaxtū ixtapuhuān. Calalh chu a'nchī quihua'ni'nī'ta'. Lā' huan ángel a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lā' milh lakatin chi'chini' a'xni'ca' María taxtulh lā' a'lh lacapalh nac huan xcānsipej xala' lakakēstīnni' Judea. ");
INSERT INTO tooNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lā' tanūlh na ixchic Zacarías lā' mālakakōtanu'lh Elisabet. ");
INSERT INTO tooNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lā' a'xni'ca' Elisabet kaxmatni'lh ixtachihuīn María, huan ska'ta' taxakā'līlh na ixpān lā' Elisabet lītatzumalh huan Espíritu Santo ixa'clhcunuc. ");
INSERT INTO tooNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Lā' a'xni'ca' Elisabet chihuīna'lh lej palha' lā' hualh: ―Dios más sicua'lanālīnī'ta'ni' hui'x que ixlīhuākca'n puscan lā' nā sicua'lanālīnī't mincaman. ");
INSERT INTO tooNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Lā' ¿tichūn quit para que naquilakmin ixtzī't quiMāpa'ksīni'? Quit nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Lā' xmān ickaxmatli mintachihuīn lā' quiska'ta' līpāxuhualh lā' taxakā'līlh na quimpān. ");
INSERT INTO tooNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hui'x līpāxuhua'ya' como kalhlaka'ī'nī'ta' lā' natlōkentaxtū a'ntū huaninī'ta'ni' huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Lā' tuncan María hualh: Quilīca'tzīn mācā'tanīmā' huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Lā' quilīca'tzīn līpāxuhua ixpālacata quiMāpūtaxtūnu' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Dios cuenta quintlahuanī't quit a'ntī ixtasācua' lej xapobre. Lā' chuhua'j lā' nā pō'ktu tachi'xcuhuī't natahuan que iclīpāxuhua quit. ");
INSERT INTO tooNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Dios a'ntī lej ka'lhī līmāpa'ksīn quintlahuani'nī't laka'tla'n catūhuā. Lā' xla' lej santo. ");
INSERT INTO tooNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Pō'ktu nacālakalhu'man a'ntīn ta'a'cnīni'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ixlīmāpa'ksīn lītlahuanī't lhūhua' catūhuā. Lītlajalh a'ntī lej ka'tla'jca'tzī. ");
INSERT INTO tooNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Cāmāpānūni'lh ixlīmāpa'ksīnca'n huan a'ntī lej ka'tla' ixtahuanī't lā' a'ntīn tapuhuan que xlaca'n más natatasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","A'ntī xatzi'ncsni'nī'n cālīmāka'sīlh xatzey līhua't lā' cāmacā'nī't huan ricosnu' con nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Cāmaktāyanī't huan ixraza Israel a'ntī tatlōkentaxtū ixtapuhuān Dios lā' tū' maktin makxteknī't ixlīlakalhu'man. ");
INSERT INTO tooNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","U'tza' tlahualh a'cxtim hua'chi cāhuaninī't quimpapca'n a'ntī Abraham lā' nā ixnatā'natna' que pō'ktu nacāmaktāya. ");
INSERT INTO tooNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Lā' María tachokolh na ixchic Elisabet lakatu'tun mālhcuyu' lā' ā'calīstān taspi'tli na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Lā' a'xni'ca' chā'ni'lh ixmālhcuyu' huan ska'ta', tahui'lalh ixcaman Elisabet. Xachi'xcu' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Lā' ixamigos lā' ixtalakapasnī'n tamilh para natatā'līpāxuhua a'xni'ca' taca'tzīlh que Dios lītlahuanī't xalītzey Elisabet. ");
INSERT INTO tooNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ixlīlakatzeyan chi'chini' ta'a'lh tatlahua ixtalanānca'n para nacircuncidarlīcan huan ska'ta' lā' ixui'līni'cu'tuncan ixtacuīni' Zacarías hua'chi ixtāta'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lā' ixtzī't cāhuanilh: ―Tū'. Ixtacuīni' Juan nahuan. ");
INSERT INTO tooNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Lā' kalhasquinīca: ―Lā' ¿a'chī'? Tintī' a'nan de mintalakapasni' a'ntī huanican Juan. ");
INSERT INTO tooNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Chu tuncan tamacahuani'lh ixtāta' huan ska'ta' para nataca'tzī tūyā tacuīni' nahui'līni'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xatāta' squi'nli kalhtin ca'psnat para natzo'kui'lī lā' tzo'kli: “Ixtacuīni' Juan”. Lā' ixlīhuākca'n talē'cnīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lā' tuncan huā'mā' ka'tlā'tus Zacarías tzucupā chihuīna'n lā' mācā'tanīlh Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","U'tza' talīlē'cnīlh huan ixamigos lā' tahuankō'lh huā'mā' lakachu nac huan lakakēstīn xala' nac Judea. ");
INSERT INTO tooNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ixlīhuākca'n a'ntīn takaxmatli lej tapāstacna'lh lā' talākalhasqui'nīlh: ―Lā' huā'mā' ska'ta' ¿tuchūyā chi'xcu' nala? Chuntza' tahualh como ixtasu'yu que ixsicua'lanālīnī't huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huan Espíritu Santo lītatzumalh ixa'clhcunuc huan Zacarías lā' chihuīna'lh hua'chi Dios māsu'ni'lh lā' hualh: ");
INSERT INTO tooNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Camācā'tanīca huan Māpa'ksīni' a'ntī ixDiosca'n israelitas porque quincālakalhu'mani' quina'n a'ntī ixraza lā' quincāmāpūtaxtūni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quincāmaxquī'nī'ta'ni' kalhatin Māpūtaxtūnu'; lej ka'lhī līmāpa'ksīn lā' xala' ixlaclhni' ixnatā'natna' David a'ntī tlōkentaxtūlh ixtapuhuān Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chu a'nchī hualh por huan profetasna' xalanī'n makān, chuntza' līhui'līlh Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Hualh que ixquincāmāpūtaxtūni' de ixlīmāpa'ksīn quintā'ca'tzaca'n lā' ixlīhuākca'n a'ntīn tū' quincātalaktzī'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Lā' huampā que ixquincālakalhu'mani' quimpapca'n lā' tū' ixtipātza'nkālh a'nchī līlacāxtlahualh con xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","U'tza' huan compromiso a'ntū Dios ixlītlahuanī't quimpapca'n Abraham, ");
INSERT INTO tooNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","que ixquincāmāpānūni'n quintā'ca'tzaca'n para que ixtlahuáuj ixtapuhuān Dios lā' tū' ixjicua'uj. ");
INSERT INTO tooNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Lā' chuntza' nalayāuj lacuan pō'ktu nac huā'mā' quilhtamacuj, hua'chilh tū' ixtlahuáuj a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Lā' hui'x, quiska'ta', namāpācuhuīca'na' ixa'cta'sana' Dios más Xaka'tla' porque napū'lani'yāni' huan Māpa'ksīni' lā' namālakstu'nca' a'nlhā na'a'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Lā' nacāmāsu'ni'ya' tachi'xcuhuī't para que chuntza' nataca'tzī que namin huan Māpūtaxtūnu' lā' nacāmāsputūnu'ni' ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Dios quincāpāxquī'yāni' lā' quincālakalhu'manāni'. U'tza' quincālīmacamini'yāni' kalhatin para naquincāmāpūtaxtūyāni'. Xla' namāxkakē quintejca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Quina'n hua'chi a'ntīn tahui'lāna' a'nlhā cā'pucsua' lā' tanīmā'na. Lā' naquincāmāsu'ni'yāni' a'nchī chu lakatin quintapuhuānca'n con Dios a'xni'ca' natlā'huanāuj na ixtej. ");
INSERT INTO tooNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Lā' huan ska'ta' Juan ī'stacmā' lā' xa'nca ixcāmāchekxī ixlīhuāk catūhuā a'ntū ixla' Dios. Lā' a'xni'ca' ka'tla'tza', ixuī' nac cā'lhpi'mpi'li' ti'ya't hasta que milh huan ixlacchi'chini' para nalīlakapascan israelitas. ");
INSERT INTO tooNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lā' a'xni'ca' tūna'j ixtahui'la Jesús, huan emperador Augusto māpa'ksīlh lakatin censo chuxalhā nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","A'xni'ca' Cirenio ixuī' ixlīgobernador nac Siria a'xni'ca' pū'la tlahualh huan censo. ");
INSERT INTO tooNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ixtasqui'nī chā'tunu' cata'a'lh na ixā'lacchicni'ca'n a'nlhā ixtatahui'lanī't ixpapca'n para nacātzo'kni'can ixtacuīni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","U'tza' lītaxtulh José de nac huan cā'lacchicni' Nazaret xala' nac estado de Galilea lā' a'lh nac lakatin cā'lacchicni' Belén xala' nac estado de Judea. A'ntza' xatahui'lani' David lā' como José ixtā'nat ixuanī't David, a'ntza' ixmāstā'lh ixtacuīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lā' a'lh nac Belén para natzo'kcan ixtacuīni'. Tā'a'lh María a'ntī ixtalacāxlanī'ttza' que natā'tapūchahua xla' lā' xla' ixka'lhīni'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Lā' pātle'kelh que a'xni'ca' ixuī' nac Belén, chā'ni'lh ixmālhcuyu' huan ska'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Tahui'lalh ī'ska'ta' ixlīmaksāsti' María lā' xachi'xcu'. Līmaksna'tli ixtanchut lā' māpī'lh a'nlhā mojōcan ixlīhua't cahuāyuj como tū' takaksli a'nlhā natamaklhtata nac mesón. ");
INSERT INTO tooNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ixa'nan pastornu' pajtzu nac Belén. Tintascac ixtalakalhtatamā'na nac potrero ixborregoca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chu līmaktin tasu'yulh kalhatin ixángel Dios lā' cālīxti'li'lh ī'xkakana' Māpa'ksīni'. Lā' lej tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Lā' huan ángel cāhuanilh: ―Tū' cajicua'ntit porque iccālīmini'yāni' razón xatzey lā' ū'tza' natalīka'lhī tapāxuhuān ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chuhua'j huā'mā' tzī'sa tahui'la'cha' kalhatin ska'ta' nac huan cā'lacchicni' a'nlhā ixtahui'lanī't David. Xla' nala miMāpūtaxtūnu'ca'n lā' māni' ū'tza' Cristo huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Lā' nakaksā'tit huan ska'ta' talīmaksna'tni' ixtanchut lā' māpī'canī't a'nlhā mojōcan ixlīhua't cahuāyuj. U'tza' nalīlakapasā'tit que ū'tza' xla'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Lā' chu līmaktin tatasu'yupā lhūhua' ángeles xala' nac a'kapūn a'ntī ixtamācā'tanīmā'na Dios. Lā' tahualh: ");
INSERT INTO tooNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―¡Camācā'tanīca Dios nac a'kapūn lā' tzē'k catatahui'lalh nac cā'ti'ya'tna' ixlīhuākca'n a'ntī Dios cālakalhu'malh! ");
INSERT INTO tooNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Lā' tuncan a'xni'ca' huan ángeles tataspi'tli nac a'kapūn, huan pastornu' tatzuculh talāhuani: ―Cāhuitit chuhua'j nac Belén lā' nalaktzī'nāuj a'ntūn pātle'kenī't lā' a'ntū huan Māpa'ksīni' quincāmāca'tzīnīnī'ta'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lā' ta'a'lh lacapalh lā' cākaksca María lā' José lā' huan ska'ta' a'nlhā ixmāpī'canī't lā' a'nlhā chī'yāhuacan cahuāyuj. ");
INSERT INTO tooNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lā' a'xni'ca' talaktzī'lh, tahualh a'ntū ixtahuanī't ángeles ixpālacata huan ska'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Lā' ixlīhuākca'n a'ntīn takaxmatli talīlē'cnīlh ixtachihuīnca'n huan pastornu'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Lā' María lej ixpāstacmā' ixlīhuāk a'ntū ixpātle'kenī't lā' a'ntū ixuanicanī't lā' ixpuhuan. ");
INSERT INTO tooNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lā' huan pastornu' tataspi'tli lā' ixta'a'cnīni'ni'mā'na Dios lā' ixtamācā'tanīmā'na como chu a'nchī cāhuanica, chu a'cxtim pātle'kelh. ");
INSERT INTO tooNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lā' ixlīlakatzeyan chi'chini' tlahuaca huan talanān de circuncisión para huan ska'ta' lā' hui'līni'ca ixtacuīni' Jesús. U'tza' huā'mā' tacuīni' a'ntū huan ángel huanilh María a'xni'ca' tūna'j ixka'lhīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Lā' ixlītu'pu'xam chi'chini' tatlōkentaxtūlh ixtalanānca'n huan puscan a'nchī Moisés ixmāsu'yunī't para naxapa ixlīko'hua'jua' huan puscāt. Lā' talē'lh huan ska'ta' nac Jerusalén para namāsu'ni'can huan Māpa'ksīni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chuntza' tatlahualh como tatzo'kni' na ixley Dios: Chā'tunu' ska'ta' xachi'xcu' a'ntī līmaksāsti', ū'tza' nala ixla' Māpa'ksīni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chuntza' María lā' José ta'a'lh para natamālacnū chu a'nchī huan na ixley Dios. Huan palh tasqui'nī namālacnūni'can xachi'xcu' lā' xapuscāt tórtola o tantu' tantzasnān. ");
INSERT INTO tooNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lā' ixuī' nac Jerusalén huā'mā'na chi'chini' kalhatin chi'xcu' a'ntī ixuanican Simeón. Lej tzeyā chi'xcu' ixuanī't lā' ixa'cnīni'ni' Dios lā' ixka'lhīmā' ixMāpūtaxtūnu'ca'n israelitas. Lā' huan Espíritu Santo ixtā'huī'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Lā' ixmāsu'ni'nī'ttza' que tū' ixnīlh palh tū' pū'la nalaktzī'n huan Cristo a'ntī huan Māpa'ksīni' Dios namacamin. ");
INSERT INTO tooNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Huā'mā' chi'xcu' a'lh nac lītokpān por huan Espíritu Santo. Lā' līminca huan ska'ta' Jesús nac lītokpān para natlōkentaxtū ixtalanānca'n lā' a'ntū māpa'ksīlh huan ley a'ntū tzo'kli Moisés. ");
INSERT INTO tooNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Lā' huan Simeón cha'xli huan ska'ta' lā' a'cnīni'ni'lh Dios lā' hualh: ");
INSERT INTO tooNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","QuiMāpa'ksīni', chuhua'j līpāxūj na'icnī como tlōkentaxtū'nī'ta' a'ntū quihua'ni'nī'ta' quit a'ntī mintasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Iclaktzī'nī'ttza' con quilakastapun huā' Māpūtaxtūnu' ");
INSERT INTO tooNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","a'ntī hui'x māstā'nī'ta' para ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","U'tza' nacāmāsu'ni' a'ntīn tū' israelitas para que xa'nca natatlā'huan nac cā'quilhtamacuj hua'chi huan pūmaksko nacāmāsu'yu a'ntī talatlā'huan a'nlhā cā'pucsua'. Lā' por ixpālacata nacā'a'cnīni'ni'can huan israelitas a'ntī mintachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lā' José lā' ixtzī't Jesús talīlē'cnīlh a'ntū hualh huan Simeón ixpālacata huan ska'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Lā' Simeón squi'nli que Dios casicua'lanālīlh lā' huanilh María a'ntī ixtzī't Jesús: ―Cala'ktzi'. Dios lacsacnī't huā'mā' ska'ta'. Lā' a'xni'ca' chi'xcu'tza' nala, lhūhua' israelitas natakalhlaka'ī' lā' xla' nacāmaktāya. Lā' a'ntī tū' natakalhlaka'ī', xlaca'n natatā'lāsta'la. Xla' namāsu'yu ixtapuhuān Dios lā' tachi'xcuhuī't natalakmaka'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lā' chuntza' naca'tzīcan a'nchī pāstacna'nāuj chā'tunu' de quina'n na qui'a'clhcunucca'n. Lā' hui'x lej nalakaputza'ya' hua'chi palh nalakpusa kantin espada na mi'a'clhcunuc ―hualh Simeón. ");
INSERT INTO tooNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Lā' nā ixuī' a'ntza' kalhatin puscāt a'ntī ixa'cta'sana' Dios lā' ixtacuīni' Ana. Xla' ixcaman Fanuel xala' ixraza Aser. Lejtza' to'kotzīntza' ixuanī't. Tzu'ma'jātcus ixuanī't a'xni'ca' tapūchōlh lā' tā'tahui'lalh ixchi'xcu' lakatojon cā'ta. ");
INSERT INTO tooNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chuhua'j ixlītā'ti'pu'xamatā'ti' cā'ta lakapūt. Tū' ixtaxtu de nac xaka'tla' lītokpān pero pō'ktu ixmācā'tanīmā' Māpa'ksīni' Dios. A'katunu' tū' ixuā'yan como ixtlahuacu'tun oración. ");
INSERT INTO tooNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","A'xni'ca' José lā' María tatanūlh nac xaka'tla' lītokpān, huā'mā' ka'tlā'tus Ana cālaktapajtzūlh. Lā' a'xni'ca' maxquī'kō'lh pāxcatca'tzī Dios, tzuculh līchihuīna'n huan ska'ta' Jesús. Cālītā'chihuīna'lh ixlīhuākca'n a'ntī xalanī'n nac Jerusalén a'ntī ixtaka'lhīmā'na ixmāpūtaxtūnu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lā' a'xni'ca' José lā' María tatlōkentaxtūlh ixlīhuāk a'ntū māpa'ksīlh Moisés a'ntū tzo'kli na ixley Dios, talē'mpā huan ska'ta' nac Galilea nac Nazaret ixā'lacchicni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Lā' huan ska'ta' ī'stacmā' lā' lej ixtli'hui'quimā' lā' lej skalalh ixlatēlha lā' Dios ā'chulā' ixsicua'lanālī. ");
INSERT INTO tooNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cā'ta cā'ta José lā' María ixta'a'n nac Jerusalén para ixcā'tani'ca'n israelitas a'ntū huanican pascua. ");
INSERT INTO tooNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lā' a'xni'ca' Jesús ixka'lhī lakacāujtu' cā'ta, ixlīhuākca'n ta'a'lh nac Jerusalén para huan cā'tani' lā' chuntza' hua'chi ixtalīsmanīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lā' a'xni'ca ixlē'ksputnī'ttza' cā'tani' lā' ixtaquītaspi'tmā'natza', huan ka'hua'chu Jesús tachokolh nac Jerusalén. Lā' ixtzī't lā' José tū' cuenta tatlahualh. ");
INSERT INTO tooNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ixtapuhuan que Jesús ixtatā'mimā'natza' ā'makapitzīn lā' chuntza' ta'a'lh nac tej lakatin chi'chini'. Lā' a'xni'ca' ixtaputzamā'natza' ixlaclhni' ixtalakapasnī'n lā' ixamigos, ");
INSERT INTO tooNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tū' takaksli. Lā' tuncan tataspi'tli nac Jerusalén para nataputzayācha'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lā' ixlīlakatu'tun chi'chini' takaksli Jesús nac xaka'tla' lītokpān. Ixcālaclhpu'nahuī' huan mākalhtō'kē'ni'nī'n huan ley lā' ixcākaxmatmā' lā' ixcākalhasqui'nīmā'. ");
INSERT INTO tooNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Lā' ixlīhuākca'n a'ntī takaxmatli talīlē'cnīlh ixtapāstacna' lā' a'nchī ixcākalhtī. ");
INSERT INTO tooNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lā' a'xni'ca' talaktzī'lh María lā' José, talē'cnīlh lā' ixtzī't huanilh: ―Qui'o'kxa', ¿a'chī' quilātlahuani'nī'ta'uj chuntza'? Quit lā' mintāta' lej iclīpuhuanī'ta'uj iccāputzayān. ");
INSERT INTO tooNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Lā' Jesús cāhuanilh: ―¿A'chī' quilāputzayāuj? ¿Chu tū' ca'tzīyā'tit maclacasqui'n na'ictachoko na ixchic quinTāta' Dios? ");
INSERT INTO tooNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Lā' xlaca'n tū' tamāchekxīni'lh ixtachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Lā' tuncan cātā'taspi'tli nac Nazaret lā' cā'a'kahuāna'ni'lh. Lā' ixtzī't lej lhūhua' ixpāstaca ixlīhuāk huā'mā' lā' māquī'kō'lh na ixcu'xan. ");
INSERT INTO tooNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Lā' Jesús ī'stacmā' lā' ā'chulā' ixka'lhīma' tapāstacna'. Lā' nā tzey ixuanī't na ixlacapūn Dios lā' na ixlacapūnca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ixlīlakacāujquitzis cā'ta ixlīgobernador Tiberio a'xni'ca' Poncio Pilato gobernador ixuanī't de nac Judea. Lā' Herodes gobernador ixuanī't de nac Galilea, lā' ixtā'tin Felipe gobernador ixuanī't de nac Iturea lā' de nac Traconite, lā' Lisanias gobernador ixuanī't de nac Abilina. ");
INSERT INTO tooNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Lā' Anás lā' Caifás xamāpa'ksīni'nī'n curasna' ixtahuanī't. A'xni'ca' ixlīhuākca'n ixtamāpa'ksīni'mā'na, a'xni'ca' Dios tā'chihuīnalh Juan ixcaman Zacarías a'ntī ixuī' nac cā'lhpi'mpi'li' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Lā' Juan a'lh lakachu pajtzu huan pūxka Jordán. Lā' cāhuanilh tachi'xcuhuī't que ixta'a'kpaxli lā' ixtaxtāpalīlh ixtapāstacna'ca'n para nacāmāsputūnu'ni'can ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Huā'mā' pātle'kelh a'nchī ixtzo'knunī't huā' ixa'cta'sana' Dios a'ntī ixuanican Isaías. Chuntza' tzo'kli: A'ntza' a'nlhā cā'lhpi'mpi'li' ti'ya't, nakaxmatcan catīhuā a'ntī palha' nachihuīna'n lā' nahuan: “Cacāxtlahua'tit huan tej como mimā' huan Māpa'ksīni'. Stu'nc camālakstu'nctit huan tej. ");
INSERT INTO tooNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ixlīhuāk huan cā'pūtatonkopūn natatzumana'n lā' huan kēstīnni' lā' ixpōkalhni' kēstīnni' pūsca'nan natalakō'. Lā' huan lhka'hui'li' tej slitua' nala. Lā' a'nlhā tū' kalhspit, kalhspit nala. ");
INSERT INTO tooNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lā' ixlīhuākca'n tachi'xcuhuī't natalaktzī'n que Dios macamilh Māpūtaxtūnu'”. ");
INSERT INTO tooNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lā' a'xni'ca' lhūhua' tachi'xcuhuī't tataxtulh para que Juan nacāmā'kpaxī, xla' cālacaquilhnīlh lā' cāhuanilh: ―¡Hui'xina'n tlahua'pā'na'ntit lakatu' milacanca'n! ¿Tichū cāhuanini' que natzā'la'ni'yā'tit huan ixtā'kcha Dios a'ntū mimā'? ");
INSERT INTO tooNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Catlahua'tit a'ntū tzey para que natasu'yu palh stu'ncua' xtāpalīnī'ta'ntittza' mintapāstacna'ca'n. Lā' tū' catihuantit mē'cstuca'n: “Quina'n ī'xū'yātā'natna' Abraham. U'tza' iclīpāhuanāuj lā' tū' icjicuani'yāuj ixtā'kcha Dios”. Tū' chuntza' ixua'ntit. Quit iccāhuaniyāni' que Dios tzē nacāxtāpalī huā'mā' chihuixni' lā' natala ī'xū'yātā'natna' Abraham. ");
INSERT INTO tooNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hua'chilh xacacanī'ttza' huan ā'chaj lā' natzucucan natancā'can huan qui'hui'. Lā' chuxatūyā qui'hui' a'ntūn tū' māstā' ixtō'ca't xatzey, ū'tza' natancā'can lā' nalhcuyucan. ");
INSERT INTO tooNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Lā' huan tachi'xcuhuī't takalhasqui'nīlh: ―¿Tuchū na'ictlahuayāuj? ");
INSERT INTO tooNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Lā' Juan cākalhtīlh: ―A'ntī ka'lhī kalhtu' ixcamisa camaxquī'lh kalhtin a'ntīn tū' ka'lhī. Lā' a'ntī ka'lhī ixlīhua't catā'hua'lh a'ntīn tū' ka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lā' nā tamilh mātā'jīni'nī'n de impuestos para nata'a'kpaxa lā' takalhasqui'nīlh: ―Mākalhtō'kē'ni', ¿tuchū xa'ictlahuáuj quina'n? ");
INSERT INTO tooNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lā' Juan cākalhtīlh: ―Nasqui'nā'tit xmān a'ntū ixtapalh huan impuesto. ");
INSERT INTO tooNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Lā' huan tropasna' nā takalhasqui'nīlh: ―Lā' quina'n ¿tuchū maclasqui'n na'ictlahuayāuj? Lā' cākalhtīlh: ―Tū' tilē'ksa'nīni'nā'tit a'ntūn tū' stu'ncua' nīn tū' titucsnu'nā'tit para naka'lhā'na'nā'tit. Lā' calīpāxuhua'tit mintatlajca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Lā' huan tachi'xcuhuī't lej ixtaca'tzīcu'tun ixpālacata Juan, como ixtapuhuamā'na que chō'la Juan, ū'tza' huan Cristo a'ntī Dios lacsacnit. ");
INSERT INTO tooNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Lā' Juan cāhuanikō'lh: ―Ixlīstu'ncua' quit iccālīmā'kpaxīyāni' con xcān. Huan a'ntī namin, xla' makapitzīn de hui'xina'n nacātalīmā'kpaxīyāni' Espíritu Santo lā' ā'makapitzīn huampala con macscut. Xla' ā'līhua'ca' māpa'ksīni'n que quit. Quit tūla icmālacastuca xla'. Ixtasācua' a'ntī naxcuta ixuarachi līhua'ca' tasqui'nī que quit. ");
INSERT INTO tooNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Xla' hua'chi a'ntī ka'lhī ixpūmālakosūn na ixmacan para nalacsu'nu huan trigo a'ntū lītlahuacan harina. Nasaca huan trigo lā' namāquī' para nahua' lā' huan paja nalhcuyu nac macscut a'nlhā tūla catimāmixīca. ");
INSERT INTO tooNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chuntza' cāhuanilh Juan xatzey tachihuīn lā' nā cāchihuīna'maxquī'lh tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Lā' nā lacaquilhnīlh huan gobernador Herodes ixpālacata Herodías a'ntī ixpuscāt ixtā'tin Felipe ixuanī't como Herodes ixka'lhī hua'chi ixpuscāt. Lā' nā lacaquilhnīlh porque tlahualh lhūhua' ā'catūhuā a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Lā' Herodes a'kchā'lh lā' ā'chulā' tlahualh lā' Juan mānūca nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lā' a'xni'ca' Juan ixmā'kpaxīni'n, nā Jesús milh para na'a'kpaxa. Lā' līhuan ixorarlīmā', huan a'kapūn talaquī'lh ");
INSERT INTO tooNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","lā' mincha' huan Espíritu Santo. Tasu'yulh hua'chi lakatin tantzasnān ixlakstu'nc Jesús lā' kaxmatca lakatin tachihuīn a'ntū hualh: ―Hui'x qui'O'kxa'. Lej icpāxquī'yāni' lā' lej quimaxquī'ya' tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lā' a'xni'ca' Jesús tzuculh tlahua ixlītlōt, ixka'lhī hua'chi pu'xamacāuj cā'ta. Huā'huī' ixnapapana' Jesús. Ixpuhuancan que Jesús ixo'kxa' José. Lā' José ixo'kxa' ixuanī't Elí ");
INSERT INTO tooNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","a'ntī ixo'kxa' Matat a'ntī ixo'kxa' Leví. Lā' Leví ixo'kxa' ixuanī't Melqui a'ntī ixo'kxa' Jana a'ntī ixo'kxa' José. ");
INSERT INTO tooNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Lā' José ixo'kxa' ixuanī't Matatías a'ntī ixo'kxa' Amós a'ntī ixo'kxa' Nahum a'ntī ixo'kxa' Esli a'ntī ixo'kxa' Nagai. ");
INSERT INTO tooNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Lā' Nagai ixo'kxa' ixuanī't Maat a'ntī ixo'kxa' Matatías a'ntī ixo'kxa' Semei a'ntī ixo'kxa' José a'ntī ixo'kxa' Judá. ");
INSERT INTO tooNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Lā' Judá ixo'kxa' ixuanī't Joana a'ntī ixo'kxa' Resa a'ntī ixo'kxa' Zorobabel a'ntī ixo'kxa' Salatiel a'ntī ixo'kxa' Neri. ");
INSERT INTO tooNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Lā' Neri ixo'kxa' ixuanī't Melqui a'ntī ixo'kxa' Adi a'ntī ixo'kxa' Cosam a'ntī ixo'kxa' Elmodam a'ntī ixo'kxa' Er. ");
INSERT INTO tooNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Lā' Er ixo'kxa' ixuanī't Josué a'ntī ixo'kxa' Eliezer a'ntī ixo'kxa' Jorim a'ntī ixo'kxa' Matat. ");
INSERT INTO tooNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lā' Matat ixo'kxa' ixuanī't Leví a'ntī ixo'kxa' Simeón a'ntī ixo'kxa' Judá a'ntī ixo'kxa' José a'ntī ixo'kxa' Jonán a'ntī ixo'kxa' Eliaquim. ");
INSERT INTO tooNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Lā' Eliaquim ixo'kxa' ixuanī't Melea a'ntī ixo'kxa' Mainán a'ntī ixo'kxa' Matata a'ntī ixo'kxa' Natán. ");
INSERT INTO tooNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Lā' Natán ixo'kxa' ixuanī't David a'ntī ixo'kxa' Isaí a'ntī ixo'kxa' Obed a'ntī ixo'kxa' Booz a'ntī ixo'kxa' Salmón a'ntī ixo'kxa' Naasón. ");
INSERT INTO tooNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Lā' Naasón ixo'kxa' ixuanī't Aminidab a'ntī ixo'kxa' Aram a'ntī ixo'kxa' Esrom a'ntī ixo'kxa' Fares a'ntī ixo'kxa' Judá. ");
INSERT INTO tooNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Lā' Judá ixo'kxa' ixuanī't Jacob a'ntī ixo'kxa' Isaac a'ntī ixo'kxa' Abraham a'ntī ixo'kxa' Taré a'ntī ixo'kxa' Nacor. ");
INSERT INTO tooNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Lā' Nacor ixo'kxa' ixuanī't Serug a'ntī ixo'kxa' Ragau a'ntī ixo'kxa' Peleg a'ntī ixo'kxa' Heber a'ntī ixo'kxa' Sala. ");
INSERT INTO tooNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Lā' Sala ixo'kxa' ixuanī't Cainán a'ntī ixo'kxa' Arfaxad a'ntī ixo'kxa' Sem a'ntī ixo'kxa' Noé a'ntī ixo'kxa' Lamec. ");
INSERT INTO tooNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lā' Lamec ixo'kxa' ixuanī't Matusalén a'ntī ixo'kxa' Enoc a'ntī ixo'kxa' Jared a'ntī ixo'kxa' Mahalaleel a'ntī ixo'kxa' Cainán. ");
INSERT INTO tooNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Lā' Cainán ixo'kxa' ixuanī't Enós a'ntī ixo'kxa' Set a'ntī ixo'kxa' Adán a'ntī ixo'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Lā' ixa'clhcunuc Jesús ixlītzuma Espíritu Santo lā' taspi'tli de nac huan pūxka Jordán. Lā' huan Espíritu Santo lē'lh a'nlhā lej cā'lhpi'mpi'li'. ");
INSERT INTO tooNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","A'ntza' ixuī' tu'pu'xam chi'chini'. Lā' milh huan ko'ti'ti' para nalīlaktzī'n a ver palh tzē ixtlajalh Jesús. Lā' Jesús tū' huā'yalh huan tamā'na chi'chini' lā' lejtza' ixtzi'ncsa. ");
INSERT INTO tooNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tuncan huanilh huan ko'ti'ti': ―Palh hui'x ixO'kxa' Dios, cahua'ni' huā'mā' chihuix que calalh pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Lā' Jesús kalhtīlh: ―Tatzo'kni' na ixtachihuīn Dios: Tū' xmān pāntzi catipūlatā'kchokoca nac huā'mā' cā'quilhtamacuj. Nā maclacasqui'n cuenta natlahuacan ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Lā' tuncan huan ko'ti'ti' lēlh Jesús nac lakatin kēstīn lej tālhmā'n. Lā' a'ntza' chu līmaktin māsu'yukō'lh ixlīhuāk quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Lā' huanilh: ―Na'icmaxquī'yāni' ixlīhuāk huā'mā' lā' namāpa'ksīya'. Huāk quila' lā' nā tzē na'icmaxquī' chuxatī. ");
INSERT INTO tooNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Palh hui'x naquintatzokostani'ya' lā' naqui'a'cnīni'ni'ya', na'icmaxquī'kō'yāni' lā' ixlīhuāk mila' nahuan. ");
INSERT INTO tooNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Lā' Jesús kalhtīlh: ―Catapānu', Satanás, porque tatzo'kni' na ixtachihuīn Dios: Natatzokostani'ya' lā' namācā'tanī'ya miMāpa'ksīni' Dios lā' natlahua'ya' xmān a'ntū xla' lacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Lā' ā'calīstān huan ko'ti'ti' lē'lh nac xcānsipej Jerusalén lā' yāhualh na ixa'cpān huan xaka'tla' lītokpān. Lā' huanilh: ―Palh hui'x ixO'kxa' Dios, cayujti nac ti'ya't ");
INSERT INTO tooNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","como tatzo'kni' na ixtachihuīn Dios: Dios nacāmāpa'ksī ixángeles que natamaktaka'lhāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Natamā'kaquī'yāni' para que tū' natakāhuī' nīn kantin mintojon nac chihuix. ");
INSERT INTO tooNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Lā' Jesús kalhtīlh: ―Nā chuntza' tatzo'kni' na ixtachihuīn Dios: Tū' tilīlaktzī'na' huan Māpa'ksīni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lā' como huan ko'ti'ti tū'tza' kaksni'lh a'nchī nalīlaktzī'n Jesús, tapānūlh lakatin ka'tlā'tus. ");
INSERT INTO tooNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Lā' Jesús taspi'tli nac Galilea lā' ixka'lhī ixlīmāpa'ksīn Espíritu Santo. Lā' chuxalhā nac huan estado de Galilea ixlīchihuīnamā'ca ixpālacata a'ntūn tlahualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ixcāmāsu'ni'mā' na ixlītokpānca'n israelitas lā' ixlīhuākca'n ixta'a'cnīni'ni'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Lā' tuncan Jesús a'lh nac Nazaret a'nlhā ī'stacnī't. Lā' tanūlh nac lītokpān huan chi'chini' de pūjaxni' hua'chi ixtalanān. Lā' tāyalh para nalakapūtle'ke huan ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Maxquī'ca huan a'ntū tzo'kli huan profeta Isaías. Lā' a'xni'ca' mālakapitzilh, kaksli a'nlhā ixtatzo'kni' chuntza': ");
INSERT INTO tooNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Huan ixEspíritu Māpa'ksīni' quintā'huī' como quilacsacnī't para na'iccāmāca'tzīnī xatzey tachihuīn huan lacxcamanīnni'. Lā' nā quimacamilh para na'iccāmāko'xamāka'tlī' huan a'ntī lej talakaputza lā' para na'iccāmāxtu a'ntī cāchī'canī't. Lā' icmilh para que na'iccāmālacahuānī lakatzī'nī'n lā' na'iccāmaktāya a'ntī tapātīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Lā' nā quimacamilh para na'iccāhuani ixlacchi'chini' huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lā' a'xni'ca' Jesús mālakaxtokli huan libro, maxquī'lh huan xamayūlh lītokpān lā' tahui'lalh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Lā' como ixlīhuākca'n nac lītokpān ixtalaktzī'mā'na, lā' xla' tzuculh chihuīna'n lā' hualh: ―Chuhua'j huā'mā' chi'chini' tlōkentaxtūcanī't na milacapūnca'n huā' a'ntūn kaxpa'ttitcus. ");
INSERT INTO tooNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lā' ixlīhuākca'n tahualh lej tzey Jesús lā' talīlē'cnīlh ixtachihuīn lej tzēhuanī't a'ntū cāhuanilh. Lā' ixtalāhuanimā'na: ―¿Chu tū' ū'tza' ixcaman José? ");
INSERT INTO tooNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Lā' Jesús cāhuanilh: ―Ixlīstu'ncua' naquilāhuaniyāuj huā' tamā'na: “Hui'x doctor lā' pū'la namā'tzeyīca'na' mē'cstu”. Lā' naquilāhuaniyāuj: “Chuhua'j catlahua' huā'tzā' na minti'ya't chu a'cxtim hua'chi quincātahuanin que tlahuanī'ta' nac Capernaum”. ");
INSERT INTO tooNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chu chihuīna'mpā lā' cāhuanilh: ―Ixlīstu'ncua' iccāhuaniyāni' que tū' a'nan kalhatin a'cta'sana' a'ntī nalaktzī'ncu'tuncan na ixti'ya't a'nlhā stacli. ");
INSERT INTO tooNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ica'na iccāhuaniyāni' que lhūhua' lakapūt ixa'nan nac huan país Israel a'xni'ca' ixlatlā'huan Elías a'xni'ca' lakatu'tun cā'ta ā'i'tāt tū' lalh xcān. Lā' chuxalhā ixtzi'ncsnīmā'ca. ");
INSERT INTO tooNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Lā' Dios tū' lakmacā'lh Elías nīn kalhatin lakapūt xala' nac Israel. Lakmacā'lh kalhatin makatiyāti' xala' nac Sarepta a'ntū pajtzu huan cā'lacchicni' Sidón. ");
INSERT INTO tooNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Nā chuntza' ixa'nan nac Israel lhūhua' a'ntī ixtapātīmā'na huan ta'jatat a'ntū māmasī quinquinītca'n lā' a'xni'ca' ixui'lacha' huan a'cta'sana' Eliseo pero nīn kalhatin de xlaca'n mātzeyīca, xmān huan makatiyāti' Naamán xala' nac Siria. ");
INSERT INTO tooNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","A'xni'ca' takaxmatli huā'mā' tachihuīn, ixlīhuākca'n a'ntī ixtatanūmā'na nac lītokpān lej ta'a'kchā'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Lā' tatā'kaquī'lh lā' tatantlakaxtulh Jesús de huan nac xcānsipej. Lā' talē'lh hasta ixa'cpūn na ixkēstīn huan xcānsipej para natamacā'n para makjū. ");
INSERT INTO tooNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Lā' Jesús tētaxtulh ixlaclhni'ca'n lā' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Lā' tuncan Jesús a'lh nac Capernaum xala' nac estado de Galilea. Lā' ixcāmāsu'ni'mā' tachi'xcuhuī't huan chi'chini' de pūjaxni'. ");
INSERT INTO tooNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Lā' talīlē'cnīlh a'nchī ixcāmāsu'ni'mā' como ixlīchihuīna'mā' con līmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ixuī' nac lītokpān kalhatin chi'xcu' a'ntī ixchi'panī't huan tlajana'. Lā' ta'salh lā' hualh: ");
INSERT INTO tooNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Jesús xala' nac Nazaret, ¿a'chī' ta't a'nlhā icui'lāna'uj? ¿Chā ta'nī'ta' para naquilāmālaksputūyāuj? Quit iclakapasāni'. Hui'x ixla' Dios lā' santo hui'x. ");
INSERT INTO tooNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús lacaquilhnīlh huan tlajana' lā' huanilh: ―¡Quilhca'cs! ¡Lā' camakxtekti huā'mā' chi'xcu'! Lā' huan tlajana' māyujūlh huan chi'xcu' na ixlacapūnca'n huan tachi'xcuhuī't lā' makxtekli huan chi'xcu'. Lā' nīn tuntū' lani'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ixlīhuākca'n lej talē'cnīlh lā' talāhuanilh: ―¿Tuchūyā tachihuīn huā' tamā'na'? ¡Huā'mā' chi'xcu' līchihuīna'n con līmāpa'ksīn lā' tataxtu huan tlajana'nī'n! ");
INSERT INTO tooNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Lā' chuxalhā pajtzu nac Capernaum talātā'chihuīna'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lā' a'xni'ca Jesús taxtulh de nac lītokpān, a'lh lā' tanūlh na ixchic Simón. Lā' ixpuhuiti' Simón lej ixchi'chīxni'mā'. Lā' squi'ni'ca Jesús que camātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Lā' Jesús taquilhpūtalh a'nlhā ixmā' lā' lacaquilhnīlh huan tachi'chīxni' lā' mixli. Chu līmaktin tā'kaquī'lh huan puscāt lā' tzuculh cāmāhuī'. ");
INSERT INTO tooNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Lā' a'xni'ca' ixtā'cnūmā'tza' huan chi'chini', ixlīhuākca'n a'ntī ixta'ī'tza'ca'n de tāpālhūhua' ta'jatatna' cālīmini'ca Jesús. Lā' cāmacaxapalh lā' cāmātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Lā' lhūhua' a'ntī ixtaka'lhī tlajana' cāmātzeyīlh. Lā' huan tlajana'nī'n cāmakxtekli. Lā' tahuanilh: ―Hui'x ixO'kxa' Dios. Lā' Jesús cālacaquilhnīlh huan tlajana'nī'n lā' tū' cāmakxtekli natachihuīna'n como xlaca'n taca'tzīlh que ū'tza' Cristo a'ntī Dios lacsacui'līlh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lā' a'xni'ca tuncuīlh, Jesús taxtulh de nac xcānsipej lā' a'lh a'nlhā tintī' ixa'nan. Lā' huan tachi'xcuhuī't ixtaputzamā'na lā' takaksli a'nlhā ixuī'. Tū' ixtamakxtekcu'tun ixa'lh makat. ");
INSERT INTO tooNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Lā' Jesús cāhuanilh: ―Maclacasqui'n na'iccāmāsu'ni' huan xatzey tachihuīn ā'makapitzīn xalanī'n xtunc cā'lacchicni'. Na'iccāmāsu'ni' ixpālacata a'nchī Dios māpa'ksī. U'tza' quilīmacamilh. ");
INSERT INTO tooNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Lā' chuntza' ixcāmāsu'ni'tēlha Jesús nac huan lītokpānna' xala' nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lā' milh lakatin chi'chini' a'xni'ca' Jesús ixuī' na ixquilhtūn huan lago ixtacuīni' Genesaret. Lā' tanto lhūhua' tachi'xcuhuī't tamilh que ixtalāpi'ta'tza' para natalaktapajtzū Jesús como ixtakaxmatcu'tun ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús cālaktzī'lh tantu' barcos ixquilhtūn huan lago lā' nīn tintī' ixpūtojōma'. Ixtēcu'ca'n ixta'a'nī't talakche'kē' ixpūxuākna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Lā' tuncan Jesús tōca'lh huan nac lakatin barco a'ntū ixla' Simón lā' hualh que camātampūxtuca macsti'na'j de nac quilhtūn. Lā' tuncan Jesús tahui'lalh nac barco lā' a'ntza' tzuculh cāmāsu'ni' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lā' a'xni'ca' cāmāsu'ni'kō'lh, huanilh huan Simón: ―Calī'pi huā' barco a'nlhā pūlhmā'n lā' camojō'tit mimpūxuākna'ca'n para nachi'payā'tit squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Lā' Simón kalhtīlh: ―Mākalhtō'kē'ni', tintascactza' icsquī'tī'ninī'tauj lā' nīn tuntū' icchi'panī'tauj. Pero por minquilhtampān na'icmacā'nāuj quimpūxuākna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lā' a'xni'ca' tatlahualh chuntza', tanto lhūhua' squī'ti' talaknūcha' nac pūxuākna' lā' ixtaxtī'tmā'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Chu tuncan tamacahuani'lh ixtā'squī'tīni'nī'n nac ā'lakatin barco para que natamin natamaktāyana'n. Tamilh lā' tamaktāyalh. Lā' huan squī'ti' lītatzumalh huan tantu' barcos hasta ixtatā'cnūcu'tuntza'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lā' a'xni'ca' Simón Pedro laktzī'lh, tatzokostalh na ixlacapūn Jesús lā' huanilh: ―Māpa'ksīni', caquintapānū'ni' como quit tū' tzeyā chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chuntza' huanilh como Simón lā' ixlīhuākca'n a'ntī ixtatā'squī'tī'nimā'na talē'cnīlh ixpālacata huan lhūhua' squī'ti' a'ntū tachi'palh. ");
INSERT INTO tooNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nā Jacobo lā' Juan a'ntī ixo'kxa'n Zebedeo lā' a'ntī ixtā'squī'tīni'nī'n Simón nā xlaca'n tajicua'lh. Lā' Jesús huanilh Simón: ―Tū' cajicua'. Lā' hua'chi milītlōt ixuanī't ū'tza' milīsquī'tī'ni', chuhua'j milītlōt nahuan nacāmākalhlaka'ī'nī'ya' tachi'xcuhuī't ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Lā' tuncan a'xni'ca' huan barcos tachā'lh nac ti'ya't, ta'a'kxtekmaka'nkō'lh lā' tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Lā' a'xni'ca' Jesús ixuī' nac lakatin cā'lacchicni', lakchā'lh kalhatin chi'xcu' a'ntī ixka'lhī huan ta'jatat a'ntū māmasī quinquinītca'n lā' a'ntū huanican lepra. Lā' a'xni'ca' huan ī'tza'ca' laktzī'lh Jesús, tatzokostani'lh lā' lej squi'ni'lh lā' huanilh: ―Māpa'ksīni', palh hui'x lacasqui'na', tzē naquimātzeyī'ya'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Lā' tuncan Jesús xa'malh lā' huanilh: ―Chuntza' quit iclacasqui'n. Catzeya'nti. Lā' a'xni'ca' hualh huā'mā', tapānūni'lh ixta'jatat huan ī'tza'ca'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Lā' tuncan Jesús māpa'ksīlh que tintī' nahuani. Huanilh: ―Xmān calakpi huan ixcuraca'n israelitas lā' camā'su'ni' mimacni' para nalaktzī'n palh tzeyanī'ta'tza'. Lā' namaxquī'ya' lē'ksajna' hua'chi māpa'ksīni'lh Moisés. Chuntza' naca'tzīcan que tzeyanī'ta'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Lā' a'yuj Jesús huanilh que tū' ixuanilh nīn tintī', pero ā'chulā' lakachu huan tachi'xcuhuī't takaxmatli ixpālacata Jesús. Lā' līlhūhua' ixtatakēstoka para natakaxmata lā' para que ixcāmātzeyīni'ca ixta'jatatca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Lā' Jesús tamakatīlh lā' a'lh ā'lacatin a'nlhā tintī' ixa'nan lā' a'ntza' tlahualh ixoración. ");
INSERT INTO tooNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lā' milh lakatin chi'chini' a'xni'ca' Jesús ixmāsu'yumā' lā' ixtakaxmatui'lāna' ā'makapitzīn fariseosnu' lā' huan xamākalhtō'kē'ni'nī'n ley. Ixtaminī'ta'ncha' de nac Jerusalén lā' de lhūhua' cā'lacchicni' xala' nac Galilea lā' Judea. Lā' ixtasu'yu ixlīmāpa'ksīn Dios como Jesús ixcāmātzeyīmā' ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Lā' tuncan a'xni'ca' tachā'lh huan tachi'xcuhuī't lā' talīmilh nac laklaj kalhatin ī'tza'ca' a'ntī lhtuculu' ixuanī't. Ixtamānūcu'tun ixchakān chic para natamāpī' na ixlacapūn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Lā' como lhūhua' ixtahuanī't huan tachi'xcuhuī't tūla ixtatanū huan nac chic. U'tza' talītō'calh ixa'kstīn huan chic lā' ta'a'kstīlhua'kli huan chic. Lā' a'ntza' talacmānūlh huan ī'tza'ca' con ixlaklaj na ixlaclhni' tachi'xcuhuī't hasta na ixlacapūn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lā' a'xni'ca' Jesús ca'tzīlh que takalhlaka'ī'lh, xla' huanilh huan ī'tza'ca': ―Na'icmāsputūnu'ni'yāni' ixlīhuāk mintalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Lā' tuncan huan fariseosnu' lā' xamākalhtō'kē'ni'nī'n ley xlaca'n tatzuculh tapuhuan: “¿Tichūyā chi'xcu' a'ntī chihuīna'n contra Dios? Nīn tintī' tzē naquincāmāsputūnu'ni'yāni' quintalaclē'i'ca'n, xmān Dios”. ");
INSERT INTO tooNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Lā Jesús, como ixca'tzī a'nchī ixtapuhuamā'na, cāhuanilh: ―¿A'chī' puhua'nā'tit chuntza' na mi'a'clhcunucca'n? ");
INSERT INTO tooNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Icuanilhtza' huan ī'tza'ca': “Icmāsputūnu'ni'ntza' mintalaclē'i'”. Pero tuntū' tasu'yu a'yuj māsputūnu'ni'ca. Palh xa'icuanilh: “Catā'kaqui' lā' casmi'li' mixti'cat lā' catlā'hua'”, chuntza' ixtasu'yulh palh tzeyalh o tū'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Quit huan Chi'xcu' xala' Tālhmā'n. Lā' chuhua'j na'iccāmāsu'ni'yāni' a'nchī icka'lhī līmāpa'ksīn nac huā'mā' cā'quilhtamacuj lā' tzē na'iccāmāsputūnu'ni' ixtalaclē'i'ca'n tachi'xcuhuī't. Lā' chu tuncan huanilh huan ī'tza'ca': ―Icuaniyāni', catā'kaqui' lā' calī'pi milaklaj lā' capit na minchic. ");
INSERT INTO tooNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chu līmaktin tā'kaquī'lh huan ī'tza'ca' na ixlacapūnca'n lā' sacli ixlaklaj lā' a'lh na ixchic. Lā' a'lh mācā'tanītēlhā Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Lā' ixlīhuākca'n talē'cnīlh lā' tamācā'tanīlh Dios. Tajicua'lh lā' tahualh: ―Huā'mā' chi'chini' lakzī'nī'tauj lej ka'tla' lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lā' ā'calīstān Jesús taxtulh lā' laktzī'lh kalhatin mātā'jīni'. Ixtacuīni' Leví lā' ixuī a'nlhā i'xmātā'jīni'ncan. Lā' huanica: ―Caquistāla'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lā' tuncan tāyalh lā' makxtekkō'lh lā' stālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lā' ā'calīstān Leví cāxtlahualh lakatin ka'tla' cā'tani' na ixchic para na'a'cnīni'ni' Jesús. Lā' lhūhua' mātā'jīni'nī'n lā' ā'makapitzīn chi'xcuhuī'n ixtatā'huā'yamā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Lā' tuncan huan fariseosnu' lā' huan xamākalhtō'kē'ni'nī'n ley tapuhualh palh tū' tzey. Lā' tatzuculh tatā'chihuīna'n ī'sca'txtunu'nī'n Jesús lā' tahuanilh: ―Lā' ¿a'chī' tā'huā'yanā'tit con huan mātā'jīni'nī'n lā' con huan tūn tū' tzeyā chi'xcuhuī'n? ");
INSERT INTO tooNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Lā' Jesús cākalhtīlh: ―Huan a'ntīn tū' ta'ī'tza'ca'n, xlaca'n tū' tamaclacasqui'n doctor, xmān huan a'ntīn ta'ī'tza'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Quit tū' icmilh iccāputza a'ntīn tapuhuan palh xlaca'n xalacuan. Icmilh iccāputza huan tachi'xcuhuī't a'ntīn taca'tzī palh tū' tzey xlaca'n, como iclacasqui'n que nataxtāpalī ixtapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lā' tuncan xlaca'n takalhasqui'nīlh Jesús: ―Lā' huan a'ntī tastālani'lh Juan, tū' tahuā'yan a'xni'ca' lej tatlahua ixoraciónca'n. Lā' nā chuntza' huan fariseosnu'. Lā' misca'txtunu'nī'n pō'ktu tahuā'yan lā' tako'tnūn. Lā' ¿a'chī'? ");
INSERT INTO tooNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Lā' Jesús cākalhtīlh: ―¿Chā natalakaputza huan a'ntī cākantāyacan a'nlhā tapūchahuamā'ca? Līhuan huī' huan squi'nīni', tū' talakaputza. ");
INSERT INTO tooNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Namin lakatin chi'chini' a'xni'ca' nalē'ncan huan squi'nīni' lā' a'xni'ca' natalakaputza ixamigos lā' tū' catitahuā'yalh. A'xni'ca Jesús cāhuanilh huā'mā', ixlīchihuīna'mā'ca māni' xla'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nā chuntza' cāhuanilh huā'mā' a'ntū lītalacastuca: ―Tintī' nachu'cu xasāsti' ixlu'xu' para nalīlactza'pa' huan xamasni'. Palh chuntza' ixtlahuaca tū'tza' tzey huan xasāsti' lu'xu' lā' huan līlactza'pa'n más palha' que huan xamasni'. ");
INSERT INTO tooNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Lā' huan xaxcān uva a'ntū tūna'j xcu'tan nīn tintī' catimojōlh nac xakōlūhua' ixko'xka' borrego. Namojōcan nac xasāsti' ko'xka' lā' chuntza' a'xni'ca' naxcu'tan, tū' catipankli huan ko'xka'. Chuntza' tū' catipāxcatlalh huan ko'xka' lā' tū' catitaxtulh huan xaxcān uva. ");
INSERT INTO tooNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","U'tza' nalīmojōcan xasāsti' xaxcān uva nac xasāsti' ko'xka' lā' a'xni'ca' naxcu'tan huan xaxcān, huan ko'xka' nataxtō'nka lā' tū' catitaxtī'tli. ");
INSERT INTO tooNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Lā' nā chuntza' a'ntī quilhca'tzīlh xaxcān uva a'ntū makāntza' xcu'tanī't, tū' catilakatīlh xaxcān uva a'ntū tū' lej makān xcu'tanī't. Nahuan: “Más tzey huan xakōlūhua'”. ");
INSERT INTO tooNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Maktin huā lakatin chi'chini' a'ntū ixpūjaxcan a'xni'ca' Jesús ixtalatlā'huan nac cā'tacuxtu lā' ī'sca'txtunu'nī'n tatē'ī'lh pātin pātū tza'ksa'. Lā' tuncan tapa'sli lā' tahua'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Lā' makapitzīn huan fariseosnu' cākalhasqui'nīlh: ―¿A'chī' scujpā'na'ntit huan chi'chini' a'ntū pūjaxcan? Tū' līmakuan. ");
INSERT INTO tooNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Lā' Jesús cākalhtīlh: ―¿Chū tū' lakapūtle'kenī'ta'ntit a'ntūn tlahualh David maktin huā? Xla' lā' a'ntī ixta'a'mā'na ixtatzi'ncsmā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lā' tanūlh na ixchic Dios lā' tēlh huan pāntzi a'ntū ixmālacnūni'canī't Dios. Hua'lh lā' nā tā'hua'lh a'ntī ixtatā'a'mā'na, a'yuj tū' minī'ni' nahua' ā'kalhatin, xmān huan cura. ");
INSERT INTO tooNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nā cāhuanilh: ―Lā' quit huan Chi'xcu' xala' Tālhmā'n lā' tzē na'icmāpa'ksī a'ntū natlahuacan huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Maktin huampala chi'chini' de pūjaxni' a'xni'ca' Jesús tanūlh na ixlītokpānca'n israelitas lā' tzuculh māsu'yu. Lā' ixuī' a'ntza' kalhatin chi'xcu' ixmacascōhuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lā' huan xamākalhtō'kē'ni'nī'n ley ixtamaktaka'lhmā'na Jesús a ver palh ixmātzeyīni'lh huan chi'chini' a'ntū pūjaxcan. Chuntza' tzē ixtalē'ksa'nīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Lā' xla' ca'tzīlh a'ntū ixtapuhuan lā' huanilh huan chi'xcu' a'ntī ixmacascōhuanī't: ―Catāqui' lā' catāya' na quilaclhpu'nanca'n. Lā' huan chi'xcu' tāquī'lh lā' tāyalh a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Lā' tuncan Jesús cāhuanilh: ―Na'iccākalhasqui'nīyāni' catūhuā. ¿Tuchū más minī'ni' tzē tlahuacan huan chi'chini' a'ntū pūjaxcan? ¿Chā na'ictlahua a'ntū tzey o a'ntūn tū' tzey? ¿Chā līmakuan na'icmāpūtaxtū huan chi'xcu' o na'icmāpānūni' ixlīca'tzīn? ");
INSERT INTO tooNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Lā' tuncan Jesús cālaktzī'lh ixlīhuākca'n a'ntī ixtalītamacxti'li'nī't lā' huanilh huan chi'xcu': ―Castu'ncti mimacan. Huan chi'xcu' stu'ncli lā' tzeyalh ixmacan. ");
INSERT INTO tooNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Lā' xlaca'n lej ta'a'kchā'lh lā' tatzuculh talacchihuīna'n a'ntū natatlahuani' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Huan tamā'na chi'chini' Jesús a'lh nac lakatin kēstīn para na'orarlī. Lā' tintascac ixorarlīmā'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lā' ixlīlakalī cāta'sani'lh ī'sca'txtunu'nī'n lā' cālacsacli kalhacāujtu' lā' cāmāpācuhuīlh apóstoles. ");
INSERT INTO tooNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Xlaca'n cāhuanican Simón a'ntī ixlītāpātu' ixtacuīni' Pedro lā' Andrés ī'stancu Simón lā' Jacobo lā' Juan lā' Felipe lā' Bartolomé ");
INSERT INTO tooNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","lā' Mateo lā' Tomás lā' Jacobo ixo'kxa' Alfeo lā' Simón a'ntī ixlītāpātu' ixtacuīni' Zelote ");
INSERT INTO tooNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","lā' Judas ixtā'tin Jacobo lā' Judas Iscariote a'ntī macamāstā'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús cātā'yujli xlaca'n de nac kēstīn lā' tachokolh a'nlhā pūsca'nan con ī'sca'txtunu'nī'n. Lā' ixuī' lhūhua' tachi'xcuhuī't de lakachu nac Judea lā' xalanī'n nac Jerusalén lā' xalanī'n ixquilhtūn mar pajtzu a'nlhā ixuanican Tiro lā' Sidón. Xlaca'n ixtachā'nī't para natakaxmata Jesús lā' para que ixcāmātzeyīni'lh ixta'jatatca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Lā' a'ntī ixtaka'lhī huan tlajana' nā cāmātzeyīca xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ixlīhuākca'n huan tachi'xcuhuī't ixtaxa'macu'tun Jesús como xla' cālīcu'chū'kō' con ixlīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Lā' tuncan Jesús cālaktzī'lh ī'sca'txtunu'nī'n lā' cāhuanilh: ―Pāxuhuayā'tit a'ntīn tū' ka'tla'jca'tzīyā'tit como Dios cāmāpa'ksīmā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Pāxuhuayā'tit a'ntī putzapā'na'ntit ixtapuhuān Dios como xla' nacāmaktāyayāni'. ’Pāxuhuayā'tit a'ntī calhuampā'na'ntit chuhua'j como ā'calīstān napāxuhuayā'tit a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Napāxuhuayā'tit a'xni'ca' tachi'xcuhuī't tū' cātalaktzī'ncu'tunāni' lā' a'xni'ca' nacātamāxtunquī'yāni' quimpālacata quit huan Chi'xcu' xala' Tālhmā'n. Lā' napāxuhuayā'tit a'xni'ca' cātalakapalayāni' lā' a'xni'ca' nacātalakmaka'nāni' hua'chilh tū' tzey hui'xina'n, lā' ixlīhuāk por quimpālacata quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lej capāxuhua'tit lā' caka'lhī'tit tapāxuhuān a'xni'ca' chuntza' napātīni'nā'tit como nac a'kapūn naka'lhī'yā'tit huāk a'ntūn tzey. Huan a'ntī cātamāpātīnīyāni', nā chuntza' ixnapapana'ca'n tamāpātīnīlh huan ixa'cta'sana'nī'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero lej nalakaputzayā'tit hui'xina'n ricosnu' como tlahua'tittza' mintapāxuhuānca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Lej nalakaputzayā'tit hui'xina'n a'ntī lej lhūhua' ka'lhīyā'tit chuhua'j como ticāmakasputāni'. ’Lej nalakaputzayā'tit hui'xina'n a'ntī chuhua'j lītzī'mpā'na'ntit como nacalhua'nā'tit con talakaputzīt. ");
INSERT INTO tooNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Lej nalakaputzayā'tit hui'xina'n a'xni'ca' ixlīhuāk nata'a'cnīni'ni'yāni' como ixnapapana'ca'n xlaca'n chuntza' makān ixtatlahuani' huan a'cta'sana'nī'n a'ntīn tahualh a'ntūn tū' stu'ncua. ");
INSERT INTO tooNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Lā' Jesús cāhuanipā: ―Lā' iccāhuaniyāni' hui'xina'n a'ntī quilākaxmatāuj: Cacāpāxquī'tit mintā'ca'tzaca'n lā' nacāmaktāyayā'tit a'ntīn tū' cālaktzī'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Casqui'ni'tit Dios que cacāsicua'lanālīlh a'ntī cachīhuā cātalīchihuīna'nāni' lā' na'orarlīyā'tit por a'ntī cālakapalayāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Palh catīhuā nalacala'sāni' milacapītin, natamakxteka' nalacala'sāni' ā'milacapītin. Lā' palh catīhuā namāmakxtuyāni' mintakēnū, ca'a'kataxtuni' nā mincamisa. ");
INSERT INTO tooNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Camaxqui' chuxatī a'ntī squi'ni'yāni' lā' palh catīhuā namāmakxtuyāni' a'ntū mila', tū'tza' tisqui'ni'ya'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chuntza' natlahua'ni'ya' ā'chā'tin chu a'cxtim hua'chi lacasqui'na' xla' natlahua'ni'yāni' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Palh xmān cāpāxquī'yā'tit a'ntīn tapāxquī'yāni', ¿chu tzeyā chi'xcuhuī'n hui'xina'n na ixlacapūn Dios? Huan a'ntīn tū' tzey nā chuntza' talāpāxquī'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Lā' palh xmān cāmaktāyayā'tit a'ntīn tamaktāyayāni', ¿chu tzeyā chi'xcuhuī'n hui'xina'n na ixlacapūn Dios? A'cxtim talāmaktāya huan a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Lā' palh xmān namāsācua'nī'yā'tit a'ntī tzēn natamāstā'chokopala, ¿chu tzeyā chi'xcuhuī'n hui'xina'n na ixlacapūn Dios? A'ntīn tū' tzey nā tamāsācua'nī i'xtā' tū' tzey como taca'tzī namāstā'pala. ");
INSERT INTO tooNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Hui'xina'n nacāpāxquī'yā'tit mintā'ca'tzaca'n lā' nacāmaktāyayā'tit lā' nacāmāsācua'nī'yā'tit lā' tū' catiputzalh a'ntū nacālīmāpalani'yāni'. Chuntza' naka'lhī'yā'tit ka'tla' mintatlajca'n nac a'kapūn lā' nala'yā'tit ixcamana' a'ntī xala' tālhmā'n lā' a'ntī lej ka'tla' como nā xla' cālakalhu'man huan tampi'lhīni'nī'n lā' huan a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cacālakalhu'mantit tachi'xcuhuī't como hua'chi minTāta'ca'n Dios nā cālakalhu'man. ");
INSERT INTO tooNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Lā' Jesús cāhuanipā: ―Tū' caticā'a'ksa'ntit ā'makapitzīn lā' Dios tū' nacāmālaclē'nīyāni'. Tū' timālaclē'nīni'nā'tit lā' Dios tū' caticāmālaclē'nīni' hui'xina'n. Nalāmāsputūnu'ni'yā'tit lā' Dios nacāmāsputūnu'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cacāmaxquī'tit ā'makapitzīn lā' nā Dios nacāmaxquī'yāni' hui'xina'n. Xla' lej nacāmaxquī'yāni' hua'chi a'ntī xa'nca pūlhcāna'n lā' naxakā'lī huan cuartillo lā' nachiqui lā' namātzuma hasta natakalhmaka'n lā' namojō na mimorralhca'n. A'cxtim hua'chi hui'xina'n namaxquī'yā'tit ā'chā'tin, chuntza' Dios nacāmaxquī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús cāhuanilh huā'mā' a'ntū lītalacastuca: ―¿Chu tzēn kalhatin lakatzī'n napū'lani' ixtā'lakatzī'n? ¿Chu tū' catikostajōlh nac lakatin lhu'cu'? ");
INSERT INTO tooNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tintī' ā'kalhatin sca'txtunu' a'ntī más ca'tzī que ixmākalhtō'kē'ni' a'yuj tzē namālacastuca huan mākalhtō'kē'ni' a'xni'ca' natlahuakō' ixlīscatat. ");
INSERT INTO tooNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chichū tzē nalaktzī'na' huan ti'na'j pa'lhma' na ixlakastapun mintā'tin palh tanūma' hua'chi kentin qui'hui' na milakastapun? ");
INSERT INTO tooNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Palh tū' pū'la namaxtuya' huan qui'hui' na milakastapun, tūlalh catima'xtuni' huan pa'lhma' na ixlakastapun mintā'tin. ¡A'kxokonu'na'! Pū'la camāxtu' huan xaka'tla' pa'lhma' de na milakastapun lā' chuntza' xa'nca nalaktzī'na' para namāxtuya' huan ti'na'j pa'lhma' a'ntū tanūma' na ixlakastapun mintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Lā' Jesús cāhuanipā: ―Tintī' xatzey qui'hui' a'ntū namāstā' ixtō'ca't a'ntūn tū' tzey. Lā' nīn tintī' qui'hui' a'ntūn tū' tzey lā' namāstā' xatzey ixtō'ca't. ");
INSERT INTO tooNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Lā' kantin qui'hui' līlakapascan por ixtō'ca't. Tūla pu'xcan huan higo de huan lhtucū' qui'hui' lā' tūla pu'xcan uvas de huan xamayāc caxanilh. ");
INSERT INTO tooNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Huan tzeyā chi'xcu' tlahua a'ntūn tzey porque tzey ixtapāstacna'. Lā' huan tūn tū' tzeyā chi'xcu' tlahua a'ntūn tū' tzey como tū' tzey ixtapāstacna'. A'nchī pō'ktu pāstacna'na', chuntza' nachihuīna'na'. ");
INSERT INTO tooNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Lā' Jesús cāhuanipā: ―Palh quilāmāpācuhuīyāuj: “Māpa'ksīni'”, ¿a'chī' tū' tlahua'yā'tit a'ntū quit iccālīmāpa'ksīyāni'? ");
INSERT INTO tooNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Huan a'ntī namin para que naquinkaxmata lā' natlahua a'ntū icmāpa'ksī, na'iccāhuaniyāni' a'nchī tasu'yu. ");
INSERT INTO tooNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xla' lītasu'yu hua'chi kalhatin chi'xcu' a'ntī yāhualh ixchic. Pū'la ponknu'lh pūlhmā'n lā' xa'nca yāhualh ixtantūn. Lā' a'xni'ca' stacli huan pūxka, snū'n tahui'lani'lh huan chic. Lā' tū' xakā'līlh como xa'nca yāhuacanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Lā' a'ntīn quinkaxmata lā' tū' natlahua a'ntū icmāpa'ksī, ū'tza' tasu'yu hua'chi kalhatin chi'xcu' a'ntī yāhualh ixchic lā' tū' pūlhmā'n ponknu'lh. Lā' a'xni'ca' stacli huan pūxka lā' snū'n tahui'lani'lh huan chic, a'kā'lh lā' mū'xtulh lā' laclakō'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A'xni'ca' Jesús cāmāsu'ni'kō'lh huan tachi'xcuhuī't, a'lh nac Capernaum. ");
INSERT INTO tooNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Lā' a'ntza' ixuī' kalhatin capitán xala' nac Roma. Lā' ixka'lhī kalhatin ixtasācua' a'ntī lej ixpāxquī'. U'tza' ī'tza'ca'ni'lh hasta ixnīmā'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lā' a'xni'ca' huan capitán kaxmatli līchihuīna'mā'ca Jesús, cāmacā'lh ā'makapitzīn papatzīnni' israelitas para natasqui'ni' que camilh lā' camātzeyīlh ixtasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xlaca'n talaktapajtzūlh Jesús lā' tatzuculh tasqui'ni'. Lā' tahuanilh: ―Lej līmakuan namaktāya'ya' huā'mā' capitán ");
INSERT INTO tooNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","como quincā'a'cnīni'ni'yāni' quina'n israelitas. Lā' māni' xla' mātlahuīni'lh quilītokpānca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tuncan Jesús cātā'a'lh. Lā' a'xni'ca' pajtzutza' ixta'a'mā'nancha' de huan ixchic, huan capitán cāmacamilh ā'makapitzīn amigosnu' para natahuani Jesús: ―Māpa'ksīni', tū' catamakchuyi'. Hui'x lej ka'lhī'ya' līmāpa'ksīn lā' tū' minī'ni' natanū'ya' nac quinchic. ");
INSERT INTO tooNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","U'tza' iclīpuhualh que chō'la tū' minī'ni' palh icquīputzanī'ta'ni'. Xmān namāpa'ksī'ya' lā' natzeyan quintasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Māni' quit nā quintamāpa'ksī huan xalaka'tla' lā' nā quit iccāmāpa'ksī huan quintropasna'. A'xni'ca' na'icuani kalhatin tropa que ca'a'lh, xla' na'a'n. Lā' a'xni'ca' na'icuani ā'kalhatin que camilh, xla' namin. Lā' a'xni'ca' na'icuani quintasācua' que catlahualh catūhuā, xla' natlahua a'ntū icuanilh. ");
INSERT INTO tooNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","A'xni'ca' Jesús kaxmatli huā'mā' tachihuīn, lej lē'cnīlh lā' cālaktalakspi'tli a'ntī ixtastālani'mā'na lā' cāhuanilh: ―Stu'ncua' a'ntū iccāhuaniyāni'. Tū' iclakapasa nīn tintī' israelita a'ntī quinkalhlaka'ī' hua'chi huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lā' a'xni'ca' huan lacscujnī'n tataspi'tli nac huan chic, talaktzī'lh ixtzeyanī'ttza' huan tasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A'calīstān Jesús a'lh nac lakatin cā'lacchicni' ixtacuīni' Naín lā' cātā'a'lh ī'sca'txtunu'nī'n lā' līlhūhua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Lā' a'xni'ca' pajtzutza' i'xta'a'mā'na de huan cā'lacchicni' lā' laktzī'lh que ixlīmimā'ca huan nīn para namā'cnūcan. Lā' ixtzī't huan o'kxa' a'ntī ixnīnī't lakapūt ixuanī't. Lā' xmān kalhatin ixuanī't ixcaman huan lakapūt. Līlhūhua' xalanī'n huanmā' cā'lacchicni' ixtatā'a'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lā' a'xni'ca' laktzī'lh huan lakapūt, huan Māpa'ksīni' lakalhu'malh lā' huanilh: ―Tū' caca'lhua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tuncan Jesús laktapajtzūlh lā' xa'malh huan caja. Lā' a'ntī ixtalē'mā'na tatāyalh. Lā' Jesús huanilh huan nīn: ―O'kxa', quit icuaniyāni': ¡Catā'kaqui'! ");
INSERT INTO tooNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tuncan tā'kxpāquī'lh lā' tahui'lalh huan a'ntī ixnīnī't lā' tzuculh chihuīna'n. Lā' Jesús a'kataxtuni'lh ixtzī't. ");
INSERT INTO tooNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Lā' a'xni'ca' talaktzī'lh huā'mā', huan tachi'xcuhuī't tajicua'nkō'lh lā' tatzuculh ta'a'cnīni'ni' Dios lā' tahualh: ―Tasu'yulh kalhatin ka'tla a'cta'sana' na quilaclhni'ca'n. Nā tahualh: ―Dios quincālakalhu'manāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lā' chu lakachu nac Judea lā' a'nlhā pajatzu, ixlīhuāk taca'tzīlh a'ntū tlahualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","I'sca'txtunu'nī'n Juan tamāca'tzīnīlh a'ntū ixtlahuamā' Jesús. Lā' tuncan cāta'sani'lh kalhatu' ī'sca'txtunu'nī'n ");
INSERT INTO tooNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","lā' cāmacā'lh para natakalhasqui'nī Jesús a ver palh stu'ncua' xla' huan Cristo a'ntī namin o palh naka'lhī ā'kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Huan kalhatu' ixlacscujnī'n Juan talakmilh Jesús lā' tahuanilh: ―Juan huan Mā'kpaxīni' quincātalakmacamini' lā' ū'tza' ca'tzīcu'tun palh stu'ncua' hui'x Cristo a'ntī namin o palh na'icka'lhīyāujcus ā'kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chū'tza' huā'mā' ka'tlā'tus Jesús cāmātzeyīlh lhūhua' ī'tza'ca'nī'n lā' cāmāxtuni'lh lhūhua' huan tlajana'nī'n. Nā lhūhua' lakatzī'nī'n cāmālacahuānīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Chuntza' cākalhtīlh Jesús: ―Cataspi'ttit lā' nahuaniyā'tit Juan a'ntū laktzī'nī'ta'ntit lā' a'ntū kaxpatnī'ta'ntit. Nahuaniyā'tit a'nchī huan lakatzī'nī'n talacahuāna'n lā' nā huan lū'ntū'lanī'n talatlā'huan. Lā' nā huan a'ntī ixcāmasni'mā' ixquinītca'n, xlaca'n tatzeyanli. Lā' huan a'ntīn tū' ixta'a'kahuāna'n chuhua'j takaxmata lā' nā cāmālakahuanīchokocanī't huan a'ntī ixtanīnī'ttza'. Lā' cāmāsu'ni'can a'nchī nacālīmāpūtaxtūcan a'ntī līpānīn talahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Līpāxūj a'ntī takalhlaka'ī' que Dios quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","A'xni'ca' ixta'a'nī't ixlacscujnī'n Juan, Jesús tzuculh cātā'chihuīna'n tachi'xcuhuī't ixpālacata Juan lā' cāhuanilh: ―A'xni'ca' quīla'tit nac cā'lhpi'mpi'li' ti'ya't, ¿tichū ixlaktzī'ncu'tunā'tit? Tū' quīla'tit para nalaktzī'nā'tit kalhatin chi'xcu' a'ntī hua'chi kantin chi'tin a'ntū xakā'līlh huan ū'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿A'chī' quīla'tit? Tū' quīla'tit para nalaktzī'nā'tit kalhatin chi'xcu' a'ntī lej tzēhuanī't lhakā'nanī't. Hui'xina'n ca'tzīyā'tit que huan a'ntī pō'ktu lej tzēhuanī't talhakā'nanī't lā' pō'ktu tapaxialhna'n, xlaca'n tahui'lāna' na ixchicca'n reyes. ");
INSERT INTO tooNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pues ¿a'chī' quīla'tit nac cā'lhpi'mpi'li' ti'ya't? ¿Chu tū' quīla'tit para nalaktzī'nā'tit kalhatin a'cta'sana'? Stu'ncua', ixlaktzī'ncu'tunā'tit kalhatin a'cta'sana'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lā' huā'mā' a'cta'sana' ixtacuīni' Juan. Lā' ixpālacata huā'mā' Juan tatzo'knī't chuntza' na ixtachihuīn Dios: Na'icmacā'n qui'a'cta'sana' a'ntī napū'lani'yāni' para nacāxmāpī' mintej. ");
INSERT INTO tooNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Lā' iccāhuaniyāni' que na ixlaclhni'ca'n tachi'xcuhuī't tintī' kalhatin a'cta'sana' más xaka'tla' que Juan huan Mā'kpāxīni'. Pero huan a'ntī līhua'ca' xamakstancu a'nlhā Dios māpa'ksīni'n, xla' más xaka'tla' que Juan. ");
INSERT INTO tooNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","A'xni'ca' takaxmatli huā'mā' tachihuīn, ixlīhuākca'n tachi'xcuhuī't lā' huan mātā'jīni'nī'n a'ntī Juan ixcāmā'kpaxīnī't, xlaca'n ixtalāhuani que lej tzey Dios por ixpālacata a'ntū ixcāhuaninī't Juan. ");
INSERT INTO tooNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero huan fariseosnu' lā' huan mākalhtō'kē'ni'nī'n ley a'ntīn tū' ixcāmā'kpaxīnī't Juan, xlaca'n talakmaka'lh a'ntū Dios ixcātlahuani'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Lā' huan Māpa'ksīni' hualh: ―¿Chichū na'iccālīmālacastucāuj huan tamā'na chi'xcuhuī'n? ¿Chichū tatasu'yu? ");
INSERT INTO tooNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tatasu'yu hua'chi camana' a'ntī takamāna'mā'na nac lītamāuj. Cātā'ta'sa ixtā'camana' lā' tahuani: “A'xni'ca' quina'n icmakata'sauj huan līskoli', hui'xina'n tū' lakatītit lā' tū' lu'cxtit. Lā' a'xni'ca' ictlī'uj hua'chi līlakaputzani', hui'xina'n tū' lakatītit lā' tū' calhua'ntit. ¿Tuchū lacasqui'nā'tit?” tahuan. ");
INSERT INTO tooNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Chuntza' līlayā'tit hui'xina'n como huanā'tit que Juan huan Mā'kpaxīni' ka'lhī tlajana' porque tū' hua' pāntzi lā' tū' ko'ta. ");
INSERT INTO tooNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A'calīstān quit icmilh lā' quit huan Chi'xcu' xala' Tālhmā'n. Lā' quit icuā'yalh lā' icua'lh xcān lā' chuxatū quimālacnūni'ca. Lā' hua'nā'tit que quit lej icuā'yan lā' lej icko'ta, que quit ixamigoca'n mātā'jīni'nī'n lā' a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero huan a'ntīn takalhlaka'ī', xlaca'n tamāchekxī que Dios macamilh Juan lā' nā quit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kalhatin fariseo ixtā'huā'yancu'tun Jesús. Lā' Jesús a'lh na ixchic lā' tahui'lalh nac mesa. ");
INSERT INTO tooNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Lā' nac huanmā' cā'lacchicni' ixuī' kalhatin puscāt xala' nac tej. A'xni'ca' ca'tzīlh que Jesús ixa'nī't huā'yan na ixchic kalhatin fariseo, huan puscāt lē'lh lakatin frasco de aceite a'ntū lej xamu'csa. ");
INSERT INTO tooNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ixcalhuamā' lā' a'xni'ca' tahui'lalh pajtzu ixtojon Jesús lā' yujli ixlakaxta'jat na ixtojon. U'tza' līche'kē'lh ixtojon Jesús. Tuncan līmāscōhuīlh ixyaj lā' tantūmu'sulh lā' lītlahualh aceite a'ntū lej mu'csa. ");
INSERT INTO tooNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lā' a'xni'ca' laktzī'lh huā'mā', huan fariseo a'ntī ixtā'huā'yamā' Jesús, puhualh: “Palh stu'ncua' cahuā huā'mā' chi'xcu' ixa'cta'sana' Dios ixuanī't, ixca'tzīlh tichū xla' lā' tichūyā puscāt xa'malh. Ixca'tzīlh que ixlākalhī'ni'n huan puscāt”. ");
INSERT INTO tooNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tuncan Jesús huanilh huan fariseo: ―Simón, icuanicu'tunāni' lakatin catūhuā. Lā' huan fariseo kalhtīlh: ―Mākalhtō'kē'ni', caquihua'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Lā' Jesús huanilh: ―Ixa'nan kalhatu' chi'xcuhuī'n. Ixtu'ca'n talaclē'ni'lh kalhatin māsācua'nīni'. Kalhatin laclē'ni'lh quinientos denarios (a'ntū tumīn xala' makān). Lā' ā'kalhatin laclē'ni'lh tu'pu'xamacāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Lā' como xlaca'n tūlalh tamāpalalh, huan māsācua'nīni' cāmāsputūnu'ni'lh ixtu'ca'n. Chuhua'j caquihua'ni' ¿tichū más napāxquī' de ixtu'ca'n? ");
INSERT INTO tooNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Lā' Simón kalhtīni'lh: ―Icpuhuan que huan chi'xcu' a'ntī más ixlaclē'nī't. Lā' Jesús huanilh: ―Stu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tuncan Jesús laktalakspi'tli huan puscāt lā' huanica Simón: ―¿Chā laktzī'na' huā'mā' puscāt? Ictanūlh na minchic lā' tū' quimaxquī'nī'ta' xcān para na'iclītantūchaka'n quintojon. Lā' huā'mā' puscāt quilīlacmu'nulh ixlakaxta'jat naquintojon lā' cālīmāscōhuanīnī't ixya'j. ");
INSERT INTO tooNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hui'x tū' quimacamu'sunī'ta' pero xla' desde a'xni'ca' ictanūlh tū' jaxnī't de quintantūmu'su. ");
INSERT INTO tooNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Hui'x tū' quilītlahua' aceite na qui'a'kxāk, pero xla' quilītantūtlahualh ixperfume. ");
INSERT INTO tooNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","U'tza' icuaniyāni' que huan lhūhua' tapāxquī'n māsu'yu que Dios māsputūnu'ni'nī'ttza' ixtalaclē'i' a'yuj lhūhua'. Lā' a'ntīn tū' lej pāxquī'nin māsu'yu que tū' lhūhua' ixtalaclē'i' cāmāsputūnu'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tuncan Jesús huanilh huan puscāt: ―Icmāsputūnu'ni'yāni' mintalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lā' huan a'ntī ixcākantāyacanī't tatzuculh talāhuani: ―¿Tichū huā'mā' chi'xcu' a'ntīn tzē cāmāsputū huan talaclē'i'? ");
INSERT INTO tooNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Lā' Jesús huanilh huan puscāt: ―Māpūtaxtūcanī'ta'tza' como kalhlaka'ī'nī'ta'. Capit con tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","A'calīstān Jesús ixtētaxtumā' nac lhūhua' cā'lacchicni' lā' cā'ranchujnu'. Lā' ixmāsu'yutēlha lā' ixcālītā'chihuīna'ntēlha ixpālacata a'nchī Dios māpa'ksīni'n. Lā' huan kalhacāujtu' sca'txtunu'nī'n ixtatā'a'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nā ixtatā'a'mā'na ā'makapitzīn puscan a'ntī ixcāmāxtuni'canī't huan tlajana' lā' a'ntī ixcāmātzeyīcanī't de huan ixta'jatatca'n. Na ixlaclhni'ca'n ixa'mā' María a'ntī ixlītāpātu' ixtacuīni' Magdalena. U'tza' a'ntī cāmaxtuni'ca lakatojon tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nā ixtā'a'n kalhatin Juana, ixpuscāt Chuza a'ntī xapuxcu' ixtasācua' Herodes. Nā ixtatā'a'mā'na Susana lā' lhūhua' ā'makapitzīn puscan a'ntī ixtalīmaktāyanī't con ixtumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Līlhūhua' tataxtulh de lakatunu' cā'lacchicni' para natakaxmata Jesús. Lā' a'xni'ca' tatakēxtimīlh lhūhua' tachi'xcuhuī't, cāhuanilh a'ntū lītalacastuca. ");
INSERT INTO tooNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Cāhuanilh: ―Kalhatin cha'nāna' taxtulh para nacha'n ixti'ni'. Līhuan ixa'jmaka'mā' ixti'ni' makapitzīn tayujli nac tej lā' cālacchi'ntaca lā' tasacua'lh huan spūnnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Lā' ā'makapitzīn tayujli na ixkalhni' chihuix a'nlhā xmān macsti'na'j ti'ya't ixuī'. Lā' a'xni'ca' pu'nli huanmā' ti'ni' tīlh porque tū' kaksli xcān como tū' pūlhmā'n ixka'lhī huan ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","A'makapitzīn huampala tayujpā na ixlaclhni' lhtucū'n lā' tūlalh stacli como tamā'ktzī'lh huan lhtucū'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Lā' ā'makapitzīn ti'ni' tayujli a'nlhā tzey ti'ya't lā' pu'nli. Lā' a'xni'ca' stacli, lej tō'ca'lh. A'xni'ca' ī'ca, lhūhua' taxtulh de xmān lakatin ti'ni' a'ntū ixa'jmaka'ncanī't hasta lakatin ti'ni' tō'ca'lh cien. A'xni'ca' huankō'lh huā'mā' Jesús cāhuanilh lej palha': ―Pa'lh kaxpa'tā'tit, cuenta catlahua'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tuncan huan ī'sca'txtunu'nī'n takalhasqui'nīlh tuchū huanicu'tun huā'mā' lītalacastuc. ");
INSERT INTO tooNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Lā' cāhuanilh: ―Dios cāmāsca'tīnī'ta'ni' hui'xina'n a'ntūn tatzē'knī't ixpālacata a'nchī nala ixlīmāpa'ksīn Dios. A'makapitzīn iccālīchihuīna'n xmān a'ntū lītalacastuca. Chuntza' a'yuj takaxmatli tū' tamāchekxīlh, lā' a'yuj talaktzī'n tasu'yu hua'chilh tū' talacahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Lā' Jesús cāhuanipā: ―Huā'mā' līmālacastuc huanicu'tun chuntza': Huan ti'ni', ū'tza' ixtachihuīn Dios; ");
INSERT INTO tooNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","lā' huan tej ū'tza' hua'chi tachi'xcuhuī't a'ntīn takaxmata huan tachihuīn. Namin huan ko'ti'ti' lā' nacāmāpātza'nkānī lā' tū' natakalhlaka'ī' lā' tūlalh catitapūtaxtulh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Huan ti'ya't nac cā'chihuixni' ū'tza' hua'chi ā'makapitzīn tachi'xcuhuī't. Xlaca'n takaxmata lā' tapuhuan lej tzey, lā' talakatī pero tū' xa'nca takalhlaka'ī'. Lā' a'xni'ca' tū' cālaktzī'ncu'tuncan ixpālacata ixtachihuīn Dios, palaj natamakxteka. ");
INSERT INTO tooNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","’Huan lhtucū'n, ū'tza' hua'chi ā'makapitzīn huampala tachi'xcuhuī't. Takaxmata huan tachihuīn pero tū' taxtāpalīcu'tun ixtapāstacna'ca'n. Pō'ktu tapāstacmā'na ixlītlōtca'n lā' i'xtumīnca'n lā' a'nchī natalakastāna'n. Chuntza' tūla tasca'ta xa'nca. U'tza' hua'chi huan ti'ni' a'ntū tamā'ktzi'lh huan lhtucū'n. Tūla staca. ");
INSERT INTO tooNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","’Huan xatzey ti'ya't ū'tza' hua'chi tachi'xcuhuī't a'ntī xa'nca takaxmatli huan tachihuīn. Takalhlaka'ī' lā' ta'a'kahuāna'ni' lā' tzeyā chi'xcuhuī'n natala. Nīn tintī' tzē nacāmāmakxtekē ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Lā' Jesús cāhuanipā: ―Nīn tintī' māquilhtī huan pūmaksko para nahui'lī ixtampīn huan chā'xta. Lā' nīn hui'līcan ixtampīn huan tama'. Namā'ca'can tālhmā'n para que a'ntīn tatanūmā'na natalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pues ixlīhuāk a'ntū iccāmāsu'ni'yāni' mē'cstuca'n, ā'calīstān maclacasqui'n nacāmāsu'ni'yā'tit ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Chuntza' xa'nca cakaxpa'ttit porque a'ntī xa'nca kalhlaka'ī' ixtachihuīn Dios, ū'tza' más namāchekxī; lā' a'ntīn tū' xa'nca kalhlaka'ī' ixtachihuīn Dios, xla' namāpātza'nkānīcan a'ntū puhuan que māchekxīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tuncan tamilh ixtzī't lā' ixtā'timīn a'nlhā ixuī' Jesús lā' tūlalh talaktapajtzūlh como līlhūhua' tachi'xcuhuī't ixa'nan. ");
INSERT INTO tooNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Lā' huanica Jesús: ―Tayāna' kēpun mintzī't lā' mintā'timīn. Tatā'chihuīna'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Lā' xla' cāhuanilh: ―A'ntī kaxmata ixtachihuīn Dios lā' a'kahuāna'ni', ū'tza' quintzī't lā' quintā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Milh lakatin chi'chini' a'xni'ca' Jesús tā'tojōlh nac lakatin barco con ī'sca'txtunu'nī'n. Lā' cāhuanilh: ―Cāhuī'tit tintacut xcān. Lā' ta'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Lā' līhuan ixtatacutmā'na, lhtatalh Jesús. Lā' palaj tzuculh lakatin palha' ū'ni' lā' ixlītatzumamā'tza' de xcān huan barco hasta que ixtā'cnūmā'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Lā' tuncan ta'a'lh tamālakahuānī Jesús lā' tahuanilh: ―¡Mākalhtō'kē'ni'! ¡Jicsua'mā'nauj! Lā' tuncan Jesús tā'kaquī'lh lā' lacaquilhnīlh huan ū'ni' lā' huan xasipej xcān, lā' taca'cslalh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Lā' tuncan cāhuanilh huan ī'sca'txtunu'nī'n: ―¿Chī la'tit? ¿Chu tū' kalhlaka'ī'yā'tit? Lā' xlaca'n tajicua'lh lā' talē'cnīlh lā' talākalhasqui'nīlh: ―¿Tichū huā'mā' chi'xcu'? ¿Chichū tzē cālīmāpa'ksī huan ū'ni' lā' huan xcān lā' nata'a'kahuāna'ni'? ");
INSERT INTO tooNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A'calīstān tachā'lh huan nac ti'ya't a'nlhā huanican Gadara. U'tza' tintacut huan xcān lā' na ixlacapūn Galilea. ");
INSERT INTO tooNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","A'xni'ca' Jesús tacutli de huan barco, kalhatin chi'xcu' xala' a'ntza' laktapajtzūlh. Lej makān xla' ixka'lhī huan tlajana'. Tū' maktin lhakā'lh ixlu'xu' lā' tū' tahui'lalh nac chic. Mejor tahui'lalh nac cā'lhu'cu'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lā' a'xni'ca' huan chi'xcu' laktzī'lh Jesús, tatzokostani'lh na ixlacapūn lā' ta'salh lā' hualh: ―¿A'chī' ta'na' hui'x a'nlhā icuī'? Hui'x Jesús i'xO'kxa' Dios lej ka'tla'. ¿Chu quit mimaca'tzi? Icsqui'ni'yāni' caquimakxtekti. ");
INSERT INTO tooNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Chuntza' huanilh como Jesús ixmāpa'ksīmā' huan tlajana' que nataxtu de xla'. Maklhūhua' huan tlajana' chi'palh. Lā' ixlīmacachī'can cadenas lā' nā ixlītantūchī'can cadenas lā' xla' ixcālacpu'lha. Lā' huan tlajana' makatzā'lalh nac cā'lhpi'mpi'li' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús kalhasqui'nīlh: ―¿Chichū hua'ni'ca'na'? Lā' xla' kalhtīlh: ―Quihuanican Legión. Chuntza' huanilh como Legión huanicu'tun lhūhua', lā' lhūhua' tlajana'nī'n ixtatanūni'nī't. ");
INSERT INTO tooNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Lā' huā'mā'na tlajana'nī'n tasqui'ni'lh Jesús que tū' cacāmacā'lh nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lā' como lhūhua' pa'xni' ixtahuā'yamā'na na ixlacapān kēstīn, huan tlajana'nī'n tasqui'nli que cacāmakxtekca natatanū na ixchakānca'n huan pa'xnī'n. Lā' Jesús cāmakxtekli. ");
INSERT INTO tooNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lā' tuncan huan tlajana'nī'n tataxtukō'lh de huan chi'xcu' lā' tatanūlh ixchakānca'n huan pa'xnī'n. Lā' xlaca'n tatu'jnulh nac cā'pūtatonkopūn lā' tatonkopūlh lā' tatojōcha' nac xcān lā' tajicsua'kō'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lā' a'xni'ca' huan maktaka'lhna'nī'n pa'xni' talaktzī'lh a'ntū ixpātle'kenī't, tajicua'lh lā' tatu'jnulh lā' tamāca'tzīnīni'lh nac cā'lacchicni' lā' pajtzu huā'mā' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Lā' huan tachi'xcuhuī't tataxtulh de huan cā'lacchicni' para natalaktzī'n a'ntū ixpātle'kenī't. Lā' a'xni'ca' tachā'lh a'nlhā ixuī' Jesús, talaktzī'lh huan chixcu' a'ntī ixka'lhī huan tlajana'nī'n. Ixcāmāxtuni'nī'ttza' huan tlajana'nī'n lā' huan chi'xcu' ī'lhakā'nanī'ttza' lā' tzē'k tō'lalh pajtzu ixtojon Jesús. Lā' xlaca'n tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Lā' a'ntī ixtalaktzī'nī't tahuanilh a'nchī ixlītzeyanī't huan chi'xcu' a'ntī ixka'lhī huan tlajana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Lā' chuntza' ixlīhuākca'n xalanī'n nac Gadara tatzuculh tasqui'ni' Jesús que nataxtu de a'ntza' como lej tajicua'lh. Lā' chuntza' Jesús tojōlh nac barco lā' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Lā' huan chi'xcu' a'ntī ixtzeyanī'ttza' squi'ni'lh Jesús que camakxtekli natā'a'n, pero Jesús māpa'ksīlh que catachokolh lā' huanilh: ");
INSERT INTO tooNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cataspi'tti na minchic. Lā' nacāhua'ni'kō'ya' huā'mā'na laka'tla'n catūhuā a'ntū Dios tlahuani'nī'ta'ni' lā' a'nchī pātle'keni'nī'ta'ni'. Huan chi'xcu' a'lh lā' tzuculh huan a'ntū ixtlahuani'nī't Jesús chuxalhā nac cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","A'xni'ca' Jesús taspi'tli para tintacut huan xcān, huan tachi'xcuhuī't talaktzī'lh con tapāxuhuān como ixlīhuākca'n ixtaka'lhīmā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tuncan milh kalhatin chi'xcu', ixtacuīni' Jairo a'ntī xapuxcu' ixlītokpānca'n israelitas. Xla' tatzokostani'lh Jesús. Lā' huanilh que ca'a'lh na ixchic ");
INSERT INTO tooNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porque xmān kalhatin ixtzu'ma'jāt ixka'lhī hua'chi de cāujtu' cā'ta lā' ixnīmā'. A'xni'ca' ixa'mā' Jesús na ixchic Jairo, līlhūhua' ixtastālani'mā'na hasta que ixtalāpi'ta'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Lā' na ixlaclhni'ca'n ixa'mā' kalhatin puscāt a'ntī ixī'tza'ca'n. Ixka'lhītza' lakacāujtu' cā'ta tūla ixcāsni' ixka'lhni'. Lā' ī'sputni'kō'nī'ttza' ixtumīn para nacāmāpala doctor pero nīn kalhatin mātzeyīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Xla' tapajtzūlh na ixkēn Jesús lā' xa'malh ixquilhtūn ixlu'xu'. Lā' chu tuncan huanmā' ka'tlā'tus cāsni'lh ixka'lhni'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Lā' Jesús kalhasqui'nīni'lh: ―¿Tichū quixa'manī't? Lā' como ixlīhuākca'n tahualh que nīn tintī', Pedro lā' ā'makapitzīn tahuanilh: ―Mākalhtō'kē'ni', de tantu līlhūhua' pi'ta'ca'na' lā' tampi'ta'ca'na' chu xalhā, lā' hui'x kalhasqui'nīni'na': “¿Tichū quixa'malh?” ");
INSERT INTO tooNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús cāhuanilh: ―Catīhuā quixa'manī't como icu'cxca'tzī iclīmātzeyīni'nī't quilīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","A'xni'ca' huan puscāt ca'tzīlh que Jesús cuenta tlahualh que xa'maca, ī'xpipitēlha lakmilh lā' tatzokostalh na ixtojon Jesús. Huanilh na ixlacapūn ixlīhuākca'n tachi'xcuhuī't a'nchī līxa'malh Jesús lā' chuntza' chu tuncan ixtzeyanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tuncan Jesús huanilh: ―Quintzu'ma'jāt, tzeyanī'ta' hui'x como kalhlaka'ī'nī'ta'. Capit con tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ixchihuīna'mā'cus Jesús a'xni'ca' chilh kalhatin xala' ixchic Jairo huan xapuxcu' ixlītokpānca'n israelitas. Lā' huanica Jairo: ―Mintzu'ma'jāt nīlhtza'. Tū'tza' camāmakchu'yi' huan Mākalhtō'kē'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A'xni'ca' Jesús kaxmatli huā'mā', huanilh: ―Tū' caji'cua'. Mintzu'ma'jāt natzeyan xmān cakalhlaka'i'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","A'xni'ca' chā'lh huan nac chic, nīn tintī' makxtekli natā'tanū, xmān Pedro lā' Jacobo lā' Juan lā' ixtāta' lā' ixtzī't huan tzu'ma'jāt. ");
INSERT INTO tooNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ixlīhuākca'n ixtacalhuamā'na lā' ixtata'samā'na por ixpālacata huan tzu'ma'jāt. Lā' Jesús cāhuanilh: ―Tū' cacalhua'ntit. Tū' nīnī't huan tzu'ma'jāt, xmān lhtatamā'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Lā' xlaca'n talīlītzī'nli como ixtaca'tzī que ixnīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Lā' tuncan Jesús macachi'palh huan tzu'ma'jāt lā' palha' huanilh: ―Tzu'ma'jāt, icuaniyāni' catā'kaqui'. ");
INSERT INTO tooNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lā' taspi'tli ixlīca'tzīn lā' chu tuncan tā'kaquī'lh. Lā' Jesús māpa'ksīni'lh que camāhuī'ca. ");
INSERT INTO tooNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lā' ixtāta' lā' ixtzī't lej talē'cnīlh lā' Jesús cāmāpa'ksīlh que nīn tintī' ixtahuanilh a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús cātā'takēxtimīlh huan kalhacāujtu' ī'sca'txtunu'nī'n lā' cāmaxquī'lh līmāpa'ksīn para natamāxtu huan tlajana'nī'n. Nā cāmaxquī'lh līmāpa'ksīn para natamātzeyī huan ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cāmacā'lh para natahuan a'nchī māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Lā' cāhuanilh: ―Tū' tilīpinā'tit nīn tuntū' para mintejca'n, nīn mimpāla'cca'n nīn tumīn nīn mimpūtumīnca'n nīn pāntzi. Lā' tū' catilīpintit kalhtu' mincamisaca'n, xmān kalhtunu'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chu calhāhuāya chic a'nlhā nachipinā'tit a'ntza' natachokoyā'tit hasta a'xni'ca' nataxtuyā'tit de huanmā' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Lā' a'nlhā tū' cātamānūyāni' na ixchicca'n, cataxtutit de huanmā' cā'lacchicni'. Lā' a'xni'ca' nataxtuyā'tit, catincxtit mintojonca'n para nayuja huan pokxni' ixlakxtampūn mintojonca'n. Chuntza' nalīmāsu'yu'yā'tit que xlaca'n natalē'n cuenta como tū' takaxmatcu'tulh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tuncan tataxtulh huan sca'txtunu'nī'n lā' ta'a'lh lakachu nac cā'lacchicni'. Tatā'chihuīna'lh lā' tahuanilh a'nchī nacālīmāpūtaxtūcan lā' tamātzeyīlh ī'tza'ca'nī'n chu calhāhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lā' huan gobernador Herodes māca'tzīnīca ixlīhuāk a'ntū Jesús ixtlahuamā'. Lā' tū' ixca'tzī a'nchī puhuan como ā'makapitzīn ixtalāhuanimā'na que Juan huan Mā'kpaxīni' ixlakahuanchokonī't de ixlaclhni'ca'n nīnī'n lā ixtahuan que chō'la ū'tza' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lā' ā'makapitzīn ixtalāhuanimā'nampā que Jesús ū'tza' Elías a'ntī tasu'yulh. Lā' ā'makapitzīn huampala ixtalāhuanimā'na que kalhatin a'cta'sana' xala' makān lakahuanchokolh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lā' Herodes hualh: ―Māni' quit icmā'a'cchu'cunīni'lh Juan. ¿Tichū huā'mā' a'ntī ixpālacata ickaxmata lhūhua' catūhuā? Lā' Herodes ixlaktzī'ncu'tun Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","A'xni'ca' tataspi'tli huan apóstoles, tahuanilh Jesús a'ntū tatlahuanī't. Lā' tuncan Jesús cālē'lh ixa'cstuca'n lā' tatā'a'lh nac lakatin lugar pajtzu huan cā'lacchicni' a'nlhā huanican Betsaida. ");
INSERT INTO tooNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Lā' a'xni'ca' huan tachi'xcuhuī't taca'tzīlh, tastālani'lh. Lā' Jesús cāhuanilh que catatahui'lh lā' tzuculh cālītā'chihuīna'n ixpālacata huan ixlīmāpa'ksīn Dios. Lā' cāmātzeyīlh ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lā' a'xni'ca' ixkōtanūmā'tza', talaktapajtzūlh Jesús huan kalhacāujtu' sca'txtunu'nī'n lā' tahuanilh: ―Cacāmacapi huan tachi'xcuhuī't para nata'a'n natajaxa lā' nataputza ixlīhua'tca'n nac huan cā'lacchicni' a'ntū pajatzu como huā'tzā' a'nlhā hui'lāna'uj tuntū' a'nan. ");
INSERT INTO tooNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Lā' Jesús cāhuanilh: ―Hui'xina'n cacāmāhuī'tit. Lā' xlaca'n takalhtīlh: ―Xmān icka'lhīyāuj macquitzis pāntzi lā' tantu' squī'ti' palh tū' na'ica'nāuj na'ictamāhuayāuj chauj para ixlīhuakca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ixa'nan hua'chi lakaquitzis mil chi'xcuhuī'n. Lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Catatahui'lalh lītu'pu'xamacāujna'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Lā' chuntza' tatlahualh lā' tatahui'lakō'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tuncan Jesús cātayalh huan makquitzis pāntzi lā' huan tantu' squī'ti'. Talacayāhualh nac a'kapūn lā' maxquī'lh pāxcatca'tzī Dios lā' cāmālacpitzini'lh lā' cāmaxquī'lh huan ī'sca'txtunu'nī'n para que natamālacpitzini' na ixlaclhni'ca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ixlīhuākca'n tahuā'yalh lā' taka'sli. Lā' a'xni'ca' tahuā'yankō'lh, tasacli lhūhua' xalacpītzin. Lā' tatzumalh pācāujtu' chā'xta de huan a'ntū a'katāxtūlh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Milh lakatin chi'chini' a'xni'ca' ixa'cstu ixorarlīmā' Jesús. Lā' ī'sca'txtunu'nī'n pajtzu tatahui'lalh. Lā' Jesús cākalhasqui'nīlh: ―Lā' huan tachi'xcuhuī't, ¿chichū tahuan quimpālacata? ");
INSERT INTO tooNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Takalhtīlh: ―Makapitzīn tahuan palh hui'x Juan huan Mā'kpaxīni'. Lā' ā'makapitzīn tahuan palh hui'x Elías. Lā' ā'makapitzīn huampala tahuan que hui'x kalhatin a'cta'sana' xala' makān a'ntī lakahuanchokonī't. ");
INSERT INTO tooNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Lā' tuncan cākalhasqui'nīlh: ―Lā' hui'xina'n ¿chichū huanā'tit que quit? Lā' Pedro kalhtīlh: ―Hui'x Cristo a'ntī Dios macamilh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lā' Jesús lej cāmāpa'ksīlh que tū' catitahuanilh nīn tintī' palh ū'tza' huan Cristo. ");
INSERT INTO tooNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Lā' cāhuanilh: ―Quit huan Chi'xcu' xala' Tālhmā'n lā' tasqui'nī lej naquimāpātīnīcan. Lā' nā tasqui'nī que naquintalakmaka'n huan xanapuxcu'nu' israelitas lā' huan xanapuxcu'nu' curasna' lā' huan mākalhtō'kē'ni'nī'n huan ley. Lā' naquimaknīcan lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko. ");
INSERT INTO tooNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A'calīstān cāhuanilh ixlīhuākca'n: ―Palh catīhuā tapa'ksīcu'tun con quit, tūlatza' pāstaca xmān a'nchī xla' lacasqui'n. Calīhui'līlh natlahua quintapuhuān lakalīyān a'yuj capātīni'lh hua'chi quit na'icpātīni'n lā' caquistālani'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huan a'ntīn tapūtaxtucu'tun de huan a'ntū natapātīni'n por quimpālacata, tū' catitaka'lhīlh ixquilhtamacujca'n para pō'ktu. Lā' huan a'ntī natapātīni'n a'yuj natanī por quimpālacata, xlaca'n nataka'lhī ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Lā' palh kalhatin chi'xcu' ixtlajalh ixlīhuāk xala' huā'mā' quilhtamacuj, nīn tuntū' ixtapalh huā'mā' palh tū' ka'lhī ixquilhtamacuj para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Palh catīhuā līmāxana'n quimpālacata lā' ixpālacata quintachihuīn, ū'tza' na'iclīmāxana'n a'xni'ca' na'icmin hua'chi Rey lā' na'icka'lhī ixlīmāpa'ksīn quinTāta' Dios lā' naquintatā'min huan ángeles a'ntī lej tzey. Lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Iccāhuaniyāni' a'ntū stu'ncua'. A'nan makapitzīn a'ntīn tahui'lāna' huā'tzā' chuhua'j lā' xlaca'n tū' catitanīlh a'xni'ca' tūna'j natalaktzī'n ixlīmāpa'ksīn Dios lā' a'nchī namāpa'ksīni'nkō' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hua'chi ixlīlakatzeyan chi'chini' Jesús tō'ca'lh nac lakatin kēstīn para natlahua oración. Tatā'a'lh Pedro lā' Jacobo lā' Juan. ");
INSERT INTO tooNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lā' līhuan Jesús ixtlahuamā' oración, xla' taxtāpalīlh lā' xtunc ixtasu'yu ixlacan. Lā' lej smu'yonko' lalh ixlu'xu' hasta xkakalh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Lā' tuncan tatasu'yulh kalhatu' chi'xcuhuī'n lā' ixtatā'chihuīna'mā'na Jesús. Xlaca'n Moisés lā' Elías a'ntī makāntza' ixtanīnī't ");
INSERT INTO tooNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","lā' cālītamacxti'li'lh xkakana'. Lā' ixtatā'chihuīna'mā'na a'nchī Jesús napātīni'n lā' nanī nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro lā' a'ntī cātā'a'lh a'yuj lej ixtalhtatacu'tun pero lakahuan ixtahui'lāna' lā' talaktzī'lh a'nchī xkakalh Jesús lā' huan kalhatu' chi'xcuhuī'n a'ntī ixtatā'yāna'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","A'xni'ca' huā'mā'na chi'xcuhuī'n ixtamakxtekmā'na Jesús, Pedro huanilh: ―Mākalhtō'kē'ni', ¡xalītzey hui'lāna'uj ā'tzā! Na'ictlahuayāuj lakatu'tun mū'xta'ka'; lakatin mila', ā'lakatin ixla' Moisés lā' ā'lakatin ixla' Elías. Chuntza' hualh Pedro como tū' ixca'tzī a'ntū ixuan. ");
INSERT INTO tooNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Līhuan ixchihuīna'mā', milh lakatin poklhnu' lā' cālīmacxti'li'ca. Tajicua'lh a'xni'ca' ta'u'cxca'tzīlh na ixchakān poklhnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Lā' tuncan takaxmatli lakatin tachihuīn nac huan poklhnu' lā' hualh: ―U'tza' huā'mā' qui'O'kxa' lā' lej icpāxquī'. Cakaxpa'ttit a'ntū huan. ");
INSERT INTO tooNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","A'xni'ca' huankō'lh huan tachihuīn, talaktzī'lh que ixa'cstu ixuī' Jesús. Ca'cs tatāyalh lā' tū' tahualh nīn tuntū' a'ntū ixtalaktzī'nī't. ");
INSERT INTO tooNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ixlīlakalī huampala, a'xni'ca' tataxtucha' de huan kēstīn, līlhūhua' tachi'xcuhuī't tapāxtokli Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Lā' tuncan kalhatin chi'xcu' na ixlaclhni'ca'n lej palha' huanilh: ―Mākalhtō'kē'ni', icsqui'ni'yāni' lakatin talakalhu'mān. Capit laktzī'na' qui'o'kxa' porque xmān ixa'cstu icka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Lā' lakatin tlajana' chi'pa lā' makata'sa lā' palha' xpipi lā' kalhpupu. Lā' makaxtacnānī lā' lej jicslīhua' nataxtuni'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Iccāhuanilhtza' misca'txtunu'nī'n que ixtamāxtuni'lh huan tlajana' pero tūlalh tamāxtuni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús kalhtīlh: ―¡Hui'xina'n tachi'xcuhuī't a'ntīn tū' xa'nca pāstacna'nā'tit lā' tū' kalhlaka'ī'yā'tit! ¿Hasta lhānīn na'iccātā'latahui'layāni' hui'xina'n para que namāchekxī'yā'tit? Lā' ¿hasta lhānīn na'iccātāyani'yāni' hui'xina'n a'nchī huanī'ta'ntit? Calī'ta' huā'tzā' minka'hua'chu. ");
INSERT INTO tooNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Lā' a'xni'ca' huan ka'hua'chu ixlaktapajtzūmā' Jesús, huan tlajana' māyujūlh nac ti'ya't lā' makaxtacnānīpā. Lā' Jesús lacaquilhnīlh huan tlajana'. Lā' mātzeyīlh huan ka'hua'chu lā' maxquī'pā ixtāta'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Lā' ixlīhuākca'n talē'cnīlh ixlīka'tla' Dios. Līhuan ixlīhuākca'n talē'cnīlh ixpālacata a'ntū Jesús tlahualh, xla' cāhuanilh ī'sca'txtunu'nī'n: ");
INSERT INTO tooNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Xa'nca cakaxpa'ttit lā' tū' tipātza'nkāyā'tit; quit huan Chi'xcu' xala' Tālhmā'n lā' naquimacamāstā'can na ixmacanca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Lā' huan sca'txtunu'nī'n tū' tamāchekxīlh a'ntū cāhuanilh como xtunc ixtapāstacmā'na. Lā' tū' ixtakalhasqui'nīcu'tun a'ntū ixuanicu'tun como ixtajicua'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Lā' tuncan huan sca'txtunu'nī'n tatzuculh talacchihuīna'n ixpālacata tichū de xlaca'n más tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Lā' Jesús cuenta tlahualh a'nchī ixtapāstacna'mā'na. Lā' tuncan macachi'palh kalhatin ka'hua'chu lā' yāhualh na ixpāxtun ");
INSERT INTO tooNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","lā' cāhuanilh: ―Chuxatī a'ntīn tatapa'ksī con quit lā' ū'tza' natalīpāxquī' kalhatin ti'na'j ka'hua'chu hua'chi huā'mā' ka'hua'chu, ū'tza' chu a'cxtim hua'chilh quintapāxquī'. Lā' chuxatī a'ntī quintapāxquī', nā tapāxquī' huan a'ntī quimacamilh lā' tū' xmān quit. Lā' a'ntīn tū' ka'tla'jca'tzī na milaclhni'ca'n, ū'tza' a'ntī tasqui'nī na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tuncan Juan huanilh: ―Mākalhtō'kē'ni', iclaktzī'nī'tauj kalhatin a'ntī ixcāmāxtumā' huan tlajana'nī'n con milīmāpa'ksīn. Lā' icuaninī'tauj que tū'tza' catlahualh chuntza' como tū' quincātā'latlā'huanāni' quina'n. ");
INSERT INTO tooNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Lā' Jesús cāhuanilh: ―Tū' tihua'nā'tit chuntza' porque a'ntīn tū' quintā'ca'tzaca'n, xla' quincāmaktāyayāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A'xni'ca' ixmimā' huan chi'chini' a'xni'ca' Jesús ixa'lh nac a'kapūn, līhui'līlh na'a'n nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Cāmāpū'līlh ā'makapitzīn ī'sca'txtunu'nī'n lā' ta'a'lh nac lakatin ti'na'j cā'lacchicni' para nataputza a'nlhā natalhtata. Huan cā'lacchicni' xala' nac Samaria, ");
INSERT INTO tooNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","lā' huan xalanī'n a'ntza' tū' tamānūcu'tulh na ixchicca'n como ixtasu'yu ixa'mā' nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lā' a'xni'ca' huan sca'txtunu'nī'n Jacobo lā' Juan talaktzī'lh huā'mā', tahuanilh: ―Māpa'ksīni', ¿chā lacasqui'na' na'icmāyujūyāuj macscut de nac a'kapūn para que natasputkō' xlaca'n hua'chi tlahua'lh huan a'cta'sana' Elías? ");
INSERT INTO tooNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Lā' tuncan Jesús cālaktalakspi'tli lā' cālacaquilhnīlh. Hualh: ―Hui'xina'n tū' ca'tzī'yā'tit que tū' tzey a'nchī pāstacna'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Quit huan Chi'xcu' xala' Tālhmā'n lā' quit tū' ictimilh para na'iccāmāsputūkō' ixquilhtamacujca'n tachi'xcuhuī't. Icmilh para na'iccāmāputaxtū. Lā' tuncan ta'a'lh nac ā'lacatin cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","A'xni'ca' ixta'a'mā'na nac tej, kalhatin chi'xcu' huanilh Jesús: ―Quit na'icstālani'yāni' chu xalhā napina'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Lā' Jesús kalhtīlh: ―Huan tanqui'hui' taka'lhī ixlhu'cu'ca'n lā' huan spūnnu' taka'lhī ixmāsekca'n. Lā' quit huan Chi'xcu' xala' Tālhmā'n lā' quit tū' icka'lhī a'nlhā na'iclhtata. ");
INSERT INTO tooNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Lā' Jesús huanilh ā'kalhatin: ―Caquistālani'. Lā' xla' kalhtīlh: ―Māpa'ksīni', caquimakxtekti na'ictahui'la na quinchic hasta que nanī quintāta'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Lā' Jesús kalhtīlh: ―Xlaca'n a'ntīn tū' takalhlaka'ī' tzē natamā'cnū mintāta'. Hui'x capit lā' cacāmāsu'ni' huan tachi'xcuhuīt a'nchī nātalīpūtaxtu. ");
INSERT INTO tooNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Lā' tuncan huanilh ā'kalhatin: ―Māpa'ksīni', icstālani'cu'tunāni', pero pū'la ica'ncu'tun na quinchic para na'icuan ica'nā ā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Lā' Jesús huanilh: ―A'ntī natzucu laklhkāna'n lā' tuncan natalakspi'ta ixkēn, tūla xa'nca laklhkāna'n. Nā chuntza' tū' minī'ni' palh hui'x natā'scuja Dios como taspi'tcu'tuna' na minchic. ");
INSERT INTO tooNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A'calīstān huan Māpa'ksīni' cālacsacli tu'tumpu'xamacāuj chi'xcuhuī'n xtunc huampala lā' cāmacā'lh kalhatu'yūn. Ixtapū'lani' nac cā'lacchicni' lā' chuxalhā ixa'mā'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Lā' Jesús cāhuanilh: ―Lej stu'ncua' a'ntū iccāhuaniyani'. Lhūhua' a'nan a'ntīn tūna'j takalhlaka'ī' pero tū' a'nan lhūhua' a'ntī natamāsu'ni' xlaca'n. U'tza' hua'chi a'xni'ca' lej la cuxi' lā' tintī' tasācua'. Lā' Dios hua'chi ixtēcu' huan cuxi'. U'tza' nalīkalhasqui'nīyā'tit Dios que cacāmacamilh chi'xcuhuī'n para natamāsu'ni' a'ntīn tūna'j takalhlaka'ī. ");
INSERT INTO tooNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Capitit. Cuenta catlahua'tit. Iccāmacā'nāni' hua'chi xalakska'tā'n borregos na ixlaclhpu'nanca'n misinī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tū' tilīpinā'tit nīn morral, nīn pūtumīn, nīn huarache. Lā' tū' titakoxīyā'tit nac tej a'xni'ca' natā'chihuīna'nā'tit a'ntī pātle'kemā'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","’Lā' a'xni'ca' natanūyā'tit nac lakatin chic a'nlhā natachokoyā'tit, pū'la nacāhuaniyā'tit: “Dios cacāsicua'lanālīni' a'ntī hui'lā'na'ntit nac huā'mā' chic”. ");
INSERT INTO tooNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Lā' palh a'nan a'ntīn takalhlaka'ī', Dios nasicua'lanālī; lā' palh tintī' a'ntīn takalhlaka'ī', Dios tū' caticāsicua'lanālīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Natachokoyā'tit nac lakatin chic lā' chu a'ntū nacātalakahui'līyāni', nahua'yā'tit lā' nako'tnu'nā'tit como a'ntī scuja ka'lhī nahuā'yan. Tū' tilactā'kchokoyā'tit pūtunu' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’A'xni'ca' nachipinā'tit nac lakatin cā'lacchicni' a'nlhā nacātamānūyāni' nac chic, chu a'ntū nacātalakahui'līni'yāni nahua'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nacāmātzeyīyā'tit a'ntī ta'ī'tza'ca'n a'ntza' lā' nacāhuani'yā'tit tachi'xcuhuī't: “Laktzī'mpā'na'ntit ixlīmāpa'ksīn Dios”. ");
INSERT INTO tooNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Lā' palh nachipinā'tit nac lakatin cā'lacchicni' lā' tū' lacasqui'ncan natachokoyā'tit, napimpalayā'tit nac tej lā' nacāhuani'yā'tit: ");
INSERT INTO tooNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Lā' huan pokxni' xala' ā'tzā' a'ntū quincātantūpasanī'ta'ni' na'ictincxyujuyāuj lā' ū'tza' huanicu'tun que hui'xina'n laclīpinā'tit. Lā' caca'tzī'tit huā'mā', que hui'xina'n laktzī'nī'ta'ntittza' a'nchī Dios māpa'ksīni'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Iccāhuaniyāni' que a'xni'ca' Dios nalaccāxtlahuakō', más nacāmāpātīnī xalanī'n huanmā' cā'lacchicni' que xalanī'n nac Sodoma. ");
INSERT INTO tooNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Lā' Jesús cāhuanipā: ―¡Xāntila'yā'tit hui'xina'n xalanī'n nac Corazín! Lā' ¡xāntila'yā'tit xalanī'n nac Betsaida! Nalakaputza'yā'tit porque tū' kalhlaka'ī'tit. Lej tlahuacanī't lē'cnīn na milaclhpu'nanca'n. Lā' palh ixcātlahuacancha' cahuā huā' tamā'na lē'cnīn nac huan cā'lacchicni' Tiro lā' nac Sidón, makāntza' ixtaxtāpalīlh ixtapāstacna'ca'n. Lā' xlaca'n ixtalhakā'lh tzi'tze'ke ixlu'xu'ca'n lā' ixcā'a'cpūmacaca lhca'ca'n lā' chuntza' ixtatasu'yulh que lej ixtalakaputza ixpālacata ixtalaclē'i'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","’A'xni'ca' Dios nalaccāxtlahuakō', hui'xina'n ā'chulā' nacātamāpātīnīyāni' que xalanī'n nac Tiro lā' nac Sidón. ");
INSERT INTO tooNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Lā' hui'xina'n xalanī'n nac Capernaum, ¿chā puhua'nā'tit palh napinā'tit nac a'kapūn como lej tzey hui'xina'n? Napinā'tit hasta nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ―A'ntī cākaxmatni'yāni' hui'xina'n, xla' naquinkaxmata. Lā' a'ntī nacālakmaka'nāni' hui'xina'n, chuntza' naquilakmaka'n nā quit. Lā' a'ntī naquilakmaka'n quit chuntza' nalakmaka'n Dios como ū'tza' a'ntī quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Huan tu'tumpu'xamacāuj tataspi'tli con tapāxuhuān. Lā' tahuanilh: ―Māpa'ksīni', hasta huan tlajana'nī'n quincāta'a'cnīni'ni'n ixpālacata milīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Lā' Jesús cāhuanilh: ―U'huē. Quit iclaktzī'lh a'xni'ca' tlajaca Satanás. Tasu'yulh hua'chi lakatin makli'pni'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Iccāmaktaka'lhāni' para que mintā'ca'tzaca'n tūlalh caticātlajani'. Lā' iccāmaxquī'nī'ta'ni'tza' līmāpa'ksīn para que natlajakō'yā'tit ixlīmāpa'ksīn Satanás. ");
INSERT INTO tooNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tū' calīpāxuhua'tit xmān porque huan tlajana'nī'n ta'a'cnīni'ni'yāni'. Calīpāxuhua'tit como hui'xina'n kalhlaka'ī'tit lā' Dios cālakapasāni' hua'chi ixcamana'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lā' tuncan Jesús ka'lhīlh tapāxuhuān por huan Espíritu Santo lā' Jesús kalhtō'ka'lh: ―Quintāta', hui'x māpa'ksīni'na' nac a'kapūn lā' nac ti'ya't. Icmaxquī'yāni' pāxcatca'tzī como cāmāsu'ni'nī'ta' huan a'ntīn tasca'tcu'tun ū'tza' a'ntū ixcāmātzē'kni'nī'ta' huan a'ntī lej lakskalalhna'. U'tza' tla'hua' chu a'nchī mintapuhuān. ");
INSERT INTO tooNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Lā' nā Jesús hualh: ―Quintāta' quimacamaxquī'kō'lh ixlīhuāk a'ntū a'nan. Tintī' ca'tzī a'nchī huanī't ixO'kxa' Dios, xmān Dios xaTāta'. Lā' tintī' ca'tzī a'nchī huanī't quinTāta' Dios, xmān quit a'ntī ixO'kxa'. Nā nataca'tzī xlaca'n a'ntī na'iccāmālacsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lā' tuncan talakspi'tli lā' cāhuanilh ī'sca'txtunu'nī'n xmān xlaca'n: ―Līpāxūj huan a'ntīn talaktzī'n a'ntū hui'xina'n laktzī'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Iccāhuaniyāni' que lhūhua' a'cta'sana'nī'n lā' reyes ixtalaktzī'ncu'tun huā'mā' a'ntū hui'xina'n laktzī'nā'tit, lā' tū' talaktzī'lh. Lā' ixtakaxmatcu'tun a'ntū kaxpatā'tit, lā' tū' takaxmatli. ");
INSERT INTO tooNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Lā' tuncan kalhatin xamākalhtō'kē'ni' ley tāyalh lā' tā'chihuīna'lh Jesús para nalīlaktzī'n. Lā' kalhasqui'nīlh: ―Mākalhtō'kē'ni', ¿tuchū na'ictlahua para que na'icka'lhī quinquilhtamacuj para pō'ktu? ");
INSERT INTO tooNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Lā' Jesús kalhtīlh: ―¿Tuchū tatzo'kni' na ixley Moisés? ¿Chichū lakapūtle'ke'ya'? ");
INSERT INTO tooNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Huan xamākalhtō'kē'ni' ley kalhtīni'lh: ―“Capāxqui' huan Māpa'ksīni' a'ntī minDios con ixlīhuāk mi'a'clhcunuc lā' con ixlīhuāk milīca'tzīn lā' con ixlīhuāk mifuerza lā' con ixlīhuāk mintapāstacna'. Lā' cacāpāxqui' ā'makapitzīn hua'chi pāxquī'ca'na' mē'cstu”. ");
INSERT INTO tooNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Lā' tuncan Jesús huanilh: ―Xa'nca kalhtīni'nī'ta'. Palh chuntza' natlahua'ya', naka'lhīya' minquilhtamacuj para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Lā' huan xamākalhtō'kē'ni' ley māpūtaxtūcu'tulh ixlīkalhasqui'nīn lā' huanilh Jesús: ―¿Tichū ā'makapitzīn a'ntī xa'iccāpāxquī'lh? ");
INSERT INTO tooNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Lā' tuncan Jesús kalhtīlh: ―Ixuī' kalhatin chi'xcu'; ixtaxtunī't de nac Jerusalén lā' ixa'mā' nac Jericó. Lā' huan ka'lhāna'nī'n tachi'palh lā' tamakka'lhankō'lh hasta ixlu'xu' a'ntū ixlhakā'nī't. Tatucsli lā' ta'a'lh. Tamakxtekli xa'a'ctzincsni'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chuntza' pātle'kelh que ixa'mā' nac huā'mā' tej kalhatin sacerdote. Lā' a'xni'ca' laktzī'lh huan chi'xcu', xmān xti'li'maka'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nā tētaxtulh kalhatin ixmaktaka'lhna' xaka'tla' lītokpān. Lā' a'xni'ca' laktzī'lh huan chi'xcu', nā xti'li'maka'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Lā' a'xni'ca' milh kalhatin xala' nac Samaria, xla' laktzī'lh lā' lakalhu'malh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lā' tuncan tapajtzūlh huan chi'xcu' lā' līcu'chū'lh aceite lā' līcu'chu'ni' a'nlhā ixmātakāhuī'canī't. Lā' hui'līni'lh vendaje. Lā' tuncan kēhui'līlh ixburro lā' pūlē'lh nac mesón lā' a'ntza' maktaka'lhli. ");
INSERT INTO tooNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Lā' ixlīlakalī tuncuīlh a'xni'ca' huan samaritano ixa'mā'tza', maxquī'lh tumīn huan ixtēcu' mesón lā' huanilh: “Camaktaka'lhti huā' ī'tza'ca'. Lā' palh tū' a'cchā'n huā' tumīn, na'icmaxquī'yāni' ixlaktapalh a'xni'ca' na'icchimpala”. ");
INSERT INTO tooNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Lā' Jesús huanilh huan xamākalhtō'kēni' ley: ―Chuhua'j caquihua'ni', ¿tichū de huā' tamā'na kalhatu'tun puhua'na' māsu'yulh a'nchī pāxquī'lh huan takāhuī'n? ");
INSERT INTO tooNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lā' huan xamākalhtō'kē'ni' ley hualh: ―A'ntī lakalhu'malh. Lā' Jesús huanilh: ―Capit lā' catlahua' chu a'cxtim. ");
INSERT INTO tooNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús tēlh ixtej lā' chā'lh nac lakatin cā'lacchicni'. Lā' a'ntza' kalhatin puscāt, a'ntī ixuanican Marta, mānūlh na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ixka'lhī ixtā'tin a'ntī ixuanican María. Lā' xla' tahui'lh na ixtojon Jesús para nakaxmatni' a'ntū xla' ixmāsu'yumā'. ");
INSERT INTO tooNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Lā' Marta tamakchuyīlh como lej ixka'lhī ixlītlōt lā' laktapajtzūlh Jesús lā' huanilh: ―Māpa'ksīni', ¿tū' lītamakchu'yi' nīn tuntū' que quintā'tin quimāchokoni'kō' lītlōt? Cahua'ni' que caquimaktāyalh. ");
INSERT INTO tooNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Lā' Jesús kalhtīlh: ―Marta, hui'x māmakchuyīya' lā' lej lē'capina' milītlōt lā' ā'catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero a'nan a'ntū más tasqui'nī. María lacsacnī't a'ntū más tzey lā' tintī' catimaklhtīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Maktin huā Jesús ixkalhtō'ka'mā' nac lakatin lugar. Lā' a'xni'ca' kalhtō'ka'kō'lh, kalhatin ī'sca'txtunu' huanilh: ―Māpa'ksīni', caquilāmāsca'tīuj a'nchī kalhtō'ka'can hua'chi cāmāsca'tīlh ī'sca'txtunu'nī'n Juan huan Mā'kpaxīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Lā' Jesús cāhuanilh: ―A'xni'ca' kalhtō'ka'yā'tit, chuntza' nahua'nā'tit: QuinTāta'ca'n a'ntī hui'lachi nac a'kapūn, ca'a'cnīni'ni'ca'. Camilh a'xni'ca' natzucuya' nacāmāpa'ksī'kō'ya' huan tachi'xcuhuī't. Catlahuaca mintapuhuān huā'tzā' nac ti'ya't chu a'cxtim hua'chi nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Caquilāmaxquī'uj quilīhua'tca'n a'ntū na'icua'yāuj lakalīyān. ");
INSERT INTO tooNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lā' caquilāmāsputūnu'ni'uj quintalaclē'i'ca'n como nā quina'n iccāmāsputūnu'ni'yāuj a'ntī quincātalaclē'ni'yāni'. Tū' camakxtekti naquincāpātle'keni'yāni' a'ntū naquincāmātlahuīyāni' talaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nā Jesús cāhuanilh: ―Calīhui'līuj que kalhatin de hui'xina'n ka'lhīyā'tit kalhatin mi'amigoca'n. Lā' i'tāt tzī'sa napina' na ixchic lā' nahuani'ya': “Amigo, caquimāpāhua'xtuni' mactu'tun pāntzi ");
INSERT INTO tooNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porque chuna'j quilakchilh kalhatin qui'amigo na quinchic lā' tū' icka'lhī a'ntū na'icmāhuī'”. ");
INSERT INTO tooNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Lā' calīhui'līuj que xla' desde ixchakān chic nakalhtīyāni': “Tū' caquimāmakchuyi'. Lacchōyātza' huan mākalhcha lā' quilīhuākca'n iclhtatamā'naujtza'. Lā' tūla ictāquī' para na'icmaxquī'yāni' nīn tuntū'”, nahuaniyāni' mi'amigo. ");
INSERT INTO tooNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","’Iccāhuaniyāni' que a'yuj mi'amigo tū' catāquī'cu'tulh para namaxquī'yāni' catūhuā a'yuj lī'amigo hui'xina'n, pero natlahua para que tū' namājiclhuī'ya' ā'chulā' lā' namaxquī'yāni' ixlīhuāk a'ntū maclacasqui'na'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Chuntza' iccāhuaniyāni': Casqui'ni'tit Dios lā' xla' nacāmaxquī'yāni'. Lā' caputzatit a'ntū Dios cāmaxquī'cu'tunāni' lā' nakaksā'tit. Lā' calīmacasā'na'ntit huan mākalhcha lā' nacātamālaquī'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chuntza' a'ntī nasqui'n, xla' namaklhtīni'n; lā' a'ntī naputza, xla' nakaksa; lā' a'ntī nalīmacasā'nan huan mākalhcha, namālaquī'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Ixlīca'tzan kalhatin de hui'xina'n a'ntī xatāta', ¿chu namaxquī'ya' chihuix mincaman a'xni'ca' squi'ni'yāni' pāntzi? Lā' ¿chu namaxquī'ya' lakatin lūhua' palh squi'ni'yāni' squī'ti'? ");
INSERT INTO tooNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Lā' ¿chu namaxquī'ya' lakatin cūlūtl palh squi'ni'yāni' ka'lhuā't? ");
INSERT INTO tooNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hui'xina'n a'yuj tū' lacuan pero ca'tzīyā'tit que tzē namaxquī'yā'tit lē'ksajna' xatzey mincamana'ca'n. Lā' ā'chulā' minTāta'ca'n a'ntī hui'lacha' nac a'kapūn nacāmaxquī' Espíritu Santo a'ntī tasqui'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús ixmāxtuni'mā' de huan chi'xcu' huan tlajana'. U'tza' ixmakakō'ko'nī't. Lā' a'xni'ca' taxtulh huan tlajana', tzētza' ixchihuīna'n huan kō'ko'. Lā' huan tachi'xcuhuī't talē'cnīlh huā'mā' ");
INSERT INTO tooNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero makapitzīn tahualh: ―Huā'mā' chi'xcu' cālīmāxtu huan tlajana'nī'n ixlīmāpa'ksīn Beelzebú a'ntī xapuxcu' huan tlajana'ni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Lā' a'makapitzīn ixtalīlaktzī'ncu'tun Jesús lā' ixtasqui'ni' lakatin lē'cnīn xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Lā' xla' ixca'tzī a'ntū xlaca'n ixtapuhuan lā' cāhuanilh: ―Palh huan pūchihuīna'nī'n tatapitzi lā' talāsta'la, tūla tamāpa'ksīni'n makān. Natalāmāsputūkō'. Lā' palh tatapitzi lā' natalātucsa lītā'timīn nā natalāmāsputūkō'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chuntza' palh tatapitzi xlaca'n a'ntīn tatapa'ksī con Satanás lā' lītā'ca'tza tala, ¿chī nalīka'lhī ixlīmāpa'ksīn Satanás? Iccāhuaniyāni' huā'mā' como hui'xina'n quilāhuaniyāuj que quit iclīmāxtulh huan tlajana' por ixlīmāpa'ksīn Beelzebú. ");
INSERT INTO tooNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Palh quit iccālīmāxtu huan tlajana'nī'n ixlīmāpa'ksīn Beelzebú, ¿tichū ixlīmāpa'ksīn taka'lhī xlaca'n a'ntīn tatapa'ksī con hui'xina'n lā' talīmāxtu tlajana'? Chuntza' māni' xlaca'n talīmāsu'yu que tū' stu'ncua' a'ntū quilālē'ksa'nāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Quit iccālīmāxtu tlajana'nī'n por ixlīmāpa'ksīn Dios. Lā' huā'mā' ū'tza' huanicu'tun que Dios cāmāsu'ni'yāni' a'nchī tzuculhtza' māpa'ksīni'n huā'tzā' nac cā'ti'ya'tna'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’A'xni'ca' maktaka'lhmā' ixchic kalhatin chi'xcu' a'ntī tli'hui'qui lā' a'ntī ka'lhī līcā'n a'ntū nalīmaktāyacan, tuntū' catipātle'keni'lh catūhuā a'ntū ixla'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero palh namin ā'kalhatin más xatli'hui'qui, ū'tza' natlaja lā' namaklhtī ixlīcā'n a'ntū līpāhuan lā' namālacpitzi a'ntū namaklhtī. ");
INSERT INTO tooNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’A'ntīn tū' tapa'ksīcu'tun con quit, ū'tza' quintā'ca'tza. Lā' a'ntīn tū' quintā'scuja, ū'tza' lactlahuana'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Lā' Jesús cāhuanipā: ―A'xni'ca' lakatin tlajana' nataxtu de huan chi'xcu', nalatā'kchoko a'nlhā cā'scōhua lā' naputza a'nlhā najaxa. Lā' a'xni'ca' tū' kaksa a'nlhā najaxa, napuhuan: “Na'ictaspi'tchoko a'nlhā ictaxtulh”. ");
INSERT INTO tooNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","’Lā' a'xni'ca' nataspi'ta, nakaksa huan chi'xcu' hua'chi lakatin chic a'ntū scayancyā lā' xa'nca pa'lhnancanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Lā' tuncan na'a'n nacātē ā'kalhatojon tlajana'nī'n más xaca'tzanca'tzīnī'n. Lā' ixlīhuākca'n natatanū natalatahui'la na ixchakān huan chi'xcu'. Lā' chuntza' ā'chulā' na'a'nīni' huan chi'xcu' que a'xni'ca' ixka'lhī xmān kalhatin tlajana'. ");
INSERT INTO tooNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Lā' a'xni'ca' Jesús ixcāhuanimā' huā'mā', kalhatin puscāt na ixlaclhpu'nanca'n tachi'xcuhuī't ta'salh lā' hualh: ―¡Līpāxūj huan puscāt a'ntī mālacatuncuīnī'ta'ni' lā' a'ntī mātziquī'ni'! ");
INSERT INTO tooNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Lā' Jesús hualh: ―¡A'chulā' natalīpāxuhua a'ntīn takaxmata lā' ta'a'cnīni'ni' a'ntū huan Dios lā' ta'a'kahuāna'ni'! ");
INSERT INTO tooNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Huan tachi'xcuhuī't ā'chulā' talaktakēstokli Jesús lā' xla' tzuculh chihuīna'n lā' hualh: ―Hui'xina'n huā'tzā' tū' tzey. U'tza' līsqui'nā'tit lakatin lē'cnīn. Lā' xmān nacātamāsu'ni'yāni' lē'cnīn hua'chi a'ntū pātle'keni'lh Jonás. ");
INSERT INTO tooNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Lā' a'ntū pātle'keni'lh Jonás cāmāsu'ni'lh ixlīmāpa'ksīn Dios xalanī'n nac Nínive. Lā' nā chuntza' a'ntū napātle'keni' huan Chi'xcu' xala' Tālhmā'n nacāmāsu'ni'yāni' ixlīmāpa'ksīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Namin huan chi'chini' a'xni'ca' nacālaccāxtlahuakō'can ixlīhuākca'n tachi'xcuhuī't xala' nac huā'mā' quilhtamacuj. Lā' a'xni'ca'tza' huan reina a'ntī ixmāpa'ksīni'n nac Saba natāya lā' nacālē'ksa'nīni'nāni'. Nacālē'ksā'nīni'nāni' xla' porque xla' kaxmatli a'ntū hualh Salomón. Makat ixuanī't ixchic huan reina lā' milh kaxmata Salomón. Lā' quit ā'chulā' ictasqui'nī que Salomón lā' tū' quinkaxpa'tcu'tunā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","’Lā' nā a'xni'ca' nalaccāxtlahuakō'can, xlaca'n a'ntī ixtahui'lāna' huan nac cā'lacchicni' a'nlhā huanican Níneve natatāya lā' nacātalē'ksa'nīni'nāni' hui'xina'n a'ntī hui'lāna'ntit chuhua'j. Nacātalē'ksa'nīni'nāni' como xlaca'n taxtāpalīlh ixtapāstacna'ca'n a'xni'ca' milh Jonás lā' lī'a'cta'sana'lh ixtachihuīn Dios. Lā' hui'xina'n tū' xtāpalī'tit mintapāstacnaca'n a'xni'ca' quit ica'cta'sana'lh. Lā' quit ā'chulā' ictasqui'nī que Jonás. ");
INSERT INTO tooNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Lā' Jesús cāhuanipā: ―Tintī' māquilhtī ixpūmaksko lā' namātze'ka o nahui'lī ixtampīn cajón. Namā'ca' cā'lakuān para que chuntza' a'ntī natatanū tzē natalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Palh tū' tampi'lhīni'nā'tit lā' palh laktzī'nā'tit a'ntūn tamaclacasqui'n ā'makapitzīn, ū'tza' hua'chilh tzey milakastapunca'n lā' hua'chilh huāk xkakana' na mimacni'ca'n. Lā' palh xmān laktzī'nā'tit a'ntū maclacasqui'nā'tit hui'xina'n mē'cstuca'n, lej lactampi'lhni' lanī'ta'ntit. Lā' ū'tza' hua'chilh tū' tzey milakastapunca'n lā' hua'chilh huāk cā'pucsua' na mimacni'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Cuenta catlahua' que tū' natzucuya' pāstaca' a'ntūn tū' tzey, porque chuntza' tūlalh catitlahua' a'ntūn tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Palh hui'x pāstaca' a'ntūn tzey lā' palh tlahua'ya' a'ntūn tzey, ū'tza' nala hua'chi lakatin pūmaksko a'ntū xa'nca maksko mintej. ");
INSERT INTO tooNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","A'xni'ca' Jesús chihuīna'nkō'lh, kalhatin fariseo huanilh que catā'a'lh tā'huā'yan na ixchic. Lā' Jesús tanūlh lā' tahuī'lh huā'yan. ");
INSERT INTO tooNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lā' huan fariseo lē'cnīlh como Jesús tū' makacha'ka'lh hua'chi xlaca'n ixtalīsmanīnī't para natahuā'yan. ");
INSERT INTO tooNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Lā' huan Māpa'ksīni' huanilh: ―Hui'xina'n fariseosnu' hua'chi a'ntī namakche'kē' vaso lā' pulātu lā' tū' catipūche'kē'lh. Nā chuntza' hui'xina'n. Tasu'yu'yā'tit que tzeyā chi'xcuhuī'n hui'xina'n pero tū' tzey mintapāstacna'ca'n porque tampi'lhīni'nā'tit lā' tlahua'cu'tunā'tit a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tū' māchekxīcu'tunā'tit hui'xina'n! ¿Chu tū' ca'tzīyā'tit que Dios cātlahuani' hui'xina'n para que na'a'cnīni'ni'yā'tit Dios? Lā' a'xni'ca' tū' tzey mintapāstacna'ca'n, tūlalh cati'a'cnīni'ni'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Palh stu'ncua' a'cnīni'ni'cu'tunā'tit Dios, maclacasqui'n xatzey mintapāstacna'ca'n. Palh tzey mintapāstacna'ca'n, ixlīhuākca'n natalaktzī'n palh tzey hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Hui'xina'n fariseosnu' nalakaputzayā'tit! Hui'xina'n māstā'yā'tit para Dios macsti'na'j huan līhua'tna' hua'chi a'lhmūhuēn lā' a'jonjolin lā' ā'tāpātin. Lā' chuntza' tasqui'nī. Pero tū'tza' tasu'yu palh pāxquī'yā'tit Dios lā' palh natlahua'yā'tit a'ntū lacuan. Lā' tasqui'nī namāstā'yā'tit huan lacmacastin līhua't. Lā' nā maclacasqui'n natlahua'yā'tit a'ntū xatzey lā' napāxquī'yā'tit Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Nalakaputzayā'tit hui'xina'n fariseosnu'! Lacasqui'nā'tit mimpūtahuī'lhca'n a'ntū más xalactzey nac lītokpān. Lā' lacasqui'nā'tit cacāta'a'cnīni'ni'ni' a'xni'ca' pimpā'na'ntit nac tej. ");
INSERT INTO tooNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Nalakaputzayā'tit hui'xina'n mākalhtō'kē'ni'nī'n de huan ley lā' fariseosnu' a'ntī a'kxokonu'nī'n! Hui'xina'n hua'chi taponkni' a'ntūn tū' tatasu'yu. Tachi'xcuhuī't tachi'nta lā' tū' taca'tzī. Chuntza' talaclē'n chu a'nchī tatzo'kni' na ixley Moisés. Nā chuntza' hui'xina'n cāmālaclīpinīyā'tit ā'makapitzīn ixpālacata a'ntū cāmāsu'ni'yā'tit. Lā' xlaca'n tū' taca'tzī palh talaclē'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tuncan kalhtīlh kalhatin xamākalhtō'kē'ni' ley lā' huanilh: ―Mākalhtō'kē'ni', a'xni'ca' hua'na' huā'mā' quilālacaquilhnīyāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Lā' Jesús hualh: ―¡Nalakaputzayā'tit nā hui'xina'n huan mākalhtō'kē'ni'nī'n ley! Lej lhūhua' talanān mātlahuīni'nā'tit lā' tūlatza' tlōkentaxtūkō'can. U'tza' hua'chilh ixcāxtlahua'tit huan tacu'ca' a'ntū lej tzinca. Nīn tintī' tzē natāyani' lā' hui'xina'n tū' lacāxtlahuacu'tunā'tit para que tzē nacu'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Nalakaputzayā'tit hui'xina'n! Tū' tzey a'nchī tlahua'yā'tit. Xmān cā'a'cnīni'ni'cu'tunā'tit huan xanīnī'ntza' a'cta'sana'nī'n. Minapapana'ca'n tamaknīlh huan a'cta'sana'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Lā' hui'xina'n tlahua'yā'tit ixa'cchicca'n huan a'cta'sana'nī'n a'ntī cāmaknīca. U'tza' lītasu'yu que chu lakatin hui'lāna'ntit con minapapana'ca'n, lā' puhua'nā'tit que tzey a'nchī tatlahualh. ");
INSERT INTO tooNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’U'tza' līchihuīna'lh Dios como lej ka'lhī tapāstacna'; hualh: “Na'iccāmacamini' a'cta'sana'nī'n. Lā' nacāmaknīcan ā'makapitzīn lā' nacāmāpātīnīcan ā'makapitzīn huampala”. ");
INSERT INTO tooNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Chuntza' huan tachi'xcuhuī't a'ntīn tahui'lāna' chuhua'j, ū'tunu'n natalē'n cuenta ixpālacata ixlīhuākca'n a'cta'sana'nī'n a'ntī cāmaknīcanī't desde a'xni'ca lalh quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Natzucucan nacākalhasqui'nīcan con Abel lā' ā'xmān nalī'a'ksputcan huan Zacarías a'ntī maknīca na ixpu'nan huan lītokpān lā' na ixlacapūn huan pūmacamāstā'n. U'tza' iccāhuaniyāni' que Dios nacākalhasqui'nīyāni' hui'xina'n ā'tzā' ixpālacata huan a'cta'sana'nī'n a'ntī cāmaknīcanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Nalakaputzayā'tit hui'xina'n, mākalhtō'kē'ni'nī'n ley! Ixtachihuīn Dios hua'chilh tanūma' nac lakatin chic. Hui'xina'n ka'lhīyā'tit xallave huan chic, pero tū' tanūyā'tit. Lā' tū' cāmakxtekā'tit natatanū ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","A'xni'ca' Jesús cāhuanilh huanmā', huan mākalhtō'kē'ni'nī'n ley lā' fariseosnu' ta'a'kchā'ni'lh Jesús. Lā' lej tatzuculh takalhasqui'nī lhūhua' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ixtamaktaka'lhmā'na a ver palh tzē ixtamakkaksli a'ntū ixtalīlē'ksa'nīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Līhuan ixtatakēstokmā'na lej lhūhua' tachi'xcuhuī't hasta ixtalālacchi'ntatza'. Lā' Jesús tzuculh cāhuani pū'la ī'sca'txtunu'nī'n: ―Cuenta natlahuayā'tit huan fariseosnu' como xlaca'n tatlahua lakatu' ixlacanca'n. Lā' tū' titlahuayā'tit hua'chi xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ixlīhuāk a'ntū tatzē'knī't, ū'tza' nalaktzī'ncan. Lā' a'ntū lakatzē'kcus, naca'tzīkō'can. ");
INSERT INTO tooNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Lā' chuntza' a'ntū hui'xina'n huaninī'ta'ntit xmān kalhatin, ū'tza' nakaxmatcan chuxalhā. Lā' a'ntū tzē'k huanī'ta'ntit ixchakān chic, ū'tza' palha' nahuancan kēpūn. ");
INSERT INTO tooNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Lā' Jesús cāhuanipā: ―Qui'amigos, iccāhuaniyāni' que tū' tijicua'ni'yā'tit a'ntīn tamaknīni'n lā' ā'calīstān tūla tatlahua ā'chulā'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Na'iccāhuani'yāni a'ntī najicua'ni'yā'tit: Cajicua'ni'tit Dios a'ntī tzē nacāmāsputūkō'yāni' lā' ā'calīstān nacāmacā'nāni' nac pūpātīn. U'tza' calījicua'ni'tit Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Tū' lej tapala huan tantzictzi. Stā'can tanquitzis por xmān lakatu' tumīn. Lā' Dios tū' cāpātza'nkā nīn lakatin de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pues hasta miya'jca'n chā'tunu' de hui'xina'n cātapūtle'keni'ni' kanatunu'. Lā' ū'tza' tū' tilījicua'nā'tit; hui'xina'n ā'chulā' tapalayā'tit que huan tantzictzi. ");
INSERT INTO tooNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Lā' Jesús cāhuanipā: ―Iccāhuaniyāni' que chuxatī a'ntī nahuan na ixlacapūnca'n tachi'xcuhuī't: “Quit ictapa'ksī con Cristo”, lā' chuntza' nā quit na'icuan na ixlacapūnca'n ixángeles Dios: “Xla' tapa'ksī con quit”. Lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Lā' chuxatī naquinkalhtatzē'ka na ixlacapūnca'n tachi'xcuhuī't, nā quit na'ickalhtatzē'ka na ixlacapūnca'n ixángeles Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Lā' a'ntī talīchihuīna'n contra huan Chi'xcu' xala' Tālhmā'n, nacāmāsputūnu'ni'can. Pero a'ntīn tahuan que tū' tzey a'ntū tlahua huan Espíritu Santo, xlaca'n tūla caticāmāsputūnu'ni'ca. ");
INSERT INTO tooNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’A'xni'ca' nacātalē'nāni' na ixlacapūnca'n huan māpa'ksīni'nī'n lā' huan pūchihuīna'nī'n a'nlhā tlahuacan justicia, tū' lej nacāpāta'layāni' a'nchī nakalhtīni'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huā'mā' ka'tlā'tus, a'xni'ca' nachihuīna'nā'tit, huan Espíritu Santo nacāmāsu'ni'yāni' a'nchī nakalhtīni'nā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kalhatin ixlaclhni' tachi'xcuhuī't huanilh Jesús: ―Mākalhtō'kē'ni', cahua'ni' quintā'tin caquimāpitzini'lh quiherenciaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Lā' Jesús kalhtīlh: ―¿Tichū quihui'līnī't quit hua'chi juez o mālacpitzini' ti'ya't? ");
INSERT INTO tooNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Lā' nā hualh: ―Cuenta catlahua'tit. Lā' tū' titampi'lhīni'nā'tit porque huan lhūhua' tumīn lā' ā'catūhuā xala' nac huā'mā' quilhtamacuj tūlalh caticāmaxquī'ni' minquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Lā' tuncan Jesús cālīmālacastucli lā' cāhuanilh: ―Ixuī' kalhatin chi'xcu'; lej rico ixuanī't. Lā' lej ixmakalana'n na i'xti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Lā' xla' tuncan puhualh ixpātunca'tzi: “¿Tuchū na'ictlahua? Tū' icka'lhī lhā na'icmāquī' lhūhua' quincuxi'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na'iccālactlahua xalacti'na'jna' quimpūcuxi' lā' na'ictlahua más xaka'tla' lā' a'ntza' na'icmāquī'kō' quincuxi' lā' ixlīhuāk ā'makapitzīn a'ntu icmakalalh. ");
INSERT INTO tooNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Lā' a'xni'ca' na'icpuhuan quē'cstu: Chuhua'j icka'lhī lhūhua' catūhuā para lhūhua' cā'ta. Chuhua'j na'icjaxa lā' na'icuā'yan lā' na'icko'tnūn lā' na'icpāxuhua”. ");
INSERT INTO tooNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Lā' Dios huanilh: “Hui'x tū' xa'nca pāstacna'na'. Chuhua'j huā'mā' tzī'sa nanī'ya'. Lā' a'ntū māquī'nī'ta', ¿tichū natachokoni'?” ");
INSERT INTO tooNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chuntza' napātle'keni' kalhatin chi'xcu' a'ntī mākēstoka lhūhua' catūhuā para ixa'cstu. Lā' ixlīhuāk a'ntū ka'lhī, nīn tuntū' ixtapalh na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","A'calīstān Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Iccāhuaniyāni'. Tū' ticāpāta'layāni' a'ntū nahua'yā'tit nīn a'ntū nalhakā'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Como Dios cāmaxquī'yāni' minquilhtamacujca'n lā' mimacni'ca'n a'ntū napūscujā'tit, ā'chulā' nacāmaxquī'yāni' milīhua'tca'n lā' milu'xu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cuenta cacātlahua'tit huan cha'kni'. Xlaca'n nīn tuntū' tacha'n lā' nīn tamakalana'n. Lā' tū' taka'lhī ixpūcuxi'ca'n pero Dios cāmāhuī'. A'chulā' tapalayā'tit hui'xina'n que huan tamā'na spūnnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nīn tintī' de hui'xina'n tzē más makān nalatahui'la a'yuj cāpāta'layāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Palh chuntza' tūla natlahuayā'tit, ¿a'chī' lē'capinā'tit ā'tāpātin catūhuā? ");
INSERT INTO tooNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Cuenta cacātlahua'tit huan xa'natna' a'nchī talīstaca. Tū' tascuja lā' tū' tatza'pa' ixlu'xu'ca'n. Lā' lej tzēhuanī't tastaca a'yuj tuntū' tatlahua. Lā' iccāhuaniyāni' que huan rey Salomón tūlalh cāmālacastucli ixlītzēhuanī't huan xa'nat. Lā' xla' lej rico ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A'nan chi'tin nac cā'tacuxtu a'ntū tzēhuanī't pero lakalī tū'xama'n nacā'ī'can lā' nacālhcuyucan. Lā' como Dios cāmaktaka'lha lā' cāmakastaca huan chi'tin a'ntū palaj nascōhuan, ā'chulā' nacāmaktaka'lhāni' hui'xina'n. Lā' ¿a'chī' tū' kalhlaka'ī'yā'tit huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Chuntza' tū' tilē'capinā'tit ixpālacata a'ntū nalīhua'yā'tit nīn a'ntū nalīko'tnūnā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Huan tachi'xcuhuī't xala' huā'mā' quilhtamacuj xmān ū'tza' taputzatlā'huan. Lā' hui'xina'n ka'lhīyā'tit kalhatin minTāta'ca'n nac a'kapūn lā' xla' ca'tzī a'ntū maclacasqui'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mejor pū'la caputzatit a'nchī nalī'a'kahuāna'ni'yā'tit Dios xala' tālhmā'n lā' nā namaklhtīni'nā'tit ā'makapitzīn a'ntū maclacasqui'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lā' Jesús cāhuanipā: ―Quilakska'tā'n, tū' cajicua'ntit. Tū' lhūhua' hui'xina'n pero minTāta'ca'n nac a'kapūn lacasqui'n que natapa'ksīyā'tit con xla'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Castā'tit a'ntū ka'lhī'yā'tit lā' cacāmaxquī'tit a'ntīn tamaclacasqui'n. Chuntza' naka'lhī'yā'tit mimpūtumīnca'n a'ntūn tū' maktin catimasli lā' milīricujlani'ca'n nac a'kapūn a'nlhā tū' maktin catisputli. Lā' a'ntza' tū' catitanūlh ka'lhāna' lā' nīn huan tzapūla' tūlalh catihua'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","A'nlhā huī' milīricujlani'ca'n, a'ntza' huī' mintapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Lā' Jesús cāhuanipā: ―Cacāxtahui'la'tit con mimpūmakskoca'n xataquilhtani'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cala'tit hua'chi tasācua' a'ntīn taka'lhīmā'na ixpatronca'n a'ntī a'nī't a'nlhā tapūchahuamā'ca. Lā' a'xni'ca' nataspi'ta lā' nalīmacasā'nan huan mākalhcha, lacasqui'n camālaquī'ni'ca lacapalh. ");
INSERT INTO tooNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Līpāxūj huan tasācua'nī'n talakahuahui'lāna' a'xni'ca' nachin ixpatronca'n. Stu'ncua' a'ntū iccāhuaniyāni' que māni' ixpatronca'n namācāxkō' lā' nacāmāhuī'can. ");
INSERT INTO tooNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A'yuj cachilh i'tāt tzī'sa o tuncuīni', pero līpāxūj huan tasācua'nī'n palh talakahuahui'lāna' a'xni'ca' nachin ixpatronca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Caca'tzī'tit huā'mā' que palh ixtēcu' chic ixca'tzīlh tuyā hora nachin huan ka'lhāna', ixlakahuantō'lalh lā' tū' ixtimakxtekli natanū huan ka'lhāna'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nā hui'xina'n caskalalhtō'la'tit como namin huan Chi'xcu' xala' Tālhmā'n a'xni'ca' tū' pāstacā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Lā' tuncan Pedro kalhasqui'nīlh: ―¿Chā quilālīmālacastucui xmān para quina'n o para līhuāk? ");
INSERT INTO tooNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lā' Jesús hualh: ―¿Chī huanī't huan xatzey tasācua' a'ntī xa'nca māchekxī? Xla' ū'tza' a'ntī huan patrón nalīmāmacū' huan chic para nacāmāhuī' ixtā'tasācua'nī'n a'xni'ca' maclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Līpāxūj huan tasācua' palh tlōkentaxtūmā' ixlītlōt a'xni'ca' nataspi'ta ixpatrón. ");
INSERT INTO tooNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Stu'ncua' a'ntū iccāhuaniyāni'. Huan patrón nalīmāmacū' huā'mā' tasācua' ixlīhuāk a'ntū ka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Lā' palh tū' tzey huā'mā' tasācua', xla' napuhuan que natakoxī huan ixpatrón. Lā' chuntza' natzucu cālactucsa ā'makapitzīn tasācua'nī'n lā' huan maksqui'tīnī'n lā' natzucu huā'yan lā' nako'ta lā' naka'chī. ");
INSERT INTO tooNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Lā' chu līmaktin nataspi'ta huan patrón. Lā' namin lakatin chi'chini' a'xni'ca' huan tū' tzeyā tasācua' tū' ca'tzī lā' tū' ka'lhīmā'. Lā' huan patrón lej palha' nacastigarlī huan tasācua' lā' namāpātīnī hua'chi natapātīni'n xlaca'n a'ntī līhua tahuan palh takalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Huan tasācua' a'ntī ca'tzī a'ntū lacasqui'n ixpatrón lā' tū' tlōkentaxtū lā' tū' a'cnīni'ni', xla' lej maklhūhua' natucscan. ");
INSERT INTO tooNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Lā' huan a'ntīn tū' ca'tzī a'ntū lacasqui'n ixpatrón lā' chuntza' natlahua a'ntū maclacasqui'n castigo, xla' tū' lhūhua' catihui'līni'ca. A'ntī līmāmacū'can lhūhua', xla' tzē nasqui'ni'can lhūhua'. Lā' a'ntī līmāmacū'can más lhūhua', xla' tzē nasqui'ni'can más lhūhua'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Lā' Jesús cāhuanipā: ―Por quimpālacata tū' chu lakatin natala. Makapitzīn lej nata'a'kahuāna'ni' quintachihuīn. Lā' ā'makapitzīn lej natalakmaka'n quintachihuīn. Makapitzīn stu'tu'lu' natahuan que stu'ncua' quintachihuīn lā' ā'makapitzīn stu'tu'lu' natahuan que tū' stu'ncua'. Chuntza' calalh chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A'nan a'ntū na'icpātī. ¿Chī na'iclītāyani' hasta a'xni'ca' na'ictlōkentaxtū? ");
INSERT INTO tooNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Chu puhua'nā'tit icmilh para que chu lakatin natala tachi'xcuhuī't? Iccāhuaniyāni' que tū'. Na'iccāmā'kapitziyāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Lā' chuhua'j hasta kalhaquitzis xala' lakatin chic natalacpitzi. Kalhatu'tun natala contra kalhatu', lā' kalhatu' contra kalhatu'tun. ");
INSERT INTO tooNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Huan xatāta' nala contra ixcaman lā' huan o'kxa' contra ixtāta'. Lā' xatzī't nala contra ixtzu'ma'jāt lā' huan tzu'ma'jāt nala contra ixtzī't. Lā' huan puscāt nala contra ixpuscāt ixo'kxa' lā' huan puscāt nala contra ixtzī't ixkōlu'. ");
INSERT INTO tooNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nā Jesús cāhuanilh huan tachi'xcuhuī't: ―A'xni'ca' hui'xina'n laktzī'nā'tit tā'kaquī'mā'cha' poklhnu' a'nlhā tā'cnū huan chi'chini', tuncan nahua'nā'tit namin xcān. Lā' chuntza' pātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Lā' a'xni'ca' minācha' huan ū'ni' xala' nac sur, huancan naxu'nu. Lā' chuntza' pātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Hui'xina'n tlahua'yā'tit lakatu' milacanca'n! Tzē nahuanā'tit palh namin xcān o tū' namin, xmān porque laktzī'nā'tit huan a'kapūn. Lā' ¿a'chī' tū' cuenta tlahua'yā'tit a'ntū pātle'kemā' nac huā'mā' quilhtamacuj a'xni'ca' laktzī'nā'tit huan lē'cnīn? ");
INSERT INTO tooNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Lā' Jesús cāhuanipā: ―¿A'chī' tūla puhuanā'tit palh catūhuā tzey o tū' tzey? ");
INSERT INTO tooNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Palh catīhuā mālacapū'yāni', calī'hui'li' natā'lacāxla'ya' līhuan tūna'j pinā'tit nac pūchihuīn. Chuntza' tū' catilē'ni' na ixlacapūn juez. Lā' huan juez tū' catimacamāstā'ni' con huan policía lā' huan policía tū' catimānūni' nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Palh chuntza' ixpātle'keni'ni', icuaniyāni que tū' catitaxtu hasta que tū' namāpalakō'ya' ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lā' huā'mā' chi'chini' tamilh chi'xcuhuī'n. Lā' ixtahuanimā'na Jesús a'nchī Pilato cāmāmaknīnīni'nī't makapitzīn chi'xcuhuī'n xalanī'n nac Galilea a'xni'ca' xlaca'n ixtamaxquī'mā'na Dios huan lē'ksajna'. ");
INSERT INTO tooNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Lā' Jesús cāhuanilh: ―¿Chu puhua'nā'tit que huan tamā'na chi'xcuhuī'n cāpātle'keni'nī't chuntza' porque más ixtalaclē'n que ā'makapitzīn xalanī'n nac Galilea? ");
INSERT INTO tooNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iccāhuaniyāni' que tū'. Lā' palh hui'xina'n tū' naxtāpalīyā'tit mintapāstacna'ca'n, nā milīhuākca'n nanīkō'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lā' huan kalhacāujtzeyan a'ntīn tanīlh a'xni'ca' huan torre de Siloé tapancli lā' cā'a'klhta'lalh, ¿chu puhua'nā'tit que más ixtalaclē'n que ā'makapitzīn xalanī'n nac Jerusalén? ");
INSERT INTO tooNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iccāhuani'yāni' que tū'. Lā' palh hui'xina'n tū' naxtāpalī'yā'tit mintapāstacna'ca'n, nā nanī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Lā' tuncan Jesús cāhui'līni'lh huā'mā' a'ntū lītalacastuca lā' cāhuanilh: ―Kalhatin chi'xcu' ixcha'nī't a'katin xaqui'hui' higo na ixti'ya't. Lā' a'lh laktzī'n palh ixtō'ca'mā'. Lā' tū' makkaksli ixtō'ca't. ");
INSERT INTO tooNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lā' tuncan huanilh ixtasācua': “Lakatu'tun cā'tatza' icmakputza ixtō'ca't huā'mā' qui'hui' lā' nīn tuntū' icmakkaksa. Catanca' porque xmān yā. Chu tlakaj iccha'nli”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Lā' a'ntī ixmaktaka'lha huan ti'ya't kalhtīlh: “Camakxtekti xmān huā'mā' cā'ta. Na'iclacxla'ja huan ti'ya't lā' na'icmaka'ni' abono. ");
INSERT INTO tooNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Lāsā' chuhua'j natō'ca'. Lā' palh tū' tō'ca' a'xni'ca' natancā'ya'”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lakatin chi'chini' a'ntū ixpūjaxcan, Jesús ixcāmāsu'ni'mā' nac lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Lā' ixuī' a'ntza' kalhatin puscāt a'ntī ixī'tza'ca'n lakacāujtzeyan cā'ta. Ixchi'panī't lakatin tlajana' lā' ixmaka'ī'tza'ca'n lā' ixtaquilhpūstucnī't lā' tūla ixtā'cstu'nca nīn macsti'na'j. ");
INSERT INTO tooNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lā' Jesús, a'xni'ca' laktzī'lh huan puscāt, ta'sani'lh lā' huanilh: ―Puscāt, tzeyanī'ta'tza'. Tū'tza' ka'lhī'ya' ta'jatat. ");
INSERT INTO tooNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Lā' tuncan Jesús mā'ca'ni'lh ixmacan lā' chu tuncan huan puscāt tā'cstu'ncli lā' tzuculh mācā'tanī Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Como Jesús mātzeyīlh huanmā' chi'chini' a'ntū pūjaxcan, huan xapuxcu' de huan lītokpān a'kchā'lh lā' cāhuanilh huan tachi'xcuhuī't: ―A'nan xmān lakachāxan chi'chini' para nascujā'tit. Huan tamā'na chi'chini' cata'ntit tacu'chu'yā'tit lā' tū' a'xni'ca' jaxkō'can. ");
INSERT INTO tooNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Lā' tuncan Jesús kalhtīlh: ―¡Tlahua'yā'tit lakatu' milacanca'n! ¿Chu tū' naxcutā'tit mihuācaxca'n o mimburroca'n huan chi'chini' a'ntū pūjaxcan lā' namāko'tūyā'tit? ");
INSERT INTO tooNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lā' huā'mā' puscāt, ī'xū'yātā'nat Abraham, lā' hua'chīlh līchī'hui'līlh huan Satanás huā'mā' ta'jatat. Lā' chuhua'j lakacāujtzeyan cā'tatza'. ¿Chu tū' līmakuan ixmaklhtīca ixta'jatat huā'mā' chi'chini' a'ntū pūjaxcan? ");
INSERT INTO tooNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","A'xni'ca' Jesús hualh huā'mā', cāmāmāxanī'lh ixlīhuākca'n ixtā'ca'tzanī'n. Lā' ixlīhuākca'n tachi'xcuhuī't ixtalīpāxuhua huan lē'cnīn a'ntūn tlahualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Lā' tuncan Jesús hualh: ―¿Chī huanī't ixlīmāpa'ksīn Dios? Lā' ¿chī na'iclīmālacastuca a'nchī natalhūhua'n xlaca'n a'ntī Dios cāmāpa'ksī? ");
INSERT INTO tooNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Natalhūhua'n chuntza' hua'chi staca lakatin ti'ni' de mostaza a'ntū cha'nli kalhatin chi'xcu' nac ti'ya't. Lacti'na'j huanmā' ti'ni' lā' a'xni'ca' nastackō', nala hua'chi a'katin qui'hui'. A'xni'ca' ka'tla'tza' lā' a'ntza' huan spūnnu' natatlahua ixmāsekca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nā Jesús cāhuanilh: ―¿Chī na'iclīmālacastuca a'nchī nalaklhtāya ixlīmāpa'ksīn Dios? ");
INSERT INTO tooNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","U'tza' hua'chi lakatin levadura a'ntū kalhatin puscāt nalītlō maktu'tun xatapūlhcān harina lā' namakxteka hasta nalaklhtāyakō' huan ixtasquit. ");
INSERT INTO tooNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús tēpā ixtej para nac Jerusalén. Lā' ixtētaxtu cā'lacchicni' ti'na'j lā' laka'tla' lā' ixmāsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Lā' kalhatin kalhasqui'nīlh: ―¿Chā xmān makapitzīn natapūtaxtu? Lā' Jesús kalhtīlh: ");
INSERT INTO tooNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Calīhui'lī'tit natanū'yā'tit nac xapītzina'j mākalhcha para nac a'kapūn, porque iccāhuaniyāni' que lhūhua' nataputza a'nchī natalītanūcu'tun. Lā' tūlalh catitatanūlh. ");
INSERT INTO tooNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","A'xni'ca' huan xamāpa'ksīni' chic namālacchō mākalhcha, hui'xina'n a'ntī yā'na'ntit kēpūn nalīmacasā'na'nā'tit huan mākalhcha. Lā' nahua'nā'tit: “Caquilāmālaquīni'uj”. Lā' xla' nacākalhtīyāni': “Tū' icca'tzī lhachū xalanī'n hui'xina'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Lā' hui'xina'n naquilhtzucuyā'tit nahua'nā'tit: “Iccātā'huā'yanī'ta'ni' lā' hui'x māsu'yu' na qui'ā'lacchicni'ca'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Lā' xla' nacākalhtīyāni': “Iccāhuanini'tza' que tū' icca'tzī lhachū xalanī'n hui'xina'n. Caquilātapānūni'uj milīhuākca'n. Hui'xina'n lej tlahua'yā'tit a'ntūn tū' tzey”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lā' chuntza' hui'xina'n nacalhua'nā'tit a'ntza' lā' nalāmāxcani'yā'tit mintatzanca'n a'xni'ca' nalaktzī'nā'tit que Abraham lā' Isaac lā' Jacob lā' ixlīhuākca'n huan a'cta'sana'nī'n tahui'lāna'ncha' a'nlhā Dios māpa'ksīni'n lā' hui'xina'n tū' caticātamakxtekni' natanū'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","’Nataminācha' tachi'xcuhuī't xalanī'n chuxalhā lā' natahuā'yan a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A'xni'ca'tza' lej nacā'a'cnīni'ni'can xlaca'n a'ntīn tū' tatasqui'nī chuhua'j; lā' tū' caticā'a'cnīni'ni'ca xlaca'n a'ntī lej tatasqui'nī chuhua'j ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chu ū'tza' huā'mā' chi'chini' ā'makapitzīn fariseosnu' talakchilh Jesús lā' tahuanilh: ―Cataxtu de huā'tzā' porque Herodes maknīcu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Lā' Jesús cākalhtīlh: ―Calakpintit huanmā' chi'xcu' a'ntī lej skalalh para natlahua a'ntū xla' lacasqui'n lā' nahuani'yā'tit: “Chuhua'j lā' lakalī na'iccāmāxtukō' huan tlajana'nī'n. Nā na'iccāmātzeyī ī'tza'ca'nī'n. Lā' tū'xama'n na'ictlahuakō'”. ");
INSERT INTO tooNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Lā' maclacasqui'n na'ica'n na quintej chuhua'j lā' lakalī tū'xama'n porque tū' līmakuan chuxalhā nanī kalhatin a'cta'sana', xmān a'nlhā huanican nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Xānti layā'tit xalanī'n nac Jerusalén! Hui'xina'n cāmaknīyā'tit a'cta'sana'nī'n lā' cāmūta'layā'tit huan lacscujnī'n a'ntī Dios cāmacā'n. Maklhūhua' xa'iccāmākēstokcu'tunāni' hua'chi huan ko'lhnu' cāmākēstoka ixcamana', pero tū' lacasqui'ntit. ");
INSERT INTO tooNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cuenta catlahua'tit hui'xina'n como Dios makxteklitza' mi'ā'lacchicni'ca'n. Lā' iccāhuaniyāni' que tū'tza' quintilālaktzī'uj hasta huan chi'chini' a'xni'ca' nahuancan: “Sicua'lanālanī't a'ntī min con ixlīmāpa'ksīn Dios”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Lā' milh lakatin chi'chini' a'ntū pūjaxcan lā' a'xni'ca' Jesús quīmakuā'yalh na ixchic kalhatin xapuxcu' fariseosnu'. Lā' ā'makapitzīn fariseosnu' ixtamaktaka'lhmā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nā ixuī' kalhatin chi'xcu' na ixlacapūn lā' ixka'lhī cu'nu'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Lā' tuncan Jesús cākalhasqui'nīlh huan xamākalhtō'kē'ni'nī'n ley lā' huan fariseosnu': ―Lā' huan ixley Moisés ¿chā makxteka namātzeyīcan kalhatin ī'tza'ca' huan chi'chini' a'ntū pūjaxcan o tū' makxteka? ");
INSERT INTO tooNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Lā' xlaca'n ca'cs tatāyalh. Lā' tuncan Jesús makachi'palh huan ī'tza'ca' lā' mātzeyīlh lā' huanilh que ca'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Lā' cāhuanilh huan fariseosnu': ―Palh mimburroca'n o mihuācaxca'n namakōsa nac pūlhmā'n xcān ¿chu tū' namācutuyā'tit tuncan a'yuj huan chi'chini' a'ntū pūjaxcan? ");
INSERT INTO tooNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Lā' tūlalh takalhtīni'lh nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A'xni'ca' Jesús laktzī'lh huan a'ntī cākantāyacanī't lā' a'nchī ixtaputzamā'na huan pūtahuī'lhni' a'ntū más xalactzey, cāmaxquī'lh huā'mā' tapāstacna': ");
INSERT INTO tooNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―A'xni'ca' nakantāyaca'na' a'nlhā tapūchahuacan, tū' titahui'la'ya' calacan. Chō'la tzē nachin ā'kalhatin a'ntī más tasqui'nī que hui'x. ");
INSERT INTO tooNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Lā' a'ntīn kantāyani' nalaka'nāni' nahuaniyāni': “Cama'xqui' mimpūtōlh huā'mā' kalhatin a'ntī ā'calīstān chilh”. Lā' chuntza' māxana'jtza' napina' natahui'la'ya' kēpān. ");
INSERT INTO tooNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pero a'xni'ca' nakantāyaca'na', natahui'la'ya' nac kēpān. Lā' a'xni'ca' namin a'ntī kantāyanī'ta'ni' nahuaniyāni': “Cata't, catahui'la' nac mesa”. Chuntza' na'a'cnīni'ni'ca'na' na ixlacapūnca'n ā'makapitzīn a'nlhā tapūchahuacan. ");
INSERT INTO tooNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","A'ntī xa'cstu ka'tla' lacu'tun, ū'tza' namāmāxanī'can. Lā' a'ntī tū' xa'cstu putza ixlīka'tla', ū'tza' na'a'cnīni'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nā Jesús huanilh huan chi'xcu' a'ntī ixkantāyanī't: ―A'xni'ca' natlahua'ya' mincā'tani' o mintahua', tū' cacākantāya' xmān mi'amigos lā' mintā'timīn lā' mintalakapasnī'n lā' huan ricosnu'. Xlaca'n a'xni'ca' natatlahua ixcā'tani'ca'n, nā tzē natakantāyayāni' lā' chuntza' naka'lhīya' ixlaktapalh mincā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero a'xni'ca' natlahua'ya' mincā'tani', cacākantāya' huan a'ntī lacxcamanīn lā' huan ī'tza'ca'nī'n lā' huan lū'ntu'lanī'n lā' huan lakatzī'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Lā' chuntza' nalīpāxuhua'ya' como xlaca'n tuntū' catitamaxquī'ni'. Lā' chuntza' naka'lhīya' mintatlaj a'xni'ca' natalakahuanchoko ixlīhuākca'n a'ntīn takalhlaka'ī ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","A'xni'ca' takaxmatli huā'mā', kalhatin a'ntī ixuī' nac mesa huanilh Jesús: ―Līpāxūj a'ntī nahuā'yan a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Lā' tuncan Jesús kalhtīlh: ―Kalhatin chi'xcu' tlahualh lakatin ka'tla' tahua' lā' cākantāyakō'lh lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lā' a'xni'ca' chā'lh huan hora a'ntū pūhuā'yancan, cāmacā'lh ixtasācua' para natamāca'tzīnīni'n lā' cāhuanilh a'ntī ixcākantāyanī't: “Cata'ntit como cāxuī'kō'tza' ixlīhuāk”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero ixlīhuākca'n tamacā'lh razón que tūla ta'a'n. Kalhatin hualh: “Apenas ictamāhualh lakatin ti'ya't lā' maclacasqui'n na'ica'n na'iclaktzī'n. Icsqui'ni'yāni' que naquimāsputūnu'ni'ya' porque tūlalh icti'a'ncha'”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Lā' kalhatin huampā: “Ictamāhualh tanquitzis par de huācax lā' ica'n iccālaktzī'n a ver palh tzey tascuja. Por favor caquimāsputūnu'ni' porque tūlalh icti'a'ncha'”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Lā' kalhatin huampā: “Ictapūchahuakō'lhcus lā' chuntza' tūlalh icti'a'ncha'”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Lā' a'xni'ca' taspi'tli huan tasācua', huanikō'lh ixpatrón a'nchī pātle'kelh. Lā' huan ixpatrón a'kchā'lh lā' huanilh ixtasācua': “Lacapalh capit na ixcā'tejen cā'lacchicni' lā' cacālī'ta' a'ntī lacxcamanīn lā' huan ī'tza'ca'nī'n lā' huan lū'ntu'lanī'n lā' huan lakatzī'nī'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","A'mpā lā' ā'calīstān taspi'tpā huan tasācua' lā' hualh: “Ictlahualhtza' chu a'nchī quihua'ni' lā' ti'a'nan lugar”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Lā' huan patrón huanilh ixtasācua': “Capit nac cā'tejen más makatna' lā' nacāsālī'ta'na' lā' natatzuma quinchic. ");
INSERT INTO tooNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Iccāhuaniyāni' que nīn tintī' de xlaca'n a'ntī iccākantāyalh pū'la natahua' quilīhua't”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Lhūhua' tachi'xcuhuī't ixtastālani' Jesús, lā' xla' cālaktalakspi'tli lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Palh catīhuā tapa'ksīcu'tun con quit lā' tū' napāxquī' Dios más que nacāpāxquī' ixtāta' lā' ixtzī't lā' ixpuscāt lā' ixcamana' lā' ixtā'timīn lā' hasta māni' xla', ū'tza' tūlalh catilalh quisca'txtunu'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Lā' a'ntīn tū' pātīni'ncu'tun por quimpālacata lā' tū' latahui'lacu'tun hua'chi iclahuī' quit, tūlalh catilalh quisca'txtunu'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Palh kalhatin chi'xcu' tlahuacu'tun pātin chic, pū'la natlahua ixcuenta lhānchulā' na'a'n de tumīn. Chuntza' naca'tzī palh na'a'cchā'n huan tumīn a'ntū nalītlahuakō'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Palh tū' chuntza' natlahua, nasputa ixtumīn a'xni'ca' xmān yācus xatantūnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Lā' ixlīhuāk a'ntī natalaktzī'n, natalīlītzī'n. Lā' natahuan: “Huā'mā' chi'xcu' tilītzuculh ixchic lā' tū' mā'ksputukō'lh”. ");
INSERT INTO tooNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Lā' tū' a'nan kalhatin rey a'ntī tū' pū'la napāstaca palh tzē nalītlaja con kalhacāuj mil soldados huan rey ixtā'ca'tza a'ntī ka'lhī kalhapu'xam mil. ");
INSERT INTO tooNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Lā' palh ca'tzī que tūlalh catitlajalh ixtā'ca'tza, namacā'ni' kalhatin lacscujni' para natā'lacāxla a'xni'ca' mimā'cha'cus de makat. ");
INSERT INTO tooNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Lā' chuntza' palh hui'xina'n tū' makxtekcu'tunā'tit ixlīhuāk a'ntū milaca'n, tūlalh catila'tit quisca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lā' Jesús cāhuanipā: ―Tzey huan matzat. Pero palh tū'tza' ka'lhī ixlīsko'ko', ¿chichū nalīmāsko'kō'palacan? ");
INSERT INTO tooNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tū' tzey para tuntū'. Xmān namaka'ncan. A'ntī kaxmata cuenta catlahualh. ");
INSERT INTO tooNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ixlīhuākca'n huan xamātā'jīni'nī'n impuestos lā' a'ntīn tū' lactzey, xlaca'n talaktapajtzūlh Jesús para natakaxmatni'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lā' huan fariseosnu' lā' huan xamākalhtō'kē'ni'nī'n ley ixtalīchihuīna'n Jesús. Lā' talāhuanilh: ―Huā'mā' chi'xcu' cātā'huā'yan huan tachi'xcuhuī't a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lā' tuncan Jesús cāhui'līni'lh huā'mā' a'ntū lītalacastuca: ");
INSERT INTO tooNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Palh kalhatin chi'xcu' cāka'lhī lakatin ciento borregos lā' palh namakatza'nkā lakatin, ¿tuchū natlahua? Nacāmakxteka huan ā'makapitzīn noventa y nueve a'nlhā tahuā'yamā'na nac cā'seketni'. Lā' na'a'n naputza huan borrego a'ntū makatza'nkālh. Naputza hasta a'xni'ca' nakaksa. ");
INSERT INTO tooNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lā' a'xni'ca' nakaksa, napekxtūko'ka'līmin. ");
INSERT INTO tooNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Lā' a'xni'ca' nachā'mpala na ixchic, nacāmākēstoka ixamigos lā' a'ntīn tahui'lāna' pajtzu ixchic. Lā' nacāhuani: “Caquilātā'pāxuhuáuj chuhua'j como ickaksli quimborrego a'ntū ixtza'nkānī't”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iccāhuaniyāni' que chu a'cxtim a'nan más tapāxuhuān nac a'kapūn ixpālacata kalhatin a'ntī xtāpalīnī't ixtapāstacna' que por ixpālacata noventa y nueve a'ntī tapuhuan que tzeyā tachi'xcuhuī't lā' chuntza' tū' ta'u'cxca'tzī que maclacasqui'n nataxtāpalī ixtapāstacna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Lā' Jesús cāhuanipā: ―Lā' palh kalhatin puscāt ka'lhī lakacāuj tumīn lā' palh natza'nkā lakatin, namāquilhtī ixpūmaksko lā' napa'lhnana'n lā' xa'nca naputza hasta a'nlhā nakaksa. ");
INSERT INTO tooNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Lā' a'xni'ca' nakaksa, nacāmākēstoka ixamigas lā' a'ntī tahui'lāna' pajtzu ixchic, lā' nacāhuani: “Caquilātā'pāxuhuáuj como ickakslitza' huan tumīn a'ntū ixtza'nkānī't”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iccāhuaniyāni' que chu a'cxtim natapāxuhua huan ángeles a'xni'ca' naxtāpalī ixtapāstacna' kalhatin a'ntī laclē'n. ");
INSERT INTO tooNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nā Jesús hualh: ―Kalhatin chi'xcu' ixka'lhī kalhatu' ixo'kxa'n. ");
INSERT INTO tooNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lā' xastancu huanilh ixtāta': “Tāta', caquima'xqui' huan herencia a'ntū quintapa'ksīni'”. Lā' huan xatāta' cāmālacpitzini'lh ixherenciaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Lā' tū' lej makān huan xastancu mākēstokkō'lh ixmaclacasqui' lā' a'lh makat ā'lacatin cā'lacchicni'. Lā' a'ntza' pāxcat līlakō'lh ixtumīn. ");
INSERT INTO tooNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","’Lā' a'xni'ca' ixmakasputkō'nī'ttza' ixtumīn, milh lakatin tatzi'ncsta nac huanmā' cā'lacchicni' lā' xla' tzuculh pātzi'ncsa. ");
INSERT INTO tooNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Lā' tuncan a'lh putza a'nlhā namakscuja. Kalhatin chi'xcu' xala' huan cā'lacchicni' macā'lh para nacāmaktaka'lha pa'xni'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Lā' tihua'cu'tulh a'ntū ixcāmāhuī'mā' huan pa'xni', pero nīn tintī' ixmaxquī' a'ntū nahua'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Lā' tuncan tzuculh cuenta tlahua lā' pāstacli: “Lhān kalhalā't tasācua' na ixchic quintāta' tū' tahuā'yamā'na lā' cā'a'katāxtūni' lā' quit ictzi'ncsnīmā' huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Na'iclaka'mpala quintāta' lā' na'icuani: “Tāta', ictlahuani'ni' a'ntūn tū' tzey lā' nā ictlahuanī't a'ntūn tū' tzey na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tū'tza' minī'ni' naquihuani'ya' palh quit mi'o'kxa'. Caquintlahua' hua'chi kalhatin de mintasācua'nī'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Lā' tuncan quilhtāyalh huan tej para nalaka'n ixtāta'. ’Lā' a'xni'ca' makatcus ixa'mā'cha' de na ixchic, laktzī'lh lā' lakapasli huan ixtāta' lā' lakalhu'malh. Tatu'jnu' laka'lh lakapāxtoka ixo'kxa' lā' a'kxko'ka'lh lā' mu'sulh. ");
INSERT INTO tooNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Lā' tuncan huan ixo'kxa' huanilh: “Tāta', ictlahuani'ni' a'ntūn tū' tzey, lā' ictlahuanī't a'ntūn tū' tzey na ixlacapūn Dios. Tū'tza' minī'ni' naquihuani'ya' palh quit mi'o'kxa'”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Pero huan xatāta' cāhuanilh ixtasācua'nī'n: “Calīta'ntit pūtin xasāsti' lu'xu' lā' camālhakē'tit huā' qui'o'kxa'. Lā' camacahui'lī'tit lakatin macatzātzāt lā' camātūnū'tit ī'zapatos. ");
INSERT INTO tooNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Calīta'ntit huan huācax a'ntū xako'ntīntza' lā' camaknī'tit. Natlahuayāuj lakatin cā'tani' lā' nahuā'yanāuj ");
INSERT INTO tooNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","porque hua'chilh xanīntza' ixuanī't huā'mā' qui'o'kxa' lā' lakahuanchokonī't. Ixtza'nkānī'ttza' lā' ickakschokolh”. Lā' tatzuculh tapāxuhua. ");
INSERT INTO tooNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Lā' huanmā' chi'chini' huan xapuxcu' ixo'kxa' ixa'nī't scuja. Lā' a'xni'ca' ixtaspi'tmā' para na ixchic, kaxmatli xamúsica huan baile. ");
INSERT INTO tooNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lā' tuncan ta'sani'lh kalhatin tasācua' lā' kalhasqui'nīlh tuchū lamā'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Lā' xla' kalhtīlh: “Mat milhtza' mistancu. Lā' mintāta' māmaknīnīni'lh huan xako'ntīn huācax como tzey chilh lā' tū' ī'tza'ca'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Pero huan xapuxcu' lej a'kchā'lh lā' tū' ixtanūcu'tun. Lā' ixtāta' taxtulh para nahuani catanūlh. ");
INSERT INTO tooNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Lā' xla' huanilh ixtāta': “Hui'x ca'tzīya' lhūhua'tza' cā'ta ictā'scujnī'ta'ni' lā' pō'ktu ica'kahuāna'ni'nī'ta'ni'. Lā' tū' maktin quimaxquī'nī'ta' nīn chu lakatin ti'na'j chivo para na'iccālītā'pāxuhua qui'amigos. ");
INSERT INTO tooNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero chuhua'j como chilh huā'mā' mi'o'kxa' a'ntī pāxcat līlakō'lh mintumīn con huan puscan a'ntīn tū' tzey lā' hui'x māmaknīnīni'nī'ta' huan xako'ntīn huācax”. ");
INSERT INTO tooNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Lā' tuncan huan xatāta' huanilh: “Hui'x qui'o'kxa' lā' hui'x pō'ktu quintā'lahui'la', lā' ixlīhuāk a'ntū icka'lhī huāk mila'. ");
INSERT INTO tooNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero chuhua'j līmakuan natlahuayāuj cā'tani' para napāxuhuayāuj como mistancu hua'chilh xanīntza' ixuanī't lā' lakahuanchokonī'ttza'. Hua'chilh ixtza'nkānī'ttza' lā' chuhua'j ickakspā”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nā Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Ixuī' kalhatin patrón; lej rico ixuanī't. Lā' ixka'lhī kalhatin xapuxcu' ixtasācua'. Lā' lakminca huanican que huanmā' xapuxcu' tasācua' ixpāxcatlīlani'mā' ixtumīn. ");
INSERT INTO tooNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Lā' tuncan huan ixpatrón māta'sīlh lā' huanilh: “¿Tuchūn chū'tza' huā' quihuanica por mimpālacata? Caquimāsu'ni' a'ntū iclīmāmacū'nī'ta'ni' como tū'tza' quintitā'scujti hua'chi xapuxcu' tasācua'”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Lā' huan xapuxcu' tasācua' tahui'lalh pāstacna'n: “¿Tuchū na'ictlahua chuhua'j como quimpatrón quimaklhtīlh quintascujūt? Tū' tli'hui'qui quit para na'icscuja cā'tacuxtu, lā' icmāxana'n na'icsqui'nīhuā'yan. ");
INSERT INTO tooNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Quit icka'lhī quimpātunca'tzi lā' chuntza' tzē na'icchā'n nac lakatin chic para na'icuā'yan a'xni'ca' tū' na'icka'lhī quintascujūt”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Lā' chuntza' kalhatunu' cāmāta'sīlh a'ntī ixtalaclē'ni' ixpatrón. A'ntī chā'lh pū'la kalhasqui'nīlh: “¿Lhānchulā' laclīpini'ya' quimpatrón?” ");
INSERT INTO tooNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Lā' xla' kalhtīlh: “Iclaclē'ni' lakatin ciento barriles de aceite”. Lā' tuncan xapuxcu' tasācua' huanilh: “A' mā' minca'psnat. Tuncan catahui'la' lā' catlahua'pala' ā'kalhtin por xmān cincuenta”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Lā' ā'calīstān kalhasqui'nīlh ā'kalhatin: “¿Chu hui'x, lhānchulā' laclīpini'ya'?” Lā' huanilh: “Lakatin ciento cuartillo de trigo”. Lā' tuncan huanilh: “A'mā' minca'psnat. Catlahua'pala' ā'kalhtin xmān por ochenta”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Lā' huan patrón puhualh que huan xapuxcu' tasācua' skalalh lalh a'nchī tlahualh. Chuntza' a'ntī xalanī'n nac huā'mā' quilhtamacuj lakskalalhna' para natatlahua ixnegocioca'n. Más skalalhna' xlaca'n que a'ntīn takalhalaka'ī' ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Quit iccāhuaniyāni': Nacālīmaktāyayā'tit a'ntīn tamaclacasqui'n con mintumīnca'n. Lā' chuntza' a'xni'ca' nanīyā'tit lā' tūla catilīpintit mintumīnca'n, nacātamānūyāni' a'nlhā pō'ktu nalatahui'la'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’A'ntī xa'nca namaktaka'lha macsti'na'j a'ntū līmāmacū'can, nā xa'nca namaktaka'lha lhūhua' palh nalīmāmacū'can. A'ntīn tū' xa'nca natlōkentaxtū ixlītlōt a'yuj tū' lej tasqui'nī, xla' tū' xa'nca natlōkentaxtū a'ntū más tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Palh tūla cātalīmāmacū'yāni' a'ntū xala' nac quilhtamacuj, ¿chichū nacātalīmāmacū'yāni' a'ntū ixla' Dios? ");
INSERT INTO tooNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Lā' palh tū' maktaka'lhā'tit a'ntū cātamāsācua'nīyāni' hui'xina'n, tū' caticātamaxquī'n a'ntū milaca'n nala. ");
INSERT INTO tooNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Nīn kalhatin tasācua' tzē natā'scuja chu a'cxtim kalhatu' ixpatrón porque napāxquī' kalhatin lā' tū' nalaktzī'ncu'tun ā'kalhatin. Lā' na'a'kahuāna'ni' kalhatin lā' nalakmaka'n ā'kalhatin. Lā' nā chuntza' hui'x tūla nalīpāhua'na' Dios palh nalīpāhua'na' mintumīn. ");
INSERT INTO tooNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Huan fariseosnu' a'ntī ixtapāxquī' ixtumīnca'n ixtakaxmatmā'na ixlīhuāk huā'mā' lā' ixtalīlītzī'mā'na Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Lā' tuncan Jesús cāhuanilh: ―Hui'xina'n lacasqui'nā'tit que huan tachi'xcuhuī't natapuhuan que lej tzey hui'xina'n, pero Dios cālakapasni'yāni' mi'a'clhcunucca'n. Lā' a'yuj cā'a'kxokoyā'tit chi'xcuhuī'n chuntza' lā' xlaca'n cāta'a'cnīni'ni'yāni', pero Dios lakmaka'n a'ntū huan tachi'xcuhuī't tapuhuan que lej ka'lhī ixtapalh. ");
INSERT INTO tooNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Lā' Jesús cāhuanipā: ―Ixa'nan huan ixley Moisés hasta a'xni'ca' ixlatlā'huan Juan huan Mā'kpaxīni', lā' chu a'cxtim a'ntū tamāsu'yulh a'cta'sana'nī'n. Chuhua'j talīchihuīna'n huan xatzey tachihuīn a'nchī Dios māpa'ksīni'n. Lā' ixlīhuāk talīhui'lī natatanū. ");
INSERT INTO tooNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Jicslīhua' namāsputūcan a'kapūn lā' ti'ya't, pero más jicslīhua' naxtāpalīcan ixtachihuīn Dios. Tū' catixtāpalīca nīn macsti'na'j. ");
INSERT INTO tooNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Lā' Jesús cāhuanipā: ―Palh kalhatin chi'xcu' namakxteka ixpuscāt lā' natā'tapuchahua ā'kalhatin, xla' makpuscātīni'n na ixlacapūn Dios. Lā' a'ntīn tā'tapūchahua kalhatin puscāt a'ntī makxtekcanī'ttza', nā xla' makpuscātīni'n na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Lā' Jesús cāhuanipā: ―Ixuī' kalhatin chi'xcu'; lej rico ixuanī't. Lā' ixlhakā' ixlu'xu' xalacuan. Lā' lakalīyān ixtlahua cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nā ixuī' kalhatin chi'xcu'; ixtacuīni' Lázaro. Lā' lhūhua' ixka'lhī ixmactzi'tzi'. Lā' ixtahui'la ī'squi'nīhuā'yan na ixtanquilhni' huan rico. ");
INSERT INTO tooNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lā' xla' ixlēka'scu'tun huan xalacpītzin pāntzi a'ntū ixyuja de na ixmesa huan rico. Lā' huan chichi' ī'snakani' ixtzi'tzi'. ");
INSERT INTO tooNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Lā' milh lakatin chi'chini' huan Lázaro nīlh, lā' huan ángeles talē'lh nac a'kapūn. Nā a'ntza' ixuī' Abraham. Nā huan rico nīlh lā' mā'cnūca. ");
INSERT INTO tooNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Lā' a'xni'ca' ixpātīni'mā' huan rico nac pūpātīn, talacayāhualh lā' cālaktzī'lh Abraham lā' Lázaro ixtu'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Lā' tuncan ta'salh lā' hualh: “Quintāta' Abraham, caquilakalhu'ma' lā' cama'cata' Lázaro para que camojōlh nac xcān kantin ixmakspulh lā' camāske'hui'huī'lh quisī'ma'kā't porque lej icpātīni'mā' na ixlaclhni' lamana'”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Lā' Abraham huanilh: “Qui'o'kxa', capāstacti xa'nca que hui'x lej tzey a'nī'ni'n na minquilhtamacuj lā' Lázaro tū' tzey a'nī'ni'lh. Lā' chuhua'j xla' māko'xamixīmā'ca huā'tzā' lā' hui'x pātīni'pā't a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lā' huampala a'nan lakatin ka'tla' cā'pūtatonkopūn a'ntū quincāmā'kapitziyāni'. Lā' chuntza' a'ntīn ta'a'ncu'tun a'ntza' tūlalh catita'a'lh lā' nīn xalanī'n a'ntza' tūlalh catitamilh ā'tzā'”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","’Lā' tuncan huan rico hualh: “Quintāta' Abraham, icsqui'niyāni' que cama'capi Lázaro na ixchic quintāta' ");
INSERT INTO tooNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","para nacāhuani kalhaquitzis quintā'timīn a'ntīn tahui'lāna'ncha'cus. Lā' chuntza' xlaca'n tū' catitatanūlh nac huā'mā' pūpātīn”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","’Lā' Abraham huanilh: “Xlaca'n taka'lhītza' a'ntū tzo'kli huan Moisés lā' huan profetasna'. Cuenta catatlahualh ū'tza'”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Lā' huan rico kalhtīni'lh: “Stu'ncua'. U'tza' icca'tzī pero palh ixcālaka'lh kalhatin a'ntī nīnī'ttza', ixtaxtāpalīlh ixtapāstacna'ca'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Lā' Abraham huanilh: “Palh tū' cuenta tatlahua a'ntū tzo'kli huan Moisés lā' huan profetasna', nīn tū' catitakalhlaka'ī'lh a'yuj ixcālaka'lh a'ntī lakahuanchokonī't de na ixlaclhni'ca'n nīnī'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús cāhuanilh ī'sca'txtunu'nī'n: ―Pō'ktu a'nan catūhuā a'ntū nacāmātonkopū tachi'xcuhuī't, pero xānti tala xlaca'n a'ntīn tamātonkopū ā'makapitzīn lā' tamātlahuī talaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mejor ixpixchī'hua'ca'ca lakatin chihuix lā' ixmacā'nca nac mar, lā' tū' ixmātonkopūlh nīn kalhatin a'ntī tzucumā'cus kalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cuenta catlahua'tit. ’Palh mintā'tin tlahuani'nī'ta'ni' a'ntūn tū' tzey, nahuani'ya'. Lā' palh xla' puhuan que tū' tzey a'ntū tlahualh, namāsputūnu'ni'ya'. ");
INSERT INTO tooNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Lā' namāsputūnu'ni'ya' a'yuj lakatin chi'chini' maktojon catlahualh tūn tū' tzey lā' maktojon nalakmināni' nahuaniyāni': “Tū' tzey quit, lā' tū' ā'maktin ictitlahualh”. ");
INSERT INTO tooNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Huan sca'txtunu'nī'n tahuanilh huan Jesús: ―Caquilāmaktāyauj para que ā'chulā' na'ickalhlaka'ī'yāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Lā' huan Māpa'ksīni' cāhuanilh: ―Palh ixkalhlaka'ī'tit, a'yuj macsti'na'j, ixuani'tit huanyā qui'hui': “Catatampu'lhu' lā' capit tāya'ya' nac mar”. Lā' chuntza' huan qui'hui' ixtlahualh. ");
INSERT INTO tooNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Lā' Jesús cāhuanipā: ―Palh hui'x ixka'lhi' kalhatin mintasācua' a'ntī scujnī'ttza' tintacuj lā' ixtaspi'tli na minchic, tū' catihua'ni': “Catanu', cahuā'ya'”. ");
INSERT INTO tooNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Chō'la nahuani'ya': “Cacāxtlahua' quilīhua't lā' pū'la naquimā'huī'ya' quit. A'calīstān nahuā'ya'na' hui'x”. ");
INSERT INTO tooNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","’Lā' a'xni'ca' mintasācua' natlahuakō' ixlītlōt, tū' catihua'ni' nīn pāxcatca'tzī como xla' tasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Lā' chuntza' hui'xina'n, a'xni'ca' tlahuakō'yā'tit ixlīhuāk ixtapuhuān Dios, nahuanā'tit: “Tū' maclacasqui'n naquincāhuaniyāni' pāxcatca'tzī como xmān ictlahuáuj quilītlōtca'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A'xni'ca' ixa'mā'cus nac Jerusalén, Jesús tētaxtulh lacalhūhua' cā'lacchicni' xala' nac Samaria lā' Galilea. ");
INSERT INTO tooNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","A'xni'ca' ixtapajtzūtēlhatza' lakatin cā'lacchicni', kalhacāuj chi'xcuhuī'n a'ntī ixtamasmā'na ixquinītca'n tataxtulh para natapāxtoka. Lā' makat tatāyalh xlaca'n ");
INSERT INTO tooNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","lā' lej palha' tahualh: ―¡Jesús, Mākalhtō'kē'ni', caquilālakalhu'mauj! ");
INSERT INTO tooNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Lā' a'xni'ca' Jesús cālaktzī'lh, cāhuanilh: ―Capintit cāmāsu'ni'yā'tit mimacni'ca'n huan curasna'. Lā' a'xni'ca' xlaca'n ixta'a'mā'nacus nac tej, talaktzī'lh ixmacni'ca'n que tzeytza' ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Lā' kalhatin de xlaca'n, a'xni'ca' laktzī'lh que ixtzeyanī'ttza', taspi'tli mācā'tanītēlha Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tatzokostani'lh Jesús para namaxquī' pāxcatca'tzī. Lā' huā'mā' chi'xcu' xala' nac Samaria ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Lā' tuncan Jesús hualh: ―¿Chu tū' kalhacāuj a'ntī tatzeyalh? ¿A'chī' tū' tamilh huan makapitzīn kalhana'jās? ");
INSERT INTO tooNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Chā xmān huā'mā' samaritano taspi'tli para naquimaxquī' pāxcatca'tzī? ");
INSERT INTO tooNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Lā' tuncan huanilh huan chi'xcu': ―Catāqui' lā' catlā'hua'. Tzeyanī'ta' como kalhalaka'ī'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lā' huan fariseosnu' takalhasqui'nīlh Jesús: ―¿Lhachūnīn nala que nacāmāpa'ksīkō' Dios tachi'xcuhuī't? Lā' xla' cākalhtīlh: ―A'nchī Dios cāmāpa'ksīkō', tū' tasu'yu. ");
INSERT INTO tooNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tūla catihuanca: “A'huī”, o “A'hui'lacha'”. Ixlīmāpa'ksīn Dios huī'tza' na ixa'clhcunucca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Lā' tuncan cāhuanilh ī'sca'txtunu'nī'n: ―Namin lakatin chi'chini' a'xni'ca' hui'xina'n lej nalaktzī'ncu'tunā'tit a'nchī namāpa'ksīni'n huan Chi'xcu' xala' Tālhmā'n. Nalaktzī'ncu'tunā'tit a'yuj xmān lakatin chi'chini'. Lā' tū' catilaktzī'ntit. ");
INSERT INTO tooNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Lā' nacātahuaniyāni': “A'huī'”, o “A'hui'lacha'”. Pero tū' tipinā'tit lā' tū' tistālani'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Hua'chi tasu'yu lakatin makli'pni' a'nchī palaj xkaka nac a'kapūn, chuntza' nala a'xni'ca' namin quilacchi'chini' lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pū'la lej na'icpātīni'n lā' naquintalakmaka'n xalanī'n huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Lā' hua'chi pātle'kelh a'xni'ca' ixuī'cus Noé, nā chuntza' nala a'xni'ca' namin quilacchi'chini' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ixtahuā'yan lā' ixtatapūchahua lā' ixtamāstā'mā'na ixtzu'ma'jātca'n para natatapūchahua hasta a'xni'ca' huan chi'chini' a'ntū pūtanūlh Noé nac barco. Lā' huan lakuat milh lā' tanīkō'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nā chuntza' pātle'kelh a'xni'ca' ixuī'cus Lot; ixtahuā'yamā'na lā' ixtako'tnumā'na; ixtatamāhuana'mā'na lā' ixtastā'namā'na; ixtacha'nāna'n lā' ixtatlahua ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lā' a'xni'ca' Lot taxtulh de huan cā'lacchicni' Sodoma, yujli macscut lā' azufre de nac a'kapūn lā' cāmaknīkō'lh ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","’Hua'chi a'xni'ca' ixtahui'lāna'cus Lot lā' Noé, chuntza' nala a'xni'ca' na'iccātasu'ni'yāni' quit huan Chi'xcu' xala' Tālhmā'n. Tachi'xcuhuī't tū' tapuhuan palh palaj na'icmimpala. ");
INSERT INTO tooNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’A'xni'ca' namin huā'mā' chi'chini', a'ntī huī' kēpūn lā' ka'lhī ixmaclacasqui' na ixchakān ixchic, tū' catitanūlh para namāxtu. Lā' a'ntī scujmā'cha' na ixā'tacuxtu, tū' catitaspi'tli na ixchic para natē catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Capāstactit a'ntū pātle'keni'lh ixpuscāt Lot. ");
INSERT INTO tooNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A'ntī māpūtaxtūcu'tun ixlīca'tzīn, tū' catipāstacli a'ntū a'nan nac cā'quilhtamacuj. Lā' a'ntī xmān pāstaca a'ntū a'nan nac cā'quilhtamacuj, xla' tū' catipūtaxtulh. ");
INSERT INTO tooNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Iccāhuaniyāni' que huanmā' tzī'sa kalhatu' natalhtata nac lakatin xti'cat, lā' Dios nalē'n kalhatin lā' namāchoko kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Lā' kalhatu' puscan natasquiti pajatzu, lā' Dios nalē'n kalhatin lā' namāchoko kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Lā' kalhatu' chi'xcuhuī'n natascuja ixtu'ca'n nac cā'tacuxtu, lā' Dios nalē'n kalhatin lā' namāchoko kalhatin ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Lā' a'xni'ca' takaxmatli huā'mā'na tachihuīn, huan ī'sca'txtunu'nī'n takalhasqui'nīlh: ―Māpa'ksīni', lā' ¿lhachūnīn napātle'ke huā'mā'? Lā' xla' cākalhtīlh: ―Chuxalhā napātle'ke, hua'chi huan chū'ni' tatakēstoka chuxalhā a'nan ixlīhua'tca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús cāhuanilh catūhuā a'ntū lītalacastuca para nacāmāsu'ni' que lakalīyān natakalhtō'ka' lā' tū' maktin catilakachā'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Cāhuanilh: ―Ixuī' nac lakatin cā'lacchicni' kalhatin juez. Tū' ixa'cnīni'ni' Dios lā' nīn cuenta ixcātlahua a'ntī ixtaputza justicia. ");
INSERT INTO tooNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chu a'ntza' huanmā' cā'lacchicni' ixuī' kalhatin lakapūt. Lakalīyān ixa'n laktzī'n huan juez para natlahuani'can lakatin justicia ixpālacata ixtā'ca'tza. ");
INSERT INTO tooNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lā' ixlīmaklhūhua'tza' huan juez tū'tza' tlahuani'cu'tulh justicia. Lā' ā'calīstān puhualh: “A'yuj tū' ica'cnīni'ni' Dios lā' tū' cuenta ictlahua a'yuj taputza justicia, ");
INSERT INTO tooNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero como huā'mā' lakapūt quimājiclhuī'lhtza', na'ictlahuani' justicia, para que tū'tza' camilh quimājiclhuī'”. ");
INSERT INTO tooNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lā' huan Māpa'ksīni' Jesús hualh: ―Cuenta catlahua'tit a'ntū tlahualh huan juez a'yuj tū' tzey ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Lā' ā'chulā' nacālīmaktāya Dios xlaca'n a'ntī cālacsacnī't a'ntī lakalīyān lā' tintascac tasqui'ni'. Lā' ¿chu natakoxī nacāmaktāya? ");
INSERT INTO tooNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iccāhuaniyāni' que palaj nacālīmaktāyayāni'. Lā' quit huan Chi'xcu' xala' Tālhmā'n. Lā' a'xni'ca' na'icmimpala, ¿chā na'ickaksa nac huā'mā' quilhtamacuj a'ntīn takalhlaka'ī' lā' tasqui'ni'mā'na Dios lakalīyān? ");
INSERT INTO tooNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús cāhuanipā catūhuā a'ntū lītalacastuca para a'ntī tapuhuan que xlaca'n xalactzey lā' talakmaka'n ā'makapitzīn. Hualh: ");
INSERT INTO tooNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Kalhatu' chi'xcuhuī'n ta'a'lh nac lītokpān para natakalhtō'ka'. Lā' kalhatin de xlaca'n fariseo ixuanī't, lā' ā'kalhatin mātā'jīni' de impuestos ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Lā' huan fariseo tāyalh kalhtō'ka' chuntza': “Dios, icmaxquī'yāni' pāxcatca'tzī porque quit tū' hua'chi ā'makapitzīn. Tū' icka'lhāna'nī't. Tū' ictampi'lhīni'nī't. Lā' quit tū' icmakpuscātīni'n. Lā' nīn quit hua'chi huā'mā' mātā'jīni' de impuestos. ");
INSERT INTO tooNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Quit tū' icuā'yan lakatu' chi'chini' nac lakatin semana, lā' de a'ntū icka'lhī icmāstā' ixlīhuāk a'ntū maclacasqui'n para quilē'ksajna'”. ");
INSERT INTO tooNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Lā' xtunc hualh huan mātā'jīni'. Xla' makat tāyalh. Lā' tū' ixtalacayāhuacu'tun, nīn ixtaquilhpūqui pero ixcu'xatucscan lā' ixuan: “¡Dios, caquilakalhu'ma' porque quit tū' tzey!” ");
INSERT INTO tooNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Lā' iccāhuaniyāni' que huā'mā' mātā'jīni' xalacuan tasu'yu na ixlacapūn Dios lā' huan fariseo tū'. Lā' chuntza' a'ntī ka'tla'jca'tzī, xla' namāmāxanī'can. Lā' a'ntī tū' ka'tla'jca'tzī, ū'tza' na'a'cnīni'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nā cālīmini'ca camana' Jesús para que ixcā'a'cpūxa'malh. Lā' a'xni'ca' talaktzī'lh ī'sca'txtunu'nī'n, talacaquilhnīlh a'ntī ixtalīmin. ");
INSERT INTO tooNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Lā' Jesús cāmāta'sīlh huan camana' lā' cāhuanilh ī'sca'txtunu'nī'n: ―Cacāmakxtektit huan camana' caquintalakmilh lā' tū' cacāmāmakchuyī'tit como huan a'ntī natatapa'ksī con Dios a'nlhā māpa'ksīni'n, xlaca'n a'ntī naquintalīpāhuan hua'chi huan tamā'na camana'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ixlīstu'ncua' iccāhuaniyāni' que a'ntīn tū' takalhlaka'ī' ixtachihuīn Dios hua'chi lakska'tā'n takalhlaka'ī', tū' maktin catitatanūlh a'nlhā māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kalhatin de huan xanapuxcu'nu' kalhasqui'nīlh Jesús: ―Tzeyā Mākalhtō'kē'ni' hui'x. ¿Tuchū na'ictlahua para na'icka'lhī quinquilhtamacuj para pō'ktu? ");
INSERT INTO tooNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Lā' Jesús huanilh: ―¿A'chī' quihuani'ya' palh tzey quit? Xmān kalhatin a'ntī xatzey lā' ū'tza' māni' a'ntī Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Hui'x ca'tzīya' ixlīmāpa'ksīn Dios a'ntū huan chuntza: Tū' timakpuscātīni'na'. Tū' timaknīni'na'. Tū' tika'lhāna'na'. Tū' tilīchi'huīna'na' nīn kalhatin. Cacā'a'kahuāna'ni' mintāta' lā' mintzī't. ");
INSERT INTO tooNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Lā' huan chi'xcu' kalhtīlh: ―Huāk huā' tamā'na' ictlōkentaxtūkō'nī'ttza' desde quilīti'na'j. ");
INSERT INTO tooNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Lā' a'xni'ca' kaxmatli huā'mā', Jesús huanilh: ―Xmān lakatin catūhuā tisputni'yāni' a'ntū natlahua'ya'. Caquīstā'kō'j huāk a'ntū ka'lhī'ya' lā' nacāmālacpitzini'ya' huan tumīn huan pobresni' lā' naka'lhī'ya' a'nchī rico nalīla'ya' nac a'kapūn. Lā' ā'calīstān caquintā'pi, a'yuj napātīni'na'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lā' a'xni'ca' huan chi'xcu' kaxmatli huā'mā' tachihuīn, lej līlakaputzalh como lej rico ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Lā' a'xni'ca' Jesús laktzī'lh a'nchī lej ixlakaputza, huanilh: ―Lej jicslīhua' natatapa'ksī con Dios xlaca'n a'ntī lej ricosnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tū' lej jicslīhua' natanū lakatin camello na ixtani' līxtokon. Más jicslīhua' natanū kalhatin rico a'nlhā māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lā' a'ntīn takaxmatli huā'mā' tahualh: ―Lā' ¿tichūn tzē māpūtaxtūcan? ");
INSERT INTO tooNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Lā' Jesús cāhuanilh: ―Huan chi'xcuhuī'n tūlalh catitatlahualh nīn tuntū' para natalīpūtaxtu; xmān Dios tzē nacāmāpūtaxtū. ");
INSERT INTO tooNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Lā' Pedro huanilh: ―Quina'n icmakxtekkō'uj ixlīhuāk lā' iccāstālani'mā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Lā' tuncan Jesús cākalhtīlh: ―Stu'ncua a'ntū iccāhuaniyāni'. A'nan a'ntī nata'a'kxtekui'lī ixchicca'n o ixtāta'ca'n lā' ixtzī'tca'n o ixtā'timīnca'n o ixpuscātca'n o ixcamana'ca'n para nata'a'kahuāna'ni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Xlaca'n ā'chulā' nataka'lhī nac huā'mā' quilhtamacuj, lā' nataka'lhī ixquilhtamacujca'n para pō'ktu a'nlhā Dios māpa'ksīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús cāmāta'sīlh ī'sca'txtunu'nī'n lā' cāhuanilh: ―A'mā'nauj nac Jerusalén a'nlhā natlōkentaxtūkō'can ixlīhuāk a'ntū talītzo'kli huan profetasna' por quimpālacata quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lā' naquimacamāstā'can con a'ntīn tū' israelitas lā' naquintalakapala lā' naquintalakmaka'n lā' naquintalakachojmanī. ");
INSERT INTO tooNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Naquintakēsnoka lā' ā'calīstān naquintamaknī. Lā' ixlīlakatu'tun chi'chini' na'iclakahuanchoko. ");
INSERT INTO tooNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Lā' huan ī'sca'txtunu'nī'n nīn tuntū' tamāchekxīlh de huā'mā', nīn ixtaca'tzī a'ntū ixlīchihuīna'mā' porque hua'chilh xatatzē'kni' a'ntū ixcāhuanimā'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","A'xni'ca' Jesús ixchā'mā'tza' huan cā'lacchicni' Jericó, ixuī' kalhatin lakatzī'n na ixpāxtūn tej. I'squi'nīhuā'yahuī'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lā' a'xni'ca' ixkaxmata tētaxtumā'ca, ixkalhasqui'nīni'n tichū ixpātle'kemā'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Huanica que Jesús xala' nac Nazaret ixpātle'kemā'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Lā' tuncan ta'salh lā' hualh: ―¡Jesús! ¡Hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj! ¡Caquilakalhu'ma'! ");
INSERT INTO tooNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A'ntī ixtapū'lani'nī't Jesús taquilhnīlh huan lakatzī'n para que ixquilhca'cslalh, pero xla' ā'chulā' ta'salh lā' hualh: ―¡Hui'x ixtā'nat David a'ntī xa'icka'lhīmā'nauj! ¡Caquilakalhu'ma'! ");
INSERT INTO tooNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Lā' tuncan Jesús tāyalh lā' hualh calīmini'ca. Lā' a'xni'ca' pajtzu ixlakayātza', kalhasqui'nīlh: ");
INSERT INTO tooNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tuchū lacasqui'na' que na'ictlahuani'yāni'? Lā' huan lakatzī'n kalhtīlh: ―Māpa'ksīni', caquimā'lacahuā'nī'pala'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Lā' Jesús huanilh: ―¡Calacahuā'na'! Tzeyanī'ta' como kalhlaka'ī'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lā' tuncan huā'mā' ka'tlā'tus lacahuāna'lh huan lakatzī'n. Lā' stālani'lh Jesús, mācā'tanītēlha Dios. Lā' ixlīhuākca'n tachi'xcuhuī't talaktzī'lh huā'mā' lā' nā xlaca'n tamācā'tanīlh Dios ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Ixuī' kalhatin rico; ixtacuīni' Zaqueo. Lā' xapuxcu' ixuanī't de huan mātā'jīni'nī'n impuestos. Lā' a'xni'ca' Jesús ixtētaxtumā' nac Jericó, a'ntza' ixuī' Zaqueo. ");
INSERT INTO tooNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Huā'mā' Zaqueo ixlaktzī'ncu'tun Jesús para que ixlakapasli pero tūla ixlaktzī'n Jesús como lej a'ctzina'j chi'xcu' ixuanī't lā' lhūhua' tachi'xcuhuī't ixa'nan. ");
INSERT INTO tooNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lā' tuncan tatu'jnunpū'lalh a'nlhā natētaxtu Jesús lā' tō'ca'lh nac a'katin ka'tla' qui'hui' a'ntū huanican sicómoro para que tzē nalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lā' a'xni'ca' Jesús ixpātle'kemā' a'ntza', talacayāhualh lā' huanilh Zaqueo: ―Lacapalh cayujti porque chuhua'j na'ictachoko na minchic. ");
INSERT INTO tooNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Lā' Zaqueo lacapalh yujli lā' līpāxūj lē'lh Jesús na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Lā' a'xni'ca' talaktzī'lh huā'mā', ixlīhuākca'n tatzuculh talīchihuīna'n lā' talāhuanilh que Jesús ixa'nī't tachoko na ixchic a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Lā' ā'calīstān Zaqueo tāyalh lā' huanilh Jesús: ―Chuhua'j, na'iccāmaxquī' i'tāt a'ntū icka'lhī huan pobresni'. Lā' palh xa'iccā'a'kxokomaklhtīnī't ā'makapitzīn, na'iccāmaxquī' maktā'ti' ixlaktapalh. ");
INSERT INTO tooNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Lā' Jesús huanilh: ―Chuhua'j pūtaxtunī'ta' porque kalhlaka'ī'nī'ta' a'nchī Abraham kalhlaka'ī'lh. Nā xalanī'n na minchic tapūtaxtunī't. ");
INSERT INTO tooNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Lā' quit huan Chi'xcu' xala' Tālhmā'n icmilh iccāputza a'ntīn tū' takalhlaka'ī' para na'iccāmāsu'ni' a'nchī nacālīmāpūtaxtūcan. ");
INSERT INTO tooNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","A'xni'ca' ixtakaxmatmā'na a'ntū ixcāhuanimā' Jesús, xla' cāhuanilh a'ntū lītalacastuca. Como ixtatapajtzūmā'na nac Jerusalén, xlaca'n tapuhualh que palaj natasu'yu a'nchī Dios namāpa'ksīni'n nac huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Lā' tuncan Jesús cāhuanilh: ―Ixuī' kalhatin chi'xcu' lā' xla' tū' chu catihuāyā chi'xcu'. Lā' ixa'mā' makat nac lakatin ti'ya't a'nlhā nalīhui'līcan i'xlīrey lā' ā'calīstān nataspi'tpala. ");
INSERT INTO tooNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Lā' a'xni'ca' ixa'mā'cus, cāmākextimīlh kalhacāuj ixtasācua' lā' a'cxtim cāmaxquī'lh lhūhua' tumīn chā'tunu' de xlaca'n lā' cāhuanilh: “Camāscujū'tit huā' tumīn hasta a'xni'ca' na'icmimpala”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Lā' huan tachi'xcuhuī't xalanī'n ixā'lacchicni' tū' ixtalaktzī'ncu'tun lā' cāmāstālīca lacscujnī'n para natahuan: “Tū' iclacasqui'nāuj huā'mā' chi'xcu' hua'chi rey”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero a'yuj, līhui'līca ixlīrey lā' chuntza' taspi'tli na ixti'ya't. ’Lā' a'xni'ca' chilh, cāmāta'satīnīni'lh huan tasācua' a'ntī ixcāmaxquī'nī't tumīn. Ixca'tzīcu'tun a'nchī ixtatlajanī'ttza' chā'tunu' de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A'ntī xapū'la a'lh lā' hualh: “Mintumīn tlajanī't makcāuj”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Huan rey kalhtīlh: “Lej tzey tasācua' hui'x, como xa'nca mā'scu'ju' a'yuj macstina'j tumīn. Na'icui'līyāni' milīgobernador de lakacāuj cā'lacchicni'”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","’Lā' chā'mpā kalhatin lā' hualh: “Mintumīn tlajanī't makquitzis”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Lā' nā kalhtīlh: “Hui'x nala'ya' milīgobernador de lakaquitzis cā'lacchicni'”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Lā' tuncan kalhatin chā'mpā lā' hualh: “A' mā' mintumīn. Icmāquī'lh nac lakatin pāyu ");
INSERT INTO tooNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","porque icjicua'ni'ni' como hui'x līpalha' milīmāpa'ksīn. Hui'x tē'ya' a'ntūn tū' hui'līnī'ta' lā' makalana'na' a'nlhā tū' cha'nāna'nī'ta' hui'x”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Lā' tuncan huan rey hualh: “Hui'x tū' tzey tasācua'. Mismo mintachihuīn lē'ksa'nīni'nāni'. Hui'x puhua'na' palh quit lej līpalha' icmāpa'ksīni'n lā' ictē a'ntūn tū' quit icui'līnī't, lā' icmakalana'n a'nlhā tū' quit iccha'nāna'nī't. ");
INSERT INTO tooNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Lā' ¿a'chī' tū' hui'li' nac banco quintumīn? Chuntza' xa'icmaklhtīni'lh quintumīn con xaska'ta' a'xni'ca' xa'ictaspi'tpā na quinchic”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’Lā' cāhuanilh a'ntī ixtayāna': “Camaklhtītit ixtumīn lā' camaxquī'tit a'ntī tlajanī't makcāuj”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Lā' tahuanilh: “Pero xla' ka'lhītza' makcāuj”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Lā' huan rey kalhtīlh: “Iccāhuaniyāni' más namaxquī'can a'ntī ka'lhī, pero a'ntīn tū' lhūhua' ka'lhī namaklhtīkō'can a'ntū ka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Lā' quintā'ca'tzanī'n a'ntīn tū' quintalacasqui'n hua'chi rey, caquilī'ta'ni'tit lā' cacāmaknī'tit na quilacapūn”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","A'xni'ca' huankō'lh huā'mā', Jesús tēlh ixtej para nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Lā' ixtapajtzūmā'natza' nac huan cā'lacchicni' a'nlhā huanican Betfagé lā' a'nlhā huanican Betania. A'ntza' pajtzu huan o'kspū'n a'nlhā huanican Olivos. Lā' Jesús cāmāpū'līlh kalhatu' ī'sca'txtunu'nī'n ");
INSERT INTO tooNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","lā' cāhuanilh: ―Capintit huan nac cā'lacchicni' a'ntūn tasu'yu na milacapūnca'n. Lā' a'xni'ca' nachipinā'tit, nalaktzī'nā'tit lakatin xaska'ta' burro a'ntū chī'yāhuacanī't. Nīn tintī'na'j kētō'la. Caxcutit lā' caquilālīmini'uj huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Lā' palh catīhuā nacākalhasqui'nīyāni': “¿A'chī' xcutpā'na'ntit huan burrito?” hui'xina'n nakalhtīni'nā'tit: “Huan Māpa'ksīni' maclacasqui'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Lā' huan sca'txtunu'nī'n ta'a'lh lā' takaksli hua'chi huan Māpa'ksīni' ixcāhuaninī't. ");
INSERT INTO tooNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Lā' a'xni'ca'tza' ixtaxcutmā'na huan burro, huan ixtēcu' cāhuanilh: ―¿A'chī' xcutpā'na'ntit huan burro? ");
INSERT INTO tooNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Lā' xlaca'n takalhtīni'lh: ―Huan Māpa'ksīni' maclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Lē'ni'ca Jesús tuncan lā' talīkētlapalh ixlu'xu'ca'n lā' kēhui'līca Jesús huan burro. ");
INSERT INTO tooNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Lā' a'xni'ca' Jesús ixa'mā'tza' lacachuna'j, ixmāpī'ni'tēlhacan lu'xu' nac tej. ");
INSERT INTO tooNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lā' a'xni'ca' ixtatapajtzūtēlhatza' a'nlhā laktokopūcanāchi huan nac kēstīn Olivos, tatzuculh tapāxuhua ixlīhuākca'n huan a'ntīn takalhlaka'ī'lh lā' ixtastālani'tēlha. Lā' tata'salh lā' tamācā'tanīlh Dios por ixpālacata ixlīhuāk huan lē'cnīn a'ntūn talaktzī'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Lā' ixtahuan: ―¡Sicua'lanālanī't huan Rey a'ntī mimā' por ixlīmāpa'ksīn Dios! ¡Līpāxūj nac a'kapūn! ¡Ca'a'cnīni'ni'ca Dios! ");
INSERT INTO tooNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Lā' tuncan ā'makapitzīn fariseosnu' a'ntī ixtayāna' na ixlaclhni' chi'xcuhuī'n, tahualh: ―Mākalhtō'kē'ni', cacāquilhni' a'ntīn tastālani'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Lā' Jesús cākalhtīlh: ―Iccāhuaniyāni' palh huā' tamā'na nataquilhca'csla, huan chihuixni' natata'sa. ");
INSERT INTO tooNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Lā' a'xni'ca' pajtzutza' ixa'mā'cha', Jesús laktzī'lh huan cā'lacchicni' Jerusalén lā' calhualh ");
INSERT INTO tooNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","lā' hualh: ―¡Tzey ixuanī't para hui'xina'n xalanī'n nac Jerusalén palh ixmāchekxī'tit cahuā a'nchī nalīpūtaxtuyā'tit, a'yuj huā'mā' chi'chini'! Pero chuhua'j tatzē'knī't lā' tūlalh catipūtaxtutit. ");
INSERT INTO tooNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Namin lakatin quilhtamacuj a'ntūn tū' tzey. Lā' mintā'ca'tzanī'nca'n natamin natayāhua lakatin corral ixmacni' mincālacchicni'ca'n lā' nacātalīxti'li'yāni' lakachu. ");
INSERT INTO tooNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lā' nacātalīlakasno'kāni' nac ti'ya't. Nacātamaknīkō'yāni' milīhuākca'n lā' natalacpanckō' lā' tū' catimakxtekli nīn lakatin chihuix ixa'cpān huan taxaka. Chuntza' nacāpātle'keni'yāni' como tū' lakapastit Dios a'xni'ca' cālakmini' para nacāmāpūtaxtūyāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lā' tuncan Jesús tanūlh nac xaka'tla' lītokpān lā' tzuculh cātantlakaxtu huan a'ntī ixtastā'namā'na lā' ixtatamāhuana'mā'na na ixtanquilhni' huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Lā' cāhuanilh: ―Tatzo'kni' na ixtachihuīn Dios: “Quinchic xmān para pūkalhtō'ka'can”. Lā' hui'xina'n tlahuapā'na'ntit hua'chi ixchicca'n ka'lhāna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Lakalīyān Jesús ixmāsu'yumā' nac lītokpān. Lā' ixtaputzani'mā'na a'nchī natalīmaknī huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley lā' nā pūchihuīna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Lā' tū' ixtakaksni' a'nchī natalīmaknī porque ixlīhuākca'n tachi'xcuhuī't ska'lh ixtakaxmatni'. ");
INSERT INTO tooNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lakatin chi'chini' Jesús ixcāmāsca'tīmā' tachi'xcuhuī't nac lītokpān lā' ixcāmāsu'ni'mā' a'nchī tzē nalīpūtaxtucan. Lā' tachilh huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley nā xanapuxcu'nu' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Lā' tahuanilh: ―Caquilāhuaniuj: ¿Tichū ixquilhtampān cālītlahua'pā't huā' tamā'na catūhuā? ¿Tichū maxquī'ni' huā'mā' līmāpa'ksīn? ");
INSERT INTO tooNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Lā' tuncan Jesús cāhuanilh: ―Nā quit na'iccākalhasqui'nīyāni' catūhuā. Caquilākalhtīuj: ");
INSERT INTO tooNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tichū ixquilhtampān ixlīmā'kpaxīni'n Juan? ¿Ixquilhtampān Dios o ixquilhtampānca'n tachi'xuhuī't? Caquilākalhtīuj. ");
INSERT INTO tooNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Lā' xlaca'n tatzuculh talacchihuīna'n ixa'cstuca'n lā' talāhuanilh: ―¿Chichū nahuaniyāuj? Palh nahuaniyāuj que Dios māpa'ksīlh huan Juan, naquincākalhasqui'nīyāni': “Lā' ¿a'chī' tū' kalhlaka'ī'tit?” ");
INSERT INTO tooNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Lā' palh nahuaniyāuj que chi'xcuhuī'n tamāpa'ksīlh, ixlīhuākca'n huan tachi'xcuhuī't naquincātamūta'lamaknīyāni' como xlaca'n tahuan que Juan stu'ncua' ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lā' chuntza' takalhtīlh que tū' ixtaca'tzī tichū ixquilhtampān Juan ixlīmā'kpaxīni'n. ");
INSERT INTO tooNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Lā' tuncan Jesús cāhuanilh: ―Nā chuntza' quit tū' icticāhuanini' tichū ixquilhtampān iclītlahua huā'mā'. ");
INSERT INTO tooNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tuncan Jesús tzuculh cātā'chihuīna'n tachi'xcuhuī't. Lā' cāhuanilh a'ntū lītalacastuca: ―Ixuī' kalhatin chi'xcu'; cha'nli ixpū'uva. Lā' ā'calīstān māsācua'nī'lh ixtasācua'nī'n lā' makān a'lh ā'lacatin. ");
INSERT INTO tooNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","’Lā' a'xni'ca' chilhtza' ixpūlani' uvas, macā'lh ixlacscujni' na ixpū'uva. A'lh cāsqui'ni' huan tasācua'nī'n catamacamaxquī'lh huan a'ntū tamakalanī't a'ntū ixla' ixtēcu' ti'ya't. Lā' xlaca'n talacnicui'līlh huan lacscujni' lā' chu chuntza' māspi'tchokoca. ");
INSERT INTO tooNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","’Lā' tuncan ixtēcu' uva macā'mpā ā'chatin lacscujni'. Nā chuntza' tlahuaca hua'chi xapū'la; lacnicui'līca lā' talakapalalh lā' chu chuntza' māspi'tchokoca. ");
INSERT INTO tooNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Lā' ixlīmaktu'tun macā'mpā ā'chā'tin. Lā' nā xla' mātakāhuī'ca lā' makatzā'laca. ");
INSERT INTO tooNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Lā' ā'calīstān huan ixtēcu' ti'ya't hualh: “¿Tuchū na'ictlahua? Na'icmacā'n qui'o'kxa' a'ntī lej icpāxquī'. A'xni'ca' nalaktzī'ncan lāsā' na'a'cnīni'ni'can”. ");
INSERT INTO tooNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero a'xni'ca' talaktzī'lh huan o'kxa', huan tasācua'nī'n talāhuanilh: “U'tza' huan a'ntī nalītachoko ixlīhuāk a'ntū ixla' ixtāta'. Camaknīuj lā' chuntza' quila'ca'n nala huan pū'uva”. ");
INSERT INTO tooNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Lā' tamāxtulh de huan nac pū'uva lā' tamaknīlh. Lā' Jesús cākalhasqui'nīlh: ―¿Chī puhua'nā'tit nacātlahua huan tamā'na a'ntīn tamaksācua'lh? ");
INSERT INTO tooNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na'a'n lā' nacāmāsputūkō' huā' tamā'na tasācua'nī'n lā' nacāmāsācua'nī huan pū'uva ā'makapitzīn xtunc tasācua'nī'n. Lā' a'xni'ca' huan tachi'xcuhuī't takaxmatli huā'mā' tachihuīn, tahualh: ―¡Nīn calacasqui'lh Dios! ");
INSERT INTO tooNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Lā' Jesús cālaktzī'lh lā' hualh: ―Lā' ¿tuchū huanicu'tun a'ntū tatzo'kni' na ixtachihuīn Dios? Chuntza' huan: Huan xakana'nī'n talakmaka'lh huan chihuix lā' māni' ū'tza' huanmā' chihuix a'ntū más tasqui'nī. ");
INSERT INTO tooNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Lā' Jesús huampā: ―A'ntīn tū' xa'nca tamāchekxī quintachihuīn, xlaca'n hua'chi a'ntīn tapū'a'kchekxlalh huan chihuix lā' tatakāhuī'lh. Lā' a'ntīn tū' takalhlaka'ī' quintachihuīn, xlaca'n hua'chi a'ntī cā'a'klhta'lalh huan ka'tla' chihuix lā' cāka'nkxli lā' tanīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Huan xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley titachi'pacu'tulh Jesús tuncan huā'mā' chi'chini' como tamāchekxīlh que xlaca'n ixtalītalacastuca hua'chi huan tasācua'nī'n nac pū'uva. Pero tū' tachi'palh porque ixtajicua'ni' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Lā' tuncan cāmacā'nca maktakalhna'nī'n a'ntī ixtatasu'yu hua'chi tzeyā chi'xcuhuī'n para natakaxmatxtu a'ntū tzē natalē'ksa'nīni'n con huan gobernador lā' chuntza' más tzey ixtalīmālacapū'lh con huan gobernador. ");
INSERT INTO tooNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","U'tza' talīkalhasqui'nīlh huā'mā': ―Mākalhtō'kē'ni', icca'tzīyāuj que a'ntū hua'na' lā' a'ntū māsu'yu'ya' ū'tza' xastu'ncua'. Lā' icca'tzīyāuj que hui'x tū' tlahua'ni'ya' cuenta a'nchī talīchihuīna'nāni' tachi'xuhuī't. Lā' hui'x chu a'cxtim cālaktzī'na' ixlīhuākca'n tachi'xcuhuī't. Lā' hui'x xa'nca māsu'yu'ya' a'nchī Dios lacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Tuchū puhua'na' ixpālacata huan a'ntū māta'jīni'n huan emperador romano? ¿Chā tzey palh na'icmāpalayāuj o tū' tzey? ");
INSERT INTO tooNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Lā' Jesús ixca'tzī que xmān ixtalīlaktzī'ncu'tun lā' cākalhasqui'nīlh: ―Lā' ¿a'chī' quilālīlaktzī'ncu'tunāuj? ");
INSERT INTO tooNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Caquilāmāsu'ni'uj huan tumīn a'ntū līmāpalacan. ¿Tichū ixlacan tasu'yu huā'tzā' nac tumīn lā' tichū ixtacuīni' tatzo'kni'? Lā' takalhtīlh: ―Ixla' huan emperador. ");
INSERT INTO tooNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Lā' tuncan cāhuanilh: ―Camaxquī'tit huan emperador a'ntū ixla' lā' camaxquī'tit Dios a'ntū ixla' Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Lā' nīn tuntū' tamakkaksli a'ntū tzē ixtalē'ksa'nīni'lh por a'ntū ixuan ixlacapūnca'n tachi'xcuhuī't. Pero talē'cnīlh a'nchī kalhtīni'lh lā' chuntza' taca'cslalh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","A'calīstān, ā'makapitzīn saduceosnu' talaka'lh Jesús. Huan saduceosnu' tahuan que tū' catilakahuanchokoca. Chuntza' tahuanilh Jesús: ");
INSERT INTO tooNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Mākalhtō'kē'ni', huan Moisés quincāmāchokoni'ni' huā'mā' tatzo'kni': Palh nanī kalhatin chi'xcu' a'ntī tapūchahuanī'ttza' lā' palh tū' ka'lhī ixcaman, maclacasqui'n que ī'stancu natā'tapūchahua huan lakapūt. Lā' huan xapū'la o'kxa' a'ntī nalacatuncuī nala ixo'kxa' huan xapuxcu' a'ntī nīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Maktin huā ixtahui'lāna' kalhatojon lītā'timīn. Huan xapuxcu' tapūchahualh lā' tū' ka'lhīlh nīn kalhatin ixcaman. Chuntza' līnīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ixlīkalhatu' tā'tapūchahualh huan lakapūt lā' chuntza' nīpā huan chi'xcu'; nīn kalhatin ixcaman māchokolh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Lā' ixlīkalhatu'tun tā'tapūchahuapā huan lakapūt lā' nā chuntza' ixlīkalhatojon lā' ixlīhuākca'n tanīlh; nīn kalhatin ixcamanca'n tamāchokolh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lā' ā'calīstān nā huan puscāt nīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lā' a'xni'ca' nalakahuanchokokō'can, ¿tichū ixla' nala huanmā' puscāt como ixkalhatojonca'n tatā'tapūchahualh? ");
INSERT INTO tooNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Lā' a'xni'ca' Jesús cākalhtīlh: ―Nac huā'mā' quilhtamacuj tapūchahuacan lā' tamāpūchahua ixtzu'ma'janca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Lā' a'ntī natalakahuanchokopala lā' natachā'n nac a'kapūn tū'tza' catitatapūchahualh. Lā' tū'tza' catitalāmāpūchahualh, ");
INSERT INTO tooNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","lā' tū'tza' maktin catitanīlh. Chuntza' natala hua'chi ixángeles Dios. Lā' natala ixcamana' Dios como talakahuanchokonī't. ");
INSERT INTO tooNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Lā' nā Moisés quincāmāpāstaquīyāni' que huan nīnī'n natalakahuanchokopala, a'xni'ca' tzo'kli ixpālacata huan pūtzina'j qui'hui' a'ntū ixlamamā'. A'ntza' tatzo'kli que huan Māpa'ksīni' ū'tza' ixDios Abraham lā' ixla' Isaac lā' ixla' Jacob. ");
INSERT INTO tooNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","U'tza' huanicu'tun que xlaca'n lakahuan a'yuj tanīlh de makāntza' lā' Dios ū'tza ixDiosca'n xalakahuan lā' tū' huan xanīnī'n. Lā' Dios cālaktzī'n ixlīhuāk talakahuan. ");
INSERT INTO tooNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Lā' tuncan ā'makapitzīn xamākalhtō'kē'ni'nī'n ley tahuanilh Jesús: ―Xa'nca kalhtīni'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Lā' tū'tza' talīhui'līlh natakalhasqui'nī catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús cāhuanilh: ―¿Chichū huancan que Cristo a'ntī Dios hui'līlh ixlīmāpūtaxtūnu' ū'tza' ixtā'nat David? ");
INSERT INTO tooNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Māni' David tzo'kli nac huan libro a'ntū huanican Salmos: Huan Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' na quimpāxtūcāna'j, ");
INSERT INTO tooNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta a'xni'ca' na'iccātlajakō' ixlīhuākca'n mintā'ca'tzanī'n”. ");
INSERT INTO tooNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Palh David līchihuīna'lh ī'xū'yātā'nat lā' māpācuhuīlh Māpa'ksīni', ū'tza' huanicu'tun xla' līhua'ca' xaka'tla' nala. ");
INSERT INTO tooNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ixlīhuākca'n tachi'xcuhuī't ixtakaxmatmā'na lā' Jesús cāhuanilh ī'sca'txtunu'nī'n: ");
INSERT INTO tooNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Catamaktaka'lhtit lā' tū' nacāta'a'kxokoyāni' huan xamākalhtō'kē'ni'nī'n ley a'ntīn tapūlatā'kchokocu'tun pūlhmā'n ixlu'xu'ca'n hua'chi a'ntī lej taca'tzī. Nā talacasqui'n que cacātā'chihuīna'nca lā' cacā'a'cnīni'ni'ca nac cā'tejen. Lā' na ixlītokpānca'n israelitas xlaca'n taputza pūtahuī'lh a'ntū tahui'lāna' calacan lā' talacasqui'n que cacā'a'cnīni'ni'ca a'nlhā tlahuacan cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Lā' xlaca'n ta'a'kxokomaklhtī ixchicca'n lakapūtnu' lā' ā'calīstān lej xlīt takalhtō'ka' a'nlhā nacālaktzī'ncan lā' chuntza' talī'a'kxokonu'n. A'chulā' natapātīni'n xlaca'n que ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ixuī'cus nac lītokpān lā' cālaktzī'lh a'nchī huan ricosnu' ixtamojō tumīn a'nlhā māquī'can huan tumīn a'ntū a'ksajcanī't Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nā laktzī'lh kalhatin lakapūt pobre. Mojōlh lakatu' ixtumīn de cobre a'ntūn tū' lej tapala. ");
INSERT INTO tooNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Lā' Jesús hualh: ―Ixlīstu'ncua' iccāhuaniyāni' que huā'mā' pobre lakapūt māstā'nī't a'ntū más ixtapalh na ixlacapūn Dios que ā'makapitzīn ");
INSERT INTO tooNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","porque huāk xlaca'n tamāstā' a'ntū cā'a'katāxtūni'nī'ttza'. Lā' xla' a'yuj tū' lhūhua' ixka'lhī, pero māstā'kō'lh a'ntū ixpūlatahui'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","A'makapitzīn ixtalīchihuīna'mā'na a'nchī ixlītzēhuanī't huan lītokpān por ixlītzēhuanī't huan chihuix lā' ā'catūhuā a'ntū ixmāstā'canī't hua'chi lē'ksajna'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Lā' tuncan Jesús cāhuanilh: ―Namin lakatin chi'chini' a'xni'ca' tū' catitachokolh nīn lakatin chihuix nac taxaka. Ixlīhuākca'n natapanckō' lā' huan taxaka nalacla. ");
INSERT INTO tooNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lā' tuncan takalhasqui'nīlh: ―Mākalhtō'kē'ni', ¿lhāchūnīn natala huā' tamā'na? ¿Chichū na'iclīca'tzīyāuj palh palaj napātle'ke? ");
INSERT INTO tooNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Lā' Jesús hualh: ―Catamaktaka'lhtit lā' tū' nacāta'a'kxokoyāni' como lhūhua' chi'xcuhuī'n natahuan palh taka'lhī quilīmāpa'ksīn. Lā' chā'tunu' natahuan: “Quit Cristo a'ntī Dios lacsacui'līlh”. Lā' natahuampala: “Chuhua'j chilhtza' huan ixlacchi'chini' Cristo lā' xla' Dios lacsacui'līlh”. Pero tū' tistālani'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Lā' nakaxpa'tā'tit a'nchī sā'nan pajtzu a'nlhā tlahuamā'ca guerra lā' nacātamāca'tzīnīyāni' a'nchīn tatā'kaquī' tachi'xcuhuī't. Tū' tijicua'nā'tit como huā'mā' pū'la napātle'ke lā' ā'calīstān nasputa huā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Lā' cāhuanipā: ―Lakatin gobierno natlajacu'tun ā'lakatin lā' kalhatin māpa'ksīni' natlajacu'tun ā'kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lā' palha' naxpipi huan ti'ya't lā' chuxalhā nala tatzi'ncsta lā' ta'jatatna'. Lā' lej lījicua' a'ntū natatasu'yunu'n nac a'kapūn lā' lej laka'tla' lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero pū'la nacātachi'payāni' hui'xina'n lā' nacātamāpātīnīyāni'. Nacātalē'nāni' nac lītokpān para natlahuacan justicia, lā' nacātamānūyāni' nac pūlāchī'n lā' nacātalē'nāni' ixlacapūnca'n reyes lā' gobernadores porque quilākalhlaka'ī'yāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Chuntza' tzē naquilālīchihuīna'nāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Calīhui'lī'tit que tū' nacāpāta'layāni' a'nchī nalītamaktāyayā'tit, ");
INSERT INTO tooNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","como quit na'iccāmāsu'ni'yāni' tachihuīn lā' na'iccāmaxquī'yāni' tapāstacna' lā' chuntza' mintā'ca'tzaca'n tū' caticātatlajani' nīn catitā'lāhua'nitit. ");
INSERT INTO tooNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Lā' hui'xina'n nacātamacamāstā'yāni' mintāta'ca'n lā' mintzī'tca'n lā' mintā'timīnca'n lā' mintalakapasni'ca'n lā' mi'amigosca'n. A'makapitzīn de hui'xina'n nacātamaknīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lā' ixlīhuākca'n tachi'xcuhuī't nacātaca'tzalaktzī'nāni' lā' xmān por quimpālacata, ");
INSERT INTO tooNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","pero tū' caticāyujni'ni' nīn kentin miya'jca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Calīhui'lī'tit natāyani'yā'tit lā' a'xni'ca' napātle'kekō', naka'lhīyā'tit minquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’A'xni'ca' nalaktzī'nā'tit Jerusalén lītamacxti'li'nī't soldados, naca'tzīyā'tit que palaj nalactlahuacan huan cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tuncan maclacasqui'n que natatzā'la hasta nac o'kspū'n xlaca'n a'ntīn tahui'lāna' nac estado de Judea. Lā' a'ntīn tahui'lāna' nac Jerusalén maclacasqui'n natataxtuyācha'. Lā' a'ntīn ta'a'nī't nac cā'tacuxtu tū' catitataspi'tli nac cā'lacchicni', ");
INSERT INTO tooNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","como huan tamā'na chi'chini' ū'tza' napūpātīni'ncan. Lā' natlōkentaxtūcan ixlīhuāk a'ntūn tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","’Lā' xānti tala huan puscan huan tamā'na chi'chini' palh tacamalanī't o palh tamātzi'quī'nincus como lhūhua' taca'tzāt na'a'nan. Lā' ixtā'kcha Dios nacāmāpātīnī huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","’Lā' a'makapitzīn natanī nac guerra lā' ā'makapitzīn xatachī'n nacālē'ncan nac xaxtunc xcānsipej. Lā' huan makatiyātī'n natalactlahua chu calhāhuā nac Jerusalén lā' natamaknī xalanī'n a'ntza' hasta a'xni'ca' Dios nahuan tū'tza' catatlahualh. ");
INSERT INTO tooNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Lā' Jesús cāhuanipā: ―Lā' tuncan na'a'nan lē'cnīn nac chi'chini' lā' nac mālhcuyu' lā' nac sta'cūn. Lā' xalanī'n huā'mā' quilhtamacuj natatamakchuyīkō' lā' nīn catitaca'tzīlh a'ntū natatlahua. Lā' nacāmakajicua'ncan a'nchī namacasā'nan huan mar. ");
INSERT INTO tooNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huan tachi'xcuhuī't nataxtacnānīkō' por ixtajicuā'tca'n a'xni'ca' natapāstaca a'ntū nacāpātle'keni' nac huā'mā' quilhtamacuj. Lā' māni' huan a'kapūn natachiqui. ");
INSERT INTO tooNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A'xni'ca'tza' naquilaktzī'ncan quit huan Chi'xcu' xala' Tālhmā'n a'nchī na'icpūmin nac poklhnu'. Lēj na'icka'lhī līmāpa'ksīn lā' tzēhuanī't na'icxkaka. ");
INSERT INTO tooNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","A'xni'ca' natzucu pātle'ke huā'mā', calīpāxuhua'tit lā' catalacayāhua'tit porque palaj napūtaxtuyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nā cāhui'līni'lh huā'mā' tamāsca'tīn: ―Calaktzī'ntit huan xaqui'hui' higo o ā'catūhuā qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A'xni'ca' tasu'yutza' lakapu'mā' huan qui'hui' a'xni'ca' naca'tzīyā'tit que tapajtzūmā'tza' a'xni'ca' lej xu'nu. ");
INSERT INTO tooNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lā' chuntza' a'xni'ca' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuaniyāni', naca'tzī'yā'tit que tapajtzūmā'tza' a'xni'ca' Dios nacāmāpa'ksīkō'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Stu'ncua' a'ntū iccāhuaniyāni'. Xlaca'n a'ntīn tahui'lāna'cus tū' catitanīkō'lh hasta a'xni'ca' tū' napātle'ke ixlīhuāk huā'mā' a'ntū iccāhuanini'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nasputa huan a'kapūn lā' nasputa huan ti'yat pero tū' maktin catisputli quintachihuīn; natlōkentaxtūkō'can. ");
INSERT INTO tooNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Cuenta catlahua'tit lā' tū' camakxtektit palha' nala mi'a'clhcunucca'n ixpālacata huan vicio lā' taka'chīn nīn ixpālacata catūhuā de huā'mā' quilhtamacuj. Palh chuntza' nala'yā'tit, chu līmaktin namin huā'mā' chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Namin hua'chi lakatin a'ktā'lh a'ntū chu līmaktin yuja. Chu a'cxtim namin huā'mā' chi'chini' para ixlīhuāk tachi'xcuhuī't nac huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Cāxni'j catahui'la'tit lā' pō'ktu nakalhasqui'nī'yā'tit Dios para que chuntza' tzē napūtaxtuyā'tit de ixlīhuāk huā' tamā'na catūhuā a'ntū napātle'ke. Lā' nakalhasqui'nī'yā'tit para que chuntza' tzē natāyayā'tit na quilacapūn quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Lā' cā'tuncuj Jesús ixmāsu'yu nac lītokpān lā' cā'tzī'sa ixa'n tachoko nac huan o'kspū'n a'nlhā huanican Olivos. ");
INSERT INTO tooNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Lā' huan tachi'xcuhuī't tzi'sāt ixta'a'n nac lītokpān para natakaxmata a'ntū Jesús ixcāhuani. ");
INSERT INTO tooNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pajtzutza' ixmimā' ixcā'tani'ca'n israelitas a'ntū huanican pascua, a'xni'ca' hua'can pāntzi a'ntūn tū' ka'lhī levadura. ");
INSERT INTO tooNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Lā' huan xanapuxcu'nu' curasna' lā' huan xamākalhtō'kē'ni'nī'n ley ixtaputzamā'na a'nchī natalīmāmaknīnīni'n Jesús. Lā' ixtajicua'ni' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lā' tuncan huan ko'ti'ti' tanūni'lh Judas a'ntī ixlītāpātu' ixtacuīni' Iscariote. Lā' xla' kalhatin de huan ixlīkalhacāujtu' sca'txtunu'nī'n ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xla' ū'tza' cālaka'lh huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' policía a'ntī ixmaktaka'lhmā' huan lītokpān. U'tza' cātā'lacchihuīna'lh a'nchī nacālīmacamaxquī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xlaca'n tapāxuhuakō'lh lā' tahuanilh palh natamaxquī' tumīn. ");
INSERT INTO tooNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Lā' Judas cākalhlaka'ī'lh lā' tzuculh putzani' a'nchī tzē nalīmacamāstā' Jesús a'xni'ca' tintī' lhūhua' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ixtzucumā'tza' huan cā'tani' a'xni'ca' ixua'can pāntzi a'ntūn tū' lītlahuacanī't levadura. Huā'mā' chi'chini' maclacasqui'n namaknīcan lakatin xaska'ta' borrego para na'a'ksajuī'can Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Lā' Jesús cāmacā'lh Pedro lā' Juan lā' cāhuanilh: ―Capintit nacāxtlahua'ya'tit a'nlhā nahua'yāuj huan borrego. ");
INSERT INTO tooNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Lā' xlaca'n takalhasqui'nīlh: ―¿Lhachū lacasqui'na' na'iccāxtlahuayāuj? ");
INSERT INTO tooNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Lā' Jesús cākalhtīlh: ―A'xni'ca' natanūyā'tit huan nac xcānsipej, napāxtokā'tit kalhatin chi'xcu' a'ntī lē'mā' huan ixpūxka'tni'. Nastālani'yā'tit hasta a'nlhā natanūyācha' nac chic ");
INSERT INTO tooNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","lā' nahuaniyā'tit ixtēcu' chic: “Huan Mākalhtō'kē'ni' huaniyāni': ¿Lhā yā huan cuarto a'nlhā tzē na'iccātā'hua' quisca'txtunu'nī'n huan xalīhua't cā'tani'?” ");
INSERT INTO tooNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lā' tuncan nacāmāsu'ni'yāni' lakatin ka'tla' cuarto cāxyātza' ixlītanca'cstu' huan chic. A'ntza' nacāxtlahuayā'tit huan līhua't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ta'a'lh lā' pātle'kelh chu a'nchī Jesús cāhuanilh, lā' tacāxtlahualh huan līhua't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lā' a'xni'ca' horatza' ixuanī't, Jesús lā' ī'sca'txtunu'nī'n tatahui'lalh tahuā'yan. ");
INSERT INTO tooNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Lā' tuncan Jesús cāhuanilh: ―Lej xa'iccātā'huā'yancu'tunāni' huā'mā' xala' smalanka'n porque quit palaj na'icnī. ");
INSERT INTO tooNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Huā'mā' ā'xmān na'iccātā'huā'yanāni' quit hasta a'xni'ca' natlōkentaxtūkō'can ixlīhuāk a'ntū Dios māpa'ksīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lā' tuncan tēlh huan taza a'ntū ixlītzuma xaxcān uva lā' maxquī'lh pāxcatca'tzī Dios. Lā' cāhuanilh ī'sca'txtunu'nī'n: ―Camaklhtīni'ntit lā' cahua'tit milīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quit tū'tza' ā'maktin ictihua'lh xaxcān uva hasta a'xni'ca' nalaktzī'nā'tit a'nchī Dios cāmāpa'ksīkō' ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ixlīka'tlā'tus tayalh huan pāntzi lā' maxquī'lh pāxcatca'tzī Dios lā' mālacpitzilh. Cāmaxquī'lh xlaca'n lā' cāhuanilh: ―U'tza' huā'mā' quimacni' a'ntū macamāstā'mā'ca por mimpālacataca'n. Chuntza' natlahua'yā'tit para naquilālīpāstacāuj. ");
INSERT INTO tooNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nā chuntza' lītlahuapā huan taza a'xni'ca' tahuā'yankō'lh lā' cāhuanilh: ―Huan xaxcān uva a'ntū pūhuī' huā'mā' taza, ū'tza' quinka'lhni'. Lā' ū'tza' a'ntū līcāxtlahuaca huan xasāsti' convenio ixpālacata a'nchī Dios nacālīmāpūtaxtū huan tachi'xcuhuī't. Lā' quinka'lhni' ū'tza' a'ntū na'icmaka'n por mimpālacataca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Lā' chuhua'j hua'chi quimacan huī' nac mesa, nā chuntza' huī' ixmacan huan chi'xcu' a'ntī naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quit huan Chi'xcu' xala' Tālhmā'n lā' naquimpātle'keni' chu a'nchī tatzo'kni' quimpālacata na ixtachihuīn Dios. Pero xānti la huan chi'xcu' a'ntī naquimacamāstā'; nalīlakaputza ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Lā' tuncan tatzuculh talākalhasqui'nī tichū de xlaca'n ixmacamāstā'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Lā' tuncan tatzuculh talālīchihuīna'n tichū de xlaca'n puhuancan más tasqui'nī'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Lā' Jesús cāhuanilh: ―Huan reyes tamāpa'ksī hua'chilh ixtēcu'ca'n tachi'xcuhuī't lā' huan tachi'xcuhuī't tahuan que lacuan huan reyes. ");
INSERT INTO tooNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tū' chuntza' nala na milaclhni'ca'n. Xtunc nala. Lā' a'ntī más tasqui'nī na milaclhni'ca'n xla' nala hua'chi xastancu. A'ntī namāpa'ksīni'n maclacasqui'n nala hua'chi tasācua'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Tichū puhua'na' más tasqui'nī, huan a'ntī huā'yamā' o huan a'ntī mojōmā' huan pulātu? ¿Chu tū' stu'ncua' más tasqui'nī a'ntī huā'yamā'? Pero quit iclalh hua'chi a'ntī mojōmā' mimpulātuca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Hui'xina'n pō'ktu quilātā'latlā'huanāuj a'yuj ixquimpātle'keni' lhūhua' catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lā' como quinTāta' quimaxquī'lh quilīmāpa'ksīn, nā quit na'iccāmaxquī'yāni' milīmāpa'ksīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chuntza' na'iccātā'huā'yanāni' a'nlhā na'icmāpa'ksī lā' natahui'layā'tit a'nlhā nacālacāxtlahuayā'tit huan lakacāujtu' tribusnu' de huan israelitas. ");
INSERT INTO tooNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nā huan Māpa'ksīni' cāhuanilh: ―Cuenta catlahua'tit como Satanás lej cālīlaktzī'ncu'tunāni' a ver palh nacātlajayāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Lā' quit icsqui'ni'lh Dios que hui'x, Simón, tū' catipātza'nkākō'j ixlīhuāk a'ntū kalhlaka'ī'nī'ta'. Lā' hui'x a'xni'ca' nalacāxtlahuapala mintapāstacna', cacāmaktāya' mintā'timīn. ");
INSERT INTO tooNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón Pedro huanilh: ―Mākalhtō'kē'ni', iccāxuī'tza' para na'ictā'a'nāni' hasta huan nac pūlāchī'n lā' para na'ictā'nīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Lā' Jesús huanilh: ―Pedro, icuaniyāni' que huā'mā' chi'chini', a'xni'ca' tūna'j nata'sa huan gallo, maktu'tun naquinkalhtatzē'ka' que tū' quilakapasa'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Lā' tuncan Jesús cākalhasqui'nīlh: ―A'xni'ca' iccāmacā'ni' lā' tū' līpintit mimpūtumīnca'n nīn mimorralca'n nīn mizapatoca'n, ¿chū cāsputni'ni' a'ntū ixmaclacasqui'nā'tit? Lā' xlaca'n tahualh: ―Nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Lā' tuncan cāhuanilh: ―Chuhua'j xtunc iccāhuaniyāni'. Lā' a'ntī ka'lhī ixmorralh, calē'lh. Lā' calē'lh ixpūtumīn. Lā' palh tū' ka'lhī ixmachīta, castā'lh ixtakēnu' para natamāhua. ");
INSERT INTO tooNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","U'tza' iccāhuaniyāni' porque quit na'ictlōkentaxtū ixlīhuāk a'ntūn tatzo'kni' quimpālacata. Chuntza' tatzo'kni': Lā' laktzī'ncan hua'chi kalhatin a'ntīn tū' tzey. Chuhua'j ixlīhuāk a'ntūn tatzo'kni' por quit, tasqui'nī nala. ");
INSERT INTO tooNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Lā' tuncan ī'sca'txtunu'nī'n tahualh: ―Mākalhtō'kē'ni', ā'yā kantu' machīta. Lā' Jesús kalhtīni'lh: ―Tzeytza'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lā' tuncan Jesús taxtulh de huan cuarto lā' como ixlīsmanīnī'ttza', a'lh nac huan o'kspū'n a'nlhā huanican Olivos. Lā' tastālani'lh ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lā' a'xni'ca' tachā'lh, cāhuanilh: ―Na'orarlīyā'tit para que tū' nacātatlajayāni' a'xni'ca' nacātalīlaktzī'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lā' tuncan Jesús a'lh lacachuna'j lā' tatzokostalh para na'orarlī. ");
INSERT INTO tooNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Hualh: ―QuinTāta' Dios, palh hui'x lacasqui'na', caquimāpūtaxtu de huā'mā' līpātīn. Pero calalh a'ntū hui'x lacasqui'na' lā' tū' calalh a'ntū xmān quit iclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Lā' tuncan tasu'yuni'lh kalhatin ángel xala' nac a'kapūn. Tā'chihuīna'lh Jesús para namaxquī' tahuixcān. ");
INSERT INTO tooNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Lā' como lej ixpātīni'mā', Jesús ā'chulā' squi'ni'lh Dios. Lā' tanto ixpātīni'mā' lā' skakana'lh. Lā' tasu'yulh hua'chilh ī'sta'jmā' ixka'lhni' a'nchī skakana'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lā' a'xni'ca' orarlīkō'lh, tāyalh lā' taspi'tli a'nlhā ixcāmāchokonī't ī'sca'txtunu'nī'n. Ixtalhtatamā'na cākaksli como ixcātlajanī't ixtalakaputzītca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Lā' tuncan cāhuanilh: ―Lā' ¿a'chī' lhtatapā'na'ntit? Catā'kaquī'tit lā' casqui'ni'tit Dios para que tū' nacātatlajayāni' a'xni'ca' nacātalīlaktzī'ncu'tunāni'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ixcātā'chihuīna'mā'cus Jesús a'xni'ca' tachā'lh lhūhua' tachi'xcuhuī't. Kalhatin de huan kalhacāujtu' sca'txtunu'nī'n a'ntī ixuanican Judas ū'tza' ixcāpū'lani'tēlha. Laktapajtzūlh Jesús lā' mu'sulh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Lā' tuncan Jesús huanilh: ―Judas, hui'x quimu'su'ya' lā' chuntza' quilīmacamāstā'ya' quit, huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lā' a'xni'ca' talaktzī'lh a'ntū ixpātle'keni'mā' huan a'ntī ixtatā'hui'lāna' Jesús takalhasqui'nīlh: ―¿Chā na'iclatucsāuj con machīta? ");
INSERT INTO tooNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Lā' kalhatin sca'txtunu' mātakāhuī'lh ixtasācua' huan māpa'ksīni' curasna' lā' a'kasityujulh ixa'ka'xko'lh na ixa'kacāna'j. ");
INSERT INTO tooNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Lā' Jesús huanilh: ―Camakxtektit; tū'tza' catlahua'tit. Lā' tuncan Jesús xa'malh ixa'ka'xko'lh huan tasācua' lā' xanca cāxlapā. ");
INSERT INTO tooNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Lā' tuncan cāhuanilh huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' policía a'ntī ixtamaktaka'lha huan lītokpān lā' huan xanapuxcu'nu' israelitas, ixlīhuākca'n a'ntī ixtaminī't tachi'pa: ―¿A'chī' līta'nā'tit mimachītaca'n lā' minqui'hui'ca'n? Hua'chilh chi'pacu'tunā'tit kalhatin ka'lhāna'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A'xni'ca' xa'iccātā'latlā'huanāni' lakalīyān nac lītokpān, ¿a'chī' tūlalh quilāchi'pauj a'xni'ca'? Pero chuhua'j milh milacchi'chini'ca'n lā' namāpa'ksīni'n a'ntīn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tuncan chi'paca Jesús lā' lē'nca na ixchic xamāpa'ksīni' curasna'. Lā' Pedro lacachuna'j ī'stālani'tēlha. ");
INSERT INTO tooNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lā' a'ntza' tahui'līlh macscut pu'nan tanquilhni' lā' tatahui'lalh ixmacni' macscut. Nā Pedro tahui'lalh pu'nan. ");
INSERT INTO tooNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lā' a'xni'ca' laktzī'lh kalhatin squiti' a'nlhā ī'sko'huī', lakalaktzī'hui'līlh lā' hualh: ―Nā huā'mā' chi'xcu' ū'tza' ixtā'latlā'huan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Lā' Pedro kalhtatzē'kli lā' hualh: ―Puscāt, tū' iclakapasa. ");
INSERT INTO tooNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A'calīstān ā'kalhatin laktzī'mpā lā' nā huanilh: ―Nā hui'x kalhatin de xlaca'n. Pero Pedro huanilh: ―Chi'xcu', quit tū' de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lā' ixlīlakatin hora huampala ā'kalhatin stu'tu'lu' huampā: ―Stu'ncua' huā'mā' chi'xcu' ixtā'latlā'huan porque xala' nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Lā' tuncan Pedro huanilh: ―Chi'xcu', tū' icca'tzī a'ntū hua'na'. Lā' huā'mā' ka'tlā'tus a'xni'ca' ixchihuīna'mā'cus Pedro, tuncan huan gallo ta'salh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lā' huan Māpa'ksīni' Jesús talakspi'tli lā' laktzī'lh Pedro, lā' Pedro pāstacli a'nchī ixuaninī't huan Māpa'ksīni': “A'xni'ca' tūna'j nata'sa huan gallo, maktu'tun naquinkalhtatzē'ka' que tū' quilakapasa”. ");
INSERT INTO tooNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Lā' tuncan Pedro taxtulh lā' lej lakaputzaj calhualh. ");
INSERT INTO tooNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huan chi'xcuhuī'n a'ntī ixtamaktaka'lhmā'na Jesús talakapalalh lā' tatucsli. ");
INSERT INTO tooNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Talakachī'lh lā' talacala'sli lā' tahuanilh: ―¡Caquilhchipi tichū lacala'sni'! ");
INSERT INTO tooNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lā' lej lhūhua' ixtahuani de catūhuā como ixtamāmāxanī'cu'tun. ");
INSERT INTO tooNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lā' a'xni'ca' tuncuīlh, tatakēstokli xanapuxcu'nu' israelitas lā' xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley, lā' talē'lh Jesús na ixlacapūnca'n huan pūchihuīna'nī'n a'ntī más ixtamāpa'ksīni'n. A'ntza' kalhasqui'nīca: ");
INSERT INTO tooNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Caquilāhuaniuj: ¿Chā hui'x Cristo a'ntī Dios hui'līnī't ixlīmāpūtaxtūnu'? Lā' xla' cākalhtīlh: ―A'yuj xa'iccāhuanini' palh stu'ncua', pero tū' quintilākalhlaka'ī'uj. ");
INSERT INTO tooNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Lā' palh quit na'iccākalhasqui'nīyāni' catūhuā, tū' quintilākalhtīuj nīn quintilāmakxtekui. ");
INSERT INTO tooNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Quit huan Chi'xcu' xala' Tālhmā'n lā' desde chuhua'j na'ictahui'la na ixpāxtūcāna'j Dios a'ntī más xamāpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Lā' tuncan ixlīhuākca'n takalhasqui'nīlh: ―Lā' ¿chu hui'x ixO'kxa' Dios? Lā' Jesús cākalhtīlh: ―U'huē, chuntza' hua'chi huanī'ta'ntit. ");
INSERT INTO tooNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Lā' tuncan talāhuanilh: ―Lā' ¿a'chī' maclacasqui'nāuj ā'catīhuā para naquincāhuaniyāni' ā'catūhuā? Māni' quina'n kaxmatnī'tauj a'ntū pūhuan ixquilhni'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lā' tuncan ixlīhuākca'n tatāyakō'lh lā' talē'lh Jesús na ixlacapūn Pilato. ");
INSERT INTO tooNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A'ntza' tatzuculh talē'ksa'nīni'n lā' tahualh: ―Iclaktzī'nī'tauj a'nchī huā'mā' chi'xcu' cāmāmakchuyī huan tachi'xcuhuī't. Huan que tū' maclacasqui'n namāpalayāuj iximpuesto emperador, lā' nā huan que ū'tza' Cristo huan a'ntī Dios hui'līni't ixlīmāpūtaxtūnu', lā' huā'mā' tachihuīn huanicu'tun que xla' rey. ");
INSERT INTO tooNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Lā' tuncan Pilato kalhasqui'nīlh: ―¿Chā hui'x ixreyca'n israelitas? Lā' Jesús kalhtīlh: ―Chu chuntza' a'nchī huanī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Lā' tuncan Pilato cāhuanilh xanapuxcu'nu' curasna' lā' tachi'xcuhuī't: ―Nīn tuntū' icmakkaksa a'ntū ixpālacata. ");
INSERT INTO tooNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Lā' xlaca'n stu'tu'lu' tahualh: ―Cāmāmakchuyīmā' ixlīhuākca'n xalanī'n nac Judea a'nchī māsu'yumā'. Tzuculh māsu'yu nac Galilea lā' ixmāsu'yutēlha hasta chilh huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lā' a'xni'ca' Pilato kaxmatli huā'mā', kalhasqui'nīni'lh palh xala' nac Galilea Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lā' a'xni'ca' huanica palh stu'ncua' xala' nac Galilea, macā'ni'ca Herodes a'ntī gobernador de Galilea ixuanī't. Lā' nā xla' ixminī't nac Jerusalén huan tamā'na chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Lā' a'xni'ca' Herodes laktzī'lh Jesús, līpāxuhualh como de makāntza' lej ixlaktzī'ncu'tun. Ixkaxmatnī't a'nchī ixlīchihuīna'ncan lā' puhualh nalaktzī'n lakatin lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Lā' lhūhua' catūhuā kalhasqui'nīlh pero Jesús nīn tuntū' kalhtīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nā a'ntza' ixtahui'lāna'nkō' xanapuxcu'nu' curasna' lā' xamākalhtō'kē'ni'nī'n ley lā' xlaca'n lej palha' ixtalē'ksa'nīni'ni'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Lā' Herodes lā' ixtropasna' talakmaka'lh Jesús lā' tamālhakē'lh tzēhuanī't lu'xu' hua'chi ixla' rey para natalīlītzī'n. Lā' ā'calīstān Herodes macā'ni'pā Pilato. ");
INSERT INTO tooNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lā' chuntza' huā'mā'na chi'chini' Pilato ixamigo tlahualh Herodes. Pū'la lītā'ca'tza ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Lā' Pilato cāmākēstokpā xanapuxcu'nu' curasna' lā' pūchihuīna'nī'n lā' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Lā' cāhuanilh: ―Hui'xina'n quilālīmini'uj huā'mā' chi'xcu' lā' quilāhuaniuj que cāmāmakchuyī tachi'xcuhuī't. Lā' quit ickalhasqui'nīnī'ttza' na milacapūnca'n lā' ca'tzīyā'tittza' que nīn tuntū' icmakkaksa a'ntū ixpālacata a'ntū līlē'ksa'nīni'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nā chuntza' Herodes nīn tuntū' makkaksli. U'tza' līmacaminchokopā. Laktzī'nā'tittza' que nīn tuntū' tlahuanī't para nachī'can lā' nanī. ");
INSERT INTO tooNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Na'iclīmākēsno'knīni'n ko'xka' lā' ā'calīstān na'icmakxteka. ");
INSERT INTO tooNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ixa'nan huan talanān que Pilato ixmakxteka kalhatin tachī'n a'xni'ca' lamā' cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Lā' ixlīhuākca'n tatzuculh tata'sa lā' tahualh: ―¡Camāmaknīnī'ni' huā'mā'! ¡Camakxtekti Barrabás! ");
INSERT INTO tooNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Huan Barrabás ixlīchī'canī't como xla' lā' ixchi'xcuhuī'n tatā'kaquī'lh contra huan māpa'ksīni'nī'n romanos lā' hasta tamaknīni'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ixmakxtekcu'tun Jesús lā' cātā'chihuīna'mpā. ");
INSERT INTO tooNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ā'chulā' tata'salh lā' tahualh: ―¡Caxtokohua'ca'ca! ¡Caxtokohua'ca'ca! ");
INSERT INTO tooNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ixlīmaktu'tun Pilato cāhuanilh: ―Lā' ¿a'chī'? ¿Tuchū tlahuanī't? Quit tū' icmakkaksa nīn tuntū' ixpālacata para namaknīcan. Xmān na'iclīmākēsno'knīni'n ko'xka' lā' ā'calīstān na'icmakxteka. ");
INSERT INTO tooNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Lā' xlaca'n ā'chulā' stu'tu'lu' tahualh lā' tasqui'nli caxtokohua'ca'ca. Lā' tanto tata'salh xlaca'n lā' xanapuxcu'nu' curasna' que tatlajalh. ");
INSERT INTO tooNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chuntza' Pilato tlahualh a'ntū xlaca'n ixtalacasqui'n, ");
INSERT INTO tooNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","lā' makxtekli huan chi'xcu' a'ntī ixtalacsacnī't. U'tza' huan Barrabás a'ntī ixmānūcanī't como tā'kaquī'lh lā' maknīni'lh. Lā' macamāstā'lh Jesús para que catatlahuani'lh chu a'ntū ixtalacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","A'xni'ca' ixtalē'mā'na Jesús para nataxtokohua'ca', tachi'palh kalhatin chi'xcu' a'ntī ixuanican Simón lā' xala' nac Cirene. Xla' ixtanūtēlha nac xcānsipej Jerusalén lā' sāmācu'quī'ca huan cruz lā' māstālīca Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lā' lhūhua' tachi'xcuhuī't ixtastālani'tēlha, nā lhūhua' puscan a'ntī ixtacalhuantēlha lā' lej talakaputzalh por ixpālacata Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Lā' Jesús cālakalaktzī'lh lā' cāhuanilh: ―Puscan xalanī'n nac Jerusalén, tū' cacalhua'ntit por quimpālacata. Mejor nacalhuanā'tit por mimpālacataca'n lā' por ixpālacataca'n mincamana'ca'n, ");
INSERT INTO tooNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","porque namin lakatin chi'chini' a'xni'ca' nahuancan: “Līpāxūj huan a'ntīn tūla ka'lhī ixcaman. Līpāxūj huan a'ntīn tū' maktin tahui'lalh ixcaman lā' tū' maktin mātzi'quī'nilh”. ");
INSERT INTO tooNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lā' a'xni'ca'tza' tachi'xcuhuī't natahuanī huan kēstīn: “Caquilāyujni'uj”. Lā' natahuanī ixmacni' kēstīn: “Caquilā'a'kta'pū'j”. ");
INSERT INTO tooNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Hua'chi huancan palh chuntza' tlahuani'can huan xastaka qui'hui', ā'chulā' natlahuani'can huan xascōhua. Palh chuntza' quintlahuani'can lā' quit tuntū' iclaclē'n, ā'chulā' nacātlahuani'can a'ntīn talaclē'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Nā ixcālē'mā'ca kalhatu' maknīni'nī'n para nacātā'maknīcan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lā' a'xni'ca' tachā'lh a'nlhā huanican La Calavera o Ixa'kxāk Nīn, a'ntza' xtokohua'ca'ca Jesús lā' nā chuntza' huan kalhatu' maknīni'nī'n lā' kalhatin na ixpāxtūcāna'j lā' kalhatin na ixpāxtūxuc. ");
INSERT INTO tooNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Lā' a'xni'ca' ixtaxtokohua'ca'mā'na, Jesús hualh: ―QuinTāta', cacāmāsputūnu'ni' porque tū' taca'tzī a'ntū tatlahuamā'na. Lā' huan tropasna' tapūmāxtulh suerte huan ixlu'xu' Jesús para natatapitzi chā'tunu' de ū'tunu'n. ");
INSERT INTO tooNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Lā' tachi'xcuhuī't ixtayāna' lā' ixtalaktzī'mā'na lā' hasta huan pūchihuīna'nī'n talīlītzī'lh lā' tahualh: ―A'makapitzīn cāmāpūtaxtūlh. Chuhua'j capūtaxtulh ixa'cstu palh stu'ncua' Dios lacsacnī't lā' hui'līlh ixlīmāpūtaxtūnu'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nā huan tropasna' ixtalīlītzī'mā'na. Talaktapajtzūlh lā' tamāhuī'lh vinagre. ");
INSERT INTO tooNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Lā' tahuanilh: ―Palh hui'x ixreyca'n huan israelitas, capūtaxtu mē'cstu. ");
INSERT INTO tooNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lā' ixua'ca' lakatin letrero ixa'cpūn lā' ixtatzo'kni' nac griego lā' latino lā' hebreo. Lā' huan letrero ixuan: U'tza' huā'mā' ixreyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Lā' kalhatin maknīni' a'ntī ixtā'hua'ca' ixlīlītzī'n lā' huanilh: ―Palh stu'ncua' hui'x a'ntī Dios hui'līlh ixlīmāpūtaxtūnu', capūtaxtu' mē'cstu lā' nā caquilāmāpūtaxtūj. ");
INSERT INTO tooNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ā'kalhatin quilhnīlh ixtā'maknīni' lā' huanilh: ―¿Chū tū' ji'cua'ni'ya' Dios? Nā hui'x chu a'cxtim pātīni'mpā't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Līmakuan quina'n pātīni'mā'nauj porque māpalamā'nauj a'ntū laclē'nāuj. Pero huā'mā' chi'xcu' tuntū' laclē'n. ");
INSERT INTO tooNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Lā' tuncan huanilh Jesús: ―Caquimpāstacti a'xni'ca' nata'mpala'ya' lā' rey hui'x. ");
INSERT INTO tooNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Lā' Jesús kalhtīlh: ―Ixlīstu'ncua' icuaniyāni': Chuhua'j, huā'mā' chi'chini' naquintā'latahui'la'ya'chi nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Lā' hua'chi tastu'nūtatza' ixuanī't a'xni'ca' cā'pucsua' lakō'lh chuxalhā nac cā'ti'ya'tna'. Lā' chuntza' lalh hasta hua'chi maktu'tun kōtanū. ");
INSERT INTO tooNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Huan chi'chini' tū' māxkakēni'lh. Lā' huan lu'xu' nac lītokpān ixa'cstu taxtī'tli lā' tapūpitzilh. U'tza' huā'mā' lu'xu' a'ntū ixmāpitzi huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Lā' tuncan Jesús lej palha' ta'salh lā' hualh: ―QuinTāta', icmacamaxquī'yāni' quilīca'tzīn. Lā' a'xni'ca' huankō'lh, nīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Lā' a'xni'ca' huan capitán romano laktzī'lh a'ntū pātle'kelh, mācā'tanīlh Dios lā' hualh: ―Ixlīstu'ncua' huā'mā' chi'xcu' lej tzey ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lā' ixlīhuākca'n tachi'xcuhuī't a'ntīn tamilh lā' talaktzī'lh a'ntū pātle'kelh, tatapānūlh de ā'tzā' lā' cācu'xatucstēlhaca como lej ixtalakaputza. Lā' ta'a'lh na ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lā' ixtalakapasnī'n Jesús lā' nā huan puscan a'ntī ixtastālani'nī't desde nac estado de Galilea makat tatāyalh lā' ixtalaktzī'mā'na huā'mā'na. ");
INSERT INTO tooNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ixuī' kalhatin chi'xcu' ixtacuīni' José lā' ū'tza' xala' nac Arimatea nac huan estado de Judea. Ixtā'tapa'ksī con huan pūchihuīna'nī'n a'ntī más ixtamāpa'ksīni'n de huan israelitas. Lā' tzeyā chi'xcu' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Lā' ixka'lhīmā' a'xni'ca' ixmāpa'ksīni'lh Dios. Tū' lakatīlh a'ntū ixtatlahuanī't huan pūchihuīna'nī'n ixpālacata Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nā huā'mā' chi'xcu' laka'lh Pilato lā' squi'ni'lh ixmacni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Lā' a'xni'ca' ixmāyujūnī'ttza' de nac cruz, līmaksna'tli kalhtin lu'xu' lā' māpī'lh nac lakatin lhu'cu' a'ntū ixcāxtlahuacanī'ttza' nac talhpān. Lā' a'ntza' nīn tintī'na'j ixmā'cnūcanī't. ");
INSERT INTO tooNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huanmā' chi'chini' ū'tza' a'ntū ixpūcāxtlahuakō'can como ixlīlakalī huan chi'chini' de pūjaxni'. Lā' ixtzucumā'tza'. ");
INSERT INTO tooNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Huan puscan a'ntī ixtatā'minī't Jesús desde nac estado de Galilea ta'a'lh talaktzī'n huan lhu'cu' lā' cuenta tatlahualh a'nlhā ixmāpī'canī't ixmacni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Lā' tataspi'tli na ixchicca'n lā' tacāxtlahualh perfume lā' pomada para huan nīn. Lā' tapūjaxli huan chi'chini' de pūjaxni' chuntza' hua'chi māpa'ksīlh a'nlhā tzo'kli huan ixley Moisés. ");
INSERT INTO tooNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cā'tzi'sāt domingo huan tamā'na puscan ta'a'mpā nac taponkni' lā' ixtalē'mā'na huan perfume a'ntū ixtacāxtlahuanī'ttza'. Lā' ā'makapitzīn puscan tatā'a'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lā' a'xni'ca' tachā'lh, talaktzī'lh que ixmāpānūcanī'ttza' huan chihuix a'ntū ixlīmālacchōcanī't huan taponkni'. ");
INSERT INTO tooNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tatanūlh pero tū' takaksli ixmacni' huan Māpa'ksīni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tajicua'lh lā' tū' ixtaca'tzī a'ntū natatlahua lā' a'xni'ca' talaktzī'lh kalhatu' ángeles a'ntī ixtatasu'yu hua'chi chi'xcuhuī'n. Lej slamama ixlu'xu'ca'n ixtahuanī't lā' ixtayāna' pajtzu huan puscan. ");
INSERT INTO tooNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Lā' como xlaca'n ixtajicua'n, tataquilhpūtalh lā' huan ángeles cāhuanilh: ―Lā' ¿a'chī' putzayā'tit na ixlaclhni'ca'n huan nīnī'n kalhatin a'ntī lakahuan? ");
INSERT INTO tooNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A'tzā' tū' huī'. Xla' lakahuanchokonī'ttza'. Capāstactit a'nchī cāhuanini' a'xni'ca' ixuī'cus nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hualh xla' que maclacasqui'n que huan Chi'xcu' xala' Tālhmā'n nacāmacamaxquī'can a'ntīn talaclē'n lā' nataxtokohua'ca' lā' ixlīlakatu'tun chi'chini' nalakahuanchokopala. ");
INSERT INTO tooNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lā' tuncan huan puscan tapāstacli ixtachihuīn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Lā' a'xni'ca' tataspi'tli de huan taponkni', tahuanikō'lh huan kalhacāujtin apóstoles lā' ixlīhuākca'n ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lā' huan puscan, xlaca'n cāhuanican María Magdalena lā' Juana lā' María a'ntī ixtzī't Jacobo lā' ā'makapitzīn puscan huampala. ");
INSERT INTO tooNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero huan apóstoles takaxmatli hua'chi takalhkamān a'ntū ixcāhuanimā'ca lā' tū' takalhlaka'ī'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Lā' a'yuj tū' takalhlaka'ī'lh, pero huan Pedro taxtulh lā' tu'jnulh para nac taponkni'. Lā' taquilhpūtalh lā' talacnūlh lā' laktzī'lh xmān huan lu'xu' a'nlhā ixmā'. Lā' a'lh na ixchic lā' ixlīlē'cnīmā' a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lā' chu ū'tza' huā'mā' chi'chini' kalhatu' a'ntī ixtastālani'nī't Jesús, ixta'a'mā'na nac lakatin cā'lacchicni' a'nlhā huanican Emaús. Lā' ū'tza' hua'chi lakacāujtin kilómetros ixlīmakat de Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ixtalīkalhachihuīna'ntēlha ixlīhuāk a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Lā' līhuan ixtachihuīna'mā'na lā' ixtalacapūchihuīna'mā'na, māni' Jesús cālaktapajtzūlh lā' tzuculh cātā'latā'kchoko. ");
INSERT INTO tooNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Lā' a'yuj talaktzī'lh pero tūlalh talakapasli porque catūhuā talītamakchuyīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Lā' tuncan Jesús cākalhasqui'nīlh: ―¿Tuchū līchihuīna'ntēlhayā'tit? Lā' ¿tuchū līlakaputzayā'tit? ");
INSERT INTO tooNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Lā' kalhatin a'ntī huanican Cleofas kalhtīni'lh: ―Ixlīhuāk tachi'xcuhuī't taca'tzīkō' a'ntū pātle'kelh nac Jerusalén huā' tamā'na chi'chini'. ¿Chu xmān hui'x ixui'la' lā' tū' ca'tzīya'? ");
INSERT INTO tooNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Lā' tuncan Jesús cāhuanilh: ―¿Tuchū lanī't? Lā' tahuanilh: ―Lhūhua' pātle'kelh ixpālacata Jesús xala' nac Nazaret a'ntī a'cta'sana' lā' lej ixka'lhī līmāpa'ksīn na ixlacapūn Dios lā' na ixlaclhni'ca'n tachi'xcuhuī't. Lītasu'yu a'ntū tlahualh lā' a'ntū hualh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Lā' huan xanapuxcu'nu' curasna' lā' quimpūchihuīna'nī'nca'n tamacamāstā'lh para namaknīcan lā' naxtokohua'ca'can. ");
INSERT INTO tooNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Quina'n xa'icka'lhīmā'nauj que ū'tza' xla' a'ntī nacāmāpūtaxtū israelitas. Lā' ixlīlakatu'tuntza' chi'chini' chuhua'j a'xni'ca' pātle'kelh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lā' ā'makapitzīn puscan de na quilaclhpu'nanca'n quincātamakalē'cnīni' porque cā'tzi'sāt taquīlalh nac taponkni', ");
INSERT INTO tooNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","lā' como tū' talaktzī'lh ixmacni' Jesús, tataspi'tli. Lā' quincātahuanini' que talīlakachuyalh ángeles a'ntī cāhuanilh que lakahuan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Lā' chu tuncan ā'makapitzīn quincompañerosnu' taquīlalh nac taponkni' lā' chu a'nchī tahuanilh huan puscan, chuntza' takaksli. Pero tū' talaktzī'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Lā' tuncan Jesús cāhuanilh: ―Tū' xa'nca māchekxīyā'tit. ¿Lhānīn nakalhlaka'ī'yā'tit ixlīhuāk a'ntū tahualh huan a'cta'sana'nī'n? ");
INSERT INTO tooNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Lā' Cristo a'ntī Dios hui'līnī't ixlīmāpūtaxtūnu', ¿chu tū' tasqui'nī que pū'la napātīni'n chuntza' lā' ā'calīstān natanū a'nlhā lej xkaka? ");
INSERT INTO tooNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Lā' tuncan Jesús tzuculh cāmāsu'ni'kō' ixlīhuāk a'ntū tzo'kcanī't na ixtachihuīn Dios lā' a'ntū līchihuīna'n xla'. Tzuculh a'nlhā tzo'knulh Moisés lā' cāmāsu'ni'lh a'ntū ixtatzo'knunī't ixlīhuākca'n huan profetas. ");
INSERT INTO tooNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lā' a'xni'ca' tachā'lh nac huan cā'lacchicni' a'nlhā ixta'a'mā'na, Jesús lalh hua'chilh ixa'mā' más makat. ");
INSERT INTO tooNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Lā' xlaca'n stu'tu'lu' tahuanilh que natachoko lā' tahuanilh: ―Mejor catachoko porque tzī'suamā'tza'. Cā'pucsua'tza'. Lā' tuncan Jesús cātā'tanūlh nac chic para natachoko. ");
INSERT INTO tooNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Lā' a'xni'ca' tatahui'lalh tahuā'yan, xla' tēlh huan pāntzi lā' māstā'lh pāxcatca'tzī lā' mālacpitzilh lā' cāmaxquī'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Chu tuncan huā'mā' ka'tlā'tus hua'chilh xa'nca tatalakapākē'lh lā' talakapasli, pero xla' cālaksputtāyani'lh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Lā' xlaca'n talāhuanilh: ―¿Chu tū' stu'ncua' que lej līpāxūj līhuan ixquincāmāsu'ni'tēlhayāni' ixtachihuīn Dios? ");
INSERT INTO tooNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Lā' chu līmaktin tachi'papā ixtejca'n. Tū' tatakoxīlh nīn macsti'na'j. Tataspi'tchokolh nac Jerusalén lā' cāpāxtokli huan kalhacāujtin apóstoles a'nlhā ixtatakēstoknī't con ā'makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Lā' cāhuanica huan kalhatu': ―Ixlīstu'ncua' lakahuanchokolh huan Māpa'ksīni'. Lā' tasu'yuni'lh Simón. ");
INSERT INTO tooNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lā' tuncan xlaca'n cāhuanilh a'nchī cāpātle'keni'lh nac tej lā' a'nchī talakapasli Jesús a'xni'ca' mālacpitzilh huan pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Līhuan ixtalīchihuīna'mā'nacus huā' tamā'na, a'xni'ca' Jesús tāyalh na ixlaclhpu'nanca'n. Lā' cāhuanilh: ―Tzey calīla'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Lā' cāmakē'klhaca lā' lej tajicua'lh lā' ixtapuhuan que ixtalaktzī'mā'na espíritu. ");
INSERT INTO tooNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Lā' Jesús cāhuanilh: ―¿A'chī' jicua'nā'tit? ¿A'chī' xtunc puhua'nā'tit mē'cstuca'n? ");
INSERT INTO tooNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Calaktzī'ntit quimacanī'n lā' quintojonī'n. Lā' naquilālakapasāuj. Caquilāxa'mauj lā' caquilālaktzī'uj. Huan espíritu tū' ka'lhī quinīt lā' lucut hua'chi quit. ");
INSERT INTO tooNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","A'xni'ca' chuntza' cāhuanilh, cāmāsu'ni'lh ixmacanī'n lā' ixtojonī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero como xlaca'n tapalalaktzī'ni'lh lā' lej talīpāxuhualh, tūlalh takalhlaka'ī'lh. Lā' Jesús cākalhasqui'nīlh: ―¿Chā a'nan līhua't? ");
INSERT INTO tooNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Lā' tuncan maxquī'ca pītzina'j xatapū'n squī'ti' lā' lakatin xatachu'cu ta'xcāt. ");
INSERT INTO tooNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Lā' xla' maklhtīni'lh lā' hua'kō'lh na ixlacapūnca'n. ");
INSERT INTO tooNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lā' ā'calīstān cāhuanilh: ―A'ntū quimpātle'keni'lh ū'tza' a'ntū iccāhuanini' a'xni'ca' xa'iccātā'latlā'huanāni' que maclacasqui'n na'ictlōkentaxtū ixlīhuāk a'ntūn tatzo'kni' na ixtachihuīn Dios por quimpālacata, a'nlhā tzo'knulh Moisés lā' huan profetasna' lā' a'nlhā huanican Salmos. ");
INSERT INTO tooNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lā' tuncan cāmāsca'tīlh ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Lā' cāhuanilh: ―Chuntza' tatzo'kni' que maclacasqui'n nanī Cristo a'ntī Dios hui'līnī't ixlīmāpūtaxtūnu'. Lā' maclacasqui'n que ixlīlakatu'tun chi'chini' nalakahuanchoko de a'nlhā tahui'lāna'ncha' nīnī'n. ");
INSERT INTO tooNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Lā' maclacasqui'n que nacāmāsu'ni'kō'can ixlīhuākca'n tachi'xcuhuī't xalanī'n nac quilhtamacuj por ixpālacata Cristo. Natzucucan nac Jerusalén lā' nacāhuanikō'can que maclacasqui'n nataxtāpalī ixtapāstacna'ca'n para que nacāmāsputūnu'ni'can. ");
INSERT INTO tooNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Lā' hui'xina'n nacāmāsu'ni'yā'tit huā' tamā'na catūhuā como laktzī'nkō'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lā' chuhua'j calaktzī'ntit. Na'iccāmacamini'yāni' a'ntū huanī't quinTāta'. Lā' natachokoyā'tit huā'tzā' nac Jerusalén hasta a'xni'ca' namaklhtīni'nā'tit huan līmāpa'ksīn a'ntū xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Lā' tuncan Jesús cālē'lh ī'sca'txtunu'nī'n nac tej hasta Betania lā' cha'xli ixmacanī'n lā' cāsicua'lanālīlh. ");
INSERT INTO tooNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Lā' līhuan ixcāsicua'lanālīmā', tzuculh tā'kayāhua na ixlacapūnca'n lā' lē'nca nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Xlaca'n tamācā'tanīlh lā' ā'calīstān lej līpāxūj tataspi'tli nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lā' pō'ktu ixtahui'lāna' nac xaka'tla' lītokpān para natamā'ca'tanī Dios. Amén.");
INSERT INTO tooNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A'xni'ca' tūna'j ixcāxui'lī huan quilhtamacuj, lanāntza' ixuī' kalhatin a'ntī huanican Tachihuīn, como ū'tza' quincāmālakapasnīyāni' Dios. Lā' xla' ixtā'lahuī'tza' Dios. Lā' xla' ū'tza' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Xapū'la ixtā'lahuī' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Lā' huan Tachihuīn cāxui'līlh ixlīhuāk catūhuā a'ntū a'nan; tuntū' ixa'nalh palh tū' cahuā por ū'tza'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Por ixpālacata ū'tza' talīhui'lāna' ixlīhuāk a'ntū jaxāna'n. Lā' xla' cāmāsu'ni' huan tachi'xcuhuī't a'ntū ixlīstu'ncua' lā' chuntza' hua'chilh ixcāmakskoni' huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","U'tza' hua'chi lakatin xkakana' a'ntū mālakxkakēni'n a'nlhā cā'pucsua'. Lā' huan ko'ti'ti', xla' xala' nac cā'pucsua' lā' xla' tūla tlaja huan Xkakana'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ixuī' kalhatin chi'xcu' ixtacuīni' Juan, a'ntī Dios macamilh. ");
INSERT INTO tooNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Xla' milh para nalīchihuīna'n a'ntī huanican Xkakana' lā' para nacāmaxquī' tapāstacna' huan tachi'xcuhuī't que natakalhlaka'ī' a'ntī Xkakana'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan tū' ū'tza' Xkakana'. Xla' xmān quīmāsu'yuchi huā'mā' a'ntī scana'nca Xkakana'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A'ntī mero Xkakana' ixmimā'cus nac cā'quilhtamacuj. Xla' cāmakskokō' ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Lā' a'ntī scana'nca Xkakana', xla' milh nac cā'quilhtamacuj. Lā' a'yuj ū'tza' cāxui'līlh quilhtamacuj, pero xalanī'n nac quilhtamacuj tū' talakapasli lā' tū' ixtaca'tzī que ū'tza' ixcāxui'līnī't huan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xla' milh nac quilhtamacuj a'ntū ixcāxui'līnī't pero tū' talaktzī'ncu'tulh ixtā'macchicni'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero makapitzīn takalhlaka'ī'lh. Lā' ixlīhuākca'n a'ntīn takalhlaka'ī'lh, xla' cāmaxquī'lh līmāpa'ksīn para que chuntza' natala ixcamana' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Lā' a'nchī tala ixcamana' Dios, tū' hua'chi talacatuncuī ixcamana'ca'n tachi'xcuhuī't. Ixcamana' Dios tū' hua'chi lakatin ska'ta' a'ntī lacatuncuīlh por ixpālacata ixtapāxuhuanca'n lā' ixtapuhuānca'n tachi'xcuhuī't. Dios ū'tza' a'ntī cāmā'a'nanī ixcamana'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Lā' a'ntī huanican Tachihuīn, xla' macni' lalh. Lā' xla' latahui'lalh na quilaclhpu'nanca'n. Lā' iclaktzī'uj a'nchī ka'lhī līmāpa'ksīn. Huā'mā' līmāpa'ksīn ū'tza' ixla' a'ntī ixa'cstu ixO'kxa' Dios. Xla' lej lakalhu'mana'n lā' huāk a'ntū huan ū'tza' ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan līchihuīna'lh lā' hualh: ―U'tza' huā'mā' a'ntī iclīchihuīna'lh a'xni'ca' icualh que a'ntī icpū'lani'nī't, ū'tza' līhuaj xaka'tla' que quit. Xla' lanāntza' ixuī' a'xni'ca' quit iclacatuncuīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quincātlahuani'nī'ta'ni' lhūhua' talakalhu'mān, como xla' lej lakalhu'mana'n. ");
INSERT INTO tooNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés quincāmāsu'ni'ni' ixley Dios. Pero Jesucristo quincāmāca'tzīnīyāni' a'ntū ixlīstu'ncua' lā' a'nchī quincālakalhu'manāni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lā' nīn tintī' laktzī'nī't Dios nīn maktin. A'ntī ixa'cstu ixO'kxa' Dios, a'ntī Dios lej pāxquī', ū'tza' quincāmāsu'ni'nī'ta'ni' a'nchī huanī't Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Lā' huan israelitas xalanī'n nac Jerusalén talakmacamilh Juan makapitzīn curasna' lā' levitasna'. Lā' xlaca'n takalhasqui'nīlh Juan tichū xla'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Lā' Juan cāmālacstū'ncni'lh lā' cāhuanilh: ―Pues quit, tū' quit Cristo a'ntī Dios lacsacli lā' hui'līlh ixlīmāpūtaxtūnu'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Lā' takalhasqui'nīpā: ―¿Tichū hui'x? ¿Chā hui'x huan ixa'cta'sana' Dios a'ntī huanican Elías? Lā' Juan hualh: ―Tū' quit. Lā' takalhasqui'nīpā: ―¿Chā hui'x huan ixa'cta'sana' Dios a'ntī icka'lhīmā'nauj? Lā' xla' kalhtīni'lh: ―Tū'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Lā' takalhasqui'nīpā: ―¿Tichū hui'x? Caquilāhuaniuj para na'iccāhuaniyāuj a'ntī quincātamacaminī'ta'ni'. ¿Tichū hua'na' que hui'x? ");
INSERT INTO tooNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan cākalhtīlh: ―Quit hua'chi a'ntī ta'sa nac cā'lhpi'mpi'li' ti'ya't lā' huan: “Cacāxtlahua'tit mintapāstacna'ca'n para que nakaxpa'tā'tit huan Māpa'ksīni' a'xni'ca' namin”. Chuntza' hualh ixa'cta'sana' Dios a'ntī huanican Isaías, a'xni'ca' hualh: Camā'lakstu'nctit ixtej Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lā' nā ixtahui'lāna' makapitzīn fariseosnu' a'ntī ixcālakmacamincanī't Juan. ");
INSERT INTO tooNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Lā' xlaca'n takalhasqui'nīlh: ―Lā' ¿a'chī' mā'kpaxīni'mpā't palh tū' Cristo hui'x, nīn Elías, nīn huan ixa'cta'sana' Dios a'ntī icka'lhīmā'nauj? ");
INSERT INTO tooNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Lā' Juan cāhuanilh: ―Quit iclīmā'kpaxīni'n xmān con xcān. Yā na milaclhpu'nanca'n kalhatin a'ntīn tū' lakapasā'tit. Lā' nā xla' namā'kpaxīni'n. ");
INSERT INTO tooNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Xla' līhuaj xaka'tla' que quit. Lā' tū' minī'ni' nīn na'icxcutni' ixlīkalhtza'pa'can ī'zapato. ");
INSERT INTO tooNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lā' huāk huā'mā' pātle'kelh a'nlhā huanican Betábara tīntacut huan pūxka Jordán, a'nlhā ixmā'kpaxīni'n Juan. ");
INSERT INTO tooNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lā' ixlīlakalī Juan laktzī'lh Jesús ixlaktapajtzūtēlha lā' cāhuanilh huan tachi'xcuhuī't: ―Calaktzī'ntit a'ntī mimā'. U'tza' huā'mā' a'ntī macaminī't Dios lā' ū'tza' huanican Ixcordero Dios. U'tza' namāpānū huan quintalaclē'i'ca'n xalanī'n nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","U'tza' iclīchihuīna'lh a'xni'ca' iccāhuanini': “A'ntī icpū'lani'nī't, ū'tza' līhuaj xaka'tla' que quit porque xla' lanāntza' ixuī' a'xni'ca' quit iclacatuncuīlh”. ");
INSERT INTO tooNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","A'yuj quit tūna'j xa'iclakapasa, quit icminī't icmā'kpaxīni'n con xcān para que huan tachi'xcuhuī't nataca'tzī que Dios macamilh huan a'ntī icpū'lani'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Lā' nā cāhuanilh Juan: ―Quit iclaktzī'lh huan Espíritu Santo a'ntū yujchi lā' chilh na ixa'cpūn. Lā' huan Espíritu Santo tasu'yulh hua'chi lakatin tantzasnān. ");
INSERT INTO tooNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xapū'la quit tū' xa'icca'tzī tichū xla'. Quihuanilh Dios a'ntī quimacā'lh para na'icmā'kpaxīni'n con xcān. Dios quihuanilh: “Nalaktzī'na' nayujāchi huan Espíritu Santo lā' nachin na ixa'cpūn kalhatin chi'xcu'. Huā'mā' chi'xcu' ū'tza' a'ntī līmā'kpaxīni'n Espíritu Santo”. ");
INSERT INTO tooNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iclaktzī'nī'ttza' a'nchī quihuanica. Lā' ū'tza' iclīmāstū'nca quit que ū'tza' huā'mā' ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Lā' ixlīlakalī huampala Juan ixcātā'layā con kalhatu' ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Lā' laktzī'lh ixtētaxtumā' Jesús. Lā' Juan lakalaktzī'lh Jesús lā' hualh: ―U'tza' huā'mā' a'ntī macamilh Dios lā' a'ntī huanican Ixcordero Dios, como xla' nacāmāpānūni' ixtalaclē'i'ca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Huan kalhatu' ī'sca'txtunu'nī'n Juan takaxmatli a'xni'ca' hualh. Lā' xlaca'n tastālani'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Lā' Jesús talakspi'tli lā' laktzī'lh ixtastālani'tēlha lā' cāhuanilh: ―¿Chichū puhua'nā'tit? Lā' xlaca'n tahuanilh: ―Māpa'ksīni', ¿lhachū hui'la'? ");
INSERT INTO tooNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Lā' Jesús cākalhtīlh: ―Cata'ntit lā' calaktzī'ntit. Tatā'a'lh lā' talaktzī'lh a'nlhā ixuī'. Lā' como lejtza' kōtanū ixuanī't, hua'chi maktā'ti', a'ntza' tatachokolh huanmā' chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Lā' huan tamā'na' kalhatu' a'ntī tastālani'lh Jesús por ixpālacata a'ntū ixcāhuaninī't Juan, lā' kalhatin de ū'tunu'n ixuanican Andrés, ixtā'tin Simón Pedro. ");
INSERT INTO tooNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lā' chu tuncan Andrés putzalh ixtā'tin a'ntī ixuanican Simón lā' huanilh: ―Icpāxtokuitza' huan Mesías ―ū'tza' huanicu'tun: Cristo a'ntī lacsacui'līnī't Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Lā' Andrés tā'a'lh Simón talaktzī'n Jesús. Lā' a'xni'ca' Jesús laktzī'lh huan Simón lā' huanilh: ―Hui'x Simón, ixo'kxa' Jonás. Hui'x nahuanica'na' Cefas ―huā'mā' ū'tza' huanicu'tun: Pedro lā' nā chihuix. ");
INSERT INTO tooNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Lā' ixlīlakalī huampala Jesús ixa'ncu'tun a'nlhā huanican Galilea. Lā' tā'lāpāxtokli Felipe lā' huanilh: ―Caquistāla'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Lā' huā'mā' Felipe xala' nac Betsaida ixuanī't lā' nā a'ntza' xalanī'n Andrés lā' Pedro. ");
INSERT INTO tooNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe quīkaksli Natanael lā' huanilh: ―Icpāxtokuitza' huan chi'xcu' a'ntī tatzo'kni' na ixtachihuīn Dios a'nlhā Moisés tzo'kli huan ley lā' a'nlhā tatzo'knulh huan profetas. Xla' ū'tza' Jesús, ixo'kxa' José xala' nac Nazaret. ");
INSERT INTO tooNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Lā' Natanael hualh: ―¿Chu tzēn taxtu de Nazaret a'ntū xatzey? Lā' Felipe kalhtīlh: ―Cata't laktzī'na'. ");
INSERT INTO tooNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús laktzī'lh huan Natanael lakmimā' lā' hualh: ―Huan a'ntī mimā' ū'tza' tzeyā israelita. Xla' tū' a'kxokonu'n. ");
INSERT INTO tooNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael kalhasqui'nīlh: ―¿Chichū quilīlakapasti? Lā' Jesús huanilh: ―Quit iclaktzī'ni' xapū'la na ixtampīn huan a'kalhpauj a'xni'ca' tūna'j ixta'sani'yāni' Felipe. ");
INSERT INTO tooNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael kalhtīlh: ―Māpa'ksīni', hui'x ixO'kxa' Dios; hui'x a'ntī Dios lacsacni' para nala'ya' ixreyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Lā' Jesús kalhtīlh: ―Quinkalhlaka'ī'ya' xmān por ixpālacata icuanini' iclaktzī'ni' na ixtampīn huan a'kalhpauj. Nalaktzī'na'cus más laka'tla'n catūhuā a'ntū na'ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Lā' nā hualh Jesús: ―Ixlīstu'ncua' a'ntū icuaniyāni'. Hui'xina'n nalaktzī'nā'tit huan a'kapūn laquī'yā, lā' huan ángeles a'ntū nacāmacamin Dios. Xlaca'n natatahua'ca' lā' natayujāchi na ixa'cpūn huan Chi'xcu' xala' Tālhmā'n. Quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ixlīlakatu'tun chi'chini' tapūchahuaca nac lakatin cā'lacchicni' a'ntū huanican Caná, nac estado de Galilea. Ixtzī't Jesús a'ntza' ixuī'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Lā' nā kantāyaca Jesús lā' con ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Lā' como sputli huan xavino uva, ixtzī't Jesús huanilh: ―Tintī'tza' xavino uva. ");
INSERT INTO tooNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Lā' Jesús kalhtīlh: ―Lā' ¿a'chī' quihuani'ya' huā'mā', Nā'? Tūna'j tzucu quilītlōt. ");
INSERT INTO tooNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ixtzī't cāhuanilh huan macatzī'tni'nī'n: ―Catlahua'tit ixlīhuāk a'ntū xla' nacāhuaniyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Lā' ixuī' pāchāxan pūxka'tni' de chihuix a'ntū ixcāmaclacasqui'ncan a'xni'ca' ixmakacha'ka'ncan chu a'nchī ixtalanānca'n. (Huan tachi'xcuhuī't israelitas ixtakalhlaka'ī' que palh maklhūhua' ixtamakacha'ka'lh, chuntza' natala lacuan na ixlacapūn Dios.) Lā' huan pātunu' pūxka'tni' ixtalītatzuma lakatunu' hua'chi tā'ti'pu'xamna' hasta lakatin ciento litros de xcān. ");
INSERT INTO tooNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús cāhuanilh huan macatzī'tni'nī'n: ―Cacāmātzuma'tit de xcān huā' pūxka'tni'. Lā' chuntza' xlaca'n xa'nca tamātzumalh. ");
INSERT INTO tooNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lā' Jesús cāhuanilh: ―Camācututit macsti'na'j lā' calīpini'tit huan a'ntī xapuxcu' de huan cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lā' huan xapuxcu' quilhca'tzīlh. Lā' vinotza' ixuanī't. Lā' xla' tū' ixca'tzī palh xcān ixuanī't lā' ixtaxtāpalīnī'ttza' huan xcān, vinotza' ixlanī't. Ixtaca'tzī xmān huanmā'na macatzī'tni'nī'n porque ū'tunu'n ixtamojōnī't xcān nac huan pūxka'tni'. Lā' huan xapuxcu' de huan cā'tani' ta'sani'lh huan squi'nīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Lā' huanilh: ―Lanān xapū'la cāmaxquī'can a'ntī cākantāyacan huan xatzey vino. Lā' ā'calīstān, a'xni'ca' tzejtza' tako'tnī't huan a'ntī cākantāyacanī't, cāmaxquī'can huan a'ntūn tū' lej xatzey. Lā hui'x ā'xmān māstā'ya' huan xatzey vino. ");
INSERT INTO tooNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","U'tza' huā'mā' a'ntū tlahualh Jesús nac Caná nac estado de Galilea, ū'tza' xapū'la lē'cnīn a'ntū tlahualh Jesús. Lā' chuntza' līmāsu'yulh ixlīmāpa'ksīn. Lā' ī'sca'txtunu'nī'n takalhlaka'ī'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","A'calīstān Jesús a'lh nac Capernaum. Lā' tatā'a'lh ixtzī't lā' ixtā'timīn lā' ī'sca'txtunu'nī'n. Lā' a'ntza' tatachokolh lātma'j. ");
INSERT INTO tooNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Lā' como lejtza' pajtzu ixmimā' huan cā'tani' a'ntū huanican pascua a'ntū pō'ktu ixtapūtlahua cā'tani' huan israelitas, Jesús a'lh nac xcānsipej a'ntū huanican Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lā' tanūlh nac xaka'tla' lītokpān. Lā' a'ntza' cālaktzī'lh a'ntī ixtastā'mā'na huācax lā' borregos lā' tantzasnān, lā' ā'makapitzīn a'ntī ixtahui'lāna' con ixmesaca'n para nataxtāpalī huan tumīn. ");
INSERT INTO tooNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús tlahualh lakatin lītāsno'knu' de lazo, lā' cālītansno'kxtukō'lh ixlīhuākca'n huan borregosnu' lā' huan huācaxna'. Cāmakpūspi'tni'lh ixmesaca'n a'ntī ixtaxtāpalīmā'na tumīn, lā' cāmaka'ni'kō'lh huan ixtumīnca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Lā' cāhuanilh huan stā'na'nī'n tantzasnān: ―Camāxtutit huan tamā'na de huā'tzā'. Tū' catlahua'tit hua'chi lītamāuj huā' na ixchic quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lā' ī'sca'txtunu'nī'n talīpāstacli chu a'nchī ixtatzo'kni' na ixtachihuīn Dios: Lej iclacasqui'n ca'a'cnīni'ni'ca ixchic Dios. Lā' ū'tza' naquilīlakmaka'ncan. ");
INSERT INTO tooNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Huan israelitas tahuanilh: ―¿Chu ka'lhī'ya' līmāpa'ksīn para natlahua'ya' huā'mā'? Caquilātlahuani'uj lakatin lē'cnīn para que chuntza' na'icca'tzīyāuj palh hui'x ka'lhī'ya' līmāpa'ksīn para nacāmāxtuya' huan animalhna' de huan xaka'tla' lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Lā' Jesús cāhuanilh: ―Calactlahua'tit huā'yā chic lā' ixlītu'tuma'j na'iclīcāxtlahua quit. ");
INSERT INTO tooNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Huan israelitas takalhtīlh: ―Tu'pu'xamachāxan cā'ta līcāxtlahuakō'ca huan lītokpān. Lā' ¿chu hui'x xmān tu'tuma'j nalīcāxtlahuakō'ya'? ");
INSERT INTO tooNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Lā' a'xni'ca' hualh huā'mā' Jesús ixlīchihuīna'mā' de ixmacni'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Lā' ī'sca'txtunu'nī'n tapāstacli ixtachihuīn Jesús a'xni'ca' xla' lakahuanchokolh. Lā' takalhlaka'ī'lh a'ntū ixtatzo'kni' na ixtachihuīn Dios lā' nā a'ntū hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nac Jerusalén ixlamā' cā'tani' a'ntū huanican pascua. Lā' Jesús ixui'lacha' lā' a'ntza' tlahualh lhūhua' lē'cnīn. Lā' ū'tza' lhūhua' talīkalhlaka'ī'lh huan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Lā' como Jesús ixcālakapaskō' ixlīhuākca'n, xla' ixca'tzī que makapitzīn ixtakalhlaka'ī' lā' ā'makapitzīn tū' ixtakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lā' tū' ixmaclacasqui'n ā'kalhatin a'ntī nahuani chichū huanī't huan tachi'xcuhuī't. Xla' cālakapasni'kō' ixtapāstacna'ca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ixuī' kalhatin fariseo ixtacuīni' Nicodemo. Xla' kalhatin xapuxcu' israelitas ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Lakatin tzī'sa' xla' lakmilh huan Jesús lā' huanilh: ―Mākalhtō'kē'ni', ca'tzīcan que Dios macaminī'ta'ni' para namāsu'yu'ya'. Xmān ū'tunu'n a'ntī Dios tatā'scuja, xmān xlaca'n tzē natatlahua huan lē'cnīn hua'chi tlahua'ya' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Lā' Jesús huanilh: ―Ixlīstu'ncua' a'ntū icuaniyāni'. Xmān ū'tunu'n a'ntī taka'lhī xasāsti' ixquilhtamacujca'n, xmān ū'tunu'n tzē natatapa'ksī con Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo kalhasqui'nīlh: ―Lā' ¿chichū līlalh huā'mā', kalhatin chi'xcu' papatza' lā' naka'lhī xasāsti' ixquilhtamacuj? Tūla natanūpala na ixpān ixtzī't para nalacatuncuīpala. ");
INSERT INTO tooNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Lā' Jesús hualh: ―Ixlīstu'ncua' a'ntū icuaniyāni'. Xmān ū'tunu'n a'ntī taka'lhī xasāsti' ixquilhtamacujca'n por ixpālacata xcān lā' huan Espíritu Santo, xmān xlaca'n tzē natatapa'ksī con Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Huan a'ntī ixcaman tachi'xcuhuī't, ū'tza' ka'lhī ixquinīt lā' ixlucut. Lā' a'ntī ka'lhī xasāsti' ixquilhtamacuj por ixlīmāpa'ksīn Espíritu Santo, ū'tza' ka'lhī ixEspíritu Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tū' calē'cni' a'ntū icuaniyāni': “Maclacasqui'n que naka'lhī'yā'tit xasāsti' minquilhtamacujca'n milīhuākca'n hui'xina'n”. ");
INSERT INTO tooNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Huan ū'ni' lakachu a'n. Xmān kaxpa'ta' a'nchī macasā'nan lā' hui'x tū' ca'tzīya' lhachū mincha' lā' tū' ca'tzīya' lhachū a'mā'. Lā' nā chuntza' tū' ca'tzīya' a'nchī kalhatin chi'xcu' tzē naka'lhī xasāsti' ixquilhtamacuj por ixlīmāpa'ksīn Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo kalhasqui'nīpā: ―Lā' ¿chichū līlalh huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Lā' Jesús hualh: ―¿Chu tū' ca'tzīya' huā'mā'? Lā' hui'x kalhatin ixmākalhtō'kē'ni'ca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ixlīstu'ncua' a'ntū icuaniyāni'. Iclīchihuīna'nāuj a'ntū icca'tzīyāuj lā' icuanāuj a'ntū iclaktzī'nī'tauj. Lā' hui'xina'n tū' kalhlaka'ī'yā'tit a'ntū icuanāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Como hui'xina'n tū' quilākalhlaka'ī'yāuj a'xni'ca' quit iccālīkalhachihuīna'ni'yāni' a'ntū xala' nac cā'ti'ya'tna', tū' quintilākalhlaka'ī'uj quit palh na'iccālīkalhachihuīna'ni'yāni' catūhuā xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Nīn tintī' lakapasna'n nac a'kapūn, xmān quit. Como xa'icui'lacha'cus a'xni'ca' tūna'j xa'icyujāchi de nac a'kapūn, quit iclakapasna'n. Lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Lā' chu a'nchī Moisés pūmā'kayāhualh qui'hui' huan lūhua' nac cā'lhpi'mpi'li' ti'ya't, nā chuntza' maclacasqui'n naquimā'kayāhuacan quit nac cruz. Lā' quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Lā' chuntza', ixlīhuākca'n a'ntīn quintalīpāhuan nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Lā' Jesús cāhuanipā: ―Dios lej cāpāxquī' ixlīhuākca'n huan tachi'xcuhuī't xalanī'n nac quilhtamacuj. U'tza' līmāstā'lh ixO'kxa' a'ntī xmān kalhatin ixuanī't para que chuntza' ixlīhuākca'n a'ntīn talīpāhuan xla', xlaca'n tū' maktin catitasputli. Nataka'lhī xasāsti' ixquilhtamacujca'n a'ntū natāyani' para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios macamilh ixO'kxa' nac quilhtamacuj. Tū' macamilh para nacāmāpātīnī xalanī'n nac cā'quilhtamacuj. Macamilh para que xlaca'n natapūtaxtu. Ixlīhuākca'n a'ntīn takalhlaka'ī' ixO'kxa' Dios, xlaca'n natapūtaxtu. ");
INSERT INTO tooNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’A'ntīn talīpāhuan ixO'kxa' Dios, xlaca'n tū' caticāmāpātīnīca. A'ntīn tū' talīpāhuan, xlaca'n nacāmāpātīnīcan porque xlaca'n tū' talīpāhuan ixO'kxa' Dios a'ntī xmān kalhatin ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Milh huā' nac quilhtamacuj huan a'ntī hua'chi xkakana' como māsu'yu a'ntū ixlīstu'ncua'. Lā' makapitzīn tū' ixtalakatī huan Xkakana'. Ixtalakatī a'nlhā cā'pucsua' porque xlaca'n ixtatlahuacu'tun a'ntūn tū' tzey. Lā' ū'tza' nacālīmāpātīnīcan. ");
INSERT INTO tooNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Huāk a'ntīn tatlahua a'ntū ko'hua'jua' tū' talakatī huan xkakana' lā' tū' tatapajtzūcu'tun nac cā'xkakana' porque tū' talacasqui'n que nacālaktzī'ncan nīn naca'tzīcan a'nchī tatlahuanī't a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","A'ntīn tatlahua a'ntūn tzey, xlaca'n tatapajtzū nac cā'xkakana' para que nacālaktzī'ncan lā' naca'tzīcan que xlaca'n tatlahua chu a'nchī Dios lacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lā' ā'calīstān Jesús a'lh nac estado de Judea lā' tatā'a'lh huan ī'sca'txtunu'nī'n. Lā' a'ntza' tachokolh lātma'j lā' ixmā'kpaxīni'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Lā' nā huan Juan nā ixmā'kpaxīni'n huan nac Enón na ixpajtzu Salim como a'ntza' ixmā' lhūhua' xcān. Lā' huan tachi'xcuhuī't ixtalakchin lā' ixta'a'kpaxa. ");
INSERT INTO tooNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tūna'j ixmānūcan Juan nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Makapitzīn ixchi'xcuhuī'n Juan tatzuculh tatā'lāhuanī huan ā'makapitzīn israelitas por ixpālacata huan a'nchī mā'kpaxīni'ncan lā' palh Dios laktzī'n más xatzey catīhuā a'xni'ca' a'kpaxa. ");
INSERT INTO tooNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Talaka'lh huan Juan lā' tahuanilh: ―Māpa'ksīni', ¿pāstaca' huan chi'xcu' a'ntī ixtā'hui'lāchi tintacut Jordán lā' a'ntī līchihuī'na'? Chuhua'j nā xla' mā'kpaxīni'mā' lā' ū'tza' talakminkō'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan cākalhtīlh: ―Kalhatin chi'xcu' ka'lhī xmān a'ntū Dios maxquī'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Hui'xina'n kaxpa'ttit a'nchī icualh: “Tū' quit Cristo. Xmān quimacamincanī't para na'icpū'lani'”. ");
INSERT INTO tooNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A'xni'ca' cāxtlahuacanī'ttza' para natapūchahuacan, huan tasqui'ni' nala ixla' huan squi'nīni'. Huan ixamigo squi'nīni' xmān tāya lā' kaxmata. Lā' līpāxuhua a'nchī pāxuhua huan squi'nīni'. Lā' nā chuntza' quit lej iclīpāxuhua Jesús como talakminkō'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Maclacasqui'n que Jesús ā'chulā' natastālani'kō' lā' quit tū' ā'chulā' quintistālani'ca. ");
INSERT INTO tooNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","A'ntī minī'ta'ncha' xala' nac a'kapūn, ū'tza' más xaka'tla' que ixlīhuākca'n. A'ntīn talacatuncuī nac quilhtamacuj, ū'tunu'n xalanī'n nac quilhtamacuj lā' xmān talīchihuīna'n a'ntū xala' nac cā'quilhtamacuj. A'ntī mincha' de nac a'kapūn, ū'tza' más xaka'tla' de ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Lā' xla' līchihuīna'n a'ntū laktzī'nī't lā' kaxmatnī't. Lā' nīn tintī' kalhlaka'ī' a'ntū huan. ");
INSERT INTO tooNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Palh catīhuā kalhlaka'ī' ixtachihuīn a'ntī mincha' de nac a'kapūn, chuntza' tasu'yu que xla' puhuan que stu'ncua' a'ntū huan Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Huan a'ntī Dios macamilh, xla' līchihuīna'n ixtachihuīn Dios porque Dios maxquī' huan Espíritu Santo lā' tū' lakpuhuan a'nchī māstā'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Huan xaTāta' pāxquī' huan ixO'kxa' lā' macamaxquī'kō'lh ixlīhuāk para namāpa'ksīni'n xla'. ");
INSERT INTO tooNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","A'ntīn talīpāhuan ixO'kxa' Dios, xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. Lā' a'ntīn tū' talīpāhuan, xlaca'n tū' catitaka'lhīlh xasāsti' ixquilhtamacujca'n para pō'ktu. Lā' Dios lej nacāmāpātīnī. ");
INSERT INTO tooNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Huan fariseosnu' ixcāmāca'tzīnīcanī'ttza' que huan Jesús más lhūhua' ixtastālani' lā' ixcāmā'kpaxīmā', lā' Juan tū' lej lhūhua' a'ntī ixtastālani' lā' ixcāmā'kpaxī. ");
INSERT INTO tooNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero Jesús tū' ixmā'kpaxīni'n; xmān ī'sca'txtunu'nī'n Jesús ū'tunu'n ixtamā'kpaxīni'n. ");
INSERT INTO tooNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Lā' a'xni'ca' Jesús ca'tzīlh que huan fariseosnu' ixcāmāca'tzīnīcanī'ttza' huā'mā', Jesús taxtulh de huan nac Judea lā' a'lh para nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Lā' huan ixtej Galilea tētaxtu por Samaria. ");
INSERT INTO tooNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lā' a'xni'ca' Jesús ixtētaxtumā' a'nlhā ixtapa'ksī nac Samaria, chā'lh nac lakatin cā'lacchicni' ixtacuīni' Sicar na ixpajtzu huan ti'ya't a'ntū Jacob ixmaxquī'nī't ixo'kxa' a'ntī ixuanican José. ");
INSERT INTO tooNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A'ntza' ixuī' lakatin mu'sni' a'ntū makāntza' ixla' ixuanī't Jacob. Lā' hua'chi tastu'nūta Jesús chā'lh nac huanmā' mu'sni'. Lā' como lejtza' makat ixtlā'huanī't, lejtza' ixtlekuanī't. Lā' a'ntza' tahui'lalh na ixquilhtūn huan mu'sni'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Lā' tū' xlīt lakchilh kalhatin puscāt xala' nac Samaria para namācutu xcān como ī'xka'tmā'. Lā' Jesús huanilh: ―Quintā'hua' mixcān. ");
INSERT INTO tooNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Huan sca'txtunu'nī'n ixta'a'nī't nac cā'lacchicni' para natatamāhua ixlīhua'tca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Lā' huan puscāt samaritana huanilh huan Jesús: ―Hui'x israelita lā' quit samaritana. Lā' ¿a'chī' quisqui'ni'ya' xcān? ―chuntza' huanilh porque huan israelitas tū' ixtalālaktzī'ncu'tun con huan samaritanosnu'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Lā' Jesús kalhtīlh: ―Ixca'tzi cahuā a'ntū Dios māstā' lā' a'ntī squi'ni'mā'ni' mixcān, hui'x ixquisqui'ni' quit lā' quit xa'icmaxquī'ni' xatzey xcān. ");
INSERT INTO tooNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Huan puscāt huanilh: ―Hui'x tū' ka'lhī'ya' a'ntū napūmācutuya' lā' huan mu'sni' pūlhmā'n hui'lacha'. ¿Lhāchū nataya'ya' huan xatzey xcān? ");
INSERT INTO tooNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A'ntī quimpapca'n Jacob quincāmāchokoni'ni' huā'mā' mu'sni'. A'tzā' ixko'tnun Jacob lā' ixo'kxa'n lā' ixanimalhna'. Lā' ¿chu hui'x más ka'tla' que Jacob? ");
INSERT INTO tooNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Lā' Jesús huanilh: ―Ixlīhuāk a'ntī natahua' huā'mā' xcān, nataka'lhīpala takalhpūtīt. ");
INSERT INTO tooNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Lā' a'ntī natahua' huā'mā' xcān a'ntū na'iccāmaxquī' quit, xlaca'n tū'tza' maktin catitakalhpūtīlh. Huan xcān a'ntū na'iccāmaxquī' quit nala hua'chi mu'sni' na ixchakānca'n, lā' nacāmaxquī' xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Lā' huan puscāt huanilh: ―Pues caquima'xqui' huā'mā' xcān lā' chuntza' tū'tza' maktin ictikalhpūtīlh lā' chuntza' tū'tza' ictimilh na'icxka'ta huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Lā' Jesús huanilh: ―Caquīta'sa'ni' minkōlu'. Lā' cata'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Lā' huan puscāt kalhtīlh: ―Tū' icka'lhī quinkōlu'. Jesús huanilh: ―Stu'ncua' a'ntū hua'na' que tū' ka'lhī'ya' minkōlu'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Hui'x cāka'lhī'nī'ta' kalhaquitzis minkōlu'. Lā' a'ntī tā'hui'la' chuhua'j, xla' tū' minkōlu'. Ixlīstu'ncua' a'ntū huanī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Lā' huan puscāt huanilh: ―Hui'x ixa'cta'sana' Dios. Chuntza' tasu'yu. ");
INSERT INTO tooNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Huan quinapapna'ca'n samaritanosnu' ixtamācā'tanī Dios huā'tzā' nac kēstīn. Lā' hui'xina'n israelitas hua'nā'tit que xmān nac Jerusalén tzē namācā'tanīcan Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Lā' Jesús kalhtīlh: ―Cakalhlaka'i' a'ntū na'icuaniyāni'. Namin lakatin quilhtamacuj a'xni'ca' tū'tza' catimaclacasqui'nca na'a'ncan mācā'tanīcan xaTāta' Dios huan nac kēstīn lā' nīn nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hui'xina'n samaritanosnu' tū' lakapasā'tit a'ntī mācā'tanī'yā'tit. Quina'n iclakapasāuj a'ntī icmācā'tanīyāuj. Lā' a'ntī namāpūtaxtūnu'n, xla' ū'tza' kalhatin israelita. ");
INSERT INTO tooNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Chilhtza' huan quilhtamacuj a'xni'ca' a'ntī xa'ncq tamācā'tanī xaTāta' Dios natamācā'tanī con ixlīhuāk ixa'clhcunucca'n lā' natakalhlaka'ī' ixtachihuīn Dios. Dios lacasqui'n que chuntza' nalīmācā'tanīcan. ");
INSERT INTO tooNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios lakahuan a'yuj tū' laktzī'ncan. Lā' tasqui'nī que tachi'xcuhuī't natamācā'tanī con ixlīhuāk ixa'clhcunucca'n; lā' tasqui'nī natakalhlaka'ī' ixtachihuīn Dios. Chuntza' xa'nca natalīmācā'tanī Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Huan puscāt huanilh: ―Quit icca'tzī que namin huan Mesías a'ntī huanican Cristo a'ntī Dios lacsacui'līnī't lā' mānūlh ixlīmāpūtaxtūnu'. Xla' naquincāhuanikō'yāni' ixlīhuāk a'xni'ca' namin. ");
INSERT INTO tooNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Lā' Jesús huanilh: ―U'tza' quit a'ntī tā'chihuīna'mā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Lā' tuncan tachilh ī'sca'txtunu'nī'n. Lā' talē'cnīlh como talaktzī'lh Jesús a'nchī ixtā'chihuīna'mā' huan puscāt. Lā' nīn chā'tin kalhasqui'nīlh huan puscāt: “¿Tuchū lacasqui'na'?” Lā' tū' kalhasqui'nīca Jesús: “¿A'chī' tā'chihuīna'mpā't huan puscāt?” ");
INSERT INTO tooNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Huan puscāt hui'līlh ixpūxka'tni' lā' a'lh nac cā'lacchicni' lā' cāhuanilh huan tachi'xcuhuī't: ");
INSERT INTO tooNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Capintit laktzī'nā'tit kalhatin chi'xcu' a'ntī quihuanikō'lh ixlīhuāk a'ntū ictlahuanī't. Chō'la ū'tza' a'ntī Cristo. ");
INSERT INTO tooNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tataxtulh de huan cā'lacchicni' para natalaka'n Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Lā' līhuan ixtamimā'na huan tachi'xcuhuī't, huan ī'sca'txtunu'nī'n Jesús tahuanilh: ―Māpa'ksīni', catihua'ya' macsti'na'j. ");
INSERT INTO tooNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Lā' xla' cāhuanilh: ―Quit icka'lhī quilīhua't. Hui'xina'n tū' ca'tzīyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Huan sca'txtunu'nī'n talākalhasqui'nīlh: ―¿Chā catīhuā quīxtekni'chitza' ixlīhua't? ");
INSERT INTO tooNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Lā' Jesús cāhuanilh: ―Quit ictlahuacu'tun ixlīmāpa'ksīn quinTāta' a'ntī quimacaminī't, lā' ictlahuakō'cu'tun a'ntū quilīmāmacū'nī't. U'tza' huā'mā' quit quilīhua't. ");
INSERT INTO tooNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hui'xina'n hua'nā'tit: “Sputacus lakatā'ti' mālhcuyu' napūlana'n”. Quit iccāhuaniyāni': Calaktzī'ntit huan tachi'xcuhuī't a'ntīn tamimā'na. Palaj natakalhlaka'ī' quintachihuīn. Xlaca'n hua'chi tacuxtu a'nlhā ā'xmān naxkāna'ncan. ");
INSERT INTO tooNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A'ntī xkāna'n maxquī'can ixtatlaj. Lā' nā chuntza' a'ntī quintatā'scuja. Por ixpālacata a'ntū tamāsu'yu xlaca'n, makapitzīn takalhlaka'ī'. Lā' ū'tza' hua'chi ixtatlajca'n a'ntīn quintatā'scuja. Lā' a'ntīn takalhlaka'ī' quintachihuīn, xlaca'n taka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. U'tza' natalīpāxuhua a'ntīn tamāsu'yulh quintachihuīn xapū'la lā' a'ntīn tamāsu'yulh ā'calīstān. ");
INSERT INTO tooNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ixlīstu'ncua' a'nchī huancan: “Kalhatin cha'n lā' ā'kalhatin xkāna'n”. ");
INSERT INTO tooNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Quit iccāmacā'nī'ta'ni' para naxkāna'nā'tit a'nlhā tū' cha'nī'ta'ntit hui'xina'n. Naxkāna'nā'tit a'nlhā tascujli ā'makapitzīn. U'tza' huanicu'tun que hui'xina'n nacāmāsu'ni'yā'tit a'ntī cāmāca'tzīnīcanī'ttza' macsti'na'j quintachihuīn. Lā' xlaca'n natakalhlaka'ī' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Lā' lej lhūhua' samaritanosnu' xalanī'n huanmā' cā'lacchicni' takalhlaka'ī'lh Jesús por ixpālacata huan a'ntū huanī't huan puscāt: “Quihuanikō'lh ixlīhuāk a'ntū ictlahuanī't quit”. ");
INSERT INTO tooNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lā' chuntza' huan samaritanosnu' a'xni'ca' talakchilh Jesús, tahuanilh catachokolh con ū'tunu'n. Lā' xla' tachokolh lakatu' chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Lā' lhūhua' takalhlaka'ī'lh a'xni'ca' takaxmatli a'ntū hualh xla'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Lā' xlaca'n tahuanilh huan puscāt: ―Chuhua'j tū' xmān por ixpālacata mintachihuīn ickalhlaka'ī'yāuj. Quina'n iclaktzī'uj con quilakastapunca'n lā' ickaxmatnī'tauj a'ntū huan xla'. Lej ixlīstu'ncua' palh ū'tza' Cristo a'ntī nacāmāpūtaxtū xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lā' ixlīlakatu' chi'chini' Jesús taxtulh de nac Samaria lā' a'lh nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús ixcāhuaninī't que kalhatin a'cta'sana' tū' a'cnīni'ni'can na ixā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Lā' a'xni'ca' Jesús chilh nac Galilea, līpāxūj talaktzī'lh xalanī'n nac Galilea. Como xlaca'n taquīlalh nac Jerusalén a'nlhā ixlamā' cā'tani' a'ntū huanican pascua, ixtalaktzī'nkō'nī'ttza' ixlīhuāk a'ntū quītlahualh Jesús a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús mimpā nac Caná, nac estado de Galilea, a'nlhā līmāxtulh xavino uva huan xcān. Lā' pajtzu Caná, nac lakatin cā'lacchicni' a'ntū huanican Capernaum, ixuī' kalhatin chi'xcu' a'ntī ixtā'scujmā' huan rey. Lā' huan ixo'kxa' lej ixī'tza'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lā' a'xni'ca' ca'tzīlh que Jesús ixtaxtunī'ttza' huan nac Judea lā' ixui'lacha'tza' nac Galilea, lā' chu tuncan huan xatāta' a'lh laktzī'n Jesús lā' lej squi'nli que ca'a'lh na ixchic para namātzeyī ixo'kxa' porque ixnīmā'tza'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Lā' Jesús huanilh: ―Hui'xina'n tū' kalhlaka'ī'yā'tit hasta que tū' nalaktzī'nā'tit lē'cnīn lā' xalaka'tla'n catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Lā' huan chi'xcu' huanilh: ―Capit na quinchic līhuan tūna'j nī qui'o'kxa'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Lā' Jesús huanilh: ―Capinchitza' na minchic. Mi'o'kxa' tzeyalhtza'. Lā' huan chi'xcu' kalhlaka'ī'lh a'ntū huanilh Jesús lā' a'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lā' a'xni'ca' ixchintēlha na ixchic, ixtasācua'nī'n chu tuncan tataxtulh ta'a'lh talakapāxtoka lā' tahuanilh: ―Mi'o'kxa' tzeyalhtza'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Lā' cākalhasqui'nīlh tuchūyā hora tzuculh tzeyan. Lā' tahuanilh: ―Kōtan hua'chi maktin kōtanū tapānūni'lh huan tachi'chīxni'. ");
INSERT INTO tooNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Huan xatāta' chu tuncan ca'tzīlh que chu ū'tza' huā'mā' hora a'xni'ca' huanilh Jesús: “Mi'o'kxa' tzeyalhtza'”. Lā' ū'tza' līkalhlaka'ī'lh Jesús huan chi'xcu' lā' nā ixlīhuākca'n xalanī'n na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Lā' ū'tza' huā'mā' ixlīlakatu' lē'cnīn a'ntū tlahualh Jesús a'xni'ca' mincha' nac Judea lā' chā'lh nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Lā' tū' makān ā'calīstān huan israelitas talītzuculh huan cā'tani'. Lā' Jesús a'lh nac xcānsipej Jerusalén a'nlhā ixlamā' huan cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Lā' nac Jerusalén, ixuī' lakatin mu'sni' na ixpajtzu a'nlhā ixtalactanū borregos nac huanmā' xcānsipej. Lā' huan mu'sni' ixuanican Betesda. U'tza' ixtachihuīn hebreo. Lā' a'nlhā ixuī' huan mu'sni' ixuī' lhūhua' xcān. Lā' pūlhmā'n ixuanī't. Lā' ixyāhuacanī'ttza' ixa'cchic a'ntū ixka'lhī lakaquitzis ixtanquilhni'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","A'ntza' ixtamā'na lhūhua' ī'tza'ca'nī'n a'ntī lakatzi'nī'n lā' a'ntīn tū' tzey ixtojonca'n lā' a'ntī ixtalū'ntū'lanī't. Xlaca'n ixtaka'lhīmā'na a'xni'ca' ixtaxakā'līlh huan xcān. ");
INSERT INTO tooNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","A'katunu' ixyujāchi kalhatin ángel. Lā' ū'tza' ixlakxakā'lī huan xcān. Lā' a'ntī pū'la ixtojō huan nac xcān a'xni'ca' ixtalakxakā'lī, xla' chu tuncan ixtzeyan de chu xatūyā tajatat. ");
INSERT INTO tooNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lā' a'ntza' ixuī' kalhatin chi'xcu' a'ntī ixī'tza'ca'n pu'xamacāujtzeyan cā'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Lā' Jesús laktzī'lh huan chi'xcu' a'nlhā ixmā'. Lā' como Jesús ixca'tzī'tza' palh lejtza' makān ixī'tza'ca'n huan chi'xcu', lā' kalhasqui'nīlh: ―¿Chā tzeyancu'tuna'? ");
INSERT INTO tooNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Lā' huan ī'tza'ca' kalhtīni'lh: ―Tintī' a'ntī naquimojō huā' nac xcān a'xni'ca' talakxakā'lī. A'xni'ca' quit ictojōcu'tun chu tuncan tojō ā'kalhatin lā' chuntza' quilītlajacan. ");
INSERT INTO tooNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Lā' Jesús huanilh: ―Catā'kaqui' lā' casacti mixti'cat lā' catlā'hua'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lā' chu tuncan huan chi'xcu' tzeyalh lā' sacli ī'xti'cat lā' tzuculh tlā'huan. Lā' huanmā' chi'chini' xla' ū'tza' ixpūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lā' huan israelitas tahuanilh huan chi'xcu' a'ntī mātzeyīca: ―Chuhua'j huā'mā' chi'chini' ū'tza' a'ntū pūjaxcan. Lā' hui'x tū' a'nan nalīpina' catūhuā. Tū' līmakuan hui'x līpimpā't mixti'cat. Chuntza' huan quileyca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Lā' huan chi'xcu' cākalhtīlh: ―Pues a'ntī quimātzeyīlh, ū'tza' quihuanilh: “Casacti mixti'cat lā' catlā'hua'”. ");
INSERT INTO tooNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Lā' takalhasqui'nīlh: ―Lā' ¿tichūyā chi'xcu' a'ntī huanini': “Casacti mixti'cat lā' catlā'hua'”? ");
INSERT INTO tooNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Lā' huan chi'xcu' tū' ixca'tzī a'ntī mātzeyīlh porque lej lhūhua' tachi'xcuhuī't ixtahui'lāna' lā' Jesús ixcālaclhtaxtunī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Lā' ā'calīstān Jesús tā'lāpāxtokli nac xaka'tla' lītokpān lā' huanica: ―Chuhua'j hui'x tzeya'tza'. Tū'tza' catlahua' a'ntū ko'hua'jua'. Palh hui'x natlahua'pala'ya' a'ntū ko'hua'jua', chō'la napātīpala'ya' hui'x ā'līhua'ca'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Lā' huan chi'xcu' a'lh lā' cāmāca'tzīnīlh huan israelitas que a'ntī ixmātzeyīnī't xla' ū'tza' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Lā' huanmā' chi'chini' ū'tza' a'ntū ixpūjaxcan lā' a'xni'ca' Jesús tlahualh huanmā' lē'cnīn. Lā' ū'tza' talītzuculh talīmacaputza israelitas lā' ixtamaknīcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Lā' Jesús cāhuanilh: ―QuinTāta' pō'ktu scujmā' lā' nā ū'tza' quit iclīscuja. ");
INSERT INTO tooNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lā' ū'tza' ā'chulā' talī'a'kchā'lh huan israelitas lā' lej ixtamaknīcu'tun. Ta'a'kchā'lh porque xla' ixtlahuanī't a'ntūn tū' tzey para xlaca'n huanmā' chi'chini' a'ntū pūjaxcan lā' ixuampala xla' que Dios ū'tza' ixTāta' lā' ū'tza' ixlītā'talacastuca Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Lā' Jesús cāhuanilh: ―Lej stu'ncua' a'ntū iccāhuaniyāni'. Quit quē'cstu tuntū' ictlahua. Xmān ictlahua ixtapuhuān quinTāta' Dios. Iclaktzī'n a'ntū tlahua quinTāta' lā' xmān ū'tza' ictlahua. A'ntū tlahua quinTāta', nā ū'tza' ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Huā' quinTāta' quimpāxquī' quit lā' quimāsu'ni' ixlīhuāk catūhuā a'ntūn tlahuamā'. Lā' naquimāsu'ni'cus a'ntū más xalaka'tla'n catūhuā. Lā' ū'tza' na'ictlahua lā' nalē'cnī'yā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","QuinTāta' mālakahuanīchokonīni'n. Lā' nā chuntza' quit iccāmālakahuanī a'ntī iccāmālakahuanīcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","QuinTāta' tū' lacāxtlahua nīn kalhatin porque xla' quimacamaxquī'nī't huan līmāpa'ksīn para na'iclacāxtlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Lā' chuntza' ixlīhuākca'n naquinta'a'cnīni'ni' quit a'cxtim hua'chi ta'a'cnīni'ni' quinTāta' Dios. A'ntīn tū' qui'a'cnīni'ni' quit nā tū' a'cnīni'ni' quinTāta' a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ixlīstu'ncua' a'ntū iccāhuaniyāni'. A'ntī takaxmata a'ntū icuan lā' talīpāhuan a'ntī quimacamilh, xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. Lā' xlaca'n tū' caticāmālaclē'nīca; taka'lhītza' ixquilhtamacujca'n xasāsti' a'ntū tū' maktin catisputli. ");
INSERT INTO tooNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Lā' ixlīstu'ncua' a'ntū iccāhuaniyāni'. Mimā'tza' huan chi'chini' lā' chuhua'j huā'mā' quilhtamacuj a'xni'ca' huan a'ntīn tū' taka'lhī xasāsti' ixquilhtamacujca'n, xlaca'n natakaxmata quintachihuīn quit, ixO'kxa' Dios. Lā' a'ntī nata'a'kahuāna'ni' quintachihuīn, xlaca'n nacāmaxquī'can xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","QuinTāta' Dios, xla' ka'lhī līmāpa'ksīn para nacāmaxquī' tachi'xcuhuī't ixquilhtamacujca'n xasāsti'. Lā' quimaxquī'nī't quit līmāpa'ksīn para na'iccāmaxquī' xasāsti' ixquilhtamacujca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Lā' quimaxquī'nī't līmāpa'ksīn para na'iclacāxtlahua, como quit huan Chi'xcu' xala' Tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tū' calē'cnī'tit a'ntū iccāhuanimā'ni'. Mimā' huan chi'chini' a'xni'ca' huan nīnī'n natakaxmata quintachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Lā' natatā'cxtuyāchi xlaca'n de nac taponkni'. A'ntīn tatlahualh a'ntūn tzey, xlaca'n natalakahuanchoko lā' nataka'lhī xasāsti' ixquilhtamacujca'n. Lā' a'ntīn tatlahualh a'ntū xako'hua'jua', xlaca'n natalakahuanchoko lā' nacāmāpātīnīcan. ");
INSERT INTO tooNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Lā' Jesús cāhuanipā: ―Quit tū' ictlahua a'ntū xmān quimpātunca'tzi. Quit iclacāxtlahua chu a'nchī Dios quihuanī. A'nchī iclacāxtlahua quit, chuntza' tzey porque quit tū' ictlahua xmān a'ntū quit iclacasqui'n. Ictlahua xmān ixpātunca'tzi huan quinTāta' a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Palh xmān cahuā quit xa'icmālacstū'ncli lā' tintī' ā'kalhatin a'ntī namālacstū'nca de quit, chuntza' tū' catikalhlaka'ī'ca a'ntū icuan. ");
INSERT INTO tooNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Hui'lapā ā'kalhatin. U'tza' naquilīchihuīna'n. Lā' quit icca'tzī que a'ntū nahuan xla' de quit, ū'tza' ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hui'xina'n mākalhasqui'nīnīni'ntit Juan. Lā' Juan kalhtīni'lh a'ntū ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Quit tū' icmaclacasqui'n nīn kalhatin chi'xcu' a'ntī namālacstū'nca de quit. Xmān iccāhuanimā'ni' huanmā' para que hui'xina'n napūtaxtuyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan xla' hua'chi lakatin pūmaksko a'ntū ixlama lā' ixmaksko. Lā' hui'xina'n tū' makān lakatī'tit a'nchī ixcāmāxkakēyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juan ixmālacstū'nca que Dios quimacaminī't. Lā' a'ntū más māsu'yu que Dios quimacaminī't ū'tza' a'ntū ictlahua, como ictlahua a'ntū Dios quilīmāmacū'nī't. ");
INSERT INTO tooNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Lā' nā Dios mālacstū'nca de quit. Pero hui'xina'n tū' maktin kaxpa'tnī'ta'ntit ixtachihuīn lā' tū' maktin laktzī'nī'ta'ntit Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Lā' tū' ka'lhīyā'tit ixtachihuīn na mi'a'clhcunucca'n. Chuntza' tasu'yu como hui'xina'n tū' kalhlaka'ī'yā'tit palh quit Dios quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Hui'xina'n lej xa'nca lakapūtle'keyā'tit huan ixtachihuīn Dios. Puhua'nā'tit que chuntza' naka'lhīyā'tit xasāsti' minquilhtamacujca'n para pō'ktu. A'yuj huan ixtachihuīn Dios līchihuīna'n de quimpālacata, ");
INSERT INTO tooNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pero hui'xina'n tū' quilākalhlaka'ī'cu'tunāuj para que chuntza' naka'lhīyā'tit xasāsti' minquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Quit tū' ictamakchuyī palh tachi'xcuhuī't tū' quinta'a'cnīni'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Quit icca'tzī xa'nca que hui'xina'n tū' pāxquī'yā'tit Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Quit icminī't por ixquilhtampān Dios. Lā' hui'xina'n tū' quilākalhlaka'ī'yāuj. Palh ixmilh ā'kalhatin xmān por ixtapuhuān, ū'tza' nakalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Hui'xina'n lacasqui'nā'tit que cacāta'a'cnīni'ni'ni' huan tachi'xcuhuī't lā' tū' pāstacā'tit natlahua'yā'tit a'ntū ixtapuhuān Dios. Lā' ū'tza' tū' līkalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tū' capuhua'ntit palh na'iccālē'ksa'nīni'nāni' con quinTāta'. A'ntī nacālē'ksa'nīni'nāni' ū'tza' Moisés a'ntī līpāhua'nā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Palh hui'xina'n ixkalhlaka'ī'tit cahuā a'ntū tzo'kli Moisés, nā quit ixquilākalhlaka'ī'uj, como a'ntū tzo'kli Moisés, ū'tza' līchihuīna'lh de quit. ");
INSERT INTO tooNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Lā' palh hui'xina'n tū' kalhlaka'ī'yā'tit a'ntū tzo'kli Moisés, ¿chichū naquilālīkalhlaka'ī'yāuj quit a'ntū iccāhuaniyāni'? ");
INSERT INTO tooNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lā' ā'calīstān Jesús a'lh nac tintacut mar a'nlhā ixtacuīni' Galilea lā' nā ixuanican Tiberias. ");
INSERT INTO tooNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Lā' lej lhūhua' tachi'xcuhuī't ixtastālani'nī't porque ixtalaktzī'nī't huan lhūhua' lē'cnīn a'ntū ixtlahuanī't, como ixcāmātzeyīnī't huan ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Lā' Jesús tō'ca'lh huan nac kēstīn lā' a'ntza' tatō'lalh con ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lā' ixtapajtzūtēlha huan ixcā'tani'ca'n israelitas a'ntū huanican pascua. ");
INSERT INTO tooNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Lā' Jesús laca'a'lh lā' lacachuna'j cālaktzī'lh lhūhua' tachi'xcuhuī't ixtalakmimā'na. Lā' huanilh huan Felipe: ―Chuhua'j ¿lhachū natamāhuayāuj līhua't a'ntū nacāmāhuī'yāuj huā'mā' tachi'xcuhuī't? ");
INSERT INTO tooNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús hualh huā'mā' a ver chichū ixkalhtīni'lh Felipe. Jesús, xla' ixca'tzītza' a'ntū natlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Lā' Felipe kalhtīni'lh: ―Lakatu' ciento pesos tū' cati'a'cchā'lh para natalīhuā'yan macasti'n. ");
INSERT INTO tooNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Lā' ā'kalhatin sca'txtunu' ixtacuīni' Andrés, a'ntī ixtā'tin Simón Pedro, xla' hualh: ");
INSERT INTO tooNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―A'tzā' huī' kalhatin ka'hua'chu. Xla' līmin macquitzis pāntzi de cebada lā' ā'tantu' squī'ti'. Lā' ¿chichū nalī'a'cchā'n, tanto lhūhua' tachi'xcuhuī't? ");
INSERT INTO tooNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Lā' Jesús hualh: ―Cacāhuani'tit huan tachi'xcuhuī't que catatahui'lakō'lh ixlīhuākca'n. A'ntza' lej ixmā' seket. Lā' a'ntza' tatahui'lakō'lh hua'chi lakaquitzis mil chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Lā' Jesús cātayalh huan pāntzi lā' maxquī'lh pāxcatca'tzī Dios lā' cāmaxquī'lh ī'sca'txtunu'nī'n. Lā' xlaca'n tamaxquī'lh a'ntī ixtahui'lāna'. Lā' nā chuntza' cāmaxquī'lh huan squī'ti'. Lā' cāmaxquī'lh chu a'nchī xlaca'n talacasqui'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lā' a'xni'ca' taka'sli, Jesús cāhuanilh huan ī'sca'txtunu'nī'n: ―Cacāmākēstokkō'tit huan xalacpītzin. Tū' capāxcatlīla'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tamākēstokli lā' a'cchā'lh pācāujtu' chā'xta' lītatzumalh xalacpītzin macquitzis pāntzi de cebada. ");
INSERT INTO tooNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lā' huan tachi'xcuhuī't a'xni'ca' talaktzī'lh huanmā' lē'cnīn a'ntūn tlahualh Jesús, xlaca'n tahualh: ―Stu'ncua' ū'tza' huanmā' ixa'cta'sana' Dios a'ntī ixmimā' huā' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Lā' Jesús ca'tzīlh que ixtalē'ncu'tun lā' ixtasātlahuacu'tun ixreyca'n. Lā' ū'tza' lītapānūlh lā' ixa'cstu a'lh nac kēstīn. ");
INSERT INTO tooNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lā' a'xni'ca' tzī'satza' ixuanī't, ī'sca'txtunu'nī'n tayujchi para na ixquilhtūn mar. ");
INSERT INTO tooNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Tatojōlh nac lakatin barco lā' ixtatēlakataxtumā'natza' huan mar. Xlaca'n ixtachā'ncu'tun nac Capernaum. Lejtza' cā'pucsua' ixuanī't lā' Jesús tūna'j ixtaspi'ta. ");
INSERT INTO tooNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lā' lej tzuculh ū'nun. Lā' huan xasipej xcān ixtatā'kayāhua. ");
INSERT INTO tooNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lā' a'xni'ca' ixtatlā'huanī'ttza' hua'chi lakaquitzis kilómetro ixlīmakat, huan sca'txtunu'nī'n talaktzī'lh Jesús. Ixtapajtzūtēlha huan nac barco, lā' ixkalhtlā'huantēlha huan xcān. Lā' xlaca'n tajicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Lā' xla' cāhuanilh: ―Quit Jesús. Tū' cajicua'ntit. ");
INSERT INTO tooNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lā' xlaca'n con lhūhua' tapāxuhuān tamā'ca'lh nac barco. Lā' chu tuncan lacapalh tachā'lh na ixquilhtūn huan mar, ixpajtzu Capernaum. ");
INSERT INTO tooNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Lā' ixlīlakalī ixtalahui'lāna'ncha'cus huan tachi'xcuhuī't nac tintacut mar. Xlaca'n taca'tzīlh que xmān lakatin barco ixuī' lā' ū'tza' ixtapūtacutnī't huan sca'txtunu'nī'n lā' Jesús tū' ixcātā'a'nī't. ");
INSERT INTO tooNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lā' makapitzīn barcos xalacti'na'j ixtaminī'ta'ncha' nac Tiberias lā' tachilh ixpajtzu a'nlhā ixua'canī't pāntzi a'xni'ca' māstā'lh pāxcatca'tzī huan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lā' a'xni'ca' huan tachi'xcuhuī't taca'tzīlh que Jesús tū'tza' ixuī' a'ntza' lā' nīn ī'sca'txtunu'nī'n, xlaca'n tatojōlh huan nac barcos lā' ta'a'lh taputza nac Capernaum. ");
INSERT INTO tooNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lā' a'xni'ca' huan tachi'xcuhuī't tatacutcha', takaksli Jesús lā' takalhasqui'nīlh: ―Māpa'ksīni', ¿lhāchūnīn chita' huā'tzā'? ");
INSERT INTO tooNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Lā' Jesús cāhuanilh: ―Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Hui'xina'n laktzī'ntit huan lhūhua' lē'cnīn a'ntū ictlahualh. Tū' ixpālacata huan lē'cnīn quilāputzayāuj. Hui'xina'n tzej huā'yantit lā' tzej ka'stit. U'tza' quilālīputzayāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tū' cascujtit por huan milīhua'tca'n a'ntū nasputa. Xatzey cascujtit por huan līhua't a'ntū tū' maktin catisputli. Quit icmāstā' huā'mā' līhua't como quit huan Chi'xcu' xala' Tālhmā'n lā' como quit icmilh por ixquilhtampān quinTāta' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Lā' xlaca'n takalhasqui'nīlh: ―Lā' ¿chichū na'ictlahuayāuj para que tzē na'ictlahuayāuj chu a'nchī lacasqui'n Dios? ");
INSERT INTO tooNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Lā' Jesús cākalhtīlh: ―A'ntū Dios lacasqui'n que natlahua'yā'tit, ū'tza' huā'mā': Naquilākalhlaka'ī'yāuj, como quit quimacaminī't Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Takalhasqui'nīlh: ―Lā' ¿tuchūyā lē'cnīn tzē naquilātlahuani'yāuj para que chuntza' na'iccākalhlaka'ī'yāni'? ¿Tuchū natlahua'ya' hui'x? ");
INSERT INTO tooNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Huan quinapapna'ca'n tahua'lh a'ntū huanican maná nac cā'lhpi'mpi'li' ti'ya't. Chuntza' tatzo'kni' na ixtachihuīn Dios: Xla' cāmaxquī'lh ixlīhua'tca'n xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Lā' Jesús cākalhtīlh: ―Ixlīstu'ncua' a'ntū iccāhuaniyāni'. A'ntū Moisés cāmaxquī'ni', ū'tza' tū' huan līhua't xala' nac a'kapūn. QuinTāta' xla' cāmaxquī'yāni' huan Xatzey Līhua't xala' nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Macamincanī'ta'ncha' nac a'kapūn kalhatin a'ntī cāmaxquī' xasāsti' ixquilhtamacujca'n huan tachi'xcuhuī't nac cā'quilhtamacuj. U'tza' huā'mā' huan Xatzey Līhua't a'ntū māstā'mā' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Lā' tahuanilh: ―Caquilāmaxquī'uj pō'ktu huanmā' līhua't. ");
INSERT INTO tooNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Lā' Jesús cāhuanilh: ―Quit huā'mā' Līhua't. Quit iccāmaxquī' xasāsti' ixquilhtamacujca'n tachi'xcuhuī't. A'yuj hui'xina'n huā'yanā'tit, pero natzincspalayā'tit lā' nakalhpūtīpalayā'tit. Palh naquilākalhlaka'ī'yāuj lā' naquilā'a'kahuāna'ni'yāuj, hui'xina'n tū' caticāsputni'ni' tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iccāhuanintza' hui'xina'n laktzī'nī'ta'ntit huan lhūhua' lē'cnīn a'ntū ictlahualh. Lā' tū' kalhlaka'ī'yā'tit a'yuj laktzī'nī'ta'ntit. ");
INSERT INTO tooNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ixlīhuākca'n a'ntī nacāmāpuhuanī quinTāta' que naquinta'a'kahuāna'ni'cu'tun, xlaca'n naquintastālani'. Lā' a'ntī naquintastālani'cu'tun tū' icticāmāspi'tli. ");
INSERT INTO tooNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quit icminī'ta'ncha' nac a'kapūn para na'ictlahua ixtapuhuān a'ntī quimacamilh. Tū' ictlahua a'ntū xmān quintapuhuān. ");
INSERT INTO tooNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","QuinTāta' a'ntī quimacaminī't, xla' lacasqui'n que na'iccāmaktaka'lha ixlīhuākca'n a'ntī cāmāpuhuanī que naquintastālani'. Xla' lacasqui'n que na'iccāmālakahuanīchoko a'xni'ca' nachin a'ntū ā'xmān chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ixtapuhuān quinTāta' ū'tza' huā'mā': Ixlīhuākca'n a'ntī natahuan que quit ixO'kxa' Dios lā' naquintalīpāhuan, xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu; lā' quit na'iccāmālakahuanīchoko a'xni'ca' nachin a'ntū ā'xmān chi'chini' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Lā' huan israelitas tatzuculh talīchihuīna'n Jesús. Tū' cāminī'ni'lh a'nchī hualh Jesús: “Quit huan Līhua't. Quit icmincha' nac a'kapūn”. ");
INSERT INTO tooNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Lā' talāhuanilh: ―¿Chu tū' ū'tza' ixo'kxa' José huā'mā' Jesús? Quina'n lakapasāuj ixtāta' lā' ixtzī't. Lā' ¿a'chī' quincāhuaniyāni' chuhua'j palh minī'ta'ncha' nac a'kapūn? ");
INSERT INTO tooNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Lā' Jesús cāhuanilh: ―Tū' cachihuī'na'ntit chuntza'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Dios ū'tza' a'ntī cāmāpuhuanī tachi'xcuhuī't que naquintastālani' lā' xmān chuntza' natatapa'ksī con quit. Lā' quit na'iccāmālakahuanīchoko a'xni'ca' nachin a'ntū ā'xmān chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na ixtachihuīn Dios a'nlhā tatzo'kli profetas, chuntza' tatzo'kni': Dios nacāmāsu'ni' ixlīhuākca'n tachi'xcuhuī't. Ixlīhuākca'n a'ntī takaxmata ixtachihuīn quinTāta' lā' chuntza' tasca'ta, xlaca'n naquintastālani'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Nīn tintī' laktzī'nī't quinTāta'. Xmān quit iclaktzī'nī't, como icminī'ta'ncha' a'nlhā hui'lacha' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ixlīstu'ncua' a'ntū iccāhuaniyāni'. A'ntī quintalīpāhuan, xlaca'n taka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Quit huan Līhua't a'ntū cāmaxquī' xasāsti' ixquilhtamacujca'n huan tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Minapapna'ca'n, xlaca'n ixtahua' huan maná a'xni'ca' ixtahui'lāna'ncha' nac cā'lhpi'mpi'li' ti'ya't. Lā' a'yuj ixtahua' huan maná, pero xlaca'n tanīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Quit iccālīkalhachihuīna'ni'mā'ni' huan Līhua't a'ntū minī'ta'ncha' nac a'kapūn. Quit huā'mā' Līhua't. A'ntī quintakalhlaka'ī' tū' maktin catitanīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Quit huan Līhua't a'ntū minī'ta'ncha' nac a'kapūn lā' a'ntū cāmaxquī' xasāsti' ixquilhtamacujca'n tachi'xcuhuī't. A'ntī natahua' huā'mā' Līhua't natatahui'la para pō'ktu. Huan Līhua't a'ntū na'iccāmaxquī', xla' ū'tza' quimacni'. Lā' na'icmāstā' para que nataka'lhī xasāsti' ixquilhtamacujca'n tachi'xcuhuī't ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Lā' huan israelitas tatzuculh talālacatāquī' lā' talāhuanilh: ―Lā' ¿chichū līlalh huā'mā' chi'xcu' naquincāmaxquī'yāni' ixmacni' para nahua'yāuj? ");
INSERT INTO tooNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Lā' Jesús cāhuanilh: ―Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Quit huan Chi'xcu' xala' Tālhmā'n. Palh hui'xina'n tū' nahua'yā'tit quimacni', lā' palh tū' nahua'yā'tit quinka'lhni', tū' catika'lhī'tit xasāsti' minquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A'ntī natahua' quimacni' lā' a'ntī natahua' quinka'lhni', xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n a'ntū para pō'ktu. Lā' quit na'iccāmālakahuanīchoko a'xni'ca' nachin huan ā'xmān chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quimacni' ū'tza' huan Xatzey Līhua't lā' quinka'lhni' ū'tza' a'ntū Xatzey Līko'tnuncan. ");
INSERT INTO tooNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","A'ntī natahua' quimacni' lā' a'ntī natalīko'tnun quinka'lhni', xlaca'n kēxtim naquintatā'latahui'la. ");
INSERT INTO tooNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quimacaminī't quinTāta' a'ntī xalakahuan. Quit xalakahuan porque quinTāta' xalakahuan. Lā' nā chuntza' na'iccāmālakahuanī a'ntī natahua' quimacni'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Quit huā'mā' Līhua't a'ntū mincha' nac a'kapūn. Xla' tū' hua'chi huan maná a'ntūn tahua'lh minapapna'ca'n. Lā' a'yuj minapapna'ca'n tahua'lh huan maná, pero xlaca'n tanīlh. A'ntī natahua' huā'mā' Līhua't a'ntū iccālīkalhachihuīna'ni'mā'ni', xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús hualh huā'mā' a'xni'ca' ixcāmāsu'ni'mā' nac huan lītokpān nac Capernaum. ");
INSERT INTO tooNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lā' a'xni'ca' takaxmatli huā'mā', lhūhua' a'ntī ixtakalhlaka'ī'mā'na ixlīmāsca'tin Jesús, xlaca'n talāhuanilh: ―Lej jicslīhua' huā'mā' a'ntū huan. Tū'tza' kaxmatcu'tunāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Lā' Jesús ixca'tzī que ī'sca'txtunu'nī'n ixtalīchihuīna'mā'na lā' tū' ixcāminī'ni' huan ixtachihuīn Jesús. Lā' xla' cākalhasqui'nīlh: ―¿Chā tū' cāminī'ni'yāni' a'ntū iccāhuaniyāni'? ");
INSERT INTO tooNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tuchū ixpuhuantit palh ixlaktzī'ntit huan Chi'xcu' xala' Tālhmā'n tā'kayāhuamā' a'nlhā pū'la ixui'lacha'? ");
INSERT INTO tooNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A'ntū iccāhuaniyāni', ū'tza' tū' huanicu'tun que stu'ncua' nahua'yā'tit quinquinit. Quinquinit tū' caticāmaxquī'ni' minquilhtamacujca'n. Huan Espíritu Santo ū'tza' tzē nacāmaxquī'yāni' xasāsti' minquilhtamacujca'n. A'ntū iccāhuanincus, ū'tza' māsu'yu a'nchī tzē nalīka'lhīyā'tit xasāsti' minquilhtamacujca'n a'ntū māstā' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Lā' huan makapitzīn de hui'xina'n tū' kalhlaka'ī'yā'tit. Jesús lanāntza' ixca'tzī tichū a'ntīn tū' natakalhlaka'ī' lā' tichū namacamāstā' xla'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lā' hualh: ―Lā' ū'tza' iccālīhuaninī'ta'ni'tza' que nīn tintī' tzē natapa'ksī con quit palh quinTāta' tū' namāpuhuanī que naquistālani'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lā' ū'tza' talīmakxtekli Jesús lhūhua' a'ntī ixtakalhlaka'ī'mā'na. Lā' tū'tza' ixtastālani'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lā' Jesús cākalhasqui'nīlh huan kalhacāujtu' ī'sca'txtunu'nī'n: ―¿Nā hui'xina'n quilāmakxtekcu'tunāuj? ");
INSERT INTO tooNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Lā' Simón Pedro kalhtīni'lh: ―Māpa'ksīni', lā' ¿tichūn tzē na'ictā'a'nāuj? Mintachihuīn ū'tza' māsu'yu chu a'nchī na'iclīka'lhīyāuj xasāsti' quinquilhtamacujca'n a'ntū para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Lā' quina'n ickalhlaka'ī'yāuj lā' quina'n icca'tzīyāuj que hui'x Cristo, hui'x ixO'kxa' Dios xalakahuan. ");
INSERT INTO tooNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Lā' Jesús cākalhtīlh: ―Quit iccālacsacni' minkalhacāujtu'ca'n. Lā' kalhatin de hui'xina'n xla' tā'scujatza' huan ko'ti'ti'. ");
INSERT INTO tooNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús ixlīchihuīna'mā' huan Judas Iscariote, ixo'kxa' Simón. Xla' a'ntī namacamāstā' Jesús, a'yuj ū'tza' ixlīkalhacāujtu' ixuanī't de huan sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lā' tuncan Jesús a'lh latā'kchoko nac Galilea. Tū'tza' ixlatā'kchokocu'tun nac Judea porque huan israelitas xalanī'n nac Judea ixtamaknīcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ixtapajtzūtēlhatza' huan cā'tani' a'ntū huanican ixla' mū'xta'ka' a'ntū ixtatlahua huan israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Huan chi'xcuhuī'n, ixtā'timīn Jesús, tahuanilh: ―Tū' titachokoya' huā'tzā'. Capittza' nac Judea para que chuntza' mintachi'xcuhuī't a'ntīn tahui'lāna'ncha' a'ntza', xlaca'n nā natalaktzī'n a'ntū tlahua'pā't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","A'ntī lacasqui'n que natalakapasa ixlīhuāk tachi'xcuhuī't, xla' tū' lakatzē'k catitlahualh catūhuā. Palh lej stu'ncua' a'ntū tla'hua'ya' hui'x, catla'hua' na ixlacapūnca'n de ixlīhuākca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lā' nīn ixtā'timīn tū' ixtakalhlaka'ī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Lā' Jesús cāhuanilh: ―Tūna'j chin huan chi'chini' a'xni'ca' na'ica'n nac Judea. Hui'xina'n tzē napinā'tit a'xni'ca' napincu'tunā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Huan tachi'xcuhuī't xalanī'n nac cā'quilhtamacuj tūla caticātaca'tzalaktzī'ni' hui'xina'n. Lā' quit quintaca'tzalaktzī'n porque quit icmāsu'yu palh tū' tzey a'ntū tatlahua xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Capintit hui'xina'n a'nlhā lamā' cā'tani'. Quit tūna'j icti'a'lh porque tūna'j chin huan chi'chini' a'ntū na'icpū'a'n quit. ");
INSERT INTO tooNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Lā' a'xni'ca' cāhuanikō'lh ixtā'timīn, xla' tachokolh nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Lā' a'xni'ca' ixta'a'nī'ttza' huan chi'xcuhuī'n, ixtā'timīn Jesús, nā xla' a'lh a'nlhā ixlamā' huan cā'tani'. Tū' cātā'a'lh huan ixtalhūhuā't tachi'xcuhuī't, xla' lakatzē'k a'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lā' huan israelitas lej ixtaputza Jesús a'nlhā ixlamā' huan cā'tani' lā' ixtalīkalhasqui'nīni'n: ―¿Lhachū lahuī' huan chi'xcu'? ");
INSERT INTO tooNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lā' lhūhua' a'ntī ska'lh ixtalīkalhachihuīna'mā'na. Makapitzīn ixtahuan: “Xla' lej tzeya chi'xcu'”. Lā' ā'makapitzīn ixtahuan: “Tū' tzey huā'mā' chi'xcu'; a'kxokonu'n”. ");
INSERT INTO tooNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Lā' ixlīhuākca'n tzē'k ixtalīkalhachihuīna'n porque ixtajicua'ni' huan israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lā' a'xni'ca' hua'chi i'tāt ixlamā' huan cā'tani', Jesús tanūlh huan nac xaka'tla' lītokpān lā' tzuculh cāmāsu'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Lā' huan israelitas lej talē'cnīlh lā' talāhuanilh: ―¿Chichū lej līca'tzī huā'mā' chi'xcu'? Tū' maktin estudiarlīnī't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Lā' Jesús cākalhtīlh: ―A'ntū icmāsu'yu quit tū' quē'cstu quintapāstacna'. Xla' ū'tza' ixtapāstacna' a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Palh catīhuā tlahuacu'tun a'ntū Dios lacasqui'n, xla' naca'tzī palh icmāsu'yu ixtapāstacna' Dios, lā' tū' xmān quintapāstacna'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A'ntī chihuīna'n xmān por ixtapāstacna', xla' lacasqui'n que ca'a'cnīni'ni'ca. A'ntī lacasqui'n que ca'a'cnīni'ni'ca a'ntī macaminī't, ū'tza' nahuan a'ntū ixlīstu'ncua'. Lā' tū' cati'a'kxokonu'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés cāmaxquī'ni' hui'xina'n huan ley. Lā' milīhuākca'n tū' tlōkentaxtūyā'tit huanmā' ley. ¿A'chī' quilāmaknīcu'tunāuj? ");
INSERT INTO tooNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Lā' huan tachi'xcuhuī't takalhtīlh: ―Hui'x chō'la chuya'ya'. ¿Tichū maknīcu'tunāni'? ");
INSERT INTO tooNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Lā' Jesús cāhuanilh: ―Milīhuākca'n lē'cnī'yā'tit por ixpālacata a'ntū ictlahualh huanmā' chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés cāmāsu'ni'ni' huan talanān a'ntū huanican circuncisión (a'yuj xapū'la huan quinapapana'ca'n chuntza' ixtatlahua). Lā' ū'tza' ixpālacata hui'xina'n līcircuncidarlīyā'tit kalhatin ska'ta' a'ntī xachi'xcu', a'yuj ū'tza' huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Chuntza' tlōkentaxtūyā'tit a'ntū hualh Moisés que nacircuncidarlīyā'tit kalhatin ska'ta' a'ntī xachi'xcu', a'yuj ū'tza' huan chi'chini' a'ntū pūjaxcan. Palh hui'xina'n chuntza' tlahua'yā'tit', lā' ¿a'chī' lē'kchipinā'tit hui'xina'n por icmātzeyīlh xa'nca huan ī'tza'ca' huanmā' chi'chini' a'ntū pūjaxcan? ");
INSERT INTO tooNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Hui'xina'n quilālīyāhuayāuj porque puhua'nā'tit que, chu a'nchī mileyca'n, tū' tzey a'ntū ictlahualh. A'xni'ca' nalīyāhua'yā'tit ā'chā'tin, tasqui'nī nalīyāhua'yā'tit chu a'nchī Dios lacasqui'n ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lā' tatzuculh takalhachihuīna'n a'ntī ixtahui'lāna' nac Jerusalén. Lā' talākalhasqui'nīlh: ―¿Chu tū' ū'tza' huā'mā' a'ntī putzacan para namaknīcan? ");
INSERT INTO tooNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","A'tzā' chihuīna'mā' na ixlacapūnca'n tachi'xcuhuī't lā' nīn tuntū' tahuanī huan pūchihuīna'nī'n. ¿Chu tapuhuan que huā'mā' chi'xcu' ū'tza' Cristo a'ntī Dios lacsacui'līnī't? ");
INSERT INTO tooNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","A'xni'ca' namin Cristo nīn tintī' catica'tzīlh a'nlhā naminācha'. Pero quina'n ca'tzīyāuj a'nlhā xala' huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús kaxmatli huā'mā' tachihuīn a'nlhā ixcāmāsu'ni'mā' nac xaka'tla' lītokpān. Lā' lej palha' chihuīna'lh: ―Hui'xina'n puhua'nā'tit que quilālakapasāuj lā' nā puhua'nā'tit que ca'tzīyā'tit a'nlhā xala' quit. Quit tū' icminī't por quimpātunca'tzi. A'ntī quimacaminī't xla' stu'ncua' lahuī'. Xla' tū' lakapasā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Lā' quit iclakapasa como icmincha' a'nlhā hui'lacha' xla', lā' ū'tza' quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tuncan ixtachī'lē'ncu'tun. Lā' nīn tintī' chi'palh porque tūna'j ixchā'n huan chi'chini' a'ntū napūchi'pacan. ");
INSERT INTO tooNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Lhūhua' tachi'xcuhuī't takalhlaka'ī'lh Jesús lā' tahualh: ―Lā' Cristo a'xni'ca' namin xla' tū' catitlahualh más lē'cnīn que huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lā' huan fariseosnu' takaxmatli a'nchī ska'lh ixtalīchihuīna'n Jesús huan tachi'xcuhuī't. Lā' huan fariseosnu' lā' huan xanapuxcu'nu' curasna' tamacā'lh ixpolicíasna'ca'n para natachī'lē'n Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Lā' a'xni'ca' talakmilh, Jesús cāhuanilh huan tachi'xcuhuī't: ―Tū'tza' makān ictilatahui'lalh con hui'xina'n. Tuncan na'iclaka'n a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hui'xina'n naquilāputzayāuj pero tū' quintilākaksui, como tūla catichipintit a'nlhā quit na'ica'n. ");
INSERT INTO tooNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Lā' huan israelitas talākalhasqui'nīlh: ―Lā' ¿lhachū na'a'n palh tūlalh catikaksui? Chō'la nacālaka'n huan israelitas a'ntīn tatā'lahui'lāna'ncha' huan griegos lā' nacāmāsu'ni' xlaca'n lā' nā huan griegos. ");
INSERT INTO tooNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Quincāhuanini': “Naquilāputzayāuj lā' tū' quintilākaksui, como tūla catichipintit a'nlhā na'ica'n quit”. ¿Tuchū huanicu'tun huā'mā' tachihuīn? ");
INSERT INTO tooNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lā' huan a'ntū ā'xmān chi'chini' ixla' huan cā'tani' ū'tza' más xaka'tla' chi'chini' de huan cā'tani'. Lā' huanmā' chi'chini' Jesús tāyalh lā' lej palha' hualh: ―Lā' a'ntīn takalhpūtī, caquintalakmilh lā' catako'tnūlh. ");
INSERT INTO tooNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","A'ntī quintakalhlaka'ī' nataka'lhī hua'chi mu'sni' na ixa'clhcunucca'n lā' natā'cxtuyāchi lhūhua' xcān a'ntū māstā' quilhtamacuj. Chuntza' tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús ixuanicu'tun huā'mā' que a'ntī natakalhlaka'ī', natamaklhtīni'n huan Espíritu Santo. Tūna'j ixmin huan Espíritu Santo porque Jesús tūna'j ixa'n nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Lā' a'xni'ca' huan tachi'xcuhuī't takaxmatli huā'mā', makapitzīn tahualh: ―Ixlīstu'ncua' huā'mā' Jesús ixa'cta'sana' Dios a'ntī naquincālakmināni'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Lā' ā'makapitzīn tahuampā: ―U'tza' huā'mā' Cristo. Lā' ā'makapitzīn tahuampā: ―¿Chichū līlalh huā'mā'? Cristo tū' catimincha' de nac Galilea. ");
INSERT INTO tooNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Huan Cristo nala ī'xū'yātā'nat David. Lā' ū'tza' natahui'la nac Belén a'nlhā xala' ixuanī't David. Chuntza' tatzo'kni' na ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Lā' ū'tza' tū' a'cxtim ixtalīpuhuan huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lā' huan makapitzīn ixtachī'lē'ncu'tun pero nīn tintī' chi'palh. ");
INSERT INTO tooNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Huan policías talaka'nchokopā huan fariseosnu' lā' huan xanapuxcu'nu' curasna'. Lā' cākalhasqui'nīca: ―Lā' ¿a'chī' tū' lī'ta'ntit? ");
INSERT INTO tooNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Lā' huan policías takalhtīni'lh: ―Tū' maktin ickaxmatāuj nīn kalhatin chi'xcu' a'ntī chihuīna'n hua'chi huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lā' huan fariseosnu' takalhtīni'lh: ―Chō'la nā hui'xina'n cāta'a'kxokochāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tū' kalhlaka'ī'nī't Jesús nīn kalhatin xapuxcu' lā' nīn kalhatin fariseo. ");
INSERT INTO tooNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Huan catīhuāya tachi'xcuhuī't tū' talakapasa ixley Dios. Lā' ū'tza' nacālīmālaclē'nī Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Lā' huan Nicodemo a'ntī ixlakminī't Jesús de tzī'sa, xla' nā fariseo ixuanī't. Lā' xla' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Tūla catimāpātīnīuj kalhatin chi'xcu' palh tū' pū'la naca'tzīyāuj a'ntū laclē'n lā' palh tū' pū'la namakxtekāuj nachihuīna'n. Chuntza' tatzo'kni' huan nac ley. ");
INSERT INTO tooNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Lā' huan ā'makapitzīn fariseosnu' tahuanilh Nicodemo: ―Chō'la nā hui'x xala' nac Galilea a'nlhā tahui'lāna'ncha' huāk catīhuāya chi'xcuhuī'n. Calakapūtle'ke ixtachihuīn Dios lā' naca'tzīya' que tū' maktin minī'ta'ncha' nac Galilea kalhatin ixa'cta'sana' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Lā' tuncan ta'a'lh na ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Lā' Jesús a'lh nac kēstīn a'nlhā ixuanican Olivos. ");
INSERT INTO tooNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Lā' ixlīlakalī lej tzi'sāt Jesús a'mpā nac xaka'tla' lītokpān. Lā' ixlīhuāk tachi'xcuhuī't talakminkō'lh. Lā' xla' tahui'lalh lā' tzuculh cāmāsu'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Huan fariseosnu' lā' huan mākalhtō'kē'ni'nī'n de huan ley talīmini'lh Jesús kalhatin puscāt. Lā' huan puscāt ixchi'paquī'canī't con kalhatin ixmakchi'xcu'. Lā' yāhuaca a'ntza' na ixlaclhpu'nanca'n a'ntī ixtahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Lā' tahuanilh Jesús: ―Mākalhtō'kē'ni', huā'mā' puscāt chi'paquī'canī't con kalhatin ixmakchi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lā' huan ley a'ntū quincāmaxquī'nī'ta'ni' Moisés, ū'tza' quincāmāpa'ksīyāni' que nacucta'lamaknīyāuj kalhatin puscāt a'ntī la chuntza'. Lā' hui'x, ¿chī hua'na'? ");
INSERT INTO tooNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xlaca'n tahuanilh Jesús huā'mā' chu xmān para natalīlaktzī'n para que chuntza' tzē natamālacapū'. Lā' Jesús taquilhpūtalh lā' tzuculh tzo'knun nac cā'ti'ya'tna' con ixmakspulh. ");
INSERT INTO tooNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Lā' ā'chulā' ixtakalhasqui'nī lā' xla' tā'cstu'ncli lā' cāhuanilh: ―Kalhatin de hui'xina'n a'ntīn tuntū' laclē'n ū'tza' xapū'lh camūta'lalh huan puscāt. ");
INSERT INTO tooNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Lā' Jesús taquilhpūtapā lā' chu tzo'knumpā nac cā'ti'ya'tna' con ixmakspulh. ");
INSERT INTO tooNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lā' a'xni'ca' takaxmatli huā'mā', nā xlaca'n ta'u'cxca'tzīlh palh nā ixtalaclē'n. Lā' tatzuculh ta'a'n a'ntī más lacpapatzīnī'n lā' huan makapitzīn chā'tunu' chā'tunu' ta'a'ntēlhalh hasta lhā ta'a'nkō'lh ixlīhuākca'n. Lā' Jesús tachokolh lā' huan puscāt nā ixyācus. ");
INSERT INTO tooNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Lā' Jesús tā'cstu'ncli lā' kalhasqui'nīlh: ―¿Lhachū tayāna' a'ntī ixtalē'ksa'nīni'mā'ni'? ¿Tichū huan palh natamaknīyāni' por mintalaclē'i'? ");
INSERT INTO tooNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Lā' xla' hualh: ―Nīn tintī' huan chuntza', Māpa'ksīni'. Jesús huanilh: ―Pues nīn quit tū' icuan palh natamaknīyāni'. Capit lā' nīn tuntū'tza' titlahua'ya' a'ntū ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús cātā'chihuīna'mpā huan tachi'xcuhuī't lā' cāhuanilh: ―Quit iccāmāsu'ni' huan tachi'xcuhuī't. Chuntza' quit hua'chi lakatin xkakana'. Lā' a'ntī naquintastālani' quit, xlaca'n tū' catitalatā'kchokolh a'nlhā cā'pucsua' como quit na'iccāmakskoni' ixtejca'n. Lā' na'iccāmaxquī' xasāsti' ixquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lā' huan fariseosnu' tahuanilh: ―Hui'x mālacstū'ncca' mē'cstu. Lā' chuntza' nīn tuntū' ixtapalh a'ntū hua'na'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús cākalhtīlh: ―Quit a'ntū icuan, ū'tza' ixlīstu'ncua' a'yuj quit quē'cstu quimālacstū'nccan. Lā' quit icca'tzī a'nlhā icminī'ta'ncha' lā' a'nlhā ica'mā'. Pero hui'xina'n tū' ca'tzīyā'tit a'nlhā icmincha' lā' a'nlhā ica'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Hui'xina'n lē'ksa'nanā'tit lā' tū' ca'tzīyā'tit ixpālacata. Chuntza' talē'ksa'nan tachi'xcuhuī't. Lā' quit tū' iclacāxtlahua nīn chā'tin. ");
INSERT INTO tooNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Palh quit xa'iclacāxtlahualh, xa'iclacāxtlahualh chu a'nchī ixlīstu'ncua'. Quit tū' quē'cstu iclacāxtlahua. QuinTāta' a'ntī quimacaminī't ū'tza' quintā'lacāxtlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chuntza' tatzo'kni' na mileyca'n: A'xni'ca' kalhatu' chi'xcuhuī'n a'cxtim tamālacstū'nca, ū'tza' huā'mā' ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Quit icmālacstū'nca quē'cstu. Lā' hui'lapā ā'kalhatin a'ntī mālacstū'nca de quit. Lā' ū'tza' a'ntī quinTāta' lā' ū'tza' quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lā' takalhasqui'nīlh: ―Lā' ¿lhachū hui'lacha' mintāta'? Jesús cākalhtīlh: ―Hui'xina'n tū' quilālakapasāuj lā' nā tū' lakapasā'tit a'ntī quinTāta'. Palh ixquilālakapasui cahuā quit, nā quinTāta' ixlakapastit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Lā' Jesús hualh huā'mā' a'xni'ca' ixmāsu'yumā' nac xaka'tla' lītokpān a'nlhā ixmāquī'can huan tumīn. Lā' nīn tintī' puhualh nachī'lē'n porque tūna'j ixchā'ni' ixquilhtamacuj a'ntū napūchī'lē'ncan. ");
INSERT INTO tooNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Lā' Jesús chu ā'maktin cāhuanipā: ―Quit na'ica'n. Lā' hui'xina'n naquilāputzayāuj. Lā' a'xni'ca' nanīyā'tit hui'xina'n naka'lhī'yā'titcus mintalaclē'i'ca'n. Lā' hui'xina'n tūlalh catipintit a'nlhā na'ica'n quit. ");
INSERT INTO tooNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huan israelitas tahualh: ―Chō'la namaknīcan ixa'cstu lā' ū'tza' līhualh tūlalh cati'a'uj a'nlhā na'a'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Lā' Jesús cāhuanilh: ―Hui'xina'n xalanī'n ā'tzā' nac ti'ya't, lā' quit xala' nac tālhmā'n. Hui'xina'n xalanī'n huā' nac cā'quilhtamacuj lā' quit tū' xala' huā' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Lā' ū'tza' iccālīhuanini' hui'xina'n que a'xni'ca' nanīyā'tit naka'lhī'yā'titcus mintalaclē'i'ca'n. Hui'xina'n tū' kalhlaka'ī'yā'tit a'xni'ca' iccāhuaniyāni' a'ntīn quit. Chuntza' naka'lhī'yā'titcus mintalaclē'i'ca'n a'xni'ca' nanīyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lā' tuncan takalhasqui'nīlh: ―¿Tichū hui'x? Lā' Jesús cākalhtīlh: ―Iccāhuaninī'ta'ntza' xapū'la. ");
INSERT INTO tooNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Quit tzē na'icuan lhūhua' por mimpālacataca'n lā' tzē na'iclacāxtlahua lhūhua' catūhuā a'ntū tlahuapā'na'ntit a'ntūn tū' tzey. A'ntī quimacaminī't, xla' huan a'ntū ixlīstu'ncua'. Lā' a'ntū quihuanī, xmān ū'tza' iccāhuanī huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Lā' xlaca'n tū' tamāchekxīlh que Jesús ixlīchihuīna'mā' Dios, xaTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lā' ū'tza' cālīhuanilh Jesús: ―Lā' a'xni'ca' hui'xina'n naquilāmā'ca'yāuj tālhmā'n quit, hasta a'xni'ca' naca'tzīyā'tit tichūn quit. Lā' quit huan Chi'xcu' xala' Tālhmā'n. Lā' naca'tzīyā'tit que quit tuntū' ictlahua quē'cstu. Xmān icuan a'ntū quimāsu'ni'nī't quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","A'ntī quimacamilh, xla' huī' con quit. Lā' tū' quimakxteknī't quē'cstu, porque quit pō'ktu ictlahuamā' a'ntū ixtapuhuān. ");
INSERT INTO tooNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lā' a'xni'ca' Jesús hualh huā'mā', lej lhūhua' a'ntīn takalhlaka'ī'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Lā' Jesús cāhuanilh huan israelitas a'ntī ixtakalhlaka'ī'mā'nacus: ―Hui'xina'n palh na'a'kahuāna'ni'yā'tit quintachihuīn, lā' chuntza' nalītalacsu'yu'yā'tit palh hui'xina'n lej stu'ncua' quisca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Lā' nalakapasā'tit a'ntū ixlīstu'ncua'. Lā' por ixpālacata a'ntū ixlīstu'ncua' nala'yā'tit libres. ");
INSERT INTO tooNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Lā' xlaca'n takalhtīlh: ―Quina'n ī'xū'yātā'natna' Abraham. Lā' nīn tintī' maktin quincātamāscujūnī'ta'ni' hua'chi ixtatamāuj. Lā' ¿a'chī' hua'na' hui'x que na'iclayāuj libres? ");
INSERT INTO tooNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Lā' Jesús cāhuanilh: ―Stu'ncua' a'ntū iccāhuaniyāni'. A'ntī tlahua talaclē'i', ū'tza' xla' hua'chi kalhatin tasācua' a'ntīn tamāhuacanī't, como tūla makxteka ixtalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huan xatatamāuj tasācua' tū' hua'chi a'ntī scana'nca xa'o'kxa'. Huan xatatamāuj tū' pō'ktu catitahui'lalh na ixchic ixtēcu' como nastā'palacan. A'ntī scana'nca ixo'kxa' kalhatin chi'xcu', xla' para pō'ktu ixo'kxa'. Lā' tū' catistā'ca. ");
INSERT INTO tooNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hui'xina'n hua'chi a'ntī xatatamāuj como tūla makxtekā'tit mintalaclē'i'ca'n. Lā' ixO'kxa' Dios tzē nacāmaktāyayāni' hui'xina'n para namakxtekā'tit mintalaclē'i'ca'n. Lā' chuntza' tū'tza' nalayā'tit hua'chi xatatamāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lā' a'yuj hui'xina'n ī'xū'yātā'natna' Abraham, pero quilāmaknīcu'tunāuj porque tū' kalhlaka'ī'yā'tit a'ntū iccāhuaniyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Quit iclīchihuīna'n a'ntū quimāsu'ni'nī't quinTāta'. Lā' hui'xina'n tlahua'yā'tit a'ntū cāhuaninī'ta'ni' mintāta'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Lā' xlaca'n takalhtīlh: ―Quintāta'ca'n, xla' ū'tza' Abraham. Lā' Jesús cāhuanilh: ―Palh stu'ncua' cahuā hui'xina'n ixcamana' Abraham nā chuntza' ixtlahua'tit chu a'nchī ixtlahua Abraham. ");
INSERT INTO tooNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Hui'xina'n quilāmaknīcu'tunāuj a'yuj quit iccāhuaniyāni' a'ntū ixlīstu'ncua' a'ntū Dios quimāsu'ni'nī't. Abraham tū' chuntza' ixtlahua hua'chi hui'xina'n tlahua'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Hui'xina'n tlahua'pā'na'ntit a'ntū tlahua mintāta'ca'n. Lā' xlaca'n tahuanilh: ―Quina'n tū' makcamanna'. Icka'lhīyāuj xmān kalhatin quintāta'ca'n lā' ū'tza' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Lā' Jesús cāhuanilh: ―Palh mintāta'ca'n cahuā Dios, hui'xina'n ixquilāpāxquī'uj porque quit icminī'ta'ncha' a'nlhā xa'ictā'lahui'lacha' Dios lā' chuhua'j ā'tzā' iclahuī'. Quit tū' icmilh xmān por quimpātunca'tzi. Dios ū'tza' a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hui'xina'n tū' kaxpa'tcu'tunā'tit a'ntū icuan. U'tza' tū' līmāchekxī'yā'tit a'ntū iccāhuanimā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","’Mintāta'ca'n hui'xina'n ū'tza' huan ko'ti'ti'. Hui'xina'n tlahuacu'tunā'tit ixtapuhuān huan ko'ti'ti'. Huan ko'ti'ti' xla' ū'tza' lanī't maknīni' desde xapū'la. Xla' tū' maktin pāstaca a'ntū ixlīstu'ncua' como tū' lakatī a'ntū ixlīstu'ncua'. Xla' chihuīna'n huāk tā'ksa'nīn como xla' chuntza' ixtāyat. Xla' lej a'ksa'nīni' lā' xla' ū'tza' mā'a'nanīlh tā'ksa'nīn. ");
INSERT INTO tooNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Quit iccāhuaniyāni' a'ntū ixlīstu'ncua' lā' hui'xina'n tū' quilākalhlaka'ī'yāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Lā' ¿tichū de hui'xina'n tzē nahuan palh quit ictlahuanī't a'ntūn tū' tzey? Lā' palh quit huan a'ntū ixlīstu'ncua', lā' ¿a'chī' tū' quilākalhlaka'ī'yāuj? ");
INSERT INTO tooNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Huan a'ntī ixla' Dios kaxmata ixtachihuīn Dios. Hui'xina'n tū' ixla' Dios. Lā' ū'tza' tū' līkaxpa'tcu'tunā'tit ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Lā' huan israelitas tahuanilh: ―Stu'ncua' a'nchī icuáuj que hui'x samaritano lā' ka'lhī'ya' huan espíritu a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Lā' Jesús cākalhtīlh: ―Tū' icka'lhī huan espíritu a'ntūn tū' tzey. Quit ica'cnīni'ni' quinTāta' lā' hui'xina'n quilālīlakmaka'nāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Lā' quit tū' quimaca'tzi palh quilā'a'cnīni'ni'yāuj o tū'. Huī' kalhatin a'ntī lacasqui'n que caqui'a'cnīni'ni'ca, ū'tza' a'ntī nalacāxtlahuakō'. ");
INSERT INTO tooNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ixlīstu'ncua' a'ntū iccāhuaniyāni': A'ntī natatlōkentaxtū quintachihuīn xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n a'ntūn tū' maktin catisputli. ");
INSERT INTO tooNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Lā' huan israelitas takalhtīni'lh: ―Quina'n icca'tzīyāujtza' que ka'lhī'ya' huan espíritu a'ntūn tū' tzey. Abraham nīlhtza' lā' nā tanīlhtza' ixa'cta'sana'nī'n Dios. Lā' hui'x hua'na' que a'ntī natatlōkentaxtū mintachihuīn tū' maktin catitasputli. ");
INSERT INTO tooNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Lā' ¿chu hui'x más xaka'tla' que quintāta'ca'n Abraham? Xla' nīlh lā' huan a'cta'sana'nī'n nā tanīlh. Lā' hui'x ¿tichū palh tū' catinīt? ");
INSERT INTO tooNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Lā' Jesús cākalhtīlh: ―Palh quit quē'cstu qui'a'cnīni'ni'can, nīn tuntū' ixtapalh. A'ntī qui'a'cnīni'ni' quit, xla' ū'tza' quinTāta' chu ū'tza' a'ntī hui'xina'n huani'yā'tit minDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Lā' ū'tza', a'ntī hua'nā'tit minDiosca'n, tū' lakapasā'tit hui'xina'n. Lā' quit iclakapasa. Palh quit cahuā xa'icualh tū' iclakapasa, quit xa'iclalh kalhatin a'ksa'nīni' hua'chi hui'xina'n. Lā' quit stu'ncua' iclakapasa lā' quit ica'cnīni'ni' ixtachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham a'ntī mimpapca'n ka'lhīlh tapāxuhuān porque xla' ixca'tzī palh nalaktzī'n a'xni'ca' xa'icmilh nac quilhtamacuj. Xla' laktzī'lh lā' līpāxuhualh. ");
INSERT INTO tooNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lā' huan israelitas tahuanilh Jesús: ―Hui'x tūna'j ka'lhī'ya' nīn pūpitzi ciento cā'ta, lā' ¿chī līhua'na' palh laktzī'nī'ta' Abraham? ");
INSERT INTO tooNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Lā' Jesús cākalhtīlh: ―Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Quit lanāntza' xa'icuī' a'xni'ca' tūna'j ixlacatuncuī Abraham. ");
INSERT INTO tooNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lā' chu tuncan tasacli chihuix lā' ixtalīmūta'lacu'tun. Lā' Jesús cātatzē'kni'lh lā' chuntza' taxtulh de huan xaka'tla' lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Lā' a'xni'ca' Jesús ixlatlā'huan, laktzī'lh huan kalhatin chi'xcu' a'ntī ixlacatuncuīnī't xalakatzī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Lā' ī'sca'txtunu'nī'n takalhasqui'nīlh: ―Māpa'ksīni', lā' ¿a'chī' tahui'lalh lakatzī'n huā'mā' chi'xcu'? ¿Chu ixpālacata ixtalaclē'i'ca'n ixtāta' lā' ixtzī't, o ixpālacata ixtalaclē'i' huan lakatzī'n? ");
INSERT INTO tooNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Lā' Jesús cāhuanilh: ―Tū' por ixpālacata ixtalaclē'i' huan lakatzī'n lā' nīn ixtalaclē'i'ca'n ixtāta' lā' ixtzī't. Xla' lacatuncuīlh xalakatzī'n para que chuntza' tzē nalīmālacsu'yu ixlīmāpa'ksīn Dios a'xni'ca' namātzeyīcan. ");
INSERT INTO tooNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","A'xni'ca' xkakacus, tzē scujcan; pero a'xni'ca' tzī'suamā'tza', tūlalhtza' catiscujca. Lā' nā chuntza' quina'n, tasqui'nī natlahuayāuj chuhua'j ixlītlōt a'ntī quimacaminī't. Namin lakatin chi'chini' a'xni'ca' na'icnī lā' tūlalhtza' ictiscujli. ");
INSERT INTO tooNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quit iccāmakskoni' huan tachi'xcuhuī't līhuan iclahuī' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Lā' a'xni'ca' hualh huā'mā' Jesús chojnu'lh nac ti'ya't. Lā' tlahualh macsti'na'j pūtlū'n lā' līlacatlahualh na ixlakastapun huan lakatzī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Lā' huanilh: ―Capinchi huan nac xcān a'nlhā huanican Siloé lā' nalakacha'ka'na' ―Siloé huanicu'tun Macamincanī't. Lā' huan lakatzī'n a'lh lā' a'ntza' lakacha'ka'lh. Lā' a'xni'ca' chimpā, tzētza' ixlacahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lā' huan ixtā'macchicni' lā' a'ntī ixtalaktzī'nī't xapū'la a'xni'ca' lakatzī'n ixuanī't, xlaca'n talāhuanilh: ―¿Chu tū' ū'tza' huā'mā' chi'xcu' a'ntī ixtahui'la ī'squi'nīhuā'yan? ");
INSERT INTO tooNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Makapitzīn ixtahuan: ―U'tza'. Lā' ā'makapitzīn huampala ixtahuan: ―Tū' ū'tza'. Hua'chi ū'tza' lītasu'yu. Huan chi'xcu' māni' ū'tza' hualh: ―Quit huan chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Lā' takalhasqui'nīlh: ―Lā' ¿chichū līlalh tzētza' lacahuāna'na' hui'x? ");
INSERT INTO tooNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Lā' xla' cākalhtīlh: ―U'tza' huan chi'xcu' a'ntī ixtacuīni' Jesús tlahualh pūtlū'n lā' quilīlacatlahualh na quilakastapun. Lā' quihuanilh: “Capinchi huan nac xcān a'nlhā huanican Siloé lā' calakacha'ka'”. Ica'lh lā' a'xni'ca' iclakacha'ka'nkō'lh, tzētza' iclacahuāna'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Lā' takalhasqui'nīlh: ―Lā' ¿lhachū huī' huanmā' chi'xcu'? Lā' xla' cāhuanilh: ―Tū' icca'tzī. ");
INSERT INTO tooNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lā' cālīmini'ca huan fariseosnu' huan chi'xcu' a'ntī lakatzī'n ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Lā' huan chi'chini' a'ntū pūtlahualh pūtlū'n Jesús lā' pūmātzeyīlh huan lakatzī'n, ū'tza' huan chi'chini' a'ntū pūjaxcan. ");
INSERT INTO tooNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lā' huan fariseosnu' chu ā'maktin takalhasqui'nīpā: ―¿Chichū līlacahuā'na'? Lā' xla' cākalhtīlh: ―Quilīlacatlahualh pūtlū'n na quilakastapun lā' iclakacha'ka'lh lā' chuhua'j quit tzē iclacahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lā' makapitzīn de huan fariseosnu' tahualh: ―Huā'mā' chi'xcu' tū' ixla' Dios porque tū' a'cnīni'ni' huan chi'chini' a'ntū pūjaxcan. Lā' ā'makapitzīn tahuampā: ―A'ntī tlahua talaclē'i', xla' tū' catitlahualh lē'cnīn a'nchī tlahua huā'mā' chi'xcu'. Lā' tū' chu lakatin ixtapuhuānca'n ixtaka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lā' chu takalhasqui'nīpā huan chi'xcu' a'ntī lakatzī'n ixuanī't: ―Lā' hui'x ¿chichū hua'na' de huan chi'xcu' como hui'x a'ntī mālacahuānīni'? Lā' xla' hualh: ―Xla' ixa'cta'sana' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Lā' huan israelitas, xlaca'n tū' takalhlaka'ī'lh palh lakatzī'n ixuanī't lā' palh mālacahuānīca. Lā' cāta'sani'ca ixtāta' lā' ixtzī't huan chi'xcu' a'ntī lakatzī'n ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Lā' cākalhasqui'nīca: ―¿Chā ū'tza' huā'mā' chi'xcu' mi'o'kxa'ca'n? ¿Chā lacatuncuīlh xalakatzī'n? Lā' ¿chichū tzētza' līlacahuāna'n chuhua'j? ");
INSERT INTO tooNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lā' ixtāta' lā' ixtzī't takalhtīni'lh: ―Quina'n icca'tzīyāuj palh qui'o'kxa'ca'n. Lā' icca'tzīyāuj que a'xni'ca' lacatuncuīlh lanān lakatzī'n ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Tū' icca'tzīyāuj chichū tzētza' līlacahuāna'n chuhua'j. Lā' tū' icca'tzīyāuj a'ntī mālacahuānīlh. Cakalhasqui'nī'tit ū'tza'; xla' chuhua'j chi'xcu'tza'. Māni' ū'tza' tzē nacāhuaniyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ixtāta' lā' ixtzī't tahualh chuntza' porque xlaca'n ixtajicua'ni' huan israelitas. Lā' huan israelitas talacchihuīna'lh que namātuxtekēcan de huan nac xaka'tla' lītokpān a'ntī nahuan que Jesús ū'tza' Cristo. ");
INSERT INTO tooNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lā' ū'tza' talīhualh ixtāta' lā' ixtzī't: “Cakalhasqui'nī'tit ū'tza'; xla' chuhua'j chi'xcu'tza'”. ");
INSERT INTO tooNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Lā' huan israelitas chu tata'sani'pā ixlīmaktu' huan chi'xcu' a'ntī lakatzī'n ixuanī't lā' tahuanilh: ―Caquilāhuaniuj ixlīstu'ncua' na ixlacapūn Dios. Quina'n icca'tzīyāuj que huā'mā' chi'xcu' lej tlahua talaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Xla' cākalhtīlh: ―Quit tū' icca'tzī palh tlahua talaclē'i'. Xmān icca'tzī quit xapū'la lakatzī'n xa'icuanī't lā' chuhua'j iclacahuāna'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Lā' chu kalhasqui'nīpalaca: ―¿Tuchūn tlahuani'ni'? ¿Chichū līmālacahuānīni'? ");
INSERT INTO tooNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Lā' xla' cākalhtīlh: ―Iccāhuani'ntza'. Lā' hui'xina'n tū' ixkaxpa'tcu'tunā'tit. ¿A'chī' lacasqui'nā'tit na'iccāhuanipalayāni'? Chō'la nā stālani'cu'tunā'tit nā hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Lā' talakapalalh lā' tahuanilh: ―Hui'x stālani'ya' huanmā' chi'xcu'. Quina'n icstālani'yāuj Moisés. ");
INSERT INTO tooNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Icca'tzīyāuj que Dios tā'chihuīna'lh Moisés. Lā' huā'mā' Jesús tū' icca'tzīyāuj lhachū minī'ta'ncha'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Lā' huan chi'xcu' cākalhtīlh: ―¿Chichū līlalh huā'mā'? Hui'xina'n tū' ca'tzīyā'tit lhachū mincha' huan chi'xcu'. Lā' ū'tza' a'ntī quimālacahuānīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Quina'n ca'tzīyāuj que Dios tū' cākaxmata a'ntīn tatlahua talaclē'i'. Dios cākaxmata a'ntī ta'a'cnīni'ni' xla' lā' a'ntīn tatlahua a'ntū ixtapuhuān Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde a'xni'ca' ixlītzucuni' quilhtamacuj, tū' maktin kaxmatca palh kalhatin chi'xcu' mālacahuānī huan a'ntī lacatuncuī xalakatzī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Palh tū' cahuā Dios macaminī't, tūlalh ixtlahualh catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lā' tahuanilh: ―Hui'x lacatuncui' con mintalaclē'i'. ¿Chu naquilāmāsca'tīyāuj quina'n? Lā' tamacaxtuca kēpūn. ");
INSERT INTO tooNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús huanica palh ixtamacaxtucanī't huan chi'xcu' a'ntī lakatzī'n ixuanī't. Lā' a'xni'ca' tā'lāpāxtokli, huanilh: ―¿Chā kalhlaka'ī'ya' hui'x huan ixO'kxa' Dios? ");
INSERT INTO tooNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Lā' huan chi'xcu' huanilh: ―Lā' ¿tichū xla'? Caquihua'ni' para que chuntza' quit na'ickalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Lā' Jesús kalhtīlh: ―Hui'x laktzī'nī'ta'tza'. Lā' ū'tza' a'ntī tā'chihuīna'mā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Lā' huan chi'xcu' taquilhpūtani'lh lā' huanilh: ―Māpa'ksīni', ickalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Lā' Jesús hualh: ―Quit icmilh nac quilhtamacuj para que chuntza' natasu'yu a'ntīn takalhlaka'ī' lā' a'ntīn tū' takalhlaka'ī'. Quit icmilh nac quilhtamacuj para na'iccāmālacahuānī a'ntī xalakatzī'nī'n lā' icmilh para na'iccāmālakatzī' a'ntīn talacahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Lā' makapitzīn fariseosnu' ixtayāna' ixpajtzu. Lā' a'xni'ca' takaxmatli huā'mā', tahualh: ―Lā' ¿chu quina'n iclakatzī'yāuj? ");
INSERT INTO tooNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Lā' Jesús cāhuanilh: ―Palh lakatzī'n cahuā hui'xina'n, tū' ixlīpintit cuenta hui'xina'n por mintalaclē'i'ca'n. Como hua'nā'tit hui'xina'n que lacahuānā'tit, pues hui'xina'n līpinā'tit cuenta. ");
INSERT INTO tooNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Lā' Jesús cāhuanipā: ―Stu'ncua' a'ntū iccāhuaniyāni': A'ntī lacatin tanū na ixchicca'n borregos lā' tū' lactanū a'nlhā yā xamākalhcha ū'tza' ka'lhāna'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Lā' a'ntī lactanū a'nlhā yā xamākalhcha, ū'tza' xamaktaka'lhna' borregos. ");
INSERT INTO tooNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Lā' a'ntī maktaka'lha mākalhcha ū'tza' mālaquī'ni' huan xamaktaka'lhna' borregos. Lā' huan borregos takaxmata ixtachihuīn. Lā' cāmāta'sī lakatunu' con ixtacuīni'ca'n a'ntū ixborrego xla'. Lā' cāmāxtu de huan ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lā' a'xni'ca' cāmāxtukō' xla' cāpū'lani'. Lā' huan borregos tastālani' como xlaca'n takalhlakapasatza' ixtachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Lā' tū' catitastālani'lh ā'chā'tin chi'xcu'. Tū' natastālani' porque tū' takalhlakapasa ixtachihuīn. Natatzā'lani'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Lā' Jesús cāhuanilh huā'mā' tachihuīn hua'chi lītalacastuca. Xlaca'n tū' tamāchekxīlh a'ntū ixcāhuanicu'tuncan. ");
INSERT INTO tooNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lā' Jesús chu cāhuanipā: ―Lej ixlīstu'ncua' a'ntū iccāhuaniyāni'. Quit hua'chi mākalhcha a'nlhā talactanū huan borregos. ");
INSERT INTO tooNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ixlīhuākca'n a'ntī quintitapū'lani'lh, xlaca'n ū'tza' ka'lhāna'nī'n. Lā' huan borregos tū' ta'a'kahuāna'ni'lh huan ka'lhāna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Quit hua'chi huan mākalhcha. A'ntī naquintakalhlaka'ī', xlaca'n natapūtaxtu. Lā' na'iccāmaktaka'lha hua'chi cāmaktaka'lhcan borrego a'ntū natataxtu lā' natakaksa ixlīhua'tca'n lā' chu natatanūpala. ");
INSERT INTO tooNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Lā' huan ka'lhāna' xla' xmān min ka'lhāna'n lā' maknīni'n lā' mālakuanīni'n. Quit icminī't para na'iccāmaxquī' xasāsti' ixquilhtamacujca'n a'ntū más xatzey quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Quit hua'chi xatzey maktaka'lhna' borregos. Huan a'ntī lej xatzey maktaka'lhna' xla' lej xa'nca cāmaktaka'lha ixborregos lā' a'yuj calīnīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Lā' huan a'ntī xmān tasācua', a'xni'ca' laktzī'n mimā' huan lobo, cāmakxteka huan borregos lā' tzā'latāquī' como tū' scana'nca maktaka'lhna' lā' tū' ixla' huan borregos. Lā' chu tuncan huan lobo cāchi'pa huan borregos lā' cāmakatzā'lakō'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Huan tasācua' tzā'la porque xmān tasācua' lā' tū' ixla' huan borregos, lā' xla' tū' ixmaca'tzi. ");
INSERT INTO tooNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Quit hua'chi xatzey maktaka'lhna' borregos. Como xatzey maktaka'lhna' cālakapasa ixborregos, quit iccālakapasa quintachi'xcuhuī't, lā' nā xlaca'n quintalakapasa. ");
INSERT INTO tooNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Lā' nā chuntza' huan xaTāta' quilakapasa quit, lā' nā quit iclakapasa. Lā' quit na'iclīnī por quintachi'xcuhuī't chuntza' hua'chi huan maktaka'lhna' borregos līnī por ixborregos. ");
INSERT INTO tooNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Hui'lapā ā'makapitzīn tachi'xcuhuī't. Xlaca'n hua'chi borregos a'ntūn tū' xalanī'n huā'mā' na ixchic. Tasqui'nī na'iccālīmin nā xlaca'n. Lā' xlaca'n nā nata'a'kahuāna'ni' quintachihuīn. Lā' chuntza' xlaca'n chu lakatin natala con a'ntī lanān quila'. Lā' xmān kalhatin xamaktaka'lhna' nala. ");
INSERT INTO tooNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’QuinTāta' quimpāxquī' porque iclīmāstā' quinquilhtamacuj lā' quit na'ictēpala quinquilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Lā' nīn tintī' quintimaklhtīlh quinquilhtamacuj. Quit icmāstā' porque icmāstā'cu'tun. Quit icka'lhī talacasqui' para que tzē na'icmāstā' lā' icka'lhī talacasqui' para que tzē na'ictēchokopala. Chuntza' quilīmāpa'ksīlh quinTāta' ―hualh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lā' a'xni'ca' huan israelitas takaxmatli huā'mā' tachihuīn lā' tū'tza' chu lakatin talīpāstacna'mpā. ");
INSERT INTO tooNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Makapitzīn ixtahuan: ―Lā' ¿a'chī' tlahuani'yā'tit cuenta huā'mā' chi'xcu' palh ka'lhī espíritu a'ntūn tū' tzey, lā' xla' chuya? ");
INSERT INTO tooNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Lā' ā'makapitzīn huampala tahualh: ―A'ntī ka'lhī espíritu a'ntūn tū' tzey, xla' tūlalh catichihuīna'lh chuntza'. ¿Chu tzē namālacahuānī kalhatin lakatzī'n huan espíritu a'ntūn tū' tzey? ");
INSERT INTO tooNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Lā' nac Jerusalén ixtlahuamā'ca cā'tani'. Lā' huanmā' cā'tani' ū'tza' a'ntū ixpāstaccan a'nchī cāxtlahuani'ca Dios huan xaka'tla' lītokpān makāntza'. Lā' cā'lonkni' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Lā' Jesús ixlatlā'huan na ixtanquilhni' huan xaka'tla' lītokpān. Lā' huan tanquilhni' ixuanican Ixtanquilhni' Salomón. ");
INSERT INTO tooNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Lā' huan israelitas taxti'li'hui'līlh lā' tahuanilh: ―¿Hasta lhachūnīn naquilāmāpāstacnīkō'yāuj tichū hui'x? Palh hui'x Cristo caquilāhuaniuj chu maktin. ");
INSERT INTO tooNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Lā' Jesús cākalhtīlh: ―Quit iccāhuanintza' lā' hui'xina'n tū' kalhlaka'ī'yā'tit. Huāk catūhuā a'ntū ictlahua quit ictlahua por ixlīmāpa'ksīn quinTāta'. Lā' ū'tza' lītasu'yu tichūn quit. ");
INSERT INTO tooNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Lā' hui'xina'n tū' kalhlaka'ī'yā'tit porque hui'xina'n tū' quintachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quintachi'xcuhuī't takaxmata quintachihuīn chuntza' hua'chi borregos takaxmata ixtachihuīn ixtēcu'. Lā' quit iccālakapasa, lā' xlaca'n quintastālani'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Quit iccāmaxquī' xasāsti' ixquilhtamacujca'n para pō'ktu lā' tū' maktin caticāsputni'lh. Lā' tintī' a'ntī tzē naquimaklhtī a'ntī quintakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Quimacamaxquī'nī't quinTāta' lā' xla' ū'tza' más xaka'tla' māpa'ksīni'. Lā' tintī' tzē quintimaklhtīlh a'ntī quintakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Quit con quinTāta' chu lakatin. ");
INSERT INTO tooNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Lā' tuncan huan israelitas tasacpā chihuix para natalīmūta'la. ");
INSERT INTO tooNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Lā' Jesús cāhuanilh: ―Por ixlīmāpa'ksīn quinTāta' quit lejtza' lhūhua' catūhuā a'ntū lej xalactzey ictlahuanī't na milacapūnca'n. Lā' ū'tza' naquilālīmūta'layāuj. ");
INSERT INTO tooNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Lā' huan israelitas tahuanilh: ―Tū' icticāmūta'lani' por huan xalacuan catūhuā a'ntūn tlahuanī'ta'. Na'iccāmūta'layāni' porque hui'x lakmaka'na' Dios. Lā' tā'talacastuccu'tuna' Dios. Lā' hui'x xmān chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Lā' Jesús cāhuanilh: ―Chuntza' tatzo'kni' na mileyca'n a'nchī hualh Dios: “Hui'xina'n huāk diosnu'”. ");
INSERT INTO tooNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Dios cāmāpācuhuīlh diosnu' a'ntī cālīmāmacū'lh ixtachihuīn Dios. Lā' ixtachihuīn Dios a'ntū tatzo'kni' tū' maktin catilactlahuaca. ");
INSERT INTO tooNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios quilacsacli lā' quimacamilh nac huā'mā' quilhtamacuj. Lā' ¿a'chī' quilālī'a'ksa'nīni'nāuj iclakmaka'lh Dios porque iccāhuanini' quit ixO'kxa' Dios? ");
INSERT INTO tooNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Palh quit tū' ictlahua chu a'nchī tlahua quinTāta', tū' caquilākalhlaka'ī'uj. ");
INSERT INTO tooNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Lā' palh hui'xina'n tū' quilākalhlaka'ī'cu'tunāuj, a'yuj quit ictlahua chu a'nchī tlahua quinTāta', cakalhlaka'ī'tit a'ntū ictlahua quit que ū'tza' ixla' Dios. Lā' chuntza' naca'tzī'yā'tit hui'xina'n lā' namāchekxī'yā'tit que huan xaTāta' lā' quit chu lakatin quina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Lā' chu ā'maktin ixtachī'lē'npalacu'tun pero Jesús cāpūtaxtuni'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Lā' tuncan Jesús a'lh nac tintacutā'cha' huan pūxka Jordán. Lā' chā'lh a'nlhā Juan ixmā'kpaxīni'n xapū'la. ");
INSERT INTO tooNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lā' lhūhua' tachi'xcuhuī't talakchilh Jesús a'ntza' lā' xlaca'n talāhuanilh: ―Juan tū' tlahualh lē'cnīn. Pero huāk a'ntū ixuan por ixpālacata Jesús, ū'tza' a'ntū ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Lā' a'ntza' lej lhūhua' takalhlaka'ī'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ixuī' kalhatin chi'xcu' ixtacuīni' Lázaro. Lā' xla' ī'tza'ca'lh. Lā' xla' ixlahuī' nac lakatin cā'lacchicni' a'ntū huanican Betania. Lā' nā a'ntza' ixtalahui'lāna' María lā' Marta ixtā'tin. ");
INSERT INTO tooNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Lā' huā'mā' María ū'tza' a'ntī lītantūtlahualh lej xamu'csa aceite huan Jesús lā' lītantūxacalh con ixya'j. Lā' Lázaro, ixtā'tin huā'mā' María, ū'tza' a'ntī ī'tza'ca'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lā' María lā' Marta tamāca'tzīnīlh huan Jesús lā' tahuanilh: ―Māpa'ksīni', lej ī'tza'ca'n a'ntī lej tā'lāpāxquī'ya'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lā' a'xni'ca' huanica huā'mā' Jesús hualh: ―Huā'mā' ta'jatat tū' catilaknīlh. Por ixpālacata huanmā' ta'jatat nalaktzī'ncan a'nchī lej ka'tla' Dios, lā' nā namāsu'yu a'nchī lej ka'tla' ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús ixcāpāxquī' huan Marta lā' María lā' nā huan Lázaro. ");
INSERT INTO tooNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lā' a'xni'ca' huanica que huan Lázaro ixī'tza'ca'n, Jesús tachokopā a'nlhā ixuī' ā'lakatu' chi'chini'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Lā' tuncan cāhuanilh huan ī'sca'txtunu'nī'n: ―Ca'a'nchokoujtit nac Judea. ");
INSERT INTO tooNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Lā' huan ī'sca'txtunu'nī'n tahuanilh: ―Māpa'ksīni', huan israelitas xalanī'n nac Judea tūna'j makān ixtamūta'lamaknīcu'tunāni'. Lā' hui'x ¿chu pimpalacu'tuna' a'ntza'? ");
INSERT INTO tooNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Lā' Jesús cāhuanilh: ―Huan chi'chini' xmān lakacāujtu' hora māxkakēni'n. Palh kalhatin latlā'huan de tuncuj, tū' a'kche'kxla porque chi'chini'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Palh kalhatin latlā'huan de tzī'sa, xla' a'kche'kxla porque tintī' xkakana'. Tasqui'nī na'ica'n chuhua'j. Tuntū' quintipātle'keni'lh como tūna'j ictlahuakō' quilītlōt. ");
INSERT INTO tooNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","A'calīstān Jesús cāhuanilh: ―Lázaro, qui'amigoca'n, xla' lhtatalhtza' lā' quit ica'nā icmālakahuanī. ");
INSERT INTO tooNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lā' ī'sca'txtunu'nī'n tahualh: ―Māpa'ksīni', palh lhtatamā', natzeyan. ");
INSERT INTO tooNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús ixcāhuanicu'tun que Lázaro ixnīnī'ttza'. Lā' ī'sca'txtunu'nī'n ixtapuhuan que Jesús ixcāhuanimā' que xmān ī'lhtatamā'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lā' ū'tza' lej xa'nca cālīhuanikō'lh: ―Lázaro nīlhtza'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Xalītzey palh tū' xa'icuī' a'ntza' quit. Chuntza' xatzey para hui'xina'n porque chuntza' nakalhlaka'ī'yā'tit. Chuhua'j cā'huitit a'nlhā mā'cha' Lázaro. ");
INSERT INTO tooNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, a'ntī ixuanican Stu'yūn, cāhuanilh huan ā'makapitzīn sca'txtunu'nī'n: ―Nā catā'a'uj Jesús. Nanīyāuj a'cxtim. ");
INSERT INTO tooNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lā' a'xni'ca' chā'lh Jesús, māca'tzīnīca que tā'ti'ma'jtza' ix'a'cnūma' Lázaro. ");
INSERT INTO tooNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania hua'chi lakatu'tun kilómetro ixlīmakat ixuanī't de nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Lā' lej lhūhua' israelitas ixtalakminī't Marta lā' María para nata'o'kska'lhīni'n como ixnīnī't Lázaro a'ntī ixtā'tinca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lā' Marta, a'xni'ca' ca'tzīlh ixchā'ntēlhatza' Jesús, chu tuncan milh pāxtoka. Lā' María tachokolh nac chic. ");
INSERT INTO tooNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Lā' Marta huanilh huan Jesús: ―Māpa'ksīni', palh ixlatahui'la' cahuā ā'tzā', tū' ixnīlh quintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero quit icca'tzī que Dios, a'yuj chuhua'j, namaxquī'yāni' ixlīhuāk a'ntū nasqui'ni'ya'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Lā' Jesús huanilh: ―Mintā'tin nalakahuanchokopala. ");
INSERT INTO tooNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Lā' Marta huanilh: ―Quit icca'tzī palh nalakahuanchokopala a'xni'ca' ā'xmān chi'chini' nala. ");
INSERT INTO tooNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Lā' Jesús huanilh: ―Quit a'ntī na'iccāmālakahuanīchoko tachi'xcuhuī't lā' quit na'iccāmaxquī' xasāsti' ixquilhtamacujca'n. A'ntī quintalīpāhuan quit, a'yuj catanīlh, xlaca'n nataka'lhī xasāsti' ixquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Lā' ixlīhuākca'n a'ntīn taka'lhī xasāsti' ixquilhtamacujca'n lā' quintalīpāhuan, nā xlaca'n tū' maktin catitasputli. ¿Chā hui'x kalhlaka'ī'ya' huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta huanilh: ―U'huē, Māpa'ksīni'. Quit ickalhlaka'ī' palh hui'x ixO'kxa' Dios, lā' hui'x Cristo a'ntī ixmimā' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lā' Marta, a'xni'ca' hualh huā'mā', a'lh ta'sani' María ixtā'tin. Lā' xla' ska'lh huanilh: ―Chuhua'j chilhtza' huan Māpa'ksīni' lā' ta'sani'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lā' a'xni'ca' kaxmatli huā'mā', María chu tuncan lacapalh tāyalh lā' laka'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Lā' Jesús tūna'j ixtanū huan nac cā'lacchicni'. Ixyācus a'nlhā quīpāxtokli Marta. ");
INSERT INTO tooNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Huan israelitas ixtalahui'lāna' con María huan nac chic lā' ixta'o'kska'lhīmā'na. Lā' a'xni'ca' talaktzī'lh María a'nchī tāyalh lā' chu tuncan lacapalh a'ntāquī'lh lā' xlaca'n tastālani'lh. Ixtapuhuan a'mā' calhuan nac taponkni'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lā' María a'xni'ca' lakchā'lh Jesús, tatzokostani'lh lā' huanilh: ―Māpa'ksīni', palh ixtahui'la' cahuā huā'tzā', tū' ixnīlh quintā'tin. ");
INSERT INTO tooNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Lā' Jesús laktzī'lh tzuculh calhuan María lā' huan israelitas a'ntī ixtatā'minī't. Lā' xla' līlakaputzalh lā' lej ixlītamakchuyīnī't. ");
INSERT INTO tooNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Lā' cākalhasqui'nīlh: ―Lā' ¿lhachū mā'cnū'tit? Lā' tahuanilh: ―Cata't laktzī'na', Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Lā' Jesús calhualh. ");
INSERT INTO tooNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Lā' huan israelitas talāhuanilh: ―Calaktzī'ntit a'nchī calhuan. Lej ixpāxquī'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Lā' ā'makapitzīn tahualh: ―U'tza' huā'mā' a'ntī mālacahuānī huan lakatzī'n. ¿Chu tūlalh ixtlahualh catūhuā para que tū' ixnīlh Lázaro? ");
INSERT INTO tooNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lā' Jesús ixtamakchuyīnī't huampala. Lā' chā'lh huan nac taponkni'. Lā' huan taponkni' lakatin lhu'cu' ixuanī't lā' ixka'lhī lakatin chihuix a'ntū ixkalhui'līcanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Lā' Jesús hualh: ―Camāpānū'tit huan chihuix. Lā' Marta, ixtā'tin huan nīn, huanilh: ―Māpa'ksīni', tā'ti'ma'jtza' nīnī't lā' chuhua'j pu'csantza'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Lā' Jesús huanilh: ―¿Chu tū' icuanini' palh kalhlaka'ī'ya', nalaktzī'na' ixlīmāpa'ksīn Dios a'ntū natlahua? ");
INSERT INTO tooNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuncan māpānūca huan chihuix. Lā' Jesús talacayāhualh lā' hualh: ―Tāta', icmaxquī'yāni' pāxcatca'tzī porque hui'x quinkaxpa'tnī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Quit icca'tzī que pō'ktu quinkaxpa'ta'. Pero quit icuaniyāni'tza' por ixpālacata huan tachi'xcuhuī't a'ntī tahui'lāna' huā'tzā' para que xlaca'n chuntza' natakalhlaka'ī' palh hui'x quimacata'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Lā' a'xni'ca' huankō'lh huā'mā', Jesús lej palha' hualh: ―¡Lázaro, cataxtu! ");
INSERT INTO tooNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lā' taxtulh a'ntī xanīntza' ixuanī't. Ixlīmacasna'tcanī't lā' ixlīlacsna'tcanī't lu'xu' lā' ixlīlakatlapacanī't lu'xu'. Lā' Jesús cāhuanilh: ―Calacxcutit lā' camacaxcutit lā' chuntza' camakxtektit. ");
INSERT INTO tooNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Lā' a'xni'ca' talaktzī'lh Jesús a'ntū tlahualh, takalhlaka'ī'lh lhūhua' israelitas a'ntī ixta'o'kska'lhīmā'na María. ");
INSERT INTO tooNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Lā' makapitzīn de xlaca'n talaka'lh huan fariseosnu' lā' tahuanilh a'ntū ixtlahuanī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Lā' huan fariseosnu' lā' huan xanapuxcu'nu' curasna' lā' huan pūchihuīna'nī'n tatakēxtimīlh lā' talāhuanilh: ―¿Tuchū natlahuayāuj chuhua'j? Huā'mā' chi'xcu' lej tlahuamā' lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Palh tuntū' natlahuani'yāuj, ixlīhuākca'n natakalhlaka'ī' ū'tza', lā' huan xanapuxcu'nu' romanos natamin lā' natalactlahua huan xaka'tla' lītokpān lā' huan quixcānsipejca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kalhatin de ū'tunu'n ixuanican Caifás. Xla' ū'tza' mero xamāpa'ksīni' curasna' ixuanī't huanmā' cā'ta. Lā' xla' cāhuanilh: ―Hui'xina'n tū' ca'tzīyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Hui'xina'n tū' māchekxī'yā'tit que más tzey para quina'n palh kalhatin chi'xcu' nanī por quimpālacataca'n. Chuntza' ixlīhuāk huan xcānsipej tū' catilakualh. ");
INSERT INTO tooNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Lā' ū'tza' a'ntū hualh Caifás, tū' xmān ixtapāstacna'. Como Caifás mero xamāpa'ksīni' curasna' ixuanī't huanmā' cā'ta, Dios māhuanīlh que Jesús xla' ū'tza' nalīnī por ixpālacata tachi'xcuhuī't xalanī'n huan xcānsipej. ");
INSERT INTO tooNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Lā' tū' xmān por huan tachi'xcuhuī't xalanī'n huanmā' xcānsipej; xla' nanī para que tzē nacāmākēxtimī ixcamana' Dios a'ntī ixta'a'kahuankō'nī't, lā' chu lakatin natala. ");
INSERT INTO tooNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lā' huanmā' chi'chini' huan xanapuxcu'nu' israelitas tatzuculh talīlacchihuīna'n a'nchī tzē natalīmaknī Jesús lā' chuntza' ixtalīlacchihuīna'ntēlha. ");
INSERT INTO tooNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Lā' ū'tza' huā'mā' ixpālacata Jesús tū'tza' ixcātalacsu'yuni' huan israelitas. Lā' taxtulh de nac Judea lā' a'lh ā'lacatin cā'lacchicni' a'ntū ixuanican Efraín, na ixpajtzu huan a'nlhā cā'lhpi'mpi'li' ti'ya't. Lā' a'ntza' tachokolh con ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ixtapajtzūtēlhatza' huan cā'tani' a'ntū huanican pascua a'ntū ixtapūtlahua cā'tani' israelitas. Lā' lej lhūhua' tachi'xcuhuī't ta'a'lh nac Jerusalén para natatapa'lha chu a'nchī ixtalanānca'n porque ixtapuhuan que Dios nacālaktzī'n lacuan a'xni'ca' ixtamaclacā'ni' huan cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Lā' xlaca'n ixtaputza Jesús. Lā' a'xni'ca' ixtatanūmā'natza' nac xaka'tla' lītokpān, ixtalākalhasqui'nī: ―¿Chichū puhua'nā'tit hui'xina'n? ¿Namin Jesús o tū' catimilh? ");
INSERT INTO tooNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Huan fariseosnu' lā' huan xanapuxcu'nu' curasna' ixtamāstā'nī't talacasqui' palh tichū ca'tzī a'nlhā hui'lacha' Jesús, cacāmāca'tzīnīca xlaca'n para que chuntza' tzē nachi'pacan. ");
INSERT INTO tooNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ixtapajtzūtēlhatza' huan cā'tani' a'ntū ixuanican pascua. Xmān lakachāxan chi'chini' ī'sputa. Lā' Jesús a'lh nac Betania a'nlhā ixui'lacha' Lázaro a'ntī ixmālakahuanīchokonī't. ");
INSERT INTO tooNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Lā' a'ntza' cāxtlahuaca huan ixlīhua't Jesús. Lā' Marta ixcāmojō huan pulātu. Lā' Lázaro lā' huan ā'makapitzīn ixtahui'lāna' macaxtim con Jesús a'nlhā ixtahuā'yamā'na. ");
INSERT INTO tooNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lā' María līmilh hua'chi pūpitzi litro de huan aceite de puro nardo a'ntū xamu'csa lā' lej lhūhua' ixtapalh. Lā' lītantūtlahualh Jesús lā' chu tuncan lītantūxacalh ixya'j. Lā' ixlīchakaka'tla' huan chic ā'mu'csana'nkō'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Lā' Judas Iscariote, ixo'kxa' Simón, a'ntī nā sca'txtunu' ixuanī't lā' a'ntī namacamāstā' Jesús, xla' hualh: ");
INSERT INTO tooNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Lā' ¿a'chī' tū' stā'ca huā'mā' perfume? Hua'chi lakatu'tun ciento pesos ixtapalh. Lā' huā'mā' tumīn tzē ixcālē'ksajca a'ntī lacpobres. ");
INSERT INTO tooNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas tū' ixcālakalhu'man huan pobres. Hualh huā'mā' porque xla' ka'lhāna' ixuanī't. Xla' ū'tza' ixmāmāquī'nīcanī't huan tumīn. Lā' xla' a'ntza' ixmaka'lhantēlha. ");
INSERT INTO tooNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Lā' Jesús huanilh: ―Tū' calītamakchu'yi' huan puscāt. Xla' māquī'nī't huan perfume hasta chuhua'j para naquilītlō como palaj naquimā'cnūcan. ");
INSERT INTO tooNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Lā' pō'ktu na'a'nan pobres con hui'xina'n. Quit tū' pō'ktu ictilatahui'lalh con hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Lā' a'xni'ca' taca'tzīlh que Jesús ixui'lacha' nac Betania, lej lhūhua' israelitas ta'a'lh talaktzī'n. Lā' tū' xmān Jesús ixtalaktzī'ncu'tun, lā' nā ixtalaktzī'ncu'tun Lázaro a'ntī ixmālakahuanīchokonī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Lā' chuntza' huan xanapuxcu'nu' curasna' nā xlaca'n talacchihuīna'mpā para natamaknī nā huan Lázaro. ");
INSERT INTO tooNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Por ixpālacata huan Lázaro, lej lhūhua' israelitas ixtatalakspi'tnī'ttza' con huan curasna' lā' ixtakalhlaka'ī'nī'ttza' huan Jesús. Lā' ū'tza' ixtalīmaknīcu'tun huan Lázaro. ");
INSERT INTO tooNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Lā' ixlīlakalī lhūhua' tachi'xcuhuī't a'ntī ixtachinī't nac xcānsipej Jerusalén para huan cā'tani', xlaca'n taca'tzīlh que Jesús ixmimā' nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Lā' talē'lh xta'cna' lā' ta'a'lh tapāxtoka Jesús lā' ixtamāta'sīmā'na: ―¡Camācā'tanī'tit Dios! ¡Dios casicua'lanālīlh a'ntī mimā' por ixlīmāpa'ksīn huan Māpa'ksīni'! U'tza' quiReyca'n quina'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Lā' Jesús ixkaksnī't lakatin burro lā' ixkēhuī'. Chuntza' tatzo'kni' na ixtachihuīn Dios: ");
INSERT INTO tooNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tū' cajicua'ntit hui'xina'n xalanī'n nac Sión; chuhua'j huan miReyca'n mimā' lā' kēhuī' lakatin burro a'ntū o'kxa'cus. ");
INSERT INTO tooNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xapū'la ī'sca'txtunu'nī'n tū' tamāchekxīlh huā'mā'. Lā' a'xni'ca' Jesús lakahuanchokolh, a'xni'ca' tapāstacli chu a'nchī ixtatzo'kni' lā' chuntza' pātle'keni'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lā' huan tachi'xcuhuī't a'ntī ixtatā'hui'lāna' Jesús a'xni'ca' xla' ta'sani'lh Lázaro nac taponkni' a'nlhā ixmā'cnūcanī't lā' mālakahuanīchokolh, lā' xlaca'n ixtalīchihuīna'n a'ntū ixtalaktzī'nī't. ");
INSERT INTO tooNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lā' ū'tza' talī'a'lh tapāxtoka Jesús lhūhua' tachi'xcuhuī't porque xlaca'n ixtaca'tzī palh ixtlahuanī't huā'mā' lē'cnīn. ");
INSERT INTO tooNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lā' huan fariseosnu' talāhuanilh: ―Calaktzī'ntit a'nchī tastālani'kō'. Lā' tūla tlahuani'yāuj nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Makapitzīn griegos nā xlaca'n ixta'a'nī't huan nac Jerusalén para natataquilhpūtani' Dios a'xni'ca' ixlamā' cā'tani'. ");
INSERT INTO tooNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xlaca'n talaka'lh Felipe xala' nac Betsaida nac estado de Galilea. Lā' tahuanilh: ―Señor, quina'n ictā'chihuīna'ncu'tunāuj Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Lā' Felipe laka'lh Andrés lā' huanilh a'nchī tahualh. Lā' ixkalhatu'ca'n ta'a'lh tahuanī Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Lā' Jesús cāhuanilh: ―Quit huan Chi'xcu' xala' Tālhmā'n. Chilhtza' huan quilhtamacuj a'ntū naquimpū'a'cnīni'ni'can como palaj na'icnī. ");
INSERT INTO tooNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","U'tza' ixlīstu'ncua'. Palh lakatin ti'ni' namāstā' ixtō'ca't, tasqui'nī que namā'cnūcan nac ti'ya't. Lā' a'xni'ca' namā'cnūcan, pū'la tasu'yu hua'chilh lakuan. Pero ā'calīstān namāstā' ixtō'ca't. Lā' nā chuntza' naquimpātle'keni' quit a'xni'ca' naquimā'cnūcan. ");
INSERT INTO tooNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lā' nā chuntza' huan tachi'xcuhuī't. A'ntīn tatlahua a'ntū ixtapuhuānca'n, xlaca'n nacāsputni' ixquilhtamacujca'n. Lā' a'ntīn tatlahua ixtapuhuān Dios, xlaca'n taka'lhī xasāsti' ixquilhtamacujca'n a'ntū tū' maktin caticāsputni'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","A'ntī quintatā'scujcu'tun, xlaca'n caquintastālani'lh. Lā' a'nlhā na'ictahui'la quit nac a'kapūn, nā a'ntza' natatahui'la a'ntī quintatā'scuja. QuinTāta' nacā'a'cnīni'ni' ixlīhuākca'n a'ntī quintatā'scuja. ");
INSERT INTO tooNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Chuhua'j quit lej ictamakchuyīnī't. ¿Chichū na'icuan? Tū' ictihuanilh quinTāta': “Tāta', caquimāpūtaxtu a'ntū na'icpātī”. Tūla icuan chuntza' porque tasqui'nī na'icpātīni'n. U'tza' iclīminī't nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tāta', ca'a'cnīni'ni'ca' hui'x. Lā' chu tuncan kaxmatca lakatin tachihuīn de nac a'kapūn a'ntū hualh: ―Qui'a'cnīni'ni'canī'ttza' lā' chu naqui'a'cnīni'ni'palacan. ");
INSERT INTO tooNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Lā' huan tachi'xcuhuī't, a'xni'ca' takaxmatli huā'mā', tahualh: ―Jililh. Lā' ā'makapitzīn tahuampā: ―Kalhatin ángel tā'chihuīna'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Lā' Jesús cāhuanilh: ―Huan tachihuīn chihuīna'lh por mimpālacataca'n lā' tū' por quimpālacata. ");
INSERT INTO tooNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Chuhua'j natzucucan cālacāxtlahuacan huā' xalanī'n huā'mā' nac quilhtamacuj. Lā' namaklhtīcan ixlīmāpa'ksīn a'ntī māpa'ksī huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Lā' quit a'xni'ca' naquimā'kayāhuacan nac cruz, na'iccāmāpuhuanī ixlīhuākca'n huan tachi'xcuhuī't palh naquinta'a'kahuāna'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Lā' Jesús hualh huā'mā' para que chuntza' naca'tzīcan a'nchī nalīnī. ");
INSERT INTO tooNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Lā' huan tachi'xcuhuī't takalhtīlh: ―Huan quileyca'n quincāmāsu'ni'yāni' que Cristo natahui'la para pō'ktu. Lā' ¿chī hua'na' hui'x que huan Chi'xcu' xala' Tālhmā'n namā'kayāhuacan nac cruz? ¿Tichū huā'mā' huan Chi'xcu' xala' Tālhmā'n? ");
INSERT INTO tooNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Lā' Jesús cāhuanilh: ―Tū' makān catika'lhī'tit huan Xkakana'. Lā' catlā'hua'ntit hui'xina'n līhuan ka'lhī'yā'tit huan Xkakana' lā' līhuan tūna'j lakatzī'suanā'tit. A'ntī talatlā'huan de tzī'sa xlaca'n tū' taca'tzī a'nlhā ta'a'n. ");
INSERT INTO tooNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Quit huan Xkakana' como quit icmāsu'yu a'ntū ixlīstu'ncua'. Caquinkalhlaka'ī'tit para que chuntza' naca'tzīyā'tit a'ntū ixlīstu'ncua'. Lā' a'xni'ca' ixuanī'ttza' huā'mā', Jesús a'lh lā' cātatzē'kni'lh xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Huan israelitas tū' ixtakalhlaka'ī' Jesús a'yuj ixtlahuanī'ttza' lej lhūhua' lē'cnīn na ixlacapūnca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Lā' chuntza' tlōkentaxtūlh a'ntū tzo'kli huan a'cta'sana' Isaías: Māpa'ksīni', tū' kalhlaka'ī'ca a'ntū icmāsu'yūj. Tū' kalhlaka'ī'ca a'yuj laktzī'nca a'nchī Dios lej ka'lhī līmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Lā' Isaías līchihuīna'lh ixpālacata a'nchī tūlalh kalhlaka'ī'ca. Lā' xla' tzo'kpā: ");
INSERT INTO tooNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios cātlahualh lakatzī'nī'n, lā' cālactlahuani'lh ixtapāstacna'ca'n. Lā' chuntza' tū' talaktzī'n lā' tū' tamāchekxī lā' tū' quintalakmin para que na'iccāmātzeyī. ");
INSERT INTO tooNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías hualh huā'mā' porque ixlaktzī'nī'ttza' a'nchī lej ixlīka'tla' ixlīmāpa'ksīn Jesús. Lā' chuntza' līchihuīna'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lā' lej lhūhua' xanapuxcu'nu' takalhlaka'ī'lh Jesús. Xlaca'n xmān tzē'k taca'tzīlh porque ixtajicua'ni' huan fariseosnu'. Ixtajicua'n que nacāmātuxtekēcan de huan lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Xlaca'n lej ixtalacasqui'n que cata'a'cnīni'ni'lh tachi'xcuhuī't; lā' tū' tanto ixtatlahuacu'tun a'ntū Dios lacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús chihuīna'lh lej pa'lha lā' hualh: ―A'ntī quintakalhlaka'ī' quit, tū' xmān quē'cstu quintakalhlaka'ī'. Xlaca'n takalhlaka'ī' nā quinTāta' a'ntī quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Lā' a'ntī quintalaktzī'n quit, hua'chilh xlaca'n talaktzī'n nā quinTāta' a'ntī quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Quit huan Xkakana'. Quit icminī't nac quilhtamacuj para nacāmakskoni' tachi'xcuhuī't. Chuntza' a'ntī naquintakalhlaka'ī' quit, tū'tza' catitatahui'lalh xlaca'n a'nlhā cā'pucsua', como natamāchekxī a'ntū ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","A'ntīn takaxmata quintachihuīn lā' tū' takalhlaka'ī', tū' iccālacāxtlahua quit. Quit icminī't para na'iccāmāpūtaxtū xalanī'n nac quilhtamacuj, lā' tū' para na'iccālacāxtlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Lā' a'ntī quintalakmaka'n lā' tū' takalhlaka'ī' quintachihuīn, xlaca'n nacālacāxtlahuacan. A'ntū ā'xmān chi'chini' nala, xlaca'n nacālacāxtlahuacan por ixpālacata a'ntū icuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Lā' quit tū' xmān icchihuīna'n por quimpātunca'tzi. QuinTāta' a'ntī quimacamilh xla' quimāpa'ksīlh a'ntū icuan lā' a'ntū icmāsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Lā' quit icca'tzī que quinTāta' quimāpa'ksīlh que iccāmāsu'ni'lh huan tachi'xcuhuī't a'nchī nataka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. A'ntū quihuaninī't quinTāta', ū'tza' icchihuīna'n quit. ");
INSERT INTO tooNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Lā' a'xni'ca' tūna'j ixtzucu huan cā'tani', Jesús ca'tzīlh que ā'macsti'na'j ī'sputni' para namakxteka huan quilhtamacuj lā' para nalaka'mpala ixTāta'. Lā' xla' pō'ktu ixcāpāxquī'nī't a'ntī ixla' xalanī'n nac quilhtamacuj. Lā' tū' ixlīmakān xla' namāsu'yu a'nchī lej ixcāpāxquī'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Lā' Jesús ixcātā'huā'yamā' ī'sca'txtunu'nī'n cā'smalanka'n. Lā' huan ko'ti'ti' ixmāpuhuanīnī'ttza' Judas Iscariote, ixo'kxa' Simón, palh namacamāstā' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús, xla' ixca'tzī que huan xaTāta', xla' ixmaxquī'kō'nī't ixlīhuāk līmāpa'ksīn. Lā' nā ixca'tzī palh ixminī'ta'ncha' de Dios lā' chu nalaka'mpala Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lā' tuncan tāyalh a'nlhā ixuā'yamā' lā' tamakxtulh ixlu'xu' xala' ixkalhni' lā' chā'xpātahui'lalh kalhtin ixlīmacaxaca. ");
INSERT INTO tooNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Lā' chu tuncan mojōlh xcān nac lakatin pūmakacha'ka'. Lā' chu tuncan tzuculh cātantūche'kē' huan ī'sca'txtunu'nī'n lā' cālītantūxacalh huan līmacaxaca a'ntū ixchā'xpāhuī'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lā' a'xni'ca' ixtantūche'kē'cu'tumā'tza' huan Simón Pedro, xla' hualh: ―Māpa'ksīni', lā' ¿chu hui'x naquintantūche'kē'ya'? ");
INSERT INTO tooNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Lā' Jesús kalhtīlh: ―Chuhua'j hui'x tū' māchekxī'ya' a'ntū ictlahuamā' quit. A'calīstān namāchekxī'ya' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Lā' Pedro huanilh: ―Quit tū' maktin quintitantūche'ke'. Lā' Jesús huanilh: ―Palh quit tū' ictitantūche'kē'ni' hui'x tūlalhtza' catila't quisca'xtunu'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Lā' Simón Pedro huanilh: ―Lā' tū' xmān quintojon, nā quimacan caquimakache'ke', lā' nā qui'a'kxāk caquimūche'ke'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Lā' Jesús huanilh: ―A'ntī paxnī'tcus, xmān tasqui'nī natantūcha'ka'n porque ixlīhuāk ixmacni' makcha'ka'nī't. Hui'xina'n lactzey. Xmān kalhatin de hui'xina'n tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Lā' Jesús ixca'tzītza' a'ntī namacamāstā'. Lā' ū'tza' līhualh: “Hui'xina'n lactzey. Xmān kalhatin de hui'xina'n tū' tzey”. ");
INSERT INTO tooNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Lā' Jesús a'xni'ca' cātantūche'kē'kō'lh huan ī'sca'txtunu'nī'n, chu hui'līpā ixlu'xu' huan xala' ixkalhni' lā' xla' tahui'lapā lā' cāhuanilh: ―¿Chā māchekxī'yā'tit hui'xina'n huā' a'ntū iccātlahuani'nī'ta'ni'? ");
INSERT INTO tooNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Hui'xina'n quilāmāpācuhuīyāuj Mākalhtō'kē'ni' lā' Māpa'ksīni'. Chuntza' tzey porque ū'tza' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Como quit Mākalhtō'kē'ni' lā' Māpa'ksīni', lā' iccātantūche'kē'nī'ta'ni' hui'xina'n lā' nā chuntza' tasqui'nī que hui'xina'n nā nalātantūche'kē'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Quit iccātlahuani'ni' huā'mā' hua'chi tamālacastuc; lā' nā chuntza' natlahua'yā'tit nā hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Hui'xina'n tū' más laka'tla'n que quit. Hui'xina'n hua'chi quintasācua'nī'n lā' quit hua'chi mimpatronca'n. Hui'xina'n quilacscujnī'n lā' quit iccāmālacscujūyāni'. Chuntza' tasqui'nī natlahua'yā'tit a'ntū ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hui'xina'n ca'tzīyā'tit a'ntū iccāhuaninī'ta'ni'cus. Lā' palh natlahua'yā'tit, lej līpāxūj nalatahui'la'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Lā' tū' milīhuākca'n iccālīchihuīna'nāni'. Quit icca'tzī a'ntī iccālacsacnī't. Natlōkentaxtū chu a'nchī tatzo'kni' na ixtachihuīn Dios: U'tza' a'ntī ictā'huā'yan ū'tza' lalh hua'chi quintā'ca'tza'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quit iccāhuanimā'ni' a'ntū napātle'ke. Lā' chuntza' a'xni'ca' nala huā'mā', hui'xina'n nakalhlaka'ī'yā'tit tichū quit. ");
INSERT INTO tooNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Quit ixlīstu'ncua' iccāhuaniyāni'. A'ntī ta'a'cnīni'ni' a'ntī icmālakachā', nā quit quinta'a'cnīni'ni' lā' nā ta'a'cnīni'ni' a'ntī quimacamilh. ");
INSERT INTO tooNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Lā' a'xni'ca' huankō'lh huā'mā', Jesús lej tamakchuyīlh lā' lacastu'nc hualh: ―Ixlīstu'ncua' iccāhuaniyāni', chā'tin de hui'xina'n ū'tza' naquimacamāstā'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lā' ū'tza' tatzuculh talālīlakalaktzī'n huan sca'txtunu'nī'n porque xlaca'n tū' ixtaca'tzī a'ntī ixlīchihuīna'mā'ca. ");
INSERT INTO tooNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kalhatin ī'sca'txtunu' ixuā'yamā' na ixpāxtūn Jesús. U'tza' a'ntī lej ixpāxquī' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Lā' Simón Pedro lacahuanilh huanmā' sca'txtunu' lā' huanilh: ―Cakalhasqui'ni' tichū līchihuīna'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Lā' xla' ū'tza' ā'chulā' līlaktapajtzūlh huan Jesús lā' kalhasqui'nīlh: ―Māpa'ksīni', ¿tichū līchihuīna'mpā't? ");
INSERT INTO tooNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Lā' Jesús kalhtīlh: ―Na'iclīmāchū'huī' xaxcān līhua't pītzina'j pāntzi. Lā' a'ntī na'icmaxquī' ū'tza' nala. Lā' māchū'huī'lh huan pītzina'j pāntzi lā' maxquī'lh huan Judas Iscariote, ixo'kxa' Simón. ");
INSERT INTO tooNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Lā' a'xni'ca' Judas maklhtīni'lh huan pāntzi tanūni'lh huan ko'ti'ti' na ixa'clhcunuc. Lā' chu tuncan Jesús huanilh: ―Catla'hua' tuncan a'ntū tla'hua'cu'tuna'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Lā' huan ā'makapitzīn a'ntī ixtahuā'yamā'na, xlaca'n tū' tamāchekxīlh a'chī' huanilh huanmā'. ");
INSERT INTO tooNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Lā' como Judas ū'tza' ixmāmāquī'nīcanī't huan tumīn, makapitzīn tapuhualh que Jesús ixuaninī't que natamāhua catūhuā a'ntū ixtamaclacasqui'n para huan cā'tani', o ixuaninī't que nacāmaxquī' macsti'na'j huan pobres. ");
INSERT INTO tooNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lā' a'xni'ca' ixmaklhtīni'nī'ttza' huan pāntzi, Judas taxtulh. Lā' tzī'satza' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Lā' a'xni'ca' Judas ixtaxtunī'ttza', Jesús hualh: ―Chuhua'j qui'a'cnīni'ni'can quit, como quit huan Chi'xcu' xala' Tālhmā'n. Lā' chuhua'j a'cnīni'ni'can Dios por ixpālacata a'ntū ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lā' como a'cnīni'ni'can Dios por ixpālacata a'ntū ictlahua, lā' chuntza' Dios naqui'a'cnīni'ni' quit. Lā' palaj natlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Quilakska'tā'n, tū'tza' makān icticātā'latahui'lani' hui'xina'n. Lā' hui'xina'n naquilāputzayāuj. Chuntza' a'nchī iccāhuanilh huan israelitas, nā hui'xina'n chuntza' chuhua'j na'iccāhuaniyāni': “A'nlhā na'ica'n quit, hui'xina'n tūlalh catipintit”. ");
INSERT INTO tooNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lā' hui'xina'n iccāmaxquī'yāni' xasāsti' līmāpa'ksīn: Calāpāxquī'tit. Chuntza' a'nchī iccāpāxquī'yāni' quit, nā chuntza' nalāpāxquī'yā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Palh hui'xina'n nalāpāxquī'yā'tit, chuntza' nataca'tzī ixlīhuāk tachi'xcuhuī't palh hui'xina'n quisca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro kalhasqui'nīlh Jesús: ―Māpa'ksīni', ¿lhachū pimpā't? Lā' Jesús kalhtīlh: ―A'nlhā na'ica'n quit, tūlalh quintitā'pi chuhua'j. Naquistālani'ya' ā'calīstān. ");
INSERT INTO tooNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Lā' Pedro huanilh: ―Māpa'ksīni', lā' ¿a'chī' tūla ictitā'a'ni' chuhua'j? Quit xa'iclīnīlh por hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Lā' Jesús kalhtīlh: ―¿Chā stu'ncua' palh ixnī't por quit? Stu'ncua' a'ntū icuaniyāni'. A'xni'ca' tūna'j ta'sa huan gallo, hui'x naquinkalhtatzē'ka' maktu'tun. ");
INSERT INTO tooNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","lā' Jesús cāhuanipā: ―Lā' hui'xina'n tū'tza' catamakchuyī'tit. Calīpāhua'ntit Dios lā' nā chuntza' quit caquilālīpāhuáuj. ");
INSERT INTO tooNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","A'nlhā hui'lacha' quinTāta', a'ntza' a'nan lhūhua' pūtahuī'lhni'. Palh tū' cahuā chuntza', xa'iccāhuanini' hui'xina'n. Ica'nā quit iccāxui'lī lacatin a'nlhā natahui'la'yā'tit a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Lā' a'xni'ca' na'ica'n quit lā' na'iccāxui'līkō'yācha', quit na'icmimpala lā' na'iccālē'nāni' hui'xina'n. Lā' chuntza' a'nlhā na'ictahui'la quit, nā hui'xina'n a'ntza' natahui'la'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hui'xina'n ca'tzīyā'tit a'nlhā ica'mā' lā' ca'tzīyā'tit a'nchī tzē līchā'ncan. ");
INSERT INTO tooNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Lā' Tomás huanilh: ―Māpa'ksīni', quina'n tū' icca'tzīyāuj a'nlhā pimpā't. ¿Chichū na'iclīca'tzīyāuj a'nchī līchā'ncan? ");
INSERT INTO tooNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús kalhtīlh: ―Quit huan xatzey tej, lā' quit icmāsu'yu a'ntū ixlīstu'ncua', lā' quit iccāmaxquī'yāni' xasāsti' minquilhtamacujca'n. Lā' xmān a'ntī quintakalhlaka'ī', xmān xlaca'n tzē natalakchā'n quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Palh hui'xina'n ixca'tzītit tichūn quit, ixlakapastit quinTāta'. Chuhua'j lakapasā'tit quinTāta' lā' laktzī'nī'ta'ntit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Lā' Felipe huanilh: ―Māpa'ksīni', caquilāmāsu'ni'uj minTāta'. Lā' xmān ū'tza' iccāsqui'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús kalhtīlh: ―Felipe, lejtza' makān iccātā'lahui'lani' hui'xina'n, lā' ¿a'chī' tūna'j quilakapasa'? A'ntī quintalaktzī'nī't quit, nā talaktzī'nī't quinTāta'. Lā' ¿a'chī' hua'na': “Caquilāmāsu'ni'uj minTāta'”? ");
INSERT INTO tooNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Chu tū' a'ka'ī'ya' que quinTāta' lā' quit chu lakatin quina'n? A'ntū iccāhuaniyāni', tū' xmān quimpātunca'tzi. QuinTāta' quintā'lahuī', lā' māni' ū'tza' tlahua a'ntū ixtascujūt. ");
INSERT INTO tooNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Cakalhlaka'ī'tit que chu lakatin quina'n, quit lā' quinTāta'. Lā' palh tūla nakalhlaka'ī'yā'tit huā'mā' xmān por ixpālacata a'ntū iccāhuanini', caquilākalhlaka'ī'uj por ixpālacata huan lē'cnīn a'ntū ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ixlīstu'ncua' a'ntū iccāhuaniyāni'. A'ntī quintakalhlaka'ī' quit, nā xlaca'n natatlahua huan catūhuā a'ntū ictlahua quit. Lā' ā'līhua'ca' xalaka'tla'n catūhuā natatlahua porque quit na'iclaka'n quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A'ntū nasqui'nā'tit hui'xina'n por quinquilhtampān quit na'ictlahua porque quit xa'O'kxa'; chuntza' tzē na'iclīmālacsu'yu a'nchī ixlīka'tla' ixlīmāpa'ksīn quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quit na'ictlahua chuxatū a'ntū nasqui'nā'tit hui'xina'n por quinquilhtampān. ");
INSERT INTO tooNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Lā' Jesús cāhuanipā: ―Palh hui'xina'n quilāpāxquī'yāuj, ca'a'kahuāna'ni'tit quilīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Quit na'icsqui'ni' quinTāta' lā' xla' nacālakmacamimpalayāni' ā'kalhatin a'ntī nacāmaktāyayāni'. Lā' xla' ū'tza' natachoko con hui'xina'n para pō'ktu. Xla' ū'tza' huan Espíritu Santo a'ntī māsu'yu a'ntū ixlīstu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Xalanī'n nac quilhtamacuj xlaca'n tūlalh catitamaklhtīni'lh huan Espíritu Santo porque xlaca'n tūlalh catitalaktzī'lh lā' tūlalh catitalakapasli. Lā' hui'xina'n lakapasā'tit porque xla' cātā'lahui'lani' hui'xina'n lā' nacā'o'kska'lhīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Lā' tū' icticāmakxtekni' mi'a'cstuca'n. Na'iccālakmimpalayāni' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","A'macsti'na'j tū'tza' quintitalaktzī'lh huan xalanī'n nac quilhtamacuj. Pero hui'xina'n naquilālaktzī'nāuj. Hui'xina'n nalatahui'la'yā'tit porque quit iclahuī'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lā' a'xni'ca' namin huan Espíritu Santo, hui'xina'n naca'tzīyā'tit que quinTāta' quintā'lahuī' lā' nā iccātā'lahui'lani'. ");
INSERT INTO tooNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","A'ntīn taca'tzī quilīmāpa'ksīn lā' ta'a'kahuāna'ni', chuntza' lītasu'yu palh quintapāxquī'. Lā' quinTāta' nā nacāpāxquī' a'ntī quintapāxquī' quit. Lā' nā quit nā na'iccāpāxquī' lā' na'iccātalacsu'yuni' xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Lā' Judas (ā'chā'tin Judas lā' tū' huan Iscariote) huanilh: ―Māpa'ksīni', lā' ¿a'chī' naquilātalacsu'yuni'yāuj quina'n lā' tū' huan tachi'xcuhuī't xalanī'n nac quilhtamacuj? ");
INSERT INTO tooNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Lā' Jesús kalhtīlh: ―A'ntī quintapāxquī' quit, xlaca'n nata'a'kahuāna'ni' a'ntū icuan quit. Lā' quinTāta' nacāpāxquī'. Lā' quinTāta' lā' quit na'iccālakmināuj para na'iccātā'latahui'layāuj xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Lā' a'ntīn tū' quintapāxquī' xlaca'n tū' ta'a'kahuāna'ni' a'ntū icuan quit. Lā' huan līmāsca'tīn a'ntū kaxpa'tpā'na'ntit hui'xina'n, xla' tū' quila'; ixla' quinTāta' a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Lā' huāk huā'mā' iccāhuanimā'kō'ni' līhuan iccātā'lahui'lani' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","QuinTāta' namacamin huan Espíritu Santo lā' xla' namāsu'yu por quimpālacata. U'tza' huan maktāyana' lā' nacāmāsu'ni'kō'yāni' ixlīhuāk lā' nacāmāpāstaquīyāni' ixlīhuāk a'ntū iccāhuaninī'ta'ni' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Hui'xina'n quilākalhlaka'ī'yāuj lā' ū'tza' līpāxuhua'yā'tit hua'chi quit icpāxuhua. Lā' a'nchī pāxuhua'yā'tit tū' hua'chi xalanī'n nac quilhtamacuj. Lā' tū' catamakchuyī'tit lā' tū' cajicua'ntit. ");
INSERT INTO tooNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Hui'xina'n kaxpa'ttit a'nchī iccāhuanini': “Quit ica'nā lā' na'iccālakmimpalayāni' hui'xina'n”. Palh lej stu'ncua' ixquilāpāxquī'uj, lej ixlīpāxuhua'tit hui'xina'n porque quit iclaka'mā' quinTāta'. Lā' xla' ū'tza' más xaka'tla' que quit. ");
INSERT INTO tooNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iccāhuanimā'ni' a'ntū napātle'ke. Lā' a'xni'ca' nala, hui'xina'n nakalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Lā' tū'tza' lej icticātā'chihuīna'ni' hui'xina'n porque mimā'tza' a'ntī māpa'ksī huā' quilhtamacuj. Lā' xla', quit tūlalh quintimāpa'ksīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Quit ictlahua ū'tza' a'ntū quihuani quinTāta'. Chuntza' huan xalanī'n nac quilhtamacuj tzē nataca'tzī palh quit icpāxquī' quinTāta'. Lā' a'xni'ca' Jesús cāhuanikō'lh huā'mā', cāhuanipā: ―Lā' chuhua'j catāya'tit lā' cā'hui'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Lā' Jesús cāhuanipā: ―Quit hua'chi xatzey mayāc lā' quinTāta' hua'chi xamaktaka'lhna' huā'mā' mayāc. ");
INSERT INTO tooNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Lā' huāk huan ixpekenī'n a'ntū tū' māstā' ixtō'ca't, xla' ū'tza' cācā'tē. Lā' ixlīhuāk huan ixpekenī'n a'ntū tatō'ca', xla' xmān cāpekesita. Lā' chuntza' ā'chulā' māstā' ixtō'ca't. ");
INSERT INTO tooNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lā' nā chuntza' Dios cāmāpānūni'nī'ta'ni' a'ntū ko'hua'jua' porque hui'xina'n kalhlaka'ī'nī'ta'ntit huan līmāsca'tīn a'ntū iccāhuaninī'ta'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Caquilātā'latahui'lauj quit lā' chuntza' quit na'iccātā'latahui'layāni' hui'xina'n. Kentin ixpeken huan xamayāc xmān ixa'cstu tūlalh catika'lhīlh ixtō'ca't. Maclacasqui'n xa'nca nachi'pāna'n nac xamayāc. Palh hui'xina'n namāstā'yā'tit mintō'ca'tca'n, maclacasqui'n naquilātā'tahui'layāuj hua'chi huan ixpekenī'n mayāc chi'pāna'n na ixtojon. Xmān hui'xina'n mē'cstuca'n tūlalh catimāstā'tit mintō'ca'tca'n; tūlalh catitlahua'tit a'ntū Dios lacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Quit hua'chi xamayāc lā' hui'xina'n hua'chi ixpekenī'n. Lā' a'ntī pō'ktu quintatā'latahui'la, xlaca'n natamāstā' ixtō'ca'tca'n; natatlahua a'ntū Dios lacasqui'n. Hui'xina'n mē'cstuca'n tūlalh catitlahua'tit catūhuā porque lej maclacasqui'n quit na'iccāmaktāyayāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lā' a'ntīn tū' quintatā'latahui'la, xlaca'n nacālakmaka'ncan hua'chi huan ixpekenī'n a'ntū cāpeksitmaka'ncanī't lā' scōhuan lā' mākēxtimīcan lā' lhcuyucan. ");
INSERT INTO tooNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Palh hui'xina'n macaxtim naquilātā'latahui'layāuj, lā' palh tū' napātza'nkāyā'tit quintachihuīn, casqui'ntit chu a'ntū lacasqui'nā'tit lā' hui'xina'n nacātamaxquī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Palh hui'xina'n lej māstā'yā'tit mintō'ca'tca'n, palh lej tlahua'yā'tit a'ntū Dios lacasqui'n, chuntza' lī'a'cnī'ni'ni'yā'tit quinTāta'. Lā' chuntza' tasu'yu palh hui'xina'n stu'ncua' quisca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Quit iccāpāxquī'yāni' hui'xina'n chuntza' hua'chi quinTāta' quimpāxquī' quit. Lā' hui'xina'n pō'ktu caquilāpāxquī'uj quit. ");
INSERT INTO tooNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","QuinTāta' quimpāxquī' porque ica'kahuāna'ni' ixtachihuīn. Lā' nā hui'xina'n palh na'a'kahuāna'ni'yā'tit quintachihuīn, nā chuntza' na'iccāpāxquī'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Lā' quit iccāhuaninī'ta'ni' huā'mā' para que naka'lhī'yā'tit huan tapāxuhuān a'ntū icmāstā'. Lā' chuntza' lej naka'lhī'yā'tit tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Quilīmāpa'ksīn xla' ū'tza' huā'mā': calāpāxquī'tit hui'xina'n chu a'nchī quit iccāpāxquī'yāni' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kalhatin a'ntī līnīlh para namāpūtaxtū ixamigo, ū'tza' lej pāxquī'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hui'xina'n qui'amigos palh natlahua'yā'tit a'ntū iccālīmāpa'ksīyāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tū'tza' icticāmāpācuhuīni' quintasācua'nī'n porque huan tasācua' xla' tū' ca'tzī tuchū tlahuacu'tumā' ixpatrón. Hui'xina'n iccāhuaniyāni' qui'amigos porque quit iccāmāca'tzīnīyāni' ixlīhuāk a'ntū quihuanī quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Lā' tū' hui'xina'n quilālacsacui quit. Quit iccālacsacni' hui'xina'n. Lā' iccālīmāmacū'yāni' que napinā'tit lā' lej namāstā'yā'tit mintō'ca'tca'n a'ntū natāyani' para pō'ktu. Lā' nā chuntza' quinTāta' nacāmaxquī'yāni' ixlīhuāk a'ntū nasqui'ni'yā'tit por quinquilhtampān. ");
INSERT INTO tooNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Lā' ū'tza' huā'mā' iccālīmāpa'ksīyāni' hui'xina'n que calāpāxquī'tit milīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Lā' Jesús cāhuanipā: ―Palh huan xalanī'n nac quilhtamacuj cātaca'tzalaktzī'nāni' hui'xina'n, tū' natamakchuyī'yā'tit, porque nā quit xapū'la quintaca'tzalaktzī'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Palh hui'xina'n cahuā xalanī'n nac cā'quilhtamacuj, ixcātapāxquī'ni' huan xalanī'n nac quilhtamacuj, hua'chi talāpāxquī' xlaca'n. Quit iccālacsacni' lā' chuntza' hui'xina'n tū'tza' xalanī'n nac quilhtamacuj. Lā' ū'tza' cātalīca'tzalaktzī'nāni' hui'xina'n huan xalanī'n nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Capāstactit a'nchī iccāhuanini' que hui'xina'n tū' más laka'tla'n que quit. Hui'xina'n hua'chi quintasācua'nī'n lā' quit hua'chi mimpatronca'n. Como makapitzīn quintamacaputzanī't quit, nā hui'xina'n chuntza' nacātamacaputzayāni' makapitzīn. Lā' como ā'makapitzīn ta'a'kahuāna'ni'nī't quintachihuīn, nā hui'xina'n nacāta'a'kahuāna'ni'yāni' makapitzīn a'ntū namāsu'yuyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Lā' huāk huā'mā' nā nacātatlahuani'yāni' hui'xina'n por quimpālacata, porque xlaca'n tū' talakapasa a'ntī quimacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Palh quit tū' cahuā xa'icmilh iccāhuanī quintachihuīn, xlaca'n tū' ixtalē'lh cuenta por ixtalaclē'i'ca'n. Pero chuhua'j tūlalh catitahualh palh tū' talē'n cuenta por ixtalaclē'i'ca'n, como iccāhuaninī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","A'ntī quintaca'tzalaktzī'n quit, nā chuntza' quinTāta' taca'tzalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Xlaca'n nīn tuntū'yā cuenta ixtaka'lhīlh, palh quit cahuā tū' xa'ictlahualh na ixlacapūnca'n a'ntū tūla tlahua ā'chā'tin. Lā' a'yuj talaktzī'nī't huā'mā', quintaca'tzalaktzī'n quit, lā' nā quinTāta' taca'tzalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chuntza' pātle'ke porque maclacasqui'n natlōkentaxtū a'nchī tatzo'kni' na ixleyca'n: Quintaca'tzalaktzī'lh por nīn tuntū' ixpālacata. ");
INSERT INTO tooNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Namin huan Maktāyana'. U'tza' huan Espíritu Santo a'ntī nahuan ixlīstu'ncua'. U'tza' naminācha' a'nlhā hui'lacha' huan xaTāta'. Lā' quit na'iccālakmacā'nāchāni' a'nlhā hui'lacha' quinTāta'. Lā' namāsu'yu por quimpālacata. ");
INSERT INTO tooNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Lā' nā hui'xina'n nalīchihuīna'nā'tit por quimpālacata porque ixquintā'lahui'lāna'ntit quit desde iclītzuculh quilītlōt huā'tzā' nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Quit iccāhuanimā'ni' huā'mā' para que chuntza' tū' natatonkopūyā'tit a'xni'ca' napātīni'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Hui'xina'n nacātamātuxtekēyāni' de huan nac lītokpānna'. Namin lakatin chi'chini' a'ntū nacātapūmaknīyāni' hui'xina'n. Lā' a'ntī nacātamaknīyāni', xlaca'n natapuhuan que tatlahuamā'na a'ntū ixtapuhuān Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Huā'mā' natatlahua porque tū' maktin talakapasnī't quinTāta' lā' nā quit tū' quintalakapasnī't. ");
INSERT INTO tooNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Iccāhuaniyāni' huā'mā' para que chuntza' a'xni'ca' nacātamacaputzayāni', nalīpāstacā'tit a'nchī iccāhuanini' xapū'la. Lā' Jesús cāhuanipā: ―Quit tū' iccāhuanini' huā'mā' xapū'la porque quit xa'iccātā'lahui'lani' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Chuhua'j na'iclaka'mpala a'ntī quimacaminī't. Lā' hui'xina'n milīhuākca'n tū' quilākalhasqui'nī'nī'ta'uj: “¿Lhām pimpā't?” ");
INSERT INTO tooNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Chuhua'j hui'xina'n lej līlakaputzayā'tit porque iccāhuanimā'ni' huā'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Quit iccāhuaniyāni' ixlīstu'ncua'. Xalītzey para hui'xina'n palh quit na'ica'n. Palh quit tū' na'ica'n, tū' caticālakmini' a'ntī nacāmaktāyayāni' hui'xina'n. Lā' palh na'ica'n quit na'iccālakmacamināni' a'ntī nacāmaktāyayāni' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Lā' xla', a'xni'ca' namin, nacāmāca'tzīnī huan tachi'xcuhuī't nac quilhtamacuj a'nchī talaclē'n chā'tunu' de xlaca'n. Lā' nacāmāca'tzīnī tichū xatzey na ixlacapūn Dios. Lā' nacāmāca'tzīnī a'nchī Dios nacālacāxtlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nacāmāca'tzīnī xlaca'n que talaclē'n porque tū' quintakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nacāmāca'tzīnī que Dios quit quilaktzī'n palh xatzey, porque quit iclaka'mā' quinTāta' lā' hui'xina'n tū'tza' quintilālaktzī'uj. ");
INSERT INTO tooNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nacāmāca'tzīnī a'nchī Dios nacālacāxtlahua porque chuhua'j lacāxtlahuacanī'ttza' a'ntī māpa'ksī huā'mā' quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Lej lhūhua' sputa a'ntū iccāhuanicu'tunāni' pero hui'xina'n tūlalh catimāchekxī'tit chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","A'xni'ca' namin huan Espíritu Santo, a'ntī nahuan ixlīstu'ncua', xla' ū'tza' nacāmāsu'ni'kō'yāni' ixlīhuāk a'ntū ixlīstu'ncua'. Xla' tū' catichihuīna'lh por xmān ixpātunca'tzi. Xla' nacāhuaniyāni' xmān a'ntū huan xaTāta' nahuanī. Lā' nā nacāmāca'tzīnīyāni' hui'xina'n a'ntū napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Lā' xla' nā naqui'a'cnīni'ni' como nacāmāca'tzīnīyāni' hui'xina'n a'ntū iclacasqui'n que naca'tzīyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Huāk a'ntū ka'lhī quinTāta' nā quit quila'. Lā' ū'tza' iclīhualh que huan Espíritu Santo nacāmāca'tzīnīyāni' hui'xina'n a'ntū iclacasqui'n que naca'tzī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Lā' Jesús cāhuanipā: ―Lā' ā'macsti'na'j hui'xina'n tū' quintilālaktzī'uj. Lā' ā'macsti'na'j huampala hui'xina'n naquilālaktzī'mpalayāuj porque quit iclaka'mā' quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Lā' huan makapitzīn sca'txtunu'nī'n, xlaca'n talākalhasqui'nīlh: ―Lā' ¿tuchū huanicu'tun huā'mā'? Xla' quincāhuaniyāni' que ā'macsti'na'j tū' catilaktzī'uj lā' ā'macsti'na'j huampala chu nalaktzī'mpalayāuj. Lā' huā'mā' porque nalaka'n ixTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lā' ¿tuchū huanicu'tun ā'macsti'na'j? Tū' māchekxīyāuj a'ntū quincāhuanimā'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Lā' Jesús ca'tzīlh palh ixtakalhasqui'nīcu'tun lā' ū'tza' cālīhuanilh: ―Quit iccāhuanini' que ā'macsti'na'j tū' quintilālaktzī'uj lā' ā'macsti'na'j huampala chu naquilālaktzī'mpalayāuj. ¿Chu tū' ū'tza' huā'mā' a'ntū lākalhasqui'nī'pā'na'ntit hui'xina'n? ");
INSERT INTO tooNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ixlīstu'ncua' a'ntū iccāhuaniyāni'. Hui'xina'n nacalhua'nā'tit lā' nalakaputzayā'tit. Lā' huan tachi'xcuhuī't xalanī'n nac quilhtamacuj natalīpāxuhua. Lā' a'yuj pū'la nalakaputzayā'tit, ā'calīstān lej līpāxūj nalatahui'la'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","A'xni'ca' kalhatin puscāt namālacatuncuīnītza', xla' lakaputza porque pātī huan taca'tzāt. Lā' a'xni'ca' lacatuncuīnī'ttza' huan ska'ta', xla' tū'tza' pāstaca a'nchī pātīni'lh como chilhtza' nac quilhtamacuj lakatin ska'ta'. Lā' ū'tza' lej līpāxuhua. ");
INSERT INTO tooNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lā' nā chuntza' hui'xina'n chuhua'j lakaputzayā'tit. Lā' a'xni'ca' quit na'iccālakmimpalayāni' hui'xina'n lā' a'xni'ca' lej napāxuhua'yā'tit hui'xina'n. Lā' nīn tintī' caticāmaklhtīni' huā'mā' tapāxuhuān. ");
INSERT INTO tooNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Lā' a'xni'ca' namin huanmā' chi'chini', hui'xina'n nīn tuntū'tza' quintilākalhasqui'nīuj. Ixlīstu'ncua' a'ntū iccāhuaniyāni', quinTāta' nacāmaxquī'yāni' ixlīhuāk a'ntū nasqui'ni'yā'tit por quinquilhtampān. ");
INSERT INTO tooNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Lā' tūna'j squi'nī'ta'ntit nīn tuntū' por quinquilhtampān. Casqui'ntit lā' namaklhtīni'nā'tit. Lā' chuntza' lej nalīpāxuhua'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Lā' Jesús cāhuanipā: ―Lā' iccāhuaninī'ta'ni' huā'mā' hua'chi a'ntū lītalacastuca. Lā' namin huan quilhtamacuj a'xni'ca' tū'tza' icticātā'chihuīna'ni' chuntza'. Lej xa'nca na'iccātā'līchihuīna'nāni' quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Huanmā' quilhtamacuj hui'xina'n nasqui'ni'yā'tit quinTāta' por quinquilhtampān. Lā' tū'tza' timaclacasqui'lh palh quit na'icsqui'ni' quinTāta' por hui'xina'n, ");
INSERT INTO tooNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porque quinTāta' cāpāxquī'yāni' hui'xina'n. Hui'xina'n quilāpāxquī'yāuj quit lā' kalhlaka'ī'nī'ta'ntit palh quit icminī'ta'ncha' de Dios. Lā' ū'tza' xla' cālīpāxquī'yāni' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Quit icmincha' de quinTāta' lā' icmilh huā'tzā' nac quilhtamacuj. Lā' chuhua'j na'icmakxteka huā' quilhtamacuj lā' na'iclaka'mpala quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Lā' tuncan huan ī'sca'txtunu'nī'n tahuanilh: ―Chuhua'j lej xa'nca icmāchekxīyāuj a'ntū chihuīna'mpā't como tū'tza' chihuīna'mpā't hua'chi a'ntū lītalacastuca. ");
INSERT INTO tooNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lā' chuhua'j icca'tzīyāuj que hui'x lej ca'tzīya' ixlīhuāk. Lā' tū'tza' tasqui'nī nakalhasqui'nīca'na' hui'x. Lā' icca'tzīyāuj xa'nca que hui'x ta'nī'ta'nchi a'nlhā hui'lacha' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Lā' Jesús cākalhtīlh: ―Hua'chīlh kalhlaka'ī'yā'tittza'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mimā'tza' huan chi'chini', lā' chuhua'j huā'mā' quilhtamacuj a'xni'ca' hui'xina'n na'a'kahua'nā'tit. Milīhuākca'n hui'xina'n chā'tunu' napinā'tit na minchicca'n lā' quit naquilāmakxtekāuj quē'cstu. Lā' a'yuj quilāmakxtekui, tū' quē'cstu ictitahui'lalh porque quinTāta', xla' quintā'lahuī'. ");
INSERT INTO tooNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lā' iccāhuaniyāni' huā'mā' para que chuntza' tū' najicua'nā'tit porque hui'xina'n quilālīpāhuanāuj xmān quit. Lā' como lahui'lā'na'ntitcus nac quilhtamacuj, napātīni'nā'tit. Tū' cajicua'ntit. Quit ictlajanī't huan a'ntī māpa'ksī huan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Lā' a'xni'ca' huankō'lh huā'mā', Jesús talacayāhualh nac a'kapūn lā' hualh: ―Tāta', chilhtza' huan quilhtamacuj. Caqui'a'cnīni'ni' quit, mi'O'kxa', lā' nā chuntza' quit nā na'ica'cnīni'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quimaxquī'nī'ta' talacasqui' para na'iccāmāpa'ksī ixlīhuākca'n huan tachi'xcuhuī't. Lā' chuntza' quit tzē na'iccāmaxquī' xasāsti' ixquilhtamacujca'n para pō'ktu xlaca'n ixlīhuākca'n a'ntī quimacamaxquī'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Xlaca'n talakapasāni' hui'x lā' quintalakapasa quit, Jesucristo. Lā' taca'tzī que hui'x scana'nca Dios lā' que hui'x quimacata'nī'ta'. Chuntza' tasu'yu que xlaca'n taka'lhī xasāsti' ixquilhtamacujca'n para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Quit ica'cnīni'ni'nī'ta'ni' huā'tzā' nac quilhtamacuj. Lā' ictlahuakō'lhtza' a'ntū quilakma'cata' na'ictlahua. ");
INSERT INTO tooNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Chuhua'j Tāta', caqui'a'cnīni'ni' na milacapūn chuntza' hua'chi ixqui'a'cnīni'ni'ya' a'xni'ca' xa'ictā'lahui'lachāni' hui'x a'xni'ca' tūna'j ixa'nan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Lā' huan xalanī'n nac quilhtamacuj a'ntī hui'x quimacamaxquī'nī'ta', xlaca'n iccāmālakapasnīnī'ttza' a'ntī hui'x. Xlaca'n mila' ixtahuanī't lā' hui'x quimacamaxquī'nī'ta' lā' xlaca'n ta'a'kahuāna'ni'nī't milīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lā' chuhua'j xlaca'n taca'tzī que milīmāpa'ksīn ū'tza' a'ntū iclītlō ixlīhuāk. ");
INSERT INTO tooNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Quit iccāhuaninī't mintachihuīn a'ntū quihua'ni' hui'x. Lā' xlaca'n quintamaklhtīni'nī't. Lā' xlaca'n chuhua'j taca'tzītza' palh lej stu'ncua' icminī'ta'ncha' a'nlhā hui'la'chi hui'x. Lā' takalhlaka'ī'nī'ttza' palh hui'x quimacata'nī'ta'nchi. ");
INSERT INTO tooNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Quit icsqui'ni'yāni' por ū'tunu'n. Tū' icsqui'ni'yāni' por xalanī'n huā'tzā' nac quilhtamacuj. Icsqui'ni'yāni' xmān por xlaca'n a'ntī quimacamaxquī'nī'ta' porque xlaca'n huāk mila'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Huāk a'ntī quila' nā mila'. Lā' huāk a'ntī mila' nā quila'. Lā' quit quinta'a'cnīni'ni'nī't. ");
INSERT INTO tooNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Lā' chuhua'j quit na'iclakmimpalayāni' hui'x. Tū'tza' ictitachokolh nac quilhtamacuj. Xlaca'n natatachoko nac quilhtamacuj. Padre Santo, quinTāta', cacāmaktaka'lhti con milīmāpa'ksīn xlaca'n a'ntī quimacamaxquī'nī'ta' para que chu lakatin natala, hua'chi hui'x lā' quit chu lakatin. ");
INSERT INTO tooNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","A'xni'ca' xa'iclahuī' con ū'tunu'n, xa'iccāmaktaka'lha con milīmāpa'ksīn a'ntī quimacamaxqui' hui'x. Xa'iccāmaktaka'lha xlaca'n. Lā' chuntza' tū' tataxtutāyanī't nīn kalhatin de huan chi'xcuhuī'n, xmān ū'tza' a'ntī līhui'lī taxtutāya. Chuntza' tlōkentaxtūlh mintachihuīn chu a'nchī tatzo'kni'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Chuhua'j quit iclaka'mā'chāni'. Lā' līhuan icuī'cus huā'tzā' nac quilhtamacuj, quit icuan huā'mā' para que chuntza' xlaca'n nataka'lhī tapāxuhuān hua'chi quit. ");
INSERT INTO tooNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Quit iccāmaxquī'nī't mintachihuīn. Lā' huan xalanī'n nac quilhtamacuj taca'tzalaktzī'n xlaca'n. Cāca'tzalaktzī'ncan quinchi'xcuhuī'n porque xlaca'n tū' xalanī'n nac quilhtamacuj, chuntza' hua'chi quit tū' xala' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tū' icsqui'ni'mā'ni' que cacāma'xtu nac cā'quilhtamacuj. Quit icsqui'ni'yāni' que cacāmaktāya' para que huan ko'ti'ti' tū' nacātlaja. ");
INSERT INTO tooNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Xlaca'n tū' xalanī'n nac quilhtamacuj, chuntza' hua'chi quit tū' xala' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Lā' xalacuan cacālītlō't mintachihuīn, como mintachihuīn ū'tza' lej xastu'ncua'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hua'chi quima'cata'nī'ta' quit nac quilhtamacuj, nā chuntza' xlaca'n nā quit na'iccālakmacā'n huan xalanī'n nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Lā' por ixpālacataca'n quit na'iclītamacamāstā' quē'cstu hua'chi lē'ksajna' para que nā chuntza' xlaca'n stu'ncua' natala mila'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Lā' icsqui'nīmā'ni' por ū'tunu'n lā' por ixlīhuākca'n a'ntī nā natakalhlaka'ī' ā'calīstān por ixpālacata ixtachihuīnca'n xlaca'n a'ntī quila'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Icsqui'ni'yāni' que xlaca'n chu lakatin catalalh con quina'n, Tāta', chuntza' hua'chi chu lakatin quina'n, hui'x lā' quit. Catalalh chu lakatin para que chuntza' huan xalanī'n nac quilhtamacuj nā natakalhlaka'ī' palh hui'x quima'cata'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hua'chi hui'x qui'a'cnīni'ni'nī'ta', nā chuntza' quit iccā'a'cnīni'ni'nī't xlaca'n para que chu lakatin natala hua'chi quit lā' hui'x chu lakatin quina'n. ");
INSERT INTO tooNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Lā' quit iccātā'lahuī' xlaca'n chuntza' hua'chi hui'x quintā'lahui'la', para que xlaca'n natala chu lakatin. Chuntza' huan xalanī'n nac quilhtamacuj tzē nataca'tzī palh hui'x quima'cata'nī'ta' lā' palh hui'x nā cāpāxquī'ya' xlaca'n chuntza' hua'chi quimpāxquī'ya' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’QuinTāta', hui'x quimacamaxquī'nī'ta' xlaca'n. Lā' quit iclacasqui'n que nā xlaca'n catachā'lh a'nlhā quit na'icchā'n, para que chuntza' xlaca'n natalaktzī'n a'nchī qui'a'cnīni'ni'ya'. Hui'x qui'a'cnīni'ni'ya' como ixquimpāxquī'ya' xapū'la a'xni'ca' tūna'j ixa'nan huan quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tāta', hui'x xatzey. Lā' a'yuj tū' talakapasāni' huan tachi'xcuhuī't xalanī'n nac quilhtamacuj, pero quit iclakapasāni'. Lā' quinchi'xcuhuī'n, xlaca'n taca'tzī palh hui'x quima'cata'nī'ta'. ");
INSERT INTO tooNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Quit iccāmālakapasnīnī'ttza' tichū hui'x. Lā' na'iccāmālakapasnīcus para que chuntza' xlaca'n natapāxquī'nin chuntza' hua'chi hui'x quimpāxquī'ya'. Lā' nā chuntza' xlaca'n pō'ktu na'iccātā'lahuī'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Lā' Jesús a'xni'ca' tlahuakō'lh huan oración, taxtulh con ī'sca'txtunu'nī'n lā' ta'a'lh pātintacut huan pūxka Cedrón. A'ntza' ixuī' lakatin pū'olivo. Jesús a'ntza' cātā'tanūlh ī'sca'txtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Lā' nā huan Judas a'ntī namacamāstā' Jesús, xla' ixlakapasna'n a'ntza' porque lej maklhūhua' Jesús ixcātā'takēstoknī't a'ntza' con ī'sca'xtunu'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lā' a'ntza' nac pū'olivo Judas cālē'lh soldados lā' policíasna' a'ntī ixcāmālakachā'nī't huan xanapuxcu'nu' curas lā' huan fariseosnu'. Ixtalē'nācha' ixlīlhtucuyāhuanca'n lā' ixpūmakskoca'n lā' ixkanchi'chica'n. ");
INSERT INTO tooNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Lā' como Jesús ixca'tzīkō'tza' ixlīhuāk a'ntū napātle'keni', cātapajtzūni'lh lā' cākalhasqui'nīlh: ―¿Tichū putzayā'tit? ");
INSERT INTO tooNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Lā' xlaca'n takalhtīlh: ―Jesús xala' nac Nazaret. Lā' Jesús cākalhtīlh: ―Quit Jesús a'ntī putzayā'tit. Lā' a'ntza' ixcātā'yā Judas a'ntī namacamāstā' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lā' a'xni'ca' Jesús cāhuanilh: “Quit Jesús a'ntī putzayā'tit”, xlaca'n kēni'yaj ta'a'lh lā' ta'a'kā'lh nac ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Lā' Jesús chu cākalhasqui'nīpā: ―¿Tichū putzayā'tit? Lā' xlaca'n tahuampā: ―Jesús xala' nac Nazaret. ");
INSERT INTO tooNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús cāhuanilh: ―Iccāhuanintza' palh quit. Lā' palh quit quilāputzayāuj, cacāmakxtektit nata'a'n huā' makapitzīn. ");
INSERT INTO tooNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lā' hualh huā'mā' para que natlōkentaxtū a'ntū Jesús māni' ixuanī't: “Tū' tataxtutāyalh nīn kalhatin de huan chi'xcuhuī'n a'ntī quincāmacamaxquī'lh huan xaTāta'”. ");
INSERT INTO tooNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Lā' como Simón Pedro ixlē'nācha' ixmachīta, chu tuncan māxtulh lā' a'kacā'tēlh ixa'ka'xko'lh na ixa'kacāna'j a'ntī ixuanican Malco. Lā' xla' ū'tza' ixtasācua' ixuanī't huan xamāpa'ksīni' curasna'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús huanilh huan Pedro: ―Camānū'pala' mimachīta na mimpūmachīta. Quit iclīhui'līnī't para na'icpātī a'ntū ixtapuhuān quinTāta'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lā' tachi'palh Jesús huan soldados lā' ixcomandanteca'n lā' huan policías a'ntī ixlaca'n israelitas. Lā' macachī'ca. ");
INSERT INTO tooNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lā' lē'nca pū'la na ixchic Anás. Lā' huan papatzīn Anás ixpuhuiti' ixuanī't huan Caifás a'ntī xamāpa'ksīni' curasna' huanmā' cā'ta. ");
INSERT INTO tooNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Lā' huā'mā' Caifás chu ū'tza' a'ntī ixcāhuaninī't huan israelitas que más tzey palh kalhatin chi'xcu' nalīnī por ixpālacata ixlīhuākca'n huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Lā' ixtastālani'tēlha Jesús huan Simón Pedro lā' ā'kalhatin sca'txtunu'. Lā' huanmā' sca'txtunu' xla' nā ixlakapasa huan xamāpa'ksīni' curasna'. Lā' ū'tza' lītā'tanūlh Jesús na ixtanquilhni' ixchic huan xamāpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Lā' Pedro tachokolh kēpūn, ixpajtzu huan xamākalhcha tanquilhni'. Taxtulh huan sca'txtunu' a'ntī ixlakapasa huan xamāpa'ksīni' curasna'. Lā' tā'chihuīna'lh huan tzu'ma'jāt a'ntī ixmaktaka'lha mākalhcha. Lā' chuntza' huan sca'txtunu' tzē mānūlh huan Pedro nac tanquilhni'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Lā' huan tzu'ma'jāt a'ntī ixmaktaka'lha mākalhcha, xla' kalhasqui'nīlh huan Pedro: ―¿Chu tū' nā hui'x ī'sca'txtunu' huā'mā' chi'xcu'? Pedro kalhtīni'lh: ―Tū' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Lā' como lej ixlonknu'n, huan tasācua'nī'n lā' huan policías ixtahui'līnī't macscut lā' ixtayāna' lā' ixtasko'mā'na. Lā' nā a'ntza' ixmaklayā Pedro ī'sko'mā'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Lā' Anás a'ntī xamāpa'ksīni' curasna', xla' līkalhasqui'nīlh Jesús ixpālacata ī'sca'txtunu'nī'n lā' ixlīmāsca'tīn. ");
INSERT INTO tooNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Lā' Jesús huanilh: ―Quit icchihuīna'nī't calacan na ixlacapūnca'n ixlīhuākca'n. Pō'ktu xa'icmāsu'yu quit nac lītokpānna' lā' nac xaka'tla' lītokpān a'nlhā ixtatakēstoka huan israelitas. Lā' nīn tuntū' icuanī't lakatzē'k. ");
INSERT INTO tooNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Lā' ¿a'chī' quinkalhasqui'nī'ya' quit? Cacākalhasqui'ni' huan tachi'xcuhuī't a'ntī quintakaxmatnī't. U'tunu'n catahualh a'ntū iccāhuanilh. U'tunu'n taca'tzī a'ntū icuanī't quit. ");
INSERT INTO tooNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Lā' a'xni'ca' Jesús hualh huā'mā', kalhatin policía a'ntī ixlacahuayā a'ntza', lacala'syāhualh lā' huanilh: ―Lā' ¿chu chuntza' kalhtīcan huā' xamāpa'ksīni' curasna'? ");
INSERT INTO tooNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Lā' Jesús kalhtīlh: ―Palh sā' tū' tzey a'ntū icualh, cacāhua'ni' ixlīhuākca'n huā'tzā' a'ntū icualh. Lā' palh tzey a'ntū icualh quit, ¿a'chī' quintucsa'? ");
INSERT INTO tooNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anás lakmacā'lh Jesús xatamakachī'n huan Caifás a'ntī xamāpa'ksīni' curasna'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simón Pedro ixyā ī'sko'mā'. Lā' huanica: ―¿Chu tū' hui'x ī'sca'txtunu' huā'mā' chi'xcu'? Lā' Pedro chu kalhtatzē'kpā lā' hualh: ―Tū' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Lā' nā a'ntza' ixuī' kalhatin ixtasācua' huan xamāpa'ksīni' curasna'. Lā' xla' ixtalakapasni' ixuanī't a'ntī a'kacā'tēlh Pedro ixa'ka'xko'lh. Lā' huanmā' tasācua', xla' kalhasqui'nīlh Pedro: ―Lā' ¿chu tū' ictā'laktzī'ni' Jesús huan nac pū'olivo? ");
INSERT INTO tooNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Lā' Pedro chu kalhtatzē'kpā lā' chu tuncan ta'salh huan lakatin gallo. ");
INSERT INTO tooNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lā' cā'tzi'sāt ixuanī't a'xni'ca' māxtuca Jesús de huan na ixchic Caifás lā' lē'nca na ixchic huan gobernador. Lā' huan israelitas, xlaca'n tū' tatanūlh nac huan chic. Palh ixtatanūlh cahuā, chuntza' ko'hua'jua' ixtalalh chu a'nchī ixtalanānca'n. Lā' chuntza' tūlalh ixtahua'lh huan līhua't ixla' huan cā'tani' a'ntū huanican pascua. ");
INSERT INTO tooNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lā' ū'tza' lītaxtulh Pilato para nacātā'chihuīna'n. Lā' cāhuanilh: ―Lā' ¿tuchū ixpālacata līlē'ksa'nī'ni'nā'tit huā'mā' chi'xcu'? ");
INSERT INTO tooNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Lā' xlaca'n takalhtīni'lh: ―Palh tū' cahuā xla' lej laclē'n, tū' xa'icticāmacamaxquī'ni' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Lā' Pilato cāhuanilh: ―Pues calī'pintit hui'xina'n lā' calacāxtlahua'tit chu a'nchī ka'lhī'yā'tit mileyca'n hui'xina'n. Lā' huan israelitas takalhtīlh: ―Pero quina'n israelitas tū' icka'lhīyāuj līmāpa'ksīn para na'icmaknīyāuj catīhuā. ");
INSERT INTO tooNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chuntza' pātle'kelh para que natlōkentaxtū a'ntū ixuanī't Jesús ixpālacata a'nchī nalīnī. ");
INSERT INTO tooNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Lā' Pilato chu tanūpā na ixpūchihuīn lā' ta'sani'lh huan Jesús lā' kalhasqui'nīlh: ―¿Chā hui'x huan ixreyca'n israelitas? ");
INSERT INTO tooNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Lā' Jesús huanilh: ―¿Chā mimpātunca'tzi quinkalhasqui'nī'ya' huā'mā' o talītā'chihuīna'nī'ta'ni' ā'makapitzīn por quimpālacata? ");
INSERT INTO tooNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Lā' Pilato kalhtīlh: ―¿Chu quit israelita? Quintamacamaxquī'ni' hui'x mintā'israelitas lā' huan xanapuxcu'nu' curasna'. Lā' ¿tuchū tlahua'nī'ta'? ");
INSERT INTO tooNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Lā' Jesús kalhtīlh: ―Quit tū' icmāpa'ksīni'n nac huā'mā' quilhtamacuj. Palh chuntza' cahuā, quinchi'xcuhuī'n ixquintalē'katāyalh xlaca'n a'xni'ca' quintachi'palh huan israelitas. Tū' icmāpa'ksīni'n huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Lā' Pilato kalhasqui'nīlh: ―¿Pues hui'x chō'la rey? Lā' Jesús kalhtīlh: ―Stu'ncua' a'ntū huanī'ta'. Quit iclacatuncuīlh lā' icmilh huā' nac quilhtamacuj para na'icuan a'ntū ixlīstu'ncua'. Ixlīhuākca'n a'ntī taca'tzīcu'tun a'ntū ixlīstu'ncua', xlaca'n quintakaxmata. ");
INSERT INTO tooNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Lā' Pilato huanilh: ―¿Chichū līca'tzīcan tuchū ixlīstu'ncua'? Lā' a'xni'ca' Pilato ixuanī'ttza' huā'mā', xla' cālaktaxtupā huan israelitas lā' cāhuanilh: ―Pues quit tū' icmakkaksa nīn lakatin ixtalaclē'i' huā'mā' chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Hui'xina'n ka'lhīyā'tit mintalanānca'n que cā'ta cā'ta quit na'icmakxteka kalhatin tachī'n a'xni'ca' lamā' huan cā'tani' a'ntū huanican pascua. ¿Lacasqui'nā'tit que na'iccāmakxtekni'yāni' ixReyca'n israelitas? ");
INSERT INTO tooNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lā' ixlīhuākca'n tata'sapā lā' tahualh: ―¡Xla' tū'! ¡Camakxtekti huan Barrabás! Lā' huanmā' Barrabás xla' ka'lhāna' ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lā' Pilato mākēsno'knīni'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Lā' huan soldados tatlahualh lakatin corona de lhtucū'n lā' tamūhui'līlh huan Jesús lā' tamālhakē'lh lakatin ixlu'xu' xasmumonko' como chuntza' ixtalhakā'nan reyes. ");
INSERT INTO tooNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lā' ixtalaktapajtzū lā' ixtahuanī: ―¡Lej tzehuanī't ixReyca'n israelitas! Lā' ixtalacala'syāhua. ");
INSERT INTO tooNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Lā' Pilato chu cālaktaxtupā huan tachi'xcuhuī't lā' cāhuanilh: ―Calaktzī'ntit. Quit iccāmāxtuni'yāni' para que hui'xina'n chuntza' naca'tzīyā'tit que quit tū' icmakkaksnī't nīn lakatin ixtalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lā' taxtulh Jesús. Lā' ixmūhuī' lakatin corona de lhtucū'n. Lā' ixlhakā'nī't huan lu'xu' xasmumonko'. Lā' tuncan Pilato cāhuanilh: ―¡A' yā huā' chi'xcu'! ");
INSERT INTO tooNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lā' a'xni'ca' talaktzī'lh huan xanapuxcu'nu' curasna' lā' huan policías, xlaca'n tatzuculh tata'sa lā' tahualh: ―¡Caxtokohua'ca'ca! ¡Caxtokohua'ca'ca! Lā' Pilato cāhuanilh: ―Calīpintit lā' caxtokohua'ca'tit hui'xina'n. Quit tū' icmakkaksa nīn lakatin ixtalaclē'i'. ");
INSERT INTO tooNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Lā' huan israelitas takalhtīlh: ―Quina'n icka'lhīyāuj lakatin ley. Lā' chu a'nchī huan huā'mā' ley, tasqui'nī nanī huā'mā' chi'xcu' porque māni' xla' huan que ū'tza' ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lā' Pilato, a'xni'ca' kaxmatli que Jesús ixuanī't que xla' ixO'kxa' Dios, xla' ā'chulā' jicua'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Lā' tanūpā na ixpūchihuīn lā' kalhasqui'nīpā Jesús: ―Lā' ¿lhachū xala' hui'x? Jesús tū' kalhtīlh. ");
INSERT INTO tooNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato huanilh: ―¿Quit tū' quintikalhti? ¿Chu tū' ca'tzīya' palh quit icka'lhī talacasqui' para que tzē na'icmakxtekāni' lā' nā icka'lhī talacasqui' para que tzē na'icxtokohua'ca'yāni'? ");
INSERT INTO tooNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Lā' Jesús kalhtīlh: ―Palh tū' cahuā Dios ixmaxquī'ni' talacasqui', hui'x tū' ixka'lhi' nīn lakatin talacasqui' para ixquintlahua'ni' catūhuā. Lā' huan chi'xcu' a'ntī quimacamāstā'lh con hui'x, xla' ā'chulā' lej ka'tla' ka'lhī ixtalaclē'i' que hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Lā' a'xni'ca' kaxmatli huā'mā', Pilato ā'chulā' makxtekcu'tulh Jesús. Lā' huan israelitas tata'salh lā' tahuanilh: ―¡Palh hui'x namakxteka', hui'x tū' ixamigo César, a'ntī ixmāpa'ksīni'ca'n romanos! ¡Chu a'ntī lītanūcu'tun ixlīrey, xla' ū'tza' ixtā'ca'tza César! ");
INSERT INTO tooNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lā' a'xni'ca' kaxmatli Pilato huā'mā', māmāxtunīni'lh Jesús. Lā' tahui'lh a'nlhā xla' ixtlahua justicia a'nlhā huanican Empedrado lā' nā hebreo ixtacuīni' Gabata. ");
INSERT INTO tooNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Lā' ī'sputa xmān lakatin chi'chini' para natzucu huan cā'tani' a'ntū huanican pascua. Lā' hua'chi cā'tāstu'nūta huan Pilato cāhuanilh huan israelitas: ―¡A' yā miReyca'n! ");
INSERT INTO tooNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Lā' xlaca'n tata'salh lā' tahualh: ―¡Camaknīca! ¡Camaknīca! ¡Caxtokohua'ca'ca! Lā' Pilato cāhuanilh: ―¿Chu lakasqui'nā'tit naxtokohua'ca'can miReyca'n? Lā' huan xanapuxcu'nu' curasna' takalhtīni'lh: ―Quina'n icka'lhīyāuj xmān kalhatin quireyca'n. Lā' ū'tza' César. ");
INSERT INTO tooNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Lā' tuncan Pilato cāmacamaxquī'lh xlaca'n para nataxtokohua'ca'. Lā' xlaca'n talē'lh. ");
INSERT INTO tooNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús taxtulh lā' ixcu'ca'lē'mā' ixcruz. Lā' chā'lh a'nlhā huanican Ixa'kxāk Nīn lā' nā hebreo ixtacuīni' Gólgota. ");
INSERT INTO tooNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Lā' a'ntza' xtokohua'ca'ca lā' nā cāxtokohua'ca'ca ā'kalhatu' na ixpāxtūtunnu' Jesús. Lā' Jesús pu'nan ixmā'ca'canī't. ");
INSERT INTO tooNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Lā' Pilato māhui'līnīni'lh lakatin letrero huan nac cruz a'ntū ixuan chuntza': Jesús xala' nac Nazaret, ixReyca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lā' como huan lhā xtokohua'ca'ca Jesús pajtzu ixuanī't de nac cā'lacchicni' lā' lej lhūhua' israelitas talaktzī'lh huan letrero. Lā' huan letrero tāpātu'tun tachihuīn ixtzo'kcanī't: hebreo lā' griego lā' latín. ");
INSERT INTO tooNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Huan xanapuxcu'nu' curasna' tahuanilh huan Pilato: ―Tū' ixtzo'kti: “IxReyca'n israelitas”. Chuhua'j catzo'kti que ū'tza' hualh: “Quit ixReyca'n israelitas”. ");
INSERT INTO tooNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Lā' Pilato cākalhtīlh: ―A'ntū ictzo'klitza' chuntza' natachoko. ");
INSERT INTO tooNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lā' a'xni'ca' huan soldados ixtaxtokohua'ca'nī'ttza' huan Jesús, tasacni'lh ixlu'xu' huan kalhatā'ti' soldados lā' tamālacpitzilh. Lā' huan ixtakēnu' xla' tū' xatatza'pa' ixuanī't; ixtacāxtlahuanī't chu kalhtin de ixa'cpūn lā' hasta ixtampān. ");
INSERT INTO tooNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Lā' huan soldados talāhuanilh: ―Tū' calacxtitui. Xatzey capūmāxtūj suerte para que chuntza' natasu'yu a'ntī natachokoni'. Lā' chuntza' tlōkentaxtūlh ixtachihuīn Dios a'nlhā tatzo'kni': Tamālacpitzilh quilu'xu' lā' tapūmāxtulh suerte para que natasu'yu a'ntī natachokoni'. Lā' chuntza' tatlahualh huan soldados. ");
INSERT INTO tooNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lā' ixpajtzu huan cruz a'nlhā ixmā'ca'canī't Jesús, ixtayāna' ixtzī't Jesús lā' xapuscāt ixtā'tin ixtzī't lā' huan María ixpuscāt huan Cleofas, lā' María Magdalena. ");
INSERT INTO tooNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Lā' Jesús cālaktzī'lh ixtzī't lā' huan sca'txtunu' a'ntī ixmakyā. Lā' huan sca'txtunu' ū'tza' ixuanī't a'ntī lej ixpāxquī'. Lā' Jesús huanilh ixtzī't: ―Nā'. A' yā a'ntī nala hua'chi mi'o'kxa'. ");
INSERT INTO tooNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Lā' tuncan huanilh huan sca'txtunu': ―U'tza' huā'yā puscāt a'ntī nala hua'chi mintzī't. Lā' desde a'xni'ca', huanmā' sca'txtunu' mānūlh na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lā' Jesús ixca'tzītza' palh ixtlōkentaxtūkō'canī'ttza' ixlīhuāk. Lā' chu a'nchī tatzo'kni' na ixtachihuīn Dios, xla' hualh: ―Ickalhpūtī. ");
INSERT INTO tooNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Lā' a'ntza' ixuī' lakatin xālu ixlītzuma vinagre. Lā' līmāchū'huī'ca vinagre nac lakatin a'ntū hua'chi panamāc. Lā' o'ksmā'ca'ca huan ixpeken qui'hui' a'ntū huanican hisopo lā' tacha'xni'lh hasta na ixquilhni'. ");
INSERT INTO tooNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Lā' Jesús tzu'tzu' hua'lh huan vinagre. Lā' tuncan hualh: ―Ixlīhuāk ictlōkentaxtūkō'nī'ttza'. Jesús māquilhpūtīlh ixa'kxāk lā' tamacamāstā'lh ixa'cstu con Dios lā' chuntza' ixa'cstu tamakxtekli nanī. ");
INSERT INTO tooNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lā' xmāntza' ā'lakatin chi'chini' ī'sputa para huan cā'tani' a'ntū huanican pascua. Lā' huan israelitas, xlaca'n tū' ixtalacasqui'n que huan ixmacni'ca'n sputnī'n natatachoko huan nac cruznu' huan chi'chini' a'ntū pūjaxcan, porque huanmā' chi'chini' xla' ū'tza' lej ixtamaclacā'ni'. Lā' ū'tza' līsqui'ni'ca Pilato que nacāmāchākētu'cxnīni'n a'ntī ixcāxtokohua'ca'canī't lā' nacāmāyujūnīni'n huan ixmacni'ca'n sputnī'n. ");
INSERT INTO tooNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Lā' huan soldados ta'a'lh lā' tachākētu'cxli huan kalhatu' chi'xcuhuī'n a'ntī ixcātā'xtokohua'ca'canī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","A'xni'ca' talaktapajtzūlh huan Jesús, talaktzī'lh que xanīntza' ixuanī't. Lā' ū'tza' tū' līchākētu'cxca xla'. ");
INSERT INTO tooNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Lā' kalhatin soldado tāpālhtuculh Jesús con ixlanza lā' chu tuncan taxtulh ka'lhni' lā' xcān. ");
INSERT INTO tooNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Quit Juan lā' iclaktzī'lh huā'mā'. A'ntū icuan ū'tza' a'ntū stu'ncua'. Iccāhuaniyāni' huā'mā' para que chuntza' nā hui'xina'n nakalhlaka'ī'yā'tit. ");
INSERT INTO tooNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lā' huā'mā' pātle'kelh para natlōkentaxtū ixtachihuīn Dios chu a'nchī tatzo'kni': Tū' catitu'cxni'ca nīn kantin ixlucut. ");
INSERT INTO tooNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Lā' nā chuntza' tatzo'kni': Xlaca'n natalaktzī'n a'ntī tāpālhtucucanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lā' a'xni'ca' ixpātle'kenī't huā'mā', José xala' nac Arimatea squi'ni'lh Pilato para que namakxteka nalē'n ixmacni' Jesús. Huā'mā' José nā ū'tza' a'ntī lakatzē'k ixkalhlaka'ī' Jesús porque xla' ixcājicua'ni' huan israelitas. Pilato makxtekni'lh José lā' xla' a'lh lā' lē'lh huan ixmacni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Lā' nā tā'a'lh huan Nicodemo a'ntī pū'la ixlakminī't cā'tzī'sa huan Jesús, lā' xla' līmīlh catūhuā a'ntū lej mu'csa a'ntū ixlīcāxtlahuacanī't mirra lā' áloes. Lā' hua'chi pu'xamacāuj kilos līmilh huan Nicodemo. ");
INSERT INTO tooNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Lā' chuntza' José lā' Nicodemo talē'lh huan ixmacni' Jesús lā' talīpāsna'tli lu'xu' lā' nā tatā'mānūlh huan a'ntū lej mu'csa a'ntū ixtalīminī't. Chuntza' ixtaka'lhī ixtahui'latca'n huan israelitas a'xni'ca' ixtamā'cnūnu'n. ");
INSERT INTO tooNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Lā' a'nlhā xtokohua'ca'ca Jesús, pajtzu ixuī' lakatin pū'olivo lā' a'ntza' ixuī' lakatin lhu'cu' a'ntū ixtlahuacanī't para namā'cnūcan catīhuā, lā' a'ntza' tintī'na'j ixmā'cnūcanī't, nīn kalhatin. ");
INSERT INTO tooNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Lā' como huanmā' lhu'cu' pajtzu ixuī' lā' a'ntza' mānūca ixmacni' Jesús como ixtzucumā'tza' huan chi'chini' a'ntū ixtapūjaxa israelitas. ");
INSERT INTO tooNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cā'domingo lej cā'tzi'sāt a'xni'ca' cā'pucsua'cus ixuanī't, lā' María Magdalena a'lh huan nac lhu'cu' a'nlhā ixmānūcanī't Jesús. Xla' laktzī'lh tū'tza' ixuī' huan chihuix a'ntū ixkalhui'līcanī't huan lhu'cu'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tu'jnuntēlha cālaka'lh huan Simón Pedro lā' ā'kalhatin sca'txtunu' a'ntī lej ixpāxquī' Jesús. Lā' cāhuanilh: ―Māxtucanī't de nac lhu'cu' huan Māpa'ksīni' lā' tū' icca'tzīyāuj a'nlhā mā'cnūca. ");
INSERT INTO tooNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Lā' Pedro lā' huan ā'kalhatin sca'txtunu' tataxtulh lā' ixta'a'mā'na huan nac lhu'cu'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ixkalhatu'ca'n ixtatu'jnuntēlha a'cxtim. Lā' ā'calīstān kalhatin ā'chulā' tu'jnulh. Lā' Pedro a'kapū'laca. Lā' xapū'la chā'lh huan nac lhu'cu' huan ā'kalhatin sca'txtunu'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lā' taquilhpūtalh lā' talacanūlh lā' laktzī'lh a'ntza' ixuī' huan lu'xu' a'ntū ixlīpāsna'tcanī't Jesús. Lā' huan sca'txtunu' tū' tanūlh. ");
INSERT INTO tooNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Lā' Simón Pedro ī'stālatēlha. Lā' ā'calīstān xla' chā'lh lā' tanūlh huan nac lhu'cu' lā' a'ntza' laktzī'lh huan lu'xu' a'ntū ixlīpāsna'tcanī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nā laktzī'lh huan pāyu a'ntū ixlītakoksna'tnī't na ixa'kxāk Jesús. Lā' tū' ixtā'huī' huan lu'xu'; lacatin ixuī' lā' ixpāsui'tui'līcanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lā' nā tanūlh huan sca'txtunu' a'ntī xapū'la ixchinī't huan nac lhu'cu' lā' laktzī'lh lā' a'ka'ī'lh que Jesús ixlakahuanchokonī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Lā' tūna'j ixtamāchekxīkō' huan ixtachihuīn Dios a'nlhā ixtatzo'kni' que tasqui'nī nalakahuanchoko Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lā' huan tamā'na sca'txtunu'nī'n ta'a'mpā na ixchicca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Lā' María tāyalh ixtanquilhni' huan lhu'cu' a'nlhā ixmānūcanī't Jesús. Lā' ixcalhuan. Lā' līhuan ixcalhuayā, taquilhpūtalh lā' talacanūlh huan nac lhu'cu'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Lā' cālaktzī'lh kalhatu' ángeles lā' lej lakstala'nka' ixtaka'lhī ixlu'xu'ca'n. Xlaca'n ixtahui'lāna' a'nlhā ixmāpī'canī't huan ixmacni' Jesús. Kalhatin ixuī' na ixa'cpūn lā' kalhatin nā ixuī' na ixtojon a'nlhā ixmāpī'canī't Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Lā' huan ángeles takalhasqui'nīlh: ―Puscāt, ¿a'chī' calhua'na'? Lā' xla' cāhuanilh: ―Lē'nca ixmacni' quiMāpa'ksīni'. Lā' tū' icca'tzī lhachū mānūcanī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lā' a'xni'ca' ixuanī'ttza' huā'mā', chu tuncan xla' talakspi'tli lā' laktzī'lh Jesús a'ntza' ixyā. Lā' xla' tū' ixlakapasa palh ū'tza' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Lā' Jesús huanilh: ―Puscāt, ¿a'chī' calhua'yā't? ¿Tichū putzaya'? Lā' huan puscāt xla' ixpuhuan ū'tza' huan maktaka'lhna' pū'olivo lā' huanilh: ―Señor, palh hui'x lī'pi, caquihua'ni' a'nlhā lī'pi, para que chuntza' quit na'ica'n ictē. ");
INSERT INTO tooNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Lā' Jesús huanilh: ―¡María! Lā' xla' chu talakspi'tpā lā' huanilh: ―¡Raboni! ―ū'tza' lakatin tachihuīn hebreo a'ntū huanicu'tun Mākalhtō'kē'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Lā' Jesús huanilh: ―Tū' caquixa'ma' porque quit tūna'j ictā'kayāhua a'nlhā hui'lacha' quinTāta'. Capinchi lā' cacāhua'ni' huan tā'timīn que quit na'ictā'kayāhua a'nlhā hui'lacha' quinTāta'. Lā' ū'tza' nā minTāta'ca'n lā' quinDios lā' minDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Lā' tuncan María Magdalena a'lh cāmāca'tzīnī huan sca'txtunu'nī'n que xla' ixlaktzī'nī'ttza' huan Māpa'ksīni' lā' cāhuanilh a'ntū ixuaninī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lā' a'xni'ca' ī'smalanka'namā'tza' huanmā' domingo lā' huan sca'txtunu'nī'n ixtatakēstokkō'nī't nac lakatin chic. Lā' lacchahuaj ixtatanūmā'na porque xlaca'n ixtajicua'ni' huan israelitas. Lā' Jesús tanūlh lā' tāyalh na ixlaclhpu'nanca'n lā' cāhuanilh: ―Xa'nca' cacā'a'nīni'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Lā' a'xni'ca' ixcāhuaninī'ttza' huā'mā', cāmāsu'ni'lh ixmacan lā' ixtāpān. Lā' huan sca'txtunu'nī'n lej tapāxuhualh porque talaktzī'mpā huan Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Lā' Jesús chu cāhuanipā: ―Xa'nca cacā'a'nīni'ni' hui'xina'n. Chuntza' a'nchī quimacamilh quinTāta' lā' nā chuntza' hui'xina'n na'iccāmacā'nāni' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lā' a'xni'ca' huankō'lh huā'mā', Jesús cāsu'nulh xlaca'n lā' cāhuanilh: ―Chuhua'j, caquilāmaklhtīuj huā' Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Palh hui'xina'n māsputūnu'ni'yā'tit ixtalaclē'i' kalhatin, xla' tū'tza' laclē'n. Lā' palh hui'xina'n tū' catimāsputūnu'ni'tit ixtalaclē'i' kalhatin, xla' ū'tza' laclē'ncus. ");
INSERT INTO tooNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kalhatin sca'xtunu' ixtacuīni' Tomás lā' nā ixuanican Stu'yūn. Xla' tū' ixmaklahuī' con huan ā'makapitzīn sca'txtunu'nī'n a'xni'ca' cātalacsu'yuni'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Lā' xlaca'n tahuanilh: ―Iclaktzī'ujtza' huan Māpa'ksīni'. Tomás cāhuanilh: ―Palh tū' na'iclaktzī'n a'nlhā takāhuī'nī't na ixmakxtampūn lā' palh tū' na'icxa'mani' a'nlhā ixtanūni'nī't clavos, lā' palh tū' na'icxa'ma ixtāpān a'nlhā takāhuī'nī't, tū' ictikalhlaka'ī'lh palh lakahuanchokonī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Lā' ixlītzeyama'j huampala ixtatakēstokpalanī't huan sca'txtunu'nī'n lā' nā Tomás a'ntza' ixmakuī'. Lā' a'yuj ixlacchahuayā huan chic, Jesús tanūlh lā' tāyalh na ixlaclhpu'nanca'n lā' cāhuanilh: ―Xa'nca cacā'a'nīni'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lā' tuncan huanica Tomás: ―Camānu' mimakspulh na quimakxtampūn a'nlhā quimakxtampūlhu'cu'canī't lā' calaktzi' quimacan lā' castu'ncti mimacan lā' caxa'ma' quintāpān. Lā' tū'tza' capuhua' palh tū' stu'ncua' iclakahuanchokonī't. Cakalhlaka'i'. ");
INSERT INTO tooNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Lā' Tomás kalhtīni'lh: ―¡QuiMāpa'ksīni' lā' quinDios! ");
INSERT INTO tooNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Lā' Jesús huanilh: ―Tomás, chuhua'j hui'x kalhlaka'ī'ya' porque quilaktzī'nī'ta'. Līpāxūj a'ntī takalhlaka'ī' lā' a'yuj xlaca'n tū' quintalaktzī'nī't. ");
INSERT INTO tooNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Lā' Jesús tlahuapā lej lhūhua' lē'cnīn na ixlacapūnca'n ī'sca'txtunu'nī'n. Lā' huan tamā'na lē'cnīn xla' tū' tatzo'kni' huā' nac libro. ");
INSERT INTO tooNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Makapitzīn lē'cnīn xla' tatzo'kni' para que chuntza' hui'xina'n nakalhlaka'ī'yā'tit que Jesús xla' ū'tza' ixO'kxa' Dios a'ntī Dios mānūlh ixlīmāpūtaxtunu', lā' chuntza' hui'xina'n tzē naka'lhī'yā'tit xasāsti' minquilhtamacujca'n por ixpālacata nalīpāhua'nā'tit Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lā' ā'calīstān Jesús cātasu'yuni'pā ī'sca'txtunu'nī'n na ixquilhtūn huan xcān a'ntū ixtacuīni' Galilea, lā' nā ixuanican Tiberias. Lā' a'xni'ca' talacsu'yulh chuntza' līlalh: ");
INSERT INTO tooNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A'ntza' ixtahui'lāna' kēxtim Simón Pedro lā' Tomás, a'ntī ixuanican Stu'yūn, lā' Natanael xala' nac Caná de Galilea, lā' ixo'kxa'n Zebedeo lā' ā'kalhatu' ī'sca'txtunu'nī'n Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Lā' Simón Pedro cāhuanilh: ―Ica'nā icsquī'tī'nin. Lā' xlaca'n tahualh: ―Nā quina'n na'iccātā'a'nāni'. Ta'a'lh lā' tatanūlh nac barco. Lā' nīn tuntū' tachi'palh ixlīhuāk huanmā' tzī'sa. ");
INSERT INTO tooNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Lā' a'xni'ca' tzuculh tuncuī, Jesús cātasu'yuni'lh na ixquilhtūn xcān. Lā' huan sca'txtunu'nī'n tū' ixtaca'tzī tichū. ");
INSERT INTO tooNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lā' Jesús cāhuanilh: ―Chi'xcuhuī'n, ¿tuchū chi'panī'ta'ntit? Lā' xlaca'n takalhtīlh: ―Nīn tuntū'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Lā' Jesús cāhuanilh: ―Camacapintit huan pūtayan na ixpāxtūcāna'j huan barco. Lā' a'ntza' nachi'payā'tit. Lā' chuntza' tatlahualh xlaca'n. Lā' tuncan tūlatza' ixtamācutū huan ixpūtayanca'n porque lej lhūhua' squī'ti' ixtalaknūnī't. ");
INSERT INTO tooNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Huan sca'txtunu' a'ntī lej ixpāxquī' Jesús, xla' huanilh Pedro: ―¡U'tza' huan Māpa'ksīni'! Lā' a'xni'ca' huanica huā'mā', Simón Pedro chu tuncan lhakā'lh ixtakēnu' a'ntū ixtamakxtunī't lā' xla' chu tuncan tojōlh nac xcān lā' laka'lh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Lā' huan barco pajtzu huan quilhtūn ixuanī't, hua'chi cien metros ixlīmakat ixuanī't. Lā' huan makapitzīn ixtapūmimā'na huan barco lā' ixtastancalīmimā'na huan ixpūtayanca'n a'ntū ixpūtalaknūnī'ta'ncha' lhūhua' squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lā' a'xni'ca' tatacutchi xlaca'n talaktzī'lh pūlactin macscut de carbón lā' ixkalhmā'ca'canī't huan jala'nat lakatin squī'ti' lā' pāntzi. ");
INSERT INTO tooNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Lā' Jesús cāhuanilh: ―Calīta'ntit macsti'na'j squī'ti' a'ntū chi'patittza'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Lā' Simón Pedro tuncan tojōlh nac barco lā' stancalīmilh huan pūtayan nac quilhtūn. Lā' huan pūtayan ixpūtalaknūnī'ta'ncha' lakatin ciento tu'pu'xamacāujtu'tun laka'tla'n squī'ti'. Lā' a'yuj lej lhūhua' squī'ti' ixtalaknūnī't, pero huan pūtayan tū' taxtī'tli. ");
INSERT INTO tooNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Lā' Jesús cāhuanilh: ―Cata'ntit, cahuā'ya'ntit. Lā' nīn chā'tin sca'txtunu' talīhui'līlh natakalhasqui'nī tichū porque ixtaca'tzī palh ū'tza' Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesús quītayalh huan pāntzi lā' cāmaxquī'lh xlaca'n. Lā' chu chuntza' tlahuapā huan squī'ti'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Huā'mā' a'nlhā ixlīmaktu'tun cātasu'yuni'lh ī'sca'txtunu'nī'n a'xni'ca' ixlakahuanchokonī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A'xni'ca' tahuā'yankō'lh, Jesús kalhasqui'nīlh huan Simón Pedro: ―Simón, ixo'kxa' Jonás, ¿chā más quimpāxquī'ya' quit que huā' ā'makapitzīn chi'xcuhuī'n quintapāxquī'? Lā' Pedro kalhtīlh: ―U'huē, Māpa'ksīni'. Hui'x ca'tzīya' palh icpāxquī'yāni'. Jesús huanilh: ―Cacāmaktāya' a'ntī quintakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Lā' chu kalhasqui'nīpā ixlīmaktu': ―Simón, ixo'kxa' Jonás, ¿chā quimpāxquī'ya'? Lā' Pedro kalhtīlh: ―U'huē, Māpa'ksīni'. Hui'x ca'tzīya' palh icpāxquī'yāni'. Lā' Jesús huanilh: ―Cacāmaktaka'lhti a'ntī quintakalhlaka'ī' chuntza' hua'chi līlacatzucu cāmaktaka'lha ixborregos a'ntī ixtēcu'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Lā' ixlīmaktu'tun chu kalhasqui'nīpā: ―Simón, ixo'kxa' Jonás, ¿chā quimpāxquī'ya'? Lā' Pedro līlakaputzalh porque xla' kalhasqui'nīca ixlīmaktu'tun palh ixpāxquī' Jesús. Lā' huanilh: ―Māpa'ksīni' huix ca'tzīya' ixlīhuāk. Hui'x ca'tzīya' palh icpāxquī'yāni'. Lā' Jesús huanilh: ―Cacāmaktāya' a'ntī quintakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Icuaniyāni' quit ixlīstu'ncua'. A'xni'ca' o'kxa'cus ixuanī'ta', hui'x ixlhakā'na'na' lā' ixpina' chu a'nlhā ixpincu'tuna'. A'xni'ca' papatzīntza' nala'ya' hui'x, nalacstū'nca' mimpekenī'n lā' ā'kalhatin namacachī'yāni' lā' xla' nalē'nāni' a'nlhā tū' pincu'tuna' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Lā' chuntza' Jesús ixlīhuanimā' Pedro a'nchī xla' nalīnī lā' chuntza' huā'mā' nalī'a'cnīni'ni' Dios. Lā' ā'calīstān huanilh: ―Caquistāla'ni'. ");
INSERT INTO tooNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pedro talakspi'tli lā' laktzī'lh kalhatin sca'txtunu' ī'stālani'tēlha. U'tza' huā'mā' Jesús lej ixpāxquī'. Lā' nā huā'mā' ū'tza' a'ntī ixpāxtūhuī' Jesús a'xni'ca' ixtahuā'yamā'na lā' kalhasqui'nīlh: “Māpa'ksīni', lā' ¿tichū namacamāstā'yāni'?” ");
INSERT INTO tooNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lā' a'xni'ca' laktzī'lh Pedro kalhasqui'nīlh Jesús: ―Māpa'ksīni', lā' huā'mā' ¿tuchū napātle'keni'? ");
INSERT INTO tooNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Lā' Jesús kalhtīlh: ―Palh quit na'iclacasqui'n que xla' nalatahui'la hasta a'xni'ca' na'icmimpala, ¿chu mimaca'tzi hui'x? Hui'x caquistāla'ni' quit. ");
INSERT INTO tooNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Lā' ū'tza' ixtalīhuan huan tā'timīn que huanmā' sca'txtunu' tū' catinīlh. Jesús tū' hualh palh tū' catinīlh. A'ntū hualh xla' ū'tza': “Palh quit na'iclacasqui'n que xla' nalatahui'la hasta a'xni'ca' na'icmimpala, ¿chu mimaca'tzi hui'x?” ");
INSERT INTO tooNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Lā' huā'mā' sca'txtunu' ū'tza' quit. Icmālacstū'ncnī't lā' ictzo'knī't huā'mā' tachihuīn. Lā' icca'tzīyāuj que lej stu'ncua' a'ntū icuan. ");
INSERT INTO tooNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lā' a'nampala lej lhūhua' catūhuā a'ntū tlahualh Jesús. Lā' palh ixtzo'kui'līca cahuā ixlīhuāk a'ntū tlahualh xla', chō'la tūlalh ixlītahui'lakō'lh ixlīka'tla' quilhtamacuj ixlīlhūhua' libros a'nlhā ixtzo'kui'līca. Amén.");
INSERT INTO tooNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Icuaniyāni', Teófilo, que a'xni'ca' quit ictzo'kli pū'la huan lakatin libro, ictzo'kli ixlīhuāk a'ntū Jesús lītzuculh tlahua lā' māsu'yu. ");
INSERT INTO tooNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Lā' ictzo'kli a'ntūn tlahualh hasta a'xni'ca' a'lh nac a'kapūn. Lā' a'xni'ca' tūna'j ixa'n nac a'kapūn, Jesús cāmaxquī'lh lakatin līmāpa'ksīn ixapóstoles a'ntī ixcālacsacnī't. Cāmaxquī'lh por ixlīmāpa'ksīn Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A'xni'ca' Jesús lej ixpātīni'nī't, xla' lakahuan cātasu'yuni'lh ixapóstoles. Lā' xla' tlahualh lej lhūhua' catūhuā a'ntū māsu'yulh que lej stu'ncua' ixuanī't Jesús xalakahuan. Lā ixcātasu'yuni' hasta lhān chā'lh tu'pu'xam chi'chini'. Lā' ixcāhuani ixpālacata a'nchī māpa'ksīni'n Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lā' a'xni'ca' ixtatakēstoknī't xlaca'n lā' Jesús, xla' cāhuanilh: ―Tūna'j cataxtutit de nac Jerusalén. Caka'lhī'tit a'ntū nacāmaxquī'yāni' xaTāta'. Huā'mā' quit iccālīkalhachihuīna'ni'nī'ta'ni'tza'. ");
INSERT INTO tooNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ixlīstu'ncua', Juan ixlīmā'kpaxīni'n xcān. Pero xtunc a'nchī na'a'kpaxā'tit. Hui'xina'n nacātamaxquī'yāni' Espíritu Santo. Lā' palaj nacātamaxquī'yāni' ―cāhuanilh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lā' a'ntī ixtatakēstoknī't takalhasqui'nīlh: ―Māpa'ksīni', lā' ¿chā chuhua'j nahui'lī'ya' ixlīmāpa'ksīni' kalhatin israelita? ");
INSERT INTO tooNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Lā' Jesús cāhuanilh: ―Hui'xina'n tūla catica'tzītit huanmā' chi'chini' a'xni'ca' nala huā'mā'. Xmān Dios ca'tzī a'xni'ca' namacamin huā'mā' a'ntū nala. U'tza' māpa'ksī. ");
INSERT INTO tooNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Hui'xina'n namaklhtīni'nā'tit līmāpa'ksīn a'xni'ca' huan Espíritu Santo nacālakmināni' porque naka'lhī'yā'tit Espíritu Santo. Hui'xina'n nachihuīna'nā'tit de quimpālacata nac Jerusalén lā' na ixlīhuāk estado de Judea lā' nac Samaria lā' na ixlīhuāk quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lā' a'xni'ca' Jesús huankō'lh lā' xla' chu tuncan tzuculh tā'kayāhua na ixlacapūnca'n. Lā' tanūlh nac lakatin poklhnu' a'ntū cāmātzē'kni'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Lā' xlaca'n ixtatalacayāhuayāna' a'xni'ca' Jesús ixa'mā' tālhmā'n. Lā' chu līmaktin tatāyachi kalhatu' chi'xcuhuī'n ixpajtzuca'n. Ixtaka'lhī ixlu'xu'ca'n laksmu'yonko. ");
INSERT INTO tooNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Lā' xlaca'n tahualh: ―Chi'xcuhuī'n xalanī'n nac Galilea, ¿a'chī' talacayāhuayāna'ntit? U'tza' huā'mā' Jesús, a'ntīn tā'kayāhuanī't nac a'kapūn na milacapūnca'n, ū'tza' nataspi'tpala. Chu a'nchī a'lh, namimpala hua'chi a'xni'ca' tā'kayāhualh na milacapūnca'n ―cāhuanica. ");
INSERT INTO tooNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Lā' huan apóstoles tataxtulh de nac kēstīn a'nlhā ixuī' pū'olivo. Lā' huan kēstīn ixpajtzu Jerusalén ixlīmakat chu a'cxtim hua'chi tzē natlā'huancan lakatin chi'chini' a'ntū pūjaxcan chu a'nchī tatzo'kni' nac ley. Lā' xlaca'n ta'a'nchokopā nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lā' a'xni'ca' tachilh xlaca'n tatō'ca'lh hasta nac cuarto tālhmā'n a'nlhā ixtahui'lāna'ncha' Pedro lā' Jacobo lā' Juan lā' Andrés lā' Felipe lā' Tomás lā' Bartolomé lā' Mateo lā' Jacobo ixo'kxa' Alfeo lā' Simón Zelote lā' Judas ixtā'tin Jacobo. ");
INSERT INTO tooNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Lā' ixlīhuākca'n a'cxtim talīhui'līlh ta'orarlī lā' tasqui'ni' Dios. Lā' nā ta'orarlīlh nā puscan lā' María a'ntī ixtzī't Jesús lā' nā ixtā'timīn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Lā' a'ntī ixtatakēstoknī't xlaca'n hua'chi lakatin ciento ā'kalhapu'xam. Lā' huanmā'na chi'chini' Pedro tāyalh ixlaclhpu'nanca'n huan tā'timīn lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Tā'timīn, chuntza' tasqui'nī que pātle'kelh a'ntū huan ixtachihuīn Dios a'nlhā David hualh pū'la por ixlīmāpa'ksīn Espíritu Santo, ixpālacata Judas. U'tza' huā'mā' Judas a'ntī cāpū'lani'lh xlaca'n a'ntī tachi'palh Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","U'tza' Judas a'ntī ixquincātā'latlā'huanāni'. Lā' nā ū'tza' ixtā'scuja Dios hua'chi quina'n tā'scujāuj Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Huā'mā' chi'xcu' tamāhualh ti'ya't. Lā' līmāpalalh huan tumīn a'ntū tlajalh por ixpālacata a'ntūn tlahualh a'ntūn tū' tzey. Lā' tatonkopūlh lā' tapālhkālh lā' taxtukō'lh ixpālūhua'. ");
INSERT INTO tooNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Lā' ixlīhuākca'n xalanī'n nac Jerusalén ixtaca'tzī huā'mā'. U'tza' līmāpācuhuīca ixtacuīni' huan ti'ya't Acéldama. Chuntza' ixtachihuīnca'n a'ntū huanicu'tun Pasakō'nī't Ka'lhni' huan Ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Chuntza' tatzo'kni' nac libro ixtacuīni' Salmos: Calakmaka'nca ixchic. Lā' a'ntza' nīn tintī' catitahui'lalh. Lā' nā tatzo'kni' chuntza': Lā' catanūpā ā'chā'tin na ixlītlōt. ");
INSERT INTO tooNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Lā' Pedro huampā: ―Catanūlh ixlaktapalh Judas kalhatin a'ntī ixquincātā'latlā'huanāni' ixlīhuāk quilhtamacuj a'xni'ca' Jesús taxtulh lā' tanūlh na quilaclhpu'nanca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Calalh kalhatin a'ntī ixquincātā'latlā'huanāni' desde a'xni'ca' Juan mā'kpaxīni'lh hasta huanmā' chi'chini' a'xni'ca' Jesús tā'kayāhualh tālhmā'n na quilacapūnca'n. U'tza' nala hua'chi quina'n lā' namāstū'nca a'nchī Jesús lakahuanchokolh ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Lā' cālacsacca kalhatu' chi'xcuhuī'n. Lā' de huā' kalhatu' ixtacuīni' chā'tin José a'ntī ixka'lhī ixtacuīni' ixlītāpātu' Barsabás lā' ixlītāpātu'tun Justo. Lā' ā'chā'tin huampala ixtacuīni' Matías. ");
INSERT INTO tooNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lā ta'orarlīlh lā' tahualh: ―QuinDiosca'n, hui'x cālakapasni'ya' ixa'clhcunucca'n ixlīhuākca'n chi'xcuhuī'n. Caquilāmāsu'ni'uj tichū de huā' tamā'na kalhatu' chi'xcuhuī'n lacsacnī'ta' hui'x. ");
INSERT INTO tooNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Lā' ū'tza' natā'scujāni' lā' apóstol nala. Lā' nala ixlaktapalh Judas a'ntī makxtekli de tā'scujāni' por ixpālacata a'ntūn tlahualh a'ntūn tū' tzey, lā' ū'tza' lī'a'lh nac pūpātīn. ");
INSERT INTO tooNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lā' tzo'kca ixtacuīni' José nac kalhtin ca'psnat. Lā' ixtacuīni' Matías tzo'kpalaca nac kalhtin ca'psnat huampala. Mojōca kalhtu' ca'psnat. Lā' a'xni'ca' mācutuca xmān kalhtin ca'psnat lā' ixka'lhī ixtacuīni' Matías. Lā' chuntza' tanūlh Matías ixlītlōt. Lā' a'cchā'lh ixlīkalhacāujtu' apóstoles. ");
INSERT INTO tooNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lā' a'xni'ca' chilh huan chi'chini' a'ntū huanican Pentecostés, ixlīhuākca'n ixtatakēstokkō'nī't. ");
INSERT INTO tooNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Chu līmaktin macasa'nalh de nac a'kapūn hua'chi lakatin palha' ū'ni' a'ntū kaxmatca huāk huan nac chic a'nlhā ixtahui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lā' cātasu'yuni'lh hua'chi si'makāt a'ntū tasu'yulh hua'chi lamana'. Lā' tahuī'lh na ixa'cpunca'n chā'tunu' de xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Lā' ixa'clhcunucca'n talītatzumakō'lh Espíritu Santo. Lā' tatzuculh tachihuīna'n xtuncnu' tachihuīn a'ntū cāmaxquī'lh Espíritu Santo natachihuīna'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Lā' ixtahui'lāna' nac Jerusalén israelitas, chi'xcuhuī'n a'ntī ixta'a'cnīni'ni' Dios. Xlaca'n xalanī'n lakachu nac cā'quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Lā' a'xni'ca' takaxmatli a'ntū macasa'nalh, tatakēstokkō'lh ixlīlhūhua'ca'n. Lā' nīn ixtalīca'tzīhui'lāna' a'nchī ixtakaxmatli ixtachihuīnca'n chā'tunu' xalanī'n lakatunu' cā'lacchicni'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lā' tatamakchuyīlh lā' cālē'cnīca lā' talāhuanilh: ―¿Chu tū' xalanī'n nac Galilea huā' tamā'na chi'xcuhuī'n a'ntīn tachihuīna'mā'na? ");
INSERT INTO tooNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Lā' ¿chī līkaxmatāuj quilīhuākca'n huan tachihuīn a'ntū chihuīna'nāuj desde quilīlacti'na'jca'n? ");
INSERT INTO tooNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Makapitzīn de quina'n xalanī'n nac Partia lā' Media lā' Elam lā' Mesopotamia lā' Judea lā' Capadocia lā' Ponto lā' Asia. ");
INSERT INTO tooNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","A'makapitzīn quina'n xalanī'n nac Frigia lā' Panfilia lā' Egipto lā' ixpajtzu Cirene a'ntū lakatin cā'lacchicni' nac Africa. Lā' ā'makapitzīn xalanī'n nac Roma a'ntīn taminī'ta'ncha'. Xlaca'n israelitas lā' nā a'ntī ixtatanūnī't na ixreligionca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Lā' ā'makapitzīn quina'n xalanī'n nac Creta lā' Arabia. Lā' quina'n cākaxmatni'yāuj huanmā'na chi'xcuhuī'n, xalanī'n nac Galilea, a'nchī tachihuīna'mā'na a'ntūn quintachihuīnca'n. Lā' quincātalīchihuīna'mā'ni' catūhuā lej ka'tla' a'ntū tlahualh Dios ―talāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Lā' ixlīhuākca'n talē'cnīkō'lh lā' tū' taca'tzīlh tuchū. Lā' talāhuanipā: ―¿Tuchū huanicu'tun huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Lā' makapitzīn talakapalalh lā' tahualh: ―Huā' tamā'na chi'xcuhuī'n taka'chī. ");
INSERT INTO tooNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lā' Pedro tāyalh ixlīkalhacāujtu' apóstoles lā' cāhuanilh palha': ―Iccāhuaniyāni' chi'xcuhuī'n israelitas lā' milīhuākca'n hui'xina'n a'ntī hui'lā'na'ntit nac Jerusalén. Caca'tzītit huā'mā' lā' cakaxpa'ttit quintachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Huā' tamā'na chi'xcuhuī'n tū' taka'chī hua'chi puhua'nā'tit hui'xina'n. Tū' taka'chī porque xmān maknajās cūhuīni'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Huā'mā', a'ntū hui'xina'n laktzī'mpā'na'ntit lā' kaxpa'tpā'na'ntit, ū'tza' a'ntū hualh Joel a'ntī ixa'cta'sana' Dios xala' makāntza'. Joel hualh: ");
INSERT INTO tooNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios hualh chuntza': A'xni'ca' nasputatza' quilhtamacuj na'iccāmacamini' quiEspíritu ixlīhuākca'n tachi'xcuhuī't. Lā' mi'o'kxa'nca'n lā' mintzu'ma'janca'n natahuan quintachihuīn. Lā' mi'o'kxa'nca'n natalakachuya lā' mimpapatzīnca'n natalakahuāna'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Lā' lej ixlīstu'ncua' na'iccāmacamini' xlaca'n quiEspíritu huanmā'na chi'chini' a'ntī quintatā'scuja a'ntīn chi'xcuhuī'n lā' a'ntīn puscan. Lā' xlaca'n natahuan quintachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Lā' na'icmāsu'yu lē'cnīn tālhmā'n nac a'kapūn lā' laka'tla'n catūhuā nac ti'ya't. Lā' natatasu'yu ka'lhni' lā' lamana' lā' mixini' a'ntū hua'chi jini'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Lā' huan chi'chini' tū' naxkaka lā' huan mālhcuyu' natasu'yu hua'chi ka'lhni'. Lā' ā'calīstān namin ixlaclhchi'chini' Māpa'ksīni' Jesucristo a'xni'ca' namimpala. Nala lakatin chi'chini' lej xaka'tla'. Lā' nalaktzī'ncan a'ntū napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lā' nala chuntza': Chuxatī a'ntī nata'sani' Māpa'ksīni' para namaktāya, ū'tza' napūtaxtu. Chuntza' Joel tzo'knulh a'nchī hualh Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Lā' Pedro huampā: ―Chi'xcuhuī'n israelitas, cakaxpa'ttit huā'mā' tachihuīn. Dios cāmāsu'ni'ni' hui'xina'n que ū'tza' māni' macamilh Jesús xala' nac Nazaret. Lā' cāmāsu'ni'ni' huā'mā' por ixpālacata lē'cnīn a'ntūn tlahualh Jesús por ixlīmāpa'ksīn Dios na milacapūnca'n. Huā'mā' hui'xina'n ca'tzīyā'tit. ");
INSERT INTO tooNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Lā' a'xni'ca' macamāstā'ca Jesús, lā' hui'xina'n hua'ntit que caxtokohua'ca'ca lā' māmaknī'nī'ni'ntit. Lā' a'ntīn tamaknīlh Jesús, xlaca'n tū' tzeyā chi'xcuhuī'n. Huā'mā' pātle'kelh chuntza' hua'chi ixtapuhuān Dios a'ntū tūla taxtāpalī lā' chuntza' hua'chi ixca'tzī Dios makāntza'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Dios mālakahuanīchokolh Jesús lā' māxtulh de ixlīmāpa'ksīn huan līnīn porque Jesús tūlalh tachokolh xanīn. ");
INSERT INTO tooNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David līchihuīna'lh Jesús lā' hualh: Pō'ktu xa'iclaktzī'n Māpa'ksīni' na quilacapūn. Lā' huī' na quimpāxtūcāna'j. Lā' chuntza' tū' ictitamakchuyīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","U'tza' līpāxuhualh qui'a'clhcunuc lā' icchihuīna'lh catūhuā a'ntū līpāxūj porque tū' catimakxtekca quimacni'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Hui'x tū' namakxteka' quilīca'tzīn nac cā'līnīn, lā' tū' namakxteka' namasa quimacni'. Quit mi'O'kxa' a'ntī lej tzey. ");
INSERT INTO tooNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Quimāca'tzīnī'nī'ta' a'nchī na'iclatā'kchoko. Na'icka'lhī tapāxuhuān na milacapūn. Lā' chuntza' David tzo'knulh a'nchī nalakahuanchoko Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Lā' Pedro huampā: ―Chi'xcuhuī'n, israelitas hua'chi quit, na'iccāhuaniyāni' a'ntū stu'ncua' ixpālacata huan quimpapca'n David a'ntī ixmāpa'ksīni'ca'n israelitas ixuanī't. Xla' nīlh lā' mā'cnūca. Lā' huī'cus a'nlhā mā'cnūca. ");
INSERT INTO tooNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Xla' ixa'cta'sana' Dios ixuanī't. Lā' ixca'tzī a'nchī Dios ixuanī't que ixlīstu'ncua' nahui'lī ixlīrey a'ntī ī'xū'yātā'nat David. ");
INSERT INTO tooNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ixca'tzī que Cristo nalakahuanchoko lā' tū' natachoko nac cā'līnīn lā' tū' namasa ixmacni' Cristo. Lā' ū'tza' chuntza' lītzo'knulh David. ");
INSERT INTO tooNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios mālakahuanīchokonī't huā'mā' Jesús. Lā' quilīhuākca'n iclaktzī'nī'ta'uj huā'mā'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Dios līmā'ca'lh Jesús lā' hui'līlh na ixpāxtūcāna'j. XaTāta' Dios maxquī'lh Jesús huan Espíritu Santo chuntza' hua'chi hualh pū'la. Lā' nā Jesús macaminī't Espíritu Santo huā'tzā'. Huā'mā' ū'tza' a'ntū hui'xina'n laktzī'nā'tit lā' kaxpa'tā'tit chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David tū' a'lh nac a'kapūn. Pero ū'tza' māni' hualh: Huan Māpa'ksīni' Dios huanilh quiMāpa'ksīni': “Catahui'la' na quimpāxtūcāna'j ");
INSERT INTO tooNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta que a'xni'ca' quit na'iccātlaja mintā'ca'tzanī'n”. Chuntza' tzo'knulh David. ");
INSERT INTO tooNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Lā' Pedro huampā: ―Cataca'tzīkō'lh xa'nca ixlīhuākca'n xalanī'n nac Israel que Dios hui'līlh Jesús ixlīMāpa'ksīni' lā' ixlīCristo. U'tza' huā'mā' Jesús a'ntī hui'xina'n xtokohua'ca'tit ―cāhuanilh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lā' a'xni'ca' takaxmatli huā'mā', ta'u'cxca'tzīlh a'nchī lej ko'hua'jua' lalh ixa'clhcunucca'n. Lā' cāhuanica Pedro lā' ā'makapitzīn apóstoles: ―Chi'xcuhuī'n, ¿tuchū na'ictlahuayāuj? ");
INSERT INTO tooNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Lā' Pedro cāhuanilh: ―Caxtāpalī'tit mintapāstacna'ca'n lā' ca'a'kpaxtit milīhuākca'n hui'xina'n lā' chuntza' namāsu'yu'yā'tit que tapa'ksīyā'tit con Jesucristo. Lā' chuntza' nacātamāsputūnu'ni'yāni' mintalaclē'i'ca'n lā' nacātamaxquī'yāni' huan lē'ksajna' a'ntū Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","U'tza' a'ntū Dios huanī't namāstā'. Lā' huā'mā' tzē namaklhtīni'nā'tit hui'xina'n. Lā' nā tzē natamaklhtīni'n nā mincamana'ca'n lā' nā ixlīhuākca'n huan tachi'xcuhuī't xalanī'n ā'lakatunu' xcānsipejni' lā' ixlīhuāk a'ntīn cāta'sani' huan Māpa'ksīni' quinDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Lā' Pedro lej cāhuanilh lā' cāmaxquī'lh tapāstacna' lā' hualh: ―Capūtaxtutit lā' chuntza' tū' napāstacna'nā'tit hua'chi huā'mā' tachi'xcuhuī't tū' tzey a'ntīn tahui'lāna' chuhua'j ―cāhuanilh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lā' a'ntīn takalhlaka'ī'lh ixtachihuīn Pedro, xlaca'n ta'a'kpaxli. Lā' a'ntīn takalhlaka'ī'lhcus huā'mā' chi'chini' lakatu'tun mil tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lā' xlaca'n tū' ixtamakxteka ixlīmāsca'tīnca'n apóstoles. Lā' tū' ixtamakxteka tatakēstoka lā' tamālacpitzi pāntzi lā' ta'orarlī. Lā' ixtaka'lhī chu lakatin ixtapuhuānca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Lā' ixlīhuākca'n ixtajicua'n. Lā' huan apóstoles tatlahualh lej lhūhua' laka'tla'n catūhuā a'ntū māsu'yulh ixlīmāpa'ksīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Lā' ixlīhuāk a'ntī ixta'a'ka'ī', ixtahui'lāna' kēxtim lā' chu lakatin ixtamākēxtimīnī't huāk a'ntū ixtaka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Lā' tastā'lh ixti'ya'tca'n lā' a'ntū ixtaka'lhī lā' ixtalāmālacpitzini'lh ixlīhuākca'n como hua'chi chā'tunu' ixtamaclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lā' lakalīyān ixtatakēstoka nac xaka'tla' lītokpān. Lā' ixtamālacpitzi pāntzi na ixchicca'n lā' ixtahuā'yan con tapāxuhuān. Lā' ixa'clhcunucca'n huāk lactza'ta'ta'. ");
INSERT INTO tooNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Lā' ixtalīchihuīna'n a'nchī ixlēka'tla' Dios. Lā' ixcālaktzī'ncan como lej tzeyā chi'xcuhuī'n. Lā' Māpa'ksīni' Dios ixmālhūhuī'pala lakalīyān. Lā' lakalīyān lhūhua'ntēlhalh a'ntī ixtapūtaxtu. ");
INSERT INTO tooNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro lā' Juan ixtatanū kēxtim na ixlītokpānca'n israelitas. Lā' ixchā'n huan hora a'ntū ixtapū'orarlī, hua'chi maktu'tun kōtanū. ");
INSERT INTO tooNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lakalīyān ixuī' a'ntza' kalhatin chi'xcu' a'ntī ixlū'ntū'lanī't desde a'xni'ca' lacatuncuīlh. Lā' ixui'līcan lakalīyān na ixlacapūn xamākalhcha lītokpān. Lā' huan mākalhcha ixtacuīni' Tzēhuanī't. Lā' a'ntza' ī'squi'nīhuā'yan lā' ixcāsqui'ni' a'ntī ixtatanū nac lītokpān. ");
INSERT INTO tooNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lā' xla' cālaktzī'lh Pedro lā' Juan a'xni'ca' ixtatanūmā'na nac lītokpān lā' xla' cāsqui'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Lā' Pedro lā' Juan talakalaktzī'hui'līlh lā' Pedro huanilh: ―Caquilālaktzī'uj quina'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Lā' xla' cālakalaktzī'lh lā' ixpuhuan que namaxquī'can catūhuā. ");
INSERT INTO tooNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Lā' Pedro hualh: ―Tū' icka'lhī plata nīn oro. Pero na'icmaxquī'yāni' a'ntū icka'lhī. Por ixlīmāpa'ksīn Jesucristo xala' nac Nazaret, catāya' lā' catlā'hua'. ");
INSERT INTO tooNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Lā' makachi'palh ixpekecāna'j lā' yāhualh. Lā' huanmā' ka'tlā'tus chu līlacapalh ixtojon lā' ixtūpixni' lactli'hui'quilh. ");
INSERT INTO tooNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Lā' lacapalh tāyalh lā' tlā'hualh lā' cātā'tanūlh Pedro lā' Juan nac lītokpān. Lā' ixtlā'huantēlha tanūlh lā' ixtā'kapūyāhua lā' ixuan a'nchī Dios lej ka'tla'. ");
INSERT INTO tooNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Lā' ixlīhuāk tachi'xcuhuī't talaktzī'lh a'nchī ixlatlā'huan lā' xlaca'n tamāka'tlī'lh Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Lā' talakapasli ū'tza' a'ntī ī'squi'nīhuā'yamā' na ixlacapūn ixlītokpānca'n israelitas, a'nlhā huanican huan mākalhcha Tzēhuanī't. Lā' talē'cnīlh a'ntū ixpātle'keni'nī't huan chi'xcu'. Lā' tū' ixtalīca'tzīhui'lāna'. ");
INSERT INTO tooNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lā' huan chi'xcu' a'ntī ixlū'ntū'lanī't lā' a'ntī ixtzeyanī'tcus, ixcātā'lāmakachi'patlā'huan Pedro lā' Juan. Lā' ixlīhuāk tachi'xcuhuī't tatu'jnuntēlhalh lā' cālaktakēstokca nac corredor a'nlhā huanican ixtacuīni' ixcorredor Salomón. Lā' lej talē'cnīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lā' Pedro, a'xni'ca' laktzī'lh huā'mā', cāhuanilh tachi'xcuhuī't: ―Chi'xcuhuī'n israelitas, ¿a'chī' a'cnī'yā'tit huā'mā'? Lā' ¿a'chī' quilālakalaktzī'nāuj? Tū' quilīmāpa'ksīnca'n a'ntū iclīmātzeyīnī'ta'uj lā' tū' por quimpālacataca'n porque quina'n tzeyā chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tlahualh huā'mā' ixDiosca'n Abraham lā' Isaac lā' Jacob lā' quinatāta'na'ca'n. U'tza' Dios māsu'yunī't que lej ka'lhī līmāpa'ksīn Jesús a'ntī ixO'kxa' Dios. Lā' huā'mā' Jesús ū'tza' a'ntī macamāstā'tit hui'xina'n lā' kalhtatzē'ktit na ixlacapūn Pilato a'xni'ca' xla' ixlīhui'līnī't namakxteka. ");
INSERT INTO tooNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Lā' hui'xina'n kalhtatzē'ktit a'ntī lej tzey lā' tlahuanī't xmān a'ntū lej tzey. Lā' hui'xina'n squi'ntit cacātamāxtuni'ni' lā' camakxtekca kalhatin maknīni'. ");
INSERT INTO tooNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Lā' māmaknīnīni'ntit Jesús a'ntī māstā' vida lā' a'ntīn Dios mālakahuanīchokolh. Lā' quina'n icmāstū'ncāuj a'nchī lakahuanchokolh. ");
INSERT INTO tooNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ickalhlaka'ī'yāuj Jesucristo. U'tza' līmātzeyīca huā'mā' chi'xcu' a'ntī hui'xina'n laktzī'nā'tit lā' lakapasā'tit. Jesús quincāmaxquī'ni' ixtapuhuān. U'tza' līmātzeyīca xa'nca na milacapūnca'n milīhuākca'n hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Lā' chuhua'j chi'xcuhuī'n, quit icca'tzī que hui'xina'n tū' ixmāchekxī'yā'tit a'ntūn tlahua'tit a'xni'ca' māmaknīnīni'ntit Jesús. Lā' nā tū' ixtamāchekxī mimpūchihuīna'nī'nca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dios māca'tzīnīni'lh xapū'la que Cristo napātīni'n. Chuntza' tahualh ixa'cta'sana'nī'n Dios xalanī'n makān. Huā'mā' tlōkentaxtūlh Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lā' chuhua'j hui'xina'n caxtāpalī'tit mintapāstacna'ca'n lā' caxtāpalī'tit mi'a'clhcunucca'n lā' chuntza' naxapacan mintalaclē'i'ca'n. Lā' chuntza' namin huan chi'chini' a'xni'ca' Dios nacāmāske'hui'huī'ni'yāni' mi'a'clhcunucca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Lā' namacamin Jesucristo a'ntī xapū'la līhui'līlh Dios nacāmacamini'yāni' hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero Jesucristo ka'lhī natachoko nac a'kapūn hasta a'xni'ca' Dios nalacāxtlahuapalakō' ixlīhuāk a'nchī Dios makāntza' cāmāchihuīnīlh ixa'cta'sana'nī'n a'ntī lacuan. ");
INSERT INTO tooNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés cāhuanilh quinapapna'ca'n: Huan Māpa'ksīni' quinDiosca'n nacāmacamini'yāni' hui'xina'n kalhatin a'cta'sana', chuntza' hua'chi quimacamilh quit. Lā' ū'tza' nala kalhatin de hui'xina'n. Lā' hui'xina'n nakaxpa'tā'tit ixlīhuāk a'ntū xla' nacāhuaniyāni'. ");
INSERT INTO tooNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Lā' a'ntīn tū' natakalhlaka'ī a'ntū nahuan huanmā' chi'xcu', ū'tunu'n nacāmāsputūcan lā' nacātamacaxtucan de ixlaclhni' tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Lā' chuntza' tahualh ixlīhuākca'n ixa'cta'sana'nī'n Dios xalanī'n makān lā' Samuel lā' nā a'ntīn tamilh ā'calīstān. Xlaca'n tahualh que chuntza' napātle'ke. ");
INSERT INTO tooNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Hui'xina'n ixcamana'ca'n ixa'cta'sana'nī'n Dios. Lā' nā mila'ca'n huan convenio a'ntū talacāxtlahualh quinDiosca'n lā' quinapapna'ca'n. Tlahuaca huan convenio a'xni'ca' Dios huanilh Abraham: Por ixpālacata minatā'natna' nacāsicua'lanālīcan ixlīhuāk tachi'xcuhuī't xala' nac quilhtamacuj. ");
INSERT INTO tooNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","A'xni'ca' Dios macamilh ixO'kxa', cālakmacamini' hui'xina'n pū'la para que milīhuākca'n camakxtektit mintalaclē'i'ca'n lā' chuntza' nacātasicua'lanālīyāni' ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Lā' a'xni'ca' Pedro lā' Juan ixtatā'chihuīna'mā'na tachi'xcuhuī't, talakmilh curasna' lā' ixcapitán tropasna' xalanī'n nac lītokpān lā' nā saduceosnu'. ");
INSERT INTO tooNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Xlaca'n tatamakchuyīlh por ixpālacata a'ntū ixcāmāsu'ni'can tachi'xcuhuī't lā' a'nchī ixtamāca'tzīnīni'n que Jesús lakahuanchokolh, lā' chuntza' nalīlakahuanchokocan. ");
INSERT INTO tooNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lā' cāchi'paca Pedro lā' Juan lā' cāmānūca nac pūlāchī'n. Lā' como kōtanūtza' ixuanī't, cāmakxtekca a'ntza' hasta ixlīlakalī. ");
INSERT INTO tooNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Lā' ta'a'ka'ī'lh lej lhūhua' a'ntīn takaxmatli huan tachihuīn. Lā' ixlīlhūhua' hua'chi lakaquitzis mil chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lā' ixlīlakalī tatakēstokli nac Jerusalén huan pūchihuīna'nī'n lā' xanapuxcu'nu' israelitas lā' mākalhtō'kē'ni'nī'n huan ley. ");
INSERT INTO tooNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Lā' tamilh Anás, a'ntī xamāpa'ksīni' curasna', lā' Caifás lā' Juan lā' Alejandro lā' ixlīhuāk ixtalakapasnī'n huan xamāpa'ksīni' curasna'. ");
INSERT INTO tooNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Lā' a'xni'ca' ixcāhui'līcanī'ttza' Pedro lā' Juan na ixlacapūnca'n, cākalhasqui'nīca: ―¿Tichū ixlīmāpa'ksīn a'ntū lītlahua'tit huā'mā'? Lā' ¿tichū ixquilhtampān tlahua'tit huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Lā' ixa'clhcunuc Pedro ixlītzuma' Espíritu Santo lā' cāhuanilh: ―Chi'xcuhuī'n, pūchihuīna'nī'n lā' xanapuxcu'nu' israelitas: ");
INSERT INTO tooNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chuhua'j quina'n quilāmālacapū'nī'ta'uj por ixpālacata lakatin a'ntūn tzey ictlahuani'uj huā'mā' chi'xcu' ī'tza'ca' lā' por ixpālacata a'nchī mātzeyīcanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Caca'tzītit milīhuākca'n hui'xina'n lā' cataca'tzīlh ixlīhuāk tachi'xcuhuī't israelitas huā'mā' a'ntū lalh. Huā'mā' chi'xcu' a'ntī yā na milacapūnca'n hui'xina'n, ū'tza' līmātzeyīlh por ixlīmāpa'ksīn Jesucristo xala' nac Nazaret. U'tza' Jesucristo a'ntī hui'xina'n māxtokohua'ca'nīni'ntit lā' Dios mālakahuanīchokolh. ");
INSERT INTO tooNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Huā'mā' Jesucristo ū'tza' a'ntī lakmaka'ntit hui'xina'n hua'chi tapācna'nī'n talakmaka'n lakatin chihuix. Lā' chuhua'j huā'mā' Jesucristo hua'chi chihuix a'ntū pū'la hui'līca ixa'katzā'stūn. ");
INSERT INTO tooNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Lā' Jesucristo xmān ū'tza' māpūtaxtunu'. Lā' tū' a'nampala ā'kalhatin chi'xcu' nac cā'quilhtamacuj a'ntī tzēn quincāmāpūtaxtūyāni' ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Lā' a'xni'ca' talaktzī'lh huan pūchihuīna'nī'n a'nchī Pedro lā' Juan tū' ixtajicua'n, xlaca'n talē'cnīlh porque ixtaca'tzī que Pedro lā' Juan xlaca'n catīhuāyā chi'xcuhuī'n lā' tuntū' lej ixtaca'tzī. Lā' ū'tza' talīmāchekxīlh que xlaca'n ixtatā'latlā'huan Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Lā' talaktzī'lh huan chi'xcu' a'ntī mātzeyīca lā' ixyā ixlacapūnca'n. Lā' tūlalh tahualh que tū' tzey a'ntūn tatlahualh Pedro lā' Juan. ");
INSERT INTO tooNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lā' cāmaxquī'ca līmāpa'ksīn catataxtulh macsti'na'j Pedro lā' Juan a'nlhā ixtatakēstoknī't a'ntī ixtatlahua justicia. Lā' takalhachihuīna'lh xlaca'n ");
INSERT INTO tooNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","lā' talāhuanilh: ―¿Tuchū nacātlahuani'yāuj huā' tamā'na chi'xcuhuī'n? Por ixpālacataca'n ū'tunu'n, pātle'kenī't lakatin ka'tla' lē'cnīn. Huā'mā' taca'tzī ixlīhuākca'n a'ntīn tahui'lāna' nac Jerusalén. Lā' tūlalh catikalhtatzē'kui. ");
INSERT INTO tooNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Lā' cacāmākē'klhauj lā' cacāhuaniuj que tū'tza' catahuanilh huan ixtacuīni' Jesús nīn ā'chā'tin. Lā' chuntza' tū'tza' catitalhūhua'lh huan a'ntīn takalhlaka'ī' huan ixtachihuīnca'n ―talāhuanilh. ");
INSERT INTO tooNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Lā' cāmātayīni'nca Pedro lā' Juan lā' cāmāpa'ksīca que tū'tza' catachihuīna'lh lā' tū'tza' catamāsu'yulh nīn ā'maktin por ixlīmāpa'ksīn Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Lā' Pedro lā' Juan takalhtīni'lh lā' tahualh: ―¿Chu tzey na ixlacapūn Dios na'iccā'a'kahuāna'ni'yāni' hui'xina'n lā' tū' na'ica'kahuāna'ni'yāuj Dios? ¿Chichū puhua'nā'tit? Lā' caquilāhuaniuj. ");
INSERT INTO tooNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Quina'n tūla ictimakxtekui de na'icuanāuj a'ntū iclaktzī'nī'ta'uj lā' a'ntū ickaxmatnī'ta'uj ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Lā' a'xni'ca' ixcāmākē'klhacanī't huampala, cāmakxtekca. Tūla ixtakaksni' a'nchī natalīcastigarlī porque ixtajicua'ni' huan tachi'xcuhuī't porque, por ixpālacata a'ntū ixpātle'kenī't, ixlīhuākca'n ixtachihuīna'n a'nchī lej ka'tla' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Lā' huan chi'xcu' a'ntī tlahuani'canī't huan lē'cnīn ixka'lhītza' más de tu'pu'xam cā'ta. ");
INSERT INTO tooNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lā' a'xni'ca' Pedro lā' Juan ixcāmakxtekcanī'ttza', talaka'lh ixcompañerosnu'ca'n. Lā' cāhuanica ixlīhuāk a'ntū ixtahuanī't huan xanapuxcu'nu' curasna' lā' huan xanapuxcu'nu' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lā' a'xni'ca' takaxmatli huā'mā', ixlīhuāk a'cxtim ta'orarlīlh lā' tahuanilh Dios lej palha': ―Māpa'ksīni', hui'x Dios lā' hui'x tla'hua' a'kapūn lā' ti'ya't lā' ixlīhuāk a'ntū a'nan. ");
INSERT INTO tooNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Lā' por ixlīmāpa'ksīn Espíritu Santo māchihuī'ni' David a'ntī ixtā'scujāni'. Lā' David hualh chuntza': ¿A'chī' lej tata'sa con tā'kcha tachi'xcuhuī't a'ntīn tū' israelitas? ¿A'chī' tapāstaca huan tachi'xcuhuī't a'ntūn tū' tasqui'nī? ");
INSERT INTO tooNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Lā' huan reyni' xala' nac huā' quilhtamacuj talalh ixtā'ca'tza Dios. Lā' huan pūchihuīna'nī'n tatakēstokli, lā' talītalakspi'tli huan Māpa'ksīni' Dios lā' nā Cristo a'ntī Dios lacsacui'līnī't. ");
INSERT INTO tooNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’U'tza' lej stu'ncua'. Nac huā'mā' xcānsipej tatakēstokli Herodes lā' Poncio Pilato lā' huan israelitas lā' a'ntīn tū' israelitas. Lā' talītalakspi'tli Jesús mi'O'kxa' lacuan a'ntī lacsacui'līnī'ta' hui'x, quinDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Xlaca'n tatakēstokli natatlahua xmān a'ntū hui'x līhui'li' xapū'la a'ntū nala lā' xmān a'ntū milīmāpa'ksīn lā' mintapuhuān. ");
INSERT INTO tooNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Lā' chuhua'j, Māpa'ksīni' Dios, chu tū' la'ktzi' a'nchī quincātamakē'klhacu'tunāni'. Lā' caquilāmaktāyauj quina'n a'ntī iccātā'scujāni'. Chuntza' na'icchihuīna'nāuj mintachihuīn lā' tū' ca'icjicua'nui. ");
INSERT INTO tooNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lā' camāsu'yu' milīmāpa'ksīn lā' cacāmātzeyi' lā' calalh laka'tla'n catūhuā lā' lē'cnīn por ixlīmāpa'ksīn Jesús mi'O'kxa' lacuan. ");
INSERT INTO tooNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lā' a'xni'ca' ixta'orarlīnī'ttza', tachiquilh a'nlhā ixtatakēstoknī't. Lā' ixa'clhcunucca'n ixlīhuākca'n talītatzumalh Espíritu Santo. Lā' tachihuīna'lh ixtachihuīn Dios lā' tū' ixtajicua'n. ");
INSERT INTO tooNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Lā' ixlīlhūhua' a'ntī ixtakalhlaka'ī'nī't lā' chu lakatin tapāstacna' lā' ixtaka'lhī chu lakatin tapuhuān. Lā' nīn tintī' puhuanli que tūla namāstā' a'ntū ixka'lhī. Lā' chu lakatin ixtamākēxtimīnī't ixlīhuāk a'ntū ixtaka'lhī. ");
INSERT INTO tooNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Lā' huan apóstoles ixtaka'lhī lhūhua' līmāpa'ksīn. Lā' ixtamālacstū'nca que Māpa'ksīni' Jesús ixlakahuanchokonī't. Lā' Dios ixcāsicua'lanālī. ");
INSERT INTO tooNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Lā' nīn tintī' ī'sputni' catūhuā porque ixlīhuākca'n a'ntī ixtaka'lhī ixti'ya'tca'n lā' ixchicca'n, ixtastā' lā' ixtalīmin ixtapalh a'ntū ixtastā'. ");
INSERT INTO tooNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Lā' ixtamaxquī' huan apóstoles. Lā' tamālacpitzilh chā'tunu' chu a'nchī ixtamaclacasqui'n. ");
INSERT INTO tooNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Lā' ixuī' kalhatin chi'xcu' ixtacuīni' José. Lā' huan apóstoles tamāpācuhuīlh por ixlītāpātu' ixtacuīni' Bernabé (huā'mā' huanicu'tun māko'xamixīni'). Lā' ū'tza' levita ixuanī't xala' nac Chipre. ");
INSERT INTO tooNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Lā' xla' ixka'lhī ixti'ya't. Lā' stā'lh lā' cālīmini'lh ixtapalh lā' cāmaxquī'lh huan apóstoles. ");
INSERT INTO tooNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Lā' nā ixuī' kalhatin chi'xcu' ixtacuīni' Ananías. Lā' ixka'lhī ixpuscāt a'ntī ixtacuīni' Safira. Lā' xlaca'n tastā'lh pītzina'j ixti'ya'tca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lā' Ananías māquī'lh macsti'na'j ixtapalh. Lā' nā ixpuscāt nā ixlīca'tzī. Lā' Ananías līmilh a'ntū a'katāxtūlh lā' cāmaxquī'lh huan apóstoles. ");
INSERT INTO tooNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lā' Pedro hualh: ―Ananías, ¿a'chī' mātzumanī't mi'a'clhcunuc ko'ti'ti' lā' xtāpalīlh mintapāstacna' para nalē'ksa'nīni'na' Espíritu Santo lā' namāquī'ya' macsti'na'j huan tumīn ixtapalh ti'ya't? ");
INSERT INTO tooNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Chu tū' mila' ixuanī't huan ti'ya't a'xni'ca' tūna'j ī'stā'ya'? ¿Chu tū' mila' ixuanī't huan ixtapalh a'xni'ca' stā't huan ti'ya't? ¿A'chī' pāstacti natlahua'ya' huā'mā'? Lā' hui'x a'ksa'nī'ni' tū' xmān na ixlacapūn chi'xcuhuī'n. Hui'x nā a'ksa'nī'ni' na ixlacapūn Dios ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Lā' a'xni'ca' Ananías kaxmatli huā'mā' tachihuīn, a'kā'lh xanīn. Lā' lej ixtajicua'n ixlīhuākca'n a'ntīn takaxmatli. ");
INSERT INTO tooNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Lā' huan o'kxa'n tasacli Ananías lā' tamaksna'tli lā' tamāxtulh lā' tamā'cnūlh. ");
INSERT INTO tooNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lā' hua'chi ixlīlakatu'tun hora ixpuscāt Ananías tanūlh. Xla' tū' ixca'tzī a'ntū ixpātle'kenī't. ");
INSERT INTO tooNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Tuncan Pedro huanilh: ―Caquihua'ni', ¿lhānchula' līstā'tit huan ti'ya't? Lā' huan puscāt huanilh chu a'cxtim chuntza' chī ixuaninī't ixkōlu'. ");
INSERT INTO tooNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lā' Pedro huanilh: ―Lā' ¿a'chī' chu lālīca'tzīyā'tit na'a'ksa'nī'ni'nā'tit ixEspíritu Māpa'ksīni'? Cakaxpa'tti a'nchī tatantūsa'nan kēpūn a'ntī tamā'cnūnī't minkōlu'. Lā' nā hui'x natamāxtuyāni' ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lā' līlacapalh huan puscāt a'kā'lh xanīn na ixlacapūn Pedro. Lā' huan o'kxa'n tatanūchi lā' talaktzī'lh mā' xanīn. Lā' tamāxtulh lā' tamā'cnūlh ixpāxtūn ixkōlu'. ");
INSERT INTO tooNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Lā' lej ixtajicua'n ixlīhuākca'n a'ntī ixtakalhlaka'ī' lā' ixlīhuākca'n a'ntīn takaxmatli huā'mā'. ");
INSERT INTO tooNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Lā' huan apóstoles tatlahualh lhūhua' lē'cnīn lā' laka'tla'n catūhuā ixlaclhpu'nanca'n tachi'xcuhuī't. Lā' ixtatakēstoknī't ixlīhuākca'n na ixcorredor Salomón. ");
INSERT INTO tooNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nīn chā'tin de ixtalhūhuā'tca'n tū' talīhui'līlh natatā'takēxtimī con ū'tunu'n. Lā' tachi'xcuhuī't lej ta'a'cnīni'ni'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Lā' a'ntī ixtakalhlaka'ī' huan Māpa'ksīni' ā'chulā' ixtalhūhua'n chi'xcuhuī'n lā' puscan. ");
INSERT INTO tooNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lā' ixcālīmincan huan ī'tza'ca'nī'n nac cā'tejen a'nlhā ixtētaxtu Pedro. Lā' ixcāhui'līcan nac laklaj lā' na ī'xti'catca'n, palh tzē cahuā a'yuj xmān ixmāspilē'k Pedro ixcāmāskē'kēlh lā' chuntza' ixcāmātzeyīlh makapitzīn ī'tza'ca'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Lā' nā ixtamimā'na nac Jerusalén lhūhua' tachi'xcuhuī't xalanī'n huan xcānsipejni' na ixpajtzu Jerusalén. Lā' ixtalīmin ī'tza'ca'nī'n lā' a'ntī ixtaka'lhī tlajana'nī'n. Lā' ixlīhuākca'n cāmātzeyīca. ");
INSERT INTO tooNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lā' tatā'kaquī'lh huan xamāpa'ksīni' curasna' lā' ixchi'xcuhuī'n a'ntī ixtakalhlaka'ī' ixtamākalhtō'kē'nca'n saduceosnu'. Lā' lej ixtalakca'tzan xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Lā' cāchi'paca huan apóstoles lā' cāmānūca nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Lā' Dios macamilh kalhatin ángel. Lā' huan ángel cāmālaquī'ni'lh huan pūlāchī'n cā'tzī'sa lā' cāmāxtulh lā' cāhuanilh: ");
INSERT INTO tooNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Capitit lā' catāya'tit nac xaka'tla' lītokpān lā' cacātā'chihuīna'ntit huan tachi'xcuhuī't ixlīhuāk ixpālacata a'nchī tzē natalīka'lhī xasāsti' ixquilhtamacujca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lā' a'xni'ca' ixtakaxmatnī't huā'mā', tatanūlh nac xaka'tla' lītokpān a'xni'ca' ixtuncuīmā'tza' lā' tamāsu'yulh. Lā' huan xamāpa'ksīni' curasna' lā' nā ixchi'xcuhuī'n tatakēstokli. Lā' cāmākēstokca ū'tunu'n a'ntī ixtatlahua justicia lā' ixlīhuāk xanapuxcu'nu' xala' nac Israel. Lā' cāmacā'nca policíasna' para natamāxtu huan tachī'nī'n de nac pūlāchī'n lā' natalīmin. ");
INSERT INTO tooNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Lā' a'xni'ca' huan policíasna' tachā'lh, tū' cākaksca nac pūlāchī'n. Tataspi'tchokolh lā' tamāca'tzīnīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Lā' tahualh: ―Icchā'uj nac pūlāchī'n lā' iclaktzī'uj lā' ixlacchahua xa'nca. Lā' huan maktaka'lhna'nī'n ixtayāna' na ixlacapūn mākalhcha. Lā' a'xni'ca' icmālaquī'uj, nīn tintī' ickaksui na ixchakān huan pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lā' a'xni'ca' takaxmatli huā'mā', xacapitán xaka'tla' lītokpān lā' huan xanapuxcu'nu' curasna' lej lhūhua' tapāstacna'lh tuchūn chuhua'j nala. ");
INSERT INTO tooNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Lā' chu tuncan milh kalhatin lā' cāhuanilh: ―Huan chi'xcuhuī'n a'ntī hui'xina'n cāmānū'tit nac pūlāchī'n tayāna'ncha' nac xaka'tla' lītokpān lā' tamāsu'ni'mā'na huan tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Lā' tuncan ta'a'lh huan capitán lā' huan policíasna' lā' cāquītēpalaca Pedro lā' Juan. Lā' cālīminca lej līlacatzucu porque ixtajicua'ni' huan tachi'xcuhuī't que ixcāmūta'laca. ");
INSERT INTO tooNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Lā' a'xni'ca' ixcālīmincanī'ttza', cāhui'līca ixlacapūnca'n huan pūchihuīna'nī'n. Lā' xamāpa'ksīni' curasna' cākalhasqui'nīlh: ");
INSERT INTO tooNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Chu tū' iccāmāpa'ksīni' hui'xina'n lej līpalha' que tū'tza' camāsu'yu'tit por ixquilhtampān Jesús? Lā' hui'xina'n cāmāsca'tīkō'tittza' xalanī'n nac Jerusalén huā' mintamākalhtō'kē'nca'n. Lā' hui'xina'n hua'nā'tit que quina'n iclē'nāuj cuenta por ixpālacata maknīca Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Lā' takalhtīni'lh Pedro lā' ā'makapitzīn apóstoles lā' tahualh: ―Lā' ¿chu tzey palh na'iccā'a'kahuāna'ni'yāuj chi'xcuhuī'n lā' tū' na'ica'kahuāna'ni'yāuj Dios? ");
INSERT INTO tooNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","IxDiosca'n quinatāta'na'ca'n mālakahuanīchokolh Jesús a'ntī hui'xina'n māmaknīnīni'ntit a'xni'ca' xtokohua'ca'ca nac cruz. ");
INSERT INTO tooNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Lā' Dios līmā'ca'lh Jesús lā' hui'līlh na ixpāxtūcāna'j lā' hui'līlh xapuxcu' lā' māpūtaxtūnu'. U'tza' tlahualh para que xalanī'n nac Israel nataxtāpalī ixtapāstacna'ca'n lā' nacāmāsputūnu'ni'can a'ntū talaclē'ni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Lā' quina'n icmālacstū'ncāuj huā'mā'. Lā' nā chuntza' mālacstū'nca huan Espíritu Santo a'ntī Dios cāmaxquī'nī't xlaca'n a'ntīn ta'a'kahuāna'ni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lā' a'xni'ca' takaxmatli huā'mā', ta'a'kchā'lh lā' ixcāmaknīcu'tuncan. ");
INSERT INTO tooNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Lā' kalhatin pūchihuīna', a'ntī fariseo ixuanī't, ixtacuīni' Gamaliel. Xla' ū'tza' kalhatin mākalhtō'kē'ni' de huan ley. Lā' lej ixa'cnīni'ni'can. Xla' tāyalh lā' māpa'ksīni'lh que cacāmāxtuca Pedro lā' Juan lakatin ka'tlā'tus. ");
INSERT INTO tooNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Lā' Gamaliel cāhuanilh huan ā'makapitzīn pūchihuīna'nī'n: ―Chi'xcuhuī'n xalanī'n nac Israel, capāstacna'ntit xa'nca a'ntū nacātlahua'ni'yā'tit huā' tamā'na chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ca'tzīyā'tit que makāntza' i'xuī' kalhatin chi'xcu' ixtacuīni' Teudas, a'ntī ixuan que xla' lej ka'tla'. Lā' makapitzīn chi'xcuhuī'n, como hua'chi lakatā'ti' ciento, tastālani'lh. Xla' maknīca. Lā' ta'a'kahuankō'lh ixlīhuākca'n a'ntī ixtastālani'nī't. Lā' chuntza' līsputli a'ntū ixlītzucunī't Teudas. ");
INSERT INTO tooNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lā' ā'calīstān ixui'lapā Judas xala' nac Galilea a'xni'ca' lālaktzo'kca. Xla' cācuccha'xli makapitzīn lā' ixtastālani'. Lā' nā Judas sputli. Lā' ta'a'kahuankō'lh a'ntī ixtastālani'nī't. ");
INSERT INTO tooNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Lā' chuhua'j iccāhuaniyāni' hui'xina'n, nīn tuntū' cacātlahuani'tit huan chi'xcuhuī'n lā' cacāmakxtektit. Palh huā'mā' tapāstacna' lā' huā'mā' tamākalhtō'kē'n xmān ixla'ca'n chi'xcuhuī'n, ixa'cstu nasputa. ");
INSERT INTO tooNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Lā' palh ixla' Dios, tū' maktin catimāpānū'tit. Tū' ixlīca'tzan kalhtaxtoktipā'na'ntit Dios ―cāhuanilh Gamaliel. ");
INSERT INTO tooNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Lā' ta'a'ka'ī'lh ixtachihuīn Gamaliel. Lā' cāmātayīni'ca huan apóstoles lā' cāsno'kca. Lā' cāhuanica que tū'tza' natachihuīna'n por ixquilhtampān Jesús. Lā' cāmakxtekca. ");
INSERT INTO tooNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lā' Pedro lā' Juan tataxtulh ixlacapūnca'n pūchihuīna'nī'n. Lā' tapāxuhualh porque cālaktzī'nca xlaca'n lej tzey para natapātī a'ntū lej līmāxana' por ixpālacata Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Lā' lakalīyān nac xaka'tla' lītokpān lā' na ixchicca'n, tū' ixtamakxteka tamāsu'yu lā' tachihuīna'n ixpālacata Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Huā'mā'na chi'chini' ixtalhūhua'ntēlha huan a'ntī ixtakalhlaka'ī'. Lā' huan chi'xcuhuī'n griegos cāhuanilh huan hebreos que tū' xa'nca ixcāmāpitzini'can a'ntū ixcāmaxquī'can huan lakapūtnu' griegasna' lakalīyān. ");
INSERT INTO tooNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lā' huan kalhacāujtu' apóstoles tamākēstokli ixlīhuāk a'ntī ixtakalhlaka'ī' lā' cāhuanica: ―Tū' līmakuan na'icmakxtekāuj na'icmāsu'yuyāuj ixtachihuīn Dios lā' na'icmāstā'yāuj līhua't. ");
INSERT INTO tooNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pues chuhua'j, tā'timīn, cacālacsactit hui'xina'n kalhatojon chi'xcuhuī'n de hui'xina'n. Cacālacsactit a'ntī cālakapascan huāk lacuan lā' a'ntī talītzuma Espíritu Santo lā' a'ntī lej xa'nca tapāstacna'n. Lā' nacāmacamaxquī'yāuj huā'mā' lītlōt. ");
INSERT INTO tooNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Lā' quilītlōtca'n quina'n chu ū'tza'tza': na'icorarlīyāuj lā' na'icmāsu'yuyāuj ixtachihuīn Dios ―cāhuanica. ");
INSERT INTO tooNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Huā'mā' cāminī'ni'lh ixlīhuāk huan ixtalhūhuā'tca'n. Lā' lacsacca huan Esteban, kalhatin chi'xcu' a'ntī ixlītzuma Espíritu Santo lā' a'ntī xa'nca ixkalhlaka'ī' Dios. Lā' cālacsacca Felipe lā' Prócoro lā' Nicanor lā' Timón lā' Parmenas lā' Nicolás xala' nac Antioquía a'ntī ixtanūnī't na ixreligionca'n israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lā' cālīminca ixlacapūnca'n apóstoles lā' ta'orarlīlh lā' ta'a'cpūmā'ca'lh ixmacanca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Lā' a'kahualh ixtachihuīn Dios. Lā' a'ntī ixtakalhlaka'ī' lej ixtalhūhua'ntēlha nac Jerusalén. Lā' lhūhua' curasna' takalhlaka'ī'lh lā' ta'a'kahuāna'ni'lh ixtachihuīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Lā' Esteban lej ixkalhlaka'ī' lā' lej ixka'lhī līmāpa'ksīn. Lā' ixtlahua laka'tla'n catūhuā lā' lē'cnīn ixlaclhpu'nanca'n tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Lā' tatā'kaquī'lh makapitzīn xalanī'n na ixlītokpānca'n israelitas a'ntī ixcāmāpācuhuīcan Libertos, lā' nā xalanī'n nac Cirene lā' Alejandría lā' Cilicia lā' Asia. Xlaca'n talālīhuanilh con Esteban. ");
INSERT INTO tooNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero xlaca'n tūlalh tatā'lātlajalh por ixpālacata ixtapāstacna' Esteban lā' por ixpālacata Espíritu Santo a'ntī ixmāchihuīnī. ");
INSERT INTO tooNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Lā' xlaca'n tamāpalalh ā'makapitzīn para natalē'ksa'nīni'n lā' natahuan que ixtakaxmatnī't a'nchī Esteban a'ksa'nli Moisés lā' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Lā' cācuccha'xca tachi'xcuhuī't lā' huan xanapuxcu'nu' israelitas lā' huan mākalhtō'kē'ni'nī'n ley. Lā' chu līmaktin laktapajtzūca Esteban lā' chi'paca lā' līminca ixlacapūnca'n pūchihuīna'nī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Lā' cāhui'līca testigos a'ntīn tahualh a'ntūn tū' stu'ncua' lā' tahualh: ―Huā'mā' chi'xcu' tū' makxteka a'ksa'n huā' ley lā' huā' xaka'tla' lītokpān a'ntū sicua'lanālanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ickaxmatui a'xni'ca' hualh xla' que huā'mā' Jesús xala' nac Nazaret namāsputū huan xaka'tla' lītokpān lā' nataxtāpalī huan talanān a'ntū māsu'yulh Moisés natlahuayāuj. ");
INSERT INTO tooNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Lā' ixlīhuākca'n a'ntī ixtahui'lāna' a'nlhā ixtlahuacan justicia, talakalaktzī'lh Esteban. Lā' ixlacan ixtasu'yu hua'chi ixla' ángel. ");
INSERT INTO tooNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Lā' huan xamāpa'ksīni' curasna' kalhasqui'nīlh Esteban: ―¿Chā stu'ncua' huā'mā'? ");
INSERT INTO tooNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Lā' Esteban hualh: ―Chi'xcuhuī'n, israelitas hua'chi quit, cakaxpa'ttit. Dios a'ntī lej ka'tla', tasu'yuni'lh quimpapca'n Abraham a'xni'ca' xla' ixuī'cus nac xcānsipej Mesopotamia. Tūna'j ixa'n tahui'la nac Harán. ");
INSERT INTO tooNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios huanilh: Cataxtu de mi'ā'lacchicni' lā' cacāmakxtekti mintalakapasnī'n lā' capi't nac xcānsipej a'ntū na'icmāsu'ni'yāni'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Lā' Abraham taxtulh de huan ī'xcānsipejca'n caldeosnu' lā' a'lh tahui'la nac Harán. Lā' a'xni'ca' ixnīnī'ttza' ixtāta' Abraham, Dios līmilh Abraham huā'tzā' nac xcānsipej a'nlhā hui'xina'n hui'lā'na'ntit chuhua'j. ");
INSERT INTO tooNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Lā' Dios tūna'j maxquī'lh ti'ya't ā'tzā', nīn pītzina'j a'nlhā nayāhua ixtojon. Xmān huanilh que ixtēcu' ti'ya't nala xla' lā' ixnatā'natna', a'yuj xla' tūna'j ixka'lhī ixcaman. ");
INSERT INTO tooNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Dios tā'chihuīna'lh chuntza': Minatā'natna' natatahui'la hua'chi xatza'nkān nac ā'lakatin xcānsipej. Lā' a'ntza' lej nacāmāscujūcan lā' nacāmāpātīnīcan lakatā'ti' ciento cā'ta. ");
INSERT INTO tooNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lā' quit na'iccāmāpātīnī huan tachi'xcuhuī't a'ntī nacāmāscujū minatā'natna'. Lā' ā'calīstān natataxtu minatā'natna' lā' naquintamācā'tanī ā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Lā' Dios cāxtlahualh huan convenio a'ntū ixpālacata ixcāchu'cucan chi'xcuhuī'n israelitas para que nacālīlakapascan. Lā' tahuī'lh kalhatin ixcaman Abraham, ixtacuīni' Isaac. Lā' ixlīlakatzeyan chi'chini' Abraham chu'culh ixcaman para nalīlakapascan hua'chi israelita. Lā' ā'calīstān tahuī'lh kalhatin ixcaman Isaac, ixtacuīni' Jacob. Lā' ā'calīstān Jacob ka'lhīlh kalhacāujtu' ixo'kxa'n a'ntīn quinapapna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Lā' huan quinapapna'ca'n ixtaca'tzalaktzī'n ixtā'tinca'n José. Lā' xlaca'n tastā'lh José. Lā' lē'nca nac Egipto. Pero Dios ixmaktaka'lha. ");
INSERT INTO tooNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Lā' Dios māpūtaxtūlh de ixlīhuāk a'ntūn pātīlh. Lā' Dios maxquī'lh José tapāstacna' na ixlacapūn Faraón a'ntī rey xala' nac Egipto. Lā' Faraón ixa'cnīni'ni' huan José. Lā' hui'līlh ixlīgobernador nac Egipto. Lā' hui'līlh que namāpa'ksīkō' ixlīhuāk ixchic Faraón. ");
INSERT INTO tooNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Lā' milh lakatin tatzi'ncsta ixlīhuāk huanmā' ti'ya't Egipto lā' nac Canaán. Lā' lej tapātīni'lh. Lā' huā' quinapapna'ca'n tū' ixtakaksa a'ntū natahua'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Lā' a'xni'ca' kaxmatli Jacob que nac Egipto ixa'nan trigo, pū'la cāmacā'lh a'ntza' ixo'kxa'n a'ntīn quinapapna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lā' a'xni'ca' ta'a'mpā ixlīmaktu', José cāmāca'tzīnīlh que ū'tza' māni' ī'stancuca'n ixuanī't. Lā' Faraón māca'tzīnīca que ixtalakapasni' José ixtahuanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Lā' José mātayīni'lh Jacob a'ntī ixtāta' lā' ixlīhuākca'n ixtā'timin lā' ixcamana'ca'n. Xlaca'n pūpitzi ciento ā'pu'xamaquitzis tachi'xcuhuī't. ");
INSERT INTO tooNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Lā' Jacob a'lh tahui'la nac Egipto. A'ntza' nīlh xla' lā' nā tanīkō'lh ixo'kxa'n a'ntī quinapapna'ca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Lā' ā'maktin cālē'mpalaca nac Siquem lā' a'ntza' cāmā'cnūca nac lhu'cu' a'ntū cāmaktamāhualh Abraham ixcamana' Hamor xalanī'n Siquem. Lītamāhualh con tumīn. ");
INSERT INTO tooNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Ixtapajtzūtēlha huan chi'chini' a'xni'ca' ixtlōkentaxtū Dios a'ntū ixuaninī't Abraham. Lā' huan tachi'xcuhuī't israelitas lhūhua'ntēlhalh nac Egipto. ");
INSERT INTO tooNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Lā' hui'līpalaca kalhatin rey nac Egipto a'ntīn tū' lakapasli José. ");
INSERT INTO tooNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Xla' cā'a'kxokolh quinapapna'ca'n lā' chuntza' cālītlajalh. Lā' xla' cāmāpātīnīlh quinapapna'ca'n lā' cāmāmaka'nīlh xanatāta'na' ixlakska'tā'nca'n para que natanī. ");
INSERT INTO tooNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lā' huā'mā'na chi'chinī'n tahuī'lh Moisés lā' xla' tzēhuanī't ixuanī't na ixlacapūn Dios. Lā' ixmaktaka'lhmā'ca lakatu'tun mālhcuyu' na ixchic ixtāta'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Lā' a'xni'ca' nā tihui'līca Moisés kēpūn, ixtzu'ma'jāt Faraón sacli huan ska'ta' lā' makastacli como hua'chi scana'nca ixcaman. ");
INSERT INTO tooNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Lā' Moisés māsca'tīca ixlīhuāk tapāstacna' xala' nac Egipto. Lā' lej xa'nca ixchihuīna'n lā' huāk tzē ixtlahua. ");
INSERT INTO tooNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Lā' a'xni'ca' ixka'lhītza' tu'pu'xam cā'ta, puhualhtza' palh nacālaka'n ixtalakapasnī'n a'ntī israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lā' laktzī'lh a'nchī kalhatin egipcio ixmāpātīnīmā' kalhatin israelita. Lā' Moisés līmaktāyalh lā' mātakāhuī'lh huan egipcio. Lā' chuntza' tapalana'ni'lh huan tī ixmāpātīnīmā'ca. ");
INSERT INTO tooNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ixpuhuan que huan israelitas ixtamāchekxī a'nchī Dios ixlacsacnī't nacāmaktāya natapūtaxtu. Pero xlaca'n tū' ixtamāchekxī. ");
INSERT INTO tooNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Lā' ixlīlakalī huampala cālakchilh Moisés a'xni'ca' ixtalālacatāquī' kalhatu' israelitas lā' ixcāmāko'xamixīcu'tun lā' cāhuanilh: “Chi'xcuhuī'n, hui'xina'n lītalakapasnī'n. ¿A'chī' lālacatāquī'yā'tit?” ");
INSERT INTO tooNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Lā' tuncan huan tī ixlacatāquī' ixtā'chic tampi'ta'lh Moisés lā' hualh: “¿Tichū hui'līni' hua'chi quimpuxcu'ca'n lā' quijuezca'n? ");
INSERT INTO tooNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Chā naquimaknīcu'tuna' quit hua'chi ma'kni' kōtan huan egipcio?” ");
INSERT INTO tooNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lā' a'xni'ca' kaxmatli huā'mā', Moisés tzā'lalh. Lā' chā'lh nac xcānsipej Madián lā' a'ntza' tachokolh hua'chi xatza'nkān. Lā' talacatuncuīlh kalhatu' ixo'kxa'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Lā' a'xni'ca' ixpātle'kenī'ttza' tu'pu'xam cā'ta, kalhatin ángel tasu'yuni'lh nac cā'lhpi'mpi'li' ti'ya't ixpajtzu huan kēstīn ixtacuīni' Sinaí. A'ntza' tasu'yulh nac a'katin puchuna'j qui'hui' a'ntū ī'lhcumā'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","A'xni'ca' lakzī'lh Moisés tū' ixlīca'tzīhuī'. Lā' tapajtzūlh para nalaktzī'n. Lā' ixtachihuīn Māpa'ksīni' huanilh: ");
INSERT INTO tooNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Quit ixDiosca'n minatāta'na' lā' ixDiosca'n Abraham lā' Isaac lā' Jacob. Lā' Moisés xpipilh lā' jicua'lh lā' tū' līhui'līlh nalaktzī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Lā' Māpa'ksīni' huanilh: Catatūxtu mizapato porque a'nlhā yā't, ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Quit stu'ncua' iclaktzī'nī't a'nchī cāmāpātīnīmā'ca quintachi'xcuhuī't a'ntīn tahui'lāna' nac Egipto. Lā' ickaxmatnī't a'nchī tahua'ntli'jmā'na xlaca'n, lā' icyujnī'ta'nchi para na'iccāmāpūtaxtū. Lā' chuhua'j cata't. Na'icmacā'nāni' nac Egipto. ");
INSERT INTO tooNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Lā' huā'mā' chu ū'tza' Moisés a'ntī talakmaka'lh a'xni'ca' tahualh: ¿Tichū hui'līnī'ta'ni' hua'chi quimpuxcu'ca'n lā' quijuezca'n? Lā' Dios macamilh huā'mā' Moisés hua'chi xapuxcu' lā' māpūtaxtūnu'. Lā' ixmaktāya huan ángel a'ntī tasu'yuni'lh nac a'katin puchuna'j qui'hui'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Lā' Moisés cāmāxtulh quinapapna'ca'n. Xla' tlahualh lej laka'tla'n lē'cnīn nac Egipto lā' nac mar a'ntū huanican Spi'nenke' lā' nac cā'lhpi'mpi'li' ti'ya't tu'pu'xam cā'ta. ");
INSERT INTO tooNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Huā'mā' ū'tza' Moisés a'ntī cāhuanilh israelitas: Māpa'ksīni' quinDiosca'n nalacsaca chā'tin de mintalakapasni'ca'n chuntza' hua'chi quilacsacli quit. U'tza' ixa'cta'sana' Dios nala. Lā' nakaxpa'tā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Huā'mā' Moisés ū'tza' ixuī' a'xni'ca' ixtatakēstoknī't nac cā'lhpi'mpi'li' ti'ya't. Lā' huan ángel tā'chihuīna'lh nac kēstīn Sinaí. Lā' Moisés cāhuanilh quinapapna'ca'n a'ntū hualh huan ángel. Lā' Moisés maklhtīni'lh huan tachihuīn a'ntūn tū' maktin catisputli. Lā' huan tachihuīn quincāmaxquī'ni'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Huā' quinapapna'ca'n tū' ta'a'kahuāna'ni'cu'tulh Moisés lā' talakmaka'lh. Lā' ixtapuhuan natataspi'ta nac Egipto. ");
INSERT INTO tooNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Tahuanilh Aarón: Caquilātlahuani'uj ídolos a'ntū naquincātapū'lani'yāni'. Tū' icca'tzīyāuj a'ntū pātle'keni'nī't huā'mā' Moisés a'ntī quincāmāxtuni' nac ti'ya't Egipto. ");
INSERT INTO tooNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Entonces xlaca'n tatlahualh lakatin ídolo a'ntū ixtasu'yu hua'chi ti'na'j huācax lā' tamaxquī'lh lē'ksajuī'n huan ídolo. Lā' lej talīpāxuhualh a'ntū ixtatlahuanī't māni' xlaca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Lā' Dios tamakatīlh de xlaca'n lā' cāmakxtekli que natamācā'tanī sta'cu. Lā' nā chuntza' tatzo'kni' huan nac libro a'ntū tzo'kli kalhatin a'ntī ixa'cta'sana' Dios. Hualh: Lā' hui'xina'n, israelitas, ¿chu quilāmālacnūni'uj lē'ksajna' lā' animalhna' xatamaknīn ixlīhuāk huan tu'pu'xam cā'ta nac cā'lhpi'mpi'li' ti'ya't? ");
INSERT INTO tooNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Hui'xina'n līta'ntit ixcarpa huan ídolo Moloc a'nlhā ixtaquilhpūtani'can, lā' huan ídolo Renfán a'ntū ixtasu'yu hua'chi sta'cu. Hui'xina'n tlahua'tit para nacāmācā'tanīyā'tit. Lā' chuhua'j quit na'iccālē'nāni' más a'jlē'nī'ta'ncha' de Babilonia. Chuntza' tatzo'kni'. ");
INSERT INTO tooNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Lā' Esteban huampā: ―Nac cā'lhpi'mpi'li' ti'ya't, quinapapna'ca'n ixtaka'lhī huan xaka'tla' carpa a'ntū ixmāsu'yu que Dios ixcā'o'kska'lhīlē'mā'. Lā' huan carpa ū'tza' ixtlahuanī't Moisés chu a'nchī hua'chi Dios ixuaninī't lā' chu a'nchī Dios ixmāsu'ni'nī't. ");
INSERT INTO tooNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lā' quinapapna'ca'n tamaklhtīni'lh huan carpa. Lā' talīmilh a'xni'ca' tatanūchi con Josué na ixti'ya'tca'n xtuncnu' chi'xcuhuī'n a'ntī Dios cāmāxtulh ixlacapūnca'n quinapapna'ca'n. Lā' a'ntza' tachokolh huan carpa hasta ixquilhtamacuj David. ");
INSERT INTO tooNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios līpāxuhualh David. Xla' ixtlahuacu'tun lakatin ixchic Dios a'ntī nā ixDios Jacob. ");
INSERT INTO tooNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero huan a'ntī tlahualh huan chic, ū'tza' Salomón. ");
INSERT INTO tooNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero Dios, a'ntī lej ka'tla', tū' tahui'la nac lakatin chic a'ntū tatlahuanī't chi'xcuhuī'n. Lā' nā chuntza' hualh ixa'cta'sana' Dios: ");
INSERT INTO tooNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Quit, Dios, icmāpa'ksī nac a'kapūn lā' nac quilhtamacuj. ¿Tuchūyā chic naquilātlahuani'yāuj? huani Māpa'ksīni'. Lā' ¿lhachū na'icjaxa quit? ");
INSERT INTO tooNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Chu tū' quit ictlahualh ixlīhuāk a'ntū a'nan? ");
INSERT INTO tooNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Lā' Esteban cāhuanipā: ―Hui'xina'n lej lacxumpi. Tū' ka'lhī'yā'tit mi'a'clhcunucca'n para napūpāstacna'nā'tit. Lā' tū' kaxpa'tcu'tunā'tit. Hui'xina'n pō'ktu kalhtaxtoktīyā'tit huan Espíritu Santo. Chu a'nchī ixtala minapapna'ca'n nā chuntza' la'yā'tit hui'xina'n. ");
INSERT INTO tooNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Minapapna'ca'n tamāpātīnīlh ixlīhuākca'n ixa'cta'sana'nī'n Dios. Lā' tamaknīlh a'ntīn tahualh xapū'la que namin a'ntī xatzey. U'tza' milh lā' hui'xina'n macamāstā'tit lā' māmaknīnīni'ntit. ");
INSERT INTO tooNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Hui'xina'n maklhtīni'ntit huan ley a'ntū tamacamāstā'lh ángeles. Pero tū' a'kahuāna'ni'tit ―hualh Esteban. ");
INSERT INTO tooNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lā' a'xni'ca' takaxmatli huā'mā', ta'a'kchā'lh lā' ixtamāsā'nī ixtatzanca'n porque lej ta'a'kchā'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Lā' ixa'clhcunuc Esteban ixlītzuma Espíritu Santo. Lā' xla' ixtalacayāhuayā para nac a'kapūn. Lā' laktzī'lh huan xkakana' a'nlhā ixuī' Dios. Lā' laktzī'lh Jesús na ixpāxtūcāna'j Dios ");
INSERT INTO tooNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","lā' hualh: ―Calaktzī'ntit. Quit iclaktzī'n huan a'kapūn laquī'yā. Lā' ixtā'tin ixlīhuāk tachi'xcuhuī't huī' na ixpāxtūcāna'j Dios ―hualh Esteban. ");
INSERT INTO tooNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lā' ixlīhuākca'n a'ntī ixtahui'lāna' a'nlhā ixtlahuacan justicia, xlaca'n tata'salh palha' lā' cā'a'kachi'paca. Lā' ixlīhuākca'n tuncan talakminkō'lh lacapalh. ");
INSERT INTO tooNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Lā' māxtuca Esteban de huan nac xcānsipej lā' mūta'laca. Lā' huan testigos tahui'līlh ixlu'xu'ca'n na ixlacapūn kalhatin o'kxa' a'ntī ixtacuīni' Saulo. ");
INSERT INTO tooNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Lā' a'xni'ca' mūta'laca Esteban ta'sani'lh Dios lā' huanilh: ―Māpa'ksīni' Jesús, cachi'patampāxtokchi quilīca'tzīn. ");
INSERT INTO tooNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lā' tatzokostalh lā' ta'salh lej palha' lā' hualh: ―Māpa'ksīni', cacāmāsputūnu'ni' a'ntū quintatlahuani'mā'na. Lā' a'xni'ca' hualh huā'mā' Esteban nīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Lā' Saulo chu ixlīca'tzī a'nchī līmaknīca Esteban. Lā' huanmā' chi'chini' tzucuca lej cāmacaputzacan a'ntī ixtakalhlaka'ī' xalanī'n nac Jerusalén. Lā' ixlīhuākca'n ta'a'kahuankō'lh hasta nac ti'ya't Judea lā' Samaria. Lā' tatachokolh xmān apóstoles. ");
INSERT INTO tooNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Lā' makapitzīn chi'xcuhuī'n, a'ntī ixta'a'cnīni'ni' Dios, talē'lh Esteban lā' tamā'cnūlh. Lā' lej talakcalhualh xla'. ");
INSERT INTO tooNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Lā' Saulo ixlīhui'lī ixcāmāsputūkō'lh huan a'ntī ixtakalhlaka'ī'. Tzuculh tanū nac lakatunu' chic lā' ixcāstancalē'n chi'xcuhuī'n lā' puscan lā' ixcāmānū nac pūlāchī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lā' a'ntīn ta'a'kahuankō'lh ixta'a'n lakaxtim lā' ixtachihuīna'n huan xatzey tachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Lā' Felipe a'lh tancā'n nac xcānsipej ixtacuīni' Samaria. Lā' ixcāmāsu'ni' ixpālacata Cristo. ");
INSERT INTO tooNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lā' huan ixtalhūhuā't tachi'xcuhuī't ixtakaxmata a'cxtim a'ntū ixcāhuani Felipe. Takaxmatli lā' talaktzī'lh huan lē'cnīn a'ntū ixtlahua. ");
INSERT INTO tooNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Lā' huan tlajana'nī'n ixtata'sa lej palha' lā' tataxtulh de xlaca'n a'ntī ixtaka'lhī. Lā' lhūhua' ixtalū'ntū'lanī't lā' xalactajua' chi'xcuhuī'n ixcāmātzeyīcan. ");
INSERT INTO tooNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Lā' lej ixa'nan lhūhua' tapāxuhuān huanmā' nac xcānsipej. ");
INSERT INTO tooNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Lā' ixuī' chā'tin chi'xcu' ixtacuīni' Simón. Xla' xapū'la ixuanī't tlahuāna' nac huanmā' xcānsipej. Lā' ixtalē'cnī huan tachi'xcuhuī't xalanī'n nac Samaria. Lā' hualh que ū'tza' māni' lej ka'tla'. ");
INSERT INTO tooNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Lā' xa'nca ixtakaxmatni' Simón ixlīhuākca'n a'ntī xalacti'na'j lā' a'ntī xalaka'tla'n. Lā' ixtahuan: ―Huā'mā' chi'xcu' lej ka'lhī ixlīmāpa'ksīn Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lā' xa'nca takaxmatni'lh Simón porque lej makān talē'cnīlh ixtatlahuān. ");
INSERT INTO tooNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Lā' Felipe cākalhachihuīna'ni'lh xatzey tachihuīn ixpālacata a'nchī Dios māpa'ksīni'n lā' ixpālacata Jesucristo. Lā' xlaca'n takalhlaka'ī'lh lā' ta'a'kpaxli chi'xcuhuī'n lā' puscan. ");
INSERT INTO tooNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Lā' nā huan Simón nā xla' kalhlaka'ī'lh lā' a'kpaxli lā' stālani'lh Felipe. Lā' a'xni'ca' Simón laktzī'lh huan laka'tla'n lā' lej lhūhua' lē'cnīn, xla' lej lhūhua' ixpāstacna'n. ");
INSERT INTO tooNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lā' a'xni'ca' taca'tzīlh que xalanī'n nac Samaria ixtamaklhtīni'nī'ttza' ixtachihuīn Dios, huan apóstoles xalanī'n nac Jerusalén tamacā'lh Pedro lā' Juan nac Samaria. ");
INSERT INTO tooNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Xlaca'n tamilh lā' ta'orarlīlh que catamaklhtīni'lh Espíritu Santo xalanī'n nac Samaria. ");
INSERT INTO tooNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tūna'j ixcālakyujachi Espíritu Santo. Xmān ixta'a'kpaxnī't lā' chuntza' tamāsu'yulh que tatapa'ksīlh con Māpa'ksīni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Lā' ta'a'cpūmā'ca'lh ixmacanca'n lā' xlaca'n tamaklhtīni'lh Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lā' Simón laktzī'lh que huan Espíritu Santo māstā'ca a'xni'ca' huan apóstoles ta'a'cpūmā'ca'lh ixmacanca'n. Lā' cāmālacnūni'lh tumīn. ");
INSERT INTO tooNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Lā' hualh Simón: ―Nā quit caquilāmaxquī'uj huā'mā' līmāpa'ksīn para que chuntza' chu catīhuā na'ica'cpūmā'ca' quimacan nā tzē namaklhtīni'n huan Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Lā' Pedro huanilh: ―Casputli mintumīn lā' nā hui'x casputti porque puhuanti nalītamāhua'ya' tumīn a'ntū ixlē'ksajna' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Hui'x tūla catimaklhtīni' huanmā' lē'ksajna' porque tū' tzey mi'a'clhcunuc na ixlacapūn Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Camakxtekti huanmā' ko'hua'jua' tapāstacna' lā' casqui'ni' Māpa'ksīni' Dios lā' tzēla chuntza' namāsputūnu'ni'yāni' Dios huanmā' tapāstacna' a'ntū ka'lhī'ya' na mi'a'clhcunuc. ");
INSERT INTO tooNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Iclaktzī'nāni' lej ca'tzanca'tzī'ya'. Hui'x tūla makxteka a'ntūn tū' tzey. ");
INSERT INTO tooNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Lā' kalhtīni'lh Simón lā' hualh: ―Casqui'ni'tit Māpa'ksīni' Dios que tū' naquimpātle'keni' nīn tuntū' a'ntū hui'xina'n hua'nā'tit. ");
INSERT INTO tooNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Lā' a'xni'ca' xlaca'n ixtamālacstū'ncnī'ttza' lā' ixtachihuīna'nī'ttza' ixtachihuīn Dios, tataspi'tpā para nac Jerusalén. Lā' tachihuīna'lh huan xatzey tachihuīn ixpālacata Jesucristo nac lacalhūhua' ixā'lacchicni'ca'n samaritanosnu'. ");
INSERT INTO tooNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Lā' tā'chihuīna'lh Felipe kalhatin ángel a'ntī Dios macamilh lā' huanilh: ―Catā'kaqui' lā' capit nac sur. Nalacpina' xatej Jerusalén para Gaza. A'ntza' cā'lhpi'mpi'li' ti'ya't. ");
INSERT INTO tooNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Lā' Felipe tā'kaquī'lh lā' a'lh. Lā' ixuī' kalhatin eunuco xala' nac Etiopía. Xla' pūchihuīna' ixuanī't nac Etiopía a'nlhā ixmāpa'ksīni'n huan reina ixtacuīni' Candace. Huā'mā' chi'xcu', xla' ū'tza' xamaktaka'lhna' ixlīhuāk ixlīrico huan reina. Lā' quīlachi nac Jerusalén para namācā'tanī Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Lā' ixtaspi'tmā'tza' lā' ixpūmimā' lakatin carro a'ntū ī'stancalē'mā' huan cahuāyuj. Lā' ixlakapūtle'kehuī' a'ntū tzo'kli Isaías, a'ntī ixa'cta'sana' Dios ixuanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lā' huan Espíritu Santo huanilh Felipe: ―Catapajtzu' nac xatej a'nlhā lē'mā'ca huan carro lā' catā'pi. ");
INSERT INTO tooNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Lā' Felipe tu'jnulh lā' lakmilh lā' kaxmatli a'nchī xla' ixlakapūtle'kehuī' a'ntū ixtzo'knī't Isaías. Lā' Felipe kalhasqui'nīlh: ―¿Chā māchekxī'ya' a'ntū lakapūtle'keya'? ");
INSERT INTO tooNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Lā' kalhtīlh: ―Tūla como tintī' a'ntī naquimāsu'ni'. Lā' huanica Felipe que catō'ca'lh lā' capāxtūtō'lalh. ");
INSERT INTO tooNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lā' xla' ixlakapūtle'kehuī' ixtachihuīn Dios a'nlhā huan chuntza': Hua'chi lē'ncan lakatin oveja a'ntū namaknīcan, chuntza' lē'nca huan chi'xcu'; lā' como hua'chi lakatin borrego xla' kō'ko' na ixlacapūn a'ntī macsi'ta, chuntza' huan chi'xcu' nīn tuntū' hualh. ");
INSERT INTO tooNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Lā' māmāxanī'ca lā' tū' xa'nca tlahuani'ca justicia. Lā' nīn tintī' tūla pūtle'ke tichū ixtā'natna' huan chi'xcu', porque maknīca. ");
INSERT INTO tooNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Lā' huan eunuco huanilh Felipe: ―Icsqui'ni'yāni' caquihua'ni', ¿tichū līchihuīna'mā' huā'mā' Isaías? ¿Chu ixa'cstu līchihuīna'ncan, o līchihuīna'n ā'kalhatin? ");
INSERT INTO tooNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lā' Felipe tzuculh chihuīna'n. Lā' tzuculh xa'nca huani a'ntū ixlakapūtle'kenī't huan ixtachihuīn Dios lā' māsu'ni'lh ixpālacata Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Lā' a'xni'ca' ixta'a'mā'na nac tej, tachā'lh a'nlhā mā' xcān. Lā' hualh huan eunuco: ―Cala'ktzi'. Huā'tzā' mā' xcān. ¿Chu a'nan a'ntū naquimāmakchuyī para que tzē na'ica'kpaxa? ");
INSERT INTO tooNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Lā' Felipe huanilh: ―Palh hui'x kalhlaka'ī'ya' con ixlīhuāk mi'a'clhcunuc, tzē na'a'kpaxa'. Lā' xla' kalhtīni'lh: ―Quit ickalhlaka'ī' que Jesucristo ū'tza' ixO'kxa' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Lā' chu tuncan māyāhuanīni'lh huan carro. Lā' tatojōlh nac xcān ixtu'ca'n, Felipe lā' huan eunuco. Lā' Felipe mā'kpaxīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lā' a'xni'ca' tatacutli nac xcān, ixEspíritu Dios mā'kayāhualh Felipe. Lā' huan eunuco tū'tza' laktzī'lh. Lā' huan eunuco a'mpā lā' lej pāxuhualh. ");
INSERT INTO tooNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Lā' Felipe lakchā'nca nac xcānsipej Azoto. Lā' ixcākalhachihuīna'ni'tēlha xatzey tachihuīn ixpālacata Jesucristo na ixlīhuāk xcānsipejni' hasta que chā'lh nac Cesarea. ");
INSERT INTO tooNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lā' Saulo lej ixcāmākē'klha a'ntī ixtakalhlaka'ī' huan Māpa'ksīni' lā' ixcāmaknīcu'tun. Lā' lakmilh xamāpa'ksīni' curasna' ");
INSERT INTO tooNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","lā' squi'nli lakatin acta a'ntū nalē'n na ixlītokpānna'ca'n israelitas nac Damasco. Lā' chuntza' tzē nacāputza chi'xcuhuī'n lā' puscan a'ntī ixtastālani' Jesús lā' tzē nacālīmin xatachī'nī'n nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lā' Saulo ixtlā'huantēlha lā' ixtapajtzūtēlhatza' nac Damasco. Lā' chu līmaktin lakatin xkakana' xala' nac a'kapūn lītamacxti'li'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lā' a'kā'lh nac ti'ya't. Lā' kaxmatli lakatin tachihuīn a'ntū ixuani: ―Saulo, Saulo, ¿a'chī' quimacaputzaya'? ");
INSERT INTO tooNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Lā' Saulo kalhasqui'nīlh: ―¿Tichū hui'x, Māpa'ksīni'? Lā' xla' hualh: ―Quit Jesús, chu ū'tza' a'ntī hui'x macaputzaya'. Chu tlakaj quintā'latla'hua'ya'. Hui'x hua'chi lakatin cahuāyuj a'xni'ca' chi'nta huan qui'hui' a'ntū lītlakalē'ncan. ");
INSERT INTO tooNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lā' Saulo ixpipi lā' ixjicua'n lā' hualh: ―Māpa'ksīni', ¿tuchū lacasqui'na' na'ictlahua quit? Lā' huan Māpa'ksīni' huanilh: ―Catā'kaqui' lā' catanu' nac xcānsipej. Lā' a'ntza' nahuanica'na' a'ntū līhui'līca natlahua'ya'. ");
INSERT INTO tooNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Lā' huan chi'xcuhuī'n a'ntī ixtatā'latlā'huan Saulo, takaxmatli lakatin tachihuīn pero nīn tintī' talaktzī'lh. Lā' lej talē'cnīlh. ");
INSERT INTO tooNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Lā' Saulo tā'kaquī'lh de nac ti'ya't. Lā' a'xni'ca' titalakapākē'cu'tulh, tūlalhtza' lacahuāna'lh. Lā' makachi'palē'nca lā' līminca nac Damasco. ");
INSERT INTO tooNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","A'ntza' tahuī'lh lakatu'tun chi'chini' lā' tūlalh lacahuāna'lh. Lā' tū' huā'yalh lā' tū' ko'tnūlh. ");
INSERT INTO tooNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Lā' ixuī' nac Damasco kalhatin chi'xcu' a'ntī ixkalhlaka'ī' lā' ixtacuīni' Ananías. Xla' lakachuyalh lā' huan Māpa'ksīni' huanilh: ―Ananías. Lā' xla' kalhtīni'lh: ―Lā' ā'tzā' icuī', Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Lā' Māpa'ksīni' huanilh: ―Capit huan nac calle a'ntū huanican Xaslitua'. Lā' caputza na ixchic Judas kalhatin a'ntī ixtacuīni' Saulo xala' nac xcānsipej Tarso. A'ntza' kalhtō'ka'mā'. ");
INSERT INTO tooNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","U'tza' lakachuyanī't lā' laktzī'nī't kalhatin chi'xcu' ixtacuīni' Ananías a'ntī tanūlh lā' a'cpūmā'ca'lh ixmacan para que chuntza' nalacahuāna'nchokopala. ");
INSERT INTO tooNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Pero Ananías kalhtīni'lh: ―Māpa'ksīni', lhūhua' quintahuaninī't que huā'mā' chi'xcu' lej lhūhua' a'ntūn tū' tzey cātlahuani'nī'ttza' xalanī'n nac Jerusalén a'ntīn takalhlaka'ī' mintachihuīn. ");
INSERT INTO tooNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Lā' huan xanapuxcu'nu' curasna' tamaxquī'nī't līmāpa'ksīn que xla' naquincāchi'payāni' quilīhuākca'n a'ntī icchihuīna'nāuj por milīmāpa'ksīn. ");
INSERT INTO tooNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Lā' Māpa'ksīni' huanilh: ―Capit porque quit iclacsacnī't Saulo. Xla' nacātā'chihuīna'n de quit xalanī'n nac ā'lakatunu' xcānsipejni' lā' reyes lā' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Quit na'icmāsu'ni' līlhūhua' a'ntū napātīni'n por quimpālacata. ");
INSERT INTO tooNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Lā' Ananías a'lh lā' tanūlh huan nac chic a'nlhā ixuī' Saulo. Lā' a'cpūmā'ca'lh ixmacan lā' huanilh: ―Tā'tin Saulo, quimacaminī't huan Māpa'ksīni' Jesús a'ntī tasu'yuni'ni' nac tej a'nlhā ixta'mpā't. U'tza' quimacaminī't para que nalacahuāna'nchokopala'ya' lā' nalītatzumakō' Espíritu Santo mi'a'clhcunuc. ");
INSERT INTO tooNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Lā' tuncan yujni'lh ixlakastapun catūhuā hua'chi xapipēks lā' lacahuāna'nchokopā. Lā' tā'kaquī'lh lā' tuncan a'kpaxli. ");
INSERT INTO tooNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Lā' huā'yalh lā' tli'hui'quimpā. Lā' lātma'j ixcātā'lahuī' huan tā'timīn nac Damasco. ");
INSERT INTO tooNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lā' chu tuncan huan na ixlītokpānna'ca'n israelitas, Saulo tzuculh līchihuīna'n Jesús. Lā' ixuan que ū'tza' huā'mā' ixO'kxa' quinDiosca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Lā' talē'cnīlh ixlīhuākca'n a'ntīn takaxmatli lā' talāhuanilh: ―¿Chu tū' ū'tza' huā'mā' a'ntī ixcāmāsputūcu'tun nac Jerusalén a'ntī ixtatapa'ksī con Jesús? Lā' minī't huā'tzā' lā' quincālē'ncu'tunāni' tachī'n lā' quincāmacamaxquī'cu'tunāni' xanapuxcu'nu' curasna'. U'tza' līmilh huā'tzā'. ");
INSERT INTO tooNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Lā' Saulo más ixtahuixcānī. Lā' ixmālacstū'nca que Jesús ū'tza' huā'mā' Cristo a'ntī Dios ixlacsacui'līnī't. Lā' ū'tza' talīlē'cnīlh huan israelitas a'ntī ixtahui'lāna' nac Damasco. ");
INSERT INTO tooNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Lā' a'xni'ca' ixpātle'kēnī'ttza' lakalhūhua' chi'chini', huan israelitas talacchihuīna'lh para natamaknī Saulo. ");
INSERT INTO tooNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Lā' māca'tzīnīca Saulo que ixmaktaka'lhmā'ca. Tintacuj lā' tintascac ixtaka'lhītīmā'na huan lhā ixlactanūcan nac cā'lacchicni' porque ixtamaknīcu'tun. ");
INSERT INTO tooNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Lā' cā'tzī'sa huan tā'timīn talē'lh Saulo lā' tamāyujūlh nac lakatin canasta de na ixa'cpān taxaka de huan cā'lacchicni'. Lā' chuntza' līpūtaxtulh. ");
INSERT INTO tooNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Lā' Saulo a'lh nac Jerusalén lā' ixcātā'tanūcu'tun huan tā'timīn a'ntza'. Lā' xlaca'n ixtajicua'ni'. Tū' ta'a'ka'ī'lh que xla' ixkalhlaka'ī'nī't. ");
INSERT INTO tooNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Lā' Bernabé cālīmini'lh Saulo huan apóstoles. Lā' cāpūtle'keni'lh a'nchī Saulo ixlaktzī'nī't nac tej huan Māpa'ksīni' Jesucristo a'ntīn tā'chihuīna'lh. Lā' cāpūtle'keni'lh a'nchī Saulo ixchihuīna'nī't nac Damasco por ixlīmāpa'ksīn Jesús, lā' tū' ixlacapuhuan. ");
INSERT INTO tooNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Lā' Saulo ixcātā'latlā'huan nac Jerusalén. ");
INSERT INTO tooNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lā' ixchihuīna'n por ixlīmāpa'ksīn Dios lā' tū' ixlacapuhuan. Lā' ixcātā'lāhuani huan israelitas a'ntī ixtachihuīna'n griego. Lā' ixtamaknīcu'tun Saulo. ");
INSERT INTO tooNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lā' a'xni'ca' huan tā'timīn taca'tzīlh huā'mā', talē'lh Saulo nac Cesarea lā' tamacā'lh para nac Tarso. ");
INSERT INTO tooNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Lā' cā'cacsuatza' ixtahui'lāna' a'ntī ixtatakēxtimī na ixlīhuāk ixlēka'tla' Judea lā' Galilea lā' Samaria. Lā' ā'chulā' ixtakalhlaka'ī'. Lā' ixtajicua'ni'tēlha Māpa'ksīni'. Lā' huan Espíritu Santo ixcāmāko'xamaka'tlī. Lā' ixtalhūhua'ntēlha. ");
INSERT INTO tooNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Lā' Pedro lakaxtim ixlatlā'huan lā' cālakmilh a'ntī ixtakalhlaka'ī' xalanī'n nac Lida. ");
INSERT INTO tooNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","A'ntza' pāxtokli kalhatin chi'xcu' a'ntī ixtacuīni' Eneas. Xla' ixmā' na ī'xti'cat lakatzeyan cā'ta. Ixchēkēnī'n ixtalū'ntū'lanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Lā' Pedro huanilh: ―Jesucristo mātzeyīyāni'. Catā'kaqui' lā' camā'kaqui' mixti'cat. Lā' chu tuncan tā'kaquī'lh Eneas. ");
INSERT INTO tooNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lā' ixlīhuākca'n a'ntī ixtahui'lāna' nac Lida lā' Sarón talaktzī'lh que ixtzeyanī'ttza'. Lā' xlaca'n tatzuculh tastālani' huan Māpa'ksīni' Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ixuī' nac Jope kalhatin puscāt a'ntī ixkalhlaka'ī'. Lā' ixtacuīni' Tabita lā' nā Dorcas ixtacuīni' griego. Huā'mā' puscāt ixtlahua lhūhua' catūhuā lej tzey. Lā' ixmāstā' lhūhua' limosna. ");
INSERT INTO tooNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lā' huā'mā'na chi'chini' xla' ī'tzaca'lh lā' nīlh. Lā' ixmāpaxīcanī'ttza' lā' ixcāxmāpī'canī'ttza' nac lakatin cuarto tālhmā'n. ");
INSERT INTO tooNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lā' huan tā'timīn nac Jope takaxmatli que Pedro ixuī' nac Lida, como pajtzu ixuanī't. Lā' cālakmacā'nca kalhatu' chi'xcuhuī'n. Lā' xlaca'n tahuanilh Pedro: ―Capit lacapalh hasta lhā icui'lāna'uj. ");
INSERT INTO tooNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Lā' tuncan Pedro cātā'a'lh. Lā' a'xni'ca' xla' cālakchā'lh, lā' lē'nca nac cuarto tālhmā'n. Lā' ixlīhuākca'n huan lakapūtnu' talītakēxtimīlh a'nlhā ixmāpī'canī't Dorcas lā' tacalhualh. Lā' tamāsu'ni'lh huan takēnu' lā' huan lu'xu' a'ntū ixtlahua Dorcas a'xni'ca' lakahuancus ixlahuī'. ");
INSERT INTO tooNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pero Pedro cāmāxtulh ixlīhuākca'n lā' tatzokostalh lā' orarlīlh. Lā' laktalakspi'tli huan sputni' lā' huanilh: ―Tabita, catā'kaqui'. Lā' talakapāke'lh lā' laktzī'lh Pedro lā' tā'kxpāquī'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Lā' Pedro makachi'palh lā' mā'kaquī'lh. Lā' a'xni'ca' Pedro cāta'sani'lh huan a'ntī ixtakalhlaka'ī' lā' huan lakapūtnu' lā' cāmāsu'ni'lh Dorcas xalakahuan. ");
INSERT INTO tooNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Huā'mā' ca'tzīkō'ca na ixlīhuāk Jope. Lā' lhūhua' takalhlaka'ī'lh Māpa'ksīni' Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Lā' Pedro tachokolh lātma'j nac Jope na ixchic kalhatin chi'xcu' ixtacuīni' Simón a'ntī māmasījūnu'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ixuī' nac Cesarea kalhatin chi'xcu' ixtacuīni' Cornelio. Xla' capitán ixuanī't. Lā' huan compañía a'ntū ixmāpa'ksī ixtacuīni' Italiana. ");
INSERT INTO tooNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio lej ixa'cnīni'ni' lā' ixtajicua'ni' Dios, lā' nā chuntza' ixlīhuāk xala' na ixchic. Lej ixmaxquī' limosna huan tachi'xcuhuī't lā' pō'ktu ixorarlīni' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Lakatin chi'chini' hua'chi maktu'tun kōtanū, Cornelio lakachuyalh. Lā' xa'nca laktzī'lh kalhatin ángel a'ntī Dios macamilh. Lā' huan ángel tanūlh lā' huanilh: ―¡Cornelio! ");
INSERT INTO tooNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Lā' Cornelio lakalaktzī'lh lā' jicua'lh lā' kalhasqui'nīlh: ―¿Tuchū, Māpa'ksīni'? Lā' huan ángel huanilh: ―Dios pāstacmā'chāni' a'nchīn tlahua'ya' mi'oración lā' a'nchī māstā'ya' limosna. ");
INSERT INTO tooNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Lā' chuhua'j cacāma'capi chi'xcuhuī'n nac Jope lā' camātayī'ni' Simón a'ntī ka'lhī ixlītāpātu' ixtacuīni' Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Xla' tētachokonī't na ixchic Simón huan māmasījūnu' a'ntī ka'lhī ixchic na ixquilhtūn mar. U'tza' nahuaniyāni' a'ntū natla'hua'ya'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lā' a'xni'ca' huanikō'lh huan ángel lā' chu tuncan a'lh. Lā' Cornelio cāta'sani'lh kalhatu' ixtasācua'nī'n lā' kalhatin tropa a'ntī ixta'a'cnīni'ni' Dios lā' a'ntī ixtascuja na ixchic. ");
INSERT INTO tooNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Lā' a'xni'ca' ixcāpūtle'keni'kō'nī'ttza' a'ntū ixuaninī't huan ángel, cāmacā'lh nac Jope. ");
INSERT INTO tooNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lā' ixlīlakalī xlaca'n ixtatlā'huamā'na lā' ixtatapajtzūtēlha para huan nac xcānsipej. Lā' hua'chi tastu'nūta Pedro tō'ca'lh huan na ixlītanca'cstu' chic para na'orarlī. ");
INSERT INTO tooNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Lā' lej tzi'ncstāyalh lā' ixuā'yancu'tun. Lā' līhuan ixcāxtlahuamā'ca huan līhua't, Pedro lakachuyalh. ");
INSERT INTO tooNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lā' laktzī'lh huan a'kapūn laquī'yā lā' hua'chi lakatin ka'tla' sábana chī'canī't ixa'katzā'stūtā'ti'. Lā' yujli na ixlacapūn. ");
INSERT INTO tooNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Huā'mā' a'ntza' ixtatojōmā'na ixlīhuāk animalhna' a'ntū makakantā'ti' lā' lūhua' lā' spunnu'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lā' kaxmatli a'nchī tā'chihuīna'nca lā' huanica: ―Catā'kaqui', Pedro, cama'kni' lā' cahua't. ");
INSERT INTO tooNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Lā' Pedro hualh: ―Tū', Māpa'ksīni'; porque tū' maktin icua'nī't a'ntūn tū' līmakuan hua'can lā' a'ntū ko'hua'jua'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Lā' chu kaxmatpā ixlīmaktu' tā'chihuīna'nca lā' huanica: ―Tū' cahua'nti ko'hua'jua' a'ntū Dios huan que xacanī't. ");
INSERT INTO tooNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Huā'mā' pātle'kelh maktu'tun lā' huan sábana lē'nchokopalaca nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Lā' Pedro lej ixpāstacna'huī' porque tū' ixca'tzī a'ntū ixuanicu'tun huan a'ntū mālakachuyīlh. Lā' huan chi'xcuhuī'n, a'ntī ixcāmacaminī't Cornelio, takalhasqui'nīlh lhachū ixchic Simón. Lā' tuncan tachilh na ixlacapūn mākalhcha. ");
INSERT INTO tooNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Lā' tata'sani'lh lā' takalhasqui'nīni'lh lā' tahualh palh tū' lahuī' kalhatin chi'xcu' a'ntī ixtacuīni' Simón a'ntī ixka'lhī ixlītāpātu' ixtacuīni' Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Lā' a'xni'ca' Pedro ixpāstacna'huī' a'nchī lakachuyanī't, huan Espíritu Santo huanilh: ―Kalhatu'tun chi'xcuhuī'n taputzayāni'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Catā'kaqui' lā' cayujti lā' cacātā'pi xlaca'n. Lā' tū' napuhua'na' catūhuā porque quit iccāmacaminī't. ");
INSERT INTO tooNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Lā' Pedro cālakyujli huan chi'xcuhuī'n lā' hualh: ―Quit a'ntī putza'yā'tit hui'xina'n. ¿Tuchū lakta'nī'ta'ntit? ");
INSERT INTO tooNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Lā' xlaca'n takalhtīlh: ―Ixpālacata huan capitán Cornelio. Xla' lej tzeyā chi'xcu' lā' jicua'ni' Dios. Lā' ixlīhuākca'n israelitas talaktzī'n por tzeyā chi'xcu'. Kalhatin ángel a'ntī lej tzey huanilh Cornelio que namāta'satīnīni'nāni' lā' xla' nakaxmata a'ntū hui'x nahua'na'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Lā' Pedro cāmānūlh na ixchic lā' cāhuanilh que catatachokolh huā'mā' tzī'sa. Lā' ixlīlakalī cātā'a'lh. Lā' nā cātā'a'lh makapitzīn tā'timīn xalanī'n nac Jope. ");
INSERT INTO tooNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lā' ixlīlakalī huampala tachā'lh nac Cesarea. Lā' Cornelio ixcāka'lhīmā' lā' ixcāmākēstokkō'nī't ixtalakapasnī'n lā' ixamigos a'ntī más ixcālakapasa. ");
INSERT INTO tooNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Lā' a'xni'ca' Pedro ixtanūmā', Cornelio lakchilh. Lā' chu tuncan tatzokostani'lh lā' taquilhpūtani'lh. ");
INSERT INTO tooNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Lā' Pedro mā'kaquī'lh lā' hualh: ―Catā'kaqui'. Nā quit nā chu xmān chi'xcu'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Lā' a'xni'ca' Pedro ixtanūtēlha lā' ixtā'chihuīna'ntēlha lā' cākaksli ixtalhūhuā't a'ntī ixtatakēstoknī't. ");
INSERT INTO tooNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Lā' Pedro cāhuanilh: ―Hui'xina'n ca'tzīyā'tit que kalhatin israelita tūla catitā'takēxtimīlh con a'ntīn tū' israelita. Lā' tūla catitanūlh na ixchic. Chuntza' tatzo'kni' na ixleyca'n israelitas. Pero Dios quimāsu'ni'nī't que tūla ictihualh que ā'chā'tin chi'xcu' ko'hua'jua' lā' ū'tza' xmān catīhuā. ");
INSERT INTO tooNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","U'tza' iclīmilh a'xni'ca' quimātayīni'nca lā' tū' icpuhualh catūhuā. Lā' iccākalhasqui'nīyāni' ¿tuchū ixpālacata quilālīmātayīni'uj hui'xina'n? ");
INSERT INTO tooNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Lā' tuncan Cornelio hualh: ―Tā'ti'majatza' quit xa'ictascajamā' lā' tū' icuā'yalh. Lā' hua'chi maktu'tun kōtanū quit xa'icorarlīmā' na quinchic. Lā' chā'tin chi'xcu' tāyalh na quilacapūn lā' ixka'lhī ixlu'xu' lej slamama. ");
INSERT INTO tooNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Lā' quihuanilh: “Cornelio, Dios kaxmatnī't mi'oración lā' pāstacmā' a'nchī māstā'ya' limosna. ");
INSERT INTO tooNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Cacāmacapi chi'xcuhuī'n nac Jope lā' camātayī'ni' Simón a'ntī ka'lhī ixlītāpātu' ixtacuīni' Pedro. Xla' tētachokomā' na ixchic Simón huan māmasījūnu' na ixquilhtūn mar. Xla' namin lā' natā'chihuīna'nāni'”, quihuanica. ");
INSERT INTO tooNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lā' ū'tza' quit iclīmātayīni'ni' tuncan. Lā' hui'x quintlahua'ni' talakalhu'mān quila'kta'. Pues chuhua'j quilīhuākca'n icui'lāna'uj huā'tzā' na ixlacapūn Dios. Lā' ickaxmatcu'tunāuj ixlīhuāk a'ntū Dios māpa'ksīnī'ta'ni' nahua'na' ―hualh Cornelio. ");
INSERT INTO tooNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Lā' Pedro tzuculh chihuīna'n lā' hualh: ―Ixlīstu'ncua' quit icmāchekxī que Dios puhuan que chu a'cxtimni' ixlīhuākca'n chi'xcuhuī'n. ");
INSERT INTO tooNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Lā' xalanī'n chu calhāhuā xcānsipej, a'ntīn tajicua'ni' Dios lā' tatlahua a'ntūn tzey ū'tunu'n tamāpāxuhuī' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios cāmacā'ni'lh huan israelitas ixtachihuīn. Lā' cāmāsu'ni'lh que tzē natala ixamigos Dios por ixpālacata Jesucristo a'ntī cāmāpa'ksī ixlīhuākca'n. ");
INSERT INTO tooNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Hui'xina'n ca'tzīyā'tit a'nchī māca'tzīnīni'nca huan xatzey tachihuīn pū'la nac Galilea lā' ā'calīstān na ixlīhuāk Judea a'xni'ca'tza' Juan ixmāsu'yunī'ttza' lā' ixmā'kpaxīnī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Dios maxquī'lh Jesús, xala' nac Nazaret, ixlīmāpa'ksīn Espíritu Santo. Lā' Jesús ixtlahuatlā'huan a'ntū lej lacuan lā' ixcāmātzeyītlā'huan ixlīhuāk a'ntī ixtapātīni'n por ixlīmāpa'ksīn ko'ti'ti'. Huā'mā' tzēn tlahualh Jesús porque Dios ixmaktāyamā'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Lā' quina'n icmālacstū'ncāuj ixlīhuāk a'ntūn tlahualh Jesús na ī'xcānsipejca'n israelitas lā' nac Jerusalén. U'tza' a'ntī xtokohua'ca'ca nac cruz lā' chuntza' maknīca. ");
INSERT INTO tooNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Lā' Dios mālakahuanīchokolh ixlīlakatu'tun chi'chini' lā' Dios lej xa'nca quincāmāsu'ni'ni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tū' cāmāsu'ni'lh ixlīhuāk tachi'xcuhuī't. Dios quincāmāsu'ni'ni' Jesús xmān quina'n a'ntī quincālacsacnī'ta'ni' para na'icmālacstū'ncāuj ixtachihuīn. Quina'n ictā'huā'yauj Jesús lā' ictā'ko'tnūj a'xni'ca' ixlakahuanchokonī'ttza'. ");
INSERT INTO tooNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Lā' Dios quincāhuanini' que na'iccāmāsu'ni'yāuj tachi'xcuhuī't lā' na'icuanāuj que Jesús ū'tza' a'ntī Dios hui'līlh ixlīJuezca'n xalakahuan lā' xanīn. ");
INSERT INTO tooNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Lā' ixlīhuākca'n ixa'cta'sana'nī'n Dios, xalanī'n makān, tamālacstū'ncli que ixlīhuāk a'ntīn talīpāhuan Jesús, xlaca'n nacāmāsputūnu'ni'can ixtalaclē'i'ca'n por ixpālacata Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Lā' Pedro ixchihuīna'huī'cus lā' huan Espíritu Santo cālakyujchi ixlīhuākca'n a'ntī ixtakaxmatni'mā'na Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Lā' lej talē'cnīni'lh huan israelitas a'ntī ixtakalhlaka'ī' lā' ixcātā'minī't Pedro. Talē'cnīlh porque huan lē'ksajna' a'ntū Espíritu Santo, nā ixcāmaxquī'mā'ca huan tīn tū' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Cālē'cnīca porque ixcākaxmatcanī't a'nchī ixtachihuīna'n ā'tāpātin tachihuīn lā' nā tachihuīna'mpā ixlēka'tla' Dios. ");
INSERT INTO tooNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Lā' Pedro cāhuanipā: ―¿Chā a'nan catīhuā a'ntī nacāmāmakchuyī nata'a'kpaxa huā' tamā'na? Xlaca'n tamaklhtīni'n chuntza' hua'chi quina'n huan lē'ksajna' a'ntū huan Espíritu Santo. ");
INSERT INTO tooNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Lā' Pedro cāhuanilh que cata'a'kpaxli porque tatapa'ksīlh con Jesucristo. Lā' squi'ni'ca Pedro que catachokolh lātma'j. ");
INSERT INTO tooNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Huan apóstoles lā' tā'timīn a'ntī ixtahui'lāna' nac Judea cāmāca'tzīnīca que ixtakalhlaka'ī' ixtachihuīn Dios nā xlaca'n a'ntīn tū' israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lā' a'xni'ca' Pedro chā'lh nac Jerusalén, tatā'lāhuanilh huan israelitas a'ntī ixtakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Takalhasqui'nīlh Pedro: ―¿A'chī' maktanūnī'ta' a'nlhā tahui'lāna' chi'xcuhuī'n a'ntīn tū' israelitas? Lā' ¿a'chī' cātā'huā'ya'nī'ta'? ");
INSERT INTO tooNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Lā' Pedro tzuculh chihuīna'n lā' cāhuanikō'lh xa'nca lā' hualh: ");
INSERT INTO tooNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Xa'icui'lācha' quit nac xcānsipej Jope lā' xa'icorarlīmā'. Lā' iclakachuyalh. Lā' iclaktzī'lh hua'chi ka'tla' sábana a'ntū yujchi de nac a'kapūn. Chī'canī't ixa'katzā'stūtā'ti' lā' quilakchilh. ");
INSERT INTO tooNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Lā' lej xa'nca iclaktzī'lh. Lā' iclaktzī'lh huan animalhna' a'ntū makakantā'ti' lā' animalhna' a'ntū tahua'nan lā' lūhua' lā' spunnu'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Lā' ickaxmatli lakatin tachihuīn a'ntūn quihuanilh: “Pedro, catā'kaqui' lā' cama'kni' lā' cahua't”. ");
INSERT INTO tooNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Lā' icuanilh: “Tū', Māpa'ksīni'. Tū' maktin icua'nī't a'ntū xmān catūhuā lā' a'ntūn ko'hua'jua'”. ");
INSERT INTO tooNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Lā' huan tachihuīn quinkalhtīpā ixlīmaktu' de nac a'kapūn. Lā' quihuanilh: “Tū' cahua'nti que ko'hua'jua' a'ntū Dios huan que xacanī't”. ");
INSERT INTO tooNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Huā'mā' pātle'kelh maktu'tun lā' tēpalacancha' tālhmā'n ixlīhuāk nac a'kapūn. ");
INSERT INTO tooNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Lā' chu līlacapalh tachilh nac chic a'nlhā xa'iclahui'lāna'uj kalhatu'tun chi'xcuhuī'n a'ntī ixquilakmacamincanī't de nac Cesarea. ");
INSERT INTO tooNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lā' Espíritu Santo quihuanilh: “Cacātā'pi ū'tunu'n lā' tū' capāstacti catūhuā”. Lā' quintatā'a'lh huā' kalhachāxan tā'timīn. Lā' ictanūj na ixchic Cornelio. ");
INSERT INTO tooNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lā' xla' quincāhuanini' a'nchī laktzī'lh na ixchic kalhatin ángel a'ntī tasu'yuni'lh lā' huanilh: “Cacāmacapi chi'xcuhuī'n nac Jope lā' calīminca Simón a'ntī ka'lhī ixlītāpātu' ixtacuīni' Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Xla' nahuaniyāni' a'nchīn tzē napūtaxtuya' hui'x lā' ixlīhuāk xala' na minchic”, huanilh huan ángel. ");
INSERT INTO tooNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Lā' Pedro cāhuanipā: ―Lā' a'xni'ca' ictzuculh icchihuīna'n, huan Espíritu Santo cālakmilh ū'tunu'n chuntza' hua'chi quincālakmini' pū'la. ");
INSERT INTO tooNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lā' quit icpāstacli a'nchī hualh Māpa'ksīni' Jesús: “Juan ixlīmā'kpaxīni'n xcān pero xtunc a'nchī na'a'kpaxā'tit. Hui'xina'n namaklhtīni'nā'tit Espíritu Santo”. ");
INSERT INTO tooNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Dios cāmaxquī'lh xlaca'n huā'mā' lē'ksajna' nā chuntza' hua'chi quincāmaxquī'ni' quina'n a'ntī kalhlaka'ī'nī'ta'uj Māpa'ksīni' Jesucristo. Lā' ¿chu quit tzē xa'icmāmakchuyīlh Dios? ―hualh Pedro. ");
INSERT INTO tooNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lā a'xni'ca' takaxmatli huā'mā', taquilhca'cslalh. Lā' tuncan tatzuculh tachihuīna'n a'nchī ixlēka'tla' Dios lā' tahualh: ―Dios lacasqui'n nataxtāpalī ixtapāstacna'ca'n nā xlaca'n a'ntīn tū' israelitas lā' nā chuntza' natalatahui'la para pō'ktu. ");
INSERT INTO tooNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lā' a'xni'ca' maknīca Esteban, lā tzucuca cāmacaputzacan a'ntī ixtakalhlaka'ī'. Lā' xlaca'n tatzā'lalh lā' ixta'a'kahuankō'nī't. Lā' ixtatachokoyācha' nac Fenicia lā' nac Chipre lā' nac Antioquía. Lā' cāhuanica huan xatzey tachihuīn xmān huan israelitas. ");
INSERT INTO tooNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero makapitzīn de xlaca'n xalanī'n nac Chipre lā' nac Cirene lā' xlaca'n tachā'lh nac Antioquía. Lā' cātā'chihuīna'nca a'ntīn tū' israelitas. Lā' cāmāsu'ni'ca huan xatzey tachihuīn ixpālacata Māpa'ksīni' Jesús. ");
INSERT INTO tooNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Lā' huan Māpa'ksīni' cāmaxquī'lh līmāpa'ksīn lā' chuntza' lej lhūhua' takalhlaka'ī'lh lā' tastālani'lh Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Lā' cāmāca'tzīnīca a'ntī ixtakalhlaka'ī' xalanī'n nac Jerusalén a'ntū ixpātle'kemā' nac Antioquía. Lā' macā'nca Bernabé a'ntza'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lā' a'xni'ca' xla' chā'lh lā' laktzī'lh a'nchī Dios ixcāsicua'lanālīnī't, lā' lej pāxuhualh xla'. Lā' Bernabé cāmaxquī'lh tapāstacna' lā' cāhuanilh ixlīhuākca'n: ―Calīhui'lī'tit stālani'yā'titcus Māpa'ksīni'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Lā' Bernabé tzeyā chi'xcu' ixuanī't lā' ixa'clhcunuc ixlītzuma Espíritu Santo lā' lej ixkalhlaka'ī'. Lā' lhūhua' tachi'xcuhuī't tatzuculh tatapa'ksī con Māpa'ksīni' Jesucristo. ");
INSERT INTO tooNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lā' ā'calīstān Bernabé a'lh putza Saulo nac Tarso. ");
INSERT INTO tooNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lā' a'xni'ca' kaksli, līmilh nac Antioquía. Lā' ixlīhuāk lakatin cā'ta Bernabé lā' Saulo ixtatā'takēstoka a'ntī ixtakalhlaka'ī'. Lā' ixcāmāsu'ni'can lhūhua' tachi'xcuhuī't. Lā' a'ntza' nac Antioquía tzucuca pū'la cāmāpācuhuīcan cristianos xlaca'n a'ntī ixtakalhlaka'ī'. ");
INSERT INTO tooNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Huan tamā'na chi'chini' tataxtulh de nac Jerusalén makapitzīn ixa'cta'sana'nī'n Dios. Lā' tachā'lh nac Antioquía. ");
INSERT INTO tooNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Lā' kalhatin de xlaca'n, a'ntī ixuanican Agabo, tā'kaquī'lh na ixlacapūnca'n lā' cāmāca'tzīnīlh. Lā' Espíritu Santo maktāyalh. Lā' hualh que na'a'nan lakachu lakatin ka'tla' tatzi'ncsta. Lā' chuntza' pātle'kelh a'xni'ca' Claudio ixmāpa'ksīni'n. ");
INSERT