﻿USE sofia;
DROP TABLE IF EXISTS sofia.ton_vpl;
CREATE TABLE ton_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ton_vpl WRITE;
INSERT INTO ton_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Naʻe fakatupu ʻe he ʻOtua ʻi he kamataʻanga ʻae langi mo māmani. ");
INSERT INTO ton_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pea naʻe fuofuonoa ʻa māmani mo lala; pea naʻe fakapoʻuli ʻae funga ʻoe loloto. Pea naʻe ʻōʻōfaki ʻae Laumālie ʻoe ʻOtua ki he fukahi vai. ");
INSERT INTO ton_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Pea folofola ʻae ʻOtua, “Ke maama pea naʻe maama ai.” ");
INSERT INTO ton_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Pea ʻafio ʻe he ʻOtua ki he maama, kuo lelei ia: pea naʻe vaheʻi ʻe he ʻOtua ʻae maama mei he poʻuli. ");
INSERT INTO ton_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Pea naʻe ui ʻe he ʻOtua ʻae maama ko e “ʻAho,” pea ne ui ʻae poʻuli ko e “Pō.” Pea ko e efiafi mo e pongipongi ko e ʻuluaki ʻaho ia. ");
INSERT INTO ton_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","¶ Pea naʻe folofola ʻae ʻOtua, “Ke ai ʻae ʻatā ʻi he vahaʻa ʻoe ngaahi vai, ke vaheʻi ʻae ngaahi vai mei he ngaahi vai.” ");
INSERT INTO ton_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Pea naʻe ngaohi ʻe he ʻOtua, ʻae ʻatā, pea vaheʻi ʻae ngaahi vai naʻe ʻi he lalo ʻatā, mei he ngaahi vai naʻe ʻi ʻolunga ʻi he ʻatā: pea naʻe hoko ia. ");
INSERT INTO ton_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pea naʻe ui ʻae ʻatā ʻe he ʻOtua ko e “Langi.” Pea ko e efiafi mo e pongipongi ko hono ʻaho ua ia. ");
INSERT INTO ton_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","¶ Pea naʻe folofola ʻae ʻOtua, “Ke fakataha ʻae ngaahi vai ʻi he lalo langi ki he potu pe taha, pea ke hā mai ʻae mōmoa: pea naʻe hoko ia.” ");
INSERT INTO ton_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pea naʻe ui ʻe he ʻOtua ʻae mōmoa ko e Fonua; pea ko e ngaahi vai naʻe tānaki fakataha, naʻa ne ui ko e Tahi; pea naʻe ʻafio ʻe he ʻOtua kuo lelei. ");
INSERT INTO ton_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Pea naʻe folofola ʻae ʻOtua, “Ke tupu ʻae mohuku mei he kelekele, mo e ʻakau iiki ʻoku ai hono tenga, mo e ʻakau ʻoku fua, pea ʻi ai hono tenga, ʻo tatau mo hono faʻahinga:” pea naʻe hoko ia. ");
INSERT INTO ton_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Pea naʻe tupu mei he kelekele ʻae mohuku, mo e ʻakau iiki naʻe tupu ai ʻae tenga ʻo hono faʻahinga, mo e ʻakau ʻoku fua, ʻaia naʻe ʻi ai ʻae tenga ʻo hono faʻahinga: pea naʻe ʻafio ʻe he ʻOtua kuo lelei. ");
INSERT INTO ton_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Pea ko e efiafi mo e pongipongi ko hono ʻaho tolu ia. ");
INSERT INTO ton_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","¶ Pea naʻe folofola ʻae ʻOtua, “Ke ai ʻae ngaahi maama ʻi he ʻatā ʻoe langi, ke vaheʻi ʻae ʻaho mei he pō; pea ke fakaʻilonga ʻaki ia ʻae ngaahi faʻahitaʻu, mo e ngaahi ʻaho, mo e ngaahi taʻu: ");
INSERT INTO ton_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","pea ke hoko ia ko e ngaahi maama ʻi he ʻatā ʻoe langi ke fakamaama ki māmani:” pea naʻe hoko ia. ");
INSERT INTO ton_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Pea naʻe ngaohi ʻe he ʻOtua ʻae maama lahi ʻe ua; ko e maama lahi hake ke pule ki he ʻaho, mo e maama siʻi ke pule ki he pō: pea mo e ngaahi fetuʻu foki. ");
INSERT INTO ton_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Pea naʻe tuku ia ʻe he ʻOtua ʻi he ʻatā ʻoe langi, ke fakamaama ki māmani, ");
INSERT INTO ton_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Pea ke pule ki he ʻaho mo e pō, pea ke vaheʻi ʻae maama mei he poʻuli: pea naʻe ʻafio ʻe he ʻOtua kuo lelei. ");
INSERT INTO ton_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Pea ko e efiafi mo e pongipongi ko hono ʻaho fā ia. ");
INSERT INTO ton_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","¶ Pea naʻe folofola ʻae ʻOtua, “Ke tupu ʻo lahi ʻaupito mei he ngaahi vai ʻae meʻa moʻui ʻoku totolo, mo e fanga manupuna ke puna ʻi he funga ʻo māmani, ʻi he ʻatā ʻoe langi.” ");
INSERT INTO ton_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Pea naʻe ngaohi ʻe he ʻOtua ʻae ngaahi tofuaʻa lalahi, mo e meʻa moʻui kotoa pē naʻe ngaolo, ʻaia ne tupu lahi ʻaupito mei he ngaahi vai ʻi honau faʻahinga, mo e fanga manupuna kotoa pē ʻi honau faʻahinga pea naʻe ʻafio ʻe he ʻOtua kuo lelei. ");
INSERT INTO ton_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pea naʻe tāpuakiʻi ʻakinautolu ʻe he ʻOtua, ʻo pehē, “Mou fanafanau, mo tupu ke lahi, pea fakafonu ʻae ngaahi vai ʻoe tahi, pea ke tupu ke lahi ʻae fanga manupuna ʻi māmani. ");
INSERT INTO ton_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Pea ko e efiafi mo e pongipongi ko hono ʻaho nima ia. ");
INSERT INTO ton_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","¶ Pea naʻe folofola ʻae ʻOtua, “Ke tupu mei he fonua ʻae meʻa moʻui ʻi hono faʻahinga, ʻae fanga manu, mo e meʻa totolo, mo e manu ʻoe vao ʻi hono faʻahinga:” pea naʻe hoko ia. ");
INSERT INTO ton_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Pea naʻe ngaohi ʻe he ʻOtua ʻae manu ʻoe vao ʻi hono faʻahinga, mo e fanga manu lalahi ʻi honau faʻahinga, mo e meʻa kotoa pē ʻoku totolo ʻi he funga fonua ʻi hono faʻahinga: pea naʻe ʻafio ʻe he ʻOtua kuo lelei ia. ");
INSERT INTO ton_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","¶ Pea naʻe folofola ʻae ʻOtua, “Ke tau ngaohi ʻae tangata ʻi hotau tatau, mo e tau anga: pea kenau pule ki he ika ʻoe tahi, mo e manupuna ʻoe ʻatā, mo e fanga manu, mo māmani kotoa pē, mo e meʻa totolo kotoa pē ʻoku ngaue ʻi he kelekele.” ");
INSERT INTO ton_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ko ia naʻe ngaohi ʻae tangata ʻe he ʻOtua ʻi hono tatau, naʻa ne ngaohi ia ʻi he tatau ʻoe ʻOtua; naʻa ne ngaohi ʻakinaua ko e tangata mo e fefine. ");
INSERT INTO ton_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Pea naʻe tāpuakiʻi ʻakinaua ʻe he ʻOtua, pea folofola ʻae ʻOtua kiate kinaua, “Fanafanau, mo fakatokolahi, mo fakakakai ʻa māmani, pea pule ki ai: pea pule ki he ika ʻoe tahi, mo e fanga manupuna ʻoe ʻatā, mo e meʻa moʻui kotoa pē ʻoku ngaue ʻi he funga ʻo māmani.” ");
INSERT INTO ton_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","¶ Pea naʻe folofola ʻae ʻOtua, “Vakai, kuo u foaki kiate kimoua ʻae ʻakau iiki kotoa pē ʻoku ʻi ai hono tenga, ʻaia ʻoku ʻi he funga ʻoe fonua kotoa, mo e ʻakau kotoa pē ʻoku fua ʻaia ʻoku ʻi ai hono tenga; ko ia ia ke mo kai. ");
INSERT INTO ton_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Pea ko e fanga manu kotoa pē ʻi he fonua, mo e fanga manupuna kotoa pē ʻoe ʻatā, mo e meʻa moʻui kotoa pē ʻoku totolo ʻi he fonua, ʻe kai ʻi he ʻakaulaumata kotoa pē:” pea naʻe hoko ia. ");
INSERT INTO ton_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Pea naʻe ʻafio ʻe he ʻOtua ki he meʻa kotoa pē naʻa ne ngaohi, pea vakai, naʻe lelei ʻaupito. Pea ko e efiafi mo e pongipongi ko hono ʻaho ono ia. ");
INSERT INTO ton_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Naʻe pehē ʻa hono ngaohi ʻo ʻosi ʻae langi mo e fonua, mo hona nāunau kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Pea ʻi hono fitu ʻoe ʻaho kuo fakaʻosi ʻe he ʻOtua ʻa ʻene ngāue ʻaia naʻa ne fai; pea naʻe tutuku ia ʻi hono fitu ʻoe ʻaho, mei heʻene ngāue kotoa pē ʻaia naʻa ne fai. ");
INSERT INTO ton_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Pea naʻe tāpuaki ʻe he ʻOtua ʻa hono fitu ʻoe ʻaho, mo ne fakatapui ia: koeʻuhi ko ia ia naʻa ne tutuku ai mei heʻene ngāue kotoa pē, ʻaia naʻe fakatupu mo ngaohi ʻe he ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","¶ Ko e tala fakahohoko eni ki he ngaohi ʻoe langi mo māmani, ʻi he ʻaho ʻaia naʻe fakatupu ai ʻe Sihova ko e ʻOtua, ʻa māmani pea mo e langi, ");
INSERT INTO ton_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Mo e ʻakau kotoa pē ʻoe fonua ʻi he teʻeki ke tuʻu ia ʻi he kelekele, mo e ʻakau iiki kotoa pē ʻoe fonua, ʻi he teʻeki ai ke tupu: he naʻe teʻeki ke tuku ʻe he ʻOtua ha ʻuha ki he kelekele, pea naʻe ʻikai ha tangata ke ngoueʻi ʻae kelekele. ");
INSERT INTO ton_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ka naʻe ʻalu hake ʻae vaivao mei he fonua, ke fakaviviku ʻae funga kelekele kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Pea naʻe ngaohi ʻe Sihova ko e ʻOtua ʻae tangata mei he efu ʻoe kelekele, pea ne mānava ki hono avaʻi ihu ʻae mānava ʻoe moʻui; pea hoko ʻae tangata ko e laumālie moʻui. ");
INSERT INTO ton_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","¶ Pea naʻe tō ʻae ngoue ʻe Sihova ko e ʻOtua ki he potu hahake ʻi ʻIteni; pea ne tuku ki ai ʻae tangata ʻaia naʻa ne ngaohi. ");
INSERT INTO ton_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Pea naʻe fakatupu ʻe Sihova ko e ʻOtua mei he kelekele ʻae ʻakau kotoa pē ʻoku matamatalelei, pea lelei ki he kai; mo e ʻakau ʻoe moʻui foki ʻi he loto ngoue, pea mo e ʻakau ʻoe ʻilo ʻoe lelei mo e kovi. ");
INSERT INTO ton_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Pea naʻe ʻalu atu ʻae vaitafe ʻi ʻIteni ke fakaviviku ʻae ngoue; pea ne mavahevahe ia mei ai ʻi he mangaʻivai ʻe fā. ");
INSERT INTO ton_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ko e hingoa ʻoe ʻuluaki ko Pisoni: ko ia ia ʻoku takatakai ʻae fonua kotoa ko Havila, ʻaia ʻoku ʻi ai ʻae koula; ");
INSERT INTO ton_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Pea ʻoku lelei ʻae koula ʻoe fonua ko ia pea ʻoku ʻi ai ʻae mataʻitofe, mo e maka ko e onike. ");
INSERT INTO ton_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Pea ko e hingoa ʻo hono ua ʻoe vaitafe ko Kihoni: ko ia ia ʻoku takatakai ʻae fonua kotoa ko Kusi. ");
INSERT INTO ton_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Pea ko e hingoa ʻo hono tolu ʻoe vaitafe ko Hitikeli: ko ia ia ʻoku tafe atu ki he hahake ʻo ʻAsilia. Pea ko hono fā ʻoe vaitafe ko ʻIufaletesi. ");
INSERT INTO ton_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Pea naʻe ʻave ʻe Sihova ko e ʻOtua ʻae tangata ʻone tuku ia ki he ngoue ko ʻIteni, ke tauhi mo leʻo ki ai. ");
INSERT INTO ton_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Pea naʻe fekau ʻe Sihova ko e ʻOtua ki he tangata, ʻo pehē, “ʻE ngofua ʻa hoʻo kai mei he ʻakau kotoa pē ʻoe ngoue, ");
INSERT INTO ton_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ka ko e ʻakau ʻoe ʻilo ʻoe lelei mo e kovi, ʻe ʻikai te ke kai mei ai: he ko e ʻaho ko ia te ke kai ai, ko e moʻoni te ke mate.” ");
INSERT INTO ton_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","¶ Pea naʻe folofola ʻe Sihova ko e ʻOtua, “ʻOku ʻikai lelei ke tokotaha pe ʻae tangata: te u ngaohi kiate ia ha tokoni ʻoku taau mo ia.” ");
INSERT INTO ton_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Pea naʻe ngaohi ʻe Sihova ko e ʻOtua, mei he kelekele ʻae fanga manu kotoa pē ʻoe fonua, mo e manu kotoa pē ʻoe ʻatā; pea ne ʻomi ia kia ʻAtama, ke vakai pe ko e hā te ne ui ʻakinautolu: pea ʻilonga ʻae hingoa naʻe ai ʻe ʻAtama ki he meʻa moʻui kotoa pē, ko hono hingoa ia. ");
INSERT INTO ton_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Pea naʻe fakahingoa ʻe ʻAtama ʻae fanga manu lalahi kotoa pē, mo e fanga manupuna ʻoe ʻatā, mo e fanga manu kotoa pē ʻoe vao; ka naʻe ʻikai ke ʻilo kia ʻAtama ha tokoni naʻe taau mo ia. ");
INSERT INTO ton_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Pea naʻe tuku ʻe Sihova ko e ʻOtua, ʻae mohe maʻu kia ʻAtama, pea naʻa ne mohe: pea naʻa ne toʻo hono hui vakavaka ʻe taha, pea naʻe toe fakamaʻopoʻopo ʻa hono kakano. ");
INSERT INTO ton_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Pea ko e hui vakavaka ʻaia naʻe toʻo ʻe Sihova ko e ʻOtua mei he tangata, naʻa ne ngaohi mei ai ʻae fefine, pea ʻomi ia ki he tangata. ");
INSERT INTO ton_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Pea naʻe pehē ʻe ʻAtama, “Ko e hui eni ʻo hoku ngaahi hui, mo e kakano ʻo hoku kakano: ʻe ui ia ‘ko e Fefine,’ koeʻuhi naʻe toʻo ia mei he Tangata.” ");
INSERT INTO ton_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ko ia ʻe tukuange ai ʻe he tangata ʻa ʻene tamai mo ʻene faʻē, kae pikitai ki hono uaifi: pea te na kakano taha pe. ");
INSERT INTO ton_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pea naʻa na fakatou telefua, ʻae tangata mo hono uaifi, pea naʻe ʻikai te na mā ai. ");
INSERT INTO ton_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Pea naʻe olopoto lahi hake ʻae ngata ʻi he manu kotoa pē ʻoe fonua, ʻaia naʻe ngaohi ʻe Sihova ko e ʻOtua. Pea pehē ʻe ia ki he fefine, “ʻOku moʻoni koā kuo pehē ʻe he ʻOtua, ‘ʻE ʻikai te mo kai ʻi he ʻakau kotoa pē ʻoe ngoue?’” ");
INSERT INTO ton_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Pea naʻe pehē ʻe he fefine ki he ngata, “ʻOku ngofua ʻema kai ʻi he fua ʻoe ngaahi ʻakau ʻoe ngoue: ");
INSERT INTO ton_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ka ko e fua ʻoe ʻakau ʻaia ʻoku ʻi he loto ngoue, kuo folofola mai ʻe he ʻOtua, ‘ʻE ʻikai te mo kai ai, pea ʻe ʻikai te mo ala ki ai, telia naʻa mo mate.’” ");
INSERT INTO ton_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pea pehē ʻe he ngata ki he fefine, “ʻOku ʻikai moʻoni te mo mate. ");
INSERT INTO ton_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","He ʻoku ʻilo ʻe he ʻOtua, ʻi he ʻaho te mo kai ai, ʻe toki ʻā ai homo mata, pea te mo hangē ko e ʻotua, ke ʻilo ai ʻae lelei mo e kovi.” ");
INSERT INTO ton_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Pea ʻi he mamata ʻe he fefine ʻoku lelei ʻae ʻakau ki he kai, mo matamatalelei ki he mata, pea ko e ʻakau ke velevele ki ai ke fakapotoʻi, naʻa ne toʻo ai hono fua, ʻo kai, pea naʻa ne ʻange foki ki hono ʻhusepāniti, pea naʻa ne kai. ");
INSERT INTO ton_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Pea naʻe ʻā ai ʻae mata ʻokinaua ʻosi pe, pea na ʻilo kuo na telefua; pea naʻa na tui ʻae lou fiki, ʻona vala ʻaki ia. ");
INSERT INTO ton_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Pea naʻa na fanongo ki he leʻo ʻo Sihova ko e ʻOtua, ʻi he ʻalu ʻi he ngoue ʻi he mokomoko ʻoe ʻaho: pea naʻe toitoi ʻa ʻAtama mo hono uaifi, mei he ʻao ʻo Sihova ko e ʻOtua, ʻi he ngaahi ʻakau ʻoe ngoue. ");
INSERT INTO ton_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pea naʻe ui ʻe Sihova ko e ʻOtua kia ʻAtama, ʻo ne pehē kiate ia, “ʻOku ke ʻi fē?” ");
INSERT INTO ton_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Pea pehē ʻe ia, “Naʻaku fanongo ki ho leʻo ʻi he ngoue, pea naʻaku manavahē, koeʻuhi kuo u telefua; pea u toitoi ai.” ");
INSERT INTO ton_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Pea pehē ʻe ia, “Ko hai kuo fakahā kiate koe ʻoku ke telefua? Kuo ke kai ʻi he ʻakau, ʻaia naʻaku fekau kiate koe, ke ʻoua naʻa ke kai ai?” ");
INSERT INTO ton_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pea pehē ʻe he tangata, “Ko e fefine ʻaia naʻa ke foaki ke ma nonofo, naʻe ʻomi ʻe ia kiate au mei he ʻakau pea u kai ai.” ");
INSERT INTO ton_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Pea naʻe folofola ʻa Sihova ko e ʻOtua ki he fefine, “Ko e hā eni kuo ke fai?” Pea pehē ʻe he fefine, “Naʻe kākaaʻi au ʻe he ngata, pea u kai.” ");
INSERT INTO ton_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Pea naʻe folofola ʻa Sihova ko e ʻOtua ki he ngata, “Koeʻuhi kuo ke fai eni, kuo ke malaʻia lahi hake ʻi he fanga manu lalata kotoa pē, mo e manu kotoa pē ʻoe vao; te ke ngaolo koe ʻi ho kete, pea te ke kai ʻae efu ʻi he ngaahi ʻaho kotoa pē ʻo hoʻo moʻui: ");
INSERT INTO ton_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","pea te u tuku ʻae taufehiʻa ʻiate koe mo e fefine, pea ki ho hako mo hono hako; ʻe laiki ʻe ia ho ʻulu, pea te ke fakavolu ʻe koe ʻa hono muivaʻe.” ");
INSERT INTO ton_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Pea naʻe pehē ʻe ia ki he fefine, “Te u fakalahi ʻaupito ʻa hoʻo mamahi ʻi hoʻo fanafanau: te ke fāʻeleʻi ʻae fānau ʻi he mamahi; pea ʻe ʻi ho husepāniti ʻa hoʻo holi, pea te ne puleʻi koe.” ");
INSERT INTO ton_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Pea naʻe pehē ʻe ia kia ʻAtama, “Koeʻuhi kuo ke tokanga ki he leʻo ʻo ho uaifi, pea kuo ke kai ʻi he ʻakau ʻaia ne u fekau kiate koe, ‘Ke ʻoua naʻa ke kai ai:’ kuo malaʻia ʻae kelekele koeʻuhi ko koe; te ke kai mei ai ʻi he mamahi ʻi he ngaahi ʻaho kotoa pē ʻo hoʻo moʻui; ");
INSERT INTO ton_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","‌ʻe tupu mei ai kiate koe ʻae ʻakau talatala mo e talatalaʻāmoa; pea te ke kai ʻae ʻakau iiki ʻoe fonua; ");
INSERT INTO ton_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","te ke kai ʻae meʻakai ʻi he kakava ʻo ho mata, kaeʻoua ke ke foki ki he kelekele; he naʻe toʻo koe mei ai: he ko e efu koe, pea te ke toe foki ki he efu.” ");
INSERT INTO ton_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Pea naʻe ui ʻe ʻAtama ʻae hingoa ʻo hono uaifi ko ʻIvi; koeʻuhi ko e faʻē ia ʻoe kakai moʻui kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Naʻe ngaohi foki ʻe Sihova ko e ʻOtua mei he kiliʻi manu, ʻae ngaahi kofu kia ʻAtama mo hono uaifi, pea naʻa ne fakakofuʻi ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","¶ Pea naʻe folofola ʻa Sihova ko e ʻOtua, “Vakai, kuo hoko ʻae tangata ke hangē ko ha taha ʻiate kitautolu, ke ne ʻilo ʻae lelei mo e kovi: pea ko eni, telia naʻa mafao atu ʻe ia hono nima, pea ne toli foki mei he ʻakau ʻoe moʻui, ʻo kai, pea moʻui ʻo taʻengata:” ");
INSERT INTO ton_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ko ia naʻe fekau atu ia ʻe Sihova ko e ʻOtua mei he ngoue ʻo ʻIteni, ke ne ngāue ki he kelekele ʻaia naʻe toʻo ia mei ai. ");
INSERT INTO ton_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Pea naʻa ne kapusi ai ʻae tangata pea ne tuku ki he potu hahake ʻoe ngoue ʻo ʻIteni, ʻae selupimi, mo e heletā ulo, ʻaia naʻe foli fakatakamilo, ke leʻohi ʻae hala ʻoe ʻakau ʻoe moʻui. ");
INSERT INTO ton_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Pea naʻe ʻilo ʻe ʻAtama ʻa hono uaifi ko ʻIvi; pea tuituʻia ia, pea fanauʻi ʻa Keini, pea pehē ʻe ia, “Kuo u maʻu ha tangata meia Sihova.” ");
INSERT INTO ton_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pea ne toe fanauʻi ʻa hono tehina ko ʻEpeli. Pea ko e tauhi sipi ʻa ʻEpeli, ka ko e tauhi ngoue ʻa Keini. ");
INSERT INTO ton_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Pea ʻi he hokosia ʻae ngaahi ʻaho, naʻe ʻomi ʻe Keini ʻae ngaahi fua ʻoe kelekele, ko e feilaulau kia Sihova. ");
INSERT INTO ton_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Pea naʻe ʻomi foki ʻe ʻEpeli, ʻae veloaki mo ia naʻe ngako ʻi heʻene fanga manu. Pea naʻe leleiʻia ʻa Sihova kia ʻEpeli mo ʻene feilaulau: ");
INSERT INTO ton_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ka naʻe ʻikai te ne leleiʻia kia Keini mo ʻene feilaulau. Pea naʻe ʻita ʻaupito ʻa Keini, pea kehe hono mata. ");
INSERT INTO ton_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Pea naʻe folofola ʻa Sihova kia Keini, “Ko e hā ʻoku ke ʻita ai? Pea ko e hā ʻoku kehe ai ho mata? ");
INSERT INTO ton_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kapau te ke fai lelei, ʻikai ʻe maʻu koe? Pea ka ʻikai te ke fai lelei, ʻoku ʻi he matapā ʻae angahala. Pea ʻe anganofo ia kiate koe, pea te ke pule kiate ia.” ");
INSERT INTO ton_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Pea naʻe alea ʻa ʻEpeli mo hono tokoua: pea lolotonga ʻena ʻi he ngoue, naʻe tuʻu hake ʻa Keini ki hono tehina ko ʻEpeli, ʻone tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","¶ Pea naʻe folofola ʻa Sihova kia Keini, “Ko e fē ʻa ʻEpeli ko ho tehina?” Pea pehē ʻe ia, “ʻOku ʻikai te u ʻilo: he ko e tauhi au ʻa hoku tokoua?” ");
INSERT INTO ton_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Pea pehē ʻe ia, “Ko e hā eni kuo ke fai? ʻOku tangi kiate au mei he kelekele ʻae leʻo ʻoe toto ʻo ho tehina. ");
INSERT INTO ton_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Pea ko eni, kuo fakamalaʻia koe mei he kelekele, ʻaia kuo fakamanga hono ngutu ke maʻu mei ho nima ʻae toto ʻoho tehina; ");
INSERT INTO ton_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","‌ʻoka ke ka ngoueʻi ʻae kelekele, ʻe ʻikai tupu lelei kiate koe ʻa hono fua; te ke hoko ko e fehēhēʻaki mo e hehengi ʻi he fonua.” ");
INSERT INTO ton_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Pea naʻe pehē ʻe Keini kia Sihova, “ʻOku lahi hake ʻa hoku tautea ʻi heʻeku faʻa kātaki. ");
INSERT INTO ton_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Vakai, kuo ke kapusi au ʻi he ʻaho ni mei he funga ʻoe fonua; pea ʻe fufū au mei ho fofonga; pea teu fehēhēʻaki mo hehengi ʻi he fonua; pea ʻe hoko ʻo pehē, ko ia kotoa pē ʻoku ʻiloʻi au ʻe tāmateʻi au.” ");
INSERT INTO ton_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pea naʻe folofola ʻa Sihova kiate ia, “Ko ia ia ʻoku ne tāmateʻi ʻa Keini, ʻe tō kiate ia ʻae tautea ʻo liunga fitu.” Pea naʻe ʻai ʻe Sihova ʻae fakaʻilonga kia Keini, telia naʻa ʻilo ia ʻe ha taha, pea tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","¶ Pea naʻe ʻalu atu ʻa Keini mei he ʻao ʻo Sihova, ke nofo ʻi he fonua ko Noti, ʻi he potu  hahake ʻo ʻIteni. ");
INSERT INTO ton_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Pea naʻe ʻilo ʻe Keini ʻa hono uaifi, pea tuituʻia ia mo ne fanauʻi ʻa ʻInoke: pea naʻe langa ʻe ia ʻae kolo, pea naʻa ne fakahingoa ʻae kolo ki he hingoa ʻo hono foha ko ʻInoke. ");
INSERT INTO ton_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Pea naʻe fanauʻi kia ʻInoke ʻa ʻIlati pea tupu ʻia ʻIlati ʻa Mihuseale: pea tupu ʻia Mihuseale ʻa Metuseʻeli: pea tupu ʻia Metuseʻeli ʻa Lemeki, ");
INSERT INTO ton_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","¶ Pea naʻe maʻu ʻe Lemeki kiate ia ʻae ongo uaifi: ko e hingoa ʻoe tokotaha ko ʻAta, pea ko e hingoa ʻoe tokotaha ko Sila. ");
INSERT INTO ton_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Pea naʻe fanauʻi ʻe ʻAta ʻa Sepale ko e tamai ia ʻanautolu ʻoku nofo ʻi he ngaahi fale fehikitaki mo tauhi ʻae fanga manu. ");
INSERT INTO ton_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Pea ko e hingoa ʻo hono tokoua ko Supale: ko e tamai ia ʻanautolu kotoa pē ʻoku faiva ʻaki ʻae meʻa tatangi mo e meʻa ʻoku ifi. ");
INSERT INTO ton_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Pea fāʻeleʻi foki ʻe Sila ʻa Tupale-Keini, ko e tufunga ʻoe ngaahi meʻa kotoa pē ʻi he palasa mo e ukamea; pea ko e tuofefine ʻo Tupale-Keini ko Neama. ");
INSERT INTO ton_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Pea naʻe pehē ʻe Lemeki ki hono ongo uaifi ko ʻAta mo Sila, “Fanongo ki hoku leʻo; ʻae ongo uaifi ʻo Lemeki, fakafanongo ki heʻeku lea: he kuo u tāmateʻi ha tangata ʻi hoku lavea, ʻio, ko e talavou koeʻuhi ko ʻeku mamahi. ");
INSERT INTO ton_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kapau ʻe totongi ʻia Keini ʻo liunga fitu, ko e moʻoni, ʻe liunga fitungofulu ia lau ʻe fitu kia Lemeki.” ");
INSERT INTO ton_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","¶ Pea naʻe toe ʻilo ʻe ʻAtama ʻa hono uaifi; pea fāʻeleʻi ʻe ia ʻae tama, pea naʻe ui hono hingoa ko Seti: he naʻe pehē ʻe ia, “Kuo foaki kiate au ʻe he ʻOtua ha hako ʻe taha ko e fetongi ʻo ʻEpeli, ʻaia naʻe tāmateʻi ʻe Keini.” ");
INSERT INTO ton_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Pea naʻe fanauʻi foki ha foha kia Seti; pea naʻe ui hono hingoa ko ʻInosi: pea naʻe kamata ui ʻae kakai ki he huafa ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ko eni ʻae tohi ʻoe hako ʻo ʻAtama. ʻI he ʻaho naʻe fakatupu ʻe he ʻOtua ʻae tangata, naʻa ne ngaohi ia ʻi he tatau ʻoe ʻOtua; ");
INSERT INTO ton_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Naʻa ne fakatupu ʻakinaua ko e tangata mo e fefine; pea ne tāpuakiʻi ʻakinaua, pea ui hona hingoa ko ʻAtama, ʻi he ʻaho naʻe fakatupu ai ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","¶ Pea naʻe moʻui ʻa ʻAtama ʻi he taʻu ʻe teau ma tolungofulu, pea ne fakatupu ʻae foha ʻi hono tatau ʻoʻona, mo ʻene anga; pea naʻe ui hono hingoa ko Seti: ");
INSERT INTO ton_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Pea ko e ngaahi ʻaho ʻo ʻAtama hili ʻae fānau kiate ia ʻa Seti ko e taʻu ʻe valungeau: pea naʻa ne fakatupu ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Pea ko e ngaahi ʻaho kotoa pē naʻe moʻui ai ʻa ʻAtama, ko e taʻu ʻe hivangeau, mā tolungofulu: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Pea naʻe moʻui ʻa Seti ko e taʻu ʻe teau ma nima, pea ne fakatupu ʻa ʻInosi: ");
INSERT INTO ton_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Pea hili ʻae fanauʻi ʻa ʻInosi naʻe moʻui ʻa Seti ʻi he taʻu ʻe valungeau ma fitu, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Pea ko e ngaahi ʻaho kotoa pē ʻo Seti, ko e taʻu ʻe hivangeau ma hongofulu ma ua: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","¶ Pea naʻe moʻui ʻa ʻInosi, ko e taʻu ʻe hivangofulu, pea ne fakatupu ʻa Kēnani: ");
INSERT INTO ton_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Pea hili ʻae fanauʻi ʻa Kēnani naʻe moʻui ʻa ʻInosi ʻi he taʻu ʻe valungeau ma hongofulu ma nima pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Pea ko e ngaahi ʻaho kotoa pē ʻo ʻInosi, ko e taʻu ʻe hivangeau ma nima: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","¶ Pea naʻe moʻui ʻa Kēnani ko e taʻu ʻe fitungofulu, pea ne fakatupu ʻa Malelili: ");
INSERT INTO ton_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Pea hili ʻae fanauʻi ʻa Malelili naʻe moʻui ʻa Kēnani ʻi he taʻu ʻe valungeau ma fāngofulu, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Pea ko e ngaahi ʻaho kotoa pē ʻo Kēnani, ko e taʻu ʻe hivangeau ma hongofulu pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","¶ Pea naʻe moʻui ʻa Malelili ko e taʻu ʻe onongofulu ma nima, pea ne fakatupu ʻa Seleti: ");
INSERT INTO ton_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Pea hili ʻae fanauʻi ʻa Seleti naʻe moʻui ʻa Malelili ʻi he taʻu ʻe valungeau ma tolungofulu pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Pea ko e ngaahi ʻaho kotoa pē ʻo Malelili, ko e taʻu ʻe valungeau ma hivangofulu ma nima: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","¶ Pea naʻe moʻui ʻa Seleti ko e taʻu ʻe teau ma onongofulu ma ua, pea ne fakatupu ʻa ʻInoke: ");
INSERT INTO ton_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Pea hili ʻae fanauʻi ʻa ʻInoke naʻe moʻui ʻa Seleti ʻi he taʻu ʻe valungeau, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Pea ko e ngaahi ʻaho kotoa pē ʻo Seleti, ko e taʻu ʻe hivangeau ma onongofulu ma ua: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","¶ Pea naʻe moʻui ʻa ʻInoke ko e taʻu ʻe onongofulu ma nima, pea ne fakatupu ʻa Metusela: ");
INSERT INTO ton_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Pea hili ʻae fanauʻi kiate ia ʻa Metusela naʻe ʻeveʻeva ʻa ʻInoke mo e ʻOtua ʻi he taʻu ʻe tolungeau, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Pea ko e ngaahi ʻaho kotoa pē ʻo ʻInoke, ko e tau ʻe tolungeau ma onongofulu ma nima: ");
INSERT INTO ton_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Pea naʻe ʻaʻeva ʻa ʻInoke mo e ʻOtua pea naʻe ʻikai ia; he naʻe ʻave ia ʻe he ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","¶ Pea naʻe moʻui ʻa Metusela ko e taʻu ʻe teau ma valungofulu ma fitu, pea ne fakatupu ʻa Lemeki: ");
INSERT INTO ton_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Pea hili ʻae fanauʻi ʻa Lemeki naʻe moʻui ʻa Metusela ʻi he taʻu ʻe fitungeau ma valungofulu ma ua, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Pea ko e ngaahi ʻaho kotoa pē ʻo Metusela ko e taʻu ʻe hivangeau ma onongofulu ma hiva: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","¶ Pea naʻe moʻui ʻa Lemeki ko e taʻu ʻe teau ma valungofulu ma ua, pea ne fakatupu ha foha: ");
INSERT INTO ton_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Pea naʻa ne ui hono hingoa ko Noa, ʻo pehē, “Ko eni ia ʻe fakafiemālie kiate kitautolu ʻi heʻetau ngāue, mo e ongosia ʻa hotau nima, koeʻuhi ko e kelekele kuo fakamalaʻia ʻe Sihova.” ");
INSERT INTO ton_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Pea hili ʻae fanauʻi ʻa Noa naʻe moʻui ʻa Lemeki ʻi he taʻu ʻe nimangeau ma nimangofulu ma nima, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine: ");
INSERT INTO ton_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pea ko e ngaahi ʻaho kotoa pē ʻo Lemeki ko e taʻu ʻe fitungeau ma fitungofulu ma fitu: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","¶ Pea ko Noa, naʻe nimangeau taʻu hono motuʻa: pea fakatupu ʻe Noa ʻa Semi, mo Hami, mo Sepeti. ");
INSERT INTO ton_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Pea naʻe hoko ʻo pehē, ʻi he fakaʻaʻau ke tokolahi ʻae kakai ʻi he funga ʻo māmani, naʻe fanauʻi ʻae ngaahi ʻofefine kiate kinautolu, ");
INSERT INTO ton_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Pea mamata ʻe he ngaahi foha ʻoe ʻOtua ki he ngaahi ʻofefine ʻoe tangata ʻoku nau hoihoifua; pea naʻa nau fili mei ai ʻae ngaahi uaifi ʻo maʻu kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Pea naʻe folofola ʻa Sihova, “E ʻikai ʻahiʻahi maʻuaipē ʻa hoku Laumālie mo e tangata, he ko e kakano foki ia: ka ʻe hoko hono ngaahi ʻaho ki he taʻu ʻe teau ma uofulu.” ");
INSERT INTO ton_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","‌ʻI he ngaahi ʻaho ko ia naʻe ai ʻae kakai lalahi ʻi māmani; pea hili ia foki, ʻi he ʻalu ʻae ngaahi foha ʻoe ʻOtua ki he ngaahi ʻofefine ʻoe tangata, pea nau fānau kiate kinautolu, naʻe mālohi lahi ʻae kau tangata ko ia, ʻae kau tangata ongoongo ʻoe muʻaki kuonga. ");
INSERT INTO ton_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","¶ Pea naʻe ʻafio ʻe he ʻOtua kuo lahi ʻae angahala ʻae tangata ʻi māmani, pea kuo kovi maʻuaipē ʻae filioʻi kotoa pē ʻoe ngaahi mahalo ʻa hono loto. ");
INSERT INTO ton_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Pea naʻe fakatomala ʻa Sihova koeʻuhi kuo ne ngaohi ʻae tangata ʻi māmani, pea naʻe mamahi ai ʻa hono finangalo. ");
INSERT INTO ton_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Pea naʻe folofola ʻa Sihova, “Te u fakaʻauha mei he funga ʻo māmani ʻae tangata ʻaia kuo u ngaohi; ko e tangata, mo e manu, mo e meʻa totolo, mo e fanga manu ʻoe ʻatā; he ʻoku ou fakatomala ʻi heʻeku ngaohi ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ka naʻe ʻofeina ʻa Noa ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","¶ Ko eni ʻae tala hohoko kia Noa ko e tangata angatonu mo haohaoa ʻa Noa ʻi hono toʻutangata, pea naʻe ʻaʻeva ʻa Noa mo e ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Pea naʻe fakatupu ʻe Noa ʻae foha ʻe toko tolu, ko Semi, mo Hami, mo Sefeti. ");
INSERT INTO ton_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Naʻe fakalielia foki ʻa māmani ʻi he ʻao ʻoe ʻOtua, pea naʻe fonu ʻa māmani ʻi he fakamālohi. ");
INSERT INTO ton_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pea naʻe ʻafioʻi ʻe he ʻOtua ki māmani, pea vakai kuo kovi ia; he naʻe fakalieliaʻi ʻe he kakano kotoa pē hono hala ʻi māmani. ");
INSERT INTO ton_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Pea naʻe folofola ʻe he ʻOtua kia Noa, “Kuo hoko ki hoku ʻao ʻae ngataʻanga ʻoe kakano kotoa pē; he kuo fonu ʻa māmani ʻi he fakamālohi ʻiate kinautolu; pea vakai, te u fakaʻauha ʻakinautolu mei he māmani. ");
INSERT INTO ton_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","¶ Ngaohi kiate koe hā vaka mei he ʻakau ko e kofa; te ke ngaohi ʻae ngaahi ʻana ʻi he vaka, pea te ke vali ʻaki ia ʻae pulu ʻi loto mo tuʻa. ");
INSERT INTO ton_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Pea ko eni ʻae anga ʻo hono ngaohi, Ko hono lōloa ʻoe vaka ko e hanga ʻe onongeau, ko hono māukupu ko e hanga ʻe teau pea ko hono māʻolunga ko e hanga ʻe onongofulu. ");
INSERT INTO ton_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Te ke ngaohi ha kātupa ʻi he vaka pea te ke fakaʻosi ia ʻi he hanga ʻe ua ki ʻolunga; pea te ke ʻai ʻae matapā ʻoe vaka ʻi hono kaokao; pea te ke ngaohi ʻae fata ʻi lalo, mo hono ua, mo hono tolu, ki ʻolunga. ");
INSERT INTO ton_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Pea vakai, ko au, ʻio, ko au, ʻoku ou ʻomi ʻae lōmaki ʻoe ngaahi vai ki māmani, ke fakaʻauha ʻae kakano kotoa pē mei he lalo langi, ʻaia ʻoku ʻi ai ʻae mānava ʻoe moʻui; pea ʻe mate ʻae meʻa kotoa pē ʻoku ʻi māmani. ");
INSERT INTO ton_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ka te u fokotuʻumaʻu mo koe ʻeku fuakava; pea te ke haʻu ki he vaka, ʻa koe, mo ho ngaahi foha, mo ho uaifi, mo e ngaahi uaifi ʻo ho ngaahi foha mo koe. ");
INSERT INTO ton_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Pea te ke ʻomi ki he vaka ʻo tautau toko ua mei he meʻa moʻui kotoa pē ʻoe kakano kotoa pē, ke fakamoʻui ʻakinautolu mo koe; ko e fefine mo e tangata. ");
INSERT INTO ton_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ko e fanga manupuna ʻi honau faʻahinga, mo e fanga manu ʻi honau faʻahinga, mo e ngaahi meʻa totolo kotoa pē ʻoe fonua ʻi hono faʻahinga, ʻe haʻu kiate koe ʻae toko ua ʻi he faʻahinga kotoa pē, ke fakamoʻui. ");
INSERT INTO ton_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pea ke toʻo kiate koe ʻi he meʻakai kotoa pē ʻoku kai, pea te ke tānaki ia kiate koe; pea ko e meʻakai ia kiate koe, pea mo kinautolu.” ");
INSERT INTO ton_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Naʻe fai pehē ʻe Noa; ʻo hangē ko ia kotoa pē naʻe fekau kiate ia ʻe he ʻOtua, ko ia naʻa ne fai. ");
INSERT INTO ton_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Pea naʻe folofola ʻa Sihova, kia Noa, “Haʻu koe mo ho fale kotoa pē ki he vaka; he kuo u vakai kiate koe ʻoku ke māʻoniʻoni ʻi hoku ʻao ʻi he toʻutangata ni. ");
INSERT INTO ton_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Te ke toʻo kiate koe ʻo tautau toko fitu ʻi he fanga manu maʻa kotoa pē ko e tangata mo e fefine; pea tautau toko ua ʻi he fanga manu taʻemaʻa, ko e tangata mo e fefine. ");
INSERT INTO ton_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ke tautau toko fitu ʻi he fanga manu foki ʻoe ʻatā, ko e tangata mo e fefine; ke fakamoʻui ʻae hako ʻi he funga ʻo māmani kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","He ʻoku toe ʻae ngaahi ʻaho ʻe fitu, pea te u pule ke ʻuha ki māmani ʻi he ʻaho ʻe fāngofulu mo e pō ʻe fāngofulu; pea te u fakaʻauha mei he funga ʻo māmani ʻae ngaahi meʻa moʻui kotoa pē kuo u ngaohi.” ");
INSERT INTO ton_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Pea naʻe fai ʻe Noa ʻo hangē ko ia kotoa pē naʻe fekau ʻe Sihova kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Pea naʻe onongeau ʻae taʻu ʻo Noa, feʻunga mo e hoko ʻae lōmaki ʻoe ngaahi vai ki māmani. ");
INSERT INTO ton_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","¶ Pea naʻe hū ʻa Noa ki he vaka mo hono ngaahi foha, mo hono uaifi, mo e ngaahi uaifi ʻo hono ngaahi foha mo ia, koeʻuhi ko e ngaahi vai ʻoe lōmaki. ");
INSERT INTO ton_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ko e fanga manu maʻa, mo e fanga manu taʻemaʻa, mo e fanga manupuna, mo e meʻa kotoa pē ʻoku totolo ʻi he fonua, ");
INSERT INTO ton_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Naʻe ʻalu atu kia Noa ʻi he vaka ʻo tautau toko ua, ko e tangata mo e fefine, ʻo hangē ko e fekau ʻae ʻOtua kia Noa. ");
INSERT INTO ton_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Pea ʻi heʻene hili mai ʻae ʻaho ʻe fitu, naʻe hoko ki māmani ʻae ngaahi vai ʻoe lōmaki. ");
INSERT INTO ton_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","¶ ʻI he taʻu ʻe onongeau ʻoe moʻui ʻa Noa, ʻi hono ua ʻoe māhina, mo hono hongofulu ma fitu ʻoe ʻaho ʻi he māhina, ko e ʻaho ko ia naʻe fakapā hake ai ʻae ngaahi matavai ʻoe moana lahi, pea naʻe toʻo ai ʻae ngaahi matavai ʻoe langi. ");
INSERT INTO ton_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Pea naʻe tō ʻae ʻuha ki māmani, ʻi he ʻaho ʻe fāngofulu mo e pō ʻe fāngofulu. ");
INSERT INTO ton_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","‌ʻI he ʻaho pe ko ia naʻe hū ai ki he vaka ʻa Noa, mo Semi, mo Hami, mo Sefeti, ko e ngaahi foha ʻo Noa, mo e uaifi ʻo Noa, mo e ngaahi uaifi ʻe toko tolu ʻa hono ngaahi foha, mo kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","‌ʻAkinautolu, mo e fanga manu ʻoe vao ʻi hono faʻahinga kotoa pē, mo e fanga manu kotoa pē ʻi honau faʻahinga, mo e meʻa totolo kotoa pē ʻoku ngaolo ʻi he fonua ʻi hono faʻahinga, mo e fanga manupuna kotoa pē ʻi hono faʻahinga, ʻae manu kapakau kehekehe kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Pea naʻa nau ʻalu kia Noa ki he vaka, ʻo tautau toko ua ʻi he kakano kotoa pē, ʻaia naʻe ʻi ai ʻae mānava ʻoe moʻui. ");
INSERT INTO ton_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Pea ko ia naʻe hū ai, naʻe ʻalu ko e tangata mo e fefine ʻi he kakano kotoa pē, ʻo hangē ko e fekau ʻae ʻOtua kiate ia; pea naʻe tāpuni ia ʻi ai ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Pea naʻe ʻi he fonua ʻae lōmaki ʻi he ʻaho ʻe fāngofulu; pea naʻe hake ʻae ngaahi vai, pea maʻanu ai ʻae vaka, pea naʻe tētē ia ʻi ʻolunga, ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Pea naʻe mālohi ʻae ngaahi vai, pea tupu lahi ʻi he funga fonua; pea naʻe tētē ʻae vaka ʻi he fukahi vai. ");
INSERT INTO ton_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Pea naʻe mālohi ʻaupito ʻae ngaahi vai ʻi he funga fonua; pea naʻe fakangalo ai ʻae ngaahi moʻunga māʻolunga kotoa pē, ʻaia naʻe ʻi he lalo langi. ");
INSERT INTO ton_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Naʻe mālohi ʻae ngaahi vai; naʻe hake ia ko e hanga ʻe tolungofulu, pea naʻe ʻūfia ai ʻae ngaahi moʻunga. ");
INSERT INTO ton_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Pea naʻe mate ʻae kakano kotoa pē ʻaia naʻe ngaue ʻi māmani, ko e fanga manupuna, mo e fanga manu lalata, mo e fanga manu ʻoe vao, mo e meʻa totolo kotoa pē ʻoku ngaolo ʻi he fonua, mo e tangata kotoa pē: ");
INSERT INTO ton_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ko ia kotoa pē naʻe ʻi honau avaʻi ihu ʻae mānava ʻoe moʻui, ʻaia kotoa pē naʻe ʻi he fonua mōmoa naʻe mate. ");
INSERT INTO ton_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Pea naʻe fakaʻauha ʻae meʻa moʻui kotoa pē ʻaia naʻe ʻi he funga kelekele, ʻae tangata, mo e fanga manu, mo e ngaahi meʻa totolo, mo e fanga manupuna ʻoe ʻatā; pea naʻe fakaʻauha ʻakinautolu mei he māmani; pea naʻe toe pe ʻa Noa, mo kinautolu naʻe ʻiate ia ʻi he vaka. ");
INSERT INTO ton_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Pea naʻe mālohi ʻae ngaahi vai ʻi māmani ʻi he ʻaho ʻe teau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Pea naʻe manatu ʻae ʻOtua kia Noa, mo e meʻa moʻui kotoa pē, mo e fanga manu kotoa pē ʻaia naʻe ʻi he vaka mo ia: pea naʻe pule ʻe he ʻOtua ke ʻalu atu ʻae matangi ʻi he funga ʻo māmani, pea naʻe matuku ai ʻae ngaahi vai; ");
INSERT INTO ton_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Naʻe tāpuni foki ʻae ngaahi matavai ʻoe moana mo e ngaahi matavai ʻoe langi, pea naʻe taʻofi ʻae ʻuha mei he langi; ");
INSERT INTO ton_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Pea naʻe fakaʻaʻau ke matuku ʻae ngaahi vai mei māmani: pea ʻi he fakaʻosi ʻae ʻaho ʻe teau ma nimangofulu kuo siʻi ʻae ngaahi vai. ");
INSERT INTO ton_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Pea naʻe toka ʻae vaka ʻi he ngaahi moʻunga ʻo ʻAlalate, ʻi hono fitu ʻoe māhina, ʻi he ʻaho ʻe hongofulu ma fitu ʻoe māhina. ");
INSERT INTO ton_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Pea naʻe fakasiʻisiʻi maʻuaipē ʻae ngaahi vai ʻo aʻu ki hono hongofulu ʻoe māhina: naʻe ha hake ʻae tumutumu ʻoe ngaahi moʻunga ʻi hono hongofulu māhina, ʻi he ʻuluaki ʻaho ʻoe māhina. ");
INSERT INTO ton_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","¶ Pea ʻi he hili ange ʻae ʻaho ʻe fāngofulu, naʻe toʻo ʻe Noa ʻae matapā ʻoe vaka ʻaia naʻa ne ngaohi: ");
INSERT INTO ton_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Pea naʻa ne tukuange ha leveni, ʻaia naʻe feʻaluʻaki, kaeʻoua ke matuʻu ʻae ngaahi vai mei he funga ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Naʻa ne tukuange foki ha lupe meiate ia, ke vakai pe kuo matuku ʻae ngaahi vai mei he funga ʻoe kelekele; ");
INSERT INTO ton_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ka naʻe ʻikai ʻilo ʻe he lupe ha tuʻuʻanga ki hono ʻaofi vaʻe, pea naʻe foki ia kiate ia ki he vaka, he naʻe ʻi he funga ʻo māmani kotoa ʻae ngaahi vai: pea naʻe mafao atu ʻe ia hono nima, ʻo toʻo pea ʻomi ia kiate ia ki he vaka. ");
INSERT INTO ton_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Pea naʻe toe tatali ia ʻi he ʻaho ʻe fitu; pea ne toe tukuange ʻae lupe mei he vaka; ");
INSERT INTO ton_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Pea naʻe haʻu ʻae lupe kiate ia ʻi he efiafi; pea vakai, kuo ʻi hono ngutu ʻae lauʻi ʻolive kuo ne pakiʻi: pea toki ʻilo ai ʻe Noa kuo matuku ʻae ngaahi vai mei he māmani. ");
INSERT INTO ton_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Pea toe tatali ia ʻi he ʻaho ʻe fitu; pea tuku atu ai ʻae lupe; pea naʻe ʻikai toe foki mai ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","¶ Pea ʻi he hoko ki hono onongeau ma taha taʻu, ʻi he ʻuluaki māhina, ʻi he ʻuluaki ʻaho ʻoe māhina, naʻe matuʻu ai ʻae ngaahi vai mei he fonua; pea naʻe hiki ʻe Noa ʻae ʻufiʻufi ʻoe vaka, ʻo sio, pea vakai, kuo mōmoa ʻae funga ʻoe kelekele. ");
INSERT INTO ton_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Pea naʻe mōmoa ʻae fonua ʻi hono ua ʻoe māhina, ʻi hono uofulu ma fitu ʻoe ʻaho ʻoe māhina. ");
INSERT INTO ton_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","¶ Pea naʻe folofola ʻae ʻOtua kia Noa, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ʻAlu atu mei he vaka, ʻa koe, mo ho uaifi, mo ho ngaahi foha, mo e ngaahi uaifi ʻo ho ngaahi foha mo koe. ");
INSERT INTO ton_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Omi mo koe ʻae ngaahi meʻa moʻui kotoa pē ʻoku ʻiate koe, ʻi he kakano kotoa pē, mo e fanga manupuna, mo e fanga manu, pea mo e meʻa totolo kotoa pē ʻoku ngaolo ʻi he fonua; koeʻuhi kenau fanafanau ʻo lahi ʻi he fonua pea tupu, pea fakatokolahi ʻi māmani.” ");
INSERT INTO ton_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Pea naʻe ʻalu atu ʻa Noa, mo hono ngaahi foha, mo hono uaifi, mo e ngaahi uaifi ʻo hono ngaahi foha mo ia: ");
INSERT INTO ton_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Naʻe ʻalu atu mei he vaka, ʻi honau faʻahinga, ʻae fanga manu kotoa pē, mo e ngaahi meʻa totolo kotoa pē, mo e fanga manupuna kotoa pē, mo ia kotoa pē ʻoku totolo ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","¶ Pea naʻe fokotuʻu ʻe Noa ha ʻesifeilaulau kia Sihova; pea naʻa ne toʻo mei he fanga manu maʻa kotoa pē, pea mei he fanga manupuna naʻe maʻa, pea ʻohake ai ʻae ngaahi feilaulau tutu ʻi he ʻesifeilaulau. ");
INSERT INTO ton_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Pea naʻe nanamu ʻa Sihova ki hono ngangatu lelei, pea naʻe pehē ʻe Sihova ʻi hono finangalo, “ʻE ʻikai te u toe fakamalaʻiaʻi ʻae fonua koeʻuhi ko e tangata; he ʻoku kovi ʻae ngaōʻi ʻoe loto ʻoe tangata mei heʻene kei siʻi; pea ʻe ʻikai te u toe taaʻi ʻae ngaahi meʻa moʻui kotoa pē ʻo hangē ko ia kuo u fai. ");
INSERT INTO ton_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Lolotonga ʻae tuʻu ʻa māmani, ʻe ʻikai tuku ʻae tō taʻu mo e ututaʻu, mo e momoko mo e pupuha, mo e faʻahitaʻu mafana mo e faʻahitaʻu momoko, mo e ʻaho mo e pō.” ");
INSERT INTO ton_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Pea naʻe tāpuakiʻi ʻe he ʻOtua ʻa Noa mo hono ngaahi foha, pea ne pehē kiate kinautolu, “Mou tupu, mo fakatokolahi, pea fakakakai ʻa māmani. ");
INSERT INTO ton_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Pea ʻe ʻi he fanga manu kotoa pē ʻo māmani ʻae manavahē mo e ilifia kiate kimoutolu, pea ʻi he fanga manupuna kotoa pē ʻoe ʻatā, mo ia kotoa pē ʻoku ngaue ʻi he fonua, pea ki he ngaahi ika kotoa pē ʻoe tahi; kuo tuku kotoa pē ki homou nima. ");
INSERT INTO ton_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ko e meʻa moʻui kotoa pē ʻoku ngaue, ko hoʻo mou meʻakai ia; ʻio, ʻo hangē ko e ʻakau mata kuo u foaki ʻae ngaahi meʻa kotoa pē kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ka ko e kakano ʻoku ʻi ai ʻae moʻui, ʻaia ko hono toto, ʻe ʻikai te mou kai ia. ");
INSERT INTO ton_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","He ko e moʻoni, teu ʻekeʻi ʻae toto ʻa hoʻomou moʻui; teu ʻekeʻi ia ʻi he nima ʻoe fanga manu kotoa pē; pea mei he nima ʻoe tangata; teu ʻekeʻi ʻae moʻui ʻae tangata mei he nima ʻoe kāinga ʻoe tangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ko ia ʻoku lilingi ʻae toto ʻoe tangata, ʻe lilingi hono toto ʻe he tangata: he naʻe ngaohi ʻae tangata ʻi he tatau ʻoe ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pea ko kimoutolu, ke mou tupu, pea fakatokolahi mo fanafanau lahi ʻi he fonua, pea tupu ke tokolahi ʻi ai.” ");
INSERT INTO ton_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","¶ Pea naʻe folofola ʻae ʻOtua kia Noa, pea ki hono ngaahi foha, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Vakai, ko au, ʻoku ou fokotuʻu ʻeku fuakava kiate kimoutolu, mo homou hako ʻe tupu fakaholo; ");
INSERT INTO ton_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Pea ki he ngaahi meʻa moʻui kotoa pē ʻoku ʻiate kimoutolu, ʻae fanga manupuna, mo e fanga manu lalata, mo e fanga manu vao kotoa pē ʻoe fonua ʻoku ʻiate kimoutolu; ʻaia kotoa pē ʻoku ʻalu atu mei he vaka, pea mo e fanga manu vao kotoa pē ʻe ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Pea te u fokotuʻu ʻeku fuakava mo kimoutolu; pea ʻe ʻikai toe motuhi ʻae kakano kotoa pē ʻe he ngaahi vai ʻo ha lōmaki; pea ʻe ʻikai toe ai ha lōmaki ke fakaʻauha ʻa māmani.” ");
INSERT INTO ton_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Pea naʻe pehē ʻe he ʻOtua, “Ko eni ʻae fakaʻilonga ʻoe fuakava kuo u fai mo kimoutolu mo e ngaahi meʻa moʻui kotoa pē ʻoku ʻiate kimoutolu, ki he ngaahi toʻutangata taʻetuku: ");
INSERT INTO ton_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","‌ʻOku ou ai ʻeku ʻumata ʻi he ʻao, pea ʻe fakaʻilonga ʻaki ia ʻae fuakava ʻiate au mo māmani.” ");
INSERT INTO ton_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Pea ʻe pehē, “O kau ka ʻomi ʻae ʻao ki he fonua, ʻe hā mai ʻae ʻumata ʻi he ʻao: ");
INSERT INTO ton_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Pea te u manatu ki heʻeku fuakava, ʻaia kuo u fai mo kimoutolu mo e ngaahi meʻa moʻui kotoa pē ʻoe kakano kotoa pē; pea ʻe ʻikai toe hoko ʻae ngaahi vai, ko e lōmaki ke fakaʻauha ʻae kakano kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pea ʻe ʻi he ʻao ʻae ʻumata; pea te u vakai ki ai, koeʻuhi ke u manatu ki he fuakava taʻengata ʻae ʻOtua mo e ngaahi meʻa moʻui kotoa pē ʻoe kakano kotoa pē, ʻaia ʻoku ʻi māmani.” ");
INSERT INTO ton_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Pea naʻe folofola ʻe he ʻOtua kia Noa, “Ko eni ʻae fakaʻilonga ʻoe fuakava, ʻaia kuo u fokotuʻu ʻiate au mo e kakano kotoa pē ʻoku ʻi māmani.” ");
INSERT INTO ton_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","¶ Pea ko e ngaahi foha ʻo Noa, ʻaia naʻe ʻalu atu mei he vaka, ko Semi, mo Hami, mo Sefeti: pea ko Hami ko e tamai ʻa Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ko eni ʻae foha ʻe toko tolu ʻo Noa pea naʻe fakakakai ʻa māmani kotoa pē ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Pea naʻe kamata ʻa Noa ke tauhi ngoue, pea ne tō ʻae ngoue vaine: ");
INSERT INTO ton_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Pea inu ʻe ia ʻi he uaine, pea kona ai: pea naʻe telefua ia ʻi hono fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Pea naʻe mamata ʻa Hami, ko e tamai ʻa Kēnani, ki he telefua ʻo ʻene tamai, pea tala ʻe ia ki hono ongo tokoua ʻituʻa. ");
INSERT INTO ton_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Pea naʻe toʻo ʻe Semi mo Sefeti ʻae kofu, pea na ai ia ki hona uma, pea naʻa na fakaholomui, pea ʻufiʻufi ʻae telefua ʻo ʻena tamai, pea naʻe hanga kimui hona mata, pea naʻe ʻikai mamata ʻekinaua ki he telefua ʻo ʻena tamai. ");
INSERT INTO ton_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Pea naʻe ʻā ʻa Noa mei heʻene uaine, pea ʻilo ʻe ia ʻaia naʻe fai kiate ia ʻe hono foha kimui. ");
INSERT INTO ton_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Pea pehē ʻe ia, “Ke malaʻia ʻa Kēnani. ʻE hoko ia ko e tamaioʻeiki ʻoe kau tamaioʻeiki ki hono kāinga.” ");
INSERT INTO ton_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Pea pehē ʻe ia, “Ke monūʻia ʻa Sihova ko e ʻOtua ʻo Semi; pea ʻe hoko ʻa Kēnani ko ʻene tamaioʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","E fakalahi ʻe he ʻOtua ʻa Sefeti, pea ʻe nofo ia ʻi he ngaahi fale fehikitaki ʻo Semi; pea ʻe hoko ʻa Kēnani ko ʻene tamaioʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","¶ Pea naʻe moʻui ʻa Noa hili ʻae lōmaki ʻi he taʻu ʻe tolungeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Pea naʻe hivangeau ma nimangofulu taʻu ʻae ngaahi ʻaho kotoa pē ʻo Noa: pea pekia ia. ");
INSERT INTO ton_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ko eni ʻae tala hohoko ʻoe ngaahi foha ʻo Noa, ko Semi, mo Hami, mo Sefeti: pea naʻe fanauʻi kiate kinautolu ʻae ngaahi foha hili ʻae lōmaki. ");
INSERT INTO ton_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ko e ngaahi foha ʻo Sefeti; ko Komela, mo Mekoki, mo Metai, mo Savani, mo Tupale, mo Meseke, mo Tailasa. ");
INSERT INTO ton_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Pea ko e ngaahi foha ʻo Komela; ko ʻAsekinasa, mo Lifata, mo Tokama. ");
INSERT INTO ton_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Pea ko e ngaahi foha ʻo Savani; ko ʻElaisa, mo Taʻasisi, mo Ketimi, mo Totenimi. ");
INSERT INTO ton_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Naʻe vahevahe kiate kinautolu ni ʻae ngaahi fonua ʻoe ngaahi puleʻanga ke nau fonua ʻaki; ke taki taha ʻi hono lea mo honau faʻahinga, pea mo honau ngaahi puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","¶ Pea ko e ngaahi foha ʻo Hami; ko Kusa, mo Misilemi, mo Futi, mo Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Pea ko e ngaahi foha ʻo Kusa; ko Sipa, mo Havila, mo Sapita, mo Leama, mo Sapetika: pea ko e ongo foha ʻo Leama; ko Sipa, mo Titani. ");
INSERT INTO ton_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Pea naʻe tupu ia Kusa, ʻa Nimilote: pea naʻe hoko ia ko e tokotaha lahi ʻi māmani. ");
INSERT INTO ton_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ko e tangata tuli manu fakamanavahē ia ʻi he ʻao ʻoe ʻEiki: ko ia ʻoku ai ʻae lea ʻoku pehē, “ʻO hangē ko Nimilote ko e tuli manu lahi ʻi he ʻao ʻoe ʻEiki.” ");
INSERT INTO ton_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Pea ko e kamataʻanga ʻo hono puleʻanga ko Pepeli, mo ʻIleke, mo ʻAkata, mo Kalina, ʻi he fonua ko Saina. ");
INSERT INTO ton_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Naʻe ʻalu atu ʻa ʻAsilia mei he fonua ko ia, pea ne langa ʻa Ninive, mo e kolo ko Leopote, mo Kela, ");
INSERT INTO ton_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Mo Lisini ʻi he vahaʻa ʻo Ninive mo Kela: ko e kolo lahi ia. ");
INSERT INTO ton_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Pea naʻe tupu ia Misilemi ʻa Lutimi, mo ʻAnamemi, mo Lehapimi, mo Nafituhemi, ");
INSERT INTO ton_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Mo Patilusime, mo Kasiluhemi, (naʻe tupu mei ai ʻa Filisitia,) mo Kafitolime. ");
INSERT INTO ton_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","¶ Pea naʻe tupu ia Kēnani ʻa Saitoni ko hono ʻuluaki, mo Heti, ");
INSERT INTO ton_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Mo e kakai Sepusi, mo e ʻAmoli, mo e Keakasa, ");
INSERT INTO ton_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Mo e Hevi, mo e ʻAlaka, mo e Sina, ");
INSERT INTO ton_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Mo e ʻAvati, mo e Semali, mo e Hemati; pea hili ia naʻe movete atu ʻae ngaahi faʻahinga ʻo Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Pea ko e ngataʻanga fonua ʻoe kakai Kēnani naʻe fai mei Saitoni, ʻi hoʻo haʻu mei Kilai ki Kesa; ʻi hoʻo ʻalu ai ki Sotoma mo Komola, mo ʻAtima, mo Sipoimi ʻo aʻu ki Lesa. ");
INSERT INTO ton_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ko e ngaahi foha eni ʻo Hami, ʻi honau ngaahi faʻahinga, mo e nau ngaahi lea, ʻi honau ngaahi fonua, mo honau ngaahi puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","¶ Ko Semi foki, ʻaia ko e tamai ʻae fānau kotoa pē ʻa ʻIpela, ko e tehina ʻo Sefeti ko e lahi, naʻe ai foki ʻae fānau kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ko e fānau ʻa Semi; ko ʻIlami, mo ʻAsuli, mo ʻAfakisati, mo Luti, mo ʻElami. ");
INSERT INTO ton_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Pea ko e fānau ʻa ʻElami; ko ʻUsi, mo Uli, mo Ketali, mo Masi. ");
INSERT INTO ton_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Pea naʻe tupu ia ʻAfakisati ʻa Sela, pea fakatupu ʻe Sela ʻa ʻIpela. ");
INSERT INTO ton_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Pea naʻe fanauʻi kia ʻIpela ʻae ongo foha; ko e hingoa ʻoe tokotaha ko Peleki: he naʻe vahevahe ʻae fonua ʻi hono ngaahi ʻaho; pea ko e hingoa ʻo hono tokoua ko Sokitani. ");
INSERT INTO ton_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Pea naʻe tupu ia Sokitani ʻa ʻAlimotate, mo Silefi, mo Hesamevete, mo Sela, ");
INSERT INTO ton_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Mo Hatolame, mo ʻUsali, mo Tikila, ");
INSERT INTO ton_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Mo ʻOpale, mo ʻApimaeli, mo Sipa. ");
INSERT INTO ton_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Mo ʻOfeli, mo Havila, mo Sopapi: ko e ngaahi foha eni kotoa pē ʻo Sokitani. ");
INSERT INTO ton_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Pea ko honau nofoʻanga naʻe fai mei Mesa, ʻi hoʻo ʻalu ʻo aʻu ki Sefa ko e moʻunga ʻi hahake. ");
INSERT INTO ton_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ko e ngaahi foha eni ʻo Semi, ʻi honau ngaahi faʻahinga, mo e nau ngaahi lea, mo honau ngaahi fonua, mo honau ngaahi puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ko eni ʻae ngaahi faʻahinga ʻoe ngaahi foha ʻo Noa, mo honau ngaahi toʻutangata, ʻi honau ngaahi puleʻanga: pea naʻe vahe vahe ʻiate kinautolu ni ʻae ngaahi puleʻanga ʻo māmani, hili ʻae lōmaki. ");
INSERT INTO ton_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Pea naʻe ngutu taha pe ʻa māmani kotoa, mo lea taha pe. ");
INSERT INTO ton_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pea naʻe hoko, ʻi heʻenau fononga mei hahake, naʻa nau ʻilo ai ʻae toafa ʻi he fonua ko Saina; pea nau nofo ai. ");
INSERT INTO ton_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Pea naʻa nau fepehēʻaki, “Vakai, ke tau ngaohi ʻae makaʻumea, pea taʻo ia ke vela ʻaupito. Pea naʻa nau maka ʻaki ʻae makaʻumea, mo nau lahe ʻaki ʻae kelepulu.” ");
INSERT INTO ton_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Pea naʻa nau pehē, “Vakai, ke tau langa moʻotautolu ha kolo mo e fale māʻolunga, kae aʻu hono tuʻa fale ki langi; pea tau fakaongoongoa ʻa hotau hingoa, telia naʻa fakamovetevete ʻakitautolu ki he funga ʻo māmani kotoa.” ");
INSERT INTO ton_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pea naʻe hāʻele hifo ʻa Sihova, ke ʻafio ki he kolo mo e fale māʻolunga, ʻaia naʻe langa ʻe he fānau ʻae tangata. ");
INSERT INTO ton_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Pea naʻe pehē ʻe Sihova, “Vakai, ʻoku taha pe ʻae kakai, pea ʻoku nau lea taha pe; pea kuo nau kamata fai eni: pea ko eni, ʻe ʻikai taʻofia ʻakinautolu, ʻi ha meʻa kuo nau fakakaukau ke fai. ");
INSERT INTO ton_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Vakai, ke tau ʻalu hifo, pea veuveuki ʻenau lea, koeʻuhi ke ʻoua naʻa nau feʻiloaki lea.” ");
INSERT INTO ton_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ko ia naʻe fakamovetevete ai ʻakinautolu ʻe Sihova ki he funga ʻo māmani kotoa pē: pea naʻa nau tuku ʻae langa kolo. ");
INSERT INTO ton_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ko ia ʻoku ui ai hono hingoa ko Pepeli; koeʻuhi naʻe veuveuki ʻi ai ʻe Sihova ʻae lea ʻa māmani kotoa pē: pea naʻe fakamovetevete ʻakinautolu mei ai, ʻe Sihova, ki he funga ʻo māmani kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ko eni ʻae ngaahi toʻutangata ʻo Semi naʻe teau taʻu ʻae motuʻa ʻo Semi, pea fānau kiate ia ʻa ʻAfakisati ʻi hono ua taʻu hili ʻae lōmaki: ");
INSERT INTO ton_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Pea naʻe moʻui ʻa Semi hili ʻae fanauʻi ʻa ʻAfakisati ʻi he taʻu ʻe nimangeau, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Pea naʻe moʻui ʻa ʻAfakisati ʻi he taʻu ʻe tolungofulu ma nima, pea fānau kiate ia ʻa Sela: ");
INSERT INTO ton_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Pea naʻe moʻui ʻa ʻAfakisati, hili ʻae fanauʻi ʻa Sela, ʻi he taʻu ʻe fāngeau ma tolu, pea fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Pea naʻe moʻui ʻa Sela ʻi he taʻu ʻe tolungofulu, pea naʻe fānau kiate ia ʻa ʻIpela. ");
INSERT INTO ton_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Pea naʻe moʻui ʻa Sela hili ʻae fanauʻi ʻa ʻIpela ʻi he taʻu ʻe fāngeau ma tolu, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Pea naʻe moʻui ʻa ʻIpela ʻi he taʻu ʻe tolungofulu ma fā, pea naʻe fānau kiate ia ʻa Peleki: ");
INSERT INTO ton_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pea naʻe moʻui ʻa ʻIpela hili ʻae fanauʻi ʻo Peleki, ʻi he taʻu ʻe fāngeau ma tolungofulu, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pea naʻe moʻui ʻa Peleki ʻi he taʻu ʻe tolungofulu, pea naʻe fānau kiate ia ʻa Liu: ");
INSERT INTO ton_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pea naʻe moʻui ʻa Peleki hili ʻae fanauʻi ʻa Liu, ʻi he taʻu ʻe uangeau ma hiva, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Pea naʻe moʻui ʻa Liu ʻi he taʻu ʻe tolungofulu ma ua, pea naʻe fānau kiate ia ʻa Seluke: ");
INSERT INTO ton_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Pea naʻe moʻui ʻa Liu hili ʻae fanauʻi ʻa Seluke, ʻi he taʻu ʻe uangeau ma fitu, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Pea naʻe moʻui ʻa Seluke ʻi he taʻu ʻe tolungofulu, pea naʻe fānau kiate ia ʻa Nehoa; ");
INSERT INTO ton_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Pea naʻe moʻui ʻa Seluke hili ʻae fanauʻi ʻa Nehoa ʻi he taʻu ʻe uangeau, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Pea naʻe moʻui ʻa Nehoa ʻi he taʻu ʻe uofulu ma hiva, pea naʻe fānau kiate ia ʻa Tela: ");
INSERT INTO ton_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Pea naʻe moʻui ʻa Nehoa hili ʻae fanauʻi ʻa Tela ʻi he taʻu ʻe teau ma hongofulu ma hiva, pea naʻe fānau kiate ia ʻae ngaahi foha mo e ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pea naʻe moʻui ʻa Tela ʻi he taʻu ʻe fitungofulu, pea naʻe fānau kiate ia ʻa ʻEpalame, mo Nehoa, mo Halani. ");
INSERT INTO ton_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","¶ Pea ko eni ʻae hako ʻo Tela: naʻe fānau kia Tela ʻa ʻEpalame, mo Nehoa, mo Halani; pea naʻe fānau kia Halani ʻa Lote. ");
INSERT INTO ton_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Pea naʻe tomuʻa pekia ʻa Halani ʻi heʻene tamai ko Tela, ʻi he fonua naʻe fanauʻi ai ia, ko Ua ʻi Kalitia. ");
INSERT INTO ton_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Pea naʻe maʻu uaifi ʻa ʻEpalame mo Nehoa: ko e hingoa ʻoe uaifi ʻo ʻEpalame ko Selai, pea ko e hingoa ʻoe uaifi ʻo Nehoa ko Milika, ko e ʻofefine ʻo Halani, ko e tamai ʻa Milika, mo e tamai ʻa Isika. ");
INSERT INTO ton_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ka naʻe paʻa ʻa Selai; naʻe ʻikai haʻa ne tama. ");
INSERT INTO ton_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Pea naʻe ʻave ʻe Tela ʻa hono foha ko ʻEpalame, mo Lote ko e foha ʻo hono foha ko Halani, mo Selai ko hono ʻofefine ʻi he fono, ko e uaifi ʻo hono foha ko ʻEpalame; pea naʻa nau ʻalu atu mei Ua ʻi Kalitia, ke fononga ki he fonua ko Kēnani; pea naʻa nau hoko ki Halani, ʻo nofo ai. ");
INSERT INTO ton_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Pea ko e ngaahi ʻaho ʻo Tela ko e taʻu ʻe uangeau ma nima; pea naʻe pekia ʻa Tela ʻi Halani. ");
INSERT INTO ton_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ka ko eni, kuo pehē ʻe Sihova kia ʻEpalame, “ʻAlu koe ʻi ho fonua, pea mei ho kāinga, pea mei he fale ʻo hoʻo tamai, ki ha fonua te u fakahā kiate koe: ");
INSERT INTO ton_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Pea te u fakatupu ʻiate koe ha puleʻanga lahi, pea te u tāpuakiʻi koe, pea ngaohi ho hingoa ke lahi; pea te ke hoko ko e tāpuaki: ");
INSERT INTO ton_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Pea te u fakamonūʻia, ʻakinautolu ʻe tāpuakiʻi koe, pea fakamalaʻia ia ʻe kapeʻi koe: pea ʻe monūʻia ʻiate koe ʻae ngaahi faʻahinga kotoa pē ʻo māmani.” ");
INSERT INTO ton_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ko ia naʻe ʻalu ʻa ʻEpalame, ʻo hangē ko e folofola ʻa Sihova kiate ia; pea ʻalu ʻa Lote mo ia: pea naʻe fitungofulu ma nima taʻu ʻae motuʻa ʻo ʻEpalame ʻi heʻene ʻalu mei Halani. ");
INSERT INTO ton_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Pea naʻe ʻave ʻe ʻEpalame ʻa hono uaifi ko Selai, mo Lote ko e foha ʻo hono tokoua, mo e nau ngaahi meʻa kotoa pē kuo nau tānaki, mo e kakai kuo nau maʻu ʻi Halani; pea naʻa nau ʻalu atu ke fononga ki he fonua ko Kēnani; pea naʻa nau hoko ai ki he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","¶ Pea naʻe ʻalu atu ʻa ʻEpalame ʻi he fonua ki he potu ʻo Sikemi, ki he potu ʻakauʻia ʻo Mole. Pea ko e kakai Kēnani naʻe ʻi he fonua ʻi he kuonga ko ia. ");
INSERT INTO ton_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Pea naʻe hā mai ʻa Sihova kia ʻEpalame, ʻo ne pehē, “Te u foaki ʻae fonua ni ki ho hako:” pea naʻe fokotuʻu ai ʻe ia ʻae ʻesifeilaulau kia Sihova, ʻaia naʻe hā kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Pea naʻe hiki ia mei ai ki ha moʻunga ʻi he potu hahake ʻo Peteli, pea ne fokotuʻu hono fale fehikitaki, ʻoku ʻi hihifo ʻa Peteli, mo ʻAi ʻi hahake: pea ne fokotuʻu ai ʻae ʻesifeilaulau kia Sihova, pea ui ʻe ia ki he huafa ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Pea naʻe fononga ʻa ʻEpalame, ʻo ne kei ʻalu atu ki he feituʻu tonga. ");
INSERT INTO ton_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","¶ Pea naʻe hoko ʻae honge ʻi he fonua: pea naʻe ʻalu hifo ʻa ʻEpalame ki ʻIsipite ke nofo ai: he kuo lahi ʻae honge ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Pea naʻe pehē, ʻi heʻene hoko ʻo ofi atu ki ʻIsipite, naʻe pehē ʻe ia kia Selai ko hono uaifi, “Vakai mai, ʻoku ou ʻilo ko e fefine hoihoifua koe ke sio ki ai: ");
INSERT INTO ton_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Pea ko ia, ka mamata ʻae kakai ʻIsipite kiate koe, te nau pehē, ‘Ko hono uaifi eni:’ pea te nau tāmateʻi au, ka te nau fakamoʻui koe. ");
INSERT INTO ton_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","‌ʻOku ou kole kiate koe, ke ke pehē, ko hoku tuofefine koe: kae lelei ai au koeʻuhi ko koe; pea ʻe moʻui ʻa hoku laumālie koeʻuhi ko koe.” ");
INSERT INTO ton_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","¶ Pea naʻe pehē, ʻi he ʻalu atu ʻa ʻEpalame ki ʻIsipite, naʻe vakai ʻe he kakai ʻIsipite ki he hoihoifua ʻaupito ʻoe fefine. ");
INSERT INTO ton_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Naʻe mamata foki kiate ia ʻae houʻeiki ʻa Felo, pea naʻa nau fakaongolelei ia kia Felo: pea naʻe ʻave ʻae fefine ki he fale ʻo Felo. ");
INSERT INTO ton_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pea naʻe fai lelei ʻe ia kia ʻEpalame koeʻuhi ko ia: pea naʻa ne maʻu ʻae fanga sipi, mo e fanga manu, mo e fanga ʻasi tangata, mo e kau tamaioʻeiki, mo e kau kaunanga, mo e fanga ʻasi fefine, mo e fanga kāmeli. ");
INSERT INTO ton_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pea naʻe tautea ʻe Sihova ʻa Felo mo hono fale ʻaki ʻae ngaahi hangatāmaki lahi koeʻuhi ko Selai ko e uaifi ʻo ʻEpalame. ");
INSERT INTO ton_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Pea naʻe ui ʻa Felo kia ʻEpalame, ʻo ne pehē, “Ko e hā eni kuo ke fai kiate au? Ko e hā naʻe ʻikai ai te ke tala mai ko ho uaifi ia? ");
INSERT INTO ton_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ko e hā naʻa ke pehē ai, ‘Ko hoku tuofefine eni?’ Ne u meimei maʻu ia ko e uaifi kiate au; pea ko eni, vakai ki ho uaifi, ʻave ia pea ke ʻalu.” ");
INSERT INTO ton_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Pea naʻe fonosi ʻe Felo ki heʻene kau tangata koeʻuhi ko ia: pea naʻa nau fekau ia ke ʻalu, mo hono uaifi, mo ia kotoa pē naʻa ne maʻu. ");
INSERT INTO ton_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Pea naʻe ʻalu hake ʻa ʻEpalame mei ʻIsipite, ko ia, mo hono uaifi, mo ia kotoa pē naʻa ne maʻu, pea naʻa nau ō mo Lote, ki he feituʻu tonga. ");
INSERT INTO ton_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Pea naʻe koloaʻia ʻaupito ʻa ʻEpalame ʻi he fanga manu, mo e siliva, mo e koula. ");
INSERT INTO ton_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Pea ʻalu ai pe ia ʻi hono fononga mei he feituʻu tonga ʻo aʻu ki Peteli, ki he potu naʻe tuʻu ai ʻa hono fale fehikitaki he kamataʻanga, ʻi he vahaʻa ʻo Peteli mo ʻAi: ");
INSERT INTO ton_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ki he potu ʻoe ʻesifeilaulau, ʻaia naʻa ne tomuʻa fokotuʻu: pea naʻe ui ai ʻa ʻEpalame ki he huafa ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","¶ Pea naʻe maʻu ʻe Lote foki, ʻaia naʻe ō mo ʻEpalame, ʻae fanga sipi, mo e fanga manu, mo e ngaahi fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Pea naʻe siʻi ʻae fonua kiate kinaua ke na nofo fakataha: he naʻe lahi ʻaupito ʻena meʻa, ko ia naʻe ʻikai ai te na faʻa nofo fakataha. ");
INSERT INTO ton_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Pea naʻe ai ha kē ʻi he kau tauhimanu ʻa ʻEpalame mo e kau tauhimanu ʻa Lote: pea naʻe kei nofo ʻae kakai Kēnani mo e kau Pelisi ʻi he fonua, ʻi he kuonga ko ia. ");
INSERT INTO ton_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Pea naʻe pehē ʻe ʻEpalame kia Lote, “ʻOku ou kole kiate koe, ke ʻoua naʻa ai ha kē ʻiate kitaua, pe ʻi heʻeku kau tauhimanu mo hoʻo kau tauhimanu; he ʻoku ta kāinga. ");
INSERT INTO ton_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","‌ʻIkai ʻoku ʻi ho ʻao ʻae fonua kotoa? ʻOku ou kole kiate koe, ke mavahe koe ʻiate au: kapau te ke ʻi he toʻohema pea te u ʻalu au ki he toʻomataʻu; pea kapau te ke ʻalu ki he toʻomataʻu, pea te u ʻalu au ki he toʻohema.” ");
INSERT INTO ton_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Pea naʻe sio hake ʻa Lote, pea vakai ʻe ia ki he fonua fakalelei kotoa pē ʻo Sioatani, kuo lahi ʻae vai ʻi he potu kotoa pē. ʻI he teʻeki ke fakaʻauha ʻe Sihova ʻa Sotoma mo Komola, naʻe hangē ia ko e ngoue ʻa Sihova, ʻo tatau mo e fonua ko ʻIsipite, ʻi he halaifonua ki Soa. ");
INSERT INTO ton_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Pea naʻe fili ʻe Lote maʻana, ʻae fonua tokalelei kotoa pē ʻo Sioatani; pea fononga ʻa Lote ki he feituʻu hahake: pea naʻe fakamāvae ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Naʻe nofo ʻa ʻEpalame ʻi he fonua ko Kēnani, pea nofo ʻa Lote ʻi he ngaahi kolo ʻoe tokalelei, pea naʻa ne fokotuʻu hono fale fehikitaki ke hanga ki Sotoma. ");
INSERT INTO ton_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ka naʻe kovi ʻae kakai ʻo Sotoma, pea angahala ʻaupito ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","¶ Pea naʻe folofola ʻa Sihova kia ʻEpalame, hili ʻae māvae ʻa Lote meiate ia, “Tangaki hake ni ho mata, pea sio mei he potu ʻoku ke ʻi ai ki he tokelau mo e tonga, pea ki he hahake, mo hihifo: ");
INSERT INTO ton_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","He ko e fonua kotoa pē ʻoku ke mamata ai, te u foaki ia kiate koe, pea ki ho hako ʻo lauikuonga. ");
INSERT INTO ton_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Pea te u fakatupu ho hako ke hangē ko e efu ʻoe kelekele: pea kapau ʻe faʻa lau ʻe ha tangata ʻae efu ʻoe kelekele, pehē, ʻe lau foki ʻa ho hako. ");
INSERT INTO ton_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Tuʻu hake, pea ʻalu atu ʻi he fonua, ʻi hono lōloa mo hono māukupu ʻo ia he te u foaki ia kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Pea naʻe toki hiki ʻe ʻEpalame hono fale fehikitaki, pea haʻu ʻo nofo ʻi he fonua tokalelei ʻo Mamili, ʻaia ʻoku ʻi Hepeloni, pea naʻe fokotuʻu ai ʻae ʻesifeilaulau kia Sihova. ");
INSERT INTO ton_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pea naʻe hoko ʻi he ngaahi ʻaho ʻo ʻAmilafeli ko e tuʻi ʻo Saina, mo ʻAlioke ko e tuʻi ʻo ʻIlasa, mo Kitaleoma. Ko e tuʻi ʻo ʻIlami, mo Titale ko e tuʻi ʻoe ngaahi puleʻanga; ");
INSERT INTO ton_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Naʻa nau tau mo Pila ko e tuʻi ʻo Sotoma, mo Pilisa ko e tuʻi ʻo Komola, mo Sinape ko e tuʻi ʻo ʻAtima, mo Semipa ko e tuʻi ʻo Sepoimi, mo e tuʻi ʻo Pila ʻaia ʻoku ui ko Soa. ");
INSERT INTO ton_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Naʻe kātoa fakataha ʻakinautolu kotoa pē ʻi he teleʻa ʻo Sitimi, ʻaia ko e tahi māsima. ");
INSERT INTO ton_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Naʻa nau tauhi kia Kitaleoma ʻi he taʻu ʻe hongofulu ma ua, pea nau angatuʻu ʻi hono hongofulu ma tolu ʻoe taʻu. ");
INSERT INTO ton_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pea naʻe haʻu ʻa Kitaleoma ʻi hono hongofulu ma fā ʻoe taʻu, mo e ngaahi tuʻi naʻe ʻiate ia, pea taaʻi ʻae kakai Lifeime ʻi ʻAsitelote Kaneime, mo e kakai Susi ʻi Hami, mo e kakai Imime ʻi Seva Kiliateimi, ");
INSERT INTO ton_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Mo e kau Hoa ʻi honau moʻunga ko Seia, ʻo aʻu ki ʻEli-Pelani, ʻaia ʻoku ofi ki he toafa. ");
INSERT INTO ton_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Pea naʻa nau liu mai, ʻo hoko ki ʻEni-Misipate, ʻaia ko Ketesi, ʻo nau taaʻi ʻae fonua kotoa pē ʻoe kakai ʻAmaleki, mo e kakai ʻAmoli foki, ʻaia naʻe nofo ʻi Hesisone Tamali. ");
INSERT INTO ton_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Pea naʻe ʻalu atu ʻae tuʻi ʻo Sotoma, mo e tuʻi ʻo Komola, mo e tuʻi ʻo ʻAtima, mo e tuʻi ʻo Sepoime, mo e tuʻi ʻo Pila (ʻa ia ko Soa;) pea nau tali tau kiate kinautolu ʻi he teleʻa ʻo Sitimi; ");
INSERT INTO ton_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Kia Kitaleoma ko e tuʻi ʻo ʻIlami, mo Titale ko e tuʻi ʻoe ngaahi puleʻanga, mo ʻAmilafeli ko e tuʻi ʻo Saina, mo ʻAlioke ko e tuʻi ʻo ʻIlasa; ko e tuʻi ʻe toko fā ki he toko nima. ");
INSERT INTO ton_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Pea naʻe fonu ʻae teleʻa ʻo Sitimi ʻi he ngaahi luo kelepulu: pea naʻe hola ʻae ngaahi tuʻi ʻo Sotoma mo Komola pea hinga ʻi ai; pea ko kinautolu naʻe toe naʻa nau hola ki he moʻunga. ");
INSERT INTO ton_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Pea naʻa nau veteki ʻae koloa kotoa pē ʻo Sotoma mo Komola, mo e meʻakai kotoa pē ʻi ai, pea nau ʻalu. ");
INSERT INTO ton_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Pea naʻa nau ʻave ʻa Lote, ko e foha ʻoe tokoua ʻo ʻEpalame, ʻaia naʻe nofo ʻi Sotoma, mo ʻene ngaahi meʻa, pea nau ʻalu. ");
INSERT INTO ton_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","¶ Pea naʻe haʻu ʻae tokotaha naʻe hao ʻo fakahā kia ʻEpalame ko e Hepelū; he naʻe nofo ia ʻi he potu tokalelei ʻo Mamili, ko e tangata ʻAmoli, ko e tokoua ʻo ʻEsikoli, mo e tokoua ʻo ʻAneli; pea naʻa nau kau taha pe mo ʻEpalame. ");
INSERT INTO ton_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Pea kuo fanongo ʻa ʻEpalame kuo ʻave pōpula ʻa hono kāinga, pea ne tuku ʻae mahafutau ki hono kau nofoʻanga naʻe tupu ʻi hono fale, ko e toko tolungeau mo e toko hongofulu ma toko valu, pea ne tuli ʻakinautolu ki Tani. ");
INSERT INTO ton_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Pea ne vahevahe ʻakinautolu, ʻaia mo hono kau nofoʻanga ʻi he poʻuli, pea ne teʻia ʻakinautolu, ʻo ne tuli ʻakinautolu ki Hopa, ʻaia ʻoku tuʻu ki he toʻohema ʻo Tamasikusi. ");
INSERT INTO ton_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Pea naʻa ne toe maʻu ʻae koloa kotoa pē, pea ne toe ʻomi ʻa hono kāinga ko Lote, mo ʻene ngaahi meʻa mo e kau fefine mo e kakai. ");
INSERT INTO ton_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","¶ Pea naʻe ʻalu ʻae tuʻi ʻo Sotoma ke fakafetaulaki kia ʻEpalame ʻi heʻene liu mai mei he taaʻi ʻa Kitaleoma mo e ngaahi tuʻi, naʻe ʻiate ia ʻi he teleʻa ʻo Seve, ʻaia ko e teleʻa ʻoe tuʻi. ");
INSERT INTO ton_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Pea ʻomi ʻe Melekiseteki ko e tuʻi ʻo Selemi ʻae mā mo e uaine: pea ko e taulaʻeiki ia ʻoe ʻOtua fungani māʻolunga. ");
INSERT INTO ton_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Pea naʻa ne tāpuaki ia ʻo pehē, “ʻOku monūʻia ʻa ʻEpalame, ʻi he ʻOtua fungani māʻolunga ʻaia ʻoku ʻoʻona ʻae langi mo māmani. ");
INSERT INTO ton_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Pea ke monūʻia mo e ʻOtua fungani māʻolunga, ʻaia kuo ne tuku ho ngaahi fili ki ho nima. Pea naʻa ne tukuhau kiate ia, ʻi he meʻa kotoa pē.” ");
INSERT INTO ton_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Pea pehē ʻe he tuʻi ʻo Sotoma kia ʻEpalame, “Tuku mai kiate au ʻae kakai, pea ke toʻo maʻau ʻae ngaahi meʻa.” ");
INSERT INTO ton_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pea talaange ʻe ʻEpalame ki he tuʻi ʻo Sotoma, “Naʻaku hiki hoku nima kia Sihova, ko e ʻOtua fungani māʻolunga, ʻoku ʻoʻona ʻae langi, mo māmani, ");
INSERT INTO ton_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Koeʻuhi ʻe ʻikai te u toʻo ha foʻi lou filo pe ha nonoʻo ʻoe topuvaʻe, pea ʻe ʻikai te u toʻo ha meʻa ʻe taha meiate koe, telia naʻa pehē ʻe koe, ‘Kuo u fakakoloaʻia ʻa ʻEpalame.’ ");
INSERT INTO ton_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ka ko e meʻa kuo kai ʻe he kau talavou, pea mo e ʻinasi ki he kau tangata naʻa mau o mo au, ko ʻAneli, mo ʻEsikoli, mo Mamili; tuku ke nau toʻo honau ʻinasi.” ");
INSERT INTO ton_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pea hili ʻae ngaahi meʻa ni, naʻe haʻu ʻae folofola ʻa Sihova kia ʻEpalame ʻi he meʻa hā mai ʻo pehē, “ʻOua naʻa ke manavahē ʻEpalame: ko ho ungaʻanga au, mo ho totongi lahi ʻaupito.” ");
INSERT INTO ton_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Pea pehēange ʻe ʻEpalame, “E Sihova ko e ʻOtua, ko e hā te ke foaki kiate au, he ʻoku ou masiva fānau, pea ko e tauhi ʻo hoku ʻapi, ko e ʻEliesa ni ʻo Tamasikusi?” ");
INSERT INTO ton_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Pea pehē ʻe ʻEpalame, “Vakai, naʻe ʻikai te ke foaki kiate au ha hako; pea vakai, ko e taha naʻe fānau ʻi hoku fale, ko hoku hoko ia.” ");
INSERT INTO ton_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pea ʻiloange, naʻe folofola mai ʻa Sihova kiate ia, ʻo pehē, “ʻOku ʻikai ko ho hoko ia: ka ko ia ʻe tupu mei ho fatu ʻoʻou ko ho hoko ia.” ");
INSERT INTO ton_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Pea ne taki atu ia kituaʻā, ʻo ne pehē, “Hanga hake ni ki he langi, ʻo lau ʻae ngaahi fetuʻu, ʻo kapau te ke faʻa lau ia; pea ne pehē kiate ia, E tatau mo ia ho hako.” ");
INSERT INTO ton_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Pea naʻe tui ia kia Sihova; pea naʻe lau ia kiate ia, ko e māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Pea naʻa ne pehē kiate ia, “Ko au ko Sihova, naʻaku ʻomi koe mei Ua, ʻi Kalitia, ke foaki kiate koe ʻae fonua ni, ke ke maʻu moʻou.” ");
INSERT INTO ton_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pea ne pehē ʻe ia, “E Sihova ko e ʻOtua, te u ʻilo ʻi he ha te u maʻu ia? ");
INSERT INTO ton_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Pea ne pehē kiate ia, “Toʻo mai maʻaku ʻae pulu fefine mui ʻoku tolu taʻu hono motuʻa, mo e kosi fefine ʻoku tolu taʻu hono motuʻa, mo e sipitangata ʻoku tolu taʻu hono motuʻa, mo e kulukulu mo e lupe mui.” ");
INSERT INTO ton_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Pea ne toʻo ʻae ngaahi meʻa ni kotoa pē, ʻo ne fahiua ʻakinautolu, ʻo tuku fakaholo ʻae ngaahi konga kotoa pē, ka naʻe ʻikai te ne fahiʻi ʻae fanga manupuna. ");
INSERT INTO ton_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pea ʻi he lolofa mai ʻae fanga manupuna ki he ngaahi ʻangaʻanga, naʻe fakahēhē ia ʻe ʻEpalame. ");
INSERT INTO ton_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Pea ʻi he kamata tō ʻae laʻā, naʻe hoko ʻae mohe maʻu kia ʻEpalame: pea vakai naʻe tō kiate ia ʻae fuʻu manavahē ʻoe fakapoʻuli lahi. ");
INSERT INTO ton_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Pea naʻe pehē kia ʻEpalame, “Ke ke ʻilo pau eni, ʻe nofo ʻāunofo ho hako ʻi ha fonua ʻoku ʻikai ʻonautolu, pea te nau tauhi ʻakinautolu; pea te nau fakamamahi ʻakinautolu ʻi he taʻu ʻe fāngeau. ");
INSERT INTO ton_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pea ko e puleʻanga ko ia te nau ngāue ki ai, te u fakamaauʻi foki: pea hili ia te nau haʻu mei ai mo e koloa lahi. ");
INSERT INTO ton_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pea te ke ʻalu koe ki hoʻo ngaahi tamai ʻi he fiemālie: ʻe pekia koe ʻoka ke ka motuʻa lelei. ");
INSERT INTO ton_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Pea ʻi hono fā ʻoe toʻutangata te nau toe haʻu ki heni; he ʻoku teʻeki ai fonu ʻae angahala ʻae kakai ʻAmoli.” ");
INSERT INTO ton_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Pea ʻi he tō ʻae laʻā pea poʻuli, vakai, naʻe ʻi ai ʻae afi kakaha kuo kohu, mo e maama ulo naʻe ʻalu ʻi he vahaʻa ʻoe ngaahi konga manu. ");
INSERT INTO ton_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","‌ʻI he ʻaho ko ia naʻe fai ʻe Sihova ʻae fuakava mo ʻEpalame, ʻo pehē, “Kuo u tuku ki ho hako ʻae fonua ni, mei he vaitafe ʻo ʻIsipite ʻo aʻu ki he vaitafe lahi, ʻaia ko e ʻIufaletesi. ");
INSERT INTO ton_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ko e kakai Kena, mo e kakai Kenisai mo e kakai Katimona. ");
INSERT INTO ton_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Mo e kakai Heti, mo e kakai Pelisi, mo e kakai Lifeime, ");
INSERT INTO ton_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Mo e kakai ʻAmoli, mo e kakai Kēnani, mo e kakai Kilikesa, mo e kakai Sepusi.” ");
INSERT INTO ton_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Pea ko Selai, ko e uaifi ʻo ʻEpalame, naʻe ʻikai siʻi haʻane fānau; ka naʻe ʻiate ia ʻae kaunanga, ko e fefine ʻIsipite, ko Hekaʻā hono hingoa. ");
INSERT INTO ton_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Pea naʻe lea ʻa Selai kia ʻEpalame, “Vakai mai, kuo taʻofi au ʻe Sihova, ke ʻoua naʻaku fānau; pea ʻoku ou tala atu kiate koe, ke ke ʻalu ki heʻeku kaunanga; heiʻilo te u maʻu ʻae fānau ʻiate ia. Pea naʻe tokanga ʻa ʻEpalame ki he lea ʻa Selai. ");
INSERT INTO ton_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Pea ʻave ʻe Selai, ko e uaifi ʻo ʻEpalame, ʻene kaunanga ko Hekaʻā ko e ʻIsipite ʻo ne ʻatu ia ki hono husepāniti ko ʻEpalame ke uaifi ʻaki, hili ʻenau nofo ʻi he fonua ko Kēnani, ʻi he taʻu ʻe hongofulu.” ");
INSERT INTO ton_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","¶ Pea naʻe ʻalu ia kia Hekaʻā, pea feitama ia; pea ʻi heʻene ʻilo ia ʻoku ne feitama, naʻa ne taukaeʻi hono ʻeiki fefine ʻi hono mata. ");
INSERT INTO ton_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Pea pehē ʻe Selai kia ʻEpalame, “Ke ʻiate koe ʻeku mamahi: Naʻaku foaki ʻeku kaunanga ki ho fatafata: pea kuo mamata ia kuo feitama, peau kovi leva ʻi hono mata: ke fakamaau ʻe Sihova ʻiate kitaua.” ");
INSERT INTO ton_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ka naʻe pehē ʻe ʻEpalame kia Selai, “Vakai, ʻoku ʻi ho nima hoʻo kaunanga; ke ke fai kiate ia hoʻo faʻiteliha.” Pea ʻi he fai fakamālohi ʻe Selai kiate ia, naʻa ne hola ia mei hono ʻao. ");
INSERT INTO ton_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Pea ʻilo ia ʻe he ʻāngelo ʻa Sihova ʻo ofi ki ha vai ʻi he toafa, ʻae vai ʻoku ʻi he hala ki Sua. ");
INSERT INTO ton_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Pea ne pehē, “Hekaʻā, ko e kaunanga ʻa Selai, Kuo ke haʻu mei fē? Pea te ke ʻalu ki fē?” Pea pehēange ʻe ia, “ʻOku ou hola mei he ʻao ʻo ʻeku fineʻeiki ko Selai.” ");
INSERT INTO ton_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Pea pehē ʻe he ʻāngelo ʻa Sihova kiate ia. “Toe ʻalu ki ho fineʻeiki, mo ke fakavaivaiʻi koe kiate ia.” ");
INSERT INTO ton_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Pea pehē ʻe he ʻāngelo ʻa Sihova kiate ia, “Te u fakatupu ho hako ke tokolahi ʻaupito, pea ʻe ʻikai faʻa lau hono tokolahi.” ");
INSERT INTO ton_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pea pehē ʻe he ʻāngelo ʻa Sihova kiate ia, “Vakai, ʻoku ke feitama, pea te ke fāʻeleʻi ʻae tama, pea te ke ui hono hingoa ko ʻIsimeʻeli; “he kuo ongoʻi ʻe Sihova ʻa hoʻo mamahi.” ");
INSERT INTO ton_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Pea ʻe hoko ia ko e tangata hehengi; ʻe hiki hake ʻe ia hono nima ki he tangata kotoa pē, pea ʻe hiki hake ʻe he tangata kotoa pē hono nima kiate ia; pea ʻe nofo ia ʻi he ʻao ʻo hono kāinga kotoa pē.” ");
INSERT INTO ton_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Pea naʻa ne ui ʻae huafa ʻo Sihova naʻe folofola kiate ia, “Ko e ʻOtua koe ʻoku ke ʻafioʻi au: he naʻa ne pehē, ‘He ʻikai foki kuo u siofia ia ʻaia ʻoku ʻafio kiate au?’” ");
INSERT INTO ton_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ko ia ʻoku ui ai ʻae vai ko ia, “ko Pea-Lehai-Loʻai;” vakai ʻoku tuʻu ia ʻi he vahaʻa ʻo Ketesi mo Peleti. ");
INSERT INTO ton_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","¶ Pea naʻe fanauʻi ʻe Hekaʻā ʻae tama kia ʻEpalame; pea ui ʻe ʻEpalame hono foha, naʻe fanauʻi ʻe Hekaʻā, ko ʻIsimeʻeli. ");
INSERT INTO ton_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Pea naʻe valungofulu ma ono taʻu ʻae motuʻa ʻo ʻEpalame ʻi he fanauʻi ʻe Hekaʻā ʻa ʻIsimeʻeli kia ʻEpalame. ");
INSERT INTO ton_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Pea ʻi he hivangofulu ma hiva taʻu ʻoe motuʻa ʻo ʻEpalame naʻe hā mai ʻa Sihova kia ʻEpalame, ʻo ne pehē kiate ia, “Ko au, ko e ʻOtua Māfimafi; ke ke ʻeveʻeva ʻi hoku ʻao, pea ke haohaoa. ");
INSERT INTO ton_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Pea te u fai ʻa ʻeku fuakava ʻiate koe mo au, pea te u fakatokolahi ʻaupito koe.” ");
INSERT INTO ton_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Pea tō foʻohifo ʻa ʻEpalame ki he kelekele pea folofola ʻae ʻOtua kiate ia, ʻo pehē; ");
INSERT INTO ton_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ko au eni, Vakai, ʻoku ʻiate koe ʻeku fuakava, pea te ke hoko ko e tamai ki he ngaahi puleʻanga lahi; ");
INSERT INTO ton_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Pea ʻe ʻikai toe ui ho hingoa ko ʻEpalame, ka ko ʻEpalahame ho hingoa, he kuo u ngaohi koe “ko e tamai ki he ngaahi puleʻanga lahi.” ");
INSERT INTO ton_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Pea te u ngaohi koe ke ke tupu ʻo tokolahi ʻaupito, pea te u ngaohi ʻae ngaahi puleʻanga lahi ʻiate koe, pea ʻe tupu ʻae ngaahi tuʻi ʻiate koe. ");
INSERT INTO ton_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Pea te u fakamaau ʻeku fuakava kiate koe, mo ho hako ʻe tupu ʻiate koe ʻamui, ʻi heʻenau ngaahi toʻutangata, ko e fuakava taʻengata, ke u ʻiate koe, ko e ʻOtua, pea ki ho hako ki mui ʻiate koe. ");
INSERT INTO ton_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Pea te u foaki kiate koe, pea mo ho hako ʻe hoko mo koe, ʻae fonua ʻoku ke ʻāunofo ki ai, ʻio ʻae fonua kotoa pē ʻo Kēnani, ko e tofiʻa taʻengata; pea teu ʻiate kinautolu ko honau ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","¶ Pea pehē ʻe he ʻOtua kia ʻEpalahame, “Ko ia te ke tauhi ai ʻeku fuakava, ʻa koe mo ho hako ʻe hoko mo koe ʻi honau ngaahi toʻutangata. ");
INSERT INTO ton_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ko eni ʻa ʻeku fuakava, ʻaia te mou tauhi, kiate au mo kimoutolu mo ho hako ʻe tupu ʻamui ʻiate koe; E kamu ʻae tamasiʻi tangata kotoa pē ʻoku ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Pea te mou kamu ʻae kili ʻo homou potu; pea ko e fakaʻilonga ia ʻoe fuakava kiate au mo kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pea ko ia ʻiate kimoutolu ʻoku ʻaho valu hono motuʻa ʻe kamu ia, ʻae tama tangata kotoa pē ʻi homou ngaahi toʻutangata, ko ia kuo fanauʻi ho fale, mo ia ʻoku ʻikai ʻi hoʻo fānau, ka kuo fakatauʻaki hoʻo koloa mei he muli. ");
INSERT INTO ton_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ko ia ʻe tupu ʻi ho fale, mo ia kuo fakatauʻaki hoʻo koloa ke ke kamu ia; pea ʻe ʻi homou sino ʻeku fuakava, ko e fuakava taʻengata ia. ");
INSERT INTO ton_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Pea ko e tamasiʻi taʻekamu, ʻe motuhi ʻae laumālie ko ia mei hono kakai; he kuo ne siʻaki ʻeku fuakava.” ");
INSERT INTO ton_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","¶ Pea naʻe pehē ʻe he ʻOtua kia ʻEpalahame, “Pea koeʻuhi ko Selai ko ho uaifi, ʻe ʻikai te ke ui hono hingoa ko Selai, ka ko Sela hono hingoa. ");
INSERT INTO ton_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Pea te u tāpuaki ia, ʻo tuku kiate koe ʻae foha ʻiate ia; ʻio, te u tāpuaki ia, pea ʻe hoko ia, ko e faʻē ki he ngaahi puleʻanga; ʻe tupu ʻiate ia ʻae ngaahi tuʻi ʻoe kakai.” ");
INSERT INTO ton_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Pea tō foʻohifo ai ʻa ʻEpalahame ki he kelekele pea kata, ʻo ne pehē ʻi hono loto, “E tupu ha tama ʻiate ia ʻoku teau taʻu hono motuʻa? Pea ʻe feitama ʻa Sela, ʻaia ʻoku hivangofulu hono taʻu? ");
INSERT INTO ton_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Pea pehēange ʻe ʻEpalahame ki he ʻOtua, ʻofa ke moʻui ʻa ʻIsimeʻeli ʻi ho ʻao.” ");
INSERT INTO ton_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Pea pehē ʻe he ʻOtua, “Ko e moʻoni ʻe fanauʻi ʻe ho uaifi ko Sela, ha tama kiate koe; pea te ke ui hono hingoa ko ʻAisake: pea te u fakamaau ʻeku fuakava kiate ia, ko e fuakava taʻengata pea mo hono hako ʻe hoko mo ia. ");
INSERT INTO ton_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pea koeʻuhi ko ʻIsimeʻeli, kuo u fanongo kiate koe; “Vakai, kuo u tāpuaki ia, pea te u ngaohi ke tokolahi ʻaupito ia; te ne fakatupu ʻae ʻeiki ʻe toko hongofulu ma toko ua, pea te u ngaohi ia ko e puleʻanga lahi. ");
INSERT INTO ton_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ka ko ʻeku fuakava te u fakamaau ia kia ʻAisake, ʻaia ʻe fanauʻi ʻe Sela kiate koe, ʻi he kuonga totonu ʻi he taʻu ʻe hoko mai ni.” ");
INSERT INTO ton_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pea ngata ai ʻene lea kiate ia, pea hāʻele hake ʻae ʻOtua meia ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","¶ Pea ʻave ʻe ʻEpalahame hono foha ko ʻIsimeʻeli, mo kinautolu kotoa pē naʻe fāʻele ʻi hono fale, mo kinautolu kotoa pē naʻe fakatauʻaki ʻene koloa: ʻae tama tangata kotoa pē ʻi he fale ʻo ʻEpalahame; ʻo ne kamu ʻakinautolu ʻi he ʻaho ko ia, ʻo hangē ko ia naʻe folofolaʻaki ʻe he ʻOtua kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Pea naʻe hivangofulu ma hiva taʻu ʻae motuʻa ʻo ʻEpalahame, ʻi hono kamu. ");
INSERT INTO ton_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Pea naʻe hongofulu ma tolu taʻu hono foha ko ʻIsimeʻeli, ʻi he kamu ʻae kili ʻo hono potu. ");
INSERT INTO ton_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","‌ʻI he ʻaho pe taha ko ia naʻe kamu ai ʻa ʻEpalahame mo hono foha ko ʻIsimeʻeli, ");
INSERT INTO ton_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Pea mo e tangata kotoa pē ʻo hono fale, naʻe tupu ʻi hono fale, pe fakatauʻaki ʻene koloa mei he muli, naʻa nau kamu kotoa pē mo ia. ");
INSERT INTO ton_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Pea naʻe hā mai ʻa Sihova kiate ia ʻi he fonua ʻo Mamili, ʻi heʻene nofo ʻi he matapā ʻoe fale fehikitaki ʻi he pupuha ʻoe ʻaho. ");
INSERT INTO ton_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Pea hanga hake ʻe ia hono mata ʻo sio, pea vakai, ʻoku tutuʻu mai ʻae tangata ʻe toko tolu kiate ia: pea ʻi heʻene mamata ki ai, naʻa ne lele mei he matapā ʻoe fale fehikitaki, ke fakafetaulaki kiate kinautolu, pea naʻe punou hifo ia ki he kelekele, ");
INSERT INTO ton_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","‌ʻO ne pehē, “Ko hoku ʻEiki, ko eni, kapau kuo u maʻu ʻae lelei ʻi ho ʻao, ʻofa ke ʻoua naʻa ke ʻalu mei hoʻo tamaioʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tuku ke ʻomi ha vai siʻi, pea fufulu homou vaʻe, pea mou mālōlō ʻi he lolo ʻakau. ");
INSERT INTO ton_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Pea te u ʻomi ha konga mā, pea fakafiemālie homou loto; pea hili ia te mou ʻalu; he ko ia kuo mou haʻu ai ki hoʻomou tamaioʻeiki.” Pea naʻa nau pehē, “Ke ke fai ʻo hangē ko hoʻo lea.” ");
INSERT INTO ton_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Pea ʻalu fakatoʻotoʻo ʻa ʻEpalahame ki he fale, kia Sela ʻo ne pehē, “Teuteu fakavave ʻae fua ʻe tolu ʻoe mahoaʻa lelei ʻo natu ia, ʻo ngaohi ʻaki ʻae ngaahi foʻi mā, pea taʻo ia ʻi he ngotoʻumu. ");
INSERT INTO ton_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Pea lele ʻa ʻEpalahame ki he fanga manu, ʻo ne toʻo mei ai ʻae ʻuhiki pulu molu mo lelei, ʻo ne ʻatu ia ki ha talavou pea naʻa ne fakatoʻotoʻo ʻa hono ngaohi. ");
INSERT INTO ton_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Pea ne toʻo mai ʻae pota, mo e huʻahuhu, pea mo e ʻuhiki pulu naʻa ne ngaohi, ʻo ne tuku ia ʻi honau ʻao; pea tuʻu ia ʻo ofi kiate kinautolu ʻi he lolo ʻakau, pea naʻa nau kai.” ");
INSERT INTO ton_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","¶ Pea nau pehē kiate ia, “Ko e fē ʻa Sela, ko ho uaifi?” Pea pehēange ʻe ia, “Vakai, ʻoku ʻi he fale fehikitaki ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Pea ne pehē, “Ko e moʻoni te u toe haʻu kiate koe, ʻi he kuonga totonu; pea vakai, ʻe maʻu ʻe ho uaifi ko Sela, ha tama.” Pea naʻe ongoʻi ʻe Sela ʻi he matapā ʻoe fale fehikitaki, ʻaia naʻe ʻi hono tuʻa. ");
INSERT INTO ton_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Pea naʻe motuʻa ʻa ʻEpalahame mo Sela, pea naʻe lahi hona taʻu: naʻe ʻikai kei ia Sela ʻae anga ʻoe fefine. ");
INSERT INTO ton_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ko ia naʻe katakata loto ai ʻa Sela, ʻo pehē, “He ko e moʻoni, te u nekeneka au, ka kuo u motuʻa, pea kuo motuʻa mo ʻeku ʻeiki foki?” ");
INSERT INTO ton_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pea folofola ʻa Sihova kia ʻEpalahame, ʻo pehē, “Ko e hā naʻe kata ai ʻa Sela, ʻo pehē, ‘Ko e moʻoni koā te u fanauʻi ha tama ʻeau ka kuo u motuʻa?’ ");
INSERT INTO ton_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","He ʻoku ai ha meʻa ʻe taha ʻoku faingataʻa kia Sihova? ʻI he kuonga kuo kotofa te u toe haʻu kiate koe, pea ʻe maʻu ʻe ho uaifi ko Sela ʻae tama.” ");
INSERT INTO ton_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Pea fakafisi ʻa Sela ʻo pehē, “Naʻe ʻikai te u kata;” he naʻa ne manavahē. Pea ne pehē, “ʻIkai, ka naʻa ke kata pe.” ");
INSERT INTO ton_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","¶ Pea tuʻu hake ʻae kau tangata mei ai, pea hanga atu ki Sotoma, pea ʻalu ʻa ʻEpalahame mo kinautolu, ke moimoiʻi ʻakinautolu ʻi he hala. ");
INSERT INTO ton_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pea pehē ʻe Sihova, “He te u fufū mei ʻa ʻEpalahame ʻae meʻa te u fai? ");
INSERT INTO ton_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","He ko e moʻoni ʻe hoko ʻa ʻEpalahame ko e puleʻanga lahi mo mālohi ʻaupito, pea ʻe monūʻia ʻiate ia ʻae ngaahi puleʻanga kotoa pē ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","He ʻoku ou ʻiloʻi ia, te ne fekau ʻene fānau mo hono kau nofoʻanga kotoa pē tuku fakaholo, pea te nau ʻalu ʻi he hala ʻo Sihova, ke fai ʻae angatonu, mo e fakamaau: koeʻuhi ke fakahoko ʻe Sihova kia ʻEpalahame, ʻaia kotoa pē kuo ne lea ʻaki kiate ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Pea pehē ʻe Sihova, “Koeʻuhi kuo lahi ʻae tangi ʻa Sotoma mo Komola, pea kuo hoko ʻo kovi ʻaupito ʻenau angahala; ");
INSERT INTO ton_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ko ia te u ʻalu hifo ni, ʻo mamata, pe kuo nau fai kotoa pē, ʻo hangē ko e tangi ʻo ia, ʻaia kuo aʻu mai kiate au: pea kapau ʻe ʻikai, pea te u ʻilo.” ");
INSERT INTO ton_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Pea naʻe hanga atu mei ai ʻae mata ʻoe ongo tangata ke na ʻalu atu ki Sotoma: ka naʻe kei tuʻu pe ʻa ʻEpalahame ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","¶ Pea ʻunuʻunu atu ke ofi ʻa ʻEpalahame, ʻo ne pehē, “Pea te ke fakaʻauha fakataha ʻae angatonu mo e angahala? ");
INSERT INTO ton_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Naʻa ʻoku ʻi he kolo ʻae angatonu ʻe toko nimangofulu: pea te ke fakaʻauha foki, ka ʻe ʻikai fakamoʻui ʻae potu, koeʻuhi ko e angatonu ʻe toko nimangofulu ʻoku ʻi ai? ");
INSERT INTO ton_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ke mamaʻo ʻiate koe ha fai pehē, ke tāmateʻi ʻae angatonu fakataha mo e angahala, pea ke fakatatau ʻae angatonu ki he angahala, ke mamaʻo ia ʻiate koe: ʻikai ʻe fai totonu ʻae Fakamaau ʻo māmani kotoa pē?” ");
INSERT INTO ton_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Pea pehē ʻe Sihova, “Kapau te u ʻilo ʻi Sotoma ʻae angatonu ʻe toko nimangofulu, te u fakamoʻui ʻae potu kotoa pē koeʻuhi ko kinautolu.” ");
INSERT INTO ton_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pea lea ʻa ʻEpalahame ʻo ne pehē, “Vakai, ko eni kuo u lea au kia Sihova, ka ko e efu, mo e efuefu pe au: ");
INSERT INTO ton_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pea kapau ʻe ʻikai ʻi ai ʻae toko nima ʻi he toko nimangofulu ʻoku angatonu: pea te ke fakaʻauha ʻae kolo kotoa pē, koeʻuhi ko e toko nima? Pea pehē ʻe ia, kapau te u ʻilo ʻi ai ʻae toko fāngofulu ma toko nima, ʻe ʻikai te u fakaʻauha ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Pea ne toe lea kiate ia, ʻo pehē, “Pea kapau ʻe ʻilo ʻi ai ʻae toko fāngofulu.” Pea pehē ʻe ia, “E ʻikai te u fai ia, koeʻuhi koe toko fāngofulu ko ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pea pehē ʻe ia kiate ia, “ʻOfa ke ʻoua naʻa houhau ʻa Sihova, pea te u lea: Kapau ʻe ʻilo ʻi ai ʻae toko tolungofulu.” Pea pehēange ʻe ia, “E ʻikai te u fai ia, ʻo kapau te u ʻilo ʻi ai ʻae toko tolungofulu.” ");
INSERT INTO ton_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Pea pehē ʻe ia, “Vakai, kuo u lea ni kia Sihova: Kapau ʻe ʻilo ʻi ai ʻae toko uofulu.” Pea pehē ʻe ia, “E ʻikai te u fakaʻauha ia koeʻuhi ko e toko uofulu ko ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Pea pehē ʻe ia, “ʻOfa ke ʻoua naʻa houhau ʻa Sihova, pea te u lea ni ʻo tā tuʻo taha pe; Kapau ʻe ʻilo ʻi ai ʻae toko hongofulu.” Pea pehē ʻe ia, “E ʻikai te u fakaʻauha ia, koeʻuhi ko e toko hongofulu ko ia.” ");
INSERT INTO ton_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pea hāʻele atu ai ʻa Sihova ʻi hono hala, hili ʻena alea mo ʻEpalahame; pea liu mai ʻa ʻEpalahame ki hono potu. ");
INSERT INTO ton_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Pea naʻe haʻu ʻae ʻāngelo ʻe toko ua ki Sotoma kuo efiafi; pea naʻe nofo ʻa Lote ʻi he matapā ʻo Sotoma, pea mamata ʻa Lote, pea tuʻu hake ia ʻo ʻalu ke fakafetaulaki kiate kinaua: pea naʻa ne punou ia mo hono mata ki he kelekele. ");
INSERT INTO ton_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Pea pehē ʻe ia, “Ongo ʻeiki, mo vakai mai, ʻoku ou kole kiate kimoua, mo afe ki he fale ʻo ho mo tamaioʻeiki ʻo nofo ʻi he poōni, pea fufulu ho mo vaʻe, pea te mo tuʻu hengihengi hake pe, pea ō ʻi homo fononga. Pea naʻa na pehē, “E ʻikai; ka te mā nofo ʻi he hala he poōni.” ");
INSERT INTO ton_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pea kole fakamātoato ia kiate kinaua; pea na afe ai kiate ia, ō hū ki hono fale; pea naʻa ne teu ʻena kai, pea taʻo ʻae mā taʻemeʻafakatupu, pea ne na kai. ");
INSERT INTO ton_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","¶ Pea naʻe teʻeki te na tokoto, mo ʻene haʻu ʻae kau tangata ʻoe kolo, ʻio, ʻae kau tangata ʻo Sotoma, ʻo nau kāpui ʻae fale, ʻae kau mātuʻa mo e talavou, ʻae kakai kotoa pē mei he potu kehekehe. ");
INSERT INTO ton_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Pea naʻa nau ui kia Lote ʻo pehē kiate ia, “Kofaʻā ia ʻae ongo tangata naʻe omi kiate koe he poōni? ʻOmi ʻakinaua kituʻa kiate kimautolu ke mau ʻilo ʻakinaua.” ");
INSERT INTO ton_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Pea ʻalu kituaʻā Lote ʻi he matapā kiate kinautolu, pea tāpuni ʻe ia ʻae matapā ʻi hono tuʻa, ");
INSERT INTO ton_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Pea ne pehē, “ʻOku ou kole kiate kimoutolu, ʻe kāinga, ʻoua te mou fai ʻae kovi pehē ni. ");
INSERT INTO ton_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Vakai mai, ʻoku ai hoku ongo ʻofefine ʻoku teʻeki ai te na ʻilo ha tangata; ʻoku ou kole kiate kimoutolu, ke u ʻomi ʻakinaua kiate kimoutolu, pea mou fai kiate kinaua, ʻaia ʻoku lelei kiate kimoutolu kaeʻoua te mou fai ha meʻa ki he ongo tangata ni; he ko ia kuo na omi ai ki he malu ʻo hoku fale.” ");
INSERT INTO ton_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pea naʻa nau pehē, “Tuʻu atu. Pea nau toe pehē, Ko e siana ni naʻe haʻu ia ko e ʻāunofo, pea kuo fie hoko ia ko e fakamaau nai; pea ko eni te mau fai kovi lahi kiate koe, ʻiate kinaua.” Pea naʻa nau feʻohofi mai ʻo tataʻo ʻae tangata ko Lote, pea naʻe meimei maumau ʻae matapā. ");
INSERT INTO ton_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ka naʻe mafao atu ʻae ongo tangata hona nima ʻo toho mai ʻa Lote ki he fale kiate kinaua, pea tāpuni ʻae matapā. ");
INSERT INTO ton_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Pea na taaʻi ʻaki ʻae kui, ʻae kau tangata naʻe ʻi he matapā ʻoe fale, ʻae siʻi mo e lalahi: ko ia naʻa nau fiu ʻi he kumi ʻae matapā. ");
INSERT INTO ton_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","¶ Pea pehē ʻe he ongo tangata kia Lote, “ʻOku ai hao kāinga ʻi he potu ni? Ko ho foha ʻi he fono, mo ho ngaahi foha, mo ho ngaahi ʻofefine, mo ia kotoa pē ʻoku ke maʻu ʻi he kolo ni fetuku mei he potu ni. ");
INSERT INTO ton_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","He te ma fakaʻauha ʻae potu ni, koeʻuhi kuo hoko ʻo lahi ʻaupito ʻa ʻenau tangi ki he ʻao ʻo Sihova; pea kuo fekauʻi ʻakimaua ʻe Sihova, ke fakaʻauha ia,” ");
INSERT INTO ton_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Pea naʻe ʻalu kituʻa ʻa Lote ʻo lea ki hono ngaahi foha ʻi he fono, ʻaia naʻe uaifi mo hono ngaahi ʻofefine, ʻo ne pehē kiate kinautolu, “Tuʻu hake, hola mei he potu ni; koeʻuhi ʻe fakaʻauha ʻe Sihova ʻae kolo ni;” ka naʻe hangē ia ko ha tokotaha ʻoku luma, ki hono ngaahi foha ʻi he fono. ");
INSERT INTO ton_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","¶ Pea pongipongi hake ai, naʻe fakavave ʻa Lote ʻe he ongo ʻāngelo, ʻo pehē, “Tuʻu ʻo ʻave ho uaifi mo ho ongo ʻofefine ʻoku ʻi heni; telia naʻa ʻauha koe ʻi he angahala ʻae kolo.” ");
INSERT INTO ton_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Pea ʻi heʻene fakatuotuai, naʻe puke hono nima ʻe he ongo tangata, pea mo e nima ʻo hono uaifi, pea mo e nima ʻo hono ongo ʻofefine; naʻe ʻaloʻofa ʻa Sihova kiate ia; pea naʻa na ʻomi ia kituʻa, ʻo tuku ia ʻi he tuaʻā kolo. ");
INSERT INTO ton_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","¶ Pea hili ʻena ʻomi ʻakinautolu kituaʻā, pea pehē ʻe ia, “Hola ke ke moʻui ai, ʻoua naʻa ke sio ki mui, pe mālōlō ʻi he tokalelei kotoa pē, mole atu ki he moʻunga, telia naʻa ke ʻauha.” ");
INSERT INTO ton_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pea pehēange ʻe Lote kiate kinaua, “Ke ʻoua naʻa pehē ʻeku ʻEiki! ");
INSERT INTO ton_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Vakai, kuo ʻofeina ʻa hoʻo tamaioʻeiki ʻi ho ʻao, Pea kuo ke fakaongo lahi hoʻo ʻaloʻofa, ʻaia kuo ke fakahā kiate au, ʻi hoʻo fakamoʻui au: pea ʻe ʻikai te u faʻa lava ki he moʻunga, telia naʻa hoko ai ha kovi kiate au, peau mate. ");
INSERT INTO ton_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Vakai, mai ko e kolo ni ʻoku ofi ke hola ki ai, pea ʻoku siʻi ia; ʻofa ke u hola ki ai, (ʻikai ko e siʻi ia?) Pea ʻe moʻui ai hoku laumālie. ");
INSERT INTO ton_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Pea ne pehē kiate ia, “Vakai, kuo u tokanga kiate koe ʻi he meʻa ni foki, pea ʻe ʻikai te u fakaʻauha ʻae kolo ni ʻaia kuo ke kole ki ai. ");
INSERT INTO ton_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Fakatoʻotoʻo ʻo hola ki ai; he ʻoku ʻikai teu faʻa fai ha meʻa, kaeʻoua ke ke hoko ki ai;” Ko ia naʻe ui ai hono hingoa ʻoe kolo ko ia ko Soa. ");
INSERT INTO ton_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","¶ Naʻe hoko ʻa Lote ki Soa, kuo hopo ʻae laʻā ki māmani. ");
INSERT INTO ton_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Pea naʻe fakaʻuha ʻe Sihova ki Sotoma mo Komola, ʻae makavela mo e afi mei ʻa Sihova ʻi he langi. ");
INSERT INTO ton_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Pea ne fakaʻauha ʻae ngaahi kolo ko ia, mo e fonua tokalelei kotoa pē, pea mo e kakai kotoa pē ʻoe ngaahi kolo, pea mo e ngaahi meʻa naʻe tupu ʻi he kelekele. ");
INSERT INTO ton_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","¶ Ka naʻe hanga ki mui hono uaifi, ʻi heʻene muimui ʻiate ia, pea naʻe liliu ia ko e pou māsima. ");
INSERT INTO ton_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","¶ Pea naʻe ʻalu hengihengi hake pe ʻa ʻEpalahame ki he potu naʻe tuʻu ai ia ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Pea ne sio atu ki Sotoma mo Komola, pea ki he fonua kotoa pē ʻoe tokalelei, pea ne mamata, pea vakai naʻe ʻalu hake ʻae kohu ʻoe fonua, ʻo hangē ko e kohu ʻoe pupuʻa afi. ");
INSERT INTO ton_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Pea ʻi he fakaʻauha ʻe he ʻOtua ʻae ngaahi kolo ʻoe toafa, naʻe pehē ʻa ʻene manatuʻi ʻe he ʻOtua ʻa ʻEpalahame, ʻo ne fekau ʻa Lote mei he lotolotonga ʻoe ʻauha, ʻi heʻene fakaʻauha ʻae ngaahi kolo ʻaia naʻe nofo ai ʻa Lote. ");
INSERT INTO ton_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Pea naʻe ʻalu ʻa Lote mei Soa, mo hono ongo ʻofefine ʻo nau nofo ʻi he moʻunga: he naʻe manavahē ia ke nofo ʻi Soa; pea nofo ia ʻi he ʻanaʻi maka, ʻaia mo hono ongo ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pea pehē ʻe he taʻokete ki he tehina, “Kuo motuʻa ʻeta tamai, pea ʻoku ʻikai ha tangata ʻi māmani ke haʻu kiate kitaua, ʻo hangē ko e anga ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ke ta fakainu uaine ʻe ta tamai, pea te ta mohe mo ia, koeʻuhi ke ai ha hako ʻi he ʻe ta tamai.” ");
INSERT INTO ton_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Pea naʻa na fakainu uaine ʻena tamai ʻi he pō ko ia; pea ʻalu ʻae taʻokete ʻo mohe mo ʻene tamai: pea naʻe ʻikai te ne ʻilo ʻene tokoto hifo, pe ko ʻene toetuʻu hake. ");
INSERT INTO ton_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Pea pongipongi ai, naʻe pehē ʻae lea ʻae ʻuluaki ki he tehina, “Vakai, naʻaku mohe ʻanepō ki heʻeku tamai; pea ke ta fakainu uaine ia he poōni foki; pea ke ʻalu kiate ia ke mo mohe, koeʻuhi ke ai ha hako ʻi heʻeta tamai.” ");
INSERT INTO ton_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Pea naʻa na fakainu uaine ʻena tamai ʻi he pō ko ia foki; pea ʻalu ange ʻae tehina, ʻo mohe mo ia pea naʻe ʻikai te ne ʻilo ʻene tokoto hifo, pe ko ʻene tuʻu hake. ");
INSERT INTO ton_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Pea feitama ai fakatouʻosi pe ʻae ongo ʻofefine ʻo Lote ki heʻena tamai. ");
INSERT INTO ton_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Pea fanauʻi ʻe he ʻuluaki ʻae tama, pea ne ui hono hingoa ko Moape, ko e tamai ia ʻae kakai Moape, ʻo aʻu ki he ʻaho ni. ");
INSERT INTO ton_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Pea fanauʻi foki ʻe he tehina ʻae tama, pea ne ui ia ko Peniami: ʻaia ko e tamai ʻae ngaahi fānau ʻa ʻAmoni, ʻo aʻu ki he ʻaho ni. ");
INSERT INTO ton_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Pea naʻe fononga ʻa ʻEpalahame mei ai, ki he fonua ʻi he feituʻu tonga, pea nofo ia ʻi he vahaʻa ʻo Ketesi mo Sua, pea ʻāunofo ia ʻi Kela. ");
INSERT INTO ton_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Pea naʻe pehē ʻe ʻEpalahame ʻi heʻene lau ki hono uaifi ko Sela, “Ko hoku tuofefine ia:” pea fekauʻi ʻe ʻApimeleki, ko e tuʻi ʻo Kela, ʻo ne ʻave ʻa Sela. ");
INSERT INTO ton_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ka naʻe hā mai ʻae ʻOtua kia ʻApimeleki ʻi he misi ʻi he pō, ʻo ne pehē kiate ia, “Vakai ko e tangata mate koe, koeʻuhi ko e fefine kuo ke toʻo, he ko e uaifi ia ʻo ha tangata.” ");
INSERT INTO ton_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ka naʻe teʻeki ai ofi ʻa ʻApimeleki kiate ia: pea pehē ʻe ia, “E ʻEiki, te ke fakaʻauha foki ʻae puleʻanga māʻoniʻoni? ");
INSERT INTO ton_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‌ʻIkai naʻa ne pehē mai kiate au, ‘Ko hoku tuofefine ia?’ Mo e fefine, naʻe pehē ʻe ia, ‘Ko hoku tuongaʻane ia;’ ʻi he totonu ʻa hoku loto, mo e māʻoniʻoni ʻa hoku nima kuo u fai ʻae meʻa ni.” ");
INSERT INTO ton_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Pea pehē ʻe he ʻOtua kiate ia ʻi he misi, “ʻIo, ʻoku ou ʻilo naʻa ke fai ia ʻi he anga totonu, he naʻaku taʻofi koe foki ke ʻoua naʻa ke fai hala kiate au; ko ia naʻe ʻikai te u tuku koe ke ke ala kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Pea ko eni, ke ke toe ʻatu ki he tangata hono uaifi; he ko e palōfita ia, pea te ne hūfia koe, pea te ke moʻui: pea kapau ʻe ʻikai te ke toe ʻatu ia, ke ke ʻilo ko e moʻoni te ke mate, ʻa koe mo ia kotoa pē ʻoku ʻoʻou.” ");
INSERT INTO ton_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ko ia naʻe tuʻu hengihengi hake ai ʻa ʻApimeleki, ʻo ne ui ʻene kau nofoʻanga kotoa pē, ʻo ne fakahā kiate kinautolu ʻae ngaahi meʻa ni kotoa pē; pea naʻa nau manavahē lahi. ");
INSERT INTO ton_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Pea fekau ʻe ʻApimeleki ke haʻu ʻa ʻEpalahame, pea ne pehē kiate ia, “Ko e hā eni kuo ke fai kiate kimautolu? Pea ko e hā ha kovi naʻaku fai kiate koe, ke ke ʻomi ai kiate au mo hoku puleʻanga ʻae hala lahi ni? Kuo ke fai ʻae ngaahi meʻa kiate au ʻaia ʻoku ʻikai lelei ke fai.” ");
INSERT INTO ton_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Pea fehuʻi ʻe ʻApimeleki kia ʻEpalahame ʻo ne pehē, ‘Ko e hā ʻae meʻa naʻe hā kiate koe, koeʻuhi ke ke fai ai ʻae meʻa ni?’ ");
INSERT INTO ton_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Pea talaange ʻe ʻEpalahame, “Naʻaku pehē ʻi hoku loto, Ko e moʻoni ʻoku ʻikai ʻi he potu ni, ʻae manavahē ki he ʻOtua; pea te nau tāmateʻi au, koeʻuhi ko hoku uaifi. ");
INSERT INTO ton_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ka ko e moʻoni pe ko hoku tuofefine ia: he ko e ʻofefine ia ʻo ʻeku tamai, ka ʻoku ʻikai ko e tama ʻa ʻeku faʻē ʻaʻaku pea naʻe hoko ia ko hoku uaifi. ");
INSERT INTO ton_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Pea ʻi he fakahēʻi au ʻe he ʻOtua mei he fale ʻo ʻeku tamai, naʻaku pehē kiate ia, Ko hoʻo ʻofa eni, te ke fakahā kiate au; ʻi he potu kotoa pē te ta hoko ki ai, te ke fakahā au, ʻo pehē, Ko hoku tuongaʻane ia.” ");
INSERT INTO ton_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Pea toʻo ʻe ʻApimeleki ʻae fanga sipi, mo e fanga pulu, mo e kau tamaioʻeiki, mo e kau kaunanga ʻo ne foaki ʻakinautolu kia ʻEpalahame, mo ne toe atu kiate ia ʻa Sela ko hono uaifi. ");
INSERT INTO ton_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Pea pehēange ʻe ʻApimeleki, “Vakai, ʻoku ʻi ho ʻao hoku fonua kotoa pē; faʻiteliha ko e hā potu te ke nofo ki ai.” ");
INSERT INTO ton_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Pea naʻe pehē ʻe ia kia Sela, “Vakai, kuo u foaki ki ho tuongaʻane ʻae konga siliva ʻe afe: vakai ʻoku ʻiate koe ia, ko e pūlou ki ho mata kiate kinautolu kotoa pē ʻoku ʻiate koe mo e kakai kotoa pē naʻe pehē ʻa hono valokia ia.” ");
INSERT INTO ton_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","¶ Pea lotu ʻa ʻEpalahame ki he ʻOtua pea fakamoʻui ʻe he ʻOtua ʻa ʻApimeleki, mo hono uaifi, mo ʻene kau kaunanga; pea naʻa nau fanafanau. ");
INSERT INTO ton_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","He ne kuo pupuni ʻe he ʻOtua ʻae manāva kotoa pē ʻi he fale ʻo ʻApimeleki, koeʻuhi ko Sela, ko e uaifi ʻo ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Pea naʻe ʻaʻahi ʻe Sihova kia Sela ʻo hangē ko ʻene folofola, pea naʻe fai ʻe Sihova kia Sela ʻo hangē ko ʻene folofola. ");
INSERT INTO ton_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","He naʻe tuituʻia ʻa Sela ʻo ne fanauʻi kia ʻEpalahame ʻae tama ʻi heʻene motuʻa, ʻio, ʻi he kuonga ko ia naʻe folofola ki ai ʻae ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Pea naʻe ui ʻe ʻEpalahame ʻae hingoa ʻo hono foha naʻe fānau kiate ia, ʻaia naʻe fāʻeleʻi ʻe Sela kiate ia, ko ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pea naʻe kamu ʻe ʻEpalahame hono foha ko ʻAisake ʻi hono ʻaho valu, ʻo hangē ko e fekau ʻae ʻOtua kiate ia, ");
INSERT INTO ton_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Pea naʻe teau taʻu ʻae motuʻa ʻo ʻEpalahame ʻi he fānau ʻa ʻAisake kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","¶ Pea naʻe pehē ʻe Sela, “Kuo fakakata au ʻe he ʻOtua, pea ʻe kata mo au ʻakinautolu kotoa pē ʻe fanongo ai.” ");
INSERT INTO ton_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Pea pehē ʻe ia, “Ko hai ia naʻe teitei pehē kia ʻEpalahame, ʻe fakahuhu ʻe Sela ha fānau? He kuo u fāʻeleʻi ha tama kiate ia ʻi heʻene motuʻa.” ");
INSERT INTO ton_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Pea naʻe tupu ʻae tama, pea māvae ia, pea naʻe fai ʻe ʻEpalahame ʻae kātoanga lahi ʻi he ʻaho naʻe māvae ai ʻa ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","¶ Pea naʻe mamata ʻa Sela ki he tama ʻa Hekaʻā ko e fefine ʻIsipite, ʻaia naʻa ne fanauʻi kia ʻEpalahame, ʻoku manuki. ");
INSERT INTO ton_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ko ia naʻa ne pehē ai kia ʻEpalahame, “Kapusi ʻae fefine pōpula ni mo ʻene tama: koeʻuhi ʻe ʻikai fakataha ʻae tama ʻae fefine pōpula ni, mo ʻeku tama ko ʻAisake.” ");
INSERT INTO ton_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Pea ko e meʻa fakamamahi lahi ia ʻi he ʻao ʻo ʻEpalahame, koeʻuhi ko hono foha. ");
INSERT INTO ton_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","¶ Pea naʻe folofola ʻae ʻOtua kia ʻEpalahame, “ʻOua naʻa ke mamahi koeʻuhi ko e tama, pe koeʻuhi ko hoʻo fefine kaunanga ka ke tokanga ki he leʻo ʻo Sela ʻi he meʻa kotoa pē kuo ne lea ai kiate koe koeʻuhi ʻe ui ia ʻAisake pe ʻa ho hako. ");
INSERT INTO ton_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Pea te u fakatupu ʻae puleʻanga ʻi he tama ʻae fefine kaunanga, koeʻuhi ko ho hako ia.” ");
INSERT INTO ton_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Pea tuʻu hengihengi hake ai ʻa ʻEpalahame, mo ne ʻomi ʻae mā mo e hina vai, ʻo ne ʻatu kia Hekaʻā, pea ne ai ia ki hono uma pea mo e tama, ʻo ne fekau ia ke ʻalu; pea naʻe ʻalu ia, ʻo he fano pe ʻi he toafa ʻo Peasipa. ");
INSERT INTO ton_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Pea ʻi he ʻosi ʻae vai ʻi he hina, naʻe tuku ʻe ia ʻae tama ʻi he lolo ʻakau ʻe taha. ");
INSERT INTO ton_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ka ka ʻalu ia ʻo nofo fakahangatonu mai mei he mamaʻo ʻo tatau nai mo e touʻanga ngahau kuo fana; he naʻe pehē ʻe ia; “ʻOfa ke ʻoua naʻaku mamata ki he pekia ʻae tama, pea naʻe nofo ia ʻo hangatonu kiate ia, pea hiki hake ʻe ia hono leʻo ʻo tangi.” ");
INSERT INTO ton_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Pea ongoʻi ʻe he ʻOtua ʻae leʻo ʻoe tamasiʻi; pea lea mai ʻae ʻāngelo ʻae ʻOtua kia Hekaʻā mei he langi ʻo ne pehē kiate ia, “Ko e hā ʻoku ke mamahi ai Hekaʻā? ʻOua te ke manavahē: he kuo ongoʻi ʻe he ʻOtua ʻae leʻo ʻoe tamasiʻi mei he potu na. ");
INSERT INTO ton_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Tuʻu, pea hiki hake ʻae tamasiʻi pea fafa ia ho nima: he te u ngaohi ia ko e puleʻanga lahi.” ");
INSERT INTO ton_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Pea naʻe fakaʻā ʻe he ʻOtua hono mata, pea naʻe mamata ia ki he matavai: pea ʻalu ia ʻo fakafonu ʻae hina ʻaki ʻae vai, pea ne fakainu ʻae tamasiʻi. ");
INSERT INTO ton_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Pea naʻe kau ʻae ʻOtua ki he tamasiʻi pea tupu ia, pea ne nofo ʻi he toafa, pea hoko ia ko e tangata fana. ");
INSERT INTO ton_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Pea naʻe nofo ia ʻi he toafa ʻo Palani: pea naʻe ʻomi ʻe heʻene faʻē, ʻae uaifi kiate ia mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","¶ Pea naʻe hoko ʻo pehē ʻi he kuonga ko ia, naʻe lea kia ʻEpalahame ʻa ʻApimeleki, mo Fikoli ko e ʻeiki lahi ia ʻo ʻene kautau, ʻo pehē: “ʻOku ʻiate koe ʻae ʻOtua ʻi he meʻa kotoa pē ʻoku ke fai; ");
INSERT INTO ton_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Pea ko eni, ke ke fuakava kiate au ʻi he ʻOtua, koeʻuhi ke ʻoua naʻa ke fai kākā kiate au, pe ki hoku foha, pe ki he foha ʻo hoku foha, ka ke fai kiate au, mo e fonua, ʻaia kuo ke nofo ʻāunofo ki ai, ʻo hangē ko ʻeku ʻofa kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Pea pehē ʻe ʻEpalahame, “Te u fuakava.” ");
INSERT INTO ton_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Pea naʻe valoki ʻe ʻEpalahame kia ʻApimeleki, koeʻuhi ko e vai keli naʻe faʻao fakamālohi ʻe he kau tamaioʻeiki ʻa ʻApimeleki. ");
INSERT INTO ton_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Pea pehēange ʻe ʻApimeleki, “ʻOku ʻikai te u ʻilo pe ko hai kuo fai ʻae meʻa ni, pea naʻe ʻikai te ke tala mai ia, pea naʻe ʻikai te u fanongo ki ai, ka ko e ʻaho ni pe.” ");
INSERT INTO ton_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Pea naʻe ʻomi ʻe ʻEpalahame ʻae fanga sipi mo e fanga pulu, ʻo ne foaki ia kia ʻApimeleki; pea naʻe fai ʻekinaua ʻae fuakava; ");
INSERT INTO ton_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pea naʻe vaheʻi mo tuku kehe ʻe ʻEpalahame ʻae lami fefine ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Pea pehē ʻe ʻApimeleki kia ʻEpalahame; “Ko e hā hono ʻuhinga ʻoe lami fefine ʻe fitu kuo ke vaheʻi mo tuku kehe?” ");
INSERT INTO ton_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Pea ne pehē, “Ke ke toʻo ia ʻo ʻave mei hoku nima, ʻae lami fefine ʻe fitu ko ia, koeʻuhi ko e fakamoʻoni ia kiate au, naʻaku keli ʻae vai. ");
INSERT INTO ton_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ko ia naʻa ne ui ai ʻae potu ko ia ko Peasipa: koeʻuhi naʻa na fefuakava ʻi ai; ");
INSERT INTO ton_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Naʻe pehē ʻena fai ʻae fuakava ʻi Peasipa: pea tuʻu hake ʻa ʻApimeleki mo Fikoli ko e ʻeiki lahi ʻo ʻene kautau, pea na toe ō ki he fonua ʻoe kakai Filisitia. ");
INSERT INTO ton_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","¶ Pea naʻe tō ʻe ʻEpalahame ʻae ngaahi ʻakau ʻi Peasipa, pea naʻe ui ai ia ki he huafa ʻo Sihova, ko e ʻOtua taʻengata; ");
INSERT INTO ton_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Pea naʻe ʻāunofo ʻa ʻEpalahame ʻi he fonua ʻoe kakai Filisitia ʻi he ngaahi ʻaho lahi. ");
INSERT INTO ton_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Pea hili ʻae ngaahi meʻa ni, naʻe hoko ʻae ʻahiʻahi mei he ʻOtua kia ʻEpalahame ʻo ne pehē, ʻEpalahame: pea pehē ʻe ia, “Vakai ko au eni. ");
INSERT INTO ton_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Pea ne pehē, “Ko eni ke ke ʻave ho foha, ho foha pe taha ko ʻAisake, ʻaia ʻoku ke ʻofa ki ai, pea ke ʻalu ki he fonua ko Molia: ʻo feilaulau ʻaki ia ʻi ai, ko e feilaulau tutu, ʻi he moʻunga ʻe taha ʻaia te u fakahā kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","¶ Pea tuʻu hengihengi hake ʻa ʻEpalahame ʻo ne ai hono hekaʻanga ki he ʻasi, pea ʻave mo ia ʻae talavou ʻe toko ua, pea mo ʻAisake ko hono foha, pea naʻa ne tā ʻae fefie ki he feilaulau tutu, pea nau tutuʻu hake ʻo fononga ki he potu naʻe fakahā ʻe he ʻOtua kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Pea hanga hake ʻa ʻEpalahame hono mata ʻi hono ʻaho tolu, pea mamata ia ki he potu mei he mamaʻo. ");
INSERT INTO ton_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Pea pehē ʻe ʻEpalahame ki heʻene ongo talavou, “Mo nofo ʻi heni mo e ʻasi: pea te ma ō mo e tama ki hena ʻo lotu, pea toe haʻu kiate kimoua.” ");
INSERT INTO ton_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Pea toʻo mai ʻe ʻEpalahame ʻae fefie ki he feilaulau tutu, ke fua ia ʻe hono foha ko ʻAisake; pea ne toʻo ʻae afi ʻi hono nima mo e hele; pea naʻa na ō fakataha. ");
INSERT INTO ton_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Pea naʻe leaange ʻa ʻAisake ki heʻene tamai ko ʻEpalahame, ʻo pehē, “Ko ʻeku tamai; pea ne pehē, “Hoku foha, ko au eni.” Pea pehē ʻe ia, “Vakai, ko eni ʻae afi, mo e fefie; ka ko e fē ʻae lami ki he feilaulau?” ");
INSERT INTO ton_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Pea pehēange ʻe ʻEpalahame, “Hoku foha, ʻe tokonaki ʻe he ʻOtua maʻana ha lami ki he feilaulau tutu; pea ne na ō fakataha.” ");
INSERT INTO ton_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pea naʻa na hoko ki he potu naʻe fakahā ʻe he ʻOtua kiate ia; pea fokotuʻu ai ʻe ʻEpalahame ʻae ʻesifeilaulau, ʻo ne hili ʻae fefie ki ai, pea ne haʻi hono foha ko ʻAisake, ʻo ne hilifaki ia ki he fefie ki he funga ʻesifeilaulau. ");
INSERT INTO ton_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Pea mafao atu ʻe ʻEpalahame hono nima, ʻo ne toʻo ʻae hele ke tāmateʻi hono foha. ");
INSERT INTO ton_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Pea naʻe ui ʻe he ʻāngelo ʻa Sihova kiate ia mei he langi, ʻo pehē, “ʻEpalahame, ʻEpalahame;” pea pehē ʻe ia, “Ko au eni;” ");
INSERT INTO ton_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Pea pehē ʻe ia, “ʻOua naʻa ala ho nima ki he tama, pe fai ha meʻa kiate ia; he ʻoku ou ʻilo eni, ʻoku ke manavahē ki he ʻOtua, koeʻuhi naʻe ʻikai te ke taʻofi ho foha, ko ho foha pe taha meiate au.” ");
INSERT INTO ton_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Pea hanga hake ʻa ʻEpalahame hono mata ʻo ne sio, pea vakai naʻe ʻi hono tuʻa ha sipitangata, kuo ʻefihia ʻi hono nifo ʻi he vao; pea naʻe ʻalu ʻa ʻEpalahame ʻo ne toʻo ʻae sipitangata, ʻo ne feilaulau ʻaki ia, ko e feilaulau tutu, ko e fetongi ʻo hono foha. ");
INSERT INTO ton_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Pea naʻe ui ʻe ʻEpalahame ʻae hingoa ʻoe potu ko ia, ko Sihova-Saila; hangē ko ia ʻoku lea ʻaki ʻo aʻu ki he ʻaho ni, ʻo pehē, “ʻI he moʻunga ʻe ʻafio ʻa Sihova ki ai.” ");
INSERT INTO ton_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","¶ Pea naʻe ui ʻe he ʻāngelo ʻa Sihova kia ʻEpalahame mei he langi ko hono tuʻo ua, ");
INSERT INTO ton_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","‌ʻo ne pehē, “ʻOku pehē ʻe Sihova, kuo u fuakava ʻiate au, koeʻuhi kuo ke fai ʻae meʻa ni, pea naʻe ʻikai te ke taʻofi meiate au ho foha, ʻa ho foha pe taha; ");
INSERT INTO ton_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Koeʻuhi ʻi he tāpuaki, te u tāpuakiʻi koe, pea ʻi he fakatokolahi, te u fakatokolahi ho hako ke tatau mo e ngaahi fetuʻu ʻoe langi, mo e ʻoneʻone ʻoku ʻi he matātahi; pea ʻe maʻu ʻe ho hako ʻae matapā ʻo honau ngaahi fili. ");
INSERT INTO ton_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Pea ʻe monūʻia ʻi ho hako ʻae puleʻanga kotoa pē ʻo māmani; ko e meʻa ʻi hoʻo tuitala ki hoku leʻo.” ");
INSERT INTO ton_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Pea naʻe toe haʻu ʻa ʻEpalahame ki heʻene ongo talavou, pea naʻa nau tutuʻu ki ʻolunga ʻo nau fononga fakataha ki Peasipa, pea naʻe nofo ʻa ʻEpalahame ʻi Peasipa. ");
INSERT INTO ton_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","¶ Pea hili ʻae ngaahi meʻa ni, naʻe fakahā kia ʻEpalahame, ʻo pehē, “Vakai, kuo fanauʻi foki ʻe Milika ʻae fānau kia Nehoa, ko ho tokoua. ");
INSERT INTO ton_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ko Husa hono ʻuluaki, mo Pusa ko hono tehina, pea mo Kemueli, ko e tamai ʻa ʻElami. ");
INSERT INTO ton_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Mo Keseti, mo Hesoa, mo Pilitasi, mo Sitilafi, mo Petueli. ");
INSERT INTO ton_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Pea naʻe tupu ia Petueli ʻa Lepeka ko e toko valu ni naʻe fanauʻi ʻe Milika kia Nehoa, ko e tehina ʻo ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Pea ko hono sinifu naʻe hingoa ko Liuma, naʻa ne fanauʻi foki ʻe ia ʻa Tepa, mo Kehami, mo Tehasi, mo Meeka. ");
INSERT INTO ton_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Pea naʻe teau ma uofulu ma fitu ʻae taʻu ʻa Sela; ko e ngaahi taʻu eni ʻoe moʻui ʻa Sela; ");
INSERT INTO ton_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Pea naʻe pekia ʻa Sela ʻi Kesa ʻAlipa; ʻaia ko Hepeloni ʻi he fonua ko Kēnani pea naʻe haʻu ʻa ʻEpalahame ke tēngihia ʻa Sela, mo tangi koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","¶ Pea naʻe tuʻu ki ʻolunga ʻa ʻEpalahame ʻi he ʻao ʻo hono pekia, ʻo ne lea ki he fānau ʻa Heti, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ko e muli au mo e ʻāunofo ʻiate kimoutolu, tuku mai ha potu faʻitoka meiate kimoutolu, koeʻuhi ke u tanu ai hoku pekia mei hoku ʻao.” ");
INSERT INTO ton_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Pea leaange ʻae fānau ʻa Heti kia ʻEpalahame, ʻo pehē kiate ia: ");
INSERT INTO ton_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“E ʻEiki, ke ke fanongo mai kiate kimautolu, ko e ʻEiki lahi koe ʻiate kimautolu; ke ke faʻiteliha ki homau ngaahi fonualoto, ke fai ai ho pekia; ʻe ʻikai ha mau tokotaha ʻe taʻofi meiate koe hono fonualoto, ka ke fai ʻi ai ho pekia.” ");
INSERT INTO ton_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Pea tuʻu hake ʻa ʻEpalahame, ʻo tulolo ia ki he kakai ʻoe fonua, ʻio ki he fānau ʻa Heti. ");
INSERT INTO ton_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Pea lea ia kiate kinautolu, ʻo pehē, “Kapau ko homou loto ke u tanu hoku pekia mei hoku ʻao, pea mou fanongo mai; pea mou kole kia ʻEfilone ko e foha ʻo Sohaʻa, koeʻuhi ko au. ");
INSERT INTO ton_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Koeʻuhi ke ne tuku mai ʻae ʻana ʻi Makipila ʻoku ʻaʻana, pea ʻoku ʻi he potu ʻo ʻene ngoue; ke ne fakatau ia kiate au, ki he paʻanga ʻoku tatau mo ia, ke u maʻu ia ko hoku faʻitoka ʻiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Pea naʻe nofo ʻa ʻEfilone fakataha mo e fānau ʻa Heti; pea leaange ʻa ʻEfilone ko e tangata Heti kia ʻEpalahame ʻi he ʻao ʻoe ngaahi fānau ʻa Heti, ʻio, ʻi he ʻao ʻoe kakai kotoa pē naʻe hū ʻi he matapā ʻoe kolo, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Ko ʻeku ʻeiki, ʻe ʻikai; ka ke fanongo mai: ʻoku ʻoʻou ʻae ngoue, pea mo e ʻana ʻoku ʻi ai, te u foaki ia kiate koe; ʻi he ʻao ʻoe fānau ʻa hoku kakai ni, ʻoku ou foaki ia kiate koe, ke ke tanu ai ho pekia.” ");
INSERT INTO ton_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pea toe tulolo ʻa ʻEpalahame ki he kakai ʻoe fonua. ");
INSERT INTO ton_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Pea lea ia kia ʻEfilone ʻi he ʻao ʻoe kakai ʻoe fonua, ʻo pehē, “Kapau ko ho loto ia, ʻoku ou kole kiate koe fanongo mai kiate au: te u ʻatu kiate koe ʻae paʻanga ki he ngoue; ke ke maʻu ia, pea teu tanu hoku pekia ʻi ai.” ");
INSERT INTO ton_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Pea lea ʻa ʻEfilone kia ʻEpalahame, ʻo ne pehē kiate ia, ");
INSERT INTO ton_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ko ʻeku ʻeiki, ke ke fanongo mai; ʻoku tatau ʻae konga fonua mo e sikeli siliva ʻe fāngeau; ka koeʻumaʻā ia kiate au mo koe? Ko ia, ke ke tanu pe ho pekia.” ");
INSERT INTO ton_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Pea tokanga ʻa ʻEpalahame kia ʻEfilone; pea naʻe fua ʻe ʻEpalahame ʻae siliva kia ʻEfilone, ʻaia naʻa ne tala ʻi he ʻao ʻoe fānau ʻa Heti, ko e sikeli siliva ʻe fāngeau, ʻo hangē ko e lau ʻe he kau fakatau. ");
INSERT INTO ton_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","¶ Pea ko e ngoue ʻa ʻEfilone, ʻaia naʻe ʻi Makipila, pea ofi ki Mamali, ko e ngoue, pea mo e ʻana ʻi ai, pea mo e ngaahi ʻakau ʻoku ʻi ai, ʻaia naʻe ʻi he veʻe ngoue kotoa pē, naʻe fakapapau ia, ");
INSERT INTO ton_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Kia ʻEpalahame ko e tofiʻa, ʻi he ʻao ʻoe fānau ʻa Heti, ʻi he ʻao ʻo kinautolu kotoa pē naʻe hū ʻi he matapā ʻo hono kolo. ");
INSERT INTO ton_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Pea hili ia, naʻe tanu ʻe ʻEpalahame hono uaifi ko Sela ʻi he ʻana ʻi he ngoue ʻo Makipila ʻoku hangatonu ki Mamili, ʻaia ko Hepeloni, ʻi he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Pea ko e ngoue, mo e ʻana naʻe ʻi ai naʻe fakapapau ia kia ʻEpalahame, ʻe he ngaahi foha ʻo Heti, ke ne maʻu ko hono faʻitoka. ");
INSERT INTO ton_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Pea naʻe motuʻa ʻa ʻEpalahame, pea lahi ʻaupito ʻa hono ngaahi ʻaho; pea naʻe tāpuaki ʻe Sihova ʻa ʻEpalahame ʻi he meʻa kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Pea pehē ʻe ʻEpalahame ki ke motuʻa tamaioʻeiki ʻi hono fale, ʻaia naʻe pule ki heʻene meʻa kotoa pē, “ʻOku ou kole ke ke ai ho nima ʻi hoku lalo tenga: ");
INSERT INTO ton_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","He ko hoku loto, ke ke fuakava ʻia Sihova ko e ʻOtua ʻoe langi, pea ko e ʻOtua ʻo māmani, ke ʻoua naʻa ke fili ha uaifi ki hoku foha ʻi he ngaahi ʻofefine ʻoe kakai Kēnani, ʻaia ʻoku ou ʻāunofo ki ai. ");
INSERT INTO ton_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ka te ke ʻalu ki hoku fonua, ki hoku kāinga, mo ke fili mai ha uaifi ki hoku foha ko ʻAisake.” ");
INSERT INTO ton_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Pea pehēange ʻe he tamaioʻeiki kiate ia, “Kapau ʻe ʻikai fie haʻu mo au ʻae fefine ki he fonua ni; ʻe fēfē, te u toe ʻave ho foha ki he fonua naʻa ke haʻu mei ai?” ");
INSERT INTO ton_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Pea talaange ʻe ʻEpalahame kiate ia, “Vakai, ʻoua ʻaupito naʻa ke toe ʻave hoku foha ki ai. ");
INSERT INTO ton_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ko Sihova ko e ʻOtua ʻoe langi, ʻaia naʻe ʻomi au mei he fale ʻo ʻeku tamai, mo e fonua ʻo hoku kāinga, pea naʻa ne lea kiate au mo ne fuakava kiate au, ʻo pehē, Te u foaki ki ho hako ʻae fonua ni: te ne fekau ʻene ʻāngelo ke muʻomuʻa ʻiate koe, pea te ke ʻomi mei ai ha uaifi ki hoku foha. ");
INSERT INTO ton_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Pea kapau ʻe ʻikai loto ʻae fefine ke haʻu mo koe, te ke ʻataʻatā ai mei he ʻe ta fuakava ni: kaeʻoua naʻa ke toe ʻave hoku foha ki ai.” ");
INSERT INTO ton_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Pea naʻe ai ʻe he tamaioʻeiki hono nima ki he lalo tenga ʻo hono ʻeiki ko ʻEpalahame, pea ne fuakava kiate ia, koeʻuhi ko e meʻa ni. ");
INSERT INTO ton_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","¶ Pea naʻe fili mai ʻe he tamaioʻeiki ʻae kāmeli ʻe hongofulu ʻi he fanga kāmeli ʻa ʻene ʻeiki, pea ʻalu; he naʻe ʻiate ia ʻae ngaahi meʻa kotoa pē ʻa ʻene ʻeiki, pea tuʻu hake ia ʻo ʻalu ki Mesopōtemia, ki he kolo ʻo Nehoa. ");
INSERT INTO ton_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Pea naʻa ne fakatūʻulutui ʻene fanga kāmeli ʻi he tuaʻā kolo ʻi he veʻe vaikeli, ʻi he feituʻulaʻā efiafi, ʻio, ʻi he feituʻulaʻā ʻoku ʻalu ai ʻae kau fefine ke utu vai. ");
INSERT INTO ton_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Pea pehē ʻe ia, “E Sihova ko e ʻOtua ʻo ʻeku ʻeiki ko ʻEpalahame, ʻoku ou kole kiate koe, ke ke fakamonūʻia au he ʻaho ni, pea ke fakahā hoʻo ʻofa ki heʻeku ʻeiki ko ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Vakai, ʻoku ou tuʻu ʻi heni, ʻi he veʻe vaikeli; pea ʻe haʻu ʻae ngaahi ʻofefine ʻoe kakai ʻoe kolo ke utu vai. ");
INSERT INTO ton_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tuku ke hoko ʻo pehē, ke ʻilonga ʻae taʻahine, ʻaia te u pehē ki ai, ‘ʻOku ou kole kiate koe, tuku hifo hoʻo hina, ke u inu; pea te ne pehē mai, Inu, pea te u fakainu hoʻo fanga kāmeli foki;’ ko ia ia kuo ke fili maʻa hoʻo tamaioʻeiki ko ʻAisake: pea te u ʻilo ai kuo ke fakahā ʻae ʻofa ki heʻeku ʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","¶ Pea naʻe hoko, ʻo pehē, ʻi he teʻeki ai ʻosi ʻene lea, vakai naʻe haʻu mo ʻene hina vai ʻi hono uma, ʻa Lepeka ʻaia naʻe tupu ia Petueli, ko e tama ʻa Milika, ko e uaifi ʻo Nehoa, ko e taʻokete ʻo ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Pea naʻe hoihoifua ʻae taʻahine ke sio ki ai, pea ko e tāupoʻou ia, he naʻe teʻeki ʻiloʻi ia ʻe ha tangata; pea ne ʻalu hifo ia ki he vai, ʻo fakafonu ʻene hina pea toe ʻalu hake. ");
INSERT INTO ton_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Pea lele ʻae tamaioʻeiki ke fakafetaulaki kiate ia, ʻo ne pehē kiate ia: “ʻOku ou kole ke u inu ha vai siʻi ʻi hoʻo hina.” ");
INSERT INTO ton_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Pea pehēange ʻe ia, “Ko ʻeku ʻeiki ke ke inu;” pea fakatoʻotoʻo ia ʻo tuku hifo ʻae hina ki hono nima, ʻo ne fakainu ia. ");
INSERT INTO ton_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Pea hili ʻene fakainu ia, pea pehē ʻe ia, “Te u utu ki hoʻo fanga kāmeli foki ke ʻoua ke nau fiu.” ");
INSERT INTO ton_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Pea fakatoʻotoʻo ia, pea lingi ʻae vai mei he hina ki he tukuʻanga vai, pea toe lele ki he vai ke utu, pea naʻa ne utu ki heʻene fanga kāmeli kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Pea naʻe ofo ʻae tangata kiate ia, kae fakalongo pe, ko ʻene vakai pe kuo fakamonūʻia ʻe Sihova hono fononga pe ʻikai. ");
INSERT INTO ton_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Pea naʻe hoko ʻo pehē, ʻi he hili ʻae inu ʻae fanga kāmeli, naʻe toʻo ʻe he tangata ʻae hau koula, ko e vaheua ʻoe sikeli siliva hono mamafa, pea mo e lelu koula ʻe ua ki hono nima, ko e sikeli ʻe hongofulu hono mamafa. ");
INSERT INTO ton_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Pea ne pehē, “Ko e ʻofefine ʻohai koe? ʻOku ou kole ke ke tala mai, pe ʻoku ʻataʻatā ʻae ʻapi ʻo hoʻo tamai ke mau ʻapitanga ai.” ");
INSERT INTO ton_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Pea ne pehē kiate ia, “Ko e ʻofefine au ʻo Petueli ko e tama ʻa Milika, ʻaia naʻa ne fāʻeleʻi kia Nehoa.” ");
INSERT INTO ton_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Pea ne pehē foki kiate ia, “ʻOku mau maʻu ʻae mohuku mo e meʻakai lahi pea ʻoku ʻataʻatā homau ʻapi ke mou ʻapitanga ki ai.” ");
INSERT INTO ton_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Pea tulolo hifo ʻae tangata hono ʻulu, pea hū ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","‌ʻO ne pehē, “ʻOku monūʻia ʻa Sihova ko e ʻOtua ʻa ʻeku ʻeiki ko ʻEpalahame, ʻaia ʻoku ʻikai te ne fakamasiva ʻeku ʻeiki ʻi heʻene ʻaloʻofa mo ʻene moʻoni; naʻaku ʻi he hala, pea kuo tataki au ʻe Sihova ki he fale ʻoe kāinga ʻo ʻeku ʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Pea naʻe lele ʻae taʻahine, ʻo fakahā ki he fale ʻo ʻene faʻē, ʻae ngaahi meʻa ni. ");
INSERT INTO ton_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","¶ Pea naʻe ʻi ai ʻae tuongaʻane ʻo Lepeka ko Lepani hono hingoa; pea lele kituʻa ʻa Lepani ki he tangata, ʻi he vaikeli. ");
INSERT INTO ton_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Pea naʻe hoko ʻo pehē, ʻi heʻene mamata ki he hau, mo e lelu ʻi he nima ʻo hono tuofefine, pea mo ʻene fanongo ki he ngaahi lea ʻa Lepeka ko hono tuofefine, ʻo pehē, naʻe lea pehē mai ʻae tangata kiate au; pea haʻu leva ia ki he tangata; pea vakai naʻe tuʻu ia ʻo ofi ki he fanga kāmeli ʻi he veʻe vaikeli. ");
INSERT INTO ton_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Pea pehē ʻe ia, “Haʻu ki heni, ʻa koe ko e monūʻia ʻo Sihova; ko e hā ʻoku ke kei tuʻu ai ʻi tuaʻā? He kuo ʻosi ʻeku teu ʻae fale, mo e potu ki he fanga kāmeli. ");
INSERT INTO ton_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","¶ Pea naʻe hū ʻae tangata ki he fale; pea ne vete ʻae fanga kāmeli, pea ne ʻatu ʻae mohuku mo e meʻakai ki he fanga kāmeli, mo e vai ke fufulu ai hono vaʻe mo e vaʻe ʻoe kau tangata naʻe ʻiate ia. ");
INSERT INTO ton_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Pea naʻe tuku ʻi hono ʻao ʻae meʻakai: ka naʻe pehē ʻe ia, “E ʻikai te u kai, kaeʻoua muʻa ke u fakahā ʻeku fekau,” pea ne pehē, “Ke ke lea.” ");
INSERT INTO ton_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Pea ne pehē ʻe ia, “Ko e tamaioʻeiki au ʻa ʻEpalahame, ");
INSERT INTO ton_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Pea kuo tāpuaki lahi ʻe Sihova ʻeku ʻeiki; pea kuo hoko ia ʻo lahi: pea kuo ne foaki kiate ia ʻae fanga sipi, mo fanga manu, mo e siliva, mo e koula, mo e kau tamaioʻeiki mo e kau kaunanga, mo e fanga kāmeli, mo e fanga ʻasi. ");
INSERT INTO ton_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Pea ko Sela, ko e uaifi ʻo ʻeku ʻeiki naʻa ne fanauʻi ki heʻeku ʻeiki ʻae tama heʻene motuʻa; pea kuo ne tuku ʻa ʻene meʻa kotoa pē kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pea naʻe fekau ʻe heʻeku ʻeiki kiate au ke u fuakava, ʻo pehē, ‘E ʻikai te ke fili ha uaifi ki hoku foha mei he ngaahi ʻofefine ʻoe kakai Kēnani, ʻaia ʻoku ʻonautolu ʻae fonua ʻoku ou nofo ai;’ ");
INSERT INTO ton_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ka ke ʻalu ki he fale ʻo ʻeku tamai mo hoku kāinga, ʻo ʻomi mei ai ha uaifi ki hoku foha. ");
INSERT INTO ton_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Pea naʻaku pehē ki heʻeku ʻeiki, ‘Ka e fēfē ʻoka ʻikai fie haʻu ʻae fefine mo au?’ ");
INSERT INTO ton_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Pea pehē mai ʻe ia kiate au, ‘Ko Sihova ʻaia ʻoku ou ʻalu ʻi hono ʻao, te ne fekau ʻene ʻāngelo ke ʻalu mo koe ʻo fakamonūʻia hoʻo ʻalu; pea te ke ʻomi ha uaifi ki hoku foha mei hoku kāinga mo e fale ʻo ʻeku tamai: ");
INSERT INTO ton_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pea te ke ʻataʻatā mei heʻeku fuakava ni, ʻoka ke ka hoko ki hoku kāinga, pea kapau ʻe ʻikai te nau tuku ha tokotaha kiate koe, pea te ke ʻataʻatā mei he ʻe tā fuakava ni.’ ");
INSERT INTO ton_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Pea naʻaku haʻu he ʻaho ni ki he vaikeli pea u pehē, ‘E Sihova ko e ʻOtua ʻo ʻeku ʻeiki ko ʻEpalahame, kapau ʻoku ke fakamonūʻia hoku hala, ʻaia ʻoku ou ʻalu ai: ");
INSERT INTO ton_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Vakai ʻoku ou tuʻu ʻi he veʻe vaikeli pea te u pehē, ʻoka haʻu ha taʻahine ke utu vai, te u pehē kiate ia, ‘ʻOku ou kole kiate koe, tuku mai ha vai siʻi ʻi hoʻo hina ke u inu:’ ");
INSERT INTO ton_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Pea kapau te ne pehē mai kiate au, ‘Inu koe, pea te u utu ha vai ki hoʻo fanga kāmeli foki,’ ʻofa ko e fefine ko ia kuo fili ʻe Sihova ki he foha ʻo ʻeku ʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Pea naʻe teʻeki ai ʻosi ʻeku lea ʻi hoku loto, mo ʻene hoko mai ʻa Lepeka mo ʻene hina ʻi hono uma: pea hifo ia ki he vai, ʻo utu, pea ne u pehē kiate ia, ‘ʻOku ou kole kiate koe tuku mai ke u inu.’ ");
INSERT INTO ton_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Pea naʻe fakatoʻotoʻo ia ʻo tuku hifo ʻene hina mei hono uma, ʻo ne pehē, ‘Inu, pea te u fakainu hoʻo fanga kāmeli foki; pea u inu, pea naʻa ne fakainu ʻae fanga kāmeli foki. ");
INSERT INTO ton_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Pea naʻaku fehuʻi kiate ia ʻo pehē, ‘Ko e ʻofefine ʻohai koe?’ Pea pehē ʻe ia, ‘Ko e ʻofefine ʻo Petueli, ko e foha ʻo Nehoa ʻaia naʻe fanauʻi ʻe Milika kiate ia: pea naʻaku ai ʻae hau ki hono mata, mo e lelu ki hono nima.’ ");
INSERT INTO ton_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Pea punou hifo hoku mata ʻo hū mo e fakafetaʻi kia Sihova, ko e ʻOtua ʻo ʻeku ʻeiki ko ʻEpalahame, ʻaia naʻe tataki au ʻi he hala totonu ke ʻave ʻae ʻofefine ʻoe tokoua ʻa ʻeku ʻeiki ki hono foha. ");
INSERT INTO ton_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Pea ko eni, kapau te mou fai ʻofa mo totonu, ki heʻeku ʻeiki, tala mai, pea ka ʻikai, tala mai, koeʻuhi ke u afe ki he nima toʻomataʻu, pe ki he toʻohema.” ");
INSERT INTO ton_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Pea lea ʻa Lepani mo Petueli, ʻo pehēange, “ʻOku haʻu ʻae meʻa ni meia Sihova; pea ʻoku ʻikai te ma faʻa lea ʻaki kiate koe ʻae kovi pe ko e lelei; ");
INSERT INTO ton_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Vakai, ʻoku ʻi ho ʻao ʻa Lepeka, toʻo ia, pea ʻalu, pea ke hoko ia ko e uaifi ki he foha ʻo hoʻo ʻeiki, ʻo hangē ko e folofola ʻa Sihova.” ");
INSERT INTO ton_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Pea ʻi he fanongo ʻae tamaioʻeiki ʻa ʻEpalahame ki he ngaahi lea ni, naʻe hū ia kia Sihova, ʻo ne punou ki he kelekele; ");
INSERT INTO ton_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Pea toʻo ʻe he tamaioʻeiki ʻae ngaahi teunga siliva, mo e ngaahi teunga koula, mo e ngaahi kofu, ʻo ne foaki ia kia Lepeka; pea ne foaki ʻae ngaahi meʻa mahuʻinga ki hono tuongaʻane, mo ʻene faʻē. ");
INSERT INTO ton_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Pea naʻa nau kai mo inu, ko ia mo e kau tangata naʻe ʻiate ia, pea nau mohe ʻi he pō ko ia: pea nau tuʻu hake ʻi he pongipongi, pea naʻa ne pehē, “Tuku au ke u ʻalu ki heʻeku ʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pea pehēange ʻe hono tuongaʻane mo ʻene faʻē, “Tuku muʻa ke mau nonofo mo e taʻahine ʻi he ʻaho niʻihi, ʻae ʻaho ʻe hongofulu nai; pea hili ia ʻe toki ʻalu atu.” ");
INSERT INTO ton_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pea pehēange ʻe ia kiate kinaua, “ʻOua te mo taʻofi au, he kuo fakamonūʻia ʻe Sihova hoku hala: tuku au ke u ʻalu ki heʻeku ʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Pea naʻa na pehē, “Te ma ui ʻae taʻahine ʻo fehuʻi mei hono ngutu.” ");
INSERT INTO ton_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Pea naʻa na ui ʻa Lepeka, ʻo pehē kiate ia, “Te ke ʻalu mo e tangata ni?” Pea pehēange ʻe ia, “Te u ʻalu.” ");
INSERT INTO ton_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Pea naʻa nau tuku ʻa Lepeka ko honau tuofefine ke ne ʻalu mo hono fefine tauhi, mo e tamaioʻeiki ʻa ʻEpalahame, mo ʻene kau tangata. ");
INSERT INTO ton_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Pea naʻa nau tāpuaki ʻa Lepeka ʻo pehē kiate ia, “Ko homau tuofefine koe, ʻofa ke ke hoko koe ko e faʻē ʻoe ngaahi toko afe taʻefaʻalaua, pea ke maʻu ʻe ho hako ʻae matapā ʻonautolu ʻoku fehiʻa kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","¶ Pea naʻe tuʻu hake ʻa Lepeka mo hono kau fefine, pea nau heka ʻi he fanga kāmeli ʻo muimui ki he tangata; pea ʻave ʻa Lepeka ʻe he tamaioʻeiki, pea fononga ʻi hono hala. ");
INSERT INTO ton_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ka naʻe haʻu ʻa ʻAisake ʻi he hala mei he vai ko Lehai-Loʻai; he naʻa ne nofo ʻi he potu tonga. ");
INSERT INTO ton_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Pea ʻalu atu ʻa ʻAisake ki he ngoue ʻi he efiafi, ke ne lotu; pea ne hanga hake hono mata ʻo sio, pea vakai ʻoku haʻu ʻae fanga kāmeli. ");
INSERT INTO ton_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Pea hanga hake ʻe Lepeka hono mata, pea ʻi heʻene mamata kia ʻAisake, naʻe ʻalu hifo ia mei he kāmeli. ");
INSERT INTO ton_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","He kuo ʻosi ʻene fehuʻi ki he tamaioʻeiki, ʻo pehē, ‘Ko hai ʻae tangata ko ia ʻoku haʻu ʻi he ngoue ke fakafetaulaki mai kiate kitautolu?” Pea naʻe pehēange ʻe he tamaioʻeiki, “Ko ʻeku ʻeiki ia: ko ia naʻa ne toʻo ai ʻae pulupulu, ʻo fakapulou ʻaki ia.” ");
INSERT INTO ton_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Pea naʻe fakamatala ʻe he tamaioʻeiki kia ʻAisake ʻae ngaahi meʻa kotoa pē naʻa ne fai. ");
INSERT INTO ton_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Pea naʻe ʻomi ia ʻe ʻAisake ki he fale fehikitaki ʻo ʻene faʻē ko Sela, pea ne maʻu ʻa Lepeka, pea hoko ia ko hono uaifi: pea ʻofa ia kiate ia; pea naʻe fiemālie ʻa ʻAisake ʻi he hili ange ʻae pekia o ʻene faʻē. ");
INSERT INTO ton_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Pea toe maʻu ʻe ʻEpalahame ʻae uaifi, ko hono hingoa ko Ketula. ");
INSERT INTO ton_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Pea ne fanauʻi kiate ia ʻa Similani, mo Sokesani, mo Metani mo Mitiani: mo ʻIsipaka, mo Suaa. ");
INSERT INTO ton_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Pea naʻe fānau kia Sokesani ʻa Sipa mo Titani, pea ko e ngaahi foha ʻo Titani ko ʻAsuli, mo Litusi mo Leumi. ");
INSERT INTO ton_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Pea ko e ngaahi foha ʻo Mitiani: ko ʻEfaa, mo ʻEfee, mo Henoke, mo ʻApaita, mo Elitaa. Ko e ngaahi fānau eni ʻa Ketula. ");
INSERT INTO ton_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","¶ Pea naʻe foaki ʻe ʻEpalahame ʻene meʻa kotoa pē kia ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ka ko e ngaahi foha ʻo ʻEpalahame ʻi hono sinifu, naʻe ʻatu ki ai ʻe ʻEpalahame ʻae ngaahi foaki, pea ʻi heʻene kei moʻui naʻa ne fekau ke nau ʻalu ki he feituʻu hahake, koeʻuhi ke ʻataʻatā ʻo hono foha ko ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Pea ko e ngaahi ʻaho ʻoe ngaahi taʻu naʻe moʻui ai ʻa ʻEpalahame, ko e taʻu ʻe teau mo e taʻu ʻe fitungofulu ma nima. ");
INSERT INTO ton_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Pea naʻe tukuange ʻe ʻEpalahame hono laumālie, pea pekia ia ʻi he motuʻa lelei, ko e tangata motuʻa kuo aʻu; pea naʻe fakataha ia ki hono kakai. ");
INSERT INTO ton_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Pea naʻe tanu ia ʻe hono ongo foha ko ʻAisake mo ʻIsimeʻeli, ʻi he ʻana ʻi Makipila, ʻi he ngoue ʻa ʻEfilone, ko e foha ʻo Sohaʻa, ko e Heti, ʻaia ʻoku fehangai mo Mamili. ");
INSERT INTO ton_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ko e ngoue ia naʻe fakatau ʻe ʻEpalahame mei he ngaahi foha ʻo Heti; naʻe tanu ʻi ai ʻa ʻEpalahame mo hono uaifi ko Sela. ");
INSERT INTO ton_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","¶ Pea hili ʻae pekia ʻa ʻEpalahame, naʻe tāpuakiʻi ʻe he ʻOtua hono foha ko ʻAisake: pea naʻe nofo ʻa ʻAisake ʻo ofi ki he vaikeli ko Lehai-Loʻai. ");
INSERT INTO ton_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","¶ Pea ko e hako eni ʻo ʻIsimeʻeli, ko e foha ʻo ʻEpalahame, ʻaia naʻe fanauʻi kia ʻEpalahame ʻe Hekaʻā ko e ʻIsipite, ko e kaunanga ʻa Sela. ");
INSERT INTO ton_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Pea ko e hingoa eni ʻoe ngaahi foha ʻo ʻIsimeʻeli, ko honau hingoa ʻi honau ngaahi toʻutangata; ko e ʻuluaki ʻo ʻIsimeʻeli, ko Nepeoti; mo Keta, mo ʻAtieli, mo Mipisami, ");
INSERT INTO ton_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mo Misima, mo Tumaʻā mo Masa: ");
INSERT INTO ton_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ko Hetaʻa, mo Tima, mo Situa, mo Nefisi, mo Kitema. ");
INSERT INTO ton_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ko e ngaahi foha ia ʻo ʻIsimeʻeli, pea ko honau hingoa ia, ʻi honau ngaahi kolo, ʻi honau ngaahi fale: ko e ʻeiki ʻe toko hongofulu ma toko ua, ʻo fakatatau mo honau ngaahi puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Pea ko e ngaahi taʻu eni ʻoe moʻui ʻa ʻIsimeʻeli, ko e taʻu ʻe teau mo e tolungofulu ma fitu: pea tukuange ʻe ia hono laumālie, pea pekia ia, pea fakataha ia ki hono kakai. ");
INSERT INTO ton_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Pea naʻa nau nofo mei Havila ʻo aʻu ki Sua, ʻaia ʻoku ofi ki ʻIsipite, ʻi he hala ki ʻAsilia; pea naʻe pekia ia ʻi he ʻao ʻo hono ngaahi kāinga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","¶ Pea ko e hako eni ʻo ʻAisake ko e foha ʻo ʻEpalahame: naʻe fānau kia ʻEpalahame ʻa ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Pea naʻe fāngofulu taʻu ʻae motuʻa ʻo ʻAisake, ʻi heʻene maʻu ʻa Lepeka ko hono uaifi, ko e ʻofefine ʻo Petueli, ko e Silia ʻa Petanalami, ko e tuofefine ʻo Lepani ko e Silia. ");
INSERT INTO ton_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Pea naʻe hūfia ʻe ʻAisake hono uaifi kia Sihova, he naʻe paʻa ia; pea tui kiate ia ʻa Sihova, pea feitama hono uaifi ko Lepeka. ");
INSERT INTO ton_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Pea naʻe fengaueʻi ʻae fānau ʻiate ia; pea pehē ʻe ia, “Kapau ʻoku moʻoni, ko e hā ʻoku ou pehē ai?” Pea ʻalu ia ke fehuʻi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Pea naʻe pehē ʻe Sihova kiate ia, “ʻOku ai ʻae puleʻanga ʻe ua ʻi ho manāva, pea ʻe mahuʻi mei ho manava ʻae kakai ʻe ua, ʻo taki taha hono anga; pea ʻe mālohi ʻae kakai ʻe taha ki he taha; pea ʻe tauhi ʻe he ʻuluaki ʻae kimui.” ");
INSERT INTO ton_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","¶ Pea ʻi heʻene kakato hono ngaahi ʻaho ke fāʻele, pea vakai, naʻe ai ʻae māhanga ʻi hono manāva. ");
INSERT INTO ton_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Pea fāʻele ʻae ʻuluaki kuo kulokula kotoa pē, ʻo hangē ha kofu fulufulu: pea ne nau ui hono hingoa ko ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Pea toki fāʻeleʻi hono tehina, pea naʻe puke ʻe hono nima ʻae mui vaʻe ʻo ʻIsoa; pea naʻe ui hono hingoa ko Sēkope; pea naʻe onongofulu taʻu ʻa ʻAisake ʻi he fanauʻi ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Pea tupu ʻae ongo tama: pea naʻe poto ʻa ʻIsoa ʻi he tuli manu, ko e tangata taka ʻuta; ka ko e tangata angamalūʻia ʻa Sēkope, pea naʻe nofo ia ʻi he ngaahi fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Pea ʻofa ʻa ʻAisake kia ʻIsoa, he naʻa ne kai ʻa ʻene kanoʻi manu, ka naʻe ʻofa ʻa Lepeka kia Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","¶ Pea naʻe fei haka ʻa Sēkope; pea haʻu ʻa ʻIsoa mei he vao, pea kuo vaivai ia; ");
INSERT INTO ton_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Pea pehē ʻe ʻIsoa kia Sēkope, “ʻOku ou kole kiate koe, ke ke fafanga au ʻaki ʻae lū kulokula na, he kuo u vaivai; ko ia naʻe ui ai hono hingoa, ko ʻItomi.” ");
INSERT INTO ton_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Pea pehēange ʻe Sēkope, Fakatau kiate au he ʻaho ni, ʻae ʻinasi ʻoe ʻuluaki foha. ");
INSERT INTO ton_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Pea pehē ʻe ʻIsoa, “Vakai, kuo u teitei mate: pea ko e hā hono ʻaonga kiate au ʻoe ʻinasi ʻoe ʻuluaki foha?” ");
INSERT INTO ton_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Pea pehēange ʻe Sēkope; “Fuakava mai kiate au he ʻaho ni; pea ne fuakava kiate ia:” pea naʻa ne fakatau ʻae ʻinasi ʻoe ʻuluaki foha kia Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Pea toki ʻatu ai ʻe Sēkope kia ʻIsoa ʻae mā mo e haka lū; pea kai ia mo inu, pea ne tuʻu hake ʻo ʻalu ʻi hono hala; naʻe pehē ʻae siʻaki ʻe ʻIsoa ʻae ʻinasi ʻoe ʻuluaki foha. ");
INSERT INTO ton_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Pea naʻe tō ʻae honge ki he fonua: ka ʻoku taha kehe ʻae ʻuluaki honge ʻaia naʻe hoko ʻi he ngaahi ʻaho ʻo ʻEpalahame. Pea naʻe ʻalu ʻa ʻAisake ki Kela kia ʻApimeleki ko e tuʻi ʻoe kakai Filisitia. ");
INSERT INTO ton_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Pea naʻe hā mai ʻa Sihova kiate ia, ʻo ne pehē, “ʻOua naʻa ke ʻalu hifo ki ʻIsipite: nofo ʻi he fonua ʻaia te u fakahā kiate koe. ");
INSERT INTO ton_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ke ke nofomaʻu ʻi he fonua ni, pea teu ʻiate koe, pea te u tāpuakiʻi koe; he te u foaki kiate koe mo ho hako ʻae ngaahi fonua ni kotoa pē, pea te u fakamoʻoni ʻae fuakava ʻaia naʻaku fuakava ʻaki ki hoʻo tamai ko ʻEpalahame. ");
INSERT INTO ton_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Pea te u fakatupu ho hako ke tokolahi, ʻo hangē ko e ngaahi fetuʻu ʻoe langi; pea te u foaki ki ho hako ʻae ngaahi fonua ni kotoa pē; pea ʻe monūʻia ʻi ho hako ʻae puleʻanga kotoa pē ʻo māmani; ");
INSERT INTO ton_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Koeʻuhi naʻe talangofua ʻa ʻEpalahame ki hoku leʻo, mo ne maʻu ʻeku tala, mo ʻeku ngaahi fekau, mo ʻeku tuʻutuʻuni, mo ʻeku ngaahi fono.” ");
INSERT INTO ton_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","¶ Pea naʻe nofo ʻa ʻAisake ʻi Kela. ");
INSERT INTO ton_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Pea fehuʻi kiate ia ʻae kakai tangata ʻoe potu ko ia, ki hono uaifi: pea pehē ʻe ia, ko hoku tuofefine ia; he naʻe manavahē ia ke pehē atu, ‘Ko hoku uaifi ia;’ he naʻa ne pehē, telia naʻa tāmateʻi au ʻe he kau tangata ʻoe potu ni, koeʻuhi ko Lepeka; he naʻe hoihoifua ia ke mamata ki ai. ");
INSERT INTO ton_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Pea naʻe nofo ia ʻi ai ʻo fuoloa; pea ʻiloange, naʻe fakasio ʻa ʻApimeleki ko e tuʻi ʻoe kakai Filisitia, mei he tupa, ʻo ne mamata ʻoku fakavā ʻa ʻAisake mo Lepeka ko hono uaifi. ");
INSERT INTO ton_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Pea fekau ʻe ʻApimeleki ke haʻu ʻa ʻAisake, ʻo ne pehē, “Vakai, ko e moʻoni ko ho uaifi ia; pea ko e hā naʻa ke pehē ai, ko hoku tuofefine ia?” Pea talaange ʻe ʻAisake kiate ia, “Koeʻuhi naʻaku pehē, telia naʻaku mate koeʻuhi ko ia.” ");
INSERT INTO ton_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Pea pehē ʻe ʻApimeleki, “Ko e hā ʻae meʻa ni kuo ke fai kiate kimautolu? Ka ne mohe faainoa ha tokotaha mo ho uaifi; pehē kuo ke ʻomi ʻae kovi lahi kiate kimautolu.” ");
INSERT INTO ton_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Pea fai fono ʻe ʻApimeleki ki hono kakai, ʻo pehē, “Ko ia ʻe ala ki he tangata ni, pe ko hono uaifi, ko e moʻoni ʻe tāmateʻi ia.” ");
INSERT INTO ton_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Pea naʻe toki tō taʻu ʻe ʻAisake ʻi he fonua ko ia, pea ne utu ʻi he taʻu ko ia hono tupu ʻe tā tuʻo teau: pea naʻe tāpuaki ia ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pea naʻe tupu pe ʻae tangata, pea fakaʻaʻau ki muʻa ia, pea ne tupu ʻo lahi ʻaupito. ");
INSERT INTO ton_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","He naʻa ne maʻu ʻae fanga sipi lahi, mo e fanga manu, mo e kau tamaioʻeiki tokolahi; pea naʻe meheka ʻae kakai Filisitia kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","He ko e ngaahi vai kehekehe naʻe keli ʻe he kau tamaioʻeiki ʻa ʻene tamai, ʻi he ngaahi ʻaho ʻo ʻEpalahame, naʻe mapuni ia ʻe he kakai Filisitia ʻi hono tanu ʻaki ʻae kelekele. ");
INSERT INTO ton_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Pea pehē ʻe ʻApimeleki kia ʻAisake, “Ke ke ʻalu ʻiate kimautolu; he ʻoku ke mālohi hake koe ʻiate kimautolu.” ");
INSERT INTO ton_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Pea ʻalu mei ai ʻa ʻAisake, pea fokotuʻu hono fale fehikitaki ʻi he teleʻa ʻo Kela, pea nofo ai ia. ");
INSERT INTO ton_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Pea naʻe toe keli ʻe ʻAisake ʻae ngaahi vai, ʻaia naʻa nau keli ʻi he ngaahi ʻaho ʻo ʻene tamai ko ʻEpalahame: he naʻe tanu ia ʻe he kakai Filisitia, hili ʻae pekia ʻa ʻEpalahame: pea ne ui ʻaki ia ʻae ngaahi hingoa, ʻaia naʻe fakahingoa ʻaki ia ʻe heʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Pea naʻe keli ʻe he kau tamaioʻeiki ʻa ʻAisake ʻi he teleʻa ʻo nau ʻilo ai ʻae matavai moʻui. ");
INSERT INTO ton_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pea fakakikihi ʻe he kau tangata tauhimanu ʻa Kela, mo e kau tauhimanu ʻa ʻAisake, ʻo nau pehē, “ʻOku ʻamautolu ʻae vai;” pea ne ui hono hingoa ʻoe vai, ‘ko Eseki;’ ko e meʻa ʻi heʻenau ke mo ia. ");
INSERT INTO ton_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Pea naʻa nau keli ʻae vai ʻe taha, pea nau fakakikihi ki ai foki; pea ne ui hono hingoa ʻo ia ko Sitina. ");
INSERT INTO ton_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Pea hiki mei ai ia ʻo keli ʻae vai ʻe taha; pea naʻe ʻikai te nau fakakikihi ki ai; pea ne ui hono hingoa ʻo ia ko Leopote; pea ne pehē, “He ko eni, kuo fakaʻataʻatā ʻe Sihova ha potu kiate kitautolu, pea te tau tupu ʻi he fonua.” ");
INSERT INTO ton_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Pea naʻe ʻalu ia mei ai ki Peasipa. ");
INSERT INTO ton_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Pea hā mai ʻa Sihova kiate ia ʻi he pō ko ia, ʻo ne pehē kiate ia, “Ko e ʻOtua au ʻo hoʻo tamai ko ʻEpalahame; ʻOua naʻa ke manavahē, he ʻoku ou ʻiate koe, pea te u tāpuaki koe, pea fakatokolahi ho hako, koeʻuhi ko ʻeku tamaioʻeiki ko ʻEpalahame.” ");
INSERT INTO ton_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Pea fokotuʻu ʻe ia ʻi ai ʻae ʻesifeilaulau ʻo ne hū kia Sihova, pea fokotuʻu ʻe ia hono fale fehikitaki ʻi ai; pea keli ʻi ai ʻe he kau tamaioʻeiki ʻa ʻAisake ʻae vai. ");
INSERT INTO ton_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","¶ Pea naʻe ʻalu ʻa ʻApimeleki kiate ia mei Kela, pea mo hono kāinga ʻe taha ko ʻAhusate, mo Fikoli ko e ʻeiki ʻo ʻene kautau. ");
INSERT INTO ton_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Pea pehē ʻe ʻAisake kiate kinautolu, “Ko e hā ʻoku mou haʻu ai kiate au, ka ʻoku mou fehiʻa kiate au, pea kuo mou kapusi au meiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Pea naʻa nau pehē, “Naʻa mau mamata pau kuo ʻiate koe ʻa Sihova; pea naʻa mau pehē, ‘Ke tau fefuakavaʻaki mo koe, ʻio, ʻiate kitautolu mo koe, pea ke tau fai ʻae fuakava mo koe;’ ");
INSERT INTO ton_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ke ʻoua naʻa ke fai kovi kiate kimautolu, ʻo hangē ko ʻemau taʻeala kiate koe, pea kuo mau fai lelei pe kiate koe, pea mau tuku koe ke ke ʻalu fiemālie: pea ko eni, ko e monūʻia koe ʻia Sihova.” ");
INSERT INTO ton_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Pea naʻe teu ʻe ia hanau kātoanga, pea naʻa nau kai mo inu. ");
INSERT INTO ton_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Pea nau tuʻu hengihengi hake mo nau fefuakavaʻaki: pea naʻe tukuange ʻakinautolu ʻe ʻAisake, pea naʻa nau ʻalu ʻiate ia ʻi he fiemālie. ");
INSERT INTO ton_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Pea naʻe hoko ʻi he ʻaho ko ia ʻae haʻu ʻae kau tamaioʻeiki ʻa ʻAisake, ʻo nau fakahā kiate ia ʻae vai kuo nau keli, ʻo nau pehē kiate ia, “Kuo mau ʻilo ʻae vai.” ");
INSERT INTO ton_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Pea ne ui ia ko Sipa; ko ia ʻoku ui ai ʻae kolo ko ia ʻo aʻu ki he ʻaho ni, ko Peasipa. ");
INSERT INTO ton_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","¶ Pea naʻe fāngofulu ʻae taʻu ʻa ʻIsoa, pea ne maʻu kiate ia ʻa Sutiti ko hono uaifi, ko e ʻofefine ʻo Peli ko e tangata Heti, mo Pasimati ko e ʻofefine ʻo ʻElone ko e tangata Heti. ");
INSERT INTO ton_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ko e meʻa ko ia, naʻe mamahi ai ʻae loto ʻo ʻAisake mo Lepeka. ");
INSERT INTO ton_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Pea naʻe hoko ʻo pehē, ʻi heʻene motuʻa ʻa ʻAisake, pea kuo kui hono mata, pea naʻe ʻikai te ne faʻa sio, naʻa ne ui ki hono ʻuluaki foha ko ʻIsoa, ʻo ne pehē kiate ia, Ko hoku foha: pea ne pehē kiate ia, Vakai, ko au eni. ");
INSERT INTO ton_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Pea pehē ʻe ia, “Vakai mai, kuo u motuʻa, pea ʻoku ʻikai te u ʻilo ʻae ʻaho ʻo ʻeku mate. ");
INSERT INTO ton_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Pea ko eni, ʻoku ou kole kiate koe, ke ke toʻo hoʻo nāunau, ʻa hoʻo tangakaho, mo hoʻo kaufana, pea ke ʻalu ki he vao mo ke kumi maʻaku ha manu. ");
INSERT INTO ton_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Pea ke ngaohi maʻaku ha meʻakai ifo lelei, ʻo hangē ko ʻeku manako, pea ke ʻomi ia kiate au ke u kai; koeʻuhi ke tāpuaki koe ʻe hoku laumālie, ʻi he teʻeki ai teu mate.” ");
INSERT INTO ton_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Pea naʻe fanongo ʻa Lepeka ki he lea ʻa ʻAisake ki hono foha ko ʻIsoa. Pea naʻe ʻalu ʻa ʻIsoa ki he vao ke kumi ha manu mo ʻomi ia. ");
INSERT INTO ton_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","¶ Pea lea ʻa Lepeka ki heʻene tama ko Sēkope, ʻo pehē, “Vakai mai, naʻaku fanongo naʻe lea hoʻo tamai ki ho tokoua ko ʻIsoa, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Omi maʻaku ha manu, mo ngaohi maʻaku ʻae meʻakai lelei, koeʻuhi ke u kai ia, mo tāpuaki koe ʻi he ʻao ʻo Sihova, ʻi he teʻeki ai teu mate.’ ");
INSERT INTO ton_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Pea ko eni, ʻeku tama, Ke ke talangofua ki hoku leʻo, ʻo hangē ko ia te u fekau kiate koe. ");
INSERT INTO ton_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","‌ʻAlu leva ki he fanga kosi, mo ke ʻomi mei ai ʻae ongo ʻuhikiʻi kosi lelei ʻe ua: pea te u ngaohi ʻaki ia ki hoʻo tamai, ʻae meʻakai lelei, ʻo hangē ko ʻene manako. ");
INSERT INTO ton_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Pea te ke ʻave ia ki hoʻo tamai, koeʻuhi ke ne kai, pea koeʻuhi ke ne tāpuaki koe ʻi he teʻeki ai te ne pekia.” ");
INSERT INTO ton_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pea naʻe pehēange ʻe Sēkope ki heʻene faʻē ko Lepeka, “Vakai mai, ko e tangata fulufulu ʻa ʻIsoa ko hoku tokoua, pea ko e tangata molemole au. ");
INSERT INTO ton_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","E ala nai ʻe heʻeku tamai kiate au, pea te u hā atu kiate ia ko e kākā; pea te u ʻomi kiate au ha malaʻia, kae ʻikai ha tāpuaki.” ");
INSERT INTO ton_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pea pehēange ʻe heʻene faʻē kiate ia, “Ko ʻeku tama, ke ʻiate au pe ho malaʻia, ka ke tui pe ki hoku leʻo pea ke ʻalu ʻo ʻomi ia kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Pea naʻe ʻalu ia ō fetuku mo ʻomi ia ki heʻene faʻē; pea ngaohi ai ʻe heʻene faʻē ʻae meʻakai lelei, ʻo hangē ko e manako ʻa ʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Pea toʻo ʻe Lepeka ʻae ngaahi kofu lelei ʻo ʻene ʻuluaki tama ko ʻIsoa, ʻaia naʻe ʻiate ia ʻi he fale, pea ne ai ia ki heʻene tama ki mui ko Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Pea ne ai ʻae kiliʻi kosi ki hono nima mo e potu molemole ʻo hono kia. ");
INSERT INTO ton_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Pea ne ʻatu ʻae meʻakai lelei, mo e mā kuo ne ngaohi, ki he nima ʻo ʻene tama ko Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","¶ Pea naʻe ʻalu ia ki heʻene tamai, ʻo ne pehē, “Ko ʻeku tamai;” pea pehē ʻe ia, “Ko au eni; ka ko hai koe hoku foha?” ");
INSERT INTO ton_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Pea pehē ʻe Sēkope ki heʻene tamai, “Ko au ʻIsoa, ko ho ʻuluaki; kuo u fai ʻo hangē ko hoʻo fekau kiate au; pea ʻoku ou kole kiate koe, ke ke tuʻu hake, pea ke nofo ʻo kai mei heʻeku manu, koeʻuhi ke ke tāpuaki au.” ");
INSERT INTO ton_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Pea pehēange ʻe ʻAisake ki hono foha, “Hoku foha naʻe fēfeeʻi hao maʻu vave pehē mai ia?” Pea ne pehē kiate ia, “Koeʻuhi naʻe ʻomi ia kiate au ʻe Sihova ko ho ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pea pehē ʻe ʻAisake kia Sēkope, “Ko hoku foha ʻoku ou kole ke ke ʻunuʻunu mai, koeʻuhi ke u ala kiate koe ke u ʻilo pe ko hoku foha ko ʻIsoa moʻoni koe, pe ʻikai.” ");
INSERT INTO ton_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pea ʻunuʻunu atu ʻa Sēkope ki heʻene tamai ko ʻAisake; pea ne fāfā ia ʻo ne pehē, ‘Ko e leʻo, ko e leʻo ʻo Sēkope, ka ko e nima ko e nima ʻo ʻIsoa.” ");
INSERT INTO ton_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Pea naʻe ʻikai te ne ʻilo ia, koeʻuhi naʻe fulufulu hono nima, ʻo hangē ko e nima ʻo hono taʻokete, ko ʻIsoa: pea naʻa ne tāpuaki ia; ");
INSERT INTO ton_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Pea pehē ʻe ia, “Ko hoku foha ko ʻIsoa moʻoni koe?” Pea pehēange ʻe ia, “Ko au ia.” ");
INSERT INTO ton_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Pea pehē ʻe ia, “Omi ke ofi ia kiate au, pea te u kai ʻae kanoʻi manu ʻa hoku foha, koeʻuhi ke tāpuaki koe ʻe hoku laumālie.” Pea ne ʻomi ia ʻo ofi kiate ia, pea ne kai ai: pea ne ʻomi kiate ia ʻae uaine, pea ne inu ai. ");
INSERT INTO ton_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Pea pehē ʻe heʻene tamai ko ʻAisake kiate ia; “Ko hoku foha ke ke ʻunuʻunu mai, ʻo uma kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Pea ʻunuʻunu atu ia, pea uma kiate ia; pea ne nanamu ki he nanamu ʻo hono ngaahi kofu, ʻo ne tāpuaki ia, ʻo pehē, “Vakai, ko e nanamu ʻo hoku foha, ʻoku tatau mo e nanamu ʻoe ngoue kuo tāpuakiʻi ʻe Sihova: ");
INSERT INTO ton_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ko ia ke foaki kiate koe ʻe he ʻOtua ʻae hahau mei langi, mo e mahu ʻoe kelekele, pea mo e koane, mo e uaine, ʻo lahi: ");
INSERT INTO ton_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ke tauhi koe ʻe he ngaahi kakai, pea ke punou ʻae ngaahi puleʻanga kiate koe; ke ke ʻeiki koe ki ho kāinga, pea ke punou ʻae ngaahi tama ʻa hoʻo faʻē kiate koe; ke malaʻia ia te ne kapeʻi koe, pea ke monūʻia ia ʻoku ne tāpuakiʻi koe.” ");
INSERT INTO ton_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Pea pehē, kuo hili ʻae tāpuaki ʻe ʻAisake ʻa Sēkope, pea naʻe teʻeki ke meimei ʻalu ia mei he ʻao ʻo ʻene tamai ko ʻAisake, mo ʻene haʻu ʻa hono taʻokete ko ʻIsoa, mei heʻene tuli manu. ");
INSERT INTO ton_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Pea kuo ngaohi ʻe ia foki ʻae meʻakai ifo lelei, pea ne ʻomi ia ki heʻene tamai, pea pehē ʻe ia ki heʻene tamai, “Ke tuʻu hake ʻeku tamai, mo kai ʻae kanoʻi manu ʻa hono foha, pea ke tāpuaki au ʻe ho laumālie.” ");
INSERT INTO ton_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Pea pehēange ʻe heʻene tamai ko ʻAisake kiate ia, “Ko hai koe?” Pea talaange ʻe ia, “Ko au, ko ho foha, ko ho ʻuluaki ko ʻIsoa.” ");
INSERT INTO ton_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Pea tetetete lahi ʻaupito ʻa ʻAisake, ʻo ne pehē, “Ko hai? Kofaʻā ia naʻa ne maʻu ʻae kanoʻi manu, ʻo ʻomi kiate au, pea naʻaku kai ʻi he meʻa kotoa pē, pea naʻaku tāpuaki ia ʻi he teʻeki ai te ke haʻu koe? ʻIo pea ko e moʻoni ʻe monūʻia ia.” ");
INSERT INTO ton_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Pea kuo fanongo ʻa ʻIsoa ki he ngaahi lea ʻa ʻene tamai, pea tangi ia ʻi he leʻo lahi mo fakamamahi, ʻo ne pehē ki heʻene tamai, “Ke ke tāpuaki au, ʻio, ko au foki, ʻa ʻeku Tamai.” ");
INSERT INTO ton_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pea pehēange ʻe ia, “Naʻe haʻu ʻa ho tehina ʻi he kākā, pea kuo ne faʻao ʻo ʻave ʻa ho tāpuaki.” ");
INSERT INTO ton_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Pea pehē ʻe ia, “ʻIkai kuo totonu ʻae fakahingoa ia ko Sēkope? He kuo tuʻo ua ʻene muʻakiʻi au: naʻa ne toʻo ʻo ʻave ʻae lelei ʻoe taʻokete ʻiate au; pea ko eni kuo ne toʻo hoku tāpuaki. Pea pehē ʻe ia, “Kuo ʻikai ha tāpuaki te ke tuku maʻaku?” ");
INSERT INTO ton_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Pea talaange ʻe ʻAisake kia ʻIsoa, ʻo ne pehē; “Vakai mai, kuo u ngaohi ia ko hoʻo ʻeiki, pea ko hono ngaahi kāinga kuo u foaki kiate ia ko ʻene kau tamaioʻeiki: pea kuo u tokoni ʻaki ia ʻae koane mo e uaine: pea ko eni, ko e hā te u fai kiate koe hoku foha?” ");
INSERT INTO ton_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Pea pehēange ʻe ʻIsoa ki heʻene tamai, “He ʻoku taha pe hoʻo tāpuaki ʻa ʻeku tamai? Ke ke tāpuaki au, ʻio, ko au foki ʻa ʻeku tamai. Pea hiki hake ʻe ʻIsoa hono leʻo, pea tangi.” ");
INSERT INTO ton_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Pea pehēange ʻe heʻene tamai ko ʻAisake kiate ia, “Vakai, ko ho nofoʻanga ʻe ʻi he lelei ʻoe kelekele, pea mo e hahau ʻoe langi mei ʻolunga. ");
INSERT INTO ton_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Pea te ke moʻui ʻi hoʻo heletā, pea te ke tauhi ʻa ho tehina; pea ʻe hoko, ʻo pehē, ʻoka ke ka hoko ki he pule, te ke toki fesiʻi hono haʻamonga mei ho kia.” ");
INSERT INTO ton_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","¶ Pea naʻe fehiʻa ʻa ʻIsoa kia Sēkope, koeʻuhi ko e tāpuaki naʻe tāpuaki ʻaki ia ʻe heʻene tamai; pea pehē ʻe ʻIsoa ʻi hono loto, Ko eni kuo ofi ʻae ngaahi ʻaho ke tēngihia ʻa ʻeku tamai, pea te u toki tāmateʻi hoku tehina ko Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Pea naʻe fakahā kia Lepeka ʻae ngaahi lea ʻa ʻene ʻuluaki tama ko ʻIsoa: pea fekau ia ke ui ʻa ʻene tama ki mui ko Sēkope ʻo ne pehē kiate ia, “Vakai, ko ho taʻokete ko ʻIsoa, ʻoku ne fakafiemālieʻi ia, ʻi heʻene pehē, ke ne tāmateʻi koe. ");
INSERT INTO ton_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pea ko eni ʻeku tama, ke ke muitala ki hoku leʻo; pea ke tuʻu ʻo hola ki hoku tuongaʻane ko Lepani, ʻi Halani; ");
INSERT INTO ton_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Pea ke nofo mo ia ʻi he ʻaho niʻihi, ke ʻoua ke ʻosi ʻae ʻita ʻa ho taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ke ʻoua ke afe ʻae ʻita ʻa ho taʻokete meiate koe, pea ʻe ngalo ʻiate ia, ʻaia kuo ke fai kiate ia; pea te u toki fekau ʻo ʻomi koe mei ai: he koeʻumaʻā ʻeku masiva ʻiate kimoua ʻosi pe, ʻi he ʻaho pe taha?” ");
INSERT INTO ton_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Pea pehē ʻe Lepeka kia ʻAisake, “Kuo u fiu ʻi heʻeku moʻui, koeʻuhi ko e ngaahi ʻofefine ʻo Heti; he kapau ʻe fili ʻe Sēkope ha uaifi ʻi he ngaahi ʻofefine ʻo Heti, ʻo hangē ko kinautolu ni ʻae ngaahi ʻofefine ʻoe fonua, ko e hā hono ʻaonga ʻo ʻeku moʻui kiate au?” ");
INSERT INTO ton_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Pea ui ʻe ʻAisake ʻa Sēkope ʻo ne tāpuaki ia, ʻo ne naʻinaʻi kiate ia, mo ne pehē ki ai, “ʻOua naʻa ke fili ho uaifi mei he ngaahi ʻofefine ʻo Kēnani; ");
INSERT INTO ton_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ka ke tuʻu ʻo ʻalu ki Petanalami, ki he fale ʻo Petueli ko e tamai ʻa hoʻo faʻē; pea ke fili hao uaifi mei he ngaahi ʻofefine ʻo Lepani, ko e tuongaʻane ʻo hoʻo faʻē. ");
INSERT INTO ton_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Pea ke tāpuaki koe ʻe he ʻOtua Māfimafi, pea fakatupu mo fakatokolahiʻi koe, koeʻuhi ke ke hoko ko e fuʻu kakai tokolahi. ");
INSERT INTO ton_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Pea ke tuku kiate koe ʻae tāpuaki ʻo ʻEpalahame, pea ki ho hako foki; koeʻuhi ke ke maʻu ʻae fonua ʻaia ʻoku ke ʻāunofo ki ai, ʻaia naʻe foaki ʻe he ʻOtua kia ʻEpalahame.” ");
INSERT INTO ton_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Pea naʻe fekau ʻe ʻAisake ʻa Sēkope ke ne ʻalu: pea ʻalu ia ki Petanalami kia Lepani, ko e foha ʻo Petueli ko e tangata Silia, ko e tuongaʻane ʻo Lepeka, ko e faʻē ʻa Sēkope mo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","¶ Pea ʻi he mamata ʻa ʻIsoa kuo tāpuaki ʻe ʻAisake ʻa Sēkope, ʻo ne fekau ia ke ʻalu ki Petanalami, ke fili moʻona ha uaifi mei ai; pea mo ʻene tāpuaki ia mo naʻinaʻi kiate ia, ʻo pehē, ʻoua naʻa ke fili ha uaifi mei he ngaahi ʻofefine ʻo Kēnani: ");
INSERT INTO ton_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Pea mo ʻene talangofua ʻa Sēkope ki heʻene tamai mo ʻene faʻē, pea kuo ʻalu ia ki Petanalami; ");
INSERT INTO ton_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Pea ʻi he mamata ʻa ʻIsoa ʻoku ʻikai fiemālie ʻene tamai ko ʻAisake, ʻi he ngaahi ʻofefine ʻo Kēnani; ");
INSERT INTO ton_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Pea ʻalu ʻa ʻIsoa kia ʻIsimeʻeli, ʻo ne fakatokolahi ʻaki ʻae ngaahi uaifi naʻa ne maʻu ʻa Mehalate, ko e ʻofefine ʻo ʻIsimeʻeli, ko e foha ʻo ʻEpalahame, ko e tuofefine ʻo Nepeoti, ke mali mo ia. ");
INSERT INTO ton_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","¶ Pea ʻalu atu ʻa Sēkope mei Peasipa, mo ne fononga ki Halani. ");
INSERT INTO ton_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Pea hoko ia ki he potu ʻe taha, pea ne nofo ai ʻi he pō ko ia, he kuo tō ʻae laʻā; pea ne toʻo ʻae ngaahi maka ʻoe potu ko ia, ke ne ʻolunga ʻaki, pea naʻa ne tokoto ʻi he potu ko ia, ʻo mohe. ");
INSERT INTO ton_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Pea misi ia, pea vakai, kuo fokotuʻu ha tuʻunga ki he funga kelekele, pea tau hake hono potu ki he langi, pea vakai, naʻe feʻaluʻaki hake mo hifo ʻi ai ʻae kau ʻāngelo ʻae ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Pea vakai, naʻe ʻafio ʻa Sihova mei ʻolunga ʻi ai, pea pehē ʻe ia, “Ko au ko Sihova, ko e ʻOtua ʻo ʻEpalahame ko hoʻo tamai, pea ko e ʻOtua ʻo ʻAisake: ko e fonua ʻoku ke tokoto ai, te u foaki ia kiate koe, mo ho hako. ");
INSERT INTO ton_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Pea ʻe tatau ho hako mo e efu ʻoe kelekele, pea te ke mafola koe ki he lulunga mo e hahake, pea ki he tokelau mo e tonga: pea ʻe monūʻia ʻiate koe mo ho hako, ʻae ngaahi faʻahinga kotoa pē ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Pea vakai, ʻoku ou ʻiate koe, pea te u tauhi koe ʻi hoʻo fononga kotoa pē, pea te u toe ʻomi koe ki he fonua ni: koeʻuhi ʻe ʻikai te u siʻaki koe, ka te u fai ʻaia kuo u lea ai kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","¶ Pea ʻā hake ʻa Sēkope mei heʻene mohe, pea pehē ʻe ia, “Ko e moʻoni ʻoku ʻi heni ʻa Sihova; pea naʻe ʻikai te u ʻilo ia.” ");
INSERT INTO ton_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Pea naʻe manavahē ia, ʻo ne pehē, “ʻOku fakamanavahē ʻae potu ni! ʻOku ʻikai ko ha potu kehe eni, ka ko e fale ʻoe ʻOtua, pea ko eni ʻae matapā ʻoe langi.” ");
INSERT INTO ton_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Pea tuʻu hengihengi hake pe ʻa Sēkope, pea ne toʻo mai ʻae maka naʻa ne ʻolunga ʻaki, pea ne tō ia ko e pou, pea lilingi ʻe ia ʻae lolo ki ai. ");
INSERT INTO ton_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Pea ne ui ʻae hingoa ʻoe potu ko ia ko Peteli: ka ko hono hingoa ʻi muʻa ʻoe kolo ko ia ko Lusa. ");
INSERT INTO ton_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Pea fai ai ʻe Sēkope ʻae fuakava, ʻo pehē, “Kapau ʻe ʻiate au ʻae ʻOtua, pea ne tauhi au ʻi he hala ni ʻoku ou ʻalu ai, pea ne foaki kiate au ʻa ʻeku meʻakai, mo e ngaahi kofu ke u ai, ");
INSERT INTO ton_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Koeʻuhi ke u toe hoko ki he fale ʻo ʻeku tamai ʻi he fiemālie, pehē, te u ʻOtua ʻaki ʻa Sihova; ");
INSERT INTO ton_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","pea ko e maka ni, ʻaia kuo u tō ko e pou, ʻe hoko ia ko e fale ʻoe ʻOtua; pea ʻi he meʻa kotoa pē te ke tuku mai kiate au, te u ʻatu moʻoni hono vahe hongofulu kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Pea toe ʻalu ʻa Sēkope ʻi hono fononga, pea naʻe haʻu ia ki he fonua ʻoe kakai hahake. ");
INSERT INTO ton_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Pea sio ia, pea ne ʻilo ʻae vai ʻi he ngoue, pea vakai, naʻe ai ʻae vāhenga fanga sipi ʻe tolu, naʻe tokoto ʻo ofi ki ai, he naʻe fakainu ʻae fanga manu mei he vai ko ia: pea naʻe tāpuni ʻaki ʻae ngutu vai ʻae fuʻu maka lahi. ");
INSERT INTO ton_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Pea naʻe fakataha ki ai ʻae ngaahi vāhenga sipi kotoa pē: pea nau filifilihi ʻae maka mei he ngutu vai, pea fakainu ʻae fanga sipi, pea naʻe toe ai ʻae maka ki hono potu, ki he ngutu vai. ");
INSERT INTO ton_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Pea pehē ʻe Sēkope kiate kinautolu, “Kāinga, ʻoku mei fē ʻakinautolu?” Pea nau pehē, “Ko e kau Halani ʻakimautolu.” ");
INSERT INTO ton_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Pea pehē ʻe ia kiate kinautolu, “ʻOku mou ʻilo ʻa Lepani, ko e foha ʻo Nehoa?” Pea naʻa nau pehē, “ʻOku mau ʻilo ia.” ");
INSERT INTO ton_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Pea pehēange ʻe ia kiate kinautolu, “ʻOku moʻui ia?” Pea nau pehēange, “ʻOku mālōlō pe: pea vakai, ko Lesieli ko hono ʻofefine, ʻoku haʻu mo e fanga sipi.” ");
INSERT INTO ton_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Pea pehē ʻe ia, “Vakai, ʻoku kei hoʻatā pe, pea ʻoku teʻeki ai hokosia ʻae feituʻulaʻā ke fakataha ai ʻae fanga manu: ko ia mou fakainu ʻae fanga sipi, pea ʻalu ʻo fafanga.” ");
INSERT INTO ton_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Pea naʻa nau pehē, “ʻOku ʻikai te mau faʻa fai, kaeʻoua ke fakataha mai ʻae vāhenga sipi kotoa pē, pea ʻoua ke filifilihi ʻae maka mei he ngutu vai; pea te mau toki fakainu ʻae fanga sipi.” ");
INSERT INTO ton_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","¶ Pea lolotonga ʻenau alea mo e haʻu ʻa Lesieli mo e fanga sipi ʻa ʻene tamai, he naʻa ne tauhi ki ai. ");
INSERT INTO ton_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Pea ʻi he mamata ʻa Sēkope kia Lesieli ko e ʻofefine ʻo Lepani, ko e tuongaʻane ʻo ʻene faʻē, mo e fanga sipi ʻa Lepani, ko e tuongaʻane ʻo ʻene faʻē, naʻe ʻunuʻunu atu ʻa Sēkope ʻo ne tekaʻi ʻae maka mei he ngutu vai, pea ne fakainu ʻae fanga sipi ʻa Lepani, ko e tuongaʻane ʻo ʻene faʻē. ");
INSERT INTO ton_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Pea uma ʻa Sēkope kia Lesieli, pea hiki hake hono leʻo, pea tangi. ");
INSERT INTO ton_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Pea talaange ʻe Sēkope kia Lesieli, “Ko e kāinga ia ʻo ʻene tamai, pea ko e tama ia ʻa Lepeka:” pea naʻe lele ia ʻo fakahā ki heʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Pea kuo fanongo ʻa Lepani ki he talanoa kia Sēkope, “Ko e tama ʻa hono tuofefine,” pea naʻe lele ia ke fakafetaulaki kiate ia, pea ne fāʻufua ia, ʻo ʻuma kiate ia, mo ne ʻomi ia ki hono fale. Pea talanoa ʻe ia kia Lepani, ʻae ngaahi meʻa ni kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Pea pehē ʻe Lepani kiate ia, Ko e moʻoni ko hoku hui koe, mo hoku kakano. Pea naʻa ne nofo kiate ia ʻi he māhina ʻe taha. ");
INSERT INTO ton_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","¶ Pea pehē ʻe Lepani kia Sēkope, “He ʻoku totonu koā ke ke ngāue kiate au taʻehatotongi koeʻuhi ko hoku kāinga koe? Tala mai, ko e hā ʻae totongi ʻe fai kiate koe?” ");
INSERT INTO ton_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Pea naʻe toko ua ʻae ʻofefine ʻo Lepani; ko e hingoa ʻoe ʻuluaki ko Lia, pea ko e hingoa ʻoe kimui ko Lesieli. ");
INSERT INTO ton_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Naʻe mata kuikui ʻa Lia, ka naʻe hoihoifua ʻa Lesieli, mo matamatalelei. ");
INSERT INTO ton_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Pea naʻe ʻofa ʻa Sēkope kia Lesieli, pea ne pehē, “Te u tauhi ko e ʻi he taʻu ʻe fitu, ka ke tuku mai ʻa Lesieli, ko ho ʻofefine kimui.” ");
INSERT INTO ton_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Pea pehē ʻe Lepani, “ʻOku lelei lahi ʻeku foaki ia kiate koe, ʻi heʻeku foaki ia ki ha tangata kehe: ke ta nonofo mo au.” ");
INSERT INTO ton_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","¶ Pea naʻe ngāue ʻa Sēkope ʻi he taʻu ʻe fitu, ke ne maʻu ʻa Lesieli; pea naʻe tatau ia kiate ia mo e ʻaho siʻi pe, koeʻuhi ko ʻene ʻofa lahi kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Pea naʻe pehē ʻe Sēkope kia Lepani, “Tuku mai hoku uaifi koeʻuhi ke u ʻalu atu kiate ia, he kuo kakato ʻa hoku ngaahi ʻaho.” ");
INSERT INTO ton_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Pea fakataha ʻe Lepani ʻae kau tangata kotoa pē ʻoe potu, pea ne fai ʻae kātoanga. ");
INSERT INTO ton_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pea ʻi heʻene hoko ki he pō, naʻa ne ʻave hono ʻofefine ko Lia, ʻo ne ʻomi ia kiate ia; pea ʻalu ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Pea ne foaki ki hono ʻofefine ko Lia, ʻa ʻene kaunanga ko Silipa, ke kaunanga kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Pea pongipongi hake ai, pea vakai, pea tā ko Lia ia: pea pehē ʻe ia kia Lepani, “Ko e hā eni kuo ke fai kiate au? ʻIkai naʻaku ngāue kiate koe koeʻuhi ko Lesieli? Pea ko e hā kuo ke kākaaʻi ai au?” ");
INSERT INTO ton_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Pea pehē ʻe Lepani, “E ʻikai fai ha meʻa pehē ʻi homau fonua, ke tomuʻa foaki ʻae kimui ʻi he ʻuluaki. ");
INSERT INTO ton_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ka ke fakakakato ʻa hono uike, pea te mau foaki ia foki kiate koe, ʻoka ke ka toe ngāue kiate au, ʻi ha taʻu ʻe fitu kehe.” ");
INSERT INTO ton_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Pea naʻe fai ia ʻe Sēkope; ʻo ne fakakakato hono uike: pea ne foaki kiate ia hono ʻofefine ko Lesieli, ko hono uaifi foki. ");
INSERT INTO ton_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Pea foaki ʻe Lepani ki hono ʻofefine ko Lesieli ʻa Pila, ko ʻene kaunanga, ke kaunanga kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Pea naʻe ʻalu ʻa Sēkope kia Lesieli, pea ʻofa lahi hake ʻe ia kia Lesieli ia Lia, pea naʻa ne toe ngāue kiate ia ʻi he taʻu ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","¶ Pea ʻafioʻi ʻe Sihova kuo fehiʻanekina ʻa Lia, pea naʻa ne ngaohi ia ke faʻa fānau; ka naʻe paʻa ʻa Lesieli. ");
INSERT INTO ton_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Pea feitama ʻa Lia, pea ne fāʻeleʻi ʻae tama, pea ui hono hingoa ko Lupeni; he naʻe pehē ʻe ia, “Ko e moʻoni kuo ʻafioʻi ʻe Sihova ʻeku mamahi; pea ko eni ʻe ʻofa hoku husepāniti kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Pea naʻe toe feitama ia pea fāʻeleʻi ʻae tama: ʻo ne pehē, “He kuo fanongo ʻa Sihova kuo fehiʻanekina au, ko ia kuo ne foaki kiate au ʻae tama ni foki: pea ne ui hono hingoa ko Simione.” ");
INSERT INTO ton_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Pea toe feitama ia, pea fāʻeleʻi ʻae tama: pea pehē ʻe ia; “Ko eni ʻe tokanga hoku husepāniti kiate au ʻi he kuonga ni, koeʻuhi kuo u fanauʻi kiate ia ʻae tama ʻe toko tolu; ko ia naʻe ui ai hono hingoa ko Livai.” ");
INSERT INTO ton_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Pea toe feitama ia, pea fāʻeleʻi ʻae tama: pea pehē ʻe ia, Ko eni te u fakafetaʻi kia Sihova: ko ia naʻa ne ui hono hingoa ko Siuta: pea naʻe ngata ai ʻene fānau. ");
INSERT INTO ton_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Pea ʻi he mamata ʻa Lesieli ʻoku ʻikai haʻa ne fānau kia Sēkope, naʻe meheka ia ki hono taʻokete: pea pehē ʻe ia kia Sēkope, “Tuku mai ha fānau kiate au, telia naʻaku mate.” ");
INSERT INTO ton_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Pea tupu ai ʻae loto ʻo Sēkope kia Lesieli: pea pehē ʻe ia, “He ko e ʻOtua au, ʻaia kuo ne taʻofi meiate koe ʻae fua ʻoe manāva?” ");
INSERT INTO ton_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ka naʻe pehēange ʻe ia, “Vakai ki heʻeku kaunanga ko Pila, ke ke ʻalu kiate ia: pea te ne fānau ʻi hoku ongo tui koeʻuhi ke u maʻu ha fānau ʻiate ia. ");
INSERT INTO ton_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Pea ne foaki kiate ia ʻene kaunanga ko Pila ko hono uaifi, pea ʻalu ʻa Sēkope kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Pea naʻe tuituʻia ʻa Pila, pea fānau kia Sēkope ʻae tama.” ");
INSERT INTO ton_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Pea pehē ʻe Lesieli, “Kuo fakamaau au ʻe he ʻOtua, mo ne fanongo ki hoku leʻo, pea kuo ne foaki kiate au ʻae tama ko ia naʻa ne ui ai hono hingoa ko Tani.” ");
INSERT INTO ton_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Pea toe feitama ʻa Pila, ko e kaunanga ʻa Lesieli, pea ne fānau kia Sēkope ʻae tama ko hono tokoua. ");
INSERT INTO ton_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Pea pehē ʻe Lesieli, “ʻI he ʻahiʻahi lahi, naʻa ma ʻahiʻahi mo hoku taʻokete, pea kuo u lavaʻi: pea ne ui hono hingoa ko Nafitalai.” ");
INSERT INTO ton_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Pea ʻi he mamata ʻa Lia kuo ngata ʻene fānau, pea ʻave ʻe ia ʻene kaunanga ko Silipa, ʻo ne ʻatu ia kia Sēkope ko hono uaifi. ");
INSERT INTO ton_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Pea ko Silipa, ko e kaunanga ʻa Lia, naʻa ne fānau kia Sēkope ʻae tama. ");
INSERT INTO ton_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Pea pehē ʻe Lia, “ʻOku haʻu ʻae tokolahi: pea ne ui hono hingoa ko Kata.” ");
INSERT INTO ton_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Pea ko Silipa ko e kaunanga ʻa Lia, naʻa ne fānau kia Sēkope ʻae tama ʻe taha. ");
INSERT INTO ton_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Pea pehē ʻe Lia, “ʻOku monūʻia au, ʻe ui au ʻe he ngaahi ʻofefine ko e monūʻia pea ne ui hono hingoa ko ʻAseli.” ");
INSERT INTO ton_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","¶ Pea naʻe ʻalu ʻa Lupeni ʻi he ngaahi ʻaho ʻoe ututaʻu uite, pea ne ʻilo ʻae ngaahi tutai ʻi he ngoue, pea ne ʻomi ia ki heʻene faʻē ko Lia. Pea pehē ʻe Lesieli kia Lia, “ʻOku ou kole ke ke tuku mai foki, mei he ngaahi tutai ʻa hoʻo tama.” ");
INSERT INTO ton_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pea talaange ʻe ia kiate ia, “He ko e meʻa siʻi ia, hao faʻao hoku husepāniti? Pea te ke toʻo mo e ngaahi tutai ʻa ʻeku tama foki?” Pea pehē ʻe Lesieli, “E mohe ia mo koe he poōni, koeʻuhi ko e tutai ʻa hoʻo tama.” ");
INSERT INTO ton_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Pea haʻu ʻa Sēkope mei he ngoue ʻi he efiafi, pea ʻalu ʻa Lia ke fakafetaulaki kiate ia, ʻo ne pehē, “Ke ke haʻu kiate au; he ko e moʻoni kuo u fakatau koe ʻaki ʻae ngaahi tutai ʻa ʻeku tama.” Pea ne na mohe ʻi he pō ko ia. ");
INSERT INTO ton_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Pea naʻe ʻafio ʻae ʻOtua kia Lia, pea feitama ia, pea ne fāʻeleʻi kia Sēkope ʻae tama ʻe taha, ko hono toko nima ia. ");
INSERT INTO ton_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Pea pehē ʻe Lia, “Kuo tuku mai ʻe he ʻOtua ʻae totongi, koeʻuhi ʻi heʻeku foaki ʻeku kaunanga ki hoku husepāniti: pea ne ui hono hingoa ko ʻIsaka.” ");
INSERT INTO ton_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Pea toe feitama ʻa Lia, pea fānau kia Sēkope ʻae tama ko hono toko ono ia. ");
INSERT INTO ton_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Pea pehē ʻe Lia, “Kuo ʻomi ʻe he ʻOtua kiate au ʻae koloa lelei; ko eni ʻe toki fie nofo hoku husepāniti kiate au, koeʻuhi kuo u fanauʻi kiate ia, ʻae tama ʻe toko ono: pea ne ui hono hingoa ko Sepuloni.” ");
INSERT INTO ton_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pea ne toki fānau kiate ia ʻae taʻahine, pea ne ui hono hingoa ko Taina. ");
INSERT INTO ton_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","¶ Pea naʻe manatuʻi ʻe he ʻOtua ʻa Lesieli, ʻo ne tokanga kiate ia, pea ne ngaohi ia ke ne faʻa fānau. ");
INSERT INTO ton_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Pea feitama ia, pea fanauʻi ʻae tama; pea pehē ʻe ia, “Kuo toʻo ʻo ʻave ʻe he ʻOtua ʻa hoku manukia:” ");
INSERT INTO ton_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Pea naʻa ne ui hono hingoa ko Siosefa: ʻo ne pehē, “E ʻomi kiate au ʻe Sihova ʻae tama ʻe taha.” ");
INSERT INTO ton_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","¶ Pea kuo fāʻeleʻi ʻe Lesieli ʻa Siosefa, pea lea ʻa Sēkope kia Lepani, ʻo pehē, “Tuku au ke u ʻalu, koeʻuhi ke u ʻalu ki hoku potu, mo hoku fonua. ");
INSERT INTO ton_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Tuku mai hoku ngaahi uaifi, mo ʻeku fānau, ʻakinautolu naʻaku ngāue ai kiate koe, pea ke tuku ke u ʻalu: he ʻoku ke ʻilo ʻae ngāue kuo u fai kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pea kole ʻa Lepani, ʻo ne pehē kiate ia: “Kapau kuo u ʻofeina ʻi ho ʻao, ke ke nofo pe; he kuo u ʻilo pau kuo tāpuakiʻi au ʻe Sihova, koeʻuhi ko koe.” ");
INSERT INTO ton_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pea pehē ʻe ia, “Tala mai hao totongi, pea te u ʻatu ia.” ");
INSERT INTO ton_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Pea pehēange ʻe ia kiate ia, “ʻOku ke ʻilo pe naʻe fēfē ʻeku ngāue kiate koe, pea mo e ʻiate au ʻa hoʻo fanga manu.” ");
INSERT INTO ton_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","He naʻa ke maʻu siʻi pe, ʻi he heʻeki ai te u haʻu au; pea ko eni kuo tupu ia ʻo lahi ʻaupito; pea kuo tāpuaki koe ʻe Sihova talu ʻeku haʻu: pea ko eni, te u tokonaki afe, ki hoku fale foki ʻoʻoku?” ");
INSERT INTO ton_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Pea pehē ʻe ia, “Ko e hā te u foaki kiate koe?” Pea pehē ʻe Sēkope, “E ʻikai te ke foaki mai ha meʻa ʻe taha: ka ko eni kapau te ke fai ʻae meʻa ni kiate au, te u toe fafanga mo tauhi hoʻo fanga manu: ");
INSERT INTO ton_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Te u ʻalu ki hoʻo fanga manu he ʻaho ni, ʻo vaheʻi mei ai ʻae ilaila mo e pulepule, pea mo e fanga manu kelo mei he fanga sipi, pea mo e ilaila mo e pulepule mei he fanga kosi: pea ʻe ʻi he fanga manu pehē ʻa ʻeku totongi. ");
INSERT INTO ton_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Pea ʻe hā ai ʻa ʻeku angatonu ʻamui, ʻoka hoko ia ko ʻeku totongi ʻi ho ʻao; ko ia kotoa pē ʻe ʻiate au ʻoku ʻikai ilaila mo pulepule ʻi he fanga kosi, mo ia ʻoku ʻikai kelo ʻi he fanga sipi, ʻe lau ia ko ʻeku kaihaʻa.” ");
INSERT INTO ton_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Pea pehēange ʻe Lepani, “Ko hoku loto ke fai ʻo hangē ko hoʻo lea.” ");
INSERT INTO ton_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Pea ne vaheʻi ʻi he ʻaho ko ia ʻae fanga kosi tangata naʻe ilaila mo pulepule, pea mo e kosi fefine naʻe lavatea mo pulepule, pea ko ia kotoa pē naʻe hinehina hano potu, pea mo e kelo kotoa pē mei he fanga sipi, pea naʻa ne tuku ia ki he nima ʻo hono ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Pea naʻa ne fakamamaʻo mo Sēkope, ʻi he fononga mei ai ʻi he ʻaho ʻe tolu; pea tauhi ʻe Sēkope hono toe ʻoe fanga manu ʻa Lepani. ");
INSERT INTO ton_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Pea naʻe toʻo mai ʻe Sēkope ʻae ngaahi vaʻa ʻakau hinehina mo mata, ko e ʻakau ko e futu pea mo e ifi; pea ne fohifohiʻi hono kili, koeʻuhi ke hā mai ʻae ngaahi potu hinehina ʻi he ʻakau. ");
INSERT INTO ton_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Pea naʻa ne tuku ʻae ngaahi vaʻa ʻakau naʻa ne fohifohiʻi ʻi he tafeʻanga vai, mo e ngaahi tukuʻanga vai, ʻi he haʻu ʻae fanga manu ke inu, koeʻuhi ke nau tuituʻia ʻi heʻenau haʻu ke inu. ");
INSERT INTO ton_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Pea naʻe tuituʻia ʻae fanga manu ʻi he ʻao ʻoe ngaahi vaʻa ʻakau, pea fanauʻi ʻae ʻuhiki kuo lavatea mo pulepule, mo ilaila. ");
INSERT INTO ton_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Pea vavahe ʻe Sēkope ʻae fanga lami, pea ne fakahanga ʻae mata ʻoe fanga manu ki he lavatea, pea mo e faʻahinga kelo kotoa pē ʻi he fanga manu ʻa Lepani; pea ne tuku kehe pe ʻene fanga manu ʻaʻana, mei he fanga manu ʻa Lepani. ");
INSERT INTO ton_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Pea naʻe pehē, ʻi he tuituʻia ʻae manu mālohi, naʻe tuku ʻe Sēkope ʻae ngaahi vaʻa ʻakau ʻi he ʻao ʻoe fanga manu ʻi he tafeʻanga vai, koeʻuhi ke nau tuituʻia ʻi he lotolotonga ʻoe ngaahi ʻakau. ");
INSERT INTO ton_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ka naʻe ʻikai te ne ai ʻae ʻakau ki he ʻao ʻoe fanga manu vaivai: ko ia naʻe ia Lepani ʻae vaivai, pea naʻe ia Sēkope ʻae mālohi. ");
INSERT INTO ton_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Pea naʻe tupu ke koloaʻia ʻaupito ʻae tangata, pea lahi ʻene fanga manu, mo e kau kaunanga, mo e kau tamaioʻeiki, mo e fanga kāmeli, mo e fanga ʻasi. ");
INSERT INTO ton_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pea fanongo ia ki he lea ʻae ngaahi foha ʻo Lepani, ʻo pehē, “Kuo toʻo ʻe Sēkope ʻae ngaahi meʻa kotoa pē ʻa ʻetau tamai; pea kuo ne maʻu ʻae nāunau ni kotoa pē ʻi he meʻa ʻa ʻetau tamai.” ");
INSERT INTO ton_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Pea naʻe mamata ʻa Sēkope ki he mata ʻo Lepani, pea vakai, naʻe ʻikai lelei ia kiate ia ʻo hangē ko ia ʻi muʻa. ");
INSERT INTO ton_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Pea pehē ʻe Sihova kia Sēkope, “Foki atu ki he fonua ʻo hoʻo ngaahi tamai mo ho ngaahi kāinga; pea te u ʻiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Pea ʻalu ʻa Sēkope ʻo ne ui mai ʻa Lesieli mo Lia kiate ia ki he ngoue, ki he fanga manu. ");
INSERT INTO ton_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Pea pehē ʻe ia kiate kinaua, “ʻOku ou sio ki he mata ʻo hoʻomo tamai ʻoku ʻikai kei ʻiate au, ʻo hangē ko ia ʻi muʻa; ka kuo ʻiate au ʻae ʻOtua ʻo ʻeku tamai. ");
INSERT INTO ton_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Pea ʻoku mo ʻilo naʻaku ngāue ki hoʻomo tamai, ʻaki ʻa ʻeku mālohi kotoa. ");
INSERT INTO ton_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Pea kuo kākaaʻi au ʻe hoʻomo tamai, mo ne fakakehe ʻeku totongi ʻo liunga hongofulu; ka naʻe ʻikai tuku ia ʻe he ʻOtua ke u kovi ai. ");
INSERT INTO ton_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Kapau naʻa ne pehē ʻe ia, ‘Ke ʻoʻou ʻae pulepule ko hoʻo totongi,’ pea fānau leva ʻae fanga manu kotoa pē ko e pulepule: pea kapau naʻa ne pehē, ‘Ko hoʻo totongi ʻae ilaila;’ pea fānau leva ʻae fanga manu kotoa pē ko e ilaila. ");
INSERT INTO ton_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ko ia kuo toʻo ʻe he ʻOtua ʻae fanga manu ʻa hoʻomo tamai ʻo foaki ia kiate au. ");
INSERT INTO ton_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Pea ʻi he tuituʻia ʻae fanga manu, naʻaku hanga hake hoku mata, ʻo mamata ʻi he misi, pea vakai, ko e fanga sipitangata, naʻe hopo ki he fanga manu naʻe ilaila mo e pulepule mo e kelo. ");
INSERT INTO ton_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Pea lea ʻae ʻāngelo ʻae ʻOtua kiate au ʻi he misi, ʻo pehē, ‘Sēkope:’ pea naʻaku pehē, ‘Ko au eni.’ ");
INSERT INTO ton_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Pea pehē ʻe ia, “Hanga hake eni ho mata”, ʻo vakai, ‘Ko e fanga sipitangata ʻoku hopo ki he fanga manu, ko e ilaila mo e pulepule, mo e kelo; he kuo u mamata ki he meʻa kotoa pē ʻoku fai ʻe Lepani kiate koe. ");
INSERT INTO ton_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ko au ko e ʻOtua ʻo Peteli, ʻaia naʻa ke fakatapui ai ʻae pou, mo ke fai ʻae fuakava kiate au; pea ko eni, ke ke tuʻu, pea ke ʻalu ʻi he fonua ni, ʻo toe ʻalu ki he fonua ʻo ho ngaahi kāinga.’” ");
INSERT INTO ton_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Pea pehēange ʻe Lesieli mo Lia kiate ia, “He ʻoku kei ai ha ʻinasi pe tufakanga kiate kimaua ʻi he fale ʻoe ma tamai? ");
INSERT INTO ton_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","‌ʻIkai kuo ne lau ʻakimaua ko e ongo muli? He kuo ne fakatau ʻakimaua, pea kuo ne fakaʻosiʻosi foki ʻe ma paʻanga. ");
INSERT INTO ton_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","He ko e koloa kotoa pē kuo toʻo ʻe he ʻOtua mei heʻetau tamai ʻoku ʻatautolu ia, pea mo e tau fānau: pea ko eni, ko e meʻa kotoa pē kuo lea ʻaki ʻe he ʻOtua kiate koe, ke ke fai.” ");
INSERT INTO ton_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Pea tuʻu hake ʻa Sēkope, ʻo ne fakaheka ʻa ʻene fānau, mo hono ngaahi uaifi ki he fanga kāmeli; ");
INSERT INTO ton_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Pea naʻa ne ʻave ʻene fanga manu kotoa pē, mo ʻene meʻa kotoa pē ʻaia naʻa ne maʻu, ʻae fanga manu naʻe tupu kiate ia, ʻaia naʻa ne maʻu ʻi Petanalami, ke ʻalu ia ki heʻene tamai ko ʻAisake ki he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Pea naʻe ʻalu ʻa Lepani ke kosi ʻene fanga sipi: pea naʻe kaihaʻasi ʻe Lesieli ʻae ngaahi tamapua ʻa ʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Pea ʻalu fakafufū pe ʻa Sēkope meia Lepani, ko e tangata Silia, he naʻe ʻikai te ne tala kiate ia ʻene hola. ");
INSERT INTO ton_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ko ia naʻe hola ia mo ʻene meʻa kotoa pē: pea tuʻu hake ia ʻo ne laka ʻi he vaitafe, pea hanga hono mata ki he moʻunga ko Kiliate. ");
INSERT INTO ton_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","¶ Pea ʻi hono tolu ʻoe ʻaho, naʻe fakahā kia Lepani, ʻae hola ʻa Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Pea naʻa ne ʻalu mo hono kāinga tangata, pea nau tuli ia ʻi he ʻaho ʻe fitu; pea naʻa nau maʻu ia ʻi he moʻunga ko Kiliate. ");
INSERT INTO ton_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pea naʻe hāʻele mai ʻae ʻOtua kia Lepani ko e tangata Silia, ʻi he misi ʻi he pō, ʻo ne pehē kiate ia, “Vakai, ʻoua naʻa ke lea kia Sēkope ʻi he lelei pe ʻi he kovi.” ");
INSERT INTO ton_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","¶ Pea maʻu ʻe Lepani ʻa Sēkope. He naʻe fokotuʻu ʻe Sēkope hono fale fehikitaki ʻi he moʻunga; pea pehē foki ʻa Lepani mo hono kāinga, naʻa nau fokotuʻu fale fehikitaki ʻi he moʻunga ko Kiliate. ");
INSERT INTO ton_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Pea pehē ʻe Lepani kia Sēkope, “Ko e hā eni kuo ke fai, koeʻuhi kuo ke ʻalu fakafokifā pe, mo ke ʻave hoku ngaahi ʻofefine, ʻo hangē ko e ngaahi pōpula kuo maʻu ʻaki ʻae heletā? ");
INSERT INTO ton_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ko e hā kuo ke hola fakafufū ai, hangē ha kaihaʻa meiate au: pea naʻe ʻikai te ke tala kiate au, koeʻuhi ke u tuku ko e ke ʻalu ʻi he fiefia, mo e fai hiva, mo e tā ʻae lali mo e haʻape? ");
INSERT INTO ton_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Pea naʻe ʻikai te ke tuku ke u uma ki ho ngaahi foha, mo hoku ngaahi ʻofefine? Kuo ke fai vale ʻi hoʻo fai pehē. ");
INSERT INTO ton_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","‌ʻOku ai ʻae mālohi ʻi hoku nima ke fai kovi kiate koe: ka ko e ʻOtua ʻo hoʻo tamai naʻa ne folofola mai kiate au ʻanepō, ʻo pehē, ‘Vakai, ʻoua naʻa ke lea kia Sēkope, ʻi he lelei, pe ʻi he kovi.’ ");
INSERT INTO ton_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Pea ko eni, naʻe totonu hoʻo holi ke ʻalu, he ʻoku ke holi ki he fale ʻo hoʻo tamai, ka ko e hā kuo ke kaihaʻa ai hoku ngaahi ʻotua?” ");
INSERT INTO ton_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Pea lea ʻa Sēkope, ʻo ne pehē kia Lepani, “Koeʻuhi naʻaku manavahē, he naʻaku pehē, telia naʻa ke toʻo fakamālohi pe, ʻa ho ngaahi ʻofefine ʻiate au. ");
INSERT INTO ton_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pea ko ia te ke ʻilo ki ai ʻa ho ngaahi ʻotua ke ʻoua naʻa moʻui ia; ʻi he ʻao ʻo ho ta kāinga, ke ke vakai ʻae meʻa ʻaʻau, pea ke toʻo ia kiate koe.” He naʻe ʻikai ʻilo ʻe Sēkope kuo kaihaʻasi ia ʻe Lesieli. ");
INSERT INTO ton_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Pea hū atu ʻa Lepani ki he fale fehikitaki ʻo Sēkope, mo e fale fehikitaki ʻo Lia, pea mo e fale fehikitaki ʻe ua ʻoe ongo kaunanga; ka naʻe ʻikai te ne ʻilo ia. Pea ʻalu ia mei he fale fehikitaki ʻo Lia, mo ne hū ki he fale fehikitaki ʻo Lesieli. ");
INSERT INTO ton_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ka kuo toʻo ʻe Lesieli ʻae ngaahi tamapua, ʻo ne ʻai ia ki he nāunau ʻoe fanga kāmeli, pea heka ai ia. Pea kumi ʻe Lepani ʻi he potu kotoa pē ʻoe fale fehikitaki, ka naʻe ʻikai te ne ʻilo ia. ");
INSERT INTO ton_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Pea pehē ʻe ia ki heʻene tamai. “Ke ʻoua naʻa tuputāmaki ʻa ʻeku ʻeiki, koeʻuhi ʻoku ʻikai te u faʻa tuʻu; he ʻoku ʻiate au ʻae anga fakafefine.” Pea naʻe kumi ia, ka naʻe ʻikai te ne ʻilo ʻae ngaahi tamapua. ");
INSERT INTO ton_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Pea naʻe ʻita ʻa Sēkope ʻo lea lahi kia Lepani: pea lea ʻa Sēkope ʻo pehē, kia Lepani, “Ko e hā ʻeku fai kovi? Pea ko e hā ʻeku angahala koeʻuhi ke ke tuli ai au ʻi he lili ni? ");
INSERT INTO ton_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","He kuo ke kumi ʻi heʻeku meʻa kotoa pē, pea ko e hā hao meʻa kuo ke ʻiloʻi? Fokotuʻu ia ʻi he ʻao ʻo hoku kāinga, mo ho kāinga, koeʻuhi ke nau fakamaau kiate kitaua. ");
INSERT INTO ton_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Naʻaku ʻiate koe ʻi he taʻu ʻe uofulu ni, naʻe ʻikai ʻuhimate ʻa hoʻo fanga sipi fefine, mo e fanga kosi fefine, pea ko e sipitangata ʻo hoʻo fanga manu, naʻe ʻikai te u kai. ");
INSERT INTO ton_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ko ia naʻe kai ʻe he manu fekai naʻe ʻikai te u ʻomi kiate koe: naʻaku totongi ia; naʻa ke maʻu ʻae totongi ʻo ia ʻi hoku nima, kapau naʻe kaihaʻa ia ʻi he ʻaho, pe ʻi he pō. ");
INSERT INTO ton_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Naʻaku pehē au, pea naʻe fakavaivai au ʻe he pupuha ʻi he ʻaho, mo e momoko ʻi he pō; pea mahuʻi ʻae mohe mei hoku mata. ");
INSERT INTO ton_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kuo u pehē ni ʻi he taʻu ʻe uofulu ʻi ho fale; naʻaku tauhi koe ʻi he taʻu ʻe hongofulu ma fā, koeʻuhi ko ho ongo ʻofefine, mo e taʻu ʻe ono ki hoʻo fanga manu; pea kuo ke fakakehe ʻeku totongi ʻo liunga hongofulu. ");
INSERT INTO ton_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ka ne ʻikai ʻiate au ʻae ʻOtua ʻo ʻeku tamai, ko e ʻOtua ʻo ʻEpalahame, mo e manavahē kia ʻAisake, pehē kuo ke fekau au ke u ʻalu taʻehaʻakumeʻa.” Kuo ʻafioʻi ʻe he ʻOtua hoku tautea, mo e ngāue ʻa hoku nima, pea ne valoki ko e ʻanepō. ");
INSERT INTO ton_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","¶ Pea pehē mai ʻa Lepani kia Sēkope, “Ko e ngaahi ʻofefine ni, ko hoku ngaahi ʻofefine, pea ko e tamaiki ni, ko ʻeku fānau, pea ko e fanga manu ni, ko ʻeku fanga manu, pea ko e meʻa kotoa pē ʻoku ke mamata ki ai ʻoku ʻaʻaku ia: pea ko e hā nai te u fai he ʻaho ni, ki hoku ongo ʻofefine ni, mo e na fānau kuo na fanauʻi? ");
INSERT INTO ton_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ko eni ke ke haʻu, ke ta fai ʻae fuakava, ʻa koe mo au; pea tuku ia ko e fakamoʻoni kiate kitaua.” ");
INSERT INTO ton_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Pea toʻo ʻe Sēkope ʻae maka, ʻo ne fokotuʻu ia ko e pou. ");
INSERT INTO ton_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Pea pehē ʻe Sēkope ki hono kāinga, “Tānaki ʻae ngaahi maka; pea naʻa nau toʻo ʻae ngaahi maka ʻo fokotuʻu; pea naʻa nau kai ʻi ai, ʻi he fanga maka.” ");
INSERT INTO ton_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Pea ui ia ʻe Lepani, ko Sekaa Satuta; ka naʻe ui ia ʻe Sēkope, ko Kaleti. ");
INSERT INTO ton_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Pea pehē ʻe Lepani, “Ko e fokotuʻunga maka ni, ko e fakamoʻoni kiate koe mo au he ʻaho ni. Ko ia naʻe ui ai hono hingoa ko Kaleti mo Misipa.” ");
INSERT INTO ton_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","He naʻe pehē ʻe ia, “Ke leʻohi ʻe Sihova kiate au mo koe, ʻi he ʻe ta māvae. ");
INSERT INTO ton_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kapau te ke fakamamahi hoku ongo ʻofefine, pea kapau te ke toʻo maʻau ha uaifi kehe, mo hoku ongo ʻofefine, ʻoku ʻikai ha tangata ʻi heni; kae vakai, ko e fakamoʻoni ʻae ʻOtua kiate kitaua:” ");
INSERT INTO ton_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Pea pehē ʻe Lepani kia Sēkope, “Vakai ki he ngaahi maka ni, mo e pou ʻaia kuo tuku ʻi ho ta vahaʻa; ");
INSERT INTO ton_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ke fakamoʻoni ʻe he ʻesi ni, mo e pou ni, ʻe ʻikai te u laka ʻi he potu ʻoe ʻesi ni kiate koe, pea ʻe ʻikai te ke laka ʻi he ʻesi ni kiate au, ke fai ha kovi. ");
INSERT INTO ton_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ko e ʻOtua ʻo ʻEpalahame, mo e ʻOtua ʻo Nehoa, ko e ʻOtua ʻo ʻena tamai, fakamaau kiate kitaua.” Pea naʻe fuakava ʻa Sēkope, ʻi he manavahē ʻo ʻene tamai ko ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Pea feilaulau ʻa Sēkope ʻi he moʻunga, pea naʻa ne ui hono kāinga ke nau kai: pea naʻa nau kai ʻae mā, pea nau mohe ʻi he moʻunga ʻi he pō ko ia. ");
INSERT INTO ton_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Pea tuʻu hengihengi hake pe ʻa Lepani, mo ne uma ki hono ngaahi foha, mo hono ongo ʻofefine, ʻo ne tāpuaki ʻakinautolu; pea ʻalu ʻa Lepani, ʻo toe foki ki hono potu. ");
INSERT INTO ton_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Pea naʻe ʻalu ʻa Sēkope ʻi hono hala, pea fakafetaulaki mai kiate ia ʻae kau ʻāngelo ʻae ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Pea kuo mamata ʻa Sēkope kiate kinautolu, pea pehē ʻe ia, “Ko e kau tau eni ʻae ʻOtua: pea naʻa ne ui ʻae hingoa ʻoe potu ko ia, ko Mehanemi.” ");
INSERT INTO ton_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","¶ Pea fekau ʻe Sēkope ʻae kau talafekau ke muʻomuʻa ʻiate ia ki hono taʻokete ko ʻIsoa, ʻi he fonua ko Seia, ʻi he fonua ko ʻItomi. ");
INSERT INTO ton_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Pea ne fekau kiate kinautolu, ʻo pehē, “Te mou lea pehē ki hoku ʻeiki ko ʻIsoa; ʻoku pehē mai ʻa hoʻo tamaioʻeiki ko Sēkope, Naʻaku nofo ʻāunofo mo Lepani peau nofo mo ia ʻo aʻu ki he kuonga ni. ");
INSERT INTO ton_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Pea kuo u maʻu ʻae fanga pulu mo e fanga ʻasi mo e ngaahi fanga manu, mo e kau tangata tauhi, mo e kau fefine tauhi, pea kuo u fekau ke fakahā ia ki hoku ʻeiki, koeʻuhi ke u lelei ʻi ho ʻao.” ");
INSERT INTO ton_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","¶ Pea toe liu mai ʻae kau tangata kia Sēkope, ʻo nau pehē, “Naʻa mau hoko ki ho taʻokete ko ʻIsoa, pea vakai, ʻoku haʻu ia foki ke fakafetaulaki mai kiate koe, mo e kau tangata ʻe fāngeau.” ");
INSERT INTO ton_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Pea naʻe manavahē ai ʻa Sēkope, ʻo mamahi lahi: pea ne vaeua ʻae kakai naʻe ʻiate ia, pea mo e fanga sipi, mo e fanga manu lalahi, pea mo e fanga kāmeli. ");
INSERT INTO ton_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Pea ne pehē, “Kapau ʻe haʻu ʻa ʻIsoa ki he kakai ʻe taha ʻo taaʻi ia, pea ko e kakai ʻe toe te nau hao.” ");
INSERT INTO ton_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","¶ Pea pehē ʻe Sēkope, “E ʻOtua ʻo ʻeku tamai ko ʻEpalahame, mo e ʻOtua ʻo ʻeku tamai ko ʻAisake, ko e ʻEiki naʻa ke pehē mai kiate au, ‘Toe ʻalu ki ho fonua mo ho kāinga, pea te u fai lelei kiate koe:’ ");
INSERT INTO ton_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","‌ʻOku ʻikai te u taau au, mo e siʻi hifo ʻo hoʻo ʻaloʻofa kotoa pē, mo e moʻoni kotoa pē, ʻaia kuo ke fakahā ki hoʻo tamaioʻeiki: he naʻaku ʻalu mo hoku tokotoko pe ʻi he Sioatani ni; ka ko eni, kuo u hoko ko e kakai ʻe ua. ");
INSERT INTO ton_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","‌ʻOku ou kole kiate koe, fakahaofi au mei he nima ʻo hoku taʻokete mei he nima ʻo ʻIsoa: he ʻoku ou manavahē kiate ia, telia naʻa ne haʻu ʻo taaʻi au, pea mo e fale mo e fānau. ");
INSERT INTO ton_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pea naʻa ke pehē, ‘Te u fai lelei kiate koe, ʻo ngaohi ho hako ke tatau mo e ʻoneʻone ʻoe tahi, ʻaia ʻe ʻikai faʻa lau hono lahi.’” ");
INSERT INTO ton_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","¶ Pea mohe ia ʻi ai ʻi he pō ko ia pea naʻa ne fili mai ʻaia naʻe ofi kiate ia, ko e meʻaʻofa ki hono taʻokete ko ʻIsoa; ");
INSERT INTO ton_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ko e kosi fefine ʻe uangeau mo e kosi tangata ʻe uofulu, mo e sipi fefine ʻe uangeau, mo e sipitangata ʻe uofulu. ");
INSERT INTO ton_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ko e kāmeli huhu ʻe tolungofulu mo honau ʻuhiki, mo e fanga pulu fefine ʻe fāngofulu, mo e pulu tangata ʻe hongofulu, mo e ʻasi fefine ʻe uofulu mo e ʻuhiki ʻe hongofulu. ");
INSERT INTO ton_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Pea ne tuku fakafaʻahinga ia ki he nima ʻoe kau tauhi, pea ne pehē ki heʻene kau tamaioʻeiki, “Mou muʻomuʻa ʻiate au, ʻo fakavahavaha ʻae faʻahinga manu taki taha.” ");
INSERT INTO ton_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Pea fekau ia ki he ʻuluaki, ʻo pehē, “ʻOka fakafetaulaki mai hoku taʻokete ko ʻIsoa kiate koe, ʻo fehuʻi kiate koe, ʻo pehē, ‘Ko hai koe?’ pea, ‘ʻOku ke ʻalu ki fē?’ Pea ʻoku ʻa hai ʻena ʻi ho ʻao? ");
INSERT INTO ton_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Pea ke lea ʻo pehē, ‘Ko e meʻa ʻa hoʻo tamaioʻeiki ko Sēkope, pea ko e meʻaʻofa ia kuo ne fekau ki hoku ʻeiki ko ʻIsoa; pea vakai, ʻoku ne muimui mai.’” ");
INSERT INTO ton_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Pea naʻa ne fekau pehē ki hono toko ua, mo hono toko tolu, mo kinautolu kotoa pē naʻe muimui ki he fanga manu, ʻo pehē, “Te mou lea pehē ki hoku ʻeiki ko ʻIsoa, ʻoka mou ka fetaulaki mo ia. ");
INSERT INTO ton_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pea te mou pehē foki, ‘Vakai, ʻoku muimui mai ʻa hoʻo tamaioʻeiki ko Sēkope.’” He naʻe pehē ʻe ia, “Te u fakafiemālieʻi ia ʻaki ʻae meʻaʻofa, ʻe muʻomuʻa ʻiate au, pea te u toki mamata ki hono mata; heiʻilo pe te ne maʻu lelei au.” ");
INSERT INTO ton_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ko ia naʻe ʻave ai ʻae meʻaʻofa, ʻo nau muʻomuʻa ʻiate ia ki he kauvai ʻe taha; pea mohe ia ʻi he pō ko ia mo e kakai. ");
INSERT INTO ton_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Pea tuʻu hake ia ʻi he pō ko ia ʻo ne ʻave hono ongo uaifi, mo ʻene ongo kaunanga, mo hono ngaahi foha ʻe toko hongofulu ma tokotaha, pea nau aʻa ʻi he aʻaʻanga ko Sapoki. ");
INSERT INTO ton_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pea naʻa ne ʻave ʻakinautolu ʻo fekau ke nau aʻa ki he kauvai ʻe taha, pea ne ʻave mo ʻene meʻa kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","¶ Ka naʻe nofo tokotaha pe ʻa Sēkope; pea naʻe ai ʻae tangata naʻa na fefaʻuhi mo ia ʻo aʻu ki he mafoa ʻae ata. ");
INSERT INTO ton_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pea ʻi heʻene mamata ʻoku ʻikai te ne mālohi kiate ia, naʻa ne alasi ʻae tefito tupu ʻo Sēkope: pea naʻe homo ʻae tenga ʻo Sēkope, ʻi he ʻena fefaʻuhi mo ia. ");
INSERT INTO ton_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Pea naʻa ne pehē, “Tuku au ke u ʻalu, he kuo maʻa ʻae ʻaho;” pea ne pehē, “E ʻikai te u tukuange koe ʻo kapau ʻe ʻikai te ke tāpuaki au.” ");
INSERT INTO ton_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Pea ne pehē kiate ia, “Ko hai ho hingoa?” Pea ne pehē, “Ko Sēkope.” ");
INSERT INTO ton_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Pea pehē ʻe ia, “E ʻikai toe ui ho hingoa ko Sēkope, ka ko ʻIsileli: he ʻoku hangē ko ha ʻeiki ʻa hoʻo fai mālohi ki he ʻOtua, mo e tangata, pea kuo ke lavaʻi.” ");
INSERT INTO ton_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Pea fehuʻi ʻe Sēkope kiate ia, ʻOku ou kole kiate koe, ke ke tala mai ho hingoa. Pea pehē ʻe ia, “Ko e hā ʻoku ke fehuʻi ai ki hoku hingoa?” Pea naʻa ne tāpuaki ia ʻi ai. ");
INSERT INTO ton_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Pea ne ui ʻe Sēkope ʻae hingoa ʻoe potu ko ia, ko Penieli. He kuo u mamata ki he ʻOtua, ko e mata ki he mata, ka ʻoku ou kei moʻui. ");
INSERT INTO ton_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Pea ʻi heʻene ʻalu ʻi Penieli, naʻe hopo ʻae laʻā, pea naʻe ketu ia koeʻuhi ko hono tenga. ");
INSERT INTO ton_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ko ia naʻe ʻikai kai ai ʻe he fānau ʻa ʻIsileli ʻae uoua naʻe alasi, ʻaia ʻoku ʻi he aoʻi tenga, ʻo aʻu ki he ʻaho ni: koeʻuhi naʻa ne alasi ʻae aoʻi tupu ʻo Sēkope ʻi he uoua naʻe mingi. ");
INSERT INTO ton_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Pea hanga hake ʻa Sēkope ʻo sio, pea vakai, naʻe haʻu ʻa ʻIsoa, mo e kau tangata ʻe toko fāngeau. Pea vaheʻi ʻe ia ʻae fānau, kia Lia, mo Lesieli, pea mo e ongo kaunanga. ");
INSERT INTO ton_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Pea ne fakamuʻomuʻa ʻae ongo kaunanga mo ʻena fānau, pea hoko ʻa Lia mo ʻene fānau, pea fakamuimui ʻa Lesieli mo Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Pea ne muʻomuʻa ia ʻiate kinautolu, pea punou hifo ia ʻo tuʻo fitu ki he kelekele, ʻi heʻene ʻunuʻunu atu ki hono taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ka naʻe lele ʻa ʻIsoa ke fakafetaulaki kiate ia, pea ne fāʻofua ia ki hono kia, pea uma kiate ia: pea naʻa na fetāngihi. ");
INSERT INTO ton_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Pea hanga hake hono mata, ʻo ne sio ki he kau fefine mo e tamaiki: pea pehē ʻe ia, “Ko hai ʻakinautolu ni ʻoku ʻiate koe?” Pea pehēange ʻe ia, “Ko e fānau, kuo foaki ʻe he ʻOtua ʻaloʻofa ki hoʻo tamaioʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Pea naʻe toki ʻunuʻunu mai ʻo ofi, ʻae ongo kaunanga, ʻakinaua mo ʻena fānau, pea naʻa nau punou. ");
INSERT INTO ton_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Pea haʻu ʻo ofi ʻa Lia foki mo ʻene fānau, pea punou ʻakinautolu: pea haʻu fakamui ʻa Siosefa mo Lesieli ʻo ofi, pea punou ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Pea pehē ʻe ia, “Ko e hā hono ʻuhinga ʻoe ngaahi fanga manu naʻa mau fehikitaki mo au?” Pea pehē ʻe ia, “Ko e meʻa ke ʻofeina ai au ʻi he ʻao ʻo hoku ʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Pea pehē ʻe ʻIsoa, “Ko hoku tehina, kuo lahi ʻeku meʻa; ke ʻiate koe pe, ʻaia ʻoku ʻaʻau.” ");
INSERT INTO ton_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pea pehēange ʻe Sēkope, “ʻOua, ko eni, ʻoku ou kole kiate koe, kapau ʻoku ou lelei ʻi ho ʻao, pea ke maʻu ʻeku meʻaʻofa mei hoku nima; he ko ia kuo u mamata ai ki ho mata, ʻo hangē ko e fofonga ʻoe ʻOtua, pea kuo ke lelei kiate au. ");
INSERT INTO ton_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","‌ʻOku ou kole ke ke maʻu ʻeku tāpuaki, ʻaia kuo ʻomi kiate koe; koeʻuhi kuo fai lelei ʻe he ʻOtua kiate au, pea kuo u maʻu ʻo lahi.” Pea naʻa ne fakalotoʻi ia, pea ne toʻo ia. ");
INSERT INTO ton_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Pea pehē ʻe ia, “Ke tau fononga pea tau ō, pea te u muʻomuʻa ʻiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pea pehēange ʻe ia kiate ia, “ʻOku ʻilo ʻe hoku ʻeiki ʻoku vaivai ʻae tamaiki, pea ʻoku ʻiate au ʻae fanga manu feitama: pea kapau ʻe fakateka mālohi ʻakinautolu ʻe he kau tangata, ʻi he ʻaho pe taha, ʻe mate ai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","‌ʻOku ou kole kiate koe, ke muʻomuʻa ʻa hoku ʻeiki ʻi heʻene tamaioʻeiki; pea te u muimui atu ʻo fakatuotuai, ʻo fakatatau ki he faʻa fai ʻe he fanga manu, mo e tamaiki, ʻa ʻenau muʻomuʻa ʻiate au, ke ʻoua ke u hoko ki hoku ʻeiki ʻi Seia.” ");
INSERT INTO ton_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Pea talaange ʻe ʻIsoa, “Tuku ke nofo kiate koe hā niʻihi ʻiate kinautolu ʻoku ʻiate au:” pea pehē ʻe ia, “Ko e hā hono ʻaonga?” Tuku ke u lelei ʻi he ʻao ʻo hoku ʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","¶ Pea tafoki ʻa ʻIsoa ʻi he ʻaho ko ia ke ʻalu ki Seia. ");
INSERT INTO ton_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Pea fononga ʻa Sēkope ki Sukote, pea langa ai hono fale louʻakau ʻo ne ngaohi ai ʻae ngaahi fale louʻakau ki heʻene fanga manu: ko ia ʻoku ui ai ʻae potu ko ia ko Sukote. ");
INSERT INTO ton_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","¶ Pea hoko lelei pe ʻa Sēkope ki he kolo ko Sikemi, ʻaia ʻoku ʻi he fonua ko Kēnani, ʻi heʻene haʻu mei Petanalami; pea naʻa ne fokotuʻu hono fale fehikitaki ʻo ofi ki he kolo. ");
INSERT INTO ton_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Pea ne fakatau ʻae potu ngoue, ʻaia ne ne folahi ai hono fale fehikitaki, mei he nima ʻoe fānau ʻa Hemoa ko e tamai ʻa Sikemi, ʻaki ʻae paʻanga ʻe teau. ");
INSERT INTO ton_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Pea naʻa ne fokotuʻu ʻi ai ʻae ʻesifeilaulau, ʻo ne ui ia ko ʻEle-ilohe-ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Pea ko Taina ko e taʻahine ʻa Lia, ʻaia naʻa ne fanauʻi kia Sēkope, naʻe ʻalu ia ke ʻaʻahi ki he kau fefine ʻoe fonua. ");
INSERT INTO ton_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pea ʻi he mamata kiate ia ʻa Sikemi ko e foha ʻo Hemoa ko e tangata Hevi, ko e ʻeiki ʻoe fonua, naʻa ne puke ia ʻo na mohe, ʻo ne fakahalaʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pea pikitai hono laumālie kia Taina ko e ʻofefine ʻo Sēkope, pea ʻofa ia ki he taʻahine, ʻo ne lea lelei ki he taʻahine. ");
INSERT INTO ton_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Pea lea ʻa Sikemi ki heʻene tamai ko Hemoa, ʻo pehē, “Ke ke maʻu mai ʻae taʻahine ni ke ma mali.” ");
INSERT INTO ton_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Pea fanongo ʻa Sēkope kuo ne fakahalaʻi hono ʻofefine ko Taina; ka naʻe ʻi he ngoue ʻa hono ngaahi foha, mo ʻene fanga manu: pea longo pe ʻa Sēkope kaeʻoua ke nau haʻu. ");
INSERT INTO ton_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","¶ Pea naʻe ʻalu ʻa Hemoa ko e tamai ʻa Sikemi kia Sēkope, ke na alea mo ia. ");
INSERT INTO ton_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Pea ʻi he fanongo ki ai ʻae ngaahi foha ʻo Sēkope, naʻa nau haʻu mei he ngoue; pea mamahi ʻae kau tangata ʻo nau ʻita lahi, koeʻuhi ko ʻene fai meʻa kovi ʻi ʻIsileli, ʻo mohe mo e ʻofefine ʻo Sēkope; ʻae meʻa naʻe ʻikai ngofua ke fai. ");
INSERT INTO ton_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pea naʻe lea ʻa Hemoa ki ai, ʻo pehē, “ʻOku holi ʻae laumālie ʻo hoku foha ko Sikemi ki ho ʻofefine: ʻoku ou kole kiate kimoutolu, foaki mai ia kiate ia, ke na mali. ");
INSERT INTO ton_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Pea mou fai mali mo kimautolu, pea foaki mai homou ngaahi ʻofefine kiate kimautolu, pea mou maʻu homau ngaahi ʻofefine kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pea ke tau nonofo; pea ʻoku ʻi homou ʻao ʻae fonua: mou nofo ki ai, mo fai hoʻomou fakatau, pea mou maʻu ʻi ai ʻae ngaahi ʻapi moʻomoutolu.” ");
INSERT INTO ton_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Pea pehē ʻe Sikemi ki he tamai ʻae fefine mo hono ngaahi tuongaʻane, “ʻOfa ke u lelei ʻi homou ʻao, pea ko ia ʻoku mou tala te u foaki. ");
INSERT INTO ton_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tala mai ʻae totongi lahi, pe ko e foaki, pea te u ʻatu ʻo hangē ko ia te mou tala kiate au, kae kehe ke foaki mai ʻae fefine ke ma mali.” ");
INSERT INTO ton_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pea naʻe lea fakakākā ʻae ngaahi foha ʻo Sēkope kia Sikemi, mo ʻene tamai ko Hemoa, ʻo nau pehē, ko e meʻa ʻi heʻene fakahalaʻi ʻa Taina, ko honau tuofefine: ");
INSERT INTO ton_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Pea naʻa nau pehē kiate kinaua, “ʻOku ʻikai te mau faʻa fai ʻae meʻa ni, ke foaki homau tuofefine ki ha tokotaha ʻoku taʻekamu; he ko e meʻa kovi ia kiate kimautolu. ");
INSERT INTO ton_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ka ʻi he meʻa ni te mau loto kiate kimoutolu: ʻo kapau te mou hoko ʻo hangē ko kimautolu, koeʻuhi ke kamu ʻae tangata kotoa pē ʻoku ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Pea te mau toki foaki homau ngaahi ʻofefine kiate kimoutolu, pea te mau maʻu homou ngaahi ʻofefine kiate kimautolu, pea te tau nonofo, pea te tau hoko ko e kakai pe taha. ");
INSERT INTO ton_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pea kapau ʻe ʻikai te mou tokanga kiate kimautolu ke mou kamu: pea te mau toʻo homau ʻofefine, ka mau ʻalu.” ");
INSERT INTO ton_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Pea naʻe leleiʻia ʻa Hemoa, mo Sikemi ko e foha ʻo Hemoa, ʻi heʻenau lea. ");
INSERT INTO ton_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Pea naʻe ʻikai fakatuai ʻae talavou ke fai ʻae meʻa ko ia, koeʻuhi naʻe lahi ʻene ʻofa ki he ʻofefine ʻo Sēkope; pea naʻe tuʻu ki muʻa ia ʻi he fale kotoa pē ʻo ʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","¶ Pea naʻe ʻalu ʻa Hemoa mo hono foha ko Sikemi ki he matapā ʻo ʻenau kolo, ʻo nau alea mo e kau tangata ʻo ʻenau kolo, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ʻOku nofo fiemālie pe ʻae kau tangata ni mo kitautolu; ko ia tuku ke nau nofo ʻi he fonua mo fai ʻenau fakatau ʻi ai: he vakai, ʻoku lahi ʻae fonua kiate kinautolu; ke tau maʻu honau ngaahi ʻofefine ke mali, pea tau foaki kiate kinautolu hotau ngaahi ʻofefine. ");
INSERT INTO ton_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ka ko e meʻa pe taha ʻe loto ai ʻae kau tangata kiate kitautolu, ke nofo mo kitautolu, ke tau hoko ko e kakai pe taha, ʻo kapau ʻe kamu ʻae tangata kotoa pē ʻoku ʻiate kitautolu, ʻo hangē ʻoku nau kamu. ");
INSERT INTO ton_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","‌ʻIkai ʻe hoko ai ʻenau fanga pulu, mo e nau fanga manu kotoa pē, mo e nau ngaahi meʻa, ko e tau ngaahi meʻa? Kae kehe ke tau loto kiate kinautolu, pea te nau nofo mo kitautolu. ");
INSERT INTO ton_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Pea naʻe tokanga kia Hemoa mo Sikemi ko hono foha, ʻakinautolu kotoa pē naʻe ʻalu kituaʻā ʻi he matapā ʻo ʻena kolo; pea kamu ʻae tangata kotoa pē, ʻio, ʻakinautolu kotoa pē naʻe hū kituaʻā ʻi he matapā ʻo ʻena kolo.” ");
INSERT INTO ton_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","¶ Pea ʻi heʻene hokosia hono ʻaho tolu, kuo nau mamahi, pea naʻe taki taha toʻo ʻae heletā ʻe he ongo foha ʻe toko ua ʻo Sēkope, ko Simione mo Livai, ko e ongo tuongaʻane ʻo Taina, ʻo na hū mālohi ki he kolo, ʻo tāmateʻi ʻae kau tangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Pea naʻa na tāmateʻi ʻa Hemoa mo hono foha ko Sikemi ʻaki ʻae mata ʻoe heletā, pea na toʻo mai ʻa Taina mei he fale ʻo Sikemi, pea nau ō ai. ");
INSERT INTO ton_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Pea naʻe haʻu ai ʻae ngaahi foha ʻo Sēkope ki he kakai mate ʻo nau maumauʻi ʻae kolo, ko e meʻa ʻi heʻenau fakahalaʻi honau tuofefine. ");
INSERT INTO ton_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ne nau ʻave ʻenau fanga sipi mo e nau fanga pulu, mo e nau fanga ʻasi, mo e meʻa kotoa pē ʻi he kolo, mo e meʻa ʻi he ngoue, ");
INSERT INTO ton_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Mo ʻenau koloa kotoa pē, mo nau ʻave fakapōpula ʻenau fānau iiki, mo honau ngaahi uaifi, pea naʻa nau maumauʻi ʻae meʻa kotoa pē ʻi he ngaahi fale. ");
INSERT INTO ton_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Pea pehē ʻe Sēkope kia Simione mo Livai, “Kuo mo fakamamahiʻi au, ke fakanamukūʻi au, ki he kakai ʻoe fonua, ko e kakai Kēnani mo e kakai Pelesi: ʻoku ou tokosiʻi au, pea te nau fakataha kotoa pē, ke tāmateʻi au, pea te u ʻauha, ko au, mo hoku fale.” ");
INSERT INTO ton_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pea naʻa na pehēange kiate ia, “He naʻe lelei ʻa ʻene fai ki homa tuofefine ʻo hangē ko ha muitau?” ");
INSERT INTO ton_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Pea naʻe folofola ʻe he ʻOtua kia Sēkope, “Tuʻu hake ʻo ʻalu ki Peteli, pea nofo ai; pea ke ngaohi ʻi ai ʻae ʻesifeilaulau ki he ʻOtua, ʻaia naʻe hā kiate koe ʻi hoʻo hola mei he ʻao ʻo ho taʻokete ko ʻIsoa.” ");
INSERT INTO ton_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Pea fekau ai ʻe Sēkope ki hono kau nofoʻanga, pea mo kinautolu kotoa pē naʻe ʻiate ia, ʻo pehē; “Tukuange ʻae ngaahi ʻotua kehe ʻoku ʻiate kimoutolu, pea mou maʻa, pea fetongi homou ngaahi kofu. ");
INSERT INTO ton_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Pea ke tau tuʻu hake, ʻo ʻalu ki Peteli: pea te u ngaohi ai ʻae ʻesifeilaulau ki he ʻOtua, ʻaia naʻe tali ʻeku hū, ʻi he ʻaho ʻo ʻeku mamahi, pea naʻe ʻiate au ʻi he hala naʻaku ʻalu ai. ");
INSERT INTO ton_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Pea naʻa nau tuku kia Sēkope honau ngaahi ʻotua kehe kotoa pē naʻe ʻi honau nima, mo honau ngaahi hau, naʻe ʻi honau telinga; pea naʻe fufū ia ʻe Sēkope ʻi he lalo ʻakau ko e oke naʻe ofi ki Sikemi.” ");
INSERT INTO ton_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pea naʻa nau fononga; pea ko e manavahē ki he ʻOtua, naʻe ʻi he ngaahi kolo kotoa pē naʻe tuʻu takatakai ʻiate kinautolu, pea naʻe ʻikai te nau tuli ʻae ngaahi foha ʻo Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","¶ Pea hoko ʻa Sēkope ki Lusa, ʻi he fonua ko Kēnani, ʻaia ko Peteli, ko ia mo e kakai naʻe ʻiate ia. ");
INSERT INTO ton_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Pea naʻe fokotuʻu ʻe ia ʻi ai ʻae ʻesifeilaulau, ʻo ne ui ʻae potu ko ia, ko ʻElepeteli: koeʻuhi naʻe hā ai ʻae ʻOtua kiate ia, ʻi heʻene hola mei he ʻao ʻo hono taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Pea naʻe pekia ai ʻa Tepola ko e tauhi ʻo Lepeka, pea naʻe tanu ia ʻi Peteli, ʻi he lalo oke; pea naʻe fakahingoa ʻae potu ko ʻAlonipakuti. ");
INSERT INTO ton_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","¶ Pea naʻe toe hā ʻae ʻOtua kia Sēkope, ʻi heʻene haʻu mei Petanalami, ʻo ne tāpuaki ia. ");
INSERT INTO ton_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Pea pehē ʻe he ʻOtua kiate ia, “Ko ho hingoa ko Sēkope: ka e ʻikai toe ui ho hingoa ko Sēkope, ka ko ʻIsileli ho hingoa: pea ne ui hono hingoa ko ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Pea pehē ʻe he ʻOtua kiate ia, “Ko e ʻOtua Māfimafi au ke ke monūʻia, ʻo tupu ke tokolahi ko e puleʻanga, mo e ngaahi puleʻanga ʻe tupu ʻiate koe, pea ʻe tupu ʻiate koe ʻae ngaahi tuʻi. ");
INSERT INTO ton_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Pea ko e fonua naʻaku tuku kia ʻEpalahame mo ʻAisake, ʻoku ou foaki ia kiate koe, pea mo ho hako ʻamui ʻiate koe, te u foaki ki ai ʻae fonua.” ");
INSERT INTO ton_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Pea naʻe hāʻele hake ʻae ʻOtua meiate ia, mei he potu naʻa ne folofola ai kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Pea naʻe fokotuʻu ʻe Sēkope ʻae pou ʻi he potu naʻa ne folofola ai kiate ia, ʻio, ʻae pou maka: pea ne lilingi ki ai ʻae feilaulau inu, pea ne lilingi ki ai ʻae lolo. ");
INSERT INTO ton_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Pea naʻe ui ʻe Sēkope ʻae hingoa ʻoe potu ko ia naʻe folofola ai ʻae ʻOtua kiate ia, ko Peteli. ");
INSERT INTO ton_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","¶ Pea naʻa nau fononga mei Peteli pea naʻe toetoe siʻi pe, ke nau hoko ki ʻEfelata, pea naʻe langā ai ʻa Lesieli, pea naʻe faingataʻa. ");
INSERT INTO ton_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Pea ʻi heʻene kei langā, naʻe lea ʻae māʻuli kiate ia, ʻo pehē, “ʻOua te ke manavahē; he te ke maʻu ʻae tama ni foki.” ");
INSERT INTO ton_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pea ʻi he tei ʻalu hono laumālie, (he naʻe pekia ia,) pea ne ui hono hingoa ko Penioni; ka naʻe ui ia ʻe heʻene tamai ko Penisimani. ");
INSERT INTO ton_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Pea naʻe pekia ʻa Lesieli, pea tanu ia ʻi he hala ʻoku tau ki ʻEfelata, ʻaia ko Petelihema. ");
INSERT INTO ton_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Pea naʻe fokotuʻu ʻe Sēkope ʻae pou ki hono tanuʻanga; pea ko e pou ia ʻoe tanuʻanga ʻo Lesieli, ʻo aʻu ki he ʻaho ni. ");
INSERT INTO ton_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","¶ Pea naʻe fai fononga ʻa ʻIsileli, pea folahi hono fale fehikitaki ki kō atu ʻoe fale māʻolunga ko ʻEta. ");
INSERT INTO ton_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pea ʻi he kei nofo ʻa ʻIsileli ʻi he fonua ko ia, naʻe ʻalu ʻa Lupeni ʻo na mohe mo Pila, ko e sinifu ʻo ʻene tamai; pea fanongo ki ai ʻa ʻIsileli. Pea ko e ngaahi foha ʻo Sēkope naʻe toko hongofulu ma toko ua. ");
INSERT INTO ton_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ko e ngaahi tama ʻa Lia: ko Lupeni, ko e ʻuluaki ʻo Sēkope, mo Simione, mo Livai, mo Siuta, mo ʻIsaka, mo Sepuloni. ");
INSERT INTO ton_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ko e ongo tama ʻa Lesieli: ko Siosefa mo Penisimani. ");
INSERT INTO ton_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Pea ko e ongo tama ʻa Pila, ko e kaunanga ʻa Lesieli, ko Tani, mo Nafitali. ");
INSERT INTO ton_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Pea ko e ongo tama ʻa Silipa, ko e kaunanga ʻa Lia; ko Kata mo ʻAseli; ko e ngaahi foha eni ʻo Sēkope, naʻe fanauʻi kiate ia ʻi Petanalami. ");
INSERT INTO ton_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","¶ Pea naʻe haʻu ʻa Sēkope ki heʻene tamai ko ʻAisake ʻi Mamili, ki he kolo ko ʻAapa, ʻaia ko Hepeloni, ko e potu naʻe ʻāunofo ai ʻa ʻEpalahame mo ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Pea ko e ngaahi ʻaho ʻo ʻAisake, ko e taʻu ʻe teau, mo e taʻu ʻe valungofulu. ");
INSERT INTO ton_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Pea tukuange ʻe ʻAisake ʻa hono laumālie, pea pekia ia, pea fakataha ia ki hono kakai, kuo motuʻa, naʻe aʻu hono ngaahi ʻaho; pea naʻe tanu ia ʻe hono ongo foha, ko ʻIsoa, mo Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Pea ko e ngaahi toʻutangata eni ʻo ʻIsoa, ʻaia ko ʻItomi. ");
INSERT INTO ton_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Naʻe maʻu ʻe ʻIsoa hono ngaahi uaifi mei he fānau fefine ʻo Kēnani; ko ʻAta ko e ʻofefine ʻo ʻEloni ko e tangata Heti, mo ʻAholipama ko e taʻahine ʻo ʻAna, ko e ʻofefine ʻo Sipione, ko e tangata Hevi. ");
INSERT INTO ton_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Mo Pasimati ko e ʻofefine ʻo ʻIsimeʻeli, ko e tuofefine ʻo Nepeoti. ");
INSERT INTO ton_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Pea naʻe fānau ʻe ʻAta kia ʻIsoa, ʻa ʻIlifasi; pea fanauʻi ʻe Pasimati ʻa Leueli. ");
INSERT INTO ton_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Pea fanauʻi ʻe ʻAholipama, ʻa Seusi, mo Salami, mo Kola; ko e ngaahi foha eni ʻo ʻIsoa, naʻe fanauʻi kiate ia ʻi he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Pea naʻe ʻave ʻe ʻIsoa hono ngaahi uaifi, mo hono ngaahi foha, mo hono ngaahi ʻofefine, mo e kakai kotoa pē ʻo hono fale, mo ʻene fanga pulu, mo ʻene fanga manu, mo e meʻa kotoa pē ʻaia naʻa ne maʻu ʻi he fonua ko Kēnani; pea ʻalu mamaʻo ia ki he tukuʻuta, mei he ʻao ʻo hono tehina ko Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","He naʻe lahi ʻena koloa, ko ia naʻe ʻikai ai te na faʻa nofo fakataha; pea ko e fonua naʻa na nofo ʻāunofo ai, naʻe ʻikai ʻataʻatā ia kiate kinaua, koeʻuhi naʻe lahi ʻena fanga manu. ");
INSERT INTO ton_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Pea pehē, naʻe nofo ʻa ʻIsoa ʻi he moʻunga ko Seia, pea ko ʻIsoa ko ʻItomi ia. ");
INSERT INTO ton_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","¶ Pea ko e ngaahi toʻutangata eni ʻo ʻIsoa, ko e tamai ʻae kakai ʻItomi, ʻi he moʻunga ko Seia. ");
INSERT INTO ton_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ko e hingoa eni ʻoe ngaahi foha ʻo ʻIsoa: ko ʻIlifasi ko e tama ʻa ʻAta ko e uaifi ʻo ʻIsoa; ko Leueli ko e tama ʻa Pasimati, ko e uaifi ʻo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Pea ko e ngaahi foha ʻo ʻIlifasi, ko Temani, mo ʻOmaa, mo Sefo, mo Katami, mo Kinasi. ");
INSERT INTO ton_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Pea ko Timina, ko e sinifu ia kia ʻIlifasi, ko e foha ʻo ʻIsoa, pea ne fāʻele kia ʻIlifasi, ʻa ʻAmaleki; ko e ngaahi tama ia ʻa ʻAta, ko e uaifi ʻo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Pea ko e ngaahi foha eni ʻo Leueli ko Nehate, mo Sela, mo Sama, mo Misa: ko e ngaahi tama ia ʻa Pasimati, ko e uaifi ʻo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","¶ Pea ko e ngaahi tama eni ʻa ʻAholipama, ko e uaifi ʻo ʻIsoa, ko e taʻahine ʻo ʻAna, ko e ʻofefine ʻo Sipione; naʻa ne fānau kia ʻIsoa ʻa Seusi, mo Salami, mo Kola. ");
INSERT INTO ton_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","¶ Pea ko e ngaahi ʻeiki eni ʻi he ngaahi foha ʻo ʻIsoa; ko e ngaahi foha ʻo ʻIlifasi, ko e ʻuluaki foha ʻo ʻIsoa; ko e ʻeiki ko Temani, ko e ʻeiki ko ʻOmaa, ko e ʻeiki ko Sefo, ko e ʻeiki ko Kinasi, ");
INSERT INTO ton_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Ko e ʻeiki ko Kola, mo e ʻeiki ko Katami, mo e ʻeiki ko ʻAmaleki; ko e ngaahi ʻeiki ia naʻe tupu ia ʻIlifasi ʻi he fonua ko ʻItomi; ko e ngaahi tama eni ʻa ʻAta. ");
INSERT INTO ton_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","¶ Pea ko e ngaahi foha eni ʻo Leueli ko e foha ʻo ʻIsoa; ko e ʻeiki ko Nehate, mo e ʻeiki ko Sela, mo e ʻeiki ko Sama, mo e ʻeiki ko Misa: ko e ngaahi ʻeiki eni naʻe tupu ia Leueli, ʻi he fonua ko ʻItomi; ko e ngaahi tama eni ʻa Pasimati ko e uaifi ʻo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","¶ Pea ko e ngaahi tama eni ʻa ʻAholipama ko e uaifi ʻo ʻIsoa: ko e ʻeiki ko Seusi, mo e ʻeiki ko Salami, mo e ʻeiki ko Kola: ko e ngaahi ʻeiki ia naʻe tupu ia ʻAholipama, ko e taʻahine ʻo ʻAna, ko e uaifi ʻo ʻIsoa. ");
INSERT INTO ton_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ko e ngaahi foha eni ʻo ʻIsoa ʻaia ko ʻItomi, pea ko honau ngaahi ʻeiki ia. ");
INSERT INTO ton_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","¶ Ko e ngaahi foha eni ʻo Seia, ko e tangata Hoa, ʻaia naʻe maʻu ʻae fonua ko Lotani mo Sopale, mo Sipione, mo ʻAna, ");
INSERT INTO ton_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Mo Tisoni, mo ʻEseli, mo Tisani ko e ngaahi ʻeiki ʻoe kakai Hoa, ko e fānau ʻa Seia, ʻi he fonua ko ʻItomi. ");
INSERT INTO ton_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Pea ko e fānau ʻa Lotani ko Holi, mo Hemami; pea ko e tuofefine ʻo Lotani ko Timina. ");
INSERT INTO ton_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Pea ko e fānau ʻa Sopale eni ko ʻAlivani, mo Maneate, mo ʻEpale, mo Sifo, mo ʻOnama. ");
INSERT INTO ton_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Pea ko e fānau eni ʻa Sipione ko ʻEiaa mo ʻAna; ko e ʻAna ia ʻaia naʻa ne ʻiloʻi ʻae fanga miuli ʻi he toafa, ʻi heʻene tauhi ʻae fanga ʻasi ʻa ʻene tamai ko Sipione. ");
INSERT INTO ton_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Pea ko e fānau ʻa ʻAna ʻa eni; ko Tisoni mo ʻAholipama, ko e taʻahine ʻa ʻAna. ");
INSERT INTO ton_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Pea ko e fānau eni ʻa Tisoni; ko Hemitani, mo ʻEsipani, mo ʻItilani, mo Kilani. ");
INSERT INTO ton_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Pea ko e fānau eni ʻa ʻEseli, ko Pilani, mo Sefani, mo ʻEkani. ");
INSERT INTO ton_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Pea ko e fānau eni ʻa Tisani; ko ʻUsa mo ʻAlani. ");
INSERT INTO ton_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ko eni ʻae ngaahi ʻeiki naʻe tupu ʻi he kau Hoa; ko e ʻeiki ko Lotani, mo e ʻeiki ko Sopale, mo e ʻeiki ko Sipione, mo e ʻeiki ko ʻAna, ");
INSERT INTO ton_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Ko e ʻeiki ko Tisoni, mo e ʻeiki ko ʻEseli, mo e ʻeiki ko Tisani; ko e ngaahi ʻeiki eni naʻe tupu ia Holi, ʻi he ngaahi ʻeiki ʻi he fonua ko Seia. ");
INSERT INTO ton_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","¶ Pea ko e ngaahi tuʻi eni naʻe pule ʻi he fonua ko ʻItomi, ʻi he teʻeki pule ha tuʻi ki he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ko Pela ko e foha ʻo Peoli, naʻe pule ia ki ʻItomi; pea ko e hingoa ʻo hono kolo ko Tinapa. ");
INSERT INTO ton_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Pea pekia ʻa Pela, pea pule ʻi hono puleʻanga ʻa Sopapa ko e foha ʻo Sela ʻo Posila. ");
INSERT INTO ton_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Pea pekia ʻa Sopapa, pea pule ʻi hono puleʻanga ʻa Husami, mei he fonua ko Temani. ");
INSERT INTO ton_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Pea pekia ʻa Husami, pea ko Hetati ko e foha ʻo Pitati, ʻaia naʻa ne taaʻi ʻa Mitiane, ʻi he ngoue ʻo Moape, naʻe pule ia ʻi hono puleʻanga; pea ko e hingoa ʻo hono kolo ko ʻEviti. ");
INSERT INTO ton_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Pea pekia ʻa Hetati, pea ko Samila mei Masileka, naʻa ne pule ʻi hono puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Pea pekia ʻa Samila, pea ko Saula mei Leopote ʻo ofi ki he vaitafe, naʻe pule ia ʻi hono puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Pea pekia ʻa Saula, pea ko Pealihenani, ko e foha ʻo ʻAkepoa, naʻe pule ʻi hono puleʻanga. ");
INSERT INTO ton_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Pea pekia ʻa Pealihenani ko e foha ʻo ʻAkepoa; pea pule ʻa Hetali ʻi hono puleʻanga pea ko e hingoa ʻo hono kolo ko Pau pea ko e hingoa ʻo hono uaifi ko Mehetepeli, ko e ʻofefine ʻo Matileti, ko e ʻofefine ʻo Mesaʻapi. ");
INSERT INTO ton_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","¶ Pea ko e ngaahi hingoa eni ʻoe ngaahi ʻeiki naʻe tupu ia ʻIsoa, ʻo hangē ko honau ngaahi faʻahinga, ʻi honau ngaahi potu, ʻi honau ngaahi hingoa; ko e ʻeiki ko Timina, mo e ʻeiki ko ʻAlivani, mo e ʻeiki ko Sesete, ");
INSERT INTO ton_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ko e ʻeiki ko ʻAholipama, mo e ʻeiki ko ʻe ia, mo e ʻeiki ko Pinoni, ");
INSERT INTO ton_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Mo e ʻeiki ko Kinasi, mo e ʻeiki ko Temani, mo e ʻeiki ko Mipisali, ");
INSERT INTO ton_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mo e ʻeiki ko Makiteli, mo e ʻeiki ko ʻIlami; ko e ngaahi ʻeiki eni ʻo ʻItomi, ʻo hangē ko honau nofoʻanga, ʻi honau ngaahi fonua: pea ko ʻIsoa, ko e tamai ia ʻae kakai ʻItomi. ");
INSERT INTO ton_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Pea naʻe nofo ʻa Sēkope ʻi he fonua naʻe ʻāunofo ki ai ʻene tamai, ʻio, ʻi he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ko e hako eni ʻo Sēkope naʻe hongofulu ma fitu ʻae taʻu ʻo Siosefa, pea naʻe tauhi ʻe ia ʻae fanga manu, ʻo fakataha mo hono ngaahi taʻokete; pea naʻe nofo ʻae tama mo e ongo tama ʻa Pila, pea mo e fānau ʻa Silipa, ko e ongo sinifu ʻo ʻene tamai: pea naʻe ʻomi ʻe Siosefa ki heʻene tamai ʻenau ongoongo kovi. ");
INSERT INTO ton_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Pea naʻe ʻofa lahi hake ʻa ʻIsileli kia Siosefa ʻi heʻene fānau kotoa pē, koeʻuhi ko hono foha ia ʻi heʻene motuʻa; pea ne ngaohi maʻana ʻae kofutuʻa pulepule. ");
INSERT INTO ton_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pea kuo mamata hono ngaahi taʻokete, ʻoku ʻofa lahi hake ʻenau tamai kiate ia, ʻi hono taʻokete kotoa pē, naʻa nau fehiʻa ai kiate ia, pea naʻe ʻikai te nau lea lelei kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Pea misi ʻe Siosefa ʻae misi, pea ne tala ia ki hono ngaahi taʻokete; pea naʻe ʻāsili ai ʻenau fehiʻa kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Pea pehē ʻe ia kiate kinautolu, “ʻOku ou kole ke mou fanongo ki he misi ni, kuo u misi ʻaki; ");
INSERT INTO ton_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","He naʻa tau nonoʻo ʻae ngaahi u koane ʻi he ngoue, pea vakai, naʻe tuʻu hake ʻeku u koane, ʻo tuʻu totonu; pea vakai, ko hoʻomou ngaahi u koane naʻa nau tutuʻu hake ʻo takatakai ia, ʻo nau punou ki heʻeku u koane.” ");
INSERT INTO ton_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Pea pehē ʻe hono ngaahi taʻokete kiate ia, “He ko e moʻoni te ke pule kiate kimautolu? Pea te ke mālohi kiate kimautolu?” Pea ʻāsili ai ʻenau fehiʻa kiate ia ʻi heʻene misi, mo ʻene ngaahi lea. ");
INSERT INTO ton_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","¶ Pea misi ia ʻae misi ʻe taha, pea ne tala ia ki hono ngaahi taʻokete, ʻo pehē, “Vakai, kuo u misi ʻae misi ʻe taha, pea vakai, ko e laʻā mo e māhina, mo e fetuʻu ʻe hongofulu ma taha, naʻa nau punou kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Pea ne fakahā ki heʻene tamai, mo hono ngaahi taʻokete: pea valoki ia ʻe heʻene tamai, ʻo ne pehē kiate ia, “Ko e hā ʻae misi ni kuo ke misi ʻaki? Ko e moʻoni ʻe pehē au mo hoʻo faʻē, mo ho ngaahi taʻokete, ke mau punou ʻakimautolu kiate koe, ki he kelekele?” ");
INSERT INTO ton_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Pea naʻe meheka ʻa hono ngaahi taʻokete kiate ia; ka naʻe tokanga ʻene tamai ki he lea. ");
INSERT INTO ton_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","¶ Pea naʻe ʻalu hono ngaahi taʻokete ki Sikemi, ke fafanga ʻae fanga manu ʻa ʻenau tamai. ");
INSERT INTO ton_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Pea pehē ʻe ʻIsileli kia Siosefa, “ʻIkai ʻoku fafanga ʻe ho ngaahi taʻokete ʻae fanga manu ʻi Sikemi?” Haʻu, pea te u fekau koe kiate kinautolu. Pea pehē ʻe ia, “Ko au eni.” ");
INSERT INTO ton_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Pea pehē ʻe ia kiate ia, “Ke ke ʻalu, ʻo vakai pe ʻoku lelei ʻa ho ngaahi taʻokete, pea lelei mo e fanga manu; pea ke haʻu ʻo tala mai.” Pea ne fekau ia mei he teleʻa ʻo Hepeloni ʻo ne hoko ki Sikemi. ");
INSERT INTO ton_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","¶ Pea naʻe ʻilo ia ʻe he tangata ʻe taha, pea vakai, naʻe ʻalu he pe ia ʻi he fonua; pea fehuʻi ʻae tangata kiate ia, ʻo pehē, “Ko e hā ʻoku ke kumi?” ");
INSERT INTO ton_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Pea ne pehē, “ʻOku ou kumi hoku ngaahi taʻokete; ʻoku ou kole kiate koe, fakahā kiate au ʻae potu ʻoku nau fafanga ai ʻae fanga manu.” ");
INSERT INTO ton_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Pea pehēange ʻe he tangata, “Kuo nau ō, he naʻaku fanongo ki heʻenau pehē, Tau ō ki Totani.” Pea naʻe muimui ʻa Siosefa ki hono ngaahi taʻokete, pea ne ʻilo ʻakinautolu ʻi Totani. ");
INSERT INTO ton_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Pea kuo nau mamata kiate ia, ʻi heʻene kei mamaʻo, ʻi he teʻeki ke ne ofi kiate kinautolu, naʻa nau alea fakataha, ke tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Pea naʻa nau fealēleaʻaki, ʻo pehē, “Vakai, ʻoku haʻu ʻae faʻa misi ni.” ");
INSERT INTO ton_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Pea ko ia ke tau tāmateʻi ia pea lī ia ki ha luo, pea te tau pehē, kuo kai ia ʻe ha manu fekai; pea te tau vakai, pe ʻe hoko ʻo fēfē ʻene ngaahi misi. ");
INSERT INTO ton_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pea fanongo ki ai ʻa Lupeni, ʻo ne fakahaofi ia mei honau nima; ʻo ne pehē, “ʻOua naʻa tau tāmateʻi ia.” ");
INSERT INTO ton_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Pea pehē ʻe Lupeni kiate kinautolu, “ʻOua naʻa lingi toto, kae lī ia ki he luo ni, ʻoku ʻi he toafa, pea ʻoua naʻa ala ha nima kiate ia;” naʻa ne pehē koeʻuhi ke ne toʻo ia mei honau nima, ke toe ʻatu ia ki heʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","¶ Pea kuo hoko atu ʻa Siosefa ki hono ngaahi taʻokete, pea pehē, naʻa nau toʻo ʻae kofutuʻa ʻo Siosefa meiate ia, ʻae kofutuʻa pulepule naʻe ʻiate ia; ");
INSERT INTO ton_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Pea nau ʻave ia ʻo lī ki he luo; pea naʻe maha pe ʻae luo, naʻe ʻikai ʻi ai ha vai. ");
INSERT INTO ton_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Pea nau nofo ki lalo ke kai mā: pea ʻi he hanga hake honau mata ʻo sio, pea vakai, naʻe haʻu ʻae fononga ʻoe kakai ʻIsimeʻeli, naʻe haʻu mei Kiliate, mo e nau fanga kāmeli, naʻe fakaheka ki ai ʻae ngaahi ʻakau namu lelei, mo e pulu mo e pulu nanamu, ko e nau fetuku ia ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Pea lea ʻa Siuta, ʻo pehē ki hono ngaahi taʻokete, “Ko e hā hono ʻaonga, ʻo ʻetau tāmateʻi hotau tehina, pea fufū hono toto? ");
INSERT INTO ton_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Haʻu, ke tau fakatau ia ki he kau ʻIsimeʻeli, kaeʻoua naʻa ʻiate ia hotau nima: he ko hotau tehina ia mo hotau kakano.” Pea loto ki ai ʻa hono ngaahi taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Pea ʻalu ʻo ofi ki ai ʻae kakai Mitiani ko e kau fakatau: pea naʻa nau toho hake ʻa Siosefa mei he luo, pea nau fakatau ʻa Siosefa ki he kau ʻIsimeʻeli, ʻaki ʻae konga siliva ʻe uofulu; pea naʻa nau ʻave ʻa Siosefa ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","¶ Pea toe ʻalu ʻa Lupeni ki he luo pea vakai, naʻe ʻikai ʻi he luo ʻa Siosefa pea haehae ʻe ia hono ngaahi kofu. ");
INSERT INTO ton_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Pea toe haʻu ia ki hono ngaahi tokoua, ʻo ne pehē, “Kuo ʻikai ʻae tama; pea ko au, te u ʻalu ki fē?” ");
INSERT INTO ton_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Pea naʻa nau toʻo ʻae kofutuʻa ʻo Siosefa, ʻo nau tāmateʻi ʻae ʻuhikiʻi kosi, ʻo nau unu ʻae kofutuʻa ʻi he toto: ");
INSERT INTO ton_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Pea nau fekau ke ʻave ʻae kofutuʻa pulepule ki heʻenau tamai; ʻo nau pehē, “Kuo mau ʻilo ʻae meʻa ni; pea ke vakai, pe ko e kofutuʻa ʻo ho foha pe ʻikai.” ");
INSERT INTO ton_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Pea ne ʻilo ia, ʻo ne pehē, “Ko e kofutuʻa ia ʻo hoku foha; kuo kai ia ʻe he manu fekai; kuo haehae nai, ʻo fakaikiiki ʻa Siosefa.” ");
INSERT INTO ton_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Pea haehae ʻe Sēkope hono ngaahi kofu, pea ne ai ʻae tauangaʻa, pea ne tēngihia hono foha ʻo ʻaho lahi. ");
INSERT INTO ton_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Pea tuʻu hake hono ngaahi foha mo hono ngaahi ʻofefine ke nau fakafiemālieʻi ia; ka naʻe ʻikai te ne tali ʻae fakafiemālie; pea ne pehē, “He te u ʻalu hifo tangi pe ki he faʻitoka ki hoku foha.” Naʻe pehē ʻae tangi ʻa ʻene tamai koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Pea naʻe fakatau ia ʻe he kakai Mitiani ki ʻIsipite, kia Potifa, ko e matāpule ʻa Felo, ko e pule ʻoe kau leʻo. ");
INSERT INTO ton_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Pea ʻi he ngaahi ʻaho ko ia, naʻe hoko ʻo pehē, naʻe ʻalu ʻa Siuta mei hono ngaahi tokoua, pea afe ia ki ha taha ʻi he kakai ʻAtulama, ko ʻIla hono hingoa. ");
INSERT INTO ton_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Pea mamata ai ʻa Siuta ki he ʻofefine ʻoe Kēnani ʻe tokotaha, ko Suaa hono hingoa: pea ne maʻu ia, pea ʻalu kiate ia ʻo na mohe. ");
INSERT INTO ton_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Pea feitama ia, mo fāʻeleʻi ʻae tama pea ne ui hono hingoa ho ʻEa. ");
INSERT INTO ton_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Pea toe feitama ia, pea fāʻeleʻi ʻae tama; pea ne ui hono hingoa ko ʻOnani ");
INSERT INTO ton_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Pea toe feitama foki ia; pea fāʻeleʻi ʻae tama; pea ne ui hono hingoa ko Sila pea naʻe ʻi Kesipi ia ʻi heʻene fanauʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Pea fili ʻe Siuta ʻae uaifi kia ʻEa, ko hono ʻuluaki, pea ko Tema hono hingoa. ");
INSERT INTO ton_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pea naʻe anga kovi ʻa ʻEa, ko e ʻuluaki foha ʻo Siuta, ʻi he ʻao ʻo Sihova; pea naʻe tāmateʻi ia ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Pea pehē ʻe Siuta kia ʻOnani, “ʻAlu ko e ki he uaifi ʻo ho taʻokete, pea ke mali mo ia, mo ke fakatupu ai ʻae hako ki ho taʻokete.” ");
INSERT INTO ton_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pea naʻe ʻilo ʻe ʻOnani ʻe ʻikai ʻiate ia ʻae hako; pea ʻi heʻene ʻalu ki he uaifi ʻo hono taʻokete, naʻa ne huaʻi ia ki he kelekele, telia naʻa foaki ʻe ia ʻae hako ki hono taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Pea naʻe kovi kia Sihova ʻae meʻa naʻa ne fai: ko ia, naʻa ne tāmateʻi mo ia foki. ");
INSERT INTO ton_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Pea fekau ʻe Siuta kia Tema ko hono ʻofefine ʻi he fono ʻo pehē, “Ke ke nofo ʻatā pe koe, ʻi he fale ʻo hoʻo tamai, ke ʻoua ke tupu hoku foha ko Sila;” he naʻe pehē ʻe ia, “Telia naʻa mate foki ia, ʻo hangē ko hono ongo taʻokete.” Pea ʻalu ʻa Tema ʻo nofo ʻi he fale ʻo ʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","¶ Pea fuoloa ai, pea pekia ʻae taʻahine ʻa Suaa ko e uaifi ʻo Siuta: pea kuo fiemālie ʻa Siuta, pea ʻalu ia ki heʻene kau tangata kosi sipi ki Timinate, ʻaia mo hono kāinga ko ʻIla, ko e ʻAtulama. ");
INSERT INTO ton_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Pea naʻe fakahā kia Tema, ʻo pehē, Vakai, ʻoku ʻalu ʻa hoʻo tamai ʻi he fono, ki Timinate ke kosi ʻene fanga sipi. ");
INSERT INTO ton_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Pea ne tuku ʻe ia hono ngaahi kofu putu, pea pūlou ʻaki ʻe ia ʻae pūlou, ʻo ne tākai ʻaki ʻae kofu, pea nofo ia ʻi he potu ʻataʻatā naʻe ʻi he veʻe hala ki Timinate; he naʻe vakai ia, kuo tupu ʻa Sila, ka ʻoku teʻeki ai ʻatu ia kiate ia, ke na mali. ");
INSERT INTO ton_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Pea kuo mamata ʻa Siuta, kiate ia, naʻa ne mahalo ko e fefine angahala ia, he koeʻuhi kuo pūlou hono mata. ");
INSERT INTO ton_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Pea afe ia kiate ia ʻi he hala, ʻo ne pehē, “Ko eni, ʻoku ou kole kiate koe, tuku ke u ʻalu atu kiate koe;” (he naʻe ʻikai te ne ʻilo ko hono ʻofefine ia ʻi he fono). Pea pehēange ʻe ia, “Ko e hā te ke tuku mai kiate au, koeʻuhi ke ke haʻu kiate au?” ");
INSERT INTO ton_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Pea pehē ia, “Te u fekau ke ʻomi ha ʻuhiki mei he fanga manu,” pea pehē ʻe ia, “Pea te ke tuku mai ha fakamoʻoni, kaeʻoua ke ke ʻomi ia?” ");
INSERT INTO ton_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Pea pehē ʻe ia, “Ko e hā te u tuku kiate koe?” Pea talaange ʻe ia, “Ko ho mama, mo ho lelu, pea mo ho tokotoko ʻoku ʻi ho nima.” Pea ne ʻatu ia kiate ia, pea ʻalu atu ia kiate ia, pea feitama ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Pea tuʻu hake ia ʻo ʻalu mei ai, pea ne tuku ʻene pūlou meiate ia, ʻo toe ai hono ngaahi kofu putu. ");
INSERT INTO ton_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Pea fekau ʻe Siuta ke ʻave ʻae ʻuhikiʻi kosi ʻi he nima ʻa hono kāinga ko e ʻAtulama, koeʻuhi ke ne maʻu ʻae fakamoʻoni mei he nima ʻoe fefine; ka naʻe ʻikai te ne faʻa ʻilo ia. ");
INSERT INTO ton_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Pea fehuʻi ia ki he kau tangata ʻoe potu ko ia, ʻo pehē, “Ko e fē ʻae fefine angahala naʻe ʻi he potu hala ni?” Pea nau pehē, naʻe ʻikai ha fefine angahala ʻi he potu ni. ");
INSERT INTO ton_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Pea toe ʻalu ia kia Siuta, ʻo ne pehē, “ʻOku ʻikai te u ʻilo ia; pea ʻoku pehē foki ʻe he kau tangata ʻoe potu, naʻe ʻikai ha fefine angahala ʻi he potu ko ia.” ");
INSERT INTO ton_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Pea pehē ʻe Siuta, “Tuku ke ne maʻu, ia maʻana, telia naʻa tau mā ai; vakai, naʻaku fekau ke ʻave ʻae ʻuhiki manu ni, pea ʻoku ʻikai te ke ʻilo ia.” ");
INSERT INTO ton_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","¶ Pea hili ʻae māhina ʻe tolu nai, naʻe fakahā kia Siuta, ʻo pehē, “Kuo fai angahala ʻe Tema, ko ho ʻofefine ʻi he fono; pea vakai, ʻoku feitama foki ia ʻi he feʻauaki.” Pea pehē ʻe Siuta; “Taki mai ia, ke tutu ia.” ");
INSERT INTO ton_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pea kuo nau taki mai ia, pea fekau ia ki heʻene tamai ʻi he fono, ʻo pehē, “Kuo u feitama ki he tangata ʻoku ʻaʻana ʻae meʻa ni: pea ne pehē, Ke ke vakai, pe ʻoku ʻa hai ʻae maama ni mo e lelu, mo e tokotoko ni?” ");
INSERT INTO ton_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Pea fakamoʻoni ʻe Siuta, ʻo ne pehē, “ʻOku tonuhia lahi ia ʻia au: koeʻuhi naʻe ʻikai te u foaki ia ki hoku foha ko Sila.” Pea naʻe ʻikai te ne taʻeʻiloʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","¶ Pea naʻe hoko, ʻo pehē, ʻi heʻene langā, pea vakai, naʻe ai ʻae māhanga ʻi hono manāva. ");
INSERT INTO ton_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Pea ʻi heʻene langā naʻe tuku kituʻa ʻe he tokotaha hono nima, pea nonoʻo ki ai ʻe he māʻuli ʻae filo kulokula, ʻo ne pehē, naʻe fuofua haʻu eni. ");
INSERT INTO ton_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pea ʻi heʻene toe toʻo atu hono nima, pea vakai, naʻe haʻu hono tokoua; pea pehē ʻe he māʻuli, “Naʻe fēfeeʻi hao ʻoho mai koe ke ʻiate koe ʻae motuhi ni, ko ia naʻa ne ui hono hingoa ko Felesi.” ");
INSERT INTO ton_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Pea toki haʻu hono tokoua, ʻaia naʻe ʻi hono nima ʻae filo kulokula, pea ne ui hono hingoa ko Selaa. ");
INSERT INTO ton_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Pea naʻe ʻave ʻa Siosefa ki ʻIsipite; pea ko Potifa ko e matāpule ʻa Felo, ko e pule ʻoe kau leʻo, ko e tangata ʻIsipite, naʻa ne fakatau ia ʻi he nima ʻoe kau ʻIsimeʻeli, ʻakinautolu naʻa nau ʻomi ia ki ai. ");
INSERT INTO ton_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Pea naʻe ia Siosefa ʻa Sihova, pea ko e tangata monūʻia ia, pea naʻa ne ʻi he fale ʻo ʻene ʻeiki, ko e tangata ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Pea mamata ʻene ʻeiki ki he ʻiate ia ʻa Sihova, pea mo e fakamonūʻia ʻe Sihova ʻi hono nima ʻae meʻa kotoa pē naʻa ne fai. ");
INSERT INTO ton_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Pea naʻe lelei ʻa Siosefa ʻi hono ʻao, ʻo ne ngāue kiate ia, pea ne fakanofo ia ke leʻohi hono fale, pea naʻa ne tuku ki hono nima ʻa ʻene meʻa kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Pea talu ʻae fakanofo ia ke leʻohi hono fale, pea mo ʻene meʻa fulipē, naʻe tāpuaki ʻe Sihova ʻae fale ʻoe tangata ʻIsipite, koeʻuhi ko Siosefa: pea ko e tāpuaki ʻa Sihova naʻe ʻi heʻene meʻa kotoa pē, ʻi he fale, pea ʻi he ngoue. ");
INSERT INTO ton_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Pea naʻa ne tuku ʻene meʻa kotoa pē ki he nima ʻo Siosefa; pea naʻe ʻikai te ne tokangaʻi ʻe ia haʻane meʻa, ka ko e mā pe naʻa ne kai. Pea ko e tangata sino lelei ʻa Siosefa mo toulekeleka. ");
INSERT INTO ton_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","¶ Pea hili ʻae ngaahi meʻa ni, naʻe fakasiosio ʻae uaifi ʻoe ʻeiki ʻa Siosefa kiate ia; pea ne pehē, Haʻu ke ta mohe. ");
INSERT INTO ton_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ka naʻe ʻikai loto ia ki ai, ʻo ne pehē ki he uaifi ʻo hono ʻeiki, “Vakai, ʻoku ʻikai ʻiloʻi ʻe heʻeku ʻeiki ʻae ngaahi meʻa ʻoku ʻoʻona ʻi he fale, pea kuo ne tuku ia kotoa pē ki hoku nima: ");
INSERT INTO ton_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","‌ʻoku ʻikai ha tokotaha ʻoku lahi hake ʻiate au ʻi he fale ni; pea naʻe ʻikai te ne taʻofi au mei ha meʻa ʻe taha, ka ko Koe pe, koeʻuhi ko hono uaifi koe: pea ʻe fēfē ʻeku fai ʻae hala lahi ni, ke u halaia ai ki he ʻOtua?” ");
INSERT INTO ton_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pea ʻi heʻene lea pe ʻi he ʻaho kotoa pē kia Siosefa, naʻe ʻikai te ne tokanga kiate ia, ke na mohe, pe ke ofi kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pea ʻi he ngaahi ʻaho ko ia, naʻe pehē, naʻe hū ʻa Siosefa ki fale ke fai ʻene ngāue; pea naʻe ʻikai ha tangata ʻoe kakai ʻoe fale ʻi ai. ");
INSERT INTO ton_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Pea naʻa ne puke ki hono kofu, ʻo ne pehē, “Haʻu ke ta mohe;” ka naʻe siʻaki ʻe Siosefa hono kofu ʻi hono nima, ka ka hola ia ʻo hao kituʻa. ");
INSERT INTO ton_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Pea naʻe hoko ʻo pehē, ʻi heʻene mamata kuo tuku hono kofu ki hono nima, pea kuo hola ia kituʻa, ");
INSERT INTO ton_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Naʻa ne ui ki he kau tangata ʻo hono fale, ʻo ne pehē kiate kinautolu, “Vakai, kuo ne ʻomi ʻae Hepelū ni ke pauʻusiʻi mai kiate kitautolu: naʻe haʻu ia kiate au ke ma mohe mo ia, pea u kalanga ʻi he leʻo lahi:” ");
INSERT INTO ton_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Pea kuo fanongo ia kuo u hiki hoku leʻo ʻo kalanga, ʻiloange, naʻa ne siʻaki hono kofu kiate au, ka ka hola, pea mole kituaʻā. ");
INSERT INTO ton_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Pea naʻa ne tuku maʻu hono kofu, kaeʻoua ke haʻu ʻene ʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Pea naʻa ne lea kiate ia ʻi he lea ni, ʻo pehē, “Ko e tamaioʻeiki Hepelū naʻa ke ʻomi kiate kitautolu, naʻe haʻu kiate au ke pauʻu mai kiate au. ");
INSERT INTO ton_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pea ʻi heʻeku hiki hake hoku leʻo ʻo kalanga, ʻiloange, naʻa ne siʻaki hono kofu kiate au, pea hola kituaʻā.” ");
INSERT INTO ton_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Pea kuo fanongo ʻa ʻene ʻeiki ki he ngaahi lea ʻa hono uaifi, ʻaia naʻa ne lea ʻaki kiate ia, ʻo ne pehē, naʻe fai pehē ʻa hoʻo tamaioʻeiki kiate au; naʻe tupu ai ʻene ʻita lahi. ");
INSERT INTO ton_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Pea naʻe ʻave ʻa Siosefa ʻe heʻene ʻeiki, ki he fale fakapōpula, ki he potu naʻe haʻi ai ʻae kau pōpula ʻae tuʻi: pea naʻe nofo ai ia ʻi he fale fakapōpula. ");
INSERT INTO ton_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","¶ Ka naʻe ia Siosefa ʻa Sihova, ʻo ne ʻaloʻofa kiate ia, mo ne fakaʻofeina ia ʻi he ʻao ʻoe tauhi fale fakapōpula. ");
INSERT INTO ton_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Pea naʻe tuku ʻe he tauhi fale fakapōpula ki he nima ʻo Siosefa ʻae kau pōpula kotoa pē naʻe ʻi he fale fakapōpula; pea ko e meʻa kotoa pē naʻa nau fai, naʻe fai maʻana. ");
INSERT INTO ton_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Naʻe ʻikai vakai ʻe he tauhi fale fakapōpula ki ha meʻa ʻe taha naʻe ʻi hono nima; koeʻuhi naʻe ʻiate ia ʻa Sihova, pea ko ia naʻa ne fai, naʻe fakamonūʻia ia ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Pea hili ʻae ngaahi meʻa ni, naʻe hoko ʻo pehē, ko e tauhi lahi, mo e tangata taʻo mā ʻae tuʻi ʻo ʻIsipite, naʻa na fakaʻitaʻi hona ʻeiki ko e tuʻi ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pea tuputāmaki ʻa Felo ki heʻene ongo matāpule, ʻio, ki he matāpule ʻoe kau tauhi, mo e matāpule ʻoe kau taʻo mā. ");
INSERT INTO ton_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Pea ne tuku ʻakinaua ke pōpula ʻi he fale ʻoe ʻeiki ʻoe kau leʻo, ki he fale fakapōpula, ko e potu ko ia naʻe nofo haʻisia ai ʻa Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pea naʻe tuku ʻakinaua ʻe he matāpule ʻoe kau leʻo, kia Siosefa ke ne leʻohi, pea naʻe tauhi ʻe ia ʻakinaua: pea ne na nofo ʻi he fale fakapōpula ʻo fuoloa siʻi pe. ");
INSERT INTO ton_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","¶ Pea ne na misi fakatouʻosi ʻae misi, taki taha ʻae tangata ʻene misi ʻi he pō pe taha, ʻae tangata taki taha ʻo fakatatau mo hono ʻuhinga ʻo ʻene misi, ʻae tauhi lahi, mo e tangata taʻo mā ʻae tuʻi ʻo ʻIsipite, ʻaia naʻe nofo haʻisia ʻi he fale fakapōpula. ");
INSERT INTO ton_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Pea ʻalu ange ʻa Siosefa kiate kinaua ʻi he pongipongi, pea sio ia kiate kinaua, pea vakai, naʻa na matapeko. ");
INSERT INTO ton_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Pea fehuʻi ia ki he ongo matāpule ʻa Felo, ʻakinaua naʻe pōpula mo ia ʻi he fale ʻo ʻene ʻeiki, ʻo pehē, “Ko e hā ʻoku mo matapeko ai he ʻaho ni?” ");
INSERT INTO ton_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Pea na pehē kiate ia, “Kuo ma misi ʻae misi, pea ʻoku ʻikai ha tokotaha ke fakahā hono ʻuhinga.” Pea pehē ʻe Siosefa kiate kinaua, “ʻIkai ʻoku ʻi he ʻOtua pe hono ʻuhinga? ʻOku ou kole mo fakahā mai ia kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Pea tala ʻe he tauhi lahi ʻene misi kia Siosefa, ʻo ne pehē kiate ia; “Vakai, ʻi heʻeku misi, naʻe ʻi hoku ʻao ʻae vaine; ");
INSERT INTO ton_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","pea naʻe ʻi he vaine ʻae vaʻa ʻe tolu pea hangē naʻe litolito ia, pea tupu hono fisi; pea naʻe tupu ʻi hono ngaahi fuhi ʻae kālepi momoho: ");
INSERT INTO ton_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","pea naʻe ʻi hoku nima ʻae ipu ʻa Felo pea naʻaku toʻo ʻae ngaahi kālepi, ʻo tatau ia ki he ipu ʻa Felo, pea ne u ʻatu ʻae ipu ki he nima ʻo Felo.” ");
INSERT INTO ton_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Pea pehēange ʻe Siosefa kiate ia, “Ko hono ʻuhinga eni; Ko e vaʻa ʻe tolu, ko e ʻaho ia ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","‌ʻI he teʻeki ʻosi ʻae ʻaho ʻe tolu, ʻe hakeakiʻi Ko e ʻe Felo, ʻo ne toe tuku koe ki hoʻo ngāue: pea te ke ʻatu ʻae ipu ʻa Felo ki hono nima, ʻo hangē ko ia naʻa ke fai ʻi hoʻo kei nofo ko ʻene tauhi lahi. ");
INSERT INTO ton_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ka ʻoka ke ka lelei koe, ke ke manatuʻi au; pea ʻoku ou kole ke ke ʻofa mai kiate au, ʻo tala au kia Felo, pea fakahao au mei he fale ni; ");
INSERT INTO ton_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","He ko e moʻoni naʻe kaihaʻasia au mei he fonua ʻoe kakai Hepelū: pea naʻe ʻikai te u fai ha meʻa ʻi heni foki, koeʻuhi ke nau tuku au ki he fale fakapōpula.” ");
INSERT INTO ton_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Pea kuo mamata ʻe he tangata taʻo mā, ʻoku lelei hono ʻuhinga, pea pehē ʻe ia kia Siosefa: “Naʻaku misi foki, pea vakai, naʻe ʻi hoku ʻulu ʻae kato hinehina ʻe tolu; ");
INSERT INTO ton_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Pea naʻe ʻi he kato ʻi ʻolunga ʻae ngaahi meʻakai, kuo taʻo kia Felo; pea naʻe kai ia ʻe he fanga manupuna mei he kato, ʻi hoku ʻulu.” ");
INSERT INTO ton_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Pea lea ʻa Siosefa, ʻo pehē: “Ko hono ʻuhinga, eni: ko e kato ʻe tolu ko e ʻaho ia ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Pea ʻi he teʻeki ke ʻosi ʻae ʻaho ʻe tolu, ʻe hiki ʻe Felo ho ʻulu meiate koe, pea te ne tautau koe ki he ʻakau; pea ʻe kai ʻe he fanga manupuna, ʻae kakano meiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","¶ Pea ʻi heʻene hokosia hono ʻaho tolu, ko e ʻaho fakamanatu ki he fanauʻi ʻo Felo, naʻa ne fai ʻae kātoanga ki heʻene kau nofoʻanga kotoa pē, pea naʻa ne lau hake ʻae tauhi lahi, mo e tangata taʻo mā, ʻi heʻene kau nofoʻanga. ");
INSERT INTO ton_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Pea ne toe tuku ki he tauhi lahi ʻa ʻene ngāue: pea toe ʻatu ʻe ia ʻae ipu ki he nima ʻo Felo; ");
INSERT INTO ton_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ka naʻa ne tautau ʻae tangata taʻo mā; ʻo hangē ko e fakamatala, ʻa Siosefa, ");
INSERT INTO ton_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ka naʻe ʻikai manatu ʻe he tauhi lahi kia Siosefa, ka naʻa ne fakangaloʻi ia. ");
INSERT INTO ton_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Pea hili ʻae taʻu kotoa ʻe ua, pea pehē, naʻe misi ʻa Felo: pea vakai naʻe tuʻu ia ʻi he veʻe vaitafe. ");
INSERT INTO ton_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Pea vakai, naʻe ʻalu hake mei he vaitafe ʻae fanga pulu ʻe fitu naʻe matamatalelei mo sino lahi; pea nau kai ʻi he ngoue mohuku. ");
INSERT INTO ton_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Pea vakai naʻe ʻalu hake ʻo muimui ʻi ai ʻae fanga pulu matamata kehe ʻe fitu, naʻe matamata kovi mo tutue lahi, pea nau tutuʻu ʻo ofi ki he fanga pulu kehe ʻi he veʻe vaitafe. ");
INSERT INTO ton_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Pea ko e fanga pulu matamata kovi mo tutue, naʻa nau kai ʻo ʻosi ʻae fanga pulu matamatalelei, mo sino lahi. Pea ʻā ai ʻa Felo. ");
INSERT INTO ton_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pea toe mohe ia, pea misi ia ko hono tuʻo ua; pea vakai, naʻe tupu hake ʻae fua koane ʻe fitu ʻi he kau pe taha, naʻe lahi mo lelei. ");
INSERT INTO ton_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Pea vakai, naʻe tupu hake ʻo muimui ʻi ai ʻae fua koane ʻe fitu, naʻe kekena mo mate ʻi he matangi hahake. ");
INSERT INTO ton_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Pea ko e fua vaivai ʻe fitu, naʻa nau kai ʻo ʻosi ʻae fua ʻe fitu naʻe mālohi mo lelei. Pea; ʻā ai ʻa Felo, pea vakai, ko e misi pe ia. ");
INSERT INTO ton_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pea pongipongi hake ai, naʻe mamahi pe hono laumālie; pea fekau ʻe ia ke ui ʻae kau fiemana kotoa pē ʻo ʻIsipite, pea mo e kau tangata poto kotoa pē ʻi ai: pea fakahā ʻe Felo ʻene misi kiate kinautolu; ka naʻe ʻikai ha taha ke ne faʻa fakahā hono ʻuhinga kia Felo. ");
INSERT INTO ton_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","¶ Pea lea ai ʻae tauhi lahi kia Felo, ʻo pehē, “ʻOku ou manatu ki heʻeku ngaahi hala he ʻaho ni; ");
INSERT INTO ton_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Naʻe tuputāmaki ʻa Felo ki heʻene kau tamaioʻeiki, pea ne tuku au ke fakapōpulaʻi, ki he fale ʻoe ʻeiki ʻoe kau leʻo, ʻa au mo e tangata taʻo mā. ");
INSERT INTO ton_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Pea naʻa ma misi ʻae misi ʻi he pō pe taha, ko au mo ia; naʻa ma misi ʻae tangata taki taha ʻo fakatatau ki hono ʻuhinga ʻo ʻene misi. ");
INSERT INTO ton_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Pea naʻa mau ʻi ai mo e talavou ko e Hepelū, ko e tamaioʻeiki ki he ʻeiki ʻoe kau leʻo; pea ma fakahā kiate ia, pea ne fakahā kiate kimaua hono ʻuhinga ʻoe ma misi, ki he tangata taki taha naʻa ne fakahā hono ʻuhinga ʻo ʻene misi. ");
INSERT INTO ton_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Pea naʻe hoko ia, ʻo hangē ko e meʻa naʻa ne fakahā; naʻa ne toe tuku au ki heʻeku ngāue, pea ne tautau ia.” ");
INSERT INTO ton_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","¶ Pea fekau leva ʻe Felo ke ui mai Siosefa, pea naʻa nau fakatoʻotoʻo ʻo ʻomi ia mei he fale fakapōpula; pea naʻa ne tele kava, pea fetongi hono kofu, pea haʻu ia kia Felo. ");
INSERT INTO ton_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pea pehē ʻe Felo kia Siosefa, “Kuo u misi ʻae misi, pea ʻoku ʻikai ha taha ke fakahā hono ʻuhinga; pea kuo u fanongo kiate koe, ʻoku ke faʻa ʻilo hono ʻuhinga ʻoe misi ke fakahā ia.” ");
INSERT INTO ton_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Pea talaange ʻe Siosefa kia Felo, ʻo pehē, “ʻOku ʻikai ʻiate au; ʻe tuku ʻe he ʻOtua kia Felo ʻae tala fakafiemālie.” ");
INSERT INTO ton_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pea pehē ʻe Felo kia Siosefa, “Naʻaku mamata ʻi heʻeku misi, pea vakai, naʻaku tuʻu ʻi he veʻe vaitafe: ");
INSERT INTO ton_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Pea vakai, naʻe ʻalu hake mei he vaitafe ʻae fanga pulu ʻe fitu naʻe sino lahi, mo matamatalelei; pea naʻa nau kai ʻi he ngoue mohuku: ");
INSERT INTO ton_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","pea vakai, naʻe ʻalu hake ʻae fanga pulu kehe ʻe fitu, naʻa nau kovi mo matamata kehe, mo tutue ʻaupito, kuo ʻikai te u mamata ki he kovi pehē, ʻi he fonua kotoa pē ʻo ʻIsipite: ");
INSERT INTO ton_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Pea naʻe kai ʻo ʻosi ʻe he fanga pulu tutue, ʻae ʻuluaki fanga pulu ʻe fitu, ʻaia naʻe sino: ");
INSERT INTO ton_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pea hili ʻenau kai ʻo ʻosi ia, pea naʻe ʻikai hano fakaʻilonga ʻo ʻenau kai ia; he naʻa nau matamata kovi ai pe, ʻo hangē ʻi muʻa. Pea u ʻā ai. ");
INSERT INTO ton_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Pea naʻaku mamata ʻi heʻeku misi, pea vakai, naʻe ai ʻae fua koane ʻe fitu ʻi he kau pe taha, naʻe lahi mo lelei; ");
INSERT INTO ton_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Pea vakai, naʻe ai ʻae fua koane ʻe fitu naʻe mae mo manifi, mo mate ʻi he matangi hahake, naʻe tupu hake ki mui; ");
INSERT INTO ton_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Pea naʻe kai ʻo ʻosi ʻae ngaahi fua lelei, ʻe he ngaahi fua mate: pea ne u tala ʻae meʻa ni ki he kau fiemana; ka naʻe ʻikai ha tokotaha ke faʻa fakahā ia.” ");
INSERT INTO ton_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","¶ Pea talaange ʻe Siosefa kia Felo, “Ko e misi ʻa Felo, ʻoku taha pe: kuo fakahā ʻe he ʻOtua kia Felo, ʻaia ʻoku ne teu ke fai. ");
INSERT INTO ton_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ko e fanga pulu lelei ʻe fitu ko e taʻu ia ʻe fitu: pea ko e fua lelei ʻe fitu, ko e taʻu ʻe fitu; ko e misi ʻoku taha pe. ");
INSERT INTO ton_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Pea ko e fanga pulu tutue mo matamata kovi ʻe fitu, naʻe tupu ki mui, ko e taʻu ia ʻe fitu: pea ko e fua ʻe fitu naʻe mate ʻi he matangi hahake, ko e taʻu honge ia ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ko eni ʻae meʻa kuo u lea ʻaki kia Felo; ko ia ʻoku teu ʻe he ʻOtua ke fai ni, kuo ne fakahā kia Felo. ");
INSERT INTO ton_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Vakai, ʻoku haʻu ʻae taʻu mahu lahi ʻe fitu ki he fonua kotoa pē ʻo ʻIsipite; ");
INSERT INTO ton_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pea ʻe hoko mo ia ʻae taʻu ʻe fitu ʻoku honge; pea ʻe ngalo ʻaupito ʻae mahu ʻi he fonua kotoa pē ʻo ʻIsipite; pea ʻe fakaʻosi ʻe he honge ʻae fonua; ");
INSERT INTO ton_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Pea ʻe ʻikai ʻilo ʻae mahu ʻi he fonua ni, ko e meʻa ʻi he honge ʻe hoko mo ia; koeʻuhi ʻe lahi ʻaupito ia. ");
INSERT INTO ton_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pea ko e meʻa ʻi hono fai ʻo tuʻo ua ʻae misi kia Felo; ko hono ʻuhinga kuo fakapapau ʻe he ʻOtua ʻae meʻa ni, pea ʻe fakahoko toʻotoʻo ia ʻe he ʻOtua. ");
INSERT INTO ton_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Pea ko eni, ke kumi ʻe Felo ha tangata lelei, mo poto, ke fakanofo ia, ke pule ki he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pea ke fai ʻe Felo ʻae meʻa ni, tuku ke fakanofo ʻae kau matāpule ki he fonua ni, pea ke vaheʻi mo toʻo hono vahe nima ʻoe fonua ko ʻIsipite, ʻi he taʻu mahu ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Pea tuku ke nau tānaki ʻae meʻakai kotoa pē ʻoe ngaahi taʻu lelei ko ia ʻoku haʻu, pea ke nau fokotuʻu ʻae koane ʻi he fekau ʻa Felo, pea nau maʻu ʻae meʻakai ʻi he ngaahi kolo. ");
INSERT INTO ton_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Pea ko e meʻakai ko ia ko e tokonaki ia ki he fonua ʻi he taʻu ʻe fitu ʻoe honge, ʻaia ʻe hoko ki he fonua ko ʻIsipite; ke ʻoua naʻa ʻauha ʻae fonua koeʻuhi ko e honge.” ");
INSERT INTO ton_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","¶ Pea naʻe lelei ʻae meʻa ko ia ʻi he ʻao ʻo Felo, mo e ʻao ʻo hono kau nofoʻanga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Pea pehē ʻe Felo ki heʻene kau tamaioʻeiki, “He te tau faʻa ʻilo ha tokotaha ʻo hangē ko eni, ko e tangata ʻoku ʻiate ia ʻae Laumālie ʻoe ʻOtua?” ");
INSERT INTO ton_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pea pehē ʻe Felo kia Siosefa, “Ko e meʻa ʻi he fakahā ʻe he ʻOtua kiate koe ʻae ngaahi meʻa ni, ʻoku ʻikai ha taha ʻoku lelei mo poto ʻo hangē ko koe: ");
INSERT INTO ton_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Te ke pule koe ki hoku fale: pea ʻe fekauʻi ʻa hoku kakai, ʻo fakatatau ki hoʻo lea: ko e nofoʻa fakatuʻi pe, teu lahi hake ai ʻiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pea pehē ʻe Felo kia Siosefa, “Vakai kuo u fakanofo koe he ʻaho ni, ki he fonua kotoa pē ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pea naʻe toʻo ʻe Felo hono mama mei hono nima, ʻo ne ʻai ia ki he nima ʻo Siosefa, ʻo ne fakakofuʻaki ia ʻae ngaahi kofu lelei, pea ne ʻai ʻae kahoa koula ki hono kia. ");
INSERT INTO ton_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Pea naʻa ne tuku ia ke heka ʻi hono ua ʻoe saliote naʻa ne maʻu pea naʻa nau kalanga ʻi hono ʻao, Punou pea naʻa ne fakanofo ia ke pule ki he fonua kotoa pē ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Pea pehē ʻe Felo kia Siosefa, “Ko Felo au, pea ʻe ʻikai ha tangata ʻi he fonua kotoa pē ʻo ʻIsipite, te ne hiki hono nima pe vaʻe, ka ʻi hoʻo pule.” ");
INSERT INTO ton_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pea ui ʻe Felo ʻae hingoa ʻo Siosefa ko Safinati Peanea: pea naʻa ne foaki kiate ia ʻa ʻAsinate, Ko e ʻofefine ʻo Potifela koe taulaʻeiki ʻo ʻOni, ko hono uaifi. Pea naʻe ʻalu ʻa Siosefa ki he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","¶ Pea naʻe tolungofulu taʻu ʻa Siosefa ʻi heʻene tuʻu ʻi he ʻao ʻo Felo ko e tuʻi ʻo ʻIsipite. Pea naʻe ʻalu ʻa Siosefa mei he ʻao ʻo Felo, ʻo ne ʻalu ʻi he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pea ʻi he taʻu mahu ʻe fitu naʻe fua lahi ʻaupito ʻae kelekele. ");
INSERT INTO ton_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Pea naʻa ne tānaki ʻae meʻakai kotoa pē ʻoe taʻu ʻe fitu, ʻaia naʻe ʻi he fonua kotoa pē ʻo ʻIsipite, ʻo fokotuʻu ia ʻi he kolo: ko e ngaahi meʻakai ʻoe ngoue, ʻaia naʻe takatakai ʻae kolo kotoa pē, naʻa ne fokotuʻu ia ki ai. ");
INSERT INTO ton_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Pea naʻe tānaki ʻe Siosefa ʻae koane ʻo tatau mo e ʻoneʻone ʻoe tahi, ʻo lahi ʻaupito, pea naʻe tuku ʻene lau ia; he naʻe ʻikai ke faʻa lau ia; ");
INSERT INTO ton_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Pea naʻe tupu kia Siosefa ʻae foha ʻe toko ua ʻi he teʻeki ai hoko ʻae honge, ʻaia naʻe fāʻeleʻi kiate ia ʻe ʻAsinate, ko e ʻofefine ʻo Potifela, ko e taulaʻeiki ʻo ʻOni. ");
INSERT INTO ton_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Pea naʻe ui ʻe Siosefa ʻae hingoa ʻo hono ʻuluaki, ko Manase; he naʻe pehē ʻe ia, “Kuo tuku ʻe he ʻOtua, ke u fakangaloʻi ʻeku ngaahi mamahi, mo e fale kotoa pē ʻo ʻeku tamai.” ");
INSERT INTO ton_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Pea ne ui ʻae hingoa ʻo hono toko ua ko ʻIfalemi; he kuo ngaohi au ʻe he ʻOtua ke u monūʻia ʻi he fonua ʻo hoku tautea. ");
INSERT INTO ton_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","¶ Pea naʻe ʻosi ange ʻae taʻu mahu ʻe fitu, ʻaia naʻe ʻi he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Pea kuo hoko ʻae taʻu ʻe fitu ʻoe honge, ʻo hangē ko e lea ʻa Siosefa pea naʻe ʻi he fonua kotoa pē ʻae honge ka naʻe ai ʻae mā ʻi he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Pea ʻi he hongea ʻae fonua kotoa pē ʻo ʻIsipite, naʻe tangi ʻae kakai kia Felo ki he mā: pea pehē ʻe Felo ki he kakai ʻIsipite; ʻAlu kia Siosefa; pea ko ia ʻoku ne fakahā kiate kimoutolu, mou fai ia. ");
INSERT INTO ton_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pea naʻe hoko ʻae honge ki he fonua kotoa pē; pea naʻe fakaava ʻe Siosefa ʻae ngaahi feleoko, ʻo ne fakatau ki he kakai ʻIsipite; pea tupu ʻo lahi ʻae honge ʻi he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pea naʻe haʻu ʻae fonua kotoa pē ki ʻIsipite kia Siosefa ke fakatau: koeʻuhi naʻe lahi fau ʻae honge ʻi he fonua kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Pea kuo mamata ʻe Sēkope ʻoku ai ʻae koane ʻi ʻIsipite, pea pehē ʻe Sēkope ki hono ngaahi foha, “Ko e hā ʻoku mou fesiofaki ai? ");
INSERT INTO ton_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Pea pehē ʻe ia, Vakai, kuo u fanongo ʻoku ai ʻae koane ʻi ʻIsipite: mou ʻalu ki ai, pea mou fakatau maʻatautolu mei ai; koeʻuhi ke tau moʻui, kae ʻikai mate.” ");
INSERT INTO ton_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","¶ Pea naʻe ʻalu ki ʻIsipite ke fakatau koane, ʻae ngaahi taʻokete ʻe toko hongofulu ʻo Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ka ko Penisimani ko e tehina ʻo Siosefa, naʻe ʻikai tuku ia ʻe Sēkope ke ʻalu mo hono ngaahi taʻokete; he naʻa ne pehē; Telia naʻa tō ha kovi kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Pea haʻu ʻae ngaahi foha ʻo ʻIsileli ke fakatau ʻae koane mo kinautolu naʻe haʻu; he naʻe lahi ʻae honge ʻi he fonua ko Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Pea naʻe pule pe ʻa Siosefa ʻi he fonua, pea ko ia pe naʻe fakatau ki he kakai kotoa pē ʻoe fonua; pea haʻu ʻae ngaahi taʻokete ʻo Siosefa, ʻo nau tulolo mo honau mata ki he kelekele, ʻi hono ʻao. ");
INSERT INTO ton_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Pea mamata ʻa Siosefa ki hono ngaahi taʻokete, ʻo ne ʻilo ʻakinautolu, ka naʻe mata kehe ia kiate kinautolu, ʻo ne lea mālohi kiate kinautolu: pea ne pehē kiate kinautolu, “ʻOku mou haʻu mei fē?” Pea nau talaange, “Mei he fonua ko Kēnani, ke fakatau meʻakai.” ");
INSERT INTO ton_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Pea naʻe ʻilo ʻe Siosefa hono ngaahi taʻokete, ka naʻe ʻikai te nau ʻilo ia. ");
INSERT INTO ton_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Pea naʻe manatu ʻe Siosefa ki he ngaahi misi naʻa ne misi ʻaki kiate kinautolu, pea pehē ʻe ia kiate kinautolu, “Ko e kau mataki ʻakinautolu; kuo mou haʻu ke mamata ki he telefua ʻoe fonua.” ");
INSERT INTO ton_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Pea nau talaange kiate ia, “ʻEiki ʻoku ʻikai, ka kuo haʻu ʻa hoʻo kau tamaioʻeiki ke fakatau meʻakai. ");
INSERT INTO ton_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ko e ngaahi foha ʻoe tangata pe taha ʻakimautolu kotoa pē: ko e kau tangata moʻoni ʻakimautolu, ʻoku ʻikai ko e kakai mataki ʻa hoʻo kau tamaioʻeiki.” ");
INSERT INTO ton_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Pea pehē ʻe ia kiate kinautolu, “ʻIkai, ka kuo mou haʻu ke mamata ki he telefua ʻoe fonua.” ");
INSERT INTO ton_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Pea naʻa nau pehē, “Ko hoʻo kau tamaioʻeiki, ko e kāinga ʻe toko hongofulu ma toko ua, ko e ngaahi foha ʻoe tangata pe taha ʻi he fonua ko Kēnani; pea vakai, ko e kimui, ʻoku ʻi he ʻemau tamai he ʻaho ni, pea ko e tokotaha kuo ʻikai.” ");
INSERT INTO ton_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Pea pehē ʻe Siosefa kiate kinautolu, “Ko ia ia naʻaku lea ai kiate kimoutolu, ʻo pehē, ko e kau mataki ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","E ʻahiʻahi kiate kimoutolu ʻaki ʻae meʻa ni; hangē ʻoku moʻui ʻa Felo, ʻe ʻikai te mou ʻalu ʻi heni, ʻo kapau ʻe ʻikai haʻu ki heni homou tehina. ");
INSERT INTO ton_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Fekau homou tokotaha ke ne ʻalu ʻo ʻomi homou tehina, pea ʻe nofo pōpula ʻakinautolu, koeʻuhi ke fakamoʻoni ki hoʻomou ngaahi lea, pe ʻoku ai ha moʻoni ʻiate kimoutolu; ka ka ʻikai, hangē ʻoku moʻui ʻa Felo, ko e kau mataki ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Pea naʻa ne tuku fakataha ʻakinautolu ki he fale fakapōpula, ʻi he ʻaho ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pea pehē ʻe Siosefa kiate kinautolu ʻi hono ʻaho tolu, “Mou fai eni, pea mou moʻui he ʻoku ou manavahē ki he ʻOtua; ");
INSERT INTO ton_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kapau ko e kau tangata angatonu ʻakinautolu, tuku ke haʻi homou tokotaha ʻi he fale ʻo homou pōpula: ka mou ʻalu ʻo fetuku ʻae koane telia ʻae honge ʻi homou ngaahi fale. ");
INSERT INTO ton_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ka mou ʻomi homou tehina kiate au; ko ia ʻe fakamoʻoni ai hoʻomou ngaahi lea, pea ʻe ʻikai te mou mate. Pea naʻa nau fai ia.” ");
INSERT INTO ton_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","¶ Pea naʻa nau fealēleaʻaki ʻo pehē, “Ko e moʻoni, ʻoku tau kovi ko e meʻa ʻi hotau tehina, ko e meʻa ʻi heʻetau mamata ki he feinga ʻa hono laumālie, ʻi heʻene fakakole kiate kitautolu, ka naʻe ʻikai te tau fie tokanga kiate ia; ko ia kuo tō ai ʻae mamahi ni kiate kitautolu.” ");
INSERT INTO ton_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Pea lea ʻa Lupeni kiate kinautolu, ʻo pehē, “ʻIkai ne u lea kiate kimoutolu, ʻo pehē, ʻoua naʻa mou fai hala ki he tamasiʻi, ka naʻe ʻikai te mou tokanga? Ko ia, vakai, ʻoku ʻeke foki ʻae totongi ʻo hono toto.” ");
INSERT INTO ton_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pea naʻe ʻikai te nau ʻilo ʻoku ʻilo ʻe Siosefa ʻenau lea; he naʻe lea ia kiate kinautolu ʻaki ʻae tangata hiki lea. ");
INSERT INTO ton_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Pea naʻe foki atu ia ʻiate kinautolu ʻo tangi; pea toe haʻu ia kiate kinautolu, ke nau alea, pea naʻa ne toʻo ʻa Simione ʻiate kinautolu, ʻo haʻi ia ʻi honau ʻao. ");
INSERT INTO ton_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","¶ Pea naʻe fekau ʻa Siosefa ke fakafonu ʻenau ngaahi tangai ʻi he koane, pea ke toe ai ki he tangai ʻae tangata taki taha, ʻene paʻanga, pea ke tuku kiate kinautolu ʻae ʻoho ke kai ʻi he hala; pea naʻe fai pehē ia kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Pea naʻa nau fakaheka ʻae koane ki heʻenau fanga asi, pea nau ʻalu. ");
INSERT INTO ton_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pea ʻi he toʻo ʻe honau tokotaha ʻene tangai ke ʻatu ʻae meʻakai ki heʻene ʻasi ʻi he fale talifononga, naʻe ʻilo ʻe ia ʻene ngaahi paʻanga; he vakai naʻe ʻi he ngutu ʻoe tangai ia. ");
INSERT INTO ton_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Pea pehē ʻe ia ki hono ngaahi tokoua, “Kuo toe ʻomi ʻeku ngaahi paʻanga; he vakai, ʻoku ʻi he ngutu ʻo ʻeku tangai;” pea naʻe vaivai ai honau loto, pea nau manavahē, ʻo fepehēʻaki, “Ko e hā eni kuo fai ʻe he ʻOtua kiate kitautolu?” ");
INSERT INTO ton_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","¶ Pea naʻa nau haʻu kia Sēkope ko e nau tamai ki he fonua ko Kēnani, ʻo nau fakahā kiate ia ʻae meʻa kotoa pē naʻe hoko kiate kinautolu; ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ko e tangata ʻoku ʻeiki ʻi he fonua, naʻe lea mālohi kiate kimautolu, ʻo pehē, Ko e kau mataki ʻakinautolu ki he fonua. ");
INSERT INTO ton_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pea mau tala kiate ia, ko e kau tangata moʻoni ʻakimautolu; ʻoku ʻikai ko e kau mataki ʻakimautolu. ");
INSERT INTO ton_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ko e kāinga ʻe toko hongofulu ma toko ua ʻakimautolu, ko e ngaahi foha ʻoe mau tamai, ko e tokotaha ʻoku ʻikai, pea ko e kimui ʻoku ʻi he ʻemau tamai he ʻaho ni, ʻi he fonua ko Kēnani.” ");
INSERT INTO ton_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Pea ko e tangata, ko e ʻeiki ʻoe fonua, naʻe pehē kiate kimautolu, “Te u ʻilo ʻi he meʻa ni, pe ko e kau tangata moʻoni ʻakinautolu; tuku mai homou tokoua ʻe tokotaha kiate au, pea mou ʻave ʻae meʻakai ki he honge ʻo homau ngaahi fale, pea mou ʻalu; ");
INSERT INTO ton_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Pea mou ʻomi ki heni, homou tehina: ko ia te u ʻilo ai, ʻoku ʻikai ko e kau mataki ʻakinautolu, ka ko e kau tangata moʻoni: pea te u toe tuku ai kiate kimoutolu homou tokoua, pea te mou fakatau ʻi he fonua ni.” ");
INSERT INTO ton_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","¶ Pea ʻi heʻenau lingi ʻenau ngaahi tangai, pea nau vakai, naʻe ʻilo taki taha ʻae tangata ʻene kato paʻanga ʻi he ngutu ʻo ʻene tangai: pea kuo mamata ʻakinautolu mo e nau tamai ki he ngaahi kato paʻanga, naʻa nau manavahē. ");
INSERT INTO ton_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Pea pehē ʻe Sēkope ko e nau tamai kiate kinautolu, “Kuo mou fakamasiva au ʻi heʻeku fānau; kuo ʻikai ʻa Siosefa, pea kuo ʻikai mo Simione, pea te mou toe ʻave mo Penisimani; ʻoku kovi ʻae ngaahi meʻa ni kotoa pē kiate au.” ");
INSERT INTO ton_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Pea lea ʻa Lupeni ki heʻene tamai, ʻo pehē, “Tāmateʻi hoku foha ʻe toko ua, ʻo kapau ʻe ʻikai te u toe ʻomi ia kiate koe; tuku mai ia ki hoku nima, pea te u toe ʻomi ia kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pea pehē ʻe ia, “E ʻikai ʻalu hifo hoku foha mo kimoutolu, he kuo mate hono tokoua, pea ʻoku toe tokotaha pe ia; pea kapau ʻe hoko ha kovi kiate ia ʻi he hala ʻoku mou ʻalu ai, te mou ʻomi hoku ʻuluhinā ki he faʻitoka ʻi he mamahi.” ");
INSERT INTO ton_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Pea naʻe lahi ʻaupito ʻae honge ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pea ʻi heʻene ʻosi ʻenau kai ʻae koane naʻa nau ʻomi mei ʻIsipite, naʻe pehē ʻenau tamai kiate kinautolu, “Toe ʻalu ʻo fakatau ʻetau meʻakai siʻi.” ");
INSERT INTO ton_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pea lea ʻa Siuta kiate ia, ʻo pehē, “Naʻe lea fakatotonu mai ʻae tangata kiate kimautolu, ʻo pehē, ‘E ʻikai te mou mamata ki hoku mata, ʻo kapau ʻe ʻikai ʻiate kimoutolu homou tehina.’ ");
INSERT INTO ton_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Pea kapau te ke tuku homau tehina ke ʻalu mo kimautolu, pea te mau toe ʻalu hifo ʻo fakatau hao meʻakai.” ");
INSERT INTO ton_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pea kapau ʻe ʻikai te ke tuku mai ia, ʻe ʻikai te mau ʻalu; he naʻe pehē ʻe he tangata kiate kimautolu, E ʻikai te mou mamata ki hoku mata, ʻo kapau ʻe ʻikai ʻiate kimoutolu homou tehina.” ");
INSERT INTO ton_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Pea pehē ʻe ʻIsileli, “Ko e hā naʻa mou fai kovi pehē ai kiate au, koeʻuhi ke fakahā ki he tangata ʻoku toe homou tehina?” ");
INSERT INTO ton_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Pea naʻa nau pehē, “Naʻe fehuʻi fakatotonu mai ʻe he tangata ki he ʻemau nofo, ʻa mo homau ngaahi kāinga, ʻo pehē, ʻOku kei moʻui hoʻomou tamai? ʻOku ai homou tehina? Pea naʻa mau tala kiate ia ʻo hangē ko e lea ni; he naʻa mau teitei ʻilo te ne lea, ʻo pehē, ‘Omi homou tehina ki heni?’” ");
INSERT INTO ton_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Pea pehē ʻe Siuta ki heʻene tamai ko ʻIsileli, “Tuku mai ʻae tamasiʻi kia au, pea te mau tuʻu hake ʻo ʻalu; koeʻuhi ke mau moʻui, kaeʻoua naʻa tau mate, ʻio, ʻakimautolu mo koe, mo e mau tamaiki foki. ");
INSERT INTO ton_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Te u totongi ia; te ke maʻu ia ʻi hoku nima: kapau ʻe ʻikai te u toe ʻomi ʻo tuku ia ʻi ho ʻao, ke ʻiate au hono kovi ʻo taʻengata:” ");
INSERT INTO ton_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","He ko e moʻoni, ka ne ʻikai ko e tau fakatuotuai ni, pehē kuo mau toe liu mai ko hono tuʻo ua. ");
INSERT INTO ton_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Pea pehē ʻe heʻenau tamai ko ʻIsileli kiate kinautolu, “Kapau ko ia, pea mou fai eni; ʻave ʻae ngaahi fua fungani lelei ʻoe fonua ʻi hoʻomou ngaahi tangai, pea mou ʻave ia, ko e meʻaʻofa ki he tangata, ko e paame, mo e hone, mo e ʻakau namu lelei, mo e paame nanamu, mo e ngaahi foʻi ai, mo e telie. ");
INSERT INTO ton_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Pea ʻave ʻae kato paʻanga ʻe ua ʻi homou nima; pea mo e paʻanga naʻe toe ʻomi ʻi he ngutu ʻo hoʻomou tangai, toe ʻave ia ʻi homou nima: naʻa ko ha fai noa nai;” ");
INSERT INTO ton_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","‌ʻAve foki mo homou tehina, pea mou tuʻu ʻo toe ʻalu ki he tangata: ");
INSERT INTO ton_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Pea ke tuku kiate kimoutolu ʻe he ʻOtua Māfimafi ʻae ʻofa ʻi he ʻao ʻoe tangata, koeʻuhi ke ne toe tuku mai homou tokoua ʻe taha, mo Penisimani. Kapau ʻe fakamasiva au ʻi heʻeku fānau, kuo u masiva moʻoni. ");
INSERT INTO ton_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","¶ Pea naʻe ʻave ʻe he kau tangata ʻae meʻaʻofa, pea naʻa nau toʻo ʻae kato paʻanga ʻe ua ʻi honau nima, pea mo Penisimani; pea naʻa nau tutuʻu hake ʻo toe ʻalu ki ʻIsipite, ʻo nau tutuʻu ʻi he ʻao ʻo Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Pea ʻi he mamata ʻa Siosefa ʻoku ʻiate kinautolu ʻa Penisimani, pea pehē ʻe ia ki he pule ʻo hono fale; “Omi ʻae kau tangata ni ki ʻapi, pea tāmateʻi ha manu mo teuteu; he te mau kai mo e kau tangata ʻi he hoʻatā.” ");
INSERT INTO ton_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Pea naʻe fai ʻe he tangata ʻo hangē ko e fekau ʻa Siosefa; pea naʻe ʻomi ʻe he tangata ʻae kau tangata ki he fale ʻo Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pea naʻe manavahē ʻae kau tangata, koeʻuhi ko e ʻave ʻakinautolu ki he fale ʻo Siosefa; pea naʻa nau pehē, “Kuo ʻomi ʻakitautolu ki heni, ko e meʻa ʻi he paʻanga nai, naʻe toe tuku mai ʻi heʻetau tangai, ʻi he fuofua haʻu; koeʻuhi ke nau fakahalaʻi ʻaki ʻakitautolu, ʻo ʻoho mai kiate kitautolu, ʻo puke ʻo fakapōpulaʻi ʻakitautolu, mo ʻetau fanga ʻasi.” ");
INSERT INTO ton_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Pea naʻa nau ʻunuʻunu ʻo ofi ki he tauhi ʻoe fale ʻo Siosefa, ʻo nau alea mo ia ʻi he matapā ʻoe fale, ");
INSERT INTO ton_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","‌ʻO pehē, “E ʻeiki, ko e moʻoni naʻa mau fuofua haʻu ke fakatau meʻakai: ");
INSERT INTO ton_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Pea ʻi he ʻemau hoko ki he fale talifononga, pea mau vete ʻemau tangai, pea vakai, kuo taki taha ʻae tangata ʻene paʻanga ʻi he ngutu ʻo ʻene tangai, ʻae paʻanga kotoa; pea kuo mau toe ʻomi ia ʻi homau nima. ");
INSERT INTO ton_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Pea mo e paʻanga kehe kuo mau ʻomi ke fakatau meʻakai: ʻoku ʻikai te mau ʻilo pe ko hai naʻa ne ai ʻemau paʻanga, ki he ʻemau tangai.” ");
INSERT INTO ton_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Pea pehē ʻe ia, “Mou fiemālie, ʻoua te mou manavahē: ko homou ʻOtua, mo e ʻOtua ʻo hoʻomou tamai naʻa ne tuku koloa maʻamoutolu, ki hoʻomou tangai: naʻe ʻiate au hoʻomou paʻanga.” Pea naʻa ne ʻomi ʻa Simione kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Pea ʻomi ʻe he tangata ʻae kau tangata ki he fale ʻo Siosefa, ʻo ne ʻatu ʻenau vai, pea fufulu honau vaʻe; pea naʻa ne ʻatu ʻae meʻakai ki heʻenau fanga ʻasi. ");
INSERT INTO ton_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Pea naʻa nau teuteu ʻae meʻaʻofa ʻo tali ʻae haʻu ki ʻapi ʻa Siosefa ʻi he hoʻatā: he naʻa nau fanongo te nau kai mā ʻi ai. ");
INSERT INTO ton_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","¶ Pea kuo haʻu ʻa Siosefa ki ʻapi, naʻa nau ʻomi kiate ia ki fale ʻae meʻaʻofa naʻe ʻi honau nima, ʻo nau tulolo ʻakinautolu kiate ia ki he kelekele. ");
INSERT INTO ton_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Pea fehuʻi ia kiate kinautolu pe ʻoku nau fēfē, ʻo ne pehē, “ʻOku lelei hoʻomou tamai, ʻae tangata motuʻa naʻa mou lea ki ai? ʻOku kei moʻui ia?” ");
INSERT INTO ton_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Pea nau talaange, “Ko hoʻo tamaioʻeiki ko e mau tamai ʻoku mālōlō pe, ʻoku kei moʻui ia.” Pea naʻa nau tulolo honau ʻulu ʻo nau hū. ");
INSERT INTO ton_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Pea naʻa ne hanga hake hono mata ʻo mamata ki hono tehina ko Penisimani, ʻae tama ʻa ʻene faʻē, ʻo ne pehē, “Ko homou tehina eni, ʻaia naʻa mou lea ki ai?” Pea pehē ʻe ia, “Ko hoku foha, ke ʻofa ʻae ʻOtua kiate koe.” ");
INSERT INTO ton_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Pea fakatoʻotoʻo ʻe Siosefa, he naʻe ngaue lahi hono fatu ki hono tehina: pea naʻa ne kumi ha potu ke tangi ai; pea hū ia ki hono loki, pea tangi ai. ");
INSERT INTO ton_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pea naʻa ne kaukau hono mata, pea ʻalu kituʻa, pea ne fakamaʻumaʻu ʻe ia ia, pea ne pehē, Ke mou teu mai ʻae kai. ");
INSERT INTO ton_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Pea naʻa nau teuteu maʻana tokotaha pe, pea teu kehe maʻanautolu, pea ai kehe ki he kakai ʻIsipite naʻe kai mo kinautolu; koeʻuhi naʻe ʻikai kai ʻae kakai ʻIsipite ʻo fakataha mo e kakai Hepelū; he ko e meʻa ia naʻe fakaliliʻa ai ʻae kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Pea naʻe fakanofo ʻakinautolu ʻi hono ʻao, ko e ʻuluaki ʻo fakatatau ki hono fanauʻi, mo e kimui ʻo fakatatau ki heʻene siʻi; pea naʻe feʻofaʻaki pe ʻae kau tangata. ");
INSERT INTO ton_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Pea naʻe toʻo ʻo ange ʻenau meʻakai mei hono ʻao: ka ko e meʻa ʻa Penisimani, naʻe tuʻo nima hono lahi hake ʻi heʻenau meʻa. Pea naʻa nau inu mo nau fiefia mo ia. ");
INSERT INTO ton_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Pea fekau ʻe ia ki he tauhi ʻo hono fale ʻo pehē, “Fakapito ʻaki ʻae meʻakai ʻae ngaahi tangai ʻae kau tangata ni, ʻo fakatatau mo ia te nau faʻa fua, pea ai ʻae paʻanga ʻae tangata taki taha ki he ngutu ʻo ʻene tangai. ");
INSERT INTO ton_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pea ai ʻeku ipu, ʻae ipu siliva ki he ngutuʻi tangai ʻae kimui, pea mo e paʻanga totongi ʻo ʻene koane.” Pea ne fai ʻe ia ʻo hangē ko e fekau ʻa Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Pea pongipongi hake ʻi he maʻa ʻae ʻaho, naʻe tuku ʻae kau tangata ke ʻalu, ʻakinautolu mo e nau fanga ʻasi. ");
INSERT INTO ton_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pea kuo nau ʻalu mei he kolo, pea naʻe teʻeki ai mamaʻo fau, pea pehē ʻe Siosefa ki heʻene tauhi, “Tuʻu, ʻo tuli ʻae kau tangata; pea ʻoka ke ka maʻu ʻakinautolu, pea ke lea pehē kiate kinautolu, ‘Ko e hā kuo mou totongi kovi ai ki he lelei?’ ");
INSERT INTO ton_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","‌ʻIkai ko ia ia ʻoku inu mei ai ʻa ʻeku ʻeiki, mo ia ʻoku ne fai ai ʻene ʻilo meʻa? Kuo mou fai kovi ʻi he meʻa ni.” ");
INSERT INTO ton_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","¶ Pea naʻa ne maʻu ʻakinautolu, ʻo ne lea ʻaki kiate kinautolu ʻae ngaahi lea ko ia. ");
INSERT INTO ton_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Pea nau pehēange kiate ia, “Ko e hā ʻoku lea pehē ai homauʻeiki? Ke mamaʻo ʻaupito mei hoʻo kau tamaioʻeiki ʻae fai ha meʻa pehē. ");
INSERT INTO ton_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Vakai, ko e ngaahi paʻanga naʻa mau ʻilo ʻi he ngutu ʻoe mau tangai, kuo mau toe ʻomi ia kiate koe, mei he fonua ko Kēnani: pea ʻe fēfeeʻi ʻemau kaihaʻa ha siliva pe ha koula mei he fale ʻo homauʻeiki? ");
INSERT INTO ton_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ko ia te ke ʻilo ia ki ai ʻi hoʻo kau tamaioʻeiki, tuku ke mate ia, pea te mau nofo ko e kau pōpula ki heʻemau ʻeiki foki.” ");
INSERT INTO ton_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Pea pehē ʻe ia, “Ko eni, ke hoko ʻo tatau mo hoʻomou lea: ko ia ʻe ʻilo ai ia, ko ʻeku tamaioʻeiki ia, pea ʻe taʻehalaia ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Pea naʻa nau fakatoʻotoʻo ʻo tuku hifo, taki taha ʻae tangata ʻa ʻene tangai ki he kelekele, pea toʻo taki taha ʻa ʻene tangai. ");
INSERT INTO ton_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Pea ne kumi ia, ʻo kamata ʻi he ʻuluaki, ʻo aʻu ki he kimui; pea naʻe ʻilo ʻae ipu ʻi he tangai ʻa Penisimani. ");
INSERT INTO ton_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Pea naʻa nau haehae honau kofu, ʻo toe ʻai ʻae kavenga taki taha ʻae tangata ki he ʻasi, ʻo nau foki ki he kolo. ");
INSERT INTO ton_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","¶ Pea naʻe haʻu ʻa Siuta mo hono ngaahi tokoua ki he fale ʻo Siosefa; he naʻe kei ʻi ai ia; pea nau foʻohifo ʻi hono ʻao ki he kelekele. ");
INSERT INTO ton_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Pea pehē ʻe Siosefa kiate kinautolu, “Ko e hā ʻae meʻa ni kuo mou fai? He naʻe ʻikai te mou mahalo, ko e tangata hangē ko au, te u faʻa ʻiloʻi.” ");
INSERT INTO ton_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Pea pehēange ʻe Siuta, “Ko e hā te mau lea ʻaki ki homauʻeiki? Pea te mau pehē ko e hā? Pea ʻe fēfē ʻemau fakatonuhia ʻakimautolu? Kuo ʻafioʻi ʻe he ʻOtua ʻae halaia ʻo hoʻo kau tamaioʻeiki; vakai, ko e kau tamaioʻeiki ʻakimautolu ʻa homauʻeiki, ʻakimautolu mo ia foki kuo ʻilo ki ai ʻae ipu ni.” ");
INSERT INTO ton_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pea pehē ʻe ia, “Tapu mo e ʻOtua ʻa ʻeku fai pehē: ka ko e tangata kuo ʻilo ʻi hono nima ʻae ipu ni, ko ʻeku tamaioʻeiki ia; ka ko kimoutolu, mou ʻalu fiemālie pe ki hoʻomou tamai.” ");
INSERT INTO ton_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","¶ Pea naʻe ʻunuʻunu mai ʻa Siuta kiate ia, ʻo ne pehē, “Ko ʻeku ʻeiki, ʻoku ou kole kiate koe, ke ke tuku ke lea siʻi pe ʻa hoʻo tamaioʻeiki ki he fofonga ʻo hoku ʻeiki, pea ʻoua naʻa ke tuputāmaki mai ki hoʻo tamaioʻeiki: he ʻoku ke tatau mo Felo. ");
INSERT INTO ton_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Naʻe fehuʻi ʻa homauʻeiki ki heʻene kau tamaioʻeiki, ʻo pehē, ‘ʻOku ai hoʻomou tamai, pe ha tehina?’ ");
INSERT INTO ton_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Pea naʻa mau tala ki homauʻeiki, ‘ʻOku ai ʻemau tamai ko e tangata motuʻa, pea mo e tama ʻo ʻene motuʻa, ko e tamasiʻi siʻi; pea kuo pekia hono tokoua, pea ko ia tokotaha pe kuo toe ʻi heʻene fale, pea ʻoku ʻofa ʻene tamai kiate ia.’ ");
INSERT INTO ton_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Pea naʻa ke pehē ki hoʻo kau tamaioʻeiki, ‘Omi ia ki heni kiate au, koeʻuhi ke u sio fakapapau kiate ia.’ ");
INSERT INTO ton_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Pea naʻa mau tala ki heʻemau ʻeiki, ‘ʻE ʻikai faʻa māvae ʻae tama mo ʻene tamai: he kapau te ne tuku ʻene tamai, ʻe pekia ai ʻene tamai:’ ");
INSERT INTO ton_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pea naʻa ke pehē ki hoʻo kau tamaioʻeiki, ‘Kapau ʻe ʻikai ʻiate kimoutolu homou tehina, ʻe ʻikai te mou toe mamata ki hoku mata.’ ");
INSERT INTO ton_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Pea ʻi heʻemau hoko ki hoʻo tamaioʻeiki ko ʻemau tamai, naʻa mau fakahā kiate ia ʻae ngaahi lea ʻa homauʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Pea pehē ʻe heʻemau tamai, ‘Toe ʻalu ʻo fakatau ʻetau meʻakai siʻi.’ ");
INSERT INTO ton_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","“Pea naʻa mau pehē, ‘ʻE ʻikai te mau faʻa ʻalu: kapau ʻe ʻiate kimautolu homau tehina, te mau ʻalu hifo: koeʻuhi ʻe ʻikai te mau mamata ki he mata ʻoe tangata, ʻo kapau ʻe ʻikai ʻiate kimautolu homau tehina.’ ");
INSERT INTO ton_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Pea naʻe pehē ʻe hoʻo tamaioʻeiki ko ʻemau tamai, kiate kimautolu, ‘ʻOku mou ʻilo naʻe fanauʻi kiate au ʻe hoku uaifi ʻae tama ʻe toko ua:’ ");
INSERT INTO ton_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Pea naʻe ʻalu ʻae tokotaha ʻiate au, pea naʻaku pehē, ‘Ko e moʻoni kuo haehae ke iikiiki ia; pea talu mei ai naʻe ʻikai te u toe mamata kiate ia:’ ");
INSERT INTO ton_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Pea kapau te mou ʻave eni ʻiate au foki, pea hoko ha kovi kiate ia, te mou ō hifo hoku ʻuluhinā ʻi he mamahi ki he faʻitoka. ");
INSERT INTO ton_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Pea ko eni, ʻoka hoko ʻa hoʻo tamaioʻeiki ko au ki heʻeku tamai, pea ʻikai ʻiate kimautolu ʻae tama; ko e meʻa ʻi he feohi fakataha ʻene moʻui mo e moʻui ʻae tama; ");
INSERT INTO ton_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","‌ʻE hoko ʻo pehē, ʻoka mamata ia ʻoku ʻikai ʻiate kimautolu ʻae tama, ʻe pekia ia; pea ko hoʻo kau tamaioʻeiki te mau fakahifo ʻae ʻuluhinā ʻo hoʻo tamaioʻeiki ko ʻemau tamai ʻi he mamahi, ki he faʻitoka. ");
INSERT INTO ton_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","He naʻe hoko ʻa hoʻo tamaioʻeiki, ko e fetongi ʻoe tama ki heʻene tamai, ʻo pehē, Kapau ʻe ʻikai te u toe ʻomi ia kiate koe, pea ke ʻiate au hono kovi ki heʻeku tamai ʻo taʻengata. ");
INSERT INTO ton_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Pea ko eni, ʻoku ou kole kiate koe, tuku ke nofo ʻa hoʻo tamaioʻeiki ko e pōpula ki heʻeku ʻeiki, ko e fetongi ʻoe tama; kae tuku ke ʻalu ʻae tama mo hono ngaahi taʻokete. ");
INSERT INTO ton_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","He koeʻuhi, ʻe fēfeeʻi ʻeku faʻa ʻalu ki heʻeku tamai, kae ʻikai ʻiate au ʻae tama? Telia naʻaku mamata ki he kovi ʻe hoko ki heʻeku tamai.” ");
INSERT INTO ton_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Pea naʻe ʻikai faʻa taʻofi ia ʻe Siosefa ʻi he ʻao ʻokinautolu kotoa pē naʻe tutuʻu ʻo ofi kiate ia; pea tangi ia, ʻo pehē, “Ke ʻalu ʻae tangata kotoa pē meiate au.” Pea naʻe ʻikai ʻi ai ha tangata ʻe tokotaha, ʻi he fakahā ia ʻe Siosefa ki hono ngaahi tokoua. ");
INSERT INTO ton_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Pea naʻe tangi kalanga ia; pea naʻe fanongo ki ai ʻae kakai ʻIsipite mo e fale ʻo Felo. ");
INSERT INTO ton_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Pea pehē ʻe Siosefa ki hono ngaahi tokoua, “Ko Siosefa au: ʻoku kei moʻui ʻeku tamai? Pea naʻe ʻikai faʻa tali ia ʻe hono ngaahi tokoua; he kuo nau puputuʻu ʻi hono ʻao. ");
INSERT INTO ton_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Pea pehē ʻe Siosefa ki hono ngaahi tokoua, “ʻOku ou kole kiate kimoutolu, mou ʻunuʻunu mai kiate au.” Pea naʻa nau ʻunuʻunu atu, pea pehē ʻe ia, “Ko Siosefa au, ko homou tokoua, ʻaia naʻa mou fakatau ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Pea ko eni ʻoua naʻa mou mamahi, pe ʻita kiate kimoutolu, koeʻuhi ko hoʻomou fakatau au ki heni: he naʻe fekau au ʻe he ʻOtua, ke u muʻomuʻa ʻiate kimoutolu ke fakahaofi hoʻomou moʻui. ");
INSERT INTO ton_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","He ko hono ua taʻu eni, mo e hongea ʻae fonua: pea ʻoku toe ʻae taʻu ʻe nima ʻe ʻikai ʻi ai ha tō taʻu pe ko e ututaʻu. ");
INSERT INTO ton_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pea naʻe fekau au ʻe he ʻOtua ke muʻomuʻa ʻiate kimoutolu ke fakamoʻui homou hako ʻi māmani, ke fakahaofi hoʻomou moʻui, ʻi he fakamoʻui lahi. ");
INSERT INTO ton_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Pea ko eni, naʻe ʻikai ko kimoutolu naʻe fekau au ki heni, ka ko e ʻOtua: pea kuo ne ngaohi au ko e tamai kia Felo, mo e ʻeiki ki hono fale kotoa pē, pea mo e pule ki he fonua kotoa pē ʻo ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Mou fakatoʻotoʻo, ʻo ʻalu ki heʻeku tamai, pea mou pehē kiate ia, ‘ʻOku lea pehē ho foha ko Siosefa, Kuo ngaohi au ʻe he ʻOtua ko e ʻeiki ki ʻIsipite kotoa pē; ke ke haʻu kiate au, ʻoua naʻa tatali. ");
INSERT INTO ton_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Pea te ke nofo ʻi he fonua ko Koseni, pea te ke ofi kiate au, ʻa koe mo hoʻo fānau, mo e fānau ʻa hoʻo fānau, mo hoʻo fanga manu, mo hoʻo fanga sipi, mo e meʻa kotoa pē ʻoku ke maʻu. ");
INSERT INTO ton_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Pea te u fafanga koe ʻi ai; he ʻoku kei toe ʻae taʻu ʻe nima ʻoe honge: telia naʻa masiva koe mo hoʻo kau nofoʻanga, pea mo e meʻa kotoa pē ʻoku ke maʻu.’” ");
INSERT INTO ton_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Pea vakai, ʻoku mamata ʻa homou mata, pea mo e mata ʻo hoku tehina ko Penisimani, ko hoku ngutu ia ʻoku lea kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pea te mou tala ki heʻeku tamai hoku nāunau kotoa pē ʻi ʻIsipite, pea mo e meʻa kotoa pē kuo mou mamata ki ai; pea te mou fakatoʻotoʻo ʻo ʻomi ʻeku tamai ki heni. ");
INSERT INTO ton_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Pea naʻa ne faʻaki ki he kia ʻo hono tehina ko Penisimani ʻo tangi; pea tangi ʻe Penisimani ki hono kia. ");
INSERT INTO ton_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Pea ʻuma ia ki hono ngaahi tokoua kotoa pē, ʻo fāʻufua mo tangi kiate kinautolu; pea hili ia ne nau fealēleaʻaki mo hono ngaahi tokoua. ");
INSERT INTO ton_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","¶ Pea naʻe ongo ʻae meʻa ni ki he fale ʻo Felo, ʻo pehē, “Kuo haʻu ʻae ngaahi tokoua ʻo Siosefa: pea naʻe fiefia lahi ai ʻa Felo, pea mo hono kau nofoʻanga. ");
INSERT INTO ton_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pea pehē ʻe Felo kia Siosefa, Ke ke lea pehē ki ho kāinga, Mou fai ʻae meʻa ni; hilifaki ʻae koane ki hoʻomou fanga manu, pea mou mole leva ki he fonua ko Kēnani; ");
INSERT INTO ton_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Pea ʻomi hoʻomou tamai mo hoʻomou ngaahi kau nofoʻanga ʻo haʻu kiate au; pea te u foaki kiate kimoutolu ʻae lelei ʻoe fonua ko ʻIsipite, pea te mou kai ʻae lelei ʻoe fonua. ");
INSERT INTO ton_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Pea ko eni, kuo mou maʻu ʻae fekau, pea mou fai eni: pea mou ʻave ʻae ngaahi saliote mei he fonua ko ʻIsipite, koeʻuhi ko hoʻomou tamaiki, mo homou ngaahi uaifi, pea mou ʻomi hoʻomou tamai, pea haʻu. ");
INSERT INTO ton_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pea ʻoua naʻa tokanga foki ki hoʻomou ngaahi meʻa: he ʻoku ʻamoutolu ʻae lelei ʻoe fonua ko ʻIsipite kotoa.” ");
INSERT INTO ton_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Pea naʻe fai ia ʻe he fānau ʻa ʻIsileli pea foaki ʻe Siosefa ʻae ngaahi saliote kiate kinautolu ʻo hangē ko e fekau ʻa Felo, ʻo ne ʻatu honau ʻoho ki he hala. ");
INSERT INTO ton_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Naʻa ne foaki kiate kinautolu, ki he tangata taki taha ʻae ngaahi kofu, ka naʻa ne foaki kia Penisimani ʻae konga siliva ʻe tolungeau, mo e ngaahi kofu kotoa kehekehe ʻe nima. ");
INSERT INTO ton_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pea ne tuku ʻae meʻa ko eni ki heʻene tamai; ko e ʻasi ʻe hongofulu kuo fakaheka ki ai ʻae ngaahi meʻa lelei ʻo ʻIsipite, pea ko e ʻasi fefine ʻe hongofulu kuo fakaheka ki ai ʻae koane, mo e mā, mo e meʻakai ko e ʻoho ki heʻene tamai ʻi he hala. ");
INSERT INTO ton_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Pea ne tuku hono ngaahi tokoua kenau ʻalu, pea naʻa nau ʻalu: pea pehē ʻe ia kiate kinautolu, “Vakai, ke ʻoua naʻa mou kē ʻi he hala.” ");
INSERT INTO ton_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","¶ Pea naʻa nau ʻalu mei ʻIsipite, ʻo hoko ki he fonua ko Kēnani, kia Sēkope ko ʻenau tamai, ");
INSERT INTO ton_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","‌ʻonau talaange kiate ia ʻo pehē, “ʻOku kei moʻui ʻa Siosefa, pea ko e pule ia ʻoe fonua kotoa pē ʻo ʻIsipite.” Pea lele ai ʻae moʻui ʻo Sēkope, he naʻe ʻikai te ne tui kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pea naʻa nau tala kiate ia ʻae ngaahi lea kotoa pē ʻa Siosefa, ʻaia naʻa ne tala kiate kinautolu; pea ʻi heʻene mamata ki he ngaahi saliote naʻe fekau ʻe Siosefa ke fetuku ia, naʻe toe moʻui ʻae laumālie ʻo ʻenau tamai ko Sēkope: ");
INSERT INTO ton_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Pea naʻe pehē ʻe ʻIsileli, “Maʻuā, ʻoku kei moʻui hoku foha ko Siosefa: te u ʻalu ʻo mamata kiate ia ʻi he teʻeki ai teu mate.” ");
INSERT INTO ton_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Pea fononga ʻa ʻIsileli mo e meʻa kotoa pē naʻa ne maʻu, pea haʻu ia ki Peasipa, pea ne ʻatu ʻi ai ʻae ngaahi feilaulau ki he ʻOtua ʻo ʻene tamai ko ʻAisake. ");
INSERT INTO ton_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Pea naʻe folofola ʻae ʻOtua kia ʻIsileli ʻi he ngaahi meʻa hā mai ʻoe pō, ʻo ne pehē, “Sēkope, Sēkope;” pea pehē ʻe ia, “Ko au eni.” ");
INSERT INTO ton_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Pea pehē ʻe ia, “Ko e ʻOtua au, ko e ʻOtua ʻo hoʻo tamai: ʻOua naʻa ke manavahē ke ʻalu hifo ki ʻIsipite, he te u ngaohi ʻaki koe ʻi ai ʻae puleʻanga lahi. ");
INSERT INTO ton_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Pea te u ʻalu mo koe ki ʻIsipite; pea ko e moʻoni te u toe ʻomi koe mei ai; pea ʻe ʻai ʻe Siosefa hono nima ki ho mata.” ");
INSERT INTO ton_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Pea naʻe tuʻu hake ʻa Sēkope mei Peasipa: pea ko e ngaahi foha ʻo ʻIsileli naʻa nau ʻomi ʻa ʻenau tamai ko Sēkope, mo ʻenau fānau, mo honau ngaahi uaifi ʻi he ngaahi saliote naʻe fekau ʻe Felo ke fetuku ʻaki ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Pea naʻa nau ʻave ʻenau fanga manu mo ʻenau koloa, naʻa nau maʻu ʻi he fonua ko Kēnani, ʻo nau haʻu ki ʻIsipite, ʻa Sēkope, mo hono hako kotoa pē mo ia: ");
INSERT INTO ton_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ko hono ngaahi foha, mo e ngaahi foha ʻo hono ngaahi foha mo ia, mo e ngaahi ʻofefine ʻo hono ngaahi foha, mo hono hako kotoa pē, naʻe haʻu mo ia ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","¶ Pea ko e ngaahi hingoa eni ʻoe fānau ʻa ʻIsileli naʻe haʻu ki ʻIsipite, ko Sēkope mo hono ngaahi foha: ko Lupeni ko e ʻuluaki ʻo Sēkope. ");
INSERT INTO ton_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Pea ko e ngaahi foha ʻo Lupeni; ko Henoke, mo Falu, mo Hesiloni, mo Kalimi. ");
INSERT INTO ton_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","¶ Pea ko e ngaahi foha ʻo Simione; ko Semueli, mo Samini, mo ʻOhati, mo Sakini, mo Sohali, mo Saula, ko e tama ʻae fefine Kēnani. ");
INSERT INTO ton_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","¶ Pea ko e ngaahi foha ʻo Livai, ko Kesoni, mo Kohate, mo Melali. ");
INSERT INTO ton_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","¶ Pea ko e ngaahi foha ʻo Siuta; ko ʻEa, mo ʻOnani, mo Felesi, mo Selaa, ka naʻe mate ʻa ʻEa mo ʻOnani ʻi he fonua ko Kēnani, pea ko e ongo foha ʻo Felesi ko Hesiloni mo Hamuli. ");
INSERT INTO ton_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","¶ Pea ko e ngaahi foha ʻo ʻIsaka; ko Tola, mo Fufa, mo Sope, mo Similoni. ");
INSERT INTO ton_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","¶ Pea ko e ngaahi foha ʻo Sepuloni; ko Seleti, mo ʻEloni, mo Salili. ");
INSERT INTO ton_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ko e ngaahi tama eni ʻa Lia, naʻa ne fāʻeleʻi kia Sēkope ʻi Petanalami, mo hono ʻofefine ko Taina; ko e laumālie ʻo hono ngaahi foha mo hono ngaahi ʻofefine naʻe toko tolungofulu ma toko tolu. ");
INSERT INTO ton_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","¶ Pea ko e ngaahi foha ʻo Kata; ko Sifioni, mo Haki, mo Suni, mo ʻEsiponi, mo ʻElai, mo ʻEloti, mo ʻAlili. ");
INSERT INTO ton_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","¶ Pea ko e ngaahi foha ʻo ʻAseli; ko Simina, mo ʻIsua, mo ʻIsui, mo Pelia, mo Sela, ko honau tuofefine; pea ko e ongo foha ʻo Pelia; ko Hepa, mo Malikieli. ");
INSERT INTO ton_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ko e ngaahi tama eni ʻa Silipa, ʻaia ne foaki ʻe Lepani ki hono ʻofefine ko Lia, pea ne fanauʻi ʻakinautolu ni kia Sēkope, ko e laumālie ʻe hongofulu ma ono. ");
INSERT INTO ton_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Pea ko e fānau ʻa Lesieli ko e uaifi ʻo Sēkope; ko Siosefa, mo Penisimani. ");
INSERT INTO ton_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","¶ Pea naʻe tupu ia Siosefa ʻi he fonua ko ʻIsipite, ʻa Manase, mo ʻIfalemi, ʻaia naʻe fanauʻi kiate ia ʻe ʻAsinate ko e ʻofefine ʻo Potifela ko e taulaʻeiki ʻo ʻOni. ");
INSERT INTO ton_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","¶ Pea ko e ngaahi foha ʻo Penisimani, ko Pela, mo Pekeli, mo ʻAsipeli, mo Kela, mo Neemani, mo ʻEhi, mo Losi, mo Mupimi, mo Hupimi, mo ʻAliti. ");
INSERT INTO ton_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ko e ngaahi tama eni ʻa Lesieli, naʻe tupu kia Sēkope; ko e laumālie kotoa pē, naʻe toko hongofulu ma toko fā. ");
INSERT INTO ton_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","¶ Pea ko e foha ʻo Tani; ko Husami. ");
INSERT INTO ton_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","¶ Pea ko e ngaahi foha ʻo Nafitali, ko Saseili, mo Kuni; mo Seseli, mo Silemi. ");
INSERT INTO ton_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ko e ngaahi tama eni ʻa Pila, ʻaia naʻe foaki ʻe Lepani, ki hono ʻofefine ko Lesieli, pea ne fānau ʻakinautolu ni kia Sēkope; ko e laumālie kotoa pē naʻe toko fitu. ");
INSERT INTO ton_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ko e laumālie kotoa pē naʻe haʻu mo Sēkope ki ʻIsipite, ʻaia naʻe tupu ʻiate ia, ka ʻoku ʻikai lau ʻae ngaahi uaifi ʻoe ngaahi foha ʻo Sēkope; ko e laumālie ʻe toko onongofulu ma toko ono. ");
INSERT INTO ton_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Pea ko e ongo foha ʻo Siosefa naʻe fānau kiate ia ʻi ʻIsipite, ko e laumālie ʻe toko ua: pea ko e laumālie kotoa pē ʻoe fale ʻo Sēkope, naʻe haʻu ki ʻIsipite, naʻa nau toko fitungofulu. ");
INSERT INTO ton_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","¶ Pea naʻa ne fekau ʻa Siuta ke muʻomuʻa ʻiate ia, ke fakahinohino ia ki Koseni; pea naʻa nau hoko ki he fonua ko Koseni. ");
INSERT INTO ton_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Pea teuteu ʻe Siosefa hono saliote, pea ʻalu ia ke fakafetaulaki ki heʻene tamai ʻi Koseni, ʻo ne fakahā ia kiate ia: pea ne fāʻufua ia ʻo faʻaki ki hono kia ʻo tangi fuoloa. ");
INSERT INTO ton_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Pea pehē ʻe ʻIsileli kia Siosefa, “Ko eni tuku ke u mate, he koeʻuhi kuo u mamata ki ho mata, pea ʻoku ke kei moʻui.” ");
INSERT INTO ton_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Pea pehē ʻe Siosefa ki hono ngaahi tokoua mo e fale ʻo ʻene tamai, “Te u ʻalu hake ʻo fakahā kia Felo, ʻo tala kiate ia, ko hoku ngaahi tokoua, mo e fale ʻo ʻeku tamai ʻaia naʻe ʻi he fonua ko Kēnani, kuo nau haʻu kiate au. ");
INSERT INTO ton_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Pea ko e kau tauhi sipi ʻae kau tangata, he ko ʻenau ngāue ko e fafanga ʻae fanga manu; pea kuo nau ʻomi ʻenau fanga manu mo e meʻa kotoa pē ʻoku nau maʻu. ");
INSERT INTO ton_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Pea ʻe hoko ʻo pehē, ʻoka ui ʻa Felo kiate kimoutolu, ʻo ne fehuʻi pe ko e hā ʻa hoʻomou faiva; ");
INSERT INTO ton_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Pea te mou pehē, ‘Ko e ngāue ʻa hoʻo kau tamaioʻeiki talu ʻemau kei siʻi ʻo fai mai ni, ʻio ʻakimautolu mo ʻemau ngaahi tamai, ko e tauhimanu;’ koeʻuhi ke mou nofo ʻi he fonua ko Koseni,” he ʻoku fakalielia ki he kakai ʻIsipite, ʻae tauhi sipi kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Pea haʻu ʻa Siosefa ʻo fakahā kia Felo, ʻo pehē, “Kuo haʻu ʻeku tamai mo hoku ngaahi kāinga mo ʻenau fanga sipi, mo e fanga manu, mo ʻenau meʻa kotoa pē, mei he fonua ko Kēnani; pea vakai ʻoku nau ʻi he fonua ko Koseni.” ");
INSERT INTO ton_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Pea naʻa ne ʻave ʻae niʻihi ʻo hono ngaahi tokoua, ʻio, ʻae kau tangata ʻe toko nima, ʻo ne fakahā ʻakinautolu kia Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pea naʻe pehē ʻe Felo ki hono ngaahi tokoua, “Ko e hā hoʻomou faiva?” Pea nau talaange kia Felo, “Ko e tauhi sipi ʻa hoʻo kau tamaioʻeiki, ʻakimautolu mo ʻemau ngaahi tamai foki.” ");
INSERT INTO ton_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Pea naʻa nau pehē foki kia Felo, “Kuo mau haʻu ke mau ʻāunofo ʻi he fonua; he ʻoku ʻikai ʻi hoʻo kau tamaioʻeiki ha meʻakai ki heʻemau fanga manu; he kuo lahi ʻaupito ʻae honge ʻi he fonua ko Kēnani, ko ia ʻoku mau kole ai tuku ke nofo ʻa hoʻo kau tamaioʻeiki ʻi he fonua ko Koseni.” ");
INSERT INTO ton_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pea lea ʻa Felo kia Siosefa ʻo pehē, “Kuo haʻu kiate koe ʻa hoʻo tamai mo ho ngaahi kāinga: ");
INSERT INTO ton_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","‌ʻoku ʻi ho ʻao ʻae fonua kotoa pē ko ʻIsipite; ʻi he potu lelei ʻoe fonua, ke ke tuku ke nofo ai hoʻo tamai mo ho ngaahi tokoua: tuku ke nau nofo ʻi he fonua ko Koseni: pea kapau ʻoku ke ʻilo ha kau tangata poto ʻiate kinautolu, pea ke fakanofo ʻakinautolu ke nau puleʻi ʻeku fanga manu.” ");
INSERT INTO ton_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Pea ʻomi ʻe Siosefa ʻene tamai ko Sēkope, ʻo tuku ia ki he ʻao ʻo Felo; pea naʻe tāpuaki ʻe Sēkope ʻa Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pea naʻe fehuʻi ʻa Felo, kia Sēkope, ʻo pehē, “ʻOku fiha ho taʻu?” ");
INSERT INTO ton_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Pea pehē ʻe Sēkope kia Felo, “Ko e ngaahi ʻaho ʻoe taʻu ʻo hoku fononga, ko e taʻu ʻe teau mo e taʻu ʻe tolungofulu: kuo siʻi mo kovi pe ʻae ngaahi ʻaho ʻoe ngaahi taʻu ʻo ʻeku moʻui, pea ʻoku teʻeki ai aʻu ia ki he ngaahi ʻaho ʻoe ngaahi taʻu ʻoe moʻui ʻa ʻeku ngaahi tamai, ʻi he ngaahi ʻaho ʻo honau fononga.” ");
INSERT INTO ton_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Pea naʻe tāpuaki ʻe Sēkope ʻa Felo, pea ʻalu ia mei he ʻao ʻo Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","¶ Pea naʻe tuku ʻe Siosefa ʻene tamai mo hono ngaahi tokoua ʻo ne foaki kiate kinautolu ʻae nofoʻanga ʻi he fonua ko ʻIsipite, ʻi he potu lelei ʻi he fonua ko Lamesisi, ʻo hangē ko e fekau ʻa Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Pea naʻe tauhi ʻe Siosefa ʻene tamai, mo hono ngaahi kāinga, mo e kau nofoʻanga kotoa pē ʻo ʻene tamai ʻaki ʻae mā, ʻo fakatatau mo honau ngaahi ʻapi. ");
INSERT INTO ton_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","¶ Pea naʻe ʻikai ha mā ʻi he fonua kotoa; he naʻe lahi ʻae honge, pea naʻe vaivai ʻae fonua kotoa ʻo ʻIsipite, mo Kēnani, koeʻuhi ko e honge. ");
INSERT INTO ton_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Pea naʻe tānaki ʻe Siosefa ʻae paʻanga kotoa pē naʻe ʻilo ʻi he fonua kotoa pē ko ʻIsipite, mo e fonua ko Kēnani, ko e totongi ʻoe koane naʻa nau fakatau; pea ʻomi ʻe Siosefa ʻae ngaahi paʻanga ki he fale ʻo Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Pea kuo ʻosi ʻae ngaahi paʻanga ʻi he fonua ko ʻIsipite, mo e fonua ko Kēnani, pea haʻu ʻae kakai ʻIsipite kotoa pē kia Siosefa ʻo nau pehē, “Tuku mai haʻamau mā; he ko e hā te mau mate ai ʻi ho ʻao? He kuo ʻikai ha paʻanga.” ");
INSERT INTO ton_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Pea pehēange ʻe Siosefa, “Tuku mai hoʻomou fanga manu: pea te u ʻatu ʻae mā koeʻuhi ko hoʻomou fanga manu, ʻo kapau kuo ʻosi ʻae paʻanga.” ");
INSERT INTO ton_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Pea naʻa nau ʻomi ʻenau fanga manu kia Siosefa; pea ʻatu ʻe Siosefa kiate kinautolu ʻae mā, ko e fetongi ʻo ʻenau fanga hoosi mo e fanga sipi, mo ʻenau fanga manu lalahi mo e fanga ʻasi; pea ne fafanga ʻakinautolu ʻi he taʻu ko ia, koeʻuhi ko ʻenau fanga manu. ");
INSERT INTO ton_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Pea ʻi he ʻosi ʻae taʻu ko ia, pea nau toe haʻu kia Siosefa ʻi hono ua ʻoe taʻu, ʻo nau pehē kiate ia, “E ʻikai te mau fakafufū mei homauʻeiki, kuo ʻosi ʻemau paʻanga; pea kuo maʻu foki ʻe homauʻeiki ʻemau fanga manu: ʻoku ʻikai toe ha meʻa ʻi he ʻao ʻo homauʻeiki, ka ko homau sino pe mo homau ngaahi fonua. ");
INSERT INTO ton_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ko e hā te mau mate ai ʻi ho ʻao, ʻakimautolu mo homau fonua? Ke ke fakatau ʻakimautolu mo homau fonua ʻaki ʻae mā, pea te mau hoko, mo homau fonua, ko e kau tamaioʻeiki kia Felo; pea tuku kiate kimautolu ʻae tenga, koeʻuhi ke mau moʻui, kae ʻikai mate, pea ke ʻoua naʻa lala ʻae fonua.” ");
INSERT INTO ton_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Pea naʻe fakatau ʻe Siosefa ʻae fonua kotoa pē ʻa ʻIsipite, kia Felo; he naʻe taki taha fakatau ʻe he kakai ʻIsipite ʻa ʻene ngoue; he koeʻuhi naʻe fakavaivaiʻi ʻakinautolu ʻe he honge; pea naʻe maʻu ʻe Felo ʻae fonua kotoa pē. ");
INSERT INTO ton_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Pea koeʻuhi ko e kakai, naʻa ne tuku ʻakinautolu ki he ngaahi kolo mei he ngataʻanga ʻe taha ʻo ʻIsipite ʻo aʻu ki hono ngataʻanga ʻe taha. ");
INSERT INTO ton_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ka ko e fonua ʻoe kau taulaʻeiki naʻe ʻikai te ne fakatau; he naʻe ʻatu ʻae ʻinasi ki he kau taulaʻeiki meia Felo, pea naʻa nau kai ʻaia naʻe foaki ʻe Felo kiate kinautolu; ko ia naʻe ʻikai ai tenau fakatau honau fonua. ");
INSERT INTO ton_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Pea naʻe pehē ʻe Siosefa ki he kakai, “Vakai, kuo u fakatau ʻakimoutolu he ʻaho ni, mo homou fonua, maʻa Felo: vakai mai, ko e tenga eni kiate kimoutolu, pea te mou tūtuuʻi ʻaki ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pea ʻe hoko ʻo pehē, ʻi hono tupu te mou ʻomi hono vahe nima kia Felo, ka ko e vahe ʻe fā ʻe ʻiate kimoutolu ia, ko e tenga ki hoʻomou ngoue, mo e meʻakai kiate kimoutolu, mo kinautolu ʻi homou kau nofoʻanga, mo e meʻakai ki hoʻomou fānau.” ");
INSERT INTO ton_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Pea naʻa nau pehē, “Kuo fakahaofi ʻemau moʻui; ʻofa ke mau ʻilo ʻae ʻofa ʻi he ʻao ʻo homauʻeiki, pea mau nofo ko e kau tamaioʻeiki kia Felo. ");
INSERT INTO ton_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Pea naʻe fokotuʻu ia ʻe Siosefa ko e fono ki he fonua kotoa pē ʻo ʻIsipite ʻo aʻu ki he ʻaho ni, koeʻuhi ke maʻu ʻe Felo hono vahe nima; ka naʻe ʻikai pehē ki he fonua ʻoe kau taulaʻeiki ʻaia naʻe ʻikai maʻu ʻe Felo.” ");
INSERT INTO ton_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","¶ Pea naʻe nofo ʻa ʻIsileli ʻi ʻIsipite, ʻi he fonua ko Koseni; pea naʻa nau maʻu ʻae ngaahi fonua, pea naʻa nau tupu ʻo tokolahi ʻaupito. ");
INSERT INTO ton_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Pea naʻe moʻui ʻa Sēkope ʻi he fonua ko ʻIsipite ʻi he taʻu ʻe hongofulu ma fitu; pea ko e taʻu kotoa pē ʻo Sēkope, ko e taʻu ʻe teau mo e taʻu ʻe fāngofulu ma fitu. ");
INSERT INTO ton_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Pea naʻe ofi ʻae ʻaho ke pekia ai ʻa ʻIsileli; pea ui ia ke haʻu hono foha ko Siosefa, ʻo ne pehē kiate ia, “Ko eni, kapau kuo u maʻu ʻae ʻofa ʻi ho ʻao, pea ke ʻai ho nima ʻi hoku lalo tenga, mo ke fai angalelei mo moʻoni kiate au; ʻoku ou kole kiate koe, ʻoua naʻa ke tanu au ʻi ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ka te u tokoto au mo ʻeku ngaahi tamai, pea te ke fata au mei ʻIsipite, ʻo tanu au ʻi honau tanuʻanga.” Pea naʻe pehē ʻe ia, “Te u fai ʻo hangē ko hoʻo lea.” ");
INSERT INTO ton_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Pea naʻa ne pehē, “Fuakava mai kiate au.” Pea ne fuakava kiate ia. Pea naʻe punou ʻa ʻIsileli ki he ʻuluʻi mohenga. ");
INSERT INTO ton_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Pea hili ʻae ngaahi meʻa ni, naʻe fakahā ʻe he tokotaha kia Siosefa ʻo pehē, “Vakai, ʻoku mahaki hoʻo tamai:” pea naʻa ne ʻave mo ia ʻa hono ongo foha, ko Manase, mo ʻIfalemi. ");
INSERT INTO ton_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Pea naʻe tala kia Sēkope, ʻo pehē, “Vakai, ʻoku haʻu ho foha ko Siosefa kiate koe: pea naʻe fakamālohi ʻe ʻIsileli ia, pea ne nofo hake ʻi he mohenga.” ");
INSERT INTO ton_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Pea pehē ʻe Sēkope kia Siosefa, “Naʻe hā mai ʻae ʻOtua māfimafi kiate au ʻi Lusa ʻi he fonua ko Kēnani, ʻo ne tāpuaki au; ");
INSERT INTO ton_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‌ʻo ne pehē mai kiate au, ‘Vakai, te u ngaohi koe ke ke monūʻia, mo ke tupu ʻo tokolahi, pea te u fakatupu ʻiate koe ʻae ngaahi kakai lahi; pea te u foaki ʻae fonua ni ki ho hako ki mui ʻiate koe, ko e nofoʻanga maʻu ʻo taʻengata.’” ");
INSERT INTO ton_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","¶ “Pea ko eni, ko ho ongo foha ko ʻIfalemi, mo Manase, naʻe fānau kiate koe ʻi he fonua ko ʻIsipite, ʻi he teʻeki ai te u haʻu ki ʻIsipite, ʻoku ʻoʻoku ʻakinaua; ʻo hangē ko Lupeni mo Simione, ʻe ʻoʻoku ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pea ko hoʻo fānau te ke fakatupu kimui ʻiate kinaua, ʻe ʻoʻou ia, pea ʻe ui ʻakinautolu ʻi he hingoa ʻo honau kāinga ʻi honau tofiʻa. ");
INSERT INTO ton_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pea ko au, ʻi heʻeku haʻu mei Petana, naʻe pekia ʻa Lesieli ʻo ofi kiate au ʻi he hala, ka naʻe toetoe siʻi pe, pea mau hoko ki ʻEfelata pea naʻaku tanu ia ʻi he hala ki ʻEfelata ʻaia ko Petelihema.” ");
INSERT INTO ton_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Pea naʻe sio ʻa ʻIsileli ki he ongo foha ʻo Siosefa, ʻo ne pehē, “Ko hai ʻakinaua?” ");
INSERT INTO ton_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Pea pehēange ʻe Siosefa ki heʻene tamai, “Ko hoku ongo foha ʻakinaua, kuo foaki ʻe he ʻOtua kiate au, ʻi he fonua ni.” Pea pehē ʻe ia, “ʻOku ou kole kiate koe, ʻomi ʻakinaua kiate au, pea te u tāpuaki ʻakinaua.” ");
INSERT INTO ton_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Pea naʻe kui ʻae mata ʻo ʻIsileli ko e meʻa ʻi heʻene motuʻa, ko ia naʻe ʻikai ai te ne faʻa sio. Pea ne ʻomi ʻakinaua ʻo ofi kiate ia; pea naʻa ne ʻuma kiate kinaua ʻo ne fāʻufua ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Pea naʻe pehē ʻe ʻIsileli kia Siosefa, “Naʻe ʻikai te u ʻamanaki ke u mamata ki ho mata; pea vakai, kuo fakahā ʻe he ʻOtua kiate au ho hako foki.” ");
INSERT INTO ton_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Pea naʻe ʻomi ʻakinaua ʻe Siosefa mei hono tui, pea ne tulolo ia mo hono mata ki he kelekele. ");
INSERT INTO ton_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Pea ʻave ʻakinaua ʻe Siosefa, ko ʻIfalemi ʻi hono nima toʻomataʻu ʻo hanga atu ki he nima toʻohema ʻo ʻIsileli, mo Manase ʻi hono toʻohema ʻo hanga atu ki he nima toʻomataʻu ʻo ʻIsileli, pea ne ʻomi ʻakinaua ke ofi kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pea naʻe mafao atu ʻe ʻIsileli hono nima toʻomataʻu ʻo hilifaki ia ki he ʻulu ʻo ʻIfalemi, ʻaia ko e kimui, mo hono nima toʻohema ki he ʻulu ʻo Manase, ʻo ʻai fakapotopoto pe hono nima; he ko Manase, ko e ʻuluaki ia. ");
INSERT INTO ton_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","¶ Pea naʻa ne tāpuaki ʻa Siosefa ʻo ne pehē, “Ko e ʻOtua, ʻaia naʻe ʻalu ʻi he ʻao ʻo ʻeku tamai ko ʻEpalahame, mo ʻAisake, ko e ʻOtua naʻa ne fafanga au ʻi heʻeku moʻui kotoa pē ʻo aʻu ki he ʻaho ni, ");
INSERT INTO ton_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ko e ʻāngelo ʻaia naʻa ne huhuʻi au mei he kovi kotoa pē, tāpuakiʻi ʻae ongo tama; pea ke ui hoku hingoa kiate kinaua, mo e hingoa ʻo ʻeku tamai ko ʻEpalahame, mo ʻAisake; pea tuku ke na tupu ko e kakai tokolahi ʻi māmani.” ");
INSERT INTO ton_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pea kuo mamata ʻa Siosefa kuo ʻai ʻe heʻene tamai hono nima toʻomataʻu ki he ʻulu ʻo ʻIfalemi, naʻa ne mamahi ai; pea ne hiki ʻae nima ʻo ʻene tamai ke ʻave ia mei he ʻulu ʻo ʻIfalemi ki he ʻulu ʻo Manase. ");
INSERT INTO ton_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Pea pehē ʻe Siosefa ki heʻene tamai, “Ko ʻeku tamai ke ʻoua naʻa pehē, he ko e ʻuluaki eni: ʻai ho nima toʻomataʻu ki hono ʻulu.” ");
INSERT INTO ton_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pea naʻe taʻofi ia ʻe heʻene tamai, ʻo ne pehē, “ʻOku ou ʻilo, ko hoku foha, ʻoku ou ʻilo ia: ʻe hoko ia foki ko e kakai tokolahi, pea ʻe lahi ia foki; ka ko e moʻoni ʻe lahi hono tehina ʻiate ia, pea ʻe hoko hono hako ko e ngaahi puleʻanga lahi.” ");
INSERT INTO ton_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Pea naʻa ne tāpuaki ʻakinaua ʻi he ʻaho ko ia, ʻo pehē, “ʻE fai tāpuaki ʻe ʻIsileli ʻiate koe, ʻo pehē, ‘Ke ngaohi koe ʻe he ʻOtua ke tatau mo ʻIfalemi mo Manase:’ pea naʻa ne tuku ʻa ʻIfalemi ki muʻa ʻia Manase. ");
INSERT INTO ton_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Pea pehē ʻe ʻIsileli kia Siosefa, “Vakai teu mate au; ka ʻe ʻiate kimoutolu ʻae ʻOtua, pea te ne toe ʻave ʻakinautolu ki he fonua ʻo hoʻomou ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Pea ko eni foki, kuo u foaki kiate koe ʻae potu lahi hake ʻe taha ʻi ho ngaahi tokoua, ʻaia naʻaku maʻu mei he nima ʻoe kakai ʻAmoli, ʻaki ʻa ʻeku heletā, mo ʻeku kaufana.” ");
INSERT INTO ton_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Pea naʻe fekau ʻe Sēkope ki hono ngaahi foha, ʻo pehē, “Mou fakataha mai, koeʻuhi ke u fakahā kiate kimoutolu ʻaia ʻe hoko kiate kimoutolu ʻi he ngaahi ʻaho ʻamui. ");
INSERT INTO ton_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ʻAe ngaahi foha ʻo Sēkope, mou fakakātoa ʻakinautolu ʻo fanongo: pea fakafanongo kia ʻIsileli ko hoʻomou tamai. ");
INSERT INTO ton_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ko Lupeni, ko hoku ʻuluaki koe, ko hoku mālohi, mo e kamataʻanga ʻo hoku mālohi, ko e lelei mo e ngalingali ʻeiki, mo e fungani ʻoe mālohi. ");
INSERT INTO ton_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","‌ʻOku ke ngaueue koe ʻo hangē ko e vai, pea ʻe ʻikai te ke hoko ʻo lelei; koeʻuhi naʻa ke ʻalu ki he mohenga ʻo hoʻo tamai; pea naʻa ke fakaʻuliʻi ia: naʻa ke ʻalu ki hoku tokotoʻanga. ");
INSERT INTO ton_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Ko Simione mo Livai ko e ongo tokoua; ʻoku ʻi heʻena fakakaukau ʻae ngaahi meʻa tautea fakamamahi. ");
INSERT INTO ton_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ko hoku laumālie, ʻoua naʻa ke fie kau ki heʻena fakalilolilo; ko hoku ongoongolelei, ʻoua naʻa ke kau mo hona fakataha, he naʻa na tāmateʻi ʻae tangata ʻi heʻena ʻita, pea ʻi hona loto lahi, naʻa na holoki hifo ʻae ʻā maka. ");
INSERT INTO ton_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Malaʻia ki heʻena ʻita, he naʻe kakaha ia: mo ʻena lili he naʻe taʻeʻofa ia: te u tufa ʻakinaua ʻi Sēkope, mo veteki ʻakinaua ʻi ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Ko koe Siuta, ʻe fakamālō ki ai ʻa ho ngaahi tokoua; ʻe ʻi he kia ʻo ho ngaahi fili ʻa ho nima; ʻe punou kiate koe ʻae ngaahi fānau ʻa hoʻo tamai. ");
INSERT INTO ton_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ko e ʻuhiki laione ʻa Siuta: ko hoku foha kuo ke ʻalu hake mei he tamatea: naʻa ne tulolo, ʻo tokoto ʻo hangē ko e laione, pea hangē ko e laione motuʻa; pea ko hai te ne ueʻi hake ia? ");
INSERT INTO ton_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","E ʻikai mole ʻae tokotoko ʻoe pule ia Siuta, pe ha taha ke foaki ʻae fono mei hono vaʻe, kaeʻoua ke hāʻele mai ʻa Sailo; pea ʻe ʻiate ia ʻae tānaki fakataha ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Te ne noʻotaki ʻene ʻuhiki ki he vaine, mo ʻene ʻuhiki ʻasi ki he vaine mātuʻaki lelei; te ne fō hono ngaahi kofu ʻi he uaine, mo hono ngaahi kofu ʻi he toto ʻoe kālepi. ");
INSERT INTO ton_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","E kulokula hono mata ʻi he uaine, pea ʻe hinehina hono nifo ʻi he huʻahuhu. ");
INSERT INTO ton_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“E nofo ʻa Sepuloni ʻi he taulanga ki tahi; pea ko e taulanga ia ki he ngaahi vaka: pea ʻe aʻu atu ʻa hono ngataʻanga ki Saitoni. ");
INSERT INTO ton_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Ko e ʻasi mālohi ʻa ʻIsaka, ʻoku tokoto ia ʻi he tauloto ʻoe kavenga ʻe ua. ");
INSERT INTO ton_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Pea ʻe pehē ʻe ia ʻoku lelei ʻae fiemālie, pea ʻoku mata lelei ʻae fonua; pea ʻe fakapunou hifo hono uma ke haʻamo, pea ʻe hoko ia ko e tamaioʻeiki ki he tukuhau. ");
INSERT INTO ton_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“E fakamaau hono kakai ʻe Tani, ʻo hangē ko e tokotaha ʻae faʻahinga ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ko e ngata fekai ʻa Tani ʻi he veʻehala, ko e ngata ia ʻi he hala, ʻoku ne uʻu ʻae mui vaʻe ʻoe hoosi, ko ia ʻe hinga ki mui ai ʻae tangata heka hoosi. ");
INSERT INTO ton_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Kuo u tatali ki hoʻo fakamoʻui ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Ko Kata, ʻe lavaʻi ia ʻe ha kongakau, ka te ne toki ikuna ʻamui. ");
INSERT INTO ton_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“E tupu ia ʻAseli ʻae mā lelei, pea ʻe tupu ʻiate ia ʻae ngaahi meʻakai fakaʻeiʻeiki. ");
INSERT INTO ton_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Ko e hainiti ʻa Nafitali kuo vete ange: ʻoku ne lea ʻaki ʻae ngaahi lea lelei. ");
INSERT INTO ton_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Ko e vaʻa fua lahi ʻa Siosefa, ʻio, ko e vaʻa fua ia ʻoku ofi ki he vai; ʻoku kaka hake hono ngaahi vaʻa ʻi he funga ʻā. ");
INSERT INTO ton_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kuo fakamamahi lahi ia ʻe he kau tangata fana, ʻo nau fanaʻi ia, mo fehiʻa kiate ia: ");
INSERT INTO ton_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ka naʻe tuʻumaʻu ʻene kaufana ʻi he mālohi, pea naʻe fakamālohi ʻae kupuʻi nima ʻo hono nima, ʻe he nima ʻoe Māfimafi ʻo Sēkope. ʻOku mei ai ʻae Tauhi, ko e Maka ʻo ʻIsileli: ");
INSERT INTO ton_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","‌ʻIo, mei he ʻOtua ʻo hoʻo tamai, ʻaia te ne tokoniʻi koe; pea ʻi he Māfimafi, ʻaia te ne tāpuaki koe ʻaki ʻae ngaahi tāpuaki ʻoe langi mei ʻolunga, mo e ngaahi tāpuaki ʻoe loloto ʻoku ʻi lalo, mo e tāpuaki ʻoe ngaahi huhu, pea mo e manāva: ");
INSERT INTO ton_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ko e ngaahi tāpuaki ʻa hoʻo tamai kuo māhilihili ia ki ʻolunga ʻi he ngaahi tāpuaki ʻa hoʻo ngaahi kui, ʻo aʻu ki he mātuʻaki ngataʻanga mamaʻo ʻoe ngaahi moʻunga taʻengata; te nau ʻi he ʻulu ʻo Siosefa, pea ki he tumuʻaki ʻoe ʻulu ʻo ia naʻe vaheʻi mei hono ngaahi tokoua. ");
INSERT INTO ton_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“E ʻuakai ʻa Penisimani ʻo hangē ko e ulofi: te ne kai ʻi he pongipongi ʻaia kuo ne maʻu, pea te ne tufa ʻi he pō ʻae koloa kuo vete.” ");
INSERT INTO ton_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","¶ Ko e ngaahi faʻahinga ʻe hongofulu ma ua eni ʻo ʻIsileli; pea ko eni ia naʻe lea ʻaki ʻe heʻenau tamai kiate kinautolu, ʻo ne tāpuaki ʻaki ʻakinautolu; naʻa ne tāpuaki ʻakinautolu taki taha, ʻo fakatatau ki hono tāpuaki ʻoʻona. ");
INSERT INTO ton_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Pea fonosia ia kiate kinautolu, ʻo ne pehē: “E tānaki au ki hoku kakai ka mou tanu au mo ʻeku ngaahi tamai ʻi he ʻana ʻoku ʻi he ngoue ʻa ʻEfilone ʻoe faʻahinga ʻo Heti. ");
INSERT INTO ton_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","‌ʻI he ʻana ʻoku ʻi he ngoue ʻi Makipila, ʻaia ʻoku hanga atu ki Mamili, ʻi he fonua ko Kēnani, ʻaia naʻe fakatau ʻe ʻEpalahame, mo e ngoue ʻa ʻEfilone ʻoe kau Heti, ko e potu maʻana ko e tanuʻanga. ");
INSERT INTO ton_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Naʻa nau tanu ʻi ai ʻa ʻEpalahame mo hono uaifi ko Sela; pea naʻa nau tanu ʻi ai ʻa ʻAisake mo hono uaifi ko Lepeka pea naʻaku tanu ʻi ai ʻa Lia. ");
INSERT INTO ton_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Naʻe fakatau ʻae ngoue mo e ʻana ʻoku ʻi ai, mei he fānau ʻa Heti.” ");
INSERT INTO ton_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Pea kuo fakaʻosi ʻe Sēkope ʻene fekau ki hono ngaahi foha, pea naʻa ne hamusi hake hono vaʻe ʻi he mohenga, pea tukuange ʻe ia hono laumālie, pea naʻe tānaki ia ki hono kakai. ");
INSERT INTO ton_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Pea tōmapeʻe ʻa Siosefa ki he mata ʻo ʻene tamai, ʻo tangi kiate ia, mo uma kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Pea fekau ʻe Siosefa ki heʻene kau tangata faitoʻo, ke nau fakatolongaʻi ʻene tamai; pea naʻe fakatolonga ʻa ʻIsileli ʻe he kau faitoʻo. ");
INSERT INTO ton_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Pea naʻe fai ʻae ʻaho ʻe fāngofulu koeʻuhi ko ia; he ko hono ngaahi ʻaho ia kiate kinautolu ʻoku fakatolongaʻi; pea naʻe tangi ʻae kakai ʻIsipite ʻi he ʻaho ʻe fitungofulu koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Pea ʻi he hili ʻae ngaahi ʻaho fakamamahi, naʻe lea ʻa Siosefa ki he fale ʻo Felo, ʻo pehē, “Ko eni, kapau kuo u lelei ʻi homou ʻao, ʻoku ou kole kiate kimoutolu ke mou lea ʻi he ʻao ʻo Felo, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Naʻe puleʻi au ʻe heʻeku tamai ke u fuakava, ʻo pehē, Vakai, teu mate: pea te ke tanu au ʻi he faʻitoka naʻaku ngaohi maʻaku ʻi he fonua ko Kēnani. Pea ko eni ʻoku ou kole kiate koe, tuku ke u ʻalu ʻo tanu ʻeku tamai, pea te u toe haʻu.” ");
INSERT INTO ton_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pea naʻe pehē ʻe Felo, “Ke ke ʻalu ʻo tanu hoʻo tamai, ʻo hangē ko e fuakava naʻa ne fekau ke ke fai.” ");
INSERT INTO ton_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","¶ Pea naʻe ʻalu ʻa Siosefa ke tanu ʻene tamai; pea naʻe ʻalu mo ia ʻae kau matāpule kotoa pē ʻa Felo, mo e kau mātuʻa ʻo hono fale, mo e kau mātuʻa ʻo ʻIsipite, ");
INSERT INTO ton_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Pea mo e fale kotoa pē ʻo Siosefa, mo hono ngaahi tokoua, mo e fale ʻo ʻene tamai; ko e nau tamaiki, mo e nau fanga manu, mo e nau fanga sipi, naʻa nau tuku pe ʻi he fonua ko Koseni. ");
INSERT INTO ton_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Pea naʻe ʻalu mo ia ʻae ngaahi saliote, mo e kau tangata heka hoosi; ko e kakai tokolahi ʻaupito. ");
INSERT INTO ton_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Pea naʻa nau hoko ki he hahaʻanga uite ʻi ʻEtati, ʻaia ʻoku ʻituʻa Sioatani, pea nau tangi ai ʻi he tangi lahi mo fakamamahi: pea naʻa ne fai ʻae tangi ki heʻene tamai ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Pea kuo mamata ʻe he kakai ʻoe fonua, ʻaia ko e kakai Kēnani, ki he tangi ʻi he potu ʻi ʻEtati, pea nau lea ʻo pehē, “Ko e tangi fakamamahi eni, ki he kakai ʻIsipite;” ko ia naʻe ui ai hono hingoa ʻo ia ko ʻEpelimisilemi, ʻaia ʻoku ʻituʻa Sioatani. ");
INSERT INTO ton_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Pea naʻe fai ʻe hono ngaahi foha kiate ia, ʻo hangē ko ʻene fekau. ");
INSERT INTO ton_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","He naʻe fata ia ʻe hono ngaahi foha ki he fonua ko Kēnani, ʻo nau tanu ia ʻi he ʻana ʻi he ngoue ko Makipila ʻoku hanga ki Mamili, ʻaia naʻe fakatau maʻana ʻe ʻEpalahame, mo e ngoue ko e tanuʻanga, meia ʻEfilone ʻoe faʻahinga ʻo Heti. ");
INSERT INTO ton_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pea naʻe toe liu mai ʻa Siosefa ki ʻIsipite, hili ʻae tanu ʻo ʻene tamai, ʻaia mo hono ngaahi tokoua, mo kinautolu kotoa pē naʻe ʻalu mo ia ke tanu ʻene tamai. ");
INSERT INTO ton_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","¶ Pea kuo mamata ʻe he ngaahi tokoua ʻo Siosefa, kuo pekia ʻa ʻenau tamai, naʻa nau pehē, “E fehiʻa nai ʻa Siosefa kiate kitautolu, mo totongi kiate kitautolu ʻae kovi kotoa pē naʻa tau fai kiate ia.” ");
INSERT INTO ton_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Pea naʻa nau fekau ʻae tokotaha ke ʻalu kia Siosefa ʻo lea pehē, naʻe fekau ʻe hoʻo tamai ʻi heʻene kei moʻui, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Te mou lea pehē kia Siosefa, ‘ʻOku ou kole ni kiate koe, fakamolemole ʻae kovi ʻa ho ngaahi tokoua mo ʻenau fai hala;’ he naʻa nau fai kovi kiate koe: pea ko eni, ʻoku mau kole kiate koe, fakamolemole ʻae hia ʻae kau tamaioʻeiki ʻae ʻOtua ʻo hoʻo tamai.” Pea naʻe tangi ʻa Siosefa ʻi heʻenau lea kiate ia. ");
INSERT INTO ton_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Pea ʻalu hono ngaahi tokoua ʻo foʻohifo ʻi hono ʻao; ʻo nau lea pehē, “Vakai mai, ko hoʻo kau tamaioʻeiki ʻakimautolu.” ");
INSERT INTO ton_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pea pehēange ʻe Siosefa kiate kinautolu, “ʻOua te mou manavahē; he ko e fetongi au ʻoe ʻOtua? ");
INSERT INTO ton_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ka ko kimoutolu, naʻa mou mahalo kovi kiate au, ka naʻe puleʻi ia ʻe he ʻOtua ke lelei, koeʻuhi ke fakahoko ʻaia ʻoku fai he ʻaho ni, ke fakahaofi ʻae moʻui ʻae kakai tokolahi. ");
INSERT INTO ton_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pea ko eni, ke ʻoua naʻa mou manavahē; he te u tauhi ʻakinautolu mo hoʻomou tamaiki.” Pea naʻa ne fakafiemālieʻi ʻakinautolu, ʻo lea ʻofa kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","¶ Pea naʻe nofo ʻa Siosefa ʻi ʻIsipite, ʻa ia, mo e fale ʻo ʻene tamai; pea ko e moʻui ʻa Siosefa ko e taʻu ʻe teau, mo e taʻu ʻe hongofulu. ");
INSERT INTO ton_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Pea naʻe mamata ʻa Siosefa ki he fānau ʻa ʻIfalemi, ko e toʻutangata ʻe tolu ko e fānau foki ʻa Mekili ko e foha ʻo Manase, naʻe ʻomi ʻo tuku ki he funga tui ʻo Siosefa. ");
INSERT INTO ton_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Pea naʻe pehē ʻe Siosefa ki hono ngaahi tokoua, “Teu mate au; pea ko e moʻoni ʻe ʻaʻahi ʻae ʻOtua kiate kimoutolu, ʻo ʻave ʻakimoutolu mei he fonua ni, ki he fonua naʻa ne fuakava ki ai kia ʻEpalahame, mo ʻAisake, pea mo Sēkope.” ");
INSERT INTO ton_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Pea naʻe fai kia Siosefa ʻae fuakava ʻe he fānau ʻa ʻIsileli, ʻo pehē, “Ko e moʻoni ʻe ʻaʻahi ʻae ʻOtua kiate kimoutolu, pea te mou fetuku hoku ngaahi hui mei heni.” ");
INSERT INTO ton_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Pea naʻe pekia ai ʻa Siosefa, kuo teau taʻu, mo e taʻu ʻe hongofulu hono motuʻa: pea naʻa nau fakatolongaʻi ia, pea nau ai ia ki he puha ʻi ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Pea ko e ngaahi hingoa eni ʻoe fānau ʻa ʻIsileli, naʻe haʻu ki ʻIsipite; ʻae tangata kotoa pē mo ʻene kau nofoʻanga naʻe haʻu mo Sēkope. ");
INSERT INTO ton_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ko Lupeni mo Simione, mo Livai, mo Siuta, ");
INSERT INTO ton_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Mo ʻIsaka, mo Sepuloni, mo Penisimani, ");
INSERT INTO ton_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Mo Tani, mo Nafitali, mo Kata, mo ʻAseli. ");
INSERT INTO ton_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Pea ko e fānau kotoa pē naʻe tupu ʻia Sēkope, ko e laumālie ʻe toko fitungofulu: he naʻe ʻi ʻIsipite ʻa Siosefa. ");
INSERT INTO ton_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Pea naʻe pekia ʻa Siosefa, mo hono kāinga kotoa pē, mo e toʻutangata kotoa pē ko ia. ");
INSERT INTO ton_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","¶ Pea naʻe fanafanau ʻae fānau ʻa ʻIsileli, ʻo tupu pe ʻo tokolahi ʻaupito, ʻonau hoko ʻo mālohi ʻaupito: pea naʻe fonu ʻae fonua ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Pea naʻe toki hoko ʻae tuʻi foʻou ke pule ki ʻIsipite, ʻaia naʻe ʻikai te ne ʻilo ʻa Siosefa. ");
INSERT INTO ton_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Pea pehē ʻe ia ki hono kakai, “Vakai, ko e kakai ʻae fānau ʻa ʻIsileli, ʻoku tokolahi hake, pea ʻoku mālohi ʻiate kitautolu: ");
INSERT INTO ton_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ko eni, ke tau fai fakapotopoto kiate kinautolu; telia naʻa nau tupu ʻo tokolahi, pea ʻe hoko ʻo pehē, ʻoka hoko ha tau, tenau kau mo hotau fili, ʻo tauʻi ʻakitautolu, pea ʻe hiki ai ʻakinautolu mei he fonua.” ");
INSERT INTO ton_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ko ia naʻa nau fakanofo ai ʻae kau enginaki ngāue ke fakamamahi ʻaki ʻakinautolu ʻa ʻenau ngaahi kavenga. Pea naʻa nau ngaohi ʻae kolo tukungakoloa ʻe ua moʻo Felo; ko Pitomi, mo Lamisisi. ");
INSERT INTO ton_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ka neongo ʻae ʻāsili fakamamahi ʻakinautolu, naʻa nau tupu pe ʻo fuʻu tokolahi hake. Pea naʻe mamahi ʻakinautolu koeʻuhi ko e fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Pea naʻe houtonga ʻae fānau ʻa ʻIsileli ʻe he kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","‌ʻO nau fakamamahiʻi ʻenau moʻui ʻi he ngāue pōpula ki he kelepulu, mo e makaʻumea, mo e ngāue kehekehe ʻi he ngoue: ko e ngāue kotoa pē ʻaia naʻa nau pule kenau fai, naʻe fakamamahi. ");
INSERT INTO ton_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","¶ Pea naʻe fekau ʻe he tuʻi ʻo ʻIsipite ki he kau māʻuli ʻoe kakai Hepelū, ko e hingoa ʻoe tokotaha ko Sifila, mo e hingoa ʻoe tokotaha ko Piua: ");
INSERT INTO ton_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","‌ʻO ne pehē, “ʻOka mo ka fai ʻae ngāue ʻae māʻuli ki he kau fefine Hepelū, ʻo mamata ki heʻenau fāʻele; kapau ko e tama tangata, te mo tāmateʻi ia: pea kapau ko e taʻahine, pea ʻe moʻui ia.” ");
INSERT INTO ton_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ka naʻe manavahē ʻae ongo māʻuli ki he ʻOtua, pea naʻe ʻikai te na fai ʻo hangē ko e fekau ʻae tuʻi ʻo ʻIsipite kiate kinaua, ka naʻa na fakamoʻui ʻae fānau tangata. ");
INSERT INTO ton_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Pea fekau ʻe he tuʻi ʻo ʻIsipite ke haʻu ʻae ongo māʻuli, ʻo ne pehē kiate kinaua, “Ko e hā kuo mo fai ai ʻae meʻa ni, pea kuo mo fakamoʻui ʻae fānau tangata?” ");
INSERT INTO ton_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Pea talaange ʻe he ongo māʻuli kia Felo, “Koeʻuhi ʻoku ʻikai tatau ʻae kau fefine Hepelū mo e kau fefine ʻIsipite; he ʻoku nau mālohi, pea ʻoku nau fāʻeleʻi ʻi he teʻeki ai hoko atu ʻae kau māʻuli kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Ko ia naʻe fai lelei ʻe he ʻOtua ki he ongo māʻuli: pea naʻe tupu pe ʻae kakai, ʻo fakaʻaʻau ʻo mālohi lahi. ");
INSERT INTO ton_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Pea ko e meʻa ʻi he manavahē ʻae kau māʻuli ki he ʻOtua, ko ia naʻa ne fakatupu ai hona fale. ");
INSERT INTO ton_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Pea naʻe fekau ʻe Felo ki hono kakai kotoa pē, ʻo pehē, “Ko e fānau tangata kotoa pē ʻoku fāʻeleʻi te mou lī ia ki he vaitafe, pea ko e fānau fefine kotoa pē te mou fakamoʻui.” ");
INSERT INTO ton_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Pea naʻe ʻalu ha tangata ʻoe faʻahinga ʻo Livai, ʻo na mali mo ha ʻofefine ʻo Livai. ");
INSERT INTO ton_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Pea naʻe feitama ʻae fefine, ʻo ne fāʻeleʻi ʻae tama: pea ʻi heʻene mamata ki hono fakaʻofoʻofa, naʻa ne fufū ia ʻi he māhina ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pea ʻi he ʻikai te ne kei faʻa fufū ia, naʻa ne ngaohi ha vaka louʻakau, ʻo ne pani ia ʻaki ʻae kelepulu, mo e pulu, ʻo ne ʻai ʻae tamasiʻi ki loto; pea ne tuku ia ʻi he potu ʻakau ʻi he veʻe vaitafe. ");
INSERT INTO ton_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Pea naʻe tuʻu mamaʻo atu hono tuofefine, ke vakai pe ko e hā ʻe fai kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Mo ʻene ʻalu hifo ʻae ʻofefine ʻo Felo ki he vaitafe ke pālutu; pea naʻe ʻeveʻeva hono kau fefine ʻi he veʻe vaitafe; pea ʻi heʻene mamata ki he vaka ʻi he potu ʻakau, naʻa ne fekau ʻene fefine fekau ke ʻalu ʻo ʻomi ia. ");
INSERT INTO ton_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Pea ʻi heʻene toʻo hono tāpuni, pea mamata ia ki he tamasiʻi, pea vakai, naʻe tangi ʻae tamasiʻi. Pea ʻofa leva ia kiate ia, ʻo ne pehē, “Ko e tamasiʻi eni ʻae kau Hepelū.” ");
INSERT INTO ton_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Pea pehē leva ʻe hono tuofefine ki he ʻofefine ʻo Felo, “ʻE lelei kiate koe ʻeku ʻalu ʻo ui ha fefine toutama mei he kau Hepelū, koeʻuhi ke ne tauhi ʻae tamasiʻi maʻau? ");
INSERT INTO ton_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Pea talaange ʻe he ʻofefine ʻo Felo kiate ia, “ʻAlu.” Pea naʻe ʻalu ʻae taʻahine ʻo ne ui ʻae faʻē ʻae tamasiʻi. ");
INSERT INTO ton_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Pea pehēange ʻe he ʻofefine ʻo Felo kiate ia, “Toʻo ʻae tamasiʻi ni ʻo ʻave, mo ke tauhi ia maʻaku, pea te u totongi koe. Pea naʻe ʻave ʻe he fefine ʻae tamasiʻi, ʻo ne tauhi ki ai. ");
INSERT INTO ton_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Pea naʻe tupu ʻae tamasiʻi, pea naʻe ʻomi ia ki he ʻofefine ʻo Felo, pea hoko ia ko ʻene tama. Pea naʻa ne ui hono hingoa ko Mōsese: He naʻa ne pehē, “Ko e meʻa ʻi heʻeku ʻohake ia mei he vai.” ");
INSERT INTO ton_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","¶ Pea ʻi he ngaahi ʻaho ko ia kuo tupu ʻo lahi ai ʻa Mōsese, naʻe ʻeveʻeva ia kituaʻā ki hono ngaahi kāinga, ʻo ne mamata ki heʻenau ngaahi kavenga: pea naʻa ne sio ki he tangata ʻIsipite ʻoku ne taaʻi ʻae Hepelū, ko e tokotaha ʻi hono kāinga. ");
INSERT INTO ton_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Pea fekilokilofaki ia, pea ʻi heʻene sio ʻoku ʻikai ha tangata, naʻa ne tāmateʻi ʻae tangata ʻIsipite, ʻo ne fufū ia ʻi he ʻoneʻone. ");
INSERT INTO ton_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Pea ʻi heʻene ʻalu kituaʻā ʻi hono ua ʻoe ʻaho, vakai, naʻe fekeeʻi ʻae ongo tangata Hepelū: pea lea ia kiate ia naʻe fai kovi, “Ko e hā ʻoku ke taaʻi ai ho kāinga?” ");
INSERT INTO ton_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Pea pehē mai ʻe ia, “Ko hai naʻa ne ngaohi koe ko e ʻeiki mo e fakamaau kiate kimautolu? ʻOku ke fie tāmateʻi au, ʻo hangē ko hoʻo tāmateʻi ʻae tangata ʻIsipite?” Pea naʻe manavahē ʻa Mōsese, ʻo ne pehē, “Ta kuo ʻilo ʻae meʻa ni.” ");
INSERT INTO ton_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pea ʻi he fanongo ʻa Felo ki he meʻa ni, naʻe holi ia ke tāmateʻi ʻa Mōsese. Ka naʻe hola ʻa Mōsese mei he ʻao ʻo Felo, pea naʻe ʻalu ia ʻo nofo ʻi he fonua ko Mitiane, pea nofo ia ki lalo ʻi he veʻe vaikeli. ");
INSERT INTO ton_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Pea ko e taulaʻeiki ʻo Mitiane naʻe toko fitu hono ʻofefine: pea naʻa nau haʻu ke utu ʻae vai, ʻo fakapito ʻae ngaahi ʻaiʻanga vai ke fakainu ʻae fanga manu ʻa ʻenau tamai. ");
INSERT INTO ton_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pea naʻe haʻu ʻae kau tangata tauhi sipi ʻo tekeʻi atu ʻakinautolu: ka naʻe tuʻu hake ʻa Mōsese ʻo ne tokoni ʻakinautolu, ʻo ne fakainu ʻenau fanga manu. ");
INSERT INTO ton_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Pea ʻi heʻenau aʻu atu kia Liueli ko e nau tamai, naʻe pehē ʻe ia, “Ko e hā kuo mou haʻu vave ai he ʻaho ni?” ");
INSERT INTO ton_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Pea naʻa nau pehē, “Ko e tangata ʻIsipite naʻa ne fakahaofi ʻakimautolu mei he nima ʻoe kau tauhi sipi, ʻo ne utu foki ʻae vai lahi kiate kimautolu, ʻo ne fakainu ʻae fanga manu.” ");
INSERT INTO ton_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Pea pehē ʻe ia ki hono ngaahi ʻofefine, “Pea kuo ʻi fē ia? Ko e hā kuo mou tuku ai pe ʻae tangata? Ui ia, ke haʻu ʻo kai mā.” ");
INSERT INTO ton_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Pea naʻe loto lelei ʻa Mōsese ke nofo mo e tangata: pea naʻa ne foaki hono ʻofefine ko Sipola kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Pea ne fanauʻi kiate ia ʻae tama, pea naʻa ne ui hono hingoa ko Kesomi; he naʻa ne pehē, “Ko e muli au ʻi he fonua foʻou.” ");
INSERT INTO ton_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","¶ Pea kuo fuoloa ange naʻe hoko ʻae pekia ʻae tuʻi ʻo ʻIsipite: pea naʻe toʻe ʻae fānau ʻa ʻIsileli, ko e meʻa ʻi honau fakapōpulaʻi, pea naʻa nau tangi, pea naʻe aʻu hake ʻenau tangi ki he ʻOtua ko e meʻa ʻi he fakapōpulaʻi. ");
INSERT INTO ton_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Pea naʻe ongoʻi ʻe he ʻOtua ʻenau ngaahi toʻe, pea manatuʻi ʻe he ʻOtua ʻene fuakava kia ʻEpalahame, mo ʻAisake, pea mo Sēkope. ");
INSERT INTO ton_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Pea naʻe ʻafio ʻae ʻOtua ki he fānau ʻa ʻIsileli, pea naʻe tokanga ʻofa ʻae ʻOtua kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Pea ko eni, naʻe tauhi ʻe Mōsese ʻae fanga manu ʻa ʻene tamai ʻi he fono ko Setelo, ko e taulaʻeiki ʻo Mitiane: pea naʻa ne tataki atu ʻae fanga manu ki he tukuʻuta ʻoe toafa, ʻo aʻu ki he moʻunga ʻoe ʻOtua, ki Holepi. ");
INSERT INTO ton_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Pea naʻe hā mai ʻae ʻāngelo ʻa Sihova kiate ia ʻi he ulo afi ʻi he lotolotonga ʻoe ʻuluʻakau: pea sio ia, pea vakai, naʻe ulo ʻae ʻuluʻakau ʻi he afi, ka naʻe ʻikai ʻosi ai ʻae ʻuluʻakau. ");
INSERT INTO ton_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Pea pehē ʻe Mōsese, “Ko eni, te u afe atu ʻo mamata ki he meʻa lahi ni, pe ko e hā ʻoku ʻikai vela ai ʻae ʻuluʻakau.” ");
INSERT INTO ton_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Pea naʻe ʻafioʻi ʻe Sihova ki heʻene afe ke mamata, pea folofola ʻae ʻOtua kiate ia mei he lotolotonga ʻoe ʻuluʻakau, ʻo pehē, “Mōsese, Mōsese.” Pea pehē ʻe ia, “Ko au eni.” ");
INSERT INTO ton_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Pea pehē ʻe ia, ‘ʻOua naʻa ke ofi mai ki heni; toʻo ho topuvaʻe mei ho vaʻe, he ko e potu ʻoku ke tuʻu ai ko e kelekele tapu.” ");
INSERT INTO ton_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Pea naʻa ne pehē foki, “Ko au ko e ʻOtua ʻo hoʻo tamai, ko e ʻOtua ʻo ʻEpalahame, ko e ʻOtua ʻo ʻAisake, pea ko e ʻOtua ʻo Sēkope.” Pea naʻe fufū ʻe Mōsese hono mata; he naʻe manavahē ia ke sio atu ki he ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","¶ Pea naʻe pehē ʻe Sihova, “Ko e moʻoni kuo u mamata ki he mamahi ʻa hoku kakai, ʻaia ʻoku ʻi ʻIsipite, pea kuo u ongoʻi ʻenau tangi ko e meʻa ʻi honau kau enginaki ngāue: pea ʻoku ou ʻiloʻi ʻenau ngaahi mamahi: ");
INSERT INTO ton_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Pea kuo u ʻalu hifo ke fakamoʻui ʻakinautolu mei he nima ʻoe kakai ʻIsipite, pea ke ʻomi ʻakinautolu mei he fonua ko ia ki ha fonua lelei mo lahi, ko e fonua ʻoku mahu tāfea ʻi he huʻahuhu mo e honi; ki he fonua ʻoe kau Kēnani mo e kau Heti, mo e kau ʻAmoli, mo e kau Pelesi, mo e kau Hevi, mo e kau Sepusi. ");
INSERT INTO ton_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Pea ko eni, vakai, ko e tangi ʻae fānau ʻa ʻIsileli kuo ongo mai kiate au: pea kuo u mamata foki ki he mamahi ʻaia ʻoku fakamamahi ʻaki ʻakinautolu ʻe he kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Pea ko eni, ke ke haʻu, pea te u fekau koe kia Felo, koeʻuhi ke ke ʻomi hoku kakai ko e fānau ʻa ʻIsileli mei ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Pea pehēange ʻe Mōsese ki he ʻOtua, “Ko hai au, koeʻuhi ke u ʻalu kia Felo, pea koeʻuhi ke u ʻomi ʻae fānau ʻa ʻIsileli mei ʻIsipite?” ");
INSERT INTO ton_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Pea pehē ʻe ia, “Ko e moʻoni, Te u ʻiate koe; pea ko e fakaʻilonga eni kiate koe, kuo u fekauʻi koe: Hili haʻo ʻomi ʻae kakai mei ʻIsipite, te mou tauhi ʻae ʻOtua ʻi he moʻunga ni.” ");
INSERT INTO ton_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pea pehēange ʻe Mōsese ki he ʻOtua, “Vakai, ʻo kau ka hoko atu ki he fānau ʻa ʻIsileli, pea u pehē kiate kinautolu, ‘Ko e ʻOtua ʻo hoʻomou ngaahi tamai kuo ne fekau au kiate kimoutolu; pea te nau pehē mai kiate au, ‘Ko hai hono huafa?’ Pea ko e hā te u tala kiate kinautolu?” ");
INSERT INTO ton_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Pea pehē ʻe he ʻOtua kia Mōsese, “KO AU, KO E KO AU: pea pehē ʻe ia, Te ke lea pehē ki he fānau ʻa ʻIsileli, ‘Kuo fekau au ʻe he KO AU kiate kimoutolu.’” ");
INSERT INTO ton_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Pea toe pehē ʻe he ʻOtua kia Mōsese, “Pea ke lea ʻo pehē ki he fānau ʻa ʻIsileli, Ko Sihova ko e ʻOtua ʻo hoʻomou ngaahi tamai, ko e ʻOtua ʻo ʻEpalahame, ko e ʻOtua ʻo ʻAisake, mo e ʻOtua ʻo Sēkope, kuo ne fekau au kiate kimoutolu: ko hoku huafa eni ke taʻengata, pea ko hoku fakaʻilonga eni ki he ngaahi toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","‌ʻAlu, ʻo fakataha ʻae kau mātuʻa ʻo ʻIsileli, mo ke pehē kiate kinautolu, ‘Ko Sihova ko e ʻOtua ʻo hoʻomou ngaahi tamai, ko e ʻOtua ʻo ʻEpalahame, ʻo ʻAisake, mo Sēkope, naʻe hā mai ia kiate au, ʻo ne pehē mai, ‘Kuo u ʻaʻahi atu moʻoni kiate kimoutolu, ʻo mamata ki he meʻa ʻoku fai kiate kimoutolu ʻi ʻIsipite.’ ");
INSERT INTO ton_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Pea ne u pehē, ‘Te u ʻomi ʻakimoutolu mei he ngaahi mamahi ʻo ʻIsipite, ki he fonua ʻoe kau Kēnani, mo e kau Heti, mo e kau ʻAmoli, mo e kau Pelesi, mo e kau Hevi, mo e kau Sepusi, ki he fonua ʻoku mahu tāfea ʻi he huʻahuhu mo e honi.’ ");
INSERT INTO ton_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Pea te nau tokanga ki ho leʻo: pea te ke haʻu, ʻa koe mo e kau mātuʻa ʻo ʻIsileli ki he tuʻi ʻo ʻIsipite, pea te mou lea kiate ia, ‘Ko Sihova ko e ʻOtua ʻoe kakai Hepelū kuo haʻu kiate kimautolu: pea ko eni, ʻoku mau kole kiate koe, tuku ke mau ʻalu ʻi he fonongaʻanga ʻoe ʻaho ʻe tolu ki he toafa, koeʻuhi ke mau fai ʻae feilaulau kia Sihova ko homau ʻOtua.’ ");
INSERT INTO ton_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pea ʻoku ou ʻilo pau ʻe ʻikai fie tukuange ʻakimoutolu ʻe he tuʻi ʻo ʻIsipite ke mou ʻalu, ka ʻi he nima mālohi. ");
INSERT INTO ton_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Pea te u mafao atu hoku nima ʻo taaʻi ʻa ʻIsipite ʻaki ʻa ʻeku ngaahi meʻa mana kotoa pē, ʻaia te u fai ʻi he lotolotonga ʻo ia: pea hili ia, te ne toki tuku ke mou ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Pea te u fakaʻofeina ʻae kakai ni ʻi he ʻao ʻoe kakai ʻIsipite: pea ʻe hoko ʻo pehē, ʻoka mou ka ʻalu, ʻe ʻikai te mou ʻalu masiva. ");
INSERT INTO ton_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ka ʻe kole ʻae fefine kotoa pē ki hono kaungāʻapi, pea mo ia ʻoku ʻāunofo ʻi hono fale, ʻae ngaahi teunga siliva, mo e teunga koula, mo e ngaahi kofu: pea te mou ʻai ia ki homou ngaahi foha, pea ki homou ngaahi ʻofefine; pea te mou fakamasivaʻi ʻae kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Pea naʻe leaange ʻa Mōsese ʻo pehē, “Kae vakai, ʻe ʻikai te nau tui kiate au, pe tokanga ki hoku leʻo: he te nau pehē, naʻe ʻikai hā mai ʻa Sihova kiate koe.” ");
INSERT INTO ton_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Pea pehēange ʻe Sihova kiate ia, “Ko e hā ʻena ʻi ho nima? Pea naʻa ne pehē, Ko e tokotoko.” ");
INSERT INTO ton_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Pea pehē ʻe ia, “Si ia ki he kelekele. Pea ne si ia ki he kelekele, pea hoko leva ia ko e ngata; pea hola ʻa Mōsese mei hono ʻao.” ");
INSERT INTO ton_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Pea pehē ʻe Sihova kia Mōsese, “Mafao atu ho nima ʻo puke ia ʻi hono iku.” Pea mafao atu ʻe ia hono nima, ʻo ne puke ia, pea liliu ia ko e tokotoko ʻi hono nima. ");
INSERT INTO ton_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Koeʻuhi ke nau tui ko Sihova ko e ʻOtua ʻo ʻenau ngaahi tamai, ko e ʻOtua ʻo ʻEpalahame, ko e ʻOtua ʻo ʻAisake, mo e ʻOtua ʻo Sēkope, kuo hā mai kiate koe.” ");
INSERT INTO ton_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Pea toe pehēange ʻe Sihova kiate ia, “Ko eni, ai ho nima ki ho fatafata.” Pea naʻa ne ai hono nima ki hono fatafata: pea ʻi heʻene toʻo ia mei ai, vakai, kuo kilia hono nima pea hangē ko e ʻuha hinehina. ");
INSERT INTO ton_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Pea pehē ʻe ia, “Toe ai ho nima ki ho fatafata.” Pea ne toe ai hono nima ki hono fatafata; pea toe toʻo ia mei hono fatafata, pea vakai, kuo toe liliu ia ke hangē ko e anga ʻo hono sino. ");
INSERT INTO ton_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Pea ʻe pehē, “Kapau ʻe ʻikai te nau tui kiate koe, pe tokanga ki he leʻo ʻoe ʻuluaki fakaʻilonga, te nau tui ki he leʻo ʻoe fakaʻilonga fakamui. ");
INSERT INTO ton_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pea ʻe pehē, kapau ʻe ʻikai te nau tui foki ki he fakaʻilonga ni ʻe ua, pe tokanga ki ho leʻo, pea te ke ohu ʻae vai mei he vaitafe, ʻo lilingi ia ki he kelekele: pea ko e vai ʻoku ke ohu mei he vaitafe, ʻe liliu ia ko e toto ki he kelekele mōmoa.” ");
INSERT INTO ton_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","¶ Pea pehēange ʻe Mōsese kia Sihova, “ʻE hoku ʻEiki, ʻOku ʻikai ko e leʻo afea au talu mei muʻa, pe talu hoʻo folofola ki hoʻo tamaioʻeiki: ka ko e lea tōʻohi au, mo e ʻelelo tōʻohi.” ");
INSERT INTO ton_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pea pehēange ʻe Sihova kiate ia, “Ko hai naʻe ngaohi ʻae ngutu ʻoe tangata? Pea ko hai ʻoku ne ngaohi ʻae noa, pe ko e tuli, pe ko e mata ʻaa, pe ko e kui? ʻIkai ko au Sihova? ");
INSERT INTO ton_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Pea ko eni, ke ke ʻalu, pea ko au, teu ʻi ho ngutu, ke ako kiate ko e ʻaia te ke lea ʻaki.” ");
INSERT INTO ton_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Pea ne pehē ʻe ia, “ʻE hoku ʻEiki, ʻOku ou kole kiate koe, ke ke fekau ʻi he nima ʻo ia ʻoku ke lelei ke fekau ki ai.” ");
INSERT INTO ton_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Pea naʻe tupu ai ʻae houhau ʻo Sihova kia Mōsese, pea ne pehē, “ʻIkai ko ho taʻokete ʻa ʻElone ʻoe faʻahinga ʻo Livai? ʻOku ou ʻilo ʻoku lea lelei ia. Pea vakai foki, ʻoku haʻu ia ke fakafetaulaki kiate koe: pea ka mamata ia kiate koe, pea ʻe fiefia ia ʻi hono loto. ");
INSERT INTO ton_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Pea te ke lea ko e kiate ia, ʻo ʻai ʻae ngaahi lea ki hono ngutu: pea te uʻi ho ngutu mo hono ngutu, ke akoʻi ʻakimoua ʻaia te mo fai. ");
INSERT INTO ton_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Pea ʻe hoko ia ko hoʻo tangata lea ki he kakai: pea ʻe hoko ia, ʻio ʻe ʻiate koe ia, ko e ngutu, pea te ke ʻiate ia ko e fetongi ʻoe ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Pea te ke ʻave ʻae tokotoko ni ʻi ho nima, ʻaia te ke fai ʻaki ʻae ngaahi fakaʻilonga.” ");
INSERT INTO ton_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","¶ Pea naʻe ʻalu ʻa Mōsese ʻo hoko atu kia Setelo ko ʻene tamai ʻi he fono, ʻo ne pehē kiate ia, “ʻOku ou kole kiate koe ke ke tuku au ke u ʻalu, ʻo foki atu ki hoku ngaahi kāinga ʻoku ʻi ʻIsipite, ʻo vakai pe ʻoku nau kei moʻui.” Pea talaange ʻe Setelo kia Mōsese, “ʻAlu ʻi he fiemālie.” ");
INSERT INTO ton_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Pea pehē ʻe Sihova kia Mōsese ʻi Mitiane, “ʻAlu, ʻo toe foki ki ʻIsipite: he kuo mate ʻae kau tangata kotoa pē naʻa nau fie tāmateʻi koe.” ");
INSERT INTO ton_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Pea naʻe ʻave ʻe Mōsese hono uaifi mo hono ongo foha ʻo fakaheka ʻakinautolu ki he ʻasi, pea toe ʻalu ia ki he fonua ko ʻIsipite: pea naʻe toʻo ʻe Mōsese ʻae tokotoko ʻoe ʻOtua ʻi hono nima. ");
INSERT INTO ton_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻOka ke ka ʻalu ke toe hoko ki ʻIsipite, vakai, ke ke fai ʻae ngaahi mana ni kotoa pē ʻi he ʻao ʻo Felo, ʻaia kuo u ʻai ki ho nima: ka te u fakafefeka hono loto, pea ʻe ʻikai te ne tuku ʻae kakai ke ʻalu:” ");
INSERT INTO ton_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Pea te ke lea kia Felo, “ʻOku pehē mai ʻe Sihova, ‘Ko hoku foha ʻa ʻIsileli, ʻio, ko hoku ʻuluaki. ");
INSERT INTO ton_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Pea ʻoku ou tala atu kiate koe, Tukuange hoku foha ke ʻalu, koeʻuhi ke ne tauhi au: pea kapau te ke taʻofi ʻo ʻikai tukuange ia, vakai, Te u tāmateʻi ho foha, ʻio, ʻa ho ʻuluaki.’” ");
INSERT INTO ton_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","¶ Pea naʻe hoko ʻo pehē ʻi he hala ʻi he fale talifononga, naʻe fakafetaulaki ʻa Sihova kiate ia, ko e kumi ke tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Pea naʻe toʻo ai ʻe Sipola ʻae maka māsila, ʻo ne kamuʻi ʻene tama, ʻo ne si ia ki hono vaʻe, ʻo ne pehē, “Ko e moʻoni ko e mali pani toto koe kiate au.” ");
INSERT INTO ton_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ko ia ne ne tukuange ia ke ʻalu: pea pehē ʻe ia, Ko e mali pani toto koe, ko e meʻa ʻi he kamu. ");
INSERT INTO ton_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","¶ Pea naʻe pehēange ʻe Sihova kia ʻElone, “ʻAlu atu ki he toafa ke fakafetaulaki kia Mōsese.” Pea naʻe ʻalu atu ia, ʻo fakafetaulaki kiate ia ʻi he moʻunga ʻoe ʻOtua, pea ne ʻuma kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Pea naʻe tala ʻe Mōsese kia ʻElone ʻae ngaahi lea kotoa pē ʻa Sihova ʻaia naʻe fekauʻi ia, mo e ngaahi mana kotoa pē naʻa ne fekau kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","¶ Pea naʻe ʻalu ʻa Mōsese mo ʻElone ʻo fakakātoa ʻae kau mātuʻa kotoa pē ʻoe fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Pea naʻe lea ʻaki ʻe ʻElone ʻae ngaahi lea kotoa pē ʻaia naʻe folofolaʻaki ʻe Sihova kia Mōsese, pea ne fai ʻae ngaahi mana ʻi he ʻao ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Pea naʻe tui ʻae kakai: pea ʻi heʻenau fanongo kuo ʻaʻahi ʻa Sihova ki he fānau ʻa ʻIsileli, pea kuo ʻafio ia ki heʻenau mamahi, naʻa nau punou hifo honau mata ʻo hū. ");
INSERT INTO ton_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Pea hili ia naʻe ʻalu ʻa Mōsese mo ʻElone, ʻo tala kia Felo, “ʻOku pehē mai ʻe Sihova, ko e ʻOtua ʻo ʻIsileli, Tukuange ʻa hoku kakai ke ʻalu, koeʻuhi ke nau fai ʻae kātoanga kiate au ʻi he toafa.” ");
INSERT INTO ton_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pea pehēange ʻe Felo, “Ko hai ʻa Sihova, koeʻuhi ke u talangofua ai ki hono leʻo ʻo tukuange ʻa ʻIsileli ke ʻalu? ʻOku ʻikai te u ʻiloa ʻa Sihova, pea ʻe ʻikai te u tukuange ʻa ʻIsileli ke ʻalu.” ");
INSERT INTO ton_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Pea naʻa na pehē, “Kuo hāʻele mai ʻae ʻOtua ʻoe kau Hepelū kiate kimautolu: ko ia ʻoku mau kole ai kiate koe, tuku ʻakimautolu ke mau ʻalu ki he toafa, ko e fonongaʻanga ʻoe ʻaho ʻe tolu, ke feilaulau kia Sihova ko homau ʻOtua; telia naʻa hoko ia kiate kimautolu ʻi he mahaki fakaʻauha pe ko e heletā. ");
INSERT INTO ton_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pea pehēange ʻe he tuʻi ʻo ʻIsipite kiate kinaua, “ʻE Mōsese mo ʻElone, ko e hā ʻoku mo taʻofi ai ʻae kakai ʻi heʻenau ngaahi ngāue? Mou fei mo ʻalu ki hoʻomou ngaahi kavenga. ");
INSERT INTO ton_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pea naʻe pehē ʻe Felo, “Vakai, ko ʻeni, ʻoku tokolahi ʻae kakai ʻoe fonua pea ʻoku mou taʻofi ʻakinautolu mei heʻenau ngaahi kavenga.” ");
INSERT INTO ton_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Pea naʻe fekau ʻe Felo ʻi he ʻaho ko ia ki he kau enginaki ngāue ʻoe kakai, mo honau kau matāpule, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ʻOua te mou kei ʻatu ki he kakai ʻae mohuku mōmoa ke ngaohi ʻae makaʻumea ʻo hangē ko ia naʻe fai: tuku ke nau ʻalu ʻo tānaki ʻae mohuku mōmoa maʻanautolu. ");
INSERT INTO ton_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pea ko hono lau ʻoe ngaahi makaʻumea ʻaia naʻa nau muʻaki ngaohi, te mou fakapapau ia kiate kinautolu; ʻe ʻikai te mou fakasiʻisiʻi ia, he ʻoku nau fakapikopiko; ko ia ʻoku nau tangi ai, ʻo pehē, Tukuange ʻakimautolu ke ʻalu ʻo feilaulau ki homau ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Fakalahi ki he ngāue ʻae kau tangata, koeʻuhi ke nau moʻua ai; pea ʻoua naʻa nau tokanga ki he ngaahi launoa.” ");
INSERT INTO ton_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","¶ Pea naʻe ʻalu kituʻa ʻae kau ʻenginaki ngāue ʻoe kakai, mo honau kau matāpule, ʻonau lea ki he kakai, ʻo pehē, “ʻOku pehē mai ʻe Felo, ʻE ʻikai te u ʻatu ʻae mohuku mōmoa kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Mou ʻalu, ʻo maʻu ʻae mohuku mōmoa mei ha potu pe: ka ʻe ʻikai siʻi fakasiʻisiʻi ai hoʻomou ngāue.” ");
INSERT INTO ton_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Pea ko ia naʻe movetevete ai ʻae kakai ʻi he fonua kotoa pē ʻo ʻIsipite, ke tānaki ʻae louveve ko e fetongi ʻoe mohuku mōmoa. ");
INSERT INTO ton_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Pea naʻe fakavavevave ʻakinautolu ʻe he kau enginaki ngāue, ʻo pehē, “Fakakakato hoʻomou ngāue ki he ʻaho taki taha, ʻo hangē ko ia ʻi he ʻi ai ʻae mohuku. ");
INSERT INTO ton_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Pea ko e kau matāpule ʻi he fānau ʻa ʻIsileli, ʻaia naʻe fakanofo ʻe he kau enginaki ngāue ʻa Felo, ke pule kiate kinautolu, naʻe teʻia, pea ʻeke kiate kinautolu, “Ko e hā naʻe ʻikai te mou fakakakato ai hono lau ʻoe maka naʻe tala ke ngaohi ʻaneafi, pea mo e ʻaho ni, ʻo hangē ko hono muʻaki fai?” ");
INSERT INTO ton_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Pea haʻu ai ʻae kau matāpule ʻi he fānau ʻa ʻIsileli kia Felo, ʻo tangi ʻo pehē, “Ko e hā ʻoku ke fai pehē ai ki hoʻo kau tamaioʻeiki? ");
INSERT INTO ton_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","‌ʻOku ʻikai tuku mai ha mohuku mōmoa ki hoʻo kau tamaioʻeiki, pea ʻoku nau tala mai, ‘Ngaohi ʻae maka:’ pea vakai, kuo teʻia ʻa hoʻo kau tamaioʻeiki ka ko hono kovi ʻoku ʻi ho kakai ʻoʻou.” ");
INSERT INTO ton_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ka naʻe pehē ʻe ia, “ʻOku mou fakapikopiko, ʻoku mou fakapikopiko: ko ia ʻoku mou pehē ai, ‘Tuku ʻakimautolu ke mau ʻalu ʻo feilaulau kia Sihova.’ ");
INSERT INTO ton_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ko ia mou ʻalu ni ʻo ngāue: ʻe ʻikai ʻatu ha mohuku mōmoa kiate kimoutolu, ka te mou ʻatu hono lau totonu ʻo hoʻomou makaʻumea.” ");
INSERT INTO ton_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Pea mamata ʻae kau matāpule ʻoe fānau ʻa ʻIsileli ʻoku nau tuʻutāmaki, hili hono tala, ʻo pehē, “ʻE ʻikai te mou fakasiʻisiʻi ʻae makaʻumea mei he ngāue ʻoe ʻaho taki taha.” ");
INSERT INTO ton_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","¶ Pea naʻa nau fetaulaki mo Mōsese mo ʻElone, ʻoku tutuʻu ʻi he hala, ʻi heʻenau haʻu kituʻa meia Felo. ");
INSERT INTO ton_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Pea nau pehē kiate kinaua, “Ke vakai ʻa Sihova kiate kimoua, pea fakamaauʻi: koeʻuhi kuo mo fakanamukūʻi ʻakimautolu ʻi he ʻao ʻo Felo, pea mo e ʻao ʻo ʻene kau tamaioʻeiki, ke ai ʻae heletā ʻi honau nima ke fakapoongi ʻaki ʻakimautolu.” ");
INSERT INTO ton_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Pea naʻe toe ʻalu ʻa Mōsese kia Sihova, ʻo ne pehē, “ʻEiki ko e hā kuo ke fai kovi pehē ai ki he kakai ni? Ko e hā kuo ke fekau ai au? ");
INSERT INTO ton_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","He talu ʻeku haʻu kia Felo ke lea ʻi ho huafa, kuo fai kovi ʻe ia ki he kakai ni; pea ʻoku teʻeki ʻaupito te ke fakamoʻui ho kakai.” ");
INSERT INTO ton_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Pea naʻe folofola ai ʻa Sihova kia Mōsese, “Ko eni, te ke mamata ki he meʻa te u fai kia Felo: koeʻuhi ʻi he nima mālohi te ne tukuange ʻakinautolu ke ʻalu, pea ʻi he nima mālohi te ne kapusi ʻakinautolu mei he fonua.” ");
INSERT INTO ton_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Pea naʻe folofola ʻae ʻOtua kia Mōsese, ʻo ne pehē kiate ia, “Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Pea naʻaku fakahā au kia ʻEpalahame, mo ʻAisake, pea mo Sēkope, ko e ʻOtua Māfimafi, ka ko hoku huafa KO SIHOVA, naʻe ʻikai ke ʻilo ai au ʻekinautolu. ");
INSERT INTO ton_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Pea kuo u fakapapau ʻeku fuakava mo kinautolu, ke foaki kiate kinautolu ʻae fonua ko Kēnani, ko e fonua ʻo ʻenau fononga fano, ʻaia naʻa nau nofo ai ko e muli. ");
INSERT INTO ton_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Pea kuo u ongoʻi ʻae ngaahi toʻe foki ʻae fānau ʻa ʻIsileli, ʻakinautolu ʻoku kei fakapōpulaʻi ʻe he kakai ʻIsipite: pea kuo u manatuʻi ʻeku fuakava. ");
INSERT INTO ton_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ko ia, lea ki he fānau ʻa ʻIsileli, ‘Ko au ko Sihova, pea te u ʻomi ʻakimoutolu kituʻa mei he ngaahi kavenga ʻae kakai ʻIsipite, pea te u fakangata ʻa hoʻomou pōpula kiate kinautolu, pea teu huhuʻi ʻakimoutolu ʻaki ʻae nima kuo mafao, mo e ngaahi tautea lahi: ");
INSERT INTO ton_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Pea te u maʻu ʻakimoutolu kiate au ko hoku kakai, pea teu ʻiate kimoutolu ko homou ʻOtua: pea te mou ʻilo ko au ko Sihova ko homou ʻOtua, ʻoku ou ʻomi ʻakimoutolu kituʻa mei he ngaahi kavenga ʻae kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Pea te u ʻomi ʻakimoutolu ki he fonua, ʻaia naʻaku fuakava ai ke foaki ia kia ʻEpalahame, mo ʻAisake, pea mo Sēkope; pea te u foaki ia kiate kimoutolu ko e tofiʻa: Ko au ko Sihova.’” ");
INSERT INTO ton_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","¶ Pea naʻe lea pehē ʻe Mōsese ki he fānau ʻa ʻIsileli: ka naʻe ʻikai te nau tokanga kia Mōsese ko e meʻa ʻi he feinga ʻa honau laumālie, mo e māmani ʻo honau pōpula. ");
INSERT INTO ton_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ʻAlu, ʻo lea kia Felo ko e tuʻi ʻo ʻIsipite, ke ne tukuange ʻae fānau ʻa ʻIsileli, ke ʻalu mei hono fonua.” ");
INSERT INTO ton_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pea naʻe lea ʻa Mōsese ʻi he ʻao ʻo Sihova, ʻo pehē, “Vakai, ʻoku ʻikai tokanga ʻae fānau ʻa ʻIsileli kiate au: pea ʻe tokanga fēfeeʻi ʻa Felo kiate au, ko e loungutu taʻekamu ko au?” ");
INSERT INTO ton_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Pea naʻe folofola ʻa Sihova kia Mōsese, pea mo ʻElone, “ʻO ne tuku kiate kinaua ʻae fekau ki he fānau ʻa ʻIsileli, pea kia Felo ko e tuʻi ʻo ʻIsipite, ke ʻomi ʻae fānau ʻa ʻIsileli mei he fonua ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","¶ Pea ko e ngaahi ʻeiki eni ʻoe fale ʻo ʻenau ngaahi tamai: Ko e ngaahi foha ʻo Lupeni ko e ʻuluaki foha ʻo ʻIsileli; ko Henoke, mo Falu, mo Hesiloni, mo Kalimi; ko e ngaahi faʻahinga eni ʻo Lupeni. ");
INSERT INTO ton_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Pea ko e ngaahi foha ʻo Simione; ko Semueli, mo Samini, mo ʻOhati, mo Sakini mo Sohali, mo Saula, ko e tama ʻae fefine Kēnani: ko e ngaahi faʻahinga eni ʻo Simione. ");
INSERT INTO ton_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","¶ Pea ko e hingoa eni ʻoe ngaahi foha ʻo Livai ʻo fakatatau ki honau ngaahi toʻutangata; ko Kesoni, mo Kohate, mo Melali: pea ko e ngaahi taʻu ʻoe moʻui ʻa Livai ko e taʻu ʻe teau mo e taʻu ʻe tolungofulu ma fitu. ");
INSERT INTO ton_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ko e ongo foha ʻo Kesoni: ko Sipinai, mo Simi, ʻo fakatatau ki hona faʻahinga: ");
INSERT INTO ton_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Pea ko e ngaahi foha ʻo Kohate; ko ʻAmilami, mo ʻIsa, mo Hepeloni, mo ʻUsili: pea ko e ngaahi taʻu ʻoe moʻui ʻa Kohate, ko e taʻu ʻe teau mo e taʻu ʻe tolungofulu ma tolu. ");
INSERT INTO ton_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Pea ko e ongo foha ʻo Melali; ko Mali mo Musi: ko e ngaahi faʻahinga eni ʻo Livai ʻi honau ngaahi toʻutangata. ");
INSERT INTO ton_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Pea naʻe ʻomi ʻe ʻAmilami ʻa Sokapeti ko e tuofefine ʻo ʻene tamai ʻo na mali; pea ne fanauʻi kiate ia ʻa ʻElone mo Mōsese: pea ko e ngaahi taʻu ʻoe moʻui ʻa ʻAmilami ko e taʻu ʻe teau mo e taʻu ʻe tolungofulu ma fitu. ");
INSERT INTO ton_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Pea ko e ngaahi foha ʻo ʻIsa: ko Kola, mo Nefaki, mo Sikili. ");
INSERT INTO ton_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Pea ko e ngaahi foha ʻo ʻUsili; ko Miseli, mo ʻElisefani, mo Sitili. ");
INSERT INTO ton_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Pea naʻe ʻomi ʻe ʻElone ʻa ʻElisipa, ko e ʻofefine ʻo ʻAminatape, ko e tuofefine ʻo Neasoni, ʻo na mali; pea naʻe fānau kiate ia ʻa Natipi mo ʻApiu, mo ʻEliesa, mo ʻItama. ");
INSERT INTO ton_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Pea ko e ngaahi foha ʻo Kola; ko ʻAsili, mo ʻElikena, mo ʻApiasafi: ko e ngaahi faʻahinga eni ʻo Kola. ");
INSERT INTO ton_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Pea naʻe maʻu ʻe ʻEliesa ko e foha ʻo ʻElone ʻae tokotaha ʻoe ʻofefine ʻo Piuteli ʻo na mali: pea ne fanauʻi kiate ia ʻa Finiasi: ko ʻeni ʻae ngaahi ʻeiki ʻoe kau mātuʻa ʻoe kau Livai ʻi honau ngaahi faʻahinga. ");
INSERT INTO ton_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ko eni ʻae ʻElone mo e Mōsese ko ia, naʻe folofola ki ai ʻa Sihova, “Mo omi kituaʻā mei he fonua ko ʻIsipite ʻae fānau ʻa ʻIsileli ʻi honau ngaahi kongakau. ");
INSERT INTO ton_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ko kinaua ʻeni ʻaia naʻa na lea kia Felo ko e tuʻi ʻo ʻIsipite, ke ʻomi kituaʻā ʻae fānau ʻa ʻIsileli mei ʻIsipite: ko eni ʻae Mōsese mo e ʻElone ko ia.” ");
INSERT INTO ton_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","¶ Pea naʻe hoko ʻo pehē, ʻi he ʻaho ko ia naʻe folofola ai ʻa Sihova kia Mōsese ʻi he fonua ko ʻIsipite, ");
INSERT INTO ton_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Naʻe folofola ʻa Sihova kia Mōsese, ʻo pehēange, “Ko au ko Sihova: ke ke tala ʻe koe kia Felo ko e tuʻi ʻo ʻIsipite, ʻaia kotoa pē ʻoku ou lea ʻaki kiate koe.” ");
INSERT INTO ton_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Pea naʻe pehē ʻe Mōsese ʻi he ʻao ʻo Sihova, “Vakai, ko e loungutu taʻekamu au, pea ʻe tokanga fēfeeʻi ʻa Felo kiate au?” ");
INSERT INTO ton_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “Vakai, Kuo u ngaohi koe ke ke hangē ko e ʻotua kia Felo: pea ko ʻElone ko ho taʻokete, ko hoʻo fakafofonga ia. ");
INSERT INTO ton_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Pea ke ke lea ʻaki ʻe koe ʻaia kotoa pē te u fekau kiate koe: pea ʻe lea ʻa ho taʻokete ko ʻElone kia Felo, koeʻuhi ke ne tuku atu ʻae fānau ʻa ʻIsileli mei hono fonua. ");
INSERT INTO ton_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pea te u fakafefeka ʻae loto ʻo Felo, pea te u fakalahi ʻeku mana mo ʻeku meʻa fakaofo ʻi he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ka ʻe ʻikai tokanga ʻa Felo kiate kimoua, koeʻuhi ke u hili hoku nima ki ʻIsipite, ʻo ʻomi kituaʻā ʻeku ngaahi kautau, mo hoku kakai ko e fānau ʻa ʻIsileli, mei he fonua ko ʻIsipite ʻi he ngaahi tautea lahi. ");
INSERT INTO ton_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Pea ʻe hoko ʻo ʻilo ʻe he kakai ʻIsipite ko au ko Sihova, ʻo kau ka mafao atu hoku nima ki ʻIsipite, ʻo ʻomi kituaʻā ʻae fānau ʻa ʻIsileli meiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Pea naʻe fai ʻe Mōsese mo ʻElone ʻo hangē ko e fekau ʻa Sihova kiate kinaua, ko ia ia ne na fai. ");
INSERT INTO ton_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Pea naʻe valungofulu taʻu ʻae motuʻa ʻo Mōsese, pea valungofulu taʻu mo e taʻu ʻe tolu ʻae motuʻa ʻo ʻElone, ʻi heʻena lea kia Felo. ");
INSERT INTO ton_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehēange, ");
INSERT INTO ton_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","‌ʻOka lea ʻa Felo kiate kimoua, ʻo pehē, “Fakahā mai haʻa mo mana: te ke lea ai kia ʻElone, Toʻo ho tokotoko, ʻo si ia ʻi he ʻao ʻo Felo, pea ʻe hoko ia ko e ngata.” ");
INSERT INTO ton_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","¶ Pea naʻa na ō, ʻa Mōsese mo ʻElone, ʻo hoko atu kia Felo, pea ne na fai ʻo hangē ko e fekau ʻa Sihova: pea si hifo ʻe ʻElone hono tokotoko ʻi he ʻao ʻo Felo, mo e ʻao ʻo ʻene kau tamaioʻeiki, pea hoko ia ko e ngata. ");
INSERT INTO ton_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pea naʻe toki ui ʻe Felo ke haʻu foki ʻae kau tangata poto mo e kau kikite: pea ko eni, ko e kau fie mana ʻo ʻIsipite, naʻa nau fai pehē foki ʻaki ʻenau ngaahi ngāue fakalilolilo. ");
INSERT INTO ton_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","He naʻa nau taki taha si ki lalo hono tokotoko, pea naʻe liliu ia ko e ngaahi ngata: ka ko e tokotoko ʻo ʻElone naʻa ne folo hifo ʻo ʻosi honau ngaahi tokotoko. ");
INSERT INTO ton_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pea ne fakafefeka ʻae loto ʻo Felo, pea naʻe ʻikai te ne tokanga kiate kinautolu; ʻo hangē ko e folofola ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Kuo fefeka ʻae loto ʻo Felo, ʻoku ʻikai loto ia ke ʻalu ʻae kakai. ");
INSERT INTO ton_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ke ke ʻalu ʻapongipongi kia Felo; vakai, ʻoku ʻalu atu ia ki he vai; pea te ke tuʻu koe ʻo ofi ki he veʻe vai ko hono tali; pea ke ke toʻo ʻi ho nima ʻae tokotoko naʻe liliu ko e ngata. ");
INSERT INTO ton_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Pea te ke lea kiate ia, ‘Ko Sihova ko e ʻOtua ʻoe kakai Hepelū kuo ne fekau au kiate koe, ke pehē, Tukuange hoku kakai ke ʻalu, koeʻuhi ke nau tauhi au ʻi he toafa: pea vakai, ʻoku teʻeki ai te ke tokanga ki ai. ");
INSERT INTO ton_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","‌ʻOku pehē mai ʻe Sihova, ʻi he meʻa ni te ke ʻilo ko au ko Sihova: vakai, teu tā ʻae vai ʻaia ʻoku ʻi he vaitafe, ʻaki ʻae tokotoko ʻoku ʻi hoku nima, pea ʻe liliu ia ko e toto. ");
INSERT INTO ton_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Pea ko e ngaahi ika ʻoku ʻi he vaitafe, ʻe mate ia, pea ʻe namukū ʻae vaitafe: pea ʻe fakaliliʻa ʻae kakai ʻIsipite ke inu ʻae vai ʻi he vaitafe.’” ");
INSERT INTO ton_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, Tala kia ʻElone, “Toʻo ho tokotoko, mo ke mafao atu ho nima ki he ngaahi vai ʻo ʻIsipite, ki honau vaitafe siʻi mo e vai tafe lahi, ki he ngaahi luovai, mo e ngaahi anovai, koeʻuhi ke liliu ia ko e toto: koeʻuhi ke ai ʻae toto ʻi he potu fonua kotoa pē ʻo ʻIsipite, ʻi he ngaahi ʻaiʻanga vai ʻakau, mo e ngaahi ʻaiʻanga vai maka.” ");
INSERT INTO ton_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Pea naʻe fai ʻe Mōsese mo ʻElone, ʻo hangē ko e fekau ʻa Sihova: pea naʻa ne hiki hake ʻae tokotoko ʻo taaʻi ʻaki ʻae vai ʻi he vaitafe ʻi he ʻao ʻo Felo, mo e ʻao ʻo ʻene kau tamaioʻeiki; pea naʻe liliu ʻae ngaahi vai kotoa pē ʻi he vaitafe ko e toto. ");
INSERT INTO ton_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Pea naʻe mate ai ʻae ika naʻe ʻi he vaitafe; pea naʻe namukū ʻae vaitafe, pea ʻikai faʻa inu ʻe he kakai ʻIsipite ʻae vai ʻoe vaitafe; pea naʻe ai ʻae toto ʻi he potu fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pea naʻe fai pehē pe ʻe he kau fie mana ʻo ʻIsipite ʻaki ʻenau ngaahi ngāue fakalilolilo: pea naʻe fefeka ai ʻae loto ʻo Felo, pea naʻe ʻikai te ne tokanga kiate kinaua, ʻo hangē ko e folofola ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pea foki atu ʻa Felo ʻo hū ki hono fale, pea naʻe ʻikai te ne fakatokangaʻi hono loto ki he meʻa ni. ");
INSERT INTO ton_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Pea naʻe keli ʻe he kakai ʻIsipite kotoa pē ʻo ofi ki he vaitafe ke maʻu ʻae vai ke inu; he naʻe ʻikai te nau faʻa inu ʻae vai mei he vaitafe. ");
INSERT INTO ton_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pea naʻe ʻosi ange ʻae ʻaho ʻe fitu, hili hono taaʻi ʻae vai lahi ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu kia Felo mo ke tala kiate ia, ʻOku pehē mai ʻe Sihova, Tukuange hoku kakai ke ʻalu, koeʻuhi ke nau tauhi au. ");
INSERT INTO ton_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pea kapau ʻe ʻikai te ke tukuange ʻakinautolu ke ʻalu, vakai, Te u taaʻi ho ngaahi potu fonua kotoa pē ʻaki ʻae fanga poto: ");
INSERT INTO ton_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Pea ʻe tupu ʻi he vaitafe ʻae fanga poto ʻo lahi ʻaupito, ʻaia te nau ʻalu hake ʻo hoko ki ho fale, pea ki ho potu mohe, pea ki ho mohenga, pea ki he fale ʻo hoʻo kau tamaioʻeiki, pea ki hoʻo kakai, pea ki hoʻo ngaahi ngotoʻumu, pea ki hoʻo ngaahi natuʻanga ma: ");
INSERT INTO ton_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pea ʻe haʻu ʻae fanga poto ʻo hoko kiate koe, pea ki ho kakai, pea ki hoʻo kau tamaioʻeiki kotoa pē.” ");
INSERT INTO ton_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Tala kia ʻElone, Mafao atu ho nima, mo hoʻo tokotoko ki he ngaahi vaitafe siʻi mo e vai tafe lahi, mo e ngaahi luo vai, koeʻuhi ke haʻu ai ʻae fanga poto ki he fonua ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Pea naʻe mafao atu ʻe ʻElone hono nima ki he ngaahi vai ʻo ʻIsipite; pea naʻe ʻalu hake ʻae fanga poto ʻo ʻufiʻufi ʻae fonua ko ʻIsipite, ");
INSERT INTO ton_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pea naʻe fai pehē ʻe he kau fie mana ʻaki ʻenau ngaahi ngāue fakalilolilo, ʻonau ʻomi ʻae fanga poto ki he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","¶ Pea naʻe fekau ʻe Felo ke haʻu ʻa Mōsese mo ʻElone, ʻo ne pehē, “Mo kole kia Sihova, koeʻuhi ke ne ʻave ʻiate au mo hoku kakai ʻae fanga poto: pea te u tukuange ʻae kakai ke ʻalu, koeʻuhi ke nau fai ʻae feilaulau kia Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Pea pehēange ʻe Mōsese kia Felo, “Ke ke fekau kiate au, pe te u fai fakakū ʻae hū, koeʻuhi ko koe, mo hoʻo kau tamaioʻeiki, pea mo ho kakai, ke fakaʻauha ʻae fanga poto meiate koe mo ho ngaahi fale koeʻuhi ke nau nofo pe ki he vaitafe?” ");
INSERT INTO ton_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pea pehē ʻe ia, “ʻApongipongi.” Pea pehē ʻe ia, “Ke hoko ʻo hangē ko hoʻo lea: koeʻuhi ke ke ʻilo ai ʻoku ʻikai ha tokotaha ʻoku hangē ko Sihova ko homau ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Pea ʻe ʻalu meiate koe ʻae fanga poto, pea mei ho ngaahi fale, pea mei hoʻo kau tamaioʻeiki, pea mei ho kakai: te nau nofo pe ʻi he vaitafe.” ");
INSERT INTO ton_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Pea naʻe ʻalu ʻa Mōsese mo ʻElone mei he ʻao ʻo Felo: pea naʻe tangi ʻa Mōsese kia Sihova ko e meʻa ʻi he fanga poto, ʻaia naʻa ne ʻomi kia Felo. ");
INSERT INTO ton_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Pea naʻe fai ʻe Sihova ʻo hangē ko e lea ʻa Mōsese; pea naʻe mate ai ʻae fanga poto mei he ngaahi fale, mo e ngaahi potu kakai, pea mei he ngaahi ngoue. ");
INSERT INTO ton_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Pea naʻa nau tānaki fakataha ia ki he ngaahi fokotuʻunga: pea naʻe namuhāhā ai ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pea kuo mamata ʻa Felo ʻoku ai ʻae fiefiemālie, naʻa ne fakafefeka ʻa hono loto, ʻo ne taʻetokanga kiate kinaua; ʻo hangē ko e folofola ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Tala kia ʻElone, Mafao atu ho tokotoko, ʻo taaʻi ʻaki ia ʻae efu ʻoe fonua, koeʻuhi ke hoko ia ko e fanga kutu ʻi he fonua kotoa pē ʻo ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Pea naʻa na fai ia; he naʻe mafao atu ʻe ʻElone hono nima mo e tokotoko, ʻo ne taaʻi ʻae efu ʻoe kelekele, pea naʻe liliu ia ko e kutu ʻi he tangata mo e manu; ko e efu kotoa pē ʻoe fonua naʻe hoko ia ko e fanga kutu ʻi he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pea naʻe fai ʻe he kau fie mana ke fakatupu ʻae kutu ʻaki ʻenau ngāue fakalilolilo ka naʻe ʻikai te nau lavaʻi: pea naʻe ai ʻae kutu ʻi he tangata mo e manu. ");
INSERT INTO ton_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Pea pehē ai ʻe he kau fie mana kia Felo, “Ko e louhiʻi nima eni ʻoe ʻOtua:” ka kuo fefeka ʻae loto ʻo Felo, pea naʻe ʻikai tokanga ia kiate kinaua; ʻo hangē ko e folofola ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Tuʻu hengihengi hake ʻapongipongi, ʻo tuʻu ʻi he ʻao ʻo Felo; vakai, ʻoku haʻu ia ki he vai; ʻo tala kiate ia, ʻoku pehē mai ʻa Sihova, ‘Tukuange hoku kakai ke ʻalu, koeʻuhi ke nau tauhi au. ");
INSERT INTO ton_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pea kapau ʻe ʻikai te ke tukuange hoku kakai, vakai, te u fekau ʻae ngaahi fuifui lango kehekehe kiate koe, pea ki hoʻo kau tamaioʻeiki, pea ki ho kakai, pea ki ho ngaahi fale: pea ko e ngaahi fale ʻoe kakai ʻIsipite ʻe fonu ʻi he ngaahi fuifui lango, pea mo e kelekele foki ʻoku nau tuʻu ai. ");
INSERT INTO ton_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pea te u vaheʻi ʻi he ʻaho ko ia ʻae fonua ko Koseni, ʻaia ʻoku nofo ai hoku kakai, ʻe ʻikai ha fuifui lango ʻi ai; koeʻuhi ke ke ʻilo ai ko au ko Sihova ʻi he lotolotonga ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Pea te u ʻai ʻae vahaʻa ʻi hoku kakai mo ho kakai: ʻe hoko ʻapongipongi ʻae fakaʻilonga ni.’” ");
INSERT INTO ton_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Pea naʻe fai ia ʻe Sihova: pea naʻe haʻu ʻae fuifui lango fakamamahi ki he fale ʻo Felo, mo e ngaahi fale ʻo ʻene kau tamaioʻeiki, pea ki he fonua kotoa pē ʻo ʻIsipite: pea naʻe maumau ʻae fonua ko e meʻa ʻi he ngaahi fuifui lango. ");
INSERT INTO ton_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","¶ Pea fekau ʻe Felo ke haʻu ʻa Mōsese mo ʻElone, ʻo ne pehē, “Mo ō, ʻo feilaulau ki homou ʻOtua ʻi he fonua.” ");
INSERT INTO ton_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Pea talaange ʻe Mōsese, “ʻOku ʻikai lelei ke fai pehē: he te mau feilaulau ʻaki ʻae meʻa ʻoku fakaliliʻa ai ʻae kakai ʻIsipite, kia Sihova ko homau ʻOtua: vakai, kapau te mau feilaulau ʻaki ʻae meʻa ʻoku fakaliliʻa ai ʻae kakai ʻIsipite, ʻi honau ʻao, pea ʻikai te nau tolongi ʻaki ʻakimautolu ʻae maka? ");
INSERT INTO ton_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Te mau ʻalu ko e fonongaʻanga ʻoe ʻaho ʻe tolu ki he toafa, ke feilaulau kia Sihova ko homau ʻOtua, ʻo hangē ko ʻene fekau kiate kimautolu.” ");
INSERT INTO ton_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pea pehē ʻe Felo, “Te u tuku ke mou ʻalu, koeʻuhi ke mou feilaulau kia Sihova, ko homou ʻOtua ʻi he toafa: ka ʻe ʻikai te mou ʻalu mamaʻo atu: ko ia mou hūfia au.” ");
INSERT INTO ton_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Pea pehē ʻe Mōsese, “Vakai, ʻoku ou ʻalu meiate koe, pea te u hū kia Sihova koeʻuhi ke ʻalu ʻae ngaahi fuifui lango ia Felo, pea mei heʻene kau tamaioʻeiki, pea mei hono kakai ʻapongipongi: kaeʻoua naʻa toe fai fakakākā ʻe Felo ʻi he taʻofi ʻae kakai ke ʻoua naʻa ʻalu ke feilaulau kia Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Pea naʻe ʻalu kituʻa ʻa Mōsese meia Felo, ʻo ne hū kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Pea naʻe fai ʻe Sihova ʻo hangē ko e lea ʻa Mōsese: ʻo ne ʻave ʻae ngaahi fuifui lango meia Felo, pea mei heʻene kau tamaioʻeiki, pea mei hono kakai; naʻe ʻikai kei toe ha taha. ");
INSERT INTO ton_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pea naʻe fakafefeka hono loto ʻe Felo ʻi he ʻaho ko ia foki, pea naʻe ʻikai te ne tuku ʻae kakai ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Pea folofola ai ʻa Sihova kia Mōsese, “ʻAlu kia Felo, ʻo tala kiate ia, ʻOku pehē mai ʻa Sihova ko e ʻOtua ʻoe kakai Hepelū, ‘Tukuange hoku kakai ke ʻalu,’ koeʻuhi ke nau tauhi au.” ");
INSERT INTO ton_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","He kapau te ke taʻofi hono tukuange, mo ke puke pe ʻakinautolu, ");
INSERT INTO ton_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Vakai, ko e nima ʻo Sihova ʻoku ʻi hoʻo ngaahi manu ʻaia ʻoku ʻi he ngoue, ki he fanga hoosi, pea ki he fanga asi, ki he fanga kāmeli, ki he fanga pulu, pea ki he fanga sipi: ʻe ai ʻae mahaki lahi mo mamahi. ");
INSERT INTO ton_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pea ʻe vaheʻi ʻe Sihova ʻae ngaahi manu ʻa ʻIsileli mei he ngaahi manu ʻa ʻIsipite: pea ʻe ʻikai ha meʻa ʻe mate ʻi he meʻa kotoa pē ʻae fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Pea naʻe kotofa ʻe Sihova hono feituʻulaʻā, ʻo pehē, “ʻE fai ʻe Sihova ʻae meʻa ni ʻapongipongi ʻi he fonua.” ");
INSERT INTO ton_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Pea naʻe fai ʻe Sihova ʻae meʻa ko ia ʻi he ʻapongipongi, pea naʻe mate ai ʻae ngaahi manu ʻa ʻIsipite; ka ko e ngaahi manu ʻae kakai ʻIsileli, naʻe ʻikai mate ai ha taha. ");
INSERT INTO ton_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pea fekau ʻe Felo, pea vakai, naʻe ʻikai mate ha manu ʻe taha ʻi he kakai ʻIsileli. Pea naʻe fakafefeka ʻae loto ʻo Felo, pea naʻe ʻikai te ne tukuange ʻae kakai ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, pea mo ʻElone, “Mo toʻo ʻae faluku ʻoe efuefu mei he ngotoʻumu, pea tuku ke laku hake ia ʻe Mōsese ki langi ʻi he ʻao ʻo Felo: ");
INSERT INTO ton_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Pea ʻe hoko ia ko e efu ʻi he fonua kotoa pē ʻo ʻIsipite, pea ʻe hoko ia ko e hangatāmaki mo e vakafoha, ki he tangata mo e manu ʻi he fonua kotoa pē ʻo ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Pea naʻa na toʻo mai ʻae efuefu ʻoe ngotoʻumu, ʻo na tuʻu ʻi he ʻao ʻo Felo: pea laku hake ia ʻe Mōsese ki langi; pea naʻe hoko ia ko e hangatāmaki, pea naʻe tupu ʻae vakafoha ki he tangata mo e manu. ");
INSERT INTO ton_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Pea naʻe ʻikai faʻa tuʻu ʻae kau fie mana ʻi he ʻao ʻo Mōsese ko e meʻa ʻi he hangatāmaki; he naʻe ʻi he kau fie mana ʻae hangatāmaki, pea naʻe ʻi he kakai ʻIsipite kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pea naʻe fakafefeka ʻe Sihova ʻae loto ʻo Felo, pea naʻe ʻikai tokanga ia kiate kinaua; ʻo hangē ko e folofola ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Tuʻu hengihengi hake ʻi he ʻapongipongi, pea tuʻu ʻi he ʻao ʻo Felo, ʻo tala kiate ia, ʻOku pehē mai ʻa Sihova ko e ʻOtua ʻoe kakai Hepelū, ‘Tukuange hoku kakai ke ʻalu, koeʻuhi ke nau tauhi au.’ ");
INSERT INTO ton_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","He te u fekau eni ʻa ʻeku ngaahi tautea kotoa pē ki ho loto, pea ki hoʻo kau tamaioʻeiki, pea mo ho kakai; koeʻuhi ke ke ʻilo ai ʻoku ʻikai ha tokotaha ʻi māmani ʻo hangē ko au. ");
INSERT INTO ton_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","He ko ʻeni, teu mafao atu hoku nima, koeʻuhi ke u taaʻi koe mo ho kakai ʻaki ʻae mahaki fakaʻauha; pea ʻe tuʻusi koe mei māmani. ");
INSERT INTO ton_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pea ko e moʻoni kuo u fokotuʻu koe, koeʻuhi ke fakahā ʻiate koe ʻeku mālohi; pea ke fakaongo atu ai hoku huafa ʻi māmani kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","‌ʻOku ke kei fakahikihiki koe ki hoku kakai, pea ʻoku ʻikai te ke fie tuku ʻakinautolu ke ʻalu? ");
INSERT INTO ton_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Vakai, ko e feituʻulaʻā ni ʻapongipongi, Te u pule ke tō ai ʻae ʻuha maka fakamamahi lahi, naʻe ʻikai hano tatau ʻi ʻIsipite, talu hono fokotuʻu ʻo ia ʻo aʻu ki heni. ");
INSERT INTO ton_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ko ia ke ke fekau ni, ke tānaki hoʻo fanga manu mo ia kotoa pē ʻoku ke maʻu ʻi he ngoue; he ko e tangata kotoa pē mo e manu kotoa pē ʻaia ʻe ʻilo ʻi he ngoue, pea ʻe ʻikai ʻomi ia ki ʻapi, ʻe tō hifo ʻae ʻuha maka ki ai, pea te nau mate.” ");
INSERT INTO ton_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pea ʻilonga ia naʻe manavahē ki he folofola ʻa Sihova ʻi he kau tamaioʻeiki ʻa Felo, naʻa ne pule ke puna ʻene kau tamaioʻeiki, mo e fanga manu ki he ngaahi fale: ");
INSERT INTO ton_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pea ko ia naʻe ʻikai tokanga ki he folofola ʻa Sihova, naʻe tuku ʻe ia ʻene kau tamaioʻeiki mo e fanga manu ʻi he ngoue. ");
INSERT INTO ton_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Mafao atu ho nima ki langi: koeʻuhi ke hoko ʻae ʻuha maka ki he tangata mo e manu ʻi he fonua kotoa pē ʻo ʻIsipite, pea ki he ʻakau kotoa pē ʻoe ngoue, ʻi he fonua kotoa pē ʻo ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Pea mafao atu hono tokotoko e Mōsese ki langi: pea naʻe fekau ʻe Sihova ʻae mana mo e ʻuha maka, pea naʻe malele ʻae afi ʻi he funga fonua; pea naʻe fakaʻuha maka ʻe Sihova ki he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Pea naʻe ai ʻae ʻuha maka naʻe fefiofi mo e afi, ko e meʻa mamahi ʻaupito, naʻe ʻikai hano tatau ʻi he fonua kotoa pē ʻo ʻIsipite talu hono hoko ko e puleʻanga. ");
INSERT INTO ton_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Pea naʻe teʻia ʻe he ʻuha maka ʻaia kotoa pē naʻe ʻi he ngoue ʻi he fonua kotoa pē ʻo ʻIsipite, ʻae tangata mo e manu: pea teʻia ʻe he ʻuha maka ʻae ʻakau siʻi kotoa pē, pea ne fesiʻi ʻae ʻakau lahi kotoa pē ʻoe ngoue. ");
INSERT INTO ton_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ka ko e fonua ko Koseni, ʻaia naʻe nofo ai ʻae fānau ʻa ʻIsileli, naʻe ʻikai ʻi ai ha ʻuha maka. ");
INSERT INTO ton_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","¶ Pea naʻe fekau ʻe Felo ke haʻu ʻa Mōsese mo ʻElone, ʻo ne pehē kiate kinaua, “Kuo u fai angahala ʻi he feituʻulaʻā ni: ʻoku māʻoniʻoni ʻa Sihova, ka ko au mo hoku kakai ʻoku angahala. ");
INSERT INTO ton_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mo hū kia Sihova (he kuo lahi,) ke ʻoua naʻa kei fai ʻae mana lahi mo e ʻuha maka; pea te u tuku ʻakimoutolu ke ʻalu, pea ʻe ʻikai te mou tatali.” ");
INSERT INTO ton_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Pea pehē ʻe Mōsese kiate ia, “ʻI heʻeku hoko leva ki he tuʻa kolo, teu mafao atu hoku nima kia Sihova; pea ʻe tuku leva ʻae mana, pea ʻe ʻikai kei tō ʻae ʻuha maka: koeʻuhi ke ke ʻilo ai ʻoku ʻo Sihova ʻa māmani. ");
INSERT INTO ton_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ka ko koe mo hoʻo kau tamaioʻeiki, ʻoku ou ʻilo ʻe ʻikai te mou manavahē kia Sihova ko e ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Pea naʻe teʻia ʻae falakesi mo e paʻale he naʻe fua ʻae paʻale, pea kamata fua mo e falakesi. ");
INSERT INTO ton_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ka ko e uite mo e lai naʻe ʻikai teʻia, he naʻe teʻeki ai tupu hake. ");
INSERT INTO ton_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Pea ʻalu ʻa Mōsese meia Felo ki he tuaʻā kolo, ʻo ne mafao atu hono nima kia Sihova: pea naʻe tuku ai ʻae mana mo e ʻuha maka, pea naʻe ʻikai kei tō ʻae ʻuha ki he kelekele. ");
INSERT INTO ton_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pea ʻi he mamata ʻa Felo kuo matuʻu ʻae ʻuha mo e ʻuha maka, mo e mana, naʻe toe fai angahala ia, ʻo fakafefeka hono loto, ʻaia mo ʻene kau tamaioʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pea naʻe fefeka ʻae loto ʻo Felo, pea naʻe ʻikai te ne tuku ʻae fānau ʻa ʻIsileli ke ʻalu: ʻo hangē ko e folofola ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu kia Felo: he kuo u fakafefeka hono loto, mo e loto ʻo ʻene kau tamaioʻeiki, koeʻuhi ke u fakahā ʻa ʻeku ngaahi fakaʻilonga ni ʻi hono ʻao: ");
INSERT INTO ton_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Pea koeʻuhi ke ke tala ʻi he telinga ʻo ho foha, mo e fānau ʻa ho foha, ʻae ngaahi meʻa kuo u fai ʻi ʻIsipite, mo ʻeku ngaahi fakaʻilonga, ʻaia kuo u fai ʻi honau ʻao koeʻuhi ke mou ʻilo ko au ko Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Pea naʻe ʻalu ʻa Mōsese mo ʻElone kia Felo, ʻo na pehē kiate ia, “ʻOku pehē mai ʻa Sihova ko e ʻOtua ʻoe kakai Hepelū, ‘ʻE tuku afe hoʻo taʻefakavaivai koe ʻi hoku ʻao? Tuku hoku kakai ke ʻalu, koeʻuhi ke nau tauhi au.’ ");
INSERT INTO ton_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Pea kapau te ke taʻofi ʻae tukuange ʻo hoku kakai, vakai, te u ʻomi ʻae fanga heʻe ki ho fonua ʻapongipongi: ");
INSERT INTO ton_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Pea te nau ʻufiʻufi ʻae funga ʻoe fonua, pea ʻe ʻikai faʻa mamata ʻe ha tokotaha ki he kelekele: pea te nau kai ʻo ʻosi hono toe ʻo ia naʻe hao, ʻaia naʻe toe ʻiate kimoutolu mei he ʻuha maka, pea te nau kai ʻae ʻakau kotoa pē ʻoku tupu ʻi he ngoue kiate kimoutolu: ");
INSERT INTO ton_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Pea te nau fakapito ho ngaahi fale, mo e ngaahi fale ʻo hoʻo kau tamaioʻeiki, mo e ngaahi fale ʻoe kakai ʻIsipite kotoa pē; ʻaia naʻe ʻikai mamata ai ʻa hoʻo ngaahi tamai, pe ko e nau ngaahi kui, talu ʻae ʻaho naʻa nau ʻi he fonua ʻo aʻu ki he ʻaho ni. Pea naʻe tafoki ia ʻo ʻalu mei he ʻao ʻo Felo.” ");
INSERT INTO ton_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pea pehē ʻe he kau tamaioʻeiki ʻa Felo kiate ia, “ʻE fēfeeʻi hono fuoloa mo e kei ʻiate kitautolu ʻae tangata ni ko e tauhele? Tuku ʻae kau tangata ke ʻalu, koeʻuhi ke nau tauhi ʻa Sihova ko honau ʻOtua: ʻoku teʻeki ai te ke ʻilo kuo ʻauha ʻa ʻIsipite?” ");
INSERT INTO ton_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Pea naʻe toe omi ʻa Mōsese mo ʻElone kia Felo: pea pehē ʻe ia kiate kinaua, “ʻAlu ʻo tauhi ʻa Sihova ko homou ʻOtua: ka ko hai ʻakinautolu ʻe ʻalu? ");
INSERT INTO ton_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Pea pehē ʻe Mōsese, Te mau ʻalu mo e mau fānau siʻi mo e mau mātuʻa, mo homau ngaahi foha, mo homau ngaahi ʻofefine, ʻa ʻemau fanga sipi mo ʻemau fanga manu lalahi: he ʻoku tonu ke mau fai ha kātoanga kia Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pea pehē ʻe ia kiate kinaua, “Ke ʻiate kimoutolu pehē pe ʻa Sihova, ʻo kapau te u tuku ʻakimoutolu ke ʻalu mo hoʻomou fānau iiki: vakai ki ai; he ʻoku ʻi homou ʻao ʻae kovi.” ");
INSERT INTO ton_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","“ʻE ʻikai pehē: ka e ʻalu pe ʻakimoutolu ʻoku tangata, pea tauhi ʻa Sihova; he ko ia ne mou kole ki ai.” Pea naʻe kapusi ai ʻakinaua mei he ʻao ʻo Felo. ");
INSERT INTO ton_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Mafao atu ho nima ki he fonua ko ʻIsipite ki he fanga heʻe, koeʻuhi ke nau ʻalu hake ki he fonua ko ʻIsipite, ʻo kai ʻae ʻakau kotoa pē ʻoe fonua, ʻio, ʻaia kotoa pē naʻe hao ʻi he ʻuha maka.” ");
INSERT INTO ton_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Pea naʻe mafao atu ʻae tokotoko ʻo Mōsese, ki he fonua ko ʻIsipite, pea naʻe ʻomi ʻe Sihova ʻae matangi hahake ki he fonua ʻi he ʻaho ko ia, pea mo e pō kotoa ko ia; pea kuo pongipongi ai, naʻe ʻomi ʻe he matangi hahake ʻae fanga heʻe. ");
INSERT INTO ton_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Pea naʻe ʻalu hake ʻae fanga heʻe ki he potu fonua kotoa pē ʻo ʻIsipite, ʻo tuʻu ʻi he ngaahi potu kotoa pē ʻo ʻIsipite; ko e meʻa fakamamahi ʻaupito: naʻe ʻikai ha fanga heʻe pehē ʻi muʻa, pea ʻe ʻikai ha toe heʻe pehē ʻamui. ");
INSERT INTO ton_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","He naʻa nau ʻufiʻufi ʻae funga fonua kotoa pē, ko ia naʻe fakapoʻuli ai ʻae fonua: pea naʻe kai ʻae ʻakau kotoa pē ʻoe fonua, mo e fua kotoa pē ʻoe ngaahi ʻakau naʻe toe ʻi he ʻuha maka: pea naʻe ʻikai ha meʻa mata ʻe toe ʻi he ngaahi ʻakau pe ʻi he ngaahi louʻakau ʻoe ngoue, ʻi he fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","¶ Pea naʻe fekau fakatoʻotoʻo ʻe Felo ke haʻu ʻa Mōsese mo ʻElone; ʻo ne pehē, “Kuo u fai angahala kia Sihova, ko homou ʻOtua, pea mo kimoua. ");
INSERT INTO ton_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Pea ko ʻeni, ʻoku ou kole kiate koe, fakamolemole ʻeku angahala ʻi he meʻa ni pe taha, pea fakakolekole kia Sihova ko homou ʻOtua, koeʻuhi ke ne ʻave pe ʻiate au ʻae mate ni.” ");
INSERT INTO ton_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Pea naʻe ʻalu ia mei he ʻao ʻo Felo, ʻo hū kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Pea liliu ʻe Sihova ʻae fuʻu matangi mālohi mei lulunga, ʻaia naʻa ne ʻave ʻae fanga heʻe, ʻo lī ia ki he tahi Kulokula; naʻe ʻikai ke toe ha heʻe ʻe taha ʻi he potu fonua kotoa pē ʻo ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ka naʻe fakafefeka ʻe Sihova ʻae loto ʻo Felo, pea naʻe ʻikai te ne tuku ʻae fānau ʻa ʻIsileli ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Mafao hake ho nima ki langi, koeʻuhi he hoko ai ʻae fakapoʻuli ki he fonua kotoa pē ʻo ʻIsipite, ʻio, ʻae poʻuli matolu.” ");
INSERT INTO ton_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Pea naʻe mafao hake hono nima ʻe Mōsese ki langi; pea hoko ʻae poʻuli matolu ʻi he fonua kotoa pē ʻo ʻIsipite ʻi he ʻaho ʻe tolu: ");
INSERT INTO ton_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Naʻe ʻikai te nau femātaaki ʻakinautolu, pea naʻe ʻikai tuʻu hake ha tokotaha mei hono potu ʻi he ʻaho ʻe tolu: ka naʻe māmangia ʻae fānau ʻa ʻIsileli ʻi honau ngaahi nofoʻanga. ");
INSERT INTO ton_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","¶ Pea naʻe ui ʻe Felo kia Mōsese, ʻo ne pehē, “Mou ʻalu, ʻo tauhi ʻa Sihova: kae tuku hoʻomou fanga sipi, mo e fanga manu lalahi; kae ʻalu hoʻomou ngaahi fānau siʻi mo kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pea naʻe pehē ʻe Mōsese, “Ka te ke tuku mai ʻae ngaahi feilaulau foki mo e ngaahi feilaulau tutu, koeʻuhi ke mau feilaulau ʻaki kia Sihova ko homau ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","‌ʻE ʻalu ʻemau fanga manu mo kimautolu ʻe ʻikai tuku ki mui ha pesipesi pe taha koeʻuhi te mau toʻo mei ai ʻaia te mau tauhi ʻaki ʻa Sihova ko homau ʻOtua: pea ʻoku ʻikai te mau ʻilo pau, ʻaia te mau tauhi ʻaki ʻa Sihova, kaeʻoua ke mau hoko ki ai.” ");
INSERT INTO ton_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","¶ Ka naʻe fakafefeka ʻe Sihova ʻae loto ʻo Felo, pea naʻe ʻikai te ne tukuange ʻakinautolu ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pea talaange ʻe Felo kiate ia, “ʻAlu koe ʻiate au, vakai kiate koe, ʻoua naʻa ke toe sio ki hoku mata; he ko e ʻaho ko ia te ke mamata ai ki hoku mata te ke mate.” ");
INSERT INTO ton_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Pea pehē ʻe Mōsese, “Kuo ke lea lelei, ʻe ʻikai te u toe mamata ki ho mata.” ");
INSERT INTO ton_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻOku toe taha pe ʻae tautea te u ʻomi kia Felo mo ʻIsipite; hili ia, te ne tuku ke mou ʻalu ʻi heni: pea ka fekau ia ke mou ʻalu, ko e moʻoni te ne kapusi ʻakimoutolu ke ʻalu kotoa pē ʻi heni. ");
INSERT INTO ton_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ke ke lea ʻi he telinga ʻoe kakai, pea tuku ke nau kole taki taha ʻae tangata ʻi hono kaungāʻapi, mo e fefine kotoa pē ʻi hono kaungāʻapi, ʻae ngaahi teunga siliva, mo e teunga koula.” ");
INSERT INTO ton_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Pea naʻe fakaʻofeina ʻe Sihova ʻae kakai ʻi he ʻao ʻoe kakai ʻIsipite. Kae muʻa hake foki, naʻe ongoongo lahi ʻaupito ʻae tangata ko Mōsese ʻi he fonua ko ʻIsipite, ʻi he ʻao ʻoe kau tamaioʻeiki ʻa Felo, pea mo e ʻao ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Pea pehē ʻe Mōsese, “ʻOku pehē mai ʻa Sihova, ‘ʻE feʻunga mo e tuʻuapō te u ʻalu atu ki he lotolotonga ʻo ʻIsipite: ");
INSERT INTO ton_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Pea ʻe mate ʻae ʻuluaki fānau kotoa pē ʻi he fonua ko ʻIsipite, mei he ʻuluaki fānau ʻa Felo ʻoku nofo ʻi hono nofoʻanga, ʻo aʻu ki he ʻuluaki fānau ʻae kaunanga ʻoku muimui ʻi he meʻa momosi; pea mo e ʻuluaki fānau kotoa pē ʻoe fanga manu. ");
INSERT INTO ton_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Pea ʻe ai ʻae tangi lahi ʻi he ngaahi potu kotoa pē ʻoe fonua ko ʻIsipite, ʻaia naʻe ʻikai hano tatau ʻi muʻa, pea ʻe ʻikai toe ai ha meʻa pehē. ");
INSERT INTO ton_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ka ko e fānau ʻa ʻIsileli, ʻe ʻikai ha kulī ʻe taha ke ne ueʻi hono ʻelelo ki ai, ki ha tangata pe ki ha manu: koeʻuhi ke mou ʻilo kuo fai kehekehe ʻe Sihova ki he kakai ʻIsipite mo e kakai ʻIsileli.’” ");
INSERT INTO ton_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Pea ko kinautolu ni ko hoʻo kau tamaioʻeiki kotoa pē, te nau ʻalu hifo kiate au, ʻonau punou hifo ʻakinautolu kiate au, ʻo pehē, “Ke ke ʻalu koe, pea mo e kakai kotoa pē ʻoku muimui ʻiate koe; pea hili ia, te u ʻalu kituaʻā.” Pea naʻe ʻalu ia kituaʻā meia Felo ʻoku ʻita lahi. ");
INSERT INTO ton_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻE ʻikai tokanga ʻa Felo kiate kimoua: koeʻuhi ke fakalahi ai ʻeku ngaahi meʻa mana ʻi he fonua ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Pea naʻe fai ʻe Mōsese mo ʻElone ʻae ngaahi mana ni kotoa pē ʻi he ʻao ʻo Felo: pea naʻe fakafefeka ʻe Sihova ʻae loto ʻo Felo, ko ia naʻe ʻikai te ne tukuange ʻae fānau ʻa ʻIsileli ke ʻalu mei hono fonua. ");
INSERT INTO ton_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone ʻi he fonua ko ʻIsipite, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ko e māhina ni ʻe ʻiate kimoutolu ko e kamataʻanga ʻoe ngaahi māhina: ʻe ʻiate kimoutolu ia ko e ʻuluaki māhina ʻi he taʻu.” ");
INSERT INTO ton_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","¶ Mo lea ki he kakai fakataha kotoa pē ʻo ʻIsileli, ʻo pehē, “ʻI hono hongofulu ʻoe ʻaho ʻoe māhina ni, te nau toʻo kiate kinautolu taki taha ʻe he tangata ha lami, ʻo fakatatau ki he fale ʻoe ngaahi tamai, ko e lami ki he fale: ");
INSERT INTO ton_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Pea kapau ʻoku tokosiʻi ʻae kau nofoʻanga ki ha lami, ke toʻo ia ʻe ia mo hono kaungāʻapi ʻoku na fale vāofi ʻo fakatatau ki hono lau ʻoe kakai; ko e tangata kotoa pē ʻe kau ia ʻo fakatatau mo ʻene kai ʻi homou lau ki he lami. ");
INSERT INTO ton_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","‌ʻE haohaoa ʻa hoʻomou lami taʻehanomele, ko e manu tangata ʻi hono ʻuluaki taʻu: te mou toʻo ia mei he fanga sipi, pe mei he fanga kosi. ");
INSERT INTO ton_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Pea te mou talitalifaki ʻaki ia ʻo aʻu ki hono hongofulu ma fā ʻoe ʻaho ʻoe māhina ko ia: pea ʻe tāmateʻi ia ʻe he fakataha kotoa pē ʻae fānau ʻa ʻIsileli ʻi he efiafi poʻuli. ");
INSERT INTO ton_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Pea te nau ʻave ʻa hono toto ʻo vali ʻaki ia ʻae pou ʻe ua, mo e ʻakau fakalava ʻi he ʻulu matapā ʻoe ngaahi fale ʻoku nau kai ai ia. ");
INSERT INTO ton_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Pea te nau kai hono kakano ʻi he pō ko ia, kuo tunu ʻaki ʻae afi, mo e mā taʻefakalēvani; te nau kai ia mo e ngaahi louʻakau kona. ");
INSERT INTO ton_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","‌ʻOua naʻa kai ʻota ia, pe haka ʻi he vai, ka ko e tunu pe ʻaki ʻae afi: ko hono ʻulu, mo e kau vaʻe, mo hono toʻotoʻonga. ");
INSERT INTO ton_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pea ʻoua naʻa fakatoe hano potu ki he ʻapongipongi; pea ko ia ʻoku toe ki he ʻapongipongi te mou tutu ʻaki ʻae afi. ");
INSERT INTO ton_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","¶ Pea te mou kai pehē ia; kuo nonoʻo homou vala, kuo ʻai homou topuvaʻe ʻi homou vaʻe, mo homou tokotoko ʻi homou nima; pea te mou kai fakatoʻotoʻo ia; ko e Lakaatu ia ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“He te u ʻalu ʻo ʻasi ʻi he fonua ʻo ʻIsipite he poōni, pea te u taaʻi ʻae ʻuluaki fānau kotoa pē ʻi he fonua ko ʻIsipite, ʻae tangata mo e manu; pea ko e ngaahi ʻotua ʻo ʻIsipite te u fai ʻeku fakaʻauha ki ai: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Pea ko e toto, ʻe hoko ko e fakaʻilonga ia kiate kimoutolu ʻi he ngaahi fale ʻoku mou ʻi ai: ʻo kau ka mamata ki he toto, teu laka atu ʻiate kimoutolu, pea ʻe ʻikai ha fakaʻauha kiate kimoutolu ke mou mate ai ʻo kau ka taaʻi ʻae fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Pea ko e ʻaho ni ʻe ʻiate kimoutolu ke fakamanatu: pea te mou tauhi ia ʻo fai ʻae kātoanga kia Sihova ʻi homou ngaahi toʻutangata tuku fakaholo: te mou tauhi ia ko e kātoanga ʻi he tuʻutuʻuni taʻengata.” ");
INSERT INTO ton_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Ko e ʻaho ʻe fitu te mou kai mā taʻefakalēvani; ʻio, ʻi hono ʻuluaki ʻaho te mou tukuange ʻae lēvani mei homou ngaahi fale: he ko ia ʻoku kai ha mā kuo fakalēvani mei he ʻuluaki ʻaho ʻo aʻu ki hono fitu ʻoe ʻaho, ʻe motuhi ia mei ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Pea ʻe fai ʻi he ʻuluaki ʻaho ʻae fakataha māʻoniʻoni, pea ʻe fai ʻekimoutolu ʻi hono fitu ʻoe ʻaho ʻae fakataha māʻoniʻoni: ʻe ʻikai ha ngāue ʻe taha ʻe fai ʻi ai, ka koeʻuhi ko e kai ʻe he tangata kotoa pē, ko ia pe ʻe ngofua ke fai. ");
INSERT INTO ton_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Pea te mou tokanga ki he kātoanga ʻoe mā taʻefakalēvani; koeʻuhi ʻi he ʻaho totonu ko ʻeni, kuo u ʻomi ai homou ngaahi kautau mei he fonua ko ʻIsipite: ko ia te mou fakaʻilongaʻi ʻae ʻaho ni ʻi homou toʻutangata kotoa pē ʻi he tuʻutuʻuni taʻengata. ");
INSERT INTO ton_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","¶ ʻI he ʻuluaki māhina, ʻi hono hongofulu ma fā ʻoe ʻaho ʻoe māhina, ʻi he efiafi, te mou kai ʻae mā taʻefakalēvani, ʻo aʻu ki hono uofulu ma taha ʻoe ʻaho ʻoe māhina ʻi he efiafi. ");
INSERT INTO ton_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","‌ʻI he ʻaho ʻe fitu ʻe ʻikai ʻilo ha lēvani ʻi homou ngaahi fale; he ko ia ʻoku kai ʻaia kuo fakalēvani, ʻe motuhi ia mei he fakataha ʻo ʻIsileli, pe ko ha muli ia, pe ko ha tupu ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","‌ʻE ʻikai te mou kai ha meʻa kuo ʻi ai ʻae lēvani; ʻi homou ngaahi nofoʻanga kotoa pē te mou kai mā taʻefakalēvani. ");
INSERT INTO ton_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","¶ Pea naʻe toki fekau ʻe Mōsese ke haʻu ʻae kau mātuʻa kotoa pē ʻo ʻIsileli, ʻo ne pehē kiate kinautolu, “Vaheʻi ʻo toʻo kiate kimoutolu ʻae lami ʻo fakatatau ki homou ngaahi kau nofoʻanga ʻo tāmateʻi ʻae Lakaatu. ");
INSERT INTO ton_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Pea te mou toʻo ʻae ʻū ʻisope ʻo unu ia ki he toto ʻoku ʻi he ipu, ʻo vali ʻae potu fakalava mo e pou ʻe ua ʻoe matapā ʻaki ʻae toto ʻaia ʻoku ʻi he ipu; pea ʻe ʻikai ʻalu ha tokotaha ʻi he matapā ʻo hono fale kituaʻā kaeʻoua ke pongipongi hake. ");
INSERT INTO ton_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Koeʻuhi ʻe hāʻele atu ʻa Sihova ke taaʻi ʻae kakai ʻIsipite: pea ka ʻafio ia ki he toto ʻi he potu fakalava mo e pou ʻe ua, ʻe Lakaatu ʻa Sihova ʻi he matapā, pea ʻe ʻikai te ne tuku ʻae fakaʻauha ke hū ki homou fale ke taaʻi ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Pea te mou tokanga maʻu ki he meʻa ni, ko e fekau kiate koe mo ho ngaahi foha ʻo taʻengata. ");
INSERT INTO ton_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pea ʻe pehē, ʻoka mou ka hoko atu ki he fonua ʻaia ʻe foaki ʻe Sihova kiate kimoutolu, ʻo hangē ko ʻene talaʻofa, te mou fai ʻae ngāue ni. ");
INSERT INTO ton_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Pea ʻe hoko ʻo pehē, ʻoka fehuʻi hoʻomou fānau kiate kimoutolu, ‘Ko e hā hono ʻuhinga ʻoe ngāue ni?’ ");
INSERT INTO ton_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Te mou pehē: ‘Ko e feilaulau ia ʻoe Lakaatu ʻa Sihova, ʻaia naʻa ne laka atu ʻi he ngaahi fale ʻoe fānau ʻa ʻIsileli ʻi ʻIsipite, ʻi heʻene taaʻi ʻae kakai ʻIsipite, ʻo ne fakamoʻui homau fale. Pea naʻe fakapunou hifo honau ʻulu ʻe he kakai ʻo hū. ");
INSERT INTO ton_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Pea naʻe ʻalu ʻae fānau ʻa ʻIsileli, ʻo fai ʻo hangē ko e fekau ʻa Sihova kia Mōsese mo ʻElone, naʻe pehē ʻenau fai. ");
INSERT INTO ton_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","¶ Pea naʻe hoko ʻo pehē, ʻi heʻene tuʻuapō, naʻe taaʻi ʻe Sihova ʻae ʻuluaki fānau kotoa pē ʻi he fonua ko ʻIsipite, mei he ʻuluaki fānau ʻa Felo naʻe nofo ʻi he nofoʻanga fakatuʻi ʻo aʻu ki he ʻuluaki fānau ʻae pōpula ʻi he fale fakapōpula; pea mo e ʻuluaki tupu kotoa pē ʻoe fanga manu. ");
INSERT INTO ton_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pea naʻe tuʻu hake ʻa Felo ʻi he pō, ʻaia mo ʻene kau tamaioʻeiki kotoa pē, mo e kakai ʻIsipite kotoa pē; pea naʻe ai ʻae tangi lahi ʻi ʻIsipite: he naʻe ʻikai hala ha fale ʻi he taʻeʻiai-ha-taha kuo mate. ");
INSERT INTO ton_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","¶ Pea naʻe fekau ʻe ia ʻi he poʻuli ke haʻu ʻa Mōsese mo ʻElone, ʻo ne pehē, Tuʻu hake pea mou ʻalu atu mei hoku kakai, ʻakimoua pea mo e fānau ʻa ʻIsileli: pea mou ʻalu ʻo tauhi ʻa Sihova, ʻo hangē ko hoʻomou lea. ");
INSERT INTO ton_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","‌ʻAve mo hoʻomou ngaahi fanga sipi, mo hoʻomou fanga manu, ʻo hangē ko hoʻomou tala, pea mou ʻalu; pea mou tāpuaki foki au. ");
INSERT INTO ton_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Pea naʻe fai mālohi ʻe he kakai ʻIsipite ki he kakai, koeʻuhi ke nau tukuange fakatoʻotoʻo ʻakinautolu ke ʻalu mei he fonua; he naʻa nau pehē, Kuo tau mate kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Pea naʻe toʻo ʻenau mā ʻe he kakai ʻi he teʻeki ai ʻae lēvani; mo e nau ngaahi natuʻanga mā, kuo haʻi fakataha mo e nau ngaahi kofu ki honau uma. ");
INSERT INTO ton_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Pea naʻe fai ʻe he fānau ʻa ʻIsileli ʻo fakatatau ki he lea ʻa Mōsese; naʻa nau kole mei he kakai ʻIsipite ʻae ngaahi teunga siliva, mo e teunga koula, mo e ngaahi kofu; ");
INSERT INTO ton_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Pea naʻe fakaʻofeina ʻe Sihova ʻae kakai ʻi he ʻao ʻoe kakai ʻIsipite, ko ia naʻa nau tuku ai kiate kinautolu ʻae ngaahi meʻa. Pea naʻa nau fakamasivaʻi ʻae kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","¶ Pea fononga ai ʻae fānau ʻa ʻIsileli mei Lamisisi ki Sukote, ko e kau tangata hāʻele, ko e toko ono kilu nai, kaeʻumaʻā ʻae fānau. ");
INSERT INTO ton_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Pea naʻe ʻalu mo kinautolu ʻae ngaahi kakai kehe tokolahi: mo e ngaahi fanga sipi mo e fanga manu, ʻae fuʻu fanga manu lahi. ");
INSERT INTO ton_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Pea naʻa nau taʻo ʻae ngaahi foʻi mā taʻehalēvani, ʻi he mā naʻa nau ʻomi mei ʻIsipite, he naʻe ʻikai ai ʻae lēvani; koeʻuhi naʻe kapusi ʻakinautolu mei ʻIsipite, pea naʻe ʻikai te nau faʻa tatali, pea naʻe teʻeki te nau teuteu haʻanau meʻakai. ");
INSERT INTO ton_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","¶ Pea ko e nofo ʻāunofo ʻae fānau ʻa ʻIsileli, ʻaia naʻe nofo ʻi ʻIsipite, ko e taʻu ʻe fāngeau ma tolungofolu. ");
INSERT INTO ton_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Pea hili ʻae taʻu ʻe fāngeau ma tolungofulu, pea hoko ʻo pehē, ʻio, naʻe hoko ʻi he ʻaho pe ko ia, ʻae ʻalu ai ʻae ngaahi kautau ʻa Sihova mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ko e pō ko ia ke tokanga lahi ki ai maʻa Sihova koeʻuhi ko ʻene ʻomi ʻakinautolu mei he fonua ko ʻIsipite: ko e pō eni ia ʻo Sihova ke fakamanatu ki ai ʻe he fānau ʻa ʻIsileli, ʻi honau toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, “Ko eni ʻae tuʻutuʻuni ʻoe Lakaatu: ʻE ʻikai kai ia ʻe ha muli: ");
INSERT INTO ton_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ka ko e tamaioʻeiki ʻae tangata kotoa pē kuo fakatauʻaki ʻae paʻanga, hili hao kamu ia, ʻe toki kai ia ʻe ia. ");
INSERT INTO ton_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","‌ʻE ʻikai kai ia ʻe ha muli, pe ha tamaioʻeiki ngāue totongi. ");
INSERT INTO ton_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","‌ʻE kai ia ʻi he fale pe taha: ʻoua naʻa ke ʻave kituaʻā mei he fale ha konga siʻi ʻoe kakano; pea ʻoua naʻa mou fesiʻi hano hui. ");
INSERT INTO ton_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","‌ʻE fai ia ʻe he fakataha kotoa pē ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Pea ka ʻāunofo ha muli kiate koe, pea loto ia ke fai ʻae Lakaatu kia Sihova, tuku ke kamu ʻene kakai tangata kotoa pē, pea ʻe toki ngofua ke haʻu ia ʻo fai: pea ʻe tatau ia mo ha tokotaha naʻe tupu ʻi he fonua: ʻe ʻikai kai ia ʻe ha tokotaha ʻoku taʻekamu. ");
INSERT INTO ton_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","‌ʻE ai ʻae fono pe taha kiate ia ʻoku tupu ʻi he fonua, pea ki he muli ʻoku ʻāunofo ʻiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Pea naʻe fai pehē ʻe he fānau kotoa pē ʻa ʻIsileli; ʻo hangē ko e fekau ʻa Sihova kia Mōsese mo ʻElone, naʻe pehē ʻenau fai. ");
INSERT INTO ton_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Pea naʻe hoko ʻi he pō pe ko ia, ʻae ʻomi ʻe Sihova ʻae fānau ʻe ʻIsileli kituaʻā mei he fonua ko ʻIsipite ʻi honau ngaahi kongakau. ");
INSERT INTO ton_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Fakatapui maʻaku ʻae ʻuluaki fānau kotoa pē, ko ia kotoa pē ʻoku fakaava ʻae mānava ʻi he fānau ʻa ʻIsileli, ʻi he tangata mo e manu: ʻoku ʻaʻaku ia.” ");
INSERT INTO ton_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","¶ Pea pehē ʻe Mōsese ki he kakai, “Manatu ki he ʻaho ni, ʻa ia, kuo mou haʻu ai mei ʻIsipite, mei he fale fakapōpula: he kuo ʻomi ʻakimoutolu ʻe Sihova mei he potu ni ʻi he nima mālohi: ʻoua naʻa kai ha mā kuo fakalēvani. ");
INSERT INTO ton_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Kuo mou hao mai he ʻaho ni ʻi he māhina ko ʻApipi. ");
INSERT INTO ton_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","¶ Pea ka ʻomi koe ʻe Sihova ki he fonua ʻoe kau Kēnani, mo e kau Heti, mo e kau ʻAmoli, mo e kau Hevi, mo e kau Sepusi, ʻaia naʻa ne fuakava ai ki hoʻo ngaahi tamai ke foaki kiate koe, ʻae fonua mahu tāfea ʻi he huʻahuhu mo e honi, te ke fai ʻae ngāue ni ʻi he māhina ni. ");
INSERT INTO ton_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","‌ʻI he ʻaho ʻe fitu te ke kai mā taʻeaihalēvani, pea ʻe fai ʻi hono fitu ʻoe ʻaho ʻae kātoanga kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","‌ʻE kai ʻae mā taʻefakalēvani ʻi he ʻaho ʻe fitu; pea ʻe ʻikai ha mā kuo ʻai ki ai ha lēvani ʻe ʻilo ʻiate koe, pea ʻe ʻikai ʻilo ha lēvani ʻiate koe ʻi hoʻo ngaahi potu kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","¶ Pea te ke fakahā ki ho foha ʻi he ʻaho ko ia, ʻo pehē, ‘ʻOku fai ʻeni, koeʻuhi ko e meʻa ko ia ʻaia naʻe fai ʻe Sihova kiate au, ʻi heʻeku hao mei ʻIsipite.’ ");
INSERT INTO ton_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Pea ʻe ʻiate koe ia ko e fakaʻilonga ʻi ho nima, pea ko e meʻa fakamanatu ʻi he vahaʻa ʻo ho mata, koeʻuhi ke ʻi ho ngutu ʻae fono ʻa Sihova: he kuo ʻomi koe ʻe Sihova mei ʻIsipite ʻi he nima mālohi. ");
INSERT INTO ton_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ko ia ke ke tauhi ai ʻae fekau ni ʻi hono faʻahitaʻu tukufakaholo ʻi he taʻu kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","¶ “Pea ʻe pehē, ʻi he ʻomi koe ʻe Sihova ki he fonua ʻoe kau Kēnani, ʻo hangē ko ʻene fuakava kiate koe mo hoʻo ngaahi tamai, ʻo ne foaki ia kiate koe, ");
INSERT INTO ton_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Te ke vaheʻi maʻa Sihova ʻaia kotoa pē ʻoku fakaava ʻae manāva, pea mo e ʻuluaki fānau kotoa pē ʻoku tupu ʻi he manu ʻoku ke maʻu: ko e manu tangata ʻoku ʻa Sihova ia. ");
INSERT INTO ton_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Pea ko e ʻuluaki fānau ʻae ʻasi te ke huhuʻi ʻaki ʻae lami: pea kapau ʻe ʻikai te ke huhuʻi ia, te ke fesiʻi hono kia: pea ko e ʻuluaki fānau kotoa pē ʻi hoʻo fānau tangata te ke huhuʻi. ");
INSERT INTO ton_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","¶ Pea ʻe pehē ʻoka fehuʻi ʻe ho foha kiate koe ʻamui, ʻo pehē, Ko e hā eni? Te ke tala ʻo pehē kiate ia, naʻe ʻomi ʻakimautolu ʻe Sihova mei ʻIsipite, mei he fale fakapōpula ʻi he nima mālohi. ");
INSERT INTO ton_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pea ʻi he ʻikai fie tuku mai ʻakimautolu ʻe Felo, naʻe tāmateʻi ʻe Sihova ʻae ʻuluaki fānau kotoa pē ʻi he fonua ko ʻIsipite, ʻae ʻuluaki fānau ʻae tangata mo e ʻuluaki fānau ʻae manu: ko ia ʻoku ou feilaulau ʻaki ai kia Sihova ʻae fānau tangata kotoa pē, ʻoku fakaava ʻae manāva: ka ko e ʻuluaki tupu kotoa pē ʻo ʻeku fānau ʻoku ou huhuʻi. ");
INSERT INTO ton_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Pea ʻe hoko ia ko e fakaʻilonga ki ho nima, mo e meʻa fakamanatu ki ho laʻē: he naʻe ʻomi ʻakimautolu mei ʻIsipite ʻe Sihova ʻi he nima mālohi.” ");
INSERT INTO ton_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","¶ Pea ko ʻeni, ʻi he tukuange ʻae kakai ʻe Felo ke nau ʻalu, naʻe ʻikai tataki ʻakinautolu ʻe he ʻOtua ʻi he hala ʻoe fonua ʻoe kau Filisitia, neongo hono ofi ia; he naʻe pehē ʻe he ʻOtua, Telia naʻa fakatomala ʻae kakai ʻi heʻenau mamata ki he tau, pea te nau foki ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ka naʻe tataki ʻe he ʻOtua ʻae kakai ke afe ʻi he hala ʻoe toafa ʻoe tahi Kulokula: pea naʻe hiki teuteu tau pe ʻae fānau ʻa ʻIsileli mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Pea naʻe hikitanga ʻe Mōsese ʻae hui ʻo Siosefa ke ʻave: he naʻa ne fakafuakavaʻi totonu ʻae fānau ʻa ʻIsileli, ʻo pehē, ‘Ko e moʻoni ʻe ʻaʻahi ʻae ʻOtua kiate kimoutolu; pea te mou hikitanga hoku hui ʻo ʻave mei heni mo kimoutolu.’ ");
INSERT INTO ton_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","¶ Pea naʻa nau fononga mei Sukote, ʻonau ʻapitanga, ʻi ʻEtami, ʻi he veʻe toafa. ");
INSERT INTO ton_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Pea naʻe hāʻele ʻo muʻomuʻa ʻiate kinautolu ʻa Sihova ʻi he pou ʻao ʻi he ʻaho, ke tataki ʻakinautolu ʻi he hala: pea mo e pou afi ʻi he poʻuli, ke fakamaama kiate kinautolu; ke nau ʻalu ʻaho, mo ʻalu ʻi he poʻuli: ");
INSERT INTO ton_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Naʻe ʻikai te ne hiki ʻo ʻave ʻae pou ʻao ʻi he ʻaho, pe ko e pou afi ʻi he poʻuli mei he ʻao ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehēange, ");
INSERT INTO ton_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Tala ki he fānau ʻa ʻIsileli ke nau afe ʻo ʻapitanga ʻi he ʻao ʻo Piheloti ʻi he vahaʻa ʻo Mikitoli mo e tahi, ʻo hanga tonu ki Peali-sefoni: mou ʻapitanga ʻi he feangai mo ia ʻo ofi ki tahi. ");
INSERT INTO ton_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Koeʻuhi ʻe lea ʻa Felo ki he fānau ʻa ʻIsileli, Kuo nau ʻefihia ʻi he fonua, kuo punusia ʻakinautolu ʻe he toafa. ");
INSERT INTO ton_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Pea te u fakafefeka ʻae loto ʻo Felo, koeʻuhi ke ne tuli ʻakinautolu; pea te u ongolelei ai ʻia Felo mo ʻene kautau kotoa pē; ke ʻilo ai ʻe he kakai ʻIsipite ko Sihova au.” Pea naʻa nau fai ia. ");
INSERT INTO ton_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","¶ Pea naʻe tala ki he tuʻi ʻo ʻIsipite kuo hola ʻae kakai: pea naʻe kovi leva ʻae loto ʻo Felo, mo ʻene kau tamaioʻeiki ki he kakai, pea nau pehē, “Ko e hā kuo tau fai ai ʻae meʻa ni, ke tuku ʻa ʻIsileli ke ʻalu mei heʻenau tauhi ʻakitautolu?” ");
INSERT INTO ton_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pea naʻa ne teuʻi leva ʻene saliote, ʻo ne ʻave ʻa hono kakai mo ia: ");
INSERT INTO ton_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Pea ne ʻave ʻae saliote fili ʻe onongeau, mo e ngaahi saliote kotoa pē ʻo ʻIsipite pea naʻe taki taha kotoa pē ʻa hono ʻeikitau. ");
INSERT INTO ton_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pea naʻe fakafefeka ʻe Sihova ʻae loto ʻo Felo ko e tuʻi ʻo ʻIsipite, pea naʻa ne tuli ki he fānau ʻa ʻIsileli: pea naʻe ʻalu atu ʻae fānau ʻa ʻIsileli mo e nima māʻolunga. ");
INSERT INTO ton_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ka naʻe tuli ʻakinautolu ʻe he kakai ʻIsipite, ko e fanga hoosi kotoa pē, mo e ngaahi saliote ʻo Felo, mo ʻene kau tangata heka hoosi, mo ʻene tau, ʻonau maʻu ʻakinautolu ʻi heʻenau ʻapitanga ʻo ofi ki tahi, ʻi he potu ʻo Piheloti, ʻi he ʻao ʻo Peali-sefoni. ");
INSERT INTO ton_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","¶ Pea ʻi he ʻunuʻunu ʻo ofi ʻa Felo, pea hanga hake ʻae mata ʻoe fānau ʻa ʻIsileli, pea vakai, ʻoku tuli ʻakinautolu ʻe he kakai ʻIsipite; naʻa nau manavahē lahi: pea tangi kalanga ʻae fānau ʻa ʻIsileli kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Pea naʻa nau pehē kia Mōsese, ‘Naʻe ʻikai ha tanuʻanga ʻi ʻIsipite, ko ia kuo ke ʻomi ai ʻakimautolu ke mate ʻi he toafa? Ko e hā kuo ke fai pehē ai kiate kimautolu, ke fetuku ʻakimautolu mei ʻIsipite? ");
INSERT INTO ton_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","‌ʻIkai ko e lea eni naʻa mau tala kiate koe ʻi ʻIsipite, ʻo pehē, Tuku ai pe ʻakimautolu, koeʻuhi ke mau tauhi ʻae kakai ʻIsipite? He tā ne lelei lahi ʻemau tauhi ʻae kakai ʻIsipite, ʻi heʻemau mate ʻi he toafa.” ");
INSERT INTO ton_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","¶ Pea pehē ʻe Mōsese ki he kakai, “ʻOua te mou manavahē, tuʻu fakalongolongo pe, ʻo mamata ki he fakamoʻui ʻa Sihova, ʻaia te ne fakahā kiate kimoutolu he ʻaho ni: he ko e kakai ʻIsipite kuo mou mamata ki ai he ʻaho ni, ʻe ʻikai te mou toe mamata ki ai ʻo lauikuonga. ");
INSERT INTO ton_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","‌ʻE tau ʻa Sihova maʻamoutolu, pea te mou fakalongo pe.” ");
INSERT INTO ton_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Ko e hā ʻoku ke tangi ai kiate au? Lea ki he fānau ʻa ʻIsileli ke nau ʻalu atu pe. ");
INSERT INTO ton_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ka ke hiki hake ho tokotoko, ʻo mafao atu ho nima ki tahi, ʻo fakavaeua ia: pea ʻe ʻalu ʻae fānau ʻa ʻIsileli ʻi he kelekele mōmoa ʻi he loto tahi. ");
INSERT INTO ton_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pea ko au, vakai, te u fakafefeka ʻae loto ʻoe kakai ʻIsipite, pea te nau muimui ʻiate kinautolu; pea te u maʻu ʻae ongoongo ʻia Felo, pea mo ʻene kautau kotoa pē, mo ʻene ngaahi saliote, mo ʻene kau tangata heka hoosi. ");
INSERT INTO ton_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Pea ʻe ʻilo ʻe he kakai ʻIsipite ko au ko Sihova, hili ʻae fakaongoongo au ʻia Felo, mo ʻene ngaahi saliote, mo ʻene kau tangata heka hoosi.” ");
INSERT INTO ton_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","¶ Pea ko e ʻāngelo ʻae ʻOtua, ʻaia naʻe ʻalu muʻomuʻa ʻi he fononga ʻo ʻIsileli, naʻe hiki ʻo ʻalu kimui ʻiate kinautolu; pea ko e pou ʻoe ʻao naʻe hiki ia mei honau ʻao, ʻo tuʻu kimui ʻiate kinautolu: ");
INSERT INTO ton_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Pea naʻe haʻu ia ʻo tuʻu ʻi he vahaʻa ʻoe kakai ʻIsipite mo e kakai ʻIsileli; pea ko e ʻao ia mo e fakapoʻuli kiate kinautolu na, ka naʻe fakamaama ia kiate kinautolu ni: ko ia naʻe ʻikai hoko ai ʻae taha ki he taha ʻi he pō kotoa ko ia. ");
INSERT INTO ton_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Pea naʻe mafao atu ʻae nima ʻo Mōsese ki tahi; pea naʻe pule ʻa Sihova ke foki ʻae tahi ʻi he matangi mālohi mei hahake, ʻi he pō kotoa ko ia, ʻo ne ngaohi ʻae tahi ke mōmoa, pea naʻe vaeua ʻae ngaahi vai. ");
INSERT INTO ton_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Pea naʻe ʻalu mōmoa ʻae fānau ʻa ʻIsileli ʻi he loto tahi: pea ko e ʻā kiate kinautolu ʻae vai ʻi he nima toʻomataʻu, mo e nima toʻohema. ");
INSERT INTO ton_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","¶ Pea tuli ʻe he kakai ʻIsipite, ʻonau ʻalu ʻo muimui ʻiate kinautolu ki loto tahi, ʻio, ʻae ngaahi hoosi kotoa pē ʻa Felo, mo ʻene ngaahi saliote, mo e kau heka hoosi. ");
INSERT INTO ton_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Pea ʻi he hoko ʻae lakanga leʻo pongipongi, naʻe ʻafio ʻa Sihova ki he kau tau ʻo ʻIsipite mei he pou ʻoe afi mo e ʻao, ʻo ne veuveuki ʻae tau ʻae kakai ʻIsipite, ");
INSERT INTO ton_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","‌ʻO ne toʻo ʻae vaʻe mei heʻenau ngaahi saliote; ko ia naʻe tohongataʻa ai: pea pehē ʻe he kakai ʻIsipite, “Ke tau hola mei he ʻao ʻo ʻIsileli; he ʻoku tau maʻanautolu ʻa Sihova kiate kitautolu ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","¶ Pea folofola ʻa Sihova kia Mōsese, “Mafao atu ho nima ki tahi, koeʻuhi ke toe haʻu ʻae tahi ki he kakai ʻIsipite, pea ki heʻenau ngaahi saliote, pea mo e kau tangata heka hoosi.” ");
INSERT INTO ton_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Pea mafao atu ʻae nima ʻo Mōsese ki tahi, pea pongipongi ai, naʻe toe tau mai ʻae tahi ʻi heʻene mālohi; pea hola ai ʻae kakai ʻIsipite; ka naʻe liaki ʻe Sihova ʻae kakai ʻIsipite ʻi loto tahi. ");
INSERT INTO ton_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Pea naʻe tau mai ʻae tahi, ʻo lōmakiʻi ʻae ngaahi saliote ʻa Felo, mo e kau tangata heka hoosi, pea mo e tau kotoa pē naʻe haʻu ki tahi ʻo tuli ʻakinautolu; naʻe ʻikai ke hao ha tokotaha. ");
INSERT INTO ton_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ka naʻe ʻalu pe ʻae fānau ʻa ʻIsileli ʻi he mōmoa ʻi loto tahi: pea hangē ko e ʻā maka ʻae tahi kiate kinautolu ʻi he nima toʻomataʻu, mo e toʻohema. ");
INSERT INTO ton_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Naʻe pehē hono fakamoʻui ʻe Sihova ʻa ʻIsileli ʻi he ʻaho ko ia mei he nima ʻoe kakai ʻIsipite; pea naʻe mamata ʻa ʻIsileli ki he kakai mate ʻo ʻIsipite, ʻi he matātahi. ");
INSERT INTO ton_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Pea naʻe mamata ʻa ʻIsileli ki he ngāue lahi ko ia, ʻaia naʻe fai ʻe Sihova ki he kakai ʻIsipite; pea naʻe manavahē ʻae kakai kia Sihova, ʻo tui kia Sihova, mo ʻene tamaioʻeiki ko Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Pea naʻe toki hiva ʻe Mōsese mo e fānau ʻa ʻIsileli ʻae hiva ni kia Sihova, ʻonau pehē, “Te u hiva kia Sihova, he kuo ne ikuna fakamanavahē: ko e hoosi mo ia ʻoku heka ai kuo ne lī ki loto tahi. ");
INSERT INTO ton_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ko hoku mālohi mo ʻeku hiva ʻa Sihova, pea kuo hoko ia ko hoku fakamoʻui: ho hoku ʻOtua ia, pea teu teuteu moʻona ʻae fale nofoʻanga; ko e ʻOtua ia ʻo ʻeku tamai, pea te u fakahikihiki ia. ");
INSERT INTO ton_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","‌ʻOku toʻa ʻa Sihova ʻi he tau: ko Sihova hono huafa. ");
INSERT INTO ton_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Ko e ngaahi saliote ʻa Felo mo ʻene kautau kuo ne lī ki tahi: ko ʻene ngaahi ʻeikitau ongoongo kuo ne lōmakiʻi foki ʻi he tahi Kulokula. ");
INSERT INTO ton_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kuo ʻufiʻufi ʻakinautolu ʻe he loloto naʻa nau ngalo hifo ki he kilisi tahi ʻo hangē ko e foʻi maka. ");
INSERT INTO ton_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Ko ho nima toʻomataʻu ʻe Sihova kuo ongoongolelei lahi ʻi he mālohi; ko ho nima toʻomataʻu ʻe Sihova kuo ne laiki ke iikiiki ʻae fili. ");
INSERT INTO ton_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Pea ʻi hono lahi ʻo hoʻo māfimafi kuo ke fulihi ʻakinautolu naʻe tuʻu hake kiate koe: naʻa ke fekau atu ho houhau, ʻaia naʻa ne fakaʻauha ʻakinautolu ʻo hangē ko e veve. ");
INSERT INTO ton_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Pea ʻi he mānava mālohi ʻo hoʻo fofonga, naʻe tānaki fakataha ai ʻae ngaahi vai, naʻe tuʻu totonu ʻae ngaahi vai ʻo hangē ha ʻesi, pea naʻe mohe ʻae loloto ʻi loto tahi. ");
INSERT INTO ton_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Naʻe pehē ʻe he fili, ‘Te u tuli, te u lavaʻi, te u vahevahe ʻae koloa ʻoe vete; ʻe mākona ʻeku holi kiate kinautolu; teu unuhi hake ʻeku heletā, ʻe fakaʻauha ʻe hoku nima ʻakinautolu.’ ");
INSERT INTO ton_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Naʻa ke ifi ʻaki hoʻo matangi, pea naʻe ʻufiʻufi ʻakinautolu ʻe he tahi: naʻa nau ngalo hifo ʻo hangē ko e ukamea ʻi he loto moana. ");
INSERT INTO ton_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","‌ʻE Sihova ko hai ʻi he ngaahi ʻotua, ʻoku tatau mo e ʻafiona? Ko hai ʻoku hangē ko e ʻafiona, ʻoku ke nāunauʻia ʻi he māʻoniʻoni, ʻoku ke fakamanavahē ʻi he fakamālō, ʻoku ke fai ʻae ngaahi meʻa fakaofo? ");
INSERT INTO ton_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Naʻa ke mafao atu ho nima toʻomataʻu, naʻe folo hifo ʻakinautolu ʻe he kelekele. ");
INSERT INTO ton_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Naʻe tataki atu ʻe he ʻafiona ʻi hoʻo ʻaloʻofa ʻae kakai ʻaia naʻa ke huhuʻi: kuo ke fakahinohino ʻakinautolu ʻi hoʻo māfimafi ki ho ʻafioʻanga māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","‌ʻE fanongo ʻae kakai, pea manavahē: ʻe pukea ʻi he mamahi ʻae kakai ʻo Filisitia. ");
INSERT INTO ton_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","‌ʻE ofo ai ʻae ngaahi ʻeiki ʻo ʻItomi; ʻe pukea ʻi he tetetete ʻae kau tangata mālohi ʻo Moape; ʻe fakaʻaʻau ke ʻosi ai ʻae kakai kotoa pē ʻo Kēnani. ");
INSERT INTO ton_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","‌ʻE tō ʻae manavahē mo e ilifia kiate kinautolu: ʻi hono lahi ʻo ho nima te nau longo mate pe ʻo hangē ha maka: kaeʻoua ke hoko atu ho kakai, ʻE Sihova, ke ʻoua ke hoko atu ʻae kakai, ʻaia kuo ke fakatau: ");
INSERT INTO ton_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Pea te ke ʻomi ʻakinautolu ki ai, ʻo tō ʻakinautolu ʻi he moʻunga ʻo ho tofiʻa, ʻi he potu, ʻe Sihova, ʻaia kuo ke teuʻi ke ke ʻafio ki ai, ʻi he Potu toputapu, ʻE ʻEiki, ʻaia kuo fokotuʻumaʻu ʻe ho nima. ");
INSERT INTO ton_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","‌ʻE pule ʻa Sihova ʻo lauikuonga pea taʻengata.” ");
INSERT INTO ton_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","He naʻe ʻalu ʻae hoosi ʻa Felo mo ʻene ngaahi saliote, mo ʻene kau tangata heka hoosi ki tahi, pea naʻe toe ʻomi ʻe Sihova ʻae tahi kiate kinautolu; ka naʻe ʻalu ʻae fānau ʻa ʻIsileli ʻi he mōmoa ʻi loto tahi. ");
INSERT INTO ton_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","¶ Pea naʻe toʻo ʻe Miliame ko e palōfita fefine ko e tuofefine ʻo ʻElone, ʻae kihiʻi lali kiliʻi manu ʻi hono nima; pea naʻe muimui ʻiate ia ʻae kau fefine kotoa pē mo ʻenau ngaahi lali mo e meʻe. ");
INSERT INTO ton_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Pea naʻe talia ʻakinautolu ʻe Miliame, ʻo pehē, “Mou hiva kia Sihova, he kuo ne ikuna fakamanavahē: ko e hoosi mo ia ʻoku heka ai kuo ne lī ki tahi.” ");
INSERT INTO ton_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","¶ Pea naʻe ʻomi ʻe Mōsese ʻa ʻIsileli mei he tahi Kulokula, pea naʻa nau ʻalu atu ki he toafa ʻo Sua; pea naʻa nau fononga ʻi he ʻaho ʻe tolu ʻi he toafa, pea ʻikai ʻilo ha vai. ");
INSERT INTO ton_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Pea ʻi heʻenau hoko ki Mala, naʻe ʻikai te nau faʻa inu ʻae vai ʻo Mala, he naʻe kona: ko ia naʻe ui ai hono hingoa ko Mala. ");
INSERT INTO ton_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Pea naʻe lāunga ʻae kakai kia Mōsese, ʻo pehē, “Ko e hā te mau inu?” ");
INSERT INTO ton_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Pea naʻe tangi ia kia Sihova, pea fakahā kiate ia ʻe Sihova ʻae ʻakau, ʻaia naʻa ne lī ki he vai, pea naʻe melie ai ʻae vai: pea naʻe fokotuʻu ʻe ia ʻi ai ʻae fekau mo e tuʻutuʻuni, mo ne ʻahiʻahiʻi ʻakinautolu ʻi ai. ");
INSERT INTO ton_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","‌ʻO ne pehē, “Kapau te ke faʻa tokanga ki he leʻo ʻo Sihova ko ho ʻOtua, mo ke fai ʻaia ʻoku totonu ʻi hono ʻao, mo ke fanongo ki heʻene ngaahi fekau, ʻo tauhi ʻene ngaahi tuʻutuʻuni, ʻe ʻikai te u ʻai kiate koe hā mahaki ʻe taha, ʻi he ngaahi mahaki, ʻaia naʻaku ʻomi ki he kakai ʻIsipite: he ko au Sihova, ʻoku ou fakamoʻui koe.” ");
INSERT INTO ton_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","¶ Pea naʻa nau hoko ki ʻElimi, ʻaia naʻe ʻi ai ʻae luo vai ʻe hongofulu ma ua, mo e ʻakau ko e paame ʻe fitungofulu: pea naʻa nau ʻapitanga ʻi ai, ʻo ofi ki he vai. ");
INSERT INTO ton_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Pea naʻe hiki honau fononga mei ʻElimi, pea haʻu ʻae fakataha kotoa pē ʻoe fānau ʻa ʻIsileli ki he toafa ko Sini, ʻaia ʻoku ʻi he vahaʻa ʻo ʻElimi mo Sainai, ʻi hono hongofulu ma nima ʻoe ʻaho, ʻi hono ua ʻoe māhina, hili ʻenau haʻu mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Pea naʻe lāunga ʻi he toafa ʻae fakataha kotoa pē ʻae fānau ʻa ʻIsileli kia Mōsese mo ʻElone. ");
INSERT INTO ton_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Pea naʻe lea ʻae fānau ʻa ʻIsileli kiate kinaua, ʻo pehē, “ʻOku mau fakaʻamu ki he ʻOtua, naʻa mau mate ʻi he nima ʻo Sihova ʻi he fonua ko ʻIsipite, ʻi heʻemau kei tauʻutu ofi ki he ngaahi kulo kakano, pea ne mau kai mā ʻo mākona; he kuo mo ʻomi ʻakimautolu ki he toafa ni, ke tāmateʻi ʻae fakataha ni kotoa pē ʻaki ʻae fiekaia.” ");
INSERT INTO ton_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","¶ Pea naʻe folofola ai ʻa Sihova kia Mōsese, “Vakai, Te u fakaʻuha ʻae mā mei he langi maʻamoutolu: pea ʻe ʻalu atu ʻae kakai ʻo tānaki fakatuhotuha ki he ʻaho kotoa pē ʻae mā, koeʻuhi ke u ʻahiʻahiʻi ʻakinautolu, pe te nau felakaʻi ʻi heʻeku ngaahi fekau pe ʻikai. ");
INSERT INTO ton_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Pea ʻi hono ono ʻoe ʻaho ʻe fai pehē, te nau ngaohi ʻaia kuo na tuku, pea ʻe tuʻoua hono lahi hake ʻi he mā ʻoku nau ʻomi ʻi he ʻaho kehe.” ");
INSERT INTO ton_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Pea naʻe tala ʻe Mōsese mo ʻElone ki he fānau kotoa pē ʻa ʻIsileli, “Te mou toki ʻilo ʻi he efiafi, kuo ʻomi ʻe Sihova ʻakimoutolu mei he fonua ko ʻIsipite: ");
INSERT INTO ton_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Pea ʻi he ʻapongipongi, te mou mamata ki he nāunau ʻo Sihova he ʻoku ne ʻafioʻi hoʻomou ngaahi lāunga pea ko hai ʻakimaua, koeʻuhi ke mou hanu ai kiate kimaua?” ");
INSERT INTO ton_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Pea pehē ʻe Mōsese, “ʻE tuku ʻe Sihova ʻae kakano kiate kimoutolu ʻi he efiafi, mo e mā ʻi he pongipongi ke mou mākona ai; he ʻoku ʻafioʻi ʻe Sihova hoʻomou lāunga ʻaia ʻoku mou lāunga ai kiate ia: pea ko hai ʻakimaua? ʻOku ʻikai kiate kimaua hoʻomou lāunga, ka kia Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","¶ Pea naʻe lea ʻa Mōsese kia ʻElone, “Tala ki he fakataha kotoa pē ʻae fānau ʻa ʻIsileli, Mou haʻu ʻo ofi ki he ʻao ʻo Sihova he kuo ne ʻafioʻi hoʻomou lāunga.” ");
INSERT INTO ton_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Pea vakai lolotonga ʻae lea ʻa ʻElone ki he fakataha kotoa pē ʻae fānau ʻa ʻIsileli, naʻa nau sio atu ki he toafa, pea vakai, kuo ha mai ʻae nāunau ʻo Sihova ʻi he ʻao. ");
INSERT INTO ton_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Kuo u ongoʻi ʻae lāunga ʻae fānau ʻa ʻIsileli: lea kiate kinautolu ʻo pehē, ʻi he efiafi te mou kai kakano, pea ʻi he pongipongi te mou mākona ʻi he mā: pea te mou ʻilo ko au ko Sihova ko homou ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Pea ʻi heʻene efiafi naʻe hoko ʻo pehē, naʻe haʻu ʻae fuifui kueili, pea naʻe ʻuʻufi ʻae ʻapitanga; pea ʻi he pongipongi naʻe ʻufiʻufi takatakai ʻae ʻapitanga ʻe he hahau. ");
INSERT INTO ton_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Pea ʻi he ʻalu hake ʻae hahau naʻe ʻūfia ai, vakai, naʻe ʻi ai ʻi he funga toafa ʻae meʻa siʻi potopoto, ʻo hangē ko e hahau fefeka ʻi he kelekele. ");
INSERT INTO ton_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Pea ʻi he mamata ki ai ʻae fānau ʻa ʻIsileli, naʻa nau fepehēʻaki, “Ko e hā ia?” He naʻe ʻikai te nau ʻilo pe ko e hā. Pea pehē ʻe Mōsese kiate kinautolu, “Ko e mā eni kuo foaki mai ʻe Sihova ke mou kai. ");
INSERT INTO ton_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ko eni ʻae meʻa kuo fekau ʻe Sihova, Tānaki ia ʻe he tangata kotoa pē ʻo fakatatau ki heʻene kai, ko e oma ʻe taha mā ʻae tangata taki taha, ʻo fakatatau ki he lau ʻo homou kakai; ke toʻo taki taha ʻae tangata maʻanautolu ʻoku ʻi hono ngaahi fale fehikitaki.” ");
INSERT INTO ton_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Pea naʻe fai pehē ʻe he fānau ʻa ʻIsileli, ʻo tānaki ia, naʻe lahi ʻae niʻihi, pea siʻi ʻae niʻihi. ");
INSERT INTO ton_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Pea kuo fakafuofua ʻaki ia ʻae oma, naʻe ʻikai hano toe, kiate ia naʻe tānaki ʻo lahi, pea ko ia naʻe tānaki siʻi naʻe ʻikai hano masiva; naʻa nau tānaki ʻae tangata taki taha ʻo fakatatau ki heʻene kai. ");
INSERT INTO ton_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Pea pehē ʻe Mōsese, “ʻOua naʻa tuku ʻe ha tangata hano toe ki he ʻapongipongi.” ");
INSERT INTO ton_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ka naʻe ʻikai te nau tokanga kia Mōsese; ka ko honau niʻihi naʻe tuku hano toe ki he ʻapongipongi, pea naʻe ʻuangahia ia, pea namuaʻa; pea naʻe ʻita ʻa Mōsese kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Pea naʻa nau tānaki ia ʻi he pongipongi kotoa pē, ʻae tangata taki taha ʻo tatau mo ʻene kai: pea ʻi he hoko ʻo vela ʻae laʻā, naʻe vai ʻo ʻosi ia. ");
INSERT INTO ton_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","¶ Pea ʻi heʻene hoko ki hono ono ʻoe ʻaho, naʻa nau tānaki ʻo tuʻo ua hono lahi hake ʻoe mā, ko e oma ʻe ua ki he tangata pe taha: pea naʻe haʻu ʻae kau pule kotoa pē ʻoe kakai ʻo tala ia kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Pea pehē ʻe ia kiate kinautolu, “Ko eni ia kuo folofola ai ʻa Sihova, Ko e mālōlō ʻoe Sāpate māʻoniʻoni kia Sihova ʻapongipongi: taʻo he ʻaho ni, ʻaia te mou taʻo, pea haka ʻaia te mou haka: pea ko ia ʻoku toe, hilifaki ia ki he ʻapongipongi maʻamoutolu.” ");
INSERT INTO ton_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Pea naʻa nau hilifaki ki he ʻapongipongi, ʻo hangē ko e fekau ʻa Mōsese: pea naʻe ʻikai namuaʻa, pea naʻe ʻikai ha ʻuanga ʻi ai. ");
INSERT INTO ton_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Pea pehē ʻe Mōsese, “Kai ia he ʻaho ni; he ko e ʻaho ni ko e Sāpate ia kia Sihova: ʻe ʻikai te mou ʻilo ia he ʻaho ni ʻi he ngoue. ");
INSERT INTO ton_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Ko e ʻaho ʻe ono te mou tānaki ia; ka ʻi hono fitu ʻoe ʻaho ʻaia ko e Sāpate, ʻe ʻikai siʻi ʻi ai ia.” ");
INSERT INTO ton_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","¶ Pea hoko ʻo pehē, naʻe ʻalu kituaʻā ʻae niʻihi ʻi he kakai ʻi hono fitu ʻoe ʻaho ke tānaki, ka naʻe ʻikai te nau ʻilo ia. ");
INSERT INTO ton_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻE tuku ʻafē hoʻomou taʻefietauhi ʻeku ngaahi fekau mo ʻeku ngaahi fono? ");
INSERT INTO ton_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Vakai, ko e meʻa ʻi he foaki ʻe Sihova ʻae Sāpate kiate kimoutolu, ko ia ʻoku ne foaki ai kiate kimoutolu ʻi hono ono ʻoe ʻaho, ʻae mā ki he ʻaho ʻe ua: mou nofomaʻu taki taha ʻae tangata ʻi hono potu, ʻoua naʻa ʻalu ha tangata ʻe tokotaha mei hono potu ʻi hono fitu ʻoe ʻaho.” ");
INSERT INTO ton_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ko ia naʻe mālōlō ai ʻae kakai ʻi hono fitu ʻoe ʻaho. ");
INSERT INTO ton_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Pea naʻe ui hono hingoa ʻe he fale ʻo ʻIsileli, ko e Mana: pea naʻe hinehina ia ʻo hangē ko e tengaʻi kolianita; pea ko hono ifo naʻe hangē ha mā kuo ngaohi ʻaki ʻae honi. ");
INSERT INTO ton_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","¶ Pea pehē ʻe Mōsese, “Ko eni ʻae meʻa kuo fekau ʻe Sihova, Fakapito ʻaki ia ʻae oma ʻe taha ke fakatolonga ki homou toʻutangata ʻamui: koeʻuhi ke nau mamata ki he mā naʻaku fafanga ʻaki ʻakimoutolu ʻi he toafa, ʻi heʻeku ʻomi ʻakimoutolu mei he fonua ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Pea naʻe fekau ʻe Mōsese kia ʻElone, “Toʻo mai ha ipu, pea fakapito ʻae oma ʻe taha ʻi he mana ʻo lingi ia ki ai, pea hili ia ʻi he ʻao ʻo Sihova, ke tauhi maʻa homou ngaahi toʻutangata.” ");
INSERT INTO ton_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Pea naʻe hili ia ʻe ʻElone ʻi he ʻao ʻoe Fuakava ke tauhi ia ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Pea naʻe kai mana ʻae fānau ʻa ʻIsileli ʻi he taʻu ʻe fāngofulu, ʻo aʻu ki heʻenau hoko ki he fonua naʻe kakai; naʻa nau kai mana ʻo aʻu ki heʻenau hoko ki he veʻe fonua ʻo Kēnani. ");
INSERT INTO ton_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Pea ko e oma, ko hono vahe hongofulu ia ʻoe efa. ");
INSERT INTO ton_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Pea naʻe fononga ʻae fakataha kotoa pē ʻae fānau ʻa ʻIsileli mei he toafa ʻo Sini, ʻi he anga ʻo honau ngaahi fononga, ʻo fakatatau ki he fekau ʻa Sihova, ʻonau ʻapitanga ʻi Lefitimi: pea naʻe ʻikai ha vai ʻi ai ke inu ʻe he kakai. ");
INSERT INTO ton_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ko ia naʻe lea fakamamahi ai ʻae kakai kia Mōsese, ʻo pehē, “Tuku mai ha vai kiate kimautolu ke mau inu.” Pea pehē ʻe Mōsese kiate kinautolu, “Ko e hā ʻoku mou tautea ai au? Ko e hā ʻoku mou ʻahiʻahi kovi ai kia Sihova?” ");
INSERT INTO ton_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pea naʻe holi ʻae kakai ki he vai; pea lāunga ʻae kakai kia Mōsese, ʻo pehē, “Ko e hā kuo ke ʻomi ai ʻakimautolu mei ʻIsipite ke tāmateʻi ʻakimautolu mo e mau fānau, mo e mau fanga manu ʻaki ʻae fie inu?” ");
INSERT INTO ton_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Pea naʻe tangi ʻa Mōsese kia Sihova, ʻo pehē, “Ko e hā te u fai ki he kakai ni? ʻOku nau meimei tolongaki au ʻaki ʻae maka.” ");
INSERT INTO ton_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu atu ʻo muʻomuʻa ʻi he kakai, pea ʻalu mo koe ʻae mātuʻa ʻo ʻIsileli: mo ho tokotoko ʻaia naʻa ke tā ʻaki ʻae vaitafe, toʻo ia ʻi ho nima, mo ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Vakai, te u tuʻu ʻi ho ʻao ʻi ai ʻi he maka ʻi Holepi; pea te ke tā ʻae maka pea ʻe tupu mei ai ʻae vai, koeʻuhi ke inu ai ʻae kakai.” Pea naʻe fai ia ʻe Mōsese ʻi he ʻao ʻoe kau mātuʻa ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Pea ne ui hono hingoa ʻoe potu ko ia ko Masa, mo Melipa, ko e meʻa ʻi he lea fakamamahi ʻae fānau ʻa ʻIsileli, pea ko e meʻa ʻi heʻenau ʻahiʻahi kovi kia Sihova, ʻi heʻenau pehē, “ʻOku ʻiate kitautolu ʻa Sihova pe ʻikai?” ");
INSERT INTO ton_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","¶ Pea naʻe haʻu ʻa ʻAmaleki, ʻo tauʻi ʻa ʻIsileli ʻi Lefitimi. ");
INSERT INTO ton_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Pea naʻe fekau ʻe Mōsese kia Siosiua, “Fili haʻatau kau tangata, pea ʻalu ʻo tauʻi ʻa ʻAmaleki: te u tuʻu ʻapongipongi ki he tumutumu ʻoe moʻunga mo e tokotoko ʻoe ʻOtua ʻi hoku nima.” ");
INSERT INTO ton_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Pea naʻe fai ʻe Siosiua ʻo hangē ko e fekau ʻa Mōsese kiate ia, ʻo ne tauʻi ʻa ʻAmaleki: pea naʻe ʻalu ʻa Mōsese, mo ʻElone, mo Hua, ki he tumutumu ʻoe moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Pea naʻe pehē, ʻi he hiki ki ʻolunga ʻae nima ʻo Mōsese, naʻe mālohi ʻa ʻIsileli: pea ka tuku hifo hono nima, naʻe mālohi ʻa ʻAmaleki. ");
INSERT INTO ton_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Ka naʻe mamafa ʻae nima ʻo Mōsese pea naʻa nau toʻo ʻae maka ʻo tuku ia ke ne heka ai: pea naʻe poupou hake hono nima ʻe ʻElone mo Hua, ko e tokotaha ki hono toʻomataʻu, mo e taha ki hono toʻohema; pea naʻe taʻengāue hono nima ʻo aʻu ki he tō ʻae laʻā. ");
INSERT INTO ton_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Pea naʻe ikuna ʻe Siosiua ʻa ʻAmaleki mo hono kakai ʻaki ʻae mata ʻoe heletā. ");
INSERT INTO ton_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Pea naʻe fekau ʻe Sihova kia Mōsese, “Tohi ʻae meʻa ni ʻi ha tohi, ko e meʻa fakamanatu, pea lau ia ʻi he telinga ʻo Siosiua: he te u fakaʻauha ʻaupito ʻae fakamanatu ki ʻAmaleki mei he lalo langi.” ");
INSERT INTO ton_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Pea naʻe fokotuʻu ʻe Mōsese ʻae ʻesifeilaulau, ʻo ne ui hono hingoa ko Sihova-nisai: ");
INSERT INTO ton_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","He naʻa ne pehē, “Kuo fuakava ʻa Sihova, ʻe tauʻi maʻuaipē ʻe Sihova ʻa ʻAmaleki ʻi he toʻutangata ki he toʻutangata.” ");
INSERT INTO ton_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Pea ʻi he fanongo ʻa Setelo, ko e taulaʻeiki ʻo Mitiane, ko e tamai ʻi he fono kia Mōsese, ki he meʻa kotoa pē kuo fai ʻe he ʻOtua maʻa Mōsese, pea ki hono kakai ko ʻIsileli, pea mo e ʻomi ʻe Sihova ʻa ʻIsileli mei ʻIsipite; ");
INSERT INTO ton_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Pea toʻo ʻe Setelo, ko e tamai ʻi he fono kia Mōsese, ʻa Sipola ko e mali ʻo Mōsese, hili ʻene fekau ke ʻalu ia; ");
INSERT INTO ton_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Mo ʻene ongo tama: ko e tokotaha ʻi ai naʻe hingoa ko Kesomi; he naʻe pehē ʻe ia, “Naʻaku nofo ko e muli ʻi he fonua kehe: ");
INSERT INTO ton_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Pea ko hono hingoa ʻoe tokotaha ko ʻEliesa; he naʻe pehē ʻe ia, ko e ʻOtua ʻo ʻeku tamai, ko hoku tokoni, pea naʻa ne fakamoʻui au mei he heletā ʻa Felo:” ");
INSERT INTO ton_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Pea naʻe haʻu ʻa Setelo, ko e tamai ʻi he fono ʻa Mōsese, mo hono ongo foha, mo hono mali kia Mōsese ʻi he toafa, ʻaia naʻa ne ʻapitanga ai ʻi he moʻunga ʻoe ʻOtua: ");
INSERT INTO ton_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Pea naʻe pehē ʻe ia kia Mōsese, “Ko au Setelo ko hoʻo tamai ʻi he fono, kuo u haʻu kiate koe, mo ho mali, mo ʻene ongo tama mo ia.” ");
INSERT INTO ton_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","¶ Pea naʻe ʻalu kituaʻā ʻa Mōsese ke fakafetaulaki ki heʻene tamai ʻi he fono, ʻo ne fakaʻapaʻapa ki ai, mo ʻuma kiate ia pea fefehuʻiʻaki ʻakinaua ki heʻena lelei pea naʻa nau haʻu ki he fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Pea naʻe fakahā ʻe Mōsese ki heʻene tamai ʻi he fono, ʻaia kotoa pē kuo fai ʻe Sihova kia Felo, pea ki he kakai ʻIsipite koeʻuhi ko ʻIsileli, pea mo e mamahi kotoa pē kuo tō kiate kinautolu ʻi he hala, pea mo e fakamoʻui ʻakinautolu ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Pea naʻe fiefia ʻa Setelo ʻi he ngaahi angalelei kotoa pē ʻaia kuo fai ʻe Sihova ki ʻIsileli, ʻaia naʻa ne fakamoʻui mei he nima ʻoe kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Pea pehē ʻe Setelo, “Fakafetaʻi kia Sihova, ʻaia kuo ne fakahaofi ʻakimoutolu mei he nima ʻoe kakai ʻIsipite, pea mei he nima ʻo Felo, pea kuo ne fakahaofi ʻae kakai mei he nima ʻoe kakai ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Pea ko eni, ʻoku ou ʻilo ai ʻoku lahi ʻa Sihova ʻi he ngaahi ʻotua kotoa pē: koeʻuhi ʻi he meʻa ko ia naʻa nau fai fakafiefielahi ai, naʻe māʻolunga lahi ia ʻiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Pea naʻe toʻo ʻe Setelo ko e tamai ʻi he fono ʻa Mōsese, ʻae feilaulau tutu mo e ngaahi feilaulau ki he ʻOtua: pea naʻe haʻu ʻa ʻElone mo e kau mātuʻa kotoa pē ʻo ʻIsileli, ke nau kai mā mo e tamai ʻi he fono ʻa Mōsese, ʻi he ʻao ʻoe ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","¶ Pea pongipongi ai pea pehē, naʻe nofo ʻa Mōsese ke fakamaauʻi ʻae kakai: pea naʻe tuʻu ʻae kakai ʻo ofi kia Mōsese mei he pongipongi ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Pea kuo mamata ʻae tamai ʻi he fono ʻa Mōsese ki he meʻa kotoa pē naʻa ne fai ki he kakai, naʻe pehē ʻe ia, “Ko e hā ʻae meʻa ni ʻoku ke fai ki he kakai ni? Ko e hā ʻoku ke nofo tokotaha ai pe, pea tuʻu ʻae kakai kotoa pē ʻo ofi kiate koe mei he pongipongi ki he efiafi?” ");
INSERT INTO ton_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Pea pehē ʻe Mōsese ki heʻene tamai ʻi he fono, “Koeʻuhi ʻoku haʻu ʻae kakai ke fehuʻi kiate au ki he ʻOtua; ");
INSERT INTO ton_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","‌ʻOka ai haʻanau meʻa, ʻoku nau haʻu kiate au; peau fakamaau ki he tangata mo e tangata, pea u fakahā kiate kinautolu ʻae ngaahi fekau ʻae ʻOtua, mo ʻene ngaahi fono.” ");
INSERT INTO ton_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Pea naʻe lea ʻae tamai ʻi he fono ʻa Mōsese kiate ia, ʻo pehē, “Ko e meʻa ni ʻoku ke fai ʻoku ʻikai lelei. ");
INSERT INTO ton_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","He te ke fakaʻaʻau ʻo ʻosi moʻoni koe, ʻa koe mo e kakai ni ʻoku ʻiate koe: he ʻoku mamafa lahi ʻaupito ʻae meʻa ni kiate koe: ʻoku ʻikai te ke mafai ia ʻe koe tokotaha pe. ");
INSERT INTO ton_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ko eni, fanongo ki hoku leʻo, pea te u akonakiʻi koe, pea ʻe ʻiate koe ʻae ʻOtua: Ke ke ʻi he kakai ko e fehokotakiʻanga mo e ʻOtua, koeʻuhi ke ke ʻomi ʻae ngaahi meʻa ki he ʻOtua; ");
INSERT INTO ton_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Pea te ke ekinaki ʻae ngaahi tuʻutuʻuni, mo e ngaahi fono, pea ke fakahā kiate kinautolu ʻae hala ʻoku totonu ke nau ʻalu ai, mo e ngaahi ngāue ke nau fai, ");
INSERT INTO ton_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Pea ko eni ke ke fili mei he kakai ʻae kau tangata ʻoku mafai, ʻoku manavahē ki he ʻOtua, ko e kau tangata ʻoe moʻoni, ʻoku fehiʻa ki he manumanu; pea ke fakanofo ʻakinautolu ke nau pule ki he ngaahi toko afe, mo pule ki he ngaahi toko teau, mo pule ki he ngaahi nimangofulu, mo pule ki he ngaahi hongofulu: ");
INSERT INTO ton_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Pea tuku ke nau fakamaau ʻae kakai ʻi he ngaahi kuonga kotoa pē: pea ʻe pehē, ʻilonga ʻae meʻa lahi kotoa pē, ke nau ʻomi ia kiate koe, ka ko e ngaahi meʻa ʻoku siʻi, ke nau fakamaauʻi: ko ia ʻe hoko ʻo faingofua ai kiate koe, pea te nau fai mo koe ke fua ʻae kavenga. ");
INSERT INTO ton_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Pea kapau te ke fai ʻae meʻa ni, pea fekau pehē ʻe he ʻOtua kiate koe, te ke toki mafai ke tolonga, ai, pea ʻe ʻalu ʻae kakai ni kotoa pē ki honau potu ʻi he fiemālie.” ");
INSERT INTO ton_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Pea naʻe tokanga ʻa Mōsese ki he leʻo ʻo ʻene tamai ʻi he fono, ʻo ne fai ʻaia kotoa pē naʻa ne lea ki ai. ");
INSERT INTO ton_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Pea naʻe fili ʻe Mōsese ʻae kau tangata mafai mei ʻIsileli kotoa pē, ʻo ne fakanofo ʻakinautolu ko e ʻulu ʻoe kakai, ko e kau pule ki he ngaahi toko afe, mo e kau pule ki he ngaahi toko teau, ko e kau pule ki he ngaahi toko nimangofulu, mo e kau pule ki he ngaahi hongofulu. ");
INSERT INTO ton_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Pea naʻe fakamaau ʻae kakai ʻi he ngaahi faʻahitaʻu kotoa pē; naʻa nau ʻomi kia Mōsese ʻae ngaahi meʻa faingataʻa, ka ko e ngaahi meʻa siʻi naʻe fakamaau ʻekinautolu. ");
INSERT INTO ton_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","¶ Pea naʻe tuku ʻe Mōsese ʻene tamai ʻi he fono ke ne ʻalu; pea naʻe ʻalu ia ʻi hono hala ki hono fonua. ");
INSERT INTO ton_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","‌ʻI hono tolu ʻoe māhina, hili ʻae ʻalu atu ʻae fānau ʻa ʻIsileli mei he fonua ko ʻIsipite, ko e ʻaho ko ia naʻa nau hoko ki he toafa ko Sainai. ");
INSERT INTO ton_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","He kuo nau hiki mei Lefitimi, pea hoko ki he toafa ʻo Sainai, pea nau ʻapitanga ʻi he toafa; pea naʻe ʻapitanga ʻa ʻIsileli ʻi he ʻao ʻoe moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Pea naʻe ʻalu hake ʻa Mōsese ki he ʻOtua, pea folofola ʻa Sihova kiate ia mei he moʻunga, ʻo pehē, “Te ke lea pehē ki he fale ʻo Sēkope, ʻo tala ki he fānau ʻa ʻIsileli; ");
INSERT INTO ton_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Kuo mou mamata ki he meʻa naʻaku fai ki he kakai ʻIsipite, mo ʻeku fua ʻakimoutolu ʻi he kapakau ʻoe ʻikale, ʻo ʻomi ʻakimoutolu kiate au. ");
INSERT INTO ton_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Pea ko ʻeni, kapau te mou tuitala moʻoni ki hoku leʻo, ʻo tauhi ʻeku fuakava, te mou ʻiate au ko e koloa lelei lahi ʻi he kakai kotoa pē: he ʻoku ʻoʻoku ʻa māmani kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Pea te mou ʻiate au ko e puleʻanga ʻoe kau taulaʻeiki, mo e kakai māʻoniʻoni. Ko eni ʻae ngaahi lea ke ke lea ʻaki ki he fānau ʻa ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","¶ Pea naʻe haʻu ʻa Mōsese ʻo fekau ke haʻu ʻae kau mātuʻa ʻoe kakai, ʻo ne tuku ki honau ʻao ʻae ngaahi lea ni kotoa pē, ʻaia naʻe fekau ʻe Sihova kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Pea naʻe lea fakataha ʻae kakai kotoa pē, ʻo pehē, “Te mau fai ʻaia kotoa pē kuo folofola ki ai ʻa Sihova.” Pea tala atu ʻe Mōsese ʻae ngaahi lea ʻae kakai kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Pea naʻe folofola ʻa Sihova kia Mōsese, “Vakai, te u ʻalu atu kiate koe ʻi he ʻao matolu, koeʻuhi ke ongoʻi ʻe he kakai ʻo kau ka lea kiate koe, pea nau tui kiate koe ʻo taʻengata.” Pea naʻe tala atu ʻe Mōsese ʻae ngaahi lea ʻae kakai kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu ki he kakai, ʻo fakamāʻoniʻoni ʻakinautolu he ʻaho ni mo e ʻapongipongi, pea ke nau fō honau ngaahi kofu. ");
INSERT INTO ton_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Pea teu ki hono tolu ʻoe ʻaho: koeʻuhi ʻi hono tolu ʻoe ʻaho ʻe hāʻele hifo ʻa Sihova ki he moʻunga ko Sainai ʻi he ʻao ʻoe kakai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pea ke ai hano ngataʻanga takatakai ki he kakai, mo ke pehē, Vakai kiate kimoutolu, ʻoua naʻa mou ʻalu hake ki he moʻunga, pe ʻalu ki hono tafaʻaki: ko ia ʻe ʻalu ki he moʻunga ʻe tāmateʻi moʻoni ia: ");
INSERT INTO ton_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","‌ʻE ʻikai ha nima ʻe ala ki ai ʻe taʻetolongaki moʻoni ia ʻaki ʻae maka pe fanaʻi ke ʻasi: pe ko ha manu ia pe ha tangata, ʻe ʻikai moʻui ia: ʻoka ongo mai ʻae meʻa lea ʻo fuoloa, te nau ʻalu atu ki he moʻunga.” ");
INSERT INTO ton_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","¶ Pea naʻe ʻalu hifo ʻa Mōsese mei he moʻunga ki he kakai, ʻo ne fakamāʻoniʻoniʻi ʻae kakai; pea naʻa nau fō honau ngaahi kofu. ");
INSERT INTO ton_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Pea pehē ʻe ia ki he kakai, “Mou tali teu pe ki hono tolu ʻoe ʻaho: ʻoua naʻa ala ki homou uaifi.” ");
INSERT INTO ton_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","¶ Pea pongipongi hake ʻi hono tolu ʻoe ʻaho, naʻe hoko ʻo pehē, naʻe ai ʻae ngaahi mana mo e ʻuhila, mo e ʻao matolu ki he moʻunga, mo e ongo mai ʻae meʻa lea naʻe mālohi fakamanavahē; ko ia naʻe tetetete ai ʻae kakai kotoa pē naʻe ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Pea naʻe ʻomi ʻe Mōsese ʻae kakai kituʻa mei he ʻapitanga ke nau fakafetaulaki atu ki he ʻOtua; pea naʻa nau tutuʻu ʻi he potu ʻi lalo ʻi he moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Pea naʻe kohuʻia ʻae moʻunga ko Sainai kotoa pē, koeʻuhi naʻe hāʻele hifo ki ai ʻa Sihova ʻi he afi: pea naʻe ʻalu hake ʻa hono kohu ʻo hangē ko e kohu ʻo ha fuʻu afi, pea naʻe ngalulu lahi ʻae moʻunga kotoa. ");
INSERT INTO ton_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Pea ʻi he ongo mai ʻae leʻo ʻoe meʻa lea ʻo fuoloa, pea fakaʻaʻau ʻo leʻo lahi ʻaupito, pea lea ʻa Mōsese, pea talia ia ʻe he ʻOtua ʻaki ʻae leʻo. ");
INSERT INTO ton_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Pea naʻe hāʻele hifo ʻa Sihova ki he moʻunga ko Sainai, ki he tumutumu ʻoe moʻunga: pea naʻe folofola ʻa Sihova kia Mōsese ke ʻalu hake ia ki he tumutumu ʻoe moʻunga; pea naʻe ʻalu hake ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Pea naʻe folofola ʻa Sihova kia Mōsese, “Ke ke ʻalu hifo, ʻo naʻinaʻi atu ki he kakai, telia naʻa nau ʻasi ki loto ʻo fakasio kia Sihova, pea mate ai honau tokolahi. ");
INSERT INTO ton_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Pea ko e kau taulaʻeiki foki, ʻaia ʻoku haʻu ʻo ofi kia Sihova, tuku ke nau fakamāʻoniʻoniʻi ʻakinautolu, telia naʻa ʻoho atu ʻa Sihova kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Pea pehēange ʻe Mōsese kia Sihova, “ʻOku ʻikai faʻa haʻu ʻae kakai ki he moʻunga ko Sainai: he naʻa ke fekauʻi ʻakimautolu ʻo pehē, ʻAi hono fakangatangata, ki he moʻunga, mo fakatapui ia.” ");
INSERT INTO ton_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Pea naʻe folofola ʻa Sihova kiate ia, “Ke ke ʻalu hifo, pea ke toe ʻalu hake, ʻa koe, mo ʻElone: kaeʻoua naʻa ʻoho ki loto ʻae kau taulaʻeiki mo e kakai ke ʻalu hake kia Sihova, telia naʻa ʻoho atu ia kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Pea naʻe ʻalu hifo ai ʻa Mōsese ki he kakai, ʻo ne lea atu kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Pea naʻe folofolaʻaki ʻe he ʻOtua ʻae ngaahi folofola ni kotoa pē, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ko au ko Sihova ko homou ʻOtua, kuo u ʻomi koe mei he fonua ko ʻIsipite, mei he fale ʻoe pōpula. ");
INSERT INTO ton_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ʻOua naʻa ke maʻu mo au ha ʻotua kehe ʻi hoku ʻao. ");
INSERT INTO ton_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ʻOua naʻa ke ngaohi kiate koe ha fakatātā, pe ha meʻa fakatatau ʻe taha ʻi ha meʻa ʻi he langi ʻi ʻolunga, pe ha meʻa ʻoku ʻi he fonua ʻi lalo ni, pe ki ha meʻa ʻoku ʻi he vai ʻi he lalo fonua: ");
INSERT INTO ton_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","“ʻOua naʻa ke punou hifo koe kiate kinautolu, pe tauhi ki ai: he ko au Sihova ko ho ʻOtua ko e ʻOtua fuaʻa au, ʻoku ou totongi ʻae hia ʻae ngaahi tamai ki he fānau, ʻo aʻu ki hono tolu mo hono fā ʻoe toʻutangata ʻokinautolu ʻoku fehiʻa kiate au; ");
INSERT INTO ton_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pea u fakahā ʻae ʻaloʻofa ki he ngaahi toko afe ʻokinautolu ʻoku ʻofa kiate au mo tauhi ʻeku ngaahi fekau. ");
INSERT INTO ton_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ʻOua naʻa ke takuanoa ʻae huafa ʻo Sihova ko ho ʻOtua; koeʻuhi ʻe ʻikai lau ʻe Sihova ko e taʻehalaia ia, ʻaia ʻoku ne takuanoa hono huafa. ");
INSERT INTO ton_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Manatu ki he ʻaho Sāpate, ke tauhi ia ke māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ko e ʻaho ʻe ono ke ke ngāue ai, ʻo fai ai hoʻo ngāue kotoa pē: ");
INSERT INTO ton_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ka ko hono fitu ʻoe ʻaho ko e Sāpate ia ʻo Sihova ko ho ʻOtua: ʻoua naʻa ke fai ʻi ai ha ngāue ʻe taha, ʻa koe, pe ko ho foha, pe ko ho ʻofefine, ko hoʻo tamaioʻeiki, pe ko hoʻo kaunanga, pe ko hoʻo fanga manu, pe ko e muli ʻoku nofo ʻi ho lotoʻā; ");
INSERT INTO ton_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","He naʻe ngaohi ʻe Sihova ʻi he ʻaho ʻe ono, ʻae langi, mo e fonua, mo e tahi, mo e ngaahi meʻa kotoa pē ʻoku ʻi ai, pea ne mālōlō ʻi hono fitu ʻoe ʻaho: ko ia naʻe tāpuakiʻi ai ʻe Sihova ʻae ʻaho Sāpate ʻo ne fakatapui ia. ");
INSERT INTO ton_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Fakaʻapaʻapa ki hoʻo tamai mo hoʻo faʻē: koeʻuhi ke fuoloa ho ngaahi ʻaho ʻi he fonua ʻoku foaki ʻe Sihova ko ho ʻOtua kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“ʻOua naʻa ke fakapō. ");
INSERT INTO ton_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ʻOua naʻa ke tono fefine. ");
INSERT INTO ton_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ʻOua naʻa ke kaihaʻa. ");
INSERT INTO ton_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","‌ʻOua naʻa ke tukuakiʻi ʻa ho kaungāʻapi. ");
INSERT INTO ton_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ʻOua naʻa ke manumanu ki he fale ʻo ho kaungāʻapi, ʻoua naʻa ke manumanu ki he mali ʻo ho kaungāʻapi, pe ki heʻene tamaioʻeiki, pe ki heʻene kaunanga, pe ki heʻene fanga pulu, pe ki heʻene asi, pe ki ha meʻa ʻe taha ʻoku ʻa ho kaungāʻapi. ");
INSERT INTO ton_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","¶ Pea naʻe mamata ʻae kakai kotoa pē ki he ngaahi mana, mo e ngaahi ʻuhila, mo e longoaʻa lahi ʻoe meʻa lea, mo e kohu ʻoe moʻunga: pea ʻi heʻenau mamata ki ai, naʻa nau holomui, ʻo tuʻu mai mei he mamaʻo. ");
INSERT INTO ton_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Pea naʻa nau lea kia Mōsese, “Ke ke lea koe kiate kimautolu, pea te mau tokanga ki ai: kaeʻoua naʻa folofola ʻae ʻOtua kiate kimautolu, telia naʻa mau mate. ");
INSERT INTO ton_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Pea talaange ʻe Mōsese ki he kakai, “ʻOua ʻe manavahē; he kuo hāʻele mai ʻae ʻOtua, ko homou ʻahiʻahiʻi, pea ke ʻi homou ʻao ʻene manavahē, ke ʻoua naʻa mou fai angahala.” ");
INSERT INTO ton_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Pea naʻe tuʻu ʻae kakai mei he mamaʻo, pea ʻunuʻunu atu ʻa Mōsese ki he poʻuli matolu, ʻaia naʻe ʻafio ai ʻae ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Ke ke lea ki he fānau ʻa ʻIsileli, ʻo pehē, Kuo mou mamata ki heʻeku lea kiate kimoutolu mei langi. ");
INSERT INTO ton_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","‌ʻOua naʻa mou ngaohi ke fakalahi ʻaki au ha ngaahi ʻotua siliva, pea ʻoua naʻa mou ngaohi kiate kimoutolu ʻae ngaahi ʻotua koula. ");
INSERT INTO ton_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","¶ Ke ke ngaohi ʻae feilaulauʻanga kelekele kiate au, pea ke fai ai hoʻo ngaahi feilaulau tutu, mo hoʻo ngaahi feilaulau fakalelei, ʻa hoʻo fanga sipi, mo e fanga pulu: pea ʻi he potu kotoa pē ʻoku ou fakahā ai hoku huafa, te u haʻu ai kiate koe, pea te u tāpuakiʻi koe. ");
INSERT INTO ton_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Pea kapau ʻoku ke fie ngaohi kiate au ʻae feilaulauʻanga maka, ʻoua naʻa ke ngaohi ʻaki ia ʻae maka kuo tā: he kapau te ke hiki ki ai ha toki, kuo ke ʻuliʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Pea ʻoua naʻa ke ʻalu hake ʻi ha tuʻunga ki hoku feilaulauʻanga, telia naʻa ʻiloʻi ai hoʻo telefua. ");
INSERT INTO ton_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Pea ko e ngaahi fono ʻeni, ʻaia ke ke tuku ʻi honau ʻao. ");
INSERT INTO ton_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kapau te ke fakatau ha tamaioʻeiki ko e Hepelū, ko e taʻu ʻe ono te ne tauhi koe: pea ʻi hono fitu ʻe ʻalu atu tauʻatāina ia taʻetotongi. ");
INSERT INTO ton_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kapau naʻe haʻu tokotaha pe, ʻe ʻalu kituaʻā tokotaha pe: kapau naʻe mali, pea ʻe ʻalu hono mali mo ia. ");
INSERT INTO ton_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kapau naʻe foaki ha mali kiate ia ʻe hono ʻeiki, pea kuo ne fānau kiate ia ʻae fānau tangata pe ʻe fānau fefine: ko e mali mo e fānau ʻe ʻa hono ʻeiki, pea te ne ʻalu tokotaha pe ia. ");
INSERT INTO ton_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pea kapau ʻe lea totonu ʻae tamaioʻeiki, ʻo pehē, ʻOku ou ʻofa ki hoku ʻeiki, mo hoku mali, mo ʻeku fānau; ʻe ʻikai te u ʻalu ke tauʻatāina au, ");
INSERT INTO ton_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Pea ʻe toki ʻomi ia ʻe hono ʻeiki ki he kau fakamaau; pea ʻe ʻomi ia foki ki he matapā, pe ki he pou ʻoe matapā; pea ʻe tui hono telinga ʻe hono ʻeiki ke ʻasi ʻaki ʻae hui; pea te ne tauhi ia ʻo fai maʻuaipē. ");
INSERT INTO ton_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","¶ “Pea kapau ʻe fakatau ʻe ha tangata hono ʻofefine ke hoko ko e kaunanga, ʻe ʻikai ʻalu kituaʻā ia ʻo hangē ko e kau tamaioʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kapau ʻoku ʻikai lelei ia ʻi he ʻao ʻo hono ʻeiki, ʻaia kuo ne fakanofo ia kiate ia, te ne toki tukuange ia ke huhuʻi ia: ʻoku ʻikai ngofua ʻene fakatau ia ki ha kakai kehe, koeʻuhi kuo fai taʻetotonu ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Pea kapau kuo ne fakanofo ia ki hono foha, pea te ne fai kiate ia ʻo hangē ko e anga ʻae ʻofefine. ");
INSERT INTO ton_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kapau ʻoku ne toʻo kiate ia ʻae uaifi ʻe taha: ʻe ʻikai siʻi te ne fakasiʻisiʻi ʻene meʻakai, pe ko e kofu, mo e ngāue totonu ʻae uaifi. ");
INSERT INTO ton_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Pea kapau ʻe ʻikai te ne fai ʻae meʻa ni ʻe tolu kiate ia, pea ʻe ʻalu atu ia ʻiate ia, ʻe tauʻatāina ia taʻetotongi. ");
INSERT INTO ton_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","¶ “Ko ia ʻoku ne tali ha tangata, pea mate ai ia, ʻe tāmateʻi moʻoni ia. ");
INSERT INTO ton_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pea kapau naʻe ʻikai lamasi ia ʻe ha tangata, ka naʻe tukuange ia ʻe he ʻOtua ki hono nima; pea te u fakahā kiate koe ha potu ke hola ia ki ai. ");
INSERT INTO ton_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ka koeʻuhi kapau ʻe haʻu loto lahi ha tangata ki hono kaungāʻapi, ke tāmateʻi ia ʻi he angakovi; te ke ʻave ia mei hoku feilaulauʻanga koeʻuhi ke mate ia. ");
INSERT INTO ton_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","¶ “Pea ko ia ʻoku ne taaʻi ʻene tamai, pe ko ʻene faʻē, ko e moʻoni ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","¶ “Pea ko ia ʻoku ne kaihaʻasi ha tangata, ʻo fakatau ia, pea kapau ʻoku ʻilo ia ʻi hono nima, ʻe tāmateʻi moʻoni ia. ");
INSERT INTO ton_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","¶ “Pea ko ia ʻoku ne kapeʻi ʻene tamai pe ko ʻene faʻē, ʻe tāmateʻi moʻoni ia. ");
INSERT INTO ton_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","¶ “Pea kapau ʻe fekuki ʻae ongo tangata, pea taaʻi ʻe he tokotaha ʻae tokotaha ʻaki ʻae maka, pe tuki ʻaki hono nima, pea ʻikai mate kae toka ai: ");
INSERT INTO ton_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Kapau ʻe toetuʻu hake ʻo ʻeveʻeva ʻituʻa mo hono tokotoko, pea ʻe toki hao ai ʻaia naʻa ne taaʻi ia: ka ʻe totongi ia ki hono ngaahi ʻaho kuo liaki, pea te ne totongi hono fakamoʻui ke haohaoa. ");
INSERT INTO ton_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","¶ “Kapau ʻe taaʻi ʻe ha tangata ʻene tamaioʻeiki, pe ko ʻene kaunanga ʻaki ha vaʻa ʻakau, pea mate ai ia ʻi hono nima; ko e moʻoni ʻe tautea ia. ");
INSERT INTO ton_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ka koeʻuhi kapau ʻe moʻui ia ʻi he ʻaho ʻe taha, pe ua, ʻe ʻikai tautea ia, he ko ʻene koloa ia. ");
INSERT INTO ton_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","¶ “Kapau ʻoku fekuki ʻae ongo tangata, pea lavea ai ha fefine feitama, pea tō ai ʻene tama, pea ngata ai hono kovi: ʻe tautea moʻoni ai ʻae tangata, ʻo hangē ko ia ʻe lea ki ai ʻae mali ʻoe fefine: pea ʻe totongi ia ʻo hangē ko e lea ʻae kau fakamaau. ");
INSERT INTO ton_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pea kapau ʻe tupu ai ʻae kovi, ke ke ʻatu ʻae moʻui ke totongi ʻae moʻui. ");
INSERT INTO ton_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ko e mata ki he mata, ko e nifo ki he nifo, ko e nima ki he nima, ko e vaʻe ki he vaʻe, ");
INSERT INTO ton_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ko e tutu ki he tutu, ko e lavea ki he lavea, mo e tā ki he tā. ");
INSERT INTO ton_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","¶ “Pea kapau ʻe taaʻi ʻe ha tangata ʻae mata ʻo ʻene tamaioʻeiki pe ko e mata ʻo ʻene kaunanga, pea kui ai; pea ʻe tukuange ia ke ʻalu ʻataʻatā, koeʻuhi ko hono mata. ");
INSERT INTO ton_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Pea kapau te ne taaʻi ʻene tamaioʻeiki, pea mokulu ai ʻae nifo, pe ko e nifo ʻo ʻene kaunanga; te ne tukuange ia ke ʻalu tauʻatāina koeʻuhi ko e nifo. ");
INSERT INTO ton_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","¶ “Kapau ʻe tuiʻi ʻe ha pulu ha tangata pe ha fefine, pea mate ai ia: ʻe tolongaki ʻae pulu ʻaki ʻae maka ke mate, pea ʻe ʻikai kai hono sino: pea ʻe ʻataʻatā ʻaia ʻoku ʻaʻana ʻae pulu. ");
INSERT INTO ton_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pea kapau naʻe faʻa tui ʻe he pulu ʻaki hono meʻatui, ʻi he ngaahi ʻaho naʻe hili, pea naʻe tala ia kiate ia ʻoku ʻaʻana, pea naʻe ʻikai te ne noʻotaki ia, ka kuo ne tāmateʻi ha tangata, pe ha fefine; ʻe tolongaki ʻae pulu ʻaki ʻae maka ke mate ia, pea ʻe tāmateʻi mo ia ʻoku ʻaʻana. ");
INSERT INTO ton_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pea kapau ʻe lau paʻanga kiate ia mo hono huhuʻi, pea te ne ʻatu ʻaia kotoa pē ʻoku tala kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kapau kuo ne tuiʻi ha foha pe ha ʻofefine, ʻe fai kiate ia ʻo fakatatau ki ha fakamaau ni. ");
INSERT INTO ton_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kapau ʻe tuiʻi ʻe he pulu ha tamaioʻeiki pe ha kaunanga; ʻe ʻatu ʻe ia ki heʻena ʻeiki ʻae sikeli siliva ʻe tolungofulu, pea ʻe tolongaki ʻae pulu ʻaki ʻae maka ke mate. ");
INSERT INTO ton_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","¶ “Pea kapau ʻe tangaki ʻe ha tangata ha luo, pe kapau ʻe keli ʻe ha tangata ha luo, pea ʻikai ʻufiʻufi ia, pea tō ki ai ha pulu, pe ha ʻasi; ");
INSERT INTO ton_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Ko ia ʻoku ʻaʻana ʻae luo te ne totongi ia, ʻo ʻatu ʻae ngaahi paʻanga kiate ia ʻoku ʻaʻana ʻae manu; ka e ʻaʻana ʻae manu mate. ");
INSERT INTO ton_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","¶ Pea kapau ʻe tuiʻi ʻe ha pulu ʻae tangata ʻe tokotaha ʻae pulu ʻae tangata kehe, pea mate ai ia; te na toki fakatau ʻae pulu moʻui, ʻo vaeua ʻae totongi; pea te na vaeua mo e pulu mate. ");
INSERT INTO ton_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pea kapau ʻe ʻilo, naʻe faʻa tui ʻe he pulu ʻi muʻa, pea naʻe ʻikai noʻotaki ia ʻe heʻene ʻeiki; ko e moʻoni te ne totongi ʻae pulu ʻaki ʻae pulu; pea ʻe ʻaʻana ʻae pulu mate. ");
INSERT INTO ton_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Kapau ʻe kaihaʻa ʻe ha tangata ha pulu pe ha sipi, mo tāmateʻi ia, pe fakatau ia; te ne totongi ʻae pulu ʻaki ʻae pulu ʻe nima, mo e sipi ʻe taha ʻaki ʻae sipi ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","¶ Kapau ʻe maʻupoʻuli ha kaihaʻa lolotonga ʻene fai, pea taaʻi ia pea mate, ʻe ʻikai lilingi ha toto koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Kapau kuo ʻalu hake ʻae laʻā kiate ia, ʻe ʻikai teʻia ia: ka te ne ʻatu hono totongi kotoa: kapau ʻoku ʻikai haʻa ne meʻa, pehē ʻe fakatau ia koeʻuhi ko ʻene kaihaʻa. ");
INSERT INTO ton_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kapau ʻoku ʻilo pau ʻene kaihaʻa ʻi hono nima ʻoku kei moʻui, pe ko ha pulu, pe ha ʻasi, pe ha sipi; ʻe totongi ʻaki ia ʻae ua. ");
INSERT INTO ton_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","¶ “Kapau ʻe fai ʻe ha tangata ke keina ha ngoue, pe ha ngoue vaine, ʻo ne tuku ki ai ʻene manu, ke kai ʻi he ngoue ʻae tangata kehe: ʻe totongi ki ai ia ʻaki hono fua lelei ʻo ʻene ngoue, mo e lelei ʻo ʻene ngoue vaine. ");
INSERT INTO ton_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","¶ “Kapau ʻe tupu ha afi, pea hoko ki he ʻakau talatala, pea vela ai ʻae ngaahi fokotuʻunga uite, pe ko e ngoue, ʻo ʻauha ai; ko ia naʻa ne tutu ʻae afi te ne totongi moʻoni. ");
INSERT INTO ton_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","¶ “Kapau ʻe tuku ʻe ha tangata ʻae ngaahi paʻanga, pe ha meʻa ki hono kaungāʻapi, ke ne vakai ki ai, pea kapau ʻe kaihaʻasia ia mei he fale ʻoe tangata: kapau ʻe ʻilo ʻae kaihaʻa, tuku ke ne totongi ʻaki ʻae ua. ");
INSERT INTO ton_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Kapau ʻoku ʻikai ʻilo ʻae kaihaʻa, pea ʻe toki ʻomi ʻae ʻeiki ʻoe fale ki he kau fakamaau, ke ʻilo, pe kuo ne ai hono nima ki he meʻa ʻa hono kaungāʻapi. ");
INSERT INTO ton_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“ʻI he ngaahi anga fakakaihaʻa kotoa pē, ʻoku kau ki he pulu, pe ki he ʻasi, pe ko e sipi, pe ki he kofu, pe ki he meʻa kuo mole, ʻaia ʻoku lea fakapapau ki ai ha tokotaha ʻo pehē ko ʻene meʻa, ʻe fakahā fakatouʻosi pe ʻena meʻa ki he kau fakamaau; pea ko ia ʻe tuku ko e halaia ʻe he kau fakamaau, te ne totongi ke tuʻo ua ki hono kaungāʻapi. ");
INSERT INTO ton_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Kapau ʻe tuku ʻe ha tangata ki hono kaungāʻapi, ha ʻasi, pe ha pulu, pe ha sipi, pe ha manu ʻe taha ke ne tauhi; pea mate ia, pe lavea, pe fakahēʻi ke mamaʻo, kae ʻikai ha tangata kuo mamata ki ai; ");
INSERT INTO ton_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Pea ʻe fuakava ʻakinaua ki he ʻEiki, ʻo pehē naʻe ʻikai te ne mafao atu hono nima ki he meʻa ʻa hono kaungāʻapi; pea ko ia ʻoku ʻaʻana ʻae meʻa te ne tui ki ai, pea ʻe ʻikai totongi ia. ");
INSERT INTO ton_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pea kapau kuo kaihaʻasi meiate ia, pea te ne ʻatu ʻae totongi kiate ia ʻoku ʻaʻana ia. ");
INSERT INTO ton_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kapau kuo mahaehae, ʻoku lelei ʻene ʻomi ia ke fakamoʻoni, pea ʻe ʻikai te ne totongi ʻaia kuo mahaehae. ");
INSERT INTO ton_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","¶ “Pea kapau ʻe nō ʻe ha tangata ha meʻa ʻe taha ʻi hono kaungāʻapi, pea hoko ʻo lavea ia, pe mate, kae ʻikai ʻi ai ʻaia ʻoku ʻaʻana, ko e moʻoni te ne totongi ia. ");
INSERT INTO ton_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pea kapau naʻe ʻi ai ia ʻaia ʻoku ʻaʻana, pea ʻe ʻikai totongi ia; kapau ko e ngāue totongi, naʻe haʻu ia ko e totongi. ");
INSERT INTO ton_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","¶ “Pea kapau ʻe fakatauveleʻi ʻe ha tangata ha taʻahine ʻoku teʻeki poloʻi pea na mohe, ko e moʻoni te ne vahe koloa maʻana, pea hoko ko hono mali. ");
INSERT INTO ton_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Pea kapau ʻe ʻikai ʻaupito tuku ia ʻe heʻene tamai kiate ia, pea ke totongi paʻanga ia ʻo fakatatau ki he koloa fakatau ʻae kau taʻahine. ");
INSERT INTO ton_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","¶ “ʻOua naʻa ke tuku ke moʻui ʻae fefine taulafaʻahikehe. ");
INSERT INTO ton_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","¶ “Ko ia ʻe mohe mo e manu ko e moʻoni ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","¶ “Ko ia ʻoku feilaulau ki ha ʻotua kehe, ka ʻoku ʻikai kia Sihova pe, ko e moʻoni ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","¶ “ʻE ʻikai te ke fakamamahiʻi ha muli, pe taʻomia ia, he naʻa mou nofo ʻi ʻIsipite ko e kau muli. ");
INSERT INTO ton_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","¶ “ʻE ʻikai te mou fakamamahi ha fefine kuo pekia hono mali, pe ko e tamasiʻi tuēnoa. ");
INSERT INTO ton_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kapau te ke tautea ʻakinautolu ʻi ha meʻa, pea nau tangi mai kiate au, ko e moʻoni te u ongoʻi ʻenau tangi; ");
INSERT INTO ton_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Pea ʻe tupu ʻo lahi ai ʻeku houhau, pea te u tāmateʻi ʻakimoutolu ʻaki ʻae heletā; pea ʻe hoko homou ngaahi mali ko e kau paea, mo hoʻomou fānau ko e tamai mate. ");
INSERT INTO ton_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","¶ “Kapau ʻoku tuku atu hoʻo koloa ki ha niʻihi ʻi hoku kakai masiva ʻoku ofi kiate koe, ʻoua naʻa ke fai kiate ia hangē ha tangi koloa totongi, pea ʻoua naʻa ke tala kiate ia ʻae totongi. ");
INSERT INTO ton_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kapau ʻoku ke toʻo ʻae kofu ʻo ho kaungāʻapi ko e fakamoʻoni, ke ke toe ʻatu ia kiate ia ʻo feʻunga mo e tō ʻae laʻā. ");
INSERT INTO ton_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","He ko hono kofu pe ia, ko e kofu ʻo hono kili: pea ko e hā ʻe mohe ai ia? Pea ka tangi ia kiate au, pea ʻe pehē, Te u ongoʻi, he ʻoku ou angaʻofa. ");
INSERT INTO ton_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","¶ “ʻOua naʻa ke lauʻikovi ʻae kau fakamaau, pe kapeʻi ʻae pule ʻa hoʻo kakai. ");
INSERT INTO ton_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","¶ “ʻOua naʻa ke fakatuai ʻi he ʻatu hoʻo ngaahi ʻuluaki fua kuo motuʻa, mo e meʻainu; ko e ʻuluaki ʻi ho ngaahi foha te ke foaki kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Pea ke fai pehē pe foki ki hoʻo fanga pulu pea mo hoʻo fanga sipi: ʻe nofo ʻae ʻuhiki mo ʻene faʻē ʻi he ʻaho ʻe fitu: ʻi hono ʻaho valu te ke foaki mai ia kiate au. ");
INSERT INTO ton_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","¶ “Pea te mou ʻiate au ko e kau tangata māʻoniʻoni: pea ʻe ʻikai te mou kai ha kakano kuo haehae ʻe he fanga manu ʻi he vao; ka te mou lī ia ki he fanga kulī. ");
INSERT INTO ton_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ʻOua naʻa ke fakatupu ʻae ongoongo loi; ʻoua naʻa ke kuku nima mo e kau angakovi ke hoko ʻae fakamoʻoni taʻetotonu. ");
INSERT INTO ton_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","¶ “ʻOua naʻa ke muimui ki he tokolahi ke fai kovi: ʻoua naʻa ke lea fakaangimui pe ki he tokolahi ke fakapikoʻi ʻae fakamaau. ");
INSERT INTO ton_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","¶ “Pea ʻoua naʻa ke tokoni kovi ki he tangata masiva. ");
INSERT INTO ton_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","¶ “Pea kapau ʻoku mo fetaulaki mo e pulu pe ko e ʻasi ʻa ho fili ʻoku ʻalu hē, ko e moʻoni te ke toe ʻomi ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kapau ʻoku ke mamata ki he ʻasi ʻo ia ʻoku fehiʻa kiate koe ʻoku tokoto kuo taʻomia ia ʻe heʻene kavenga, pea ʻoku ʻikai te ke fie tokoni ia, ko e moʻoni te ke tokoni ia. ");
INSERT INTO ton_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","¶ “ʻOua naʻa ke fakahalaʻi ʻae fakamaau ʻo hoʻo kakai masiva ʻi heʻene meʻa. ");
INSERT INTO ton_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Taʻofi koe ke ke mamaʻo mei he meʻa loi: pea ʻoua naʻa ke tāmateʻi ʻae taʻehalaia mo e māʻoniʻoni: koeʻuhi ʻe ʻikai te u fakatonuhia ʻae angakovi. ");
INSERT INTO ton_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","¶ “Pea ʻoua naʻa ke maʻu ha meʻa foaki: he ko e meʻa foaki, ʻoku ne fakakui ʻae poto, mo ne fakahalaʻi ʻae ngaahi lea ʻae māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","¶ “Pea ʻoua naʻa ke fakafiuʻi foki ʻae muli; he ʻoku mou ʻilo ʻae loto ʻoe muli, he naʻa mou nofo ko e kau muli ʻi he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","¶ “Pea te ke tō ho fonua ʻi he taʻu ʻe ono, mo ke tānaki hono ngaahi fua ʻo ia: ");
INSERT INTO ton_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ka ko hono fitu ʻoe taʻu, ke ke tuku ia ke mālōlō, pea taʻeueʻi: koeʻuhi ke kai ʻe he masiva ʻi ho kakai: pea ko ia ʻoku tuku ʻekinautolu ʻe kai ia ʻe he fanga manu ʻoe vao: pea te ke fai pehē pe ki hoʻo ngoue vaine, mo hoʻo ngoue ʻolive. ");
INSERT INTO ton_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ke ke fai hoʻo ngāue ʻi he ʻaho ʻe ono, pea ke mālōlō ʻi hono fitu ʻoe ʻaho: ke mālōlō ai hoʻo pulu, mo hoʻo asi, mo e tama ʻa hoʻo kaunanga, mo e muli, pea ke nau maʻu ʻae fiemālie. ");
INSERT INTO ton_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Pea ko e meʻa kotoa pē kuo u tala kiate kimoutolu, mou tokanga lelei ki ai: pea ʻoua siʻi naʻa ke lea ki he hingoa ʻoe ngaahi ʻotua kehe, pea ke ʻoua naʻa ongoʻi ia mei homou ngutu. ");
INSERT INTO ton_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","¶ “ʻE liunga tolu hoʻo fai ʻae kātoanga kiate au ʻi he taʻu. ");
INSERT INTO ton_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ke ke fai ʻae kātoanga ʻoe mā taʻefakalēvani: (ke ke kai mā taʻefakalēvani ʻi he ʻaho ʻe fitu, ʻo hangē ko ʻeku fekau kiate koe, ʻi he ʻaho tuʻutuʻuni ʻi he māhina ko ʻApipi; he naʻa ke haʻu ai mei ʻIsipite; pea ʻoua naʻa haʻu mola pe ha tokotaha ki hoku ʻao.) ");
INSERT INTO ton_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mo e kātoanga ʻoe ututaʻu, ko e ʻuluaki fua ʻo hoʻo ngoue ʻaia naʻa ke tūtuuʻi ʻi hoʻo ngoue: pea mo e kātoanga ʻoe tānaki, ʻaia ʻoku fai ʻi he ngataʻanga ʻoe taʻu, hili hao tānaki fakataha hoʻo ngāue mei he ngoue. ");
INSERT INTO ton_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","‌ʻE fakahā liunga tolu ʻi he taʻu ʻa hoʻo kakai tangata kotoa pē ʻi he ʻao ʻo Sihova ko e ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ʻOua naʻa ke ʻatu ʻae toto ʻo hoku feilaulau fakataha mo e mā kuo fakalēvani: pea ʻoua naʻa tuku ʻae ngako ʻo hoku feilaulau ki he ʻapongipongi. ");
INSERT INTO ton_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ko e polopolo ʻoe ngaahi ʻuluaki fua ʻo ho fonua ke ke ʻomi ki he fale ʻo Sihova ko ho ʻOtua. “ʻOua naʻa ke haka ʻae ʻuhikiʻi sipi pe ko e kosi ʻi he huhuʻa ʻo ʻene faʻē. ");
INSERT INTO ton_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","¶ “Vakai, ʻoku ou fekau ha ʻĀngelo ke muʻomuʻa ʻi ho ʻao, ke tataki koe ʻi he hala, pea ke ʻomi koe ki he potu ʻaia kuo u teuteuʻi. ");
INSERT INTO ton_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Pea ke tokanga kiate ia, pea fai talangofua ki hono leʻo, ʻoua naʻa ke fakahouhau kiate ia; koeʻuhi ʻe ʻikai te ne fakamolemole hoʻomou ngaahi talangataʻa: he ʻoku ʻiate ia ʻa hoku huafa. ");
INSERT INTO ton_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pea kapau te ke fai talangofua moʻoni ki hono leʻo, ʻo fai ʻaia kotoa pē ʻoku ou tala: te u hoko ai ko e fili au ki ho ngaahi fili, pea te u tautea ʻakinautolu ʻoku tautea koe. ");
INSERT INTO ton_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","He ko ʻeku ʻĀngelo ʻe muʻomuʻa ʻiate koe, ʻo ne ʻomi koe ki he kakai ʻAmoli, mo e kau Heti, mo e kau Pelesi, mo e kau Kēnani, mo e kau Hevi, mo e kau Sepusi; pea te u tuʻusi ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","‌ʻOua naʻa ke punou koe ki honau ngaahi ʻotua, pe tauhi ʻakinautolu, pe fai ʻo hangē ko ʻenau ngaahi ngāue, ka ke fakaʻauha ʻaupito ʻakinautolu, mo holoki hifo ʻaupito ʻenau ngaahi meʻa fakatātā. ");
INSERT INTO ton_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Pea te mou tauhi ʻa Sihova ko homou ʻOtua, pea te ne tāpuakiʻi hoʻo mā mo hoʻo vai: pea te u toʻo ʻae mahaki ʻo ʻave ia meiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","¶ ʻE ʻikai ha meʻa ʻe fānau taʻehoko, pe paʻa ʻi ho fonua: ko hono lau ʻo ho ngaahi ʻaho te u fakakakato. ");
INSERT INTO ton_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Te u fekau ke muʻomuʻa ʻiate koe hoku manavahēʻia, pea te u fakaʻauha ʻae kakai kotoa pē ʻaia te ke hoko ki ai, pea te u ngaohi ha ngaahi fili ke nau fulituʻa kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Pea te u fekau ke muʻomuʻa ʻiate koe ʻae fanga langomū, pea te nau kapusi mei ho ʻao, ʻae kau Hevi, mo e kau Kēnani, mo e kau Heti. ");
INSERT INTO ton_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","‌ʻE ʻikai te u kapusi ʻakinautolu mei ho ʻao ʻi he taʻu pe taha: telia naʻa ngaongao ai ʻae fonua, pea tupu ʻo lahi ai kiate koe ʻae fanga manu ʻoe vao. ");
INSERT INTO ton_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Te u kapusi fakaholoholo pe ʻakinautolu mei ho ʻao, kaeʻoua ke mou tupu ʻo tokolahi, pea maʻu ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Pea te u tuku ho ngataʻanga mei he tahi Kulokula, ʻo aʻu ki he tahi ʻoe kakai Filisitia, pea mei he toafa ʻo aʻu ki he vaitafe lahi: he te u tukuange ʻae kakai ʻoe fonua ki homou nima; pea te ke kapusi ʻakinautolu mei ho ʻao. ");
INSERT INTO ton_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","‌ʻOua naʻa ke fai ha fuakava mo kinautolu, pe ki honau ngaahi ʻotua. ");
INSERT INTO ton_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","‌ʻE ʻikai te nau nofo ʻi ho fonua, telia naʻa nau fakafaihalaʻi koe kiate au: he kapau te ke tauhi honau ngaahi ʻotua, ko e moʻoni ʻe fakahalahala ai koe.” ");
INSERT INTO ton_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Pea pehē ʻe ia kia Mōsese, “ʻAlu hake koe kia Sihova, ʻa koe mo ʻElone, mo Natapi, mo ʻApiu, mo e kau mātuʻa ʻo ʻIsileli ʻe toko fitungofulu; pea punou hifo ʻakimoutolu mei he mamaʻo ʻo hū. ");
INSERT INTO ton_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Pea ko Mōsese tokotaha pe ʻe haʻu ʻo ofi kia Sihova: kaeʻoua te nau haʻu ʻo ofi; pea ʻoua naʻa ʻalu hake ʻae kakai mo ia.” ");
INSERT INTO ton_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","¶ Pea naʻe haʻu ʻa Mōsese ʻo ne tala ki he kakai ʻae ngaahi folofola kotoa pē ʻa Sihova, mo e ngaahi fono kotoa pē; pea tali lea taha pe ʻae kakai kotoa pē, ʻonau pehē, “Ko e ngaahi lea kotoa pē kuo folofolaʻaki ʻe Sihova te mau fai.” ");
INSERT INTO ton_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Pea naʻe tohi ʻe Mōsese ʻae ngaahi folofola kotoa pē ʻa Sihova, pea tuʻu hengihengi hake ia ʻi he pongipongi, ʻo ne langa ʻae feilaulauʻanga ʻi he lalo moʻunga, mo e maka ʻe hongofulu ma ua, ʻo fakatatau ki he faʻahinga ʻe hongofulu ma ua ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Pea fekau ʻe ia ʻae kau talavou ʻi he fānau ʻa ʻIsileli, pea naʻa nau ʻatu ʻae ngaahi feilaulau tutu kia Sihova, mo e ngaahi feilaulau ʻoe melino, ko e fanga pulu. ");
INSERT INTO ton_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Pea naʻe toʻo ʻe Mōsese hono vaeua mālieʻanga ʻoe toto, ʻo ne lingi ia ki he ngaahi ipu; pea ko hono vahe ʻe taha ʻoe toto naʻa ne luluku ʻaki ʻae feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Pea toʻo ʻe ia ʻae tohi ʻoe fuakava, ʻo ne lau ia ke ongoʻi ʻe he kakai: pea naʻa nau tala, ‘Ko e meʻa kotoa pē kuo folofola ki ai ʻa Sihova te mau fai, pea te mau talangofua.” ");
INSERT INTO ton_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Pea naʻe toʻo ʻe Mōsese ʻae toto, ʻo ne luluku ia ki he kakai, ʻo ne pehē, “Vakai, ko e toto ʻoe fuakava, ʻaia kuo fai ʻe Sihova mo kimoutolu ʻi he ngaahi folofola ni kotoa pē.” ");
INSERT INTO ton_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","¶ Pea toki ʻalu hake ai ʻa Mōsese, mo ʻElone, mo Natapi, mo ʻApiu, mo e kau mātuʻa ʻo ʻIsileli ʻe toko fitungofulu. ");
INSERT INTO ton_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Pea naʻa nau mamata ki he ʻOtua ʻo ʻIsileli; pea naʻe ʻi hono lalo vaʻe ʻae ngāue ʻo hangē ha faliki maka ko e safaia, pea naʻe tatau mo e langi maʻa ʻa hono malama. ");
INSERT INTO ton_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Pea naʻe ʻikai hili hono nima ki he kau mātuʻa ʻoe fānau ʻa ʻIsileli; pea naʻa nau mamata ki he ʻOtua foki, ʻonau kai mo inu. ");
INSERT INTO ton_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu hake koe kiate au ʻi he moʻunga, pea nofo ai: pea te u tuku kiate koe ʻae maka lafalafa ʻe ua, pea mo e fono, mo e ngaahi fekau kuo u tohi; koeʻuhi ke ke ako ʻaki ia.” ");
INSERT INTO ton_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Pea naʻe tuʻu hake ʻa Mōsese mo hono tauhi ko Siosiua: pea naʻe ʻalu hake ʻa Mōsese ki he moʻunga ʻoe ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Pea naʻe tala ʻe ia ki he kau mātuʻa, “Mou tatali ʻi heni kiate kimaua, ke ʻoua ke ma toe ʻomi kiate kimoutolu: pea vakai, ʻoku ʻiate kimoutolu ʻa ʻElone, mo Hua: kapau ʻe ai ha meʻa ʻi ha tangata ke fai, ke haʻu ia kiate kinaua.” ");
INSERT INTO ton_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Pea naʻe ʻalu hake ʻa Mōsese ki he moʻunga, pea naʻe ʻuʻufi ʻae moʻunga ʻe he ʻao. ");
INSERT INTO ton_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Pea naʻe nofo mai ʻae nāunau ʻo Sihova ki he moʻunga ko Sainai, pea naʻe ʻuʻufi ia ʻe he ʻao ʻi he ʻaho ʻe ono: pea naʻe folofola ia kia Mōsese ʻi hono fitu ʻoe ʻaho mei he loto ʻao. ");
INSERT INTO ton_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Pea naʻe hā mai ʻae nāunau ʻo Sihova ʻo hangē ko e afi fakaʻauha ʻi he tumutumu ʻoe moʻunga, ʻi he ʻao ʻoe fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Pea naʻe ʻalu ʻa Mōsese ki he loto ʻao, ʻo ʻalu hake ki he moʻunga: pea naʻe ʻi he moʻunga ʻa Mōsese ʻi he ʻaho ʻe fāngofulu mo e pō ʻe fāngofulu. ");
INSERT INTO ton_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Ke ke lea ki he fānau ʻa ʻIsileli, ke nau ʻomi kiate au ʻae meʻaʻofa; pea ʻilonga ʻae tangata kotoa pē ʻoku foaki loto lelei pe, te mou maʻu mei ai ʻeku meʻaʻofa. ");
INSERT INTO ton_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Pea ko e meʻaʻofa ʻeni te mou maʻu ʻiate kinautolu; ko e koula, mo e siliva, mo e palasa. ");
INSERT INTO ton_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e silika, mo e fulufuluʻi kosi, ");
INSERT INTO ton_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Mo e kili ʻoe sipitangata kuo tuku kula, mo e kili ʻoe pasa, mo e ʻakau ko e sitimi, ");
INSERT INTO ton_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Mo e lolo ke maama ʻaki, mo e ʻakau nanamu ki he lolo tākai, pea ki he meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ko e maka ko e oniki, mo e maka ke ʻai ki he ʻefoti, pea ki he sifa fatafata. ");
INSERT INTO ton_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Pea tuku ke nau ngaohi kiate au ʻae Potu Toputapu; koeʻuhi ke u nofo ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Te mou ngaohi ia ʻo fakatatau ki he ngaahi meʻa kotoa pē te u fakahā kiate koe, ki he fakatātā ʻoe fale fehikitaki, mo e fakatātā ʻo hono ngaahi nāunau kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","¶ “Pea te nau ngaohi ha puha ʻoe ʻakau ko e sitimi: ko e hanga ʻe nima mo e toe ʻa hono lōloa ʻo ia, pea ko e hanga ʻe tolu ʻa hono māukupu, mo e hanga ʻe tolu ʻa hono māʻolunga. ");
INSERT INTO ton_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pea ke ʻaofi ʻaki ia ʻae koula haohaoa, ke ke ʻaofi ia ʻi loto mo tuʻa, pea ke ngaohi ʻi ai ʻae tatā koula ke takatakai. ");
INSERT INTO ton_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Pea te ke ngaohi hono kavei koula ʻe fā, ʻo ʻai ia ki hono tuliki ʻe fā; ʻe ai ʻae kavei ʻe ua ʻi hono faʻahi ʻe taha, mo e kavei ʻe ua ʻi hono faʻahi ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Pea ke ngaohi ʻae ongo haʻamo mei he ʻakau ko e sitimi, ʻo ʻaofi ia ʻaki ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Pea ke velo ʻae haʻamo ki he kavei ʻi he potu ʻe ua ʻoe puha, koeʻuhi ke haʻamo ʻaki ʻae puha. ");
INSERT INTO ton_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","‌ʻE tuku maʻuaipē ʻae ongo haʻamo ʻi he kavei ʻoe puha: ʻe ʻikai toʻo ʻo ʻave ia mei ai. ");
INSERT INTO ton_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Pea te ke ai ki he loto puha ʻae tohi ʻoe fuakava, ʻaia te u ʻatu kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Pea te ke ngaohi ʻae nofoʻanga ʻaloʻofa ʻaki ʻae koula haohaoa: ko e hanga ʻe nima ʻa hono lōloa ʻo ia, mo e hanga ʻe tolu ʻa hono māukupu. ");
INSERT INTO ton_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Pea te ke ngaohi ʻae selupimi koula ʻe ua, ke ke ngaohi ia ʻaki ʻae koula tuki, ʻi hono tā ʻe ua ʻoe nofoʻanga ʻaloʻofa. ");
INSERT INTO ton_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Pea te ke ngaohi ʻae selupi ʻe tahake tuʻu ʻi he tā ʻe taha, mo e selupi ʻe taha ke tuʻu ʻi he tā ʻe taha; ʻe ʻi he nofoʻanga ʻaloʻofa ʻae ongo selupimi ʻi hono tā ʻe ua ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Pea ʻe mafola atu hona kapakau ʻi ʻolunga ʻe he ongo selupimi, ke maluʻi ʻae nofoʻanga ʻaloʻofa ʻaki hona kapakau, pea ʻe fehangaʻaki hona mata, ʻo na femamataʻaki; pea ʻe hanga ki he nofoʻanga ʻaloʻofa ʻae mata ʻoe ongo selupimi. ");
INSERT INTO ton_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Pea te ke hilifaki ʻae nofoʻanga ʻaloʻofa ki ʻolunga ki he funga puha; pea te ke ʻai ki loto ʻi he puha ʻae tohi ʻoe fuakava ʻaia te u ʻatu kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Pea te u fakafetaulaki ʻi ai kiate koe, pea te tā lea ai mo koe mei ʻolunga ʻi he nofoʻanga ʻaloʻofa, mei he vahaʻa ʻoe ongo selupimi, ʻaia ʻoku ʻi he funga ʻoe puha ʻoe fuakava, ki he ngaahi meʻa kotoa pē ʻaia te u fekau atu ai kiate koe, ki he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","¶ “Pea te ke ngaohi foki ʻae palepale mei he ʻakau ko e sitimi: ko e hanga ʻe fā ʻa hono lōloa, mo e hanga ʻe ua ʻa hono māukupu ʻo ia, mo e hanga ʻe tolu ʻa hono māʻolunga. ");
INSERT INTO ton_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Pea te ke ʻaofi ia ʻaki ʻae koula haohaoa, mo ke ngaohi ʻi ai ʻae tatā koula ke takatakai. ");
INSERT INTO ton_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Pea te ke ngaohi ki ai hono tapa takatakai ko e ʻaofinima ʻe taha hono lau lahi; pea ke ngaohi ha tatā takatakai. ");
INSERT INTO ton_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Pea te ke ngaohi hono kavei koula ʻe fā, pea ʻai ʻae kavei ki hono tuliki ʻe fā, ʻaia ʻoku ʻi hono vaʻe ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","‌ʻE tuʻu hanga tonu atu ʻae ngaahi kavei mo hono tapa ke velo ai ʻae ʻakau ke haʻamo ʻaki ʻae palepale. ");
INSERT INTO ton_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Pea te ke ngaohi ʻae haʻamo ʻaki ʻae ʻakau ko e sitimi, ʻo ʻaofi ʻaki ia ʻae koula, ke haʻamo ʻaki ʻae palepale. ");
INSERT INTO ton_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Pea te ke ngaohi ʻa hono ngaahi ipu, mo hono ngaahi meʻa ohu, mo hono ngaahi tāpuni, mo hono ngaahi ipu luoluo, ke lingi ki ai: ke ke ngaohi ia kotoa pē ʻaki ʻae koula haohaoa. ");
INSERT INTO ton_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Pea te ke hili maʻuaipē ʻae mā ʻoe ʻao ki he palepale ʻi hoku ʻao. ");
INSERT INTO ton_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","¶ “Pea te ke ngaohi ʻae tuʻunga maama koula haohaoa: ʻe ngaohi ʻae tuʻunga maama ʻaki ʻae ngāue tuki: ko hono kau, mo hono ngaahi pasanga mo hono ngaahi ipu siʻi, mo hono ngaahi teunga potopoto, mo hono ngaahi fisiʻiʻakau, ʻe ʻi he meʻa pe ko ia. ");
INSERT INTO ton_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Pea ʻe tuʻu ʻae pasanga ʻe ono mei hono potu ʻe ua: ko e pasanga ʻe tolu mei he potu ʻe taha ʻoe tuʻunga maama, mo e pasanga ʻe tolu mei he potu kehe ʻoe tuʻunga maama: ");
INSERT INTO ton_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ko e ipu ʻaiʻanga lolo ʻe tolu kuo ngaohi ʻo hangē ko e fuaʻi telie, ko e teunga potopoto mo hono fisiʻiʻakau ʻi he pasanga ʻe taha; mo e ipu ʻaiʻanga lolo ʻe tolu kuo ngaohi ʻo hangē ko e fuaʻi telie ʻi he pasanga ʻe taha, mo hono teunga potopoto mo hono fisiʻiʻakau: pea ʻe pehē pe ʻi he pasanga ʻe ono ʻoku tuʻu ʻi he tuʻunga maama. ");
INSERT INTO ton_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Pea ʻe ʻai ʻae ipu ʻaiʻanga lolo ʻe fā ʻi he tuʻunga maama kuo ngaohi ʻo hangē ko e fuaʻi telie mo honau ngaahi teunga potopoto mo hono ngaahi fisiʻiʻakau. ");
INSERT INTO ton_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Pea ʻe ʻai ʻae teunga potopoto ʻe taha ʻi lalo ʻi he pasanga ʻe ua, mo e teunga potopoto ʻe taha ʻi lalo ʻi he pasanga ʻe ua, mo e teunga potopoto ʻe taha ʻi lalo ʻi he pasanga ʻe ua, ʻo fakatatau ki he pasanga ʻe ono ʻoku tuʻu ʻi he tuʻunga maama. ");
INSERT INTO ton_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ko honau ngaahi teunga potopoto mo e ngaahi pasanga, ʻe ngaohi ia kotoa pē ʻi he koula haohaoa kuo tuki. ");
INSERT INTO ton_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Pea te ke ngaohi hono foʻi maama ʻe fitu ʻo ia: pea te nau tutu ʻae maama ʻi ai, koeʻuhi ke nau fakamaama ʻae potu ko ia. ");
INSERT INTO ton_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Pea ko hono helekosi, mo hono ʻaiʻanga efu; ʻe ngaohi ʻaki ia ʻae koula haohaoa. ");
INSERT INTO ton_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Te ne ngaohi ia mo e ngaahi ipu ni kotoa pē, ʻaki ʻae taleniti koula haohaoa pe taha. ");
INSERT INTO ton_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Pea vakai ʻe koe, ke ngaohi ʻae meʻa kotoa pē, ʻo fakatatau ki hono fakatātā, ʻaia naʻe fakahā kiate koe ʻi he moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Pea te ke ngaohi foki ʻae fale fehikitaki mo e puipui ʻe hongofulu ʻaki ʻae tupenu tuʻovalevale, mo e lanu moana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho: mo e selupimi kuo ngaohi fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ko hono lōloa ʻoe puipui ʻe taha, ko e hanga ʻe nimangofulu ma ono, mo hono māukupu ʻoe puipui pe taha ko e hanga ʻe valu: pea ʻe fuofua tatau pe ʻae ngaahi puipui kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pea ko e puipui ʻe nima ʻe fakahoko ʻae taha ki he taha; pea ko e puipui kehe ʻe nima ʻe fakahoko ʻae taha ki he taha. ");
INSERT INTO ton_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Pea te ke ngaohi ʻae ngaahi kavei lanumoana ki he kapa ʻoe puipui ʻe taha mei he kapa ʻi he hokoʻanga; pea ke fai pehē pe, ʻi he kapa ʻoe puipui ʻe taha, ʻi he hokoʻanga ʻo hono ua. ");
INSERT INTO ton_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ke ke ngaohi ʻae kavei ʻe nimangofulu ki he puipui ʻe taha, pea mo e kavei ʻe nimangofulu ki he kapa ʻoe puipui ʻoku ʻi he hokoʻanga ʻo hono ua: koeʻuhi ke fehokotaki ia. ");
INSERT INTO ton_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Pea ke ngaohi ʻae fakamaʻu koula ʻe nimangofulu, ke fakahoko ʻaki ʻae puipui pea ʻe hoko ia ko e fale fehikitaki pe taha. ");
INSERT INTO ton_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","¶ “Pea te ke ngaohi ʻae ngaahi puipui mei he fulufuluʻi kosi ke fakapulonga ʻaki ʻae fale fehikitaki: ke ke ngaohi ʻae puipui ʻe hongofulu ma taha. ");
INSERT INTO ton_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ko hono lōloa ʻoe puipui ʻe taha ko e hanga ʻe onongofulu, mo hono māukupu ʻo ia, ko e hanga ʻe valu: pea ʻe fua tatau pe ʻae puipui ʻe hongofulu ma taha. ");
INSERT INTO ton_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pea ke hokohoko ʻae puipui ʻe nima ke taha pe, mo e puipui ʻe ono ke fakataha, pea ke peluki hono ono ʻoe puipui ʻi he ʻao ʻoe mata fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Pea te ke ngaohi ʻae kavei ʻe nimangofulu ʻi he kapa ʻoe puipui ʻe taha ʻaia ʻoku ʻituʻa ʻi he hokoʻanga, mo e kavei ʻe nimangofulu ʻi he kapa ʻoe puipui ʻoku hokohoko ki hono ua. ");
INSERT INTO ton_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Pea te ke ngaohi ʻae fakamaʻu palasa ʻe nimangofulu, pea ʻai ʻae fakamaʻu ki he ngaahi kavei, ʻo hokohoko ʻaki ʻae fakapulonga, ke hoko ʻo taha pe ia. ");
INSERT INTO ton_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Pea ko hono konga ʻoku toe ʻi he puipui ʻoe fale fehikitaki, ko e vaeua ʻoe puipui ʻoku toe ʻe tautau pe ia ʻituʻa ʻi he tuʻafale. ");
INSERT INTO ton_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Pea ko e hanga ʻe ua ʻi he faʻahi ʻe taha, mo e hanga ʻe ua ʻi he faʻahi ʻe taha ʻo ia, ʻoku toe ʻi hono lōloa ʻoe ngaahi puipui ʻoe fale fehikitaki, ʻe tāupe ia ki hono faʻahi ʻe ua ʻoe fale ʻi he potu ni, mo e potu na ke ʻufiʻufi ia. ");
INSERT INTO ton_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Pea te ke ngaohi ʻae meʻa fakapulonga ki he fale fehikitaki ʻaki ʻae ngaahi kili ʻoe sipitangata kuo tuku kula, mo e meʻa fakapulonga ʻe taha kituʻa ʻi he ngaahi kiliʻi pasa. ");
INSERT INTO ton_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","¶ “Pea te ke ngaohi ʻae ngaahi laupapa ki he fale fehikitaki mei he ʻakau ko e sitimi ke tuʻu tonu. ");
INSERT INTO ton_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ko hono lōloa ʻoe laupapa ko e hanga ʻe uofulu, mo e hanga ʻe tolu ʻa hono māukupu ʻoe laupapa pe taha. ");
INSERT INTO ton_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ke ua hono hokoʻanga ʻi he laupapa pe taha, ke tuʻu hangatonu atu pe ʻae taha ki he taha: pea ke fai pehē pe ki he laupapa kotoa pē ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Pea te ke ngaohi ʻae ngaahi laupapa ki he fale fehikitaki, ko e laupapa ʻe uofulu ki he feituʻu tonga ke hanga ki tonga. ");
INSERT INTO ton_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Pea ke ngaohi ʻae tuʻunga siliva ʻe fāngofulu ki lalo ʻi he laupapa ʻe uofulu: ko e tuʻunga ʻe ua ki lalo ʻi he laupapa ʻe taha, ki hono mui potu ʻe ua, mo e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha ki hono mui potu ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Pea ki hono potu fakatokelau ʻoe fale fehikitaki ʻe ʻai ʻae laupapa ʻe uofulu. ");
INSERT INTO ton_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Mo honau tuʻunga siliva ʻe fāngofulu; ko e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha, mo e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Pea ke ngaohi ʻae laupapa ʻe ono ki he potu fale fehikitaki ki he toʻangalaʻā. ");
INSERT INTO ton_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Pea te ke ngaohi ʻae laupapa ʻe ua ki he tuliki ʻoe fale fehikitaki ʻi hono faʻahi ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Pea ʻe hokohoko ia ʻi lalo, pea ʻe hokohoko ia ʻi ʻolunga ʻi he ʻulu ʻo ia ki hono kavei ʻe taha: ʻe fai pehē ki ai fakatouʻosi: ko e ongo tuliki ia. ");
INSERT INTO ton_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Pea ko e laupapa ʻe valu ia, mo honau ngaahi tuʻunga siliva, ko e tuʻunga ʻe hongofulu ma ono; ko e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha, mo e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","¶ “Pea te ke ngaohi ʻae ngaahi ʻakau fakalava mei he ʻakau ko e sitimi; ko e nima ki he ngaahi laupapa ʻi he potu ʻe taha ʻoe fale fehikitaki, ");
INSERT INTO ton_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Pea ko e ʻakau fakalava ʻe nima ki he ngaahi laupapa ʻi he potu ʻe taha ʻoe fale fehikitaki, pea ko e ʻakau fakalava ʻe nima ki he ngaahi laupapa ʻoe potu ʻoe fale fehikitaki, ki he potu ʻe ua ki he toʻangalaʻā. ");
INSERT INTO ton_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Pea ko e ʻakau fakalava ʻi loto ʻi he ngaahi laupapa, ʻe tau ia ʻi he potu ʻe taha ʻo aʻu ki he potu ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Pea te ke ʻaofi ʻae ngaahi laupapa ʻaki ʻae koula, pea ngaohi ʻaki ʻae koula honau ngaahi kavei, ke ʻai ki ai ʻae ʻakau fakalava: pea ke ʻaofi ʻae ngaahi ʻakau fakalava ʻaki ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Pea te ke fokotuʻu hake ʻae fale fehikitaki ʻo fakatatau ki he fakatātā ko ia ʻaia naʻe fakahā kiate koe ʻi he moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","¶ “Pea te ke ngaohi ʻae puipui ʻaki ʻae lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, ʻi he ngāue fakapotopoto: pea ʻe ngaohi ki ai ʻae selupimi: ");
INSERT INTO ton_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Pea ke tautau ia ki he pou ʻe fā ʻoe ʻakau ko e sitimi kuo ʻaofi ʻaki ʻae koula; ko e koula pe honau ngaahi tautauʻanga, ki honau tuʻunga siliva ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","¶ “Pea te ke tautau ʻae puipui ʻi lalo ʻi he ngaahi fakamaʻu, koeʻuhi ke ke ʻomi ki ai ki he loto puipui ʻae puha ʻoe fuakava: pea ʻe vaheʻi kiate kimoutolu ʻe he puipui ʻae Potu Tapu mei he Potu Toputapu ʻaupito. ");
INSERT INTO ton_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pea te ke hili ʻae nofoʻanga ʻaloʻofa ki he funga puha ʻoe fuakava ʻi he Potu Toputapu ʻaupito. ");
INSERT INTO ton_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Pea te ke tuku ʻae palepale ʻituʻa ʻi he puipui, mo e tuʻunga maama ke tuʻu ʻo hanga tonu atu ki he palepale ʻi he faʻahi ʻoe fale fehikitaki ʻoku hanga ki tonga: pea te ke tuku ʻae palepale ʻi he potu tokelau. ");
INSERT INTO ton_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Pea te ke ngaohi ʻae meʻa tautau ki he matapā ʻoe fale fehikitaki, ʻoe lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, kuo ngaohi ʻaki ʻae tuitui poto. ");
INSERT INTO ton_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Pea te ke ngaohi ki he meʻa tautau ʻae pou ʻakau sitimi ʻe nima, ʻo ʻaofi ia ʻaki ʻae koula, pea ʻe koula mo honau tautauʻanga: pea te ke haka ki ai ʻae tuʻunga palasa ʻe nima. ");
INSERT INTO ton_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Pea te ke ngaohi ʻae feilaulauʻanga ʻaki ʻae ʻakau ko e sitimi, ko e hanga ʻe hongofulu ʻa hono lōloa, mo e hanga ʻe hongofulu ʻa hono māukupu: ʻe potupotu tatau pe ʻae feilaulauʻanga: pea ko e hanga ʻe ono ʻa hono māʻolunga. ");
INSERT INTO ton_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Pea te ke ngaohi ʻae ngaahi nifo ʻi ai ʻi hono tuliki ʻe fā: ʻe ʻi he meʻa pe ko ia ʻa hono ngaahi nifo: pea te ke ʻaofi ʻaki ia ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Pea te ke ngaohi hono ngaahi ipu fakatalinga efuefu, mo hono ngaahi huo lafalafa, mo hono ngaahi ipu luoluo, mo hono ngaahi huhu, mo e ngaahi ipu ʻaiʻanga afi: ko hono ngaahi ipu kotoa pē ke ke ngaohi ʻaki ia ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pea te ke ngaohi ki ai ʻae meʻa vangavanga ʻaki ʻae palasa; pea ke ngaohi ʻi he meʻa vangavanga ʻae kavei palasa ʻe fā ʻi hono tuliki ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Pea ke ʻai ia ki lalo ʻi hono ngataʻanga ʻoe feilaulauʻanga ki loto, koeʻuhi ke hoko atu ʻae meʻa vangavanga ʻo aʻu hifo ki he vaeua ʻoe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Pea ke ngaohi ʻae haʻamo ki he feilaulauʻanga, ko e ongo haʻamo mei he ʻakau ko e sitimi, ʻo ʻaofi ia ʻaki ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Pea ʻe velo ʻae ongo haʻamo ki he kavei, pea ʻe ʻi hono potu ʻe ua ʻoe feilaulauʻanga ʻae ongo haʻamo ke haʻamo ʻaki. ");
INSERT INTO ton_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ke ke ngaohi ia ʻaki ʻae laupapa ke luoluo ʻi loto: ʻo hangē ko ia naʻe fakahā kiate koe ʻi he moʻunga, te nau ngaohi pehē pe ia. ");
INSERT INTO ton_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","¶ “Pea te ke ngaohi ʻae lotoʻā ʻoe fale fehikitaki: ki he potu ʻoku hanga ki tonga ʻe ai ʻae ngaahi puipui tautau ʻoe tupenu tuʻovalevale, ko e hanga ʻe uangeau hono lōloa ki he potu ʻe taha: ");
INSERT INTO ton_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Pea ko hono pou ʻe uofulu mo hono ngaahi tuʻunga ko e palasa ia; ko e ngaahi tautauʻanga ʻoe ngaahi pou mo honau tākai ko e siliva ia. ");
INSERT INTO ton_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Pea ʻe pehē pe ki he potu tokelau, ʻe ai ʻae ngaahi puipui tautau ko e hanga ʻe uangeau hono lōloa, mo hono pou ʻe uofulu mo honau tuʻunga palasa ʻe uofulu; ko e ngaahi tautauʻanga ʻe ʻi he ngaahi pou mo honau ngaahi meʻa tākai ko e siliva. ");
INSERT INTO ton_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","¶ Pea ki hono māukupu ʻoe lotoʻā ʻi he potu lulunga ʻe ai ʻoe ngaahi puipui tautau ko e hanga ʻe teau: ke hongofulu honau pou pea hongofulu mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Pea ko hono māukupu ʻoe lotoʻā ʻi he potu hahake ko e hanga ʻe teau. ");
INSERT INTO ton_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Koe puipui tautau ʻi he potu ʻe taha ʻoe matapā, ko e hanga ʻe tolungofulu: ke tolu honau pou, pea tolu mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Pea ʻi hono potu ʻe taha ʻe ai ʻae puipui tautau ko e hanga ʻe uofulu: ke tolu honau pou, pea tolu mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pea ʻe ʻai ki he matapā ʻoe lotoʻā ʻae puipui tautau, ko e hanga ʻe fāngofulu, ʻoe lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, kuo ngaohi ʻaki ʻae tuitui poto: ke fā honau pou, pea fā mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ko e ngaahi pou kotoa pē ʻoku tuʻu takatakai ʻi he lotoʻā ʻe tākai ʻaki ia ʻae siliva; ʻe siliva honau tautauʻanga, pea ko e palasa honau ngaahi tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","¶ Ko hono lōloa ʻoe lotoʻā ko e hanga ʻe uangeau, pea ko e hanga ʻe teau ʻa hono māukupu ʻi he potu kotoa pē, pea ko e hanga ʻe hongofulu hono māʻolunga, ʻoe tupenu tuʻovalevale, pea ko e palasa honau ngaahi tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ko e ngaahi ipu kotoa pē, ʻoe fale fehikitaki ʻi hono fāinga ngāue kotoa pē, mo hono ngaahi faʻo kotoa pē ʻo ia, mo e ngaahi faʻo kotoa pē ʻoe lotoʻā, ko e palasa ia. ");
INSERT INTO ton_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","¶ “Pea te ke fekau ki he fānau ʻa ʻIsileli, koeʻuhi ke nau ʻomi kiate koe ʻae lolo ʻolive maʻa kuo tuki, ki he maama, koeʻuhi ke fakaulo maʻu pe ʻae maama, ");
INSERT INTO ton_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","‌ʻI he fale fehikitaki ʻoe kakai ʻi he tuʻapuipui, ʻaia ʻoku ʻi he ʻao ʻoe fuakava, ʻe tuʻu ʻi ʻai ʻe ʻElone mo hono ngaahi foha mei he efiafi ki he pongipongi, ʻi he ʻao ʻo Sihova: ko e fekau fai maʻu pe ia ʻo taʻengata ki honau ngaahi toʻutangata, koeʻuhi ko e fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Pea te ke ʻomi kiate Ko e ho taʻokete ko ʻElone, mo hono ngaahi foha mo ia, mei he fānau ʻa ʻIsileli, koeʻuhi ke ngāue ia kiate au ʻi he ngāue ʻae taulaʻeiki, ʻio, ʻa ʻElone, mo Natapi, mo ʻApiu, mo ʻEliesa, mo ʻItama, ko e ngaahi foha ʻo ʻElone. ");
INSERT INTO ton_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pea te ke ngaohi ʻae ngaahi kofu tapu ki ho taʻokete ko ʻElone ke fakaʻeiʻeiki mo matamatalelei. ");
INSERT INTO ton_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Pea te ke lea kiate kinautolu ʻoku loto poto, ʻaia kuo u fakafonu ʻaki ʻae laumālie poto, koeʻuhi ke nau ngaohi ʻae ngaahi kofu ʻo ʻElone, ke fakatapui ia, koeʻuhi ke ne ngāue kiate au ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Pea ko e ngaahi kofu ʻeni te nau ngaohi; ko e sīfafatafata, mo e ʻefoti, mo e kofu fakatōtōlofa mo e kofu kuo fakanikonikoʻi, mo e tatā, mo e noʻo: pea te nau ngaohi ʻae ngaahi kofu tapu kia ʻElone ko ho taʻokete, mo hono ngaahi foha, koeʻuhi ke ngāue ia kiate au ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","¶ “Pea te nau toʻo ʻae koula mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Pea te nau ngaohi ʻae ʻefoti ʻaki ʻae koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, ʻi he ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ko hono potu ʻe ua ʻi he uma ʻe fakahoko fakataha ʻi hono kapa; pea ʻe hoko ʻo fakataha ia. ");
INSERT INTO ton_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Pea ko e noʻo fakanikonikoʻi ʻoe ʻefoti, ʻaia ʻoku ʻi ai, ʻe ʻi he meʻa pe ko ia, ʻo fakatatau ki hono ngaohi: ʻio, ʻae koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Pea te ke toʻo ʻae maka ʻoniki ʻe ua, ʻo tohi tongi ki ai ʻae ngaahi hingoa ʻoe fānau ʻa ʻIsileli: ");
INSERT INTO ton_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ke ʻi he maka ʻe taha ʻae hingoa ʻe ono, mo e hingoa ʻe ono ke ʻi he maka ʻe taha, ʻo fakatatau ki heʻenau hohoko. ");
INSERT INTO ton_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Te ke tongitongi ʻae ngaahi hingoa ʻoe fānau ʻa ʻIsileli ʻi he ongo maka, ʻaki ʻae ngāue ʻae tufunga tongi maka, pea hangē ko e tongitongi ʻoe mama; te ke ngaohi ia ke maʻu ʻi he ʻaiʻanga koula. ");
INSERT INTO ton_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Pea te ke ʻai ʻae maka ʻe ua ki he uma ʻoe ʻefoti ko e ongo maka fakamanatu ki he fānau ʻa ʻIsileli: pea ʻe fua honau hingoa ʻe ʻElone ʻi hono uma ʻe ua ʻi he ʻao ʻo Sihova, ko e meʻa fakamanatu. ");
INSERT INTO ton_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","¶ “Pea te ke ngaohi ʻae ongo fakamaʻu koula; ");
INSERT INTO ton_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Mo e seini koula haohaoa ʻe ua ʻi hono mui ʻe ua; te ke ngaohi ia ʻi he ngāue fihifihi, pea fakamaʻu ʻae ongo seini fihifihi ki he ongo fakamaʻu. ");
INSERT INTO ton_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","¶ “Pea te ke ngaohi ʻae sīfafatafata ʻoe fakamaʻu ʻi he ngāue fakapotopoto; te ke ngaohi ia ʻo hangē ko e ngāue ʻae ʻefoti: ʻi he koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale te ke ngaohi ʻaki ia. ");
INSERT INTO ton_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","‌ʻE tatau pe hono potu ʻe fā ʻoka pelu ua; ko e hanga pe taha hono lōloa ʻo ia, mo e hanga pe taha hono māukupu ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Pea te ke fakamaʻu ki ai ke fono ʻi ai ʻae ʻotu maka ʻe fā: ko hono ʻuluaki ʻotu ko e satio, mo e topasi, mo e kapukeli: ko hono ʻuluaki ʻotu ia. ");
INSERT INTO ton_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Ko hono ua ʻoe ʻotu ko e ʻemalata, mo e safaia, mo e taiamoni. ");
INSERT INTO ton_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Pea ko hono tolu ʻoe ʻotu ko e likua, mo e ʻaketi, mo e ʻametisi. ");
INSERT INTO ton_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Pea ko hono fā ʻoe ʻotu, ko e pelili, mo e ʻoniki, mo e sasipa: ʻe ʻai ʻaki ia ʻae koula ki honau ngaahi tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Pea ʻe ʻi he maka ʻae ngaahi hingoa ʻoe fānau ʻa ʻIsileli, ko e hongofulu ma ua, ʻo fakatatau ki honau hingoa, ʻo hangē ko e tongitongi ʻoe mama: ʻe tuʻutaki taha mo hono hingoa ʻo fakatatau mo honau faʻahinga ʻe hongofulu ma ua. ");
INSERT INTO ton_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","¶ “Pea te ke ngaohi ʻi hono potu ʻe ua ʻoe sīfafatafata ʻae seini ʻoe koula haohaoa ʻoe ngāue fihifihi. ");
INSERT INTO ton_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Pea te ke ngaohi ʻi he sīfafatafata ʻae kavei koula ʻe ua, pea ke ʻai ʻae kavei ʻe ua ki he mui ʻe ua ʻoe sīfafatafata. ");
INSERT INTO ton_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Pea te ke ʻai ʻae seini koula fihifihi ʻe ua ʻi he kavei ʻe ua ʻoku ʻi he mui ʻe ua ʻoe sīfafatafata. ");
INSERT INTO ton_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Pea ko hono potu kehe ʻe ua ʻoe seini fihifihi te ke fakamaʻu ki he fakamaʻu, ʻo tuku ia ki he potu ʻe ua ʻoe uma ʻi he ʻefoti ʻi hono ʻao. ");
INSERT INTO ton_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","¶ “Pea te ke ngaohi ʻae kavei koula ʻe ua, pea ʻai ia ki he mui ʻe ua ʻoe sīfafatafata ʻi hono kapa, ʻaia ʻoku ʻi he potu ʻoe ʻefoti ki loto, ");
INSERT INTO ton_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Pea te ke ngaohi ʻae kavei koula ʻe ua, ʻo ʻai ia ki he potu ʻe ua ʻoe ʻefoti ʻi lalo, ʻo ofi ki hono potu ki ʻao, ʻo hangatonu atu ki he fakamaʻu ʻe taha, ʻi ʻolunga ʻi he noʻo fakanikonikoʻi ʻoe ʻefoti. ");
INSERT INTO ton_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Pea te nau nonoʻo ʻae sīfafatafata ʻaki ʻa hono ngaahi kavei ki he kavei ʻe ua ʻoe ʻefoti, ʻaki ʻae noʻo lanumoana, koeʻuhi ke ʻi ʻolunga ia ʻi he noʻo fakanikonikoʻi ʻoe ʻefoti, pea koeʻuhi ke ʻoua naʻa vete ʻae sīfafatafata mei he ʻefoti. ");
INSERT INTO ton_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Pea ʻe fua ʻe ʻElone ʻae ngaahi hingoa ʻoe fānau ʻa ʻIsileli ʻi he sīfafatafata ʻoe fakamaʻu ʻi hono loto, ʻoka ʻalu ia ki he potu māʻoniʻoni, ko e fakamanatu maʻuaipē ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Pea te ke ʻai ʻi he sīfafatafata ʻoe fakamaau, ʻae ʻUlimi mo e Tumemi: pea te na ʻi he loto ʻo ʻElone, ʻi heʻene hū ki he ʻao ʻo Sihova: pea ʻe fua maʻuaipē ʻe ʻElone ʻi hono loto ʻi he ʻao ʻo Sihova ʻae fakamaauʻi ʻoe fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","¶ “Pea te ke ngaohi ke ʻosi ʻae kofu ʻoe ʻefoti ʻaki ʻae lanumoana. ");
INSERT INTO ton_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Pea ʻe ʻai hono ava ʻi ʻolunga ki loto pea ʻe ʻai ʻae tākai ki he ava ʻoe meʻa kuo fi, ʻo hangē ko e ava ʻoe kofutuʻa, telia naʻa mahae ia. ");
INSERT INTO ton_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Pea ʻi hono kapa ki lalo ke ke ngaohi hono teunga ke hangē ko e fuaʻi ʻakau, ʻoe lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, ke tuʻu takatakai ʻi hono kapa; mo e ngaahi fafangu koula ʻi honau vahaʻa ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Ko e fafangu koula mo e fuaʻi ʻakau, ko e fafangu koula mo e fuaʻi ʻakau, ʻi he kapa ʻoe kofu ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Pea ʻe ʻai ia kia ʻElone ke fai ʻae tauhi: pea ʻe ongona hono kini ʻoka hū atu ia ki he potu māʻoniʻoni ʻi he ʻao ʻo Sihova, pea ʻi heʻene haʻu kituʻa, koeʻuhi ke ʻoua naʻa mate ia. ");
INSERT INTO ton_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","¶ “Pea te ke ngaohi ʻae pale ʻoe koula haohaoa, pea tohi tongi ki ai, ʻo hangē ko e tongi ʻoe mama, KO E MĀʻONIʻONI KIA SIHOVA. ");
INSERT INTO ton_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Pea ʻe ʻai ia ki he noʻo lanumoana, koeʻuhi ke ʻi he tatā ia; ʻe ʻai ia ki he muʻa tatā. ");
INSERT INTO ton_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Pea ʻe ʻi he laʻē ia ʻo ʻElone, koeʻuhi ke fua ʻe ʻElone ʻae hia ʻoe ngaahi meʻa māʻoniʻoni, ʻaia ʻoku fakatapui ʻe he fānau ʻa ʻIsileli ʻi heʻenau ngaahi meʻaʻofa kotoa pē; pea ʻe tuʻumaʻu pe ia ki hono laʻē, koeʻuhi ke lelei ai ʻakinautolu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","¶ “Pea te ke ʻai ʻae tuitui ki he kofu ʻoe tupenu tuʻovalevale, mo ke ngaohi ʻae tatā ʻaki ʻae tupenu tuʻovalevale, pea ke ngaohi hono noʻo ʻaki ʻae ngāue ʻoe tuitui. ");
INSERT INTO ton_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","¶ “Pea te ke ngaohi ʻae ngaahi kofu maʻae ngaahi foha ʻo ʻElone, pea ke ngaohi ʻae ngaahi noʻo moʻonautolu, mo ke ngaohi ʻae ngaahi tatā moʻonautolu, ke fakaʻeiʻeiki pea ke matamatalelei. ");
INSERT INTO ton_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Pea ke ʻai ia kia ʻElone ko ho taʻokete, pea ki hono ngaahi foha mo ia; pea te ke tākai ʻakinautolu, ʻo fakanofo ʻakinautolu, pea fakatapui ʻakinautolu, koeʻuhi ke nau ngāue kiate au ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Pea te ke ngaohi ʻae ngaahi kofu vaʻe moʻonautolu ke ʻufiʻufi ʻenau telefua: te nau hifo mei he noʻotangavala ki he ʻateʻivaʻe: ");
INSERT INTO ton_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Pea ʻe ʻai ia kia ʻElone, pea ki hono ngaahi foha, ʻoka nau ka haʻu ki he fale fehikitaki ʻoe kakai, pe ʻi heʻenau haʻu ʻo ofi ki he feilaulauʻanga, ke tauhi ʻi he potu māʻoniʻoni; telia naʻa nau fai hala, pea mate ai; ko e fekau tuʻumaʻu ʻeni kiate ia, pea ki hono hako ʻamui ʻiate ia. ");
INSERT INTO ton_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Pea ko e meʻa ʻeni te ke fai kiate kinautolu ke fakatapui ʻakinautolu, ke tauhi kiate au ʻi he ngāue fakataulaʻeiki: ʻOmi ha pulu mui ʻe taha, mo e sipitangata ʻe ua taʻehaʻana-mele. ");
INSERT INTO ton_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Mo e mā taʻefakalēvani, mo e ngaahi foʻi mā iiki taʻefakalēvani, kuo natuʻaki ʻae lolo, mo e ngaahi mā manifinifi kuo tākai ʻaki ʻae lolo: ngaohi ia ʻaki ʻae kanoʻi uite. ");
INSERT INTO ton_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Pea te ke ʻai ia ki he kato pe taha, pea ʻomi ia ʻi he kato, fakataha mo e pulu mo e sipitangata ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Pea te ke ʻomi ʻa ʻElone mo hono ngaahi foha ki he matapā ʻoe fale fehikitaki ʻoe kakai, pea ke kaukauʻi ʻakinautolu ʻaki ʻae vai. ");
INSERT INTO ton_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Pea te ke ʻomi ʻae ngaahi kofu, pea ʻai kia ʻElone ʻae kofutuʻa, mo e kofu ʻoe ʻefoti, mo e ʻefoti, mo e sīfafatafata, ʻo nonoʻo ʻaki ia ʻae noʻo fakanikonikoʻi ʻoe ʻefoti: ");
INSERT INTO ton_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Pea te ke ʻai ʻae tatā ki hono ʻulu, pea ʻai ʻae pale tapu ki he tatā. ");
INSERT INTO ton_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Pea te ke toki toʻo ʻae lolo tākai, ʻo lingi ia ki hono ʻulu, ʻo tākai ʻaki ia. ");
INSERT INTO ton_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Pea te ke ʻomi hono ngaahi foha ʻo ʻai ʻae ngaahi kofu kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Pea te ke nonoʻo ʻa ʻElone mo hono ngaahi foha ʻaki ʻae ngaahi noʻo, pea ʻai mo e ngaahi tatā kiate kinautolu: pea ko e ngāue ʻae taulaʻeiki ʻe ʻanautolu ia ʻi he fekau tuʻumaʻu pe: pea te ke fakatapui ʻa ʻElone mo hono ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Pea te ke fekau ke ʻomi ʻae pulu tangata ki he mata fale fehikitaki ʻoe kakai: pea ko ʻElone mo hono ngaahi foha te nau hili honau nima ki he ʻulu ʻoe pulu tangata. ");
INSERT INTO ton_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Pea te ke tāmateʻi ʻae pulu tangata ʻi he ʻao ʻo Sihova, ʻi he veʻe matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Pea te ke toʻo ʻae toto ʻoe pulu tangata ʻo ai ia ki he ngaahi nifo ʻoe feilaulauʻanga ʻaki ho tuhu, pea lilingi hono toto kotoa pē ʻoku toe ki lalo ʻi he veʻe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Pea te ke toʻo ʻae ngako kotoa pē ʻoku ne ʻufiʻufi ʻae toʻotoʻonga ʻi loto, ʻae ʻahu mo e ʻate, mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻo tutu ia ʻi he funga ʻoe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ka ko hono kakano ʻoe pulu mo hono kili, mo hono teʻepulu, te ke tutu ia ʻaki ʻae afi ʻi he tuaʻā ʻoe ʻapitanga: ko e feilaulau ia maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","¶ “Pea te ke toʻo foki ʻae sipitangata ʻe taha; pea ko ʻElone mo hono ngaahi foha te nau hili honau nima ki he ʻulu ʻoe sipitangata. ");
INSERT INTO ton_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Pea te ke tāmateʻi ʻae sipitangata, pea ke toʻo hono toto, ʻo luluku takatakai ia ʻi he feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Pea te ke tafa ʻae sipitangata ke iiki, pea fufulu ʻae toʻotoʻonga ʻi loto ʻo ia, mo hono kauvaʻe, ʻo ʻai ia ki hono ngaahi konga, pea ki hono ʻulu. ");
INSERT INTO ton_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Pea te ke tutu ʻae sipitangata kotoa pē ʻi he funga feilaulauʻanga: ko e feilaulau tutu ia kia Sihova: ko e meʻa namu kakala ia, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","¶ “Pea te ke ʻave ʻae sipitangata ʻe taha pea ʻe hilifaki ʻe ʻElone mo hono ngaahi foha honau nima ki he ʻulu ʻoe sipitangata. ");
INSERT INTO ton_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Pea te ke tāmateʻi ʻae sipitangata, pea ʻomi hono toto, pea ʻai ia ʻi he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo ʻElone, pea ki he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo hono ngaahi foha, pea ki he motuʻa nima ʻo honau nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo honau vaʻe toʻomataʻu, pea luluku ʻae toto ki he feilaulauʻanga ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Pea te ke toʻo ʻae toto ʻaia ʻoku ʻi he feilaulauʻanga, pea mo e lolo tākai, ʻo luluku ʻaki ʻa ʻElone, mo hono ngaahi kofu, mo hono ngaahi foha, pea mo e ngaahi kofu ʻo hono ngaahi foha mo ia: pea ʻe fakatapui ia, mo hono ngaahi kofu, mo hono ngaahi foha, mo e ngaahi kofu ʻo hono ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Pea te ke toʻo foki mei he sipitangata ʻae ngako, mo e tuʻungaiku, mo e ngako ʻoku ne ʻufiʻufi ʻae toʻotoʻonga ʻi loto, mo e ʻahu ʻi ʻolunga ʻi he ʻate, mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, mo e alanga muʻa toʻomataʻu he ko e sipitangata ia ʻoe fakatapui: ");
INSERT INTO ton_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Pea mo e foʻi mā ʻe taha, mo e mā siʻi kuo tākai ʻaki ʻae lolo, mo e foʻi mā manifinifi ʻe taha mei he kato ʻoe mā taʻefakalēvani, ʻaia ʻoku ʻi he ʻao ʻo Sihova: ");
INSERT INTO ton_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Pea te ke ʻai ia kotoa pē ki he nima ʻo ʻElone, pea mo e nima ʻo hono ngaahi foha: pea ke lieliaki ia, ko e feilaulau lieliaki ia ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Pea te ke maʻu ia mei honau nima, ʻo tutu ia ʻi he funga ʻoe feilaulauʻanga, ko e feilaulau tutu, ko e meʻa namu kakala ʻi he ʻao ʻo Sihova: ko e feilaulau ia kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Pea te ke toʻo hono fatafata ʻoe sipitangata ʻoe fakatapui ʻo ʻElone, ʻo lieliaki ia ko e feilaulau lieliaki ia ʻi he ʻao ʻo Sihova: pea ko ho inasi ia. ");
INSERT INTO ton_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Pea te ke fakatapui ʻae fatafata ʻoe feilaulau lieliaki, mo e alanga muʻa ʻoe feilaulau hiki hake, ʻaia ʻoku lieliaki, pea ʻoku hiki hake: ʻae sipitangata ʻoe fakatapui, ʻio, ʻo ia ʻoku ʻa ʻElone, mo ia ʻoku ʻa hono ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Pea ʻe ʻia ʻElone ia mo hono ngaahi foha ʻi he fekau tuʻumaʻu mei he fānau ʻa ʻIsileli: he ko e feilaulau hiki hake ia; pea ʻe hoko ia ko e feilaulau hiki hake mei he fānau ʻa ʻIsileli mei he feilaulau ʻoe fakamelino, ʻio, ko ʻenau feilaulau hiki hake kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","¶ Pea ko e ngaahi kofu tapu ʻo ʻElone ʻe hoko ki hono ngaahi foha ki mui ʻiate ia, ʻaia ʻe tākai ai, pea ʻe fakatapui ai ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Pea ko e foha ko ia kuo hoko ke taulaʻeiki, ko hono fetongi ʻo ia, te ne ʻai ia ʻi he ʻaho ʻe fitu, ʻi heʻene haʻu ki he fale fehikitaki ʻoe kakai ke ngāue ʻi he potu māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","¶ “Pea te ke ʻave ʻae sipitangata ʻo fakatapui, pea haka hono kakano ʻi he potu māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Pea ʻe kai ʻe ʻElone mo hono ngaahi foha ʻae kakano ʻoe sipitangata, mo e mā ʻoku ʻi he kato, ʻi he veʻe matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Pea te nau kai ʻae ngaahi meʻa ko ia, ʻaia naʻe fai ʻaki ʻae fakalelei, ke fakanofo mo fakatapui ʻakinautolu: ka ʻe ʻikai kai ia ʻe ha tokotaha kehe, he ʻoku tapu ia. ");
INSERT INTO ton_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Pea kapau ʻoku toe ha kakano ʻoe fakatapui pe ko e mā, ʻo aʻu ki he ʻapongipongi, pea ʻe tutu hono toe ʻaki ʻae afi: ʻe ʻikai kai ia, koeʻuhi ʻoku tapu. ");
INSERT INTO ton_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Pea te ke fai pehē pe kia ʻElone mo hono ngaahi foha, ʻo fakatatau ki he meʻa kotoa pē kuo u fekau kiate koe: ko e ʻaho ʻe fitu te ke fakatapui ai ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Pea te ke ʻatu ʻae pulu tangata ʻi he ʻaho kotoa pē ko e feilaulau ʻoe angahala ke fakalelei ʻaki: pea te ke fakamaʻa ʻae feilaulauʻanga, hili haʻo fai ʻae fakalelei koeʻuhi ko ia, pea ke tākai ia ko hono fakatapui. ");
INSERT INTO ton_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ko e ʻaho ʻe fitu te ke fai ʻae fakalelei ki he feilaulauʻanga, ʻo fakatapui ia; pea ʻe hoko ia ko e feilaulauʻanga māʻoniʻoni lahi: ko ia kotoa pē ʻe lave ki he feilaulauʻanga ʻe tapu ia. ");
INSERT INTO ton_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","¶ “Pea ko e meʻa ʻeni ʻaia te ke ʻatu ʻi he funga ʻoe feilaulauʻanga: ko e lami ʻe ua ʻoe ʻuluaki taʻu maʻuaipē ʻi he ʻaho kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Te ke ʻatu ʻae lami ʻe taha ʻi he pongipongi; mo e lami ʻe taha ʻi he efiafi: ");
INSERT INTO ton_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Pea kakano ʻaki ʻae lami ʻe taha ʻae oma ʻe taha ʻoe mahoaʻa kuo lingi ki ai hono fā ʻoe vahe ʻoe hini lolo tuki; mo hono fā ʻoe vahe ʻoe hini uaine ko e feilaulau inu. ");
INSERT INTO ton_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Pea ko hono ua ʻoe lami te ke ʻatu ʻi he efiafi, mo ke fai ki ai ʻo hangē ko e feilaulau kai ʻoe pongipongi, pea fakatatau ki he feilaulau inu ʻo ia, ko e meʻa namu kakala, ko e feilaulau kia Sihova kuo ngaohi ʻaki ʻae afi. ");
INSERT INTO ton_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ko eni ʻae feilaulau tutu ke fai homou ngaahi toʻutangata ʻi he ʻao ʻo Sihova ʻi he matapā ʻoe fale fehikitaki ʻoe kakai; ʻaia teu fetaulaki ai mo kimoutolu, ke lea ai kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Pea te u fakafetaulaki ai mo e fānau ʻa ʻIsileli, pea ʻe fakatapui ʻaki ʻae fale fehikitaki ʻa hoku nāunau. ");
INSERT INTO ton_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Pea te u fakatapui ʻae fale fehikitaki ʻoe fakataha, mo e feilaulauʻanga: Teu fakatapui foki ʻa ʻElone mo hono ngaahi foha, ke nau ngāue kiate au ʻi he ngāue ʻae taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","¶ “Pea te u nofo ʻi he lotolotonga ʻoe fānau ʻa ʻIsileli, pea ko honau ʻOtua au. ");
INSERT INTO ton_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Pea te nau ʻilo ko au ko Sihova ko honau ʻOtua, ne u ʻomi ʻakinautolu mei he fonua ko ʻIsipite, koeʻuhi ke u nofo ʻiate kinautolu: Ko au ko Sihova ko honau ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Pea te ke ngaohi ʻae feilaulauʻanga ke tutu ai ʻae meʻa namu kakala: ke ke ngaohi ʻaki ia ʻae ʻakau ko e sitimi. ");
INSERT INTO ton_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ko e hanga ʻe ua ʻa hono lōloa, mo e hanga ʻe ua ʻa hono māukupu; ʻe tatau pe hono potu ʻe fā: pea ko e hanga ʻe fā ʻa hono māʻolunga: pea ko hono ngaahi nifo ʻe ʻi he meʻa pe ko ia. ");
INSERT INTO ton_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Pea te ke ʻaofi ʻaki ia ʻae koula haohaoa, ʻa hono funga mo hono ngaahi kaokao ʻo takatakai ia, mo hono ngaahi nifo; pea te ke ngaohi ki ai ʻae tatā koula ke takatakai. ");
INSERT INTO ton_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pea te ke ngaohi ki ai ʻae kavei koula ʻe ua, ʻi lalo ʻi he tatā, ʻo ofi ki hono tuliki ʻe ua, ke ke ngaohi ia ki hono faʻahi ʻe ua: pea ko e ʻaiʻanga ia ʻoe ongo ʻakau ke haʻamo ʻaki. ");
INSERT INTO ton_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Pea te ke ngaohi ʻae ongo haʻamo ʻaki ʻae ʻakau ko e sitimi, pea ʻaofi ia ʻaki ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Pea te ke tuku ia ʻi he tuʻa puipui ʻoku ofi ki he puha ʻoe fuakava, ʻi he ʻao ʻoe nofoʻanga ʻaloʻofa, ʻaia ʻoku ʻi ʻolunga ʻi he fuakava, ʻaia te u fakafetaulaki ai mo koe. ");
INSERT INTO ton_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Pea ʻe tutu ʻi ai ʻe ʻElone ʻae meʻa namu kakala ʻi he pongipongi kotoa pē: ʻi heʻene teuʻi ʻae ngaahi maama, te ne tutu ai ʻae meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Pea ka tutu ʻe ʻElone ʻae ngaahi maama ʻi he efiafi, pea ʻe tutu ʻe ia ʻae meʻa namu kakala ki ai, ko e meʻa namu kakala maʻuaipē ia ʻi he ʻao ʻo Sihova ʻi homou ngaahi toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","‌ʻOua te mou ʻatu ʻi ai ha meʻa namu kakala kehe, pe ha feilaulau tutu, pe ha feilaulau meʻakai: pea ʻoua naʻa mou lilingi ki ai ha feilaulau inu. ");
INSERT INTO ton_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Pea ʻe fai ʻe ʻElone ʻo tuʻo taha ʻi he taʻu ʻae fakalelei ʻi he ngaahi nifo ʻo ia ʻaki ʻae toto ʻoe feilaulau fakalelei maʻae angahala: tuʻo taha ʻi he taʻu te ne fai ʻae fakalelei ʻi ai ʻi homou ngaahi toʻutangata ko e meʻa tapu lahi ia kia Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ʻOka ke ka lau ʻae fānau ʻa ʻIsileli, ʻo fakatatau ki honau tokolahi, te nau toki ʻatu kia Sihova ʻe he tangata taki taha ha meʻa ke huhuʻi ʻaki hono laumālie, ʻoka ke ka lau ʻakinautolu: koeʻuhi ke ʻoua naʻa hoko ha malaʻia kiate kinautolu, ʻoka ke ka lau ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ko eni ia te nau ʻatu: ko ia kotoa pē ʻoku kau mo kinautolu kuo lau, ʻe ʻatu hono vaeuaʻanga ʻoe sikeli ʻo fakatatau ki he sikeli ʻoe fale fehikitaki: (pea ko e kela ʻe uofulu ʻae sikeli,) ko hono vaeuaʻanga ʻoe sikeli ko e feilaulau ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ko ia kotoa pē ʻoku kau mo kinautolu kuo lau, mei he taʻu ʻe uofulu ʻo ʻene motuʻa ʻo fai hake, te nau ʻomi ha feilaulau kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","‌ʻE ʻikai ʻatu ha meʻa lahi hake ʻe he koloaʻia, pea ʻoua naʻa ʻatu ke siʻi hifo ʻe he masiva ʻi he vaeuaʻanga ʻoe sikeli, ʻoka nau ka ʻatu ʻae meʻaʻofa kia Sihova, ke fai ʻaki ʻae fakalelei koeʻuhi ko honau laumālie. ");
INSERT INTO ton_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Pea te ke toʻo ʻae ngaahi paʻanga fakalelei ʻae fānau ʻa ʻIsileli, ʻo vahe ia ki he ngāue ʻoe fale fakatahaʻanga ʻoe kakai: koeʻuhi ke hoko ia ko e meʻa fakamanatu ki he fānau ʻa ʻIsileli ʻi he ʻao ʻo Sihova, ke fai ʻaki ʻae fakalelei ki homou laumālie.” ");
INSERT INTO ton_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","¶ “Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē: ");
INSERT INTO ton_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Ke ke ngaohi foki ʻae sene palasa pea palasa mo hono tuʻunga foki, ke fanofano ai: pea ke tuku ia ʻi he vahaʻa ʻoe fale fakatahaʻanga ʻoe kakai mo e feilaulauʻanga, pea ke lingi ki ai ʻae vai. ");
INSERT INTO ton_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","He ko ʻElone mo hono ngaahi foha te nau fanofano honau nima mo kaukau honau vaʻe ʻi ai: ");
INSERT INTO ton_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","‌ʻI heʻenau hū ki he fale fakatahaʻanga ʻoe kakai, te nau fanofano ʻaki ʻae vai, telia naʻa nau mate; pe ʻi heʻenau haʻu ʻo ofi ki he feilaulauʻanga ke ngāue, ke tutu ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ");
INSERT INTO ton_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ko ia te nau fanofano honau nima mo kaukauʻi honau vaʻe, koeʻuhi ke ʻoua naʻa nau mate: pea ko e fekau maʻuaipē ia kiate kinautolu, ʻio, kiate ia mo ʻene fānau ʻi honau ngaahi toʻutangata.” ");
INSERT INTO ton_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","¶ Pea naʻe folofola foki ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ke ke toʻo foki kiate koe ʻae ʻakau fungani nanamu, ko e mula moʻonia, ko e sikeli e nimangeau, mo e sinamoni namu kakala, hono vaeuaʻanga ʻe taha, ʻio, ko e sikeli e uangeau mo e nimangofulu, mo e kalamusi namu kakalako e sikeli e uangeau ma nimangofulu, ");
INSERT INTO ton_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Pea mo e kāsiako e sikeli e nimangeau, ʻo fakatatau ki he sikeli ʻoe fale tapu, mo e lolo ʻolive ko e hini ʻe taha: ");
INSERT INTO ton_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Pea te ke ngaohi ʻaki ia ʻae lolo tākai ʻoku tapu, ko e lolo tākai kuo hakaluku ʻo fakatatau mo e poto ʻoe tufunga fai lolo lelei: ko e lolo tākai tapu ia. ");
INSERT INTO ton_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Pea ke tākai ʻaki ia ʻae fale fakatahaʻanga ʻoe kakai, mo e puha ʻoe fuakava, ");
INSERT INTO ton_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Mo e palepale mo hono ngaahi nāunau kotoa pē, mo e tuʻunga maama mo hono ngaahi nāunau, mo e feilaulauʻanga ʻoe meʻa namu kakala, ");
INSERT INTO ton_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Mo e feilaulauʻanga ʻoe feilaulau tutu mo hono nāunau kotoa pē, mo e sene mo hono tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Pe te ke fakatapui ʻakinautolu ke nau māʻoniʻoni lahi: ko ia fulipē ʻe lave ki ai ʻe māʻoniʻoni ia. ");
INSERT INTO ton_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Pea te ke tākai ʻa ʻElone mo hono ngaahi foha, ʻo fakanofo ʻakinautolu, koeʻuhi ke nau ngāue kiate au ʻi he ngāue ʻae taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Pea ke lea ki he fānau ʻa ʻIsileli, ʻo pehē, koe lolo tākai tapu eni kiate au ʻi homou toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","‌ʻOua naʻa lingi ia ki he sino ʻoe tangata, pea ʻoua naʻa fai ha lolo ke hangē ko ia hono ngaohi; ʻoku tapu ia, pea ʻe māʻoniʻoni ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ko ia ʻe fai ha lolo hangē ko ia, mo ia ʻoku ne ʻai ia ki ha taha kehe, ʻe motuhi ia mei hono kakai.” ");
INSERT INTO ton_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “Toʻo kiate koe ʻae ngaahi ʻakau nanamu, ʻae sitakiti, mo e ʻonika, mo e kalipeno; ko e ngaahi ʻakau nanamu ni mo e laipeno moʻonia: ke mamafa tatau pe kotoa pē: ");
INSERT INTO ton_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Pea ke ngaohi ia ko e meʻa tākai nanamu, ʻo fefiofi ʻo fakatatau ki he poto ʻoe tufunga fai lolo, ʻo natu fakataha ke lelei mo tapu. ");
INSERT INTO ton_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Pea te ke tuki hono meʻa siʻi ke fakaikiiki, ʻo ʻai ia ʻi he ʻao ʻoe fuakava ʻi he fale fakatahaʻanga ʻoe kakai, ʻaia te u fakafetaulaki ai kiate koe: ʻe ʻiate kimoutolu ia ko e meʻa tapu lahi. ");
INSERT INTO ton_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Pea koeʻuhi ko e meʻa namu kakala te ke ngaohi, ʻoua naʻa mou ngaohi maʻamoutolu ʻo fakatatau mo hono ngaohi ʻo ia: ʻe ʻiate koe ia ko emeʻa tapu kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ko ia ʻe fai ke hangē ko ia ke nanamu ki ai, ʻe motuhi ia mei hono kakai.” ");
INSERT INTO ton_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Vakai, kuo u ui ʻa Pesalili ko e foha ʻo Uli, ko e foha ʻo Hua, ʻi he faʻahinga ʻo Siuta: ");
INSERT INTO ton_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Pea kuo u fakafonu ia ʻi he laumālie ʻoe ʻOtua, ʻi he poto, pea ʻi he loto-matala, mo e faʻa ʻilo, pea ʻi he ngaahi ngāue fakatufunga kotoa pē, ");
INSERT INTO ton_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ke fifili ki he ngaahi ngāue fakapotopoto, ke ngāue ʻi he koula, mo e siliva, mo e palasa. ");
INSERT INTO ton_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Pea ʻi he tātā ʻoe ngaahi maka koloa, ke fakamaʻu ia, pea ʻi he tātā ʻae ʻakau, mo e ngāue ʻi he ngaahi ngāue fakatufunga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Pea ko au, vakai, kuo u foaki mo ia ʻa ʻAholiapi ko e foha ʻo ʻEhisamaki, ʻi he faʻahinga ʻo Tani: pea kuo u ʻai ʻae poto ki he loto ʻokinautolu kotoa pē ʻoku loto poto, koeʻuhi ke nau faʻa ngaohi ʻaia kotoa pē kuo u fekau kiate koe: ");
INSERT INTO ton_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ko e fale fakatahaʻanga ʻoe kakai, mo e puha ʻoe fuakava, mo e nofoʻanga ʻaloʻofa ʻoku hilifaki ki hono funga, mo hono ngaahi nāunau kotoa pē ʻoe fale fehikitaki, ");
INSERT INTO ton_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Mo e palepale mo hono nāunau, mo e tuʻunga maama māʻoniʻoni mo hono nāunau kotoa pē, mo e feilaulauʻanga ʻoe meʻa namu kakala, ");
INSERT INTO ton_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Mo e feilaulauʻanga ʻoe feilaulau tutu mo hono nāunau kotoa pē, mo e sene mo hono tuʻunga, ");
INSERT INTO ton_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Mo e ngaahi kofu ʻoe ngāue, mo e ngaahi kofu tapu kia ʻElone ko e taulaʻeiki, mo e ngaahi kofu ki hono ngaahi foha, ke nau ngāue ai ʻi he ngāue fakataulaʻeiki, ");
INSERT INTO ton_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Mo e lolo tākai, mo e meʻa namu kakala ki he potu māʻoniʻoni: te nau fai ʻo fakatatau ki he meʻa kotoa pē kuo u fekau kiate koe.” ");
INSERT INTO ton_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ke ke lea foki ki he fānau ʻa ʻIsileli, ʻo pehē, “Ko e moʻoni te mou tauhi hoku ngaahi Sāpate: he ko e fakaʻilonga ia ʻiate au mo kimoutolu ʻi homou ngaahi toʻutangata kotoa pē, koeʻuhi ke mou ʻilo ko au ko Sihova ʻoku ou fakatapui ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Ko ia te mou tauhi ai ʻae Sāpate he ʻoku tapu ia kiate kimoutolu: ko ia kotoa pē ʻoku ʻuliʻi ia ko e moʻoni ʻe tāmateʻi ia: he ko ia kotoa pē ʻe fai ʻi ai ha ngāue, ʻe motuhi ʻae tangata ko ia mei hono kakai, ");
INSERT INTO ton_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","‌ʻOku ngofua ke fai ʻae ngāue ʻi he ʻaho ʻe ono; ka ʻi hono fitu, ko e Sāpate ʻoe mālōlō, ko e māʻoniʻoni kia Sihova: ko ia kotoa pē ʻoku fai ha ngāue ʻi he ʻaho Sāpate, ko e moʻoni ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ko ia, ʻe tauhi ʻae Sāpate ʻe he fānau ʻa ʻIsileli, ke tokanga ki he Sāpate ʻi homou ngaahi toʻutangata kotoa pē, ko e fuakava maʻuaipē ia. ");
INSERT INTO ton_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ko e fakaʻilonga ia ʻiate au mo e fānau ʻa ʻIsileli ʻo taʻengata: he naʻe ngaohi ʻe Sihova ʻi he ʻaho ʻe ono ʻae langi mo e fonua, pea naʻa ne tutuku ʻi hono fitu ʻoe ʻaho, pea fiemālie ai.” ");
INSERT INTO ton_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","¶ Pea hili ʻene folofola kia Mōsese ʻi he moʻunga ko Sainai, naʻa ne ʻatu kiate ia ʻae maka ʻe ua ʻoe fuakava, ko e ongo maka, kuo tohi ʻaki ʻae louhiʻi nima ʻoe ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Pea ʻi he mamata ʻae kakai kuo tuai ʻae ʻalu hifo ʻa Mōsese mei he moʻunga, naʻe fakataha ʻae kakai kia ʻElone, ʻonau pehē kiate ia, “Tuʻu hake ʻo ngaohi hotau ngaahi ʻotua, ʻaia ʻe muʻomuʻa ʻiate kitautolu; he koeʻuhi ko Mōsese ni ko e tangata naʻe ʻomi ʻakitautolu mei he fonua ko ʻIsipite, ʻoku ʻikai te tau ʻilo pe kuo ʻi fē ia.” ");
INSERT INTO ton_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Pea naʻe fekau ʻe ʻElone kiate kinautolu, “Motuhi mai ʻae ngaahi hau koula, ʻaia ʻoku ʻi he telinga ʻo homou ngaahi mali, mo homou ngaahi foha, mo homou ngaahi ʻofefine, pea ʻomi ia kiate au.” ");
INSERT INTO ton_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Pea naʻe fesiʻi leva ʻe he kakai kotoa pē ʻae ngaahi hau koula naʻe ʻi honau telinga, ʻo ʻomi ia kia ʻElone. ");
INSERT INTO ton_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Pea maʻu ʻe ia ʻi honau nima, pea hili ʻene haka ia ke ngaohi ʻae fakatātā ʻoe pulu mui, naʻa ne fakafuofua ia ʻaki ʻae meʻa tā; pea naʻa nau pehē, “Ko ʻeni ho ngaahi ʻotua ʻe ʻIsileli, ʻaia kuo ʻomi koe mei he fonua ko ʻIsipite.” ");
INSERT INTO ton_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Pea kuo mamata ki ai ʻa ʻElone, pea fokotuʻu ʻe ia ʻae feilaulauʻanga ʻi hono ʻao: pea naʻe fakahā ʻe ʻElone, ʻo pehē, “ʻE fai ʻae kātoanga kia Sihova ʻapongipongi.” ");
INSERT INTO ton_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Pea naʻa nau tuʻu hengihengi hake ʻi he pongipongi, ʻo ʻatu ʻae ngaahi feilaulau tutu, ʻo ʻomi ʻae ngaahi feilaulau fakamelino; pea naʻe nofo hifo ʻae kakai ke kai mo inu, pea tutuʻu hake ke fakavā. ");
INSERT INTO ton_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu koe, pea ke ʻalu ki lalo: he ko ho kakai, ʻaia kuo ke ʻomi mei he fonua ko ʻIsipite, kuo nau fakahalaʻi ʻakinautolu: ");
INSERT INTO ton_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kuo nau afe leva mei he hala ʻaia kuo u fekauʻi ai ʻakinautolu: kuo nau ngaohi moʻonautolu ʻae fakatātā haka ki he pulu mui, pea kuo nau hū ki ai, mo nau feilaulau ki ai, ʻo pehē, Ko eni ho ngaahi ʻotua ʻe ʻIsileli, ʻaia kuo ʻomi koe mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Pea naʻe folofola ʻa Sihova kia Mōsese, Kuo u mamata ki he kakai ni, pea vakai, ko e kakai kia kekeva ia: ");
INSERT INTO ton_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Pea ko ʻeni, tuku ai pe au, koeʻuhi ke tupu pe ʻo vela ʻeku tuputāmaki kiate kinautolu, pea koeʻuhi ke u fakaʻauha ʻakinautolu: pea te u fakatupu ʻiate koe ʻae puleʻanga lahi.” ");
INSERT INTO ton_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pea naʻe kole fakamātoato ʻe Mōsese kia Sihova ko hono ʻOtua, ʻo pehē, “ʻE Sihova, ko e hā ʻoku tupu ʻo vela ai ho houhau ki ho kakai, ʻaia kuo ke aʻutaki mai mei he fonua ko ʻIsipite ʻi he mālohi lahi, pea ʻi he nima māfimafi? ");
INSERT INTO ton_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ko e hā ka lea ai ʻae kakai ʻIsipite, ʻo pehē, naʻa ne ʻomi kovi ʻakinautolu kituaʻā, ke tāmateʻi ʻakinautolu ʻi he ngaahi moʻunga, pea ke fakaʻauha ʻakinautolu mei he funga ʻo māmani? Tafoki mei ho houhau lahi, pea lolou ʻi he kovi ni ki ho kakai. ");
INSERT INTO ton_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Manatu ki hoʻo kau tamaioʻeiki ko ʻEpalahame, mo ʻAisake, mo ʻIsileli, ʻakinautolu naʻa ke fuakava ki ai ʻi he ʻafiona, mo ke pehē kiate kinautolu, Te u fakatupu ke tokolahi homou hako ke tatau mo e ngaahi fetuʻu ʻoe langi, pea ko e fonua ni kotoa pē, ʻaia kuo u lea ki ai te u foaki ia ki homou hako, pea te nau maʻu ia ʻo taʻengata.” ");
INSERT INTO ton_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Pea naʻe lolou ʻa Sihova ʻi he kovi ʻaia naʻa ne finangalo ke fai ki hono kakai. ");
INSERT INTO ton_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","¶ Pea naʻe tafoki ʻa Mōsese, ʻo ʻalu hifo mei he moʻunga, mo e maka ʻe ua ʻoe fuakava naʻe ʻi hono nima: kuo tohi ʻae ongo maka ʻi hona potu fakatouʻosi: kuo tohi ia ʻi hono potu ʻe taha mo hono potu ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Pea naʻe ngaohi ʻe he ʻOtua ʻae ongo maka, pea ko e tohi ko e tohi ʻae ʻOtua, kuo tongi ki he ongo maka. ");
INSERT INTO ton_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Pea ʻi he fanongo ʻa Siosiua ki he longoaʻa ʻoe kakai ʻi heʻenau kalanga, naʻe pehē ʻe ia kia Mōsese, “ʻOku longolongo tau ʻae ʻapitanga.” ");
INSERT INTO ton_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pea pehē ʻe ia, “ʻOku ʻikai ko e leʻo ia ʻokinautolu ʻoku mavava ʻi he mālohi, pea ʻoku ʻikai ko e leʻo ʻonautolu ʻoku tangi ʻi he fakavaivaiʻi: ka ʻoku ou ongoʻi ʻae leʻo ʻonautolu ʻoku hiva.” ");
INSERT INTO ton_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","¶ Pea naʻe pehē, ʻi heʻene hoko ʻo ofi ki he ʻapitanga, naʻa ne mamata leva ki he fakatātā ʻoe pulu mui mo e meʻe hopohopo: pea tupu ʻo vela ʻae ʻita ʻa Mōsese, pea ne si ʻae ongo maka mei hono nima pea naʻe laiki ia ʻi he lalo moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Pea naʻa ne toʻo ʻae pulu mui ʻaia naʻa nau ngaohi, ʻo tutu ia ʻi he afi, ʻo ne momosi ia ke efu, ʻo ne lī ia ki he vai, ʻo ne fakainu ʻaki ia ʻae fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Pea naʻe pehē ʻe Mōsese kia ʻElone, “Ko e hā naʻe fai ʻe he kakai ni kiate koe, kuo ke ʻomi ai ʻae angahala lahi pehē ni kiate kinautolu?” ");
INSERT INTO ton_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Pea pehēange ʻe ʻElone, “Ke ʻoua naʻa tupu ʻo vela lahi ʻae ʻita ʻa hoku ʻeiki: ʻoku ke ʻiloʻi ʻae kakai, ʻoku pau pe honau loto ki he kovi. ");
INSERT INTO ton_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","He naʻa nau pehē mai kiate au, Ngaohi hotau ngaahi ʻotua, ʻaia ʻe muʻomuʻa ʻiate kitautolu: he koeʻuhi ko e Mōsese ni, ko e tangata naʻa ne ʻomi ʻakitautolu mei he fonua ko ʻIsipite, ʻoku ʻikai te tau ʻilo pe kuo ʻi fē ia. ");
INSERT INTO ton_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Pea ne u tala kiate kinautolu, Ko ia fulipē ʻoku ai haʻanau koula, ke nau motuhi ia. Pea naʻa nau tuku mai ia kiate au: pea naʻaku si ia ki he afi, pea naʻe haʻu mei ai ʻae pulu mui ni.” ");
INSERT INTO ton_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","¶ Pea ʻi he mamata ʻa Mōsese, ʻoku telefua ʻae kakai; (he naʻe fakatelefuaʻi ʻakinautolu ʻe ʻElone ke nau mā ai ʻi he lotolotonga ʻo honau ngaahi fili:) ");
INSERT INTO ton_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Naʻe tuʻu ai ʻa Mōsese ʻi he matapā ʻoe ʻapitanga, ʻo ne pehē, “Ko hai ʻoku kau mo Sihova? Ke haʻu ia kiate au. Pea ko e ngaahi foha kotoa pē ʻo Livai, naʻa nau fakataha kiate ia.” ");
INSERT INTO ton_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Pea pehē ʻe ia kiate kinautolu, “ʻOku pehē mai ʻe Sihova ko e ʻOtua ʻo ʻIsileli, ‘Ke ʻai ʻe he tangata taki taha ʻene heletā ki hono vakavaka, pea ʻalu ʻo feʻaluʻaki ʻi he matapā ki he matapā ʻi he ʻapitanga kotoa pē, ʻo tāmateʻi ʻe he tangata hono tokoua, mo e tangata kotoa pē ʻene kaumeʻa, mo e tangata kotoa pē hono kaungāʻapi.’” ");
INSERT INTO ton_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Pea naʻe fai ʻe he fānau ʻa Livai ʻo fakatatau ki he fekau ʻa Mōsese: pea naʻe tō ai ʻi he kakai ʻi he ʻaho ko ia ʻae kau tangata ko e toko tolu afe nai. ");
INSERT INTO ton_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","He naʻe pehē ʻe Mōsese, “Fakatapui ʻakimoutolu kia Sihova he ʻaho ni, ʻae tangata taki taha ki hono foha, pea ki hono tokoua: koeʻuhi ke ne foaki ʻae tāpuaki kiate kimoutolu he ʻaho ni.” ");
INSERT INTO ton_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","¶ Pea pongipongi ai, naʻe pehē ʻe Mōsese ki he kakai, “Kuo mou fai ʻae angahala lahi: pea ko eni, te u ʻalu hake kia Sihova; heiʻilo pe teu lavaʻi ke fai ʻae fakalelei ʻi hoʻomou angahala.” ");
INSERT INTO ton_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Pea naʻe toe ʻalu ʻa Mōsese kia Sihova, ʻo ne pehē, “ʻOiauē, kuo fai ʻae angahala lahi ʻe he kakai ni, pea kuo ngaohi honau ngaahi ʻotua koula. ");
INSERT INTO ton_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ka ko eni, kapau ʻe lelei te ke fakamolemole ʻenau angahala; pea kapau ʻe ʻikai, ʻoku ou kole kiate koe, tāmateʻi au mei hoʻo tohi ʻaia kuo ke tohi.” ");
INSERT INTO ton_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pea pehē ʻe Sihova kia Mōsese, “Ko ia fulipē kuo fai angahala kiate au, te u tāmateʻi ia mei heʻeku tohi. ");
INSERT INTO ton_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ko ia, ke ke ʻalu ni, ʻo ʻave ʻae kakai ki he fonua, ʻaia naʻaku lea ai kiate koe: vakai, ʻe muʻomuʻa ʻiate koe a ʻeku ʻĀngelo ka ko e moʻoni ʻi he ʻaho ʻo ʻeku ʻaʻahi, Te u ʻaʻahi ʻenau angahala kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Pea naʻe fakamamahi ʻe Sihova ʻae kakai, ko e meʻa ʻi heʻenau ngaohi ʻae pulu mui, ʻaia naʻe ngaohi ʻe ʻElone. ");
INSERT INTO ton_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “ʻAlu, pea hiki ʻi heni, ʻa koe mo e kakai ʻaia kuo ke ʻomi mei he fonua ko ʻIsipite, ki he fonua ʻaia naʻaku fuakava ai kia ʻEpalahame, mo ʻAisake, pea kia Sēkope, ʻo pehē, Te u foaki ia ki ho hako: ");
INSERT INTO ton_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Pea te u fekau ha ʻāngelo ke muʻomuʻa ʻiate koe: pea te u kapusi ʻae kakai Kēnani, mo e kau ʻAmoli, mo e kau Heti, mo e kau Pelesi, ko e kau Hevi, pea mo e kau Sepusi: ");
INSERT INTO ton_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mou ʻalu ki he fonua mahu tāfea ʻi he huʻahuhu mo e honi: ka ʻe ʻikai te u ʻalu hake ʻi homou lotolotonga; he ko e kakai kia kekeva koe: telia naʻaku fakaʻauha koe ʻi he hala.” ");
INSERT INTO ton_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","¶ Pea ʻi he fanongo ʻae kakai ki he ongoongo kovi ni, naʻa nau tangi: pea naʻe ʻikai ʻai ʻe ha tangata haʻa ne teunga. ");
INSERT INTO ton_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","He naʻe pehē ʻe Sihova kia Mōsese, “Tala ki he fānau ʻa ʻIsileli, koe kakai kia kekeva ʻakimoutolu: Te u ʻalu atu ki loto ʻiate koe ʻi he kemo pe taha, ʻo fakaʻauha koe; ko ia ke ke tukuange ai ʻae ngaahi teunga ʻiate koe, kaeʻoua ke u ʻilo ai ha meʻa ke fai kiate koe.” ");
INSERT INTO ton_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Pea naʻe vete ʻe he fānau ʻa ʻIsileli ʻenau ngaahi teunga ʻiate kinautolu ʻi he moʻunga ko Holepi. ");
INSERT INTO ton_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Pea naʻe hiki ʻe Mōsese ʻae fale fehikitaki, ʻo fokotuʻu ia ʻi tuaʻā mei he ʻapitanga, ʻo mamaʻo atu mei he ʻapitanga, ʻo ne ui ia ko e Fale fehikitaki ʻoe kakai. Pea naʻe pehē, ko ia kotoa pē naʻe kumi kia Sihova naʻe ʻalu ia kituaʻā ki he fale fehikitaki ʻoe kakai, ʻaia naʻe ʻi tuaʻā mei he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Pea naʻe pehē, ʻi he ʻalu kituaʻā ʻa Mōsese ki he fale fehikitaki, naʻe tuʻu hake leva ʻae kakai kotoa pē, ʻo tuʻu ʻae tangata taki taha ʻi he matapā ʻo hono fale fehikitaki, ke sio atu kia Mōsese, ke ʻoua ke hū ia ki he fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Pea ʻi he hū ʻa Mōsese ki he fale fehikitaki, naʻe ʻalu hifo ʻae pou ʻao, pea tuʻu ia ʻi he matapā ʻoe fale fehikitaki, pea aleaʻa Sihova mo Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Pea naʻe mamata ʻe he kakai kotoa pē ki he pou ʻao ʻoku tuʻu ʻi he matapā ʻoe fale fehikitaki: pea naʻe tuʻu hake ʻae kakai kotoa pē ʻo hū, ʻo taki taha ʻae tangata ʻi he matapā ʻo hono fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Pea naʻe folofola ʻa Sihova kia Mōsese, ko e mata ki he mata, ʻo hangē ko e lea ʻae tangata ki hono kāinga. Pea naʻe liu mai ia ki he ʻapitanga; he ko hono tauhi, ʻa Siosiua ko e foha ʻo Nuni, ko e tangata talavou, naʻe ʻikai ʻalu ia mei he fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","¶ Pea naʻe pehē ʻe Mōsese kia Sihova, “Vakai, ʻoku ke pehē mai kiate au, Ke ke ʻohake ʻae kakai ni: pea ʻoku ʻikai te ke fakahā kiate au, pe ko hai ia te ke fekau ke ma ō mo au. Ka kuo ke tala mai, ʻOku ou ʻilo koe ʻi ho hingoa, pea kuo ʻofeina koe ʻi hoku ʻao. ");
INSERT INTO ton_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Pea ko ʻeni, ʻoku ou kole kiate koe, kapau kuo u maʻu ʻae ʻofa ʻi ho ʻao, ke ke fakahā ni kiate au ho hala, koeʻuhi ke u ʻilo koe, pea te u ʻilo ai ʻae ʻofa ʻi ho ʻao: pea ke ʻafioʻi ko e puleʻanga ni ko ho kakai.” ");
INSERT INTO ton_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Pea pehē ʻe ia, “Te u ʻalu mo koe, pea te u tuku kiate koe ʻae fiemālie.” ");
INSERT INTO ton_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Pea pehē ʻe ia kiate ia, “Kapau ʻe ʻikai ʻalu ʻa hoʻo ʻafio mo au, ʻoua naʻa ke fetuku hake ʻakimautolu ʻi heni. ");
INSERT INTO ton_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","He koeʻuhi ʻe ʻilo ni ʻi he ha kuo ʻofeina au mo hoʻo kakai ʻi ho ʻao? ʻIkai ʻi he meʻa ni, ʻi hoʻo ʻalu mo kimautolu? Ko ia te mau mavahe ai, ʻa au mo hoʻo kakai, mei he kakai kotoa pē ʻoku ʻi he funga ʻo māmani.” ");
INSERT INTO ton_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Pea naʻe folofola ʻa Sihova kia Mōsese, “Te u fai ʻae meʻa ni foki ʻaia kuo ke lea ki ai: he kuo ke maʻu ʻae ʻofa ʻi hoku ʻao, pea ʻoku ou ʻilo koe ʻi ho hingoa.’ ");
INSERT INTO ton_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Pea pehē ʻe ia, “ʻOku ou kole kiate koe, fakahā kiate au ho nāunau.’ ");
INSERT INTO ton_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Pea naʻa ne pehē, “Te u fai ke hā atu ʻeku angalelei kotoa pē ʻi ho ʻao, pea te u fakahā ʻae huafa ʻo Sihova ʻi ho ʻao; pea te u ʻofa mataʻatā pe kiate ia ʻoku ou loto ke ʻofa mataʻatā pe ki ai, pea te u ʻaloʻofa kiate ia ʻoku ou loto ke ʻaloʻofa ki ai. ");
INSERT INTO ton_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pea pehē ʻe ia, ʻOku ʻikai te ke mafai ke mamata ki hoku fofonga: he ʻoku ʻikai ha tangata te ne mamata kiate au, pea moʻui. ");
INSERT INTO ton_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Pea pehē ʻe Sihova, Vakai, ʻoku ai ʻae potu ʻoku ofi kiate au, pea te ke tuʻu koe ki he funga maka: ");
INSERT INTO ton_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Pea ʻe hoko ʻo pehē, ʻi he ʻalu atu ʻa hoku nāunau, te u ai koe ki he mafahi ʻoe maka, pea teu ʻufiʻufi koe ʻaki hoku nima lolotonga ʻeku ʻalu atu: ");
INSERT INTO ton_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Pea te u toʻo hoku nima, pea te ke mamata ki hoku tuʻa; ka ko hoku fofonga ʻe ʻikai hā ia.” ");
INSERT INTO ton_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, “Ke ke tā maʻau ʻae maka lafalafa ʻe ua ʻo hangē ko e ʻuluaki maka: pea te u tohi ki he ongo maka ni, ʻae ngaahi lea naʻe ʻi he ʻuluaki maka, ʻaia naʻa ke maumauʻi. ");
INSERT INTO ton_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pea ke teu ki he ʻapongipongi, pea ke ʻalu hake ʻapongipongi ki he moʻunga ko Sainai, pea ke fakahā koe kiate au ʻi he tumutumu ʻoe moʻunga. ");
INSERT INTO ton_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Pea ʻe ʻikai ʻalu hake mo koe ha tangata ʻe tokotaha, pea ʻoua naʻa hā mai ha tangata ʻi he moʻunga kotoa pē, pea ʻoua naʻa kai ʻae fanga sipi, pe ko e fanga manu lalahi ʻi he ʻao ʻoe moʻunga ko ia.” ");
INSERT INTO ton_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","¶ Pea naʻa ne tā ʻae ongo maka lafalafa ʻo hangē ko e ʻuluaki; pea naʻe tuʻu hengihengi hake ʻa Mōsese, ʻo ne ʻalu hake ki he moʻunga ko Sainai, ʻo hangē ko e fekau ʻa Sihova kiate ia, ʻo ne ʻave ʻi hono nima ʻae ongo maka lafalafa. ");
INSERT INTO ton_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Pea naʻe hāʻele hifo ʻa Sihova ʻi he ʻao, pea tutuʻu ʻi ai mo ia, ʻo ne fakahā ʻae huafa ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Pea naʻe hāʻele ange ʻa Sihova ʻi hono ʻao, ʻo ne folofola, “Ko Sihova, Ko Sihova ko e ʻOtua, ʻoku ʻaloʻofa, mo ʻofa mataʻatā, ʻoku kātaki fuoloa, pea mohu ʻi he angalelei mo e moʻoni. ");
INSERT INTO ton_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","‌ʻOku ne fakahā ʻae ʻaloʻofa ki he ngaahi toko afe, ʻi he fakamolemole ʻae hia, mo e talangataʻa, mo e angahala, pea ʻe ʻikai ʻaupito fakatonuhiaʻi ʻae halaia; ʻoku ʻaʻahi ʻaki ki he fānau ʻae hia ʻae mātuʻa, pea ki he hako ʻo ʻenau fānau, ʻo aʻu ki hono tolu mo hono fā ʻoe toʻutangata.” ");
INSERT INTO ton_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Pea naʻe fakatoʻotoʻo ʻe Mōsese, ke punou hifo hono ʻulu ki he kelekele, pea hū. ");
INSERT INTO ton_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Pea naʻa ne pehē, “ʻE Sihova, kapau kuo u maʻu ni ʻae ʻofa ʻi ho ʻao, ʻoku ou kole kiate koe, ke ʻalu ʻa hoku ʻEiki, mo kimautolu: he ko e kakai kia kekeva; pea fakamolemole ʻe mau hia mo e mau angahala, mo ke fili ʻakimautolu ko e tofiʻa ʻoʻou.” ");
INSERT INTO ton_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","¶ Pea naʻe pehē ʻe ia, “Vakai, ʻoku ou fai ʻae fuakava: te u fai ʻae ngaahi meʻa mana ʻi he ʻao ʻo ho kakai kotoa pē, ʻae meʻa naʻe ʻikai ʻaupito hano tatau, ʻi ha potu ʻe taha ʻo māmani, pe ʻi ha puleʻanga: pea ko e kakai kotoa pē ʻaia ʻoku ke nofo ki ai te nau mamata ki he ngāue ʻa Sihova: he ko e meʻa fakamanavahē ia ʻaia te u fai kiate koe. ");
INSERT INTO ton_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ke ke tokanga koe ki he meʻa ʻoku ou fekau kiate koe he ʻaho ni: vakai, ʻoku ou kapusi mei ho ʻao ʻae kau ʻAmoli, mo e kau Kēnani, mo e kau Heti, mo e kau Pelesi, mo e kau Hevi, mo e kau Sepusi. ");
INSERT INTO ton_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ke ke vakai kiate koe, telia naʻa mou fai ha fuakava mo e kakai ʻoe fonua ʻaia ʻoku ke ʻalu ki ai, telia naʻa hoko ia ko e tauhele ʻi loto ʻiate koe. ");
INSERT INTO ton_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ka te mou maumauʻi honau ngaahi feilaulauʻanga, pea laiki ʻenau ngaahi meʻa fakatātā, pea tā ke hinga ʻenau ngaahi ʻakau tapu: ");
INSERT INTO ton_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","‌ʻE ʻikai te ke lotu koe ki ha ʻotua kehe: he ko Sihova, ʻaia ko hono huafa ko Fuaʻa, ko e ʻOtua fuaʻa ia. ");
INSERT INTO ton_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Telia naʻa mou fai ʻae fuakava mo e kakai ʻoe fonua, pea nau ʻalu ʻo tango ki honau ngaahi ʻotua, pea fai ʻae feilaulau ki honau ngaahi ʻotua, pea ui koe ʻe ha tokotaha, pea ke kai ʻi heʻene feilaulau; ");
INSERT INTO ton_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","pe ke fili ʻe koe ʻa honau ngaahi ʻofefine ki ho ngaahi foha; pea ʻalu ʻa honau ngaahi ʻofefine ʻo tango ki honau ngaahi ʻotua, ʻonau fakakau ho ngaahi foha ke nau ʻalu ʻo tango ki honau ngaahi ʻotua. ");
INSERT INTO ton_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","‌ʻOua naʻa ke ngaohi moʻou ha ʻotua ukamea kuo haka. ");
INSERT INTO ton_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","¶ “Pea te ke tauhi ʻae kātoanga ʻoe mā taʻefakalēvani. Ke ke kai ʻae mā taʻefakalēvani ʻi he ʻaho ʻe fitu, ʻo hangē ko ʻeku fekau kiate koe, ʻi he ngaahi ʻaho ʻoe māhina ko ʻApipi: he naʻa ke haʻu mei ʻIsipite ʻi he māhina ko ʻApipi. ");
INSERT INTO ton_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Ko ia kotoa pē ʻoku fakaava ʻae manāva ʻoku ʻaʻaku ia; mo e ʻuluaki manu tangata ʻi hoʻo fanga manu, pe ko ha pulu ia, pe ko ha sipi. ");
INSERT INTO ton_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ka ko e ʻuluaki ʻuhiki ʻoe ʻasi ke ke huhuʻi ʻaki ia ʻae lami; pea kapau ʻe ʻikai te ke huhuʻi ia, pea ke fesiʻi hono kia. Ko e ʻuluaki fānau kotoa pē ʻi ho ngaahi foha te ke huhuʻi. Pea ʻoua naʻa fakahā mola pe ha tokotaha ʻi hoku ʻao. ");
INSERT INTO ton_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","¶ “Te ke ngāue ʻi he ʻaho ʻe ono, ka ʻi hono fitu ʻoe ʻaho te ke mālōlō: ʻi he ngaahi ʻaho ʻoe tō taʻu, mo e ututaʻu ke ke mālōlō. ");
INSERT INTO ton_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","¶ “Pea te ke tokanga ki he kātoanga ʻoe ngaahi uike, mo e ʻuluaki fua ʻoe tuʻusi ʻoe uite, mo e kātoanga ʻoe ututaʻu ʻi he fakaʻosi taʻu. ");
INSERT INTO ton_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","¶ “ʻE liunga tolu ʻi he taʻu ʻae fakahā ʻa hoʻomou fānau tangata kotoa pē ʻi he ʻao ʻoe ʻEiki ko Sihova, ko e ʻOtua ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","He te u kapusi ʻae ngaahi puleʻanga mei ho ʻao, pea te u fakalahi atu ʻae ngataʻanga ʻo ho fonua: pea ʻe ʻikai ha tangata te ne holi ki ho fonua, ʻoka ke ka ʻalu hake, ʻo liunga tolu ʻi he taʻu ke fakahā koe ʻi he ʻao ʻo Sihova ko ho ʻOtua. ");
INSERT INTO ton_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ʻOua naʻa ke ʻatu ʻae toto ʻo ʻeku feilaulau mo e lēvani: pea ʻoua naʻa ke tuku ki he ʻapongipongi ʻae feilaulau ʻoe kātoanga ʻoe Lakaatu. ");
INSERT INTO ton_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ko e polopolo ʻoe ngaahi ʻuluaki fua ʻo ho fonua ke ke ʻomi ki he fale ʻo Sihova ko ho ʻOtua. “ʻOua naʻa ke haka ʻae ʻuhiki sipi pe kosi ʻi he huʻahuhu ʻo ʻene faʻē.” ");
INSERT INTO ton_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Pea pehē ʻe Sihova kia Mōsese, “Ke ke tohi ʻae ngaahi lea ni: he kuo u fai ʻae fuakava kiate koe mo ʻIsileli, ʻo fakatatau ki hono ʻuhinga ʻoe ngaahi lea ni. ");
INSERT INTO ton_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Pea naʻe ʻi ai ia mo Sihova ʻi he ʻaho ʻe fāngofulu mo e pō ʻe fāngofulu; pea naʻe ʻikai te ne kai mā, pe inu ha vai. Pea naʻa ne tohi ki he ongo maka lafalafa ʻae ngaahi lea ʻoe fuakava, ko e fekau ʻe hongofulu. ");
INSERT INTO ton_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","¶ Pea naʻe pehē, ʻi he ʻalu hifo ʻa Mōsese mei he moʻunga ko Sainai, mo e maka lafalafa ʻe ua ʻoe fuakava ʻi he nima ʻo Mōsese, ʻi heʻene ʻalu hifo mei he moʻunga, naʻe ʻikai ʻilo ʻe Mōsese ʻoku ulo ʻae kili ʻo hono mata lolotonga ʻene talanoa mo ia. ");
INSERT INTO ton_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Pea ʻi he mamata ʻa ʻElone, pea mo e fānau kotoa pē ʻa ʻIsileli kia Mōsese, vakai, naʻe ulo ʻae kili ʻo hono mata: pea naʻa nau manavahē ke haʻu ʻo ofi kiate ia. ");
INSERT INTO ton_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Pea naʻe ui ʻe Mōsese kiate kinautolu; pea ko ʻElone mo e kau pule kotoa pē ʻoe kakai naʻa nau foki mai kiate ia: pea naʻe talanoa ʻa Mōsese mo kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Pea hili ia, naʻe ʻunuʻunu mai ʻo ofi ʻae fānau kotoa pē ʻa ʻIsileli: pea naʻa ne tala ʻo fekau kiate kinautolu ʻaia kotoa pē naʻe folofolaʻaki ʻe Sihova kiate ia ʻi he moʻunga ko Sainai. ");
INSERT INTO ton_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Pea naʻe ʻai ʻe Mōsese ʻae pūlou ki hono mata, kaeʻoua ke hili ʻene talanoa mo kinautolu. ");
INSERT INTO ton_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ka ʻi he ʻalu ʻa Mōsese ki he ʻao ʻo Sihova ke lea kiate ia, naʻa ne toʻo ʻae pūlou, kaeʻoua ke hū kituʻa. Pea naʻe haʻu kituʻa ia, ʻo ne tala ki he fānau ʻa ʻIsileli, ʻaia naʻe fekau kiate ia ke fai. ");
INSERT INTO ton_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Pea naʻe mamata ʻe he fānau ʻa ʻIsileli ki he mata ʻo Mōsese, ʻoku ulo ʻae kili ʻoe mata ʻo Mōsese: pea naʻe toe ʻai ʻe Mōsese ʻae pūlou ki hono mata kaeʻoua ke toe hū ia ke alea mo ia. ");
INSERT INTO ton_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Pea naʻe tānaki ʻe Mōsese ʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli ke nau fakataha, ʻo ne pehē kiate kinautolu, “Ko ʻeni ʻae ngaahi lea ʻaia kuo fekau ʻe Sihova, koeʻuhi ke mou fai ia. ");
INSERT INTO ton_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‌ʻE fai ʻae ngāue ʻi he ʻaho ʻe ono, ka ʻi hono fitu ʻoe ʻaho ʻe ʻai kiate kimoutolu ʻae ʻaho tapu, ko e Sāpate ʻoe mālōlō kia Sihova: ko ia fulipē ʻoku fai ha ngāue ʻi ai ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","‌ʻOua naʻa mou tutu ha afi ʻi he ʻaho Sāpate ʻi ha nofoʻanga ʻe taha ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","¶ Pea naʻe lea ʻa Mōsese ki he fakataha kotoa pē ʻoe fānau ʻa ʻIsileli, ʻo pehē, Ko eni ʻae meʻa ʻaia naʻe fekau ai ʻe Sihova, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mou toʻo meiate kimoutolu ʻae meʻaʻofa kia Sihova: ko ia ʻoku loto lelei ki ai, tuku ke ʻomi ia, ko e meʻaʻofa kia Sihova; ko e koula, mo e siliva, mo e palasa, ");
INSERT INTO ton_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, mo e fulufuluʻi kosi, ");
INSERT INTO ton_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Mo e ngaahi kiliʻi sipitangata kuo tukukula, mo e ngaahi kiliʻi pasia, mo e ʻakau ko e sitimi, ");
INSERT INTO ton_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Mo e lolo ki he maama, mo e ngaahi ʻakau nanamu ki he lolo tākai, pea ki he meʻa namu kakala, ");
INSERT INTO ton_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Mo e ngaahi maka ʻoniki, mo e ngaahi maka ke fonofono ʻaki ʻae ʻefoti, pea ki he sīfafatafata. ");
INSERT INTO ton_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Pea ke haʻu ʻae loto poto kotoa pē ʻoku ʻiate kimoutolu ʻo ngaohi ʻaia kotoa pē kuo fekau ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ko e fale fehikitaki, mo hono puipui, mo hono fakapulonga, mo hono ngaahi fakamaʻu, mo hono ngaahi laupapa, mo hono ngaahi ʻakau, mo hono ngaahi pou, mo hono ngaahi tuʻunga, ");
INSERT INTO ton_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Ko e puha mo hono ʻakau haʻamo, mo e nofoʻanga ʻaloʻofa, mo e puipui ʻoe fakapulonga, ");
INSERT INTO ton_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ko e palepale, mo hono haʻamo, mo hono ngaahi nāunau, mo e mā ʻoe ʻao, ");
INSERT INTO ton_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Ko e tuʻunga maama foki ki he maama, mo hono nāunau, mo hono ngaahi foʻi maama, mo e lolo ki he maama, ");
INSERT INTO ton_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Mo e feilaulauʻanga ʻoe meʻa namu kakala, mo hono haʻamo, mo e lolo tākai, mo e meʻa namu kakala, mo e puipui ke tautau ʻi he matapā ʻi he hūʻanga ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Ko e feilaulauʻanga ʻoe feilaulau tutu, mo hono meʻa vangavanga palasa mo hono haʻamo, mo hono ngaahi nāunau kotoa pē, ko e sene mo hono tuʻunga, ");
INSERT INTO ton_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Ko e ngaahi puipui tautau ʻoe lotoʻā, ko hono ngaahi pou, mo honau ngaahi tuʻunga, mo e ngaahi puipui tautau ki he matapā ʻoe lotoʻā, ");
INSERT INTO ton_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Ko e ngaahi faʻo ʻoe fale fehikitaki, mo e ngaahi faʻo ʻoe lotoʻā, mo honau ngaahi afo, ");
INSERT INTO ton_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ko e ngaahi kofu ki he ngāue, ke fai ʻaki ʻae ngāue ʻi he potu tapu, ko e ngaahi kofu tapu kia ʻElone ko e taulaʻeiki, mo e ngaahi kofu ki hono ngaahi foha ke ngāueʻaki ʻi he ngāue fakataulaʻeiki.” ");
INSERT INTO ton_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","¶ Pea naʻe ʻalu ʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli mei he ʻao ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Pea naʻa nau haʻu, ʻaia kotoa pē naʻe langaʻi ia ʻe hono loto, mo ia kotoa pē kuo fakalotolelei ia ʻe hono laumālie, ʻonau ʻomi ʻae meʻaʻofa kia Sihova ki he ngāue ʻoe fale fakatahaʻanga ʻoe kakai, pea ki hono ngāue kotoa pē, pea ki he ngaahi kofu tapu. ");
INSERT INTO ton_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Pea naʻa nau haʻu, ʻae tangata mo e fefine, ʻakinautolu kotoa pē naʻe loto lelei, ʻo ʻomi ʻae ngaahi vesa, mo e ngaahi hau, mo e ngaahi mama, mo e ngaahi noʻo, ko e teunga koula kotoa pē: pea ko e tangata kotoa pē naʻe ʻomi meʻa naʻe ʻatu ʻae koula kia Sihova. ");
INSERT INTO ton_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Pea ko e tangata kotoa pē, ʻaia naʻe ʻi ai ʻae lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, mo e fulufuluʻi kosi, mo e kiliʻi sipitangata kulokula, mo e ngaahi kiliʻi pasia, naʻa nau ʻomi ia. ");
INSERT INTO ton_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ko ia kotoa pē naʻe ʻatu ha meʻaʻofa ʻi he siliva mo e palasa naʻe ʻomi ʻe ia ʻae meʻaʻofa kia Sihova; pea ko e tangata kotoa pē, naʻe ʻiate ia ʻae ʻakau ko e sitimi ki ha ngāue ʻe taha ʻi he ngāue, naʻe ʻomi ia. ");
INSERT INTO ton_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Pea ko e kau fefine kotoa pē naʻe loto poto naʻa nau lalanga ʻaki honau nima, ʻonau ʻomi ʻaia kuo nau lalanga, ko e lanumoana mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Pea mo e kau fefine kotoa pē ʻaia naʻe langaʻi ʻakinautolu ʻe honau loto ʻi he poto, naʻa nau fi ʻae fulufuluʻi kosi. ");
INSERT INTO ton_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Pea naʻe ʻomi ʻe he kau pule ʻae ngaahi maka ʻoniki, mo e ngaahi maka ke fonofono ʻaki, ki he ʻefoti, pea ki he sīfafatafata; ");
INSERT INTO ton_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Mo e ʻakau nanamu, mo e lolo ki he maama, pea ki he lolo tākai, pea ki he meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Naʻe ʻomi loto lelei pe ʻe he fānau ʻa ʻIsileli ʻae meʻaʻofa kia Sihova, ʻae tangata mo e fefine kotoa pē, ʻaia kuo fakafiemālieʻi ia ʻe hono loto ke fetuku ki he ngaahi ngāue kehekehe kotoa pē, ʻaia naʻe fekau ʻe Sihova ke ngaohi ʻe he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","¶ Pea naʻe pehē ʻe Mōsese ki he fānau ʻa ʻIsileli, “Vakai, kuo ui ʻe Sihova ʻi hono hingoa ʻa Pesalili, ko e foha ʻo Uli, ko e foha ʻo Hua, ʻoe faʻahinga ʻo Siuta. ");
INSERT INTO ton_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Pea kuo ne fakafonu ia ʻi he laumālie ʻoe ʻOtua, ʻi he poto mo e lotomatala, mo e faʻa ʻilo, ʻi he ngaahi ngāue fakatufunga, kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Pea ke fakatupu ʻae ngaahi ngāue fakapotopoto, ke ngāue ʻi he koula, mo e siliva, pea ʻi he palasa, ");
INSERT INTO ton_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Pea ʻi he tā ʻae ngaahi maka ke fono ʻaki, pea ʻi he tātā ʻae ʻakau, ke fai ʻaki ʻae ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Pea kuo ne ʻai ki hono loto koeʻuhi ke ne akonakiʻi ʻaia mo ʻAholiapi, ko e foha ʻo ʻEhisamaki, ʻoe faʻahinga ʻo Tani. ");
INSERT INTO ton_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ko kinaua kuo ne fakafonu ʻaki ʻae poto ʻoe loto, ke fai ʻae ngaahi ngāue kotoa pē ʻae tufunga tongitongi meʻa, mo e ngāue ʻae tufunga fakapotopoto, pea mo e ngaahi teunga, ʻi he lanumoana, pea ʻi he paʻuhiʻuhi, mo e kulaʻahoʻaho, pea ʻi he tupenu tuʻovalevale, pea ʻi he lalanga, ʻo hangē ko kinautolu ʻoku fai ha ngāue, mo kinautolu ʻoku fakatupu ha ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Pea naʻe toki ngāue ʻa Pesalili mo ʻAholiapi, mo e tangata loto poto kotoa pē, ʻaia naʻe ʻai ki ai ʻe Sihova ʻae poto mo e ʻiloʻanga, ke nau ʻilo ke ngaohi ʻae ngaahi ngāue kehekehe kotoa pē ki he ngāue ʻoe fale tapu, ʻo fakatatau ki he meʻa kotoa pē naʻe fekau ki ai ʻe Sihova.” ");
INSERT INTO ton_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Pea naʻe ui ʻe Mōsese ʻa Pesalili, mo ʻAholiapi, mo e tangata loto poto kotoa pē, ʻaia kuo tuku ki hono loto ʻe Sihova ʻae poto, ʻio, ʻaia kotoa pē kuo langaʻi ia ʻe hono loto ke haʻu ki he ngāue ke fai ia: ");
INSERT INTO ton_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Pea naʻa nau maʻu ʻia Mōsese ʻae meʻaʻofa kotoa pē, ʻaia naʻe ʻomi ʻe he fānau ʻa ʻIsileli ki he ngāue ʻoe fale tapu, mo hono ngaohi. Pea naʻa nau kei ʻomi kiate ia ʻae meʻaʻofa ʻi he pongipongi kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","¶ Pea naʻe haʻu ʻae kau tangata kotoa pē, naʻe fai ʻae ngaahi ngāue kotoa pē ʻoe fale tapu, ʻo haʻu taki taha ʻae tangata mei he ngāue naʻa ne fai; ");
INSERT INTO ton_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Pea naʻa nau lea kia Mōsese, ʻo pehē, “ʻOku ʻomi ʻe he kakai ʻae meʻa ʻoku lahi hake noa pē ki he ngāue ʻoku fai ni, ʻaia naʻe fekau ʻe Sihova ke ngaohi.” ");
INSERT INTO ton_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Pea naʻe fekau ʻe Mōsese, pea naʻa nau fekau ke fanongonongo ki he potu kotoa pē ʻoe ʻapitanga, ʻo pehē, “Ke ʻoua naʻa kei fai ha teuteu meʻaʻofa ʻe ha tangata pe ha fefine ki he fale tapu.” Ko ia naʻe taʻofi ai ʻae kakai ʻi he fetuku. ");
INSERT INTO ton_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","He ko e meʻa kuo nau maʻu, naʻe lahi ia ki he ngāue kotoa pē ke ngaohi, pea naʻe toe. ");
INSERT INTO ton_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","¶ Pea ko e tangata loto poto kotoa pē ʻiate kinautolu naʻa nau fai ʻae ngāue ʻoe fale fehikitaki, naʻa nau ngaohi ʻae puipui ʻe hongofulu ʻoe tupenu tuʻovalevale, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho: naʻa ne ngaohi ʻaki ia ʻae ngaahi selupimi ʻoe ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Ko hono lōloa ʻoe puipui ʻe taha ko e hanga ʻe nimangofulu ma ono, pea ko hono laulahi ʻoe puipui ʻe taha ko e hanga ʻe valu: pea naʻe fua tatau pe ʻae puipui kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pea ne fakamaʻu ke fakataha ʻae puipui ʻe nima: pea ko hono puipui ʻe nima ʻoku toe naʻa ne fakamaʻu ke fakataha. ");
INSERT INTO ton_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Pea ne ngaohi ʻae ngaahi kavei lanumoana, ʻi he kapa ʻoe puipui ʻe taha mei he hokoʻanga ʻi he fakamaauʻanga: pea naʻe fai pehē ʻi he kapa kituʻa ʻoe puipui ʻe taha, ʻi he hokoʻanga ʻo hono ua. ");
INSERT INTO ton_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Naʻa ne ngaohi ʻae kavei ʻe nimangofulu ʻi he puipui ʻe taha mo e kavei ʻe nimangofulu ʻi he kapa ʻoe puipui, ʻaia naʻe ʻi he hokoʻanga ʻo hono ua: naʻe fakamaʻu ʻaki ʻae kavei ʻae puipui ʻe taha ki he taha. ");
INSERT INTO ton_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Pea naʻa ne ngaohi ʻae fakamaʻu koula ʻe nimangofulu, ʻo ne fakahoko ʻaki ʻae fakamaʻu ʻae puipui ʻe taha ki he taha: pea naʻe hoko ia ko e fale fehikitaki pe taha. ");
INSERT INTO ton_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","¶ Pea naʻa ne ngaohi ʻae ngaahi puipui fulufuluʻi kosi ke ʻaofi ʻaki ʻae fale fehikitaki: naʻa ne ngaohi ʻae puipui ʻe hongofulu ma taha. ");
INSERT INTO ton_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Ko hono lōloa ʻoe puipui ʻe taha ko e hanga ʻe onongofulu, mo hono lau lahi ʻoe puipui pe taha ko e hanga ʻe valu: naʻe fua tatau pe ʻae puipui ʻe hongofulu ma taha. ");
INSERT INTO ton_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Pea naʻa ne fakamaʻu ʻae puipui ʻe nima ke taha pe, mo e puipui ʻe ono ke taha pe. ");
INSERT INTO ton_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Pea ne ngaohi ʻae kavei ʻe nimangofulu ki he kapa ʻi ʻolunga ʻoe puipui ʻi he hokoʻanga, mo ne ngaohi ʻae kavei ʻe nimangofulu ki he kapa ʻoe puipui ʻaia ʻoku ne hoko ki hono ua. ");
INSERT INTO ton_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Pea ne ngaohi ʻae fakamaʻu palasa ʻe nimangofulu ke fakamaʻu fakataha ʻae faletupenu ke taha pe ia. ");
INSERT INTO ton_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Pea ne ngaohi ʻae meʻa fakapulonga ki he fale fehikitaki ʻaki ʻae ngaahi kili ʻoe sipitangata tukukula, mo e meʻa fakapulonga ʻe taha ʻi ʻolunga ʻi ai, ko e kili ʻoe pasia. ");
INSERT INTO ton_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","¶ Pea ne ngaohi ʻae ngaahi laupapa ki he fale fehikitaki ʻaki ʻae ʻakau ko e sitimi ke tuʻu tonu. ");
INSERT INTO ton_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ko hono lōloa ʻoe laupapa ʻe taha ko e hanga ʻe uofulu, mo hono lau lahi ʻoe laupapa ʻe taha ko e hanga ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Naʻe ua hono mui ki he laupapa ʻe taha, pea tatau pe hono mamaʻo ʻoe taha ki he taha: pea naʻa ne fai pehē pe ki he ngaahi laupapa kotoa pē ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Pea naʻa ne ngaohi ʻae ngaahi laupapa ki he fale fehikitaki; ko e laupapa ʻe uofulu ki he faʻahi ki tonga ke hanga ki tonga; ");
INSERT INTO ton_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Pea ne ngaohi ʻae tuʻunga siliva ʻe fāngofulu ʻi lalo ʻi he laupapa ʻe uofulu; ko e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha ki hono mui ʻe ua, mo e tuʻunga ʻe ua ʻi lalo he laupapa ʻe taha ki hono mui ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Pea ko hono faʻahi ʻe taha ʻoe fale fehikitaki, ʻaia ʻoku hanga ki he tuliki fakatokelau, naʻa ne ngaohi ki ai ʻae laupapa ʻe uofulu, ");
INSERT INTO ton_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Mo honau tuʻunga siliva ʻe fāngofulu ko e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha, mo e tuʻunga ʻe ua ʻi lalo ʻi he laupapa ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pea ne ngaohi ʻae laupapa ʻe ono ki he potu lulunga ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Pea ne ngaohi ʻae laupapa ʻe ua ki he tuliki ʻoe fale fehikitaki ʻi hono faʻahi ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Pea naʻe fakamaʻu ia ki lalo, pea fakamaʻu ke fakataha ia ʻi he ʻulu ʻo ia, ki he kavei pe taha: pea fai pehē pe ʻe ia ki ai ʻi he tuliki ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Pea naʻe ʻi ai ʻae laupapa ʻe valu; pea ko honau tuʻunga ko e tuʻunga siliva ʻe hongofulu ma ono, naʻe ua ʻae tuʻunga ʻi lalo ʻoe laupapa kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","¶ Pea naʻa ne ngaohi ʻae ngaahi ʻakau fakamaʻu ʻoe sitimi; ko e nima ki he ngaahi laupapa ʻi he faʻahi ʻe taha ʻoe fale fehikitaki, ");
INSERT INTO ton_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Mo e ʻakau fakamaʻu ʻe nima ki ha ngaahi laupapa ʻoe faʻahi ʻe taha ʻoe fale fehikitaki, pea mo e ʻakau fakamaʻu ʻe nima ki he ngaahi laupapa ʻi he potu lulunga ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Pea naʻa ne ngaohi ʻae ʻakau fakamaʻu ʻi loto ke velo ʻi he laupapa kotoa pē mei he potu ʻe taha ʻo aʻu atu ki he potu ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Pea naʻa ne ʻaofi ʻaki ʻae koula ʻae ngaahi laupapa kotoa pē, ʻo ngaohi honau ngaahi kavei ko e koula, ke velo ai ʻae ʻakau fakamaʻu, pea ne ʻaofi ʻae ngaahi ʻakau fakamaʻu ʻaki ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","¶ Pea naʻa ne ngaohi ʻae puipui ʻaki ʻae lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale: pea naʻe ʻai ki ai ʻae ngaahi selupimi ʻi he ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Pea naʻa ne ngaohi ki ai ʻae pou ʻe fā ʻoe ʻakau ko e sitimi, ʻo ne ʻaofi ia ʻaki ʻae koula: ko e koula hono tautauʻanga; pea naʻa ne haka ki ai ʻae tuʻunga siliva ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","¶ Pea naʻa ne ngaohi ʻae meʻa tautau ki he matapā ʻoe fale fehikitaki ʻaki ʻae lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, ʻoe ngāue tuitui; ");
INSERT INTO ton_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Mo hono pou ʻe nima ʻo ia, mo e ngaahi tautauʻanga: pea naʻa ne ʻaofi honau ʻuluʻi pou, mo honau ngaahi tākai ʻaki ʻae koula: ka ko honau tuʻunga ʻe nima ko e palasa ia. ");
INSERT INTO ton_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Pea naʻe ngaohi ʻe Pesalili ʻae puha ʻaki ʻae ʻakau ko e sitimi: ko e hanga ʻe nima hono lōloa, mo e hanga ʻe tolu hono māukupu, mo e hanga ʻe tolu ʻa hono māʻolunga: ");
INSERT INTO ton_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Pea naʻa ne ʻaofi ʻaki ia ʻae koula haohaoa ʻi loto mo tuʻa, ʻo ne ngaohi ʻae tatā koula ki ai ke takatakai ia. ");
INSERT INTO ton_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Pea naʻa ne haka ʻae kavei koula ʻe fā ki ai, ke ʻai ʻo ofi ki hono tuliki ʻe fā: ʻio, ʻae kavei ʻe ua ʻi hono faʻahi ʻe taha, mo e kavei ʻe ua ki hono faʻahi ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Pea naʻa ne ngaohi ʻae ʻakau ʻe ua ʻaki ʻae ʻakau ko e sitimi, ʻo ne ʻaofi ʻaki ia ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Pea ne ʻai ʻae ongo ʻakau ki he kavei ʻi he ongo faʻahi ʻoe puha, ke haʻamo ʻaki. ");
INSERT INTO ton_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","¶ Pea naʻa ne ngaohi ʻae nofoʻanga ʻaloʻofa ʻaki ʻae koula haohaoa: ko e hanga ʻe nima ʻa hono lōloa, mo e hanga ʻe tolu ʻa hono māukupu ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Pea naʻa ne ngaohi ʻae ongo selupimi koula, ʻo ne tuki ʻakinaua mei he konga koula pe taha, ʻi hono potu ʻe ua ʻoe nofoʻanga ʻaloʻofa. ");
INSERT INTO ton_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ko e selupi ʻe taha ʻi he potu ʻi he faʻahi ni, mo e selupi ʻe taha ʻi hono potu ʻe taha ʻi he faʻahi ʻe taha: naʻa ne ngaohi ʻae ongo selupimi ʻi he nofoʻanga ʻaloʻofa: ʻi hono potu ʻe ua ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Pea naʻe mafola hake ki ʻolunga hona kapakau ʻe he ongo selupimi, ʻo na maluʻi ʻaki hona kapakau ʻae nofoʻanga ʻaloʻofa, pea naʻe fehāngaaki hona mata; ʻio, naʻe hanga ki he nofoʻanga ʻaloʻofa ʻae mata ʻoe ongo selupimi. ");
INSERT INTO ton_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","¶ Pea naʻa ne ngaohi ʻae palepale ʻaki ʻae ʻakau ko e sitimi: ko e hanga ʻe fā ʻa hono lōloa, mo e hanga ʻe ua hono māukupu ʻo ia, mo e hanga ʻe tolu ʻa hono māʻolunga: ");
INSERT INTO ton_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Pea ne ʻaofi ʻaki ia ʻae koula haohaoa, ʻo ne ngaohi ʻae tatā koula ke takatakai ia. ");
INSERT INTO ton_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Pea naʻa ne ngaohi foki ki ai ʻae tapa ke takatakai ia ko e nima ʻe taha hono laulahi: ʻo ne ngaohi ʻae tatā koula ki he tapa ʻo ia ke takatakai. ");
INSERT INTO ton_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Pea ne haka ʻae kavei koula ʻe fā ki ai, ʻo ai ʻae kavei ki hono tuliki ʻe fā ʻaia naʻe ʻi hono vaʻe ʻe fā. ");
INSERT INTO ton_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Naʻe tuku tonu ki he tapa ʻae ngaahi kavei, ko e ʻaiʻanga ʻoe ongo ʻakau ke haʻamo ʻaki ʻae palepale. ");
INSERT INTO ton_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Pea ne ngaohi ʻae ongo ʻakau ʻaki ʻae sitimi, pea naʻe ʻaofi ʻaki ia ʻae koula, ke haʻamo ʻaki ʻae palepale. ");
INSERT INTO ton_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Pea naʻa ne ngaohi ʻae ngaahi ipu ʻi he palepale, ʻae ngaahi ipu kai, mo e ngaahi ohu, mo hono ngaahi ipu luoluo, mo e ngaahi meʻa ʻufiʻufi, ke ʻufiʻufi ʻaki, ʻaki ʻae koula haohaoa. ");
INSERT INTO ton_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","¶ Pea naʻa ne ngaohi ʻae tuʻunga maama ʻaki ʻae koula haohaoa: ʻo ne ngaohi ʻae tuʻunga maama ʻaki ʻae ngāue tuki: ʻa hono kau, mo hono pasanga, mo hono ngaahi ipu siʻi, mo hono ngaahi teunga potopoto, mo hono ngaahi fisi, naʻe ʻi he meʻa pe ko ia. ");
INSERT INTO ton_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Mo e pasanga ʻe ono naʻe tuʻu ʻi hono potu ʻe ua: ko e pasanga ʻe tolu ʻoe tuʻunga maama mei hono potu ʻe taha, mo e pasanga ʻe tolu ʻoe tuʻunga maama mei hono potu ʻe taha: ");
INSERT INTO ton_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ko e ipu siʻi ʻe tolu ʻi he pasanga ʻe taha kuo ngaohi ʻo hangē ko e fuaʻitelie, ko e teunga potopoto mo e fisi; pea ko e ipu siʻi ʻe tolu kuo ngaohi ʻo hangē ko e fuaʻitelie ʻi he pasanga ʻe taha, ko e teunga potopoto mo e fisi; pea ke pehē pe ʻi he pasanga ʻe ono ʻoku tuʻu ʻi he tuʻunga maama. ");
INSERT INTO ton_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Pea naʻe ʻi he tuʻunga maama ʻae ipu siʻi ʻe fā kuo ngaohi ʻo hangē ko e fuaʻitelie, ko hono ngaahi teunga potopoto mo hono ngaahi fisi: ");
INSERT INTO ton_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ko e teunga potopoto ʻe taha ʻi lalo ʻoe pasanga ʻe ua, mo e teunga potopoto ʻe taha ʻi lalo ʻi he pasanga ʻe ua, mo e teunga potopoto ʻe taha ʻi lalo ʻi he pasanga ʻe ua, ʻo fakatatau ki he pasanga ʻe ono ʻoku tuʻu ʻi ai. ");
INSERT INTO ton_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ko honau ngaahi teunga potopoto mo honau ngaahi pasanga naʻe ʻi he meʻa pe ko ia: ko e konga koula tuki pe taha ʻaia kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Pea naʻa ne ngaohi hono foʻi maama ʻe fitu, mo hono ngaahi helekosi-maama, mo hono ʻaiʻanga helekosi, ʻaki ʻae koula haohaoa. ");
INSERT INTO ton_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Ko e taleniti koula pe taha naʻa ne ngaohi ʻaki ia, mo hono ngaahi ipu kotoa pē. ");
INSERT INTO ton_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","¶ Pea naʻa ne ngaohi ʻae feilaulauʻanga meʻa namu kakala ʻaki ʻae ʻakau ko e sitimi: ko hono lōloa ko e hanga ʻe ua, mo hono māukupu ko e hanga ʻe ua; naʻe potupotu tatau pe: pea ko e hanga ʻe fā ʻa hono māʻolunga; pea ko hono ngaahi nifo naʻe ʻi he meʻa pe ko ia. ");
INSERT INTO ton_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Pea naʻa ne ʻaofi ʻaki ia ʻae koula haohaoa, ʻi hono funga ʻo ia, mo hono ngaahi potu ʻo takatakai, mo hono ngaahi nifo: pea naʻa ne ngaohi foki ki ai ʻae tatā koula ke takatakai. ");
INSERT INTO ton_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Pea naʻa ne ngaohi hono kavei koula ʻe ua ʻi lalo ʻi he tatā ʻo ia, ʻo ofi ki hono tuliki ʻe ua, ki hono potu ʻe ua, ke velo ai ʻae ongo ʻakau ke haʻamo ʻaki. ");
INSERT INTO ton_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Pea naʻa ne ngaohi ʻae ongo haʻamo ʻaki ʻae ʻakau ko e sitimi, pea naʻe ʻaofi ia ʻaki ʻae koula. ");
INSERT INTO ton_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","¶ Pea naʻa ne ngaohi ʻae lolo tākai tapu, mo e meʻa namu lelei, ʻaki ʻae ngaahi ʻakau nanamu, ʻo taau mo e ngāue ʻae tangata fua vai. ");
INSERT INTO ton_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Pea naʻa ne ngaohi ʻae feilaulauʻanga ʻoe feilaulau tutu, ʻaki ʻae ʻakau ko e sitimi: ko e hanga ʻe hongofulu ʻa hono lōloa, mo e hanga ʻe hongofulu ʻa hono māukupu; naʻe potupotu tatau ia; pea ko e hanga ʻe ono ʻa hono māʻolunga. ");
INSERT INTO ton_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Pea naʻa ne ngaohi hono ngaahi nifo ʻo ia, ʻi hono tuliki ʻe fā; ko hono ngaahi nifo, naʻe ʻi he meʻa ko ia pea naʻa ne ʻaofi ʻaki ia ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Pea naʻa ne ngaohi ʻae nāunau kotoa pē ʻoe feilaulauʻanga, ʻae ngaahi ipu, mo e ngaahi huo, mo e ngaahi ipu luoluo, mo e ngaahi huhu ʻoe kakano, mo e ngaahi ʻaiʻanga afi; ko hono ngaahi meʻa kotoa pē naʻe ngaohi ʻaki ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Pea naʻa ne ngaohi ki he feilaulauʻanga ʻae meʻa vangavanga palasa ʻi lalo ʻi hono ngataʻanga ki lalo, ʻo aʻu hifo ki hono lotolotonga ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Pea ne haka ʻae kavei ʻe fā ki he tuliki ʻe fā ʻoe meʻa vangavanga palasa ke ʻai ki ai ʻae ongo haʻamo. ");
INSERT INTO ton_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Pea naʻa ne ngaohi ʻae ongo haʻamo ʻaki ʻae ʻakau ko e sitimi, pea ʻaofi ia ʻaki ʻae palasa. ");
INSERT INTO ton_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Pea naʻa ne ʻai ʻae ongo ʻakau ki he kavei ʻi he potu ʻe ua ʻoe feilaulauʻanga, ke haʻamo ʻaki ia: naʻa ne ngaohi ʻae feilaulauʻanga ʻaki ʻae laupapa ke luoluo, ʻi loto. ");
INSERT INTO ton_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","¶ Pea naʻa ne ngaohi ʻae sene ʻaki ʻae palasa, mo hono tuʻunga ʻo ia ʻaki ʻae palasa, ʻoe ngaahi sioʻata ʻae kau fefine naʻe kātoa fakafaʻahinga ʻi he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","¶ Pea naʻa ne ngaohi hono lotoʻā: pea ko e puipui tautau ki he potu tonga ʻo hanga ki tonga ko e tupenu tuʻovalevale, ko e hanga ʻe uangeau: ");
INSERT INTO ton_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Naʻe uofulu honau pou, pea uofulu mo honau tuʻunga palasa: ko e ngaahi tautauʻanga ʻoe ngaahi pou mo honau ngaahi tākai ko e siliva: ");
INSERT INTO ton_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pea ko e puipui tautau ki he potu tokelau, ko e hanga ʻe uangeau, naʻe uofulu honau ngaahi pou, pea uofulu mo honau tuʻunga palasa; ko e ngaahi tautauʻanga ʻoe ngaahi pou mo honau ngaahi tākai ko e siliva. ");
INSERT INTO ton_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pea ko e puipui tautau ki he potu lulunga ko e hanga ʻe teau, pea hongofulu honau pou, pea hongofulu mo honau tuʻunga: ko e ngaahi tautauʻanga ʻoe pou mo honau tākai ko e siliva. ");
INSERT INTO ton_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Pea ko e puipui ʻoe potu ki he hopoʻangalaʻā ko e hanga ʻe teau. ");
INSERT INTO ton_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Ko e meʻa tautau ki he potu ʻe taha ʻoe matapā ko e hanga ʻe tolungofulu; pea tolu honau pou, pea tolu mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Pea ki hono potu ʻe taha ʻoe matapā ʻoe lotoʻā, ʻi he nima ni, mo e nima na, naʻe ʻi ai ʻae meʻa tautau ko e hanga ʻe tolungofulu: pea tolu honau pou, pea tolu mo honau tuʻunga. ");
INSERT INTO ton_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ko e ngaahi puipui tautau kotoa pē ʻo takatakai ʻi he lotoʻā naʻe ngaohi ʻaki ʻae tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Pea ko e ngaahi tuʻunga ki he ngaahi pou ko e palasa ia: ko e ngaahi tautauʻanga, ʻoe ngaahi pou mo honau ngaahi tākai ko e siliva ia: pea naʻe ʻaofi ʻaki ʻae ngaahi ʻuluʻi pou ʻae siliva: pea tākai ʻaki ʻae siliva ʻae ngaahi pou kotoa pē ʻoe lotoʻā. ");
INSERT INTO ton_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Pea ko e puipui tautau ki he matapā ʻoe lotoʻā ko e ngāue ʻae tuitui, ko e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale: pea ko e hanga ʻe fāngofulu hono lōloa, pea ko hono māʻolunga fakamāukupu, ko e hanga ʻe hongofulu, ʻo fakatatau ki he ngaahi puipui tautau ʻoe lotoʻā. ");
INSERT INTO ton_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Pea naʻe fā honau pou, pea fā honau tuʻunga palasa: ko e siliva honau ngaahi tautauʻanga, pea ko e ʻaofi ʻo honau ngaahi ʻuluʻi pou, mo honau ngaahi tākai, ko e siliva. ");
INSERT INTO ton_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Pea ko e ngaahi faʻo kotoa pē ʻoe fale fehikitaki, mo e lotoʻā takatakai, ko e palasa ia. ");
INSERT INTO ton_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","¶ Ko eni hono lau ʻoe meʻa ʻoe fale fehikitaki, ʻio, ʻoe fale fehikitaki ʻoe fuakava, ʻo hangē ko ia naʻe lau, ʻo fakatatau ki he fekau ʻa Mōsese, ki he ngāue ʻae kau Livai, ʻi he nima ʻo ʻItama, ko e foha ʻo ʻElone ko e taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Pea ko Pesalili ko e foha ʻo Uli ko e foha ʻo Hua, ʻi he faʻahinga ʻo Siuta, naʻa ne ngaohi ʻae meʻa kotoa pē naʻe fekau ʻe Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Pea naʻe ʻiate ia ʻa ʻAholiapi, ko e foha ʻo ʻEhisamaki, ʻi he faʻahinga ʻo Tani, ko e tufunga tātā, ko e tangata ngāue fakapotopoto, pea poto ke fai teunga ʻi he lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ko e koula kotoa pē naʻe fakakau ki he ngāue ʻi he ngaahi ngāue kotoa pē ʻoe potu māʻoniʻoni, ʻio, ʻae koula naʻe ʻatu, ko e taleniti ʻe uofulu ma hiva, mo e sikeli ʻe fitungeau, mā tolungofulu, ʻo fakatatau ki he sikeli ʻoe fale tapu. ");
INSERT INTO ton_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Pea ko e siliva ʻokinautolu naʻe lau ʻi he kakai fakataha, ko e taleniti ʻe teau, mo e sikeli ʻe taha afe ma fitungeau, mā fitungofulu ma nima, ʻo fakatatau ki he sikeli ʻoe fale tapu: ");
INSERT INTO ton_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ko e pika ʻe taha ki he tangata kotoa pē, ʻaia ko e vaeuaʻanga ʻoe sikeli, ʻo fakatatau ki he sikeli ʻoe fale tapu, kiate kinautolu taki taha naʻe ʻalu ke lau, naʻe uofulu taʻu ʻene motuʻa, ʻo fai hake, ʻae kau tangata ʻe toko ono kilu mo e toko tolu afe, mo e toko nimangeau, mo e toko nimangofulu. ");
INSERT INTO ton_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Pea naʻe haka ʻaki ʻae taleniti siliva ʻe teau, ʻae ngaahi tuʻunga pou ʻoe fale tapu, pea mo e ngaahi tuʻunga ʻoe meʻa puipui; ko e tuʻunga ʻe teau ʻi he taleniti ʻe teau, ko e taleniti ʻe taha ki he tuʻunga ʻe taha. ");
INSERT INTO ton_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Pea ko e sikeli ʻe taha afe ma fitungeau ma fitungofulu ma nima, naʻa ne ngaohi ʻaki ʻae ngaahi tautauʻanga ki he ngaahi pou, ʻo ne ʻaofi ʻae ngaahi ʻuluʻi pou, ʻo tākai ʻaki ia. ");
INSERT INTO ton_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Pea ko e palasa ʻoe ngaahi meʻaʻofa ko e taleniti ʻe fitungofulu, mo e sikeli ʻe ua afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Pea naʻa ne ngaohi ʻaki ia ʻae ngaahi tuʻunga ki he matapā ʻoe fale fehikitaki ʻoe kakai, mo e feilaulauʻanga palasa mo e meʻa vangavanga palasa ki ai, mo hono ngaahi nāunau kotoa pē ʻoe feilaulauʻanga, ");
INSERT INTO ton_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Pea mo e ngaahi tuʻunga ʻoe lotoʻā takatakai, mo e ngaahi tuʻunga ʻoe matapā ʻoe lotoʻā, mo e ngaahi faʻo kotoa pē ʻoe fale fehikitaki, mo e ngaahi faʻo kotoa pē ʻoe lotoʻā ʻo ʻosi takatakai. ");
INSERT INTO ton_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Pea naʻa nau ngaohi ʻaki ʻae lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, ʻae ngaahi kofu ngāue, ke fai ʻaki ʻae ngāue ʻi he potu māʻoniʻoni, pea naʻe ngaohi ʻae ngaahi kofu tapu kia ʻElone; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Pea naʻa ne ngaohi ʻae ʻefoti ʻaki ʻae koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Pea naʻa nau tuki ʻae koula ke manifinifi, pea hele ia ke tuʻoiiki, koeʻuhi ke nau lalanga ia ʻi he lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale, mo e ngāue fakapotopoto. ");
INSERT INTO ton_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Naʻa nau ngaohi ʻae tuinga nima ʻe ua ki he uma, ke fakamaʻu fakataha ia; pea naʻe fakataha ia ʻi hono kapa ʻe ua. ");
INSERT INTO ton_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Pea naʻe ʻi he meʻa pe ko ia hono noʻo fakanikonikoʻi ʻoe ʻefoti naʻe ʻi ai, ʻo fakatatau ki he ngāue ʻo ia: ko e koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale: ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","¶ Pea naʻa nau tā ʻae ngaahi maka ʻoniki, pea fakamaʻu ʻi he takafi koula; kuo tongi ʻo hangē ko e tongi ʻoe mama, ʻaki ʻae ngaahi hingoa ʻoe fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Pea naʻa ne ʻai ia ki he uma ʻe ua ʻoe ʻefoti, koeʻuhi ke hoko ia ko e ngaahi maka fakamanatu ki he fānau ʻa ʻIsileli: ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","¶ Pea naʻa ne ngaohi ʻae sīfafatafata ʻoe ngāue fakapotopoto, ʻo hangē ko e ngāue ʻoe ʻefoti; ʻi he koula, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Naʻe potupotu tatau pe ia naʻa nau ngaohi ʻae sīfafatafata ke lōua: ko e hanga pe taha hono lōloa ʻo ia, mo e hanga pe taha hono māukupu, ʻoka peluua ia. ");
INSERT INTO ton_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Pea naʻa nau fakamaʻu ʻi ai ʻae ʻotu maka ʻe fā: ko hono ʻuluaki ʻotu ko e satisi, mo e topasi, mo e kapukeli: ko ʻeni ʻae ʻuluaki ʻotu. ");
INSERT INTO ton_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Pea ko hono ua ʻoe ʻotu, ko e ʻemalata, mo e safaia, mo e taiamoni. ");
INSERT INTO ton_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Pea ko hono tolu ʻoe ʻotu, ko e likua, mo e ʻaketi, mo e ʻametisi. ");
INSERT INTO ton_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Pea ko hono fā ʻoe ʻotu, ko e pelili, mo e ʻoniki, mo e sasipa: naʻe fakamaʻu ia ʻi he ngaahi takafi koula mo honau fakamaʻu. ");
INSERT INTO ton_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Pea naʻe hongofulu ma ua ʻae maka, ʻo fakatatau ki he hingoa ʻoe fānau ʻa ʻIsileli, ʻo hangē ko e tohi tongitongi ʻoe mama, taki taha mo hono hingoa, ʻo fakatatau ki he faʻahinga ʻe hongofulu ma ua. ");
INSERT INTO ton_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pea naʻa nau ngaohi ki hono potu ʻe ua ʻoe sīfafatafata ʻae nonoʻo koula haohaoa ʻe ua, ko e ngāue fihifihi. ");
INSERT INTO ton_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Pea naʻa nau ngaohi ʻae takafi koula ʻe ua, mo e kavei koula ʻe ua; pea ʻai ʻae kavei ʻe ua ki hono potu ʻe ua ʻoe sīfafatafata. ");
INSERT INTO ton_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Pea naʻa nau ʻai ʻae ongo nonoʻo koula fihifihi ki he kavei ʻe ua ʻi hono potu ʻe ua ʻoe sīfafatafata. ");
INSERT INTO ton_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Pea ko hono potu ʻe ua ʻoe nonoʻo fihifihi ʻe ua, naʻa nau fakamaʻu ki he takafi ʻe ua, pea naʻe ʻai ia ki he potu ʻe ua ʻoe uma ʻoe ʻefoti ki ʻao. ");
INSERT INTO ton_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Pea naʻa nau ngaohi ʻae kavei koula ʻe ua, ʻo ʻai ia ʻi he potu ʻe ua ʻoe sīfafatafata, ki he kapa ʻo ia, ʻaia naʻe ʻi he potu ki loto ʻoe ʻefoti. ");
INSERT INTO ton_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Pea naʻa nau ngaohi ʻae kavei koula kehe ʻe ua, pea naʻe ʻai ia ʻi he potu ʻe ua ʻoe ʻefoti ʻi lalo, ʻo ofi ki he potu ki ʻao; ʻo hangatonu atu ki he fakamaʻu ʻe taha ʻo ia, ʻi ʻolunga ʻi he noʻo fakanikonikoʻi ʻoe ʻefoti. ");
INSERT INTO ton_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Pea naʻa nau fakamaʻu ʻae sīfafatafata ʻaki hono kavei ki he kavei ʻoe ʻefoti ʻaki ʻae noʻo lanumoana, koeʻuhi ke ʻi ʻolunga ia ʻi he noʻo fakanikonikoʻi ʻoe ʻefoti, pea koeʻuhi ke ʻoua naʻa vete ʻae sīfafatafata mei he ʻefoti; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","¶ Pea naʻa ne ngaohi ʻae kofu fakatōtōlofa ʻoe ʻefoti ʻaki ʻae ngāue lalanga, pea ko e lanumoana pe ia kātoa. ");
INSERT INTO ton_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Pea naʻe ai ʻae ava ʻi he loto ʻoe kofu tōtōlofa, ʻo hangē ko e ava ʻoe kofu tau, mo e meʻa fakamaʻu naʻe takatakai ʻae ava telia naʻa mahae ia. ");
INSERT INTO ton_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Pea naʻa nau ngaohi ʻi he tapatapa ʻoe kofu fakatōtōlofa ʻae ngaahi pomikanite ʻoe lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, mo e tupenu tuʻovalevale. ");
INSERT INTO ton_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Pea naʻa nau ngaohi ʻae ngaahi fafangu ʻoe koula haohaoa pea naʻe ai ʻae ngaahi fafangu ki he vahaʻa ʻoe pomikanite ʻi he tapa ʻoe kofu fakatōtōlofa, ʻo takatakai ʻi he vahaʻa ʻoe ngaahi pomikanite; ");
INSERT INTO ton_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Ko e fafangu mo e pomikanite, ko e fafangu mo e pomikanite, ʻo takatakai ʻi he tapatapa ʻoe kofu fakatōtōlofa ke fai ai ʻae ngāue: hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","¶ Pea naʻa nau ngaohi ʻae ngaahi kofutuʻa ʻoe tupenu tuʻovalevale kuo lalanga moʻo ʻElone, mo hono ngaahi foha, ");
INSERT INTO ton_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Mo e tatā ʻoe tupenu tuʻovalevale, mo e ngaahi tatā lelei ʻoe tupenu tuʻovalevale, mo e kofu vaʻe tupenu ko e tupenu tuʻovalevale, ");
INSERT INTO ton_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Mo e noʻo ʻoe tupenu tuʻovalevale, mo e lanumoana, mo e paʻuhiʻuhi, mo e kulaʻahoʻaho, naʻe tuitui: ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","¶ Pea naʻa nau ngaohi ʻae pale ʻoe tatā tapu ʻoe koula haohaoa, ʻo tohi ki ai ʻae tohi, ʻo hangē ko e tohi tongitongi ʻoe mama, KO E MĀʻONIʻONI KIA SIHOVA. ");
INSERT INTO ton_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Pea naʻa nau nonoʻo ki ai ʻae noʻo ko e lanumoana, ke fakamaʻu ʻaki ia ʻi ʻolunga ki he tatā; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","¶ Pea naʻe pehē hono fakaʻosi ʻoe ngaahi ngāue kotoa pē ki he fale tapu ʻoe fale fehikitaki ʻoe kakai: pea naʻe fai ʻe he fānau ʻa ʻIsileli ʻo fakatatau ki he meʻa kotoa pē naʻe fekau ʻe Sihova kia Mōsese, naʻe pehē pe ʻenau fai. ");
INSERT INTO ton_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","¶ Pea naʻa nau ʻomi ʻae fale tapu kia Mōsese, ko e fale fehikitaki, mo hono nāunau kotoa pē, ko hono ngaahi fakamaʻu, mo hono ngaahi laupapa, mo hono ngaahi ʻakau fakamaʻu, mo hono ngaahi pou, mo hono ngaahi tuʻunga, ");
INSERT INTO ton_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Mo hono fakapulonga ʻoe kiliʻi sipitangata naʻe tukukula, pea mo e fakapulonga ʻoe kiliʻi pasia, pea mo e puipui ke ʻufiʻufi ʻaki, ");
INSERT INTO ton_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Ko e puha ʻoe fuakava, mo hono ongo haʻamo, mo e nofoʻanga ʻaloʻofa, ");
INSERT INTO ton_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Ko e palepale, mo hono ngaahi nāunau ʻo ia, mo e mā ʻoe ʻao, ");
INSERT INTO ton_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Ko e tuʻunga maama maʻa, mo hono ngaahi foʻi maama, mo hono ngaahi ʻaiʻanga maama ke teuʻi, mo hono ngaahi nāunau kotoa pē ʻo ia, mo e lolo ki he maama, ");
INSERT INTO ton_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Mo e feilaulauʻanga koula, mo e lolo tākai, mo e meʻa namu kakala, mo e meʻa tautau ki he matapā ʻoe fale fehikitaki, ");
INSERT INTO ton_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ko e feilaulauʻanga palasa mo hono meʻa vangavanga palasa, ʻa hono ongo haʻamo, mo hono nāunau kotoa pē, ko e sene mo hono tuʻunga, ");
INSERT INTO ton_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ko e ngaahi puipui tautau ki he lotoʻā, ʻa hono ngaahi pou, mo hono ngaahi tuʻunga, mo e meʻa tautau ki he matapā ʻoe lotoʻā, ʻa hono ngaahi afo, mo hono ngaahi faʻo, pea mo e ngaahi ipu kotoa pē ki he ngāue ʻoe fale tapu, ki he fale fehikitaki ʻoe kakai, ");
INSERT INTO ton_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ko e ngaahi kofu ngāue ke fai ai ʻae ngāue ʻi he potu māʻoniʻoni, mo e ngaahi kofu māʻoniʻoni kia ʻElone ko e taulaʻeiki, mo e ngaahi kofu ki hono ngaahi foha, ke ngāue ai ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Pea naʻe fai ʻae ngāue kotoa pē ʻe he fānau ʻa ʻIsileli, ʻo fakatatau ki he meʻa kotoa pē naʻe fekau ʻe Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Pea naʻe vakai ʻe Mōsese ki he ngaahi ngāue kotoa pē, pea vakai, kuo nau fai ia ʻo hangē ko e fekau ʻa Sihova, ʻio, naʻe pehē pe ʻenau fai ia: pea naʻe tāpuaki ʻakinautolu ʻe Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ʻI he ʻuluaki ʻaho ʻoe ʻuluaki māhina, te ke fokotuʻu ʻae fale tapu ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Pea te ke ʻai ki ai ʻae puha ʻoe fuakava, pea ʻufiʻufi ʻaki ʻae puha ʻae puipui. ");
INSERT INTO ton_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Pea te ke ʻomi ki ai ʻae palepale, pea ke ʻai ʻo fakatonutonu ʻae ngaahi meʻa ʻoku totonu ke ʻai ki ai; pea ke ʻomi ki ai ʻae tuʻunga maama, ʻo tutu ʻae ngaahi maama ʻo ia. ");
INSERT INTO ton_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Pea te ke tuku ʻae feilaulauʻanga koula ki he meʻa namu kakala, ʻi he ʻao ʻoe puha ʻoe fuakava, pea ʻai ʻae puipui tautau ki he matapā ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Pea te ke fokotuʻu ʻae feilaulauʻanga ʻoe feilaulau tutu ʻi he ʻao ʻoe matapā ʻoe fale tapu ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Pea te ke fokotuʻu ʻae sene ʻi he vahaʻa ʻoe fale fehikitaki ʻoe kakai, mo e feilaulauʻanga, pea ke ʻai ki ai ʻae vai. ");
INSERT INTO ton_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Pea te ke fokotuʻu hono lotoʻā ʻo takatakai ia, pea tautau hake hono puipui ʻi he matapā ʻoe lotoʻā. ");
INSERT INTO ton_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Pea te ke ʻave ʻae lolo tākai, ʻo tākai ʻaki ʻae fale fehikitaki, mo e meʻa kotoa pē ʻoku ʻi ai, mo ke fakatapui ia, mo hono ngaahi nāunau kotoa pē ʻo ia: pea ʻe māʻoniʻoni ia. ");
INSERT INTO ton_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Pea te ke tākai ʻae feilaulauʻanga ʻoe feilaulau tutu, mo hono ngaahi nāunau kotoa pē, ʻo fakatapui ʻae feilaulauʻanga: pea ʻe hoko ia ko e feilaulauʻanga fungani māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Pea te ke tākai ʻae sene mo hono tuʻunga, ʻo fakatapui ia. ");
INSERT INTO ton_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Pea te ke ʻomi ʻa ʻElone mo hono ngaahi foha ki he matapā ʻoe fale fehikitaki ʻoe kakai, ʻo kaukauʻi ʻakinautolu ʻaki ʻae vai. ");
INSERT INTO ton_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pea te ke ʻai kia ʻElone ʻae ngaahi kofu māʻoniʻoni, pea tākai ia, ʻo fakatapui ia; koeʻuhi ke ne ngāue kiate au ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Pea te ke ʻomi hono ngaahi foha, ʻo fakakofuʻaki ʻakinautolu ʻae ngaahi kofutuʻa. ");
INSERT INTO ton_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Pea te ke tākai ʻakinautolu ʻo hangē ko hoʻo tākai ʻenau tamai, koeʻuhi ke nau ngāue kiate au ʻi he ngāue fakataulaʻeiki: he ko honau tākai ia ki he ngāue fakataulaʻeiki moʻoni ʻo taʻengata ʻi honau toʻutangata kotoa pē tuku fakaholo.” ");
INSERT INTO ton_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Pea naʻe fai ia ʻe Mōsese: ʻo hangē ko e meʻa kotoa pē naʻe fekau ʻe Sihova kiate ia, naʻe pehē ʻene fai. ");
INSERT INTO ton_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","¶ Pea ʻi he ʻuluaki māhina ʻi hono ua ʻoe taʻu, ʻi he ʻuluaki ʻaho ʻoe māhina, naʻe hoko ʻo pehē, naʻe fokotuʻu hake ʻae fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Pea naʻe fokotuʻu hake ʻe Mōsese ʻae fale fehikitaki, ʻo ne fakamaʻu hono ngaahi tuʻunga, pea naʻe fokotuʻu hake ʻa hono ngaahi laupapa, pea ʻai ki ai hono ngaahi ʻakau fakamaʻu, pea naʻe fokotuʻu hono ngaahi pou. ");
INSERT INTO ton_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Pea naʻa ne folahi atu ʻae fakapulonga ʻi ʻolunga ʻi he fale fehikitaki, pea naʻe ʻai hono fakapulonga ʻe taha ki ai ʻi ʻolunga ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","¶ Pea naʻa ne ʻave ʻae fuakava ʻo ne ʻai ia ki he puha, pea naʻe ʻai ʻae ongo ʻakau haʻamo ki he puha, pea naʻe hili ʻae nofoʻanga ʻaloʻofa ki ʻolunga ʻi he puha. ");
INSERT INTO ton_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Pea naʻa ne ʻomi ʻae puha ki loto ʻi he fale fehikitaki, pea naʻe fokotuʻu ai ʻae puipui ʻufiʻufi, pea naʻe ʻufiʻufi ai ʻae puha ʻoe fuakava ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","¶ Pea naʻa ne tuku ʻae palepale ki he fale fehikitaki ʻoe kakai, ki he potu tokelau ʻoe fale fehikitaki, ʻituʻa ʻi he puipui. ");
INSERT INTO ton_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Pea naʻa ne tuku lelei ʻi ai ʻae mā, ʻi he ʻao ʻo Sihova; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","¶ Pea naʻa ne ʻai ʻae tuʻunga maama ʻi he fale fehikitaki ʻoe kakai, ʻo hanga tonu atu ki he palepale, ʻi he potu tonga ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Pea naʻa ne tutu ʻae ngaahi maama ʻi he ʻao ʻo Sihova; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","¶ Pea naʻa ne ʻai ʻae feilaulauʻanga koula ʻi he fale fehikitaki ʻoe kakai ʻi he ʻao ʻoe puipui: ");
INSERT INTO ton_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Pea naʻa ne tutu ʻae meʻa namu kakala ʻi hono funga ʻo ia; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","¶ Pea naʻa ne tautau hake ʻae puipui ʻi he matapā ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Pea naʻa ne fokotuʻu ʻae feilaulauʻanga ʻoe meʻa tutu ʻo ofi ki he matapā ʻoe fale tapu ʻoe fale fehikitaki ʻoe kakai, ʻo ne ʻatu ʻi ai ʻae feilaulau tutu, mo e feilaulau meʻakai; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","¶ Pea naʻa ne fokotuʻu ʻae sene ʻi he vahaʻa ʻoe fale fehikitaki ʻoe kakai mo e feilaulauʻanga, pea naʻe ai ki ʻai ʻae vai, ke kaukau ʻaki. ");
INSERT INTO ton_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Pea ko Mōsese mo ʻElone mo hono ngaahi foha naʻa nau fanofano honau nima, mo kaukauʻi honau vaʻe ʻi ai: ");
INSERT INTO ton_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","‌ʻI heʻenau hū ki he fale fehikitaki ʻoe kakai, pea ʻi heʻenau haʻu ʻo ofi ki he feilaulauʻanga, naʻa nau kaukau; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Pea naʻa ne fokotuʻu ʻae lotoʻā ʻo fakatakamilo ki he fale fehikitaki, mo e feilaulauʻanga, ʻo fokotuʻu hake ʻae puipui ki he matapā ʻoe lotoʻā. Pea naʻe fakaʻosi pehē ʻe Mōsese ʻae ngāue. ");
INSERT INTO ton_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","¶ Pea hili ia naʻe ʻufiʻufi leva ʻe he ʻao ʻae fale fehikitaki ʻoe kakai, pea naʻe fakafonu ʻe he nāunau ʻo Sihova ʻae fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Pea naʻe ʻikai mafai ʻe Mōsese ke hū ki he fale fehikitaki ʻoe kakai, ko e meʻa ʻi he nofomaʻu ki ai ʻae ʻao, pea naʻe fakafonu ʻe he nāunau ʻo Sihova ʻae fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Pea ka toʻo hake ʻae ʻao mei heʻene fakamalumalu ʻae fale fehikitaki, naʻe fononga ʻae fānau ʻa ʻIsileli ʻi honau ngaahi fononga kotoa pē: ");
INSERT INTO ton_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pea kapau naʻe ʻikai toʻo hake ʻae ʻao, pea naʻe ʻikai te nau fononga, kaeʻoua ke hoko ʻae ʻaho kuo toʻo hake ai ia. ");
INSERT INTO ton_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","He naʻe fakamalumalu ʻae fale fehikitaki ʻe he ʻao ʻo Sihova ʻi he ʻaho, pea naʻe ʻi ai ʻae afi ʻi he poʻuli, ʻi he ʻao ʻoe fale kotoa pē ʻo ʻIsileli, ʻi honau ngaahi fononga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Pea naʻe ui ʻa Sihova kia Mōsese, ʻo folofola kiate ia mei he fale fehikitaki ʻoe kakai, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo tala kiate kinautolu, Kapau ʻoku ai ha tangata ʻiate kimoutolu ʻoku ʻomi ha meʻaʻofa kia Sihova, temou ʻomi hoʻomou meʻaʻofa ʻi he fanga manu, ʻio, ʻi he fanga manu lalahi, mo e fanga manu siʻi. ");
INSERT INTO ton_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kapau ko e feilaulau tutu mei he fanga manu lalahi ʻa ʻene meʻaʻofa, tuku ke ne ʻatu ʻae manu tangata taʻehanomele, te ne ʻatu ia ʻi hono loto lelei pe ʻi he matapā ʻoe fale fehikitaki ʻoe kakai, ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Pea te ne hilifaki hono nima ki he ʻulu ʻoe feilaulau tutu; pea ʻe maʻu ia mei ai koeʻuhi ke fai ʻaki ʻae fakalelei maʻana. ");
INSERT INTO ton_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Pea ʻe tāmateʻi ʻe ia ʻae pulu tangata ʻi he ʻao ʻo Sihova: pea ko e kau taulaʻeiki ko e ngaahi foha ʻo ʻElone, tenau ʻomi ʻae toto, pea luluku ʻae toto ʻo fakatakatakamilo ʻi he feilaulauʻanga, ʻaia ʻoku ofi ki he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Pea te ne fohiʻi ʻae feilaulau tutu, pea tafa ia ʻo mavahevahe. ");
INSERT INTO ton_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Pea ko e ngaahi foha ʻo ʻElone ko e kau taulaʻeiki, tenau ʻai ʻae afi ki he feilaulauʻanga, pea hili totonu ʻae fefie ki he afi: ");
INSERT INTO ton_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Pea ko e kau taulaʻeiki, ko e ngaahi foha ʻo ʻElone, tenau hili totonu ʻae ngaahi konga, ko e ʻulu, mo e ngako ki he fefie ʻaia ʻoku ʻi he afi ʻi he feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Ka ko hono toʻotoʻonga mo hono kauvaʻe, ʻe fufuluʻaki ʻae vai: pea ʻe tutu kotoa pē ʻe he taulaʻeiki ʻi he feilaulauʻanga, ko e feilaulau tutu, ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","¶ Pea kapau ʻoku ʻomi mei he fanga manu siʻi ʻene meʻaʻofa, ʻi he fanga sipi, pe ʻi he fanga kosi, koeʻuhi ko e feilaulau tutu; te ne ʻomi ia ko e manu tangata taʻehanomele. ");
INSERT INTO ton_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Pea te ne tāmateʻi ia ʻi he potu fakatokelau ʻoe feilaulauʻanga ʻi he ʻao ʻo Sihova: pea ʻe lulukuʻaki hono toto ʻe he kau taulaʻeiki, ko e ngaahi foha ʻo ʻElone ʻo takatakai ʻi he funga feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Pea te ne tafa ia ki hono ngaahi konga, mo hono ʻulu mo hono ngako: pea ʻe hili totonu ia ʻe he taulaʻeiki ʻi he fefie, ʻaia ʻoku ʻi he afi ʻi he funga feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ka ʻe fufulu ʻe ia hono toʻotoʻonga mo hono kauvaʻe ʻaki ʻae vai: pea ʻe ʻomi kotoa pē ia ʻe he taulaʻeiki, ʻo tutu ia ʻi he feilaulauʻanga: ko e feilaulau tutu ia, ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","¶ Pea kapau ko ʻene feilaulau kia Sihova, ko e manupuna ki heʻene feilaulau tutu, pea te ne ʻomi ʻae kulukulu ʻe ua, pe ko e lupe mui ʻe ua. ");
INSERT INTO ton_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Pea ʻe ʻomi ia ʻe he taulaʻeiki ki he feilaulauʻanga, ʻo motuhi hono ʻulu, ʻo tutu ia ʻi he feilaulauʻanga; pea ʻe tatau hono toto ʻi he potu ʻoe feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Pea te ne toʻo mai hono ngākau mo hono fulufulu, ʻo lī ia ki he potu hopoʻangalaʻā ʻoe feilaulauʻanga ʻo ofi ki he potu ʻoe efuefu. ");
INSERT INTO ton_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pea te ne fahiua ia mo hono kapakau, kaeʻoua naʻa motuua ia; pea ʻe tutu ia ʻe he taulaʻeiki ʻi he feilaulauʻanga, ki he fefie ʻoku ʻi he afi; ko e feilaulau tutu ia, ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Pea ka fie ʻatu ʻe ha tokotaha ʻae feilaulau meʻakai kia Sihova, te ne feilaulau ʻaki ʻae mahoaʻa lelei; pea ʻe lilingi ʻe ia ʻae lolo ki ai, pea ʻe ʻai ki ai ʻae meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Pea te ne ʻomi ia ki he ngaahi foha ʻo ʻElone ko e kau taulaʻeiki: pea te ne toʻo mei ai ha falukunga ʻe taha ʻoe mahoaʻa, mo e lolo ʻo ia, mo e meʻa namu kakala ʻo ia: pea ʻe tutu ʻe he taulaʻeiki hono fakamanatu ʻi he feilaulauʻanga, ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova: ");
INSERT INTO ton_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Pea ko e toenga ʻoe feilaulau meʻakai ʻe ʻia ʻElone ia mo hono ngaahi foha: ko e meʻa fungani māʻoniʻoni ia ʻi he ngaahi feilaulau kia Sihova kuo ngaohi ʻaki ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","¶ Pea kapau te ke ʻomi ha meʻaʻofa ko e feilaulau meʻakai kuo taʻo ʻi he ngotoʻumu, ʻomi ia ko e ngaahi foʻi mā taʻefakalēvani ʻoe mahoaʻa lelei kuo fefiofi mo e lolo, pē ko e ngaahi foʻi mā manifinifi pehē kuo pani ʻaki ʻae lolo. ");
INSERT INTO ton_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","¶ Pea kapau ko hoʻo feilaulau meʻakai ko e meʻa kuo taʻo ʻi he ukamea lafalafa, ʻe mei he mahoaʻa lelei ia taʻefakalēvani, kuo fefiofi mo e lolo. ");
INSERT INTO ton_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Te ke vahevahe ia, pea lingi ʻae lolo ki ai: ko e feilaulau meʻakai ia. ");
INSERT INTO ton_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","¶ Pea kapau ko hoʻo meʻaʻofa ko e feilaulau meʻakai kuo fakapaku ʻi he fakapaku, ʻe ngaohi ʻaki ia ʻae mahoaʻa lelei mo e lolo. ");
INSERT INTO ton_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Pea te ke ʻomi ʻae feilaulau meʻakai kuo ngaohi ʻaki ʻae ngaahi meʻa ni kia Sihova: pea ka ʻatu ia ki he taulaʻeiki, te ne ʻomi ia ki he feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Pea ʻe toʻo ʻe he taulaʻeiki mei he feilaulau meʻakai hono fakaʻilonga, ʻo tutu ia ki he feilaulauʻanga: ko e feilaulau ia kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Pea ko ia ʻoku toe ʻi he feilaulau meʻakai, ʻoku ia ʻElone ʻia mo hono ngaahi foha: ko e meʻa fungani māʻoniʻoni ia ʻoe ngaahi feilaulau kia Sihova kuo ngaohi ʻaki ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","‌ʻE ʻikai ngaohi ʻaki ha meʻa fakalēvani ha feilaulau meʻakai ʻoku mou ʻomi kia Sihova: koeʻuhi ʻe ʻikai te mou tutu ha lēvani, pe ha honi, ʻi ha feilaulau ʻoku ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","¶ Pea koeʻuhi ko e meʻaʻofa ʻoe ngaahi ʻuluaki fua, temou ʻatu ia kia Sihova: kaeʻoua naʻa tutu ia ki he feilaulauʻanga ʻoe meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Pea ko e meʻaʻofa kotoa pē ʻo hoʻo feilaulau meʻakai, ke ke fakamāsimaʻi; pea ʻoua naʻa ke tuku haʻo feilaulau meʻakai ʻe taha ke masiva ʻi he māsima ʻoe fuakava ʻa ho ʻOtua: te ke ʻatu ʻae māsima ʻi hoʻo ngaahi feilaulau kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Pea kapau te ke ʻatu kia Sihova ʻae feilaulau meʻakai ʻi hoʻo ngaahi ʻuluaki fua, pea ke ʻatu ko e feilaulau meʻakai ʻae ngaahi fua mata ʻoe uite kuo āngaki ʻi he afi, ʻio ʻae uite kuo tuki mei he ngaahi fua haohaoa. ");
INSERT INTO ton_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Pea ke ʻai ʻae lolo ki ai, pea ʻai ki ai mo e laipeno: ko eni ʻae feilaulau meʻakai. ");
INSERT INTO ton_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Pea ʻe tutu ʻe he taulaʻeiki hono fakaʻilonga ʻo ia, ʻi he uite naʻe tuki; mo e meʻi lolo ʻi ai, mo e laipeno kotoa pē ʻi ai; ko e feilaulau ia kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Pea kapau ko ʻene feilaulau ko e feilaulau fakalelei, pea kapau ʻoku ʻatu ia mei he fanga manu lalahi; kapau ko ha tangata pe ha fefine, ʻe ʻatu ia, ʻi he ʻao ʻo Sihova taʻehanomele. ");
INSERT INTO ton_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Pea ʻe hilifaki ʻe ia hono nima ki he ʻulu ʻo ʻene feilaulau, pea ʻe tāmateʻi ia ʻi he matapā ʻoe fale fehikitaki ʻoe kakai; pea ko e ngaahi foha ʻo ʻElone ko e kau taulaʻeiki tenau luluku fakatakamilo ʻae feilaulauʻanga ʻaki ʻae toto. ");
INSERT INTO ton_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Pea ʻe ʻatu ʻe ia ʻi he feilaulau ʻoe feilaulau fakalelei ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova; ʻae punukete, mo e ngako kotoa pē ʻoku ʻi loto, ");
INSERT INTO ton_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Pea mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻaia ʻoku ʻi he ngutukete; pea ko e ʻahu ʻi ʻolunga ʻi he ʻate, mo e kofuua, ʻe toʻo ia ʻo ʻave. ");
INSERT INTO ton_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Pea ʻe tutu ia ʻe he ngaahi foha ʻo ʻElone, ʻi he funga feilaulauʻanga mo e feilaulau tutu, ʻaia kuo hili ki he fefie ʻoku ʻi he afi; ko e feilaulau ia kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","¶ Pea kapau ko ʻene feilaulau ko e feilaulau fakalelei kia Sihova, mei he fanga manu siʻi, ko e tangata pe ko e fefine, ʻe ʻatu ia taʻehanomele. ");
INSERT INTO ton_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kapau ʻoku ne ʻatu ha lami ko ʻene feilaulau, pehē te ne ʻatu ia ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Pea ʻe hili ʻe ia hono nima ki he ʻulu ʻo ʻene feilaulau, pea ʻe tāmateʻi ia ʻi he mata fale fehikitaki ʻoe kakai, pea ʻe luluku takatakai ʻaki hono toto ʻae funga feilaulauʻanga ʻe he ngaahi foha ʻo ʻElone. ");
INSERT INTO ton_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Pea ʻe ʻatu ʻe ia ʻi he feilaulau ʻoe fakalelei ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ko hono ngako ʻo ia, mo hono iku kotoa ʻe toʻo ʻo motuhi mei he tuʻungaiku: mo e punukete, mo e ngako kotoa pē ʻoku ʻi loto, ");
INSERT INTO ton_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻaia ʻoku ʻi he ngutukete, mo e ʻahu ʻi ʻolunga ʻi he ʻate, mo e kofuua, ʻe toʻo ia ʻo ʻave. ");
INSERT INTO ton_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Pea ʻe tutu ia ʻe he taulaʻeiki ʻi he funga feilaulauʻanga: ko e meʻakai ia ʻoe feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","¶ Pea kapau ko e kosi ʻa ʻene feilaulau, pea ʻe ʻatu ia ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Pea ʻe hili ʻe ia hono nima ki hono ʻulu, ʻo tāmateʻi ia ʻi he mata fale fehikitaki ʻoe kakai: pea ʻe luluku takatakai ʻaki hono toto ʻo ia ʻe he ngaahi foha ʻo ʻElone ʻae funga feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Pea ʻe ʻatu ʻe ia mei ai ʻa ʻene feilaulau, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova; ko e punukete, mo e ngako kotoa pē ʻoku ʻi loto, ");
INSERT INTO ton_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻaia ʻoku ʻi he ngutukete, mo e ʻahu ʻi ʻolunga ʻi he ʻate, mo e kofuua, ʻe toʻo ia ʻo ʻave. ");
INSERT INTO ton_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Pea ʻe tutu ia ʻe he taulaʻeiki ki he funga ʻoe feilaulauʻanga: ko e meʻakai ia ʻoe feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala: ʻoku ʻa Sihova ʻae ngako kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ko e tuʻutuʻuni taʻengata ia ki homou ngaahi toʻutangata ʻi homou ngaahi nofoʻanga, koeʻuhi ke ʻoua naʻa mou kai ngako pe ko e toto. ");
INSERT INTO ton_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Tala ki he fānau ʻa ʻIsileli, ʻo pehē, Kapau ʻe fai hala ʻe ha tokotaha ʻi he taʻeʻilo ki ha fekau ʻa Sihova, ʻaia ʻoku ʻikai ngofua ke fai, pea fai ʻe ia ʻo angatuʻu ki ai: ");
INSERT INTO ton_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kapau ʻoku fai hala ʻae taulaʻeiki ʻaia kuo fakanofo, ʻo hangē ko e angahala ʻae kakai; ke ʻomi ʻe ia maʻa ʻene angahala ʻaia kuo ne fai, ʻae pulu mui taʻehanomele kia Sihova ko e feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Pea ʻe ʻomi ʻe ia ʻae pulu ki he matapā ʻoe fale fehikitaki ʻoe kakai ʻi he ʻao ʻo Sihova: pea ʻe hili hono nima ki he ʻulu ʻoe pulu pea ʻe tāmateʻi ʻae pulu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Pea ʻe toʻo ʻe he taulaʻeiki kuo fakanofo ʻae toto ʻoe pulu ʻo ʻomi ia ki he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Pea ʻe ʻai ʻe he taulaʻeiki hono tuhu ki he toto, pea ʻe luluku ʻaki ʻae toto ke liunga fitu ʻi he ʻao ʻo Sihova, ʻi he tuʻa puipui ʻoe faletapu. ");
INSERT INTO ton_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Pea ʻe ʻai ʻe he taulaʻeiki ʻae toto ki he ngaahi nifo ʻoe feilaulauʻanga namu kakala ʻi he ʻao ʻo Sihova, ʻaia ʻoku ʻi he fale fehikitaki ʻoe kakai: pea ʻe lingi ʻe ia ʻae toto kotoa pē ʻoe pulu ki he tefitoʻi feilaulauʻanga ʻoe feilaulau tutu, ʻaia ʻoku ʻi he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Pea ʻe toʻo ʻe ia mei ai hono ngako, kotoa pē ʻoe pulu ki he feilaulau maʻae angahala; ko e punukete, mo e ngako kotoa pē ʻoku ʻi loto, ");
INSERT INTO ton_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻaia ʻoku ʻi he ngutukete, mo e ʻahu ʻoku ʻi ʻolunga ʻi he ʻate, mo e ongo kofuua, ʻe toʻo ia ʻo ʻave, ");
INSERT INTO ton_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Hangē ko hono toʻo ʻo ʻave mei he pulu ʻi he feilaulau fakalelei: pea ʻe tutu ia ʻe he taulaʻeiki ki he funga ʻoe feilaulauʻanga ʻoe feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pea ko e kili ʻoe pulu, mo hono kanomate, mo hono ʻulu, mo hono ngaahi kau vaʻe, mo hono toʻotoʻonga, mo hono kinohaʻa, ");
INSERT INTO ton_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","‌ʻIo, hono kotoa ʻoe pulu ʻe fetuku atu ʻe ia kituaʻā ʻi he ʻapitanga, ki he potu maʻa, ʻaia ʻoku lilingi ki ai ʻae efuefu, pea ʻe tutu ia ʻi he fefie ʻaki ʻae afi: ʻe tutu ia ʻi he potu ʻoku lilingi ki ai ʻae efuefu. ");
INSERT INTO ton_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","¶ Pea kapau ʻoku fai hala ʻi he taʻeʻilo ʻe he fakataha kotoa ʻo ʻIsileli, pea fufū ʻae meʻa mei he mata ʻoe fakataha, pea kuo nau fai ki he ngaahi fekau ʻa Sihova, ʻaia ʻoku ʻikai ngofua ke fai, pea ʻoku nau halaia; ");
INSERT INTO ton_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Pea ka hoko ʻo ʻilo ʻae angahala ko ia kuo nau fai, pea ʻe toki ʻatu ʻe he fakataha ʻae pulu mui ʻi heʻenau angahala, ʻonau ʻomi ia ki he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Pea ʻe hili ʻe he kau mātuʻa ʻoe fakataha honau nima ki he ʻulu ʻoe pulu ʻi he ʻao ʻo Sihova: pea ʻe tāmateʻi ʻae pulu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Pea ʻe ʻomi ʻae toto ʻoe pulu ʻe he taulaʻeiki ʻaia kuo fakanofo, ki he fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Pea ʻe ʻai ʻe he taulaʻeiki hono tuhu ki he toto, ʻo luluku ʻaki ia ke liunga fitu ʻi he ʻao ʻo Sihova, ʻi he tuʻa puipui. ");
INSERT INTO ton_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Pea ʻe ʻai ʻe ia ʻae toto ʻi he nifo ʻoe feilaulauʻanga ʻaia ʻoku ʻi he ʻao ʻo Sihova, ʻi he fale fehikitahi ʻoe kakai, pea ʻe lingi ʻe ia ʻae toto kotoa pē ki he tefitoʻi feilaulauʻanga ʻoe feilaulau tutu, ʻaia ʻoku ʻi he matapā ʻoe fale fehikitaki ʻoe fakataha. ");
INSERT INTO ton_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Pea ʻe toʻo ʻe ia hono ngako kotoa pē, ʻo tutu ia ki he funga ʻoe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Pea ʻe fai ʻe ia ki he pulu ni ʻo hangē ko ʻene fai ki he pulu ʻi he feilaulau maʻae angahala, ʻe pehē pē ʻene fai ʻeni: pea ʻe fai ʻe he taulaʻeiki ha fakalelei koeʻuhi ko kinautolu, pea ʻe fakamolemole ia kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Pea ʻe fetuku ʻe ia ʻae pulu kituaʻā ʻi he ʻapitanga, pea ʻe tutu ia ʻo hangē ko ʻene tutu ʻae ʻuluaki pulu: ko e feilaulau ia maʻae angahala ʻae fakataha. ");
INSERT INTO ton_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","¶ ʻOka fai hala ʻae pule, pea fai hala ʻi he taʻeʻilo ki he ngaahi fekau ʻa Sihova ko hono ʻOtua ʻaia ʻoku ʻikai ngofua ke fai, pea ne halaia ai; ");
INSERT INTO ton_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Pea kapau kuo toki ʻilo ʻe ia ʻene angahala; ʻe ʻomi ʻe ia ʻene feilaulau, ko e ʻuhikiʻi kosi, ko e manu tangata taʻehanomele; ");
INSERT INTO ton_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Pea ʻe hili ʻe ia hono nima ki he ʻulu ʻoe kosi, ʻo tāmateʻi ia ʻi he potu ʻoku nau tāmateʻi ai ʻae feilaulau tutu ʻi he ʻao ʻo Sihova: ko e feilaulau ia maʻae angahala ");
INSERT INTO ton_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Pea ʻe toʻo ʻe he taulaʻeiki ʻae toto ʻoe feilaulau maʻae angahala ʻaki hono tuhu, ʻo ʻai ia ki he ngaahi nifo ʻoe feilaulauʻanga ʻoe feilaulau tutu, pea lingi hono toto ki he tefitoʻi feilaulauʻanga ʻoe feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Pea ʻe tutu ʻe ia hono ngako kotoa pē ki he funga ʻoe feilaulauʻanga, ʻo hangē ko e ngako ʻoe feilaulau fakalelei: pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻi heʻene angahala, pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","¶ Pea kapau ʻe fai angahala ʻe he tokotaha ʻi he kakai lāuvale ʻi he taʻeʻilo, ʻo fai hala ki he fekau ʻa Sihova ʻi he meʻa ʻoku ʻikai ngofua ke fai; pea ne halaia ai: ");
INSERT INTO ton_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Pea kapau ʻe toki ʻilo ʻe ia ʻae angahala kuo ne fai: pea ʻe ʻomi ʻe ia ʻene feilaulau, ko e ʻuhikiʻi kosi, ko e manu fefine taʻehanomele, maʻa ʻene angahala ʻaia kuo ne fai. ");
INSERT INTO ton_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Pea ʻe hili ʻe ia hono nima ki he ʻulu ʻoe feilaulau maʻae angahala, ʻo tāmateʻi ʻae feilaulau maʻae angahala ʻi he potu ʻoe feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Pea ʻe toʻo ʻe he taulaʻeiki ʻae toto ʻaki hono tuhu ʻo ʻai ia ki he nifo ʻoe feilaulauʻanga tutu, pea ʻe lingi ʻe ia ʻa hono toto kotoa pē ki he tefitoʻi feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Pea ʻe toʻo ʻe ia ʻae ngako kotoa pē, ʻo hangē ko e toʻo ʻo ʻave ʻae ngako mei he feilaulau ʻoe fakalelei; pea ʻe tutu ia ʻe he taulaʻeiki ki he funga feilaulauʻanga ko e meʻa namu kakala kia Sihova; pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Pea kapau ʻe ʻomi ʻe ia ha lami ko e feilaulau maʻae angahala, pea ʻe ʻomi ia ko emanu fefine taʻehanomele. ");
INSERT INTO ton_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Pea ʻe hili ʻe ia hono nima ki he ʻulu ʻoe feilaulau maʻae angahala, ʻo tāmateʻi ia ko e feilaulau maʻae angahala, ʻi he potu ʻoku nau tāmateʻi ai ʻae feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Pea ʻe toʻo ʻe he taulaʻeiki ʻae toto ʻoe feilaulau maʻae angahala ʻaki hono tuhu, ʻo ʻai ia ki he nifo ʻoe feilaulauʻanga tutu, ʻo lingi hono toto kotoa pē ki he tefitoʻi feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Pea ʻe toʻo ʻo ʻave hono ngako kotoa pē, ʻo hangē ko e ʻave ʻae ngako ʻoe lami mei he feilaulau ʻoe feilaulau fakalelei; pea ʻe tutu ia ʻe he taulaʻeiki ki he funga feilaulauʻanga, ʻo fakatatau ki he ngaahi feilaulau kuo fai ʻaki ʻae afi kia Sihova: pea ʻe fai ʻae fakalelei ʻe he taulaʻeiki maʻa ʻene angahala ʻaia kuo ne fai, pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Pea kapau ʻoku fai angahala ʻe ha tokotaha, ʻo ongoʻi ʻae kape, pea ʻoku ne faʻa fakamoʻoni, pe ko haʻane mamata, pe ko ʻene ʻilo pe: kapau ʻe ʻikai te ne fakahā ia, ʻe ʻiate ia ʻene hia. ");
INSERT INTO ton_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Pea kapau ʻe ala ʻe ha tokotaha ki ha meʻa taʻemaʻa, pe ko e sino ʻoe manu taʻemaʻa, pe ko e sino ʻoe manu lalahi taʻemaʻa, pe ko e sino ʻoe manu totolo taʻemaʻa, pea kapau ʻoku fufū ia kiate ia: ʻe taʻemaʻa foki ia mo hala ai. ");
INSERT INTO ton_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Pea kapau ʻoku lave ia ki he taʻemaʻa ʻae tangata, ʻi he meʻa kehekehe ʻoku taʻemaʻa ai ʻae tangata, pea ʻoku fufū ia kiate ia; ʻoka hoko ʻo ne ʻilo ia, ʻe toki hala ai ia. ");
INSERT INTO ton_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Pea kapau ʻe kape ʻe ha tokotaha, ʻo ne lea ʻaki hono loungutu ke fai kovi, pe ke fai lelei, ha meʻa ʻoku fuakava ki ai ʻae tangata, pea fufū ia ʻiate ia; ʻoka hoko ʻo ne ʻilo ia, pea ʻe hala ai ia ʻi ha taha ʻi he ngaahi meʻa ni. ");
INSERT INTO ton_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Pea ʻe pehē, ʻi heʻene halaia ʻi ha taha ʻoe ngaahi meʻa ni pea ʻoku totonu ʻa ʻene vete ʻene hala ʻi he meʻa ko ia: ");
INSERT INTO ton_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Pea ʻe ʻomi ʻe ia ʻene feilaulau maʻae angahala kia Sihova koeʻuhi ko ʻene angahala kuo ne fai, ko e manu fefine mei he fanga manu, ko e lami, pe ko e ʻuhikiʻi kosi, ko e feilaulau maʻae angahala; pea ʻe fai ʻae fakalelei ʻe he taulaʻeiki koeʻuhi ko ʻene angahala. ");
INSERT INTO ton_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Pea kapau ʻoku ʻikai te ne faʻa ʻomi ha lami, pea ʻe ʻomi ʻe ia kia Sihova koeʻuhi ko e angahala kuo ne fai, ʻae kulukulu ʻe ua, pe ko e lupe mui ʻe ua; ko e taha ko e feilaulau maʻae angahala, mo e taha ko e feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Pea te ne ʻomi ʻe ia ia ki he taulaʻeiki, ʻaia te ne tomuʻa ʻatu ko e feilaulau maʻae angahala, ʻo ne mimio ke motu hono ʻulu mei hono kia, kae ʻikai vaeua ia: ");
INSERT INTO ton_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Pea ʻe luluku ʻe ia ʻae toto ʻoe feilaulau maʻae angahala ki he potu tafaʻaki ʻoe feilaulauʻanga: pea ʻe tatau hono toe ʻoe toto ki he tefitoʻi feilaulauʻanga: ko e feilaulau ia maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Pea ʻe ʻatu ʻe ia hono ua ko e feilaulau tutu, ʻo taau mo hono anga: pea ʻe fai ʻae fakalelei ʻe he taulaʻeiki kiate ia koeʻuhi ko ʻene angahala, pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","¶ Pea kapau ʻe ʻikai faʻa ʻomi ʻe ia ʻae ongo kulukulu, pe ko e ongo lupe mui, pea ʻe ʻomi ʻaia naʻe fai hala, maʻa ʻene feilaulau ko e feilaulau maʻae angahala, ko hono hongofulu ʻoe vahe ʻoe efa ʻoe mahoaʻa lelei; ʻe ʻikai ʻai ʻe ʻia ha lolo ki ai, pe ʻe ʻikai te ne ʻai ki ai ha meʻa nanamu: he ko e feilaulau ia maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Pea ʻe ʻomi ia ʻe ia ki he taulaʻeiki, pea ʻe toʻo ʻe he taulaʻeiki ʻae faluku ʻe taha mei ai, ko hono meʻa fakaʻilonga, ʻo tutu ia ki he feilaulauʻanga, ʻo taau mo e ngaahi feilaulau tutu kia Sihova: ko e feilaulau ia maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻi heʻene angahala ʻaia kuo ne fai ʻi ha taha ʻoe ngaahi meʻa ni, pea ʻe fakamolemole ia kiate ia: pea ko hono toe ʻe ʻi he taulaʻeiki ia, ʻo hangē ko e feilaulau meʻakai. ");
INSERT INTO ton_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Kapau ʻe fai hala ʻe ha tokotaha, pea fai angahala ʻi he taʻeʻilo, ʻi he ngaahi meʻa māʻoniʻoni ʻa Sihova; pehē ʻe ʻomi ʻe ia koeʻuhi ko ʻene faihala kia Sihova, ʻae sipitangata taʻehanomele mei he fanga sipi, mo e feilaulau maʻae angahala ʻi he ngaahi sikeli siliva, te ke lau kiate ia ʻo tatau mo e sikeli ʻoe faletapu: ");
INSERT INTO ton_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Pea ʻe fai ʻe ia ʻae totongi ki he kovi kuo ne fai ki he meʻa māʻoniʻoni, pea te ne fakalahi ʻaki ʻe ia hono nima ʻoe vahe, ʻo ʻatu ia ki he taulaʻeiki: pea ʻe fai ʻae fakalelei maʻana ʻe he taulaʻeiki ʻaki ʻae sipitangata ʻoe feilaulau maʻae angahala, pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","¶ Pea kapau ʻoku fai angahala ʻe ha tokotaha, ʻo fai ha meʻa ʻi he ngaahi meʻa ʻaia kuo fakatapui ʻe he ngaahi fekau ʻa Sihova; neongo naʻe ʻikai te ne ʻilo ia, ka ʻoku ne halaia ai, pea ʻe fua ʻe ia ʻene hia. ");
INSERT INTO ton_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Pea te ne ʻomi ʻe ia ha sipitangata mei he fanga sipi ki he taulaʻeiki, ʻo hangē ko hoʻo lau, ko e feilaulau maʻae angahala; pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻi heʻene taʻeʻilo ʻaia naʻe hē ai ia ʻo ʻikai ʻilo, pea ʻe fakamolemole ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ko e feilaulau ia maʻae angahala: kuo fai hala moʻoni ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Kapau ʻe fai angahala ʻe ha tokotaha, ʻo fai ha meʻa hala kia Sihova, pea loi ki hono kaungāʻapi ʻi ha meʻa naʻe tuku kiate ia ke tauhi, pe ʻi ha fakatau, pe ʻi ha meʻa kuo ʻave fakamālohi, pe ʻi he kākaaʻi hono kaungāʻapi; ");
INSERT INTO ton_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Pe kuo ne ʻilo ha meʻa naʻe mole, pea ʻoku loi ki ai, ʻo fuakava loi, ʻoka fai hala ʻae tangata ʻi ha taha ʻoe ngaahi meʻa ni: ");
INSERT INTO ton_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Pea ʻe pehē, ko e meʻa ʻi heʻene angahala, pea kuo ne halaia, ʻe toe ʻatu ʻe ia ʻaia naʻa ne ʻave fakamālohi, pe ko e meʻa kuo ne maʻu fakakākā pe ko e meʻa naʻe ʻatu kiate ia ke tauhi, pe ko e meʻa naʻe mole ʻaia naʻa ne ʻiloʻi. ");
INSERT INTO ton_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Pe ko e meʻa ko ia kotoa pē kuo ne fuakava loi ki ai; ʻe toe ʻatu ia ʻi hono tatau totonu, pea ke fakalahi ʻaki ʻe ia hono nima ʻoe vahe, ʻo ʻatu kiate ia ʻaia ʻoku totonu ke maʻu, ʻi he ʻaho ʻo ʻene feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Pea te ne ʻomi ʻe ia ʻene feilaulau maʻae angahala kia Sihova, ko e sipitangata taʻehanomele mei he fanga sipi ʻo tatau mo hoʻo lau, ko e feilaulau maʻae angahala, ki he taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻi he ʻao ʻo Sihova: pea ʻe fakamolemole kiate ia ʻi he meʻa kotoa pē ko ia kuo ne fai hala ai. ");
INSERT INTO ton_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Fekau kia ʻElone mo hono ngaahi foha, ʻo pehē, Ko ʻeni ʻae fono ʻoe feilaulau tutu: Ko e feilaulau tutu ia, ko e meʻa ʻi heʻene vela ʻi he pō kotoa ʻo aʻu ki he pongipongi ʻi he funga feilaulauʻanga, pea ko e afi ʻoe feilaulauʻanga ʻe moʻui pe ʻi ai. ");
INSERT INTO ton_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Pea ʻe ʻai ʻe he taulaʻeiki hono kofu tupenu tuʻovalevale, pea ʻai mo hono kofuvaʻe tupenu tuʻovalevale ki hono sino, pea te ne hiki ʻae efuefu kuo vela ʻe he afi mo e feilaulau tutu ʻi he feilaulauʻanga, pea ʻe lilingi ʻe ia ia ʻi he tafaʻaki ʻoe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Pea ʻe vete ʻe ia hono ngaahi kofu ʻo tuku, kae ʻai ʻae kofu kehe, pea te ne fetuku ʻae efuefu ki he potu maʻa ʻi tuaʻā ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Pea ʻe moʻui maʻuaipē ʻae afi ʻi he feilaulauʻanga; ʻe ʻikai tāmateʻi: pea ʻe tutu ʻae fefie ki ai ʻe he taulaʻeiki ʻi he pongipongi kotoa pē, pea hilifaki lelei pe ki ai ʻae feilaulau tutu: pea ʻe tutu ʻe ia ki ai ʻae ngako ʻoe ngaahi feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","‌ʻE moʻui maʻuaipē ʻae afi ʻi he feilaulauʻanga; ʻe ʻikai mate ia ʻo taʻengata. ");
INSERT INTO ton_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","¶ Pea ko e fono eni ʻoe feilaulau meʻakai: ʻe ʻatu ia ʻe he ngaahi foha ʻo ʻElone ʻi he ʻao ʻo Sihova, ʻi he muʻa feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Pea ʻe toʻo ʻe ia ʻae faluku ʻe taha ʻoe mahoaʻa ʻoe feilaulau meʻakai, pea mo hono lolo ʻo ia, mo e laipeno kotoa pē ʻaia ʻoku ʻi he feilaulau meʻakai, ʻo tutu ia ki he funga ʻoe feilaulauʻanga, ʻio, ko hono fakamanatu ʻo ia, kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Pea ko hono toe ʻe kai ʻe ʻElone mo hono ngaahi foha: ʻe kai ia mo e mā taʻefakalēvani ʻi he potu māʻoniʻoni; tenau kai ia ʻi he lotoʻā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","‌ʻOua naʻa taʻo ia mo e lēvani. Kuo u tuku ia ko honau ʻinasi ʻi he ngaahi feilaulau tutu kiate au: ʻoku fungani māʻoniʻoni ia, ʻo hangē ko e feilaulau maʻae angahala, pea hangē ko e feilaulau maʻae fai hala. ");
INSERT INTO ton_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","‌ʻE kai ia ʻe he fānau tangata kotoa pē ʻi he fānau ʻa ʻElone. Ko e fekau fai maʻu pe ia ʻo taʻengata ʻi homou ngaahi toʻutangata ki he ngaahi feilaulau tutu ʻa Sihova: ko ia kotoa pē ʻe ala ki ai ʻe tapu ia. ");
INSERT INTO ton_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Ko e feilaulau eni ʻa ʻElone mo hono ngaahi foha, ʻaia tenau ʻatu kia Sihova ʻi he ʻaho ʻoku fakanofo ai ia; ko hono hongofulu ʻoe vahe ʻoe efa ʻoe mahoaʻa lelei ko e feilaulau meʻakai fai maʻu pe, ko hono vahe ʻe taha ʻi he pongipongi, mo hono vahe ʻe taha ʻi he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","‌ʻE ngaohi ia ʻi he fakapaku ʻaki ʻae lolo: pea hili ʻa hono fakapaku, te ke ʻomi ia ki loto: pea ko e ngaahi konga ʻoe feilaulau meʻakai kuo fakapaku ke ke ʻatu ia ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Pea ko e taulaʻeiki ʻi hono ngaahi foha ʻaia kuo fakanofo ko hono tongia ʻe ʻatu ʻe ia ia; ko e fekau fai maʻu ia ʻo taʻengata kia Sihova; ʻe tutu ke vela ʻa hono kātoa ʻo ia. ");
INSERT INTO ton_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","He ko e feilaulau meʻakai kotoa pē ki he taulaʻeiki ʻe tutu hono kotoa ʻo ia ʻe ʻikai kai ia. ");
INSERT INTO ton_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Lea kia ʻElone pea ki hono ngaahi foha, ʻo pehē, Ko eni ʻae fono ʻoe feilaulau maʻae angahala; ʻi he potu ko ia ʻoku tāmateʻi ai ʻae feilaulau tutu ʻe tāmateʻi ʻi ai ʻae feilaulau maʻae angahala ʻi he ʻao ʻo Sihova: ʻoku fungani māʻoniʻoni ia. ");
INSERT INTO ton_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Ko e taulaʻeiki ʻoku ne ʻatu ia maʻae angahala ʻe kai ʻe ia ia: ʻe kai ia ʻi he potu tapu ʻi he lotoʻā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ko ia kotoa pē ʻe ala ki hono kakano ʻe tapu ai ia: pea ka luluku ʻaki ʻae toto ʻo ia ki ha kofu, te ke fō ʻaia naʻe luluku ʻi he potutapu. ");
INSERT INTO ton_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ka ko e kulo ʻumea naʻe haka ai ia ʻe foa ia: pea kapau naʻe haka ʻi he kulo palasa, pea ʻe olo ia, pea fufulu ʻaki ʻae vai. ");
INSERT INTO ton_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ko e fānau tangata kotoa pē ʻi he kau taulaʻeiki ʻe kai ia: ʻoku fungani māʻoniʻoni ia. ");
INSERT INTO ton_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pea ʻe ʻikai kai ʻae feilaulau maʻae angahala, ʻaia kuo ʻomi ʻa hono toto ki he fale fehikitaki ʻoe kakai ke fai ʻaki ʻae fakalelei, ʻi he potu māʻoniʻoni: ʻe tutu ia ʻi he afi. ");
INSERT INTO ton_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ko e fono foki eni ʻoe feilaulau maʻae fai hala: ʻoku māʻoniʻoni lahi ia. ");
INSERT INTO ton_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","‌ʻI he potu ʻoku nau tāmateʻi ai ʻae feilaulau tutu tenau tāmateʻi ʻae feilaulau maʻae fai hala: pea ko e toto ʻo ia ʻe luluku ʻaki ʻae feilaulauʻanga ʻo fakatakamilo. ");
INSERT INTO ton_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Pea ʻe ʻatu ʻe ia hono ngako kotoa pē ʻo ia; ko hono tuʻunga iku, mo e punukete, ");
INSERT INTO ton_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Mo e kofuua ʻe ua, mo e ngako ʻoku ʻi ai, ʻaia ʻoku ofi ki he ngutukete, mo e ʻahu ʻoku ʻi ʻolunga ʻi he ʻate, mo e ongo kofuua, ʻe toʻo ʻe ia ia ʻo ʻave. ");
INSERT INTO ton_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Pea ʻe tutu ia ʻe he taulaʻeiki ki he funga feilaulauʻanga ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ko e feilaulau ia maʻae fai hala. ");
INSERT INTO ton_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ko e tangata kotoa pē ʻi he kau taulaʻeiki ʻe kai ia: ʻe kai ia ʻi he potu tapu ʻoku fungani māʻoniʻoni ia. ");
INSERT INTO ton_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Hangē ko e feilaulau maʻae angahala, ʻoku pehē pe ʻae feilaulau maʻae fai hala: ʻoku taha pe ʻae fono ki ai: ko e taulaʻeiki ʻoku fai ʻaki ia ʻae fakalelei ʻe maʻu ʻe ia ia. ");
INSERT INTO ton_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pea ko e taulaʻeiki ʻoku ne ʻatu ʻae feilaulau tutu ʻa ha tangata, ʻe maʻu ʻe he taulaʻeiki maʻana ʻae kili ʻoe feilaulau tutu ʻaia kuo ʻatu ʻe ia. ");
INSERT INTO ton_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Pea ko e feilaulau meʻakai kotoa pē ʻoku taʻo ʻi he ngotoʻumu, mo ia kotoa pē ʻoku fai ʻi he fakapaku, pe ʻi he ukamea lafalafa ʻe ʻi he taulaʻeiki ia ʻaia ʻoku ne ʻatu ia. ");
INSERT INTO ton_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Pea ko e feilaulau meʻakai kotoa pē, ʻoku feofi mo e lolo, pea mo ia ʻoku mōmoa, ʻe maʻu tatau pe ʻe he ngaahi foha ʻo ʻElone. ");
INSERT INTO ton_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Pea ko e fono eni ʻoe feilaulau ʻoe ngaahi feilaulau fakamelino, ʻaia ʻe ʻatu ʻe ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kapau ʻoku ne ʻatu ia ko e meʻa fakafetaʻi, pea ʻe ʻatu ʻe ia fakataha mo e feilaulau fakafetaʻi ʻae ngaahi mā taʻefakalēvani kuo fefiofi mo e lolo, mo e ngaahi mā manifinifi taʻefakalēvani kuo pani ʻaki ʻae lolo, mo e ngaahi mā ʻoe mahoaʻa lelei ʻoku fefiofi mo e lolo, ʻoku fakapaku. ");
INSERT INTO ton_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pea ʻe ʻatu ʻe ia fakataha mo e ngaahi mā ʻi heʻene feilaulau ʻae mā kuo ʻi ai ʻae meʻa fakalēvani fakataha mo e feilaulau ʻoe fakafetaʻi ʻo ʻene feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Pea ʻe ʻatu ʻe ia ʻae taha mei he meʻaʻofa kotoa pē ko e feilaulau hiki hake kia Sihova, pea ʻe ʻi he taulaʻeiki ia ʻaia ʻoku ne luluku ʻae toto ʻoe feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Pea ko e kanomate ʻoe feilaulau ʻo ʻene feilaulau fakamelino ko e meʻa fakafetaʻi, ʻe kai ia ʻi he ʻaho ʻoku ʻatu ai ia: ʻe ʻikai tuku ʻe ia hano toe ki he ʻapongipongi. ");
INSERT INTO ton_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Pea kapau ʻoku ʻatu ʻa ʻene feilaulau ko e meʻa ʻi he lea fakapapau, pe ko e feilaulau loto lelei pe, ʻe kai ia ʻi he ʻaho ko ia ʻoku ʻatu ai ʻene feilaulau pea ko e ʻapongipongi foki ʻe kai hono toe: ");
INSERT INTO ton_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ka ko hono toe ʻoe kanomate ʻoe feilaulau ʻi hono tolu ʻoe ʻaho ʻe tutu ʻaki ia ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Pea kapau ʻe kai ʻi hono tolu ʻoe ʻaho ha kanomate ʻoe feilaulau ʻo ʻene feilaulau fakamelino, ʻe ʻikai maʻu ia, pea ʻe ʻikai lau ia kiate ia naʻe ʻatu ia: ko e meʻa kovi lahi ia, pea ko ia ʻoku ne kai ai ʻe fua ʻe ia ʻene hia. ");
INSERT INTO ton_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Pea ko e kanomate ʻoku lave ki ha meʻa taʻemaʻa ʻe ʻikai kai ia: ʻe tutu ʻaki ia ʻae afi; pea koeʻuhi ko e kanomate, ko ia kotoa pē ʻoku maʻa ʻe kai ʻe ia ia. ");
INSERT INTO ton_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ka ko ia ʻoku kai ʻae kanomate ʻoe feilaulau ʻoe feilaulau fakamelino, ʻaia ʻoku kau kia Sihova, ka ʻoku ʻiate ia ʻa ʻene taʻemaʻa, ʻe motuhi ʻae laumālie ko ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Pea ko ia foki ʻe lave ki ha meʻa taʻemaʻa, ki he taʻemaʻa ʻae tangata, pe ha manu, pe ha meʻa fakalielia ʻo taʻemaʻa, pea kai ʻe ia ʻae kanomate ʻoe feilaulau ʻoe feilaulau fakamelino, ʻaia ʻoku kau kia Sihova, ʻe motuhi ʻae laumālie ko ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, ʻoua naʻa mou kai ha ngako ʻoe pulu, pe ko e sipi, pe ko e kosi. ");
INSERT INTO ton_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Pea ko e ngako ʻoe manu mate mahaki pe, mo e ngako ʻo ia kuo mate ʻi he haehae ʻe he manu kehe, ke mou ngāueʻaki ia ʻi ha ngāue kehe: ka ʻe ʻikai ʻaupito te mou kai ia. ");
INSERT INTO ton_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","He ko ia ʻoku ne kai ʻae ngako ʻoe manu, ʻaia ʻoku ʻatu mei ai ʻe he kakai ʻae feilaulau tutu kia Sihova, ʻio, ko ia ʻoku ne kai ai ʻe motuhi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Pea ʻe ʻikai foki te mou kai ha toto ʻo ha manu kapakau pe ha manu kehe, ʻi homou ngaahi nofoʻanga. ");
INSERT INTO ton_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","‌ʻIlonga ha taha ʻe kai ha toto, ʻe motuhi ʻae laumālie ko ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, Ko ia ʻoku ne ʻatu ʻae feilaulau ʻo ʻene ngaahi feilaulau fakamelino kia Sihova, ʻe ʻomi ʻe ia ʻene meʻaʻofa kia Sihova, ʻi he feilaulau ʻo ʻene ngaahi feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","‌ʻE ʻomi ʻe hono nima ʻoʻona pe ʻae ngaahi feilaulau kia Sihova, ʻoku tutu ʻi he afi, ʻe ʻomi ʻe ia ʻae ngako mo e fatafata, koeʻuhi ke taʻaloʻalo ʻaki ʻae fatafata, ko e feilaulau taʻaloʻalo ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Pea ʻe tutu ʻae ngako ʻe he taulaʻeiki ʻi he funga ʻoe feilaulauʻanga: ka ʻoku ʻia ʻElone mo hono ngaahi foha ʻae fatafata. ");
INSERT INTO ton_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Pea te mou ʻatu ki he taulaʻeiki ʻae alanga muʻa toʻomataʻu ko e feilaulau hiki hake ia ʻi he ngaahi feilaulau ʻo hoʻomou ngaahi feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ko ia ʻi he ngaahi foha ʻo ʻElone, ʻoku ʻatu ʻae toto ʻoe feilaulau fakamelino, mo e ngako, ʻe maʻu ʻe ia ʻae alanga muʻa toʻomataʻu ko hono ʻinasi. ");
INSERT INTO ton_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","He ko e fatafata taʻaloʻalo mo e alanga muʻa hiki hake kuo u toʻo mei he fānau ʻa ʻIsileli, mei he ngaahi feilaulau ʻo ʻenau ngaahi feilaulau fakamelino, pea kuo u ʻatu ia kia ʻElone ko e taulaʻeiki, pea ki hono ngaahi foha ʻi he tuʻutuʻuni taʻengata, mei he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","¶ Ko eniʻae ʻinasi ʻoe fakanofo ʻo ʻElone, mo e fakanofo ʻo hono ngaahi foha, mei he ngaahi feilaulau kia Sihova ʻoku tutu ʻi he afi, ʻi he ʻaho ʻoku ne ʻatu ʻakinautolu ke ngāue kia Sihova ʻi he ngāue fakataulaʻeiki; ");
INSERT INTO ton_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","‌ʻAia naʻe fekau ʻe Sihova ke ʻatu kiate kinautolu mei he fānau ʻa ʻIsileli, ʻi he ʻaho naʻa ne fakanofo ai ʻakinautolu, ʻi he tuʻutuʻuni taʻengata ʻi honau ngaahi toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ko eni ʻae fono ʻoe feilaulau tutu, ʻoe feilaulau meʻakai, pea mo e feilaulau maʻae angahala, mo e feilaulau ʻi he fai hala, mo e ngaahi fakatapu, mo e feilaulau ʻoe ngaahi feilaulau fakamelino; ");
INSERT INTO ton_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","‌ʻAia naʻe fekau ʻe Sihova kia Mōsese ʻi he moʻunga ko Sainai, ʻi he ʻaho naʻa ne fekau ai ki he fānau ʻa ʻIsileli, ke ʻatu ʻenau ngaahi meʻaʻofa kia Sihova, ʻi he toafa ʻo Sainai. ");
INSERT INTO ton_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ke ke ʻave ʻa ʻElone mo hono ngaahi foha, mo e ngaahi kofu mo e lolo ʻoe fakatapui, mo e pulu ki he feilaulau maʻae angahala, mo e sipitangata ʻe ua, mo e kato mā taʻefakalēvani; ");
INSERT INTO ton_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Pea ke tānaki ʻae kakai ke fakataha ki he matapā ʻoe fale fehikitaki ʻoe kakai.” ");
INSERT INTO ton_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Pea naʻe fai ʻe Mōsese ʻo hangē ko e fekau ʻa Sihova kiate ia; pea naʻe tānaki fakataha ʻae kakai ki he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Pea pehē ʻe Mōsese ki he kakai, “Ko eni ʻaia kuo fekau ʻe Sihova ke fai.” ");
INSERT INTO ton_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Pea naʻe ʻomi ʻe Mōsese ʻa ʻElone mo hono ngaahi foha, ʻo ne kaukauʻi ʻakinautolu ʻaki ʻae vai. ");
INSERT INTO ton_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Pea naʻa ne ʻai kiate ia ʻae kofutuʻa, ʻo ne nonoʻo ʻaki ʻe ia ʻae noʻo, ʻo ʻai kiate ia ʻae kofu fakatōtōlofa, mo ne ʻai kiate ia ʻae ʻefoti, ʻo ne nonoʻo ʻaki ia ʻae noʻo fakanikonikoʻi ʻoe ʻefoti, ʻo nonoʻo ʻaki ʻe ia ia. ");
INSERT INTO ton_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Pea naʻa ne ʻai ʻae kofu fatafata kiate ia: pea ne ʻai foki ki he kofu fatafata ʻae ʻUlimi mo e Tumemi. ");
INSERT INTO ton_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Pea naʻa ne ʻai ʻae tatā ki hono ʻulu pea naʻa ne ʻai ʻae pale koula ki he muʻa tatā, ko e tatā māʻoniʻoni; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Pea naʻe toʻo ʻe Mōsese ʻae lolo tākai, ʻo ne tākai ʻaki ʻae fale fehikitaki mo ia kotoa pē naʻe ʻi ai, ʻo ne fakatapui kotoa pē ia. ");
INSERT INTO ton_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Pea naʻa ne luluku ʻaki ia ʻae feilaulauʻanga ʻo liunga fitu, ʻo ne tākai ʻaki ʻae feilaulauʻanga mo hono nāunau kotoa pē, mo e sene mo hono tuʻunga, ke fakatapui ia. ");
INSERT INTO ton_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Pea naʻa ne lingi mei he lolo tākai ki he ʻulu ʻo ʻElone, ʻo ne tākai ʻaki ia, ko hono fakatapui. ");
INSERT INTO ton_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Pea naʻe ʻomi ʻe Mōsese ʻae ngaahi foha ʻo ʻElone, ʻo ne ʻai ʻae ngaahi kofu kiate kinautolu, ʻo ne nonoʻo ʻaki ʻakinautolu ʻae ngaahi noʻo, ʻo ne ʻai ʻae tatā kiate kinautolu; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Pea naʻa ne ʻomi ʻae pulu ki he feilaulau maʻae angahala: pea naʻe hilifaki ʻe ʻElone mo hono ngaahi foha honau nima ki he ʻulu ʻoe pulu ki he feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Pea naʻa ne tāmateʻi ia: pea ʻave ʻe Mōsese ʻae toto, ʻo ʻai takatakai ia ʻaki hono tuhu ki he ngaahi nifo ʻoe feilaulauʻanga, ko e fakamaʻa ʻoe feilaulauʻanga, ʻo ne lingi ʻae toto ki he tefitoʻi feilaulauʻanga, ko e fakatapui ia, ke fai ʻi hono funga ʻae fakalelei. ");
INSERT INTO ton_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Pea naʻa ne ʻave ʻae ngako kotoa pē naʻe ʻi loto, mo e ʻahu mei ʻolunga ʻi he ʻate, mo e kofuua ʻe ua, mo hona ngako, pea tutu ia ʻe Mōsese ʻi he funga feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Ka ko e pulu, mo hono kili, ko hono sino, mo hono kinohaʻa, naʻa ne tutu ʻaki ʻae afi ʻi tuaʻā ʻi he ʻapitanga; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","¶ Pea naʻa ne ʻomi ʻae sipitangata ki he feilaulau tutu: pea hilifaki ʻe ʻElone mo hono ngaahi foha honau nima ki he ʻulu ʻoe sipitangata. ");
INSERT INTO ton_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Pea naʻa ne tāmateʻi ia; pea luluku ʻaki ʻe Mōsese ʻae toto ʻae funga ʻoe feilaulauʻanga ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Pea naʻa ne tafa ʻae sipitangata; pea tutu ʻe Mōsese ʻae ʻulu, mo e ngaahi konga, mo e ngako. ");
INSERT INTO ton_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Pea fufulu ʻe ia ʻae toʻotoʻonga mo e keukeu ʻaki ʻae vai; pea tutu ʻe Mōsese hono kotoa ʻoe sipitangata ʻi he funga feilaulauʻanga: ko e feilaulau tutu ia ko e meʻa namu kakala, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","¶ Pea naʻe ʻomi ʻe ia ʻae sipitangata ʻe taha, ko e sipitangata ʻoe fakanofo: pea naʻe hilifaki ʻe ʻElone mo hono ngaahi foha honau nima ki he ʻulu ʻoe sipitangata. ");
INSERT INTO ton_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Pea naʻa ne tāmateʻi ia; pea ʻave ʻe Mōsese ʻa hono toto ʻo ne ʻai ia ki he muʻa telinga toʻomataʻu ʻo ʻElone, pea ki he motuʻa nima ʻo hono nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo hono vaʻe toʻomataʻu. ");
INSERT INTO ton_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Pea ne ʻomi ʻae ngaahi foha ʻo ʻElone, pea ʻai ʻe Mōsese ʻae toto ki honau muʻa telinga toʻomataʻu, pea ki he motuʻa nima ʻo honau nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo honau vaʻe toʻomataʻu: pea naʻe luluku ʻaki ʻe Mōsese ʻae toto ʻae funga feilaulauʻanga ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Pea naʻa ne ʻave ʻae ngako, mo e tuʻungaiku, mo e ngako kotoa pē naʻe ʻi he toʻotoʻonga, mo e ʻahu ʻi ʻolunga ʻi he ʻate, mo hono kofuua ʻe ua, mo hona ngako, mo e alanga muʻa toʻomataʻu: ");
INSERT INTO ton_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Pea toʻo ʻe ia ʻae foʻi mā ʻe taha taʻefakalēvani mei he kato mā taʻefakalēvani ʻi he ʻao ʻo Sihova, mo e foʻi mā naʻe loloʻi mo e foʻi mā manifinifi, ʻo ne ʻai ia ki he ngako, pea ki he alanga muʻa toʻomataʻu: ");
INSERT INTO ton_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Pea naʻe tuku ʻe ia kotoa pē ki he nima ʻo ʻElone, pea ki he nima ʻo hono ngaahi foha, pea taʻaloʻalo ʻaki ia ko e feilaulau taʻaloʻalo ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Pea naʻe toʻo ia ʻe Mōsese mei honau nima, ʻo ne tutu ia ki he funga ʻoe feilaulauʻanga ki he meʻa tutu: ko e ngaahi meʻa ʻoe fakanofo ko e meʻa namu kakala ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Pea naʻe ʻave ʻe Mōsese ʻae fatafata, ʻo taʻaloʻalo ʻaki ia ko e feilaulau taʻaloʻalo ʻi he ʻao ʻo Sihova: ko hono ʻinasi ia ʻo Mōsese ʻi he sipitangata ʻoe fakanofo; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Pea naʻe ʻave ʻe Mōsese ʻae lolo tākai, pea mo e toto ʻaia naʻe ʻi he funga feilaulauʻanga, ʻo ne luluku ʻaki ia ʻa ʻElone, pea mo hono ngaahi kofu, pea mo hono ngaahi foha, pea mo e ngaahi kofu ʻo hono ngaahi foha; ʻo ne fakatapui ʻa ʻElone, mo hono ngaahi kofu, mo hono ngaahi foha, mo e ngaahi kofu ʻo hono ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","¶ Pea naʻe fekau ʻe Mōsese kia ʻElone pea ki hono ngaahi foha, “Haka ʻae kakano ʻi he matapā ʻoe fale fehikitaki ʻoe kakai: pea kai ia ʻi ai, mo e mā ʻoe ngaahi fakanofo ʻoku ʻi he kato, ʻo hangē ko ʻeku fekau, ʻo pehē, Ko ʻElone mo hono ngaahi foha tenau kai ia. ");
INSERT INTO ton_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Pea ko ia ʻoku toe ʻi he kakano, pea mo e mā te mou tutu ʻaki ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pea ʻoua naʻa mou hū kituʻa ʻi he matapā ʻoe fale fehikitaki ʻoe kakai ʻi he ʻaho ʻe fitu, ke ʻoua, ke ngata ʻae ngaahi ʻaho ʻo homou fakanofo: ʻi he ʻaho ʻe fitu te ne fakanofo ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hangē ko ia kuo fai ʻe ia he ʻaho ni, ko ia kuo fekau ʻe Sihova ke fai, ke fai ʻae fakalelei maʻamoutolu. ");
INSERT INTO ton_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ko ia te mou nofomaʻu ai ʻi he matapā ʻoe fale fehikitaki ʻoe kakai ʻi he ʻaho mo e pō ʻi he ʻaho ʻe fitu, ʻo tauhi ʻae fekau ʻa Sihova; telia naʻa mou mate: he kuo pehē hono fekauʻi au.” ");
INSERT INTO ton_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Pea naʻe fai ʻe ʻElone ʻae ngaahi meʻa ni ʻaia naʻe fekau ʻe Sihova ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Pea ʻi hono valu ʻoe ʻaho naʻe ui ʻa Mōsese kia ʻElone mo hono ngaahi foha, pea ki he kau mātuʻa ʻo ʻIsileli: ");
INSERT INTO ton_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Pea pehē ʻe ia kia ʻElone, “Ke ke toʻo kiate koe ʻae ʻuhiki pulu mui ko e feilaulau ki he angahala, mo e sipitangata ko e feilaulau tutu, taʻehanomele, ʻo ʻatu ia ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Pea ke lea ki he fānau ʻa ʻIsileli, ʻo pehē, Toʻo ʻekimoutolu ʻae ʻuhikiʻi kosi ko e feilaulau maʻae angahala; mo e ʻuhiki pulu mo e lami ʻi he ʻuluaki taʻu fakatouʻosi, taʻehanomele, ko e feilaulau tutu; ");
INSERT INTO ton_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Pea mo e pulu mo e sipitangata ko e feilaulau fakamelino, ke feilaulau ʻaki ʻi he ʻao ʻo Sihova; mo e feilaulau meʻakai kuo felingiʻaki ʻae lolo: he ko e ʻaho ni ʻe hā mai ʻa Sihova kiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","¶ Pea naʻa nau ʻomi ʻaia naʻe fekau ʻe Mōsese ki he fale fehikitaki ʻoe kakai: pea naʻe ʻunuʻunu atu ʻae kakai kotoa pē ʻo tuʻu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Pea pehē ʻe Mōsese, “Ko eni ʻae meʻa kuo fekau ʻe Sihova ke mou fai: pea ʻe fakahā ai ʻae nāunau ʻo Sihova kiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Pea pehē ʻe Mōsese kia ʻElone, “ʻAlu ki he feilaulauʻanga, ʻo ʻatu ʻa hoʻo feilaulau maʻae angahala, mo hoʻo feilaulau tutu, pea fai ʻae fakalelei koeʻuhi ko koe, pea maʻae kakai: pea ʻatu ʻae feilaulau ʻae kakai, mo fai ʻae fakalelei koeʻuhi ko kinautolu; ʻo hangē ko e fekau ʻa Sihova.” ");
INSERT INTO ton_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","¶ Pea naʻe ʻalu ʻa ʻElone ki he feilaulauʻanga, ʻo ne tāmateʻi ʻae pulu mui ʻoe feilaulau maʻae angahala, ʻaia ko e meʻa maʻana. ");
INSERT INTO ton_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Pea naʻe ʻomi ʻe he ngaahi foha ʻo ʻElone ʻae toto kiate ia: pea naʻa ne ʻai hono tuhu ki he toto, ʻo ne ʻai ia ki he ngaahi nifo ʻoe feilaulauʻanga, ʻo ne lingi ʻae toto ki he tefitoʻi feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Ka ko hono ngako, mo e kofuua, mo e ʻahu ʻoku ʻi ʻolunga ʻi he ʻate ʻoe feilaulau koeʻuhi ko e angahala, naʻa ne tutu ia ʻi he funga ʻoe feilaulauʻanga; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pea ko hono sino mo hono kili ne ne tutu ʻaki ʻae afi ʻi tuaʻā ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Pea naʻa ne tāmateʻi ʻae feilaulau tutu; pea ko e ngaahi foha ʻo ʻElone naʻa nau ʻatu kiate ia ʻae toto, pea naʻa ne luluku ia ki he feilaulauʻanga ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Pea naʻa nau ʻatu kiate ia ʻae feilaulau tutu, mo hono ngaahi konga ʻo ia mo e ʻulu: pea ne tutu ia ki he funga ʻoe feilaulau. ");
INSERT INTO ton_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Pea naʻe fufulu ʻe ia ʻae toʻotoʻonga mo e keukeu, pea tutu ia ki he funga ʻoe feilaulau tutu ʻi he feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","¶ Pea naʻa ne ʻomi ʻae feilaulau ʻae kakai, ʻo ne ʻave ʻae kosi, ʻaia ko e feilaulau koeʻuhi ko e angahala ʻae kakai, ʻo ne tāmateʻi ia, ʻo ne ʻatu ia koeʻuhi ko e angahala, ʻo hangē ko e ʻuluaki. ");
INSERT INTO ton_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Pea naʻe ʻomi ʻe ia ʻae feilaulau tutu, ʻo ʻatu ia ʻo fakatatau mo e fekau. ");
INSERT INTO ton_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Pea naʻa ne ʻomi ʻae feilaulau meʻakai, pea ne toʻo ʻae mahoaʻa ʻo ia, ʻo ne tutu ia ki he funga feilaulauʻanga, ʻo ofi ki he feilaulau tutu ʻoe pongipongi. ");
INSERT INTO ton_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Pea naʻa ne tāmateʻi ʻae pulu mo e sipitangata ko e feilaulau ʻoe feilaulau fakamelino, ʻaia naʻe fai koeʻuhi ko e kakai: pea ko e ngaahi foha ʻo ʻElone naʻa nau ʻatu ʻae toto kiate ia, ʻaia naʻa ne luluku ki he funga feilaulauʻanga ʻo takatakai hake, ");
INSERT INTO ton_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mo e ngako ʻoe pulu mo e sipitangata, ko e tuʻunga iku, mo e punukete, mo e kofuua, mo e ʻahu ʻi ʻolunga ʻi he ʻate: ");
INSERT INTO ton_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Pea naʻa nau ʻai ʻae ngako ʻoe fatafata, pea tutu ʻe ia ʻae ngako ʻi he funga feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Pea ko e fatafata mo e alanga muʻa toʻomataʻu naʻe taʻaloʻalo ʻaki ʻe ʻElone ko e feilaulau taʻaloʻalo ia ʻi he ʻao ʻo Sihova; ʻo hangē ko e fekau ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Pea naʻe hiki ʻe ʻElone hono nima ki ʻolunga ki he kakai, ʻo ne tāpuaki ʻakinautolu, pea ʻalu hifo ia mei heʻene ʻatu ʻae feilaulau maʻae angahala, mo e feilaulau tutu, mo e feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Pea naʻe ʻalu ʻa Mōsese mo ʻElone ki he fale fehikitaki ʻoe kakai, pea haʻu mei ai mo e tāpuaki ki he kakai: pea naʻe hā mai ʻae nāunau ʻo Sihova ki he kakai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Pea naʻe haʻu ai ʻae afi mei he ʻao ʻo Sihova, ʻo ne fakavela ke ʻosi ʻae feilaulau tutu mo e ngako ʻi he funga ʻoe feilaulauʻanga: pea ʻi he mamata ki ai ʻae kakai kotoa pē, naʻa nau kalanga, pea tō fakafoʻohifo ki honau mata. ");
INSERT INTO ton_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Pea ko Natapi mo ʻApiu ko e ongo foha ʻo ʻElone, naʻa na taki taha toʻo ʻene ipu ʻaiʻanga afi, ʻo ʻai ʻae afi ki ai, pea ʻai ʻae meʻa nanamu ki ai, ʻo na ʻatu ʻae afi kehe ʻi he ʻao ʻo Sihova, ʻaia naʻe fekau ʻe ia ke ʻoua naʻa fai. ");
INSERT INTO ton_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Pea naʻe ʻoho atu ʻae afi meia Sihova, pea na vela ai, pea mate ʻakinaua ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Pea pehē ʻe Mōsese kia ʻElone, “Ko eni ia naʻe folofolaʻaki ʻe Sihova, ʻo pehē, ‘ʻE ʻapasia ʻiate au ʻakinautolu ʻoku ʻunuʻunu mai kiate au, pea ʻe fakahikihiki au ʻi he ʻao ʻoe kakai kotoa pē.’” Pea naʻe longo pe ʻa ʻElone. ");
INSERT INTO ton_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Pea naʻe ui ʻe Mōsese ke haʻu ʻa Misaeli, mo ʻElisafani, ko e ongo foha ʻo ʻUsaeli ko e tuʻasina ʻo ʻElone, ʻo ne pehē kiate kinaua, “Mo omi ke ofi, ʻo fua homou kāinga mei he ʻao ʻoe fale fehikitaki kituaʻā ʻi he ʻapitanga.” ");
INSERT INTO ton_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Pea naʻa na ʻunuʻunu atu, ʻo na fua ia ʻi hona kofu kituaʻā ʻi he ʻapitanga; ʻo hangē ko e fekau ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Pea pehē ʻe Mōsese kia ʻElone mo hono ongo foha ko ʻEleisa mo ʻItama, “ʻOua naʻa toʻo ʻae tatā mei homou ʻulu, pea ʻoua naʻa hae homou kofu; telia naʻa mou mate, pea telia naʻa tō ʻae houhau ki he kakai kotoa pē: kae tuku ki homou ngaahi kāinga ko e fale kotoa ʻo ʻIsileli, kenau tēngihia ʻae vela kuo tutu ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pea ʻoua naʻa mou ʻalu kituaʻā ʻi he matapā ʻoe fale fehikitaki ʻoe kakai, telia naʻa mou mate: he ko e lolo tākai ʻa Sihova ʻoku ʻiate kimoutolu.” Pea naʻa nau fai ʻo hangē ko e lea ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","¶ Pea naʻe folofola ʻa Sihova kia ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ʻOua naʻa ke inu uaine pe ha inu mālohi, ʻa koe, pe ko ho ngaahi foha mo koe, ʻoka mou ka hū ki he fale fehikitaki ʻoe kakai, telia naʻa mou mate: ko e fekau ia ʻe fai maʻuaipē ʻi homou ngaahi toʻutangata kotoa pē: ");
INSERT INTO ton_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Pea koeʻuhi ke mou ʻai ʻae fakaʻilonga kehekehe, ʻi he meʻa māʻoniʻoni, mo e meʻa taʻemāʻoniʻoni, pea ki he meʻa taʻemaʻa, mo e meʻa maʻa; ");
INSERT INTO ton_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Pea koeʻuhi ke mou ako ʻaki ki he fānau ʻa ʻIsileli, ʻae ngaahi fekau kotoa pē ʻaia kuo folofolaʻaki ʻe Sihova kiate kinautolu ʻi he nima ʻo Mōsese.” ");
INSERT INTO ton_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","¶ Pea naʻe lea ʻa Mōsese kia ʻElone, pea mo ʻEliesa mo ʻItama, ko hono ongo foha naʻe toe, ʻo pehē, “Toʻo ʻae feilaulau meʻakai, ʻaia ʻoku toe ʻi he ngaahi feilaulau kia Sihova ʻoku tutu ʻi he afi, pea kai ia taʻefakalēvani ʻi he potu ʻoe feilaulauʻanga, he ʻoku fungani māʻoniʻoni ia: ");
INSERT INTO ton_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Pea mou kai ia ʻi he potutapu, he ko ho ʻinasi ia, mo e ʻinasi ʻo ho ngaahi foha, ʻi he ngaahi feilaulau tutu kia Sihova: he ʻoku pehē pe ʻae fekau kiate au. ");
INSERT INTO ton_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pea ko e fatafata taʻaloʻalo mo e alanga muʻa hiki hake te mou kai ʻi he potu maʻa; ʻa koe, mo ho ngaahi foha, mo ho ngaahi ʻofefine mo koe: he ko ho ʻinasi ia, mo e ʻinasi ʻo ho ngaahi foha, ʻaia kuo foaki mei he ngaahi feilaulau ʻoe feilaulau fakamelino ʻoe fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ko e alanga muʻa hiki hake, mo e fatafata taʻaloʻalo tenau ʻomi fakataha mo e ngaahi feilaulau mo e ngako ʻoku tutu ʻi he afi, ke taʻaloʻalo ʻaki ia ko e meʻa ʻatu taʻaloʻalo ʻi he ʻao ʻo Sihova: pea ʻe ʻiate koe ia, mo ho ngaahi foha mo koe, ʻi he tuʻutuʻuni taʻengata; ʻo hangē ko e fekau ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","¶ Pea naʻe kumi lahi ʻe Mōsese ki he kosi ʻoe feilaulau maʻae angahala, pea vakai, kuo tutu ia: pea naʻe ʻita ai ia kia ʻEliesa mo ʻItama, ko e ongo foha ʻo ʻElone, ʻaia naʻe moʻui mo toe, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Ko e hā naʻe ʻikai temou kai ai ʻae feilaulau maʻae angahala ʻi he potu māʻoniʻoni, he koeʻuhi ʻoku fungani māʻoniʻoni ia, pea kuo foaki ia ʻe he ʻOtua kiate kimoutolu ke mou fua ʻae hia ʻae kakai ʻoe fakataha, ke fai ʻaki ʻae fakalelei maʻanautolu ʻi he ʻao ʻo Sihova? ");
INSERT INTO ton_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Vakai, naʻe ʻikai ʻomi hono toto ki loto ʻi he potu māʻoniʻoni: ko e moʻoni naʻe totonu hoʻomou kai ia ʻi he potu māʻoniʻoni, ʻo hangē ko ʻeku fekau.” ");
INSERT INTO ton_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pea pehē ʻe ʻElone kia Mōsese, “Vakai, kuo nau ʻatu he ʻaho ni ʻenau feilaulau maʻae angahala mo ʻenau feilaulau tutu ʻi he ʻao ʻo Sihova: pea kuo tō ʻae ngaahi meʻa pehē ni kiate au: pea ka ne u kai he ʻaho ni ʻae feilaulau maʻae angahala, pea he ʻe lelei ia ʻi he ʻao ʻo Sihova?” ");
INSERT INTO ton_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Pea ʻi he fanongo ʻa Mōsese ki ai, naʻa ne fiemālie. ");
INSERT INTO ton_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo ne pehē kiate kinaua, ");
INSERT INTO ton_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, Ko eni ʻae ngaahi manu ʻaia temou kai ʻi he ngaahi manu ʻoku ʻi he funga ʻo māmani. ");
INSERT INTO ton_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","‌ʻIlonga ʻaia ʻi he fanga manu ʻoku mavaeua hono pesipesi, pea vaʻe mafahi, pea ʻoku toe lamulamu ʻangaua ʻene kai, temou kai ia. ");
INSERT INTO ton_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Ka ko e niʻihi ʻi ai ʻoku lamu ʻangaua ʻene kai, mo vaeua ʻae vaʻe ʻe ʻikai temou kai: ʻo hangē ko e kāmeli, koeʻuhi ʻoku ne toe lamu ʻene kai, ka ʻoku ʻikai mavahevahe ʻae vaʻe: ʻoku taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Pea mo e koni, koeʻuhi ʻoku ne toe lamu ʻene maʻanga, ka ʻoku ʻikai mavaeua ʻae vaʻe; ʻoku taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Pea ko e hea, koeʻuhi ʻoku ne toe lamu ʻene kai, ka ʻoku ʻikai mavaeua hono pesipesi: ʻoku taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Pea ko e puaka, ʻoku mavahevahe hono pesipesi, pea vaʻe mafahi, ka ʻoku ʻikai fakahake ʻene kai ʻo toe lamu ia; ʻoku taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","‌ʻOua naʻa mou kai honau sino, pe ala ki honau kakano; ʻoku taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ko eni ia temou kai ʻi he ngaahi meʻa ʻoku ʻi he ngaahi vai: ʻilonga ʻaia ʻoku ʻi he vai ʻoku ne maʻu ʻae kaponga, mo e ʻuno, ʻi he tahi mo e ngaahi vaitafe, ko ia te mou kai. ");
INSERT INTO ton_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Pea ko e meʻa ʻi tahi, pea ʻi he ngaahi vaitafe, ʻoku ʻikai maʻu ʻae kaponga mo e ʻuno, ʻi he ngaahi meʻa kotoa pē ʻoku ngaue ʻi he vai, pe ko ha meʻa ʻe taha ʻoku moʻui ʻi he ngaahi vai, ko e meʻa kovi ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","‌ʻIo, ʻe ʻiate kimoutolu ia ko e meʻa fakalielia: ʻoua naʻa mou kai honau sino, pea ko honau kakano ko e meʻa fakalielia ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","‌ʻIlonga ʻaia ʻi he ngaahi vai ʻoku ʻikai hano kaponga pe ʻuno, ke ʻiate kimoutolu ia ko e meʻa fakalielia. ");
INSERT INTO ton_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","¶ Pea ko eni ia ʻi he ngaahi manu kapakau ʻe tapu kiate kimoutolu; ʻe ʻikai temou kai ia, he ko e meʻa fakalielia ia kiate kimoutolu: ko e ʻikale, mo e ʻosifalesi, mo e ʻosipale, ");
INSERT INTO ton_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Mo e volita, mo e kaite ʻi hona faʻahinga. ");
INSERT INTO ton_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","‌ʻAe leveni kotoa pē ʻi honau faʻahinga, ");
INSERT INTO ton_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Mo e ʻositalesi, mo e taiseni ʻoe poʻuli, mo e koku, mo e taiseni ʻi hono faʻahinga, ");
INSERT INTO ton_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Mo e lulu iiki, mo e komolaniti, mo e lulu lahi, ");
INSERT INTO ton_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Mo e suani, mo e lofa, mo e Lahami, ");
INSERT INTO ton_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Mo e sitoaka, mo e motuku ʻi hono faʻahinga, mo e lapiuingi, mo e peka. ");
INSERT INTO ton_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Ko e ngaahi manu kapakau ʻoku totolo, ʻo ʻalu ʻi honau vaʻe, ko e meʻa fakalielia ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ka ko e ngaahi meʻa ni temou kai ʻi he ngaahi meʻa puna ʻoku totolo, ʻo ʻalu ʻi hono vaʻe, ʻaia ʻoku maʻu ʻae vaʻe ʻi ʻolunga ʻi honau vaʻe, ke hopo ʻaki ʻi he kelekele; ");
INSERT INTO ton_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","‌ʻIo, ko eni ia ʻi ai temou kai; ko e heʻe lalahi ʻi honau faʻahinga, ko e solami ʻi honau faʻahinga, mo e kakoli ʻi honau faʻahinga, mo e kakapi ʻi honau faʻahinga: ");
INSERT INTO ton_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ka ko e ngaahi manupuna kotoa pē ʻoku totolo, ʻaia ʻoku veʻe fā: ko e meʻa fakalielia ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Pea temou taʻemaʻa koeʻuhi ko ia he ko ia ʻe ala ki honau ʻangaʻanga ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Pea ko ia ʻe toʻo ha potu ʻo honau sino ʻe fō ʻe ia hono ngaahi kofu, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ko e sino ʻoe manu kotoa pē ʻoku vahe ua hono pesipesi ka ʻoku ʻikai vaʻe mafahifahi, pe toe lamu ʻene kai, ʻoku nau taʻemaʻa kiate kimoutolu: ko ia kotoa pē ʻoku ala ki ai ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Pea ʻilonga ʻaia ʻi he ngaahi manu kotoa pē ʻoku ʻalu ʻi hono ʻaofivaʻe ʻo fakaveʻe fā; ʻoku nau taʻemaʻa kiate kimoutolu: ko ia ʻoku ala ki honau sino ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Pea ko ia ʻoku ne fua honau sino ʻe fō ʻe ia hono ngaahi kofu, pea taʻemaʻa ia ke ʻoua ke efiafi: ʻoku nau taʻemaʻa kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","¶ Ko e ngaahi meʻa ni ʻoku totolo ʻi he kelekele ʻoku taʻemaʻa kiate kimoutolu; ko e uiseli, mo e kumā, mo e fonu papālangi ʻi hono faʻahinga. ");
INSERT INTO ton_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Mo e felite, mo e fokai, mo e moko, mo e sineli, mo e mole. ");
INSERT INTO ton_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ko eni ia ʻoku taʻemaʻa kiate kimoutolu ʻi he meʻa ʻoku totolo; ko ia ʻe ala ki ai ka kuo mate, ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Pea ʻilonga ha meʻa ʻe tō ki ai ha taha ʻiate kinautolu ka kuo mate, ʻe taʻemaʻa ia; pe ko e ipu ʻakau ia, pe ko e kofu, pe ko e kili, pe ko e kato, ha ipu, pe ha meʻa ʻe taha ʻoku fai ʻaki ha ngāue, ʻoku tonu ke tuku ia ki he vai, pea tuku ke taʻemaʻa ia ʻo aʻu ki he efiafi; pea ʻe fakamaʻa ai ia. ");
INSERT INTO ton_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Pea ʻilonga ha ipu ʻumea ʻaia ʻe tō hanau taha ki ai, ko ia ʻoku ʻi ai ʻe taʻemaʻa ia; pea temou foaʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","‌ʻIlonga ʻae meʻakai ʻoku ngofua ke kai, pea kuo tō ki ai ʻae vai ko ia ʻe taʻemaʻa ia; pea ko e meʻainu kotoa pē ʻaia ʻoku ngofua ke inu ʻi he ngaahi ipu pehē, ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Pea ʻilonga ha meʻa ʻe tō ki ai ha konga ʻo honau sino, ʻe taʻemaʻa ia; pe ko e ngotoʻumu, pe ko e hiliʻanga kulo, ʻe maumauʻi ia; he ʻoku nau taʻemaʻa, pea tenau taʻemaʻa kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ka koeʻuhi ko e vai moʻui, pe ha luo ʻoku ʻi ai ʻae vai lahi, ʻe maʻa ia: ka ko ia ʻoku ala ki honau sino ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Pea kapau ʻe tō ha potu ʻo honau sino ki he tengaʻi ʻakau ʻaia ʻoku tuku ki he tō taʻu, ʻe maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pea kapau kuo lingi ha vai ki he ngaahi tenga, pea tō ki ai ha potu ʻo honau sino ki ai, ʻe taʻemaʻa ia kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Pea kapau ʻoku mate mahaki ha manu, ʻaia ʻoku ngofua ke kai: ko ia ʻoku ala ki hono sino, ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Pea ko ia ʻoku ne kai mei hono sino, ʻe fō hono kofu, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi; mo ia foki ʻoku ne fua hono sino ʻo ia, ʻe fō ʻe ia hono kofu, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Pea ko e meʻa totolo kotoa pē ʻoku totolo ki he kelekele ko e meʻa taʻemaʻa ia; ʻe ʻikai kai ia. ");
INSERT INTO ton_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","‌ʻIlonga ʻaia ʻoku ngaolo ki hono kete, mo ia kotoa pē ʻoku ʻalu veʻe fā, mo ia ʻi he ngaahi meʻa totolo ʻi he kelekele ʻoku lahi hono vaʻe, ʻe ʻikai temou kai ia he ʻoku nau taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","‌ʻOua naʻa mou fakalieliaʻi ʻakimoutolu ʻaki ha meʻa ʻe taha ʻoku totolo; pea ʻoua naʻa fakaʻuliʻi ʻakimoutolu ʻi ai, koeʻuhi ke mou taʻemaʻa ai. ");
INSERT INTO ton_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","He ko au ko Sihova ko homou ʻOtua: ko ia temou fakamāʻoniʻoniʻi ʻakimoutolu, pea temou māʻoniʻoni; he ʻoku ou māʻoniʻoni: pea ʻoua naʻa mou ʻuliʻi ʻakimoutolu ʻaki ha meʻa totolo ʻe taha ʻoku totolo ʻi he funga kelekele. ");
INSERT INTO ton_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","He ko au Sihova ʻoku ou ʻomi ʻakimoutolu mei he fonua ko ʻIsipite, ke hoko ko homou ʻOtua: ko ia temou māʻoniʻoni ai, he ʻoku ou māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Ko eni ʻae fono ki he ngaahi manu lahi, pea ki he fanga manu kapakau, pea ki he meʻa moʻui kotoa pē ʻoku ngaue ʻi he ngaahi vai, mo e ngaahi meʻa totolo kotoa pē ʻi he funga kelekele. ");
INSERT INTO ton_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ke fai kehekehe ki he meʻa taʻemaʻa mo e meʻa maʻa, pea ki he manu ʻoku ngofua ke kai mo e manu ʻoku ʻikai ngofua ke kai. ");
INSERT INTO ton_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, Kapau ʻoku feitama ha fefine, pea fāʻeleʻi ʻae tama tangata: pea ʻe taʻemaʻa ia ʻi he ʻaho ʻe fitu; ʻe taʻemaʻa ia ʻo fakatatau ki he ngaahi ʻaho fakamavahe ʻi hono mahaki. ");
INSERT INTO ton_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Pea ʻi hono valu ʻoe ʻaho ʻe kamu ʻae muʻa kili ʻo hono potuʻoe tama tangata. ");
INSERT INTO ton_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Pea ʻe nofo pēʻae fefine ʻi he toto ʻo hono fakamaʻa ʻi he ʻaho ʻe tolungofulu ma tolu; ʻe ʻikai te ne ala ki ha meʻa tapu, pe hū ki he faletapu, kaeʻoua ke kakato ʻae ngaahi ʻaho ʻo hono fakamaʻa. ");
INSERT INTO ton_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Pea kapau te ne fāʻeleʻi ha taʻahine, ʻe taʻemaʻa ai ia ʻi he uike ʻe ua, ʻo hangē ko hono mavahe: pea te ne nofo ʻi he ʻaho ʻe onongofulu ma ono koeʻuhi ko e toto mo hono fakamaʻa. ");
INSERT INTO ton_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Pea ka kakato ʻae ngaahi ʻaho ʻo hono fakamaʻa, koeʻuhi ko e tama, pe ko e taʻahine, te ne ʻomi ʻe ia ha lami ʻoe ʻuluaki taʻu ki he feilaulau tutu, mo e lupe mui, pe ha kulukulu, ko e feilaulau maʻae angahala, ki he taulaʻeiki ʻi he matapā ʻoe fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","‌ʻAia te ne ʻatu ia ʻi he ʻao ʻo Sihova, ʻo ne fai ʻae fakalelei maʻana; pea ʻe fakamaʻa ai ia mei he ʻau ʻo hono toto. Ko eni ʻae fono kiate ia kuo ne fāʻeleʻi ʻae tama pe ko e taʻahine. ");
INSERT INTO ton_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Pea kapau ʻoku ʻikai faʻa ʻomi ʻe ia ha lami, te ne toki ʻomi ʻe ia ha kulukulu ʻe ua, pe ko e lupe mui ʻe ua; ko e taha ki he feilaulau tutu, pea ko e taha ki he feilaulau maʻae angahala: pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana, pea ʻe maʻa ai ia. ");
INSERT INTO ton_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","‌ʻOka tupu ʻi ha tangata ʻi he kili ʻo hono sino ha meʻa pupula, ha mongumangu, pe ha ʻila ngingila, pea ʻoku ʻi he kili ʻo hono sino ia ʻo hangē ko e mahaki ko e kilia; ʻe ʻomi ai ia ki he taulaʻeiki ko ʻElone, pe ki ha tokotaha ʻo hono ngaahi foha ʻoku taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Pea ʻe sio ʻae taulaʻeiki ki he mahaki ʻi he kili ʻoe sino: pea kapau kuo liliu ʻo hinehina ʻae fulufulu ʻi he hangatāmaki, pea ʻoku aʻu hifo ki lalo ʻi he kili ʻo hono sino ʻae mahaki, ko e mahaki ia ko e kilia: pea ʻe vakai kiate ia ʻe he taulaʻeiki, ʻo ne fakahā ko e taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kapau ʻoku hinehina ʻae ʻila ngingila ʻi he kili ʻoe sino, pea hā ia ka ʻoku ʻikai ʻi lalo ʻi he kili, pea ʻoku teʻeki liliu ʻo hinehina ʻae fulufulu ʻi ai; ʻe toki tuku ia ʻoku mahaki ʻe he taulaʻeiki ke nofomaʻu ki fale ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Pea ʻe mamata kiate ia ʻae taulaʻeiki ʻi hono fitu ʻoe ʻaho: pea vakai, kapau ʻoku ne sio ʻoku pehē pe ʻae mahaki, ka ʻoku teʻeki tupu ʻo mafola ʻi he kili: ʻe toe tuku ia ʻe he taulaʻeiki ki ha fale tāpuni ke ʻaho fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Pea ʻe toe mamata kiate ia ʻe he taulaʻeiki ʻi hono fitu ʻoe ʻaho: pea vakai kapau ʻoku mata ʻuliʻuli ʻae hangatāmaki, pea ʻoku ʻikai tupu ke mafola atu ʻi he kili, ʻe fakahā ia ʻe he taulaʻeiki ʻoku maʻa: ko e mongumangu pe ia: pea ʻe fō ʻe ia ʻa hono ngaahi kofu ʻo maʻa ai. ");
INSERT INTO ton_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pea kapau ʻe totolo atu ʻo lahi ʻae mongumangu ʻi he kili, hili hono mamata kiate ia ʻe he taulaʻeiki ʻi hono fakamaʻa, ʻe toe mamata ʻae taulaʻeiki kiate ia: ");
INSERT INTO ton_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Pea kapau ʻoku mamata ʻae taulaʻeiki, pea vakai, ʻoku tupu ʻo totolo atu pe ʻae mongumangu ʻi he kili, ʻe toki fakahā ia ʻe he taulaʻeiki ko e taʻemaʻa: ko e kilia ia. ");
INSERT INTO ton_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","¶ ʻOka hoko ki he tangata ʻae mahaki ko e kilia, ʻe ʻomi ai ia ki he taulaʻeiki; ");
INSERT INTO ton_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Pea ʻe mamata ʻae taulaʻeiki kiate ia: pea vakai, kapau ʻoku hinehina ʻae meʻa kuo tupu hake ʻi he kili, pea kuo ne liliu ʻae fulufulu ke hinehina, pea ʻoku tuʻu ʻi he hangatāmaki ʻae mataʻi kakano ʻoku kalakalaʻia, ");
INSERT INTO ton_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Ko e kilia fuoloa ia ʻi he kili ʻoe kakano, pea ʻe fakahā ia ʻe he taulaʻeiki ko e taʻemaʻa, pea ʻe ʻikai tāpuni ia ki fale: he ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Pea kapau ʻe tupu ʻo lahi ha kilia ʻituʻa ʻi he kili, pea tupu ʻae kilia ʻo ne ʻufiʻufi ʻae kili kotoa pē ʻo ia ʻoku mahaki, mei hono ʻulu ʻo aʻu ki he vaʻe, ʻi he potu kotoa pē ʻoku sio ki ai ʻae taulaʻeiki; ");
INSERT INTO ton_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Pehē ʻe fifili ki ai ʻae taulaʻeiki: pea vakai, kapau kuo ʻufiʻufi ʻe he kilia ʻae sino kotoa, te ne fakahā ʻoku maʻa ia ʻaia ʻoku mahaki: kuo liliu ia ʻo hinehina kotoa pē: ʻoku maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ka ʻoka hā ʻae kanomate kalakalaʻia ʻiate ia ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Pea ʻe mamata ʻae taulaʻeiki ki he kanomate kalakalaʻia, ʻo ne fakahā ʻoku taʻemaʻa ia: he ko e kanomate kalakalaʻia ʻoku taʻemaʻa ia: ko e kilia ia. ");
INSERT INTO ton_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Pea kapau ʻe toe liliu ʻae kanomate kalakalaʻia pea toe liliu ia ʻo hinehina, ʻe toe haʻu ia ki he taulaʻeiki; ");
INSERT INTO ton_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Pea ʻe mamata kiate ia ʻae taulaʻeiki, pea vakai, kapau kuo liliu ʻae mahaki ʻo hinehina; pea ʻe toki fakahā ʻe he taulaʻeiki ʻoku maʻa ia ʻaia ʻoku mahaki: ʻoku maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","¶ Pea ko e sino foki ʻaia naʻe ʻi ai ʻi hono kili ʻae vakafoha, pea kuo moʻui, ");
INSERT INTO ton_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Pea ʻi he potu naʻe ʻi ai ʻae vakafoha ʻoku tupu ai ʻae meʻa hinehina, pe ko e ʻila ngingila, ʻoku hinehina, pea mata fakakulokula, pea ʻoku fakahā ia ki he taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Pea ʻoka mamata ki ai ʻae taulaʻeiki, pea kapau ʻoku hā ia ʻo māʻulalo ʻi he kili, pea liliu ʻo hinehina ʻae ngaahi fulufulu ʻi ai ʻe fakahā ia ʻe he taulaʻeiki ko e taʻemaʻa ko e mahaki ia ko e kilia, kuo tupu mei he vakafoha. ");
INSERT INTO ton_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pea kapau ʻoku mamata ki ai ʻae taulaʻeiki, pea vakai, ʻoku ʻikai ha fulufulu hinehina ʻi ai, pea kapau ʻoku ʻikai ʻi lalo ia ʻi he kili, ka ʻoku mata ʻuliʻuli: pea ʻe toki tuku ia ki ha fale tāpuni ʻe he taulaʻeiki ʻi he ʻaho fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Pea kapau ʻe totolo lahi ʻi he kili, ʻe fakahā ia ʻe he taulaʻeiki ko e taʻemaʻa ko e mahaki ia. ");
INSERT INTO ton_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pea kapau ʻoku tuʻu pehē ai pe ʻae ʻila ngingila, pea ʻikai totolo atu, ko e vakafoha kalakalaʻia ia; pea ʻe fakahā ia ʻe he taulaʻeiki ko e maʻa. ");
INSERT INTO ton_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","¶ Pea kapau ʻe ai ha kakano ʻi he kili ʻoku vela lahi, pea tuʻu ʻi he kanomate ʻoku vela ʻae ʻila hinehina ngingila, ʻoku mata fakakulokula, pe hinehina; ");
INSERT INTO ton_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","‌ʻE toki sio ki ai ʻae taulaʻeiki: pea vakai, kapau kuo liliu ʻo hinehina ʻae fulufulu ʻi he ʻila ngingila, pea hā ʻi lalo ʻi he kili; ko e kilia ia kuo tupu mei he meʻa kalakala: ko ia, ʻe fakahā ia ʻe he taulaʻeiki ko e taʻemaʻa: ko e mahaki ia ko e kilia. ");
INSERT INTO ton_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pea kapau ʻoku mamata ki ai ʻe he taulaʻeiki, pea vakai, ʻoku ʻikai ha fulufulu hinehina ʻi he ʻila ngingila, pea ʻoku ʻikai ʻi lalo ʻi he kili, ka ʻoku matamata ʻuliʻuli siʻi ia; ʻe toki tāpuni ia ʻe he taulaʻeiki ki fale ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pea ʻe mamata kiate ia ʻae taulaʻeiki ʻi hono fitu ʻoe ʻaho: pea kapau kuo totolo lahi atu ia ʻi he kili, ʻe fakahā ia ʻe he taulaʻeiki ʻoku taʻemaʻa: ko e mahaki ko e kilia. ");
INSERT INTO ton_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pea kapau ʻoku tuʻu ʻi he potu pe taha ʻae ʻila ngingila ka ʻoku ʻikai totolo atu ʻi he kili, ka ʻoku matamata ʻuliʻuli ia: ko e meʻa tupu pe ia ʻi heʻene kalakala, pea ʻe fakahā ia ʻe he taulaʻeiki ʻoku maʻa: he ko e hangatāmaki ia ʻi heʻene kalakalaʻia. ");
INSERT INTO ton_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","¶ Kapau ʻoku tupu ʻi ha tangata pe ʻi ha fefine ʻae mahaki ʻi he ʻulu pe ʻi he kava; ");
INSERT INTO ton_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","‌ʻE mamata ai ʻe he taulaʻeiki ki he mahaki: pea vakai, kapau ʻoku hā mai ia ki lalo ʻi he kili; pea ʻoku ʻi ai ha tuʻoni fulufulu melomelo fuoiiki; ʻe toki fakahā ʻe he taulaʻeiki ʻoku taʻemaʻa ia: ko e kamaa mōmoa ia, ʻio, ko e kilia ʻoe ʻulu pe ʻoe kava. ");
INSERT INTO ton_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Pea kapau ʻoku mamata ʻe he taulaʻeiki ki he mahaki ko e kamaa, pea vakai, ʻoku ʻikai hā mai ia ʻi lalo ʻi he kili, pea ʻoku ʻikai ʻi ai ha fulufulu ʻuliʻuli; ʻe toki tāpuniki fale ʻe he taulaʻeiki ʻaia ʻoku mahaki ʻi he kamaa ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Pea ʻe mamata ʻe he taulaʻeiki ʻi hono fitu ʻoe ʻaho ki he mahaki: pea vakai, kapau ʻoku ʻikai totolo atu ʻae kama, pea ʻoku ʻikai ʻi ai ha fulufulu melomelo, pea ʻoku ʻikai matamata ʻi lalo ʻi he kili ʻae kama. ");
INSERT INTO ton_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","‌ʻE fafai ia ka ʻe ʻikai fafai ʻae kamaa pea ʻe toe tāpuniki fale ʻa ia ʻoku kamaa ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Pea ʻe mamata ʻae taulaʻeiki ki he kamaa ʻi hono fitu ʻoe ʻaho: pea vakai, kapau ʻoku ʻikai totolo ʻae kamaa ʻi he kili, pea ʻikai hā ʻi lalo ʻi he kili; ʻe toki fakahā ʻe he taulaʻeiki ʻoku maʻa ia: pea ke fō ʻe ia hono ngaahi kofu, pea ʻe maʻa ai ia. ");
INSERT INTO ton_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pea kapau ʻoku totolo lahi ʻae kamaa ʻi he kili ʻoka hili hono fakamaʻa: ");
INSERT INTO ton_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Pea ʻe mamata kiate ia ʻae taulaʻeiki pea vakai, kapau kuo totolo ʻae kamaa, ʻi he kili, ʻoua naʻa kumi ʻe he taulaʻeiki ki he fulufulu melomelo; ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pea kapau ʻoku hā mai ʻae kamaa ʻoku pehē ai pe, pea kuo tupu ʻi ai ʻae fulufulu ʻuliʻuli; kuo moʻui ʻae kamaa, ʻoku maʻa ia: pea ʻe fakahā ia ʻe he taulaʻeiki ʻoku maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","¶ Kapau ʻoku ʻi ha tangata pe ko e fefine ʻae ngaahi ʻila ngingila ʻi he kili ʻo honau sino, ʻio, ʻae ngaahi ʻila hinehina ʻoku ngingila; ");
INSERT INTO ton_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Pea ʻe mamata ai ʻae taulaʻeiki pea vakai, kapau ʻoku hinehina ʻuliʻuli ʻae ngaahi ʻila ʻi hona sino; ko e ʻila ia ʻoku tupu ʻi hona sino; ʻoku maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Pea ko e tangata kuo mokulu hono louʻulu, kuo tula ia; ka ʻoku ne maʻa pe: ");
INSERT INTO ton_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Pea ko ia kuo mokulu hono louʻulu mei hono muʻa laʻē ki ʻao, ko e tula muʻa laʻē ia; ka ʻoku ne maʻa. ");
INSERT INTO ton_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pea kapau ʻoku ʻi he ʻulu tula pe ʻi he muʻa laʻē tula ha meʻa pupula ʻoku hinehina kulokula; ko e kilia ia kuo tupu ʻi hono ʻulu tula pe ʻi hono muʻa laʻē tula. ");
INSERT INTO ton_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Pea ʻe mamata ki ai ʻae taulaʻeiki pea vakai, kapau ʻoku hinehina kulokula ʻae meʻa kuo tupu ʻi hono ʻulu tula, pe ki hono muʻa laʻē tula, pea hā ia ʻo hangē ko e kilia ʻi he kili ʻoe sino: ");
INSERT INTO ton_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Ko e tangata kilia ia, ʻoku taʻemaʻa ia; ʻe fakahā ia ʻe he taulaʻeiki ʻoku taʻemaʻa ʻaupito ia; ʻoku ʻi hono ʻulu ʻa hono mahaki. ");
INSERT INTO ton_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Pea ko e kilia ʻaia ʻoku ʻiate ia ʻae mahaki, ʻe haehae hono ngaahi kofu, pea ʻe tekefua hono ʻulu, pea ʻe ʻai ʻe ia ha meʻa ʻufiʻufi ki hono loungutu ʻi ʻolunga, pea ʻe kalanga ia, “Taʻemaʻa, taʻemaʻa.” ");
INSERT INTO ton_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","‌ʻE taʻemaʻa ia ʻi he ngaahi ʻaho kotoa pē ʻo hono mahaki; ʻoku taʻemaʻa ia: ʻe nofo tokotaha ia; ʻe tuʻu ʻa hono nofoʻanga ʻi tuaʻā ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","¶ Ko e kofu foki ʻoku ʻi ai ʻae mahaki ko e kilia, pe ko ha kofu sipi ia, pe ko e kofu tupenu tuʻovalevale; ");
INSERT INTO ton_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","‌ʻI hono lalanga fakamāukupu pe ʻi he lōloa: ʻi he tupenu, pe ʻi he kofu fulufuluʻi sipi; ko e meʻa ʻi ha kiliʻi manu, pe ʻi ha meʻa kuo ngaohi ʻaki ʻae kiliʻi manu; ");
INSERT INTO ton_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Pea kapau ʻoku hangē ko e lanu ʻakau mata ʻae mahaki, pe kulokula ʻi he kofu, pe ʻi he kiliʻi manu, ʻi hono lalanga fakamāukupu pe ʻi hono lōloa, pe ʻi ha meʻa ʻe taha he kiliʻi manu; ko e mahaki ia ko e kilia, pea ʻe fakahā ia ki he taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Pea ʻe mamata ʻae taulaʻeiki ki he mahaki, pea ʻe tāpuni ki fale ʻaia ʻoku mahaki ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Pea ʻe mamata ʻe ia ki he mahaki ʻi hono fitu ʻoe ʻaho: pea kapau kuo totolo ʻae mahaki ʻi he kofu, ʻi hono lalanga fakamāukupu pe ʻi hono lōloa, pe ʻi ha kiliʻi manu, pe ʻi ha meʻa ʻe taha kuo ngaohi ʻaki ʻae kiliʻi manu; ko e kilia fakamamahi ia: ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","‌ʻE tutu ʻe ia ʻae kofu ko ia ʻaia ʻoku ʻi ai ʻae kilia, ʻi hono māukupu pe ʻi hono lōloa, ʻi he kofu sipi, pe ʻi he tupenu, pe ʻi ha kiliʻi manu, he ko e kilia fakamamahi ia; ʻe tutu ia ʻi he afi. ");
INSERT INTO ton_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pea kapau ʻoku mamata ʻae taulaʻeiki, pea vakai, ʻoku ʻikai tupu ʻae mahaki ʻi he kofu, ʻi hono māukupu, pe ʻi hono lōloa, pe ʻi ha kiliʻi manu ʻe taha; ");
INSERT INTO ton_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","‌ʻE toki fekau ʻe he taulaʻeiki kenau fō ʻae meʻa ʻoku ʻi ai ʻae mahaki, pea ke tuku tāpuni ia ke toe ʻaho fitu: ");
INSERT INTO ton_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Pea ʻe mamata ʻae taulaʻeiki ki he mahaki, hili hono fō ia: pea vakai, kapau kuo ʻikai liliu ʻo mata kehe ʻae mahaki, pea ʻoku ʻikai totolo atu ʻae mahaki; ʻoku taʻemaʻa ia; ke ke tutu ia ʻi he afi; he kuo kai ia ʻi loto kuo molemole ia ʻi loto mo tuʻa. ");
INSERT INTO ton_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pea kapau ʻoku mamata ʻae taulaʻeiki, pea vakai, ʻoku mata ʻuliʻuli ʻae mahaki hili hono fō; pea ʻe hae ia mei he kofu, pe mei he kiliʻi manu, pe mei hono lōloa pe mei hono māukupu ʻoe kofu. ");
INSERT INTO ton_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Pea kapau ʻoku kei hā ia ʻi he kofu, ʻi hono lōloa, pe ʻi he māukupu, pe ʻi ha kiliʻi manu ʻe taha: pehē ʻe toki tutu ʻaia ʻoku ʻi ai ʻae mahaki. ");
INSERT INTO ton_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pea ko e kofu, pe ko e lōloa pe māukupu, pe ko e kiliʻi manu ʻaia ʻoku ke fō, kapau ʻoku mahuʻi mei ai ʻae mahaki, pea ʻe toe fō ia ke liunga ua, pea ʻe maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Ko eni ʻae fono ki he mahaki ko e kilia ʻi he kofu sipi pe ko e tupenu, ʻi hono lōloa pe ʻi hono māukupu, pe ha kiliʻi manu ʻe taha, ke fakahā ai hono maʻa, pe fakahā ʻa hono taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ko eni ʻae fono ki he kilia ʻi he ʻaho ʻo hono fakamaʻa: ʻE ʻomi ia ki he taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Pea ʻe ʻalu ʻae taulaʻeiki kituaʻā ʻi he ʻapitanga; pea ʻe mamata ʻae taulaʻeiki, pea vakai, pe kuo moʻui ʻae mahaki ko e kilia ʻi he kilia; ");
INSERT INTO ton_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Pea ʻe toki fekau ʻe he taulaʻeiki ke toʻo maʻana ʻe ia ʻoku te u fakamaʻa, ʻae manu siʻi ʻe ua ʻoku moʻui mo maʻa, mo e ʻakau ko e sita, mo e kulaʻahoʻaho, mo e ʻisope: ");
INSERT INTO ton_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Pea ʻe fekau ʻe he taulaʻeiki ke tāmateʻi ʻae manu ʻe taha ʻi ha ipu ʻumea ʻi ʻolunga ʻi he vaitafe. ");
INSERT INTO ton_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Pea ko e manu moʻui, ʻe toʻo ʻe ia ia, mo e ʻakau ko e sita, mo e kulaʻahoʻaho, mo e ʻisope, pea ʻe unu ia mo e manu moʻui ki he toto ʻoe manu naʻe tāmateʻi ʻi ʻolunga ʻi he vaitafe, ");
INSERT INTO ton_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Pea te ne luluku ʻaki ia ʻaia ʻoku fakamaʻa mei he kilia, ke liunga fitu, pea fakahā ʻoku maʻa ia, pea ʻe tukuange ʻae manu moʻui ke ʻalu ki he ʻataʻatā ʻoe fonua. ");
INSERT INTO ton_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Pea ʻe fō ʻe ia ʻoku te u fakamaʻa ʻa hono ngaahi kofu, pea ʻe tekefua ia pea kaukau ia ʻi he vai, koeʻuhi ke maʻa ai ia: pea hili ia, ʻe haʻu ia ki he ʻapitanga, pea toe tatali mamaʻo mei hono fale fehikitaki ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Pea ka hokosia ʻa hono fitu ʻoe ʻaho, ʻe tele ʻe ia ʻae louʻulu mei hono ʻulu kotoa mo hono kava, mo hono tuotua mata, ʻio, ʻe tele hono fulufulu kotoa pē: pea ʻe fō ʻe ia hono ngaahi kofu, pea kaukau mo hono sino ʻi he vai, pea ʻe maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Pea ʻi hono valu ʻoe ʻaho te ne toʻo ʻe ia ha lami tangata ʻe ua taʻehaʻana-mele, mo e lami fefine ʻe taha ʻoe ʻuluaki taʻu taʻehanomele, mo e oma ʻe tolu ʻoe mahoaʻa lelei ko e feilaulau meʻakai, kuo fefiofi mo e lolo, mo e lolo ko e fua siʻi ʻe taha. ");
INSERT INTO ton_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Pea ko e taulaʻeiki ʻoku ne fakamaʻa ia, ʻe ʻatu ʻe ia ʻae tangata ʻoku teu ke fakamaʻa mo e ngaahi meʻa ni, ʻi he ʻao ʻo Sihova, ʻi he matapā ʻoe fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Pea ʻe toʻo ʻe he taulaʻeiki ʻae lami tangata ʻe taha, ʻo ʻatu ia ko e feilaulau maʻae angahala, mo e fua siʻi ʻoe lolo, pea taʻaloʻalo ʻaki ia ko e feilaulau taʻaloʻalo ia kia Sihova: ");
INSERT INTO ton_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Pea te ne tāmateʻi ʻae lami ʻi he potu ʻaia ʻoku ne tāmateʻi ai ʻae feilaulau maʻae angahala mo e feilaulau tutu, ʻi he potu māʻoniʻoni: he ʻoku hangē ʻoku ʻoe taulaʻeiki ʻae feilaulau maʻae angahala, pea ʻoku pehē pe foki ʻae feilaulau maʻae fai hala: ko e meʻa māʻoniʻoni lahi ia: ");
INSERT INTO ton_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Pea ʻe toʻo ʻe he taulaʻeiki ʻae toto ʻoe feilaulau maʻae fai hala, pea ʻe ʻai ia ʻe he taulaʻeiki ki he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo ia ʻoku fakamaʻa, pea ki he motuʻa nima ʻo hono nima toʻomataʻu, pea ki he motuʻa vaʻe ʻoe vaʻe toʻomataʻu: ");
INSERT INTO ton_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Pea ʻe toʻo ʻe he taulaʻeiki ʻae lolo mei he fua siʻi ʻoe lolo, ʻo lingi ia ki he ʻaofi nima ʻo hono nima toʻohema ʻoʻona: ");
INSERT INTO ton_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Pea ʻe ʻai ʻe he taulaʻeiki ʻae tuhu ʻo hono nima toʻomataʻu ki he lolo ʻoku ʻi hono nima toʻohema, pea ʻe luluku ʻae lolo ʻaki hono tuhu ke liunga fitu ʻi he ʻao ʻo Sihova: ");
INSERT INTO ton_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Pea ʻe ʻai ʻe he taulaʻeiki, mei he toe ʻoe lolo ʻoku ʻi hono nima, ki he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo ia ʻoku fakamaʻa, pea ki he motuʻa nima ʻo hono nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo hono vaʻe toʻomataʻu, pea ki he toto ʻoe feilaulau maʻae fai hala: ");
INSERT INTO ton_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Pea ko hono toe ʻoe lolo ʻoku ʻi he nima ʻoe taulaʻeiki ʻe lingi ia ki he ʻulu ʻo ia ʻoku fakamaʻa: pea ʻe fai ʻae fakalelei maʻana ʻe he taulaʻeiki ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Pea ʻe ʻatu ʻe he taulaʻeiki ʻae feilaulau maʻae angahala, ʻo fai ʻae fakalelei maʻana ʻaia ʻoku te u fakamaʻa taʻemaʻa: pea hili ia ʻe tāmateʻi ʻe ia ʻae feilaulau tutu: ");
INSERT INTO ton_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Pea ʻe ʻatu ʻe he taulaʻeiki ʻae feilaulau tutu mo e feilaulau meʻakai ʻi he feilaulauʻanga: pea ʻe fai ʻae fakalelei maʻana ʻe he taulaʻeiki, pea ʻe maʻa ai ia. ");
INSERT INTO ton_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Pea kapau ʻoku masiva ia, pea ʻe ʻikai faʻa maʻu ʻe ia ha meʻa lahi pehē: ʻe toki toʻo ʻe ia ha lami ʻe taha pe ki he feilaulau maʻae fai hala, ke taʻaloʻalo ʻaki, ke fai ʻae fakalelei maʻana, mo e oma ʻe taha ʻoe mahoaʻa lelei kuo felingiʻaki ʻae lolo, ko e feilaulau meʻakai, mo e fua siʻi ʻe taha ʻoe lolo; ");
INSERT INTO ton_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Mo e kulukulu ʻe ua, pe ko e lupe mui ʻe ua, ʻo hangē ko ʻene faʻa maʻu; pea ko e feilaulau maʻae angahala ʻae taha, pea ko e taha ko e feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Pea te ne ʻomi ia ki he taulaʻeiki ʻi hono valu ʻoe ʻaho ʻo hono fakamaʻa, ki he matapā ʻoe fale fehikitaki ʻoe kakai ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Pea ʻe toʻo ʻe he taulaʻeiki ʻae lami ki he feilaulau maʻae fai hala, mo e fua siʻi ʻoe lolo, pea ʻe taʻaloʻalo ʻaki ia ʻe he taulaʻeiki ko e feilaulau taʻaloʻalo kia Sihova: ");
INSERT INTO ton_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Pea ʻe tāmateʻi ʻe ia ʻae lami ki he feilaulau maʻae fai hala, pea ʻe toʻo ʻe he taulaʻeiki ʻae toto ʻoe feilaulau maʻae fai hala, ʻo ʻai ia ki he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo ia ʻoku fakamaʻa, pea ki he motuʻa nima ʻo hono nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo hono vaʻe toʻomataʻu: ");
INSERT INTO ton_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Pea ʻe lingi ʻe he taulaʻeiki ʻae lolo ki hono ʻaofinima toʻohema ʻoʻona: ");
INSERT INTO ton_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Pea ʻe luluku ʻaki hono tuhu toʻomataʻu ʻe he taulaʻeiki ʻae toto ʻoku ʻi hono nima toʻohema ke liunga fitu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Pea ʻe ʻai ʻe he taulaʻeiki ʻae lolo ʻoku ʻi hono nima ki he potu ʻi ʻolunga ʻoe telinga toʻomataʻu ʻo ia ʻoku fakamaʻa, pea ki he motuʻa nima ʻo hono nima toʻomataʻu, pea ki he motuʻa vaʻe ʻo hono vaʻe toʻomataʻu, ʻi he potu ʻoe toto ʻoe feilaulau maʻae fai hala: ");
INSERT INTO ton_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Pea ko hono toe ʻoe lolo ʻoku ʻi he nima ʻoe taulaʻeiki ʻe lingi ʻe ia ia ki he ʻulu ʻo ia ʻoku fakamaʻa, ke fai ʻae fakalelei maʻana ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Pea te ne ʻatu ʻe ia ha kulukulu ʻe taha, pe ha lupe mui, ʻo tatau mo ʻene faʻa maʻu; ");
INSERT INTO ton_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ko ia ʻoku ne faʻa maʻu, ko e taha ko e feilaulau maʻae angahala. Ko e taha ki he feilaulau tutu, mo e feilaulau meʻakai: pea ʻe fai ʻae fakalelei ʻe he taulaʻeiki maʻana, ʻaia ʻoku fai ke fakamaʻa ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ko eni ʻae fono kiate ia ʻoku ʻi ai ʻae mahaki ko e kilia, pea ʻoku ʻikai mafai ʻe hono nima ke maʻu ʻaia ʻoku kau ki hono fakamaʻa. ");
INSERT INTO ton_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","‌ʻOka mou ka hoko atu ki he fonua ko Kēnani, ʻaia ʻoku ou foaki kiate kimoutolu ke mou maʻu, peau ʻai ʻae mahaki ko e kilia ki ha fale ʻi homou fonua: ");
INSERT INTO ton_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Pea ka haʻu ia ʻoku ʻoʻona ʻae fale ʻo tala ki he taulaʻeiki, ʻo pehē, ʻOku hā kiate au ʻo hangē ʻoku ai ʻae mahaki ko e kilia ʻi he fale: ");
INSERT INTO ton_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","‌ʻE toki fekau leva ʻe he taulaʻeiki kenau fetuku ʻae meʻa kotoa pē mei he fale ʻi he teʻeki hū ki ai ʻae taulaʻeiki ke mamata ki he mahaki, telia naʻa hoko ʻo taʻemaʻa ʻaia kotoa pē ʻoku ʻi he fale: pea ʻe toki ʻalu ki ai ʻae taulaʻeiki ke mamata ki he fale: ");
INSERT INTO ton_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Pea te ne sio ki he mahaki, pea vakai, kapau ʻoku ʻi he ngaahi holisi ʻoe fale ʻae mahaki kuo matohitohi luoluo, pea lanu louʻakau mata, pe kulokula, ʻaia ʻoku matamata luoluo ʻi hefunga holisi: ");
INSERT INTO ton_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Pea ʻe toki ʻalu kituʻa fale ʻae taulaʻeiki ki he matapā ʻoe fale, pea tāpuni ʻae fale ʻi he ʻaho ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Pea ʻe toe haʻu ʻae taulaʻeiki ʻi hono fitu ʻoe ʻaho, pea mamata: pea vakai, kapau kuo totolo ʻae mahaki ʻi he holisi ʻoe fale; ");
INSERT INTO ton_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","‌ʻE toki fekau ʻe he taulaʻeiki kenau toʻo ʻo ʻave ʻae ngaahi maka ʻoku ʻi ai ʻae mahaki, ʻo lī ia ki he potu taʻemaʻa ʻi tuaʻā ʻi he kolo: ");
INSERT INTO ton_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Pea ʻe fekau ʻe ia ke teletele kotoa ʻae lahe ʻoe loto fale ʻo ʻosi, pea ke nau lilingi ʻae efu ʻoku nau teletele mei ai ki he potu taʻemaʻa ʻi tuaʻā ʻi he kolo: ");
INSERT INTO ton_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Pea tenau toʻo ʻae ngaahi maka kehe ʻo ʻai ke fetongi ʻaki ʻae ngaahi maka ko ia; pea ʻe ʻomi ʻe ia ʻae lahe kehe, ke ʻaofi ʻaki ʻae fale: ");
INSERT INTO ton_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Pea kapau ʻe toe haʻu ʻae mahaki ʻo tupu ʻi he fale, hili ʻa ʻene toʻo ʻo ʻave ʻae ngaahi maka, pea hili ʻa ʻene teletele ʻae fale, pea hili hono toe ʻaofi ia; ");
INSERT INTO ton_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","‌ʻE toki haʻu ʻae taulaʻeiki ʻo mamata, pea vakai, kapau ʻoku tupu ʻo totolo atu ʻae mahaki, ko e kilia tupu kovi ia ʻi he fale: ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Pea ʻe holoki hifo ʻe ia ʻae fale, ʻa hono ngaahi maka, mo e ngaahi ʻakau ʻo ia, mo e lahe kotoa pē ʻoe fale; pea fetuku kotoa pē ia kituaʻā ʻi he kolo ki ha potu taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Pea ʻilonga ʻaia ʻe hū ki he fale ʻi he lolotonga ʻa hono tāpuni ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Pea ko ia ʻe mohe ʻi he fale ʻe fō ʻe ia hono ngaahi kofu; pea ko ia ʻoku kai ʻi he fale ʻe fō ʻe ia hono kofu. ");
INSERT INTO ton_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Pea kapau ʻe haʻu ʻae taulaʻeiki, ʻo mamata ki ai, hili hono ʻaofi ʻae fale, pea vakai, ʻoku teʻeki totolo ʻae mahaki: pea ʻe toki fakahā ʻe he taulaʻeiki ʻoku maʻa ʻae fale, koeʻuhi kuo mahuʻi ʻae mahaki. ");
INSERT INTO ton_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pea te ne toʻo ʻe ia ke fakamaʻa ʻae fale ʻae ʻuhikiʻi manupuna ʻe ua, mo e ʻakau ko e sita, mo e kulaʻahoʻaho, mo e ʻisope; ");
INSERT INTO ton_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Pea te ne tāmateʻi ʻae manupuna ʻe taha ʻi he ipu ʻumea ʻi ʻolunga ʻi ha vai ʻoku tafe. ");
INSERT INTO ton_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Pea ʻe toʻo ʻe ia ʻae ʻakau ko e sita, mo e ʻisope, mo e kulaʻahoʻaho, mo e manupuna moʻui, ʻo unu ia ʻi he toto ʻoe manu kuo tāmateʻi, pea ki he vai ʻoku tafe, pea ʻe luluku ʻaki ia ʻae fale ke liunga fitu: ");
INSERT INTO ton_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Pea te ne fakamaʻa ʻae fale ʻaki ʻae toto ʻoe manu, mo e vai ʻoku tafe, pea mo e manu moʻui, mo e ʻakau ko e sita, pea mo e ʻisope, pea mo e kulaʻahoʻaho: ");
INSERT INTO ton_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Ka ʻe tukuange ʻe ia ʻae manupuna moʻui mei he kolo ki he ʻataʻatā ʻoe fonua, pea fai ʻae fakalelei maʻae fale: pea ʻe maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ko eni ʻae fono ki he mahaki kehekehe ʻoe kilia, mo e kamaa, ");
INSERT INTO ton_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Pea ki he kilia ʻoe kofu, pea mo e fale, ");
INSERT INTO ton_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Pea ki he hangatāmaki pupula, pea ki he mongumangu, pea ki he ʻila ngingila; ");
INSERT INTO ton_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ke fakahā ʻene taʻemaʻa mo ʻene maʻa; ko eni ʻae fono ʻoe kilia. ");
INSERT INTO ton_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo pehē kiate kinautolu, ʻOka mahaki ʻae tangata ʻi he ʻau ʻa hono sino, ko ʻene ʻau ko ia ʻoku taʻemaʻa ai ia. ");
INSERT INTO ton_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Pea ko hono taʻemaʻa eni ʻo ʻene ʻau; pe kuo ʻau hono sino ʻi heʻene mahaki, pē kuo matuʻu mei hono sino; ko ʻene taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Ko e mohenga kotoa pē ʻoku mohe ai ʻaia ʻoku ʻiate ia ʻae ʻau, ʻoku taʻemaʻa ia; pea ko e meʻa kotoa pē ʻoku nofo ai ia, ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Pea ko ia ʻe ala ki hono mohenga ʻe fō ʻe ia hono kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Pea ko ia ʻoku nofo ʻi ha meʻa naʻe nofo ai ʻaia ʻoku ʻiate ia ʻae ʻau, ʻe fō ʻe ia hono kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia, ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Pea ko ia ʻoku lave ki he sino ʻo ia ʻoku ʻiate ia ʻae ʻau, ʻe fō ʻe ia hono kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Pea kapau ʻe ʻaʻanu ʻaia ʻoku ʻiate ia ʻae ʻau kiate ia ʻoku maʻa; pea ʻe fō ʻe ia hono kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Pea ʻilonga ha meʻa hekaʻanga ʻoku heka ai ʻaia ʻoku ʻiate ia ʻae ʻau ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Pea ko ia ʻe ala ki ha meʻa naʻe ʻi lalo ʻiate ia, ʻe taʻemaʻa ia ʻo aʻu ki he efiafi: pea ko ia ʻoku ne fua ʻae meʻa ko ia, ʻe fō ʻe ia hono ngaahi kofu, pea kaukau hono sino ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Pea ʻilonga ʻaia ʻoku ala ki ai ʻaia ʻoku moʻua ʻi he mahaki ko e ʻau, pea naʻe ʻikai fanofano hono nima, ʻe fō ʻe ia hono kofu, pea kaukau ia ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Pea ko e ipu ʻumea ʻoku ala ki ai ʻaia ʻoku ʻiate ia ʻae ʻau, ʻe foa ia: pea ko e ipu ʻakau kotoa pē ʻe fufulu ia ʻi he vai. ");
INSERT INTO ton_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Pea ka fakamaʻa ia mei heʻene ʻau, ʻaia naʻe mahaki ai: ʻe toki lau kiate ia ʻae ʻaho ʻe fitu moʻono fakamaʻa, pea ʻe fō hono ngaahi kofu, pea kaukau hono sino ʻi he vai ʻoku tafe, pea maʻa ai. ");
INSERT INTO ton_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Pea ʻi hono valu ʻoe ʻaho ʻe toʻo ʻe ia kiate ia ʻae kulukulu ʻe ua, pē ko e lupe mui ʻe ua, pea ʻe haʻu ia ki he ʻao ʻo Sihova ki he matapā ʻoe fale fehikitaki ʻoe kakai, ʻo ʻatu ia ki he taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Pea ʻe ʻatu ia ʻe he taulaʻeiki, ko e taha ko e feilaulau maʻae angahala, ko e taha kehe ko e feilaulau tutu; pea koeʻuhi ko ʻene ʻau ʻe fai ʻae fakalelei ʻe he taulaʻeiki maʻana ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Pea kapau ʻe ʻau noa mei he tangata hono huhuʻa fakatangata pea ʻe kaukau ʻe ia hono sino kotoa, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Pea ko e kofu kotoa pē, mo e kili kotoa pē, ʻaia ʻoku ʻi ai ʻae meʻa, ʻe fō ia ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Pea ko e fefine foki ʻaia ʻe mohe ki ai ʻae tangata, kena kaukau fakatouʻosi pe ʻi he vai, pea kena taʻemaʻa ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","¶ Pea kapau ʻoku mahaki ʻae fefine ʻi he ʻau, pea ko e mahaki ʻi hono sino ko e ʻau toto, ʻe tuku tokotaha ia ke ʻaho fitu: pea ko ia ʻe lave kiate ia ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Pea ko e meʻa kotoa pē ʻoku tokoto ki ai ia ʻi heʻene vaheʻi ʻe taʻemaʻa ia; pea ko e meʻa kotoa pē ʻoku nofo ki ai ia ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Pea ko ia ʻe ala ki hono mohenga, ʻe fō ʻe ia hono ngaahi kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Pea ko ia ʻoku ala ki ha meʻa naʻe nofo ki ai ia, ʻe fō ʻe ia hono kofu, pea kaukau ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Pea kapau ʻoku ʻi hono mohenga ʻae meʻa, pe ʻi ha meʻa ʻe taha ʻoku nofo ia ki ai, ʻi heʻene ala ki ai, ʻe taʻemaʻa ai ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Pea kapau ʻoku mohe ha tangata kiate ia, pea hoko hono mahaki kiate ia, ʻe taʻemaʻa ia ʻi he ʻaho ʻe fitu; pea mo e mohenga kotoa pē ʻoku mohe ai ia ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Pea kapau ʻoku mahaki ʻae fefine ʻi he ʻau ʻoe toto ʻi he ʻaho ʻoku lahi hake ʻi he ngaahi ʻaho ʻo hono vaheʻi, pea kapau ʻoku fai ai pe ia hili ʻae ngaahi ʻaho ʻoe vaheʻi: ko e ngaahi ʻaho kotoa pē ʻo ʻene mahaki taʻemaʻa ʻe tatau pe ia mo e ngaahi ʻaho ʻo hono vaheʻi: ʻe taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ko e mohenga kotoa pē ʻoku ne mohe ai ʻi he ngaahi ʻaho ʻo ʻene mahaki ʻe tatau ia kiate ia mo e mohenga ʻo hono vaheʻi: pea ko ia ʻe nofo ki ai ia ʻe taʻemaʻa, ʻo hangē ko e taʻemaʻa ʻo hono vaheʻi. ");
INSERT INTO ton_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Pea ko ia ʻe ala ki he ngaahi meʻa ni, ʻe taʻemaʻa ia, pea ʻe fō hono kofu, pea kaukau ia ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Pea kapau kuo fakamaʻa ia mei hono mahaki, ʻe toki lau ʻe ia kiate ia ʻae ʻaho ʻe fitu, pea hili ia, ʻe toki maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Pea ʻi hono valu ʻoe ʻaho te ne toʻo ʻe ia ʻae kulukulu ʻe ua, pe ko e lupe mui ʻe ua, ʻo ʻomi ia ki he taulaʻeiki, ki he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Pea ʻe ʻatu ʻe he taulaʻeiki ʻae taha ko e feilaulau maʻae angahala, mo e taha ko e feilaulau tutu; pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻi he ʻao ʻo Sihova koeʻuhi ko e mahaki ʻo ʻene taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Te mou vaheʻi pehē pe ʻae fānau ʻa ʻIsileli mei heʻenau taʻemaʻa; telia naʻa nau mate ʻi heʻenau taʻemaʻa, ʻi heʻenau ʻuliʻi hoku fale fehikitaki ʻoku ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ko eni ʻae fono ʻo ia ʻoku ʻiate ia ʻae ʻau, mo ia ʻoku ʻau noa meiate ia hono huhuʻa, pea ne taʻemaʻa ai. ");
INSERT INTO ton_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Pea mo efefine ʻoku mahaki ʻi hono mahaki, mo ia ʻoku ʻiate ia ʻae ʻau noa, pe ko e tangata, pe ko e fefine, pea mo ia ʻoku mohe kiate ia ʻoku taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Pea naʻe folofola ʻa Sihova hili ʻae mate ʻae ongo foha ʻo ʻElone, ʻi heʻena fai ʻae feilaulau ʻi he ʻao ʻo Sihova, pea na mate; ");
INSERT INTO ton_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Pea naʻe folofola ʻa Sihova kia Mōsese, “Lea ki ho taʻokete ko ʻElone, ke ʻoua naʻa faʻa haʻu ia ki he potu māʻoniʻoni ʻi he loto puipui ʻi he ʻao ʻoe nofoʻanga ʻaloʻofa, ʻaia ʻoku ʻi he funga puha; telia naʻa mate ia: he te u fakahāhā au ʻi he nofoʻanga ʻaloʻofa. ");
INSERT INTO ton_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","‌ʻE pehē ni ʻae haʻu ʻa ʻElone ki he potu māʻoniʻoni: ʻe ʻomi ʻe ia ʻae pulu mui ko e feilaulau maʻae angahala, mo e sipitangata ki he feilaulau tutu.” ");
INSERT INTO ton_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Pea ʻe ʻai ʻe ia ʻae kofu tupenu hinehina māʻoniʻoni, pea ke ʻai ki hono sino ʻae kofu vaʻe tupenu hinehina, pea ke nonoʻo ʻaki ʻae noʻo tupenu hinehina, pea tatā ʻaki ʻae tatā tupenu hinehina: ko e ngaahi kofu māʻoniʻoni ʻeni; ko ia te ne kaukau ai hono sino ʻaki ʻae vai, pea ʻai ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Pea te ne toʻo ʻe ia mei he fakataha ʻoe fānau ʻa ʻIsileli, ʻae ʻuhikiʻi kosi ʻe ua ko e feilaulau maʻae angahala, mo e sipitangata ʻe taha ko e feilaulau tutu. ");
INSERT INTO ton_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pea ʻe ʻatu ʻe ʻElone ʻae pulu ki he feilaulau maʻae angahala, ʻaia ʻoku maʻana, ʻo fai ʻaki ʻae fakalelei maʻana pea mo hono fale. ");
INSERT INTO ton_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Pea ʻe toʻo ʻe ia ʻae ongo kosi, ʻo ʻatu ia ʻi he ʻao ʻo Sihova ʻi he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Pea ʻe fai ʻae talotalo ʻe ʻElone ki he ongo kosi: ke vahe ʻae taha maʻa Sihova, pea ko e taha ko e kosi fetuku. ");
INSERT INTO ton_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Pea ʻe ʻomi ʻe ʻElone ʻae kosi naʻe talotalo ke vahe maʻa Sihova, ʻo ʻatu ia ko e feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ka ko e kosi, ʻaia naʻe talotalo ke vahe ke hoko ko e kosi fetuku, ʻe ʻatu moʻui pe ia ʻi he ʻao ʻo Sihova, ke fai ʻaki ia ʻae fakalelei, pea ke tukuange ia ke ʻalu ki he toafa ngaongao ko e kosi fetuku. ");
INSERT INTO ton_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Pea ʻe ʻomi ʻe ʻElone ʻae pulu ki he feilaulau maʻae angahala, ʻaia ʻoku ʻatu maʻana, pea ne fai ʻaki ʻae fakalelei maʻana, pea mo hono fale, pea ʻe tāmateʻi ʻe ia ʻae pulu ʻoe feilaulau maʻae angahala, ʻaia ʻoku ʻatu maʻana. ");
INSERT INTO ton_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Pea ʻe toʻo ʻe ia ʻae ipu ʻaingaafi ʻoku fonu ʻi he malalaʻi afi vela mei he funga feilaulauʻanga ʻi he ʻao ʻo Sihova, pea mo e falukunga lahi ʻoe meʻa namu kakala kuo tuki ke iiki, pea te ne ʻomi ia ki loto ʻi he puipui: ");
INSERT INTO ton_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Pea ʻe ʻai ʻe ia ʻae meʻa namu kakala ki he afi ʻi he ʻao ʻo Sihova, koeʻuhi ke ʻufiʻufi ʻe he kohu ʻoe meʻa namu kakala ʻae nofoʻanga ʻaloʻofa, ʻaia ʻoku ne ʻufiʻufi ʻae fuakava, telia naʻa mate ai ia: ");
INSERT INTO ton_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Pea ʻe toʻo ʻe ia mei he toto ʻoe pulu, ʻo luluku ʻaki hono tuhu ki he nofoʻanga ʻaloʻofa ki he potu hopoʻangalaʻā; pea te ne luluku ʻae toto ʻi he ʻao ʻoe nofoʻanga ʻaloʻofa ʻaki ʻa hono tuhu ke liunga fitu. ");
INSERT INTO ton_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","¶ Pea te ne toki tāmateʻi ʻe ia ʻae kosi ki he feilaulau maʻae angahala, ʻaia ʻoku maʻae kakai, pea ʻe ʻomi hono toto ki loto ʻi he puipui, pea ʻe fai ʻaki ʻae toto ʻo hangē ko ia naʻe fai ʻaki ʻae toto ʻoe pulu, ʻo luluku ia ki he nofoʻanga ʻaloʻofa, pea ʻi he ʻao ʻoe nofoʻanga ʻaloʻofa: ");
INSERT INTO ton_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Pea te ne fai ha fakalelei koeʻuhi ko e potu māʻoniʻoni, ko e meʻa ʻi he taʻemaʻa ʻae fānau ʻa ʻIsileli, pea ko e meʻa ʻi heʻenau ngaahi talangataʻa mo ʻenau ngaahi angahala: pea ʻe fai pehē ʻe ia ki he fale fehikitaki ʻoe fakataha, ʻaia ʻoku tuʻu ʻiate kinautolu ʻi he lotolotonga ʻo ʻenau ngaahi meʻa taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Pea ʻe ʻikai ʻalu ki he fale fehikitaki ʻoe fakataha ha tangata ʻe tokotaha, ʻoka hū ia ki ai ke fai ʻae fakalelei ʻoe potu māʻoniʻoni, kaeʻoua ke haʻu ia kituʻa, pea ʻosi ʻene fai ʻe ia ʻae fakalelei maʻana, pea mo hono fale, pea koeʻuhi ko e kakai kotoa pē ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Pea te ne ʻalu kituʻa ki he feilaulauʻanga ʻaia ʻoku ʻi he ʻao ʻo Sihova, pea fai ʻae fakalelei koeʻuhi ko ia; pea ʻe toʻo ʻae toto ʻoe pulu, mo e toto ʻoe kosi, pea ʻe ʻai ia ki he ngaahi nifo ʻoe feilaulauʻanga ʻo takatakai. ");
INSERT INTO ton_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Pea te ne luluku ʻae toto ki ai ʻaki hono tuhu ke liunga fitu, ʻo fakamaʻa ia, ʻo fakatapui ia mei he ngaahi taʻemaʻa ʻae fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","¶ Pea ʻoka hili ʻene fakaʻosi hono fakalelei ʻoe potu māʻoniʻoni, mo e fale fehikitaki ʻoe fakataha, mo e feilaulauʻanga, ʻe toki ʻomi ʻe ia ʻae kosi moʻui: ");
INSERT INTO ton_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Pea ʻe hilifaki ʻe ʻElone hono nima fakatouʻosi ki he ʻulu ʻoe kosi moʻui, ʻo vete ki ai ʻae ngaahi hia kotoa pē ʻae fānau ʻa ʻIsileli, mo ʻenau ngaahi talangataʻa kotoa pē, mo ʻenau ngaahi angahala, ʻo ne hilifaki ia ki he ʻulu ʻoe kosi, pea te ne fekau ke tataki atu ia ki he toafa ʻe ha tangata ʻoku ngalingali mo ia: ");
INSERT INTO ton_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Pea ʻe fua ʻe he kosi ʻo ʻave ki he fonua lala, ʻenau ngaahi hia kotoa pē: pea te ne tukuange ʻe ia ʻae kosi ʻi he toafa. ");
INSERT INTO ton_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Pea ʻe haʻu ʻa ʻElone ki he fale fehikitaki ʻoe fakataha, pea toʻo hono ngaahi kofu tupenu hinehina, ʻaia naʻa ne ʻai ʻi heʻene ʻalu ki he potu māʻoniʻoni, pea te ne tuku ia ʻi ai: ");
INSERT INTO ton_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Pea te ne kaukau ʻe ia hono sino ʻaki ʻae vai ʻi he potu māʻoniʻoni, pea ʻai hono kofu, pea ʻalu atu, pea te ne ʻatu ʻae feilaulau tutu ʻaʻana, mo e feilaulau tutu ʻae kakai, ʻo ne fai ʻae fakalelei maʻana, pea mo e kakai. ");
INSERT INTO ton_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Pea ko e ngako ʻoe feilaulau maʻae angahala ʻe tutu ʻe ia ia ki he feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Pea ko ia naʻa ne tukuange ʻae kosi ko e kosi fetuku ʻe fō ʻe ia hono kofu, pea kaukau hono sino ʻi he vai pea hili ia, ʻe haʻu ia ki he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Pea ko e pulu ki he feilaulau maʻae angahala, mo e kosi ki he feilaulau maʻae angahala, ʻaia naʻe ʻomi hono toto ke fai ʻaki ʻae fakalelei ʻi he potu māʻoniʻoni, ʻe fetuku ia kituaʻā ʻi he ʻapitanga: pea ʻe tutu ʻi he afi hona kili, mo hona sino, pea mo hona kinohaʻa. ");
INSERT INTO ton_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Pea ko ia ʻoku fai ʻa hono tutu ʻe fō ʻe ia hono kofu, pea kaukau hono sino ʻi he vai, pea toki haʻu ia ki he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","¶ Pea ko e fekau tuʻumaʻu ʻeni kiate kimoutolu ʻo taʻengata: koeʻuhi ʻi hono fitu ʻoe māhina, ʻi hono hongofulu ʻoe ʻaho ʻoe māhina ke mou fakavaivai ʻakimoutolu, pea ʻoua naʻa fai ha momoʻi ngāue, pe ko ha tokotaha ʻo homou fonua pe ko ha tokotaha ʻoku ʻāunofo ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Koeʻuhi ʻe fai ʻe he taulaʻeiki ke fakalelei maʻamoutolu, ke fakamaʻa ʻakimoutolu, koeʻuhi ke mou maʻa mei hoʻomou ngaahi angahala ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","‌ʻE ʻiate kimoutolu ia ko e Sāpate mālōlō, pea te mou fakavaivai ʻakimoutolu, ko e fekau ia fai maʻu ʻo taʻengata. ");
INSERT INTO ton_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Pea ko e taulaʻeiki ko ia ʻaia kuo ne fakanofo, mo ne fakatapui ʻe ia ke ngāue ʻi he ngāue fakataulaʻeiki ʻo fetongi ʻene tamai, ʻe fai ʻe ia ʻae fakalelei, pea ʻe ʻai ʻe ia ʻae ngaahi kofu tupenu hinehina, ʻio, ʻae ngaahi kofu māʻoniʻoni: ");
INSERT INTO ton_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Pea ʻe fai ʻe ia ʻae fakalelei koeʻuhi ko e potu tapu lahi, pea fai ʻe ia ʻae fakalelei koeʻuhi ko e fale fehikitaki ʻoe fakataha, pea koeʻuhi ko e feilaulauʻanga, pea ʻe fai ʻe ia ʻae fakalelei maʻae ngaahi taulaʻeiki, pea koeʻuhi ko e kakai kotoa pē ʻoe fakataha. ");
INSERT INTO ton_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Pea ko e fekau fai maʻu eni ʻo taʻengata kiate kimoutolu, ke fai ʻae fakalelei maʻae fānau ʻa ʻIsileli ʻo tuʻo taha ʻi he taʻu koeʻuhi ko ʻenau ngaahi angahala. Pea naʻa ne fai ia ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Lea kia ʻElone, pea ki hono ngaahi foha, pea ki he fānau kotoa pē ʻa ʻIsileli ʻo pehē kiate kinautolu, Ko eni ʻae meʻa ʻaia kuo fekau ʻe Sihova, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ko e tangata kotoa pē ʻiate kimoutolu ʻi he fānau ʻa ʻIsileli ʻoku ne tāmateʻi ʻae pulu pē ko e lami, pe ko e kosi, ʻi he ʻapitanga, pe tāmateʻi ia ʻituʻa he ʻapitanga, ");
INSERT INTO ton_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Pea ʻikai ʻomi ia ki he matapā ʻoe fale fehikitaki ʻoe fakataha, ke ʻatu ha feilaulau kia Sihova ʻi he ʻao ʻoe fale fehikitaki ʻo Sihova; ʻe tuku ʻae toto ki he tangata ko ia: kuo lingi ʻe ia ʻae toto; pea ʻe motuhi ʻae tangata ko ia mei hono kakai: ");
INSERT INTO ton_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Koeʻuhi ke ʻomi ʻe he fānau ʻa ʻIsileli ʻenau ngaahi feilaulau, ʻaia ʻoku nau ʻatu ʻi he ngoue ʻataʻatā, ʻio, kenau ʻomi ia kia Sihova, ki he matapā ʻoe fale fehikitaki ʻoe fakataha, ki he taulaʻeiki, pea ke ʻatu ia ko e ngaahi feilaulau fakalelei kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Pea ʻe luluku ʻe he taulaʻeiki ʻae toto ki he feilaulauʻanga ʻo Sihova ʻi he matapā ʻoe fale fehikitaki ʻoe fakataha, pea tutu ʻae ngako ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Pea ʻe ʻikai tenau toe ʻatu ʻenau ngaahi feilaulau ki he ngaahi faʻahikehe, ʻaia naʻa nau holi kovi ki ai. Ko e fekau fai maʻu eni kiate kinautolu ʻo taʻengata ʻi honau ngaahi toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","¶ Pea te ke pehē kiate kinautolu, Ko e tangata ko ia ʻiate kimoutolu ʻi he fale ʻo ʻIsileli, pe ʻi he muli ʻoku nofo ʻāunofo ʻiate kimoutolu, ʻoku ne ʻatu ha feilaulau tutu pe ha feilaulau, ");
INSERT INTO ton_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Pea ʻoku ʻikai ʻomi ia ki he matapā ʻoe fale fehikitaki ʻoe fakataha, ke ʻatu ia kia Sihova; ko e tangata ko ia ʻe motuhi mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","¶ Pea ko e tangata kotoa pē ko ia ʻiate kimoutolu ʻi he fale ʻo ʻIsileli, pe ʻi he muli ʻoku ʻāunofo ʻiate kimoutolu, ʻoku kai ʻe ia ha toto: teu sio fakafulofula ki he tangata ko ia ʻoku kai toto, pea motuhi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","He ko e moʻui ʻae kakano ko e toto pea kuo u tuku ia kiate kimoutolu ki homou feilaulauʻanga ke fai ʻae fakalelei maʻa homou laumālie; he ko e toto ʻoku ne fai ʻae fakalelei maʻae laumālie. ");
INSERT INTO ton_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Ko ia naʻaku pehē ai ki he fānau ʻa ʻIsileli, ʻoua naʻa kai toto ʻe ha tokotaha ʻiate kimoutolu, pea ʻoua naʻa kai toto ʻe ha muli ʻe tokotaha ʻoku ʻāunofo ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Pea ʻilonga ʻae tangata kotoa pē ʻi he fānau ʻa ʻIsileli, pe ʻi he muli ʻoku ʻāunofo ʻiate kimoutolu, ʻaia ʻoku tuli pe maʻu ha manu ha manu kapakau ʻoku ngofua ke kai: ko e moʻoni ʻe lingi ʻe ia hono toto, ʻo ʻufiʻufi ʻaki ia ʻae efu. ");
INSERT INTO ton_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","He ko e moʻui ia ʻae kakano kotoa pē; ko hono toto ko ʻene moʻui ia; ko ia ne u pehē ai ki he fānau ʻa ʻIsileli, ʻoua naʻa mou kai ʻae toto ʻo ha meʻa moʻui ʻe taha: he ko e toto ko e moʻui ia ʻae kakano kotoa pē; ko ia ʻoku ne kai ia ʻe motuhi ia. ");
INSERT INTO ton_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Pea ko ia ʻoku ne kai ʻaia naʻe mate mahaki, pē ko ia kuo haehae ʻe he manu, pe ko ha tokotaha ia ʻo homou fonua pe ko ha muli, ʻe fō ʻe ia hono kofu mo kaukau ia ʻi he vai, pea ʻe taʻemaʻa ia ʻo aʻu ki he efiafi: pea ʻe toki maʻa ia. ");
INSERT INTO ton_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pea kapau ʻoku ʻikai fō ia, pe kaukau hono sino; pea ʻe ʻiate ia pe ʻene hia. ");
INSERT INTO ton_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo pehē kiate kinautolu, “Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","‌ʻOua naʻa mou fai ʻo hangē ko e faianga ʻae fonua ko ʻIsipite, ʻaia naʻa mou nofo ai: pea ʻe ʻikai te mou fai ʻo hangē ko e faianga ʻae fonua ko Kēnani, ʻaia te u ʻomi ʻakimoutolu ki ai; pea ʻoua naʻa mou ʻalu ʻi heʻenau ngaahi fekau. ");
INSERT INTO ton_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ka mou fai ki heʻeku ngaahi fekau ʻo tauhi ʻeku ngaahi tuʻutuʻuni, ke fai ki ai; Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ko ia ke mou tauhi ʻeku ngaahi tuʻutuʻuni, mo ʻeku ngaahi fekau; ʻaia kapau ʻe fai ia ʻe ha tangata, ʻe moʻui ai ia: Ko au ko Sihova.” ");
INSERT INTO ton_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","¶ ʻOua naʻa ofi atu ha taha ʻiate kimoutolu ki ha tokotaha ʻoku kāinga moʻoni mo ia ko hono fakatelefuaʻi: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ko e telefua ʻo hoʻo tamai pe ko e telefua ʻo hoʻo faʻē ʻoua naʻa ke tatala: he ko hoʻo faʻē ia; ʻe ʻikai te ke fakatelefuaʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","‌ʻOua naʻa ke fakatelefua ʻae mali ʻo hoʻo tamai; he ko e telefua ia ʻo hoʻo tamai. ");
INSERT INTO ton_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","‌ʻOua naʻa ke fakatelefua ʻa ho tuofefine ko e ʻofefine ʻo hoʻo tamai, pe ko e tama ʻo hoʻo faʻē, pe kuo ne tupu ʻi ʻapi, pe tupu ʻi he mamaʻo, ʻoua naʻa ke tatala honau telefua. ");
INSERT INTO ton_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","‌ʻOua naʻa ke fakatelefua ʻae ʻofefine ʻo ho foha, pe ko e tama ʻa ho ʻofefine; he ko honau telefua ko ho telefua ʻoʻou ia. ");
INSERT INTO ton_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Pea ko e telefua ʻoe tama ʻae mali ʻo hoʻo tamai, kuo tupu ʻi hoʻo tamai, ko hoʻo tuofefine ia, ʻoua naʻa ke fakatelefua ia. ");
INSERT INTO ton_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","‌ʻOua naʻa ke fakatelefua ʻae tuofefine ʻo hoʻo tamai: he ko e kāinga fefine ofi ia ʻo hoʻo tamai. ");
INSERT INTO ton_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","‌ʻOua naʻa ke fakatelefua ʻae tokoua ʻo hoʻo faʻē: he ko e kāinga fefine ofi ia ʻo hoʻo faʻē. ");
INSERT INTO ton_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","‌ʻOua naʻa ke fakatelefua ʻae tokoua ʻo hoʻo tamai; ʻoua naʻa ke ʻunuʻunu ʻo ofi ki hono mali; he ko ho mehikitanga ia, ");
INSERT INTO ton_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","‌ʻOua naʻa ke fakatelefua ʻa ho ʻofefine ʻi he fono: he ko e mali ia ʻo ho foha; ʻoua naʻa ke fakatelefua ia. ");
INSERT INTO ton_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","‌ʻOua naʻa ke fakatelefua ʻae mali ʻo ho tokoua: he ko e telefua ʻo ho tokoua ia. ");
INSERT INTO ton_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","‌ʻOua naʻa ke fakatelefua ha fefine mo ʻene tama, pea ʻoua naʻa ke ʻave ʻae ʻofefine ʻo ʻene tama, pe ko e tama ʻa ʻene tama, ke fakatelefua ia; he ko hono kāinga fefine ofi ʻakinautolu; ko e meʻa kovi ia. ");
INSERT INTO ton_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Pea ʻoua naʻa ke mali mo e tokoua ʻo ho mali ke fakamamahi ʻaki ia, mo fakatelefua ia ʻi heʻene kei moʻui ʻaʻana. ");
INSERT INTO ton_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Pea ʻoua naʻa ke ʻunuʻunu ʻo ofi ki ha fefine ke fakatelefua ia, lolotonga kuo vaheʻi ia ʻi heʻene taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Pea ʻoua foki naʻa ke mohe angahala mo e uafi ʻo ho kaungāʻapi, ke fakaʻuliʻi koe mo ia. ");
INSERT INTO ton_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Pea ʻoua naʻa ke tuku ke ʻalu ʻa ho hako ʻi he afi kia Moleki, pea ʻoua naʻa ke fakaongokovi ʻae huafa ʻo ho ʻOtua; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","‌ʻOua naʻa ke mohe mo ha tangata ʻo hangē ko e mohe mo e fefine: ko e meʻa fakalielia ia. ");
INSERT INTO ton_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Pea ʻe ʻikai te ke mohe mo ha manu ke fakaʻuliʻi koe ʻi ai: pea ʻoua naʻa tuʻu ha fefine ʻi he ʻao ʻoe manu ke tokoto ki ai: ko e meʻa kovi fakaʻulia ia. ");
INSERT INTO ton_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","‌ʻOua naʻa mou fakalieliaʻi ʻakimoutolu ʻi ha ngaahi meʻa pehē: he ʻoku ʻuliʻi ʻi he ngaahi meʻa ni ʻae ngaahi puleʻanga ʻaia ʻoku ou kapusi mei homou ʻao: ");
INSERT INTO ton_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","‌ʻOku fakalieliaʻi ʻae fonua: ko ia ʻoku ou totongi ki ai ʻene hia, pea ʻoku lua ʻaki foki ʻe he fonua ko ia ʻa hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ko ia te mou tauhi ʻeku ngaahi tuʻutuʻuni mo ʻeku ngaahi fekau, pea ʻoua naʻa mou fai ha meʻa ʻe taha ʻi he ngaahi meʻa fakalielia ni, ʻe ha tokotaha ʻi homou puleʻanga, pe ha muli, ʻoku ʻāunofo ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(He ko e ngaahi meʻa fakalielia ni kuo fai ʻe he kau tangata ʻoe fonua, pea kuo pani ʻuli fōfō ʻae fonua:) ");
INSERT INTO ton_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Telia naʻa lua ʻaki ʻakimoutolu foki ʻe he fonua, ʻo hangē ko ʻene lua ʻaki kituʻa ʻae ngaahi puleʻanga naʻe muʻomuʻa ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","He ko ia ʻe fai ha meʻa ʻi he ngaahi meʻa fakalielia ni, ʻio, ko e laumālie ʻe fai ia ʻe motuhi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ko ia te mou tauhi ai ʻeku ngaahi fekau, koeʻuhi ke ʻoua naʻa mou fai ha meʻa ʻe taha ʻi he ngaahi anga fakalielia ni, ʻaia naʻe fai ʻi muʻa ʻi homou ʻao, pea ke ʻoua naʻa mou ʻuliʻi ʻakimoutolu ʻi ai: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Lea ki he fakataha kotoa pē ʻoe fānau ʻa ʻIsileli mo ke pehē kiate kinautolu, “Ke mou māʻoniʻoni; he ko au ko Sihova ko homou ʻOtua ʻoku ou māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","¶ “Te mou fakaʻapaʻapa taki taha kotoa pē ʻae tangata ki heʻene faʻē, mo ʻene tamai, pea tauhi hoku ngaahi Sāpate: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","¶ “ʻOua naʻa mou tafoki ki he ngaahi ʻotua loi, pea ʻoua naʻa mou ngaohi moʻomoutolu ʻae ngaahi ʻotua ʻi he ukamea haka: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","¶ “Pea kapau ʻoku mou ʻatu ʻae feilaulau ko e ngaahi feilaulau fakalelei kia Sihova, te mou ʻatu ia ʻi homou loto lelei ki ai. ");
INSERT INTO ton_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","‌ʻE kai ia ʻi he ʻaho ʻoku mou ʻatu ia, pea ʻi he ʻaho ʻoku na feholoʻi: pea kapau ʻoku ai hano toe ki hono ʻaho tolu, ʻe tutu ʻaki ia ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Pea kapau ʻe momoʻi kai ia ʻi hono ʻaho tolu, ko e meʻa kovi ia; ʻe ʻikai maʻu ia. ");
INSERT INTO ton_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ko ia, ko e tangata kotoa pē ʻoku kai ia ʻe ʻiate ia ʻene hia, koeʻuhi kuo fakahala ʻe ia ʻae meʻa tapu ʻa Sihova: pea ʻe motuhi ʻae tangata ko ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","¶ “Pea ka mou ka tuʻusi ʻae fua ʻo homou fonua, ʻoua naʻa ke tuʻusi ke ʻosi ʻae ngaahi tuliki ʻo hoʻo ngoue, pea ʻe ʻikai te ke tānaki ʻae ngaahi toenga tufi ʻo hoʻo ututaʻu. ");
INSERT INTO ton_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Pea ʻoua naʻa ke tufi ʻae toenga ʻo hoʻo ngoue vaine, pea ʻoua naʻa ke tānaki ʻae kālepi kotoa pē ʻo hoʻo ngoue vaine; ka ke tuku ia ki he masiva mo e muli: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","¶ “ʻOua naʻa mou kaihaʻa, pe fai fakakākā, pe feloiʻaki ʻae taha ki he taha. ");
INSERT INTO ton_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","¶ “Pea ʻoua naʻa mou fuakava loi ʻi hoku hingoa, pea ʻoua naʻa ke takuanoa ʻae huafa ʻo ho ʻOtua: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","¶ “ʻOua naʻa ke kākaaʻi ho kaungāʻapi, pea ʻoua naʻa ke kaihaʻa meiate ia: ko e totongi ngāue ʻo ia naʻa mo alea ki ai, ʻoua naʻa tuku ia ʻiate koe ʻi he pō ʻo ʻaho. ");
INSERT INTO ton_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","¶ “ʻOua naʻa ke kapeʻi ʻae tuli, pe ʻai ʻae tūkiaʻanga ʻi he ʻao ʻoe kui, ka ke manavahē ki ho ʻOtua: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","¶ “ʻOua naʻa mou fai taʻetotonu ʻi he fakamaau: ʻoua naʻa ke tokanga koeʻuhi ko e mata ʻoe masiva, pe fakaʻapaʻapa koeʻuhi ko e mata ʻoe ʻeiki: ka te ke fakamaauʻi ho kaungāʻapi ʻi he angatonu. ");
INSERT INTO ton_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","¶ “ʻOua naʻa ke feʻaluʻaki fano ke fetuku talanoa ʻi hoʻo kakai; pea ʻoua naʻa ke lea ke mate ai ho kaungāʻapi: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","¶ “ʻOua naʻa ke fehiʻa ki ho tokoua ʻi ho loto: ko e moʻoni ke ke valokiʻi ho kaungāʻapi, pea ʻoua naʻa tuku ai pe ʻene angahala. ");
INSERT INTO ton_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","¶ “ʻOua naʻa ke totongi kovi pe angafakamolokau ki he fānau ʻa ho kakai, ke ke ʻofa ki ho kaungāʻapi ʻo hangē pe ko koe: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Te mou tauhi ʻeku ngaahi fekau. ʻOua naʻa ke tuku hoʻo fanga manu ke tauʻi ʻe he faʻahinga manu kehe: ʻoua naʻa ke tūtuuʻi hoʻo ngoue ʻaki ʻae ngaahi tenga kuo felavai; pea ke ʻoua naʻa ke ʻai ha kofu ʻoku felalangaʻaki ʻae filo tupenu mo e fulufuluʻi sipi. ");
INSERT INTO ton_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","¶ “Pea ko ia ʻe mohe angahala mo e fefine ʻoku pōpula, kuo poloʻi ki ha mali, pea ʻoku teʻeki ai huhuʻi, pe tauʻatāina ia; ʻe haha ia; ʻe ʻikai tāmateʻi ʻakinaua, koeʻuhi naʻe ʻikai ʻataʻatā ia. ");
INSERT INTO ton_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Pea ke ʻomi ʻe he tangata ʻene feilaulau fai hala kia Sihova, ki he matapā ʻoe fale fehikitaki ʻoe kakai, ʻio, ko e sipitangata ki he feilaulau maʻae fai hala. ");
INSERT INTO ton_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Pea ke fai ʻe he taulaʻeiki ʻae fakalelei maʻana ʻaki ʻae sipitangata ʻoe feilaulau maʻae fai hala ʻi he ʻao ʻo Sihova ʻi heʻene angahala ʻaia kuo ne fai: pea ʻe fakamolemole kiate ia ʻae angahala kuo ne fai. ");
INSERT INTO ton_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","¶ “Pea ka mou ka hoko atu ki he fonua pea mou tō ai ʻae ngaahi ʻakau kehekehe ki he kai, te mou lau hono ngaahi fua ko e meʻa tapu; ko e taʻu ʻe tolu ʻe tapu ia kiate kimoutolu; ʻoua naʻa kai ia. ");
INSERT INTO ton_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ka ʻi hono fā ʻoe taʻu ko e ngaahi fua kotoa pē ʻo ia ko e meʻa māʻoniʻoni ia ke fakafetaʻi ʻaki kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pea ʻi hono nima ʻoe taʻu te mou kai hono ngaahi fua, koeʻuhi ke tupu ʻo fua lahi hake kiate kimoutolu: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","¶ “ʻOua naʻa mou kai ha meʻa ʻe taha mo hono toto: pea ʻoua naʻa mou fai tuki, pe fai ʻae talotalo kovi. ");
INSERT INTO ton_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","‌ʻOua naʻa mou kosi ke fuopotopoto homou louʻulu, pe maumauʻi hono potu tuliki ʻo hoʻomou kava. ");
INSERT INTO ton_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","‌ʻOua naʻa mou tafatafaʻi homou sino koeʻuhi ko e pekia, pea ʻoua naʻa mou tātatau; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","¶ “ʻOua naʻa ke fakaangahalaʻi ho ʻofefine, pe fakahoko ia ko e fefine fai angahala; telia naʻa hinga ʻae fonua ki he feʻauaki, pea hoko ʻo fonu ʻae fonua ʻi he anga kovi. ");
INSERT INTO ton_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","¶ “Te mou tauhi hoku ngaahi Sāpate, ʻo fakaʻapaʻapa ki hoku faletapu; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","¶ “ʻOua naʻa tokanga kiate kinautolu ʻoku vaka ai ʻae kau laumālie ʻuli, pea ʻoua naʻa kumi ki he ngaahi taulafaʻahikehe tuki, ke mou ʻuli ai ʻiate kinautolu. Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","¶ “Ke ke tuʻu hake ʻi he ʻao ʻoe ʻuluhinā, ʻo fakaʻapaʻapa ki he mata ʻoe tangata motuʻa, pea manavahē ki ho ʻOtua; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","¶ “Pea kapau ʻoku nofo ʻāunofo ha muli mo koe ʻi ho fonua, ʻoua naʻa ke fakamamahiʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ka ko e muli ʻoku nofo mo koe ʻe tatau ia mo e tokotaha kuo tupu ʻiate kimoutolu, pea te ke ʻofa kiate ia ʻo hangē ko hoʻo ʻofa kiate koe; he naʻa mou nofo ko e muli ʻi he fonua ko ʻIsipite; Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","¶ “ʻOua naʻa mou fai taʻetotonu ʻi he fakamaau, pe ʻi he meʻa fuofua pe ʻi he fakamamafa, pe ʻi he fakafuofua meʻa. ");
INSERT INTO ton_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Te mou fua ʻaki ʻae meʻa fakatatau totonu, mo e fakamamafa totonu mo e efa totonu, mo e hini totonu: Ko au ko Sihova ko homou ʻOtua, ʻaia naʻe ʻomi ʻakimoutolu mei he fonua ko ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Ko ia te mou tokanga ai ki heʻeku ngaahi tuʻutuʻuni, mo ʻeku ngaahi fekau, ʻo fai ki ai. Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ko eni foki, ke ke lea ki he fānau ʻa ʻIsileli, Ko ia fulipē ʻi he fānau ʻa ʻIsileli, pe ʻi he kau muli ʻoku ʻāunofo ʻi ʻIsileli, ʻoku ne foaki hono hako kia Moleki; ko e moʻoni ʻe tāmateʻi ia: ʻe tolongaki ia ʻaki ʻae maka ʻe he kakai ʻoe fonua. ");
INSERT INTO ton_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Pea te u fakahangatonu hoku fofonga ki he tangata ko ia, ke motuhi ia mei hono kakai: ko e meʻa ʻi heʻene foaki ʻa hono hako kia Moleki, ke ʻuliʻi hoku faletapu, mo fakaongokoviʻi hoku huafa māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Pea kapau ʻoku fufū honau mata ʻe he kakai ʻoe fonua mei he tangata, ʻi heʻene foaki hono hako kia Moleki, pea ʻikai tāmateʻi ia; ");
INSERT INTO ton_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Pea te u fakahanga hoku fofonga ki he tangata ko ia, pea ki hono fale, pea ko ia, mo kinautolu kotoa pē ʻoku fai hala ʻo muimui ʻiate ia, ke fai angahala mo Moleki, teu motuhi mei honau kakai. ");
INSERT INTO ton_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","¶ “Pea ko ia ʻoku tafoki kiate kinautolu ʻoku vaka ai ʻae ngaahi laumālie ʻuli, mo e kau taulafakafaʻahikehe, ke ʻalu holi kovi kiate kinautolu, te u fakahanga moʻoni hoku fofonga ki he tangata ko ia, pea teu motuhi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","¶ “Ko ia mou fakamāʻoniʻoniʻi ʻakimoutolu, pea ke mou māʻoniʻoni: he ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Pea ke mou tauhi ʻeku ngaahi fekau ʻo fai ki ai: Ko au ko Sihova ʻoku ou fakamāʻoniʻoniʻi ʻakimoutolu.” ");
INSERT INTO ton_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","¶ He ko ia kotoa pē ʻoku kapeʻi ʻene tamai pe ko ʻene faʻē, ko e moʻoni ʻe tāmateʻi ia kuo ne kapeʻi ʻene tamai pe ko ʻene faʻē pea ʻe ʻiate ia pe hono toto. ");
INSERT INTO ton_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","¶ Pea ko e tangata ʻoku tonoʻi ʻae uafi ʻoe tangata ʻe tokotaha, ʻio, ko ia ʻoku tonoʻi ʻae uafi ʻo hono kaungāʻapi, ko e tangata tono fefine mo e fefine tono tangata, ʻe tāmateʻi moʻoni ʻakinaua. ");
INSERT INTO ton_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ko e tangata ʻoku mohe mo e mali ʻo ʻene tamai kuo fakatelefua ʻe ia ʻa ʻene tamai: ʻe tāmateʻi ʻakinaua fakatouʻosi pe; ʻe ʻiate kinaua hona toto. ");
INSERT INTO ton_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Pea kapau ʻe mohe ʻae tangata mo hono ʻofefine ʻi he fono, ʻe tāmateʻi ʻakinaua fakatouʻosi pe: kuo na fai fakamaveuveu; ʻe ʻiate kinaua hona toto. ");
INSERT INTO ton_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Pea kapau ʻe mohe ha tangata mo e tangata, ʻo hangē ko ʻene mohe mo e fefine, kuo na fai fakalielia fakatouʻosi pe; ke tāmateʻi moʻoni ʻakinaua; ʻe ʻiate kinaua hona toto. ");
INSERT INTO ton_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Pea kapau ʻoku ʻomi ʻe ha tangata mo hono mali ʻae faʻē ʻa hono mali kena mali, ko e meʻa kovi ia: ʻe tutu ʻakinautolu ʻaki ʻae afi, ʻaia mo kinaua; koeʻuhi ke ʻoua naʻa ai ha kovi ʻiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Pea kapau ʻe mohe ha tangata mo e manu, ʻe tāmateʻi moʻoni ia: pea ke mou tāmateʻi ʻae manu. ");
INSERT INTO ton_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Pea kapau ʻe ʻunuʻunu atu ha fefine ki ha manu, pea tokoto ki ai ia, ʻe tāmateʻi ʻae fefine, mo e manu: ʻe tāmateʻi moʻoni ʻakinaua; ʻe ʻiate kinaua hona toto. ");
INSERT INTO ton_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Pea kapau ʻe ʻave ʻe ha tangata hono tuofefine, ko e ʻofefine ʻo ʻene tamai, pe ko e tama ʻa ʻene faʻē, ʻo mamata ki heʻene telefua, pea mamata ia ki heʻene telefua ʻaʻana; ko e meʻa kovi ia: pea ʻe motuhi ʻakinaua ʻi he ʻao ʻo hona kakai: kuo tatala ʻo fakatelefua ʻa hono tuofefine; ʻe fua ʻe ia ʻene hia. ");
INSERT INTO ton_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Pea kapau ʻe mohe ha tangata mo e fefine ʻoku ʻiate ia hono mahaki, pea tatala hono mahaki; kuo ne fakatelefua hono mahaki, pea kuo tatala ʻe ia ʻae mata ʻo hono toto: pea ʻe motuhi ʻakinaua fakatouʻosi mei hona kakai. ");
INSERT INTO ton_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Pea ʻoua naʻa ke fakatelefua ʻae tokoua ʻo hoʻo faʻē, pe ko e tuofefine ʻo hoʻo tamai: he ko ia ʻoku ne fai pehē ʻoku fakatelefua hono kāinga ofi: te na fua ʻena hia. ");
INSERT INTO ton_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Pea kapau ʻe mohe ha tangata mo e uaifi ʻoe tokoua ʻo ʻene tamai, kuo fakatelefua ʻe ia ʻa hono tuʻasina: te na fua ʻena angahala: te na mate taʻehafānau. ");
INSERT INTO ton_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Pea kapau ʻe maʻu ʻe ha tangata ʻae uaifi ʻa hono tokoua, ko e meʻa taʻemaʻa ia: kuo fakatelefua ʻa hono tokoua; te na mate taʻehafānau. ");
INSERT INTO ton_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","¶ “Ko ia ke mou tauhi ai ʻeku ngaahi tuʻutuʻuni ni, mo ʻeku ngaahi fekau, ʻo fai ki ai: telia naʻa lua ʻaki ʻakimoutolu ʻe he fonua ʻoku ou ʻomi ʻakimoutolu ki ai. ");
INSERT INTO ton_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Pea ʻe ʻikai te mou fai ki he ngaahi anga ʻoe puleʻanga, ʻaia ʻoku ou kapusi mei homou ʻao: he kuo nau fai ʻae ngaahi meʻa ni, pea ko ia kuo u fehiʻa ai kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ka kuo u lea kiate kimoutolu, Te mou maʻu honau fonua, pea te u ʻatu ia kiate kimoutolu ke mou maʻu ia, ko e fonua ʻoku mahu tāfea ʻi he huʻahuhu mo e honi: Ko au ko Sihova ko homou ʻOtua, ʻaia kuo u vaheʻi ʻakimoutolu mei he kakai kehe. ");
INSERT INTO ton_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Ko ia ke mou vaheʻi ʻae fanga manu maʻa mo e taʻemaʻa, pea lau kehe ʻae fanga manu taʻemaʻa ʻoku kapakau mo e maʻa: pea ʻoua naʻa mou fakalieliaʻi ʻakimoutolu ʻi he manu, pe ha manu kapakau, pe ʻi ha meʻa ʻe taha ʻoku totolo ʻi he kelekele, ʻaia kuo vaheʻi ia ʻiate kimoutolu ko e taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Pea te mou māʻoniʻoni kiate au: he ko au Sihova ʻoku ou māʻoniʻoni, pea kuo u fakamavahe ʻakimoutolu mei he kakai kehe, koeʻuhi ke ʻoʻoku ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","¶ “Ko e tangata foki, pe ko e fefine ʻoku vaka ai ʻae laumālie ʻuli, pea ko e taulafakafaʻahikehe, ʻe tāmateʻi moʻoni ia: ʻe tolongaki ʻakinautolu ʻaki ʻae maka: ʻe ʻiate kinautolu honau toto. ");
INSERT INTO ton_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, Lea ki he kau taulaʻeiki ko e ngaahi foha ʻo ʻElone, ʻo pehē kiate kinautolu, “ʻOua naʻa fakaʻuliʻi ha tokotaha koeʻuhi ko e pekia ʻoku ʻi hono kakai: ");
INSERT INTO ton_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ka koeʻuhi ko hono kāinga moʻoni, ʻoku ofi kiate ia, koeʻuhi ko ʻene faʻē, pea mo ʻene tamai, pea mo hono foha, pea mo hono ʻofefine, pea mo hono tokoua, ");
INSERT INTO ton_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Pea koeʻuhi ko hono tuofefine ko e tāupoʻou, ʻaia ʻoku ofi kiate ia, pea kuo teʻeki ai hano husepāniti; ʻoku ngofua ʻene taʻemaʻa koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Kaeʻoua naʻa ne fakaʻuliʻi ia koeʻuhi ko ha taha ʻeiki ʻi hono kakai, ke ne taʻemaʻa ai. ");
INSERT INTO ton_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ʻE ʻikai tenau tekefua honau ʻulu, pe tele hono potu tuliki ʻoe kava, pe fai ha tafatafaʻi ʻi honau sino. ");
INSERT INTO ton_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Tenau māʻoniʻoni ki honau ʻOtua, kaeʻoua naʻa fakaongokoviʻi ʻae huafa ʻo honau ʻOtua: he ko e ngaahi feilaulau kia Sihova ʻoku ngaohi ʻi he afi, pea ʻoku nau ʻatu ʻae mā ʻa honau ʻOtua; ko ia ʻe māʻoniʻoni ai ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","‌ʻE ʻikai tenau fakamaʻu mali mo ha fefine faʻa feʻauaki, pe ha taʻelotu; pea ʻoua naʻa nau maʻu ʻae fefine kuo tukuange mei hono mali: he ʻoku māʻoniʻoni ia ki hono ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ko ia ke ke fakamāʻoniʻoniʻi ia; he ʻoku ne ʻatu ʻae mā ʻa ho ʻOtua; ʻe māʻoniʻoni ia kiate koe: he ko au Sihova, ʻoku ou fakamāʻoniʻoniʻi ʻakimoutolu, ʻoku ou māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Pea ko e ʻofefine ʻo ha taulaʻeiki, kapau ʻoku ne fakahalaʻi ʻe ia ia ʻi he fai feʻauaki, ʻoku ne fakahalaʻi ʻene tamai: ʻe tutu ʻaki ia ʻae afi. ");
INSERT INTO ton_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","¶ “Pea ko ia ʻoku taulaʻeiki lahi ʻi hono ngaahi kāinga, ʻaia naʻe lingi ki hono ʻulu ʻae lolo ʻoe fakanofo, pea kuo fakatapui ke ʻai ʻae ngaahi kofu, ʻe ʻikai toʻo ʻe ia hono tatā, pe hae hono kofu; ");
INSERT INTO ton_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Pea ʻe ʻikai te ne ʻalu ia ki ha sino ʻoku mate, pe fakahalaʻi ʻe ia ia koeʻuhi ko ʻene tamai, pe ko ʻene faʻē; ");
INSERT INTO ton_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Pea ʻe ʻikai ʻalu ia kituaʻā ʻi he faletapu, pe fakahalaʻi ʻae faletapu ʻo hono ʻOtua; he ko e tatā ʻoe lolo tākai ʻo hono ʻOtua ʻoku ʻiate ia: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Pea te ne fili ʻe ia hono uaifi ko e tāupoʻou. ");
INSERT INTO ton_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ko e fefine paea, pe ko e fefine fakamāvae, pe ko e taʻelotu, pe ko e feʻauaki, ko kinautolu ni ʻe ʻikai te ne fili: kae maʻu ʻe ia ha taʻahine mei hono kakai ko hono uaifi. ");
INSERT INTO ton_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pea ʻe ʻikai te ne fakahalaʻi ʻe ia hono hako ʻi he lotolotonga ʻo hono kakai: he ko au ko Sihova ʻoku ou fakamāʻoniʻoniʻi ia.” ");
INSERT INTO ton_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Lea kia ʻElone, ʻo pehē, “Ko ia ʻi ho hako ʻi honau toʻutangata kotoa pē, ʻoku ʻiate ia hano mele, ʻoua naʻa ʻunuʻunu mai ia ke ʻatu ʻae mā ʻa hono ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","He ko e tangata ko ia ʻoku ai hano mele, ʻoua naʻa ʻunuʻunu mai ia: ko e tangata kui, pe ko e ketu, pe ko ia ʻoku ihu lafalafa, pe ai haʻane anga ʻoku kehe, ");
INSERT INTO ton_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Pe ha tangata ʻoku veʻe fasi, pe nima fasi, ");
INSERT INTO ton_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","‌ʻAe tuʻa piko pe ko e kihi, pe hangatāmakia hono mata, pe ko e kamaa, pe ko e mongumangu, pe ko e tangapula. ");
INSERT INTO ton_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","‌ʻIlonga ʻae tangata ʻi he fānau ʻa ʻElone ko e taulaʻeiki ʻoku ʻiate ia ha mele, ke ʻoua naʻa ʻunuʻunu mai ia ke ʻatu kia Sihova ʻae feilaulau kuo ngaohi ʻaki ʻae afi: ʻoku ʻiate ia hano mele; ʻe ʻikai ofi mai ia ke ʻatu ʻae mā ʻa hono ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","‌ʻE kai ʻe ia ʻae mā ʻa hono ʻOtua, ʻio, ʻae māʻoniʻoni lahi, pea mo e māʻoniʻoni pe. ");
INSERT INTO ton_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ka koeʻuhi pe ʻe ʻikai te ne ʻalu ki he loto puipui, pe hoko ʻo ofi ki he feilaulauʻanga, koeʻuhi ʻoku ʻiate ia hano mele; ke ʻoua naʻa fakahalaʻi ʻe ia hoku ngaahi potu tapu: he ko au ko Sihova ʻoku ou fakamāʻoniʻoni ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Pea naʻe tala ia ʻe Mōsese kia ʻElone, pea ki hono ngaahi foha, pea ki he fānau kotoa pē ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Lea kia ʻElone pea ki hono ngaahi foha, koeʻuhi kenau fakamavae ʻakinautolu mei he ngaahi meʻa māʻoniʻoni ʻae fānau ʻa ʻIsileli, pea ke “ʻOua naʻa nau fakahalaʻi hoku huafa māʻoniʻoni ʻi he ngaahi meʻa ko ia ʻoku nau fakatapui kiate au: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Tala kiate kinautolu, Ko ia ʻiate kimoutolu ʻi homou hako kotoa pē ʻi homou ngaahi toʻutangata, ʻoku ʻalu ki he ngaahi meʻa māʻoniʻoni, ʻaia ʻoku fakatapui ʻe he fānau ʻa ʻIsileli kia Sihova, ka ʻoku ne taʻemaʻa, ʻe motuhi ʻae laumālie ko ia mei hoku ʻao: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Ko e tangata ko ia ʻi he hako ʻo ʻElone ʻoku kilia, pe mahaki ko e ʻau; ʻoua naʻa kai ia ʻi he ngaahi meʻa māʻoniʻoni, kaeʻoua ke maʻa ia. Pea mo ia ʻoku ala ki ha meʻa taʻemaʻa ʻi he mate, pe ʻi ha tangata ʻoku ʻau noa hono mahaki; ");
INSERT INTO ton_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Pe ha taha ʻoku ala ki ha meʻa totolo, ʻaia ʻe hoko ʻo taʻemaʻa ai, pe ʻi ha tangata ʻaia ʻe hoko ʻo pihia ai, ʻi he mahaki ʻoku taʻemaʻa ai ia; ");
INSERT INTO ton_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Ko e tangata kuo ala ki ha meʻa pehē ʻe taʻemaʻa ia ʻo aʻu ki he efiafi, pea ʻe ʻikai kai ʻe ia ʻae ngaahi meʻa māʻoniʻoni, kaeʻoua ke kaukau hono sino ʻi he vai. ");
INSERT INTO ton_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Pea ka tō ʻae laʻā, ʻe toki maʻa ia, pea kai ʻe ia ʻae ngaahi meʻa māʻoniʻoni; he koeʻuhi ko ʻene meʻakai ia. ");
INSERT INTO ton_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ko ia ʻoku mate mahaki pe, pe ko ia kuo haehae ʻe he manu, ʻoua naʻa ne kai ia ke fakahala ai ia: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Ko ia kenau tauhi ʻeku ngaahi tuʻutuʻuni ni, telia naʻa nau halaia ai, pea mate ai, ʻo kapau ʻoku nau fakahalaʻi ia: Ko au ko Sihova ʻoku ou fakamāʻoniʻoniʻi ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ʻE ʻikai kai ʻe ha muli ki he ngaahi meʻa māʻoniʻoni: ko e ʻāunofo ʻae taulaʻeiki, pe ko e tamaioʻeiki unga ngāue, ʻe ʻikai kai ia ʻi he meʻa māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Pea kapau ʻe fakatau ha tokotaha ʻe he taulaʻeiki ʻaki ʻene paʻanga, ʻe ngofua ʻene kai ʻaʻana, pea mo ia kuo fānau ʻi hono fale: te na kai ʻi heʻene meʻakai. ");
INSERT INTO ton_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Pea kapau ʻoku mali ʻae ʻofefine ʻoe taulaʻeiki mo e tangata kehe, ʻe ʻikai ngofua ʻa ʻene kai ʻaʻana ʻi he meʻa ʻatu ʻoe ngaahi meʻa māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pea kapau ko e fefine paea ʻae ʻofefine ʻoe taulaʻeiki, pe kuo fakamāvaeʻi pea ʻikai haʻane tamasiʻi, pea kuo toe ʻomi ia ki he fale ʻo ʻene tamai, ʻo hangē ko ʻene kei siʻi, ʻe kai ia ʻi he meʻakai ʻa ʻene tamai: kaeʻoua naʻa kai ia ʻe ha muli. ");
INSERT INTO ton_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","¶ “Pea kapau ʻe kai faainoa pe ʻe ha tangata ʻae meʻa māʻoniʻoni, te ne fakalahi ʻaki ia hono nima ʻoe vahe ʻo ia, pea ʻatu ia ki he taulaʻeiki fakataha mo e meʻa māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Pea ʻe ʻikai tenau fakahalaʻi ʻae ngaahi meʻa māʻoniʻoni ʻae fānau ʻa ʻIsileli, ʻaia ʻoku nau ʻatu kia Sihova: ");
INSERT INTO ton_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Pe tuku ʻakinautolu ke fua ʻae hia ʻae fai hala, ʻi heʻenau kai ʻenau ngaahi meʻa māʻoniʻoni: he ko au ko Sihova ʻoku ou fakamāʻoniʻoniʻi ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Lea kia ʻElone, pea ki hono ngaahi foha, pea ki he fānau kotoa pē ʻa ʻIsileli, pea ke pehē kiate kinautolu, ʻilonga ʻae tangata ʻi he fale ʻo ʻIsileli, pe ʻi he ngaahi muli ʻi ʻIsileli, ʻoku loto ke ʻatu ʻene meʻaʻofa ʻi heʻene ngaahi fuakava, pea ki heʻene ngaahi meʻa ʻoku ʻatu loto ʻataʻatā pe, ʻaia ʻoku nau ʻatu kia Sihova ko e feilaulau tutu: ");
INSERT INTO ton_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Ke mou ʻatu ʻo fai loto lelei pe, ʻae manu tangata taʻehanomele mei he fanga pulu pe ko e fanga sipi, pe ko e fanga kosi. ");
INSERT INTO ton_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Ka ko ia ʻoku ai hano mele, ʻoua naʻa mou ʻatu ia; koeʻuhi ʻe ʻikai leleiʻia ai ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Pea ko ia ʻoku ne ʻatu kia Sihova ʻae feilaulau ʻoe ngaahi meʻa fakamelino ke fakahoko ʻaki ʻene fuakava, pea ko e meʻa ʻatu loto lelei ʻi he fanga pulu, pe ʻi he fanga sipi, ke haohaoa ia koeʻuhi ke maʻu lelei ia; ʻoua naʻa ʻi ai hano mele. ");
INSERT INTO ton_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ko e kui, pe ko e fasi, pe ko e mutu, pe ko e meʻa fufula, pe ko e kamaa, pe ko e mongumangu, ʻoua naʻa mou ʻatu mei ai kia Sihova, pe fai ʻaki ia ha feilaulau tutu ʻaki ʻae afi ki he funga feilaulauʻanga ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ko e pulu pe ko e lami ʻoku ʻi ai ha meʻa kovi, pe ʻoku taʻehaohaoa ʻi ha meʻa ʻe taha, ʻe ngofua ke ʻatu ia ko e feilaulau loto ʻataʻatā ia: ka ʻe ʻikai maʻu lelei ia ʻi he fuakava. ");
INSERT INTO ton_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","‌ʻOua naʻa mou ʻatu kia Sihova ʻaia kuo fakavolu, pe kuo taʻomia, pe kuo mafesi, pe kuo mahifi; pea ʻoua naʻa mou fai ha feilaulau ʻaki ia ʻi homou fonua. ");
INSERT INTO ton_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Pea ʻoua naʻa ke ʻatu ʻi he nima ʻo ha muli ʻae meʻakai ʻa homou ʻOtua ʻi he ngaahi meʻa ni; koeʻuhi ʻoku ʻi ai ʻenau kovi, pea ʻoku ʻi ai ʻae ngaahi mele: ʻe ʻikai ʻaonga ia maʻamoutolu. ");
INSERT INTO ton_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","‌ʻOka fanauʻi ha pulu, pe ha sipi, pe ha kosi, tuku ia ke ʻaho fitu mo ʻene faʻē: pea mei he ʻaho valu ʻo fai ai pe ʻe maʻu lelei pe ia ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Pea kapau ko ha pulu fefine ia pe ha sipi fefine, ʻoua naʻa mou tāmateʻi ia mo hono ʻuhiki ʻi he ʻaho pe taha. ");
INSERT INTO ton_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Pea ka mou ka loto ke ʻatu ha feilaulau fakafetaʻi kia Sihova, ʻatu ia ʻi he loto ʻataʻatā lelei pe. ");
INSERT INTO ton_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","‌ʻI he ʻaho pe ko ia ʻe kai ia ke ʻosi ʻoua naʻa mou tuku hono toe ki he ʻapongipongi; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ko ia ke mou tauhi ai ʻeku ngaahi fekau, mo fai ki ai; Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Pea ʻoua naʻa mou fakahalaʻi hoku huafa māʻoniʻoni; kae ʻapasia kiate au ʻae fānau ʻa ʻIsileli: Ko au ko Sihova ʻaia ʻoku ou fakatapui ʻakimoutolu; ");
INSERT INTO ton_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Naʻaku ʻomi ʻakimoutolu mei he fonua ko ʻIsipite, ke hoko ko homou ʻOtua: Ko au ko Sihova.” ");
INSERT INTO ton_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo pehē kiate kinautolu, Ko e ngaahi kātoanga kia Sihova, ʻaia te mou fakahā ko e ngaahi fakataha māʻoniʻoni, ʻio, ko ʻeku ngaahi kātoanga ʻaʻaku ia. ");
INSERT INTO ton_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Ko e ʻaho ʻe ono ʻe fai ai ʻae ngāue: ka ko hono fitu ʻoe ʻaho ko e Sāpate mālōlō ia, ko e fakataha māʻoniʻoni; ʻoua naʻa mou fai ai ha ngāue ʻe taha; he ko e ʻaho tapu ia ʻo Sihova ʻi homou ngaahi fale kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","¶ Ko e ngaahi kātoanga eni ʻa Sihova, ʻio, ʻae ngaahi kātoanga māʻoniʻoni, ʻaia te mou fanongonongo ʻi honau ngaahi faʻahitaʻu. ");
INSERT INTO ton_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","‌ʻI he efiafi ʻo hono hongofulu ma fā ʻoeʻaho ʻoe ʻuluaki māhina, ko e Lakaatu ʻo Sihova ia. ");
INSERT INTO ton_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Pea ʻi hono hongofulu ma nima ʻoe ʻaho ʻi he māhina ko ia, ko e kātoanga kai mā taʻefakalēvani kia Sihova; ke mou kai mā taʻefakalēvani ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ke mou fai ʻae fakataha māʻoniʻoni ʻi he ʻuluaki ʻaho: ʻoua naʻa fai ha ngāue faʻiteliha ʻi ai. ");
INSERT INTO ton_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ka mou ʻatu ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova ʻi he ʻaho ʻe fitu: ko hono fitu ʻoe ʻaho ko e kātoanga māʻoniʻoni; ʻoua naʻa mou fai ha ngāue faʻiteliha ʻi ai. ");
INSERT INTO ton_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Lea ki he fānau ʻa ʻIsileli, ʻo pehē kiate kinautolu, ʻOka mou ka hoko atu ki he fonua ʻoku ou foaki kiate kimoutolu, pea ʻoku mou tuʻusi hono ngaahi fua, te mou toki ʻomi ʻae faluku ʻe taha ʻoe ʻuluaki fua ʻo hoʻo ngoue ki he taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Pea ʻe taʻaloʻalo ʻaki ʻe ia ʻae faluku ʻoe koane ʻi he ʻao ʻo Sihova, ke maʻu ia koeʻuhi ko koe: ʻi he pongipongi ʻi he hili ʻae Sāpate ʻe taʻaloʻalo ʻaki ia ʻe he taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Pea te mou ʻatu ʻi he ʻaho ko ia ʻoku mou taʻaloʻalo ʻaki ʻae faluku ʻoe koane, ʻae lami tangata taʻehanomele ʻi hono ʻuluaki taʻu, ko e feilaulau tutu kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Pea ko e feilaulau meʻakai ʻo ia ko e oma ʻe ua ʻoe mahoaʻa lelei mo e lolo, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova, ko e meʻa namu kakala; pea ko e feilaulau inu ʻo ia ko e uaine, ko hono fā ʻoe vahe ʻoe hini. ");
INSERT INTO ton_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Pea ʻe ʻikai te mou kai ʻae mā pe ko e uite tunu, pe ko e fua mata, kaeʻoua ke hokosia ʻae ʻaho ko ia ʻoku mou ʻomi ai ha feilaulau ki homou ʻOtua: ko e fekau fai maʻu ia ʻi homou ngaahi toʻutangata ʻi homou ngaahi nofoʻanga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","¶ Pea ke mou lau kiate kimoutolu mei he pongipongi ʻi he hili ʻae Sāpate, mei he ʻaho naʻa mou ʻomi ai ʻae faluku ʻoe feilaulau ke taʻaloʻalo ʻaki; ʻe kātoa ʻae Sāpate ʻe fitu: ");
INSERT INTO ton_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","‌ʻIo, ʻo hoko mo e pongipongi ʻi he hili hono fitu ʻoe Sāpate ke mou lau ʻae ʻaho ʻe nimangofulu; pea ke mou ʻatu ʻae feilaulau foʻou ʻoe meʻakai kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ke mou ʻomi mei homou ngaahi fale ʻae foʻi mā taʻaloʻalo ʻe ua ʻoe oma ʻe ua: ʻe ngaohi ʻaki ia ʻae mahoaʻa lelei; ʻe taʻo ia mo e lēvani; ko e ʻuluaki fua ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pea ke mou ʻatu fakataha mo e mā ʻae lami ʻe fitu taʻehanaumele, ʻi he ʻuluaki taʻu, mo e pulu mui ʻe taha, mo e sipitangata ʻe ua: ko e feilaulau tutu ia kia Sihova, fakataha mo ʻenau ngaahi feilaulau meʻakai, mo e feilaulau inu, ʻio, ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Pea ke mou feilaulau ʻaki ʻae ʻuhikiʻi kosi ʻe taha ko e feilaulau maʻae angahala, mo e lami ʻe ua ʻoe ʻuluaki taʻu ko e feilaulau fakamelino. ");
INSERT INTO ton_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Pea ʻe taʻaloʻalo ʻaki ia ʻe he taulaʻeiki fakataha mo e mā ʻoe ʻuluaki fua, mo e ongo lami ko e feilaulau taʻaloʻalo ʻi he ʻao ʻo Sihova; ʻe māʻoniʻoni ia kia Sihova maʻae taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Pea ke mou fanongonongo ʻi he ʻaho pe ko ia, ke ʻiate kimoutolu ia ko e fakataha māʻoniʻoni; ʻoua naʻa mou fai ha ngāue faʻiteliha ʻi ai: ko e fekau fai maʻu ia ʻi homou ngaahi fale nofoʻanga kotoa pē ʻi homou toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","¶ Pea ʻoka ke ka tuʻusi ʻae ngaahi fua ʻo ho fonua, ʻo ʻikai te ke fetuku ke ʻosi mei he ngaahi tuliki ʻo hoʻo ngoue ʻoka ke ka tuʻusi ia, pea ʻe ʻikai te ke tānaki ʻae toenga ʻo hoʻo fua: ka te ke tuku ia ki he masiva, pea ki he muli: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, ʻI hono fitu ʻoe māhina, ʻi he ʻuluaki ʻaho ʻoe māhina, ʻe ʻiate kimoutolu ʻae Sāpate, ko e fakamanatu ʻoe ifi meʻa lea, ko e fakataha māʻoniʻoni. ");
INSERT INTO ton_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","‌ʻE ʻikai te mou fai ha ngāue faʻiteliha ʻi ai: ka te mou ʻatu ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","‌ʻI hono hongofulu foki ʻoe ʻaho ʻo hono fitu ʻoe māhina ni ʻe ai ʻae ʻaho ʻoe fakalelei: ko e ʻaho ia ʻoe fakataha māʻoniʻoni kiate kimoutolu; pea ke mou fakamamahi homou laumālie, pea ʻatu ha feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Pea ʻe ʻikai te mou fai ha ngāue ʻi he ʻaho ko ia: he ko e ʻaho ia ʻoe fakalelei, ke fai ai ʻae fakalelei maʻamoutolu ʻi he ʻao ʻo Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","He ko ia ʻoku ʻikai fakamamahiʻi ia ʻi he ʻaho ko ia, ʻe motuhi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Pea ko ia ʻe fai ha ngāue ʻi he ʻaho ko ia, te u tāmateʻi ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","‌ʻE ʻikai te mou fai ha momoʻi ngāue; ko e fekau fai maʻu ia ʻi homou ngaahi toʻutangata ʻi homou ngaahi nofoʻanga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","‌ʻE ʻiate kimoutolu ia ko e Sāpate ʻoe mālōlō, pea te mou fakamamahi homou laumālie: ʻi hono hiva ʻoeʻaho ʻoe māhina ʻi he efiafi, mei he efiafi ʻo aʻu ki he efiafi, ke mou tauhi homou Sāpate. ");
INSERT INTO ton_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Lea ki he fānau ʻa ʻIsileli, ʻo pehē, Ko hono hongofulu ma nima ʻoe ʻaho ʻa hono fitu ʻoe māhina ni ʻe hoko ia ko e kātoanga kia Sihova ʻoe ngaahi fale fehikitaki, ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","‌ʻI he ʻuluaki ʻaho ke mou fai ʻae fakataha māʻoniʻoni; ʻoua naʻa mou fai ha ngāue faʻiteliha ʻi ai. ");
INSERT INTO ton_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ko e ʻaho ʻe fitu ke mou ʻatu ai ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ʻi hono valu ʻoe ʻaho ke mou fai ʻae fakataha māʻoniʻoni: pea te mou ʻatu ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova: ko e fakataha mamalu: pea ʻe ʻikai te mou fai ha ngāue faʻiteliha ʻi ai. ");
INSERT INTO ton_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Ko e ngaahi kātoanga eni ʻa Sihova, ʻaia ke mou fakahā ko e ngaahi fakataha māʻoniʻoni, ke ʻatu ai ʻae feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova, ko e feilaulau tutu, mo e feilaulau meʻakai, mo e feilaulau meʻainu, taki taha pe ʻi hono ʻaho: ");
INSERT INTO ton_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Kaeʻumaʻā foki ʻae ngaahi Sāpate ʻo Sihova, pea mo hoʻomou ngaahi foaki, mo hoʻomou ngaahi fuakava, mo e ngaahi feilaulau ʻoku fai loto lelei pe, ʻaia ʻoku mou foaki kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Pea ʻi hono hongofulu ma nima foki ʻoe ʻaho ʻi hono fitu ʻoe māhina, hili hoʻomou tānaki ʻae fua ʻoe fonua, ke mou fai ha kātoanga kia Sihova ʻi he ʻaho ʻe fitu: ko hono ʻuluaki ʻaho, ko e Sāpate ia, pea ko hono valu ʻoe ʻaho ʻe Sāpate mo ia. ");
INSERT INTO ton_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Pea te mou fili ʻekimoutolu ʻae ngaahi vaʻa ʻoe ʻakau matamatalelei, ʻae ngaahi vaʻa ponga, mo e ngaahi vaʻa ʻoe ʻakau lalahi, mo e ngaahi uilou ʻoe vaitafe; pea te mou fiefia ʻi he ʻao ʻo Sihova ko homou ʻOtua ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Pea ke mou tauhi ia ko e kātoanga kia Sihova ʻi he ʻaho ʻe fitu ʻi he taʻu. Ko e fekau fai maʻu ia ʻi homou ngaahi toʻutangata: ke mou fai ia ʻi hono fitu ʻoe māhina. ");
INSERT INTO ton_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ke mou nofo ʻi he ngaahi fale louʻakau ʻi he ʻaho ʻe fitu; ko kinautolu kotoa pē kuo fanauʻi ko e ʻIsileli ʻe nofo ia ʻi he fale louʻakau: ");
INSERT INTO ton_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Koeʻuhi ke ʻilo ʻe homou ngaahi toʻutangata naʻaku puleʻi ʻae fānau ʻa ʻIsileli ke nofo ʻi he ngaahi fale fehikitaki, ʻi heʻeku ʻomi ʻakinautolu mei he fonua ko ʻIsipite: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Pea naʻe fakahā ʻe Mōsese ki he fānau ʻa ʻIsileli ʻae ngaahi kātoanga ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Fekau ki he fānau ʻa ʻIsileli, koeʻuhi kenau ʻomi kiate koe ʻae lolo ʻolive lelei kuo tuki ki he maama, koeʻuhi ke ulo lelei maʻuaipē ʻae maama. ");
INSERT INTO ton_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","‌ʻE teuteu ia ʻe ʻElone ʻituʻa ʻi he puipui ʻoe fuakava ʻi he fale fehikitaki ʻoe kakai, mei he efiafi ki he pongipongi ʻe fai maʻuaipē ia ʻi he ʻao ʻo Sihova; ko e fekau fai maʻu pe ia ʻi homou toʻutangata kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ke te u maʻuaipē ʻe ia ʻae ngaahi foʻi maama ki he tuʻunga maama tapu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","¶ Pea ke toʻo ʻae mahoaʻa lelei, ʻo ngaohi ʻaki ʻae foʻi mā ʻe hongofulu ma ua: ʻe ʻai ʻae oma ʻe ua ʻi he foʻi mā pe taha. ");
INSERT INTO ton_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Pea te ke fokotuʻu ia ʻi he ʻotu ʻe ua, ke taki ono ʻi he ʻotu pe taha, ki he palepale māʻoniʻoni ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Pea te ke ʻai ki he ʻotu fakatouʻosi pe ʻae laipeno moʻonia, koeʻuhi ke ʻi he mā ia ko e meʻa fakamanatu, ʻio, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","‌ʻE ʻai ia ʻo teuteu ʻi he ʻao ʻo Sihova ʻo fai maʻu pe ʻi he Sāpate kotoa pē, kuo toʻo ia mei he fānau ʻa ʻIsileli ʻi he fuakava ʻoku taʻengata. ");
INSERT INTO ton_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Pea ʻe ʻia ʻElone ia mo hono ngaahi foha; pea kenau kai ia ʻi he potu māʻoniʻoni: he ko e meʻa māʻoniʻoni lahi kiate ia ʻi he ngaahi feilaulau kia Sihova kuo ngaohi ʻaki ʻae afi ʻi he fekau tuʻumaʻu. ");
INSERT INTO ton_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","¶ Pea naʻe ʻalu kituaʻā mo e fānau ʻa ʻIsileli ʻae tama ʻae fefine ʻIsileli, ka ko ʻene tamai ko e tangata ʻIsipite; pea ko e tama ʻae fefine ʻIsileli, mo e tangata ʻIsileli, naʻa na fekuki fakataha ʻi he ʻapitanga: ");
INSERT INTO ton_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Pea naʻe kape ʻae tama ʻae fefine ʻIsileli ki he huafa ʻo Sihova ʻo lea kovi. Pea naʻa nau ʻomi ia kia Mōsese, (pea ko e hingoa ʻo ʻene faʻē, ko Selomiti, ko e ʻofefine ʻo Tipili ʻi he faʻahinga ʻo Tani:) ");
INSERT INTO ton_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Pea naʻa nau tuku haʻisia ia, ke ʻoua ke nau ʻilo ʻae finangalo ʻo Sihova ki ai. ");
INSERT INTO ton_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Ko ia kuo kape, ʻomi ia kituaʻā mei he ʻapitanga; pea ko kinautolu kotoa pē naʻe fanongo ki ai ke hilifaki honau nima ki hono ʻulu, pea ke tolongaki ia ʻe he fakataha kotoa pē ʻaki ʻae maka. ");
INSERT INTO ton_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Pea ke lea koe ki he fānau ʻa ʻIsileli, ʻo pehē, Ko ia ʻoku kapeʻi hono ʻOtua ʻe fua ʻe ia ʻene angahala. ");
INSERT INTO ton_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Pea ko ia ʻoku ne kapeʻi ʻae huafa ʻo Sihova, ko e moʻoni ʻe tāmateʻi ia, ʻe tolongaki ia ʻaki ʻae maka ʻe he kakai kotoa pē: ko e muli ia pe ko ia kuo tupu ʻi he fonua, ʻoka kapeʻi ʻe ia ʻae huafa ʻo Sihova ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","¶ “Pea ko ia ʻoku ne tāmateʻi ha tangata ʻe tāmateʻi moʻoni ia. ");
INSERT INTO ton_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Pea ko ia ʻoku ne tāmateʻi ha manu ʻe totongi ke tatau ia; ko e manu ki he manu. ");
INSERT INTO ton_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Pea kapau ʻe fakameleʻi ʻe ha tangata hono kaungāʻapi ʻe fai kiate ia ʻo hangē ko ia kuo ne fai ");
INSERT INTO ton_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ko e lavea ki he lavea, ko e mata ki he mata, ko e nifo ki he nifo: ʻo hangē ko ʻene fakameleʻi ha tangata, ʻe pehē pe hono fai kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Pea ko ia ʻoku ne tāmateʻi ha manu, ʻe ʻatu ke tatau ia: pea ko ia ʻoku ne tāmateʻi ha tangata, ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ke mou maʻu ʻae fono pe taha, ki he muli, mo ia ʻoku ʻi homou fonua: he ko au ko Sihova ko homou ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","¶ Pea naʻe lea ʻa Mōsese ki he fānau ʻa ʻIsileli, koeʻuhi kenau ʻomi ʻaia naʻe kape kituaʻā mei he ʻapitanga, ʻo tolongaki ʻaki ia ʻae maka. Pea naʻe fai ʻe he fānau ʻa ʻIsileli ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese ʻi he moʻunga ko Sainai, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Lea ki he fānau ʻa ʻIsileli, mo ke pehē kiate kinautolu, ʻOka mou ka hoko atu ki he fonua ʻaia ʻoku ou foaki kiate kimoutolu, ʻe toki fai ai ʻe he fonua ʻae Sāpate kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Ko e taʻu ʻe ono ke ke tō ai hoʻo ngoue, mo e taʻu ʻe ono ke ke ʻauhani hoʻo ngoue vaine, ʻo tānaki hono fua; ");
INSERT INTO ton_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Ka ko hono fitu ʻoe taʻu ko e Sāpate ia ke mālōlō ai ʻae fonua, ko e Sāpate ia kia Sihova: ʻoua naʻa ke tō ai hoʻo ngoue, pe ʻauhani hoʻo ngoue vaine. ");
INSERT INTO ton_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ko ia ʻoku tupu ʻiate ia pe ʻi he ngaahi fua ʻo hoʻo taʻu ʻoua naʻa ke tuʻusi, pe toli ʻae ngaahi kālepi ʻoe vaine taʻeʻauhani he ko e taʻu mālōlō ia ki ho fonua. ");
INSERT INTO ton_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pea ko e Sāpate ʻoe fonua ko e meʻakai ia maʻamoutolu; kiate koe, pea ki hoʻo tamaioʻeiki, pea ki hoʻo kaunanga, pea ki hoʻo tamaioʻeiki unga ngāue, pea ki he muli ʻoku ʻāunofo kiate koe, ");
INSERT INTO ton_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Pea ki hoʻo fanga manu lahi, pea ki hoʻo fanga manu ʻi ho fonua kotoa pē, ko ia kotoa pē ʻoku tupu ko e meʻakai ia kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","¶ Pea ke lau kiate koe ʻae Sāpate ʻe fitu ʻoe ngaahi taʻu; ko e taʻu ʻe fitu lau ʻe fitu; pea ko hono lau ʻoe Sāpate ʻe fitu ʻoe ngaahi taʻu ko e taʻu ʻe fāngofulu ma hiva. ");
INSERT INTO ton_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Pea te ke toki fekau ke ifi ʻae meʻa lea ʻoe siupeli ʻi hono hongofulu ʻoe ʻaho ʻi hono fitu ʻoe māhina, ʻi he ʻaho ʻoe fakalelei ke mou fakaongo atu ʻae meʻa lea ʻi homou fonua kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pea ke mou fakatapui hono nimangofulu ʻoe taʻu, ʻo fakahā ʻae huhuʻi ʻi he fonua kotoa pē ki hono kakai kotoa pē; ʻe ʻiate kimoutolu ia ko e siupeli: pea ʻe toe hoko ʻae tangata taki taha kotoa pē ki hono ʻapi, pea ʻe toe haʻu taki taha ʻae tangata ki hono fale. ");
INSERT INTO ton_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ko e nimangofulu taʻu ko ia ʻe ʻiate kimoutolu ia ko e siupeli: ʻoua naʻa mou tūtuuʻi, pe tuʻusi ʻaia ʻoku tupu ʻiate ia pe, pe tānaki mei he vaine ʻoku taʻeʻauhani. ");
INSERT INTO ton_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","He ko e siupeli ia; ʻe māʻoniʻoni ia kiate kimoutolu: te mou kai ʻa hono fua ʻo ia mei he ngoue pe. ");
INSERT INTO ton_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Pea ʻi he taʻu ʻoe siupeli ni ʻe toe haʻu ʻae tangata taki taha kotoa pē ki hono tofiʻa, ");
INSERT INTO ton_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Pea kapau ʻoku ke fakatau ha meʻa ki ho kaungāʻapi, pe fakatau ha meʻa meiate ia, ʻoua naʻa mou fefakamamahiʻaki ʻakimoutolu: ");
INSERT INTO ton_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ke ke fakatau mei ho kaungāʻapi ʻo fakatatau ki hono lau ʻoe taʻu ʻi he hili ʻae siupeli, pea te ne fakatau kiate koe ʻo fakatatau ki hono lau ʻoe taʻu ʻo hono ngaahi fua: ");
INSERT INTO ton_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Te ke fakalahi ʻa hono totongi ʻo fakatatau mo hono lahi ʻoe taʻu, pea ke fakasiʻisiʻi hono totongi ʻo fakatatau ki hono siʻi ʻoe taʻu: he ʻoku ne fakatau ia kiate koe ʻo fakatatau ki hono lau ʻoe taʻu ʻo hono fua ʻo ia. ");
INSERT INTO ton_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ko ia ʻoua naʻa mou fefakamamahiʻaki ʻakimoutolu; ka ke manavahē ki ho ʻOtua; he ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","¶ Ko ia ke mou fai ʻeku ngaahi fekau, pea tauhi ʻeku ngaahi tuʻutuʻuni, ʻo fai ki ai; pea te mou nofo malu pe ʻi he fonua. ");
INSERT INTO ton_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Pea ʻe tupu ʻi he fonua hono fua, pea te mou kai ʻo mākona, ʻo nofo ʻi ai ʻi he fiemālie. ");
INSERT INTO ton_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Pea kapau ʻoku mou pehē, Ko e hā te mau kai ʻi hono fitu ʻoe taʻu? Koeʻuhi ʻe ʻikai te mau tūtuuʻi, pe tānaki ʻemau fua: ");
INSERT INTO ton_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Teu toki fekau ʻeku tāpuaki kiate kimoutolu ʻi hono ono ʻoe taʻu, pea ʻe tupu ʻi ai ʻae fua ʻo feʻunga mo e taʻu ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Pea te mou tūtuuʻi ʻi hono valu ʻoe taʻu, kae kai ʻae fua motuʻa ʻo aʻu ki hono hiva ʻoe taʻu: te mou kai ʻae meʻakai motuʻa kaeʻoua ke hoko ʻa hono toʻukai. ");
INSERT INTO ton_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","¶ ʻE ʻikai fakatau ʻae fonua ʻo taʻengata: he ʻoku ʻoʻoku ʻae fonua; he ko e kau muli mo e ʻāunofo ʻakimoutolu kiate au. ");
INSERT INTO ton_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Pea ʻi he fonua kotoa pē ʻoku mou maʻu te mou tuku ke huhuʻi ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","¶ Kapau kuo fakaʻaʻau ʻo masiva ʻa ho kāinga, pea kuo ne fakatau ha potu ʻo hono ʻapi, pea kapau ʻe haʻu ha niʻihi ʻi hono kāinga ke huhuʻi ia, ke ne huhuʻi ai ʻaia naʻe fakatau ʻe hono kāinga. ");
INSERT INTO ton_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Pea kapau ʻoku ʻikai ʻi he tangata ha tokotaha ke huhuʻi ia, pea ʻoku faʻa huhuʻi ia ʻe ia pe; ");
INSERT INTO ton_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Tuku ai ke ne lau ʻe ia ʻae ngaahi taʻu ʻo hono fakatau ʻo ia, pea ʻatu hono toe ʻo ia ki he tangata naʻa ne fakatau ia ki ai; koeʻuhi ke toe haʻu ia ki hono ʻapi. ");
INSERT INTO ton_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pea kapau ʻoku ʻikai mafai ʻe ia ke toe ʻomi ia kiate ia, pea ko e meʻa naʻe fakatau ʻe tuku pe ia ʻi he nima ʻo ia naʻa ne fakatau ia ʻo aʻu ki he taʻu ʻoe siupeli: pea ʻi he siupeli ʻe tukuange ia, pea ʻe haʻu ia ki hono ʻapi. ");
INSERT INTO ton_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Pea kapau ʻoku fakatau ʻe ha tangata ha fale nofoʻanga ʻi loto kolo ʻoku ai hano ʻā maka, ʻe ngofua ʻa ʻene huhuʻi ia ʻi he ʻikai ʻosi ʻae taʻu kotoa hili hono fakatau: ʻi he taʻu kotoa ʻe ngofua ʻa ʻene huhuʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pea kapau ʻe ʻikai huhuʻi ia ʻi he taʻu kātoa, pea ko e fale ko ia ʻoku ʻi he kolo ʻā maka ʻe ʻoʻona ia naʻa ne fakatau ia ʻo taʻengata ʻi hono ngaahi toʻutangata; ʻe ʻikai toe tukuange ia ʻi he siupeli. ");
INSERT INTO ton_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ka ko e ngaahi fale ʻi he ngaahi potu kakai ʻoku ʻikai hanau ʻā, ʻe lau ia fakataha mo e ngaahi ngoue ʻoe fonua: ʻe ngofua ke huhuʻi ia, pea ʻe tukuange ia ʻi he siupeli. ");
INSERT INTO ton_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ka ko e ngaahi potu nofoʻanga ʻoe kau Livai, mo e ngaahi fale ʻi he ngaahi potu nofoʻanga ʻo honau ʻapi, ʻe ngofua ki he kau Livai, ke huhuʻi ia ʻi he kuonga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Pea kapau ʻoku fakatau ʻe ha tangata mei he kau Livai, pea ko e fale naʻe fakatau, mo e potu kakai ʻo hono ʻapi, ʻe tukuange ia ʻi he siupeli: he ko e ngaahi fale ʻoe ngaahi potu kakai ʻoe kau Livai, ko honau ʻapi ia ʻi he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Ka ko e ngoue ʻoku hoko ʻo ofi mo honau ngaahi potu kakai, ʻe ʻikai fakatau ia: he ko honau tofiʻa tuʻumaʻu ia. ");
INSERT INTO ton_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","¶ Pea kapau kuo hoko ʻo masiva ʻa ho kāinga, pea kuo vaivai ia; pea te ke tokoni ia; neongo pe ko e muli ia pe ko ha ʻāunofo kiate koe; koeʻuhi ke ne moʻui ai mo koe. ");
INSERT INTO ton_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","‌ʻOua naʻa ke toʻo ha totongi ʻiate ia, pe hano tupu; ka ke manavahē ki he ʻOtua; koeʻuhi ke moʻui ho kāinga mo koe. ");
INSERT INTO ton_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","‌ʻOua naʻa ke ʻatu hoʻo koloa kiate ia ke maʻu ai ʻae totongi, pe nō hoʻo meʻakai ke maʻu ai hono tupu. ");
INSERT INTO ton_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ko au ko Sihova ko homou ʻOtua, kuo u ʻomi ʻakimoutolu mei he fonua ko ʻIsipite, ke foaki kiate kimoutolu ʻae fonua ko Kēnani, pea ke u hoko ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","¶ Pea kapau kuo hoko ʻo masiva ho kāinga ʻoku nofo ofi kiate koe, pea fakatau ʻe ia ia kiate koe: ʻoua naʻa ke fakapōpulaʻi ia ke fai ʻo hangē ha hopoate; ");
INSERT INTO ton_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ka ʻe ʻiate koe ia ʻo hangē ha tamaioʻeiki ʻoku ngāue ki ha totongi, mo e ʻāunofo, pea te ne ʻiate koe ko e tauhi ʻo aʻu ki he taʻu ʻoe siupeli: ");
INSERT INTO ton_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Pea ʻe toki ʻalu ia ʻiate koe, ʻaia mo ʻene fānau mo ia, pea ʻe toe hoko atu ia ki hono kāinga, pea ʻe hoko ki he ʻapi ʻo ʻene ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","He ko ʻeku kau tamaioʻeiki ʻakinautolu, ʻaia naʻaku ʻomi mei he fonua ko ʻIsipite: ʻoua naʻa fakatau ʻakinautolu ke fakapōpulaʻi. ");
INSERT INTO ton_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","‌ʻE ʻikai te ke puleʻi ʻakinautolu ʻi he mālohi lahi; ka ke manavahē ki ho ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Ko hoʻo kau tamaioʻeiki mo hoʻo kau kaunanga ʻaia te ke maʻu, ʻe maʻu ia mei he kakai taʻelotu ʻoku nofo takatakai ʻiate koe; ke mou fakatau ʻiate kinautolu ʻae kau tamaioʻeiki mo e kau kaunanga. ");
INSERT INTO ton_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Pea koeʻuhi ko e fānau ʻae kau muli ʻoku ʻāunofo ʻiate kimoutolu, te mou fakatau ʻiate kinautolu, pea ʻi honau ngaahi faʻahinga ʻoku ʻiate kimoutolu, ʻaia naʻa nau fakatupu ʻi homou fonua: pea ko homou kakai ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Pea ke mou maʻu ʻakinautolu ko e kakai ki hoʻomou fānau ʻoku muimui ʻiate kimoutolu, kenau maʻu ʻakinautolu ko honau kakai; ko hoʻomou kau tamaioʻeiki ʻo taʻengata; ka ʻe ʻikai te mou pule mālohi ki he fānau ʻa ʻIsileli ko homou kāinga, ko e taha ki he taha. ");
INSERT INTO ton_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","¶ Pea kapau ʻe fakaʻaʻau ʻo koloaʻia ha ʻāunofo, pe ha muli ʻoku nofo ofi kiate koe, pea fakaʻaʻau ʻo masiva ho kāinga ʻoku nofo ofi kiate ia, ʻo ne fakatau ia ki he muli pe ko e ʻāunofo ʻoku nofo ʻāunofo ofi kiate ia, pe ki ha tokotaha ʻi he hako ʻoe muli: ");
INSERT INTO ton_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Hili hono fakatau ia ʻoku ngofua ke huhuʻi ia: ʻoku ngofua ke huhuʻi ia ʻe ha tokotaha ʻi hono kāinga. ");
INSERT INTO ton_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","‌ʻE ngofua ke huhuʻi ia ʻe he tokoua ʻo ʻene tamai, pe ko e foha ʻoʻona, pe huhuʻi ia ʻe ha tokotaha ʻoku kāinga ofi kiate ia ʻi hono kāinga; pea kapau ʻoku ne mafai, ke huhuʻi ia ʻe ia pe. ");
INSERT INTO ton_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Pea te ne lau kiate ia naʻa ne fakatau ia ʻo fai mei he taʻu naʻe fakatau ai ia kiate ia ʻo hoko ki he taʻu ʻoe siupeli: pea ko e totongi ʻoe fakatau ʻe fakatatau ki hono lau ʻoe taʻu, ʻe fakatatau ia kiate ia mo e ngāue ʻae tamaioʻeiki ʻoku totongi. ");
INSERT INTO ton_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kapau ʻoku toe lahi ʻae taʻu kimui, ʻe toe ʻatu ʻe ia ʻo fakatatau ki ai ʻae koloa ʻo hono huhuʻi mei he koloa naʻe fakatauʻaki ia. ");
INSERT INTO ton_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Pea kapau ʻoku toe siʻi pe ʻae taʻu ki he siupeli, pea ʻe lau ia ki ai mo ia, pea ʻe toe ʻatu kiate ia ʻo fakatatau ki hono taʻu ʻae totongi ʻo hono huhuʻi. ");
INSERT INTO ton_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Pea ʻe ʻiate ia ia ʻo hangē ha tamaioʻeiki ngāue ʻoku totongi ʻi he taʻu taki taha; pea ʻe ʻikai puleʻi mālohi ia kiate ia ʻi ho ʻao. ");
INSERT INTO ton_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Pea kapau ʻe ʻikai huhuʻi ia ʻi he ngaahi taʻu ko ia, pea ʻe toki tukuange ia ʻi he taʻu ʻoe siupeli, ʻa ia, mo ʻene fānau mo ia. ");
INSERT INTO ton_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","He ko e kau tamaioʻeiki kiate au ʻae fānau ʻa ʻIsileli; ko ʻeku kau tamaioʻeiki ʻakinautolu, ʻaia kuo u ʻomi mei he fonua ko ʻIsipite: Ko au ko Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“E ʻikai te mou ngaohi hamou ʻotua loi, pe ha fakatātā kuo tongitongi, pea ʻoua naʻa mou fokotuʻu hake ha meʻa fakatātā ke tuʻu, pea ʻe ʻikai te mou fokotuʻu hake ha fakatātā maka ʻi homou fonua, ke punou hifo ki ai: he ko au Sihova ko homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","¶ “Ke mou tauhi hoku ngaahi Sāpate, pea fai fakaʻapaʻapa ki hoku faletapu: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","¶ “Kapau ʻoku mou ʻalu ʻi heʻeku ngaahi tuʻutuʻuni, pea tauhi ʻeku ngaahi fekau, pea fai ki ai; ");
INSERT INTO ton_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Te u tuku ai kiate kimoutolu ʻae ʻuha ʻi hono faʻahitaʻu lelei, pea ʻe tupu ʻi he fonua ʻa hono fua, pea ʻe tupu mei he ngaahi ʻakau ʻoe ngoue honau ngaahi fua. ");
INSERT INTO ton_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Pea ʻe hoko atu homou kuonga haha ki he tataʻo ʻoe vaine, pea ko e tataʻo vaine ʻe hoko atu ia ki he tūtuuʻi: pea te mou kai hoʻomou mā pea mākona, pea nofo fiemālie pe ʻi homou fonua. ");
INSERT INTO ton_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Pea te u foaki ʻae melino ki he fonua, pea te mou tokoto hifo, pea ʻe ʻikai fakamanavahēʻi ʻakimoutolu ʻe ha tokotaha: pea te u fakaseʻeseʻe ʻae fanga manu kovi mei he fonua, pea ʻe ʻikai ʻalu ʻae heletā ʻo ʻasi ʻi homou fonua. ");
INSERT INTO ton_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Pea te mou tuli homou ngaahi fili, pea tenau tō ʻi he heletā ʻi homou ʻao. ");
INSERT INTO ton_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Pea ʻe tuli ʻe homou toko nima ʻae toko teau, pea ko e toko teau ʻomoutolu ʻe hola ai ʻae toko mano: pea ʻe hinga homou ngaahi fili ʻi homou ʻao ʻi he heletā. ");
INSERT INTO ton_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","He teu tokanga kiate kimoutolu, ʻo tāpuaki ʻakimoutolu, ʻo fakatokolahi ʻakimoutolu, ʻo fakatuʻumaʻu ʻeku fuakava mo kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Pea te mou kai ʻae meʻa motuʻa, pea ʻomi ʻae meʻa motuʻa koeʻuhi ko e meʻa foʻou. ");
INSERT INTO ton_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Pea te u fokotuʻu hoku fale fehikitaki ʻiate kimoutolu: pea ʻe ʻikai fehiʻa hoku laumālie kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Pea te u ʻeveʻeva ʻiate kimoutolu, pea ko homou ʻOtua au, pea te mou hoko ko hoku kakai. ");
INSERT INTO ton_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ko au ko Sihova ko homou ʻOtua, ʻaia naʻe ʻomi ʻakimoutolu mei he fonua ko ʻIsipite, koeʻuhi ke ʻoua naʻa mou nofo pōpula kiate kinautolu; pea naʻaku fesiʻi ʻae noʻo ʻo hoʻomou haʻamonga, ʻo ngaohi ʻakimoutolu ke mou ʻalu totonu. ");
INSERT INTO ton_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","¶ “Pea kapau ʻe ʻikai te mou tokanga kiate au, pea ʻikai fai ʻae ngaahi fekau ni; ");
INSERT INTO ton_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Pea kapau te mou liʻaki ʻeku ngaahi tuʻutuʻuni ni, pea kapau ʻe fehiʻa homou laumālie ki heʻeku ngaahi fakamaau, pea ʻikai te mou fai ʻeku ngaahi fekau kotoa pē, ka mou liʻaki ʻeku fuakava: ");
INSERT INTO ton_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Ko au foki te u fai eni kiate kimoutolu; Te u tuku kiate kimoutolu ʻae fakailifia, mo e fakaʻauʻausino, mo e pupuke vela, ʻaia ʻe fakakui ai ho mata, pea ne langaʻi ʻae mamahi ʻi loto: pea te mou tūtuuʻi taʻeʻaonga hoʻomou ngaahi tenga, koeʻuhi ʻe kai ia ʻe homou ngaahi fili. ");
INSERT INTO ton_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Pea te u sio fakafulofula kiate kimoutolu, pea ʻe tāmateʻi ʻakimoutolu ʻi he ʻao ʻo homou ngaahi fili: ʻe pule kiate kimoutolu ʻakinautolu ʻoku fehiʻa kiate kimoutolu; pea te mou hola ka ʻoku ʻikai tuli ʻakimoutolu ʻe ha tokotaha. ");
INSERT INTO ton_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Pea kapau te mou liʻaki kotoa pē ia, ʻo ʻikai siʻi tokanga kiate au, pea te u toki tautea ʻakimoutolu ke tā tuʻo fitu ʻi hoʻomou ngaahi angahala. ");
INSERT INTO ton_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Pea te u fesiʻi ʻae laukau ʻo homou mālohi; pea te u ngaohi homou langi ke hangē ko e ukamea, mo homou kelekele ke hangē ko e palasa: ");
INSERT INTO ton_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Pea ʻe fakaʻosi taʻeʻaonga homou mālohi: koeʻuhi ʻe ʻikai tuku hake ʻe he fonua hono tupu, pea ʻe ʻikai tupu ʻi he ngaahi ʻakau ʻoe fonua honau fua. ");
INSERT INTO ton_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","¶ “Pea kapau te mou ʻalu kehe pe, pea ʻikai tokanga kiate au; te u ʻomi kiate kimoutolu ʻae mamahi ke tā tuʻo fitu ʻo fakatatau mo hoʻomou ngaahi angahala. ");
INSERT INTO ton_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Pea te u ʻomi ʻae ngaahi manu fekai kiate kimoutolu, ʻaia ʻe kaihaʻasi hoʻomou fānau meiate kimoutolu, pea fakaʻauha hoʻomou fanga manu, ʻo fakatokosiʻi ʻakimoutolu; pea ʻe vaoa homou ngaahi hala motuʻa. ");
INSERT INTO ton_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Pea kapau ʻe ʻikai te mou tui kiate au ʻi he ngaahi meʻa ni ʻo liliu ai, ka mou angatuʻu kiate au; ");
INSERT INTO ton_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Pehē te u ʻalu hake foki kiate kimoutolu, pea te u tautea ʻakimoutolu ke tā tuʻo fitu ʻi hoʻomou ngaahi angahala. ");
INSERT INTO ton_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Pea te u ʻomi ʻae heletā kiate kimoutolu, ʻaia te ne totongi kiate kimoutolu ʻi hono maumauʻi ʻo ʻeku fuakava: pea ka mou ka kātoa fakataha ʻi hoʻomou ngaahi kolo, te u fekau ʻae mahaki lahi kiate kimoutolu; pea ʻe tukuange ʻakimoutolu ki he nima ʻoe fili. ");
INSERT INTO ton_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Pea hili ʻeku fesiʻi ʻae tokotoko ʻo hoʻomou mā, ko e kau fefine ʻe toko hongofulu tenau taʻo hoʻomou mā ʻi he ngotoʻumu pe taha, pea tenau toe ʻatu fakatuhotuha pe hoʻomou mā kiate kimoutolu: pea te mou kai, kae ʻikai mākona. ");
INSERT INTO ton_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Pea kapau ʻe ʻikai te mou tui kiate au neongo ʻa ʻeku fai eni kotoa pē, ka mou fai kehe pe kiate au: ");
INSERT INTO ton_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Pea te u toki ʻalu kehe pe au ʻiate kimoutolu ʻi he houhau lahi: pea ko au, ʻio, ko au te u tautea ʻakimoutolu ke tā tuʻo fitu ʻi hoʻomou ngaahi angahala. ");
INSERT INTO ton_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Pea te mou kai ʻae sino ʻo homou ngaahi foha, mo e sino ʻo homou ngaahi ʻofefine te mou kai. ");
INSERT INTO ton_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Pea te u maumauʻi homou ngaahi potu māʻolunga, pea tā hifo hoʻomou ngaahi meʻa fakatātā, ʻo laku homou ngaahi ʻangaʻanga ki he ʻangaʻanga ʻo homou ngaahi ʻotua loi, pea te u fakaliliʻa kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Pea te u ngaohi hoʻomou ngaahi kolo ke lala, pea te u tuku liʻaki pe homou ngaahi faletapu, pea ʻe ʻikai te u nanamu ki he namu kakala ʻo hoʻomou meʻa namu kakala. ");
INSERT INTO ton_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Pea te u fakalala ʻae fonua; pea ko homou ngaahi fili ʻaia ʻoku nofo ai tenau ofo ki ai. ");
INSERT INTO ton_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Pea te u fakahēʻi ʻakimoutolu ki he ngaahi fonua taʻelotu, pea teu toho ʻae heletā ke tuli ʻaki ʻakimoutolu: pea ʻe lala homou fonua, pea ʻe liʻaki homou ngaahi kolo. ");
INSERT INTO ton_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Pea ʻe toki maʻu mālie pe ʻe he fonua hono ngaahi Sāpate, lolotonga ʻa ʻene lala, ka ʻoku mou ʻi he fonua ʻo homou fili ʻakimoutolu; ʻio, ʻe toki mālōlō ʻae fonua, pea maʻu pe hono ngaahi Sāpate. ");
INSERT INTO ton_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Lolotonga hono tuku liʻaki ia ʻe mālōlō; koeʻuhi naʻe ʻikai mālōlō ia ʻi homou ngaahi Sāpate, lolotonga ʻa hoʻomou nofo ki ai. ");
INSERT INTO ton_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Pea kiate kinautolu ʻoku moʻui mo toe, ʻiate kimoutolu te u tuku ʻae vaivai ki honau loto ʻi he ngaahi fonua ʻo honau fili; pea ko e mumuhu ʻoe louʻakau vilingia te ne tulia ʻakinautolu; pea tenau hola ʻo hangē ko e hola mei he heletā; pea tenau hinga ʻi he ʻikai tuli ʻakinautolu ʻe ha tokotaha. ");
INSERT INTO ton_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Pea tenau tō ʻo fetaʻotaʻomi pe ʻakinautolu, ʻo hangē ko e tō ʻi he ʻao ʻoe heletā, ka ʻoku ʻikai ha tokotaha ʻoku tulia ʻakinautolu: pea ʻe ʻikai te mou maʻu ha mālohi ke tuʻu ʻi he ʻao ʻo homou fili: ");
INSERT INTO ton_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Pea te mou ʻauha ʻi he ngaahi fonua taʻelotu, pea ko e fonua ʻo homou ngaahi fili te ne kai ʻo ʻosi ʻakimoutolu. ");
INSERT INTO ton_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Pea ko kinautolu ʻoku toe ʻiate kimoutolu tenau fakaʻaʻau ʻo ʻosi ʻi heʻenau hia ʻi he fonua ʻo homou fili: pea ʻi he hia ʻa ʻenau ngaahi tamai foki tenau fakaʻaʻau ʻo mole ai. ");
INSERT INTO ton_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Kapau tenau vete ʻenau ngaahi hia, pea mo e hia ʻa ʻenau ngaahi tamai, mo ʻenau ngaahi fai hala ʻaia kuo nau angahala ai kiate au, pea pehē mai foki, kuo nau ʻalu ʻo angatuʻu kiate au; ");
INSERT INTO ton_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Pea kuo u ʻalu ʻo fai kehe kiate kinautolu, pea kuo u ʻomi ʻakinautolu ki he fonua ʻo honau fili; kapau kuo toki fakavaivai ʻa honau loto taʻekamu, pea nau maʻu loto lelei ʻae tautea ʻo ʻenau ngaahi hia: ");
INSERT INTO ton_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Pehē te u manatu ai ki heʻeku fuakava kia Sēkope, pea mo ʻeku fuakava mo ʻAisake, pea mo ʻeku fuakava foki mo ʻEpalahame te u manatuʻi; pea te u manatuʻi ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","‌ʻE tuku liʻaki pe foki ʻae fonua ʻekinautolu, pea te ne maʻu mālie hono ngaahi Sāpate, ʻi heʻene tuku liʻaki pe ʻekinautolu: pea tenau tali lelei ʻae tautea ʻo ʻenau hia: koeʻuhi, ʻio, ko e meʻa ʻi heʻenau liʻaki ʻeku ngaahi fono, pea ko e meʻa ʻi heʻenau fehiʻa ki heʻeku ngaahi tuʻutuʻuni. ");
INSERT INTO ton_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ka neongo ʻa eni kotoa pē, ʻoka nau ka ʻi he fonua ʻo honau fili, ʻe ʻikai te u liʻaki ʻakinautolu, pea ʻe ʻikai te u fehiʻa kiate kinautolu, ke fakaʻosi ʻaupito ʻakinautolu, pea ke liʻaki ʻeku fuakava mo kinautolu: he ko au ko Sihova ko honau ʻOtua. ");
INSERT INTO ton_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ka te u manatu koeʻuhi ko kinautolu, ki he fuakava ʻa ʻenau ʻuluaki mātuʻa, ʻaia naʻaku ʻomi mei he fonua ko ʻIsipite ʻi he ʻao ʻoe kakai taʻelotu, koeʻuhi ke u hoko ai ko honau ʻOtua: Ko au ko Sihova.” ");
INSERT INTO ton_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ko eni ʻae ngaahi tuʻutuʻuni mo e ngaahi fono, mo e ngaahi fekau, ʻaia naʻe fokotuʻu ʻe Sihova ke kau kiate ia mo e fānau ʻa ʻIsileli ʻi he moʻunga ko Sainai ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Lea ki he fānau ʻa ʻIsileli, ʻo tala kiate kinautolu, ʻOka fai ʻe ha tangata ha fuakava mamafa, ʻe ʻa Sihova ʻae tatau ʻoe meʻa ko ia te ke lau ʻe koe. ");
INSERT INTO ton_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Pea ko hoʻo fakatatau ʻae tangata mei he taʻu ʻe uofulu ʻo ʻene motuʻa ʻo aʻu ki he taʻu ʻe onongofulu ʻo ʻene motuʻa, ʻio, ko hoʻo fakatatau ko e sikeli siliva ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu. ");
INSERT INTO ton_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pea kapau ko e fefine ia, ko hoʻo fakatatau, ko e sikeli ʻe tolungofulu. ");
INSERT INTO ton_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Pea kapau ko e taʻu ʻe nima ʻene motuʻa ʻo aʻu ki he taʻu ʻe uofulu, pea ko hoʻo fakatatau ki he tangata ko e sikeli ʻe uofulu, pea ki he fefine ko e sikeli ʻe hongofulu. ");
INSERT INTO ton_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Pea kapau ko e māhina pe taha ʻene motuʻa ʻo aʻu ki he taʻu ʻe nima ʻene motuʻa, pea ko hoʻo fakatatau ki he tangata ko e sikeli siliva ʻe nima, pea ko hoʻo fakatatau ki he fefine ko e sikeli siliva ʻe tolu. ");
INSERT INTO ton_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Pea kapau ʻoku onongofulu taʻu mo e taʻu niʻihi ʻene motuʻa; kapau ko e tangata, ko hoʻo fakatatau ki ai ko e sikeli ʻe hongofulu ma nima, pea ki he fefine ko e sikeli ʻe hongofulu. ");
INSERT INTO ton_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Pea kapau ʻoku masiva ʻaupito ia ʻi he meʻa kuo ke lau, pea te ne fakahā ia ʻi he ʻao ʻoe taulaʻeiki, pea ʻe fakatatau ia ʻe he taulaʻeiki; pea ke fai ʻe he taulaʻeiki ʻi heʻene fakatatau, ʻo taau mo hono mafai ʻo ia ʻaia naʻa ne fuakava. ");
INSERT INTO ton_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Pea kapau ko e manu, ʻaia ʻoku ʻomi ʻe he kakai ʻo ʻatu kia Sihova, ko ia kotoa pē ʻoku foaki ʻe ha tangata ʻi he meʻa pehē kia Sihova ʻe tapu ia. ");
INSERT INTO ton_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","‌ʻE ʻikai te ne fakakehe ia, pe fetongi ia, ʻae lelei ki he kovi, pe ha kovi ki he lelei: pea kapau ʻoku ne fetongi ʻae manu ʻaki ʻae manu, pea ko ia mo ia naʻe fetongi ʻaki ia ʻe fakatou tapu ia. ");
INSERT INTO ton_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Pea kapau ko e manu taʻemaʻa ia, ʻaia ʻoku ʻikai tenau fai ʻaki ha feilaulau kia Sihova, te ne toki ʻatu ʻae manu ʻi he ʻao ʻoe taulaʻeiki: ");
INSERT INTO ton_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Pea ke fakatatau ia ʻe he taulaʻeiki, pe ʻoku lelei pe ʻoku kovi: pea hangē ko hoʻo fakatatau ʻe koe ʻoku taulaʻeiki ko ia pe ʻe fai. ");
INSERT INTO ton_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pea kapau ʻoku loto ia ke huhuʻi ia, pea ʻe fakalahi ʻaki ia hono nima ʻoe vahe ki hoʻo fakatatau. ");
INSERT INTO ton_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","¶ Pea kapau ʻoku fakatapui ʻe ha tangata hono fale ke māʻoniʻoni ia kia Sihova, pea ke fakatatau ia ʻe he taulaʻeiki, he ʻoku lelei ia pe kovi: pea hangē ko ia ʻoku fakatatau ia ki ai, ʻe maʻu pe ia. ");
INSERT INTO ton_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Pea kapau ʻoku loto ʻaia naʻa ne fakatapui ia ke huhuʻi hono fale, pea ʻe fakalahi ʻaki ia hono nima ʻoe vahe ʻoe koloa ʻo hoʻo fakatatau, pea ʻe ʻoʻona ia. ");
INSERT INTO ton_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Pea kapau ʻoku fakatapui ʻe ha tangata kia Sihova ha potu ngoue ʻi hono potu fonua, pea ko hoʻo fakatatau, ʻe fakatatau ki he tenga ʻo ia: ko e oma ʻe taha ʻoe tengaʻi paʻale ʻe fakatatau ia ki he sikeli siliva ʻe nimangofulu. ");
INSERT INTO ton_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kapau ʻoku ne fakatapu ʻene ngoue mei he taʻu ʻoe siupeli, ʻe tuʻumaʻu ia ʻo tatau mo hoʻo fakatatau. ");
INSERT INTO ton_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pea kapau ʻoku ne fakatapui ʻene ngoue ka kuo hili ʻae siupeli, pea ʻe lau ʻe he taulaʻeiki ʻae paʻanga kiate ia ʻo fakatatau ki he ngaahi taʻu ʻoku toe, ʻio, ʻo aʻu atu ki he taʻu ʻoe siupeli, pea ʻe fakasiʻisiʻi ia mei hoʻo fakatatau. ");
INSERT INTO ton_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Pea ko ia naʻa ne fakatapui ʻae ngoue, kapau ʻoku tokanga ia ke huhuʻi ia, pea ke fakalahi ʻaki ʻe ia ia hono vahe nima ʻoe koloa ʻo hoʻo fakatatau, pea ʻe hoko ia kiate ia. ");
INSERT INTO ton_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pea kapau ʻoku ʻikai loto ia ke huhuʻi ʻae ngoue, pea kapau kuo ne fakatau ia ki he tangata ʻe taha, ʻe ʻikai toe huhuʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ka ko e ngoue ʻi hono tukuange ʻi he siupeli, ʻe tapu ia kia Sihova, ʻo hangē ha ngoue kuo fakatapui: ʻe hoko ia ke ʻoe taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Pea kapau ʻoku ai ha tangata ʻoku ne fakatapui kia Sihova ʻae ngoue naʻa ne fakatau, ʻaia ʻoku ʻikai ʻi he ngaahi ngoue ʻo hono tofiʻa; ");
INSERT INTO ton_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Pea ʻe toki lau kiate ia ʻe he taulaʻeiki hono fakatatau, ʻio, ʻo hoko ki he taʻu ʻoe siupeli: pea te ne ʻatu ʻe ia ʻi he ʻaho ko ia hoʻo fakatatau, ko e meʻa tapu kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Pea ʻi he taʻu ʻoe siupeli ʻe toe hoko ʻae ngoue kiate ia naʻe fakatau ia mei ai, ʻio, kiate ia naʻe ʻoʻona ʻae potu fonua ko ia. ");
INSERT INTO ton_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Pea ʻe fai ʻo taau mo e sikeli ʻoe faletapu ʻa hoʻo ngaahi fakatatau kotoa pē: ʻi he sikeli ʻe taha ʻae kela ʻe uofulu. ");
INSERT INTO ton_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","¶ Ka ko e ngaahi ʻuluaki fānau ʻae fanga manu, ʻaia ʻoku totonu ke ʻa Sihova ʻae ʻuluaki tupu, ke ʻoua naʻa fakatapui ia ʻe ha tangata ʻe tokotaha; pe ko e pulu ia, pe ko ha sipi; ʻoku ʻa Sihova ia. ");
INSERT INTO ton_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pea kapau ʻoku ʻi he manu taʻemaʻa ia, pea ʻe huhuʻi ia ʻo fakatatau ki hoʻo fakatatau, pea te ne fakalahi ʻaki ia hono nima ʻo hono vahe ʻo ia: pea kapau ʻe ʻikai huhuʻi ia, pea ʻe fakatau ia ʻo hangē ko hoʻo fakatatau. ");
INSERT INTO ton_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ka ko e moʻoni ʻe ʻikai fakatau pe huhuʻi ha meʻa ʻe taha, ʻaia kuo fakatapui ʻe ha tangata kia Sihova ʻi he meʻa kotoa pē ʻoku ne maʻu, ʻi he tangata, pe ʻi he manu, pe ʻi he ngoue ʻo hono potu fonua: ko e meʻa fakatapui kotoa pē ʻoku māʻoniʻoni lahi ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","‌ʻE ʻikai huhuʻi ha meʻa kuo fakatapui ʻaia kuo fakatapu ʻe he tangata ka ʻe tāmateʻi moʻoni ia. ");
INSERT INTO ton_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Pea ko hono hongofulu ʻoe vahe kotoa pē ʻoe fonua, pe ko e meʻa ʻi he tenga ʻoe fonua, pe ʻi he ngaahi fua ʻoe ʻakau ʻoku ʻa Sihova ia: ʻoku māʻoniʻoni ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Pea kapau ʻoku tokanga ʻe ha tangata ke huhuʻi ʻae meʻa niʻihi ʻi hono hongofulu ʻoe vahe, ʻe fakalahi ʻaki ʻe ia ia hono nima ʻoe vahe ʻo ia. ");
INSERT INTO ton_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Pea ko e meʻa ʻi hono hongofulu ʻoe vahe ʻi he fanga manu lalahi, pe ʻi he fanga manu siʻi, ʻio, ʻi he manu kotoa pē ʻoku ʻalu ʻi lalo ʻi he vaʻakau, ʻe māʻoniʻoni hono hongofulu kia Sihova. ");
INSERT INTO ton_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","‌ʻE ʻikai te ne kumi ke ʻilo pe ʻoku lelei pe ʻoku kovi ia, pea ʻe ʻikai te ne fetongi ia: pea kapau ʻoku ne fetongi ia, pea ko ia mo ia naʻe fetongi ʻaki ʻe fakatou māʻoniʻoni ia; ʻe ʻikai huhuʻi ia. ");
INSERT INTO ton_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ko eni ʻae ngaahi fekau, ʻaia naʻe fekau ʻe Sihova kia Mōsese ki he fānau ʻa ʻIsileli ʻi he moʻunga ko Sainai. ");
INSERT INTO ton_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese ʻi he toafa ʻo Sainai, ʻi he fale fehikitaki ʻoe kakai, ʻi he ʻuluaki ʻaho ʻo hono ua ʻoe māhina, ʻi hono ua taʻu ʻo ʻenau haʻu mei he fonua ko ʻIsipite, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Mou lau ʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli, ʻi honau ngaahi faʻahinga ʻo fakatatau mo e fale ʻo ʻenau ngaahi tamai, ʻo lau kotoa pē ʻi honau hingoa, ʻae kakai tangata kotoa pē taki taha; ");
INSERT INTO ton_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Mei honau taʻu ʻe uofulu tupu, ʻakinautolu kotoa pē ʻoku mālohi ke ʻalu atu ke tau ʻi ʻIsileli: ko koe mo ʻElone ke mo lau ʻakinautolu ʻi heʻenau ngaahi matatau. ");
INSERT INTO ton_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Pea ʻe fakataha mo kimoua ha tangata ʻe tokotaha mei he faʻahinga kotoa pē; ko ia taki taha ʻoku ʻeiki ʻi he fale ʻo ʻene ngaahi tamai.” ");
INSERT INTO ton_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","¶ Pea ko e ngaahi hingoa eni ʻoe kau tangata ʻe tuʻu mo kimoua; ko ʻIlisua, ko e foha ʻo Setiua ʻi he faʻahinga ʻo Lupeni: ");
INSERT INTO ton_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Ko Selumieli, ko e foha ʻo Sulisatai ʻi he faʻahinga ʻo Simione. ");
INSERT INTO ton_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Ko Nasoni, ko e foha ʻo ʻAminitapi ʻi he faʻahinga ʻo Siuta. ");
INSERT INTO ton_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Ko Netanili, ko e foha ʻo Sua ʻi he faʻahinga ʻo ʻIsaka. ");
INSERT INTO ton_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Ko ʻIliapi, ko e foha ʻo Heloni ʻi he faʻahinga ʻo Sepuloni. ");
INSERT INTO ton_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","‌ʻI he fānau ʻa Siosefa: ko ʻIlisama, ko e foha ʻo ʻAmihuti ʻi he faʻahinga ʻo ʻIfalemi; ko Kāmelieli, ko e foha ʻo Petasuli ʻi he faʻahinga ʻo Manase: ");
INSERT INTO ton_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Ko ʻEpitani, ko e foha ʻo Kitione ʻi he faʻahinga ʻo Penisimani. ");
INSERT INTO ton_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ko ʻEhiesa, ko e foha ʻo ʻAmisatai ʻi he faʻahinga ʻo Tani. ");
INSERT INTO ton_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Ko Pakieli, ko e foha ʻo ʻOkilani ʻi he faʻahinga ʻo ʻAseli. ");
INSERT INTO ton_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Ko ʻIliasafi, ko e foha ʻo Teuili ʻi he faʻahinga ʻo Kata. ");
INSERT INTO ton_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ko Heila, ko e foha ʻo ʻEnani ʻi he faʻahinga ʻo Nafitali. ");
INSERT INTO ton_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ko kinautolu ni naʻa nau ongoongo lahi ʻi he kakai, ko e houʻeiki ʻi he ngaahi faʻahinga ʻo ʻenau ngaahi tamai, ko e ʻeiki ʻoe ngaahi toko afe ʻi ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","¶ Pea naʻe ʻave ʻe Mōsese mo ʻElone ʻae kau tangata ni kuo fakahā honau hingoa: ");
INSERT INTO ton_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Pea naʻa nau fakataha ʻae kakai kotoa pē ʻi he ʻuluaki ʻaho ʻo hono ua ʻoe māhina, pea naʻa nau fakahā honau hokohoko ʻi honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau mo e lau ʻoe ngaahi hingoa taki taha, mei hono uofulu tupu ʻoe taʻu ʻo fai hake. ");
INSERT INTO ton_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","¶ ʻO hangē ko e fekau ʻa Sihova kia Mōsese, naʻe pehē ʻa ʻene lau ʻakinautolu ʻi he toafa ʻo Sainai. ");
INSERT INTO ton_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","¶ Pea ko e fānau ʻa Lupeni, ko e ʻuluaki foha ʻo ʻIsileli, ʻi honau ngaahi toʻutangata, mo honau faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa taki taha, ʻae tangata kotoa pē, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Lupeni, ko e toko fā mano mo e toko ono afe ma nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","¶ Ko e fānau ʻa Simione, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻakinautolu naʻe lau ʻiate kinautolu, ʻo fakatatau ki he lau ʻoe ngaahi hingoa taki taha, ʻae tangata kotoa pē mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Simione, ko e toko nima mano mo e toko hiva afe ma tolungeau. ");
INSERT INTO ton_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","¶ Ko e fānau ʻa Kata, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Kata, ko e toko fā mano mo e toko nima afe mo e toko onongeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","¶ Ko e fānau ʻa Siuta, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Siuta ko e toko fitu mano mo e toko fā afe ma onongeau. ");
INSERT INTO ton_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","¶ Ko e fānau ʻa ʻIsaka, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ko kinautolu, naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo ʻIsaka ko e toko nima mano mo e toko fā afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","¶ Ko e fānau ʻa Sepuloni, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Sepuloni ko e toko nima mano mo e toko fitu afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","¶ Ko e fānau ʻa Siosefa, ʻio, ʻae fānau ʻa ʻIfalemi ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻa ʻIfalemi, ko e toko fā mano ma toko nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","¶ Ko e fānau ʻa Manase, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Manase, ko e toko tolu mano, mo e toko ua afe ma uangeau. ");
INSERT INTO ton_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","¶ Ko e fānau ʻa Penisimani, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Penisimani, ko e toko tolu mano, mo e toko nima afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","¶ Ko e fānau ʻa Tani, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Tani, ko e toko ono mano, mo e toko ua afe ma fitungeau. ");
INSERT INTO ton_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","¶ Ko e fānau ʻa ʻAseli, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu, ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Pea ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo ʻAseli, ko e toko fā mano, mo e toko taha afe ma nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","¶ Ko e fānau ʻa Nafitali, ʻi honau ngaahi toʻutangata, mo honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau ki he lau ʻoe ngaahi hingoa, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau; ");
INSERT INTO ton_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ko kinautolu naʻe lau ʻiate kinautolu, ʻio, ʻi he faʻahinga ʻo Nafitali, ko e toko nima mano, mo e toko tolu afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ko kinautolu eni naʻe lau, ʻaia naʻe lau ʻe Mōsese mo ʻElone, mo e houʻeiki ʻo ʻIsileli, ko e kau tangata ʻe toko hongofulu ma toko ua: naʻe taki taha tuʻu maʻae fale ʻo ʻene ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Naʻe pehē ʻakinautolu kotoa pē naʻe lau ʻi he fānau ʻa ʻIsileli, ʻi he fale ʻo ʻenau ngaahi tamai, mei hono taʻu ʻe uofulu ʻo fai hake, ʻakinautolu kotoa pē naʻe mālohi ke ʻalu atu ke tau ʻi ʻIsileli; ");
INSERT INTO ton_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","‌ʻIo, ko kinautolu kotoa pē naʻe lau ko e toko ono kilu, mo e toko tolu afe, mo e toko nimangeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","¶ Ka naʻe ʻikai lau ʻiate kinautolu ʻae kau Livai ʻi he faʻahinga ʻo ʻenau ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","He kuo folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ʻE ʻikai te ke lau ʻae faʻahinga ʻo Livai, pea ʻoua naʻa ke lau ʻakinautolu fakataha mo e fānau ʻa ʻIsileli: ");
INSERT INTO ton_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Ka ke fakanofo ʻae kau Livai ke pule ki he fale fehikitaki ʻoe fakamoʻoni, pea mo e ngaahi nāunau kotoa pē ʻi ai, pea mo e ngaahi meʻa kotoa pē ʻi ai, pea tenau fua ʻae fale fehikitaki, pea mo hono ngaahi nāunau kotoa pē; pea tenau ngāue ki ai, ʻo nofo takatakai ki he fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Pea ʻoka ʻalu atu ʻae fale fehikitaki, ʻe vete hifo ia ʻe he kau Livai; pea ʻoka nofo ʻae fale fehikitaki, ʻe fokotuʻu ia ʻe he kau Livai: pea ko e muli ʻoku haʻu ke ofiki ai ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Pea ko e fānau ʻa ʻIsileli tenau fokotuʻu ʻa honau ngaahi fale fehikitaki, ʻae tangata taki taha ki hono ʻapitanga, pea mo e tangata taki taha ki hono fuka, ʻi honau ngaahi faʻahinga. ");
INSERT INTO ton_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Ka ʻe nofo ʻae kau Livai ʻo takatakai ʻi he fale fehikitaki ʻoe fakamoʻoni, koeʻuhi ke ʻoua naʻa ai ha houhau ki he fakataha ʻoe fānau ʻa ʻIsileli: pea ʻe tokanga ʻae kau Livai ki he tauhi ʻoe fale fehikitaki ʻoe fakamoʻoni.” ");
INSERT INTO ton_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Pea naʻe fai ʻe he fānau ʻa ʻIsileli ʻo fakatatau ki he meʻa kotoa pē kuo fekau mai ʻe Sihova kia Mōsese; naʻe pehē pe ʻenau fai. ");
INSERT INTO ton_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","‌ʻE nofo ʻae tangata taki taha ʻoe fānau ʻa ʻIsileli ki hono fakaʻilonga, ʻo fakataha mo e fuka ʻoe fale ʻo ʻenau tamai; pea tenau nofo mamaʻo ʻo folifoliaki ʻi he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Pea ʻe nofo ʻi he potu hahake ʻo hangatonu ki he hopoʻangalaʻā, ʻakinautolu ʻoe fakaʻilonga ʻoe ʻapitanga ʻo Siuta ʻi heʻenau ngaahi matatau: pea ko Nasoni ko e foha ʻo ʻAminitapi ʻe ʻeikitau ia ʻi he fānau ʻa Siuta. ");
INSERT INTO ton_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Pea ko ʻene kautau ʻaʻana, mo kinautolu naʻe lau ai, ko e toko fitu mano, mo e toko fā afe ma onongeau. ");
INSERT INTO ton_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Pea ko kinautolu ʻe hokoʻo nofo mo ia ko e faʻahinga ʻo ʻIsaka, pea ko Netanili ko e foha ʻo Sua, ʻe ʻeikitau ia ʻi he fānau ʻa ʻIsaka. ");
INSERT INTO ton_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko nima mano, mo e toko fā afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Pea ʻe hoko ai ʻae faʻahinga ʻo Sepuloni, pea ko ʻIliapi, ko e foha ʻo Heloni ʻe ʻeikitau ia ʻi he fānau ʻa Sepuloni. ");
INSERT INTO ton_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Pea ko ʻene kautau mo kinautolu naʻe lau ai, ko e toko nima mano, mo e toko fitu afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Pea ko kinautolu kotoa pē naʻe lau ʻi he ʻapitanga ʻo Siuta, ko e tokotaha kilu, mo e toko valu mano, mo e toko ono afe ma fāngeau, ʻi heʻenau ngaahi matatau. ʻE ʻalu muʻomuʻa atu ʻakinautolu ni. ");
INSERT INTO ton_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","¶ Pea ʻe tuʻu ʻi he feituʻu tonga ʻae fakaʻilonga ʻoe ʻapitanga ʻo Lupeni ʻo fakatatau ki heʻenau ngaahi matatau; pea ko ʻIlisua ko e foha ʻo Setiua ʻe ʻeikitau ia ʻi he fānau ʻa Lupeni. ");
INSERT INTO ton_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko fā mano, mo e toko ono afe ma nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Pea ko kinautolu ʻe hoko nofo mo ia, ko e faʻahinga ʻo Simione: pea ko Selumieli ko e foha ʻo Sulisatai ʻe ʻeikitau ia ʻi he fānau ʻa Simione. ");
INSERT INTO ton_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko nima mano, mo e toko hiva afe ma tolungeau. ");
INSERT INTO ton_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Pea ʻe hoko ai ʻae faʻahinga ʻo Kata pea ko ʻIliasafi ko e foha ʻo Teuili, ʻe ʻeikitau ia ʻi he ngaahi foha ʻo Kata. ");
INSERT INTO ton_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko fā mano, mo e toko nima afe mo e toko onongeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Pea ko kinautolu kotoa pē naʻe lau ʻi he ʻapitanga ʻo Lupeni, ko e tokotaha kilu, mo e toko nima mano, mo e toko taha afe mo e toko fāngeau ma nimangofulu, ʻi heʻenau ngaahi matatau. Pea ʻe ʻalu atu ʻakinautolu ʻi hono ua ʻoe ʻotutangata. ");
INSERT INTO ton_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","¶ Pea ʻe toki ʻalu atu ʻae fale fehikitaki ʻoe kakai, fakataha mo e ʻapitanga ʻoe kau Livai ʻi he lotolotonga ʻoe kau tau: ʻo hangē pe ko ʻenau nofo, ʻe pehē pe ʻi heʻenau fononga atu, ko e tangata taki taha ʻe ʻi hono potu ʻi honau fakaʻilonga. ");
INSERT INTO ton_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","¶ Pea ʻe tuʻu ʻi he potu lulunga ʻae fakaʻilonga ʻoe ʻapitanga ʻo ʻIfalemi, ʻo fakatatau ki heʻenau ngaahi matatau: pea ko ʻIlisama ko e foha ʻo ʻAmihuti, ʻe ʻeikitau ia ʻi he ngaahi foha ʻo ʻIfalemi. ");
INSERT INTO ton_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko fā mano mo e toko nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Pea ʻe hoko mo ia ʻae faʻahinga ʻo Manase: pea ko Kāmelieli ko e foha ʻo Petasuli, ʻe ʻeikitau ia ʻi he fānau ʻa Manase. ");
INSERT INTO ton_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko tolu mano mo e toko ua afe mo e uangeau. ");
INSERT INTO ton_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Pea ʻe hoko ai ʻae faʻahinga ʻo Penisimani: pea ko ʻEpitani ko e foha ʻo Kitione ʻe ʻeikitau ia ʻi he fānau ʻa Penisimani. ");
INSERT INTO ton_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, koe toko tolu mano mo e toko nima afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Pea ko kinautolu kotoa pē naʻe lau ʻi he ʻapitanga ʻo ʻIfalemi, ko e tokotaha kilu, mo e toko valu afe, mo e toko teau, ʻi honau ngaahi matatau. Pea ʻe ʻalu atu ʻakinautolu ʻi hono tolu ʻoe ʻotutangata. ");
INSERT INTO ton_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","¶ Pea ʻe tuʻu ʻi he potu tokelau ʻae fakaʻilonga ʻoe ʻapitanga ʻo Tani ʻi heʻenau ngaahi matatau: pea ko ʻEhiesa ko e foha ʻo ʻAmisatai ʻe ʻeikitau ia ʻi he fānau ʻa Tani. ");
INSERT INTO ton_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko tolu mano, mo e toko ua afe ma toko fitungeau. ");
INSERT INTO ton_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Pea ko kinautolu ʻoku hoko nofo mo ia ko e faʻahinga ʻo ʻAseli: pea ko Pakieli ko e foha ʻo ʻOkilani ʻe ʻeikitau ia ʻi he fānau ʻa ʻAseli. ");
INSERT INTO ton_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko fā mano, mo e toko taha afe ma nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Pea ʻe hoko ai ʻae faʻahinga ʻo Nafitali: pea ko Heila ko e foha ʻo ʻEnani ʻe ʻeikitau ia ʻi he fānau ʻa Nafitali. ");
INSERT INTO ton_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Pea ko ʻene kautau, mo kinautolu naʻe lau ai, ko e toko nima mano, mo e toko tolu afe ma fāngeau. ");
INSERT INTO ton_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Pea ko kinautolu kotoa pē naʻe lau ʻi he ʻapitanga ʻo Tani, ko e tokotaha kilu, mo e toko nima mano, mo e toko fitu afe ma onongeau. Pea ʻe muimui ʻakinautolu mo ʻenau ngaahi fuka. ");
INSERT INTO ton_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","¶ Ko kinautolu ia naʻe lau ʻi he fānau ʻa ʻIsileli ʻi he fale ʻo ʻenau ngaahi tamai: ko kinautolu kotoa pē naʻe lau ʻi honau ngaahi ʻapitanga, ʻi honau ngaahi matatau, ko e toko ono kilu, mo e toko tolu afe, mo e toko nimangeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ka naʻe ʻikai lau ʻae kau Livai ʻi he fānau ʻa ʻIsileli; ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Pea naʻe fai ʻe he fānau ʻa ʻIsileli ʻo fakatatau ki he meʻa kotoa pē kuo fekau mai ʻe Sihova kia Mōsese: ko ia naʻa nau nofo ai ki honau ngaahi fakaʻilonga, pea naʻe pehē ʻenau fononga atu; taki taha ʻi honau ngaahi faʻahinga ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Pea ko eni foki ʻae ngaahi toʻutangata ʻo ʻElone mo Mōsese ʻi he ʻaho naʻe folofola ai ʻa Sihova kia Mōsese ʻi he moʻunga ko Sainai. ");
INSERT INTO ton_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Pea ko e hingoa eni ʻoe ngaahi foha ʻo ʻElone; ko Natapi ko e ʻuluaki ia, mo ʻApiu, mo ʻEliesa, mo ʻItama. ");
INSERT INTO ton_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Pea ko e hingoa ia ʻoe ngaahi foha ʻo ʻElone naʻe fakanofo ko e kau taulaʻeiki, ʻakinautolu naʻa ne fakatapui ke ngāue ʻi he ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pea naʻe mate ʻa Natapi mo ʻApiu ʻi he ʻao ʻo Sihova, ʻi heʻena ʻomi ʻae afi kehe ki he ʻao ʻo Sihova ʻi he toafa ʻo Sainai, pea naʻe ʻikai haʻana fānau: pea ko ʻEliesa mo ʻItama naʻa na ngāue ʻi he ngāue fakataulaʻeiki ʻi he ʻao ʻo ʻElone ko ʻena tamai. ");
INSERT INTO ton_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Ke ke fakaofi mai ʻae faʻahinga ʻo Livai, pea fakahā ʻakinautolu ʻi he ʻao ʻo ʻElone ko e taulaʻeiki koeʻuhi kenau ngāue kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Pea tenau tokanga ki heʻene ngāue, mo e ngāue ʻae kakai kotoa pē, ʻi he ʻao ʻoe fale fehikitaki ʻoe kakai, ke fai ki he ngāue ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Pea tenau tauhi ʻae ngaahi meʻa kotoa pē ʻoe fale fehikitaki ʻoe kakai, mo e ngāue ʻae fānau ʻa ʻIsileli, ke fai ki he ngāue ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Pea te ke foaki ʻae kau Livai kia ʻElone mo hono ngaahi foha: kuo foaki ʻakinautolu kotoa pē kiate ia mei he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pea te ke fakanofo ʻa ʻElone mo hono ngaahi foha, pea tenau fai ʻenau ngāue fakataulaʻeiki: pea ko e muli ʻe haʻu ʻo ofi ʻe tāmateʻi ia.” ");
INSERT INTO ton_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Pea ko au, vakai, Ko au kuo ʻomi ʻae kau Livai mei he fānau ʻa ʻIsileli ke fetongi ʻaki ʻae ʻuluaki tama kotoa pē kuo ne toʻo ʻae manāva ʻi he fānau ʻa ʻIsileli; ko ia ai, ʻe ʻoʻoku ʻae kau Livai; ");
INSERT INTO ton_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Koeʻuhi ʻoku ʻoʻoku ʻae ʻuluaki tama kotoa pē; he ko e ʻaho ne u taaʻi ai ʻae ʻuluaki fānau ʻi he fonua ko ʻIsipite, ne u fakatapui ai kiate au ʻae ʻuluaki tama ʻi ʻIsileli, ʻae tangata mo e manu; Ko au ko Sihova ʻe ʻoʻoku ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","¶ Pea naʻe folofola ʻa Sihova kia Mōsese ʻi he toafa ʻo Sainai, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Ke ke lau ʻae fānau ʻa Livai ʻi he fale ʻo ʻenau ngaahi tamai, mo honau ngaahi faʻahinga, ʻae kakai tangata kotoa pē mei hono taha māhina, ke ke lau fakaʻaufuli ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Pea naʻe lau ʻakinautolu ʻe Mōsese ʻo fakatatau ki he folofola ʻa Sihova, pea hangē ko e fekau kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Pea ko e hingoa eni ʻoe ngaahi foha ʻo Livai; ko Kesoni, mo Kohate, mo Melali. ");
INSERT INTO ton_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Pea ko e ngaahi hingoa eni ʻoe ngaahi foha ʻo Kesoni ʻi honau ngaahi faʻahinga, ko Lipinai, mo Simi. ");
INSERT INTO ton_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Pea ko e ngaahi foha ʻo Kohate ʻi honau ngaahi faʻahinga, ko ʻAmilami, mo ʻIsa, mo Hepeloni, mo ʻUsili. ");
INSERT INTO ton_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Pea ko e ngaahi foha ʻo Melali ʻi honau ngaahi faʻahinga, ko Mali, mo Musi. Pea ko e ngaahi fānau ʻoe kau Livai ʻakinautolu ni, ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Pea naʻe ʻia Kesoni ʻae faʻahinga ʻoe kau Lipinai, mo e faʻahinga ʻoe kau Simi; pea ko e ngaahi faʻahinga ʻoe kau Kesoni ʻakinautolu ni. ");
INSERT INTO ton_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ko kinautolu naʻe lau ʻiate kinautolu ʻo fakatatau ki he lau ʻoe kakai tangata mei hono taha māhina ʻo fai hake, ʻio, ʻakinautolu naʻe lau ʻiate kinautolu, ko e toko fitu afe ma toko nimangeau. ");
INSERT INTO ton_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Pea ʻe nofo kituʻa ʻi he fale fehikitaki ki he potu lulunga ʻae ngaahi faʻahinga ʻoe kau Kesoni. ");
INSERT INTO ton_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Pea ko ʻIliasafi ko e foha ʻo Laeli, ko e ʻeiki ia ʻoe fale ʻoe tamai ʻae kau Kesoni. ");
INSERT INTO ton_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Pea ko e ngāue ʻae ngaahi foha ʻo Kesoni ki he fale fehikitaki ʻoe kakai, ko e faletapu, pea mo e fale fehikitaki, mo hono pulonga, pea mo e puipui ʻoe matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Pea mo e ngaahi puipui ʻoe lotoʻā, pea mo e puipui ʻoe matapā ʻoe lotoʻā, ʻaia ʻoku ofi ki he fale fehikitaki, pea ʻoku takatakai ʻae feilaulauʻanga, pea mo e ngaahi maea ki he ngāue kotoa pē ʻi ai. ");
INSERT INTO ton_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","¶ Pea naʻe ʻia Kohate ʻae faʻahinga ʻoe kau ʻAmilami, pea mo e faʻahinga ʻoe kau ʻIsa, pea mo e faʻahinga ʻoe kau Hepeloni, pea mo e faʻahinga ʻoe kau ʻUsili, pea ko e ngaahi faʻahinga ʻoe kau Kohate ʻakinautolu ni. ");
INSERT INTO ton_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ko e lau ʻoe kakai tangata kotoa pē mei hono taha māhina ʻo fai hake, ko e toko valu afe ma toko onongeau, kuo nau fai ki he ngāue ʻoe faletapu. ");
INSERT INTO ton_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Ko e ngaahi faʻahinga ʻoe ngaahi foha ʻo Kohate tenau nofo ʻi he potu tonga ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Pea ko ʻElisefani ko e foha ʻo ʻUsili ko e ʻeiki ia ʻoe fale ʻoe tamai ʻae ngaahi faʻahinga ʻoe kau Kohate. ");
INSERT INTO ton_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Pea ko e meʻa kenau tauhi, ko e puha ʻoe fuakava, mo e palepale, mo e tuʻunga maama, mo e ngaahi feilaulauʻanga, mo e ngaahi ipu ʻoe faletapu ʻaia kuo nau ngāueʻaki, pea mo e puipui, pea mo e ngaahi meʻa kotoa pē ʻi ai. ");
INSERT INTO ton_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Pea ko ʻEliesa, ko e foha ʻo ʻElone ko e taulaʻeiki ko e pule ia ʻoe houʻeiki ʻoe kau Livai, pea ʻe pule ia kiate kinautolu ʻoku fai ʻae ngāue ʻoe faletapu. ");
INSERT INTO ton_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","¶ Pea naʻe ʻia Melali ʻae faʻahinga ʻoe kau Mali, mo e faʻahinga ʻoe kau Musi: pea ko e ngaahi faʻahinga ʻo Melali ʻakinautolu ni. ");
INSERT INTO ton_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Pea ko kinautolu naʻe lau ʻiate kinautolu, ʻo fakatatau ki he lau ʻoe kakai tangata kotoa pē, mei hono taha māhina ʻo fai hake, ko e toko ono afe ma toko uangeau. ");
INSERT INTO ton_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Pea ko Suleli ko e foha ʻo ʻEpieli ko e ʻeiki ia ʻoe fale ʻoe tamai ʻae ngaahi faʻahinga ʻo Melali: ko kinautolu ni, ʻe nofo ʻi he potu tokelau ʻoe fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Pea ʻoku ʻae ngaahi foha ʻo Melali ʻae ngaahi laupapa ʻoe fale fehikitaki, mo hono ngaahi ʻakau fakamaʻu, mo hono ngaahi pou, mo hono ngaahi tuʻunga pou, pea mo hono ngaahi ipu kotoa pē, pea mo e meʻa kotoa pē ʻoku ngāueʻaki ʻi ai. ");
INSERT INTO ton_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Pea mo e ngaahi ʻotu pou ʻoe lotoʻā, pea mo honau ngaahi tuʻunga, mo honau ngaahi tutuki, mo honau ngaahi maea. ");
INSERT INTO ton_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","¶ Ka ko kinautolu ʻoku nofo ʻi he ʻao ʻoe fale fehikitaki ki he potu hahake, ʻio, ʻi he ʻao ʻoe fale fehikitaki ʻoe kakai ʻi he potu hahake, ko Mōsese, mo ʻElone, mo hono ngaahi foha, ke tauhi ai ʻae ngāue ʻoe faletapu ki he ngāue ʻae fānau ʻa ʻIsileli; pea ko e muli ʻoku haʻu ʻo ofi ʻe tāmateʻi ia. ");
INSERT INTO ton_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ko kinautolu kotoa pē naʻe lau ʻi he kau Livai, ʻaia naʻe lau ʻe Mōsese mo ʻElone ʻi he fekau ʻa Sihova, ʻi honau ngaahi faʻahinga, ʻae kakai tangata kotoa pē mei hono taha māhina ʻo fai hake, ko e toko ua mano ma toko ua afe. ");
INSERT INTO ton_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","¶ Pea naʻe pehē ʻe Sihova kia Mōsese, “Ke ke lau ʻae ʻuluaki tama tangata kotoa pē ʻi he fānau ʻa ʻIsileli mei hono taha māhina ʻo fai hake, pea ke lau honau hingoa. ");
INSERT INTO ton_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Pea ke ʻave ʻae kau Livai moʻoku, (Ko au ko Sihova) ke fetongi ʻaki ʻae ʻuluaki fānau ʻi he fānau ʻa ʻIsileli; pea mo e fanga manu ʻae kau Livai, ke fetongi ʻaki ʻae ʻuluaki kotoa pē ʻoe fanga manu ʻae fānau ʻa ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Pea naʻe lau ʻe Mōsese ʻae ʻuluaki tama kotoa pē ʻi he fānau ʻa ʻIsileli, ʻo hangē ko e fekau ʻa Sihova kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Pea ko e ʻuluaki tama tangata kotoa pē ʻi he lau ʻa honau hingoa mei hono taha māhina ʻo fai hake, ko kinautolu naʻe lau ʻiate kinautolu, ko e toko ua mano, mo e toko ua afe, mo e toko uangeau, mo e toko fitungofulu ma toko tolu. ");
INSERT INTO ton_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ʻAve ʻae kau Livai ke fetongi ʻaki ʻae ʻuluaki tama kotoa pē ʻi hē fānau ʻa ʻIsileli; pea mo e fanga manu ʻae kau Livai ke fetongi ʻaki ʻenau fanga manu pea ko e kau Livai ʻe ʻoʻoku ʻakinautolu: Ko au ko Sihova. ");
INSERT INTO ton_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pea koeʻuhi ko kinautolu, ʻe huhuʻi ʻae toko uangeau mo e toko fitungofulu ma toko tolu ʻoe ʻuluaki tama ʻi he fānau ʻa ʻIsileli, ʻakinautolu kuo tokolahi hake ʻi he kau Livai; ");
INSERT INTO ton_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ke ke ʻave ʻa esikeli ʻe nima maʻanautolu taki taha, ʻo fakatatau ki hesikeli ʻoe faletapu: (koesikeli ko e kela ʻe uofulu:) ");
INSERT INTO ton_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Pea te ke ʻatu ʻae paʻanga, ʻaia kuo huhuʻi ʻaki ʻakinautolu ʻoku toe, kia ʻElone mo hono ngaahi foha.” ");
INSERT INTO ton_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Pea naʻe maʻu ʻe Mōsese ʻae paʻanga huhuʻi ʻokinautolu naʻe tokolahi hake ʻiate kinautolu naʻe huhuʻi ʻe he kau Livai: ");
INSERT INTO ton_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Naʻe maʻu ʻe ia ʻae ngaahi paʻanga mei he ʻuluaki fānau ʻi he fānau ʻa ʻIsileli; ko esikeli ʻe afe ma tolungeau ma onongofulu ma nima, ʻo fakatatau mo esikeli ʻoe faletapu: ");
INSERT INTO ton_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Pea naʻe ʻatu ʻe Mōsese ʻae ngaahi paʻanga kuo huhuʻi ʻaki ʻakinautolu kia ʻElone mo hono ngaahi foha, ʻo hangē ko e folofola ʻa Sihova, pea hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Mo lau ʻae ngaahi foha ʻo Kohate mei he ngaahi foha ʻo Livai, ʻi honau ngaahi faʻahinga, ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai, ");
INSERT INTO ton_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mei he taʻu ʻe tolungofulu ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu kotoa pē ʻoku ʻalu ki he tau, ke fai ʻae ngāue ʻi he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Pea ko e ngāue eni ʻae ngaahi foha ʻo Kohate ʻi he fale fehikitaki ʻoe kakai, ʻi he ngaahi meʻa toputapu. ");
INSERT INTO ton_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Pea ʻoka hiki atu ʻae ʻapitanga, ʻe haʻu ʻa ʻElone, mo hono ngaahi foha, kenau vete hifo ʻae fakapulonga, ʻo ʻuʻufi ʻaki ia ʻae puha ʻoe fuakava: ");
INSERT INTO ton_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Pea ʻe tuku ki ai ʻae kiliʻi pasia ke ʻuʻufi ʻaki ia, pea ʻe ʻufiʻufi ʻaki ia ʻae kofu lanumoana, pea ʻe ʻai ki ai hono ʻakau haʻamo. ");
INSERT INTO ton_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Pea ko e palepale ʻoe ma ʻoe ʻao tenau ʻuʻufi ʻaki ʻae kofu lanumoana, pea tuku ki ai ʻae ngaahi ipu, mo e ngaahi sēpuni, mo e ngaahi ipu louluo, pea mo e ngaahi tāpuni ke ʻufiʻufi ʻaki; pea ʻe tuku ki ai ʻae ma ʻoe ʻao: ");
INSERT INTO ton_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Pea tenau ʻuʻufi ʻaki ia ʻae kofu kulaʻahoʻaho, pea ʻe toe ʻuʻufi ʻaki ia ʻae kiliʻi pasia, pea ʻe ʻai ki ai hono ʻakau haʻamo. ");
INSERT INTO ton_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Pea tenau ʻave ʻae kofu lanumoana, ʻo ʻuʻufi ʻaki ʻae tuʻunga maama, mo hono ngaahi foʻi maama, mo hono ngaahi hikofi, mo e ngaahi tukuʻanga ʻoe maama helekosi, pea mo e ipu lolo kotoa pē, ʻaia ʻoku nau ngāueʻaki ki ai: ");
INSERT INTO ton_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Pea tenau tuku ia mo hono ngaahi ipu kotoa pē ke ʻuʻufi ʻaki ʻae kiliʻi pasia, pea ʻe tuku ia ki ha fata. ");
INSERT INTO ton_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Pea tenau faliki ʻaki ʻae feilaulauʻanga koula ʻae kofu lanumoana, pea toe ʻuʻufi ʻaki ia ʻae kiliʻi pasia, pea ʻe tuku ki ai hono ʻakau haʻamo. ");
INSERT INTO ton_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Pea tenau toʻo ai ʻae nāunau kotoa pē ʻoe ngāue, ʻaia ʻoku nau ngāueʻaki ʻi he faletapu, pea ʻe tuku ia ki ha kofu lanumoana, pea ʻe ʻuʻufi ʻaki ia ʻae pulonga kiliʻi pasia, pea ʻe tuku ia ki ha fata. ");
INSERT INTO ton_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Pea tenau ʻave ʻae efuefu mei he feilaulauʻanga, pea ʻe ʻuʻufi ʻaki ia ʻae kofu paʻuhiʻuhi: ");
INSERT INTO ton_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Pea tenau tuku ki ai hono ngaahi ipu kotoa pē, ʻaia ʻoku nau ngāueʻaki ki ai, ʻio, ʻae ngaahi ipu ʻaiʻanga afi, mo e ngaahi huhu, pea mo e ngaahi huo, pea mo e ngaahi ipu luoluo, ko e ngaahi ipu kotoa pē ʻoe feilaulauʻanga; pea tenau ʻuʻufi ʻaki ia ʻae kiliʻi pasia, pea tuku ki ai hono ʻakau haʻamo. ");
INSERT INTO ton_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Pea ka fakaʻosi ʻe ʻElone mo hono ngaahi foha ʻae fakapulonga ʻoe faletapu, pea mo hono ngaahi nāunau kotoa pē, pea ka hiki atu ʻae ʻapitanga; ʻe toki haʻu ʻae ngaahi foha ʻo Kohate ʻo fata ia: kaeʻoua naʻa nau ala ki ha meʻa tapu, telia naʻa nau mate ai. Ko e ngaahi meʻa ni ko e kavenga ia ʻae ngaahi foha ʻo Kohate ʻi he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","¶ Pea ko e ngāue ʻa ʻEliesa ko e foha ʻo ʻElone ko e taulaʻeiki, ko e lolo ki he maama, pea mo e meʻa namu kakala, pea mo e feilaulau meʻakai ʻoe ʻaho, pea mo e lolo ʻoe fakanofo, pea mo e pule ʻoe fale fehikitaki, pea mo e ngaahi meʻa kotoa pē ʻi ai, ʻi he faletapu, pea mo hono ngaahi nāunau ʻo ia. ");
INSERT INTO ton_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“ʻOua naʻa mo vaheʻi ʻae faʻahinga ʻoe ngaahi fānau ʻa Kohate mei he kau Livai: ");
INSERT INTO ton_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ka ko eni ia te mou fai kiate kinautolu, koeʻuhi kenau moʻui, pea ʻikai mate, ʻoka nau ka haʻu ki he ngaahi meʻa toputapu: ʻe ʻalu ʻa ʻElone mo hono ngaahi foha ʻo tuʻutuʻuni kiate kinautolu taki taha ʻenau ngāue mo ʻenau kavenga: ");
INSERT INTO ton_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ka ʻe ʻikai tenau hū atu ke mamata ʻoka ʻuʻufi ʻae ngaahi meʻa toputapu, telia naʻa nau mate.” ");
INSERT INTO ton_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Ke ke lau foki ʻae ngaahi foha ʻo Kesoni, ʻi he fale ʻo ʻenau ngaahi tamai, ʻo fakatatau mo ʻenau ngaahi fānau; ");
INSERT INTO ton_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ke ke lau ʻakinautolu mei he tolungofulu taʻu ʻo aʻu ki he taʻu ʻe nimangofulu; ʻakinautolu kotoa pē ʻoku hū ke fai ʻae ngāue, ke fai ʻae ngāue ʻi he fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Pea ko e ngāue eni ʻae faʻahinga ʻoe kau Kesoni, ke tauhi, mo kavenga ʻaki: ");
INSERT INTO ton_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Pea tenau fua ʻae ngaahi puipui ʻoe fale fehikitaki, pea mo e fale fehikitaki ʻoe kakai, ko hono fakapulonga, pea mo e ʻuʻufi kiliʻi pasia ʻoku ʻuʻufi ʻaki ia, pea mo e puipui ʻoe matapā ʻoe fale fehikitaki ʻoe kakai, ");
INSERT INTO ton_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Pea mo e ngaahi puipui ʻoe lotoʻā, pea mo e puipui ke matapā ʻaki ʻi he hūʻanga ʻoe lotoʻā, ʻaia ʻoku ofi ki he fale fehikitaki pea ʻoku takatakai ʻi he veʻe feilaulauʻanga, pea mo hono ngaahi maea, pea mo e nāunau kotoa pē ʻo ʻenau tauhi, pea mo e meʻa kotoa pē kuo ngaohi maʻanautolu: ʻe pehē ʻenau tauhi. ");
INSERT INTO ton_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","‌ʻE ʻi he tuʻutuʻuni ʻa ʻElone mo hono ngaahi foha ʻae ngāue kotoa pē ʻae ngaahi foha ʻo Kesoni, mo ʻenau kavenga kotoa pē, pea mo ʻenau tauhi kotoa pē: pea te mou tuʻutuʻuni kiate kinautolu ʻenau kavenga kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pea ko e ngāue eni ʻae faʻahinga ʻoe ngaahi foha ʻo Kesoni ʻi he fale fehikitaki ʻoe kakai: pea ʻe puleʻi ʻenau ngāue ʻe ʻItama ko e foha ʻo ʻElone ko e taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","¶ Pea ko e ngaahi foha ʻo Melali, ke ke lau ʻakinautolu ʻi honau ngaahi faʻahinga, ʻi he fale ʻo ʻenau ngaahi tamai; ");
INSERT INTO ton_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ke ke lau ʻakinautolu mei he tolungofulu taʻu, ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu kotoa pē ʻoku hū ke fai ʻae ngāue ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Pea ko e fakahā eni ʻo ʻenau kavenga, ʻo fakatatau ki heʻenau ngāue kotoa pē ʻi he fale fehikitaki ʻoe kakai; ko e ngaahi laupapa ʻoe fale fehikitaki, pea mo hono ngaahi ʻakau fakamaʻu, pea mo hono ngaahi pou, pea mo hono ngaahi tuʻungaʻi pou, ");
INSERT INTO ton_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Pea mo e ngaahi ʻotu pou takatakai ʻoe lotoʻā, mo hono ngaahi tuʻungaʻi pou, mo hono ngaahi faʻo, mo hono ngaahi maea, fakataha mo honau nāunau kotoa pē, pea mo ʻenau ngāue kotoa pē: pea te mo lau ʻi honau hingoa ʻae ngaahi meʻa ʻoe ngāue ʻo ʻenau kavenga. ");
INSERT INTO ton_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Pea ko e ngāue eni ʻae fānau ʻae ngaahi foha ʻo Melali, ʻo fakatatau ki heʻenau ngāue kotoa pē ʻi he fale fehikitaki ʻoe kakai, ʻi he pule ʻa ʻItama ko e foha ʻo ʻElone ko e taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","¶ Pea naʻe lau ʻe Mōsese mo ʻElone mo e houʻeiki ʻoe kakai ʻae ngaahi foha ʻoe kau Kohate ʻi honau ngaahi faʻahinga, pea mo e fale ʻo ʻenau ngaahi tamai, ");
INSERT INTO ton_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Mei he taʻu ʻe tolungofulu ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu kotoa pē ʻoku hū ke fai ʻae ngāue, ki he ngāue ʻi he fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Pea ko kinautolu naʻe lau ʻiate kinautolu ʻi honau ngaahi faʻahinga ko e toko ua afe mo e toko fitungeau ma nimangofulu. ");
INSERT INTO ton_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ko kinautolu ni naʻe lau ʻoe fānau ʻoe kau Kohate, ʻakinautolu kotoa pē ʻoku faʻa fai ʻae ngāue ʻi he fale fehikitaki ʻoe kakai, ʻakinautolu naʻe lau ʻe Mōsese mo ʻElone, ʻo fakatatau ki he fekau ʻa Sihova ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Pea ko kinautolu naʻe lau ʻoe ngaahi foha ʻo Kesoni, ʻi honau ngaahi faʻahinga, pea mo e fale ʻo ʻenau ngaahi tamai, ");
INSERT INTO ton_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Mei he taʻu ʻe tolungofulu ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu kotoa pē ʻoku hū ke fai ʻae ngāue, ki he ngāue ʻi he fale fehikitaki ʻoe kakai, ");
INSERT INTO ton_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","‌ʻIo, ʻakinautolu naʻe lau ʻiate kinautolu, ʻi honau ngaahi faʻahinga, mo e fale ʻo ʻenau ngaahi tamai, ko e toko ua afe mo e toko onongeau ma tolungofulu. ");
INSERT INTO ton_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ko kinautolu ni naʻe lau ʻi he fānau ʻoe ngaahi foha ʻo Kesoni, ʻiate kinautolu kotoa pē ʻe ngofua ke fai ʻae ngāue ʻi he fale fehikitaki ʻoe kakai, ʻakinautolu naʻe lau ʻe Mōsese mo ʻElone ʻo fakatatau ki he fekau ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","¶ Pea ko kinautolu naʻe lau ʻoe ngaahi fānau ʻa Melali, ʻi honau ngaahi faʻahinga, mo e fale ʻo ʻenau ngaahi tamai, ");
INSERT INTO ton_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Mei he taʻu ʻe tolungofulu ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu ʻoku hū ke fai ʻae ngāue, ki he ngāue ʻi he fale fehikitaki ʻoe kakai, ");
INSERT INTO ton_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","‌ʻIo, ko kinautolu naʻe lau ʻiate kinautolu, ʻi honau ngaahi faʻahinga, ko e toko tolu afe ma toko uangeau. ");
INSERT INTO ton_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ko kinautolu ni naʻe lau ʻi he fānau ʻoe ngaahi foha ʻo Melali, ʻa ia, naʻe lau ʻe Mōsese mo ʻElone ʻo fakatatau ki he folofola ʻa Sihova ʻi he nima ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ko kinautolu kotoa pē naʻe lau ʻi he kau Livai, ʻakinautolu naʻe lau ʻe Mōsese mo ʻElone mo e houʻeiki ʻo ʻIsileli, ʻi honau ngaahi faʻahinga, pea mo e fale ʻo ʻenau ngaahi tamai, ");
INSERT INTO ton_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Mei he taʻu ʻe tolungofulu ʻo fai hake, ʻio, ʻo aʻu ki he taʻu ʻe nimangofulu, ʻakinautolu kotoa pē naʻe haʻu ke fai ʻae ngāue ʻoe fai fekau, pea mo e tauhi ʻoe kavenga ʻi he fale fehikitaki ʻoe kakai, ");
INSERT INTO ton_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","‌ʻIo, ko kinautolu naʻe lau ʻiate kinautolu, ko e toko valu afe, mo e toko nimangeau ma valungofulu. ");
INSERT INTO ton_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Pea naʻe lau ʻakinautolu ʻe he nima ʻo Mōsese, ʻo fakatatau ki he fekau ʻa Sihova, ʻo taki taha fakatatau ki heʻene ngāue, pea mo ʻene kavenga: naʻe pehē ʻa ʻene lau ʻakinautolu ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ke ke fekau ki he fānau ʻa ʻIsileli, kenau tuku kituaʻā mei he ʻapitanga ʻae kilia kotoa pē, pea mo ia kotoa pē ʻoku fānoa ai ha meʻa, pea mo ia kotoa pē ʻoku fakaʻuli ʻe he mate. ");
INSERT INTO ton_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","‌ʻAe tangata mo e fefine ke mou tuku kituaʻā, ke mou tuku ʻakinautolu ki he tuaʻā ʻoe ʻapitanga: koeʻuhi ke ʻoua naʻa nau fakaʻuli honau ʻapitanga, ʻaia ʻoku ou nofo ai, ʻi hono lotolotonga.” ");
INSERT INTO ton_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Pea naʻe fai pehē ʻae fānau ʻa ʻIsileli, ʻonau tuku ʻakinautolu kituaʻā ʻi he ʻapitanga: ʻo hangē ko e folofola ʻa Sihova kia Mōsese, naʻe pehē ʻae fai ʻene fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Ke ke fakahā ki he fānau ʻa ʻIsileli, ʻOka fai ʻe ha tangata pe ʻe ha fefine ʻae angahala ʻoku fai ʻe he kakai, ke fai ha talangataʻa kia Sihova, pea halaia moʻoni ʻae tokotaha ko ia; ");
INSERT INTO ton_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Tenau toki vete ʻenau angahala ʻaia kuo nau fai; pea te ne totongi ʻene angahala ʻaki ʻae meʻa ʻoku na tatau, pea ne fakalahi ki ai ʻaki ʻa hono vahe nima, pea te ne foaki ia kiate ia naʻa ne fai kovi ki ai. ");
INSERT INTO ton_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Pea kapau ʻoku ʻikai ha kāinga ʻoe tangata ʻoku totongi ki ai ʻae fai kovi, tuku ke ʻatu ʻae totongi ʻoe fai kovi kia Sihova, ʻio, ki he taulaʻeiki; ko e fakalahi eni ʻoe sipitangata ʻoe feilaulau fakalelei ʻaia ʻe fai ʻaki ha fakalelei koeʻuhi ko ia. ");
INSERT INTO ton_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Pea ko e meʻa foaki kotoa pē ʻi he ngaahi meʻa tapu kotoa pē ʻae fānau ʻa ʻIsileli, ʻaia kuo nau ʻomi ki he taulaʻeiki, ʻe ʻaʻana ia. ");
INSERT INTO ton_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Pea ko e ngaahi meʻa ʻae tangata kotoa pē kuo fakatapui, ʻe ʻaʻana ia: pea ko e meʻa kotoa pē ʻe foaki ʻe ha tangata ki he taulaʻeiki ʻe ʻaʻana ia. ");
INSERT INTO ton_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Ke ke fakahā ki he fānau ʻa ʻIsileli, ʻo ke pehē kiate kinautolu, kapau ʻe afe ʻae uaifi ʻo ha tangata, ʻo fai meʻa kovi kiate ia, ");
INSERT INTO ton_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Pea kapau ʻe mohe ha tangata mo ia, pea fakafufū ia mei he mata ʻo hono husepāniti, pea ʻoku ʻikai fakahā, pea kuo ne ʻuliʻi ai, pea ʻoku ʻikai ha taha ke tukuakiʻi ia, pea naʻe ʻikai mamata ki ai ha taha; ");
INSERT INTO ton_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Pea kapau ʻe tō kiate ia ʻae laumālie fakahoa, pea te ne fuaʻa ki hono uaifi, ka kuo ne ʻuliʻi: pea kapau ʻe tō kiate ia ʻae laumālie ʻoe fakahoa, pea te ne fuaʻa ki hono uaifi, ka ʻoku ʻikai ʻuliʻi ia: ");
INSERT INTO ton_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","‌ʻE toki ʻomi ʻe he tangata hono uaifi ki he taulaʻeiki, pea te ne ʻomi ʻa ʻene feilaulau ʻaʻana, ko hono hongofulu ʻoe vahe ʻoe efa ʻoe paʻale kuo momosi; ʻe ʻikai te ne lilingi ʻae lolo ki ai, pe tuku ʻae laipeno ki ai; he ko e feilaulau eni ʻoe fuaʻa, ko e feilaulau ke fakamanatu, ke fakamanatuʻi ai ʻae angahala. ");
INSERT INTO ton_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Pea ʻe ʻomi ia ʻe he taulaʻeiki ke ofi, pea ʻe tuku ia ʻi he ʻao ʻo Sihova: ");
INSERT INTO ton_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Pea ʻe toʻo ʻe he taulaʻeiki ʻae vai tapu ʻi ha ipu ʻumea; pea ʻe toʻo ʻe he taulaʻeiki ʻae efu mei he faliki ʻoe fale fehikitaki, ʻo ʻai ia ki he vai. ");
INSERT INTO ton_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Pea ʻe tuku ʻe he taulaʻeiki ʻae fefine ʻi he ʻao ʻo Sihova, pea ʻe tatala ʻae ʻulu ʻoe fefine, pea ʻe tuku ʻae feilaulau ʻoe fakamanatu ki hono nima, ʻaia ko e feilaulau ʻoe fuaʻa: pea ʻe ʻi he nima ʻoe taulaʻeiki ʻae vai kona, ʻaia ʻoku tupu ai ʻae malaʻia: ");
INSERT INTO ton_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Pea ʻe tuku ia ʻe he taulaʻeiki ke fuakava, ʻo ne pehē ki he fefine, “Kapau naʻe ʻikai te mo mohe mo ha tangata, pea kapau naʻe ʻikai te ke afe ke ʻuliʻi ko e mo ha taha ʻoku ʻikai ko ho husepāniti, te ke ʻataʻatā ko e mei he vai kona ni ʻoku tupu ai ʻae malaʻia: ");
INSERT INTO ton_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pea kapau kuo ke afe ki ha tokotaha, ka ʻoku ʻikai ko ho husepāniti, pea kapau kuo ke ʻuliʻi koe, pea kuo mo mohe mo ha tangata ʻoku ʻikai ko ho husepāniti: ");
INSERT INTO ton_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(Pea ʻe toki tuku ʻe he taulaʻeiki ʻae fefine ke fuakava ki he malaʻia, pea ʻe pehē ʻe he taulaʻeiki ki he fefine), ʻE tuku ko e ʻe Sihova ko e malaʻia, pea mo e fuakavaʻanga ʻi ho kakai, ʻoka ngaohi ko e ʻe Sihova ke popo ho tenga, pea pupula ho kete;” ");
INSERT INTO ton_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Pea ko e vai ni ʻaia ʻoku tupu ai ʻae malaʻia, ʻe hū ia ki ho fatu, pea ʻe pupula ai ho kete, pea popo ai ho tenga. Pea ʻe pehē ʻe he fefine, “ʻEmeni, ʻEmeni.’ ");
INSERT INTO ton_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Pea ʻe tohi ʻe he taulaʻeiki ʻae ngaahi malaʻia ni ʻi ha tohi, pea te ne holoholoʻi ia ke ʻosi ʻaki ʻae vai kona: ");
INSERT INTO ton_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Pea te ne tuku ʻae fefine ke ne inu ʻae vai kona, ʻaia ʻoku tupu ai ʻae malaʻia; pea ko e vai kuo tupu ai ʻae malaʻia ʻe hū kiate ia; pea toki hoko ʻo kona. ");
INSERT INTO ton_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Pea ʻe ʻave ʻe he taulaʻeiki mei he nima ʻoe fefine ʻae feilaulau ʻoe fuaʻa, pea te ne taʻaloʻalo ʻaki ʻae feilaulau ʻi he ʻao ʻo Sihova, pea hili ia ki he funga feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Pea ʻe toʻo ʻe he taulaʻeiki mei he feilaulau ha falukunga, ʻio, ko hono fakamanatu ʻo ia, ʻo tutu ia ʻi he funga feilaulauʻanga, pea hili ia te ne tuku ʻae fefine ke ne inu ʻae vai. ");
INSERT INTO ton_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Pea ʻoka ne ka tuku ʻae fefine ke ne inu ʻae vai, ʻe hoko ʻo pehē, kapau kuo fakaʻuliʻi ia, ʻi heʻene fai meʻa kovi ki hono husepāniti, ko e vai ʻoku tupu ai ʻae malaʻia ʻe hū ia kiate ia, pea hoko ʻo kona, pea ʻe pupula hono kete, pea ʻe popo hono tenga: pea ʻe malaʻia ʻae fefine ʻi hono kakai. ");
INSERT INTO ton_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pea kapau kuo ʻikai fakaʻuliʻi ia, ka ʻoku maʻa pe; ʻe toki ʻataʻatā ia, pea ʻe faʻa tuituʻia ia. ");
INSERT INTO ton_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Ko eni ʻae fono ʻoe fuaʻa ʻoka afe atu ʻae fefine ki ha taha kae tuku ʻa hono husepāniti, pea ʻoku ʻuli ai ia. ");
INSERT INTO ton_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Pea ʻoka tō ki he tangata ʻae laumālie ʻoe fakahoa, pea te ne fuaʻa ki hono uaifi, te ne tuku ʻae fefine ʻi he ʻao ʻo Sihova, pea ʻe fai ʻe he taulaʻeiki kiate ia ʻae fono ni kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Pea ʻe toki ʻataʻatā ʻae tangata mei he angahala, pea ʻe fua ʻe he fefine ni ʻene angahala. ");
INSERT INTO ton_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Ke ke lea ki he fānau ʻa ʻIsileli, ʻo ke pehē kiate kinautolu, ʻOka fakamāvae ia ʻe ha tangata pe ʻe ha fefine ke fuakava ʻi he fuakava ʻae fakamavahe, ke fakamāvae ʻakinautolu kia Sihova: ");
INSERT INTO ton_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","‌ʻE mahuʻi ia mei he uaine mo e inu mālohi, ʻe ʻikai te ne inu ʻae uaine mahi, pe ko e inu mālohi kuo mahi, ʻe ʻikai inu ʻe ia ʻae huhuʻa ʻoe kālepi, pe kai ʻae kālepi mata, pe mōmoa. ");
INSERT INTO ton_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","‌ʻI he ʻaho kotoa pē kuo mavahe ai ia, ʻe ʻikai te ne kai ha meʻa ʻe taha kuo ngaohi mei he ʻakau ko e vaine, mei he tenga ʻo aʻu ki hono kafukafu. ");
INSERT INTO ton_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ko e ʻaho kotoa pē ʻoe fuakava ʻo ʻene mahuʻi ʻe ʻikai hoko ʻae tele ki hono ʻulu: kaeʻoua ke ʻosi ʻae ngaahi ʻaho, ʻaia kuo mavahe ai ia kia Sihova, pea ʻe māʻoniʻoni ia, pea te ne tuku ke lōloa ʻa hono louʻulu. ");
INSERT INTO ton_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Ko e ʻaho kotoa pē kuo mavahe ai ia kia Sihova, ʻoua naʻa ofi ange ia ki ha sino kuo mate. ");
INSERT INTO ton_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","‌ʻE ʻikai te ne fakaʻuliʻi ia koeʻuhi ko ʻene tamai, pe ko ʻene faʻē, pe ko hono tokoua, pe ko hono tuofefine, ʻoka nau ka mate: koeʻuhi ko e fakatapui ia ʻi hono ʻulu ʻe hono ʻOtua. ");
INSERT INTO ton_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ko e ʻaho kotoa pē ʻo ʻene mavahe ʻoku māʻoniʻoni ai ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Pea kapau ʻe mate fakafokifā ha tangata ʻoku ofi kiate ia, pea kapau kuo ne fakaʻuliʻi ʻae fakatapu ʻo hono ʻulu; pehē te ne toki tele hono ʻulu, ʻi he ʻaho ʻo hono fakamaʻa te ne tele ia, ʻi hono ʻaho fitu. ");
INSERT INTO ton_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Pea ʻi hono valu ʻoe ʻaho te ne ʻomi ʻae ongo kulukulu, pe ha ongo lupe mui ki he taulaʻeiki, ki he matapā ʻoe fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Pea ʻe feilaulau ʻaki ʻe he taulaʻeiki ʻae taha ko e feilaulau maʻae angahala, ka ko e taha ko e feilaulau tutu, pea ʻe fai ʻae fakalelei maʻana, he kuo angahala ia ʻi he mate, pea te ne fakatapui ʻa hono ʻulu ʻi he ʻaho ko ia. ");
INSERT INTO ton_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Pea te ne fakatapui kia Sihova ʻae ngaahi ʻaho ʻo ʻene mavahe, pea te ne ʻomi ʻae lami ʻi hono ʻuluaki taʻu ko e feilaulau fakalelei, ka kuo mole ʻae ngaahi muʻaki ʻaho koeʻuhi kuo fakaʻuliʻi ʻe ia ʻa ʻene mavahe. ");
INSERT INTO ton_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","¶ Pea ko eni ʻae fono ʻo ia kuo fakamavahe, ʻoka hili ʻae ngaahi ʻaho ʻo ʻene mahuʻi: ʻe ʻomi ia ki he matapā ʻoe fale fehikitaki ʻoe kakai: ");
INSERT INTO ton_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Pea te ne ʻatu ʻa ʻene feilaulau kia Sihova, ko e lami tangata ʻe taha taʻehanomele ʻi hono ʻuluaki taʻu, ko e feilaulau tutu, pea mo e lami fefine ʻe taha taʻehanomele ʻi hono ʻuluaki taʻu, ko e feilaulau ia maʻae angahala, pea mo e sipitangata ʻe taha taʻehanomele ko e feilaulau fakalelei ia. ");
INSERT INTO ton_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Pea mo e kato mā taʻefakalēvani, ʻae ngaahi foʻi mā ʻoe mahoaʻa lelei kuo fefiofi mo e lolo, pea mo e ngaahi mā manifinifi taʻefakalēvani kuo pani ʻaki ʻae lolo, mo ʻenau feilaulau meʻakai, mo ʻenau feilaulau inu. ");
INSERT INTO ton_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Pea ʻe ʻomi ia ʻe he taulaʻeiki ki he ʻao ʻo Sihova, pea te ne ʻatu ʻa ʻene feilaulau maʻae angahala, mo ʻene feilaulau tutu: ");
INSERT INTO ton_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Pea te ne ʻange ʻae sipitangata, ko e feilaulau fakalelei kia Sihova, mo e kato mā taʻefakalēvani, pea ʻe ʻatu foki ʻe he taulaʻeiki ʻa ʻene feilaulau meʻakai, mo ʻene feilaulau inu. ");
INSERT INTO ton_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Pea ko ia kuo fakamavahe ʻe tele ʻe ia ʻa hono ʻulu ʻi heʻene mavahe ʻi he matapā ʻoe fale fehikitaki ʻoe kakai, pea ʻe ʻave ʻe ia ʻae tuʻoni louʻulu ʻo ʻene mavahe, ʻo tuku ia ki he afi ʻaia ʻoku ʻi he lalo feilaulau fakalelei. ");
INSERT INTO ton_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Pea ʻe ʻave ʻe he taulaʻeiki ʻae alanga ʻoe sipitangata kuo haka, pea mo e foʻi mā ʻe taha taʻefakalēvani mei he kato, mo e mā manifinifi ʻe taha taʻefakalēvani, ʻo ne tuku ia ki he nima ʻo ia kuo fakamavahe, ʻoka hili ʻae tele ʻoe louʻulu ʻo ʻene mahuʻi koe. ");
INSERT INTO ton_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Pea ʻe lieliaki ia ʻe he taulaʻeiki, ko e feilaulau lieliaki ʻi he ʻao ʻo Sihova: ʻoku māʻoniʻoni ia ki he taulaʻeiki, fakataha mo e fatafata lieliaki, mo e alanga nima hiki hake; pea ka hili ia ʻe inu ʻae uaine ʻe ia naʻe fakamanavahē. ");
INSERT INTO ton_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘Pea ko eni ʻae fono ʻo ia kuo fakamavahe ʻaia kuo fuakava, pea mo ʻene feilaulau kia Sihova koeʻuhi ko ʻene mavahe, pea mo ia te ne ʻomi ʻi hono nima: ʻo fakatatau ki he fuakava naʻa ne fuakava ʻaki, ʻe pehē ʻene fai ʻo hangē ko e fono ʻo ʻene mavahe.’” ");
INSERT INTO ton_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Ke ke lea kia ʻElone mo hono ngaahi foha, ʻo ke pehē, ‘ʻE pehē hoʻomou tāpuaki ʻae fānau ʻa ʻIsileli,’ pea te mou pehē kiate kinautolu: ");
INSERT INTO ton_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Ke fakamonūʻia ko e ʻe Sihova, ʻo tauhi koe: ");
INSERT INTO ton_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ke tuku ʻe Sihova ke ulo hono fofonga kiate koe, ʻo ne ʻaloʻofa kiate koe: ");
INSERT INTO ton_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ke hiki hake ʻe Sihova ʻa hono fofonga kiate koe, ʻo tuku ʻae fiemālie kiate koe.’ ");
INSERT INTO ton_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Pea tenau tuku hoku hingoa ki he fānau ʻa ʻIsileli; pea te u fakamonūʻia ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Pea naʻe hoko ʻo pehē ʻi he ʻaho naʻe ʻosi ai hono fokotuʻu ʻe Mōsese ʻae fale fehikitaki, pea ne luluku ia, ʻo fakatapui ia, pea mo hono nāunau kotoa pē, ʻae feilaulauʻanga, pea mo hono ngaahi ipu kotoa pē, pea ne luluku ʻo fakatapui ia; ");
INSERT INTO ton_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Naʻe feilaulau ai ʻae houʻeiki ʻo ʻIsileli, ko e ngaahi ʻeiki ʻoe fale ʻo ʻenau ngaahi tamai, ko e houʻeiki ʻoe ngaahi faʻahinga, pea naʻa nau pule kiate kinautolu naʻe lau: ");
INSERT INTO ton_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Pea naʻa nau ʻomi ʻenau feilaulau ki he ʻao ʻo Sihova, ko e saliote ʻe ono kuo fakapulonga, mo e fanga pulu ʻe hongofulu ma ua; ko e saliote ʻe taha ki he ongo ʻeiki ʻe toko ua, pea naʻa na taki taha ʻae pulu: pea naʻa nau ʻomi ia ki he matafale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ke ke maʻu ia meiate kinautolu, koeʻuhi ke fai ʻaki ia ʻae ngāue ʻoe fale fehikitaki ʻoe kakai; pea te ke tuku ia ki he kau Livai, ki he tangata taki taha ʻo fakatatau ki heʻene ngāue.” ");
INSERT INTO ton_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Pea naʻe ʻave ʻe Mōsese ʻae ngaahi saliote mo e fanga pulu, ʻo ne foaki ia ki he kau Livai. ");
INSERT INTO ton_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Ko e saliote ʻe ua mo e fanga pulu ʻe fā, naʻa ne foaki ki he ngaahi foha ʻo Kesoni, ʻo fakatatau ki heʻenau ngāue: ");
INSERT INTO ton_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Pea mo e saliote ʻe fā mo e fanga pulu ʻe valu naʻa ne foaki ki he ngaahi foha ʻo Melali, ʻo fakatatau ki heʻenau ngāue, ʻi he pule ʻa ʻItama ko e foha ʻo ʻElone ko e taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ka ko e ngaahi foha ʻo Kohate naʻe ʻikai te ne foaki kiate kinautolu ha taha: koeʻuhi naʻe ʻiate kinautolu ʻae tauhi ʻoe faletapu ʻi heʻenau fua ia ki honau uma. ");
INSERT INTO ton_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","¶ Pea naʻe feilaulau ʻae houʻeiki he fakatapui ʻae feilaulauʻanga ʻi he ʻaho naʻe pani ai ia, ʻio naʻe ʻange ʻe he houʻeiki ʻenau feilaulau ʻi he ʻao ʻoe feilaulauʻanga. ");
INSERT INTO ton_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Pea naʻe pehē ʻe Sihova kia Mōsese, “ʻE ʻatu ʻe he houʻeiki ʻenau feilaulau ki he fakatapui ʻoe feilaulauʻanga, ʻo fai taki taha ʻi hono ʻaho.” ");
INSERT INTO ton_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","¶ Pea ko ia naʻe ʻange ʻene feilaulau ʻi he ʻuluaki ʻaho, ko Nasoni ko e foha ʻo ʻAminitapi ʻi he faʻahinga ʻo Siuta: ");
INSERT INTO ton_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko esikeli ʻe teau ma tolungofulu, mo e ipu siliva ʻe taha ko esikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo, ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Mo e sēpuni koula ʻe taha ko esikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: ko e feilaulau eni ʻa Nasoni ko e foha ʻo ʻAminitapi. ");
INSERT INTO ton_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","¶ Pea naʻe feilaulau ʻa Netanili ko e foha ʻo Sua, ko e ʻeiki ʻo ʻIsaka, ʻi hono ʻaho ua: ");
INSERT INTO ton_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Naʻa ne ʻange ki heʻene feilaulau ʻae ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, mo e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatoupito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo, ko e feilaulau meʻakai ia. ");
INSERT INTO ton_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: ko e feilaulau eni ʻa Netanili ko e foha ʻo Sua. ");
INSERT INTO ton_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","¶ Pea naʻe feilaulau ʻa ʻIliapi, ko e foha ʻo Heloni, ko e ʻeiki ʻoe fānau ʻa Sepuloni ʻi hono ʻaho tolu: ");
INSERT INTO ton_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatoupito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo, ko e feilaulau meʻakai ia; ");
INSERT INTO ton_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Mo e ʻuhiki kosi ʻe taha, ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: ko e feilaulau eni ʻa ʻIliapi ko e foha ʻo Heloni. ");
INSERT INTO ton_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","¶ Pea naʻe feilaulau ʻa ʻElisua ko e foha ʻo Setiua, ko e ʻeiki ʻoe fānau ʻa Lupeni ʻi hono ʻaho fā: ");
INSERT INTO ton_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo, ko e feilaulau meʻakai ia; ");
INSERT INTO ton_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala; ");
INSERT INTO ton_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Mo e ʻuhiki kosi ʻe taha, ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko eni ʻae feilaulau ʻa ʻElisua ko e foha ʻo Setiua. ");
INSERT INTO ton_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","¶ Pea naʻe feilaulau ʻa Selumieli ko e foha ʻo Sulisatai, ko e ʻeiki ʻoe fānau ʻa Simione ʻi hono ʻaho nima: ");
INSERT INTO ton_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻa Selumieli ko e foha ʻo Sulisatai. ");
INSERT INTO ton_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","¶ Pea naʻe feilaulau ʻa ʻIliasafi ko e foha ʻo Teuili, ko e ʻeiki ʻoe fānau ʻa Kata ʻi hono ʻaho ono: ");
INSERT INTO ton_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu; pea ko eni ʻae feilaulau ʻa ʻIliasafi ko e foha ʻo Teuili. ");
INSERT INTO ton_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","¶ Pea naʻe feilaulau ʻa ʻIlisama ko e foha ʻo ʻAmihuti, ko e ʻeiki ʻoe fānau ʻa ʻIfalemi ʻi hono ʻaho fitu: ");
INSERT INTO ton_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli  ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli  ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatoupito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo, ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi hono ʻuluaki taʻu; pea ko eni ʻae feilaulau ʻa ʻIlisama ko e foha ʻo ʻAmihuti. ");
INSERT INTO ton_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","¶ Pea naʻe feilaulau ʻa Kāmelieli ko e foha ʻo Petasuli, ko e ʻeiki ʻoe fānau ʻa Manase ʻi hono ʻaho valu: ");
INSERT INTO ton_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau kai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻa Kāmelieli ko e foha ʻo Petasuli. ");
INSERT INTO ton_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","¶ Pea naʻe feilaulau ʻa ʻEpitani ko e foha ʻo Kitione, ko e ʻeiki ʻoe fānau ʻa Penisimani ʻi hono ʻaho hiva: ");
INSERT INTO ton_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Mo e sēpuni koula ʻe taha, ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻo ʻEpitani ko e foha ʻo Kitione. ");
INSERT INTO ton_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","¶ Pea naʻe feilaulau ʻa ʻEhiesa ko e foha ʻo ʻAmisatai, ko e ʻeiki ʻoe fānau ʻa Tani ʻi hono ʻaho hongofulu: ");
INSERT INTO ton_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Mo e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻa ʻEhiesa ko e foha ʻo ʻAmisatai. ");
INSERT INTO ton_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","¶ Pea naʻe feilaulau ʻa Pakieli ko e foha ʻo ʻOkilani, ko e ʻeiki ʻoe fānau ʻa ʻAseli ʻi hono ʻaho hongofulu ma taha: ");
INSERT INTO ton_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Pea ko ʻene feilaulau ko e ipu siliva lahi ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau meʻakai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Ko e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻa Pakieli ko e foha ʻo ʻOkilani. ");
INSERT INTO ton_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","¶ Pea naʻe feilaulau ʻa Heila ko e foha ʻo ʻEnani, ko e ʻeiki ʻoe fānau ʻa Nafitali ʻi hono ʻaho hongofulu ma ua: ");
INSERT INTO ton_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Pea ko ʻene feilaulau ko e ipu siliva ʻe taha, ko hono mamafa ko e sikeli ʻe teau ma tolungofulu, ko e ipu siliva ʻe taha, ko e sikeli ʻe fitungofulu, ʻo fakatatau ki he sikeli ʻoe faletapu; naʻe fakatou pito ia ʻi he mahoaʻa lelei kuo fefiofi mo e lolo ko e feilaulau kai ia: ");
INSERT INTO ton_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Mo e sēpuni koula ʻe taha ko e sikeli ʻe hongofulu, naʻe pito ia ʻi he ʻakau namu kakala: ");
INSERT INTO ton_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Mo e pulu mui ʻe taha, mo e sipitangata, mo e lami ʻe taha ʻi hono ʻuluaki taʻu, ko e feilaulau tutu ia: ");
INSERT INTO ton_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Ko e ʻuhiki kosi ʻe taha ko e feilaulau ia maʻae angahala: ");
INSERT INTO ton_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Pea ko e feilaulau ki he feilaulau fakalelei, ko e fanga pulu ʻe ua, mo e sipitangata ʻe nima, mo e kosi tangata ʻe nima, mo e lami ʻe nima ʻi honau ʻuluaki taʻu: pea ko e feilaulau eni ʻa Heila ko e foha ʻo ʻEnani. ");
INSERT INTO ton_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Pea ko e fakatapui eni ʻoe feilaulauʻanga, ʻi he ʻaho naʻe pani ai ia, ʻe he houʻeiki ʻo ʻIsileli: ko e ipu siliva lahi ʻe hongofulu ma ua, mo e ipu siliva kehe ʻe hongofulu ma ua, mo e sēpuni koula ʻe hongofulu ma ua: ");
INSERT INTO ton_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ko e ipu siliva lahi ko hono mamafa taki taha ko e sikeli ʻe teau ma tolungofulu, mo e ipu kehe taki taha ko e fitungofulu: ko e ngaahi ipu siliva kotoa pē ko e sikeli ʻe ua afe ma fāngeau hono mamafa, ʻo fakatatau ki he sikeli ʻoe faletapu: ");
INSERT INTO ton_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ko e sēpuni koula ʻe hongofulu ma ua, naʻe pito ʻi he ʻakau namu kakala, ko hono mamafa taki taha ko e sikeli ʻe hongofulu, ʻo fakatatau ki he sikeli ʻoe faletapu: ko e koula kotoa pē ʻoe ngaahi sēpuni ko e sikeli ʻe teau ma uofulu. ");
INSERT INTO ton_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ko e fanga pulu kotoa pē ki he feilaulau tutu ko e pulu ʻe hongofulu ma ua, ko e sipitangata ʻe hongofulu ma ua, ko e lami ʻoe ʻuluaki taʻu ʻe hongofulu ma ua, ʻo fakataha mo ʻenau feilaulau meʻakai: pea mo e ʻuhiki kosi ʻe hongofulu ma ua ki he feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Pea ko e fanga pulu kotoa pē ki he feilaulau fakalelei, ko e pulu ʻe uofulu ma fā, mo e sipitangata ʻe onongofulu, mo e kosi tangata ʻe onongofulu, mo e lami ʻoe ʻuluaki taʻu ʻe onongofulu. Ko e fakatapui eni ʻoe feilaulauʻanga, ʻi he hili hono pani. ");
INSERT INTO ton_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","¶ Pea ʻi heʻene ʻalu ʻa Mōsese ki he fale fehikitaki ʻoe kakai ke lea ki he ʻOtua, naʻa ne fanongo ki he leʻo ʻoe tokotaha naʻe lea kiate ia mei he nofoʻanga ʻoe ʻaloʻofa ʻaia naʻe tuʻu ʻi he funga ʻoe puha ʻoe fuakava, mei he vahaʻa ʻoe ongo selupimi: pea naʻa ne folofola mai kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ke ke lea kia ʻElone, mo ke pehē kiate ia, ʻOka ke ka fokotuʻu ʻae ngaahi maama ʻe ulo atu ʻae ngaahi maama ʻe fitu mei he tuʻunga maama.” ");
INSERT INTO ton_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Pea naʻe fai pehē ʻe ʻElone; naʻa ne tutu ʻae ngaahi maama ʻi ai ke ulo atu mei he tuʻunga maama, ʻo hangē ko e fekau ʻa Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Pea naʻe ngaohi ʻae tuʻunga maama ʻaki ʻae koula kuo tuki, ʻo aʻu hifo ki hono kau, mo hono ngaahi fisi, ko e koula tuki ia: ʻo hangē ko e fakatātā ʻaia naʻe fakahā ʻe Sihova kia Mōsese, naʻe pehē ʻene ngaohi ʻae tuʻunga maama. ");
INSERT INTO ton_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Mavahe ʻae kau Livai mei he fānau ʻa ʻIsileli, ʻo fakamaʻa ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Pea ʻe pehē ni hoʻo fai kiate kinautolu, ke fakamaʻa ʻakinautolu: Ke ke luluku ʻakinautolu ʻaki ʻae vai fakamaʻa, ʻo tuku ʻakinautolu ke nau tele honau sino kotoa pē, ʻo fō honau ngaahi kofu, ke pehē ʻenau fakamaʻa ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Pea tenau toki ʻave ʻae pulu mui fakataha mo e feilaulau meʻakai ʻoku kau ai, ʻio, ʻae mahoaʻa lelei kuo fefiofi mo e lolo, pea te ke ʻave ʻae pulu mui ʻe taha ko e feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Pea te ke ʻomi ʻae kau Livai ki he matafale fehikitaki ʻoe kakai: pea te ke tānaki ʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli kenau fakataha: ");
INSERT INTO ton_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Pea te ke ʻomi ʻae kau Livai ki he ʻao ʻo Sihova: pea ko e fānau ʻa ʻIsileli tenau hilifaki honau nima ki he kau Livai: ");
INSERT INTO ton_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Pea ʻe ʻatu ʻe ʻElone ʻae kau Livai ki he ʻao ʻo Sihova ko e feilaulau ia ʻae fānau ʻa ʻIsileli, koeʻuhi kenau fai ki he ngāue ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Pea ʻe hilifaki ʻe he kau Livai honau nima ki he ʻulu ʻoe ongo pulu: pea te ke ʻatu ʻae taha ko e feilaulau maʻae angahala, pea ko e taha ko e feilaulau tutu, kia Sihova, ke fai ʻae fakalelei koeʻuhi ko e kau Livai. ");
INSERT INTO ton_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“Pea te ke tuku ʻae kau Livai ʻi he ʻao ʻo ʻElone, mo e ʻao ʻo hono ngaahi foha, ʻo ʻatu ʻakinautolu ko e feilaulau kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","‌ʻE pehē haʻo vaheʻi ʻae kau Livai mei he fānau ʻa ʻIsileli: pea ko e kau Livai ʻe ʻoʻoku ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Pea hili ia, ʻe ʻalu ʻae kau Livai ke fai ʻae ngāue ʻoe fale fehikitaki ʻoe kakai: pea te ke fakamaʻa ʻakinautolu, ʻoatu ʻakinautolu ko e feilaulau. ");
INSERT INTO ton_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","He kuo tuku maʻaku ʻakinautolu mei he fānau ʻa ʻIsileli; ke fetongi ʻaki ʻakinautolu ʻoku fuofua tō mei he manāva, ʻio ke fetongi ʻaki ʻae ʻuluaki fānau ʻoe fānau ʻa ʻIsileli, ko ia kuo u ʻomi ai maʻaku ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","He ko e ʻuluaki tama kotoa pē ʻoe fānau ʻa ʻIsileli ʻe ʻoʻoku ia, ʻae tangata mo e manu fakatouʻosi pe: ʻi he ʻaho ne u taaʻi ai ʻae ʻuluaki tama kotoa pē ʻi he fonua ko ʻIsipite, ne u fakatapui ʻakinautolu maʻaku. ");
INSERT INTO ton_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Pea kuo u fili mai ʻae kau Livai ke fetongi ʻaki ʻae ʻuluaki tama kotoa pē ʻi he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Pea kuo u foaki ʻae kau Livai mei he fānau ʻa ʻIsileli ko e foaki kia ʻElone mo hono ngaahi foha ke fai ʻae ngāue maʻae fānau ʻa ʻIsileli ʻi he fale fehikitaki ʻoe kakai, pea kenau fai ʻae fakalelei koeʻuhi ko e fānau ʻa ʻIsileli: koeʻuhi ke ʻoua naʻa hoko ha mahaki fakaʻauha ki he fānau ʻa ʻIsileli, ʻoka haʻu ʻo ofi ʻae fānau ʻa ʻIsileli ki he faletapu.” ");
INSERT INTO ton_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Pea ko Mōsese mo ʻElone, mo e kakai kotoa pē ʻoe fānau ʻa ʻIsileli, naʻa nau fai ki he kau Livai ʻo fakatatau ki he fekau kotoa pē ʻa Sihova kia Mōsese koeʻuhi ko e kau Livai, naʻe fai pehē ʻae fānau ʻa ʻIsileli kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Pea naʻe fakamaʻa ʻae kau Livai, pea naʻa nau fō honau ngaahi kofu; pea naʻe ʻatu ʻe ʻElone ʻakinautolu ko e feilaulau ʻi he ʻao ʻo Sihova; pea naʻe fai ʻe ʻElone ʻae fakalelei maʻanautolu ke fakamaʻa ʻakinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Pea hili ia naʻe hū ʻae kau Livai ke fai ʻae ngāue ʻi he fale fehikitaki ʻoe kakai ʻi he ʻao ʻo ʻElone, mo e ʻao ʻo hono ngaahi foha: ʻo hangē ko e fekau ʻa Sihova kia Mōsese koeʻuhi ko e kau Livai, naʻa nau fai pehē kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","¶ “Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Pea ko e meʻa ni ʻoku kau ki he kau Livai: tenau hū ke talifekau ʻi he ngāue ʻoe fale fehikitaki ʻoe kakai mei honau taʻu ʻe uofulu ma nima: ");
INSERT INTO ton_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Pea ʻoka hoko ki he nimangofulu taʻu, tenau tuku ʻa ʻenau tauhi ʻae ngāue ʻi ai, pea ʻe ʻikai tenau toe fai: ");
INSERT INTO ton_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ka tenau fai fakataha mo honau kāinga ʻi he fale fehikitaki ʻoe kakai, ke fai ki he tauhi, ka ʻe ʻikai tenau fai ha ngāue lahi. Ke ke fai pehē ki he kau Livai ʻi honau tauhi.” ");
INSERT INTO ton_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese ʻi he toafa ʻo Sainai, ʻi he ʻuluaki māhina ʻo hono ua taʻu hili ʻenau haʻu mei he fonua ko ʻIsipite, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Tuku ʻae fānau ʻa ʻIsileli kenau fai foki ʻae Lakaatu ʻi hono ngaahi ʻaho kuo kotofa. ");
INSERT INTO ton_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","‌ʻI hono ʻaho hongofulu ma fā ʻoe māhina ni, ʻi he efiafi, te mou fai ia ʻi hono ngaahi ʻaho kuo kotofa: ʻo fakatatau ki hono anga kotoa pē, pea te mou fai ia ʻo fakatatau ki hono tuʻutuʻuni kotoa pē.” ");
INSERT INTO ton_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Pea naʻe lea ʻa Mōsese ki he fānau ʻa ʻIsileli, kenau fai ʻae Lakaatu. ");
INSERT INTO ton_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Pea naʻa nau fai ʻae Lakaatu ʻi hono ʻaho hongofulu ma fā ʻoe ʻuluaki māhina, ʻi he efiafi, ʻi he toafa ʻo Sainai: ʻo fakatatau ki he fekau kotoa pē ʻa Sihova kia Mōsese, naʻe fai pehē ʻae fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","¶ Pea naʻe ʻi ai ʻae kau tangata niʻihi, naʻa nau taʻemaʻa ʻi he sino mate ʻo ha tangata, ko ia naʻe ʻikai ai tenau fai ʻae Lakaatu ʻi he ʻaho ko ia: pea naʻa nau haʻu ki he ʻao ʻo Mōsese mo ʻElone ʻi he ʻaho ko ia: ");
INSERT INTO ton_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Pea naʻe lea pehē ʻae kau tangata ko ia kiate ia, “ʻOku mau ʻuli ʻi he sino mate ʻoe tangata: ko e hā kuo taʻofi ai ʻakimautolu, ke ʻoua naʻa mau ʻatu ʻae feilaulau kia Sihova ʻi hono kuonga kuo kotofa ki he fānau ʻa ʻIsileli?” ");
INSERT INTO ton_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Pea naʻe pehē ʻe Mōsese kiate kinautolu, “Mou tatali, kaeʻoua ke u fanongo pe ko e hā ʻe fekau ʻe Sihova kiate kimoutolu.” ");
INSERT INTO ton_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Ke ke lea ki he fānau ʻa ʻIsileli, mo ke pehē, “Kapau ʻe taʻemaʻa ha tangata ʻiate kimoutolu pe ʻi homou hako koeʻuhi ko e sino mate, pea mo ia ʻoku fononga mamaʻo, ʻe fai pe ʻe ia ʻae Lakaatu kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","‌ʻI hono ʻaho hongofulu ma fā ʻo hono ua māhina ʻi he efiafi tenau fai ia, pea ʻe kai fakataha ia mo e mā taʻefakalēvani mo e ngaahi ʻakau kona. ");
INSERT INTO ton_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","‌ʻE ʻikai tenau tuku hono toe ki he ʻapongipongi, pe fesiʻi ha hui ʻi ai: tenau fai ia ʻo fakatatau ki he ngaahi tuʻutuʻuni ʻoe Lakaatu. ");
INSERT INTO ton_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ka ko e tangata ʻoku maʻa, pea ʻoku ʻikai fononga mamaʻo, pea ʻoku ʻikai fai ʻe ia ʻae laka-atu, ko e tangata ko ia ʻe tuʻusi mei hono kakai: koeʻuhi naʻe ʻikai te ne ʻomi ʻae feilaulau ʻa Sihova ʻi hono ʻaho kuo kotofa; ʻe fua ʻe he tangata ko ia ʻa ʻene angahala. ");
INSERT INTO ton_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Pea kapau ʻe ʻāunofo ha muli ʻiate kimoutolu, pea fai ʻe ia ʻae Lakaatu kia Sihova; ʻe fakatatau ki he tuʻutuʻuni ʻoe Lakaatu, pea fakatatau ki hono anga, ʻe pehē ʻene fai: ko e fekau pe taha te mou maʻu ki he muli, pea mo ia ʻoku fanauʻi ʻi he fonua.” ");
INSERT INTO ton_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","¶ Pea ʻi he ʻaho naʻe fokotuʻu ai ʻae fale fehikitaki naʻe ʻuʻufi ʻaki ʻae fale fehikitaki ʻae ʻao, ʻio, ko e fale fehikitaki ʻoe fakamoʻoni: pea naʻe ʻi he funga fale fehikitaki ʻi he efiafi ʻae meʻa ʻo hangē ko e afi, ʻo aʻu ki he pongipongi. ");
INSERT INTO ton_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Naʻe pehē maʻuaipē: naʻe ʻuʻufi ʻaki ia ʻae ʻao ʻi he ʻaho, pea hangē ko e afi ʻi he pō. ");
INSERT INTO ton_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Pea ʻoka toʻo hake ʻae ʻao mei he fale fehikitaki, hili ia, naʻe fononga ʻae fānau ʻa ʻIsileli: pea ko e potu naʻe tuʻu ai ʻae ʻao, ko ia naʻa nau fokotuʻu ai honau ngaahi fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Pea naʻe fononga atu ʻae fānau ʻa ʻIsileli ʻi he fekau ʻa Sihova, pea nau nofo ʻi he fekau ʻa Sihova: naʻa nau nofo ʻi honau ʻapitanga ʻo hangē ko hono fuoloa ʻoe nofo ʻae ʻao ʻi he funga fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Pea ka tatali fuoloa ʻae ʻao ʻi he funga fale fehikitaki ʻo ʻaho lahi, naʻe fai ʻe he fānau ʻa ʻIsileli ki he tauhi ʻo Sihova, pea naʻe ʻikai fononga. ");
INSERT INTO ton_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Pea naʻe pehē, ʻi he nofo ʻae ʻao ʻi he funga fale fehikitaki ʻi he ngaahi ʻaho siʻi; ʻo fakatatau ki he fekau ʻa Sihova naʻa nau nofo ʻi honau ʻapitanga, pea naʻa nau fononga ʻo fakatatau ki he fekau ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Pea naʻe pehē, ka tuʻu ʻae ʻao mei he efiafi ʻo aʻu ki he pongipongi, pea toki toʻo hake ʻae ʻao ʻi he pongipongi, naʻa nau fononga: ʻi he ʻaho pe ʻi he pō kuo toʻo hake ai ʻae ʻao naʻa nau fononga. ");
INSERT INTO ton_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Pea kapau ko e ʻaho ʻe ua, pe taha māhina, pe taha taʻu, mo e tuʻu ʻae ʻao ʻi he funga fale fehikitaki, ʻo tuʻumaʻu ai, naʻe nofo ʻae fānau ʻa ʻIsileli ʻi honau ʻapitanga, pea naʻe ʻikai tenau fononga: pea ʻi hono toʻo hake ia naʻa nau fononga. ");
INSERT INTO ton_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Pea naʻa nau mālōlō ʻi honau ʻapitanga ʻi he fekau ʻa Sihova, pea naʻa nau fononga ʻi he fekau ʻa Sihova: naʻa nau fai ki he pule ʻa Sihova, ʻi he fekau ʻa Sihova ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Ke ke ngaohi maʻau ʻae meʻalea ʻe ua ʻaki ʻae siliva, ko e konga pe taha ke ke ngaohi ʻaki ia: koeʻuhi ke ke ui ʻaki ia ʻae fakataha, pea mo e fononga ʻoe ngaahi ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Pea ʻoka nau ka ifi ia ʻe fakataha ʻae kakai kotoa pē kiate koe ki he matapā ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Pea kapau tenau ifi ʻaki ʻae meʻalea pe taha, ʻe toki fakataha ai kiate koe ʻae houʻeiki, ʻaia ʻoku ʻeiki ki he ngaahi toko afe ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Pea ka mou ka ifi fakakaila, ʻe toki hiki atu ʻae ngaahi ʻapitanga ʻoku nofo ʻi he potu hahake. ");
INSERT INTO ton_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Pea ka mou ka ifi fakakaila ʻo tuʻo ua, ʻe toki hiki atu ʻae ngaahi ʻapitanga ʻoku nofo ʻi he potu tonga: ʻe ifi fakakaila ia ke teu honau fononga. ");
INSERT INTO ton_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ka ʻi he tānaki ʻo fakataha ʻae kakai te mou ifi, ka ʻe ʻikai te mou ifi fakakaila. ");
INSERT INTO ton_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","¶ “Pea ko e ngaahi foha ʻo ʻElone, ko e kau taulaʻeiki, tenau ifi ʻae ongo meʻalea; Pea ʻe tuku ia ko e talatuku ki homou ngaahi toʻutangata ʻo lauikuonga. ");
INSERT INTO ton_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Pea kapau te mou ʻalu ʻi homou fonua ke tau ki he fili ʻoku fakamālohi kiate kimoutolu, te mou toki ifi fakakailaʻaki ʻae ongo meʻalea: pea ʻe manatuʻi ʻakimoutolu ʻi he ʻao ʻo Sihova ko homou ʻOtua, pea ʻe fakamoʻui ʻakimoutolu mei homou ngaahi fili. ");
INSERT INTO ton_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Pea ko e ʻaho foki ʻo hoʻomou fiefia, pea mo homou ngaahi ʻaho tapu, ʻi he ʻuluaki ʻo homou ngaahi māhina, te mou ifi ʻaki ʻae ongo meʻalea ʻi hoʻomou feilaulau tutu, pea mo e feilaulau ʻi hoʻomou feilaulau fakalelei; koeʻuhi ke tuku ia ko e fakamanatu kiate kimoutolu ʻi he ʻao ʻo homou ʻOtua: Ko au ko Sihova ko homou ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","¶ Pea naʻe hoko ʻo pehē ʻi he ʻaho uofulu ʻo hono ua māhina, ʻi hono ua ʻoe taʻu naʻe toʻo hake ʻae ʻao mei he fale fehikitaki ʻoe fakamoʻoni. ");
INSERT INTO ton_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Pea naʻe fononga atu ʻae fānau ʻa ʻIsileli mei he toafa ʻo Sainai; pea naʻe tuʻu ʻae ʻao ʻi he toafa ʻo Palani. ");
INSERT INTO ton_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Pea naʻa nau tomuʻa fononga ʻo hangē ko e fekau ʻa Sihova ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Pea naʻe muʻomuʻa ʻae fakaʻilonga ʻoe fakataha ʻoe fānau ʻa Siuta ʻo fakatatau ki heʻenau ngaahi matatau: pea ko Nasoni ko e foha ʻo ʻAminitapi naʻe pule ia ki heʻene kautau. ");
INSERT INTO ton_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Pea ko Netanili ko e foha ʻo Sua, naʻe pule ia ki he kau tau ʻoe faʻahinga ʻoe fānau ʻa ʻIsaka. ");
INSERT INTO ton_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Pea ko ʻIliapi ko e foha ʻo Heloni, naʻe pule ia ki he kau tau ʻoe faʻahinga ʻoe fānau ʻa Sepuloni. ");
INSERT INTO ton_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Pea naʻe vete hifo ʻae fale fehikitaki; pea ko e ngaahi foha ʻo Kesoni mo e ngaahi foha ʻo Melali naʻa nau hiki atu, ʻo fua ʻae fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","¶ Pea naʻe hiki atu ʻae fakaʻilonga ʻoe fakataha ʻo Lupeni ʻo fakatatau ki heʻenau ngaahi matatau: pea ko ʻIlisua ko e foha ʻo Setiua naʻe pule ia ki heʻene kautau. ");
INSERT INTO ton_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Pea ko Selumieli ko e foha ʻo Sulisatai, naʻe pule ia ki he kautau ʻoe faʻahinga ʻoe fānau ʻa Simione. ");
INSERT INTO ton_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Pea ko ʻIliasafi ko e foha ʻo Teuili, naʻe pule ia ki he kautau ʻoe faʻahinga ʻoe fānau ʻa Kata. ");
INSERT INTO ton_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Pea naʻe hiki atu ʻae kau Kohate, ʻonau fua ʻae faletapu: pea naʻe fokotuʻu ʻe he kau Kesoni mo e kau Melali ʻae fale fehikitaki ʻi he teʻeki ai ke nau haʻu. ");
INSERT INTO ton_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","¶ Pea naʻe hiki atu ʻae fakaʻilonga ʻoe fakataha ʻoe fānau ʻa ʻIfalemi, ʻo fakatatau ki heʻenau ngaahi matatau: pea ko ʻIlisama. Ko e foha ʻo ʻAmihuti naʻe pule ia ki heʻene kautau. ");
INSERT INTO ton_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Pea ko Kāmelieli ko e foha ʻo Petasuli, naʻe pule ia ki he kautau ʻoe faʻahinga ʻoe fānau ʻa Manase. ");
INSERT INTO ton_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Pea ko ʻEpitani ko e foha ʻo Kitione, naʻe pule ia ki he kautau ʻoe faʻahinga ʻoe fānau ʻa Penisimani. ");
INSERT INTO ton_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","¶ Pea naʻe hiki atu ʻae fakaʻilonga ʻoe fakataha ʻoe fānau ʻa Tani, ʻaia naʻe muimui ʻi he kongakau kotoa pē ʻi heʻenau ngaahi kautau: pea ko ʻEhiesa ko e foha ʻo ʻAmisatai, naʻe pule ia ki heʻene kautau. ");
INSERT INTO ton_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Pea ko Pakieli ko e foha ʻo ʻOkilani, naʻe pule ia ki he kautau ʻoe faʻahinga ʻoe fānau ʻa ʻAseli. ");
INSERT INTO ton_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Pea ko Heila ko e foha ʻo ʻEnani, naʻe pule ia ki he kau tau ʻoe faʻahinga ʻoe fānau ʻa Nafitali ");
INSERT INTO ton_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Pea naʻe pehē ʻae ngaahi fononga ʻoe fānau ʻa ʻIsileli ʻo fakatatau ki heʻenau ngaahi matatau, ʻi heʻenau hiki atu ke ʻalu. ");
INSERT INTO ton_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","¶ Pea naʻe pehē ʻe Mōsese kia Hopapi, ko e foha ʻo Lakueli ko e Mitiane, ko e tamai ʻa Mōsese ʻi he fono, “ʻOku mau fononga ki he potu ʻaia kuo pehē ki ai ʻe Sihova, Te u foaki ia kiate kimoutolu: haʻu ke tau ō, pea te mau fai lelei kiate koe: he kuo folofola lelei ʻa Sihova ki ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Pea naʻa ne pehēange kiate ia, “ʻE ʻikai te u ʻalu; ka te u foki au ki hoku fonua, pea mo hoku kāinga. ");
INSERT INTO ton_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Pea naʻe pehē ʻe ia, “ʻOku ou kole kiate koe, ʻoua naʻa ke ʻalu ʻiate kimautolu; koeʻuhi ʻoku ke ʻilo ʻae anga ʻo ʻemau nofo ʻi he toafa, pea te ke ʻiate kimautolu ʻo hangē ko homau mata. ");
INSERT INTO ton_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Pea ʻe hoko ʻo pehē, ʻo kapau te tau ō mo koe, ʻio, ʻe hoko ʻo pehē, ko e angalelei ʻe fai ʻe Sihova kiate kimautolu, ko ia pe te mau fai kiate koe.” ");
INSERT INTO ton_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","¶ Pea naʻa nau ʻalu mei he moʻunga ʻo Sihova ʻo fononga ʻi he ʻaho ʻe tolu: pea naʻe muʻomuʻa ʻiate kinautolu ʻae puha ʻoe fuakava ʻo Sihova ʻi he fononga ʻi he ʻaho ʻe tolu ko ia, ke kumi ha mālōlōʻanga moʻonautolu. ");
INSERT INTO ton_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Pea naʻe ʻiate kinautolu ʻae ʻao ʻa Sihova ʻi he ʻaho, ʻi heʻenau hiki mei he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Pea naʻe hoko ʻo pehē, ʻI heʻene hiki atu ʻae puha, naʻe pehē ʻe Mōsese, “ʻE Sihova, Tuʻu hake, pea tuku ke movetevete ho ngaahi fili; pea ke tuku ʻakinautolu ʻoku fehiʻa ki hoʻo ʻafio ke vilingia ʻi ho ʻao.” ");
INSERT INTO ton_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Pea ʻi heʻene nofo ia, naʻa ne pehē, “ʻE Sihova, ke ke foki mai ki he ngaahi toko afe fakamanavahē ʻo ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Pea naʻe lāunga ʻae kakai, pea houhau ai ʻa Sihova; pea naʻe fanongo ki ai ʻa Sihova; pea naʻe tutu hono houhau, pea naʻe vela ʻae afi ʻa Sihova ʻiate kinautolu, pea naʻe ʻai ʻae fakaʻauha ʻi he potu kotoa pē ʻoe ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Pea naʻe tangi ʻae kakai kia Mōsese pea ʻi he lotu ʻa Mōsese kia Sihova, ne mate ai ʻae afi. ");
INSERT INTO ton_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Pea naʻa ne fakahingoa ʻae potu ko ia ko Tapela: koeʻuhi naʻe vela ai ʻae afi ʻa Sihova ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","¶ Pea ko e kakai ʻiate kinautolu mei he potu kehekehe naʻa nau tō ki he holi fakasino: pea naʻe toe tangi foki ʻae fānau ʻa ʻIsileli, ʻo pehē, “Ko hai te ne foaki kiate kitautolu ha kakano ke tau kai? ");
INSERT INTO ton_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","‌ʻOku tau manatu ki he ika, ʻaia naʻa tau kai faʻiteliha pe ʻi ʻIsipite; mo e kukumipa, mo e meleni, pea mo e liki, mo e onioni, pea mo e kāliki: ");
INSERT INTO ton_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ka ko eni kuo fakamahamaha ʻetau moʻui ke ʻosi; ʻoku ʻikai ha meʻa ʻe taha ʻi hotau ʻao, ka ko e mana ni.” ");
INSERT INTO ton_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Pea naʻe hangē ko e tengaʻi kolianita ʻae mana, pea ko hono lanu naʻe hangē ko e lanu ʻoe mataʻitofe. ");
INSERT INTO ton_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Pea naʻe ʻalu ʻae kakai, ʻo tānaki ia, pea naʻa nau momosi ia ʻi he ngaahi meʻa momosi, pe tuki ia ʻi ha ipu, pea naʻe tunu ia ʻi he ngaahi ipu kapa, pea naʻe ngaohi ʻaki ia ʻae ngaahi foʻi ma: pea ko hono ifo naʻe tatau mo e ifo ʻoe lolo foʻou, ");
INSERT INTO ton_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Pea ʻi heʻene tō ʻae hahau ʻi he poʻuli ki he ʻapitanga, naʻe tō ʻae mana ki ai. ");
INSERT INTO ton_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","¶ Pea naʻe toki fanongo ʻa Mōsese ki he tangi ʻae kakai ʻi honau ngaahi faʻahinga, ʻae tangata taki taha ʻi he matapā ʻo hono fale fehikitaki: pea naʻe vela ʻae houhau ʻo Sihova ʻo lahi; pea naʻe ʻita foki ʻa Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Pea naʻe pehē ʻe Mōsese kia Sihova, “Ko e hā kuo ke fakamamahiʻi ai ʻa hoʻo tamaioʻeiki? Pea ko e hā kuo ʻikai te u ʻiloa ai ʻae ʻofa ʻi ho ʻao, koeʻuhi kuo ke tuku ʻae kavenga ʻae kakai ni kotoa pē kiate au? ");
INSERT INTO ton_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","He ko au koā naʻe tuʻituʻia ʻi he kakai ni kotoa pē? Pe ko au naʻaku fakatupu ʻakinautolu? He kuo ke folofola mai kiate au, Ke ke fua ʻakinautolu ʻi ho fatafata, ʻo hangē ko e tamai ʻoku ne tauhi, ʻo fua ʻae tamasiʻi ʻoku huhu, ki he fonua ʻaia naʻa ke fuakava ʻaki ki heʻenau ngaahi tamai? ");
INSERT INTO ton_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Pea te u maʻu mei fē ʻeau ha kakano ke foaki ki he kakai ni kotoa pē? He ʻoku nau tangi kiate au, ʻonau pehē, Foaki mai ha kakano maʻamautolu koeʻuhi ke mau kai. ");
INSERT INTO ton_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","‌ʻOku ʻikai te u mālohi ke u fua tokotaha pe ʻae kakai ni, koeʻuhi ʻoku nau mamafa fau kiate au. ");
INSERT INTO ton_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Pea kapau te ke fai pehē kiate au, ʻoku ou kole atu ki hoʻo ʻafio ke ke tāmateʻi leva au mei ho nima, ʻo kapau ʻoku ou ʻiloa ʻae ʻofa ʻi ho ʻao; kaeʻoua ʻe tuku au ke u mamata ki hoku mamahi.” ");
INSERT INTO ton_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","¶ Pea naʻe pehē ʻe Sihova kia Mōsese, “Tānaki mai kiate au ʻae kau tangata ʻe toko fitungofulu ʻi he kau mātuʻa ʻo ʻIsileli, ʻakinautolu ʻoku ke ʻilo ko e kau mātuʻa ʻi he kakai, pea mo e kau matāpule ʻiate kinautolu; pea ke ʻomi ʻakinautolu ki he fale fehikitaki ʻoe kakai, koeʻuhi kenau tuʻu fakataha ʻi ai mo koe. ");
INSERT INTO ton_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Pea te u ʻalu hifo ʻo ta alea ʻi ai mo koe: pea te u toʻo ʻae laumālie ʻoku ʻiate koe, ʻo tuku ia kiate kinautolu; pea tenau fua fakataha mo ko e ʻae kavenga ʻae kakai, ʻe ʻikai te ke fua tokotaha pe ia ");
INSERT INTO ton_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Pea te ke pehē ki he kakai, Fakamaʻa ʻakimoutolu ki he ʻapongipongi, pea te mou kai kakano: he kuo mou tangi ki he fofonga ʻo Sihova, ʻo pehē, Ko hai te ne foaki kiate kimautolu ha kakano ke mau kai; he naʻa mau lelei ʻi ʻIsipite: pea ko ia ʻe foaki ai ʻe Sihova ʻae kakano kiate kimoutolu, pea te mou kai. ");
INSERT INTO ton_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","‌ʻE ʻikai te mou kai ia ʻi he ʻaho pe taha, pe ʻi he ʻaho ʻe ua, pe ʻi he ʻaho ʻe nima, pe ʻi he ʻaho ʻe hongofulu, pe ʻi he ʻaho ʻe uofulu; ");
INSERT INTO ton_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ka ko e māhina kātoa, ke ʻoua ke haʻu ia ʻi homou avaʻi ihu, pea ʻe fakalielia ia kiate kimoutolu: koeʻuhi naʻa mou fehiʻa kia Sihova ʻaia ʻoku ʻiate kimoutolu, pea kuo mou tangi ʻi hono ʻao, ʻo pehē, Ko e hā ne mau haʻu ai mei ʻIsipite?” ");
INSERT INTO ton_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Pea naʻe pehē ʻe Mōsese, “Ko e kakai ʻoku ou nofo ʻi ai, ʻoku nau toko ono kilu ʻae kau tangata fononga; pea kuo ke pehē, Te u foaki ʻae kakano kiate kinautolu, kenau kai ai ʻi he māhina ʻe taha. ");
INSERT INTO ton_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","‌ʻE tāmateʻi ʻae fanga sipi, pea mo e fanga manu lalahi maʻanautolu, kenau mākona ai? Pe tānaki fakataha ʻae ika kotoa pē ʻi he tahi maʻanautolu, kenau mākona ai?” ");
INSERT INTO ton_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Pea naʻe pehē ʻe Sihova kia Mōsese, “He kuo fakanounou ʻae nima ʻo Sihova? Ko eni te ke mamata, pe hoko ʻeku lea kiate ko e pe ʻikai.” ");
INSERT INTO ton_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","¶ Pea naʻe ʻalu kituʻa ʻa Mōsese, ʻo ne fakahā ki he kakai ʻae folofola ʻa Sihova, pea naʻa ne tānaki ʻae kau tangata ʻe toko fitungofulu ʻi he kau mātuʻa ʻoe kakai, pea naʻa ne tuku ʻakinautolu ke tuʻu takatakai ʻi he fale fehikitaki. ");
INSERT INTO ton_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Pea naʻe hāʻele hifo ʻa Sihova ʻi he ʻao, ʻo ne folofola kiate ia, pea ne toʻo ʻae laumālie naʻe ʻiate ia, ʻo ne foaki ia ki he kau mātuʻa ʻe toko fitungofulu: pea naʻe pehē, ʻi he hoko ʻae laumālie kiate kinautolu, naʻa nau kikite, pea naʻe ʻikai tuku. ");
INSERT INTO ton_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ka naʻe nofo ʻae ongo tangata ʻe toko ua ʻi he ʻapitanga, ko e hingoa ʻoe tokotaha ko ʻElitati, pea ko e hingoa ʻoe tokotaha ko Metati: pea naʻe hoko ʻae laumālie kiate kinaua; pea naʻa na ʻiate kinautolu kuo tohi, ka naʻe ʻikai te na ō ki he fale fehikitaki: ka naʻa na kikite ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Pea naʻe lele ʻae tangata talavou, ʻo ne pehē kia Mōsese, “ʻOku kikite ʻa ʻElitati mo Metati ʻi he ʻapitanga.” ");
INSERT INTO ton_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Pea naʻe lea ʻa Siosiua ko e foha ʻo Nuni, ko e tamaioʻeiki ʻa Mōsese, ko e tokotaha ʻi heʻene kau tangata talavou, ʻo pehē, “Ko ʻeku ʻeiki ko Mōsese ke ke taʻofi ʻakinaua.” ");
INSERT INTO ton_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Pea naʻe pehē ʻe Mōsese kiate ia, “ʻOku ke meheka koeʻuhi ko au? ʻOku ʻamusiaange ʻeau ki he ʻOtua ke kikite ʻae kakai kotoa pē ʻa Sihova, pea ke tuku ʻe Sihova ʻa hono laumālie kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Pea naʻe ʻalu ʻa Mōsese ki he ʻapitanga, ʻaia mo e kau mātuʻa ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","¶ Pea naʻe ʻalu atu ʻae matangi meia Sihova, ʻo ne ʻomi ʻae fanga kueili mei he tahi, pea naʻe tuku ia ke tō ʻo ofi ki he ʻapitanga, ʻo hangē ko e ngataʻanga ʻoe fononga ʻi he ʻaho ʻe taha ki he potu toʻomataʻu, pea hangē ko e ngataʻanga ʻoe fononga ʻi he ʻaho ʻe taha ki he potu toʻohema, ʻo takatakai ʻae ʻapitanga, pea naʻe hangē ko e hanga ʻe fā hono māʻolunga mei he funga kelekele. ");
INSERT INTO ton_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pea naʻe tuʻu hake ʻae kakai ʻi he ʻaho kotoa pē ko ia, pea mo e pō kotoa pē ko ia, pea mo e ʻaho kotoa naʻe feholoi, pea naʻa nau tānaki ʻae fanga kueili: ko ia naʻe siʻi ʻene tānaki naʻa ne tānaki ʻae oma ʻe hongofulu: pea naʻa nau fakamafola ʻakinautolu ʻo takatakai ʻi he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Pea ʻi he kei ʻi honau nifo ʻae kakano ʻi he teʻeki ai ke lamu, naʻe vela ʻae houhau ʻo Sihova ki he kakai, pea naʻe taaʻi ʻe Sihova ʻae kakai ʻaki ʻae mahaki fakaʻauha lahi ʻaupito. ");
INSERT INTO ton_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Pea naʻa ne fakahingoa ʻae potu ko ia ko Kipiloti-Hateva: koeʻuhi naʻa nau tanu ʻi ai ʻae kakai ʻaia naʻe holi kovi. ");
INSERT INTO ton_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Pea naʻe fononga atu ʻae kakai mei Kipiloti-Hateva ki Heseloti; pea naʻa nau nofo ʻi Heseloti. ");
INSERT INTO ton_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Pea naʻe lea fakamamahi ʻa Miliame mo ʻElone kia Mōsese, koeʻuhi ko e fefine ʻItiopea naʻa na fakamaʻu: he naʻa ne fakamaʻu mo e fefine ʻItiopea. ");
INSERT INTO ton_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Pea naʻa na pehē, “He kuo folofola ʻa Sihova ʻia Mōsese pe? Ka kuo ʻikai folofola foki ia ʻiate kimaua?” Pea naʻe fanongo ki ai ʻa Sihova. ");
INSERT INTO ton_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Pea ko eni, ko e tangata ko Mōsese naʻe angavaivai ia, ʻo lahi hake ʻi he kau tangata kotoa pē naʻe ʻi he funga ʻo māmani.) ");
INSERT INTO ton_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Pea naʻe folofola fakafokifā ʻa Sihova kia Mōsese, pea mo ʻElone, pea mo Miliame, “Mou haʻu ʻakimoutolu ko e toko tolu ki he fale fehikitaki ʻoe kakai.” Pea naʻe ʻalu atu ʻae toko tolu ko ia. ");
INSERT INTO ton_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Pea naʻe hāʻele hifo ʻa Sihova ʻi he pou ʻoe ʻao, ʻo ne tuʻu ʻi he matapā ʻoe fale fehikitaki, pea naʻa ne ui ia kia ʻElone mo Miliame: pea naʻa na ʻomi kituʻa fakatouʻosi. ");
INSERT INTO ton_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Pea naʻa ne pehē, “Mo fanongo eni ki heʻeku lea: Kapau ʻoku ʻiate kimoutolu ha taha ʻoku kikite, Ko au ko Sihova te u, fakahā au kiate ia ʻi he meʻa hā mai, pe te u lea kiate ia ʻi he misi. ");
INSERT INTO ton_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ka ʻoku taha kehe ʻa Mōsese ko ʻeku tamaioʻeiki: ʻoku angatonu ia ʻi hoku fale kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Te ma lea fakataha mo ia mo ngutu taha, ʻi he fakahā, kae ʻikai ʻi he lea heliaki; pea ʻe mamata ia ki he hā mai ʻo Sihova: pea ko ia, ko e hā ʻoku ʻikai te mo manavahē ai ke lea fakamamahi ki heʻeku tamaioʻeiki ko Mōsese?” ");
INSERT INTO ton_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Pea naʻe vela ʻae houhau ʻo Sihova kiate kinaua; pea naʻe hāʻele atu ia. ");
INSERT INTO ton_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Pea naʻe ʻalu ʻae ʻao mei he fale fehikitaki, pea vakai, naʻe hoko ʻa Miliame ko e kilia hina ʻo hangē ko e ʻuha hinehina: pea naʻe sio ʻa ʻElone kia Miliame, pea vakai kuo kilia ia. ");
INSERT INTO ton_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Pea naʻe pehē ʻe ʻElone kia Mōsese, “ʻOiauē, ʻeku ʻeiki, ʻoku ou kole kiate koe, ʻoua naʻa tuku ʻae angahala kiate kimaua ʻaia kuo ma fai vale ai, pea mo ia ʻoku ma angahala ai. ");
INSERT INTO ton_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","‌ʻOua naʻa tuku ia ke ne hangē ko e tokotaha kuo mate, pe ha taha kuo popo hono kakano ʻi heʻene haʻu mei he fatu ʻo ʻene faʻē.” ");
INSERT INTO ton_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Pea naʻe tangi ʻa Mōsese kia Sihova, ʻo pehē, “ʻE ʻOtua ʻoku ou kole ki hoʻo ʻafio, ke ke fakamoʻui leva ia.” ");
INSERT INTO ton_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Pea naʻe pehē ʻe Sihova kia Mōsese, “Kapau ne kuo ʻaʻanu ʻa ʻene tamai ki hono mata ʻikai ʻe ma ia he ʻaho ʻe fitu? Tuku ke tāpuni kiate ia ʻae ʻapitanga, ʻi he ʻaho ʻe fitu, pea ka hili ia, tuku ke toe haʻu ia ki ai.” ");
INSERT INTO ton_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Pea naʻe kapusi ʻa Miliame mei he ʻapitanga, ʻi he ʻaho ʻe fitu: pea naʻe ʻikai kei fononga ʻae kakai kaeʻoua ke toe ʻomi ʻa Miliame. ");
INSERT INTO ton_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Pea hili ia naʻe hiki ʻae kakai mei Heseloti, ʻonau nofo ʻi he toafa ʻo Palani. ");
INSERT INTO ton_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Ke ke fekau ha kau tangata, ke nau ʻalu ʻo vakai ki he fonua ko Kēnani, ʻaia te u foaki ki he fānau ʻa ʻIsileli: ʻi he faʻahinga taki taha ʻo ʻenau ngaahi tamai ke mo fekau ha tangata, ʻoku taki taha matāpule ʻiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Pea naʻe fekau ʻe Mōsese kiate kinautolu ʻi he fekau ʻa Sihova, mei he toafa ko Palani: ʻae kau tangata kotoa pē naʻe matāpule ʻi he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Pea ko honau hingoa eni: ko Samua ko e foha ʻo Sakuli, ʻi he faʻahinga ʻo Lupeni. ");
INSERT INTO ton_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Pea mo Safati ko e foha ʻo Holi, ʻi he faʻahinga ʻo Simione. ");
INSERT INTO ton_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Pea mo Kelepi ko e foha ʻo Sifune, ʻi he faʻahinga ʻo Siuta. ");
INSERT INTO ton_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Pea mo ʻIkali ko e foha ʻo Siosefa, ʻi he faʻahinga ʻo ʻIsaka. ");
INSERT INTO ton_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Pea mo ʻOsea ko e foha ʻo Nuni, ʻi he faʻahinga ʻo ʻIfalemi. ");
INSERT INTO ton_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pea mo Paleti ko e foha ʻo Lafu, ʻi he faʻahinga ʻo Penisimani. ");
INSERT INTO ton_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Pea mo Katieli ko e foha ʻo Soti, ʻi he faʻahinga ʻo Sepuloni. ");
INSERT INTO ton_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Pea mo Kati ko e foha ʻo Susi, ʻi he faʻahinga ʻo Manase, ko e faʻahinga ʻo Siosefa. ");
INSERT INTO ton_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Pea mo ʻAmieli ko e foha ʻo Kimali, ʻi he faʻahinga ʻo Tani. ");
INSERT INTO ton_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Pea mo Situli ko e foha ʻo Mikaeli, ʻi he faʻahinga ʻo ʻAseli. ");
INSERT INTO ton_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Pea mo Napi ko e foha ʻo Vofisi, ʻi he faʻahinga ʻo Nafitali. ");
INSERT INTO ton_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Pea mo Kineli ko e foha ʻo Maki, ʻi he faʻahinga ʻo Kata. ");
INSERT INTO ton_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ko e hingoa eni ʻoe kau tangata naʻe fekau ʻe Mōsese kenau ō ʻo matakiʻi ʻae fonua. Pea naʻe ui ai ʻe Mōsese ʻa ʻOsea ko e foha ʻo Nuni ko Siosiua. ");
INSERT INTO ton_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","¶ Pea naʻe fekau ʻe Mōsese ʻakinautolu kenau matakiʻi ʻae fonua ko Kēnani, ʻo ne pehē kiate kinautolu, “Mou ʻalu hake ʻi he hala ki he potu tonga, pea te mou hake ki he moʻunga: ");
INSERT INTO ton_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","‌ʻO mamata ki he fonua, pe ʻoku fēfē ia; pea mo e kakai ʻoku nofo ai, pe ʻoku nau mālohi pe ʻoku nau vaivai, pe ʻoku nau tokolahi pe ʻoku nau tokosiʻi; ");
INSERT INTO ton_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Pea ʻoku fēfē ʻae fonua ʻoku nau nofo ai, pe ʻoku lelei pe ʻoku kovi; pe ʻoku fēfē honau ngaahi kolo ʻoku nau nofo ai, pe ʻoku nau nofo ʻi he ngaahi fale fehikitaki, pe ʻi he ngaahi kolo mālohi.” ");
INSERT INTO ton_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Pea mo e fonua, pe ʻoku mahu pe ʻoku masiva, pe ʻoku ʻakauʻia, pe ʻikai: pea mou lototoʻa, ʻo ʻomi ʻae fua ʻoe fonua. Pea ko e kuonga ko ia ko e ngaahi ʻaho ia ʻoe fua ʻoe ʻuluaki kālepi. ");
INSERT INTO ton_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","¶ Pea naʻa nau ʻalu hake, ʻo vakai ki he fonua, mei he toafa ʻo Sini ki Lehopi, ʻi he hala ʻoku haʻu ai ʻae fononga ki Hemati. ");
INSERT INTO ton_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Pea naʻa nau ʻalu ʻi he potu tonga, ʻonau haʻu ki Hepeloni; naʻe ʻi ai ʻae fānau ʻa ʻAnaki, ko ʻEhimani, mo Sesei, mo Talimi. (Vakai, naʻe langa ʻa Hepeloni ʻi he taʻu ʻe fitu ki muʻa ange ʻi he fokotuʻu ʻa Soani ʻi ʻIsipite.), ");
INSERT INTO ton_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Pea naʻa nau haʻu ki he vaitafe ʻo ʻEsikoli, pea naʻa nau tuʻusi ʻi ai ʻae vaʻa mo hono fuhinga kālepi, pea naʻa nau haʻamo toko ua ia ʻi he ʻakau; pea naʻa nau ʻomi ʻae pomikanite, mo e fiki. ");
INSERT INTO ton_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Pea naʻe ui ʻae potu ko ia, ko e vaitafe ʻo ʻEsikoli, koeʻuhi ko e fuhinga kālepi naʻe tuʻusi ai ʻe he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Pea hili ʻae ʻaho ʻe fāngofulu, naʻa nau liliu mai mei heʻenau vakai ʻae fonua. ");
INSERT INTO ton_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","¶ Pea naʻa nau ō pea haʻu kia Mōsese, mo ʻElone, pea mo e kakai kotoa pē ʻoe fānau ʻa ʻIsileli, ki he toafa ʻo Palani, ki Ketesi; pea naʻe ʻomi ʻae ongoongo kiate kinautolu, pea mo e kakai kotoa pē, pea naʻa nau fakahā ʻae fua ʻoe fonua kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Pea naʻa nau lea kiate ia, ʻo pehē, “Naʻa mau ō ki he fonua naʻa ke fekau ʻakimautolu ki ai, pea ko e moʻoni ʻoku pito ia ʻi he huʻahuhu mo e honi; pea ko hono fua eni. ");
INSERT INTO ton_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ka ʻoku mālohi ʻae kakai ʻoku nofo ʻi he fonua, pea kuo ʻā maka ʻae ngaahi kolo, ʻo lahi ʻaupito: pea naʻa mau mamata ʻi ai ki he fānau ʻa ʻAnaki. ");
INSERT INTO ton_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","‌ʻOku nofo ʻi he potu fakatonga ʻoe fonua ʻae kau ʻAmaleki: pea ko e kau Heti, mo e kau Sepusi, mo e kau ʻAmoli, ʻoku nau nofo ʻi he ngaahi moʻunga: pea ko e kau Kēnani ʻoku nofo ʻakinautolu ʻo ofi ki he tahi, pea mo e matafonua ʻo Sioatani.” ");
INSERT INTO ton_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Pea naʻe lolomi ʻe Kelepi ʻae kakai ʻi he ʻao ʻo Mōsese, ʻo ne pehē, “Ke tau ʻalu hake ke vave, ʻo maʻu ia; he ʻoku tau mālohi lahi ke ikuna ia.” ");
INSERT INTO ton_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ka naʻe pehē ʻe he kau tangata naʻa nau ʻalu hake mo ia, “ʻE ʻikai te tau mālohi ke ʻalu hake ki he kakai; he ʻoku nau mālohi ʻiate kitautolu.” ");
INSERT INTO ton_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Pea naʻa nau ʻomi ki he fānau ʻa ʻIsileli ʻae ongoongo kovi ʻoe fonua naʻa nau ʻalu ʻo vakai, ʻo pehē, “Ko e fonua naʻa mau ʻalu atu ke vakai ki ai, ko e fonua ia ʻoku ne keina ke ʻosi hono kakai; pea ko e kakai kotoa pē naʻa mau mamata ʻi ai ko e kau tangata lalahi ʻaupito. ");
INSERT INTO ton_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Pea naʻa mau mamata ʻi ai ki he kau tangata lalahi fakamanavahē, ko e ngaahi foha ʻo ʻAnaki ʻaia ʻoku tupu ʻi he faʻahinga lalahi: pea naʻa mau tatau ʻi homau mata ʻomautolu mo e fanga heʻe, pea naʻa mau pehē moʻoni ʻi honau ʻao ʻonautolu.” ");
INSERT INTO ton_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Pea naʻe hiki hake ʻae leʻo ʻoe kakai kotoa pē, ʻo tangi; pea naʻe tangi ʻae kakai ʻi he pō ko ia. ");
INSERT INTO ton_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Pea naʻe lāunga ʻae fānau kotoa pē ʻa ʻIsileli kia Mōsese pea mo ʻElone: pea naʻe pehē ʻe he kakai kotoa pē kiate kinaua, “ʻAmusiaange ʻekimautolu ne mau mate ʻi he fonua ko ʻIsipite! Pea ʻamusiaange ʻekimautolu naʻa mau mate ʻi he toafa ni! ");
INSERT INTO ton_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pea ko e hā kuo ʻomi ai ʻe Sihova ʻakimautolu ki he fonua ni, ke mau tō ʻi he heletā, kae tuku homau uaifi mo ʻemau fānau ke pōpula? ʻIkai ʻe lelei hake ʻemau toe foki ki ʻIsipite?” ");
INSERT INTO ton_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Pea naʻa nau fealēleaʻaki, ʻo pehē, “Ke tau fakanofo ha ʻeiki, pea tau foki ki ʻIsipite. ");
INSERT INTO ton_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Pea naʻe tō foʻohifo ʻa Mōsese mo ʻElone ki hona mata ʻi he ʻao ʻoe fakataha ʻoe kakai ʻoe fānau ʻa ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","¶ Pea ko Siosiua ko e foha ʻo Nuni, mo Kelepi ko e foha ʻo Sifune, naʻa na ʻiate kinautolu naʻe vakai ki he fonua, pea naʻa na hae hona kofu: ");
INSERT INTO ton_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Pea naʻa na lea ki he fakataha ʻae fānau ʻa ʻIsileli, ʻo pehē, “Ko e fonua naʻa mau ʻalu ke vakai ki ai, ko e fungani fonua lelei. ");
INSERT INTO ton_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Kapau ʻe fiemālie ʻa Sihova ʻiate kitautolu, pea te ne ʻave ʻakitautolu ki he fonua ko ia, ʻo foaki ia kiate kitautolu; ko e fonua ʻoku pito ʻi he huʻahuhu mo e honi. ");
INSERT INTO ton_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ke ʻoua pe naʻa mou angatuʻu kia Sihova, pea ʻoua naʻa mou manavahē ki he kakai ʻoe fonua; he ko e meʻakai maʻatautolu ʻakinautolu: kuo mole honau mālohi ʻiate kinautolu, pea ʻoku ʻiate kitautolu ʻa Sihova: ʻoua naʻa mou manavahē kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ka naʻe tala ʻe he kakai kotoa pē ke lisingi ʻakinaua ʻaki ʻae maka. Pea naʻe hā mai ʻae nāunau ʻo Sihova ʻi he fale fehikitaki ʻoe kakai ʻi he ʻao ʻoe fānau kotoa pē ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","¶ Pea naʻe pehē ʻe Sihova kia Mōsese, “ʻE fēfē hono fuoloa ʻoe fakaʻita mai ʻae kakai ni kiate au? ʻE fēfē hono fuoloa mo e teʻeki tenau tui kiate au, ʻi he ngaahi fakaʻilonga ne u fakahā kiate kinautolu? ");
INSERT INTO ton_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Te u taaʻi ʻaki ʻakinautolu ʻae mahaki fakaʻauha, pea te u liʻaki ʻakinautolu, pea te u ngaohi koe ko e puleʻanga lahi mo mālohi ʻiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","¶ Pea naʻe pehē ʻe Mōsese kia Sihova, “ʻE toki fanongo ki ai ʻae kakai ʻIsipite, (he naʻa ke ʻomi ʻi ho mālohi ʻae kakai ni meiate kinautolu;) ");
INSERT INTO ton_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Pea tenau tala ia ki he kakai ʻoe fonua ni: he kuo nau fanongo ko koe ko Sihova ʻoku ke ʻi he kakai ni, kuo ke femamataʻaki pe, pea kuo tuʻu hoʻo ʻao ʻi ʻolunga ʻiate kinautolu, pea ʻoku ke muʻomuʻa ʻiate kinautolu, ʻi he pou ʻoe ʻao ʻi he ʻaho, pea mo e pou ʻoe afi ʻi he pō. ");
INSERT INTO ton_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Pea ko eni, kapau te ke tāmateʻi ʻae kakai ni kotoa pē, ʻo hangē ko ha tangata ʻe tokotaha, ʻe toki lea ai ʻae ngaahi puleʻanga kuo nau fanongo ki ho ongoongo, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Koeʻuhi kuo ʻikai faʻa ʻomi ʻe Sihova ʻae kakai ni ki he fonua naʻa ne fuakava ai kiate kinautolu, ko ia kuo ne tāmateʻi ai ʻakinautolu ʻi he toafa. ");
INSERT INTO ton_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Pea ko eni, ʻoku ou kole ki hoʻo ʻafio, tuku ke lahi ʻae mālohi ʻo hoku ʻOtua, ʻo hangē ko hoʻo folofola, naʻe pehē, ");
INSERT INTO ton_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‌ʻOku kātaki fuoloa ʻa Sihova, pea ʻoku lahi ʻene ʻaloʻofa, ʻoku faʻa fakamolemole ʻe ia ʻae angahala mo e fai meʻa kovi, ka ʻe ʻikai ʻaupito fakatonuhiaʻi ʻe ia ʻae halaia: ʻoku fakahoko ki he fānau hono nunuʻa ʻoe hia ʻae mātuʻa ʻo aʻu ki he toʻutangata ʻe tolu mo hono fā. ");
INSERT INTO ton_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","‌ʻOku ou kole ki hoʻo ʻafio, ke ke fakamolemole ʻae angahala ʻae kakai ni ʻo tatau mo hono lahi ʻo hoʻo ʻaloʻofa, pea hangē ko hoʻo fakamolemole ʻae kakai ni, mei ʻIsipite ʻo aʻu mai ki heni.” ");
INSERT INTO ton_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Pea naʻe pehē ʻe Sihova, “Kuo u fakamolemole ʻo hangē ko hoʻo lea. ");
INSERT INTO ton_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Ka e hangē ko e moʻoni ʻa ʻeku moʻui, ʻe pito ʻa māmani kotoa pē ʻi he nāunau ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Koeʻuhi ko e kau tangata kotoa pē naʻe mamata ki hoku nāunau, pea mo ʻeku ngaahi ngāue mana, ʻaia ne u fai ʻi ʻIsipite, pea mo e toafa, kuo nau fakaʻitaʻi au ʻo liunga hongofulu, pea naʻe ʻikai tenau fanongo ki hoku leʻo; ");
INSERT INTO ton_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ko e moʻoni ʻe ʻikai tenau mamata ki he fonua ne u fuakava ai ki heʻenau ngaahi tamai, pea ʻe ʻikai mamata ai ha taha ʻiate kinautolu naʻe fakaʻita kiate au: ");
INSERT INTO ton_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ka ko ʻeku tamaioʻeiki ko Kelepi, koeʻuhi naʻe ʻiate ia ʻae laumālie kehe, pea kuo muimui ʻaupito ia kiate au, ko ia te u ʻomi ai ia ki he fonua naʻe ʻalu ia ki ai; pea ʻe maʻu ia ʻe hono hako. ");
INSERT INTO ton_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","(Pea ko eni, naʻe nofo ʻi he vahaʻa moʻunga ʻae kau ʻAmaleki mo e kau Kēnani,) Mou toe foki ʻapongipongi, pea mou ō ki he toafa ʻi he hala ki he Tahi Kulokula.” ");
INSERT INTO ton_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ʻE fēfē hono fai fuoloa ʻae kakai kovi ni, mo ʻenau lāunga kiate au? Kuo u fanongo ki he lāunga ʻae fānau ʻa ʻIsileli, kuo nau lāunga ai kiate au. ");
INSERT INTO ton_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ke ke tala kiate kinautolu, ‘ʻOku pehē ʻe Sihova, ko e moʻoni ʻa ʻeku moʻui, pea te u fai kiate kimoutolu ʻo hangē ko hoʻomou lea ʻi hoku telinga: ");
INSERT INTO ton_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","‌ʻE tō homou ʻangaʻanga ʻi he toafa ni ʻakinautolu kotoa pē naʻe lau ʻiate kimoutolu, ʻo fakatatau ki homou lau kotoa pē, mei hono taʻu ʻe uofulu tupu, ʻakinautolu ʻaia kuo lāunga kiate au, ");
INSERT INTO ton_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ko e moʻoni ʻe ʻikai te mou hoko atu ki he fonua, ʻaia ne u fuakava ke tuku kiate kimoutolu ke mou nofo ai, ka ko Kelepi ko e foha ʻo Sifune, mo Siosiua ko e foha ʻo Nuni. ");
INSERT INTO ton_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ka ko hoʻomou fānau, ʻakinautolu naʻa mou pehē ki ai tenau pōpula, te u ʻomi ʻakinautolu ki ai, pea ʻe ʻilo ʻekinautolu ʻae fonua kuo mou liʻaki. ");
INSERT INTO ton_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ka ko kimoutolu, ʻe tō homou ʻangaʻanga ʻi he toafa ni. ");
INSERT INTO ton_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Pea ʻe ʻalu fano pe hoʻomou fānau ʻi he toafa ʻi he taʻu ʻe fāngofulu, ʻo fua hoʻomou feʻauaki, kaeʻoua ke ʻosiʻosi homou ʻangaʻanga ʻi he toafa. ");
INSERT INTO ton_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","‌ʻE fakatatau ki he ngaahi ʻaho ʻaia naʻa mou mataki ai ʻae fonua, ʻio, ko e ʻaho ʻe fāngofulu, ko e ʻaho taki taha ki he taʻu ʻe taha, ʻio, ko e taʻu ʻe fāngofulu te mou fua hoʻomou angahala, pea te mou ʻilo ai ʻeku fakamamahi, ");
INSERT INTO ton_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Kuo u lea ʻaki eni ʻeau ko Sihova, ko e moʻoni te u fai ia ki he kakai kovi ni kotoa pē, kuo tānaki ʻo fakataha ke angatuʻu kiate au: ʻe fakaʻauha ʻakinautolu ʻi he toafa ni, pea tenau mate ʻi ai. ");
INSERT INTO ton_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","¶ Pea ko e kau tangata, naʻe fekau ʻe Mōsese kenau ʻalu ʻo vakai ki he fonua, ne nau liliu mai, pea naʻa nau fakalanga lāunga ʻi he kakai kiate ia, ʻi heʻenau ʻomi ʻae ongoongo kovi ʻoe fonua, ");
INSERT INTO ton_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","‌ʻIo, ʻae kau tangata naʻe ʻomi ʻae ongoongo kovi ʻoe fonua, naʻa nau mate ʻi he ʻao ʻo Sihova ʻi he mahaki fakaʻauha. ");
INSERT INTO ton_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ka naʻe fakamoʻui ʻa Siosiua ko e foha ʻo Nuni, mo Kelepi ko e foha ʻo Sifune, naʻa na ʻiate kinautolu naʻe ʻalu ke vakai ki he fonua. ");
INSERT INTO ton_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Pea naʻe tala ʻe Mōsese ʻae ngaahi lea ni ki he fānau kotoa pē ʻa ʻIsileli: pea naʻe loto mamahi lahi ʻae kakai. ");
INSERT INTO ton_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","¶ Pea naʻa nau tuʻu hengihengi hake pe, pea naʻa nau ō ki he tumutumu ʻoe moʻunga, ʻonau pehē, “Vakai, kuo tau ʻi heni, ka tau ō ki he potu ʻaia kuo talaʻofa ki ai ʻe Sihova: he kuo mau angahala.” ");
INSERT INTO ton_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Pea naʻe pehē ʻe Mōsese, “Ko e hā eni ʻoku mou talangataʻa ai ki he fekau ʻa Sihova? Ka ʻe ʻikai monūʻia ia. ");
INSERT INTO ton_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","‌ʻOua naʻa mou ʻalu hake, he ʻoku ʻikai ʻiate kimoutolu ʻa Sihova; naʻa taaʻi ʻakimoutolu ʻi he ʻao ʻo homou ngaahi fili. ");
INSERT INTO ton_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","He ko e kau ʻAmaleki mo e kau Kēnani ʻoku nau ʻi ai ʻi homou ʻao, pea te mou tō ʻi he heletā: koeʻuhi kuo mou fulituʻa kia Sihova, ko ia ʻe ʻikai ai ʻiate kimoutolu ʻa Sihova.” ");
INSERT INTO ton_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ka naʻa nau talangataʻa pe ʻonau ʻalu ki he tumutumu ʻoe moʻunga: ka ko e puha ʻoe fuakava ʻa Sihova, pea mo Mōsese, naʻe ʻikai ʻalu mei he ʻapitanga. ");
INSERT INTO ton_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Pea naʻe toki hifo mai ʻae kau ʻAmaleki, mo e kau Kēnani, ʻakinautolu naʻe nofo ʻi he moʻunga ko ia, ʻonau taaʻi ʻakinautolu, mo haha ʻakinautolu, ʻo aʻu ki Hoama. ");
INSERT INTO ton_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ke ke lea ki he fānau ʻa ʻIsileli, mo ke pehē kiate kinautolu, ‘ʻOka mou ka hoko ki he fonua te mou nofo ai, ʻaia te u foaki kiate kimoutolu, ");
INSERT INTO ton_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Pea mou loto ke fai ʻae feilaulau ʻi he afi kia Sihova, ko e feilaulau tutu, pe ko ha feilaulau ʻe fai ʻi he fuakava, pe ʻi he feilaulau faʻiteliha, pe ʻi hoʻomou ngaahi kātoanga mamalu, ke ʻatu ʻae meʻa namu kakala kia Sihova, ʻi he fanga manu lalahi, pe ʻi he fanga sipi: ");
INSERT INTO ton_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","‌ʻE toki ʻomi ʻe ia ʻoku ne ʻange ʻene feilaulau kia Sihova ʻae feilaulau meʻakai, ko hono hongofulu ʻoe vahe ʻoe efa ʻoe mahoaʻa kuo fefiofi mo hono fā ʻoe vahe ʻoe hini ʻoe lolo. ");
INSERT INTO ton_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Pea te ke teuteu hono fā ʻoe vahe ʻoe hini ʻoe uaine, ki he feilaulau inu ke fakataha mo e feilaulau tutu pe ko ha feilaulau, ki he lami ʻe taha. ");
INSERT INTO ton_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘Pea ka ko ha sipitangata, te ke teuteu ki he feilaulau meʻakai ʻae oma ʻe ua ʻoe mahoaʻa kuo fefiofi mo hono tolu ʻoe vahe ʻae hini ʻoe lolo. ");
INSERT INTO ton_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Pea ko e feilaulau inu te ke ʻange ai hono tolu ʻoe vahe ʻoe hini ʻoe uaine, ko e meʻa namu kakala ia kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Pea ʻi hoʻo teuteu ha pulu ki he feilaulau tutu, pe ki he feilaulau ʻoku fai ʻi he fuakava, pe ki he feilaulau fakamelino kia Sihova: ");
INSERT INTO ton_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Te ne toki ʻomi fakataha mo e pulu ʻae feilaulau meʻakai ko e oma ʻe tolu ʻoe mahoaʻa kuo fefiofi mo hono vaeua ʻoe hini ʻoe lolo. ");
INSERT INTO ton_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Pea te ke ʻomi ki he feilaulau inu hono vaeua ʻoe hini ʻoe uaine, ko e feilaulau ia kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","‌ʻE pehē hono ngaohi ʻoe pulu ʻe taha, pe ko e sipitangata ʻe taha, pe ko e lami ʻe taha, pe ko e ʻuhiki kosi. ");
INSERT INTO ton_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","‌ʻE fakatatau mo hono fiha ʻo ia te mou teuteu, ʻe pehē hoʻomou fai ke ʻai taki taha ʻo fakatatau ki hono lahi. ");
INSERT INTO ton_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ko kinautolu kotoa pē kuo fanauʻi ʻi he fonua tenau fai ʻae ngaahi meʻa ni ʻi hono anga ni, ʻi he ʻatu ʻae feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Pea kapau ʻe ʻāunofo ʻae muli ʻiate kimoutolu, pea ko ia kotoa pē ʻe ʻiate kimoutolu ʻi homou ngaahi toʻutangata ʻoku fie ʻatu ʻae feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu lelei kia Sihova; ʻe pehē ʻene fai ʻo hangē ko hoʻomou fai. ");
INSERT INTO ton_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ko e fekau pe taha ia kiate kimoutolu ʻoe fakataha, pea mo e muli foki ʻoku ʻāunofo ʻiate kimoutolu, pea ko e fekau ia ki homou ngaahi toʻutangata ʻo lauikuonga; he ʻoku tatau ʻae muli mo kimoutolu ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ko e fono pe taha mo e anga pe taha kiate kimoutolu, pea mo e muli ʻoku ʻāunofo ʻiate kimoutolu.’” ");
INSERT INTO ton_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ke ke lea ki he fānau ʻa ʻIsileli, ʻo ke pehē kiate kinautolu, ‘ʻOka mou ka hoko ki he fonua ʻaia teu ʻave ʻakimoutolu ki ai, ");
INSERT INTO ton_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","‌ʻE toki hoko ʻo pehē, ʻi hoʻomou kai ʻae mā ʻoe fonua, te mou ʻatu ʻae feilaulau hiki hake kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Te mou ʻange ha foʻi mā siʻi ʻi hoʻomou ʻuluaki takaonga mā ko e feilaulau hiki hake ia: ʻo hangē ko hoʻomou fai ʻae feilaulau hiki hake ʻoe potu hahaʻanga koane, ʻe pehē hoʻomou hiki hake ia. ");
INSERT INTO ton_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Mei he ʻuluaki ʻo hoʻomou takaonga mā te mou ʻange ʻae feilaulau hiki hake kia Sihova, ʻi homou ngaahi toʻutangata. ");
INSERT INTO ton_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","¶ “‘Pea kapau kuo mou hē, ʻo ʻikai te mou tokanga ki he ngaahi fekau ni kotoa pē, ʻaia kuo folofolaʻaki ʻe Sihova kia Mōsese, ");
INSERT INTO ton_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","‌ʻI he meʻa kotoa pē kuo fekau ʻe Sihova kiate kimoutolu ʻi he nima ʻo Mōsese, talu mei he ʻaho naʻe fekau ai ʻe Sihova kia Mōsese, ke fai maʻu ʻi homou ngaahi toʻutangata; ");
INSERT INTO ton_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","‌ʻE hoko ʻo pehē, ʻo kapau ʻe fai ha meʻa ʻi he taʻeʻilo pea ʻoku ʻikai ʻilo ia ʻe he kakai, ʻe ʻatu ai ʻe he kakai kotoa pē ʻae pulu mui ʻe taha ko e feilaulau tutu, ko e meʻa namu kakala kia Sihova, fakataha mo ʻene feilaulau meʻakai, mo ʻene feilaulau inu, ʻo fakatatau ki hono anga, pea mo e ʻuhiki ʻoe kosi ko e feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei maʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli pea ʻe fakamolemole ia kiate kinautolu; he ko e meʻa fai noa ia: pea tenau ʻomi ʻenau feilaulau, ko e feilaulau kuo ngaohi ʻaki ʻae afi kia Sihova, pea mo ʻenau feilaulau maʻae angahala ki he ʻao ʻo Sihova, koeʻuhi ko ʻenau taʻeʻilo: ");
INSERT INTO ton_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Pea ʻe fakamolemole ʻae kakai kotoa pē ʻoe fānau ʻa ʻIsileli pea mo e muli ʻoku ʻāunofo ʻiate kinautolu; koeʻuhi naʻe taʻeʻilo ʻae kakai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","¶ “‘Pea kapau ʻe angahala ha tokotaha ʻi he taʻeʻilo, te ne ʻomi ʻae kosi fefine ʻi hono ʻuluaki taʻu ko e feilaulau maʻae angahala. ");
INSERT INTO ton_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Pea ʻe fai ʻe he taulaʻeiki ʻae fakalelei koeʻuhi ko e laumālie naʻe angahala ʻi he taʻeʻilo, ʻi heʻene angahala ʻi he taʻeʻilo, ʻi he ʻao ʻo Sihova, ke fai ʻae fakalelei koeʻuhi ko ia; pea ʻe fakamolemole ai ia. ");
INSERT INTO ton_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ko e fono pe taha te mou maʻu kiate ia ʻoku angahala ʻi he taʻeʻilo, kiate ia kuo fanauʻi ʻi he fānau ʻa ʻIsileli, pea mo e muli ʻoku ʻāunofo kiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","¶ “‘Ka ka ai ha tokotaha ʻoku fai ha meʻa ʻi he fielahi, pe ʻoku fanauʻi ia ʻi he fonua, pe ko e muli, ʻoku manuki ia kia Sihova; pea ʻe tuʻusi ʻae laumālie ko ia mei hono kakai. ");
INSERT INTO ton_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Koeʻuhi kuo manukiʻi ʻe ia ʻae folofola ʻa Sihova, pea kuo maumauʻi ʻe ia ʻa ʻene fekau, ʻe tuʻusi ʻaupito ʻae laumālie ko ia, ʻe hoko kiate ia ʻa ʻene angahala.’” ");
INSERT INTO ton_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","¶ Pea lolotonga ʻae ʻi he toafa ʻae fānau ʻa ʻIsileli, naʻa nau ʻilo ha tangata naʻe okooko ʻi he ʻaho Sāpate. ");
INSERT INTO ton_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Pea ko kinautolu naʻe ʻiloʻi ia ʻi heʻene tānaki fefie, naʻa nau ʻomi ia kia Mōsese mo ʻElone, pea mo e kakai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Pea naʻa nau tuku ia ki he fale fakapōpula, koeʻuhi naʻe ʻikai fakahā pe ko e hā ʻe fai kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Pea naʻe pehē ʻe Sihova kia Mōsese, “Ko e moʻoni ʻe tāmateʻi ʻae tangata ko ia: ʻe lisingi ʻaki ia ʻae maka ʻe he kakai kotoa pē ʻi he tuʻa ʻapitanga.” ");
INSERT INTO ton_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Pea naʻe ʻomi ia kituʻa mei he ʻapitanga ʻe he kakai kotoa pē, ʻonau lisingi ia ʻaki ʻae maka, pea naʻe mate ia; ʻo hangē ko e fekau ʻe Sihova kia Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ke ke lea ki he fānau ʻa ʻIsileli, ʻo fekau kenau ngaohi moʻonautolu ʻae pao ʻi he kapa ʻo honau ngaahi kofu, ʻi honau ngaahi toʻutangata, pea tenau ʻai ha loufau lanumoana ki he pao ʻoe ngaahi kapa: ");
INSERT INTO ton_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Pea ʻe tuku ia ko e pao kiate kinautolu, koeʻuhi te mou sio ki ai, ʻo manatu ki he ngaahi fekau kotoa pē ʻa Sihova, ʻo fai ki ai; kaeʻoua te mou muimui ki homou loto, pea mo homou mata, ʻaia naʻa mou muimui ki ai ʻo feʻauaki: ");
INSERT INTO ton_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Koeʻuhi ke mou manatu, ʻo fai ki heʻeku ngaahi fekau kotoa pē, pea mou māʻoniʻoni ai ki homou ʻOtua. ");
INSERT INTO ton_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ko au ko Sihova ko homou ʻOtua, naʻe ʻomi ʻakimoutolu mei he fonua ko ʻIsipite, ke hoko ai ko homou ʻOtua: ko Sihova au ko homou ʻOtua.” ");
INSERT INTO ton_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Pea ko eni, naʻe kautaha ʻa Kola, ko e foha ʻo ʻIsa, ko e foha ia ʻo Kohate, ko e foha ia ʻo Livai, pea mo Tatani, mo ʻEpilami, ko e ongo foha ʻo ʻIliapi, pea mo ʻOni, ko e foha ʻo Peleti, ko e ngaahi foha ʻo Lupeni: ");
INSERT INTO ton_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Pea naʻa nau tuʻu hake ʻi he ʻao ʻo Mōsese, fakataha mo e niʻihi ʻi he fānau ʻa ʻIsileli, ʻae houʻeiki ʻoe fakataha, ʻae toko uangeau mo e toko nimangofulu naʻe poto ʻi he fakakaukau ʻi he kakai, ko e kau tangata ongoongo: ");
INSERT INTO ton_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Pea naʻa nau fakataha ʻakinautolu kia Mōsese mo ʻElone, pea nau pehē kiate kinaua, “ʻOku lahi fau ʻa hoʻomo fie pule ʻamoua, he kuo māʻoniʻoni taki taha kotoa pē ʻae kakai, pea ʻoku ʻiate kinautolu ʻa Sihova: pea ko e hā te mo hiki hake ai ʻakimoua ke mo māʻolunga ʻi he kakai ʻa Sihova?” ");
INSERT INTO ton_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Pea ʻi he fanongo ki ai ʻa Mōsese, naʻe tō fakafoʻohifo ia ki hono mata: ");
INSERT INTO ton_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Pea naʻa ne pehē kia Kola mo hono kakai kotoa pē, “ʻE fakahā ʻe Sihova ʻapongipongi ʻakinautolu ʻoku ʻoʻona, pea mo ia ʻoku māʻoniʻoni; pea te ne tuku ia ke ʻunuʻunu ʻo ofi kiate ia: ʻio, ko ia kuo ne fili te ne tuku ke ʻunuʻunu mai ki heʻene ʻafio. ");
INSERT INTO ton_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Mou fai eni; Toʻo homou ngaahi ipu ʻaiʻanga afi, ʻa Kola, mo hono kakai kotoa pē; ");
INSERT INTO ton_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Pea tuku ki ai ʻae afi, ʻo ʻai ʻae ʻakau namu kakala ki ai ʻi he ʻao ʻo Sihova ʻapongipongi: pea ʻe hoko ʻo pehē, ko e tangata ʻe fili ki ai ʻa Sihova ko e māʻoniʻoni ia: ʻoku mou angahiki ʻaupito, ʻakimoutolu ʻae ngaahi foha ʻo Livai.” ");
INSERT INTO ton_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Pea naʻe pehē ʻe Mōsese kia Kola, “ʻOku ou kole atu kiate kimoutolu ke mou fanongo mai, ʻae ngaahi foha ʻo Livai: ");
INSERT INTO ton_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ko e meʻa vaʻinga koā ia kiate kimoutolu ʻae fakamavae ʻe he ʻOtua ʻakimoutolu mei he kakai ʻo ʻIsileli, ʻo ʻomi ʻakimoutolu ke ofi ki heʻene ʻafio ke mou fai ʻae ngāue, ʻoe fale fehikitaki ʻo Sihova, pea ke tuʻu ʻi he ʻao ʻoe kakai ke ngāue kiate kinautolu? ");
INSERT INTO ton_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Pea naʻa ne ʻomi koe ke ofi ki heʻene ʻafio, pea mo ho kāinga ʻae ngaahi foha ʻo Livai fakataha mo koe: pea ʻoku mou kumi foki ʻae ngāue fakataulaʻeiki? ");
INSERT INTO ton_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","He ko hono ʻuhinga eni ʻo hoʻomou fakataha ʻa koe mo ho kakai kia Sihova: pea ko hai ʻa ʻElone, ʻoku mou lāunga ai kiate ia?” ");
INSERT INTO ton_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","¶ Pea naʻe fekau ʻe Mōsese ke ui ʻa Tatani mo ʻEpilami, ko e ongo foha ʻo ʻIliapi: ka naʻa na pehē, “ʻE ʻikai te ma ʻalu ange: ");
INSERT INTO ton_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","He ko e meʻa siʻi hoʻo ʻomi ʻakimautolu mei he fonua ʻoku pito ʻi he huʻahuhu mo e honi, ke tāmateʻi ʻakimautolu ʻi he toafa, ʻo kapau ʻe ʻikai te ke nofo koe ko e ʻeiki kiate kimautolu? ");
INSERT INTO ton_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ka kuo ʻikai te ke ʻomi ʻakimautolu ki ha fonua ʻoku pito ʻi he huʻahuhu mo e honi, pe tuku kiate kimautolu ha tofiʻa ʻi he ngoue mo e ngoue vaine: te ke kapeʻi koā ʻae mata ʻoe kau tangata ni? ʻE ʻikai te ma ʻalu ange.” ");
INSERT INTO ton_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Pea naʻe tuputāmaki lahi ʻa Mōsese, ʻo ne pehē kia Sihova, “ʻOua naʻa ke ʻafio ki heʻenau feilaulau: naʻe ʻikai te u faʻao ha ʻasi ʻe taha meiate kinautolu, pea naʻe ʻikai te u fakamamahiʻi ha taha ʻiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Pea naʻe pehē ʻe Mōsese kia Kola, “Ko koe mo ho kakai ke mou ʻi he ʻao ʻo Sihova ʻapongipongi, ʻa koe, mo kinautolu, pea mo ʻElone: ");
INSERT INTO ton_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","pea ʻe taki taha ʻave ʻe he tangata ʻa ʻene ipu ʻaiʻanga afi, pea tuku ʻi ai ʻae ʻakau namu kakala, pea taki taha ʻomi ʻe he tangata ʻa ʻene ipu ʻaiʻanga afi ki he ʻao ʻo Sihova, ko e ipu ʻaiʻanga afi ʻe uangeau ma nimangofulu; pea ko koe foki, mo ʻElone, te mo taki taha ʻene ipu ʻaiʻanga afi.” ");
INSERT INTO ton_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Pea naʻe taki taha ʻave ʻe he tangata ʻa ʻene ipu ʻaiʻanga afi, pea naʻe tuku ʻae afi ki ai, pea tuku ki ai ʻae ʻakau namu kakala, pea naʻa nau tuʻu ʻi he matapā ʻoe fale fehikitaki ʻoe kakai fakataha mo Mōsese mo ʻElone. ");
INSERT INTO ton_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Pea naʻe fakataha ʻe Kola ʻae kakai kotoa pē kiate kinaua ki he matapā ʻoe fale fehikitaki ʻoe kakai, pea naʻe hā mai ʻae nāunau ʻo Sihova ki he kakai kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Fakamavahe ʻakimoua mei he kakai ni, koeʻuhi ke u fakaʻauha leva ʻakinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Pea naʻa na tō ki hona mata, ʻo na pehē, “ʻE ʻOtua, ko e ʻOtua ʻoe laumālie ʻoe kakai kotoa pē, ʻe angahala ha tokotaha, pea te ke houhau ki he kakai kotoa pē?” ");
INSERT INTO ton_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Ke ke lea ki he kakai, ʻo pehē, Mou ʻalu atu ke ʻatā mei he fale fehikitaki ʻo Kola, mo Tatani, mo ʻEpilami.” ");
INSERT INTO ton_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Pea naʻe tuʻu hake ʻa Mōsese ʻo ʻalu kia Tatani mo ʻEpilami; pea naʻe muimui ʻiate ia ʻae kau mātuʻa ʻo ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Pea naʻe lea ia ki he kakai, ʻo pehē, “ʻOku ou kole kiate kimoutolu, Mou hiki atu mei he ngaahi fale fehikitaki ʻoe kau tangata angahala ni, pea ʻoua naʻa mou ala ki haʻanau meʻa, telia naʻa mou ʻauha ʻi heʻenau angahala.” ");
INSERT INTO ton_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ko ia naʻa nau ʻalu ai mei he potu kotoa pē ʻoe fale fehikitaki ʻo Kola, mo Tatani, mo ʻEpilami: pea naʻe haʻu ʻa Tatani mo ʻEpilami, pea na tuʻu ʻi he matapā ʻo hona fale fehikitaki, pea mo hona uaifi mo hona ngaahi foha, pea mo ʻena fānau iiki. ");
INSERT INTO ton_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Pea naʻe pehē ʻe Mōsese, “Te mou ʻilo eni kuo fekau au ʻe Sihova ke u fai ʻae ngaahi meʻa ni kotoa pē; he ʻoku ʻikai ko hoku loto ʻoʻoku. ");
INSERT INTO ton_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kapau ʻe mate ʻae kau tangata ni ʻo hangē ko e mate ʻae kakai kotoa pē, pea kapau ʻe hoko kiate kinautolu ʻo hangē ko e hoko ki he kakai kotoa pē; pea tā kuo ʻikai fekau au ʻe Sihova. ");
INSERT INTO ton_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Pea kapau ʻe fai ʻe Sihova ha meʻa foʻou pea ʻe mafaʻa ʻae ngutu ʻoe kelekele, ʻo folo hifo ʻakinautolu, mo e meʻa kotoa pē ʻoku ʻiate kinautolu, pea nau ʻalu hifo fakafokifā pe ki he luo; te mou toki ʻilo ai kuo fakahouhauʻi ʻa Sihova ʻe he kau tangata ni.” ");
INSERT INTO ton_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Pea naʻe hoko ʻo pehē, ʻi he fakaʻosi ʻa ʻene fakahā ʻae ngaahi lea ni, naʻe mafahi ʻae kelekele ʻi lalo ʻiate kinautolu: ");
INSERT INTO ton_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Pea naʻe mafaʻa ʻae ngutu ʻoe kelekele, ʻo folo hifo ʻakinautolu, mo honau ngaahi fale pea mo e kau tangata kotoa pē naʻe ʻia Kola, mo ʻenau koloa kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ko kinautolu, mo e meʻa kotoa pē naʻe ʻiate kinautolu, naʻe ʻalu moʻui hifo ki he luo, pea naʻe mapuni ʻae kelekele kiate kinautolu: pea naʻa nau ʻauha mei he kakai. ");
INSERT INTO ton_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Pea naʻe hola ʻi heʻenau tangi ʻae kakai ʻIsileli kotoa pē naʻe tuʻu takatakai ʻiate kinautolu: he naʻa nau pehē, “Naʻa toe folo hifo ʻe he kelekele ʻakimautolu.” ");
INSERT INTO ton_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Pea naʻe haʻu ʻae afi meia Sihova, ʻo fakaʻauha ʻae kau tangata ʻe toko uangeau ma toko nimangofulu naʻe feilaulau ʻaki ʻae ʻakau namu kakala. ");
INSERT INTO ton_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Ke ke lea kia ʻEliesa ko e foha ʻo ʻElone ko e taulaʻeiki, ke ne hiko hake ʻae ngaahi ipu ʻaiʻanga afi mei he afi, he kuo tapu ia; pea ke liʻaki ʻae afi ki hena. ");
INSERT INTO ton_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ko e ngaahi ipu ʻaiʻanga afi ʻakinautolu ni kuo angahala ki honau laumālie, tuku kenau ngaohi ʻaki ia ʻae ngaahi teunga lafalafa laulahi ke ʻuʻufi ʻaki ʻae feilaulauʻanga: he kuo nau feilaulau ʻaki ia ʻi he ʻao ʻo Sihova, ko ia kuo tapu ai ia; pea ʻe hoko ia ko e fakaʻilonga ki he fānau ʻa ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Pea naʻe ʻave ʻe ʻEliesa ko e taulaʻeiki ʻae ngaahi ipu ʻaiʻanga afi palasa, ʻaia naʻe feilaulau ʻaki ʻekinautolu kuo vela; pea naʻe ngaohi ʻaki ia ʻae ngaahi fono lafalafa laulahi ke ʻuʻufi ʻaki ʻae feilaulauʻanga: ");
INSERT INTO ton_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Ke tuku ia ko e fakamanatu ki he fānau ʻa ʻIsileli, koeʻuhi ke ʻoua naʻa ofi mai ha muli, ʻoku ʻikai ʻoe hako ʻo ʻElone ke feilaulau ʻaki ʻae ʻakau namu kakala ʻi he ʻao ʻo Sihova; telia naʻa tatau ia mo Kola, pea mo hono kakai: ʻo hangē ko e folofola ʻa Sihova kiate ia ʻi he nima ʻo Mōsese. ");
INSERT INTO ton_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","¶ Pea ʻi he ʻaho naʻa na feholoʻi naʻe lāunga ʻae kakai kotoa pē ʻi he fānau ʻa ʻIsileli kia Mōsese mo ʻElone, ʻo pehē, “Kuo mo tāmateʻi ʻae kakai ʻo Sihova.” ");
INSERT INTO ton_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Pea naʻe hoko ʻo pehē, ʻi he fakataha ʻae kakai kia Mōsese pea mo ʻElone, naʻa nau sio ki he fale fehikitaki ʻoe kakai: pea fokifā pe kuo ʻuʻufi ʻaki ia ʻae ʻao, pea naʻe hā mai ʻae nāunau ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Pea naʻe haʻu ʻa Mōsese mo ʻElone ki he matafale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Mo ʻalu hake ʻi he kakai ni, koeʻuhi ke u fakaʻauha leva ʻakinautolu.” Pea naʻa na tō foʻohifo ki hona mata. ");
INSERT INTO ton_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","¶ Pea naʻe pehē ʻe Mōsese kia ʻElone, “Toʻo ha ipu ʻaiʻanga afi, ʻo tuku ki ai ʻae afi mei he funga feilaulauʻanga, ʻo ʻai ki ai ʻae ʻakau namu kakala, pea ke ʻalu vave ki he kakai, ʻo fai ʻae fakalelei maʻanautolu: he kuo ʻalu atu ʻae houhau meia Sihova; pea kuo kamata ʻae mahaki fakaʻauha.” ");
INSERT INTO ton_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Pea naʻe ʻave ʻe ʻElone ʻo hangē ko e fekau ʻa Mōsese, ʻo ne lele ki he lotolotonga ʻoe kakai; pea vakai kuo kamata ʻae mahaki fakaʻauha ʻi he kakai: pea naʻa ne ʻai ʻae ʻakau namu kakala ki ai, ʻo ne fai ʻae fakalelei maʻanautolu. ");
INSERT INTO ton_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Pea naʻe tuʻu ia ʻi he vahaʻa ʻoe mate mo e moʻui; pea naʻe taʻofi ai ʻae mahaki fakaʻauha. ");
INSERT INTO ton_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Pea ko kinautolu naʻe mate ʻi he mahaki fakaʻauha ko e tokotaha mano mo e toko fā afe ma toko fitungeau, mo kinautolu naʻe mate ʻi he meʻa ʻa Kola. ");
INSERT INTO ton_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Pea naʻe foki ʻa ʻElone kia Mōsese ki he matapā ʻoe fale fehikitaki ʻoe kakai: pea naʻe taʻofi ʻae mahaki fakaʻauha. ");
INSERT INTO ton_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Ke ke lea ki he fānau ʻa ʻIsileli, pea ke maʻu mei ai taki taha ʻae tokotoko ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai, ʻi he houʻeiki kotoa pē ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai ʻae tokotoko ʻe hongofulu ma ua: ke ke tohi ʻae hingoa ʻoe tangata taki taha ki hono tokotoko. ");
INSERT INTO ton_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Pea ke tohi ʻae hingoa ʻo ʻElone ki he tokotoko ʻo Livai: ʻe tuku ʻae tokotoko taki taha ki he ʻeiki ʻoe fale ʻo ʻenau ngaahi tamai. ");
INSERT INTO ton_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Pea ʻe tuku ia ki he fale fehikitaki ʻoe kakai ʻi he ʻao ʻoe fakamoʻoni, ʻaia te u fetaulaki ai mo kimoutolu. ");
INSERT INTO ton_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Pea ʻe hoko ʻo pehē, ko e tokotoko ʻoe tangata te u fili ki ai, ʻe moto ia: pea te u fai ke fakangata ʻae lāunga kiate au ʻae fānau ʻa ʻIsileli, ʻaia ʻoku nau lāunga ʻaki kiate kimoua.” ");
INSERT INTO ton_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","¶ Pea naʻe lea ʻa Mōsese ki he fānau ʻa ʻIsileli, pea naʻe taki taha ʻange ʻe honau houʻeiki ʻa hono tokotoko ʻo fakatatau ki he fale ʻo ʻenau ngaahi tamai, ko e tokotoko ʻe hongofulu ma ua: pea ko e tokotoko ʻo ʻElone naʻe ʻai fakataha mo ʻenau ngaahi tokotoko. ");
INSERT INTO ton_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Pea naʻe tuku ʻe Mōsese ʻae ngaahi tokotoko ʻi he fale fehikitaki ʻoe fakamoʻoni ʻi he ʻao ʻo Sihova. ");
INSERT INTO ton_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Pea naʻe hoko ʻo pehē, ʻi heʻene pongipongi hake naʻe hū ʻa Mōsese ki he fale fehikitaki ʻoe fakamoʻoni; pea vakai, ko e tokotoko ʻo ʻElone mei he fale ʻo Livai, kuo matala pea kuo tupu ʻi ai ʻae ngaahi moto, mo e fisiʻi ʻakau, pea mo e ngaahi telie. ");
INSERT INTO ton_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Pea naʻe ʻomi ʻe Mōsese mei he ʻao ʻo Sihova ʻae ngaahi tokotoko kotoa pē ki he fānau kotoa pē ʻa ʻIsileli: pea naʻa nau mamata, pea naʻe taki taha ʻave ʻe he tangata ʻa hono tokotoko. ");
INSERT INTO ton_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","¶ Pea naʻe pehē ʻe Sihova kia Mōsese, “Toe ʻomi ʻae tokotoko, ʻo ʻElone ki he ʻao ʻoe fakamoʻoni, ke tuku ia ko e fakaʻilonga ki he kau angatuʻu; pea te ke fakaʻosi ʻaupito ʻenau lāunga kiate au, telia naʻa nau mate.” ");
INSERT INTO ton_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Pea naʻe fai pehē ʻe Mōsese: ʻo hangē ko e fekau ʻa Sihova kiate ia, naʻe pehē ʻene fai. ");
INSERT INTO ton_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Pea naʻe lea ʻae fānau ʻa ʻIsileli kia Mōsese, ʻo pehē, “Vakai, ʻoku mau mate, ʻoku mau malaʻia, ʻoku mau malaʻia kotoa pē. ");
INSERT INTO ton_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ko ia kotoa pē ʻoku haʻu ke ofi siʻi ki he fale fehikitaki ʻo Sihova ʻe mate ia: te mau fakaʻau aipe ke ʻauha ʻi he mate?” ");
INSERT INTO ton_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Pea naʻe pehē ʻe Sihova kia ʻElone, “Ko koe mo ho ngaahi foha mo e fale ʻo hoʻo ngaahi tamai te mou fua ʻae hia ʻoe faletapu: pea ko koe mo ho ngaahi foha te mou fua ʻae hia ʻa hoʻomou ngāue fakataulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Pea te mou ʻomi fakataha foki mo koe ho kāinga ʻi he faʻahinga ʻo Livai, ko e faʻahinga ʻo hoʻo tamai, koeʻuhi te mou feangai mo koe, ʻo ngāue kiate koe: ka ko koe mo ho ngaahi foha te mou fakatahaʻo ngāue ʻi he matafale fehikitaki ʻoe fakamoʻoni. ");
INSERT INTO ton_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Pea tenau tokanga ki hoʻo ngāue, mo e tauhi kotoa pē ʻoe fale fehikitaki: kaeʻoua tenau haʻu ke ofi ki he ngaahi ipu ʻoe faletapu mo e feilaulauʻanga, telia naʻa nau mate ai, mo kimoutolu foki. ");
INSERT INTO ton_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Pea tenau fakataha ʻakinautolu kiate koe, ʻo tokanga ki he tauhi ʻoe fale fehikitaki ʻoe kakai, ki he ngāue kotoa pē ʻoe fale fehikitaki: pea ʻe ʻikai haʻu ha muli ke ofi kiate kimoutolu. ");
INSERT INTO ton_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Pea te mou tokanga ki he tauhi ʻoe faletapu, mo e tauhi ʻoe feilaulauʻanga: koeʻuhi ke ʻoua naʻa toe hoko ʻae houhau ki he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Pea ko au, vakai, kuo u ʻomi homou kāinga ʻoe kau Livai mei he fānau ʻa ʻIsileli: ʻoku foaki ʻakinautolu ʻo hangē ko e meʻa foaki kiate kimoutolu maʻa Sihova, ke fai ʻae ngāue ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Pea ko ia, ko koe mo ho ngaahi foha te mou tokanga ki hoʻomou ngāue fakataulaʻeiki ki he meʻa kotoa pē ʻoe feilaulauʻanga, mo e loto puipui; pea te mou tauhi: kuo u foaki kiate kimoutolu hoʻomou ngāue fakataulaʻeiki ʻo hangē ko e meʻa foaki: pea ko e muli ʻe haʻu ʻo ofi ʻe tāmateʻi ia.” ");
INSERT INTO ton_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","¶ Pea naʻe folofola ʻa Sihova kia ʻElone, ʻo pehē, “Kuo u foaki foki kiate koe ʻae tauhi ʻo ʻeku feilaulau hiki hake ʻi he ngaahi meʻa tapu kotoa pē ʻae fānau ʻa ʻIsileli; kuo u foaki ia kiate koe koeʻuhi ko e fakanofo, pea ki ho ngaahi foha, ʻi he talatuku ʻo lauikuonga. ");
INSERT INTO ton_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ko hoʻo meʻa eni ʻi he ngaahi meʻa toputapu, kuo hao ʻi he afi: ko ʻenau feilaulau kotoa pē, ko ʻenau feilaulau meʻakai kotoa pē, ko ʻenau feilaulau kotoa pē maʻae angahala, mo ʻenau feilaulau fakalelei kotoa pē, ʻaia kuo nau ʻange kiate au, ʻe mātuʻaki tapu ia maʻau, mo ho ngaahi foha. ");
INSERT INTO ton_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Te ke kai ia ʻi he potu tapu ʻaupito, ʻe kai ia ʻe he kakai tangata kotoa pē: ʻe māʻoniʻoni ia kiate koe. ");
INSERT INTO ton_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Pea ko e meʻa eni ʻaʻau; ko e feilaulau hiki hake ʻoku nau foaki, fakataha mo e ngaahi feilaulau lialiaki kotoa pē ʻae fānau ʻa ʻIsileli: kuo u foaki ia kiate koe, mo ho ngaahi foha, pea mo ho ngaahi ʻofefine fakataha mo koe, ʻi he fekau ʻo lauikuonga: ko ia kotoa pē ʻoku maʻa ʻi ho fale te ne kai mei ai. ");
INSERT INTO ton_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Ko e lelei kotoa pē ʻoe lolo, mo e lelei kotoa pē ʻoe uaine, pea mo e uite, ko hono ʻuluaki fua ʻaia tenau ʻatu kia Sihova, kuo u foaki ia kiate koe. ");
INSERT INTO ton_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Pea mo ia ʻoku fuofua moho ʻi he fonua, ʻaia tenau ʻomi kia Sihova, ʻe ʻaʻau ia; ko ia kotoa pē ʻoku maʻa ʻi ho fale te ne kai mei ai. ");
INSERT INTO ton_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Ko e meʻa kotoa pē ʻoku fakatapu ʻi ʻIsileli ʻoku ʻaʻau ia. ");
INSERT INTO ton_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","‌ʻAe meʻa kotoa pē ʻoku ne toʻo ʻae mānava ʻi he kakano kotoa pē, ʻaia ʻoku nau ʻomi kia Sihova, ʻi he kau tangata, pe ʻi he fanga manu, ʻe ʻaʻau ia: ka ko e moʻoni te ke huhuʻi ʻae ʻuluaki tama ʻi he tangata, pea mo e ʻuluaki fānau ʻi he fanga manu taʻemaʻa te ke huhuʻi ia. ");
INSERT INTO ton_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Pea ko ia ʻoku totonu ke huhuʻi mei he taha māhina, te ke huhuʻi ia ʻo fakatatau ki hoʻo lau, ʻaki ʻae paʻanga ko e sikeli ʻe nima, ʻo hangē ko esikeli ʻoe faletapu, ʻaia ko e kela ʻe uofulu. ");
INSERT INTO ton_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Ka ko e ʻuluaki fānau ʻae fanga pulu, pea mo e ʻuluaki fānau ʻae sipi, pea mo e ʻuluaki fānau ʻae kosi, ʻe ʻikai te ke huhuʻi ia; he ʻoku māʻoniʻoni ia: pea te ke luluku ʻaki honau toto ʻae feilaulauʻanga, pea te ke tutu honau ngako ko e feilaulau kuo ngaohi ʻaki ʻae afi, ko e meʻa namu kakala kia Sihova. ");
INSERT INTO ton_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Pea ko honau kakano ʻe ʻaʻau ia, ʻo hangē ko e ʻaʻau ʻae fatafata lialiaki, pea mo e alanga nima toʻomataʻu. ");
INSERT INTO ton_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ko e ngaahi feilaulau hiki hake ʻoe ngaahi meʻa tapu kotoa pē, ʻaia kuo ʻange ʻe he fānau ʻa ʻIsileli kia Sihova, kuo u foaki ia kiate koe, mo ho ngaahi foha, pea mo ho ngaahi ʻofefine fakataha mo koe, ʻi he fekau ʻo lauikuonga: ko e fuakava ia kiate ko e ʻoe māsima ʻi he ʻao ʻo Sihova, fakataha mo ho hako ʻo lauikuonga.” ");
INSERT INTO ton_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","¶ Pea naʻe folofola ʻa Sihova kia ʻElone, ʻo pehē, “ʻE ʻikai te ke maʻu ha tofiʻa ʻi honau fonua, pea ʻe ʻikai te ke maʻu ha tufakanga ʻiate kinautolu: ka ko au ko ho ʻinasi mo ho tofiʻa ʻi he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Pea vakai, kuo u foaki ki he fānau ʻa Livai ʻa hono vahe hongofulu ʻoe meʻa kotoa pē ʻi ʻIsileli ko honau tofiʻa, koeʻuhi ko e ngāue ʻoku nau tauhi, ʻio ʻae tauhi ʻoe fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Pea ʻe ʻikai toe haʻu ʻae fānau ʻa ʻIsileli ʻo ofi ki he fale fehikitaki ʻoe kakai, telia naʻa nau fua ʻae angahala, pea nau mate. ");
INSERT INTO ton_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ka ko e kau Livai te nau fai ʻae tauhi ʻoe fale fehikitaki ʻoe kakai, pea te nau fua ʻenau hia: ko e fekau ia ki homou ngaahi toʻutangata ʻo lauikuonga, ke ʻilo ʻoku ʻikai tenau maʻu ha tofiʻa ʻi he fānau ʻa ʻIsileli. ");
INSERT INTO ton_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Ka ko hono hongofulu ʻoe vahe ʻoe meʻa ʻae fānau ʻa ʻIsileli, ʻaia ʻoku nau ʻatu ko e feilaulau hiki hake kia Sihova, kuo u foaki ia ki he kau Livai kenau maʻu ia: pea ko eni, ne u pehē ai kiate kinautolu, ʻE ʻikai tenau maʻu ha tofiʻa ʻi he fānau ʻa ʻIsileli.” ");
INSERT INTO ton_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","¶ Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Ke ke lea ki he kau Livai, ʻo ke pehē kiate kinautolu, “ʻOka mou ka maʻu hono hongofulu ʻoe vahe ʻoe meʻa mei he fānau ʻa ʻIsileli, ʻaia ne u foaki meiate kinautolu maʻamoutolu, ko homou tofiʻa, te mou toki ʻohake hono feilaulau hiki hake kia Sihova, ʻio, ko hono hongofulu ʻoe vahe ʻi homou vahe hongofulu. ");
INSERT INTO ton_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Pea ko hoʻomou feilaulau hiki hake ʻe lau ia kiate kimoutolu, ʻo hangē ko e koane ʻoe potu hahaʻanga, pea mo e pito ʻoe tataʻoʻanga uaine. ");
INSERT INTO ton_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","‌ʻE pehē hoʻomou ʻatu ʻae feilaulau hiki hake kia Sihova ʻi homou vahe hongofulu kotoa pē, ʻaia ʻoku mou maʻu ʻi he fānau ʻa ʻIsileli; pea te mou foaki hono feilaulau hiki hake ʻo Sihova kia ʻElone ko e taulaʻeiki. ");
INSERT INTO ton_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ko e meʻa foaki kotoa pē ʻoku mou maʻu te mou ʻange mei ai ʻae feilaulau hiki hake kia Sihova, mei hono lelei, ʻio, mei hono meʻa ʻoku tapu. ");
INSERT INTO ton_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Pea ko eni, te ke lea pehē kiate kinautolu, ʻOka mou ka hiki hono lelei mei ai, ʻe toki lau ai ia ki he Livai ʻo hangē ko hono tupu ʻoe hahaʻanga koane, pea mo e tupu ʻoe tataʻoʻanga uaine. ");
INSERT INTO ton_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Pea te mou kai ia ʻi he potu kotoa pē, ʻekimoutolu mo homou kau nofoʻanga: he ko hono totongi ia ʻo hoʻomou tauhi ʻae fale fehikitaki ʻoe kakai. ");
INSERT INTO ton_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Pea ʻe ʻikai te mou fua ʻae angahala koeʻuhi ko ia, ʻoka mou ka hiki hono lelei mei ai: pea ʻe ʻikai te mou fakaʻuli ʻae ngaahi meʻa tapu ʻoe fānau ʻa ʻIsileli, telia naʻa mou mate.” ");
INSERT INTO ton_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Pea naʻe folofola ʻa Sihova kia Mōsese pea mo ʻElone, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Ko eni ʻae talatuku ʻoe fono ʻaia kuo fekau ʻe Sihova, ʻo pehē, Ke ke lea ki he fānau ʻa ʻIsileli, ka nau ʻomi kiate koe ha pulu fefine mui kulokula taʻehanoʻila, pea taʻehanomele, pea teʻeki hoko ki ai ʻae haʻamonga: ");
INSERT INTO ton_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Pea te mou foaki ia kia ʻEliesa ko e taulaʻeiki, koeʻuhi ke ne ʻomi ia ki he tuʻa ʻapitanga, pea ʻe tāmateʻi ia ʻe ha tokotaha ʻi hono ʻao: ");
INSERT INTO ton_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Pea ko ʻEliesa ko e taulaʻeiki te ne ʻave ʻae toto ʻi hono tuhu, ʻo ne luluku ʻaki ʻae toto ʻi he matafale fehikitaki ʻoe kakai ke liunga fitu: ");
INSERT INTO ton_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Pea ʻe tutu ʻe ha tokotaha ʻae pulu fefine mui ʻi hono ʻao; te ne tutu hono kili mo hono kakano, mo hono toto, fakataha mo hono kinohaʻa: ");
INSERT INTO ton_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Pea ʻe ʻave ʻe he taulaʻeiki ʻae ʻakau ko e sita, mo e ʻisope, mo e kulaʻahoʻaho, ʻo lī ia ki he loto afi ʻoku tutu ai ʻae pulu fefine. ");
INSERT INTO ton_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Pea ʻe toki fō ʻe he taulaʻeiki ʻa hono ngaahi kofu, pea te ne kaukauʻi hono sino ʻi he vai, pea te ne toki haʻu ki he ʻapitanga, ka ʻe taʻemaʻa ʻae taulaʻeiki ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Pea ko ia ʻoku ne tutu ia ʻe fō ʻe ia ʻa hono ngaahi kofu ʻi he vai, pea ʻe kaukauʻi hono sino ʻi he vai, ka ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Pea ʻe tānaki ʻe he tangata ʻoku maʻa ʻae efu ʻoe pulu fefine, ʻo tuku ia ki he tuaʻā ʻapitanga, ʻi ha potu maʻa, pea ʻe tuku ia ki he kakai ʻoe fānau ʻa ʻIsileli, ko e vai fakamavahe; ko e fakamaʻa ia ʻoe angahala. ");
INSERT INTO ton_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Pea ko ia ʻoku ne tānaki ʻae efu ʻoe pulu fefine ʻe fō ʻe ia ʻa hono ngaahi kofu, ka ʻe taʻemaʻa ia ʻo aʻu ki he efiafi: pea ko e fekau ia ki he fānau ʻa ʻIsileli, pea mo e muli ʻoku ʻāunofo ʻiate kinautolu ʻo lauikuonga. ");
INSERT INTO ton_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","¶ Ko ia ʻoku ala ki ha sino mate ʻo ha tangata ʻe taʻemaʻa ia ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Pea te ne fakamaʻa ʻaki ia ʻi hono ʻaho tolu, ka ʻe toki maʻa ia ʻi hono ʻaho fitu: pea kapau ʻe ʻikai te ne fakamaʻa ia ʻi hono ʻaho tolu, ʻe ʻikai maʻa ia ʻi hono ʻaho fitu. ");
INSERT INTO ton_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Pea ko ia ʻoku ala ki he sino mate ʻo ha tangata mate, pea ʻe ʻikai fakamaʻa ia, ʻoku ne fakaʻuliʻi ʻae fale fehikitaki ʻo Sihova; pea ʻe tuʻusi ʻae laumālie ko ia mei ʻIsileli: koeʻuhi naʻe ʻikai luluku ʻaki ia ʻae vai fakamavahe, pea ʻe ʻuli ia, pea ʻoku kei ʻiate ia ʻa ʻene taʻemaʻa. ");
INSERT INTO ton_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ko e fono eni, ʻoka mate ha tangata ʻi ha fale fehikitaki: ʻakinautolu kotoa pē ʻoku haʻu ki he fale fehikitaki, pea mo e meʻa kotoa pē ʻoku ʻi he fale fehikitaki, ʻe taʻemaʻa ia ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Pea mo e ipu kotoa pē ʻoku ava pe, ʻaia ʻoku ʻikai hano tāpuni ke fakamaʻu, ʻe ʻuli ia. ");
INSERT INTO ton_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Pea ko ia ʻoku ala ki ha taha, kuo taaʻi ʻaki ʻae heletā ʻi he ʻataʻatā ʻoe fonua, pe ha sino mate, pe ki ha hui ʻo ha tangata, pe ki ha faʻitoka, ʻe taʻemaʻa ia ʻi he ʻaho ʻe fitu. ");
INSERT INTO ton_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Pea tenau ʻave maʻana ʻoku taʻemaʻa ʻae efu ʻoe pulu fefine kuo tutu, ko e meʻa fakamaʻa ia ʻoe angahala, pea tenau lilingi ʻae vaitafe ki ai ki ha ipu: ");
INSERT INTO ton_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Pea ʻe ʻave ʻe he tangata ʻoku maʻa ʻae ʻisope, ʻo ne fuʻifuʻi ki he vai, ʻo luluku ʻaki ʻae fale fehikitaki, pea mo e ngaahi ipu kotoa pē, pea mo e kakai naʻe ʻi ai, pea mo ia naʻe ala ki ha hui, pe ki ha taha kuo tāmateʻi, pe ki ha taha kuo mate, pe ki ha faʻitoka: ");
INSERT INTO ton_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Pea ʻe luluku ʻe he tangata ʻoku maʻa ʻae tangata ʻoku taʻemaʻa ʻi hono ʻaho tolu, pea mo hono ʻaho fitu, pea ko hono ʻaho fitu te ne fakamaʻa ai ia, ʻo fō hono ngaahi kofu, pea kaukauʻi ia ʻi he vai, pea ʻe maʻa ia ʻi he efiafi. ");
INSERT INTO ton_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Ka ko e tangata ʻoku taʻemaʻa, pea ʻoku ʻikai te ne fakamaʻa ia, ʻe tuʻusi ʻae laumālie ko ia mei he kakai, koeʻuhi kuo ne fakaʻuliʻi ʻe ia ʻae faletapu ʻo Sihova: naʻe ʻikai luluku ʻaki ia ʻae vai ʻoe fakamavae; ʻoku taʻemaʻa ia. ");
INSERT INTO ton_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Pea ko e fekau fai maʻuaipē ia kiate kinautolu, ʻo pehē, Ko ia ʻoku ne luluku ʻaki ʻae vai ʻoe fakamavahe ʻe fō ʻe ia hono ngaahi kofu; pea mo ia ʻoku ala ki he vai ʻoe fakamavahe ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Pea ko e meʻa kotoa pē ʻoku ala ki ai ʻaia ʻoku taʻemaʻa ʻe ʻuli ia; pea ko e tokotaha ʻoku ala ki ai ʻe taʻemaʻa ia ʻo aʻu ki he efiafi. ");
INSERT INTO ton_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Pea naʻe haʻu ʻae fānau ʻa ʻIsileli, ʻio, ʻae kakai kotoa pē, ki he toafa ʻo Sini ʻi he ʻuluaki māhina: pea naʻe nofo ʻae kakai ʻi Ketesi; pea naʻe pekia ʻi ai ʻa Miliame, pea naʻe tanu ia ʻi ai. ");
INSERT INTO ton_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Pea naʻe ʻikai ha vai ki he kakai pea naʻa nau fakataha fakaangatuʻu kia Mōsese pea mo ʻElone. ");
INSERT INTO ton_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Pea naʻe lāunga ʻae kakai kia Mōsese, ʻonau lea pehē, “ʻAmusiaange ʻekimautolu ki he ʻOtua naʻa mau mate fakataha mo homau kāinga naʻe mate ʻi he ʻao ʻo Sihova! ");
INSERT INTO ton_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pea ko e hā kuo mo ʻomi ai ʻae kakai ʻa Sihova ki he toafa ni ke mau mate ʻi heni mo ʻemau fanga manu? ");
INSERT INTO ton_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pea ko e hā kuo mo ʻomi ai ʻakimautolu mei ʻIsipite, ke ʻomi ʻakimautolu ki he potu kovi ni? ʻOku ʻikai ha tenga ʻi he potu ni, pe ha fiki, pe ha vaine, pe ha pomikanite; pea ʻoku ʻikai ha vai ʻi ai ke mau inu.” ");
INSERT INTO ton_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Pea naʻe ʻalu ʻa Mōsese mo ʻElone ʻi he ʻao ʻoe fakataha ki he matapā ʻoe fale fehikitaki ʻoe kakai, pea naʻa na tō ki hona mata, pea naʻe hā mai ʻae nāunau ʻo Sihova kiate kinaua. ");
INSERT INTO ton_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Pea naʻe folofola ʻa Sihova kia Mōsese, ʻo pehē, ");
INSERT INTO ton_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ke ke toʻo ʻae tokotoko, pea tānaki ʻae kakai kenau fakataha, ʻa koe mo ʻElone ko ho taʻokete, pea mo lea ki he maka ʻi honau ʻao, pea ʻe foaki mai ʻe ia ʻa hono vai, pea te ke ʻomi ʻae vai mei he maka kiate kinautolu, pea te ke foaki pehē ʻae vai ki he kakai mo ʻenau fanga manu kenau inu.” ");
INSERT INTO ton_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Pea naʻe ʻave ʻe Mōsese ʻae tokotoko mei he ʻao ʻo Sihova ʻo hangē ko ʻene fekau kiate ia. ");
INSERT INTO ton_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Pea naʻe fakataha ʻe Mōsese mo ʻElone ʻae kakai ki he ʻao ʻoe maka, pea naʻa ne pehē kiate kinautolu, “Mou fanongo mai ʻae kau angatuʻu; ʻoku lelei ke ma ʻomi ʻae vai mei he maka ni kiate kimoutolu?” ");
INSERT INTO ton_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Pea naʻe hiki hake ʻe Mōsese ʻa hono nima, pea naʻa ne taaʻi ʻae maka ʻo liunga ua ʻaki ʻa hono tokotoko, pea naʻe hā mai ʻae vai ʻo lahi, pea naʻe inu ai ʻae kakai mo ʻenau fanga manu foki. ");
INSERT INTO ton_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","¶ Pea naʻe folofola ʻa Sihova kia Mōsese mo ʻElone, ʻo pehē, “Ko e meʻa ʻi hoʻomo taʻetui kiate au, ke fakaongolelei au ʻi he ʻao ʻoe fānau ʻa ʻIsileli, ko ia ʻe ʻikai ai te mo ʻomi ʻae kakai ni ki he fonua, ʻaia kuo u foaki kiate kinautolu.” ");
INSERT INTO ton_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ko e vai eni ʻo Melipa, koeʻuhi naʻe fakakē ʻae fānau ʻa ʻIsileli kia Sihova, pea naʻe ongolelei ia ʻiate kinautolu. ");
INSERT INTO ton_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","¶ Pea naʻe fekau ʻe Mōsese ʻae kau talafekau mei Ketesi ki he tuʻi ʻo ʻItomi, “ʻOku pehē ʻe ho tokoua ko ʻIsileli, Kuo ke ʻilo ʻe koe ʻae fononga kotoa pē kuo tō mai kiate kimautolu: ");
INSERT INTO ton_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Mo e ʻalu hifo ʻemau ngaahi tamai ki ʻIsipite, pea mo ʻemau nofo fuoloa ʻi ʻIsipite, pea naʻe fakafiuʻi ʻe he kaka