﻿USE sofia;
DROP TABLE IF EXISTS sofia.tojNT_vpl;
CREATE TABLE tojNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tojNT_vpl WRITE;
INSERT INTO tojNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ja juun iti, ja' ni huax yala machunc'a yintil ja Jesucristo. Ja yeni, yintil ja rey Davidi soc cho yintil ja Abrahami. ");
INSERT INTO tojNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ja Abrahami, ja' yunin ja Isaac, jaxa Isaqui, ja' yunin ja Jacob, jaxa Jacobi, ja' yunin ja Judá soc ja yermano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jaxa Judá, Tamar sbiil ja xcheumi. Ay chab yuntiquil ja yenlei, ja juni Fares sbiil, jaxa yijtz'ini, Zara. Jaxa Faresi, ja' yunin ja Esrom, jaxa Esromi, ja' yunin ja Aram. ");
INSERT INTO tojNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ja Arami, ja' yunin ja Aminadab, jaxa Aminadabi, ja' yunin ja Naasón, jaxa Naasoni, ja' yunin ja Salmón. ");
INSERT INTO tojNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Jaxa Salmoni, Rahab sbiil ja xcheumi, jaxa yunini, Booz sbiil. Jaxa xcheum ja Boozi, Rut sbiil, jaxa yunini, Obed sbiil. Jaxa Obedi, ja' yunin ja Isaí. ");
INSERT INTO tojNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jaxa Isaí, ja' yunin ja rey David, jaxa rey Davidi, ja' yunin ja Salomoni. Jaxa snan ja Salomoni, cuando yora mi tox yiaj sbaje soc ja rey Davidi, ja' ni statam ja Uriasi. ");
INSERT INTO tojNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Jaxa Salomoni, ja' yunin ja Roboam, jaxa Roboami, ja' yunin ja Abías, jaxa Abiasi, ja' yunin ja Asa. ");
INSERT INTO tojNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jaxa Asai, ja' yunin ja Josafat, jaxa Josafati, ja' yunin ja Joram, jaxa Jorami, ja' yunin ja Uzías. ");
INSERT INTO tojNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jaxa Uziasi, ja' yunin ja Jotam, jaxa Jotami, ja' yunin ja Acaz, jaxa Acazi, ja' yunin ja Ezequías. ");
INSERT INTO tojNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jaxa Ezequiasi, ja' yunin ja Manasés, jaxa Manasesi, ja' yunin ja Amón, jaxa Amoni, ja' yunin ja Josías. ");
INSERT INTO tojNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jaxa Josiasi, ja' yunin ja Jeconías soc ay otro mas ja yermano jumasa ja Jeconiasi. Ja jun c'ole jahui, ti ni aye ja yora jac ch'ac iijuque och mozoil ja ba Babilonia spetzanil ja israeleño jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cuando ti xa aye ba Babilonia ja israeleño jumasa, ti to manxi ja yunin ja Jeconías, Salatiel sbiil, jaxa Salatieli, ja' yunin ja Zorobabel. ");
INSERT INTO tojNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jaxa Zorobabeli, ja' yunin ja Abiud, jaxa Abiudi, ja' yunin ja Eliaquim, jaxa Eliaquimi, ja' yunin ja Azor. ");
INSERT INTO tojNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Jaxa Azori, ja' yunin ja Sadoc, jaxa Sadoqui, ja' yunin ja Aquim, jaxa Aquimi, ja' yunin ja Eliud. ");
INSERT INTO tojNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jaxa Eliudi, ja' yunin ja Eleazar, jaxa Eleazari, ja' yunin ja Matán, jaxa Matani, ja' yunin ja Jacob. ");
INSERT INTO tojNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaxa Jacobi, ja' yunin ja José, jaxa Josei, ja' xcheum ja María, ja' ni ja snan ja Jesús ja ma' yena ni ja Cristoi, ja ma' tzaubal yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jitzan tiempo ec' ja yora mi tox manxi ja Cristo. Desde manxi ja Abrahami, ec' catorce lame cristiano, ti to manxi ja rey Davidi. Ti cho ec' otro catorce lame cristiano, ti to iijiye fuerza ja ba Babilonia ja israeleño jumasa. Ti cho ec' otro catorce lame cristiano, ti to manxi ja Cristo. ");
INSERT INTO tojNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ja Jesucristo jach manxi ja jastal iti: Ja' ni ja snan ja María, jaxa yeni, ja' smacben huinic ja José, pero mi tox yiaj sbaje. Huaj to snaa sbaj, tucbi ta, pero ja' ni yuj ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jaxa José, ja ma' oj ni yii, como toj ni ay ja yeni, mi sc'ana oj sloilta ja smacben ixuqui, jayuj ch'aban ti' abal huas sc'ana yaa can ajyi. ");
INSERT INTO tojNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jach mero huan pensar, iday, jun ta repente huaychini. Yila juntiro jun yangel ja Cajualtiqui. Jac aljuc yabi: ―Q'uelahuil José, ja huena ni ja yintila ja rey Davidi. Mix cham ac'ujol. Mi lom xa huala que mi oja huii ja hua cheum María. Ja jastal ayi, ja' ni sbaj ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Oj sman jun yal alatz, pero querem. Jaxa hueni oj hua sbiiluc Jesús porque yena ni ja ma' mero oj scolta spetzanil ja cristiano soc ja jastal huas slea ja smulei, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Jaxa José, jach ni sc'ulan ja jastal yala ja angeli, como jach ni yalunej ja Cajualtic Dios ja yora yiaj majan ja sti' ja yaluman ja najatei. Jach yala jastal iti: ");
INSERT INTO tojNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Q'uelahuile, jun soltera oj ni tucbuca. Oj sman jun yal alatz, querem nia. Oj bi aajuc sbiiluc Emanuel. Jach ni yala ja aluman‑Diosi. Jaxa biilal jau Emanuel, ay ni sbeja ‑ mi ni cualquiera biilaluc. Ja' ni bi huax yala que ti ni bi ay jmoctic ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ja Josei, yajni huaychini, ti yaa sbaja. Ti sc'uan ja jas alji yab yuj ja yangel ja Cajualtiqui, jayuj ti yiaj ja xcheumi. ");
INSERT INTO tojNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Hauj to snaa sbaj como jastal xcheum cuando manxi ta ja sbajtanil yal ja María. Yaa ni sbiiluc Jesús. ");
INSERT INTO tojNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ja yora manxi ja Jesús ba Belén sbaj lugar Judea, jaxa ma' ay yatel ja ora jahui, ja' ni ja rey Herodesi. Jaxa tiempo jahui, ti c'otye ba Jerusalén chaboxe ja matic jel ni vivo ay juntiro soc ja jastic ay ja ba satq'uinali. Ti elye jan ba lado huax el q'uen ja c'ac'u. Cuando c'otye ja ba chonab Jerusaleni, ");
INSERT INTO tojNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ti sobohue yabalila: ―Ala cabticon, ¿baya sbejlal ja snaj ja sreyil ja israeleño jumasa, ja yal ch'in queremi? Ja ba lado huax el q'uen ja c'ac'u ja ba jlugarticoni, ti quilaticon ja sc'anali, jayuj jacticon ba oj caaticon yi ja smajtani porque mi cualquiera alatzuc, xchi ja matic jel vivo. ");
INSERT INTO tojNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jaxa rey Herodesi, cuando ch'ac yab ja loil it que ti xa ay otro sreyil ja israeleño jumasa, jel jom juntiro ja s'olomi soc jach ni spetzanil ja suinquil ja Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti stzomo sbaj spetzanil ja nihuac spagre ja israeleño jumasa soc ja ma' huas sea ja smandar ja Moisesi. Jaxa rey Herodesi, ti sobo leca: ―Alahuic cabi, ¿ba bi oj manxuc ja Cristoi? xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","―Ti ba Belén, como jach ni stz'ijbunej ja aluman‑Diosi. Ata huabil ja jas huax yala ja suun tac: ");
INSERT INTO tojNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Q'uelahuilex ja huenlex ja janec' ti ayex ba Belén sbaj lugar Judá, mi lom xa hualahuex ta jel ch'in ja hua chonabilexi, jaxa ba otro chonab ja Judá, mas jel tzatz ja mandari. Porque ja ba hua chonabilexi oj to ni ajyuc june ja ma' jel ni tzatz oj ajyuqui, jaxa yeni, oj ni stalna ec' ja quisraeleño jumasa, xchi ja Diosi. Jach ni tz'ijbanubal ja ba suun ja aluman‑Dios, xchi ja spagreil ja israeleño jumasa soc ja ma' huas seahue ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jaxa rey Herodesi ti spaya jan ja huinique ja ma' jel huas snaahue jastal ay ja satq'uinali, pero ch'aban ti' abal spaya. Ti och ya el sti' t'ilana jas ora yilahue ja c'anal jahui, ");
INSERT INTO tojNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ti xa seca ja ba Beleni: ―Cax leanic ja yal querem jahui, pero leanic lec. Cuando huaxa taahuexi, tix jac ahualex caba, jaxa queni oj cho huajcon. Oj ni cho huajcon ja queni ba oj caa yi ja smajtani porque sbej ni, como rey ni ja yena, xchi ja rey Herodesi. ");
INSERT INTO tojNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Cuando yabye ja jas yala ja reyi, ti huajyea. Iday, huaj to yile, ti ni cho yilahue ja c'anali, pero ti ni mismo ja ba yilahue ja ba lugar jau ba lado ja ba huax el q'uen ja c'ac'u. Ti sate huan xta huajel ja c'anali, pero toj ni huaj ja ba lugar jau ja ba manxi ja yal querem Jesusi. Ti ni c'ot tec'ana ja ba mero ay ja yal alatzi. ");
INSERT INTO tojNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ja yajni yilahue c'ot tec'an ja c'anali, jel juntiro gustoaxiye. ");
INSERT INTO tojNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ti ochye ja ba yoj naitzi. Yilahue ja yal queremi soc ja snani, ja' ni ja María. Ti cooye mec'ana. Samahue ja scopreei. Ti yaahue yi ja smajtan ja yal querem Jesusi. Yaahue yi oro soc pom soc jun perpume, mirra sbiil yujile. ");
INSERT INTO tojNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ja mas tzaani, ja huinique jumasa jahui ti suaychinea. Ja ba suayichei alji yabye yuj ja Diosi que mi xa oj to ec'uque ja ba snaj ja rey Herodesi. Jayuj sc'ulane pensar que pilan xa bej oj yie ja cumxiye ja ba slugarei. ");
INSERT INTO tojNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Cuando elye ja ba Belén ja huinique jahui, ti cho suaychin ja José. Sea sbaj yi jun yangel ja Cajualtiqui. Yala: ―José, nutza baj, q'uean. Iaj huego ja alatzi soc ja snani. Caaxic. Ti oj huajanic ba Egipto. Ti ni oj ajyanic ja tihua masan to oj cho cala huab otro vuelta porque ja rey Herodesi huas sc'ana oj slee ja yal queremi ba oj xch'ay snaajel, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jaxa José ti yaa sbaja. Yiaj ja yal queremi soc ja snani, jaxa mismo acual jahui, elye. Ti huajye ba Egipto. ");
INSERT INTO tojNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ti ajyiye t'usan tiempo ja tihui, masan to cham ja rey Herodesi, como jach ni yala ja Cajualtiqui ja yora yiaj majan ja sti ja yaluman ja najatei: Ja' ni ba lugar Egipto ba cal yab oj sip can ja cunini, xchi ja aluman‑Dios jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Cuando jac sc'ujol ja rey Herodesi que mi c'uaji yabal yuj ja huinique jau jel vivoei, jel juntiro tajqui. Ti yala mas lec oj ch'ay snaajel spetzanil ja yal queremtic ja janec' tey ba Belén soc ja ba yal lugar ja ba mojan yioj sbaji. Como sc'ana ta lec sc'ujole ja matic jel vivo jas mero ora yilahue ja c'anali, jayuj yala oj ch'ac chamuc spetzanil ja ma' yioj chab jabili soc ja ma' mi to ni staa chab jabili. ");
INSERT INTO tojNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ja jastal sc'ulan ja rey Herodesi, c'ot ni smeranil ja jas yala ja aluman‑Dios Jeremías ja najatei. Jach ni yala jastal ita: ");
INSERT INTO tojNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xuooljiye xta oq'uel ja ba lugar Ramai. Xch'eeljiye xta oq'uel. Q'ue sni sc'ujole. Spetzanil ja nanal jumasa ja ba Israeli, jel huax ocye juntiro yuj ja yuntiquilei, mi ni huas sc'ana ay jas oj aljuc yabye ba oj cujlajuc ja sc'ujolei, como ch'ac ni ch'ay snaajel ja yal yuntiquilei, xchi ja ba slibro ja Jeremiasi. ");
INSERT INTO tojNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Cuando cham ta ja rey Herodesi, jun yangel ja Cajualtiqui ti cho sea sbaj yi ja Josei. Cho suaychin cuando ti to aye ba Egipto. Alji yab ja ba suayichi: ―Q'uean José. Iaj ja yal queremi soc ja snani. Oj xa ni cumxanic ja ba hua lugar Israeli. Ja matic huas sc'ana oj xch'ay snaajeli, cham ta, x'utji ja José. ");
INSERT INTO tojNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yajni yaa sbaji, yiaj ja yal queremi soc ja snani, ti xa cumxiye ja ba slugar Israeli. ");
INSERT INTO tojNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero ja José, cuando yab yabalil ja' ni ay yatel ja Arquelao, jaxa yeni, ja' bi yunin ja rey Herodes ajyi, xihuel xihuel aye ba oj cumxuque ja ba Judea. Cho huaychini ja José. Alji yab yuj ja Diosi ti bi oj huajuque ja ba lugar ba Galilea. ");
INSERT INTO tojNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jayuj ti huajye ba Galilea. Ti ajyiye ba jun chonab sbiil Nazaret. Jach ni c'ot smeranil ja jas yala ja aluman‑Dios ja najatei, que oj ni aljuc sbaj ja Jesús que nazareño nia. ");
INSERT INTO tojNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ec' jitzan jabil y ja Juan it ja ma' huax yaa bautismo ti huan sloiltajel ja yabal ja Diosi. Ti ajyi ba Judea pero ba jun ch'ayan lugar. ");
INSERT INTO tojNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ti huax yala ja jastal iti: ―Aa xa ni suchuc ja hua c'ujolexa porque jel xa mojan ba oja huil soc ja hua satex ja ma' oj sc'ulucotic mandari porque ja yeni, ti ni coel jan ja ba satq'uinali, xchi ja Juan ja huas sloilta ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ja Juan jahui, yena ni ja ma' taaji ti' yuj ja aluman‑Dios Isaiasi. Jach ni yalunej can ja jastal iti: Oj to ajyuc jun ma' tzatz lec oj c'umanuc ja ba ch'ayan lugari: ―Ja jastal huaxa c'ulanex ja cuando huax jac ja ma' ay yateli, huaxa jamahuex ja sbej nihuan lec, jach huas sc'ana oj ajyuc ja hua c'ujolexi ja cuando huax jac ja Cajualtiqui. Jach bi oj chiuc ja huinic jahui. Y meran nia, ja jastal stz'ijba can ja aluman‑Diosi, jach ni yala ja Juana. ");
INSERT INTO tojNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ja sc'u ja Juani, ja' ni c'ulubal soc ja stzotzil jun chante sbiil camello, jaxa cincho ja ba snalani, tz'uum nia. Ja suaeli, ja' ni ja yal chan sbiil chapulín. Puro yaal chab huax yuaj. ");
INSERT INTO tojNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jaxa suinquil ja Jerusaleni, lom xta xnololjiye huax huajye soc ja Juani soc jach ni ja suinquil ja Judea soc ni spetzanil ja matic mojan ay ja ba nihuanja Jordani. ");
INSERT INTO tojNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yaj ch'ac yab spetzanil ja jas yala ja Juani, ti suchi ja sc'ujolei, ti el stie ja smulei. Ja ba nihuanja Jordani, ti huaj aajuc yile ja' yuj ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jach ni ja fariseo jumasa soc ja saduceo jumasa, cho huajye ja yenlei. Jach sbiile yuj ja sreligionei. Jitzan cho huajye ja yenlei. Huas sc'ana oj ni yie ja' ja yenle chomajquili. Pero ja Juani ti yalaa: ―Ja huenlexi, ja' amojex ja chante it huax elye ajnel ja cuando huax jac ja tziq'uinali. ¿Huan ma xa hualahuex ta oj elanic libre yuj ja huaxa pacahuex ajneli? ¡Majlayic, ti oja huilex ta tajnel ja scastigo ja Diosi! ");
INSERT INTO tojNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","¡Tojbes abajic! Ta meran seguro xa ayexi, ta meran huan xax ilxi que suchi ta ja hua c'ujolexi, ");
INSERT INTO tojNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mi jauc ja huenlex ta mismo oj eluc ja hua tiexi: ―Ja' Abraham ja quintilticon ja quenticoni, ja' oj chianiqui. Huax cala huabyex, ja Diosi ta huan c'a sc'ana, oj ya pax yintilil ja Abraham ja ton jumasa iti. ");
INSERT INTO tojNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ja yaani, ja Diosi lajan soc jastal jun huinic puesto xta ay soc ja yecheji ba oj ch'ac sc'utz el ja te' ba mi tzamaluc ja sati. Oj sip ja ba yoj c'ac'. ");
INSERT INTO tojNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja queni huax ca huiex ja' yuj ja suchi ta ja hua c'ujolex merani. Pero ja ma' oj to jacuqui, ja yeni oj yaa huilex ja Espíritu Santo, pero con todo yip. Pero ja matic mix c'ocxiye, oj ni aajuc cajane c'ac'a. Mas jel nihuan juntiro ja ma' oj jacuqui. Ja queni, mi oj maconucon yuj, mi ni ba oj sop yi ja xanabi. ");
INSERT INTO tojNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ja yeni huax jac ba oj ch'ac spil ja ba lec ja sat iximi soc ja ba somelali, soc oj smes el ja stz'ilelali. Ti xa oj snol can ja iximi ja ba snajtzili, jaxa spolvoili, ti xa oj sip ba yoj c'ac' ja ba mi ni nunca huax tupi, xchi ja Juan ja yora huan sloiltajel ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ja Jesusi ti el ja ba Galilea. Ti huajum ja ba lado Jordán ja bay ja Juani. Huas sc'ana oj aajuc yi ja'. ");
INSERT INTO tojNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero ja Juani mi sc'ana oj ya yii ja'. Ti yalaa: ―¿Jasyujil oj ca huii ja'? Huen oj hua quii ja' mi huen oj ca huii ja', xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ti yala ja Jesusi: ―Meran nia, pero ja huego, acta cani. Sbej ni jach oj c'ultic ba oj ni c'uuctic ja jas huax yala ja Dios que lec nia, xchi ja Jesusi. Soc ja jahui, sc'uan ni ja Juana. ");
INSERT INTO tojNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Cuando ch'ac aajuc yi ja' ja Jesusi, ti xa el el ja ba yoj ja'. Huaj to yile, jamxi ja satq'uinali, ti yila jun yalchan entero jastal splanta jun paloma, pero ja' ni ja Yespíritu ja Diosi. Ti co jan luchan sbaj. ");
INSERT INTO tojNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ti abji ja sc'umal ja mero Dios Tatal ja ba satq'uinali: ―Ja iti, ja' ni ja cunina, xchi. Jel yaj huax cabi. Jel ni gusto huax quilaa. Jach yala ja Dios Tatal ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ja Jesusi ti iiji och yuj ja Espíritu Santo ja ba jun ch'ayan lugar. Ti huaj ja tihui ba oj c'ulajuc probar yuj ja tan diablo. ");
INSERT INTO tojNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta c'ac'u soc cuarenta acual mi huai, ti xa och huain xyaba. ");
INSERT INTO tojNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ti jac ja tan diablo. Jac sc'ul probar ja Jesusi. Ti yalaa: ―Como huena ni yunin Diosaa, a pax quitic huego panil ja ton iti, x'utji ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ti yala ja Jesusi: ―Q'uelahuile, mi quechanuc ja huaelal huax yaa sac'anil ja cristiano, ja' ni spetzanil ja jas huax el ja ba sti ja Diosi. ¿Mi ma jach tz'ijbanubal ja ba yabal ja Dios ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ja tzaan ja jahui, ja diablo ti yiaj och ja ba Jerusalén, ja' ni ja xchonabil ja Diosi. Ti huajye ja ba s'olom ja templo ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Jaxa diablo ti yalaa: ―Como huena ni yunin Diosaa, jipa quitic co abaj. Jach ni huax yala ja yabal ja Dios tac: Ja Diosi oj ni sc'ul mandar ja yangel ba oj scoltaya. Oj bi xchecha eq'ue ba mi oj c'ochuc ahuoc ja toni. ¿Mi ma jach ni huax yala ba? xchi ja diablo. ");
INSERT INTO tojNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","―Eso sí, pero huan nix cho yala que moc ni lom q'uiq'uinal oja c'ul probar ja hua Huajual Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Otro vuelta cho iiji och yuj ja diablo ba jun huitz, ja ba chaan lec ja huitzi. Ch'ac jeejuc yi spetzanil ja lugar jumasa ba mundo. Xlijpi xta yila ja lugar jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ti yala ja diablo: ―Q'uelahuil, spetzanil ja lugar iti oj caa hui pero siquiera oj coan mec'an ja ba sti jsati, xchi ja diablo. ");
INSERT INTO tojNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","―¡Elan ja ba jtz'eel Satanás! xchi ja Jesusi. Ja hua Huajual Diosi, yena ni oj coan mec'an ja ba sti sati. Ja yeni, ja' ni oja huaa c'ujola. Jach ni huax yala ja yabal ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yajni yab ja diablo ja jas yala ja Jesús ja jastal jahui, ti xa ela. Huaj to yil ja Jesusi, ti xa ay ja ángel jumasa. Jacye ba oj scolta soc ja snesesida. ");
INSERT INTO tojNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ja mas tzaani, ja Jesusi, cuando yab yabalil ja Juani, que ochel preso, ti cho cumxi ba Galilea. ");
INSERT INTO tojNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ti ec' ja ba Nazareti, pero mi albi. Ti xa huaj culan ba Capernaum. Ja Capernaumi tey ba sti ja'. Mojan yioj sbaj soc ja lugar Zabuloni soc ja lugar Neftalí. ");
INSERT INTO tojNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jach ni yala can ja aluman‑Dios Isaiasi. Najate lec yala jachuc: ");
INSERT INTO tojNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ja lugar Zabulón soc ja lugar Neftalí ti ni ay ja ba sti ja', ja ba otro lado ja nihuanja Jordani, sbaj ni Galileaa. Ja tihui, ti ni mero culan jitzan ja ma' mi judiouqui, ja cristiano ja matic q'uiq'uinal ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pero yilahue ni ja nihuan luza. Jel ch'ayel ajyiye pero lijpi ni ja luz ja bayei. Jach ni tz'ijbanubal ja ba slibro ja Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja yora huaj ja ba Capernaum ja Jesusi, ti q'ue stul ja sloiltajel ja yabal ja Diosi: ―Aa xa suchuc ja hua c'ujolexi, xchi. Ora xa ni oja huaa bajex soc ja ma' tey ba satq'uinali, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jun c'ac'u ja Jesusi ti huan bejyel ec' ja ba sti ja' ba Galilea. Ti yila chab huinica. Yermano ni sbaje ja huinique jahui. Ja juni, Simón ‑ huax cho alji sbaj Pedro ‑ jaxa yijtz'ini, Andrés. Huane sipjel co ja yenubei ja ba yoj jai. Yamachaye nia. ");
INSERT INTO tojNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ti yala ja Jesusi: ―Laic xa jmoc. Meran, ja' huajel ac'ujolex syamjel ja chayi, pero ja yaani, ja' oja huaa c'ujolex sleejel jan ja cristiano ba oj cho jac jmoc ja yenlei, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jaxa yenlei ti yaa can ja yenubei. Ti huajye soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cuando huane bejyeli, ti yilahue otro chahuane huiniquea, cho yermano ni sbajea. Jacobo ja banquilali, jaxa ijtz'inali, Juan. Ja' ni yuntiquil ja Zebedeo. Naca ti ni aye ja ba sbarco ja statei. Huane stz'acbajel ja yenubei. Ti sobo ja Jesús ta mi huas sc'ana oj huajuque soc ja yeni, ");
INSERT INTO tojNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jayuj ti yaahue can huego ja barco soc ja statei. Ti xa huajye soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ja Jesusi c'atan xta ay eq'ue ja ba sutanal ja Galilea. Ti huan seejel ja ba yiglesia ja judio jumasa. Ja' ni huan sloiltajel ec' ja jastal jel tzamal cuando huas sc'ulan mandar ja Diosi. Spetzanil ja chamum jumasa, chican jas tiq'ue chamel yioje, huan nix ya tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jaxa cristiano, ja' xta ni sloile ec' ja jas huan sc'ulajel ec' ja Jesusi, jayuj ch'ac yabye ba spetzanil ja lugar ba Siria. Jaxa tiempo jahui, iiji jan yi spetzanil ja ma' malo ayi. Tuctuquil ja chamel yiojei. Ay ma' huan ixtalajel lec yuj ja pucuji. Ay ni ma' huax tup yic' cho ay ma' tulido ay ja yoc sc'abi, pero yaa ni tojbuc spetzanilea. ");
INSERT INTO tojNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ja cristiano huan xta sbatalaan ec' sbaje ba oj huaj smaclaye ja jas huax yala ja Jesusi. Ay ma' jacye ba Galilea soc ja ba Decapolisi soc ja ba Jerusaleni soc ja ba sutanal ja Judea. Soc ay ma' cho jac ja ba otro lado ja ja' Jordani. ");
INSERT INTO tojNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ja Jesusi, cuando yila botz'an xta sbaj ja cristiano, ti xa huaj ba jun huitz. Ja tihui, ti och culana. Ja snebumani ti jacye soca. ");
INSERT INTO tojNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ti xa och jeejuc yilea: ");
INSERT INTO tojNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Jel lec huax ec' yujile ja matic huas snaa que jel ajul ja sbaje ja ba sti sat ja Diosi. Ja yenlei ti xa ni aye ba sc'ab ja Dios ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jel lec huax ec' yujile ja matic huax oq'ui. Ja yenlei oj ni aajuc yile snihuan sc'ujolea. ");
INSERT INTO tojNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Jel lec huax ec' yujile ja matic mix c'umani porque ja yenlei, lajan soc tey ba sc'abe spetzanil ja jas ay ja ba luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jel lec huax ec' yujile ja matic jex c'anc'oni toj oj ajyuqui. Oj ni coltajuque yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Jel lec huax ec' yujile ja matic huas stalna syaujulal ja smoji. Oj ni cho talnajuc syaujulal yuj ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Jel lec huax ec' yujile ja matic jel toj ja spensarei. Oj ni yile sat ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jel lec huax ec' yujile ja matic huax ya lamxuc ja pleito. Oj ni naajuque que yunin Diose nia. ");
INSERT INTO tojNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jel lec huax ec' yujile ja matic huax yiaj huocol yuj ja toj ni ayei. Ti xa ni aye ja ba sc'ab ja Dios ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Jel lec huax ec' ahuujilex cuando jel malo huala utjiyex yuj ja jbiili. Soc ta huax aaji ahuilex huocol, ma lom ni mi alben ja jas huax alji abajexi, ");
INSERT INTO tojNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aahuic yi stz'acatal ja Diosi. Ajyanic gusto porque jel tzamal ja hua majtanex tey ba satq'uinali. Jach ni yiaje huocol ja aluman‑Dios ja najatei. ");
INSERT INTO tojNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Lec moc to jauc ja huenlexi, mi naben jastal oj huajuc ja mundo porque ja huenlexi, lajanex soc ja atz'ami. Porque q'uelahuil ja atz'ami. Mi c'a ayuc, mey yajbal ja huaelali. Pero huax cho cala huabyex, moc alajex ja atz'am it huax pooxi, mi xa nix maconi ja mas tzaani. Sbaj xa ni sipjela, anima ti xa huas sbatalaan ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jach ni, luzex ni ayex ja ba mundo. Q'uelahuil jun chonab tey ba scajanal ja huitzi. Chican lec. Mi ni huax nacxia. ");
INSERT INTO tojNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ila jun lámpara. Cuando huan ajlel, mi ni sbejuc oj nujxuc soc jun cajón. ¿Mi ma tiuc huax aaji culan ja ba jun mesa ba? Ja jastal jahui, spetzanil ja matic tey ba yoj naitzi, huan nix yila q'uinala. ");
INSERT INTO tojNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jachuc ja huenlexi, a yil q'uinal ja hua mojexi. Jea yi ja jas jel lec huaxa c'ulanexi. Jachuc, oj ni yaa yi stz'acatal ja hua Tatex tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mi lom xa hualahuex ta jacyon ba oj ch'ay ja smandar ja Moisesi soc ja jas yala ja aluman‑Dios jumasa. Mi jacyon ba oj ch'aye. Jac jea huilex jas mero sbej ja mandar jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Meran huax cala, mi lomuc, mi ni jun palabra oj ch'ayuc ja smandar ja Diosi. Ja luumi soc ja satq'uinali oj ni ch'acuca, pero ja jas huax yala ja Diosi, oj ni c'ot smeranil spetzanila. ");
INSERT INTO tojNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ta ay c'a ma' mandar xa aye yuj ja Dios ba satq'uinali, pero huan c'a syoopes sbaj soc ja smandar ja Diosi, anima jun mandar ba jel ch'in huax yabi, jach ni huas sea yi ja smoja, jel ni coel oj iljuc ja ba sti sat ja Diosa. Pero ja ma' huas sc'uan ja mandari, jach ni huas sea yi ja smoja, ja yeni, jel ni nihuan oj iljuc yuj ja Dios ja ma' huax yaa ja mandar ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Q'uelahuil ja fariseo soc ja ma' huas sea ja smandar ja Moisesi. Jel toj aye ja huax yalahuei. Huax cala, pero meran, ta jach c'a hua modoex ja huenlexi ja jastal ja smodo ja yenlei, ja ma' tey ba satq'uinali mi ni oj yaex cuenta ja ba huas sc'ulan mandari. ");
INSERT INTO tojNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ja huabunejex ja jas alji yab ja ma' ec' pax ta huujilexi: ―Mi la milhuani. Oj c'a milhuanan, oj ni yaa hui castigo ja jueza, x'utjiye bi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero ja queni huax cala huabyex, ta ay c'a ma' coraja huax yila ja yermano, ay modo jastal oj c'ulajuc castigara. ―Lajan soc ja tz'iilel ja jau yen, huan c'ax yutaj ja yermano, ja ma' jach ni huax c'umani, ay modo jastal oj c'ulajuc castigar yuj ja juez mas nihuani. Jaxa ma' huax yal yab ja yermano: ―Ja hueni, lajana soc ja sat tz'ii, jach c'a huas sc'ulan, pues a yaa scuidado. Ay modo oj jecjuc ja ba yoj sc'ajc'al ja inpierno soc ja jastal huax c'umani. ");
INSERT INTO tojNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ja hueni, ta huan c'ax huaj ahuaa yi ja smajtan ja Diosi, yutzil xa oja huaa yi cuando huax jac ac'ujol que ja hua huermano, ay scoraja amoc, ");
INSERT INTO tojNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Aa t'an cani. Cax tojbes abajex bajtan soc ja huermano, entonces ti la jaca. Tix jac ahuaa yi ja smajtan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tojbes abajex. Ora to ja huego. Mi c'a, ja mas tzaani ja hua condra oj ni yaa endregal ja ba sti sat ja juezi, jaxa juezi, oj yaa ba sc'ab ja comandante, jaxa comandante oj xch'ica och preso. ");
INSERT INTO tojNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Huax cala, pero meran, ja ba yoj preso mi ni oj elana masan huax ch'ac atup spetzanil ja hua muli. ");
INSERT INTO tojNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ja huabunejex ja jas alji ja najatei: ―Moc lomuc alee otro acheum. Moc lomuc alee otro atatam. Jach ni alubal ahuabyexa. ");
INSERT INTO tojNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero ja quen huax cala huabyex, ta ay c'a jun huinic quechan huax yila jun ixuc, jex c'anc'oni yuj, quechan soc ja jahui, slea ta ni smula, anima mi jas huas sc'ulan. ");
INSERT INTO tojNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jayuj ta ja' c'a ja hua sat huax ya lee ja hua muli, mas lec, sutu jun lado. Mas lec ach'ay snaajel junuc ja hua sati que no que spetzanil ja hua cuerpo oj aajuc och ja ba inpierno. ");
INSERT INTO tojNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ta ja c'a ja hua c'abi huax ya lee ja hua muli, pues mas lec a ch'ay snaajel junuc que no que spetzanil ja hua cuerpo oj aajuc och ja ba inpierno. ");
INSERT INTO tojNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Alubal nia: ―Ja ma' huas sipa can ja xcheumi, oj ni yaa yi jun juuna. ");
INSERT INTO tojNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero ja queni huax cala huabyex, ta ay c'a ma' lom huas sipa can ja xcheumi, ta mi c'a huanuc sleejel smul soc otro huinic, lajan soc ti huas sipa ba yoj c'ac' ja xcheumi. Jach ni ja huinic oj cho nupanuc soc ja ma' jipubal cani, huan nix cho staa smul soca. ");
INSERT INTO tojNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ja huabunejex ja jas alji yabye ja ma' ec' pax ta huujilexi: ―Ta huan c'a xa taa ti' ja Diosi ‑ xila Dios, meran la chi ‑ entonces mi lom xa lea mentira. Ta huan c'a xa taa ti' ja sbiil ja Diosi, t'ilan ni oja hual ja smeranila. ");
INSERT INTO tojNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ja queni huax cala huabyex, mas lec mi xa taa ti' ja sbiil ja Diosi soc mi ni ja satq'uinali. Ja satq'uinali, delicado, porque ti ni ay ja ma' huas sc'ulan mandari. ");
INSERT INTO tojNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Soc jach ja lumq'uinali, mi lom xa taahuex ti' porque ja ba luum iti, c'atan ni ay ec' ja Diosa. Mi ni ja Jerusaleni, mi xa taahuex ti'. Ja chonab jahui, ja' xchonabil ja Diosi. Ti ni mero oj sc'ul mandara. Delicado nia. ");
INSERT INTO tojNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","―Anima huax c'utzji ja j'olomi, meran nia, la chiyex. Iday, mi sbejuc huaxa huala jachuqui. Pues Dios huas snaa ta oj eluc ja hua olomi. Mi jas huaxa naa ja hueni. ");
INSERT INTO tojNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Alahuic ta meran ma mi meranuc. Huan c'a la jelxi, soc ja jahui, oja taa mul. ");
INSERT INTO tojNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Cho huabunejex que alji ni yab ja cristiano ja najatei: ―Ta ay c'a jun amoj huas stupu hui june ja hua sati, jach ni ja yen, oj cho tupjuc yi june ja sati. Huan c'ax ya el jun ahuej, jach ni ja yen, oj cho aaji eluc june ja yeji. ");
INSERT INTO tojNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero ja queni huax cala huabyex, ta ay c'a ma' jel malo, huan c'ax yixtalaana, mi lom xa colta baj. Ta ay c'a ma' huax yaa yi vuelta ja hua choji, cho sutu yi ja otro lado, cho a yaa yi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ta ay c'a ma' huax och parte, huas sc'ana hui ja hua c'ui, aa yi. Mi lom xa yajta. Cho aa yi ja hua camisolai. ");
INSERT INTO tojNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Huan c'ax jac jun soldado, huan c'ax yala oja cuch spetzanil ja jas yioji ba jun lehua, pues cuchu yi chab lehua. ");
INSERT INTO tojNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ta ay c'a ma' huas sc'ana hui jun cosa, mi lom xa yajta. Aa yi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ja huabunejex ja jastal alubal ja najatei: ―Yaj xa huab ja hua moji, pero ta ay c'a ma' huax yilahua condra, jachuc ja huen, cho acta cani. ");
INSERT INTO tojNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero ja queni huax cala huabyex, yaj xa huab ja hua condraexi. C'uman ja Dios yuj ja ma' huax yilahua coraja. ");
INSERT INTO tojNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jach c'a huaxa c'ulanex, como yuninex nia ja hua Tatex tey ba satq'uinali. Q'uelahuil ja yeni. Ja yeni sc'ulunej ja c'ac'u ba oj quijlabuctic, sea lec ja jmodotiqui ma mi lecuc. Huax ya jacuc ja jai, sea ja ma' mi tojuc, ma sea ja ma' toj ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Quechan c'a yaj huaxa huab ja ma' yaj huax yabya, ja jahui, mi huocoluc. Ja jahui, mi jas oj aajuc ahui. Hasta ja cristiano ja ma' huas stzomo ja contribucioni, jel coel huaxa huilahuex, pero ja yenlei, yaj huax yab ja yamigo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ta quechan c'a ja hua huamigo huaxa huaa yi Diosi, ¿jasunc'a huaxa c'ulanex mas lequi? Hasta ja ma' mi sc'uan ja Diosi, huan nix yaa yi Dios ja yamigo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pero ja huenlexi, sbej que oj ajyanic ja jastal toj ay ja Dios Tatal tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ta toj c'a aya meran soc ja jas huaxa c'uani, mi lom xa c'ulan abaj ba oj stoya ja cristiano. Jach c'a huaxa c'ulan, mi jas oj yaa hui ja hua Tat tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cuando huaxa huaa hua limosna, mi t'ilan ma' oja hual yabi porque ta ay c'a ma' huaxa hual yabi, quechan huaxa lea ba oj toyjan. Pe jitzan ni lec ja ma' jach ni smodoe tac. Huax huajye ba yiglesia. Jaxa ba calle gana huas slea jun sbejyele yac xta ba oj toyjuque que jel huas sc'uan ja Diosi. Huan nix toyjiyea pero quechana, pero soc ja Diosi, mi jas ay. ");
INSERT INTO tojNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero ja huenlexi, cuando huaxa huaa hua limosnaexi, pues mi ni ja hua huamigo, mi t'ilanuc oj snae. ");
INSERT INTO tojNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jach ch'aban ti' abal, jaxa Tatal Dios ja ma' huax yila que nac'ul abal ay ahuujilexi, ay ni jas oj yaa huilexa. ");
INSERT INTO tojNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Cuando huaxa c'uman ja Diosi, moc lomuc alajex ja ma' huas sea sbaj que lajan soc jel lequi. Ja yenlei huax huajye ba iglesia. Ja tihui, ja' ni sgustoe huas sc'umane ja Diosi, pero quechan ba huas sc'ana oj toyjuque lec. Cada huas staahue jujune calle, t'ilan huax c'otye tec'an. Huas sc'umane ja Diosi. Ja' mero smodo ja yenlei. Ja' ni mero huas slea stoyjelea. Huan nix toyjiyea pero quechana, pero soc ja Diosi, mi jas ay. ");
INSERT INTO tojNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero ja huenlexi, cuando oja c'umuquex ja Diosi, leahuic jun lugar ba ch'ayan. Mi t'ilan oja jea baj yi soc ja cristiano. Jaxa tihui, c'uman ja hua Tatexi. Anima jun ch'ayan lugar, ja yeni ti ni aya. Ja hua Tatexi huax yila ja jas huaxa c'ulanexi. Oj ni yaa huilex ja jas huaxa c'anahuexi. ");
INSERT INTO tojNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Cuando huaxa c'umanex ja Diosi, mi jauc ja lom oj xta bulbunananiqui ja jastal ja ma' mi sc'uan ja Dios sac'ani. Ja yenlei huax yalahue que ti huax yab ja sdiose yuj ja jastal ja sc'umalei. ");
INSERT INTO tojNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Moc alajex ja yenlei porque ja hua Tatexi, mi to xa c'ana yi, ja yeni huan xa ni snaa jasunc'a ja hua nesesida. ");
INSERT INTO tojNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Oj cala huabyex jastal oja c'umuquex ja Diosi: Jtaticon Dios ti aya ba satq'uinali, ja hua biili, mi cualquierauc ‑ jel nihuan juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A jacuc ja tiempo oj ni ac'ul mandari. A c'ulajuc ja jastal huaxa c'ana. Ja jastal huaxa c'ulan ja ba satq'uinali, jach ni a c'ulajuc ja ba luum chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ja yaan c'ac'u aa quiticon ja juaelticoni. ");
INSERT INTO tojNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Como jc'ulanticon ta perdonar ja ma' huas sc'ulan quiticon malo, c'ulanoticon xa perdonar soc ja jmulticon Cajual. ");
INSERT INTO tojNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Moc hua c'ulajucoticon ganar soc ja jmulticoni. Pilahuoticon ja ba yoj maloili porque ja huena ni ayticon ba hua c'abi. Quechan ni huen jel ja hua huipi. Ja hueni, huan ni la lijpia. Jach ni aya tola vidaa. Amén. Jach ni oja c'umuquex jastal it ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ta ay c'a smul ja hua moji, ta huan c'a xa c'ulanex perdonar, jach ni ja hua Tatex tey ba satq'uinali, oj ni sc'uluquex perdonara. ");
INSERT INTO tojNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero ta mi c'a xa c'ulanex perdonar ja hua mojexi, jach ni ja hua Tatex tey ba satq'uinali, mi ni oj sc'ul perdonar ja hua mulexa. ");
INSERT INTO tojNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jaxa cuando huaxa como ja hua huaelexi, mi lom xa jea bajex que jel triste ayex. Jach c'a huaxa jea bajex, yuj ni huanex sleejel jastal oj toyjanica. Ja' amojex ja jun c'ole jau gana huas somo sbaje siquiera oj naajuc yuj ja cristiano que huane scomjel ja suaelei. Huan nix toyjiyea pero quechana, pero soc ja Diosi, mi jas ay. ");
INSERT INTO tojNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero ja huenlexi, cuando huaxa como ja hua huaelexi, mi lom xa c'ulan cambiar abajex mas. Jixa hua olomex como siempre. Atnanic como jastal ja hua modoexi. ");
INSERT INTO tojNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jach c'a huaxa c'ulanex, mi oj naajuc ta huaxa como ja hua huaelexi. Quechan oj yil ja hua Tatex ja ma' huax yila spetzanil ja lugari, anima jun ch'ayan lugaruc. Ja yeni, oj ni yaa hua majtanex ba jel nihuana. ");
INSERT INTO tojNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ja jas ay ja ba mundo, chican jas cosa, mi lom xa yajta porque oj ni och xchajnula soc oj ni cuxbuca. Oj cho ni och lagron ba oj yie. ");
INSERT INTO tojNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mas lec mi lom xa yajtayex. Ta mi c'a ja' huajel ja hua c'ujolex ja jas ay ba mundo, ja ba satq'uinali ay jas nolobal ahuilex ba mas jel tzamali. Ja tihui mix och xchajnul soc mix cuxbi soc mey lagron ba oj yie. ");
INSERT INTO tojNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chican ja ba huaxa yajtayexi, ti ni huajel ja hua c'ujolexa. ");
INSERT INTO tojNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ta ja' c'a huaxa yajtayex ja cosa ba Diosi, entonces lajan soc ja ma' ti xa ay ba jel ja luzi. Toj xa ni huan bejyela. ");
INSERT INTO tojNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero ta mi c'a huanuca bejyel toji, lajan soc ti ni huana bejyel ja ba yoj q'uiq'uinali. Jachuc, ta huan c'a xa huala que ti xa aya ja ba luzi pero ta ja' c'a jel yaj huaxa huab ja cosa ba mundo, lom ni huaxa huala que ti xa aya ba luzi. Mas to jel q'uiq'uinal juntiro aya. ");
INSERT INTO tojNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Q'uelahuil jun huinic. Mi ni modo oj slee chab yajuala. Ta jach c'a huas sc'ulan, pues lec oj yil ja juni, jaxa juni, coraja oj yile. Menos oj yil ja juni, jaxa otro juni, yaj ni oj yaba. Jach ay ja Diosi soc ja taq'uini. Mix bob ayajta ja xchabili, jayuj tzaa ba oja huaa c'ujolexi. ");
INSERT INTO tojNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jayuj huax cala huabyex, mi lom xa c'ulanex pensar jastal oj ajyanic, jastal oj huaanic. Jach ni ja hua c'uexi, mi xa c'ulanex pensar. Ja jas huaxa huabyexi soc ja jastal huaxa c'uutes abajexi, pero ay to mas jel t'ilan que yuj ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Q'uelahuil ja yalchan jumasa. Mi jas huas stz'unuhue soc mi ni huax jach'ulaniye, mi ni ba huas snolo ja suaelei, iday, jaxa hua Tatex ja ba satq'uinali, yen huax yaa yi ja suaeli. Iday, yalchane, ¡jauc to ma huenlexi! ");
INSERT INTO tojNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Huan ama xa hualahuex que oj ajyan jitzan tiempo ja ba luumi yuj ja chamc'ujol xta ayexi? ");
INSERT INTO tojNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Jach ni ja hua c'uexi, ¿yuj ama ti oja taex yuj ja chamc'ujoli? Q'uelahuil ja yal nichim ba huitzi. Mix atjiye. Mix ch'alniye. ");
INSERT INTO tojNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero mi ni ja sc'u ja rey Salomoni mi slaja ja jastal ja yelahuil ja yal nichim jahui conser ja Salomoni jel tzamal juntiro ja sc'u huas slapa. ");
INSERT INTO tojNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jaxa nichim ba huitzi, ja huego yaax, jaxa jecheli huax ch'ac c'ac', pero anima, jel tzamal ja yelahuil huas sc'ulan ja Diosi. ¡Jauc to ma huenlex mi oj ni sc'uutesexa! Pero ja huenlexi, jel huocol huaxa c'uanex. ");
INSERT INTO tojNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","―¿Jasunc'a oj cabtiqui? ¿Jastal oj taa ja jc'uutiqui? la chiyex. ¡Ch'abananic soc ja hua pensarexi! Actayic can t'usan ja abc'ujoli. ");
INSERT INTO tojNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Spetzanil ja jastal iti, ja' huajel sc'ujol ja ma' mi sc'uan ja Dios sac'ani. Pero ja huenlexi, ja hua Tatex tey ba satq'uinali huan ni snaa jastic junuca huaxa c'ulanex nesesitari. ");
INSERT INTO tojNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jayuj aa bajex spetzanil ja hua c'ujolex ja ba smandar ja Diosi. Ajyanic toj como jastal ja yeni. A huajuc ja hua c'ujolex soc ja yeni. Jach c'a ayex, mi ni jas oj sc'uluc ahuilex palta. ");
INSERT INTO tojNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jach ni ja tiempo oj to jacuqui, mix cham ac'ujolex. Mi sbejuc najtil tiempo ja hua pensarexi. C'ac'u c'ac'u huan eq'uel ahuocolexi. ");
INSERT INTO tojNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mi lom xa huaa huochel ja otro cristiano. Ta jach c'a huaxa c'ulan, jach ni ja hueni, oj aajan ochelal. ");
INSERT INTO tojNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Huan ita c'a xa q'uela ja hueni, jach ni ja hueni, oj ita ni cho q'ueljana. Ta jach c'a huaxa c'ulan ja hueni, jach ni oj cho c'ulajuc ahuia. ");
INSERT INTO tojNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Jas lom huaxa q'uela ja stz'iilelal ja sat ja hua huermano pero mas to jel nihuan tey ba hua baj ja hueni, iday, mi ni huaxa huaa yi casoa? ");
INSERT INTO tojNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","―Majla, oj ca eluc ahui ja stz'iilelal ja hua sati. Jach huaxa hual yab ja hua huermano. Pero hua baj ja hueni, ¡mi ni icben sbej jastal aya! ¿Jastal modo oja hual yab jachuc ja hua huermano? ");
INSERT INTO tojNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ja hueni, pacaxero aya juntiro. Mas lec, a el bajtan ja tz'iilel tey ba hua sat ja hueni, entonces oj xa bob ahuil q'uinal ba oj hua eluc ja stz'iilelal ja sat ja hua huermano. ");
INSERT INTO tojNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pero aa cuidadoex soc ja cristiano jumasa. Ta ay c'a ma' jel coraja huax yab ja smeranil ja Diosi, puro c'a burla huax ochye, aa cuidadoex ja jastal huaxa taahuex ti' ja Diosi porque ja yeni, mi cualquierauc. Mi c'a, lajan soc huaxa huaahuex ba oj yixtalauque ja sbiil ja Diosi. Huaj to ahuabyex, yaahuex ta can baan luum ja huenlex chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Cuando huaxa c'umanex ja Diosi, c'anahuic yi ja jas huaxa c'anahuexi. Ja yeni oj ni yaa huilexa. Mi lom xa huaahuex can ja sc'anjel yii. T'ilan oj aajuc ahuilex. Jaman c'a ja hua tiexi, oj ni ataex ja jas huaxa c'anahuexi. ");
INSERT INTO tojNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porque spetzanil ja ma' ay jas huas sc'ana yi ja Diosi, huan nix aaji yia, jaxa ma' mix yaa can ja sc'anjeli, huan ni sc'ulan recibira, jaxa ma' jaman ni ja stii, huan ni staaa. ");
INSERT INTO tojNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Machunc'a junuc ja huenlexi ja hua huuninexi, ta huan c'a sc'ana huilex jun pan, oj ma huaex yi jun ton ba? ");
INSERT INTO tojNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma huas sc'ana huilex jun chay, ¿oj ma huaahuex yi jun mal chan ba? ");
INSERT INTO tojNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ja huenlexi, eso sí, maloex nia pero iday, huan ni xa huaahuex yi ba lec ja smajtan ja hua huuntiquilexi. ¡Jauc to ma ja hua Tatex ja ma' tey ba satq'uinali! Puro ni lequil majtan oj yaa yi ja matic huas sc'ana. ");
INSERT INTO tojNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Q'uelahuil ja huenlexi, puro lec huaxa c'ana oj c'ulajuc ahuilex. Jachuc ja huenlexi, c'ulanic yi lec ja cristiano. Ja iti, ja' ni ja sbej ja sley ja Diosi, soc jach ni yala ja aluman‑Dios jumasa ba najatei. ");
INSERT INTO tojNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ochanic ja ba puerta ba ch'ini porque ja puerta ba nihuani soc ja bej ba jel nihuani, ja tihui, ti huax huaj ja ma' ch'ayel ni ayi. Jel jitzan juntiro ja ma' huax huaj ja tihui porque mi ni huocoluc ja bej jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jaxa puerta ba ch'ini soc ja ch'in beji, ja' ni huax huaj ja ma' puro tzamal oj yili. Jel t'usan ja ma' huas staa ja bej jahui porque jel ni huocola. ");
INSERT INTO tojNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Aa cuidadoex soc ja ma' huas sea sbaj que aluman‑Dios bii. Ja yenlei huas sea jun smodo ba jel tzamal, jaxa sc'ujolei, huan xta huaatzhuunuc. ");
INSERT INTO tojNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Oja naex jastal ay ja sc'ujolei yuj ja yatele mi lecuc huas sc'ulanei porque q'uelahuilex jun q'uiix. Mi ni modo oj yaa sat jastal jun lobal. ");
INSERT INTO tojNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Spetzanil ja te' ba lequi, tzamal ni ja sat huax yaa. Pero cuando mi xa lecuc ja tei, jach ni ja sati, mi xa lecuc. ");
INSERT INTO tojNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ja te' ba lequi, mi ni modo oj yaa sat maloa, jaxa jun te' ba mi xa lecuc, mi ni ja sati, mi ni modo oj yaa leca. ");
INSERT INTO tojNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ja te' ba mi xax yaa tzamal ja sati, sbaj xa ni sc'utzjela, sbaj xa ni oj och c'ac'a. ");
INSERT INTO tojNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Cuando huaxa huila jastal ay ja sat ja tei, huaxa naa ta lec ma mi lecuc. Jach ay ja tantic cristiano jahui. Cuando huaxa huilahuex ja smodoei, yuj ni jach ay ja sc'ujolea. ");
INSERT INTO tojNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ja ma' tola vida huax yala: ―Cajual, Cajual, yuj ja huax yala jachuqui, ¿yuj ama yuj tola vida huax yala jachuqui ti xa ay soc ja smandar ja ma' tey ba satq'uinal ba? Quechan ja ma' huas sc'ulan ja jas huax yala ja jTat tey ba satq'uinali, oj ni ochuque ja tihui. Mi ni modo oj ochuc yuj ja jastic huan elel ja ba stii. ");
INSERT INTO tojNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ja último c'ac'u jahui jel jitzan ja ma' oj yal cabi: ―Cajual, Cajual, pero jloiltaticon ja hua biil tac. Quechan jtaaticon ti' ja hua biili, jaxa pucuji yacta can ja cristiano. Jc'ulanticon jitzan milagro yuj ja hua biili. ¿Mi ma ahuila ba? oj chiuque. ");
INSERT INTO tojNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","―Pero ja queni, mi ni nunca jnaa bajex, oj cute. Caaxic. Ja' huajel ac'ujolex ja maloili. Jach oj cal yabye ja quen ja c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pero ja ma' huax yab ja jas huax cala, huan ni sc'uana, lajan soc jun huinic ba jel vivo. Huas sc'ulan ja snaji pero tz'unan lec huax yaa cani. ");
INSERT INTO tojNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jaxa mas tzaani, co ja jai. Jac ja butjai. Cho jac jun ic' jel tzatz. Huas spuctzin sbaj ja ja' ba sat ja snaji, pero mi jas sc'ulan, como tz'unan ni leca. ");
INSERT INTO tojNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero ta ay c'a ma' huax yab ja jas huax cala, pero mix yaa caso, ja yeni lajan soc ja ma' huas sc'ulan ja snaji pero huan ita xyaa cajan can ja ba sat ja luumi. Lajan soc jun yal untic ba michinq'uinal ay. ");
INSERT INTO tojNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Co ja jai. Jac ja butjai. Cho jac jun ic' jel tzatz. Huas spuctzin sbaj ja ja' ba sat ja naitz jahui. Soc ja jahui, uchpiji ja naitzi. Jel ni tristea. ");
INSERT INTO tojNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Cuando ch'ac ta yal ja jastal it ja Jesusi, ti jel och ja spensar ja cristiano yuj ja jas huax yala. ");
INSERT INTO tojNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Lajan bi soc jun huinic ay lec yatel. Tuc bi juntiro ja yen soc ja ma' huas sea ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ja Jesusi, cuando co ja ba huitzi, ti jac nochjuc yuj jitzan cristianoa. ");
INSERT INTO tojNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huaj to cho yil ja Jesusi, ti jac jun huinic malo ay. Huan c'ael ja sbacteli. Huaj tajuc sc'ab, ti yalaa: ―Cajual, ta jach c'a huaxa c'ana ja hueni, oj ni hua tojbucona, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jaxa Jesusi xija ja sc'abi. Syama ja huiniqui, ti yalaa: ―Huan nix c'anaa. Oj ni tojbana, xchi. Jaxa sc'aelal ja sbacteli, huego huego tojbi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ti alji yab yuj ja Jesusi: ―Moc lomuc aloilta ja jastal tojbiya. Mas lec, caax. Cax jea baj yi ja pagre, ti xa huaa yi ja jas yala can ja Moisesi, cosaque oj ni naajuc que tojbiya taa, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ja Jesusi ti huaj ba Capernaum. Cuando oj xa c'otuqui, ti jac tajuc yuj jun huinic ja ma' jepe ay ba jun c'ole soldado. ");
INSERT INTO tojNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jac c'anjuc yi jitzan pavor: ―Cajual, ay quioj jun mozo ja ba jnaji. Pero jel huan huocol soc ja xchameli. Mi xax bob snic sbaj, xchi ja soldado. ");
INSERT INTO tojNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","―Lec, oj huajcon. Oj ni huaj ca tojbuca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero ja huiniqui ti yalaa: ―Cajual, jel q'uixhuel ja jbaj oj huaj abat ja jnaji. Malan soc oja hual cabi. Ja jahui, huan nix naa que oj ni tojbuc ja jmozo. ");
INSERT INTO tojNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ja queni mandar ayon y ay quioj soldado huax c'ulan mandar ja quen chomajquili. Huax cal yab ja jun iti, caax, huax cutaj, y huan nix huaja. Jaxa otro jun iti, la, huax cutaj, y huan nix jaca. Jaxa jmozo, c'ulan ja iti, y huan ni sc'ulana, xchi ja jepe jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Cuando yab ja Jesús ja jas yala ja huinic jahui, jel och juntiro ja spensari. Jaxa cristiano ja ma' jac nochan soqui, ti ch'ac yal yaba: ―Huax cala huabyex, pero meran, mi ni nunca jtaa ja ma' huas sc'uan ja jastal ja huinic iti, mi ni june ba Israel oj slaj ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jach ni, jitzan ja ma' oj el ba spetzanil lado ja lugari oj jac stae ja Abrahami soc ja Isaqui soc ja Jacobi. Lajan oj ajyuque ja ba huas sc'ulan mandar ja ma' tey ba satq'uinali, ");
INSERT INTO tojNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero ja jun c'ole oj ni sbajuc ja satq'uinal ajyi, ja' ni ja israeleño jumasa, oj nutz'ujuque ba yoj q'uiq'uinal, jaxa tihui jel ja oq'ueli. Oj ni sc'ux ja yejea. ");
INSERT INTO tojNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ja Jesusi ti yal yab ja sepeil ja soldado: ―Ja hueni, caax. Oj ni c'ulajuc ahui ja jas huaxa c'ana. Ja hua mozo tojbi, como hua c'uan, xyutaj. Jaxa mozo jahui, ja mismo ora jahui, tojbi nia. ");
INSERT INTO tojNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ja Jesusi, cuando huaj ja ba snaj ja Pedro, ti yila ja snial ixuqui. Baan eq'ue. Ay yioj c'ac'. ");
INSERT INTO tojNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ti syama yi ja sc'ab ja ixuc jahui, jaxa sc'ajc'ali ec' huego. Ti xa q'uea. Q'ue yaa yi ja suael ja ma' tey ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jaxa mismo och c'ac'u jahui ti iiji jan yi jitzan ja cristiano ja matic ixtalanubal yuj ja pucuji. Quechan soc ja c'umani ja Jesusi, ya el libre ja cristiano, jaxa pucuji, spacahue ajnel. Spetzanil ja matic malo ayi yaa ni tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jachuc, c'ot smeranil ja jas yala ja aluman‑Dios Isaías ja najatei: Ja yeni, yena ni ja ma' el el yuj spetzanil ja jchameltiqui. Yuj ja yeni, yaa ni ch'ayuc ja jchameltiqui, xchi ja Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja Jesusi, cuando yila jac xta botz'an sbaj ja cristiano, entonces ti yala que mas lec oj ec' sc'utz ja jai soc ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cuando oj xa huajuque, ti jac june ja ma' huas sea ja smandar ja Moisesi: ―Maestro, chican ba huala huaja, oj ni huajcon amoca, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jaxa Jesusi ti yalaa: ―Pero ja queni, mas lec ja jalahui. Ay sq'ueen. Soc ja yalchan huax jujpi ec' ba nalanchaani, ay soj. Ja queni coelon ni jan ja ba satq'uinali, pero mi ni ba oj ochcon baani, mey quioj, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ay to otro jun huinic huan snebjel ja jas huax yala ja Jesusi. Ti yala ja yeni: ―Cajual, cuando huax cham ja jtati, ti oj jacon amoca, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","―Ja hua tati, oj ni mucjuc yuj ja ma' mi ni cuenta ayuc soc ja Diosi, jaxa hueni, la xa jmoc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ti xa q'ue ja ba barco ja Jesusi. Jach ni ja snebuman jumasa, cho q'ueye. ");
INSERT INTO tojNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Cuando ti xa ay ja sbarcoe ba yoj jai, huaj to yile, jac jun ic' pero jel tzatz juntiro. Jaxa barco, ti mustalaji yuj ja jai. Iday, jaxa Jesusi, huan huayel. ");
INSERT INTO tojNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jaxa smoj jumasa ja Jesusi ti huajyea. Huaj syujquese ja Jesusi: ―Cajual, q'uean. Coltayoticon. Mi c'a, oj xa huajtic ja', xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","―¿Jasyuj jel huala xiuyexi? ¿Mi ma huaxa c'uanex ba? xchi ja Jesusi. Ti xa q'uea. Yal yab ja iq'ui que oj lamxuc, jach ni ja jai, yal yab que oj lamxuc. Xlamami huaji. ");
INSERT INTO tojNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jaxa huiniquei, jel och ja spensarei: ―¿Jas huiniquil ja iti? Hasta ic' huax ya lamxuc, jach ni ja jai, huax ya lamxuc, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ja Jesusi ti c'ot ja ba otro lado ja jai, ja' ni ja slugar ja gadareño jumasa. Ti jac tajuc yuj chab huinica. Ja yenlei, juntiro mandar ay yuj ja pucuji. Ti elye jan ba campo santo. Jel c'aq'ue juntiro. Mi sc'anahue que ay ma' oj ec'uc ja ba bej jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ti ahuaniyea: ―Ja huena ni ja yunina Dios tac y ¡jastal aya jmocticon ja huen ba! ¿Yuja huocheloticon ba? ¿Jaquela ma ba oja huixtalaucoticon ba? Iday, mi to coraucticon tac, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iday, jaxa mismo lugar jahui, mi mero najatuc, tey jun nole chitama. Ti huane huaela. ");
INSERT INTO tojNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pero ja pucuj jumasa, ti c'anji yi jitzan stz'acatal ja Jesusi: ―Ta huan c'a xa nutzuhuoticon, c'ulan quiticon pavor. Aa quiticon permiso ba oj ochcoticon ba scuerpoe ja chitam jumasa, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","―Pues ochanic, x'utjiye yuj ja Jesusi. Ja pucuj jumasa ti yaahue can ja huinique jahui, ti huaj ochuque ja ba scuerpo ja chitam jumasa jahui. Jaxa chitami, lom xta xbalali ch'ac couque ja ba huitzi. Ti ch'ac couque ba yoj ja'. Ti ch'ac siq'ue ja'. ");
INSERT INTO tojNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jaxa tanumchitam jumasa, ti ch'ac spaque ajnela. Ti huajye ja ba yoj chonabi. Ch'ac huaj sloiltaye spetzanil. Jach ni, cho yalahue jastal ay ja chab huinique ja ma' huax c'ulaji mandar yuj ja pucuj ajyi. ");
INSERT INTO tojNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jaxa spetzanil ja cristiano ja ba chonab jahui, ti huaj slee ja Jesusi. Cuando staahuei, ti sc'anahue yi stz'acatal ba oj eluc ja ba slugarei. ");
INSERT INTO tojNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jaxa Jesusi ti q'ue jun barcoa. Ec' sc'utz otro vuelta ja jai. Ti c'ot ja ba xchonabili. ");
INSERT INTO tojNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Huaj to yile, ti iiji jan yi jun huinic, q'uechubal soc xch'ajtilteil. Tulido ay ja yoc sc'abi. Jaxa Jesusi yila que huax c'uaji lec, ti yal yab ja ma' tulido ayi: ―Hijito, mix cham ac'ujol, ja hua muli, tupel xa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pero tey chaboxe ja ma' huas sea ja smandar ja Moisesi. Quechan ta yenle huax yaltalaan sbaje: ―Ja jas huan yaljel ja tan huinic iti, ¡jel piero! ¡Huas sc'ulan sbaj jastal Dios tac! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ja Jesusi huas snaa jastal ay ja sc'ujolei, jayuj ti yalaa: ―¿Jaxa yuj ja toj malo huan sc'ulajel pensar ja hua c'ujolexi? ");
INSERT INTO tojNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jasunc'a huaxa c'anahuex oj cal ba? ¿Q'uean huego, oj ma cut ba? ¿Ja' ma gustoex jach oj cal ba, soc ja huax cala, ja hua muli, tupel xa? ");
INSERT INTO tojNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Porque ja queni, ti coelon jan ja ba satq'uinali. Ja' catel ayon ja ba luumi que oj ni jc'ul perdonar ja mulali. Pero ba oja c'uuc ja huenlexi, que yuj ni ac'ubal catela, oj ni ca tojbuc ja huinic ita. Ti yal yab ja huinic ja ma' tulido ayi que oj q'ueuc. ―Iaj ja hua huaynubi, cax xa ja ba hua naji, xyutaj ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ti xa q'ue ja huinica. Huaj ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jitzan ja cristiano ja ma' yila ja iti, jel och juntiro ja spensarei. Jel sc'anahue yi stz'acatal ja Diosi yuj ja ay xa ma' tey ba luum ac'ubal yip yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ja Jesusi ti xa el ja tihui. Ti ec' ja ba oficina ja ba huas tzomxi ja contribucioni. Jaxa tihui, quena ni huanon ni atela ‑ Mateo jbiil. Yajni yilahuon ja Cajualtic Jesusi, ti yala caba: ―Mateo, ¿mi ma xa c'ana jacan jmoc ba? xyutajon. Ti xa q'ueyon tec'an huegoa. Huajyon soc ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","11","Jun c'ac'u ja Jesusi ti huaj huauc ja ba jnaji. Ti smoj ja snebuman jumasa. Cho tey jitzan ja jmoj atel ajyi ja ba colecturía, cho tey jitzan otro cristiano. Iday, ja tantic fariseo yalahue que jel bi mulanumoticon como ti bi huane huael jmocticon lajana. Como ti huas sq'uelahuoticon ja tantic fariseo, ti yalahue yab ja snebuman ja Cajualtic Jesusi: ―¿Jas sbej ja jun ta sec' huan huael ja hua maestroexi soc ja tantic colector jumasa soc ja tantic mulanum jumasa? xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Cuando yab ja Jesús ja iti, ti yalaa: ―Ja matic lec ayi, mi huas slea ja doctor pero ja matic malo ayi, huane sleejel ja sdoctorei. ");
INSERT INTO tojNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","A jac ac'ujolex ja jas huax yala ja spalabra ja. Diosi: Ja queni huax c'ana oj talna syaujulal ja cristiano. Mi jauc huala ocyon yuj oja mil jun chante ba oja huaa ba sti jsati. ¿Mi ma jach ni huax yala ja Dios ba? Ja queni mi jaquelucon ba oj lee ja ma' huas stoyo sbaj que jel toji. Jaquelon ba oj lee ja mulanum jumasa ba oj yaa can jun lado ja smulei. Jach alji yab ja tantic fariseo yuj ja Jesús ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Entonces ti jac ja snebuman ja Juan it huax yaa bautismo. Ti jac jobjuc yi ja Jesusi: ―¿Jastal ay ba? Ja quenticoni soc ja fariseo, tola vida huan nix como ja juaelticona, pero ja hua nebuman ja hueni, mi ni t'usan huas scomo ja suaelei, xyutaje ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ti sutu jan ja Jesús chomajquila: ―Pero ¿jasyuj oj tecticon huaini? Pe gusto ayticon tac. Q'uelahuil jun ch'acabalanum. Ja yamigo ja nupanumi, mi ni modo oj ajyuque tristea, como ti ni tzomane soc ja nupanumi. Pero oj ni jacuc ja c'ac'u cuando oj ni ch'ay yujile ja nupanumi. Eso sí, ja c'ac'u jahui oj ni scom ja suaelea yuj oj ni but'uque yuj ja stristeilei, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ja Jesusi ti cho yala otro palabra ba oj jac sc'ujole que yajc'achil nia ja jas haun seejel ja yen: ―Ba jun poco c'ual mas lec mix hua ochuquex smactonil ba yajc'achil porque ja c'uutz jahui, mi quechan oj sujbuc. Toj coleto ni oj huajuca. ");
INSERT INTO tojNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jach ni jun oxom ba ay syaj. Mix bob hua och ja taan ba yajc'achil to. Jach c'a huaxa c'ulan, huaj to ahuile, leutz'uji ta snalan ja oxomi, jaxa hua taani, mi xa lecuca. Mas lec aa ba jun oxom ba mey syaj. Jachuc, mi ni jas oj sc'uluca, mi ni ja oxomi soc mi ni ja taani, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jach huan yaljel cuando jac jun huinic. Ay yatel ba yiglesia ja judio jumasa. Jac staa yi sc'ab ja Jesusi. Ti yal yaba: ―Ay tat, cham ta ja cunin aq'uixi. C'ulan qui pavor, caax. Cax yama qui ja scuerpo ja cunini ba oj sac‑huuc, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yajni yab ja Jesusi, huego huaj soc ja huiniqui, jach ni ja snebuman jumasa chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Huajume ja ba snaj ja huiniqui, huaj to snaa ja Jesusi, ti nochobal yuj jun ixuc. Jaxa ixuc jahui, ti syama yi ja snich ja sc'u ja Jesusi. Huan lec huocol. Ay xa lajchahue jabil mi xax ec' ja scuenta. ");
INSERT INTO tojNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Huan xta loil ja sc'ujol cuando mi to syama ja sc'u ja Jesusi: ―Siquiera oj bob jyam ja sc'ui, soc ja jahui oj ni tojbucona, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ja Jesusi ti sutu sbaj, ti sq'uelaa, ti yal yaba: ―Hija, mix cham ac'ujol. Yuj ja hua c'uani, tojbiya ta, x'utji ja ixuc jahui. Iday, huego huego ec' ja xchameli. ");
INSERT INTO tojNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jaxa Jesusi ti c'ot ja ba snaj ja huinic jau ja ma' ay yateli. Jel ja ajmayanumi, jaxa jun nole mucachamhuiniqui, tuctuquil ja jas huanei. ");
INSERT INTO tojNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jaxa Jesusi ti yalaa: ―Caxic xa ba hua najex porque ja aq'uix iti, mi ni chameluca. Quechan huan huayel, xchi. Jaxa yenlei ti taquintzeeniyea. ");
INSERT INTO tojNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cuando ch'ac ta el spetzanil ja jun nole cristiano jahui, ja Jesusi ti och ja bay ja chamhuiniqui. Syama yi ja sc'abi, jaxa aq'uixi q'ue huego. ");
INSERT INTO tojNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yuj ja ya sac‑huuc ja aq'uix jahui, xpucuqui xta ec' ja yabalil ja ba lugar jumasa tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jaxa Jesusi ti xa el ja ba lugar tihui. Ja cuando ti to ay ba nalan beji, ti cho jac nochjuc yuj chab huinic. Puro tupel ja satei. Huane xta ahuanel: ―Majla, ja huena ni yintila rey Davidi. Talna jyaalticon, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pero ja Jesusi ti xa och ja ba jun naitz. Jaxa ma' tupel ja satei ti cho ochyea. Ti jobji yile yuj ja Jesusa: ―¿Huan ma xa hualahuex ta oj bob jc'uluc ja iti? ―¡Ba miyuca Cajual! xchi ja huiniquei. ");
INSERT INTO tojNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ti yamji yile ja satea: ―Ja yaani oj xa huilex q'uinal, como ja c'uanonex ta, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y meran nia, huego huego yilahue ni q'uinala. ―Q'uelahuilex, mi lom ma' xa hualex yab ja jastal tojbi ja hua satexi, x'utjiye. Pero cuando yala jastal iti, c'ac' ni ay ja sc'umala. ");
INSERT INTO tojNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero iday, ja huajye ja yenlei, ja' yobrae ch'ac spuque ec' ba spetzanil ja lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Cuando elye ja tihui, ti cho iiji jan yi jun huinic ixtalanubal yuj ja pucuji. Mi xax aaji c'umanuc. ");
INSERT INTO tojNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Cuando ch'ac ta aaji el yi ja pucuji, ti xa jamxi ja stii. Iday, jaxa huinic jahui, mi xax c'umani ajyi. Jaxa jun nole cristiano jahui, jel juntiro och ja spensarei: ―Eso sí, israeleñootic nia, pero ba oj quiltic oj c'ulajuc quitic ja jastal ja it ja quentiqui, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ja fariseo, tuc ja jas huax yalahue ja yenlei: ―Eso sí, huax ya el ja pucuji, pero mi yenuc yip, pero como ja' ni yip ja sepeil ja tantic pucuji, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ja Jesusi, c'atan xta ay eq'ue. Huax huaj ba spetzanil ja chonabi soc ja yal hacienda jumasa. Jaxa ba yiglesia ja judio jumasa, ja' ni huan sloiltajel ja jastal jel tzamal cuando huas sc'ulan mandar ja Dios ja ba jc'ujoltiqui. Soc huan nix ch'ac ya tojbuc ja cristiano, chican jas tiq'ue chamel yioje. ");
INSERT INTO tojNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Cuando yila jel ja cristiano mi xa snaa jas oj sc'uluque, lajane xa bi soc ja chej ba suelto xa ni ayi, mi xa ay tanuman. Jayuj ti jel jac syaal sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ti yal yab ja snebumani: ―Ja cristiano jumasa lajan soc jun alaj ba stiempo xa sachjeli, pero jasa, jel t'usan ja jach'ulumi. ");
INSERT INTO tojNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mas lec, c'anahuic yi ja suinquil ja jach'oji ba oj sec mas ja jach'ulumi ba oj scuch jan ja iximi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ja Jesusi ti spaya jan ja lajchahue snebumani. Ti yala ja Jesusi: ―Ja huego oja c'uluquex mandar ja pucuj jumasa porque jel huax yixtalaane ja cristiano ja tantic pucuj jahui, xchi ja Jesusi. Cuando huax jac ja ma' ay xchameli, chican jas tiq'ue chamelil yioj, a tojbuquex, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ja sbiil ja lajchahue snebuman it oj xa sequi, jach ni ja jastal iti: Ja sbajtanili, Simón sbiil, cho huax alji sbaj Pedroil. Soc ja Andrés ja yijtz'ini, soc ja Jacobo yunin ja Zebedeo, soc ja Juan ja yijtz'ini, ");
INSERT INTO tojNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Soc ja Felipe, soc ja Bartolomé, soc ja Tomasi, soc ja queni ja Mateooni. Ja catel ajyi, huas tzomo taq'uini. Jaxa otro snebumani, ja' ni ja Jacobo yunin ja Alfeo, soc ja Lebeo ja ma' ay otro sbiil Tadeo, ");
INSERT INTO tojNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Soc ja Simón ja cananista, soc ja Judas Iscariote ja yena ma' yaa endregal ja Jesús ja mas tzaani. ");
INSERT INTO tojNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja Jesusi, cuando ch'ac see yi ja lajchahuanei, ti seca ba oj sloilta ja yabal ja Diosi: ―Moc lomuc ahualex yab ja ma' tuc raza ayi soc mi lom la huajyex ja ba xchonabil ja samariteño jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pero caaxic. Cax loilta yabye ja ch'ayel cheji, ja' ni ja jmojtic israeleñoili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Oj cala huabyex jas oja hualex yabi: Tiempo xa ni oja huaa bajex soc ja Dios ja ma' huas sc'ulan mandar ja ba satq'uinali, utajic. ");
INSERT INTO tojNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","A tojbuquex ja matic malo ayi, jaxa ma' cham ta, aahuic sac‑huuc, jaxa ma' huan c'ael ja sbactelei, aahuic tojbuc. C'ulanic mandar ja pucuji. Ja hua huipex iti, ac'ubal ni ahuilexa y mi amanunejuquex. Jayuj mi sbejuc oja c'uluquex cobrar ja huenlex chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mi lom xa c'ulanex pensar ta mey sbaal ja yal amorralexi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mi ni ja hua c'uex, ta mi c'a potzanuc chabei, soc mi ni hua xanabexi, soc mi ni ja hua najbanteexi. Porque jun atjum, sbej ni oj aajuc yi ja stz'acola. ");
INSERT INTO tojNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Chican jas chonabil ma chican jas yal haciendail ja ba huala c'otyexi, jobohuic yabalil ja cristiano ja ma' toj ni ayei. Ti la huajyex ba snaj ja yenlei. Ti la ajyiyex ja tihui masan to oj elanic. ");
INSERT INTO tojNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Cuando huala ochyex ja ba naitz jahui, aahuic yi Dios. ");
INSERT INTO tojNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta meran c'a toj ay ja suinquili, c'umanic ja Diosi ba laman oj ajyuque, pero ta mi c'a toj ayuque, como laman ajyanic ja huenlexi. Actayic cani. ");
INSERT INTO tojNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi c'a huas sc'ulanex recibir, mi c'ax yab slugaril ja hua palabraexi, pues elanic ja ba naitz jahui. Actayic can ja xchonabilei. Tzijun can ja spolvoil ja hua huoquexi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ja c'ac'u oj yae yi cuenta ja Diosi, ¡ay pobre ja yenlei! Ja suinquil ja Sodoma soc ja suinquil ja Gomorra, jel ni piero ja yenlea, pero mas to leque que yuj ja suinquil ja chonab jahui. Pero meran huax cala, mi loiluc. ");
INSERT INTO tojNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Eso sí, ja cristiano jel c'aq'ue. Ja huenlexi, lajanex soc jun chej. Lajan soc huax jecahuex ja ba yojol ja tigre. Vivo ajyanic como jastal ja chichi. Pero cho ch'in ajyanic como jastal ja yal untiqui. ");
INSERT INTO tojNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aa cuidadoex porque oj ni yaex endregal ja ba sti sat ja juezi, jaxa ba yojol ja yiglesiaei, oj ni smaq'uex soc chicotaa. ");
INSERT INTO tojNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Oj ni yaex endregal ja ba sti sat ja gobierno soc ja ba sti sat ja reyi pero yuj ja huaxa c'uanonexi. Jachuc, oj ni yabye cabalil ja yenlei. Soc jach ni ja ma' tuc raza ayi, oj ni yaba. ");
INSERT INTO tojNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ja cuando huala c'ulajiyex endregali, ja mero ora jahui, mi lom xcham ac'ujolex jastal oj c'umananic, jas oja hualex. Ja ora jahui, oj ni aajuc jacuc ac'ujolexa. ");
INSERT INTO tojNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mi huenuc oj c'umananic, ja' ni ja Yespíritu ja hua Tatex tey ba satq'uinali. Ja yeni oj c'umanuc ja ba hua tiexi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Oj c'otuc ja tiempo jun huinic oj sc'ul endregal ja yermano ba oj chamuc. Jachuc jun tatal, oj sc'ul endregal ja yunini. Jachuc jun nanal tatal, oj iljuque condra yuj ja yuntiquili, masan oj chamuque. ");
INSERT INTO tojNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Jach ni ja huenlexi, yuj ja huiojex ja jbiili, oj ni yilex condra ja cristianoa. Pero ja ma' huas sc'ulan ahuantar ja masan to huax ec' ja tiempo ja huocol jahui, ja yeni, oj ni c'ulajuc librara. ");
INSERT INTO tojNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ta ti c'a ayex ba jun chonab, jel c'a huax aaji ahuilex huocol, elanic xa. Caxic ba otro chonab. Mas mi tox ch'ac abatex spetzanil ja xchonabil ja jmojtic israeleñoili, oj cho jac ja ma' coel ni jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Q'uelahuil jun maestro. Mi oja hual mas nihuan ja ma' huan snebjel ja ateli. Jachuc jun ajualal. Mi oja hual mas nihuan ja smozo. ");
INSERT INTO tojNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pero ja ma' huan snebjel ja ateli, jel lec ta huas slaja svivoil ja smaestro. Jachuc jun mozo, jel lec ta oj cho bob ajyuc ajualalil. Pero ta huan c'ax alji sbaj inpierno ja ma' Ajualal ayi, ¡jauc to ma jun mozo mas to jel tzatz oj aljuc sbaj! ");
INSERT INTO tojNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pero mi jauc oj xihuanic yuj ja jas oj aljuc abajexi. Mi jas nac'an ay ba mi oj chicnajuc. Mi ni jas cosa ba ch'aban ti' abal oj ajyuca. ");
INSERT INTO tojNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ja jas nac'an huanon yaljel ahuabyexi, alahuic satalajel abal ja huenlexi. Ja huego, lajan soc sajaloil huanex yabjeli, jaxa huenlexi, alahuic ba yoj comon. ");
INSERT INTO tojNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ja matic huas sc'ana smil ja jcuerpotiqui, mi lom la xiuyex yuj. Mix bob xch'ay ja caltziltiqui. Mas lec, ja' oj xihuanic yuj ja Diosi, porque ja yeni, ay yip ba oj bob xch'ay ja caltziltiqui soc jach ni ja jcuerpotiqui. Ti oj ya xch'ay snaajel ba yoj inpierno. ");
INSERT INTO tojNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Q'uelahuil ja yal tz'unuli. Lom nia. Mi ni ma' oj smana. Pero anima, mi ni june ja yenlei ba mi oj yil ja hua Tatex oj co luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","¡Jauc to ma huenlexi! Hasta ja stzotzil ja hua olomexi, cuenta ay. ");
INSERT INTO tojNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jayuj, mi lom la xiuyex. Yajtanubal to ni ja yal ch'in tz'unuli, ¡jauc to ma huenlexa! ");
INSERT INTO tojNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Spetzanil ja matic claro huas staa ti' ja jbiili, jachuc ja queni, oj ni jtae ti' ja sbiilei ja ba sti sat ja jTat tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero spetzanil ja matic nac'ul ay yuj ja jbiili, jach ni ja queni, mi ni oj taa ti' ja sbiile ja ba sti sat ja jTat tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mi lom xa c'ulanex pensar ta jaquelon ba luum ba oj ca lamxuc ja cristiano. Mi jaquelucon ba oj ca lamxuc. Jaquelon ba oj ca q'ue pleito. ");
INSERT INTO tojNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Jun huinic oj yil condra ja stati, jaxa jun ixuc oj yil condra ja snani. Jun ixuc huax och alibajel, oj yil condra ja yalib ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jun huinic, ja' ni ja scondra ja suinquil ja snaji. ");
INSERT INTO tojNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ja ma' mas huas syajta ja snan stat que yuj ja queni, mi ni sbejuc oj bajuca. Jachuc ja ma' mas huas syajta ja yuntiquili que yuj ja queni, mi ni oj bajuca. ");
INSERT INTO tojNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Pero c'ulanic ahuantar ja huocoli. Anima huax aaji locananic ja ba cruzi, pero siquiera laic jmoc. Mi c'a, mi ni nunca oj bajuquexa. ");
INSERT INTO tojNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Porque ja ma' huas syajta ja scuerpo, ja yaltzili huan ni sipa ba yoj c'ac'a. Pero ja ma' mi huas syajta ja scuerpo yuj ja queni, ja yeni, oj ni staa scoltajela. ");
INSERT INTO tojNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ja ma' huas sc'ulanex recibiri, quena ni huas sc'ulanone recibira. Jaxa ma' huas sc'ulanon recibiri, ja' ni huas sc'ulane recibir ja ma' secahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ja ma' huas sc'ulan recibir jun aluman‑Dios yuj ja jecubal ni jan yuj ja Diosi, oj sc'ul recibir ja smajtan ja jastal oj sc'ul recibir jun aluman‑Dios. Jach ni, ta huax jac jun huinic ba toj, y huan c'a xa c'ulanex recibir, jun xta yabal ja hua majtanex oja c'uluquex recibir ja c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jaxa yal cuntiquili, ta ay c'a ma' huax yaa yi siquiera jun vaso cheel ja' yuj ja quen jecuneji, entonces ja ma' huax yaa, ay ni jas oj to aajuc yi ja yen chomajquili. Oj ni sc'ul recibir ja smajtani. ");
INSERT INTO tojNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ja Jesusi, cuando ch'ac yaa yi mandar ja lajchahue snebumani, ti xa spila sbaj soca. Ti huaj ja ba xchonabile ja yenlei. Huaj sloilta ja yabal ja Diosi soc huaj see yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ja Juani lutan preso ja ora jahui, jaxa cuando yab yabalil ja jas huan sc'ulajel ec' ja Cristo, ti seca ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Huaj sob yi ta yena ni ja Cristo ja huane smajlajeli, ja' ni ja ma' tzaubal yuj ja Diosi, ―¿ma ay otro ma' oj majlaticon? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ti yala ja Jesusi: ―Caaxic. Cax alahuic yab ja Juani ja jas huaxa huabyexi soc ja jas huaxa huilahuexi porque ");
INSERT INTO tojNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ja ma' tupel ja sat ajyi, huan xax yila q'uinal, jaxa ma' renco ay ajyi, toj xa huax bejyi, jaxa ma' huan c'ael ja sbactel ajyi, tojbi ta, jaxa ma' mix yab q'uinal ajyi, huan xax yab q'uinal. Jaxa ma' cham ta ajyi, sacui ta, jaxa ma' pobre ayi, huan xax yabye ja jas yajc'achil xa ba jel tzamali. Jach cax alahuic yab ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jel lec oj ec' yujil ja ma' mix ec' sc'ujol ta mi quenuc ni ja jecubalon yuj ja Diosi, x'utjiye yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ja secabanum ja Juani ti huajyea. Jaxa Jesusi ti och sloilta jastal ay ja Juani, como jel ja cristiano huane smaclajeli: ―Jaxa cuando huajyex ja ba ch'ayan lugari, ¿jasunc'a huaj ahuilexi? ¿Yuj ama huaj ahuilex jun huinic lajan soc ja aj huan xta cumtz'ijel yuj ja iq'ui? ");
INSERT INTO tojNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Entonces ¿jasunc'a ja huilahuexi? ¿Yuj ama huaj ahuilex jun huinic ba jel tzamal juntiro ja sc'ui? Iday, ¿mi ma quechanuc huax tax ja ba snaj ja rey ja jastal jau ba? ");
INSERT INTO tojNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Jastal lec huajyex ja tihui? ¿Yuj ama huaxa hualahuex que oja huilex junuc ja yaluman ja Diosi? Meran nia, ja huilahuex nia, pero mas to jel nihuan ja ma' ahuilahuexi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ja huinic jahui, yena ni ja ma' taubal ti' ja ba slibro ja Diosi: Q'uelahuile, ay ma' oj jeque ba oj sloilta ja cabali. Ja yeni, bajtan oj ya q'ueuc ja ateli que yuj ja hueni. Yuj ja jas huas sea ja yeni jayuj puesto oj ajyuc ja cristiano ba oj sc'uuc ja jas oja loilta ja hueni, xchi ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mi ni june ja ma' ac'ubal yi yatel como jastal aaji yi ja Juani. Iday, jel ni nihuan ja yateli pero ay to jas mas jel nihuan que yuj ja yatel ac'ubal yii. Q'uelahuile ja jas huas sc'ulan ja Diosi. Huas staa jun cristiano ba jel ch'in juntiro huax ilji, ti huax yila como jastal yuntiquil. ¿Mi ma mas jel nihuanuc ja jau ba? ");
INSERT INTO tojNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Desde tiempo jau q'ue ja yatel ja Juan it huax yaa bautismo, masan ora, huan xta sbatalaan sbaje ja cristiano yuj ja mix yilahue ora oj yaa sbaje ja ba sc'ab ja ma' tey ba satq'uinali. Lajan soc sac ajnele xta aye eq'ue. ");
INSERT INTO tojNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Como najate ni alubal jachuca. Jach ni yalahue spetzanil ja aluman‑Diosi soc jach ni tz'ijbanubal ja ba sley ja Diosi. Jayuj cuando manxi ja Juani, c'ot ni smeranil spetzanil ja jas tz'ijbanubal sbaj ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ja Diosi yala que ja' ni ja aluman‑Dios Elías oj sec jan ajyi, pero ta huan c'ax bob ac'uuquexi, yena nia ja Juan ja ma' jaqui. Cuando jac ja Juan jahui, ti ilxi ja smeranil ja jas yalunej ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ja ma' huax yab q'uinali, a yab slugaril, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","―¿Jasunc'a oj ca smojuc ja cristiano jumasa iti? Ja' mero smoje ja yal untiqui. Q'uelahuil ja yal untiqui, ta ay c'a chab c'ole huax yiaj sbaje tajnel nalan patio, yenle ta huax yautalaan sbaje: ");
INSERT INTO tojNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ja quenticoni juuticon ta ja ajmayi, jaxa huenlexi mi ni modo hua la chaaniyexa, xchiye. Ja quenticoni octicon ta, iday ja huenlexi, mi ni modo hua la ocyexa. Jach huax yutaj sbaje. ");
INSERT INTO tojNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jaxa cristiano iti, lajan soc ja jun c'ole yal untic ba mi jas huas sc'anahuei, porque ja Juani, jel ni scomo ja suaela soc mi ni t'usan yuaj ja yaalel tz'usubi, iday, huax yaahue och demonioil. ");
INSERT INTO tojNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jaxa queni ti ni coelon jan ja ba satq'uinali y mix como ja juaeli. Huax cho cuaj ja yaalel tz'usubi, iday huax yutajone chitamil. Tan yacbumon bi. Ja' bi jmoj ja cristiano jumasa jau huas stzomohue ja taq'uini soc ja otro mulanum jumasa. Pero anima. Ja ma' mero yuntiquil ja Diosi, huan ni snaahue sbaj machunc'a ja mero Tatali, jaxa Tatali, huan nix yila ja jc'ujoltiqui cada jujune. Huas snaa ja Diosi ja baya lequi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Cuando ch'ac yal ja jachuqui, ti xa och utanuc leca. Jel ja jas yal yab ja suinquil ja chonab ja ba sc'ulan ta jitzan ja milagro. Utjiye yuj ja mi ni modo huas suchi ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Ay pobre ja huenlex ja matic suinquilex ja Corazini! Soc jach ni ja matic suinquilex ja Betsaida, ¡jel ajul abajex! Jach c'a c'ulaji ja milagro ja ba suinquil ja Tiro soc ja ba suinquil ja Sidoni, entonces ay xa tiempo suchi ja sc'ujolea. Jach c'a, ja' xa ni sc'ue ja huanhuocha soc huan xa ni saxa sbaje taana. Yatz'an xta ni tola vida ja yaltzile yuj ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huax cala, pero meran, mas yoc'an oj yii ja scastigo ja suinquil ja Tiro soc ja suinquil ja Sidoni ja c'ac'u oja huaex yi cuenta ja Diosi. Pero ja huenlexi, tzatz juntiro oja huiex ja castigo. ");
INSERT INTO tojNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Jaxa huenlex ja matic suinquilex ja Capernaumi, jel lom juntiro huaxa toya bajex. ¿Yuj ama huaxa hualahuex ta oj q'ueanic ja ba satq'uinali? ¡Ay pobre ja huenlexi! ¡Ti ni oj jipjanic ja yoj inpierno! Ta jach c'a c'ulaji ja milagro ja ba Sodoma ja jastal c'ulaji ja ba hua chonabilex ja huenlexi, pues mex ch'ay snaajel masan oraa. ");
INSERT INTO tojNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jach huax cala, pero meran. Ja c'ac'u jau oja huaex yi cuenta ja Diosi, mas yoc'an ja scastigoe oj aajuc yile ja suinquil ja Sodoma que yuj ja huenlexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ja mismo ora jahui, ja Jesusi ti yalaa: ―Ja huen Tatey, Ajualal aya ja ba satq'uinali soc jach ni ja ba luumi. Ja ma' vivo soc ja ma' jel huas snaahuei, mi jauc huaxa jea yi ja jastic iti. Tz'acatal, ja' huaxa jea yi ja matic ch'in huax yaa sbaj ahuii. ");
INSERT INTO tojNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Lec Tatey, como jach ni huaxa c'anaa. ");
INSERT INTO tojNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ja yaani, Tatey, quena ni huax c'ulan mandara pero huena ni ahuaunej quia. Mi ni ma' huas snaa ta quena ni ja huuninoni. Quechan huen huaxa naa soc ja ma' huax c'ana oj jee yi que quena ni ja hua huuninoni porque mi ni june ma' huas snaa ba ayaa Tatey. Quechan ja quen huax naa porque ahuuninon nia. ");
INSERT INTO tojNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ja Jesusi ti yal yab ja cristiano: ―Ja huenlex ja matic cuchan ahuujilex jun montón ja mandar jumasa, cuchan ni ahuujilex tola vida ja hua cargaexi, yajtiquex xta, laic xa jmoc. Oj ni ca jijlanica. ");
INSERT INTO tojNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","¿Mi ma xa c'anahuex oja huiex ja jmandar ja quen ba? ¡Jel oj liquicuc oj huajuc ja hua hualtzilexi! Nebahuic ja jastal ja queni, porque jel ja jas oj jea huilex, ti oja huilex que jel mansoon soc jel ja jpasensia. ");
INSERT INTO tojNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ja mandar huax caa ja queni, mi t'ilan montón cargauc. Jel tzamal oja huabyex. ");
INSERT INTO tojNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jun c'ac'u ja Jesusi soc ja snebumani ti ecye ba jun yalajil trigo. Ja snebumani jel xa huain xyabye. Ti stuch'uhue ja sat ja trigo. Sc'uxuhue, ");
INSERT INTO tojNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iday, iljiye yuj ja fariseo jumasa. Ti huaj chonjuc yabalilea: ―Q'uelahuile Jesús, xchiye, ¿mi ma jauc ja c'ac'u jijlel ja huego ba? ¿Sbej ama jach huane ja hua nebuman ba? xchi ja fariseo. ");
INSERT INTO tojNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ti yala ja Jesusi: ―Entonces mi ni t'un huaxa huabyex slugaril ja jas yala ja slibro ja Diosi. ¿Mi ma xa naahuex ja jas sc'ulan ja rey David ja najatei cuando och huain xyabi soc ja smoj jumasa? ");
INSERT INTO tojNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ja yeni, cuando och ja ba stemplo ja Diosi, sloohue ni ja pan ti jian ec' ja ba sti sat ja Diosi, iday, ja pan jahui, mi sbejuc oj sloe, mi ni ja Davidi soc mi ni ja smoji. Quechan huax bob sloo ja pagre jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pero q'uelahuilex ja pagre ja ba templo. T'ilan ni huas sc'ocohue ja sc'ac'uil ja jijleli, pero mi ni malouc ja jas huas sc'ulanei. ¿Mi ma jach tz'ijbanubal ja ba sley ja Dios ba? ");
INSERT INTO tojNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ja huenlexi, jel nihuan ahuiojex ja hua temploexi, pero ja huego, como ti xa ni ayon amoquexa, ay jas mas jel t'ilan oja huaahuex caso yuj ja templo. ");
INSERT INTO tojNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aa xa jac t'unuc ja hua c'ujolex ja jas huax yala ja Diosi: Mi jauc huax c'ana ba oja milex chante ba oja huaahuex quii. Quechan huax c'ana que oja talnayex ja syaal ja hua mojexi, xchi ja Diosi. Pero ja huenlexi, mi ni t'un huaxa huabyex slugarila. Huanuc to c'a xa huabyex slugaril ja yabal ja Diosi, entonces mi oja chonex yabalil ja ma' mi ni ay smula. ");
INSERT INTO tojNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ja queni coelon jan ja ba satq'uinali. Quena ni oj cal jasunc'a lec sc'ulajel ja ba c'ac'u jijleli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ja Jesusi ti xa huaja. Ti och ja ba yiglesia ja mismo judio jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Huaj to yile, tey jun huinica. Jiman xa ec' ja sc'abi. Mi xa ni modo xbob ya q'ueuca. Pero ja fariseo jumasa ti yalahuea: ―Ja c'ac'u iti, ja' ni sbaj jijlel tac. ¿Yuj ama sbej oj hua tojbuc ja yaan c'ac'u ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ti yala ja Jesusi: ―Jaxa huenlex ba, ta ay c'a huiojex jun chej, huan c'ax moc' ba yoj q'ueen, ja' c'a sc'ac'uil jijleli, ¿mi ma oj bob hua eluquex ba? ");
INSERT INTO tojNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iday, jun chej, ¡jauc to ma ja huinic ita! Abyic t'un sbej ba. Ja sc'ac'uil jijleli sbej ni oj c'ulaxuc ja ba leca. ");
INSERT INTO tojNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ti yal yab ja huinic jahui: ―A q'ueuc ja hua c'abi, xchi. Jaxa huiniqui ya q'ueuc ja sc'abi. Staa slugar como jastal ja otro jun sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jaxa fariseo ti xa elyea. Och yii yabal sbaje: ―¿Jas oj c'ultic yi ja iti? ¡La xa jch'aytic el snaajel! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pero ja Jesusi huan ni snaa jasunc'a ja spensarei, jayuj ti xa el ja tihui. Pero ti huaj nochan soc jitzan cristiano. Jaxa matic malo ayi, mi ni june ma' mi ya tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero yala que mi oj spuque ec' ja jastal tojbiyei. ");
INSERT INTO tojNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jachuc, c'ot ni smeranil ja jas yala ja Dios ja ba slibro ja Isaías aluman‑Dios ja najatei. Jach yala jastal iti: ");
INSERT INTO tojNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Q'uelahuil ja jmozo. Quena ni jtzauneja. Jel ni yaj huax caba. Jel gusto ayon soc. Oj ni caa yi ja Espíritu Santo ba oj bob sloilta yab ja cristiano jastal oj to quii cuenta ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ja jmozo jahui mi lom oj c'umanuc, mi ni oj cho bulbunuc lom. Mi oj ahuanuc ba yoj calle. ");
INSERT INTO tojNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ja ma' jel ajul ja sbaj huax ilji, mi oj yil condra ja yeni, jaxa ma' lajan soc ja tz'iilel huax ilji, oj ni syajta ja yena. Jach oj sc'uluc ja jmozo. Oj ch'ac xch'ay snaajel spetzanil ja jas malo ja ba luumi, ");
INSERT INTO tojNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jaxa cristiano ja ma' mi judiouqui, oj ni aajuc snihuanil sc'ujole yuj ja jmozo jahui. Jach huax yala ja Dios ja ba slibro ja Isaías tac. ");
INSERT INTO tojNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ti iiji jan yi jun huinica. Ixtalanubal juntiro yuj ja pucuji. Tupel xa ja sati y mi xax el sc'umal. Jaxa yila ja Jesusi, ya tojbuc. Jaxa mismo ora jahui yila q'uinal soc el sc'umal huego. ");
INSERT INTO tojNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ja cristiano jumasa, ja matic ti aye ja tihui, jel och juntiro ja spensarei, ti yalahuea: ―Pero ja huinic iti, ¿jas huiniquila? ¿Mi ma jauc ja Cristo ja yintil ja rey David ba? xchiye. ―Miyuc, xchi ja tuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jaxa fariseo, yajni yabye ja jastal jahui, ti yalahuea: ―Miyuc. Es, huan ni sc'ulan mandar ja pucuj yena, pero ja' ni yip ja tan Beelzebuji ja sepeil ja tantic pucuji, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero ja Jesusi huas snaa jastal huan xta huaatzhuunuc ja sc'ujolei, ti yalaa: ―C'ulanic t'un pensar. Ja ba jun lugar, ta huan c'ax yila sbaje condra ja suinquili, mi ni lec oj ajyuca. Jachuc ja suinquil ba jun chonab ma sea jun naitz, ta huan c'ax yila sbaje condra ja suinquili, ja jastal jahui, ja' ni mero somelala. ");
INSERT INTO tojNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jaxa Satanás, ta yen ta c'a huas snutztalaan sbaje, ¿mi ma oj q'ueuc spleitoe ba? Jaxa ba huas sc'ulan mandari, oj ni jomuca. ");
INSERT INTO tojNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ja queni, huaxa hualahuex que ja' quioj ja yip ja Beelzebú, jayuj huax bob jc'ul mandar ja tantic pucuji. Iday, ¿jaxa hua mojex ba? Ja yenlei huan bi sc'ulane mandar ja pucuji. ¿Ba huax yiaje ja yipe ja yenle ba? ¡Majlayic! Soc ja hua mojex jahui, mi libre ayuquex. ");
INSERT INTO tojNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero ja queni, ja Yespíritu ja Diosi huax yaa qui ja quip ba huax c'ulan mandar ja pucuji. Naahuic xa t'usan que huan xa sc'ulajel mandar ja Dios ja ili. ");
INSERT INTO tojNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Q'uelahuil jun huinic ba jel ja yipi. Mi ni ma' oj bob och ba snaj ba oj yii ja jastic sbaji. Quechan ta huax mochji bajtan ja tzatzal huinic jahui, ti oj bob ochuc ja ba snaji. Oj ni iijuc yi ja jastic sbaji. ");
INSERT INTO tojNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ja ma' mix bob smojuconi, condra ni huax yilahuona, jaxa ma' mix bob yab ja cabali, huas somo juntiro ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ja cristiano, cuando huas slea ja smulei, chican jas tiq'ue mulalil, anima huas staa ti' malo ja Diosi, ay modo oj ni c'ulajuque perdonara. Pero ta ja' c'a huas staa ti' malo ja Espíritu Santo, ja mulal jahui, mi ni nunca oj c'ulajuque perdonara. ");
INSERT INTO tojNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ja ma' huas staahuon ti' malo ja queni, anima ti coelon jan ja ba satq'uinali, ay modo oj ni jc'ul perdonara pero ta ja' c'a ja Espíritu Santo huas staahue ti' malo, eso sí, mi oj c'ulajuque perdonar, mi ni ja huego soc mi ni ja tiempo oj to jacuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Q'uelahuil jun te' ba tzamal. Lec ni ja sat huax yaa. Mi ni modo oja hualex que ta mi lecuca. Jach ni, jun te' ba huan xa c'ael, jaxa sat huax yaa, mi xa ni lecuca. Mi ni modo oja hualex ta leca. Malan soc ja sat oja huilexi, oja naex que lec ni ja steila. ");
INSERT INTO tojNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ja huenlexi, toj chanteex. Toj malo juntiro huan yaljel ja hua c'ujolexi jayuj mi ni modo oj bob eluc jun cosa tzamal ja hua tiexa porque ja jas huax el ja ba jtiitiqui, yuj ti ni ay ja ba caltziltica. ");
INSERT INTO tojNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun cristiano ba toj ay ja yaltzili, tzamal ni ja jas huax el ja ba stia. Jach ni, jun cristiano ba mi tojuc ay ja yaltzili, toj malo ni ja jas huax el ja ba stia. ");
INSERT INTO tojNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naahuic t'usan, ja c'ac'u jau oja huaex cuenta soc ja Diosi, cada palabra ja hualahuex ba mi sbejuqui, mi oj elanic libre ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yuj ja hua tiexi oj huajanic libre ma oja huiex castigo, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ti sac'a jan chaboxe ja ma' huas seahue ja smandar ja Moisesi soc chaboxe ja fariseo jumasa: ―Maestro, jea quiticon ta ay meran ja hua huip ba, cosaque ti oj naaticon que meran ni ja' Dios secahua cona. ");
INSERT INTO tojNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ti yala ja Jesusi: ―Ja queni mi jaquelucon ba oj c'uuc yabal jun cristiano ja ma' huan xta huaatzhuunuc ja sc'ujol jmoqui. Ja jun nole ja huenlexi, ja' xta cahuan atiex oja huilex ja yip ja Diosi, pero mi ni jas oj jeejuc ahuilexa. Ja tiempo ti to ajyi ja Jonasi, eso sí, jeeji yi jun nihuan señaa, ");
INSERT INTO tojNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Como ti ni ajyi oxe c'ac'u soc oxe acual ja ba yoj slucum ja nihuan chay ja yeni. Jach ni oj cho ajyucon ja queni. Ti ni cooyon ja ba satq'uinali, pero oj ni cho ajyucon oxe c'ac'u soc oxe acual ja ba yoj luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jaxa c'ac'u oja huaahuex yi cuenta ja Diosi, ti ni oj ajyuc ja suinquil ja Ninivé, jaxa yenlei oj yaex endregal. Ja yenlei suchi ja sc'ujole ja yora loiltaji yabye yuj ja Jonasi. Iday, ja ili ay jun ma' mas nihuan que yuj ja Jonasi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jachuc ja reina jau ja ma' el jan ja ba jun najtil lugar. Huaj sc'an yi sc'ujol ja rey Salomoni, iday el jan ba jun najtil lugar lec. Ti ni oj ajyuc ja reina jau cuando oja huaahuex yi cuenta ja Diosi. Ja yeni oj ni yaex endregala. Iday, ja ili ay jun ma' mas nihuan que yuj ja rey Salomoni. ");
INSERT INTO tojNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Q'uelahuil jun pucuj. Huax yaa can jun huinic. Ti huax huaj ba jun taquin lugar, jaxa tihui, c'atan xta ay eq'ue. Mix yila ora ba oj staa ja sijlubi, pero meyuc. ");
INSERT INTO tojNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ti yalaa: Oj ma cumxucon soc ja huinic ja it caa cani, xchi. Ti xa cumxia. Jaxa c'oti, ti ni ay puesto ja huinica. Chapan ay lec ja yaltzili. Tola vida huan smajlajel. ");
INSERT INTO tojNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jaxa pucuji ti huaja. Huaj yii jan otro juque ja smoj pucujili, pero mas to pegor ja jucuane jahui que soc ja yeni. Ti ochye culan ja bay ja huinic jahui. Jaxa pobre huiniqui, mas to pegor huaji. Mas lec ay ja jastal ajyi. Jach ni ja jun lame cristiano iti, jach ni mero oj huajuquea, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yutzil huan to loil soc ja cristiano jumasa cuando och c'ot ja snani soc ja yermano jumasa. Huas sc'ana oj c'umajuc yuj ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ja Jesusi ti alji yaba: ―Q'uelahuile, ja hua nani soc ja huermano jumasa, ti aye ba fuera. Huas sc'ana oj sc'umuca, x'utji ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ti yalaa: ―¿Jas bi la chi? ¿Machunc'a ja jnan ba? ¿Machunc'a ja quermano ba? ");
INSERT INTO tojNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ja nebuman ja it tey ba jtz'eeli, ja' ni jnana y ja' ni quermano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porque chican ja ma' huas sc'uan ja jTat tey ba satq'uinali, ja yeni ja' quermano soc ja' quermana soc ja' jnani, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jun c'ac'u ja Jesusi el ja ba snaji, ti huaj culan ja ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ti jac botz'an sbaj jitzan ja cristiano. Jaxa yila jel huan stzomjel sbaj ja cristiano, ti xa q'ue ba jun barco. Ti och culan ja tihui, jaxa cristiano ti ch'ac canuque q'uelan ja ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jaxa Jesusi ti och see yi ja cristiano, pero soc jun loil sea: ―Q'uelahuilex. Jun huinic huaj ba oj stic ja inati. ");
INSERT INTO tojNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jaxa cuando huan sticjeli, ay ba co ba yoj bej. Pero iday, ti jac ja yalchan jumasa. Ti stuluhue ela. ");
INSERT INTO tojNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jaxa tuqui, ti co ba yoj ton ja ba mey lec ja luumi, jaxa tihui, huego eli como jel t'usan ja luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero iday, cuando el q'uen ja c'ac'u, huego cho tacji porque mey yech. Huego c'oxbi ja spoohuili. ");
INSERT INTO tojNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jaxa tuc inati ti co ja ba yoj q'uiix. Jaxa tihui, cho q'ui ja q'uiixi, jaxa inati, c'utzji sq'uiel. ");
INSERT INTO tojNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jaxa tuqui ti co ba lequil luum. Jun nihuan alaj ajyi. Ja jun sat inati ya pojxuc cien, jaxa otro juni, sesenta, jaxa otro juni, treinta. ");
INSERT INTO tojNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ja ma' ay xchiquini, a yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ti yala ja snebumani: ―Pero Cajual, ¿jasyuj quechan jun loil huaxa jea yi ja cristiano iti? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","―Q'uelahuilex, ja huenlexi tzaubalex ba oja huabyex slugaril ja jastal jel tzamal cuando huas sc'ulan mandar ja yen ja ma' tey ba satq'uinali. Ja ajyi, ch'aban ti' abal ay ja iti. Eso sí, ja jas huax cala, mi ni clarouca, jayuj mi ni cualquierauc ja ma' oj yab slugarili. ");
INSERT INTO tojNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pero ja ma' huas sc'ulan seguir sbaj, oj ni aajuc sna masa. Jel ni vivo oj ajyuca. Pero ja ma' mi huas sc'ulan seguir sbaji, ja janec' huas snaa, oj ni ch'ay sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jayuj huax ca slaj jun loil. Eso sí, ja cristiano jumasa ay sate pero lajan soc mix yilahue q'uinal. Ay xchiquine pero lajan soc mix yabye q'uinal porque mix yabye slugaril. ");
INSERT INTO tojNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Meran ni ja jas yala ja Isaías ja najatei: Ja huenlexi, tola vida huanex yabjel ja yabal ja Diosi pero mi xa huabyex slugaril. Tey ja hua satexi, pero mix yila q'uinal. ");
INSERT INTO tojNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ja cristiano iti, jel ch'uuy ja sc'ujolei. Ja xchiquinei, lajan soc huan xa tupel, jaxa satei, mutz'an xa juntiro. Pero sganae. Moc to jach huas sc'ulane, oj ni jamxuc ja satea. Oj ni yabye sbeja, oj ni can sc'ujolea. Ay modo oj ni suchuc ja sc'ujolea, jaxa queni, oj ni ca tojbuque ajyia. Jach ni yala ja Isaías tac. ");
INSERT INTO tojNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero ja huenlex cuntiquil, jel lec xa huilahuex. Ja hua satexi huan nix yila q'uinala, jaxa hua chiquinexi, huan nix yab q'uinala. ");
INSERT INTO tojNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pero meran huax cala. Q'uelahuil ja aluman‑Dios ba najatei. Jach ni jitzan ja ma' toj ni ayi, jel sgusto oj yile ja jas huanex yiljel ja huenlexi, pero mi ni yilahuea. Jel sgustoe oj yabye ja jas huanex yabjel ja huenlexi, pero mi ni yabyea. ");
INSERT INTO tojNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Abyic. Oj cala huabyex jas sbej ja loil it sbaj ja ma' huaj stic ja inati. ");
INSERT INTO tojNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ta ay c'a ma' huax yab ja yabal ja ma' jel tzamal huax c'ulhuani mandar, ja ma' tey ba satq'uinali, pero ta mi c'ax yab sbej, huego huax jac ja diablo. Huax jac sap yi ja jas ti ni ay ja ba sc'ujoli. Ja sc'ujol ja cristiano iti, ja' ni smoj ja inat it co ja ba yoj beji. ");
INSERT INTO tojNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jaxa cristiano ja ma' jel huego huax yaa sbaji, jel gusto huax yab ja yabali, ja sc'ujol ja yenlei, ja' ni smoj ja inat it co ja ba yoj toni, ");
INSERT INTO tojNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero lom nia. Huaj to cho ilxuc, cho lolaji ta. Huan c'ax jac ja huocoli, ta ay ma' huas sc'ulan burla yuj ja yabal ja Diosi, huego huas scomo sbaj. ");
INSERT INTO tojNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jaxa cristiano ja ma' huax yab ja yabal ja Diosi, pero yuj ja jas ay ja ba mundo, huax aaji ch'ay sc'ujole. Huax lolaji yuj. Ja sc'ujol ja cristiano jahui, ja' ni smoj ja inat it co ja ba yoj q'uiixi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero ja cristiano ja ma' huax yab sbej ja yabal ja Diosi, huan ni stucbes meran ja smodoa. Ja' ni huajel sc'ujole oj yaa yi ja smoj ja ba jel tzamali. Ja yenlei, lajane soc ja inat it co ja ba lequil luumi. Ay ba oj ya pojxuc cien, ay ba oj ya pojxuc sesenta, soc ay ba quechan treinta oj ya pojxuc. Ja sc'ujol ja cristiano jahui, ja' ni smoj ja lequil inati. ");
INSERT INTO tojNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ja Jesusi ti cho yala otro loila: ―Oj cala huabyex jun loil jastal ayex ja ili cuando ti xa mandar ayex yuj ja ma' tey ba satq'uinali. Lajan soc jun huinic huax huaj stz'un ja yalaji pero ja yintil ja yalaji, puro tzamal. ");
INSERT INTO tojNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero iday, cuando huane huayeli, ti huax jac ja scondra ja ajualali. Ti huax jac stz'un can jun c'ul ba malo leca, pero ti ba mero yojol ja trigo. Ti xa huaja. ");
INSERT INTO tojNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jaxa trigo eli. Q'uii. Yaa sat. Ti chicnaji ja c'ul jahua ja cuando satini ja trigo. ");
INSERT INTO tojNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jaxa smozo ja ajualali ti jacyea. Jac yal yab ja yajualei: Cajual, ¿mi ma lequil inatuc ja huaa quiticon ba oj tz'unticon ja ba hua hualaji? ¿Pe jastal ay ba? Pe tey jun c'ul ba jel tuc tac, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","―¡Seguro ja' jcondra jac yaa can ja c'ul iti! xchi ja ajualali. ―Entonces ¿jasunc'a huaxa c'ana oj c'ulticon yii? ¿Oj ma huaj jotzticon ja c'ul jau ba? xchi ja mozo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","―Miyuc. Repente oja jotzex ja trigo cuando huanex sotzjel ja c'uli. ");
INSERT INTO tojNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mas lec, a canuc masan to stiempo ja jach'oji. Oj cal yab ja jach'ulumi a stzome bajtan ja c'uli. A sc'ul manoja ba oj jipxuc yoj c'ac'. Ti oj stzome tzaan ja trigo, entonces ti oj ya ochuque ba yoj jrancho, xchi ja ajualali. Jach huaj ja loil jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ti cho yala otro jun loil ja Jesusi: ―Q'uelahuil ja huenlexi, ja matic mandar xa ayex yuj ja ma' tey ba satq'uinali. T'usan oj q'ueanic pero oj jitzanbananic lec como jastal ja sbac' ja mostaza. ");
INSERT INTO tojNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Porque jun sbac' mostaza, jel ch'in juntiro. Mey otro inat ja jastal jahui. Pero iday, jun jabil mi ma' oj sc'oc ja sc'abi, huaj to iljuc, pojxi ta lec ja jun yal sbac' jahui. Hasta ja yalchani oj bob sc'uluc ja soj ja ba pimi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ja Jesusi ti cho yala otro jun loila: ―Q'uelahuil ja huenlexi, ja matic mandar xa ayex yuj ja ma' tey ba satq'uinali. T'usan oj q'ueanic pero oj jitzanbananic lec como jastal ja slevadurail ja pani. Jun c'ulapan huax yiaj t'usan altiro ja levadura, ti huax ya och socan soc oxe medida harina. Huaj to yile, ja yarina, pojxi ta lec. Q'ui ta, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Spetzanil ja jas sea ja Jesusi, ja' huax ya slaj jun loil. Mi ni toj juntiro yalaa, jayuj huax ya slaj sbaj soc jun loil. ");
INSERT INTO tojNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jachuc, c'ot ni smeranil ja jas yala ja aluman‑Dios ja najatei: Oj cala huabyex t'usan, pero oj ca slaj sbaj soc jun loil. Ja' oj cala huabyex ja jas nac'an musan to ay ajyi Masan cujlaji ja satq'uinali, mi ni huax chicnaji leca. Jachuc, c'ot ni smeranil ja jas yala ja aluman‑Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ja Jesusi ti spila sbaj soc ja cristiano. Ti och ba jun naitz, jaxa snebumani ti jac jobjuc yia: ―Ala cabticon ba, ¿jas sbej ja loil it huaxa huala cabticon ja c'ul it q'ui ba yoj yalajil ja trigo? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ti yala ja Jesusi: ―Ja ma' huas stz'unu ja lequil inati, quena nia, como ti ni coelon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jaxa yalajil ja trigo, ja' ni spetzanil ja cristiano ja ba luumi. Jaxa lequil inati, ja' ni ja ma' mandar ay yuj ja Diosi. Jaxa c'uli, ja' ni ja ma' mandar ay yuj ja yen ja ma' jel malo. ");
INSERT INTO tojNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jaxa jcondratic ja ma' stz'unu can ja c'uli, ja' ni ja diablo. Jaxa stiempo ja jach'oji, ja' ni ja jas ora oj c'ot tic'an ja tiempo. Jaxa jach'ulumi, ja' ni ja ángel jumasa ja smozo ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ja jastal cala que oj tzomxuc ja c'ul jau malo, oj jipxuc yoj c'ac', jach ni oj c'ot smeranil soc ja matic tey ba sc'ab ja diablo. Oj jipjuque ba yoj c'ac' ja ora jau oj ni c'ot tic'an ja tiempo. ");
INSERT INTO tojNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Oj ni jac ja cangel jumasa, como ti ni coelon jan ja ba satq'uinali. Jaxa ba huax c'ulan mandari, ja ángel jumasa oj ni ch'ac spil can ja matic huas sc'oco ja mandari soc ja ma' huas somo ja lugari. ");
INSERT INTO tojNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ti ni oj ch'ac jipjuque yuj ja ángel ba yojol ja nihuan c'ac' jahui. Ja tihui jel oj ajyuc ja oq'ueli. Oj ni sc'ux ja yejea. ");
INSERT INTO tojNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero ja ma' toj ay soc ja mandari, oj ni bi lijpuquea ja ba sti sat ja Dios Tatal ja ba lugar jau ja ba huas sc'ulan mandari. Ja ma' ay xchiquin, a yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ja Jesusi, otro vuelta yala jun loil: ―Huan ni xa naahuex mey otro mas tzamal yuj ja jastal mandar xa ni ayex yuj ja ma' tey ba satq'uinali. Ja jastal iti, lajanex soc jun huinic it staa jun cosa ba jitzan lec ja svale, ti huaj smuc cana. Jel gustoaxi juntiro, jayuj huaj xchon can spetzanil ja jas yioji siquiera ba oj sman ja pedazo luum ja ba smucu cani. ");
INSERT INTO tojNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","―Meran nia. Jel lec juntiro ja ti xa mandar ayex yuj ja ma' tey ba satq'uinali. Lajanex soc jun comerciante ja ma' ja' snegocio ja xchonjel ja ujal ba jel ja stz'acoli. ");
INSERT INTO tojNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jun c'ac'u ti yila jun perla ba huax lijpi, pero jel ja stz'acoli. Ti yalaa: Oj huaj chon can spetzanil ja jas quioji siquiera oj taa ja stz'acol ja perla iti, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","―Jachuc ja huenlex ja matic meran mandar xa ni ayex yuj ja ma' tey ba satq'uinali. Pero ay ma' mi ni jachucuc aya. Q'uelahuil jun enub ba huax yamxi ja chayi. Huax jipxi ba yoj ja', ti huax och ja chayi, tuctuquil tiq'ueil. ");
INSERT INTO tojNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Cuando huax but' ja enubi, huax licji el ja ba sti ja jai, jaxa tihui, huax aaji och ba mooch ja lequil chayi, jaxa ba mi lec sc'uxjeli, huax jipji ele. ");
INSERT INTO tojNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jach ni oj c'ulajuc ja cuando huax c'ot tic'an ja tiempo. Oj jac ja ángel jumasa. Oj ch'ac spil can ja ma' malo soc ja ma' toj ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jaxa ma' malo, ti ni oj jipjuque ja ba yoj c'aq'ui. Ja tihui jel ja oq'ueli. Oj ni sc'ux ja yejea. ");
INSERT INTO tojNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","―¿Ja huabyex ama sbej spetzanil ja loil iti? ―Cabticon, xchi ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ti yala ja Jesusi: ―Q'uelahuil jun ajualal. Ja ba yoj snaji ay ba yajc'achil ja sastic sbaji, cho ay ba poco. Huax maconi yujil spetzanil, sea yajch'achil, sea poco. Jachuc, ja ma' huas sea sbaj soc ja smoji jastal oj yaa sbaje ba sc'ab ja Dios tey ba satq'uinali. Ja jas huas snaa, sea najate yilunej, ma yajc'achil, oj ni maconuc spetzanila. ");
INSERT INTO tojNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ja Jesusi, ja jastal ch'ac yal can ja loil iti, ti xa spila sbaj ja tihua. ");
INSERT INTO tojNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ti huaj ja ba mero xchonabili. Ti och ja ba yiglesia ja judio ja tihui ba oj see yi ja cristiano. Pero ja cristiano, jom juntiro ja s'olomei. Ti yalahuea: ―¿Jastal ay ja iti? ¿Ba yiaj ja svivoili? ¿Ba yiaj ja yip ba? ¡Pe huax bob sc'ul milagro tac! ");
INSERT INTO tojNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Pero ¡ja' yunin ja tan carpintero tac! jaxa snani, ¡ja' ni ja men María! Jaxa yermano, ja' ni ja tan Santiago soc ja tan José soc ja tan Simón soc ja tan Judasi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jaxa yermana ixuque ba, ¿mi ma teyuque il ba? ¿Ma' aaji sneb yuj ja jas huax bob sc'uluqui? xchiye ja suinquil ja xchonabil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Malan soc ja loil jahui, juntiro boboaxiye, jayuj ja cristiano mi mero sgustouque. Ti yala ja Jesusi: ―Pe jach ni ja aluman‑Dios jumasa tac. Jel gusto iljiye ja ba otro lugari pero ja ba mero xchonabilei, soc ja ba yoj snajei, jel ch'in iljiye, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jayujil mi ni sc'ulan milagro ja ba xchonabili porque ja cristiano mi ni t'un huas sc'uanea. ");
INSERT INTO tojNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ja rey Herodesi ja ma' ay yatel ja tiempo jahui, ti ch'ac yab yabalil ja jas huan sc'ulajel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ti yal yab ja smozo jumasaa: ―Ja huinic jahui, seguro ja' tan Juan it ma' huax yaa bautismo ajyi. Eso sí, cham ta nia pero seguro sacui ta ja huego, jayuj huax bob sc'ul milagro, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Como ja rey Herodesi, ay ni smula yuj ja slea smul soc ja ixuc Herodíasi ja xcheum ja yijtz'in Felipe. Jaxa Juani ti yalaa: ―Pero ja ixuc jahui, mi sbejuc ja jastal aya soqui, x'utji ja rey Herodesi. Yajni alji yab claro jastal ay soc ja ixuc jahui, ti syama ja Juani. Aaji och preso. Mochji can soc jun cadena pero ja' ta ni smulan yuj ja yala ja smul soc ja ixuc jau Herodíasi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jaxa rey Herodesi yala que oj xch'ay snaajel pero huax xiu yuj ja cristiano porque huax yalahue que aluman‑Dios bi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ti xa ajyi jun sq'uinil ja rey Herodesi. Jaxa ba q'uin jahui, chaani ja yal ja ixuc Herodíasi. Jel gusto juntiro yila ja rey Herodesi, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","―Xila Dios, oj ni caa yi ja jas huas sc'ana quii, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jaxa aq'uixi ti huaj sc'an sc'ujol ja men snani. Ti yala ja snani: ―Pues c'ana yi a sec jan ba jun plato ja s'olom ja tan Juan it huax yaa bautismo, xchi ja snan Herodíasi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jaxa yab ja rey Herodesi, jel tristeaxi pero como jel ja testigo yab ja jas yala, ");
INSERT INTO tojNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jayuj ti seca suinquili: ―Caxic ni. Cax c'utzuhuic jan ja s'olom ja tan Juan it tey ba preso, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ti huajyea. Ti spachahue jan ba jun plato ja s'olomi. Yaahue yi ja aq'uixi, jaxa yeni ti yaa yi ja snani. ");
INSERT INTO tojNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jaxa snebuman ja Juani ti jacyea. Jac stule ja scuerpo, ti smucuhuea. Ti huaj yale yab ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Cuando yab ja Jesusi, ti q'ue jun barcoa. Spila sbaj, ti huaj ba jun ch'ayan lugar, stuch'il. Pero iday, cuando yab ja cristiano, ti ch'ac huajuque nochana. Soc yoque ch'ac eluque ba xchonabilei. ");
INSERT INTO tojNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huaj to yil ja Jesusi, ti xa aye jun nole cristiano. Ti stalna syaujulal ja Jesusi, jayuj ch'ac ya tojbuc ja ma' malo ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Cuando mojan oj xa mucxuc ja c'ac'u, ti jac ja snebumani. Ti yalahuea: ―Ja lugar iti jel ch'ayan juntiro soc och ta c'ac'u. Jeca xa huego ja cristiano ba oj stae ja hacienda jumasa. Ja tihui oj stae manjel ja jas oj yabyei, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","―Pero ¿jas yatel oj huajuque? Aahuic yi ja suael ja huenlexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","―Pero Cajual, quechan joe pan quiojtic tac, soc chab ala chay, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","―Pues iajic jan qui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ti yal yab ja cristiano ba oj ochuque culan ja ba yoj jobi. Ti yiaj ja joe pani soc ja chab chayi, ti sq'uela ja satq'uinali. Ti sc'ulan bendiciar ja huaelal jahui. Ti yiaj ja pani, ti spilaa. Yaa yi ja snebumani, jaxa snebumani ya ec' yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jaxa cristiano ti huaayea. But'iye lec. Ti stuluhue ja jas can sobra, iday, soc ja sobra pan jahui, sbut'uhue lajchahue mooch. ");
INSERT INTO tojNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iday, joe mil ja huinique ja ma' huai. Pilan ja ixuquei, cho ay yal untic. ");
INSERT INTO tojNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ja Jesusi ti sc'ulan mandar ja snebumani que oj huajuque soc barco ja ba otro lado ja jai, jaxa yeni, tzaan to bi oj huajuc. Jaxa cristiano ti seca ja ba snajei. ");
INSERT INTO tojNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Cuando ch'ac sequi, ti huaj ba jun huitz ja yeni. Huaj sc'umuc ja Diosi. Ti xa mucxi ja c'ac'u, jaxa yeni, stuch'il. ");
INSERT INTO tojNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pero ja barco, najat ay soc ja sti jai. Huan ixtalajel juntiro ja ba yoj jai porque ja iq'ui ti jacum ja ba lado huajum ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cuando mojan xa ja yoxil gallo, ja Jesusi ti huajum ja bay ja snebumani, pero ti huan bejyel ba sat ja'. ");
INSERT INTO tojNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jaxa snebuman jumasa, cuando yilahue ay ma' huan bejyel jani, ti jel xiuye juntiroa: ―¡Pero mi ma altzilaluc ja jahui! xchiye, pero ti och ahuanuque yuj ja xihuelei. ");
INSERT INTO tojNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ja Jesusi ti c'umani huegoa: ―Tzatzal c'ujolana bajex. Ch'abananic soc ja hua xihuelexi. Quena nia. Mi lom la xiuyex, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ti yala ja Pedro: ―Cajual, ta meran c'a huena ni, aa hua mandari. Oj huaj taa jani. A cho bejyucon ja quen ja ba sat ja jai, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Lec, coan ba. La, xchi ja Jesusi. Jaxa Pedro ti el ja ba barco. Och ja ba yoj jai. Ti stojo och ja ba huan jaquel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cuando ti xa huan bejyel ja ba sat jai, jun ta repente jac xihuel yuj ja iq'ui, ti sulji coa. ―Cajual, coltayon, xchi, pero ahuanel. ");
INSERT INTO tojNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jaxa Jesusi, huego xija ja sc'abi. Syama. ―¿Yuj ama mi ni t'usan huaxa c'uan ba? ¿Jas lom huan xta c'umal ja hua c'ujoli? x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cuando q'ueye ja ba barco, ti ch'abaji ja iq'ui, ");
INSERT INTO tojNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jaxa matic tey ba yoj barco ti cooye mec'ana: ―Meran lec que huena ni yunina Diosa, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cuando elye c'ot ja ba otro lado ja jai, ti ba jun lugar sbiil Genesaret, ");
INSERT INTO tojNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jaxa suinquil ja lugar jahui, huego snaahue que ja' ni ja Jesusi. Ch'ac seque spayjel ba oj ch'ac yii jan ja matic malo ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Sc'anahue yi stz'acatal ja Jesusi siquiera oj yamjuc yi ja snich ja sc'ui, jaxa matic ch'ac syami, ch'ac ni tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ti jac chaboxe fariseo soc chavoxe ja ma' huas sea ja smandar ja Moisesi. Ti culane ja ba Jerusaleni pero jac ba oj sc'umuque ja Jesusi: ");
INSERT INTO tojNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Jastal ay ba? Pero ja hua nebuman jumasa mi ni sbejuc ja jastal huas sac'ahue ja sc'abe cuando oj xa huauque porque ¡mi ni sbejuc huas sc'ocohue ja scostumbre ja banquilal jumasa, xchi ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ti yala ja Jesusi: ―Jaxa huenlex ba, ¡pe pegor ja jas huaxa c'ulanex tac! Eso sí, ja costumbre, jel nihuan ahuiojex pero ja sley ja Diosi, ja' huaxa c'ocohuex. ");
INSERT INTO tojNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porque ja Diosi huax yala que oj yajtatic ja jnan jtatiqui, jaxa ma' huax c'umani malo soc ja snan stati, oj ni aajuc ch'ay snaajela. ");
INSERT INTO tojNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero ja huenlexi, tuc ja jas huajel ac'ujolexi: ―Naney, tatey, eso sí, huax c'ana jcoltayex nique ajyi, pero spetzanil ja jas quioji, naca caunej yi ja Diosi, huaxa huutaj ja hua nan atatexi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yuj ja jastal huaxa hualahuex ja jastal jahui, ¿yuj ama ja' ti oj elanic libre ja huaxa hualahuexi? Ja jastal jahui, huaxa hualahuex que lom juntiro ja yabal ja Diosi, que mas jel t'ilan ja hua costumbreexi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ja huenlexi, ¡toj chab cara ayex juntiro! Ja huenlex nia ja staahuex ti' ja Diosi ja ba slibro ja aluman‑Dios Isaiasi: ");
INSERT INTO tojNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ja cristiano, ja stiei huas sea sbaje que huas syajtayone, pero ja sc'ujolei, najat yiojone juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lom ni juntiro huax cooye mec'an ja ba sti jsata, jaxa jas huax el ja ba s'olom ja cristiano, ja' huas seahue que ja' bi ja yabal ja Diosi, como jach ni yala ja Isaiasi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ja Jesusi ti spaya jan ja cristiano, ti yalaa: ―Abyic t'un sbej ja iti. ");
INSERT INTO tojNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mi jauc ja jas huax och ja ba hua tiexi, ja' oj jomanic yuj. Ja jas huax el ja ba hua tiexi, ja' mero huas somohuex, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ti jac ja snebumani, ti yalahuea: ―Pero ja fariseo jumasa, jel coraja aye yuj ja yabye ja hua huala jastal jahui, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","―Ja yenlei, como mi ni cuenta ayuque soc ja Tatal Diosi, oj ni aajuc ch'ay snaajelea. ");
INSERT INTO tojNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","―¡Actayic can ja jau jumasa! Mutz'an ni ja satea pero iday, huane seejel yi sbej ja ma' cho tupel ja satei. Jun huinic, ta tupel c'a ja sati, huas sea yi ja sbej ja smoj tupel satili, ¿mi ma xchahuaniluque oj moc'uque ba yoj q'ueen ba? ¿Mi ma meranuc ja jastal jau ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","―Pero ¿jasyuj ja quechan loil huaxa huala cabticon ba? ¿Jaxa mi xa huala cabticon claro? xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","―Jaxa huenlex ba, ¿yuj ama mi huaxa naahuex jastal aye ba? ");
INSERT INTO tojNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Spetzanil ja jas huax och ja ba jtiitiqui, toj eq'uel huax huaji. Jaxa jahui, ¿mi ma xa naahuex ba? ");
INSERT INTO tojNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ja jas huax yala ja jc'ujoltiqui, jach ni huax el ja ba jtiitica. Ja jahui, eso sí, huas somo ja hua hualtzilexi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ja hua pensarex ba malo, yuj ti ni ay ba ja hua c'ujolexa. Jachuc ja milhuaneli, soc ja sleejel ja tuc ixuquei, sleejel ja tuc huiniquei, spetzanil ja ma' lajan soc chante ja spensarei. Jach ni ay ja sc'ujolea. Jachuc ja elc'aneli soc ja sleejel ja smul ja hua moji, gana huaxa tzica jun ja hua moji. Spetzanil ja mulal iti, ti huax el ja ba sc'ujol ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ja pecado jumasa iti, ja' ni huas somo ja cristiano. ¡Vaya, ja sacjel ja c'abal yen, mi ni jas yioja! ");
INSERT INTO tojNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ja Jesusi ti el ja tihui. Ti huaj ja ba lugar ba mojan ja chonab Tiro soc ja chonab Sidoni. ");
INSERT INTO tojNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ti jac jun ixuc suinquil ja lugar jahui. Cananera nia. Ti c'umani tzatz leca: ―Ay Cajual, huena ni ja yintila rey Davidi, jayuj talna jyaal. Ja cala aq'uixi, ixta juntiro huax ilji yuj ja tan pucuji, xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ja Jesusi, c'an ta yabi mi yabi. Ti jac ja snebuman jumasa. Jac aljuc yabi que oj sec ele: ―Jeca ele porque quechan lom huax yahuayotic. Pero huahuanto xta huane yaljel ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pero ja Jesusi ti yal yab ja ixuc jahui: ―Ja queni jecubalon ba oj lee ja ch'ayel chej jumasa pero quechan ja sbaj ja israeleño jumasa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jaxa ixuqui stela ja sc'abi, ti sc'ana yi lec pavor: ―Pero Cajual, coltayon, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","―Pero mi ni sbejuc oj japxuc yi ja suael ja yal untiqui ba oj aaxuc yi ja ma' mix naaxi sbaji, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","―Eso sí, meran ni Cajual. Pero q'uelahuil jun ula. Huax jac ja ba jun naitz. Anima jauc ja sobra, oj ni aajuc yia ja ula jahui, xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","―Ay nana, ¡jel lec huaxa huila porque jel huaxa c'uan! Ja jas huaxa c'ana, oj ni c'ulajuc ahuia, xchi ja Jesusi, jaxa yal aq'uix ja ma' jel malo ayi, huego tojbi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ja Jesusi ti el ja tihui. Ja cuando ec' ja ba sti ja ja' ba Galilea, ti q'ue jun huitza. Och culan ja tihui, ");
INSERT INTO tojNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jaxa cristiano, lom xta xnololi ch'ac jacuque. Ti iiji jan yi ja ma' renco ayi, ja ma' mix bob bejyuqui, soc ja ma' tupel ja sati, soc ja ma' mix el ja sc'umali, soc jel jitzan ja matic yioj tuctuquil tiq'ue chameli. Ti ch'ac aajuc yi endregal ja ba sti sati, jaxa Jesusi ch'ac ya tojbuque spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jaxa cristiano, jel och ja spensare cuando yilahue huan xax el sc'umal ja matic mix c'umani ajyi, jaxa renco jumasa, toj xa huax bejyiye. Chican jas spaltail ja yoc sc'abei, ch'ac tojbuque. Jaxa ma' tupel ja satei, ch'ac yile q'uinal. Yaahue yi stz'acatal ja sDios ja israeleño jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ja Jesusi ti spaya jan ja snebuman jumasa, ti yalaa: ―¡Jel ajul ja sbaj ja cristiano jumasa! Ay xa oxe c'ac'u ti aye jmoctic ja ili pero mi jas yioje ja jas oj yabyei. Mix c'ana oj jeque cuando huain xyabyei. Lom oj ch'ac yipe ja ba beji, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jaxa snebumani ti yalahuea: ―Pero ¿ba oj quiitic ja pan ba oj caatic huauc jun nole cristiano jastal iti? Ja iti, oj sc'an jun montón ja pani, pero ¡jun ch'ayan lugar aytic tac! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―¿Jaye to ja pan quiojtic ba? xchi ja Jesusi. ―Quechan xta juque soc chaboxe yal chay, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ti yal yab ja cristiano ba oj ochuque culan ja ba luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ti yiaj ja juque pani soc ja chayi. Yaa yi stz'acatal ja Diosi, ti spila yi ja snebumani, jaxa snebuman jumasa, ch'ac xchol yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jaxa cristiano ti och huauquea. But'iye lec. Ti ch'ac stzome ja jas ch'ac can sobra, iday, cho but' otro juque mooch, pero huosan lec. ");
INSERT INTO tojNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iday, ¡chane mil huinic ja matic ch'ac huauquei! Pilan ja ixuquei soc ja yal untiqui. ");
INSERT INTO tojNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ja Jesusi ti spila sbaj soc ja cristiano. Q'ue jun barco, ti huaj ba jun lugar sbiil Magdala. ");
INSERT INTO tojNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ti jacye ja fariseo jumasa. Cho jac otro cristiano saduceo sbiil ja spartida ja yenlei. Jac sc'uluque probar ja Jesusi: ―Jea quiticon jun seña ba oj quilticon ta ay meran ahuipi pero jea quiticon ja ba satq'uinal chomajquili, ti oj naaticon que Dios secahua cona, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ti yala ja Jesusi: ―Ja huenlexi cuando huaxa huilahuex huax chacbi ja satq'uinali ja cuando huax och ja c'ac'u, ti huaxa hualahuexa: Ja jecheli leman oj ajyuc ja c'ac'u, la chiyex. ");
INSERT INTO tojNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Pero ta jel c'a chac ja c'ac'u huax el jani, ti huaxa hualahuex que: Ja yaani oj jac jun tzatzal ic', la chiyex. Huala c'umaniyex, como ay atiex, como huan ni xa naahuex jastal ja seña ja satq'uinali. Eso sí, huan ni xa naahuex yena pero iday, ja jas jel nihuan huanex yiljel ja tiempo jumasa iti, mi ni t'usan huaxa naahuex jas sbeja. ");
INSERT INTO tojNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ja' mero cahuan atiex ba oja huilex ta meran ac'ubal quip yuj ja Diosi pero como jel maloex. Mi ni t'un huax oc' ac'ujolex ja Dios ja huenlexi. Pero mi ni jun seña oj jeejuc ahuilex, quechan ja seña ja Jonasi, eso sí, oj ni ahuilexa, xchi ja Jesusi. Ti xa spila sbaja. Huaji. ");
INSERT INTO tojNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jaxa snebuman jumasa ja Jesusi ti ec' sc'utze jan ja jaa. Iday, ch'ay sc'ujol ja spanei. ");
INSERT INTO tojNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ti yala ja Jesusi: ―C'ulanic t'un pensar. Aa cuidadoex soc ja slevadura ja fariseo soc ja saduceo, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pero ja snebuman jumasa ti yalahue yenle itaa: ―Jach huax yala porque mi quiajtic jan ja pani, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ja Jesusi huas snaa jasunc'a huane yaljeli: ―Ja huenlexi lajan soc mi jas huaxa naahuex. Ja' huajel ja hua c'ujolex ja hua panex ja mi anaahuexi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Bob ta mi ahuabyex sbej. ¿Mi ni ma t'un huaxa naahuex jastal huaj ja joe pan jahui soc ja ma' huaa joe mili? ¿Ch'ay ama c'ujolex jaye nihuac mooch atuluhuex ja sobra ja pan jau ba? ");
INSERT INTO tojNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jaxa juque pani soc ja chane mil ja ma' huaa ja c'ac'u jahui soc ja jaye mooch ja tuluhuexi, ¿mi ma xa naahuex ba? ");
INSERT INTO tojNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mi jauc huax c'ulan pensar ja hua panexi. Abyic q'uinal. Aa cuidadoex soc ja slevadura ja fariseo soc ja saduceo, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Soc ja jahui, ti xa jac sc'ujole que mi jauc huax taaji ti' ja spanei, pero ja' ni huax taaji ti' ja jas huas sea ja fariseo soc ja saduceo, que oj bi yaa scuidadoe soc ja jas huane seejeli. Ja' bi smoj ja slevadurail ja pani. ");
INSERT INTO tojNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ja Jesusi ti huaj ba jun lugar sbiil Cesarea Filipo. Ti sobo yi ja snebumani: ―Ja queni ti coelon jan ja ba satq'uinali, pero ja cristiano, ¿jasunc'a huax yalahue jbaj ba? ");
INSERT INTO tojNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ti sac'a jan ja snebumani: ―Ay ma' huax yala que ja huena ni ja Juani ja ma' huax yaa bautismo ajyi. Jaxa tuqui huax yala que Eliasa, jaxa otro c'olei huax yala que Jeremiasa, ma junuc ja aluman‑Diosi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ti yala ja Jesusi: ―Jaxa huenlexi, ¿machunquilon huaxa hualahuex ja huenlexi? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","―Pues huena ni ja Cristoa tac, yunina ja Dios sac'an lequi, xchi ja Simón Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","―A Simón, jaxa hueni, ja' ni atat ja Jonasi pero iday, mi ni ma' yala oja hual cab ja jastal iti. Ja' ya jac ja hua c'ujol ja jTat tey ba satq'uinali. ¡Jel lec huaxa huila! ");
INSERT INTO tojNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Como ahuala ni cab que quena ni ja Cristooni, que yuninon ja Diosa. Soc ja iti, jitzan ni lec ja ma' oj sc'uuconi, y oj ni cuntiquiluquea, jaxa yenlei, mi ni oj bob c'ulajuque ganar, anima huax jac spetzanil ja yip ja diablo. Jaxa huen Simón, ja yaani, Pedro xa ni ja hua biili. Tzatz ni lec oj ajyana jastal jun te' tz'unan lec. ");
INSERT INTO tojNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja huen oja poj ja beji y ti oj huaj nochan ja ma' oj yii ja sbej ja Diosi. Ja hueni oj canan como jastal jloc'ol ja ba luumi. Ja jas huaxa huila mi lec huas sc'ulan ja cristiano, jach ni oj cho yil ja ma' huas sc'ulan mandar ja ba satq'uinali. Y ja jas huaxa huala ba lequi, lec ni oj cho yil ja ma' huas sc'ulan mandar ja ba satq'uinali, x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ja Jesusi ti xa yal yab ja snebuman jumasa que mi bi ma' oj yal yab ta yen bi ja Cristo ja ma' tzaubal yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde ja tiempo jahui, ja Jesucristo q'ue see yi ja snebuman jumasa que t'ilan bi oj huaj ba Jerusaleni. Oj bi cho aajuc yi jitzan huocol yuj ja banquilal jumasa soc ja nihuac spagre ja judio jumasa soc ja matic huas sea ja smandar ja Moisesi. Oj bi miljuc pero ba yoxil c'ac'u, oj ni bi sac‑huuca. ");
INSERT INTO tojNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jaxa Pedro ti spaya el pilan ja Jesusi, ti och yal yaba: ―Cajual, sc'an to Dios, miyuc. Mi oj bobuc ahuuj ja jachuqui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ti yala ja Jesusi: ―Elan ja ba jtz'eeli. Lajan soc ja' spalabra ja Satanás huaxa huala cabi. Ja hueni quechan ba huax jac acomon. Ja' huajel ac'ujol juntiro soc ja jastal ja spensar ja cristiano, mi jauc ja cosa sbaj Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ti cho yal yab ja snebuman jumasa: ―Ta ay c'a ma' huas sc'ana sip sc'ujol jmoc, moc lom yen ita oj syajta sbaj. A yaa sbaj juntiro, anima huax aaji locan ja ba cruzi, pero siquiera a sip juntiro sc'ujol jmoc. ");
INSERT INTO tojNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porque spetzanil ja ma' quechan huajel sc'ujol que oj ajyuc tzamal ja ba luum iti, huan ni xch'aya sbaja. Pero ja ma' huax yala: Ta huala chamyon, ti la chamyona, pero siquiera oj ajyuc lec ja caltzili ‑ ja ma' jach huax yala yuj ja queni, oj ni staa ja svida ba jel leca. ");
INSERT INTO tojNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pero ja ma' tey ba sc'ab spetzanil ja jas ay ja ba mundo, pero ta huan c'ax ch'ay ja yaltzili, ¿ja' ma ba slequil ja jau ba? ¡Mi xa huala que oj bob yaa taq'uin siquiera ba oj ajyuc lec ja yaltzil ja ora jahui! ");
INSERT INTO tojNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja queni ti coelon jan ja ba satq'uinali, pero oj to ni cho jacona. Pero cuando la jacyoni, oj ni ya lijpucon ja jTata. Oj ni sec jmoc ja yangela. Jaxa ora jahui, chican ja yatel ja cada jujunei, ay ni jas oj caa yia. ");
INSERT INTO tojNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Q'uelahuilex. Ja queni, ti ni coelon jan ja ba satq'uinali. Pero ay chaboxe ja huenlex ti ayex ja ili, pero mi oj chamanic masan to oja huilonex. Oj ni ahuilonexa, pero ja' ni ja ba huax c'ulan mandari, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ti ec' huaque c'ac'u masa. Ja Jesusi soc ja Pedro soc ja Jacobo soc ja yijtz'in Juani, ti huajye ja ba jun chaanil huitz. Stuch'ile. ");
INSERT INTO tojNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jaxa Jesusi stucbes sbaj ja ba sti sat ja yenlei. Ja sati lijpi juntiro jastal ja sat ja c'ac'u. Jaxa sc'ui sact'ost'os xta huaji. ");
INSERT INTO tojNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Huaj to yile, tey ja aluman‑Dios Moisesi soc ja aluman‑Dios Eliasi. Ti huane loil soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ti yala ja Pedro: ―Cajual, jel lec juntiro ti ayotic ja ili. Huan c'a xa c'ana, jutz'in oj c'ulticon oxe yal naitz, june hua baji, soc june sbaj ja Tat Moisesi, soc june sbaj ja Tat Eliasi, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cuando jach huan yaljel ja Pedro, huaj to yile, jac musjuque yuj jun ason, pero jex lijpi ja asoni. Ti yabye jun c'umal ja ba yojol ja asoni, ja' ni ja sc'umal ja Tatal Diosi: ―Ja iti, ja' ni ja cunin yaj ni huax caba. Jel gusto huax quila, jayuj c'uanic ja huenlexi, xchi ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jaxa yabye ja c'umani ja Diosi, ti ch'ac couque sacnujnuja. Jel xiuye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ti jac ja Jesusi. Ti yamjiyea: ―Q'ueanic, mi lom la xiuyex, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jaxa q'ueyei, q'uelan jacane, pero yilahue que stuch'il ja Jesusi. Mi xa teyuc ja smoj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cuando huane xa coel ja ba huitzi, ti alji yabye yuj ja Jesusi: ―Ja jas ahuilahuexi, moc lom ma' jas ahualex yabi masan to la sacuiyon otro vuelta porque ja queni, ti ni coelon jan ja ba satq'uinali, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","―Pero ¿jastal ay ba? Huax yala ja ma' huas seahue ja smandar ja Moisesi que jel bi t'ilan bajtan oj jacuc ja aluman‑Dios Eliasi, xchi ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","―Meran nia, oj ni jacuc ja aluman‑Dios Eliasi, jaxa yeni oj stojbes spetzanil ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero huax cala huabyex, jac ta ni ja Eliasa pero mi c'ulaji caso. Sc'ulane ja jas sc'ana sc'uluquei. Jach ni ja queni, ti ni coelon jan ja ba satq'uinali pero anima, oj ni yixtalauconea, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ti xa jac sc'ujole ja snebuman jumasa que ja' ni ja Juan huan staajel ti' ja Jesusi, pero ja' ni ja Juan ja ma' huax yaa bautismo ajyi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuando cooye ja ba huitzi, tey jun nole cristiano. Ti jac jun huinica. Jac tajuc yi sc'ab ja Jesusi, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Cajual, talna syaal ja cunini. Jel huax tup yic'. Jel xa yioj juntiro. Tola vida huax moc' ja ba yoj c'ac' soc ja ba yoj ja'. ");
INSERT INTO tojNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Quiaj ta jan yi ja hua nebuman jumasa pero jun xta ay. Mix bob ya tojbuque, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ti yala ja Jesusi: ―Ja huenlexi, mi ni t'un huaxa c'uanex. Jel ch'uuyex juntiro. Ay xa tiempo ti ayex jmoca. ¿Jaye to tiempo huaxa c'anahuex oj caa jpasensia? Iaj jan qui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ti yal yab ja pucuji que oj yacta can ja querem jahui, jaxa queremi, huego huego tojbi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Cuando stuch'ile ja Jesús soc ja snebumani, jaxa snebuman jumasa ti xa sobohuea: ―¿Jasyuj mi bob cujticon ja quenticon oj caaticon eluc ja pucuj ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","―Porque mi xa c'uanex tac. Q'uelahuil ja sbac' ja mostaza. Toj ch'inic juntiro pero ta huan c'a xa c'uanex ja jastal jahui, oj bob ahualex yab ja huitz iti: Elan ja ili, cax ja tihui, y oj ni eluca. Mi ni jas mi oj bob ahuujilexa. ");
INSERT INTO tojNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ja jun tiq'ue pucuj iti, mi ni huax el loma. Quechan ta huaxa c'uanex meran ja Diosi soc huaxa como ahuaelexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Cuando ti xa aye ba Galilea, c'atan xta aye eq'ue. Ti yala ja Jesusi: ―Ja quen ti coelon ni jan ja ba satq'uinali pero oj ni c'ulajucon endregal ja ba sc'ab ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Oj smilone pero ba yoxil c'ac'u, oj ni sac‑huucona, xchi. Pero ja snebumani, jel triste yabye ja jas yala. ");
INSERT INTO tojNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Cuando c'otye ja ba Capernaum, ti jac ja matic huas stzomo ja coperación. Ti yalahue yab ja Pedro: ―Ja hua maestroex ba, ¿mi ma oj yaa ja taq'uin ba? ");
INSERT INTO tojNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―¡Ba miyuca! xchi ja Pedro. Ti huaj sob yi ja Jesús ja ba yoj naitzi, pero bajtan to yala jan ja Jesusi: ―Pero Simón, huan nix naatic jastal ja smodo ja ma' huas stzomo ja taq'uini y huan ni sc'ulan librar ja yermano jumasa. Jaxa tuc jumasa, t'ilan huas sc'anahue yia. ");
INSERT INTO tojNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Meran ni Cajual, xchi ja Simoni. Ti yala ja Jesusi: ―Mi ni sbejuc oj caatica, ");
INSERT INTO tojNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero ba mi ni ma' jas oj yal cabtic, cax ja ba jai, ti xa hua couc ja anzuelo. Ja primero chay huax el ahuuji, a eluc y cahua yi ja stii. Ti oja taa jun taq'uina. Iaj. Cax tupu yile. Tupu ja jbaj ja queni, cho tupu ja baj ja hueni, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ja c'ac'u jumasa jahui, ti jac ja snebuman jumasa. Jac jobjuc yi ja Jesusi: ―Ala cabticon, ja janec' yib mandar ayticon yuj ja Dios tey ba satq'uinali, ¿machunc'a mas nihuan ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ja Jesusi ti spaya jan jun yal untica. Ya och ba snalane, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","―Q'uelahuilex. Mi c'a la ajyiyex como jastal yal untic, mi ni oj ochanic ja ba sc'ab ja ma' tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Porque ja ma' ch'in huax yaa sbaji, ja jastal ja yal untic iti, yena ni mas nihuan huax ilji yuj ja Dios ja ma' huan sc'ulajel mandar ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jaxa ma' huas sc'ulan recibir jun yal untic ja jastal iti yuj ni yaj huax yabyona, lajan soc quena ni huas sc'ulanon recibira. ");
INSERT INTO tojNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pero ja ma' huas somo yi ja spensar ja jun ch'inita ja ma' huas sc'uanoni, mas lec, mocho yi jun sc'ab cha' ja ba snuq'ui. A jipjuc ba yoj ja', jaxa tihui, ti ni oj chamuca. ");
INSERT INTO tojNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Jel ajul ja sbaj ja cristiano ba mundo iti! Jel ja ma' huas somo ja s'olomei, pero jach nia. T'ilan ni oj ajyuc ja ma' huas somo ja s'olom ja cristiano pero ¡pobre ja matic huas somo! ");
INSERT INTO tojNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ja' c'a hua c'ab ma ja' hua huoqui huax ya lee ja hua muli, pues mas lec, a ch'ay snaajel junuc. Mas lec mey jun ahuoc huala och ja ba lequil vida. Mas lec renco ochan, no que soc ja tz'ican ahuoc ac'abi ti oj huajan ba yoj c'ac' jau ba mi ni nunca huax tupi. ");
INSERT INTO tojNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ja' c'a june ja hua sat huax ya lee ja hua muli, mas lec a ch'ay snaajel junuc. Mas lec quechan june ja hua sat oj ochan ja ba lequil vida que no que soc ja tey ja xchabil ja hua sat oj jipjan ba sc'ajc'al ja inpierno. ");
INSERT INTO tojNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Moc lomuc ahuilex menos ja yal ch'in jumasa iti, porque ja yenlei, huane q'ueljel yuj ja ángel jumasa. Jaxa ángel jumasa jahui, ti ni ay ba satq'uinala, y ti ni aye ja ba sti sat ja jTati. ");
INSERT INTO tojNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ja queni ti ni coelon jan ja ba satq'uinali pero jac jcolta ja ma' ch'ayeli. ");
INSERT INTO tojNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jun huinic, ta ay c'a yioj cien chej pero ta huan c'ax ch'ay junuc ja jahui, oj ni yaa can ja noventa nueve ja ba huitzi. Oj ni huaj slee ja jun it ch'ay can yuji. ¿Mi ma jach ni oj sc'ul ba? ");
INSERT INTO tojNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pero man to huas staa, ti xa huax cujlaji ja sc'ujoli. Mas jel sgusto ja jun jau it ch'ay yujili soc ja noventa nueve mi ch'ayeluqui. ");
INSERT INTO tojNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Porque ja hua Tatex tey ba satq'uinali, mi ni june huas sc'ana oj ch'ayuc ja yal ch'in jumasa iti. ");
INSERT INTO tojNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ta huan c'a slea smul ja hua huermano, caax. Cax como, pero atuch'ilex. Ta huan c'a smacla ja jas oja huali, oj ni tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero ta mi c'a huas smacla ja jas oja huali, ti xa lea junuc ma chabuc ja hua testigo cosaque jachuc oj ilxuc ja smeranili porque ay chaboxe tial. ");
INSERT INTO tojNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Pero ta mi ni c'a jastal jahui mi smacla, ala claro ba yoj iglesia. Mi ni c'a ja iglesia, mi c'a cho smacla, entonces lajan soc ja ma' mi huas sc'uan ja Diosi. Ilahuic jastal june ja ma' mi ni huax naatic sbaji, jastal ja ma' lom huax yaa ba sc'ab ja taq'uini. Jach oja huilex. ");
INSERT INTO tojNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Pero huax cala, pero meran, ja huenlexi oj cananic como jastal jloc'ol ja ba luumi. Ja jas huaxa huilahuex mi lec huas sc'ulane ja cristiano, jach ni oj cho yil ja ma' huas sc'ulan mandar ja ba satq'uinali. Y ja jas huaxa huala ba lequi, lec ni oj cho yil ja ma' huas sc'ulan mandar ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Soc oj to cala huabyex otro cosa. Ta ay c'a chahuanex lajti abal ayex huaxa c'anahuex yi ja Dios jun cosa, oj ni yaa huilex ja jTat tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ta tzoman c'a ay chaboxe yuj ja jbiil ja queni, ti ni oj ajyucon ja ba snalanei, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ti jac sob ja Pedro: ―Cajual, jun quermano, ta huan c'a slea smul jmoc, ¿jaye vuelta oj c'ul perdonar ba? ¿Oj ma jc'ul perdonar juque vuelta? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","―¡Jas yatel quechan juque vuelta huaxa c'ana oja c'ul perdonar! Chican jaye vuelta, c'ulan ni perdonara. ");
INSERT INTO tojNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ja ma' mandar ay yuj ja Dios tey ba satq'uinali, ja' ni mero sbej oja c'ul perdonar abajexa. Maclayic ja jas sc'ulan jun rey huas sc'ana oj aajuc yi cuenta yuj ja smozo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Cuando ja' huane cuenta soc ja smozo, ti payji jan june ja ma' ay sel soqui, pero jel aay juntiro ja seli. ");
INSERT INTO tojNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero iday, mi ni modo huax bob stupa. Jayuj ti yala ja ajualali que oj chonjuc ja yeni soc ja xcheumi soc ja yuntiquili, soc spetzanil ja jastic sbaji. Jachuc oj bi bob stup ja seli. ");
INSERT INTO tojNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jaxa mozo ti sipa sbaj ja ba sti sat ja ajualali: Cajual, ¿mi ma oja huaa t'an qui perdón? Majlayon t'usan. Oj ni tup ahuia, pero spetzanil, xchi ja mozo. ");
INSERT INTO tojNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jaxa ajualali stalna syaal ja smozo. Ya huaj libre. Ch'ac sc'ul perdonar spetzanil ja seli. ");
INSERT INTO tojNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ti huaj ja mozo. Ti staa sbaj soc jun ja smoj mozoili. Jaxa mozo jahui, ay sel soc ja ma' ch'ayji ta yi ja sel soc ja yajuali, pero ja jun iti, t'usan ja seli. Iday, ti syamaa. Stz'oto yi ja snuq'ui: Aa qui huego ja hua jeli, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jaxa smoj mozoili ti cho sipa sbaj ja ba sti sati: ¿Mi ma oja huaa t'an qui perdón? Majlayon t'usan. Oj ni tup ahuia, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jaxa yeni, mi ni t'un yaba. Yiaj. Huaj ya och preso. Masan to yaa ja seli, ti to ya el librea. ");
INSERT INTO tojNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pero ilji ja jas sc'ulane. Iljiye yuj ja otro mozo jumasa. Juntiro och stristeilei. Huaj yale yab ja yajualei. ");
INSERT INTO tojNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jaxa yajualei ti spaya jan ja ma' sc'ulan ta perdonari: Ja huen mozo, jel maloa juntiro. Ja quen caa hui perdón porque ja c'ana qui lec perdón. ");
INSERT INTO tojNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jaxa hua moj mozoili, mi ni huaxa talna syaujulala ja jastal jtalna ja hua yaujulal ja hueni. Pero ¿jasyujil? xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jel xa q'ueel juntiro ja scoraja jayuj ti xa yaa ba sc'ab ja matic jel tzatz huax yaa castigo. Ti bi oj ajyuc masan to huax ch'ac tupuc ja seli. ");
INSERT INTO tojNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ti cho yala ja Jesusi: ―Jachuc ja huenlexi, ta mi c'a xa c'ulanex perdonar soc spetzanil ja hua c'ujolex ja hua huermanoexi, jach oj cho sc'uluc ahuilex ja jTat tey ba satq'uinali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ja cuando ch'ac ta yal ja jastal jahui, ti xa el ja ba Galilea. Ti huaj ja ba lugar Judea ja ba otro lado ja nihuanja Jordani. ");
INSERT INTO tojNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iday, nochji yuj jitzan cristiano. Ti ch'ac ya tojbuc ja chamum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ti jac chaboxe fariseoa. Jac sc'uluque probar ja Jesusi: ―Ala cabticon ba. Jun huinic soc ja xcheumi, ta huan c'a spila sbaje ja ba mi sbejuqui, ¿lec ama ba? ¿Jas huaxa huala soc ja hua mandar ja huen ba? ");
INSERT INTO tojNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ti yala ja Jesusi: ―¿Mi ni ma t'usan huaxa q'uelahuex ja yabal ja Dios ba? Ja ma' sc'ulanexi, sc'ulan ixuc soc cho sc'ulan huinic. Jach ni masan cujlaji ja satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jayuj yala que jun huinic, t'ilan oj yaa can ja snan stati. Oj bi yii ja xcheumi. Meran nia, chahuane ajyi pero ja huego, lajan soc quechan xta june aye. ");
INSERT INTO tojNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jayuj huax alxi que mi xa chabeuc, quechan xta june. Ja jas ya staa sbaj ja Diosi, mi lecuc ay ma' oj jac spile, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","―Entonces, ¿jasyujil ja yala ja Moisesi que oj yaa yi jun juun ja xcheume ja cuando huas spila sbaje ba? xchi ja fariseo. ");
INSERT INTO tojNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ti yala ja Jesusi: ―Yala nia, pero yuj ja jel ch'uuy ja hua c'ujolexi, jayuj yala que oja pil abajex soc ja hua cheumexi. Pero ja cujlaji ja satq'uinali, mi jachucuc ay. ");
INSERT INTO tojNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero ja queni huax cala huabyex, ja ma' c'a lom huas sipa can ja xcheumi, ta mi c'a huanuc sleejel smul soc otro huinic, ti c'a huax cho nupani soc otro ixuc, huan ni slea smula. Jach ni, ja ma' huax cho nupani soc ja ixuc it jipubal cani, huan ni cho staa smula, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ti yala ja snebuman jumasa: ―Entonces ta jach c'a ay jun huinic soc ja xcheumi, mas lec mi la nupaniticon, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ti yala ja Jesusi: ―Ja iti, chican chican ja ma' huax yab slugarili. Quechan ita ja ma' ac'ubal spensar yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tuctuquil ay ja ma' mix nupani. Ay ma' manxel yuj ni mi tz'icanuc ac'ubala. Soc ay ma' ba satq'uinal xa it huax jom lom ja scuerpo ba mi oj c'anc'onuc oj yii jun ixuc. Soc ay ma' mix nupani yuj huas sc'ana oj ajyuc libre cosaque oj bob sc'uluc ja jas huas sc'ana ja Dios ja ma' mero huas sc'ulan mandar ja ba satq'uinali. Ta huan c'ax bob ahuujilex, pues jel lec, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ja Jesusi ti iiji jan yi chaboxe yal untica. C'anji yi pavor que oj bi syame, oj bi sc'umuc ja Dios yuj ja yenlei. Pero ja snebuman jumasa scomohue ja snan statei. ");
INSERT INTO tojNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ti yala ja Jesusi: ―Miyuc. Actayic. A jacuc jmoc ja yal untiqui. Mi lom xa macahuex. Ja jastal ja sc'ujol ja yal untic iti, jach ni ay ja sc'ujole ja ma' mandar ay yuj ja jTat tey ba satq'uinali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Cuando ch'ac ya cajan ja sc'ab ja s'olomei, ti el ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huaj to yil ja Jesusi, ti jac jun solteroa: ―Maestro, jel leca juntiro. Ala cab jasunc'a lec oj c'uluc oj quil jun vida ba jel lec ba mi ni nunca oj ch'acuc, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","―¿Jasyuj huaxa huala cab que leconi? Mi ni june ma' lec, quechan ja Diosi. Pero ta huan c'a xa c'ana oj ochan ja vida ba lequi, c'uan ja mandari, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―Pero ¿jas mandaril ba? xchi ja soltero. Ti yala ja Jesusi: ―Moc lom milhuanan. Moc alee amul soc jun ixuc. Moc lom elc'anan. Moc lomuc alee mentira. ");
INSERT INTO tojNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yajta ja hua nan atati. Yaj oja huab ja hua moji jastal ja huen yaj huaxa huab abaji, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","―Pero jach ni huax c'ulan man jch'inila. ¿Jasunc'a huas sc'ulanon palta ba? xchi ja soltero. ");
INSERT INTO tojNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ti alji yab yuj ja Jesusi: ―Ta meran huaxa c'ana toj lec oj ajyani, caax. Cax chono can ja jastic ahuioji, ti xa huaa yi ja pobre jumasa. Cuando xch'ac ac'uluc jachuc, ti la jac jmoca, ti oja huil que oj ni ata ja jas jel tzamal ja ba satq'uinali, x'utji yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jaxa soltero jahui, cuando ch'ac yabi, jel triste huaji porque jel ja jastic sbaji. ");
INSERT INTO tojNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ja Jesusi ti yal yab ja snebuman jumasa: ―Jel huocol huax yaa sbaj jun rico ba oj c'ulajuc mandar yuj ja ma' tey ba satq'uinali. Pero meran huax cala. ");
INSERT INTO tojNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Soc oj cho cala huabyex otro vuelta, mas mi huocoluc oj ec' jun camello ba sotol ja tz'istaq'uini que jun rico oj yaa sbaj oj c'ulajuc mandar yuj ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","―Entonces ¿machunc'a oj bob el libre soc ja smul ba? xchi ja snebumani. Cham yabye juntiro ja yabye ja jas yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ti tojtoq'ueljiye lec yuj ja Jesusi: ―Ja cristiano, mi jas oj bob yuj, pero ja Diosi, mi huocoluc. Oj ni bob yuj spetzanila. ");
INSERT INTO tojNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ja Pedro ti yalaa: ―Entonces, ¿jaxa quenticon ba? Caunejticon can spetzanil ja jastic quiojticoni ba oj ajyucoticon amoc. ¿Jasunc'a oj aajuc quiticon ba? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","―Pues oj cala huabyex ja smeranili. Ja queni ti coelon jan ja ba satq'uinali pero ja ba yajc'achil ja mundoi, oj ni aajuc jun catel ba jel tzamal juntiro. Y jachuc ja huenlexi ja lajchahuanexi, oj ni cho aajuc ahuatelexa. Oja tojbesex ja cristiano ba Israel. Jach ni oj aajuc ahuilex ja huenlexi yuj ja hua jipunejex ja hua c'ujolex jmoqui. ");
INSERT INTO tojNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jach ni spetzanil ja ma' yauneje can ja snaji, ma ja yermano jumasa, ma ja yermana jumasa, soc ja snan stati, ma ja xcheumi, ma ja yuntiquili, ma ja slugari yuj ja sipa sc'ujole jmoc ja queni, oj ni aajuc yi sloc'ol spetzanila, soc cien vuelta mas. Oj cho aajuc yi jun svida ba jel tzamal ba mi ni nunca huax ch'aqui. ");
INSERT INTO tojNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Soc jitzan ja ma' nihuan huax ilji ja ili, pero ja tihui, jel juntiro ch'in oj iljuque. Soc jitzan ja ma' jel ch'in huax iljiye ja ili, jaxa tihui, jel nihuan oj iljuque, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Cuando mandar xa ayex yuj ja ma' tey ba satq'uinali, mi xa sbejuc oja huil abajex condra. Q'uelahuil jun ajualal. Ja sacbeli huaj sc'ul trato soc ja atjum jumasa ba oj atjuque ja ba yalajil ja stz'usubi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oj bi tupjuque joe peso ja c'ac'u. Cuando ch'ac ta sc'uluque ja trato, ti xa seca ba yalaja. ");
INSERT INTO tojNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Cuando chaan xa lec ja c'ac'u, ti xa cho huaj otro vuelta ja ba plaza. Ti yila ti saculcul ec' ja ma' mey yatelei. ");
INSERT INTO tojNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ti yal yaba: Caaxic ja huenlex chomajquili. Cax taahuic ja catjum tey ba calaji. Mix cham ac'ujolex ja hua tz'acolexi. Oj caa huilex, xchi ja ajualali. Ti huajyea. ");
INSERT INTO tojNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jaxa cujlaji ja c'ac'u, ti cho huaj otro vuelta ja ba plaza, soc ja nalan tz'elan c'ac'u cho huaji. ");
INSERT INTO tojNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Soc huaj jun vuelta mojan xa las cinco. Ti cho staa otro chaboxe huinique ti tec'ane ec'a: ¿Jasyuj ti ayex ja il snajtil ja c'ac'u meyuc ahuatelexi? xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Porque mi ma' huax yala cabticon atel, xchiye. Pues caaxic ba calaji. Ay catel ja quen, xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cuando q'uicbi ja q'uinali, ja suinquil ja yalajil tz'usubi ti yal yab ja smayordomo: Paya xa jan ja atjum jumasa. Aa xa yi ja stz'acolei. Bajtan oja huaa yi ja ma' tzaan juli, x'utji ja mayordomo. ");
INSERT INTO tojNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ti jacye ja ma' ochye atel ba las cinco. Cada huinic aaji yile jotique peso. ");
INSERT INTO tojNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jaxa yajni jacye ja ma' bajtan ochye ateli, huego c'umani sc'ujole oj aajuc yi mas. Pero jach ni ja yenlei, jotique peso sc'ulane recibir. ");
INSERT INTO tojNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yajni yilahue quechan joe peso aaji yilei, jel q'ue juntiro ja scorajae soc ja yajualei. ");
INSERT INTO tojNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ja yenle ja ma' tzaan ochye ateli, quechan jun ora atjiye iday, jun xta lajan ja jtz'acolticoni. Jaxa quenticoni, snajtil ja c'ac'u huanticon atel y jel yaj juntiro ja c'ac'u, xchiye ja atjum jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero tata, ¿mi ma cal ni huab que joe peso oj caa hui ba? Ja quen mey xlolaya. ");
INSERT INTO tojNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Iajic ja ba hua baj ja huenlexi. Caaxic. Ja huinic it ja ma' tzaan ochi, oj ni caa yi ja jastal caa huilex ja huenlexi, como jach ni huax c'anaa. ");
INSERT INTO tojNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mi ma sbejuc ni oj c'uluc ja jas huax c'ana soc ja jas quioj ba? Ja huenlexi, jel envidiosoex soc ja ma' huaxa huilahuex jaman ja jc'ab soqui, xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pues jach ni aya, xchi ja Jesusi. Ja ma' huaxa huilahuex tzaan ay ja ba luumi, yen to bajtan oj ajyuc ja ba huas sc'ulan mandar ja mero Ajualali. Jaxa ma' bajtan ay ja ba luumi, yen tzaan oj ajyuc ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Cuando ti huajume ja ba Jerusaleni, smoj jitzan cristiano. Ti spiltalaan ja lajchahue snebuman ja ba lado bay ja yeni. Ti xa yala ja Jesusi: ");
INSERT INTO tojNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Q'uelahuilex. Huajumotic xa ba Jerusaleni. Ja queni coelon jan ja ba satq'uinali pero anima, oj ni c'ulajucon endregal ja ba sc'ab ja nihuac pagre jumasa soc ja ma' huas sea ja smandar ja Moisesi. Ja yenlei oj yaone endregal ba oj miljucon. ");
INSERT INTO tojNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Oj yaone yi ja ba sc'ab ja ma' mi sc'uan ja Diosi, jaxa yenlei, oj yixtalaucone lec. Oj smac'one soc cabresto, ti oj yaone locan ja ba cruzi. Pero ba yoxil c'ac'u oj sac‑huucon, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jaxa xcheum ja Zebedeo ti yiaj och ja yuntiquili. Jaxa ixuc jahui ti huaj staa yi sc'ab ja Jesusi. Huaj sc'an yi pavor. ");
INSERT INTO tojNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","―¿Jasunc'a huaxa c'ana ja huen nana? xchi ja Jesusi. ―Cajual, ja' huax c'ana, cuando och ta huateli, huax c'ana hui pavor oja huaa yi ba mas tzatz ja yatele ja cuntiquili, xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","―Pero nana, ja hueni, mi xa naa jasunc'a huana sc'anjeli, xchi ja Jesusi. Jaxa huenlex queremtic, ¿oj ma bob ac'uluquex ahuantar jun nihuan huocol ba? ¿Oj ma huaa bajex ba oj chamanic? xchi ja Jesusi. ―Ojo, xchi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ti yala ja Jesusi: ―Meran nia, lajan oj quiitic ja huocoli. Pero ba oj caa hui ja atel ba mas tzatzi, mi ni sbejuc oj caa huia. Tzaubal ni yuj ja ma' oj yaa yi ja jTata, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jaxa lajunhuane ja smoj snebumanil, cuando ch'ac yabye ja iti, jel q'ue ja scorajae soc ja chab huinique jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ti yala ja Jesusi: ―Ch'abananic. Ja matic mi sc'uan ja Diosi, huan ni xa naahuex jastal culan yuj ja ma' ay yatel yujilei. Jel c'aq'ue. Jel menos huax yilahue ja suiniquei. ");
INSERT INTO tojNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ja huenlexi, mi jach oja huila bajex. Ta huan c'a xa c'anahuex nihuan oj ajyanic, colta ja hua mojexi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ta huaxa c'ana ajyanic jepeil, ochanic mozoil. ");
INSERT INTO tojNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Q'uelahuil ja queni. Coelon jan ja ba satq'uinali pero mi jaquelucon ba ay ma' oj yateltayon. Jaquelon ba oj colta ja cristiano ‑ oj caa ja jvida ba oj bob ajyuc libre spetzanil ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuando elye ja ba chonab Jericó, nochjiye yuj jitzan cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jaxa ba sti ja beji, ti culan ec' chab huinica. Tupel ja satei. Yabye yabalil ja Jesusi que ti bi ec'um ja tihui: ―Cajual, talna jyaalticon. Huena ni yintil ja rey Davida, pero ahuanel huane yaljel. ");
INSERT INTO tojNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jaxa cristiano, huane xta huooljuc: ―Ch'abananic ja huenlex pac'a sat, xchiye xta. Pero ja ma' tupel ja satei, mas to ahuaniye: ―Cajual, talna jyaalticon. Huena ni yintil ja rey Davidi, jecubala yuj ja Dios jel nihuani, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ti c'ot tec'an ja Jesusi. Spaya jani: ―¿Jasunc'a huaxa c'ana oj c'uluc ahuilex ja huenlex ba? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","―Cajual, huax c'ana oj hua quilticon q'uinal, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ti talnaji syaale yuj ja Jesusi. Yamji yile ja satei. Huego yilahue q'uinal, ti xa huajye nochan soc ja Jesusa. ");
INSERT INTO tojNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Cuando mojan xa yioje ja Jerusaleni, ti c'otye ba jun lugar sbiil Betfagé ja bay ja huitz Olivosi. Ja Jesusi huas sc'ana sec chabe ja snebumani, ");
INSERT INTO tojNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ti yal yabyea: ―Caaxic ja ba ch'in chonab ja ba lado sti jsatiqui. Jaxa tihui, ti oja taex jun burra mochantea. Cho ay ni yal. Tucuhuic. Iajic jan qui. ");
INSERT INTO tojNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ta ay c'a ma' jas huax yala huabyex, alahuic yabi, ja' huas sc'ulan necesitar ja Cajualtiqui, utajic. Pues iajic ba, oj yutex, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Spetzanil ja jastal iti, jach huaji, iday c'ot ni smeranil ja jas yala ja aluman‑Dios ja najatei: ");
INSERT INTO tojNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cax alahuic yab ja suinquil ja Jerusaleni: Q'uelahuilex, ja hua reyexi oj xa jac amoquex. Cajan burrito oj jacuc. Pobre ni huax jaca. Cajan jun yal burro, yal jun burra ba carga oj jacuc ja hua reyexi. Jach ni huax yala ja aluman‑Dios tac. ");
INSERT INTO tojNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ti huajye ja snebumani. Sc'ulane nia ja jas alji yabye yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ti yiaje jan ja burra soc ja yali. Ti ya bacan ja sc'uei, ti q'ue ja Jesusa. Quechan scujlaban ja c'uutz jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jaxa cristiano, jel aaye juntiro. Ch'ac slich'e ja sc'ue ja ba yoj beji, soc ay ma' sc'utzu ja spoohuil ja tei. Ti xcholohue ja ba beji. ");
INSERT INTO tojNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jitzan ja cristiano ja ma' ba sti sat ja Jesusi soc jitzan lec ja ma' tzaan ba spatiqui. Spetzanil huane xta ahuanel: ―¡Viva ja ma' yintil ni ja rey Davidi! ¡Stz'acatal ja ma' jac yuj ja sbiil ja Cajualtiqui! ¡Viva ja ma' tey ba satq'uinali! xchiye xta ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Cuando ochye ja ba Jerusaleni, spetzanil ja suinquili, jel och ja spensare: ―¿Machunc'a ja iti? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jaxa tuc cristiano: ―Ja huinic iti, aluman‑Dios nia, ja' ni ja Jesús ba Nazaret sbaj Galilea, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ja Jesusi ti och ja ba spatioil ja templo. Ti yila ja ma' huan xchonjel ja cosa soc ja ma' huan smanjeli. Jaxa yeni, ch'ac snutz el spetzanile. Jaxa smesa ja ma' huan sc'ulajel cambiar ja taq'uini, ti suichpun ele. Jach ni ja silla ja ma' huan xchonjel paloma. ");
INSERT INTO tojNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","―Ja jnaji, quechan ba huax c'umaxi ja Diosi, ¿mi ma jach ni tz'ijbanubal ba? Pero ja huenlexi, ¡huaahuex ta pax snaj lagronil! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ja matic tupel ja satei soc ja renco jumasa ti huajye soc ja Jesusi cuando ti xa ay ba yojol ja templo. Jaxa yeni ch'ac ni ya tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Spetzanil ja jastic jel tzamal huan sc'ulajel ja Jesusi, huane yiljel ja nihuac spagre ja judio jumasa soc ja matic huas sea ja smandar ja Moisesi. Cho huane yabjel ja jastal ja yahuanel ja yal untic jumasa: ―¡Viva ja yintil ja rey Davidi! xchiye xta, iday, jaxa yenlei, jel q'ue juntiro ja scorajae ja yabyei. ");
INSERT INTO tojNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ti xa yalahue yab ja Jesusi: ―¿Mi ma xa huab ja jas huane yaljel ja yal untic it ba? xchi ja pagre jumasa. Ti yala ja Jesusi: ―¡Jastal mi oj cabi! Bob ta mi ni nunca huaxa q'uelahuex ja juun ja huenlexi ja ba huax yala jastal iti: Jel toyjiya juntiro pero ja' ni ba sti ja yal untic jumasa, ja' sti ja ma' huan to chuuneli. ¿Mi ma jach ni huax yala ja yabal ja Dios ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ja Jesusi ti sipa can ja yenlei. El ja ba chonabi, ti huaj ja ba jun ch'in chonab, Betania sbiil. Ja tihui, ti staa ja sposada ja ba huayi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ja Jesusi sacbel saj to cumxi ja ba Jerusaleni, pero cuando ti xa ay ja ba beji, ti jac huain xyaba. ");
INSERT INTO tojNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ti yila jun steil ja higo tey ba sti ja bej ba eq'ui. Ti huaj sq'uel c'ubana, pero mi ni jun sat aya. Quechan tey ja spoohuili. Ti yalaa: ―Ja huen higo, mi ni nunca oj ajyuc ja hua sati. Jaxa steil ja higo, huego tacji. ");
INSERT INTO tojNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jaxa yilahue ja snebumani, jel och juntiro ja spensarei. Ti yalahuea: ―¿Jasyujil ja steil ja higo huego huego tacji? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ti yala ja Jesusi: ―Huan c'a xa c'uanex meran, mi lom xc'umani ja hua c'ujolex, jach ni ja huenlexi. Oj ni bobuc ahuujilex soc ja steil ja higo iti. Soc mi quechanuc ja iti. Oj bob ahualex yab ja huitzi, elan ja ili, cax jipa baj ba yoj jai, y oj ni c'otuca. ");
INSERT INTO tojNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Porque spetzanil ja jas huaxa c'anahuex yi ja Diosi, ta huan c'a xa c'uanex merani, oj ni aajuc ahuilexa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ja Jesusi cuando och ja ba templo, ti q'ue see yi ja cristiano. Ti jac ja nihuac pagre jumasa soc ja ma' banquilal ay yujile ja cristiano. Ti yalahuea: ―¿Yuj ama ay ahuatel ja huen huaxa c'ulan ja cosa jumasa iti? Entonces, ¿ma' yaa hui ja hua huateli? xyutaje. ");
INSERT INTO tojNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ti yala ja Jesusi: ―Jachuc ja queni, ay jas huax c'ana job ahuilex. Ta huan c'a xa hualahuex cabi, entonces oj cala huabyex ma' yaa qui oj c'uluc ja cosa jumasa iti. ");
INSERT INTO tojNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jaxa Juan it huax yaa bautismo, ¿machunc'a yala oj sc'ul bautizar ja cristiano? ¿Ja' ma alji yab yuj ja ma' tey ba satq'uinali, ma ja' alji yab yuj ja cristiano? Pero ja pagre jumasa soc ja banquilal jumasa ti ochye loil yenle mismo: ―Huan c'ax calatic ja ma' tey ba satq'uinali, entonces oj yal cabtic, entonces, ¿jaxa yuj ja mi xa c'uanex ba? oj yutotic. ");
INSERT INTO tojNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iday, ta huan c'ax cho calatic que ja' sbaj cristiano, jel xihuel ja sbaj porque ay modo ay jas oj yal cabtic porque spetzanil huax yalahue que aluman‑Dios ja Juani, xyutaj sbaje. ");
INSERT INTO tojNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ti yalahue yab ja Jesusi: ―Mix naaticon, xchiye. ―Entonces jachuc ja queni, mi oj cala huabyex ma' yaa qui ja cateli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pero maclayonic, ti xa huala cab jasunc'a ja hua pensarexi. Ay jun huinic soc ay chab yuntiquil. Ja tatali ti huaj yal yab june ja yenlei: Cunin, cax atjanan ja yaan c'ac'u ja ba yalajil ja tz'usubi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pues mix c'ana huajcon tatey, xchi ja yunin jahui. Pero ti sc'ulan pensar ja mas tzaani, ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jach cho huaj soc ja otro jun yunini. Cho huaj yal yab como jastal huaj yal yab ja otro juni, iday, jaxa yeni: Lec tatey, oj ni huajcona, xchi. Pero iday, mi ni huaja. ");
INSERT INTO tojNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ti cho sobo ja Jesusi: ―Jaxa chahuane queremtic jahui, ¿machunc'a sc'uan ja yabal ja stati? xchi ja Jesusi. Ti yalahuea: ―Ja' ni it ma' alji yab bajtani, como yala que mi oj huajuc, iday, huaj nia. Ti yala ja Jesusi: ―Meran huax cala huabyex, ja tantic colector jumasa ja ma' jel coraja huaxa huilahuexi, soc ja ixuque jumasa mañosa, lajan soc mi ni nunca oj yaa sbaje soc ja Diosi, pero iday, ja mas tzaani, huan nix yaa sbajea. Pero ja huenlexi, lec, la chiyex, pero iday, mi ni nunca huaxa c'ulanexa. ");
INSERT INTO tojNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ja Juan it ma' yaa bautismo, yena ni sea huilex ja bej ba lequi, pero ja huenlexi, mi ac'uanex. Hasta man ahuilahuex que ja yenle ja ma' jel coraja huaxa huilahuex huan suchel ja sc'ujolei, jaxa huenlexi, mi ni t'un huaxa c'ulanex pensara. Hasta que mi ni oja c'uuquexa, iday, sea ni huilex ja bej ba mas lec ja Juani. ¡Jel ni ch'uuy juntiro ja hua c'ujolexi! ");
INSERT INTO tojNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Cho maclayic. Oj cala huabyex otro jun loil. Ay jun huinic, jaxa huinic jahui, ay jun yunin. Sc'ulan jun yalajil tz'usub, ti smacbaa. Sc'ulan jun sluchayub ba oj yil spetzanil ja yalaji. Jaxa yalaj jahui, ti sc'ulan trato soc chaboxe huiniquea. Jaxa mero suinquili, najat huaji. ");
INSERT INTO tojNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuando ja' xa yorail ja sbaal ja alaji, ja suinquili ti seca chaboxe ja smozo ba oj huaj sc'umuc ja ma' trato ay soc ja alaj jahui ba oj cho c'ulajuc recibir ja sracion ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jaxa huinique jahui, ti syamahue ja mozo jumasa. Ja juni, smac'ahue, jaxa juni, smilahue, jaxa otro juni, xch'ojohue ton. ");
INSERT INTO tojNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jaxa suinquil ja alaji ti cho seca chanjoe ja smozo jumasa. Mas aaye xa huajye ja tiempo iti. Pero jun xta yabal c'ulaji yile soc ja ma' bajtan huajyei. ");
INSERT INTO tojNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jaxa suinquil ja alaj jahui mi xa snaa jas oj sc'uluc. Ti yalaa: Oj ma jec ja cunini. Ja cunini, bob ta oj ni sc'ul respetara, xchi ja suinquil ja alaji. ");
INSERT INTO tojNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","¡Pero malaya! Yilahue sat ja yunini, ti cho yalahue yenle itaa: Ja iti, yen oj yii can spetzanil ja dote. ¿Jaxa mix milatic ele? Ta huan c'ax cham cujtic, quen ni oj bajuctic ja sdotea, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ti syamahuea. Ti yiaje ja ba spat alaj, ti smilahuea. ");
INSERT INTO tojNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Cuando huax cumxi ja suinquil ja alaj jahui, ¿jas huala chiyex? ¿Jas oj yut ja huinique jumasa jahui? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti yalahue ja ma' huan loil soqui: ―Pues moc lom yaa sperdon. ¡A ch'ay snaajel ja mal cristiano jumasa jahui! ¡A yaa ba sc'ab ja otro cristiano ja yalaji ba oj yateltaye. Cuando oj staa ja yorail ja sbaal ja yalaji, oj ni aajuc yi ja sracion ja suinquili, xchiye ja ma' huan smaclajel ja loili. ");
INSERT INTO tojNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ti yala ja Jesusi: ―¿Mi ni ma nunca huaxa q'uelahuex ja suun ja Dios ba? Ay jun oy ba jel tzamali, pero ja c'ulanaitzi mi huas squitz'a, iday, jaxa oy jau mi squitz'ahuei, ja' mero oj yaa mas yip ja naitzi. Ja Cajualtiqui, yena ni sc'ulan ja iti y jel tzamal juntiro huax abxi, xchi ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ja huenlex ja matic pagre ayexi, soc ja fariseo jumasa, cuenta ayex lec yuj ja Dios ajyi. Pero ja huego, lajan soc toj suelto xa ayex soc ja smandar ja Diosi. Ja mandari, eso sí, ti ni aya, pero chican ja ma' huas sc'uani. Yenle ni oj ochuque cuenta soc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ta ay c'a ma' huas st'aspun sbaj soc ja oy jahui, jel tzatz juntiro oj yie. Pero ta ja' c'a oy tec'an eq'ue, y huax moc' ja oy jahui, eso sí, pedazo oj huajanic. Y jach ni oj huajanica ta mi xa c'uanonexi. Ja castigo, jach ni oj couc abajexa. ");
INSERT INTO tojNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Huan yaljel lec ja loil it ja Jesusi, jaxa yabye ja yenle ja nihuac pagre jumasa soc ja fariseo, huego jac sc'ujole que yenle huax tajiye tii. ");
INSERT INTO tojNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ti huas sc'ana syamea, pero xihuel xihuel aye juntiro yuj ja cristiano porque huax yalahue que aluman‑Dios ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ja Jesusi ti cho yal yabye otro jun loila: ");
INSERT INTO tojNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Mi cualquierauc xta ja ma' oj yaa sbaj ja ba sc'ab ja ma' tey ba satq'uinali ba oj c'ulajuc mandar. Q'uelahuil jun rey cuando huax ch'ac yabalil ja yunini. ");
INSERT INTO tojNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ti seca ja smozo ba oj huaj yal yab spetzanil ja sloc jumasa ba oj xa jacuque ja ba ch'ac abali. Jaxa loc jumasa, mi ni june yala oj jacuquea. ");
INSERT INTO tojNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jaxa reyi, cho seca otro vuelta ja smozo: Caaxic. Cax alahuic yab ja loc jumasa jahui, q'uelahuilex, chapan xa huaelali. Ch'ac ta chamuc ja huacax jumasa y tzaubal lec ja ba cojleli. Chapan xa spetzanil. La xa huaanic ja ba ch'ac abal ba, utajic. ");
INSERT INTO tojNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ja loc jumasa, mi ni yaahue casoa. Huaj como jastal huas sc'ulanei. Ja tuqui huaj ba yalaj, jaxa tuqui, huaj soc ja jas huax xchonohue. ");
INSERT INTO tojNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jaxa tuqui, syamahue ja mozo jumasa. Yixtalaane lec hasta man smilahue. ");
INSERT INTO tojNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jaxa reyi, jel q'ue juntiro ja scoraja. Ti seca ja soldado jumasa. Ch'ac smil spetzanil ja milhuanum jumasa. Xchimahue c'ac' ja xchonabilei. ");
INSERT INTO tojNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ja reyi ti yal yab ja smozo jumasa: Ja ch'ac abali, chapan xa nia, jaxa loc jumasa ajyi, jel maloe juntiro. Pero como mi ni sbejuc oj jacuque ajyia. ");
INSERT INTO tojNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pero caaxic. Cax ja ba nihuan beji. Chican ma' huax ec' ja tihui, locohuic jani. A jacuque ja ba ch'ac abali, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ti huaj ja mozo jumasa. Huajye ba calle. Chican ma' staahue, sea mal cristiano, sea lequil cristiano, pero stzomohue nia. Jaxa naitz ja bay ja ch'ac abali but'iye juntiro ja loc jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ti xa och jan ja reyi. Sq'uela lec ja sloc jumasa iday, yila jun huinic. Mi slapunejuc ja sc'u ba ch'ac abali. ");
INSERT INTO tojNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ti yala ja reyi: Jaxa huen camigo, ¿jasyuj ja jach jacya mi alapunejuc ac'u ba ch'ac abali? Jaxa huinic jahui, mi ni jun palabra c'umani. ");
INSERT INTO tojNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jaxa reyi, ti sc'ulan mandar ja smozo jumasa: Chuyuhuic ja huinic iti. Pujtzinic el ja ba q'uiq'uinali. Ja tihui, jel ja oq'ueli. Oj ni sc'ux ja yeja, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Meran nia, jel jitzan ja ma' locobali, pero ja ma' oj tzaajuqui, jel ni t'usana, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ja fariseo jumasa ti och yii yabal sbaje siquiera bi jastal oj yaahue el sti jun palabra ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jayuj ti secahue ja suiniqui soc ja yamigo jumasa ja rey Herodesi. Hauj yie loil ja Jesusi, ti yalahuea: ―Maestro, huax naaticon que ja jas huaxa huala ja hueni, puro meran. Huen huaxa jea bay ja sbej ja Diosi, pero meran. Mi la xiu yuj ja cristiano soc mi tzaubaluc ahuuj. ");
INSERT INTO tojNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jayuj jac jobticon ahui, ¿lec ama oj caatic yi contribución ja gobierno Cesari, ma miyuc? ¿Jas la chi ja huen ba? ");
INSERT INTO tojNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ja Jesusi jac sc'ujol jasunc'a huas sc'ulane pensari, que toj malo ja sc'ujolei, ti yalaa: ―Ja huenlexi, toj chab cara ayex. ¿Jas sbej ja huax jac ac'uluconex probari? ");
INSERT INTO tojNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Jea qui jas taq'uinil huaxa tupuhuex ja contribucioni, xchi ja Jesusi. Ti seahue yi jun taq'uin sbiil denario. ");
INSERT INTO tojNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","―¿Ma' s'olom ja iti? Jaxa sletraili, ¿ma' sc'ulan? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Ja' sbaj gobierno Cesari, xchiye. ―Entonces ta ja c'a sbaj gobierno Cesari, aahuic yi ja César ja ba sbaji, jaxa jas sbaj ja Diosi, aahuic yi, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jaxa ch'ac yal ja iti, cham yabye juntiro. Ti xa spila sbaje soc ja Jesusa. Ti huajyea. ");
INSERT INTO tojNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ja Jesusi ja mismo c'ac'u jahui, ti cho jac jobjuc yi yuj chaboxe huinique. Saduceo huax aaji sbiiluque, jaxa yenlei mi huas sc'uane ta huas sacui ja scuerpo ja cristiano ja ba otro lado huax chamyei. ");
INSERT INTO tojNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ti yalahuea: ―Maestro, ta ay c'a jun huinic huax chami, huax yaa can ja xcheumi, pero mey yuntiquile, jaxa Moisesi yaa smandar que oj iijuc ja xcheum ja chamhuiniqui yuj ja yijtz'in huiniqui. Jaxa yuntiquil ja yenlei, que oj bi aljuc que ja' bi yuntiquil ja chamhuinic banquilali. ");
INSERT INTO tojNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma oj caltic que ti bi aye jmoctic ja jucuane yermano sbajei. Ja banquilali nupani, pero chami. Mi ni jun yuntiquil cana. Jaxa xcheumi, ja' ita yiaj ja xchabil yijtz'ini. ");
INSERT INTO tojNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ja jastal sc'ulan ja banquilali, jach cho sc'ulan ja xchabili. Soc jach ni ja yoxili. Jach ni cho ec' scajcajile ja sucuanilea. ");
INSERT INTO tojNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ti xa cho cham ja xcheumea. ");
INSERT INTO tojNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jaxa ba otro lado, cuando oj sac‑huuc ja scuerpoei, ¿machunc'a mero oj yii ja ixuc jau ba? Porque spetzanile xcheumane ja ba luumi, xchi ja saduceo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ti yala ja Jesusi: ―Ja petzanilex mi ni jas huaxa naahuex t'usana. Mi xa huabyex sbej ja slibro ja Diosi. Mi huaxa c'uanex ja yip ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porque cuando oj sac‑huuc ja scuerpo ja ma' huax chamyei, mi xa oj to ajyuc nupanel. Mi xa oj to aajuc nupanuque. Ja tihui mi xa ma' oj yii sbaje. Oj ajyuque jastal ja ángel jumasa ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero ja Diosi yala ni que oj ni sac‑huuc ja ma' huax chamyei. Bob ta mey xa q'uelahuex ja suuni: ");
INSERT INTO tojNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja queni sDioson ni ja Abrahami, sDioson ja Isaqui, sDioson ja Jacobi, xchi ja yabal ja Diosi. Como ja Diosi, mi huax yila ta ay ma' chamel. Puro ni sac'an huax yilahuotica, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Cuando yab ja cristiano ja jastal iti, jel och ja spensare ja jas huan seejel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pero ja fariseo cuando ch'ac yabye que canye jac'an ja saduceo jumasa, ti cho huajye jun nole ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ay june ja yenlei, jel vivo. Jel huas snaa soc ja smandar ja Moisesi. Oj bi sc'ul probar ja Jesusi. Ti soboa: ");
INSERT INTO tojNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ja ba spetzanil ja smandar ja Moisesi, ¿bay ja mas t'ilani? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ti yala ja Jesusi: ―Yaj oja huab ja Huajual Diosi soc spetzanil ja hua c'ujoli, soc spetzanil ja hua hualtzili, soc spetzanil ja hua pensari. ");
INSERT INTO tojNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ja mandar iti, ja' mero mas t'ilan soc mas nihuan. ");
INSERT INTO tojNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Soc ay otro mandar oj slaj ja iti: Ja jastal huaxa yajta baj ja huen mismo, jach oja yajta ja hua moji. ");
INSERT INTO tojNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ta mi c'a ayuc ja chab mandar jahui, lom ni ja tuc smandar ja Moisesi soc lom ni ja jas yala ja otro aluman‑Dios jumasa. Mas jel t'ilan ja chab mandar jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Como ti ni tzomane ja fariseo jumasa, ja Jesusi ti sobo yilea: ");
INSERT INTO tojNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―Ja Cristo, ¿jas la chiyex soc ba? ¿Ma' yintil ba? Jaxa yenlei: ―Pues ja' ni ja yintil ja rey Davidi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","―Pues meran nia, pero mi cualquierauc. Ay jas yala ja Davidi, pero julbesnubal yuj ja Santo Espíritu. Ata huabilex: ");
INSERT INTO tojNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ja Dios Tatali ti yal yab ja Cajual Cristoi: Quechan ja huen oj ajyuc ja huatel mas tzatz. Oj caa ba yib ac'ab ja hua condra jumasa, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ja huabyex que yajualan ja Cristo ja rey Davidi, iday, yena ni yintila, ¡pero mi tox manxi ja ora jahui! ¿Jastal xa ay ja jahua? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ti ch'ac canuque jac'ana. Masan ja c'ac'u jahui ti scomo sbaje juntiroa. Mi xa ma' huax yaa sbaj ba oj sc'ul probar ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ja Jesusi ti yal yab ja jun nole cristiano tey tihui soc ja snebuman jumasa: ");
INSERT INTO tojNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ja fariseo jumasa soc ja matic huas sea ja smandar ja Moisesi, ja' ni xchole huas seahue ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bueno, ja jas huas sea huilex soc ja stiei, c'uanic, pero ja jastal ja smodoei, moc atzajlayex. Jel tzamal ja jas huax yalahuei pero iday, mi huas sc'ulane. ");
INSERT INTO tojNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Lajan soc huas stz'alahue yi jun nihuan scarga ja cristiano, ti huax ya scuchea, jaxa yenlei, jach xta xbuchbuniye eq'ue. ");
INSERT INTO tojNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Spetzanil ja jas huas sc'ulane ja yenlei, siquiera ba lec oj iljuque yuj ja cristiano. Jaxa yal scajone huas smochohue ja ba spatanei, mas jel xa nihuan huas sc'ulane ja huego. Jach ni ja snich ja sc'uei, mas najat huas sc'ulane. ");
INSERT INTO tojNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jaxa huax huajye ba jun huaelal, huan ita sq'uelahue ja lugar ja ba mas tzamali. Jach ni ba yoj yiglesiaei, ti ni huax huajye ja ba huax och culan ja ma' ay yateli. ");
INSERT INTO tojNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jaxa ba plaza, jel sgustoe oj jac tajuc sc'abe. Huas sc'ana oj aljuc yabye: Maestro, Maestro, oj utjuque. ");
INSERT INTO tojNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero ja huenlexi, mi lom x'oc' ac'ujolex que oj aljuc ahuabyex Maestroil. Ay ni hua Maestroex meran ni, pero quechan june, ja' ni ja Cristoi. Jaxa huenlexi, puro ahuermano abajex. ");
INSERT INTO tojNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Soc quechan june ja hua tatexi, ja' ni ja ma' tey ba satq'uinali. Mi lom jel xa huiajex snihuanil jun cristiano ba mi sbejuc oja tatuquexi. Moc lomuc hua ochuquex diosil jun cristiano ja ba luumi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Moc lomuc ac'anex que oj aljuc ahuabyex jepeil porque quechan june ja hua jepeexi, ja' ni ja Cristo. ");
INSERT INTO tojNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pero ja huenlexi, ja ma' yutzil sc'ujol huas scolta ja yermano, ja yeni, mas nihuan oj iljuc yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pero ja ma' jel nihuan huax yaa sbaji, ch'in ni oj aaji huajuca. Pero ja ma' huax yaa sbaj ch'ini, jel nihuan oj aaji huajuc. ");
INSERT INTO tojNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Ay pobre ja huenlex ja huanex seejel ja smandar ja Moisesi! Jach ni ja huenlex fariseo, ¡toj chab cara ayex! Huaxa macahuex sbej ja cristiano ja ma' huas sc'ana oj yaa sbaj ja ba sc'ab ja Diosi. Mi xa huaa bajex ja huenlexi, jaxa ma' huas sc'ana yaa sbaji, huaxa comohuex. ");
INSERT INTO tojNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ay pobre ja huenlex ja huanex seejel ja smandar ja Moisesi! Jach ni ja huenlex fariseo, ¡toj chab cara ayex! Huaxa japahuex yi ja snaj ja viguda jumasa, entonces ti huax och ac'umuquex ja Diosi, pero albel juntiro. Ja jastal jahui, oj ni aajuc ahuilex ja ba mas nihuan ja castigo. ");
INSERT INTO tojNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ay pobre ja huenlex ja matic huanex seejel ja smandar ja Moisesi! Jach ni ja huenlex fariseo, ¡toj chab cara ayex! Eso sí, c'atan xta ayex eq'ue. Hasta huaxa c'utzuhuex ja mari huala huajyex ja ba lugar jumasa siquiera oj sc'uuc ja cristiano jastal huaxa c'uanex ja huenlexi. Iday, cuando huax ch'ac sc'uuquei, yuj ja hua tz'acatal ja huenlexi, huax jomye mas. Eso sí, lajan soc ja' amojex ja diablo ja huenlexi pero ja yenlei, ¡mas to pegor huax hua huajuquex! ");
INSERT INTO tojNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ja huenlexi, lajan soc mi xa huila jastal huanex bejyel. Jach ni ja cristiano, jel huaxa lolayex juntiro. Ata jasunc'a huaxa hualahuexi, quera oj c'uajuc ahuilex ja jas huaxa hualahuexi. Quechan ta ay c'a ma' huas staa ti' ja templo, ja jahui, mi jas yioj la chiyex. Pero ta ja' c'a yoroil ja templo huas staahue tii, ja jahui, oj ni c'ot smeranila, la chiyex. Jach huaxa lolayex ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ja huenlexi, jel tontoex. Lajan soc mutz'an ja hua satexi. ¿Jas yioj ja oro? Mi c'a jauc ba yoj templo, jun cualquiera taq'uin. Ja queni, mas t'ilan huax cab ja templo que soc ja oro. ");
INSERT INTO tojNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Soc huax cho hualahuex ta ay c'a ma' huas staa ti' ja juegon ba huas tzicxi ja smajtan ja Diosi, mi jas yioj, la chiyex. Pero ta ja c'a huax taxi ti' ja smajtan Dios ti cajan ja ba sat ja juegon jahui, entonces t'ilan huax c'ot smeranil ja jas huax yala, la chiyex. ");
INSERT INTO tojNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ja huenlexi, jel tontoex. Lajan soc mutz'an ja hua satexi. Yuj ja juegon jahui, jayuj ja chante ti cajan ja tihui huax pax smajtanil ja Diosi. Ja juegoni, iday, mas to jel t'ilan juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ja ma' huax ya och testigoil ja juegoni, mi quechanuc ja juegoni. Jach spetzanil ja jas ti cajani, ja' ni ja smajtan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jaxa ma' huax ya och testigoil ja templo, mi quechanuc ja templo. Jach ni spetzanil ja jas ay ba yojol ja templo. ");
INSERT INTO tojNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jach ni spetzanil ja ma' huax ya och testigoil ja satq'uinali. Ja' ni ja lugar jau ba jel tzamal ti culan ec' ja Diosi, soc jach ni ja ma' ti culan ec' ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ay pobre ja huenlex huanex seejel ja smandar ja Moisesi! Soc jach ni ja huenlex fariseo, ¡toj chab cara ayex! Hasta arabueno, hasta eneldo, hasta cominos huaxa huaahuex lec cuenta. Ja ba cada lajunei, ti huax hua eluquex jujune ja ba smajtan ja Diosi, jaxa ba mas t'ilan ja mandari, mi ni t'un huaxa huaahuex yi casoa. Mi xa naa jastal oja talna syaujulal ja hua moji. Mi ni t'un huaxa c'uanex ja Diosi. Jel lec huaxa huaahuex yi ja Dios ja hua c'ulexi pero mi lec huaxa huaahuex can jun lado ja ba mas t'ilani. ");
INSERT INTO tojNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Meran huax cala, lajan soc mi xa huila jastal huanex bejyel. Ja ba ch'ini, ja' huaxa huaahuex caso, jaxa ba nihuani, mi huaxa huaahuex caso. ");
INSERT INTO tojNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ay pobre ja huenlex huanex seejel ja smandar ja Moisesi! Soc jach ni ja huenlex fariseo, ¡toj chab cara ayex! Ja ba spatic ja vaso soc ja plato huaxa sac'ahuex, jaxa yojoli, quistal juntiro. Jach ni mero ay ja hua c'ujolexa. Huan ni la elc'aniyexa porque jach ni jex c'anc'oni ahuujilexa. ");
INSERT INTO tojNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo chorocos! Sac'ahuic bajtan ja ba yojol ja hua vasoexi soc ja hua platoexi, jaxa spatic, sac ni oj ajyuca. ");
INSERT INTO tojNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ay pobre ja huenlex ja ma' huanex seejel ja smandar ja Moisesi! Soc jach ni ja huenlex fariseo jumasa, ¡toj chab cara ayex! Ja' mero amojex ja yal naitz ba campo santo, ja snajtzil ja rico jumasa ja ma' huax chami. Ja sparedeili, c'ulubal lec blanquear. Tojbel lec iday, ja ba yojoli, ti but'el ja sc'aelal ja chamhuiniqui. Jel tuu juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jach mero ayex ja huenlexi. Ja ba fuera, jel toj huaxa jea bajex soc ja hua mojex jumasa, pero ja ba hua c'ujolexi, toj chab cara ayex. Quechan cajan ac'ujolex ja maloili. ");
INSERT INTO tojNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ay pobre ja huenlex ja huaxa jeahuex ja smandar ja Moisesi! Soc jach ni ja huenlex fariseo jumasa, ¡toj chab cara ayex! Ja ba canele mucan ja aluman‑Dios jumasa, jaxa huenlexi, ti huaxa c'ulanex ja snajtzil ja sq'uejnalei. Huax hua tzatzjuquex lec ja ba mucane ja matic jel toji. ");
INSERT INTO tojNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ti huaxa hualahuexi: Ja lec ti xa ayotic ja yora ec' ja aluman‑Dios jumasa iti, mey xchamyea. Ja quentiqui mi ni nunca oj miltic como jastal sc'ulan ja jun lame jahui, la chiyex. ");
INSERT INTO tojNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ata huabil ja jas huaxa hualahuexi, iday, ja' ni mero ja ec' pax ta huujilex ja jun lame jau ja ma' ch'ac smil ja aluman‑Dios jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pero mi tz'icui yujile ja smaloil ja yenle ja jau jumasa. ¡Aahuic xa tz'ic‑huuc qui ja huenlexi! ");
INSERT INTO tojNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Toj chanteex! Ja' amojex ja chan it huax c'uxhuani. ¿Huan ma xa hualahuex ta mi ti oj aaji ochanic ja ba inpierno ba? ");
INSERT INTO tojNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Oj xa jeca huilex ja ma' oj xchol ahuabyex ja yabal ja Diosi. Ja yenlei ay svivoil yuj ja Diosi. Jel huas snaahue ja suun ja Diosi, pero anima, ay ma' oja milex. Ay ma' oj huaahuex locan ba cruz soc ay ma' tey ba yoj ja hua huiglesiaex ti oj och amaq'uex leca. Jaxa tuqui, cada lugar ja ba huax huajye, ti nochanex ec' soca. ");
INSERT INTO tojNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","¡Jel lec juntiro ja jas huaxa c'ulanexi! ¡Ochanic mas con gana! Jachuc, ¿huan ma xa huala ta mi huenlex oj ch'ac acuchex can ja smul ja ma' milhuani ja najatei? Lom ni spec'a ja xchiq'uele ja matic toj eq'ui. Ja hua moj milhuanum jumasa, jach ni huane sc'ulajel ja ba mundo desde yora milji ja Abeli. Jach lamlamil sc'ulane hasta smilahue ja Zacarías yunin ja Berequiasi. Ja Abeli, jel toj ay juntiro, jaxa Zacariasi, ti smilahue ba templo ba stz'eel ja juegoni. Iday, ¡ja' ni mero amojex ja jau ma' milhuanii! ");
INSERT INTO tojNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","¡Majlayic! Oja huilex ta mi huen oj ch'ac atupex can ja scastigo ja jau jumasa. Huen xa ni cajan abajex spetzanila. ");
INSERT INTO tojNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡A jerusaleño suinquil ja Jerusaleni! Huaxa milahuex ja aluman‑Diosi. Soc ton huaxa milahuex ja matic huax jecji ahuilex. Mi naben jaye vuelta huax c'ana oj tzomex can jastal ja gallina huas stzomo ja yuntiquili, ti huax yaa ba yibel ja suech'i. Pero mi ni modo xa c'anahuexa. ");
INSERT INTO tojNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","¡Ay pobre ja huenlexi! Oj xa can lutan ja hua najexi. ");
INSERT INTO tojNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quechan xta huaxa huilahuonex ja huego. Eso sí, oj to ahuilonex, pero ja ora jahui: Stz'acatal ja ma' huax jac yuj ja sbiil ja Cajualtiqui, oj chianic. ");
INSERT INTO tojNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ja Jesusi ti el ja ba templo. Ti xa huajuma cuando ti ch'ac jac c'uban ja snebuman jumasa, jaxa yenlei ti och stae ti' ja jastaltic ay ja naitz jumasa ja ba templo. ");
INSERT INTO tojNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ti yala ja Jesusi: ―¿Ch'ac ama huilex ba? Pues ja naitz jumasa jahui, mi ni jun ton oj can latzana. Oj ch'ac jem spetzanil, pero meran, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Cuando c'otye ja ba huitz Olivosi, ti och culan ja Jesusi. Ja snebumani ti huaj sc'umuque c'ubana. Quechan ita yenle, mey otro: ―Cajual, ala cabticon ¿jas ora oj c'ot smeranil ja jasa hualunej cabticon ba? ¿Jas señail oja jee cuando oj xa jacani, cuando oj xa c'ot tic'an ja tiempo jumasa iti? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ti yala ja Jesusi: ―Aa cuidadoex moc ma' oj slolayex, ");
INSERT INTO tojNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porque jel ja ma' oj yii majan ja jbiili: Quen ja Cristooni, oj chiuque. Jel ni ja ma' oj lolajuqui. ");
INSERT INTO tojNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Oja huabyex yabalil ja guerra. Ja' mero oj sloiltaye ja guerra ja cristiano jumasa pero moc lom chamuc ac'ujolex porque t'ilan ni oj c'ot smeranil spetzanil ja ita. Pero ja jahui, mi to jauc ja mero oj c'ot tic'an ja tiempo. ");
INSERT INTO tojNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ja lugar jumasa, puro coraja oj yil sbaje. Ja gobierno jumasa oj ochuque pleito. Oj cho jacuc ja chamel jumasa, pero mi cualquierauc. Jel oj ajyuc ja huaini, jaxa ba tuctuquil ja lugari, jel oj ajyuc ja templori. ");
INSERT INTO tojNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero ja seña iti, huan tox och q'ueuc, pero ja mas tzatzi, tzaan to ay. ");
INSERT INTO tojNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ja hua condraexi, ja' sgusto ba oj yaa huilex ja huocoli. Oj smilex. Cuando huax yilahuex ja cristiano, lajan soc ja sat tz'i oj yilexi, pero jayuj ahuiojex ja jbiili. ");
INSERT INTO tojNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jayujil jitzan oj snaq'ue ja jbiil ja ora jahui. Jitzan oj yaa endregal ja smoji. Jel coraja oj yil sbaje ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jel ja ma' oj stoy sbaj que aluman‑Dios bii. Oj slolaye jitzan ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oj jelxuc juntiro ja maloili. Ja ma' yaj huax yab ja Dios ajyi, tacal tacal oj ch'ay sc'ujole. ");
INSERT INTO tojNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ja matic oj cuch yujil ja huocoli hasta man xc'ot tic'an ja tiempo jahui, yenle ni ja ma' oj c'ulajuque librari. ");
INSERT INTO tojNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jaxa yajc'achil loil it jastal huan xa sc'ulajel mandar ja Diosi, ja loil iti oj ch'ac pucxuc ja ba spetzanil ja lugari. Cada lugar oj ch'ac cholxuc yabye ja suinquili. Cuando ch'ac ta pucxuqui, ti xa oj c'ot tic'an ja tiempo ita. ");
INSERT INTO tojNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Naahuic que ja cuando huaxa huilahuex ja cosa jau jel quistal juntiro tey ba yojol ja templo jau mi cualquierauqui, entonces mi xa najatuc ay ja chamel ch'aqueli. Ja aluman‑Dios Daniel staa ni ti' ja cosa iti, jaxa ma' huas sq'uela ja suun ja Danieli, a yab sbej. ");
INSERT INTO tojNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jaxa suinquil ja Judea, cuando huax yilahue ja tan quistal cosa jahui, aa xa spaque ajnel ba huitz. ");
INSERT INTO tojNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ja ora jahui, ta ay c'a ma' tey ba xchabil lame ja naitzi, cuando huax coi, toj eq'uel a huajuc. Moc xa lom jas oj och yii ja ba yoj snaji. ");
INSERT INTO tojNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jaxa ma' tey ba huitzi, moc xa lom oj cumxuc oj huaj yii ja sc'ui. ");
INSERT INTO tojNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Jel ajul ja sbaj ja ma' cuchan yuj ja nihuac chameli soc ja ma' ay to yioje ja yal alatz huan to chuuneli. ");
INSERT INTO tojNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","C'anahuic yi ja Diosi cuando ora oja paquex ajneli que mi jauc stiempo chee soc mi jauc ja sc'ac'uil ja jijeli. ");
INSERT INTO tojNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porque ja huocol iti, jel tzatz juntiro. Quechan huocol mas tzatz ja iti masan cujlaji ja satq'uinali soc mi ni nunca oj jac otro vuelta ja jastal iti. ");
INSERT INTO tojNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ja huocol jau jel tzatzi, mi c'a com tic'anuc t'usan, mi ni june ma' oj cuch yuja. Pero como ay to ni ma' stzauneji, jayuj huan to sbisjel t'usan ja huocoli. ");
INSERT INTO tojNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pero ta ay c'a ma' huax jac yala huabyex: Q'uelahuilex, jul bi ja il ja Cristo, ma q'uelahuilex, ti bi aya, pero moc lomuc ac'uuquex. ");
INSERT INTO tojNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ay ni ma' oj yal que Cristoa soc ay ma' oj stoy sbaj que aluman‑Dios bi. Oj sea huilex jitzan cosa ba mi ni nunca ahuilahuex. Oj bob sc'uluque jitzan milagro. Hasta ja ma' tzaubal ni yuj ja Diosi oj slolaye. ");
INSERT INTO tojNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pero con tiempo huax cala huabyex. ");
INSERT INTO tojNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ta huan c'ax yala huabyex: Q'uelahuile, ja Cristo ti bi ay ba ch'ayan lugar, ta xchiye c'a, moc lom huajanic. Ta huan c'ax yalahue: Q'uelahuile, tey ba yoj naitz, ta xchiye c'a, moc lomuc ac'uuquex, porque lom nia. ");
INSERT INTO tojNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porque cuando ora oj cho cocon jan otro vuelta ja ba satq'uinali, jel tuc juntiro. Jach oj jacon jastal huax lijpi ja chamtzelau huax ya lijpuc juntiro ja satq'uinali. Y mi ni june ma' mi oj yile. Jach oj cho cocon jani. ");
INSERT INTO tojNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jaxa ora jahui, chican jas tiq'ue mulali, pero t'ilan ni oj ch'ac c'ulajuc castigar como jastal jun chamel cahuu huax co jun montón sbaje ja useji, huax ch'aca ele. ");
INSERT INTO tojNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Cuando huax ch'ac ja huocol ja c'ac'u jumasa jahui, huego huego oj tupuc ja c'ac'u, jaxa luna, oj ch'acuc, jaxa c'anal jumasa, oj ch'ac lujbajuc con ja ba satq'uinali. Oj ni ch'ac syoopes ja yip ja Dios jel tzatz ay ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ti oj iljuc jun nihuan seña ja ba satq'uinali. Ja seña jahui, yuj ni huanon xa coel jana. Jaxa cristiano jumasa ja ba luumi, tuctuquil ja yabalei, naca xta oj st'uxpuc ja sc'abei. Oj yile ti huanon coel jan ja ba asoni soc huanon xa mandar. Oj lijpucon lec. ");
INSERT INTO tojNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Oj cal yab ja cangel jumasa que tzatz lec oj ya oc' ja corneta, ti oj stzom sbaj spetzanil ja ma' tzaubal cuji. Oj stzomtalauc sbaje ja ba xchanil xchiquin ja satq'uinali, ja ba spetzanil ja lugar jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Q'uelahuil ja steil ja higo. Ay jas oj ca jac ac'ujolex soc ja te' jahui. Cuando huaxa huilahuex yaau xa sc'abi, yuj oj xa eluc ja spoohuili, ti huaxa naahuex que q'ue ta stiempo jai. ");
INSERT INTO tojNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jachuc, cuando huaxa huilahuex spetzanil ja cosa iti, naahuic que jel xa mojan ja tiempo ja huocol jahui. Ja' xa nia. ");
INSERT INTO tojNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Huax cala, pero meran, ja jun lame cristiano jahui mi oj chamuque masan to huax c'ot smeranil spetzanil ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ja satq'uinali soc ja luumi oj ni ch'acuca pero ja jas huax cala, t'ilan ni oj c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero ja c'ac'u jahui, soc ja mero yorail oj ec'uc ja cosa jumasa iti, mi ni june ma' huas snaa, mi ni ja ángel jumasa tey ba satq'uinali. Quechan ja Dios Tatal oj snae. ");
INSERT INTO tojNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ja jastal ja tiempo jumasa jau ja ti ajyi ba luum ja Noeji, jach ni oj ajyuc ja cuando la coyon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ja tiempo jau mojan xa oj jacuc ja butjai, ja cristiano, jun xta ja smodoei. Huax huaaye. Huax nupaniye. Huax aaji ch'ac yabalile. Jach sc'ulane hasta c'ot ja c'ac'u jau och ja ba barco ja Noeji. ");
INSERT INTO tojNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mi ni t'un yabye sbej ja jas alji yabyei. Hasta yilahue meran jac ja butjai, ti xa sc'uanea. Cuando huane xa huajel jai, ti snaahue que meran nia. Jach oj cho ajyuc otro vuelta cuando ora oj cho cocon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti aye chab huinique ja ba huitzi. Ja juni oj iijuc, jaxa juni, oj aajuc cani. ");
INSERT INTO tojNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y otro chab ixuc, jun ta aq'uinte huane chee. Ja juni oj iijuc, jaxa juni, oj aajuc cani. ");
INSERT INTO tojNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Chapan ajyanic porque mi xa naahuex jas ora oj jacuc ja hua Huajualexi. ");
INSERT INTO tojNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","C'ulanic t'un pensar. Ja statalil ja yoj naitzi, ta huan c'a snaa jas ora oj jac ja lagroni, oj smacla. Mi oj yaa ja snaj ba oj ochuc ja lagroni. ");
INSERT INTO tojNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jachuc ja huenlexi. Q'uelan jacan ajyanic. Cuando mi jauc huaxa c'ulanex pensari, ja' mero c'ac'u oj cho cocon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jun ajualal, mi cualquierauc ja smozo oj yaa yi ba sc'ab ja snaji. Ja mero yorail ja huaeli, ja' xchol oj yil ta huax ch'ac yii ja suaele spetzanil ja matic tey ba yoj naitzi. Ja mozo jahui jel huax c'uaji soc jel toj ja spensari. ");
INSERT INTO tojNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ta jach c'a huan sc'ulajel tola vida, cuando xul ja yajuali, jel lec oj iljuc juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Seguro oj ni aajuc ba sc'ab spetzanil ja tiempo ja jas yioj ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero ta ay c'a jun mozo, yajni huax yila huax huaj ja yajuali, huan c'ax yala: Ja cajuali, mi baq'uin oj cumxuc, ta xchi c'a, ");
INSERT INTO tojNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ti huax och yixtalauc ja smoj mozoili. Huas smojan ja yacbum jumasa. Huas smojan huael, huas smojan yuujel trago. ");
INSERT INTO tojNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Iday, cuando mi jauc huas sc'ulan pensar, huan tox huaj yile, tey ja yajuali. Mi ni t'usan huas snaa ta oj xa jacuc ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jaxa ajualali, jel tzatz oj yaa yi ja scastigo. Ti oj nutzjuc soc ja matic toj chab cara ayi, jaxa tihui, puro oq'uel. Oj xta jechjeljuc ja yejei yuj ja jel ja huocoli. ");
INSERT INTO tojNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ja c'ac'u jau oj ochuc ja cristiano ja ba lugar ja ba huas sc'ulan mandar ja ma' tey ba satq'uinali, lajan soc ja jastal sc'ulunej ja lajune soltera. Yiaje cada jujune ja scandilei, ti elyea. Huajume ja ba jun ch'ac abal ba oj smojtaye ja nupanumi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ja soltera jumasa, ja johuanei, jel bobae, jaxa johuanei, lista xta aye. ");
INSERT INTO tojNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ja soltera ja ma' jel bobaei, jel tanteado yioj ja sbaal ja scandilei, ");
INSERT INTO tojNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jaxa ma' lista, but'el yioj ja scandilei, y cho yiaje otro pilan. ");
INSERT INTO tojNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ja nupanum it trato ay oj huaj staei, iday, mix julye. Jaxa soltera jumasa jahui jac snecuele. Ti och ja suayelea. ");
INSERT INTO tojNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Iday, como nalan acual ti yabye jun ahuanela: ¡Ti xa huax jac ja nupanumi! Cax xa taahuic, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ti q'ueye spetzanilea. Ya ajluc ja scandilei. ");
INSERT INTO tojNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero ja johuane ja ma' jel bobaei ti yalahuea: Aa quiticon t'usan ja sbaal ja hua candilexi. Huan xa tupel ja jbajticon tac, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jaxa matic lista ti yalahuea: Mi ma yena. Ta huan c'ax caaticon ahui, mi ni ja jbajticoni, mi oj yae. Mas lec, cax manahuic ja ba huax chonxi, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ti huajyea. Iday, mi tox c'otye cuando jul ja nupanumi. Jaxa ma' lista xta ni ayei, ti xa huaj soc ja nupanumi. Ti c'otye ja ba oj ajyuc ja ch'ac abali. Ti xa lutji can ja puertaa. ");
INSERT INTO tojNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jaxa mas tzaani, c'otye ja johuane ja ma' jel boba, ti yalahuea: Cajual, cajual, jama quiticon ja puerta, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero ja nupanumi ti yalaa: Ja smeranili, mi nix naa bajexa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ti xa yala ja Jesusi: ―Jachuc ja huenlexi, q'uelan jacan ajyanic porque mi ni oja naex jas ora oj cocon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ja huenlex ja matic mandar xa ac'ubalex yuj ja ma' tey ba satq'uinali, lajanex soc ja smozo jun ajualal. Ja ajualal jahui huajum xa ba jun lugar ba najat lec. Pero ja mi tox huaji, ti huas spaya jan ja smozo jumasa. Huax yaa can ba sc'ab ja jas yioji. ");
INSERT INTO tojNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ja june ja smozoi yaa yi joe mil peso, jaxa otro jun smozo, yaa yi chab mil peso, jaxa otro jun smozo, quechan jun mil peso yaa yi. Ja jun jel vivo, yaa yi mas, jaxa chahuane ma' mi jel vivouqui, menos yaa yi. Yajni ch'ac spil can ja staq'uin ja ajualal jahui, ti xa huaj najat leca. ");
INSERT INTO tojNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ja ma' sc'ulan recibir ja joe mil peso jahui ti huaja. Huaj ya atjuc ja staq'uini. Huaj to yile, ay xa yioj otro joe mil peso mas. ");
INSERT INTO tojNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Soc jach ni ja jun mozo jau aaji can yi chab mil peso. Sc'ulan ganar otro chab mil ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ja ma' aaji can yi quechan jun mil peso ti huaj smuc can ja ba luumi. Huaj snac' can lec ja staq'uin ja yajuali. ");
INSERT INTO tojNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Jaxa yajual ja mozo jumasa, cuando albi ta jan lequi, ti xa jula. Ti xa sobo yi ja smozo jumasa jastal ay ja scuentaei. ");
INSERT INTO tojNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ti jac ja ma' sc'ulan recibir joe mili. Cho yiaj jan otro joe mil: Cajual, ja huaa can qui joe mil peso. Oj xa jc'uluc ahui entregar ja huego. Caa ta ni pojxuc ahui otro joe mil, xchi ja mozo jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ti yala ja ajualali: Pues jel lec juntiro. Jel lequil huinica juntiro. Jel lec ja hua huateli. Jel t'usan caa hui pero jel lec ja jas ac'ulan soqui. Ja yaani oj caa hui, pero jitzan. Ja queni ahuajualon y jel gusto ayon juntiro. Jach ajyan gusto ja hueni, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ti jac ja mozo jau ja ma' aaji can yi chab mili: Cajual, ja huaa qui chab mil peso. Oj xa jc'uluc ahui entregar ja huego. Caa ta ni pojxuc ahui otro chab mil, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ti yala ja ajualali: Pues jel lec juntiro. Jel lequil huinica juntiro. Jel lec ja hua huateli. Jel t'usan caa hui pero jel lec ja jas ac'ulan soqui. Ja yaani oj caa hui, pero jitzan. Ja queni ahuajualon y jel gusto ayon juntiro. Jach ajyan gusto ja hueni, x'utji yuj ja yajuali. ");
INSERT INTO tojNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ti jac ja mozo ja ma' sc'ulan recibir quechan jun mil peso: Cajual, huax naa que c'ac'al huinica. Pavor huaxa huiaj sbaal ja hua hualaji, iday, mi ahuateluc ja huena. ");
INSERT INTO tojNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jayuj huaj mus can luum ja taq'uin ja huaa can qui. Huanon xihuel ahuuj jayuj huan xax c'ulan entregar ahui, xchi ja mozo jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","¡Ay mozo, jel malo juntiro ja hua c'ujoli! Mero jaragana juntiro. ¡Entonces pavor huala huaayon ta jachuqui! Mi quenuc huas tz'unu ja calaji. Jach huana yaljel cabi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mas lec oj elan ajyi ja lec huaa to och qui ba banco ja jtaq'uini. Ja tihui oj alinuc. Anima quechan t'usanuc ja yal oj c'ul recibir ajyi, xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ti yal yab ja tuc mozo jumasa: Japahuic yi ja taq'uin jahui. Ja' oj yii ja ma' yioj lajune mil peso, ");
INSERT INTO tojNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porque ay cristiano ay ni jas yiojea, y ay ni jas oj aajuc yi masa. Ay ni jas mas oj sbajuquea. Cho ay cristiano jel t'usan ja jas yiojei, pero ja t'usan jahui, oj japjuc yile. ");
INSERT INTO tojNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Jaxa mozo iti, nujtzinic el ja ba yoj q'uiq'uinal. Y ¿jas yateluc cuj? Mix maconi tac. Eso sí, ja tihui jel ja oq'ueli. ¡A huaj ya jechjeljuc ja yeji! xchi ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ti cho yala ja Jesusi: ―Ja queni oj ni cho cocon jan ja ba satq'uinali, jaxa ora jahui, oj ni lijpucon juntiroa. Ja' ni jmoj spetzanil ja ángel jumasa. Ti oj tul ja catel jau mi cualquierauqui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jaxa ba sti jsati, ti oj tzomjuque spetzanil ja suinquil ja lugar jumasa. Jaxa queni oj ch'ac jpile. Ja jastal jun talnachej huax yaa pilan ja xcheji soc pilan ja chibo jumasa, jach oj c'uluc ja quen ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ja ba lado stojol jc'abi, ti oj caa ja jcheji, jaxa ba lado surdero jc'abi, ti oj ch'ac caa ja chiboi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ja ora jahui, quena ni hua reyonexa. Oj c'ul mandar. Oj cal yab ja ma' tey ba lado stojol jc'abi: Q'uelahuilex, ja huenlex ja ma' ahuiojex ja sbendicion ja jTati, laic xa. La ochanic ja ba huas sc'ulan mandar ja Diosi. Ja mi tox cujlaji ja satq'uinali, jach ni st'ujpinex ja Diosi ba ti oj ajyanic ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ja yora jel huain xcabi, ja huaahuex huaacon. Cuando taquin jtii, ja huaahuex cu ja'. Cuando ula ayon ja ba hua lugarexi, ja locohuonex ja ba hua najexi. ");
INSERT INTO tojNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Meyuc ja jc'ui pero ja huaahuex qui ja jc'ui. Cuando maloaxiyon, huaj ahuilonex. Cho lutjiyon preso pero huaj ahuilonex. Jach oj cal ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jaxa jun c'ole matic naca toj ayei, ti oj yalea: Cajual, pero mi ni nunca quilaticon huain xa huab tac. Mi ni ba caaticon ahui ahuaeli. Ala cabticon ba, ¿jas ora caaticon ahui ja' oja huu cuando taquin ati' ba? ");
INSERT INTO tojNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Cuando huana ulataneli, huaxa huala que jlocohuaticon ja ba jnajticon. Pero lajan soc mi jc'ulanticon ahui jach tac. Mi ni nunca quilaticon que meyuc ac'u soc mi caaticon ahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jas ora maloaxiya ba? ¿Jas ora lutjiya preso? ¡Mi ni huaj quilaticon tac! Jach oj yal ja jun c'ole ja ma' toj ayei. ");
INSERT INTO tojNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Como quena ni reyon ja ora jahui, quena ni ayex ba jc'aba. Ti oj cala huabyexa: Pero jachuc ac'ulanex tac. Mi quenuc mismo, pero lajan soc quena nia. Ja mero smeranili, ja c'ulanex yi ja quermano iti, jaxa yeni bob ta mas ch'in que apetzanilex, pero quena ni hua coltayonexa. ");
INSERT INTO tojNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jaxa jun c'ole tey ba jsurdero, ti oj cal yabyea: Elanic ja ba jtz'eel ja huenlexi. Najat juntiro ni ahuiojonexa, oj cute. Ti oj ajyanic ba yoj c'ac' jau ba mi ni nunca oj tupuqui. Ja c'ac' jahui, ac'ubal ni ba oj ajyuc ja diablo soc ja smozo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ja yora huain xcabi, mi ni jas ahuaahuex qui t'usana. Cuando jel taquin juntiro ja jtii, mi ni t'un ja huaahuex quia. ");
INSERT INTO tojNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ula ayon ja ba hua lugarexi pero mi ahuaahuex qui majan ja hua najexi. Ja huilahuex que basanon pero mi ni ahuaahuex qui jc'ua. Maloaxiyon, ti ajyiyon lutan preso, pero mi ni t'usan huaj ahuilonex. Jach oj cal yabye ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ti oj yal ja jun c'ole jahui: Pero Cajual, mi ni t'un quilaticon que huain xa huabi, que taquin ati'. Mix naaticon ta jacya ulatanel. Mi quilaticon ta ajyiya basan. Mi cabticon ta maloaxiya, mi ni ta lutjiya preso. Mi ni t'usan huax naaticon ta mey xcoltayaticon, oj chiuc ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Q'uelahuilex ja jun quermano iti. Ja yeni mas jel ch'in juntiro ahuilahuex. Mi acoltayex. Pero mi yenuc. Quena nia. ");
INSERT INTO tojNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ja jun c'ole ba jsurderoi, ti oj huajuc ja ba lugar jau ba mi ni nunca huax ch'ac ja castigo, jaxa jun c'ole ja ma' toj ayei, oj ochuque ja ba lequil vida ba mi ni nunca oj ch'acuc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuando ch'ac ta aljuc yabye jachuc ja cristiano yuj ja Jesusi, ti xa cho yal yabye ja snebuman jumasa: ");
INSERT INTO tojNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Huan ni xa naahuex que jel xa mojan ja syalq'uinali. Quechan xta chab c'ac'u huas sc'ana. Meran nia, ti coyon jan ja ba satq'uinali pero ja mero sc'ac'uil ja q'uini, ja' mero ora jau oj c'ulajucon endregar ba oj aajucon locan ba cruz, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti stzomo sbaje ja nihuac spagreil ja judio jumasa soc ja ma' banquilal ay yujile ja cristiano. Ti ch'ac huaj sta sbaje ja ba spatioil ja snaj ja pagre mas nihuani, Caifás sbiil. ");
INSERT INTO tojNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ti och yii yabal sbajea jastal oj bob syame ja Jesusi pero ch'aban ti' abal oj sc'uluque ba oj bob smile. ");
INSERT INTO tojNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ti yalahuea: ―Pero mi jauc ja sc'ac'uil ja q'uini porque ja cristiano, ay modo oj q'uecotic soc pleito, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jaxa yen ja Jesusi ti huaj ba jun yal hacienda Betania sbiil. Huaj ulatanel ja ba snaj ja Simón ja ma' huax alji sbaj yajchamel xta ajyi yuj ja huan c'ael ja sbacteli. ");
INSERT INTO tojNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ti jac jun ixuca. Yiaj jan yi jun perpume ba jel ja stz'acoli, jaxa yetali, c'ulubal soc jun ton alabastro sbiil. Ja Jesusi tey ba mesa, jaxa ixuqui ti jac spec' yi ja ba s'olomi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Pero ja snebuman jumasa, cuando yilahue ja jas ch'ac sc'uluc ja ixuqui, ti q'ue ja scorajaei. ―¡Jel lástima juntiro jach huax ch'ay lom ja perpume! ");
INSERT INTO tojNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mas lec huan tox chonxi, caro lec oj chonxuc ajyi, jaxa stz'acoli, oj aaxuc yi ja ma' pobre, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero ja Jesusi huas snaa jasunc'a huane yaljeli. ―¿Jasyuj huanex staajel ti' ja ixuc iti? Jel tzamal juntiro ja jas sc'ulunej quii. ");
INSERT INTO tojNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ja matic pobre, tola vida oj ajyuc amoquex pero ja queni, mi tola vidauc oj ajyucon amoquex. ");
INSERT INTO tojNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ja ixuc iti, eso sí, spec'a qui ja ba jcuerpo ja perpume pero mi lomuc. Huan xax chapahuon ja ba jmuculabili. ");
INSERT INTO tojNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jaxa abal it ba jel tzamali, chican ba lugar ja ba spetzanil ja mundo oj to cholxuqui, oj ni abjuc ja jas sc'ulan qui ja ixuc iti. Mi ni nunca oj ch'ay snaajel ja jas sc'ulani, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Entonces june ja lajchahuane snebumani, Judas Iscariote sbiil, ti huaj sob yi ja pagre mas nihuaqui: ");
INSERT INTO tojNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","―¿Jaye ma oj bob ahuaex qui ta huan c'ax bob oj c'uluc ahuilex endregar ja tan Jesusi? xchi ja Judasi. Jaxa yenlei ti yalahuea: ―Pues oj caaticon ahui treinta sat taq'uin puro plata, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jaxa Judasi, cuando yab ja jachuqui, ti slea modo jastal oj sc'ul endregar ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ja c'ac'u jumasa jau culan yujile huas sueahue ja pan it mey slevaduraili, pero ja mero sbajtanil c'ac'u huax q'ue stule t'ani, ti jac ja snebuman jumasa. Ti yalahue yab ja Jesusi: ―Cajual, syalq'uinal xa tac. ¿Ba oj c'uxtic ja cheji ja jastal huan nix c'uxutiqui? Ala cabticon ba, ti oj huaj chapticona, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ti yala ja Jesusi: ―Caxic ja ba chonabi. Ja tihui ay ma' oja taex, ti oja hualex yaba: Ja Maestro, jel xa bi mojan ja yora. Ti bi ja ba hua naji, ti bi oj ec' cujticon ja syalq'uinali. Oj bi jac ja yeni soc ja quenticon janec' ayoticon ja snebumani. Jach oja hualex yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jaxa snebuman jumasa ti huaj sc'uluque ja jas alji yabye yuj ja Jesusi. Ti xchapahuea ja ba oj ec' yujile ja syalq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuando och ja acuali, ti xa ochye ba mesa ja Jesusi soc ja lajchahuanei. ");
INSERT INTO tojNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Cuando snalan ja suaelei, ti alji yabye yuj ja Jesusi: ―June ja huenlexi oja c'uluconex endregar, pero meran, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jaxa yenlei ch'ac jom juntiro ja s'olomei. ―¿Machunc'a ba Cajual? ¿Quen ama? Jach ch'ac sobe cada jujune. Jel tristeaxiye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ti yala ja Jesusi: ―Pues june ja ma' lajan huanon xchicjel soc ja juaeli, yena ni oj sc'ulucon endregar. ");
INSERT INTO tojNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Meran nia, ti ni coelon jan ja ba satq'uinali pero oj ni chamcona, como jach ni tz'ijbanubal ja ba yabal ja Diosi. Pero ¡pobre ja huinic jau ja ma' oj sc'ulucon endregari! Mas lec moc to manxuc ja huinic jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ti yala ja Judas ja ma' sc'ulan ni endregari: ―¿Machunc'a ba Maestro? ¿Quen ama? ―Pero huen ta ni huaxa huala baja, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Cuando mojan xa oj ch'ac huauquei, ti syama jun pan ja Jesusi. Ti sc'ana yi stz'acatal ja Diosi. Ti xet'aa. Ch'ac yaa yi ja snebuman jumasa. ―Iajic. Hueanic. Ja iti, ja' xa ni ja jcuerpoa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ti syama jun vaso but'el yaalel tz'usub. Yaa yi stz'acatal ja Diosi, ti cho yaa yi ja snebuman jumasa. ―Uc'anic apetzanilex. ");
INSERT INTO tojNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Porque ja' xa ni ja jchiq'uela. Ja Diosi sc'ulunej jun yajc'achil trato soc ja cristiano, ja' cuando xpec' ja jchiq'ueli, oj bi huajuque libre jitzan cristiano soc ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ja yaani, mi xa oj to cu otro vuelta ja yaalel ja tz'usubi. Man to cuando ti xa aytic jpetzaniltic ja ba lugar jau ja ba huas sc'ulan mandar ja jTati, ti xa oj ch'ac xiitalauc jbajtic yuj jel ja jgustotiqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Cuando ch'ac yale jun stz'eboj Dios, ti huajye ba huitz Olivosi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ti yala ja Jesusi: ―Ja jastal oja huilex oj ec' cujil ja yaan acuali, oj xihuanic juntiro. Oja ch'ayon ac'ujolex, como jach ni tz'ijbanubala: Oj ca yajbuc ja tanumcheji, jaxa jun nole ja xcheji, sactantan oj ch'ac huajuque. Jach ni huax yala ja yabal ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero cuando la sacuiyoni, ti oj huajcon ba Galileaa. Tix cho la huajyex ja huenlexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pero ja Pedro ti yalaa: ―Ja tuqui bob ta oj xch'aya sc'ujole pero ja queni, miyuc. ");
INSERT INTO tojNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ti yala ja Jesusi: ―Huax cala, pero meran, cuando mi tox oc' ja gallo ja yaan acuali, oxe vuelta oja hual que mi xa naa jbaj. ");
INSERT INTO tojNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","―Pero miyuc. Anima huala chamyon amoc lajan, pero mi ni nunca oj cal que mix naa baj, xchi ja Pedro. Jach ni ja tuc snebuman jumasa, jach ni ch'ac yale chomajquila. ");
INSERT INTO tojNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ja Jesusi soc ja snebuman jumasa ti c'otye ba jun lugar sbiil Getsemaní. Ti yalaa: ―Culananic ja ili, jaxa queni, ti oj huaj c'umuc ja Dios ja tihui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ti alji yabye ja Pedro soc ja chab yuntiquil ja Zebedeo que oj huajuque soc. Jaxa Jesusi ti syatz'a sbaj ja yaltzili. Mi snaa jas oj sc'uluc. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","―Jel yatz'an juntiro ja caltzili. Lajan soc oj xa chamcon mas ligero. Moc ahuaonex cani. Moc lomuc hua ochuquex ja hua huayelexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ti huaj och otro jun maq'ue mas ja Jesusi. Ti co pacan ba luum. Och sc'umuc ja Diosi: ―Tatey, ta huan c'ax bobi, a ec' qui ja juocol iti, pero mi jauc ja jas huax c'ana ja queni. C'ulan ja jas huaxa c'ana ja hueni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ti xa cumxi ja bay ja Pedro soc ja xchabil ja yuntiquil ja Zebedeo. Naca huane xa huayel staa. Ti yal yab ja Pedro: ―¿Mi ni ma jun ora oj bob atec' ja hua huayelex ba? ");
INSERT INTO tojNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mi lom la huayex. C'umanic ja Diosi ba mi oja ta ja hua mulexi. Ja hua hualtzilexi, jel huas sc'ana oj sc'uluc ja ba lequi, jaxa hua cuerpoexi, jel yaau juntiro. Mey yip, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti cho spila sbaj otro vueltaa. Ti cho och sc'umuc ja Diosa: ―Tatey, ta jel c'a t'ilan oj ec' cujil ja huocol iti, pues chican ja jas huaxa c'ana ja hueni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ti cho huaj ja bay ja oxhuane snebumani. Cho huane huayel staa. Lajan soc but'el tz'iilel ja satei. ");
INSERT INTO tojNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ti cho yaa cana. Ja' xa ba yoxil vuelta huaj sc'umuc ja Diosi. Jun xta mismo ja jas cho yal yab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ti cho jac ja bay ja snebuman jumasa. Ti yalaa: ―¿Huanex to ma huayel ba? Lec xa. Jijlanic xa. Malan xa soca porque ja queni, chapanon xa nia ba oj chamcona. Meran nia, ja queni ti ni coelon jan ja ba satq'uinali pero iday, jpatic huanon iijel. Oj xa aajucon ja ba sc'ab ja mulanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Q'ueanic xa huego. Ata huabyex jastal xcululiye xta jani. Huajtic xa porque ti xa huax jac ja ma' yionej xa jpatiqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mi tox ch'ac el yujila, huaj to yile, ti xa ay ja Judasi, ja' ni june ja lajchahuane snebumani. Smoj jun nole cristiano. Naca ay smachite soc sgarrotee. Jecubale yuj ja pagre mas nihuaqui soc ja ma' banquilal ay yujile ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pero ja mi tox c'otyei, ti alji yabye yuj ja Judas ja ma' yionej xa spatiqui: ―Ja ma' oj huaj cujtz'uqui, yena nia. Ti xa yamahuexa, xchi ja Judasi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iday, cuando c'oti, ti huaj sta yi sc'ab ja Jesusi: ―Maestro, xchi. Ti yujtz'ana. ");
INSERT INTO tojNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ti yala ja Jesusi: ―Lec camigo. Mi lomuc jacya. C'ulan ja jas huaxa c'ana oja c'uluc quii, x'utji yuj ja Jesusi. Jaxa cristiano ti jac syamea. Smochohue. ");
INSERT INTO tojNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Huaj to yile, june ja ma' tey soc ja Jesusi stasa ba snaj ja smachiti. Yaa yi ja smozo ja pagre mas nihuani. Sc'utzu el yi june ja xchiquini. ");
INSERT INTO tojNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ti yala ja Jesusi: ―Acta cani. A och ba snaj ja hua machiti. Ja ma' huas syama ja machiti, jach ni oj chamuca. ");
INSERT INTO tojNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Huan ma xa huala ta mi oj bob jcolta jbaj? Quechan oj c'an yi ja jTati, huego oj sec qui lajchahue tropa ja yangeli. ");
INSERT INTO tojNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero como mi huax c'ana. Mas lec a c'ot smeranil ja jas huax yala ja yabal ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ja Jesusi ti yal yab ja cristiano jumasa: ―¿Yuj ama lagronon soc machit soc garrote huax jac ayamonex ja ili? Pero cada c'ac'u ti huanon seejel ahuilex ba yoj templo, iday, mi ni jas huaxa hualahuex caba. ");
INSERT INTO tojNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero lec nia ba oj c'ot smeranil ja jas stz'ijba can ja aluman‑Dios jumasa ja najatei, xchi ja Jesusi. Cuando ch'ac yabye ja jastal it ja snebuman jumasa, ti spila sbajea. Spacahue ajnel spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jaxa yamhuanum jumasa ti yiaje och ja Jesús ja ba snaj ja pagre mas nihuan sbaj ja judio jumasa, Caifás sbiil. Jaxa tihui, ti stzomonej sbaje ja matic huas sea ja smandar ja Moisesi soc ja banquilal yujilei. ");
INSERT INTO tojNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jaxa Pedro ti huaj nochana, pero najtic najtic ay. Ti och ja ba spatioil ja snaj ja pagre mas nihuani. Jaxa tihui, ti aye chanjoe mozo soc ja criada jumasa. Jaxa Pedro ti och culan ja tihui ba oj yil jastal oj ch'ac huajuc. ");
INSERT INTO tojNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jaxa pagre mas nihuaqui soc ja banquilal jumasa, spetzanil ja ma' ay yateli, ti huane junta. Huane xta sleejel yi smul ja Jesusi, pero puro mentira, pero como huas sleahue modo jastal oj chamuc. ");
INSERT INTO tojNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero mi ni modo huax bob yujile conser ay jitzan stestigoe. Huane xta slocjel abal pero mi meranuc ja jas huax yalahuei. Ti cho och otro chahuanea. Sea sbaje que testigoe. ");
INSERT INTO tojNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","―Ja tan huinic iti, jel huas stoyo sbaj ta huan c'a bi sc'ana, oj bi sem ja stemplo ja Diosi, jaxa yoxil c'ac'u, oj bi cho ya q'ue otro vuelta, xchiye ja testigo jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jaxa pagre mas nihuani xachachi xta q'ue tec'an. Ti q'ue yal yab ja Jesusa: ―Jaxa hueni, ¿jas la chi ba? ¿Ja huab ama jas yala ja it jumasa? ");
INSERT INTO tojNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jaxa Jesusi, mi ni jun palabra sama stii. Ti cho yala ja pagre mas nihuani: ―Ala cabticon ja mero smeranil ta huen c'a Cristoai, ta huen c'a yunin ja Diosai. Oj yab ja Dios sac'an lequi, xchi ja pagre. ");
INSERT INTO tojNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ti sac'a jan ja Jesusi: ―Pero quena nia. Pero ay jas oj cala huabyex. Ti ni coelon jan ja ba satq'uinali pero ja yaani oja huilex que oj aaji ochcon ja ba lugar jau ja ba huax ilxi ja yip ja Diosi, jaxa ba nalan chaani oja huilex oj cho cocon jan ja ba asoni, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jaxa pagre mas nihuani, yajni yab ja jas yala ja Jesusi, tix batbuni ec' yuj ja scoraja. Ti yalaa: ―Pero ata huabilex tac. Ja tan huinic iti huan nix yala claro que Dios bi. ¿Jas yatel cujtic mas testigo? Ja huabyex yala que yen bi yunin Dios tac. ");
INSERT INTO tojNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jas la chiyex? Ti yala ja yenlei: ―Pero sbej ni oj chamuca, xchi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ti stzujbaye ja sat ja Jesusi. Yaahue yi golpe. Yaahue yi vuelta ja ba xchoji. ");
INSERT INTO tojNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ti yalahuea: ―Ta huena c'a Cristoa, naa sbaj machunc'a huas smac'ahua ba, huax yutaje. ");
INSERT INTO tojNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jaxa Pedro tey ba fuera. Ti culan ec' ba patio. Ti huaj tajuc yuj jun criada, ti yala ja criada jahui: ―Jach ni ja hueni, ja mojan ec' ja tan Jesús jau ba Galilea. ¿Mi ma meranuc ba? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero ja Pedro huax yala que miyuc: ―Mix cab ja jas huaxa huala cabi, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ti huaj tec'an ja ba puerta calle. Ti cho ilji yuj otro jun criada: ―Jach ni ja tan huinic iti, ti ajyi ec' soc ja Jesús ja tan nazareño, xchi ja aq'uixi. ");
INSERT INTO tojNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","―Xila Dios, mix naa sbaj ja tan huinic jahui, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jaxa otro jutz'ini, ti jacye ja matic ti huan comcompaxyal ec' ba patio. Ti yalahuea: ―Meran nia. Ja mojan ni abajexa. Pe chican ja hua c'umal tac, x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ja yab ja Pedro iti, jel q'ue ja scoraja, ti jel piero c'umania: ―Xila Dios, mix naa sbaj ja tan huinic jahui, xchi. Cuando ch'ac yal jachuc ja Pedro, oc' huego ja gallo. ");
INSERT INTO tojNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ti xa jac sc'ujol ja Pedro ja jas alji yab yuj ja Jesusi, ja cuando mi to bix oc' ja gallo, oxe bi vuelta oj yal que mi snaa sbaj. Ti el ja tihui. Ti q'ue juntiro sni sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cuando el ja c'ac'u, spetzanil ja nihuac spagre sbaj ja judio jumasa soc ja matic banquilal yujilei ti slajahue lec jastal oj bob ya chamuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jayuj ti smochohue ocha. Huaj yae yi endregal ja ba sc'ab ja Pilato ja ma' gobierno ayi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jaxa Judas ja ma' sc'ulan endregal ja Jesusi, cuando yab que t'ilan oj chamuqui, jel juntiro snaa malaya. Jaxa treinta sat taq'uin puro plata jahui, ti huaj ya cumxuc yi ja nihuac pagre soc ja banquilal jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ti yalaa: ―Ja huinic jahui, lom ni oj pec'uc ja xchiq'ueli. Mi ni jun smul ay, jaxa queni, mi ni t'un sbejuc jc'ulan ahuilex endregal, xchi ja Judasi. ―¡Jas cochelticon ja quenticoni! Pero ja huen ac'ulan endregal quiticon tac, x'utji ja Judasi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jaxa yab ja jastal iti, ti yiaj ja plata jumasa jahui. Spoctzin can ja ba yojol ja templo, ti xa huaja. Huaj sc'ul jorcar sbaj. ");
INSERT INTO tojNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jaxa nihuac pagre jumasa ti huaj stule ja sat taq'uin jahui. Ti yalahuea: ―Ja taq'uin iti, mi cualquierauc. Stz'acol ni svida jun huinica. Mi sbejuc ja' oj caatic sta sbaj soc ja tuc taq'uin sbaj templo, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ti yalahue que oj smane jun pedazo luum pero sbaj jun c'ulaoxom ajyi. Ti bi oj mucxuc ja polestero jumasa ja ma' huax cham ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jaxa luum jau smanahuei ya sbiiluque chiq'uil. Man ora jach sbiil. ");
INSERT INTO tojNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jaxa jas yala can ja aluman‑Dios Jeremías ja najatei, c'ot ni smeranila: Ja israeleño jumasa trato xa ay oj stup treinta sat taq'uin puro plata. Ti yiaje ja treinta sat taq'uin plata jau, ja' ni ja stz'acol ja svida jun huinic, ");
INSERT INTO tojNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ti smanahue sluum jun c'ulaoxoma. Jach ni yalunej ni cab ja Cajuala. Jach ni yala ja Jeremías ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jaxa Jesusi ti aaji tec'an ja ba sti sat ja gobierno Poncio Pilato. Ti jobji yia: ―Bueno, ala cabi, ja judio jumasa, ¿meran ama huen sreya? ―Quena nia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jaxa nihuac pagre soc ja banquilal jumasa huane xta sleejel yi ja smuli. Pero ja Jesusi, mi ni jun palabra sama stii. ");
INSERT INTO tojNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","―¡Ata huab ja jas huax yala baj ja testigo jumasa tac! xchi ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero mi ni soc ja jahui, mi c'umani. Jel och juntiro ja spensar ja gobierno Pilato. ");
INSERT INTO tojNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ja ba q'uin jahui, culan ni yuj ja gobierno que huax ya el libre jun presoanumi, pero tzaubal huax ya eluc ja cristiano ja ma' oj eluqui. ");
INSERT INTO tojNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jaxa q'uin jahui, lutan jun huinic sbiil Barrabás. Naubal lec yuj ja cristiano jumasa que jel tzatz juntiro ja smuli. ");
INSERT INTO tojNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Cuando ti tzoman spetzanil ja cristiano, ti jobji yile yuj ja Pilato: ―¿Jas la chiyex? ¿Ja' ma Barrabás ma ja' Jesús it huax alji sbaj Cristo oj sijpuc huilex? xchi ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Como huas snaa ja Pilato que puro envidioso aye, jayuj sc'ulane endregar ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ja Pilato ti culan ec' ja ba juzgado, jaxa xcheumi ti seca och jun jecabanuma. ―Ja hua cheumi huaychini bi ja huaaxa pero jel bi xiu juntiro yuj ja suayichi. Ja' bi suaychin ja huinic jahui, pero jel bi toj juntiro. Oj bi ahuacta cani, xyutajon jan ja hua cheumi, x'utji ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ja Pilato mi ni modo huax bob yujila. Ja nihuac pagre sbaj ja judio jumasa soc ja banquilal jumasa huane xta yaljel yab ja cristiano: ―C'anahuic ja tan Barrabasi. Alahuic oj chamuc ja tan Jesusi, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jaxa gobierno ti yalaa: ―Ay chab huinique. ¿Baya huaxa c'anahuexi? Oj ni sijpuc ahuilexa ja ba oja c'anexi, xchi. ―¡Ja' ni ja Barrabasi! xchiye xta ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","―Jaxa Jesús it huax alji sbaj Cristoili, ¿jas oj c'ul yi? xchi ja Pilato. Ti ahuani spetzanilea: ―¡A chamuc ba cruz! ¡A chamuc ba cruz! ");
INSERT INTO tojNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―Pero ¿jasunc'a ja smuli? xchi ja Pilato. Lom xta xuooljiye huax q'ueye: ―¡A chamuc ba cruz! ¡A chamuc ba cruz! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ja Pilato, cuando yila snicjel xta ja cristiano, mi xa jas huax bob sc'uluc ja yeni. Huan to nique slea modo jastal oj sac sbaj. Ti yalaa: ―Ja queni, limpio ayon. Mi oj cuch ja mulal iti. Ja huinic iti, mi ni ay smul cujtica. Lom oj pec'uc ja xchiq'ueli. ");
INSERT INTO tojNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Cuando yabye ja jastal yala ja Pilato, ti yala ja cristiano: ―Pues mi t'ilanuc. Tix cuchu ja quenticona soc ja cuntiquilticoni, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Entonces ja Pilato ti sijpan yile ja Barrabasi, jaxa Jesusi, cuando ch'ac mac'juc, ti yala ja Pilato que oj bi aajuc locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ja soldado jumasa ja ma' mandar ay yuj ja gobierno, ti yiaje och ba presidencia ja Jesusi. Ti ch'ac jacuque nolan sbaja. ");
INSERT INTO tojNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sopohue yi ja sc'ui, ti yaahue slap jun najtil c'ual morado ja jastal huas slapa ja gobierno. ");
INSERT INTO tojNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jaxa ba s'olomi yaahue cajan jun corona pero puro q'uiix sc'uluneje. Ti yaa yi jun aj ba oj bi syam soc ja stojol sc'abi como jastal ja vara huas syama ja reyi. Jaxa soldado jumasa ti ch'ac couque mec'an ba sti sati, pero burla huane: ―¡Viva ja srey ja judio jumasa! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Huas stzujbaye ja sati, ti sapahue yi ja aj yaman yuji, jaxa soc ja aj jahui, yaahue yi ja s'olomi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Cuando ch'ac eluc ja sganae soc ja burla, ti xa cho sopohue yi ja c'ual jau morado. Yaahue slap ja mero sc'ui. Ti xa yiaje ba oj yaahue locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Cuando ti xa aye ba beji, ti staahue jun huinic suinquil ja Cirene, Simón sbiil. Ti yalahue yab fuerza que oj bi scuch ja scruz ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ti c'otye ja ba huitz sbiil Gólgota. Jach sbiil yujile como ja' ni el ja splanta ja sbaquel ja s'olom ja chamhuiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jaxa Jesusi ti aaji yi vinagre socan soc jun c'ul ba jel c'aj ja' bi ba mi oj yab syajal ja suocoli. Sc'ulan probar, pero mi yuaj. ");
INSERT INTO tojNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cuando ch'ac aaji locan ja ba cruzi, ja soldado jumasa sc'ulane ripar ja sc'u ja Jesusi. Jach spilahuea, ti c'ot smeranil ja jas yala can ja aluman‑Dios ja najatei. Yala nia que ja sc'ui oj ch'ac spil sbaje ja yenlei. Oj bi sc'uluque ripar ja sc'ui, xchi ni ja aluman‑Diosa. ");
INSERT INTO tojNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jaxa soldado jumasa ti saculcule ec' ja tihui. Ti huane stalnajel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ti yaahue jun letrero ja ba s'olom ja scruzi, ja' bi huax yala jastal ja smuli: Ja Jesusi, srey ja judio jumasa, xchi ja ba letrero. ");
INSERT INTO tojNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Soc ay chab lagron cho aaji q'ueuque locan ja ba cruz, ja juni, ja scruz ja yeni ti ajyi ba lado stojol sc'ab ja Jesusi, jaxa juni, ti ajyi ba lado surdero. ");
INSERT INTO tojNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jaxa cristiano huan eq'uel ja tihui, huane xta burla. Naca huane xta st'uxpijel ja sc'abei. ");
INSERT INTO tojNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ti huax yalahuea: ―Ja yaani, ¿jasyuj ja mi la co ja ba cruzi? ¡Yunin Diosa tac! Pero huaxa huala oja jem ja templo tac y ja ba yoxil c'ac'u oj hua q'ueuc. ¡Colta baj ja huen mismo ba! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jach ni huane xta sc'ulajel ja nihuac pagre jumasa soc ja ma' huas seahue ja smandar ja Moisesi soc ja fariseo jumasa soc ja banquilal jumasa: ");
INSERT INTO tojNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Jaxa tuc jumasa, jel huas scolta, pero iday, jaxa yeni, mix bob scolta sbaj ja yen mismo. Ta meran c'a yen ja srey ba Israeli, aa ba co huego ba, ti oj naatic que meran yunin Diosa como jastal huax yala cabtiqui. ");
INSERT INTO tojNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jel bi huas sc'uan ja Diosi. ¿Jasyuj ja mix jac c'ulajuc librar ta jel gusto huax ilji yuj ja Dios ba? Quena ni yunin Diosoni, pe xchi tac, xchiye xta ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jach ni ja chab lagron lajan aaji q'ueuque ja ba cruzi. Huane xta burla ja yenle chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jaxa mero culan c'ac'u, q'uicbi juntiro ja satq'uinali. Masan to ec' ja oxe ora, ti to lijpia. ");
INSERT INTO tojNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Oj xa lijpuc ja satq'uinali cuando c'umani ja Jesusi, pero tzatz lec c'umani: ―Elí, Elí, ¿lama sabactani? xchi soc ja mero yabali. Dios mío, Dios mío, ¿jas lom ahuaahuon ta cani? Jach sbej ja yala soc ja yabali. ");
INSERT INTO tojNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","―Huan xa spayjel jan ja aluman‑Dios Eliasi, xchiye chaboxe ja ma' tey tihui cuando yab ja yahuaneli. ");
INSERT INTO tojNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jaxa june ja yenlei ti jac ajnel huegoa. Yiaj jun yojol c'aem. Ya yu vinagre ja yojol c'aem jahui, ti xch'ica jun tea. Ti sacha q'ue yia ba oj xchuuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jaxa smoj jumasa: ―Acta can ja hueni. Oj quiltic ta oj jac sc'ul librar ja Eliasi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jaxa Jesusi ti cho ahuani otro vueltaa. Ja' xa mero ora chami. ");
INSERT INTO tojNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jaxa ba yojol ja templo ay jun nihuan scortinail, jaxa ora jahui xch'ia sbaj snalan. Ja xch'ielali stulu con man sti q'ueel. El con man ba luumi. Ti cho ajyi jun tzatzal templor. Nijqui juntiro ja luumi. Spetzanil ja toni pedazo ch'ac huajuc. ");
INSERT INTO tojNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Jaxa q'ueen ba mucan can ja scuerpo ja creyente jumasa ja matic ch'ac ta ni chamuquei, ti ch'ac sam sbaja. Ja scuerpo ja yuntiquil ja Dios jahui, ti ch'ac sac‑huuquea, ");
INSERT INTO tojNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ti ch'ac q'ueuque ja ba sq'uejnalea. Jaxa cuando sacui ja Jesús chomajquili, jaxa matic ch'ac ta sac‑huuquei, ti xa huajye och ja ba chonab jau mi cualquierauqui, ja' ni ja Jerusaleni, iday, iljiye yuj jitzan cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cuando ti to locan ba cruz ja Jesusi, huan talnajel yuj jun capitán soc ja smoj soldadoili. Pero cuando yilahue jac ja templori soc cho yilahue spetzanil ja jas ch'ac ec'uc ja ora jahui, jel xiuye juntiro, ti yalahuea: ―Ja huinic iti, yena ni meran ja yunin Diosa, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jaxa tihui, tey jun nole ixuque, ja' ni ja ma' smojtaye jan ja Jesusi masan ec' ba Galilea. Jacye soc ba oj scoltaye ja Jesús ja ba beji. Najat huane q'uelhuanel ja yora huan chameli. ");
INSERT INTO tojNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tey ja María it sbaj Magdala, soc tey ja María snan ja Jacobo soc ja José, soc tey ja xcheum ja Zebedeo, ja' ni ja snane ja Jacobo soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ay jun huinic rico, José sbiil, suinquil Arimatea. Ja yeni, snebuman ni ja Jesusi. Cuando och ja acuali, ");
INSERT INTO tojNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ti huaj ja bay ja Pilato. Ti huaj sc'an ja scuerpo ja Jesusi ba oj bob smuque. Jaxa Pilato ti yaa smandar que oj bi yii ja scuerpo ja Jesús ja José jahui. ");
INSERT INTO tojNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ti yiaja. Ti spotzo soc jun sábana ba sac aya. ");
INSERT INTO tojNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ti huaj yaa can ba jun patac' pero ja patac' jahui, ajc'ach to jotobal jastal q'ueen. Yen ya c'ulajuc ja José jahui. Ti sbaltzun jan jun tona, ti smaca can lec ja sti ja q'ueeni. Ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pero cuando jach to huan sc'ulajel ja Josei, ti culane ec' ba stz'eel ja q'ueeni ja María sbaj Magdala soc ja otro jun María. ");
INSERT INTO tojNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jaxa tuc cristiano jumasa huan xax xch'ac xchap sbaje porque jechel xa ja sc'ac'uil ja jijlel yujilei. Jaxa el ja c'ac'u ti ch'ac huaj stzom sbaje ba sti sat ja Pilato ja nihuac pagre soc ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ti yalahuea: ―Jac jc'ujolticon ja jas huax yala ja tan lolanum jahui ja mi tox chami que oj bi sac‑huuc ja ba yoxil c'ac'u, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aa pavor. Jeca ja soldado jumasa ba oj stalna lec ja q'ueeni, siquiera oxe c'ac'u. Mi c'a, ay modo acual oj jac ja snebuman jumasa oj jac ya eluque nac'ul ja scuerpo. Ti oj cho yale yab ja cristiano que meran nia, que cham nia pero cho sacui ta, como jach ni smodoea. Jel ni piero ja huegoa, pero ta jach c'a huas sc'ulane, mas to pegor oj huajuc, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ti yala ja Pilato: ―Pues lec, iajic chanjoe soldado. Cax talnayic lec como ja huenlexi huaxa naahuex jastal mi oj bob ajnuc, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ti huajyea. Jaxa ton jau macan soc ja sti ja q'ueeni, ti yaahue lec seña ja yenlei soc jun sello ja gobierno. Ti yal yabye ja soldado jumasa oj can stalnaye lec ba mi ni ma' oj jac sam ja q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jach ec' yujile ja sc'ac'uil ja jijleli. Jaxa otro c'ac'u, ja' ni ja sbajtanil sc'ac'uil ja semana, como domingo nia, jaxa María suinquil ja Magdala, soc ja otro María, ti huaj yile ja sq'uejnal ja Jesús ja ba mucani. ");
INSERT INTO tojNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jaxa luumi nijqui juntiro ja ora jahui porque jun yangel ja Cajualtiqui ti co jan ja ba satq'uinali. Ti huaj ya eluc ja ton jau ba sti ja q'ueeni. Ti och culan ja ba sat ja toni. ");
INSERT INTO tojNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ja splanta ja angeli lajan soc jastal huax lijpi ja chamtzelahui, jaxa sc'ui sact'ost'os xta. ");
INSERT INTO tojNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jaxa soldado ja ma' huas stalna ja q'ueeni, jel xiuye juntiro ja yilahue ja angeli. Ti ch'ac couque baana. Tup yiq'ue. Lajan soc juntiro chamye. ");
INSERT INTO tojNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jaxa angeli ti yal yabye ja ixuquei: ―Mi lom la xiuyex. Huax naa ja' jac ahuilex ja Jesús aaji locan ja ba cruzi ");
INSERT INTO tojNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero mi xa teyuca. Sacui ta nia como jach ni yalaa. Laic. La ilahuic ba aaji can ja Cajualtiqui, xchi ja angeli. Ti och yilea, ti alji yabyea: ");
INSERT INTO tojNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","―Jayujil caaxic. Cax alahuic yab ja snebuman jumasa que sacui ta. Mi xa chameluc. Oj bi huaj ba Galilea ja Cajualtiqui, ti bi cho la huajyex ja huenlexi, ti bi oja huila bajex soca. Jayuj huax cala huabyex, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jaxa ixuquei, jel gusto aye pero cho huane xihuel. Ti elye ja ba q'ueeni. Ajnel huaj yale yab ja snebuman jumasa spetzanil ja jas yajc'achil to yabyei. Mix yilahue ora oj yal yab ja snebuman ja Jesusi ja jas yajc'achili. Cuando bej to aye ja ixuque jahui, ");
INSERT INTO tojNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Huaj to yile, jac tajuque yuj ja Jesusi. Ti aaji yile Dios yuj ja yeni. Jaxa ixuquei ti huajye ajnela. Huaj couque mec'an ja ba sti sat ja Jesusi: ―¡A Cajual, huen ama! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ti yala ja Jesusi: ―Quena nia. Mi la xiuyex. Cax alahuic yab ja quermanotic jumasa ja jas yajc'achil huanex yiljeli. Alahuic yabye a huajuque ba Galilea, ti oj c'um jbajtic ja tihui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jaxa ixuquei, ti cho stulu ja sbejea. Jaxa mismo ora jahui, chaboxe ja soldado ja ma' huane stalnajel ja q'ueen ajyi, ti huajye ja ba chonabi. Huaj yal yabye ja nihuac pagre jumasa spetzanil ja jas ch'ac ec'uqui. ");
INSERT INTO tojNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jaxa pagre jumasa yiaj yabal sbaje soc ja banquilal jumasa. Ti sc'apahue yile jitzan taq'uin ja soldado jumasa ba mi oj sloiltaye ja jas yilahuei. ");
INSERT INTO tojNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Oja hualex que ja snebuman jumasa, acual jac yie ja scuerpo ja tan Jesús jahui, jaxa quenticon, naca huanticon huayel, oj chianic. ");
INSERT INTO tojNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y ta huan c'ax c'ot xchiquin ja gobierno, mix cham ac'ujolex. Oj tojbesticon ja quenticoni, jaxa huenlexi, mi jas oj sc'uluc ahuilex, x'utjiye ja soldado jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jaxa yenlei, ti syamahue ja taq'uina. Sc'uane nia ja jastal alji yabyei. Jaxa mentira jahui, ti pucxia, Jach ni yabye spetzanil ja judio jumasa, jayuj man ora jach huax alxi. ");
INSERT INTO tojNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jaxa once snebuman ja Jesusi ti huajye ba Galilea ja ba huitz jau yalunej ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Cuando yilahue ja Jesusi, ti coye mec'ana, pero ay ma' huan c'umal ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Cuando ti xa aye ba stzeeli, ti c'umani ja Jesusi: ―Spetzanil ja satq'uinali soc ja mundoi, ac'ubal xa ba jc'ab. ");
INSERT INTO tojNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaxa huenlexi, caaxic, cax ja ba spetzanil ja lugari ba jachuc oj och jnebumanil ja cristiano jumasa. Ti xa c'ulanex bautizara ja ba sbiil ja Tatali soc ja queni, como yuninon nia, soc ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jeahuic ba oj sc'uuque spetzanil ja jmandari. Jaxa queni oj ni jmojtayex ec' tola vida, masan to cuando huax ch'ac ja mundoi, xchi ja Jesusi. Ti ch'aca. Amén.");
INSERT INTO tojNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ja abal it jel tzamali, ja' huax yala jastal ay ja Jesucristo ja yunin ja Diosi, jach q'ue ja jastal iti: ");
INSERT INTO tojNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ja najate lequi, yalunej ni jastal ay ja aluman‑Dios Isaiasi. Ata huabilex ja jas yala can tac: Q'uelahuilex, bajtan oj jec ja cala jecabanumi, jaxa yeni oj sam ja hua beji, ti oj cho huajan nochan ja hueni. ");
INSERT INTO tojNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja jecabanum jahui ti oj ajyuc ec' ja ba ch'ayan lugar jumasa. Tzatz lec oj c'umanuc eq'ue. Oj yal ja jastal iti: Ja jastal huaxa jamahuex ja bej ja cuando oj jac ja ma' ay yateli, jach oja huaex puesto ja hua c'ujolexi porque oj xa jac ja Cajualtiqui. Jach bi oj yal yab ja cristiano, xchi ja Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jayujil huaj to yabye ja cristiano jumasa, ti xa bi ay ba jun ch'ayan lugar ja Juani, ja' ni ja Juan it huax yaa bautismo. Huan yaljel que aa xa bi suchuc ja sc'ujol ja cristiano, ti xa bi oj c'ulajuque perdonara, ti xa bi oj yie jaa. ");
INSERT INTO tojNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jaxa spetzanil ja cristiano suinquil ja Judea soc jach ni ba Jerusaleni, lom xta xnololjiye huaj smaclaye ja jas huax yala ja Juani. Cuando yabye ja jas yalai, ti ch'ac el stie ja smulei, ti xa aaji yie jaa. ");
INSERT INTO tojNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jaxa Juani, ja' c'ulubal soc ja stzotzil camello ja sc'ui, jaxa snalani, pitan soc jun sincho tz'uum, jaxa suaeli, ja' tz'itit soc yaal chab. ");
INSERT INTO tojNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Con gana huan xcholjel ja yabal ja Dios ja Juani. Ti huax yalaa: ―Meran, ti xa ayon ja queni pero oj to jacuc ja ma' jel tzatz juntiro ja yateli. Mi ni ba oj sop yi ja xanabi oj maconucon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja queni huax ca huiex ja', jaxa yeni oj yaa huilex ja Espíritu Santo, pero con todo yip, xchi ni ec' ja Juana. ");
INSERT INTO tojNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja c'ac'u jumasa jahui ja Jesusi ti el ja ba Nazaret ba lugar Galilea. Ti huaj ja bay ja Juani, ti aaji yi ja' yuj ja Juani. Ja ba nihuanja Jordán ti yiaj ja' ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iday, cuando huan xa elel jan ja ba sti ja ja' ja Jesusi, huaj to yile, jamxi ja satq'uinali, jaxa Espíritu Santo ti co t'ucan sbaj, pero entero splanta jastal paloma. ");
INSERT INTO tojNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti yab jun c'umal ja ba satq'uinali: ―Mero cunina ja hueni. Jel juntiro yaj huax cabya. Jel huaxa huaa qui gusto, xchi ja c'umal jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ja Jesusi ti yab ja ba sc'ujoli que jel bi t'ilan oj huajuc ba jun ch'ayan lugar pero ja' alji yab yuj ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ti ajyi cuarenta c'ac'u ja tihui, pero mero ch'ayan lugar nia. Jel ja sbaal ja huitzi. Ti jel c'ulaji probar yuj ja Satanasi pero ja mas tzaani ti jac ja ángel jumasa ba oj scoltaye ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ja c'ac'u jumasa jahui, aaji och preso ja Juani. Ti to lutana cuando cho cumxi ja ba Galilea ja Jesusi. Ti huaj ja ba Galilea ba oj see yi ja cristiano ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ti yalaa: ―Ora xa nia. Tiempo xa oja huaa bajex ja ba sc'ab ja Diosi. Aa xa suchuc ja hua c'ujolexi. C'uanic xa ja ajc'ach abal it huax cala huabyexi porque jel tzamal juntiro, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jun c'ac'u ja Jesusi ti huan bejyel ec' ja ba sti ja ja' ja ba Galilea. Jaxa tihui ti yila ja Simoni soc ja yijtz'in Andresi. Ti huane sipjel yoj ja' ja yenubei, como yamachaye nia. ");
INSERT INTO tojNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ti yala ja Jesusi: ―Ti la jacyex jmoca. Eso sí meran, quechan huajel ac'ujolex ja syamjel ja chayi pero ja yaani ja' oja huaa c'ujolex ja sleejel ja cristiano ba oj jac jmoc, x'utjiye ja Simón soc ja Andresi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jayuj ja yenlei ti yaahue can ja yenubei. Ti huajye soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cuando huajye ta jun maq'uei, ti yilahue ja Jacobo soc ja yijtz'in Juani, ja' ni ja yuntiquil ja Zebedeo. Ti aye ba jun barco. Ti huane stz'acbajel ja yenubei. ");
INSERT INTO tojNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ti ya q'ueuc ja sloilei. Ti xa yala ja Jesusi: ―¿Mi ma xa c'anahuex oj huajanic jmoc ba? xchi ja Jesusi. Jaxa Jacobo soc ja Juani ti xa yaahue can ja statei soc ja yatjume tey ba yoj barco. Ti xa huajye soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ti huajye ba Capernaum, jaxa sc'ac'uil ja jijleli, ti huaj ba iglesia ja Jesusi. Och see yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Cuando abji ja jas huax yala, jel och juntiro ja spensar ja cristiano jumasa. Lajan bi soc jun ma' jel tzatz ja yateli. Mi bi oj slaj ja yenle ja ma' huas seahue ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jaxa ba mismo iglesia jahui, huaj to yile, tey jun huinica. Ja yeni ixtalanubal juntiro yuj ja pucuji. Ti och ahuanuca: ");
INSERT INTO tojNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Ja huen Jesús nazareño, ¿jas ahuocheloticon ja quenticoni? ¿Yuj ama huaxa c'ana oja ch'ayoticon ja huen ba? Huan nix naaticon abaja. Eso sí, ja hueni mi ni huaxa taa tan amul tac. ¡Yunina ni ja Diosa! Jach el sti ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ti xa yal yab ja Jesusi: ―Ch'abananic ja huenlexi. Actayic can ja huinic iti, x'utjiye ja tantic pucuji. ");
INSERT INTO tojNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jaxa pucuj jumasa ti syamahue ja huiniqui. Ya q'uitc'onuc spetzanil ja scuerpo. Ti ya ahuanuc tzatz leca. Ti xa actaji can ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jaxa cuando yila ja cristiano jumasa, jel xiuye juntiro. Ti huax yala sbajea: ―¿Jastal ay ja iti? ¿Yuj ama ay jas yajc'achil ay ba? Pero ¡huas sc'ulan mandar ja tantic pucuj tac, y huax c'uaji! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Huego huego ch'ac pucxuc yabalil ja Jesusi. Ch'ac yabye ja cristiano ja ba sutanal ja Galilea. ");
INSERT INTO tojNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ja Jesusi ti el ja ba iglesia jahui. Ti xa huaj ja ba snaj ja Simón soc ja Andresi. Ti smoj ja Jacobo soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Cuando c'otye ja tihui, ti alji yab ja Jesusi que ti baan ec' ja snial ixuc ja Simoni. Jel bi yioj c'ac'. ");
INSERT INTO tojNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jaxa Jesusi ti huaj och ja bayi. Syama yi ja sc'ab ja chamumi. Ya q'ueuc. Huaj to yabi, mi xa ay ja sc'ajc'ali. Yen xa ya ec'uc ja suaele ja huiniquei. ");
INSERT INTO tojNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Cuando mucxi ta c'ac'ui, oj xa q'uicbuc ja q'uinali, ti iiji jan yi ja Jesús spetzanil ja matic malo ayi soc ja matic ixtalanubale yuj ja pucuji. ");
INSERT INTO tojNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Spetzanil ja suinquil ja chonabi ti ch'ac jacuque montón ja ba sti naitz ja bay ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jaxa yeni, jitzan ja ma' ya tojbuc ja ora jahui. Tuctuquil tiq'ue chamel yioje, jaxa pucuji, yaa yi mandar que oj yactaye can ja cristiano jumasa. Mi aaji c'umanuque yuj ja Jesusi porque huas snaa machunc'a ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jaxa el ja c'ac'u, ja Jesusi jel saj q'uei, q'uic' to ja q'uinali. Ti huaj sc'umuc ja Dios ja ba jun ch'ayan lugar. ");
INSERT INTO tojNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ti huaj leejuc yuj ja Simoni soc ja smoj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yajni staahuei, ti yalahue yaba: ―Pero huana leejel yuj ja cristiano jumasa tac, xyutaje. ");
INSERT INTO tojNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ti yala ja Jesusi: ―Pero oj ni huajtic ja ba lugar mojan yaman tac. Oj cho huaj choltic ja yabal ja Dios ja tihui. Jayuj ti xa ni ayon ja il tac, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jaxa ba spetzanil ja yal lugar ba Galilea, ti xa och see yi ja ba yiglesiae ja smoj judioili. Chican ba huax huaj ec'a, huan ni sc'ulan ec' mandar ja pucuj jumasa ba oj yactaye can ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jun c'ac'u ti jac jun huinic soc jun chamel huan c'ael ja sbacteli. Ti jac sc'an yi stz'acatal ja Jesusi. Co mec'an ja ba sti sati: ―Cajual, ta jach c'a huaxa c'ana, oj ni hua tojbucona, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jaxa Jesusi jel stalna syaujulal. Ti ya cajan ja sc'ab ja ba scuerpo ja huiniqui: ―Huan nix c'ana oj tojbana hijo, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mi tox el yuj ja palabra jahui, ch'ay huego ja spieroil ja sbacteli. Huego huego tojbi. ");
INSERT INTO tojNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ja Jesusi ti yalaa: ―Pero huax cala huabi, moc ma' ahual yab que quen ca tojban. Cax xa. Cax jea baj yi ja pagre. Aa yi ja jastal ni yalunej ja Moisesi ba oj yil ja cristiano que lec xa ni ayaa. Cuando ch'ac yala jastal it ja Jesusi, ti xa spila sbaja. ");
INSERT INTO tojNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero iday, lajan soc yal yab ba oj spuc eq'ue. Ja' xta huan xcholjel ec' jastal tojbi, jayuj ja Jesusi mi xax bob och satalajel abal ja ba chonab jumasa. Jayuj ti xa can ja ba jun ch'ayan lugar ba mey lec ja suinquili. Pero ja cristiano huaj ni stae ja bayi. Ba spetzanil lugar ch'ac jacuque ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ja Jesusi ti ajyi chaboxe c'ac'u ja tihui, ti xa cho cumxi ja ba Capernaumi. Ti abji yabalil que ti xa bi ay ba jun naitz. ");
INSERT INTO tojNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yajni ch'ac yab ja cristiano ja jastal jahui, sac ajnel xta ch'ac huaj yile. But' ja ba naitz jahui. Mi ni ba mojan ja puerta huax bob ochuque. Pec' man fuera ja cristiano. Jaxa Jesusi ja' ni mero huan xta yaljel ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ti xa c'ot chaboxe cristianoa. Chanhuane slicuneje jan jun huinic mi xax bob snic ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ja c'otyei, mi ni modo huax bob ochuque c'uban porque jel juntiro ja cristiano, jayuj ti xa q'ueye ja ba s'olom ja naitzi. Sotohue ja tihui, ti yaahue couque ja chamumi soc ja xch'atilteili. ");
INSERT INTO tojNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jaxa Jesusi cuando yila jel huax c'uaji yuj ja cristiano jumasa jahui, ti yal yab ja chamumi: ―Hijo, perdonado xa ay ja hua muli, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pero ti ni aye chaboxe ja ma' huas sea ja smandar ja Moisesi, ti culane ec'a. Huan xta c'umal ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","―¿Jasyuj jach huax yala ja iti? ¡Huan amax yala que Dios ja yen ba! ¿Mi ma quechanuc ja Dios oj bob c'ulhuanuc perdonar ba? ¡Jel piero juntiro ja jas huax yala tac! ");
INSERT INTO tojNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero ja Jesusi como huan ni snaa que jach huan xta loil ja sc'ujole ja jau jumasa, jayuj ti yalaa: ―¿Jas lom huan xta c'umal ja hua c'ujolexi? ");
INSERT INTO tojNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Mi ma jun xta ni ja huax cal yab que perdonado ay ja smul ba, ma ja' huaxa c'anahuex oj cal yab a q'ueuc, a stul ja xch'ati, a bejyuc? ¿Baya mas lec ba? x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ja queni ti ni coelon jan ja ba satq'uinali pero ba oja c'uuquex que huax bob jc'ul perdonar ja mulali, ba oja naex que tzatz ni ayon ja ba luumi, ay ni jas oj cal yab ja chamum iti. Ti yal yab ja ma' mix bob snic sbaji: ");
INSERT INTO tojNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Ja huen hijito, q'uean xa. Iaj xa hua huaynubi. Cax xa ba hua naji, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jaxa huinic jahui, huego huego q'uei. Ti ba sat ja cristiano ch'ac spac ja xch'atilteili, ti huaja. Jaxa cristiano jel och juntiro ja spensarei: ―¡A stz'acatal juntiro ja Diosi! Jun ta ora huax quilatic ja jastal iti, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ja Jesusi ti cho huaj ja ba sti ja jai, jaxa tihui ti c'ot spetzanil ja cristiano ba oj jeejuc yile. ");
INSERT INTO tojNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jaxa cuando ch'ac see yi ja cristiano, ti xa cho huaja. Ti ec' ja ba colecturía ba huax och ja scontribucion ja cristiano jumasa. Jaxa tihui ti culan ec' jun atjum sbiil Leví, ja' stat ja Alfeo. Ja Jesusi ti och loil soca: ―¿Jaxa mila huaj jmoc ba? xchi. Jaxa Levii ti q'ue huegoa. Ti huaj soca. ");
INSERT INTO tojNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jun c'ac'u ti huaj ba snaj ja Leví jau ja Jesusi. Ti och culan ja ba mesa, soc tey jitzan ja ma' huax atji ba colecturía soc tey ja ma' ay smulei soc ti ni aye ja snebuman jumasa. Pero smoj ni sbaje huaela. Ja tiempo jumasa iti, jel xa jitzan ja ma' tey ec' soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jaxa fariseo jumasa soc ja ma' huas seahue ja smandar ja Moisesi ti yilahue smoj sbaje huael ja Jesusi soc ja colector jumasa soc ja ma' jel bi ja smulei. Jayuj ti ochye loil soc ja snebuman jumasa: ―Pero ¿jastal ay ja iti? Ja hua maestroexi, pero ti huan huael soc ja tantic colector tac soc ja mulanum tac, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pero ja Jesusi c'ot xchiquin ja jas huane yaljeli, ti yalaa: ―Pe ¡mi jas yioj! Ja' ni yuj jaquelon taca, ba oj colta ja ma' ay smuli. Ja mulanum jumasa huan ni sc'ulane necesitar jun doctor pero ja huenlexi, como jel lec ayex, mi ni ayuc ja hua nesesidaexi. ¡Jas lom oj coltayex! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ja snebuman jumasa ja Juani soc jach ni ja snebuman ja fariseo jumasa, culan yujile tola vida huas scomo ja suaelei. Ti huaj sobe yi ja Jesusi: ―Ja janec' ayticon snebumanil ja Juani soc ja fariseo jumasa, c'ajyeloticon huan nix como ja juaelticon tola vidaa. Iday, jaxa hua nebuman ja hueni, mi ni t'usan huas scomo ja suaelei. ¿Jaxa yuj ba? ");
INSERT INTO tojNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ti yala ja Jesusi: ―Pero q'uelahuilex jun ch'ac abal. Ja loc jumasa mi ni modo oj scom ja suaelei como ti ni tzomane soc ja nupanumi. Jel ja sgustoei. Mi ni sbejuc oj scom ja suaelei como ti ni ay soc ja ma' huan nupaneli. ");
INSERT INTO tojNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero oj ni jacuc ja c'ac'u ja' oj ch'ay yujile ja nupanumi, jaxa tiempo jahui, eso sí, sbej ni oj scom ja suaelea. Oj ni but'uque yuj ja stristeilea. ");
INSERT INTO tojNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Meran huax cala huabyex, jel huocol huaxa huabyex huaxa huaahuex can ja viejo scostumbre ja jmojtic judioili. Porque q'uelahuilex jun poco c'uutz. Mas lec mix hua ochuquex smactonil ba yajc'achil. Huan c'ax ochi, jaxa yajc'achili oj sujbuc y toj coleto huax huaji. ");
INSERT INTO tojNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jach ni jun oxom ba ay syaj. Mix bob hua och taan ba yajc'achil to. Jach c'a huaxa c'ulan, huaj to ahuile, leutz'uji ta snalan ja oxomi, jaxa taani, oj ch'ac co bulan ba luum. Mi xa lecuc ja taani, jaxa oxomi, lom nia. Ta yajc'achil c'a ja taani, mas lec, aa ba jun oxom mey syaj. ");
INSERT INTO tojNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jun sc'ac'uil ja jijleli, ti huane eq'uel ba yoj alajaltiqui ja Jesusi soc ja snebuman jumasa. Ti och stuch'e ja sni ja trigo. ");
INSERT INTO tojNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Cuando yilahue ja fariseo jumasa, ti yalahuea: ―Q'uelahuil ja hua nebuman jumasa. ¿Sbej ama jach huane sc'ulajel ba? ¿Mi ma jauc ja sc'ac'uil ja jijlel ja yaan ba? ");
INSERT INTO tojNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ti sac'a jan ja Jesusi: ―Bob ta mey xa q'uelahuex ja juun ja ba huax yala jas sc'ulan ja rey David ja najatei cuando jel bi och huain xyabi. Y mi quechanuc ja yen, jach ni spetzanil ja smoj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Och bi ja ba snaj ja Diosi. Ti bi ch'ac suee ja pan it ti jian ec' ja ba sti sat ja Diosi, iday, mi sbejuc cualquier cristiano oj sue ja pan jahui. Ja' sbaj quechan oj sue ja pagre jumasa. Pero ja ora jahui, ja Davidi suea nia soc cho yaa yi ja smoj jumasa, y mi ni malouc iljia. Ja nihuan pagre ja ora jahui, ja' ni ja Abiatari. ");
INSERT INTO tojNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja sc'ac'uil ja jijleli ac'ubal yi ja cristiano ba slequilei, mi jauc ja ba yibc'abal oj yaa sbaje ja c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ja queni ti ni coelon jan ja ba satq'uinali. Quena ni oj cal jasunc'a lec sc'ulajel ja ba c'ac'u jijleli porque ac'ubal ni qui ba quen oj cal jasunc'a lec oj c'ulaxuqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ja Jesusi ti cho huaj otro vuelta ja ba yiglesia ja judio jumasa. Huaj to yile, tey jun huinic jiman xa ec' ja sc'abi. Mi xa ni modo xbob ya q'ueuca. ");
INSERT INTO tojNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Como ja' ni ja sc'ac'uil ja jijleli, jaxa scondra jumasa ja Jesusi quechan huane xta smajlajel ba oj yile ta oj ya tojbuc ja chamum jahui. Ta huan c'a bix aaji tojbuc, ti bi oj sta smul ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ja Jesusi ti yal yab ja huinic it jiman ec' ja sc'abi: ―Q'uean xa ja ba culana ec' ja hueni, ti la jac ba sti jsaticoni, x'utji ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ja Jesusi ti yal yab ja cristiano: ―Q'uelahuilex ja huenlexi. Ja yaan c'ac'u ja' ni sc'ac'uil ja jijleli. Mi sbejuc oj c'ultic yi malo ja jmojtic ja c'ac'u iti. Oj ni jc'ultic ja ba leca. Oj coltatic, mi oj caatic chamuc, xchi. Jaxa scondra ja Jesusi, mi jun palabra sama stiei. ");
INSERT INTO tojNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ja Jesusi ti och stojtoq'uel ja cristiano. Coraja ay soc huax jac jun stristeil porque jel ch'uuy juntiro ja sc'ujolei. Ti yal yab ja huinic jahui: ―A q'ueuc ja hua c'abi, xyutaj. Iday, ja huiniqui ti ya q'ueuca, jaxa sc'abi, huego staa slugar ja jastal ja otro jun sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jaxa fariseo jumasa ti elye ja tihui. Huaj yii yabal sbaje soc ja yamigo jumasa ja rey Herodesi. Huaj xchape yabalil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jaxa Jesusi ti huaj ba sti jaa. Ja' smoj ja snebuman jumasa. Ti huaj nochan jun nole cristiano sbaj Galilea soc sbaj Judea, ");
INSERT INTO tojNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Soc jach ni ba Jerusalén soc ba Idumea. Cho jacye ja ba otro lado c'ax ja ba nihuanja Jordani, soc ba tuctuquil lugar ba Tiro soc ja ba Sidoni. Cuando ch'ac yabye spetzanil ja jas jel nihuan huan sc'ulajel ec' ja Jesusi, lom xta xnololji ch'ac jacuc ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ti yal yab ja snebuman jumasa que oj yae puesto jun barco ba cualquiera ora oj bob q'ueuque ja tihui porque jel bi juntiro ja cristiano. Ay bi modo oj batalajuc. ");
INSERT INTO tojNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jaxa chamum jumasa, jitzan lec ya tojbuc, jaxa matic mi tox ya tojbuqui, huane xta sutbintalaan sbaje siquiera oj huaj syame ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jaxa ma' ixtalanubal yuj ja pucuji, cuando huax yilahue ja Jesusi, huax coye pacan ja ba sti sati: ―Ja hueni yunina ni ja Diosa, xchiye xta, pero tzatz lec huax c'umaniye. ");
INSERT INTO tojNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jaxa Jesusi c'ac' lec huax comhuani ba mi oj yale machunc'a ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ti q'ue ba jun huitz ja Jesusi. Ti spaya jan ja matic huas sc'ana oj sc'uluc ja yateli. Ti cho q'ueye ba huitz ja yenle chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ti tzaajiye can lajchahuanea ba oj ajyuc ec' soc ja Jesusi. Oj bi huaj xchole ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Soc aaji yipe ba oj cho bob ya tojbuque ja matic malo ayi soc oj bi sc'uluque mandar ja pucuj jumasa ba mi xa oj yixtalauc ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Stzaa ja Simoni, ti slea yi otro sbiila. Yaa yi Pedroil. ");
INSERT INTO tojNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Cho stzaa ja Jacobo soc ja yijtz'in Juani, ja' state ja Zebedeo. Jaxa yenlei, jel bi t'usan ja xchijnaq'uei. Lajane bi soc ja mentzululi porque snicjele xta nia. ");
INSERT INTO tojNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Cho stzaa ja Andresi, soc ja Felipe, soc ja Bartolomé, soc ja Mateo, soc ja Tomasi, soc ja Jacobo ja' stat ja Alfeo, soc ja Tadeo, soc ja Simón cananero, ");
INSERT INTO tojNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Soc ja Judas Iscariote, ja ma' sc'ulan endregal ja mas tzaani. Yaj ni ch'ac stzai, ti xa cumxiye ja ba snajea. ");
INSERT INTO tojNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ja cristiano jumasa ti xta nolane ja bay ja Jesusi, jaxa yeni soc ja snebumani, mi xax bob huauque. ");
INSERT INTO tojNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ti c'ot xchiquin ja yermano jumasa ja Jesusi, jayuj ti huaj yilea. Ti yalahuea: ―Loco xa ma quermanotiqui. Mas lec huan xax jac jmoctic, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jaxa matic ti jac ja ba Jerusaleni soc ja matic huas sea ja smandar ja Moisesi mi huax yalahue que loco. Ja' huax yaahue smojuc ja diablo, soc yen bi mero statalil ja diablo, ja' bi yuj huax bob sc'ul mandar ja pucuj jumasa. Como ay ni bi yipa, ja' bi yuj huax bob yal yab que oj actajuc can ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ja Jesusi ti spaya jan ja matic jach huan yaljeli. Ti yala jun loila: ―Pero ¿sbej ama jach huanex yaljel ba? Ja Satanasi, ¿oj ma snutz el ja smoj Satanasil ba? ");
INSERT INTO tojNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Q'uelahuilex, ja cristiano ma' jun ta lugar ayei, ta tola vida huas snutzu sbaje, oj jomuc ja lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y jach ay ba jun naitz. Ja suinquili, ta puro pleito aye, oj ni jomuca. ");
INSERT INTO tojNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pero jach ni ja Satanás soc ja smoj jumasa tac. Ta toj pleito c'a aye, huan c'a snutzu ja smoji, oj ni jomuquea. Ti ni oj ch'acuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ja diablo jel tzatz juntiro. Jel jitzan ja ma' yaa ta och smozoil ja ba snaji. Mi ni nunca oj bob ochan ba snaj oj hua el libre ja smozo jumasa. Quechan ta huaxa mocho bajtan ja mero statalili, eso sí, oj bob ochan ja ba snaji. Ti oj bob oj el libre ja smozo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Huax cala, pero meran, spetzanil ja specado ja cristiano oj c'ulajuc yi perdonar, anima jel piero ja jas huax el ja ba stii. ");
INSERT INTO tojNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero ta huan c'ax yaahue och pucujil ja Espíritu Santo, mi ni nunca oj c'ulajuque perdonar. Mi ni nunca oj ch'ac ja scastigoei. ");
INSERT INTO tojNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jach yala ja Jesusi yuj ja yalahue sbaj que ja' bi yip ja diablo yioji. ");
INSERT INTO tojNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Cuando ch'ac yal jachuc ja Jesusi, ti c'otye ja yermano jumasa soc ja snani. Secahue spayjel ba oj huaj sc'umuque porque ti aye ba fuera. ");
INSERT INTO tojNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jaxa cristiano ja ma' ti culane ec' mojan stz'eel ja Jesusi, ti yalahuea: ―Abi, ti bi ay ba fuera ja hua nani soc ja hua huermano jumasa. Huan bi sc'ana oj sc'umuca. ");
INSERT INTO tojNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ¿machunc'a ja jnan ba? ¿Machunc'a ja quermano jumasa? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ti stojtoq'uela ja cristiano ja matic culane ec' ba stz'eeli: ―Ja it jumasa, ja' jnan, ja' quermano jumasa ");
INSERT INTO tojNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque spetzanil ja ma' huas sc'uan ja smandar ja Diosi, ja jau jumasa, ja' ni ja quermano soc ja quermana soc ja jnani, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ja Jesusi ti cho och see yi ja cristiano. Ti tzoman aye ja ba sti ja jai, pero montón xta aye. Jayuj ti huaj culan ba yoj barco ti lac'an ba yoj ja'. Jaxa cristiano ti ch'ac canuque ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jel jitzan ja jas jeeji yile yuj ja Jesusi pero soc jun loil: ");
INSERT INTO tojNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Maclayic. Jun c'ac'u jun huinic huaj stic ja yintil ja trigo. ");
INSERT INTO tojNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cuando huan sticjel ec' ja inat jahui, iday, ay ba co ba yoj bej. Pero jac ja yalchani, ti stuch'u ela. ");
INSERT INTO tojNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Soc ay ba co yoj ton ba mey lec ja luumi. Huego el jani porque mi pimuc ja luumi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Iday, cuando el q'uen ja c'ac'u, huego huego tacji, como mey yech. ");
INSERT INTO tojNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Soc ay tuc inat ti co ba yoj q'uiix. Jaxa tihui, huax q'ui ja q'uiixi, jayuj ja inat jahui, c'utzji sq'uiel. Mi ni satinia. ");
INSERT INTO tojNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ay ba co ja ba lequil luumi. Huaj to yile, tz'ipan xa ec' ja yal trigoi. Jel tzamal q'uii. Ajyi sat. Ja jun sat inati, ya pojxuc treinta, jaxa otro juni, sesenta, jaxa otro juni, ya pojxuc cien. ");
INSERT INTO tojNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ja ma' ay xchiquini, a yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jaxa mas tzaani, canye stuch'il ja Jesusi soc ja lajchahuanei soc chaboxe ja ma' mas yamigo sbajei. Ti och sobe yi ja Jesús jas sbej ja loil jau ja jas ch'ac yal yab ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ti yala ja Jesusi: ―Ja ajyi, mi ni mero huax chijcaji jastal huas sc'ulan mandar ja Dios ja ba c'ujolali pero ja yaani sbej ni claro oja huabyexa. Pero ja tuc jumasa, sbej ni oj yabye jastal jun loil, porque mi nix c'ocxiyea. ");
INSERT INTO tojNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Huas smaclaye pero mi ni huax yabyea. Eso sí, huax yilahue, pero ja smeranili, lajan soc mi ni huax yilahuea. Jayuj huax cal yab soc loil tac. Mi c'a, oj to huaja huabi, lec, oj chique. La xa c'uuctic siquiera oj c'ulajuc perdonar ja jmultiqui, pero yib ta ni abal oj yalea. ");
INSERT INTO tojNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Pero ja huenlexi, ¿casta mi ahuabyex ja sbeji? ¿Jastal xa oja huabyex sbej ja otro loil oj to cal ba? ");
INSERT INTO tojNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ja ma' huaj stic ja inati, ja' ni ja ma' huan xcholjel ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jaxa ma' huas smacla ja yabal ja Diosi pero cuando huax ch'ac yabi, ti huax jac ja diablo. Huax jac sap yi ja jas ti xa ay ba sc'ujoli. Ja jun tiq'ue cristiano jahui lajane soc ja inat ti co ba yoj beji. ");
INSERT INTO tojNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Soc ay ma' cuando huax yabye ja yabal ja Diosi, huego huas sc'ulane gusto. Lajane soc ja inati jau ti co yoj ton it huego eli, ");
INSERT INTO tojNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Porque cuando huax q'ue ja huocoli, coraja huax iljiye yuj ja sc'uan ja yabal ja Diosi, mi huas sc'ulane ahuantar. Huax yaa can ja yabal ja Diosi. Mey yahuantare. Ja' ni smoj ja yal trigo jau tacji porque mey yech. ");
INSERT INTO tojNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Jaxa ma' huax yab ja yabal ja Diosi, pero ja' huajel sc'ujol ja svida ba mundo, huax lolajiye yuj ja taq'uini, huax oc' sc'ujole ja cosa jumasa, pues, spetzanil ja jastic jahui, lajan soc huax jac sc'utz sq'uiel ja yabal ja Diosi. Mi huax ajyi sat. Lajane ni soc ja inat jau co ba yoj q'uiixi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ja ma' huax yab ja yabal ja Diosi y huas sc'uan merani, ja' ni smoj ja inat jau co ba lequil luum ja it yaa sati. Ay ba yaa treinta, ay ba yaa sesenta soc ay ba yaa cien. Iday, quechan jun yala sat tz'unji. ");
INSERT INTO tojNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ja jas huax jea, lajan soc jun candela huan ajleli. Jaxa candela, mi jauc ja ba oj nujxuc soc jun cajón, mi ni ba oj aaxuc ba yib ch'at. Sbaj ni oj aaxuc ba jun candelerio ba oj ijlabanuca. ");
INSERT INTO tojNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Porque mi ni modo oj can musan ja jas huax jea. Sbaj ni t'ilan oj chicnajuca. Eso sí, ja huego nac'an musan to t'usan ja jas huanon yaljeli pero oj ni ch'ac abxuc sbeja. ");
INSERT INTO tojNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ja ma' ay xchiquin, a yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti cho yalaa: ―Ja jas huax cala huabyexi, toj a ajyuc ja hua c'ujolexi. Chican ja jastal huaxa c'anahuex yi ja Diosi, jach ni oj yaa huilexa. Ta soc spetzanil ja hua c'ujolex huaxa maclayex ja yabali, entonces ja Diosi oj ya jac ac'ujolex mas. ");
INSERT INTO tojNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porque ja ma' huax yab sbej ja jas huax cala, oj to ni jamxuc mas ja sata. Jaxa ma' quechan huas smacla, mi jachucuc ay ja sc'ujoli, ja t'usan huas snaa, oj ni aajuc ch'ay sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ja Diosi ja jastal huax atji ja ba sc'ujol ja ma' yaunej sbaj ba oj c'ulajuc mandar, lajan soc jun huinic huas stz'unu can ja inati, ");
INSERT INTO tojNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ti xa huax huaja. Huax huaj como jastal ja smodo culan yuji. Ja acuali huax huayi, jaxa sacbeli huax q'uei. Mi jauc huan sc'ulajel pensar ta huan sitz'el ja inat jau stz'ununeji. Mey sc'ulan pensar jas ora oj eluc. ");
INSERT INTO tojNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Como smodo ni ja luuma. Stuch'il huax q'ui ja sbaali. Bajtan huax q'uii, ti huax jac ja yal jia, jaxa tzaani, ti huax ajyi ja sata. ");
INSERT INTO tojNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Cuando c'an xa, es que yuj ni mojan xa jach'oji. ");
INSERT INTO tojNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ti cho yala ja Jesusi: ―Ja jastal huax pojxi el ja abal it jastal huax c'ulhuani mandar ja Diosi, oj cala huabyex otro jun loil. ");
INSERT INTO tojNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Lajan soc ja ch'in sbac mostaza. Jel ja inat ja ba luumi pero quechan mas ch'in ja iti. Cuando huax moc' ja ba yoj alaji, ");
INSERT INTO tojNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Huaj to ahuile, tz'ipan xa eq'ue. Jun jabil mi ma' oj sc'oc ja sc'abi, quechan yen mas nihuan oj ajyuc soc ja smoj c'ulili. Jel huax ajyi ja sc'abi, jaxa yalchani huax jac sc'ul ja soj ja ba spimil ja sc'abi como ay yaxubil ja tihui, xchi ja Jesusi ja huan seejel yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jel ni sea yi ja cristiano ja Jesús ja yabal ja Diosi pero mi juntiro clarouc yala. Pero cuando huax yila ja Jesús mi xa huan to smaclayei, ti xa huax ch'ajbajia. ");
INSERT INTO tojNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Huax ya slaj loil ja jas huax yal yab ja cristiano pero ja snebuman jumasa, claro ni huax yal yabyea. ");
INSERT INTO tojNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ja mismo c'ac'u jahui, cuando och ja acuali, ti yal yabye ja snebuman jumasa: ―Huajtiquic xa. Oj xa ec' jc'utztic ja jai, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ti ch'ac sc'um can ja cristiano jumasa. Jaxa yeni mi ni t'un xchapa sbaja. Jach ni huaj ja jastal ni ayi. Ja' ni huajye soc ja mismo barco ja ba culane eq'ue. Soc ay ni chaboxe yal barco huaj nochana. ");
INSERT INTO tojNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bej xa aye cuando jac jun tzatzal ic'. Spuctzin sbaj ja ja' ja ba barco. But' ja' ja yoj barco, jaxa snebumani huane xta yaljel que oj bi ibjaaxuc ja sbarco. ");
INSERT INTO tojNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jaxa Jesusi huan huayel ja ba stop ja barco. Ti baan ec' ba jun scolchonil ja barco. Ti huaj syujquesea, ti yalahuea: ―Jaxa huen Maestro, ¿mi huaxa naa que oj xa huajcotic ja' ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jaxa Jesusi ti xa q'uea. Ti scomo ja iq'ui. Ti yal yab ja ja' que oj ch'ajbajuc. ―Laman la ajyi, xyutaj. Jaxa ch'ac yali, ch'abaji huego ja iq'ui. Xlamami huaj juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ti yal yab ja snebumani: ―¿Jasyuj ja huanex ta xihueli? ¿Yuj ama mi ni t'usan huaxa c'uanex ba? x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jaxa yenlei jel och juntiro ja spensarei. Ti yala sbaje yenle itaa: ―¿Jas huiniquil ja iti? Ja jai soc ja iq'ui, ¡pe huax c'uaji tac! ");
INSERT INTO tojNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ja Jesusi soc ja snebuman jumasa ti c'otye ja ba otro lado sti ja jai, ja' ni ja slugare ja suinquil ja Gadara. ");
INSERT INTO tojNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cuando ch'ac couc ja ba barco ja Jesusi, ti jac tajuc huego yuj jun huinica jaxa huinic jahui, ja' ixtalanubal lec yuj ja pucuji. Ti el jan ja ba campo santo ");
INSERT INTO tojNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Porque ti xa ni huax ajyi ec' ja tihui. Mi xa ni huan tox bob mochjuca, mi ni soc cadena. ");
INSERT INTO tojNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mi naben jaye vuelta huax mochji yi ja yoqui. Huax aaji och yi scadenail pero ja cadena, pedazo huax ch'ac ya huajuc, jaxa cuando mochan ja yoqui, lajan soc mi mochanuc huax yab ja yen. Mi ni june ja ma' huax bob ochuc ja ba sti sati. ");
INSERT INTO tojNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","C'ac'u acual huax bejyi eq'ue. Huax huaj ja ba huitzi, ti huax cho huaj ja ba campo santo. Lom xta huan ahuanel eq'ue. Ti huas stulu jun ton. Huax ch'ia soc ja sbactel ja ton jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jun ta repente yila najat ja Jesusi. Ti huaj ajnela. Huaj stae. Ti co mec'an ja ba sti sati: ");
INSERT INTO tojNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","―A Jesús, ja huena ni ja yunina Dios jel nihuani. ¿Jastal aya jmoc ja huen ba? Por Diosito, tz'acataluca, moc lomuc jas oja c'ul qui, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jach yala porque yala ja Jesusi que oj bi yacta can ja huinic jau ja pucuji. ");
INSERT INTO tojNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ti yala ja Jesusi: ―Jaxa hueni, ¿jas abiil ba? ―Jel ni ja jbiil huax alji jbaji porque jel ni jitzanoticon, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ti och sc'an yi lec pavor ja Jesusi que mi bi oj jecjuque ba otro lugar, ti bi oj canuque ja ba mismo lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Iday, tey jun huitz ti ta mojan ay ja tihui. Tey jun montón chitam huan huael ja ba huitz jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","―C'ulan quiticon lec pavor. Jecahuoticon soc ja tantic chitam jumasa jahui ba oj bob ochcoticon ja ba scuerpoei, xchiye xta spetzanil ja pucuj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","―Pues lec, caaxic, xchi ja Jesusi. Jaxa pucuj jumasa ti yactaye can ja huiniqui. Ti huajye soc ja chitam jumasa jahui. Chab mil ja chitam jau huane huaeli. Iday, ja chitam jumasa, lom xta xbalali ch'ac couque jan ja ba huitzi. Ti ch'ac couque ja ba yoj jai. Ti ch'ac siq'ue jaa. Ch'ac chamuque spetzanil ja chab mil chitam jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jaxa matic huan stalnajel ja chitam jumasa jahui, ti ch'ac spaque ajnela. Ti huajye ba yoj chonabi soc huajye ba sti ja chonabi. Ch'ac sloilta yabye ja cristiano jumasa, jaxa yenlei lom xta xnololji ch'ac huaj yile. ");
INSERT INTO tojNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ti c'otye ja bay ja Jesusi soc ja ma' ixtalanubal yuj ajyi ja pucuji. Ja huinic jahui ti xa culan ec'a. Lapan xa sc'u. Siempre xa smodo. Mi xa locouc. Pero ja cristiano, xihuel xihuel ni aya. ");
INSERT INTO tojNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jaxa matic yilahue tojbi ja huinic jahui, ti cho och yale yab ja tuqui, cho yalahue jastal yilahue huaj ja chitami. ");
INSERT INTO tojNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jaxa cristiano jumasa ti och sc'an yi stz'acatal ja Jesusi. Sc'anahue yi lec pavor que a el huego, que oj bi yacta can ja slugarei. ");
INSERT INTO tojNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jaxa Jesusi ti q'ue ja ba barco, jaxa huinic jau ja ma' ixtalanubal ajyi yuj ja pucuji, ti och sc'an yi jitzan stz'acatal ja Jesús ta ay modo oj huaj soc. ");
INSERT INTO tojNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jaxa Jesusi mi sc'ana oj huajuc: ―Miyuc. Mas lec cax ba hua naji soc ja hua huermano jumasa. Al yabye ja jastal jel tzamal jc'ulan ahuii, jastal jtalna ja hua yaujulali. Jach sc'ulan qui ja Cajuali, oja huute, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ti huaj ja huiniqui, jaxa slugari, Decápolis sbiil. Ti och spuc ec' ja jastal jel tzamal c'ulaji yi yuj ja Jesusi, jaxa cristiano jel och juntiro ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Como ti ni ay ba yojol ja barco ja Jesusi, ti xa ec' sc'utz otro vuelta ja jai. Cuando c'ot ja ba jun lado sti ja jai, ti ch'ac stzom sbaj jitzan lec ja cristiano, jaxa Jesusi ti can ja ba mero sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ti jac june ja ma' ay yatel ba yiglesia ja judio jumasa, Jairo sbiil. Cuando yila bay ja Jesusi, ti co mec'an ja ba sti sati. ");
INSERT INTO tojNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ti och sc'an yi lec pavora: ―Ja caq'uixi jel juntiro huan huocol. Oj c'ana hui pavor oj huajan jmoc ba oja yam yi ja scuerpo ja caq'uixi ba oj tojbuc, ba mi oj chamuc, xchi ja Jairo. ");
INSERT INTO tojNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jaxa Jesusi ti huaj soca. Jaxa cristiano ti ch'ac huajuque nochana. Pero jel aaye juntiro. Huan xta sbatalaan sbaje. ");
INSERT INTO tojNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jaxa ba yojol ja cristiano jumasa tey jun ixuca. Ay xa lajchahue jabil mi xax ec' ja scuenta. ");
INSERT INTO tojNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jel yiaj ta huocol. Jel xa jitzan ja doctor yajna ta pero mas to huax aaji ipaxuc cani. Ch'ac ta spetzanil ja staq'uini. Lajan soc mi anuc huax yab ja scuerpo. Pegor xa ay. ");
INSERT INTO tojNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ja ixuc jahui yab yabalil ja Jesusi, jayuj ti xa nochan ec' soca, pero ti lapan ja ba yojol ja cristiano. Jaxa ixuc jahui, ti syama yi ja sc'u ja Jesusi porque ");
INSERT INTO tojNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Huan xta yaljel ja sc'ujoli, anima bi quechanuc ja sc'u oj syam yii, oj ni bi tojbuca, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y meran nia, cuando ch'ac syam yi ja sc'u ja Jesusi, huego huego c'ot tec'an ja scuenta, jaxa scuerpo, jel xliquiqui huaji. Snaa huego que tojbi ta ja xchameli. ");
INSERT INTO tojNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jach ni ja Jesusi. Yab sc'ujol que ay ma' ya tojbuc porque c'ot man ba scuerpo. Jayuj ti sutu sbaja. Sobo yi ja cristiano jumasa: ―Machunc'a cab syama qui ja jc'ui? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","―Pe xa huila latzan ay ja cristiano tac, iday huaxa jobo mach'a huas syamahuoni, la chi, xchi ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ja Jesusi q'uelan jacan ay eq'ue. Huan sleejel machunc'a yamji yuji. ");
INSERT INTO tojNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jaxa ixuqui xiu juntiro. Och q'uitc'onuc ja scuerpo pero huan ni snaa jastal huaja. Ti huaj ja ba stz'eel ja Jesusi. Co mec'an ja ba sti sati: ―Quena jyamahua Cajual, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ti alji yab yuj ja Jesusi: ―Hija, yuj ja hua c'uani, tojbiya ta. Mix cham ac'ujol. Cax xa. Mi xa ni oj cho coan soc ja chamel iti, x'utji ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jach huan yaljel ja Jesusi cuando c'ot jun jecabanum. Ti el jan ja ba snaj ja Jairo, como jepe ay ja ba yiglesia ja judio jumasa. Ti yalaa: ―Ja huala aq'uixi cham ta. ¿Jas to yatel oj josjonan soc mas ja Maestro? xchi ja jecabanumi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero ja Jesusi cuando ch'ac yab ja jas yala ja jecabanum jahui, ti yal yab ja sepeil ja yiglesia ja judio, ja' ni ja Jairo ja ma' cham ta bi ja yunini: ―Mix cham ac'ujol, como c'uan, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ja Jesusi ti yala que quechan oj huaj soc ja Pedro soc ja Jacobo soc ja Juan ja yijtz'in ja Jacobo. ");
INSERT INTO tojNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ti c'otye ja ba snaj ja sepeil ja yiglesia ja judio jumasa. Jaxa naitz jahui but'el xa ja cristiano. Lom xta xuooljiye. Tuc ma' huan meba oq'uel, tuc ma' huan q'ueel sni sc'ujol yuj ja oq'ueli. Ja Jesusi, cuando yila, ");
INSERT INTO tojNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti och ja ba yoj naitzi. Ti yalaa: ―¿Jasyuj lom jel huanex oq'ueli? ¿Jasyuj jel juntiro huaxa huaahuex ja ruido? Ja aq'uix iti mi chameluc. Huan huayel tac, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jaxa mucuanum jumasa: ―Lom huan c'umal ja iti, xchiye. Pero ja Jesusi ti yal yab ja mucuanum jumasa que oj ch'ac eluque. Ti can ba yoj naitz ja snan stat ja aq'uixi soc ti ni ay ja ma' stzaunej ni ja Jesusi. Ti ochye ja ba liban ec' ja aq'uixi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti syama yi ja sc'ab ja aq'uixi: ―Talita cumi, xchi soc ja sc'umali, jaxa soc ja jc'umaltiqui: Nina, huax cala huabi, q'uean, xyutaj ja aq'uixi. ");
INSERT INTO tojNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jaxa aq'uixi, huego huego q'uei. Q'ue bejyuc. Lajchahue jabil yioj ja aq'uix jahui. Jaxa cristiano ch'ac boboaxuque juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ja Jesusi ti ch'ac scom c'ac' lec ja cristiano que mi bi ma' oj yale yab ja jastal huaj ja aq'uix jahui. Ti yala que oj xa aajuc yi ja suael ja aq'uixi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ja Jesusi ti yaa can ja lugar jahui. Ti huaj ja ba slugar ja yeni. Ja' smoj ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jaxa ba sc'ac'uil ja jijleli, ti huaj ba yiglesia ja judio jumasa, jaxa tihui, ti och see yi ja cristiano. Ja matic huan yabjeli, jel och juntiro ja spensarei, ti yalahuea: ―¿Jastal ay ja iti? ¿Ba yiaj ja svivoili? Huax bob sc'ul milagro tac. ¿Ma' ac'uni yip ja huinic iti? ");
INSERT INTO tojNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Pero ja' yunin ja carpintero tac, jaxa snani, ja' ni ja men María, jaxa yijtz'ini, ja' ni ja tan Jacobo soc ja tan José, soc ja tan Judas, soc ja tan Simoni. Jaxa ixuquei, pero jmojtic ni taca, xchiye xta. Jayuj mi ni t'un yaahue casoa. ");
INSERT INTO tojNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jayuj ti yala ja Jesusi: ―Jach ni ja aluman‑Dios jumasa. Jel gusto iljiye ja ba otro lugari, pero ja ba mero xchonabilei, soc ja yermano jumasa, ja ba yoj snajei, jel ch'in iljiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jayuj mi ni bob sc'ul milagro ja tiu ja Jesusi. Quechan syama yi ja scuerpo chaboxe cristiano ja ma' malo ayei, jaxa yenlei tojbiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pero ja tuc jumasa, jel och ja spensar ja Jesusi porque mi ni t'un huax c'uajia, jayuj ti el ja tihui. Ti xa huaj ec' ja ba yal hacienda jumasa ja ba mojan yaman ja tihui. Huaj see yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jaxa ec' ja c'ac'u jumasa jahui, ti c'umajiye ja lajchahuane jau yuj ja Jesusi. Naca cuagrilla cuagrilla bi oj yi sbaje ja ba oj huajuquei. ―Caxic xa. Huax caa huatelex ba oj bob ac'uluquex mandar ja pucuji, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Mi bi jas oj yie eq'ue. Mi bi oj yii ja snutiei, soc mi ni ja yoot spichei, soc mi ni bi jun centavo oj yie ja ba smorralei. Quechan bi oj yie ja snajbantei. ");
INSERT INTO tojNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Soc oj bi slap ja xanabei pero malan bi soc ja sc'ue lapan yujilei. ");
INSERT INTO tojNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","―Huan c'ax aaji ochanic ba jun naitz, ti la ajyiyex ja tihui masan to oj elanic ja ba lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pero ta ay c'a jun lugar mi huas sc'ulanex recibir, mi huas smacla ja jas huaxa hualahuexi, pues elanic ja tihui. Tzijunic can ja spolvoil ja hua huoquexi. A yil can sbaje. Ja c'ac'u oj yae yi cuenta ja Diosi, ¡ay pobre ja yenlei! Mas lec oj ajyuc ja suinquil ja Sodoma soc ja suinquil ja Gomorra que yuj ja suinquil ja chonab jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jaxa snebuman ja Jesusi ti huaj yale yab ja cristiano jumasa que aa xa bi suchuc ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jel jitzan ja cristiano actaji can yuj ja pucuj jumasa yuj ja jach ni sc'ulan mandar ja snebuman ja Jesusi, jaxa matic malo ayei, quechan jaxji yile aceite ja s'olomei, ch'ac ni tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ja rey Herodesi ti yab yabalil ja Jesusi porque pucan xa ni yabalila: ―Ja' ni ja Juan it huax yaa bautismo ajyi, jayuj jel ja jas huax bob yujili. Eso sí, cham ta nia, pero seguro cho sacui ta, xchi ja Herodesi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jaxa tuqui: ―Miyuc. Ja' ni ja Eliasi. Jaxa tuqui: ―Ja' ma aluman‑Diosi, ma ja' june ja aluman‑Dios ba najatei, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jach c'ot xchiquin ja rey Herodesi. Ti yalaa: ―Seguro ja' ni ja Juani. Eso sí, cham nia porque jeca ni c'utzuman ja s'olomi, pero cho sacui ta, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porque yena ni ja Herodes jau yaa smandar ba oj yamjuc ja Juan ajyi. Xch'ica ba preso y cho smocho soc cadena. Jach ni sc'ulana yuj ja scuentosil ja ixuc Herodíasi. Ja Herodíasi, ja' statam ja yijtz'in ja rey Herodesi, Felipe sbiil. Jaxa xcheum ja Felipe, japji yuj ja sbanquil rey Herodesi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jaxa rey Herodesi ti alji yab yuj ja Juani: ―Ja ixuc jahui, ja' ni sbaj ja hua huijtz'ini. Mi sbejuc huaxa cheuman, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Jayuj ja ixuc Herodíasi, jel coraja ay soc ja Juani. Huan xchapjel yabalil. Huas sc'ana oj smile pero mi bob yujil ");
INSERT INTO tojNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Porque ja rey Herodesi, xihuel xihuel ay yuj ja Juani. Huas snaa que jel toj ay soc mi huas slea ja smuli, jayuj mix yaa orden ba ay jas oj c'ulajuc yi ja Juani. Huas smacla ja jas huax yala ja Juani, anima mix yab sbej, pero jel ni ja sganaa. ");
INSERT INTO tojNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero c'ot ni ja c'ac'u bob yujil ja jas huas sc'ana ja ixuqui. Ja rey Herodesi yaa jun q'uin, como ja' ni ja sc'ac'uil ja sq'uini. Sloco ja ma' ay yatel yuji, soc ja soldado jumasa, soc ja ma' ay yatel ba Galilea. Sloco ba jun huaelal. ");
INSERT INTO tojNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti och ja yal ja ixuc Herodíasi. Ti och chaanuca. Jaxa rey Herodesi, jel sgusto, jach ni ja smoj huael jumasa. Ja reyi ti yal yab ja aq'uixi: ―Chican jas huaxa c'ana qui, oj ni caa huia. ");
INSERT INTO tojNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Xila Dios, hasta snalan ja ba huax c'ulan mandari, oj caa hui, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jaxa aq'uixi ti ela. Ti huaj yii yabal ja snani. ―¿Jasunc'a lec oj c'an yii? xchi ja aq'uixi. Jaxa snani ti yalaa: ―C'ana yi ja s'olom ja tan Juan it huax yaa bautismo, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jaxa aq'uixi, ti cho och huego ja ba sti sat ja reyi, ti yal yaba: ―Ay ni jas huax c'ana oj c'an ahui Señor Rey. Huax c'ana oja pach jan qui ba jun plato ja s'olom ja tan Juan it huax yaa bautismo. Pero aa qui huego, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jaxa rey Herodesi, jel tristeaxi pero como yab ja smoj huael jumasa soc jel tzatz ja sti yala, jayuj mi sc'ana oj stucbes ja spalabra. ");
INSERT INTO tojNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Huego spaya jan june ja soldado ja matic huas stalna ja snaj ja reyi. Oj bi huaj yii jan ja s'olom ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ti huaj ja soldado jahui, jaxa ba yoj preso, ti sc'utzu el yi ja s'olomi. Ti yaa ba jun plato. Ti spacha och yi ja aq'uixi, jaxa aq'uixi ti yaa yi ja snani. ");
INSERT INTO tojNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ti c'ot xchiquin ja snebuman ja Juani. Ti jac yie ja scuerpo. Ti smucuhue ba jun q'ueen. ");
INSERT INTO tojNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jaxa matic jecji yuj ja Jesús ba oj huaj sloiltaye ja yabal ja Diosi, cuando ch'ac sloiltaye eq'ue, ti cumxiyea. Ti huaj yale yab ja Jesusi ja jastic sc'ulanei. Cho yalahue yab jastic seahue yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ti yala ja Jesusi: ―Lec ay, la xa huajtic ba jun lugar ba mey lec ja suinquili ba oja huii ahuipexi, xchi ja Jesusi. Porque jel xa jitzan ja cristiano. Tuc ma' huan cumxel ba snajei, tuc ma' huan c'otel ja bay ja yenlei. Mi xa ni ba oj huauque, mi xax bob yujile. ");
INSERT INTO tojNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jayuj ti spila sbajea. Soc barco huajye ba jun ch'ayan lugar. ");
INSERT INTO tojNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero iday, mi bob yujile. Iljiye huajye. Naaji sbaje que yenle. Jaxa ma' yila, ja' ni ja suinquil ja chonab jumasa mojan ja tihui. Ti cho huajye nochan ja yenlea. Soc yoque soybaye ja jai, jaxa mi tox c'ot ja Jesús soc ja snebuman jumasa, ti xa aye ja cristiano jumasa. Huane xta smajlajel oj c'otuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jaxa Jesusi, cuando c'ot ja tihui, ti co ja ba barco. Cuando yila tey jun nole ja cristiano, ti stalna syaujulalea. Lajane bi soc jun nole chej pero mey talnuman. Ti och see yi jitzan cosa. ");
INSERT INTO tojNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cuando jel xa och ta c'ac'u, ja snebuman jumasa ti jac ja bay ja Jesusi. Ti yalahuea: ―Pero ja lugar iti, jel najat ay y jel xa och ta c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mas lec al yab ja cristiano que aa xa huajuque. Tix huajye ja ba yal hacienda ja ba yal lugar jumasa ba mojani. A huaj sman ja yoot spichei porque mi xa ni jas yiojea, xchi ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ti yala ja Jesusi: ―¿Jaxa mi xa huaahuex yi ja suaele ja huenlex ba? Ti yala ja yenlei: ―Pero Cajual, ¿jastal ay ba? ¿Oj ma bob huaj manticon dosciento peso ja pan ja quenticon ba oj caaticon ja suaele ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","―Cax ilahuic jaye pan ahuiojex ja huenlex ba, xchi ja Jesusi. Jaxa snebuman jumasa, cuando yilahue jaye pan yiojei, ti yalahue yaba: ―Pe quechan xta joe pan soc chab ala chay, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ti yala ja Jesús que oj bi ochuque culan ba yoj job ja cristiano jumasa, que oj bi yii sbaje jujun nole. ");
INSERT INTO tojNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jach ni sc'ulanea. Ay ba yioj sbaje cien, soc ay ba cincuenta cada yal nole jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jaxa Jesusi ti yiaj ja joe pani soc ja chab chayi. Sq'uela q'ue ja ba satq'uinali, ti yaa yi stz'acatal ja Diosi. Ti spilaa. Yaa yile ja snebuman jumasa ba oj ya ec' yi ja cristiano. Soc jach ni ja chab chayi. Spilahue yi ja cristiano, iday, yaa ba spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mi ni june ma' mi huaa. Ch'ac but'uque lec. ");
INSERT INTO tojNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cuando ch'ac stzome ja sobra ja pani soc ja sobra ja chayi, cho but' lajchahue mooch. ");
INSERT INTO tojNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jaxa janec' huaayei, cinco mil huinic. ");
INSERT INTO tojNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ja Jesusi ti yal yab ja snebuman jumasa que oj xa bi huajuque soc barco ba Betsaida ja ba otro lado sti ja jai. Jaxa yeni oj to bi sc'um can ja cristiano jumasa, ti bi oj cho huajuca. ");
INSERT INTO tojNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jaxa cuando ch'ac sc'um can ja cristiano jumasa, ti huaj sc'umuc ja Diosi ja ba jun huitz. ");
INSERT INTO tojNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jaxa och ja acuali, ti xa ay ja snebuman jumasa ja ba sbarcoei ja ba snalan ja jai, jaxa Jesusi ti to ay ja ba huitzi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ja Jesusi yila que jel huane huocol soc ja sbarcoei. Jel xa yajtique soc ja snicjeli porque ja iq'ui ti jacum ja ba lado huane huajeli. Ja Jesusi ti huaj snoch ja snebuman jumasa, pero ti huan bejyel och ja ba sat ja jai ba oj ec' toj eq'uel, pero sbaj xa xchanil gallo. ");
INSERT INTO tojNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero ja snebuman jumasa, cuando yilahue que ti huan bejyel jan ja ba sat ja jai, mi snaahue machunc'a. Jel tuc yilahue ja scuerpo. Ti ch'ac ahuanuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jel xiuye juntiro. Spetzanile ch'ac yile. Jaxa Jesusi ti c'umani: ―Mi la xiuyex. Quena nia. Tzatz la ajyiyex. ");
INSERT INTO tojNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ti q'ue ba barco ja Jesusi. Scomo ja iq'ui. Jaxa snebuman jumasa ch'ac paxuque boboil. Jel och juntiro ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ja ora jahui, eso sí, yilahue jastal jitzanbi ja pani, pero mi jauc jac sc'ujole. Lajan soc mi yilunejuque. ");
INSERT INTO tojNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cuando ch'ac sc'utze ja jai, ti c'otye ja ba jun lugar Genesaret. Ti smochohue can ja sbarcoei ja ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cuando ch'ac couque ja ba barco, huego huego naaji sbaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jaxa ba spetzanil ja lugar ja ba mojan yamani, sac ajnel xta ch'ac jacuque ja cristiano jumasa. Ch'ac yie jan ja ma' malo ayi. Soc xch'atilteil huas slicahue jani, chican ba lugaril huax yabye bay ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chican ba huax huaj ja Jesusi, sea ba yal hacienda, sea ba chonab, ma ba sti ja chonabi, ti huax huaj tajuc yuj ja cristiano. Huax yiaje jan ja chamum jumasa. Ti huax yaahue can ba calle. Ti huax huaj sc'ane yi lec pavor ja Jesusi, anima bi quechanuc ja snich ja sc'u oj yamjuc yii. Y meran nia, spetzanil ja ma' syama, ch'ac ni tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ja fariseo jumasa soc chanjoe ja ma' huas sea ja smandar ja Moisesi ti huajye ja bay ja Jesusi. Ja yenlei ti elye jan ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cuando yilahue jastal huane huael chaboxe ja snebuman ja Jesusi, ti sleahue yi ja smula porque mi bi sbejuc ja jastal sac'ahue ja sc'abei. Jel bi cux ja sc'ab huas syamahue ja suaelei. ");
INSERT INTO tojNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ja fariseo jumasa, jach ni spetzanil ja cristiano judio, culan ni yujile jitzan vuelta huas sac'a ja sc'abei. Ja costumbre iti, ja' ni sbaj ja ma' ec' pax ta yujilei. Mi c'a huas sac'ahue jitzan vuelta, mi ni bi modo oj bob huauque. ");
INSERT INTO tojNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cuando huax huajye ba plaza ti huax cumxiye ja ba snajei, mi c'a huas sac'a jitzan vuelta ja sc'abei, mi ni bi oj huauquea. Jitzan lec ja scostumbre yioje xa ja jastal jahui. Jach ni ja svasoe ja ba huax yuaje ja' soc ja jarro jumasa soc ja oxom taq'uini. Hasta ja suaynubei, huas sac'ahue lec. ");
INSERT INTO tojNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jayuj ti jac sobe yi ja Jesusi ja fariseo jumasa soc ja ma' huas sea ja smandar ja Moisesi: ―Ja hua nebuman jumasa mi ni t'un huas squitz'ahue ja scostumbre ja ma' ec' pax ta cujtiqui. Pe scuxil sc'ab huax huaaye tac. ¿Jasyuj jach huas sc'ulane ba? ");
INSERT INTO tojNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ti yala ja Jesusi: ―Ja huenlexi toj chab cara ayex. Meran ni ja jastal staahuex ti' ja Isaiasi: Ja cristiano jumasa iti huas sea sbaje que huas squitz'ahuone. ");
INSERT INTO tojNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jel tzamal ja sc'umalei, pero iday, ja sc'ujolei, mi ni t'un huas squitz'ahuone. Ja' bi ja ba sti jsati huas stzomo sbaje, pero lom ni juntiroa. Ja jas huane seejeli, spensar ni yenlea, xchi ni ja Isaías tac. ");
INSERT INTO tojNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Huaxa huaahuex can jun lado ja smandar ja Diosi, jaxa jastic culan ahuujilexi, ja' jel nihuan ahuiojex. Q'uelahuilex ja jastal huaxa sac'ahuex ja hua jarroex soc ja hua vasoexi. Montón jastal jau huaxa c'ulanexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Soc ay jas mas yala: ―Jel ni vivoexa. Jel xa naahuex jastal huaxa c'ulan ja hua costumbreexi, jaxa smandar ja Diosi, huaxa huaahuex can jun lado. ");
INSERT INTO tojNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","¿Mi ma yala ja Moisesi que oj bi yajtatic ja jnan jtatiqui, jaxa ma' huas staahue ti' malo ja snan stati, oj ni bi aajuc ch'ay snaajela? ");
INSERT INTO tojNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jaxa huenlexi, at ja jas huaxa hualahuexi: Naney, tatey, eso sí, huax c'ana jcoltayex nique ajyi pero spetzanil ja jas quioji, naca caunej yi ja Diosi, huaxa huutajex ja hua nan atatexi. Jach huaxa jeahuex yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jaxa cristiano, mix bob scolta mas ja snan statei pero ja' yuj ja hua mul ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lamlamil jach huaxa jeahuex yi ja cristiano. Puro ja' hua costumbreexi, jaxa yabal ja Diosi, lom ni altiro ahuujilexa. But'elex soc ja hua modoex ja jastal jahui, x'utji ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ja Jesusi ti spaya jan ja jun nole cristiano ja tihui, ti ch'ac och aljuc yabyea: ―Maclayic apetzanilex. Naahuic t'unuc ja sbeji. ");
INSERT INTO tojNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ja jas huax och ba hua tiexi, mi jauc oj jomanic yuj. Ja jas huax el ja ba hua tiexi, ja' mero huas somohuex. ");
INSERT INTO tojNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ja ma' ay xchiquin, a yabi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ti xa spila sbaj soc ja cristiano jumasa. Cuando och ja ba yoj naitzi, ti jobji yi yuj ja snebuman jumasa jastal ay ja loil it ch'ac ta yali. ");
INSERT INTO tojNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ti yala ja Jesusi: ―Jaxa huenlex chomajquili, ¿yuj ama mi ni t'un huaxa huabyex slugaril ba? ");
INSERT INTO tojNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","20","¿Mi ma huaxa naahuex ja jas huax och ba hua tiexi, mi jauc oj jomanic yuj? Ja jahui mi jas yioj ba hua hualtzilexi. Ja jas huax och ba hua tiexi, ti huax co ba hua lucumexi, jaxa ba ja hua lucumexi, toj eq'uel huax eq'ui, xchi ja Jesusi. Cuando jach yala, slugar que yala que lec yabjel spetzanil ja huaelali. ");
INSERT INTO tojNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ja' bi ja jas huax el ja ba jtiitiqui, ja' bi oj jomcotic yuj, mi bi jauc ja juaeltiqui. Porque ja' ni ja caltziltiqui, ti huax jac ja malo jpensartiqui. Huax leatic ja tuc jcheumtiqui, ma ja tuc huiniqui. Lajan soc chante ja jpensartiqui, huala milhuanitic, como ti ni ay ja ba caltziltica. ");
INSERT INTO tojNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Huala elc'anitic. Jex c'anc'oni ja jc'ujoltiqui, chican jas malo huax c'ulantiqui. Huax lola jbajtic. Toj malo ja jpensartiqui, envidiosootic, huala c'umanitic malo, huax toyo jbajtic, jel bobootic. ");
INSERT INTO tojNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Spetzanil ja jastal jahui, ti ni cajan jc'ujoltica. Juntiro huax jomo jbajtic. ");
INSERT INTO tojNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ja Jesusi ti xa el ja tihui, ti huaj ja ba lugar mojan ja ba Tiro soc ja ba Sidoni. Cuando c'ot ja tihui, ti och ba jun naitz. Mi sc'ana oj see sbaj satalajel abal pero mi ni modo huax bob yujila. ");
INSERT INTO tojNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ti abji yabalil yuj jun ixuc, jaxa ixuc jahui, ay yal. Ja yal yaq'uixi ixtalanubal yuj ja pucuji. Ti huaj ja bay ja Jesusi, jaxa ixuqui ti co mec'an ja ba sti sati. ");
INSERT INTO tojNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ti och sc'an yi jitzan pavor ba oj sc'ul mandar ja pucuji ba oj actajuc can ja yali. Sirofeñera ja yeni. Griego huax c'umani. ");
INSERT INTO tojNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ti alji yab yuj ja Jesusi: ―¿Mi ma sbejuc bajtan huax huaa ja yal untic ba? Jel piero ta huan c'ax japxi ja suael ja yal untiqui oj aaxuc yi ja ma' mix naaxi sbaji, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","―Meran Cajual. Eso sí, anima tz'iuc pero q'uelahuil jun ula tac. Huax jac ja ba jun naitz, anima jauc ja sobra pero oj ni aajuc yia, xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ti yala ja Jesusi: ―Caax xa. Yuj ja jel tzamal ja jas ahualai, ja hua huali libre xa aaji ta can yuj ja pucuji, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y meran nia. Yajni c'ot ja ba snaj ja ixuqui, huaj yile, lec xa ay ja yali. Ti to ni baan ec' ba sat ch'at pero mi xa ixtalanubaluc yuj ja pucuji. ");
INSERT INTO tojNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ja Jesusi ti yaa can ja lugar mojan ba Tiro. Toj eq'uel ec' ba Sidón soc ba Decápolis masan c'ot ja ba ja' sbaj Galilea. ");
INSERT INTO tojNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Cuando ti xa ay c'ot ja tihui, ti iiji jan yi jun huinic sordo ay y jel queec huax c'umani. Ti c'anji yi pavor ja Jesusi ba oj syam yi ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ja Jesusi ti spila sbaj soc jun maq'ue ja huinic jau sordo ay y queec huax c'umani. Ti smaca soc ja xchiquin ja yal sc'abi. Yajni ch'ac sc'uluc ja jachuqui, ti tzujbania. Ti syama yi ja yac'a. ");
INSERT INTO tojNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ja Jesusi ti sq'uela q'ue ja satq'uinali. Sic'a sc'ujol: ―Efata, xchi soc ja sc'umali. Oj xa huab q'uinal. Oj xa bob c'umanan claro. Jach sbej ja jas yala. ");
INSERT INTO tojNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y meran nia. Huego huego jamxi ja xchiquini, jaxa yaq'ui lajan soc tzatzbel ajyi, jaxa ora jahui, huego huego c'umbi. Jel claro el ja sc'umali. ");
INSERT INTO tojNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ja Jesusi ti och sc'an yi lec pavor ja cristiano jumasa que mi ni ma' oj yale yab ja jastal tojbi ja huinic jahui. Pero lajan soc sulbes ita ja cristiano. Yochele ec' ch'ac spuque ec' jastal tojbi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jel och juntiro ja spensarei, ti yalahuea: ―Jel ni tzamal spetzanil ja jas huas sc'ulani. Huax ya yab q'uinal ja ma' tupel xchiquin, jaxa matic mudo, huax ya c'umanuc, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja c'ac'u jumasa jahui lom xta xnoloji huax jac ja cristiano jumasa ja bay ja Jesusi, iday, mi xa ay ja suaelei, como ch'ac ta. Ja Jesusi ti spaya jan ja snebumani, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―¡Jel ajul ja sbaj ja cristiano jumasa iti! Ay xa oxe c'ac'u ti jmoctica y ch'ac ta yoot spichiei. ");
INSERT INTO tojNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Huan c'ax cal yab oj huajuque ba snajei, oj ch'ac yipe ja ba beji porque oj xta syatz'atz'uc ja yaltzilei yuj ja huaini porque ay ma' jel najat jaquele, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ti yala ja snebuman jumasa: ―Pero Cajual, jel ch'ayan lugar juntiro tac. ¿Ba xa oj yie ja suaele ba? ¿Jastal oj bob but'uque ja ili? ");
INSERT INTO tojNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ti yala ja Jesusi: ―¿Jaye ja pan ahuiojex ba? ―Quechan xta juque, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ja Jesusi ti yal yab ja cristiano oj ochuque culan ba yoj job. Ti yiaj ja juque pani. Yaa yi stz'acatal ja Diosi, ti spila yi ja snebuman jumasa, jaxa snebumani ch'ac ya ec' yi ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ja snebuman jumasa cho ay yioje chaboxe chay. Ja Jesusi ti sc'ana yi stz'acatal ja Diosi. Ti yal yab ja snebumani oj cho ch'ac yaa yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ja cristiano jumasa ti och huauquea. Butye lec. Cuando ch'ac huauquei, ti och stzome ja jas can sobra. But' juque mooch. ");
INSERT INTO tojNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Chane mil cristiano huaa ja ora jahui. Jaxa Jesusi, ti xa sc'uman can ja cristiano jumasa. Ti q'ue jun barco soc ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ti huajye ba jun lugar Dalmanuta. ");
INSERT INTO tojNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jaxa ba lugar jahui, ti jacye chaboxe ja fariseo jumasa. Jac yie loil ja Jesusi. Eso sí, jacye pero mi slequiluc sc'ujole. Oj bi jeejuc yile jun seña ja ba satq'uinali ti bi oj snae que meran tey soc ja Dios ja Jesusi, pero como quechan huane sc'ulajel probar. ");
INSERT INTO tojNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ja Jesusi ti syatz'a sbaj ja yaltzili, ti yalaa: ―Ja cristiano iti, quechan huane sc'anjel que oj bi yile jun seña ba jel ja smilagro pero ja mero smeranili, mi jas oj jeexuc yile, xchi ja Jesusi. Quechan alji can yabye jachuc, ");
INSERT INTO tojNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ti xa huaja. Cho q'ue ja ba barco, ti cho ec' sc'utz ja jaa. ");
INSERT INTO tojNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pero ja snebuman jumasa ch'ay sc'ujole mi yiaje jan ja pani. Quechan june altiro ja pan ti nolan yujile ja ba barco. ");
INSERT INTO tojNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ti yala ja Jesusi: ―Aa cuidadoex soc ja slevadurail ja fariseo jumasa soc ja tan Herodesi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","―¿Jas sbej jach huax yala cabtic ba? ¿Yuj ama jayujil huax yala yuj ja ch'ay jc'ujoltic mi quiajtic jan ja pan ba? Jach och sobtalauc sbaje ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ja Jesusi cuando yab ja jas huane yaljeli, ti yalaa: ―¿Ja' ma pan huanex xta staajel ti' ba? Mi ni t'un huaxa naahuexa. ¿Mi ni ma t'un huax jac ac'ujolex ba? Lajan soc mi teyuc ja hua c'ujolex huaxa huilahuex ja jas huax c'ulani. ");
INSERT INTO tojNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Eso sí, ay asatex, pero mila ilhuaniyex. Ay achiquinex pero lajan soc mi xa huabyex q'uinal. A jac t'un ac'ujolex. ");
INSERT INTO tojNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ja yora quechan xta joe pan quiojtiqui, jpila yi ja cristiano jumasa, iday, joe mil huaaye, jaxa sobrai, ¿jaye mooch atzomohuex ba? ―Lajchahue, xchi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Jaxa it yora quechan xta juque pan quiojtiqui, jpila yi ja cristiano jumasa, ¿jaye mooch atzomohuex ja sobra ba? ―Juque, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","―Iday, ja huilunejex pero mi ni t'un huax jac ac'ujolexa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ti c'otye ja ba lugar Betsaida jaxa tihui, ti iiji jan yi jun huinic tupel sat. Ti c'anji yi pavor ba oj syam ja sati. ");
INSERT INTO tojNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ja Jesusi ti syama yi ja sc'ab ja huiniqui. Xchecha el ja ba sti hacienda, jaxa cuando ti xa aye ja tihui, ja Jesusi ti ya och yi t'usan ja yaal sti ja ba sat ja huiniqui. Ti saxa yi ja sati. Sobo yi ta ay jas huax yila. ");
INSERT INTO tojNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jaxa huiniqui ti sacha ja sati, ti yalaa: ―Lajan soc te' huax quila pero ¡huan bejyel tac! ¡Ja' ma cristiano jahui! xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jaxa Jesusi ti syama yi otro vuelta ja sati. Yajni ch'ac syam yi, huego huego yila q'uinal lec. Tojbi ja sati. Claro juntiro huax yila ja cristiano, y najat lec. ");
INSERT INTO tojNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","―Lec, caax xa. Cax ba hua naji. Moc lom huajan ja ba yoj hacienda. Mi lom xa hual yab ja suinquil ja hacienda jastal tojbia, xyutaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ja Jesusi soc ja snebuman jumasa ti stulu ja sbejei. Yabalil ti oj huajuque ja ba yal lugar jumasa ja ba huas sc'ulan mandar ja Filipo, Cesarea sbiil. Cuando bej to aye, ja Jesusi ti sobo yi ja snebuman jumasa: ―Jaxa cristiano ba, ¿mach ayon ja huax yalahuei? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ti sac'a jan ja snebuman jumasa: ―Ay ma' huax yalahue que huena bi ja Juan it huax yaa bautismo ajyi. Jaxa tuqui huax yalahue que Eliasa, jaxa tuqui huax yala que huena bi june ja aluman‑Diosi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jaxa huenlexi, ¿machunquilon huaxa hualahuex ba? Ti yala ja Pedro: ―¡Pero huena ni ja Cristoa tac! ");
INSERT INTO tojNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Cuando yab ja Jesús ja jas yala ja Pedro, ti sc'ana yile lec pavor que mi bi ma' oj yale yab ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ja Jesusi ti och see yi ja snebuman jumasa. Ja yeni ti bi coel jan ja ba satq'uinali pero oj to bi yii jitzan huocol. ―Ja banquilal jumasa soc ja nihuac pagre jumasa soc ni ja ma' huas seahue ja smandar ja Moisesi mi oj squitz'one, xchi. Oj ni chamcona pero ja huax ec' oxe c'ac'u, ti oj sachuucona, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jel claro juntiro yala jachuc. Ja Pedro ti spaya ja Jesusi. Cuando stuch'ilei, ti yala ja Pedro que mi bi lec huax yala jachuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero ja Jesusi ti sutu sbaj ja bay ja tuc snebuman jumasa. Stojtoq'uela lec, ti yal yab ja Pedro: ―Elan ba jtz'eel ja huen diablo. Mi jauc ja Dios huajel ja hua c'ujoli. Quechan cajan ac'ujol ja spensar ja cristiano, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ja Jesusi ti spaya jan ja cristiano jumasa soc ja snebuman jumasa, ti yalaa: ―Ta ay c'a ma' huas sc'ana ajyuc jmoqui, mi yen mismo oj syajta sbaj. A yaa sbaj juntiro, anima huax aaji locan ja ba cruzi. A stul ja jmodo ja queni. ");
INSERT INTO tojNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Spetzanil ja ma' huajel sc'ujol ba quechan oj ajyuc tzamali, huan nix ch'aya sbaja. Pero ja ma' huax yala, ta huala chamyon, ti la chamyona, pero siquiera oj ajyuc lec ja caltzili ‑ ja ma' jach huax yala yuj ja queni ‑ huax yala jachuc yuj ja jas jel tzamal ajc'ach huan yabjeli ‑ pues ja yeni oj ni sta ja svida ba jel lequi. ");
INSERT INTO tojNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ja ma' tey ba sc'ab spetzanil ja jas ay ja ba mundo, pero ta huan c'ax ch'ay ja yaltzili, ¿ja' ma ba slequil ja jau ba? ");
INSERT INTO tojNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¡Mi xa huala que oj bob yaa taq'uin siquiera ba oj ajyuc lec ja yaltzil ja ora jahui! ");
INSERT INTO tojNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ja cristiano, mi huajeluc sc'ujole soc ja Diosi. Otro lado ay juntiro. Mulanume nia. Oj to q'uixhuucon yuj ja yenlei. Ja queni ti coelon jan ja ba satq'uinali pero ja c'ac'u jau oj cho jacon soc ja jTati soc ja cangel jau mi cualquierauqui, oj lijpucon. Ja c'ac'u jahui oj q'uixhuucon juntiro yuj ja smodoe ja cristiano jumasa iti, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti cho yala ja Jesusi: ―Huax cala, pero meran, ay chaboxe ti ayex ja ili pero mi oj chamanic masan to oja huilex jastal jel tzamal ja ba huas sc'ulan mandar ja Diosi. Oja huilex que jel juntiro ja yipi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cuando ch'ac yal ja jachuqui, ti ec' huaque c'ac'ua. Ja Jesusi ti yal yab ja Pedro soc ja Jacobo soc ja Juani que oj bi huajuque stuch'ile ba jun chaanil huitz. Cuando c'otye ja tihui, ja Jesusi ti stucbes sbaj ba sti sat ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ja sc'ui ch'ac lijpuc juntiro. Sact'ost'os xta ch'ac huajuc. Ja sacal ja sc'ui mi ni june ma' oj bob chuc'ulanuc ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huaj to cho yile, ti xa ay ja Eliasi soc ja Moisés ja ma' ch'ac ni chamuque ja najatei. Ti xa huane loil soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ti yala ja Pedro: ―Maestro, ¡jel lec juntiro ja ti ayotic ja ili! Oj c'ulticon oxe yal naitz, june ja hua baji, soc june sbaj ja tat Moisesi soc june sbaj ja tat Eliasi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pero lom huan bulbunuc ja Pedro. Mi huas snaa jasunc'a huan yaljeli. Xihuel xihuel ay. Jach ni ja Jacobo soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Huaj to yile, jac musjuque yuj ja asoni, jaxa ba yojol ja ason jahui ti yabye jun c'umala: ―Ja iti, ja' ni ja cunini. Jel yaj huax cabi. Maclayic ja jas huax yala, xchi ja c'umali. ");
INSERT INTO tojNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huaj to cho yile, mi xa ma' tey soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuando huane xa coel ja ba huitz jahui, ti comjiye yuj ja Jesusi. Mi ni bi ma' oj yale yab ja jas ch'ac yilei. Ja yeni ti bi coel jan ja ba satq'uinali. Oj to bi chamuc pero cuando huas sacui, ti to bi oj yale ja jas ch'ac yile ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jach ni sc'ulanea. Ti och sob sbajea: ―¿Jas sbej ja huax yala oj chamuqui y huax yala oj cho sac‑huuc? ");
INSERT INTO tojNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ti sobohue yi ja Jesusi: ―Jaxa matic huas sea ja smandar ja Moisesi huax yalahue que t'ilan bi bajtan oj jacuc ja Eliasi. ¿Jasyuj jach huax yalahue ba? xchi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ti yala ja Jesusi: ―Meran nia, bajtan ni oj jac ja Eliasa. Yen oj ch'ac stojbes spetzanil. Jaxa queni, ti ni coelon jan ja ba satq'uinali pero ¿huan ma xa naahuex jas huax yala ja yabal ja Diosi, que oj ni bi quii jitzan huocola? Mi ni bi oj quitzjucona. ");
INSERT INTO tojNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ja mero smeranili, jac ni ja Eliasi, iday, sc'ulan ja sgusto ja cristiano, como jach ni huax yala ja yabal ja Diosa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ja Jesusi soc ja Pedro soc ja Jacobo soc ja Juani ti c'otye ja bay ja otro snebuman jumasa. Cho tey jun nole cristiano, jaxa matic huas sea ja smandar ja Moisesi, cho ti ni ayea. Jaxa yenlei, huane xta huooljuc c'umal. ");
INSERT INTO tojNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jun ta repente yilahue ja Jesús ja cristiano. Cham yabye. Sac ajnel ch'ac huaj yae yi Dios. ");
INSERT INTO tojNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ti sobo ja Jesusi: ―¿Jasunc'a ja hua loilex ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ti sac'a jan june ja yenlei: ―Maestro, ja queni quiaj jan ahui ja cunini. Ixtalanubal juntiro yuj ja pucuji. Mix aaji c'umanuc. ");
INSERT INTO tojNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jun ta repente huas syama ja scuerpo. Huax ya q'uitc'onuc juntiro. Huax puuxani ja stii, jaxa yeji huax ya jechjech'uc. ¡Jel xa ajul ja sbaj juntiro! Jel xa el ta sgana. Jc'ana yi stz'acatal ja hua nebuman jumasa ba oj sc'ul mandar ja tan pucuji ba oj yacta can ja cunini pero mi bob yujile, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ti yala ja Jesusi: ―¡A, ja cristiano iti mi ni t'un huas sc'uane! Ay xa tiempo ti ayex jmoc pero lom nia. ¿Jaye to tiempo oj caa jpasensia amoquex? Ja Jesusi ti yal yab ja huiniqui: ―Caax. Iaj jan qui ja hua huunini. ");
INSERT INTO tojNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ti iiji jan yi ja querem jahui. Jaxa pucuji, cuando yila ja Jesusi, ti cho och ya q'uitc'onuc tzatz lec ja queremi. Ya moc' man luum. Och sc'oc sbaj ja scuerpo. Cho ya puuxanuc ja stii. ");
INSERT INTO tojNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ja Jesusi ti sobo yi ja stat ja querem jahui: ―¿Ay xa ma tiempo jach ay ja hua huunini? ―Desde xch'inil jach huas sc'ulan, xchi ja tatali. ");
INSERT INTO tojNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Vuelta huas sipa sbaj c'ac', vuelta huas sipa sbaj ba yoj ja'. Huas sc'ana miljuc. C'ulan quiticon ja pavori. Talna jyaujulalticon, coltayoticon ta huan c'ax bob ahuuj, xchi ja stat ja querem jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ti yala ja Jesusi: ―¿Huan ma xa c'uan ta oj bob cujil? Ta huan c'a xa c'uan, mi jas mi oj bobuc. Oj ni bobuca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Huan nix c'uana, jaxa janec' mix c'uani, coltayon, xchi ja tatali, pero tzatz lec yala jachuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ja Jesusi ti yila que huan xta jaquel mas ja cristiano ja ba stz'eeli. Ti sc'ulan mandar ja pucuji: ―¡Diablo ja hueni! Huaxa maca ja sti ja querem iti. Huax hua tupuc ja xchiquini. Ja yaani huax cala huabi, elan ja ba stz'eel ja querem iti. Mi xa ni nunca oj bob ahuixtalauc mas, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jaxa pucuji ahuani tzatz lec. Con gana ya q'uitc'onuc ja queremi. Ti yacta cana. Jaxa ma' ixtalanubal ajyi, ti tup can yic'a. Lajan soc cham cani. Jaxa cristiano yala que cham ta bi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ja Jesusi ti syama ja sc'abi. Scolta ba oj q'ue culan. Jaxa queremi xachachi xta q'ue tec'an. ");
INSERT INTO tojNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jaxa ch'ac sc'uluc ja jastal jahui, ja Jesusi soc ja snebuman jumasa ti ochye ba jun naitz. Ti sobohue ja snebuman jumasa: ―Jaxa quenticon ba, ¿jastal lec mi sc'uan quiticon ja cabalticon ja tan pucuj jahui? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ti yala ja Jesusi: ―Ja jun tiq'ue jahui, mi c'a xa c'umanex ja Diosi, mi c'a xa como ja hua huaelexi, mi ni nunca oj yacta can ja yixtalajel ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ja Jesusi soc ja snebuman jumasa ti yaahue can ja lugar jahui. Bejyel huajye ja ba sutanal ja Galilea pero ja Jesusi mi huas sc'ana oj abjuc ba huajumea ");
INSERT INTO tojNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porque ja' huan seejel yi ja snebuman jumasa: ―Ja queni ti coelon jan ja ba satq'uinali pero oj c'ulajucon entregar ja ba sc'ab ja cristiano jumasa ba oj miljucon. Oj ni chamcona pero ja ba yoxil c'ac'u ti oj cho sac‑huucona, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ja snebuman jumasa, mi ni huax yabye sbeja pero como huax xiuye, jayuj mi ni sobohuea. ");
INSERT INTO tojNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ja Jesusi soc ja snebuman jumasa ti c'otye ba Capernaum. Cuando ti xa aye ba yoj snaj ja Jesusi, ti jobji yile yuj ja Jesusi: ―Jel huanex loil ja ba beji. ¿Jasunc'a ja hua loilex ba? ");
INSERT INTO tojNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jaxa snebuman jumasa, ti ch'abaji juntiroa porque ja' huane yaljel mach bi junuca mas nihuan oj huajuquei. Jach ni mero sloilea. ");
INSERT INTO tojNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ja Jesusi ti och culana. Spaya jan ja lajchahuane snebumani. Ti och sob yia: ―¿Jel ama x'oc' ac'ujolex que jel nihuan oj iljanic ba? Pues ta jach c'a huaxa c'anahuex, t'ilan oj ch'inbanic juntiro ja ba sti sat ja hua mojexi, y oj cho ahuateltayex. ");
INSERT INTO tojNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ti spaya jan jun yal querem. Ti yaa ba snalan ja yenlei, ti stelaa: ");
INSERT INTO tojNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Huan c'a xa yajta ja yal untic ja jastal ja yal querem iti, pero ja c'a yuj ja queni, quena ni huaxa yajtayonexa. Iday, ta quen c'a huaxa yajtayonex, entonces ja ma' secahuon coni, jach ni huaxa yajtayexa. ");
INSERT INTO tojNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ti sac'a jan ja Juani: ―Maestro, pero quilaticon jun huinic: Ja huen pucuj, acta can ja huinic iti, huax cala huab yuj ja sbiil ja Jesusi, pe xchi tac. Pero ja quenticoni jcomoticon porque mi ni jauc ja jmojtica, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ti yala ja Jesusi: ―Pero ¿jas sbej ja hua comohuexi? Ta ja' c'a yuj ja queni huas sc'ulan ja milagro, mi xa hualahuex que ta oj bob staon ti' malo. ");
INSERT INTO tojNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mi c'a condra huax yilahuotic, camigotic nia. ");
INSERT INTO tojNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Q'uelahuilex. Ja queni Cristoon nia, jaxa huenlexi, ti xa ayex jmoca. Ta ja' c'a yuj ja jbiili, anima jun vaso ja' huax aaji ahuilex, mi lomuc ja jahui. Ay ni jas oj sc'uluque recibir ja ma' ay jas huax yaa huilexi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Q'uelahuilex ja yal querem iti soc ja smoj yal untiquili ja janec' huas sc'uanonei. Ta ay c'a ma' huax jac som ja spensarei, mas lec a mochjuc jun sc'ab cha' ja ba snuq'ui, a jipjuc ba yoj ja'. ");
INSERT INTO tojNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jach ni ja huenlex chomajquili. Ta ja' c'a hua c'abex huax ya le ja hua mulexi, mas lec, a ch'ay snaajel. Mas lec tunco oj ochanic ja ba vida jau jel tzamali que no que tz'ican ac'abex oj huajanic yoj inpierno ja ba mi ni nunca huax bob tupuc ja sc'ajc'ali ");
INSERT INTO tojNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Jaxa yaljai mix chamye. Ja c'ac' ja tihui mi ni nunca huax tupi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ta ja' c'a hua huoquex huax ya le ja hua mulexi, mas lec a ch'ay snaajel. Mas lec renco oj ochan ja ba vida jau jel tzamali que no que tz'ican ahuoquex oj huajanic ba yoj inpierno ja ba mi ni nunca huax bob tupuc ja sc'ajc'ali ");
INSERT INTO tojNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Jaxa yaljai mix chamye. Ja c'ac' ja tihui mi ni nunca huax tupi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ta ja c'a june ja hua sat huax ya le ja hua mulexi, mas lec a ch'ay snaajel. Mas lec quechan june ja hua satex oj ochanic ja ba huas sc'ulan mandar ja Diosi que no que tey xchabil ja hua sat oj huajanic ja ba yoj inpierno ja ba mi ni nunca huax bob tupuc ja sc'ajc'ali ");
INSERT INTO tojNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jaxa yaljai mix chamye. Ja c'ac' ja tihui mi ni nunca huax tupi. ");
INSERT INTO tojNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jayuj jel ni t'ilan juntiro oj iixuc ja huocol ja janec' ti to oj ajyucotic ja ba mundo iti. ");
INSERT INTO tojNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Pero tzatz la ajyiyex. Moc alajex ja atz'am it huax pooxi, mi xa nix maconi ja mas tzaani. Pero ja huenlexi, laman la ajyiyex. ");
INSERT INTO tojNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cuando elye ja ba Capernaum, ti huajye ja ba Judea ba c'ax jun lado ja nihuanja ba Jordani. Jaxa cristiano ti stzomo sbaje otro vuelta ja bay ja Jesusi, jaxa Jesusi, como jach ni ja smodoa, ti cho och see yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ti jac ja ba stz'eel chaboxe fariseo jumasa pe quechan ba oj sc'uluque probar ja Jesusi. Ti sobohue yi ta lec c'a oj sip can ja xcheum jun huinic. ");
INSERT INTO tojNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ja Jesusi ti yalaa: ―¿Jasunc'a yala can ja Moisés ba? ");
INSERT INTO tojNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","―Ja Moisesi yena ni yala que lec bi oj sip can sbaj soc ja xcheumi pero oj bi ya el suunil, xchiye ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","―Meran nia, pero ja' yujil jel ch'uuy ja hua c'ujolexi, jayuj jach yala. ");
INSERT INTO tojNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero cuando ch'ac cujlajuc ja satq'uinali, huinic soc ixuc sc'ulan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jayuj jun huinic oj bi yaa can ja snan stati, ja' oj yii ja xcheumi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Eso sí meran, chahuane ajyi, pero cuando huax nupaniyei, jun ita huax huajyea. Jayuj mi xa ni chahuaneuque toa porque june ita ni ayea. ");
INSERT INTO tojNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jayuj mi sbejuc oja pilex ja jas ya staa sbaj ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cuando ochye ja ba naitzi, ja snebuman jumasa ti cho sobohue yi otro vuelta jastal ay ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jaxa Jesusi ti yalaa: ―Jun huinic, ta huan c'a sipa can ja xcheumi, tuc ja ma' huax yiaji, ja yeni staa ta ni smul soc ja mero xcheuma. ");
INSERT INTO tojNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Soc jach ni ja ixuqui. Ta huan c'a sipa can ja statami, tuc statam c'a huax yiaj, jach ni ja yeni, cho staa ta ni smula. ");
INSERT INTO tojNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ja Jesusi ti iiji jan yi jitzan yal untic ba oj yamjuc ja s'olomei. Jaxa snebuman jumasa ti yalahue yab ja matic huan yiijel jani que mi xa bi oj yie jani. ");
INSERT INTO tojNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cuando yab ja Jesús ja jas huane yaljeli, mi sc'ulan gusto, ti yalaa: ―Lec ja huax jac ja yal untiqui. Mi lom xa comohuex. Ja jastal ja sc'ujol ja yal untic iti, jach ni ay ja sc'ujole ja matic yaunej xa ni sbaj ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Huax cala huabyex, pero meran, mi c'a la ch'inbiyex jastal jun yal untic cuando huaxa huaa bajex ja ba sc'ab ja Diosi, mi ni modo oj bob ochanic soc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ja Jesusi ti stela ja yal untiqui. Syama yi ja s'olomei, ti sc'ulan bendiciara. ");
INSERT INTO tojNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ja Jesusi ti el ja ba naitz jahui. Oj xa stul ja sbeji, huaj to yile, ti huan jaquel jun huinica, pero ajnel ay. Jac tajuc sc'ab. Ja huiniqui ti yalaa: ―Maestro, jel leca juntiro. Ala cab jasunc'a lec oj c'uluc oj quil ja vida jau ba jel lequi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ti yala ja Jesusi: ―¿Jasyuj huaxa huala jel leconi? Mi ni june ma' lec, quechan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Mi ma huaxa naa ja mandar jumasa ja ba huax yala mi oja lea mul soc jun ixuc soc mi ni oj milhuanan? Mi oj elc'anan. Moc lomuc alee mentira. Moca lola ja hua moji. Yajta ja hua nan atati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ti yala ja huinic jahui: ―Pero jach ni huax c'ulan man jch'inila. ");
INSERT INTO tojNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ja Jesusi ti stojtoq'uelaa. Jel yaj yabi. Ti yalaa: ―Pero ay to jas huas sc'ulan ahui palta. Cax chono can spetzanil ja jastic ahuioji. Aa yi ja pobre jumasa. Jach c'a huaxa c'ulan, jel ja jas oj aajuc ahui ja ba satq'uinali. Pero caax. Cax c'ulan jachuc, ti la jac jmoca. C'uanon anima huala aaji locan ja ba cruzi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero ja huiniqui, cuando yab ja jas ch'ac aljuc yabi, cham yabi. Tristeaxi juntiro porque jel ja jastic sbaji. ");
INSERT INTO tojNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ja Jesusi ti sq'uela ja snebuman jumasa, ti yalaa: ―Ja ma' jel ja jastic sbaji, jel huocol juntiro oj yaa sbaj ja ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Cuando yabye ja jas yala ja Jesusi, cham yabye ja snebuman jumasa. Ti cho yala ja Jesusi: ―Cuntiquil, ja ma' huajel sc'ujol soc ja sastic sbaji, jel huocol juntiro huas sipa sc'ujol soc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas mi huocoluc oj ec' jun camello ja ba sotol ja tz'istaq'uini que soc oj yaa sbaj ba sc'ab ja Dios jun rico, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","―Ta jel c'a huocol oj sc'uuc ja Dios ja ma' ay staq'uini, ¿machunc'a oj bob coltajuc ba? Jach sobo ja snebuman jumasa porque cham yabye juntiro ja jas yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ja Jesusi ti stojtoq'uela otro vuelta: ―Ja cristiano, mi ni oj bob yujila pero ja Diosi, oj ni bob yujila. Ja Diosi huax bob yuj spetzanil, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ja Pedro ti yalaa: ―Entonces ¿jaxa quenticon ba, Cajual? Caunejticon can spetzanil ja jastic quiojticoni ba oj ajyucoticon amoc, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ti yala ja Jesusi: ―Pues oj cala huabyex ja smeranili. Spetzanil ja ma' yaunej can ja snaji, ma ja yermano jumasa, ma ja yermana jumasa, ma ja snan stati, ma ja xcheumi, ma ja yuntiquili, ma ja slugari, mi ni lomuca. Ta ja c'a yuj ja queni, ma ja' yujil ja abal it jel tzamali, mi ni lomuca. ");
INSERT INTO tojNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Oj ni sc'ul recibir cien tanto mas ja tiempo iti. Oj sc'ul recibir cien tanto ja snaji soc ja yermano jumasa, soc ja yermana jumasa, soc ja snan stati, soc ja yuntiquili, soc ja slugari, pero oj ni yie ja huocola. Pero ja ba otro vida oj yil ja vida jau ba mi ni nunca oj ch'acuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero jitzan ja ma' huax ilji nihuan ja huego, jel ch'in oj huajuque ja tihui, jaxa matic jel ch'in huax ilji ja huego, ay modo jel nihuan oj huajuque ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ja Jesusi soc ja snebuman jumasa soc jun nole cristiano ti huane huajel ja ba Jerusaleni. Yen bajtan ay ja Jesusi. Ti nochan ja snebuman jumasa pero xihuel xihuel aye. Jel ja spensarei. Ja Jesusi ti ch'ac spay ja ba stz'eel ja snebuman jumasa. Och yal yabye jastal oj to c'ulajuc yi: ");
INSERT INTO tojNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Q'uelahuilex. Ti xa huajumotic ja ba Jerusaleni. Ja queni ti ni coelon jan ja ba sat'quinali pero anima, oj ni c'ulajucon endregal ba sc'ab ja nihuac pagre soc ja ma' huas sea ja smandar ja Moisesi. Huane xa ni xchapjel cabalila. Oj ni sc'ulucone endregal ja ba sc'ab ja ma' mi sc'uan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Oj yaahue qui burla. Oj smac'one. Oj tzujbayone. Oj smilone pero x'ec' oxe c'ac'u, oj cho sac‑huucon, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ti jac ba stz'eel ja Jesús ja Jacobo soc ja Juani, ja' yuntiquil ja Zebedeo. Ti yalahuea: ―Maestro, ay jas oj c'anticon ahui. C'ulan quiticon ja pavori. ");
INSERT INTO tojNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","―¿Jasunc'a huaxa c'ana oj c'uluc ahuilex ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","―Pues, oj c'anticon ahui pavor, cuando ti xa aytic ja ba jel tzamal huana sc'ulajel mandari, oja huaa quiticon ja catelticon ba mas tzatzi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ti yala ja Jesusi: ―Pero mi xa naahuex jasunc'a huanex sc'anjeli. Ja queni oj ni quii ja huocola. ¿Oj ma bob ahuiex huocol ja huenlex ba? Jel ja jas oj c'ul ahuantar, ¿jaxa huenlex ba? ¿Oj ma bob ac'uluquex ahuantar? ");
INSERT INTO tojNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Pues ojo, xchiye. Ti yala ja Jesusi: ―Pues meran nia, ja jastal oj quii ja huocoli, jach ni oj cho huiex ja huenlex chomajquili. Ja jastal oj c'ul ahuantar ja queni, jach ni oj cho ac'uluquex ahuantar ja huenlex chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ba oj caa huilex ja atel ba mas tzatzi, mi ni sbajuc oj caa huilexa. Tzaubal ni ja ma' oj aajuc yii. ");
INSERT INTO tojNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jaxa lajunhuane ja snebumani, cuando ch'ac yabye ja iti, jel q'ue ja scorajae soc ja Jacobo soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ja Jesusi ti spaya jan ja otro snebuman jumasa, ti yalaa: ―Ja ba spetzanil ja lugar jumasa, ja ma' ay yateli, jel nihuan huax yaa sbaje. Jel tzatz ja smandarei. ");
INSERT INTO tojNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ja huenlexi, mi jachucuc oja c'uluquex. Ta huan c'a xa c'ana nihuan oj ajyanic, sbej ni oj ch'inbanica ba oja huateltayex ja tuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ta huan c'a xa c'ana nihuan oj ajyan ja ba sti sat ja Diosi, sbej ni ch'in oja jee abajex ja ba sti sat ja hua mojexi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ja queni, ti ni coelon jan ja ba satq'uinali pero mi jaquelucon ba oj ateltajucon. Jaquelon ba oj catelta ja cristiano soc oj caa ja jvida ba oj huajuc libre jitzan ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ti c'otye ja ba jun chonab, Jericó sbiil. Ja Jesusi soc ja snebuman jumasa ti cho smoje jun nole cristiano. Cuando elye ja ba chonab Jericó, huaj to yile, ti culan ec' jun huinic ba sti bej, jaxa huinic jahui, Bartimeo sbiil, pero tupel ja sati. Ja' stat ja Timeo. Jaxa Bartimeo huan sc'anjel limosna. ");
INSERT INTO tojNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ti yab que ja' huan eq'uel ja Jesús ja tihui, jayuj ti ahuania: ―¡Jesús, ja hueni, ja' ni ja yintila rey David tac! Talna jyaujulal, xchi xta, pero ahuanel. ");
INSERT INTO tojNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ti comji yuj jitzan cristiano pero lajan soc alji yab ba oj ahuanuc mas tzatz: ―¡Ja huen yintila rey Davidi, talna jyaujulal! xchi xta ja Bartimeo. ");
INSERT INTO tojNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ti c'ot tec'an ja Jesusi, ti yalaa: ―A jacuc ja huinic jahui, xchi ja Jesusi. Ti huaj aljuc yab ja ma' tupel ja sati: ―Mix cham ac'ujol. Q'uean xa. Cax bi oche, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ja Bartimeo ti sipa can ja scotoni. Q'uei. Ti huaj ja ba stz'eel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","―¿Jasunc'a huaxa c'ana oj c'uluc ahui? xchi ja Jesusi. ―Maestro, huax c'ana oj quil q'uinal, xchi ja ma' tupel ja sati. ");
INSERT INTO tojNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","―Huan ni xa c'uan merana. Caax xa, x'utji. Iday, huego huego yila q'uinal ja Bartimeo. Ti huaj nochan soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ja Jesusi soc ja snebuman jumasa soc jun nole lec ja cristiano mojan xa yioje ja Jerusaleni. Ti xa aye ba jun huitz Olivos sbiil, jaxa tihui ay chab yal hacienda, Betfagé soc Betania. Ja Jesusi ti yal yab chahuane ja snebumani: ");
INSERT INTO tojNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Q'uelahuilex ja yal hacienda jau mojan xa quiojtiqui. Caxic ja huenlexi. Ja ba sti ja hacienda ti oja taex jun yal burro mochante. Mi to ni ma' huax q'uea. Tucuhuic. Iajic jani. ");
INSERT INTO tojNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ta ay c'a ma' huas sobo huilex jasyujil huaxa tucuhuexi, ti xa hualahuex yabi que ja' oj maconuc yuj ja Cajualtiqui, oj bi ya cumxuc jan huego, utajic, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ti huajye ja chahuane snebuman jahui. Ti ni staahue ja yal burro ti mochan ba sti ja puerta ja ba huas spila sbaj ja beji. Ti xa stucuhuea. ");
INSERT INTO tojNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ti yilahue chaboxe ja ma' tey tihui. Ti yalahuea: ―¿Jas sbej ja huaxa tucuhuex ja yal burro jau ba? ");
INSERT INTO tojNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jaxa jecabanum jahui ti yalahue ja jas alji yabye yuj ja Jesusi. ―Entonces ta jachuc, lec, iajic, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ti yiaje och ja yal burro ja bay ja Jesusi. Ti yaahue bacan ja sc'uei, jaxa Jesusi, ti q'uea. ");
INSERT INTO tojNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jaxa cristiano, jel ja ma' ch'ac slich'e ja sc'ue ja ba yoj beji. Soc ay ma' sc'utzu ja spoohuil ja tei, ti xcholohue ja ba beji. ");
INSERT INTO tojNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jitzan ja cristiano bajtan ba sti sat ja Jesusi soc jitzan lec ja ma' tzaan ba spatiqui. Ti yalahuea: ―¡Viva! ¡Stz'acatal lec ja ma' jac yuj ja sbiil ja Cajualtiqui! ");
INSERT INTO tojNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oj ni och sc'ul mandar june ja yintil ja rey Davidi, como quintiltic nia. ¡Stz'acatal huax c'anatic yi! ¡Viva ja ma' tey ba satq'uinali! xchiye xta ja cristiano, pero ahuanel huane. ");
INSERT INTO tojNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ti xa huane ochel ja ba yoj chonab ba Jerusalén. Ti c'otye ja ba templo, jaxa Jesusi ti ch'ac sq'uel ec' spetzanil ja ba yojol ja templo. Jaxa cuando oj xa ochuc ja acuali, ti xa cumxi ba Betania soc ja lajchahuane ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti canye jun acual ja ba Betania, jaxa el ja c'ac'u, ti cho stulu ja sbeja. Ti to ay ba nalan bej ja Jesusi cuando och huain xyabi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti yila najat jun steil higo. Ay xa lec spoohuil. Ti huaj c'ubana ba oj yil ta ay sat pero cuando c'uban xa ayi, huaj to yile, mi ni jun sat ay. Jel xa ja spoohuili pero mi to ayuc ja sati como mi to ni stiempouca ja higo. ");
INSERT INTO tojNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ja Jesusi ti yal yab ja steil ja higo jahui: ―Mi ni nunca oja huaa sat ja hueni, xchi. Jaxa snebuman jumasa ti yabye ja jas yal yab ja steil ja higo jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ja Jesusi soc ja snebuman jumasa ti c'otye ba Jerusalén, jaxa Jesusi ti och ja ba templo. Ti snutzu el ja ma' huane xchonjel cosa ja ba yojol ja templo soc ja ma' huane smanjeli, jaxa ma' huan sc'ulajel cambiar taq'uini, suichpun el ja smesaei. Jachuc ja ma' huane xchonjel paloma, ch'ac sutbuc el ja sillaei. ");
INSERT INTO tojNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Spetzanil ja matic huan scuchjel ja sastic sbajei, mi huax yaa licensia oj ec'uque ja ba spatioil ja temploi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ti och yal ja jas huax yala ja yabal ja Diosi. Ja templo ja' ni ba oj maconuc yuj spetzanil ja cristiano ba oj sc'umuque ja Diosi. ―¿Mi ma jach ni huax yala ja suun ja Dios ba? Pero ja huenlexi huaahuex ta pax snaj lagronil, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jaxa ma' huas sea ja smandar ja Moisesi soc ja nihuac pagre jumasa ti huane smaclajela. Juntiro ch'ac xihuuque yuj ja Jesusi porque spetzanil ja cristiano jel huas sc'ulane gusto ja jas huan yaljeli, jaxa yenlei ti och xchape yabalila. ");
INSERT INTO tojNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jaxa Jesusi, cuando och ja acuali, ti xa el ja chonab jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jaxa el ja c'ac'u, huaj to yile ja snebuman jumasa, taquin xa juntiro ja steil ja higo, pero man yech. ");
INSERT INTO tojNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ti jul sc'ujol ja Pedro: ―Q'uelahuil Maestro, ja jastal ahual yab ja steil ja higo, meran nia. ¡Taquin xa ni juntiro taca! ");
INSERT INTO tojNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ti yala ja Jesusi: ―C'uanic ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Q'uelahuilex ja huitz iti. Huan c'a xa hualahuex yab oj stucbes ja slugari, huan c'a xa hualahuex yab oj sip sbaj ba yoj ja', oj ni bobuca. Pero mi oj c'umanuc ja hua c'ujolexi. Oja c'uuquex que oj ni c'otuc ja jas huaxa hualahuexi. Huax cala huabyex, pero meran. ");
INSERT INTO tojNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cuando huaxa c'umanex ja Diosi, c'uanic que oj aajuc ahuilex spetzanil ja jas huaxa c'anahuex yi ja Diosi y oj ni ahuilex sata. ");
INSERT INTO tojNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Cuando huanex sc'umajel ja Diosi, ta ay c'a ma' timan ahuabalex soc, c'ulanic perdonar. Jachuc, ja hua Tatex tey ba satq'uinali oj sc'ul perdonar ja hua mulex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pero ta mi c'a xa c'ulan perdonar ja hua moji, jach ni ja hua Tatex tey ba satq'uinali, mi ni oj sc'uluquex perdonar ja huenlex chomajquili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ti cho huajye otro vuelta ja ba Jerusaleni. Ja Jesusi ti och ja ba templo, jaxa nihuac spagreil ja judio soc ja matic huas sea ja smandar ja Moisesi soc ja banquilal jumasa ti huajye ja ba huan bejyel ec' ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti yalahuea: ―¿Yuj ama ay ahuatel ja huen huaxa c'ulan ja cosa jumasa iti? Entonces, ¿ma' yaa hui ja hua huatel ba? xyutaje. ");
INSERT INTO tojNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","―Jachuc ja queni, ay jas huax c'ana oj job ahuilex. Ta huan c'a xa hualahuex cabi, entonces oj cala huabyex ma' yaa qui oj c'uluc ja cosa jumasa iti. ");
INSERT INTO tojNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ja Juani, ¿machunc'a yala oj sc'ul bautizar ja cristiano? ¿Ja' ma alji yab yuj ja ma' tey ba satq'uinali ma ja' alji yab yuj ja cristiano? Alahuic cab ba, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jaxa yenlei ti ochye loil yenle itaa: ―Huan c'ax calatic ja ma' tey ba satq'uinali, entonces oj yal cabtic: Entonces ¿jaxa yuj ja mi xa c'uanex ba? oj yutotic. ");
INSERT INTO tojNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iday, ta huan c'ax cho calatic que ja' sbaj cristiano … mi snaa jas oj yale porque xihuel xihuel aye yuj ja cristiano porque ja cristiano toyobal yujile ja Juani que mero aluman‑Dios bi. ");
INSERT INTO tojNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ti yalahue yab ja Jesusi: ―Mix naaticon, xchiye. ―Entonces jachuc ja queni, mi oj cala huabyex ma' yaa qui ja cateli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ja Jesusi ti och yal yab ja cristiano pero soc jun loil: ―Ay jun huinic, jaxa yeni stz'unu jun yalajil tz'usub. Smacba. Sboyo jun sq'uejnal ja strapichi. Ya q'ue jun sluchayub ba huax q'ue yil ja yalaji. Cuando ch'ac sc'uluc ja jachuqui, ti sc'ulan trato soc chaboxe ja ma' oj yil can ja yatel ja yalaji, jaxa yeni ti huaj najata. ");
INSERT INTO tojNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ti sc'ulan tantear ja tiempo. Ti seca jun smozo ba oj yii jan ja sbaal ja yalaji. ");
INSERT INTO tojNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Cuando c'ot ja mozo jahui, ti yamji yuj ja matic canel ba sc'ab ja ateli. Smac'ahue. Telan sc'ab yaahue huajuc. ");
INSERT INTO tojNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jaxa suinquil ja yalajil tz'usubi ti cho seca otro ja smozo pero iday, yajni yilahue, ti och xch'oje tona. Yaahue yajbuc ja s'olomi. Xihuel ja sbaj ja jas sc'ulane yii. ");
INSERT INTO tojNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jaxa suinquil ja alaji otro vuelta cho seca june ja smozo, jaxa mozo jahui, smilahue. Jel ja ma' seca pero ¡malaya, ay ma' puro golpe yaahue yi, jaxa tuc jumasa, smilahue! ");
INSERT INTO tojNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pero ja suinquil ja yalajil tz'usubi, ay to ni yioj junea, ja' ni ja yunini. Jel yaj huax yabi. Ti yal yaba: ―Ja huego, cax ja hueni. Oj sc'uluca respetar porque mero cunina, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero cuando c'ot ja yunini, ti yalahue yenle itaa: ―Ja iti, ja' ni ja ma' oj yii can ja dote. ¿Jaxa mix milatiqui? Ta cham c'a, quen oj bajuctic can ja sdotea, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ti syamahuea. Smilahue. Ti yiaje el ba spat alaj. ");
INSERT INTO tojNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Cuando ch'ac ja loil jahui, ti sobo ja Jesusi: ―Jaxa huenlexi, ¿jas la chiyex? Cuando huax cumxi ja suinquil ja alaj jahui, ¿mi ma oj xch'ay snaajel ja tantic huinique jahui, tuc ja ma' oj yaa ba sc'abi? ");
INSERT INTO tojNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Yuj ama mi huaxa q'uelahuex ja juun ja jastal huas staahuon ti' ba? Huax yala que quena ni ja oy it jel tzamal tac. Pero q'uelahuilex: Ay jun oy ba jel tzamali pero ja c'ulanaitzi mi squitz'ahue, iday, jaxa oy jau mi squitz'ahuei, ja' mero oj yaa mas yip ja naitzi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja Cajualtic Diosi, yena ni sc'ulan ja iti. Jel tzamal juntiro huax cabticon, xchi ja yabal ja Dios tac, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pero ja loil it yala ja Jesusi, huego jac sc'ujole que yenle ja huax tajiye tii. Jayuj huas sc'anahue oj syame pero mi bob yujile porque huax xiuye yuj ja cristiano jumasa. Ti yaahue cana. Huajye. ");
INSERT INTO tojNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ja mas tzaani ti huajye chaboxe fariseo jumasa soc chaboxe yamigo ja Herodesi. Ti huajye ja bay ja Jesusi, pero jecubal huajye. Bob ta ay bi jas oj el sti. ");
INSERT INTO tojNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Cuando c'otye ja bay ja Jesusi, ti yiaje loila: ―Maestro, huax naaticon que ja jas huaxa huala ja hueni, que meran. Mi ni huala xiu yuj ja cristiano tac. Mi huanuca sleejel oj iljan lec pero ja' huaxa jea ja sbej ja Diosi, pero puro smeranil. Jac jobticon ahui, ¿lec ama oj caatic yi contribución ja gobierno César ma miyuc? ¿Jas la chi ba? ¿Oj ma caatic yi ma miyuc? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jaxa Jesusi huego snaa que xchabil lado aye. Ti yalaa: ―¿Yuj ama oja c'uluconex probar ba? Lec ay. Jeahuic qui ja taq'uini. Oj q'uele. ");
INSERT INTO tojNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ti seahue yi ja taq'uini. Ti sobo ja Jesusi: ―Jaxa olomal jahui, ¿ma' sbaj ba? Jaxa sletraili, ¿ma' sbiil ba? ―Ja' sbaj Cesari, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","―Entonces ta ja c'a ba Cesari, aahuic yi ja César ja ba sbaji, jaxa jas sbaj ja Diosi, aahuic yi, x'utjiye yuj ja Jesusi. Jaxa yenlei smaca juntiro ja stiei. ");
INSERT INTO tojNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jaxa jun c'ole cristiano jumasa, saduceo sbiile, ti huajye ja bay ja Jesusi. Ja yenlei mi huas sc'uane ta huas sacui ja ma' huax chami. Ti yalahuea: ");
INSERT INTO tojNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, ja Moisesi yala can ta huan c'ax cham jun banquilal y huax yaa can ja xcheumi pero mey yuntiquile, entonces oj bi iijuc ja xcheum ja chamhuiniqui yuj ja yijtz'in ja ma' nochan soqui, jaxa yuntiquil ja yenlei que oj bi bob aljuc que ja' bi yuntiquil ja chamhuinic banquilali. ");
INSERT INTO tojNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","¿Jaxa ta lec ay jucuane yermano sbaje ba? Ja banquilali huax nupani pero huax chami. Mi ni jun yuntiquil huax cani. ");
INSERT INTO tojNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jaxa xcheum ja banquilal jahui, jaxa ta lec ja' tax cho iiji yuj ja yijtz'in nochan soc ja statam ajyi y ta huan c'a cho xcham ja yen chomajquili, y mi ni ja yeni, mix yaa can yuntiquil … ja lec jach cho sc'ulan ja ba yoxil ijtz'inali … ");
INSERT INTO tojNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","¿Jaxa ta lec jach xch'ac ec'uque sucuanile ba? ¡Y ta mi ni c'a jun yuntiquil huax can spetzanile! Ja lec ti xa huax cho cham ja ixuc jahui, ");
INSERT INTO tojNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jaxa ba otro lado, cuando oj sac‑huuc ja scuerpoei, ¿machunc'a mero oj yii ja ixuc jau ba? porque spetzanile xcheumane ja ba luumi, xchi ja saduceo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ti yala ja Jesusi: ―Ja spetzanilex mi ni jas huaxa naahuex t'usana. Mi ni t'un huaxa huabyex sbej ja slibro ja Diosi, mi ni huaxa c'uanex ja jastal ja yipi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porque cuando oj sac‑huuc ja scuerpo ja ma' huax chamyei, mi xa oj to ajyuc nupanel. Mi xa oj to aajuc nupanuque. Ja tihui mi xa ma' oj yii sbaje. Oj ajyuque jastal ja ángel jumasa ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jaxa ma' huax chamyei, oj ni sac‑huuquea. Bob ta mey xa q'uelahuex ja slibro ja Moisesi. Ja Diosi, cuando ti c'umani ba yoj q'uiixi, ti yal yab ja Moisesi: Ja queni sDioson ni ja Abrahami, sDioson ja Isaqui, sDioson ja Jacobi, jach bi alji yab ja Moisesi, iday, ja ora jahui, mi xa ni huaanuc to ch'ac chamuque ja oxhuane jahua. ");
INSERT INTO tojNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jach yala porque ja oxhuane huinique jahui ti ni aye soc ja Diosi. Ja ba sti sat ja Diosi mi ni ma' huax cham juntiro. Mi ni jas huaxa naahuex t'usana, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ti jac c'uban june ja ma' huas sea ja smandar ja Moisesi. Yab sloile soc ja saduceo jumasa. Huas snaa que jel lec ja jastal sutji yile ja sloil ja saduceo jumasa. Ti sobo ja huinic jahua: ―Ja ba spetzanil ja mandar jumasa ¿bay ja mas t'ilan ba? ");
INSERT INTO tojNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ti yala ja Jesusi: ―Ja mandar ja ba mas t'ilani huax yala jachuc: Israeleño jumasa abyic. Ja Cajualtic Diosi, quechan ni june ja Cajualtica. ");
INSERT INTO tojNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yaj oja huab ja Huajual Diosi soc spetzanil ja hua c'ujoli soc spetzanil ja hua hualtzili, soc spetzanil ja hua pensari, soc spetzanil ja hua huipi. Ja jahui, ja' ni ja mandar mas t'ilani. ");
INSERT INTO tojNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Soc ay otro mandar oj slaj ja iti: Ja jastal huaxa yajta baj ja huen mismo, jach oja yajta ja hua moji. Mey otro mandar oj slaj ja jastal ja chab mandar jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","―Meran Maestro, meran ja jas huaxa huala. Quechan june ja Diosi, mey otro. ");
INSERT INTO tojNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Mas ni t'ilan ja mandar ba oj yajtatic soc spetzanil ja jc'ujoltiqui, soc spetzanil ja jpensartiqui, soc spetzanil ja caltziltiqui, soc spetzanil ja quiptiqui. Soc oj ni yajtatic ja jmojtic ja jastal huax yajta jbajtiqui. Mas jel t'ilan juntiro oj c'ultic jachuc que oj quiitic jan chante ba oj tzicxuc ja ba sti sat ja Diosi, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ja Jesusi, cuando yab que jel lec ja jas yala ja huiniqui, ti yal yaba: ―Ja hueni, jel t'usan sc'ana oja jip ac'ujol soc ja Diosi ba oja huaa baj ja ba smandari, x'utji. Jaxa cristiano ti ch'ac canuque jac'ana. Mi xa ni june ma' huax yaa sbaj jas oj sob yi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ja Jesusi ti huaj see ba templo, ti yalaa: ―Ja ma' huas seahue ja smandar ja Moisesi huax yalahue que cuando oj bi manxuc ja Cristo, ti bi oj jac manxuc ja ba yintil ja rey Davidi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pero ja rey Davidi, julbesnubal yuj ja Espíritu Santo yala jachuc: Ja Dios Tatali ti yal yab ja Cajual Cristoi: Quechan ja huen oj ajyuc ja huatel mas tzatz. Oj caa ba yib ac'ab ja hua condra jumasa, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja huabyex que yajualan ja Cristo ja Davidi, iday, yena ni yintila pero mi to nix manxi ja Cristo tac. Jaxa ma' huas sea ja smandar ja Moisesi huax yala que ja Cristo oj to manxuqui, ja' ni bi ja yintil ja rey Davidi, iday, huan xax yajualan. ¿Jastal ay ja it ba? xchi ja Jesusi. Jaxa cristiano jel juntiro ja ma' jel sgusto huax yabye ja jas huax yalai. ");
INSERT INTO tojNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ay to mas ja jas yala ja Jesusi cuando huan seejel yi ja cristiano: ―Ja yenle ja ma' huas seahue ja smandar ja Moisesi ja' sgustoe huan xta huecheljuc ec' soc ja snajtil sc'uei soc ja' mero sgustoe oj jac tajuc sc'abe ja ba plaza. ");
INSERT INTO tojNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jaxa ba yiglesiaei huan ita sq'uelahue ja lugar ba huax och culan ja ma' ay yateli. Jach ni ja huax huajye ba jun huaelal, ja' mero huas sleahue ja lugar ba mas tzamali. ");
INSERT INTO tojNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pero iday, ja viguda jumasa, huas sapahue yi ja snajei. Albel lec huax och sc'umuque ja Diosi ja' ba lec oj iljuque. ¡A smajlaye! Ja it jumasa oj ni yii ja castigo ba mas tzatzi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ja Jesusi ti och culan ja ba mojan ja cajón ja ba huax yaahue can ja slimosna ja cristiano. Yila que huax yaa can jitzan taq'uin ja rico jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ti jac jun viguda jel pobre, jaxa yeni ti yaa can chab yal sat taq'uin. ");
INSERT INTO tojNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ja Jesusi ti spaya jan ja snebuman jumasa: ―Q'uelahuilex ja viguda jahui. Pero ja mero smeranili, mas jel yaa can ja yen ja ba yoj cajoni que yuj spetzanil ja tuc jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ja yenlei quechan ja ba sobraei huax yaahue cani pero ja viguda iti, pobre juntiro. Yaunej spetzanil ja janec' yioji. Mi ni jas huax can sobra yujil, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuando elye ja ba templo, june ja snebuman jumasa ti yal yab ja Jesusi: ―Maestro, q'uelahuil ja snajtzil jumasa ja templo. ¡Jel tzamal juntiro ja stojnali! xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","―Meran nia. Jel nihuan juntiro ja naitz jumasa pero iday, mi ni jun ton oj can latzana. Polvo oj ch'ac huajuc spetzanil, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ja Jesusi soc ja snebuman jumasa ti huajye ja ba huitz Olivos, jaxa tihui, ti och culan ja ba spunto ja templo ja Jesusi. Jaxa Pedro soc ja Jacobo soc ja Juani soc ja Andresi ti jac ba stz'eel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ti sobohuea: ―Pero Maestro, huaxa huala mi oj can latzan ja stojnal ja templo. Ala cabticon jas ora jach oj ec'uc ba. ¿Oj ma naaticon jas ora oj ec'uc ja it ba? ¿Oj ma ajyuc seña ba? ");
INSERT INTO tojNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ti yala ja Jesusi: ―Moca huaa bajex ba oj lolajananic. ");
INSERT INTO tojNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porque cuando mojan ja tiempo jahui jel ja ma' oj yii ja jbiili: Ja queni Cristoon nia. Stzaunejon ja Diosi, oj chiuque. Oj slolaye jitzan lec ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Oja huabyex yabalil ja guerra. Ja' mero oj sloiltaye ja guerra ja cristiano pero moc lom chamuc ac'ujolex. T'ilan ni oj c'ot smeranil ja jastal ita. Pero ja jahui, mi to jauc ja mero oj c'ot tic'an ja tiempo. ");
INSERT INTO tojNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ja lugar jumasa puro coraja oj yil sbaje. Ja gobierno jumasa oj ochuque pleito. Oj ajyuc templor ba jitzan lugar. Jel oj ajyuc ja huaini. Oj jomuc juntiro ja mundo pero spetzanil, cuando huas staa ja jastal iti, yuj ni huan tox och q'ueuc. Mi to jauc ja mero. ");
INSERT INTO tojNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero aa cuidadoex porque oj soquex parte ja ba sat ja ma' ay yateli, jaxa ba yoj yiglesiaei oj yaa huilex golpe. Oj ya huajanic ba sti sat ja gobierno jumasa soc ja rey jumasa pero ja' yujil ja huaxa loiltayonex eq'ue, pero anima, oj ni cho yabye ja yenle chomajquila. ");
INSERT INTO tojNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ja mi tox c'ot tic'an ja tiempo, jel ni t'ilan oj loiltaxuc ba spetzanil ja lugar jumasa ja abal it jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pero cuando huax yiajex ja ba sat ja ma' ay yateli, mix cham ac'ujolex ja jas oja hualexi. Mi t'ilanuc oja c'uluquex pensar ja jas oja hualex ja ora jahui porque ja mero ora oj aajuc jac ac'ujolex ja jas oja hualexi. Ja' oja hualex. Mi ni ahuenuquex oj c'umananica ja ora jahui, ja' ni ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jun huinic, ja mero yermano oj sc'ul endregal ba oj chamuc. Jach ni jun tatal, oj sc'ul endregal ja yunini. Jaxa jun nanal tatali, condra oj iljuque yuj ja yuntiquilei. Oj smile can ja snan statei. ");
INSERT INTO tojNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Quechan yuj ja huiojex ja jbiili jel coraja oj iljanic yuj spetzanil ja cristiano. Pero ja ma' oj cuch yujil ja huocol iti hasta man xc'ot tic'an ja tiempo jahui, oj ni coltajuque ja yenlea. ");
INSERT INTO tojNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ja ma' huas sq'uela ja juun iti, a yab sbej. A sna que ja cuando huaxa huilahuex ja cosa jau jel quistal juntiro tey ba lugar jau ba mi sbejuc ti oj ajyuqui, entonces ja suinquil ja Judea, mas lec aa xa spaque ajnel ja ba huitzi porque ti xa ay ja huocol ba jel tzatzi. Ja yen ja aluman‑Dios Danieli yen ch'ac yal can ja jastal iti. ");
INSERT INTO tojNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ja ora jahui, ta ay c'a ma' tey ba xchabil lame ja naitzi, toj eq'uel a huajuc cuando huax coi. Moc xa lom jas oj och yii ja ba yoj snaji. ");
INSERT INTO tojNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jaxa ma' tey ba huitz, moc xa lom oj cumxuc oj huaj yii ja xchompa. ");
INSERT INTO tojNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Jel ajul ja sbaj ja ma' cuchan yuj ja nihuac chameli soc ja ma' ay to yioje ja yal alatz huan to chuuneli! ");
INSERT INTO tojNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","C'anahuic yi ja Dios cuando ora oja paquex ajneli que mi jauc stiempo chee ");
INSERT INTO tojNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque ja huocol iti jel tzatz juntiro. Quechan huocol mas tzatz oj ajyuc masan ya cujlajuc ja satq'uinal ja Diosi. Mi ni nunca ba ilxia soc mi ni nunca oj jac otro vuelta ja jastal iti. ");
INSERT INTO tojNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Stz'acatal ja Cajualtic Diosi oj bob scom ja sc'ac'uil ja huocol jahui porque ta mi c'a comtic'anuc t'usani, mi ni june ma' oj el librea. Pero ja' yujil ja matic tzaubale ni yuj ja Diosi, jayuj comtic'an ni t'usan oj yaa ja huocoli. ");
INSERT INTO tojNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pero ta ay c'a ma' huax jac yala huabyex, q'uelahuilex, jul bi ja il ja Cristo, ma q'uelahuilex, ti bi aya, pero moc lomuc ac'uuquex. ");
INSERT INTO tojNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ay ni ma' oj yal que Cristo, que tzaubal bi yuj ja Diosi, soc ay ma' oj stoy sbaj que aluman‑Dios bi. Ay jas oj sea huilex siquiera ba oj slolayex. Oj bob sc'uluque milagro. Hasta ja ma' stzaunej ni ja Diosi, ay modo jastal oj lolajuque ta mi c'a tzatz ayuquei. ");
INSERT INTO tojNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero ja huenlexi, aa cuidadoex. Con tiempo huax cala huabyex. ");
INSERT INTO tojNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ja tiempo jahui, cuando huax ch'ac ec' ja huocoli, ja c'ac'u oj tupuc, jaxa luna oj ch'acuc, ");
INSERT INTO tojNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Jaxa c'anal jumasa oj ch'ac lujbajuc con ja ba satq'uinali. Oj ni ch'ac syoopes ja yip ja Dios ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ja queni ti ni coelon jan ja ba satq'uinali, jaxa ora jahui, oj cho cocon jan otro vuelta. Ti oj cocon jan ba yoj ason. Jel tzatz oj ajyucon. Oj ni lijpucona. Jaxa cristiano jumasa, oj ni yilonea. ");
INSERT INTO tojNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Oj jec ja cangel jumasa ja ba xchanil xchiquin ja satq'uinali. Oj huaj stzome jan spetzanil ja ma' jtzauneji ja ba spetzanil ja mundo. ");
INSERT INTO tojNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Q'uelahuilex ja steil ja higo. Cuando yaau xa ja sc'abi, huan ni xa naahuex que q'ue ta stiempo ja'. ");
INSERT INTO tojNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jachuc, cuando huaxa huilahuex spetzanil ja cosa iti, naahuic que jel xa mojan ja tiempo, ja' xa nia. ");
INSERT INTO tojNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Huax cala, pero meran, ja cristiano ma' sac'an ja ora jahui, mi oj chamuque masan to huax c'ot smeranil spetzanil ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Anima huax ch'ac ja satq'uinali soc ja luumi pero ja jas huax cala, t'ilan ni oj c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero ja c'ac'u jahui soc ja mero yorail oj ec'uc ja cosa jumasa iti, mi ni june ma' oj snaa, mi ni ja ángel jumasa tey ba satq'uinali. Ja queni mero yuninon ja jTati pero mi ni oj naa. Quechan ja jTati oj snae. ");
INSERT INTO tojNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jayuj chapan ajyanic. Q'uelan jacan ajyanic. C'umanic ja Diosi porque mi xa naahuex jas ora oj jaconi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lajan soc ja huinic jau yaa can ja snaji ba oj huajuc najat lec. Yaa ba sc'ab ja smozo jumasa. Cada mozo yaa yi ja yateli. Ti yal yab ja ma' huas stalna ja puerta: Q'uelan jacan xta la ajyi, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jachuc ja huenlex chomajquili. Q'uelan jacan ajyanic porque mi xa naahuex jas ora oj cumxuc ja suinquil ja naitzi. Bob ta oj jacuc cuando huan xax och ja acuali, ma nalan acual, ma xchabil gallo, ma sacbi q'uinal. ");
INSERT INTO tojNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Q'uelan jacan ajyanic porque jun ta ch'ay c'ujol oj jacuc ja suinquil ja naitzi. Q'uixhuel ja sbaj ta huanex c'a huayel oj staexi. ");
INSERT INTO tojNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jayujil huax cala huabyex ja huenlexi soc spetzanil ja cristiano, q'uelan jacan ajyanic apetzanilex. ");
INSERT INTO tojNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ja c'ac'u yala jachuc ja Jesusi, quechan xta chab c'ac'u sc'ana ja syalq'uinal ja judio jumasa, ja' ni ja q'uin it huas sueahue ja pan it mey slevaduraili. Ja nihuac spagreil ja judio jumasa soc ja ma' huas seahue ja smandar ja Moisesi huane xa xchapjel yabalil ja Jesusi. Ta ay bi modo jastal oj bob syame, oj bi yaahue ch'ay snaajel. ");
INSERT INTO tojNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero mi bi jauc ja mero sc'ac'uil ja q'uini porque ja cristiano lom bi oj q'ueuque soc pleito. ");
INSERT INTO tojNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jaxa Jesusi ti xa ay ba yal hacienda Betania ja ba snaj ja Simón ja ma' huax alji sbaj yaj chamel xta ajyi yuj ja huan c'ael ja sbacteli. Cuando ti culan ec' ba mesa ja Jesusi, ti jac jun ixuca. Yiaj jan yi jun perpume c'ulubal soc puro nardo ba jel ja stz'acoli. Jaxa yetali, c'ulubal soc jun ton alabastro sbiil. Ja ixuqui ti spojo ja alabastro, jaxa perpume ti spec'a yi ja ba s'olom ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pero ay chaboxe ja tihui, lom xta xuatati ja sc'ujolei. Ti yalahuea: ―¡Jel lástima juntiro jach huax ch'ay lom ja perpume iti! ¿Jasyuj jach huas sc'ulan ba? ");
INSERT INTO tojNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mas lec chonxuc to. Oj chonxuc mas que milquinientos peso, jaxa taq'uin jahui, oj aaxuc yi ja ma' pobre, xchiye. Xbulbuniye xta sbaj ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ti yala ja Jesusi: ―Ch'abananic ja huenlexi. ¿Jasyuj huanex staajel ti' ja ixuc iti? Jel tzamal juntiro ja jas sc'ulunej quii. ");
INSERT INTO tojNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ja matic pobre, tola vida oj ajyuc amoquex. Cualquiera ora oj bob acoltayex, pero ja queni, mi tola vidauc oj ajyucon amoquex. ");
INSERT INTO tojNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ja ixuc iti sc'ulunej spetzanil ja jas huax bob yujili. Meran nia, mi to la chamyon pero ja yeni spec'a ta qui ja jcuerpo ja perpume. Ja' xa ni huax xchapahuon ja ba jmuculabili. ");
INSERT INTO tojNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jaxa abal it jel tzamali, chican ba lugar ja ba spetzanil ja mundo oj to cholxuqui, oj ni abjuc ja jas sc'ulan qui ja ixuc iti. Mi ni nunca oj ch'ay snaajel ja jas sc'ulan quii, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jaxa Judas Iscariote, ja' ni june ja lajchahuanei, ti huaj soc ja nihuac pagre jumasa. Huaj sc'ul trato ba oj sc'ul yile endregal ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jaxa pagre jumasa cuando jach alji yabyei, jel gusto juntiro yabye. Ti sc'ulane trato. Oj bi yae yi taq'uin ja Judas. Jaxa Judasi ti oj slee jastal oj sc'ul endregal ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ja q'uin it huas sueahue ja pan mey slevaduraili ja' ni ja mero sbajtanil c'ac'u ja q'uin jahui, culan yujile huas smilahue jun chej cada syalq'uinal. Ja c'ac'u jahui ja snebuman jumasa ti sobohue yi ja Jesusi: ―¿Ba huaxa c'ana oj huaj chapticon ba, porque syalq'uinal xa tac. Sbej xa ni oj c'uxtic ja chej ja jastal ni culan cujtiqui. ");
INSERT INTO tojNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ti yal yab chabe ja snebuman jumasa: ―Caxic xa ba chonab. Cuando ti xa ayex ja ba sti ja chonabi, ti oja taex bej jun huinic cuchan xch'ub, ti xa tzajlayexa. ");
INSERT INTO tojNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ti oj c'ot ja ba jun naitz, jaxa suinquil ja naitz jahui oja jobex yi bay ja cuarto jau ba nalan chaani. ¿Ba bi oj sc'ux ja xchejil ja syalq'uinal ja Maestro soc ja snebuman jumasa? oja huutex. ");
INSERT INTO tojNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jaxa yeni oj sea huilex jun nihuan cuarto ba nalan chaani, chapan xa. Jaxa huenlexi ti oja tojbesex leca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ja snebuman jumasa ti huajyea. Jaxa ba sti ja chonabi, ti ni staahue ja jastal ni alji yabyei. Stojbese ja ba oj ec' yujile ja syalq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuando och ja acuali, ja Jesusi soc ja snebuman jumasa ti huajye ja ba cuarto jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ti ochye culan ja ba mesa. Huane xa huael cuando yala ja Jesusi: ―Huax cala, pero meran, june ja huenlexi, ja' ni ja jmoj huaeli, oja c'uluconex endregal, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jaxa yenlei ch'ac jom juntiro ja s'olomei. Ti och sobe yi chol ja Jesusi: ―¿Quen ama? xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jaxa Jesusi ti yalaa: ―June ni ja huenlex ja lajchahuaneexi. Lajan ni huanon xchicjel soc ja juaela. ");
INSERT INTO tojNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Meran nia, ti ni coelon jan ja ba satq'uinali pero oj ni chamcona. Como jach ni tz'ijbanubal ja ba yabal ja Diosi pero ¡pobre ja huinic jau ja ma' oj sc'ulucon endregal! ¡Mas lec moc to manxuc ja huinic jahui! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Huane to huael cuando yiaj jun pan ja Jesusi. Cuando ch'ac sc'an yi stz'acatal ja Diosi, ti xet'aa: ―Hueanic. Ja iti, ja' ni ja jcuerpoa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ti syama jun vaso but'el yaalel tz'usub. Yaa yi stz'acatal ja Diosi, ti cho yaa yi ja snebuman jumasa, jaxa yenlei ch'ac yue spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ti yala ja Jesusi: ―Ja yaalel tz'usub iti, ja' ni ja jchiq'uela. Ja Diosi sc'ulunej jun yajc'achil trato soc ja cristiano, ja' cuando xpec' ja jchiq'ueli, oj bi huajuque libre soc ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Huax cala, pero meran, ja yaani mi xa oj to cu otro vuelta ja yaalel ja tz'usubi man to cuando ti xa aytic jpetzaniltic ja ba lugar jau ja ba huas sc'ulan mandar ja jTati, ti xa oj xiitalauc jbajtic yuj ja jgustotiqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Cuando ch'ac yale jun stz'eboj Dios, ti huajye ja ba huitz Olivosi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ti yala ja Jesusi: ―Ja jastal oj ec' cujil ja yaan acuali, oj xihuanic juntiro. Como jach ni tz'ijbanubala: Oj ca yajbuc ja tanumcheji, jaxa jun nole ja xcheji, sactantan oj ch'ac huajuc, xchi nia. ");
INSERT INTO tojNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Oj ni miljucona pero oj cho sac‑huucon, ti oj huajcon ba Galileaa. Tix cho la huajyex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pero ja Pedro ti yalaa: ―Ja tuqui, bob ta oj xch'aya sc'ujol pero ja queni, miyuc, xchi xta. ");
INSERT INTO tojNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","―Huax cala, pero meran, cuando mi tox oc' ja xchabil gallo ja yaan acuali, oxe vuelta oja hual que mi xa naa jbaj, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero ja Pedro jel tzatz juntiro ja stii: ―Anima huala chamyon amoc, pero mi ni nunca oj cal que mix naa baj. Jach ni ja tuc snebuman jumasa, jach ni ch'ac yale chomajquila. ");
INSERT INTO tojNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ti c'otye ba jun lugar sbiil Getsemaní. Ja Jesusi ti yal yab ja snebuman jumasa: ―Culananic ja ili jaxa queni oj huaj c'umuc ja Diosi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ti yal yab ja Pedro soc ja Jacobo soc ja Juani: ―Laic ja huenlexi, xyutaj. Pero ja Jesusi och tristeaxuc juntiro ja ora jahui. Syatz'a sbaj ja yaltzili. ");
INSERT INTO tojNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ti yalaa: ―Jel yatz'an ja caltzili. Lajan soc oj xa chamcon mas ligero. Cananic ja ili pero moc lomuc hua ochuc ja hua huayelexi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ti huaj och otro jun maq'ue mas ja Jesusi. Ti co pacan ba luum. Ti och sc'an yi stz'acatal ja Diosi, ta ay modo oj bob ec'uc ja huocol jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―Tatey, ja hueni, huax bob ahuuj spetzanil. A ec' qui ja huocol iti pero mi jauc ja jas huax c'ana ja queni pero ja' ni ja jas huaxa c'ana ja hueni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ti xa cumxi ja bay ja oxhuane snebuman jumasa. Naca huane xa huayel jac stae. Ti yal yab ja Pedro: ―Simón, pero ¡huana xa huayel tac! ¿Mi ni ma jun ora oj bob atec' ja hua huayelex ba? ");
INSERT INTO tojNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mi lom la huayex. C'umanic ja Diosi ba mi oja lee ja hua mulexi. Ja hua hualtzilexi jel huas sc'ana oj sc'uluc ja ba lequi, jaxa hua cuerpoexi, jel yaau juntiro. Mey yip. ");
INSERT INTO tojNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ti cho huaj otro vueltaa. Jun xta mismo ja jas och sc'an yi ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti cho cumxi otro vuelta ja bay ja oxhuane snebuman jumasa. Cho huane huayel staa. Lajan soc but'el tz'iilel ja satei. Jaxa yenlei mi snaahue jas oj yale. ");
INSERT INTO tojNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jaxa ba yoxil vuelta, ja Jesusi ti yalaa: ―¿Huanex to ma huayel ba? Lec xa. Jijlanic xa. Malan xa soca porque ja queni chapanon xa nia ba oj chamcona. Meran nia, ja queni ti ni coelon jan ja ba satq'uinali pero iday, jpatic huanon iijel. Oj xa aajucon ja ba sc'ab ja mulanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Q'ueanic huego. Huajtic xa. Ti xa huax jac ja ma' yionej jpatiqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mi tox ch'ac el yujila, huaj to yile, ti xa ay ja Judasi, ja' ni june ja lajchahuane snebumani. Smoj jun nole cristiano. Naca ay smachite soc sgarrotee. Jecubale yuj ja pagre mas nihuaqui soc ja ma' huas seahue ja smandar ja Moisesi soc ja ma' banquilal ay yuj ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pero ja mi tox c'otyei, ti alji yabye yuj ja Judas ja ma' yionej spatic ja Jesusi: ―Ja ma' oj huaj cujtz'uqui, yena nia. Ti xa yamahuexa. Mi huocoluc oja huiex, xchi ja Judasi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Cuando mojan xa ay ja Jesusi, ti huaj yaa yi Diosa, ti yujtz'ana, como smodoe nia. ");
INSERT INTO tojNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jaxa smoj jumasa ja Judasi ti syamahuea, pero con gana. ");
INSERT INTO tojNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jayuj ti xa stasa ja smachit june ja yenlei. Aaji yi ja smozo ja pagre mas nihuani. C'utzji el yi june ja xchiquini. ");
INSERT INTO tojNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ti cho yala ja Jesusi: ―¿Yuj ama lagronon soc machit soc garrote huax jac ayamonex ba? ");
INSERT INTO tojNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cada c'ac'u huaxa huilahuex huanon seejel ja ba templo. ¿Jasyuj ja mi ti ayamahuonex ja tihui? Jach ni huaxa c'ulanexa yuj ja jach ni tz'ijbanubal ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Cuando ch'ac yal jachuc ja Jesusi, ja snebuman jumasa ti xa elye ja tihui. Spacahue ajnel. ");
INSERT INTO tojNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero ay jun soltero ja tihui, ja' ni june ja ma' huax bejyi ec' soc ja Jesús ajyi. Bech'an soc jun sábana. Pero ja cristiano ti syamahuea pero ja yeni soco sbaj. ");
INSERT INTO tojNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cholpiji can ja sábana. Basan spaca ajnel. ");
INSERT INTO tojNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ja Jesusi ti iiji och ba sti sat ja pagre mas nihuani. Ti jac nolan sbaj spetzanil ja nihuac pagre jumasa soc ja banquilal jumasa soc ja ma' huas seahue ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jaxa Pedro ti huaj nochana. Najtic najtic huas sq'uela. Ti och ja ba spatioil ja snaj ja pagre mas nihuani. Ti och culan ba sti c'ac'. Tey jun nole mozo jumasa soc ja criada jumasa. Naca huane c'atnel. ");
INSERT INTO tojNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jaxa Jesusi, mi xax yilahue ora jastal oj bob smile. Ja nihuac pagre soc spetzanil ja ma' tzoman sbaji, huane xta sleejel ja smul ja Jesusi, pero mi ni jas huax bob yujilea. ");
INSERT INTO tojNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jitzan ja ma' och testigoili, pero puro mentira huane. Tuctuquil ja jas huax yalahuei. ");
INSERT INTO tojNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ti cho jac chaboxe masa. Jac yale que testigoe bi pero tuc juntiro ja jas jac yalei. ");
INSERT INTO tojNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Yabye bi que oj bi sem ja templo: ―Ja templo iti c'ulubal soc c'abal pero ja queni oj jem ele. Jaxa ba yoxil c'ac'u oj cho ca sta slugar siempre pero mi soc c'abaluc oj sta slugar. ―Jach huax yala, xchi ja testigo jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero mi ni modoa. Mix lajxi ja jas huax yalahuei. ");
INSERT INTO tojNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jaxa pagre mas nihuani xachachi xta q'ue tec'an ja ba sat ja cristiano. Ti och sob yi ja Jesusi: ―Jaxa hueni, ¿jas la chi ba? ¿Ja huab ama jas yala ja it jumasa? ");
INSERT INTO tojNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ja Jesusi mi ni jun palabra sama ja stii. Mi sac'a jan ja jas jobji yii. Jaxa nihuan pagre ti cho och sob yi otro vuelta: ―¿Meran ama huen ja Cristo ja ma' stzaunej ja Diosi? ¿Yunina ama ja Dios ja ma' jel huax yajtaticoni? xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","―Quena nia. Ja queni ti ni coelon jan ja ba satq'uinali. Jel tzatz juntiro oj ajyucon yuj ja yip ja Dios ja ma' jel nihuani. Oj to cocon jan ja ba satq'uinali ba yoj asoni. Oj ni ahuilonexa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jaxa pagre mas nihuani ti st'uxpin ec' ja sc'ab yuj ja scoraja. Ti yalaa: ―¿Jas yatel cujtic mas testigo? ");
INSERT INTO tojNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Ja huabyex yala que yen bi yunin Dios tac! ¿Jas la chiyex? Spetzanile huax yalahue que sbej ni oj chamuca, que mas bi lec oj chamuc. ");
INSERT INTO tojNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jaxa tuqui ti och stzujbaye ja sat ja Jesusi. Smacahue yi ja sati, ti och st'uxpuque vueltaa: ―Naa quitic sbaj ja ma' huas smac'ahuai. Ala machunc'a huax yaa hui vuelta, xchiye xta. Jaxa policía jumasa ti cho och smac'taluque ja ba sati. ");
INSERT INTO tojNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jaxa Pedro mi teyuc ja tihui. Ti ni ay ba spatioil ja sti naitzi. Ti jac june ja scriada ja pagre mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ja criada ti yila que ti huan c'atnel ja Pedro. Stojtoq'uela lec, ti yalaa: ―Ja hueni, ja' ni ja hua moj ja tan Jesús nazareño, x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jaxa Pedro yala que miyuc. ―Mi ni huax naa sbaj. Mix cab ja jas huaxa huala cabi, xchi. Ch'ac yal jachuc ja Pedro, ti huaj tec'an ja ba puerta calle. Ti oc' ja galloa. ");
INSERT INTO tojNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jaxa criada cho sq'uela otro vuelta. Ti och yab ja ma' tey tihui: ―Ja tan huinic iti, ja' ni june ja yenlei, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jaxa Pedro cho yala otro vuelta que mi bi snaa sbaj. Ti cho ec' jutz'ina. Jaxa matic tey ja tihui, ti yalahuea: ―Ja hueni galileñoa nia. Ja mero smeranili, ja' ni ja hua moj ja yenlei porque jun xta ja hua c'umalex tac. ");
INSERT INTO tojNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jaxa Pedro och xta bulbunuc. Jel piero ja jas yala: ―Xila Dios mix naa sbaj ja tan huinic jau huaxa taahuex tii, xchi. ");
INSERT INTO tojNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ti xa oc' ja xchabil galloa. Malan soc ja jahui, ti jul sc'ujol ja Pedro ja jas alubal yab yuj ja Jesusi, que ja mi tox oc' chab vuelta ja gallo, oxe vuelta oj yal que mi snaa sbaj. Cuando jac sc'ujol ja Pedro, ti och oc'uc leca. ");
INSERT INTO tojNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja nihuac pagre sbaj ja judio jumasa soc ja banquilal jumasa soc ja ma' huas seahue ja smandar ja Moisesi soc spetzanil ja matic tey ba yoj junta, lajti abal xa ni ayea. Saj to lec smochohue ja Jesusi. Yiaje och ja ba sti sat ja Pilato ja ma' ay yateli. ");
INSERT INTO tojNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jaxa Pilato ti sobo yi ja Jesusi: ―Jaxa huen, ala cabi, ¿meran ama huen sreya ja hua moj judioili? ―Quena nia como jach ni huana yaljela, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jaxa nihuac pagre ti och slee yi ja smuli, pero xuooljiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jaxa Pilato ti cho yalaa: ―¿Jasyuj mi la c'umani? ¡Ata huab ja jas huax yalahue abaji! ");
INSERT INTO tojNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ja Jesusi mi ni soc ja jahui, mi ni jun palabra sama stii. Jel och juntiro ja spensar ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ja mero sc'ac'uil ja q'uin jahui, culan ni yujil ja ma' ay yatel huax ya el libre jun presoanum pero tzaubal huax ya eluc ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jaxa q'uin jahui, lutan jun nole huinique ja ma' milhuaniye ja yora q'ue jun nihuan spleitoe. Ay june ja yenle lutan preso, Barrabás sbiil. ");
INSERT INTO tojNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jaxa c'ac'u jahui, ti jac jun nole ja cristiano. Jac sc'ane yi ja Pilato que oj sc'uluc ja jastal ni culan yujile ja ba q'uin jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ti sobo ja Pilato: ¿Mi ma xa c'anahuex ja oj sijpuc ahuilex ja hua reyexi? ");
INSERT INTO tojNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Como huas snaa ja Pilato que puro envidioso aye ja nihuac pagre, jayuj sc'ulane entregar ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ja nihuac pagre jumasa huane xta yaljel yab ja cristiano ba oj sc'ane yi ja Pilato ba oj sijpuc ja tan Barrabasi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jaxa Pilato ti sobo yi otro vuelta ja cristiano: ―Entonces jaxa ma' huaxa hualahuex que ja' hua reyexi, ¿jasunc'a huaxa c'anahuex oj c'ul yi ba? ");
INSERT INTO tojNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","―¡A chamuc ba cruz! xchiye xta, pero ahuanel huane. ");
INSERT INTO tojNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―Pero ¿jasunc'a ja smuli? xchi ja Pilato. Lom xta xuooljiye huax q'ueye: ―¡A chamuc ba cruz! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jaxa Pilato, como huas sc'ana oj can lec soc ja cristiano, ti ya el libre ja Barrabasi, ti yaa endregal ja Jesusi ba oj ni mac'juca. Ti yaa ba sc'ab ja ma' oj yaa locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jaxa soldado jumasa ti yiaje ja Jesusi. Yiaje och ba yoj presidencia, pretorio sbiil yujile. Ti spaya jan spetzanil ja smoj soldadoili. ");
INSERT INTO tojNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Cuando jacyei, ti yaahue slap jun c'ual morado ja jastal huas slapa ja reyi. Jaxa ba s'olomi, yaahue cajan jun corona pero puro q'uiix sc'uluneje. ");
INSERT INTO tojNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ti yalahuea: ―¡Viva ja srey ja judio jumasa! ");
INSERT INTO tojNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ti syamahue jun aja. Smac'ahue soc ja s'olomi. Stzujbaye, ti ochye mec'an ja ba sti sati, pero puro burla huane. ");
INSERT INTO tojNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cuando el ja sganae soc ja burla, ti sopohue yi ja c'ual morado. Yaahue slap ja mero sc'ui. Ti yaahue eluc ba oj yae locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jaxa ba beji, ti ec' jun huinic cireño, Simón sbiil, jaxa yuntiquili sbiil Alejandro soc Rufo. Ch'ac ta cumxuc jan ba huitz. Jaxa soldado jumasa, ti yalahue yab ja Simón jahui que oj scuch och ja cruzi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jaxa Jesusi ti yiaje och ba jun lugar sbiil Gólgota. Jach sbiil yujile como ja' ni el ja splanta ja sbaquel ja s'olom ja chamhuiniqui. ");
INSERT INTO tojNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ti yaahue yi ja Jesús t'usan yaalel tz'usub pero paj xa, socan soc jun an sbiil mirra, ja' bi ba mi oj yab ja syajal ja suocoli. Oj bi yue pero ja Jesusi mi yuaj. ");
INSERT INTO tojNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ti yaahue locan ja ba cruzi. Ti yiaje ja sc'u jumasa ja Jesusi. Sc'ulane ripar ba oj yile machunc'a oj co sbaj yujile ja soldado jumasa. ");
INSERT INTO tojNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ja mero ora aaji locan ba cruz ja Jesusi, como las nueve de la mañana. ");
INSERT INTO tojNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ti stz'ijbaye can jas sbej ja huax yaahue locan ja ba cruzi: Ja srey ja judio jumasa, xchi ja letrero sc'ulanei. ");
INSERT INTO tojNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Cho ay chab lagron ti cho yaahue locan ja ba stz'eel ja scruz ja Jesusi. Ja juni, ti yaahue ba lado stojol sc'ab ja Jesusi, jaxa juni, tey ba lado surdero. ");
INSERT INTO tojNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Jachuc, c'ot ni smeranil ja jas huax yala ja yabal ja Diosi, ja' ni aaji smojuc ja ma' jel ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jaxa matic huax ec' ja tihui, huane xta burla. Naca huane xta seetalajel ja sc'abi, ti huax yalahuea: ―¿Baya huaxa huala oja jem ja stemplo ja Diosi jaxa yoxil c'ac'u oj hua sta slugar? ");
INSERT INTO tojNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Colta baj ja huen mismo ba. ¿Jaxa mi la co ja ba cruz ba? xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jachuc ja nihuac pagre, huane xta burla ja yenle chomajquili. Huax yiaj sbaje loil soc ja matic huas seahue ja smandar ja Moisesi, ti huax yalahuea: ―Ja tuqui, jel huas scolta, jaxa yeni mix bob scolta sbaj. ");
INSERT INTO tojNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Pero ¡Cristoa tac! ¡Huaxa toya baj que huena jreyaticon tac! ¿Jastal lec mi la co ja ba cruz ja huego ba? ¡Colta baj ba, ti oj c'uucaticona! xchiye xta. Jachuc ja chahuane ja ma' lajan locane ja ba cruzi, huane xta burla. ");
INSERT INTO tojNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jaxa mero culan c'ac'u q'uicbi juntiro ja satq'uinali. Masan to ec' ja oxe ora, ti xa cho lijpia. ");
INSERT INTO tojNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Cuando oj xa lijpuc ja satq'uinali, ti c'umani ja Jesusi, pero tzatz lec c'umani: ―Eloi, Eloi, ¿lami sabactani? xchi soc ja mero yabali. Dios mío, Dios mío, ¿jas lom ahuaahuon ta cani? Jach ni sbej ja jas yala soc ja yabali. ");
INSERT INTO tojNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","―Ata huabilex, huan xa spayjel ja Eliasi, xchiye chaboxe ja ma' tey tihui cuando yab ja yahuaneli. ");
INSERT INTO tojNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jaxa june ja yenlei ti huaj ajnel huegoa. Yiaj jun yojol c'aem, ti sbut'u soc vinagre. Ti xch'ica jun tea. Ti jac sach q'ue yia ba oj xchuuc ja Jesusi: ―¡Actayic cani! Oj quiltic ta oj jac sc'ul librar ja Eliasi, xchi june ja huinique jahui. ");
INSERT INTO tojNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jaxa Jesusi ti cho ahuani otro vueltaa. Ti chama. ");
INSERT INTO tojNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jaxa ba yojol ja templo ay jun nihuan scortinail, jaxa ora jahui, xch'ia sbaj snalan. Ja xch'ielali, stulu con man sti q'ueel. El con man ba luum. ");
INSERT INTO tojNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jaxa ba sti sat ja Jesusi, ti tec'an ec' jun capitán soldado. Ja soldado jahui, yila quechan pavor ch'ac ahuanuc ja Jesusi, cham huego, ti yalaa: ―Ja huinic jahui, yunin ni ja Dios merana. ");
INSERT INTO tojNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Soc ay jun c'ole ixuque ti huane q'uelhuanela pero najat aye. Tey ja María sbaj Magdala, soc ja María snan ja ch'in Jacobo soc ja José, soc tey ja ixuc Salomé. ");
INSERT INTO tojNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ja ixuque jumasa jahui, jel scoltaye ja Jesús cuando yora ti huan bejyel ec' ba Galilea. Soc ay to jitzan ja ixuque ja matic smojane ja Jesús ja yora huaj ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ja och c'ac'u jau cuando ti to locan ba cruz ja Jesusi, ja' ni ja yoch c'ac'uil huax q'ue xchap sbaj ja cristiano porque ja otro c'ac'u, sc'ac'uil xa ni sijlelea. ");
INSERT INTO tojNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jaxa och c'ac'u jahui, ti och ba sti sat ja Pilato ja José ba Arimatea. Ja yeni ay ni yatela. Jel lec huax ilji yuj ja smoj jumasa. Ja yeni huan ni smajlajel jas ora oj sc'ul mandar ja Diosi. Pero ja och c'ac'u jahui, mi xihui. Ti och sc'an yi pavor ja Pilato ba oj aajuc yi ja scuerpo ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jaxa Pilato cham yab que cham ta ja Jesusi. Ti spaya jan ja soldado captiani. Sobo ta meran cham ta ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","―Cham ta nia, xchi ja capitani. Cuando yab jachuc ja Pilato, ti yal yab ja José que lec bi oj yii ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jaxa José ti smana jun sábanaa. Ti ya couc ja ba cruz ja scuerpo ja Jesusi. Sbech'a soc ja sábana jahui. Ti yaa ba jun q'ueen pero ja q'ueen jahui jotobal ba jun nihuan patac'. Ti sbaltzun jan jun tona. Ti smaca can lec ja sti ja q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pero cuando jach to huan sc'ulajel ja Josei, ti culane ec' ba stz'eel ja q'ueeni ja María sbaj Magdala soc ja María snan ja José. ");
INSERT INTO tojNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Entonces ja cristiano ti xa jijliyea, como ja' ni ja sc'ac'uil sijlelei. Jaxa otro c'ac'u, como ja' ni sbajtanil c'ac'u ja semana, ja María sbaj Magdala soc ja María snan ja Jacobo soc ja Salomé ti smanahue jun perpume ba oj saxe yi ja scuerpo ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ti huajye saj to leca. Cuando c'otye ja ba q'ueeni huan xa elel q'uen ja c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","―Saber ta ay ma' oj ya el quitic ja ton ja ba sti ja q'ueeni, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cuando ti xa aye ja tihui, ti yilahue que mi xa macanuc ja q'ueeni. Ja nihuan ton jahui, ti xa ay ba jun lado. ");
INSERT INTO tojNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ti ochye ba yoj q'ueeni, jaxa ba lado stojol ja sc'abei, ti culan ec' jun soltero, jaxa sc'u lapan yuji, jel najat soc jel sac. Jaxa ixuquei, xiuye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero ja soltero jahui ti yalaa: ―Mi lom la xiuyex. Huanex ni sleejel ja Jesús ja nazareño, ja' ni ja ma' aaji locan ba cruz pero mi xa teyuca. Sacui ta. Q'uelahuilex ja lugar ja ba aaji can ja scuerpo tac. ");
INSERT INTO tojNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Caaxic xa. Cax alahuic yab ja snebuman jumasa soc ja Pedro que ti xa huaj ta ba Galilea ja Jesusi. Al yab aa xa huajuc ja yenle chomajquili. Ti oja c'umuquex ja tihui ja jastal ni yala huabyexi, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jaxa ixuquei ajnel elye ja ba q'ueeni porque huane xa q'uitc'onel yuj ja xihueli. Mi ni june ma' huax yalahue yab ja ba beji porque jel juntiro ja xihueli. ");
INSERT INTO tojNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ja Jesusi, ja' ni ja sbajtanil c'ac'u ja semana sacui, pero saj to lec. Jaxa ma' mero bajtan sea sbaj yi, ja' ni ja María sbaj Magdala. Ja ixuc jahui, ixtalanubal yuj juque pucuj ajyi pero ja Jesusi yen ya el libre. ");
INSERT INTO tojNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jaxa María, cuando ch'ac yil ja Jesusi, ti huaj yal yab ja ma' smojan ec' ja Jesús ajyi. Ja yenlei jel triste aye juntiro. Huane xta oq'uel. ");
INSERT INTO tojNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jaxa cuando yabye que sac'an xa bi ja Jesusi, que yila bi, mi ni modo huas sc'uanea. ");
INSERT INTO tojNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jaxa mas tzaani, ja Jesusi ti sea sbaj yi chahuane huinique cuando bej to aye. Ti to huane eq'uel ba huitz. ");
INSERT INTO tojNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Soc jach ni ja yenlei, cho huaj yale yab ja tuc jumasa, pero mi ni soc ja jastal jahui, mi sc'uane. ");
INSERT INTO tojNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jaxa mas tzaan ja jahui, ti culane ec' ba mesa ja juluchuane snebumani. Ja Jesusi ti jac see sbaj yilea. Ti och aljuc yabye t'un abala yuj ja mi bi huas sc'uane. Jel bi ch'uuy juntiro ja sc'ujolei. Mi ni modo huas sc'uane ja jas huax alji yabye yuj ja matic yilahue que sacui ta. ");
INSERT INTO tojNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ti alji yabyea: ―Caxic xa ba spetzanil ja mundo. Loiltayic ec' ja abal it jel tzamali. Alahuic yab ba spetzanil ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jaxa ma' mi sc'uani, oj ni aajuc yi ja scastigoa, jaxa ma' huas sc'uani soc huax yiaj jai, oj ni coltajuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ja ma' huas sc'uanonei, ay jas oj bob sc'uluque ba oj naajuc que meran ni huas sc'uanonea. Quechan oj stae ti' ja jbiili, jaxa tantic pucuj jumasa oj yacta can ja cristiano ja ma' huax yixtalaanei. Oj bob c'umanuque soc yajc'achil abal. ");
INSERT INTO tojNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Oj bob syame ja mal chani. Ta ay c'a jas huax yuaje ba veneno, mi ni jas oj bob sc'uluquea. Oj bob ya cajan ja sc'ab ja ba scuerpo ja ma' malo ayi y oj ni tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cuando ch'ac yal jachuc ja Cajualtiqui, ti iiji q'ue ja ba satq'uinali, jaxa tihui, ti aaji yi ja yatel ba mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jaxa snebuman jumasa, ti huajyea. Huaj sloiltaye ja yabal ja Diosi ja ba spetzanil ja lugari. Coltajiye yuj ja Cajualtiqui. Ja yenlei huane sloiltajel, jaxa Cajualtiqui, jitzan cosa jas huax ya chijcajuc ba oj ya snaa ja cristiano que sbaj ni ja Diosa. Ti ch'aca. Amén.");
INSERT INTO tojNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lec ay Teófilo, ay jitzan ja ma' yaunej xa sbaje ba xchojlal oj stz'ijbaye ja jastal ec' cujticoni. ");
INSERT INTO tojNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Oj ni ch'ac ya ochuque juun ja jastal ni yala cabticon ja ma' mero yilahue ja Cajualtiqui desde ora jau q'ue ja yateli. Ja yenlei cho sloiltaye ec' ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jach ni ja quen chomajquili. Como jc'ana ta yi lec sc'ujol ja ma' huas snaa, jach ni ja huen Teófilo, xchojlal oj tz'ijba hui, ");
INSERT INTO tojNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ti oja huil que oj slaj sbaj soc ja jas jeubal ni ahuii. ");
INSERT INTO tojNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ja loil iti ja' to q'ue ja tiempo yora ay yatel ja rey Herodesi, ja ma' ay yatel ja ba Judea. Jaxa tihui cho ay jun pagre sbiil Zacarías. Ja yeni, ja' cuenta ay soc ja scuagriya ja Abiasi. Jaxa xcheumi sbiil Elisabet, ja' ni ja yintil ja Aaroni. ");
INSERT INTO tojNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jun xta yabale jel toj aye ja ba sti sat ja Diosi. Mi ni modo huax taji smulea. Huas sc'uane spetzanil ja smandar ja Cajualtiqui. Yib c'abal ni aye soc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero mey yuntiquile yuj ja mi ni nunca yila unticanel ja Elisabeti. Soc meum tatame xa. ");
INSERT INTO tojNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pero jun c'ac'u, como ja' ni xchol ja scuagriya, ja Zacarías aaji och pagreil ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Como jach ni culan yujile ja spagre ja judio jumasa, huas staahue ja ma' oj och stzic ja pom ja ba yoj stemplo ja Cajualtiqui. Jaxa Zacariasi yen co xchol. ");
INSERT INTO tojNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jun c'ac'u spetzanil ja cristiano ti aye ba fuera. Huane sc'umajel ja Diosi cuando huan tzicxel ja pomi ja ba yojol ja templo. ");
INSERT INTO tojNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ja Zacariasi, huaj to yile, tey jun yangel ja Cajualtiqui. Jaxa ángel jahui ti tec'an ec' ba lado stojol sc'ab ja ba mero bay ja tzicupomi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jaxa Zacariasi, huego huego c'umbi yoc sc'ab ja yajni yila. Jel och juntiro ja spensari. ");
INSERT INTO tojNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","―Zacarías, mi la xihui. Ja huaxa c'uman ja Diosi, abunubal. Jachuc ja Elisabet ja hua cheumi, oj to sman jun yal jaxa yal alatz jahui, Juan oja huaa yi ja sbiili. ");
INSERT INTO tojNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jaxa hueni oj chaanan yuj ja hua gusto. Jaxa cristiano jumasa, jel oj gustoaxuque juntiro cuando huax yilahue ja yal alatzi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ja alatz jahui jel nihuan oj huajuc ja ba sti sat ja Diosi. Mi oj yu ja yaalel tz'usubi ja ba paj xa soc mi ni ja jas huax yaa yacbeli. Desde ora oj jul xchonjeli, ti ni oj ajyuc ja ba sc'ab ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Soc mi quechanuc ja iti. Yuj ja yeni, jitzan ja israeleño jumasa oj cumxuque soc ja Cajualtic Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jaxa yal ahuunin oj ni manxuqui, yen bajtan oj ya q'ueuc ja ateli, ti xa oj q'ue stul ja yatel ja Cajualtiqui. Pero ja hua Juani, ja' ni oj stul ja smodo ja aluman‑Dios Eliasi. Ja jastal jel tzatz ec' ja Eliasi, jach oj huajuc ja yeni. Oj ya culan yi sc'ujol ja tatal soc ja yuntiquili. Jachuc ja ma' mix c'ocxi, oj ni ya c'ocxuca. Oj ya stul ja smodo ja ma' toji. Jaxa cuando huax jac ja Cajualtiqui, yaa ta ni chapxuc lec ja sc'ujol ja cristiano jumasa, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","―Pero mix naa ta meran ja jastal iti, xchi ja Zacariasi. ¡Pe tatamon xa ni taca! Soc jach ni ja jcheumi, meum xa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","―¿Huan ama xa huala ta mi Gabrielucon ja queni? Ti ni ayon ja ba sti sat ja Diosi, pero jecubalon ahui ba oja huab ja abal it jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero ja yaani, mudo oj canan. Mi oj bob c'umanan masan to oj c'otuc ja iti yuj ja mi ac'uan ja jas cala huabi, x'utji. Pero ja jas cala huabi, ti oja huil ta mi oj ni c'ot smeranila, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jaxa cristiano jumasa huane xta smajlajel ja Zacariasi pero jel och ja spensare yuj ja jel xa albi ta jan ja ba yoj templo. ");
INSERT INTO tojNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jaxa Zacariasi, cuando el jani, mi xax bob c'umanuc. Ti jac sc'ujole ja cristiano que ay jas snajsatin ja ba yojol ja templo. Quechan seña huas sea yuj ja mi ni modo huax bob eluc ja sc'umali. ");
INSERT INTO tojNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yajni tz'icui ja sc'ac'u ja yatel ba yoj templo, ti xa huaj ja ba snaj ja Zacariasi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ja ec' ja c'ac'u jumasa jahui, jaxa xcheum Elisabeti ti xa tucbia. Joe ixau mi ni jun parte el ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ti yala ja Elisabeti: ―Ja yaani c'ot ni ja c'ac'u oj ya ec' qui ja jq'uixol ja ba sti sat ja cristiano ja Cajualtiqui. Como yena ni yaunej qui ja jastal ayoni, xchi ja Elisabeti. ");
INSERT INTO tojNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jaxa ba suaquil ixahui ja ángel Gabrieli cho jecji otro vuelta yuj ja Diosi ba jun yal chonab, Nazaret sbiil, ja' ni sbaj ja lugar Galilea. ");
INSERT INTO tojNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jaxa ba chonab jahui, ti och ba jun naitz, jaxa ba naitz jahui, ti ni ay ja soltera jau ja smacben ixuc jun huinic sbiil José. Jaxa José ja' yintil ja rey David sbaj najatei. Jaxa soltera jahui, María sbiil. ");
INSERT INTO tojNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Huaj to yil ja María, huaj aajuc yi Dios yuj ja ángel ja bayi. Ti yalaa: ―María ja hueni mero tzaubala yuj ja Cajualtiqui. Ti ni ay amoc ja yeni. Ja ba spetzanil ja hua moj ixuquili, quechan ja huen tzaajiya. ¡Jel lec xa huila! x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero ja María jel juntiro och ja spensar ja cuando ch'ac yab jastal alji yabi. ―¿Jastal ay ja it ba? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","―Mi la xiu María. Jel lec huala ilji yuj ja Diosi ");
INSERT INTO tojNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jayuj ja yaani oj xa tucban. Oj ni aman jun yal aquerem. Oja huaa yi sbiiluc Jesús, ");
INSERT INTO tojNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jaxa yeni jel nihuan oj huajuc. Oj ni aljuc que ja' ni yunin ja Dios ja ma' jel nihuani, jaxa Cajualtic Diosi oj aajuc yi ba oj sc'ul mandar ja jastal sc'ulan mandar ja rey Davidi ja yen ja ma' ec' pax ta huujilexi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Oj cho sc'ul mandar ja israeleño jumasa spetzanil ja tiempo. Mi ni nunca oj eluc ja yateli, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jaxa María ti yalaa: ―¿Jastal ay ba? ¡Pero mey jtatam ja quen tac! xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ti yala ja angeli: ―Meyuc pero ja Espíritu Santo oj jac amoc ja huen. Quechan yuj ja yip ja Dios jel nihuani, jayuj oja man ja hua huali. Jaxa alatz oj manxuqui, mi ni jun smul ay pero oj ni aljuc que yunin Dios nia. ");
INSERT INTO tojNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Jach ni ja hua huatz Elisabeti, ja yeni tucbi ta, iday, ay xa sc'ujol. Ja' xa sbaj suaquil ixau ja huego, iday, spetzanil ja cristiano huas snaa que mi xa ni oj yil unticanela. ");
INSERT INTO tojNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Porque ja Diosi mi jas mi oj bob sc'uluc, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","―Pues lec ba, como ti ni ayon ja ba sc'ab ja Cajualtiqui. A sc'ul qui ja jas huaxa huala, xchi ja María. Jaxa angeli ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ja mismo c'ac'u jumasa jahui ja María ti huaj ja ba jun hacienda, ja' ni sbaj Judá, jaxa hacienda jahui, ti ni ay ba huitz. ");
INSERT INTO tojNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ti och c'ot ja ba snaj ja Zacariasi. Ti yaa yi Dios ja Elisabeti. ");
INSERT INTO tojNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ja Elisabeti, cuando yab aaji yi Dios yuj ja María, jaxa alatz ti to ni cuchan yujili snica sbaj juntiro. Ja Elisabeti ti iiji majan ja sti yuj ja Espíritu Santo, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","―Ja ba spetzanil ja hua moj ixuquili, quechan ni ja huena tzaubala ni leca, jaxa alatz oj to amani, t'ujpinubal ni ahuiaj. ");
INSERT INTO tojNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iday, ¿janec'on to ni ja queni? Ja huena ni snana ja Cajual tac, iday, quen huax jac ahuilon. ");
INSERT INTO tojNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quechan pavor cab ach'ac ahuaa qui Diosi, jaxa jastal ayoni, tzatz juntiro snica sbaj yuj ja sgusto. ");
INSERT INTO tojNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jel lec oj ec' ahuuj yuj ja hua c'uani porque ja jastal alji ahuabi yuj ja Cajualtiqui, oj ni c'ot smeranila, xchi ja Elisabeti. ");
INSERT INTO tojNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jaxa María ti yalaa: Ja ba jc'ujoli jel juntiro huax toyo ja Cajualtiqui, ");
INSERT INTO tojNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Jaxa caltzili jel alegre ay yuj ja Dios ja jColtanumtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ja queni ja' ni jmoj ja tz'iileli. Jel ajul ja jbaj, pero stalna ni ja jyaujulali. Ja yaani lamlamil oj toyjucon ");
INSERT INTO tojNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yuj ja jel nihuan ja jas sc'ulan qui ja ma' jel ja yipi. Ja sbiili mi cualquierauc. ");
INSERT INTO tojNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Lamlamil huas stalna ja syaujulale ja matic huax xiu yuji. ");
INSERT INTO tojNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Seunej jastal ja yipi. Ch'ac ya huaj sactantan ja ma' huas stoyo sbaj ja ba sc'ujolei ");
INSERT INTO tojNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Soc huax ch'ac sap yi ja yatel ja ma' jel tzatz ayi, jaxa ma' jel ch'in ayi, huax ya nihuanbuc. ");
INSERT INTO tojNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ja ma' jel huain xyabyei, ya but'uc soc ja jas jel lequi, jaxa rico jumasa, telan sc'ab ch'ac sec ele. ");
INSERT INTO tojNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ja yatjum jumasa ba Israeli cho scolta ja jastal ni yala que oj bi stalna syaujulalei. ");
INSERT INTO tojNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Mi ch'ay sc'ujol ja Abrahami soc spetzanil ja yintil ja janec' oj to manxuqui. Sc'ulan ta ni ja jastal yalunej yab ja ma' ec' pax ta cujtiqui, xchi ja María. ");
INSERT INTO tojNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ja María ti can soc ja Elisabet mojan oxe ixau, ti xa cumxi ja ba snaj ja el ja oxe ixau jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ja Elisabeti cuando tz'icui ja balune ixau ja xchameli, ti smana jun yal querema. ");
INSERT INTO tojNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jel gustoaxi yajni yila sat ja yal squeremi. Jach ni ja svecino jumasa soc ja yermano jumasa, cuando yabye yabalil jastal jel talnaji syaujulal yuj ja Diosi, jel gusto yabye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ja ay xa yioj huaxaque c'ac'u ja yal alatz jahui, ti jacye ba oj sc'uluque circuncidar ja jastal culan yujilei. Jaxa mismo ora jahui, ti sleahue ja sbiili. Ti yalahue que oj bi yaahue yi sbiiluc Zacarías, como jach ni sbiil ja stata. ");
INSERT INTO tojNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jaxa snani ti yalaa: ―Miyuc, oj sbiiluc Juan, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","―¿Jasyujil? Pero mi ni june ja hua huermano ay sbiil ja jastal iti, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ti sobohue yi ja stati jastal huas sc'ana yaa yi ja sbiili pero soc seña sobohue. ");
INSERT INTO tojNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jaxa yen ja Zacariasi ti sc'ana jun yal aq'uintea. Ti och stz'ijbaa, jaxa cuando yilahuei, Juan oj yii ja sbiili, xchi ja ba stz'ijbai. Jaxa smoj jumasa jel juntiro och ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ja mero ora jahui ti jamxi ja sti ja Zacariasi. Juntiro claro el ja sc'umali. Jel stoyo ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Juntiro och xihuele spetzanil ja svecino jumasa. Jaxa spetzanil ja matic tey ba huitz ba Judea, huego huego ch'ac yabye jastal huaji. ");
INSERT INTO tojNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jaxa matic ch'ac yabi, huan xta tz'iptz'unuc ja sc'ujolei: ―¡Saber jastal oj huajuc ja alatz it ja mas tzaani! xchiye. Jaxa yal querem jahui ti ni ay ba sc'ab ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jaxa Zacarías ja stat ja alatzi, ti iiji majan ja sti yuj ja Espíritu Santo, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Stz'acatal lec ja Cajualtic Dios sbaj Israeli. Yaunej sc'ujol ja yuntiquili. Jac yaa sbaj ba oj ya el libre ja matic yaunej sbaj ja ba sc'abi ");
INSERT INTO tojNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Soc cho seca quitic jun jColtanumtic jel ja yipi, ja' ni yintil ja rey David ja yatjum ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Seca ni ja jastal huan yaljel desde najate lec cuando yora yiaj majan ja sti ja yalumani, ja it mi cualquierauqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Yala jastal oj coltajucotic ja ba sc'ab ja jcondratiqui soc spetzanil ja matic coraja xta huax yilahuotiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Oj ni bi stalna syaujulal ja matic ec' pax ta cujtiqui soc oj ni snaa ja trato jau mi cualquierauqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jach ni alji yab ja Abraham ja ma' ec' pax ta cujtiqui. Jach ni bi oj sc'ul quitic ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Oj ni sc'ulucotic librar ja ba sc'ab ja jcondratiqui cosaque jachuc mey xihuel oj cateltatic ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Mi xa bi sbejuc oj lee ja jmultiqui. Toj bi oj ajyucotic ja ba sti sat ja Diosi spetzanil ja tiempo oj ajyuc ja jsac'aniltiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jaxa huen alatz, oja biiluc Yalumanil ja ma' jel nihuani. Ja huen bajtan oja hua q'ue ja ateli, ti xa oj cho stul ja Cajualtica. Ja jastal huax jamxi ja bej cuando oj jac ja ma' ay yateli, jach oja huaa puesto ja sc'ujol ja cristiano ja cuando huax jac ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Oja jee yi ja yuntiquili jastal oj coltajuque soc jastal oj c'ulajuque librar soc ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ja jDiostiqui jel juntiro huas stalna ja jyaujulaltiqui. Yaunejotic sc'ujol. Seca con quitic ja yunin ja ba satq'uinali ba oj yaa quitic jun yajc'achil jvidatic. ");
INSERT INTO tojNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jach sc'ulan quitic yuj ja ti ni ayotic ba yoj q'uiq'uinali, como paan jac'anotic xta ni yuj ja chamel ch'aquela. Ja jDiostiqui oj ni ya quiitic ic'a soc oj ya elcotic ja ba q'uiq'uinali. Oj ni yaa quijlabtica. Spetzanil ja jastal jahui, jach ni ch'ac yal ja viejito Zacariasa. ");
INSERT INTO tojNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Jaxa yal querem Juani q'uii. Jel tzatz ay soc ja Diosi. Cuando nihuan xa, ti ajyi ja ba jun lugar ba mi aayuc ja suinquili, jaxa mas tzaani, ti xa q'ue stul ja yatela. Ch'ac sloilta yab ja israeleño jumasa ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja c'ac'u jumasa jahui ti yaa jun orden ja ma' ay yatel, Augusto César sbiil. Spetzanil ja cristiano oj bi ch'ac ochuque juun. ");
INSERT INTO tojNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ja censo iti ja' ni ja sbajtanil censo sc'ulan cuando och yatel ja huinic Cirenio sbiil, ja ba lugar jau Siria. ");
INSERT INTO tojNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jaxa cristiano ti huajye spetzanilea. Cada cristiano pilan pilan ja smunicipioei, chican bay ja xchonabile ja ma' ec' pax ta yujilei. Ti ni huajye ba oj ochuque juuni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ja José ti culan ba Nazaret, ja' ni sbaj lugar Galilea. Ti huaj ja ba xchonabil ja rey Davidi, Belén sbiil, ja' ni sbaj Judea. Ti huaj ja tihui yuj ja ja' ni yintil ja José ja rey Davidi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huaj ba oj ochuque juun soc ja María ja smacben ixuqui. Jaxa yeni mi xa lecuc ay. ");
INSERT INTO tojNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Cuando ti aye c'ot ja tihui, ja' xa ni ti tz'icui ja c'ac'u oj tojbuqui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ti smana ja sbajtanil yali. Sbech'a soc jun c'uutz, ti yaa baan ba jun pesebre ja ba huax maconi ja huax huaa ja chantei. Ti yaa ja tihui yuj ja mi xa ni staahue majan ja sijlubei. ");
INSERT INTO tojNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jaxa mojan ja tihui ay talnachej. Ti aye ba yoj job. Acual ni huas stalnaye ja xchejea. ");
INSERT INTO tojNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Iday, huaj to yile, jun yangel ja Cajualtiqui huaj ja ba stz'eelei. Jaxa yijlab ja Cajualtiqui lijpi juntiro ja bay ja yenlei. Ti jel och xihuelea. ");
INSERT INTO tojNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ti yala ja angeli: ―Mi la xiuyex. Ata huabyex. Ay jas ajc'ach oj cala huabyex jel tzamal juntiro. Jel gusto juntiro oja huabyex. Jach ni spetzanil ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ja huaaxa manxi ta jun aColtanumex ja ba xchonabil ja rey Davidi, ja' ni ja Cajualtic Cristo ja ma' tzaubal yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ja huaxa taahuex jun yal alatz bech'ubal soc jun c'uutz ti baan ec' ja ba jun pesebre, ti oja naex que ja' nia, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Huaj to cho yile, cho tey jun nole ángel, ja' ni ja ma' tey ba satq'uinali. Huane xta stoyjel ja Diosi. Ti huax yalahuea: ");
INSERT INTO tojNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ja ba satq'uinali ti huax aaji yi stz'acatal ja Diosi, jaxa ba luumi, laman a ajyuc ja suinquili soc jel lec a yil sbaje, xchi ja ángel jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Yajni ch'ac yale jastal jahui, ti xa huajyea. Ti q'ueye q'ue ja ba satq'uinali, jaxa talnachej jumasa ti yala sbaj yenle itaa: ―La huaj quiltic ja ba Belén ba, xchiye. La huaj quiltic jastal ay ja jastal cabtic yala ja Cajualtiqui, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ti huajye huegoa. Ti ni staahue ja María soc ja José soc ja yal alatzi ti baan ec' ba jun pesebre. ");
INSERT INTO tojNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yajni yilahuei, ti yalahue ja jastal yabye yabalil ja yal alatz jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jaxa matic ch'ac yabye ja jas yala ja talnachej jumasa, jel juntiro och ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero ja María buc'an yuj ja jastic yabuneji. Quechan huan xta tz'iptz'unuc ja sc'ujoli. ");
INSERT INTO tojNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti xa cumxiye ja talnachej jumasa. Huane xta sc'anjel yi stz'acatal ja Diosi soc huane xta stoyjel ja Diosi yuj ja jastic ch'ac yabyei soc ja jas yilahuei. C'ot ta ni smeranil spetzanil ja jas ch'ac aljuc yabyei. ");
INSERT INTO tojNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ja ay xa yioj huaxaque c'ac'u ja yal alatz Jesusi, ti xa c'ulaji circuncidar ja jastal ni culan yujile ja judio jumasa, soc aaji sbiiluc Jesús. Jach ni yala can ja ángel ja yora mi tox tucbi ja snani que Jesús bi oj yii ja sbiili. ");
INSERT INTO tojNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ja tz'icui ja sc'ac'u huas stalna sbaje ja ixuquei, ja jastal ni ja smandar ja Moisesi, ti xa yiaje jan ja ba Jerusalena. Huaj yaahue yi ba sti sat ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ja jastal ni tz'ijbanubal ja smandar ja Cajualtiqui: Spetzanil ja yal querem bajtan alatzi, tzaubal bi oj ajyuc ba sti sat ja Cajualtic Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jayuj ja snan stat ja yal alatzi ti yiaje och ba oj yae yi ja smajtan ja Diosi ja jastal ni huax yala ja smandar ja Cajualtiqui: Jun bi pares paloma ma chab pichón oj aajuc yi ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jaxa ti ba Jerusaleni ay jun huinic sbiil Simeón. Ja huinic jahui jel toj soc meran huas sc'uan ja Diosi. Huan smajlajel ja ma' oj jac yaa snihuan sc'ujol ja israeleño jumasa. Jaxa Espíritu Santo tey soc ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aaji jac sc'ujol yuj ja Espíritu Santo mi bi oj chamuc ta mi c'a huax yila ja Cristo ja ma' tzaubal yuj ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ja viejito Simeoni, julbesnubal yuj ja Espíritu ti huaj ja ba templo ja mero ora jahui, jaxa snan stat ja yal querem Jesusi yioje jan ja ba templo ba oj sc'uluque yi ja jastal culan yujile soc ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jaxa Simeoni ti sc'atantela ja yal alatz Jesusi. Ti och sc'an yi stz'acatal ja Diosi: ");
INSERT INTO tojNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Cajual, ja huatjumon nia. Ja yaani, anima la chamyon xa. Jecahuon xa jun jc'ujol ja jastal ni huaxa hualai, ");
INSERT INTO tojNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porque soc ja mismo ja jsati quila ta ja ma' oj coltanuqui. ");
INSERT INTO tojNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Oj ni scolta spetzanil ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anima mi judiouc ja cristiano, ja jeca ta con ba oj yaa yijlab ja sbej ja yenle chomajquili, jaxa hua huuntiquil ja ba Israeli, oj ni ijlabanuc ja tihua, xchi ja viejito Simeoni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jaxa José soc ja María jel och ja spensare ja jastal huax alji sbaj ja yal queremi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ja Simeoni sc'ulan bendiciar, ti yal yab ja María ja snani: ―Ja querem iti, t'ujpinubal ba oj ya moc' jitzan ja israeleño jumasa soc jitzan lec ja israeleño jumasa oj cho ya stul sbaj. Jaxa yal alatz iti, coraja xta oj iljuc pero ja' ni ja seña yuj ja yena ni ja ma' tzaubal ni, xchi ja Simeoni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ti cho yalaa: ―Jachuc ja huen María. Lajan soc jun cuchilu oj ec' ja ba hua hualtzili. Yuj ja yeni oj ya chicnajuc ja jastal ay ja sc'ujol ja cristiano jumasa, xchi ja Simeoni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ja tihui cho ti ni ay ja viejita Ana. Ja yeni aluman‑Dios, ja' yunin ja Fanueli, ja' ni yintil ja Aseri. Ja Ana, cuando soltera to, nupani pero quechan juque jabil ec' soc ja statami ");
INSERT INTO tojNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ti can vigudaila. Jaxa tiempo ja yora c'otye ja María soc ja José, ay xa yioj ochenta cuatro jabil ja ora jahui. Pero mi ni huas sipa can ja temploa. Tola vida huas scomo ja suaeli. Ja' huajel sc'ujol sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ja yora jul ja snan stat ja yal alatzi, ja' ni ora jau ti jac ja Anai. Ti och sc'an yi stz'acatal ja Diosi. Ja mas tzaani ti huaj soc ja matic q'uelan sate que oj aajuc eluque libre ja ma' tey ba Jerusaleni. Ja' mero huan staajel ti' ja yal querem Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ja María soc ja José, ja yajni ch'ac ta sc'uluc spetzanil ja jas huax yala ja smandar ja Cajualtiqui, ti xa cumxiye ba Galilea ja ba Nazareti. ");
INSERT INTO tojNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ja yal querem Jesusi q'uii. Staa yip. Vivoaxi lec. Ac'ubal ni satal yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Cada jabil ja ba stiempo ja syalq'uinal ja judio jumasa, ja snan stat ja yal queremi ti huax huajye ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Cuando ay xa yioj lajchahue jabil ja Jesusi, ti xa huaj soc ja snan stati ja jastal ni culan yujilei huax huaj yile ja q'uin jau ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yajni ch'ac ja q'uini, ti xa huane cumxel ja ba snajei. Jaxa yal querem Jesusi ti can ja ba Jerusaleni, pero mi snaa ja snan stati. ");
INSERT INTO tojNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Huax yalahue que tey soc ja smojei, jayuj ti bejyiye jun c'ac'ua. Sleahue ja ba yermano jumasa soc ja ba sconocido jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero como mi staahue, ti cho cumxiye ja ba Jerusaleni. Huaj slee jani. ");
INSERT INTO tojNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Yajni ec' oxe c'ac'u ti staahue ja ba yoj templo. Ja Jesusi ti culan ec' ba snalan ja ma' huas sea ja smandar ja Moisesi. Ti huan smaclajela, ti huax och soba. ");
INSERT INTO tojNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Spetzanil ja ma' huan yabjeli jex och ja spensarei ja jastal ja svivoili soc ja jastal huax cho sutu jan ja loili. ");
INSERT INTO tojNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ja snan stati, yajni yilahuei, cham yabye. Ti yala ja snani: ―A cal, xchi, ¿jasyuj ja jach huaxa c'ulan quiticon ba? Huax leahuaticon soc ja hua tati pero jel xa huanticon pensar juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ti yala ja Jesusi: ―¿Jas lom huaxa leahuonex ba? ¿Mi ma t'un huax jac ja hua c'ujolex que ja yatel ja jTati, t'ilan ni oj c'uluca? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero ja nanal tatali mi yab slugaril ja jas yalai. ");
INSERT INTO tojNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ti huajye lajana. Cumxiye jan ja ba Nazareti. Jaxa Jesusi yib c'abal ni ac'ubal yuj ja snan stati. Jaxa snani naca buc'an yuj ba sc'ujol spetzanil ja jastaltic yabuneji. ");
INSERT INTO tojNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ja Jesusi mas to huan vivoaxel. Jach ni ja scuerpo, huan q'uiel. Huan xa tzatzbel ja ba sti sat ja Diosi. Huan xax aaji cuenta yuj ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ja tiempo jahui ay xa yioj quince jabil ochel yatel ja Tiberio César, jaxa ti ba Judea, gobierno ay ja Poncio Pilato. Jaxa ba Galilea ja Herodesi, ay yatel. Jaxa Herodesi ay jun yermano Felipe sbiil, ay yatel ja ba Iturea soc jach ni ja ba Traconite. Jaxa ba Abilinia ay ochel yatel ja Lisaniasi. ");
INSERT INTO tojNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jaxa Anasi soc ja Caifasi, yenle ja pagre mas nihuan yujile ja judio jumasa ja tiempo jahui. Jaxa Juan ja yunin ja Zacariasi, ti xa c'umaji yuj ja Diosi ba jun ch'ayan lugar. Ja tiempo jahui, tey ec' ja ba ch'ayan lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ja yen ja Juani ti huaj ec' ja ba sutanal ja nihuanja Jordani. Huan sloiltajel ec' jastal huax aaxi yi ja' ja cristiano cuando huas suchi ja sc'ujolei ba jachuc oj bi ch'ay snaajel ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jach ni huan sc'ulajel ja jastal tz'ijbanubal ja ba slibro ja aluman‑Dios Isaiasi: Oj to ajyuc jun ma' tzatz lec oj c'umanuc ja ba lugar jau mey lec ja suinquili, ti oj yal yab ja cristiano ja jastal iti: Ja jastal huaxa jamahuex ja bej ja cuando oj jac ja ma' ay yateli, jach oja huaex puesto ja hua c'ujolexi porque oj xa jacuc ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Jun rey, ta huax jamxi ja sbeji, spetzanil ja cañada jumasa oj ch'ac but'xuc. Anima nihuan huitzuc ma yal huitzuc, oj ch'ac jemxuc, jaxa bej ba jel lochani, oj ni tojxuc leca, soc ja bej jel lopan jotz'ani, oj cho lajxuc lec. ");
INSERT INTO tojNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ta jach c'a huaxa huaa puesto ja hua c'ujolexi, oja huilex oj ni coltajananic ja cuando huax jac ja jColtanumtiqui. Jach ni yala ja Isaiasi cuando staa ti' ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y meran nia, ti jac jun nole cristiano ja bay ja Juani. Huax jacye ba oj aajuc yile ja' yuj ja Juani, pero como huas snaa ja Juan jastal ay ja sc'ujolei, ti huax alji yabyea: ―Ja huenlexi ja' amojex ja chan it huax elye ajnel ja cuando huax jac ja tziq'uinali. ¿Huan ama xa hualahuex que ta oj elanic libre yuj ja huaxa pacahuex ajneli? ¡Majlayic! ti oja huilex ta loil tajnel ja scastigo ja Diosi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","A ilxuc ja hua modoex que suchi ta meran ja hua c'ujolexi. Mi jauc ja huen ita oja hualex, ja' quintilticon ja Abrahami, oj chianiqui. Huaxa cala huabyex, ja Diosi ta huan c'a sc'ana, oj ya pax yintilil ja Abraham ja ton jumasa iti. ");
INSERT INTO tojNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ja yaani, lajan soc jastal jun huinic puesto xta ay ja yecheji ba oj sc'utz con todo yech ja tei. Jach ni ay ja Dios chomajquili. Puesto xta ay ba oj yaa castigo. Ja ma' mi lecuc ja smodo, lajan soc ja te' it mi lecuc ja sati. Oj c'uchuc ele. Oj jipxuc ja ba yoj c'ac', xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","―Entonces ¿jasunc'a oj c'ulticon ba? xchi ja cristiano jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","―Pues ta ay c'a ma' ay chab lame ja sc'ui, a yaa yi ja ma' mey yioji. Jach ni a sc'uluc ja ma' ay suaeli, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ti jacye chaboxe ja ma' huas stzomo ja taq'uini. Huas sc'ana oj aajuc yile ja'. Ti yalahuea: ―Maestro, jaxa quenticoni, ¿jasunc'a lec oj c'ulticon ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ti yala ja Juani: ―Moc lom ec'anic mas ja jastal huax yala ja hua leyexi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jach ni chaboxe soldado, ti yalahuea: ―Jaxa quenticoni, ¿jasunc'a lec oj c'ulticoni? xchiye. ―Pues mi lom xa yamahuex ja cristiano ba oj hua eluquex fuerza ja jas yiojei. Mi lom xa locohuex abal q'uiq'uinal ja cristiano, jaxa hua tz'acolexi, gusto cananic ja janec' huax aaji ahuilexi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jaxa cristiano jumasa, cuando yabye ja jas huan yaljel ja Juani, yaa jun snihuanil sc'ujole. Huan xta tz'iptz'unuc ja sc'ujolei: ―Ja Juan iti, ¿ja' ma yen ja Cristo ja ma' tzaubal yuj ja Diosi? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ti yala ja Juani: ―Pues ja queni huax ca huiex ja' pero ay ma' oj to jacuqui. Ja yeni oj to yaa huilex ja Espíritu Santo pero con todo yip. Ja matic mix c'ocxiyei, oj ni aajuc cajan c'ac'a. Jaxa yen ja ma' oj to jacuqui, mas nihuan juntiro yuj ja queni. Mi ni oj maconucon oj sop yi ja xanabi. ");
INSERT INTO tojNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ja yeni huax jac ba oj ch'ac spil ja ba lec ja sat iximi soc ja ba somelali. Oj smes el ja stz'iilelali, ti xa oj snol can ja ixim ja ba snajtzili, jaxa spolvoili ti oj ya och ba yoj c'ac' ja ba mi ni nunca huax tupi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Soc ja jastal iti soc otro jitzan modo ti huax och sloilta yab ja cristiano ja abal it jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ja Herodes it ja ma' ay yateli, ti alji yab ja smul yuj ja Juani. Mi bi sbejuc ja jastal huan sc'ulajel soc ja ixuc Herodíasi, ja xcheum ja yijtz'in Felipe, soc cho yala spetzanil ja smodo jel malo huan sc'ulajeli. ");
INSERT INTO tojNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iday, mas to somelal huaj ja rey Herodesi, hasta slutu preso ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ja tiempo yora huan to yiijel ja' spetzanil ja cristiano, jach ni ja Jesusi. Cho yiaj ja' ja yen chomajquili. Ti och sc'umuc ja Diosi, jaxa satq'uinali jamxi. ");
INSERT INTO tojNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ti co t'ucan sbaj ja Espíritu Santo, pero entero splanta jastal jun paloma. Ti c'umani ja Dios ja ba satq'uinali: ―Ja huen mero cunina. Jel yaj huax cabya soc jel huaxa huaa qui gusto, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ja Jesusi ja yora q'ue stul ja yateli, ay xa yioj mojan treinta jabil. Huax alji que ja' bi yunin ja José. Jaxa José, ja' stat ja Elí, ");
INSERT INTO tojNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Jaxa Elii, ja' stat ja Matat, jaxa Matati, ja' stat ja Leví, jaxa Levii, ja' stat ja Melqui, jaxa Melquii, ja' stat ja Jana, jaxa Janai, ja' stat ja José, ");
INSERT INTO tojNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jaxa Josei, ja' stat ja Matatías, jaxa Matatiasi, ja' stat ja Amós, jaxa Amosi, ja' stat ja Nahum, jaxa Nahumi, ja' stat ja Esli, jaxa Eslii, ja' stat ja Nagay, ");
INSERT INTO tojNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Jaxa Nagayi, ja' stat ja Maat, jaxa Maati, ja' stat ja Matatías, jaxa Matatiasi, ja' stat ja Semey, jaxa Semeyi, ja' stat ja José, jaxa Josei, ja' stat ja Judá, ");
INSERT INTO tojNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jaxa Judai, ja' stat ja Joana, jaxa Joanai, ja' stat ja Resa, jaxa Resai, ja' stat ja Zorobabel, jaxa Zorobabeli, ja' stat ja Salatiel, jaxa Salatieli, ja' stat ja Neri, ");
INSERT INTO tojNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Jaxa Nerii, ja' stat ja Melqui, jaxa Melquii, ja' stat ja Adi, jaxa Adii, ja' stat ja Cosam, jaxa Cosami, ja' stat ja Elmodam, jaxa Elmodami, ja' stat ja Er, ");
INSERT INTO tojNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Jaxa Eri, ja' stat ja Josué, jaxa Josuei, ja' stat ja Eliezer, jaxa Eliezeri, ja' stat ja Jorim, jaxa Jorimi, ja' stat ja Matat, ");
INSERT INTO tojNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Jaxa Matati, ja' stat ja Leví, jaxa Levii, ja' stat ja Simeón, jaxa Simeoni, ja' stat ja Judá, jaxa Judai, ja' stat ja José, jaxa Josei, ja' stat ja Jonán, jaxa Jonani, ja' stat ja Eliaquim, ");
INSERT INTO tojNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Jaxa Eliaquimi, ja' stat ja Melea, jaxa Meleai, ja' stat ja Mainán, jaxa Mainani, ja' stat ja Matata, jaxa Matatai, ja' stat ja Natán, ");
INSERT INTO tojNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jaxa Natani, ja' stat ja David, jaxa Davidi, ja' stat ja Isaí, jaxa Isaí, ja' stat ja Obed, jaxa Obedi, ja' stat ja Booz, jaxa Boozi, ja' stat ja Salmón, jaxa Salmoni, ja' stat ja Naasón, ");
INSERT INTO tojNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Jaxa Naasoni, ja' stat ja Aminadab, jaxa Aminadabi, ja' stat ja Aram, jaxa Arami, ja' stat ja Esrom, jaxa Esromi, ja' stat ja Fares, jaxa Faresi, ja' stat ja Judá, ");
INSERT INTO tojNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jaxa Judai, ja' stat ja Jacob, jaxa Jacobi, ja' stat ja Isaac, jaxa Isaqui, ja' stat ja Abraham, jaxa Abrahami, ja' stat ja Taré, jaxa Tarei, ja' stat ja Nacor, ");
INSERT INTO tojNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Jaxa Nacori, ja' stat ja Serug, jaxa Serugui, ja' stat ja Ragau, jaxa Ragahui, ja' stat ja Peleg, jaxa Pelegui, ja' stat ja Heber, jaxa Heberi, ja' stat ja Sala, ");
INSERT INTO tojNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Jaxa Salai, ja' stat ja Cainán, jaxa Cainani, ja' stat ja Arfaxad, jaxa Arfaxadi, ja' stat ja Sem, jaxa Semi, ja' stat ja Noé, jaxa Noeji, ja' stat ja Lamec, ");
INSERT INTO tojNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Jaxa Lamequi, ja' stat ja Matusalén, jaxa Matusaleni, ja' stat ja Enoc, jaxa Enoqui, ja' stat ja Jared, jaxa Jaredi, ja' stat ja Mahalaleel, jaxa Mahalaleeli, ja' stat ja Cainán, ");
INSERT INTO tojNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Jaxa Cainani, ja' stat ja Enós, jaxa Enosi, ja' stat ja Set, jaxa Seti, ja' stat ja Adán, jaxa Adani, ja' sc'ulan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ja Jesusi tey soc juntiro ja Espíritu Santo, jayuj ti xa el ja ba nihuanja Jordani. Julbesnubal huaj yuj ja Espíritu ja ba jun ch'ayan lugar. ");
INSERT INTO tojNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Cuarenta c'ac'u tejc'aji ja tihui, jaxa cuarenta c'ac'u jahui, c'ulaji lec probar yuj ja diablo. Ja c'ac'u jumasa jahui mi jas yab altiro. Cuando ch'ac ta ec'uc ja c'ac'u jumasa jahui, ti xa och huain xyaba. ");
INSERT INTO tojNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ti alji yab yuj ja diablo: ―Ja huena ni yunin Diosaa. A pax huego panil ja ton iti, xyutaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ti yala ja Jesusi: ―Pero jach ni tz'ijbanubal taca, que mi quechanuc yuj ja pan huax ajyi sac'anil ja cristiano pero ja' ni yuj spetzanil ja spalabra ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ja Jesusi ti iiji yuj ja diablo ba jun chaanil huitz. Ti ch'ac jeejuc yi huego huego spetzanil ja lugar ja ba spetzanil ja mundo. ");
INSERT INTO tojNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ti alji yab yuj ja diablo: ―Ja hueni oj caa hui ba hua c'ab spetzanil ja lugar jumasa. Jel nihuan oj iljan yuj ja cristiano. Ja queni ac'ubal qui ba jc'ab spetzanil ja lugari. Chican ja ma' huax c'ana ja queni, oj ni caa yia. ");
INSERT INTO tojNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ja huen quechan oj coan mec'an ja ba sti jsati, oj ni ch'ac caa hui ba hua c'ab ja lugar jumasa, xchi ja diablo. ");
INSERT INTO tojNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ja Jesusi ti yalaa: ―Elan ja ba jtz'eel Satanás, yuj ja jach ni tz'ijbanubali: Ja ba sti sat ja hua Huajual Diosi oj coan mec'an. Quechan ja yen ja ma' oja huatelta, xchi ja ba yabal ja Dios tac, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ti cho iiji och ja ba Jerusalén ja Jesusi. Aaji q'ueuc ja ba s'olom ja templo ja tihui. Ti alji yaba: ―Huena ni yunin Diosaa. Jipa quit co abaj, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","¿Mi ma jach huax yala ja ba yabal ja Dios ba? Oj seca hui ja yangel ba oj stalnaya, ¿mi ma xchi ba? ");
INSERT INTO tojNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ja yenlei soc sc'abe oj sbecha eq'ue cosaque jachuc mi oja c'ochuc ahuoc soc ja toni. Ala quitic ta mi jach huax yala, xchi ja diablo. ");
INSERT INTO tojNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ti cho yala ja Jesusi: ―Es jach nia, pero huax cho yala que mi lom xa c'ulan probar ja hua Huajual Diosi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ja diablo, yajni ch'ac ja jun lame prueba iti, ti xa spila sbaj chaboxe tiempoa. ");
INSERT INTO tojNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ja Jesusi ti cumxi ba Galilea. Jel tzatz ay soc ja Espíritu Santo, jayuj ti el yabalil ja ba yibanal ja lugari. ");
INSERT INTO tojNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ti huan seejel ec' ja ba yiglesia ja judio jumasa. Jel nihuan huax ilji yuj spetzanil ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ti cho huaj ja ba Nazaret ja ba q'uii. Ja c'ac'u huax jijliye ja judio jumasa, ti och ja ba yiglesiaei ja jastal ni smodo. Ti q'ue tec'ana. Och sq'uel ja yabal ja Diosi ");
INSERT INTO tojNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ti aaji yi ja slibro ja Isaías ja aluman‑Diosi. Ja cuando sama ja libro, ti staa ja ba parte huax yala jachuqui: ");
INSERT INTO tojNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ja Yespíritu ja Cajual Diosi ti ni ay ec' jmoca. Yuj ja stzaunejon ba oj loilta yab ja matic mi jas yiojei. Ay jas yajc'achil oj cal yabye, jaxa matic jel triste ayi, oj ca ec'uc ja stristeilei, jaxa matic naca mochan tei, jac cal yabye que libre xa aye, jaxa matic tupel ja satei, jac ca jamxuc ja satei. Jaxa matic jel coel huax iljiyei, jac ca ec'uc ja suocolei. ");
INSERT INTO tojNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Seconejon ba oj cal yab ja mulanum jumasa que ja' xa ni tiempo huax talnaji syaujulale yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ja cuando ch'ac ta sbal ja juun ja Jesusi, ti cho yaa yi ja ma' ay yatel ja ba iglesia. Ti och culana. Och see yi ja cristiano. Jaxa spetzanil ja ma' tey ba yoj iglesia, ti huax tojtoq'uelji lec ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ti och yal yabyea: ―Ja yaani ja ba sti ja hua satexi ja jas tz'ijbanubal ja ba slibro ja Diosi huan xa c'otel, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jaxa cristiano jel tzamal huas staahue ti' ja Jesusi. Juntiro ch'abajiye yuj ja jel tzamal juntiro ja jas huan yaljeli. ―¿Jastal ay ba? ¿Mi ma jauc ja yunin ja José ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ti yala ja Jesusi: ―Huax naatic jastal ja yaljel ita ni huax calatiqui: Ta doctor c'a aya, ajnanan ja il ba. Jach ni mero huan c'umal ja hua c'ujolexi. Ja huabyex ni ja jastal ca tojbuc ja cristiano jumasa ba Capernaum. Jaxa ba slugar ja ba q'uii, mi jas huas sc'ulan, la chiyex. ");
INSERT INTO tojNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Huax cala huabyex pero meran, que mi ni jun aluman‑Dios c'ulaji caso ja ba q'uii, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pero oj cala huabyex ja smeranili. Ja tiempo jau ja tey ja aluman‑Dios Eliasi, ja' ni ja tiempo jau albel lec mi ni co ja jai ‑ oxe jabil soc huaque ixau mi yaa jai ‑ ti ajyi jun nihuan huain ja ba sutanal ja satq'uinali. Jaxa tiempo jahui jel ni jitzan ja viguda jumasa ja ba Israeli. ");
INSERT INTO tojNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero mi ni june ja viguda jumasa jahui huaj iljuc yuj ja Eliasi. Es huaj nia, pero jun viguda ba otro raza soc tuc lugar ay. Ti culan ba Sarepta ja ba lugar Sidoni. ");
INSERT INTO tojNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jaxa stiempo ja aluman‑Dios Eliseo, ja ba Israeli jel ni ja ma' yioj ja chamel it huax c'a ja sbactelei. Pero mi ni june tojbiye ja israeleño jumasa. Eso sí, tojbi ni ja Naamani pero otro raza ja yeni soc tuc lugar ay. Ja yen ti culan ba Siria, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yajni ch'ac yabye ja jastal iti, ja ma' tey ba yoj iglesia, juntiro q'ue ja scorajaei. ");
INSERT INTO tojNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xachalji xta ch'ac q'ueuque, ti yiaje el ja ba sti ja hacienda jahui. Yiaje man ba scajanal ja huitz ja bay ja xchonabilei. Ti huas sc'ana oj sipe co ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ja yen ja Jesusi ti ec' sc'utz och ja ba snalan ja yenlei. Ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ti xa huaj och ja ba Capernaum, jun chonab ba Galilea. Jaxa c'ac'u huax jijliye ja judio jumasa, ja Jesusi ti huax huaj see yi ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jel huax och spensare yuj ja jas huan seejeli. Ja sloili lajan soc yabal june ma' ay yatel. ");
INSERT INTO tojNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ja ba yiglesia ja judio jumasa tey jun huinic ja tihui ixtalanubal yuj ja pucuji. Ti ahuani tzatz leca: ");
INSERT INTO tojNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Actayoticon. Iday, ¿jastal aya jmocticon ja huen ba Jesús nazareño? ¿Jaquela ma ba oja ch'ayoticon? Ja queni huax naa mach ayaa. ¡Ja hueni mi ni huaxa lea tan amul tac! Ti ni aya soc ja Diosa, xchi ");
INSERT INTO tojNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja Jesusi ti scomo c'ac' leca: ―¡Ch'abanan ja hueni! Acta can huego ja huinic iti, xyutaj. Jaxa pucuji ti sbantzun sbaj luuma ja ba sti sat ja yenlei. Ti yaa can ja huinic jahui. Mi ni jun spaltail cana. ");
INSERT INTO tojNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Spetzanil ja cristiano jel och juntiro ja spensarei. Ti huax yala sbaje yenle itaa: ―¿Ba jac ja loil iti? xchiye. Lajan soc jun ma' ay lec yateli. Jel ja yip huas sc'ulan mandar ja pucuj tac. Iday, ¡huan nix c'uaji taca! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jaxa ba spetzanil ja lugar mojani, ch'ac yabye yabalil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ja Jesusi ti xa el ja ba yiglesia ja judio jumasa. Ti huaj ja ba snaj ja Simoni. Jaxa snial ixuc ja Simoni jel juntiro ja sc'ajc'ali. Ja Simoni ti sc'ana yi pavora que oj huaj yile. ");
INSERT INTO tojNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jaxa Jesusi ti och c'uban sq'uelaa. Ya lamxuc ja sc'ajc'ali. Huego eq'ui. Ti xa q'ue huegoa. Yen xa sc'ulan ja suael ja huiniquei. ");
INSERT INTO tojNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ja cuando huan xa mucxel ja c'ac'u, spetzanil ja matic ay xchamumi, chican jas tiq'ue chamelil yiojei, ti huax iiji och yi ja Jesusi. Jaxa yeni ti huax ya cajan ja sc'ab ja ba cada jujune ja yenlei. Huan nix ch'ac ya tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jach ni ja tuc chomajquili. Jel jitzan ja matic actaji can yuj ja pucuji. Huax ahuaniye, ti huax cho yalahuea: ―Ja hueni, huena ni ja yunin Diosa, xchiye xta. Pero ja Jesusi ti huas scomo c'ac' leca. Mi aaji c'umanuque yuj ja huas snaahue que ja yeni, yena ni ja Cristoa. ");
INSERT INTO tojNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jaxa el ja c'ac'u, ti huaja. Ti huaj ba jun lugar ja ba mey lec ja suinquili, jaxa cristiano huane sleejel eq'ue. Ti staahue ja tihui. T'ilan yalahue yabi que mi bi oj jipjuque can ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ja Jesusi ti yalaa: ―Pero jach ni ja tuc lugar chomajquili. T'ilan oj huaj cal yab jastal ay ja ba huas sc'ulan mandar ja Diosi. Jayuj jecubalon ja il tac, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jaxa ba tuctuquil yiglesia ja judio jumasa ja ba Galilea, ti huan sloiltajel ec' ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ja yora ti ajyi ja Jesús ja ba sti ja ja' ja ba Genesareti, ja cristiano huan xta xac botz'an sbaj ja yen ba oj yabye ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ja Jesusi ti yila chab barco ti lac'an ja ba sti ja jai. Jaxa yamachay jumasa coye ja ba sbarcoei. Ti huane siijel ja yenubei. ");
INSERT INTO tojNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jaxa Jesusi ti q'ue june ja barco jahui, ja' sbarco ja Simoni. Ti sc'ana yi pavor ja Simón Pedro ba oj ya och och t'un mas ja ba yoj jai. Jaxa Jesusi ti och culan ja ba yoj barco. Ti och see yi ja cristiano jumasa ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yajni ch'ac see yi ja cristiano, ti yal yab ja Simoni: ―Ochanic och mas ja ba yoj jai. Tix hua ochuquex ja hua huenubexi ba oja yamex ja chayi, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jaxa Simoni ti yalaa: ―Pero q'uelahuil Maestro, snajtil ja acuali huanticon atel pero mi ni jas jyamaticona. Pero como huen huaxa huala, oj ni cho jipticon co ja quenubticona, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jach ni sc'ulanea. Jaxa yenubei but' juntiro ja chayi, pero ch'ac c'utzuc yuj ja yalali. ");
INSERT INTO tojNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ti seahue yi seña ja smojei, ja ma' tey ba otro barco ba oj jac coltajuque. Ti jacyea. Y jach ni ja sbarco ja yenlei. Ch'ac but' ja chayi. Ibjaaxi yuj ja yalali. ");
INSERT INTO tojNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Cuando ch'ac yil ja jastal it ja Simón Pedro, ti co mec'an ja ba sti sat ja Jesusi: ―Mi lom xa mojanon, Cajual, porque ja queni mulanumon, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jach yala yuj ja xihuel ja sbaj ja janec' syamahue ja chayi. Jach ni ja smoj jumasa chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Soc jach ni ja Jacobo soc ja Juani, ja yuntiquil ja Zebedeo, smoj sbaje yamachayil soc ja Simón Pedroi. Jel och ja spensare juntiro. Pero ja Jesusi ti yal yab ja Simoni: ―Mi xa c'ulan pensar. Meran, ja' huajel ac'ujolex syamjel ja chayi pero ja yaani, ja' oja huaa ac'ujolex oja leex jan qui ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yajni yaahue eluque jan ja chab barco jau ja ba sti jai, ti xa yaahue can spetzanila. Ti huajye soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jun c'ac'u ja Jesusi tey ba june ja hacienda jumasa ja ba lugar jahui. Huaj to yile, ti jac jun huinic ay yioj jun chamel huan c'ael ja sbacteli. Jel xa yioj juntiro. Ja huinic jahui cuando yila ja sat ja Jesusi, ti co mec'ana. Och sc'an yi pavor: ―Cajual, ta jach c'a huaxa c'ana, oj bob hua tojbucon, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jaxa Jesusi ti xija ja sc'abi. Syama, ti yalaa: ―Huan nix c'ana oj tojbana, xchi. Jaxa sc'aelali, huego huego eq'ui. ");
INSERT INTO tojNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ti alji yab que moc lom ma' oj yal yabi: ―Pero caax, utji, cax jea baj yi ja pagre. Yuj ja lec xa aya, jayuj aa yi ja smajtan ja Dios ja jastal ni yala can ja Moisesi. Soc ja jahui ti oj snaa ja cristiano que tojbiya ta, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ja yabalil ja Jesusi mas to pucxi juntiro. Jaxa cristiano, partida huax jacye ba oj smaclaye soc ba oj aaji tojbuque soc ja xchamelei. ");
INSERT INTO tojNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jaxa Jesusi ti huaj ba jun lugar ba mey lec ja suinquili ba oj bob sc'umuc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jun c'ac'u ti huan seejel ja Jesusi. Ti aye jun nole judio, fariseo sbiil. Ja fariseo jumasa soc ja ma' huas sea ja smandar ja Moisesi ti culane ec'a. Ti ch'ac jacuque ja ba spetzanil ja ch'in lugar sbaj Galilea soc ja sbaj Judea soc jach ni ja ba Jerusaleni. Jaxa c'ac'u jahui jel tzatz juntiro huaj ja yip ja Jesusi. Ch'ac ni tojbuc yuj ja cristiano jumasa, ja' ni yuj ja yip ja Cajualtic Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huaj to cho yile, ti jac chaboxe huinica. Lican yujile jun huinic tulido ay. Huane fuerza oj yii och man yoj naitz ba oj see yi ja Jesusi, ");
INSERT INTO tojNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mi ni staahue modo jas oj sc'uluquea yuj ja jel but'el ja cristiano. Jayuj ti xa q'ueye ba s'olom ja naitzi. Ti sotohue ja tihui, ti ya couque ja xch'ajtilteili. Ti ya couque ba snalan ja cristiano ja ba mero spunto bay ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ja Jesusi, ja yila jastal huax c'uaji, ti yalaa: ―Hijo, ja hua muli perdonado xa ay, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jaxa fariseo jumasa soc ja matic huas sea ja smandar ja Moisesi ti och sc'uluque pensara: ―¿Janec' to ni ja iti ja huan stoyjel sbaji? ¿Yuj ama yen ja Dios ba? ¿Aya ma' oj bob sc'ul perdonar ja mulal ba? ¿Mi ma quechanuc ja Dios ba? xchi ja ba sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jaxa Jesusi snaa jastal ay ja spensar ja yenlei, ti yalaa: ―Iday, ¿jasyuj ja jach huan huaatzhuunuc ja hua c'ujolex ja huenlex ba? ");
INSERT INTO tojNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jasunc'a huaxa c'anahuex oj cal ba? ¿Q'uean, bejyan, oj ma cut ba? ¿Ja' ma gustoex jach oj cal ba, soc ja huax cala, ja hua muli, perdonado xa ay? ");
INSERT INTO tojNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ja queni ti coelon jan ja ba satq'uinali. Ja' catel ayon ja ba luumi que oj ni jc'ul perdonar ja mulali. Pero ba oja c'uuc ja huenlexi, oj ni ca tojbuc ja huinic ita. Ti yal yab ja huinic ja ma' tulido ayi que oj q'ueuc. ");
INSERT INTO tojNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jaxa huinic jahui ti ba satalajel abal q'ue huego. Yiaj ja suaynubi ja jas huas suaynuban ajyi. Ti xa huaj ba snaji. Huan sc'anjel yi stz'acatal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Spetzanil ja cristiano jahui jel och ja spensarei. Ti yalahuea: ―¡Stz'acatal ja Diosi! ¡Xihuel ja sbaj ja jas huan sc'ulajeli! Quilatic ta ja jas jel tzamal huan sc'ulajel ja Diosi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Yajni ch'ac sc'uluc ja jastal it ja Jesusi, ti xa huaja. Ti yila jun colector sbiil Leví ti culan ec' ja ba huax och ja contribucioni: ―¿Mi ma xa c'ana huajan jmoc ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ja Levii ti yaa can spetzanil ja atel jahui, ti huaj soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ja mas tzaani ja Leví ti sc'ulan jun nihuan huaelal ja ba snaji ba oj sloc ja Jesusi. Jitzan ja ma' jaqui soc ja smoj colectorili. Naca ti xa aye ba mesa. ");
INSERT INTO tojNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jaxa matic huas sea ja smandar ja Moisesi soc ja fariseo jumasa ti och huooljuque sbaj ja snebuman jumasa: ―¿Mi ma la q'uixuiyex lajan huanex huael soc ja tantic colector jumasa? ¡Jun ita aseq'uex huanex huael soc ja tantic mulanum jumasa tac! ");
INSERT INTO tojNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ti yala ja Jesusi: ―¡Lec xta huujilex ja huenlexi, meyuc anesesidaex soc doctor como naca jel lec ayex! Pero ja yenlei huas sc'ulan necesitar jun sdoctore. ");
INSERT INTO tojNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja' ni yuj jaquelona ba oj colta soc ja smulei ba oj suchuc ja sc'ujolei pero ja ma' lec ayi, mi t'ilan huax yab oj colta, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ja cristiano ja ma' huane smaclajel ja loili ti yalahuea: ―Q'uelahuilex, ja snebuman ja Juani tola vida huas scomo ja suaelei soc huas sc'umane ja Diosi. Jach ni culan yujile ja snebuman jumasa ja fariseo. Jaxa hua nebuman jumasa ja hueni mi ni t'usan huas scomo ja suaelea, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ti yala ja Jesusi: ―Ilahuil jun ch'ac abalanum. Ja sloc ja nupanumi mi ni sbejuc mi oj huauquea, como tzomane to soc ja nupanumi. ");
INSERT INTO tojNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero oj ni jacuc ja c'ac'u cuando oj ni ch'ay yujile ja nupanumi. Eso sí, ja c'ac'u jumasa jahui, oj ni scom ja suaelea yuj ja oj ni but'uque yuj ja stristeilei. ");
INSERT INTO tojNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ti cho och yal otro loila: ―Mi ni modo oja ch'iex jun yajc'achil ac'uex ba oj hua ochuquex smactonil ja ba poco xa. Ta jach c'a huaxa c'ulanex, oj sujbuc juntiro ja macton jau ba yajc'achili, soc toj coleto oj huajuc. ");
INSERT INTO tojNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jach ni jun poco oxom ba ay syaj. Mix bob hua och ja taan ba yajc'achil to. Jach c'a huaxa c'ulan, huaj to ahuile, leutz'uji ta snalan ja oxomi, jaxa hua taani, mi xa lecuca. ");
INSERT INTO tojNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mas lec, aa ba jun yajc'achil oxom ba mey syaj. Jachuc, mi ni jas oj sc'uluca, mi ni ja oxomi soc mi ni ja taani. ");
INSERT INTO tojNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jach yala jastal it ja Jesusi porque jel huocol huax yab ja ma' c'ajyel soc ja poco modo. Cuando huax yabye jun cosa yajc'achil, mi ni modo huas sc'anahuea. ―Mas lec juntiro ja jpoco modotiqui, huax xchiye. Porque ja yajc'achili, ja' ni sbaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jun sc'ac'uil ja sijlele ja judio jumasa ja Jesusi soc ja snebuman jumasa ti ecye ba jun yalajil trigo. Jaxa snebuman jumasa ti stuch'uhue ja sati. Ti sbuyuhue ja ba yoj sc'abei, ti sc'uxuhuea. ");
INSERT INTO tojNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jaxa chaboxe fariseo jumasa ti yalahuea: ―¿Jasyuj jach huaxa c'ulanex ba? ¿Yuj ama mi xa naahuex que mi jach culanuc ja sc'ac'uil ja jijleltic ba? Ja jas huanex sc'ulajeli, atel nia, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ti yala ja Jesusi: ―Entonces mi ni huaxa q'uelahuex ja yabal ja Diosi. ¿Mi ma xa naahuex ja jas sc'ulan ja rey David cuando och huain xyabi soc ja smoj jumasa? ");
INSERT INTO tojNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ja yeni, cuando och ja ba templo it c'ulubal soc c'uutzi, sloo ni ja pan ti jian ec' ja ba sti sat ja Diosi. Jach ni ja smoj jumasa, cho yaa yile, iday, ja pan jahui mi sbejuc oj sloo ja rey Davidi soc mi ni ja smoj jumasa. Quechan huax bob sloo ja pagre jumasa. Iday, jaxa rey Davidi mi malouc ilji yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja queni coelon jan ja ba satq'uinali. Quena ni oj cal jasunc'a lec sc'ulajel ja ba c'ac'u jijleli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Otro vuelta ja sc'ac'uil ja sijlele ja judio jumasa, ja Jesusi ti och ja ba yiglesiaei. Ti och see yi ja cristiano. Huaj to yile, tey jun huinica. Ja stojol sc'abi lom xta ti jiman ec'a. Mi xa ni modo huax bob ya q'ueuca. ");
INSERT INTO tojNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pero como ja' ni ja sc'ac'uil ja jijleli, ja matic huas sea ja smandar ja Moisesi quechan ta huas stz'elsatine ba oj yile ta oj ya tojbuc ja huinic jahui. Ta jach c'a huas sc'ulan, oj ni stae yi ja smula. ");
INSERT INTO tojNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ja Jesusi huas snaa jastal ay ja sc'ujol ja yenlei. Ti yal yab ja huinic jau ja ma' jiman xa ni ec' ja sc'abi: ―Q'uean, ti la jac ja ba jnalanticoni, xyutaj. Jaxa yeni ti q'ue tec'ana. ");
INSERT INTO tojNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jaxa Jesusi ti yiaj yabalea: ―Huax c'ana job ahuilex. Judiootic ja quentiqui. Jaxa sc'ac'uil ja jijleltiqui, ¿sbej ama oj c'ultic ja ba lequi ma ja' sbej oj c'ultic ja malo? ¿Lec ama oj coltatic ja cristiano ma oj ch'aytic snaajele? ");
INSERT INTO tojNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ti och sq'ueltalauc spetzanil ja janec' joyan ec' ja cristiano. Ti yal yab ja huiniqui: ―A q'ueuc ja hua c'abi, xyutaj. Jaxa huiniqui ti ya q'ueuc ja sc'aba. Huego huego staa slugar ja jastal ay ja otro jun sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jaxa fariseo jumasa soc ja matic huas sea ja smandar ja Moisesi xuaatzhuoni xta huaj ja scorajei. Ti yiaj yabal sbaje jas lec oj sc'uluque yi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ja c'ac'u jumasa jahui ja Jesusi ti huaj ba jun huitz. Huaj sc'umuc ja Diosi. Snajtil ja acual huan sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cuando el ja c'ac'u ti spaya jan ja snebuman jumasa. Ti tzaajiye lajchahuane ja yenlei, jaxa lajchahuane jahui ochye jecabanumil. ");
INSERT INTO tojNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Stzaa ja Simoni, ti slea yi otro sbiila. Yaa yi Pedroil. Cho tzaaji ja yijtz'in Andresi, soc ja Jacobo, soc ja Juani, soc ja Felipe, soc ja Bartolomé, ");
INSERT INTO tojNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Soc ja Mateo, soc ja Tomasi, soc ja Jacobo ja yunin ja Alfeo. Cho stzaa ja Simón ja ma' huax alji sbaj Zelote, ");
INSERT INTO tojNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jach ni ja Judas, yermano sbaje soc ja Jacobo, soc ja Judas Iscariote, ja' ni ja ma' yiaj spatic ja Jesús ja mas tzaani. ");
INSERT INTO tojNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ja Jesusi ti xa coye jan soc ja snebuman jumasa. Yajni elye jul ja ba yoj jobi, ti tejc'aji t'usana. Ti smoj ja snebuman jumasa soc jun nole cristiano ja sbaj sutanal ja Judea. Soc ay ni ja ba Jerusaleni soc jach ni ja ma' tey ba sti ja' ja ba Tiro soc ja ba Sidoni. Jacye ba oj smaclaye ja yabal ja Diosi soc ba oj cho aaji tojbuc ja xchamelei. ");
INSERT INTO tojNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jaxa matic huan ixtalajel yuj ja pucuj jumasa, ja yenlei ch'ac tojbuque. ");
INSERT INTO tojNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Spetzanil ja cristiano huas sc'ulane fuerza ba oj syame porque huas snaahue que jel ja yipi. Oj ni bi tojbuquea, siquiera huas syamahuei. Y meran nia, spetzanile ch'ac ni tojbuquea. ");
INSERT INTO tojNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ja Jesusi ti stojtoq'uela lec ja snebuman jumasa ti yal yabyea: ―Ja huenlex ja janec' huaxa naahuex jel ajul abajex ja ba sti sat ja Diosi, ¡jel lec huaxa huilahuex! Ti xa ni ayex ja ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ja huenlex ja janec' jex c'anc'oni toj oj ajyaniqui, jel lec huaxa huilex. Oj ni coltajananic yuj ja Diosa. Jel lec oj ec' ahuujilex ja huenlex ja huanex oq'uel ja huego, jaxa mas tzaani, jel gusto oj ajyanic. ");
INSERT INTO tojNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jel lec oj ec' ahuujilex ta coraja xta huax yilahuex ja cristiano jumasa, mi c'ax bob smojuquexi, quechan c'a sloile ja' huax yutajex eq'ue. Ta mix bob abjuc ja hua biilexi, ta ja c'a ja hua mulex yuj ja huaxa c'uanonexi yuj ja ti ni coelon jan ja ba satq'uinali, ");
INSERT INTO tojNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Cuando jach huan c'ulajel ahuilexi, mas to ajyanic gusto. Chaananic yuj ja hua gustoexi. A jac ac'ujolex ja hua majtanex nolobal ahuilex ja ba satq'uinali, jel nihuan juntiro. Ja jastal oj yixtalauquex ja huenlexi, jach ni ixtalajiye ja aluman‑Dios jumasa ja najatei. ");
INSERT INTO tojNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pobre ja huenlex ja matic rico ayex huaxa huabyexi. ¡Jel ajul abajex juntiro! Ja jastal ayexi, jacha ni oj ajyanica. ");
INSERT INTO tojNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Jaxa huenlex ja janec' mi jas huas sc'ulan ahuilex palta, ¡jel ajul abajex! Oj ni c'otuc ja c'ac'u cuando mi jas oja taexi. Jaxa huenlex ja ma' ja huan xta xa jautz'un abajex tzee ja huegoi, jaxa mas tzaani ti oja huilex ta mi oj meba oc'anic leca. Oj ni oc' xchabil ja hua satexa. ");
INSERT INTO tojNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Jel ajul abaj ja huenlexi ta jel c'a huas stoyohuex ja cristiano! Eso sí, jach ni toyjiye ja ma' huas stoyo sbaj ja najate que aluman‑Dios bi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero ja huenlexi ja janec' huaxa huabyex slugaril ja jas huax cala, yaj xa huab ja hua condraexi. C'ulanic yi lec ja ma' coraja huax yilahuexi. Huax cala huabyex, pero meran. ");
INSERT INTO tojNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","C'anahuic yi ja Diosi que oj sc'ul bendiciar ja hua condraexi. C'umanic ja Dios sbaj ja ma' miicben sbej ja jas huax yala bajexi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ta ay c'a ma' huax yaa hui vuelta ba hua choji, cho sutu yi ja jun lado. Ta ay c'a ma' huas sapa hui ja hua c'ui, cho aa yi ja hua camisola. ");
INSERT INTO tojNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chican ma' ay jas huas sc'ana hui, aa yi. Ta ay c'a ma' huas sbajan ja hua jas abaji, mi lom xa c'ana yi ba oj ya paxuc ahui. ");
INSERT INTO tojNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ja jastal huaxa c'anahuex lec oj sc'uluc ahuilex ja cristiano, jach c'ulanic yi ja huenlex chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ta quechan c'a yaj huaxa huabyex ja ma' yaj huax yabyexi, pues ja jahui lom ni altiroa. Como jach ni ja mulanumi, yaj ni huax yab ja ma' yaj huax abji yuji. ");
INSERT INTO tojNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Quechan c'a huaxa c'ulanex yi lec ja ma' lec huas sc'ulan ahuilexi, mi ni ay sbeja. Jach ni ja mulanum jumasa tac. Jach ni huax cho sc'ulan sbajea. ");
INSERT INTO tojNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ta ay c'a jas ahuioj, oj jac majuc ahui, oja huaa yi yuj ja huaxa naa que oj c'otuc ja c'ac'u ay jas oj yaa hui ja yeni, ja jahui mi jas yioj. Como jach ni ja mulanum jumasa chomajquili. Huas smaja sbaje soc ja smoj mulanumili. ");
INSERT INTO tojNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero ja huenlexi yaj xa huabyex ja ma' condra huax yilahuexi. C'ulanic yi lec. Aahuic yi majan, mi jauc ja q'uelan asatex que ay jas oj yaa huilex ja huenlexi. Ta jach c'a huaxa c'ulanex, jel nihuan juntiro ja hua majtanex oj yaa huilex ja Diosi. Oj iljuc que yuninex ja Dios jel nihuani. Como jach ni ja yeni, jel yaj huax yab ja ma' mi ni stz'acatal huas sc'anahuei soc ja ma' jel timasani. ");
INSERT INTO tojNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Talnayic syaujulal ja yenle ja ma' jel ajul ja sbajei ja jastal ni ja hua Tatex jel huas stalna ja hua yaujulalex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi lom xa huaa huochel ja otro cristiano. Ta mi c'a huaxa huaa huochel ja huen, jach ni ja huen, mi oj aajan ochelal. Mi lom xa tzujba ja hua moji. Mi c'a huaxa tzujba ja hua moji, jach ni ja hueni, mi oj cho tzujbajanan. C'ulanic perdonar. Huan c'a xa c'ulanex perdonar ja hua mojexi, jach ni ja hueni, oj c'ulajanan perdonar. ");
INSERT INTO tojNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ay c'a jas ahuiojex, aahuic yi ja hua mojexi. Oj ni cho aajuc ahuilex mas ja huenlexa. Ja jastal huaxa huaa yi ja hua mojexi, jach ni oj cho ya cumxuc ahuilexa. Ja sbisol oj aajuc ahuilexi, tzaubal ni ja bis jahua. Mi jaxanuc oj aajuc ahuilex. T'enubal lec soc huosan lec. ");
INSERT INTO tojNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ja Jesusi ti cho yala otro jun loila: ―Ay jitzan maestro lajan soc ja ma' tupel ja satei. Ilahuil ja ma' tupel ja sati. Mi ni modo oj bob see yi ja sbej ja smoj tupel satili. Ti c'a huane bejyel ba yoj huitzi, ta ay c'a jun q'ueen, ti oj moc'uque lajan ba yoj q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Q'uelahuil jun cristiano huan jeejel yi yuj ja smaestro. Cuando huan tox och jeejuc yi, mas jel huas snaa juntiro ja smaestro. Pero cuando huax ch'ac sneb spetzanil ja jas oj jeejuc yii, entonces ja ma' sea, ja' ni oj iijuc ja smodo, sea lec ma sea malo. ");
INSERT INTO tojNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Jas lom huaxa q'uela ja stz'iilelal ja sat ja hua huermano pero mas to jel nihuan tey ba hua baj ja hueni, iday, mi ni huaxa huaa yi casoa? ");
INSERT INTO tojNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Majla quijtz'in, la chi. Oj ca eluc ahui ja stz'iilelal ja hua sati, pero hua baj ja hueni, ¡mi ni icben sbej jastal aya! ¡Jastal modo oja hual yab jachuc ja hua huermano! ¡Toj chab cara aya! A el bajtan ja jas ay tey ba yoj ja hua sati. Jachuc, ti oj bob ahuil q'uinal oj hua el yi ja stz'iilelal ja sat ja hua huermano, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jun sate' ba jel piero, mi oja hual que lec ja steili. Jaxa jun sate' ba tzamal, mi oja hual que ti jac ba jun mal te'. ");
INSERT INTO tojNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yuj ja sat ja tei, ti huax naaxi jas tiq'ue teila. Q'uelahuil ja q'uehuexi. Mi ni modo oja hual que steil q'uiix. Soc mi ni oja tul pelul ja ba steil jun morax. ");
INSERT INTO tojNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jayuj jachuc ja cristiano. Ja ma' toj ayi, yuj ni toj ay ja ba sc'ujola. Jaxa cristiano ja ma' toj malo, yuj ni jach ay ja ba sc'ujola. Ja jas ay ja ba sc'ujoli, jach ni huax el ja ba stia. ");
INSERT INTO tojNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Eso sí, ja huenlexi huaxa hualahuex ja huajualonex pero lom nia. Mi ni huaxa c'ulanex ja jas huax calai, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Spetzanil ja ma' huax jac smacla ja jas huax cala, huan ni sc'uanea, oj cala huabyex machunc'a oj slaji. ");
INSERT INTO tojNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lajan soc jun huinic ja ma' huas sc'ulan ja snaji. Tz'unan lec huax yaa cani. Jel tzatz huax cani. Jaxa mas tzaani jac ja butjai. Spuctzin sbaj ja ba sat ja naitz jahui, pero mi ni huax nijquia yuj ja tz'unan ni lec ja syojyali. ");
INSERT INTO tojNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jaxa ma' huas smacla ja jas huax cala pero lom nia, mi ni huas sc'uana, ja yeni lajan soc ja ma' huas sc'ulan ja snaji pero huan ita xyaa cajan ja ba sat luumi. Mi huas stz'apa lec ja yipi. Yajni jac ja butjai, huas spuctzin sbaj ja ba sat ja naitz jahui. Soc ja jahui, uchpiji ja naitzi. Ti huaj cayan ja ba sat ja jai, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jaxa Jesusi cuando ch'ac yal yab ja cristiano ja jastal jahui, ti xa huaj ja ba Capernaum. ");
INSERT INTO tojNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Jaxa tihui tey jun scapitan ja soldado jumasa. Ja yeni ay jun smozo jel yajtanubal yuj, jaxa mozo jahui, jel xa yioj. Lajan soc oj xa chamuc. ");
INSERT INTO tojNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ja capitani cuando yab yabalil ja jas huan sc'ulajel ec' ja Jesusi, ti seca chaboxe judio jumasa, ja ma' banquilal yujilei. Huajye ba oj sc'an yi stz'acatal ta ay modo oj jacuc ba oj ya tojbuc ja smozo. ");
INSERT INTO tojNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jaxa banquilal jumasa jahui ti huajye ja bay ja Jesusi. Ti och sc'ane yi pavor leca: ―¿Mi ma oja talna syaujulal ba? Pero ¡lequil cristiano tac! ");
INSERT INTO tojNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eso sí, ja yeni tuc raza nia pero huan ni sc'anahuotica. Yuj ja yeni, ya c'ulajuc ja iglesia ja ba jchonabilticoni, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jaxa Jesusi ti huaj soc ja yenlei. Cuando mojan xa yioje ja snaj ja capitani, jaxa capitani ti seca chaboxe yamigoa ba oj yal yab ja Jesusi: ―Cajual, mi xa bi t'ilanuc oj huajan och masan. Jel bi oj q'uixhuuc ahuuj ");
INSERT INTO tojNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jayuj mi ni huax jac staaa. Malan bi soc oja hual que oj tojbuc ja smozo, soc ja jahui, oj ni bi tojbuca. ");
INSERT INTO tojNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porque q'uelahuile, ja yeni mandar bi ay, iday, huax cho sc'ulan mandar ja soldado jumasa. Ta huan c'a bix yal yab ja jun iti, caax, ta huax yutaj, oj bi huajuc. Soc ta huan c'a bi spaya jan ja otro juni, la, ta huax yutaj, huan ni bix jaca. Jaxa smozo, c'ulan ja iti, ta huan c'a bix yutaj, huan ni bi sc'ulana, ¡jauc to ma bi ja hueni mi oj ni bob ac'uluc ja jas huaxa c'ana oja c'uluqui! ");
INSERT INTO tojNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ja ch'ac yab ja jastal it ja Jesusi, juntiro och ja spensari. Ti sutu sbaja. Yal yab ja cristiano ja matic smoji: ―Meran huax cala huabyex, mi ni june ja israeleño jumasa quila huas sc'uan ja jastal ja huinic iti, iday, ja yeni tzeil cristiano ni juntiroa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jaxa jecabanum jahui, huaj to c'otuque ja ba snaj ja capitani, lec xa ni c'ot stae ja mozo jahua. ");
INSERT INTO tojNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ja mas tzaani ja Jesusi ti huaj ja ba jun chonab sbiil Naín. Ti smoj ja snebumani soc jun nole cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Oj xa stae altiro ja spuertail ja chonabi, huaj to yile, ti q'uechubal jan jun chamhuinic. Viguda ay ja snani, jaxa viguda jahui quechan altiro yal yioj ajyi ja iti, iday chami. Soc jel jitzan ja cristiano suinquil ja chonab jahui ti smojonej ja viguda jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cuando yila ja Cajualtiqui, ti stalna syaujulal ja nanal jahui. Ti yal yaba: ―Mi la oq'ui, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ti och c'ubana. Ti syama ja scajonil ja chamhuiniqui, jaxa matic q'uechan yuji ti c'otye tec'ana. Ti yala ja Jesusi: ―Hijo, c'uan ja jas huax cala huabi, q'uean xa, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jaxa yen ja ma' cham ta ajyi, ti q'ue culana. Ti och c'umanuca. Jaxa Jesusi ti yal yab ja snani: ―Ja huego ti xa ay ja hua huali, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Spetzanile och xihuele. Och yae yi stz'acatal ja Diosi: ―Ja aluman‑Dios iti jel nihuan juntiro. Sea ta ni sbaj quitica. Dios ni jac ta scoltayotica porque sbajotic nia, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ja yabalil ja Jesusi juntiro pucxi ec' ja ba spetzanil ja Judea soc ja ba sutanal ja lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jaxa snebuman jumasa ja Juani ti huaj yale yab ja Juani spetzanil ja jas ajc'ach huan sc'ulajel ec' ja Jesusi. Jaxa Juani ti spaya jan chabe ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ti yala que oj huaj sobe yi ta yena ni ja ma' secunej jan ja Diosi ma ay to ma' otro oj to majlaticon: ―Jach oja hualex yabi, xchi ja Juani. Jaxa snebuman ja Juani ti huajye ja bay ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Cuando c'otye ja huinique jumasa jahui, ti yalahuea: ―Ja yen ja Juan ja ma' huax yaa bautismo, yen secahuoticon. Oj bi jobticon ahui ta huena ni ja ma' secunej ja Diosi ma t'ilan oj to jmajlaticon, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iday, ti to tec'an ec' ja yenlei, huaj to yile, ja Jesusi ya tojbuc jitzan ja ma' mi lec ayuqui soc ja ma' ixtalanubal yuj ja pucuji. Jitzan ja ma' tupel ja sati ch'ac ya yil q'uinal ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ja Jesusi ti xa yalaa: ―Caaxic, cax alahuic yab ja Juani ja jastal ahuilahuexi soc jastal ahuabyexi. Ja ma' tupel ja sati huan xax yila q'uinal, jaxa ma' renco ayi, toj xa huax bejyiye, jaxa ma' huan c'ael ja sbacteli, naca lec xa aye. Jachuc ja ma' mix yab q'uinali, huan xax yabye, soc ja ma' cham ta ajyi, ch'ac ni sac‑huuquea. Ja ma' mi jas yioji huan aljel yabye ja abal it jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jel lec oj ec' yujil ja ma' mix ec' sc'ujol ta mi quenuc ni ja jecubalon yuj ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yajni huaj ja chahuane secabanum ja Juani, jaxa Jesusi ti och sta ti' ja Juani, como ti to ni canye jun nole ja cristiano: ―Jaxa cuando huajyex ja ba ch'ayan lugari, ¿jasunc'a huaj ahuilexi? ¿Yuj ama huaj ahuilex jun huinic lajan soc ja aj huan cumtz'ijel yuj ja iq'ui? ");
INSERT INTO tojNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Entonces ¿jasunc'a ja huilahuexi? ¿Yuj ama huaj ahuilex jun huinic ba jel tzamal juntiro ja sc'ui? Jach c'a, yuj ti huajyex ja ba snaj ja reyi porque ja tihui, ti ni aye ja ma' jel tzamal ja sc'uei. ");
INSERT INTO tojNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Jastal lec huajyex ja ba ch'ayan lugar jahui? ¿Yuj ama huaj ahuilex junuc ja yaluman‑Diosi? Meran nia, ja Juani aluman‑Dios nia. Pero mi quechanuca. Ay otro atel sc'ulan. ");
INSERT INTO tojNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ja huinic jahui, yena ni ja ma' taubal ti' ja ba slibro ja Diosi. Yala que oj jecjuc ba oj sloilta ec' ja cabali. Ja yeni bajtan bi oj ya q'ueuc ja ateli, ti xa oj q'ue atul ja hua huatel ja hueni, jach ni xchi tac. Yuj ja jas huas sea ja yeni jayuj puesto oj ajyuc ja cristiano ba oj sc'uuc ja jas oja loilta ja hueni, xchi ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mi ni june ma' ac'ubal yi yatel como jastal ajyi yi ja aluman‑Dios Juani. Jel nihuan ja yateli pero iday, ay to mas jel nihuan que yuj ja yatel ac'ubal yi. Q'uelahuile ja jastal ja smandar ja Diosi. Huas staa jun cristiano ba jel ch'in juntiro huax ilji, ti huax yila jastal yuntiquil. ¡Pero mas to jel nihuan juntiro ja jas huas sc'ulan ja Dios tac! ");
INSERT INTO tojNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jitzan lec ja cristiano, hasta ja ma' huas stzomohue ja taq'uini, ja cuando ch'ac yabye ja jas yala ja Jesusi, ti jac sc'ujole que jel ni tzamal ja jas huas sc'ulan ja Diosi, como aaji ni yie ja' yuj ja Juana. ");
INSERT INTO tojNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jaxa fariseo jumasa soc ja ma' huas seahue ja smandar ja Moisesi, eso sí, ja Diosi huas sc'ana oj scolta ajyi pero mi ni modo sc'anahuea. Mi ni jotye ba oj bob aajuc yile ja' yuj ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ti yala ja Jesusi: ―Oj cala huabyex machunc'a oj slaj ja cristiano ja tiempo iti. ");
INSERT INTO tojNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lajane soc chab c'ole yal untic huax yiaj sbaje tajnel ja ba nalan patio. Yen ta huax yautalaan sbaje: Ja hualahuex oj c'ultic q'uin. Ja quenticoni juuticon ta ja ajmayi, jaxa huenlexi mi ni huala chaaniyexa. Cham ja yal cali, xchi june ja yenlei. Ja quenticoni huanoticon oq'uel, jaxa huenlexi, mi ni modo la ocyexa. ¿Jasyuj jach huaxa c'ulanex ba? Jach huax yala sbaje ja yal untiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ja cristiano, ja' ni smoj ja yal untic jahui porque ja jastal ja smodo ja Juani, jel huas scomo ja suaeli soc mix yuaj ja yaalel tz'usubi, jaxa huenlexi huaxa hualahuex que pucuj. ");
INSERT INTO tojNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jaxa queni ti ni coelon jan ja ba satq'uinali, iday, huala huaayon. Huax cuaj ja yaalel tz'usubi y huaxa huutajonex chitamil. Huax hua ochconex yacbumil. Huaxa hualahuex que ja' jmoj ja ma' huas syama lom ja taq'uini, ja' jmoj ja mulanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ja ma' huax yaa sbaj soc ja Diosi, ja yenlei mi jauc huas sc'ulan pensar ja jastal huaxa c'ulan pensar ja huenlexi. Gusto ni huax yilahue ja jas huan sc'ulajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","June ja fariseo ti sloco huael ja Jesusi. Ja och c'ot ja ba snaj ja fariseo, ti aaji yi ja suaeli. Ti och huauca. ");
INSERT INTO tojNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Huaj to yile, ti jac jun ixuc suinquil ja chonab jahui. Jaxa ixuqui jel juntiro huas staa smul soc ja huiniqui. Como yab yabalil que ti locobal huael ja Jesús ja ba snaj ja fariseo jahui, ti yiaj jan jun perpume, jaxa yetal ja perpume jahui, c'ulubal soc jun ton alabastro sbiil. ");
INSERT INTO tojNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ja ixuc jahui ti och ba stz'eel ja Jesusi ja ba lado xijan ja yoqui. Ti och oc'uca. Ti co ja yaalel sat ja ba yoc ja Jesusi. Ti och scus soc ja s'olomi. Ti och yujtz'uc ja yoqui. Saxa can yi ja perpume ja ba yoc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ja fariseo ja ma' sloconej huael ja Jesusi, cuando yila jastal iti, ti och tz'iptz'unuc ja sc'ujoli: ―Ja iti, ta meran c'a aluman‑Diosi, oj jac sc'ujol ma' huan syamjel ja yoqui. Oj snaa jas tiq'ueil ja ixuc iti. ¡Xihuel ja sbaj ja smul tac! Jach huan c'umal ja sc'ujol ja fariseo. ");
INSERT INTO tojNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","―Simón, ay jas oj cala huabi, xchi ja Jesusi. ―Pues ala cab ba, Maestro, xchi ja Simoni. ");
INSERT INTO tojNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","―Ay jun huinic yaa yi majan taq'uin chahuane huinique. Ja juni yaa yi jel quinientos pesos, jaxa otro juni, cincuenta pesos. ");
INSERT INTO tojNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero ja yenlei mi jas yioje ba oj stupe, jayuj c'ulajiye perdonar xchahuanile. Ala cab ba, ja chahuane huinique jahui, ¿machunc'a mas yaj yab ja ma' yaa jel ja taq'uini? ");
INSERT INTO tojNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ti yala ja Simoni: ―Ja quen lajan soc ja' huax cab ja ma' mas jitzan ja sel ch'ayji yii, xchi. ―Pues ja' nia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ti sutu sbaj ja ba lado bay ja ixuqui. Ti yal yab ja Simoni: ―Q'uelahuil ja ixuc iti. Ja huen, ochyon ja ba hua naji, iday, mi ahuaa qui ja' ja sbaj coqui. Pero ja yeni ja' spec'a ja yaalel sati ja sac'a qui ja coqui. Ja' soc ja s'olomi scusu qui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ja hueni mi ni ahuaa qui Dios ja ochyon juli, mi ni ahuujtz'an qui ja jc'abi pero ja yeni quechan pavor och jule, mix yaa can yujtz'ajel ja coqui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mi ajaxa yi aceite ja j'olomi pero ja yeni jac sax qui perpume ja ba coqui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jayuj huax cala huabi, ja ixuc iti jel huas syajtayon juntiro porque ja smul jel jitzani, c'ulaji ta perdonar. Pero ja ma' quechan t'usan ja smul huax c'ulaji perdonari, jach ni, quechan t'usan huax yajtani. ");
INSERT INTO tojNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ja Jesusi ti yal yab ja ixuqui: ―Ja hua muli tupel xa nia, x'utji ja ixuc jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jaxa matic lajan huane huaeli ti och yal sbaje yenle itaa: ―¡Janec' to ni ja it ja huax yala huas sc'ulan perdonar ja mulali! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero ja Jesusi ti yal yab ja ixuc jahui: ―Yuj ja hua c'uani, jayuj coltajiya. Ja yaani cax gusto, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jaxa mas tzaan t'usani, ja Jesusi ti xa huaja. Huaj sloilta ec' ja yabal ja Diosi. Huan yaljel ec' ja jastal huas sc'ulan mandar ja Diosi. Ti huaj ba jitzan ja chonabi soc ja yal hacienda jumasa. Ja lajchahuane snebumani ja' ni smoj ec'a. ");
INSERT INTO tojNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Soc tey chaboxe ixuquea. Ja ixuque jahui c'ulajiye ta librar soc ja pucuji soc aaji tojbuque ja xchamelei. June ja yenlei, ja' ni ja María ja ma' sbiilan magdaleña. Yena ni ja ma' ixtalanubal yuj juque pucuj ajyi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Soc tey ja Juana, ja' statam ja Chuza. Jaxa Chuza, ac'ubal yi jun yatel yuj ja rey Herodesi. Soc tey jun ixuc Susana sbiil soc ay jitzan ixuque huax coltaniye eq'ue. Huane yaajel ja jas yioje t'usani. ");
INSERT INTO tojNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jel aaye elye ja ba xchonabilei soc ja yal yaciendaei ba oj huaj yile ja Jesusi. Cuando ch'ac stzom sbaj jitzan lec ja cristiano, jaxa Jesusi ti och see yile soc puro loil: ");
INSERT INTO tojNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Q'uelahuilex, jun huinic huaj stic inat. Cuando huan sticjel eq'ue, iday, ay ba huax co ba yoj bej, ti huax batji cana. Huax jac ja yalchani, ti huas stulu ela. ");
INSERT INTO tojNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Soc ay ba co yoj ton ba mey lec ja luumi. Yajni el q'uen ja ba sat luumi, huego tacji porque taquin lugar. Mi yaaxuc ja luumi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Soc ay ba co ba yoj q'uiix. Ja inat jahui ti el q'uen lajan soc ja q'uiixi, jaxa mas tzaani, c'utzji sq'uiel ja inati. ");
INSERT INTO tojNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Soc ay ba co ba lequil luumi. Q'uii. Ajyi sat. Ay ba yaa cien ja sati. Yajni ch'ac yal ja jastal iti, ti c'umani tzatz leca: ―Ja ma' ay xchiquini, a yabi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ti och sob ja snebuman jumasa: ―¿Jas bej ja loil it ahuala cabticoni? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ti yala ja Jesusi: ―Meran nia, soc ni loil huax jea yi ja cristiano. Eso sí, ja yenlei ay sate pero mix yilahue q'uinal. Ay xchiquine pero mix yabye q'uinal. Ja jastal huas sc'ulan mandar ja Diosi mi mero huax abxi claro pero ja huenlexi, sbej ni oja huabyex claroa. ");
INSERT INTO tojNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Oj cala huabyex jas sbej ja loil iti. Ja inat jahui, ja' ni smoj ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ja inat jau co ba yoj beji lajan soc ja ma' huax yab ja yabal ja Diosi pero huax jac ja diablo. Huax aaji ch'ay sc'ujole ja jas yabyei ba mi oj sc'uuque soc mi ni oj cho coltajuquea. ");
INSERT INTO tojNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jaxa inat jau co ba yoj toni lajan soc ja ma' jel gusto huax yab ja yabal ja Diosi. Huego huax yala oj sc'uuque pero lom. Mi ni ay yipea. Huas sc'uane chaboxe tiempo pero cuando huax jac jun suocole, ti huax ch'ay ja sc'ujole ja jas huas sc'uanei. ");
INSERT INTO tojNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jaxa inat jau co ba yoj q'uiixi lajan soc ja matic huax yabi, ti huax huaja. Jel ja yateli. Ja' huajel sc'ujol ba oj stul sbajei. Quechan huane sc'ulajel pensar ba jel gusto oj ajyuque, jaxa yabal ja Diosi huax yaahue can jun lado. Mi ni t'un huax bob yujilea. ");
INSERT INTO tojNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero ja inat jau co ba lequil luumi lajan soc ja ma' huas sc'uan soc spetzanil ja sc'ujoli. Tola vida puesto aye. Huas sc'uane ja jas huax alji yabyei. Jun xta aye tola vida. Meran huax ilxi que tucbi ja smodoea. ");
INSERT INTO tojNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ja Jesusi ti cho och yal otro vuelta jun loil: ―Ja jas huax jea lajan soc jastal jun candela. Mi ni jun ma' oj ya ajluc jun candela ba quechan oj snuj soc jun cajón. Mi ni oj yaa ba yib ch'at. Ti oj ya ochuc ba jun candelerio, jaxa ma' huax och ja tihui, oj ni bob yil q'uinala. ");
INSERT INTO tojNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porque mi ni modo oj can musan ja jas huax jea. Sbaj ni t'ilan oj chicnajuca. Eso sí, ja huego nac'an musan to t'usan, pero oj ni abxuc sbeja. Claro lec oj abxuc. ");
INSERT INTO tojNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Aa cuidadoex ja jas huax cala huabyexi. Ja ma' huas sc'uan ja cabali, oj ni ca snaa masa. Pero ja ma' mi huas sc'uan ja cabali, ja janec' t'usan huas snaa, oj ni ch'ay sc'ujola, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ti jac ja snan ja Jesusi soc ja yermano jumasa. Pero mi bob ochuque yuj ja jel but'el ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ti alji yab ja Jesusi: ―Ja hua nani soc ja hua huermano jumasa ti aye ba fuera. Huas sc'ana oj sc'umuca, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jaxa yeni ti yalaa: ―Ja jnani soc ja quermano jumasa ja' ni ja ma' huax yab ja yabal ja Diosi soc ja ma' huas sc'uanei, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ja Jesusi jun c'ac'u ti q'ue ba jun barcoa. Ti smoj ja snebuman jumasa. ―La xa huajtic ja ba otro lado ja jai, xchi. ―Lec, xchiye. Ti huajyea. ");
INSERT INTO tojNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cuando ti xa huan bejyel ja barco ja ba yoj jai, jaxa Jesusi ti och suayela. Ti jac jun tzatzal ic' ja ba yojol ja jai. But' ja' ja yoj sbarcoei. Lajan soc oj xa ibjaaxuc ja barco. ");
INSERT INTO tojNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jaxa snebuman jumasa ti huaj syujquese ja Jesusi: ―Maestro, Maestro, xyutaje. Ja huego huantic xa huajel ja'. Ti xa q'ue ja Jesusi. Scomo ja ic' jahui. Ya lamxuc ja yip ja jai. Lamxi juntiro. Xch'ababi xta huaji. ");
INSERT INTO tojNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ti yala ja Jesusi: ―¿Baya huaxa c'uanex ba? xchi. Porque huane xta q'uitc'onuc yuj ja xihueli. Juntiro ch'ac och spensare. Ti yala sbaj yenle itaa: ―¿Jas huiniquil ja yen ba? Hasta ja iq'ui soc ja jai huas sc'ulan mandar, ¡pero huax c'uaji yi tac! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ti c'otye ja ba slugar ja gadareño jumasa ja ba mero spunto ja Galilea. ");
INSERT INTO tojNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ja Jesusi cuando el c'ot ja ba sti ja jai, ti jac tajuc yuj jun huinic suinquil ja chonabi. Ay xa jitzan tiempo ixtalanubal yuj ja pucuji. Mi xa huan to slapa ja sc'u soc mi xa teyuc ba snaj pero ti xa ni culan ba campo santoa. ");
INSERT INTO tojNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Culan xa yuj ja pucuji jun ta repente huas syama ja huinic jahui, jayuj huax mochji yi soc cadena ja xchanil ja yoc sc'ab ja huiniqui. Pero ja yeni huas sc'utzu ja cadena. Ti huax iiji och fuerza ja ba lugar ch'ayani, pero ja' yujil ja pucuji. Ja huinic jahui cuando yila ja Jesusi, ti sipa sbaj luum ba sti sati. Ja Jesusi ti sc'ulan mandar ja pucuji que oj yacta can ja huinic jahui. Jaxa pucuji ti q'ue ahuanuc tzatz leca: ―¿Jastal aya jmoc ja huen ba Jesús? Ja hueni yunina ni ja Dios jel nihuani. Huax c'ana hui tz'acatal mi lom xa huixtalaanon, xchi ja pucuji pero ti ni ba sti ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","―¿Jas abiil ja hueni? xchi ja Jesusi. ―Como jel ni ayoticon ja quenticona, xchi ja pucuji. Como meran nia. Jel ni aayea huax yixtalaane ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ti och c'anjuc yi pavor ja Jesusi que mi bi oj jecjuque ja ba yoj q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ja ba lugar jahui tey jun trozo chitama. Ti huane huael ja ba jun huitz mojani. Jaxa pucuj jumasa ti sc'anahue yi pavor ja Jesusi ba oj jecjuque soc ja chitam jumasa jahui siquiera ba oj ochuque ja ba scuerpoei. ―Pues lec, caaxic, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jaxa pucuj jumasa it yaahue can ja huinic jahui. Ti huajye soc ja chitam jumasa, jaxa jun trozo chitam jahui ti sipa sbaje co ja ba snexanal ja huitzi. Ti baltzujiye co man ba yoj ja'. Ti ch'ac siq'ue jaa. ");
INSERT INTO tojNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jaxa matic huan stalnajel ja chitam jumasa, yajni yilahue jastal ch'ac huajuqui, ti spacahue ajnela. Ti huaj yae razón ja ba yoj chonabi soc ja ba sti chonabi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jaxa cristiano jumasa lom xta xnololji ch'ac huaj yile. Ti huajye ja bay ja Jesusi. Ti staahue ja huinic it ma' aaji ta can yuj ja pucuj jumasa. Ti culan ec' ba stz'eel ja Jesusi. Ay xa sc'u soc toj xa ay ja spensari. Jel xiuye juntiro ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jaxa matic ch'ac yil jastal tojbi ja huiniqui ti och yale jastal c'ulaji librar ja ma' ixtalanubal yuj ja pucuj ajyi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pero ja cristiano ja ba sutanal ja slugar ja gadareño jumasa ti och sc'an yi stz'acatal ja Jesusi que oj bi yacta can ja slugarei. Jel bi huax xiuye juntiro, jayuj ja Jesusi ti cho q'ue ja ba barco. Ti cumxia. ");
INSERT INTO tojNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pero cuando mi tox huaj ja Jesusi, jaxa huinic jau ja ma' ixtalanubal ajyi yuj ja pucuji, ti och sc'an yi jitzan stz'acatal ta ay modo oj huaj soc. Pero ja Jesusi ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Miyuc. Cax ja ba hua naji. Loilta ec' ja jas jel tzamal sc'ulan ahui ja Diosi, x'utji ja huiniqui. Ti huaj ja huiniqui. Ch'ac sloilta ec' ja ba spetzanil ja chonabi ja jastal jel tzamal c'ulaji yi yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yajni cho cumxi jan ja Jesusi, ti xa huan majlajel yuj jun nole cristiano. Mix yilahue ora oj c'otuc. ");
INSERT INTO tojNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Huaj to yile, ti jac jun huinic sbiil Jairo. Ti huaj tajuc yi sc'aba. Ja yeni ay yatel ja ba yiglesia ja judio jumasa. Ti och sc'an yi pavora ta mey modo oj huajuc ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Porque ay bi jun aq'uix yunin. Quechan bi altiro yena. Ay xa bi yioj mojan lajchahue jabil, iday, jaxa aq'uix jahui, huan xa chamel. Jaxa Jesusi ti yala que oj huaj yila. Cuando ti xa huajumi, jaxa cristiano jumasa ti smoji. Huan xta sbatalaan sbaje. ");
INSERT INTO tojNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jaxa ba yojol ja cristiano jahui, tey jun ixuca. Jaxa ixuc jahui ay xa lajchahue jabil mix ec' ja scuenta. Ch'ac ta xch'ac el ja janec' yioji pero mi ni june ja doctor huas snaa jastal oj ya tojbuc ja ixuc jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jaxa huego tey soc ja cristiano jumasa, ja ma' ti nochan ba spatic ja Jesusi. Ti och c'ubana. Huaj syam yi ja snich ja sc'ui, iday, jaxa scuenta, huego huego c'ot tec'an. ");
INSERT INTO tojNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jaxa Jesusi ti yalaa: ―¿Machunc'a syamahuoni? xchi. ―Pero mi ni mach'a tac, xchiye spetzanile. Ti yala ja Pedro soc ja smoj jumasa: ―Como ti ni aya ba yoj cristiano tac, Maestro, jayuj huas slatzahua. Huas st'enahua iday, jaxa hueni huana sobjel machunc'a syamahuoni, la chi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","―Pero meran, ay ma' syamahuon porque yab jchiq'uel que ay ma' tojbi cuj porque c'ot man ba jcuerpo, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jaxa ixuc jahui yajni yab ja jas yala ja Jesusi, ti jac ja ba stz'eeli. Huan q'uitc'onel. Ti co mec'an ja ba sti sat ja Jesusi. Ti yala satalajel abal jas sbej ja syamai, cho yala jastal huego huego tojbi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ti yala ja Jesusi: ―Hija, yuj ja hua c'uani, tojbiya ta. Ja yaani, cax gusto, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cuando jach to huan yaljel ja Jesusi, huaj to yile, ti jac june ja suinquil ja snaj ja Jairo. Ti alji yabi: ―Q'uelahuil, ja hua huunini cham ta. Moc xa lomuc ahual yab que oj huajuc ja Maestro. ");
INSERT INTO tojNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ja ch'ac yab ja it ja Jesusi, ti yal yab ja Jairo: ―Mix cham ac'ujol, como c'uan. Ja hua huunini oj ni sac‑huuca, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yajni c'otye ja ba snaj ja Jairo, ti yala que quechan oj och soc ja Pedro soc ja Jacobo soc ja Juani soc ja snan stat ja chamhuiniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jaxa mucuanum jumasa huane xta meba oq'uel. Huane xta staajel ti' ja ma' chameli. Pero ja Jesusi ti yalaa: ―Mi lom la ocyex. Ja aq'uix iti mi chameluc, quechan huan huayel, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero ja mucuanum jumasa quechan huas spechtiane. Huan ni snaahue que cham ta nia. ");
INSERT INTO tojNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ja Jesusi ti huaj syam yi ja sc'ab ja aq'uixi. Ti sc'uman tzatz leca: ―Nina, q'uean, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jaxa aq'uixi huego huego sacui. Q'uei. Ti yala ja Jesusa: ―Aahuic xa yi ja suaeli, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jaxa snan stat ja aq'uixi juntiro boboaxiye pero ja Jesusi ti yala que mi ni june ma' oj yale yabye ja jastal sc'ulani. ");
INSERT INTO tojNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ja Jesusi ti seca spayjel ja lajchahuane snebumani. Cuando ti xa tzomanei, ti yalaa: ―Ja yaani huax caa huatelex ba oj hua eluquex ja pucuji, chican jas tiq'ueil soc oj hua tojbuquex ja matic malo ayi, como huan nix caa hui ja hua huipexi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Oj huaj aloiltayex ec' jastal oj ajyuque ja cristiano jumasa cuando huax yaa sbaje ja ba sc'ab ja Diosi. Cax a tojbuquex ja ma' malo ayi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Moc lom jas oja huiex ja ba beji, mi ni hua najbanteexi soc mi ni hua morralexi soc mi ni hua huoot apichiexi soc mi ni hua taq'uinexi, soc moc cho ahuiex otro ac'uex. Quechan oja huiex ja jas lapan ahuujilexi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ja naitz ja ba huala ochyexi, ti la ajiyexa. Ti oj cho elanica. ");
INSERT INTO tojNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pero ta huan c'a la c'otyex ba jun chonab y mi huas sc'ulanex recibir, pues actayic cani. Tzijun can ja spolvoil ja hua huoquexi. A yil can sbaje. ");
INSERT INTO tojNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ja ch'ac yal ja jachuqui, ti huajye ja snebuman jumasa. Chol yiaje ja yal hacienda jumasa. Huane sloiltajel ec' ja abal it jel tzamali. Huax cho yaahue tojbuc ja ma' ay xchameli ja ba spetzanil ja lugar jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ja Herodes ja ma' jel nihuan ja yateli, ti yab yabalil spetzanil ja jas huan sc'ulajel ec' ja Jesusi. Jel boboaxi juntiro ja spensari como ay ma' huax yala que sacui ta Juan it ma' huax yaa bautismo ajyi, ja' ni ja Juan ja it ma' yaa ni miljuqui. ");
INSERT INTO tojNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jaxa tuqui huax yalahue que ja' ni ja aluman‑Dios Elías ba najatei. Soc ay ma' huax yala que ja' ni june ja yaluman‑Dios ba najatei sacui ta bi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ti yala ja Herodesi: ―Ja Juan jahui, eso sí, quen ca c'utzuc el ja snuq'ui, pero ja jastal huax cab jitzan cosa que ay jas huan c'ulajel eq'ue, ¿machunc'a jau ba? xchi. Huas slea modo jastal oj bob yil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cuando cumxiye ja jecabanum jumasa jahui, ti ch'ac xchole ja jastaltic sc'ulanei. Ja Jesusi ti yala que oj huajuque ja ba jun ch'ayan lugara, ja ba meyuc ja cristiano, mojan ba jun yal hacienda sbiil Betsaida. ");
INSERT INTO tojNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero ja cristiano, yajni yabyei, lom xta xnololi ch'ac huajuque. Jaxa Jesusi yajni yila ti xa ay c'ot ja cristiano, ti och see yi jastal oj ajyuque ta huan c'ax yaa sbaje ja ba sc'ab ja Diosi. Soc ch'ac ya tojbuc ja ma' jel ja snesesida soc ja xchamelei. ");
INSERT INTO tojNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cuando huan xa tz'elpujel ja c'ac'u, ti jac ja lajchahuanei. Ti yalahuea: ―Jeca xa ja cristiano. Malan oj c'otuque ja ba yal hacienda jumasa ma ja ba yal lugar mojani cosaque oj bob stae majan ja sposadaei. Ja tihui oj staa ja suaelei, pero ja ili, ti aytic ja ba mey cristiano, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ti yala ja Jesusi: ―¿Jaxa mi xa huaahuex yi ja suaele ja huenlex ba? Ti yala ja yenlei: ―Ja quentiqui quechan xta joe ala pan quiojtic soc chab chay. Entonces ¿quen oj huaj manticon ja jas oj yabye ja jun montón cristiano iti? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Porque ja janec' cristiano jahui, ja quechan ja huiniquei, ay mojan joe mil. Ja Jesusi ti yal yab ja snebuman jumasa: ―Cax alahuic yab oj ochuque culan, a yi sbaje cincuenta cada c'ole, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jach ni sc'ulanea. Yalahue yab oj ochuque culan spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ja Jesusi ti yiaj ja joe pani soc ja chab chayi. Ti sq'uela q'ue ja satq'uinali. Ti sc'ana yi stz'acatal ja Diosi. Ti och xet' ja pani. Yaa yi ja snebuman jumasa, jaxa snebumani ya ec' yi ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ti och huaa spetzanil ja cristiano. Butye lec. Jaxa jas can sobrai, ti stzomohuea, iday, lajchahue mooch but'i. ");
INSERT INTO tojNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jun c'ac'u ja Jesusi soc ja snebumani ti huajye ba jun ch'ayan lugar. Ti huaj sc'umuc ja Dios ja Jesusi. Jaxa mas tzaani ti och sob ja Jesusi: ―Jaxa cristiano ba, ¿mach ayon huax yalahue ba? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ti sac'a jan ja snebuman jumasa: ―Ay ma' huax yalahue que huena ni bi ja Juan it huax yaa bautismo ajyi. Jaxa tuqui huax yalahue que aluman‑Dios Eliasa, jaxa tuqui huax yalahue que huena ni bi june ja aluman‑Dios ba najatei sacuiya ta bi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―Jaxa huenlexi, ¿machunquilon huaxa hualahuex ba? xchi ja Jesusi. ―Huena ni ja Cristo tzaubala ni yuj ja Dios tac, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ja yeni ti scomo ja snebuman jumasa ba mi ma' jas oj yal yab ja iti, pero sc'ana lec pavor. ");
INSERT INTO tojNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ti yalaa: ―Ja queni ti coyon jan ja ba satq'uinali pero anima, oj ni quii jitzan huocola. Ja banquilal jumasa mi oj sc'ulucon recibir soc jach ni ja nihuac pagre jumasa. Mi ni ja matic huas sea ja smandar ja Moisesi, mi oj sc'ulucone recibir. T'ilan ni oj chamcona pero ba yoxil c'ac'u oj ni sac‑huucona. ");
INSERT INTO tojNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ja Jesusi ti spaya jan ja cristiano jumasa. Ti och yal yabyea: ―Ta ay c'a ma' huas sc'ana ajyuc jmoqui, mi yen mismo oj syajta sbaj. A yaa sbaj juntiro cada c'ac'u, anima huax aaji locan ja ba cruzi. A sneb ja jmodo ja queni. ");
INSERT INTO tojNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Spetzanil ja ma' huajel sc'ujol que oj ajyuc tzamali, huan nix ch'aya sbaja. Pero ja ma' huax yala, ta huala chamyon yuj ja huax c'uan ja hueni, ti la chamyona, pero siquiera oj ajyuc lec ja caltzili ‑ ja ma' jach huax yala, pues ja yeni oj ni staa ja svida ba jel leca. ");
INSERT INTO tojNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ja ma' tey ba sc'ab spetzanil ja jas ay ja ba mundo, pero ta huan c'ax ch'ay ja yaltzili, ¿ja' ma ba slequil ja jau ba? ");
INSERT INTO tojNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ja queni ti ni coelon jan ja ba satq'uinali pero oj xa cumxucon ja tihui. Pero oj cho jacuc ja c'ac'u ja oj cocon jani, jaxa c'ac'u jahui oj lijpuc juntiro ja yijlab ja jTati. Jel ni tzamal oj jacon soc ja yangel ja Diosi. Pero ja ma' q'uixhui yuj ja cabali, jach ni ja queni, oj q'uixhuucon yujile ja ba sti sat ja jTat ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Huax cala, pero meran, ja janec' ayex ja ili, ay chaboxe ja ma' oj xa yil jastal ay ja ba huas sc'ulan mandar ja Diosi pero oj xa yile mas ligero, pero mi jauc ba oj xa chamuque. ");
INSERT INTO tojNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ja ch'ac yal ja jastal jau ja Jesusi, ti ec' mojan huaxaque c'ac'ua, entonces jaxa ora jahui, ja Jesusi ti huaj ba huitz. Ja' smoj ja Pedro soc ja Juan soc ja Jacobo. Ti huaj sc'umuc ja Dios ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Cuando huan sc'umajel ja Dios ja Jesusi, huaj to yile, tucbi juntiro ja sati, jaxa sc'ui, sact'ost'os xta ch'ac huajuc. Lijpi juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Huaj to cho yile, tey chab huinica. Ti huane loil soc ja Jesusi, jaxa huinique jahui, ja' ni ja Moisesi soc ja Eliasi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jaxa bayei, joybanubale yuj ja luzi, pero huax lijpi juntiro. Ja' huane yaljel ja jastal oj to yii huocol ja ba Jerusalén ja Jesusi. Ja' ni mero sloile ja jastal ni oj chamuqui. ");
INSERT INTO tojNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jaxa Pedro soc ja chahuane smoji jel juntiro ja suayelei pero huas sc'ulane fuerza oj ec'uc ja suayelei siquiera ba oj yile ja jastal huan lijpel ja Jesusi soc ja chahuane huinic ti smoji. ");
INSERT INTO tojNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jaxa chahuane jahui ti spila sbaj soc ja Jesusi. Cuando huajume xa, ti yala ja Pedro: ―Maestro, ¡pe jel lec ja ti aytic ja il tac! Oj c'ulticon huego oxe yal naitz, june ja hua baji soc june sbaj ja Moisesi soc june sbaj ja Eliasi. Pero lom huan bulbunuc ja Pedro. Mi huas snaa jasunc'a huan yaljeli. ");
INSERT INTO tojNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cuando huan yaljel jachuc ja Pedro, huaj to yile, cho jac jun ason, ti ta musjiyea. Jel xiuye yajni yilahue ja ason jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jaxa ba yojol ja asoni ti yabye jun c'umala: ―Ja iti, ja' ni mero cunin jel yaj huax cabi. Maclayic ja jas huax yala, xchi ja c'umali. ");
INSERT INTO tojNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Cuando ch'ac ja c'umal jahui, huaj to yile, stuch'il xa ja Jesusi. Jaxa yenlei mi ni june ma' c'umani yujilea. Ja c'ac'u jumasa jahui, mi ni june ma' jas yalahue yab ja jas yilahuei. ");
INSERT INTO tojNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jaxa ba xchabil c'ac'u ti xa coye ba huitz jahui, jaxa cristiano jumasa, jitzan lec jac stae ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tey jun huinic ja ba yojol ja cristiano, jaxa huinic jahui ti och c'umanuc tzatz leca: ―Maestro, tz'acatalucaa. La ila qui ja cunini. Quechan ni altiro quioj tac. ");
INSERT INTO tojNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huax jac yamjuc yuj ja tan pucuji. Huax ya ahuanuc. Huax ya tup yic! Huax ya puuxanuc ja stii. Jel huax yixtalaan juntiro. Jel huocol huax ya jijluc can t'usan. ");
INSERT INTO tojNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jc'ana ta yi stz'acatal ja hua nebuman jumasa ba oj sc'ul mandar ja pucuj ba oj yacta cani pero mi bob yujile, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ti yala ja Jesusi: ―A, ja cristiano iti mi ni t'un huas sc'uane. ¡Jel ch'uuy ja sc'ujolei! Ay xa tiempo ti ayex jmoca pero lom nia. ¿Jaye to tiempo oj caa jpasensia amoquex? Ti yal yab ja huiniqui: ―Cax iaj jan qui ja hua huunini, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ja querem jahui cuando mojan xa ay ja ba stz'eel ja Jesusi, jaxa tan pucuji ti cho sipa man luuma. Ya tup yic'. Jaxa Jesusi ti yal yab oj eluc ja tan pucuj jahui. Ti tojbi huego ja queremi. Ti xa yaa ba sc'ab ja stati. ");
INSERT INTO tojNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Spetzanil ja cristiano jel och ja spensare ja yilahue ja jas jel tzamal huan sc'ulajel ja Diosi. Cuando huane to lec pensar ja cristiano, jaxa Jesusi ti yal yab ja snebuman jumasa: ");
INSERT INTO tojNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Pero ja huenlexi, abyic lec ja jas oj cala huabyexi. Ja queni ti ni coelon jan ja ba satq'uinali pero oj xa c'ulajucon endregal ja ba sc'ab ja cristiano jumasa, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ja snebuman jumasa mi yabye sbej ja jas alji yabyei. Lajan soc macji ja xchiquinei. Huas sc'ana oj sobe yi jas sbej pero jel huane xihuel. ");
INSERT INTO tojNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ti q'ue ja sloile ja snebuman jumasa: ―¿Mach'a ma junuca ja ma' mas nihuan oj huajuc cujtic ja quentiqui? Jach ni huane yaljela. ");
INSERT INTO tojNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jaxa Jesusi como huas snaa jastal ay ja spensarei, ti yiaj jan jun yal querema. Ti ya tec'an ja ba stz'eeli. ");
INSERT INTO tojNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ti yalaa: ―Q'uelahuilex ja yal querem iti. Ta ay c'a ma' huas squitz'a yuj ja queni, quena ni huas squitz'ahuona. Jaxa ma' huas squitz'ahuon ja queni, ja' ni huas squitz'a ja jTat ja ma' seconejon coni. Ja huenlex ja ma' jun ac'ujol ayexi, yena ni mas nihuan oj ajyuca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yajni ch'ac yal jachuc ja Jesusi, jaxa Juani ti sac'a jana: ―Maestro, quilaticon jun huinic: Yuj ja sbiil ja Jesusi acta can ja huinic jahui, pe xchi tac. Pe ja quenticon jcomoticon porque mi ni jmojuctica, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ti yala ja Jesusi: ―Pero mi sbejuc huaxa comohuexi porque ja ma' mi jcondrauctiqui, camigo ni jbajtic soca, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ja Jesusi cuando jel xa mojan ja tiempo oj iijuc q'ue ja ba satq'uinali, ti xa sutan ja sc'ujol que oj xa huajuc ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ti seca och chaboxe jecabanuma. Ti huajye ba jun yal hacienda sbaj ja samariteño jumasa. Huaj slee posada ba oj huayuquei. ");
INSERT INTO tojNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ja samariteño ja ba yal hacienda jahui mi sc'ana oj yae yi majan ja sposada ja Jesusi. Ti huaj yale yab ja Jesusi que mi bi huas sc'anahue porque ti bi huajume ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ja yab jastal alji yab ja Jesús ja Jacobo soc ja Juani, ti yalahuea: ―Cajual, ¿mi ma lec oj c'antic ja c'ac' ja ba satq'uinali ba oj ch'acuc ja it jumasa? Jach ni sc'ulan ja Elías tac, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ti sutu sbaj ja Jesusi. Ti yalaa: ―Ja huenlexi lajan soc ja spensar ja pucuj ja hua pensarexi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Iday, jaxa queni, ti ni coelon jan ja ba satq'uinali pero mi jaquelucon ba oj ch'ay ja yaltzil ja cristiano. Jacyon ba oj colta ja yaltzilei, xchi ja Jesusi. Ti cho huajye ba otro yal haciendaa. ");
INSERT INTO tojNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Cuando ti xa huajumei, ti jac jun huinica. Ti yal yab ja Jesusi: ―Cajual, chican ba huala huaja, oj ni nocha ec'a, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ti yala ja Jesusi: ―Pero ja queni, mas lec ja jalahui. Ay sq'ueen. Soc ja yalchan, ay soj. Ja queni coelon ni jan ja ba satq'uinali pero mi ni ba oj ochcon baani, mey quioj, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ti yal yab ja otro juni: ―Jachuc ja hueni, nochohuon. Ti yala ja huiniqui: ―Cajual, cuando huax cham ja jtati, ti oj jacon amoca. ");
INSERT INTO tojNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ti yala ja Jesusi: ―Ja hua tati oj ni mucjuc yuj ja ma' mi ni cuenta ayuqui, jaxa hueni, caax. Cax loilta ec' ja jastal oj ajyuc ja cristiano cuando huax yaa sbaj ja ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ti cho yala otro juni: ―Oj jacon amoc, Cajual, pero c'ulan qui ja pavori, jecahuon ba oj huaj c'um can bajtan ja suinquil ja jnaji. ");
INSERT INTO tojNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ti yala ja Jesusi: ―Ja hueni ja' amoj ja ma' huas syama arado, ti huas sq'uela spatica, iday, ja xchojlal ja alaji, c'atan mechan xta huax huaji. Mi ni tojuc ja yatela. Huaxa huala oj jacan jmoc, iday, huax cho ahuala oj cumxan ba hua naji. Ja ma' q'uelq'uelpatic ayi, quechan ita huas somo ja ateli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jaxa mas tzaan t'usani ja Cajualtiqui ti cho stzaa otro setenta huinica. Jaxa setenta huinic jahui ti yala que oj yii sbaje chaticuane ba oj huajuque ba spetzanil ja yal hacienda jumasa soc ja yal lugar jumasa, jaxa yeni ti bi oj huaj tzaana. ");
INSERT INTO tojNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ti yal yabyea: ―Ja cristiano, jel xa chapan juntiro ja sc'ujolei. Lajane soc jun alaj ja ba huan xa smajlajel ja sachjeli. Pero ja atjumi, jel t'usan, jayuj c'anahuic yi ja suinquil ja alaji ba oj sec mas ja atjumi ba oj scuche jan ja iximi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jayuj ja yaani caxic xa. Meran, ja cristiano jel c'aq'ue, lajane soc ja choji. Jaxa huenlexi lajan soc ja' amojex jun yal cheji, iday, ti huax jecahuex ba snalan ja yenle tac. ");
INSERT INTO tojNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mi lom xa huiajex ja hua nutiexi soc mi ni ja hua taq'uinexi soc mi ni ja hua xanabexi, soc mi jauc ja oj ochanic loil ja ba beji. ");
INSERT INTO tojNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chican ba naitz huala ochyexi, bajtan oja c'anex yi ja Diosi que oj ajyuc laman ja suinquil ja naitz jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ta ay c'a mach ay ja tihui, ta huan c'a sc'ana oj smacla ja jas huaxa hualahuexi, entonces oj ni lamxuc ja yaltzila. Ta mi c'a sc'ana, pues como laman ajyanic ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ja ba mismo naitz jahui ti la ajyiyexa. Chican jas huax aaji ahuilex, iajic. Abyic porque jun atjum sbej ni oj yii ja stz'acoli. Mi sbejuc ja chol oj yii ec' ja naitzaltiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chican ba yal haciendail huala huajyexi, ta huan c'ax aaji ochanic, ay c'a jas huax yaa huilex, abyic, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jaxa ba yal hacienda jahui, ta ay c'a ma' malo ay, aahuic tojbuc, ti xa hualahuex yaba: Ja yaani c'ot ta ni ja ora ba oj sc'ulucotic mandar ja Diosi, utajic. ");
INSERT INTO tojNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero ta huan c'a la huajyex ba jun yal hacienda, mi c'a huas sc'anahue ja jas oja hualexi, ti la elyexa. Pero ti xa hualahuex can yaba: ");
INSERT INTO tojNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ja cocticoni cux ta pero ja' yujil ja spolvoil ja hua lugarexi. Pero ti oj tzijucticon can ja ba sti ja hua satexi. Pero ¡pobre ja huenlexi! Ja Diosi, eso sí, jac ta nique ba oj sc'uluquex mandar pero mi ni modo huaxa huaa bajexa! ");
INSERT INTO tojNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","¡Pero majlayic! Ja c'ac'u jau oj jac ja castigo, mas to lec ja scastigo ja suinqil ja Sodoma que soc ja hua castigo ja huenlex ja ba hacienda iti, iday, ja suinquil ja Sodoma mero mal cristianoe, utajic cani, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Ay pobre ja huenlex ja matic suinquilex ja Corazini! Soc jach ni ja huenlex ja matic ti culanex ba Betsaida, ¡jel ajul abajex! Jach c'a c'ulaji ja milagro ja ba suinquil ja Tiro soc ja suinquil ja Sidoni, najate suchi ja sc'ujolea, iday, ja yenlei mi ni t'un huas snaahue sbaj ja Diosi. Jach c'a, ja' xa ni sc'ue ja coxtala soc huan xa ni saxa sbaje taana. Yatz'an xta ni tola vida ja yaltzile yuj ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mas yoc'an oj yii ja scastigo ja suinquil ja Tiro soc ja suinquil ja Sidoni ja c'ac'u oja huaex yi cuenta ja Diosi. Pero ja huenlexi, tzatz juntiro oja huiex ja castigo. ");
INSERT INTO tojNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jaxa huenlex ja matic ti culanex ja ba Capernaumi, jel lom juntiro huaxa toyo bajex. ¿Yuj ama huaxa hualahuex ta oj q'ueanic ja ba satq'uinali? ¡Ay pobre ja huenlexi! Ti ni oj jipjanic co ja ba yoj inpierno. ");
INSERT INTO tojNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ja Jesusi ti cho yal yab ja setenta huinic jahui: ―Ja matic huas smacla ja jas huaxa hualahuex ja huenlexi, lajan soc quen huas smaclayone. Jaxa ma' mi smaclayexi, quena ni mi huas sc'ulanone casoa. Jaxa ma' mi huas sc'ulanon caso ja quen, yena ni ja ma' seconejoni mi sc'ulane caso, xchi ja Jesusi. Jaxa setenta jahui ti huaj sloiltaye ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yajni cumxiyei, jel gusto aye juntiro. Ti yalahuea: ―Cajual, hasta ja pucuji, quechan huax taaticon ti' ja hua biili, huas sc'uan ja cabalticoni, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ti yala ja Jesusi: ―Huan nix naa. Can ta ni baan ja Satanasa. Huan nix quila jasunc'a hua c'ulanexa. Quila sacbanban ch'ac canuc ja pucuj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pero quen caa ja hua huipexi. Anima huaxa batahuex ja mal chani soc ja tzequi, mi ni jas oj bob sc'uluc ahuilexa. Anima jel tzatz ja hua condraexi, mi ni oj bob sc'uluquex ganara. Mi ni jas oj bob sc'uluc ahuilexa. ");
INSERT INTO tojNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jel lec ja sc'uanex ja pucuj jumasa. Jel juntiro agustoex pero ay to jun cosa mas jel nihuan. Ja hua biilexi ti xa ni tz'ijbanubal ja ba libro ja ba satq'uinal tac, jayuj sbej que mas to jel gusto oj ajyanic yuj ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ja Jesusi cuando ch'ac yal ja jachuqui, jel gustoaxi juntiro yuj ja Espíritu Santo. Ti yalaa: ―Ja huen Tatey, Ajualal aya ba satq'uinali soc jach ni ja ba luumi. Ja ma' vivo soc ja ma' jel huas snaahuei mi jauc huaxa jea yi ja jastal iti. Tz'acatal ja' huaxa jea yi ja matic ch'in huax yaa sbaj ahuii. Lec, Tatey, como jach ni huaxa c'anaa. ");
INSERT INTO tojNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ja yaani quena ni huax c'ulan mandara pero huena ni ahuaunej qui, Tatey. Mi ni ma' huas snaa ta quena ni ahuuninon. Quechan huen huaxa naa. Soc mi ni ma' huas snaa ta huena ni ja jTatai. Quechan ja quen huax naa baj, como ahuuninon nia. Eso sí, ay tuc ma' huas snaa baj pero quen huax ca snae abaj. ");
INSERT INTO tojNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ja Jesusi ti sutu sbaj ja ba lado bay ja snebumani. Ti och yal yab yenle itaa: ―¡Lec xta huujilex ja jas huanex yiljeli! ");
INSERT INTO tojNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porque jitzan ja aluman‑Dios soc ja rey jumasa huas sc'ana oj yile ja jas huanex yiljeli pero mi yilahue. Huas sc'ana oj yabye ja jastal huanex yabjeli pero mi yabye, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ja Jesusi, huaj to yile, ti jac ba stz'eel jun huinic ja ma' huas sea ja smandar ja Moisesi. Ti yiaj loila pero quechan huas sc'ana oj yab jas oj el sti ja Jesusi: ―Maestro, ¿jasunc'a mero lec oj c'uluc ba oj ajyuc ja jsac'anil tola vida? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ti yala ja Jesusi: ―¿Jasunc'a huax yala ja smandar ja Moisés ba? ¿Jastal huax yala ja juun huaxa q'uela ba? ");
INSERT INTO tojNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ti yala ja ma' huas sea ja smandar ja Moisesi: ―Huax yala que yaj oja huab ja hua Huajual Diosi soc spetzanil ja hua c'ujoli soc spetzanil ja hua hualtzili soc spetzanil ja hua huipi soc spetzanil ja hua pensari. Jachuc ja hua moji, yaj oja huab jastal huaxa yajta baj ja huen mismo, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","―Meran ni ja jas huaxa hualaa, xchi ja Jesusi. Huan c'a xa c'ulan jachuc, oj ni ajyuc ja hua sac'anil tola vida, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ja huiniqui huan ni slea modo jastal oj scolta sbaja. Ti yal yab ja Jesusi: ―Eso sí, huan nix yala oj yajtatic ja jmojtica, pero ¿machunc'a ja jmojtic ba? ");
INSERT INTO tojNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jaxa Jesusi ti yalaa: ―Jun huinic, ti el ja ba Jerusaleni, ti huajum ja ba Jericó. Cuando ti xa ay ja ba beji, ti staa chaboxe lagrona. Jaxa huinic jahui yamji. Ch'ac japjuc yi ja sastic sbaji. Ajyi yajbuc lec. Cham sac'an aaji cani. Ti huaj ja lagrona. ");
INSERT INTO tojNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jaxa bay ja huiniqui, ti ec' jun pagrea. Ec' toj c'an ta yila, mi yila can ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Otro jutz'in ti cho ec' jun huinic levita ay yatel ja ba yoj templo. Mojan juntiro eq'ui pero quechan sq'uela can lec. ");
INSERT INTO tojNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ti cho ec' jun samariteñoa, jaxa yeni toj tuc cristiano nia. Ti huaj sta och c'uban ja bay ja huinic jahui. Yajni yila jastal ayi, ti stalna syaujulala. ");
INSERT INTO tojNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yajni ti xa ay ja ba stz'eeli, ti spotzo yi ja syajbeli. Ya och yi aceite soc yaalel ja tz'usubi. Ti ya q'ueuc ja ba spatic ja scahuu. Ti yiaj och ba jun chonaba. Slea yi ja sposada soc stalna. ");
INSERT INTO tojNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jaxa otro c'ac'u cuando oj xa huajuc ja samariteño jahui, ti ya el chab sat taq'uin, denario sbiil yujile. Yaa yi ja suinquil ja naitzi. Ti yal yaba: ―Aa hua pavori. Talna qui ja huinic iti. Ta mi c'ax yaa ja taq'uin huax caa cani, ta ay c'a jas huaxa huaa ja hueni, oj tup ahui cuando huala cumxiyoni, xchi ja samariteño. ");
INSERT INTO tojNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ja Jesusi ti sobo yi ja ma' huas sea ja smandar ja Moisesi: ―¿Jas la chi ja huen ba? Ja ma' yajbesji cani, jaxa oxhuane ja ma' ec' ba, ¿machunc'a june ja yenle coltani ba? ");
INSERT INTO tojNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ti yala ja ma' huas sea ja smandar ja Moisesi: ―Pues ¿mi ma jauc ja' ma' stalna syaujulal ba? Ti yala ja Jesusi: ―Ja' nia conser ja samariteño jahui toj tuc cristiano ja ma' scolta. Pero sbej ni ja jas sc'ulana porque puro ni jmoj jbajtica. Jach ni ja huen chomajquili, cax c'ulan ja jastal jahui, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jun c'ac'u ja Jesusi tey ba bej. Ti c'ot ja ba jun yal chonab, jaxa tihui ay jun ixuc sbiil Marta. Jaxa ixuc jahui sloco ja Jesús ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jaxa Marta, ay jun yermana María sbiil. Ja María ti och culan ja ba stz'eel ja Jesusi. Ti huan smaclajel ja jas huan yaljeli. ");
INSERT INTO tojNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ja Marta jel juntiro t'ilan huax yab ja yateli, jayuj ti och parte soc ja Jesusi: ―Cajual, ¿sbej ama huaxa huab ja jtuch'il huanon atel ba? ¡Jaxa quijtz'ini lom culan ec' ba hua tz'eel tac! Aa hua pavori al yabi que a scoltayon, xchi ja Marta. ");
INSERT INTO tojNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ti yala ja Jesusi: ―Marta, ja' huajel ac'ujol soc ja hua huateli. Quechan huana snutzjel abaj soc ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero ay jas mas jel t'ilan. Ja María stzaa ta ni ja ba mas leca y mi ni ma' oj sap yia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jun c'ac'u ja Jesusi ti huaj sc'umuc ja Dios ba jun lugar. Cuando ch'ac sc'umuc ja Diosi, june ja snebumani ti yalaa: ―Cajual, jea quiticon jastal oj c'umticon ja Dios ja quenticon ba. Pe jach ni ja Juan tac, sea ni yi ja snebuman jumasa jastal oj sc'umuque ja Diosi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ti yala ja Jesusi: ―Lec oj cala huabyex jastal oja c'umuquex ja Diosi: JTaticon Dios ti aya ba satq'uinali, ja hua biili, mi cualquierauc. A jacuc ja tiempo oj ni ac'ul mandari. A c'ulajuc ja jastal huaxa c'anai. Ja jastal huaxa c'ulan ja ba satq'uinali, jach ni a c'ulajuc ja ba luum chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ja yaan c'ac'u aa quiticon ja juaelticoni. ");
INSERT INTO tojNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","C'ulan quiticon perdonar ja jmulticoni porque jach ni ja quenticoni, jc'ulanticon ta perdonar ja ma' huas sc'ulan quiticon ja malo. Moc hua c'ulajucoticon ganar soc ja jmulticoni. Pilahuoticon ja ba yoj maloili. Jach ni c'anahuic yi ja Dios jastal ita, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ti cho yala ja Jesusi: Q'uelahuile, cuando ay jun ahuamigo, jaxa hueni nalan acual oj huajan ja ba snaj ja huamigo jahui. Ti oja hual yaba: Camigo, a jel t'an siquiera chanjouc ja hua huooti. ");
INSERT INTO tojNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ay jun camigo huan tox jul ja ba jnaji pero mi jas quioj ba oj ca yabi, oj chian c'ote. ");
INSERT INTO tojNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jaxa hua huamigo tey yoj naitzi ti oj yal jana: Jachuc ja quen, mi xa jas can sobra ja cooti, cho lutan xa ja jnaji. Soc huan xa huayel ja cuntiquil ja ba jch'ati jayuj mi xa oj bob jas oj caa hui, oj chiuc. ");
INSERT INTO tojNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iday, ja huamigo nia pero mi ni modo oj q'ue yaa hui jel ja yooti. Pero yajni huax yila mi ni la huaji, ti oj q'ue yaa hui spetzanil ja jas huaxa c'ana. ");
INSERT INTO tojNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jayuj huax cala huabyex, cuando huaxa c'umanex ja Diosi, c'anahuic yi ja jas huaxa c'anahuexi. Ja yeni oj ni yaa huilexa. Mi lom xa huaahuex can ja sc'anjel yii. T'ilan oj aajuc ahuilex. Jaman c'a ja hua tiexi, oj ni ataex ja jas huaxa c'anahuexi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porque spetzanil ni ja ma' huas sc'ana yi ja Diosi, huan nix aaji yia, jaxa ma' mix yaa can ja sc'anjeli, huan ni sc'ulan recibira, jaxa ma' jaman ni ja stii, huan ni staaa. ");
INSERT INTO tojNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ja huenlexi tatalex, jaxa huuntiquilexi ta huan c'ax jac sc'an ahuilex jun pan, ¿oj ma huaex yi jun ton ba? Ma ta huan c'ax jac sc'an ahuilex jun chay, ¿oj ma huaex yi jun mal chan ba? ");
INSERT INTO tojNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma ta huan c'ax jac sc'an ahuilex jun nolob, ¿oj ma huaex yi jun tzec ba? ");
INSERT INTO tojNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ja huenlexi, eso sí, maloex nia pero iday, huan ni xa huaahuex yi ba lec ja smajtan ja hua huuntiquilexi, ¡jauc to ma ja hua Tatex tey ba satq'uinali! Ja yeni oj yaa yi ja Espíritu Santo ja ma' huan sc'anjeli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jaxa mas tzaani ja Jesusi ti iiji jan yi jun huinic ixtalanubal yuj ja pucuji. Aaji ta pax mudoil. Jaxa Jesusi ti yal yab ja pucuj jau que oj yacta can ja huinic jahui. Yajni el ja pucuji, jaxa ma' mudo ajyi, c'umani. Jaxa cristiano jumasa jel och juntiro ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero ay chaboxe ja yenlei ti yalahuea: ―Es, huan ni sc'ulan mandar ja pucuja pero ja' ac'ubal yip yuj ja sepeil ja pucuji, pero ja' ni ja tan Satanasi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jaxa tuqui ti cho yalahue yaba: ―Siquiera oja jee jun nihuan seña sbaj ja Diosi. Jach yalahue porque quechan huas sc'ana oj sc'uluque probar ja Jesusi ");
INSERT INTO tojNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ja Jesusi huas snaa jastal huan xta huaatzhuunuc ja sc'ujolei. Ti yalaa: ―Ja ba jun lugar, ta huan c'ax yila sbaje condra ja suinquili, mi ni lec oj ajyuca. Y jach ay ba jun naitz, ta puro pleito aye, oj ni jomuca. ");
INSERT INTO tojNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ja pucuj jumasa, ta pilan pilan c'a aye, ¿mi ma oj cho jomuque ba? Ja queni huaxa hualahuex que ja' quioj ja yip ja diablo jayuj huax bob jc'ul mandar ja pucuji. ");
INSERT INTO tojNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ta meran c'a ja' quioj ja yip ja diablo, iday, ¿jaxa hua mojex ba? ¿Ba huax yiaj ja yip ja yenle ba? ¡Majlayic! Ja yenle ja hua mojex jahui mi oj sc'ul gusto oja hualex jastal iti. ");
INSERT INTO tojNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero ta ja' c'a yuj ja Dios huax bob jc'ul mandar ja pucuji, entonces ja' xa ni ja Dios huan xa sc'ulajel mandar ja ila. ");
INSERT INTO tojNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Q'uelahuil jun huinic jel ja yipi. Chapan lec. Ta huan c'ax jac ja scondra, mi jas oj sc'ul yi palta. Oj ni bob scolta sbaja. Jel huas stalna ja snaji, jaxa jastic sbaji, mi huanuc pensar ta oj elc'ajuc yi como jel ni seguro aya. ");
INSERT INTO tojNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero ta huan c'ax jac ja ma' mas jel ja yipi, eso sí, oj ni c'ulajuc ganara. Oj japjuc yi spetzanil ja jas huas scolta sbaj soc ajyi, jaxa jastic sbaji oj ni ch'ac iijuc yia. ");
INSERT INTO tojNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ja ma' mix bob smojuconi, condra ni huax yilahuona, jaxa ma' mi sc'ana oj scoltayon soc ja cateli, ja' ni sgusto ja mi oj bejyuc ja catela. ");
INSERT INTO tojNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Q'uelahuil jun pucuj. Huax yaa can jun huinic, ti huax huaj ba jun taquin lugar, jaxa tihui c'atan xta ay eq'ue. Mix yila ora ba oj staa ja sijlubi, pero meyuc. Ti huax yalaa: ―Oj ma cumxucon ja ba jnaji ja ba elyon jani. ");
INSERT INTO tojNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ti xa cumxia. Jaxa c'oti, mesubal lec ja naitzi. Tojbel lec. ");
INSERT INTO tojNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ti huaja. Huaj yii jan otro juque ja smoj pucujili, pero mas to pegor ja jucuane jahui que soc ja yeni. Ti ochye culan ja ba naitz jahui. Ja huinic jahui mas lec ja jastal ay ajyi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ja Jesusi cuando jach to huan yaljel jachuqui, jun ixuc ja ba yojol ja cristiano ti c'umani tzatz leca: ―¡Jel lec huax yila ja ma' yalintaya soc ja ma' ya chuunani! xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero ja Jesusi ti yalaa: ―Eso sí, pero mas to jel lec huax yila ja ma' huax yab ja yabal ja Diosi soc ja ma' huas sc'uani, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ja cristiano mas to huan stzomjel sbaje ja bay ja Jesusi, jaxa Jesusi ti yalaa: ―Ja cristiano iti, jel maloe juntiro. Quechan huane sc'anjel ba oj yile jun seña pero mi ni oj yilea. Eso sí, ay ni jas oj yilea pero ja' ni jastal ec' ja Jonasi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ja jastal jeeji yile ja yip ja Dios ja suinquil ja Ninivé yuj ja jas c'ulaji yi ja Jonasi, jach ni oj cho jeejuc yile ja yip ja Dios ja cristiano iti. Oj ch'ac yile ja jastal oj ec' cujili, iday, ja queni ti ni coelon jan ja ba satq'uinala. ");
INSERT INTO tojNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jaxa c'ac'u oja huaex yi cuenta ja Diosi, ti ni oj ajyuc ja reina jau ja ma' el jan ja ba najtil lugar. Huaj sc'an yi sc'ujol ja rey Salomoni porque ja reyi jel juntiro huas snaa. Iday, ja reina jahui ti jac ja ba jun najtil lugar lec. Ja yeni oj ni yaex endregala. Iday, ja ili ay jun ma' mas nihuan que yuj ja Salomoni pero mi xa huaahuonex caso. ");
INSERT INTO tojNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jachuc ja suinquil ja Ninivé chomajquili. Oj ni yaex endregala. Ja yenlei suchi ja sc'ujole ja yora loiltaji yabye yuj ja Jonasi. Iday, ti ayon amoquex ja queni. Mas nihuanon ja quen que yuj ja Jonasi pero mi ni modo huas suchi ja hua c'ujolexi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ja jas huax jea lajan soc jastal jun candela. Q'uelahuil jun candela. Ta huan c'ax aaji ajluc, yuj oj ni maconuca. Mi ni modo oj nujxuc soc jun cajón soc mi ni modo oj aajuc ajluc ba jun naitz ba mey suinquil. Ti oj aaji ochuc ba jun candelerio, jaxa ma' huax och ja tihui, oj ni bob yil q'uinala. ");
INSERT INTO tojNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jaxa ma' huax yab slugaril ja jas huax jea, lajan soc ja ma' lec ay lec ja sati. Toj ni huax bejyia porque ja jsatiqui, ja' ni huax ya yil q'uinal ja jcuerpotica. Pero ja ma' mi lecuc ay ja sati, ti ni ay ja ba q'uiq'uinala. ");
INSERT INTO tojNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ta ti xa c'a aya ja ba yoj luzi, pero aa lec acuidadoex porque ay modo jastal oj cho ochanic ja ba yoj q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ta meran c'a ti xa aya ja ba luzi, najat xa ni ahuioj ja q'uiq'uinala. Lajan soc ti aya ja ba huax lijpi juntiro, como jastal ja ti aya ba stz'eel jun luz ba jel tzatz ja yijlabi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Cuando ch'ac yal ja jastal it ja Jesusi, ti locji huael yuj june ja fariseo. Yajni och c'ot ja ba snaj ja fariseo jahui, ti och culan ja ba mesa. ");
INSERT INTO tojNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ja fariseo jahui cuando yila mi sac'a ja sc'ab ja Jesusi ja jastal culan yujile cuando mi tox och huauquei, jel tuc juntiro yila. ");
INSERT INTO tojNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jaxa Cajualtiqui ti yalaa: ―Ja huenlexi, fariseoex, ja hua vasoexi soc ja hua platoexi sac'ubal lec huaxa huaahuex ja spatiqui pero ja yojoli, cux ta ni aya. Jach ni mero amodoexa. Jel tzamal huaxa jea bajex ja ba fuera pero ja hua c'ujolexi mi icben sbej jastal ay. Puro elc'al but'el. ");
INSERT INTO tojNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Tontos! Ja ma' sc'ulanex, eso sí, huax yila jastal huaxa jea bajexi, ¡jauc to ma hua c'ujolex mi oj bob yil jastal ay! ");
INSERT INTO tojNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mas lec, mi xa mutz'u ja hua c'ab soc ja hua moj jumasa. Jaman c'a ja hua c'abi, ti oja huil que tzamal oj ajyuc ja hualtzili, mi quechanuc sac'ubal ja spatic ja hua vasoexa. ");
INSERT INTO tojNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ay pobre ja huenlex fariseo! Hasta arabueno, hasta ruda, spetzanil ja yal c'uli huaxa huaahuex lec cuenta. Ja ba cada lajunei, ti huax hua eluquex jujune ja ba smajtan ja Diosi. Lajan soc jel toj ayex pero iday, mi ni t'un toj ayuquex soc ja Diosi. Mi ni t'un huaxa naahuex ja syajtajel ja Diosi. Jel lec huaxa huaahuex yi ja Dios ja hua c'ulexi, pero ja ba mas t'ilani, huaxa huaahuex can jun lado. ");
INSERT INTO tojNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ay pobre ja huenlex fariseo! Jex oc' ac'ujolex ja lugar ba mas tzamal ja ba yoj ahuiglesiaexi. Jaxa ba plaza jel ja hua gustoex huax jac tajuc ja hua c'abexi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ay pobre ja huenlex ja huanex seejel ja smandar ja Moisesi soc ja huenlex fariseo jumasa! ¡Toj chab cara ayex! Ja' ni amojex ja sq'uejnal ja chamhuinic ba mi xa ay seña pero iday, ja yojol ja q'ueen jahui, jel ni quistala. Ja ba hua c'ujolexi, mi icben sbej jastal ay ja mulali. Ja cristiano huax hua snebex ja hua modoexi. Jaxa pobre cristiano ja ma' huaxa jeahuex yii, jun sc'ujol huas smaclayex. ");
INSERT INTO tojNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ti sac'a jan june ja ma' huas sea ja smandar ja Moisesi: ―Maestro, entonces quen huax hua jmacchiquinucticon, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ti yala ja Jesusi: ―¡Ja huenlex nia! ¡Jel ajul abajex ja huanex seejel ja smandar ja Moisesi! Ja huaahuex ta och mas. Lajan soc huaxa tz'alahuex yi jun nihuan scarga ja cristiano jaxa huenlexi jach la bachbuniyex eq'ue. ");
INSERT INTO tojNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ay pobre ja huenlexi! Ja ba can mucan ja aluman‑Dios jumasa, jaxa huenlexi ti huaxa c'ulanex ja snajtzil ja sq'uejnalei pero ja mero smeranili, ja' ni amojex ja tantic mulanum ja ma' ec' pax ta huujilexi porque yenle ni ch'ac smilea. ");
INSERT INTO tojNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Moc ahualex ta mi huaxa naahuex lec ja iti. Lajan soc lajti abal ch'ac huajanic ja jastal ch'ac smile ja aluman‑Dios. Ch'ac smile ja yenlei, jaxa huego ja huenlexi, huen huax hua q'ueuquex ja snajtzil ja sq'uejnalei. ");
INSERT INTO tojNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ja Diosi, como huan ni snaaa, yala ni que oj ni sec yi ja cristiano ja yaluman jumasa soc ja secabanum jumasa pero yala ni que ay ni ma' oj miljuca, jaxa tuqui oj aajuc yi jitzan huocol. ");
INSERT INTO tojNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jaxa huenlex ja jun lame iti, huen oja cuchex can ja xchiq'uel ja aluman‑Dios jumasa ja janec' pec' desde cujlaji ja satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Desde yora milji ja Abeli, jach ni lamlamil ch'ac chamuquea hasta cham ja Zacarías it milji ja ba scol ja templo soc ja ba huas tzicxi ja smajtan ja Diosi. Spetzanil ja jau jumasa, huenlex ni oj ch'ac acuchex can spetzanila. ");
INSERT INTO tojNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ay pobre ja huenlex ja matic huas sea ja smandar ja Moisesi! Lajan soc alutunejex ja puerta ja bay ja Diosi. Mi la ochyex ja huenlexi soc huax cho amacahuex sbej ja ma' huas sc'ana oj ochuqui. ");
INSERT INTO tojNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ja Jesusi cuando ch'ac yal ja jastal jahui, jaxa matic huas sea ja smandar ja Moisesi soc ja fariseo jumasa mi snaa jas oj sc'uluque yi. Ti och sc'ane yi sc'ujol jitzan cosaa ");
INSERT INTO tojNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ba mi oj sc'ul palta jas mas piero oj el sti ja Jesusi ba oj bob slee ja smuli. ");
INSERT INTO tojNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Malan jach to huan yaljel ja Jesusi, jaxa cristiano jumasa huan xta stzomjel sbaje, mi naben jaye mil. Huan xta sbatalaan sbaje. Ja Jesusi ti och yal yab bajtan ja snebuman jumasa: ―Aa cuidadoex porque ja fariseo jumasa toj chab cara aye, jaxa smodo yiojei, lajan soc levadura. Huax pojxi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pero mi jas nac'an ay ba mi oj chicnajuc. Mi ni jas cosa ba ch'aban ti' abal oj ajyuca. ");
INSERT INTO tojNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Spetzanil ja jas nac'ul abal huaxa hualahuexi, satalajel abal oj chicnajuc, jaxa jastal huala ochyex loil ba yoj ja najexi, lajan soc ic' huax yiaj. ");
INSERT INTO tojNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Camigo jumasa, ay jas oj cho cala huabyex. Moc lom xihuanic yuj ja matic huax bob smil ja jcuerpotiqui, jaxa mas tzaani, mi ni jas oj bob sc'ul quitica. ");
INSERT INTO tojNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero oj cala huabyex ja ma' oj xihuanic yuji. Xihuanic yuj ja Diosi. Huan c'ax yala oj chamanic, oj ni chamanica. Ay ni yip oj sipex yoj inpierno ta ja c'a sbajex inpierno. Jayuj huax cala huabyex, xihuanic yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Q'uelahuil ja yalchan huax chonji ba yoj mercado. Jel barato juntiro. Quechan chab centavo stz'acol ja joe yalchani. Pero anima, cuenta ni ay yuj ja Dios ja yalchan jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Q'uelahuil ja stzotzil ja hua olomexi. Cuenta ay yuj ja Diosi. Cuenta to ay jitzan ja yalchani, ¡jauc to ma ahualtzilex mi cuentauc oj ajyuca! Jayuj moc lom xihuanic. ");
INSERT INTO tojNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Huax cala, pero meran, spetzanil ja ma' mix q'uixhui huas staa ti' ja jbiili ja ba sti sat ja cristiano, como ti ni coelon jan ja ba satq'uinali, jach ni ja quen chomajquili, mi oj q'uixhuucon ja oj taa ti' ja sbiilei ja ba sti sat ja yangel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero ja ma' huas snac'ahuon ja ba sti sat ja cristiano, jach ni oj cho jnac' ja yenle ja ba sti sat ja yangel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ja queni meran ni ti coelon jan ja ba satq'uinali pero ta ay c'a ma' huas staahuon ti' malo, oj ni c'ulajuc perdonara. Pero ta ay c'a ma' huas staa ti' malo ja Espíritu Santo, mi ni nunca oj bob c'ulajuc perdonara. ");
INSERT INTO tojNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Cuando huala iijiyex ja ba quiglesiatiqui ma ba sti sat ja comandante jumasa, ma ba sti sat ja ma' ay yateli, mix cham ac'ujolex ja jas oja hualexi. Mix cham ac'ujolex jastal oj c'umananic. ");
INSERT INTO tojNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ja Espíritu Santo ja mero ora jahui oj ya jac ac'ujolex jasunc'a lec oja hualexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ti yala jan june ja jun nole cristiano jahui: ―Maestro, al yab ja quermano que oj yaa qui ja jdote ja queni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ti yala ja Jesusi: ―Quere, ¿pe jas cochel ja queni? ¿Yuj ama juezon ma pilaluumon? ");
INSERT INTO tojNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti och yal yabye ja cristiano: ―Ata huabyex. Aa t'un acuidadoex ja japan tuch'an ja jastic cosa jumasa. Mi jauc oj ajyuc ja hua sac'anilex yuj ja jel ja hua jastic abajexi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ti och yal jun loila: ―Q'uelahuil, ta ay c'a jun rico huinic, jaxa sluumi jel xbaalani juntiro, ");
INSERT INTO tojNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ti huax yala sbaj yen itaa: ¿Jas oj cut ja jas jbaji? oj chiuc. Mix taa ba oj nol ja sbaal ja jluumi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Oj ma jc'ul jachuc. Oj jom el ja snojlayub ja jastic jbaji, entonces ti oj c'ul mas nihuaca. Ti oj bob jnol spetzanil ja sbaal ja jluumi soc chican ja jastic quioji. ");
INSERT INTO tojNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mi xa t'ilanuc oj atjucon, como ay ba jitzan jabil ja jas nolan cuji. Ja yaani oj xa jijlucon. Oj huaacon lec. Oj ajyucon gusto. Jach oj yal sbaj ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ja Diosi ti oj yala: ¡Ja hueni lajan soc pumpu ja hua olomi! Ja yaan acuali oj chaman, jaxa jastic nolan ahuuji, ¿ma' oja huaa can yi ba? oj utjuc. ");
INSERT INTO tojNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jachuc ja ma' mutz'an yuj ja sricoili, jaxa soc ja Diosi, mi ni t'un ricouca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ja Jesusi ti yal yab ja snebuman jumasa: ―Jayuj huax cala huabyex, mi lom xa c'ulanex pensar jastal oj ajyanic, jastal oj huaanic. Jach ni ja hua c'uexi, mi xa c'ulanex pensar. ");
INSERT INTO tojNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ja jas huaxa huabyexi soc ja jastal huaxa c'utes abajexi, pero ay to mas t'ilan que yuj ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Q'uelahuil ja joji. Mi jas huas stz'unuhue soc mi ni huax jach'ulaniye, mi ni ba huas snolo ja suaelei soc mi ni ay sranchoea pero anima, ja Diosi huan nix yaa yi ja suaelea. Iday, ja yenlei, yalchane, ¡jauc to ma huenlexi! ");
INSERT INTO tojNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Huan ama xa hualahuex que oj ajyan jitzan tiempo ja ba luumi yuj ja chamc'ujol xta ayexi? ");
INSERT INTO tojNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","¡Mi ni ay sbej ja chamc'ujola! Mi oj alban mas ja ba luumi soc mi ni oja taa ja jas huaxa c'ulan necesitar yuj ja chamc'ujol xta ayexi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Q'uelahuil ja yal nichim huax ajyi ja ba huitzi. Mix atjiye. Mix ch'alniye. Pero mi ni ja sc'u ja rey Salomoni mi slaja ja jastal ja yelahuil ja yal nichim jahui conser ja Salomoni jel tzamal juntiro ja sc'u huas slapa ajyi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jaxa nichim ba huitzi, ja huego yaax, jaxa jecheli huax ch'ac c'ac', pero anima, jel tzamal ja yelahuil huas sc'ulan ja Diosi, ¡jauc to ma huenlex mi oj ni sc'utesexa! ¡Pero ja huenlexi mi mero huaxa c'uanex! ");
INSERT INTO tojNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mi lom xcham ac'ujolex ja jas oja huabyexi soc ja ja' oja huuexi. Mi jauc ja chamc'ujol xta oj ajyaniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Spetzanil ja jastal iti, ja' huajel sc'ujol ja ma' mi sc'uan ja Diosi pero ja huenlexi ay jun aTatex huas snaa jasunc'a huaxa c'ulanex nesesitari. ");
INSERT INTO tojNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jayujil, aa bajex ja ba sc'ab ja Diosi. Jach c'a huaxa c'ulanex, oj ni ataex ja jastic abajexi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mi ni sbejuc oj xihuanica. Ja huenlexi lajan soc yal jchejex nia. Meran, ja huenlexi jel t'usanex pero ja hua Tatexi jel sgusto que ti xa ayex ja ba sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chonohuic ja jastic abajexi. Q'uebahuic yi ja ma' mi jas yioji. Ja jas ahuiojexi a atjuquex soc ja yatel ja Diosi cosaque mi oj ch'ayuc ahuujilexa. Jach c'a huaxa c'ulanex, lajan soc ti xa huanex snoljel ja ba satq'uinali. Ja tihui mi oj bob elc'ajuc soc mi ni ja huorhuojo, mi oj sote. ");
INSERT INTO tojNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Chican ja ba huaxa yajtayexi, ti ni huajel ja hua c'ujolexa. ");
INSERT INTO tojNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ja Jesusi ti och see jastal chapan oj ajyucotic cuando huax co jan otro vuelta ja yeni. Ti yalaa: ―Chapan xta la ajiyex. A xta ajluc ja hua tajexi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jach la ajyiyex jastal jun mozo huan smajlajel oj jacuc ja yajuali. Ja ajualali huajel to ba jun ch'ac abal. Pero ja huax cumxi jan ja ajualal ja ba snaji, ti huax c'umania. Jaxa smozoi, como huan xta ni smajlajela, jayuj huego huas sama ja puerta. ");
INSERT INTO tojNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jel lec oj ec' yujil ja mozo jahui yuj ja cuando huax cumxi ja yajuali, huan xta ni smajlajela. Huax cala, pero meran, ja ajualal jahui ti oj xchap sbaja ba oj ya ec'uc ja huaelal ja ba mesa, jaxa mozo jahui ti xa culan ec' ba mesa ba oj huauc. ");
INSERT INTO tojNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anima ba xchabil gallo ma ba yoxil gallo huax jul ja ajualali pero ta sac'an c'a huax c'ot tajuc ja mozo jahui, pues jel lec oj yile. ");
INSERT INTO tojNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","C'ulanic t'un pensar. Ta ay c'a jun huinic huas snaa jas ora oj c'otuc ja lagron ja ba snaji, mi ni oj och suayela. Mi ni oj yaa ja snaj ba oj elc'ajuc yia. ");
INSERT INTO tojNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jach ni ja huenlexi. Puesto xta ni ajyanica porque cuando mi huanuquex sc'ulajel pensar oj jaconi, ja' ni mero ora oj jacona. Oj ni cho cocon jan ja ba satq'uinala. ");
INSERT INTO tojNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ja Pedro ti yalaa: ―Cajual, ja loil it ahualai ¿quechan ama quenticon huax hua macchiquinucticon ba, ma spetzanil ja cristiano? ");
INSERT INTO tojNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ti yala ja Cajualtiqui: ―Jun ajualal, mi cualquierauc ja smayordomo oj yaa yi ba sc'ab ja snaji. Ja mero yorail ja huaeli, ja' xchol oj yil ta huax ch'ac yii ja suaele spetzanil ja matic tey ba yoj naitzi. Ja mayordomo jahui jel huax c'uaji soc jel toj ja spensari. ");
INSERT INTO tojNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ta jach c'a huan sc'ulajel tola vida, cuando xul ja yajuali, jel lec oj iljuc juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Seguro oj ni aajuc ba sc'ab ja jas yioj ja ajualali. ");
INSERT INTO tojNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero ta ay c'a jun mozo huan c'ax yala: Ja cajuali mi baq'uin oj cumxuc, ta xchi c'a ba sc'ujoli, ti c'a huax och smac' ja smoj mozoili soc ja criada jumasa, huas smojan ja yacbum jumasa, huas smojan huael, huas smojan yuujel trago, ");
INSERT INTO tojNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mi ni c'a t'un huas sc'ulan pensar jas ora oj jac ja yajuali, pero huaj to yile, ti xa ay ja yajuali, jel tzatz oj yii ja castigo. Ti oj nutzjuc soc ja smoj caprichudoili. ");
INSERT INTO tojNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jaxa mozo jau ja ma' huas snaa jasunc'a huas sc'ana ja yajuali pero mi snutzu sbaj soc mi ni huas sc'uana, jel oj mac'juc juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ta ay c'a jun mozo mi snaa jasunc'a huas sc'ana ja yajuali, eso sí, huas sc'ulan ja jas mi lecuqui, oj ni aajuc yi castigo, pero punto. Chican ja ma' ac'ubal ba sc'ab jitzan ja ateli, yuj ni huax c'uaji que toj oj ajyuc soca. Y mi quechanuc ja janec' alubal yabi. Huan ni sc'ulan mas ja atel ta huax yila ay to sc'ana. Jach ni mero huas sc'ana ja ajualali. Ja ma' huax yab lec ja jas huax yala ja ajualali y huan ni sc'ulana, huan nix naaxi que mi quechanuc oj sc'uluc ja janec' huax alji yabi. Oj to sc'ul mas. ");
INSERT INTO tojNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ja Jesusi ti yalaa: ―Yuj ja jacyon ja quen ja ba mundo, jayuj oj ch'ac q'ue ja suocol ja cristiano. Pero ja huocol jahui, mi pierouc anima cajan xta c'ac' oj ajyanic. ");
INSERT INTO tojNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero jach ni ja quen chomajquili. T'ilan oj q'ue lec ja juocoli. Cuando huax jac jc'ujoli, huax syatz'a sbaj ja caltzili, lajan soc ec' ta cuj. ");
INSERT INTO tojNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Huan ama xa hualahuex ta jacyon ja ba mundo ba laman oj ajyuc ja cristiano? Meran huax cala huabyex, miyuc. Yuj ja jacyoni, jayuj oj yil sbaje condra ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ja huego ba jun naitz, ta ay c'a joe suinquil, coraja oj yil sbaje. Ja jun c'olei, oxhuane, jaxa otro jun c'olei, chahuane. ");
INSERT INTO tojNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ja tatali condra oj yil ja yunini, jaxa uninali oj yil condra ja stati. Jachuc jun nanal, condra oj yil ja yali, jaxa aq'uix jahui, condra oj yil ja snani. Jachuc ja alibali, condra oj yil ja yalibi, jaxa ma' ochel alibajeli, condra oj cho yil ja yalibi. ");
INSERT INTO tojNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yajni ch'ac yal jachuc ja Jesusi, ti och see yi ja cristiano jumasa: ―Cuando mi stiempo jauqui, huaxa huilahuex lechechi xta huax q'ue ja asoni: Es, ja yaani oj jac ja jai, la chiyex, y huan nix yaa merana. ");
INSERT INTO tojNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Cuando huax jac ja iq'ui: Ja yaani mi xa oj to yaa ja jai. Jamxi ta can ja satq'uinal, la chiyex. Jach ni meran huas sc'ulan ja ic'a. ");
INSERT INTO tojNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Toj chab lado ayex! Eso sí, vivoex soc ja seña ja satq'uinali soc ja ba luumi, pero jastal oj to ec'uc ja tiempo oj jaconi, jel tontoex juntiro. Iday, ay lec seña pero mi huax jac ac'ujolex. ");
INSERT INTO tojNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Pero jas mi xa c'ulanex lec pensar ja ba toji? ");
INSERT INTO tojNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Cuando ay jun acondraex, jaxa yeni oj squichex och ja ba sti sat ja ma' ay yatel, mas lec cuando ti to ayex ja ba beji, lea modo jastal oja c'umuquex. Mi c'a xa lea modo jastal oja c'umuc, oj ni yia och ja ba sti sat ja jueza, jaxa juezi oj yaa ba sc'ab ja comandante, jaxa comandante oj sluta preso. ");
INSERT INTO tojNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huax cala, pero meran, ja tihui mi ni oj elana masan to xch'ac atup spetzanil ja hua muli. ");
INSERT INTO tojNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ja mismo tiempo jau huan to seejel ja Jesusi, ti jac chaboxe huinica. Jac yale yab ja Jesusi ja jastal huajye chaboxe huinic sbaj Galilea. Huane bi smiljel chante ba oj yaahue yi ja smajtan ja Diosi jaxa mismo ora jahui, ja yenle chomajquili, cho miljiye, pero ja' yaa orden ja Pilato ba oj miljuque. ");
INSERT INTO tojNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ti yala ja Jesusi: ―¿Yuj ama huaxa hualahuex que jel ja smulei, jayuj chamye? ¿Yuj ama mi ni june ja galileño oj slaj ja smul ja yenle ba? ");
INSERT INTO tojNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero huax cala que miyuc. Jach ni ja huenlex chomajquili. Oj ni chamanic ta mi c'a xa tucbes ja hua pensarexi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jaxa dieciocho huinic jau chamye ba Siloé cuando t'enjiye yuj ja chaanil naitz jahui, ¿yuj ama jel ja smule ba? Ja ba spetzanil ja suinquil ja Jerusaleni, ¿yuj ama quechan ja yenle ay smule ba? ");
INSERT INTO tojNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero huax cala que miyuc. Jach ni ja huenlex chomajquili. Oj ni chamanic ta mi c'a xa tucbes ja hua pensarexi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ti cho yala otro jun loila: ―Ay jun huinic ay stz'ununej jun ibe higo ja ba yalaji. Huaj yil ta ay xa sat pero mi jas staa. ");
INSERT INTO tojNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Entonces ti yal yab ja huinic ja ma' huas stalna ja alaj jahui: Q'uelahuile, ay xa oxe jabil huax jac quil ta ay sat ja higo iti pero mi ni jun jabil huax taa ja sati. Mas lec, c'utzu xa ele. Lom huan smacjel luum ja ili, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ti yala ja ma' huas stalna ja alaji: Cajual, aa can siquiera ja jabil iti. Oj boy ja luum ja yibeli soc oj cho jc'ul abonar. ");
INSERT INTO tojNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ta huan c'ax yaa sati, lec, pero ta mi c'a, ti xa xa c'utzu ela, xchi ja talna‑alaji. Jach yala jastal it ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jun sc'ac'uil sijlele ja judio jumasa, ja Jesusi ti huan seejel ja ba yiglesiaei. ");
INSERT INTO tojNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ja tihui tey jun ixuca. Ay xa dieciocho jabil malo ay. Ja chamel yioji ac'ubal yi yuj ja pucuji. C'ochan xa juntiro huax bejyi. Mi xa ni modo huax bob xijpuc sbaja. ");
INSERT INTO tojNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cuando yila ja Jesusi, ti spaya jana. Ti yalaa: ―Nana, ja yaani oj xa tojban soc ja chamel ahuioji. ");
INSERT INTO tojNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ti ya cajan ja sc'ab ja Jesús ja ba scuerpo ja ixuc jahui, jaxa mismo ora jahui, huego huego xijpun sbaj. Ti och sc'an yi stz'acatal ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ja sepeil ja iglesia jahui q'ue juntiro ja scoraja yuj ja ja' ni ja sc'ac'uil jijlel aaji tojbuc ja ixuc jahui. Ja jepe ba iglesia ti yal yab ja cristiano: ―Huaque c'ac'u ay ja ba oj atjucotiqui. Ja' la jacyex ja c'ac'u jumasa jahui ba oj aaji tojbaniqui, mi jauc ja ba sc'ac'uil ja jijleltiqui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ti sac'a jan ja Cajualtiqui: ―¡Toj chab cara ayex! Q'uelahuil ja huenlexi. Ta mochan c'a te' ja hua huacaxex ma ja hua burroexi, anima jauc ja sc'ac'uil ja jijleli, ¿mi ma oja sijpuquex ba oj huaj yu ja' ba? ");
INSERT INTO tojNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¡Jauc to ma ja ixuc iti, ja' ni ja yintil ja Abraham tac! Ja yeni ay xa dieciocho jabil mochante yuj ja Satanasi. ¿Mi ma sbejuc ni oj c'ulaxuc librar ba, anima jauc ja sc'ac'uil ja jijleli? ");
INSERT INTO tojNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cuando ch'ac yal jachuc ja Jesusi, spetzanil ja scondra jumasa jel q'uixhuiye juntiro. Pero ja otro cristiano jumasa, jel gusto yabye ja jas yilahue jel tzamal huan sc'ulajel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ti cho yala ja Jesusi: ―Oj cala huabyex jastal huax pojxiye ja ma' ac'ubal mandar yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lajan soc jun yal sbac' mostaza. Ja mostaza jahui tey ba yalaj jun huinic. Jaxa huiniqui, huaj to yile, pojxi ta lec ja jun yal sbac' jahui. Hasta ja yalchani bob sc'uluc ja soj ja ba pimi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ja matic ac'ubal mandar yuj ja Diosi lajan soc ja levadura. ");
INSERT INTO tojNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lajan soc ja slevadurail ja pani. Q'uelahuil jun ixuc. Huax yiaj ja levadura jahui, ti huas soco soc oxe medida harina. Huan tox huaj yile, q'ui ta lec ja pani. ");
INSERT INTO tojNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ja Jesusi cuando huan huajel ja ba Jerusaleni, ti huax ec' ja ba chonab jumasa soc ja ba yal hacienda jumasa. Ti huax ec' see yi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pero jun c'ac'u ti jobji yi ja Jesusi: ―Cajual, ¿t'usan it ama ja ma' oj aaji el libre soc ja smule yuj ja Dios ba? Ti yala ja Jesusi: ");
INSERT INTO tojNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―C'ulanic fuerza ba oj ochanic ja puerta ba ch'ini. Huax cala huabyex, jitzan ja ma' oj sc'an oj ochuquei pero mi oj bob yujile, ");
INSERT INTO tojNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Porque ja suinquil ja naitzi oj q'ueuc. Oj q'ue slut ja puerta. Jaxa huenlex ti ayex ba fuera: Cajual, jama quiticon ja puerta ba, oj chianic. Jaxa suinquil ja naitzi ti oj yala huabyexa: Mix naa ba jaquelex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jaxa huenlexi ti oja hualexa: ¿Mi ma xa naa ba? Pe huaelotic ni lajan tac. Ja huana seejel ja ba yoj plaza, ti ni ayticon ja quenticon tac. ");
INSERT INTO tojNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jaxa yeni ti oj yala huabyexa: Huax cala huabyex, mix naa ba jaquelex ja huenlexi, oj yutex. ¡Elanic ja ba jtz'eel ja huenlexi porque puro malo jas ac'ulanexi! oj yutex. ");
INSERT INTO tojNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ja tihui oj oc'anic lec. Cuando huaxa huilahuex sat ja Abrahami soc ja Isaqui soc ja Jacobi soc spetzanil ja aluman‑Dios jumasa, como ja yenlei ti aye ja ba huas sc'ulan mandar ja Diosi, jaxa huenlexi, ti ayex ba fuera, ti oja c'uxex lec ja hua huejexi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ja cristiano tey ba huas sc'ulan mandar ja Diosi oj ch'ac stzom sbaje ja ba xchanil xchiquin ja satq'uinali ba oj huauque ja ba mesa ja ba huas sc'ulan mandar ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jaxa c'ac'u jahui ja ma' lajan soc mi cristianouc ilji yuj ja smoj cristianoili, pero ja' xa soc ja Diosi jel nihuan oj iljuc. Jaxa ma' jel nihuan huax ilji ja ili, pero ja ora jahui jel ch'in oj iljuc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ja mismo ora jahui ti huaj chaboxe fariseo. Huaj yale yab ja Jesusi: ―Mas lec elan ja ili porque ja tan rey Herodesi huax yala oj bi smila. ");
INSERT INTO tojNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ti yala ja Jesusi: ―A, ja huinic jahui quechan jel vivo soc ja smaloili. Cax alahuic yabi que ja yaan c'ac'ui soc ja jecheli oj ca el libre ja cristiano ja ma' huan ixtalajel yuj ja pucuji. Oj ni ca tojbuc ja ma' malo ayi. Man to chabej oj ch'acuc ja cateli, utajic. ");
INSERT INTO tojNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ti ni huajumon ja ba Jerusalena. Oj to bejyucon ja yaani soc ja jecheli soc ja chabeji. T'ilan ni oj huajcona porque mi ni jun aluman‑Dios chamel ja ba otro lugari, quechan ti ba Jerusaleni. Cax alahuic yab jastal it ja Herodesi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yajni ch'ac yal jachuc ja Jesusi, ti och yala: ―A jerusaleño, suinquil ja Jerusaleni, huaxa milahuex ja aluman‑Diosi. Soc ton huaxa milahuex ja matic huax jecji ahuilex. Mi naben jaye vuelta huax c'ana oj tzomex can jastal ja gallina huas stzomo ja yuntiquili ti huax yaa ba yibel ja suech'i, pero mi ni modo huaxa c'anahuexa. ");
INSERT INTO tojNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","¡Ay pobre ja huenlexi! Oj xa can lutan ja hua najexi. Huax cala huabyex quechan xta huaxa huilahuonex ja huego. Eso sí, oj to ahuilonex pero ja ora jahui, stz'acatal ja ma' huax jac yuj ja sbiil ja Cajualtiqui, oj chianic. ");
INSERT INTO tojNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jun sc'ac'uil ja sijlel ja judio jumasa ja Jesusi ti locji huael yuj june ja fariseo ja ma' ay yatel. Ti huaj ja ba snaji. Tey chaboxe ja smoj fariseoil ja ma' locuanel huaeli, jaxa yenlei huane smajlajel ta ay jas oj el sti ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Cho tey jun huinic ba mojan ja stz'eel ja Jesusi jaxa huinic jahui, sitz'el sni sat. ");
INSERT INTO tojNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ja Jesusi ti sobo yi ja ma' huas sea ja smandar ja Moisesi soc ja fariseo jumasa: ―¿Lec ama ta huax caatic tojbuc ja ma' ay xchamel ja sc'ac'uil ja jijleli? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jaxa yenlei mi ni jun palabra ma' c'umani yujilea. Jaxa Jesusi ti syama ja ma' malo ayi, ti ya tojbuca, ti yal yaba: ―Cax xa, x'utji ja ma' malo ay ajyi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ti yal yab ja fariseo jumasa soc ja matic huas sea ja smandar ja Moisesi: ―Q'uelahuil ja huenlexi, ta huan c'ax moc' q'ueen ja hua burroexi ma ja huacaxexi, ¿mi ma oj ni hua eluquex huego ba, anima jauc ja sc'ac'uil ja jijleli? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jaxa yenlei mi ni jun palabra ma' sama stii. ");
INSERT INTO tojNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jaxa tuc jumasa, ja ma' locobal ni, yajni huax ochye c'ote, huan ita sq'uelahue ja silla ba mojan stz'eel ja suinquil ja naitzi. Ja Jesusi cuando yila jastal ja smodoei, ti och yal jun loila: ");
INSERT INTO tojNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Ta ay c'a ma' huas slocohuex ba jun ch'ac abal, mas lec mi la ochyex culan ja ba lugar tzaubali porque mi xa naa ta ay ma' oj jacuc jaxa yenlei mas t'ilan ti oj ochuque culan ja tihui que soc ja hueni. ");
INSERT INTO tojNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Entonces oj jacuc ja suinquil ja naitzi, oj yala huabi: ¿Mi ma oj bob huajan culan ja ti c'ote porque ay ma' oj och culan ja ili? oj yuta. Jaxa hueni, ti oj elana pero jel oj q'uixhuan, ti oj huajan ja ba jun xchiquin naitz. ");
INSERT INTO tojNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mas lec, cuando huala locjiyexi, culananic ja ba stz'eel ja ma' mey xcholi. Ti oj jacuc ja suinquil ja naitzi: Jaxa huen tatjun, ¿jas huaxa lea c'ot ja tihui? Ja hueni sbej ni ti oj jacan il ja huena, oj yuta. Ti oj yila ja cristiano que tzaubal ja hua lugari. ");
INSERT INTO tojNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque ja ma' jel huas stoyo sbaje oj aaji q'uixhuuc, jaxa ma' mi huanuc sleejel ba oj toyjuqui, mas toyobal oj huajuc. ");
INSERT INTO tojNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Cuando ch'ac yal jachuc ja Jesusi, ti yal yab ja ma' locuani: ―Ja hueni, cuando huaxa c'ulan jun q'uin y huaxa huaa huaelal, mi lom xa loco ja hua huamigo jumasa, mi ni ja hua huermano jumasa, mi ni ja hua najtil hermano, mi ni ja hua vecino jumasa ja ma' jel ja staq'uini. Porque ja yenlei ay modo oj cho sloca. Ta jach c'a, lajan soc huan nix ya paxuc ahui sloc'ola. ");
INSERT INTO tojNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mas lec, cuando huaxa c'ulan jun huaelali, loco ja pobre jumasa soc ja impedido jumasa soc ja renco jumasa soc ja ma' tupel ja sati. ");
INSERT INTO tojNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ti oja huil que jel gusto oj canuc ahualtzili, porque mi oj bob cho yaa hui ja yenlei. Jaxa ora oj ya sac‑huuc ja Dios ja ma' jel toj ayi, ti oj aajuc ahui ja stz'acol ja jas huaxa huaa. ");
INSERT INTO tojNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ja ch'ac yal ja jastal it ja Jesusi, ti yala june ja ma' ti culan ja ba mesa: ―¡Lec xta yuj ja ma' oj locjuc huael ja ba huas sc'ulan mandar ja Diosi! ");
INSERT INTO tojNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ja Jesusi ti yalaa: ―Ay jun huinic sc'ulan jun nihuan huaelal y jel jitzan ja matic slocoi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jaxa cuando lec xa ay ja huaelali, ti seca ja smozo ba oj ch'ac spay jan ja ma' sloconeji: Laic xa. Ja huaelali lec xa ay, xchi ja mozoi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Iday, spetzanile ch'ac yale que mi oj bob jacuque. Ja ba mero bajtan huaji: Huan tox ch'ac jman jun pedazo jluum. Ja' t'ilan oj huaj quile, jayuj c'ulanon perdonar, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jaxa otro juni ti cho yalaa: Q'uelahuile, jmanunej to joe teele juacax. Huax c'ana oj c'ul probar. C'ulanon perdonar, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ti cho yala ja otro juni: Ajc'ach to ch'ac nupanucon, jayuj mi oj bob huajcon, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jaxa mozo ti cumxia. Huaj yal yab ja yajuali. Ti jel q'ue ja scoraja ja suinquil ja naitzi. Ti alji yab ja mozo: Cax ja ba plazai soc ja ba calle jumasa ja ba yoj chonabi. Iaj jan ja pobre jumasa soc ja impedido jumasa soc ja renco jumasa soc ja matic tupel ja sati, xyutaj ja smozo. Jaxa mozo ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Cuando cumxi jani, ti yalaa: Cajual, jc'ulan ja jas ahualai pero ay to ni lugara, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ti yala ja ajualali: Pues cho cax ja ba beji. Ta ay c'a ma' huaxa taa tec'an ja ba sti ja beji, chican ma' huaxa taa, iaj jan t'ilan ba oj but'uc ja jnaji. ");
INSERT INTO tojNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Huax cala, pero meran, ja ma' mero jloconeji mi ni oj yabye yajbal ja huaela, xchi ja ajualali. Jach ni sbej ja loil it ja jastal yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ja Jesusi ti huan huajel soc jun nole lec ja cristiano ja ba Jerusaleni. Ti sutu sbaja. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ta ay c'a ma' huas sc'ana jac jmoc ja queni pero ta mas c'a jel yaj huax yab ja snan stati, ma ja xcheumi, ma ja yuntiquili, ma ja yermano, ma ja yermana yuj ja queni, entonces mi sbejuc huax och jnebumanil. Jachuc ja ma' huajel sc'ujol huas syajta sbaj ja yen mismo, mi ni sbejuc huax och jnebumanila. ");
INSERT INTO tojNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ta ay c'a ma' huas sc'ana oj jac jmoc, pero ta mi c'a huas sc'ulan ahuantar ja huocoli, mi lom xa huala ta jnebuman ja yeni. Ja ma' jnebuman ni ja queni, oj sc'ul ahuantar ja huocoli, anima huax aaji locan ja ba cruzi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Q'uelahuil ja huenlexi, ta huaxa c'ana oja c'uluquex jun nihuan naitz, bajtan oja c'uluquex pensar ta oja taex ja taq'uini ba oj ch'ac ac'uluquexi. ");
INSERT INTO tojNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Mi c'a, c'ot ora quechan huax hua chotanex cani, jaxa s'olomi mi oja taex. Jaxa ma' huax yila ti oj och stzeuquexa: ");
INSERT INTO tojNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ja huinic iti och suas sbaj soc ja snaji pero mi bob yuj, oj chiuque. ");
INSERT INTO tojNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Q'uelahuil, ta ay chab rey jel coraja huax yila sbaje, nechan xta aye, oj q'ueuc ja guerra. Pero ja juni, quechan diez mil soldado yioj, jaxa juni, ay yioj veinte mil. Ja ma' quechan diez mil yioji, mi sc'ana ya q'ueuc ja pleito. Bajtan oj sc'ul pensar que mi oj bob yuj. ");
INSERT INTO tojNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Cuando najat to ay ja otro reyi, oj sec ja secabanumi. Oj huaj slee modo jastal oj canuque gusto. ");
INSERT INTO tojNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jachuc ja huenlexi. Ta mi c'a pensado ayuquex lec ba oja huaex can spetzanil ja jas ahuiojexi, mi ni oj bob oj ochanic jnebumanila. ");
INSERT INTO tojNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ja ma' huas sc'ana oj och jnebumanil, jel ni leca. Porque q'uelahuil ja atz'ami, mi ni oja hual que mi lecuca. Pero oj cho cala huabyex, moca lajex ja atz'am it huax pooxi, mi xa nix maconi ja mas tzaani, ");
INSERT INTO tojNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mi ni ba abono. Sbaj xa ni xch'ayela. Ja' ni mero smoj ja ma' yaahuon ta cani. Mi xa ni jun yatel cujila. ");
INSERT INTO tojNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Spetzanil ja colector jau ja ma' huas stzomo ja taq'uini soc ja otro mulanum jumasa ti jacye ja ba stz'eel ja Jesusi ba oj smaclaye ja jas huax yala. ");
INSERT INTO tojNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ja yajni yilahue ja fariseo jumasa soc ja matic huas sea ja smandar ja Moisesi ti och bulbunuquea: ―Ja tan huinic iti lajan huas staa sbaj soc ja mulanum jumasa. ¡Jun ta sec' huax huaaye tac! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jaxa Jesusi ti och yal jun loila: ");
INSERT INTO tojNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Q'uelahuil junuc ja huenlexi. Ta ay c'a ma' yioj cien chej, ta huan c'ax ch'ay junuc ja cien jahui, entonces ti oj yaa can ba huitz ja noventa nueve, ti oj cumxuc ba oj slee ja jun yal chej jau ch'ay cani man oj stae. ");
INSERT INTO tojNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cuando huas staai, ti oj ya cajan ja ba stejlubi. Jel xa gusto oj cumxuc ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jaxa cuando huax c'ot ja ba snaji, ti oj stzom ja yamigo jumasa soc ja svecino jumasa. Ti oj yal yabyea: La xa jc'ultic jun q'uin porque jtaa ja yal chej ch'ayeli. ");
INSERT INTO tojNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Meran huax cala huabyex, ta huan c'a suchi ja sc'ujol ja june ja ma' ay smuli, jel oj yaa gusto ja ba satq'uinali. Pero ja noventa nueve jau huas stoyo sbaj que jel toji, mi sc'ana suchuc ja sc'ujolei, mi ni t'usan huax yaahue gusto ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jach ni jun ixuc ta ay c'a yioj lajune peso taq'uin, ta huan c'ax ch'ay yuj jun peso ja staq'uin jahui, oj ni xch'ix ec' ja staj ja ba yoj snaji. Ti oj och smes ja snaji. Oj slee lec masan oj stae. ");
INSERT INTO tojNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yajni huas staai, ti oj sloc jan ja yamiga jumasa soc ja svecina jumasa. Ti oj yala: La xa c'ultic jun q'uin porque jtaa ja cala taq'uin ch'ayeli. ");
INSERT INTO tojNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jayuj huax cala huabyex, jel gusto huax yab ja yangel ja Diosi ta ay c'a jun mulanum huas suchi ja sc'ujoli. ");
INSERT INTO tojNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ja Jesusi ti cho yala otro jun loila: ―Jun huinic ay yioj chab yunin. ");
INSERT INTO tojNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ja ijtz'inali ti yal yab ja stati: Tatey, aa qui ja jdote it oj ni ahuaa quii, xchi. Ti pilji yile ja sdoteei. ");
INSERT INTO tojNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jaxa ec' t'usan ja c'ac'u, ja ijtz'inal jahui ti ch'ac stzom spetzanil ja sastic sbaji. Ti huaja. Ti huaj ba jun lugar najat lec, jaxa tihui, ti ch'ac xch'ac el lom q'uiq'uinal ja staq'uini. Xch'ayelal ni huaj juntiroa. ");
INSERT INTO tojNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yajni ch'ac ta yixtalauc el spetzanil ja staq'uini, ti co jun nihuan huain ja ba lugar jahui. Iday, jaxa yeni mi xa ni jun centavo yioja. ");
INSERT INTO tojNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ti huaj sc'ap sbaj yi jun huinic ja ba lugar jahui. Ti jecji ba jun srancho ba oj stalna chitam. ");
INSERT INTO tojNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Pero mi ni huax aaji huauca. Ja huax yaa yi ja suael ja chitami, lajan soc oj cho sc'ux ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ti och sc'ul pensara: Ja ba srancho ja jtati mi naben jaye atjum huan ateli pero ay lec suaele. Huax can sobra ja suaele ja huax huaayei, jaxa queni huanon chamel huain ja ili, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","¡Oj xa ma cumxucon soc ja jtati! Oj cal yab jachuc: Tatey, jlea ta jmul soc ja ma' tey ba satq'uinali soc ja huen chomajquili, oj ma cute. ");
INSERT INTO tojNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Anima mi xa xa huilahuon jastal ahuunin, siquiera oja huilon jastal junuc ja hua huatjumi, oj ma chicon c'ote. ");
INSERT INTO tojNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ja ijtz'inal jahui ti xa huaj ja ba snaj ja stati. Cuando najat to ayi, ti ilji yuj ja stati, jaxa stati jel lástima yila ja jastal xa ayi. Ti huaj staa ajnela. Ti stela leca. Yujtz'an. ");
INSERT INTO tojNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ti yal yab ja stati: Tatey, jlea ta jmul soc ja ma' tey ba satq'uinali soc jachuc ja hueni. Ja yaani mi xa ni sbejuc oja huilon ja jastal huaxa huilahuon ajyi. Lajan soc mi xa ni ahuuninucona. ");
INSERT INTO tojNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ja tatali ti yal yab ja smozo: Iajic jan ja jc'u ja ba mas tzamali. Aahuic slap ja cunini. Aahuic yi jun anillo ba oj ya och ja ba sc'abi, cho aahuic yi jun xanab. ");
INSERT INTO tojNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Cax yamahuic ja becerro jau ba mas cojleli, ti xa milahuexa. Oj c'uxtic. Oj c'ultic jun q'uin. ");
INSERT INTO tojNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porque ja cunin iti lajan soc cham ta ajyi pero ja huego, lajan soc sacui ta. Ch'ayel xa ni ay ajyia pero ja huego, jac ta yaa sbaj quitic, xchi ja tatali. Ti och ya q'ueuque ja q'uina. ");
INSERT INTO tojNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jaxa banquilali ti huajel ba huitz ja ora jahui. Yajni cumxi, ja mojan xa yioj ja snaji, ti yab que jel ja q'uin ja ba snaji soc ay chaanel. ");
INSERT INTO tojNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ti spaya jan june ja mozo. Ti sobo yi jasyuj jel ja q'uini. ");
INSERT INTO tojNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ti yala ja mozo: Ja' jul ta hua huijtz'ini. Jel lec ay ja juli. Mi ni ay spaltaila jayuj ja yila ja hua tati, yala que oj milticon ja becerro it jel cojleli, xchi ja mozo. ");
INSERT INTO tojNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jaxa banquilali jel q'ue juntiro ja scoraja. Mi ni t'un yala oj ochuca. Yajni yila ja stat que mix yala oj ochuc, ti huaj yal yab que oj ochuc ja ba yoj q'uini. ");
INSERT INTO tojNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ti yala ja banquilali: Tatey, naa t'unuc jaye jabil huanon atel amoc. Mi ni jun vuelta ba mix c'uan ja hua huabali. Pero iday, mi ni siquiera jun yal chibo huaxa huaa qui ba oj c'ul q'uin soc ja camigo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iday, jaxa huego yuj ja jul ta tan ahuunin it ja ma' quechan ixuc huajel sc'ujoli ‑ soc ni ixuc ch'ac xch'ac el lom ja hua taq'uin it ja huaa yii, iday, ¡jaxa huen huana smiljel ja becerro mas cojleli! ");
INSERT INTO tojNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ti yala ja stati: Q'uelahuil cunin, ja hueni tola vida ti ni aya jmoca. Spetzanil ja jas quioji naca baj ni ja huenaa. ");
INSERT INTO tojNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero ja huego sbej ni oj caatic sq'uinil ja hua huijtz'ina. Oj ni ajyucotic soc gustoa porque ja hua huijtz'ini lajan soc cham ta ajyi pero ja huego lajan soc sacui ta. Ch'ayel xa ni ay ajyia, pero ja huego jac ta yaa sbaj quitic, xchi ja tatali. Spetzanil ja loil iti, jach yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ja Jesusi ti cho yal yab ja snebuman jumasa: ―Ay jun ajualal jel rico soc ay jun smayordomo. Jaxa mayordomo jahui ti huaj chonjuc yabalil ja jastal lom q'uiq'uinal huan xch'acjel ja staq'uin ja yajuali. ");
INSERT INTO tojNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jaxa ajualali ti seca spayjela: Ay jas huanon yabjel ja huabalil, jayuj ja huego mi xa oj to caa ja hua huateli pero c'ulan qui entregar spetzanil ja juun jas tey ba hua c'abi, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jaxa mayordomo jahui ti och juntiro ja spensari: ¿Jasunc'a oj c'uluc ja yaani? Ja cajuali oj xa ya el qui ja catel tac, y mey quip oj atjucon soc ja luumi. Oj cho q'uixhuucon ja oj c'an ec' limosna. ");
INSERT INTO tojNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pero jnaa ta jas modo oj c'uluc. Oj lee ja camigo jumasa, ja ma' oj snolon ja ba snaj cuando x'aaji elcon ja mayordomoili. ");
INSERT INTO tojNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ti ch'ac sec spayjel spetzanil ja ma' ay sel yuj ja yajuali. Jaxa ma' bajtan jaqui, ti sobo yia: ¿Janec' ja hua jel soc ja cajuali? xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jaxa yeni ti yalaa: Pues ay jel soc cien barril aceite. Ti yala ja mayordomo jahui: Iaj ja juun iti. Quechan xta cincuenta a och juun huego, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ti cho jul ja otro juni: Jaxa hueni, ¿janec' ja hua jeli? Ti yala ja yeni: Pues ay quioj cien medida trigo, xchi. Ti yala ja mayordomoa: Iaj ja juun iti. Quechan xta ochenta a och juun, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jaxa ajualali cuando yab jas huan sc'ulajel ja mayordomo jahui, ti yalaa: ¡A, ja tan huinic jahui jel vivo soc ja smaloil ja jas huan sc'ulajeli, xchi. Ti yala ja Jesusi: Meran nia. Jach ni ja ma' tey ba mundo tac. Jel snaa huas sc'ulan ja trato soc ja smoj jumasa. Mas jel vivoe ja yenle soc ja ma' spila ta sbaj ja ba q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Oj cala huabyex jasunc'a mas lec oja c'uluquexi. Ja huego ti ayex ja ba yoj maloili jaxa taq'uin tey ba hua c'abexi, mas lec, lean ja hua huamigoex soc ja jahui. Porque oj c'otuc ja c'ac'u ja mi jas ahuiojexi pero ta jach c'a ac'ulanex, ay ma' oj sc'uluquex recibir ja ba snaji, ja' ni ja snaj ja ma' ti culan ja ba satq'uinali, jaxa naitz jahui mi ni nunca oj ch'acuc. ");
INSERT INTO tojNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ja ma' toj ay soc ja t'usan yioji, toj ni oj cho ajyuc soc ja ta jitzan c'a yioji. Jaxa ma' mi tojuc ay soc ja t'usan yioji, ¡jauc to ma ta aay c'a yioji, mi ni t'usan oj ajyuc soc toja! ");
INSERT INTO tojNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ja jas ay ba mundo, chican ja jas tey ba hua c'abexi, ta mi c'a toj ayuquex soc ja jahui, ¡jauc to ma oj aajuc ahuilex ja ricoil ba mi ni nunca huax ch'aqui! ");
INSERT INTO tojNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ta huan c'a xa huixtalaan yi ja scosa ja hua moji, jaxa mero ja hua baj ja huen, mi ni nunca jas oja huil sata. ");
INSERT INTO tojNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mi ni jun mozo oj bob yatelta chab ajualal. Ta jach c'a huas sc'ulan, coraja oj yil ja jun yajuali, jaxa juni, yaj oj yabi. Ja' oj yaa sc'ujol ja juni, jaxa otro juni mi ni t'un oj squitz'a. Ja Diosi, ma ja taq'uini, jayuj tzaa ba oja huaa c'ujoli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jaxa jas huan yaljel ja Jesusi, ti huan yabjel ja fariseo jumasa. Ja yenlei, como ja' huajel sc'ujole ja taq'uini, ti huas spechtianea. ");
INSERT INTO tojNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ti yala ja Jesusi: ―Ja huenlexi quechan huaxa jea bajex que jel lequex ja ba sat ja cristiano pero ja Diosi huas snaa jastal ay ja hua c'ujolexi. Ja cristiano ja jas jel nihuan huax yilahue ja ili pero ja Diosi jel tuu huax yabi. ");
INSERT INTO tojNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Cuando mi tox q'ue stul oj yaa bautismo ja Juani, ti xa ni ay ja smandar ja Moisesi soc ja jas stz'ijbaye can ja aluman‑Dios jumasa. Jayuj yajni q'ue yaa bautismo ja Juani, ti xa och loiltaxuc ec' ja jastal huas sc'ulan mandar ja Diosi. Jaxa spetzanil ja mulanum jumasa huan xta sbatalaan sbaje siquiera ba oj ochuque ja ba huas sc'ulan mandar ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Anima huax ch'ac ja satq'uinali soc ja luumi pero ja smandar ja Diosi, t'ilan ni oj c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ta ay c'a jun huinic huas sipa can ja xcheumi, huax nupani soc otro ixuc, huan ni staa smula. Jaxa ma' cho nupani soc ja ixuc ma' jipji cani, jach ni ja yeni, huan ni staa smula. ");
INSERT INTO tojNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ja Jesusi ti cho ya q'ue otro loila: ―Ay jun huinic rico. Ja sc'u huas slapa puro pino. Jel tzamal juntiro. Cada c'ac'u huax yaa jun nihuan huaelal, jaxa ba huax huaa ja cristiano, tojbel lec. ");
INSERT INTO tojNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Cho ay jun huinic limosnero, Lázaro sbiil. Ja yeni ti moch'an ec' ja ba spuerta ja rico jahui, jaxa scuerpo puro xta llaga. ");
INSERT INTO tojNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ti huax jac ja tz'ii. Huax jac lecjuc yi ja llaga yioji. Huas sc'ana oj huaj stul ja stz'ubil ja suael huax moc' ja ba yib smesa ja rico. ");
INSERT INTO tojNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jun c'ac'u cham ja pobre huinic jahui. Jaxa angeli ti jac yiea ba ti oj ajyuc soc ja Abrahami ja ba lugar jau jel tzamali. Jaxa rico jau chomajquili, mi ec' mas c'ac'u, ti xta cho chama. Ti huaj mucjuc cana. ");
INSERT INTO tojNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jaxa ti xa ay ba slugaril ja chamhuinic jumasa, huan lec huocol. Ti sq'uela q'uea. Ti yila ja Abrahami soc ja Lázaro pero najat aye lec. ");
INSERT INTO tojNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ti ahuani tzatz leca: Tat Abraham, talna jyaujulal. Jeca qui ja Lázaro siquiera oj yaa qui jun bechuc ja jai. ¡Taquin xa juntiro yoj jnuc' tac! Jel huanon yiijel huocol ja ba yoj tan c'ac' iti, xchi ja rico huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jaxa Abrahami ti yalaa: Hijo, a jac ja hua c'ujoli. Jel lec ec' ahuuj ja yora ti aya ba luumi pero ja Lázaro, jel ajul ja sbaj soc ja xchamel eq'ui. Pero ja huego sc'ulan ta recibir ja svida ba jel tzamali, jaxa hueni huana lec huocol. ");
INSERT INTO tojNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jach huaxa huala pero mey modo porque ay jun nihuan uc'um ja ba jnalantiqui. Ta ay c'a ma' huas sc'ana huajuc ja tihui, mix bobi soc mi ni ja huenlexi, mix bob oj jacanic, xchi ja Abrahami. ");
INSERT INTO tojNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Entonces ti yala ja ricoa: Oj c'an ahui pavor ta jach tat Abraham, jeca qui ja Lázaro ja ba snaj ja jtati. ");
INSERT INTO tojNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ja tihui ay to ni joe quermanoa. A huaj yal yabi siquiera moc jacuque ja ba lugar ili porque jel tzatz juntiro ja huocoli. A yal yab que a suchuc ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ti yala ja Abrahami: Ja yenlei tey ba sc'abe ja jas stz'ijbunej can ja Moisesi soc ja aluman‑Dios jumasa pero mix yaahue caso. ");
INSERT INTO tojNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ti yala ja rico: Meran, tat Abraham, pero ta huan c'ax huaj junuc ja ma' cham ta, bob ta oj suchuc ja sc'ujolei, xchi ja rico jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ti yala ja Abrahami: Mi tox yaahue caso ja Moisesi soc ja aluman‑Dios jumasa, ¡jauc to ma oj squitz'e ja ma' cham ta, anima xeeji yile entero cristiano! xchi ni ja Jesusa. ");
INSERT INTO tojNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ja Jesusi ti yal yab ja secabanum jumasa: ―Mi oj sc'ul palta jastal oj slee ja smul ja cristiano pero ¡pobre ja yen ja ma' gana huax ya slee ja smul ja smoji! ");
INSERT INTO tojNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas lec, a cajan jun sc'ab cha' ja ba spat s'olomi, tix jipji co ja ba yoj mari porque quechan huax ya slee ja smul ja ma' jel to yaau ay ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Aa cuidadoex. Ja hua moj creyenteili, ta ay c'a jas huas sc'ulan ahui malo, ti la huaja. Lea modo jastal oja hual yabi. Ta huan c'a sc'ana hui perdón con todo sc'ujol, pues c'ulan perdonar. ");
INSERT INTO tojNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Anima jach huas sc'ulan ahui juque vuelta ba c'ac'u: Pero mi xa oj to jc'uluc ahui otro vuelta, ta xchi c'a, pues sbej ni oja c'ul perdonara, anima cada vuelta huax yala huab que mi xa oj to sc'uluc. ");
INSERT INTO tojNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jaxa jecabanum jumasa cuando yabye ja iti, ti yalahuea: ―Aa quiticon mas ja quipticon ba. ");
INSERT INTO tojNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ti yala ja Jesusi: ―Q'uelahuilex ja sbac' mostaza. Jel ch'in juntiro pero ta huan c'a xa c'uanex ja jastal ja xch'inil ja sbac' mostaza, oj bob ahualex yab ja moraxte iti: Elan ja ili, tix huaj atz'ap ja hua huech ja ba yoj mari, jaxa te' jahui ti oja huil que oj sc'uuquex. ");
INSERT INTO tojNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","June ja huenlexi, ta ay c'a huiojex jun mozo, jaxa mozo jahui snajtil ja c'ac'u huan atel. Huan jutuj luum. Huan stalnajel huacax, jaxa huax jul ja och c'ac'u ba hua naji, mi ni modo oja hual yabi: La xa culanan. Oj xa huaan, mi oja huute. ");
INSERT INTO tojNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Miyuc, oja hual yabi: Chapa baj. Oja tojbes qui ja juaeli porque jel huain xcabi. A ec' qui ja jcajpei. Cuando huax ch'ac huaacon ja queni, ti oj huaan ja huena, oja huutex ja hua mozoexi. ");
INSERT INTO tojNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ja mozo jahui sbej ni oj sc'uluc ja jas oja hualex yabi y mi sbejuc huaxa huaa yi stz'acatal. ");
INSERT INTO tojNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jachuc ja huenlex soc ja Diosi. Smozoex nia. Cuando huax ch'ac ac'uluquex spetzanil ja jas huax yala huabyexi, ti oja hualexa: Como smozootic nia. Sbej ni jach jc'ulantica. Jach oj chianic. ");
INSERT INTO tojNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ja Jesusi cuando ti xa ay ba bej cuando huan huajel ja ba Jerusaleni, ti ec' ja ba scol ja lugar Samaria soc ja lugar Galilea. ");
INSERT INTO tojNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Cuando oj xa c'otuc ja ba jun yal hacienda, ti huaj tajuc yuj lajune huinic ja ma' ay yioj ja chamel jau huax c'a ja sbactelei pero como mix bob mojhuanuque, jayuj ");
INSERT INTO tojNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ti ahuaniyea: ―Maestro Jesús, talna jyaujulalticon ja quenticoni, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ja Jesusi cuando yabi, ti sq'uela ocha: ―Cax jea bajex yi ja pagre jumasa, x'utjiye yuj ja Jesusi. Ti huajyea. Cuando ti xa aye ba beji, huaj to snaa sbaje, ch'ac ta tojbuque spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Entonces june ja yenlei, yajni yila que tojbi ta, ti cumxia. Huan yaajel yi stz'acatal ja Diosi, pero ahuanel. ");
INSERT INTO tojNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ti co mec'an ja ba sti sat ja Jesusi pero huan oq'uel yuj ja sgusto. Iday, ja huinic jahui mi judiouc. Samariteño nia. ");
INSERT INTO tojNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ti yala ja Jesusi: ―¿Mi ma lajunhuaneuquex huiniquex tojbiyex ba? Jaxa balune huinique jau ja hua moji, ¿bay baa? ");
INSERT INTO tojNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ja huinic iti, mi quintiluctic. Tuc raza ni ay ja yena pero cumxi ba oj yaa yi stz'acatal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ti yal yab ja huinic jahui: ―Q'uean xa. Cax xa. Tojbiya ta yuj ja hua c'uani, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ja fariseo jumasa ti och sobe yi ja Jesusi jas ora oj jac sc'ul mandar ja Diosi. Ti yala ja Jesusi: ―Cuando huax jac sc'ul mandar ja Diosi, mi xa hualahuex ta oja huilex. ");
INSERT INTO tojNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mi ni ma' oj bob yal ta ti huan sc'ulajel mandar ja ili ma ti huan sc'ulajel mandar ja tihui porque ja ma' oj sc'ul mandari, ti xa ni ay amoquex ja huenlexa. ");
INSERT INTO tojNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ti yal yab ja snebumani: ―Q'uelahuilex, ja queni ti coelon jan ja ba satq'uinali pero oj jac ja c'ac'u cuando oja hualex: Siquiera juneuc xta nique c'ac'u oj quiltic ja jastal huax quilatic ajyi pero mi xa ni oj to ahuilexa. ");
INSERT INTO tojNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pero ay ma' oj yala huabyex: Ja Cristo ti xa ay ba lugar iti, oj chiuc, ma oj cho yala huabyex: Ja Cristo ti xa ay ba lugar jahui. Pero moc lom huajanic ja ba huax yalahuei. Moc lom ac'uuquex ja cristiano jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porque ja c'ac'u oj cocon ja ba satq'uinal ja queni, oj lijpucon juntiro ja jastal huax lijpi ja chamtzelahui. ");
INSERT INTO tojNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero ja tiempo jumasa ja iti oj ni qui lec ja huocola. Ja cristiano jel coraja oj yilone. Mi ni ma' oj yion leca. ");
INSERT INTO tojNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jaxa cuando mojan xa oj cho cocon jan ja ba satq'uinali, jach ni oj cho ajyuc ja cristiano jumasa ja jastal ja jun lame cristiano ec' ja ba stiempo ja Noeji. ");
INSERT INTO tojNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ja yenlei, como siempre smodo jastal culan yujilei, huax nupaniye, huax ya nupanuque ja yuntiquilei, huax huaaye, huax yuaje ja'. ");
INSERT INTO tojNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jach ni chomajquil ja jun lame cristiano jau ja stiempo ja Loti. Huax huaaye, huax yuaje ja', huas smana ja sastic sbajei, huax cho xchonohue, huas stz'unu ja yalajei, huas sc'ulan ja snajei. ");
INSERT INTO tojNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero cuando el ja Lot ja ba chonab jau ja ba Sodoma, ti co jan ja c'ac'al taan ja ba satq'uinali, socan soc azufre. Jaxa ora jahui, ch'ac ni cham spetzanil ja suinquil ja chonab jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jach oj ajyuc ja c'ac'u oj cho cocon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ja c'ac'u jahui, ta ay c'a ma' ti t'ucan ja ba s'olom ja naitzi, jaxa sastic sbaji tey ba yoj naitzi, moc xa lom co ya eluc. Jaxa ma' tey ba huitzi, moc xa lom cumxuc ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Naahuic t'unuc ja jastal huaj ja xcheum ja Loti. ");
INSERT INTO tojNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ja ma' huajel sc'ujol quechan yen huas syajta sbaj yen mismo pero ja mas tzaani oj ni ch'ayuc ja yaltzila. Pero ja ma' huas syajta ja smoj jastal huas syajta sbaj ja yen mismo, ja mas tzaani, mi ni ni oj ch'ayuc ja yaltzila. ");
INSERT INTO tojNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Huax cala huabyex, ja acual jau oj jaconi, chab cristiano huane huayel jun ta ch'at. Ja juni oj ni iijuca, jaxa juni, oj aajuc cani. ");
INSERT INTO tojNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chahuane ixuque huane chenel jun ta aq'uinte. Ja juni oj ni iijuca, jaxa juni, oj aajuc cani. ");
INSERT INTO tojNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chahuane huinique tey ba huitz. Ja juni oj ni iijuca, jaxa juni oj aajuc cani. ");
INSERT INTO tojNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Cuando yabye ja jastal iti, ti yalahuea: ―Pero ¿jas bej jach oj ec'uc ba Cajual? xchiye. Ti yala ja Jesusi: ―Ja' ni yuj ja ti sacbanban oj ajyuc ec' ja scuerpo ja cristiano. Quechan ni ti huan poc'oljuc ec' ja useja. ");
INSERT INTO tojNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ja Jesusi ti yala jun loila. Jach yala ba mi oj yae can ja sc'umajel ja Diosi soc ba mi oj el sganae: ");
INSERT INTO tojNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Q'uelahuil ba jun chonab tey ja juezi. Ja yeni mi ni t'un huax xiu yuj ja Diosi soc mi huas soyba ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ja ba mismo chonab jahui ay jun ixuc viguda ay. Ja yeni tola vida huax huaj parte soc ja juez jahui. Huas sc'ana oj tojbesjuc soc ja scondra. ");
INSERT INTO tojNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero ja juezi jitzan vuelta mi yaa yi caso pero ja mas tzaani ti sc'ulan pensara: Eso sí, ja queni mix caa yi caso ja Diosi, ¡jauc to ma cristianoa! ");
INSERT INTO tojNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero jaxa men viguda iti tola vida huan tox huaj quile, ti xa ay jul ja ba jnaji. Mas ma lec oj colta ba mi huahuanto oj jacuc ja ba jnaji. Mi c'a, repente oj q'ue jcoraja soc, xchi ja juezi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti yala ja Cajualtiqui: ―Ata huabil ja jas yala ja juezi iday, jel malo pero scolta ni ja viguda jahua. ");
INSERT INTO tojNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¡Jauc to ma Dios que mi oj ni scolta ja ma' tzaubal ni yujili! Ta huane c'a parte c'ac'u acual, mi xa huala mi baq'uin oj stojbes. ");
INSERT INTO tojNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Huax cala huabyex, huego oj stojbes. Pero yajni huala coyon jan otro vuelta ja ba satq'uinali, mi naben ta ay to cristiano ja ma' huas sc'uan ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ja Jesusi ti cho yala otro jun loila. Jayuj yala jachuc ba oj ya smacchiquinuc ja ma' jel huas stoyo sbaje, jaxa smoj jumasa, lajan soc mi smojuc cristianoil huax yilahue: ");
INSERT INTO tojNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Q'uelahuil, chahuane huinique huaj sc'umuque ja Dios ja ba templo. Ja juni fariseo, jaxa juni colector, ja' ni june ja ma' huas stzomo ja taq'uini. ");
INSERT INTO tojNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ja fariseo ti och tec'ana. Och sc'umuc ja Diosi pero yen ta huan sc'umajel sbaj. Ti yalaa: Dios, huax c'ana hui tz'acatal porque ja queni mi lajanucon soc ja tuqui. Mi la elc'aniyon. Mi maloucon. Mi huax lea jmul soc ixuc soc mi ni t'usita jmojuc ja tan colector jau lom huax ya eluc ja taq'uini. ");
INSERT INTO tojNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cada semana huax como chab vuelta ja juaeli, jaxa jas huax c'ulan ganari huax pila hui lajune cada cosa tac, xchi ja huas sc'uman ja Dios ja fariseo jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jaxa colector jahui can najat. Ti och tz'inana. Ti stela ja sc'abi. Och sc'umuc ja Diosi: A Dios, talna jyaujulal porque ja queni jel ja jmuli. Jach yala ja colector jahui cuando huan sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ti yala ja Jesusi: ―Huax cala huabyex, ja colector jahui, cuando cumxi ja ba snaji, c'ulaji ta ni perdonara, jaxa fariseo, mi ni c'ulaji perdonara. Como jach nia. Ja ma' jel nihuan huax yaa sbaji, jel ch'in oj aaji huajuc, jaxa ma' jel ch'in huax yaa sbaji, jel nihuan oj aaji huajuc. ");
INSERT INTO tojNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ja Jesusi ti iiji jan yi ja yal untiqui ba oj syam ja s'olomei pero cuando yila ja snebuman jumasa, ti scomohuea. ");
INSERT INTO tojNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ja Jesusi ti spaya jan ja snebumani. Ti yalaa: ―Lec ja huax jacye ja yal untiqui. Mi lom xa comohuex porque ja jastal ja sc'ujol ja yal untic iti, jach ni ay ja sc'ujole ja matic yaunej sbaj ja ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Huax cala huabyex, pero meran, mi c'a la ch'inbiyex jastal jun yal untic cuando huaxa huaa bajex ja ba sc'ab ja Diosi, mi ni modo oj bob ochanic soc ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","June ja huinic ja ma' ay yateli ti soboa: ―Maestro, jel leca juntiro. Ala cab jasunc'a lec oj c'uluc oj quil ja vida jau ba jel lequi ba mi ni nunca huax ch'aqui. ");
INSERT INTO tojNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","―¿Jasyuj huaxa huala cab que jel leconi? Mi ni june ma' lec, quechan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ja hueni huaxa naa ja mandar jumasa, que mi oja lee amul soc ja ixuqui, mi oj milhuanan, mi oj elc'anan, mi lom q'uiq'uinal oja lee ja smul ja hua moji. Yaj oja huab ja hua nan atati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ti yala ja huiniqui: ―Pero jach ni huax c'ulan man jch'inila, xchi ");
INSERT INTO tojNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yajni yab ja Jesús ja jastal iti, ti yalaa: ―Pero ay to jas huas sc'ulan ahui palta. Cax chono can spetzanil ja jastic ahuioji. Aa yi ja pobre jumasa. Jach c'a huaxa c'ulan, jel ja jas oj aajuc ahui ja ba satq'uinali. Cax c'ulan jachuc, ti la jac jmoca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero ja huiniqui, cuando yab ja jas ch'ac aljuc yabi, tristeaxi juntiro porque jel ja jastic sbaji. ");
INSERT INTO tojNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ja Jesusi cuando yila tucbi ja smodo, ti yalaa: ―Ja ma' jel ja jastic sbaji, jel huocol juntiro oj yaa sbaj ja ba sc'ab ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas mi huocoluc oj ec' jun camello ja ba sotol ja tz'istaq'uini que soc oj yaa sbaj ba sc'ab ja Dios jun rico, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jaxa matic ch'ac yab ja jas yala ja Jesusi, ti yalahuea: ―Entonces ¿machunc'a oj bob el libre soc ja smul ba? ");
INSERT INTO tojNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","―Ja cristiano mi ni oj bob yujila pero ja Diosi oj ni bob yujila, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ti yala ja Pedro: ―Entonces ¿jaxa quenticon ba? Caunejticon can spetzanil ja jastic quiojticoni ba oj ajyucoticon amoc Cajual. ");
INSERT INTO tojNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ti yala ja Jesusi: ―Pues oj cala huabyex ja smeranili. Spetzanil ja ma' yaunej can ja snaji, ma ja snan stati, ma ja yermano jumasa, ma ja xcheumi, ma ja yuntiquili, ta ja' c'a huax yaa can yuj ja huas sc'ana yaa sbaj soc ja Diosi, ja jahui, mi ni lomuca. ");
INSERT INTO tojNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Ja ba mundo iti oj ni sc'ul recibir mas de snalan que soc ja janec' yaa cani, jaxa ba otro mundo oj sc'ul recibir ja vida jau ba jel lequi soc ba mi ni nunca huax ch'aqui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ja Jesusi ti ch'ac spay ja ba stz'eel ja snebuman jumasa. Ti yalaa: ―Q'uelahuilex, ti xa huajumotic ja ba Jerusaleni. Ja tihui oj c'ot smeranil spetzanil ja jas stz'ijbaye can ja aluman‑Dios jumasa ja jastal oj ni ec' cujili. Ja queni ti ni coelon jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pero oj c'ulajucon endregal ja ba sc'ab ja tzeil cristiano. Oj aajuc qui jitzan burla. Oj yixtalaucone. Oj stzujbaye ja jsati. ");
INSERT INTO tojNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Oj smac'one. Man oj smilone pero ja ba yoxil c'ac'u oj sac‑huucon. ");
INSERT INTO tojNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ja snebuman jumasa mi ni t'un yabye sbej ja jas yala. Mi snaahue jasunc'a huax alji yabyei. Lajan soc juntiro macji ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Mojan xa yioj ja Jesús ja ba chonab Jericó. Huaj to yile, ti culan ec' jun huinic tupel sat ba sti bej. Huan sc'anjel limosna. ");
INSERT INTO tojNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Cuando yab huan xta cululuc huan eq'uel ja cristiano jahui, ti sobo jasyuj ja jel ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ti alji yab que ja' huan eq'uel ja Jesús nazareño. ");
INSERT INTO tojNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ti och ahuanuc tzatz leca: ―¡Jesús yintila rey Davidi, talna jyaujulal ba! xchi xta. ");
INSERT INTO tojNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jaxa cristiano ja ma' bajtan ayi ti huas scomohuea pero lajan soc alji yab ba oj ahuanuc mas tzatz: ―¡Yintila rey Davidi, talna jyaujulal ba! xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ti c'ot tec'an ja Jesusi. Ti seca spayjela. Cuando ti xa ay ba stz'eeli, ti sobo yia: ");
INSERT INTO tojNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Jasunc'a huaxa c'ana oj c'uluc ahui ba? xchi. ―Cajual, huax c'ana oj quil q'uinal. ");
INSERT INTO tojNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ti yala ja Jesusi: ―Lec, yuj ja hua c'uani, oj xa ni tojbana. ");
INSERT INTO tojNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iday, huego huego yila q'uinal. Ti huaj nochan soc ja Jesusi. Huan xta sc'anjel yi stz'acatal ja Diosi. Jaxa spetzanil ja cristiano, cuando yilahue jastal tojbi ja huinic jahui, jel huax cho stoyohue ja Dios ja yenle chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ja Jesusi ti c'ot ja ba chonab Jericó. Ti huan bejyel ec' ja ba yoj chonabi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ay jun suinquil ja chonab jahui, Zaqueo sbiil. Ja huinic jahui jel rico, como yen huas sc'ulan mandar ja ba colecturía ja ba huax tzomxi ja taq'uini. ");
INSERT INTO tojNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jaxa yajni yab que tey ba yoj chonab ja Jesusi, jel sgusto huas sc'ana oj yil ja sati pero mix bob yujil porque jel ja cristiano, jaxa yeni, jel yal tzapito. ");
INSERT INTO tojNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jayuj ti ec' ajnel bajtana. Ti q'ue huego jun steil moraxtea ba oj bob yile, yuj ja ti ni bi oj ec'uc ja Jesús ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jaxa Jesusi cuando ec' ja tihui, ti sq'uela q'ue ja ba tei. Ti yila ti t'ucan ec' ja Zaqueo. Ti yalaa: ―Zaqueo, coan jan huego porque ja huego ti oj jijlucon ja ba hua naji, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jaxa Zaqueo ti co jan huegoa. Jel sgusto yiaj och ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jaxa cristiano jumasa, cuando yilahue ba oj huaj jijluc ja Jesusi, ti yochele xta c'umal ja ba ja' mi jauqui: ―Q'uelahuile, ti huax huaj ja ba snaj ja tan mulanum jahui, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jaxa Jesusi soc ja smoji cuando c'otye ja ba snaj ja Zaqueo, ti ochye culana. Jaxa Zaqueo ti q'ue tec'ana, ti yalaa: ―Q'uelahuil Cajual, ja jastic jbaji oj caa yi snalan ja pobre jumasa. Ta ay c'a ma' jlolonej satalajel abal, oj ni ca cumxuc yile chane vuelta mas, xchi ja Zaqueo. ");
INSERT INTO tojNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jaxa yajni yab ja Jesusi, ti och yal yab ja ma' tey ba yoj naitzi: ―Ja yaani jac ta c'ulajuc librar ja suinquil ja naitz iti. Ja huinic iti lajan soc ja' to ni yintil chomajquil ja Abrahami. ");
INSERT INTO tojNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jayuj coyon ni jan ja ba satq'uinal tac. Jac jlee ja ma' ch'ayeli ba oj colta, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jaxa cristiano ti huane smaclajel ja jas huan yaljel ja Jesusi. Huax yalahue que jel xa mojan ja c'ac'u oj aajuc och yatel ja Jesusi. Jaxa Jesusi, como mojan xa ay ja Jerusaleni soc huas snaa jastal huan c'umal ja sc'ujol ja cristiano, jayuj ti och yal jun loila: ");
INSERT INTO tojNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","―Q'uelahuil jun huinic, Ja yeni spetzanil ja ma' ec' pax ta yujili, xchojlal ch'ac och yatele. Jachuc ja yeni ti huaj ba jun najtil lugar lec ba oj aaji och reyil, ti xa bi oj cumxuc ja ba mero slugari. ");
INSERT INTO tojNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero ja mi tox huaji, ti spaya jan lajune ja smozo ba oj yaa can yile ja staq'uini y jel aay yaa can yi cada jujune. Ti yal yabyea: Q'uelahuilex, oj xa huajcon pero ja taq'uin it huax caa huilexi, atjananic soc, xyutaj ja smozo jumasa. Ti xa huaj ja huinic jahua. ");
INSERT INTO tojNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero ja suinquil ja slugar ja ajualal jahui, jel coraja yilahue. Ti secahue jun comisión ba oj huaj yale yab que mi huas sc'anahue oj och sreyil. ");
INSERT INTO tojNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero ja huinic jahui aaji ni och reyila. Ja mas tzaani, ti cumxi ja ba slugari. Cuando c'oti, ti seca spayjel ja smozo jumasa, ja ma' yaa can yi ja taq'uini. Huas sc'ana oj snaa janec' sc'ulane ta ganar cada jujune. ");
INSERT INTO tojNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ja ma' bajtan jaqui ti yalaa: Cajual, ja hua taq'uini alini ta cuj otro lajune tanto ja minai, como jach ni sbiil ja staq'uinei. ");
INSERT INTO tojNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","―Pues jel lec. Mero lequil mozoa. Ja janec' t'usan caa huii, jel lec ja jas hua c'ulan soqui, jayuj ja huego oja c'ul mandar lajune chonab, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ti cho jac ja otro juni, ti yalaa: Cajual, ja hua taq'uin ahuaa can quii alini ta cuj otro joe tanto, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","―Jachuc ja huen, oj cho ac'ul mandar joe chonab, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ti cho jac ja otro juni: Cajual, oj xa caa hui endregal ja hua taq'uin it ahuaa quii. Jpotzo can ba jun mojchilal ");
INSERT INTO tojNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Porque huala xiuyon ahuujil. Huax naa que c'ac'al huinica. Ja hua modo ni toj jotzuanel ja hua gustoi. Pavor huaxa huiaj sbaal ja hua hualaji. Mi ahuateluc ja huena, xchi ja mozo jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","―¡Ay mozo, jel malo juntiro ja hua c'ujoli! Yuj ja jas el ja ba hua tii, jayuj oj ch'ac jap ahui ja janec' ahuioji. ¡Entonces huax quiaj ja ba mi jbajuqui! ¡Pavor huala huaayon ta jachuqui! Mi quenuc huax catelta. ");
INSERT INTO tojNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Entonces ta jachuc, ¿jasyuj mi hua och qui ba banco ja jtaq'uini ba oj c'ul recibir ja yal cuando la cumxiyon ja ba jnaji? x'utji ja mozo jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ja reyi ti yal yab ja ma' tey tihui: Japahuic yi ja taq'uin jahui. Aahuic yi ja ma' ya alinuc diez tanto ja minai. ");
INSERT INTO tojNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ti yalahuea: Pero Cajual, ¡ja yeni ay xa yioj diez mina tac! ");
INSERT INTO tojNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ti yala ja reyi: Pero huax cala huabyex, jach nia. Ja ma' ay ni jas yioji, oj ni aajuc yi masa. Jaxa ma' quechan t'usan yiojei, ja t'usan jahui oj ni japjuc yilea. ");
INSERT INTO tojNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Jaxa jcondra jumasa ja ma' mi sc'ana oj ochcon reyili, iajic jan qui, ti xa milahuex ja ba sti jsati, xchi ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yajni ch'ac ja loil jahui, ja Jesusi ti stulu ja sbeji, como ti ni huan huajel ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Mojan xa yioje ja hacienda Betfagé soc ja Betania, soc mojan xa yioje ja huitz jau sbiil Olivos. Ja Jesusi ti spaya jan chahuane ja snebumani, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Caxic ja ba yal hacienda ja ba mojan xa quiojtiqui. Cuando la c'otyex ja tihui, ti oja taex jun yal burro ti mochantea. Mi to ni ma' huax q'uea. Tucuhuic, ti xa huiajex jan quia. ");
INSERT INTO tojNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ta ay c'a ma' huas sobo huilex jasyuj huaxa tucuhuexi, ti xa hualahuex yaba: Ja' huas sc'ana ja Cajualtiqui, xa huutajex, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ti huajye ja chahuane snebuman jahui. Ti ni staahue ja jastal yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Cuando huane stucjel ja yal burro jahui, ti jac ja suinquil jumasa: ―¿Jas sbej ja huanex stucjel ja yal jburroticoni? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","―Pero oj bi maconuc yuj ja Cajualtiqui, xchi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ti yiaje och yi ja Jesusa. Yaahue bacan ja sc'ue ja ba spatic ja yal burro. Ti xa q'ue ja Jesusa. ");
INSERT INTO tojNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jaxa ba bej ja ba huajum ja Jesusi, ja cristiano ti huane slibjel ja sc'uei como jach ni culan yujile cuando huax yilahue ja ma' jel nihuani. ");
INSERT INTO tojNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Cuando mojan xa yioje ja ba yib huitz sbaj Olivosi, jaxa jun nole ja ma' yaunej xa sbaj soc ja Jesusi ti och ahuanuque yuj ja sgustoei. Huane sc'anjel yi stz'acatal ja Diosi soc ja spetzanil ja milagro yilunejei. ");
INSERT INTO tojNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―¡Viva ja jreytiqui! ¡Ja yeni jecji jan yuj ja Cajualtic Diosi! ¡Jel tzamal laman ay ja satq'uinali! ¡Ja tihui xlijpi xta juntiro! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pero ja ba jun nole cristiano jahui ay chaboxe fariseo. Ti yalahuea: ―Maestro, como t'unuc ja hua nebuman ba. ");
INSERT INTO tojNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","―Huax cala huabyex, ta huan c'ax ch'abajiye ja yenlei, ay ni jas mas oj cho ilxuca. Hasta ja toni oj ahuanuque, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ja Jesusi yila mojan xa ay ja Jerusaleni, ti bojti yoq'uela. ");
INSERT INTO tojNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ti yalaa: ―¡Ay jerusaleño jumasa! Ja tiempo jumasa iti, ay modo jastal nique oj bob aajanic nique laman ajyi. Jel lec ja lec ahuabyex to nique slugarili. Ja yaani mi xax bobi porque ec' ta. ");
INSERT INTO tojNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pero oja huilex oj jacuc ja c'ac'u ja hua condraexi oj soybayex. Lot'obal oj ajyanic. Oj ni snolc'abuquexa. ");
INSERT INTO tojNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sacbanban oj cananic ja ba luumi, jerusaleño jumasa. Oj ni ch'ac miljanica. Ja ba yoj achonabilexi mi ni jun ton oj can latzan pero ja' yujil ja mi ni aquitz'ahuex ta Dios ni ja ma' jac yulatayex ja ba hua chonabilexi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ja Jesusi ti c'ot ja ba Jerusaleni. Ti och ja ba templo. Huaj to yile, tey ja ma' huan xchonjel ja cosa soc ja ma' huan smanjeli. Ti ch'ac snutz el ba fueraa. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","―Ja yabal ja Diosi huax yala ja ba snaji quechan ba huax c'umaxi ja Diosi. Pero ja huenlexi huaahuex ta pax snaj lagronil, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Spetzanil ja chaboxe c'ac'u jumasa jahui, ja Jesusi ti huan seejel ja ba yoj templo pero ja nihuac pagre jumasa soc ja ma' huas sea ja smandar ja Moisesi soc ja ma' ay yatel ja ba chonab jahui ti och xchape yabalila. ");
INSERT INTO tojNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mi ni staahue modo jas oj sc'uluquea porque spetzanil ja cristiano jel ja sgustoei. Huane smaclajel ja jas huan seejel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun c'ac'u ja Jesusi ti huan seejel yi ja cristiano ja ba yoj templo. Ja' huan sloiltajel ja abal it jel tzamali. Ti c'ot ja nihuac pagre jumasa soc ja matic huas sea ja smandar ja Moisesi soc ja banquilal jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ti yalahuea: ―¿Yuj ama ay ahuatel ja huen huaxa c'ulan ja cosa jumasa iti? Entonces ¿ma' yaa hui ja hua huatel ba? x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","―Jachuc ja queni, ay jas huax c'ana job ahuilex, alahuic cabi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ja Juani, ¿machunc'a yala oj sc'ul bautizar ja cristiano? ¿Ja' ma alji yab yuj ja ma' tey ba satq'uinali ma ja' alji yab yuj ja cristiano? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jaxa yenlei ti ochye loil yenle itaa: ―Huan c'ax calatic ja ma' tey ba satq'uinali, entonces oj yal cabtic, entonces ¿jaxa yuj ja mi xa c'uanex ba? oj yutotic. ");
INSERT INTO tojNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iday, ta huan c'ax cho calatic que ja' ba cristiano, spetzanil ja cristiano oj xch'ojotic ton porque ja yenlei mero aluman‑Dios yujile ja tan Juan jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ti yalahue yab ja Jesusi: ―Mix naaticon. ");
INSERT INTO tojNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","―Entonces jachuc ja queni, mi oj cala huabyex ma' yaunej qui ja jas huanon sc'ulajel eq'ui, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ja Jesusi ti och yal yab ja cristiano jun loila: ―Q'uelahuil, jun huinic stz'unu jun yalajil tz'usub. Ti sc'ulan trato soc chaboxe ja ma' oj yatelta ja yalaji, jaxa yeni ti el ja tihui, pero jitzan tiempo huaji. ");
INSERT INTO tojNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ti sc'ulan tantear ja tiempo. Ti seca jun mozo ba oj yii jan ja sbaal ja yalaji pero ja talna‑alaji smac'ahue. Telan sc'ab yaahue huajuc ja mozo jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jaxa suinquil ja yalajil tz'usubi ti cho seca otro ja smozo, pero jachuc ja yeni mac'ji. Xihuel ja sbaj ja jas c'ulaji yii, cho telan sc'ab aaji huajuc. ");
INSERT INTO tojNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jaxa suinquil ja alaji ti cho seca otro smozoa, pero ja' xa ba yoxili. Jachuc ja yeni, cho aaji yajbuc. Ti cho nutzjia. ");
INSERT INTO tojNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ti yala ja suinquil ja yalajil tz'usubi: ¿Jas oj c'ul ba? Oj ma jec ja cunin jel yaj huax cabi. Bob ta oj sc'uluque respectar ja yajni xyilahuei. ");
INSERT INTO tojNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero malaya, yajni ilji sat ja yunini, ti yalahue yenle itaa: Ja iti, yen oj yii can spetzanil ja dote. ¿Jaxa mix milatiqui? Ta cham c'a, quen oj bajuctic ja sdotea, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ti syamahuea. Ti yiaje ba spat alaj. Ti smilahuea. Cuando huax cumxi ja suinquil ja alaj jahui, ¿jas huala chiyex? ¿Jas oj yut ja huinique jau ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Oj cala huabyex jasunc'a oj sc'uluqui. Cuando huax cumxi oj ni ch'ayjuc snaajelea. Tuc ja ma' oj yaa ba sc'ab ja alaj jahui. Cuando yala jachuc ja Jesusi, ti yalahue ja ma' huan smaclajel ja loil iti: ―¡Moc ama sc'an Dios! ");
INSERT INTO tojNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ti tojtoq'ueljiye lec yuj ja Jesusi: ―¿Jasunc'a huax yala ja yabal ja Dios ba? Ay jun oy ba jel tzamali pero ja c'ulanaitzi mi squitz'ahue, iday, jaxa oy jau mi quitzji, ja' mero oj yaa mas yip ja naitzi. ¿Mi ma jach ni huax yala ba? ");
INSERT INTO tojNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jaxa ma' huas sloco yoc soc ja oy jahui, jel ni tzatz oj yii ja yeni, pero ta ja' c'a oy huax moq'ui, polvo ni oj huajuc ja ma' oj co sbaji, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ja nihuac pagre jumasa soc ja matic huas sea ja smandar ja Moisesi ja mero ora jahui, ja' huas sc'ana oj syame ja Jesusi porque jac sc'ujole que yenle ni huax tajiye ti' soc ja loil it yala ja Jesusi pero xiuye yuj ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jayuj ti secahue chaboxe huinique, jaxa huinique jahui oj bi huaj see sbaje que jel leque, ti oj yie loila, entonces jaxa Jesusi mi sc'ulan palta jas oj el sti t'usan. Malan bi soc ja jahui, ti oj sc'uluque endregal ja ba sc'ab ja gobierno ja ma' ay yateli. ");
INSERT INTO tojNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Cuando c'otye ja ba stz'eel ja Jesusi ti yalahuea: ―Maestro, huax naaticon que jel toj ja jas huaxa huala soc ja jas huaxa jea. Mi tzaubaluc ita ja cristiano ja ma' huaxa jea ja sbej ja Diosi. Puro ni smeranil ja jas huaxa huala, ");
INSERT INTO tojNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jayuj jac jobticon ahui, ¿lec ama oj caatic yi contribución ja gobierno César ma miyuc? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jaxa Jesusi huego snaa que xchabil lado aye. ―¿Yuj ama jac ac'uluconex probar ba? ");
INSERT INTO tojNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jeahuic qui ja taq'uin ba. Jaxa olomal iti, ¿ma' sbaj? jaxa jas tz'ijbanubal jahui, ¿ma' sbiil? ―Ja' sbaj gobierno Cesari, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","―Entonces ta ja c'a sbaj Cesari, aahuic yi ja César ja sbaji, jaxa jas sbaj ja Diosi, aahuic yi, x'utjiye yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mi ni t'un bob yujile que ay jas oj el sti ja ba sti sat ja cristiano. Mas lec, yen smaca juntiro ja stiei. Huas snaahue que jel toj ja jas yala ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ti c'otye ba stz'eel ja Jesús chaboxe saduceo. Judioe nia pero mi huas sc'uane ta oj to sac‑huuc ja scuerpo ja ma' huax chami. Ti yalahue ja saduceo jumasa jahui: ");
INSERT INTO tojNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maestro, ja Moisesi yala can ta huan c'ax cham jun banquilal y huax yaa can ja xcheumi pero mey yuntiquile, entonces oj bi iijuc ja xcheum ja chamhuiniqui. Ja' bi oj yii can ja ma' nochan soc ja chamhuinic ajyi, jaxa yuntiquil ja yenlei, que oj bi och cuenta que ja' bi yuntiquil ja chamhuinic banquilali. ");
INSERT INTO tojNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ta ay c'a jucuane yermano sbaje, jaxa banquilali nupani pero chami. Mi ni jun yuntiquil cani. ");
INSERT INTO tojNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jaxa xcheum ja banquilali, ta huan c'ax iiji yuj ja ma' nochan soc ja statam ajyi, pero cho cham ja yeni. Mi ni ja yeni, mi yaa can yuntiquil. ");
INSERT INTO tojNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ta jach cho sc'ulan ja ba yoxil ijtz'inali, ta jach c'a ch'ac ec'uque sucuanile, mi ni jun yuntiquil can spetzanilea, ");
INSERT INTO tojNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ja lec ti xax cham ja ixuc jahui, ");
INSERT INTO tojNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jaxa ba otro lado cuando oj sac‑huuc ja scuerpoei, ¿machunc'a mero oj yii ja ixuc jau ba? Porque spetzanil xcheumane ja ba luumi, xchi ja saduceo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ti yala ja Jesusi: ―Meran nia. Ja cristiano ja ba mundo iti huax nupaniye. Huax aaji nupanuque. ");
INSERT INTO tojNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ta jel c'a lec ja sportuna oj c'otuque ja ba otro mundo, ta huan c'ax chamye, jaxa mas tzaan oj sac‑huuque, ja ba mundo tihui mi ni oj nupanuquea soc mi oj aajuc nupanuque, ");
INSERT INTO tojNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porque ja tihui, mi xa ni ma' oj chamuca. Ja ángel jumasa mix chamye, jachuc oj ajyuc ja yenlei. Ta huan c'a sacuiye, yuj ni yuntiquile xa ni ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jaxa ma' huax chamyei, oj ni sac‑huuquea. Jach ni huas sea ja Moisés ja ba yabal ja Diosi ja ba huax taji ti' ja q'uiixi. Ja ba juun jahui yalunej claro ja Moisesi que ja Abrahami, sDios ni ja Diosa. Jach ni ja Isaqui, sDios ni ja Diosa, soc jach ni ja Jacobi, sDios ni ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Jach yala ja Diosi porque mi chameluc ja oxhuane huinique jahui. Ja ba sti sat ja Diosi mi ni ma' huax cham juntiro, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ti yala chaboxe ja matic huas sea ja smandar ja Moisesi: ―Maestro, meran ni ja jas huaxa hualaa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ti c'otye tec'ana. Mi xa ni jas yalahue masa. ");
INSERT INTO tojNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jaxa Jesusi ti cho yalaa: ―Pues ja yenlei huax yalahue que yintil bi ja David ja Cristo. ");
INSERT INTO tojNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pero ja yen mismo ja Davidi huax yala ba libro ba Salmosi: Ja Dios Tatali ti yal yab ja Cajual Cristoi: Quechan ja huen oj ajyuc ja huatel mas tzatz. ");
INSERT INTO tojNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Oj ni caa ba yib ac'ab ja hua condra jumasa, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ja huabyex que yajualan ja Cristo ja Davidi. ¿Jastal ay ja jahui? ¡Pero mi ni huax cajualan jbajtic ja quermano jbajtic tac! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ti ch'ac yab spetzanil ja cristiano ja jas yalai. Ti cho och yal yab ja snebuman jumasa: ");
INSERT INTO tojNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Aa lec acuidadoex soc ja matic huas sea ja smandar ja Moisesi. Ja yenlei ja' sgustoe ja xuecheljiye xta ec' soc ja sc'uei. Soc ja' mero sgustoe oj jac tajuc sc'abe ja ba plaza, jaxa ba yoj yiglesiaei ja' huax huaj slee ja lugar ja ba huax och culan ja ma' ay yateli. Jach ni ja huax huajye ba jun huaelal, ja' mero huas sleahue ja lugar ba mas tzamali. ");
INSERT INTO tojNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jachuc ja viguda jumasa, huas sapahue yi ja snajei pero ba mi oj naajuc ja jas huane sc'ulajeli, ti huax och sc'an yi stz'acatal ja Dios yuj ja viguda jahui pero albel lec huas sc'umane ja Diosi. Ja jau jumasa oj ni yii ja castigo ba mas tzatzi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ja Jesusi ti yila huane yaajel limosna ja rico jumasa. Ti huax ya ochuque ja ba cajón ja ba yoj templo. ");
INSERT INTO tojNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ti jac jun vigudaa. Ja yeni jel pobre pero ya och chab sat taq'uin blanca sbiil yujile. ");
INSERT INTO tojNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ti yala ja Jesusi: ―Ja mero smeranili, huax cala huabyexi, ja viguda iti jel pobre pero mas yaa can ja yen que soc ja tantic rico jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ja yenlei, quechan ja ba sobrae huax yaahue ja slimosnaei pero ja viguda iti, pobre juntiro pero yaa can spetzanil ja janec' yioji. Mi ni ba stz'acol ja suaeli, mi ni yiaj cana, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Como ti ni ay ja snebuman jumasa, ti och yale jastal jel tzamal ja templo. Jel bi tzamal ja stojnali. Jel bi lec ja smajtan ja Dios huan yaajel ja cristiano ja ba oj maconuc ja ba sc'ulajel ja templo. Jayuj ti yala ja Jesusi: ");
INSERT INTO tojNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Eso sí, jel tzamal huaxa huilahuex pero oj jacuc ja c'ac'u mi ni jun ton oj can latzana. Polvo oj ch'ac can spetzanil. ");
INSERT INTO tojNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","―Maestro, ala cabticon jas ora oj ec'uc ja jau ba. ¿Oj ma jnaaticon jas ora oj ec'uc ja it ba? ¿Oj ma ajyuc seña? ");
INSERT INTO tojNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ti yala ja Jesusi: ―Moc ahuaa bajex ba oj lolajananic porque ja ora jahui jel ja ma' oj yii ja jbiili: Quen ja Cristooni, oj chique. Jaxa tuqui: Ja yaani oj xa ni ch'acotica, oj chiuque. Pero moc lomuc ahuaex caso. ");
INSERT INTO tojNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cuando huaxa huabyex huan loiltajel ja guerra, pleito, moc lom xihuanic yuj porque t'ilan ni oj c'ot smeranil ja jastal iti. Pero ja jahui, mi to jauc oj c'ot tic'an ja tiempo. ");
INSERT INTO tojNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ja lugar jumasa puro coraja oj yil sbaje. Ja gobierno jumasa oj ochuque pleito. ");
INSERT INTO tojNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xihuel ja sbaj oj ajyuc ja templori. Jel oj ajyuc ja huaini. Oj ajyuc jitzan chamel ja ba tuctuquil lugari, jaxa ba satq'uinali, oj iljuc ja jas jel oj yaa ja xihueli. Nihuan seña lec. ");
INSERT INTO tojNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero ja mi tox ahuilahuex ja seña jumasa jastal jahui, ja huenlexi oj mochjanic, ti oj iijanic ja ba iglesia jumasa. Oj cho aaji ochanic preso ma oj aaji ochanic ja ba sti sat ja ma' ay yateli soc ja ba sti sat ja gobierno jumasa. Pero ja' yuj ja huaxa c'uanonex ja queni. ");
INSERT INTO tojNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero mi jas oj sc'uluc. Soc ja jas huas sc'ulanei, oj yabye claro lec ja jas huaxa c'uanexi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Naahuic t'usan. Moc lom oja c'uluquex pensar jastal oj c'umananic. Mi jauc oja c'uluquex pensar jastal oja colta bajex ja ora jahui ");
INSERT INTO tojNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque ja quen oj cala huabyex jastal oj c'umananic. Oj ca vivoaxanic, jaxa hua condraexi juntiro oj smac ja sti ja jas oja hualexi. Mi ni oj bob jas oj sc'uluc ahuilexa. ");
INSERT INTO tojNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero ja huenlexi, anima jauc ja hua nan atatexi, soc ja hua huermanoexi, soc ja hua najtil ahuermanoexi, soc ja hua huamigoexi, oj ni yii apatiquexa. Ay ni ma' oj chamuc ahuujilex ja huenlexa. ");
INSERT INTO tojNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lajan soc tz'i oj yilex spetzanil ja cristiano pero ja' yujil huaxa c'uanonex ja queni. ");
INSERT INTO tojNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero anima, porque q'uelahuilex ja stzotzil ja hua olomexi, cuenta ni aya, ¡jauc to ma hualtzilexi! ");
INSERT INTO tojNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ta huan c'ax ec' ahuujilex spetzanil ja huocol jahui, oj ni ataex ja hua vidaex ba jel lequi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Cuando huaxa huilahuex ja Jerusaleni lot'obal xa yuj ja soldado jumasa, yuj ni oj xa ch'acjuque con todo xchonabilea. ");
INSERT INTO tojNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jaxa matic tey ba Judea, mas lec aa xa huajuque ajnel ba huitz. Jaxa matic tey ba yoj chonab ba Jerusaleni, mas lec a eluque ja tihui. Jaxa matic tey ba huitzi, moc xa lom cumxuque ba yoj chonabi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ja c'ac'u jumasa iti ja' oj stup ja smul ja cristiano. Oj ni c'ot smeranil ja jastal ni tz'ijbanubal ja ba slibro ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Jel ajul ja sbaj ja ixuque ja ma' cuchan yuj ja nihuac chameli soc ja ma' ay yioj yal alatz huan chuunel yujili porque ja tiempo jahui jel ni yaj oj jacuc ja huocola. Jun castigo ba jel tzatz juntiro oj yii ja cristiano jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jel ni ja ma' oj chamuc ja ba guerra, jaxa tuqui oj mochjuque. Oj iijuque ja ba spetzanil ja lugari, ti oj aaji ochuque presoa. Jaxa ma' huax can ja ba Jerusaleni oj ni batjuque yuj ja polestero. Ja jmojtic judioili ti oj ajyuque ba sc'ab ja polestero jumasa masan to oj c'ot tic'an ja tiempo oj sc'uluque mandar ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ja tiempo jahui ja ba satq'uinali, oj tucbuc juntiro ja c'ac'u, jach ni ja luna, jach ni ja c'anali pero ja' ni ja seña lec ja jahua. Jaxa ba luumi, ja ba spetzanil ja lugar jumasa oj jom juntiro. Mi oj snaa jas oj sc'uluque ja cristiano. Ja ma' mojan yioj ja mari oj xihuuque yuj juntiro yuj ja sruidoili. Jel tzatz juntiro oj spuctzuc sbaj. ");
INSERT INTO tojNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ja cristiano jumasa oj bobaxuc juntiro yuj ja jel xihuel ja sbaj ja jastal oj to c'otuqui. Ja yip ja Dios ja jel tzatz ay ja ba satq'uinali, oj ni ch'ac syopes spetzanil. Oj ch'ac lospujuc con ja jas tey ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Entonces spetzanil ja cristiano oj yilone oj cocon jan ja ba satq'uinali. Jel tzatz juntiro oj cocon jan ja ba yoj asoni. Jel tzamal oj lijpuc juntiro ja quijlabi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Cuando huaxa huilahuex huax q'ue ja huocol jumasa jahui, tzatz lec la ajiyex. A jachan ja hua pis'olomexi porque jel xa mojan ja ora oj c'ulajananic librari. ");
INSERT INTO tojNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ja Jesusi ti och yal jun loila: ―Q'uelahuilex ja steil ja higo ma chican jas teil. ");
INSERT INTO tojNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuando yaau xa ja spoohuili, huan ni xa naahuex que q'ue ta ni ja stiempo jaa. ");
INSERT INTO tojNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jachuc cuando huaxa huilahuex ja cosa jumasa iti, naahuic t'usan que oj xa jacuc ja Dios ja ma' huas sc'ulan mandari. ");
INSERT INTO tojNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Huax cala, pero meran, ja jun lame cristiano jahui mi oj chamuque masan to huax c'ot smeranil spetzanil ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Anima huax ch'ac ja satq'uinali soc ja luumi, pero ja jas huax cala t'ilan ni oj c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aa cuidadoex mi xa huaahuex yi lugar oj c'anc'onuc ac'ujol soc ja jas ay ja ba mundo iti. Aa cuidado soc ja yuujel trago. Mi lom ja' oj huaj ac'ujolex ja hua vidaex ba mundo. Ta mi xa huaa cuidadoex soc ja jahui, oj ch'uybuc ja hua c'ujolexi porque cuando mi jauc huaxa c'ulanex pensari, huan tox huaj ahuilex, ti xa ay jul ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Lajan soc jun pojhuic' jun ta ch'ayc'ujol huax co trampa. Jach oj co spetzanil ja ma' ay ba xchanil xchiquin ja satq'uinali ja c'ac'u oj couc ja castigo. ");
INSERT INTO tojNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jayuj q'uelan jacan ajyanic ja huenlexi. C'umanic ja Dios tola vida. C'anahuic yi pavor ba oj scoltayex soc spetzanil ja jas oj to jacuqui soc ba oj bob ochanic ja ba sti jsati como oj to ni cocon jan ja ba satq'uinali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ja Jesusi ti huan seejel ja ba templo ja sat c'ac'u, jaxa acuali, ti huax huaj ja ba huitz Olivosi. ");
INSERT INTO tojNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jaxa huax el ja c'ac'u ti huax jac spetzanil ja cristiano. Huax jac smaclaye ja yabal ja jas huan seejel ja ba yoj templo. ");
INSERT INTO tojNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jel xa mojan ay ja syalq'uinal ja judio jumasa. Culan ni yujile ja q'uin jahui huas sueahue ja pan mey slevaduraili. ");
INSERT INTO tojNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ja nihuac pagre jumasa soc ja matic huas sea ja smandar ja Moisesi huas sleahue modo jastal oj bob smile ja Jesusi pero mi nix bob yujilea, como huane xihuel yuj ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Entonces ja Satanasi ti jac ja ba stz'eel ja Judas ja ma' huax aaji sbiiluc Iscariote. Ja yeni ja' ni june ja lajchahuane snebuman ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ja Judas jahui ti huaj sc'umuc ja nihuac pagre jumasa soc ja matic huas sc'ulane mandar ja ba yoj templo. Ti och xchape yabalil jastal oj bob syame ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jaxa yenle ja matic tey ba templo, jel gusto yabye juntiro. Ti yalahue que oj bi yae yi taq'uin ja Judasi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ti sc'ulane tratoa. Jaxa Judasi ti och slee modo jastal oj bob sc'ul entregar ja Jesusi pero nac'ul abal. ");
INSERT INTO tojNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ti c'ot ja sc'ac'uil ja q'uin it huas sueahue ja pan it mey slevaduraili. Ja c'ac'u jahui culan yujile huas smilahue jun chej cada syalq'uinal ja ba smajtan ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ja Jesusi ti seca ja Pedro soc ja Juani. Ti yal yabyea: ―Caaxic. Cax tojbesic ja ba oj huaacotiqui porque ja' xa mero syalq'uinal ja yaan c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","―¿Ba huaxa c'ana oj chapticon ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jaxa Jesusi ti yalaa: ―Cuando ti xa ayex ja ba sti ja chonabi, ti oja taex bej jun huinic q'uechan xch'ub. Nochohuic man oj och c'ot ja ba naitzi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jaxa suinquil ja naitz jahui oja jobex yi bay ja cuarto jau ba nalan chaani. ¿Ba bi oj sc'ux ja xchejil ja syalq'uinal ja Maestro soc ja snebuman jumasa? utajic. ");
INSERT INTO tojNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jaxa yeni oj sea huilex jun nihuan cuarto ba nalan chaani, chapan xa. Ti oja tojbesex leca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti huajyea. Ti ni staahue ja jastal ni alji yabye yuj ja Jesusi. Stojbese ja ba oj ec' yujile ja syalq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cuando ja' xa ni yorail ja suaelei, ja Jesusi soc ja snebuman jumasa ti ochye ba mesa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ti yala ja Jesusi: ―Jel gusto juntiro huax cab ja lajan huantic huael ja syalq'uinal iti porque oj xa ni chamcona. ");
INSERT INTO tojNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Huax cala huabyex quechan xta último vuelta lajan huantic huael ja huego. Oj to cho huaacotic lajan pero cuando ti xa ayotic ja ba huas sc'ulan mandar ja Diosi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ja Jesusi ti syama ja vaso but'el yalel tz'usub. Sc'ana yi stz'acatal ja Diosi, ti yalaa: ―Iajic ja iti. Uc'anic apetzanilex. ");
INSERT INTO tojNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porque huax cala huabyex mi xa oj to cu otro vuelta ja yalel ja tz'usubi masan to cuando oj sc'ul mandar ja Dios oj stzom spetzanil ja yuntiquili. ");
INSERT INTO tojNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ti syama ja pani. Ti cho sc'ana yi stz'acatal ja Diosi. Ti xet'aa. Ti yaa yi ja snebuman jumasa. Ti yalaa: ―Ja iti, ja' ni ja jcuerpo oj caa yuj ja huenlexi. Cuando huaxa hueahuex otro vuelta, a jac ac'ujolex jastal caa jbaj con todo jcuerpo yuj ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jach ni cho sc'ulan soc ja jun vaso yalel tz'usub. Yajni ch'ac huauquei, ja Jesusi ti syama ja vaso jahui, ti yalaa: ―Ja jun vaso yalel tz'usub iti, ja' xa ni ja jchiq'uela. Ja Diosi sc'ulunej jun yajc'achil trato soc ja huenlexi, ja' cuando xpec' ja jchiq'ueli oj bi huajanic libre soc ja hua mulexi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Porque ja ma' oj ni sc'ulucon endregali ti ni culan ec' jmoc lajan ja ba mesa iti. ");
INSERT INTO tojNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Meran, ti ni coelon jan ja ba satq'uinali pero oj ni chamcona como t'ujpinubalon ni ba oj chamcona pero ¡pobre ja huinic jau ja ma' oj sc'ulucon endregali! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jaxa snebuman jumasa ti och sob sbaje yenle itaa: ―¿Mach ama junuc ja oj sc'uluc ja jahui? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ja snebuman jumasa ja Jesusi ti q'ue sloilea: ―¿Ay ama junuc ja quentic ja ma' mas nihuan huax ilji? ¿Jas la chiyex ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ti yala ja Jesusi: ―Q'uelahuilex, ja matic mi judiouqui, ja ma' ay yatel yujilei, lajan soc huax och ajualalil. Jaxa cristiano jumasa tey ba sc'abei, anima mi tzamaluc ja jas huas sc'ulane ja ma' ay yateli, pero huan nix c'anji yile stz'acatala. ");
INSERT INTO tojNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero ja huenlexi moc lom jach ajyanic ja jastal jahui. Ja ma' mas jel huas snaa ahuujilexi, oj see sbaj que mi jas huas snaa, jaxa ma' mas nihuan ja yateli, eso sí, ay yatel pero jach oj see sbaj jastal ja ma' huan c'ulajel mandari. ");
INSERT INTO tojNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Machunc'a ja mas nihuani? ¿Ja' ama ma' huax aaji ec' jan yi ja suaeli ma ja' huan slechjel jan ja huaelali? ¿Mi ma jauc ni ja ma' huan smajlajel ja suael huax aaji ec' jan yi ba? Iday, ja queni lajanon soc ja ma' huas slecha jan ja huaelali. ");
INSERT INTO tojNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Spetzanil ja huocol eq'uel cuji, ja huilunejex nia. ");
INSERT INTO tojNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jayuj oj caa ja hua huatelex como jastal ja jTat yaa qui ja catel ja queni. ");
INSERT INTO tojNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jaxa ba oj to jc'ul mandar ja queni, ti oj huaacotic lajana. Ja tihui oj aajanic ochanic juezil. Oja tojbesex ja lajchau c'ole ja jmojtic israeleño jumasa, x'utjiye yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ti cho yala ja Cajualtiqui: ―Simón, q'uelahuile. Ja Satanasi sc'anunej licencia ba oj yaa huilex jun huocol, pero tzatz lec. Mi oja naex ba oja huiex ic'a. ");
INSERT INTO tojNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero jc'ana ta yi ja Diosi ba mi oj ch'ay ac'ujol ja jas huaxa c'uani. Pero cuando huala cumxi jmoc otro vuelta, ti xa colta ja hua huermano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ti yala ja Simoni: ―Pero Cajual, puesto ayon oj ni huajcon amoca, anima huax aaji ochcon preso. Puesto ayon oj chamcon amoc lajan. ");
INSERT INTO tojNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","―Pedro, huax cala huabi ja yaan acuali, ja mi tox oc' ja gallo, oxe vuelta oja hual que mi xa naa jbaj, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ti cho yala ja Jesusi: ―Cuando jecahuex sin morrali, ja it yora mi ni jun centavo ahuiojexi soc mi ni ja hua xanabexi, ¿ay ama jas sc'ulan ahuilex palta ba? ―Pues, mi ni jas sc'ulan quiticon palta yena, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ti yala ja Jesusi: ―Pero ja yaani chapa bajex lec porque oj xa ni ahuilex ja jas oj ni ec'uqui. Ja ma' ay smorrali, a yie soc a yii ja staq'uini. Jaxa ma' mey smachiti, anima jauc ja xchompa oj xchoni, a sman ja smachiti. ");
INSERT INTO tojNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porque huax cala huabyex t'ilan ni oj c'ot smeranil ja jastal ni tz'ijbanubal ja ba yabal ja Diosi. Huan nix yala que oj ni aaji jmojuc ja ma' jel malo. Como jach ni tz'ijbanubalona, jayuj t'ilan ni oj c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ti yala ja yenlei: ―Cajual, ay ni quiojticon chab machita. Ti yala ja Jesusi: ―Pues lec, malan soc. ");
INSERT INTO tojNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ja Jesusi cuando el ja tihui, ti huaj ja ba huitz Olivos, como jach ni culan yujila. Ti ch'ac huaj nochan ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ja c'otye ja ba huitz jahui, ti yala ja Jesusi: ―C'umanic ja Diosi ba mi oja lee ja hua mulexi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jaxa Jesusi ti spila sbaj jun maq'uea. Ti co mec'ana. Och sc'umuc ja Diosi: ");
INSERT INTO tojNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Tatey, ta jach huaxa c'ana, a ec' qui ja huocol iti, pero mi jauc ja jas huax c'ana ja queni pero ja' ni ja jas huaxa c'ana ja hueni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Huaj to yile, ti co jan jun ángel ja ba satq'uinali. Jac aajuc yi mas ja yipi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Pero juntiro syatz'a sbaj ja yaltzili. Ti och sc'an yi mas stz'acatal ja Diosi. Jaxa sticahui huego huego el yoc. Lajan soc chic' huax t'ujpiji man luum. ");
INSERT INTO tojNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yajni ch'ac sc'umuc ja Diosi, ti q'uea. Huaj ja bay ja snebuman jumasa. Chamele huayel yuj ja stristeilei. ");
INSERT INTO tojNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ti yalaa: ―¿Jasyuj ja huanex xta huayel ja huenlexi? Q'ueanic. C'umanic ja Diosi ba mi oja lee ja hua mulexi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Cuando jach huan yaljel ja Jesusi, huaj to yile, ti c'ot jitzan ja cristiano. Ja ma' mero bajtan yujilei, yena ni ja ma' Judas sbiil, ja' ni june ja lajchahuane ja snebumani. Ti huaj c'uban ja ba stz'eel ja Jesusi ba oj yujtz'uc, como jach ni ja scostumbreei. ");
INSERT INTO tojNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","―Judas, jel lec huax jac ahuujtz'ucon yena pero ahuionej ni lec jpatica. Pero naa t'unuc, ti ni coelon jan ja ba satq'uinali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ja smoj jumasa ja Jesusi, cuando yilahue jastal oj xa ec'uc ja cosa jumasa iti, ti yalahuea: ―Cajual ¿jas la chi? ¿Mi ma lec oj jaxticon machit? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iday, june ja yenlei huaj yaa yi ja smozo ja pagre mas nihuani. Sc'utzu el yi ja stojol xchiquini. ");
INSERT INTO tojNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","―Jaxa huenlexi, ¿jasyuj jach huanex sc'ulajeli? Acta cani, xchi ja Jesusi. Ti syama ja xchiquini. Ya staa sbaj huego. ");
INSERT INTO tojNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ja Jesusi ti yal yab ja nihuac pagre jumasa soc ja matic sepeil ja soldado jumasa ba templo soc ja banquilal jumasa, spetzanil ja ma' oj xa nolc'abijuc ja yeni: ―¿Jasyujil ja soc machit soc garrote huax jac ayamonexi? ¿Yuj ama lagronon ja quen ba? ");
INSERT INTO tojNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ja chaboxe c'ac'u ec' ta jani ti ni ajyiyon amoquex cada c'ac'u ba templo, iday, mi ni t'usan jas ahualahuex caba. Pero ja huego oj ni ac'uluquex ganar ja huenlexa porque ja' ni ora it tzatz lec huan huajel ja ma' suinquil ja q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ti smochohue ja Jesusi. Ti yiaje ja ba snaj ja pagre mas nihuani. Jaxa Pedro ti nochan och najtic najtica. ");
INSERT INTO tojNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jaxa ba snaj ja pagre mas nihuani, ti stzomo sbaje jun montón cristiano. Ti ochye culan ba sti ja c'aq'ui. Ti cho och culan ja Pedro soc ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Entonces jun criada, yajni yila ti culan ec' lajan ja ba sti ja c'aq'ui, ti stojtoq'uela leca. Ti yalaa: ―¡Pero ja tan huinic iti ja' ni smoj ja tan Jesús jahui! xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ja Pedro: ―Nana, ¡pero mi ni t'un huax naa sbaj ja huinic jahui! xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ja mas tzaani ti cho ilji ja Pedro: ―Jach ni ja hueni, amoj ni abajex soc ja yena, x'utji. ―Miyuc, mi quenuc, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jaxa ec' ta mojan jun ora, ti cho alji yaba: ―Meran, ja tan huinic iti smoj ni sbaje soca. Sbaj ni Galilea ja yen chomajquil tac, xchi, pero jel tzatz juntiro ja stii. ");
INSERT INTO tojNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ti yala ja Pedro: ―Tata, mix naa jasunc'a huana yaljeli. Cuando jach to huan yaljeli, ti oc' ja galloa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jaxa Cajualtiqui ti sutu sbaja. Ti sq'uela lec ja Pedroa. Ti jac sc'ujol ja Pedro ja jas alji yab yuj ja Cajualtiqui, ja cuando mi to bix oc' ja gallo, oxe bi vuelta oj yal que mi snaa sbaj. ");
INSERT INTO tojNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ti xa el ja Pedroa. Ti och smil sbaj oq'uela. ");
INSERT INTO tojNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ja huinique jumasa jau ja ma' ti xa ni ay ba sc'abe ja Jesusi ti och yaahue yi burlaa. Ti cho och smaq'uea. ");
INSERT INTO tojNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ti smacahue yi ja sati. Ti och yaahue yi vuelta ja ba xchoji. Ti yalahuea: ―Ala machunc'a huas smac'ahua ba. ");
INSERT INTO tojNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Jaxa tuqui ba sbiil ba mi sbiiluc huax yutaje. ");
INSERT INTO tojNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuando el ja c'ac'u ti stzomo sbaje ja banquilal jumasa soc ja nihuac pagre jumasa soc ja matic huas sea ja smandar ja Moisesi. Ti yiaje och ja Jesusi ja ba junta ja ba tzoman spetzanil ja cristiano. Ti sobohue yia: ");
INSERT INTO tojNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ala cabticon ba, ¿huen ama Cristoa? xchiye. Ti yala ja Jesusi: ―Anima huax cala huabyex ta quena, mi ni oja c'uuconexa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ta huan c'ax c'an ac'ujolex machunc'a ja Cristoi, mi ni oja hualex caba, soc mi ni oja sijpuconexa. ");
INSERT INTO tojNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ja queni coelon jan ja ba satq'uinali pero ja huego oj xa huajcon ja ba mero stz'eel ja Dios ba jel juntiro ja yipi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ti och yalea: ―¡Ja huena ni ja yunin ja Dios ta jachuqui! ―Pues quena. ¿Jasyuj huaxa jobohuexi? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ti yalahue ja yenlei: ―Pues, ¿jas yatel cujtic mas testigo? ¡Mismo quentic cabtic ta ja jas el ta ba sti tac! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Spetzanil ja cristiano ja janec' stzomonej sbajei, ti yiaje och ja Jesús ja ba sti sat ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ti och slee yi ja smula: ―Ja huinic iti co ta cujticon ja jas huan sc'ulajel ec' ja ba jlugartiqui. Huan somjel yi ja s'olom ja cristiano. Mi bi oj caaticon yi contribución ja gobierno Cesari. Huax cho stoyo sbaj que yen bi ja Cristo tzaubal bi yuj ja Diosi. Rey ni bia, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Entonces ja Pilato ti yalaa: ―Entonces, ¡ja huena ni ja sreya ja judio jumasa ta jachuqui! ―Como huen ita ni huaxa hualaa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ja Pilato ti yal yabye ja nihuac pagre jumasa soc ja cristiano jumasa: ―Ja huinic iti mi ni jun smul huax taa ja queni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero ja yenlei mas to jel tzatz huaj ja stiei: ―Huan somjel juntiro ja cristiano jumasa sbaj Judea soc ja jas huan seejeli. Q'ue stul ba Galilea. El ta jul man ili, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ja Pilato yajni yab ja jastal iti, ti sobo ta galileño ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yajni alji yab que galileño nia, ti seca ja ba sti sat ja Herodesa, como yena ni gobierno ay ja ba Galilea pero ja c'ac'u jumasa jahui, ti ni ay c'ot ja ba Jerusalena. ");
INSERT INTO tojNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jaxa Herodesi yajni yila ja sat ja Jesusi, jel gustoaxi juntiro. Ay xa tiempo huas sc'ana oj snaa sbaj. Yabunej lec yabalil ja Jesusi. Jel ja sgusto oj yil oj sc'ul jun milagro. ");
INSERT INTO tojNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ti och sc'an yi sc'ujol jitzan cosaa. Pero ja Jesusi mi ni jun palabra c'umania. ");
INSERT INTO tojNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jaxa tihui tey ja nihuac pagre jumasa soc ja matic huas sea ja smandar ja Moisesi. Mas to jel tzatz huane sleejel yi ja smuli. ");
INSERT INTO tojNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ja Herodesi soc ja soldado jumasa ti och yixtalauquea. Ti ya slape jun sc'u ba jel tzamal ja jastal huas slapa ja reyi, pero puro burla huane. Ja el ja sganae ja jastal huan sc'ulajel yii, ja Herodesi ti cho seca och ja ba sc'ab ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ja Pilato soc ja Herodesi mero scondra sbaje ajyi pero ja c'ac'u jahui, yamigoan sbaje. ");
INSERT INTO tojNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ja Pilato ti spaya jan ja nihuac pagre jumasa soc ja matic ay yatel yujilei, spetzanil ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ti och yala: ―Q'uelahuilex, ja huenlexi ja huiajex jan ja huinic iti. Huaxa hualahuex que huas somo ja s'olom ja cristiano. Ti ba sti asatex jitzan ja jas jobo ta yii, pero ja queni mi ni jun smul huax taa yi ja jastal huanex yaljeli. ");
INSERT INTO tojNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jach ni ja Herodes chomajquili, cho seca jan qui otro vuelta. Ti huaxa huabyexa, mi ni jun sbej que oj chamuca. ");
INSERT INTO tojNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Eso sí, oj yii castigo pero oj ni jsijpuca, xchi ja gobierno Pilato. ");
INSERT INTO tojNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ja ba q'uin jahui, culan ni yujile huax ya el libre jun presoanum ja Pilato ");
INSERT INTO tojNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jayuj ja cristiano jumasa ti och yalea: ―¡A chamuc! ¡Mix c'anaticon! ¡Ja' huax c'anaticon oj el libre ja Barrabasi! pero xch'eljiye xta ahuanel. ");
INSERT INTO tojNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ja Barrabás jahui aaji och preso yuj ja ya q'ue jun nihuan pleito ja ba yojol ja chonab jahui, cho milhuani. ");
INSERT INTO tojNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ti cho c'umani otro vuelta ja Pilato porque ay ni sgana oj sijpuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ja cristiano ti cho och ahuanuquea: ―¡A cham ba cruz, a cham ba cruz! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti cho yala ba yoxil vuelta ja Pilato: ―¡Pe mi jas malo huan sc'ulajel tac! ¡Mi ni jun sbej ba oj chamuca! Oj caa yi castigo, ti oj sijpuca, xchi ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ja cristiano mas jel tzatz q'ue ahuanuque. Huane xta ni yaljel que oj ni chamuc ja ba cruza. Yuj ja jel ni tzatz ja stie ja yenlei soc ja nihuac pagre jumasa, jayuj sc'ulane ni ganara. ");
INSERT INTO tojNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jaxa Pilato ti xa yaa orden ba oj sc'uluque yi ja jastal huas sc'ana ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ti ya el libre ja huinic jau huan ni sc'anahuei, ja huinic jau ma' aaji och preso yuj ja milhuani, cho ya q'ue jun nihuan pleito. Ti xa c'ulaji endregal ja Jesús ja ba sc'ab ja soldado ja jastal ni yalahue ja cristiano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jaxa soldado jumasa ti yiaje ja Jesusi. Cuando ti xa aye ba beji, ti yilahue tey jun huinic suinquil ja Cirene, Simón sbiil. Huan tox ch'ac juluc ja ba huitzi. Ti spayahue ba oj sq'uech ja cruzi. Ti huaj nochan ja ba spatic ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ti cho nochane jun nole lec ja cristiano soc jitzan ja ixuque huane oq'ueli. Huane mebaoq'uel yuj ja stristeilei. ");
INSERT INTO tojNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ti sutu sbaj ja Jesusi. Ti yalaa: ―Ixuque ba Jerusalén, mi la ocyex yuj ja queni. Mas lec, a oc' xchabil ja hua satexi yuj ja hua huocolexi soc ja suocol ja hua huuntiquilexi, ");
INSERT INTO tojNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque oj ni c'otuc ja c'ac'u mas lec oj yil ja ma' mi ni nunca yila unticaneli. Ti oja hualexa: Mas lec juntiro ja ixuque ma' mi yila unticaneli, ja ma' mi ni nunca ya chunuc ja yal alatzi. Jach ni oja hualex ja c'ac'u jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jaxa cristiano jumasa ti oj och yala: Mas lec huan xa sama sbaj ja lumq'uinali que no que lom jel huantic yiijel ja castigo iti. Tuu xa huax cabtic ja satq'uinali, oj chiuque. ");
INSERT INTO tojNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ja cristiano, q'uelahuil jas huane sc'ulajel ja huego y ti to ayona pero ¡majlayic! Cuando huax jac ja scastigoei, ¡pegor oj huajuque juntiro! xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Soc ti yioje chahuane huinique ja ma' co soc ja smulei. Lajan bi oj chamuque soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Cuando c'otye ja ba huitz jau huax aaji sbiiluc s'olom chamhuiniquili, jaxa tihui ti yaahue q'ue locan ba cruza. Jaxa chahuane huinic jau ma' co soc ja smulei, ja juni ti aaji q'ue ba lado stojol sc'ab ja Jesús ja ba stz'eel ja scruzi, jaxa otro juni ba lado surdero. ");
INSERT INTO tojNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ti yala ja Jesusi: ―Tatey, c'ulan perdonar ja cristiano jumasa. Mi snaahue jasunc'a huane sc'ulajeli. Ja soldado jumasa ti sc'ulane ripar ja sc'u ja Jesusi ba oj spil sbaje ja janec' aye ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jaxa cristiano, q'uelan jacane xta c'ote, jaxa ma' ay yateli huane xta burla sbaj ja Jesusi: ―Jel scolta ja cristiano jumasa tac. Ja huego, ta Cristo c'a meran, ¡a scolta sbaj ja yen mismo ba, como tzaubal ni bi yuj ja Diosi! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jach ni ja soldado jumasa, cho och yaahue yi burla. Ochye c'uban, ti yaahue yi vinagre ba oj yue. ");
INSERT INTO tojNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ti yalahuea: ―¡Ta huen c'a sreya ja judio jumasa, colta baj ja huen mismo ba! ");
INSERT INTO tojNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jaxa ba lado bay ja s'olom ja Jesusi ti yaahue pac'an jun juuna. Tz'ijbanubal oxe abal ja ba juun jahui, ja' ni ja abal griego soc latina soc hebrea: Ja huinic iti, ja' ni ja srey ja judio jumasa. Jach ni xchi ja ba tz'ijbanubali. ");
INSERT INTO tojNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jaxa june ja ma' locan ec' ja ma' ay ni smul merani, ti och bulbunuca: ―Ta huen c'a ja Cristoa merani, colta baj ja huen mismo ba, cho coltayoticon ja quenticoni, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jaxa smoj mulanumili ti yalaa: ―Ch'abanan ja hueni. ¡Mi ni t'un huala xiu yuj ja Diosi, iday, ti aya ba yojol ja castigo! Jaxa yeni huan yiijel ja castigo jastal huantic yiijel ja quentiqui, ");
INSERT INTO tojNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Pero ja huinic iti mi ni jas malo sc'ulana. Ja quentiqui ay ni lec sbej huax quiajtic ja huocola. Sbej ni huantic stupel ja jastic ch'ac jc'ultiqui. ");
INSERT INTO tojNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ja huinic jahui ti yal yab ja Jesusi: ―Cuando huala c'ot ja ba oja c'ul mandari, xa naahuon t'usan ja queni, xchi. ");
INSERT INTO tojNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ti yala ja Jesusi: ―Huax cala huabi, pero meran, ja yaan c'ac'u ti ni oj c'um jbajtic ja ba lugar jau jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Cuando oj xa sta ja nalan c'ac'u, ti q'uicbi juntiro ja q'uinali. Ti to cho lijpi ja mojan nalan tz'elan c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ja c'ac'u tupi, jaxa nihuan scortinail ja templo ti xch'ia con sbaj snalan. ");
INSERT INTO tojNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ja Jesusi ti ahuani tzatz leca: ―Tatey, iaj xa ja caltzili. Quechan ch'ac yal ja jachuqui, ti chama. ");
INSERT INTO tojNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jaxa scapitanil ja soldado jumasa jahui, cuando yila jastal huaji, ti och sc'an yi stz'acatal ja Diosi: ―Meran ja huinic iti lequil huinic nia. ");
INSERT INTO tojNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Spetzanil ja cristiano ja matic teyi, yajni yilahue jastal huaji, ti xa elye ja tihua. Mi snaa jas oj sc'uluque soc ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jaxa spetzanil ja yamigo jumasa ja Jesusi soc ja ixuque jau ja ma' ti nochane jan man ba Galilea, ti huane sq'ueljel najat spetzanil ja jastal ch'ac ec'uqui. ");
INSERT INTO tojNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ay jun huinic ja tihui, José sbiil. Ti culan ba Arimatea ajyi, ja' ni jun hacienda sbaj Judea. Ja yeni ay yatel soc ja smoj judioili. Lequil huinic nia soc jel toj. ");
INSERT INTO tojNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ja yeni huan ni smajlajel jas ora oj sc'ul mandar ja Diosi. Como mi ni xch'ica sbaj ja jas ch'ac sc'uluc ja smoj jumasa, mi ni lajanuc staa sbajea. ");
INSERT INTO tojNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ja José jahui ti huaj sc'an yi ja Pilato ja scuerpo ja Jesusi, ");
INSERT INTO tojNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Entonces ti huaja. Ti ya couc ja ba cruzi. Sbech'a soc jun sábana. Ti yaa ba jun q'ueen pero ja q'ueen jahui jotobal ba jun patac'. Mi to ni ma' huax mucji ba q'ueen jahua. ");
INSERT INTO tojNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ja c'ac'u jau mucxi ja Jesusi, ja' ni ja c'ac'u huax q'ue xchap sbaj ja judio jumasa ba oj stalnaye ja sc'ac'uil ja sijlelei. Oj xa mucxuc altiro ja c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jaxa ixuque jumasa ja ma' nochane jan masan ba Galilea, ti huaj yile ja sq'uejnal ja Jesusi. Yilahue ja jastal aaji can ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ti cumxiye ja ba sposadaei. Ti xchapahue yi jun yajnal ba jex ajbani ja yiq'uili soc ja yajnal ja ba oj saxe yi ja scuerpo ja Jesusi. Ti jijliye ja sc'ac'uil ja sijlelei, ja jastal ni huas sc'uane ja smandar ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jaxa sbajtanil c'ac'u ja semana, ja' ni ja c'ac'u domingo, ja ixuque jahui saj to lec huajye ja ba q'ueeni. Yiaje ja yajnal it xchapahuei, como jel nix ajbani ja yiq'uila. Soc ay otro ixuque huaj mojtajuque yuj. ");
INSERT INTO tojNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Cuando c'otye ja tihui, jaxa ton ja macji can soc ja sti ja q'ueeni, tz'elan xa ec' staahue. ");
INSERT INTO tojNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ti ochye ba yoj q'ueeni pero mi ni staahue ja scuerpo ja Cajualtic Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jel huane xihuel juntiro. Mi snaa jas oj sc'uluque. Huaj to yile, ti tec'an ec' ba stz'eele chahuane huinique, jaxa sc'uei, jex lijpi juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Como jel huane xihuel, ti ch'ac snujbuc ja sate ja ba luumi. Ti yala ja huiniquei: ―¿Jas huanex ec' ja il ba? Ja ili, ja' sbaj ja chamhuiniqui, mi jauc sbaj ja ma' sac'an xa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ja ma' huaxa leahuexi mi xa teyuc ja ili. Sacui ta nia. ¿Mi ma huax jac ac'ujolex ja jas yala cuando ti to ay ba Galilea ba? ");
INSERT INTO tojNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ti ni bi coel jan ja ba satq'uinali pero anima, oj ni bi c'ulajuc endregal ja ba sc'ab ja mulanum jumasa. Oj ni bi aajuc q'ue locan ja ba cruza pero ba yoxil c'ac'u oj ni bi sac‑huuca, ¿mi ma xa naahuex ba? xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jaxa yenlei ti xa jac sc'ujole ja jas yala meran ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ti xa cumxiye ja bay ja juluchuane secabanum ja Jesusi soc ja tuc ja ma' ti ni ayei. Ti ch'ac yale spetzanil ja jastaltic yilahuei. ");
INSERT INTO tojNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jaxa ma' yiaj och ja razoni, ja' ni ja María sbaj Magdala, soc ja Juana, soc ja María snan ja Jacobo, soc ay otro ixuquei. ");
INSERT INTO tojNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ja juluchuane secabanum ja Jesusi ti yalahuea: ―Ja' ama mojex ja loco ja huenlexi. ¡Jastal oj c'uucticon ja jahui! ");
INSERT INTO tojNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero ja Pedro ti ela, pero ajnel huaj yil ja ba q'ueeni. Huaj to yil ja ba yoj q'ueeni, quechan ti pacan ec' ja sábana. Cuando cumxi ja ba naitz ja baye ja smoj jumasa, jel juntiro huan pensar ja jastal eq'ui. ");
INSERT INTO tojNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja mismo c'ac'u jahui chahuane ja snebuman ja Jesusi ti huajume ba jun yal hacienda, Emaús sbiil. Mojan oxe lehua yioj ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ja' ni mero sloile ja jastal yabye ch'ac ec'uqui. ");
INSERT INTO tojNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Cuando huane lec loili, ja' ni huane yaljela. Huaj to yile, tey ba stz'eele ja Jesusi. Ja bej yioje ja yenlei ja mismo bej cho yiaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iday, ja yenlei mi ni t'un bob snae sbaj machunc'aa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ti yala ja Jesusi: ―¿Jasunc'a huanex yaljel ja ba bej ba? ¿Jasyuj jel triste ayex ba? ");
INSERT INTO tojNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ti yala jan ja ma' Cleofas sbiili, ja' ni june ja chahuane huinique jahui: ―Pero spetzanil ja cristiano ja sbaj Jerusaleni, mi ni june ma' mi yabunejuc ja jastal ch'ac ec'uc ja c'ac'u jumasa iti. ¿Quechan ma huen mi to xa huab ba? ");
INSERT INTO tojNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","―Pero ¿jasunc'a ec' ba? xchi ja Jesusi. ―¿Mi ma xa huab yabalil ja Jesús nazareño ba? Jun huinic pero mero aluman‑Dios. Jel tzatz ja yateli soc jel nihuan juntiro ja jas huax yala. Jel tzatz ay ja ba sti sat ja Diosi, jaxa ba yojol ja cristiano, jel nihuan ja jas sc'ulani. ");
INSERT INTO tojNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ja nihuac pagre jumasa soc ja ma' ay yatel cujtiqui xchapahue yabalil que oj bi chamuc. Yaahue q'ue locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Pero ja quenticoni nihuan jc'ujolticon ba oj sc'ulucotic librar ja janec' israeleñootic ja ba sc'ab ja jcondratiqui. Jel ja jas sc'ulani pero iday, ja huego ay xa oxe c'ac'u aaji q'ue locan ja ba cruzi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jaxa huaaxa saj to lequi, huaj chaboxe ixuc ja jmojticoni. Huajye ba sq'uejnali pero iday, jel xiuye juntiro ");
INSERT INTO tojNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Porque mi staahue ja scuerpo. Ti jac yale cabticon que snajsatine bi chaboxe ángel. Ti bi alji yabye que ja Jesús sacui ta bi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ti cho huajye chaboxe ja jmojticon huiniquil ja ba q'ueeni. Pero jach ni staahue ja jastal ni yalahue ja ixuquei. Pero ja scuerpo ja Jesusi mi ni bi yilahuea. ");
INSERT INTO tojNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ti yala ja Jesusi: ―Ja huenlexi, ¡jel huocol juntiro huaxa c'uanex! ¿Mi ni ma t'un huax jac ac'ujolex ta mi meranuc ja jas yala ja aluman‑Dios jumasa? ");
INSERT INTO tojNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mi ma bajtanuc ni t'ilan jel oj yii huocol ja Cristo ba? ¿Jaxa mas tzaani oj ni huajuc ja ba huax lijpia? ");
INSERT INTO tojNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ti och yal ja jastal huax taji ti' ja Cristo ja ba spetzanil ja slibro ja Diosi. Och stul ja jas stz'ijba can ja Moisesi masan ch'ac ec'uc ja libro stz'ijba can spetzanil ja aluman‑Dios jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yajni c'otye ja ba yal hacienda ja ba huajumei, jaxa Jesusi sea sbaj que mas najat oj huajuc. ");
INSERT INTO tojNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero ja yenlei ti sc'ulane fuerza que oj can soquea: ―¿Mi ma mas lec oj xa canan jmocticon porque och ta c'ac'u? Lajan soc acual xa nia. Entonces yajni yab ja Jesusi, ti xa och och ja ba yoj naitza. Can soc ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yajni ti xa culane ja ba mesa, ti syama ja pani. Ti sc'ana yi stz'acatal ja Diosi. Ti xet'a yi xen yamana. Ti yaa yi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ti to jac lec sc'ujole machunc'aa. Quechan pavor snaahue machunc'a, huaj to yile, ch'ay huego. ");
INSERT INTO tojNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ti och yal sbaje yenle itaa: ―¿Mi ma jel alegre huaj ja hua hualtzili cuando huan loil jan jmoctic ja ba beji, como ja' ni huan seejel quitic ja jas tz'ijbanubal ja ba slibro ja Diosi? huax yutaj sbaje. ");
INSERT INTO tojNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Y mi smajlaye mas. Cho yiaj ja sbejei. Cho cumxiye ja mismo ora ja acual jahui ja ba Jerusaleni. Ti ni staahue tzoman ja juluchuane jecabanumi soc ja smoje jumasa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ja' ni huane xta ni yaljela: ―Meran nia, sacui ta ni ja Cajualtica. Meran ni yila ja Simona, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jaxa chahuane jau cumxiye jan yilahue ja Cajualtiqui, ti och xchole ja jastal yilahue ja ba beji. Pero ti to bi snaahue sbaj ja cuando spila ja pani. ");
INSERT INTO tojNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cuando jach to huane yaljeli, huaj to yile, ti tec'an ec' ba snalane ja Jesusi. Ti aaji yile Diosa. ");
INSERT INTO tojNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero ja yenlei xlasasi ch'ac huajuc ja xchiq'uelei. Juntiro jel och ja xihuelei. Huax yalahue que altzilal bi huax yilahue. ");
INSERT INTO tojNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ja Jesusi ti yalaa: ―¿Jasyuj jel huanex xihuel ja huenlex ba? ¿Jas sbej huan xta tz'iptz'unuc ja hua c'ujolexi? ");
INSERT INTO tojNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Q'uelahuilex ja coc jc'abi. Quena ni merana. Yamahuonic. Q'uelahuonic. Jun altzilal mey scuerpo ja jastal huaxa huilahuonex ja queni, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ch'ac yal ja jastal iti, ti sea ja yoc sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jaxa yenlei jel sgustoe juntiro pero jel jomel ja s'olomei, jayuj mi mero huas sc'uane. Yajni yila ja Jesusi, ti yalaa: ―¿Ay ama jas ahuiojex ba oj cabtic? ");
INSERT INTO tojNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ti yaahue yi jun pedazo bacbel chaya soc jun penca chab. ");
INSERT INTO tojNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jaxa Jesusi ti yiaja. Och sc'ux ja ba sti sat ja yenlei, cho sloo ja chabi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ti yalaa: ―Ja jastal ch'ac ec' cujili, como jach cala huabyex cuando ti to ni ayon amoquex ajyi. Spetzanil ja jas tz'ijbanubal ja ba smandar ja Moisesi soc ja ba slibro ja aluman‑Dios jumasa soc ja libro ja Salmo jumasa t'ilan ch'ac c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Soc ja jas yala ja Jesús ja ora jahui, ti to jac sc'ujole jas sbej ja jas tz'ijbanubal ja ba slibro ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ti cho yala ja Jesusi: ―Ja Cristo t'ilan ni bi oj chamuca, jaxa ba yoxil c'ac'u oj ni sac‑huuca. ¡Pero quena ni ja Cristoon tac! ");
INSERT INTO tojNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jaxa ba spetzanil ja lugar jumasa oj xa ch'ac loiltaxuc ja jas yajc'achil ch'ac ta ec'uqui ba oj suchuc ja sc'ujol ja cristiano soc ba oj c'ulajuc perdonar ja smulei, pero ja' ni yuj ja jastal ch'ac ta ec' cujili. Ti oj q'ue tulxuc ja sloiltajel ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pero ja huenlexi testigoex nia porque ahuilunejex ja jas ch'ac ta ec' cujili. ");
INSERT INTO tojNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pero q'uelahuilex. Oj ni jec ahuilex ja Espíritu Santo ja jastal ni yalunej ja jTati. Pero cananic ja il ba Jerusaleni masan to oj yaa hui ja hua huipex ja Diosi, x'utjiye yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ja Jesusi soc spetzanil ja snebumani ti huajye ba Betania. Ja Jesusi ti ya q'ueuc ja sc'abi. Sc'ulan bendiciar ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Cuando ch'ac sc'ul bendiciari, ti spila sbaj soc ja yenlei. Ti xa iiji q'ue ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jaxa snebuman jumasa ti coye mec'ana. Yaahue yi stz'acatal ja Diosi. Entonces ti xa cumxiye ja ba Jerusaleni pero jel gusto aye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tola vida huax huajye ba templo. Huas sc'anahue yi stz'acatal ja Diosi. Ti ch'aca. Amén.");
INSERT INTO tojNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ja cuando mi tox cujlaji ja satq'uinali, ti xa ni ay ja yen ja ma' yala cabtic jastal ay ja Diosi. Tey ba stz'eel ja Dios Tatali, como Dios ni ja yen chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ti ni culan soc lajan ja Dios ja yora mi tox cujlaji ja satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yuj ja yeni, c'ulaji spetzanil ja jastic ay ja ba luumi soc ja ba satq'uinali. Mi ni jun cosa ba mi sc'ulan ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ja yeni yaa sac'anil spetzanil ja jas sac'an ay ja ba luumi, pero yip ni yena. Jaxa sac'anil yaa ja yeni, ya ijlabanuc ja spensar ja cristiano ba oj snaa ja cosa ba lequi soc ja ba mi lecuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Anima ti aye ba yoj q'uiq'uinal ja cristiano; yena ni huan ijlabanel ja ba sc'ujolei. Mix bob macxuc ja yijlabi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ajyi jun huinic jecubal yuj ja Diosi, jaxa huinic jahui, Juan sbiil. ");
INSERT INTO tojNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ja yeni jac yal ja smeranili, ja' ni huan xa staajel ti' ja yen ja ma' huax ya ijlabanuc ja sbej ja cristiano siquiera oj c'uajuc yi ja jas huan yaljeli. ");
INSERT INTO tojNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Porque ja Juani, mi yenuc ya ijlabanuc ja cristiano. Ja yeni, quechan jecubal ba oj yal cabtic jastal ay ja ma' huax ya ijlabanuc ja jbejtiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Pero ja ma' meran huax ijlabani, huax cho ya ijlabanuc ja sc'ujol ja cristiano, oj xa ni q'ue ya chijcajuc ba sat ja cristiano ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ti ni ay ja ba mundo ja yen ja ma' jac yal cabtic jastal ay ja Diosi. Yuj ja yeni, c'ulaji ja mundo pero ja cristiano mi snaahue machunc'a. ");
INSERT INTO tojNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ti co jan ja ba mundo ja ba sc'uluneji. Ay svida ja cristiano pero ja' yuj ja yeni, pero iday, mi ni c'ulaji casoa. ");
INSERT INTO tojNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero mi spetzaniluque. Ay ma' sc'ulane recibir, jaxa yenlei, sc'uane nia. Ti alji yabye que oj xa ochuque cuenta como jastal yuntiquil ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pero tuc juntiro. Mi jachucuc como jastal jun cualquiera nanal tatal. Ja yenlei huas sc'ana oj ajyuc yuntiquile, jayuj huax manxi ja yal untiqui. Pero ja ma' huas sc'uan meran ja Diosi, och ta ni mero yuntiquil ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ja yen ja ma' yala cabtic jastal ay ja Diosi pax cristianoil. Ja quenticoni, ti ajyiticon soc chaboxe tiempo. Quilaticon jastal huax lijpi, jaxa yateli, jel tzamal juntiro. Quechan único ja yunin ja Dios Tatali huax bob lijpuc ja jastal quilaticoni. Jel yaj juntiro ja sc'ujoli soc puro meran ja jas yala. ");
INSERT INTO tojNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ata huabilex jastal taaji ti' yuj ja Juan ja ma' huax yaa bautismo ja tiempo jahui. Ti yala ja jastal iti: ―Ja huinic iti, ja' ni huanon staajel tia. Cala ni que ti oj jac tzaan ja ba jpatic ja queni, pero ja mero smeranili, ti ni ay ja yeni porque cuando mi to la manxiyoni, ti xa ni ay ja yena, xchi ni ja Juan ja tiempo jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ja yeni mi ni jas huas sc'ulan yi paltaa, jaxa jas yioji, jel juntiro ja spavor jmoctiqui. Mi ajtaben ja sbendicion huax yaa quitiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Eso sí, ja mandar jumasa, yen yaa quitic ja Moisesi, pero ta mi c'a jauc jac ja Jesucristo, mi ni oj naatic jastal jel yaj huax yabyotica, mi ni oj cabtic ja smeranila. ");
INSERT INTO tojNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mi ni nunca ma' yila ja sat ja Diosi, pero ja yunin jel yaj huax yabi, ti ni ay ja ba stz'eel ja Tatal Diosi. Yena ni sea quitic jastal ay ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ja jmojticon judioil jumasa ja ba Jerusaleni, ti secahue ja jpagreticon soc ja levita jumasa ja ma' ay yatele ja ba templo. Jecjiye ba oj huaj sobe yi ja Juan machunc'a ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ja Juani ti yala claro leca: ―Ja queni, mi quenucon ja Cristo ja ma' jecubal yuj ja Diosi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","―¿Machunquiluca huen ba? Entonces ¿huen ama aluman‑Dios Eliasa? xchiye. Ti yala ja Juani: ―Pues miyuc. Ti cho sobohue yi otro vuelta: ―Entonces, ¿huen ama aluman‑Dios it t'ilan ni oj to jacuqui? ―Miyuc, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","―Pues ala cabticon mach aya ba, porque t'ilan oj snaa ja ma' secahuoticoni. Ala cabticon jasunc'a ja hua chol huana ec' ja il ba, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ti yala ja Juani: ―Pues quena ni ja ma' jel bi tzatz oj c'umanuc ec' ja ba ch'ayan lugar: Ja jastal huaxa jamahuex ja bej ja cuando oj jac ja ma' ay yateli, jach oja huaex puesto ja hua c'ujolexi porque oj xa jacuc ja Cajualtiqui, la chiyon ni ec'a. Najate jach ni yala ja aluman‑Dios Isaías que jach oj cale, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ja huinique jahui, ja' ni jecubale yuj ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ti cho sobohue yi ja Juani: ―Entonces ta mi c'a huenuc ja Cristoa soc mi ni ja aluman‑Dios Eliasi, soc mi ni ja aluman‑Dios jau oj to jacuqui, ¿jasyuj huaxa huaa bautismo ba? ");
INSERT INTO tojNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ti yala ja Juani: ―Eso sí, meran nia, huan nix ca yii ja' ja cristianoa. Pero ay ma' ti xa ay jmoctic ja quentiqui pero ja huenlexi, mi to xa naahuex sbaj. ");
INSERT INTO tojNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ja quen ja huego, ti ayon ja ili pero majlayic, jechel chabe ay ma' oj jacuc, jaxa yeni, como bajtan xa ni ay yuj ja queni. Pero mi ni oj maconucon yuj oj sop yi ja xanabi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ja ora jau jobji yi ja Juani, ti ni aye ba jun lugar Betábara, ja' ni ja ba mojan ja sti ja nihuanja Jordani, ja ba lado spunto ja ba huax el q'uen ja c'ac'u, ja ba huan nix ya yii ja' ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jaxa ba xchabil c'ac'u ja Juani ti yila ti jacum ja Jesusi. Ti yalaa: ―Q'uelahuilex, yena ni ja ma' oj yaa sbaj como jastal ja chej huax aaxi ja ba sti sat ja Diosi. Yena ni oj xch'ay spetzanil ja smul ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yena ni ja ma' huanon staajel ec' tii. Cala ni huabyexa que oj to jacuc ja ma' mas tzatz yuj ja queni, jaxa yeni ti ni aya desde ora manxiyoni. ");
INSERT INTO tojNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Jach ni ja quen, mi huax naa machunc'a ajyia pero jac ca yii ja' ja cristiano ba spetzanil ja israeleño ba oj bob snae sbaj. ");
INSERT INTO tojNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Icha quila ta jastal co jan ja Espíritu Santo ja ba satq'uinali, entero splanta jastal jun paloma. Ti can t'ucan sbaj ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pero mi tox naa machunc'a ajyia, pero ja ma' secahuon oj ca yii ja' ja cristiano, yen yala cab que cuando huax quila huax co jan ja Espíritu Santo, ti bi oj can t'ucan sbaj jun huinic, jaxa huinic jahui, yena ni bi ja ma' oj yaa quitic ja Espíritu Santo, pero con todo yip. ");
INSERT INTO tojNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pero quila ta nia, jayuj ja yaani, testigoon nia que yena ni ja yunin ja Diosi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jaxa ba xchabil c'ac'u, ja Juani cho tey otro vuelta ja ba mismo lugari, cho tey chahuane ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Cuando yila ec' ja Jesús ja tihui, ti yala ja Juani: ―Q'uelahuilex, yena ni ja ma' oj yaa sbaj jastal ja xchej ja Dios tac. ");
INSERT INTO tojNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jaxa chahuane snebuman jahui, cuando yabye ja jas yala ja Juani, ti snochohue ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ja Jesusi, ti sutu sbaj ja ba spatiqui. Huaj to yil que ti nochan soqui, ti yalaa: ―¿Jasunc'a huaxa leahuex ba? Ti yala ja yenlei: ―Maestro, ¿ba culanaa? ");
INSERT INTO tojNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ti yala ja Jesusi: ―La ilahuic. Ti huajye soca. Ti yilahue bay ja snaji, ti ec' yujile ja c'ac'u soc ja yeni porque och ta c'ac'u c'otye ja ba snaj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jaxa june ja yenle ja chahuane jau ja ma' yabye ja jas yala ja Juani, ja ma' huaj nochan soc ja Jesusi, Andrés sbiil, ja' ni ja yijtz'in ja Simón Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jaxa Andrés jahui, ti huaj slee jan ja sbanquil Simoni, ti yalaa: ―Jtaaticon ta ja ma' huantic ni smajlajeli, ja' ni ja Mesiasi, xchi c'ote. (Jaxa biilal Mesiasi, ja' ni ja Cristoa.) ");
INSERT INTO tojNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jayuj ja Andresi, huego yiaj och ja Simón ja bay ja Jesusi. Jaxa Jesusi, cuando yila, ti yal yaba: ―Huena ni ja Simona, pero ja' ni atat ja Jonas tac. Pero ja huego, oj tucbes ja hua biili. Oja biiluc Cefas, x'utji, jaxa biilal Cefasi, Pedro ni huax el ja ba jc'umaltiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jaxa yoxil c'ac'u, ja Jesusi huas sc'ana oj huajuc ja ba Galilea. Cuando huajume xa, ti staa bej ja Felipe: ―¿Mi ma xa c'ana oj huajan jmoc? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ja Felipe, ja' ni suinquil ja chonab Betsaida, ja' ni ja xchonabile ja Pedro soc ja Andresi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jach ni ja Felipe, ti huaja. Huaj slee jan ja Natanaeli. Ti yalaa: ―¿Huan ma xa naa machunc'a quilaticon? Quilaticon ta ja ma' huax taji ti' ja ba libro ja ba huax taxi ja smandar ja Moisesi, huax cho staahue ti' ja aluman‑Dios jumasa chomajquili, ja it ma' sbiil Jesusi. Ja stati, ja' ni ja José ba Nazareti, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ti yala ja Natanaeli: ―¿Yuj ama ay jas oj bob el lec ja ba Nazaret ba? ―Pues la ilahuile, xchi ja Felipe. ");
INSERT INTO tojNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Cuando oj xa c'otuque ja bay ja Jesusi, ti och loil soc ja ma' tey ba stz'eeli: ―Ja Natanael jahui, mix bob slola ja cristiano. Mero israeleño nia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","―¿Jastal lec huaxa naa jbaj ba? xchi ja Natanaeli. ―Pero quilahua cuando ti aya ba yibel ja higo. Ja Felipe mi to ni huax c'ot ja ora jahua. Mi to ni jas huax yala huaba, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","―Entonces Cajual, ja huena ni yunin Diosai. Huena ni srey ja israeleño jumasa, xchi ja Natanaeli. ");
INSERT INTO tojNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","―¿Huan ama xa c'uan yuj ja jas cala huab que quilahua ba yibel ja higo? ¡Majla huile! Oj to ahuil jitzan cosa mas nihuan que yuj ja iti ");
INSERT INTO tojNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Porque ja queni ti coelon jan ja ba satq'uinali. Oj to ahuil jastal oj jamxuc ja satq'uinali. Oja huil jastal huax coi huax q'ue ja ángel jumasa ja bayoni, x'utji ja Natanael yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ti ec' otro oxe c'ac'u masa. Ti ajyi jun ch'ac abal ja ba jun hacienda Caná tey ba Galilea. Jaxa snan ja Jesusi ti ni ay ja tihua. ");
INSERT INTO tojNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ja Jesusi soc ja snebuman jumasa ti locjiye ja ba ch'ac abal jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jaxa ch'ac abalanum jumasa, ch'ac ja yalel tz'usub huane yuujeli, jayuj ja snan ja Jesusi ti yalaa: ―A cal, mi xa jas ay ja yalel tz'usubi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","―Pues ja huen naney, mi ahuocheluc. Ja queni mi to staa ja yoraili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero ja snan ja Jesusi ti yal yab ja atjum jumasa ja ma' tey ba sc'ab spetzanil ja atel jau ba q'uini: ―C'ulanic spetzanil ja jas oj yala huabyexi, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jaxa tihui ay yioje huaque tinaja, c'ulubal soc luum. Huax maconi yujile ja jastal huas sac'a ja sc'abe ja ba sreligione ja judio jumasa. Jaxa cada jujune ja tinaja jahui, huax och mojan ochenta litro, ma cien. ");
INSERT INTO tojNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ja Jesusi ti yal yab ja atjum jumasa: ―But'uhuic soc ja' ja tinaja jumasa iti, xchi. Ti sbut'uhue leca. ");
INSERT INTO tojNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ti yala ja Jesusi: ―Ja huego, a eluquex t'usan. Iajic och yi ja banquilal jumasa, x'utjiye. Jach ni sc'ulanea. ");
INSERT INTO tojNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jaxa banquilali ti sc'ulan probar ja sbaal ja tinaja. Huaj to yabi, yalel tz'usub nia. Mi jac sc'ujol ba jaca. Quechan ja matic huan ateli, eso sí, snaahue porque yena ni sbut'uhue ja jai. Jayuj ja banquilali ti spaya jan ja querem ja ma' huan nupaneli. ");
INSERT INTO tojNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ti yalaa: ―Pero culan ni cujtic jpetzaniltica, ja' ni mero bajtan huax el ja yalel tz'usub ja ba mas lequi, jaxa cuando cuajtic ta jitzani, huax el ja ba mi lecuqui. Pero ja hueni, ¡huan tox hua el jan ja ba mas lequi! xchi ja banquilali. ");
INSERT INTO tojNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ja jastal it sc'ulan ja Jesús ja ba hacienda Caná ja ba Galilea, ja' ni ja mero sbajtanil seña sea jastal sc'ulan ja milagro. Ilji jastal jel nihuan ja yipi, jaxa snebuman jumasa, ja mero ora jahui, ti sc'uane juntiroa. ");
INSERT INTO tojNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jaxa ec' ja iti, ti xa huajye ja ba chonab Capernaum. Ti smoj ja snani, soc ja yermano jumasa, soc ja snebuman jumasa. Ti tejc'ajiye chaboxe c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ja syalsq'uinale ja judio jumasa jel xa mojan ay ja ora jahui jayuj ja Jesusi ti huaj ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jaxa ba templo, huaj to yile, ti huan chonjel ja huacaxi, soc ja cheji, soc ja paloma, jaxa ma' huas sc'ulan cambiar ja taq'uini, ti saculcule ec' ja ba smesaei. ");
INSERT INTO tojNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Cuando yila jas huan ja cristiano ja Jesusi, ti stz'acba jun maq'ue tz'uuma. Ti ch'ac snutz el ja ba fuera spetzanil ja cristiano soc ja xchejei soc ja suacaxei, jaxa ma' huas sc'ulan cambiar ja taq'uini, ti ch'ac sutbuc ele ja smesaei, jaxa staq'uinei, sactantan ch'ac huajuc. ");
INSERT INTO tojNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jaxa ma' huan xchonjel ja paloma, ti alji yabyea: ―¡A eluquex ja cosa jumasa iti! ¡Mi lom xa c'ulanex mercadoil ja snaj ja jTati! ");
INSERT INTO tojNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ti jac sc'ujole ja snebuman jumasa ja ba huax yala ja ba slibro ja Diosi: Ja hua naji, lajan soc oj ch'acuc ja satq'uinal ja huax quilai. Jel yaj juntiro huax cabi, xchi ni ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Entonces ja judio jumasa ti yalahuea: ―Jaxa hueni, ¿jas seña oja jee quiticon ba oj naaticon que ay achol ja jas huax jac ac'uluc ja ili? ");
INSERT INTO tojNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ti yala ja Jesusi: ―Pues jemahuic el ja templo it ba, ti oja huilex ja ba yoxil c'ac'u, yajc'achil xa ni ti tec'an ec'a. ");
INSERT INTO tojNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ti yala ja judio jumasa: ―¡Janec' c'a to ni ja hueni ja huaxa huala quechan oxe c'ac'u oj hua q'ueuqui! Ja templo iti, cuarenta seis jabil sc'ulan ja ma' sc'ulanei, jaxa hueni huana yaljel que quechan oxe c'ac'u oj hua q'ue yajc'achil! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ja jas yala ja Jesusi, mi ni jauc huas staa ti' ja templo jahua. Ja' ni huan staajel ti' ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jayuj yaj ni cuando cham ja Jesusi, cho sacui, ja snebuman jumasa ti jac sc'ujole ja jas yala ja ora jahui. Ti sc'uane lec ja jas tz'ijbanubal ni ja ba yabal ja Diosi soc ja jas yala ba sti ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ja Jesusi ti ni ay ja ba Jerusalén ja el jul ja syalq'uinali. Jaxa ora jahui, jel c'uaji ja yeni porque ja cristiano yilahue ja milagro sc'ulani. ");
INSERT INTO tojNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ja Jesusi jacan jacan ay. Mi mojxi xchiq'uel sbaj soc ja cristiano jumasa jahui ");
INSERT INTO tojNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Porque huas snaa jastal ay ja sc'ujolei. Mi t'ilanuc ay ma' huax aluni yab jastal ay ja sc'ujolei, como huan ni snaa ja yena. ");
INSERT INTO tojNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ay jun fariseo Nicodemo sbiil, jaxa yeni, ja' ni june ja ma' ay yatel yujile ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jun acual ti huaj ja ba snaj ja Jesusi, ti yalaa: ―Maestro, huax naaticon que Dios ni seconeja ja hueni ba oja jee quiticon porque ¿machunc'a oj bob sc'uluc ja milagro jastal huax bob ac'uluc ja hueni? Mi c'a jauc tey amoc ja Diosi, ¡jastal oj bob ajee ahuip ja jastal iti! xchi ja Nicodemo. ");
INSERT INTO tojNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ti yala ja Jesusi: ―Huax cala huabi, jel xa tzatz huan mandar ja Dios ja huego, pero ta mi c'ax ajc'achbi ja huala pensari, caso oj jac ac'ujol ja iti. Huas sc'ana oj paxan ajc'ach cristianoil, lajan soc oj manxan otro vuelta. ");
INSERT INTO tojNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ti yala ja Nicodemo: ―Pero ¿jastal oj bob manxucon otro vuelta? ¡Pero viejoon xa tac! Entonces ¡lajan soc oj cho smanon otro vuelta ja jnan ta jachuqui! xchi ja Nicodemo. ");
INSERT INTO tojNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ti yala ja Jesusi: ―Pero ja mero smeranili, ta mi c'a la c'ocxi ba oja hui ja', mi c'a xa huaa baj ba yen oj stucbesa ja Espíritu Santo, mi ni nunca oja huab yajbal ja smandar ja Diosi, ");
INSERT INTO tojNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Porque ja hua hualtzili huax ajc'achbi yuj ja Espíritu Santo. Eso sí, ja hua cuerpoi jac ni yuj ja hua nan atati ");
INSERT INTO tojNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pero ja hua hualtzili, ¿yuj ama jel tuc huax cala huab que t'ilan oj ajc'achbuc ba? ");
INSERT INTO tojNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ja jastal iti, ja' ni mero smoj ja iq'ui. Huaxa huabyex huax jac ja sruidoili. Lom xta xuui huax jaqui pero mi huaxa naahuex ba huax jaca soc mi ni ja ba huax huaji. Ja' ni mero oj slaj cuando huax ya ajc'achbuc ja yaltzil jun cristiano ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―Pero ¿jas sbej ja jastal jau ba? xchi ja Nicodemo. ");
INSERT INTO tojNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ti yala ja Jesusi: ―Ja hueni jun nihuan maestroa ja ba Israeli, iday, mi huaxa naa jas sbej ja iti. ");
INSERT INTO tojNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Oj cala huab ja mero smeranili. Ja jas huax cala, yuj ni huax naaa. Huan nix naa ja mero smeranila, pero ja huenlexi, mi xa c'uanex ja jas huax calai. ");
INSERT INTO tojNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ja queni, ja' huanon staajel ti' ja jastal huan eq'uel ja ba mundo iday, mi xa c'ulan entender, ¡jauc to ma oja c'uluquex entender ta ja c'a huax cala huabyex jastal ay ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Porque ja queni ti ni coelon jan ja tihui. Mey otro ma' coel jan ja ba satq'uinali, quechan ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Eso sí, ti coyon jan ja ba satq'uinali, iday, ay ni jas oj ec' cujila. Huaxa naahuex jastal sc'ulan ja Moisés cuando ya locan ba jun te' ja chan jau c'ulubal soc taq'uin. Ti yaa locan ja ba ch'ayan lugar jahui. Jach ni mero oj c'ulajuc qui ja quen chomajquili ");
INSERT INTO tojNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jaxa spetzanil ja ma' huas sc'uanon ja queni, mi ni oj ch'ayuca. Oj ni staa ja svida jau ba mi ni nunca oj ch'acuqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Como ja Diosi, jel yaj huax yab juntiro spetzanil ja cristiano, jayuj seca con ja único yunini. Jaxa spetzanil ja ma' huas sc'uan ja yeni, mi ni oj ch'ayuquea. Oj ni stae ja svida jau ba mi ni nunca huax ch'aqui. ");
INSERT INTO tojNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porque ja Diosi mi seca con ja ba mundo ja yunini ba oj xch'ay snaajel ja cristiano. Seca con ba oj huajuque libre soc ja smulei cuando huax c'uaji ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ja ma' huas sc'uan ja yunin ja Diosi, mi ni ch'ayeluca pero ja ma' mi sc'uani, ch'ayel xa ni aya porque mi ni huas sc'uane ja yunin ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jayuj ch'ayele xa nia porque mi ni huas sc'uanea. Yena ni huax ya ijlabanucotica, jayuj jac ja ba mundo tac, pero iday, ja cristiano mi ni modo huas sc'anahue. Huas sc'ulane gusto mas ja q'uiq'uinali porque ja yatelei, puro ni maloa. ");
INSERT INTO tojNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mi ni modo huas sc'ana oj ochuque ja bay ja yijlabi porque mi sc'anahue oj chicnajuc ja jas malo huane sc'ulajeli. Jayuj jel coraja huax yilahue ja yijlab ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ja ma' huajel sc'ujol soc ja smeranili, ti xa ay ba mojan stz'eel ja yijlab ja ma' mi cualquierauqui ba oj iljuc que tey soc ja Dios ja yenlei, jaxa jas huas sc'ulanei, toj ni aya. ");
INSERT INTO tojNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jaxa mas tzaan t'usani, ja Jesusi soc ja snebuman jumasa ti huajye ja ba lugar Judea. Ti tejc'ajiye t'usan ja tihui porque huax ya yii ja' ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jach ni ja Juan chomajquili, cho ti huax ya yii ja' ja cristiano ja ba Enoni, mojan ja ba stz'eel ja Salim porque ja tihui, jel tzamal ja jai. Jaxa cristiano huane xta jaquel ba oj aajuc yile ja'. ");
INSERT INTO tojNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jaxa ora jahui, mi to nix aaji och preso ja Juana. ");
INSERT INTO tojNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Entonces ay chaboxe ja snebuman ja Juani ti ochye c'umal soc chaboxe ja judio ja ma' jel to tzatze soc ja sreligionei. Ja' huane yaljel jastal bi mas lec oj sc'uluquei cosaque chapan oj ajyuque cuando huax jac sc'ul mandar ja Cristo ja ma' huane smajlajeli. ");
INSERT INTO tojNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jaxa snebuman ja Juani ti huaj sobea: ―Tat Juan, ata huab jas yala cabticon ja tantic jmojtic judioil jahui, que ja huinic jau ja ma' ti ajyi amoc ja ba nihuanja Jordán, ja it ba lado huax el q'uen ja c'ac'u, ja' ni ja ma' jel huaxa taa ti', pero ja huego huan xa bi yaajel yi ja' ja cristiano, jaxa cristiano, lom xta bix nololi ec' sbaj ja yeni, xchiye nia. ");
INSERT INTO tojNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ti yala ja Juani: ―Pues lec nia porque mi ni june ma' ay jas oj bob yuj ta mi c'a jauc huax aaji yi yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Porque ja huenlexi ja huabyex ni ja jas cala. Cala ni que mi quenucon ja Cristo ja ma' oj ni jacuqui. Eso sí, bajtanon ja ba sti sati, pero mi Cristoucon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Q'uelahuilex jun nupanum. Ti huax ajyi ba stz'eel ja aq'uix ja ma' huan nupanel soqui pero ja yamigo ja nupanum jahui, ti ni huan maclajel yuj ja ma' jel gusto huax ilji yuji. Jaxa queni ja' mero jmoj ja amigoal jahui. Jel alegre huala huajyon huax cabi ");
INSERT INTO tojNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Porque ja yen ja mero Cristo t'ilan ni jel nihuan oj huajuca, jaxa queni, t'ilan ni oj ch'inbucona. ");
INSERT INTO tojNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Como ja yeni ti coel jan ja ba satq'uinali. Quechan ni yen mas nihuan que spetzanil ja cristiano, jaxa quentic ti aytic ja ba mundo iti. Jbajtic nia. Ja' ni huax loiltatic ja jas ay ja ba luumi. Pero ja Cristo, como ti coel jan ja ba satq'uinali, quechan ni yen ja mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja' ni huan sloiltajel ja jas yiluneji soc ja jas yabuneji pero iday, mi ni june ma' huas sc'uan ja jas huax yalai. ");
INSERT INTO tojNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ta ay c'a ma' huas sc'uan merani, yuj ni huax yab slugaril que meran ja jas huax yala ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ja Cristo, como jecubal ni yuj ja Diosi, yena ni huan staajel ec' ti' ja yabal ja Diosa. Ac'ubal ni yi ja Santo Espíritu, pero con todo yip. ");
INSERT INTO tojNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ja Dios Tatali jel yaj huax yab juntiro ja yunini, jayuj ac'ubal yip ba yibc'abal oj yaa spetzanil ja jas ayi. ");
INSERT INTO tojNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jaxa ma' huas sc'uan ja yunin ja Diosi, staa ta ni ja svida ba mi ni nunca oj ch'acuqui. Pero ja ma' mi sc'ana oj sc'uuc ja yunin ja Diosi, mi ni oj staa ja vida jahui. Quechan ni oj sc'ul recibir ja castigo jau ba mi icben sbej ja sbaj Diosi, xchi ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jaxa fariseo jumasa ti yabye que jel xa aaye ja cristiano ti xa nochan ec' soc ja Jesusi, jaxa Juani, jel xa t'usan ja ma' nochan ec' soqui, jayuj jel xa t'usan ja ma' huax ya yii ja' ja yeni. Pero ja Jesusi, jel ja ma' huax ya yii jai. ");
INSERT INTO tojNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Eso sí, ja mero smeranili, mi yenuc mismo huax ya yii ja' ja cristiano, ja' ni ja snebuman jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jaxa Jesusi, cuando yab ja jas huane yaljeli, ti xa el ja ba Judea. Ti cumxi ja ba Galilea. ");
INSERT INTO tojNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pero ja bej yiaji, ti huax ec' ja ba Samaria. ");
INSERT INTO tojNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ti c'ot ja ba jun hacienda sbiil Sicar ja ba stz'eel ja sluum ajyi ja Jacobi, ja' ni ja luum jau ja ba sc'ulan can dotear ja yunin Josei. ");
INSERT INTO tojNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ti ni ay ja pozo jau it jotobal chaan lequi, jaxa cristiano huax ya sbiiluque ja spozo Jacobil. Jaxa Jesusi, como huan ni bejyel jana, jayuj jel xa yajtic c'ot ja ba pozo jahui. Ti och culan ja ba sti ja pozo. Mojan culan c'ac'u. ");
INSERT INTO tojNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ti culan ec' ja tihui cuando c'ot jun ixuc, suinquil ja Samaria. Jac ba oj ya eluc ja jai. Ti yala ja Jesusi: ―Nana, ¿mi ma oja q'ueb qui t'unuc ja huala aali? xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jaxa snebuman jumasa ti huajele ja ba yoj hacienda ba oj smane t'usan ja jas oj yabyei. ");
INSERT INTO tojNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jaxa ixuc jau suinquil ja Samaria, ti yalaa: ―¿Jastal lec huaxa c'ana qui ja jai? Ja hueni judioa nia, jaxa queni, samariteñaon. (Jach yala jastal iti yuj ja mi ni huax yaa sbaje caso soc ja judio.) ");
INSERT INTO tojNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ti yala ja Jesusi: ―Ja lec huanuc to xa naa jasunc'a oj yaa hui ja Diosi ma huanuc to xa naa machunquilucon ja queni, entonces mi quen oj c'an ahui ja jai. Huen oja c'an qui, jaxa queni oj caa hui ja ja' jau huax yaa sac'anil ja cristiano, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ja ixuqui ti yalaa: ―Pero tata, ja hueni mi jas ahuioj ba oj hua el soc ja jai porque ja pozo, jel chaan juntiro. ¿Ba oj jacuc ja ja' jau oj yaa sac'anil ba? ¿Ba oja huii ba? ");
INSERT INTO tojNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ja Jacob ja ma' ec' pax ta cujtiqui, yaa can quiticon ja pozo iti. Ja' ni yuaj yalel ja pozo it ja yeni soc ja yuntiquili, soc ja xchanste jumasa. ¿Yuj ama mas nihuan ja huen soc ja Jacob ba? xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ti yala ja Jesusi: ―Pero meran huax cala huabi, spetzanil ja ma' huax yuaj ja ja' iti, tola vida taquin sti oj ajyuquea ");
INSERT INTO tojNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero ta huan c'ax yuaje ja ja' oj caa ja queni, mi ni nunca oj tacjuc stiea. Lajan soc jastal jun satja cuando huan bojtel tola vida ja ba svida ja ma' oj yii ja ja' oj caa ja queni. Oj ni aajuc ja svida ba mi ni nunca oj ch'acuqui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ti yala ja ixuqui: ―Cajual, aa qui ja ja' jahui cosaque mi xa oj to tacjuc ja jti ja quena. ¡Bob ta mi xa ni oj to cho jac quii ja ja' ila! xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ti yala ja Jesusi: ―Cax paya jan ja hua tatami ti la jacyexa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","―Pero mey jtatam tac, xchi ja ixuqui. ―Pues ay ni sbej huaxa huala que meyuc ja hua tatami ");
INSERT INTO tojNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porque joe ni huinic ecya ta soca, pero ja ma' ahuioj ja huego mi ni atatamuca. Jayuj ja jas ahuala, ti ni ay t'usan ja smeranili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Cuando ch'ac yab ja jastal iti, ti yala ja ixuca: ―Cajual, jac ta jc'ujol. Ja huen, mero aluman‑Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jaxa ma' ec' pax ta cujticon ja quenticoni yalahue cani que ti bi oj jac jc'umucticon ja Dios ja ba huitz iti, pero ja huenlex ja judioexi, huaxa hualahuex ja ba Jerusaleni, ti bi sbej oj c'umaxuc ja Dios ja tihui, xchi ja ixuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ti yala ja Jesusi: ―Meran huax cala huab nana, c'uanon. Oj jacuc ja c'ac'u ja huenlexi cuando oja c'umuquex ja Tatal Diosi, pero mi sbejuc oj jacanic ja ba huitz iti soc mi t'ilanuc oj huajanic ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ja huenlex samariteño jumasa, mi huaxa naahuex jasunc'a huaxa c'uanexi. Ja quenticoni huax naaticon machunc'a huax c'uanticoni porque ja ma' oj sc'ul librar ja cristiano ja' ni ja yintil ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero c'ot ta ni ja c'ac'u ja ma' meran huas sc'uan ja Diosi, malan soc ja ba sc'ujoli oj sc'uuc ja Diosi. Oj sc'uuc pero mero smeranil. Como jach ni huas sc'ana oj c'uajuc ja Tatal Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ja yeni, ic' ason ni ay ec'a, jayuj huas sc'ana que oj c'uajuc pero soc spetzanil ja sc'ujol ja cristiano, pero meran, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ti yala ja ixuqui: ―Huan nix naa que oj ni jacuc ja Mesiasi. Cuando xac ja yeni, oj ni yal cabtic ja mero sbeja, xchi ja samariteña. (Jaxa biilal Mesiasi, ja' ni ja Cristoa.) ");
INSERT INTO tojNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ti yala ja Jesusi: ―Pero ja ma' huaxa taa tii, yena ni ja ma' huana loil soc tac, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Cuando jach to huane yaljeli, ti c'otye ja snebuman jumasa. Yajni yilahue ti huan loil soc jun ixuc, cham yabye. Quechan naca sq'ueltalaane. Mi ni ma' sobo yujile jasunc'a huan sleejeli, soc mi sobohue jasunc'a sloil soc ja ixuc jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Entonces ja ixuqui ti yaa can ja xch'ub ja tihui, ti huaj ja ba yoj hacienda. Cuando c'oti, ti yal yab ja cristiano: ");
INSERT INTO tojNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Cax ilahuic jun huinic. Ch'ac ta yal cab spetzanil ja jas ch'ac ta jc'uluqui. ¡Saber ta mi yenuc ja Cristo! xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ti ch'ac huaj yile ja bay ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Cuando ti to huajum ja ixuc ja ba yoj hacienda, jaxa snebuman jumasa ti xa yalahue yaba: ―La xa Cajual, la xa huaacotic. ");
INSERT INTO tojNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ti yala ja Jesusi: ―Ja queni, ay quioj t'usan ja juaeli pero mi xa naahuex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Cuando yabye ja it ja yenlei, ti och sob sbajea: ―Seguro ay ma' ac'uni yi ja suaeli, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ti yala ja Jesusi: ―Oj cala huabyex jasunc'a ja juael ja queni. Ja' ni huala but'iyon yuj cuando huax c'ulan ja jas huas sc'ana ja ma' seconejon coni, jayuj oj ni ch'ac jc'uluc ja yatela ");
INSERT INTO tojNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Y jel xa ni ja yatela. Mi oj slaj jastal ja stiempo sachjel ja alaji: Quechan xta chane ixau, ti oj ajyuc ja jach'oji, la chiyex. Pero mi lom xa c'ulanex pensar que ta mi to chapanuc ja sc'ujol ja cristiano. Jel ja ma' chapan xa sc'ujole ba oj xa sc'uuque ja Dios mas ligero. Quechan huas sc'ana que al tanto xta oj ajyanic ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ta huan c'a sc'uane ja Dios yuj ja huenlexi, ay ni jas oja c'uluquex recibira ba oj maconuc ja ba vida jau ba mi ni nunca oj ch'acuqui. Cho jel gusto oj ajyuc ja ma' mero bajtan yala ja yabal ja Diosi. Ja yenlei mi yilahue sat ja yatelei pero ja huenlexi, oj to ahuilex sat pero jun xta mismo ja hua gustoex oj ajyanic cuando huaxa c'ulanex recibir ja hua majtanexi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jach ni aya. Tuc ja ma' primero huax yala ja yabal ja Diosi y mi huax c'uaji, jaxa ma' huax jac yal ja tzaani, huan xa nix c'uajia. Lajan soc ja ma' huas stz'unu can jun alaj y tuc xa ja ma' huas sach'a. ");
INSERT INTO tojNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Y jachuc ja huenlexi. Ti huax jecahuex ja ba chapan xa ja sc'ujol ja cristiano porque tuc ja ma' yalunej xa ni yabye ja cabali. Pero yuj ja huenlexi, oj xa sc'uuque meran ja Diosi. Pero stz'acatal ja ma' atji primero, jayuj oj xa huilex sat ja yatel ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jach yala yuj ja jel ni ja samariteño ja ma' sc'uan ja Jesús yuj ja jas yala ja ixuqui. Como yala que alji yab spetzanil ja jas ch'ac ta sc'uluqui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jayuj ja cuando ch'ac c'otuque ja samariteño jumasa ja bay ja Jesusi, ti sc'anahue yi lec pavor ba ti oj can soc ja yenlei. Jayuj ja Jesusi ti can chab c'ac'ua. ");
INSERT INTO tojNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cuando ch'ac yabye ja jas huax yala ja Jesusi, jel ni ja ma' sc'uan ja chab c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jaxa ma' ch'ac sc'uuqui, ti yalahue yab ja ixuca: ―Ja huego huax c'uanticon yuj ja mi quechanuc yuj ja jas ahuala cabticoni. Como cabticon ja mismo ja sti ja yeni. Huan xax naaticon que yena ni meran ja Cristo ja ma' oj sc'ul librar spetzanil ja cristiano, xchi ja samariteño jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ja ec' ja chab c'ac'u jahui, ti xa el ja Jesús ja ba Samaria. Ti xa cho stul ja sbeja, como ti ni huajum ja ba Galilea, ");
INSERT INTO tojNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porque yala nia, jun aluman‑Dios mi huax quitzji ja ba mero xchonabili. ");
INSERT INTO tojNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero cuando c'ot ja ba Galilea, ja suinquil ja tihui, jel sgustoe porque ti staa c'ot sbaje ja iluj q'uin jau ba syalq'uinal ja ba Jerusaleni. Yilahue spetzanil ja jas sc'ulan ja Jesús ja ba q'uin jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ja mas tzaan t'usani ti xa cumxi ba Caná como ti ni ay ba Galilea ja hacienda jahui, ja' ni ja ba ya pax yalel tz'usubil ja jai. Jaxa tihui tey jun huinic ac'ubal yi jun nihuan atel yuj ja gobierno. Ja huinic jahui ay jun yunin ja ba Capernaumi, pero jel bi malo ay. ");
INSERT INTO tojNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jayuj yajni yab que ti xa ay ba Galilea ja Jesusi ‑ el ta jan ja ba Judea ‑ ti huaj yila. Ti sc'ana yi lec pavor ta oj huajuc ja ba snaji ba oj ya tojbuc ja yunini porque lajan bi soc oj xa cham altiro. ");
INSERT INTO tojNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ti yala ja Jesusi: ―Ja huenlexi, mi ni nunca oja c'uuquex ta mi xa huilahuex ja milagro. Quechan huaxa c'anahuex oja huilex jun seña, ti to oj jac ac'ujolex que meran ay quipa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","―Pero Cajual, cax huego. Repente xcham mas ligero ja cunini, xchi ja huinic jau ja ma' ay yateli. ");
INSERT INTO tojNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ti yala ja Jesusi: ―Cax xa ja ba hua naji porque ja hua huunini lec xa ay, x'utji ja huiniqui. Jayuj sc'uan ni ja jas yala ja Jesusi. Ti huaja. ");
INSERT INTO tojNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cuando oj xa c'otuc ja ba snaji, ja smozo jumasa ti huaj stae jana. Ti yalahuea: ―Ja hua huunini, lec xa ay. ");
INSERT INTO tojNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Entonces ti sobo jas ora och tojbuc ja yunini. Jaxa yenlei ti yalahuea: ―Pues eque ta como mojan tz'elan t'usan ja c'ac'u, ti ec' ja sc'ajc'ala, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yajni yab ja tatal ja jastal iti, ti jac sc'ujol ja' ni mero ora cuando alji yab yuj ja Jesusi que lec xa bi ay ja yunini. Ja huinic jahui, spetzanile ja janec' aye ba yoj snajei, ch'ac ni sc'uuque ja Jesusa. ");
INSERT INTO tojNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja iti, ja' ni ja ba xchabil vuelta sc'ulan ja milagro ja Jesusi, pero nihuan milagro. Ti ch'ac el jan ja ba Judea. Ti xa ni ay ja ba Galilea cuando sc'ulan ja milagro jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jaxa mas tzaan ja iti, ja judio jumasa sc'ulane jun q'uin jayuj ja Jesusi, ti xa cho cumxi otro vuelta ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jaxa ba yoj chonab Jerusaleni, ja mojan stz'eel ja puerta ja ba huax ec' ja cheji, ay jun tanque sbaj ja'. Betesda sbiil yujile ja ba sc'umale hebreoi. Ja ba sti ja tanque jahui ay joe ten. ");
INSERT INTO tojNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jaxa ba yaxubil ja ten jumasa jahui, ti sacbanban ec' jitzan lec ja chamum jumasa. Ay ma' tupel ja sati, soc ay ma' renco ay, soc ay ma' tulido ay ja yoc sc'abi. Ja' huane smajlajel jas ora huax q'ue snic sbaj ja jai ");
INSERT INTO tojNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porque tiempo tiempo ita huax co jan jun ángel ja ba tanque jahui, ti huas snica sbaj ja jai. Jaxa ma' och mero bajtani, tojbi nia, chican jas chamelil yioj ajyi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Jaxa tihui, tey jun huinic. Ay xa yioj treinta ocho jabil malo ay. ");
INSERT INTO tojNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jaxa Jesusi ti yila ti baan ec' ja tihui. Ti jac sc'ujol ay xa jitzan tiempo malo ay ja huinic jahui. Ti yalaa: ―¿Mi ma xa c'ana oj tojban ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Pero Cajual, mi ma' huax bob scoltayon oj ochcon cuando huax q'ue snic sbaj ja jai. Cada vuelta cuando huax c'ana oj ochconi, huan tox huaj quile, huas sipa sbaj ja tuqui, xchi ja ma' malo ayi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ti yala ja Jesusi: ―Q'uean. Paca hua huaynubi. Cax xa. ");
INSERT INTO tojNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jaxa huinic jahui, huaj to snaa sbaj, lec xa ni aya. Ti spaca ja suaynubi, ti och bejyuca. Pero como ja' ni ja sc'ac'uil ja jijleli, ");
INSERT INTO tojNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jayuj ja judio jumasa ti yalahue yab ja ma' ch'ac ta tojbuqui: ―Pero ja huego ja' sc'ac'uil ja jijleli. ¿Jastal lec atelunej xa ja hua pop ba? xyutaje. ");
INSERT INTO tojNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ti yala ja huiniqui: ―Pero ja ma' ya tojbuconi, yen yala cab que oj xa jtul ja juaynubi. Oj bi bejyucon. ");
INSERT INTO tojNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","―¿Jas sbej oja tul ja hua huaynubi? ¡Huaxa huala oj xa bejyan! ¿Machunc'a yala huab ja jastal jahui? xchi ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","―Pero mix naa machunc'a ya tojbuconi, xchi ja huiniqui. Jach yala yuj ja jel ni but'el ja cristiano ja tihui, como ja Jesusi, huaj ta nia. ");
INSERT INTO tojNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pero ja mas tzaani ja Jesusi ti staa ba yoj templo ja ma' tojbi nii, ti yal yaba: ―Q'uelahuile, lec xa aya. Moc xa lee otro vuelta ja hua muli. Huan c'a xa lea otro vuelta ja hua muli, mas to pegor oj huajan, x'utji ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jayuj ja huiniqui ti huaj ja bay ja judio jumasa. Ti yalaa: ―Ja' ni ja Jesús ja ma' ya tojbuconi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jayuj ja judio jumasa ti och yixtalauque lec ja Jesusi ja jastal huax ya tojbuc ja cristiano. Mi bi sbejuc jachuc huas sc'ulan ja ba sc'ac'uil ja jijleli. ");
INSERT INTO tojNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ti yala ja Jesusi: ―Q'uelahuilex, ja jTati c'ac'u acual huan atel y jach ni ja queni, t'ilan oj cho atjucon. ");
INSERT INTO tojNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jayuj ja judio jumasa, mas to jel sgustoe huas sc'ana oj xch'ay snaajel ja Jesusi porque mi quechanuc huan sc'oquel ja smandare soc ja sc'ac'uil ja sijlelei, huan bi cho stoyo sbaj lom que ja' bi sTat ja Diosi: ―¿Yuj ama huax yala que Dios ja yen ba? xchiye xta ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ti yala ja Jesusi: ―Huax cala huabyex, pero meran, quena ni yuninon Diosa pero anima, ja jas huax c'ulani, mix bob jc'uluc ja quechan ja queni. Masan to huax naa jastal huas sc'ulan ja jTati, ti huax cho jc'ulan ja queni. Spetzanil ja jas huas sc'ulan ja jTati, jach ni huax cho jc'ulan ja queni, como yuninon nia. ");
INSERT INTO tojNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ja jTati, jel yaj huax yabyon jayuj huas sea qui spetzanil ja jas huas sc'ulani. Ay to jas oj see qui mas jel nihuan, jaxa cuando huaxa huilahuexi, jel oj och ja hua pensarexi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ja jTati, hasta huax ya sac‑huuc ja ma' cham ta y jach ni ja quen chomajquili, chican machunc'a huax c'ana, oj ni ca sac‑huuca. ");
INSERT INTO tojNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ja jTati, mi yenuc huas stojbes ja cristiano. Yaunej qui ba jc'ab ja queni, ba quena ni oj tojbes ja cristiano jumasa. Quena ni oj cal jas castigoil oj yii ja cristiano soc quena ni oj cal ta oj huajuque libre. ");
INSERT INTO tojNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jayuj ja mero sbeji, sbaj ni oj yajtajucon ja jastal huax yajtaji ja jTati. Y jach ni, ja ma' mi huas sc'ulanon caso ja queni, mi ni huas sc'ulan caso ja jTati ja ma' seconejon ahuilexi, porque yuninon ni ja quena. ");
INSERT INTO tojNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Huax cala huabyex ja smeranili, ja ma' huas smacla ja jas huax cala, ta huan c'ax cho sc'uan ja Dios Tatal ja ma' secahuon coni, ja yeni staa ta ni ja svida jau mix ch'aqui. Mi ni oj ch'ayjuc snaajela. Yaa ta can ja vida it oj ni cham ajyi ja yaltzili, jaxa huego, ay xa yioj jun yajc'achil vida. Mi ni nunca oj chamuca. ");
INSERT INTO tojNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Huax cala huabyex, pero meran, oj c'otuc ja c'ac'u ja ma' cham ta, oj yab ja jc'umali y como yuninon ni ja Diosa, oj ni ch'ac sac‑huuquea ");
INSERT INTO tojNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Porque ja queni, quena ni huax caa ja sac'anil ja cristiano. Ja jTati sac'an ni leca y mi ma' yaa yi ja sac'anili jayuj jachuc ja quen chomajquili. Yuj ni jach ni huas sc'ana ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ti ni coelon jan ja ba satq'uinali, jayuj yaa qui ba jc'ab ba oj tojbes ja cristiano. Quena ni oj cal ta oj yii castigo ma miyuc. ");
INSERT INTO tojNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Oj ni c'otuc ja c'ac'u ja ma' chamel xa, oj yab ja jc'umali ti ni oj eluque ja ba sq'uejnalei. Jaxa ma' toj ecye ja ba svidaei, cuando huas sacuiyei, oj ni staa svida jau jel tzamali, pero ja ma' mi tojuc ecye ja janec' sac'ane to ajyi, eso sí, oj ni sac‑huuquea pero ti xa oj aljuc yabye jas castigo oj yie. ¿Jasyuj jel ja hua pensarex ja jas huax cala ba? ");
INSERT INTO tojNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ja queni, mi jas huax bob jc'uluc ja jtuch'ili. Meran nia, quena ni oj cal jastal oj to huajuc ja cristiano, pero chican ja jas huax yala cab ja jTati. Pero toj ni ja castigo oj caa yile. Ja queni, mi jauc huax c'ulan ja jas huax c'ana ja queni, ja' ni huax c'ulan ja jas huas sc'ana ja jTat ja ma' secahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ta quechan c'a quen ti huax el ja ba j'olom ja jas huax calai, entonces mi ni oj bob ac'uuconex ja jastal jahua. ");
INSERT INTO tojNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero ja iti, ay otro jun ja ma' huas staahuon ti' y huan nix naa ja jas huax yala jbaji, ja' ni mero smeranili. ");
INSERT INTO tojNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ja' ni ja Juan it ja ma' yaa bautismo, ja yeni ja jecahuex joboman mach ayon bi ja queni, jaxa jas yala huabyexi, smeranil nia. ");
INSERT INTO tojNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ja queni, jun xta huax cabi, como huinic ni ja yeni. Jel ni lec ja jas yala jbaji. Yala, pero ba oj scolta ja hua hualtzilexi, jayuj huax cala huabyex ja huego. Pero mi huinicuc ja ma' huas snaa machunquilon merani. ");
INSERT INTO tojNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Eso sí, ja Juani jel tzamal ja jas sc'ulani. Lajan soc huax ijlabani eq'ue. Jel tzamal ahuilahuex ja yijlabi, pero quechan t'usan tiempo. ");
INSERT INTO tojNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jel ni tzamal staahuon ti' ja yen yen, pero ja catel huanon sc'ulajeli, malan soca. Huanex ni yiljel soc mismo asatexi y seguro huax jac ac'ujolex que mi cualquiera ateluc. Mero seña lec que jecubalon yuj ja Dios Tatali, como yena ni huax yala cab jasunc'a oj c'uluqui. ");
INSERT INTO tojNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yena ni ja jTati ja ma' secahuon coni, yen mismo huax yala que quen ja yuninoni, jayuj jel tzamal huax el ja jas huax c'ulan tac. Pero ja huenlexi, mi ni huaxa huabyex ja jas huax yala ja jTati soc mi nix bob ahuilex ja sat ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ja jas huax yala, mi ni huaxa huiajex snihuanila, como mi huaxa c'uanex que jecubalon yuj ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Eso sí, tola vida huaxa q'uelahuex ja slibro ja Diosi. Jel ja hua gustoexi. Huaxa hualahuex ta huan c'ax aq'uelahuex lec ja slibro ja Diosi, oj ni ataa ja vidaex jau ba mi ni nunca oj ch'acuqui. Ja' ni mero atiex ja jahui. Iday, q'uiq'uinal ayex juntiro porque ja ba libro jahui, ti ni huala taajiyon ti' ja quena. ");
INSERT INTO tojNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mi ni modo huala jacyex jmoc ba oja taa ja hua vidaex ba jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","¿Yuj ama huaxa hualahuex que huanon sleejel ba oja toyonex? ");
INSERT INTO tojNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ja quen huan nix naa jastal ay ja hua c'ujolexa. Huax naa que mi yajuc huaxa huabyex ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ti ni ayon ja ili yuj ja seconejon ni con ja jTati pero iday, mi xa quitz'ahuonex. Pero ta ay c'a ma' huax jaqui, mi ni ma' jecubal yuj, eso sí, ja jahui, jel nihuan huaxa huiajex. ");
INSERT INTO tojNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ja' mero agustoex ja' huaxa toytalaan abajexi, pero ba oj stoyex ja Dios jel nihuani, mi ni t'usan tey ja hua pensarex soc ja yeni. ¡Jastal oj bob ajyanic toj ja jastal jahui! ¡Mi huaxa c'uanex tac! ");
INSERT INTO tojNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","¡Majlayic! Ja c'ac'u jau oja huaex cuenta ja ba sti sat ja jTati, mi xa hualahuex ta quen oj cal ja hua mulexi. Ja Moisesi, yen to ni bajtan oj yal janec' ja hua mulexa, iday, ja Moisés jahui, ja' mero snihuanil ac'ujolex. ");
INSERT INTO tojNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pero ta meran c'a huaxa c'uanex ja jas yala ja Moisesi, oj ni cho ac'uuconex ja quena porque ja ba slibro ja Moisesi, quena ni huala taajiyon tia. ");
INSERT INTO tojNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ja mero smeranili, mi ni huaxa c'uanex ja slibro ja Moisesi, ¡jauc to ma oja c'uuquex ja jas huax cala ja queni! ");
INSERT INTO tojNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ja mas tzaan t'usani, ja Jesusi ti ec' ja ba otro lado ja ja' jau ba Galilea. Ja ja' jahui, ay otro sbiil yujile, Tibérias. ");
INSERT INTO tojNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jel jitzan ja cristiano ti huajye nochani, como yiluneje jastal huax ya tojbuc ja matic malo ayi. Ja' bi sbaj Dios ja jas huas sc'ulani. ");
INSERT INTO tojNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ja Jesusi soc ja snebuman jumasa ti xa q'ueye ba jun huitz. Ti ochye culan ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ja ora jahui, jel xa ni mojan ja syalq'uinal huas stalnaye ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huaj to yile, jel jitzan ja cristiano huan jaquel ja bayei. Ja Jesusi ti yal yab ja Felipe: ―¡Mi c'a cal cristiano huan jaquel! ¿Ba xa oj huaj mantic ja juaeltic soc ja cristiano jumasa it ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jach yala jachuc, pero quechan ba oj yab jas oj yal ja Felipe, como ja Jesusi huan ni snaa jasunc'a oj xa sc'uluqui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ti yala ja Felipe: ―Mi ni mil peso pan oj yaa ba oj elcotic xentic yaman, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Entonces ja Andresi, ja' ni june ja snebuman ja Jesusi, yijtz'in ni ja Simón Pedro, ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ja ili, tey jun yal querem. Ay yioj joe pan negro soc chab chay, pero ja jahui, mi janec' oj eluc. ¡Pe jun montón ja cristiano tac! ");
INSERT INTO tojNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ti yala ja Jesusi: ―Alahuic yab spetzanile a ochuque culan, xchi ja Jesusi. Ja tihui, jel tzamal ja aqui. Ti ochye culana, pero ay ni mojan joe mil huinica. ");
INSERT INTO tojNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ja Jesusi ti yiaj ja joe yal pani, ti sc'ana yi stz'acatal ja Diosi. Ti xa yaa yi ja snebuman jumasa, jaxa snebuman jumasa, ti spila yile ja matic ti culane eq'ue. Jach ni sc'ulan soc ja chay chomajquili. Ya ec' yile ja cristiano, chican janec' huax butye. ");
INSERT INTO tojNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Cuando ch'ac ta but'uque lec ja cristiano, ja Jesusi ti yal yab ja snebuman jumasa: ―Ch'acan tzomohuic spetzanil ja sobra ja pani porque mi ni modo oj ch'aytic loma. ");
INSERT INTO tojNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ti stzomohuea. But' lajchahue mooch ja spedazoil ja joe pan negro jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Cuando yilahue ja cristiano ja jas sc'ulan ja Jesusi, ti yalahuea: ―Ja huinic iti, ja' ni meran ja yaluman‑Dios oj ni jacuc ja ba mundo. Malan soc ja jas huantic yiljeli, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ja Jesusi ti yab xchiq'uel que huas sc'ana ja cristiano que fuerza oj yaahue och reyil, jayuj ti spila sbaj soc ja yenlei. Stuch'il ni huaj ja ba huitzi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Cuando oj xa och ja acuali, ja snebuman jumasa ja Jesusi ti coye ja ba huitzi. Ti huajye ja ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Q'ueye jun barco, ti och ya bejyuquea. Ti huas sc'ana oj huajuque ja ba Capernaumi. Q'uic' xa lec ja q'uinali pero ja Jesusi mi tox cumxi coni. ");
INSERT INTO tojNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ti jac jun tzatzal ic' leca, ti q'ue spuctzuc sbaj tzatz lec ja jaa. ");
INSERT INTO tojNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ja ora iti, bejyiye ta mojan joe ma huaque kilómetro, iday, huaj to yile, ja Jesusi ti xa nochan ja ba spatic ja barco. Huan bejyel ja ba sat ja jai. Jaxa yenlei, jel xiuye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ja Jesusi ti yalaa: ―¡Mi la xiuyex! ¡Quena nia! xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jaxa yenlei, jel gustoaxiye juntiro cuando q'ue ja ba yoj barco ja Jesusi. Huaj to yile, elye ta t'an c'ot ja ba sti ja ja' ja ba huajume ni. ");
INSERT INTO tojNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yajni el ja c'ac'u ja cristiano jumasa ja ma' canye ja ba otro lado sti ja jai, ti jac sc'ujolea, ja snebuman jumasa ja Jesusi, que huajye ta soc ja yal barco ti ni ay ja tihui, como quechan ni jun yal barco aya. Huax yalahue que mi huaj ja Jesús soc ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Cuando jach to huane yaljeli, huaj to yile, c'ot chaboxe yal barco ja ba mojan stz'eel ja ba huaayei, ja huaelal it ba sc'ana stz'acatal ja Cajualtiqui. Jaxa yal barco jumasa jahui, ti elye jan ja ba chonab Tiberiasi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Yajni yilahue que meyuc ja Jesusi, soc mi ni ja snebuman jumasa, ti q'ueye ja barco jumasa jahui. Ti huaj slee ja ba Capernaumi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Yajni c'otye ja ba otro lado sti ja jai, ti staahue ja Jesusi. Ti sobohue yia: ―Maestro, ¿jas ora julya ja il ba? ");
INSERT INTO tojNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ti yala ja Jesusi: ―Oj cala huabyex ja smeranili. Jac ta jc'ujol jas sbej huaxa leahuonex eq'ue. Como butyex ni lec soc ja pan jahui pero mi ni t'un huax jac ac'ujolex ja jas huan sc'ulajel ja Dios ja ili. ");
INSERT INTO tojNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ja huenlexi, quechan ja' huajel ac'ujolex sleejel ja sbaal ja hua lucumexi. Eso sí, lec ni yena, pero ja huaelal jahui, ec'um bej ita nia. Ja mero sbej, oja leex jastal mas lec oj ajyuc ahualtzilex ja ba otro lado porque quena ni huax caa ja sac'anil ja hua hualtzilex tac. Jach huax cala porque ja queni ti ni coelon jan ja ba satq'uinali. Ja' ni mero seña que seconejon con ja Dios Tatali. ");
INSERT INTO tojNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ti yala ja cristiano jumasa: ―¿Jastal oj naaticon jasunc'a huas sc'ana ja Dios oj c'ulticon ba? ");
INSERT INTO tojNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ti yala ja Jesusi: ―Oj cala huabyex jasunc'a huas sc'ana ja Dios Tatali, huas sc'ana que oja c'uuconex ja queni porque yena ni seconejon con ja Diosi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","―Pe ¿jastal oj naaticon ta meran ja quenticoni? Quechan lec ta huaxa c'ulan jun nihuan milagro, c'ulan jun nihuan atel ba oj quilticon, ti oj c'uucaticona. ");
INSERT INTO tojNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Q'uelahuil ja ma' ec' pax ta cujtiqui. Ti ajyiye ec' ba jun ch'ayan lugar ba mey suinquil pero iday, huaaye lec. Ti co jan ba satq'uinal ja spanei. Jach ni huax yala ja yabal ja Dios tac, xchiye xta ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti yala ja Jesusi: ―Pero ja pan yaa ja Dios ja ba stiempo ja Moisesi lajan soc jastal jun seña. Ti ni co jan ja ba satq'uinali. Sloohue pero mi yaa sac'anil ja yaltzile ja pan jahui. Pero ja huego, ja Dios Tatali secunej con ja ba satq'uinali jun pan ba huax yaa ja sac'anili ");
INSERT INTO tojNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jaxa spetzanil ja cristiano ja ma' huas sloo ja pan jahui, oj ni staa ja svidaea. Ja pan jahui, ti ni coel jan ja ba satq'uinali como Dios ni ja ma' huax yaa. ");
INSERT INTO tojNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ti yalahuea: ―Pues q'uelahuile tata, ¿mi ma ay modo oja huaa quiticon tola vida ja pan jahui? ");
INSERT INTO tojNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ti yala ja Jesusi: ―¡Pero quen mismo ja pan huanon yaljel tac! Jayuj huax cala, ja ma' huax jac jmoqui mi ni nunca oj cham huain. Oj ajyuc sac'anil tola vida. Ja ma' huas sc'uanoni, mi ni nunca oj cho tacjuc sti. ");
INSERT INTO tojNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cala ta nia huabyex tac, anima huaxa huilahuonex soc xchabil ja hua satexi, pero mi ni huaxa c'uanonexa. ");
INSERT INTO tojNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ta ja' c'a jTat huas seca jan qui ja cristiano, oj ni jacuque jmoca. Spetzanil ja ma' huax jac jmoqui, mi ni modo oj nutz ele. ");
INSERT INTO tojNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jayuj ti ni coelon jan ja ba satq'uinal tac, ba oj c'uluc ja jas huas sc'ana ja ma' seconejoni. Mi jaquelucon quechan oj c'uluc ja jas huax c'ana ja quen mismo. ");
INSERT INTO tojNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ja yen ja ma' secahuon coni mi huas sc'ana oj ch'ay ja ma' yaunej xa ni quii. Mi ni bi june oj ch'ayuc. Oj bi ca sac‑huuc ja último c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Oj bi staa ja svida ba mi ni nunca oj ch'acuc. Jach ni huas sc'ana ja jTati ja spetzanil ja ma' huax yaa sbaj jmoqui, ja' ni ja ma' huas sc'uanon merani porque yuninon ni ja Diosa. Ja yenlei, oj ni ca sac‑huuc ja último c'ac'u jahui, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jaxa judio jumasa, cuando ch'ac yabye ja iti, ti och bulbunuc ja ba ja' mi jauqui: ―¡Jastal modo oj yal que pan ja yeni y ti bi cho co jan ja ba satq'uinali! ");
INSERT INTO tojNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","¿Pe mi ma yenuc ni ja yunin ja tan José ba? ¡Pero ja tantic cristiano jahua, jmoj ni jbajtic soca! ¡Jastal lec huan yaljel que ti coel jan ja ba satq'uinali, huax yutalaan sbaje! ");
INSERT INTO tojNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ti yala ja Jesusi: ―Ch'abananic t'usan. ");
INSERT INTO tojNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Meran ni ja jas huax cala. Ja jTati seconejon nia ba oj ca sac‑huuc ja cristiano ja último c'ac'u. Ta mi c'a jauc ja jTat huas seca jan quii, pues mi ni ma' oj jac jmoca. ");
INSERT INTO tojNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Q'uelahuile ja jas huax yala ja ba slibro ja aluman‑Dios jumasa. Ja ma' huax jac jmoqui, yuj ni bi huax alji yab yuj ja Diosi. Spetzanil ja ma' huax yab slugaril ja jas huax yala ja Dios Tatali, ja ma' huax yaa sbaje merani, oj ni jac jmoca. ");
INSERT INTO tojNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero mi ni huax bob yile satalajel abal ja jTati. Quechan ni quen quilunej, como ti coelon jan ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jayuj huanon yaljel ahuabyex ja smeranili. Ja ma' huas sc'uanon ja queni, staa ta ni ja svida ja ba mix ch'aqui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Lajan soc sueahue ni ja pan it huax yaa sac'anilei, pero quena ni ja pan jau tac. ");
INSERT INTO tojNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ja ma' ec' pax ta huujilexi, cuando ti aye ba ch'ayan lugar jahui, sloohue ni ja yal ch'in pan jau co jan ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero tuc panil ja jas huanon yaljel ja quen it co jan ba satq'uinali. Ja ma' huas suea ja pan huax calai, mi ni oj chamuquea. ");
INSERT INTO tojNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja pan iti, sac'an ni leca como ti ni co jan ja ba satq'uinali, como quena nia. Jaxa ma' huas suea ja pan iti, oj ni ajyuc sac'anil tola vida. Quena ni oj caa yi ja svidae jahui. Oj caa ja mismo jcuerpo ba oj staa ja sac'anil ja cristiano jumasa. Lajan soc oj pax panil ja jcuerpoi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ti och bulbunuque ja judio jumasa: ―¡Huax yala oj yaa quitic ja pani! ¡Oj bi hueetic pero huax cho yala que ja' bi ja scuerpo! ¿Sbej ama jas huan yaljel ba? ");
INSERT INTO tojNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ti yala ja Jesusi: ―Pero meran nia huax cala huabyex, ja queni ti coelon jan ja ba satq'uinali pero anima, oj ni caa ja jcuerpo. Oj ni pec' ja jchiq'uela pero ta mi c'a xa c'ulanex caso, yuj ni ch'ayelex nia, yuj ni mi ataunejuquex ja hua vidaexi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pero ja ma' huas sc'uan soc spetzanil ja sc'ujoli, mi ni t'un lom oj caa ja jcuerpo, oj ni jpec' ja jchiq'ueli yuj ja yeni, ta huan c'a sc'uan meran, oj ni staa svida jau ba mix ch'aqui, jaxa queni, oj ni ca sac‑huuc ja último c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porque meran, mi lom oj caa ja jcuerpo, mi ni lomuc oj pec'uc ja jchiq'uela. Yuj ni oj caa jbaj ba oj staa ja svidae ja cristiano tac. ");
INSERT INTO tojNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ja ma' huas sc'ulan entender jas sbej huax caa ja jcuerpo, jas sbej huax pec'a ja jchiq'ueli, ja yeni soc ja queni, jel mojan oj quii jbajticon soc. ");
INSERT INTO tojNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ja Dios Tatali, sac'an ni leca. Yena ni seconejon coni. Stz'acatal ja yeni, ay sac'anil ja quen chomajquili. Jach ni ja ma' huas sc'uanon ja queni, oj ni staa ja mero sac'anili. ");
INSERT INTO tojNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja pan it huax cala ti co jan ja ba satq'uinali, pero ¡quena nia! Ja ma' huas sloo ja pan jahui, mi ni nunca oj chamuc. Tuc juntiro ja pan jau sloo ja ma' ec' pax ta huujilex yen porque ja yenlei, chamye nia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Spetzanil ja jastal iti, ti ch'ac yal ja ba yiglesia ja judio jumasa, ja' ni ja iglesia tey ba Capernaumi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ja ma' nochan ec' soc ja Jesusi, ja ch'ac yabye ja jastal iti, ti yalahuea: ―¡Jel huocol juntiro oj bob sc'uajel porque mix chijcaji jas sbej ja jas huax yala tac! ¡Mi ni ma' oj yaa caso jun loil jastal jahui! ");
INSERT INTO tojNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ja Jesusi ti jac sc'ujol jastal lom huane bulbunuc ja snebuman jumasa jayuj ti yalaa: ―¿Jel ama piero ahuabyex ba? ");
INSERT INTO tojNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¡Jauc to ma xa huilahuex huala q'ueyon otro vuelta ja ba coyon jani! ¡Saber jasunc'a oja c'uluquex pensar cuando huaxa huilahuexi! ");
INSERT INTO tojNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja jas ch'ac ta cali, huanon staajel ti' ja hua hualtzilexi. Huanon yaljel ja hua vidaex it ba mi ni nunca oj ch'acuqui. Ja poco modoex ba jel piero, lom ni altiroa. ");
INSERT INTO tojNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero ja huenlexi, ay to ni ja ma' mi huas sc'uanon ja huujilexa, xchi ja Jesusi. Jach yala yuj ja huan ni snaa desde yora mi tox cujlaji ja satq'uinali ja ma' mi ni oj sc'uuca. Cho snaa ni machunc'a oj ic'unuc spatiqui, jayuj ");
INSERT INTO tojNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ti yalaa: ―Jayuj cala ni ahuabyex tac, mi ni ma' oj bob jac jmoc ja queni ta mi c'a jauc huas seca qui ja jTati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ja ora jahui, jitzan ja ma' nochan soc ajyi ja Jesusi, pero cuando yabye ja jas yala, ti xa spiltalaan sbajea. Mi xa ni huajye ec' soc ja yena. ");
INSERT INTO tojNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Cuando yila huajye ja tuqui, ja Jesusi ti sobo yi ja lajchahuane ja snebumani: ―Jaxa huenlexi, ¿jas la chiyex? ¿Mi ma huax cho hualahuex oj huajanic? ");
INSERT INTO tojNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ti yala jan ja Simón Pedro: ―Pero Cajual, ¿machunc'a oj huajcoticon soc ba? porque ja jas huaxa huala, ja' ni mero huana yaljel ja vida jau mix ch'ac tac. ");
INSERT INTO tojNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ja quenticoni, jc'uanticon ta. Huax naaticon, huena ni ja Cristoa, yunina ni ja Dios jel sac'ani, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ja Jesusi ti yalaa: ―Meran, ja huenlexi, lajchahuanex nia. Tzaubalex cuj pero ay june ja huenlexi, ja' ni smoj ja diablo, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pero ja' ni huan staajel ti' ja Judas Iscariote, ja it Simón sbiil ja stati porque ja Judas jahui, yena ni oj yii spatic ja Jesús ja mas tzaani, iday, ja' ni june ja lajchahuane ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tzaan ja iti, ja Jesusi ti ajyi ec' ja ba Galilea porque ja ba Judea ja judio jumasa huane sleejel modo jastal oj bob xch'aye snaajel. ");
INSERT INTO tojNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jel xa mojan ja q'uin jau ja huas sc'ulan ja judio jumasa ja cuando huas sc'ulane jitzan ja jacali ‑ sq'uin jacal sbiil yujile. ");
INSERT INTO tojNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ja yermano jumasa ja Jesusi ti yalahuea: ―¿Jastal lec ti aya il ja huen ba? ¿Jaxa mi la huaj ja ba Judea porque ja tihui ti ni jel ja hua huamigo tac. Cax jea yi ja atel huana sc'ulajeli ");
INSERT INTO tojNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porque mi ni sbejuc oj nacxuca. Sbej ni oj naaxuc machunquilucaa. Ja jas huana sc'ulajeli, c'ulan satalajel abal, xchi ja yermano jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jach yalahue porque mi ni ja yermano jumasa mi ni t'usila huax yiaje snihuanil ja sbanquilei. ");
INSERT INTO tojNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ti yala ja Jesusi: ―Pero mi to staa ja jtiempo jas ora oj jee jbaj satalajel abal. Quechan ja huenlexi, chican jas ora huaxa c'ana huajanic pero ja queni, mi cualquiera orauc oj huajcon. Como ja huenlexi, naca suinquilex ja mundo iti, jayuj mi ni oj bob ahuil abajex condraa. ");
INSERT INTO tojNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Como ja hua mojex, ti ni ay ja hua pensarex ja ba mundo. Mi ni sbejuc oj yijnayexa, pero ja queni, coraja ni huala iljiyona como claro huax cala que jel piero ja smodo ja ma' tey ba mundo. ");
INSERT INTO tojNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cax ilahuic ja q'uin ja huenlexi. Ja queni, mi to huajcon porque mi to tiempouc oj jee jbaj satalajel abal. ");
INSERT INTO tojNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jach ni yala ja Jesusi. Jayuj ti can ja ba Galilea ja chaboxe c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero cuando ch'ac huajuque ja ba q'uin ja yermano jumasa, ti cho huaj tzaan ja yeni. Pero mi ni ma' huas snaa como ch'abanti abal huaji. ");
INSERT INTO tojNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jaxa ti ba yoj q'uin jahui, ti huan leejel yuj ja smoj judioil jumasa. Ti huax yalahuea: ―¿Bay ja tan huinic jau ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jaxa cristiano, ja' ni mero huane xta staajel ti' ja Jesusi. Ay ma' huax yala que lequil huinic, jaxa tuqui huax yalahue que mi lequil huinicuc. ―Quechan huan slolajel ec' ja cristiano, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero ja sloilei, mi ni mero satalajel abaluca, como huane xihuel t'usan yuj ja smoj judioilei. ");
INSERT INTO tojNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ja q'uini, oj xa staa snalan cuando ti xa och c'ot ja ba templo ja Jesusi. Ti och see ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Entonces ja judio jumasa jel och juntiro ja spensarei. Ti yalahuea: ―¿Pe jasyuj jel huas snaa juntiro ja iti? ¡Porque mi ni jas estudio yioj tac! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ti yala ja Jesusi: ―Pero ja jas huanon seejel ja queni, mi jauc quechan ja jas huax el ja ba j'olomi. Ja ma' secahuoni, yena ni huax yala cab jasunc'a oj jei. ");
INSERT INTO tojNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ja huenlexi, ta meran c'a xa c'ana oja c'uluquex ja jas huas sc'ana ja Diosi, oj ni jac ac'ujolex ba huax jac ja jas huanon seejeli. Oja naex ta ja' c'a sbaj ja Diosi ma lom huan elel ja ba j'olom ja queni ");
INSERT INTO tojNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Porque ja ma' lom huan yaljel ja jas huax el ja ba s'olomi, quechan huan sleejel ba oj toyjuc. Pero ja ma' meran huan sleejel ba oj iljuc lec yuj ja Diosi, oj ni yal ja smeranili, mi ni modo oj yal ja mentira. ");
INSERT INTO tojNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ja Moisesi, yena ni yaa ja mandar jumasa pero iday, mi ni june huaxa c'uanex ja mandar jumasa jahui. Entonces, ¿sbej ama huanex sleejel modo jastal oja milonex ba? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","―¡Ja hueni, ja' xa ma amoj ja diablo! ¿Machunc'a huax yala oj smila? xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ti yala ja Jesusi: ―¡Ja huenlex nia! Jel cham ahuabyex ja t'usan ja jas jc'ulan ja c'ac'u jijleli. ");
INSERT INTO tojNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","¡Pe jach ja huenlex tac! Anima jauc ja sc'ac'uil ja jijleli, huan ni xa c'ulanex circuncidar ja yal queremtiqui, como jach ni yala can ja Moisesi. Ja mero smeranili, mi jauc ja Moisés ya q'ueuc ja costumbre jahui. Ti xa ni aya ja stiempo ec' ja yeni ");
INSERT INTO tojNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pero mi ni modo oja c'oquex ja smandar jau ja Moisesi jayuj anima jauc ja sc'ac'uil ja jijleli, huaxa c'ulanex circuncidar. Jaxa queni yuj ja ca tojbuc jun chamumi, jel coraja huaxa huilahuonex. ¿Sbej ama jau ba? ");
INSERT INTO tojNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mi lom la c'umaniyex cuando mi xa naahuex jastal ja sbeji. Quechan ta seguro c'a ayex, eso sí, oj bob c'umananic, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ti och sobtalauc sbaje chanjoe cristiano ja ma' ti sbaje ba Jerusaleni: ―¿Mi ma yenuc ja it huan leejel ba oj miljuc ba? ");
INSERT INTO tojNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¡Jastal lec mi jas huax yalahue ba! Pe satalajel abal ba yoj comon huan c'umal tac. ¿Yuj ama huas sc'uan ja ma' ay yatel que yena ni meran ja Cristo ba? ");
INSERT INTO tojNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","¡Pero chican lec ba jac ja tan huinic iti! Ja Cristo cuando huax jaqui, mi ni ma' oj snaa ba oj jacuca, xchiye xta ja cristiano jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jayuj ja Jesusi, cuando och see ja ba templo, ti yalaa: ―¡Entonces huaxa naahuex jbaj! ¡Huaxa naahuex ba jaquelon ta jachuqui! Pero naahuic que mi quen cala oj jacon. Ja ma' secahuoni, mi ni huaxa naahuex sbaja. Ja yeni puro smeranil ja jas huax yala. ");
INSERT INTO tojNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ja queni huax naa sbaj porque ti ajyiyon soca. Yena ni secahuon cona, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jayuj ja cristiano huas sc'ana oj syame pero mi ni june ma' bob yujili como mi to ni yorauca. ");
INSERT INTO tojNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero jel ni ja ma' sc'uane ja ora jahui, ti yalahuea: ―¿Yuj ama mas jel nihuan oj bob sc'ul ja milagro ja Cristo ba? Pero ja huinic iti, jel nihuan juntiro ja jas huan sc'ulajel tac. ");
INSERT INTO tojNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jaxa fariseo jumasa ti yabye ja jastal q'ueel ja sc'umal ja cristiano, jayuj ti secahue ja policía ja ma' huax atjiye ja ba templo ba oj syame ja Jesusi. Ti cho ch'ican ja pagre mas nihuaqui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ti yala ja Jesusi: ―Lec nia pero quechan t'usan tiempo oj ajyucon amoquex, jaxa mas tzaani t'ilan oj cho cumxucon soc ja ma' secahuoni. ");
INSERT INTO tojNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Oja leonex eq'ue pero mi ni oja taonexa porque mi oj bob huajanic ja bayoni. ");
INSERT INTO tojNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Cuando yabye ja jahui, ja judio jumasa ti och yal sbajea: ―¿Ba oj huajuc ja it ja huan yaljel mi oj bob jtaatiqui? ¿Mi ma ti oj huajuc soc ja jun c'ole jmojtic judioil ja ma' ti xa aye soc ja tantic griego? Seguro ja' oj cho huaj see yi ja yenle chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jas sbej huax yala oj leetic y mi oj taatic porque mi bi oj bob huajtic ja ba oj ajyuqui, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ja ba q'uin jahui, ja' ni mas nihuan yioje ja último c'ac'u huax ch'ac ja q'uini. Ja c'ac'u jahui, ja Jesusi ti q'ue tec'ana, ti yala tzatz leca: ―Ta ay c'a ma' jel taquin ja stii, a jac jmoc. Oj ni ca yu ja jaa. ");
INSERT INTO tojNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ja ma' huas sc'uanon ja queni ja jastal ni huax yala ja ba slibro ja Diosi, ja ba yaltzili, lajan soc oj bojtuc jun satja, pero ja ja' jahui, oj ni yaa sac'anil tola vida, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jaxa mero sbej ja jas yala ja Jesusi, ja ma' huas sc'uan ja yeni, oj ni aajuc yi ja Espíritu Santoa, jayuj yala jachuc. Ja ora jahui, mi tox jac ja Espíritu Santo yuj ja mi tox iiji q'ue ja Jesús ba oj sc'ul recibir ja yatel jel nihuani. ");
INSERT INTO tojNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ja janec' ay ja cristiano ja tihui, ay ma' huax yala yujile: ―Ja huinic iti, yena ni meran ja aluman‑Dios ja ma' t'ilan ni oj jacuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jaxa tuqui: ―Yena ni ja Cristoa, xchiye. Pero ja tuqui huax yalahue: ―¡Mi ahualhuex ti oj jacuc ba Galilea ja Cristo! ");
INSERT INTO tojNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ja yabal ja Diosi huax yala que ja Cristo, t'ilan oj manxuc ja yintil ja rey Davidi, pero t'ilan ni bi ti oj manxuc ja ba Beleni, como ja' ni ja xchonabil ja rey Davidi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Como tuctuquil xta ja spensarei. ");
INSERT INTO tojNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ay ma' huas sc'ana oj yaahue och preso pero mi ni jas bob sc'uluquea. ");
INSERT INTO tojNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ja policía jumasa ja ma' jecjiye ba oj syame ja Jesusi ti cumxiye ja bay ja fariseo jumasa soc ja sepeil ja pagre jumasa: ―¿Jasyuj mi ahuiajex jan ba? x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ti yala ja policía jumasa: ―Porque mi ni june ma' huax c'umani ja jastal huax c'umani ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ti yala ja fariseo jumasa: ―Iday, ja huenlexi, ¡cho ahuaa bajex lolajel! ");
INSERT INTO tojNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Yuj ama huilahuex ja ma' ay yatel ma ja fariseo jumasa, huan ama sc'uane ja yenle ba? ");
INSERT INTO tojNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ja tantic cristiano jau ja ma' mi ni huas snaahue ja smandar ja Moisesi, ¡ti ni aye ja ba yojol ja scastigo ja Diosi! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tey ja Nicodemo jau ja ma' huaj yulata acual ja Jesusi. Fariseo ja yen chomajquili. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Pero chican ja jas huax yala ja leyi. Mi ni bi sbejuc oj yii castigo jun huinic ta mi huax maclaxi bajtan jasunc'a ja smuli, xchi ja Nicodemo. ");
INSERT INTO tojNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Entonces ti yalahue ja smoj fariseoili: ―¿Yuj ama cho amoj ja huen ja tan galileño jau ba? Q'uelahuil lec ja yabal ja Diosi, ti oja huil que mi ni jun aluman‑Dios ti oj jacuc ja ba Galilea, xchi ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Malan soc ja jahui, ti xa spila sbajea. Ch'ac huajuque ja ba snajei. ");
INSERT INTO tojNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero ja Jesusi ti huaj ja ba huitz Olivos. ");
INSERT INTO tojNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Cuando el ja c'ac'u ja Jesusi ti cho huaj ja ba templo, jaxa cristiano ti ch'ac jacuque nolan sbaj ja yen, jayuj ja Jesusi ti och culana. Ti och see yile ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Huaj to yile, ti jac ja ma' huas sea ja smandar ja Moisesi soc ja fariseo jumasa. Ti macan jan yujile jun ixuc yuj bi staahue soc jun huinic. Ti yaahue ba snalan ja jun montón cristiano jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ti yalahue yab ja Jesusi: ―Maestro, ¿jas la chi? Ja ixuc iti, ti jtaaticon soc jun huinic ba sti bej ");
INSERT INTO tojNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pero ja smandar ja Moisesi, ja jastal ja ixuc iti, sbej ni oj ch'ojxuc tona. Jaxa hueni, ¿jas la chi ba? ");
INSERT INTO tojNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jach sobohue pero quechan ba oj sc'uluque probar ja Jesusi, siquiera tuc ja jas oj yal ja yeni, ti oj stae yi ja smula. Ja Jesusi ti och chubana. Ti och stz'ijba ja luumi soc ja yal sc'abi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero ja fariseo jumasa soc ja ma' huas sea ja smandar ja Moisesi huane xta ni sobjela. Ja Jesusi ti q'ue tec'ana, ti yalaa: ―Chican ja huenlexi, ta ay c'a ma' mey smul ahuujilex, a yaa yi bajtan ja toni, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Cuando ch'ac yal ja jachuqui, ti cho och chubana. Cho och stz'ijba otro vuelta ja ba luumi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pero ja huinique jumasa jahui, cuando yabye ja jas yala ja Jesusi, ti c'otye jacana. Jac sc'ujole que ay smule ja yenle chomajquili. Ti xa ch'ac eluque jujuntica. Ja' to mero bajtan ch'ac eluc ja ma' mas ay xa sc'ujoli. Cuando ch'ac ta eluquei, stuch'il can ja Jesusi soc ja ixuqui, ");
INSERT INTO tojNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ti q'ue tec'an ja Jesusi. Como yila que quechan xta stuch'il ay soc ja ixuqui, ti yalaa: ―Nana, ¿ba ch'ac huajuque ja ma' huan yaljel ja hua mul ba? ¿Mi ni ma june ma' yaa hui ja toni? ");
INSERT INTO tojNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―Miyuc tata. Mi ni ma' yaa quia, xchi ja ixuqui. Ti yala ja Jesusi: ―Jach ni ja queni, mi ni jas oj cala huaba. Quechan cax xa, pero moc xa lee otro vuelta ja hua muli, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ja Jesusi ti cho och see yi otro vuelta ja cristiano: ―Ja queni jac ca ijlabanuc ja sbej ja ma' naca tey ba yoj q'uiq'uinali. Ja ma' huax jac jmoqui ti oj bejyuc ja ba bej jau ja ba jel ja luzi. Mi xa ni nunca oj bejyuc ja ba yoj q'uiq'uinali porque staa ta ja sac'anil ba jel tzamali. ");
INSERT INTO tojNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ti yala ja fariseo jumasa: ―¡Lom altiro huana stoyjel abaj ja hueni! ¡Puro mentira huana! ");
INSERT INTO tojNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","―Ta mentira c'a xa huabyex pero mi mentira huanucon ja queni. Anima quen ta mismo huanon yaljel pero huax naa ba jacyona, huax cho jnaa ba oj huajcona pero ja huenlexi mi jas huaxa naahuex ja iti. ");
INSERT INTO tojNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ja jas huaxa hualahuex jbaji, lom nia. Pero como mi huocoluc huax el ahuujilex. Ja queni, mi ni ma' jas huax cal yaba, ");
INSERT INTO tojNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero ta huan c'ax cala ay smul jun cristiano, yuj ni meran que ay smula. Pero mi tiuc lom huax el ja ba j'olomi. Ja ma' secahuon coni, yena ni huax ya jac jc'ujol jastal ay ja sc'ujol ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ja ba ley jau jel nihuan ahuujilexi huax yala ta ay c'a chab testigo, jun xta c'a mismo ja jas huax yalahuei, sbej ni oj c'uaxuca. ");
INSERT INTO tojNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ja queni, ja jas huax cala huabyexi, jun xta ni mismo soc ja jas huax yala jbaj ja jTat chomajquili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ti yala ja fariseo jumasa: ―¿Bay ja hua tat ba? Ti yala ja Jesusi: ―Ja huenlexi mi xa naahuex jbaj mach ayona, ¡jauc to ma jTat oja naex sbaj! Ja lec huan to xa naahuex jbaj mach ayon ja queni, entonces jach ni ja jTati, oj cho anaex sbaja. ");
INSERT INTO tojNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jach yala jachuc ja Jesusi cuando ti huan seejel ja ba templo. Ti ni ay ja ba cuarto jau ja bay ja copre ja ba huax yaahue can ja slimosnaei. Pero mi ni ma' bob syam ja Jesús ja ora jahui porque mi to yorauc. ");
INSERT INTO tojNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ti cho yala ja Jesusi: ―Oj ni huajcona, jaxa huenlexi ti oja leonex ec'a pero ja ba oj huajcon ja queni, ja huenlexi mi ni oj bob huajanica. Oj chamanic, ti oja huiex och ja hua mulexi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ti yala sbaje yenle ita ja judio jumasa: ―¿Jas bi xchi? ¿Mi oj bob huajtic ja ba oj huajuc ja yeni? ¡Jas sbej ja jach huax yala! ¿Yuj ama oj smil sbaj ba? ");
INSERT INTO tojNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ja Jesusi ti yalaa: ―Ja huenlexi suinquilex ja mundo iti pero ja queni sbajon ni ja satq'uinala. Ja huenlexi tey ja hua najex ja ili, pero ja queni tuc lugar ja bay ja jnaji. ");
INSERT INTO tojNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jayuj huax cala huabyex oj chamanic, ti oja huiex och ja hua mulexi. Y meran nia, mi c'a xa c'uanonex ja queni, que mi cualquieraucon, oj ni acuchex och ja hua mulexa. ");
INSERT INTO tojNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ti yalahuea: ―¿Mach aya huen ba? ―Pero calunej ni ahuabyex desde q'ue jtul ja catel tac. ");
INSERT INTO tojNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ja queni, huan c'ax c'ana, jel ja jas oj bob cala bajexi. Oj ni bob cal spetzanil ja hua mulexi. Pero ja iti, tuc ja jas huanon yaljel ec' ja queni. Ja' huanon yaljel ja jas cab yala ja ma' secahuon coni porque ja yeni, puro smeranil ja jas huax yala, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero ja judio jumasa mi yabye slugaril ta ja' huan staajel ti' ja Dios Tatali ");
INSERT INTO tojNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jayuj ja Jesusi ti cho yal yabyea: ―Oj to anaex machunquilucon ja queni pero masan to huaxa huaahuonex locan ja ba cruzi, ti oj jac ac'ujolex que ti ni coyon jan ja ba satq'uinali. Ja jas huanon yaljel ja huego, ja ora jahui, oj jac ac'ujolex que mi ti huax el ja ba j'olom ja jas huanon yaljeli, que ja jas cala, ja' ni ja jas sea qui ja Dios Tatali. ");
INSERT INTO tojNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ja ma' secahuon coni, ti ni ay jmoc tola vidaa. Ja jTati mi ni nunca huax yaahuon can jtuch'il, jaxa queni quechan huax c'ulan ja jas huas sc'ana ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yuj ja jas ch'ac yal ja Jesusi, jel jitzan ja ma' sc'uanei. ");
INSERT INTO tojNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ja Jesusi ti yal yab ja judio jumasa jau ja ma' ch'ac ta sc'uuquei: ―Ja huenlexi, huan c'a xa c'ulan seguir abajex soc ja jas huax jea, oj ni ochanic mero jnebumanila. ");
INSERT INTO tojNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Oj ni anaex jasunc'a mero smeranila porque ja smeranili, oj ya huajanic libre, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ti yala ja otro jun c'ole judio jumasa: ―Pero ja quenticoni yintiloticon ni ja Abraham tac. Quechan ni altiro Cajualticon ja Dios sac'ani, mi ni ay otro ma' huas sc'ulanoticon mandara. ¿Oj huajanic libre la chi? ¿Jas sbej ja jach huaxa huala? porque libre ni ayticon ja quenticon tac. ");
INSERT INTO tojNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ti yala ja Jesusi: ―Pe mi meranuc ja jahui porque spetzanil ja ma' huas slea smuli, mandar ni ay yuj ja mulali. ¿Mi ma meranuc ba? ");
INSERT INTO tojNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Porque q'uelahuil jun ajualal. Ay yioj jitzan huinic mandar lec ay yuj pero ja huinique jahui, mi ni nunca oj slaj jastal ja yunin ja ajualali como mozo ni aye ja yenlea. ");
INSERT INTO tojNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pero jun c'ac'u ta huan c'ax jac ja yunin ja ajualali, ta huan c'ax yal yab ja smozo jumasa: Libre xa yex, ta xchi c'a, pues libre xa ayex ni merana, como uninal ja ma' yala. ");
INSERT INTO tojNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Meran nia, yintilex ni ja Abrahami ‑ huan nix naaa. Pero ta ja' c'a meran yintilex ja Abrahami mi corajauc oja huabyex ja jas huax cala. Pero ja iti, huanex sleejel modo jastal oj bob amilonex tac. ");
INSERT INTO tojNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ja queni, quechan huax cala ja jas quila ja yora ti to ayon soc ja jTati. Y jachuc ja huenlex chomajquili. Ja jas huaxa c'ulanex, ja' ni ja smandar ja hua tatexi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ja judio jumasa ti yalahuea: ―Pero ja' ni huanticon sc'ulajel ja jas yala can cabticon ja Abrahami, como yintiloticon nia, xchiye. Ti yala ja Jesusi: ―Ja huenlexi, jel nihuan ahuiojex que ja' yintilex ja Abrahami, pero lom nia. Ja lec jauc to ni merani, ja' ni ahuiojex can ja smodo ja yena. ");
INSERT INTO tojNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Porque ja Abrahami, ¿yuj ama xch'aya snaajel ja ma' huan yaljel ja smeranil ja jastal huax alji yab yuj ja mismo Dios ba? Ja Abrahami, mi ni nunca sc'ulan ja jastal huaxa c'ulanex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pero como ja' ni ahuiojex ja smodo ja hua tatexi, xchi ja Jesusi. Ti yala ja yenlei: ―Pero siquiera ja quenticoni mi tulubalucoticon ba bej. Ay jtaticon manxiticon cho jTaticon ni ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","―Ja lec meranuc sbajex ja Diosi, entonces oj ni ayajtayonexa porque ja queni ti coelon jan ja ba stz'eel ja Dios Tatali. Mi quen cala oj jacon ja ili, yuj ni secahuon ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jasyuj mix jac ac'ujolex jas slugaril ja jas huax cala ba? ¡Como jel ni ch'uuy juntiro ja hua c'ujolexi, jayuj! ");
INSERT INTO tojNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ja mero smeranili, ja huenlexi ja' ni atatex ja tan diablo. Como sbajex nia, jayuj chican jas huax yala huabyexi, huan ni xa c'uanexa. Como desde cujlaji ja satq'uinali, mero ni milhuanuma. Mi huas snaa jasunc'a merani. Mi ni nunca huax yala ja smeranili. Huax yala ja ba mi meranuqui, como mero ni mentirosoa. Puro mentira huax yala, como smodo nia, como yena ni mero statalil ja mentira. ");
INSERT INTO tojNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jayuj cuando huax cala huabyex ja smeranili, mi ni modo huaxa c'uanexa. ");
INSERT INTO tojNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ta ay c'a june ja huenlexi, ta huan c'a xa naahuex que huanon sleejel ja jmuli, alahuic ba. Pero ta huanon c'a yaljel ja smeranili, ¿jaxa mi xa c'uanex ba? ");
INSERT INTO tojNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","¿Huaxa naahuex jasyuj mi xa c'ana ja maclayonex? Como mi ni sbajuquex ja Diosa, porque ja ma' tzaubal yuj ja Diosi, huan ni smacla ja yabal ja Diosa. ");
INSERT INTO tojNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ti yala ja judio jumasa: ―Jayuj meran ni lec ja jas huax calaticona. Ja hueni ja' ni mero amoj ja tantic polestero. ¡Lajana soc ja tan diablo! ");
INSERT INTO tojNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ti yala ja Jesusi: ―Ja queni caso jau huax mojan ja diablo. Ja jas huanon sc'ulajeli, ja' ni huanon seejel jastal jel nihuan ja jTati, pero ja huenlexi, jel coraja huaxa huilahuonex. ");
INSERT INTO tojNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mi xa hualahuex ta huanon sleejel ba oj toyjucon. Eso sí, ay ni ma' huas stoyohuona, como huas snaa que toj ja jas huanon sc'ulajeli. ");
INSERT INTO tojNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Huax cala huabyex ja mero smeranili. Ja ma' huas sc'uan ja jas huax cala, mi ni nunca oj chamuc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ti yala ja judio jumasa: ―¡Ata huabilex tac! Ja huego chican lec que ti ni aya soc ja diablo. Ja Abrahami soc spetzanil ja aluman‑Dios jumasa ch'ac ni chamuquea, jaxa huen huana yaljel ja ma' huas sc'uan ja hua huabal ja hueni, mi ni nunca oj chamuc la chi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Yuj ama huaxa huala ta mas nihuan ja huen soc ja Abraham ja ma' ec' pax ta cujtic ba? Ja yeni, cham nia. Jach ni ja aluman‑Dios jumasa, jaxa hueni, ¿mach aya huaxa huala huen ba? ");
INSERT INTO tojNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ja Jesusi ti yalaa: ―Ta quen c'a mismo huax toyo huilex jbaj, entonces lom nia. Pero ja ma' huas stoyohuoni, ja' ni ja jTati, ja' ni ja ma' huaxa hualahuex que ja' ni ja hua Diosex ni. ");
INSERT INTO tojNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero mi ni huaxa naahuex sbaja. Ja queni huan nix naa sbaja, pero ta huan c'ax cala que mix naa sbaj, entonces oj laj ja hua mentirosoilex ja huenlexa. Pero ja mero smeranili, huan nix naa sbaja. Ja' ni huax c'uan ja yabal ja yen tac. ");
INSERT INTO tojNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ja Abraham ja ma' ec' pax ta cujtiqui, jel sgusto oj yil ja tiempo oj jaconi. Snaa lec que oj ni jacona jayuj chaani ec' yuj ja sgusto, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ja judio jumasa ti yalahue yab ja Jesusi: ―Ja hueni, huana yaljel que ahuilunej ja Abrahami. Lom huana c'umal ja hueni. ¡Mi to ni cincuenta jabil ahuioj tac! ");
INSERT INTO tojNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ti yala ja Jesusi: ―Oj cala huabyex ja smeranili. Ja yora mi to nix manxi ja Abrahami, ti ni ayon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jaxa yajni ch'ac yal jastal iti, ti stuluhue ja toni ba oj yaahue yi ja Jesusi pero ja Jesusi snac'a sbaj jaxa mas tzaani ti el ja ba templo. ");
INSERT INTO tojNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ja Jesusi cuando huan eq'uel ja ba jun lugari, ti yila jun huinic tupel ja sati, como jach ni manxia. ");
INSERT INTO tojNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ti sobo ja snebuman jumasa: ―Cajual, ¿jastal lec manxi tupel ja sat ja huinic iti? ¿Yuj ama ja' smul ja snan stati, ma smul yena? ");
INSERT INTO tojNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ti yala ja Jesusi: ―Miyuc. Mi jauc smul ja snan stati soc mi smuluc ja yen. Manxi jachuc ba oj yil ja cristiano jastal ja jel juntiro ja yip ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Y ora xa huego oj c'ultic ja yatel ja ma' secahuon coni. Oj ni jacuc ja c'ac'u mi ni ma' oj bob atjuc. ");
INSERT INTO tojNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pero como ti xa ni ayon ja ba mundo oj ni ca ijlabanuc ja ma' tey ba mundo. ");
INSERT INTO tojNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jach huan yaljel cuando stzujba ja luumi, ti xa slubu ja lococ it sc'ulan soc ja stzujubi, ti ya pac'an ja ba sat ja ma' tupel ja sati. ");
INSERT INTO tojNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ti yalaa: ―Caax. Cax ja ba tanque tey ba Siloé, ti xa sac'a lec ja hua sati. (Ja sbiil ja tanque jahui, Jecubal huax el ja ba sc'umal ja judio jumasa.) Ti huaj ja huiniqui. Huaj sac' ja sati, jaxa cuando cumxi, huan xax yila q'uinal. ");
INSERT INTO tojNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Cham yabye juntiro ja svecino jumasa soc ja ma' huan ni snaa sbaj que tupel ja sat ajyi. Ti yalahuea: ―¿Mi ma yenuc ja huinic it huax och culan tola vida huas sc'ana limosna ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jaxa tuqui: ―Yena nia. Jaxa tuqui: ―Lajan soc pe seguro mi yenuc. Jaxa huiniqui, yen mismo yala: ―¡Pero quena ni taca! ");
INSERT INTO tojNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ti sobohuea: ―¿Jastal lec huan xax bob ahuil q'uinal ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ti yala ja yeni: ―Ja huinic ja ma' Jesús sbiili, quechan stzujba ba luumi ti slubua, ti saxa qui ja ba jsati. Ti yala cab que oj huaj sac' ja jsat ja ba tanque ba Siloé. Ti huajyona, jaxa yajni ch'ac jsac' ja jsati, ti jamxi ja jsata. ");
INSERT INTO tojNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―¿Bay ja huinic jau ba? xchiye. ―Mi naben, xchi ja ma' tupel ja sat ajyi. ");
INSERT INTO tojNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ja cristiano ti yiaje och ja ba sti sat ja fariseo jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ja huiniqui ti ch'ac xchol ja jas c'ulaji yi. Pero ja yora tojbi ja sati, ja' ni ja sc'ac'uil ja jijleli. ");
INSERT INTO tojNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pero yuj ja sc'ulan ja lococ ja c'ac'u jau ja Jesusi, jayuj ja fariseo jumasa ti cho sobohue otro vuelta jastal bob yil q'uinal. Ti yala ja huiniqui: ―Saxa qui t'un lococ ja ba jsati, ti huaj jsac'a, jayuj huan xax quila q'uinal ja huego. ");
INSERT INTO tojNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ti yala chaboxe ja fariseo jumasa: ―Pero ja huinic ja ma' sc'ulan ja iti, mi ni modo oja hual que sbajuc ja Diosa porque mi huas stalna ja sc'ac'uil ja jijleltic tac, xchiye. Pero jaxa tuqui ti yalahuea: ―Ta meran c'a ay ja smuli, ¡ba oj bob sc'ul milagro ja jastal iti! Jayuj mi ni modo huax lajxi yujilea. ");
INSERT INTO tojNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ti cho huaj sobe yi otro vuelta ja ma' tupel ajyi ja sati: ―Jaxa hueni, ¿jas la chi soc ja huinic it ma' ya tojbuc ja hua sati? ―Ja queni huax cala que jun aluman‑Dios, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ja judio jumasa mi ni modo huas sc'ana oj sc'uuque ta meran ja tupel ja sat ajyi, jaxa huego huax bob yil q'uinal, jayuj ti secahue spayjel ja snan stat ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ti sobohue yi ja stati: ―¿Ja' ma ja hua huunin ja iti? ¿Meran ama tupel ni ja sat manxi? ¿Jastal lec huax bob yil q'uinal ja huego ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ti yala ja stati: ―Meran nia. Ja cunin iti tupel ni ja sat manxia. Jaxa snani ti yalaa: ―Meran nia tata, tupel ni ja sat manxi ja cala ala. ");
INSERT INTO tojNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ti cho yala ja stati: ―Pero mix naaticon jastal huan xax bob yil q'uinal ja huego. Mi huax cho jnaaticon sbaj machunc'a ya tojbuc ja sati. Jobohuic yi ja yeni ‑ ay xa ni sc'ujol ja cunin tac. Yen mismo oj bob yala huabyex, xchi ja tatali. ");
INSERT INTO tojNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ja nanal tatali jach yalahue jachuc porque huane xihuel. Ja judio jumasa lajti abal xa ay yujile lec, ta ay c'a ma' huax yala que Cristo ni ja Jesusa, ja' ni ja ma' oj jecjuc con yuj ja Diosi, oj bi snutze el ja ba yiglesiaei. ");
INSERT INTO tojNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jayuj ja nanal tatali ti yalahue que oj bi sobe yen mismo ja huiniqui, como ay xa ni bi sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ja judio jumasa ti cho spaya jan ja ma' tupel ajyi ja sati, ti yalahuea: ―Ala cabticon ja mero smeranili. Ta mi c'a, huax yilahua ja Dios que huana ni mentiraa porque ja quenticoni huan nix naaticon que ja tan huinic jahui, mulanum nia. ");
INSERT INTO tojNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ti yala ja huinique: ―Ja queni, mix naa ta mulanum ma miyuc pero huax naa que tupel ja jsat ajyi, pero ja huego, huan xax quila q'uinal. ");
INSERT INTO tojNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ti yala ja fariseo jumasa: ―Pero ¿jasunc'a sc'ulan yi ja hua sat ja bob ya huil q'uinal ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ti yala ja yeni: ―Pe cala ta huabyex jas sc'ulan qui pero como mi huaxa c'uanex, ¿jas sbej otro vuelta oj cala huabyexi? ¿Yuj ama huax cho c'ana ochanic snebumanil ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Cuando yabye ch'ac yal ja jastal iti, snicjel ita ch'ac huajuque, ti yalahuea: ―Ja hueni, nocho ta huaxa c'ana ja tan huinic jahui, pero ja quenticoni, ti ni oj ajyucoticon ja ba sparte ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ja quenticoni huax naaticon que c'umaji yuj ja Dios ja Moisesi pero ja tan huinic jahui, mi ni t'usan huax naaticon ba jaquela. ");
INSERT INTO tojNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ti yala ja huiniqui: ―¡Jel tuc juntiro! ¡Jastal modo mi oja naex ba jaquela! Ja queni ya quil q'uinal. ¡Malan soca! ");
INSERT INTO tojNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Como huan nix naatic, ja Diosi mi huas smacla ja mulanum jumasa. Quechan huas smacla ja ma' huax xiu yujil soc ja ma' huas sc'uan ja yabali. ");
INSERT INTO tojNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Masan cujlaji ja satq'uinali mi ni nunca huax abxi ta ay ma' oj bob ya yil q'uinal ja ma' huax manxi tupel ja sati. ");
INSERT INTO tojNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ja huinic iti, ta mi c'a sbajuc Dios, mi ni oj bob sc'uluc ja jastal ita, xchi ja ma' tupel ja sat ajyi. ");
INSERT INTO tojNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ti yala ja fariseo jumasa: ―¡Ja hueni, mi ni tojuc manxelucaa, iday, jaxa huego, huan xa xa c'ana oj ochan jmaestroilticon! ¡Elan ja huen ja ili! xchiye xta, pero ahuanel. ");
INSERT INTO tojNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ja Jesusi yajni yab que nutzji ja ma' tupel ja sati, cuando staa, ti yal yaba: ―¿Huan ma xa c'uan que ay ma' coel jan ja ba satq'uinal ba? ");
INSERT INTO tojNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","―Cajual, ala cab machunc'a ba, ti oj c'uuca, xchi ja huiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ti yala ja Jesusi: ―Pero ahuila ta ni taca. Quena nia. ¡Huana ni loil soc ja yen ja ma' jecubal ni con yuj ja Diosi! ");
INSERT INTO tojNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ja huiniqui ti co mec'an ja ba sti sat ja Jesusi, ti yalaa: ―Cajual, huan xa nix c'uanaa. ");
INSERT INTO tojNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ti yala ja Jesusi: ―Jayuj jacyon ja ba mundo tac, ba oj ch'ac quii cuenta ja ma' jel huas stoyo sbaj que jel jaman ja sati. Pero oj ni ch'ac tupuc ja sate ja yenlei. Jaxa ma' mutz'an juntiro ja satei, oj ca jamxuc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tey chaboxe fariseo mojan ja tihui. Yajni yabye ja jas yala ja Jesusi, ti yalahuea: ―¡Entonces quenticon ja lajan soc mutz'an ja jsaticon ta jachuqui! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","―Mas to lec ja lec tupeluc juntiro ja hua satexi, ay modo mi oja taa ja hua mulexi. Pero ja iti, quechan huaxa toyo bajex que jel huaxa naahuex, ti huaxa taa juntiro ja hua mulexi, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ti cho yala ja Jesusi: ―Meran huax cala huabyex, ja ma' mix och ja ba spuertail ja snajtzil ja cheji, yuj ni lagrona. Ja lagroni, tuc lado ni huas sotoa, porque elc'anel ni huana. ");
INSERT INTO tojNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero ja ma' huax och ja ba puerta, yuj ni ja' talnacheja. ");
INSERT INTO tojNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Cuando ti xa jacum jan ja ma' huas stalna ja cheji, ti huax el jan ja ma' huas sama ja puerta ba oj bob ochuc ja talnacheji. Ja talnacheji, como naca ay sbiil yuj ja xchej jumasa, ti xa huas spaytalaan cada jujune. Jach huas sc'ulan cuando huax el ja ba snaji. ");
INSERT INTO tojNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuando huax ch'ac el spetzanil ja xcheji, jaxa talnanumi, bajtan huax eq'ui, ti huax huaj tzalan ja chej jumasa como naubal lec yujil ja sc'umali. ");
INSERT INTO tojNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Mi ni huas snochohue jun cualquiera cristianoa. Ta mi c'a jauc ja ma' tola vida huas stalna, entonces ja cheji, oj ch'ac eluque ajnel. Como mi ni c'ajyeluc soc ja sc'umal ja otro cristiano, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ja loil iti yala ja Jesusi porque huas sc'ana ay jas oj ya sneb ja cristiano pero mi ni t'un yabye slugarila. ");
INSERT INTO tojNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jayuj ja Jesusi ti cho yala otro loila: ―Ja huego ay jas oj cala huabyexi pero ja' ni mero smeranili. Ta mi c'a quenuc, ¿jastal oj bob ochuc ja ba snaj ja cheji? Ja queni, lajan soc quena ni ja puertaon ja ba huax och ja cheji. ");
INSERT INTO tojNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jaxa spetzanil ja ma' ti ni ay ja il ja yora mi to la jacyon ja queni, puro ni lagron ayea. Toj elc'anel ja sgustoei, jayuj mi c'ulajiye caso yuj ja jchej jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja queni, lajan soc quena ni ja puertaon ja ba huax och ja cheji. Ja ma' huax och ja ba puerta jahui, oj ni staa ja scoltajela. Como jastal ja yal cheji huax och ja ba snaji, ti huax huaj slee ja suaeli, jach oj ajyuc ja ma' huax och ja ba puerta jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jayuj jacyon ja queni ba oj staa ja svida ja cristiano pero ja vida jahui, jel tzamal juntiro. Tuc juntiro ja spensar ja lagroni. Quechan huax jac ch'ac yii ja ba mi sbajuqui. Huax jac som spetzanil. Huax jac milhuanuque. ");
INSERT INTO tojNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Pero q'uelahuile. Jun lequil talnachej, hasta que oj yaa ja svida yuj ja xcheji. ¡Pero quena ni ja talnachej jau taqui! ");
INSERT INTO tojNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero ta jun talnachej quechan huan pensar soc ja stz'acoli, entonces huan c'ax jac jun oq'uil, oj yaa can endregal ja xcheji, jaxa yeni oj spac ajnel. ¡Ba miyuca, como mi ni sbajuc ja cheja! Quechan huan ganar. Ta jach c'a, ¡jel ajul ja sbaj ja cheji! Oj ni yamjuc yuj ja oq'uili, jaxa tuqui, sactantan oj ch'ac huajuque. ");
INSERT INTO tojNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jach ni oj huajuca porque ja tan huinic jahui, quechan ni huan smajlajel ja stz'acoli. Ja cheji, tix yila sbaj ja ora jahui, como mi ni sbajuca. ");
INSERT INTO tojNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mi ni nunca oj slaj ja ma' mero sbaj ja cheji. Huas snaatalaan sbaj ja xcheji, jaxa cheji huas snaa sbaj ja yajuali. ¡Pero quena ni suinquilon ja chej jumasa tac! ");
INSERT INTO tojNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Puesto ni ayona oj caa ja jvida yuj ja jchej jumasa. Q'uelahuile ja jTati. Huan ni snaa jbaj. Jach ni ja queni, huan nix cho jnaa sbaja. Jayuj jachuc ja jchej chomajquili, huan nix cho snaa jbaja. ");
INSERT INTO tojNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pero ay to jitzan jchej najat to aye. Mi tox och ja ba snaj ja ba quioj ja tuc jumasa ja iti. Y t'ilan ni oj ch'ac huaj quii jana. Oj ni snae ja jc'umal cuando huax payahue jani. Entonces jun ita ni nole oj ajyuque spetzanile. Quechan june ja talnumani, pero quena nia. ");
INSERT INTO tojNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ja jTati, jel ni huas sc'anahuona porque oj ni caa ja jvida, pero ja mas tzaani oj ni cho sac‑huucona. ");
INSERT INTO tojNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mi ni ma' oj ya el qui ja jvida porque jach ni huax c'ana oj caa jbaja. Como jach ni alubal cab que oj ni bi caa jbaja pero oj ni bi cho sac‑huucona. Jach ni yala cab ja jTati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yajni yabye ja jas yala ja Jesusi, ti q'ue juntiro ja c'umali pero mi ni modo huax lajxi yujile ja judio jumasa: ");
INSERT INTO tojNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","―¡Loco ja tan huinic iti! ¡Ja' ni mero smoj ja diablo! ¡Jas sbej ja oj c'ultic caso ja jas huax yala! xchi ja jun c'olei. ");
INSERT INTO tojNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jaxa otro c'olei: ―Pero ta ja' c'a smoj ja diablo, ¿jastal oj bob c'umanuc tzamal ja jastal huan c'umal ba? Porque ja diablo mi ni oj bob ya yil q'uinal ja ma' tupel ja sati, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ja ora jahui, ja' ni mero stiempo chee ja ba Jerusaleni, jaxa cristiano, ja' ni mero tiempo huas sc'ulan ja sq'uinil ja stemploei, como jach ni culan yujilea. ");
INSERT INTO tojNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ja Jesusi ti huan bejyel ja ba yoj sten ja Salomoni, ");
INSERT INTO tojNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jaxa judio jumasa ti huajye nolan sbaja. Ti yalahuea: ―Ja quenticoni jel ja jpensarticoni. Tola vida t'aban xta jc'ujolticon jas ora oja hual cabticon que ta huena c'a ja Cristo ja ma' secunej ni con ja Diosi. Huax c'ana ja quenticon oja hual cabticon juntiro. ");
INSERT INTO tojNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ti yala ja Jesusi: ―Ja huenlexi, pe mi na' jaye vuelta cala ta huabyex tac, y mi xa c'uanonex. Malan soc ja jas huanon sc'ulajeli, huax ilxi que ja' ni quip yaunej qui ja jTati ");
INSERT INTO tojNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ja huenlexi, mi ni modo huaxa c'uanex. Yuj ni mi jchejuquex ja huenlexa ");
INSERT INTO tojNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Porque ja jchej ja queni, huan ni snaahue lec sbaj ja jc'umali. Huas stzajlayone, jaxa queni huan nix naahue sbaja. ");
INSERT INTO tojNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jayuj huax caa yile ja sac'anil jau mi ni nunca huax ch'aqui, mi ni oj chamuquea. Ja mero jcheji, mi ni ma' oj bob ya el qui ja ba jc'aba. ");
INSERT INTO tojNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yena ni ja jTat ja ma' yaa quii, jaxa jTati, quechan yen mas nihuan que spetzanil. Mi ni jun ma' oj ya el yi ja ba sc'ab ja cala cheji. ");
INSERT INTO tojNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Porque ja queni soc ja jTati, jun ita ni ayticona, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jaxa judio jumasa ti cho stuluhue otro vuelta ja ton ba oj yaahue yi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ti yala ja Jesusi: ―Jitzan lec ja jas ahuilunejex jc'ulunej ja ba jel tzamali pero puro yatel ja jTati. ¿Yuj ama ay jas jc'ulan ja ba mi lecuc ba, jayuj oja ch'ojonex ton ja huego? ");
INSERT INTO tojNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","―Mi jauc yuj oj ch'ojaticon ton yuj ja jas ac'ulunej ja ba lequi. Oj caaticon ahui yuj ja jastal huaxa taa ti' ja Diosi. ¡Cristianoa nia, iday, huaxa toyo baj que Diosa! xchi ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Ti yala ja Jesusi: ―Pero q'uelahuilex. Ja najatei ja ma' sc'uan ja yabal ja Diosi, ti alji yabye yuj ja Diosi que lajane bi soc jastal ja Diosi. ¿Mi ma jach ni tz'ijbanubal ja ba yabal ja Dios ba? Huax naatic que ja jas tz'ijbanubal ja ba yabal ja Diosi, mi loiltajneluc, ");
INSERT INTO tojNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¡Jauc to ma queni! Tzaubalon yuj ja Diosi. Secahuon ja ba mundo iti. ¿Jastal modo coraja oj yilon ja Diosi yuj ja huax cala que yuninon ja yeni? ");
INSERT INTO tojNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ta mi c'a huanucon sc'ulajel ja yatel ja jTati, mi ni sbejuc oja c'uuconexa. ");
INSERT INTO tojNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero ja iti, ja' ni huanon sc'ulajela. Ta mi xa c'ana oja c'uuconex ja queni, siquiera oj jac t'un ac'ujolex ja atel huanon sc'ulajeli, mi cualquierauc. Jayuj naahuic ja jTati ti ni ay jmoca, jachuc ja queni, ti ni ayon soca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jayuj ti xa huas sc'ana oj syamea pero mi ni bob yujilea. Yoj sc'abe xa ni ela. ");
INSERT INTO tojNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ti huaj ja ba mojan ja nihuanja Jordani, ja ba lado ja ba huax el q'uen ja c'ac'u, ja' ni ja mismo lugar ja ba huax ya yii ja' ja cristiano ajyi ja Juani. Ti tejc'aji ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ti huaj iljuc yuj jitzan ja cristiano. Ti yalahuea: ―Eso sí, ja Juani mi ni jun milagro quilatic sc'ulana, pero spetzanil ja jas yala sbaj ja huinic iti, meran nia. ");
INSERT INTO tojNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jayuj jel c'uaji ja Jesús ja ba lugar jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ay jun huinic ti culan ba Betania, Lázaro sbiil, pero maloaxi ja yeni. Ti cho culan soc ja Marta ja suatzi soc ja yijtz'in María. Naca smoj'alijel ni sbaje soc ja Lázaro. ");
INSERT INTO tojNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jaxa María ja yijtz'in ja Lázaro, yena ni ja María jau ja spec'a yi perpume ja yoc ja Cajualtiqui, ti cho scusu soc ja s'olomi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jayuj ja Marta soc ja María ti secahue jun jecabanum ja bay ja Jesusi. Ti yalahue yaba: ―Alahuic yabi: Cajual, ja hua huamigo ja ma' jel yaj xa huabi, jel xa yioj, utajic. ");
INSERT INTO tojNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yajni yab ja Jesús ja jastal jahui, ti yalaa: ―Pero mi oj chamuc soc ja chamel jahui. Eso sí, malo ay, pero majlayic. Oj iljuc ja yip ja Dios yuj ja chamel iti. Jachuc, oj iljuc jastal jel tzatzon ja queni, como yuninon ni ja Diosa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ja Jesusi, eso sí, jel yaj huax yab ja Marta soc ja yijtz'ini soc ja Lázaro, ");
INSERT INTO tojNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero iday, cuando alji yab que jel xa yioj ja Lázaro, jaxa yeni can to mas chab c'ac'u ja ba lugar jau ba huan ateli. ");
INSERT INTO tojNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Cuando ec' ja chab c'ac'u jahui, ti yal yab ja snebuman jumasa: ―Huajtic otro vuelta ja ba Judea, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ti yala ja snebuman jumasa: ―Pero Cajual, mi to aayuc c'ac'u eq'uel, ja judio jumasa huane xchapjel ja huabalil que oj xch'oja ton, iday, ¡huan xax cho c'ana huajan otro vuelta ja tihui! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Ti yala ja Jesusi: ―Pero ¿mi ma xa naahuex que ora xa oj bejyucotic? Sat c'ac'u xa tac. Mi ni jas oj c'ultica. Ja ba mundo iti, mi c'a la bejyi sat c'ac'u, ti oj pumuljanan ec'a porque jel ni piero bejyel ja ba q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ja mas tzaani ti yalaa: ―Ja camigotic Lázaro huan xa huayel, pero oj huaj yujques cani. ");
INSERT INTO tojNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","―Pero Cajual, ta huan xa c'a huayel, yuj ni mas lec xa ay t'usana, xchiye ja snebumani. ");
INSERT INTO tojNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero ja Jesusi, ja mero sbej ja jas yala, ja Lázaro cham ta nia, xchi, pero ja snebuman jumasa huax yalahue que huan ni huayel merana. ");
INSERT INTO tojNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jayuj ja Jesusi ti yala claroa: ―Ja Lázaro, cham ta nia. ");
INSERT INTO tojNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Pero jel lec huax cabi yuj ja mi ni ti ayucon ja tihui. Ja jastal iti, ja' ni ja ba hua lequil ja huenlexi ba oja c'uuquex meran. Pero la xa huaj quiltic, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Entonces ja Tomás it huax aaji sbiiluc gemeloili, ti yal cabticona, como jmoj ni jabajticon nebumanila: ―¡Huajtic ja quentic chomajquili, ti la chamtic soc lajana! ");
INSERT INTO tojNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cuando c'otye ja tiu ja Jesusi, chane xa bi c'ac'u mucan ja Lázaro. ");
INSERT INTO tojNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Como jel mojan yioj sbaj ja Betania soc ja Jerusaleni ‑ bob ta mi ni jun lehue yioj ‑ ");
INSERT INTO tojNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jayuj jitzan ja judio jumasa huaj yulataye ja Marta soc ja María ba oj ya cujlajuc t'usan ja sc'ujolei, como cham ta ni ja yermanoea. ");
INSERT INTO tojNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Pero ja Marta, cuando yab yabalil que oj xa c'otuc ja Jesusi, jayuj ti huaj staa. Jaxa María ti can ja ba yoj snajei. ");
INSERT INTO tojNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ja Marta ti yal yab ja Jesusa: ―Cajual, ja lec jacan to, seguro mi ni cham ja quijtz'ina, ");
INSERT INTO tojNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero huan nix naa que oj ni yaa hui ja Dios ja jas huaxa c'ana yii. ");
INSERT INTO tojNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ti yala ja Jesusi: ―Ja hua huijtz'ini oj ni sac‑huuca. ");
INSERT INTO tojNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","―Meran nia. Huan nix naa que oj ni sac‑huuc ja último c'ac'u jau cuando huax ch'ac sac‑huuc spetzanil ja chamhuinic jumasa, xchi ja Marta. ");
INSERT INTO tojNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ti yala ja Jesusi: ―Pero quena ni oj ca sac‑huuc ja cristiano jumasa. Quena ni oj cho caa yi ja sac'anilei. Ja ma' huas sc'uanon ja queni, anima huax chami, pero oj ni cho sac‑huuca, ");
INSERT INTO tojNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Jaxa ma sac'an to ja ora jahui, ta huan c'a sc'uanoni, mi ni nunca oj chamuc ja yenlei. ¿Huan ma xa c'uan ja iti? ");
INSERT INTO tojNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Huan, Cajual. Huax naa que huena ni ja Cristoa, yunin ja Diosai. Ja huena ni ja ma' huax majlaticon ajyi oj jacuc ja ba mundo, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cuando ch'ac yal ja jastal jau ja Marta, ti huaj spay jan ja yijtz'in María. Ti yal yab tacal ja yijtz'ini: ―Ja Cajualtiqui, ti xa ay ja ili. Huas spayahua, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Quechan ch'ac yab ja María ja iti, ti q'ue tec'ana. Ti huaj yila ");
INSERT INTO tojNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pero ja Jesusi mi tox och ja ba yoj hacienda. Ti to ni ay ja ba staa ja Marta. ");
INSERT INTO tojNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jaxa judio jumasa ja ma' jac ya culan sc'ujolei, cuando yilahue xachachi xta q'ue tec'an ja María, ti huajye nochana. Huax yalahue ta ti huajum oq'uel ja ba sq'uejnal ja snui. ");
INSERT INTO tojNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ja María cuando c'ot ja bay ja Jesusi, ti co mec'an ja ba sti sati, ti yalaa: ―Cajual, ja lec tiuc to ayuca ili, seguro mi cham ja jnua. ");
INSERT INTO tojNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Huan oq'uel ja María cho huane oq'uel ja judio jumasa ja ma' jac soc lajan ja María. Yajni yila ja Jesusi, ti syatz'a sbaj ja yaltzil ja yeni. Lajan soc oj cho oc'uc. ");
INSERT INTO tojNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ti yalaa: ―¿Ba amucuhuex ba? ―Huaj quiltic ahuil baya Cajual, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ja Jesusi ti bojti yoq'uela. ");
INSERT INTO tojNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ti yala ja judio jumasa: ―Q'uelahuile, ¡jel yaj xyab juntiro! ");
INSERT INTO tojNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero ay chaboxe ja ma' yala: ―Pero q'uelahuilex. Ja yeni ya yil q'uinal ja ma' tupel ja sat ajyi, iday, ja Lázaro, mi ni jas sc'ulan yia. ¿Mi ma sbejuc ni mi oj ya cham ajyi ba? ");
INSERT INTO tojNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ja Lázaro ti mucji ba jun q'ueen ba jun huitz, jaxa ba sti ja sq'uejnali ti smacahue soc jun nihuan tona. Pero ja Jesusi yaau juntiro ja sc'ujoli. Ti huaj ja ba stz'eel ja q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ti yalaa: ―A eluquex ja toni. Ti yala ja Marta ja suatz ja chamhuiniqui: ―Pero Cajual, seguro ay xa yiq'uil porque ay xa chane c'ac'u mucan. ");
INSERT INTO tojNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ti yala ja Jesusi: ―¿Mi ma cala huabi ta huaxa c'uani, oj ni ahuil ja yip ja Diosa? ");
INSERT INTO tojNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jayuj ti yaahue eluc ja toni. Ja Jesusi ti sq'uela q'ue ja ba satq'uinali, ti yalaa: ―Tatey, tz'acatal porque huaxa macla ja jas huax calai. ");
INSERT INTO tojNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Huan nix naa que tola vida huaxa maclayon pero huax cala huabi, ja' ni ba slequil ja cristiano jumasa iti ba oj sc'uuque que huena ni ajeconejona. ");
INSERT INTO tojNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ti c'umani tzatz leca: ―Lázaro, ¡elan xa jan ja tihui! ");
INSERT INTO tojNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jaxa Lázaro ja ma' chamel xa ni ajyi, ti el jana. Pero yuch'ubal ni lec ja yoc sc'aba soc jun c'uutz, jaxa sati, macan soc jun mojchilal. Ti yala ja Jesusi: ―Tucuhuic. A huajuc libre, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yuj ja iti, sc'uane jitzan ja judio jumasa ja ma' ti aye soc ja María porque yilahue ja jas sc'ulan ja Jesús ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ay chaboxe ja yenlei ti huaj yale yab ja fariseo jumasa. Ch'ac xchole spetzanil ja jas yilahue sc'ulan ja Jesusi, ");
INSERT INTO tojNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jayuj ja fariseo jumasa soc ja sepeil ja pagre jumasa ti stzomo sbajea. Yaahue junta. Ti yalahuea: ―¿Jasunc'a lec oj c'ultic ba? Ja tan huinic jahui huan sc'ulajel ec' jitzan milagro. ");
INSERT INTO tojNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ta huax caatic can jachuc, spetzanil ja cristiano oj c'uajuc ja yeni. Huan tox huaj naa jbajtic, ti xa ay jul ja tantic ma' ay yatel ja ba Roma. Oj jac seme el ja jtemplotiqui, jaxa jlugartiqui, oj ni ch'ay snaajela, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero june ja yenlei, ja' ni ja mero sepeil ja pagre jumasa ja jabil jahui, Caifás sbiil, ti yalaa: ―Ja huenlexi mi ni t'un huaxa naahuexa. ");
INSERT INTO tojNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pero mas ni lec ja ba jlequil ja quentiqui ta huan c'ax cham quechan jun huinic que no que soc oj ch'ay jnaajeltic jpetzaniltic ja janec' suinquilotic ja jlugartiqui, xchi ja Caifasi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero ja jas ch'ac el sti ja Caifás jahui, mi s'olomuc yena. Iiji majan ja sti yuj ja Diosi como ja jabil jahui, yena ni mero sepeil ja pagre jumasa. Ja sbej ja jas yalai, ja' ni huan yaljel que ja Jesusi oj ni yaa ja svida yuj ja judio jumasa ");
INSERT INTO tojNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero mi quechanuc ja yenlei. Spetzanil ja cristiano ja ma' oj to bob och yuntiquilil ja Diosi, anima najticuc lec yioj sbaje, pero mero ni yermano oj yil sbajea. ");
INSERT INTO tojNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jayuj ja c'ac'u jahui spetzanil ja judio ja matic ay yateli ti och xchape yabalil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jayuj ja Jesusi mi xa ni huax bejyi satalajel abala ja ba yojol ja smoj judioili. Ti el ja ba Judea. Ti huaj ja ba jun lugar ba mojan stz'eel jun ch'ayan lugar, Efraín sbiil ja lugar jahui. Ti tejc'ajiticon ja tihui soc jpetzanilticon ja janec' ja snebumanoticoni. ");
INSERT INTO tojNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jel xa mojan ay ja syalq'uinal ja judio jumasa, jaxa ba cada yal hacienda, jel jitzan ja cristiano ti huax huajye ja ba Jerusaleni. Huajye cuando ay to sc'ana chaboxe c'ac'u ja q'uini ba oj sc'uluque jastal ja scostumbre siquiera ba chapan oj ajyuquea ti oj bob ochuque ja ba sq'uinei. ");
INSERT INTO tojNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jaxa cristiano jahui huane sleejel ec' ja Jesusi. Cuando ch'ac staa sbaje ja ba templo, ti yalahuea: ―¿Jas la chiyex? ¿Oj ma jac yil ja q'uini, ma miyuc? ");
INSERT INTO tojNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Porque ja fariseo jumasa soc ja sepeil ja pagre jumasa yauneje orden, chican ma' huas snaa bay ja Jesusi, a aljuc yabye ba oj bob syame. Oj bi yaahue ochuc preso. ");
INSERT INTO tojNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ay to sc'ana huaque c'ac'u ja syaljq'uinalticon ja janec' judiooticoni, jaxa Jesusi ti huaj ja ba Betania. Ja tihui ti ni culan ja Lázaro it ja ma' cham ta ajyi, ja' ni ja ma' ya sac‑huuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ja Lázaro soc ja yermana jumasa sc'ulane jun nihuan huaelal yuj ja ti ni ay ja Jesusi. Ja Marta, yen ya ec' ja huaelali, jaxa Lázaro, ja' ni smoj huael ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jaxa María ti yiaj jan jun litro perpume c'ulubal soc jun nichim nardo. Jel aay ja stz'acol ja perpume jahui. Ti huaj spec' ja ba yoc ja Jesusi, ti scusu soc ja s'oloma. Jaxa yoj naitzi, ch'ac spuc sbaj ja yiq'uil ja perpume jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ti yala ja Judas Iscariote, ja' it ma' Simón ja stati. Ja Judas jahui ja' ni june ja janec' snebumanoticon ja Jesusi, pero yena ni ja ma' yiaj ni spatic ja mas tzaani. Ti yala jachuca: ");
INSERT INTO tojNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Mas lec xchonuc to ja perpume iti. Oj ni xchon mojan milquiniento peso, jaxa taq'uin jahui, oj bob coltaxuc ja pobre jumasa, xchi ja Judasi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero ja Judasi, eso sí, yala jachuqui, pero mi jauc ba huas stalna syaujulal ja pobre. Como yen huas snolo ja sbolsail ja jtaq'uinticoni. Tola vida huan nix yelc'an can t'usan ja taq'uin jahua, como toj elc'anel ni huajel sc'ujola. ");
INSERT INTO tojNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ti yala ja Jesusi: ―¡Acta can ja hueni! Ja perpume caneli tix maconi cuando huala mucjiyoni. ");
INSERT INTO tojNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ja pobre jumasa, tola vida ti ni oj ajyuquea, chican jas ora huaxa c'ana coltayexi, pero ja queni, quechan xta t'usan tiempo ti ayon amoquex ja ili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jayuj ja judio jumasa, yajni yabye yabalil que ti xa ay ba Betania ja Jesusi, ti huaj yilea. Pero mi quechanuc huajye ba oj yile ja Jesusi. Yabye yabalil jastal cham ta ajyi ja Lázaro, pero ja Jesusi cho ya sac‑huuc, jayuj ti huaj yile ja Lázaro chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaxa sepeil ja pagre jumasa ti sc'uman sbaje leca. Huas sc'ana oj cho smile ja Lázaro ");
INSERT INTO tojNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porque smul bi yena, jayujil jel jitzan ja smoj judioili ja' xa huajel sc'ujole oj sc'uuque ja Jesusi, jaxa yenlei, mi xa ni huax c'uaji yile ja jas huax yalahuei. ");
INSERT INTO tojNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jaxa otro c'ac'u jel jitzan ja cristiano huajye ja ba Jerusalén ba oj yile ja q'uin jau ja sbaj syalq'uinali. Huan ni snaahue que oj xa c'otuc ja Jesusi ");
INSERT INTO tojNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jayuj ti huaj sc'utze ja spoohuil ja xaani. Ti huaj stae jana. Ti och ahuanuquea: ―¡Stz'acatal lec ja Diosi! ¡Jel lec huax yila ja yen ja ma' jac yuj ja sbiil ja Cajualtiqui! ¡Lec xta yuj ja rey ba Israeli! xchiye xta, pero ahuanel huane. ");
INSERT INTO tojNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ja Jesusi ti staa bej jun yal burro, ti q'uea. Como jach ni tz'ijbanubal can ja najate ja ba yabal ja Diosi: ");
INSERT INTO tojNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ja huenlex ja janec' ti ayex ja ba Sioni, q'uelahuilex. ¡Ti huax jac cajan jun yal burro ja hua reyexi! xchi ni ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ja mero ora it jach huanei, jaxa quenticon ja janec' snebumanoticoni, mi ni jac jc'ujolticon jas sbej ja jach huane yaljel ja cristianoa, pero yajni cumxi ja ba satq'uinal ja Jesusi ba oj sc'ul recibir ja yateli, ti to jac jc'ujolticon spetzanil ja jastal huax taaji ti' ja ba yabal ja Diosi. Meran nia, ja jastal ni tz'ijbanubali, jach ni c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jaxa cristiano ja matic smoj ja Jesús ja yora sc'uman ja chamhuinic Lázaro ja ba yoj sq'uejnali, y yaa ni sac‑huuca, ja' ni huane yaljel ja jas yilahuei. ");
INSERT INTO tojNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jayuj jel ja ma' ti huaj stae ja Jesusi, como yabye yabalil ja milagro jel nihuan sc'uluneji. ");
INSERT INTO tojNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ti yalahue ja fariseo jumasa: ―¡Oja huilex, mi jas oj bob jc'ultic ja quentiqui! Spetzanil ja cristiano ti xa huajum soc ja yen tac. ");
INSERT INTO tojNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ja ba q'uin jahui, ja cristiano jumasa huax huaj sc'umuque ja Dios ja ba templo. Ti ni cho och jun nole cristiano ja ma' sc'umale griego. ");
INSERT INTO tojNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ja cristiano jumasa jahui ti huaj c'umajuc ja Felipe ja jmojticon nebumanil it ja ma' jaquel ba Betsaida sbaj Galilea. Ti yalahuea: ―Tata, huax c'anaticon ta ay c'a modo, oj bob quilticon ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jayuj ja Felipe ti huaj yal yab ja Andresi, jaxa xchahuanile, ti huaj yale yab ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ti yala ja Jesusi: ―Mi oj bob cuj porque jel xa mojan ja ora oj huaj c'ul recibir ja catel it jel nihuani. Ja ba coyon jani ti oj cho huajcon otro vuelta. ");
INSERT INTO tojNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","25","Pero huax cala huabyex ja smeranili. Ja ma' quechan yen huas syajta sbaj yen mismo, oj ni ch'ayuc ja yaltzila. Lajan soc jastal jun sat ixim huas tz'unji, pero ti huax c'aa. Ja sat ixim jahui, lom ni ja yaltzila porque mi ni huax pojxi masa. Pero ja ma' mi huas syajta sbaj ja ba mundo iti, seguro ni oj staa ja svida jau ba mi ni nunca oj ch'acuqui. Ja' ni smoj ja sat ixim ja ba huas tz'unxi. Eso sí, ja sat ixim jahui, lajan soc huax c'ai, pero ja yaltzili, mi na' jaye sat ixim huax ya pojxuc ja jun sat ixim jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ja ma' huas sc'ana oj yateltayon merani, pero t'ilan oj stul ja jmodo ja queni, jaxa jmozo jumasa jahui, ti ni oj huajuque ja bayon ja queni. Spetzanil ja ma' huax yateltayon ja queni, toyobal oj ajyuque yuj ja jTati. ");
INSERT INTO tojNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ja queni jel xa tuc ayon ‑ lajan soc ajnel jomel xta ayon eq'ue. ¿Jasunc'a mas lec oj c'uluc ba? ¿Oj ma cal yab ja jTati que oj jac ya elcon ja ba yojol ja huocol iti? Pero miyuc porque ja' ni yuj jaquelon ja ili. Sbej ni oj cuch ja huocoli, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yajni ch'ac yal ja jachuqui, ti och sc'umuc ja Diosi: ―Tatey, anima mi ajtaben ja huocol huax quiaji, siquiera jel nihuan oj iljan ja hueni. Cuando ch'ac yal ja jastal iti, ti abji jun c'umal ja ba satq'uinali: ―Ay ni ma' jel nihuan huax yilahuon ja huego. Oj to ni yilone mas nihuan. Jach xchi ja sc'umal ja Dios Tatali. ");
INSERT INTO tojNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jaxa cristiano ja ma' yabyei, huax yalahue que chahuuc, jaxa tuqui huax yalahue que c'umani con jun ángel ba oj yab ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pero ja Jesusi ti yalaa: ―Miyuc. Mi quenuc. C'umani ja Diosi ba oja huabyex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","C'ot ta ora ja huego, ja Diosi huan yiljel ja c'ujolali. Huan yaajel cuenta jastal huax yilahuone spetzanil ja cristiano, jaxa tan ajualal ja ba mundo, oj xa can ibilajel porque t'usan altiro huas sc'ana, mi na' ta ay jas oja hualex jbaj ja último ora jahui. Chican ja jas oja hualex jbaji, ma lequilalex, ma ch'ayelalex, pero ja ora jahui, ja yajualalil ja luum iti, oj ni can patelajela. ");
INSERT INTO tojNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pero ja cuando huax aaji locanucon ja ba cruzi, ti xa oj bob jpay jan spetzanil ja cristiano ba oj jacuque juntiro jmoc, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jach yala jachuc ba oj bob cabticon jas mero sbej oj chamuqui. ");
INSERT INTO tojNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ti yala june ja ma' tey tihui: ―Pero ja yabal ja Diosi ja ba libro ba huax taxi ja smandar ja Moisesi, ti huax taxi ti' ja Cristo, iday, ¡oj bi ajyuc sac'an tola vida! Ti coelon jan ja ba satq'uinali, la chi, jaxa huego huana yaljel oj aajan locan ja ba cruzi. ¡Mi ni jun sbej ja jastal huax och bulbunan ja hueni! xchi ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ti cho yala ja Jesusi: ―Oj xa och altiro ja acuali. Sbej huala bejyiyex t'usan mas ja huego ja janec' ti to ay ja luzi. Mi c'a, oj to huaj ahuilex, och ta huujilex ja acuali y mi oja naex bay ja beji. ");
INSERT INTO tojNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ora xa huego oj bejyanic ja ba quijlabi. Quena ni huax ca ijlabanuc ja hua bejexi. Leca ti to ayon amoquex ja huego. Huan c'a xa c'uanonex, oj ni bejyanic tola vida ja ba jex lijpi, xchi ja Jesusi. Yajni ch'ac yal ja jachuc ja Jesusi, ti ela. Gana huaj ba mi oj taajuc yuj ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ja Jesusi jel ja jas sc'ulunej ja ba sti sat ja cristiano jumasa jahui ba oj yile ja yip ja Diosi pero mi ni modo sc'uanea. ");
INSERT INTO tojNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jayuj c'ot ni smeranil ja jas stz'ijba can ja aluman‑Dios Isaías ja najatei: Cajual, mi ni modo huas sc'uane ja jas huax calatic tac. Yiluneje ja hua huip Cajual, pero lajan soc mutz'an ja satei. Jach huax yala ja ba slibro ja Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Y meran nia, mi ni huas sc'uane taca. Pero mi quechanuc ja iti, ay ni mas jas stz'ijbunej can ja Isaiasi: ");
INSERT INTO tojNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Lajan soc mutz'an ni ja sate ja cristiano y jel ch'uuy ja sc'ujolei. Mix yilahue q'uinal soc ja satei y mix yabye slugaril. Jayuj ja Diosi el ja sgana, jayuj ti yaa can ja jastal ni ja xch'uuyil ja sc'ujolei. Ti alji yabye yuj ja Diosi: ¡Moc lom jacanic jmoc! Jachuc mi ni oj ca tojbanica, x'utjiye yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ja Isaiasi jach stz'ijba cani, como aaji jac sc'ujol jastal jel nihuan juntiro oj jacuc ja Jesusi. Jayuj jach ni staa ti' ja ba slibroi. ");
INSERT INTO tojNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero anima, jitzan ni ja judio sc'uane ja Jesusa hasta ay ma' sc'uane ja ma' ay yatel yujilei. Pero mix yalahue satalajel abal yuj ja huax xiuye yuj ja fariseo jumasa. Mix yalahue porque lom oj aaji eluque ja ba yiglesiaei. ");
INSERT INTO tojNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jex c'anc'oni oj iljuque nihuan yuj ja smoj cristianoili, jaxa ba oj iljuque lec yuj ja Diosi, mi t'ilanuc huax yabye. ");
INSERT INTO tojNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ja Jesusi ti och c'umanuc tzatz leca: ―Ja ma' huas sc'uanon ja queni, mi quechanuc quen huas sc'uanon. Yuj ni huax cho sc'uane ja jTat ja ma' secahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Cuando huax yilahuone ja queni, oj cho yile ja jTat ja ma' secahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja queni jaquelon ja ba mundo ba oj caa yijlab ja sbej ja ma' huas sc'uanon ja queni, jayuj mi ni oj canuque ja ba q'uiq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero ja ma' huas smacla ja cabali y mi huas sc'ulan caso, mi xa ni quen tey ba jc'aba. Pilan ja ma' yiaj ta cuenta jastal oj yaa castigo. Ja queni mi jaquelucon ba xch'ayelal ja cristiano. Jaquelon ba oj coltaye. ");
INSERT INTO tojNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","¡Jel ch'in huax yilahuone! Ja jas huax cala, tzeejil huax yiaje. ¡A smajlaye! Ay ma' huan yiijel cuenta, jaxa spetzanil ja jas caluneji, mi ni jas oj ch'ayuc ja ora jahui, jayuj ti oj yile jas castigoil oj aajuc yile ja último c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ja jas huax cala, mi lom huax el ja ba j'olom ja quen mismo. Ja jTat ja ma' secahuon coni, yena ni huax yala cab jasunc'a oj cali soc jasunc'a oj jei. ");
INSERT INTO tojNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ja queni huax naa ja smandar ja jTati. Ta huan c'ax c'uaji, oj ni staa ja svida ba jel tzamal ja ma' huan ni sc'uani. Jayuj spetzanil ja jas huax cala ja queni, yuj ni alubal cab yuj ja Dios Tatali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Quechan xta jaman ja c'ac'u jahui, jastal jechel xa ni oj q'ueuc ja q'uin sbaj syalq'uinal ja judio jumasa. Ja Jesusi, como huan ni snaa oj xa yaa can ja mundo iti, oj xa ni huaj soc ja sTata. Pero ja ba mundo iti, jel ni yaj huax yab juntiro spetzanil ja ma' ti xa ni ay ba sc'ab ja yeni. Jaxa huego, huas slea jun modo jastal oj bob iljuc janec' spetzanil ja syajal ja sc'ujoli. ");
INSERT INTO tojNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Pero ja Judas Iscariote ja ma' Simón sbiil ja stati, ja ora jahui yaa ta sbaj soc juntiro ja diablo. Ti xa ay ba sc'ujol jastal oj yii spatic ja Jesusi. Pero ja Jesusi snaonej xa que oj xa cumxuc soc ja Diosi, como ti ni el con soc ja Diosa. Huan ni snaa que ac'ubal ni ba sc'ab spetzanil, como jach ni huas sc'ana ja Tatal Diosi. Ja Jesusi soc ja quenticon ja janec' snebumanoticoni cuando huanticon xa huael, ti q'ue ja Jesusi. Sopo jun lame ja sc'u ba satalajeli. Ti syuch'u jun toalla ja ba snalani. ");
INSERT INTO tojNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ti sbut'u yalel jun vasija. Ti och sac' quiticon ja cocticoni. Yajni ch'ac sac' ja cocticoni, ti scusu soc ja toalla ti yuch'an ja ba snalani. ");
INSERT INTO tojNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Cuando huaj sac' yi ja yoc ja Simón Pedro, ti yalaa: ―Pero Cajual, ¿jasyuj huen huaxa sac'a qui ja coqui? ");
INSERT INTO tojNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","―Ja huego mix jac ac'ujol ja jas huanon sc'ulajeli, pero ja mas tzaani oj jac ac'ujol, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―Ja queni, mi ni oj caa hui ba oja sac' qui ja coqui, xchi ja Pedro. ―Pero ta mi c'a huas sac'a hui, yuj ni mi xa teyuca ba jparte ja queni, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","―Ta jach c'a Cajual, ¡sac'a qui ja jc'abi soc ja j'olomi, mi quechanuc ja coqui! xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ti yala ja Jesusi: ―Pero q'uelahuile. Ja ma' atni ta con todo scuerpo, malan soc ja yoc oj cho sacxuc yi ja huego, porque sac'ubale xa nia. Ja huenlexi, sac xa ni ayexa, pero mi apetzaniluquex. Ay ma' mi ni t'un sac ay ja yaltzili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jach yala que mi jpetzanilticon sac ayticon yuj ja huan ni snaa machunc'a oj ic'unuc spatiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yajni ch'ac sac' quiticon ja cocticoni, ti xa cho slapa ja sc'u ba satalajela. Ti cho och culan ja ba mesa. Ti yalaa: ―¿Huan max jac ac'ujolex jas sbej ja ch'ac jsac' ja hua huoquexi? ");
INSERT INTO tojNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Huax hua ochconex maestroil. Huaxa huajualanonex. Sbej ni ja jas huaxa hualahuex caba, como jach ni ayona. ");
INSERT INTO tojNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ja maestroonex nia y ahuajualonex nia pero anima, quena ni jsac'a hua huoquexa. Jach ni ja huenlexi, t'ilan oja sac' abajex ja hua huoquexi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ja huego ch'ac ta jea huilex ja jas lec oja c'uluquexi y sbej ni jach oj cho ac'uluc ja huenlexa. ");
INSERT INTO tojNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Q'uelahuilex, ja queni ja huajualonex. Huax c'ulanex mandar, iday, huas sac'a huilex ja hua huoquexi, ¡jauc to ma huenlexi! Quena huax jecahuex jastal jun jecabanum. Mi oja lajonex pero anima, huas sac'a ja hua huoquexi. ¡Ba mi oj bobuc ja huenlexi! ");
INSERT INTO tojNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ta huan c'a xa huabyex slugaril ja jas huax jea huilexi, huan c'a xa c'ulanex, jel ni gusto oj ajyanica. ");
INSERT INTO tojNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pero ay june ja huenlexi mi sbajuc ja jas huanon yaljel ahuabyexi. Huax naa sbaj ja ma' jtzaunej ni. Pero t'ilan oj c'ot smeranil ja jas tz'ijbanubal ja ba yabal ja Diosi, que ja ma' lajan huax huaa jmoqui, yena ni bi oj yii jpatica. Jach ni huax yala ja yabal ja Dios tac. ");
INSERT INTO tojNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pero bajtan xa huanon yaljel ahuabyex cosaque cuando huax c'ot smeranili ti oja naex que quena nia huala tajiyon ti' ja ba yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Meran huax cala huabyex, ja ma' huas sc'ulan recibir ja ma' huax jeca ja queni, quena ni huas sc'ulanone recibira, jaxa ma' huas sc'ulanon recibir ja queni, huan ni sc'ulan recibir ja ma' seconejon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yajni ch'ac yal jachuc ja Jesusi, jel syatz'a sbaj juntiro ja yaltzili. Ti xa yala claro leca: ―Meran huax cala huabyexi, june ja huenlexi oj xa huiex jpatic. ");
INSERT INTO tojNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jaxa snebuman jumasa ti och sq'ueltalauc sbajea porque mi snaahue machunc'a huan tajel ti'. ");
INSERT INTO tojNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jaxa ba mero stz'eel ja Jesusi ti huanon huael ja queni. Jel yaj huax yabyon juntiro ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jaxa Simón Pedro ti sea qui seña ba oj job yi ja Jesús machunc'a huan stajel ti'. ");
INSERT INTO tojNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jayuj ti ochyon mas c'uban ja ba stz'eel ja Jesusi. Ti calaa: ―Cajual, ¿machunc'a huana stajel ti' ba? ");
INSERT INTO tojNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ti yala ja Jesusi: ―Q'uelahuile. Oja huile. Oj ca pooxuc jun pedazo pan, jaxa ma' oj caa yi ja pan jahui, yena nia, xchi ja Jesusi. Ti yiaj jun pedazo ja pani. Ya pooxuc, ti yaa yi ja Judas Iscariote ja ma' Simón sbiil ja stati. ");
INSERT INTO tojNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jaxa Judasi, yajni yiaj ja pan jahui, juntiro tzatzbi ele soc ja tan Satanasi. Ti alji yab yuj ja Jesusi: ―Ja jas oja c'uluqui, c'ulan xa mas ligero, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero mi ni june ja janec' huanticon huaeli cabticon slugaril ja jastal iti. ");
INSERT INTO tojNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ja Judasi, como tey ba sc'ab ja bolsa ja bay ja jtaq'uinticoni jayuj huax yalahue yuj ja jas yala ja Jesusi que oj huaj sman ja jas huax c'ulanticon necesitar ja ba q'uini ma bob ta ay jas oj yaa yi ja pobre jumasa xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yajni ch'ac sloo ja pan ja Judasi, ti huaja, pero huaaxa t'un acual. ");
INSERT INTO tojNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yajni el ja Judasi, ti yala ja Jesusi: ―Ja queni ti coelon jan ja ba satq'uinali, jaxa yaani oj xa huilex jastal jel nihuan juntiro oj huajcon. Oja huilex jastal jel nihuan ja yip ja Diosi pero yuj ni jc'ulan ta ja jastal sc'ana ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ta huan c'ax ilji jastal ja yip ja Dios yuj ja jc'ulan ta ja jas yala cabi, jachuc ja huenlexi, oj cho sea huilex jastal jel nihuan ja yeni porque yuninon nia. Ti ni coyon jan ja ba satq'uinali pero mi xa ni najatuc ay ja ora oj jeexuc ja jastal ja quijlabticon soc ja jTati. ");
INSERT INTO tojNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ay chotic cuntiquil, quechan xta t'usan tiempo teyon amoquexa. Eso sí, jel oj ch'aych'unuc juntiro ja hua c'ujolexi yuj ja mi xa teyuconi. Pero lajan soc ja jas cal yab ja jmojtic judioili, jach oj cho cala huabyex ja huego ja huenlexi: Mi to oj bob huajanic ja ba oj huajcon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pero oj cho caa huilex jun mandar yajc'achil. Yaj xa huab abajex ja huenlexi. Ja jastal yaj huax quilahuex ja queni, sbej ni oja yajta bajex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ta yaj c'a huaxa huab abajex, entonces ti oj aljuca: Ja jau jumasa, seguro ja' snebuman ja Cristo porque jel juntiro yaj huax yab sbaje, oj chiuque ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ti yala ja Simón Pedro: ―Pero Cajual, ¿ba oj huajan ba? Ti yala ja Jesusi: ―Ja ba oj huajconi, mi oj bob anochon ja huego, pero ja mas tzaani, oj ni bob huajan ja huenlex chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ti yala ja Pedro: ―Pero Cajual, ¿jasyuj mi oj bob jnocha ja huego? ¡Ja queni puesto ayon oj caa ja jvida yuj ja hueni! ");
INSERT INTO tojNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ti yala ja Jesusi: ―¿Meran ama puesto aya oja huaa hua vida yuj ja queni? Ja mero smeranili, oxe vuelta oja hual que mi xa naa jbaj cuando mi tox oc' ja gallo, x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Mi lom jex cham ja hua c'ujolexi. Huan ni xa c'uanex ja Diosi, cho c'uanonic ja quen chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ja ba snaj ja jTati jel ja lugar ja ba oj bob ajyaniqui. Ta mi c'a meranuc, ¿jas yatel lom oj cala huabyex? Pero ja iti, jayuj oj xa huaj chap ahuilex jun alugarexi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Oj ni huaj chap alugarexi, ti oj cho jacon otro vuelta ba oj jac quiex ba oj ajyucotic jun xta mismo lugar ja bayon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ja huenlexi huaxa naahuex lec ba oj huajconi, huax cho anaahuex ja bej chomajquili, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","―Cajual, ¡jastal oj naaticon ba oj huajana! ¿Jastal oj cho jnaaticon bay ja beji? xchi ja Tomasi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ti yala ja Jesusi: ―Ja bej jahui, quena nia. Puro smeranil ja jas huax cala huabyexi. Quena ni huax caa ja hua sac'anilexi. Ta ay c'a ma' oj c'otuc ja bay ja jTati, yuj ni oj yii ja bej jahui, y quena nia. ");
INSERT INTO tojNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ta huan c'a xa naahuex jbaj ja queni, yuj ni huaxa naahuex sbaj ja jTata. Huan ni xa naahuex sbaja como ahuilunejex nia, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ti yala ja Felipe: ―Cajual, jea quiticon bay ja Tatal ba. Malan soc ja jahui, oj naaticon merana. ");
INSERT INTO tojNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ti yala ja Jesusi: ―Felipe, ay xa t'usan tiempo ti ayex jmoc, iday, ¡mi to ni xa naa jbaja! Porque ja ma' huax yilahuon ja quen, huan nix yila ja Tatala. Iday, huana sc'anjel que oj jea hui ja jTati. ¡Jastal ay ja jau ba! ");
INSERT INTO tojNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mi ma xa c'uan que ti ayon soc ja jTati, jaxa jTati ti ni ay jmoca? Ja jas huax cala huabyexi, mi ti huax el ja ba j'olomi. Huax yala cab ja jTati como ti ni ay jmoca. Yen huax yala cab jasunc'a oj c'uluqui. ");
INSERT INTO tojNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","C'uanic ba que ti ayon soc ja jTati, jaxa jTati, ti ni ay jmoc ja quen chomajquili. Mi c'a, siquiera c'uanic ja huaxa huilahuex ja jas huanon sc'ulajeli. ");
INSERT INTO tojNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Huax cala huabyex ja smeranili, ja ma' huas sc'uanoni, oj cho bob sc'uluc ja jas huax c'ulan ja queni. Ay jas mas to nihuan oj bob sc'uluc como oj xa huajcon soc ja jTat ja queni ");
INSERT INTO tojNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Jaxa spetzanil ja jas huaxa c'anahuex yuj ja jbiil ja queni, oj ni caa huilexa. Como yuninon nia, huax lea ba oj toyjuc ja jTati. ");
INSERT INTO tojNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chican jasunc'a huaxa c'anahuex qui yuj ja jbiili, oj ni caa huilexa. ");
INSERT INTO tojNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ta yaj c'a huaxa huabyonex, oja c'uuquex ja mandar huax caa huilexi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Oj ni jc'an yi ja jTati ba oj sec ahuilex ja ma' oj scoltayex. Oj yaa snihuanil ja hua c'ujolex. Tola vida ti oj ajyuc amoquex. ");
INSERT INTO tojNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ja yeni, yena ni ja Espíritu Santo. Oj sea huilex ja jas merani. Ja suinquil ja mundo iti mix bob oj sc'uluque recibir ja Espíritu Santo. Mix bob yile, mi ni huas snaahue sbaja. Pero ja huenlexi huaxa naahuex sbaj como ti ni ay amoquexa. Mi ni nunca oj yaex cani. ");
INSERT INTO tojNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Miyuc cuntiquil, mi oj caex can atuch'ilex. Oj cumxucon ba ti oj ajyucon amoquexa. ");
INSERT INTO tojNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","T'usan sc'ana, mi xa oj to yilon mas ja mundo. Quechan ja huenlexi, eso sí, oja huilonex. Oj ajyucon sac'an ja queni. Jachuc ja huenlexi, oj cho ajyanic sac'an. ");
INSERT INTO tojNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja tiempo jahui, oja huilex que ti ayon soc ja jTati y ti ni oj cho ajyanic jmoc ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ja ma' huas sc'uan ja jmandari, huax ilji que meran ni yaj huax yabyona. Ja jTati yaj huax cho yab ja ma' yaj huax yabyon ja queni. Jach ni ja quen chomajquili, yaj oj cho cabi. Oj cho jee yi ja quipi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ti yala ja Judasi, pero mi jauc ja Iscariotei: ―Cajual, ¿jasyuj ja quechan ja quenticon oja jee quiticon ja hua huip ba? ¿Jaxa cristiano jumasa ja ba mundo ba? ");
INSERT INTO tojNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ti yala ja Jesusi: ―Pero ja ma' yaj huax yabyoni, huas sc'uan ja cabali, ja yenlei jel yaj huax abji yuj ja jTati. Jaxa jTati soc ja queni, ti oj ajyucoticon tola vida soc ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pero ja cristiano ba mundo mi yajuc huax yabyone jayuj mi squitz'ahue ja cabali. Ja jas huax cala huabyexi, mi ti huax el ja ba j'olomi. Ja jTat ja ma' seconejon coni, yen yala cabi. ");
INSERT INTO tojNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yuj ja ti xa ayon amoquexi, jayuj huanon yaljel ahuabyex ja iti. ");
INSERT INTO tojNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero cuando la huajyon ja queni, oj jecjuc ahuilex ja Espíritu Santo. Oj scoltayex ja yeni. Oj yaa ja snihuanil ac'ujolex. Oj sea huilex spetzanil soc oj ya jul ac'ujolex ja jas calunej ahuabyexi. Jecubal oj jacuc yuj ja jTati ba oj och jloc'ol ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Oj xa huajcon ja queni, pero laman la ajiyex ja huenlexi. Ja jastal laman ja jc'ujol ja queni, jach laman oj ajyanic ja huenlexi. Mi ni nunca oj slaj ja jastal ja ba mundo. Mix cham ac'ujolex. Moc lom xihuanic. ");
INSERT INTO tojNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ja huabyex cala que oj xa huajcon, pero oj to jacon otro vuelta. Ta ay c'a meran ja syajal ac'ujolex jmoqui, sbej que gusto ni oja huabyexa cuando huaxa huabyex que oj xa huajcon soc ja jTati porque ja yeni, mas nihuan que yuj ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Huanon yaljel ahuabyex ja huego que oj xa huajcon. Cuando mi xa ti ayucon amoquexi, ti oja huilex que meran nia. ");
INSERT INTO tojNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ja yajualil ja mundo iti, jacum xa. Mi xa oj bob ochcotic loil mas. Pero ja yeni, mi jas yioj jmoc. ");
INSERT INTO tojNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ja queni quechan huanon sc'ulajel ja jas huax yala cab ja jTati ba oj snaa ja mundo que yaj huax cab ja yeni. Q'ueanic xa. Huajtiquic xa, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ja queni ja' jmoj jastal jun ibe cajpe, jaxa jTati, yen ja ma' huas stalna ja steil ja cajpe jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Q'uelahuil ja cajpe tac. Ta ay c'a jun sc'ab huax yila que meyuc ja sati, huas sc'utzu ele, jaxa sc'ab ba ay ja sati, huas sc'ulan can lec podar y huax yaa can tzamal ba oj ajyuc mas ja sati. ");
INSERT INTO tojNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jachuc ja huenlexi, como sac'ubal xa ni ay ja hua c'ujolexi porque ac'uunejex ja jas jea huilexi. ");
INSERT INTO tojNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Q'uelahuilex jun sc'ab cajpe. Ta huan c'ax jechji ele, mi xa ni modo oj to satinuca. Ja ba huax yaa sati, sbej ni noc'an soc ja steila. Ja' mero amojex ja huenlexi. Ta mi c'a ti ayuquex mojan ja ba jtz'eeli, mi ni nunca oj bob jas oja huilex sata. Pero huan c'a xa leahuonex, oj ni jacon amoquexa. ");
INSERT INTO tojNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Meran nia, jach ni ayon jastal ja jun ibe cajpe jahui, jaxa huenlexi, lajan soc jc'abex. Ta ti c'a huala ajiyex tola vida mojan ja ba jtz'eeli, jel ja jas oja huilex sati. Pero ta najat ahuiajonex, mi ni jas oj bobuc ahuujilexa. ");
INSERT INTO tojNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ja hua vidaexi oj jomuc. Lajan soc oj jipjanic el ja ba fuera porque jach ni huax jipxi jun sc'ab te' cuando huax tacji. Huax tzomxi spetzanil ja ba taquini, ti huax jipxi ba yoj c'ac'. ");
INSERT INTO tojNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pero ta tola vida huanex sleejel jastal mojan oj ajyanic jmoc, mi c'a huax ch'ay ac'ujolex ja cabali, entonces c'anahuic qui ja jas huaxa c'anahuexi y oj ni caa huilexa. ");
INSERT INTO tojNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ja cristiano cuando huax yilahue que jel tzamal ja hua modoexi, jel ni oj yaahue yi stz'acatal ja jTat ja ba satq'uinali. Oj chicnajuc lec que mero jnebumanex nia. ");
INSERT INTO tojNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ja jastal yaj huax yabyon ja jTati, jach ni yaj huax cabyex ja huenlexa. C'ulan seguir abajex. Naahuic tola vida que jel yaj huax cabyex ");
INSERT INTO tojNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Porque ta jach c'a huanex, yuj ni huanex ni sc'uajel ja jmandari. Jach ni ayon soc ja jTat ja quen. Tola vida huax c'uan ja smandari, jayuj huax naa lec que jel ja syajal sc'ujol jmoqui. ");
INSERT INTO tojNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ja jas huax cala huabyexi, yuj ni ba oja huabyex ja gusto ja ba jc'ujol ja queni. Huax c'ana que jel alegre juntiro oj huajuc ja hua hualtzilexi. ");
INSERT INTO tojNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ja jastal yaj huax cabyex ja huenlexi, jach ni yaj oja huab abajex apetzanilex. Ja iti, ja' ni ja jmandar huax caa huilexi. ");
INSERT INTO tojNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ta ay c'a ma' huax yaa ja svida yuj ja yamigo, yuj ni jel yaj huax yaba. ¡Jas mas oj bob sc'ul yi! ");
INSERT INTO tojNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jayuj naahuic, camigoex nia ta huaxa c'uanex ja jmandari. ");
INSERT INTO tojNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ja huenlexi, mi xa huan tox cala que jmozoex porque jun mozo mi huas snaa jas huas sc'ulan ja yajuali. Pero lec yuj ja camigo xa jbajtiqui, jayuj caa ta naex spetzanil ja jas cab yala ja jTati. ");
INSERT INTO tojNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ja huenlexi, mi huenuc atzaunejonex. Quena ni jtzaahuexa, jayuj huax cala huabyex, caaxic xa. Aa xa iljuc sat ja hua huatelexi, jaxa atel jahui mi ni nunca oj ch'ayuc. Jayuj ja jTati, chican ja jas huaxa c'anahuex yi, oj ni yaa huilexa porque huan xa la ochyex ba sti sati yuj ja jbiil ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jayuj huax cala huabyex lec tac, yaj xa huab abajex. Ja' ni mero jmandar ja iti. ");
INSERT INTO tojNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ta coraja c'a huax yilahuex ja cristiano, a jac ja hua c'ujolex que jach ni coraja yilahuone ja quen tac. ");
INSERT INTO tojNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Porque ta sbajex c'a ja mundo ja huenlexi, gusto ni oj iljanica porque ja ma' tey ba mundo, yaj ni huax yab sbajea. Eso sí, ti ayex ja ba mundo ajyi, pero jtzaahuex nia, jayuj ja ma' ti to ay ba mundo, jel xa coraja huax yilahuex porque mi xa sbajuquex ja mundo. ");
INSERT INTO tojNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","A jac ac'ujolex ja jas calunej ahuabyexi. Mi ni jun mozo oj slaj ja yajuali. Ja queni, ja huajualonex, pero iday, ixta ni huax yilahuonea, ¡jauc to ma huenlex mi ixta ni oj iljanica! Pero ay ni ma' sc'uan ja jas cala. Jach ni ja huenlex chomajquili. Ay ma' oj sc'uuquex. ");
INSERT INTO tojNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero t'ilan ni oj ixtalajanica yuj ja huan ni xa c'uanonexi, como mi ni huas snaahue sbaj ja ma' secahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ja cristiano, moc to jacon ja queni, eso sí, mi ni jun smule ayea. Pero ja huego, como jac jee yile, jayuj mi xa ay perdón. ");
INSERT INTO tojNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ja mero smeranili, ja ma' coraja huax yilahuon ja queni, jach ni, coraja ni huax cho yila ja jTata. ");
INSERT INTO tojNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jitzan atel jc'ulunej ja ba sat ja yenlei. Mi ni nunca ma' sc'ulan ja jastal iti. Ja lec mey xyilahuei, mi ni ay smulea. Pero ja iti, yiluneje jitzan cosa, pero anima, coraja ni huax yilahuonea. Y jach ni ja jTati, coraja huax cho yilahue. ");
INSERT INTO tojNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero jach ni oj sc'uluquea porque jach ni huax yala ja ba yabal ja Diosi. Coraja bi oj yilone pero mi ni jun sbej. Jach ni huax yala ja ba slibro ja Dios huas sq'uelahue tac. ");
INSERT INTO tojNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pero ay ma' oj to jacuc, jaxa yeni oj ya jac ac'ujolex machunquilon ja queni. Ti oj el jan ja ba mero stz'eel ja jTati ba oj jac yaa snihuanil ac'ujolexi. Oj cho ya naex spetzanil ja jas merani porque quena ni oj jec con ahuilexa. ");
INSERT INTO tojNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jachuc ja huenlexi, sbej huaxa loiltayex ec' ja cabali porque huenlex nia ti ni ajyiyex ec' jmoc desde yora q'ue ja cateli. ");
INSERT INTO tojNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jayuj huax cala huabyex spetzanil ja iti. Moc lom jomuc ja hua pensarexi. Mi jauc ja oja huaex can jun lado ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Eso sí, ja jmojtic judioili oj snutzex ja ba hua huiglesiaexi. Oj c'ot ja c'ac'u ta ay ma' huas smilahuex june ja huenlexi, oj stoy sbaje que huane ni yateltajel ja Dios ja jastal jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jach oj sc'uluque porque mi ni nunca snaahue sbaj ja jTati soc mi ni ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jayuj huax cala huabyex spetzanil ja iti porque cuando huax c'ot ja c'ac'u jau que ay ma' oj miljuc ahuujilexi ti oj jac ac'ujolex ja jas huanon yaljel ahuabyex ja huegoi. Como meran nia, mi cala huabyex ja cuando och jtul t'an ja cateli, como ti ni ayon amoquexa. ");
INSERT INTO tojNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero ja huego, como oj xa huajcon soc ja ma' secahuon coni, jayuj huan xax cala huabyex. Iday, ja huenlexi, mi ni ma' huax yaa sbaj ahuujilex ba oj sob qui ba huala huajyona. ");
INSERT INTO tojNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ja mero smeranili, jel triste ayex juntiro yuj ja jas huax cala huabyexi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero mas lec huax cala huabyex oj huajconi como meran nia, porque mi c'a la huajyon ja queni, mi oj jacuc amoquex ja ma' oj yaa snihuanil ac'ujolexi. Ja yeni oj scoltayex lec. Pero como oj ni huajcona, jayuj oj jeca huilex ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yajni huax jac ja yeni, oj ya jac sc'ujol spetzanil ja cristiano que mi quenuc ay jmuli ‑ yenle nia, soc oj cho aaji jac sc'ujole que oj yae cuenta ja smule ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ti ni cuchan yujile ja smulei yuj ja mi huas sc'uanone ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Oj xa ni huajcon ja bay ja jTati. Ja huenlexi mi xa oj to ahuilonex mas, jaxa cristiano ti oj jac sc'ujolea que mey jmul ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Oj snae que jel nihuan juntiro jastal oj ch'ac yii cuenta ja Diosi porque ja yen ja ma' huas sc'ulan mandar ja ba mundo iti oj ni jipjuc el ba jun ladoa. ");
INSERT INTO tojNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ay to jitzan ja jas huax c'ana cala huabyexi pero mi to ni oj bob ch'ac ahuabyexa. ");
INSERT INTO tojNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero cuando huax jac ja Espíritu Santo, ja yeni oj ya naex ja jas merani porque mi tiuc oj eluc ba s'olom ja jas oj yali. Ja' ni oj yal spetzanil ja jas huax yab huax yala ja Dios Tatali. Oj ya jac ac'ujolex spetzanil ja jas oj to ec'uqui. ");
INSERT INTO tojNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Oj sea huilex jastal ayon ja queni. Jel tzamal oj staa ti' ja jbiili. ");
INSERT INTO tojNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Spetzanil ja jas yioj ja jTati, jbaj ni quena jayuj huax cala huabyex que ja Espíritu Santo oj sea huilex spetzanil ja iti. ");
INSERT INTO tojNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","T'usan sc'ana, mi xa oj to ahuilonex, pero majlayic. A cho ec' t'usan mas ja c'ac'u, ti oj cho huilonex otro vueltaa porque oj xa huajcon ja bay ja jTati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ti och sobtalauc sbaje chaboxe ja snebuman jumasa: ―¿Pero jas sbej ja jahui? Huax yala que t'usan c'ac'u sc'ana, mi xa oj to quiltic, y huax cho yala que oj ec' t'usan ja c'ac'u, ti oj cho quiltica porque ti bi oj huajuc ja bay ja sTati. ");
INSERT INTO tojNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Jas sbej ja huax yala t'usan sc'ana? Mix c'ulantic entender ja jas huan yaljeli, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ja Jesusi ti yab xchiq'uel que ay jas huas sc'ana sobe ja snebuman jumasa, ti yalaa: ―Cala ta huabyex que t'usan sc'ana mi xa oj to ahuilonex pero a cho ec' t'usan ja c'ac'u, ti oj cho huilonex otro vueltaa. ¿Ja' ma jel ja hua pensarex yuj ja huabyex jach cala jastal iti? ");
INSERT INTO tojNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ja mero smeranili, oj to oc'anic lec. Jel triste oj huajanic pero ja cristiano, jel gusto juntiro oj huajuque. Meran nia, jel triste oj huajanic ja huenlexi pero huan tox huaj anaa bajex, jel xa gusto ayex juntiro. ");
INSERT INTO tojNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lajan soc jastal jun ixuc cuando oj xa tojbuc can soc ja yal alatzi. Jel ja spensari porque q'ue ta ni suocoli pero cuando ti xa ay ja yal alatzi, spetzanil ja ba yaj huax yab ajyi, mi xa jauc to huas snaa. Ja' xa jel ja sgusto yuj ja ti xa huan sq'ueljel ja sat ja yali. ");
INSERT INTO tojNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jachuc ja huenlexi, oj xa q'ueuc ja hua huocolexi, pero cuando huax cho jac quilex otro vuelta, jel juntiro oj gustoaxuc ja hua hualtzilexi, jaxa hua gustoex jahui, mi ni ma' oj bob ya eluc ahuilexa. ");
INSERT INTO tojNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ja c'ac'u jahui, mi xa quen to oja jobex qui. Huax cala huabyex ja smeranili, ja' xa mismo jTat oj yaa huilex spetzanil ja jas huaxa c'anahuex yi, como ay ni ahuiojex ja jbiil ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Masan ora mi to xa nebahuex jastal oja hualex yab ja Diosi: Yuj ja sbiil ja Cajualticoni aa quiticon ja jas huax c'anaticoni. Pero ja yaani, c'anahuic xa y oj aajuc ahuilex y soc ja jahui, oj xa ni ajyanic lec gustoa. ");
INSERT INTO tojNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Spetzanil ja loil ch'ac ta cala huabyexi, huax lea jun modo siquiera ba oja c'uluquex entender. Pero ja yaani claro lec oj ch'ac el jti jastal ay ja Tatal Diosi. Mi xa oj to ca najatbuc ja jloili. ");
INSERT INTO tojNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ja yaani, como ay xa huiojex ja jbiili, mi xa t'ilanuc quen mismo oj c'an yi ja jTat ja jas huaxa c'anahuexi ");
INSERT INTO tojNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Porque ja Tatali, yen mismo jel yaj huax yabyex. T'ilan oj yaa huilex ja jas huaxa c'anahuex yi. Jel yaj huax yabyex porque huas snaa que yaj huaxa huabyonex ja huenlexi y huaxa c'uanex que quen jecubalon yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja queni caa can ja jTati ba oj jacon ja ba mundo iti pero ja huego, oj xa caa can ja mundo. Oj xa cho huajcon soc otro vuelta ja jTati, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ti yala ja snebuman jumasa: ―Ja huego, claro lec ja jas huana yaljeli y huan xax cabticon sbej. ");
INSERT INTO tojNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Huan xax naaticon ja huego que mi jas mi huaxa naa ja hueni. Mi xa t'ilanuc oj jobticon ahui. Jayuj huan xax c'uanticon que jecubala yuj ja Diosi, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ti yala ja Jesusi: ―Entonces ¿jun ta ora huaxa c'uanex? ");
INSERT INTO tojNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","¡Pero lástima porque ja' xa ni ora iti oj huajanic sactantan ja huenlexi! Oja huaonex can jtuch'il. Pero mi jtuch'iluc porque ja jTati, ti ni ay jmoca. ");
INSERT INTO tojNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Huax cala huabyex spetzanil ja iti ba oj bob ajyuc laman ja hua c'ujolex yuj ja huaxa c'uanonex ja queni. Ja ba mundo iti jel ni oja huiexa pero c'ulanic ahuantar. Tzatz la ajiyex porque lec xa ay. Jc'ulan ta ganar. Can ta baan ja yajualil ja mundo. ");
INSERT INTO tojNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yajni ch'ac yal spetzanil ja jastal iti, ja Jesusi ti sq'uela q'ue ja ba satq'uinali. Ti yalaa: ―Tatey, c'ot ta ni ja cora. Ja huuninon nia. A iljuc ja jastal jel lec huaxa huilahuoni y jach ni ja queni, oj ni ca nihuanbuc ja hua biila. ");
INSERT INTO tojNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ja yaani tey ba jc'ab spetzanil ja matic ahuaunej qui. Ja' jchol ahuaonejon ba oj caa yile sac'anile ba tola vida. ");
INSERT INTO tojNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ja sac'anil jahui ja' ba oj naajuc abaj ja hueni porque ja hueni, quechan único Dios mas nihuana. Sac'ana lec. Oj cho naajucon ja quen chomajquili. Ti oj yalea: Entonces ja Jesús jahui, ja' ni ja Cristo ja it seconej quitic ja Diosi, oj chiuque ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ja ba mundo iti, ch'ac ta ca chijcajuc jastal jel tzatz juntiro ja hua huipi. Ja huego, ch'ac ta jc'uluc ja atel ahuaa quii. ");
INSERT INTO tojNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja yaan Tatey, lec xa ay. Oj xa c'otcon ja ba sti ja hua sati. Tz'acatal lec porque oj xa hua lijpucon otro vuelta ja jastal ayon ahuuj ajyi, ja yora mi to la jacyon ja ba luumi. ");
INSERT INTO tojNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jaxa ma' apilunej jan qui ja ba mundo, ch'ac ta ca snae jastal aya ja hueni. Ja yenlei como ja baj ni ja huenaa pero ahuaunej qui. Sc'uane ta hua huabali. ");
INSERT INTO tojNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ja yaani huan xa snaahue spetzanil ja jas quioji, huena ni ahuaunej quia. ");
INSERT INTO tojNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Cala ta yabye spetzanil ja jas ahualaunej cabi, jaxa yenlei, sc'uane ta nia. Jac ta sc'ujole que meran huena ni ajeconejona. Huan xa ni snaahue que ti elyon con ja bay ja hueni. ");
INSERT INTO tojNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Jayuj huax c'ana hui pavor yuj ja yenlei. Mi jauc oj c'ana hui yuj ja ma' tey ba mundo. Ja' ni huanon sc'anjel ahui yuj ja ma' ahuaunej ni quii, como abaj ni ahuenaa. ");
INSERT INTO tojNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Spetzanil ja jas quioj ja queni, ja baj ni ahuenaa, jaxa jas ahuioj ja hueni, jbaj ni quen chomajquila. Jaxa quijlabi huan xax yijlabane ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ja queni mi xa ti oj ajyucon ja ba mundo como oj xa huajcon ba ti oj ajyucon amoc ja hueni pero ja yenlei ti ni oj canuque ja ba mundoa. Tatey, ja hueni jel santoa jayuj talna qui soc spetzanil ja hua huipi ja ma' ahuaunej quii ba oj bob yil sbaje como jastal smoj'aljijel sbaje como jastal ayon amoqui. ");
INSERT INTO tojNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Porque cuando ti ajyiyon soc ja yenle ja ba mundo, ahuaa qui ja huipi, jayuj bob jtalnaye ja ma' ahuaunej ni quii. Tola vida coltanubale ni cujila. Mi ni june ja yenlei ch'aye cujil. Eso sí, ja jun ma' ch'ayel xa nii, ch'ay nia. C'ot ni smeranil ja jastal tz'ijbanubal ja ba hua huabali. ");
INSERT INTO tojNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pero oj xa ni huajcon ja bay ja hueni, pero leca ti to ayon ja ba luumi, ja jas huanon yaljel ahuabi, huax cala siquiera oj bob yab ja yenlei cosaque gusto ni oj ajyuquea porque ja queni, jel gusto ayon juntiro. ");
INSERT INTO tojNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Cala ta yabye ja hua huabali. Jel coraja huax iljiye porque mi sbajuque ja mundo ja yenlei ja jastal mi sbajucon ja mundo ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi huax c'ana hui ba oj hua eluque ja ba mundo. Quechan huax c'ana hui ba mi oj c'ulajuque ganar yuj ja diablo porque toj malo ja yeni. ");
INSERT INTO tojNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ja queni mi sbajucon ja mundo y jachuc ja yenlei, mi sbajuque ja mundo. ");
INSERT INTO tojNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","A snae mas y mas ja huabali porque puro smeranil. Jachuc, oj bob ajyuque mas toj. ");
INSERT INTO tojNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ja jastal ajecahuon ja quen ja ba mundo, jach oj cho jeque ja ba mundo ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Huax c'ana que oj caa jbaj ahui juntiro cosaque jachuc ja yenlei, oj bob yaa sbaj ahui, pero meran. ");
INSERT INTO tojNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pero mi quechanuc huax c'ana hui yuj ja yenlei. Huax cho c'ana hui yuj ja ma' oj to sc'uuc ja mas tzaan cuando huax yabye oj aljuc yabye ja cabal yuj ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Tatey, huax c'ana hui lec pavor que spetzanil ja ma' huas sc'uanei, soc ja ma' oj to sc'uuque ja mas tzaani, que oj quil jbajtic como jastal mero jmoj'alijel jbajtic jpetzaniltic. Ja hueni, jbaja, jaxa queni, ja bajon nia, jaxa yenlei, jun ita ni oj cho ajyucotic soca. Ta jach c'a merani, ja cristiano oj snaa que meran huena ni ajeconejon cona. ");
INSERT INTO tojNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ja jastal jel tzamal juntiro ja jas ac'ulunej qui, jach jc'ulunej yi ja yenlei ba jun xta yabal oj yil sbaje ja jastal ja quentic jun xta huax quila jbajtiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ja queni, jun xta ayon soque, jaxa hueni, jun xta ayon amoc, siquiera huax c'ot ja c'ac'u jahui que tzatz oj ajyuque jmoctic cosaque ja cristiano ja ba mundo oj snae que huena ni ajeconejona. Oj snae que huan ni xa yajtayea como jastal huaxa yajtayon ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Tatey, huena ni ahuaa qui ja cristiano jumasa iti. Huax c'ana que ti oj ajyuque jmoc ja ba oj huajconi ba oj bob yile jastal ja quijlab ahuaunej quii porque cuando mi tox cujlaji ja satq'uinali, jel ni yaj huaxa huabyona. ");
INSERT INTO tojNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tatey, jel toj juntiro ja hua pensari pero ja cristiano mi huas snaa baj. Pero ja queni huax naa baj soc jach ni ja it jumasa. Huan xa ni snaahue que huena ni ajecahuon coni. ");
INSERT INTO tojNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Caa ta snae mach ayaa y oj to ca snae mas. Oj ca jac sc'ujole jastal jel yaj huaxa huabyoni, ti ni oj ajyuc lec ja syajal sc'ujole ja yenle chomajquili, jaxa yenlei, oj ni snae que ti ni ayon soque ja quena. ");
INSERT INTO tojNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yajni ch'ac yal ja jastal it ja Jesusi, ti huajticona. Ec' jc'utzticon jun uc'um, Cedrón sbiil, jaxa tihui tey jun huerta. Ja janec' snebumanoticoni ti huajticon soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jaxa ja Judas ja ma' huan xa ni yiijel spatic ja Jesusi, huas snaa bay ja huerta jahui porque jitzan vuelta ni huajticon lajan soc ja Jesús ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jayuj ja Judas jahui ti yiaj och jun nole soldado soc chaboxe policía ja ma' huas stalna ja templo. Jecubal huajye yuj ja sepeil ja nihuac pagre jumasa soc ja fariseo jumasa. Listo xta aye soc ja svaraei. Ay yioje ja sc'aq'ue soc ja stajei. ");
INSERT INTO tojNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero ja Jesusi, como huan xa ni snaa jastal oj ch'ac ec'uca, jayuj yajni yila jacyei, ti huaj staea, ti sobo yia: ―¿Machunc'a huaxa leahuexi? xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","―Ja' huax leaticon ja tan Jesús nazareño, xchiye. ―Pero quena nia, xchi ja Jesusi. ―Jaxa Judas ja ma' huan yiijel spatic ja Jesusi ti ni ay ba snalan ja cristiano jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pero iday, quechan pavor ch'ac yal ja Jesús que yena, jaxa cristiano jumasa, ti ch'ac couque sacjaujau man luuma. ");
INSERT INTO tojNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ti cho sobo otro vuelta ja Jesusi: ―¿Mach bi junuc huaxa leahuexi? ―Ja' huax leaticon ja tan Jesús nazareño, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","―Pero ch'ac ta cala huabyex que quena ni taca. Ta quen c'a huaxa leahuonexi, pero ja jmoj jumasa, a huajuque libre, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ch'ac ni eluque librea, como jach ni yala ja Jesús que mi ni june oj ch'ayuc ja yenle ja ma' ac'ubal yi yuj ja Tatali. ");
INSERT INTO tojNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Entonces ja Simón Pedro, como ay yioj ja smachiti, ti stasaa. Ti sc'utzu el yi ja stojol xchiquin jun huinic Malco sbiil, jaxa huinic jahui, ja' ni mero smozo ja pagre mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero ja Jesusi ti yal yab ja Pedro: ―Ch'ica ba snaj ja hua machit ja hueni. ¿Yuj ama huaxa huala que ta mi jauc ja jTat huax yala que oj ni qui ja huocol it ba? ");
INSERT INTO tojNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Entonces ja jun nole soldado soc ja scomdanteei soc ja jpoliciaticon ja janec' jmoj jbajticon judioili ti syamahue ja Jesusi. Ti syuch'uhuea. ");
INSERT INTO tojNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ti yiaje och ja ba snaj ja Anasi. Ja Anás jahui, ja' ni snial ja Ciafasi, jaxa jabil jahui, ja Caifasi, yena ni ochel pagreil mas nihuan ja ba spetzanil ja pagre jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jaxa Caifás jahui, yena ni ja ma' yalunej ni yab ja judio jumasa que mas bi lec quechan jun huinic oj yaa svida que soc ja oj cham spetzanil ja suinquil ja slugarei. Jach ni yaluneja. ");
INSERT INTO tojNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jaxa Simón Pedro soc ja queni, como jmoj ni jbajticon nebumanila, ti nochanoticon och soc ja Jesusi. Ja queni, como camigo jbaj soc ja pagre mas nihuani, jayuj ti aaji ochcoticon soc ja Jesús ja ba spatioil ja snaji. ");
INSERT INTO tojNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero ja Pedro ti can ja ba calle mojan ja ba sti ja puerta. Jayuj ja queni ti huaj jc'umuc ja aq'uix ja ma' huas stalna ja puerta, jayuj ti cho och ja Pedro chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Entonces ja aq'uix jau ja ma' huan stalnajel ja puerta ti sobo yi ja Pedro: ―Jaxa hueni, ¿mi ma huenuc ni june ja snebuman ja tan huinic jahui? ―¡Miyuc! xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Como jel ja chee, ja atjum jumasa ja ba naitz jahui soc ja policía jumasa, jayuj ti stzomoneje jun montón c'ac'. Chacjinjin xta yujile. Jaxa ba sti ja c'aq'ui ti sactec'tec' ec' huane sq'uixnajel ja yoquei. Cho ti ni ay ja Pedro soc ja yenlei. Ti huane c'atnel lajan ja ba sti ja c'aq'ui. ");
INSERT INTO tojNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jaxa pagre mas nihuani ti och sob yi ja Jesusi: ―Ala cabi, ¿machtic junuc ja hua nebumani? xyutaj ja Jesusi. ¿Jasunc'a huana seejel eq'ue? ");
INSERT INTO tojNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ti yala ja Jesusi: ―Ja jas huax cala eq'ui, satalajel abal juntiro. Pe jeunej ni ja ba hua huiglesiaex tac, soc ja ba templo ja ba huaxa tzomo bajex apetzanilex ja janec' jmoj jbajtic judioili. Ja jas ch'ac cali, mi ni nac'ul abaluca. ");
INSERT INTO tojNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pero mi sbejuc huaxa jobo qui ja queni. Jobo yi ja matic ch'ac yabye ja jas huax jeai. A yal yenle ja jas caluneji. Huan ni snaahue lec taca, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yajni ch'ac yal jachuc ja Jesusi, june ja policía ja ba templo ja ma' tey ja tihui, ti snocho yi jun vuelta ja ba sat ja Jesusi. Ti yalaa: ―¿Jas sbej ja jach huaxa hual yab ja jpagretic ba? ");
INSERT INTO tojNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","―¿Yuj ama ay jas cala malo ba? Ala jasunc'a mi lecuc calai. Porque ta sbej ja jas cala, ¿jas sbej ja lom huaxa mac'ahuoni? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jayuj ja Anasi ti yala que oj mochjuca, ti bi oj iiji och ja ba sti sat ja Caifasi, jaxa Caifasi, ja' ni ja pagre mas nihuan yujile ja jabil jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Cuando ti to ay ja ba sti sat ja Anás ja Jesusi, jaxa Pedro ti ni tec'an ec' ja ba sti ja c'aq'ui. Ti huan c'atnela. Ti jobji yia: ―¿Mi ma huenuc june ja snebuman ja tan huinic jahui? ―Mi quenuc, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ti sobo yi june ja smozo ja pagre mas nihuani. Ja mozo jahui, yermano sbaje soc ja mozo ja ma' sc'utzu yi ja xchiquin ja Pedro. ―¿Yuj ama huaxa huala que mi quilahua ja ba huerta soc ja tan huinic jahui? xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ja Pedro ti cho yala otro vuelta que miyuc. Quechan pavor ch'ac yale, ti oc' huego ja galloa. ");
INSERT INTO tojNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jaxa ma' tey ba yoj snaj ja Caifasi, ti xa elyea. Ti yiaje och ja Jesús ja ba spalacio ja gobierno, pero huan xa sacbel ja q'uinali. Jaxa judio jumasa mi ochye ja ba palacio, ja' bi ba mi oj staa ja smulei. Huan c'a bix ochye, mi bi oj bob huauque ja ba suael ja sq'uinei. ");
INSERT INTO tojNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jayuj ja gobierno Pilato, yen el jan ja ba yoj palacio ba oj sc'umuc ja judio jumasa: ―¿Jasunc'a ja smul ahuujilex ja huinic iti? xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","―Ta mi c'a ay smul, mi oj quiiticon jan ahui ja huen Señor Gobernador, xchi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ja Pilato ti yalaa: ―Entonces ¡tojbesic ja huenlex ta jachuqui! C'ulanic yi ja jastal ja hua ley ja huenlexi. ―Pero ja quenticoni, judiooticon nia. Mi ni sbejuc oj milticon jun cristiano, xchi ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jayuj c'ot smeranil ja jas yala ja Jesús ja jas oj c'ulajuc yi. Oj bi miljuc ja ba cruzi pero mi bi jauc ja smoj judioil oj miljuc yuji. ");
INSERT INTO tojNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ja Pilato ti cho och ja ba yoj palacio. Ti spaya jan ja Jesusi. Ti sobo yia: ―¡Ata huab tac! ¿Huena ma srey ja judio jumasa? ");
INSERT INTO tojNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ti yala ja Jesusi: ―¿Huana ma sobjel quechan ja huen atuch'il, ma ay ma' yalunej ahuab ja iti? xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ti yala ja Pilato: ―¿Yuj ama judioon ja quen ba? Ja hua moj judioili soc ja sepeil ja hua pagreex jumasa, yen sc'ulana qui endregal ja ba jc'abi. ¿Jasunc'a hua c'ulunej yile ba? xchi ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ti yala ja Jesusi: ―Ja ba huax c'ulan mandar ja queni, mi jauc ja ba mundo iti. Ja lec jauc to, entonces ja camigo jumasa oj ochuque pleito ba mi oj aajucon endregal ja ba sc'ab ja jmoj judioili. Pero ja iti, como mi sbajuc oj c'ul mandar ja ili. ");
INSERT INTO tojNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ja Pilato ti yalaa: ―Entonces slugar huena reya ta jachuqui. Ti yala ja Jesusi: ―Reyon nia, como huen huaxa huala. Moc to jac manxucon ja ba mundo iti, mi ni ma' oj snaa ja jas merani. Jaxa spetzanil ja ma' huas sc'ana oj sc'uuc ja smeranili, huan ni smaclaye ja jas huax cala, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","―Pero ¿jasunc'a ja smeranil ba? xchi ja Pilato. Yajni jach yala ja Pilato, ti cho el otro vuelta ba oj sc'umuc ja judio jumasa. ―Ja queni, mi ni jun smul huax quila ja huinic iti. ");
INSERT INTO tojNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero como culan ni ahuujilex huax sijpan ahuilex jun presoanum ja q'uin it syalq'uinali, ¿huana ma xa c'anahuex oj ca huaj libre ja hua reyexi? xchi ja gobierno Pilato. ");
INSERT INTO tojNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ti ahuaniye tzatz lec ja cristiano: ―¡Ja jahui, miyuc! ¡Ja' huax c'anaticon oj huaj libre ja tan Barrabasi! xchiye. Iday, jaxa Barrabás jahui, mero ni lagrona. ");
INSERT INTO tojNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Entonces ja Pilato ti yiaj ja Jesusi. Ti yaa orden ba oj mac'juc. ");
INSERT INTO tojNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ja soldado jumasa ti sc'ulane jun corona puro q'uiix, ti yaahue cajan ja ba s'olom ja Jesusi. Ti yaahue slap jun sc'u morado, como morado ni ja sc'u huas slapa ja reyi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ti ochye c'ubana: ―¡Viva ja sreyil ja judio jumasa! xchi ja soldado jumasa, como huane ni burlaa. Ti smac'ahue ja ba sati. ");
INSERT INTO tojNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jaxa Pilato ti cho el otro vuelta ja bay ja cristiano jumasa. Ti yalaa: ―Q'uelahuilex. Quiaj jani ba oja naex que ja queni mi ni jun smul huax taa yi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ti el jan ja Jesusi, jaxa ba s'olomi ti lapan yuj ja corona q'uiixi, jaxa sc'ui, ja' ni ja morado jastal huas slapa ja reyi. Ti yala ja Pilato: ―¡It bay jul ja huinic it yen! xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yajni yilahue ja sepeil ja pagre jumasa soc ja policía jumasa ti och ahuanuquea: ―¡A cham ba cruz! ¡A cham ba cruz! xchiye xta. Ti yala ja Pilato: ―Ta jach c'a, pues iajic. A q'ueuquex locan ba cruz ja huenlexi porque ja queni, mi ni jun smul huax taa yia. ");
INSERT INTO tojNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ti yalahue jan ja judio jumasa: ―Ja quenticoni ay jun jleyticon, jaxa ley jahui huax yala que sbej oj chamuc porque huas stoyo sbaj que yunin Dios bi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ja Pilato cuando ch'ac yab ja jas yalahuei, ti och mas ja xihueli. ");
INSERT INTO tojNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ti och och otro vuelta ja ba yoj palacio. Ti sobo yi ja Jesusi: ―¿Ba jacya ja hueni? xchi. Pero ja Jesusi mi ni jun palabra c'umania. ");
INSERT INTO tojNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ti yala ja Pilato: ―C'umanon ba porque ¿mi ma huaxa naa quen ay catel? Huan c'ax c'ana, oj caa orden oj chaman ja ba cruzi ma oj cho caa orden que oj huajan libre. ");
INSERT INTO tojNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ti yala ja Jesusi: ―Eso sí, meran, huen ay ahuatel pero lec moc to jauc ja Diosi, entonces mi ni jas oj bobuc ahuuj soc ja quena. Jayuj ja ma' jac sc'ulucon endregar ahuii, mas jel nihuan juntiro ja smule que yuj ja hueni, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja ora jahui, ja Pilato och slee modo jastal oj bob yaa can libre ja Jesusi pero ja judio jumasa, ti cho och ahuanuquea. ―Pero ta huan c'a xa huaa can libre, yuj ni mi amigo ayuca soc ja mero jepe ja ba Roma. Porque ja tan Jesús iti huan stoyjel sbaj que oj och reyil. Entonces ja' mero scondra ja jepetic Cesari, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jayuj ja Pilato, cuando ch'ac yab ja jastal iti, ti yala que oj ya eluque ja Jesusi, jaxa yeni ti huaj culan ja ba huax ajyi arreglo. Ja lugar jahui, Gabata sbiil yujile ja judio ja ma' huax c'umaniye hebreo, jaxa palabra jahui, ja mero sbeji, Empiedrado Ay. ");
INSERT INTO tojNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mojan culan lec ja c'ac'u, jaxa c'ac'u jahui, quechan xta ni ja c'ac'u jamana, jaxa ni jastal jecheli ja' ni ja syalq'uinala. Ja Pilato ti yal yab ja judio jumasa: ―¡Oj xa caa ba hua c'abex ja hua reyexi! ¡Ch'abananic xa! ");
INSERT INTO tojNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ja yenlei ti cho q'ue ahuanuquea: ―¡A chamuc! ¡A chamuc! ¡A q'ue locan ba cruz! xchiye xta. Ti yala ja Pilato: ―Pe ¿huan ama xa c'anahuex oj ca q'ue locan ba cruz ja hua reyex ba? Ti yala jan ja sepeil ja pagre jumasa: ―Ja quenticoni, mey otro jreyticon. Quechan ni jreyticon ja ma' tey ba Roma, ja' ni ja Cesari, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yajni yab ja jastal it ja Pilato, ti sc'ulan yile endregal ja ba sc'abe ja Jesusi ba oj ya q'ueque locan ja ba cruzi. Jaxa yenlei, ti yiajea. ");
INSERT INTO tojNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ti aaji sq'uech ja scruzi. Ti huaj ja ba lugar Gólgota sbiil yujile ja ba sc'umale hebreoi, porque ja palabra jahui huax yala que splanta sbaquel ja s'olom ja chamhuiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ja tihui, ti yaahue locan ja ba cruzi. Ti cho aaji q'ue locan otro chahuane huinic smoja, jaxa Jesusi, ti och ba nalanajel. ");
INSERT INTO tojNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jaxa Pilato ti yaa orden que oj c'ulaxuc jun letrero, jaxa letrero jahui, oj bi aajuc pac'an ja ba s'olom ja scruz ja Jesusi: JESUS SBAJ NAZARET, SREYIL JA JUDIO JUMASA xchi ja letrero sc'ulani. ");
INSERT INTO tojNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jitzan lec ja judio sq'uela ja letrero jahui porque ja lugar jau ba aaji locan ba cruz ja Jesusi, mojan yioj sbaj soc ja chonabi, jaxa jas tz'ijbanubal ja ba letrero jahui, oxe c'umal ni tz'ijbanubala, ja' ni ja hebrero soc ja griego, soc ja latini. ");
INSERT INTO tojNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jayuj ja ma' jepe ay ja ba spagre ja judio jumasa, ti yalahue yab ja Pilato: ―Mi lom xa tz'ijba que sreyil ja judio jumasa. Mas lec tz'ijba que ja ma' huax yala sbaj que sreyil ja judio jumasa, xchi ja pagre. ");
INSERT INTO tojNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","―Ja jastal jtz'ijba ta, jacha ni oj canuca, xchi ja Pilato. ");
INSERT INTO tojNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yajni ch'ac ta ya q'ueuque locan ja ba cruz ja Jesusi, ti xa stuluhue ja sc'ui. Cada jujune ja xchanhuane soldado jahui yiaje jujune ja sc'u ja Jesusi. Pero ay jun sc'u toj eq'uel jalubal man ba scuerpo soc man ba yoc. ");
INSERT INTO tojNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ti yalahue ja soldado jumasa: ―Mas lec mi huax ch'iatic ja sc'u iti. Mas lec la jc'ultic ripar. Oj quiltic machunc'a oj yii, xchiye. Cuando jach sc'ulane ja jastal jahui, ti c'ot smeranil ja jastal ni tz'ijbanubal ja ba yabal ja Diosi: Spila sbaje ja jc'ui. Sc'ulane ripar, xchi ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Y meran nia, jach ni sc'ulane ja soldado jumasa ja c'ac'u jahui. Jaxa ba stz'eel ja scruz ja Jesusi, ti tec'an ec' ja snani. Cho ti ni ay ja suatz ja snani soc tey ja María jau xcheum ja Cleofasi, soc ja María jau sbaj Magdala. ");
INSERT INTO tojNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jaxa Jesusi, cuando yila ti tec'an ec' ja snani soc ja queni, como jel ni yaj huax yabyona, ti yal yab ja snani: ―Naney, ja yaani, ja' xa oj xa ochuc ahualil ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ti yala cab ja queni: ―Jaxa hueni, ila jastal mero ja hua nan ja jnani, xyutajon. Jaxa ora jahui, ja snan ja Jesusi ti xa quiaj och ja ba jnaji como snebumanon nia. ");
INSERT INTO tojNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yajni ch'ac ta yal jachuqui, ja Jesusi, como huan ni snaa ch'ac ta sc'uluc spetzanil ja yatel oj ni sc'uluqui, soc ba oj c'ot smeranil ja jastal ni tz'ijbanubal ja ba yabal ja Diosi, jayuj ti yalaa: ―Jel taquin ja jtii, xchi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ti culan ec' jun jarra ja tihui but'el ja yalel tz'usubi, pero jelxi ta spajali. Ti yiaje jun yojol c'aem, ti sbut'uhue ja yalel tz'usub jahui. Ti stz'acbaye soc otro te', jaxa te' jahui, hisopo sbiil cujticon. Ti ya q'ueque man ba stia. ");
INSERT INTO tojNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ja Jesusi ti xchuan ja yalel tz'usub jahui. Ti yalaa: ―Ja yaani, ch'ac ta jc'uluc spetzanil ja cateli, xchi. Ti tz'uyuyi xta huaj ja s'olomi, ti chama. ");
INSERT INTO tojNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Como ja c'ac'u jahui quechan xta ni jamana. Jastal jechel xa ni ja syalq'uinali. Jaxa jmojticon judioili mi huas sc'anahue que ti oj ajyuc locan ja scuerpoe ja ma' ti locan ba cruz ja sc'ac'uil ja sijlele jahui, como q'uin nia y mas jel nihuan yioje ja mero sc'ac'uil jahui, jayuj ti huaj sc'ane yi ja Pilato que oj yaa orden que oj huaj sc'oque yi ja sat yoc ja matic ti locan ja ba cruzi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jayuj ti huaj ja soldado jumasa. Huaj sc'oque yi ja sat yoc ja juni, y jach ni ja otro ja ma' ti locan ja ba stz'eel ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jaxa yajni ti xa aye ba stz'eel ja Jesusi, ti yilahue que chamel xaa, jayuj mi xa ni sc'ocohue ja sat yoc ja yena. ");
INSERT INTO tojNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero june ja soldado jahui ti stasa ja scuchilu, ti xch'ubu yi ja ba scostilla ja Jesusi. Jaxa xchiq'uel eli, socan soc ja'. ");
INSERT INTO tojNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Quena ni huanon yaljel ja iti porque quila soc ja jsati. Ja jas huax cala, yuj ni merana. Yuj ni huax naa que meran ja jas huanon yaljeli ba oj bob ac'uuc ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Spetzanil ja jastal ec' yujil ja ora jahui, como jach ni tz'ijbanubal ja ba yabal ja Diosi. Mi ni bi june ja sbaquel oj sc'oque yii. ");
INSERT INTO tojNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Cho ay otro ja ba tz'ijbanubal ja ba yabal ja Diosi. Huax yala que ja cristiano oj syajbese, jaxa mas tzaani, ti oj sq'uele jastal yaahue yajbuc leca. Jach ni huax yala ja yabal ja Dios tac. ");
INSERT INTO tojNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ay jun huinic José sbiil, yamigo ni sbaje ajyi soc ja Jesusi, pero nac'ul abal yamigo sbaje porque ja Josei, jel huax xiu yuj ja jmojticon judioili. Ja xchonabil ja yeni, Arimatea sbiil. Yena ni ja José jahui huaj sc'an yi permiso ja Pilato ba oj bob yii con ja scuerpo ja Jesusi. Ja Pilato ti yaa permisoa jayuj ja José ti yiaj ja scuerpo. ");
INSERT INTO tojNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti cho c'ot ja Nicodemo ja ma' huaj loil soc jun acual ja Jesusi. Yiaj jan jun polvo ba jex ajbani ja yiq'uili ba oj sax yi ja scuerpo ja Jesusi. Ay socan soc jun c'ul mirra sbiil, soc áloes. Ay mojan como treinta kilo ja yalal ja yajnal jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ja José soc ja Nicodemo ti yiaje ja scuerpo ja Jesusi. Ti sbech'ahue soc c'uutz, jaxa c'uutz jahui balubal ni lec soc ja perpumea, como jach ni ja jcostumbreticon ja janec' judiooticon cuando huax mucuticon ja chamhuiniqui. ");
INSERT INTO tojNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Mojan ja ba stz'eel ja lugar jau ja bay ja cruz ja ba aaji q'ue locan ja Jesusi, ay jun huerta. Jaxa ba yoj huerta jahui ay jun nihuan patac' yajc'achil to jotobal. Mi to ni ma' huax mucji ja tihua. ");
INSERT INTO tojNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jaxa tihui ti yaahue och ja scuerpo ja Jesusi, como mas mojan ay ja q'ueen jahui. Jach sc'ulane yuj ja oj xa q'ue altiro ja sc'ac'uil ja sijlele ja jmojticon judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ja sbajtanil c'ac'u ja semana, ja' ni ja domingo, ja María jau sbaj Magdala ti huaj ja ba q'ueeni pero jel saj juntiro huaji. Q'uic' to ja q'uinali. Huaj to yile, mi xa teyuc ja ton jau macan soc ja sti ja q'ueen ajyi. ");
INSERT INTO tojNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ja María ti huaj ajnel ja bay ja Simón Pedro soc ja queni, como jel ni yaj yabyon ja Jesusi. Ti yala ja María: ―¡Yaahue ta eluc ja ba q'ueen ja scuerpo ja Cajualtiqui! ¡Saber ba yaahuea! ");
INSERT INTO tojNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jaxa Pedro soc ja queni ti huajticon ja ba q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lajan elticon pero ja queni mas jel carreda huajyon jayuj bajtan c'otyon ja ba q'ueen que yuj ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ti coyon cotan jq'uela lec ja ba yoj q'ueeni. Huaj to quile, quechan ti pacan ec' ja c'uutzi, pero mi ochyon. ");
INSERT INTO tojNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yajni c'ot ja Simón Pedro, como tzaan xa c'oti, ti och och ja ba yoj q'ueeni. Jach ni ja yeni, cho yila ti pacan ec' ja c'uutz jahui, ");
INSERT INTO tojNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Cho yila ja c'uutz it ti bechji ja ba s'olom ja Jesús ajyi, pilan pacan. ");
INSERT INTO tojNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ja queni bajtan c'otyon ja ba q'ueeni pero tzaan ochyon ja ba yojoli. Ti jac jc'ujol jastal aya. Ti jc'uan juntiroa. ");
INSERT INTO tojNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cuando mi tox quilaticon ja jastal iti, lajan soc mi ni huax c'ulanticon entender ja jastal ay ja ba yabal ja Diosi, que ja Jesusi oj ni bi chamuca, pero t'ilan ni bi oj sac‑huuca. ");
INSERT INTO tojNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yajni ch'ac quilticon, ti xa cumxiticon ja ba jnajticoni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero ja María ti can ja ba sti ja q'ueeni. Ti huan oq'uela. Huan lec oq'uel cuando co nujan sq'uel ja ba yoj q'ueeni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ti yila chab ángel sac juntiro ja sc'uei. Ti culane ec' ja ba baan ja scuerpo ja Jesús ajyi. Ja juni, tey ba s'olom, jaxa juni, tey ba lado ajyi ja yoqui. ");
INSERT INTO tojNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ti yala ja angeli: ―Nana, ¿jasyuj huana oq'ueli? Ti yala ja María: ―Porque ay ma' yiaj quiticon ja scuerpo ja Cajualticoni y mi naben ba yaahue ja ma' yiaji. ");
INSERT INTO tojNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Quechan pavor ch'ac yal ja jachuqui, ti sutu sbaja. Ti yila ja Jesusi pero mi huas snaa ta yena ni ja Jesusi. Ti tec'an ec' ja ba stz'eeli. ");
INSERT INTO tojNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ti yala ja Jesusi: ―Nana, ¿jasyuj huana oq'ueli? ¿Machunc'a huaxa leai? Pero ja María huax yala que ja' ma' huan stalnajel ja huerta. Ti yalaa: ―Tata, ta huen c'a hua eluc, ala cab ba ahuaa ba oj bob huaj quii jani. ");
INSERT INTO tojNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ti yala ja Jesusi: ―¡María! Ti sutu sbaj ja María, ti yala soc ja sc'umal hebreo: ―¡Raboni! Maestro huax yala ja palabra jahui. ");
INSERT INTO tojNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ti yala ja Jesusi: ―Moc ayamon porque mi to la q'ueyon ja bay ja jTati. Pero caax. Cax al yab ja quermanotic jumasa que oj xa q'uecon ja bay ja jTati. Ja Tat ni ja huenlex chomajquili. Oj xa q'uecon ja bay ja jDiosi pero jDiostic ni lajana. ");
INSERT INTO tojNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ja María jau sbaj Magdala ti huaj yal cabticon ja janec' nebumanoticon que yila ta bi ja Cajualtiqui, ti ch'ac xchol cabticon spetzanil ja jastic alji yabi. ");
INSERT INTO tojNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ja mismo c'ac'u jahui, ja cuando och ja acuali, ja' ni mero sbajtanil c'ac'u ja semana, ti jtzomonej jbajticon pero ja puerta jumasa lutan cujticon yuj ja jel huanticon xihuel yuj ja cristiano jumasa. Ja Jesusi ti ocha. Huaj to quilticon, ti xa tec'an ec' ja ba jnalanticon. Ti yaa quiticon Diosa. Ti yalaa: ―Laman la ajiyex, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yajni ch'ac ta yal ja jastal iti, ti xa sea quiticon ja sc'abi soc ja scostilla, como snebumanoticon nia. Jel gusto juntiro quilaticon ja Cajualticoni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ti cho yala ja Jesusi: ―Laman la ajiyex. Ja jastal secahuon ja jTati, jach huax cho jecahuex ja huenlexi. ");
INSERT INTO tojNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ja Jesusi ti suuhuoticona. Yajni ch'ac ta suoticon, ti yalaa: ―C'ulanic xa recibir ja Espíritu Santo, xyutajoticon. ");
INSERT INTO tojNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ta ay c'a ma' huas sc'ana oj c'ulajuc perdonar ja smuli, oj ni jc'ultic perdonara. Pero ta ay c'a ma' jel tzatz ay soc ja smuli, pues ti scuchu cana. Jach yala cabticon. ");
INSERT INTO tojNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero ja Tomás jau ja ma' huax calaticon sbaj gemeloili, ja' ni june ja quenticon ja janec' snebumanoticon nii, ja yeni mi teyuc ja yora jac ja Jesús soc ja quenticoni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Cuando cumxi ja Tomasi, ti calaticon yab jastal quilaticon ja Cajualtiqui. Ti yala ja Tomasi: ―Pero ja queni, ti oj c'uuc ta huan c'ax quila ja sc'ab ba och ja clavo. Oj ch'ic ja yal jc'ab ja ba sotoli, jaxa ba scostilla oj cho jch'ic ja jc'abi, ti oj c'uuca, xchi xta. ");
INSERT INTO tojNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ti ec' otro huaxaque c'ac'ua. Ti cho jtzomonej jbajticon otro vuelta ba jun naitz ja janec' snebumanoticoni. Ja ora iti, ti xa ni ay ja Tomasi. Eso sí, ja puerta jumasa lutan lec cujticon pero anima, huaj to cho quilticon, tey ba jtz'eelticon ja Jesusi. Ti cho yaa quiticon Diosa: ―Laman la ajiyex, xyutajoticon. ");
INSERT INTO tojNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ti yal yab ja Tomasi: ―La ahuil Tomás. La ch'ica quitic ja yal ac'ab ja ba och ja clavo. Q'uelahuil ja jc'abi. Iaj jan quitic ja hua c'abi. Ch'ica och ja ba jcostilla. Mi lom x'ec ac'ujol que mi quenucon. ¡C'uan xa t'unuc Tomás! x'utji. ");
INSERT INTO tojNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ti yala ja Tomasi: ―¡Dios Cajual! ");
INSERT INTO tojNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ti yala ja Jesusi: ―Ja huego Tomás, huaxa c'uan yuj ja huilahuon ta. Pero mas lec huax yilahue ja ma' huas sc'uan y mi ni huax yilahuonea. ");
INSERT INTO tojNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ja Jesusi mi quechan sc'ulan can ja jas ti tz'ijbanubal ja ba libro iti. Mas jitzan lec ja jas sc'ulan ba oj ya sna ja cristiano que ja' ni jecubal yuj ja Diosi. Mi ajtaben ja milagro quilaticon ja janec' snebumanoticoni. ");
INSERT INTO tojNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ja jas tz'ijbanubal can ja ba libro iti, ja' ba oja c'uuquex que meran yena ni ja Cristo, ja yunin ja Dios ja Jesús iti. Ta huan c'a xa c'uanex merani, ti oja taex ja sac'anilex ba tola vida. ");
INSERT INTO tojNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jaxa mas tzaan t'usan ja iti, ja Jesusi ti cho sea sbaj quiticon otro vuelta ja janec' snebumanoticoni. Ti jac ja ba sti ja ja' Tiberiasi. Jach huaj ja jastal iti: ");
INSERT INTO tojNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ti jmoj jbajticon soc ja Simón Pedro soc ja Tomás jau huax alji sbaj gemelo, soc ja Natanael jau ja ma' slugar ajyi ja Caná sbaj Galilea. Cho tey ja chab yuntiquil ja Zebedeo soc ay otro june snebuman ja Jesusi soc ja queni. ");
INSERT INTO tojNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ti yala ja Simón Pedro: ―Ja quen oj xa huaj yam chay, xchi. Ti calaticon ja quenticoni: ―Jach ni ja quenticoni. Oj huajcoticon amoc. Jayuj ti huajticona. Huaj q'ueticon jun barco pero ja acual jahui, mi ni jun chay jyamaticona. ");
INSERT INTO tojNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cuando huan xax och sacbuc ja q'uinali, huaj to quilticon, tey ja Jesús ja ba sti ja jai pero mi ni huax naaticon ta yena nia. ");
INSERT INTO tojNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ti sc'umanoticon ja Jesusi: ―Queremtic, ¿mi ni ma jas huaxa yamahuex ba? Ti calaticona: ―Mi ni jas huax taaticona. ");
INSERT INTO tojNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ti yala ja Jesusi: ―Jipahuic co ja hua huenubexi ja ba lado stojol ja hua c'abexi ti oja huilex ta mi oj ni ayamexa. Jach ni jc'ulanticona. Y meran nia, mi xax bob ca elticon ja quenubticoni yuj ja but'el juntiro ja chayi. ");
INSERT INTO tojNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ti cal yab ja Pedro: ―¡Seguro ja' ja Cajualtiqui! la chiyon. Quechan pavor ch'ac yab ja Pedro que ja' Cajualtiqui, ti slapa huego ja sc'u soponej ajyi. Sipa sbaj ja ba yoj jai. Mix yila ora oj sc'umuc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jaxa quenticon ja smojoticon nebumanili ti c'oticon ja ba sti ja ja' soc ja jbarcoticoni. Ti jquichunejticon jan ja enub ba but'el ja chayi, como ja ba tec'an ec' ja jbarcoticon ajyi, ay yioj mojan cien metro ja ba sti ja jai. ");
INSERT INTO tojNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Cuando coticon ja ba jbarcoticon ja ba sti ja jai ti jtaaticon jun montón ja c'aq'ui pero chac xa lec. Ti xa ay jun chay huan bacbela soc tey ja pan ti pachan ja ba sti ja c'aq'ui. ");
INSERT INTO tojNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ti yala ja Jesusi: ―Iajic jan chaboxe ja chay huan tox ch'ac ayamexi. ");
INSERT INTO tojNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jaxa Simón Pedro ti cho q'ue ja ba barcoa. Ti squicha el ja ba sti ja ja' ja enub jau but'el ja nihuac chayi. ¡Ay ciento cincuenta tres ja chayi! Jel jitzan juntiro ja chayi pero ja enubi, mi ni c'utza. ");
INSERT INTO tojNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ti yala ja Jesusi: ―La xa huaacotic, xchi. Ja quenticoni, mi ni ma' yaa sbaj oj sobe yi machunc'aa, como huan nix naaticon que ja' ni ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ja Jesusi ti huaj ja ba sti ja c'aq'ui. Ti syama ja pani, ti spila quiticona. Jach ni sc'ulan soc ja chay chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ja iti, ja yoxil vuelta sea sbaj quiticon ja janec' snebumanoticoni porque sac'an xa nia. Es meran nia, cham ta ajyia pero ja ora jahui, cho sacui ta. ");
INSERT INTO tojNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Cuando ch'ac huaacoticoni, ja Jesusi ti yal yab ja ma' Jonas sbiil ja stati, ja' ni ja Simón Pedro: ―Simón, ¿quechan ma huen mas jel yaj huaxa huabyon que soc ja it jumasa? ―Cajual, huan ni xa naa que jel huax c'anahua, xchi ja Pedro. Ti yala ja Jesusi: ―Ta jach c'a, aa yi ja suael ja yal jchej jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ti cho sobo yi otro vuelta ja Pedro ja yunin ja Jonasi: ―Simón, ¿yaj ama xa huabyon merani? ―Pero meran Cajual. Huan ni xa naa que jel huax c'anahua, xchi ja Pedro. Ti yala ja Jesusi: ―Entonces talna ja jchej jumasa ba. ");
INSERT INTO tojNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ti cho sobo yi ba yoxil vuelta ja Pedro ja yunin ja Jonasi: ―Simón, ¿huan ama xa c'anahuon meran? Jaxa Pedro jel tristeaxi yuj ja jobji yi oxe vuelta ta meran ja yaj huax yabi, ti cho yala ja Pedro: ―Cajual, pe huan ni xa naa spetzanil tac. Huan nix cho huila que jel yaj huax cabya tac. Ti yala ja Jesusi: ―Entonces aa yi ja suael ja jchej jumasa. ");
INSERT INTO tojNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Huax cala, pero meran, cuando untica to, huaxa lapa ja hua c'ui, tzatz aya lec y huala huaji ba huaxa c'ana huajani. Pero cuando mas viejoa xa, ti oja huil que oj jachjuc ahui ja hua c'abi. Pilan ja ma' oj ya lap ja hua c'ui. Oj quichjan ja ba mi huaxa c'ana huajani, x'utji ja Pedro yuj ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jach yala jastal it ja Jesusi ba oj ya jac sc'ujol jastal oj to chamuc ja Pedro, como oj to ni bi yaa svida ba oj ya nihuanbuc ja sbiil ja Diosi. Ja Jesusi ti cho yal yab ja Pedro: ―Pero anima, ja huego, c'uanon nia. ");
INSERT INTO tojNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ti huajticona. Yen mero bajtan ay ja Jesusi soc ja Pedro. Jaxa Pedro ti sutu sbaja. Ti yilahuona. (Ja queni, ja yora último huaaticon soc ja Cajualtiqui, ti ayon ja ba mero stz'eeli. Quena ni jobo yi machunc'a mero oj yii spatiqui.) ");
INSERT INTO tojNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jaxa Pedro cuando yilahuoni, ti yalaa: ―Cajual jaxa huinic iti, ¿jastal oj ec' yuj ba? ");
INSERT INTO tojNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ti yala ja Jesusi: ―Pero Pedro, mi ahuocheluca ja yeni. Chican ja jas huax c'ana ja queni, ta oj taa sac'an ma miyuc ja ora oj cho jacon otro vuelta. Ja hueni, ja ba mas t'ilani, c'ulan seguir abaj, quechana. ");
INSERT INTO tojNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yuj ja yala jachuc ja Jesusi, jayuj el ja razon que mi ni bi nunca oj chamcon ja queni. Pero ja Jesusi mi yala que mi oj chamcon. Eso si, yala ta jach huas sc'ana ja yeni, sac'an oj staon cuando huax cumxi. Mi bi yocheluc ja Pedro ja jahui. Jach ni yalaa. ");
INSERT INTO tojNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ja queni, quena ni ja nebuman jau staahuon ti' ja Jesusi. Huax cala ja smeranil jastal huaji jayuj jtz'ijba ta can ja ba libro iti. Huax naaxi lec que meran ja jas huax cala. ");
INSERT INTO tojNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ja Jesusi ay to jas jel jitzan ja jas sc'ulani. Ja lec huax ch'ac tz'ijbaxuc spetzanil ja jastaltic sc'ulani, pero ja libro jumasa huax cala que mi ni nunca oj taxuc ba oj ch'ac ochuc ja ba mundo iti. Ti ch'aca. Amén.");
INSERT INTO tojNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Lec ay, Tata Teófilo, ja mero sbajtanil juun it jtz'ijba ta huii, ch'ac ni cala huab spetzanil ja jastic sc'ulan soc ja jastic sea ja Cajualtic Jesusi. Jach ni sc'ulan desde q'ue stul ja yateli ");
INSERT INTO tojNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Masan to iiji q'ue ja ba satq'uinali. Pero ja mi tox huaj ja ba satq'uinal ja Jesusi, stzaa ja secabanum jumasa. Yal yab ja jas lec oj sc'uluquei, jaxa jas yala, como ja' ni yuj ja yip ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jaxa Jesusi ti xa chama, iday, ja mas tzaani ja secabanum jumasa yilahue entero scuerpo. Snajtil ja cuarenta c'ac'u jumasa jahui, jujune ta ch'ay c'ujol huax jac see sbaj yile. Jac ni see sbaj juntiro claro leca ba oj snaa ja secabanum jumasa que sacui ta. Ja' ni mero huan staajel ti' jastal jel nihuan huas sc'ulan mandar ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pero cuando ti to ni ay ja Jesús soc ja secabanum jumasa ti yala que mi to bi lom oj huajuque t'ani, que ti bi oj tec'ajuque t'usan ja ba Jerusaleni: ―Majlayic ja jas oj yaa huilex ja jTati, ja' ni ja jas yaluneji, xyutaj ja secabanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Eso sí, ja Juani ya huiex ja' pero t'usan c'ac'u sc'ana ti oj jacuc amoquex ja Espíritu Santo, pero soc spetzanil ja yipi, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cuando ti ni tzamane soc ja Jesusi ti sobohuea: ―Cajual, ¿yuj ama ja' xa ora oj hua elcoticon libre ja quenticon ja israeleñooticon ba? ");
INSERT INTO tojNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ti yala ja Jesusi: ―Ja huenlexi mi t'ilanuc oja naex jas ora. Quechan ja jTati huas snaa, como ti ni ay ba sc'aba. Yen huas snaa jas sc'ac'uil oj sc'uluc ja jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero cuando huax co jan abajex ja Espíritu Santo, ja huenlexi oja taa lec ahuipex, ti oj elanic ec' oja loiltayonex ec' ja queni. Oja hualex ec' ja ba Jerusaleni soc ja ba sutanal ja Judea soc ja ba Samaria soc ja ba spetzanil ja najtil lugar jumasa ba sutanal ja satq'uinali, xchi ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yajni ch'ac yal ja jastal iti, jaxa secabanum jumasa ti huane sq'ueljel ja Jesusi. Huaj to yile, ja Jesusi iiji q'ue ja ba satq'uinali. Ti jac jun t'one asona. Musji ja Jesusi, ti ta ch'aya. ");
INSERT INTO tojNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cuando ti to ch'ipan ja sate ja ba satq'uinal ja ba yilahue q'ue ja Jesusi, huaj to yile, tey ba stz'eele chab huinic. Toj sac juntiro ja sc'uei. ");
INSERT INTO tojNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ti alji yabyea: ―Jaxa huenlex galileño, ¿jasyuj lom ti canyex q'uelan ja ba satq'uinali? Ja jastal ti asatex ahuilahuex q'ue ja Jesús ja ba satq'uinali, jach ni oj cho jacuc otro vuelta como jastal ahuilahuex q'uei, xchi ja ángel jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ti xa coye ba huitz Olivosa. Cumxiye ba Jerusaleni, como mojan ni yioj sbaj soc ja huitz jahui, jach ni snajtil ja janec' ni huax bejyiye ja sc'ac'uil ja jijleli, yuj ja jach ni culan yujile soc ja sleyei. ");
INSERT INTO tojNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuando c'otye ja ba Jerusaleni, ti q'ueye ba cuarto ba xchabil piso ja bay ja sposadaei. Tey ja Pedro soc ja Jacobo soc ja Juani, soc ja Andresi, soc ja Felipe, soc ja Tomasi, soc ja Bartolomé, soc ja Mateo, soc ja Jacobo yunin ja Alfeo, soc ja Simón ja ma' tey ba slado ja partido cananista, soc ja Judas ja yermano ja Jacobo. ");
INSERT INTO tojNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Spetzanil ja yenlei stzomonej sbaje soc ja yermano jumasa ja Jesusi, soc ja María ja snani, soc ay chaboxe ixuque. Ti huane sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ja c'ac'u jumasa jahui ja Pedro ti q'ue tec'an ja ba snalan ja yermano jumasa, ay ma como ciento veinte cristiano. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Quermano jumasa, ja najate lequi, ja Davidi ti julbesji yuj ja Espíritu Santo ch'ac stz'ijba ja ba yabal ja Diosi jastal oj to ec'uc ja Judas ja ma' slea smoj ba oj huaj syam ja Jesusi, iday, ja jas stz'ijba cani t'ilan ni c'ot smeranila. ");
INSERT INTO tojNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ja Judas jahui ja' ni june ja jmoj quentica. Jmojtic ni atela. ");
INSERT INTO tojNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iday, xchono sbaj yuj ja smaloil ja sc'ujoli, jaxa stz'acoli, ti manji soc jun pedazo luumila. Jaxa Judas jahui ti moc'a. Huichquintop coi. Toj bojtel huaji. Ch'ac huospujuc el ja xchanlucumi. ");
INSERT INTO tojNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jaxa suinquil ja Jerusaleni, cuando ch'ac yabye ja jastal iti, ti yaahue sbiiluc ja luum ba smanahuei chic', pero ja ba yabal ja yenlei, Aceldama sbiil yujile. ");
INSERT INTO tojNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jaxa ba libro ba Salmo jumasa huan nix yala que oj ni can lutan ja snaj ja Judasi. Mi ni bi oj ajyuc suinquil ja snaja. Cho yala que pilan ma' oj yii ja yateli. ");
INSERT INTO tojNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Jayuj june ja quermanotic jumasa iti, sbej ni oj och cuenta jmoctic pero ja' ni oj leetic june ja ma' smojtayotic eq'ue snajtil ja tiempo ja yora tey ja Cajualtic Jesusi. Pero ja' ni oj leexuc ja ma' yila aaji yii ja' yuj ja Juani masan huaj ja ba satq'uinali ba oj ni och testigoil jmoctica jastal quilatic sacui ja Cajualtiqui, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ti stzaahue chahuane, ja juni José Barsabás. Cho aaji sbiiluc Justo, jaxa juni, Matías. ");
INSERT INTO tojNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ti xa och sc'umuque ja Diosa: ―Cajual, huen huaxa naa jastal ay spetzanil ja sc'ujol ja cristiano. Jea quiticon ja chahuane iti ja machunc'a tzaubal ahuuji ");
INSERT INTO tojNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ba oj och jecabanumil. Oj och sloc'ol ja Judas ja ma' mi tz'icui ja yatel yuj ja lom staa ja smuli. Huaj ta ni ja ba lugar jau ba chapubal yii, xchiye ja cuando huane sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ti sc'ulane ripar ja chahuane huinique jahui, jaxa Matiasi, yen co sbaj. Ti xa och cuenta soc ja juluchuane jecabanumi. ");
INSERT INTO tojNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuando jac ja sc'ac'uil ja q'uin Pentecostés sbiil yujilei, spetzanil ja ciento veinte creyente, ti tzomane ba jun cuarto spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iday, jun ta repente yabye jun ruido ja ba satq'uinali, pero tzatz lec jastal huax jac ja bitus ja ba tzatz lequi. Lajan soc ti mero co ja ba yoj naitz ja ba culan ec' ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Huaj to yile, ja ba scuerpoei, lajan soc jastal yat c'ac' ti noc'an sbaje, cada jujunei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jaxa Espíritu Santo ti yiaj majan ja stiei. Huaj to snaa sbaje, och c'umanuque otro abal, pero tuctuquil xta sc'umale huanei, chican jas c'umalil aaji yile yuj ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ja c'ac'u jumasa jahui, ja judio jumasa ti ni huane sq'ueljel ja q'uin ja ba Jerusaleni, jaxa yenlei huax xiuye yuj ja Diosi. Tuctuquil ja lugar ja ba jacyei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jaxa cuando yabye ja ruido jahui, sac ajnel xta ch'ac stzom sbaje. Mi snaa jas oj sc'uluque pensar porque cada jujune huax yabye huane c'umajel soc ja mero yabalei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jel juntiro och ja spensarei. Q'uelan jacane xta aye. Ti yaltalaan sbajea: ―¿Mi ma sbajuque Galilea ja it jumasa huane xta c'umal ba? ");
INSERT INTO tojNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Iday, tuctuquil ja jc'umaltic pijtzi jsatiqui, jaxa huego, pero ¡huax cabtic ja jas huane yaljel tac! ");
INSERT INTO tojNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ja ili ay jaquel ba suinquil Partia, soc cho ay sbaj Media, soc ba Elam soc ba Mesopotamia. Ay suinquil Judea, cho ay ba Capadocia soc ja ba Ponto. Ay ma' jaquel ja ba Asia, ");
INSERT INTO tojNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Soc ba Frigia soc ja ba Panfilia. Ay suinquil Egipto soc ay suinquil ja ba Africa ja tey ba spatic ja Cirene. Soc ay suinquil ja Roma ajyi pero ti xa culane ja huego ja ili. Ja janec' aye ja yenlei, ay ma' mero judio ni manxia, soc ay ma' sc'uan ja jDiostic ja quentic ja janec' judiootiqui. Lajan soc paxye ta judioil ja yenle chomajquili. ");
INSERT INTO tojNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cho ay ma' jaquel ba Creta soc ja ba Arabia pero jpetzaniltic huax c'ulantic entender ja jas huane yaljel que jel bi tzamal ja jas huan sc'ulajel ja Diosi y ¡ja' mismo ja cabaltiqui! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jel juntiro och ja spensarei. Mi snaa jas oj sc'uluque pensar: ―Pero ¿jas sbej ja c'umal iti? xchiye ja jun nolei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jaxa otro c'olei: ―¡Yacbume ja it jumasa! xchiye, pero burla nia. ");
INSERT INTO tojNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Entonces ja Pedro xachachi xta q'ue tec'an. Ti cho ch'ac q'ue tec'an ja otro juluchuane jecabanumi. Entonces ja Pedro ti c'umani tzatz leca: ―Huinique sbaj Judea, apetzanilex ja huenlex ja ma' culanex ja ba Jerusalén, naahuic lec ja iti. Maclayic lec ja jas oj cala huabyexi. ");
INSERT INTO tojNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ja quenticon ja janec' ayticoni, mi xa hualahuex que yacbeloticon porque mi to ni jun parte huala elticona. ");
INSERT INTO tojNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ja jastal it huanex yiljeli, ja' ni ja jas yalunej ja aluman‑Dios Joel ja najatei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ja' bi ja último c'ac'u jumasa jau oj c'ot tic'an ja tiempo, ja Diosi oj bi sec yi ja Yespiritu ja ba spetzanil ja cristiano. Jaxa ma' oj to manxuqui, oj bi c'umanuque yuj ja yip ja Diosi, sea huinic, sea ixuc. Jaxa queremtiqui ay bi jas oj snajsatuque, jaxa ma' viejo xa jel bi jas oj huaychinuque. ");
INSERT INTO tojNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja Diosi oj bi sec yi ja Yespiritu ja ba spetzanil ja ma' huax yatelta, sea huinic, sea ixuc, jaxa yenlei oj bi c'umanuque yuj ja yip ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ja ba satq'uinali oj bi see ja Dios ja jas mi ni nunca huax ilxi, jaxa ba luumi, oj ilxuc seña. Oj bi ilxuc chic' soc c'ac' soc oj but'uc ja tab ja ba satq'uinali. ");
INSERT INTO tojNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ja c'ac'u oj q'uicbuc juntiro, jaxa luna lajan bi soc ja yelau ja chic' oj huajuqui. Ja seña jumasa iti, ja' ni mero seña que oj xa c'otuc ja c'ac'u oj xa jacuc ja Cajualtiqui. Ja c'ac'u jahui mi cualquierauc, jel nihuan juntiro. ");
INSERT INTO tojNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Spetzanil ja ma' huas sc'ana yi ja Cajualtiqui que oj coltajuqui, libre ni bi oj huajuquea. Jach ni yala ja aluman‑Dios Joel ja najate tac. ");
INSERT INTO tojNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Huinique sbaj Israel, maclayic ja jas oj cala huabyex ba. Ja Jesús sbaj Nazaret, jel tzamal juntiro ja jas sc'ulan cuando ti to ay jmoctiqui. Sc'ulan jitzan milagro. Sea lec ja seña ba oja naex que jecubal ni yuj ja Diosi porque Dios ni ja ma' sc'ulan ja milagro jahui. ¡Ja huilahuex nia! ");
INSERT INTO tojNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero iday, cuando aaji ba hua c'abexi mi ni modo huaxa c'ana oja sijpuquex. Ja huaahuex ba oj miljuc yuj ja tantic cristiano jau mi ni t'un huax xiu yuj ja Diosi. Pero como jach ni aya. ¡Jach ni ja spensar ja Dios tac! Huan ni snaa jastal oj ch'ac huajuca. ");
INSERT INTO tojNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eso sí, ja Cajualtiqui cham nia pero cho sacui. Yena ni sc'ulunej ganara. ¡Jastal modo mi oj sac‑huuc porque Dios ni yaa sac'anil tac! ");
INSERT INTO tojNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ja Jesús jahui taaji ni ti' yuj ja rey David ja najate lequi. Oj bi yal jachuc: Ja queni tola vida ni quila ja Cajualtic ja ba jtz'eeli. Huas syama qui ja jc'abi ba mi oj xiucon, ");
INSERT INTO tojNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","jayuj ja caltzili jel ni gusto ajyia, jaxa jas huax el ja ba jtii, puro alegre huax yaa. Anima huax cham ja jcuerpo, pero seguro ayon oj cho sac‑huuc. ");
INSERT INTO tojNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jaxa caltzili mi ni modo oja huaa can ja ba slugar ja chamhuinic jumasaa. Ja queni jel yaj huaxa huabyon. Mi ni oja huaa can ba oj sloo ja yalja ja jcuerpo. ");
INSERT INTO tojNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ja jea qui ja jbej jau ja ba huax yaa vida. Cuando ti xa ayon amoqui, jel gusto oj ajyucon. Jach yala ja Davidi, pero ja' ni ja jas oj to el ja ba sti ja Jesús ja mas tzaani. ");
INSERT INTO tojNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Quermano jumasa, huan nix naatic que cham ni ja rey David ja ma' ec' pax ta cujtiqui. Ti to ni huantic yiljel ja sq'uejnal ja ba mucani. ");
INSERT INTO tojNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ja rey David jahui, aluman‑Dios nia jayuj huas snaa lec que mi mentirauc ja jas alji yab yuj ja Diosi: ―Ay jun ahuintil oj to manxuqui, pero ja' ni ja Cristo. Dioson nia jayuj huax cala huabi, t'ilan ni oj c'ot smeranila. Rey ni oj ajyuca ja huintil jahui como jastal rey ja hueni, x'utji ja David ja najatei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ja Davidi, ja' xa huan yaljel ja jastal oj sac‑huuc ja Cristo, lajan soc ti xa huan yiljela, iday, ay to lec sc'ana oj manxuqui y cho yala que mi ni bi oj canuc ja yaltzil ja ba snajtzil ja chamhuinic jumasa, jaxa scuerpo mi ni bi oj tuubuca. Jach ni yala can ja rey Davidi. ");
INSERT INTO tojNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iday, c'ot ni smeranila. Ja Jesús jahui, aaji ni sac‑huuc yuj ja Diosa. Ja janec' ayticon ja quenticoni, testigooticon nia. ");
INSERT INTO tojNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ti xa aaji yi ja yatel ba mas nihuan yuj ja Diosi soc cho aaji yi ja Espíritu Santo ja jastal alubal ni yab yuj ja Tatal Diosi. Spetzanil ja jas huanex yiljel ja huego soc ja jas huanex yabjeli, como ja Cristo cho seca con ja Yespiritu Santo, soc spetzanil ja yipi. ");
INSERT INTO tojNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porque mi jauc ja rey David q'ue ja ba satq'uinali. Eso sí, ja Davidi yala ni que ja Dios Tatali yal yab ja Cajualtiqui, oj xa caa hui ja hua huatel ja ba mas nihuani, ");
INSERT INTO tojNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Pero oj cho caa hui ba yib ac'ab ja hua condra jumasa, x'utji ja Cajualtic Cristo yuj ja mero Tatali. ");
INSERT INTO tojNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ja quentiqui, israeleñootic. Sbej ni oj naatic que ja Jesús it ahuaahuex ni locan ja ba cruzi, ja' ni ja Cajualtiqui porque jach ni huax yala ja Diosi. Yena ni ja Cristo tzaubal yuj ja Diosi, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuando ch'ac yabye ja cristiano ja jastal iti, jom juntiro ja s'olomei. Ti sobohue yi ja Pedro soc ja otro jecabanum jumasa: ―Quermano jumasa, jaxa huego, ¿jas mas lec oj c'ulticon ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ti yala ja Pedro: ―Aa xa suchuc ja hua c'ujolexi. Iajic xa ja' yuj ja scuentosil ja sbiil ja Jesucristo, ti xa oj bob c'ulajuc perdonar ja hua mulexi, jaxa Diosi oj yaa huilex ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ja iti, mi ni oj ec'uca. Oj ni aajuc ahuilex ja Espíritu Santo soc jach ni ja hua huuntiquilexi. Soc jach ni ja ma' mi jmojuctic judioili, oj ni cho jac soc ja yenle chomajquili. Ja Espíritu Santo parejo ni oj yii spetzanil ja ma' tzaubal yuj ja Cajualtic Diosi, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jel ja jas yala ja Pedro, mi quechanuc ja iti. Jel ja razón yaa yile: ―Colta ja hua hualtzilexi. Pila bajic soc ja jmojtic jel piero ja smodoei, x'utjiye. ");
INSERT INTO tojNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ja mismo c'ac'u jahui, ja ma' smaclaye ja razón jau aaji yilei, ti xa aaji yie ja'. Ja c'ac'u jahui oxe mil cristiano yaa sbaje ja ba sc'ab ja Diosi. Pilan ni ja matic creyente xa ni. ");
INSERT INTO tojNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jaxa ma' yajc'achil sc'uunejei, quechan xta huane smaclajel ja yabal ja Dios ja jastal huax jeeji yile yuj ja jecabanum jumasa. Jel ja sgustoe huas sc'umane ja Diosi. Huas stzomo sbaje ba oj yae ja santa cena. Jel gusto huax yila sbaje juntiro. ");
INSERT INTO tojNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jaxa jecabanum jumasa, jel ja jas sc'ulanei. Jitzan milagro sc'ulane. Jel nihuan ilji ja yip ja Diosi jaxa cristiano, ti ch'ac canuque jacana. ");
INSERT INTO tojNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Spetzanil ja ma' sc'uan ta ja Diosi, jun xta yabale jel jaman ja yaltzilei. Huas sq'uebtalaan sbaje ja jas huas staahuei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xchonohue can ja sastic sbaje, ja jastic yiojei, ti spila sbaje ja stz'acoli, chican jasunc'a ja snesesidaei, cada jujune ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Cada c'ac'u huas stzomo sbaje ja ba templo, jaxa ba yoj snajei huax yaahue ja santa cena sbaj ja Cajualtiqui. Huax cho sloco sbaje huael. Gusto xta huax ajyiye. Jun xta sc'ujole spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jel huas stoyohue ja Diosi y spetzanil ja cristiano yaj huax yabye, jayuj cada c'ac'u ay ma' huan sc'uajel ja Diosi. Jaxa Cajualtiqui lajan xa huax ya och cuenta soc ja matic c'ulaji ta librar soc ja smulei. ");
INSERT INTO tojNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jun c'ac'u ja Pedro soc ja Juani mojan las tres de la tarde ti huajye ba templo. Ja' ni ja ora culan yujile huas sc'umane ja Dios ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Cada c'ac'u ti ni moch'an ec' jun huinic renco, pero yalijel nia. Ti huax iiji och ja ba sti ja templo. Ti huax aaji can ja ba jun puerta ba jel tzamal huax yalahue ja sbiili, ba ti huas sc'ana ja limosna, como ti jel huax och ja cristiano ja ba puerta jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jaxa renco jahui, cuando yila jacum xa ja Pedro soc ja Juani, ti ochume ba templo, ti sc'ana yi limosnaa. ");
INSERT INTO tojNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ja Pedro soc ja Juani yajni yabye que huan sc'anjel limosna, ti stojtosq'uelahuea: ―Q'eulahuoticon, xyutaj ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jaxa huiniqui sacha ja sati. Huax yala que ay jas oj aajuc yi. ");
INSERT INTO tojNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ti yala ja Pedro: ―Ja queni mi ni jun cinco quioj ba oj caa hui pero ja jas quioji oj ni caa huia. Yuj ja sbiil ja Jesucristo ba Nazaret, q'uean xa huego. Bejyan xa. ¡Ja yeni oj yaa yip ja hua huoqui! ");
INSERT INTO tojNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ti yamji yi ja stojol sc'ab yuj ja Pedro. Aaji q'ueuc. Quechan pavor cuando ya q'ue tec'an ja Pedro, staa stzatzal huego ja yoqui. Tzatzbi huego ja stornilloil ja yoqui. ");
INSERT INTO tojNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Entonces jaxa huinic jau renco, quechan jun brinco yaa yi, och bejyuc huego. Ti xa och ja ba templo soc ja Pedro soc ja Juani. Huan xta bejyel och puro brinco yuj ja sgusto. Huan yaajel yi stz'acatal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Spetzanil ja cristiano, yajni yila huan bejyel, ja huinic jahui yabye huan sc'anjel yi stz'acatal ja Diosi, ");
INSERT INTO tojNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jel och juntiro ja spensarei. Jel xiuye juntiro ja yajni yilahue ja jastal iti, como huan ni snaahue sbaj ja huinic jahua. Snaa que yena ni ja ma' huax och culan sc'an ja limosna ja ba spuertail ja templo, ja puerta jau jel tzamal huax yalahuei. ");
INSERT INTO tojNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ja ma' renco ajyi mi ni modo huas sc'ana sijpuc ja Pedro soc ja Juani. Spetzanil ja cristiano sac ajnel xta ch'ac huaj yile ja bay ja yenlei. Jel juntiro ja spensarei. Ti aye ba jun yoj ten, ja' bi ja sten ja Salomoni. ");
INSERT INTO tojNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ja Pedro cuando yila xnololi jan ja cristiano, ti yalaa: ―Huinique jumasa, pero suinquilotic ba Israel. ¿Jasyuj jel huax och ja hua pensarexi? ¿Huan ma xa hualahuex ta quen caticon tojbuc ja huinic iti? ¿Yuj ama huaxa hualahuex ta ay quipticon ba quen oj bob ca bejyucticon ba? ¿Yuj ama huaxa hualahuex que jel huax c'uanticon ja Diosi? ");
INSERT INTO tojNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","¡Mey quip ja quenticoni! Pero ja sDios ja ma' ec' pax ta cujtiqui, ja jastal ja Abrahami soc ja Isaqui, soc ja Jacobi, ja' ni ja jDiostic jahui ya nihuanbuc juntiro ja yunin Jesusi. Pero ja huenlexi ja c'ulanex entregar ba sc'ab ja ma' ay yateli. Jaxa Pilato huas sc'ana nique oj sijpuc nique ajyi pero ja huenlexi mi ni ac'anahuex oj huaj librea. ");
INSERT INTO tojNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ja huinic ja ma' mi ni jun smul ayi, toj ni ay leca, sbej nique oja c'anex oj huajuc libre, pero iday, ja' ac'anahuex ja ma' mero quechan xchol ja milhuaneli. ");
INSERT INTO tojNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jach ni huaahuex miljuc ja ma' huax yaa ja jsac'aniltiqui. Eso sí, cham nia pero ja Diosi cho ya sac‑huuc. Testigooticon ja quenticoni. Quilaticon ni sacuia. ");
INSERT INTO tojNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ja quenticoni, testigooticon nia jayuj cuando huax taaticon ti' ja sbiil ja Jesús jahui, jel ni ja yipa, jayuj ya staa stzatzal ja yoc ja huinic it huaxa huilahuexi. Huan ni xa naahuex lec sbaja. Huax c'uanticon ja yip ja Jesusi, jayuj tojbi ni ja huinic ita. ¡Pero ti ni huanex yiljel tac! ");
INSERT INTO tojNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Quermano jumasa, huan nix naa ja queni. Ja huenlexi soc ja ma' ay yateli, ja milahuex ja Jesusi pero mi ni huaxa naahuex machunc'aa. ");
INSERT INTO tojNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Como jach ni yala ja Dios ja najatei, ja yora yiaj majan ja sti ja yalumani que ja sCristo, jel ni bi t'ilan oj yii ja huocoli. ");
INSERT INTO tojNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jayujil a suchuc ja hua c'ujolexi. Cumxanic soc ja Diosi ba oj ch'ayjuc ja hua mulexi. Jach c'a huaxa c'ulanex, ja Cajualtiqui oj ya jamxuc ja hua hualtzilexi, ");
INSERT INTO tojNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jaxa Diosi oj seca huilex ja Jesucristo. Ja yeni tzaubal ni ba oj ajyuc amoquex. ");
INSERT INTO tojNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero ja huego, t'ilan ti ni oj ajyuc t'an ja ba satq'uinali masan to oj ch'ac stojbes ja jastaltic ay ja Diosi. Jach ni yala cuando yiaj majan ja sti ja yaluman jumasa ja najate lequi. ");
INSERT INTO tojNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ja Moisesi yala ni yab ja smoj jumasa que ja Cajualtic Diosi oj to bi sec yile jun aluman‑Dios pero june ja mero yintilei: ―Ja jastal secahuon ja quen amoquexi, jach oj cho seca huilex otro, xchi ja Moisesi, pero huas sc'ana oja maclayex lec slugaril ja jas oj yala huabyexi, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ja aluman‑Dios jau oj to jecjuqui, ta ay c'a ma' mix yaa caso, oj ni ch'ayjuc snaajelea ja cristiano jumasa jahua. Mi ni bi oj bob aajuc cuenta soc ja mero yuntiquil ja Diosi. Jach ni yala ja Moises tac. ");
INSERT INTO tojNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Y jach ni ch'ac yalea, spetzanil ja aluman‑Dios jumasa. Jach mero q'ue yal bajtan ja Samueli, jach cajcajil ch'ac huajuque. Ja' ni mero huane staajel ti' jastal oj jac ja c'ac'u jau oj ilxuc smeranil ja aluman‑Dios jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Dios ni mismo yiaj majan ja stie ja aluman‑Dios jumasa ja najatei. Ja jas yalahuei ja baj ni ja huenlexa. Q'uelahuil ja ma' ec' pax ta cujtiqui. Ja Abrahami och trato soc ja Diosi. Yala ja Diosi que yuj spetzanil ja yintil ja Abrahami mi ni jun ma' mi oj sc'ul recibir ja sbendicion ja Diosi. Ja jastaltic ch'ac yali, ja' ni ba jbientic ja quentiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Y meran nia, quentic ni mero bajtan jac yilotic ja Jesús cuando huan tox ch'ac ya sac‑huuc ja Dios Tatali. Jac yaa ja sbendicioni cosaque ba cada jujune ja quentiqui oj caatic can ja jmaloiltiqui, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ja Pedro soc ja Juani, cuando huane to loil soc ja cristiano, huaj to yile, jac ja pagre jumasa soc ja sepe ja soldado jumasa ja ba templo, soc ti cho jacye jun partida cristiano saduceo sbiile. ");
INSERT INTO tojNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pero jel xa coraja aye juntiro porque ja Pedro soc ja Juani huane yaljel que meran ni oj sac‑huucotica porque ¿jas to mas? Yilahue ta bi que sacui ta ni ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jayuj ti yiaje och ja ba preso. Slutuhue cani como och ta ni c'ac'ua. Ti ni canye jun acuala. ");
INSERT INTO tojNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero jitzan ja ma' yabye ja jas yalahuei, sc'uane nia. Jaxa ora jahui snolo sbaj mojan joe mil creyente, soc spetzanil ja janec' creyente nii, pero quechan ja huiniquei. Mi och cuenta ja ixuquei. ");
INSERT INTO tojNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jaxa el ja c'ac'u ti stzomo sbaje ba Jerusalén ja matic ay yatel yujile ja judio jumasa. Cho tey ja ma' banquilal yujilei soc ja matic huas sea ja smandar ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ti cho jac ja Anasi ja ma' huas sc'ulan mandar ja pagre jumasai. Cho ti ni ay ja Caifasi soc ja Juani soc ja Alejandro, spetzanil ja yermano jumasa ja pagre jau mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ti secahue spayjel ja Pedro soc ja Juani. Ti yaahue ja ba snalanei. Ti och jobjuc yilea: ―¿Ma' yaa huilex ja atel it huanex sc'ulajeli? ¿Jas sbiil ja ma' yaa huilex ja huatelexi? ");
INSERT INTO tojNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Entonces ja Pedro juntiro ti ni ay soc ja Espíritu Santo, jayuj ti iiji majan ja stia. Ti yalaa: ―Quermano jumasa, ay ni ahuatelex cujticona, jachuc ja huenlex banquilal jumasa ba Israel, ");
INSERT INTO tojNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Lec ja huaxa jobohuex jastal jel tzamal tojbi ja huinic it empedido ajyi. Huaxa c'ana naex jastal tojbi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pues lec, oj cala huabyex satalajel abal ba oj snaa spetzanil ja suinquil ja Israeli. Ja huinic it lec xa ay huax quilatiqui, oj cala huabyex, yuj ja yip ja Jesucristo ba Nazareti jayuj aaji tojbuc. Pero ja huenlexi huaahuex q'ue locan ja ba cruzi. Eso sí, chami pero ja Diosi ya sac‑huuc otro vuelta. ");
INSERT INTO tojNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ja Jesús jahui lajan soc jastal jun syojyal naitz ba mix aaji caso pero iday, ja oy jahui, ja mas tzaani, ja' mero yaa yip ja naitzi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Porque mi ni june ma' oj bob sc'ulucotic librar soc ja jmultiqui. ¿Ba oja taa jun cristiano ja ba mundo iti ba oj bob scoltayotic soc ja jmultiqui? ¡Ja Diosi mi ni ma' yaunej otro, quechan ni yenaa! xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ja matic ay yateli, yajni yilahue jel tzatz ja sti ja Pedro soc ja Juani, mi ni t'un xiuyea, iday, huas snaahue que mi ni ochye escuela ja chahuane huinique jahui ‑ cualquiera cristianoe nia pero soc ja jahui jac sc'ujole que yenle ni ja ma' ajyiye ec' soc ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Cho ti xa ay soque ja ma' empedido ajyi, jayuj juntiro smaca stiei. ");
INSERT INTO tojNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ti alji yab ja Pedro soc ja Juani que oj bi spil sbaje t'usan ja ba yoj junta, jaxa juntaanum jahui ");
INSERT INTO tojNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ti xa och yii yabal sbajea: ―¿Jasunc'a oj c'ultic yi ja tantic huinique iti? xchiye. Spetzanil ja cristiano jumasa ja ba Jerusaleni huan ni snaahue que sc'uluneje ja milagro iti. Mi ni oj bob caltic ta mi meranuca. ");
INSERT INTO tojNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero ba mi oj pucxuc ec' mas ja jas sc'ulanei, la xa jcomtic ba mi ni nunca oj stae ti' mas ja sbiil ja tan Jesús jahui, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ti xa cho spayahue jana. Yaahue yi jun orden que mi ni bi nunca oj c'umanuque eq'ue, oj see ec' ja sbiil ja Jesús jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ti yala ja Pedro soc ja Juani: ―¿Jasunc'a huaxa c'anahuex ba? ¿Mas ma lec oj c'uucaticon ja huenlexi ma mas lec oj c'uucticon ja Diosi? ¿Baya mas lec oj yil ja Dios ba? ");
INSERT INTO tojNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ja quenticoni mi nix bob jmac ja jtiiticon ja jas quilunejticoni soc ja jastic cabunejticoni, xchi ja Pedro soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pero ja matic ay yateli, quechan yalahue ta huan c'a sc'ulane otro vuelta, oj bi aajuc yi castigo. Ti ya huajuque librea. Mi ni bob yae yi castigoa porque spetzanil ja cristiano ma' yilahue jastal huaji huane xta stoyjel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ja huinic ma' tojbi yuj ja smilagro ja Diosi, ay xa yioj mas ja cuarenta jabili. ");
INSERT INTO tojNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ja Pedro soc ja Juani, cuando aaji eluque libre, ti huajye soc ja smoj jumasa. Ti yalahue spetzanil ja jas alji yabye yuj ja nihuac pagre jumasa soc ja banquilal jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Yajni yabye ja jastal ec' yujilei, ti och sc'umuque ja Dios spetzanile: ―Cajual, huena ni mero Diosaticona. Ja c'ulan ja satq'uinali soc ja luumi soc ja mari. Spetzanil ja cosa jas teyi, huena ni ac'ulana. ");
INSERT INTO tojNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ay jas ahuala ja najatei cuando yiaj majan ja sti ja David ja hua Huespiritu Santo: Ja cristiano ja ma' mi judiouqui, huolan ch'etan xta ni oj ajyuque ec'a, jaxa otro c'olei, lomtic xta ay ja spensarei, ");
INSERT INTO tojNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jaxa rey jumasa ba spetzanil ja lugari jel nihuan huax yaa sbaje, jaxa ma' ay yatel yujile ja cristiano jumasa jahui, oj stzom sbaje. Condra ni oj yile ja Cajualtic Diosi soc ja Cristo ja ma' tzaubal yuji. Jach ni huax yala ja hua huabal tac, Cajual. ");
INSERT INTO tojNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Y jach ni c'ot smeranila. Ja ba yoj chonab iti, ja rey Herodesi soc ja Poncio Pilato stzomo sbaje soc ja cristiano ja ma' mi judiouqui soc ja jmojticon israeleñoili. Jach sc'ulane ba nolcondra oj ochuque soc ja hua huunin Jesusi, iday, mi ni xet'an ja smuli. ¡Tzaubal ni ahuuj ja Cristo tac! ");
INSERT INTO tojNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pero como jach ni ahualunej desde najatea, jayuj bob yujile. T'ilan ni jach ec'a. ");
INSERT INTO tojNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ja huego, Cajual, ja huab ja jas yala cabticoni que ay bi jas oj sc'ul quiticon. Pero ahuatjumoticon ni taca. Aa snihuanil jc'ujolticon ba mi oj xiucoticon oj calticon ja hua huabali, ");
INSERT INTO tojNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jaxa hueni, soc spetzanil ja hua huipi a tojbuc ja matic malo ayi. C'ulan ja jas huaxa c'ana ba oj iljuc que meran ja jas huanoticon yaljeli. A chijcajuc jitzan milagro ba oj naajuc que ja hua huunin Jesusi, mi tajneluc ja sbiili porque ja yeni, mi cualquierauc, xchiye cuando huane sc'umajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuando ch'ac sc'umuque ja Diosi, ja lugar ja bayei, nijqui ja luumi pero ja' ni seña que jac ja Espíritu Santo ba tzatz oj ajyuque eq'ue, ti iiji majan ja stiei. Mi ni ay xihuele och yale ec' ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ja jun nole cristiano ja janec' sc'uane ta, jun xta lajan ja jas huas sc'ulane pensari soc jun xta ni yabal ayea. Mi ni june huax yalahue que sbaje stuch'il ja jas yiojei. Spetzanil ja sas sbajei huax yalahue que sbaje lajan. ");
INSERT INTO tojNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jaxa jecabanum jumasa mi nix yaahue can ja yaljel ja jastal yilahue sacui ja Cajualtic Jesusi. Con todo fuerza huane. Yioje juntiro ja slequil sc'ujol ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jaxa creyente jumasa, mi ni jas sc'ulan yile paltaa. Ja ma' ay snaji soc ja ma' ay sluumi xchonohue cani, jaxa stz'acoli ");
INSERT INTO tojNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Ti xa yiaje jan yi ja jecabanum jumasa. Sc'ulane entregar ba sc'abe, jaxa jecabanum jumasa ti spila yi ja ma' ay snesesida. ");
INSERT INTO tojNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jach ni cho sc'ulan jun huinic sbiil José. Ja José jahui, aaji sbiiluc Bernabé yuj ja jecabanum jumasa porque ja yabal ja yenlei jach huax yaa yi sbiil ja ma' jel huax yaa nihuan c'ujoli. Ja Bernabeji ja' to ni yintil ja ma' sbiil Leví ajyi. Ja José Bernabé jahui ti jaquel ba jun ch'in lugari, jaxa lugar jahui joybanubal yuj puro ja', Chipre sbiil. ");
INSERT INTO tojNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ja yeni ay yioj jun pedazo luum. Xchono cani, ti xa yiaj ja stz'acol ja sluum jahui. Jac yaa yi ba sc'ab ja jecabanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Cho ay otro huinic sbiil Ananías, jaxa xcheumi, Safira sbiil. Jach ni, cho xchono jun pedazo sluume. ");
INSERT INTO tojNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ti huaj yaa yi ja jecabanum jumasa ja stz'acoli pero iday, yiaje can snalan ja yenlei. Lajti abal aye xchahuanile. ");
INSERT INTO tojNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Jaxa Pedro ti yalaa: ―Iday, Tata Ananías, ¿jasyuj ahuaa yi lugar ja tan Satanás ba oj ochuc ba hua c'ujoli? Ja jas huaxa huala, ja' ni huana slolajel ja Espíritu Santo porque ahuiaj ni can snalan ja stz'acol ja hua luum hua chono. ");
INSERT INTO tojNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Pe ¿mi ma abajuc ni ja luum ba? Eso sí, ja chono, pero abaj ni ahuen ja stz'acola. ¿Jastal lec ac'ulan pensar oja c'uluc ja jastal iti? Ja hueni, huana ni lolanela, y cho alola ta ja Espíritu Santo, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ja Ananiasi, quechan pavor yab ja jas alji yabi, ti jautz'uji huego man luuma. El huego ja yaltzili. Spetzanil ja ma' yab yabalil jastal huaj ja Ananiasi, jel xiuye juntiro. ");
INSERT INTO tojNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Entonces ti jacye chaboxe queremtica. Sbech'ahue ja scuerpo. Yiaje ba oj huaj smuque cani. ");
INSERT INTO tojNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jaxa ay xa mojan oxe ora, ti cho och c'ot ja xcheum ja Ananiasi, pero mi ni t'un huas snaa ta cham ta ja statami. ");
INSERT INTO tojNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ti sobo ja Pedro: ―Jaxa huen nana, ala cabi, ¿meran ma jach ni ja chonohuex ja luumexi ja jastal ahualahuexi? Ti yala ja yeni: ―Meran, tata, jach ni stz'acol huaja, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ti yala ja Pedro: ―Ja huenlexi ¡lajubal lec ahuujilex! ¿Jas lom huaxa huixtalaanex ja Yespiritu ja Cajualtiqui? Ja hua tatami, huaj ta mucjuc cani. Ja huego cumxume xa jan ja queremtic jahui ba oj cho jac yia och ja huen chomajquili, xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Quechan pavor ch'ac aljuc yabi, cho jautz'uji huego. Ti co baan ba yib yoc ja Pedro. Jaxa yajni ochye c'ot ja queremtic jahui, chamel xa ni ja ixuc staahuea. Ti cho ya eluquea. Huaj smuque can ja ba stz'eel ja statami. ");
INSERT INTO tojNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Spetzanil ja creyente jumasa soc ja ma' ch'ac yab yabalil ja cosa jumasa iti, jel och ja xihuele juntiro. ");
INSERT INTO tojNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jaxa jecabanum jumasa huane xta ni ec' sc'ulajel ja milagro, ja' ni huane seejel yi ja cristiano que jel ja yip ja Jesucristo. Spetzanile huas stzomo sbaje ja ba yoj sten ja Salomón ja c'ac'u jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jaxa ma' mi creyenteuqui mi ni modo huas sc'ana smojuque ja creyente jumasa porque jel xihuel aye, pero ja mero smeranili jel yaj huax abjiye. ");
INSERT INTO tojNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero c'ot ja c'ac'u, jel juntiro ja ma' sc'uan ja Cajualtiqui, ixuque soc huinique. ");
INSERT INTO tojNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ja' ni ti c'ot ja ora ja ma' malo ayi, ti aaji el jan ja ba yoj snaji. Ti lichji ja suaynub ja ba sti ja beji ja ba mojan oj ec'uc ja Pedro cosaque anima quechanuc ja yaxubil ja Pedro oj ec'uc ja ba baan ec' june ja chamum jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jach ni ja yal hacienda jumasa ja ba mojan yioj ja Jerusaleni. Tzalali xta ch'ac huajuque ja cristiano jumasa. Ch'ac yie och ja ma' malo ay yujilei soc ja ma' ixtalanubal yuj ja pucuji, iday, tojbi spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Entonces ja pagre mas nihuani soc ja jun c'ole huinique saduceo sbiil, yamigo ni sbaje ja yenlea, pero toj envidioso ja sc'ujolei. ");
INSERT INTO tojNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jayuj ti syamahue ja Pedro soc ja Juani. Xch'icahue preso ja ba yoj chonabi. ");
INSERT INTO tojNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero yajni och ja acuali, jun yangel ja Cajualtiqui sama ja spuertail ja preso. Ti ya eluquea. Ti yalaa: ");
INSERT INTO tojNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Caxic xa. Ochanic ja ba templo. Alahuic yab ja cristiano jastal ay ja yajc'achil vida iti, xchi ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yajni yabye ja jastal alji yabyei, quechan el ja c'ac'u, ti huajye ba templo. Ti huane seejel yi ja cristiano. Cuando ti huane seejel ja ba templo, jaxa pagre mas nihuani soc ja smoj jumasa ti yaahue juntaa. Ti ch'ac c'otuque ja banquilal jumasa ja ba Israeli. Entonces ti xa secahue spayjel ja chahuane jecabanum jau ja ma' huas snaahue que slutuneje preso. ");
INSERT INTO tojNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero cuando c'ot ja ba preso ja policía jumasa, mi xa ni ti ayuquea. Ti xa cumxiyea. Huaj yale que mi xa ni teyuc ja presoanum jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","―Pero ja preso, lutan ni leca. Ja soldado jumasa ti ni huane stalnajel ja ba puerta pero yajni jamaticon, huaj quilticon, mi xa ni mach aya, xchi ja policía jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jaxa pagre mas nihuaqui soc ja sepeil ja policía ba templo soc ja nihuac spagreilei ti yalahuea: ―¿Yuj ama jel nihuan ja jas oj cho bob sc'uluque ja it jumasa ba? xchiye. ");
INSERT INTO tojNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jaxa mero ora jahui, huaj to yile, c'ot jun huinic, ti yalaa: ―Ja huinique jumasa jau ja lutuhuex preso, ¡ti xa aye ba templo soc ja cristiano! ¡Ti xa cho huane seejel c'ota! xchiye. ");
INSERT INTO tojNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Entonces ja sepeil ja policía ba templo soc ja policía jumasa ti cho huaj yie jana, pero mi yixtalaane jani. Xihuel xihuel aye porque repente bi oj ch'ojuque ton yuj ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cuando julyei, ti yaahue endregal ja ba sat ja juntaanumi. Ti yala ja pagre mas nihuani: ");
INSERT INTO tojNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―¿Mi ma calaticon ahuabyex que mi xa lom xa taahuex ti' ja sbiil ja tan huinic jahui? Iday, ¡mi ni huaxa huabyexa! ¡Ch'ac ta puquex ec' ja ba spetzanil ja Jerusaleni! y huaxa c'anahuex que quen oj cuchticon ja jastal cham ja tan huinic jahui, xchi ja pagre mas nihuani. ");
INSERT INTO tojNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ti sac'ahue ja Pedro soc ja smoj jecabanumili: ―Pero meran, sbej ni oj c'uuctic bajtan ja Diosi, tzaan ni oj c'uuctic ja yabal ja cristiano yen. ");
INSERT INTO tojNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ja sDios huas sc'uan ja ma' ec' pax ta cujtiqui, yena ni ya sac‑huuc ja Jesusa, pero ja Jesusi, huenlex ni amilahuexa. Ti ahuaahuex q'ue locan ba cruz. ");
INSERT INTO tojNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero ja Diosi, ja huego yaunej yi ja atel ba mas nihuan que spetzanil. Yen aaji och mero jepeil. Ay xa yip ba oj sc'ulotic librar ja quentic ja janec' israeleñootiqui. Huax yaa huilex tiempo ba oj suchuc ja hua c'ujolexi porque ja yeni, puesto ay ba oj sc'uluquex perdonar. ");
INSERT INTO tojNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Quilunejticon ja smeranili. Testigooticon. Ja Espíritu Santo huan nix yila que meran nia, como ja Diosi huan nix yaa yi ja Espíritu Santo ja ma' huas sc'uan ja yabali, xchi ja Pedro soc ja smoj jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cuando ch'ac yabye ja jastal iti, juntiro q'ue ja scorajaei. Huas sc'ana oj smile. ");
INSERT INTO tojNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ja janec' ay ja yenle ay yatele, tey jun huinic fariseo, Gamaliel sbiil. Ja yeni huas sea ja smandar ja Moisesi, jaxa cristiano, respetado ay yujile ja huinic jahui. Jaxa yeni xachachi xta q'ue tec'an. Sc'ulan mandar que oj bi el t'an jutz'in ba fuera ja chahuane jecabanum jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yajni yila el ele ja Pedro soc ja Juani, ti yal yab ja ma' ay yateli: ―Puro israeleñootic, quermano jumasa. Aa cuidadoex ja jas huaxa c'ana c'uluquex yi ja huinique iti. ");
INSERT INTO tojNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Naahuic t'usan ja tiempo jau ja ajyi jun Teudas jel stoyo sbaji. Ay xa t'un c'ac'u jahui, pero ja tan huinic jahui staa smoj como cuatrociento huinique. Pero iday, ja mas tzaani, milji, jaxa smoj jumasa xaan tican huaj eq'ue. Jach ch'ac huajuque ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ti ec' mas tiempo, ja mero yora q'ue ja censo iday, huaj to cabtic, jitzan ma' xch'icunej sbaj soc ja tan Judas jau ba Galilea. Jach ni, cho milji ja yen chomajquili, jaxa ma' ti ni ay soqui, ch'ac huajuque ec' lomtic. ");
INSERT INTO tojNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jayujil, actayic ja huinique jumasa iti. Mi xa ch'ica bajex soc ja yenlei. Ja cosa iti, ta ja c'a sbaj cristiano, oj lamxuque jachuc. ");
INSERT INTO tojNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero ta ja c'a sbaj ja Diosi, ja huenlexi mi oj bob ach'ayex ja yatelei. Aa cuidadoex. Moc ochanic pleito soc ja Diosi, xchi ja Gamalieli. ");
INSERT INTO tojNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ti yala ja ma' ay yateli: ―¡Meran ni maa! La' xa cactatic can ja tantic huinique it jumasa, xyutaj sbaje ja ma' ay yateli. Ti xa huaj yie jan ja chahuane jecabanum jahui. Yaahue yi lec chicota, cho yaahue yi jun orden mi xa bi oj to stae ti' mas ja sbiil ja Jesusi. Ti xa ya huajuque librea. ");
INSERT INTO tojNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jaxa chahuane jecabanumi ti elye ba sc'ab ja ma' ay yateli, pero gusto xta aye. Stz'acatal bi ja Diosi, huane bi yiijel huocol yuj ja sbiil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Y mi nix yaahue cana. Huane ni seejel eq'ue. Ja' ni mero toj sloile ec'a Jesucristo tola vida. Jach huane lec ja ba templo soc ja ba naitzaltiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ja c'ac'u jumasa jahui, mas to huane sc'uajel ja Dios ja cristiano jumasa. Ay jun c'ole ja ma' huax c'umani griego, jaxa otro jun c'olei, ja' huax c'umaniye hebreo. Jaxa ma' huax c'umaniye griego ti ochye parte soc ja jecabanum jumasa, ti yalahuea: ―Pero ja svigudae ja jun c'ole jahui, tola vida mas ni huax yiaje ja suaelea, jaxa jvigudaticon ja quenticoni, jel t'usan huax aaji yile ja suaelei, xchiye. ");
INSERT INTO tojNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jaxa lajchahuane jecabanum jahui ti stzomo sbaje soc spetzanil ja creyente jumasa. Ti yalahuea: ―Pero quermano jumasa, mi sbejuc quen oj pilticon ja suael ja jvigudatiqui, jaxa yabal ja Diosi, ¿oj ma caaticon can jun lado ba? ");
INSERT INTO tojNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","¿Jaxa mi xa leahuex juque huinic ja janec' ayexi ba oj spil ja huaelali? Tzaahuic ja ma' lec huaxa huilahuex ja smodo soc ja ma' vivo t'usani soc ja ma' tzatz ay soc ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ja quenticoni oj ni jc'ulticon seguir oj c'umticon ja Diosi, oj cho jeeticon ja yabali, xchi ja lajchahue jecabanum jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jaxa creyente jumasa jun xta lajan jel lec yabye ja jas alji yabyei. Ti stzaahue ja Estebana. Ja yeni huas sc'uan ja Dios soc spetzanil ja sc'ujoli. Yaunej sbaj juntiro soc ja Espíritu Santo. Ti cho stzaahue ja Felipe soc ja Prócoro soc ja Nicanori, soc ja ma' sbiil Timoni, soc ja Parmenasi, soc ja Nicolás it sbaj Antioquía. Ja Nicolasi, ay xa tiempo tey soc ja sreligión ja judio jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ti xa yiaje jan ja huinique jumasa jau ja ba sti sat ja jecabanum jumasa, jaxa jecabanumi ti sc'umane ja Diosi. Ya cajan ja sc'abe ja ba s'olome ja jucuane huinique tzaubal yujilei. ");
INSERT INTO tojNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jaxa yabal ja Diosi ch'ac pucxuc eq'ue. Jel juntiro ja ma' sc'uan ja ba Jerusaleni, hasta ja pagre jumasa, jitzan ja ma' sc'uan ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ja Estebani jel yaj juntiro huax yab ja cristiano. Como jel ni tzatz ay soc ja Diosi jayuj jel ja jas bob sc'uluqui. Ilji claro que jel ja yip ja Diosi soc ja milagro sc'ulan ja ora jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero ja ba yiglesia ja judio jumasa, ay jun c'ole huax yaa sbiiluc Mozo Libre ja yiglesiaei. Ja yenlei ay ma' jac ba Cirene, soc ja ba Alejandría, soc ja ba Cilicia soc ja ba Asia. Ti stzaa sbaje jun nole, ti huaj ochuque c'umal soc ja Estebani. ");
INSERT INTO tojNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero lom ni huajye c'umala. Ja Estebani, jel nihuan juntiro ja jas huax yala porque huax iiji majan ja sti yuj ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ti sleahue ma' oj stupe ba oj ochuque testigoili siquiera ba oj yale que jel piero ja jas huan yaljel ja Estebani. Oj bi yale que jel piero huas staa ti' ja Moisesi soc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Soc ja jastal jahui, ch'ac q'ue ja scoraja spetzanil ja cristiano soc ja banquilal jumasa soc ja ma' huas seahue ja smandar ja Moisesi. Ti huaj slee ja Estebani. Syamahue. Ti yiaje och ja ba sti sat spetzanil ja ma' ay yatel. ");
INSERT INTO tojNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ti c'umani och ja ma' yaa sbaj oj och testigo palsoili: ―Ja huinic iti tola vida mi alben ja jas huan yaljel sbaj ja jsanto templotiqui, jaxa smandar ja Moisesi, mi ni t'usan huas sc'ulan casoa. ");
INSERT INTO tojNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Cabticon yala que ja tan Jesús jau ba Nazareti oj bi xch'ay snaajel ja jtemplotiqui. Oj bi cho jch'aytic ja jcostumbretic yaa can quitic ja Moisesi, xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jaxa matic ay yateli soc spetzanil ja ma' ti culan ec' ja tihui, ti stojtoq'uelahue lec ja Estebani pero ja sati jach huaj jastal sat jun ángel. ");
INSERT INTO tojNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Entonces ja pagre mas nihuani ti och sob yi ja Estebani: ―¿Meran ama jach huana yaljel ja huen ba? ");
INSERT INTO tojNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ti yala ja Estebani: ―Tatjun jumasa, quermano jumasa, maclayic ja jas oj cala huabyexi. Ja najate lequi ja quintiltic Abrahami cuando ti to culan ja ba Mesopotamia ‑ mi tox huaj ja ba Harán ja ora jahui ‑ ja jDiostic sbaj ja lugar jau ba jel xlijpi ti jac see sbaj yi ja Abrahami. ");
INSERT INTO tojNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ti yalaa: Abraham, huax c'ana oja huaa can ja hua lugari soc spetzanil ja hua huermano jumasa. Oj jea hui ja lugar ba oj ajyan culani, x'utji ja Abraham yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jayuj ja Abrahami ti xa el ja ba Mesopotamia ja ba slugar ja caldeño jumasa. Ti huaj culan t'usan tiempo ja ba Harani jaxa mas tzaani, cuando ch'ac chamuc ja stat ja Abrahami, ti xa cho yiaj jan ja Dios ja ba jlugartiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero ja Dios ja ora jahui, mi to ya sbajuc ja lugar iti, mi ni ba oj ajyuc tec'ani. Pero alji ni yab ja Abrahami que oj ni sbajuc ja mas tzaani jaxa cuando huax chami, oj ni bi sbajuc can spetzanil ja yintil oj to manxuqui, iday, ja ora alji yab ja iti, mi to ni jun yunin yioj. ");
INSERT INTO tojNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Pero anima, ja Diosi cho staa ti' jastal oj huajuc ba otro lugar ja yintili, jaxa ba luum jahui, puro bi polestero oj ec'uque ja tihui. Oj bi aaji ochuque mozoil. Cuatrociento bi jabil oj ixtalajuque lec. ");
INSERT INTO tojNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero mix cham ac'ujol Abraham, xchi ja Diosi. ¡A smajlaye ja cristiano jau oj yixtalauc ja hua huintil jumasa porque t'ilan ni oj couc ja scastigoei! Cuando huax jelxiye juntiro ja scondraei, ti xa oj eluque ja ba lugar jahua, ti oj xa ni jacuque culan ja ba lugar iti ja hua huintil jumasa. Ti xa oj yateltayonea, x'utji ja Abraham yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ja Diosi ti sc'ulan jun trato soc ja Abrahami jaxa ba seña ja trato jahui, ja Abrahami oj bi sc'ul circuncidar cada yal querem huax manxi jayuj yajni manxi ja yunin Isaqui, cuando ay xa yioj huaxaque c'ac'u, ti c'ulaji circuncidara. Jach lamlamil ch'ac huajuque. Jach sc'ulan ja Isaac soc ja yunin Jacobi, jaxa Jacobi, jach ni cho sc'ulan soc ja yuntiquil ja yeni, como lajchahuane aye. Jayuj man ora ayotic lajchahue c'ole ja ba Israeli. Lamlamil quiajtic can ja sbiil ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pero ja lajchahuane yuntiquil ja Jacobi, ja ma' mero ijtz'inali, José nia. Jel coraja ilji yuj ja sbanquil jumasa, jayuj xchonohue ja Josei, jaxa ma' smana, suinquil ni ja Egipto. Pero ja Diosi ti ni ajyi soc ja José ja ba Egipto. ");
INSERT INTO tojNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Coltaji lec ja ba yojol ja suocoli. Jel vivo huaji, jayuj jel ni lec ilji yuj ja rey Faraón ba Egipto. Ja mas tzaani, aaji ba sc'ab ja José ba oj sc'ul mandar ja ba Egipto, jaxa ba yoj snaj ja reyi, yena ni mero huas sc'ulan mandar ja José jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ec' ja tiempo, ti jac jun nihuan huaina. Jel tzatz huaj ja huocol ja ba Egipto soc jach ni ja il ba jlugartiqui. Jel yiaje huain ja quintiltiqui. Huocol juntiro staa ja jas oj yabyei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero ja viejito Jacobi cuando yab yabalil que ay to bi trigo ja ba Egipto, jayuj ti seca ja yuntiquili. Jayuj ti huajye ja mero primero vuelta ja ba Egipto ja quintiltiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jaxa ba xchabil vuelta huajyei, ti chicnaji lec que ja' ni yijtz'ine ja Josei, hasta ja rey Faraoni snaa sbaj ja sbanquil jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ja Josei ti xa seca spayjel ja stati soc spetzanil ja yermano jumasa. Oj bi jacuque culan ja ba Egipto, jaxa yenlei aye xa setenta cinco ja janec' puro yermano sbajei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jayuj ti huaj culan ba Egipto ja viejito Jacobi. Ti cham ja tihui, jach ni spetzanil ja yuntiquil jumasa ja matic ec' pax ta cujtiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jaxa mas tzaani ti xa yiaje jan ja sbaquele ja matic ch'ac ta cham yujilei jayuj ti xa mucane ba Siquem ja ba q'ueen smana can ja Abraham ja najatei. Jaxa q'ueen jahui, ja' ni sbaj ajyi ja yuntiquil jun huinic sbiil Hamor sbaj Siquem, pero ja luumi, yena ni smana ja Abrahami. ");
INSERT INTO tojNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jaxa quintiltic ja yora ti to ajyiye ba Egipto huane pojxel, huane pojxel, pero huan xa mojxel ja tiempo oj c'ot smeranil ja jas alji yab ja Abrahami, que oj ni sbajuque ja lugar iti: Como Dioson nia, oj ni c'ot smeranil ja jas huax cala, xchi nia. ");
INSERT INTO tojNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","C'ot ja c'ac'u, ti och jun yajc'achil rey ja ba Egipto, jaxa yeni, mi xa ni snaa sbaj ja chamhuinic Josei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ja rey jahui mero lolanum. Yixtalaan lec ja ma' ec' pax ta cujtiqui hasta yaa jun orden que cuando huax manxi ja yal alatz ta querem c'a, oj bi jipjuc ele, siquiera oj chamuc spetzanile. ");
INSERT INTO tojNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ja tiempo jahui, ja' ni ja yora manxi ja Moisesi pero jun yal alatz jel lec huax ilji yuj ja Diosi. Ja snan stati oxe ixau snac'ahue juntiro ja ba snajei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero c'ot ja c'ac'u cuando mi xax bob nacxuc yujile ja ba snajei. Ti huaj yae cana, iday, ja ma' stulu, ja' ni ja yunin ixuc ja rey Faraoni. Ti ya q'uiuc como jastal mero ja yali. ");
INSERT INTO tojNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jayuj ja Moisesi aaji och escuela. Sneba spetzanil ja jas huas snaahue ja suinquil ja Egipto. Jel vivo huaji. Huas snaa jastal oj c'umanuc soc jel tzatz ja yateli. ");
INSERT INTO tojNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Cuando ay xa yioj cuarenta jabil ja Moisesi, ti jac ja sgana oj huaj soc ja ma' jun ta razail ay soqui, ja' ni ja jmojtic israeleñoili. ");
INSERT INTO tojNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Cuando ti xa ay soc ja smoj jumasai, ti yila ja ma' mero srazail ba Israeli huan ixtalajel lec yuj june ja suinquil ja Egipto. Ja Moisesi ti huaj scoltaa, iday, smila ni el juntiro ja egipciano jahui. Como huax yala ta huan c'a bi smila ele, ti bi oj stup ja smuli. ");
INSERT INTO tojNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Huax yala ja Moisesi que ja smoj israeleñoili, seguro oj snaa que c'ot ta ni ja ora oj aaji eluque libre yuj ja Diosi, que yena ni bi ja Moisesi oj coltanuc, pero mi jach sc'ulane entender ja yenlei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jaxa ba xchabil c'ac'u, ja Moisesi ti cho yila huane c'umal chahuane ja smoj israeleñoili. Ti huaja ba oj ya culan yi ja sc'ujole ja pleitoanumi, ti yalaa: Ja huenlexi jun xta hua razailexi. Mi ni sbejuc coraja huaxa huila bajex ja huenlex mismo, xyutaj. ");
INSERT INTO tojNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jaxa jun ma' jel piero ja smodo soc ja smoji, ti huaj sutbuc ja Moisesi: ¿Yuj ama ay ahuatel huaxa huala? ¿Ma juez ja hueni? ¡Mi ahuochelucoticon! ");
INSERT INTO tojNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Yuj ama huaxa c'ana oja milon ja quen ja jastal amila ja tan egipciano ja eque ba? xchi ja pleitoanumi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Yajni yab ja Moisés ja jastal iti, ti el ajnela. Ti huaj ba jun lugar Madián sbiil. Ti ajyi culan ja tihui. Ajyi como polestero. Ti manxi chab yuntiquil ja tihui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ti cho ec' otro cuarenta jabila. Jun c'ac'u ja Moisesi tey ba jun ch'ayan lugar mojan ja ba huitz sbiil Sinaí. Huaj to yile, ti huan ajlel jun q'uiix ja ba stz'eeli. Ja ba yoj c'ac' jahui, ti c'umani jan ja yangel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Jaxa Moisesi jel och ja spensar ja yila ja jastal huan ajlel ja c'aq'ui pero och och mas c'uban ja ba stz'eel ja c'ac' jahui ba oj yil lec. Ti yab ja sc'umal ja Cajualtiqui: ");
INSERT INTO tojNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Quen sDioson ja ma' ec' pax ta huujili. SDioson ja Abrahami soc ja Isaqui soc ja Jacobi, xchi ja Cajualtiqui. Ja Moisesi ti och q'uitc'onuc yuj ja xihueli. Mi xax yaa sbaj oj sq'uel mas. ");
INSERT INTO tojNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jaxa Cajualtiqui ti yalaa: Sopo el ja hua xanabi porque ja ba tec'ana eq'ue, mi cualquiera luumuc. ");
INSERT INTO tojNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja queni quilunej ja suocol ja cuntiquil tey ba Egipto. Cabunej lec jastal huax och mebaoc'uque, jayuj coyon jani ba oj huaj c'uluque librar, jayuj ja hueni, oj xa jeca ba Egipto, x'utji ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Eso sí, ja Moisesi mix yaahue caso ajyi. Huax yalahue sbaj que mey yatel, mi bi juezuc ja yeni. Pero ja huego aaji ni yatel yuj ja Diosi ba oj huaj sc'ul librar ja jmojtic israeleñoili, pero ja' ni mojtanubal yuj ja ángel ja ma' sea sbaj yi ba yoj yajlel ja q'uiix ja c'ac'u jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja' ni ja Moisés ja ma' ya el libre ba Egipto ja quintiltic ja najatei. Sc'ulan jitzan milagro. Soc ja jas jel nihuan sc'ulani, ilji ja yip ja Dios ja ba lugar jahui. Sea lec ja yip ja ba Mar Rojo, jach ni ja ba ch'ayan lugari. Yilahue ni cuarenta jabil ja yip ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yena ni mismo Moisés ja ma' yal yab ja jmojtic israeleñoili que oj to bi sec june ja aluman‑Diosi pero ti ni ba yintil ja yenlei. Yala ni ja Moisesi: Ja jastal secahuon ja quen ja Diosi, jach oj cho sec ja yaluman jahui, pero a sc'ul caso ja jas oj aljuc yab ja ma' sac'an ja tiempo huax jac ja yeni, xchi ja Moisesi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ja Moisesi yena ni ajyi ec' soc ja cristiano ja ba ch'ayan lugar jahui. Ti ni jac soc ja ángel ja ba huitz Sinaí, yena ni ja ángel jau sc'uman ja Moisesi. Ja Moisesi ja' ni cho smojan ec' ja ma' ec' pax ta cujtiqui. Ja yeni aaji yi ja mandar it huax yaa jsac'aniltiqui jayuj lamlamil huax naatic ja mandar jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pero ja ma' ec' pax ta cujtiqui mi sc'ana oj sc'uuque ja jas huax yala ja Moisesi. Mix yaahue caso. Ti huas sc'ana oj cumxuque ja ba Egipto. Jex oc' sc'ujole juntiro ja jas ay ba Egipto. ");
INSERT INTO tojNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jayuj ti yalahue yab ja Aarón ja yermano ja Moisesi: Huax c'anaticon ta ay modo oja c'uluc chaboxe ja jdiostiqui cosaque ti oj caatic ja ba sti jsatiqui porque ja Moisés it ya elcotic jan ja ba Egipto, mi na' bay ec'a, xchi ja cristiano. ");
INSERT INTO tojNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Entonces ti och sc'uluque ja sdiosei, jaxa sdiose jahui, jach sc'ulane jastal ja splanta ja yal becerro. Ti cho och smile ja chante jumasa ba oj yaa yi smajtan ja sdiosei. Ti xa och q'ueuc ja sq'uine yuj ja sgustoe soc ja sdiose ch'ac sc'uluquei. ");
INSERT INTO tojNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ja yila jas huane ja cristiano jumasa iti, ja Diosi ti xa yaa can jun ladoa. Sipa can sc'ujol ba oj sdiosuc ja jastic huax yilahue ja ba satq'uinali, como jach ni tz'ijbanubal ja ba slibro ja aluman‑Dios jumasa: Ja huenlex suinquil ba Israel, ja cuarenta jabil ti ajyiyex ja ba ch'ayan lugar jahui, ¿huan ma xa hualahuex yuj ja hua milahuex ja chante jumasa, ¿quen ama huaxa huaahuex qui ja huaxa hualahuexi? ");
INSERT INTO tojNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pero miyuc. Ja' la c'uchuchiyex ec' soc ja snicho ja hua dios Moloquexi iday, ja huenlex ita ni ac'ulunejexa. Ja huaahuex ta och diosil ja c'anali, Renfán sbiil ahuujilexi. ¡Majlayic, ti oja huilex ta mi oj xa ca elanic ja ba hua lugarexi! ¡Ti oj poctzuquex masan ba Babilonia! xchi ja ba slibro ja aluman‑Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ja ba ch'ayan lugari ja ma' ec' pax ta cujtiqui ay yioje ja stemplo ja Diosi, ja' ni ja templo jau puro c'uutz c'ulubal soc. Ti nolan yujile ja ton jau ja ba tz'ijbanubal ja smandar ja Moisés ac'ubal yi yuj ja Diosi. Ja templo jahui jach ni c'ulubal ja jastal ni alji yab ja Moisesi. Oj bi sc'uluc ja jastal ja splanta jeeji yi yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ja mismo templo jau c'ulubal ni soc c'uutzi, lamlamil can ba sc'ab ja ma' ec' pax ta cujtiqui. Entonces ja ma' jac soc ja Josuei ti ni yioje jana. Ti ni yioje cuando sbajane can ja jlugartiqui porque ja tiempo jahui, ti to ay ba sc'ab ja tzeil cristiano ja lugar iti. Pero ja Diosi sapa yile ja luumi ba oj sbajuque ja quintiltic ja quentiqui. Ja templo jau c'ulubal soc c'uutzi maconi yujile lec masan to och reyil ja Davidi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jaxa rey Davidi jel lec ilji yuj ja Diosi jayuj ja yen, jel ja sgana oj sc'ul yi jun snaj ba oj jac culan ja jDiostiqui, ja' ni ja mismo sDios ja cham Jacobi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero mi bob yuj ja rey Davidi. Ja yunin Salomoni, yena ni sc'ulan ja snaj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero ja mero smeranili, ja Dios jel nihuani mi ni modo oj jac culan juntiro ba jun templo c'ulubal yuj cristiano. Jach ni yala ja aluman‑Diosi: ");
INSERT INTO tojNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ja ba satq'uinali ti ni huax c'ulan mandara, jaxa ba luumi, quechan ba huala bejyiyon eq'ue. ¿Jas tiq'ue naitzil oja c'uluquex quii? xchi ja Cajualtiqui. Ja queni mi ni huax c'ulan necesitar ba oj jijlucona. ");
INSERT INTO tojNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Mi ma quenuc ni jc'ulan spetzanil ja cosa jas ay ja il ba? Jach ni xchi ja ba slibro ja aluman‑Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Meran nia, jel ch'uuy ja sc'ujol ja ma' ec' pax ta cujtiqui pero jach ni ja huenlex chomajquili. ¡Jel ch'uuyex juntiro! Lajanex soc ja ma' mi huas sc'uan ja Diosi. Huax jac sc'umuquex ja Espíritu Santo pe ¡ba oja huaex yi caso! ");
INSERT INTO tojNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ja ma' ec' pax ta cujtiqui, mi ni siquiera june ja aluman‑Dios ba mi yixtalaane. Cuando mi tox jac ja ma' jel ni toji, ja aluman‑Dios jumasa huan nix yalahue que oj ni jacuca pero iday, ja' ni yuj miljiye ni yuj ja jas huane yaljeli. Jaxa huego jac nia pero cho huiajex ni spatica. ¡Ja milahuex nia! ");
INSERT INTO tojNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iday, ¡ay ni ahuiojex ja smandar ja Diosi! Ti ni ay ba hua c'abexa ‑ ángel ja ma' yaa huilex ja mandari pero iday, ¡mi ni t'un huaxa c'uanex ja mandar jahui! xchi ja Estebani. ");
INSERT INTO tojNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cuando yabye ja jas ch'ac yal ja Estebani, ti xa q'ue juntiro ja scorajaei. Xbatbuniye xta eq'ue. ");
INSERT INTO tojNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ja Estebani, como juntiro yaunej sbaj soc ja Espíritu Santo, ti sq'uela q'ue ja satq'uinali. Huaj to yile, ti huan lijpel ja Diosi, jaxa Jesusi ti yila tec'an ec' ja ba lado stojol sc'ab ja Dios Tatali. ");
INSERT INTO tojNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ti yala ja Estebani: ―Q'uelahuilex, ja satq'uinali jaman ni huax quilaa. Tey ja ma' co jan ja ba luumi, ti xa tec'an ec' ba lado stojol sc'ab ja Dios Tatali, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero ja yenlei ch'ac smac ja xchiquinei. Och ch'eljuque ahuanel. Ti jacye botz'an sbaj ja Estebani. ");
INSERT INTO tojNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ti squichahue ja ba sti ja chonabi. Ti och xch'oje tona. Jaxa ma' och testigoil ja ora jahui ti soptalaan ja sc'uei, ti yaahue can talnuman ja sc'uei, jaxa ma' huan stalnajeli, jun soltero sbiil Saulo. ");
INSERT INTO tojNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ja Estebani, cuando huan coel sbaj ja toni, ti och sc'umuc ja Diosi: ―Cajual Jesús, iaj xa qui ja caltzili, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ti co mec'ana. Ahuani tzatz lec: ―Cajual, moc hua scuche can ja smule ja it jumasa, xchi. Yajni ch'ac yal ja jastal iti, ti xa chama. ");
INSERT INTO tojNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jaxa Saulo ja it ma' stalna ja c'uutz ja yora milji ja Estebani, lajti abal ni ay yujilea. Ja c'ac'u ja yora smilahue ja Estebani, ja' ni mero c'ac'u q'ue jun nihuan suocole spetzanil ja creyente ja ba Jerusaleni. Ch'ac nutzjuque ele. Xaan tican ch'ac huajuque ec' ja ba sutanal ja Judea soc ja ba Samaria. Quechan xta ti ch'ac canuque ja lajchahuane jecabanumi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pero ay chaboxe ja ma' jel xiuye yuj ja Diosi. Yenle ni smucuhue ja Estebani. Jel ni ocye juntiroa. ");
INSERT INTO tojNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jaxa ora jahui ja Sauloi ti och yixtalauc lec ja creyente jumasa, pero chol yiaj ec' ja naitzaltiqui. Quichubal huax ya eluc ja suinquil ja naitzi, sea huinic, sea ixuc. Ti huax ch'ac huaj xch'ictalauc can ja ba yoj preso. ");
INSERT INTO tojNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jaxa matic nutzji el ja ba Jerusaleni, ti huaj spuque ec' ja yabal ja Diosi, chican ba lado aye ec'a. ");
INSERT INTO tojNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","June ja yenlei, Felipe sbiil, ti huaj ba jun chonab ba Samaria. Ti och sloilta ec' ja Jesusi, que yena ni bi ja Cristoa. ");
INSERT INTO tojNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jaxa samariteño jumasa huego stzomo sbaje ba oj smaclaye ja jas huan yaljel ja Felipe, pero soc spetzanil ja sc'ujole huane smaclajeli, cho yilahue ja milagro huan sc'ulajeli. Ti jac sc'ujolea que ja' yip ja Dios ja jas huan sc'ulajeli. ");
INSERT INTO tojNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jel jitzan ja ma' ixtalanubal yuj ja pucuji aaji eluque libre ja ora jahui. Ja pucuji cuando huax el ja ba jun cristiano ti huax och ahuanuque tzatz leca. Jel ja ma' tulido ay soc ay ma' renco ay, ch'ac tojbuque ja c'ac'u jumasa jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jaxa suinquil ja lugar Samaria jel gusto ch'ac huajuque. ");
INSERT INTO tojNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero tey jun huinic, Simón sbiil. Ja mero xcholi huax ajnani eq'ue pero jel juntiro huas slola ja suinquil ja lugar jahui. Xiubal yuj ja samariteño jumasa. Jel huas stoyo sbaj juntiro ja Simón jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jaxa cristiano jel huas sc'uane ja huinic jahui, sea viejo, sea yal untic: ―Ja huinic iti, jel vivo. Jel tz'ican ja sentido ac'ubal yi yuj ja Diosi. Jach huax yalahue sbaj ja ajnanum jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Jel huas sc'uane porque ay xa lec tiempo huax ajnajiye yuj pero iday, huane lolajel lec yuj ja tan ajnanum jahui. Jel vivo juntiro soc ja smaloili. ");
INSERT INTO tojNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero yajni yabye ja jas huax yala ja Felipe que sbej huax yaa sbaje ja ba yib sc'ab ja Diosi, sbej bi oj syajtaye ja sbiil ja Jesucristo, entonces ja cristiano ti xa aaji yie jaa con todo ixuque, huinique. ");
INSERT INTO tojNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jaxa Simón jahui, ja ora jahui, cho sc'uan ni ja yen chomajquila. Cuando ch'ac aajuc yi ja', ti cho huaj nochan soc ja Felipe. Yajni yila ja milagro jumasa, jel och ja spensari ja yila ja jas jel nihuan huan sc'ulajel ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jaxa jecabanum jumasa ti canele ba Jerusaleni, cuando yabye yabalil huane xa sc'uajel ja yabal ja Dios ja samariteño jumasa, ti xa secahue och ja Pedro soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cuando c'otye ja ba Samaria, ti och sc'ane yi ja Diosi ba oj aajuc yile ja Espíritu Santo ja ma' ajc'ach huan ochel creyenteili, ");
INSERT INTO tojNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque mi to ni june ja yenle coel sbaj ja Espíritu ja ora jahui. Quechan yioneje xa ja' yuj ja sbiil ja Cajualtic Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ja Pedro soc ja Juani ti ya cajan ja sc'abe ja ba s'olom ja yenlei, ti xa co sbaje ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ja Simoni, cuando yila quechan huax ya cajan ja sc'ab ja jecabanum jumasa huax co jan ja Espíritu Santo, ti sc'apa yi taq'uin ja Pedro soc ja Juani. ");
INSERT INTO tojNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ti yalaa: ―Jel lec ta huaxa huaa qui quip ja jastal jau ja queni cosaque chican ma' oj ca cajan ja jc'ab ja ba s'olomei, oj ni co jan soque ja Espíritu Santo. Oj ni caa hui hua taq'uinexa, xchi ja Simoni. ");
INSERT INTO tojNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ti yala ja Pedro: ―¡Ta huan c'a sc'ana ja Diosi, oj ya ch'ayuc anaajel soc ja hua taq'uini! ¿Huan ma xa huala ta oj bob aman soc taq'uin ja jas huax yaa ja Diosi? ");
INSERT INTO tojNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ja hueni, ja atel iti, mi ni abajuca porque mi tojuc ay ja hua c'ujol ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","¡A ch'ay ac'ujol ja hua maloil jahui! C'uman ja Diosi. Bob ta oj sc'uluc perdonar spetzanil ja malo tey ba hua c'ujoli ");
INSERT INTO tojNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porque huax quilahua que toj piero juntiro ja hua pensari. Ja hua muli, lajan soc yuch'ana yuj te'. ");
INSERT INTO tojNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ti yala ja Simoni: ―¡Moc ma sc'an ja Diosi! Mas lec c'umanic ja Diosi ba mi oj co ja jcastigo, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ja Pedro soc ja Juani soc ja Felipe, cuando ch'ac sloiltaye ja yabal ja Cajualtiqui, ch'ac yale spetzanil ja jas yilunejei, ti cho yiaj ja sbejei ba oj cumxuque ja ba Jerusaleni, jaxa spetzanil ja yal lugar ja ba ch'ac ec'uquei, ti huax huaj xchole ec' ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Cuando ti xa aye ba Jerusaleni, jun yangel ja Cajualtiqui ti yal yab ja Felipe: ―Felipe, chapa baj. Cax ba Gaza. Ti xa huiaj ja bej jau huax ec' ja ba ch'ayan lugari, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Yajni yab ja it ja Felipe, ti xa xchapa sbaja. Huaji, jaxa ba beji ti staa jun huinic, suinquil ja Etiopía. Ja huinic jahui ac'ubal ba sc'ab jun nihuan atel yuj ja reina Candace ba Etiopía. Tey ba sc'ab spetzanil ja sastic sbaji. Jaxa ora jahui, cumxel jan ja ba Jerusaleni. Ti huaj ba Jerusalén ba oj huajuc ja ba stemplo ja Dios sac'ani. Jaxa cuando taaji bej yuj ja Felipe, ti ni culan ec' ja ba scarreta huan sq'ueljel ja slibro ja aluman‑Dios Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ja Espíritu Santo ti yal yab ja Felipe: ―Jitzan oche ja ba stz'eel ja carreta jahui, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Cuando ti xa ay ba stz'eel ja Felipe, ti yab que huan sc'umajel ja slibro ja aluman‑Dios Isaiasi: ―¿Huan ma xa huab sbej ja jas huana sq'ueljeli? xchi ja Felipe. ");
INSERT INTO tojNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ti yala ja huinic jahui: ―Miyuc, como mi ni ma' huas sea qui. ¿Mi ma xa c'ana oj q'uean jmoc ja ba jcarreta? xchi ja huiniqui. Ti xa q'ue ja Felipe. Ochye culan lajan. ");
INSERT INTO tojNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ja yabal ja Diosi ja ba huan sq'ueljel ja huiniqui jach huax yala ja jastal iti: Oj miljuc jastal jun chej. Jastal jun chej cuando huan joxjel ja sc'ui mi ni huax ahuania, jach ja yen chomajquili. Mi ni jun palabra oj sam ja stii. ");
INSERT INTO tojNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jel oj c'ulajuc yi burla pero iday, mi ni ay smula oj yaahue yi castigo. Mi alben ja jas oj c'ulajuc yi yuj ja jun lame cristiano jahui. Oj ni smile ela, xchi ja ba slibro ja Isaiasi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ja huinic jau ay yateli ti sobo yi ja Felipe: ―Ala cabi, ¿machunc'a huan staajel ti' ja aluman‑Diosi? ¿Yen ta ma huaxa yala sbaj, ma pilan ma' huan staajel ti'? xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Entonces ja Felipe ti xa och ya q'ueuc ja sloil ja ba sq'uela ta ni ja suun ja aluman‑Diosi. Tacal tacal slea modo jastal oj xchol yab ja jastal ec' ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Cuando yioje xa beji, ti ecye ba mojan sti jun ja'. Ti yala ja huiniqui: ―Ja ili ay ja'. ¿Mi ma oj bob oj xa quii ja'? ");
INSERT INTO tojNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","―Huan c'a xa c'uan soc spetzanil ja hua c'ujoli oj bobuc, xchi ja Felipe. Ti yala ja huiniqui: ―Huan. Huax c'uan. Ja Jesucristo, huax naa que yunin Dios nia, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ti xa ya tec'an can ja scarreta. Ti cooye xchahuanile ja ba yoj jai. Ja Felipe ti ya yii ja' ja huinic jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cuando elye ja ba sti jai, huaj to yil ja huiniqui, meyuc ja Felipe. Iiji yuj ja Yespiritu ja Cajualtiqui. Mi ni yila ba huaja, pero cho stulu ja sbeji. Gusto ni huaja. ");
INSERT INTO tojNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jaxa Felipe, huaj to snaa sbaj, ti xa ay ba jun yal hacienda Azoto sbiil. Chol yiaj ja yal hacienda jumasa. Huan sloiltajel ec' ja yabal ja Diosi. Ti c'ot ba jun chonab sbiil Cesarea. ");
INSERT INTO tojNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ja tiempo jumasa jahui, ja Saulo jel coraja ay juntiro. Huan xta yaljel ec' que mas lec oj ch'ac chamuc spetzanil ja ma' huas sc'uan ja Cajualtiqui, jayuj ti huaj soc ja pagre mas nihuani ");
INSERT INTO tojNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ba oj sc'an yi jun juun. Oj xa bi huajuc ja ba Damasco, jaxa juuni oj bi yaa yi ja ma' ay yatel ja ba yiglesia ja judio jumasa. Huan c'a bi staa ja ma' huan ochel soc ja tan yajc'achil religión iti, oj bi squich och ja ba Jerusaleni, sea ixuque, sea huinique. ");
INSERT INTO tojNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ja Saulo cuando mojan xa oj c'otuc ja ba Damasco, huaj to yile, jun ta repente lijpi jun luz ja ba satq'uinali. Ti co ja mero bayi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Jaxa Saulo man luum co baan. Ti yab jun c'umala: ―Saulo, Saulo, ¿jas lom jel huaxa huixtalaanoni? xchi ja c'umal jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","―Pero ¿mach aya ba Cajual? xchi ja Saulo. ―¡Quena ni Jesuson tac! Quena ni huaxa huixtalaanon ec'a. Pero ja hueni lajana soc ja c'ac'al toro cuando mi to c'ajyeluc soc ja sni cubo. Huen ta ni huaxa yajbes abaj atuch'ila. ");
INSERT INTO tojNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jaxa Saulo och q'uitc'onuc yuj ja xihueli. Ti yalaa: ―Pero Cajual, ¿jasunc'a huaxa c'ana oj c'uluc ba? Ti yala ja Cajualtiqui: ―Q'uean xa huego. Cax ja ba yoj chonabi. Cuando ti xa aya ja tihui, ti oj aljuc ahuab jasunc'a oja c'uluqui, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jaxa huinique jau smoj ja Saulo, jel xiuye juntiro. Mix bob el sc'umale. Eso sí, mi ni ma' yilahuea pero yabye ja c'umali. ");
INSERT INTO tojNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jaxa Saulo ti xa stulu sbaj ja ba luumi, iday, huaj spitz ja sati, mi ni modo xbob ilhuanuca, jayuj ti xa chechji och ja ba yojol ja chonab Damascoi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxe c'ac'u mi ni bob ilhuanuca. Ja oxe c'ac'u jahui mi ni xe'n jas yaba soc mi ni t'un ja' yuaj. ");
INSERT INTO tojNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ja ba Damasco ti culan jun creyente, Ananías sbiil. Jun c'ac'u ja Ananiasi ti snajsatin ja Cajualtiqui: ―Ananías, xchi ja Cajualtiqui. Jaxa Ananías: ―It bayon jula Cajual, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ti yala ja Cajualtiqui: ―Q'uelahuil. Cax ja ba calle jau toj xta huax huaji. Cuando huaxa taa ba snaj ja Judasi, ti xa jobo yabalil jun huinic sbaj Tarso, Saulo sbiil. Ja yeni huan xa ni sc'umanona. ");
INSERT INTO tojNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Snajsatina ta ja hueni hasta huas snaa jasunc'a abiili. Yila que ochya ja ba yoj naitzi ti hua cajan ja hua c'ab ja ba s'olomi ba oj bob cho ilhuanuc otro vuelta, x'utji ja Ananiasi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Cuando yab ja jastal it ja Ananiasi, ti yalaa: ―Cajual, pero jel cabunej yabalil ja huinic jau ja jas huas sc'ulan yi ja ma' huas sc'uan ja ba Jerusaleni. Toj bi malo ja sc'ujoli. ");
INSERT INTO tojNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jaxa huego ti xa ay ja ili. Elel yuj jun juun ba oj bob syam spetzanil ja ma' huan xa sc'uana ja hueni. Ac'ubal yi yuj ja pagre ja mero mas nihuani, xchi ja Ananiasi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ti yala ja Cajualtiqui: ―Jach ni mero smodo ajyia pero ja huego, mi xa jachucuc. Cax huego porque ja huinic jahui tzaubal xa ni cuja. Oj huaj sloilta ec' ja cabali. Oj sloilta yab ja tzeil cristiano soc ja ma' ay yatel yujilei soc jach ni ja hua moj israeleñoili. Oj ya nihuanbuc lec ja jbiili. ");
INSERT INTO tojNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pero oj ni yii lec ja huocola. Sbej ni oj snaa ja ita, x'utji ja Ananiasi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ja Ananiasi ti xa huaj ja ba naitz bay ja Saulo. Ti ocha. Ti huaj ya cajan ja sc'ab ja ba s'olomi. Ti yalaa: ―Hermano Saulo, ja Cajualtic Jesusi, yena ni sea sbaj ahui ja yora ti jacuma ba beji jaxa queni jecubalon ahui ba oj bob ahuil q'uinal otro vuelta. Oj bi couc abaj con todo yip ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jaxa ch'ac yal jachuc ja Ananiasi, huego huego ch'ay ja jas tey ba yoj sat ja Saulo. Bob yil q'uinal huego. Ti xachachi xta q'ue tec'an huego. Ti xa c'ulaji bautizara. ");
INSERT INTO tojNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jaxa yajni ch'ac ta yii jai, ti xa och huauca. Ti cujlaji lec ja sc'ujola. Ja Saulo ti can soc chaboxe c'ac'u ja creyente jumasa ba Damasco. ");
INSERT INTO tojNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ja Saulo ti xa huaj ja ba yiglesia ja judio jumasa. Ti yalaa: ―Ja Jesusi ja' ni mero yunin Diosa, xchi nia. ");
INSERT INTO tojNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jaxa spetzanil ja matic ch'ac yab ja jas huan yaljel ja Saulo, jel och juntiro ja spensarei: ―Pero ¿mi ma yenuc ja huinic it huan yixtalajel ec' ajyi ja tantic creyente jumasa tey ba Jerusalén ba? Quechan bi ja huax yab huas staahue ti' ja sbiil ja tan Jesús jahui, jel huax q'ue ja scoraja. ¡Pe jayuj jac ja il tac! Oj bi yie och ja ba sc'ab ja pagre mas nihuaqui. ¡Yuch'ubal bi spetzanile oj yie oche! xchiye xta. ");
INSERT INTO tojNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ja Saulo mas to con gana och yal que yena ni meran ja Cristo ja Jesusi, jaxa judio jumasa ba Damasco mi snaa jas oj sc'uluque pensar porque jel bi tzatz juntiro ja sti ja Saulo. ");
INSERT INTO tojNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jaxa ec' jitzan c'ac'u, ja judio jumasa ti och slaje lec que oj bi smile. ");
INSERT INTO tojNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero ja Saulo yab que huan chapjel yabalil. Ja judio jumasa c'ac'u acual ti huas smacahue bej ja ba sti ja chonabi ba oj bob smile. ");
INSERT INTO tojNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ja chonab jahui macan sutanal soc cimiento, pero chaan lec, jayuj ja creyente jumasa ti sleahue jun nihuan mooch ba acual oj ya couque ja Saulo. Jach el libre ja ba sc'ab ja smoj judioili. ");
INSERT INTO tojNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ja Saulo cuando ti c'ot ja ba Jerusaleni, huas slea modo jastal oj bob och loil soc ja creyente jumasa pero ja yenlei jel huane xihuel. Huax yalahue que mi meran creyenteuc. ");
INSERT INTO tojNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero ja Bernabeji ti huaj soc ja Saulo ba oj snaa sbaje soc ja jecabanum jumasa. Ti och xchol jastal yilunej ja Cajualtic ja Saulo ja ba beji. C'umaji bi yuj ja mero Cajualtiqui jayuj cuando ti ajyi ba Damasco mi ni bi t'un xiu ja cuando staa ti' ja sbiil ja Jesusi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jayuj ja Saulo yamigoan ja smoj creyenteili. Ti ajyi ec' soc ja jecabanum jumasa ja ba Jerusaleni. ");
INSERT INTO tojNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Huax och loil soc ja smoj judioili ja ma' huax c'umaniye griego pero ja' ni huan staajel ti' ja Cajualtiqui, pero mi ni t'un huax xiu ja huan yaljeli. Pero ja yenlei, xuoljiye xta huax q'ueye. Huas sleahue modo jastal oj bob smile. ");
INSERT INTO tojNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Pero ja ma' creyente xa ni ayi, yermano xa ni sbaje soc ja Saulo, yajni c'ot xchiquine ja jastal jahui, ti huaj yale yab ja Saulo que mas bi lec oj huajuc ja ba Tarso, jayuj ti huaj ya eluque can ja ba Cesarea. ");
INSERT INTO tojNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ja creyente jumasa ja ma' huas stzomo sbaje ba cada iglesia ba Judea soc ja ba Galilea soc ja ba Samaria, lamxi t'usan ja suocole ja tiempo jahui. Huane ni xihuel yuj ja Cajualtiqui. Ay snihuanil sc'ujole yuj ja Espíritu Santo. Tola vida ay ma' huan sc'uajel yajc'achil ja yabal ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ja Pedro chol ni huax huaj ec' ja ba yal hacienda jumasa ba huan yulatajel ec' ja creyente jumasa. Ti c'ot ja ba jun yal hacienda Lida sbiil ");
INSERT INTO tojNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Jaxa tihui ti staa jun huinic Eneas sbiil. Ay xa huaxaque jabil staunej xch'at porque ja yoc sc'abi mi ni modo huax bob snica. ");
INSERT INTO tojNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jayuj ja Pedro ti yal yaba: ―Eneas, ja Jesucristo oj ni ya tojbana. Q'uean huego. Tulu xa hua huaynubi, xchi. Jaxa Eneasi ti q'ue huegoa. ");
INSERT INTO tojNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ja suinquil ja Lida soc ja Saroni yilahue que tojbi ja huinic jahui, jayuj ti xa yaahue can ja jas huas sc'uane ba poco. Ti xa suchi ja sc'ujole soc ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ja tiempo jahui tey jun ixuc creyente ja ba jun chonab Jope sbiil. Tabita sbiil ja ixuc jahui pero ja ma' huax c'umani griego, Dorcas huax el ja sbiili. Ja yeni jel lec ja sc'ujoli. Huas scolta ja ma' mi jas yioji. Tola vida jach ni huas sc'ulana. ");
INSERT INTO tojNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ja c'ac'u jumasa jahui, ja Dorcasi yamji chamel. Chami, jaxa scuerpo ti stojbesea. Ti huaj yae can ja scuerpo ba jun cuarto ba xchabil piso. ");
INSERT INTO tojNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ja chonab Jope, mojan yioj sbaj soc ja yal hacienda Lida ja bay ja Pedro ja ora jahui. Jaxa creyente jumasa ba Jope yabye yabalil que tey mojan ja Pedro jayuj ti secahue chab huinica ba oj huaj yie jan ja Pedro. Ti yalahue yaba: ―A ta mi bi oja c'ul pavor oj huajan jmocticon mas ligero. Jach alji cabticon ja quenticoni, xyutaje ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ja Pedro ti huaj soc ja huinique jahui. Ja c'otyei, ti yiaje q'ue ja ba cuarto ja bay ja scuerpo ja chamhuiniqui. Ja viguda jumasa ti ch'ac jacuque parte soc ja Pedro. Jel huax ocye, ti och seetalauque ja sc'uei, jaxa Dorcas, yen bi ch'ac stz'is can ja sc'ue ja viguda jumasa jau ja yora sac'an to. ");
INSERT INTO tojNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Entonces ja Pedro ti sc'ana yi pavor que oj eluque ja cristiano jumasa jahui. Ti co mec'ana. Och sc'umuc ja Diosi. Ti stojtoq'uela lec ja ixuc jau chamel xa: ―Tabita, q'uean xa, xchi. Entonces ja Tabita spitza huego ja sati. Cuando yila ja Pedro, ti q'ue culana. ");
INSERT INTO tojNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ja Pedro ti syama yi ja sc'abi. Ya q'ue tec'an. Spaya huego ja creyente jumasa soc ja viguda jumasa: ―Quermano jumasa, q'uelahuilex. Ja quermanatic Tabita, sacui ta, xchi. ");
INSERT INTO tojNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ja jastal sacui ja Tabita, huego huego ch'ac yabye yabalil ja suinquil ja Jope, jaxa cristiano jumasa, jel ja ma' sc'uan ja Cajualtiqui. ");
INSERT INTO tojNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ja Pedro ti albi t'usan ja ba chonab jahui. Ti jijlel ba snaj jun huinic Simón sbiil. Ja yeni huas sc'ulan curtir ja tz'uumi. ");
INSERT INTO tojNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ja ba chonab Cesarea tey jun huinic Cornelio sbiil, jaxa huinic jahui capitán ay. Huan ni sc'ulan mandar jun nole soldado. Ja yenlei aaji sbiiluque Italianos, como ti ni jaquele ja ba lugar Italia ja soldado jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jaxa Cornelio soc ja xcheumi, yuntiquili, huan ni xiuye yuj ja Diosa. Huan ni sc'uanea. Tola vida huas sq'ueba ja staq'uin ba oj scolta ja cristiano ja ma' ay snesesida. Huas sc'umane ja Dios ja ba yoj snajei. ");
INSERT INTO tojNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pero jun c'ac'u mojan las tres de la tarde ja Cornelio ti snajsatin jun yangel ja Diosi. Yila juntiro ti och ja bay ja yeni. Ti alji yaba: ―Cornelio, x'utji. ");
INSERT INTO tojNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jaxa Cornelio ti och stojtoq'uel lec ja angeli, pero huan lec xihuel: ―¿Jasunc'a Cajual? xchi. Ti yala ja angeli: ―Ja jastal huaxa c'umanex ja Diosi, jaxa jastal huaxa colta ja ma' jel ajul ja sbajei, jel bi lec huax yila ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jayujil jeca chaboxe huinique ba oj huaj spay jan ja Simón ja ma' huax cho alji yab Pedroili. ");
INSERT INTO tojNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ti ni jijlela ba snaj jun curtidor Simón ni sbiil ja yen chomajquili. Ja snaji tey ba sti ja jai. Ja Simón Pedro jahui oj yala huab jasunc'a mas lec oja c'uluc, x'utji ja Cornelio yuj ja angeli. ");
INSERT INTO tojNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cuando huaj ja ángel ja it jac c'umanuqui, ja Cornelio ti spaya chabe ja smozo soc jun soldado ja ma' huax cho xiu yuj ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ti ch'ac yal spetzanil ja jastal yila ja angeli. Ti seca ja huinique jau ja ba Jope. ");
INSERT INTO tojNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Jaxa ba xchabil c'ac'u bej xa ay ja huinique jahui. Oj xa c'otuque ja ba Jope mojan xa culan c'ac'u. Jaxa Pedro ti q'ue ja ba s'olom ja naitzi porque ja tihui, jel tzamal lajan. Ti huaj ba oj bob sc'umuc ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pero jel huain xyabi. Huas sc'ana nique oj huauc pero cuando huan tojbesjel ja suaeli, huaj to yile, ");
INSERT INTO tojNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lajan soc jamxi juntiro ja satq'uinali. Ti yila co jan jun nihuan sábana ja ba luumi, mochan xchanil ja xchiquini. ");
INSERT INTO tojNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ja ba yojol ja sábana jahui tey spetzanil ja chante chane yoc sc'abi soc ja chante xbitz'ilji ec' ja ba luumi, soc ja chante ay suech'i. ");
INSERT INTO tojNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ti yab jun c'umala: ―Q'uean Pedro. Mila. C'uxan, xchi ja c'umal jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","―Miyuc Cajual porque mi jcostumbreuc huax c'uxu jun cosa quistal ¡como huan nix naa que mi jach huax yala ja hua mandar tac! xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ti cho ajyi otro vuelta ja c'umali: ―Ja jas huax yala que lec sc'uxjel ja Diosi, mi xa huala ta quistaluc. ");
INSERT INTO tojNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jach alji yab oxe vuelta. Ti xa cho q'ue q'ue ja ba satq'uinal ja sábana jahui soc spetzanil ja chante jumasa. ");
INSERT INTO tojNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ja Pedro ti can tz'uyana: ―¿Jas sbej ja it ba? xchi. Huaj to yabi, ti xa aye ba puerta ja secabanum ja Cornelio. Jobjob yabalil xta huane jan bay ja snaj ja Simón jahui. ");
INSERT INTO tojNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jayujil cuando c'otye ja ba puerta, ti c'umaniye tzatz leca. Sobohue ta ti smajunej naitz jun huinic sbiil Simón ja ma' huax cho alji sbaj Pedroili. ");
INSERT INTO tojNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pero ja Pedro huan to sc'ulajel pensar ja jas snajsatini. Ti alji yab yuj ja Espíritu Santo: ―Huana leejel yuj oxhuane huinique. ");
INSERT INTO tojNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tulu xa baj. Coan. Cax soc ja yenlei pero moc lom jas oja c'ul pensar porque quena ni jecunej jan ahuia, xchi ja Espíritu Santo. ");
INSERT INTO tojNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jaxa Pedro ti co ja bay ja huinique secunej ja Cornelio. Ti yalaa: ―Quena ni huaxa leahuonex ec'a. ¿Jas jac ac'uluquex ba? ");
INSERT INTO tojNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ti yala ja yenlei: ―Yen secahuoticon ja capitán Cornelio. Ja yeni huax xiu yuj ja Diosi. Jel lec juntiro ja sc'ujoli. Jel yaj huax abji yuj ja judio jumasa. Jel ni huax c'anjia. Pero jun yangel ja Diosi alji yab que oj bi spaya, jayuj oj bi huajan ja ba snaji, jaxa yeni oj bi smacla ja jas oja hual yabi, x'utji ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jaxa Pedro yajni yab ja jastal iti, ti xa ya och och ja huinique jumasa jau ja ba yoj naitzi. Ti canye lajan ja acual jahui. Jaxa el ja c'ac'u ja Pedro ti huaj soc ja yenlei. Ti cho huajye nochan chaboxe creyente ja ma' culan ba Jope. ");
INSERT INTO tojNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jaxa xchabil c'ac'u ti c'otye ba Cesarea ja ba huane majlajel yuj ja Cornelio. Tey soc ja yermano jumasa soc chaboxe ja yamigo ja ma' jel ni lec huax yila sbaj soqui, como sloconej ni jana. ");
INSERT INTO tojNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuando c'ot ja Pedro ja ba naitz jahui, ti el jan ja Cornelio. Jaxa ba sti sat ja Pedro, ti co mec'ana lajan soc ja jastal huax co mec'an ja ba sti sat ja Diosi. ");
INSERT INTO tojNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ja Pedro ti sachaa, ti yalaa: ―¡Q'uean! ¡Cristianoon ja queni jastal cristianoa huen tac! xchi ja Pedro. ");
INSERT INTO tojNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ti xa ochye loila. Ti ochye och ja ba yoj naitzi. Huaj to yil ja Pedro soc ja smoj jumasa, jel aay ja cristiano ti tzomanei. ");
INSERT INTO tojNT_vpl VALUES ("AC10_