﻿USE sofia;
DROP TABLE IF EXISTS sofia.tof_vpl;
CREATE TABLE tof_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tof_vpl WRITE;
INSERT INTO tof_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ngaen bwób zitüldü, God tüp akó pülpül tónzapónórr. ");
INSERT INTO tof_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tüpan obzeksyók ugón tómbapónóm yarilürr: darrü kla babulan yarilürr. Tümüna kukurru malubarr nae tumum ngalaorr. Da Godón Samua nae kwitana zaorrón tótók yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Da God bóktanórr wagó, “Zyón asi ki yarilün,” da zyón asi yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","God igó ngakanórr wa, zyón morroala. God zyón a tümün we nürrgrratórr. ");
INSERT INTO tof_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Wa zyón ngi ngyesilürr “ngürr”, akó wa tümün ngi ngyesilürr “irrüb”. Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene ngaen-gógópan ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","God wagó, “Ngarkwat kan asi ki yarilün nae aodó, da wa nae ki arrgrrat naedógab, nis bainüm.” ");
INSERT INTO tof_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Da God ene ngarkwat kan inzan we tónggapónórr, da wa ene kan tüpana nae we arrgrratórr kwitana naedógab. Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God ene ngarkwat kan ngi ngyesilürr “pülpül”. Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene nis ngim ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","God akó bóktanórr wagó, “Pülpül tüpana naea darrpan pokodó ki kwób basu, da mólóg bwóba ki okaka tibyó.” Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Wa ene mólóg bwób ngi we ngyesilürr “tüp”, a kwób basurrün nae ngi we ngyesilürr “malu”. God esenórr wa, morroala. ");
INSERT INTO tof_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","God bóktanórr wagó, “Tüpa elklaza zid ki dódórr nyónünüm: kari küppükü elklaza zid akó küppükü nugup ngórr ini tüpdü, blaman tibiób darrpan tonarr obzekpükü.” Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tüpa elklaza zid we dódórr nyónónóp: küppükü nugup zid tibiób darrpan tonarr obzekpükü, akó küppükü nugup ngórr tibiób darrpan tonarr obzekpükü. God esenórr wa, blaman kla morroalako. ");
INSERT INTO tof_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene aüd ngim ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","God akó bóktanórr wagó, “Zyón kla asi ki kwarilün pülpüldü, ngürr arrgrratóm irrübdügab. Timam ki koralón, ngürr, pail, a tóre melpal bómzyatóm. ");
INSERT INTO tof_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ini zyón kla ki koralón pülpüldü, tüp warri apónóm.” Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God wirri zyón kla nis tónzapónórr - wirrian zyón kla, ngürr angomólóm, kari zyón kla, irrüb angomólóm. Wa akó wimurr tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God ibü blaman pülpüldü we irrbünürr, tüp warri apónóm, ");
INSERT INTO tof_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ngürr akó irrüb ngakanóm akó zyón arrgrratóm tümündügab. God esenórr wa, morroala. ");
INSERT INTO tof_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene tokom ngim ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","God bóktanórr wagó, “Blaman naea ki murrbausnüm abün ngón aman elklaza-e, akó póyaea tüp kwitüdü ki barrmulülün pülpül tüpana.” ");
INSERT INTO tof_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Da God maludü wirri balóng wapi we tómbapónórr, akó blaman ngón aman akó ngübyón elklaza, nae ne klamanme barümürrüna, tibiób darrpan tonarr obzekpükü, akó blaman tappükü póyae ta inzan, tibiób darrpan tonarr obzekpükü. Da God esenórr wa, morroala. ");
INSERT INTO tof_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God ibü bles ninóp da bóktanórr wagó, “E küppükü abün bailamke. E malu nae gwarrónamke, akó póyaea ta tüpdü abün ki bainünüm.” ");
INSERT INTO tof_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene 5 ngim ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","God akó bóktanórr wagó, “Tüpa ngón aman elklaza ki balngó, tibiób darrpan tonarr obzekpükü: ngabyón lar, ngübyón elklaza, akó nurr lar, tibiób darrpan tonarr obzekpükü.” Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God tómbapónórr nurr lar tibiób darrpan tonarr obzekpükü, akó ngabyón lar tibiób darrpan tonarr obzekpükü, akó tüpdü ngübyón elklaza tibiób darrpan tonarr obzekpükü. Da God esenórr wa, morroala. ");
INSERT INTO tof_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Da God bóktanórr wagó, “Mi kya pam tómbapónónóm, mibiób dandangzan, mibü obzeksyók ngarkwatódó. I sab ibü ki balngomól kwarilün, maludü wapi, kwitüm póyae, ngabyón lar, dudu ini bwób, akó blaman tüpdü ngübyón elklaza.” ");
INSERT INTO tof_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","God pam tónggapónórr, tóba dandang ngarkwatódó, Godón dandang ngarkwatódó wa oya tónggapónórr; wa ibü igó tónzapónórr, pam a kol. ");
INSERT INTO tof_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Wa ibü bles nyónürr, da ibüka we bóktanórr wagó, “E küppükü namülamke, akó sab abün bailamke, tüpa tai ki gwarran yabübókamde, da tüp idódlamke yabü tangdó. E maludü wapi sab balngomólólamke, akó kwitüm póyae, akó blaman elklaza, ne klama agóltagóldako ini tüpdü.” ");
INSERT INTO tof_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Da God bóktanórr wagó, “Turrkrruam, ka yabü alióndóla blaman kari küppükü elklaza zid ini dudu tüpdü akó blaman küppükü nugup ngórr. Sab yabü alo kla kwarile. ");
INSERT INTO tof_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Blaman pórngaepükü zid, ka ibü alióndóla alom, blaman nurr lar ini tüpdü, blaman kwitüm póyae, akó ne klama ngübyóndako tüpdü - blaman ngón aman elklaza.” Da ene amkoman inzan we yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God blaman elklaza nósenóp, wa ne kla tómbapónórr, da módóga, blaman amkoman morroal kwarilürr. Da irrüba wamórr akó irrbia tamórr akó wamórr. Ene 6 ngim ngürr yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Tüp a pülpül tómbapóna inzan blakónórr, akó blaman elklaza, ne kla koralórr ibü kugupidü. ");
INSERT INTO tof_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","7 Ngim ngürr nóma semrranórr, Godón zaget ugón blakórrón yarilürr, wa ne kla tómbapón yarilürr. Da ene ngürr, wa ngón ngagónórr tóba blaman zagetódógab, wa ne kla tómbapón yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God 7 ngim ngürr bles yónürr, da tebe-tebe amaikürr, zitülkus wa ene ngürrdü ngón ngagónórr tóba blaman zagetódógab, wa ne kla tómbapón yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Tüp a pülpül tónggapón póepa ae blakónda. ⌊Lod⌋ God tüp a pülpül nóma tónzapónórr, ugón ");
INSERT INTO tof_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tüpdü elklaza zid babul kwarilürr akó küpa koke bamkenóp, zitülkus Lod God darrü ngup koke zirrsapónórr tüpdü. Akó pam babul yarilürr tüp kesu angónóm. ");
INSERT INTO tof_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Nae godeata tüpdügab tumkulnóp, da i blaman tumum tüp nangnóp. ");
INSERT INTO tof_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Da Lod God tüp buru-i pam we tónggapónórr, da wa arról ngón we semanórr oya syók tótórr nisdü. Ene pam ama arról pamakanóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Lod God didiburr we irtümülürr Iden bwóbdü, abüsa nólgabi banikda, da ne pam tónggapónórr ola ingrinürr. ");
INSERT INTO tof_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Da Lod God abün-abün obzek nugup dódórr ninóp tüpdügab, morroal ne kla koralórr basenóm akó alom. Didiburr aodó nis nugup namülnürri, ⌊ngarkwat-koke arról⌋ gail nugup asi yarilürr, akó umul gail nugup asi yarilürr, morroal a kolae nega. ");
INSERT INTO tof_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tobarra Iden bwóbdügab olmealórr ene didiburr nae angóm, da didiburr kalkuma, tokom il we bangónórr. ");
INSERT INTO tof_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ngaen-gógópan tobarr ngi módóga, Pison; wa blaman Abila kantrri myangrao apónda, ⌊gold⌋ nólamase. ");
INSERT INTO tof_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Ene kantrrian gold morroala, akó morroal ilang móeg akó kómal wirri darrem ingülküp, ngi oniks, ta ola asisko.) ");
INSERT INTO tof_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nis ngim tobarr ngi módóga, Gion; wa blaman Kas kantrri myangrao apónda. ");
INSERT INTO tof_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Aüd ngim tobarr ngi módóga, Taegrris. Wa olmeanda Asirria kantrri kabeana, abüsa nólgabi banikda. Tokom ngim tobarr ngi módóga, Yuprreitis. ");
INSERT INTO tof_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Lod God pam ipadórr, da we ingrinürr didiburrdü Idenóm, tüp kesu angónóm akó morroal ngakanóm. ");
INSERT INTO tof_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Akó Lod God pam arüng bóktan we ekyanórr wagó, “Marü taia blaman ini nugupdügab alom didiburr kugupidü, ");
INSERT INTO tof_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","a ma sab ini nugupdügab alogu, ne nugupa umul gailda, morroal a kolae nega. Zitülkus módóga, ma ne sab nóma elo-o, ma amkoman nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Lod God bóktanórr wagó, “Ini go morroal kokea; pam tebe püóran koke yarile, a ka morroal tangamtin gódam tonzapono oyankü.” ");
INSERT INTO tof_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Lod God ne blaman molpokodó nurr lar akó kwitüm póyae tómbapónórr tüpdügab, wa ibü ugón simarrurr pamdó oya basenóm, wa ia nadü ngi ki ngibasil yarile. Wa nadü ngi ngibasile, ene wata ibü ngi módó korale. ");
INSERT INTO tof_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Da pama ngi we ngibasilürr ngabyón lar, kwitüm póyae, akó blaman molpokodó nurr lar. A paman ma darrü morroal tangamtin gódam babul yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lod God pam büdül ut iminürr, da wa nóma umtulürr, wa darrpan nólkak kus irruanórr, da ene gao akó murrausürr tóba murri. ");
INSERT INTO tof_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Lod God kol tónzapónórr ene nólkak kusdügab, wa ne kla irruanórr pamdógab, da we tudódürr ama pamdó. ");
INSERT INTO tof_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Da pama bóktanórr wagó, “Dómdóm: Ini kus kürü kusdügabia, akó murr kürü murrdügabia; oya sab ngi ngizwasilórre: ‘kol’, zitülkus oya pamdógab urrunóp.” ");
INSERT INTO tof_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Da ini zitülkusdü pama tóba aipab nis nümgüte, ama tóba koldó dabine, da i ama darrpan bübüm baini. ");
INSERT INTO tof_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Pam a kol nizan kakapur namülnürri, a i büód ta koke aengrri. ");
INSERT INTO tof_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Da módóga, gwar wa kari ilklió-bülión gyagüpitótóke pam koke yarilürr blaman molpokodó nurr lardógab, ⌊Lod⌋ God ne kla tómbapónórr. Wa kol umtinürr wagó, “God ia amkoman bóktanórr nugup ngórr alogum blaman nugupdügab ini didiburrdü?” ");
INSERT INTO tof_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Da kola bóktanórr gwardó wagó, “Ki wa eloli blaman nugup ngórr ini didiburrdü. ");
INSERT INTO tof_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","A God igó yarilürr wagó, ‘Didiburr aodó nugupdügab, e sab ngórr alogu, akó amurr ta amurrgu! E ne nóma tónggapóni, e sab nurrótóki.’” ");
INSERT INTO tof_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Gwara bóktanórr koldó wagó, “E sab kokean nurrótóki! ");
INSERT INTO tof_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","A God umula wagó, e sab nóma elo-i, yabü ilküpa sab babzeli: e sab morroal akó kolae umul baini, God tüóbzane.” ");
INSERT INTO tof_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kola nóma esenórr, ene nugup ngórr morroal kwarilürr alom akó morroal obzek kwarilürr, oya wirrian ubi yarilürr ⌊wirri gyagüpitótók⌋ apadóm, da wa nugup ngórr we aginürr, da ngibürr poko elorr. Wa akó tóba müór ngibürr poko we iliónürr, wankü nótó yarilürr, da wa ta elorr. ");
INSERT INTO tof_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ibü nizanab ilküpa babzelórri, da i ugón umul bairri wagó, i kakapuramli. Da i tibiób ngablaom tib ⌊pig⌋ nugup pórngae-e kurr nis nürrgüprri. ");
INSERT INTO tof_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Simaman, bwóba güb nóma bainürr, ene pama tóba kolpükü Lod Godón tótók gógóram arrkrrurr, didiburrana nóma agóltagól yarilürr, da i we anikürri didiburr nugup paldó Lod Godón obzekdógab. ");
INSERT INTO tof_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Da Lod God pamdó we górrganórr wagó, “Ma ia negla?” ");
INSERT INTO tof_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Pama wagó, “Ka marü tótók gógóram arrkrrua didiburrdü, da ka gum namüla, zitülkus ka kakapurla. Da ka igósidi tünika.” ");
INSERT INTO tof_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","God we bóktanórr wagó, “Marü nótó müzazile igó, ma kakapurla? Ia ma eloa ene nugupdügab, ka marü ne arüng bóktan mókyarró alogum?” ");
INSERT INTO tof_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Pama we bóktanórr wagó, “Ma ne kol tungrinürr kankü, kürü ngibürr wató küline ene nugup ngórrdügab, da ka we eloa.” ");
INSERT INTO tof_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Lod God ene kol umtinürr wagó, “Ini ia pokoa? Ma ia larógóm tónggapóna?” Kola bóktan yalkomólórr wagó, “Kürü gwara ilklió küline, da ka igósidi amkoman kuri eloa!” ");
INSERT INTO tof_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Da Lod God gwardó bóktanórr wagó, “Zitülkus ma ini poko tónggapóna, “Ka marü amórrdóla blaman ngabyón lardógabi akó blaman molpokodó nurr lardógabi; ma sab bikómi ngain namulo, akó ma sab tüp buru elolo blaman ngürrzan moba ngyaben tonarrdó. ");
INSERT INTO tof_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ka sab alzizi aman ngyaben sidüdo, matóka kol, akó marü küp akó oya küp; oya küpa sab marü singül emkóle, akó ma sab oya küpan wakub elóngo.” ");
INSERT INTO tof_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A koldó Lod God igó bóktanórr wagó, “Ka marü azid aeng sab wirrian ino bikóm amarrudi akó olmal balngende; marü moboküpdü sab metat wirri ubi asi yarile moba müórdü, a wa ma sab metat marü singüldü pam yarile, marü alngomólóm.” ");
INSERT INTO tof_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Lod God pamdó we bóktanórr wagó, “Zitülkus ma moba kolan bóktan arrkrrua, akó mazan eloa ene nugupdügab, ka marü ne arüng bóktan mókyarró alogum, “ka tüp errkya amórrdóla marübókamde. Ma sab moba büb barre enan emkalolo tüp kesu angónde moba alo kla basenóm, blaman ngürrzan moba ngyaben tonarrdó. ");
INSERT INTO tof_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Sab tüpa tórezpükü opopor dódórr nyónórre, akó ma sab apapdó akó molpokodó zid alo namulo. ");
INSERT INTO tof_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Marü sab gügürüma tópkale alo kla basenóm, kókó ma tüpdü alkomolo, zitülkus ma olgab apadórrónla. Zitülkus ma tüp burula, da ma akó sab tüp burum baino.” ");
INSERT INTO tof_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Módóga, Adam tóba kol ngizwasilürr “Ib”, zitülkus wa blaman arrólab aipbobat warilürr. ");
INSERT INTO tof_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lod God lar sopae mórrkenyórr tómbapónórr Adamónkü akó oya kol, da wa ibü we klame püti nyónürr. ");
INSERT INTO tof_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Da Lod God tóbaka bóktanórr wagó, “Pama errkya mizan kuri baine; morroal a kolae ta wa umula. Wa tóba tang koke ki adrratól nugup ngórr aginüm akó alom, ene ngarkwat-koke arról ne nugupa gaildo. Wa ne nóma elo-e, wa sab metat ngyabele!” ");
INSERT INTO tof_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Da Lod God pam tóba kolpükü zirrapónórr Iden Didiburrdügab, tüp kesu angónóm oya nólgab tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Da wa ibü Iden Didiburrdügab we kolanókyanórr. Abüsa nólgab banikda, wa wirri arüng anerruzan kla irrbünürr akó darrpan ur ulitpükü gazirr turrik. Ene turrika ongang bapólórr akó balkomentóbalkomen yarilürr ene ngarkwat-koke arról gail nugupan kwat murrausüm. ");
INSERT INTO tof_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam tóba kolpükü umtulürr, kola bikóm we ipadórr. Da siman olom we ilngumilürr, ngi Kein. Wa ene ngi ekyanórr, zitülkus wa oyakwata igó bóktanórr wagó, “⌊Lodón⌋ tangbamtindügab ka pam olom ilngumila!” ");
INSERT INTO tof_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Solkwat oya zoret we ilngumilürr, Eibolón. Eibol wa ⌊gout⌋ a ⌊sip⌋ ngabkan pamóm bainürr, a Kein ama wa ngaon pamóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Darrpan ngürr Kein ngibürr alo kla simarrurr, tóba apapdó ne kla abülürr, urdü amselóm Lodón akyanóm. ");
INSERT INTO tof_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Da Eibol tóba ngibürr ngaensingül babótórrón sipdügab olgol murr we simarrurr, urdü amselóm, akyanóm. Lod Eibolón morroal tonarre esenórr, wa ne ⌊gyaur kla⌋ simarrurr. ");
INSERT INTO tof_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","A wa Keinün morroal tonarre koke esenórr, wa ne gyaur kla simarrurr. Da Keinün wirri ngürsila we simiógürr, akó oya mólmónapükü tupürr. ");
INSERT INTO tof_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Da Lod Keinün we imtinürr wagó, “Ma ngürsil iadela? Akó marü mólmóna iade tupe? ");
INSERT INTO tof_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ma ne dümdüm kla nóma tónggapóndóla, ma ia singül koke kwit ino barnginwómpükü? Ma ne dümdüm kla koke nóma tónggapóndóla, marü kolae tonarra akyanda nurr larzan mamtaedó zangórrón. Oya ubi marü amiógüma. Da ma ene kolae tonarr ⌊ut-ut yó⌋.” ");
INSERT INTO tof_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kein bóktanórr tóba zoretódó Eibolka wagó, “Nau, mi kya aum kóbó aurri pórrpótyapdó.” I olazan namülnürri, Kein Eibolka ara seprranórr, da we emkalórr büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Da Lod Keinün imtinürr wagó, “Marü zoret Eibol ia nega?” Wa bóktan yalkomólórr wagó, “Ka umul-kókla! Ka ia kólba zoret ngakan pamla?” carin. ");
INSERT INTO tof_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Lod bóktanórr wagó, “Ma ia poko tónggapóna? Turrkrru! Marü zoretan óea taegwarrdase kürüka tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Errkya ma amórrórrónla, da marü tüpdü ngaon errkya kulairrüna. Tüpa tae kuri tapa alngamóle marü zoretan óe anónóm marü tanganme. ");
INSERT INTO tof_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ma tüp nóma zagetan ngitino, sab myamem alo klama koke dódórr bain kwarile marünkü. A ma sab popa apól-apól ngyabenkü wamlo ini tüpdü.” ");
INSERT INTO tof_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kein bóktanórr Lodka wagó, “Kürü ⌊kolaean darrem⌋ kari kokea, kürü bügasilüm nabea! ");
INSERT INTO tof_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ma turrkrru, ma kürü tüpdügabi kuri kolakókyena ini ngürr, akó ka marü obzekdógab anikürrün namulo. Ka sab popa apól-apól ngyabenkü wamlo ini tüpdü. Darrü oloma, sab kürü nótó kósene, sab kürü kómkóle!” ");
INSERT INTO tof_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Lod bóktan yalkomólórr wagó, “Marü sab koke mómkólórre, zitülkus, sab marü büdülümpükü nótó mómkóle, ka sab oya 7 münüm kolaean darrem ekyeno.” Olgabi Lod Keinün bübdü wi ingrinürr, darrü pampükü ne nóma baseni, da oya igósidi koke emkóle. ");
INSERT INTO tof_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Módóga, Kein Lodón obzekdógabi we bumanikürr, da Nod tüpdü we ngyabelórr, Iden bwóbdü abüsa nólgabi banikda. ");
INSERT INTO tof_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein kolpükü umtulürr, da kola bikóm esenórr, Inokón we ilngumilürr. Olgabi Kein darrü wirri basirr ael yarilürr, da wa ene basirr tóba oloman ngi atenórr, Inok. ");
INSERT INTO tof_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inok olom esenórr, ngi Irrad. Irrad Meuza-elón ab yarilürr. Meuza-el Metusya-elón ab yarilürr. Metusya-el Lamekón ab yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek nis kol nümiógürr. Ngaen-gógópan kol ngi Ada, akó nis ngim kol ma Zila. ");
INSERT INTO tof_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Zabalón ilngumilürr; ngaen-gógópan olom wató yarilürr palae müótüdü ngyabenóm akó ⌊kau⌋ ngabyónüm. ");
INSERT INTO tof_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Oya zoret ngi Zubal yarilürr; ngaen-gógópan olom wató yarilürr ap barnginüm akó tatarror apulüm. ");
INSERT INTO tof_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila ta siman olom ilngumilürr, ngi Tubal-Kein. Wa abün-abün obzek zaget elklaza tólbael yarilürr brronze akó ayane. Tubal-Keinün bólbót Na-ama warilürr. ");
INSERT INTO tof_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek bóktanórr tóba kol nisdü wagó, “Ada akó Zila, kürü kurrkrruam; Kürü bóktan turrkrruam, e Lamekón kol nidipamli. Ka pam büdülümpükü kuri emkóla, kürü óepükü nótó kómkóle, darrü küsil pam, kürü gaopükü nótó kuri kómkóle. ");
INSERT INTO tof_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Darrü oloma ne büdülümpükü nóma emkóle Keinün, ene kolaean darrem 7 münüm ipüde; da olgabi, darrü oloma ne kürü büdülümpükü nóma kómkóle, ene kolaean darrem sab 77 münüm ipüde!” ");
INSERT INTO tof_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam akó tóba kolpükü umtulürr, da wa akó darrü siman olom ilngumilürr. Wa ngi ngyesilürr Set, inzan bóktanpükü wagó, “God akó kürü darrü olom kuri kókyene, Eibolón pabodó, Kein noan emkalórr.” ");
INSERT INTO tof_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Set ta olom esenórr, da ngi ngyesilürr Inos. Ene tonarrdó, pamkolpama ngaen-gógópan bókyenóp Lodón ngian ngilianóm, oya ⌊ótókde⌋. ");
INSERT INTO tof_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ini Adamón olmalbobatalab wibalómórrón ngiko. God pamkolpam nóma tómbapónórr, wa ibü tóbanan obzeksyók ngarkwatódó tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Wa ibü igó tónzapónórr, pam a kol, akó wa ibü bles ninóp, da ngi ngyesilürr “Pamakan”. ");
INSERT INTO tof_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam 130 pail nóma yarilürr, wa abóm ugón bainürr darrü siman olompükü tóba dandangzan, tóba obzeksyók ngarkwatódó. Wa oya Set ngi ngyesilürr. ");
INSERT INTO tof_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Setón amtómól kakóm, Adam akó 800 pailüm ngyabenórr, akó ngibürr simanal a ópal olmal nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Da módóga, Adam blaman kókó 930 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set 105 pail nóma yarilürr, wa Inosón abóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Inosón amtómól kakóm, Set akó 807 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Da módóga, Set blaman kókó 912 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inos 90 pail nóma yarilürr, wa Kenanón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenanón amtómól kakóm, Inos akó 815 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Da módóga, Inos blaman kókó 905 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan 70 pail nóma yarilürr, wa Ma-alalelón abóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ma-alalelón amtómól kakóm, Kenan akó 840 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Da módóga, Kenan blaman kókó 910 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ma-alalel 65 pail nóma yarilürr, wa Zarredón abóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Zarredón amtómól kakóm, Ma-alalel akó 830 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Da módóga, Ma-alalel blaman kókó 895 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Zarred 162 pail nóma yarilürr, wa Inokón abóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Inokón amtómól kakóm, Zarred akó 800 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Da módóga, Zarred blaman kókó 962 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inok 65 pail nóma yarilürr, wa Metuselan abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metuselan amtómól kakóm, Inok Godón minggüpanandó ngyabelórr akó darrü 300 pailüm akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Da módóga, Inok blaman kókó 365 pailüm ngyabenórr. ");
INSERT INTO tof_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Wa Godón minggüpanandó ngyabelórr. Olgabi, darrpan ngürr wa we bamrükürr, zitülkus God oya wata arról pam sipadórr tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela 187 pail nóma yarilürr, wa Lamekón abóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamekón amtómól kakóm, Metusela akó 782 pailüm ngyabenórr akó wa ngibürr simanal akó ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Da módóga, Metusela blaman kókó 969 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek 182 pail nóma yarilürr, wa siman oloman abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek tóba olom Noa ngi ekyanórr, zitülkus wa oyakwata igó bóktanórr wagó, “Ini wa sab mibü ul tirre mibü ini tüpan wirri müp zagetódógabi, ⌊Lod⌋ ne tüp amórrórr metatómpükü.” ");
INSERT INTO tof_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noan amtómól kakóm, Lamek akó 595 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Da módóga, Lamek blaman kókó 777 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Da Noa 500 pail ne tonarrdó yarilürr, wa ibü abóm ugón bainürr, Syem, Am, akó Zeipet. ");
INSERT INTO tof_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Pamkolpama ini tüpdü abün nóma bainónóp, akó ópal olmal nóma balngónónóp, ");
INSERT INTO tof_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","da Godón simanal olmala ini pamkolpamab ópal olmal igó nósenóp wagó, ene morroal agurr kolako. Da i ngibürr bumigóp popa tibiób kolóm, i nibióbka ubi bainóp. ");
INSERT INTO tof_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Olgabi ⌊Lod⌋ bóktanórr wagó, “Kürü arról akyan samua sab pamkolpamdó koke burrmute wirri ngarkwat tonarróm, zitülkus i enan bupso bübako, sab nurrbarine. Sab ugórr ibü ngyaben kokrrap ngarkwat wata 120 pail yarile.” ");
INSERT INTO tof_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ene ngürrdü, akó ngibürr tonarr kakóm, wirri kwitüm akó wirri arüng pam ini tüpdü asi kwarilürr. Godón simanal olmala tüpan kolpükü nóma bazurrulürr ngaen ngyaben tonarrdó, i igó olmal balngónóp: arüng bügür akó umulürrün pam nidi koralórr. ");
INSERT INTO tof_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Lod igó esenórr, paman kolae kari koke yarilürr ini tüpdü, akó oya moboküpa ne kla gyagüpi amalórr, wata kolaean yarilürr metat. ");
INSERT INTO tof_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Da Lod kari gyaur koke yarilürr, zitülkus ibü wató tómbapónórr ini tüpdü. Ini pokoa oya moboküp itülürr. ");
INSERT INTO tof_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Da Lod bóktanórr wagó, “Ka sab ini blaman pamkolpam, ka nibiób tómbapórró, blaman pabzuo ini tüpdügab. Pamkolpam tibióban koke: tüpdü agóltagól elklaza, ngübyón elklaza, akó kwitüm póyae. Ka gyaurla kótó tómbapórró.” ");
INSERT INTO tof_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","A Lod wata Noaka morroal esenórr tóba obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ini Noankwata póepe. Noa tebe püóran dümdüm ngyaben pam wató yarilürr ene ngyaben tonarrdó, akó wa Godón minggüpanandó ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noan aüd olmal kwarilürr, ngi Syem, Am, akó Zeipet. ");
INSERT INTO tof_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Da módóga, Godón ngakande, tüp abürrünsabürrün yarilürr kolae tonarranme. Blaman pamkolpama abün-abün kolae tulmilpükü ngyabenónóp akó gazirrwóm ini tüp gwarrarrón yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God tüp esenórr, da módóga, tüp amkoman kulairrün yarilürr, zitülkus blaman pamkolpama ini tüpdü tibiób ngyaben tulmil kulainóp. ");
INSERT INTO tof_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Da God Noaka we bóktanórr wagó, “Ka gyagüpitótók kuri esena blaman pamkolpam kulainüm, zitülkus gazirrwóma ini tüp kuri gwarróne ibübókamde. Turrkrru, ka sab ibü blaman pabzuo ini tüppükü! ");
INSERT INTO tof_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Wirri but elke yabióbkü, goperr nugupdügabi. Olgabi ut bwób singgalgónke ene kugupidü, da tótórr murrnausnümke tarre, kugupi kwata akó kalkuma. ");
INSERT INTO tof_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ene but inzan tónggapónke: 150 küór kokrrap, 25 küór taptap, akó 15 küór kwit. ");
INSERT INTO tof_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Twól tónggapónke butankü. Kari kan, 44 sentimita, amgatke twól a gri, ibü aodó. Barrbün mamtae kabedó ingrinke, akó aüd paug balmelke but kugupidü - tüpana, ao, akó kwitana. ");
INSERT INTO tof_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Turrkrru, ka wirri naiz nae ódód kari pokola ini tüpdü blaman arról elklaza amrüküm, ne klama ngón amandako. Blaman elklaza ini tüpdü sab nurrbarine. ");
INSERT INTO tof_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","A mankü, ka sab kólba ⌊alkamül-koke tónggapórrón bóktan⌋ ingrino. Da e sab butüdü barrbuno - mató, marü simanal olmal, marü kol, akó marü simanal olmalab kol mankü. ");
INSERT INTO tof_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ma sab blaman obzek lar ninis simarrulünke ama butüdü - siman a óp - mankü arról asenóm. ");
INSERT INTO tof_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Blaman obzek póyae, akó blaman obzek lar, akó blaman obzek tüpdü ngübyón elklaza, sab marüka ninis togoble arról asenóm - siman a óp. ");
INSERT INTO tof_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ma sab blaman obzek alo kla yazebo, da irrbuno butüdü. Ene alo kla sab marüpükü akó ibüpükü kwarile.” ");
INSERT INTO tof_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Da Noa blaman elklaza tómbapónórr, God oya enezan arüng bóktan ekyanórr. ");
INSERT INTO tof_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","⌊Lod⌋ bóktanórr Noaka wagó, “Butüdü ugó bangri, mató akó moba olmalkol, zitülkus ka igó kuri ngakóna, ma wata dümdüm ngyaben pam mobela blaman pamkolpamdógabi ini tüpdü nidi ngyabendako. ");
INSERT INTO tof_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","“Mankü yazebke 7 simanal lar tibiób ópal gómdamalpükü blaman ia-ia obzek tóman-koke lardógab butüdü arrbünüm. A blaman ia-ia obzek tómanpükü lardógab, ma mankü wata darrpan siman lar ipadke tóba óp gódampükü butüdü angrinüm. ");
INSERT INTO tof_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mankü ta yazebke 7 simanal póyae tibiób ópal gómdamalpükü blaman ia-ia obzek kwitüm póyaedógab, ibü zid ainüm akó kupo balngónóm ini dudu tüpdü akó. ");
INSERT INTO tof_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Zitülkus módóga, 7 ngürr kakóm ka sab ngup ugón zirrsapono ini tüpdü. Sab ngupa 40 ngürrüm akó 40 irrübüm timilóle, da ka ini tüpdügabi blaman arról elklaza simrüko, ka ne kla tómbapórró.” ");
INSERT INTO tof_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Da Noa blaman elklaza tómbapónórr, Lod oya arüng bóktan enezan syalórr. ");
INSERT INTO tof_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa ugón 600 pail yarilürr, naiz naea ini tüp nóma ngaslaorr. ");
INSERT INTO tof_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa butüdü bangrinürr ene naiz naedógab kyab kórzyónüm - wa tüób, oya simanal olmal, oya kol, akó oya olmalab kol. ");
INSERT INTO tof_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Tóman-koke akó tómanpükü lar, póyae, akó tüpdü ngübyón elklaza - siman a óp - ");
INSERT INTO tof_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ninis Noaka ogoblórr butüdü, God Noan arüng bóktan enezan syalórr. ");
INSERT INTO tof_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","7 Ngürr kakóm, naiz naea tüp ugón ngaslaorr. ");
INSERT INTO tof_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa 600 pail nóma yarilürr, 17 ngim ngürrdü, nis ngim melpalan, blaman tüp kugupidü arób naea wirri arüngi ugón bónganórr, akó nae mamtae tapanukuóp kwitüdü. ");
INSERT INTO tof_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Da ngupa ugón bókyanórr wirri arüngi amil, 40 ngürr akó 40 irrübüm. ");
INSERT INTO tof_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tai ene ngürrandó, Noa, tóba simanal olmal, Syem, Am, akó Zeipet, tóba kol, akó tóba olmalab kol but kugupidü barrbünürr. ");
INSERT INTO tof_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Inkü ene butüdü we kla kwarilürr ninis: blaman nurr lar, blaman ngabyón lar, blaman tüpdü ngübyón elklaza, blaman póyae, tibiób obzek ngarkwatódó - akó blaman tappükü kla. ");
INSERT INTO tof_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ninis ogoblórr ama Noaka butüdü, blaman elklaza ne klama ngón amandako. ");
INSERT INTO tof_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Blaman arról elklaza ne klama barrbülürr, simanal a ópal kwarilürr, God Noan arüng bóktan enezan ekyanórr. Olgabi Lod oya kakóm mamtae we murrausürr. ");
INSERT INTO tof_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","40 Ngürrüm ene naiz naea tai byamróklórr. Naeazan byamrók yarilürr, butpükü ta kwit yólürr tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Naiz naeazan tai buku bailürr tüp kwitana, buta udarüküm ugón bainürr nae kwitüm. ");
INSERT INTO tof_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Naiz naea amkoman wirrian nóma bainürr, blaman wirri podo nüdarükóp. ");
INSERT INTO tof_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Naea tai tüngülürr kókó podo solo nganolop, 7 küór ngarkwat. ");
INSERT INTO tof_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Blaman arról elklaza, ne klama agól-tagól kwarilürr tüpdü, nurrbarinürr - póyae, ngabyón lar, nurr lar, tüpdü ngübyón elklaza, akó blaman pamkolpam. ");
INSERT INTO tof_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Blaman arról elklaza mólóg bwóbdü, ne klama ngón tomalórr, nurrbarinürr. ");
INSERT INTO tof_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Lod ini tüpdü ne arról klama ngyabenónóp blaman pabzaurr - pamkolpam, lar, ngübyón elklaza, akó kwitüm póyae. Wata Noa akó wankü but kugupidü nidi kwarilürr, idi baminürr. ");
INSERT INTO tof_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ini tüp naiz naea wata inzan ngalaorrón yarilürr 150 ngürrüm. ");
INSERT INTO tof_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Da God Noan gyagüpi amaikürr, akó blaman nurr akó ngabyón lar wankü ene butüdü. Wa wór zirrsapónórr busom ini tüpdü, da naiz naea we ukyólürr. ");
INSERT INTO tof_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ene aumana tüp kugupidü arób nae, akó kwitüm nae mamtaepükü murrnausóp. Da wirri ngupa amil piküp bainürr kwitüdügab. ");
INSERT INTO tof_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Da módóga, ene naiz naea zaorrón we alkomólólórr; 150 ngürra nóma blakónóp, naea ama barrkyananbóka ukyónürr. ");
INSERT INTO tof_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","17 Ngim ngürrdü, 7 ngim melpaldó, but naea we amgatórr darrü Arrarrat podo kwitüm. ");
INSERT INTO tof_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Naea zaorrón inzan alkomólólórr kókó 10 ngim melpal. Ngaen-gógópan ngürrdü, ene melpaldó, ngibürr podoa panzedó ugón pulkaka tübinóp. ");
INSERT INTO tof_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","40 Ngürra nóma blakónóp, Noa pokar mamtae we tapakurr, wa ne kla tónggapónórr butüdü, ");
INSERT INTO tof_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","da kokabzan póyae arrmulüm we elkomólórr. Ene póyaea arrmulülürr bwób-bwób, kókó ta blaman naea ukyónürr tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Da wa nurre póyae arrmulüm we elkomólórr ngakanóm igó wa, naea ia kuri ukine tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","A ene nurre póyaea darrü bwób koke esenórr aupüm, da wa Noaka we tolkomólórr butüdü, zitülkus tüp wata dudu yarilürr naea ngalaorrón. Noa tang adrratórr, da ene nurre póyae ipadórr, salkomólórr tóbaka ama butüdü. ");
INSERT INTO tof_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Wa akó ngibürr 7 ngürr nókyenóp, da wa ene dadan nurre póyae akó ugón busom elkomólórr butüdügab. ");
INSERT INTO tof_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ene nurre póyaea ama oyaka simaman tolkomólórr, da módóga, küsil agirrün ⌊olib⌋ pórngae tóba taedó yarilürr, mólmóne arümürrün. Olgabi Noa umul bainürr wagó, naea barrkyananbóka ukyónürr tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Wa akó 7 ngürr nókyenóp, da olgabi ene nurre póyae aüd mün elkomólórr busom. A ini tonarr, wa myamem koke tolkomólórr oyaka. ");
INSERT INTO tof_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ngaen-gógópan ngürrdü, ngaen-gógópan melpaldó, Noa 601 pail nóma yarilürr, nae ugón ukyórrün yarilürr tüpdügab. Noa ene butan ngibürr twól ngalaorrón nugup poko nanenóp azilüm, da módóga, wa esenórr wagó, tüpa mólóg baindase. ");
INSERT INTO tof_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","27 Ngim ngürrdü, nis ngim melpaldó, tumum tüp amkoman mólóg yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Da God Noaka tóbtanórr wagó, ");
INSERT INTO tof_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Tubrra butüdügab - matóka moba kol, akó marü simanal olmal akó ibü kol mankü. ");
INSERT INTO tof_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ugó yus blaman arról elklaza, mankü ne klamko - póyae, ngabyón lar, akó tüpdü ngübyón elklaza. Da i sab küppükü ki bainünüm ini tüp ayom, kókó tüpa tai ki barüm!” ");
INSERT INTO tof_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Da Noa butüdügab burruanórr, tóba simanal olmal, oya kol, akó oya olmalab kol wankü. ");
INSERT INTO tof_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Blaman lar, blaman tüpdü ngübyón elklaza, akó blaman póyae - blaman agóltagól elklaza, butüdügab bauslürr. Darrpan ngarkwat obzek lara kopo-kopo bauslürr. ");
INSERT INTO tof_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Olgabi Noa ⌊alta⌋ elórr ⌊Lodónkü⌋; blaman darrü-darrü obzek ⌊tóman-koke⌋ lardógab akó tóman-koke póyaedógab, wa ngibürr yazebórr, altadó dudu yamselórr ura adüngüm Godón akyanóm. ");
INSERT INTO tof_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Da Lod morroal ilang nóma irrzümülürr, da moboküpi bóktanórr wagó, “Ka sab myamem akó ini tüp koke amórro ini pamkolpamabme, enana ibü moboküpdü ne gyagüpitótók kolaeanako ene tonarrdógab i karianpókal koralórr. Ka sab myamem blaman arról elklaza kokean kolae ninünümo, ka enezan tónggapórró. ");
INSERT INTO tof_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Tüpa sab enezan ngyabele, arit akó abül, güb akó urur ngürr, abüsbarr akó pail, ngürr akó irrüb sab kokean blakórre.” ");
INSERT INTO tof_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God Noa akó tóba simanal olmal bles ninóp, da we bóktanórr wagó, “E küppükü bailamke akó abün olmal balngólamke, da tüpa tai ki gwarran yabübókamde! ");
INSERT INTO tof_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Blaman ini tüpdü lar, kwitüm póyae, ngübyón elklaza, akó maludü wapi, yabü sab wirribóka gum nangónórre; ka yabü tangdó kuri irrbüna. ");
INSERT INTO tof_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Blaman arról elklaza, ne klama agóltagóldako, sab yabü alóng kla kwarile. Ka yabü alo nugup zid enezan nülinarre, ka yabü errkya blaman kla kuri nülinünüma. ");
INSERT INTO tof_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","A e sab óepükü alóng kla murr alóng-gu, zitülkus arról óedóma. ");
INSERT INTO tof_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sab darrü pama ne paman arról nóma itüle, ka sab oya kolae darrem ekyeno, zitülkus paman arrólan óea bókanórr. Akó lara ne paman arról nóma itüle, ka ta sab oya kolae darrem ekyeno. ");
INSERT INTO tof_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Pam büdülümpükü nótó nóma emkóle, oya sab darrem büdülümpükü emkórre; zitülkus God pam tónggapónórr tóba dandang ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A yadi, e küppükü bailamke, akó abün olmal balngólamke, tüpa tai ki gwarran yabübókamde! Yabü olmalbobatala sab abün ki bainünüm ini tüpdü.” ");
INSERT INTO tof_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","God we tóbtanórr Noaka akó oya simanal olmaldó wagó, ");
INSERT INTO tof_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Tübarrkrru, ka yabüpükü akó yabü olmalbobatalpükü errkya kólba alkamül-koke tónggapórrón bóktan angrindóla, ");
INSERT INTO tof_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","akó blaman arról elklaza, yenkü ne kla kwarilürr - blaman póyae, blaman ngabyón lar, akó nurr lar, blaman ne klama tübausürr yenkü butüdügab - blaman arról elklaza ini tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ka kólba alkamül-koke tónggapórrón bóktan angrindóla yabüpükü: sab myamem blaman ne arról elklaza naiz naea kokean pabzue, akó myamem inzan naiz babul yarile tüp kulainüm.” ");
INSERT INTO tof_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Da God akó bóktanórr wagó, “Alkamül-koke tónggapórrón bóktan, ka ne kla angrindóla, ka küób akó yadi, mibü aodó, akó blaman arról elklaza yenkü, akó blaman pamkolpama sab solkwat nidi tóbabótóle, timam we kla yarile: ");
INSERT INTO tof_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ka kólba órrólab kuri ingrina pülpüldü. Ene sab alkamül-koke tónggapórrón bóktanan timam yarile, kótóka tüp, mibü aodó. ");
INSERT INTO tof_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ka sab pülpül poko nóma dakabasulo tüp ngalaom, da órrólaba panzedó nóma okaka tübine, ");
INSERT INTO tof_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kürü sab ngambangóle, ka ne alkamül-koke tónggapórrón bóktan ingrirrü, kótó, yadi, akó blaman obzek arról elklaza, mibü aodó. Igó wagó, sab naea myamem wirri naizüm koke baine blaman arról elklaza kulainüm. ");
INSERT INTO tof_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Órrólaba sab pülpüldü nóma okaka tübine, ka sab eseno, akó kürü sab ngambangóle alkamül-koke tónggapórrón bóktan, God akó blaman obzek arról elklaza ini tüpdü, ibü aodó. Ene tónggapórrón bóktan sab metatómpükü asi yarile.” ");
INSERT INTO tof_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Da God tóbtanórr Noaka wagó, “Ene timam módóga, ka ne alkamül-koke tónggapórrón bóktan ingrina, kótóka blaman arról elklaza ini tüpdü, mibü aodó.” ");
INSERT INTO tof_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noan ne simanal olmala tübausürr butüdügab, idi kwarilürr: Syem, Am, akó Zeipet. (Am wa Keinanón ab yarilürr.) ");
INSERT INTO tof_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ini aüd pam Noan simanal olmal kwarilürr; pamkolpama ibükagab bayolórr ini tüp ngalaom. ");
INSERT INTO tof_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa didiburr ngaon pam yarilürr. Wa ⌊grreip⌋ zid arit ugón bókyanórr grreip didiburr tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wa ngibürr waen nóma enónórr, oya gorrgorra ugón simiógürr. Kakapurr we umtulülürr tóba palae müót kugupidü. ");
INSERT INTO tof_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Am, Keinanón ab, tóba ab Noan büb kakapur esenórr. Wa tóba naret nis we nüzazilürr. I pulkaka namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Da Syem a Zeipet mórrkenyórr poko ipadrri, tibiób tupodó we ingrirri. I kake aurrürri, aban kakapur büb ngalaom. Tibiób aban büb kakapur asen-gum, i obzek darrü pokodó nalüngrri. ");
INSERT INTO tof_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noan waen gorrgorra nóma amgatórr akó nóma umul bainürr wagó, oya solo kupo oloma ne poko tónggapónórr oyaka, ");
INSERT INTO tof_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","we bóktanórr wagó, “Ka Keinan amórrdóla! Wa sab kari-kari ⌊leba zaget olom⌋ yarile tóba naret nisabkü.” ");
INSERT INTO tof_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Wa akó igó poko bóktanórr wagó, “⌊Lodón⌋ yagüram, Syemón God! Keinan sab Syemón leba zaget olom ki yarilün. ");
INSERT INTO tof_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God sab Zeipetón bwób ki arratlón! Zeipet sab Syemón palae müótüdü ki ngyabelón, akó Keinan sab Zeipetón leba zaget olom ki yarilün.” ");
INSERT INTO tof_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Naiz nae kakóm, Noa akó 350 pailüm ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa blaman kókó 950 pailüm ngyabenórr, da wa we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ini Noan simanal olmalab ngiko, Syem, Am, akó Zeipet, akó i nibiób balngenóp naiz kakóm. ");
INSERT INTO tof_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zeipetón simanal olmalab ngi idipako: Gomerr, Magog, Madae, Zaban, Tubal, Mesek, akó Taerras, tibiób olmalbobatalpükü. ");
INSERT INTO tof_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomerrón olmalbobatalab zitül we kla kwarilürr: Askenaz, Rripat, akó Togarrma, tibiób pamkolpampükü. ");
INSERT INTO tof_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Zabanón olmalbobatalab zitül we kla kwarilürr: Ilaesya pamkolpam, Tarrsyis pamkolpam, Kit pamkolpam, akó Rrodes pamkolpam. ");
INSERT INTO tof_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Da olgab bürrgrrütóp, ngiIsbürra malu kabedó akó ngibürra kaodó we barselórr. Zeipetón olmalbobatal we kla kwarilürr. I blamana zitül-zitül we ngyabenónóp tibióban tüpdü, akó ibü ta tibióban bóktan asi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Amón simanal olmalab ngi idipako: Kus, Mizrra-im, Put, akó Keinan, tibiób olmalbobatalpükü. ");
INSERT INTO tof_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusün olmalbobatalab zitül we kla kwarilürr: Syeba, Abila, Sabta, Rra-ama, akó Sabteka, tibiób pamkolpampükü. Rra-aman olmalbobatalab zitül we kla kwarilürr: Syeba akó Dedan pamkolpam. ");
INSERT INTO tof_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus Nimrrodón ab yarilürr. Nimrrod tüób ini tüpan ngaen-gógópan wirri arüng gazirr pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wa ta wirri arrak pam yarilürr ⌊Lodón⌋ obzek kwata, da i igósidi bóktan kwarilürr pambóka wagó: “Wa Nimrrodzan arrak pama Lodón obzek kwata.” ");
INSERT INTO tof_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Oya kingan balngomól bwóban ngaen-gógópan wirri basirr ngi módó kwarilürr: Babel, Errek, Akad, akó Kalne, Babilonia kantrridü. ");
INSERT INTO tof_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Olgab wa we wamórr ama Asirria kantrridü, ó wa ngibürr wirri basirr balmelórr: Ninebe, Rreobot-Irr, Keila, ");
INSERT INTO tof_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","akó Rresen wirri basirr, Ninebe akó Keila, ibü aodóma. ");
INSERT INTO tof_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizrra-imün olmalbobatalab zitül we kla kwarilürr: Lud, Anam, Le-ab, Naptu, ");
INSERT INTO tof_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrrus, Kaslu (Pilistia pamkolpama noakagabi togobórr), akó Kaptorr, tibiób pamkolpampükü. ");
INSERT INTO tof_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Keinanón nis siman olom nis ilngumilürr: Sidon, oya ngaen olom, akó Et. ");
INSERT INTO tof_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Wa ta akó ibü abbobat yarilürr: Zebus, Amorr, Girrgas, ");
INSERT INTO tof_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ib, Arrk, Sin, ");
INSERT INTO tof_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arrbad, Zemarr, akó Amat, tibiób pamkolpampükü. Ene kakóm, Keinanón pamkolpama zitül-zitül we barsenórr, ");
INSERT INTO tof_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","da ibü tüpa wirri bailürr, tai Saedon wirri basirrdügab, ama Gerrarr wirri basirrdübóna, tai kókó Gaza wirri basirr amrran, ó akó ama Sodom, Gomorra, Adma, akó Zebo wirri basirrdübóna, pamkolpama ne ngyabenónóp, tai kókó Lasa amrran. ");
INSERT INTO tof_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amón olmalbobatal we kla kwarilürr. I blamana zitül-zitül we ngyabenónóp tibióban tüpdü, akó ibü ta tibióban bóktan asi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Syem, Zeipetón naret, wa blaman Ibrru pamkolpamab abbobat yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Syemón simanal olmalab ngi idipako: Ilam, Asyurr, Arrpaksad, Lud, akó Arram, tibiób olmalbobatalpükü. ");
INSERT INTO tof_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arramón olmalbobatalab zitül we kla kwarilürr: Uz, Ul, Geterr, akó Mesek, tibiób pamkolpampükü. ");
INSERT INTO tof_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arrpaksad Syelan ab yarilürr, akó Syela ma Eberrón ab yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberrón nis olom nisa tómtómórri: darrüpan ngi Peleg yarilürr, zitülkus oya ngyaben tonarrdó tüpan pamkolpama ugón syórr bangónórr. Oya zoretan ngi ma Zoktan yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Zoktanón olmalbobatalab zitül we kla kwarilürr: Almodad, Syelep, Azarrmabet, Zerra, ");
INSERT INTO tof_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adorram, Uzal, Dikla, ");
INSERT INTO tof_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abima-el, Syeba, ");
INSERT INTO tof_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opirr, Abila, akó Yobab, tibiób pamkolpampükü. Ini blaman Zoktanón olmalbobatal kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","I ne tüpdü ngyabenónóp, tai igó wamlórr Mesya bwóbdügab ama Separr bwóbdübóna, podopükü bwóbdü, abüsa nólgabi banikda. ");
INSERT INTO tof_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Syemón olmalbobatal we kla kwarilürr. I blamana zitül-zitül we ngyabenónóp tibióban tüpdü, akó ibü ta tibióban bóktan asi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ini blaman Noan olmalbobatal we kla kwarilürr; tibiób abankwata akó guankwata ini pebadó wialómórrónako. Naiz nae kakóm, blaman ini tüpdü pamkolpama ibükagab barselórr. ");
INSERT INTO tof_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ngaen, blaman ini tüpdü pamkolpamab darrpan wirri bóktan yarilürr; blamana dadan bóktan opore ikik kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Pamkolpama enezan ngyabenkü ogoblórr olgabi, abüsa nólgabi banikda, da i Babilonia kantrridü buruburu taptap tüp esenóp. Metat we bainóp. ");
INSERT INTO tof_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Da i tibióbka bóktan kwarilürr wagó, “Yao, mi errkya taptap marit poko tómbapóndakla, da mi zürüküm kubó tai bamngurre urdü!” Da ingülküpan pabodó ibü marit poko asi kwarilürr gri aelóm, akó motan pabodó ama tarr, marit poko karrkukus arümüm. ");
INSERT INTO tof_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Da i bóktónóp wagó, “Mi errkya wirri basirr aeldakla tawapükü, kókó tawa soloa tai pülpül emrróne. Ene ngarkwatódó, mi sab mibiób ngi wirri nirre, ó ene igósüm mi sab koke barngeno bwób-bwób ini tüpdü.” ");
INSERT INTO tof_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","⌊Lod⌋ ene wirri basirr ngakanóm we tübinürr akó tawa, pamkolpama ne kla nelnóp. ");
INSERT INTO tof_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Da Lod moboküpi we bóktanórr wagó, “I errkya darrpan pamkolpamako akó ibü darrpan bóktana. Ini wa zitüla, i sab ne kla tómbapónórre. Darrü kla sab ibüka müp koke yarile, i ne kla gyagüpi aman korale. ");
INSERT INTO tof_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Yao, mi módó ogoba ola ibü bóktan yarrisarri angónóm, igósüm i sab tibiób koke barrkrrule darrem-darrem.” ");
INSERT INTO tof_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Da módóga, Lod ibü we arngenórr bwób-bwób ini dudu tüpdü, akó i we piküp bainóp ene tawapükü wirri basirr aelóm. ");
INSERT INTO tof_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","We ngarkwatódó, ene wirri basirr ngi ngyesilóp Babel, zitülkus Lod blaman pamkolpamab bóktan yarrisarri yangónórr. Da olgabi God ibü bwób-bwób we arngenórr ini dudu tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ini Syemón olmalbobatalab ngiko. Nis pail naiz kakóm, Syem 100 pail nóma yarilürr, wa Arrpaksadón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arrpaksad nóma tómtómólórr, Syem akó 500 pailüm ngyabelórr akó ngibürr simanal akó ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arrpaksad 35 pail nóma yarilürr, wa Syilan abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Syilan amtómól kakóm, Arrpaksad akó 403 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Syila 30 pail nóma yarilürr, wa Eberrón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eberrón amtómól kakóm, Syila akó 403 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberr 34 pail nóma yarilürr, wa Pelegón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelegón amtómól kakóm, Eberr akó 430 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg 30 pail nóma yarilürr, wa Rreun abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rreun amtómól kakóm, Peleg akó 209 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rreu 32 pail nóma yarilürr, wa Serrugün abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serrugün amtómól kakóm, Rreu akó 207 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serrug 30 pail nóma yarilürr, wa Na-orrón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Na-orrón amtómól kakóm, Serrug akó 200 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Na-orr 29 pail nóma yarilürr, wa Terran abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terran amtómól kakóm, Na-orr akó 119 pailüm ngyabenórr akó wa ngibürr simanal a ópal olmal we nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terra 70 pail nóma yarilürr, wa ibü abóm ugón bainürr, Eibrram, Na-orr, akó Arran. ");
INSERT INTO tof_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ini Terran olmalbobatalab ngiko. Terra ibü abóm bainürr, Eibrram, Na-orr, akó Arran. Arran Lotón abóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Oya ab Terra arról nóma yarilürr, Arran ugón nurrótókórr tóba amtómól bwóbdü, ngi Urr, Babilonia pamkolpamab kantrridü. ");
INSERT INTO tof_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Eibrram a Na-orr kol bumiógrri. Eibrramón kol ngi Serrae warilürr, Na-orr wa Milkan zumiógürr, Arranón óp olom. Oya darrü óp olom asi warilürr, ngi Iska. ");
INSERT INTO tof_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Serrae olmal balngón-koke kol warilürr. ");
INSERT INTO tof_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terra tóba olom Eibrramón ipadórr, akó tóba bobat Lot, Arranón siman olom nótó yarilürr, akó tóba kolalkot Serrae, Eibrramón kol. I Urr basirr we amgütóp, Babilonia kantrri kugupidü, da i wa Keinan tüpdü ogoblórrma, a i Arran wirri basirrdü nóma babzilürr, da i ma metat ngyabenóm we bainóp. ");
INSERT INTO tof_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terra 205 pailüm ngyabenórr, da we nurrótókórr Arran wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Darrpan ngürr ⌊Lod⌋ Eibrramka bóktanórr wagó, “Ma moba bwób, moba pamkolpam, akó moba aban zitül pamkolpam metatómpükü ugó nümgütünüm. Ugó wam, ka marü sab ne bwób mómtyeno. ");
INSERT INTO tof_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Marü ka sab abün olmalbobatal mülino. I tibióban wirri kantrridü ngyaben kwarile. Ka marü bles mino; Ka sab marü wirri ngi mókyeno, ma sab bles-ain ngyaben sidüdo bwób-bwób pamkolpamdó. ");
INSERT INTO tof_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ka sab ibü bles ninünümo, marü nidi bles mirre, akó ka sab ibü nómórrnónómo, marü nidi mómórrórre. Marükama, ka sab blaman ini tüpdü pamkolpam bles ninünümo.” ");
INSERT INTO tof_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Da Eibrram we bupadórr tóba Arran basirrdügab, oya Lod enezan yalórr. Lot wankü wamórr. Eibrram ugón 75 pail yarilürr, wa Arran nóma amgatórr. ");
INSERT INTO tof_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eibrram tóba Serrae kolpükü we bupadórr Keinan tótókóm, tóba zoretan olom Lot, tibiób blaman elklaza, i ne kla kwób isunóp, akó ne ⌊leba zaget⌋ pamkolpam, i nibiób bumigóp Arranóm. I Keinan nóma babzilürr, ");
INSERT INTO tof_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ene bwóbdüma ogoblórr, kókó da i babzilürr Syekem wirri basirr minggüpanan, wirri nugup ne yarilürr Morre bwób pokodó. Ene tonarr ugón Keinan bwób pamkolpama ola ngyaben kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Lod Eibrramka ola okaka tübyónürr wagó, “Marü olmalbobatal ka sab ini Keinan tüp nókyenónómo.” Eibrram ⌊alta⌋ igósidi we elórr Lodónkü, oyaka nótó okaka tübyónürr. ");
INSERT INTO tof_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Wa Syekemgab we wamlórr ama darrü podopükü bwóbdü, wirri basirr Betel minggüpanan, abüsa nólgabi banikda. Wa tóba palae müót we aodó balmelórr, Betel wirri basirr, abüsa nebóna bótaoda, akó Ae wirri basirr, webónada abüsa nólgabi banikda. Wa akó Lodón alta ola elórr, da wa Lodón ngian we ngilialórr oya ⌊ótókóm⌋. ");
INSERT INTO tof_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eibrram akó olgab we bupadórr, da ngyabenkü igó wamlórr bwób-bwób, kókó Negeb ⌊ngüin-koke bwóbdübóna⌋, malubarrdóbóna. ");
INSERT INTO tof_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ene tonarr, Keinan tüpdü ku yarilürr, da Eibrram karianbóka ngyabenóm wamórr Izipt kantrridü, zitülkus kari kolae ku koke yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Eibrram tóba kolpampükü Izipt abzil minggüpanan nóma yarilürr, da wa tóba Serrae koldó bóktanórr wagó, “Serrae, ma ngaka! Ka umulóla, ma morroal agurr kolóla. ");
INSERT INTO tof_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Marü Izipt kolpama kubó nóma móserre, i sab igó bóktórre wagó, ‘Ini oya kolo’, da igósidi sab kürü büdülümpükü kómkólórre. A marü arról wa zid irre. ");
INSERT INTO tof_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","A ma sab igó bóktanke magó, ma kürü bólbótóla. Ene igósüm, i sab kürü morroal ngakan korale marübókamde, akó ene igósüm, ma sab kürü arról zid ino.” ");
INSERT INTO tof_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Eibrram tóba pamkolpampükü Izipt nóma abzilürr, da Izipt kolpama nóma osenóp oya kol, wa wirri agurr kol warilürr. ");
INSERT INTO tof_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ngibürr parraoan ngi pama oya nóma osenóp, parrao azazilüm we ogobórr, da oya we ududóp parraoan wirri müótüdü oya kolóm. ");
INSERT INTO tof_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Da parraoa Eibrramón morroal ngakan yarilürr Serraen zitülkusdü. Da wa oya we kla iliónürr: ⌊sip⌋, simanal ⌊kau⌋ akó ópal kau, siman ⌊donki⌋, ópal a simanal leba zaget kolpam, óp donki, akó ⌊kamel⌋. ");
INSERT INTO tof_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","A Eibrramón kolanbókamde Lod wirri kolaean azid zirrsapónórr parrao, oya olmalkoldó, akó müótüdü nidi zaget kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Da parraoa bóktan zirrapónórr Eibrramón ódódóm oyaka. Oya nóma sidüdóp, da bóktanórr wagó, “Ma ia laró tónggapórró kürüka? Ma kürü koke iade küzazilürrü igó, Serrae marü kolo? ");
INSERT INTO tof_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ma iade bóktarró igó, ini marü bólbóto? Ka ma oya igósidi upadórró kólba kolóm. Marü kol wóni! Upa da ugó aurram!” ");
INSERT INTO tof_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Parraoa tóba zaget pam arüng bóktan nókyenóp Eibrramónkwata, da i oya we zirrapónóp tótókóm wa nólgab tamórr, tóba kolpükü, akó oya blaman ne elklaza koralórr. ");
INSERT INTO tof_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Da Eibrram Izipt we amgatórr, tóba kolpükü, akó oya blaman ne elklaza koralórr, da we wamlórr ama Negeb ⌊ngüin-koke bwóbdü⌋. Lot, Eibrramón zoretan olom, ta wankü wamlórr. ");
INSERT INTO tof_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Eibrram wirri mórrel pam yarilürr, zitülkus oya ngabyón lar akó ⌊silba⌋ akó ⌊gold⌋ abün kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negebgab wa ngyabenkü wamlórr kókó Betel amrran, wa ngaen-gógópan tóba palae müót ne elórr ");
INSERT INTO tof_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","akó wa ⌊Lodón⌋ ⌊alta⌋ ne elórr. Ene bwób poko Betel akó Ae ibü aodó yarilürr. Wa ola Lodón ngian we ngilialórr oya ⌊ótókóm⌋. ");
INSERT INTO tof_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot Eibrramdi ngyabenkü aurrnürri, da oya ta ⌊sip⌋ a ⌊gout⌋ yabül, ⌊kau⌋ yabül, akó pamkolpam asi koralórr. ");
INSERT INTO tof_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","I enezan ngyabenórri darrpan pokodó, ene tüpdü alo kla akó nae gaodó koke koralórr ibü blamanab ngyabenóm, zitülkus ibü ngabyón lar abün koralórr. ");
INSERT INTO tof_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Da ene pokodó, Eibrramón ngabyón lar ngabkan pam akó Lotón ngabyón lar ngabkan pam, ibü aodó ongyaltongyala tómbapónórr. Ene tonarrdó, Keinan pamkolpam akó Perris pamkolpam, i ta ugón ene tüpdü ngyaben koralórr. ");
INSERT INTO tof_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Eibrram bóktanórr Lotka wagó, “Gyaurka, myamem ongyaltongyal babul ki yarilün ma na ka, mibü aodó, akó mibü ngabyón lar ngabkan pampükü, zitülkus mi ab-olomiamli. ");
INSERT INTO tof_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ngaka, marü obzek kwata blaman tüp, apad klama! Da morroal igósa, ma kürükagab mobe-mobe ugó bumanik. Ma ne banól kwata nóma wamo, ka ma tutul kwata wamo; a ma ne tutul kwata nóma wamo, ka banól kwata wamo.” ");
INSERT INTO tof_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot Zodan buruburudübóna yazilürr. Nae ola gaodó yarilürr. Ene tüp inzan yarilürr wamaka Lodón Didiburr akó wamaka Izipt tüp, tai kókó Zoarr basirr amrran. (Lod Sodom akó Gomorra wirri basirr nis solkwat kolae nyónürr.) ");
INSERT INTO tof_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot ubi bainürr blaman Zodan buruburu tüp apadóm, da wa we bupadórr solomamtaedóbóna tótókóm, tóba blaman elklazapükü. Da ene Eibrram akó Lot inzan bürrgrratürri. ");
INSERT INTO tof_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Eibrram Keinanóm ola ngyabelórr, a Lot ngibürr wirri basirr aodó ngyaben yarilürr Zodan buruburudü, da wa tóba palae müót Sodom wirri basirr minggüpanandó balmelórr. ");
INSERT INTO tof_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom pamkolpam kari kolae koke koralórr; amkoman kolaean tonarr tómbapónónóp Lodka. ");
INSERT INTO tof_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot nóma wamórr Eibrramkagab, da Lod bóktanórr Eibrramka wagó, “Ma tai ugó yazilülün blaman tokom órdóbóna ma nólgab zamngóldóla. ");
INSERT INTO tof_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ma blaman ne tüp ngakandóla, ka sab marü mókyeno akó marü olmalbobatal, metatómpükü. ");
INSERT INTO tof_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ka marü olmalbobatal sab abün ninünümo, wamaka tüp buruako. Darrü oloman sab gaodó nóma ki yaril tüp buru atangóm, da oya sab igósidi gaodó yarile marü olmalbobatal atangóm. ");
INSERT INTO tof_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bupa! Ugó wamlón kokrrap kwata akó taptap kwata, blaman kubdüma ini bwóbdü, zitülkus ka marü akyandóla.” ");
INSERT INTO tof_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eibrram tóba palae müót nanenóp, ngyabenóm we wamórr Mamrren wirri nugup paldó, Ibrron wirri basirr minggüpanan. Da wa Lodka alta ola elórr. ");
INSERT INTO tof_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ene tonarr, Amrrapel, Babilonia bwóban king, Arriok, Elasarr bwóban king, Kedorrlaomerr, Ilam bwóban king, akó Taedal, Goyim bwóban king, ");
INSERT INTO tof_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","bóktan we tómbapónóp gazirrüm ini 5 kingpükü: Berra, Sodom wirri basirran king, Birrsya, Gomorra wirri basirran king, Syinab, Adma wirri basirran king, Syemeberr, Zeboyim wirri basirran king, akó Bila wirri basirran king (ene basirran darrü ngi Zoarr yarilürr). ");
INSERT INTO tof_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Blaman ini 5 kinga gazirrüm we dabinóp Sidim buruburudü. (Kapórr Malu errkya nege.) ");
INSERT INTO tof_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ngaen-gógópan, 12 pailüm, blaman ini 5 wirri basirr kinga tibiób pamkolpampükü, Ilam king Kedorrlaomerrankü zaget koralórr. 13 Ngim paildü i gazirrüm we bainóp wankü oya alakónóm ibü myamem balngomólgum. ");
INSERT INTO tof_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","14 Ngim paildü, Kedorrlaomerr we wamórr gazirrüm tóba aüd gómdamal king tibiób gazirr pampükü. Da ini basirr pamkolpam memokan ⌊ut-ut ninóp⌋: Rrepa pamkolpam Asterrot Karrnaem wirri basirrdü, Zuz pamkolpam Am wirri basirrdü, Em pamkolpam Kirriataem buruburudü, ");
INSERT INTO tof_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","akó Orri pamkolpam Idom podopükü bwóbdü, tai kókó El Parran basirr, ⌊ngüin-koke bwób⌋ minggüpanan. ");
INSERT INTO tof_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Da olgab tübyalüngóp, ama akó Kades wirri basirrdü ogobórr (ene tonarr, ene wirri basirr ngi ugón Enmispat yarilürr). Akó i blaman Amalek pamkolpamab tüp yazebóp. Amorr pamkolpam, i ta inzan nangónóp, nidi ngyaben kwarilürr Azazon Tamarr wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Da ene tonarr, Sodom, Gomorra, Adma, Zeboyim, akó Bila wirri basirr kinga bazebórr, da blamana we ogobórr Sidim buruburudü. I ola bazelórr, tibiób gazirr pampükü, da i gazirrüm we bazebóp, da zangórrón we bórranglórr tibiób gazirr klampükü. ");
INSERT INTO tof_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Ilam king Kedorrlaomerr akó oya aüd gómdamal, Babilonia, Elasarr akó Goyim king nidi kwarilürr, i ene 5 kingpükü gazirr we bókyenóp. Ene gazirr inzan yarilürr: tokom kinga 5 kingpükü bókrralórr tibiób gazirr pampükü. ");
INSERT INTO tof_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim buruburudü ugón abün tarr kugupi asi koralórr. Sodom akó Gomorra king nisa tibiób gazirr pampükü nóma busonónóp, da ngibürra büdülümpükü balóklórr tarr kugupidü. Koke nidi balókórr, i we busuóp ama pokopükü bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ene tokom kinga ene ia-ia elklaza koralórr blaman yazebóp Sodom akó Gomorragab, akó ibü alo kla, da i we ogobórr. ");
INSERT INTO tof_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","I Eibrramón zoretan olom Lot akó oya blaman elklaza ta imarruóp, zitülkus wa ugón Sodom wirri basirrdü ngyaben yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Darrpan pama, nótó busorr gazirr pokodógab, pupainürr Ibrru pam Eibrramka laróga tómbapónórr. Ene tonarr, Eibrram wata ugón ola ngyabelórr, Mamrren wirri nugup paldó. Mamrre tóba nis zonaret nispükü, ngi Eskol akó Anerr, Amorr pam, Eibrramón gazirr gómdamal kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eibrram nóma arrkrrurr ini poko wa, gazirr pama Lotón ipüdóp tibióbkü, da wa 318 gazirr umulbairrün pam ngibaunürr nidi tóbabótórr oya müót basirrdü. Da i ene tokom king tibiób gazirr pampükü tai zutalórr kókó Dan wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Eibrram tóba gazirr pam irrüb we arrgrratórr kopo-kopodó, wa tümünzan yarilürr. Da Eibrram tóba gazirr pampükü ene tokom kingdü yaninürr, da ibü tai kolazutalórr kókó Oba, Damaskus wirri basirr dakla kabe, dorrmetódóbóna. ");
INSERT INTO tof_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eibrram blaman elklaza, Lot, oya zoretan siman olom, tóba elklazapükü, blaman kol akó pamkolpam we zid ninóp, Kedorrlaomerr ne kla yazebórr, da we sakonórr ama tóba ngyaben bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Eibrram nóma tolkomólólórr ene gazirr pokodógab, Kedorrlaomerr akó oya kamdal king memokan ut-ut ne ninóp, da Sodom kinga wamórr oya asenóm Sabe buruburudü. (Ene bwóban darrü ngi módóga: “Kingan Buru-buru”.) ");
INSERT INTO tof_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Da darrü kinga ugón wamórr Eibrramón asenóm. Oya ngi Melkizedek yarilürr, Salem wirri basirran king. Wa tüób brred akó waen imarrurr. Wa dakla Wirri Kwitüm Godón ⌊prrist⌋ yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Wa Eibrramón bles yónürr igó bóktane wagó, “Eibrramón bles ki yó Wirri Kwitüm Goda, tüp a pülpül nótó tónzapónórr. ");
INSERT INTO tof_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Akó mi blamana yagürnórre Wirri Kwitüm God, marü tangdó nótó irrbüne, mankü nidi gazirr kwarilürr.” Da Eibrram blaman elklazadógab ⌊wantent⌋ Melkizedekón ekyanórr, wa ne elklaza yazebórr ene tokom kingdügab. ");
INSERT INTO tof_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom kinga Eibrramka bóktanórr wagó, “Ma kürü pamkolpaman külió, a elklaza ma mobankü yazeb.” ");
INSERT INTO tof_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Eibrram bóktan yalkomólórr oyaka wagó, “Ka kólba tang kwit aindóla ⌊Lodka⌋, Wirri Kwitüm God, tüp a pülpül nótó tónzapónórr, akó ka ini ⌊arüng alkamül-koke bóktan⌋ bóktandóla Godón obzek kwata: ");
INSERT INTO tof_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Ka darrü kla kokean emono marü ne klamko, ia mórrkenyórr barrgüp sye o ia wapór kla amrók sye, zitülkus ma sab myamem igó bóktan-gum wagó, ‘Ka Eibrramón morroal mórrel yórrü.’ ");
INSERT INTO tof_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ka darrü kla koke ipudo kólbankü, a wata gazirr pama ne kla elorre. A kürü aüd gómdamal, Anerr, Eskol, akó Mamrre, kankü nidi ogobórr, i tibiób morroal wata ipüdórre ene elklazadógab.” ");
INSERT INTO tof_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ene klama tómbapón kakóm, ⌊Lodón⌋ bóktana tamórr Eibrramka nuszan wagó, “Ma gumgu, Eibrram; Ka marü adlang klamla. Marü darrem sab kari koke yarile!” ");
INSERT INTO tof_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","A Eibrram bóktanórr wagó, “Lod Godóe! Ma sab kürü laró kókyeno, zitülkus ka olom-koke ngyabendóla? Eliezerr, kürü Damaskus ⌊leba zaget olom⌋, kürü elklaza sab wató yazebe kürü büdül kakóm. ");
INSERT INTO tof_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ma kürü darrü olom koke kókyarró, da kürü darrü müótan leba zaget olom, kürü pabo igósidi sab wató ipüde.” ");
INSERT INTO tof_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Da módóga, Lodón bóktana akó tamórr oyaka wagó, “Ene pama sab marü pabo kokean ipüde. Marü mobanan büba ne siman olom esene, marü blaman elklaza sab wató yazebe!” ");
INSERT INTO tof_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Wa Eibrramón pul basirrdü idódürr, da bóktanórr wagó, “Pülpüldü yazil! Ma wimurr kóbó etang, ma ne gaodó nómadóla atangóm!” Da wa oyaka akó bóktanórr wagó, “Marü olmalbobatal sab inzan korale.” ");
INSERT INTO tof_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eibrram Lodón amkoman yangunürr, da ini zitülkusdü, Lod oya ipadórr ⌊dümdüm tonarr⌋ pamzan. ");
INSERT INTO tof_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ene kakóm, Lod akó bóktanórr darrü poko wagó, “Ka Lod, marü nótó küdódürrü Urr wirri basirrdü, Babilonia pamkolpamdógab, marü moba ini tüp akyanóm.” ");
INSERT INTO tof_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eibrram akó bóktanórr wagó, “Lod Godóe, ka umul ia namulo igó, ka sab ini tüp ipudo?” ");
INSERT INTO tof_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Da Lod oyaka bóktan yalkomólórr wagó, “Darrpan ⌊kau⌋, darrpan óp ⌊gout⌋, akó darrpan siman ⌊sip⌋ azebóm wam. I blaman aüd pail ngarkwat korale. Akó ibüka amngyelóm darrpan nurre akó darrpan kubukubu póyae kupo. Da kürüka simarruke.” ");
INSERT INTO tof_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eibrram blaman ene kla simarrurr Lodka, da Eibrram ekrranórr, da aodó ór nangónóp, nürrgrrütóp, solkwat wa tutul ór darrpan pokodó irrbünürr, akó wa banól ór darrpan pokodó we irrbünürr dümdüm. Ene óra tibiób obzek balóng koralórr. A póyae nis koke ór nangónórr; ibü dudu nüngrinürr. ");
INSERT INTO tof_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Da büdül murr alóng póyaea ene ór angórrón murrdü tóbalóklórr alóngóm. Da Eibrram bag yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Abüsazan bótaolórr, Eibrramón büdül uta simiógürr. Da módóga, wazan büdül ut yarilürr, güm tümüna ugón ngaslaorr, akó wirri guma oya ipadórr. ");
INSERT INTO tof_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Lod oyaka bóktanórr wagó, “Ma wata umul namulo wagó, marü olmalbobatal sab mogob korale ngibürr pamkolpamab bwóbdü. I sab ene pamkolpamabkü leba zaget tómbapónórre, akó ibü kle-kle ngabkan kwarile, 400 pailüm. ");
INSERT INTO tof_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","I ne bwób kolpamabkü zaget kwarile, ka sab ibü ⌊kolaean darrem⌋ nülinünümo. Ene kakóm, i ma sab ugón wirri mórrelpükü pamkolpama tübause olgabi. ");
INSERT INTO tof_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","A mató, ma sab paudi wamo, marü abalbobatal nólamasko. Ma sab morroal barnginwóm myanga wamo gapókdó. ");
INSERT INTO tof_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Marü bobatalab bobatala sab nóma tóbabótóle, Amorr pamkolpamab kolae tonarra tai wirri ugón baine, da marü olmalbobatala sab ugón tóbakone ini bwóbdü.” ");
INSERT INTO tof_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Abüsa nóma bótaorr akó tümün nóma yarilürr, da módóga, nokaman kübül kak akó warri zyóna ugón okaka tübyórri, da ene syórr angórrón murr aodóma aurrürri. ");
INSERT INTO tof_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ene ngürr, Lod ene inzan alkamül-koke tónggapórrón bóktan tónggapónórr Eibrramka, da wa bóktanórr wagó, “Marü olmalbobatal ka sab ini pamkolpamab tüp nókyenónómo, tai wirri tobarrdógab Izipt kantrridü, kókó Yuprreitis wirri tobarrdó: ");
INSERT INTO tof_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keni, Kenas, akó Kadmon pamkolpam, ");
INSERT INTO tof_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Et, Perris, akó Rrepa pamkolpam, ");
INSERT INTO tof_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amorr, Keinan, Girrgas, akó Zebus pamkolpam.” ");
INSERT INTO tof_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Serrae, Eibrramón kol, olmal koke balngólórr oyankü. A oya ma Izipt leba zaget kol asi warilürr, ngi Agarr. ");
INSERT INTO tof_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Serrae bóktanórr Eibrramka wagó, “Gyaurka ma turrkrru. ⌊Lod⌋ kürü piküp kyónürr olmal balngónóm. Da ugó wam, kürü leba zaget ngulmokurpükü utüm. Aprrapórr ma olmal kürünkü nósenónómo oyakagab.” Eibrram Serraen ubi we ipadórr. ");
INSERT INTO tof_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Eibrram 10 pail nóma ngyabenórr Keinanóm, da Serrae tóba Izipt leba zaget kol Agarr we ekyanórr tóba müór Eibrramón kolóm ainüm. ");
INSERT INTO tof_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","I Agarrdi umturri, da oya müp we okyanórr. Agarr igó nóma umul bainürr wagó, wa müppükümo, da wa Serraen kle-kle ngakanóm ugón bainürr. ");
INSERT INTO tof_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Da Serrae bóktanórr Eibrramka wagó, “Eibrram, zitülkus matókla, Agarr ne kürü kle-kle igósidi ngakando. Ka kólba leba zaget kol marü tangdó ungrirrü kolóm, da errkya wa umulo wagó, wa müppükümo, da wa kürü kle-kle igósidi ngakando. Da mibü sab Lod wató ki tyal igó, dümdüm nótóka ini pokodó, ia mató, ta ia kótó!” ");
INSERT INTO tof_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eibrram oyaka bóktan yalkomólórr wagó, “Turrkrru, marü leba zaget kol moba tangdómo. Ma tónggapó oyaka, ma ne kla gyagüpi amandóla.” Da Serrae amkoman kle-kle ngakanóm we bainürr Agarrón, da Agarr we busorr oyakagab. ");
INSERT INTO tof_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","⌊Lodón anerrua⌋ Agarrón aróbdó omrranórr, ⌊ngüin-koke bwóbdü⌋. Ene ne arób yarilürr, Surr bwóbdü tótók kwat kabedó yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Da wa bóktanórr wagó, “Agarr, Serraen leba zaget kol, ma nubógab katóka akó ma nubó tótókdóla?” Agarr bóktan yalkomólórr wagó, “Ka busodóla kólba wirri koldógab, Serrae.” ");
INSERT INTO tof_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Lodón anerrua oya wyalórr wagó, “Ugó alkomól moba wirri koldó, da oya ubi ipadólónke, wa ne poko bóktale.” ");
INSERT INTO tof_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Lodón anerrua akó bóktanórr wagó, “Ka sab marü olmalbobatal amkoman abün ninünümo; sab nabe yarile atangóm.” ");
INSERT INTO tof_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Lodón anerrua akó bóktanórr darrü poko oyaka wagó, “Turrkrru, ma errkya müppükümla, da marü sab siman olom yarile. Ma oya sab Isma-el ngi ngyesilke, zitülkus Lod marü yón gyaur kuri arrkrrue. ");
INSERT INTO tof_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Marü siman olom sab nurr ⌊donkizan⌋ pam yarile; wa sab blaman pamkolpampükü bóka bamgüle, akó pamkolpama usakü ta bóka bamgünórre, akó wa sab gazirr tonarre tebe-tebe ngyaben yarile tóba blaman zonaretaldógab.” ");
INSERT INTO tof_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agarr Lodón ngi igó ngyesilürr, oyaka nótó bóktanórr: “Asen God”, zitülkus wa bóktanórr wagó, “Ka ia amkoman Godón esena, kürü nótó asenda?” ");
INSERT INTO tof_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Da we zitülkusdü, ene arób ngi igósidi ngyesildako, “Be-err La-ae Rro-i”. Oya küp módóga: “Arról Godón arób, kürü nótó asenda”. Errkya asine, ini tonarr, Kades akó Berred ini wirri basirr nis aodó. ");
INSERT INTO tof_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Da Agarr Eibrramónkü siman olom we ilngumilürr, da Eibrram ngi ngyesilürr Isma-el. ");
INSERT INTO tof_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agarr Isma-elón nóma ilngumilürr, Eibrram ugón 86 pail yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Eibrram 99 pail nóma yarilürr, Lod⌋ oyaka okaka tübyónürr, da bóktanórr wagó, “Ka Wirrian Arüng God; ma morroal ngyabelón kürü obzek kwata, akó ma kolae tonarr koke tómbapón namulo, igósüm marükwata pamkolpama zitül-koke pokodó koke bóktan kwarile wagó, ma kolae kla tónggapónórró. ");
INSERT INTO tof_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Da ka sab igósidi kólba alkamül-koke tónggapórrón bóktan ingrino, matóka kótó, akó ka sab marü atang nabe, abün olmalbobatal mülino.” ");
INSERT INTO tof_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eibrram obzek kwata simbalkalórr, da obzek tüp elkomólórr. God oyaka bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“A wa kótó, ini kürü alkamül-koke tónggapórrón bóktane marünkü. Ma sab abün pamkolpamab abbobat namulo bwób-bwób ini tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Marü sab myamem igó koke ngimlianórre, Eibrrambóka. Marü ngi ma inzan yarile: Eibrra-am, zitülkus ka marü abbobatóm kuri mina bwób-bwób ini tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ka marü sab amkoman abün olmalbobatal mülino; ka sab abün olmalbobatal dódórr ninünümo marükagab akó ibü sab tibióban ngyaben bwób korale. Akó kinga sab marükagab togoble. ");
INSERT INTO tof_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Ka sab kólba ini alkamül-koke tónggapórrón bóktan metatómpükü ingrino, kótó ka mató akó marü olmalbobatal marü kakóm, marü sab elnga ne olmalbobatala tóbabótóle. Da ka marü God akó marü olmalbobatalab God namulo, marü kakóm. ");
INSERT INTO tof_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Keinan blaman tüp, ma errkya ne mogob pama ngyabendóla, ka sab marü mókyeno metatómpükü akó marü ne olmalbobatala tóbabótóle marü kakóm; da ka sab ibü God namulo.” ");
INSERT INTO tof_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Da God akó Eibrra-amka bóktanórr wagó, “A mató, marüka wata kürü alkamül-koke tónggapórrón bóktan asi yarile mamoanóm, akó marü olmalbobataldó, marü kakóm, marü sab elnga ne olmalbobatala tóbabótóle. ");
INSERT INTO tof_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ini kürü alkamül-koke tónggapórrón bóktane marünkü akó marü olmalbobatalabkü marü kakóm, yabü mamoanóm: yabü aodó, e blaman simanal olmalab ⌊gyabi sopae singgalgón kwarilünke. ");
INSERT INTO tof_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Da e yabiób sab inzan bangón kwarilünke, da ene gyagüpi amanik timam yarile igó, ene alkamül-koke tónggapórrón bóktan asine kótóka yadi, mibü aodó. ");
INSERT INTO tof_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ne paila tótókdako solkwat, e blaman simanal olmalab gyabi sopae singgalgón kwarilo, 8 ngürr nóma korale. E yabióban simanal olmalan koke singgalgónane inzan, a blaman simanal olmal yabü müótüdü nidi tóbabótólórr, akó wa nibiób bumióglürr manie mogob pamkolpamdógab ta inzan, yabü óe koke nidipako. ");
INSERT INTO tof_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ia yabü müótüdü nidi tóbabótóle, ta ia e manie bumiógnane, e ibü sab wata inzan bangón koralo. Kürü alkamül-koke tónggapórrón bóktan wata igósidi metat asi yarile yabü büb murrdü. ");
INSERT INTO tof_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ne pama ini timam koke nótó ipüde, oya sab metatómpükü zirrapórre tóba pamkolpamdógab, zitülkus wa kürü alkamül-koke tónggapórrón bóktan kuri alkamüle.” ");
INSERT INTO tof_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God Eibrra-amka akó bóktanórr wagó, “A marü kol Serrae, ma myamem igó ngilian-gu, Serrae. A oya ngi ma Serra warile. ");
INSERT INTO tof_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ka oya bles wino, akó ka ta marü sab siman olom mókyeno oyakama. Ka sab oya igó bles wino, igósüm wa sab ngibürr bwóbdü pamkolpamab aipbobat warile, da pamkolpamab kinga sab oyakagab togoble.” ");
INSERT INTO tof_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Eibrra-am akó obzek kwata simbalkalórr, da obzek tüp elkomólórr, da ngüóng apoanórr. Wa tóbananka bóktanórr wagó, “Siman oloma sab ia tómtómóle 100 pail pamdógab? Serra ia olom ilngumile ini 90 pail ngarkwatódó?” ");
INSERT INTO tof_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eibrra-am bóktanórr Lodka wagó, “Morroal igósa, wata Isma-el ki yaril ene olom, kürü pabo sab nótó ipüde marü obzek kwata!” ");
INSERT INTO tof_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God igó bóktanórr wagó, “Koke, a marü kol Serra sab siman olom ilngumile marünkü, da ma sab oya ngi ngyesilke Aesak. Ka kólba alkamül-koke tónggapórrón bóktan sab ingrino wankü akó oya olmalbobatalabkü metatómpükü, sab nidi tóbabótóle oya kakóm. ");
INSERT INTO tof_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A Isma-elónkwata, ka marü murrkrrua: turrkrru, ka sab oya bles ino. Ka sab oya küppükü ino, oya ta akó amkoman abün olmalbobatal ilino. Oya sab 12 simanal olmal kwarile, da i sab singüldü balngomól pam kwarile tibiób abün pamkolpam amarrum, akó ka oya bwób ta inzan wirri ino. ");
INSERT INTO tof_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","A kürü ini alkamül-koke tónggapórrón bóktan, ka wata sab Aesakónkü metatómpükü ingrino, Serra sab ne olom ilngumile marünkü, ini tonarr sab pail.” ");
INSERT INTO tof_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","God tóba bóktan nóma elakónórr Eibrra-amka, wa oyakagab we kwit kasilürr. ");
INSERT INTO tof_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wata ene ngürrdü, Eibrra-am yazebórr, tóba siman olom Isma-el, oya müótüdü nidi tóbabótórr, akó wa tüób manie nibiób bumiógürr, blaman simanal oya müótüdü, tibiób gyabi sopae singgalgónóm, oya Godzan yalórr. ");
INSERT INTO tof_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Eibrra-am 99 pail nóma yarilürr, wa ini timam ugón ipadórr, ");
INSERT INTO tof_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","akó oya olom Isma-el ama ugón 13 pail yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","I nizana ene timam we ngürr ipadrri. ");
INSERT INTO tof_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Akó ne simanal olmal Eibrra-amón müótüdü nidi tóbabótólórr, akó wa nibiób bumióglürr manie mogob pamkolpamdógab, i blamana timam yazebóp ene ngürrdü. ");
INSERT INTO tof_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","⌊Lod⌋ akó we okaka tübyónürr Eibrra-amka Mamrren wirri nugup paldó, Eibrra-am tóba palae müót mamtaedó abüs ururdü nóma mórran yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Wa kwit nóma yazilürr, da módóga, wa aüd pam nósenóp bórrangde tóba obzek kwata, ngibürr kan ngarkwat. Wa ibü nóma nósenóp, bupadórr, büsai-büsai we wamórr, ibü basenóm. Wa wakósingül we nülkamülürr tüpdü, da obzek tüpdü elkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Da wa we bóktanórr wagó, “Gyaurka, kürü lod, ma moba obzek kwata kürüka ne morroal nóma seserró, da ma kya büsai moba zaget pam arrgrratgu. ");
INSERT INTO tof_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kya kubó kari nae sokol ki sidüdnüm yabiób wapór bagulüm. E kya ini nugup murrdü ngón ngabagó. ");
INSERT INTO tof_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ka kubó kari brred pokopükü sidüdo. E küsil arüng iade ipüdane, da e kubó igósidi bazebke. E kürü palae müótüdüzan kuri togoba, da ka kya yabü zaget pama morroal tónggapónón yabüka.” Ene aüd pama wagó, “Tónggapó, ma enezan namüla.” ");
INSERT INTO tof_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Eibrra-am büsai-büsai Serraka we wamórr bóktanóm palae müótüdü. Wagó, “Büsai, ma aüd ngarkwat morroal plaoa yazeb, da alkomen akó ngibürr taptapan plaoa imngul!” ");
INSERT INTO tof_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Eibrra-am akó büsai-büsai wamórr ngabyón lar ne koralórr. Darrü morroal baritürrün ⌊kau⌋ kupo we upadórr, da tóba ⌊leba zaget olom⌋ we ekyanórr, büsai aungüm. ");
INSERT INTO tof_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ene kakóm, Eibrra-am ini kla simarrurr: karianbóka zürük bairrün kauan ngóm mor, kerrkyat ngóm mor, akó ne kau kupo yungürr. Da ene pam we nülinóp. Izan alo kwarilürr, Eibrra-am ibü bókyan-bókyan minggüpanan nugup murrdü zamngól yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","I oya we imtinóp wagó, “Ia marü kol Serra nego?” Eibrra-am ibüka we yalkomólórr wagó, “We palae müót kugupidümo.” ");
INSERT INTO tof_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ene pamdógab darrü Lod yarilürr, da ene wató bóktanórr wagó, “Ka sab pail, ini ngarkwat, amkoman tolkomolo marüka. Serra ugón siman olompükü warile!” Serra ugón oya kakotagab arrkrru warilürr, palae müót mamtaedógab. ");
INSERT INTO tof_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eibrra-am akó Serra ugón blaman myang akó epep bairrün namülnürri. Serra ene olmal balngón ngarkwat arrgrratórrón warilürr. ");
INSERT INTO tof_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Módóga, Serra ngüóng apónórr, da tóbaka we bóktanórr wagó, “Kürü okómóp kolaea; ka epep kuri baina. Kürü sab olom alngumil ubia ia küpüde? Koke. Kürü müór ta myanga!” ");
INSERT INTO tof_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da Lod Eibrra-amka we bóktanórr wagó, “Serra ngüóng iade apóne, akó wa iade bóktóne wagó, ‘Ka ia amkoman sab olom eseno? A ka go epepla!’ ");
INSERT INTO tof_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ka Lodla, darrü kla kürü obzek kwata müp babula tónggapónóm. Ka sab pail tolkomolo angrirrün ngarkwatódó. Serra ugón siman olompükü warile!” ");
INSERT INTO tof_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Serran guma upadórr, da we balpinürr wagó, “Ka go koke ngüóng apóna!” Da Lod bóktan we yalkomólórr wagó, “Üa! A ka ta umul baina, ma ngüóng apóna!” ");
INSERT INTO tof_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ene solkwat, pama we bazebórr tótókóm. Eibrra-am ibü we nolngomólóp kwat-kwat, yawal boweanóm. I ogoblórr kókó Sodom wirri basirr nólgab esenóp buruburudü. ");
INSERT INTO tof_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Lod tóba gyagüpi tótókde wagó, “Ka ia Eibrra-amkagab iniko, ka ne poko tónggapónóm kaindóla? ");
INSERT INTO tof_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Oya olmalbobatala sab abün bairre akó sab wirri arüngpükü bórrónge ini bwóbdü, akó ka sab blaman bwób-bwób pamkolpam ini tüpdü bles ninünümo oyakama. ");
INSERT INTO tof_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ka oyakagab koke iniko, ka ne poko tónggapónóm kaindóla, zitülkus ka oya amaikürrü tóba olmal akó olmalbobatal byalóm, kürü kwat mamoanóm, Lod nótókla. I sab morroal akó dümdüm tulmil nóma tómbapón kwarile kürü obzek kwata, da ka sab tómbapono ene morroal, ka Eibrra-amón ne ⌊alkamül-koke bóktan⌋ iliórrü.” ");
INSERT INTO tof_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Da Lod Eibrra-amka bóktanórr wagó, “Sodom a Gomorra pamkolpama kari kolae tonarr koke tómbapóndako, da ka ngibürrab yón taegwarr kuri arrkrrua, i nibióbka tómbapóndako ini kolae tonarr. ");
INSERT INTO tof_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Da ka errkyadan ola abindóla tai asenóm igó, i ia ene kolae tonarr tómbapóndako, ka ngibürrab yón taegwarrzan arrkrrudóla. Ene kolae tonarr inzan koke nóma yarile, da ka sab tai ugón umul baino.” ");
INSERT INTO tof_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ene pam nisa Eibrra-am akó Lod ibükagab we azyórri. I tib ama Sodombóna aurrürri. A Eibrra-am wata Lodón obzek kwata we zamngólórr. ");
INSERT INTO tof_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Da Eibrra-am Lodón minggüpanan we wamórr, da imtinürr wagó, “Ia ma sab ene dümdüm ngyaben pamkolpam nümrüknümo ene kolae tonarr pamkolpampükü? ");
INSERT INTO tof_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Aprrapórr ola ne 50 dümdüm ngyaben pamkolpama nóma ngyaben kwarile ene wirri basirrdü, ia ma sab kulaino? Ma ia oya kolae tonarr koke arrgono ini 50 dümdüm ngyaben pamkolpamabbókamde? ");
INSERT INTO tof_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ma gyaurka ini poko sab tónggapón-gu: ene dümdüm ngyaben pamkolpam akrranóm ene kolae tonarr pamkolpampükü! Dümdüm ngyaben pamkolpam dadan tonarre angón-gu kolae tonarr pamkolpampükü! Ma ene poko sab gyaurka koke tónggapón-gu! Ma ini blaman dudu tüpdü zaz nótókla, ma ia ⌊dümdüm tonarr⌋ koke tómbapón namulo?” ");
INSERT INTO tof_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Lod bóktan we yalkomólórr wagó, “Ka ne 50 dümdüm ngyaben pamkolpam nóma nósenónómo Sodom wirri basirrdü, ka sab ene dudu basirran kolae tonarr arrgono ibübókamde.” ");
INSERT INTO tof_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eibrra-am akó we bóktanórr Lodka wagó, “Gyaurka Lod, ka akó kya marüka bóktanón, enana ka karimakurla marü obzek kwata amtinüm. ");
INSERT INTO tof_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Aprrapórr ola ne 45 dümdüm ngyaben pamkolpam nóma kwarile, a 50 koke, ia ma sab ene wirri basirrdü pamkolpam blaman kolae ninünümo ene 5 kolpamabbókamde?” Lod bóktan yalkomólórr wagó, “Ka sab ene wirri basirr koke kulaino, ka ola ne 45 dümdüm ngyaben pamkolpam nóma nósenónómo.” ");
INSERT INTO tof_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eibrra-am akó Lodón imtinürr, “Aprrapórr ma ne ola 40 dümdüm ngyaben pamkolpam nóma nósenónómo, da ia?” Da Lod bóktan yalkomólórr wagó, “Ola ne 40 dümdüm ngyaben pamkolpam nóma kwarile, ka sab ibübókamde koke kulaino.” ");
INSERT INTO tof_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Da Eibrra-am akó we bóktanórr wagó, “Lod, ma gyaurka kürüka ngürsilüm bain-gu. Ma kürü ok kino akó bóktanóm? Aprrapórr ma ne ola 30 dümdüm ngyaben pamkolpam nóma nósenónómo?” Da Lod bóktan we yalkomólórr wagó, “Ka sab ene wirri basirr koke kulaino, ka ola ne 30 dümdüm ngyaben pamkolpam nóma nósenónómo.” ");
INSERT INTO tof_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eibrra-am akó bóktanórr wagó, “Gyaurka, ka akó kya marüka bóktanón. Aprrapórr ma ne ola 20 dümdüm ngyaben pamkolpam nóma nósenónómo?” Lod bóktan we yalkomólórr wagó, “Ola ne 20 dümdüm ngyaben pamkolpam nóma kwarile, ka sab ibübókamde koke kulaino.” ");
INSERT INTO tof_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eibrra-am akó we bóktanórr wagó, “Gyaurka, ma kürüka ngürsilüm bain-gu. Kürü ubi kya akó dómdóm bóktanóma. Ola ma ne aprrapórr 10 dümdüm ngyaben pamkolpam nóma nósenónómo?” Lod wagó, “Ola ne 10 dümdüm ngyaben pamkolpam nóma kwarile, ka sab ibübókamde koke kulaino.” ");
INSERT INTO tof_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Lodón bóktana nóma blakónórr Eibrra-amdi, wa tóba kwata we wamórr. A Eibrra-am we alkomólórr tóba ngyaben marrgudü. ");
INSERT INTO tof_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tai simaman nóma yarilürr, ene anerru nisa we abzilürri Sodom wirri basirrdü. Lot ugón ene wirri basirran barrbün mamtaedó mórran yarilürr. Wa ibü nóma nósenórr, wa we bupadórr ibü asenóm. Wakósingül we nülkamülürr da obzek tüp elkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Da ibüka bóktanórr wagó, “Kürü lod nis, ka yabü zaget pamla. Gyaurka, mi kya kürü müótüdü ogobón. E kubó wapór ola bagulamke akó umtulamke ini irrüb. E sab irrbianande türsümülamke tótókóm e nóla tótókdamli.” Da i we bóktarri wagó, “Koke, ki kubó popa pamkolpamab kwób bazen pokodó umtuli.” ");
INSERT INTO tof_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","A Lot arüng-arüng we natolórr, kókó dómdóm pokodó i ubi bairri, da i usakü we ogobórr oya müótüdü. Ibünkü morroal alo we bamngulóp akó ist-koke brred. Da i we elop. ");
INSERT INTO tof_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ibü utüm tótók küsil nóma yarilürr, Sodom wirri basirrdügab dudu pam, tai küsildügaba kókó myang, Lotón müót kal-kal yangónóp. ");
INSERT INTO tof_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Da i Lotka górrgónóp wagó, “Ei? Ene pam nis negamli, marüka nidi turri ini irrüb? Ó-ó? Da ugó tümanik; kibü ubi usakü utüma!” ");
INSERT INTO tof_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot we burruanórr ibü basenóm. Mamtaepükü murrausürr, ");
INSERT INTO tof_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","da ibüka we bóktanórr wagó, “Gyaurka, kürü gómdamal, e ini kolaean poko tónggapón-gu! ");
INSERT INTO tof_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Tübarrkrru, kürü óp olom nisamli, pampükü ut umul-kókamli. Ka kubó ibü pulkakak tüdüdo yabüka, da ene kubó yabüka yarile, ia poko tónggapónóm inkü. A ini pam nisdü darrü kla tónggapón-gu. Zitülkus módóga, i kürü murrdüzan namüli, ka ibü kubó morroal ngankono.” ");
INSERT INTO tof_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","I ma oyaka igó bóktónóp wagó, “Usi ane!” I akó we bóktónóp wagó, “Ini go mogob pama tamórr, da wa ma mibü zaz bainüm iade kainda? Ki marüka kubó amkoman kolaean kla tómbapórre, a we pam nisdü tai inzan koke!” Da i ma tai ugón Lotka arüng ipüdóp, da oya kakota yanenónóp, mamtae kulainüm. ");
INSERT INTO tof_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Módóga, ene anerru nisa Lotón kakotagab we amorratrri tibióbka müót kugupidü, da mamtae murrausürri. ");
INSERT INTO tof_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Da i ene pam, nidi bórranglórr müót mamtaedó, tai küsildügab kókó myang, ilküküp we tümün ninóp, da ibü gaodó koke yarilürr ene müót mamtae asenóm. ");
INSERT INTO tof_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ene pam nisa Lotón we imtirri wagó, “Ia marü ngibürr pamkolpam ala asiko? Ia mónangal, simanal olmal, ópal olmal, ó minggüpanan kolpam asi nóma kwarile, da ibü imarru algab, ");
INSERT INTO tof_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","zitülkus ki kubó ini wirri basirr kulaini. ⌊Lod⌋ ngibürrab yón taegwarr kuri arrkrrue, ini basirr pamkolpama kolae tórrmen tulmil nibióbka tómbapóndako, da wa kibü ugósüm zirrtapóne ini wirri basirr kulainüm.” ");
INSERT INTO tof_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Da Lot tóba ngul olom nisab ilküp pamdó we wamórr bóktanóm. Wa ibüka we bóktanórr wagó, “Büsai! Ini bwób amgütam, zitülkus Lod ini wirri basirr kulaindase!” A oya ngul olom nisab ilküp pam nisab gyagüpitótók igó yarilürr wamaka, wa ibüka tiz poko bóktanda. ");
INSERT INTO tof_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Sisazan balgón yarilürr, ene anerru nisa Lotón arüngi we yalórri wagó, “Büsai, moba olmalkol yazeb, da buso! Koke ne nóma, Lod kubó ini wirri basirr nóma kolae sine, yabüpükü ta kubó kolae tirre!” ");
INSERT INTO tof_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Wazan kalgüppókal atang yarilürr, ene pam nisa Lotón olmalkolpükü tangdó emorrarri, da zidüm we imarrurri wirri basirrdügab, zitülkus Lod ibüka gyaur yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","I ibü basirr kugupidügab nóma simarrurri, da darrü ene pama wagó, “Zidüm algab busuam! Da kakóm azilgu. Ini buruburudü amilgu, a kubó podopükü bwóbdü busuamke yabiób akrran-gum.” ");
INSERT INTO tof_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot bóktanórr wagó, “Gyaurka, kürü lod, ola koke! ");
INSERT INTO tof_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ma moba obzek kwata kürüka morroal seserró, marü zaget olom, akó marü gyaur asi yaril kürü arról zid ainüm, da ene podopükü bwóbdü ka ia busuo; ka gaodó kokela ola abzilüm. Kürü ini kolaea kubó kórrpyene ini ao pokodó, da ka nurrótoko. ");
INSERT INTO tof_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Turrkrru, basirr aum módógase. Wirri kan kokea, kürü wa ola buso gaodóma. Wata kari basirro, da ka kubó ola zid baino.” ");
INSERT INTO tof_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Darrü ene anerrua oyaka bóktanórr wagó, “Taia, ka marü morroal mino, ma kürü enezan kümtina. Ka kubó ene basirr koke kulaino, ma ne kwata bóktóna. ");
INSERT INTO tof_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Da büsai ola busuam; ka ini tonarr gaodó kokela darrü kla tónggapónóm, kókó e nóma babzilo ola.” (Ene basirr ngi igósidi ngyesilóp Zoarr. Oya küp módóga: “kari”.) ");
INSERT INTO tof_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot ene Zoarr basirr nóma emrranórr, abüs ugón banikürrün yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Da Lodón arünga kwitümgab kolae ilang urpükü ingülküp we selókórr ene wirri basirr nisdü, wamaka ngupa amilda. ");
INSERT INTO tof_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Da wa ene basirr nis akó ene dudu buruburu, ume kyamül akó nugup zid blaman nürrbitóp. ");
INSERT INTO tof_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","A Lotón kola kakota yazilürr, da kokrrap solt ingülküpüm we bümzazilürr zamngólórrón. ");
INSERT INTO tof_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Irrbianande darrü ngürr Eibrra-am türsümülürr, da we alkomólórr, wa Lodón obzek kwata ngaen-gógópan ne zamngólórr. ");
INSERT INTO tof_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Eibrra-am olgabi nóma yazilürr Sodom akó Gomorrabóna, akó blaman ene buruburu, da módóga, wirri amel-amel nokama tüngülürr ene bwóbdügab, wamaka wirri buna baebda. ");
INSERT INTO tof_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","God ene buruburudü wirri basirr nis ene inzan nóma kolae nyónürr, wa gyagüpi wamórr Eibrra-am ne klamóm yatorr. Da wa Lotón zid yónürr ene kolaedógab, wa ene basirr nóma nümrükürr, Lot ne ngyaben yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Solkwat, Lot tóba ngul olom nispükü Zoarr we amgatórr, ama podopükü bwóbdü wamórr, zitülkus wa gum yarilürr Zoarróm ngyabenóm. Wa tóba olom nispükü kugupi bapórrón wirri ingülküpdü ngyaben yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Darrpan ngürr ngaen ngul oloma zoretódó we bóktanórr wagó, “Mibü aba myang kuri baine, da ala myamem darrü pam babula müórüm ainüm akó olmal basenóm, pamkolpamazan kaindako blaman bwób-bwób. ");
INSERT INTO tof_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yao, mi errkya mibiób ab waen amyandamli gorrgorran ngitanóm. Ene kakóm, mi kubó usakü iade bazurruo. Ini tonarre, mibü küp elnga asi kwarile mibiób abdógab.” ");
INSERT INTO tof_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ene irrüb, i tibiób ab waen emyarri. Ngaen ngul oloma we umtulürr tóba abpükü. Aba ta koke umul bainürr igó, oloma nóma umtulürr akó nóma saogórr. ");
INSERT INTO tof_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Akó darrü ngürr ngaen ngul oloma zoretbóka wagó, “Turrkrru, ka irrüb umtula mibü abpükü. Da mi akó errkya ini irrüb waen amyandamli. Ini irrüb kubó e ma usadi umtuli. Ini tonarre, mibü küp sab elnga asi kwarile mibiób abdógab.” ");
INSERT INTO tof_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Da módóga, i akó tibiób ab we emyarri ene irrüb. Zoreta natókórr, abpükü we umtulürr. Aba ta akó koke umul bainürr igó, oloma nóma umtulürr akó nóma saogórr. ");
INSERT INTO tof_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Da Lotón ngul olom nisa bikóm inzan tonarre nóserri tibiób abdógab. ");
INSERT INTO tof_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ngaen ngul oloma siman olom esenórr, da ngi we ngyesilürr Moab. Errkya Moabbóka ne pamkolpam ngibliandako, i oya küpko. ");
INSERT INTO tof_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Akó zoreta ta siman olom ilngumilürr. Oya ngi we ngyesilürr Ben-Ami. Errkya Amon ne pamkolpamko, i oya küpko. ");
INSERT INTO tof_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Eibrra-am olgabi we bupadórr, da zaorrón ngyabenkü inzan wamlórr, kókó wa Negeb emrranórr, ⌊ngüin-koke bwób⌋. Wa kya karianbóka ini nis bwób aodó ngyabelórr: Kades akó Syurr. Solkwat, wa akó we bupadórr, da mogob pamzan Gerrarr wirri basirrdü bupso ngyabenóm wamórr. ");
INSERT INTO tof_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Wa olazan ngyabelórr, wa pamkolpam igó nilóp tóba kolbóka wagó, wa oya bólbóto. Da Abimelek, Gerrarr basirran king, tóba darrü zaget pam we zirrapónórr Serran ódódóm oyaka. Da Abimelek we upadórr tóba kolóm. ");
INSERT INTO tof_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ene irrüb, God Abimelek-ka nusi we tamórr. God bóktanórr wagó, “Turrkrru! Ma büdül pamla, zitülkus ma ne kol upuda, oya müór asine!” ");
INSERT INTO tof_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek ma Serradi koke umturri, da wa we bóktanórr wagó, “⌊Lod⌋, ma wa sab kürü iade kómkolo kólba pamkolpampükü? Ka umul-kók namüla igó, ka kolae tonarr tónggapóna. ");
INSERT INTO tof_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Eibrra-am tüób igó yarilürr wagó, ‘Wa kürü bólbóto,’ akó Serra ta tüób inzan warilürr wagó, ‘Wa kürü bólbóta.’ Ka ini amkoman morroal moboküpi tónggapóna.” ");
INSERT INTO tof_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Lod ene dadan nusdü akó bóktanórr wagó, “Ka umulóla, marü gyagüpitótók igósa, wamaka ma dümdümla, da ka marü mólena kürüka kolae tonarr tónggapón-gum. Módóga, ka marü igósidi mürrmüta oya amurrgum. ");
INSERT INTO tof_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Da errkyadan ene kol ugó walkomól tóba müórdü. Oya müór ⌊prropeta⌋, da wa sab marünkü tóre eko-e, da ma sab igósidi ngyabelo. A ma ne oya koke nóma walkomolo müórdü, ma umul namulo, ma sab nurrótoko moba blaman pamkolpampükü.” ");
INSERT INTO tof_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Irrbianande darrü ngürr Abimelek türsümülürr, tóba ngi pam we ngibaunürr, da wa blaman kla we adrratórr ne pokoa tómbapónórr nusdü. Ene pam ta wirri guma yazebórr. ");
INSERT INTO tof_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek Eibrra-amón ngyaunürr, da we yalórr wagó, “Ma ia laró poko tónggapóna kibüka? Ka marüka ia laró kolae tónggapóna, da ma kürü igósidi kyórrü wirrian kolae tonarr tónggapónóm kólba pamkolpampükü? Ma kürüka ne kla tónggapóna, ma kokean ki tónggapóna!” ");
INSERT INTO tof_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Da Abimelek Eibrra-amón imtinürr wagó, “Ma namügüm gyagüpi wama tiz agósüm moba kolbóka?” ");
INSERT INTO tof_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eibrra-am bóktan we yalkomólórr wagó, “Ka kólbaka igó bóktan namülnürrü: ‘Darrü olom ini pokodó babulana Godón gum angónóm, da i sab kürü kómkólórre kólba kolanbókamde.’ ");
INSERT INTO tof_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ene go amkoman, wa ta kürü bólbóto: kibü darrpan ab, a aip ma koke. Da kürü igósidi gaodó yarilürr oya amiógüm. ");
INSERT INTO tof_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kürü God nóma kyalórr kólba aban müót basirr amgatóm, ka oya we wyalórró wagó, ‘Ma sab kürüka moba morroal tonarr inzan kwata pupain namülünke: mi negama aurrli, ma igó byal namülünke magó kürübóka, “Wa kürü bólbóta.” ’” ");
INSERT INTO tof_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Módóga, Abimelek ene gyaur elklaza simarrurr: ⌊sip⌋, ⌊kau⌋, akó ópal a simanal ⌊leba zaget⌋ kolpam, da Eibrra-amón siliónürr. Serran ta we walkomólórr Eibrra-amka. ");
INSERT INTO tof_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek oyaka we bóktanórr wagó, “Turrkrru, ini ne bwóbe blaman kürüne; ma ne tüp pokom ubi baino, da ma we ngyabelónke.” ");
INSERT INTO tof_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Wa Serraka igó bóktanórr wagó, “Turrkrru, ka marü bólbót 1,000 ⌊silba⌋ poko alióndóla, blaman marü pamkolpam igó byalóm wa, ma darrü kolae koke tónggapóna. Ma errkya dümdümla.” ");
INSERT INTO tof_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelek Eibrra-amón kol Serran nóma upadórr, da Lod ini zitülkusdü olmal balngón-kokean ngintinóp blaman kol Abimelekón müótüdü. Da Eibrra-am Godka tóre we ekorr. God Abimelekón, oya kol akó leba zaget ngul olmal dólóng ninóp, da arüng we nülinóp olmal balngónóm. ");
INSERT INTO tof_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","⌊Lod⌋ Serraka ⌊gail tonarr⌋ yarilürr, wa enezan bóktanórr. Wa oyankü tónggapónórr, wa ne ⌊alkamül-koke bóktan⌋ okyanórr. ");
INSERT INTO tof_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Serra bikóm ipadórr, da siman olom we ilngumilürr Eibrra-amón myangande, tai we ngarkwatódó, God ne ngarkwat ngilianórr oya amtómólóm. ");
INSERT INTO tof_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eibrra-am tóba siman olom, Serra noan ilngumilürr oyankü, ngi we ngyesilürr Aesak. ");
INSERT INTO tof_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Da oya God ne tulmil ekyanórr tónggapónóm, da wa Aesakón ⌊gyabi sopae ugón singgapinürr⌋, wa 8 ngürr nóma yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Eibrra-am 100 pail nóma yarilürr, Aesak ugón tómtómólórr oyankü. ");
INSERT INTO tof_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Serra we bóktanórr wagó, “God kürü ngüóngan ngigütanórr barnginwómpükü. Sab blamana nidi barrkrrue ini poko, i ta ngüóng korale kankü. ");
INSERT INTO tof_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ia nótó ki bóktóne Eibrra-amka wagó, ia Serra sab amkoman olom ngayóne? “Darrü olom umul babul yarilürr Eibrra-amón azazilüm wagó, Serra sab olom ngayóne. A errkya, ka ma oyankü olom kuri ilngumila, enana wa myangana!” ");
INSERT INTO tof_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aesak morroal dódórr bailürr, kókó aipa ngómdügab ne ngürr amanikürr. Da ene ngürr Eibrra-am ugón wirri garrirr tóre tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","A Serra Isma-elón esenórr, Izipt leba zaget kol Agarr ne olom ilngumilürr Eibrra-amónkü, tóba olom Aesakón ngüóng angyalde. ");
INSERT INTO tof_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Da Eibrra-amón we yalórr wagó, “Ugó zirrzwapó ini leba zaget kol tóba olompükü! Zitülkus módóga, kürü olom Aesak marü elklaza marü büdül kakóm koke ki arrgrrüte ini leba zaget kolan olompükü!” ");
INSERT INTO tof_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Módóga, ini bóktana Eibrra-amón wirri müp ekyanórr, zitülkus Isma-el ta oya olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","A God Eibrra-amka we bóktanórr wagó, “Ma müp apadgu moba olomankwata akó moba leba zaget kolankwata! Tónggapó marü Serra ne poko mile, zitülkus wata sab Aesakón olmalbobatal marü olmalbobatalbóka ngiblianórre. ");
INSERT INTO tof_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A ka ta sab Isma-elón abün olmalbobatal ilino akó i tibióban kantrridü ngyaben kwarile, zitülkus wa ta marü küpe.” ");
INSERT INTO tof_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Irrbianande darrü ngürr Eibrra-am türsümülürr, Agarrón ngibürr alo kla uliónürr, akó naepükü lar sopae bele, oya tupodó emelórr, da we zirrzwapónórr tóba siman olompükü. Agarr a Isma-el we bupadürri, da ⌊ngüin-koke bwóbdü⌋ we apól namülnürri. Ene ngüin-koke bwób Berrsyiba wirri basirr minggüpanan yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ene lar sopae beledó naea nóma blakónórr, Agarr tóba siman olom kari tugupanan tiz bórean-bórean nugup murrdü ingrinürr. ");
INSERT INTO tof_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Agarr tebe natókórr, da barrkyanan kan we mórran-mórran bainürr. Wa tóbaka bóktanórr wagó, “Ka kokela kólba olom asenóm nurrótókde.” Módóga, yarrmurrande yónüm we bainürr, wa enezan mórran warilürr. ");
INSERT INTO tof_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","God ene siman olom bóktan bómgól arrkrrurr, da ⌊Godón anerrua⌋ kwitümgab Agarrka we tóbtanórr wagó, “Agarr! Ia laró müpa? Ma gumgu! God marü oloman bóktan bómgól kuri arrkrrue wa utürrün nege. ");
INSERT INTO tof_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ugó bupa, olom zamngól-zamngólan ngita, da tangdó emoa zao-zao ainüm, zitülkus ka sab oya abün olmalbobatal ilino akó i tibióban wirri kantrridü ngyaben kwarile.” ");
INSERT INTO tof_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Da God oya ilküp nis we nóbzelórr, da wa nae badu we esenórr. Wa ola natókórr, lar sopae bele errngamórr, tóba olom we emyanórr. ");
INSERT INTO tof_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Isma-el nóma dódórr bainürr, God oyaka asi yarilürr. Wa ngüin-koke bwóbdüzan ngyaben yarilürr, wa bügür pamóm we bainürr. ");
INSERT INTO tof_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Wa Parran ngüin-koke bwóbdüzan ngyaben yarilürr, aipa oya kol kwat we tónggapónórr Izipt kantrri kol amiógüm. Da wa we zumiógürr. ");
INSERT INTO tof_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ene tonarrdó, Abimelek akó tóba gazirr pamab singüldü wirri ngi pam, ngi Paekol, Eibrra-amka bóktarri wagó, “God mankü asine ma blaman ne poko tómbapóndóla. ");
INSERT INTO tof_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Da ma ⌊arüng alkamül-koke bóktan⌋ ugó tónggapó Godón obzek kwata. Ma sab kürü myamem ilklió alión-gu kólba olmal akó olmalbobatalpükü. Ma kürü morroal kyó ma ne kantrridü ngyabendóla mogob pamzan, ka marükazan namülnürrü morroal tonarr.” ");
INSERT INTO tof_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Da Eibrra-am bóktanórr wagó, “Ka arüng alkamül-koke bóktan igó tónggapóndóla!” ");
INSERT INTO tof_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Eibrra-am murrkurr bóktan sidódürr Abimelekka tóba darrü nae baduankwata, Abimelekón zaget pama arüngi ne kla arrbainóp. ");
INSERT INTO tof_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Da Abimelek we bóktanórr wagó, “Ka umul-kókla, ene poko nótó tónggapóne! Ma kürü ngaen-gógópan koke küzazilürrü, a ka wata errkya arrkrrua.” ");
INSERT INTO tof_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Módóga, Eibrra-am Abimelekón ngibürr ⌊sip⌋, ⌊gout⌋, akó ⌊kau⌋ iliónürr, da ene kakóm, i nizana ⌊alkamül-koke tónggapórrón bóktan⌋ we ingrirri. ");
INSERT INTO tof_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eibrra-am akó 7 sip kupo tibi-tibi irrbünürr. ");
INSERT INTO tof_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek Eibrra-amón imtinürr wagó, “Küp ia laróga, ma ene 7 sip kupo tibi-tibi iade amóna?” ");
INSERT INTO tof_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eibrra-am bóktan we yalkomólórr wagó, “Ini 7 sip kupo yazeb kürü tangdógab, kürü amkoman angunüm ma kubó abino wagó, ini nae badu kótó ilüngürrü.” ");
INSERT INTO tof_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ene bwób ngi igósidi ngyesilóp Berrsyiba, zitülkus ene pam nisa arüng alkamül-koke tónggapórrón bóktan ola ingrirri. ");
INSERT INTO tof_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Alkamül-koke tónggapórrón bóktan angrina nóma blakónórr Berrsyibam, Abimelek akó Paekol, tóba gazirr pamab singüldü wirri ngi pampükü, we alkomórri ama Pilistia bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ene kakóm, Eibrra-am darrü tamarrisk nugup zid we irtümülürr Berrsyibam. Eibrra-am ene pokodó Lodón ngian we ngilialórr oya ótókóm, ⌊Ngarkwat-koke Arról⌋ God. ");
INSERT INTO tof_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eibrra-am Pilistia isab kantrridü mogob pama ngyaben yarilürr wirri kokrrap ngarkwatóm. ");
INSERT INTO tof_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ngibürr tonarr kakóm, God Eibrra-amón apókórr: Wa ngisilianórr wagó, “Eibrra-am!” Eibrra-am bóktan yalkomólórr wagó, “Ka inamüla!” ");
INSERT INTO tof_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Da God we bóktanórr wagó, “Ma moba siman olom ipa, moba darrpanan olom, ma noaka ubila moboküpdü, Aesak. Da wam, Morria tüpdü. Ola urdü dudu igasilke kürü akyanóm darrü podo kwitüdü, ka marü sab umul mino.” ");
INSERT INTO tof_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Da Eibrra-am irrbianande saogórr. Wa tóba ⌊donki⌋ tónggapónórr bupadóm. Wa ibü yazebórr, tóba zaget pam nis akó tóba olom Aesak. Da gaodó ur nóma emótórr, Godón akyan kla aungüm, wa we wamlórr ene pokodó, God nóla tótókóm yalórr. ");
INSERT INTO tof_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Aüd ngim ngürrdü, Eibrra-am singül kwata nóma yazilürr, ene bwób barrkyanan kandógab esenórr. ");
INSERT INTO tof_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Da wa tóba zaget pam nisdü we bóktanórr wagó, “E ae namülam, ini donkipükü. Ka kólba olommokurpükü tótókdóla aum, Godón ⌊ótókóm⌋, da ki kubó akó tolkomóli yabüka.” ");
INSERT INTO tof_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eibrra-am ur kur ipadórr akyan kla aungüm, da Aesakón tupodó we emngyelórr. A wa tüób ur setan kla a turrik nüpadórr. Da i nizana darrpan mün aurrnürri. ");
INSERT INTO tof_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Da Aesak tóba abdó Eibrra-amka bóktanórr wagó, “Ba!” Eibrra-am bóktan yalkomólórr wagó, “Ia, kürü olom?” Aesak imtinürr wagó, “Ma turrkrru, mibü ur setan kla akó ur kur asine, a mibü ma ⌊sip⌋ kupo nega aungüm Godón akyanóm?” ");
INSERT INTO tof_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eibrra-am bóktan yalkomólórr wagó, “Mibü kalma God sip kupo tüób tókyene aungüm, kürü olom.” Da i nizana darrpan mün we aurrnürri. ");
INSERT INTO tof_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ene bwób nóma emrrarri, God Eibrra-amón ne bwóbüm yalórr, Eibrra-am ⌊alta⌋ ola elórr. Ene kakóm, Eibrra-am ur yazebórr, da dümdüm irrbülürr ene alta kwitüdü. Tóba olom Aesakón nizan tang akó wapór nis sye-i we nómelóp, kwit yónürr da dudu we igasilürr altadó, setan-koke ur kwitüdü. ");
INSERT INTO tof_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Tang adrratórr, da turrik ipadórr Aesakón amkalóm. ");
INSERT INTO tof_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","⌊Lodón anerrua⌋ kwitümgab we ngisilianórr wagó, “Eibrra-am, Eibrra-am!” Eibrra-am bóktanórr wagó, “Ka inamüla.” ");
INSERT INTO tof_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Anerrua bóktanórr wagó, “Ma moba tang olomdó angrin-gu! Oyaka darrü poko tónggapón-gu. Ka errkya kuri umul baina, ma Godón gum angóndóla, zitülkus ma moba olom kürü gum-koke yangóna, marü ne darrpanan olome.” ");
INSERT INTO tof_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eibrra-am kwit yazilürr, da módóga, siman sip we esenórr banómórrón nugup kopodó, oya gara bongreanórr nugup tizdü. Da Eibrra-am wamórr, ipadórr, alta kwitüdü dudu igasilürr aungüm Godón akyanóm tóba oloman pabodó. ");
INSERT INTO tof_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Eibrra-am ene bwób ngi we ngyesilürr wagó, “⌊Lod⌋ mibü aliónda.” Da errkya ini tonarr, pamkolpama inzan bóktandako wagó, “Lodón podo kwitüdü, wa sab mibü inzan tüliónórre.” ");
INSERT INTO tof_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Lodón anerrua Eibrra-amka akó nis ngim tóbtanórr kwitümgab ");
INSERT INTO tof_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","wagó, “Lod inzan bóktanda: zitülkus ma ini kla tónggapóna, akó ma moba olom kürü gum-koke yangóna, marü ne darrpanan olome, ka kólbanan ngidü igó ⌊arüng alkamül-koke bóktan⌋ ingrino: ");
INSERT INTO tof_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ka sab marü amkoman bles mino. Ka marü olmalbobatal sab abün ninünümo ini wimurrzanko kwitüm akó nóreszanko malu kabedó. Marü olmalbobatala sab ibü wirri basirr azeb kwarile, usakü nidi bókrróne. ");
INSERT INTO tof_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Marü olmalbobataldógab, ini tüpdü blaman bwób-bwób pamkolpama sab morroal ipüdórre, zitülkus ma kürü bóktan kuri amiga.” ");
INSERT INTO tof_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Da i we alkomórri zaget pam nisdü. I blamana we bakolórr ama Berrsyiba. Eibrra-am ola ngyabelórr ene tonarr. ");
INSERT INTO tof_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ngibürr tonarr kakóm, Eibrra-amón darrü oloma izazilürr wagó, “Turrkrru! Milka simanal olmal balngónórr Na-orrónkü, marü zoret: ");
INSERT INTO tof_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz, ngaen pam, Buz, oya zoret, Kemuel (Arramón ab), ");
INSERT INTO tof_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Azo, Pildas, Yidlap, akó Betuel.” ");
INSERT INTO tof_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel Rrebekan ab yarilürr. Milka ini 8 simanal olmal balngónórr Na-orrónkü, Eibrra-amón zoret. ");
INSERT INTO tof_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Na-orrón solo kol, ngi Rreuma, oyankü ta simanal olmal balngónórr: Teba, Ga-am, Ta-as, akó Ma-aka. ");
INSERT INTO tof_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Serra 127 pail nóma warilürr, wa ugón nurrótókórr Kirriat Arrba wirri basirrdü (darrü ngi módóga: Ibrron), Keinan tüpdü. Eibrra-am palae müótüdü bangrinürr yón amtom akó yón gyaurüm tóba kol Serrakamóm. ");
INSERT INTO tof_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Da Eibrra-am tóba kolan büdüldügab bupadórr, da wa we bóktanórr Et pamkolpamdó wagó, ");
INSERT INTO tof_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ka mogoba bupso ngyabendóla yabü aodó. Yabü ia darrü tüp poko babula yabükagab amiógüm? Ka igósidi kubó kólba kol büdül gapókdó ola ungrino.” ");
INSERT INTO tof_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Et pamkolpama bóktan we yalkomólóp Eibrra-amka wagó, ");
INSERT INTO tof_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Wirri pam, kibü turrkrrunünüm. Ma wirri arüng balngomól pamla kibü aodó. Ma moba kol büdül kibünüm morroalan ingülküpdü tónggapórrón gapókdó ungrino. Darrü oloma kubó koke badóle marü gapók akyanóm moba kol büdül angrinüm.” ");
INSERT INTO tof_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Da Eibrra-am bupadórr, wakósingül nülkamülürr, tóba singül we tüp elkomólórr Et pamkolpamab obzek kwata, ene tüp pamkolpam nidi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Bóktan we yalkomólórr wagó, “Yabü ne ubi asi nóma yarile kürü kolan büdül büb angrinüm yabünüm darrü gapókdó, da kürü bóktan tübarrkrru; e kubó kürü ngidü Eprronón imtinamke, Zoarrón siman olom. ");
INSERT INTO tof_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ene igósüm, wa kubó sel sine Makpela bwóbdü oya nadü kugupi apórrón wirri ingülküpse, oya ngaon bwób ngarkwat negse. Wa kürü ene tüp poko ki kókya yabü ilküpdü, tóba dudu angrirrün darrem ngarkwatódó, kibü blamanab gapók bwóbüm yabü aodó.” ");
INSERT INTO tof_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eprron ola asi yarilürr ene mórran pokodó tóba Et kolpampükü, ene wirri basirran barrbün mamtaedó. Wa bóktan yalkomólórr Eibrra-amka blaman pamkolpamab obzek kwata wagó, ");
INSERT INTO tof_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Koke, kürü wirri pam, kürü kurrkrru. Ka marü ene tüp poko akyandóla, ó ka marü ene kugupi apórrón wirri ingülküppükü akyandóla ene tüp pokodó. Ka akyandóla kólba pamkolpamab obzek kwata. Gapókdó ungri moba kol büdül.” ");
INSERT INTO tof_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eibrra-am akó wakósingül nülkamülürr, da singül tüp elkomólórr ene tüp pamkolpamab obzek kwata, ");
INSERT INTO tof_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ó bóktan we yalkomólórr Eprronka ibü blamanab arrkrrum wagó, “Gyaurka. Marü ubi ne nóma yarile, kürü kurrkrru. Kubó ka dudu darrem kla nókyenónómo ene tüp pokoankü. ⌊Sipa⌋ kürükagab, da ka kubó ola kólba kol büdül ungrino.” ");
INSERT INTO tof_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eprron bóktan yalkomólórr Eibrra-amka wagó, ");
INSERT INTO tof_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Kürü wirri pam, kürü kurrkrru; ene tüpan ngarkwat módóga, 400 ⌊silba⌋ mani poko. Mi gódamiamli; kürüka akó marüka ene wirri ngarkwat kokea. Ene marü mobakama. Ungri moba kol büdül gapókdó.” ");
INSERT INTO tof_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eibrra-am abinürr Eprronón bóktandó. Wa 400 silba mani pokoab müp ngarkwat we ipadórr, Eprron ne ngarkwat ngilianórr Et pamab obzek kwata. Ene silba mani pokoab müp we ngarkwatódó yarilürr, bumióg bwóbdü ne ngarkwatódó ingrinóp. ");
INSERT INTO tof_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Da Eibrra-am Eprronón tüp poko ene inzan amiógürr Makpela bwóbdü, abüsa nólgabi banikda Mamrre bwóbdügab. Wa tüp, ene kugupi apórrón wirri ingülküp, akó blaman ne nugup zid kwarilürr yazebórr, tai kókó tüp poko ngarkwat ne yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Ene elklaza Eibrra-am ugón yazebórr Et kolpamab obzek kwata, nidi togobórr wirri basirran barrbün mamtaedó. ");
INSERT INTO tof_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ene kakóm, Eibrra-am tóba kol Serran gapókdó we ungrinürr Makpela tüp pokodó, abüsa nólgabi banikda Mamrre bwóbdügab (ene wa Ibrron), Keinan tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Et pamkolpama ene tüp poko akó kugupi apórrón wirri ingülküp Eibrra-amón tangdó inzan ugón ingrinóp, tóba pamkolpamab gapók balüng bwóbüm. ");
INSERT INTO tof_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Eibrra-am amkoman tai myang yarilürr ene tonarrdó. Oya ⌊Lod⌋ bles yónürr blaman kwata. ");
INSERT INTO tof_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Darrpan ngürr Eibrra-am bóktanórr tóba müótüdü singüldü zaget pamdó, Eibrra-amón elklaza nótó ngabkalórr, wagó, “Moba tang kürü waurr grasana zirrsapó. ");
INSERT INTO tof_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ma kürünkü ⌊arüng alkamül-koke bóktan⌋ singri errkyadan Lodón ngidü, tüp a pülpül God: ma sab kürü siman olomankü darrü kol kokean tududo aini Keinan pamkolpamab ópal olmaldógab, ka nisakü ngyabendóla. ");
INSERT INTO tof_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","A ma sab wamo kürü kólbanan tüpdü, akó kürü kólbanan zitül kolpamdó. Ma sab kürü siman olom Aesakónkü kol olgabi upudo.” ");
INSERT INTO tof_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Oya zaget pama imtinürr wagó, “Ka sab ia kaino, ene kol ne sab ubi koke nóma warile kürüka akyanóm ini bwóbdü? Ia ka sab marü olom Aesakón yalkomolo ene bwóbdü, ma nólgab tamórró?” ");
INSERT INTO tof_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Eibrra-am bóktan yalkomólórr wagó, “Ma umul-umul namulo, ma kürü olom sab kokean yalkomolo ola. ");
INSERT INTO tof_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Da Lod, kwitüm God, kürü nótó küdódürr kürü aban zitül pamkolpamdógab akó kólba amtómól tüpdügab, wa kürüka arüng alkamül-koke bóktan igó tóbtanórr wagó, ‘Ka sab ini tüp marü olmalbobatal nókyenónómo.’ Wa tóba anerru singül kwata zirrapóndase, igósüm ma sab kol olgabi upudo kürü siman olomankü. ");
INSERT INTO tof_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ene kol ne sab ubi koke nóma warile mankü tótókóm, ma sab bago-o kürü ene arüng alkamül-koke bóktandógab. A ma sab kürü siman olom ola kokean yalkomolo.” ");
INSERT INTO tof_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Eibrra-amón zaget pama tóba tang tóba wirri paman waurr grasana zirrapónórr, da wa tóba arüng alkamül-koke bóktan ingrinürr, oya Eibrra-am ne bóktan ekyanórr inikwata. ");
INSERT INTO tof_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Eibrra-amón zaget pama 10 ⌊kamel⌋ yazebórr tóba wirri paman kameldógab, da wa abün morroal elklazapükü bupadórr, ama Mesopotamia bwóbdü wamlórr, ene wirri basirrdü Eibrra-amón zoreta Na-orr nóla ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Wa ola nóma abzilürr, da kamel mórran-mórran ninóp nae badu minggüpanan, wirri basirr kalkuma; ugón simam yarilürr, kolab nae bait ngarkwat nóma amrranda. ");
INSERT INTO tof_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Zaget pama tóre ugón ekorr wagó: “Lodóe, kürü wirri pam Eibrra-amón God, gyaurka, ma kürü kókya errkya ini ngürr ka nebókamóm tama, akó ma morroal tonarr okaka simzazilke kürü wirri pam Eibrra-amka. ");
INSERT INTO tof_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ka zamngólórrón inamüla, nae badu kabedó. Küsil kola bausdako ene wirri basirran pamkolpamdógab nae baitüm. ");
INSERT INTO tof_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kubó inzan ki yarilün: ka kubó ne küsil koldó bóktono kagó, ‘Gyaurka, moba nae bele tüp solkomól kürü anónóm’, akó wa ne kubó nóma bóktóne wagó, ‘Enó, akó ka kubó marü kamel ta nae nómyenónómo,’ da wata wató ki waril, ma ne kol zumanike moba zaget pam Aesakónkü. Inzande, ka kubó umul namulo wagó, ma morroal tonarr kuri pupo sina kürü wirri pamdó.” ");
INSERT INTO tof_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ene zaget pamazan tóre yarilürr, da módóga, Rrebeka ugón katókórr ene wirri basirrdügab, tóba mariti tónggapórrón nae bele tupodó sidódlórr. Wa Betuelón óp olom warilürr. Betuel Milkan siman olom yarilürr. Milka Na-orrón kol warilürr. Na-orr Eibrra-amón zoret yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rrebeka kari agurr ngulmokur koke warilürr. Wa müór amióg ngarkwatódó warilürr, pampükü ut umul-kók. Nae badudü abinürr, nae bórrngamórr tóba mariti tónggapórrón nae beledó, akó tügasilürr. ");
INSERT INTO tof_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Eibrra-amón zaget pama büsai-büsai wamórr oya asenóm ó oya we umtinürr wagó, “Gyaurka, ma ia kürü nae sokol koke kókyeno anónóm marü nae beledógab?” ");
INSERT INTO tof_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Wa bóktan yalkomólórr wagó, “Taia, kürü wirri pam, ugó enó.” Wa tóba mariti tónggapórrón nae bele büsai solkomólórr ama tangdó. Da wa oya nae we emyanórr. ");
INSERT INTO tof_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Oya nae amyana nóma blakónórr, wa bóktanórr wagó, “Marü kamel ka ta kubó nae nómenónómo, kókó ibü nae anón ubia nóma blakóne.” ");
INSERT INTO tof_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Wa büsai nae ekanórr, ne nae bórrngamórr nae beledó, ama wirri nae kurrópdü. Wa akó büsai natókórr nae badudü, ngibürr nae baitüm kamelabkü anónóm, kókó blamana ngarkwatódó nae enenóp. ");
INSERT INTO tof_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ene zaget pama oya piküpan ngazokalórr umul bainüm wagó, Lod oya agóltagól ia morroal küppükü kuri sine, ta ia koke. ");
INSERT INTO tof_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ene kamelab nae anóna nóma blakónórr, zaget pama ⌊gold⌋ syók rring ipadórr, oya syókdü angrinüm, akó nis gold tang püid tang nisabkü ipadórr. ");
INSERT INTO tof_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Wa we umtinürr wagó, “Ma ia kürü koke kilo, ma noan óp olomla? Ia marü aban müótüdü ut kan asine kibü utüm ini irrüb?” ");
INSERT INTO tof_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rrebeka bóktan yalkomólórr wagó, “Ka Betuelón ngul olomla. Milka Betuelón ilngumilürr Na-orrkagab. Ka Na-orr akó Milka ibü bobatla. ");
INSERT INTO tof_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kibü müótüdü kamelab ut akó alo kan asise, akó yabü ta kan asise utüm kinkü.” ");
INSERT INTO tof_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ene zaget pama wakósingül nülkamülürr, singül tüp elkomólórr, da Lodón we ⌊ótóklürr⌋. ");
INSERT INTO tof_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Wa bóktanórr wagó, “Mi blamana Lodón yagürnórre, kürü wirri pam Eibrra-amón God. Wa tóba morroal tonarr koke irrmatórr kürü wirri pamdógab akó wa koke alkamülürr, wa kürü wirri pam ne ⌊alkamül-koke bóktan⌋ ekyanórr. A kótó, Lod kürü dümdüm kolngomóle kólba wirri paman zoretan müót kolpamdó.” ");
INSERT INTO tof_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rrebeka busorr müótüdü, tóba aipan müót kolpam büzazilüm ne pokoa tómbapóne. ");
INSERT INTO tof_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rrebekan siman bólbót asi yarilürr. Oya ngi Leiban. Wa büsai-büsai wamórr Eibrra-amón zaget pam sisingül akyanóm nae badudü. ");
INSERT INTO tof_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Wa bólbótan syókdü ne rring akó nizan tangdó tang püid nóma nósenóp akó nóma arrkrrurr oya bólbóta ne poko izazilürr, pama oyaka ne poko bóktanórr, da we wamórr ene pamdó, da módóga, oya we esenórr kamel minggüpanan zamngólórrón nae badu kabedó. ");
INSERT INTO tof_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Leiban oyaka bóktanórr wagó, “Yao, mató ma bles airrünla Lodkagab. Ma aini iade zamngóldóla? Ka müót kuri tónggapóna akó ka ut bwób tónggapóna marü kamelabkü.” ");
INSERT INTO tof_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Eibrra-amón zaget pama müótüdü wamórr. Leibanón zaget pama elklaza selókóp kamelab büb kwitüdügab. I kamelab büdül twal akó alo kla tübarrmünürr, akó nae sidüdóp Eibrra-amón zaget pamankü akó wa ne pampükü tamórr, ibü wapór bagulüm. ");
INSERT INTO tof_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Leibanón zaget pama alo sirrbünóp oya obzek kwata. Wa bóktanórr wagó, “Ka ngaen-gógópan koke elo-o, kókó ka kubó adrrüto, ka ne bóktanankwata tama.” Leiban bóktan yalkomólórr wagó, “Taia. Kibü kya kóbó tüzazilnüm!” ");
INSERT INTO tof_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Da wa bóktanórr wagó, “Ka Eibrra-amón zaget pamla. ");
INSERT INTO tof_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Lod kürü wirri pam ngaru bapón-koke bles syónürr. Wa wirri mórrel pamóm kuri baine. Lod oya we kla kuri siliónürr; ⌊sip⌋ a ⌊gout⌋, ⌊kau⌋, silba a gold, zaget pam a zaget kol, akó kamel a ⌊donki⌋. ");
INSERT INTO tof_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Kürü wirri paman kol Serra epep nóma warilürr, siman olom ilngumilürr oyankü. Eibrra-amón blaman ne elklaza kwarilürr, wa tóba siman olom kuri iliónürr. ");
INSERT INTO tof_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kürü wirri pama kyalórr oyankü arüng alkamül-koke bóktan angrinüm wagó, ‘Ma sab kürü siman olomankü kol kokean upudo ini Keinan pamkolpamab ópal olmaldógab, ka nibiób tüpdü ngyabendóla. ");
INSERT INTO tof_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","A ma kürü aban kolpamdó wam, akó kürü kólbanan zitül zonaretaldó, kol amkünüm kürü siman olomankü.’ ");
INSERT INTO tof_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ka Eibrra-amón imtirrü kagó, ‘Ka sab ia kaino, ini kola ne kürüka koke nóma tókyene?’ ");
INSERT INTO tof_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Da Eibrra-am bóktanórr wagó, ‘Lod, ka ne Godpükü agóldóla, sab tóba anerru zirrsapóne marü ene kwat küppükü ainüm. Ene igósüm, ma sab kol upudo kürü kólbanan zitül zonaretaldógabi akó kürü aban kolpamdógab. ");
INSERT INTO tof_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Sab, ma kürü zitül kolpamdó nóma wamo, ma ene arüng alkamül-koke bóktandógab bago-o, enana i sab bangórre oya akyanóm marü. Ma sab igósidi bago-o.’ ");
INSERT INTO tof_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ini ngürr ka nae badudü nóma tama, ka tóre inzan ekoa kagó, ‘Lodóe, kürü wirri pam Eibrra-amón God, marü ubi ne nóma yarile, gyaurka, ma kürü kwat dümdüm sekya, ka nebókamóm tama. ");
INSERT INTO tof_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Errkyadan ka zamngólórrón inamüla nae badu kabedó. Ngulmokura kubó nóma tubrrune nae aitüm, akó ka oyaka nóma bóktono kagó, “Gyaurka, ma ia kari nae sokol koke kókyeno anónóm moba nae beledógab?” ");
INSERT INTO tof_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Wa ne kubó nóma bóktóne wagó, “Enó, akó ka marü kamelabkü ta kubó nae baito,” da wata wató ki waril, Lod ne kol zumanike kürü wirri paman siman olomankü.’ ");
INSERT INTO tof_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Ka tóre nóma elakónóma kólba moboküpdü, Rrebeka ugón tubrrune. Mariti tónggapórrón nae bele tupodó sidüde. Wa we abine badudü akó nae ite. Ka oyaka bóktóna kagó, ‘Gyaurka, kya kürü nae sokol kókya anónóm.’ ");
INSERT INTO tof_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Wa büsai nae bele tupodógab sabine, da we bóktóne wagó, ‘Ugó enó! Ka kubó marü kamel ta nae nómenónómo.’ Ka enóna, akó wa kamel ta nae nómyerre. ");
INSERT INTO tof_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Da ka oya we umtina wagó, ‘Ma ia noan óp olomla?’ Wa bóktan salkomóle wagó, ‘Ka Betuelón ngul olomla. Milka Betuelón ilngumilürr Na-orrkagab. Ka Na-orr akó Milka ibü bobatla.’ Da ka oya syók rring zotena, akó tang nis tang püid nótena. ");
INSERT INTO tof_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ka wakósingül nülkamüla, singül tüp elkomóla, Lodón we ótók namüla. Ka Lodón yagüra, kürü wirri pam Eibrra-amón God, kürü nótó kolngomóle dümdüm kwatana kürü wirri paman zoretan óp bobat apadóm Eibrra-amón siman olomankü. ");
INSERT INTO tof_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ma ne ubi nóma baino morroal tonarr kürü wirri pam amtyanóm amkoman moboküpi, da ma kürü kyal. Koke ne nóma, gyaurka, kürü ma umul-umulan ngigüta. Igósidi ka ma sab gyagüpitótók ipudo nadü kwat mamoanóm.” ");
INSERT INTO tof_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Leiban a Betuel bóktan yalkomórri wagó, “Ini Lodkagaba. Ki myamem darrü poko koke bóktóni marüka, ia morroal o kolae. ");
INSERT INTO tof_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Da wóni, Rrebeka. Upa da ugó wam! Wa sab marü wirri paman siman oloman kolóm ki bai, Lod tüób enezan emtyanórr.” ");
INSERT INTO tof_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Eibrra-amón zaget pama ibü bóktan nóma arrkrrurr, wa wakósingül nülkamülürr akó singül tüp elkomólórr Lodón obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Da Eibrra-amón zaget pama gold akó silba tómbapórrón büb püti ain kla yusürr akó dokyanan mórrkenyórr, da Rrebekan ⌊gyaur kla⌋ uliónürr. Wa akó simam naret akó aip morroalan wirri darrem gyaur kla nüliónürr. ");
INSERT INTO tof_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Da Eibrra-amón zaget pam akó wankü nidi kwarilürr, ibü alongalo we yarilürr. Akó ene irrüb we amaikóp. I nóma tübarsinürr, Eibrra-amón zaget pama bóktanórr wagó, “Kürü ugó zirrkapónam kólba wirri pamdó.” ");
INSERT INTO tof_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Da Rrebekan siman bólbót akó aipa bóktan yalkomórri wagó, “Kya ini ngul olom kinkü ae ki warilün aüd ngürrüm, ó aprrapórr 10 ngürr. Ene ngürr kakóm, wa sab ugón ki nató.” ");
INSERT INTO tof_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Eibrra-amón zaget pama ma bóktan yalkomólórr wagó, “Kürü arrmatgu. Lod kürü kwat wató morroal küppükü sine. Kürü ugó zirrkapónam kólba wirri pamdó alkomólóm.” ");
INSERT INTO tof_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Rrebekan aip a bólbóta bóktarri wagó, “Kya tóba kóbó ngizaunam, da mi kubó umtirre, wa kubó ia warile.” ");
INSERT INTO tof_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","I Rrebekan tibióbkagab ngizaunóp, da umtinóp wagó, “Ma ia ubi baina ini pampükü tótókóm?” Rrebeka bóktan we yalkomólórr wagó, “Ka ubi baina tótókóm!” ");
INSERT INTO tof_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","I Rrebeka akó oya ngakan zaget kol ibü nilóp Eibrra-amón zaget pampükü tótókóm, akó wa ne pampükü tamórr. ");
INSERT INTO tof_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","I Rrebekan bles winóp ini bóktan oporpükü wagó, “Kibü bólbót, marü sab abün olmal ki kwarilün, akó marü sab atang-koke olmalbobatal ki kwarilün. Marü olmalbobatala sab ene pamab basirrpükü idi ki yazebnóm, usakü nidi bókrróne!” ");
INSERT INTO tof_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rrebeka tüób akó tóba zaget ngul olmala elklaza tómbapónóp, da kamelab kwitüdü we bamselórr. I zaget paman solkwat we zutalórr. Eibrra-amón zaget pama Rrebekan ene inzan upadórr. Da i ene bwób we amgütóp. ");
INSERT INTO tof_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aesak tóba ngyaben marrgu ama we tónggapónórr Negeb ⌊ngüin-koke bwóbdü⌋, Keinan tüpdü. Da wa Be-err La-ae Rro-i nae badu amgatórr. ");
INSERT INTO tof_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Darrpan ngürr, ene simam abüs, wa popa agólóm wamórr pórrpótyapdó, da kwit nóma yazilürr, wa kamel nósenóp tóbakabóna tótókde. ");
INSERT INTO tof_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rrebeka kwit nóma sazilürr, Aesakón sesenórr, da wa we tübinürr tóba kameldógab, ");
INSERT INTO tof_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ó Eibrra-amón zaget pam we imtinürr wagó, “We ia nadü pama tótókda mibü basenóm ini pórrpótyapdó?” Ene zaget pama bóktan yalkomólórr wagó, “We kürü wirri pame.” Rrebeka tóba obzek ngalao mórrkenyórr poko ipadórr, tóba obzek ngablaorr. ");
INSERT INTO tof_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ene zaget pama adrratórr Aesakka, blaman wa ene ne poko tómbapólórr. ");
INSERT INTO tof_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ene kakóm, Aesak Rrebekan Serran palae müót kugupidü udódürr. Wa Rrebekan tóba kolóm we upadórr. Oya ⌊moboküpdü ubi⌋ oyaka yarilürr. Rrebeka Aesakón zao-zao yónürr tóba aip Serran büdülankwata. ");
INSERT INTO tof_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eibrra-am darrü kol akó zumiógürr, ngi Keturra. ");
INSERT INTO tof_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Wa Eibrra-amónkü simanal olmal balngónórr: Zimrran, Zoksan, Medan, Midian, Isbak, akó Sua. ");
INSERT INTO tof_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Zoksan ibü abóm bainürr: Syeba akó Dedan. Da Dedanón olmalbobatal idi kwarilürr: Asyurr pamkolpam, Letus pamkolpam, akó Leum pamkolpam. ");
INSERT INTO tof_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","A Midianón simanal olmal idi kwarilürr: Epa, Eperr, Anok, Abida, akó Elda-a. Ini blaman Keturran olmalbobatal koralórr. ");
INSERT INTO tof_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eibrra-am Aesakónkü blaman kla bimgatórr oya ne kla koralórr. ");
INSERT INTO tof_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","A wa enezan ngyabelórr, Eibrra-am tóba ngibürr simanal olmal gyaur kla nülinóp, wa nibiób balngenórr ngibürr koldó. Da ibü metatómpükü we zirrnapónóp tóba olomdógab, Aesak, abüsa nólgabi banikda, ene tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Eibrra-am blaman kókó 175 pailüm ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Wa dómdóm ngón we semanórr, da nurrótókórr wirri kokrrap ngyaben kakóm, oya ne abün morroal pail kwarilürr. Da wa tóba abalbobatal nómrrónóp, ngaen nidi nurrbarinóp. ");
INSERT INTO tof_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Oya olom nis Aesak a Isma-el oya Makpelan kugupi apórrón wirri ingülküpdü gapókdó ingrirri, Eprronón tüp pokodó, Zoarrón siman olom, tüób Et pam, abüsa nólgabi banikda Mamrre bwóbdügab. ");
INSERT INTO tof_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ene wa we tüp pokoa, Eibrra-am ne kla amiógürr Et pamdógab. Eibrra-amón we ingrirri oya kol Serra ne warilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Eibrra-amón büdül kakóm, God oya olom Aesakón bles syónürr. Da Aesak Be-err La-ae Rro-i badu minggüpanandó we ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ini Isma-elón olmalbobatalab ngiko, Eibrra-amón siman olom Agarrkagab. Agarr wa Serran ⌊leba zaget⌋ kol warilürr, tüób Izipt kol. ");
INSERT INTO tof_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ini wa ama Isma-elón simanal olmalab ngiko (igó arrbürrün, ngaen pamdógab kókó blakón pam amrran): ngaen pam Nebayot, Kedarr, Adbe-el, Mibsam, ");
INSERT INTO tof_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO tof_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad, Tema, Zeturr, Napis, akó Kedema. ");
INSERT INTO tof_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ini Isma-elón simanal olmalab ngiko. 12 Zitül singüldü balngomól pamóm idi bainóp. Ibü kolpama tibiób basirr akó marrgu we ngi ngibasilóp. ");
INSERT INTO tof_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isma-el blaman kókó 137 pailüm ngyabelórr, da wa tóba dómdóm ngón we semanórr, da we nurrótókórr. Da wa tóba abalbobatal nómrrónóp, ngaen nidi nurrbarinóp. ");
INSERT INTO tof_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Oya olmalbobatala ene bwóbdü ngyabenónóp Abilamgab kókóta Syurr amrran, abüsa nólgabi banikda Izipt órdóbóna, kwat-kwat Asirria aodó. I tibi-tibi bwóbdü ngyabenónóp tibiób ngibürr zonaretaldógab. ");
INSERT INTO tof_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ini Eibrra-amón olom Aesakón olmalbobatalab ngiko. Eibrra-am Aesakón ab yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aesak 40 pail nóma yarilürr, wa Rrebekan ugón zumiógürr, Betuelón óp olom. Betuel Padan Arram bwób pam yarilürr. Rrebeka tüób Leibanón bólbót warilürr, Arram bwób olom. ");
INSERT INTO tof_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aesak ⌊Lodka⌋ tóre ekorr tóba kolankwata, zitülkus wa olmal balngón-koke kol warilürr. Lod oya tóre arrkrrurr, da oya kol Rrebeka bikóm we esenórr. ");
INSERT INTO tof_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Da ene olom nisa tibiób bumiógtübumióg namülnürri aipan bikómdü, akó wa bóktanórr wagó, “Ia kürüka ini pokoa iade tómbapónda?” Da wa Lodón amtinüm natókórr. ");
INSERT INTO tof_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Da Lod oyaka tóbtanórr wagó, “Nis bwób zitül pam nis marü bikómdümamli, akó nis bwób zitül pam nisa sab marü bikómdügab turri, da bürrgrrüti; darrü sab wirri arüng pam yarile tóba kamadódógab, akó naret sab zoretan tangdó yarile.” ");
INSERT INTO tof_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ene ngürr nóma semrranórr Rrebekan mórranóm, da módóga, nis siman olom nis namülnürri oya bikómdü. ");
INSERT INTO tof_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ngaen-gógópan nótó tómtómólórr, wa óe-óe yarilürr; oya dudu büb igó yarilürr, wamaka ngüina gwarrarrón mórrkenyórra, da i Isaon ngi igósidi ngyesilóp. ");
INSERT INTO tof_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ene kakóm, oya zoreta tómtómólórr, da tóba tange Isaon wakub emoanórr. Da i Zeikobón ngi we ngyesilóp. Aesak ugón 60 pail yarilürr, Rrebeka ibü nóma nulngumilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Da ene olom nisa nóma dódórr bairri, Isao bügür pamóm bainürr; wa panze bwóbdü baiblürr. A Zeikob wa piküpan ngyaben pam yarilürr; wa palae müót basirr gódam pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aesak, nurr lar nótó mis apókórr, moboküpdü wirri ubi yarilürr Isaoka, a Rrebeka wa go Zeikobka wirri ubi warilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Darrpan ngürr Zeikob zurr alo bamngul yarilürr. Isao arrak bwóbdügab nóma tübzilürr, wa kari alom ta koke yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Wa Zeikobka bóktanórr wagó, “Büsai, kürü kya mobanóm óe-óe zurr kari sokol kókya! Ka amkoman aloanómla!” (Ene zitülkusdü, oya Idombóka igósidi ngilian kwarilürr.) ");
INSERT INTO tof_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Zeikob bóktan yalkomólórr wagó, “Ngaen-gógópan ma kürüka moba ngaen-gógópan amtómól dümdüm darrem klamóm singrino.” ");
INSERT INTO tof_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isao bóktanórr wagó, “Turrkrru, ka büdül kari pokola. Ini ngaen-gógópan amtómól dümdüm kürü koke tangamtinda errkyadan, ka büdül kari pokola, da taia, ka marü akyandóla.” ");
INSERT INTO tof_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Da Zeikob bóktan yalkomólórr wagó, “Ngaen-singül ma kürü moba ⌊arüng alkamül-koke bóktan⌋ kókya, kürü moba ngaen-gógópan amtómól dümdüm akyanóm.” Da Isao tóba arüng alkamül-koke bóktan ekyanórr Zeikobón. Wa tóba ngaen-gógópan amtómól dümdüm darrem klamóm we ingrinürr Zeikobón tangdó. ");
INSERT INTO tof_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Da Zeikob Isaon ngibürr brred akó lentil zurr alo iliónürr. Wa elorr akó nae enónórr, bupadórr, da we wamórr. Da Isao tóba ngaen-gógópan amtómól dümdüm popa inzan amaikürr. ");
INSERT INTO tof_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Akó darrü ku yarilürr ene tüpdü, ngaen singül kwata klamdógab Eibrra-amón ngyaben tonarrdó. Da módóga, Aesak Abimelekka we wamórr, Pilistia pamkolpamab king nótó yarilürr, Gerrarr wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","⌊Lod⌋ Aesakka we okaka tübyónürr, da tóbtanórr wagó, “Izipt tótókgu; marü ka sab milo ma ne bwóbdü ngyaben namulo. ");
INSERT INTO tof_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ma kya bupso ae ngyaben namülün ini tüpdü; ka marüka sab asi namulo akó ka marü bles mino. Ka sab marü ini dudu tüp ugón mókyeno akó marü olmalbobatal. Akó ka sab igó bóktan küsil ino, ka marü ab Eibrra-amón ne ⌊arüng alkamül-koke bóktan⌋ ekyarró. ");
INSERT INTO tof_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ka sab marü ngarkwat-koke olmalbobatal mülino, pülpüldüzan ngarkwat wimurrko. Akó ka sab ini bwób dudu ibü nókyenónómo. Marü olmalbobataldógab, ka ini tüpdü blaman ne pamkolpamko sab bles ninünümo, ");
INSERT INTO tof_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","zitülkus Eibrra-am kürü bóktan arrkrrurr, akó ka oya ne zaget iliórrü blaman tómbapónórr. Wa kürü arüng bóktan, gida, akó gida bóktan poko amkoman morroal gangga irrbünürr.” ");
INSERT INTO tof_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Da módóga, Aesak we ngyabelórr Gerrarr wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ngibürr ene basirr pama nóma togobórr oya amtinüm tóba kolanbókamóm, wa ibüka bóktanórr wagó, “Wa kürü bólbóto.” Zitülkus módóga, wa gum yarilürr igó bóktanóm wagó, “Wa kürü kolo.” Wa gyagüpi wamórr wagó, “Ini basirr pama kubó kürü kena kómkólnóm Rrebekanbókamóm.” Zitülkus módóga, wa agurr kol warilürr. ");
INSERT INTO tof_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aesak barrkyananbóka olazan ngyaben yarilürr, Abimelek, Pilistia pamkolpamab king, müótan pokar mamtaedógab sazilürr ama tüpdü, da Aesakón sesenórr tóba kol Rrebekan aprükdi. ");
INSERT INTO tof_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Da Abimelek tóba zaget pam we zirrnapónóp Aesakón apadóm, da bóktanórr wagó, “Turrkrru, ene go amkoman marü kolo! Ma igó iade bóktarró wagó, ‘Rrebeka kürü bólbóto’?” Da Aesak bóktan yalkomólórr oyaka wagó, “Zitülkus módóga, ka igó poko gyagüpi wamnórró, ka sab oyabókamde kena nurrótókón.” ");
INSERT INTO tof_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Da módóga, Abimelek Aesakka we bóktanórr wagó, “Ma kibüka ini tonarr iade tónggapóna? Darrü pama ne marü kolpükü nóma ki umtule, ma kibüka müp ki sidüda.” ");
INSERT INTO tof_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Da módóga, Abimelek ene pamkolpam igó arüng bóktan we nókyenóp wagó, “Darrüpa ne sab Aesakón kle-kle nóma yangóne, ó akó oya kol, sab amkoman büdüldü ingrirre.” ");
INSERT INTO tof_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Aesak ene tüpdü elklaza zid iritürr. Zitülkus oya Lod bles syónürr, ene pail kugupidü Aesak 100 alo kla abülürr blaman elklaza zidüdügab wa ne kla baritlürr. ");
INSERT INTO tof_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Aesak mórrel pamóm bainürr. Oya elklaza zida metat morroal dódórr bainónóp, kókó wa amkoman wirri mórrel pamóm bainürr. ");
INSERT INTO tof_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Oya aüd ngabkan lar koke kwarilürr, ⌊sip⌋ a ⌊gout⌋ akó ⌊kau⌋, akó oya abün leba zaget kolpam ta asi koralórr. Igósidi Pilistia pamkolpam gyagüp kolaea ekrralórr. ");
INSERT INTO tof_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Da módóga, blaman nae badu, Eibrra-amón leba zaget oloma ne kla ulunglürr Eibrra-amón ngyaben tonarrdó, Pilistia kolpama tüpi nodnóp. ");
INSERT INTO tof_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Da Abimelek Aesakka we bóktanórr wagó, “Kibükagab ugó bupa, zitülkus ma kibükagab wirrian arüng kuri baina.” ");
INSERT INTO tof_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Da módóga, Aesak ene bwób we amgatórr. Wa tóba ngyaben marrgu we tónggapónórr Gerrarr Buru-burudü, da we ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aesak tae nómónóp ene nae badu, ne kla balüngóp Eibrra-amón ngyaben tonarrdó, akó Pilistia kolpama ne kla nodnóp Eibrra-amón büdül kakóm. Ene nae badu akó dadan ngi ngibasilürr, oya aba Eibrra-am ngaen ne ngi ngibasilürr. ");
INSERT INTO tof_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Aesakón zaget pama kugupi alüng koralórr Gerrarr Buru-burudü. Da ene pokodó i arób nae we esenóp. ");
INSERT INTO tof_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Gerrarr wirri basirrdü sip ngabkan pama ongyalóm togobórr ene nae kugupiankwata Aesakón sip ngabkan pampükü wagó, “Ini kibü nae-e!” Ene zitülkusdü, Aesak nae badu ngi we ngyesilürr Esek, zitülkus i wankü ongyelóp. ");
INSERT INTO tof_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ene kakóm, Aesakón zaget pama akó darrü nae badu ilüngóp, da i akó dadanzan ongyal kwarilürr ene nae baduanbókamóm. Da Aesak ene nae badu ngi we ngyesilürr Sitna. ");
INSERT INTO tof_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Aesak ene pokodógab we bupadórr tóba pamkolpampükü, da akó darrü nae badu we ilüngürr. Ene pokodó, myamem darrü pama koke tamórr oya ongyalan ngitanóm. Da módóga, Aesak ene nae kugupi ngi we ngyesilürr Rreobot, ó wa we bóktanórr wagó, “Mibü Lod wirri panze bwób tókyerre ngyabenóm, ó ini bwóbdü sab mi küppükü bairre.” ");
INSERT INTO tof_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Wa olgabi we wamórr ama Berrsyiba wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ene irrüb Lod oyaka we pupo tübyónürr, da bóktanórr wagó, “Ka marü ab Eibrra-amón Godla. Ma gumgu, zitülkus ka mankü asinla. Ka marü sab bles mino akó marü ka sab abün olmalbobatal mülino, ka ngaen ne ⌊alkamül-koke bóktan⌋ ingrirrü kólba zaget pamankü Eibrra-am.” ");
INSERT INTO tof_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aesak ⌊alta⌋ ola elórr, Lodón ngian we ngilialórr oya ⌊ótókóm⌋. Ene kakóm, wa tóba palae müót we balmelórr. Oya zaget pama akó darrü nae badu we ilüngóp. ");
INSERT INTO tof_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Da Abimelek Gerrarrgabi we tamórr Berrsyiba. Wa inkü tamórr: A-uzat, oya ikik bókrran pam, akó Paekol, tóba gazirr pamab singüldü wirri ngi pam. ");
INSERT INTO tof_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Da módóga, Aesak we nümtinóp wagó, “E kürüka iade togoba? Ka yabü bamtindóla, zitülkus e kürü alzizi kümanikarre, akó e kürü we kolakókyenarre yabióbkagab.” ");
INSERT INTO tof_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","I bóktan we yalkomórri wagó, “Ki tai panzedó kuri eserre wagó, Lod marüka asine, ó ki kibiób ikik apórre kigó, ‘Mi arüng alkamül-koke bóktan ki tónggapórri mibü aodó, kidip akó mató.’ Ki kubó tónggapórrón bóktan ki ingrirre mankü, paudi ngyabenóm. ");
INSERT INTO tof_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ma kibüka sab darrü kolae koke tónggapono, ki yabü kokezan kolae ninóp akó yabü morroal tonarrezan ngabkan koralnórró, ma moba kolpampükü kinkü nóma ngyaben namülnürrü. Akó ki marü paudi zirrmapónóp. Da Lod errkya marü panzedó kuri bles mine.” ");
INSERT INTO tof_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Da módóga, Aesak ibünkü wirri alongalo we tónggapónórr. Da i alo elop akó anón klampükü we enónóp. ");
INSERT INTO tof_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Irrbianande darrü ngürr ene pama arüng alkamül-koke bóktan we tónggapónóp tibiób gazirrgum. Da módóga, Aesak ene aüd pam yawal we nókyenóp, ó i oya paudi we amgütóp. ");
INSERT INTO tof_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ene ngürr Aesakón zaget pama oya azazilüm we togobórr, i ne badu ilüngnóp, wagó, “Ki nae kuri eserre!” ");
INSERT INTO tof_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Aesak ene nae badu ngi ngyesilürr Syiba. Ene zitülkusdü, ngaendógabi kókó errkya ini tonarr pamkolpama ene basirr ngi igó ngiliandako wagó, Berrsyiba. Ene ngian küp módóga: arüng alkamül-koke bóktanan badu. ");
INSERT INTO tof_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Isao 40 pail pam nóma yarilürr, wa nis mogob kol nis nümiógürr Et kolpamdógab: Zudit, Be-erin óp olom, akó Beismat, Ilonón óp olom. ");
INSERT INTO tof_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaon kol nisa müp ngyaben sidódrri Aesak a Rrebeka, ibüka. ");
INSERT INTO tof_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aesak myangan nóma yarilürr, oya ilküp nisa tümün ugón bairri. Wa myamem koke ngabkalórr. Wa tóba ngaen olomdó Isaoka górrganórr. Oyaka bóktanórr wagó, “Kürü olom!” Isao bóktan yalkomólórr wagó, “Ba, ka inamüla!” ");
INSERT INTO tof_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aesak bóktanórr wagó, “Turrkrru, ka myang kuri baina, akó ka kólba büdül ngürrbóka umul-kókla. ");
INSERT INTO tof_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Moba bügür kyab yazeb, arrakóm ugó wam panze bwóbdü kürünkü alóng kla byamkünüm. ");
INSERT INTO tof_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ma kürünkü morroal misan alo kla tónggapó, ka ne alom ubila, da kürüka sidódke alom. Kürü aloa nóma blakóne, ka kubó marü ugón bles mino. Ka sab solodó nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rrebeka arrkrru warilürr, Aesak enezan bóktanórr tóba olomdó Isaoka. Da Isao nóma bupadórr panze bwóbdü arrakóm, ");
INSERT INTO tof_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rrebeka tóba olomdó Zeikobka bóktanórr wagó, “Turrkrru, ka marü ab arrkrrua bóktande Isaoka wagó, ");
INSERT INTO tof_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ma kürü alóng kla kubó sidódke, akó ma kürünkü morroal misan alo kla tónggapó kürü alom. Kürü aloa nóma blakóne, ka kubó marü ugón bles mino ⌊Lodón⌋ obzek kwata. Ka sab solodó nurrótoko.’ ");
INSERT INTO tof_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kürü olom, tai turrkrru, da tónggapó ka kubó marü enezan milo! ");
INSERT INTO tof_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ugó wam, mibü ⌊gout⌋ a ⌊sip⌋ negasko, da nis morroal büb baritürrün gout kupo tüdódke kürüka. Ka kubó morroal misan alo kla tónggapono marü abankü, wa ne ngarkwat alom ubi bainürr. ");
INSERT INTO tof_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Da kubó alo mató idódke moba abdó oya alom, igósüm wa kubó marü bles mine. Wa sab solodó nurrótókes.” ");
INSERT INTO tof_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","A Zeikob tóba aipbóka wagó, “Turrkrru, kürü naretan büb sopae ngüinpüküma, a kürü ma ngüin-koke büb sopaea. ");
INSERT INTO tof_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kürü aba aprrapórr kubó nóma kyamurre, wa kubó umul baine wagó, ka oya ilklió aliónüm kaindóla. Da ka kubó kólbaka igósidi amórr bóktan sidüdo, a bles bain bóktan ma koke.” ");
INSERT INTO tof_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Da oya aipa Rrebeka bóktan yalkomólórr oyaka wagó, “Kürü olom, ene amórr bóktana kürüka ki tam. Wata tónggapó, ka marü ne poko mila. Ugó wam, da ene gout kupo nis tüdódke kürüka.” ");
INSERT INTO tof_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Zeikob wamórr a ene gout kupo nis nüpadórr, da we tüdódürr tóba aipdü. Wa morroal misan alo kla tónggapónórr, Aesak ne ngarkwat alom ubi bainürr. ");
INSERT INTO tof_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Da wa ngaen olom Isaon morroalan mórrkenyórr yazebórr, oyaka ene müót kugupidü ne kla koralórr. Solo kupo olom Zeikobón we püti yónürr. ");
INSERT INTO tof_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Wa oya tang nis akó ngüin-koke gepko gout sopae poko-e ngablaorr. ");
INSERT INTO tof_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Da wa Zeikobón ekyanórr ene morroal misan alo, akó brred, wa ne kla tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Da Zeikob abdó wamórr da bóktanórr wagó, “Ba!” Oya aba bóktan yalkomólórr wagó, “Ó, ka inamüla. Ma ia nótókla, kürü olom?” ");
INSERT INTO tof_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Zeikob bóktan yalkomólórr wagó, “Ka Isao, marü ngaen olom; ka kuri tónggapóna, ma kürü enezan kila. Gyaurka, ugó mórra. Ini alóng kla ugó elóng, ka arrak bwóbdügabi ne kla sidüda marünkü. Ene igósüm ma kürü kubó kókyeno marüka ne bles bain bóktane.” ");
INSERT INTO tof_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aesak imtinürr olom wagó, “Kürü olom, ma ini alóng kla büsai ia esena?” Zeikob bóktan yalkomólórr wagó, “Lod, marü God, kürü kwatódó wató singrine.” ");
INSERT INTO tof_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aesak Zeikobka bóktanórr wagó, “Kürü minggüpanan tam, da ka kya marü kóbó myamurrün, kürü olom, igó umul bainüm ma ia amkoman Isaola o koke.” ");
INSERT INTO tof_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Zeikob tai wamórr kókó tóba aban minggüpanan. Aesak yamurrürr da bóktanórr wagó, “Marü bóktan gyagüp wamaka Zeikobón bóktan bómgóle; a marü tang nis ama Isaon tangzanamli.” ");
INSERT INTO tof_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aesak Zeikobón koke emzyatórr, zitülkus oya tang nis ngüinpükü namülnürri Isaon tang niszan. Aesak Zeikobón ene zitülkusdü kari poko bles yónürrma. ");
INSERT INTO tof_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Wa akó imtinürr wagó, “Ma ia amkoman kürü olomla Isao?” Zeikob bóktan yalkomólórr wagó, “Ka ta módógla.” ");
INSERT INTO tof_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aesak bóktanórr wagó, “Ma ngibürr alóng kla murr ala simarru kürü alóngóm. Ka kya elóngón, da marü kubó ugón bles mino.” Zeikob ene murr tóba abdó simarrurr, da siliónürr alóngóm. Oya waenpükü ta ekyanórr anónóm. ");
INSERT INTO tof_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ene kakóm, Aesak bóktanórr oyaka wagó, “Yao, kürü minggüpanan tam, kürü olom. Da kürü ugó küprük.” ");
INSERT INTO tof_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Zeikob abdó wamórr, da iprükürr. Aesak Isaon mórrkenyórr ilang nóma apónórr, wa Zeikobón ugón bles yónürr. Wa bóktanórr wagó, “Kürü oloman morroal ilang wamaka opopor pala ilangda, Lod ne kla bles yónürr. ");
INSERT INTO tof_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Marü God gles mor kwitümgab ki kókya akó marü ini tüp ki mórrel syó! Marü God metat ki küliólün abün ⌊wit⌋ küp akó küsil waen. ");
INSERT INTO tof_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ini tüpan pamkolpama sab marü zaget pam ki kwarilün, da i sab marüka wakósingül ki nümgününüm. Ma sab moba zonaretalab wirri pam ki namüla, akó marü aipan olmalbobatal wakósingül ki nümgününüm marüka. Blamana marü nidi mamórrórre, i ta sab bamórrórrón kwarile. Marü nidi bles mirre, i ta sab bles airrün kwarile.” ");
INSERT INTO tof_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aesakón Zeikobón bles aina nóma blakónórr, Zeikob tóba ab we amgatórr. Büzyón babul, Isao arrak bwóbdügab ugón tübzilürr. ");
INSERT INTO tof_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Wa ta inzan morroal mis alo kla tónggapónórr, da sidódürr tóba abdó. Da wa oyaka bóktanórr wagó, “Ba, ugó bupa, mórra, kürünüm ngibürr alóng kla alóngóm. Ene igósüm, ma kubó kürü bles kino!” ");
INSERT INTO tof_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","“Ma ia nótó?” Aesak imtinürr. “Ka Isao, marü ngaen olom,” wa bóktan yalkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Aesak arrkürrürr, da wirribóka tórrngónóm bainürr, da bóktanórr wagó, “Ene wa nótó yaril, alóng kla emkólea, ama kürüka sidüde? Ka wata errkyadan elónga, da ma ma igó bwób kuri tübzila. Ka kólba bles ain bóktan oya kuri ekyena. Wa ene bles ain bóktan metatómpükü kuri ipüde.” ");
INSERT INTO tof_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Isao tóba aban bóktan nóma arrkrrurr, wa ngürsilpükü wirri yón taegwarr ipadórr. Tóba abdó bóktanórr wagó, “Ka ta inzan, ba-óe, ma kürü bles kyó!” ");
INSERT INTO tof_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","A Aesak bóktanórr wagó, “Marü zoreta ilklió bülión tonarre tame; marü bles ain bóktan wató kuri ipüde.” ");
INSERT INTO tof_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Isao bóktanórr wagó, “Oya Zeikob ngi gaoandó ngyesilóp! Ini ma nis ngima kürü ilklió aliónüm! Kürü ngaensingül amtómól dümdüm ipadórr, akó errkya ma kürü bles bóktan kuri ipüde!” Wa akó imtinürr wagó, “Ma ia kürünkü darrü bles ain bóktan koke irrmüta?” ");
INSERT INTO tof_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aesak Isaon bóktan yalkomólórr wagó, “Turrkrru, ka oya marü wirri pamóm kuri ina, akó ka oya blaman zonaretal oya zaget pamóm ninünüma. Ka oya abün wit küp akó küsil waen kuri ilina. Da ka myamem laró tónggapono, kürü olom?” ");
INSERT INTO tof_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Isao tóba ab wata yatolórr wagó, “Ba, marü wata darrpan bles bóktana? Ba-óe, kürü ta bles kyó!” Wa wirribóka yón sabinürr. ");
INSERT INTO tof_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Oya aba bóktan yalkomólórr oyaka wagó, “Turrkrru, marü ngyaben bwób sab alam kan koke yarile ini tüpan mórreldógab, ó akó ola sab gles mor babul yarile kwitümgab. ");
INSERT INTO tof_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ma sab gazirr turriki gazirr namulo ngyabenóm, akó ma sab moba zoretan zaget pam namulo. A ma sab oyaka nóma bóka bamgün namulo, ma sab oya tangdógab ugón balkomolo; ma sab ul baino oya müp amarrudügab.” ");
INSERT INTO tof_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isao Zeikobón alzizi amanikürr, zitülkus ibü aba Zeikobón bles yónürr. Wa gyagüpitótók we esenórr wagó, “Kürü aban büdül ngarkwat minggüpanana. Ene kakóm, ka kólba zoret Zeikobón ugón emkolo.” ");
INSERT INTO tof_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Aip Rrebekan nóma uzazilóp oya ngaen oloma Isao ne poko bóktanórr, wa bóktan zirrapónórr tóba solo kupo olom Zeikobka, da bóktanórr oyaka wagó, “Turrkrru, marü nareta tóba ngürr akyanda marü amkalóm, ma ne kolae tónggapórró oyaka. ");
INSERT INTO tof_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Taia, kürü olom, tónggapó ka kubó marü enezan milo. Errkyadan ugó buso kürü naretódó Leibanka, Arran bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kya ma bupso ola ngyabenke oyaka, kókó marü naretan ngürsila zao-zao nóma baine ");
INSERT INTO tof_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","akó oya ene pokoa nóma bamrüke, ma ne poko tónggapórró oyaka. Ka marü olgab alkomólóm sab bóktan zirrapono. Kürü ubi kokea kólba siman olom nis darrpan ngürrdü amrüküm.” ");
INSERT INTO tof_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rrebeka Aesakka bóktanórr wagó, “Kürü genggorrama kuri küpüde ini arról tonarr ngakande, Isaon mogob kolabbókamde. Zeikob akó sab ne inzan kol ini Et koldógab nóma upude, kürü ngyaben sab morroal koke yarile.” ");
INSERT INTO tof_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Aesak Zeikobón ngyaunürr, da bles yónürr. Oya arüng bóktan ekyanórr wagó, “Sab Keinan kol apadgu. ");
INSERT INTO tof_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Bupa errkyadan, da ugó wam Padan Arram bwóbdü, moba aipan aban müótüdü, ngi Betuel. Mobankü kol olgabi upadke, Leibanón ópal olmaldógab, marü nuguzamón ab nótókse. ");
INSERT INTO tof_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Wirrian Arüng God marü sab ki bles myó akó marü küppükü ki myó, igósüm ma sab abün bwóbab pamkolpamab abbobat namulo! ");
INSERT INTO tof_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Wa sab marü ki bles kyó akó marü olmalbobatal, wa Eibrra-amónzan bles syónürr. Ene igósüm, ini tüp sab marü yarile, ma errkya ne ngyabendóla mogob pamzan, God Eibrra-amón ne tüp sekyanórr!” ");
INSERT INTO tof_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aesak Zeikobón we zirrapónórr Padan Arram, Leibanka, Betuelón siman olom. Wa Arram bwób pam yarilürr, Rrebekan naret, Zeikob a Isao, ibü aip. ");
INSERT INTO tof_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isao umul bainürr wagó, Aesak Zeikobón kuri bles yónürr akó oya we zirrapónórr Padan Arram, olgabi kol apadóm. Wa ta umul bainürr wagó, Aesak Zeikobón nóma bles yónürr, wa oya arüng bóktan ekyanórr wagó, “Ma sab Keinan kol apadgu.” ");
INSERT INTO tof_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Wa akó umul bainürr wagó, Zeikob tóba aipab nisab bóktan kuri arrkrrurr, da wa we bupadórr Padan Arram. ");
INSERT INTO tof_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Isao ugón umul bainürr wagó, oya ab Aesak ubi-koke yarilürr Keinan kolóm. ");
INSERT INTO tof_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Da wa we wamórr Isma-elka, Eibrra-amón siman olom, akó oya óp olom we upadórr, ngi Ma-alat, Nebayotón bólbót nótó warilürr. Isao ngaen-gógópan ngibürr ne kol yazebórr, wa ma oya ibüka daniyónürr. ");
INSERT INTO tof_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Zeikob Berrsyiba nóma amgatórr, ama Arran wamlórr. ");
INSERT INTO tof_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Wa darrü bwób poko nóma semrranórr, da wa we amilürr utüm, zitülkus abüsa bótao bwóbdü wamlórr. Wa darrpan ingülküp ola kla ipadórr, singül müózüm ingrinürr, da utüm we wamórr. ");
INSERT INTO tof_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wa igó nus umtulürr wagó, bata tüpdü alanirrün yarilürr, solo ama kwit amrrarrón yarilürr. Ene batana, Godón anerrua kwit bangülürr akó tüp tübabilürr. ");
INSERT INTO tof_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Da módóga, ⌊Lod⌋ bata kwitüm zamngólólórr, da wa we bóktanórr wagó, “Ka Lodla, ka marü abbobat Eibrra-amón God akó marü ab Aesakón God. Ka sab marü ini tüp mókyeno, mató akó marü olmalbobatal, ma errkya ne utürrünla. ");
INSERT INTO tof_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Marü olmalbobatal sab igó korale, wamaka atang-koke buru ini tüpdüzan. I sab blaman bwób ayonórre, akó arratnórre blaman órdóma: bolmüót, solomamtae, dorrmet, akó malubarr. Ini tüpdü blaman pamkolpam sab bles bairrün korale marükama akó marü olmalbobataldóma. ");
INSERT INTO tof_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Da módóga, ka sab asi namulo mankü, akó ka marü módlanglo blaman bwóbdüma, ma nega wamlo. Ka akó sab marü kalkomolo ini tüpdü. Ka marü koke molkomolo, kókó ka sab blaman kla tómbapono, ka marü ne ⌊alkamül-koke bóktan⌋ mókyarró.” ");
INSERT INTO tof_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Zeikob nóma saogórr utürrün klama, wa bóktanórr wagó, “Amkoman, Lod asine ini bwóbdü, da ka umul-kók namüla wagó, Lod asine aini.” ");
INSERT INTO tof_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Wa gum yarilürr, da bóktanórr wagó, “Ini wata gyabi akó gum angón bwóba! Ini darrü kla kokea: ini amkoman Godón müóte; ini amkoman kwitüdü bamsel mamtaea!” ");
INSERT INTO tof_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Irrbianande darrü ngürr nóma türsümülürr, tóba müózüm ne ingülküp ingrinürr, da ipadórr, ama alaninürr oya ene poko gyagüpi amaiküm. Da ⌊olib⌋ oel we ekanórr ene ingülküp kwitüdü. ");
INSERT INTO tof_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Wa ene bwób ngi we ngyesilürr Betel. (Da ngaen ene wirri basirr igó ngilianónóp, Luz.) ");
INSERT INTO tof_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Da Zeikob ⌊arüng alkamül-koke bóktan⌋ tónggapónórr Lodka. Wa igó yarilürr wagó, “God ne kürüka asi nóma yarile, akó wa ne kürü nóma kódlangle ini bwób mamoande, akó wa ne kürü alo kla akó mórrkenyórr bamelóm nóma klióle, ");
INSERT INTO tof_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","akó ka ne sab morroal nóma alkomolo kólba aban basirrdü, da Lod ama sab igósidi kürü God yarile. ");
INSERT INTO tof_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ini ingülküp, ka ne kla alanindóla marü gyagüpdü ódódóm, sab Godón ⌊ótók⌋ müót yarile. Blaman elklazadógab, ma sab kürü ne kla kliólo, ka sab marü ⌊wantent⌋ mókyalo.” ");
INSERT INTO tof_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Zeikob tótókóm akó we bupadórr. Abüsa nólgabi banikda, wa ama ene pamkolpamab tüpdü wamlórr. ");
INSERT INTO tof_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Da módóga, kwat-kwat wa nae badu sesenórr pórrpótyapdó. Ene pokodó aüd ⌊sip⌋ kopo koralórr, ngón bagólórr badu kabedó. Ene sipab nae anón badu yarilürr. Da nae badu kugupi ait poko wirri ingülküpi murrausürrün yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Blaman sip ngabkan kolpama tibiób sippükü nóma kwób tóbazenórre, sip ngabkan kolpama badu murraus ingülküp kubó ugón yanerre ene kugupidügab. I tibiób sip nae ugón nómyerre. Ene sipab nae anóna nóma blakóne, ene ingülküp kubó akó salkomórre tóba pabodó murrausüm. ");
INSERT INTO tof_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Zeikob ene sip ngabkan pam nümtinóp wagó, “Kürü gómdamal, e ia nubógabakla?” I darrem bóktan yalkomólóp wagó, “Ki Arran wirri basirrdügabakla.” ");
INSERT INTO tof_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Zeikob akó ibü nümtinóp wagó, “E ia Leibanónbóka umulakla, Na-orrón bobat?” I bóktan yalkomólóp wagó, “Ó, ki umulakla oyabóka.” ");
INSERT INTO tof_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Zeikob bamtin bóktan poko akó nümtinóp wagó, “Ia wa taiase?” I bóktan yalkomólóp wagó, “Ó, wa taiase. Ngaka, oya óp olom Rreizel wóni tóba sippükü tótókdo.” ");
INSERT INTO tof_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Zeikob bóktanórr wagó, “Ngakónam, ini abüs singülküpa. Ini we abüs küp kokea sip darrpan pokodó amarrum. E sip nae nómyenam, da kubó akó yakonamke twal alom.” ");
INSERT INTO tof_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","I bóktan yalkomólóp wagó, “Ki gaodó kokeakla, kókó kubó blaman sipa kwób tóbazene. Da darrpan mün ki kubó ingülküp igósidi yanerre nae badu kugupi ait pokodógab. Da ki kubó sip nae ugón nómyerre.” ");
INSERT INTO tof_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Zeikob wa ene pampüküzan ikik yarilürr, Rreizel ugón tübzilürr tóba aban sippükü, zitülkus wa sip ngabkan kol warilürr. ");
INSERT INTO tof_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Rreizel Leibanón olom warilürr akó Leiban Zeikobón aipan naret yarilürr. Zeikob Rreizelón nóma osenórr, Leibanón sippükü, wa wamórr badudü, ingülküp yanenórr, badu murrausürrün kla, da tóba nungzamón aban sip nae we nómyenóp. ");
INSERT INTO tof_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Zeikob Rreizelón uprükürr, da wirribóka we yón sabinürr. ");
INSERT INTO tof_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Wa Rreizelón uzazilürr wagó, “Ka Rrebekan olomla; marü aban nungzamón.” Da Rreizel busorr ab azazilüm. ");
INSERT INTO tof_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Leiban ene bóktan nóma arrkrrurr wagó, kürü bólbótan oloma kuri tame, wa büsai wamórr oya asenóm. Oya amiógürr, iprükürr, da oya ipadórr, idódürr tóba müótüdü. Zeikob adrratórr oyaka blaman ne klama tómbapónónóp. ");
INSERT INTO tof_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Leiban Zeikobka bóktanórr wagó, “Amkoman, ma kürü kólbanan okómópdógabla akó kólbanan óedógabla.” Zeikob Leibanka darrpan melpalóm ngyabenórr. ");
INSERT INTO tof_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ene melpal kakóm, Leiban Zeikobka we bóktanórr wagó, “Ma wa kürü minggüpanan nungzamónla, da ma sab kürü popa zaget koke tómbapolo. Ma kürü kyal, marü darrem sab laró kwarile.” ");
INSERT INTO tof_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leibanón nis ngul olom nis namülnürri. Ngaen kol ngi Lia, akó solo kupo ngi Rreizel. ");
INSERT INTO tof_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lian ilküp agür ngarkwatódó koke namülnürri, a Rreizel ma amkoman morroalan agurr kol dólóng warilürr. ");
INSERT INTO tof_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Zeikobón amkoman ⌊moboküpdü ubia⌋ wamórr Rreizelka, da wa bóktanórr Leibanka wagó, “Ka sab 7 pailüm zaget namulo marünkü, marü solo kupo óp olom Rreizelón amiógüm.” ");
INSERT INTO tof_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Leiban bóktanórr wagó, “Morroal igósa, ka oya sab marü mókyeno, a darrü pam koke. Ae namülün kankü.” ");
INSERT INTO tof_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Da Zeikob zaget yarilürr 7 pailüm Rreizelón amiógüm. Ene tonarra igó bainürr, wamaka aüd ngürr koralórr oyaka, zitülkus oya amkoman moboküpdü ubi yarilürr Rreizelka. ");
INSERT INTO tof_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","7 Pail kakóm Zeikob bóktanórr Leibanka wagó, “Ma kürü kol ugó kókya. Kürü zaget ngarkwata kuri blakóne. Ki kubó usadi umtuli.” ");
INSERT INTO tof_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Leiban blaman ene basirr kolpam ngibaunürr, da kol amióg tóre we tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ene irrüb Leiban tóba ngul olom Lian ugón tudódürr Zeikobón amiógüm. Da i ma usadi we umturri. ");
INSERT INTO tof_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(Leiban tóba ⌊leba zaget⌋ ngulmokur ngi Zilpa Lian okyanórr oya leba zaget kolóm bainüm.) ");
INSERT INTO tof_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Da módóga, darrü irrbi Zeikob Lian osenórr. Zeikob wamórr kókó Leibanka da bóktanórr wagó, “Ma kürüka ini ia poko tónggapóna? Ka wa tai Rreizelónkü zaget namülnürrü, ta ia koke? Ma kürü iade ilklió külina?” ");
INSERT INTO tof_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Leiban bóktan yalkomólórr wagó, “Kibü gida ala inzan babula, solo kupo ngaen-gógópan akyanóm müór. Wata kubó müór ngaen-gógópan nareta ipüde. ");
INSERT INTO tof_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ngaen-gógópan ma darrpan udai kol apad tóre elakono, ene udai kakóm ki sab marü solo kupo óp olom igósidi mókyerre, ma ne akó 7 pailüm zaget nóma namulo kürünkü.” ");
INSERT INTO tof_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Zeikob abinürr, da ene barnginwóm elakónórr ene udai kugupidü Liadi, da Leiban oya tóba óp olom Rreizelón kolóm we ekyanórr. ");
INSERT INTO tof_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(Leiban tóba leba zaget ngulmokur, ngi Bila, Rreizelón okyanórr oya leba zaget kolóm bainüm.) ");
INSERT INTO tof_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Zeikob Rreizelón upadórr, usadi umturri, da oya amkoman moboküpdü wirrian ubi yarilürr Rreizelka; Liaka ma taiwan ubi koke. Da wa akó ngibürr 7 pail amanórr Leibanónkü zagetóm. ");
INSERT INTO tof_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Da ⌊Lod⌋ nóma esenórr Zeikobón moboküpdü ubi koke yarilürr Liaka, wa oya kwat tapasukurr olmal basenóm. A Rreizel wa olmal balngón-koke kol warilürr. ");
INSERT INTO tof_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia bikóm esenórr, mórranórr olom siman. Wa ngi ngyesilürr Rruben. Wa igó bóktanórr wagó, “Lod amkoman esenórr kürü müp, kürü müóran moboküpdü ubi kubó kürüka igósidi yarile.” ");
INSERT INTO tof_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lia akó bikóm esenórr, darrü siman olom ilngumilürr. Igó bóktanórr wagó, “Zitülkus Lod igó arrkrrurr, kürü müóran moboküpdü ubi babula kürüka, da wa akó kürü ini igósidi kókyene.” Da wa igósidi ngi ngyesilürr Simion. ");
INSERT INTO tof_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Wa akó bikóm esenórr, da nóma mórranórr, wa bóktanórr wagó, “Ini aüd ngim siman olom ilngumila kólba müórankü. Ini tonarr wa sab kürü minggüpanan arróbórrón yarile.” Da wa olommokur igósidi ngi ngyesilürr Libae. ");
INSERT INTO tof_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lia bikóm akó esenórr. Nóma mórranórr, siman olom ilngumilürr. Wa bóktanórr wagó, “Ini tonarr ka Lodón yagurlo.” Wa oya igósidi ngi ngyesilürr Zuda. Ene kakóm, oya olmal basena ugón piküp bainürr. ");
INSERT INTO tof_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rreizel nóma esenórr wa, “Ka Zeikobónkü olmal koke balngóndóla,” oya gyagüp kolaea omkalórr tóba naretódó. Da wa Zeikobón yalórr wagó, “Ma kürü olmal kólngó! Koke ne nóma, ka sab nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Zeikob ngürsilüm bainürr Rreizelka. Da bóktanórr wagó, “Ia ka Godón pabodómla, marü nótó arrmatóda olmal balngón-gum?” ");
INSERT INTO tof_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rreizel we bóktanórr wagó, “Bila wóni, kürü leba zaget kol. Kubó usadi umtulamke, igósüm wa sab kürünkü olmal iade balngóne. Ka ma sab olmal oyakagab yazebo.” ");
INSERT INTO tof_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Da wa tóba leba zaget kol Bilan Zeikobón kolóm ekyanórr. Zeikobdi umturri, ");
INSERT INTO tof_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ó Bila bikóm we ipadórr, da siman olom ilngumilürr oyankü. ");
INSERT INTO tof_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ene ngarkwatódó, Rreizel bóktanórr wagó, “God pupo syónürr ka dümdüm kla tónggapórró, akó wa kürü bóktan kuri turrkrrue, da wa kürü siman olom kókyene.” Wa ngi igósidi ngyesilürr Dan. ");
INSERT INTO tof_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Solkwat Bila akó bikóm esenórr. Zeikobónkü nis ngim siman olom ilngumilürr. ");
INSERT INTO tof_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ene tonarr Rreizel bóktanórr wagó, “Ka kólba naretpükü wirri arüngi bóka bamgünürrü, da ka oya singül kwata kuri natóka!” Da wa igósidi ngi ngyesilürr Naptali. ");
INSERT INTO tof_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lia tóba nóma basenórr wagó, oya olmal balngóna kuri piküp bainürr, wa tóba leba zaget kol Zilpan upadórr, Zeikobón ekyanórr kolóm. ");
INSERT INTO tof_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lian leba zaget kol Zilpa siman olom ilngumilürr Zeikobónkü. ");
INSERT INTO tof_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Olgab Lia bóktanórr wagó, “Kürü morroal ia kine,” da wa oya ngi ngyesilürr Gad. ");
INSERT INTO tof_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa akó nis ngim siman olom ilngumilürr Zeikobónkü. ");
INSERT INTO tof_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lia bóktanórr wagó, “Errkya ka bagürdümla. Blaman kola kürükwata sab igó bóktanórre wagó, ‘Wa bagürdo’.” Da wa olommokur igósidi ngi ngyesilürr Asyerr. ");
INSERT INTO tof_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","⌊Wit⌋ abül tonarr nóma yarilürr, Rruben ngaon bwóbdü wamórr. Wa ola ngibürr bikóm basen nugup zid nósenóp. Da wa simarrurr tóba aipdü Liaka. Rreizel bóktanórr Liaka wagó, “Gyaurka, kürü ngibürr moba olomanóm bikóm basen nugup küp a simkün külió!” ");
INSERT INTO tof_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Lia Rreizelka bóktanórr wagó, “Ia marüka gaodó kokea, ma kürü müór kürrkyórró? Kürü olomanóm bikóm basen nugup küp akó simkün ia akó mató sazebo?” Da Rreizel bóktan yalkomólórr wagó, “Taia, ma ne moba olomanóm bikóm basen nugup küp a simkün nóma klino, ene darrem módóga, e kubó Zeikobdi umtuli ini irrüb.” ");
INSERT INTO tof_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ene simam Zeikob ngaon bwóbdügab nóma tolkomólórr, Lia natókórr oya asenóm. Oyaka bóktanórr wagó, “Ma kubó kürüka umtulo. Ka marü kuri mümiga kólba olomanóm bikóm basen nugup küp a simküni.” Ene irrüb i Zeikobdi we umturri. ");
INSERT INTO tof_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God Lian bóktan turrkrrurr. Wa bikóm esenórr, 5 ngim siman olom ilngumilürr Zeikobónkü. ");
INSERT INTO tof_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia bóktanórr wagó, “God kürü darrem kuri salkomóle, kólba leba zaget kol kólba müór akyanóm.” Da igósidi ngi ngyesilürr Isakarr. ");
INSERT INTO tof_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Solodó Lia akó bikóm esenórr. Zeikobónkü 6 ngim siman olom ilngumilürr. ");
INSERT INTO tof_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lia bóktanórr wagó, “God kürü morroalan ⌊gyaur kla⌋ kuri kókyene. Errkya ini tonarrdó kürü müóra kürü morroal tonarre ngakakale, zitülkus ka oyankü 6 simanal olmal kuri balngórró.” Igósidi ngi ngyesilürr Zebulun. ");
INSERT INTO tof_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ngibürr tonarr kakóm, Lia akó óp olom ulngumilürr. Daena ngi okyanórr. ");
INSERT INTO tof_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Da Godón Rreizelónbókama ngambangólórr; wa oya bóktan turrkrrurr, da wa oya olmal basen alóp akó tapasukurr. ");
INSERT INTO tof_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Da Rreizel bikóm esenórr a siman olom ilngumilürr. Wa we bóktanórr wagó, “God kürü ene büód kuri amaike.” ");
INSERT INTO tof_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rreizel tóba siman olom ngi ngyesilürr Zosep. Wa bóktanórr wagó, “Kürü ⌊Lod⌋ akó darrü olom ki kókya oya kakóm.” ");
INSERT INTO tof_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rreizel Zosepón nóma ilngumilürr, Zeikob Leibanka bóktanórr wagó, “Kürü kya zirrkapó kólba kwata, kólbanan ngyaben tüpdü alkomólóm! ");
INSERT INTO tof_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ma kürü kol a akó olmalpükü külió, ka nibióbkü zaget namülnürrü marünkü, ó ka kólba kwata ugón bupudo. Ma umulóla ka ne ngarkwatódó zaget tómbapón namülnürrü marünkü.” ");
INSERT INTO tof_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Da Leiban bóktan yalkomólórr wagó, “Ma moba obzek kwata kürüka ne morroal nóma seserró, da ma kankü ae namülün. Ka umul bairrü ngibürr umul-kók ne pokoa tómbapónónóp wagó, Lod kürü marübókamde mórrel kókyanórr. ");
INSERT INTO tof_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Moba zaget darrem ngiblia, da ka sab marü darrem mülino.” ");
INSERT INTO tof_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Zeikob bóktanórr wagó, “Ma umulóla ka marünkü ia zaget tómbapónórró akó marü sip a ⌊kau⌋ ngarkwata kürü tangdógabi ia dódórr bailürr. ");
INSERT INTO tof_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Marü aüdan kau a sip kwarilürr, ka ngaensingül nóma tamrró. Errkya marü ma wirri ngarkwat kau a sipako. Da Lod marü kuri bles mine, ka negama wamnórró. Da ma ia, ka kólbanan olmalkolabkü zaget nómatan tómbapolo?” ");
INSERT INTO tof_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Da Leiban imtinürr wagó, “Ka marü ia laró darrem mókyeno?” Zeikob bóktan yalkomólórr wagó, “Ma kürü darrü darrem kla akyan-gu. Wata darrpan kla ma tónggapono. Ka wata sab marü sip a ⌊gout⌋ ngabkalo, ma ne kürü ini bóktandó nóma tübino: ");
INSERT INTO tof_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ka kya ini ngürr kóbó wamlón marü blaman sip a gout ngabkankü. Ka blaman pug pokopükü sip kubó tibi-tibi pokodó irrbulo, akó blaman pugan sip kupo. Ka akó kubó baeb pokopükü gout inzan nangónónómo. Kürü darrem sab we kla kwarile. ");
INSERT INTO tof_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Sab ugórr ma büsai eseno wa, ka ia amkoman namülnürrü marüka, ma sab kürü darrem amzyatóm nóma tamo. Blaman gout baeb pokopükü babul ne kla kwarile, akó sip kupo pug-koke ne kla kwarile, ma ugón umul baino wagó, gómól-gómól azebórrónako.” ");
INSERT INTO tof_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Leiban abinürr wagó, “Ó, ka ubi baina. Inzan ki tómbapó, mazan namüla.” ");
INSERT INTO tof_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","A ene dadan ngürrdü, Leiban tibi-tibi amalórr blaman baeb pokopükü simanal gout akó ópal gout ngibürr goutüdügab. Akó blaman pugan sip kupo dadanzan nangónónóp. Da wa yazebórr, tóba simanal olmal nülinóp ngabkanóm. ");
INSERT INTO tof_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Leiban ne sip a gout yazebórr, wa we klampükü wamórr aüd ngürr ngarkwat kan Zeikobkagab. Zeikob we yarilürr, Leibanón ngibürr sip a gout ngabkanóm. ");
INSERT INTO tof_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Zeikob arról nugup tiz singgalgónórr. Ngibürr sopae bazebde, wa baeb wi tómbapónórr, zitülkus ngibürr ene nugup tizab aumana kwin ama panzedó togobórr. ");
INSERT INTO tof_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Zeikob olgabi ene baeb wiagótórrón nugup tiz irrbünürr blaman nae kurrópdü. Wa inzan we zitülkusdü irrbünürr, i wata sip a gout ibü obzek kwata ki korale, i nae anónóm nóma togoble. I nae anónóm nóma togoblórr, ibü ene kupo balngón ubia ugón yazeblórr. ");
INSERT INTO tof_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Sip a gout ene nugup tiz obzek kwata tibióbbóka olngolórr. Solodó ene ópala küsil kupo balngónónóp. Ngibürr ngüin wibagótórrón, ngibürr ngüin kari baeb pokopükü, ngibürr ngüin wirri baeb pokopükü. ");
INSERT INTO tof_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Zeikob ene küsil sip a gout kupo nürrgrrütóp ene dudu ngorodógabi. Wa barre sip a gout irrbünürr obzek ama Leibanón pug a wi-wi sopae kwóbdü. Wa tóbankü sip a gout yabül we ngarkwatódó tómbapónórr. Wa tóba yabül Leibanónpükü koke dayónürr. ");
INSERT INTO tof_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ene arüng sip a gout kubó dabyónüm nóma bairre, Zeikob kubó ene tiz ibü obzek kwata irrbüle ene nae kurrópdü. Ene igósüm, i kubó ene tiz minggüpanandó dabyónórre. ");
INSERT INTO tof_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Zeikob nugup tiz koke irrbünürr arüng-koke sip a gout, ibü obzek kwata. Da olgabi módóga, arüng-koke sip a gout Leibanka ogoblórr. A morroal arüng klama Zeikobka ogoblórr. ");
INSERT INTO tof_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Inzande Zeikob wirri mórrel pamóm bainürr. Oya abün sip a gout, leba zaget kolpam, akó ⌊kamel⌋ a ⌊donki⌋ kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Darrpan ngürr Zeikob arrkrrurr Leibanón simanal olmala ne poko ikik kwarilürr wagó, “Zeikob mibü aban blaman elklaza kuri imtyónürr; wa tóba mórrel kuri ipadórr mibü aban elklazadógab!” ");
INSERT INTO tof_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Zeikob ta umul bainürr Leibanón tórrmen tulmila ama darrü tonarr bainürr; ngaen-gógópan inzan koke yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Da ⌊Lod⌋ Zeikobka bóktanórr wagó, “Ugó alkomól moba abalbobatalab tüpdü akó moba zonaretaldó. Ka sab marüka asi namulo.” ");
INSERT INTO tof_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Da módóga, Zeikob bóktan we zirrapónórr Rreizel a Lia ibü tótókóm ⌊sip⌋ a ⌊gout⌋ ngabkan bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Wa ibüka bóktanórr wagó, “Ka kuri esena yabü aban tórrmen tulmil ngaen inzan koke yarilürr. A kürü aban God kankü asi yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","E umulamli ka yabü abankü kólba amkoman arüngi zaget namülnürrü. ");
INSERT INTO tof_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","A yabü aba ma kürü pugdü küngrilürr; wa kürü darrem kla amaiksimaik nangónónóp 10 münüm. God ma oya koke ok yónürr kürü kulainüm. ");
INSERT INTO tof_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Leiban igó nóma bóktanórr wagó, ‘Pug pokopükü sip a gout marü darrem kwarile,’ da God wató tónggapónórr blaman sip a gouta pug pokopükü kupo balngónóm. A Leiban igó nóma bóktanórr wagó, ‘Wi bagótórrón sip a gout marü darrem kwarile,’ da God wató tónggapónórr blaman sip a gouta wi bagótórrón kupo balngónóm. ");
INSERT INTO tof_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Inzan kwata God yabü aban sip a gout kuri imtyónürr, ama kürü kuri küliónürr. ");
INSERT INTO tof_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Sip a gout, ibü darrpan pokodó ut ubi nóma semrranórr, ka igó nus umtulürrü. Ka we kla eserró simanal gouta ópalpükü nóma dabyónóp: ibü ngüin wi bagótórrón, pug pokopükü, akó póróm-póróm kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","⌊Godón anerrua⌋ kürüka nus bóktan yarilürr wagó, ‘Zeikob!’ Ka bóktan yalkomólórró wagó, ‘Ka inamüla.’ ");
INSERT INTO tof_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Da wa bóktanórr wagó, ‘Tai ngaka, ese! Ne simanal gouta ópal goutpükü dabyóndako, ibü ngüin wi bagótórrón, pug pokopükü, akó póróm-póróm kwarilürr. Ka ini poko igósidi tónggapóna, zitülkus ka blaman ene poko basen namülnürrü Leiban marüka nebóka elngólórr. ");
INSERT INTO tof_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ka ne Godla marüka nótó okaka tübyónürr Betelóm, ma ne ⌊olib⌋ oel nóla ekarró ingülküp kwitüdü kürü ⌊ótókóm⌋, akó ma ⌊arüng alkamül-koke bóktan⌋ nóla tónggapórró kürüka. Ma ugó bupa, da ini kantrri amgat. Moba amtómól tüpdü alkomól.’” ");
INSERT INTO tof_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rreizel a Lia bóktan we yalkomólórri, “Kibü aban elklaza ia asi korale kibü azebóm oya büdül kakóm? ");
INSERT INTO tof_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Wa kibü amkoman mogob kol niszan ngakanda. Wa kibü marüka darreme tómrókórr, da wa ene mani kuri elolórr. ");
INSERT INTO tof_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Amkoman, God blaman ne elklaza mibü abdógab kuri imtyónürr, errkya ma midipa akó mibü olmalabko. Da ma tónggapó, marü God enezan mile.” ");
INSERT INTO tof_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Da módóga, Zeikob bupadórr, tóba kol a olmal ⌊kamelab⌋ kwitüdü we yamselórr, ");
INSERT INTO tof_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","da wa tóba blaman ngabyón lar singül kwata nolngomólnóp, akó blaman ne elklaza kwób isurr Padan Arramóm. Wa we klampükü alkomólórr tóba abdó Aesakka, Keinan tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","I solkwat bakonórr, Rreizel tóba aban müótan obae godab dandang kla gómól-gómól ngaen-gógópan ugón yazebórr, Leiban nóma wamórr sip ngüin alüküm. ");
INSERT INTO tof_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ene kwitüm, Zeikob Leibanón, Arramia pam, we ilklió iliónürr; wa oya koke umul-umulan ngitanórr wagó, wa busodase. ");
INSERT INTO tof_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Da wa tóba blaman elklazapükü we busorr oya ne kla koralórr. Wa Yuprreitis tobarr we banikürr, obzek ama ola yarilürr Gilead podopükü bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Aüd ngim ngürrdü, Leibanón ugón izazilóp wagó, Zeikob busorróna. ");
INSERT INTO tof_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Leiban tóba simanal zonaretal yazebórr, da 7 ngürrüm Zeikobón we kolakyanónóp solkwat. Oya we emrrónóp Gilead podopükü bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Da God ene irrüb nus tamórr Leibanka, Arramia pam, da oyaka we tóbtanórr wagó, “Ma umul-umul namulo Zeikobka kolae poko bóktan-gum!” ");
INSERT INTO tof_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Leiban Zeikobón nóma emrranórr, wa tóba palae müót Gilead podopükü bwóbdü ingrinürr singül kwata. Leiban tóba zonaretalpükü tibiób palae müót ta ola balmelóp. ");
INSERT INTO tof_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Leiban Zeikobka bóktanórr wagó, “Ma ia poko tónggapórró? Ma kürü ilklió kliórrü, akó ma kürü ngul olom nis gómól kwata tüdódürrü, wamaka ma gazirr pokodügab nüpadórró. ");
INSERT INTO tof_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ma kürükagab piküpan iade sibsorró akó ilklió kliórrü kürü? Ma kürü koke iade küzazilürrü? Ene igósidi, ka marü ki zirrkapórró barnginwómi wórrpükü, tambarran bólkalkü akó ap bapulkü. ");
INSERT INTO tof_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ma ta kürü koke ok kyórró kólba bobatal akó ngul olom nis aprüküm ibü yawal boweanóm. Ma gonggo poko tónggapórró! ");
INSERT INTO tof_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kürü ene arüng asine marü kulainüm. A irrüb marü aban God kürüka tóbtóne wagó, ‘Ma umul-umul namulo Zeikobka kolae poko bóktan-gum!’ ");
INSERT INTO tof_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ma igósidi bupadórró, zitülkus marü wirrian ubia müpadórr moba aban müót basirrdü alkomólóm. A ma kürü godab dandang kla gómól-gómól iade yazebórró?” ");
INSERT INTO tof_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Zeikob bóktan yalkomólórr Leibanka wagó, “Ka gum namülnürrü, zitülkus kamaka ma sab moba óp olom nis arüngi nüpüdo kürükagab. ");
INSERT INTO tof_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ma ne darrü olom nóma eseno marü godab dandang kla noakamako, da wa koke ki ngyabe. Mibü zonaretalab ilküpdü ma müób kóbó yamkü, ia marü darrü kla kürüka asine. Asi ne nóma yarile, ipadke!” Zeikob umul-kók yarilürr wagó, Rreizel Leibanón obae godab dandang kla gómól-gómól wató yazebórr. ");
INSERT INTO tof_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Da Leiban Zeikobón palae müótüdü bangrinürr angónóm, akó Lian palae müótüdü bangrinürr, akó nis zaget kol nisab palae müótüdü ta bangrinürr, a wa ma darrü kla koke esenórr. Olgabi ama Rreizelón palae müótüdü bangrinürr. ");
INSERT INTO tof_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rreizel wató yazebórr oya obae godab dandang müótüdü kla, da tóba kamelan kakota mórran kla gómóldó kolatanórr, ó tüób ma ene kwitüdü mórran warilürr. Leiban blaman bwób engólórr ene palae müótüdü, a wa ma darrü kla koke esenórr. ");
INSERT INTO tof_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rreizel tóba abdó bóktanórr wagó, “Ma kürüka ngürsilgu, ka kari gyaur kokela, a ka gaodó kokela marü obzek kwata zamngólóm, zitülkus ka kólba kolab azidpükümla.” Leiban ene palae müót enan engónórr, tóba obae godab dandang müótüdü kla ta kokean nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Leibanón nóma blakónórr, Zeikob ngürsil yarilürr oyaka, da bóktanórr wagó, “Ka ia laró kolae tórrmen tónggapórró? Ia ka laró kolae tonarr tónggapórró, da ma kürü igósidi kolakyandóla? ");
INSERT INTO tof_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Da ma kürü blaman elklaza kuri bapila; darrü kla ia ma esena marü müótan ne kla yarilürr? Ma ne nóma esena, ini singri marü akó kürü pamkolpamab obzek kwata. Mibü nizan idi ki zaz tinünüm, amkoman ia nótóka. ");
INSERT INTO tof_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ka mankü 20 pailüm namülnürrü kókóta errkya. Marü sip a gout ibü bikóma koke kolae bainónóp. Ene tumum, ka darrü sip ngorodógab siman sip murr kokean elóngórró. ");
INSERT INTO tof_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ka marüka darrü büdül sip akó gout kokean sidódürrü, nurr lara ne kla okrralórr. Ka ibü gaodó kólbanóm sip a gout müliónürrü. Ngürr a irrüb gómól-gómól ne klama bamrüknóp, ma kürü darrem klamóm ta katonórró. ");
INSERT INTO tof_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Inzan yarilürr kürüka: blaman ngürrzan abüs urura kürü koklamlórr; irrüb ma ka güb tórrngón aengnórró. Ka utüm nabe kainürrü. ");
INSERT INTO tof_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ka marü müótüdü namülnürrü 20 pailüm. Ka 14 pailüm zaget apoarró marü óp olom nisabkü, akó 6 pailüm marü sip a gout ngabkande, akó ma kürü zagetan darrem ta amaiksimaik yangórró 10 münüm. ");
INSERT INTO tof_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kürü abbobat Eibrra-amón God, akó kürü ab Aesak ne Godón gum angólórr, wa kankü babul ne nóma ki yaril, ma amkoman kürü ngaen ki zirrkapórró tang küpan. A God ma kürü müp ngasekalórr akó ka ne wirri zaget tómbapónórró, da sim irrüb God marü zaz mine.” ");
INSERT INTO tof_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Leiban Zeikobka bóktan yalkomólórr wagó, “Ini kol nis kürü óp olom nisamli; ibü ta ne olmalko, kürü olmalko, akó ini ne sip a gout ta kürüko. Blaman elklaza ma ne kla basendóla, kürüko. A ka ma errkya gaodó kokela darrü kla tónggapónóm kólba óp olom nis arrmatóm. ");
INSERT INTO tof_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yao, ugó tam, mi errkya alkamül-koke tónggapórrón bóktan angrindamli, matóka kótó, da mibü sab we bóktana alngomól yarile.” ");
INSERT INTO tof_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Da Zeikob wirri ingülküp ipadórr, da alaninürr, ene bóktan gyagüpi amaiküm. ");
INSERT INTO tof_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Wa tóba pamdó bóktanórr wagó, “Ngibürr ingülküp dakainam.” Da i ingülküp yazebóp, darrpan kwób we apónóp. Da i blamana alo we elop ene ingülküp kwób ne yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Leiban ene ingülküp kwób ngi we ngyesilürr wagó, Zegarr Sa-aduta, akó Zeikob ta ngi ngyesilürr wagó, Galid. ");
INSERT INTO tof_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Leiban Zeikobka bóktanórr wagó, “Ini ne ingülküp kwóbe errkya mibü gyagüpi amanik timama; matóka kótó.” Zeikob ene ingülküp kwób Galidbóka igósidi ngyesilürr. ");
INSERT INTO tof_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Leiban ta bóktanórr wagó, “Lod sab ilküp ki singri mibüka, mi sab enezan bürrgrrüti,” da ene ingülküp kwóban darrü ngi we kla yarilürr, Mizpa. ");
INSERT INTO tof_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Leiban akó bóktanórr wagó, “Ma ne sab kürü óp olom nis kle-kle nóma ngankalo, ó akó ma ne ngibürr kol nóma bumigo, mibü ne darrü pama koke nóma tósene, gyagüpi wam, God mibü wató ngabkanda.” ");
INSERT INTO tof_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Leiban akó Zeikobka bóktanórr wagó, “Ingülküp kwób yóni, akó kokrrap ingülküp ta yóni, ka ne kla alanina mibü aodó, matóka kótó. ");
INSERT INTO tof_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ini ingülküp kwób akó ini alanirrün ingülküp mibü timam nisamli, wagó, ka sab koke bórrgrróto marü kolae ainüm, ó ma ta inzan, ma sab koke tóbgrróto kürü kolae ainüm. ");
INSERT INTO tof_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Eibrra-amón God akó Na-orrón God, ibü ab nisab God nótóke, mibü sab wató ki zaz tiyón.” Da Zeikob arüng alkamül-koke bóktan we tónggapónórr Godón ngidü, oya ab Aesak ne Godón gum angólórr. ");
INSERT INTO tof_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Zeikob ola podopükü bwóbdü ngóyón lar emkalórr, da ngibürr murr poko urdü yamselórr Godón agürüm, da akó tóba kolpam we ngibaunürr usakü ene ngibürr murr poko alóngóm. Ibü alongaloa nóma blakónórr, i ene irrüb ola bazurrurr. ");
INSERT INTO tof_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Zokrrok darrü irrbi, Leiban tóba bobatal akó óp olom nis nüprükóp, akó bles nütünóp. Da Leiban ibü we bimgatórr, ama tóba bwóbdü alkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Zeikob ta inzan tóba kwata wamórr, da Godón ngibürr anerrua oya semrrónóp. ");
INSERT INTO tof_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wa ibü nóma nósenóp, wa bóktanórr wagó, “Ini Godón marrgu-e!” Da wa ene bwób Ma-anayimbóka igósidi ngyesilürr. ");
INSERT INTO tof_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Zeikob ngibürr yada ódód pam zirrnapónóp oya singül kwata tóba naretódó Isaoka, Seirr bwóbdü, Idom tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Wa ibü igó bóktan ikik nókrrónóp wagó, “E kubó ini poko bóktónane kürü wirri pamdó Isaoka: ‘Zeikob, marü zaget pam, ini bóktan zirrsapóne marüka, ka Leibanka ngyaben namülnürrü, kókó tai ini ngarkwat. ");
INSERT INTO tof_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Kürü ⌊kau⌋, ⌊donki⌋, ⌊sip⌋ a ⌊gout⌋ asiko, akó ópal a simanal ⌊leba zaget⌋ kolpam. Ka ini bóktan marüka zirrapóndóla, kürü wirri pam, igósüm ma moba obzek kwata kürüka morroal eseno.’” ");
INSERT INTO tof_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Yada ódód pama nóma tóbakonórr Zeikobka, i sidrrütóp wagó, “Ki marü naretódó, Isaoka ogoba. Wa errkya kwat-kwata marü asenóm. Wa 400 ngarkwat pampüküma.” ");
INSERT INTO tof_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Zeikobón wirri guma ipadórr, akó müp gyagüpitótóka simiógürr. Wa pamkolpam nis kopo nangónórr, wankü nidi kwarilürr. Akó sip a gout, kau, akó ⌊kamel⌋, ibü ta inzan nangónóp. ");
INSERT INTO tof_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Wa gyagüpi wamórr wagó, “Isao ne sab nóma tame ngaensingül kopodó gazirrüm, darrü kopoan kekam yarile busom.” ");
INSERT INTO tof_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Da Zeikob tóre ekorr wagó, “Kürü abbobat Eibrra-amón Godóe, akó kürü ab Aesakón God, kürü tóre turrkrru. O ⌊Lod⌋, ma kürüka tóbtarró wagó, ‘Mobanan tüpdü akó moba zitül pamkolpamdó alkomólke’, akó wagó, ‘Ka sab morroal sidüdo marüka.’ ");
INSERT INTO tof_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ka marü ngarkwatódó kokela, ma ne morroal tonarr okaka simzazilürrü kürüka, marü zaget pam, akó ma ne kla tómbapónórr kürüka, mazan bóktarró. Ka Zodan tobarr nóma baniknürrü, kürü wata tupuruan yarilürr. Kürü ma errkya nis wirri kopo nisamli! ");
INSERT INTO tof_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kürü zid kyó, ka tóredóla, kólba naretan tangdógab, Isao, zitülkus ka gumla wa kubó tame kürü amkalóm, akó aipal tibiób olmalpükü. ");
INSERT INTO tof_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Da ma ta tóbtarró wagó, ‘Amkoman, ka sab morroal sidüdo marüka, akó ka marü olmalbobatal abün ninünümo, ena bürrkós, malu nóreszane.’” ");
INSERT INTO tof_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Zeikob ene irrüb ola umtulürr, akó darrü irrbi oya ne ngabyón lar kwarilürr, wa Isaonkü ini ngarkwat ⌊gyaur kla⌋ ilianórr: ");
INSERT INTO tof_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 ópal gout akó 20 simanal gout, 200 ópal sip akó 20 simanal sip, ");
INSERT INTO tof_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ngómrin ópal kamel tibiób kupopükü, 40 ópal kau akó 10 simanal kau, 20 ópal donki akó 10 simanal donki. ");
INSERT INTO tof_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Wa ibü wirri ngorodógab tibi-tibi arrgrratlórr, da zaget pamab tangdó irrbünürr, akó wa ibüka bóktanórr wagó, “E kürü singül kwata ogoblón; kan apólamke darrpan-darrpan ne kopoko.” ");
INSERT INTO tof_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Zeikob ngaensingül kopo ne zaget pama arüng bóktan ekyanórr wagó, “Kürü nareta Isao marü kubó nóma kómrróne akó mümtine, ‘Ma noanla, akó ma ia nubó tótókdóla, akó blaman ini ngabyón lar marü obzek kwata noanko?’ ");
INSERT INTO tof_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","da ma igó bóktanke magó, ‘Ini marü zaget pam Zeikobón ngabyón larko. Wa gyaur kla zirrtapórre kürü wirri pam Isaonkü. Wa tüób kibü solodó akyanda.’” ");
INSERT INTO tof_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Zeikob akó dadan arüng bóktan nókyenóp nis ngim zaget pam, aüd ngim zaget pam, akó blaman ngibürr zaget pam oya ngabyón lar nidi nolngomólnóp, wagó, “E kubó wata dadan bóktan poko arüklamke Isaoka, e usakü nóma basenane. ");
INSERT INTO tof_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","E wata kubó inzan bóktalamke magó, ‘Marü zaget pama Zeikob kibü solodó akyanda.’” Zeikob gyagüpi wamlórr wagó, “Ka Isaon saul ino ini gyaur klame, ka singül kwata ne kla zirrbapóndóla; da solodó, ka oya nóma eseno, aprrapórr wa kubó kürü morroal küpüde.” ");
INSERT INTO tof_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Da Zeikobón gyaur klama oya singül kwata ogoblórr, a wa ma tüób ene irrüb dadan marrgudü ola umtulürr. ");
INSERT INTO tof_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ene dadan irrüb Zeikob türsümülürr, tóba kol nis nüpadórr, tóba zaget kol nis, akó tóba 11 simanal olmal, Zabok sang kus bwób baurrlürr. ");
INSERT INTO tof_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Wa ibü dakla dorrodó nóma amanórr, tóba blaman elklazapükü zirrnapónóp dakla dorrodó. ");
INSERT INTO tof_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Da Zeikob tebean we burrmatórr. Da darrü pama tamórr; i usadi we bumiógtübumióg namülnürri tai kókó sisa tuninürr. ");
INSERT INTO tof_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ene pama nóma ngakanórr igó, wa gaodó koke yarilürr Zeikobón ⌊ut-ut ainüm⌋, wa Zeikobón darrü kartül yamurrürr, da ubi augürr, wa ene pampükü nóma bumiógtübumióg yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Da ene pama Zeikobka bóktanórr wagó, “Ka kya wamón, zitülkus sisa!” Zeikob bóktan yalkomólórr wagó, “Ka marü kokean molkomolo, kókó ma kubó kürü bles kino!” ");
INSERT INTO tof_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ene pama oya imtinürr wagó, “Marü ngi ia nótóke?” Wa bóktan yalkomólórr wagó, “Zeikob.” ");
INSERT INTO tof_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Da ene pama bóktanórr wagó, “Marü ngi sab myamem Zeikob koke yarile, a Isrrael, zitülkus ma God akó pamkolpampükü bumiógtübumióg namüla, da mató bórrgrróta.” ");
INSERT INTO tof_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Da Zeikob oya imtinürr wagó, “Gyaurka, kürü moba ngi küzazil.” A wa bóktan yalkomólórr wagó, “Ma kürü ngim iade kümtina?” Da wa oya we bles yónürr. ");
INSERT INTO tof_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Da Zeikob ene bwób Penielbóka igósidi ngyesilürr wagó, “Ene zitülkus módóga, ka Godón obzek esena, da ka ma wata arrólóla!” ");
INSERT INTO tof_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Abüsa tüngürürr Zeikob Peniel bwóbzan sórrgrratlórr, da Zeikob tóba kartül amkónkü wamlórr. ");
INSERT INTO tof_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","We zitülkusdü, kókó errkya ini ngürr, Isrrael pamkolpama kartül kusdü arróbórrón ne murrko koke alóngdako, zitülkus Zeikobón ene kartül murr yamurrürr. ");
INSERT INTO tof_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Zeikob kwit yazilürr, da módóga, Isaon esenórr tótókde tóba 400 pampükü. Da olmal tibiób we nürrgrrütóp: Lian tóba, Rreizel akó nis leba zaget kol nisab go tibiób. ");
INSERT INTO tof_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Zeikob zaget kol nis tibiób olmalpükü ngaensingül irrbünürr, da Lia akó tóba olmal ibü solkwat atanóm, akó Rreizel a Zosep solo dómdóm idi murrausürri. ");
INSERT INTO tof_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Wa tüób singül apónórr ibükagab. Wa tóba naret nóma ngorram syónürr, wa tóba singül 7 münüm tüp elkomólólórr oya morroal angónóm. ");
INSERT INTO tof_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Isao sibsorr Zeikobka, da tange myangrao apónórr, oya iprükürr. Da i nizana yón namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Isao kwit nóma yazilürr, wa kol nósenóp tibiób olmalpükü, da Zeikobón imtinürr wagó, “Ini ia nidipako mankü?” Zeikob bóktan yalkomólórr wagó, “Ini we olmalako, God tóba ⌊gail tonarrdógab⌋ kürü küliónürr.” ");
INSERT INTO tof_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Da zaget kol nisa tibiób olmalpükü ngorram sinóp, Isaon obzek kwata wakósingül nümgünóp, singül tüp elókóp. ");
INSERT INTO tof_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Olgabi ma Lia tóba olmalpükü katókórr, wakósingül nümgünóp, singül tüp elókóp. Dómdóm Zosep a Rreizel ta inzan kairri. ");
INSERT INTO tof_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Isao imtinürr wagó, “Ka kwat-kwat ne ngabyón lar yabül tómrrónóma, ibü küp laróga?” Zeikob bóktan yalkomólórr wagó, “Kürü wirri pam, i gyaur klamako, igósüm ma moba obzek kwata kürüka morroal eseno.” ");
INSERT INTO tof_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","A Isao bóktanórr wagó, “Kürü zoret, kürü gaodómako. Emorra marü ne klamko mobankü.” ");
INSERT INTO tof_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Da Zeikob bóktanórr wagó, “Koke, gyaurka! Ma moba obzek kwata kürüka ne morroal nóma seserró, ini gyaur kla kürükagab sazeb. Marü obzek asende, wamaka ka Godón obzek kuri sesena, zitülkus ma kürü errkyadan morroal kuri küpüda. ");
INSERT INTO tof_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Gyaurka, ini gyaur kla sazeb, ka marünkü ne kla simarrua. God kürüka gail tonarr yarilürr, akó wa kürü abün elklaza küliónürr, ka ne klamóm namülnürrü.” Zeikob Isaon wata arüngi yatolórr, kókó Isao oya ubi ipadórr ene gyaur kla azebóm. ");
INSERT INTO tof_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Da Isao bóktanórr wagó, “Ugó tómbapó, da nau; mi darrpan mün aurri.” ");
INSERT INTO tof_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","A Zeikob oyaka bóktan yalkomólórr wagó, “Kürü wirri pam, ma umulóla igó poko wa, olmal arüng kokeako, akó ka umul-umul namulo ópal ⌊sip⌋ akó ópal ⌊kau⌋ ngabkanóm, zitülkus ibü kupo ngóm taedómako. Mi ibü ne wirri arüngi nóma amarru kwarilo wata darrpan ngürrüm, blamana kubó nurrbarine. ");
INSERT INTO tof_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Da kürü wirri pam, ma ngaensingül wamlón kürükagab, marü zaget pam. Ka kubó zaorrón akyalo, ngabyón larab akó olmalab agól ngarkwatódó, kókó ka sab marü memrrono, kürü wirri pam, Seirr bwóbdü, Idom tüpdü.” ");
INSERT INTO tof_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Da Isao bóktanórr wagó, “Ka ta kubó kólba ngibürr zaget pam marüka módó bimgüta.” Zeikob bóktan yalkomólórr wagó, “Ma ene poko iade tónggapónóm kaindóla? Kürü wirri pam, ma moba obzek kwata kürüka morroal esena, ene gaodó kuri namüla.” ");
INSERT INTO tof_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Da ene ngürr Isao bupadórr Seirr bwóbdü alkomólóm. ");
INSERT INTO tof_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","A Zeikob ma Sukot wamórr. Wa ola tóbankü müót elórr akó murr müót balmelórr tóba ngabyón larabkü. Ene basirr ngi igósidi ngyesilóp Sukot. ");
INSERT INTO tof_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Zeikob Padan Arram nóma amgatórr, wa Syekem wirri basirrdü morroal tübzilürr, Keinan tüp kugupidü, akó wa darrü marrgu wirri basirran obzek kwata tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Wa tóba palae müót ne balmelórr, ene tüp poko 100 ⌊silba⌋ poko-e amiógürr Amorrón simanal olmaldógab, Syekemón ab. ");
INSERT INTO tof_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Wa ⌊alta⌋ ola elórr ene tüp pokodó, da ngi ngyesilürr wagó, El, Isrraelón Gode. ");
INSERT INTO tof_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Darrpan ngürr Daena, Lia ne óp olom osenórr Zeikobkagab, wa Keinan basirr kol bangónóm natókórr. ");
INSERT INTO tof_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ene bwób singüldü balngomól pam Amorr, Ibait bóktan pam, oya siman olom ngi Syekem yarilürr. Daenan nóma osenórr, zumiógürr, da oya kle tiz wangónórr. ");
INSERT INTO tof_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Syekemón moboküpa arróbórr Daenaka, Zeikobón óp olom, da oya ubia wamórr Daenakamóm, akó wa mis ikik yazeblórr oyaka. ");
INSERT INTO tof_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Da Syekem tóba abdó Amorrka bóktanórr wagó, “Ene ngulmokur kürünkü upa kolóm!” ");
INSERT INTO tof_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Zeikob nóma arrkrrurr wagó, oya óp olom, Daenan, kuri kle wangóne, oya simanal olmal ugón ⌊sip⌋ a ⌊gout⌋ ngabkan bwóbdü kwarilürr. Wa darrü poko koke bóktanórr enekwata, kókó i müót basirrdü tübabzilürr. ");
INSERT INTO tof_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Da Syekemón aba, Amorr, Zeikobka Daenankwata bóktanóm wamórr. ");
INSERT INTO tof_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Zeikobón simanal olmala nóma barrkrrurr, i sip a gout ngabkan bwóbdügab ugón tóbakonórr. I gyaur akó wirri ngürsil kwarilürr, zitülkus Syekem ne kolaean poko tónggapónórr, Isrrael pamkolpamab ilküpdü büód sidódürr. Ene dümdüm koke yarilürr Zeikobón óp olompükü nóma umtulürr; ene tónggapón-koke poko yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","A Amorr ibüka bóktanórr wagó, “Kürü siman olom, Syekem, oya wirri ubia kuri wame marü óp olomdó. Gyaurka, ekya oya kolóm. ");
INSERT INTO tof_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mi sab kol gyabalómnórre; e kibü ngul olmal twazeblo, akó ki go darrem yabünüm ngul olmal wazeblo kibiób kolóm. ");
INSERT INTO tof_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","E kinkü ae ngyabelam. Tüp módóga, popada yabüka! Ngyabelamke ini tüpdü. Agóltagól akó tüp poko bumióg sab popa yarile.” ");
INSERT INTO tof_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Da Syekem bóktanórr Daenan abdó akó simanal bólbótaldó wagó, “E yabiób obzek kwata kürüka ne morroal nóma seserre, da ka sab yabü nüliónünümo, e kubó kürü ne klamóm kilane. ");
INSERT INTO tof_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ini kolan darrem akó ka sab ne gyaur kla samtülo, yabiób ubi ngarkwatódó irrbünam. Ka sab ekrralo, e kubó kürü ne klamóm kilórre. E wata kürü ene ngul oloman kókyenam kolóm.” ");
INSERT INTO tof_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Zitülkus Syekem ibü bólbót, Daenan, kle tiz wangónórr, Zeikobón simanal olmala Syekem akó oya ab, Amorr, ibüka ilklió bülión bóktan yalkomólóp. ");
INSERT INTO tof_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","I bóktónóp wagó, “Ki inzan kla kokean tónggapórre; ki kibiób bólbót kokean ekyerre ⌊gyabi sopae singgalgón⌋-koke pam. Ene büód poko yarile kibüka. ");
INSERT INTO tof_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","A ki darrpan dümdümdü ubi bairre: e sab kizan bainane, yabü blaman pamab gyabi sopae ne singgalgórrón nóma korale. ");
INSERT INTO tof_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Da mi sab kol gyabalómlo. Akó ki sab yabü aodó ngyabenórre; mi sab darrpan kolpamóm bairre. ");
INSERT INTO tof_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","A e ne koke nóma ubi bairre yabiób pamab gyabi sopae singgalgónóm, ki sab kibiób bólbót upudórre, da ogobo.” ");
INSERT INTO tof_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amorr a Syekem abirri, i ne gyagüpitótók bóktan ingrinóp. ");
INSERT INTO tof_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Da Syekem koke ürrbainürr i oya ne poko tónggapónóm ilóp, zitülkus oya wirri ubi yarilürr Zeikobón óp olomdó. Syekem wirri ngi pam yarilürr Amorrón müótan pamkolpamdógab. ");
INSERT INTO tof_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Da Amorr akó tóba siman olom Syekem we aurrürri kwób bazen pokodó, ibü wirri basirran barrbün mamtaedó, tibiób basirr pamdó bóktanóm. ");
INSERT INTO tof_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","I bóktarri wagó, “Ini pam morroal tonarrako mibüka, i ki ngyabelam mibü tüpdü, akó ki agóltagól koralón, zitülkus tüp wirria ibünkü. Mi sab ibü ópal olmal mibiób kolóm wazeblo, akó mi sab mibiób ópal olmal ibü nüliónórre kolóm. ");
INSERT INTO tof_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","A ene pama ubi bairre minkü ngyabenóm akó darrpan kolpamóm bainüm wata ini darrpan dümdümdü wagó, mibü blaman pamab gyabi sopae singgalgórrón kwarile ibüzanko. ");
INSERT INTO tof_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mi ne ini kla nóma tónggapórre, ibü sip a gout akó ngibürr ngabyón lar sab mibü iade kwarile. Mi ibü ubi ipüdórre, da i sab minkü aini iade ngyabenórre.” ");
INSERT INTO tof_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Da blaman pam ene wirri basirran barrbün mamtaedó nidi kwób bazelórr, ubi bainóp Amorr akó Syekem ibü bóktandó, da blaman simanal olmal akó pam ene wirri basirrdü ibü gyabi sopae singgalgónóp. ");
INSERT INTO tof_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aüd ngim ngürrdü, blaman pam gyabi sopae singgalgórrón azidüdü nóma kwarilürr, Zeikobón siman olom nis, Simion akó Libae, Daenan siman bólbót nis, tibiób gazirr turrik nüpadrri, da gazirrüm sakó-sakó aurrürri ene wirri basirrdü. Umul-koke arrkürr gazirr yarilürr, da nizana ene wirri basirran blaman pam büdülümpükü ekrrarri. ");
INSERT INTO tof_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","I Amorrón tóba siman olom Syekem ta gazirr turriki büdülümpükü nómkólóp, akó Daenan Syekemón müótüdügab urruarri, da i ene basirr we amgütóp. ");
INSERT INTO tof_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Zeikobón ngibürr simanal olmala büdül büb tómrrónóp, da wirri basirrdü blaman ne elklaza kwarilürr popa yazebóp, ibü bólbót Daenan kle tiz nóla wangónóp. ");
INSERT INTO tof_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ibü sip a gout, ⌊kau⌋, akó ⌊donki⌋ yazebóp. Akó i ta blaman elklaza yazebóp wirri basirr kugupidü, akó ngaon bwóbdü ne elklaza kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ibü blaman ne mórrel elklaza kwarilürr, kol akó olmal, akó müót kugupidü blaman ne elklaza kwarilürr, barrmülürr. ");
INSERT INTO tof_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Da Zeikob, Simion akó Libae ibü nyalórr wagó, “E kürüka wirri müp kuri sidüdi. Keinan akó Perrez pamkolpama akó blaman pamkolpama ini tüpdü nidi ngyabendako, sab kürü alzizi kümaniknórre. Kürü aüdan pamako; i ne mibü akrranóm nóma dabirre akó mibüka ne nóma tóbrrónge, kótó akó kürü müótüdü pamkolpam, mibü sab kolae tirre.” ");
INSERT INTO tof_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","A Simion akó Libae bóktan yalkomórri wagó, “Ia wa kibü bólbót inzan ki kle wangónól, wamaka wa popa kwatódó agól kolo?” ");
INSERT INTO tof_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","God Zeikobka bóktanórr wagó, “Bupa, da ugó wam Betel, kya ola ngyabelamke. Godónkü ⌊alta⌋ ola elke, wa marüka nóla okaka tübyónürr, ma moba naretan Isaon gum nóma busonürrü.” ");
INSERT INTO tof_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Da Zeikob tóba müót kolpamdó akó wankü nidi kwarilürr, ibüka bóktanórr wagó, “E kubó amalamke blaman mogob godab dandang yabüka ne klamko, ó e yabiób bübpükü ta bagulamke mibü gida ngarkwatódó, akó dólóng mórrkenyórr bamelamke. ");
INSERT INTO tof_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Yao, ugó bazeb, mi Betel tótókdakla, ka sab alta nóla elo Godka, kürü tóre nótó arrkrrurr ka müpdü nóma namülnürrü, akó kankü wa ta asi yarilürr ka negama wamnórró.” ");
INSERT INTO tof_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Da i blamana tibiób mogob godab dandang kla Zeikobón ilinóp, akó i güblangdó ne rring bamelóp. Da módóga, Zeikob tüp kugupi apónórr, blaman ene elklaza ola nodóp kugupidü, wirri ouk nugup murrdü Syekem wirri basirr minggüpanandó. ");
INSERT INTO tof_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","I we bazebórr, da minggüpanan wirri basirr pamkolpam Godónbókamde guma yazebórr, da i Zeikobón koke igósidi kolakyanónóp. ");
INSERT INTO tof_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Da módóga, Zeikob tóba pamkolpampükü Luz basirrdü we abzilürr Keinan tüpdü. Errkya ene basirr ngi igó ngiliandako, Betel. ");
INSERT INTO tof_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Wa alta ola elórr, ó wa ene tüp poko ngi we ngyesilürr wagó, El Betel, zitülkus God tóba we okaka tübyónürr Zeikobka, wa tóba naretan Isaon gum nóma tupsolürr. ");
INSERT INTO tof_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","I Betelóm nóma ngyabenónóp, Deborra ugón nurrótókórr, Rrebekan zaget kol, oya ngóyón aip. I oya ouk nugup murrdü we ulungóp Betel basirr malubarrdóbóna. Da Zeikob ene poko ngi we ngyesilürr Alon Bakut. ");
INSERT INTO tof_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Zeikob Padan Arramgabi nóma tolkomólórr, God akó nis ngim oyaka we okaka tübyónürr. Da wa oya bles yónürr. ");
INSERT INTO tof_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God oyaka bóktanórr wagó, “Marü ngi wa Zeikobe, a marü ma sab Zeikobbóka myamem koke ngimlianórre; marü ngi ma errkya módóga, Isrrael.” Da ngi we ekyanórr, Isrrael. ");
INSERT INTO tof_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","God akó Zeikobka bóktanórr wagó, “Ka Wirrian Arüng Godla. Sab küppükü bailamke akó marü pamkolpama sab abün ki bainünüm! Marükagab sab kantrri, anda, abün kantrria tómbapónórre, ó marü olmalbobataldógabi sab ngibürra kingüm idi bairre. ");
INSERT INTO tof_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ka Eibrra-am a Aesak ibü ne tüp nókyarró, ka akó marü akyandóla. Akó ka sab ini tüp marü olmalbobatal nókyenónómo marü büdül kakóm.” ");
INSERT INTO tof_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Da God kwitüdü we kasilürr ene pokodógab, wa oyaka ne bóktanórr. ");
INSERT INTO tof_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Olgabi Zeikob kokrrapan ingülküp alaninürr ene pokodó, God oyaka ne tóbtanórr. Zeikob anón gyaur kla akó ⌊olib⌋ oel ekanórr ene ingülküp kwitüm Godón ⌊ótókóm⌋. ");
INSERT INTO tof_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Da módóga, God Zeikobka ne tüp pokodó bóktanórr, Zeikob ene tüp poko ngi we ngyesilürr Betel. ");
INSERT INTO tof_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Zeikob tóba pamkolpampükü Betelgab we bupadórr Eprrat tótókóm. I ngibürr kan ngarkwat nóma kwarilürr Eprrat amrranóm, Rreizelón ugón twarrpinürr. Oya mórran müp yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Rreizelón büba tai wirribóka azidüm nóma bainürr, oloma ugón tómtómólórr. Oya marrna ain kola we wyalórr wagó, “Ma gumgu, marü akó darrü siman oloma.” ");
INSERT INTO tof_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Oya arróla nóma blakólórrma, Rreizel tóba dómdóm ngóni olom ngi we ngyesilürr Ben-Oni. Oya aba ma Benzamin ngi ngyesilürr. ");
INSERT INTO tof_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rreizel nugu uroatórr, da nurrótókórr. Oya Eprrat kwat kabedó we ulungóp. Eprrat errkya Betliembóka ngiliandako. ");
INSERT INTO tof_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zeikob kokrrap ingülküp we alaninürr Rreizelón gapókdó. Errkya ene ingülküp zamngólórrón duduase, Rreizelón gapókdó timamzan. ");
INSERT INTO tof_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Da módóga, Zeikob we bupadórr tóba pamkolpampükü, da wa tóba palae müót we balmelórr Migdal Ederr kakota. ");
INSERT INTO tof_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Zeikob ene bwóbdü nóma ngyaben yarilürr, Rruben Bilan palae müótüdü bangrinürr, da usadi we umturri, aban aüd ngim koldó. Solodó Zeikob tüób arrkrrurr ne pokoa tómbapónórr. Zeikobón 12 simanal olmal kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lian we simanal olmal kwarilürr: Rruben, Zeikobón ngaen siman olom, Simion, Libae, Zuda, Isakarr, akó Zebulun. ");
INSERT INTO tof_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rreizelón nis siman olom nis namülnürri: Zosep akó Benzamin. ");
INSERT INTO tof_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rreizelón ⌊leba zaget⌋ koldógab, ngi Bila, oya nis siman olom nis namülnürri: Dan akó Naptali. ");
INSERT INTO tof_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lian leba zaget koldógab, ngi Zilpa, oya nis siman olom nis namülnürri: Gad akó Asyerr. Ini blaman Zeikobón simanal olmalko, oyakagab nidi tóbabótórr Padan Arramóm. ");
INSERT INTO tof_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Da módóga, Zeikob tóba olmalkolpükü we tolkomólórr tóba abdó Aesakka, Mamrre basirrdü, Kirriat Arrba wirri basirr minggüpanandó. Ene basirr ngi errkya módóga, Ibrron, Eibrra-am a Aesak ne ngyabenórri. ");
INSERT INTO tof_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aesak 180 pailüm ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wa dómdóm ngón we semanórr, da nurrótókórr wirri kokrrap ngyaben kakóm, oya ne abün morroal pail kwarilürr. Da wa tóba abalbobatal nómrrónóp, ngaen nidi nurrbarinóp. Oya olom nisa Isao a Zeikob gapókdó we ingrirri. ");
INSERT INTO tof_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ini Isaon simanal olmalbobatalab ngiko (oya darrü ngi Idom yarilürr). ");
INSERT INTO tof_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Isao mogob kol nis nümiógürr Keinan tüpdügab: Ada, Elonón óp olom, wa Et zitül pam yarilürr, akó O-olibama, Anan óp olom, Zibionón bobat, wa Ibae zitül pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Wa akó zumiógürr Basematón, Isma-elón óp olom, Nebayotón bólbót. ");
INSERT INTO tof_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Elipazón ilngumilürr Isaonkü, Basemat Rreuelón ilngumilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Akó O-olibama ibü balngónórr: Zeus, Zalam, akó Korra. Ini Isaon simanal olmal kwarilürr, Keinan tüpdü oya aüd kola nibiób balngónóp. ");
INSERT INTO tof_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Isao tóba kol yazebórr, tóba simanal olmal, tóba ópal olmal, akó blaman nidi ngyabenónóp wankü, akó oya blaman ngabyón lar, akó blaman elklaza wa ne kla yazebórr Keinan tüpdü, da wa tóba zoret Zeikobkagab barrkyanan kan wamórr darrü tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Zitülkus módóga, ibü elklaza akó ngabyón lar abün kwarilürr, akó ibü darrpan pokodó ngyaben gaodó koke yarilürr. Tüp gaodó koke yarilürr ibü tangbamtinüm ibü ngabyón lardógab. ");
INSERT INTO tof_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Da Isao (oya darrü ngi Idom) Seirr podopükü bwóbdü ngyabenóm wamórr. ");
INSERT INTO tof_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Isao Idom pam kopoab abbobat yarilürr, nidi ngyabenónóp Seirr podopükü bwóbdü. Ini Isaon simanal olmalbobatalab ngiko. ");
INSERT INTO tof_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Isaon siman olom nisab ngi idi namülnürri: Elipaz, Adakagab, akó Rreuel, Basematkagab. ");
INSERT INTO tof_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipazón simanal olmalab ngi idi kwarilürr: Teman, Omarr, Zepo, Gatam, akó Kenaz. ");
INSERT INTO tof_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Isaon siman olom Elipaz, oya nis ngim kol Timna wató warilürr. Timna Amalekón ilngumilürr. Ini Adan simanal bobatalko, Isaon ngaen kol nótó warilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rreuelón simanal olmalab ngi idi kwarilürr: Na-at, Zerra, Sama, akó Miza. Ini Basematón simanal bobatalko, Isaon nis ngim kol nótó warilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Isaon aüd ngim kol, O-olibama, Anan óp olom, Zibionón óp bobat, oya simanal olmalab ngi idi kwarilürr: Zeus, Zalam, akó Korra. ");
INSERT INTO tof_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isaon olmalbobatalab zitül singüldü balngomól pam idi koralórr: Isaon ngaen olom Elipaz, oya simanal olmal: Teman, Omarr, Zepo, Kenaz, ");
INSERT INTO tof_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korra, Gatam, akó Amalek. Ini zitül singüldü balngomól pam koralórr Idom tüpdü, Elipazkagab, Adan simanal bobatal, Isaon kol. ");
INSERT INTO tof_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Isaon siman olom Rreuel, oya simanal olmal: Na-at, Zerra, Sama, akó Miza. Ini zitül singüldü balngomól pam koralórr Idom tüpdü Rreuelkagab, Basematón simanal bobatal, Isaon kol. ");
INSERT INTO tof_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Isaon kol O-olibama, oya simanal olmalab ngi idi koralórr: Zeus, Zalam, akó Korra. Ini zitül singüldü balngomól pam koralórr Isaon kol O-olibamakagab, Anan óp olom. ");
INSERT INTO tof_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ini blaman Isaon simanal olmalbobatalko, akó ibü singüldü balngomól pam. ");
INSERT INTO tof_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seirr darrü Orr pam yarilürr. Oya simanal olmalab ngi módógako: Lotan, Syobal, Zibion, Ana, ");
INSERT INTO tof_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disyon, Ezerr, akó Disyan. Ini Orr pamkolpamab zitül singüldü balngomól pam koralórr, ngaen Idom tüpdü nidi ngyabenónóp. ");
INSERT INTO tof_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotanón siman olom nisab ngi idi namülnürri: Orri akó Eman. Timna Lotanón óp bólbót warilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Syobalón simanal olmalab ngi idi koralórr: Alban, Mana-at, Ebal, Syepo, akó Onam. ");
INSERT INTO tof_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibionón siman olom nisab ngi idi namülnürri: Aya akó Ana. Ini we Ana-e, urur nae arób nótó nósenóp, tóba aban ⌊donkizan⌋ ngabkalórr ⌊ngüin-koke bwóbdü⌋. ");
INSERT INTO tof_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anan olom nisab ngi idi namülnürri: Disyon akó O-olibama. O-olibama wa Anan óp olom warilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disyonón simanal olmalab ngi idi koralórr: Emdan, Esban, Itrran, akó Kerran. ");
INSERT INTO tof_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezerrón simanal olmalab ngi idi koralórr: Bilan, Za-aban, akó Akan. ");
INSERT INTO tof_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyanón siman olom nisab ngi idi namülnürri: Uz akó Arran. ");
INSERT INTO tof_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ini Orr pamkolpamab zitül singüldü balngomól pam koralórr Idom tüpdü: Lotan, Syobal, Zibion, Ana, Disyon, Ezerr, akó Disyan. ");
INSERT INTO tof_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ngaen, Isrraelón king küsilan nóma kwarilürr, ini pam ugón Idom tüpan king koralórr: ");
INSERT INTO tof_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beorrón siman olom, ngaen-gógópan Idom king wató yarilürr. Oya wirri basirran ngi Din-aba yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela nóma nurrótókórr, Zobab, Zerran siman olom, Bozrra wirri basirrdügab, kingüm bainürr oya pabodó. ");
INSERT INTO tof_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Zobab nóma nurrótókórr, Usyam, Teman pamkolpamdógab, kingüm bainürr oya pabodó. ");
INSERT INTO tof_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Usyam nóma nurrótókórr, Adad, Bedadón siman olom, kingüm bainürr oya pabodó. Wa Moab tüpdü wamórr Midian pampükü gazirrüm, da ibü memokan ut-ut ninóp. Oya wirri basirr ngi Abit. ");
INSERT INTO tof_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Adad nóma nurrótókórr, Samla, Masrreka wirri basirrdügab, kingüm bainürr oya pabodó. ");
INSERT INTO tof_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla nóma nurrótókórr, Syaol kingüm bainürr oya pabodó. Wa Rreobot wirri basirr pam yarilürr, Yuprreitis tobarr kabedó. ");
INSERT INTO tof_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Syaol nóma nurrótókórr, Ba-al-Anan, Akborrón siman olom, kingüm bainürr oya pabodó. ");
INSERT INTO tof_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ba-al-Anan, Akborrón siman oloma nóma nurrótókórr, Adad kingüm bainürr oya pabodó. Oya wirri basirr ngi Pao yarilürr, akó oya kolan ngi Me-etabel warilürr. Wa Matrredón óp olom, Me-Za-abón bobat. ");
INSERT INTO tof_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Isaon olmalbobatalab zitül singüldü balngomól pamab ngi módógako: Timna, Alba, Zetet, ");
INSERT INTO tof_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","O-olibama, Ela, Pinon, ");
INSERT INTO tof_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzarr, ");
INSERT INTO tof_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, akó Irram. Ini Idom zitül singüldü balngomól pam kwarilürr, ibü ngyaben basirr iazan kwarilürr, i tibiób tüpdü enezan ngyabenónóp. Isao Idom pamkolpamab abbobat wató yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Zeikob we ngyabelórr Keinan tüpdü, ngaen Aesak, oya aba ne ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ini Zeikobón olmalbobatalab póepe. Zosep, wa küsil olom yarilürr, pail ngarkwat 17. Wa tüób ⌊sip⌋ akó ⌊gout⌋ ngabkan pam yarilürr tóba naretalpükü. Zeikobón tokom ngim ne kol nis namülnürri, ngi Bila akó Zilpa, wa ibükagabi ta simanal olmal nósenóp. Zosep tóba abdó bóktan simarrulürr, oya naretala ne kolae tómbapónónóp. ");
INSERT INTO tof_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zeikobón wirri ⌊moboküpdü ubi⌋ Zosepka yarilürr tóba ngibürr simanal olmaldógab, zitülkus oya myangande ilngumilürr. Wa oyankü morroalan kokrrapan mórrkenyórr arrgüpürr. ");
INSERT INTO tof_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Oya naretala nóma umul bainóp wagó, ibü aban wirri moboküpdü ubi Zosepka yarilürr, a ibüka ma inzan koke, i oya alzizi amanik ugón bókyenóp akó i oyaka morroal tonarre koke ikik kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Zosep darrü irrüb nus we umtulürr. Wa tóba naretal nóma nüzazilóp ene nusbóka, i oya alzizi amanik tai ama ugón we bókyenóp. ");
INSERT INTO tof_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Wa ibüka we adrratórr wagó, “Tübarrkrru, ka ini nus umtula: ");
INSERT INTO tof_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mi blaman ⌊wit⌋ apapdó kwarila wit singül kur bamelkü darrpan pokodó. Kürü kura bupadórr, dümdüm zamngólórr. Yabü kura kürü kur kal-kal yangónóp ama wakósingül we nümgünóp oyaka.” ");
INSERT INTO tof_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Oya naretala imtinóp wagó, “Ma ia igó gyagüpi tótókdóla, ma sab kingüm baino, ama kibü sab mató tolngomólnómo?” Da oya naretala oya ma tai wirribóka alzizi amanik ugón bókyenóp, oya nus akó oya bóktananme. ");
INSERT INTO tof_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Darrü irrüb Zosep darrü nus akó we umtulürr, ó tóba naretal we nüzazilóp wagó, “Tübarrkrru! Ka akó darrü nus umtula. Ene nusdü ka we kla nósenónóma: abüs, melpal, akó 11 wimurra kürüka wakósingül nümgürre.” ");
INSERT INTO tof_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wa tóba nus abdó akó naretaldó nóma adrratórr, da aba we agórr akó we imtinürr wagó, “Ia ini laró nusa? Ia ma inzan gyagüpi tótókdóla, kótó, marü aip, akó marü naretal, ki sab marüka wakósingül nólóngórre?” ");
INSERT INTO tof_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Zosepón naretal gyagüp kolaea ekrralórr oyakwata, a ibü ab ma kari gyagüpitótók koke ekyanórr. ");
INSERT INTO tof_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Darrpan ngürr Zosepón naretala Syekem wirri basirr minggüpanan ogobórr tibiób aban sip a gout ngabkanóm. ");
INSERT INTO tof_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Zeikob Zosepónbóka wagó, “Ma umulóla igó, marü naretala sip a gout ngabkandasko Syekem minggüpanan. Ka marü ola zirrapónóm kaindóla ibüka.” Zosep bóktan yalkomólórr wagó, “Taia.” ");
INSERT INTO tof_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Da oya aba we yalórr wagó, “Ma kya kóbó wam moba naretal bangónóm, ia i tib akó sip a gout taiasko. Sab tolkomólke kürü umul-umulan ngitanóm.” Da aba we zirrapónórr Ibrron basirr buruburudügabi. Zosep we abzilürr Syekem. ");
INSERT INTO tof_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Wa ibü byamkünkü wamlórr ene pórrpótyapdó. Darrü pama oya we esenórr, da oya we imtinürr wagó, “Ia ma laró amkündóla?” ");
INSERT INTO tof_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Wa bóktan yalkomólórr wagó, “Ka kólba naretal byamkündóla. Ma ia kürü koke küzazilo, ia i tibiób sip nadü pokodó ngabkandako?” ");
INSERT INTO tof_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ene pama bóktan yalkomólórr wagó, “I ini poko kuri amgütrre. Ka ibü nurrkrrunüma i nóma ikik kwarile wagó, ‘Nau, mi Dotan tótókdakla.’” Da Zosep ibü solkwat we akyanórr ó ibü we nósenóp Dotan wirri basirr minggüpanandó. ");
INSERT INTO tof_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","I oya ugón esenóp, wa ibükagabi barkyanan kan nóma yarilürr. Wa wa solkwat abzilürr, i bóktan ngaen-gógópan tónggapónóp oya amkalóm. ");
INSERT INTO tof_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","I tibiób darrpan-darrpan büzazilóp wagó, “Ene metat nus ut olom mamka! ");
INSERT INTO tof_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Yao, ugó togob, mi oya amkaldakla akó mi kubó oya büb amaikrre darrü kukurru nae-koke badudü. Mi kubó igó adrrütrre wagó, oya darrü molpokodó gazirr nurr lara sómkóle. Da mi kubó oya ugón eserre, oya nusa ia zaget apóni!” ");
INSERT INTO tof_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Rruben ibü nurrkrruóp i ne bóktan tónggapónóp, ó wa ma Zosepón yangónórr oya amkalgum. Da wa we bóktanórr wagó, “Mi oya koke emkórre. ");
INSERT INTO tof_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ini ⌊ngüin-koke bwóbdü⌋ e kubó oya amanikane ini ukyórrün nae badudü. E kubó oya ia koke yangónane!” Wa we bóktanórr oya zid ainüm akó tóba abdó alkomólóm. ");
INSERT INTO tof_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Zosep tóba naretaldó nóma abzilürr, i oya morroalan kokrrapan mórrkenyórr ngürsilpükü we atürróp oya bübdügab. ");
INSERT INTO tof_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","I oya ipüdóp, ama nae-koke badudü we amanikóp. ");
INSERT INTO tof_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","I nóma alo kwarilürr, da Isma-elón zitül pam kopo nósenóp ene kwatana tótókde. I elklaza bumióg pam kwarilürr. I olgab togoblórr Gilead bwóbdügab, kóta Izipt kantrri amrran. Ibü ⌊kamela⌋ abün morroal bübdü balóp ilang móeg barrmülürr. ");
INSERT INTO tof_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Zuda tóba zonaretaldó bóktanórr wagó, “Mi ia kubó laró darrem ipüdórre, mi ne kubó mibiób zoret nóma emkórre akó oya büb nóma inikórre pamab asen-gum? ");
INSERT INTO tof_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Morroal igósa, mi oya sel irre ini Isma-el pamdó. Da mi oya koke emkórre; ene zitülkusdü, wa mibü zorete, mi darrpan büb a óeakla.” Oya zonaretal blamana we ubi bainóp. ");
INSERT INTO tof_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Isma-elón zitül pama nóma nórrgrrótópma, ibü we nürrmütóp. Oya naretala Zosepón we amurrutóp ene badudügab, ama oya sel inóp Isma-el pamdó. Ene darrem kla ngarkwat 20 silba mani poko. I oya ipüdóp, Izipt we idüdóp. ");
INSERT INTO tof_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rruben darrü pokodógab nóma tolkomólórr ene badudü, wa Zosepón we koke esenórr. Wa oya gyauranme tóba mórrkenyórr we atürrürr. ");
INSERT INTO tof_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wa alkomólórr tóba zoretaldó, da wa we bóktanórr wagó, “Ene omokur myamem ola babulase! Ka ia-ia kaino?” ");
INSERT INTO tof_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Da i gout we edabónóp ó Zosepón kokrrapan mórrkenyórr we yanggóbólóp ene goutan óedó. ");
INSERT INTO tof_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","I ene mórrkenyórr tibiób abdó we idüdóp, da we bóktónóp wagó, “Ki ini kla eserre. Ia ini marü olomane?” ");
INSERT INTO tof_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zeikob emzyatórr da we bóktanórr wagó, “Ó, oyane! Kürü olom Zosep syórr angórróna! Darrü molpokodó nurr lara kuri elónge!” ");
INSERT INTO tof_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Zeikob tóba mórrkenyórr gyauranme we atürrürr ó wa tóba bidó mórrkenyórr batenórr. Wa metat yón gyauri ngyabelórr abün ngürrüm. ");
INSERT INTO tof_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Zeikobón simanal olmala akó ópal olmala togobórr oyaka oya zao-zao ainüm. A wa ibü zao-zao bain-gum badólórr, da we bóktanórr wagó, “Ka sab kólba olom metat inzan yón amto namulo, kóta ka sab nóma nurrótoko; ka koke piküp baino.” Wa tóba olom Zosepón we yón amtolórr. ");
INSERT INTO tof_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ene tonarrdó, Iziptüm Isma-el pama Zosepón sel inóp Potiparrka, darrü parraoan ngi pam nótó yarilürr. Wa parraoan büb ngakan gazirr pamab singüldü pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ene tonarrdó, Zuda tóba zonaretal we bimgatórr, ama Adulam wirri basirrdü wamórr darrü pampükü ngyabenóm, ngi Aerra. ");
INSERT INTO tof_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Zuda olazan ngyaben yarilürr, wa darrü Keinan ngulmokur osenórr. Ene ngulmokuran ab ngi Syua. Da módóga, Zuda ene ngul olom we zumiógürr, da usadi we umturri. Ene kakóm, kola bikóm ipadórr, akó siman olom we esenórr. Zuda ngi ngyesilürr Err. ");
INSERT INTO tof_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Wa akó bikóm we ipadórr. Kola nis ngim siman olom we esenórr, da ngi we ngyesilürr Onan. ");
INSERT INTO tof_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Wa akó aüd ngim siman olom we esenórr, da ngi we ngyesilürr Syela. I ugón Kezib wirri basirrdü kwarilürr, ene oloma nóma tómtómólórr. ");
INSERT INTO tof_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Zudan ngaen oloma wirri pam nóma bainürr, da aba bóktan we tónggapónórr Errónkü kol amiógüm. Da wa kol we zumiógürr, ngi Tamarr. ");
INSERT INTO tof_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Da Zudan ene oloma Err, ⌊Lodón⌋ ilküpdü kolae tómbapón yarilürr, da oya Lod büdülümpükü we semkalórr. ");
INSERT INTO tof_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Err nóma nurrótókórr, ene kakóm, Zuda Onanón we yalórr wagó, “Moba naretan kol kóblepükü umtulke, ó moba ngubutan zaget elakó. Ma olmal oya pabodó sab nóma nósenónómo, sab oya olmalbobatal kwarile.” ");
INSERT INTO tof_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Da módóga, Onan umul yarilürr wagó, ene olmal sab tóba olmal koke korale. I enezan ngyabenórri, wa oyaka kolae tonarr tómbapón yarilürr olmal basen-gum. ");
INSERT INTO tof_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wa ne poko tómbapólórr, Lodón ilküpdü kolae yarilürr, da oya Lod büdülümpükü we emkalórr. ");
INSERT INTO tof_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Zuda tóba kolalkot Tamarrón we wyalórr wagó, “Ma kya kóblezan ngyabelónke moba aban müótüdü, kókó kürü olom Syela nóma dódórr baine.” Zitülkus módóga, wa igó gyagüpi wamórr, “Wa ta sab kena nurrótók tóba naret nisazan.” Da Tamarr we natókórr tóba aban müótüdü ngyabenóm. ");
INSERT INTO tof_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ngibürr pail kakóm, Zudan kola we nurrótókórr, Syuan olom nótó warilürr. Oya yón gyaura nóma blakónórr, wa we wamórr Timna wirri basirrdü, tóba zaget pama ⌊sipab⌋ ngüin ne zuluklórr. Wa tóba gódampükü wamórr, ngi Aerra, Adulam basirr pam. ");
INSERT INTO tof_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Tamarrón darrü oloma uzazilürr wagó, “Marü kolalkot myanga Timna tótókdase tóba sipab ngüin alüküm.” ");
INSERT INTO tof_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Wa tóba bidó mórrkenyórr enólórr, akó obzek ngablaorr mórrkenyórr poko-e pamkolpama oya obzek asen-gum. Da wa we natókórr Ena-im wirri basirrdü, ene kwatódó ama Timna tótók. Wa we mórran-mórran bainürr barrbün bwóbdü. Da wa igó gyagüpi natókórr wagó, Syela wirri pam kuri bainürr, a i oya Syelan koke ekyenóp kolóm ainüm. ");
INSERT INTO tof_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Zuda oya nóma osenórr, wa igó gyagüpi wamlórr wamaka wa popa kwatódó agól kolo, zitülkus tóba obzek mórrkenyórr poko-e ngablaorrón warilürr. ");
INSERT INTO tof_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Zuda umul-kók yarilürr, akó wa koke omzyatórr igó, “Ini wa kürü kolalkoto.” Wa oyaka we wamórr kwat kabedó, da bóktanórr wagó, “Mi ia usadi koke umtuli?” Tamarr bóktan yalkomólórr wagó, “Ka ne kubó mankü nóma umtulo, ma kubó kürü darrem ia laró kókyeno?” ");
INSERT INTO tof_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Zuda bóktan yalkomólórr wagó, “Ka sab marü ⌊gout⌋ kupo zirrsapono.” Tamarr akó oya imtinürr wa, “Ia ma kürü darrü kla koke kókyeno marü gyagüpi amaniküm ene gout kupo zirrapónóm, igósüm ma ene gout kupo sab solodó zirrsapono?” ");
INSERT INTO tof_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Zuda oya umtinürr wagó, “Marü ubi ia ka marü laró mókyeno?” Tamarr bóktan yalkomólórr wagó, “Kürü ubi marü ngi opor alóm kla tóba syepükü, akó tupuru, marü tangdó ne klame.” Da elklaza we uliónürr, da módóga, Zuda gómól oyaka agósórr; bikóm we okyanórr. ");
INSERT INTO tof_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ene kakóm, Tamarr nóma alkomólórr, tóba obzekdógab ene mórrkenyórr poko we ininürr, ama akó bidó mórrkenyórr we bamelórr. ");
INSERT INTO tof_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ngibürr ngürr kakóm, Zuda tóba gódam Aerran we zirrapónórr gout kupo ódódóm Tamarrka, akó tóba elklaza akonóm. Oya gódama we wamórr ene wirri basirrdü, a wa ene kol koke osenórr. ");
INSERT INTO tof_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Aerra ene bwóbdü ngibürr pam nümtinóp wagó, “E ia popa kwatódó agól kol koke osenane, Ena-im kwat kabedó nótó mórralórr?” Ene pama bóktan yalkomólóp wagó, “Darrü inzan popa kwatódó agól kol ala babulo.” ");
INSERT INTO tof_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Aerra nóma alkomólórr, Zudanbóka wagó, “Ka ene kol koke osena, akó bwóbdü pama wagó, ‘Darrü inzan popa kwatódó agól kol ala babulo.’” ");
INSERT INTO tof_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Zuda bóktan yalkomólórr wagó, “Ka oya ne kla uliórrü, ene go oyanko, zitülkus kolpama sab nóma umul bairre, mibü sab ngüóng tóngyalnórre. Ka ene gout kupo amkoman zirrapóna, da ma ene kol koke osena.” ");
INSERT INTO tof_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Aüd melpal kakóm, Zudan darrü pama izazilürr wagó, “Marü kolalkota ta popa kwatódó agól kolzan tórrmen tulmil tómbapólórr, da wa errkya bikómpükümo!” Da Zuda tóba zaget pam nilóp oya apadóm wagó, “Oya sab ura büdülümpükü ae ki zudüng!” ");
INSERT INTO tof_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ene pama Tamarrónzan tudódnóp, wa bóktan zirrapónórr tóba kolalkotódó wagó, “Ini elklaza noanko, kürü bikóm wató kókyanórr. Tai ngabkónam akó kóbó tómzyetamke: ini ngi opor alóm kla tóba syepükü akó ini tupuru, ia tai noanko?” ");
INSERT INTO tof_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Zuda tóba elklaza nóma nómzyetóp, we bóktanórr wagó, “Wa amkoman dümdümo, a ka ma dümdüm kokela, zitülkus ka oya koke okyarró kólba olom Syelan oya kolóm.” Zuda myamem kolae tonarr koke tónggapónórr Tamarrka. ");
INSERT INTO tof_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ene ngürr nóma semrranórr Tamarrón twarrpinürr, oya nis siman olom nis namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Tamarr olom nis nóma nulngumilürr, darrüpa tóba tang adrratórr. Marrna ain kola büsai amiógürr, óe-óe sye-i arümürr, da igó warilürr wagó, “Ini ngaen oloma.” ");
INSERT INTO tof_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Da ene oloma tóba tang aipan bikómdü nóma errngamórr, oya zoreta we tómtómólórr, da marrna ain kola akó bóktanórr wagó, “Ma wirri arüngi ia tómtómóla singül kwata!” Da oya ngi we ngyesilóp, Perrez. ");
INSERT INTO tof_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Da olgabi oya nareta we tómtómólórr, óe-óe syepükü tang amelórrón. Oya ngi we ngyesilóp, Zerra. ");
INSERT INTO tof_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isma-el pama Zosepón we idüdóp ama Izipt. Potiparr oya we amiógürr ibükagab manie. Wa Izipt pam yarilürr, darrü parraoan ngi pam. Wa parraoan büb ngakan gazirr pamab singüldü pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","⌊Lod⌋ Zosepka asi yarilürr. Wa tóba zaget kari morroal koke idódlórr, ó tüób tóba wirri paman müótüdü ngyabelórr, Izipt pam nótó yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiparr nóma esenórr wagó, Lod oyaka asine ó Lod oya blaman klamdó tangamtin yarilürr, wa ne kla tómbapólórr, ");
INSERT INTO tof_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potiparr tóba obzek kwata Zosepka morroal esenórr. Akó Zosep Potiparrón büb ngakan pamóm bainürr. Wa ta Potiparrón müót alngomól akó ngakan pamóm bainürr. Potiparrón müótüdü ne elklaza kwarilürr, oya tangdó blaman kla we irrbünürr. ");
INSERT INTO tof_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ene ngürrdügab, Zosepónbókamde Lod Potiparrón müót kolpam bles ninóp akó müótüdü akó ngaon bwóbdü blaman ne kla kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potiparr tóba blaman kla Zosepón tangdó irrbünürr ngabkanóm. Zosepónbókamde Potiparrón gyagüpitótókdó darrü müp babul yarilürr darrü klamankwata, wata wa ne alo kla alo yarilürr. Zosep wa morroal kómal büb akó agür obzek olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ngibürr tonarr kakóm, oya wirri paman kolan büba ubi bainürr Zosepkamóm, ó oya imtinürr wagó, “Ma kya tam kankü utüm.” ");
INSERT INTO tof_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","A wa ma bangónórr ó bóktanórr oyaka wagó, “Turrkrru, kürü bókamdó kürü wirri paman gyagüpitótókdó darrü müp babula darrü klamankwata tóba müótüdü, akó wa tóba blaman elklaza kürü tangdó irrbünürr ngabkanóm. ");
INSERT INTO tof_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Kibü arüng darrpan ngarkwatódómamli ini müótüdü, ó wa darrü kla koke yangónórr kürü gumüm, wata mató, zitülkus ma oya kolóla. Da ka ma inzan wirri kolae kla iade tónggapono akó kolae tonarr tónggapono Godka?” ");
INSERT INTO tof_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Enana wa Zosepón blaman ngürrzan enan imtilürr, Zosep kokean ubi bailürr oya minggüpanandó tótókóm wankü utüm. ");
INSERT INTO tof_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","A darrpan ngürr, Zosep nóma bangrinürr ene müótüdü tóba zaget tómbapónóm, darrü zaget olom müótüdü ta babulan yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potiparrón kola oya tumum mórrkenyórr we amiógürr, da we bóktanórr wagó, “Ma kya tam kankü utüm.” A wa ma oya gum kórzyónürr ó wa we busorr pul basirrdü. Tóba mórrkenyórr we amgatórr ene kolan tangdó. ");
INSERT INTO tof_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Potiparrón kola nóma esenórr wagó, Zosep tóba mórrkenyórr kuri amgüte ó kuri busue müótüdügab, ");
INSERT INTO tof_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","wa tóba müótüdü zaget pam we ngibaunürr, da we bóktanórr wagó, “Ini kla ngakónam! Kürü müóra ne Ibrru olom sidódürr ini müótüdü, wa mibü ⌊tiz tangórre⌋. Wa kürü ut bwóbdü tübangrine kankü utüm. Da ka ma wirribóka taegwarr apóna. ");
INSERT INTO tof_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Wa kürü taegwarr nóma arrkrrue, wa tóba mórrkenyórr amgüte kürü tangdó, da we busue pul basirrdü.” ");
INSERT INTO tof_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Potiparrón kola ene mórrkenyórr tóba kabedó we ingrinürr kókó oya müóra we tübzilürr müótüdü, Zosepón wirri pam. ");
INSERT INTO tof_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ene dadan póep akó we adrratórr tóba müóran umulüm: “Ene Ibrru ⌊leba zaget olom⌋, ma noan sidódürr ini müótüdü, kürüka tame kürü tiz angónóm. ");
INSERT INTO tof_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","A ka nóma taegwarr apóna, tóba mórrkenyórr popa ola amgüte kürü kabedó, da we busue pul basirrdü!” ");
INSERT INTO tof_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Zosepón wirri pama tóba kolan bóktan nóma arrkrrurr wagó, “Marü leba zaget oloma kürü inzan kangóne,” oya büba urazan bamzikürr. ");
INSERT INTO tof_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Zosepón amigóp, tümün müótüdü we ingrinóp, kingdü kolae nidi tómbapónóp nóla kwarilürr. Da wa we ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","A Lod Zosepka yarilürr akó oya morroal tonarr emtyanórr, igósidi tümün müót ngakan pama morroal esenórr oyaka tóba obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Da wa Zosepón we ingrinürr wirri pamóm ene tümün müótüdü ta blaman ne pam kwarilürr, ibü ngabkanóm. Wa oya wirri zaget ekyanórr blaman kla ngabkanóm akó balngomólóm ene tümün müótüdü. ");
INSERT INTO tof_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tümün müót ngakan pama Zosepón ne zaget iliónürr, wa ene zagetankwata myamem koke gyagüpi amaikürr, zitülkus Zosep blaman kla ngabkan yarilürr. Lod Zosepón tangamtilürr wa ne morroal kla tómbapólórr. ");
INSERT INTO tof_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ngibürr tonarr kakóm, Izipt kingan ngyepam gail singüldü pam akó plaoa balkomen singüldü pam, i kolae tonarr tómbapórri tibiób wirri pamdó, Izipt king. ");
INSERT INTO tof_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Wa kari ngürsil ta koke yarilürr ene nis ngi pam nisdü, ");
INSERT INTO tof_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ó ibü nüpadórr, tümün müótüdü we nüngrinürr, kingan büb ngakan gazirr pamab singüldü pama ne müót ngakalórr, Zosep ne müótüdü yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","I barrkyanan tonarr we ngyabenónóp ene tümün müótüdü, ó Potiparr Zosepón we ingrinürr ene nis pam nis ngakanóm. ");
INSERT INTO tof_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Darrü irrüb, ene tümün müótüdü, ngyepam gail singüldü pam akó plaoa balkomen singüldü pam nizana nus umturri. Ene nus nisab küp darrü-darrü namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Zosep ibüka ene irrbi nóma wamórr, wa ibü nósenórr, i gyakolae obzeke namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Wa ibü we nümtinürr wagó, “E gyaur obzeke iade mórrandamli?” ");
INSERT INTO tof_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","I bóktan yalkomólórri wagó, “Ki nizana nus umtuli, a darrü pam myamem babula ini nus müsirrga ainüm, ibü küp ia laróga.” Zosep ibüka bóktan we yalkomólórr wagó, “Wata God pam gyagüpitótók wató akyanda nus morroal müsirrga ainüm. Kürüka yabiób nus kóbó adrrótam.” ");
INSERT INTO tof_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ngyepam gail singüldü pama we bóktanórr wagó, “Kürü nus inzan yarile wagó, darrü ⌊grreip⌋ syepor kürü obzek kwata yaril. ");
INSERT INTO tof_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Aüd tiz oyaka kwaril. Dümdüman ene küsil pórngaea nóma tübause, oya pula ugón bamgorre. Ene grreipa we bangurine. ");
INSERT INTO tof_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ka parraoan kübül tangdó emona, ene küp yazeba, mor emónga parraoan kübüldü, ene kübül ma parrao ekyena anónóm.” ");
INSERT INTO tof_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Zosep bóktanórr wagó, “Ini nusa we pokobóka apónda wagó, ene aüd nugup tizab küp módóga: aüd ngürr. ");
INSERT INTO tof_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Aüd ngim ngürrdü parraoa sab marü singül kwit ine moba büódüdügabi. Marü sab malkomóle moba zaget pabodó. Ma oya kübül sab iliolo, ma ngaen enezan tonarr elngónórró. ");
INSERT INTO tof_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Da gyaurka, ma sab kürü gyagüpi kümanikke, blaman klama sab morroal nóma bairre marüka. Ka marü matoa, marüka sab morroal tonarr ki yarilün. Kürü ngi ngiklianke parraodó, ó marü tangbamtin sab asi ki yarilün kürü tümün müótüdügab arruanóm. ");
INSERT INTO tof_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ngaen-gógópan pokodó, kürü gómól tonarre küpüdóp Ibrru kolpamab tüpdügab, ó ene dadan tonarrzan klama akó kuri tómbapóne aini Iziptüm. Ka darrü kolae koke tónggapórró tümün müótüdü bangrinüm.” ");
INSERT INTO tof_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ene plaoa balkomen singüldü pama arrkrrurr wagó, Zosep ngyepam gail singüldü paman nus müsirrga yónürr akó ene bóktan morroal yarilürr ene pamdó. Da wa we bóktanórr Zosepka wagó, “Ka ta nus inzan umtula. Ka aüd alóp nósenónóma kólba singüldü. ");
INSERT INTO tof_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tai wirri kwitüm ne alóp yaril, abün obzek balkomerrón brred kwaril, parraoan plaoa bamngul müótüdügabi. Ene brred póyaea elorre.” ");
INSERT INTO tof_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Zosep bóktan we yalkomólórr wagó, “Ini nusa we pokobóka apónda wagó, aüd alópab küp módóga: aüd ngürr. ");
INSERT INTO tof_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Aüd ngim ngürrdü, parraoa marü singül sab kwit ine, ugón itüle! Marü büb nugup zonodó alanirre, ó sab póyaea marü büb murr we elóngórre.” ");
INSERT INTO tof_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Parraoan amtómól ngürr nóma semrranórr, aüd ngim ngürrdü, wa wirri garrirr tónggapónórr tóba ngi pamabkü. Wa we nurruanórr tóba ngyepam gail singüldü pam akó tóba plaoa balkomen singüldü pam ó ibü we tüdüdóp ene ngi pamab obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Parraoa ene ngyepam gail singüldü pam akó tóba pabodó salkomólórr, oya kübül parraoan tangdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ene plaoa balkomen singüldü paman singül itülóp, ama oya büb nugup zonodó alaninóp. Ene pokoa wata amkoman tómbapónórr Zosep enezan müsirrga yónürr. ");
INSERT INTO tof_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Da ene ngyepam gail singüldü paman gyagüpitótók myamem babul yarilürr Zosepka - oyabóka tai imrükürr. ");
INSERT INTO tof_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Nis paila nóma blakórri, parraoa inzan nus umtulürr: Wa Nael tobarr kabedó nóma zamngólórr, ");
INSERT INTO tof_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","7 morroal akó wirri büb ⌊kaua⌋ naedógab we tübausürr, ó kayal alo we bókyenóp. ");
INSERT INTO tof_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ibü kakóm, akó ngibürr 7 aroam akó korrkorr büb kaua naedógab tübausürr. I we ogobórr, ngibürr kauab minggüpanandó we tóbrrangórr tobarr kabedó. ");
INSERT INTO tof_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ene korrkorr kaua nóma tóbrrangórr, i ene morroal akó wirri büb kau we olonglórr. Parraoa ugón saogórr. ");
INSERT INTO tof_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Oya uta akó we türümürr, ó akó darrü nus we umtulürr. 7 ⌊Wit⌋ singüla, morroal tulum waorrón, darrpan aipdügab dódórr bainóp. ");
INSERT INTO tof_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Akó 7 ngibürr korrkorr wit singüla tübausürr, wirri bao urura ne kla mangkó ninóp. ");
INSERT INTO tof_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Korrkorr wit singüla ama morroal tulum waorrón wit singül ololórr. Parraoa nóma saogórr, wa we umul bainürr wagó, “Ka nus umtula.” ");
INSERT INTO tof_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ene irrbi wa gyakolae yarilürr. Wa bóktan we zirrapónórr blaman wirri wapi pamdó akó ⌊wirri gyagüpitótók⌋ pamdó, Izipt kantrri kugupidü. Wa tóba nus we nüdrratürr, a darrü pam gaodó koke yarilürr müsirrga ainüm oyankü. ");
INSERT INTO tof_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ene ngyepam gail singüldü paman Zosepónbókama ngambangólórr, da we bóktanórr parraodó wagó, “Ka ini ngürr pupo baindóla, ka kolae tónggapórró. ");
INSERT INTO tof_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ma ngürsil namülnürrü ene plaoa balkomen singüldü pamdó akó kürüka, ó ma kibü tümün müótüdü we tüngrinürr, Potiparrón müótüdü, kingan büb ngakan gazirr pamab singüldü pam. ");
INSERT INTO tof_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Darrü irrüb ki nizana nus umturri, ó ene nusab küp darrü-darrü namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Darrü Ibrru omokur kinkü asi yarilürr, kingan büb ngakan gazirr pamab singüldü pam, oya leba zaget olom. Ki kibiób nus oyaka we adrratrri, da wa we müsirrga nyónürr kibüka. ");
INSERT INTO tof_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ene elklaza wata amkoman tómbapónóp wa enezan müsirrga yónürr. Ma kürü kalkomólórr kólba zaget pabodó, ma ma plaoa balkomen singüldü paman büb nugup zonodó alanirrü.” ");
INSERT INTO tof_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Parraoa bóktan we zirrapónórr Zosepkamóm. I ürrbain ta koke apónóp oya ódódóm tümün müótüdügab. Wa tóba ikub ngüin nóma balükürr akó morroal mórrkenyórr nóma püti bainürr, oya parraoan obzek kwata we sidüdóp. ");
INSERT INTO tof_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Parraoa we bóktanórr oyaka wagó, “Ka nus umtula; darrü pam gaodó kokea müsirrga ainüm. Ka igó arrkrrua wagó, ma nus müsirrga ain umulóla.” ");
INSERT INTO tof_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Zosep bóktan yalkomólórr wagó, “Wirri pam, kótó koke! Wata God kubó ini nus wató müsirrga ine marünkü. Aprrapórr ene bóktan kubó morroal yarile marünkü.” ");
INSERT INTO tof_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Parraoa bóktan yalkomólórr wagó, “Turrkrru, ka nus igó umtula. Ka Nael tobarr kabedó nóma zamngóla, ");
INSERT INTO tof_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","7 morroal akó wirri büb kaua naedógab we tübause, ó kayal alo we bókyerre. ");
INSERT INTO tof_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ibü kakóm, akó ngibürr 7 kaua naedógab tübause. I yuóg ngyaben kau kwarile akó ibü amkoman aroam akó korrkorr büb kwarile. Ka inzan kau ta kokean nósenarre Izipt kantrridü. ");
INSERT INTO tof_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Korrkorr akó aroam büb kaua ama ene wirri büb kau dudu olongóle, ngaen-gógópan nidi tübause. ");
INSERT INTO tof_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ibü alóng kakóm, darrü olom gaodó koke yarile asenóm igó, i ene wirri büb kau olongóle, zitülkus ibü büb wata dadanzan korrkorr kwarile ngaen-gógópanzan. Ka ugón türsümüla. ");
INSERT INTO tof_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ka akó darrü nus inzan umtula. 7 Wit singüla, morroal tulum waorrón, darrpan aipdügab dódórr bairre. ");
INSERT INTO tof_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Akó 7 ngibürr odalórrón akó korrkorr wit singüla tübause, wirri bao urura ne kla mangkó nirre. ");
INSERT INTO tof_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Korrkorr wit singüla ama morroal tulum waorrón wit singül olol. Ka ini nus wapi pamdó enan nüdrrüta, a darrü pam gaodó koke yaril müsirrga ainüm kürünkü.” ");
INSERT INTO tof_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Zosep parraodó bóktanórr wagó, “Ene nus nisa darrpan klambóka apóndamli. God marü kuri mómtyene, wa laró tómbapónóm kainda. ");
INSERT INTO tof_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Da 7 morroal büb kaua, i 7 pailüm bórrangdako, akó 7 morroal wit singüla, i akó 7 pailüm bórrangdako. I nizana darrpan pokom zamngóldamli. ");
INSERT INTO tof_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Da 7 korrkorr akó aroam büb kau, solkwat ne klama tübause, i 7 pailüm bórrangdako. Akó 7 yuóg ngyaben wit singül, wirri bao urura ne kla mangkó nirre, i ta 7 pailüm bórrangdako. ");
INSERT INTO tof_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ene inzana, kazan bóktóna - God marü kuri mómtyene, wa laró tómbapónóm kainda. ");
INSERT INTO tof_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","7 pailüm sab wirri mórrel yarile blaman Izipt tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A ene kakóm, sab 7 pailüm wirri ku yarile, ó ene morroal pailbókama sab bamrüke, zitülkus sab ini kua tüp kulaine. ");
INSERT INTO tof_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ene mórrelbókama sab bamrüke, zitülkus ene ne kua tótókda, sab kari kolae koke yarile. ");
INSERT INTO tof_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","God marü nis ngim ene nus igósüm mókyene, marü umul-umulan ngitanóm wagó, ini bóktana sab amkoman tómbapóne akó kari pokoa God ene kla tónggapónóm mibüka. ");
INSERT INTO tof_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Errkya ma darrü pam ugó yamkü susumüri akó wirri gyagüpitótók pam, da sab oya ingrinke Izipt kantrri ngakanóm. ");
INSERT INTO tof_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ma akó sab ngibürr wirri ngi zaget pam irrbünke. Blaman didiburrdügab, morroal ne alo klama dódórr baindako, blaman 5 alo klamdógab ma darrpan ipadlo gyagu müótüdü angrinüm ene 7 mórrel pail kugupidü. ");
INSERT INTO tof_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ibü ki dakabain koralón, blaman alo kla ne kla kwarile, sab ene ne morroal pail kwarile, akó blaman wit küp ki urrburrün parraoan gyagu müótüdü blaman wirri basirrdü ne klamko. I ola morroal ki ngabkanónóm. ");
INSERT INTO tof_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ene aloa mibü sab ki tangtamtinünüm ini bwóbdü ugórr ngyabenóm, ene 7 pail ku, sab ne klama tame Iziptüm. Ini igósüm, alo kua ini tüp koke kulaine.” ");
INSERT INTO tof_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Zosepón kuankwata bóktan morroal yarilürr ibüka, parrao akó tóba ngi pampükü. ");
INSERT INTO tof_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Parraoa tóba ngi pamdó bóktanórr wagó, “Mi sab inzan pam myamem koke eserre, Godón Samu ne noan bübdüma.” ");
INSERT INTO tof_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Olgabi parraoa bóktanórr Zosepka wagó, “God marü kuri mómtyene ma kürü blaman ne kla kuri küzazila, akó darrü inzan pam babula mazan, susumüri akó wirri gyagüpitótók pam. ");
INSERT INTO tof_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ka marü angrindóla wirri ngi pamóm kólba kantrri akó kürü blaman pamkolpam ngabkanóm. I sab tómbapónórre ma ne arüng bóktan bóktalo. Marü ngi sab kari-karibóka yarile kürü ngidügab, zitülkus ka kingan mórran klamdó mórrandóla.” ");
INSERT INTO tof_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Akó parraoa bóktanórr Zosepka wagó, “Ka errkyadan marü angrindóla wirri ngi pamóm blaman Izipt kantrridü.” ");
INSERT INTO tof_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Parraoa tóba ngi opor alóm rring tang pyómdügab irruanórr, ama Zosepón tang pyómdü akyanórr. Akó wa agurr akó wirri darrem mórrkenyórr ipadórr, oya atenórr. Dómdóm, ⌊gold⌋ sein sye ipadórr, oya gepkodó gegómórra yangónórr. ");
INSERT INTO tof_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Parraoa tóba nis ngim ⌊osab amorrat kla⌋ ugón ekyanórr oya agólóm, da we górrgankü ogoblórr oya singül kwata wagó, “Kwatódógab igó kainam!” Da módóga, parraoa Zosepón ingrinürr wirri ngi pamóm blaman Izipt kantrridü. ");
INSERT INTO tof_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Parraoa bóktanórr Zosepka wagó, “Ka kingla, a pamkolpama marükagab sab ngaen-gógópan bóktan ipadnórre, da i solkwat ngibürr kla ugón tómbapónórre.” ");
INSERT INTO tof_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Da parraoa Zosepón tóba Izipt ngi we ekyanórr, ngi Zapenat-Panea. Oya kolpükü we ekyanórr, ngi Asenat, Potiperran óp olom. Potiperra darrü Izipt pamkolpamab godón ⌊ótók⌋ müót prrist yarilürr, Eliopolis wirri basirrdü. Zosep Izipt kingan zaget ugón bókyanórr, wa 30 pail nóma yarilürr. Da wa parraodógab bupadórr blaman Izipt kantrridü agóltagólóm. ");
INSERT INTO tof_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ene 7 mórrel paildü, tüpa abün alo kla dódórr ninóp, aüd-koke. ");
INSERT INTO tof_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Wa ne alo kla dakabasulürr ene mórrel paildü Izipt kantrridü, ama gyagu müótüdü we irrbülürr blaman wirri basirrdüma. Wa alo kla inzan irrbülürr blaman darrpan-darrpan wirri basirrdüma, ne alo klama dódórr bainóp ngaon bwóbdü wirri basirr kabedó. ");
INSERT INTO tof_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Zosep aüd-koke wit küp gyagu müótüdü irrbülürr, ngaru-koke, wamaka maludü nóresa, ó wa piküp bainürr wit küp bótangóm, zitülkus darrü pam gaodó koke yarilürr ene kla bótangóm. ");
INSERT INTO tof_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ene kolae ku paila solkwat togobórr, ngaen-gógópan Potiperran óp olom Asenatkagab Zosep nis siman olom nis nósenórr. Potiperra prrist yarilürr Eliopolis wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Zosep bóktanórr wagó, “God kürü kuri tangkamtine kólba müp akó kólba aban pamkolpam alókóm.” Da wa tóba ngaen olom ngi we ngyesilürr Manase. ");
INSERT INTO tof_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Wa akó we bóktanórr wagó, “God kürü küppükü kine: wa kürü nis olom nis kuri kókyene ini kantrridü, kürü kolae gyaur ngyabendógab,” da wa tóba nis ngim olom ngi we ngyesilürr Iprra-im. ");
INSERT INTO tof_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ene 7 pail wirri mórrel ne kla yarilürr Izipt tüpdü, blakón bwóbdü we tamórr, ");
INSERT INTO tof_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ó ene 7 pail kua we bókyanórr, Zosep enezan yarilürr. Blaman bwób-bwób wata ku yarilürr, Iziptüm ma alo gaodó yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Izipt pamkolpama alom nóma kwarilürr, i parrao wirri arüngi yatonóp alo klamóm. Wa ibü we nilóp wagó, “Zosepka ogob akó tómbapónam Zosep yabü kubó ne poko nilórre.” ");
INSERT INTO tof_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ene kua blaman bwób we gwarranórr. Zosep blaman gyagu müót tapanukuóp, da wit küp bumióg we bókyenóp Izipt pama oyakagab, zitülkus kari kolae ku koke yarilürr Izipt kantrridü. ");
INSERT INTO tof_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Akó pamkolpama togoblórr blaman bwób-bwób Izipt kantrridü wit küp bumiógüm Zosepkagab, zitülkus kari kolae ku koke yarilürr blaman bwób-bwób. ");
INSERT INTO tof_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Zeikob nóma umul bainürr wagó, ⌊wit⌋ küp Iziptüm asisko, wa tóba olmaldó we bóktanórr wagó, “E yabiób darrem-darrem iade ngabkandakla? E ia darrü kla koke tónggapónane? ");
INSERT INTO tof_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Tübarrkrru, ka kuri arrkrrua wagó, wit küp asisko Iziptüm. E ugó bazeb wit küp bumiógüm mibünkü, zitülkus mi sab alo büdül kena nurrbarinün.” ");
INSERT INTO tof_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Da Zosepón 10 naretala we ogobórr Izipt, wit küp bumiógüm. ");
INSERT INTO tof_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","A Zeikob ma Zosepón zoret Benzaminün koke zirrapónórr inkü, zitülkus Zeikob gum yarilürr wagó, sab darrü pokoa kena tómbapón oyaka. ");
INSERT INTO tof_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Da Zeikobón olmala pam ngorodó babzilürr wit küp bumióg pokodó, zitülkus Keinan tüpdü ku yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zosep gabena yarilürr Izipt kantrridü; bwób-bwób pamkolpama alo kla bumiógüm oyaka togoblórr. Da Zosepón naretala we togobórr, tibiób wakósingül nümgünóp, oya obzek kwata singül tüp balókórr. ");
INSERT INTO tof_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zosep tóba naretal nóma nósenóp, ibü wa nómzyetóp. A wa igó bainürr, wamaka wa mogob pam yarilürr. Wa taren-taren wirri arüngi bóktanórr ibüka. Wa nümtinóp wagó, “E ia nubógab togoba?” I bóktan we yalkomólóp wagó, “Ki Keinangabakla, alo kla bumiógüm togoba.” ");
INSERT INTO tof_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Zosep naretal nómzyetóp, a i ma oya koke emzyetóp. ");
INSERT INTO tof_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Oya nusbókama ngambangólórr, wa ne nus umtulürr ibükwata ó da we bóktanórr wagó, “E kómdam bain pamakla; e ugósüm togoba kibü kómdam bainüm wagó, kibü arüng-koke bwób poko negako kibü kantrridü!” ");
INSERT INTO tof_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","I bóktan yalkomólóp wagó, “Koke, wirri pam, ki marü zaget pama kuri togoba wit küp bumiógüm. ");
INSERT INTO tof_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ki zonaretalpükümakla, ki darrpan abrrónakla. Ki kómdam bain pam kokeakla, wirri pam, ki amkoman moboküp pamakla.” ");
INSERT INTO tof_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Zosep ibüka bóktan yalkomólórr wagó, “Koke, e wata ugósüm togoba kibü kómdam bainüm wagó, kibü arüng-koke bwób poko negako kibü kantrridü!” ");
INSERT INTO tof_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","I bóktan yalkomólóp wagó, “Wirri pam, ki blaman 12 pam kwarilürr, darrpan abdógab Keinan tüpdü. Kibü darrü zoret büdüla, solo kupo zoret kibü abdómase.” ");
INSERT INTO tof_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Zosep bóktan yalkomólórr wagó, “Koke! E wata amkoman kómdam bain pamakla, ka enezan namüla! ");
INSERT INTO tof_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ini pokoan küpa sab amkoman ki tómbapó: ka parraoan ngidü yabü ini wirri arüng bóktan akyandóla wagó, e sab kokean amgütane ini bwób, kókó yabü solo kupo zoreta sab tame kürüka. ");
INSERT INTO tof_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Darrü pam zirrapónam yabükagab oya apadóm; e barrea sab tümün müótüdü koralo, kókó sab amkoman bóktana tübzile e ne pokobóka apóndakla, igósüm ka yabü amkoman nangunünümo. Koke ne nóma, ka parraoan ngidü amkoman poko bóktandóla kagó, e wa amkoman kómdam bain pamakla!” ");
INSERT INTO tof_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Da wa ibü we irrbünürr tümün müótüdü, aüd ngürrüm. ");
INSERT INTO tof_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Aüd ngim ngürrdü, Zosep ibüka we bóktanórr wagó, “Ka Godón gum angón pamla, da ini bóktan mamoalamke, igósüm e arról kwarilo. ");
INSERT INTO tof_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kürü amkoman angunüm wagó, e amkoman moboküp pamakla, yabü darrüpa sab tümün müótüdü ala yarile yabü ne irrbünóp. E barrea sab bakono wit küp amarrum, e ne kla bumigane yabiób olmalkolabkü, alo büdül nidipasko. ");
INSERT INTO tof_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Da e yabiób solo kupo zoret sab sidüdamke kürüka. Ene igósüm, ka bóktan sab amkoman yanguno ó ka sab yabü büdüldü koke irrbuno.” I blamana babinürr. ");
INSERT INTO tof_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Da we bóktónóp tibiób darrpan-darrpandó wagó, “Errkya mi ini azidómakla, mi ne tonarr tónggapónóp mibiób zoretódó. Mi mib ene wirri müp esenóp wa ne kolaedó yarilürr, wa tüób mibü tangbamtinüm arüngi nóma tatop, da mi koke barrkrrurr. Ene zitülkusdü, mi errkya ini müpdümakla.” ");
INSERT INTO tof_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rruben bóktanórr wagó, “Ka yabü nilarre wagó, kolae tonarr tónggapón-gu ini olomdó. A e ma koke barrkrrurr. Errkya ene darrema kuri tolkomóle mibüka, oya óea neme tópkanórr.” ");
INSERT INTO tof_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zosep umul bainürr i ne pokobóka apón kwarilürr. A i ma koke umul bainóp, zitülkus bóktan amzazil pam asi yarilürr oyaka bóktan okaka amzazilüm Izipt bóktane. ");
INSERT INTO tof_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Zosep ibü we nümgütóp da yónüm wamórr. Wa akó bóktanóm nóma bainürr, wa we tolkomólórr. Wa tóba darrü zaget pam yalórr Simionón apadóm, da ene zaget pama oya sye-i we amrókórr ibü obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Zosep tóba zaget pam arüng bóktan nókyenóp tóba naretalab alóp murrbausüm wit küpi, akó ibü blamanab ⌊silba⌋ mani poko tibiób alópdó akonóm, ó ibü alo kla aliónüm kwat-kwat alom. Ene bóktan pokoa tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Oya naretala wit küp tibiób ⌊donkidü⌋ yamselóp, ó ene bwób we amgütóp. ");
INSERT INTO tof_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","I nóla bamilóp ene irrüb utüm, darrüpa tóba alóp nóma tapakurr tóba donki ngóyónüm, wa tóba silba mani poko tumuman nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Wa tóba zonaretaldó górrganórr wagó, “Kürü silba mani pokoa kuri tolkomóle kólbaka! Yóni, kürü alópdóma!” Ibü moboküpa müp bainóp, ó gum tórrngónpükü tibiób darrpan-darrpan bamtinóp wagó, “God ia laró tonarr tónggapónóm kainda mibüka?” ");
INSERT INTO tof_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","I tibiób ab nóma emrrónóp Zeikobón, Keinan tüpdü, i oya we izazilóp blaman ene ne pokoa tómbapónónóp ibüka wagó, ");
INSERT INTO tof_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Izipt kantrrian gabena kibüka taren-taren bóktalórr, ó wa kibü inzan tangónóp, wamaka ki kómdam bain pamakla. ");
INSERT INTO tof_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","A ki ma bóktan yalkomólóp oyaka wagó, ‘Ki kómdam bain pam kokeakla, ki wata amkoman moboküp pamakla. ");
INSERT INTO tof_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ki blaman 12 simanal olmal kwarilnürrü, blaman darrpan abdógab. Darrü zoret büdüla, ó solo kupo zoret asise Keinanóm, kibü abdó.’ ");
INSERT INTO tof_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ene pama, ene kantrri wirri pam nótóke, bóktan yalkomólórr wagó, ‘Ka sab igósüm umul baino wagó, e wata amkoman moboküp pamakla: Yabiób darrü ala amgütam kürüka; e barrea sab wit küp barrmuno yabiób olmalkolabkü, alo büdül nidipasko. ");
INSERT INTO tof_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","E yabiób solo kupo zoret sab sidüdamke kürüka. Ene igósüm, ka sab umul baino wagó, amkoman e kómdam bain pam kokeakla, e amkoman moboküp pamakla. Ka sab yabü narezoret salkomolo yabióbka, ó e sab kibü bwóbdü kwarilo, ó e sab agóltagól kwarilo ini kantrridü.’” ");
INSERT INTO tof_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","I tibiób blaman elklaza nóma yusóp tibiób alópdógab, módóga, i blamana tibiób silba mani küppükü paos nósenóp tibiób alópdó! I ene paos nóma nósenóp, i tib akó tibiób ab Zeikob kari gum tórrngón koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ibü aba ibüka bóktanórr wagó, “Yabü ubi ia ugósüma wagó, ka kólba blaman olmal nümrüknümo? Zosep kankü babula, Simion kankü babula, ó yabü ubi akó Benzaminün ódódóma. Blaman ini müp kótó bamseldóla!” ");
INSERT INTO tof_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Da Rruben abdó we bóktanórr wagó, “Ka sab ne Benzaminün koke nóma salkomolo marüka, ma sab kürü siman olom nis ugón nümkalke. Ma oya kürü tangdó ugó ingri, akó ka sab oya salkomolo marüka.” ");
INSERT INTO tof_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","A Zeikob ma bóktan we yalkomólórr oyaka wagó, “Kürü oloma kokean wame mankü, zitülkus oya naret büdüla, ó wa wata dómdóm pammokur módóga arról Rreizelkagab. Darrü klama sab kena tómbapón oyaka, kwat-kwat. Ka myang kuri baina akó ene gyaurdügabi, e sab kürü büdülbóka kena agósam.” ");
INSERT INTO tof_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Keinan bwóbdü, kua wata kari kolae koke bailürr. ");
INSERT INTO tof_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","I ne ⌊wit⌋ küp simarruóp Iziptgab, blamana nóma blakónóp, da Zeikob tóba simanal olmaldó bóktanórr ibüka wagó, “E ugó bako, mibünkü ngibürr alo bumiógüm.” ");
INSERT INTO tof_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","A Zuda tóba ab yalórr wagó, “Ene pama kibü arüng ikik tókrrórre wagó, ‘E myamem kürü obzek koke esenane, kókó e sab yabiób zoretpükü togobo kürüka!’ ");
INSERT INTO tof_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ma ne kibü zoret nóma zirrsapono kinkü tótókóm, ki igósidi sab ogobo Izipt, marü alo kla azebóm. ");
INSERT INTO tof_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","A ma ne oya koke nóma zirrsapono kinkü tótókóm, ki sab koke ogobo, zitülkus ene pama igó yarilürr wagó, ‘E myamem kürü obzek koke esenane, kókó e sab yabiób zoretpükü togobo kürüka!’” ");
INSERT INTO tof_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Zeikob bóktanórr wagó, “E kolaean poko tónggapónarre! E ene pamdó iade adrrütarre wagó, ‘Kibü zoret asise’?” ");
INSERT INTO tof_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","I blamana bóktan yalkomólóp wagó, “Ene pama aüd poko koke bamtilürr, kibü olmalkolabbókamóm. Kibü igó tümtinónóp wagó, ‘Yabü ab ia arrólae? Yabü darrü zoret ia asise?’ Da ki oyaka bóktan blaman we yakonónóp wagó, ‘Ó’. Ki umul ia ki bairre igó, wa kibü inzanóm bamtinda kibiób zoret ola ódódóm?” ");
INSERT INTO tof_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Zuda bóktanórr tóba abdó Zeikobka wagó, “Ene omokura kankü ki tam. Ki kubó wankü darrpan mün ogobo errkyadan. Ene igósüm, kidi, mató, akó kibü olmala alo büdül koke nurrbarine. ");
INSERT INTO tof_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Benzaminün ne arról sab kótó bügasilo. Ka ne sab oya marü obzek kwata koke nóma singrino, ene müp sab kürüka ki yarilün metat. ");
INSERT INTO tof_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ki ne dokyanan ngürr koke nóma ki arrótóp, ki errkya nis ngim igósidi bakorrón ki korala!” ");
INSERT INTO tof_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Da ibü aba Zeikob bóktanórr ibüka wagó, “Inzan ne nóma yarile, da ini kla tónggapónam: ngibürr morroalan elklaza irrbünam yabiób alópdó ini tüpdügab. Ugó barrmü ene pamdó, ae kla ilinamke oya morroal ainüm: morroal bübdü balóp ilang móeg, kari sokol gus mor, meke, akó almónd. ");
INSERT INTO tof_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dokyanan mani emorronam yabiób, igósüm ene gao aodóm e yabiób alóp tumum ne mani sakonarre. Aprrapórr wa bütanórr. ");
INSERT INTO tof_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Yabiób zoret ta ipüdam. Ene pamdó ugó bako errkyadan! ");
INSERT INTO tof_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ka tóredóla, Wirrian Arüng God sab ene wirri pam gyaur ekyene yabükwata. Ene igósüm, wa ok nirre yabü narezoret nis Simion akó Benzamin, ibü alkomólóm yenkü. Ka ne olmal nóma eloklo, taia, inzan ki yarilün: ka sab ibü wata inzan eloklo.” ");
INSERT INTO tof_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ene pama ⌊gyaur kla⌋ akó dokyanan mani yazebóp. Benzaminün ipüdóp, da we bazebórr ama Izipt. Zosepón obzek kwata we bórrangórr. ");
INSERT INTO tof_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Zosep Benzaminün nóma esenórr inkü, wa bóktanórr ene pamdó oya müót nótó ngakalórr wagó, “Ini pam yazeb, da kürü müótüdü ugó imarru. Ngóyórrün lar edabónam, da morroal yung. Ini pamab abüs singülküp alo kanküma.” ");
INSERT INTO tof_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Müót ngakan pama tórrmendó ingrinürr, oya Zosep enezan yalórr. Zosepón zaget pama oya zonaretal imarrurr Zosepón müótüdü. ");
INSERT INTO tof_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ibü enezan barrmülürr Zosepón müótüdü, i gum koralórr. Igó gyagüpitótóke ogoblórr wagó, “Mibü igósidi türrbamüne maniankwata, i ne kla yakonóp mibü alópdó, mi ngaen-gógópan nóma bakonórr. I kubó ngürsilpükü togobe mibüka! Mibü sab tubarrmüne leba zaget pamóm akó wa sab mibü ⌊donki⌋ tümtirre.” ");
INSERT INTO tof_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","I müót mamtaedó nóma togobórr, da Zosepón müót ngakan pamdó we bóktónóp wagó, ");
INSERT INTO tof_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Gyaurka, kibü wirri pam, ki ngaen-gógópan ae togobórró alo bumiógüm. ");
INSERT INTO tof_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ki nóma bakorró kókó kwat-kwat, ene irrüb ki we bazurrurrü. We tapanukuóp kibiób alóp, da ki nósenóp blaman pamab mani wata tibiób alóp tumuman koralórr. Da ki we manipükü tübarrmüna. ");
INSERT INTO tof_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ki kibiób ngibürr manipükü tóbakona akó alo bumiógüm. Ki umul-kókakla kibü alópdó ini mani ia nótó irrbünürr.” ");
INSERT INTO tof_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Zosepón müót ngakan pama bóktan yalkomólórr ibüka wagó, “Gyakolaegu! E gumgu! Yabü akó yabü aban Goda yabü mani piküpan yakonórr yabü yabiób alópdó. Ka yabü darrem kla ngaen emorrarró.” Da wa Simionón sidódürr ibüka. ");
INSERT INTO tof_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Müót ngakan pama ene pam simarrurr Zosepón müót kugupidü. Ibü nae nókyenóp ibü wapór bagulüm. Wa akó ibü donki ngabyónürr. ");
INSERT INTO tof_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","I gyaur kla irrbünóp Zosepón aliónüm, wa abüs singülküp kubó nóma tame, zitülkus i tib barrkrrurr wagó, i kubó usakü elorre. ");
INSERT INTO tof_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Da Zosep müótüdü nóma bangrinürr, i oya gyaur kla we ilinóp, i ne kla tübarrmünürr müótüdü. I wakósingül nümgünóp, singül tüp balókórr oya obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Zosep ibü nümtinóp tibiób ngyabenankwata. Da we bóktanórr wagó, “E kürü yabiób ab myangbóka küzazilarre, wa iadase? Ia wa arrólase?” ");
INSERT INTO tof_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Da i bóktan we yalkomólóp wagó, “Marü zaget pam, kibü ab, taiase. Arról duduae!” I wakósingül nümgünóp akó singül tüp balókórr Zosepón obzek kwata oya wirri ngi amngyelóm. ");
INSERT INTO tof_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wa nóma yazilürr, tóba zoret esenórr Benzaminün. I darrpan aipdügabi tómtómórri. Wa we bóktanórr wagó, “Ia ini yabü solo kupo zoreta, e kürü noabóka küzazilarre? God marü ⌊gail tonarr⌋ ki mókya, kürü olom!” ");
INSERT INTO tof_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Zosepón moboküp inuóp wa tóba zoret nóma esenórr akó wa igósidi ene poko büsai we amgatórr darrü bwób amkünüm yónüm. Wa tóba müót marrgudü bangrinürr, da we yón yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Wa tóba obzek nóma bagulürr, wa akó we tubrranórr. Tóba yón-gyaur iniklürr. Wa we bóktanórr wagó, “Alo kla arsinam tógaldó!” ");
INSERT INTO tof_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Alo kla we arrgrrütóp, Zosepón tóbanan tógal akó oya zonaretalab tibióban tógal. Akó ene Izipt pam, usakü nidi elop, ibü go tibióban tógal. Ibü gidazan bóktanórr, Izipt kolpama koke dabyónónóp Ibrru kolpampükü alom, zitülkus inkü dabyónüm ngazirra. ");
INSERT INTO tof_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Zosepón zonaretala oya obzek kwata igó bobrranórr i enezan tóbabótórr, naretódógab kókó zoret amrran. I tibiób darrem-darrem nóma ngabkanónóp mórrande, da gübarirr aengóp. ");
INSERT INTO tof_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ibü alo kla idüdóp Zosepón tógaldógab. Da Benzaminün alo kla, wa 5 ngarkwat arrbürrün kwarilürr ngibürr naretaldógab. Da i bagürwóm kwarilürr wankü alode akó anónde. ");
INSERT INTO tof_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Zosep tóba müót ngakan pam yalórr wagó, “Ene pamab alópdó dokyanan alo kla irrbünam, ibü amarrum ngarkwat. Akó ibü mani tibiób alóp tumum kolatónamke. ");
INSERT INTO tof_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kürü ⌊silba⌋ kübül kubó zoretan alóp tumum kolakyanamke oya manipükü, wa ne mani simarrurr ⌊wit⌋ küp bumiógüm.” Da wa tónggapónórr oya Zosep enezan yalórr. ");
INSERT INTO tof_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Irrbianande, zaget pama Zosepón zonaretal we zirrnapónóp tibiób ⌊donkipükü⌋. ");
INSERT INTO tof_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","I ene wirri basirr nóma amgütóp, aibwób-koke, Zosep we bóktanórr tóba müót ngakan pamdó wagó, “Bupa, da ene pamab solkwat akya! Ma kubó ibü nóma nómrrónónómo, nümtinünümke ibü wagó, ‘E kürü morroal tonarr kolae tonarre iade yalkomólane? ");
INSERT INTO tof_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","E silba kübül gómól-gómól iade ipüdane? Ini kürü wirri paman anón kübüla: wa ugósüm ngakanda, ugórr ngyaben amzyatóm. E wirri kolae kuri tónggapónane!’” ");
INSERT INTO tof_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ene müót ngakan pama bupadórr, ibü we nómrrónóp, da wa dadan bóktan poko we arükürr ibüka. ");
INSERT INTO tof_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Da i bóktan we yalkomólóp wagó, “Kibü wirri pam, ma inzan iade bóktandóla ini poko? Ki, marü zaget pama, inzan kolaean tonarr kokean tónggapórre. ");
INSERT INTO tof_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Turrkrru, marü ia kuri ngambangóle, ki inzan tóbakorró marüka Keinan tüpdügab kibiób manipükü marüka akonóm, ne kla nósenóp kibiób alóp tumum? Ki ma gómól-gómól silba akó gold iade ki yazebrre marü wirri paman müótüdügab? ");
INSERT INTO tof_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ma ne kubó kübül kibü darrüdü nóma eseno, wa kubó ki nurrótók! Sab ki ngibürr marü ⌊leba zaget⌋ pamóm bairre.” ");
INSERT INTO tof_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Wa bóktan yalkomólórr wagó, “Inzan ki yarilün mazan namüla wagó, kübül kubó noaka nóma eseno sab kürü leba zaget olom yarile. A e ngibürra sab ene ⌊kolaean darrem⌋ koke ipüdane.” ");
INSERT INTO tof_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Blamana büsai-büsai tibiób alóp we elókóp tüpdü, da we tapanukuóp. ");
INSERT INTO tof_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Müót ngakan pama amkünüm we bainürr; naretódógab bókyanórr kókó zoretódó Benzaminka. Ene kübül Benzaminün alópdó esenórr. ");
INSERT INTO tof_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ene gyaurdügab, i tibiób mórrkenyórr nütürróp. Solkwat donkidü elklaza yamselóp, we bakonórr akó wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zuda tóba zonaretalpükü nóma tübarrbünürr Zosepón müótüdü, wa wata ola yarilürr. I wakósingül nümgünóp, singül tüp balókórr oya obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Zosep bóktanórr ibüka wagó, “E ini kolae iade tónggapónane? E ia koke umul bainane igó, kazan pamla, gaodómla umul bainüm ene kla, pamkolpam gaodó kokeako ene kla umul bainüm?” ");
INSERT INTO tof_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Zuda bóktan yalkomólórr wagó, “Kibü wirri pam, ki marüka ia poko bóktórre? Ia ki laró tónggapórre kibiób morroal bainüm marü ilküpdü? God kibü kibiób kolae kuri tóserre. Turrkrru, ki blaman marü leba zaget pamakla; ki blaman akó kübül noa alópdó eserre.” ");
INSERT INTO tof_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Da Zosep bóktanórr wagó, “Inzan koke! Ka ene poko kokean tónggapono! Wata ne pam eserre kübülpükü, kürü leba zaget olom wató yarile. A e barrea kubó tai ogoblónke yabiób abdó.” ");
INSERT INTO tof_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Da Zuda tai oya minggüpanandó wamórr. We bóktanórr wagó, “Gyaurka, kürü wirri pamóe, ka marü zaget pama kya dümdüman bóktanón darrü poko, marü arrkrrum. Enana ma parrao ngarkwatódómla, ma kubó ngürsilgu kürüka, marü zaget pam. ");
INSERT INTO tof_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ki ngaen-gógópan nóma togobórró, ma, kibü wirri pam nótókla, we tümtinóp wagó, ‘Ia yabü ab asise akó ia yabü darrü zonaret asise?’ ");
INSERT INTO tof_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ki bóktan yalkomólóp marüka, kibü wirri pam, wagó, ‘Kibü ab myang asise akó solo kupo zoret ta asise, wa myangande noan ilngumilürr. Errkya oya naret büdüla. Dómdóm ma watóke solo aipdügab, ó oya aban ⌊moboküpdü ubi⌋ oyakamóma.’ ");
INSERT INTO tof_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ma kibüka bóktarró, moba zaget pamdó, wagó, ‘Oya sab ala sidüdamke kürüka, ugósüm ka oya obzek eseno.’ ");
INSERT INTO tof_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Da wirri pam, ki bóktan marüka yalkomólóp wagó, ‘Ene omokura tóba ab kokean amgüte. A wa ne ab nóma amgüte, oya aba sab nurrótóke.’ ");
INSERT INTO tof_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ma kibüka bóktarró wagó, ‘E myamem kürü obzek koke esenane, kókó e sab yabiób solo kupo zoretpükü togobo kürüka.’ ");
INSERT INTO tof_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Ki nóma bakorró kibiób abdó, marü zaget pam, da ki oya izazilóp ma kibü wirri pama ne poko tüzazilóp. ");
INSERT INTO tof_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Kibü aba bóktanórr wagó, ‘E bako, mibü ngibürr alo kla bumiógüm.’ ");
INSERT INTO tof_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Da ki bóktan yalkomólóp wagó, ‘Ki koke babino ola. Kibü solo kupo zoret ne asi nóma yarile kinkü, ki igósidi babino ola. Sab ki myamem koke eserre ene paman obzek, kókó kibü solo kupo zoret asi yarile kinkü.’ ");
INSERT INTO tof_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Da kürü aba Zeikob bóktanórr kibüka wagó, ‘E umulakla, kürü kola nis siman olom nis nulngumilürr kürükü. ");
INSERT INTO tof_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Darrüpa kürü kimgatórr, da ka bóktarró wagó, “Ka umulóla wa syórrpókal angórrónase.” Ka oya kokean kuri eserró, wa ne ngarkwat bamrükürr. ");
INSERT INTO tof_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","E kubó akó ini ne nóma ipüdane kürükagab, darrü kolae klama aprrapórr tómbapóne oyaka. Ka myang kuri baina akó ene kolaedógabi, e sab kürü büdülbóka kena agósam.’” ");
INSERT INTO tof_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Zuda akó bóktanórr wagó, “Ka ne olom-koke nóma yalkomolo kólba abdó, marü zaget pam, wa kubó kibü nóma tóserre wagó, olommokur babula inkü, da wa kubó nurrótóke. Zitülkus módóga, oya ubi babula ngyabenóm, oya moboküpdü oloma koke ne nóma alkomóle. Wa myang kuri baine akó ene gyaurdügabi, ki, marü zaget pam, sab kibiób aban büdülbóka kena agósam. ");
INSERT INTO tof_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ka kólba bumanikürrü kólba aban ngidü ini omokur alkomólóm kólba abdó. Ka bóktarró wagó, ‘Ka ne koke nóma salkomolo marüka, da ene müp sab kürüka ki yarilün metat.’ ");
INSERT INTO tof_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Da módóga, gyaurka, ka marü leba zaget olomóm ala namulo zagetóm marünkü, kürü wirri pam, omokuran pabodó. A omokura ki alkomól basirrdü tóba naretalpükü. ");
INSERT INTO tof_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ka wa ia alkomolo kólba abdó, ene omokur babul ne nóma yarile kürüka? Ka kari gum kokela kólba aban gyauran büdül asenóm.” ");
INSERT INTO tof_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Zosep myamem gaodó koke yarilürr tóba moboküpdü ne gyaur yarilürr amiógüm tóba zaget kolpamdógab, ola nidi bórranglórr. Wa wirri arüngi we bóktanórr wagó, “Blamana kya kürü kümgütam!” Da darrü zaget pam babul yarilürr wankü, Zosep tóba zonaretaldó nóma pupo bainürr wa nótó yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Wa wirri taegwarre yón yarilürr, da Izipt pamkolpama barrkrrulürr. Akó nidi kwarilürr parraoan müótüdü, ene bóktan ta barrkrrurr. ");
INSERT INTO tof_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Zosep bóktanórr tóba zonaretaldó wagó, “Ka Zosep! Kürü ab ia arrólae?” A oya zonaretalab gaodó koke yarilürr bóktan oyaka alkomólóm, zitülkus i gum tórrngón kwarilürr oya obzek kwata. ");
INSERT INTO tof_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Zosep bóktanórr tóba zonaretaldó wagó, “Gyaurka, kürü minggüpanandó togob.” I we togobórr oya minggüpanandó. Wa bóktanórr wagó, “Ka yabü narezoretla Zosep, e noan sel inarre mogob pamdó akó i kürü küdüdóp Izipt! ");
INSERT INTO tof_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Da e müp apadgu inibókamde, ó ngürsilgu yabióbka, igósidi e kürü darrem klamóm küngrinarre aini. Kürü God wató zirrkapónórr yabü singül kwata, pamkolpamab arról zid bainüm. ");
INSERT INTO tof_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ini wata nis ngim paila ku kolakyanóm ini tüpdü. 5 pail duduako kesu angón-koke akó abül-koke. ");
INSERT INTO tof_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God kürü zirrkapónórr yabü singül kwata yabü zid bainüm ini tonarre, yabü ngyaben akó yabü olmalbobatalab ngyaben alblangóm ini tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Da kürü yadi koke zirrkapónóp aini. A God wató küdódürr. God kürü küngrinürr parraoan ikik bókrran pamóm, oya müót ngakanóm akó blaman Izipt kantrri alngomólóm. ");
INSERT INTO tof_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Büsai ogob kürü abdó. Oyaka bóktónamke wagó, ‘Marü oloma Zosep inzan bóktóne marüka wagó, “God kürü arüng kókyanórr blaman Izipt kantrri ngakanóm. Kürüka tam, ola irrbain-gu. ");
INSERT INTO tof_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ma sab Gosyen bwóbdü ngyabelo kürü minggüpanandó, matóka marü olmal akó bobatal, marü ⌊sip⌋ a ⌊gout⌋ akó ⌊kau⌋, ó marü ne blaman elklazako. ");
INSERT INTO tof_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ola marü sab kótó ngamkalo, zitülkus dómdóm 5 paila tótókdako ku kolakyanóm. Ene igósüm, matóka marü olmalbobatal akó marü ngabyón lara sab alo büdül koke nurrbarine.” ’ ");
INSERT INTO tof_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Errkya yabü ilküpa kürü kuri kóserre, ako kürü zoret Benzamin, ma ta kürü kuri kósena, da ini amkoman kótó bóktandóla, Zosep. ");
INSERT INTO tof_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","E sab izazilamke kürü ab igó poko, kürü ne wirri arüng ngie Iziptüm akó e ne blaman kla nósenarre. Da e sab oya büsai sidüdamke.” ");
INSERT INTO tof_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Wa tóba zoret Benzaminün we amiógürr akó yón yarilürr. Benzamin ta Zosepón amiógürr akó yón yarilürr. Nizana we yón namülnürri. ");
INSERT INTO tof_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Zosep wata yón yarilürr, tóba blaman zonaretal nóma nüprükóp. Ene kakóm, oya zonaretala usakü ikiküm we bainóp. ");
INSERT INTO tof_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ene bóktan nóma barrkrrurr parraoan wirri müótüdü wagó, Zosepón zonaretala kuri togobe, parrao akó tóba wankü ngi pama ta bagür kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Parraoa Zosepón we yalórr wagó, “Nüzazilnüm moba zonaretal magó, ‘Yabiób elklaza ⌊donki⌋ kwitüdü ugó yamselam, da bakonke Keinan tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Yabü ab akó yabiób olmalkol yazebamke, da tóbakonke kürüka. Ka sab yabü morroalan tüp poko nókyenónómo Iziptüm, ó e sab morroalan ngyabendó kwarilo ene tüpdü.’ ");
INSERT INTO tof_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ibü nilnümke magó, ‘Ngibürr osab bimurrat kla yazebamke, Izipt tüpdü kla, yabiób kolabkü akó karipókalabkü. Yabiób abpükü ipüdamke, da tóbakonke. ");
INSERT INTO tof_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yabiób elklazabkwata gyakolaegu bimgatóm. Izipt tüpdü ne morroalan klamko, sab yabü kwarile.’” ");
INSERT INTO tof_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Da Zeikobón simanal olmala we tómbapónónóp, parraoan bóktan ngarkwatódó. Zosep osab bimurrat kla we nülinóp, parraoa oya arüng bóktan enezan ekyanórr. Wa akó ibü alo nülinóp kwat-kwat alom. ");
INSERT INTO tof_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Wa ibü küsil mórrkenyórr nülinóp darrpan-darrpan, a Benzaminün wa ma 300 silba poko iliónürr akó 5 ngarkwat küsil mórrkenyórr. ");
INSERT INTO tof_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","10 simanal donki kwitüdü wa morroalan elklaza yamselórr Iziptgab, da we zirrnapónóp tóba abdó, akó 10 ópal donkidü we kla yamselórr, ⌊wit⌋ küp, brred, akó ngibürr alo kla, ibü kwat-kwat alom, i sab ene iazan togoble. ");
INSERT INTO tof_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Da wa tóba zonaretal we zirrnapónóp. I nóma bazebórr, wa ibü ikik nókrrónóp wagó, “Kubó ongyal-gu kwat-kwat!” ");
INSERT INTO tof_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Da i Izipt we amgütóp, ogobórr tibiób abdó Zeikobka, Keinan tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","I Zeikobón izazilóp wagó, “Zosep arrólase! Wa errkya balngomól pamase akó wa dudu Izipt kantrri alngomólda!” Zeikobón moboküpa karibóka koke gübarirr aengórr, da wa ibü amkoman koke nangunóp. ");
INSERT INTO tof_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","I oya nóma izazilóp blaman kla, ibü Zosep ne poko nüzazilóp, akó wa osab bimurrat kla nóma nósenóp, Zosep ne kla zirrnapónóp oya ódódóm Izipt kantrridü, Zeikobón arról dandanga tóbaka tolkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Zeikob bóktanórr wagó, “Gaodóma, ka yabü amkoman kuri nangunünüma! Kürü olom Zosep arrólae! Ka sab oya asenóm wamo, solkwat ka igósidi nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Zeikob tóba blaman elklaza tómbapónórr, we wamórr Berrsyiba wirri basirrdü. Wa ola lar bamngulürr ⌊alta⌋ kwitüdü, tóba ab Aesakón God we iliónürr. ");
INSERT INTO tof_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ene irrüb, Zeikob nuszan kla esenórr. God oyaka bóktanórr, da we ngilianórr wagó, “Zeikob, Zeikob!” “Ó, ka inamüla,” wa bóktan we yalkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Ka Godla, marü aban God. Ma gumgu Izipt tótókóm; ka sab marü olmalbobatalab zitül wirri ninünümo ola. ");
INSERT INTO tof_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ka küób sab mankü wamo Izipt, akó ka sab marü olmalbobatal sakono ini tüpdü. Zosep sab marüka asi yarile, ma nóma nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Zeikob Berrsyiba wirri basirr amgatórr. Oya simanal olmala tibiób ab Zeikob, tibiób kari olmal, akó kol osab bimurrat kla kwitüdü yamselóp, parraoa ne kla zirrtapónóp. ");
INSERT INTO tof_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","I tibiób ngabyón lar akó tibiób blaman elklaza, Keinanóm ne kla bumigóp, we imarruóp, da Izipt we bazebórr. Zeikob tóba blaman olmalbobatalpükü wamórr: ");
INSERT INTO tof_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","tóba blaman simanal olmal, ópal olmal, akó bobatal. ");
INSERT INTO tof_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Zeikobón olmalbobatalab ngi módógako, Izipt nidi ogobórr, Zeikob akó tóba simanal olmal akó bobatal. Ibü ngi módógako: Tóba ngaen siman olom, ngi Rruben, ");
INSERT INTO tof_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","akó oya simanal olmal: Anok, Palu, Ezrron, akó Karrmi. ");
INSERT INTO tof_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simion akó tóba simanal olmal: Zemuel, Zamin, Oad, Zakin, Zoarr, akó Syaol, Keinan koldógab nótó tómtómólórr. ");
INSERT INTO tof_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libae akó tóba simanal olmal: Gerrson, Koat, akó Merrarri. ");
INSERT INTO tof_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zuda akó tóba simanal olmal: Syela, Perrez, akó Zerra. (Zudan nis siman olom nisa Keinanóm ola nurrótókrri, ngi Err akó Onan.) Perrezón simam olom nis idi namülnürri: Ezrron akó Amul. ");
INSERT INTO tof_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakarr akó tóba simanal olmal: Tola, Pua, Zasub, akó Syimrron. ");
INSERT INTO tof_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun akó tóba simanal olmal: Serred, Elon, akó Zale-el. ");
INSERT INTO tof_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ini olmal Zeikob Liakagab nósenóp Mesopotamia bwóbdü. Daenan ta ola osenórr, darrpanan óp olom. Liakagab blaman oya 33 ngarkwat olmalbobatal kwarilürr. ");
INSERT INTO tof_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad akó tóba simanal olmal: Zepon, Agi, Suni, Ezbon, Erri, Arrod, akó Arreli. ");
INSERT INTO tof_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asyerr akó tóba simanal olmal: Imna, Isba, Isbi, Berria, akó ibü óp bólbót Serra. Berrian siman olom nis: Eberr akó Malkiel. ");
INSERT INTO tof_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ini ne 16 olmalbobatal Zeikob Zilpakagab nósenóp. Zilpa Lian leba zaget kol warilürr, Leiban noan okyanórr. ");
INSERT INTO tof_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Zeikobón solo kol Rreizel nis olom nis nósenórr: ngi Zosep akó Benzamin. ");
INSERT INTO tof_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Iziptüm Zosep nis siman olom nis nósenórr, Manase akó Iprra-im, Asenatkagab, Potiperran óp olom, prrist nótó yarilürr Eliopolis wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benzaminün simanal olmal idi kwarilürr: Bela, Bekerr, Asbel, Gerra, Na-aman, E-i, Rros, Mupim, Upim, akó Arrd. ");
INSERT INTO tof_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ini ne 14 olmalbobatal Zeikob Rreizelkagab nósenóp. ");
INSERT INTO tof_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan tóba darrpanan siman olompükü: ngi Usyim. ");
INSERT INTO tof_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naptali akó tóba simanal olmal: Zaziel, Guni, Zezerr, akó Syilem. ");
INSERT INTO tof_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ini ne 7 olmalbobatal Zeikob Bilakagab nósenóp. Bila Rreizelón leba zaget kol warilürr, Leiban noan okyanórr. ");
INSERT INTO tof_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Da blaman Zeikobón ne olmalbobatala ogobórr Izipt kóta 66 kwarilürr. Oya simanal olmalab kol ngarkwat koke ipüdóp. ");
INSERT INTO tof_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Zosep nis olom nis nósenórr Iziptüm. Zeikob tóba olmalbobatalpükü Izipt nóma togobórr, ibü pam ngarkwat kóta 70 emrranórr. ");
INSERT INTO tof_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Zeikob Zudan singül kwata we zirrapónórr, Zosepón amtinüm ibü basenóm tótókóm Gosyen tüpdü. I nóma babzilürr, ");
INSERT INTO tof_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Zosep tóba ⌊osab amorrat klamdó⌋ kasilürr, da we wamórr Gosyen tóba ab asenóm. I nóma baserri, Zosep tóba ab we amiógürr akó yón yarilürr. I barrkyanbóka yónüm we bairri. ");
INSERT INTO tof_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Zeikob we bóktanórr tóba olomdó wagó, “Ka marü gaodó kuri mósena, kürü büdüla ki tam. Ini ngürrdü, ka marü ilküpi kuri mósena akó ka umul kuri baina ma arrólóla.” ");
INSERT INTO tof_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Da Zosep tóba zonaretaldó we bóktanórr akó tóba aban kolpamdó wagó, “Ka kubó wamo parraodó, oya azazilüm kagó, kürü zonaretal akó kürü aban pamkolpama, Keinan tüpdü nidi ngyabenónóp, kuri togobe. ");
INSERT INTO tof_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ka kubó parrao izazilo igó, e ⌊sip⌋ ngabkan pamakla akó e sip a ⌊gout⌋ akó ⌊kaupükü⌋ kuri tübarrmüna akó blaman yabü ne elklazako. ");
INSERT INTO tof_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kubó parraoa yabü nóma ngibaune akó nóma nümtirre wagó, ‘Yabü zaget ia laróga?’ ");
INSERT INTO tof_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","e kubó izazilamke igó, ‘Wirri pam, ki wata sip ngabkan pamakla kibiób ngyaben tonarrdó, kibü abalbobatalazan ngyabenónóp.’ Ini bóktandógab, wa sab igósidi yabü Gosyen tüp nókyerre ngyabenóm. Zitülkus módóga, Izipt pamkolpamab ilküpdü, blaman sip ngabkan pam ngazirr kla kwarilürr. Koke ok nyónónóp tibiób minggüpanandó ngyabenóm.” ");
INSERT INTO tof_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Da Zosep we yazebórr 5 naretal, da i we ogobórr parraodó. Wa parrao we izazilürr wagó, “Kürü ab akó kürü zonaretala kuri togobe Keinangab tibiób ⌊sip⌋ a ⌊gout⌋ akó ⌊kau⌋ akó elklazapükü. I errkya Gosyen tüpdümako.” Wa ibü we imarrurr parrao asenóm. ");
INSERT INTO tof_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Parraoa ibü we nümtinóp wagó, “Yabü zaget ia laróga?” I bóktan we yalkomólóp wagó, “Wirri pam, ki wata sip ngabkan pamakla, kibü abalbobatalazan ngyabenónóp. ");
INSERT INTO tof_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ki ini tüpdü bupso ngyabenóm togoba, zitülkus Keinan tüpdü ku kari kolae kokea. Kibü sip a goutan alo opopor babulasko. Gyaurka, ma kibü, marü zaget pam, ok tinünüm Gosyen tüpdü ngyabenóm.” ");
INSERT INTO tof_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da parraoa Zosepón we yalórr wagó, “Marü ab akó zonaretala kuri togobe marüka, ");
INSERT INTO tof_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","da Izipt tüp mató ngakandóla. Gosyenóm sab tibiób marrgu ola ki apónónóm. Ngibürr zaget bórrgrratórrón pam ne nóma kwarile yabü aodó, kürü ngabyón lar sab morroal ki ngabkanónóm.” ");
INSERT INTO tof_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Zosep tóba ab we idódürr parrao asenóm. Zeikob parrao we bles yónürr. ");
INSERT INTO tof_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Parraoa oya we imtinürr wagó, “Ia marü nigó pailako?” ");
INSERT INTO tof_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Zeikob bóktan yalkomólórr wagó, “Kürü 130 pailako, enan agóltagóle emkalnórró. Kürü ngyaben pail abün koke kwarilürr, zitülkus ka kari müpdü koke namülnürrü. Kürü agóltagól ngyabena kuri tugupurr tübine kürü abalbobatalazan ngyabenónóp.” ");
INSERT INTO tof_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Zeikob nis ngim parrao we bles yónürr, da we amgatórr. ");
INSERT INTO tof_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Da Zosep tóba ab akó zonaretal Iziptüm we irrbünürr morroalan tüpdü, Rrameses wirri basirr minggüpanandó, parraoa oya enezan yalórr. ");
INSERT INTO tof_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Zosep tóba ab, zonaretal, akó blaman tóba aban kolpam alo kla blaman ngürrzan we nüliónónóp, ibü olmalab ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kua amkoman kari kolae koke nóma bainürr, aloa blakónórr blaman bwób-bwób, da Izipt a Keinan kolpama tai kolaem bainóp kuanbókamde. ");
INSERT INTO tof_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","I alo kla enezan bumiógnónóp, Zosep blaman pamkolpamdógab mani we yazeblórr, ama parraoan wirri müótüdü imarrulürr. ");
INSERT INTO tof_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ene blaman mania Iziptüm a Keinanóm nóma blakónórr, da blaman Izipt kolpama we togobórr Zosepka da ilóp wagó, “Gyaurka. Kibü alo kla tülinünüm. Ki marü obzek kwata kena nurrbarinün! Kibü mania kuri blakórre.” ");
INSERT INTO tof_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Zosep bóktan we yalkomólórr wagó, “Yabü mania nóma blakórre, e ne kla ngabyóndakla kürüka tübarrmü: yabü ene darrem ka alo kla nülinünümo.” ");
INSERT INTO tof_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","I ne kla ngabyónónóp, da we tübarrmülürr Zosepka. Da i we gyabalómnóp, ibü ne ⌊os⌋, sip a gout, kau, akó ⌊donki⌋ kwarilürr, alo klamóm. Ene pail, Zosep pamkolpam alo kla nüliónónóp ibü blaman ngabyón larab darrem. ");
INSERT INTO tof_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ene paila nóma blakónórr, Izipt pamkolpama akó küsil paildü we togobórr oya asenóm. Wagó, “Gyaurka, wirri pam, ki koke yalpirre wagó, kibü mania tai kuri blakórre. Akó kibü ne ngabyón larko, marüko. Darrü klama koke bamine marü akyanóm, wirri pam, da ma kibü büb akó tüp. ");
INSERT INTO tof_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ki büdülüm kokeakla marü obzek kwata! Kibü blaman tüpa sab igósidi kena kolae bainünüm! Ma kibü ugó tübumióg kibiób tüppükü, alo klamóm. Ki sab parraoan ⌊leba zaget⌋ pam kwarilo, kibü tüp ta sab oya kwarile. Ma kibü alo kla ugó tülinünüm, ngyabenóm akó küsil küp baritüm!” ");
INSERT INTO tof_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Da Zosep blaman Izipt tüp parraoankü bumióglürr. Blaman Izipt pamkolpama tibiób tüp darrem klamdó urrbulülürr, zitülkus ku kari kolae koke yarilürr. Da blaman ne tüp kwarilürr ama parraoan koralórr. ");
INSERT INTO tof_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Zosep blaman pamkolpam tóba leba zaget pamóm irrbünürr, Izipt darrü kubdügab kókó dakla kub. ");
INSERT INTO tof_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Wa blaman tüp poko bumiógürr, wata prristab ne tüp poko kwarilürr, wa koke bumiógürr, zitülkus parraoa ibü mani gail yarilürr ibü ngyabenóm. Da i igósidi tibiób tüp poko koke sel nülinóp. ");
INSERT INTO tof_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Zosep bóktanórr pamkolpamdó wagó, “Tübarrkrru, ka errkya yabü büb akó tüp kuri bumiga parraoankü. Küp ikwóni baritüm apapdó. ");
INSERT INTO tof_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Abül ngürr nóma semrróne, e sab blaman 5 küpdügab darrpan küp parrao iliónane. E sab barre küp zidüm urrbulünke akó alo klamóm yabióbkü, yabü müót kolpamabkü, akó yabiób olmalabkü.” ");
INSERT INTO tof_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","I bóktan yalkomólóp wagó, “Ma kibü arról kuri sakona; wirri pam, ma moba obzek kwata kibüka ne morroal nóma eseno, da ki sab parraoan leba zaget pam kwarilo.” ");
INSERT INTO tof_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Da Zosep gida bóktan poko we ingrinürr Izipt tüpankü wagó, abül ngarkwat nóma semrróne, blaman 5 küpdügab darrpan küp parraoan yarile. Errkya ini ngürrdü ene gida bóktan poko wa asine. Wata prristab tüpa parraoan tüp pokom koke bainóp. ");
INSERT INTO tof_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Da Isrrael pamkolpama we ngyabenónóp Izipt kantrridü, Gosyen bwóbdü. I ola mórrel ipüdóp, akó i abün olmal we nósenónóp. ");
INSERT INTO tof_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Zeikob Izipt kantrridü we ngyabelórr 17 pailüm, kókó wa 147 pail ngarkwat we emrranórr. ");
INSERT INTO tof_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Oya büdül ngarkwata minggüpanan nóma tamlórr, wa Zosepka bóktan zirrapónórr oya tótókóm. Oyaka bóktanórr wagó, “Ma moba obzek kwata kürüka ne morroal nóma seserró, moba tang kürü waurr grasana zirrsapó akó ⌊alkamül-koke bóktan⌋ ugó kókya wagó, ma sab kürü gapók ala koke ilüngo, Izipt kantrridü. Ma kürü morroal tonarr kómtya akó alkamülgu, ma ne bóktan kókyeno. ");
INSERT INTO tof_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kürü ubi ugósüma, ma sab kürü külüngo kürü abalbobatal nólamasko. Ma sab kürü Iziptgabi küdódke ama kólba bwóbdü, kürü abalbobatalab metat urbwóbdü.” Zosep bóktan yalkomólórr wagó, “Ka sab tónggapono, ma kürü ne poko kila.” ");
INSERT INTO tof_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Zeikob bóktanórr wagó, “Ma kürü ⌊arüng alkamül-koke bóktan⌋ ugó kókya, ma sab amkoman tónggapono.” Zosep oya ene arüng alkamül-koke bóktan ekyanórr. Zeikob singül tüp we elkomólórr tóba ut bwóbdü Godón ⌊ótókóm⌋. ");
INSERT INTO tof_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ngibürr tonarr kakóm, Zosepón umulan ngitinóp wagó, “Turrkrru, marü ab azidase.” Da wa tóba siman olom nis we nüpadórr, Manase akó Iprra-im, da i we ogobórr Zeikobón angónóm. ");
INSERT INTO tof_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Zeikobón nóma izazilóp wagó, “Marü oloma Zosep kuri tame marü angónóm,” wa tóba dómdóm arüng ipadórr, da bupadórr, we mórranórr tóba ut bwóbdü. ");
INSERT INTO tof_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Zeikob bóktanórr Zosepka wagó, “Wirrian Arüng God tóba kürüka okaka tübyónürr Luzüm, Keinan tüpdü, ó kürü God ola bles kyónürr. ");
INSERT INTO tof_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Wa bóktanórr kürüka wagó, ‘Turrkrru, ka sab marü abün olmalbobatal mülino. Marü olmalbobatala sab blaman bwób ayonórre ini Keinan tüpdü; ka sab ini Keinan tüp marü olmalbobatal nókyenónómo metatómpükü.’ ");
INSERT INTO tof_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Zosep, marü ne nis siman olom nisamli, Iprra-im akó Manase, kürünamli, wamaka Rruben akó Simion, izanamli. I Izipt kantrridü tómtómórri, ka ma ene solkwat tamórró. ");
INSERT INTO tof_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Solkwat olmal marü moba korale; ibü tüp akó elklaza sab Iprra-im akó Manase, idi nüliónórre, zitülkus aban pabo idi apadódamli. ");
INSERT INTO tof_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ka ini tonarr igósidi tónggapóna, marü aipan zitülkusdügab, Rreizel. Kürü bübdü wirri gyaur yarilürr, wa Keinan tüpdü nóma nurrótókórr, wirri kan babul Eprrat wirri basirrdügab, ka kwat-kwat nóma tolkomólnórró Mesopotamia bwóbdügab. Ka oya we ulungürrü ne kwata tamlórr Eprrat wirri basirrdü, kwat kabedó.” (Eprratón darrü ngi módóga: Betliem.) ");
INSERT INTO tof_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Zeikob Zosepón olom nis we nósenórr, ó we bóktanórr wagó, “Ini ia noa siman olom nisamli?” ");
INSERT INTO tof_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Zosep bóktan yalkomólórr tóba abdó wagó, “Ini kürü olom nisamli, God nibiób kókyanórr aini Iziptüm.” Zeikob bóktanórr wagó, “Ala tüdó, ka kubó ibü bles nino.” ");
INSERT INTO tof_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ene tonarrdó, Zeikobón ilküpa tümün bairri, zitülkus wa myangan yarilürr. Oya amzyat nabe yarilürr. Da Zosep siman olom nis aban minggüpanandó nüdódürr, ó Zeikob ene siman olom nis nüpadórr, tóba minggüpanandó tüdódürr, we nüprükürr. ");
INSERT INTO tof_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Wa Zosepka bóktanórr wagó, “Kürü gyagüpitótók inzan yarilürr, kamaka ma büdüla da ka sab marü myamem kokean móseno. A módóga, ini tonarr ma God kürü wató ok kine marü asenóm akó marü olom nis.” ");
INSERT INTO tof_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Da Zosep tóba siman olom nis nüpadórr tóba aban ganggópdógab, wakósingül nülkamülürr, singül tüp we elkomólórr. ");
INSERT INTO tof_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ene kakóm, Zosep Iprra-imün tóba tutul tange ipadórr, da Zeikobón banól kwata sidódürr. Akó wa Manasen ma tóba banól tange ipadórr, da Zeikobón tutul kwata sidódürr. ");
INSERT INTO tof_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Zeikobón tang nisa ma simbruatrri ó wa tóba tutul tang ipadórr, Iprra-imün singüldü emngyelórr, wa go zoret yarilürr. Wa tóba banól tang Manasen singüldü emngyelórr, wa go naret yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Zeikob Zosepón bles yónürr ó bóktanórr wagó, “God ini olom nis ki bles tyó, kürü abalbobatala Eibrra-am akó Aesak ne Godón yagürnóp. Wa kürü ⌊sip⌋ ngabkan pamzan ngakanda kürü ini ngyabende, kürü amtómól ngürrdügabi kókó ini ngürr. ");
INSERT INTO tof_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","⌊Godón anerrua⌋ ini olom nis ki bles tyó, kürü nótó zid kyónürr blaman kolaedógab! I sab kürü ngi ki idódlam, akó kürü abalbobatalab ngi, Eibrra-am akó Aesak. Ibü sab abün olmalbobatala ki tóbabótólón ini tüpdü!” ");
INSERT INTO tof_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Zosep tóba ab nóma esenórr tóba tutul tang Iprra-imün singüldü angrirrün, oya ene ubi-koke poko yarilürr. Da wa tóba aban tang ipadórr, Manasen singüldü amngyelóm. ");
INSERT INTO tof_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Zosep tóba abdó bóktanórr wagó, “Ba, inzan koke! Manase wa ngaen oloma. Ma moba tutul tang oya singüldü ki emngyela.” ");
INSERT INTO tof_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Aba badólórr ó we bóktanórr wagó, “Ka umulóla, kürü olom, ka umulóla. Manase ta sab wirri baine akó oya ne olmalbobatal kwarile. Oya zoretan ma sab amkoman abün olmalbobatal kwarile, akó oya ne olmalbobatal kwarile, i ugórr abün kantrri tómbapórre.” ");
INSERT INTO tof_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Da ibü Zeikob we bles nyónürr ene ngürr ó we bóktanórr wagó, “Isrrael pamkolpama sab yabü ngidü bles bain kwarile. I sab bóktanórre wagó, ‘Marü sab God igó ki mangó, wamaka Iprra-im akó Manase.’” Ini tonarre, Zeikob Iprra-imün singül kwata ingrinürr Manasekagab. ");
INSERT INTO tof_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Da Zeikob we bóktanórr Zosepka wagó, “Turrkrru, ka büdül kari pokola. God sab marüka asi yarile akó marü sab malkomóle moba abalbobatalab tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Syekem morroal tüp poko, ka gazirr turriki akó bügür kyabe ne kla amiógrrü Amorr pamkolpamdógab, errkya marüne, a marü zonaretalab ma koke.” ");
INSERT INTO tof_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Zeikob tóba simanal olmal ngibaunürr tóbaka. Wa bóktanórr wagó, “Kürü kal-kal kangónam, zitülkus ka kubó yabü nüzazilnümo sab laróga tómbapóne yabüka darrpan-darrpandó, singül kwata ne paila tótókdako. ");
INSERT INTO tof_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Yao, darrpan pokodó togob! Tübarrkrru, e Zeikobón simanal olmal! Kürü bóktan tübarrkrru, ka yabü ab Isrrael! ");
INSERT INTO tof_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Rruben, ma kürü ngaen olomla, ma kürü arüngla. Ka ngaen-gógópan marü mulngumilürrü, ka wirri pam nóma bairrü. Ma wirri ngi pamla ó marü arüng wirria blaman zoretaldógab. ");
INSERT INTO tof_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Naiz naeazan busoda, ma inzan ngürsil pamla. Ma sab amkoman wirri pam koke namulo, zitülkus ma kürü darrü kolpükü umtulürrü, ó ma kürü ut marrgu ⌊tóman⌋ alópórró. ");
INSERT INTO tof_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simion akó Libae narezoretiamli. Ibü turrik gazirr klamamli elklaza kolae bainüm. ");
INSERT INTO tof_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ka sab ibü piküpan ikikdi koke barümo, akó ibü bóktan tómbapónde koke tang namtino. Zitülkus módóga, ibü ene ngürsil yarilürr, pam we okrralórr; i ⌊kau⌋ wapór kus nümgününóp agólgum tibiób ubidügab. ");
INSERT INTO tof_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ibü ngürsil sab ki amórrórrón yarilün, zitülkus kari kolae kokea. Ibü wirri ngürsil sab ki amórrórrón yarilün, zitülkus gyaur babula. God sab ibü nórrgrróte Zeikobón olmalbobatalab aodó, akó wa sab ibü nórngene blaman Isrrael tüpdü. ");
INSERT INTO tof_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Zuda, marü zonaretala sab marü magürnórre. Ma sab ibü gepko nómóngnónómo, mankü nidi bókrrale. Marü zonaretala sab marüka wakósingül amgünórre. ");
INSERT INTO tof_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Zuda, kürü olom, ma ⌊laeon⌋ kupozanla; su we elóngórró, da we bupadórró, moba pepesdó we alkomórró. Wa siman laeona, wa wapór tang barrngumilda tüpdü utüdi. Wa wata óp laeonzana, gum-koke nótóka arsümülüm? ");
INSERT INTO tof_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kingan ne arüng bidame, sab oyakagab kokean aupe, kingan tupuru sab metat oya tangdó yarile, kókó wa sab tame, kingan arüng noakame; Blaman pamkolpama sab oya bóktan arrkrru kwarile. ");
INSERT INTO tof_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Zuda tóba ⌊donki⌋ sab sye amele ⌊grreip⌋ syepordó, tóba donki kupo sab sye amele amkoman morroalan grreip syepordó. Wa tóba mórrkenyórr sab waendó bagulóle; oya kokrrapan mórrkenyórr sab óe-óe grreip more bagulóle. ");
INSERT INTO tof_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oya ilküp nisa sab urzan baini waen anónde, akó oya zirrgüpa sab gabülpli bairre kau mor anónde. ");
INSERT INTO tof_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun sab malu minggüpanandó ngyabene, akó oya malu kabe sab morroal but aren gagat yarile. Oya tüp ngarkwata sab wame kókóta Saedon wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakarr wa donkizan arüng pama, tóba mobobdó ne alóp nis ódódda, we kandó ngón ngagónda. ");
INSERT INTO tof_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Wa sab tóba morroal ngón bagón bwób nóma esene, akó tüp wa ia morroala, wa sab arrngürre tóba müp ódódóm, akó wa sab leba zaget yarile ngibürr pamkolpamabkü. ");
INSERT INTO tof_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan sab tóba pamkolpam nolngomólnórre zazzan. I sab inzan kwarile, wamaka ngibürr Isrrael zitülzan. ");
INSERT INTO tof_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan sab gwarzan yarile kwat kabedó, wa büdülngalzan yarile, nótó utóda kwat minggüpanandó, ⌊osan⌋ wakub sab nótó arite. Ene igósidi, ene osa tang nis sab kwit nine, da ne pam yarile osan mórr kwitüdü, sab kakota aupe. ");
INSERT INTO tof_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“⌊Lodóe⌋, ka zid bainüm marü mókyala! ");
INSERT INTO tof_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gadón sab molpokodó agóltagól gómól pama anin korale; a wa ma sab ibü wirri arüngi kolatale tóba tüpdügab. ");
INSERT INTO tof_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asyerran tüpdügab sab morroal mórrela tamle, akó wa sab morroal misan alo nüliónórre ngibürr king. ");
INSERT INTO tof_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali wa diazan agólda tebe püóran, morroal kupo nótó basenda. ");
INSERT INTO tof_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Zosep wa küppükü syeporzana arób kabedó. Oya syepor soloa gri malmandasko. ");
INSERT INTO tof_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gazirr pama tibiób bügür kyabe gazirrüm ngürsilpükü togobórr. I bügür numrrutóp kyab amanóm oyaka, oya alzizi amanikdi. ");
INSERT INTO tof_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","A oya bügür kyaba pam dümdüm amanine, akó Zeikobón Arüng Goda oya tang nis arüng nókyene, oya ngabkan pam nótóke, ingülküpzan nótóke Zeikobón adlangóm. ");
INSERT INTO tof_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Marü aban God marü sab tangmamtine. Ene Wirrian Arüng God marü sab bles mine, wa sab kwitüdügabi marü ngupi bles mine, wa marü tüpdügabi ne naea tótókda, we klame bles mine, akó wa marü abün olmale bles mine, akó abün ngabyón lare. ");
INSERT INTO tof_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Marü aba ne morroal akyanda, wa wirriana. Ngaep wirri pododógab ne morroala tótókda, wa karia oyakagab, ngaep kari pododógab ne mórrela tótókda, wa karia oyakagab. Blaman ene ne morroal kla, Zosepón tangdó ki kwarilün. Wa tüób tebe-tebe amanikürrüna tóba zonaretaldógabi, ibü balngomólóm. ");
INSERT INTO tof_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benzamin wa wirri nurr umezan ngürsil pama. Irrbi wa su akrranda akó almitóda, akó simam wa gómól-gómól azebórrón elklaza arrgrratóda.” ");
INSERT INTO tof_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ene Isrrael pamkolpamab blaman 12 zitül kwarilürr. Ibü aban bóktan we kla kwarilürr, wa ibü dómdóm poko nóma nülinóp; wa blaman darrpan-darrpan tóba simanal olmal tibi-tibi dómdóm ngyaben bóktan nüliónónóp. ");
INSERT INTO tof_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Zeikob tóba simanal olmal arüng bóktan we nókyenóp wagó, “Ka kólba abalbobatal basen kari pokola. E sab kürü ene kugupi apórrón wirri ingülküpdü gapókdó küngrinamke, kürü abalbobatala nóla utódako. Ene gapók Makpela tüp pokodómase, abüsa nólgabi banikda Mamrre bwóbdügab, Keinan tüpdü. Eibrra-am ene ingülküpdü gapók akó tüp poko darrpan münüm nümiógürr Eprronkagab, Et pam nótó yarilürr, tibiób büdül arrbünüm. ");
INSERT INTO tof_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ene kugupi apórrón wirri ingülküpdü gapókdó Eibrra-am akó tóba kol Serra we nüngrinóp. Aesak akó tóba kol Rrebeka ta we nüngrinóp, akó Lian ta ka küób ola ungrirrü. ");
INSERT INTO tof_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ene ne tüp poko akó ingülküpdü gapók kürü bobata Eibrra-am wató nümiógürr Et pamkolpamdógab.” ");
INSERT INTO tof_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Zeikobón dómdóm ikik bókrran bóktana nóma blakónórr tóba olmaldó, wa tóba ut bwóbdü we umtulürr ó dómdóm ngón semanórr, da we nurrótókórr. Da wa tóba abalbobatal nómrrónóp, ngaen nidi nurrbarinóp. ");
INSERT INTO tof_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Zosep tóba aban büb amiógürr da yón yarilürr, akó oya obzek iprükürr. ");
INSERT INTO tof_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Zosep tóba zaget pam, dokta nidi kwarilürr, we nilóp, oya ab morroal ilang klame püti ainüm akó mórrkenyórr poko-e arrgótanóm, sab gapókdó angrinüm. Da zaget pama Zeikobón büb muru morroal we tónggapónóp. ");
INSERT INTO tof_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","40 ngürr yazebóp ene pokodó. Ugón ene tonarr, barrkyan ngarkwat ipadórr büb angrinüm gapókdó. Izipt pamkolpama 70 ngürr yazebóp oya yón amtom. ");
INSERT INTO tof_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yón amtoa nóma blakónórr, Zosep bóktanórr parraoan wirri ngi pamdó wagó, “E yabiób obzek kwata kürüka ne morroal nóma sesenane, ini bóktan idüdam parraodó kürünkü: ");
INSERT INTO tof_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kürü aba ini ⌊arüng alkamül-koke bóktanpükü⌋ kimgatórr wagó, ‘Tübarrkrru, ka büdül kari pokola. Ka küób ne gapók tónggapórró ingülküp kugupidü kólbankü, Keinan tüpdü, da sab kürü ola küngrinamke.’ Ka kya wamón kólba ab gapókdó angrinüm. Ka akó sab tolkomolo.” ");
INSERT INTO tof_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Parraoa bóktan yalkomólórr wagó, “Taia, ugó wam moba ab gapókdó angrinüm, wa ne arüng alkamül-koke bóktan amgatórr marüka!” ");
INSERT INTO tof_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Da Zosep we wamórr tóba ab angrinüm. Wankü idi ogobórr: blaman parraoan ngi pam, oya müótüdü balngomól byarrmarr pam, akó blaman balngomól byarrmarr pam Izipt kantrridügab. ");
INSERT INTO tof_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Zosepón müótüdü nidi kwarilürr, tóba blaman zonaretal akó oya aban müótüdü ne kolpam kwarilürr, ta wankü ogobórr. I wata we kla bimgütóp Gosyen tüpdü: tibiób kari olmalpókal, ⌊sip⌋ a ⌊gout⌋, akó ⌊kau⌋. ");
INSERT INTO tof_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Dokyanan pama oya elngomólóp, ⌊osab amorrat kla⌋ nidi alngomól kwarilürr akó ⌊osab⌋ bübdü nidi mórran kwarilürr. Ene wirri ngoro yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Blamana ogobórr kókó ⌊wit⌋ küp aus bwóbdü, ngi Atad, Zodan tobarr dakla dorro. I ola arrat-arrat yón kwarilürr. Zosep wata amkoman yón-gyaurdü yarilürr tóba abankwata 7 ngürrüm. ");
INSERT INTO tof_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Keinan pamkolpama, ola nidi ngyabenónóp ene tüpdü, nóma esenóp pamkolpam yón-gyaurdi Atadóm, i bóktónóp wagó, “Ini amkoman wirrian yón-gyaura Izipt kolpamabkü!” Da ene bwób ngi we ngyesilóp Eibel Mizrra-im, Zodan tobarr dakla dorrodó. ");
INSERT INTO tof_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Zeikobón olmala oya bóktan ipüdóp wa enezan yarilürr: ");
INSERT INTO tof_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","i oya büdül büb muru we idüdóp Keinan tüpdü, da oya ene kugupi apórrón wirri ingülküpdü gapókdó we ingrinóp Makpela tüp pokodó, abüsa nólgabi banikda Mamrre bwóbdügab. Eibrra-am ene tüp poko amiógürr darrü Et pamdógab ngi Eprron, tibiób büdül arrbünüm. ");
INSERT INTO tof_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Wa tóba ab gapókdó nóma ingrinürr, Zosep we alkomólórr Izipt, tóba zonaretalpükü akó blaman nidi ogobórr wankü tóba ab gapókdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Zosepón naretala nóma esenóp wagó, ibü ab büdüla, i tibióbka ola bóktanónóp wagó, “Zosep sab mibü kena alzizi sema, akó darrü gyagüpitótóka kena simióg mibü darrem kolae akonóm, mi oyaka ne kolae tómbapónóp.” ");
INSERT INTO tof_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Da i bóktan zirrapónóp Zosepka igó poko wagó, “Kibü aba solkwat nurrótókórr, a ngaen-gógópan kibü arüng bóktan tókyenóp wagó, ");
INSERT INTO tof_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘E bóktónamke Zosepka, “Gyaurka, ma moba naretalab kolae tonarr barrgo, i ne kolae poko tónggapónóp marüka.” ’ Errkya ma kibü ini kolae tonarr ugó torrgonónóm, ki ne kolae tónggapónóp marüka, marü aban Godón zaget pam.” Zosep yón sabinürr wa ene bóktan nóma arrkrrurr. ");
INSERT INTO tof_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Oya naretala togobórr, tüp balókórr oya obzek kwata, da bóktanónóp wagó, “Turrkrru, ki errkya marü ⌊leba zaget⌋ pamakla!” ");
INSERT INTO tof_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Da Zosep bóktanórr ibüka wagó, “E gumgu! Ka Godón ngarkwatódó kokela! ");
INSERT INTO tof_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","E bóktan tónggapónarre kolae poko tónggapónóm kürüka. A God ama ene kolae morroalóm yónürr: wa errkya abün pamkolpamab arról akonda, ngaen-gógópan ne tonarra tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Da e gumgu! Ka sab yabü ngabkalo akó yabü olmal.” Da wa ibü morroal bóktan nókyenóp, da ibü moboküp ta namurróp. ");
INSERT INTO tof_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","23","Zosep Iziptüm ngyabelórr tóba aban kolpampükü. Wa wirri kokrrap ngarkwatzan ngyabelórr, wa Iprra-imün olmalbobatal nósenóp. Akó Manasen siman olom Makirr, oya olmal ta we nósenóp. Wa Makirrón olmal bagürwómpükü simarrurr tóbaka. Wa 110 pail nóma emrralórr, oya büdül karipoko yarilürr. ");
INSERT INTO tof_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Zosep bóktanórr tóba zonaretaldó wagó, “Ka büdül kari pokola. A God sab yabü wató tangnamtirre wa sab yabü yakone ini tüpdügab ama yabiób tüpdü, wa ne arüng alkamül-koke bóktan nókyenóp Eibrra-amón, Aesak, akó Zeikob.” ");
INSERT INTO tof_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Da Zosepón ubi Zeikobón olmal arüng alkamül-koke bóktan akyanóm yarilürr. Wa bóktanórr wagó, “God sab yabü wató tangnamtinórre, ó e sab kürü kuspükü yakonamke algabi.” ");
INSERT INTO tof_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Zosepón büdüla ugón simiógürr, 110 pail nóma yarilürr. I oya büb morroal ilang klame püti inóp akó mórrkenyórr poko-e errgótónóp, da oya ingrinóp ingülküp kobendó Iziptüm. Bwób Zitül Peba aini blakónda. ");
INSERT INTO tof_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Da ⌊Lod⌋ bóktanórr Moseska wagó, “Ka zirrapóndóla dómdóm darrpan kolae bain kla parraodó akó Izipt pamkolpamdó. Ene kakóm, wa yabü sab ok nirre tótókóm algab. Wa sab yabü nóma ok nirre tótókóm, wa sab yabü blaman tai amkoman amóne algab, metatómpükü. ");
INSERT INTO tof_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Errkyadan bóktanke Isrrael pamkolpamdó magó, ‘E blamana nümtinamke Izipt kolpam, yabü minggüpanan nidi ngyabendako, ⌊golde⌋ akó ⌊silba-e⌋ tómbapórrón elklazam.’” ");
INSERT INTO tof_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Da Lod Izipt pamkolpam morroal gyagüpitótók nókyenóp, igósüm i morroal esenóp Isrrael pamkolpamdó tibiób obzek kwata. Anda, parraoan zaget pam akó blaman Izipt kolpama Mosesón igó ngakanónóp wagó, wa kari wirri ngi pam kokea. ");
INSERT INTO tof_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Da Moses bóktanórr wagó, “Lod inzan yaril wa, ‘Irrüb zokrrok, ka kalma wamlo blaman Izipt kantrri kugupidüma. ");
INSERT INTO tof_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Da blaman ngaensingül babótórrón simanal olmala kalma nurrbarine, tai parraoan ngaensingül siman olomdógab, sab solkwat aban mórran pabodó nótó mórróne, kókó ⌊leba zaget⌋ ngulmokuran ngaensingül siman olomdó, enan wirri zaget nótó tómbapóndo ⌊wit⌋ küp zaze amgünüm. Ngabyón larab ngaensingül babótórrón simanala ta inzan nurrbarine. ");
INSERT INTO tof_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Sab wirri yón gyaur yarile blaman Izipt kantrridü. Ngaen inzan wirri yón gyaur babul yarilürr ó myamem babul yarile ene kakóm. ");
INSERT INTO tof_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","A darrü kolaea sab kokean tómbapóne Isrrael pamkolpamdó akó ibü ngabyón elklazadó. Da e sab umul bainane igó, ka, Lod, Isrrael pamkolpam darrpan tonarre koke ngabkandóla, Izipt pamkolpamdógab.’” ");
INSERT INTO tof_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","⌊Lod⌋ bóktanórr Moses akó Erron, ibüka Izipt kantrridü wagó, ");
INSERT INTO tof_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ini melpal, sab metat wata yabü blamanabkü ngaen-gógópan melpal yarile, blaman pailzan. ");
INSERT INTO tof_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nüzazilamke blaman Isrrael basirr pamkolpam magó, ini 10 ngim ngürrdü, ini melpal, pama darrpan-darrpan ⌊sip⌋ kupo ó ta ia ⌊gout⌋ kupo tibiób olmalkolabkü ki yazebnóm, darrpan-darrpan müótankü. ");
INSERT INTO tof_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","A oya olmalkol ne abün koke nóma kwarile ene dudu lar alóngóm, wató akó oya minggüpanan müótüdü ne pame, ene lar usakü arrgrrüti. Da wata we ngarkwatódó syórr yangórre, i ne ngarkwat olmalkolako, akó darrpan-darrpana ne ngarkwatódó elóngórre. ");
INSERT INTO tof_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Da i wata darrpan pail sip kupo ó ta ia gout kupo simanal korale, gülüng akó gao koke. ");
INSERT INTO tof_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Da morroal ngabkan koralónke kókó 14 ngim ngürr ini melpal. Blaman Isrrael basirr pamkolpama ene lar ugón ki okrralón, irrüba küp nóma sirrbüle. ");
INSERT INTO tof_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Da pamkolpama ngibürr óe ki yazebnóm da mamtae talkum ki nóngangonóm akó kwitana mamtae nugup, i ene lar ne müótüdü elóngórre. ");
INSERT INTO tof_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ene dadan irrüb, i ene lar murr ki bamngulnüm birrdü, da ki elóngnóm kapan bókónpükü akó ist-koke bamngulürrün brredpükü. ");
INSERT INTO tof_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Lar murr alónggu kókres akó urur nae bamngulürrün, a wata dudu birrdü bamngulürrün, singülpükü, wapórpükü, akó aumana büb kugupidü murrpükü. ");
INSERT INTO tof_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ngibürr murr arrbün-gu sab irrbim; ngibürr murra ne nóma bamirre, da urdü yamselamke. ");
INSERT INTO tof_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Da e inzan elóngamke: yabiób tumum mórrkenyórr belte barümürrün, yabiób wapór kla bamelórrón, akó tupuru tangdó korale. Büsai-büsai elóngamke, ene Lodón Büdül Kórzyón Tóre-e. ");
INSERT INTO tof_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Ene dadan irrüb, ka blaman Izipt kantrri sab ugón arrgrrat namulo, dakla akrrankü blaman ngaensingül babótórrón simanal olmal, pamkolpam akó ngabyón lar. Ka ta blaman Izipt god sab zaz ninünümo. Ka Lodla. ");
INSERT INTO tof_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Da óe igó timama, müót bómzyatóm e ne ngyabendakla. Ka óe nóma nósenónómo yabü müótüdü, ka sab kwitana bórrgrrat namulo, da darrü büdülan kolae bain klama yabü koke namurrórre, ka ne Izipt pamkolpam wirri azid aeng nóma nókyenónómo. ");
INSERT INTO tof_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","E wata metat gyagüpi amanik koralónke ini ngürr, akó e ini ngürr tórezan amanik koralónke Lodónkü. Ene metat ódód gida-a.” ");
INSERT INTO tof_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Lod bóktanórr wagó, “7 Ngürr kugupidü, e sab istpükü aungürrün brred alogu; wata ist-koke brred ololónke. Ngaen-gógópan ngürrdü, e blaman ist amónamke yabiób müótüdügab. Darrü oloma ene 7 ngürrdi istpükü aungürrün brred nótó nóma elo-e, oya sab metatómpükü zirrapórre Isrrael pamkolpamdógab. ");
INSERT INTO tof_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ngaen-gógópan ngürr akó 7 ngim ngürrdü, e kwób bazen koralónke kürü ⌊ótókóm⌋. Darrü zaget tónggapón-gu ene nis ngürr kugupidü, a wa taia ene ngürrankü ngarkwatódó alo kla tómbapónóm blamanab alom. ");
INSERT INTO tof_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","E amanik koralónke Ist-koke Brred Tóre, zitül ka ini ngürrdü simarrurrü yabü Isrrael zitül pamkolpam Iziptgab. Amanik koralónke ini Tóre, zitülkus ini bóktan sab metat mumyamón bóktana, yabükagab solkwat ne olmalbobatala tóbabótóle.” ");
INSERT INTO tof_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Irrüb zokrrok, Lod ngaensingül simanal olmal ugón ekrranórr Izipt kantrridü, tai parraoan ngaensingül siman olomdógab, sab solkwat aban mórran pabodó nótó mórróne, kókó tümün müótüdü pamab ngaensingül simanal olmaldó. Akó blaman ngabyón larab ngaensingül simanal kupo ta inzan ekrranórr. ");
INSERT INTO tof_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ene irrüb parrao, oya zaget pam, akó blaman Izipt kolpama ugón tübarsinürr. Da kari yón taegwarr koke yarilürr blaman Izipt kantrridü, zitülkus ola darrü popa müót babul yarilürr, a blaman wata büdülpükü müót kwarilürr. ");
INSERT INTO tof_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ene dadan irrüb, parraoa Moses akó Erron ibü nginaunürr tóbaka, da bóktanórr wagó, “Bazeb! Kürü pamkolpam elókam, yadipa akó Isrrael pamkolpam! Ogob ótókóm Lodón, e enezan kümtirri kürü. ");
INSERT INTO tof_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","E yabiób sip a gout akó ⌊kau⌋ yazebam da ogob! Da e dakla kürünkü tóre bako kwarilünke kürü ngyaben morroal ainüm.” ");
INSERT INTO tof_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Izipt pamkolpama wirri arüngi nilóp Isrrael pamkolpama büsai-büsai bazebóm ibü kantrri amgatóm. I bóktónóp wagó, “Ki kubó blamana kena nurrbarinünüm, e ne koke nóma bazebo!” ");
INSERT INTO tof_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isrrael pamkolpama we bazebórr wapórane Rrameses wirri basirrdügab ama Sukot wirri basirrdü. I aprrapórr 600,000 pam koralórr; kol akó olmal koke etóngóp, i nisakü bazebórr. ");
INSERT INTO tof_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Akó abün mogob pamkolpam akó abün sip a gout yabül akó kau yabüla ta inzan bazebórr usakü. ");
INSERT INTO tof_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","I Iziptgab ne kókres plaoa barrmülürr, i kwat-kwat ist-koke pólan brred bamngulóp. Ene plaoa ist-koke yarilürr, zitülkus ibü Iziptgab wata büsai-büsai zirrnapónóp. Ibü gaodó ngarkwat koke yarilürr Iziptüm, kwat-kwat alom alo kla bamngulüm akó istpükü plaoa azebóm ene tonarr. ");
INSERT INTO tof_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isrrael pamkolpama Iziptüm 430 pailüm ngyabenónóp. ");
INSERT INTO tof_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Izipt kinga igó nóma izazilóp wagó, Isrrael pamkolpama kuri busurre, wató akó oya zaget pama tibiób gyagüpitótók we nalüngóp, da bóktónóp wagó, “Mi ini gonggo poko iade tónggapónóp? Mi ta Isrrael ⌊leba zaget⌋ pamkolpam ok ninóp tótókóm, da i tibiób zaget kuri nümgütrre!” ");
INSERT INTO tof_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Da wa tóba ⌊osab amorrat kla⌋ we tómbapónórr, da tóba gazirr pam we yazebórr ibü solkwat atanóm. ");
INSERT INTO tof_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Da wa yazebórr tóbanan 600 morroalan gazirr osab amorrat kla, akó blaman Izipt gazirr osab amorrat kla, tibiób ngabkan wirri gazirr pampükü. ");
INSERT INTO tof_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","⌊Lod⌋ parraoan gyagüp kolaean ngitanórr, Izipt king, da wa igósidi akyanórr Isrrael pamkolpamab solkwat ibü akonóm, nidi ogoblórr gum-koke. ");
INSERT INTO tof_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Izipt gazirr pam, blaman parraoan ⌊os⌋ akó oya osab amorrat kla akó oya os amarru pama zutalórr da nómrrónóp, i ne bamilürr Óe-óe Malu kabedó, Pi Akirrot wirri basirr minggüpanan, Barr Zepon wirri basirr dakla kabedó. ");
INSERT INTO tof_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Parraoa tóba gazirr pampükü ngorram nóma nyónónóp, Isrrael pamkolpama ugón sazilóp kakota. Da i parrao esenóp tóba gazirr pampükü ibü solkwat akyande, ibü wirri guma yazebórr, da wirribóka we taegwarr apónóp Lodka tibiób tangbamtinüm. ");
INSERT INTO tof_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","I Moseska bóktónóp wagó, “Ma kibü Iziptgabi büdülüm iade simarrua ⌊ngüin-koke bwóbdü⌋? Ia ene zitülkusdü, gapók balüng bwób babula Iziptüm? Ma ia kuri esena, ma kibüka ne kla tónggapórró? Ma kibü iade simarrua Iziptgab? ");
INSERT INTO tof_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ki ia marüka ngaen-gógópan koke bóktónóp Iziptüm wagó, inzan pokoa sab aprrapórr tómbapóne mibü amgat kakóm? Ene amkoman: ki marü milóp wa, ‘Ma kibü selók, a ki leba zaget inzan tómbapón ki kwarila Izipt pamkolpamabkü.’ Ene wa kari morroal koke ki yaril leba zagetóm ola, a büdülüm koke, aini ngüin-koke bwóbdü.” ");
INSERT INTO tof_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses ibüka bóktan yalkomólórr wagó, “E gumüm bain-gu. Wata zürük inzan bórrang. E kubó esenane, Lod kubó laró tónggapóne yabü zid bainüm errkya; e sab myamem ini Izipt pam kokean nósenane akó. ");
INSERT INTO tof_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Lod yabünkü kubó wató gazirr yarile, a e wata piküp kwarilo.” ");
INSERT INTO tof_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Da Lod Moseska bóktanórr wagó, “Ma kürüka iade górrgandóla tangbamtinüm? Isrrael pamkolpam nilnüm tótókóm singül kwata! ");
INSERT INTO tof_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Moba tupuru kwit yó, da tang adrrat maludü nae nis ór angónóm. Ene igósüm, Isrrael pamkolpama mólóg tüpana wapórane iade baurre, we malu ór angórrón kandóma. ");
INSERT INTO tof_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ka kubó Izipt pamab gyagüp kolaean ngintinünümo, igósüm i kubó zutale ibü solkwat. Ka kólba ngi iade wirri kwit emgnyelo, ka amkoman nóma ekrrono parrao akó oya gazirr pam, oya osab amorrat klampükü, akó oya os amarru pampükü. ");
INSERT INTO tof_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ka ne kubó ibü memokan nóma ut-ut ninünümo, ka kólba ngi igósidi wirri kwit emngyelo, da Izipt pamkolpama kubó iade umul bairre wa, ka Lodla!” ");
INSERT INTO tof_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","20","⌊Godón anerrua⌋, nótó wamlórr Isrrael pamkolpamab singül kwata, ama tolkomólórr ibü kakota, ibü solodó akyanóm. Talkumzan zamngórrón pülpül pokoa ta inzan tolkomólórr singül kwatagab, da ama kakota trramngólórr, Isrrael pamkolpam akó Izipt gazirr pamab aodó. Ene dudu irrüb, pülpül pokoa algón-koke tümün singrinürr Izipt gazirr pamdó, a zyón ma Isrrael pamkolpam nókyenóp. Da ene we zitülkusdü, Isrrael akó Izipt pamkolpama tibiób minggüpanan koke igósidi togobórr obzek basenóm ene dudu irrüb. ");
INSERT INTO tof_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses tóba tang adrratórr maludü, da ene dudu irrüb Lod malu nae ugón nis ór yangónórr wirri arüng zibórr wóri, ama imzazilürr mólóg tüpüm. Da malua ene inzan batülürr. ");
INSERT INTO tof_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isrrael pamkolpama we ogoblórr maluana, mólóg tüpdüma, nae aodó ne nürrgrratórr, amaka griamli nizan kwata. ");
INSERT INTO tof_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Izipt gazirr pam, blaman parraoan os, oya osab amorrat kla, akó oya os amarru pama ibü solkwat we zutalórr mólóg tüpdüma, malu aodó ne itilürr. ");
INSERT INTO tof_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Sisa anin minggüpanan, Lod ugón sazilürr kwitümgab, ene ur ulitpükü talkumzan zamngórrón pülpül pokodógab, Izipt gazirr pamdó, da ibü gyagüpitótók blaman gonggo ninóp. ");
INSERT INTO tof_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Wa ibü osab amorrat klamab wil barüm-barüman ngintinóp, da ibü busom kari müp koke yarilürr. Izipt gazirr pama bóktónóp wagó, “Lod gazirrda minkü Isrrael pamkolpamab ngidü! Mi ibükagab gum busurre!” ");
INSERT INTO tof_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Lod Moseska bóktanórr wagó, “Moba tang adrrat maludü, da naea kubó ugón tolkomóle Izipt gazirr pam akó ibü osab amorrat kla akó ibü os amarru pam ngablaom.” ");
INSERT INTO tof_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Da Moses tóba tang we adrratórr maludü. Sisa nóma tunilürr, naea ugón tolkomólórr tóba gaodó. Izipt gazirr pama enan kainónóp busom naedógab, a Lod ibü maludü büdülümpükü we nae nitóp. ");
INSERT INTO tof_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Naea tolkomólórr, da nganolop blaman osab amorrat kla, os amarru pam, akó blaman Izipt gazirr pam, nidi zutalórr Isrrael pamkolpamdó maludü. Darrü oloma myamem kokean twadürükürr. ");
INSERT INTO tof_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Isrrael pamkolpama Lodón wirri arüng nóma esenóp, wa ne tórrmen okaka imzazilürr Izipt gazirr pamdó, i kari gum koke ipüdóp, da i tibiób moboküpi amkoman bangun blamana we irrbünóp Lodka akó tóba zaget pam Moseska. ");
INSERT INTO tof_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","God bóktanórr blaman ini bóktan opor wagó, ");
INSERT INTO tof_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ka ⌊Lodla⌋, yabü God, yabü nótó simarrurrü Iziptgab, e ⌊leba zaget⌋ nóla tómbapónarre. ");
INSERT INTO tof_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ma myamem darrü god ⌊ótókgu⌋, a wata kótó. ");
INSERT INTO tof_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ma darrü dandang tónggapón-gu mobankü, ia kla pülpüldü, tüpdü, ó aumana naedó, tüp lorodó. ");
INSERT INTO tof_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Singül tüp alókgu darrü dandangdó ó ótókgu ene kla, zitülkus ka Lodla, yabü God, akó ka gyagüp kolaea amkal Godla. Ka ibü olmalbobatal ⌊kolaean darrem⌋ alióndóla, kürü nibiób abala alzizi amanikdako, tai ibü olmaldógab kókó aüd ó tokom lüól olmalbobataldó, ibü abalab kolae tonarranme. ");
INSERT INTO tof_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","A ka kólba morroal tonarr okaka amzazildóla atang-koke olmalbobataldó, nibiób ⌊moboküpdü ubi⌋ kürükama akó kürü gida bóktan poko nidi mamoandako. ");
INSERT INTO tof_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ma kürü ngi zitül-koke pokodó ngilian-gu. Ka Lodla, marü God, ka sab darrü olom kolaean darrem ekyeno, kürü ngi zitül-koke pokodó ngiliande. ");
INSERT INTO tof_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“⌊Sabad⌋ ngürr gyagüpi amaniklónke. Ma kürü gyabi ngürr ótók namülünke. ");
INSERT INTO tof_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Marü wata 6 ngürrako, ma ne ngürrdi zaget namulo, ");
INSERT INTO tof_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","a 7 ngim ngürr wata ngón agón ngürra, ene wa Lodón ngürre, marü God nótóke. Ene ngürrdü darrü oloma zaget koke tónggapóne, mató, marü siman olom, marü óp olom, marü leba zaget pam akó kol, marü ngabyón lar, akó darrü mogob oloma nótó ngyabenda marü bwóbdü. ");
INSERT INTO tof_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","6 Ngürr kugupidü, kótó, Lod nótókla, tómbapórró tüp, pülpül, malu, akó blaman ne elklazako ibü kugupidü. A ka Sabad ngürrdü ngón agórró. Da ene ngürr ka, Lod nótókla, we zitülkusdü bles yórrü akó tebe-tebe amanikürrü. ");
INSERT INTO tof_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Ma moba aipab nis morroal angón namülün; igósüm ma sab wirri kokrrap ngyabelo ini tüpdü, ka Lod, marü God nótókla, ne tüp akyanóm kaindóla. ");
INSERT INTO tof_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Ma darrü olom büdülümpükü amkalgu. ");
INSERT INTO tof_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Ma kol ó pam gómólgu. ");
INSERT INTO tof_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Ma gómólgu. ");
INSERT INTO tof_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Ma obae tiz bóktane darrü olom kulain-gu. ");
INSERT INTO tof_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Marü ubi darrü oloman müótüdü babul ki yarilün. Marü ubi ta babul ki yarilün oya koldó, oya leba zaget pam akó koldó, oya ⌊kau⌋ ó ⌊donkidü⌋, akó darrü klamdó oya ne klame.” ");
INSERT INTO tof_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","2","⌊Lod⌋ Mosesón ngisilianórr da tóbtanórr oyaka tóba kwóbbazen ⌊Palae Müótüdügab⌋, da oya ini gida bóktan poko iliónürr wagó, “Bóktanke Isrrael pamkolpamdó magó, ‘Darrüpa yabükagab darrü gyaur kla nóma sidüde Lodka, da wa wata ngabyón lardógab sidüde, ia ⌊kau⌋, ta ia ⌊sip⌋, ó ta ia ⌊gout⌋. ");
INSERT INTO tof_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Wa ne kau nóma sidüde dudu bóngan gyaur klamzan, da wata wa siman kau yarile, darrü gülüng akó gao koke. Wa wata ekyene kwóbbazen Palae Müótan barrbün mamtaedó, igósüm Lod ipüde wa ne kla akyanda. ");
INSERT INTO tof_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Wa tóba tang ene laran singüldü emngyele, igósüm Lod ubi baine ene dudu bóngan gyaur kla apadóm. Ene klama oya gódam yangune Lodkü. ");
INSERT INTO tof_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ma emkolo ene siman kau ola, Lodón obzek kwata, da Erronón simanal olmalbobatala, ⌊prrist⌋ nidipako, óe Lodón ilirre, da i óe-e nangrre Godón ⌊altan⌋ blaman tokom kabe. Ene ne alta-e, kwóbbazen Palae Müótan barrbün mamtae minggüpanana. ");
INSERT INTO tof_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Da ma ene lar sopae azebo, da akó edabono kari syórr. ");
INSERT INTO tof_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Prrista ur yazebrre, kumarümórre alta kwitüdü, da seterre. ");
INSERT INTO tof_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","I ene lar murr syórr angórrón kla singül akó olgolpükü yamserre. ");
INSERT INTO tof_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Da ma wata aumana okómóp akó wapór igulo nae-e. Prrista nótó zagetóda ene ngürrdü, wa bamngule dudu, altadó. Ene dudu bóngan gyaur klama. Da ene uri aungürrün laran morroal ilanga Lodón bagürwóman ngitine.’” ");
INSERT INTO tof_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","⌊Lod⌋ Moses akó Erron ini bóktan nüliónürr Isrrael pamkolpama mamoanóm. ");
INSERT INTO tof_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Darrü oloman soso, misarr, ó baeb sopae nóma yarile, da ama aprrapórr baurr-baurr sopae azidüm bairre, oya ki idüdnüm Erronón zitül pamdó, prrist nótóke. ");
INSERT INTO tof_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Prrista ene poko oya büb sopae kodalande ngakóne. Büb ngüina ne baeb nóma bairre ene pokodó, akó ene gülüng kukurru nóma yarile sopaedógab, da ene amkoman baurr-baurr sopae azida. Ene kakóm, prrista pupaine pamkolpamab umulüm wagó, ini olom ⌊tómanpüküma⌋ Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","⌊Lod⌋ Mosesón yalórr Isrrael pamkolpamdó bóktanóm wagó, “Darrü Isrrael Müótüdü olom ó mogob oloma, nótó ngyabenda yenkü, nóma elónge óepükü lar murr, ka sab kólba obzek yalüngo oyakagab akó oya sab metatómpükü zirrapono oya pamkolpamdógab. ");
INSERT INTO tof_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Zitülkus módóga, blaman ngyaben elklazab arról óedóma, da ka arüng bóktan ingrirrü óe ⌊altadó⌋ akanóm yabü kolae tonarr arrgonóm da ugósüm Godkü gódam bangunüm, zitülkus ene óea kolae tonarr arrgonda arróldóma.” ");
INSERT INTO tof_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","⌊Lod⌋ bóktanórr Moseska wagó, ");
INSERT INTO tof_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Bóktanke blaman Isrrael pamkolpamdó magó, ‘E wata kolkal ngyaben kwarilo, zitülkus ka Lod yabü God kolkal ngyabendóla. ");
INSERT INTO tof_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘Moba moboküpdü alzizi boman gyagüpitótók ódódgu darrü Isrrael olomankwata, a ma oya ago da wa dümdüm iade baine. Ene igósüm, ma oya kolae tonarrdó koke barümo. ");
INSERT INTO tof_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ma darrem tónggapón-gu darrü Isrrael olomdó akó metat alzizi amanikgu, a ma marü ⌊moboküpdü ubi⌋ moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane. Ka Lodla.’” ");
INSERT INTO tof_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","⌊Lod⌋ bóktanórr Moseska wagó, ");
INSERT INTO tof_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Bóktanke Isrrael pamkolpamdó magó, ‘Yabü darrü olom akó darrü mogob oloma, nótó ngyabenda yenkü, sab tóba olom nótó ekyene, obae god Molekón ⌊ótókóm⌋, oya sab blaman Isrrael pamkolpama ingülküpi ki arenónóm oya büdüldü angrinüm. ");
INSERT INTO tof_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘Darrü oloma ne sab nóma wame bóktan arrkrrum büdül mórrkepükü ne pamkolpama ikikdako, ó samudügabi nidi umul baindako solkwat ne tonarra tómbapónórre, ka sab kólba obzek yalüngo oyakagab akó oya sab metatómpükü zirrapono tóba pamkolpamdógab.’” ");
INSERT INTO tof_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Darrüpa paman nóma emkóle gaopükü, wa ne kla tónggapóne, akó darrem tónggapórre oyaka. ");
INSERT INTO tof_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Wa paman kus nóma alkamüle, oya kus akó darrem alkamürre. Wa paman ilküp nóma irrune, oya ilküp akó darrem irrurre. Wa paman zirrgüp nóma alkamüle, oya zirrgüp akó darrem alkamürre. Wa paman nóma emkóle gaopükü, i ta darrem inzan emkórre gaopükü. ");
INSERT INTO tof_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Ngabyón lar ne nótó emkóle büdülümpükü, wa darrü lar akó darrem yalkomóle, a pam ne nótó emkóle, oya darrem emkórre büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ini ne gida bóktan poko-e yabü blaman ngablaoda, Isrrael pamkolpam akó mogob pamkolpam, nidi ngyabendako yenkü, zitülkus ka ⌊Lodla⌋ yabü God.” ");
INSERT INTO tof_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isrrael pamkolpama Orr podo amgütóp, we ogoblórr Óe-óe Maludübóna, Idom kantrri kórzyónüm. Da módóga, pamkolpam genggorrama yazebórr kwat-kwat. ");
INSERT INTO tof_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Da i wirri taem we inóp. I dakla Godka bóktan aman koralórr, dakla Moseska wagó, “Ia e kibü Iziptgabi iade syusürri ini ⌊ngüin-koke bwóbdü⌋ nurrbarinüm? Aini alo kla babul akó nae ta babul, a kibü genggorrama kuri sazebe ini kolae alo kla alode!” ");
INSERT INTO tof_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Da ⌊Lod⌋ büdül tarük balóng gwar ibüka we zirrtapónóp. I Isrrael pamkolpam nólóngnóp, da abüna igósidi nurrbarinónóp. ");
INSERT INTO tof_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Módóga, pamkolpama Moseska we togobórr da oyaka we bóktónóp wagó, “Ki kolae tonarr tónggapórre, ne bóktan amórre Lodka akó marüka. Gyaurka, ma kya tóre eko, kubó Lod ini gwar ia zirrnapórre kibükagab.” Da Moses ene pamkolpamabkü tóre we ekorr. ");
INSERT INTO tof_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Lod Moseska we bóktanórr wagó, “Balóng Gwar tónggapó brronze, da kokrrapan nugup pokodó errgóta, da nibiób nólóngórre, kubó ki ngakónónóm. I sab igósidi ngyaberre.” ");
INSERT INTO tof_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Da Moses brronze gwar we tónggapónórr, da we emngyelórr nugup pokodó. Gwara nibiób nólóngórre, da nóma yazilóp brronze tónggapórrón gwardó, i dólóng bainóp. ");
INSERT INTO tof_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Moses Isrrael pamkolpamdó bóktanórr wagó, “Isrrael pamkolpam! Errkya ini wirri bóktan akó gida tübarrkrru, ka yabü ne kla umul baindóla. Da kürü bóktan mumyamónlamke yabiób ngyabenóm akó barrbünüm ene Keinan tüp apadóm, ⌊Lod⌋, yabü abalbobatalab God, ne tüp akyanóm kainda. ");
INSERT INTO tof_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Darrü poko amngyelgu ka yabü amorranóm ne bóktan alióndóla, akó olgab aman-gu. A Lod, yabü God, oya gida bóktan poko mumyamónlamke, ka yabü ne arüng bóktan alióndóla. ");
INSERT INTO tof_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","“Godón gida bóktan poko gangga irrbünam akó mumyamónlamke! Zitülkus módóga, e sab Godón bóktan nóma mamoan kwarilo, bwób-bwób pamkolpama sab yabü ⌊wirri gyagüpitótók⌋ eserre akó e küp iazan bómzyatódakla. I ne sab Godón ini bóktanbóka nóma barrkrrue, sab igó bóktórre wagó, ‘Amkoman, ini wirri bwób pamkolpam wirri gyagüpitótók isako akó i ⌊küp bómzyatódako⌋!’ ");
INSERT INTO tof_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","“Darrü bwób babula, wa ia wirria, darrü godpükü mibü Godzane, mibü minggüpanan nótóke. Wa bóktan alkomólda, mi oyaka tangbamtinüm nóma górrgandakla. ");
INSERT INTO tof_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Darrü bwób babula, wa ia wirria, inzan morroal dümdüm wirri bóktan akó gidapükü, ka yabü ne kla alióndóla ini ngürr.” ");
INSERT INTO tof_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Moses akó bóktanórr wagó, “Ini bóktan yazebam, da moboküpdü irrbünam wagó, Lod blaman klamab Gode, kwitüm akó ini tüpdü. Darrü God myamem babula. ");
INSERT INTO tof_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","We ngarkwatódó, oya wirri bóktan akó gida karrkukus emorronam, ka yabü ne arüng bóktan alióndóla errkya. Ene igósüm yabüka akó yabü olmalbobataldó sab morroal asi yarile akó e sab kokrrap iade ngyabenane ini tüpdü, Lod yabü God, ne kla akyanda metat ngyabenóm.” ");
INSERT INTO tof_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","“Isrrael, tübarrkrru! ⌊Lod⌋, mibü God, wata darrpan God watóka. ");
INSERT INTO tof_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Marü ⌊moboküpdü ubi⌋ asi ki yarilün Lodka, marü God, moba dudu moboküpi, dudu samu-i, akó dudu arüngi. ");
INSERT INTO tof_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ka errkya yabü ne gida bóktan poko alióndóla, sab wata yabü moboküpdü ki kwarilün. ");
INSERT INTO tof_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","E wata yabiób olmal ini bóktan arüngi umul bain kwarilo. E metat ikik kwarilün ene gida bóktan pokoankwata, e müótüdü nóma mórrandakla ó e nóma agóltagóldakla, akó nóma ngón bagóndakla ó nóma bazebdakla.” ");
INSERT INTO tof_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Moses bóktanórr Isrrael pamkolpamdó wagó, “Lod yabü God, yabü sab nóma imarrue ene tüpdü, e nóla tótókdakla ene tüp apadóm, wa sab abün bwób pamkolpam kolanütanórre yabü obzekdógab. Ibü ngi módógako: Et, Girrgas, Amorr, Keinan, Perris, Ibae, akó Zebus pamkolpam. I abün pamkolpamako akó wirri arüngako yabükagab. ");
INSERT INTO tof_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Sab Lod yabü God yabü tangdó nóma irrbüne akó e sab memokan ut-ut ninane, e ibü wata metatómpükü ekrrónane. Da sab usakü bóktan tómbapón-gu gómdamal bangunüm, akó gyaur basen-gu. ");
INSERT INTO tof_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","E sab inkü kol gyabalómgu. E yabiób ópal olmal ibü simanal olmal alión-gu, akó ibü simanal olmal azebgu yabiób ópal olmalabkü. ");
INSERT INTO tof_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Zitülkus módóga, yabü simanal olmala sab obzek kena nalüngnüm kürü mamoan-gum, ama sab ngibürr god ⌊ótókóm⌋. E ini tonarr nóma tónggapónane, Lodón ngürsila sab tame urzan pabzaum yabü büsai kolae bainüm. ");
INSERT INTO tof_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","A e sab ibü inzan nangónamke: e sab ibü ⌊alta⌋ kolae ninamke akó ibü gyabi tolom nómkenamke da baem napónamke. Ibü god Asyerran gyabi talkum singgalgónamke akó ibü tómbapórrón obae godón dandang uri angónamke. ");
INSERT INTO tof_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Ini kla tómbapónamke, zitülkus e Lodón pamkolpamakla, tibi-tibi amórrón tóbankü. Lod yabü God yabü ilianórr blaman pamkolpamdógab ini tüpdü, tóba kolpamóm bainüm. ");
INSERT INTO tof_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","“Lodón ⌊moboküpdü ubi⌋ yabüka we zitülkusdü koke yarilürr akó wa yabü we zitülkusdü koke ilianórr, igó e abün koralnórró ngibürr pamkolpamdógab. Koke, e go aüdan kwarilnürrü ini dudu tüpdü! ");
INSERT INTO tof_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","A Lodón moboküpdü ubi yabüka yarilürr akó wa zürük emoanórr wa ne ⌊arüng alkamül-koke bóktan⌋ ingrinürr yabü abalbobataldó. We zitülkusdü, wa yabü we yusürr tóba arüng tange akó ⌊aurdü we amanórr⌋ ⌊leba zaget⌋ bwóbdügab, ene wa parraoan tangdógab, Izipt king. ");
INSERT INTO tof_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","We ngarkwatódó, e umulakla igó, Lod yabü God, wata darrpan God watóke. Wa ngambangól Goda. Wa tóba ⌊alkamül-koke tónggapórrón bóktan⌋ metat mamoanda akó oya morroal tonarr asine ibüka, nibiób moboküpdü ubi oyakama akó oya gida bóktan poko nidi mamoandako. ");
INSERT INTO tof_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","A oya nidi alzizi amaikdako, sab ibü obzekdó ⌊kolaean darrem⌋ sidüde. Ene kolaean darrem igósa, wa ibü kolae nirre. Wa sab wirri ngarkwat-koke ipüde darrü oloman obzek kwata darrem alkomólóm, oya nótó alzizi amaikda. ");
INSERT INTO tof_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Da módóga, oya gida bóktan poko morroal mumyamónlamke, ka ini ngürrdü ne wirri bóktan akó gida alióndóla.” ");
INSERT INTO tof_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Moses Isrrael pamkolpamdó bóktanórr wagó, “E tai kóbó gyagüpi amaiklamke, Lod yabü God ia tolngomólnónóp ini ⌊ngüin-koke bwóbdüma⌋ 40 pailüm, yabü ngi tüp alókóm akó yabü bapókóm müp tonarre. Wa inzan tonarr igósidi tómbapónórr yabü moboküp bapinüm akó basenóm, e ia oya gida bóktan poko amkoman mamoan kwarilnürrü, ta ia koke. ");
INSERT INTO tof_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Wa yabü ngi tüp elókórr inzan kwata, wa yabü aloan ngintinóp, da wa yabü mana alo-e ngabyólürr, yadi akó yabü abalbobatala ngaen ne alo klambóka umul-kók kwarilürr. Wa ini poko tómbapónórr yabü umul bainüm wagó, pama brredane koke ngyabene, a blaman ne bóktana bausdako Lodón taedógab. ");
INSERT INTO tof_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","“A e ne gaodó nóma eloane, akó morroal müót nóma balmelane, akó mórran-mórran nóma bainane, ");
INSERT INTO tof_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","akó yabü ⌊kau⌋, ⌊sip⌋, akó ⌊gout⌋ abün nóma bainórre, akó ⌊silba⌋ akó ⌊gold⌋ nóma abün bainórre akó blaman ne elklaza, ");
INSERT INTO tof_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","e sab ikub bagürgu. Sab Lod yabü Godónbókama bamrükgu, yabü nótó yusürr Izipt kantrridügab, e leba zaget nóla kwarilnürrü. ");
INSERT INTO tof_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Wa yabü wató simarrulürr ene amkoman wirri akó gum-guman ngitan ngüin-koke bwóbdüma, balóng gwar akó walipwalipa ne ngyaben kwarilürr. Ene nae-koke bwóbdü, Lod naean kwat tapakurr karrkukus ingülküpdügab naea bókanóm yabünkü. ");
INSERT INTO tof_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Wa yabü mana alo we nilinóp alom ene ngüin-koke bwóbdü, yabü abalbobatal umul-kók ne alo klambóka kwarilürr. Wa yabü wirri müp ngyaben nókyenóp yabü ngi tüp alókóm akó bapókóm ugósüm, wa solkwat morroal ngyaben yabüka ia sidüde. ");
INSERT INTO tof_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","E sab inzan bóktan-gu yabióbka wagó, ‘Mi mórreldómakla mibiób arüng akó mibiób tangab arüngdügab.’ ");
INSERT INTO tof_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Yabü ki ngambangólólón igó, Lod yabü God watóke yabü arüng nótó aliónda mórrel bainüm. Wa ene kla tónggapónda tóba ⌊alkamül-koke tónggapórrón bóktan⌋ karrkukus ainüm, wa yabü abalbobatal ne bóktan nókyenóp. Ene bóktan wata asine errkya, kazan bóktandóla.” ");
INSERT INTO tof_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Moses bóktanórr Isrrael pamkolpamdó wagó, “Kürü ini bóktan yazebam, moboküpdü akó gyagüpitótókdó irrbünamke, da bamelamke yabiób tangdó akó yabiób müóngdü timamzan, yabiób gyagüpi bomanóm metat. ");
INSERT INTO tof_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","E wata yabiób olmal ini bóktan arüngi umul bain kwarilo. E metat ikik kwarilün ene gida bóktan pokoankwata, e müótüdü nóma mórrandakla ó e nóma agóltagóldakla, akó nóma ngón bagóndakla ó nóma bazebdakla.” ");
INSERT INTO tof_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","Moses akó bóktanórr wagó, “Ini ngürr, ka yabü obzek kwata nis bóktan angrindóla, bles bain bóktan akó amórr bain bóktan. ");
INSERT INTO tof_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Errkya ini ngürrdü, ka ⌊Lodón⌋ yabü God, oya gida bóktan poko yabü alióndóla. E ene gida bóktan poko nóma mamoan kwarilo, bles bain bóktan sab yabüka yarile. ");
INSERT INTO tof_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","A sab amórr bóktan yabüka yarile, e ene gida bóktan poko koke nóma mamoan kwarilo akó e nóma tübyalüngórre ene kwatódógab, ka yabü ne kwat amtyandóla errkya, ama ngibürr godab solkwat atanóm, e ngaen umul-kók ne godbóka kwarilnürrü. ");
INSERT INTO tof_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","“E Zodan tobarr baurr kari pokoakla, ama sab ogobo Lod yabü God ne tüp akyanda. E nóma ipüdane ene tüp, akó ngyabenóm nóma bainane, ");
INSERT INTO tof_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","blaman ini arüng bóktan akó gida tai mumyamónlamke, ka ne kla arrbündóla yabü obzek kwata ini ngürr.” ");
INSERT INTO tof_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Moses Isrrael pamkolpamdó bóktanórr wagó, “E nóma barrbuno ene tüpdü, ⌊Lod⌋ yabü God ne tüp akyanda, sab ola ngibürr ngazirran tonarr tikó azebgu ibü mamoanóm, ene pamkolpama ne ngarkwat ngazirr tonarr tómbapóndako, ola nidi ngyabendako. ");
INSERT INTO tof_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","Yabü aodó darrü olom babul ki yarilün tóba olmal nótó amselda urdü, ⌊gyaur klamzan⌋, ó kolae samuan tangamtindügab nótó ayalda solkwat ne tonarra tómbapónórre. Ó inzan kolae tulmil nótó tómbapónda: nus ut, irrüb ut azil, tonan, ");
INSERT INTO tof_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","wapi-wapi kain, merram-merram kain, pail ódód, bao tóre, azirr amgün, mórrke tóre, kwat bórrang. Ó büdül mórrkeab gapók nótó alkalda usakü ikiküm. ");
INSERT INTO tof_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","Zitülkus módóga, nadü oloma inzan tonarr nótó tómbapónda, wa ngazirr oloma Lodón ilküpdü. Da ini ngazirr klamabme, Lod yabü God ene tüp pamkolpam, ini kla nidi tómbapóndako, sab kolabütale ene tüp amgatóm e ene tüpzan emrranane. ");
INSERT INTO tof_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","E wata Lodón obzek kwata dümdüm kwarilo, igósidi yabü pamkolpama zitül-koke pokodó koke ngi barmünórre.” ");
INSERT INTO tof_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","Da Moses bóktanórr wagó, “E ne pamkolpam ngitanóm kaindakla tibiób tüpdügab, i ibü bóktan mamoandako, nidi irrüb ut azildako akó kolae samuan tangamtindügabi nidi ayaldako solkwat ne tonarra tómbapónórre. A yadi, Lod, yabü God nótóke, yabü koke ok bainda ini elklaza tómbapónóm. ");
INSERT INTO tof_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","A ini zitülkusdü, wa sab prropet zirrsapóne yabünkü kazanla, yabü yabióban pamkolpamdógab, Isrrael pamkolpam. Da e sab oya bóktan arrkrru kwarilünke. ");
INSERT INTO tof_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","“E ne ngürrdü kwób bazerró Sinae Pododó, e Lodón yabiób God yatoarre wagó, ‘Ki myamem kokeakla marü gyagüp arrkrrum, akó ki ta myamem kokeakla marü wirrian ur ulit asenóm. Ki sab kena nurrbarinün.’ ");
INSERT INTO tof_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Lod kürüka bóktanórr wagó, ‘I dümdüm pokom katop. ");
INSERT INTO tof_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Ka darrü prropet dódórr ino, mazanla, ibü kugupidügab. Ka kólba bóktan sab oya taedó irrbuno, da wa sab pamkolpam nüzazilnórre, ka oya blaman ne arüng bóktan ilino. ");
INSERT INTO tof_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Kürü bóktan koke nótó arrkrru yarile, ene pama ne poko bóktale kürü ngidü, ka oya sab imtino wa, “Ma kürü bóktan koke iade arrkrru namülnürrü?” ");
INSERT INTO tof_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","A igó prropet, tóbanan umuldügab bóktan nótó nóma bóktóne kürü ngidü, ka koke ne poko ilo bóktanóm, oya sab büdülümpükü ki emkólnóm. Akó igó prropet, darrü godón ngidü nótó bóktóne, oya ta sab ki emkólnóm.’ ");
INSERT INTO tof_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","“E aprrapórr yabiób bamtindakla wagó, ‘Ia ki umul bairre igó, prropetan bóktan ia amkoman Lodkagabia, ó ta ia koke?’ ");
INSERT INTO tof_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","Prropeta nóma bóktale Lodón ngidü, akó wa ne poko bóktóne amkoman koke nóma tómbapóne, da ene bóktan Lodkagabi kokea. Ene prropeta tóbanan umuldügab bóktóne, da e oya gum koke koralo.” ");
INSERT INTO tof_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Zaza Isrrael pamkolpam nóma balngomól kwarilürr, ene tüpdü ugón wirri ku yarilürr. Darrü pam, ngi Elimelek, Betliemóm ngyaben yarilürr, Zuda bwóbdü. Wa gyagüpitótók esenórr Moab bwóbdü ngyabenóm karianbóka, tóba Naomi kolpükü akó tibiób nis siman olom nis, ngi Maklon akó Kilyon. I Eprrat zitül kolpam koralórr. I Moab bwóbdü ogobórr akó ola ngyaben koralórr. ");
INSERT INTO tof_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","A Elimelek ma we nurrótókórr, Naomin we zumgatórr, tóba nis siman olom nispükü. ");
INSERT INTO tof_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ene olom nisa Moab kol nümiógrri, ibü ngi Orrpa akó Rrut. 10 Paila nóma blakónórr, ");
INSERT INTO tof_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Maklon akó Kilyon ta ola nurrótókrri. Wata Naomi tebe püóran warilürr, müór a olmal babul. ");
INSERT INTO tof_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Naomi Moabómzan warilürr, wa arrkrrurr wagó, ⌊Lod⌋ tóba pamkolpam kuri tangnamtirre morroal alo klame, da wa tóba elklaza we tómbapónórr Moab amgatóm, Betliem alkomólóm, tóba nis kolalkot nispükü. ");
INSERT INTO tof_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Da wa bupadórr ene bwóbdügab, wa ne ngyaben warilürr, tóba nis kolalkot nispükü, da i Zuda bakonóp. ");
INSERT INTO tof_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Da kwat-kwat Naomi tóba kolalkot nis we nyalórr wagó, “E ugó alkomólam, yabiób aip nisab müótüdü ngyabenóm. Yabüka sab Lod morroal tonarr yarile, e kürükazan morroal tonarr namülnürri akó büdül nidipako. ");
INSERT INTO tof_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Yabüka nizandó Lod sab kwat popadan sine müór nis amiógüm akó morroal ngyabenóm müótüdü yabiób küsil müór nispükü.” Da Naomi ibü nüprükürr, a i ma nizana wirribóka yónüm bairri. ");
INSERT INTO tof_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","I oya we wyalórri wagó, “Koke, ki mankü aurri marü pamkolpamdó!” ");
INSERT INTO tof_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Da Naomi ibü we nyalórr wagó, “E wata alkomólam! E kankü tótókóm iade kaindamli? Ka sab myamem siman olom nis koke nóseno yabü amiógüm. ");
INSERT INTO tof_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","E alkomólam yabiób basirrdü, zitülkus ka amkoman epepanla darrü müór amiógüm. Ka ne müór amiógüm gaodó nóma ki namüla, akó ka ne errkya irrüb ki umtula müórpükü, akó ka ne yabünkü olom nis ki nósena, e ia gaodó ki namüli inzan ngyabenóm, kókó i ki wirri baini? Akó ini pokoa yabü ia ki nólene errkyadan müór nis apadóm? Kokean, zitülkus Lod kürü ngyaben kuri kap ine, da kürü ngyaben amkoman kolaeana yabü ngyabendógab.” ");
INSERT INTO tof_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Da i wirribóka yón namülnürri akó Orrpa tóba kolalkot epep we uprükürr akó yónzwamtorr. Da wa alkomólórr tóba basirrdü. Rrut wa Naomika arróbórr. ");
INSERT INTO tof_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi oya we wyalórr wagó, “Rrut, marü gódama kuri alkomóle tóba kolpam akó godódó. Oya solkwat ugó akya.” ");
INSERT INTO tof_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Da Rrut bóktan we yalkomólórr wagó, “Ma kürü myamem ayalgu marü amgatóm ó marükagab byalüngüm. Zitülkus módóga, ma nubó natoklo, ka ta natoklo. Ma ne ngyaben namulo, ka ta we ngyaben namulo. Marü kolpam sab kürü kolpam kwarile, akó marü God sab kürü God yarile. ");
INSERT INTO tof_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ma ne nurrótoko, ka ta we nurrótoko, ó sab kürü gapók we ilüngrre. Mibü wata büdüla türrgrrüte. Ka ne marü nóma mimgüto, ngibürr popa zitülkusdü, Lodón kolae gazirra sab kürüka ki tam!” ");
INSERT INTO tof_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi igó nóma umul bainürr wagó, Rrutün wirri ubia tótókóm, wa myamem darrü poko koke bóktanórr oya alkomólóm. ");
INSERT INTO tof_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","I aurrnürri, kókó Betliem basirrdü abzirria. Dudu basirra arrkürrürr oya nóma osenóp akó kola wagó, “Ia ini Naomio?” ");
INSERT INTO tof_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Wa ibü nilóp wagó, “E kürü Naomibóka ngilian-gu. E kürü Marrabóka ngiklinam, zitülkus Wirri Arüng Goda kürü ngyaben kap kuri ine. ");
INSERT INTO tof_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Ka ngaen ini bwób nóma amgatórró, kürü abün elklaza kwarilürr, da Lod ma kürü kuri kalkomóle darrü klam koke. E kürü Naomibóka ngilian-gu, zitülkus kürü Wirri Arüng Goda kolae kyónürr akó wirri müp kókyanórr.” ");
INSERT INTO tof_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Da Naomi ene inzan tolkomólórr Moabgabi tóba Moab kolalkotpükü, Rrut. Darrü alo kla, ngi barrli, ibü abüla ugón bókyanórr, i Betliem ne tonarr abzirri. ");
INSERT INTO tof_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Naomin narezoret asi yarilürr, ngi Boaz. Wa mórrel akó wirri ngi pam yarilürr, Elimelekón zitül olom. ");
INSERT INTO tof_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Darrpan ngürr Rrut Naomika bóktanórr wagó, “Ma ia kürü koke kilo tótókóm barrli apapdó? Kürü ubi darrü oloman solkwat akyanóma barrli singül dakabainüm, oya obzek kwata kürüka morroal nótó sesene.” Naomi bóktan yalkomólórr wagó, “Taia, kürü olom, ma ugó nató!” ");
INSERT INTO tof_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Rrut we natókórr apapdó, barrli singgalgón pamab solkwat akyalórr, barrli singül dakabainkü. Ene ma igó yarilürr, wa tai Boazón apapdó warilürr, Elimelekón zitül olom. ");
INSERT INTO tof_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Da módóga, ngibürr abüs küp solkwat, Boaz Betliemgabi ugón tübzilürr. Wa ibüka bóktanórr wagó, “⌊Lod⌋ yenkü asine!” I bóktan yalkomólóp wagó, “Marü Lod sab bles mine!” ");
INSERT INTO tof_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boaz zaget singüldü pam imtinürr wagó, “Ini küsil kol ia noano?” ");
INSERT INTO tof_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Ene pama bóktan yalkomólórr wagó, “Wa ene Moab kolo, Naomidi nidi tolkomórri, Moab bwóbdügabi. ");
INSERT INTO tof_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Wa kürü kümtine wagó, ‘Ka ia zaget kolpamab solkwat koke akyeno, barrli singül dakabainüm?’ Da wa zaget kurai irrbi bókyene, kókó errkyadan. Wa ma wata karianbóka kuri ngón agóne aren-aren müót murrdü.” ");
INSERT INTO tof_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Da Boaz Rrutün we wyalórr wagó, “Gyaurka, kürü bóktan turrkrru. Ma myamem darrü apapdó barrli singül dakabain-gu, akó ini poko amgatgu. Ma wata ini zaget kolab minggüpanan akyan namulo! ");
INSERT INTO tof_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ma we apap ngaka, pama barrli singül ne singgalgóndako, ma kubó ola namülünke, kolab solkwat barrli singül dakabainüm. Ka blaman pam kuri nilnüma marü kolae tonarre ngakan-gum. Akó marü naea nóma müpüde, kubó ma we mariti tólaelórrón nae beledógab enónke, i ne kla errngamórre.” ");
INSERT INTO tof_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rrut wakósingül we nülkamülürr tüpdü, da obzek tüpdü elkomólórr. Da wa Boazón imtinürr wagó, “Ma moba obzek kwata kürüka iade morroal sesena igó, ma kürü morroal ngakandóla? Ka go mogob kolóla.” ");
INSERT INTO tof_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boaz bóktan yalkomólórr wagó, “Ka blaman bóktan nurrkrruarre ma moba kolalkotódó ne poko tómbapónórró, marü müóra nóma nurrótókórr. Ka umulóla, ma moba aipab nis akó moba bwób iazan amgatórró, akó ma ia katókórró ngyabenóm mogob kolpampükü, ma ngaen umul-koke nibióbbóka namülnürrü. ");
INSERT INTO tof_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Marü sab Lod darrem wató mókyene, ma ne poko tómbapón namülnürrü. Marü sab Lod, Isrraelón God nótóke, dudu darrem kla wató mókyene, ma noa murrdü ngyabenóm katókórró moba zid bainüm!” ");
INSERT INTO tof_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rrut bóktanórr wagó, “Ma moba obzek kwata kürüka metat morroal asen namulo, wirri pam. Ma kürü kari morroal koke kuri kina, ma enezan morroal tonarre bóktandóla kürüka. Enanla ka darrpan tonarr kokela marü ngibürr zaget koldógab.” ");
INSERT INTO tof_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Alo ngarkwat nóma semrranórr, Boaz Rrutünbóka wagó, “Ala kató, plaoa poko ipa, ugó yanggóból ini waendó.” Da wa we mórran-mórran bainürr ngibürr zaget kolpampükü. Boaz ngibürr bamngulürrün barrli küp uliónürr. Rrut tóba ngarkwatódó elorr, da ngibürr alo pokoa baminürr. ");
INSERT INTO tof_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rrut nóma bupadórr barrli singül dakabainüm, Boaz tóba zaget pamdó bóktanórr wagó, “Ini kol kubó olkomólamke. Wa ne kubó nóma dakabain waril barrli kur negako, e kubó oyaka bóktan-gu igó, wa kolae kla tónggapóndo. ");
INSERT INTO tof_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Akó kubó ngibürr tangande alók kwarilünke ene kurdügab, oya dakabainüm. E kubó oya aggu.” ");
INSERT INTO tof_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Da Rrut we dakabain warilürr barrli singül, kókó abüsa nóma bótaorr. Wa blaman nóma ailürr küp ausüm, ene barrli küp 10 müp ngarkwat kwarilürr. ");
INSERT INTO tof_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Rrut ene barrli küp imarrurr müót basirrdü. Wa tóba kolalkot omtyanórr wa nigó ngarkwat barrli ailürr, akó wa uliónürr ne alo pokoa baminürr. ");
INSERT INTO tof_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi oya umtinürr wagó, “Ma ia ini barrli ne dakabain namüla, errkya ngürr? Akó ma noa apapdó zaget namüla? Da God bles ki yó ene pam, marü morroal nótó ngakan yaril.” Da Rrut tóba kolalkot wyalórr wa noan apapdó zaget warilürr. Wa bóktanórr wagó, “Ka darrü paman apapdó zaget namüla, ngi Boaz.” ");
INSERT INTO tof_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi wirrianbóka we bóktanórr Rrutka wagó, “Lod Boazón bles ki yó, akó wa koke bóleanórr tóba morroal tonarr okaka amzazilüm arról akó büdül nidipko!” Naomi akó bóktanórr wagó, “Ene mibü minggüpanan narezorete, ó wa mibü darrü ⌊aurdü amaik⌋ pama.” ");
INSERT INTO tof_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Da Rrut bóktanórr wagó, “Kürü akó morroal ne bóktan küline, wagó, ‘Ma kürü zaget pamkolpam minggüpanan namulo, kókóta blaman abüla kürü apapdó tai nóma blakóne.’” ");
INSERT INTO tof_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi bóktanórr wagó, “Rrut, amkoman, kürü olom, ma sab kolpükü zaget namulo Boazón apapdó. Marü sab aprrapórr ta kolae tonarre kena ngakan kwarilün, ma ne darrü paman apapdó nóma natoko.” ");
INSERT INTO tof_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Rrut we dakabain warilürr Boazón zaget kolpükü, kókó blaman barrli akó ⌊wit⌋ abüla nóma blakónórr. Da wa metat we ngyaben warilürr tóba kolalkotpükü. ");
INSERT INTO tof_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ngibürr ngürr kakóm, Naomi Rrutünbóka wagó, “Kürü ubi marü müór kwat tónggapónóma. Ene igósüm, sab marü mobanan müót yarile, akó marü ngyaben sab morroal yarile. ");
INSERT INTO tof_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ma umulóla Boaz, ma noa zaget kolpükü barrli dakabain namülnürrü, mibü minggüpanan narezoreta. Da turrkrru. Ini irrüb wa kubó barrli küp aus bwóbdü zaget yarile. ");
INSERT INTO tof_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Da ma apür, morroal ilang idi balóp, akó ma tumum mórrkenyórr püti bai. Da kubó natókóke ene küp aus bwóbdü. Ma kubó moba pupo bain-gu igó ma olamla, kókó oya aloa akó anóna nóma blakóne. ");
INSERT INTO tof_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ma kubó tai ngakalónke wa kubó ne umtule. Natókóke, oya basirr mórrkenyórr kwit yónke, da kubó umtulke oya wao-wao. Wa kubó marü darrü kla tónggapónóm mile.” ");
INSERT INTO tof_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rrut wyalórr wagó, “Ka kubó blaman kla tómbapono, ma ne poko namüla.” ");
INSERT INTO tof_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Wa we natókórr, küp aus bwóbdü. Wa ene kla blaman tómbapónórr, oya kolalkota ne bóktan wyalórr. ");
INSERT INTO tof_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boazón aloa ó anóna nóma blakónórr, oya bübdü morroal mórranórr. Da wa utüm wamórr, barrli kwób minggüpanan. Wa ut nóma yarilürr, Rrut piküpan natókórr, oya wao-wao mórrkenyórr we kwit yónürr, da we umtulürr. ");
INSERT INTO tof_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ene irrüb zokrrok, oya utürrün büba nóma arrkürrürr, wa türsümülürr, da bümzazilürr. Nóma ngabkanórr, da wa kol osenórr, tóba wao-wao. ");
INSERT INTO tof_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boaz bóktanórr wagó, “Iba, kolo! Ma ia nótó?” Rrut bóktanórr wagó, “Wirri pam, ka Rrut. Kürü ubia kürü mató ngakókalo, zitülkus ma kürü ⌊aurdü amaik⌋ olomla. Da ma ia sab kürü koke kümigo moba kolóm?” ");
INSERT INTO tof_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz bóktanórr wagó, “⌊Lod⌋ marü bles ki myó, kürü olom! Ma ngaen-gógópan morroal tonarr okaka imzazilürrü moba kolalkotódó, da ma errkya wirri morroal tonarr okaka simzazila kürüka, zitülkus ma darrü küsil pam koke kuri yamküna, ia elklaza-koke pam ó mórrel pam. ");
INSERT INTO tof_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ma gumgu, kürü olom, blaman is umulako ini wirri basirrdü, ma morroal tonarr kolóla. Ka blaman kla sab tómbapono, ma ne klamóm kümtina. ");
INSERT INTO tof_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Wa go amkomana, ka marü minggüpanan narezoretla marü aurdü amaiküm, a darrü narezoret asine, amkoman minggüpanan nótóke kürükagab. ");
INSERT INTO tof_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ma ini irrüb poko aini namülün ngarkwat kókó irrbi. Mi sab ugón umul bairre, wa ne ubi nóma baine, marü aurdü amaiküm. Enta taia! Ka arról Lodón obzek kwata igó bóktono wagó, marü sab kótó aurdü mumaiko, wa ne ubi koke nóma baine. Da ma ugó umtul, kókó sab irrbi.” ");
INSERT INTO tof_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rrut Boazón wao-wao we umtulürr kókó sisa balgón küsil yarilürr, zitülkus Boazón ubi koke yarilürr kolpama koke ki umul bairre igó, kola we umtule barrli küp aus bwóbdü. ");
INSERT INTO tof_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boaz oyabóka wagó, “Moba tumum mórrkenyórr ugó sidó, da moba tange ugó adrrat.” Wa emoanórr, da Boaz oya abün barrli küp uliónürr. Wa 6 mün yazeblórr Rrutün mórrkenyórrdü alókóm. Wa kwit yónürr, da Rrutün singüldü igasilürr. Da Rrut we alkomólórr ama wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Wa nóma abzilürr müót basirrdü, oya kolalkota umtinürr wagó, “Ma ia-ia natóka, ka marü sim ne poko mila?” Rrut oyaka blaman poko adrratórr, Boaz ne tonarr tómbapón yaril oyankü. ");
INSERT INTO tof_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rrut inzan warilürr wagó, “Boaz bóktanórr wagó, ‘Ma tang küpan koke alkomolo moba kolalkotódó,’ da wa kürü abün barrli küp küline”. ");
INSERT INTO tof_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi oyaka bóktanórr wagó, “Ma wata kya piküp namülün, kókó kubó marükwata igó ia tómbapóne. Boaz kubó koke ngón ngagóne, wa kalma kókó ini bóktan tónggapóne.” ");
INSERT INTO tof_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaz kwóbbazen pokodó wamórr, wirri basirran barrbün mamtae minggüpanan, da wa we mórran-mórran bainürr. Da módóga, Elimelekón minggüpanan narezoret, Boaz noabóka apón yarilürr, wa ene poko ugósan sórrgrratórrma. Boaz oya ngyaunürr wagó, “Kürü gódam, mórranóm ala tam!” Da ene pama we wamórr oyaka, mórranóm. ");
INSERT INTO tof_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Boaz 10 ⌊balngomól byarrmarr pam⌋ ngibaunürr wankü mórranóm, da i bobrranórr. ");
INSERT INTO tof_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Wa bóktanórr ene minggüpanan narezoretódó wagó, “Naomi kuri tolkomóle Moab bwóbdügabi, da oya ubia, kolpama mibü minggüpanan narezoret Elimelekón tüp amigórre, ene kla ⌊aurdü amaiküm⌋. ");
INSERT INTO tof_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ka gyagüpi wama kagó, ka marü ini poko ayaldóla. Ma ne ubi nóma namulo apadóm, da amióg ibü obzek kwata, aini nidi mórrandako, akó ini balngomól byarrmarr pamab obzek kwata. Ma ne ubi koke nóma namulo, kibüka tópta. Darrü pam myamem singül kwata babula ini tüp amiógüm, wata matókla. Ka ma marü kakotala.” Ene pama wa, “Taia, ka amigo ene kla, ene kla aurdü amanóm Naominkü.” ");
INSERT INTO tof_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Da Boaz bóktanórr wagó, “Ma ene tüp nóma amigo Naomikagab, da igósidi ma ta ene Moab kol Rrutün zumigo, ene Maklonón kóble. Ene igósüm, ene tüp sab büdül oloman bobatalab tangdó yarile.” ");
INSERT INTO tof_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Da ene pama inzan bóktanórr wagó, “Ka igósidi gaodó kokela ene tüp amiógüm, zitülkus kürü tüp sab ene kolan olmala kena ipüdünüm; sab babul yarile kürü olmal akyanóm. Ka gaodó kokela, a ma müób amióg.” ");
INSERT INTO tof_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","(Ngaen, ene tonarrdó, Isrrael kolpamab gida yarilürr wagó, darrü oloman tüp ó elklaza bumiógüm ó darrem-darrem bumiógüm nóma yarile, da ene inzana, wa wapórdó baten kla inine, da wa amióg olom ekyene, nótó apadóda. Da wa ene poko dümdüm kuri ekyene.) ");
INSERT INTO tof_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ene pama Boazónbóka wagó, “Mató bumióg.” Da wa tóba wapórdó baten kla ininürr, Boazón ekyanórr. ");
INSERT INTO tof_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Boaz ene balngomól byarrmarr pam nilóp akó ngibürr nidi kwarilürr ene pokodó wagó, “E blamana yabiób ilküpi kuri esenane ini ngürr. Elimelek akó oya nis siman olom nis Kilyon akó Maklon, ka blaman ibü elklaza kuri bumiga Naomikagab. ");
INSERT INTO tof_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Akó ka Rrutün kuri upuda kólba kolóm, Maklonón kóble, Moabgab nótó katókórr. Ene igósüm, Elimelekón elklaza sab oya olmalkoldógab koke balóke akó oya bobatal sab asi kwarile oya pamkolpamdó akó basirrdü. Da e blamana kuri esenane ó kuri barrkrrua, ini ngürr.” ");
INSERT INTO tof_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Balngomól byarrmarr pam akó ola nidi kwarilürr, blamana bóktónóp wagó, “Ki marü kuri móserre akó murrkrrurre! ⌊Lod⌋ sab ene kol, marü müótüdü nótó bangrine, inzan wine, Rreizel akó Liazan, abün olmal nidi nósenóp Zeikobónkü. Ma sab mórrel pam namulo Eprratón zitüldü akó kolpam marübóka wirri umul kwarile Betliemóm. ");
INSERT INTO tof_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Marü sab Lod ne olmalbobatal müline Rrutkagab, i sab inzan kwarile Perrezón olmalbobatalzan, Tamarr ne olom ilngumilürr Zudankü.” ");
INSERT INTO tof_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Da Boaz Rrutün we udódürr müótüdü, tóba kolóm. Lod we tangzwamtinürr, da bikóm esenórr, siman olom we ilngumilürr. ");
INSERT INTO tof_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Basirr kola Naominbóka wagó, “Lodón yagüram! Wa marü bobat kuri mókyene errkya, marü sab nótó ngamkale. Isrrael kolpam sab oyabóka wirri umul kwarile. ");
INSERT INTO tof_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Wa marü sab küsil arüng mókyene akó marü sab ngakan yarile epepdó, zitülkus marü kolalkota oya ilngumile. Rrutün ⌊moboküpdü ubi⌋ marükama akó wa ngarkwatódómo 7 siman olmaldógab.” ");
INSERT INTO tof_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi ene gab olom ipadórr, tóba ganggópdó ingrinürr, da we makrraolórr. ");
INSERT INTO tof_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Oya minggüpanan kola olom ngi ngyesilóp Obed. I blaman is nüzazilóp wagó, “Rrut Naominkü siman olom kuri ilngumile!” Obed olom ilngumilürr, ngi Zesi, Deibidün ab nótó yarilürr. ");
INSERT INTO tof_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Perrezón olmalbobatala inzan tóbabótórr, kókó Deibidün amrran. Perrezón siman olom Kezrron yarilürr, ");
INSERT INTO tof_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Kezrronón siman olom Rram yarilürr, Rramón siman olom Aminadab yarilürr, ");
INSERT INTO tof_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabón siman olom Nakson yarilürr, Naksonón siman olom Salmon yarilürr, ");
INSERT INTO tof_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmonón siman olom Boaz yarilürr, Boazón siman olom Obed yarilürr, ");
INSERT INTO tof_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedón siman olom Zesi yarilürr, akó Zesin siman olom Deibid yarilürr. Rrutün Peba aini blakónda. ");
INSERT INTO tof_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Lod Deibidün aurdü amanikürr ibükagab, wankü nidi gazirr kwarilürr. Da módóga, wa paude we mórran-mórran bainürr tóba morroal wirri müótüdü. ");
INSERT INTO tof_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Kinga ⌊prropet⌋ Neitónka we bóktanórr wagó, “Ka inamüla ini agurr sida nugupi aelórrón müótüdü, a Godón bokos ama gyaurka ⌊Palae Müótüdüma⌋.” ");
INSERT INTO tof_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Neitón bóktan we yalkomólórr kingdü wagó, “Marü ne gyagüpitótóke, wam da tónggapó, zitülkus Lod mankü asine.” ");
INSERT INTO tof_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","A ene irrüb Lod Neitónka we tóbtanórr wagó, ");
INSERT INTO tof_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Ugó wam kürü zaget olom Deibidka, da igó yalke magó, ‘Lod igó bóktóne: ma sab ngyaben müót koke elo kürünkü.’” ");
INSERT INTO tof_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","“Wam, da kürü zaget pam yalke magó, ‘Wirrian Arüng Lodón bóktan yóni wagó, “Ngaen-gógópan ma enan ⌊sip⌋ ngabkan pam namülnürrü, da ka ma marü kuri murruna sipab alo bwóbdügab kürü Isrrael pamkolpam balngomólóm. ");
INSERT INTO tof_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Ka mankü asi namülnürrü ma ene iazan wamnórró. Akó ka ibü marükagab amarró mankü nidi gazirr kwarilürr, ama kolaedó simarrurr. Da ka sab marü ngi wirri ino ngibürr ini tüpdü wirri pamzan. ");
INSERT INTO tof_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Akó ka sab kólba Isrrael is ngyaben bwób nókyenónómo. Ka sab ibü ola irito, igósüm i sab tibiób bwóbdü ngyaben kwarile. Ibü sab myamem koke nunurre, kolaean pamkolpama ngaenzan bangón kwarilürr, ");
INSERT INTO tof_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","ka ibü zaz ne tonarr irrbürrü, tai kókó errkya. Akó ma sab paudüdü ngyaben namulo. Mankü nidi gazirr kwarilürr, i marü sab kokean munurre. Akó ka, Lod, ka marü amkoman igó milo, Deibid: Ka sab müót elo marünkü. ");
INSERT INTO tof_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Marü arróla nóma blakóne, ó tüpdü nóma müngrirre marü abalbobatal negako, ka sab darrü küp marükagab ipudo marü pabo apadóm, akó ka sab oyankü pabo tónggapono wa sab metat nólgabi ne balngomól yarile kingzan. ");
INSERT INTO tof_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Kürü ene müót sab wató ele, kürü sab nóla kagürnórre. Kürüme sab metat darrü küp asi yarile, sab metat-metat nótó balngomól yarile kingzan. ");
INSERT INTO tof_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Ka sab oya Ab namulo akó wa sab kürü olom yarile. Wa ne kolae nóma tónggapóne, ka sab oya wirri bidam ekyeno, aba tóba olomzan bidam akyanda. ");
INSERT INTO tof_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","A ka sab kólba morroal tonarr koke agino oyakagab, ka Solkagabzan agirrü, ka marüme noan amaikürrü, ama marü müngrirrü. ");
INSERT INTO tof_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Marü müóta sab kokean bülgüte akó marü kingzan balngomóla sab kokean blakóne. Marü olmalbobatal sab metatómpükü king korale Isrrael bwób alngomólóm.” ’” ");
INSERT INTO tof_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Ene kakóm, Neitón blaman ini poko Deibidka we büdrratórr, Lod ne kla okaka sizazinürr. ");
INSERT INTO tof_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Deibid nurrótókórr, da we ilüngóp Deibidün wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Wa 40 pailüm balngomól yarilürr ene Isrrael pamkolpam. 7 Pailüm wa Ibrron wirri basirrdügab balngomól yarilürr, 33 pailüm wa ama Zerrusalemgab balngomól yarilürr. ");
INSERT INTO tof_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ene kakóm, Solomon we mórran-mórran bainürr kingan mórran klamdó tóba aban Deibidün pabodó. Wa Isrrael pamkolpam wirri arüngi balngomól yarilürr kingzan. ");
INSERT INTO tof_vpl VALUES ("K13_3","012_3_3","1KI","3","3","3","Solomonón ⌊moboküpdü ubi⌋ ⌊Lodka⌋ yarilürr tóba aban Deibidün mumyamón bóktan amorrankü. A wa go ama Lodónkü ⌊urdü amsel lar⌋ akó ⌊gyaur kla⌋ bamngulülürr ngibürr godab tógaldó gyabi bwóbdü. ");
INSERT INTO tof_vpl VALUES ("K13_4","012_3_4","1KI","3","4","4","Darrpan ngürr Solomon Gibion wirri basirrdü wamórr Lodka lar urdü amselóm, zitülkus ene wirrian ⌊alta⌋ yarilürr, ngibürr altadógabi. Ngaen Solomon ola 1,000 ngarkwat dudu bóngan gyaur kla yamselórr ene altadó. ");
INSERT INTO tof_vpl VALUES ("K13_5","012_3_5","1KI","3","5","5","Gibionüm Lod Solomonka irrüb we tamórr nusi, da we yalórr wagó, “Kato kürü, marü ubi larógóm nóma yarile.” ");
INSERT INTO tof_vpl VALUES ("K13_7","012_3_7","1KI","3","7","7","Solomon bóktan yalkomólórr wagó, “Da errkya, Lodóe, kürü God, ma kürü, moba zaget pam, kingüm kuri küngrina kólba aban Deibidün pabodó. A ka go wata kari olomla, akó ka ta umul-kókla kólba zaget ia tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("K13_8","012_3_8","1KI","3","8","8","Ka marü zaget pam inamüla, moba pamkolpamab aodó, ma nibiób ilianórr. Aüd ta kokeako akó atang ta nabea. ");
INSERT INTO tof_vpl VALUES ("K13_9","012_3_9","1KI","3","9","9","Da ma moba zaget pam morroal gyagüpitótók sekya marü pamkolpam balngomólóm akó morroal amzyatóm kolae laróga, morroal laróga. Gaodó pam babulana, marü ini abün pamkolpam balngomólóm!” ");
INSERT INTO tof_vpl VALUES ("K13_10","012_3_10","1KI","3","10","10","Ini bóktana Lodón bagürwóman ngitanórr, Solomon ne poko imtinürr. ");
INSERT INTO tof_vpl VALUES ("K13_11","012_3_11","1KI","3","11","11","Da wa oyaka bóktan we yalkomólórr wagó, “Ma ini pokom gaodó kümtina, a kokrrap ngyabenóm koke, mobankü. Ma mórrelóm koke kümtina, akó mankü nidi gazirrdako, ibü kolae bainüm koke, a ma wa wirri gyagüpitótókóm katoa dümdüm ne klame morroal amzyatóm. Zitülkus ma ini pokom kümtina, ");
INSERT INTO tof_vpl VALUES ("K13_12","012_3_12","1KI","3","12","12","módóga, ka sab tónggapono ma kürü ne klamóm katoa. Turrkrru, ka sab marü wirri gyagüpitótók akó morroal moboküp mókyeno elklaza bómzyatóm. Darrü mazan pam ngaen babul yarilürr akó elnga sab mazan pam ta babul yarile. ");
INSERT INTO tof_vpl VALUES ("K13_13","012_3_13","1KI","3","13","13","Ka akó sab marü mülino ma koke ne klamóm katoa. Ka marü sab wirri mórrel mókyeno akó wirri ngi. Darrü king babul yarile mazan, marü ngyabendó. ");
INSERT INTO tof_vpl VALUES ("K13_14","012_3_14","1KI","3","14","14","Da ma ne kürü ngarkwatódó nóma ngyaben namulo akó arüng bóktan ó gida nóma mamoan namulo, marü aba Deibidzan tómbapón yarilürr, marü ngyaben ka ta sab igósidi kokrrap ino.” ");
INSERT INTO tof_vpl VALUES ("K14_20","012_4_20","1KI","4","20","20","Zuda akó Isrrael pamkolpam inzan kwarilürr, amaka malu kabedó nóresako, ena bürrkós. Pamkolpama alo akó anón akó barnginwóm kwarilürr. ");
INSERT INTO tof_vpl VALUES ("K14_21","012_4_21","1KI","4","21","21","Solomon ene dudu bwób wató alngomól yarilürr, tai Yuprreitis tobarrdógab, tai kókó Pilistia kantrridü, ene go tai kókó Izipt kantrrian ngaru. Ene bwób pamkolpama taks mani alión kwarilürr Solomonón. Ene abün-abün bwób tóba ngyaben tonarrdó wató balngomól yarilürr. ");
INSERT INTO tof_vpl VALUES ("K14_25","012_4_25","1KI","4","25","25","Solomonón ngyaben tonarrdó, Zuda akó Isrrael wata morroal ngyaben namülnürri, tai Dan wirri basirrdügab dorrmetódóbóna kókó Berrsyiba wirri basirrdü malubarrdóbóna. Blaman pamkolpama wata paudüdü bobrralórr ngórr nugup murrdü. Darrü kolaea ibüka koke tamórr. ");
INSERT INTO tof_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Ibü 480 paila nóma blakónórr Izipt nóma amgütóp, Solomon Lodón Gyabi Müót ael ugón bókyanórr, tokom ngim pail ne kla yarilürr, Solomon Isrrael nóma alngomól yarilürr. Ugón nis ngim melpal yarilürr, ngi Zib. ");
INSERT INTO tof_vpl VALUES ("K16_11","012_6_11","1KI","6","11","11","Da Lod Solomonka we bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("K16_12","012_6_12","1KI","6","12","12","“Ma ne kürü arüng bóktan akó gida nóma mumyamón namulo, akó kürü blaman gida bóktan poko mamoan namulo, da ka marü ab Deibidün ne ⌊alkamül-koke bóktan⌋ iliórrü, ka sab tónggapono. ");
INSERT INTO tof_vpl VALUES ("K16_13","012_6_13","1KI","6","13","13","Ka sab kólba ini müótüdü ngyabelo Isrrael pamkolpampükü, akó ka kólba Isrrael pamkolpam kokean bimgüto.” ");
INSERT INTO tof_vpl VALUES ("K16_14","012_6_14","1KI","6","14","14","Da Solomon ene Lodón Gyabi Müót ael we elakónórr. ");
INSERT INTO tof_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Solomon go abün mogob kol ngyaep yarilürr. Wa ngaen-gógópan Izipt kingan óp olom upadórr, da solkwat ama Moab, Amon, Idom, Sidon, akó It kol bumiógürr tóba kolóm. ");
INSERT INTO tof_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Lod ngaen Isrrael pamkolpam igó nilóp wagó, “E sab nanabwób kol bumióggu, kürübóka umul-kók nidipko, akó ibü pam yabü kol koke ki bumiógnüm. E ne sab nóma tónggapónane, i sab yabü moboküp nyalüngrre tibiób god ⌊ótókóm⌋.” A Solomon ma ene kol tóba dalgüpdü simarrurr. ");
INSERT INTO tof_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Solomonón amkoman kol 700 kwarilürr, kingab ópal olmal nidi kwarilürr. Oya ma akó 300 ngibürr kol kwarilürr. Ene kolabme wa tóba moboküp yalüngürr Godkagab. ");
INSERT INTO tof_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Solomon myang nóma bain yarilürr ene mogob kola oya moboküp yalüngóp tibiób godódó. Wa Lodón tai koke mamoan yarilürr oya aba Deibidzan kain yarilürr. ");
INSERT INTO tof_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Solomon ama Astorretón ótók yarilürr, Sidon isab kol god, akó Molek, Amon isab ngazirr god. ");
INSERT INTO tof_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Podo kwitüm, abüsa nólgabi banikda Zerrusalemgab, Solomon nis ⌊alta⌋ we tónzapónórr. Darrü Kemosón ótókóm, Moab pamkolpamab ngazirr god, akó darrü ama Molekón ótókóm, Amon pamkolpamab ngazirr god. ");
INSERT INTO tof_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Solomon ta akó dadan poko tónggapónórr tóba blaman mogob kolabkü, wa, i sab tibiób godódó morroal ilang buru akó ngibürr elklaza ia angan korale. ");
INSERT INTO tof_vpl VALUES ("K111_9","012_11_9","1KI","11","9","10","Da Lod Solomonka nis münüm inzan okaka tübyónürr oya gyabi angrinüm mogob god bütókgum, a kinga ama kak amaikürr oyaka, Isrrael pamkolpamab God. Solomon oya arüng bóktan kokean arrkrru yarilürr, da wa Solomonka ngürsilüm we bainürr. ");
INSERT INTO tof_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Oyaka we bóktanórr wagó, “Zitülkus ma inzan pamla, ma kürü ⌊alkamül-koke tónggapórrón bóktan⌋ akó kürü arüng bóktan koke amorrandóla, ka sab marü balngomól bwób marükagab ipudo, ama marü zaget olom ekyeno. ");
INSERT INTO tof_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Da ka büsai koke mürrkino ma arrólzanla, zitülkus kürü gyaur marü abdó Deibidka asine. A ka sab marü oloman tangdógab irrkino. ");
INSERT INTO tof_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Ka ma sab blaman oyakagab ini bwób koke ipudo, a ka sab oya darrpan zitül ekyeno alngomólóm, Deibidünbókamde, kürü zaget pam, akó Zerrusalemónbókamde, ka kólbankü ne wirri basirr ipadórró.” ");
INSERT INTO tof_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Solomon Zerrusalemgab Isrrael 40 pailüm alngomól yarilürr. ");
INSERT INTO tof_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Wa nóma nurrótókórr, oya gapók oya ab Deibidün Basirrdü ilüngóp. Oya olom Rreoboam kingüm bainürr oya pabodó. Tugup bóktan: Rreoboam wata Zuda zitül akó Benzamin zitül nolngomólólórr. Ngibürr Isrrael zitüla oyaka kak semónóp. Zerroboam ibü kingüm bainürr. Rreoboamón balngomól kakóm, ngibürr kinga Zuda pamkolpam idi balngomól kwarilürr kókó Asa kingüm bainürr. ");
INSERT INTO tof_vpl VALUES ("K116_29","012_16_29","1KI","16","29","29","38 Ngim pail ne kla yarilürr, Asa Zudan king nóma yarilürr, Eiabón balngomóla ugón bókyanórr Isrraelóm. King Eiab, Omrrin siman olom yarilürr akó wa Samarria wirri basirrdügab balngomól yarilürr 22 pailüm. ");
INSERT INTO tof_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Wa abün kolae tómbapón yarilürr ⌊Lodón⌋ ilküpdü; ngaen-gógópan ne king kwarilürr, ibükagab wa kolaean yarilürr. ");
INSERT INTO tof_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Wa darrpan tonarr kolae koke tómbapón yarilürr king Zerroboamzan, Nebatón siman olom. A wa ma amkoman kolaean tonarr tómbapón yarilürr oyakagab, zitülkus wa ta akó Yezebelón zumiógürr, Etba-alón óp olom, Saedon wirri basirr king. Da módóga, ene pokodógab wa Ba-alón ⌊ótókóm⌋ we bainürr. ");
INSERT INTO tof_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Wa ⌊alta⌋ Ba-alón ótókóm we elórr Ba-alón tóre müót kugupidü, wa ne müót elórr Samarriam. ");
INSERT INTO tof_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Eiab kol god Aserra oya gyabi talkum we tónggapónórr akó wa ngibürr kolae tómbapónórr. Wa Lodón, Isrraelón God nótóke, ama tai büb bólmyanan akó wirri ngürsilan ngitan yarilürr ngibürr kingdügab, oya singül kwata nidi koralórr. Tugup bóktan: Pail ugón 851 nóma yarilürr, Kerrison amtómól küsilan nóma yarilürr, Eiab ugón nurrótókórr. Ngibürr kinga Isrrael pamkolpam idi nolngomólnóp kókó Osyia kingüm bainürr. Pail ugón 724 nóma semrranórr, Kerrison amtómól küsilan nóma yarilürr, Asirria pamkolpama ugón togobórr Isrrael pamkolpampükü gazirrüm. ");
INSERT INTO tof_vpl VALUES ("K217_5","013_17_5","2KI","17","5","5","Olgabi Asirria king, ngi Salmaneserr, tóba gazirr pampükü wamórr, da Isrrael tüp blaman we ipadórr. I Samarria wirri basirr we kal-kal yangónóp aüd pailüm da blaman basirran barrbün mamtae we ngabkan koralórr paman alo byamkünüm bausgum. ");
INSERT INTO tof_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Osyia Isrrael king, oya 9 ngim pail nóma yarilürr, Asirria kinga ibü ugón yazebórr, da Asirria we imarrurr. Wa ngibürr Isrrael pamkolpam Ala wirri basirrdü irrbünürr, ngibürr Aborr tobarr minggüpanan, Gozan bwóbdü, akó wa ngibürr Isrrael pamkolpam Mid pamkolpamab ngibürr wirri basirrdü irrbünürr. ");
INSERT INTO tof_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Isrrael is igósidi imarruóp, zitülkus ibü kolae tonarranme ⌊Lodka⌋, ibü God, ibü nótó yusürr Izipt kantrridügab, i ne parraoan tangdó nóma kwarilürr. Akó zitülkus i ngibürr god ⌊ótók⌋ kwarilürr ");
INSERT INTO tof_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","akó ngibürr pamkolpamab bókam tumtum mumyamón kwarilürr, Lod ne pamkolpam kolabütan yarilürr ibü obzek kwata. I akó ene dadan kolae bókam tumtum mumyamón kwarilürr, Isrrael kinga ne kla umulbain kwarilürr. ");
INSERT INTO tof_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Isrrael pamkolpama dümdüm-koke tonarr tómbapón kwarilürr Lodka, ibü God, da ibü gyagüpitótók igó yarilürr, wamaka Lod koke asenda. I tóre bwób balmel kwarilürr pododó, ngibürr god bütókóm blaman basirrdü, tai karidügab kókó wirri. ");
INSERT INTO tof_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","I gyabi ingülküp zamngól-zamngól urrbulürr akó Asyerran gyabi talkum zolangólórr blaman pododó akó wirri nugup murrdüma. ");
INSERT INTO tof_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Asirria kinga pamkolpam simarrulürr Babilongab, Kutagab, Abagab, Amatgab, akó Separrbaemgab, da we irrbünürr Samarria wirri ne basirr kwarilürr, Isrrael isab pabodó. I Samarria wirri basirr tibióbkü we ninóp. ");
INSERT INTO tof_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","I ngaen-gógópan nóma ngyabenóm bainóp, i Lodón koke ótók kwarilürr, da wa ⌊laeon⌋ ibüka we zirrtapónóp, da ibü ngibürr we ekrrónóp büdülümpükü, ene laeona. ");
INSERT INTO tof_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Ene bóktan we pupainóp Asirria kingdü wagó, “Ma ne pamkolpam iritürr basirr-basirr Samarriam umul-kókako ini tüpan godón gida. Ini zitülkusdü wa laeon igósidi zirrtapórre ibü akrranóm büdülümpükü. Ibü igósidi akrrandako, zitülkus i umul-kókako ini tüpan godón gida.” ");
INSERT INTO tof_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Da módóga, Asirria kinga ini arüng bóktan nókyenóp wagó, “Darrpan ⌊prrist⌋ zirrapónam e ne nibiób imarruarre. Wa sab ola ki ngyabe pamkolpam umul bainüm ene tüpan godón gida.” ");
INSERT INTO tof_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Da darrpan prrist noan idüdóp ngaen-gógópan Isrrael pamkolpampükü Samarriagab, wa we yalkomólóp Betel ngyabenóm, Samarria bwób kugupidü. Da we umul bain yarilürr Lodón ótókóm. ");
INSERT INTO tof_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","A blaman dakla ne pamkolpam kwarilürr, ma tibiób god we tómbapónóp, da alóngóp tóre pokodó basirr-basirr podo kwitüdü, ibü bütókóm. Ini tóre poko Isrrael pamkolpama tómbapónóp, Samarriam nidi ngyabenónóp ngaen-gógópan. ");
INSERT INTO tof_vpl VALUES ("K218_1","013_18_1","2KI","18","1","1","Ilan olom Osyian, Isrrael king, aüd ngim pail nóma yarilürr, Ezekaea, Eiazón olom, oya balngomóla ugón bókyanórr, kingüm ugón bainürr Zudam. ");
INSERT INTO tof_vpl VALUES ("K218_2","013_18_2","2KI","18","2","2","Ezekaea 25 pail olom yarilürr, wa ne kingüm nóma bainürr. Wa 29 pailüm Zuda bwób Zerrusalemgab alngomól yarilürr. Oya aip ngi Abiza, Zekarraean óp olom. ");
INSERT INTO tof_vpl VALUES ("K218_3","013_18_3","2KI","18","3","3","Wa wata dümdüm tólbael yarilürr ⌊Lodón⌋ ilküpdü, oya abbobata Deibidzan tulmil tómbapólórr. ");
INSERT INTO tof_vpl VALUES ("K218_4","013_18_4","2KI","18","4","4","Wa ene obae godón ⌊alta⌋ gyabi bwóbdü amalórr, akó gyabi ingülküp syórr nangónónóp, akó Asyerran gyabi talkum singgalgólórr. Wa ene Mosesón ayan gwar syórrpókal yangónórr, Moses ne kla tónggapónórr. Ngaendógab kókó ene tonarr ngarkwatódó, Isrrael pamkolpama morroal ilang buru ne klamdó angan kwarilürr ene ayan gwar ⌊ótókóm⌋. I ene ayan gwar igó ngilianónóp, Neustan. ");
INSERT INTO tof_vpl VALUES ("K218_5","013_18_5","2KI","18","5","5","Ezekaean Lodka amkoman bangun asi yarilürr, Isrrael isab God. Darrü babulan yarilürr wazan, blaman Zuda kingdügab, tai ngaen-gógópandógab kókó solodó ne king kwarilürr. ");
INSERT INTO tof_vpl VALUES ("K218_6","013_18_6","2KI","18","6","6","Wa wata karrkukus zamngólórr Lodón mamoanóm akó kokean aupürr. Wa ene gida bóktan poko mamoan yarilürr, Lod Mosesón ne gida iliónürr. ");
INSERT INTO tof_vpl VALUES ("K218_7","013_18_7","2KI","18","7","7","Da igósidi Lod wata wankü asi yarilürr. Wa wata blaman klamdó bórrgrratórrón yarilürr, wa ne kla tómbapón yarilürr. Wa Asirria kingdü bóka bamgün yarilürr akó myamem koke zaget yarilürr oyankü. ");
INSERT INTO tof_vpl VALUES ("K218_8","013_18_8","2KI","18","8","8","Wa Pilistia pamkolpam memokan ekrranórr tai kókó Gaza bwób amrran, da wa blaman ibü basirr kolae ninóp, tai kari basirrdügab kókó wirri basirr amrran. Tugup bóktan: King Ezekaea nóma nurrótókórr, oya siman olom Manase kingüm bainürr oya pabodó. ");
INSERT INTO tof_vpl VALUES ("K221_1","013_21_1","2KI","21","1","1","Manase ugón 12 pail yarilürr, kingüm nóma bainürr. Wa Zuda bwób 55 pailüm alngomól yarilürr Zerrusalemgab. Oya aip ngi Epziba. ");
INSERT INTO tof_vpl VALUES ("K221_2","013_21_2","2KI","21","2","2","Wa kolaean elklaza tómbapón yarilürr ⌊Lodón⌋ ilküpdü. Wa ngazirr elklaza tómbapón yarilürr, ngibürr bwóbdü pamkolpamazan tómbapónónóp, Lod Isrrael pamkolpamab obzek kwata nibiób kolabütan yarilürr. ");
INSERT INTO tof_vpl VALUES ("K221_3","013_21_3","2KI","21","3","3","Wa ene dadan obae godón ⌊alta⌋ akó tómbapón yarilürr wirri kwitüm dorrodó, oya aba Ezekaea ne kla kolae ninóp. Wa akó alta Ba-alón ⌊ótókóm⌋ we elórr akó Asyerran gyabi talkum zolangólórr, Eiab Isrrael kingazan kainürr. Manase ta wimurrdü tórewóm yarilürr akó ibü bütók yarilürr. ");
INSERT INTO tof_vpl VALUES ("K221_4","013_21_4","2KI","21","4","4","Lod ngaen-gógópan igó poko bóktanórr wagó, “Kürü wata sab kólba müótüdü ótók kwarile Zerrusalemóm.” A Manase ama Lodón ⌊Gyabi Müótüdü⌋ ngibürr godab alta balmelólórr. ");
INSERT INTO tof_vpl VALUES ("K221_5","013_21_5","2KI","21","5","5","Wa alta balmelórr, Lodón Gyabi Müótan kal akólórrón pul basirr nisdü, wimurr ótókóm. ");
INSERT INTO tof_vpl VALUES ("K221_6","013_21_6","2KI","21","6","6","Wa tóbanan siman olom urdü yungürr ene ngibürr god bütókóm. Wa irrüb ut azil akó nus ut yarilürr. Wa ta bóktan arrkrru yarilürr büdül mórrkepükü ne pamkolpama ikikdako, ó samudügabi nidi umul baindako solkwat ne tonarra tómbapónórre. Wa kari kolae koke tómbapón yarilürr Lodón ilküpdü, akó inzana wa Lodón ngürsilan ngitan yarilürr. ");
INSERT INTO tof_vpl VALUES ("K221_10","013_21_10","2KI","21","10","10","Da Lod tóba zaget pam, ⌊prropet⌋ nidi kwarilürr, nilóp bóktanóm wagó, ");
INSERT INTO tof_vpl VALUES ("K221_11","013_21_11","2KI","21","11","11","“Manase, Zudan King, ngazirran tulmil tómbapólórr, akó wa kolaean kla tómbapónórr Amorr pamkolpamdógabi, oya singül kwata nidi ngyaben kwarilürr. Wa ta Zuda pamkolpam kuri imarrurr kolae tonarr tómbapónóm ngibürr obae god bütókóm, tüóbzan tómbapólórr. ");
INSERT INTO tof_vpl VALUES ("K221_12","013_21_12","2KI","21","12","12","We ngarkwatódó, ka Lod, Isrrael isab God, igó bóktandóla kagó, ‘Ka di ódóddóla Zerrusalem akó Zuda ibüka. Sab blaman ne güblanga barrkrrue, sab gübarirr aengrre. ");
INSERT INTO tof_vpl VALUES ("K221_13","013_21_13","2KI","21","13","13","Ka sab Zerrusalem kulaino. Oya kolae sab we ngarkwatódó yarile, ka Samarria wirri basirr akó Eiabón tóba olmalbobatalpükü ne ngarkwatódó nókyarró. Ka sab Zerrusalem pamkolpam inzan kolae ninünümo metatómpükü, amaka kübül amzazirrün akó amasórróna, myamem darrü alo burul babul. ");
INSERT INTO tof_vpl VALUES ("K221_14","013_21_14","2KI","21","14","14","Ka sab kólba ini dómdóm bamirrün pamkolpam popa bimgüto. Ka sab inkü nidi gazirrdako sab irrbuno ibü tangdó. Ibü elklaza sab idi yazebrre arüng tulmili, ");
INSERT INTO tof_vpl VALUES ("K221_15","013_21_15","2KI","21","15","15","zitülkus i kürü ilküpdü kolae tómbapón kwarilürr akó kürü ngürsilan ngitan kwarilürr, ene ngürrdügabi ibü abalbobatala Iziptgab nóma togobórr, tai kókó ini ngürr.’” ");
INSERT INTO tof_vpl VALUES ("K221_16","013_21_16","2KI","21","16","16","Manase Zuda pamkolpam obae god bütókóm imarrulürr, da i ma igósidi kolae tómbapón kwarilürr Lodón ilküpdü. Akó ene tumum wa abün kolae tómbapón-koke pamkolpam akrran yarilürr büdülümpükü. Ibü óea Zerrusalem wirri basirr gwarranórr, dakla kubdügab tai kókó dakla kub. ");
INSERT INTO tof_vpl VALUES ("K222_1","013_22_1","2KI","22","1","1","Zosaea 8 pail olom nóma yarilürr, oya balngomóla ugón bókyanórr. Wa Zerrusalemgab 31 pailüm balngomól yarilürr. Oya aip ngi Zedida, Adayan óp olom, Bozkat wirri basirrdügab. ");
INSERT INTO tof_vpl VALUES ("K222_2","013_22_2","2KI","22","2","2","Wa dümdüm kla tómbapón yarilürr ⌊Lodón⌋ ilküpdü. Wa akó tóba abbobat Deibidün wapór gaodóma akyan yarilürr akó kokean azyónürr, tutul kwata akó banól kwata. Tugup bóktan enekwata sapta 22:3-10: Zosaea ngibürr pam we nilóp LODón ⌊Gyabi Müót⌋ tónggapónóm. I nóma tónggapón kwarilürr, i Mosesón ene ⌊arrngamórrón gida peba⌋ ugón esenóp, da we sidüdóp Zosaeaka. ");
INSERT INTO tof_vpl VALUES ("K222_11","013_22_11","2KI","22","11","11","Kinga Lodón bóktan nóma arrkrrurr atangde, mórrkenyórr we nütürróp tóba bübdü ne gyaur akó müp pupainüm. ");
INSERT INTO tof_vpl VALUES ("K222_12","013_22_12","2KI","22","12","12","Wa we nilóp prrist Ilkaea, A-ikam, Syapan olom nótó yarilürr, Akborr, Mikayan olom nótó yarilürr, Syapan, peba wibalóm olom, akó Aesaya, tóba zaget pam, ");
INSERT INTO tof_vpl VALUES ("K222_13","013_22_13","2KI","22","13","13","ini bóktan wagó, “Ugó ogob, Lodón amtinüm ini peban bóktanankwata. Da kürüka müsirrga sinamke akó blaman ini Zuda isdü, zitülkus Lodón ngürsila urazan baebda mibüme. Zitülkus módóga, mibü abalbobatala ta ini peban bóktan kokean arrkrru kwarilürr. Ibü tórrmen tulmil ene bóktan ngarkwatódó koke kwarilürr, mi ne poko ki mumyamónórre.” Tugup bóktan enekwata sapta 22:14-15: Zosaea ngibürr ngi pam we zirrnapónóp Godón kol prropetódó, ngi Ulda. Da wa ibü ini bóktanpükü zirrnapónóp kingdü. ");
INSERT INTO tof_vpl VALUES ("K222_16","013_22_16","2KI","22","16","16","“Lodón bóktan yóni wagó, ‘Tübarrkrru! Ka sab kolae sidüdo ini Zuda tüpdü akó pamkolpamdó blaman ini peban bóktan ngarkwatódó, Zuda kinga ne poko etangórr. ");
INSERT INTO tof_vpl VALUES ("K222_17","013_22_17","2KI","22","17","17","I kürü kümgütrre akó ngibürr godódó morroal ilang buru angan kwarilürr, akó kürü ngürsilan ngigütirre ngibürr tange tólbaelórrón elklaza ⌊ótókde⌋. We ngarkwatódó, kürü ngürsila sab urazan tóbaebe ini bwóbdü akó sab atamün nabe yarile.’ ");
INSERT INTO tof_vpl VALUES ("K222_18","013_22_18","2KI","22","18","18","Ene Zuda king, yabü nótó zirrtapórre Lodón bóktan amtinüm, bóktan izazilamke magó, ‘Lod, Isrrael isab God, inzan yarile ene bóktanbóka, ma ne bóktan arrkrrua: ");
INSERT INTO tof_vpl VALUES ("K222_19","013_22_19","2KI","22","19","19","Ma amkoman arrkrruo, ka, Lod, ini basirrankwata nóma bóktóna akó pamkolpamabkwata. Ka igó bóktóna kagó, “I sab ngazirr obzek kwarile akó ngibürr pamkolpama ibü ngi amórr bóktandó ingrirre.” A ma nóma arrkrrua, moba moboküpdü ma kari gyaur koke namüla. Ma moba ngi tüp elkomóla kürü obzek kwata. Ma moba mórrkenyórr nütürrnüma akó yón namüla kürü obzek kwata, da ka marü igósidi murrkrrua. ");
INSERT INTO tof_vpl VALUES ("K222_20","013_22_20","2KI","22","20","20","We ngarkwatódó, ma sab nóma nurrótoko, marü sab paudi moba abalbobatalpükü mülüngrre. Marü ilküp nisa sab ini di koke eseni, ka sab ne kla zirrsapono ini pokodó.’” Da i kingdü bakonórr, blaman poko we izazilóp. ");
INSERT INTO tof_vpl VALUES ("K223_1","013_23_1","2KI","23","1","1","Da kinga blaman byarrmarr balngomól pam we ngibaunürr kwób bazenóm, Zudagab akó Zerrusalemgab. ");
INSERT INTO tof_vpl VALUES ("K223_2","013_23_2","2KI","23","2","2","Wa we kasilürr ⌊Lodón⌋ ⌊Gyabi Müótüdü⌋. I usakü ogobórr, blaman pamkolpam Zudagab akó Zerrusalemgab, prrist, prropet, akó blaman pamkolpam, ia wa ngi pama o popa pam. Da wa Lodón dudu Alkamül-koke Tónggapórrón Bóktan Peba ibüka we etanglórr, ne kla esenóp Lodón Gyabi Müótüdü. ");
INSERT INTO tof_vpl VALUES ("K223_3","013_23_3","2KI","23","3","3","Ene kakóm, kinga we zamngólórr tóba talkum minggüpanan. Wa alkamül-koke tónggapórrón bóktan ingrinürr Lodón obzek kwata, oya mamoanóm, akó oya gida bóktan poko akó arüng bóktan gangga arrbünüm dudu moboküpi akó dudu samu-i, akó ini alkamül-koke tónggapórrón bóktan tórrmendó arrbünüm, pebadó ne poko wibalómórrón kwarilürr. Da blaman pamkolpama ene alkamül-koke tónggapórrón bóktan we yazebóp. ");
INSERT INTO tof_vpl VALUES ("K223_4","013_23_4","2KI","23","4","4","Da kinga Ilkaea, singüldü prrist nótó yarilürr, akó ene prrist, olgab ngi nidi amorran kwarilürr, akó Lodón Gyabi Müótan mamtae nidi ngabkan kwarilürr, ibü we nilóp, Lodón Gyabi Müótüdügab blaman kolae elklaza ausüm, Ba-al akó Asyerra ibü ⌊ótókóm⌋ ne kla tómbapónóp, akó blaman wimurr ótók elklaza. Módóga, blaman ene elklaza urdü we yamselóp Zerrusalem wirri basirr kalkuma, Kidrron buruburudü, a urtók buru ama Betel imarruóp. Tugup bóktan enekwata sapta 23:4-20: Da Zosaea blaman Zuda akó Isrrael kantrridüma we wamlórr, ene tórewóm poko kolae bainkü, pamkolpama tange tómbapórrón godpókal ne ótók kwarilürr, akó ene prrist, obae godónkü nidi zaget kwarilürr, we zirrnapónóp. Zosaean solkwat ne kinga balngomól kwarilürr, Godón koke ótók kwarilürr, a i ama oyaka kolae tonarr tómbapón koralórr. ");
INSERT INTO tof_vpl VALUES ("R236_14","015_36_14","2CH","36","14","14","Blaman Zuda balngomól ⌊prrist⌋ akó blaman pamkolpam, ibü ta amkoman banguna blakónórr, da i akó dadan kolae we tómbapónónóp mogob pamkolpama ne ngazirr kla tómbapón koralórr, obae god elklaza tómbapónde akó ⌊ótókde⌋. I ⌊Lodón⌋ Müót inzan kolae tulmili ⌊tómanan⌋ ngitanónóp, Lod tüób ne müót gyabi yónürr. ");
INSERT INTO tof_vpl VALUES ("R236_15","015_36_15","2CH","36","15","15","Lod tüób, ibü abalbobatalab God, ibü metat ikik bókrran yarilürr, tóba ⌊prropeta⌋ ibüka nóma bóktan kwarilürr, zitülkus oya gyaur asi yarilürr tóba pamkolpamabkü akó tóba Müótankü. ");
INSERT INTO tof_vpl VALUES ("R236_16","015_36_16","2CH","36","16","16","A i Godón menyam pam ngüóng bóngyal kwarilürr, ibü bóktan alzizi aman koralórr, akó prropet ⌊tiz bangón⌋ koralórr, kókókó Lod ngürsilüm we bainürr. Oya güb ain myamem nabe yarilürr. ");
INSERT INTO tof_vpl VALUES ("R236_17","015_36_17","2CH","36","17","17","Da God Babilonia isab king we zirrsapónórr Zuda pamkolpamdó. Ibü küsil pam we ekrrónóp gazirr turriki, Lodón ⌊Gyabi Müótüdü⌋. Kingan gyaur babul yarilürr, wa ia küsil pam yarilürr, ia küsil kol, ia epep myang, ta ia arüng-koke. God blaman pamkolpam wata kingan tangdó irrbünürr. ");
INSERT INTO tof_vpl VALUES ("R236_18","015_36_18","2CH","36","18","18","Ene Godón Gyabi Müótüdü ne elklaza kwarilürr, ia wa wirri darrem kla ó ia kari darrem klama, akó Gyabi Müótüdü ne mórrel kwarilürr, wa blaman we imarrurr ama Babilon. I ta akó kingan akó oya ngi pamab mórrel blaman yazebóp. ");
INSERT INTO tof_vpl VALUES ("R236_19","015_36_19","2CH","36","19","19","Godón Gyabi Müót uri amzikóp akó Zerrusalem wirri basirr ne kotarra amarükürrün yarilürr, ene kotarrpükü ta ilgütóp. Wirri pamab morroal wirri müót blaman sentenóp akó wirri darrem elklaza kolae nyónónóp. ");
INSERT INTO tof_vpl VALUES ("R236_20","015_36_20","2CH","36","20","20","Gazirr turrik nidi nurutóp, ibü Babilon we barrmünürr. Babilonia kinga ibü ⌊leba zaget⌋ tómbapónóm we irrbünürr tóbankü akó olmalabkü, kókó Saerrus, Perrsia king, bwób nóma ipadórr. ");
INSERT INTO tof_vpl VALUES ("R236_21","015_36_21","2CH","36","21","21","Ene igósüm, Lodón bóktana küppükü bainürr, Zerremaea ne bóktan simaikürr wagó, “Tüpa piküp ngyabele, 70 pailüm ngón agóle tóba ngón agón morroal apadóm, wa koke ne ngón agón ipadórr abün pailüm.” ");
INSERT INTO tof_vpl VALUES ("R236_22","015_36_22","2CH","36","22","22","Zerremaean taedógab ne bóktana tubrranórr, Lod oya ne poko ekyanórr, Lod ene bóktan küppükü yónürr. Ngaen-gógópan pail ne kla yarilürr, king Saerrus Perrsia nóma alngomól yarilürr, Lod ini gyagüpitótók ekyanórr oya moboküpdü, zürük bóktan angrinüm akó wialómóm tóba dudu kantrriankü. ");
INSERT INTO tof_vpl VALUES ("R236_23","015_36_23","2CH","36","23","23","Wagó, “Perrsia kantrrian king Saerrus igó bóktanda wa, ‘Lod, kwitüm God, ini tüpdü blaman kingan bwób kürü kuri küline. Wa kürü kuri küngrine oyankü müót aelóm Zerrusalemóm, Zuda kantrridü. Ma ne oya pam nótó nóma namulo, Lod marü God asi ki yarilün mankü, da ma podo kasilke, ene müót akó aelóm.’” ");
INSERT INTO tof_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Lod kürü ngakan pama, kürü wató alngomólda; Ka igósidi darrü kla koke arendóla. ");
INSERT INTO tof_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Wa kürü morroal mórrel bwóbdü mórran-mórran ainda. Wa kürü alngomólda morroal piküp güb arób naedó. ");
INSERT INTO tof_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Wa kürü küsil arüng akyanda. Wa kürü dümdüm kwatódóma alngomólda, tóba morroal ngianme. ");
INSERT INTO tof_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Enana ka agóltagóldóla güm algón-koke tümün kwatódóma, kürü kolaedó gum babula, zitülkus ma kankü asinla. Marü bidam wóp akó tupuru, kürü ini nis klama adlangdamli. ");
INSERT INTO tof_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Ma kürünkü alongalo tóre tónggapóna, kürü gómdamal-koke nidipko, ibü wapi; Ma kürü singül ⌊olib⌋ oele kóngangoa, kürü morroal apadóm, marüme, kürü kübüla byamróke tai kókó ib. ");
INSERT INTO tof_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Amkoman, marü morroal tonarr akó gyaur sab kürüka asi namüli kürü ngyabendó, akó ka sab Lodón Müótüdü ngyaben namulo metat. ");
INSERT INTO tof_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Yao, mi kya ⌊Lodónkü⌋ wórr atonóm bagürwómpükü! Yao, mi kya taegwarr apónónóm bagürwómpükü oyankü, mibü zidbain ingülküp nótóke! ");
INSERT INTO tof_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Mi kya oya obzek kwata togobón oya eso akyanóm, mi kya taegwarr apónónóm bagürwómpükü wórri oya agürüm. ");
INSERT INTO tof_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","Zitülkus módóga, Lod wirri arüng Goda, wa wirri arüng Kinga blaman godódógab. ");
INSERT INTO tof_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Aumana tüp oya tangdóma, akó wirri kwitüm podo ta oya tangdómako. ");
INSERT INTO tof_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Malu oyane, zitülkus wató tónggapónórr; akó oya tanga dorro tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yao, mi kya singül tüp alókóm togobón oya ⌊ótókóm⌋! Mi kya wakósingül nümgününüm oya obzek kwata, Lod mibü Tómbapón Pam! ");
INSERT INTO tof_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Zitülkus módóga, wa mibü Gode, akó mi oya apapdó pamkolpamakla, mi sipzanakla, wa ne ⌊sip⌋ ngabyónda. Errkya, e wata ki barrkrrua God ne poko bóktanda! ");
INSERT INTO tof_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Wirri-singül bain-gu yabü abalbobatalazan Merribamzan kainóp, akó i Masamzan kainóp, ene ⌊ngüin-koke bwóbdü⌋, ");
INSERT INTO tof_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","i kürü nóla apók kwarilürr, enana i kürü kósenóp, ka ne morroal kla tómbapón namülnürrü ibüka. ");
INSERT INTO tof_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","40 Pailüm ka inkü ngürsil namülnürrü, ene Isrrael pamkolpam, ene tonarrdó nidi ngyaben kwarilürr. Da ka we bóktarró kólbabóka kagó, ‘Ibü ubi wata metat tibiób ubi kwata tótókóma, akó i bangóndako ka ne poko tómbapónóm byaldóla.’ ");
INSERT INTO tof_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Ka ngürsil namülnürrü, da ka igó ⌊arüng alkamül-koke bóktan⌋ ingrirrü kagó: ‘I sab kürü ngón bagón bwóbdü kokean barrbüne ngón bagónóm!’” ");
INSERT INTO tof_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Lod God igó bóktanórr kürü Lodódó wagó, “Ma ae mórra ini wirri pabodó, kürü tutul tangdó, kókó ka sab marüka nidi bóka bamgündako, ka sab ibü inzan ninünümo, marü wapór nisab ngón ngagón klamóm.” ");
INSERT INTO tof_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Lod sab marü kingan arüng mókyene Zaeongab. Ma sab wirri pam namulo; marüka nidi bóka bamgündako, ma sab ibü aodógab balngomól namulo! ");
INSERT INTO tof_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Marü gazirr pama sab wata ubi bain kwarile marü gazirr ngürr nóma semrrale. Amaka glesa aupda irrbi, sab marü küsil pama inzan togobe marüka, gyabi wi agótórrón mórrkenyórrpükü. ");
INSERT INTO tof_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Lod ⌊arüng alkamül-koke bóktan⌋ kuri ingrinürr ó wa sab koke alkamüle: “Ma metat ⌊prristla⌋, wata Melkizedekzan yarilürr.” ");
INSERT INTO tof_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Lod marü tutul tangdó asine marü tangamtinüm. Oya wirri ngürsila ne ngürrdü simige, sab ngibürr king memokan ekrrale. ");
INSERT INTO tof_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Wa sab bwób-bwób pamkolpam zaz nirre, gazirr pokodü pamkolpamab büdül murua sab barüme. Wa sab ini tüpan singüldü pam blaman memokan baem napórre. ");
INSERT INTO tof_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Wa sab kwat-kwat aróbdó nae enóle, da wa sab wapór igósidi karrkukus nürtümüle akó singül ugón kwit ine. ");
INSERT INTO tof_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Ia küsil pama ⌊kolkal⌋ ia ngyaben yarile? Wata wa marü bóktan ngarkwatódó ngyaben yarile! ");
INSERT INTO tof_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Ka marü amkoman moboküpi mamoan namulo. Kürü tangkamti, marü gida bóktan poko alkomólgum. ");
INSERT INTO tof_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Ka marü bóktan kólba moboküpdü kuri gangga irrbüna, marüka kolae tonarr tónggapón-gum. ");
INSERT INTO tof_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Lodóe, ka marü agürdóla. Kürü moba ngyaben gida bóktan umul kyó. ");
INSERT INTO tof_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Kürü taea sab marü ene gida bóktan blaman tonarr arük yarile, marü taedógab ne gida bóktana bausdako. ");
INSERT INTO tof_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ka bagürwómdóla, ka marü bóktan ngarkwatódó nóma ngyabendóla, pamazan bagürwómda tóba mórrelanbókamde. ");
INSERT INTO tof_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ka marü arüng bóktan metat gyagüpi amandóla, ka marü ngyaben bóktan tai ngabkandóla metat. ");
INSERT INTO tof_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Ka kari ubi kokela marü ngyaben gida bóktan amorranóm, akó ka sab marü bóktan kokean ngómkó nómkónónómo. ");
INSERT INTO tof_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Aesaya ⌊Lodón⌋ darrü bóktan okaka imzazilürr king Eiazka wagó, ");
INSERT INTO tof_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Imti Lodón, ma ne God ⌊ótókdóla⌋, darrü ⌊wirri tulmil⌋ pupainüm marü tangamtinüm oya bóktan amkoman angunüm, ia tai aumana büdülab bwóbdügab tame, ó ta ia wirri kwitümgab.” ");
INSERT INTO tof_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","A Eiaz ma bóktan yalkomólórr wagó, “Ka wirri tulmilüm koke imtino. Ka Lodón apókóm kokela!” ");
INSERT INTO tof_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Ene pokodó, Aesaya wató bóktan yalkomólórr wagó, “Da tübarrkrru, king ⌊Deibidün⌋ Müót kolpam! Yabüka ia gaodó kokea pamkolpam genggorraman ngibtanóm? E akó ia Godón, ka ne God ótókdóla, genggorraman ngitanóm kaindakla, yabü ubi babulzane oya darrü klamóm amtinüm? ");
INSERT INTO tof_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Da taia, ezan bangóndakla amtinüm, Lod sab tüób yabüka okaka simzazile darrü wirri tulmil. Tübarrkrru, pampükü koke ne kola umtulürr, sab bikóm ipüde, da wa sab siman olom esene, da wa sab ngi ngyesile Emanuel.” ");
INSERT INTO tof_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","“Oloma kuri tómtómóle mibünkü! Siman olom mibü akyarróna! Da balngomól sab oya tangdó yarile. Oya sab ngilianórre, ‘⌊Asen-koke Tórrmen⌋ Tómbapón akó Ikik Bókrran Pam’, ‘Wirri Arüng God’, ‘Metat Ngyaben Ab’, akó ‘Paud Ngyaben Ódód Singüldü Pam’. ");
INSERT INTO tof_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Oya balngomóla akó oya balngomóla ne paud ódódda wata dódórr bain yarile metat. Wa sab balngomól yarile, king Deibidün pabo apad pamzan, wa sab balngomól yarile king Deibidün alngomól bwób. Wa ene balngomól bwób tónggapóne akó ngakan yarile dümdüm tulmili akó ⌊dümdüm tonarre⌋ ini tonarrdógabi akó metat-metat. Wirri Arüng ⌊Lod⌋ wa wirri ubia ini kla tómbapónóm.” ");
INSERT INTO tof_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","⌊Prropeta⌋ bóktan yalkomólóp wagó, “Ki ne bóktan büdrrat kwarilnürrü, ia nótó kuri amkoman yangune? Ia ⌊Lod⌋ tóba arüng noaka kuri okaka simzazile? ");
INSERT INTO tof_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Ene wa Lodón ubi yarilürr wa, oya zaget pama dódórr baine kari nugup kumabzan oya obzek kwata, wamaka simkündügab kuba amtómólda mólóg tüpdü. Oyaka darrü morroal obzek ó amerr zyón babul yarilürr mibü ngakanóm oya. Oya büban obzek morroal koke yarilürr, mi ubi bainüm oyaka. ");
INSERT INTO tof_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Pamkolpama oya koke ok inóp a i ma oya alzizi amaiknónóp, wa wirri azid aengórr, akó wa azid aengbóka umul yarilürr. Wa inzan olom yarilürr, pamkolpama tibiób obzek noakagabi nalüngóp. Pamkolpama oya alzizi amaiknónóp akó mi oya morroal koke yangónóp. ");
INSERT INTO tof_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","“Anda, mibü blaman azid wa tüób bamselórr akó wa azid aengórr mibü pabodó. A mi igó gyagüpi ogobnórró wagó, oya azid aeng wata God wató sekyanórr tóba kolae tonarran darrem apadóm. ");
INSERT INTO tof_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","A ene mibü gida amgünanbókamde, oya gaopükü emkalnóp óeande, oya bidame emkalnóp, mi ne kolae tonarr tómbapónónóp. Oyaka ne ⌊kolaean darrem⌋ yamselnóp, mibüka paud sidódürr; oya sosoanme mi dólóng bairrünakla. ");
INSERT INTO tof_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Mi blaman apól kwarilnürrü, bamrükürrün ⌊sipzan⌋, mi blamana mibiób ubi kwata bagólnórró. Da Lod mibü kolae tonarr oyaka yamselórr, ene kolaean darrem mi ne kla ki ipüdórre. ");
INSERT INTO tof_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Oya kari kolae amkal koke emkalnóp, a wa wata piküp yarilürr, wa darrü poko kokean bóktanórr. Oya sip kupozan idüdóp bódabón pokodó. Sipazan zamngólda bóktan-koke, ngüin alük paman obzek kwata, wa darrü poko kokean bóktanórr. ");
INSERT INTO tof_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Oya amiógdi akó zaz aindi, oya we idüdóp büdülüm. Darrü oloma gyaur koke esenórr, oya ne arról itülóp. Wa kolae tonarran darrem ipadórr mibü pamkolpamab kolae tonarrabme. ");
INSERT INTO tof_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Oya gapókdó ingrinóp kolae tonarr pampükü, oya gapók ilüngóp mórrel pam ne gapók balüngdako, enana wa darrü kolae kokean tónggapónórr, akó darrü pam babula ilklió bülión bóktan nótó arrkrrurr oya ulitüdügab. ");
INSERT INTO tof_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","“A ene Lodón ubi yarilürr oya amkalóm bidame akó oya azidan ngitanóm. Oya büdül sab ⌊urdü agasil larzan⌋ yarile kolae tonarr barrgonóm. Olgabi wa sab tóba olmalbobatal nóserre; wa sab wirri kokrrap ngyabene, akó oyabókamde Lodón ubia sab amkoman tómbapóne. ");
INSERT INTO tof_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Azid aeng kakóm, wa sab morroal ngyaben yarile. Wa sab umul yarile wagó, wa küp-koke pokodó koke azid aengórr. Lod bóktanda wagó, ‘Kürü dümdüm zaget pama sab abün pamkolpamab kolae tonarr bamsele akó oyabókamde, ka sab ibü ⌊dümdüm tonarr⌋ pamkolpamóm ninünümo. ");
INSERT INTO tof_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","We ngarkwatódó, ka sab oya wirri ngi mórran poko ekyeno, ka sab oya mórran poko ekyeno arüng pampükü. Zitülkus módóga, wa tóba arról ekyanórr akó nurrótókórr, akó oya igó ngakónóp wagó, wa gida amgün pama. Wa abün pamkolpamab gida amgün bamselórr akó wa kürüka tóre ugósüm ekorr, ka ibü kolae tonarr iade ki amóna.’” ");
INSERT INTO tof_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","“⌊Lod⌋ Godón Samu kürükama, zitülkus wa kürü küngrinürr morroal bóktan büdrratóm elklaza-koke pamkolpamdó. Wa kürü ugósüm zirrkapónórr ibü dólóng byónüm, yón-gyauri nidi ngyabendako, akó igó bóktan amgolóm wagó, ka sab ibü panzedó suso, ⌊ut-ut bairrün⌋ pamkolpam tümün müótüdü iszan nidipko, akó aurdü amono tümün müótüdü nidipko. ");
INSERT INTO tof_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Wa kürü zirrkapónórr bóktan amgolóm wagó, ene tonarr kari pokoa Lodón tóba morroal tonarr pupo ainüm, akó ene tonarr kari pokoa God ⌊kolaean darrem⌋ aliónüm, wankü nidi bóka bamgündako. Wa kürü zirrkapónórr ibü zao-zao bainüm, nidi yón gyaurdako, ");
INSERT INTO tof_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","akó Zaeonóm nidi yón gyaurdako, ibü igó elklaza aliónüm agurr kingan müóngdur, a urtók buru koke, bagürwóm, a yón gyaur koke, agür wórr, a wirri gyaur koke. I sab morroal nugupzan korale, Lod tüób ne kla iritürr. I sab blamana tómbapónórre dümdüm ne klamko, akó ngibürr pamkolpama Godón ngi wirri kwitüm emngyelnórre wa ne kla tómbapólórr.” ");
INSERT INTO tof_vpl VALUES ("IS61_8","024_61_8","ISA","61","8","8","Lod bóktanórr wagó, “Kürü wirri ubia dümdüm tulmilüm, a ka alzizi amanikdóla gómól tonarr akó ngibürr ne kolae tonarrko. Ka sab kólba pamkolpam darrem kla aliónüm, ka ne poko bóktarró tónggapónóm, akó ka sab ⌊alkamül-koke tónggapórrón bóktan⌋ ingrino usakü. ");
INSERT INTO tof_vpl VALUES ("IS61_9","024_61_9","ISA","61","9","9","Ibü olmalbobatal sab umulürrün pamkolpam korale blaman bwób-bwób, ibü olmalbobatal sab umulürrün korale blaman pamkolpamab aodó. Blamana ibü nidi nósenórre, sab emzyetórre wagó, ene is módógako, ka Lod nibiób bles ninarre.” ");
INSERT INTO tof_vpl VALUES ("IS61_10","024_61_10","ISA","61","10","10","Zerrusalem bóktando wagó, “Ka Lodón wirri barnginwómi yagurlo, ka Godón bagürwómi yagurlo. God kürü zid baini püti kyónürr morroal mórrkenyórrzan, akó tóba ⌊dümdüm tonarr⌋ errkya kürükama kokrrap mórrkenyórrzan, wamaka kol amióg pama müóngdur batene ⌊prristzan⌋, wamaka pam amióg kola tóba püti baindo agurr büb püti ain klame.” ");
INSERT INTO tof_vpl VALUES ("IS61_11","024_61_11","ISA","61","11","11","Zid küpazan bamkenda tüpdü, da dódórr bainda, akó didiburrdü ne aritürrün zid küpa bamkenda, Lod God sab dümdüm tonarr dódórr ine akó pamkolpama sab oya agür bókyerre, kókó blaman bwób-bwób pamkolpama dümdüm ngyaben akó oya agür korale. ");
INSERT INTO tof_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Darrpan ngürr Lod Zonan, Amitaen olom, bóktan ekyanórr. ");
INSERT INTO tof_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Wagó, “Ma ugó bupa Ninebe tótókóm, ene wirri basirrdü, da wirri arüngi bóktanke pamkolpamdó ibü kolae tonarrabkwata, zitülkus ka umulóla i ia kolae kolpamako.” ");
INSERT INTO tof_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","A Zona bupadórr, da Lodón we kórzyónürr. Oya ubi darrü wirri basirrdü tótókóm yarilürr, ngi Tarrsyis, Spein kantrri kugupidü. Wa we tübinürr ama Zopa wirri basirrdü, malu kabedó. Wirri but we esenórr, nóma bupadóm kailürr ama Tarrsyis. Wa but darrem ekyanórr, we kasilürr butan zaget pampükü, ama Tarrsyis tótókóm. Oya gyagüpitótók inzan yarilürr wamaka, “Lod ola babulase.” ");
INSERT INTO tof_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","I nóma baurr kwarilürr, Zona ugón but kugupidü abinürr utüm. A Lod wirri wór zirrsapónórr ene maludü. Wór kari arüng koke yarilürr; ene buta kolae bainüm kain yarilürr. ");
INSERT INTO tof_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ene butan zaget pama kari gum koke yón taegwarr kwarilürr tibiób tangbamtinüm, darrpan-darrpan tibiób godódó. Tibiób but ul ainüm, i elklaza we aman kwarilürr maludü. Zona ma ugón but kugupidü büdül ut yarilürr. ");
INSERT INTO tof_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Up oloma we tamórr. Oyabóka wagó, “Ma iade utdóla? Bupa, moba godódó ugó górrga! Wa ne kubó gyagüpitótók nóma ipüde, mi kubó oyame koke nurrbarino!” ");
INSERT INTO tof_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Da butan zaget pama bamtinóp tibiób wagó, “Ngi asen kla ugó amónam. Mi kubó ene olom eserre mibü kolaedó nótó sirrbüne.” Nóma amónóp, Zonan ngia tamórr. ");
INSERT INTO tof_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","I Zonanbóka wagó, “Gyaurka, ma kibü errkyadan tüzazilnünümo ini müp nótó sidüde? Ma aini ia kaindóla? Ma nadü bwóbdügabi tama? Ma laró bóktan olomla?” ");
INSERT INTO tof_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Zona bóktan yalkomólórr wagó, “Ka Ibrru pamla, ka Lodón gum-gum ⌊ótókdóla⌋, kwitüm God, tüp a malu nótó tónzapónórr.” ");
INSERT INTO tof_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Wa akó we bóktanórr ibüka wagó, “Ka Lodkagabi busodóla!” Ene pam gum kwarilürr, i nóma barrkrrurr, da Zonan we ilóp wagó, “Ma ia laró tónggapóna? Kari kolae koke!” ");
INSERT INTO tof_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Da malua tai kolae bain yarilürr, kókó amkoman kolaedó. Butan zaget pama we imtinóp wagó, “Ki marü ia mangórre ini wór piküp ainüm?” ");
INSERT INTO tof_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Zona ibüka wagó, “Kürü kwit kinam akó maludü kümaikam. Malua kubó igósidi zao-zao baine. Ka umulóla, trrez kótó sidüda, e ini wirri wórdü aebókamde tóbaogane.” ");
INSERT INTO tof_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Güblang-koke, butan zaget pama krrabe atül kwarilürr tibióbnüm arüngi, ene but kórrgópdó ódódóm. Da i gaodó koke kwarilürr, zitülkus malua tai balóng obzek bainürr. ");
INSERT INTO tof_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Da i Lodka górrgónóp wagó, “Lod, gyaurka, ma kibü büdüldü amarrugu Zonan arról alakónóm. Ini kórsan oloman büdül müp sab kidi koke ipüdórre. Mató, Lod, blaman klama marü ubi ngarkwatódó tómbapóndako.” ");
INSERT INTO tof_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Da i Zonan ipüdóp, kwit inóp, ó amanikóp maludü, da ene malua we amkónórr. ");
INSERT INTO tof_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Da módóga, ene tonarr kakóm, i Lodón wirri gum we ipüdóp. I darrü lar we emkólóp oya eso akyanóm akó i oya tibiób ⌊arüng alkamül-koke bóktan⌋ ekyenóp. ");
INSERT INTO tof_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Lod tüób wirri wapi we zirrsapónórr Zonan adarüküm. Wa wapian dupidü aüd ngürr akó aüd irrüb ngyabelórr. ");
INSERT INTO tof_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Tai auma wapian dupidü, Zona tóre olgab ekorr ⌊Lodka⌋, tóba Godka ");
INSERT INTO tof_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","wagó, “Kólba ini müpdü, Lod, ka marü ngimliarró, da ma kürü bóktan kuri salkomóla. Ini büdülab bwóbdügab, ka marüka tangbamtinüm górrgarró, da ma kürü kurrkrrua. ");
INSERT INTO tof_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Lod, ma kürü kümaikürrü wirri buku bwóbdü, tai kókó ka malu tüp emrrarró, kürü blaman naea ne mamtae kotarr kónómórr, ó blaman marü ne arüng goblol kwarilürr, kürü kwitana arrgrrat kwarilürr. ");
INSERT INTO tof_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Kürü gyagüpitótók igó yarilürr kamaka, ‘Ma kürü metatómpükü alzizi kümanika mobakagabi, ó ka marü ⌊Gyabi Müót⌋ sab myamem kokean eseno.’ ");
INSERT INTO tof_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Naea kürü ngakoklaorr, kürü ngónapükü batülürr. Malua kürü metatómpükü küdarükürr akó malu opopora kürü singül kórrgótónóp. ");
INSERT INTO tof_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ka abilürrü tai kókó podo zitülkus ne kwarilürr, ene büdülab bwóbdü. Da mató, Lod, kürü God, ma kürü arról kalkomóla ene kukurru bwóbdügab. ");
INSERT INTO tof_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Ka kólba nóma küp bamkórró, wa, kürü arróla blakónóm kain yarilürr, da Lod, ka marüka tóre ekorró. Ma kürü kurrkrrurrü moba Gyabi Müótüdü. ");
INSERT INTO tof_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Obae küp-koke godóm nidi tóredako, marü morroal tonarrbóka tai kuri imrükrre. ");
INSERT INTO tof_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Ka sab marü wórri magürolo, ó ka marü eso akyanóm lar emkolo, ó ka sab kólba ⌊arüng alkamül-koke bóktan⌋ tórrmendó irrbuno. Lod, zidbaina marükagabi tótókda!” ");
INSERT INTO tof_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Da Lod wapi arüng bóktan we ekyanórr, Zonan müzi alkomólóm, kórrgópdó. ");
INSERT INTO tof_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Akó nis ngim Lodón bóktana tamórr Zonaka. ");
INSERT INTO tof_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Wagó, “Ma ugó bupa Ninebe tótókóm, ene wirri basirrdü, da wirri arüngi bóktanke pamkolpamdó, ka marü ne poko myalórró ngaensingül.” ");
INSERT INTO tof_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Da Zona bupadórr ó wa we wamórr Ninebe wirri basirrdü, Lodón bóktan ngarkwatódó. Ninebe wirrian basirr yarilürr, paman tótókóm aüd ngürr azebda, darrü kubdügab kókó dakla kub. ");
INSERT INTO tof_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Zona wirri basirr kugupidü we bangrinürr. Dudu ngürr agóltagóla nóma blakónórr, we müsirrga yónürr wagó, “40 Ngürr kakóm, Ninebe sab kolae ugón esene!” Zona ene wirri basirr we amgatórr, ama wamórr abüsa nólgab banikda. Wa tóba aren-aren müót we elórr murrüm, da murrdü we mórranórr, dakla Ninebe wirri basirr olgabi ngakan yarilürr, wa, ia kubó laróga tómbapóne. ");
INSERT INTO tof_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ninebe wirri basirr pamkolpama Godón amkoman yangunóp, da i gyagüpitótók we ipüdóp alo bütóküm. Wirridügab kókó kari, gyaur mórrkenyórr bamelóp, igósidi wagó, i kolaedógabi kuri tübyalüngórre. ");
INSERT INTO tof_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ninebe wirri basirran kinga ene bóktan nóma arrkrrurr, wa we bupadórr tóba kingan mórran klamdógab, tóba kokrrapan mórrkenyórr we ininürr, amakó gyaur mórrkenyórr we batenórr. Wa urtók burudü gyaure we mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Wa bóktan zirrapónórr Ninebe pamkolpamdó wagó, “Ini bóktan kürükagabia, ini wirri basirran king kólba zaget pampükü. Blaman kol ó pama alo a nae bütók ki kwarilün, ó ume kyamül, ⌊kau⌋, ⌊sip⌋ a ⌊gouta⌋ ta inzan. ");
INSERT INTO tof_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Blaman kol ó pam akó ume kyamüla sab gyaur mórrkenyórr ki bamelónóm. Blamana tóre bako ki kwarilün Godka, amkoman moboküpdü arüngi. I blamana tibiób ene kolaean tulmil akó zóngang tórrmendógabi ki tübyalüngnüm. ");
INSERT INTO tof_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Mi umul kokeakla, God sab gyagüpitótók ipüde, aprrapórr tóba ngürsil amige, da mi igósidi sab koke nurrbarino.” ");
INSERT INTO tof_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","God esenórr i ne kla tómbapónóp, i ia tübyalüngóp tibiób kolaean tulmildügabi. Da wa ibü gyaur we ipadórr, tóba gyagüpitótók imzazilürr, da ibü koke kolae ninóp, wa ngaen-gógópanzan bóktanórr. ");
INSERT INTO tof_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Zona nóma umul bainürr wagó, God Ninebe pamkolpamab gyaur ipadórr, wa kari mólmóntwól koke yarilürr. Oya bübdü ngürsil yarilürr Ninebe koke ne kulainürr. ");
INSERT INTO tof_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Wa tóre ekorr wagó, “⌊Lod⌋, nam, ka kólba kantrridü nóma namülnürrü, ka ugón umul bairrü, ma sab moba darrü gyagüpitótók akó eseno, da ka ene igósidi busorróma Tarrsyis wirri basirrdü. Zitülkus módóga, ma gyaur Godla, ma tórrmenóm büsai koke ino, ma büsai koke ngürsildóla, ma moba pamkolpam morroal tonarre ngabkandóla, akó ma moba gyagüpitótók büsai koke eseno pam kulain-gum. ");
INSERT INTO tof_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Da errkyadan, Lod, kürü kolkomól büdülüm. Ka morroal büdül ki namüla, a arról koke.” ");
INSERT INTO tof_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Lod bóktan we yalkomólórr wagó, “Marü ia laró dümdüma ngürsil amgünüm?” ");
INSERT INTO tof_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Wa kari nugup kumab we sirtümülürr. Igósüm ekyanórr, Zonan murr akyanóm, oya zid ainüm tóba kolae gyagüpitótókdógab. Zona kari bagürwóm koke yarilürr, ene nugup kumab nóma esenórr. ");
INSERT INTO tof_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Darrü ngürr, sisa nóma balgólórr, God su we zirrsapónórr, da sua ene nugup kumab we emkalórr. ");
INSERT INTO tof_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Abüsa nóma semkenórr, God ururan bao wór zirrsapónórr. Zonan iltümüna kari poko tupürrma ene abüs ururdügab. Oya singül nóma adünglürr, oya ubi büdülüm yarilürr. Wa bóktanórr wagó, “Ka morroal büdül ki namüla, a arról koke.” ");
INSERT INTO tof_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Da God oyaka bóktanórr wagó, “Marü ia laró dümdüma ngürsil amgünüm ini nugup kumabankwata?” Zona wagó, “Kürü ta kari dümdüm kokea ngürsil amgünüm, ó kürü büdül ta gaoandóma!” ");
INSERT INTO tof_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Lod oyaka we bóktanórr wagó, “Ini nugup kumaba irrüb dódórr baine akó darrü irrüb we nurrótóke. Ma oyankü ta darrü kla koke tónggapórró dódórr ainüm, da ma ma oya gyaur asendóla! ");
INSERT INTO tof_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ka ta inzan gyaur namulo Ninebe ene wirrian basirrdü. Ola blaman kókó 120,000 pamkolpamako, akó ngibürr asiko. I umul kokeako, morroal ia laróga ó kolae ia laróga. Akó ta abün ume kyamül asiko! Ma ia kürü amkoman ayaldóla igó, ka ia ibü sab koke ki gyaur nósenónóma?” Zonan Peba aini blakónda. ");
INSERT INTO tof_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kerriso ⌊Deibidün⌋ olom yarilürr, akó Deibid go Eibrra-amón bobat yarilürr. Yesun abalbobatalab ngi aini balómórrónako. ");
INSERT INTO tof_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibrra-amkagabi kókó King Deibidün amrran, ibü ngi idi kwarilürr: Eibrra-am Aesakón ab yarilürr, Aesak Zeikobón ab yarilürr, Zeikob, Zuda akó oya zoretal, wa ibü ab yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda, Perrez akó Zerra ibü ab yarilürr, Tamarr aipdügab. Perrez Ezrronón ab yarilürr, Ezrron Rramón ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rram Aminadabón ab yarilürr, Aminadab Nasonón ab yarilürr, Nason Salmonón ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon Boazón ab yarilürr, Rreieb aipdügab, Boaz Obedón ab yarilürr, Rrut aipdügab, Obed Zesin ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","akó Zesi Deibidün ab yarilürr, Isrrael pamkolpamab king. Deibidkagabi kókó Isrrael pamkolpam Babilonia gazirr pama nóma barrmülürr ama tibiób bwóbdü ola ngyabenóm, Yesun abalbobatalab ngi idi kwarilürr: Deibid Solomonón ab yarilürr, Urraean kol kóbledógab esenórr, ");
INSERT INTO tof_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rreoboamón ab yarilürr, Rreoboam Abaezan ab yarilürr, Abaeza Asan ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Zeosapatón ab yarilürr, Zeosapat Zeorramón ab yarilürr, Zeorram Uzian ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzia Zotamón ab yarilürr, Zotam Eazón ab yarilürr, Eaz Ezekaean ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezekaea Manasen ab yarilürr, Manase Amonón ab yarilürr, Amon Zosaean ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","akó Zosaea, Zeoyakin akó oya simanal zoretal, ibü ab yarilürr, Isrrael pamkolpam nóma barrmünürr Babilonia bwóbdü. ");
INSERT INTO tof_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isrrael pamkolpama nóma ngyaben koralórr Babiloniam, kókó Yesu nóma tómtómólórr, Yesun abalbobatalab ngi idi kwarilürr: Zeoyakin Syealtielón ab yarilürr, Syealtiel Zerrubbabelón ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerrubbabel Abiudün ab yarilürr, Abiud Elyakimün ab yarilürr, Elyakim Azorrón ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorr Zadokón ab yarilürr, Zadok Eikimün ab yarilürr, Eikim Eliudün ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazarrón ab yarilürr, Eleazarr Matanón ab yarilürr, Matan Zeikobón ab yarilürr, ");
INSERT INTO tof_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","da Zeikob Zosepón ab yarilürr. Zosep Merrin zumiógürr, da Merri olom we esenórr, ngi Yesu, noan ngiliandako ⌊Kerriso⌋. ");
INSERT INTO tof_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Blaman dayóndi, kókó 14 abalbobatal kwarilürr, Eibrra-amkagabi kókó Deibidün amrran. Akó 14 abalbobatal kwarilürr, Deibidkagabi kókó Isrrael pamkolpam Babilonia bwóbdü nóma barrmünürr. Akó 14 abalbobatal kwarilürr, we tonarrdógabi, Isrrael pamkolpam Babilonia bwóbdü nóma barrmünürr, kókó ene Kerriso nóma tómtómólórr. ");
INSERT INTO tof_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Kerriso ia tómtómólórr. Oya aip Merri. Wa tüób arrearrón warilürr Zosepka. Merri Zosepón solodó ipadórr, a ngaen-gógópan i umul bainóp wa bikómpükümo Godón Samuan arüngdügab. ");
INSERT INTO tof_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zosep, oya müórüm solkwat bainürr, wa tüób dümdüm ngyaben pam yarilürr. Wa nóma umul bainürr wagó, Merri bikóm kuri esene, oya gyagüpitótók igó yarilürr wagó, wa darrü pamdógab ipadórr. A wa Merrin büód akyanóm koke yarilürr pamkolpamab obzek kwata, da tebe we gyagüpi wamórr, Merrin amióg bóktan piküpan singgapinüm. ");
INSERT INTO tof_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wa ini poko nóma gyagüpitótók yarilürr, da módóga, ⌊Lodón⌋ darrü ⌊anerrua⌋ oyaka utüdi nus we okaka tübyónürr. Anerrua oyabóka wagó, “Zosep, Deibidün bobat, ma gumüm bain-gu Merrin apadóm, moba kolóm ainüm! Wa ne bikóm ódóddo, Godón Samuan arüngdügabia. ");
INSERT INTO tof_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Wa sab siman olom esene. Da ma sab oya Yesu ngi ngyesilo, zitülkus wa tóba pamkolpam tibiób kolae tonarrdógabi sab wató zid nirre.” ");
INSERT INTO tof_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Blaman ini tórrmen tulmila igósidi tómbapónóp, Lodón bóktan küppükü ainüm, wa ⌊prropetódó⌋ ne poko bóktanórr pamkolpamdó adrratóm Merrinkwata wagó, ");
INSERT INTO tof_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Tübarrkrru, pampükü koke ne kola umtulürr, sab bikóm ipüde, da wa sab siman olom esene. Oya sab Emanuelbóka ngilianórre,” oya küp módóga: “God asine minkü.” ");
INSERT INTO tof_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Zosep utürrüna nóma türsümülürr, wa tónggapónórr oya anerrua enezan yalórr. Merrin tóba kolóm we wyónürr, ");
INSERT INTO tof_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","a wa tóba kolpükü koke umtulürr, ngarkwat kókó Merri siman olom esenórr. Zosep olom ngi we ngyesilürr, Yesu. ");
INSERT INTO tof_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesu Betliem wirri basirrdü tómtómólórr, Zudia prrobins kugupidü, Errod king nóma yarilürr. Da módóga, ngibürr tonarr kakóm, ngibürr wirri gyagüpitótók pama, abüsa ne nólgabi banikda, olgabi togobórr. Zerrusalem wirri basirrdü nóma tübabzilürr, ");
INSERT INTO tof_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","da i kolpam we nümtinónóp wagó, “Ene olommokur ia nega, nótó kuri tómtómóle ⌊Zu pamkolpamab⌋ kingüm bainüm? Oya amtómól tonarr ne wimurra pupainda, ki ta ene wimurr eserre, abüsa nólgabi banikda, da ki ene olom ótókóm togoba.” ");
INSERT INTO tof_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Errod ene bóktan nóma arrkrrurr ini küsil kingankwata, oya wirri müp gyagüpitótók ekyanórr. Blaman Zerrusalem kolpama ta müp ipüdóp. ");
INSERT INTO tof_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Errod blaman ini Zu pamkolpamab wirri ngi pam we ngibaunürr darrpan pokodó kwób bazenóm: ⌊wirri prrist⌋ akó Mosesón gida umulbain pam. Errod ibü we nümtinóp wagó, “Ene ⌊Kerriso⌋ ia sab nubósüm tómtómóle?” ");
INSERT INTO tof_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","I oya we izazilóp wagó, “Ala Zudiam, Betliem wirri basirrdü. Darrü prropeta Godón bóktan ngaen inzan wialómórr tóba pebadó wagó, ");
INSERT INTO tof_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Mató, Betliem basirr, Zuda prrobinsdü, ma go kari basirrla, a marü ngi wirria ngibürr Zuda pamab bwób balngomól basirrdügabi, zitülkus marükagabi sab balngomól pama tame. Wa sab ⌊sip⌋ ngabkan pamzan yarile, kürü Isrrael pamkolpam balngomólóm.’” ");
INSERT INTO tof_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ene kakóm, Errod ene wirri gyagüpitótók pam piküpan we ngibaunürr, bóktan amaniküm. Wa umul ibükagab bainürr, ene wimurra tai nadü ngarkwatódó okaka tübyónürr. ");
INSERT INTO tof_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Da módóga, Errod ibü Betliem we zirrnapónóp ini bóktanpükü wagó, “E ugó ogob, ene gab olom amkünüm. Kubó tai yamkülamke. E nóma esenane, da kürü umul-umulan ngigütinamke, igósüm ka ta sab wamo, oya ótókóm.” ");
INSERT INTO tof_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I oya bóktan nóma barrkrrurr, da olgabi we bazebórr ama Betliem. Da módóga, kwat-kwat, i ene dadan wimurr akó esenóp, i ne wimurr esenóp abüsa nólgabi banikda. Ene wimurra ibü singül kwata we wamlórr, kókókó, tai ene gab olom ne pokodó yarilürr, we zamngólórr. ");
INSERT INTO tof_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","I ene wimurr nóma esenóp, ibüka kari bagürwóm ta koke yarilürr! ");
INSERT INTO tof_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Da müótüdü we barrbünürr. I ene gab olom we esenóp, tóba Merri aippükü. Da wakósingül nümgünóp, singül tüp, oya ótókóm. I tibiób wirri darrem kla nomgolóp, da we ilinóp. Ene ⌊gyaur kla⌋ módógako: gold, prrenkónsens, akó mirr. ");
INSERT INTO tof_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","God ibü nusi ikik nókrrónóp, Errodka bakon-gum. Da módóga, i we bakonórr tibiób bwóbdü darrü kwata. ");
INSERT INTO tof_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wirri gyagüpitótók susumüri pama Betliem basirr nóma amgütóp, da módóga, Lodón darrü anerrua nusi ugón okaka tübyónürr Zosepka. Anerrua we bóktanórr wagó, “Bupa! Olom a aip, ibü nüpa a ugó busuam Izipt tüpdü, zitülkus Errod sab ini gab olom amkün yarile oya amkalóm. E kya bupso ola ngyabelamke, kókóta sab yabü kótó umul-umulan ngintinünümo bakonóm.” ");
INSERT INTO tof_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nus kakóm, Zosep dümdüman irrüb tóba kol akó gab olom nüpadórr, da we bupadórr Izipt tótókóm. ");
INSERT INTO tof_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Wa ola ngyaben yarilürr, kókókó Errod ne tonarr nurrótókórr. Ini pokoa igósidi tómbapónórr, Lodón bóktan küppükü ainüm, wa prropetódó ne poko bóktanórr pamkolpamdó adrratóm wagó, “Ka kólba Olom sab ngyauno Izipt amgatóm.” ");
INSERT INTO tof_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Errod nóma umul bainürr wagó, oya wirri gyagüpitótók susumüri pama ilklió ilinóp, wa kari ngürsil ta koke yarilürr. Da tóba gazirr pam we nilóp blaman kari simanal olmal, nis pail ngarkwat kókó ta tüp, ibü akrranóm, Betliem basirr kugupidü akó Betliem bwób minggüpanan ne basirr koralórr. Wa ene poko tónggapónóm gyagüpi wamórr, zitülkus wa wirri gyagüpitótók pamdógab wirri umul bainürr, ene wimurra tai nadü tonarr okaka tübyónürr. ");
INSERT INTO tof_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Prropet Zerremaeazan bóktanórr Godón Wibalómórrón Bóktandó, da küppükü bainürr, wagó, ");
INSERT INTO tof_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gyaurwóm a yón taegwarr arrkrrudako Rrama wirri basirrdü. Rreizel tóba olmalóm yóndo akó wa zao-zao bain-gum bangóndo, zitülkus oya olmal büdülako.” ");
INSERT INTO tof_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Errod nóma nurrótókórr, da módóga, Lodón darrü anerrua nusi akó ugón okaka tübyónürr Zosepka. Ini tonarra ugón tólbaelórr, Zosep Iziptüm nóma yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Anerrua oyaka we bóktanórr wagó, “Bupa! Olom tóba aippükü nüpa, da Isrrael Müótüdü ugó alkomólam. Oya nadü pama amkalóm kain kwarilürr, ene pam tib büdülako.” ");
INSERT INTO tof_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Da Zosep bupadórr, tóba olom aippükü nüpadórr, da Isrrael we alkomólórr. ");
INSERT INTO tof_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","A Zosep nóma arrkrrurr wagó, Arrkileus tóba ab Errodón pabo kuri ipüde Zudia prrobins pamkolpam balngomólóm, wa gum yarilürr ola alkomólóm. God oya nusdü ikik akrranórr wagó, “Ma Zudia tótókgu! Ma Galili bwóbdü wamke!” Da wa we wamórr, ");
INSERT INTO tof_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","wirri basirrdü Nazarret, ngyabenóm. Ini pokoa igósidi tómbapónórr, Godón Wialómórrón Bóktan küppükü ainüm, wa prropetódó ne poko bóktanórr pamkolpamdó adrratóm Yesunkwata wagó, “Oya sab Nazarret olombóka ngilianórre.” ");
INSERT INTO tof_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Dokyanan paila nóma bobrranórr, ene kakóm, Zon Baptaes Bain Pama we tamórr. Wa Zudia ⌊ngüin-koke bwóbdü⌋ Godón bóktan we amgol yarilürr pamkolpamdó, oya arrkrrum nidi ogobórr. ");
INSERT INTO tof_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Zon we bóktanórr wagó, “Godka tübyalüngam yabiób kolae tonarrdógabi, zitülkus Godón Kingzan Balngomóla minggüpanan kuri tübine!” ");
INSERT INTO tof_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Zon Baptaes Bain Pam módóga, prropet Aesaya noanbóka apón yarilürr wagó, “Darrü pama taegwarrdase ngüin-koke bwóbdü wagó, ‘Kwat ngagrótam Lodón tótókóm, akó kwat morroal dümdüm alótam oyankü!’” ");
INSERT INTO tof_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Zon wa ⌊kamel⌋ ngüin mórrkenyórr bamelórrón yarilürr, akó wa lar sopae belt baterrón yarilürr. Oya alo kla we kla yarilürr, paza tónók akó molpokodó gus mor. ");
INSERT INTO tof_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Abün pamkolpama we ogoblórr Zonón bóktan arrkrrum, Zerrusalem wirri basirrdügabi, akó blaman Zudia prrobins kugupidü ne basirrko, akó Zodan tobarr kabedó ne basirr koralórr. ");
INSERT INTO tof_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I tibiób kolae tonarr nóma okaka uzazilürr, da Zon ibü baptaes nyónónóp Zodan tobarrdó. ");
INSERT INTO tof_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Zon abün ⌊Parrisi⌋ akó ⌊Sadusi pam⌋ nóma nósenóp tóbaka tótókde baptaes bainüm, da wa ma ibüka igó bóktanórr wagó, “E blaman kolae balóng gwarab kupoakla! E igó gyagüpi tótókgu igó, e sab Godón wirri ngürsildügab kyab kórzinane, ne klama tótókóm kainda, wata ene zitülkusdü, e sab baptaes bairrün nóma koralo. ");
INSERT INTO tof_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yabü ubi ne nóma yarile Godón wirri ngürsildügab kyab kórzyónüm, e ngaen-gógópan morroal küp waon koralo yabiób ngyaben kugupidü! Yabü olgabi nómzyetórre wagó, e Godka kuri tübyalüngane yabiób kolae tonarrdógabi. ");
INSERT INTO tof_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","E igó gyagüpi tótókgu, God yabü koke kolae nirre, yabióbka inzan bóktande igó, ‘Eibrra-am kibü abbobate.’ Enana Eibrra-am yabü abbobat: wa yabü sab koke tangnamtirre Godón wirri ngürsildügab busom! Zitülkus módóga, ka yabü igó byaldóla, Godón gaodóma olmal tólbaelóm Eibrra-amónkü ini ingülküpdügabi! ");
INSERT INTO tof_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Errkya God kari pokoa pamkolpam kolae bainüm. Salmita nugup simkün ngarkwatódó olama, nugup singgalgónóm. Morroal küp koke ne nugupa waonda, sab singgalgórre ama urdü amaike. ");
INSERT INTO tof_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka wa nae-e baptaes baindóla, Godka nidi byalüngdako tibiób kolae tonarrdógabi. A darrü pama kürü solkwat tótókda, wirri arüng nótóke kürükagab. Ka ta ngarkwatódó kokela oya wapórdó bamel kla amarrum. Wa sab yabü Godón Samu-i akó uri baptaes bain yarile. ");
INSERT INTO tof_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Zono-zono paezan kla tangdóma ⌊wit⌋ küp aus bwóbdü wit küp aleanóm buldügab. Wa sab wit küp kwób isue, ama gyagu müótüdü irrbüne, a bul ama bütamün-koke urdü yamsele.” ");
INSERT INTO tof_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Darrpan ngürr Yesu Galili prrobinsdügabi tübzilürr ama Zonka wamórr, Zodan tobarrdó, igósüm oya Zon ki baptaes ine. ");
INSERT INTO tof_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Zon oya piküp yónürrma wagó, “Ma kürüka iade tama baptaes apadóm? A kürü wa baptaes mató ki kina!” ");
INSERT INTO tof_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu bóktan we yalkomólórr wagó, “Koke! Ini pokoa inzan ugó ki tómbapó. Mi blaman kla wata morroal akó dümdüm tómbapóni, Godón ubi ngarkwatódó.” Zon igósidi we ubi bainürr Yesun baptaes ainüm. ");
INSERT INTO tof_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yesun baptaes aina nóma blakónórr, wa naedógabi dümdüman we tubrranórr. Da módóga, pülpüla tapabakurr. Wa Godón Samu we esenórr, kwitüdügabi abindi akó oya kwitüdü amngyelde nurre póyae buli. ");
INSERT INTO tof_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Da módóga, kwitüdügabi bóktan kümüla we sidórükürr wagó, “Ini kürü kólbanan olome. Kürü ⌊moboküpdü ubi⌋ oyakama. Ka kari barnginwóm kokela oyaka.” ");
INSERT INTO tof_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ene kakóm, Yesun Godón Samua we idódürr ⌊ngüin-koke bwóbdü⌋, ⌊debóla⌋ oya ki elngomóle kolae tonarr tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu ene pokodó 40 ngürr akó 40 irrüb alo-koke amanórr. Solkwat oya tai aloana we ipadórr. ");
INSERT INTO tof_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Debóla we tamórr oya alngomólóm kolae tonarr tónggapónóm. Oyabóka wagó, “Zitülkus ma Godón Olomla, ma ini ingülküp ugó nilnünüm brredóm büzazinüm.” ");
INSERT INTO tof_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","A Yesu ma oyabóka wagó, “Koke! Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Pama brredane koke ngyabene, a blaman ne bóktana bausdako Godón taedógab.’” ");
INSERT INTO tof_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Da debóla Yesun Zerrusalem idódürr, Godón wirri gyabi basirrdü, da we emngyelórr ⌊Godón Gyabi Müót⌋ wirri kwitüm pokodó. ");
INSERT INTO tof_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Oya we yalórr wagó, “Zitülkus ma Godón Olomla, algabi ugó aup. Zitülkus módóga, Godón Wialómórrón Bóktana igó bóktanda wagó, “‘God kubó tóba anerru arüng bóktan nókyerre marü adlangóm. I marü kubó tibiób tange kwit mirre, igósüm ma moba wapór koke bómkolo ingülküpdü.’” ");
INSERT INTO tof_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu oya bóktan we yalkomólórr wagó, “Koke! Godón Wialómórrón Bóktana akó igó bóktanda wagó, ‘Ma Lodón, moba God nótóke, apókgu asenóm, wa ia amkoman Goda.’” ");
INSERT INTO tof_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Debóla oya akó we idódürr wirri kwitüm pododó, da oya we emtyanórr blaman ini tüpan kingab balngomól bwób akó tüpan blaman arrbirrün nadü elklazako. ");
INSERT INTO tof_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Oya we yalórr wagó, “Ma ne wakósingül nóma nülkamulo kürü ⌊ótókóm⌋, ini blaman ne elklazako, ka sab blaman igósidi marü mülino.” ");
INSERT INTO tof_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu oya we yalórr wagó, “Kokean! Kürükagabi usi wam, satani! Ka marü koke ótók namulo, zitülkus Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Ma wakósingül nülkamulo Lodón obzek kwata, marü God nótóke, akó wata oya ótók namulo.’” ");
INSERT INTO tof_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Olgabi debóla Yesun we amgatórr. Da módóga, anerrua we togobórr Yesun tangamtinüm. ");
INSERT INTO tof_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu nóma arrkrrurr wagó, Zonón tümün müótüdü kuri ingrirre, wa Galili we alkomólórr. ");
INSERT INTO tof_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wa Nazarret wirri basirr kwatana we errgrratórr, ama Kaperrna-um wirri basirrdü wamórr ngyabenóm, Galili Malu kabedó, Zebulun akó Naptali zitül pamkolpama ne ngyaben kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ini pokoa igósidi tómbapónórr, Lodón bóktan küppükü ainüm, wa prropet Aesayaka ne poko bóktanórr pamkolpamdó adrratóm wagó, ");
INSERT INTO tof_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zebulun zitül akó Naptali zitül, yabü bwób Galili Maludübónada, Zodan tobarr dakla dorrodó. Galili, mogob pamkolpamab ngyaben bwób, Zu-koke nidipako! ");
INSERT INTO tof_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","E tümündü ne pamkolpama ngyabendakla, e sab wirri zyón esenane, akó e samuan ngarkwatódó büdül ne pamkolpamakla, yabü sab zyóna warri napórre.” ");
INSERT INTO tof_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ene tonarrdó, Yesu tóba bóktan amgol we ngarkwat bókyanórr wagó, “Godka tübyalüngam yabiób kolae tonarrdógabi, zitülkus Godón Kingzan Balngomóla minggüpanan kuri tübine!” ");
INSERT INTO tof_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yesu Galili Malu kabeana nóma wamlórr, wa nis narezoreti pam nis nósenórr, Saemon, oya darrü ngi Pita, akó Endrru. I net yagóbnürri naedó, zitülkus i wapi baib pam nis namülnürri. ");
INSERT INTO tof_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ibü nyalórr wagó, “Yao! Kankü turram! Ka yabü sab pamkolpam bumióg umul nino.” ");
INSERT INTO tof_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Darrpan güblang i ne arrkrrurri, tibiób net ola bimgatrri, da Yesuka we akyarri. ");
INSERT INTO tof_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu akó enezan wamlórr, akó nis narezoreti pam nis nósenórr, Zebedin olom nis, Zeims a Zon. I tibiób abpükü namülnürri butüdü, dakla net barrgüp namülnürri. Yesu akó ibü nginaunürr oyaka solkwat akyanóm. ");
INSERT INTO tof_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Dümdüman i tibiób ab Zebedin ola amgatrri butpükü, da Yesuka we akyarri. ");
INSERT INTO tof_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu we wamlórr basirr-basirr Galili kugupidü, ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ umul bainkü akó Morroal Bóktan amgolkü Godón Kingzan Balngomólankwata. Wa pamkolpam dólóng nyónónóp tibiób blaman ia-ia azidüdügab. ");
INSERT INTO tof_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesunkwata bóktana bayolórr tai kókó Sirria bwóba blamana umul bainürr wagó, Yesu pamkolpam dólóng byónda, da i tibiób blaman azid pamkolpam igósidi we tübarrmülürr oyaka, abün-abün tonarr azid nidi balmil kwarilürr: kolae samupükü nidi kwarilürr, tórrngón azid akó bidal azid nidi kwarilürr. Wa blaman dólóng we nyónónóp ibü tibiób azidüdügab. ");
INSERT INTO tof_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oyaka wirri pamkolpamab ngoroa zutalórr Galili prrobinsdügabi akó Dekapolisgabi, Zerrusalem wirri basirrdügabi, Zudia prrobinsdügabi, akó Zodan tobarr dakla dorro ne basirr koralórr. ");
INSERT INTO tof_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu ene pamkolpamab ngoro nóma nósenóp, pododó we kasilürr, da mórran-mórran bainürr. Oya umulbain olmal akó ngibürr pamkolpam, oya nidi mamoan kwarilürr, oyaka we togobórr. ");
INSERT INTO tof_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Da Yesu ibü blaman umul bain we ngarkwat bókyanórr. Wagó, ");
INSERT INTO tof_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bagürwóm idipako, umul nidipako ibüka arüng babula tibiób zid bainüm, zitülkus ibü God balngomólda Kingzan! ");
INSERT INTO tof_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Bagürwóm idipako, nidi yón gyaurdako, zitülkus God sab ibü zao-zao nirre! ");
INSERT INTO tof_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Bagürwóm idipako, tibiób koke nidi ikub bagürdako, zitülkus God ibü ne blaman kla aliónüm bóktanórr, i sab yazebrre! ");
INSERT INTO tof_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Bagürwóm idipako, nibiób wirri ubie dümdüm ngyabenóm Godón ilküpdü, zitülkus wa sab ibü ubi elakóne. ");
INSERT INTO tof_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Bagürwóm idipako, pamkolpamdó gyaur nidipako, zitülkus God ta sab gyaur inzan yarile ibüka! ");
INSERT INTO tof_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Bagürwóm idipako, ⌊kolkal⌋ moboküp nibióbko, zitülkus i sab Godón eserre! ");
INSERT INTO tof_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Bagürwóm idipako, paud nidi ódóddako, zitülkus God ibü sab tóba olmalbóka ngibline! ");
INSERT INTO tof_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Bagürwóm idipako, wirri müp nibiób alióndako, ⌊dümdüm tonarranme⌋, zitülkus ibü God balngomólda Kingzan! ");
INSERT INTO tof_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bagürwóm yadipakla, pamkolpama yabü sab kle-kle nóma nyalnórre, akó yabü wirri müp nóma alión korale, akó yabükwata obae bóktan nóma büdrrat korale, zitülkus e kürü amkoman angundakla! ");
INSERT INTO tof_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","E bagürwóm akó barnginwóm kwarilünke, zitülkus yabü wirri darrem kwitüm asise. Ene ka igósidi byaldóla, zitülkus ngaen yabü singül kwata, prropeta nidi ngyabenónóp, ibü ta inzan wirri müp alión kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“E ne klamakla, soltzanakla ini tüpan pamkolpamabkü. A solt misa ne nóma bamrüke, da ma myamem koke soltzan ino. Wa wata kolaeana. Oya ipüdórre, amanikórre kalkuma. Oya pamkolpama wapóre ailkü ola arrgrrat-sórrgrrat yangónórre. ");
INSERT INTO tof_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“E ne klamakla, zyón klamzanakla ini tüpan pamkolpamabkü. Podo kwitüdü aelórrón ne wirri basirre, wa anikürrün ta kokea. ");
INSERT INTO tof_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pamkolpama zyón kla nóma sentórre, i kubó alópe koke nganlorre. A i wata yazebrre, ama kumngyindü emelórre. Ene zyóna blaman müótüdü pamkolpam kubó olgabi zyón napórre. ");
INSERT INTO tof_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ene dadan ngarkwatódó, yabükagab zyóna ugó ki tam pamkolpamab obzek kwata. Ene igósüm, i sab nósenórre e ne morroal tórrmen tulmil tómbapónane, akó igósüm i sab yabü kwitüm Ab yagürnórre. ");
INSERT INTO tof_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“E wa igó gyagüpi tótókgu wagó, ka Mosesón Gida Buk akó Prropetab Peba, ibü umulbain bóktan kolae byónüm tama. Ka ugósüm koke tama ene gida kakota amanóm. Ka wa Godón gida, ibü amkoman küp okaka azazinüm akó tómbapónóm tama. ");
INSERT INTO tof_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Zitülkus módóga, ka yabü amkoman poko byaldóla: Godón Gida sab metat kwarile karrkukus bórrangórrón, ngarkwat kókó tüp a pülpüla nóma bamrüki. Godón ne gida-e karian ngi opora sab kokean bamrüke, ngarkwat kókó blaman klama sab tómbapórre. ");
INSERT INTO tof_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Darrü pama darrpanan Godón karian gida bóktan poko sab ne nóma alkamüle akó ngibürr kolpam umul nirre dadan kolae tónggapónóm, wa solodó yarile Godón Kingzan Balngomóldó. Godón gida bóktan poko nótó azebda akó umul bainda ngibürr kolpam dadan tonarr tómbapónóm, wa wirri yarile Godón Balngomóldó. ");
INSERT INTO tof_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Zitülkus módóga, ka yabü igó byaldóla, e wata barrbuno Godón Balngomóldó, e ne Godón ubi nóma tómbapónane. E ne gida umulbain pam akó Parrisizan nóma kwarilo, e igósidi God ne Bwób alngomólda Kingzan kokean barrbuno, zitülkus i Godón ubi amkoman kokean tómbapóndako. ");
INSERT INTO tof_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“E barrkrrurrü Mosesón gida bóktan poko, ne kla nilóp mibü abalbobatal wagó, ‘Ma darrü olom büdülümpükü amkalgu. Darrü olom büdülümpükü nótó emkóle, wa sab kotódó zamngóle tóba bóktan apadóm.’ ");
INSERT INTO tof_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ka ma akó ngibürr bóktan amseldóla: ma ngürsil nóma namulo moba narezoretódó, ma sab kotódó zamngolo. Akó ma nóma bóktono moba narezoretódó wagó, ‘Ma susumüri-koke olomla!’ ma sab zamngolo blaman Zu ⌊balngomól byarrmarr pamab⌋ obzek kwata. Akó ma moba narezoret igó nóma ilo, ‘Ma gonggola’, da God marü sab ⌊metat bólmyan urdü⌋ mügasile. ");
INSERT INTO tof_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Da ma moba ⌊gyaur kla⌋ Godón akyanóm nóma kaindóla Godón ⌊altadó⌋, ⌊Godón Gyabi Müót⌋ kugupidü, akó marü wata ugósan nóma ngambangóle igó, marü narezoretan ngürsil asine marüka, ");
INSERT INTO tof_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma moba gyaur kla altan obzek kwata we amgat, da oyaka wam saul bainüm. Ene kakóm, ma akó altadó we alkomolo moba gyaur kla Godón akyanóm. ");
INSERT INTO tof_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Darrü oloma nóma bóktanda wagó, ma darrü kolae tónggapórró akó marü kotóm nóma ódódóm kainda, e kwat-kwat saul büsai baini. E ne saul koke nóma baini, wa marü sab zazdó kena müdó. Marü ma sab zaza pug umeab tangdó müngrine, marü tümün müótüdü angrinüm. ");
INSERT INTO tof_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka marü amkoman poko ayaldóla: ma sab kokean tubrruno, kókóta ma sab moba dómdóm kari mani küp ungrino burruanóm, zazan bóktan ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“E barrkrrurrü Mosesón gida bóktan poko, enezan yarilürr wagó, ‘Ma kol ó pam gómólgu.’ ");
INSERT INTO tof_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ka ma yabü igó byaldóla, darrü pama ne kol ilküpane nóma ngazokone akó oyaka ubi yarile, da wata wa ene kolae tonarr kuri tónggapóne tóba moboküpdü. ");
INSERT INTO tof_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Marü tutul ilküpa ne kolae tonarr tónggapónóm nóma müdüde, da ma irrua, a ugó amaik mobakagab. Ma ne moba darrü büb poko nóma imruko, ene ma tai kolae kokea. A marü dudu büb ne metat bólmyan urdü nóma amanikórre, amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Marü tutul tanga ne kolae tonarr tónggapónóm nóma müdüde, da itül a ugó amaik mobakagab. Ma ne moba darrü büb murr nóma imruko, ene ma tai kolae kokea. A marü dudu büb ne metat bólmyan urdü nóma amanikórre, amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mosesón gida bóktan poko darrü igósa wagó, ‘Darrü pama ne tóba kol nóma zumanike, wa akó kol amaik peba mórrag okyene.’ ");
INSERT INTO tof_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ka ma yabü igó byaldóla, nadü pama tóba kol zumanike popa pokodó, a pam gómólankwata koke, da wa igósidi pam gómól kol kokeo. Inzande, müóra tóba kol zirrzotoke pam gómól kolóm bainüm. Wa ne darrü pampükü nóma umtule, wa pam gómól warile. Akó amanikürrün kol ne pama zumige, wa kol gómól yarile. ");
INSERT INTO tof_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“E ta barrkrrurrü Mosesón gida bóktan poko, enezan yarilürr mibü abalbobataldó wagó, ‘Ma Lodón ngi nóma ngiliandóla moba arüng alkamül-koke bóktan tólaelóm, ma kubó moba bóktan myamem koke singgapino.’ ");
INSERT INTO tof_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ka ma yabü igó byaldóla, e yabiób bóktan nóma tólbael kwarilo, e darrü kla ngilian-gu yabiób bóktan arüng akyanóm. Godón kwitüm ngyaben bwób ngilian-gu, zitülkus ene oya kingan mórran klamse. ");
INSERT INTO tof_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Akó ini tüp ngilian-gu, zitülkus ini tüp Godón wapór nisab ngón ngagón klama. Akó Zerrusalem wirri basirr ngilian-gu, zitülkus kwitüm King nótóke, ene oya tóba wirri basirra. ");
INSERT INTO tof_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","E yabiób bóktan nóma tólbael kwarilo, yabiób singül ta ngiblian-gu, zitülkus e gaodó kokeakla darrpan órrngóen pul gabülplian ngitanóm akó pugan ngitanóm. ");
INSERT INTO tof_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E wata igó bóktónane wagó, ‘Taia’ ó ‘Koke’, da e wata yabiób bóktan ngarkwatódó tómbapónane. E ne ngibürr bóktan nóma amseldakla, ene wa kolaean olomdógabi tótókdako. ");
INSERT INTO tof_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“E barrkrrurrü Mosesón gida bóktan poko, enezan yarilürr wagó, ‘Darrüpa paman ilküp nóma irrune, oya ilküp akó darrem irrurre. Akó darrüpa paman zirrgüp nóma alkamüle, oya zirrgüp akó darrem alkamülórre.’ ");
INSERT INTO tof_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ka ma yabü igó byaldóla, e darrem kolae tónggapón-gu! Darrü oloma ne marü tutul kwata ngorrkob nóma mómkóle tang o-e marü büódan ngitanóm, akó dakla ngorrkob emtya amkalóm. ");
INSERT INTO tof_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Darrü oloma ne marü kotóm nóma ódóddase moba sod mórrkenyórrüm, da marü tumum mórrkenyórr ta ki ipa! ");
INSERT INTO tof_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Marü gazirr pama ne arüng-arüng nóma mile tóba alóp ódódóm darrpan kan, ma ma barrkyanan kan ugó idó. ");
INSERT INTO tof_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Marü ne darrü oloma darrü klamóm nóma mato-e, ma oya ekya. Akó darrü pama ne marükagab darrü kla bupso apadóm nóma kainda, ma angón-gu ene pam akyanóm. ");
INSERT INTO tof_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“E barrkrrurrü Mosesón gida bóktan poko, enezan nilóp wagó, ‘Marü moboküpdü ubi moba minggüpanandó ne olome asi ki yarilün, a marü gódam-koke nótóke, ma oya alzizi amanik!’ ");
INSERT INTO tof_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ka ma yabü igó byaldóla, yabü moboküpdü ubi ta ibüka asi ki koralón, yabü gómdamal-koke nidipko. Akó e tóre koralo ibünkü, yabü wirri müp nidi alióndako. ");
INSERT INTO tof_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Inzan poko tómbapónde, e sab igósidi oya olmalóm bainane, yabü kwitüm Ab nótókse. Abüs zyón wató zirrapónda kolae pamkolpamdó akó morroal pamkolpamdó darrpan tonarre. Akó ngup ta wató zirrapónda, dümdüm ngyaben pam akó dümdüm-koke ngyaben pam, ibüka. ");
INSERT INTO tof_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yabü ne moboküpdü ubi wata ibüka nóma korale, moboküpdü ubi nibióbe yabükamóm, yabüka ene laró darrema? Babula! Zitülkus módóga, blaman pamkolpama inzan kaindako! ⌊Taks mani dakabain pam⌋ ibü moboküpdü ubi ta ibükamako, moboküpdü ubi nibióbe ibükamóm! ");
INSERT INTO tof_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","E ne wata yabióban zonaretal morroal ngürr nóma akyandakla, ene wa müp kla ta kokea! Godónbóka umul-kók nidipko, i ta inzan kaindako! ");
INSERT INTO tof_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yabü moboküpdü ubi blaman pamkolpamdó asi ki koralón, da e wata igósidi ⌊dudu kómal⌋ koralo yabiób Abzan, kwitüm nótókse. ");
INSERT INTO tof_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“E yabiób kwitüm Abankwata gyaur tórrmen tulmil panzedó tómbapón-gu, pamkolpama asenóm. E ne ini tórrmen tulmil pamkolpamab obzek kwata nóma tómbapónórre, yabiób ngi kwit amelóm, yabü sab kwitüm Aba darrem koke nülirre. ");
INSERT INTO tof_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ene pokodó, ma elklaza-koke pam ngibürr kla nóma nülinünümo, ma wa wórr bóngyalpükü panzedó alión-gu pamkolpama asenóm, zitülkus taepurrane bóktan pama inzan kaindako yabü kwóbbazen müótüdü akó wirri kwatódó wagó, kolpama ia nagürnórre. Ka yabü amkoman poko byaldóla: pamkolpama ibüzan agürdako, ibü darrem módóga. God ibü sab darrem kokean nülirre! ");
INSERT INTO tof_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","A ma elklaza-koke pam nóma tangamtindóla, ma igó tónggapóna, marü minggüpanan gódama ta kokean umul baine. ");
INSERT INTO tof_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ene wata marükama. A marü Aba asenda, ma ne kla tómbapóndóla piküpan. Sab marü darrem kla wató mókyene. ");
INSERT INTO tof_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“E tóre nóma akodakla, e taepurrane bóktan pamzan bain-gu. Ibü igósa, kubó pamkolpamab obzek kwata bórrónge tórem, kwóbbazen müótüdü akó wirri kwatódó wagó, ‘Kibü kolpama ia tóserre!’ Ibü ene wirri ubi pokoa. Ka yabü amkoman poko byaldóla: pamkolpama ibü blaman darrem kla kuri nülinóp; darrü myamem babula! ");
INSERT INTO tof_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","A ma tóre akom nóma, moba müótüdü bangrina, mamtae murrausa, da tóre moba Abdó ugón ekoa, asen-koke nótóke. Marü Aba asenda, ma ne kla tómbapóndóla piküpan. Sab marü darrem kla wató mókyene. ");
INSERT INTO tof_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“E nóma tóre bakonane, abün-abün küp-koke bóktan opor ngiblian-gu, Godónbóka umul-kók pamkolpamazan kaindako. Ibü gyagüpitótók igósa wa, ibü goda ta arrkrruda, zitülkus ibü tóre kokrrapako. ");
INSERT INTO tof_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","E ibüzan bain-gu. Yabü babul ne klame, Aba ngaen-gógópan umul bainda, e ne klamóm atom kaindakla. ");
INSERT INTO tof_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Da e ta tóre inzan bakonane: “Kibü Ab, kwitüm nótókla, marü ngi gyabiana; pamkolpama marü ngi ki ⌊ótók⌋ kwarilün. ");
INSERT INTO tof_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Marü Kingzan Balngomóla ugó ki tam, marü ubia ki tómbapó, ini tüpdü kwitümzanse. ");
INSERT INTO tof_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Kibü ini ngürran alo kla tilinünüm. ");
INSERT INTO tof_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ma kibü kolae tonarr torrgonónóm, ki ngibürr kolpamab kolae tonarrzan barrgondakla. ");
INSERT INTO tof_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Akó kibü balngomólgu kolae tonarr tómbapónóm, a ma kibü kolaean olomdógabi tódlóngnóm. ");
INSERT INTO tof_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“E ne ibü kolae tonarr nóma norrgonane, yabüka kolae tonarr nidi tómbapóndako, yabü kwitüm Aba ta sab igósidi yabü kolae tonarr norrgorre. ");
INSERT INTO tof_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","A e ne ibü kolae tonarr koke nóma norrgonane, yabü kwitüm Aba ta sab igósidi yabü kolae tonarr koke norrgorre. ");
INSERT INTO tof_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Gyaur obzek bain-gu, e alo nóma bütókane, taepurrane bóktan pamazan kaindako. I tibiób obzeksyók gyaur obzek byóndako wagó, ‘Kubó pamkolpama kibü ia tómzyetórre wa, “I alo kuri bütókrre.” ’ Ka yabü amkoman poko byaldóla: pamkolpama ibü blaman darrem kla kuri nülinóp; darrü myamem babula! ");
INSERT INTO tof_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","A ma alo nóma bütóko, moba singül oele bóngango-o akó moba obzek bagulo, ma bobarrzan kaindóla. ");
INSERT INTO tof_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Marü kubó koke ia mómzyetórre wa, ma alo kuri bütóka - wata marü asen-koke Ab nótóke, wató umul baine. Marü Aba asenda, ma ne kla tónggapóndóla piküpan. Sab marü darrem wató mókyene. ");
INSERT INTO tof_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“E tüpan mórrelwóm yabióbkü ini tüpdü kari arrólóm kwób asugu. Pu akó saka sab aini kolae nirre akó gómól pama müót amkerre gómól-gómól azebóm. ");
INSERT INTO tof_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","A e wa yabióbkü mórrel kwitüm ugó kwób isuam. Pu akó saka ola kokean kolae nirre akó gómól pama müót kokean amkerre gómól-gómól azebóm. ");
INSERT INTO tof_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Zitülkus módóga, marü mórrel nólamase, marü moboküp wa ta ola yarile. ");
INSERT INTO tof_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ilküp büban zyón klama. Marü ilküp nis ne ziz nóma namüli, marü dudu büb ugón wirri zyóndüma. ");
INSERT INTO tof_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","A marü ilküp nis ne kolae nóma namüli, marü büb ugón tümündüma. Marü bübdü zyón kla ne tümündü nómade, ugón marü dudu büb kari tümündü ta kokea! ");
INSERT INTO tof_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Darrü olom gaodó kokea nis wirri pam nisabkü zagetóm. Wa kubó darrü alzizi amaike, ó oya ⌊moboküpdü ubi⌋ darrüdü yarile. Wa kubó darrüpdü minggüpanan yarile, ó darrü ma kle-kle ngakan yarile. E gaodó kokeakla dakla Godón akó mani ótókóm darrpan tonarrdó. ");
INSERT INTO tof_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ini zitülkusdü, ka yabü igó byaldóla, e yabiób arrólankwata gyakolaegu igó, ‘Ia ka laró elo-o ó enono?’ Akó e yabiób bübankwata gyakolaegu igó, ‘Ia ka laró mórrkenyórr bateno?’ Da ia alo wirriana arróldógabi? Koke! Ó mórrkenyórr ia wirriana bübdügabi? Koke! ");
INSERT INTO tof_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Póyae ngabkónam kwitüdü arrmuldi. I küp koke aritódako, ó alo kokean abüldako kwób asum gyagu müótüdü. A ibü ma yabü kwitüm Aba ngabyónda. Póyae ia amkoman wirriana yabükagab? Koke! Yabü ta kwitüm Aba ngabyónda. ");
INSERT INTO tof_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Darrü yabükagab gyakolae nómada elklazam, ia wa gaodóma tóba ngyaben arratóm darrpan abüs küpüm? Koke! ");
INSERT INTO tof_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Akó e mórrkenyórrankwata iade gyakolaedakla? E gyagüpi amónam, molpokodó kubóla ia dódórr baindako. I kokean zagetódako, akó tibiób mórrkenyórr ta koke barrgüpdako. ");
INSERT INTO tof_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","A ka yabü igó byaldóla, king Solomon abün arrbirrün elklaza pam enan yarilürr, a oya ma morroal mórrkenyórr ta babul kwarilürr ene pulzan. ");
INSERT INTO tof_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God ene nurr twal inzan nóma püti bainda, errkya ne klamko, sab ama urdü amarrón kwarile, da ia wa ma yabü koke püti nirre? Ó! Wa ta sab yabü morroal püti nirre! E kari-karibóka amkoman bangun pamkolpamakla! ");
INSERT INTO tof_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Da e igósidi gyakolaegu igó, ‘Mi kubó laró elorre? Mi kubó laró enórre? Mi ia laró mórrkenyórr bamerre?’ ");
INSERT INTO tof_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Zitülkus módóga, ene Godónbóka umul-kók nidipko ene inzan gyakolaedako ini elklaza azebóm. Yabü kwitüm Ab ama umula, e blaman ne klamómakla. ");
INSERT INTO tof_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","A yabü gyagüpitótók ngaen-gógópan wata Godón Kingzan Balngomóldó kwarile, akó wa yabükagabi ene ⌊dümdüm tonarróma⌋. Da wa sab blaman ini ne elklazako enta igósidi yabü nülirre. ");
INSERT INTO tof_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Da e igósidi gyakolaegu sab ngürrüm. Ene ngürran go tóba müpko. Darrü morroal babula, kolae akó agasilüm, darrpan-darrpan ngürra ne müp amarruda. ");
INSERT INTO tof_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ngibürr kolpam zaz bain-gu, igósüm yabü ta God sab koke zaz nirre. ");
INSERT INTO tof_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Zitülkus módóga, God ta sab yabü dadanzan zaz nirre, e ngibürr pamkolpamzan zaz baindakla. Ma ne atanin klame atanindóla, ene klame marü sab ngibürra mütanirre. ");
INSERT INTO tof_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ia ma moba zonaretan ilküpdü püip iade ngakandóla? A marü moba ilküpdü ne nugup poko-e, ma wa koke iade asendóla? ");
INSERT INTO tof_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ia ma kubó moba zonaretódó igó iade bóktono wagó, ‘Ka kya marü ilküpdü we püip urruanón,’ marü ilküpdü ne nugup poko nómade? ");
INSERT INTO tof_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ma taepurrane bóktan pamla! Ma ngaen-gógópan moba ilküpdü ne nugup poko ugó irrua, da ma sab igósidi tai eseno püip arruanóm moba zonaretan ilküpdügab. ");
INSERT INTO tof_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Godón gyabi elklaza e nurr ume koke nülinane. I yabü sab syórr angónóm kena tübyalüngnüm. E yabiób wirri mani kla ta kyamülab obzek kwata koke amónane. I sab tibiób wapóre ola kena nyólnüm. ");
INSERT INTO tof_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Yatolam Godón, da yabü sab nókyerre. Yamkülam, da e sab esenane. Mamtae alkólam, da God sab yabünkü tapakue. ");
INSERT INTO tof_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Zitülkus módóga, nótó nóma yatole, sab ipüde. Nótó nóma yamküle, sab esene. Mamtae nótó nóma alkóle, God sab tapakue oyankü. ");
INSERT INTO tof_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ia yabü aodó igó pam asine, tóba oloma ne alom nóma bato-e, ia kubó ingülküp ekyene? ");
INSERT INTO tof_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ó wa ne wapim nóma bato-e, ia wa kubó büdülngal ekyene? Koke! ");
INSERT INTO tof_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Enana e kolae tonarr pamakla, e ma umulakla yabiób olmal morroal elklaza gail. Da amkoman, yabü kwitüm Aba sab igósidi ibü abün morroal elklaza gail yarile, oya nidi atodako. ");
INSERT INTO tof_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“E iazan ubi baindakla, pamkolpama yabü ne tonarr ngarkwatódó bangón kwarile, e ta ibü ene tonarr ngarkwatódó bangón kwarilo. Mosesón Gida Buk akó Prropetab Peba, ibü darrpan küp wata módóga. ");
INSERT INTO tof_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“E suran mamtaeana barrbü, ⌊ngarkwat-koke arróldó⌋ tótókóm, zitülkus ⌊metat bólmyan urdü⌋ tótókóm, mamtae wirri taptapase. Kwat ta popadanase ola tótókóm. Abün pamkolpama barrbündasko ene mamtaedóma. ");
INSERT INTO tof_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ngarkwat-koke arróldó tótókóm, mamtae suranato, akó ne kwata tótókdase ola, kari müp kokease. Wata aüdana kuri eserre. ");
INSERT INTO tof_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“E umul-umul kwarilün obae prropetódógab. Yabüka nóma togobe, tumum ngakande, wamaka amkoman ⌊sipako⌋: ibü bóktan tulmil wata morroalako. A ibü auma büb kugupidü büdül tarüka, wamaka amkoman nurr umea, ibü ilklió bülión kari kokea. ");
INSERT INTO tof_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","E sab ibü tibiób tórrmen tulmildügabi nómzyetane, e nugup tibiób ngórrdügabizan bómzyatódakla. Tórez-tórez syepor zidüdügabi, pama ⌊grreip⌋ ngórr koke alküle. Tangel opopordógabi pamkolpama ⌊pig⌋ ngórr koke alküle. ");
INSERT INTO tof_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Da módóga: morroal nugupa wata morroal küp bapónda. Kolae nugupa wata kolae küp bapónda. ");
INSERT INTO tof_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Morroal nugup gaodó kokea kolae küp bapónóm. Kolae nugup ta gaodó kokea morroal küp bapónóm. ");
INSERT INTO tof_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Morroal küp koke ne nugupa bapóndako, ibü singgalgórre da urdü yamserre. ");
INSERT INTO tof_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Da ene inzana, e sab ene pam tibiób tórrmen tulmildügabi nómzyetane. ");
INSERT INTO tof_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ngibürra kürü nidi karrasirrdako wagó, ‘⌊Lod⌋, Lod!’ sab Godón Kingzan Balngomóldó koke barrbüne. Wata sab idi barrbüne, kürü kwitüm Aban ubi nidi tómbapóndako. ");
INSERT INTO tof_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ene Godón Kot Ngürr sab nóma semrróne, abün pamkolpama sab ugón kürüka bóktanórre wagó, ‘Lod! Lod! Gyaurka, ki ta marü ngidü Godón bóktan büdrrat kwarilnürrü, akó ki ta kolae samu pamkolpamdógab aman kwarilnürrü, akó ki ta aüd ⌊arüng tonarr⌋ koke tómbapónónóp!’ ");
INSERT INTO tof_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Da ka sab ibü igó nilnünümo igó, ‘Ka yabübóka umul-kókanla! Kürükagabi ugó ogob, e güblang-koke kolaean tonarr tómbapón pamkolpamakla!’ ");
INSERT INTO tof_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kürü ini bóktan ne pama arrkrruda akó tórrmendó angrinda, wa ⌊wirri gyagüpitótók⌋ pamzana, tóba müót ingülküpdü nótó elórr. ");
INSERT INTO tof_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ngupa timilülürr, tobarr naea blaman byamróklórr, akó wóra wirribóka sibsolürr. Müot enan selkalnóp, da kokean tupürr, zitülkus wa ingülküpdü alangórrón yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Kürü ini bóktan ne pama arrkrruda, da ama tórrmendó koke angrinda, wa gonggo pamzana, tóba müót popa nóresdó nótó elórr. ");
INSERT INTO tof_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngupa timilülürr, tobarr naea blaman byamróklórr, akó wóra wirribóka sibsolürr. Ene müót selkalnóp, da we tupürr. Da amkoman kolae aup tupürr!” ");
INSERT INTO tof_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesun blaman ene bóktana nóma blakónórr, pamkolpamab ngoroa gübarirr aengóp, wa ne ngarkwatódó umul nyónónóp, ");
INSERT INTO tof_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","zitülkus wa ne balngomól arüngi umul bain yarilürr, wa Mosesón gida umulbain pam nórrgrrótóp. ");
INSERT INTO tof_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu pododógabi nóma tübinürr, wirri pamkolpamab ngoroa oyaka zutalórr. ");
INSERT INTO tof_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Da módóga, Yesuka darrü soso azid pama we tamórr. Ene azid pama wakósingül we nülkamülürr Yesun obzek kwata, da wa we bóktanórr wagó, “Lod, ka umulóla, marü ubi ne nóma yarile, ma gaodó namulo kürü ⌊tóman⌋ arrgonóm Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu tóba tang orrakórr, da ene pam we yamurrürr. Yesu oyaka we bóktanórr wagó, “Kürü ubia! Tómana ki barrgo!” Dümdüman ene pama we dólóng bainürr ene soso azidüdügab. ");
INSERT INTO tof_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Da Yesu oyaka we bóktanórr wagó, “Tai turrkrru! Ma darrü olom azazilgu! A ma wam ⌊prristdü⌋, moba bómtyanke, da wa marü büb sopae tai ki ngamka. Yabü ne ngaen Moses ne gida bóktan poko nókyenóp, da ene ⌊gyaur kla⌋ kubó ⌊Godón Gyabi Müótüdü⌋ idódke prrista ola urdü agasilüm marü tóman barrgonóm Godón ilküpdü. Ene igósüm, pamkolpam amtyanóm igó, marü soso azida kuri blakóne, da marü tómana kuri barrgone Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu Kaperrna-um wirri basirrdü nóma bangrinürr, Rrom gazirr pamab kopo ngakan wirri pama Yesuka we tamórr, da oya we yatorr tangbamtinüm. ");
INSERT INTO tof_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Wagó, “Lod, kürü leba zaget olom müótüdü utase. Oya bübdü bidal azidase akó tüób karibóka-koke azid aengdase.” ");
INSERT INTO tof_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu oyaka we bóktanórr wagó, “Ka kubó wamo oya dólóng ainüm.” ");
INSERT INTO tof_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ene gazirr pamab kopo ngakan wirri pama oyaka bóktan we yalkomólórr wagó, “Lod, ma amkoman wirrila kürükagab; ka ngarkwatódó kokela marüka, ma kürü müótüdü koke tübangrino. Ma wata tae opore bókta, da kürü leba zaget oloma kubó dólóng baine. ");
INSERT INTO tof_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ka umulóla marü gaodóma ini poko tónggapónóm, zitülkus ka küób igó olomla, ka ngibürr pamab tüpana zagetdóla. Akó ngibürr gazirr pam asiko, kürü tüpana nidi zagetódako. Ka kubó darrü igó nóma ilo igó, ‘Wam!’ wa kubó wame. Akó darrü igó nóma ilo igó, ‘Tam!’ wa kubó tame. Ka kólba leba zaget olom igó nóma ilo igó, ‘Ene kla tólael!’ wa kubó tólaele. Enta inzana, azida marü bóktan kuri arrkrrue!” ");
INSERT INTO tof_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ini bóktan nóma arrkrrurr, wa we gübarirr aengórr. Wa we bóktanórr ibüka, oya nidi mamoanónóp, wagó, “Ka yabü amkoman poko byaldóla: ka darrü inzan pam koke kuri seserró, kürü amkoman wirri arüngi nótó angunda, Isrraelóm ta kokean! ");
INSERT INTO tof_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ka yabü igó poko byaldóla, abün Zu pamkolpam-koke nidipako, sab blaman bwóbdügab sórrngamóle ini tüpdü: abüsa nólgabi banikda akó abüsa nóla bótaodase. I sab nólgópe banomólórre tibiób mórran pokodó ene garrirrwóm ne yarile Godón Kingzan Balngomól Bwóbdü, mibü wirri abalbobatalpükü Eibrra-am, Aesak, akó Zeikob. ");
INSERT INTO tof_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Zu pamkolpam, Godón Balngomóldó nidi ki kwarile, ibü sab tümün kwatódó amóne. I sab ola yón akó zirrgüp bótak korale.” ");
INSERT INTO tof_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu ene gazirr pamab kopo ngakan wirri pamdó we bóktanórr wagó, “Ugó wam müótüdü. Marü leba zaget olom ka kuri dólóng ina, mazan amkoman kanguna!” Ene tonarr, ene azid oloma dólóng we bainürr. ");
INSERT INTO tof_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu Pitan müótüdü nóma bangrinürr, da Pitan mónang we osenórr. Wa güb azid warilürr, nyórrdü utürrün. ");
INSERT INTO tof_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yesu oya tang we wamurrürr, oya ene azida wata we zumgatórr. Wa we bupadórr, da oya alo kla we ngóyónürr. ");
INSERT INTO tof_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ene simaman, pamkolpama kolae samupükü kolpam Yesuka we tübarrmülürr. Yesu kolae samu bóktanane we amalórr. Wa ta azid kolpam blaman we dólóng nyónónóp. ");
INSERT INTO tof_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesu ene tonarr igósidi tólbael yarilürr Lodón bóktan küppükü ainüm, wa prropet Aesayaka ne poko bóktanórr pamkolpamdó adrratóm wagó, “Mibü blaman azid wa tüób bamselórr akó wa azid aengórr mibü pabodó.” ");
INSERT INTO tof_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesun pamkolpamab ngoroa kal-kal yangónóp, da ibü nóma nósenóp, wa tóba umulbain olmal we nilóp usakü Galili Malu dakla dorrodó baurrüm. ");
INSERT INTO tof_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Darrü Mosesón gida umulbain pama Yesuka ugón tamórr, da oyaka we bóktanórr wagó, “Umulbain Pam, ka sab marüka akyalo, enana ma nega wamlo.” ");
INSERT INTO tof_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu ma oyaka bóktanórr wagó, “Poksab tibiób ngyaben kugupi asiko akó kwitüm póyaeab müótako. A kürü, Pamkolpamab Olom nótókla, darrü ut bwób babula, ka kólba singül ne ingrino ngón ngagónóm.” ");
INSERT INTO tof_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Darrü Yesun umulbain oloma Yesuka we bóktanórr wagó, “Lod, ma kürü ngaen-gógópan ok kyó basirrdü alkomólóm kólba ab gapókdó angrinüm. Ene kakóm, ka marüka ugón tókyeno.” ");
INSERT INTO tof_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu oyaka we bóktanórr wagó, “Tókya kürüka. Büdül nidipako tibiób büdül ki balüngnüm.” ");
INSERT INTO tof_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu tóba umulbain olmalpükü butüdü we kasilürr, da i we ogoblórr. ");
INSERT INTO tof_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Küp amkón babul, wirri arüng wóra we tubsorr Galili Maludü. Goblola but karipoko isurrunópma. Yesu wa ugón ut yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oya umulbain olmala we ogobórr Yesuka, irsümülóp, da we bóktónóp wagó, “Lod, mibü zid tinünüm! Mi brariakla!” ");
INSERT INTO tof_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu ibüka bóktan we yalkomólórr wagó, “E gum iadeakla? Yabü amkoman bangun wata karia kürüka!” Yesu bupadórr, da wór akó goblol we nagóp wagó, “Piküp bainam!” Da malua we amkónórr. ");
INSERT INTO tof_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ene butüdü pama gübarirr aengóp. Da i we bóktónóp wagó, “Ini wa ia oloma? Wór akó malua ta oya bóktan arrkrrudamli!” ");
INSERT INTO tof_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu tóba umulbain olmalpükü Gadarra wirri basirr pamkolpamab bwóbdü abzilürr, malu dakla dorro. Nis pam nisa Yesun we semrrarri. Ibü büb kugupidü kolae samu koralórr. Ene pam nisa gapók balüng bwóbdügabi turrürri. I kari gum angón pam nis ta koke namülnürri akó pamkolpama ta ene kwatana koke igósidi agóltagól kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Da módóga, ene pam nisa we taegwarr apórri Yesuka wagó, “Marü ubi ia larógóma kibüka, Godón Olom? Ia ma kibü wirri azid akyanóm tama? Kibü ngürr go küsila!” ");
INSERT INTO tof_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ibükagab barrkyanan kan yarilürr, wirri tang kyamül yabüla we ololórr. ");
INSERT INTO tof_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ene kolae samua Yesun we yatop wagó, “Ma ne kibü nóma semono ini pam nisdügab, da kibü kubó ene kyamül yabülab büb kugupidü zirrtapónónómke.” ");
INSERT INTO tof_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ibüka we bóktanórr wagó, “Ugó ogob!” Da ene kolae samua ene pam nis we nümgütóp, ama kyamülab bübdü we barrbünürr. Da módóga, ene kyamül yabüla buso-buso we tübabinürr buruburuana, mengrempükü ama Galili Maludü we bagóbórr, ó ola nae baitóp büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ene kyamül ngabkan pama we busuóp ama Gadarra wirri basirrdü. I pamkolpam umul-umulan ngintinóp blaman ne tonarra tólbaelórr kyamüldü akó kolae samupükü pam nis nidi namülnürri. ");
INSERT INTO tof_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Da módóga, blaman ene wirri basirran pamkolpama Yesun asenóm togobórr. I oya nóma esenóp, da i oya arüngi we yatop tibiób bwób amgatóm. ");
INSERT INTO tof_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu butüdü kasilürr, ama malu dakla dorrodó we banikürr tóbanan wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Da módóga, Yesuka darrü büb bidal pam we sidüdóp, nyórrdü utürrün. Yesu ibü amkoman bangun nóma esenórr, wa ene büb bidal pamdó bóktanórr wagó, “Kürü olom, ma arüng ipa! Ka marü kolae tonarr kuri norrgonónóma!” ");
INSERT INTO tof_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ngibürr Mosesón gida umulbain pama tibióbbóka wagó, “Ini pama Godón pabo apadóm kainda!” ");
INSERT INTO tof_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu ibü gyagüpitótók yazebórr, da wa ibüka we bóktanórr wagó, “E wa inzan kolaean poko iade gyagüpi tótókdakla yabiób moboküpdü? ");
INSERT INTO tof_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ini nis bóktan nisdügab, ia kürüka ulan nadü bóktana bóktanóm? Ia, ‘Marü kolae tonarr barrgorrónako,’ ta ia, ‘Bupa, da ma agólóm bai?’ ");
INSERT INTO tof_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Da kürü ubi igósüma, e kubó ini kla umul bainane wagó, Pamkolpamab Oloman balngomól arüng asine ini tüpdü kolae tonarr barrgonóm.” Da wa ene büb bidal pamdó bóktanórr wagó, “Ugó bupa, moba nyórr ipa, da ugó wam moba müót basirrdü.” ");
INSERT INTO tof_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ene pama bupadórr, da tóba müót basirrdü we wamórr. ");
INSERT INTO tof_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Pamkolpamab ngoroa nóma esenóp, ibü guma sazebórr, da Godón we yagürnóp, zitülkus wa ne balngomól arüng sekyanórr pamakan. ");
INSERT INTO tof_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu ene poko we amgatórr. Wazan wamlórr, wa ⌊taks mani dakabain pam⌋ we esenórr, ngi Metyu, tóba kari zaget müótüdü mórrande. Yesu oyabóka wagó, “Yao, ma kürüka tókya!” Metyu we bupadórr, oyaka we akyanórr. ");
INSERT INTO tof_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ene kakóm, Yesu tóba umulbain olmalpükü Metyun müótüdü nóma alo yarilürr, abün taks mani dakabain pam akó kolae tonarr kolpama we togobórr, inkü alom ene tógaldó. ");
INSERT INTO tof_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ngibürr Parrisia ene poko nóma esenóp, da i Yesun umulbain olmal nümtinóp wagó, “Yabü umulbain pama iade aloda taks mani dakabain pam akó kolae tonarr kolpampükü?” ");
INSERT INTO tof_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ibü nurrkrruóp, da bóktanórr ibüka wagó, “Azid-koke kolpam nidipako, i dokta koke amkündako, wata azid nidipko. ");
INSERT INTO tof_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Da ugó ogob amkünüm ini Godón bóktanan küp ia laróga: ‘Kürü ubi inzanóma, e wata ⌊urdü amsel lar⌋ koke simarruane, a e ta gyaur kwarilo pamkolpamdó.’ Ka ini pokodó dümdüm ngyaben pamkolpam ngibaunüm koke tamórró, a ka kolae tonarr pamkolpam ngibaunüm tamórró Godka byalüngüm kolae tonarrdógab.” ");
INSERT INTO tof_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Darrü tonarr, Zon ⌊Baptaes Bain⌋ Paman umulbain olmala Yesun amtinüm togobórr wagó, “Parrisia akó kidi, alo bobarr iade bütókdakla, a marü umulbain olmala ma alo koke bütókdako?” ");
INSERT INTO tof_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu tóbakwata alap-alap bóktanórr ibüka wagó, “Yabü gyagüpitótók iada, pamkolpama kol amióg tóredó ia kubó gyaur-gyaur bobrrale, kol amióg pam ibüka nómade? Koke! A ene ngürr sab semrróne, kol amióg pam ibükagabi nóma sipüdrre. Da i sab alo ugón bütókrre. ");
INSERT INTO tof_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Darrü oloma küsil mórrkenyórr poko koke arrgüpe ngaep mórrkenyórrdü tae murrausüm, zitülkus ene küsil mórrkenyórr pokoa nóma korrom baine, ene ngaep mórrkenyórr sab amurrute da batürre, ama tai wirri tae ine. ");
INSERT INTO tof_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Küsil waen koke errngómórre ngaep lar sopae beledó, zitülkus ene sopae belea kubó bamkene. Waena kubó bókóne akó ene lar sopae belea kolae baine. Igósidi, küsil waen wata küsil lar sopae beledó errngómórre. Nizan igósidi morroal pokodó namüli.” ");
INSERT INTO tof_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu ibüka nóma bóktan yarilürr, da módóga, darrü ⌊Zu pamkolpamab kwóbbazen müót⌋ ngakan pama ugón tübzilürr Yesuka. Wa tóba wakósingül we nülkamülürr oya obzek kwata. Yesunbóka wagó, “Kürü ngul oloma wata errkyadan kuri nurrótóke. Gyaurka, kya tam moba tang oyaka amngyelóm. Igósidi wa kubó arróldó tolkomóle.” ");
INSERT INTO tof_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Da Yesu bupadórr, ene paman solkwat we akyanórr. Oyaka umulbain olmala ta zutalórr. ");
INSERT INTO tof_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","I nóma ogoblórr kwat-kwat, da módóga, darrü kola Yesun kakota we katókórr, da oya tumum mórrkenyórr zarr we yamurrürr. Ene kola óe bókan azid balmil warilürr 12 pailüm. Wa tóba gyagüpdü bóktan warilürr wagó, “Ka ne kubó wata oya tumum mórrkenyórr nóma yamurro, ka kubó dólóng baino.” ");
INSERT INTO tof_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu tóba kakota byalüngürr, da ene kol we osenórr. Oyabóka wagó, “Ma arüng ipa, kürü olom! Marü moba amkoman banguna dólóng kuri mine.” Wata ugósan ene kola we dólóng bainürr. ");
INSERT INTO tof_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu ene Zu pamkolpamab kwóbbazen müót ngakan paman müótüdü nóma bangrinürr, wa tatarror bapul pam nósenóp, akó ene pamkolpamab ngoro, yón gyaure popa nidi bódean kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu ene pamkolpambóka wagó, “E blamana algabi ugó baus, zitülkus ini kari ngul olom go büdül kokeo, a wa go uto.” Ene pamkolpama ma Yesun ngüóng angyalnóp, zitülkus i umul kwarilürr wagó, wa go amkoman büdülano. ");
INSERT INTO tof_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesu ene pamkolpamab ngoro nóma zirrnapónóp pulkaka, wa we bangrinürr ngul olom ne pokodó warilürr. Wa oya tangdó omoanórr, da we bupadórr. ");
INSERT INTO tof_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ne pokoa tómbapónórr, pamkolpama ene bóktan we ayonóp blaman ene bwób órdó ne basirr koralórr. ");
INSERT INTO tof_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu ene poko we amgatórr. Wa enezan wamlórr, kwat-kwat, nis ilküp murrbausürrün pam nisa oya solkwat we akyan namülnürri, da i oyaka we górrgarri wagó, “⌊Deibidün Olom⌋, kibü gyaur tóse!” ");
INSERT INTO tof_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu müótüdü nóma bangrinürr, ene pam nisa ta bangrirri, da oyaka we turrürri. Yesu ibübóka wagó, “E ia kürü amkoman angundamli igó, kürü ene arüng asine yabü dólóng ainüm?” I bóktan yalkomórri wagó, “Ó, Lod! Ki marü amkoman angundamli.” ");
INSERT INTO tof_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yesu ibü ilküp nyamurrürr da ibübóka wagó, “E kürüzan amkoman angundamli, ini tonarra wata amkoman ki tómbapó yabüka!” ");
INSERT INTO tof_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ibü nizanab ilküpa we tomgolóp. Yesu ibü wirri arüng bóktan we nókyanórr wagó, “E kubó darrü pam azazilgu!” ");
INSERT INTO tof_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","A i ene poko nóma amgatrri, i Yesunkwata ene bóktan we büdrratkü aurrnürri blaman basirr-basirrdüma ene bwób órdó. ");
INSERT INTO tof_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ene pam nisazan amgatnórri, da módóga, ngibürr kolpama Yesuka pam ugón sidüdóp. Wa koke bóktan yarilürr, zitülkus oya büb kugupidü kolae samu asi yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu kolae samu nóma amanikürr, ene pama bóktan we ngarkwat bókyanórr. Pamkolpamab ngoroa gübarirr aengóp. I tibióbka bóktanónóp wagó, “Mi ngaen ta inzan kla kokean esenóp ae Isrraelóm!” ");
INSERT INTO tof_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","A Parrisia ma tibióbka igó bóktanónóp wagó, “Satani, kolae samuab singüldü pam nótóke, oya ene arüng wató akyanda kolae samu amanóm.” ");
INSERT INTO tof_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu blaman ene bwóbdüma wamlórr, wirri akó kari basirrdüma, Zu pamkolpamab kwóbbazen müótüdü umul bainkü akó Morroal Bóktan amgolkü Godón Kingzan Balngomólankwata. Wa pamkolpam dólóng nyónónóp tibiób blaman ia-ia azidüdügab. ");
INSERT INTO tof_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wa pamkolpamab ngoro nóma nósenóp, ibüka kari gyaur koke yarilürr, zitülkus i kari müpdü ta koke koralórr, akó darrü tangbamtin koke esenóp. I ⌊sipzan⌋ koralórr, sip ngabkan pam babul nibiób koralórr. ");
INSERT INTO tof_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yesu tóba umulbain olmaldó bóktanórr wagó, “Abül ta kari kokea, a zaget pam ma abün kokeako ene alo kla abülüm. ");
INSERT INTO tof_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","We ngarkwatódó, e Lodka tóre kwarilün, abül zitülkus olom nótóke, akó oya imtinamke zaget kolpam zirrbapónóm alo kla abülüm.” ");
INSERT INTO tof_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu tóba 12 umulbain olmal tóbaka ngibaunürr. Wa ibü balngomól arüng nókyenóp kolae samu amanóm ó pamkolpam dólóng byónüm blaman tibiób wirri a kari azidüdügab. ");
INSERT INTO tof_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ene 12 apostolab ngi módógako: ngaen-gógópan Saemon (akó ngiliarrón Pita), solkwat oya narezoret Endrru, Zeims akó oya zoret Zon, Zebedin olom nis nidi namülnürri, ");
INSERT INTO tof_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Barrtolomyu, Tomas, Metyu, taks mani dakabain pam nótó yarilürr, akó darrü Zeims, Alpeiusün olom nótó yarilürr, Tadeius, ");
INSERT INTO tof_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","akó darrü Saemon, ngaen Zilot pam nótó yarilürr, dómdóm ma Zudas Iskarriot, Yesun sab nótó ingrine wirri ngi pamab tangdó. ");
INSERT INTO tof_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu tóba ini 12 umulbain olmal solkwat zirrnapónóp zagetóm. Ngaen-gógópan wa ikik bókrran yarilürr tibiób zagetankwata wagó, “Zu-koke nidipako, e ibü bwób órdóbóna tótókgu. Akó ⌊Samarria⌋ pamkolpamab wirri basirrdü ta inzan. ");
INSERT INTO tof_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","A e wata sab Isrrael Müótüdü pamkolpamdó ogobke, zitülkus i Godón bamrükürrün ⌊sipako⌋. ");
INSERT INTO tof_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E sab ola nóma ogobo, da ini bóktan amgolamke magó, ‘Godón Balngomóla minggüpanandó kuri tame!’ ");
INSERT INTO tof_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Azid pamkolpam dólóng nyólamke, ursilünke büdül pamkolpam, kolae sopae azid nidi balmildako dólóng nyólamke, akó kolae samu zomalónke. E ini arüng popa yazebane, darrem babul; e ta popa inzan gail kwarilo. ");
INSERT INTO tof_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","E ⌊gold⌋, ⌊silba⌋, akó kopa mani amarrugu yabiób pam alópdó. ");
INSERT INTO tof_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Akó ngibürr kla amarrugu yabiób agóltagólde: angasangap angón alóp, ngibürr mórrkenyórr, ngibürr wapórdó bamel kla, akó tupuru. Zitülkus módóga, zaget paman dümdüm asine tóba alo kla azebóm ibükagab, nibiób tangbamtinda. ");
INSERT INTO tof_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“E wirri basirrdü ó kari basirrdü nóma barrbuno, basirr kolpam nümtinamke morroal tonarr olom nótóke. E wata oyaka bamilke, kókó e ene basirr sab amgütane. ");
INSERT INTO tof_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","E müótüdü nóma barrbuno, da bóktónamke magó, ‘Paud asi ki yarilün ini müótüdü!’ ");
INSERT INTO tof_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ene müót kolpama yabü ne morroal nóma nóserre, ene paud wata ibüka ki yarilün. A i yabü ne morroal koke nóma nóserre, ene pauda yabüka ki tolkomól. ");
INSERT INTO tof_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Müótüdü pamkolpam ó basirr pamkolpama yabü ne morroal tonarre koke nóma yazebrre akó yabü bóktan koke nóma arrkrru kwarile, ene basirr amgütamke, wapórdó buru we bainamke. ");
INSERT INTO tof_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ka yabü amkoman poko byaldóla: Godón Kot Ngürrdü, wa sab Sodom akó Gomorra wirri basirr pamkolpam ⌊kolaean darrem⌋ nókyerre. A wa ma ini basirr pamkolpam tai wirrian kolaean darrem nókyerre. ");
INSERT INTO tof_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“E tübarrkrru! Ka yabü zirrbapóndóla arüng-koke sipzan wirri nurr ume ngorodó. E umul-umul ngyaben kwarilo gwarzan. Akó e ta nurre póyaezan kwarilo: wa kolae tonarr koke tómbapónda. ");
INSERT INTO tof_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","E umul-umul kwarilünke pamab gum. I yabü sab wirri pamab tangdó urrbule kotóm. I yabü sab karrkukus sye-i ola nyólnórre tibiób kwóbbazen müótüdü. ");
INSERT INTO tof_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Kürübókamde i sab yabü imarrunórre gabena akó king, ibü obzek kwata, kürükwata Morroal Bóktan amgolóm ibüka akó Zu-koke nidipako. ");
INSERT INTO tof_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","I sab yabü wirri pamab tangdó nóma urrbule kotóm, e gyakolaegu e sab iazan bóktónane akó e sab ia poko bóktónane. Zitülkus módóga, ene tonarrdó Godón Samua yabü bóktan wató nülirre bóktanóm. ");
INSERT INTO tof_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Zitülkus módóga, yabü kubó ne bóktan yarile, yabü yabióbankagab koke yarile. Ene bóktana sab yabü Aban Samudügab tame, yabü ulitüdügabi ne bóktan yarile. ");
INSERT INTO tof_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Pamkolpama sab tibiób zonaretal wirri pamab tangdó urrbule büdüldü arrbünüm, akó abala ta sab dadanzan kairre tibiób olmaldó. Olmala sab tibiób aipalabaldó bóka bamgün kwarile akó ibü ta sab inzan wirri pamab tangdó urrbule büdüldü arrbünüm. ");
INSERT INTO tof_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Blaman pamkolpama yabü sab alzizi zomale, zitülkus e kürü mamoandakla. A kürü amkoman angunüm karrkukus nótó zamngólda kókó blakón tonarrdó, God sab oya zid ine. ");
INSERT INTO tof_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Yabü wirri müp nóma alión korale ene basirrdü, olgabi busuamke ama darrü basirrdü. Zitülkus módóga, ka yabü amkoman poko byaldóla: e sab koke elakónane Godón Morroal Bóktan büdrrat Isrraelóm blaman ne wirri basirrdü kókóta ka, Pamkolpamab Olom nótókla, sab akó tüpdü nóma tolkomolo. ");
INSERT INTO tof_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Umulbain olom wirri kokea tóba umulbain pamdógabi, akó ⌊leba zaget olom⌋ wirri kokea tóba wirri pamdógabi. ");
INSERT INTO tof_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Umulbain oloman gaodóma tóba umulbain pamzan bainüm, oya ubi koke ki yarile tóba umulbain pam arrgrratóm. Leba zaget paman gaodóma tóba wirri pamzan bainüm, oya ubi koke ki yarile tóba wirri pam arrgrratóm. Da ene ta inzana: müót olom Be-elzebulbóka ngilian kwarilürr, da tóba müótan kolpam sab ma amkoman kolaean ngi basil kwarile! ");
INSERT INTO tof_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“We zitülkusdü, e inzan pamkolpamab gum koke koralo. Blaman ngablaorrón ne elklazako errkya, sab ma ngabratórrón kwarile, ó blaman barrón ne elklazako, sab amarrón kwarile panzedó. ");
INSERT INTO tof_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ka yabüka ne poko bóktandóla tümündü, ene dadan poko sab akó ngürr zyóndü amgolamke. Ka yabü güblang küpande ne bóktan nókyenónóma, e sab mórrkakakdógabi amgolamke. ");
INSERT INTO tof_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Da e ibü gum bangón-gu, büb nidi amkaldako. I ma gaodó kokeako samu amkalóm. A e Godón gum koralo, zitülkus oya arüng asine büb a samu ⌊metat bólmyan urdü⌋ agasilüm. ");
INSERT INTO tof_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ia pamkolpama kubó nis kari póyae nis darrpan kari mani küpi koke nümigórre? A yabü Ab wa umula, darrüpa tüpdü nóma tupe! ");
INSERT INTO tof_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yabü órrngóen ta blaman bótangórrónako. God blaman kla umula yabükwata. ");
INSERT INTO tof_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Da e wa igósidi gumgu, zitülkus e Godón ilküpdü wirrianakla abün kari póyaepókaldógab! ");
INSERT INTO tof_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Tóba pamab obzek kwata nótó nóma pupo baile igó, ‘Ka Yesunla,’ ka ta sab oya dadanzan pupaino kólba kwitüm Aban obzek kwata igó, ‘Wa kürüne.’ ");
INSERT INTO tof_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","A kürü nótó nóma kalpine pamkolpamab obzek kwata, ka ta sab oya yalpino kólba kwitüm Aban obzek kwata. ");
INSERT INTO tof_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“E igó gyagüpitótókgu igó, ka wata tamórró paud ódódóm ini tüpan pamkolpamdó! Koke, ka wa paud koke sidódürrü, ka wa gazirr turrik sidódürrü! ");
INSERT INTO tof_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ka ugósüm tamórró, sab ini klama tómbapónórre: siman oloma sab tóba ab bóka bamgün yarile. Óp oloma sab tóba aipdü bóka bamgün warile. Kolalkota ta tóba kolalkotódó bóka bamgün warile. ");
INSERT INTO tof_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Kürübókamde, paman tóbanan müótan kolpam, sab tai oyaka bóka bamgün idi korale. ");
INSERT INTO tof_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Nadü oloman ⌊moboküpdü ubi⌋ wirria tóba ab akó aipdü, a inzan wirri moboküpdü ubi babula kürüka, wa ngarkwatódó kokea kürü mamoanóm. Nadü paman moboküpdü ubi wirria tóba siman olom akó ngul olomdó, a inzan wirri moboküpdü ubi babula kürüka, wa ngarkwatódó kokea kürü mamoanóm. ");
INSERT INTO tof_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ubi-koke nótóke tóba krros bügasilüm akó kürü solkwat akyanóm, wa ngarkwatódó kokea kürü wapór omkor mamoanóm. ");
INSERT INTO tof_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nadü olom ubi yarile tóba tüpan arról zürük amiógüm, wa sab tóba ⌊ngarkwat-koke arról⌋ imrüke. A nadü oloma sab tóba tüpan arról imrüke kürübókamde, wa sab tóba ngarkwat-koke arról esene. ");
INSERT INTO tof_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Yabü morroal tonarre nótó nóma azebda, enta igósa, wa kürü morroal tonarre apadóda. Ó kürü morroal tonarre nótó nóma apadóda, enta igósa, wa Godón morroal tonarre apadóda, kürü nótó zirrkapónórr. ");
INSERT INTO tof_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Prropet morroal tonarre nótó nóma apadóda, zitülkus ene wa prropeta, wa sab prropetan darrem ipüde. Akó dümdüm ngyaben pam morroal tonarre nótó nóma apadóda, zitülkus ene wa dümdüm ngyaben pama, wa sab ta dümdüm ngyaben paman darrem ipüde. ");
INSERT INTO tof_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ka yabü amkoman poko byaldóla: popa kolpam wata enan gübarr nae nótó nóma nókyerre anónóm, zitülkus i kürü mamoan olmalako, ene oloma sab tóba darrem kla kokean arene.” ");
INSERT INTO tof_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesun tóba 12 umulbain olmaldó tibiób zagetankwata ikik bókrrana nóma blakónórr, wa ibü we zirrnapónóp. Tüób we wamlórr pamkolpam umul bainkü akó Morroal Bóktan amgolkü ngibürr minggüpanandó ne wirri basirr koralórr Galili prrobins kugupidü. ");
INSERT INTO tof_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zon Baptaes Bain Pam ugón tümün müótüdü yarilürr. Wa nóma arrkrrurr Kerriso ne kla tómbapólórr, da wa tóba umulbain pam we zirrnapónórr oya amtinüm ");
INSERT INTO tof_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","wagó, “Kibü kóbó tüzazilnüm, ia ma módógla nótó ki tame, prropeta noabóka apón kwarilürr, ta ia ki darrü pam akyan kwarilo?” ");
INSERT INTO tof_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu ibüka bóktan yalkomólórr wagó, “Ugó alkomólam, da Zonón izazilamke, e ne poko arrkrrudakla akó ne kla basendakla: ");
INSERT INTO tof_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ilküküp murrbausürrün nidi kwarilürr, errkya basendako, akó wapór bidal nidi kwarilürr, errkya agóldako. Soso azid nidi balmilnóp, errkya dólóng airrünako. Güblang murrbausürrün nidi kwarilürr, errkya arrkrrudako. Büdül nidi kwarilürr, akó arrólako. Akó elklaza-koke pamkolpama Godón Morroal Bóktan arrkrrudako. ");
INSERT INTO tof_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bagürwóm watóke, ninis gyagüpitótók babul noakame kürükwata!” ");
INSERT INTO tof_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Zonón umulbain pama nóma bakonórr, Yesu ugón pamkolpamab ngorodó bóktan we bókyanórr Zonónkwata wagó, “E wa ⌊ngüin-koke bwóbdü⌋ laró asenóm ogobnórró? Ia e twal asenóm ogobnórró, wóra ne kla angapda? Koke! ");
INSERT INTO tof_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Da e wa tai laró asenóm ogobnórró? Ia morroal mórrkenyórr bamelórrón pam? Koke! Morroal mórrkenyórr nidi bameldako, kingab wirrian müótüdü ngyabendako, a ngüin-koke bwóbdü koke. ");
INSERT INTO tof_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Da e wa tai laró asenóm ogobnórró ngüin-koke bwóbdü? Ia prropet? Ó, ene amkoman. Ka yabü igó byaldóla, e wa amkoman wirrian pam esenarre ngibürr prropetódógab. ");
INSERT INTO tof_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Zon we pama, Godón Wialómórrón Bóktana noanbóka apónda, God ⌊Kerrisodó⌋ ne poko bóktanórr wagó, “‘Turrkrru! Ka sab kólba bóktan ódód pam zirrapono marü singül kwata. Wa sab marünkü kwat wató ngagróte.’ ");
INSERT INTO tof_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ka yabü amkoman poko byaldóla: darrü pama koke kuri tómtómólórr wirrian nótóke Zon Baptaes Bain Pamdógab. A kari ngi olom nótóke Godón Kingzan Balngomóldó, wa wirriana Zonkagab. ");
INSERT INTO tof_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Zon Baptaes Bain Pam wa tóba bóktan ne tonarr amgol yarilürr kókó errkya, pamkolpama Godón Kingzan Balngomóldó zirrapón-apón bóka bamgündako akó zóngang pamkolpama arrbainüm kaindako arüngpükü. ");
INSERT INTO tof_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Blaman prropet akó Mosesón Gida umulbain pama Godón Balngomólankwata bóktan kwarilürr, kókó ta Zon tübzilürr. ");
INSERT INTO tof_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Da e ubi ne nóma bainane kürü bóktan amkoman angunüm: prropeta nóma wialómórr igó: God sab Ilaezan zirrsapóne, wa amkoman Zonónkwata bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Güblang noane arrkrrum, wa ki turrkrru! ");
INSERT INTO tof_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ia ka ini lüólan pamkolpam larópükü nütaninümo? I kari olmalpókalzanako, pul basirrdü nidi mórrandako akó tibiób gómdamaldó górrgandako wagó, ");
INSERT INTO tof_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Ki yabünkü marret tatarror apul kwarilnürrü, a e zil koke kwarilnürrü; ki büdül yónamto wórr bato kwarilnürrü, a e yón gyaur koke kwarilnürrü.’ ");
INSERT INTO tof_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ka ini poko igósidi byaldóla, zitülkus Zon Baptaes Bain Pama nóma tamórr, wa alo bütóklürr, akó waen koke enólórr. We zitülkusdü, i igó bóktandako wagó, ‘Oya bübdü kolae samua ngyabenda!’ ");
INSERT INTO tof_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A ka, Pamkolpamab Olom nótókla, nóma tamórró, ka alo akó anón namülnürrü. Akó we zitülkusdü, i kürübóka igó apóndako wagó, ‘Ngakónam, wa barngin-koke alo akó gorrgorr bain pama! Wa ⌊taks mani dakabain pam⌋ akó kolae tonarr pamkolpamab gódame!’ A kürü amkoman bangun pamkolpama ne dümdüm elklaza tómbapóndako, igó poko okaka amzazildako, Godón ⌊wirri gyagüpitótók⌋ amkomana.” ");
INSERT INTO tof_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ene kakóm, Yesu barre ⌊arüng tonarr⌋ ne ngibürr basirrdü tómbapón yarilürr, wa ngarkwat we bókyanórr ene basirr pamkolpam wirribóka batüngüm, zitülkus i Godka kokean byalüngnónóp tibiób kolae tonarrdógabi. ");
INSERT INTO tof_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Wagó, “Sab Godón ngürsila tame marüka, Korrazin wirri basirr! Akó sab Godón ngürsila tame marüka, Betsaeda wirri basirr! Ka Taerr akó Saedon wirri basirr nisdü ene arüng tonarr ne nóma ki tómbapóla, ka yabüka ne arüng tonarr tómbapólórró, ene basirr pamkolpama gyaur mórrkenyórr ngaen ki bamelórre, akó urtók buru ki olokól tibiób singüldü, Godka okaka azazinüm wa, i tibiób kolae tonarrdógabi kuri tübyalüngórre. ");
INSERT INTO tof_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Da ka yabü igó byaldóla, Godón Kot Ngürrdü wa Taerr akó Saedon pamkolpam ⌊kolaean darrem⌋ nókyerre. A wa ma sab yabü, Korrazin akó Betsaeda, tai wirrian kolaean darrem tókyerre. ");
INSERT INTO tof_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Akó mató, Kaperrna-um wirri basirr, ma ia igó gyagüpitótókdóla, God sab marü kwitüdü mómngyele? Kokean! Ma sab bangrino tüpdü, büdülab bwóbdü! Ka Sodomóm ne dadan arüng tonarr nóma ki tómbapóna, marükazan tómbapólórró, wa errkya asi ki yaril. ");
INSERT INTO tof_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Da ka marü igó ayaldóla, Godón Kot Ngürrdü wa sab Sodom pamkolpam kolaean darrem nókyerre, a wa ma mató, Kaperrna-um, marü sab tai wirrian kolaean darrem mókyene.” ");
INSERT INTO tof_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ene tonarrdó Yesu Godka bóktanórr wagó, “Ka marü agürdóla, kürü Ab, tüp a pülpülan Lod, zitülkus ma ini elklazab amkoman küp iniknürrü wirri gyagüpitótók akó wirri susumüri pamdógabi, da errkya ma popa kolpamdó kuri okaka sizazina, marü kari olmalzan nidi amkoman angundako. ");
INSERT INTO tof_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Amkoman, kürü Ab, ma tónggapórró ini kwata, zitülkus marü wirri ubi inzanóm yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Blaman kla kürü Aba kuri küliónürr. Darrü olom umul-kóka Godón Olombóka, wata Ab umul tebea. Akó darrü olom umul-kóka Abbóka, wata oya Olom umul tebea, akó wa nibiób aleanda tóba Ab okaka amzazilüm. ");
INSERT INTO tof_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Yao, e blamana kürüka togob, yabü müp amarrudi genggorrama nóma yazebe. Yabü ngón bagón kótó nülinünümo. ");
INSERT INTO tof_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","E kürü balngomól sipüdam akó kürü tonarr umul bainam, zitülkus ka mómók tonarrla akó ka kólba ngi kwit koke baindóla. E sab igósidi yabiób samuan ngón bagón esenane. ");
INSERT INTO tof_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ka yabü ne ngarkwatódó balngomóldóla, wa morroala, akó ka yabü ne müp alióndóla, wa ula.” ");
INSERT INTO tof_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wirri ngarkwat babul, Yesu tóba umulbain olmalpükü Sabad ngürrdü ⌊wit⌋ apapana tótók yarilürr. Oya umulbain olmal aloa nóma yazebórr, da wit küp we zulkulóp, da alokü ogoblórr. ");
INSERT INTO tof_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parrisia nóma esenóp, i Yesuka we bóktónóp wagó, “Ngaka! Marü umulbain olmala darrü zaget tónggapóndako, gyabi ne klame Sabad ngürrandó!” ");
INSERT INTO tof_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu ibüka we bóktanórr wagó, “E ia koke kuri etóngarre Godón Wibalómórrón Bóktandó, Deibid ne kla tónggapónórr, we tonarr, wa tóba pam kopopükü alom nóma yarilürr? ");
INSERT INTO tof_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Wa Godón ⌊Palae Müótüdü⌋ bangrinürr, da prrista ne gyabi brred urrbulürr Godón obzek kwata, tóba pampükü we elorr! Wa ne gyabi yarilürr alom, Mosesón gida ngarkwatódó, i we kla elop. Mosesón gida ngarkwatódó, wata dümdüm ibü yarilürr ene brred alom, prrist nidi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Akó e ia koke etóngarre Mosesón gida wagó, blaman Sabad, prrista zagetódako, da i ta Sabad gida alkamüldako? Da ene ma ugón iada? Godón ilküpdü, i ugón darrü kolae koke tónggapóndako. ");
INSERT INTO tof_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka yabü igó byaldóla, ini pokodó pam asine wirrian nótóka ⌊Godón Gyabi Müótüdügabi⌋! ");
INSERT INTO tof_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godón Buka igó bóktanda wa, ‘Kürü ubi inzanóma, e wata ⌊urdü amsel lar⌋ koke simarruane, a e ta gyaur kwarilo pamkolpamdó.’ E ne tai ini bóktanan küp umul nóma ki kwarila, e ibükwata, kolae-babul nibióbko, koke ki bóktónane igó, i kolae tonarr kuri tómbapórre. ");
INSERT INTO tof_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Zitülkus módóga, ka Pamkolpamab Olomzanla, ka Sabadan Lodla.” ");
INSERT INTO tof_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu ene wit apap amgatórr, ama darrü ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ bangrinürr. ");
INSERT INTO tof_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Da módóga, ola darrü pam yarilürr, tutul tang bidal akó sarrpi airrün. Ngibürr Parrisiab ubi yarilürr Yesun kotóm ain bóktan amanóm tóba bóktan tulmildügabi. Da i we imtinóp wagó, “Mibü gidadógab ia taia Sabad ngürrdü pam dólóng ainüm?” ");
INSERT INTO tof_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu bóktan yalkomólórr wagó, “Yabü darrüpan ne ⌊sip⌋ nóma yarile, da kukurru kugupidü nóma aupe Sabad ngürrdü, ia ma ene kugupidügab koke irruno, ama kwitüdü sigasilo? Amkoman, ma ma kubó büsai-büsai arruanóm wamo. ");
INSERT INTO tof_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Da pam wa kari kla kokea sipdügabi. Módóga, mibü gidadógab wa taia morroal tónggapónóm Sabad ngürrdü.” ");
INSERT INTO tof_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Da wa ene pam we yalórr wagó, “Moba tang ugó adrrat.” Wa adrratórr, da oya tanga tóba gaodó alkomólórr, tai we bainürr darrü tangzan. ");
INSERT INTO tof_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parrisia kwóbbazen müót amgütóp, Yesun amkal bóktan we ingrinóp. ");
INSERT INTO tof_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu umul yarilürr wagó, Parrisia oya amkal bóktan tónggapón kwarilürr, da ene poko we amgatórr. Abün pamkolpama oyaka we zutalórr. Wa blaman azid is we dólóng nyónónóp, ");
INSERT INTO tof_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","da ibü arüng bóktan we nókyenóp wagó, “Ngibürr büzazilgu ka nótókla.” ");
INSERT INTO tof_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Yesu blaman ini poko igósidi tómbapónórr, Lodón bóktan küppükü ainüm, wa prropet Aesayaka ne poko bóktanórr pamkolpamdó adrratóm wagó, ");
INSERT INTO tof_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ngakónam, ini kürü zaget pame, ka noan ipadórró, ka noaka ubila akó ka noan bagürdóla. Ka sab oyaka kólba Samu ingrino, akó wa sab kürü dümdüm ngyabenankwata bóktan wató ayole ibüka, Zu-koke nidipko. ");
INSERT INTO tof_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Wa sab koke ongyal akó taegwarr yarile. Pamkolpama oya sab wirri arüngi bóktande koke arrkrru kwarile kwatódó. ");
INSERT INTO tof_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wa sab koke alkamüle arrngür-arrngür surpid, akó ne zyón klaman zyóna kari bainda, wa sab koke itamüne, kókó wa sab kolae errgrróte tóba dümdüm balngomóle. ");
INSERT INTO tof_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Zu-koke nidipko, i sab oya amkoman yangurre tibiób zid bainüm.” ");
INSERT INTO tof_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Da ngibürr kolpama Yesuka pam ugón sidüdóp. Wa ilküküp murrbausürrün akó koke bóktan yarilürr, zitülkus oya büb kugupidü kolae samu asi yarilürr. Yesu ene pam we dólóng yónürr, wa igósidi bóktanóm bainürr akó ilküp nisa we bamgorri. ");
INSERT INTO tof_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ene dudu pamkolpamab ngoroa gübarirr aengóp. I tibiób we bamtinónóp wagó, “Ia ini aprrapórr ⌊Deibidün Olome⌋?” ");
INSERT INTO tof_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parrisia nóma barrkrrurr inikwata, tibióbka we bóktanónóp wagó, “Wata kolae samuab singüldü pam Be-elzebul nótóke, ini pam ene arüng wató akyanda kolae samu amanóm.” ");
INSERT INTO tof_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu ibü gyagüpitótók umul bainürr, da wa ibüka we bóktanórr wagó, “Darrü kingan balngomól bwób pamkolpama tibiób nóma bürrgrrütórre, tibióbka bóka bamgünüm, ibü bwóba sab kolae baine. Ne wirri basirr ó müót pamkolpama tibiób nóma bürrgrrütórre, i sab myamem dabyórrün koke kwarile. ");
INSERT INTO tof_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Da ene ta inzana, satania ne darrü tóba kolae samu nóma amanike pamdógab, i ene tibiób kuri bürrgrrüti. Da satanian balngomóla sab myamem koke zamngóle, da oya arünga ta sab igósidi we blakóne. ");
INSERT INTO tof_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A ka kolae samu ne Be-elzebulün arüngi nóma amandóla, da yabüka nidi atandako, i ma kolae samu noan arüngi amandako? Ini zitülkusdü i sab yabü igó zaz nirre wagó, e obaedakla e nóma bóktandakla wagó, ka kolae samu Be-elzebulün arüngi amandóla. ");
INSERT INTO tof_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","A ka kolae samu amandóla Godón Samuan arüngdügabi. Akó ini klama igó poko okaka amzazilda wagó, Godón Kingzan Balngomóla yabüka kuri tame. ");
INSERT INTO tof_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ka akó igó bóktono: darrü pam gaodó kokea arüng paman müótüdü popa bangrinüm, oya elklaza azebóm. Ngaen-gógópan wa ene arüng pam sye-i amróke, da ene kakóm oya müót igósidi amkene, oya elklaza azebóm. ");
INSERT INTO tof_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kankü koke nótóke, wa kürüka bóka bamgünda. Akó kankü pamkolpam koke nótó dakasuda, wa arngenda. ");
INSERT INTO tof_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Da we zitülkusdü, ka yabü igó byaldóla, God sab kolpamab blaman kolae tonarr norrgorre akó ne kolae poko bóktandako Godónkwata. A kolae poko nótó bóktanda Godón Samuankwata, God sab oya ene kolae tonarr kokean arrgone. ");
INSERT INTO tof_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Nadü oloma ne kolae bóktan akyanda kürü, Pamkolpamab Olom nótókla, God sab arrgone. A nadü oloma ne kolae bóktan akyanda Godón Samu, sab koke arrgone, errkya ini tüpdü akó elnga tüpdü. ");
INSERT INTO tof_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Morroal küp azebóm, marü morroal nugup warile. Marü ne kolae nugup nóma warile, marü sab alo-koke küp müline. Ma kubó nugup tóba küpdügabi omzyeto, wa ne tonarr küp waondo. ");
INSERT INTO tof_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E blaman kolae balóng gwarab kupoakla! E morroal poko ia bóktónane, zitülkus e kolaeakla! Darrü oloman taea we poko bóktanda, oya moboküpdü ne klame. ");
INSERT INTO tof_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Morroal oloma tóba morroal gyagu müótüdügabi wa morroal elklaza amarruda. Kolae oloma tóba kolae gyagu müótüdügabi wa kolae elklaza amarruda. ");
INSERT INTO tof_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ka yabü igó byaldóla, Godón Kot Ngürrdü, blaman pamkolpama sab tibiób küp-koke bóktan poko pupo wyóle Godka. ");
INSERT INTO tof_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Moba bóktandógabi God marü sab ⌊dümdüm tonarr⌋ olomóm mine, ó moba bóktandógabi God marü sab ⌊kolaean darrem⌋ mókyene.” ");
INSERT INTO tof_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Da ngibürr Mosesón gida umulbain pam akó Parrisia Yesuka we bóktónóp wagó, “Umulbain Pam, ma kibünkü darrü wirri tulmil kóbó tónggapó, da ki kubó eserre, marü arüng ia amkoman Godkagabia.” ");
INSERT INTO tof_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu ibüka bóktan we yalkomólórr wagó, “Ini lüólan pamkolpam kolaeanako akó i Godón amkoman koke angundako, zitülkus i wirri tulmilüm atodako. A ibünkü darrü wirri tulmil tónggapórrón koke yarile, wata prropet Zonakazan ne wirri tulmila tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zona aüd ngürr akó aüd irrüb wirri wapian dupidüzan ngyabenórr, da ka, Pamkolpamab Olom nótókla, ta sab aüd ngürr akó aüd irrüb inzan amono auma tüp kugupidü. ");
INSERT INTO tof_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ngaen, Zonan nóma arrkrruóp Godón bóktan amgolde, Ninebe wirri basirr pamkolpama Godka tübyalüngóp tibiób kolae tonarrdógabi. Da Godón Kot Ngürrdü, i sab igósidi Godón obzek kwata bórrónge ini lüólan pamkolpampükü, da sab ibü kolae tonarr idi pupo nirre. Tübarrkrru, Zonakagabi darrü wirri ngi pam aini asine! E Godka byalüngüm koke iadeakla Ninebe basirr pamkolpamzan? ");
INSERT INTO tof_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ngaen, Syiba kwina aibwóbdügabi katókórr king Solomonón ⌊wirri gyagüpitótók⌋ bóktan arrkrrum. Da Godón Kot Ngürrdü, ene kola sab igósidi Godón obzek kwata zamngóle ini lüólan pamkolpampükü, da sab ibü kolae tonarr wató pupainirre. Tübarrkrru, Solomonkagabi darrü wirri ngi pam aini asine! E ia kürü wirri gyagüpitótók bóktan amkoman koke iade angundakla, Syiba kwinazan Solomonón wirri gyagüpitótók bóktan amkoman yangunürr? ");
INSERT INTO tof_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kolae samua nóma burruanda pamdógab, wa agóltagóldase nae-koke bwóbdüma, ngón ngagón bwób byamkünkü. Wa darrü koke nóma asenda, ");
INSERT INTO tof_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","wa tóbaka bóktanda wagó, ‘Ka ma alkomóldóla ka ne müót amgatórró.’ Wa nóma abzilda ene müótüdü, wa popa yuógan, morroal pabzaurrün akó ngarkwatódó asenda. ");
INSERT INTO tof_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Wa tótókda, da ngibürr 7 amkoman kolaean samu we amarruda. I blamana ene müótüdü we barrbündako ola ngyabenóm. Da ene tonarrdó ene pam ugón ma tai kolaean pokodóma ngaensingülan pokodógabi. Da ene sab inzan pokoa tómbapónórre ini kolae lüólan pamkolpamdó.” ");
INSERT INTO tof_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesuzan bóktan yarilürr pamkolpamab ngorodó, da módóga oya aip akó zoretala ugón togobórr. I pulkakak bórranglórr. Ibü ubi oyaka bóktanóm yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Darrü oloma oya we izazilürr wagó, “Yazil, marü aip akó zoretal bórrangde módógako kalkuma. Ibü ubi marüka bóktanóma.” ");
INSERT INTO tof_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ene pamdó bóktan we yalkomólórr wagó, “Kürü aip ia tai nótóko? Akó kürü zoretal ia tai nidipako?” ");
INSERT INTO tof_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Da tang we idódürr tóba umulbain olmaldó, da bóktanórr wagó, “Ngakónam, ini kürü aip akó zoretalako! ");
INSERT INTO tof_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Zitülkus módóga, kürü kwitüm Aban ubi ne nótó tómbapónda, wa kürü zorete, ó wa kürü bólbóto, akó wa kürü aipo.” ");
INSERT INTO tof_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ene dadan ngürr Yesu müót amgatórr, da wa we wamórr Galili Malu kabedó. Wa we mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wa olazan yarilürr, wirri pamkolpamab ngoroa oya amarüksimarük yangónónóp. Kan babul nóma yarilürr, da wa butüdü igósidi we kasilürr, we mórran-mórran bainürr, dudu ngoroazan bórranglórr malu kabedó. ");
INSERT INTO tof_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Olgabi wa ibüka abün elklazabkwata bóktan yarilürr alap-alap. Wagó, “Darrü küp barit pama we wamórr ⌊wit⌋ küp tüpdü aman-aman aritüm apapdó. ");
INSERT INTO tof_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wazan ene küp amalórr, ngibürra kwat kabedó balóklórr. Póyaea togobórr, we ololórr. ");
INSERT INTO tof_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ngibürra wirri ingülküppükü tüpdü balóklórr. Ene pokodó kari tüp yarilürr. Ene wit guba büsai-büsai igósidi tübausürr, zitülkus ene ingülküp kwitüm tüp tumuman yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Abüsa nóma tübanikürr, oya urura ene küsil zid igósidi toklomóp, da odalan ngintinóp, zitülkus ibü simkün babul kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Akó ngibürr küpa tórezpükü sólmól pokodó balóklórr. Ene sólmóla nóma dódórr bain yarilürr, da ene wit zid ola sarrpi ninóp. ");
INSERT INTO tof_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A ngibürr küpa ma morroal tüpdü balóklórr. Ene zida küp we bapónóp, ngibürra 100, ngibürra 60, akó ngibürra 30, darrpan küpdügab. ");
INSERT INTO tof_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Güblang noane, wa ki turrkrru!” ");
INSERT INTO tof_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yesun umulbain olmala togobórr oyaka, da imtinóp wagó, “Ma ia pamkolpamdó alap-alap iade bóktandóla?” ");
INSERT INTO tof_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu bóktan we yalkomólórr wagó, “Godón Kingzan Balngomólankwata arrón elklazabóka umul yabü aliórrünako, a ibü koke. ");
INSERT INTO tof_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Zitülkus módóga, noanko, sab akó oya ene tumum ngibürr iline. Oya sab igósidi ngaru bapón-koke kwarile. A babul noanko, oya sab irrkine, oya kari-kari ne klame. ");
INSERT INTO tof_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ka alap-alap bóktandóla ibüka, zitülkus enana i azildako, i tai kokean asendako. Akó enana i arrkrrudako, i tai kokean arrkrrudako, akó bóktanan küp ta tai koke apadódako. ");
INSERT INTO tof_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Da prropet Aesaya Godón igó ne bóktan wialómórr, ibüka errkya küppükü bainda, wagó, “‘E wa sab metat arrkrru wa arrkrru kwarilo, da e ma Godón bóktanan küp tai kokean apad kwarilo. E wa sab metat azil wa azil kwarilo, da e ma tai kokean asen kwarilo. ");
INSERT INTO tof_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Zitülkus módóga, ini pamkolpamab moboküp karrkukus bairrünako; ibü güblang nabeako arrkrrum, akó tibiób ilküp kuri murrnausóp. Koke ne nóma, i ki eserre tibiób ilküpi, akó i ki barrkrrue tibiób güblange, akó i ⌊küp ki ipüdórre⌋ tibiób moboküpi, akó i ki tübyalüngórre kürüka, da ka ibü igósidi ki dólóng ninünüma!’ ");
INSERT INTO tof_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“A yabü ilküpa sab bagürwóm esele, zitülkus i asendako, akó yabü güblanga sab bagürwóm arrkrrule, zitülkus i arrkrrudako! ");
INSERT INTO tof_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Zitülkus módóga, ka yabü amkoman poko byaldóla: abün prropet akó dümdüm ngyaben pamkolpam, ngaen nidi ngyaben kwarilürr, ibü wirri ubi ta asenóm yarilürr, e errkya ne kla basendakla kürü tómbapónde, da i kokean esenóp. Akó ibü wirri ubi ta arrkrrum yarilürr, e errkya ne poko arrkrrudakla, da i kokean barrkrrurr.” ");
INSERT INTO tof_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Da e tübarrkrru, küp barit paman alap-alap bóktanan küp ia laróga. ");
INSERT INTO tof_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ene bóktan nótó arrkrruda Godón Kingzan Balngomólankwata, da bóktanan küp koke apadóda, wa igó küpa, kwat kabedó ne küpa balókórr. Kolaean oloma tótókda, ama oyakagab ene bóktan arrkyónda, oya moboküpdü artümürrün ne klame. ");
INSERT INTO tof_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ne küpa balókórr wirri ingülküppükü tüpdü, oyankü zamngólda, Godón bóktan dümdüman bagürwómpükü nótó apadóda. ");
INSERT INTO tof_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","A ene bóktana oya bübdü tai koke mórran-mórran bainda, zitülkus oya simkün babulako, da ene bóktana wirrianbóka aebókamde koke ngyabenda. Ngibürr müp tonarra nóma tótókdako oyaka ó ngibürr pamkolpama oya wirri müp alióndako, zitülkus wa Godón Bóktan amkoman angunda, wa büsai-büsai bóleanda amkoman bangun-gum. ");
INSERT INTO tof_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Akó tórezpükü sólmól pokodó ne küpa balókórr, oyankü zamngólda, Godón bóktan nótó arrkrruda. A tüpan gyakolae akó mórrelwómóm ubia Godón bóktan sarrpi aindamli. Da ene oloma küp koke igósidi bapónda. ");
INSERT INTO tof_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A morroal tüpdü ne küpa balókórr, oyankü zamngólda, nótó arrkrruda akó küp apadóda, da wa küppükü igósidia, darrüpa 100, darrüpa 60, akó darrüpa 30 darrpan küpdügab.” ");
INSERT INTO tof_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu pamkolpamdó akó darrü alap-alap bóktan adrratórr. Wagó, “Godón Kingzan Balngomól inzana. Darrü pama morroal wit küp tóba apapdó iritürr. ");
INSERT INTO tof_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Darrü irrüb, blaman pamkolpam ut nóma kwarilürr, darrü kolae pama tamórr, oya gódam-koke nótó yarilürr. Wa trrabub küp we iritürr wit apapdó, da wa we amgatórr. ");
INSERT INTO tof_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ene wit akó trrabuba darrpan pokodó we dódórr bainóp. Küpa nóma tómónóp, da we nómzyetóp. ");
INSERT INTO tof_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Apap aban zaget pama oyaka togobórr da we bóktónóp wagó, ‘Ngi pam, ia ma morroal wit küp iritürrü moba apapdó, a ene trrabuba wa nubógabi togobe?’ ");
INSERT INTO tof_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wa ibüka bóktanórr wagó, ‘Darrü kolae pama tónggapónórr ini kla, kürü gódam-koke nótóke.’ I oya we imtinóp wagó, ‘Marü ia ubia, ki ia ene trrabub aprranóm ogobo?’ ");
INSERT INTO tof_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Wa bóktan yalkomólórr wagó, ‘Ki yarilün! Zitülkus e ne trrabub nóma eprrónane, e kubó ngibürr wit zidpükü kena eprrónam. ");
INSERT INTO tof_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kya elókam, ene wit a trrabub nizana darrpan pokodó ki dódórr bainünüm kókó abül tonarr nóma semrróne. Ene ngürr ka sab abül pamkolpam nilnünümo wagó, “E trrabub ngaen-gógópan dakainamke, da kur bamelamke, sab urdü amselóm. Ene kakóm, e wit dakainamke darrpan pokodó, ama kürü gyagu müótüdü irrbünamke.” ’” ");
INSERT INTO tof_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu ibüka akó darrü alap-alap bóktan adrratórr wagó, “Godón Kingzan Balngomól inzana, wamaka ne karian küpa, darrü pama tóba apapdó ne kla idódürr akó tüpdü irtümülürr. ");
INSERT INTO tof_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ene karian küpa blaman küpdügab, a wa ma nóma dódórr bainda, wa wirrian zida blaman didiburr zidüdügab. Wa nugupüm bainda, da igósidi kwitüm póyaea tótókdako tibiób müót balmelóm oya tizdü.” ");
INSERT INTO tof_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu ibüka akó darrü alap-alap bóktan adrratórr wagó, “Godón Kingzan Balngomól inzana, wamaka istako, kola ne kla yazebe, da abün plaoapükü we alkomene. Ene ista kubó plaoa kugupidü ola zaget yarile, tai kókó blaman plaoa por baine.” ");
INSERT INTO tof_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu wata blaman ini elklaza alap-alap büdrrat yarilürr pamkolpamab ngorodó. Wa ibüka wata alap-alap bóktane bóktalórr. ");
INSERT INTO tof_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Blaman ini tórrmen tulmila igósidi tómbapónónóp Godón Wialómórrón Bóktan küppükü ainüm, wa prropetódó ne poko bóktanórr pamkolpamdó adrratóm wagó, “Ka sab ibüka alap-alap bóktane elklaza müsirrga ninünümo. Ka sab amgolo, zitüldügab anikürrün ne klamko, tüp a pülpül nóma tómtómórri.” ");
INSERT INTO tof_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu pamkolpamab ngoro nóma bimgatórr, wa we alkomólórr tóba müótüdü. Oya umulbain olmala togobórr, da oya we imtinóp wagó, “Ma kibü tüzazilnüm, trrabubpükü apapan alap-alap bóktanan küp ia laróga?” ");
INSERT INTO tof_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu bóktan yalkomólórr wagó, “Ne pama morroal küp iritürr, wa kótókla, Pamkolpamab Olom. ");
INSERT INTO tof_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Apap ne klame, wa ini tüpa. Morroal küp, ene pamkolpamako, God nibiób balngomólda Kingzan, akó trrabub ne klame, i kolaean oloman pamkolpamko. ");
INSERT INTO tof_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Trrabub ne kolae pama iritürr, wa ⌊debóla⌋. Abül ngürr, wa tüpan blakón tonarra akó abül zaget pam, i wa anerruako. ");
INSERT INTO tof_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Trrabubzan dakaindako akó darrpan pokodó urdü amseldako, tüpan blakón tonarrdó enta sab inzan pokoa tómbapóne. ");
INSERT INTO tof_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ka, Pamkolpamab Olom nótókla, sab kólba anerru zirrtapónónómo, kólba Balngomól Bwóbdügab ibü dakabainüm, pamkolpam kolae tonarr tómbapónóm nidi zirrbótakdako akó blaman, kolae elklaza nidi tómbapóndako. ");
INSERT INTO tof_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ibü sab ⌊metat bólmyan urdü⌋ amórre. I sab yón akó tibiób zirrgüp ola bótak kwarile. ");
INSERT INTO tof_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A dümdüm ngyaben pamkolpama sab abüsazan zyón bapón kwarile tibiób Aban Balngomóldó. Güblang noane, wa ki turrkrru!” ");
INSERT INTO tof_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godón Kingzan Balngomól wirri mani alópzana, tüp pokodó anikürrün. Darrü pama nóma esene, wa akó kubó ngalo-e. Bagürwómpükü we alkomóle, tóba blaman kla we sel nirre, da ene mani alóppükü tüp poko we amige. ");
INSERT INTO tof_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Godón Kingzan Balngomól akó inzana. Darrü elklaza bumióg pama kubó wame kómal pel amkünüm. ");
INSERT INTO tof_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Da kubó kómalan kla nóma esene, wa kubó alkomóle, tóba blaman kla we sel nirre, da ene pel we amige. ");
INSERT INTO tof_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Godón Kingzan Balngomól akó netzana. Pama kubó ene net maludü nóma adrrütrre, abün-abün obzek wapi bumige; ngibürr alóng wapi, ngibürr alóng-koke. ");
INSERT INTO tof_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ene neta tai nóma byamróke, da kubó nóresdó ugón amrrutrre. Pama kubó bobrrone ene wapi aleanóm. Morroal kla kubó alópdó irrbünórre, akó kolae kla kubó zomale. ");
INSERT INTO tof_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tüpan blakón tonarrdó sab inzan yarile. Anerrua sab ogobe kolae kolpam aleanóm dümdüm ngyaben kolpamdógab. ");
INSERT INTO tof_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kolae kolpam sab we amórre metat bólmyan urdü, i sab nóla yón akó zirrgüp bótak kwarile.” ");
INSERT INTO tof_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu tóba umulbain olmal we nümtinóp wagó, “E ia blamana ini alap-alap bóktanab küp kuri ipüdane?” I bóktan we yalkomólóp wagó, “Ó, ki kuri umul bairre!” ");
INSERT INTO tof_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu akó bóktan we yalkomólórr wagó, “Ini igó pokoa: darrü gida umulbain pam, Godón Kingzan Balngomólankwata ne nótó kuri umul baine akó ipüde, wa müót abzana, küsil akó ngaep elklaza nótó ausda tóba gyagu müótüdügabi.” ");
INSERT INTO tof_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesun ene alap-alap bóktan büdrrata nóma blakónórr, wa ene poko we amgatórr. ");
INSERT INTO tof_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Da wa we wamórr tóbanan wirri basirrdü Nazarret. Wa pamkolpam ibü kwóbbazen müótüdü we umul bain yarilürr, da i gübarirr aengóp. I tibiób bóka bütünóp wagó, “Ini wa ene ⌊wirri gyagüpitótók⌋ nubó yazebe? Wa akó ene wirri arüng elklaza tómbapón nubó umul baine? ");
INSERT INTO tof_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A wa go ene müót balmel paman olome, Zosepón. Akó oya aip go Merrio. Akó Zeims a Zosep a Saemon akó Zudas enta oya zoretalko. ");
INSERT INTO tof_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Akó oya bólbótala ta ae ngyabendako. A wa wa ini arüng nubógabi ipüde?” ");
INSERT INTO tof_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Da i oya we alzizi amanikóp. Yesu ibüka bóktanórr wagó, “Prropet wirri ngi atendako ngibürr bwóbdü, a tóbanan basirrdü ó müót pama ama inzan koke.” ");
INSERT INTO tof_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I oyazan amkoman koke yangunónóp, wa ola abün ⌊arüng tonarr⌋ koke igósidi tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ene tonarr, Errod Galili prrobins alngomól wirri pam nóma yarilürr, wa Yesunkwata bóktan arrkrrurr. ");
INSERT INTO tof_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tóba zaget pambóka wagó, “Ene wa amkoman Zon Baptaes Bain Pama, oya büdüldügab kuri irsümürre! Da ene arünga oyaka ene zitülkusdü zagetóda wirri ⌊arüng tonarr⌋ tólbaelóm.” ");
INSERT INTO tof_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Zon büdül küsil nóma yarilürr, Errod tóba gazirr pam zirrnapónóp Zonón amiógüm, sye-i amelóm, tümün müótüdü zirrapónóm. Wa ini poko tóba kol Errodiasónbókamde tónggapónórr. Errodias ngaen-gógópan oya naret Pilipün kol warilürr. Errod oya wató urrkyónürr, da kolóm we wyónürr. ");
INSERT INTO tof_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Errod Zonón tümün müótüdü zirrapónórr, zitülkus Zon oya bobarr igó ayal yarilürr wagó, “Ini gyabia, Errodiasón amiógüm moba kolóm!” ");
INSERT INTO tof_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","We zitülkusdü, Errodón ubi oya ugón amkalóm yarilürr büdülümpükü. Da wa Zu pamkolpamab gum yarilürr, zitülkus pamkolpamab ⌊wirri gyagüpitótók⌋ wata igó yarilürr, “Zon wa prropeta.” ");
INSERT INTO tof_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Errodón amtómól ngürran tóre nóma yarilürr, Errodiasón ngul oloma zil emkalólórr wirri ngi kolpamab obzek kwata, ola nidi kwarilürr. Wa Errodón morroal barnginwóman ngitanórr, ");
INSERT INTO tof_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","da Errod oya ⌊arüng alkamül-koke bóktan⌋ we wyalórr wagó, “Ma kürüka ne klamóm tóbato-o, ka wata marü kubó mókyeno!” ");
INSERT INTO tof_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tóba aipan bóktandógabi, ngul oloma Errodón we yatorr wagó, “Ma kürü kókya aini alongalo klamdó, Zon Baptaes Bain Pam, oya singül!” ");
INSERT INTO tof_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King Errod kari gyaur koke yarilürr, wa ene bóktan nóma arrkrrurr. Da módóga, wa tóba darrü gazirr pam we arüng bóktan ekyanórr Errodiasón ubi tónggapónóm, zitülkus wa oya arüng alkamül-koke bóktan uliónürr wirri ngi kolpamab obzek kwata, tóre bwóbdü nidi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Da ene gazirr pama Zonón singül we itülürr tümün müótüdü. ");
INSERT INTO tof_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ene singül alongalo klamdó we sidódürr, da ene ngul olom okyanórr, ama akó nótó idódürr tóba aipdü. ");
INSERT INTO tof_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Zonón umulbain olmala togobórr, oya büb we idüdóp gapók alüngüm. Ene kakóm, Yesun azazilüm we ogobórr. ");
INSERT INTO tof_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu Zonón büdülbóka nóma arrkrrurr, da butüdü kasilürr, da ene poko we amgatórr kolpam-koke bwóbdü tótókóm tebe-tebe. Pamkolpam ngoroa nóma barrkrrurr, i tibiób wirri basirr we zumgatlórr, da dorro kwata, wapórane, oyaka we zutalórr. ");
INSERT INTO tof_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu butüdügabi dorro nóma kasilürr, wa wirri pamkolpamab ngoro nósenóp, da wa kari gyaur koke yarilürr ibüka. Da azid nidi kwarilürr, wa ibü dólóng nyónónóp. ");
INSERT INTO tof_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Abüs simaman nóma yarilürr, umulbain olmala oyaka togobórr, da i oyaka bóktónóp wagó, “Abüsa mórrandase. Ini kolpam-koke bwóba. Da ma ini pamkolpamab ngoro ugó zirrnapónónóm minggüpanan basirrdü, tibióbkü alo kla bumiógüm.” ");
INSERT INTO tof_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","A Yesu ibü nilóp wagó, “I koke ogobe! E yaib ibü ngibürr alo kla nülinam!” ");
INSERT INTO tof_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","I bóktan we yalkomólóp wagó, “Kibüka aini wata 5 brredako akó nis wapiamli.” ");
INSERT INTO tof_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Da Yesu ibüka we bóktanórr wagó, “Da ala simarruam kürüka!” ");
INSERT INTO tof_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wa pamkolpam opopordó mórranóm nilóp. Da ene brred yazebórr akó wapi nis, kwit yazilürr, da Godón eso ekyanórr. Wa ene brred syórr nangónóp, tóba umulbain olmal nülinóp, akó umulbain olmala pamkolpam nülinóp. ");
INSERT INTO tof_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","I blamana nóma elop, ibü bikóma nólóngóp. Umulbain olmala bamirrün alo poko dakainóp akó 12 alóp murrnausóp. ");
INSERT INTO tof_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ne pama elop, ibü ngarkwat kókó 5,000 yarilürr, kol a karipókal, ibü koke etóngóp pamdógabi. ");
INSERT INTO tof_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Dümdüman ene kakóm, Yesu tóba umulbain olmal we nilóp butüdü bamselóm ó singül kwata baurrüm malu dakla dorrodó. I nóma ogoblórr, wa ene pamkolpam we zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ene kakóm, wa tebe podo kwitüdü we angürürr, tóre akom. Abüsazan mórralórr, Yesu ola ugón wata tebe püóran yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ugón but ta alam kan koke yarilürr maludü. Goblola but wirribóka angap kwarilürr, zitülkus wóra singül kwatagabi tubsolürr. ");
INSERT INTO tof_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sis minggüpanan nóma yarilürr, Yesu tóba umulbain olmaldó we wamórr, nae kwitana tótókde. ");
INSERT INTO tof_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I oya nae kwitana tótókde nóma esenóp, kari gum ta koke kwarilürr. Wagó, “Ini wa mórrkea!” Da gum taegwarr we apónóp. ");
INSERT INTO tof_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Dümdüman Yesu ibüka bóktanórr wagó, “Moboküp karrkukus ninam! Ini kótókla. E gumgu!” ");
INSERT INTO tof_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita oyaka bóktan we yalkomólórr wagó, “Lode, mató ne nómadóla, da kürü kóbó kyal mobaka tótókóm nae kwitana!” ");
INSERT INTO tof_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu oyaka bóktanórr wagó, “Da yao!” Pita we banikürr butüdügabi, da wa nae kwitana Yesuka we wamlórr. ");
INSERT INTO tof_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pita wirri wór nóma esenórr, wa gumüm we bainürr. Naedó we mórranórrma, da wirribóka taegwarr apónórr wagó, “Lod, ma kürü ugó zid kyó!” ");
INSERT INTO tof_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Dümdüman Yesu tang adrratórr, Pitan we emoanórr. Oyabóka wagó, “Marü amkoman bangun wata karia! Ma gyagüp-gyagüp iadela?” ");
INSERT INTO tof_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","I nizana butüdü we kasilürri. Wórapükü ta we batülürr. ");
INSERT INTO tof_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Butüdü ne umulbain olmal koralórr, Yesun we yagürnóp. I we bóktónóp wagó, “Ma amkoman Godón Olomla!” ");
INSERT INTO tof_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","I malu dakla kabedó nóma baurrürr, i we babzilürr Genesarret bwóbdü. ");
INSERT INTO tof_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Pamkolpama Yesun nóma emzyetóp, da i bóktan we zirrnapónóp ibüka minggüpanan ne wirri basirr koralórr, azid kolpam Yesuka amarrum. Da i we barrmülürr. ");
INSERT INTO tof_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Da i oya we yatop, azid kolpama wata oya mórrkenyórr zarran amurrum. Nidi yamurrnóp, i blamana dólóng we bainónóp. ");
INSERT INTO tof_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Da ngibürr Parrisi akó Mosesón gida umulbain pama Zerrusalem wirri basirrdügabi togobórr Yesuka. Oya imtinóp ");
INSERT INTO tof_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","wagó, “Marü umulbain olmala ia mibü abalbobatalab gida iade amgündako? I alom nóma kaindako, i tibiób tang inzan koke baguldako mibü gidazan bóktanda!” ");
INSERT INTO tof_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu ibüka bóktan we yalkomólórr wagó, “E wa Godón gida bóktan poko iade amgündakla, ama yabiób abalbobatalab gida mamoandakla? ");
INSERT INTO tof_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God igó yarilürr wagó, ‘Ma moba aipab nis morroal angón namülün.’ Akó, ‘Nadü oloma tóba aipab nis nótó nómórre, büdüldü ki ingrinam.’ ");
INSERT INTO tof_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","A e ma kolpam igó umul baindakla wagó, paman ne darrü kla asi nóma yarile tóba ab a aip nis tangamtinüm, a ma kubó igó bóktóne wagó, ‘Ini Godón akyarrón klame, oya ngi klame,’ ");
INSERT INTO tof_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","da ene oloma tóba aipab nis koke tangnamtine ene klame. Inzan morroal kokea; yabiób gida inzan karrkukus amoande, e Godón gida bóktan poko kuri alkamülane. ");
INSERT INTO tof_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E taepurrane bóktan pamakla! Prropet Aesaya wata amkoman yarilürr, yabükwata igó ne poko bóktanórr Godón ngidü wagó, ");
INSERT INTO tof_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘God igó bóktanda wagó, “Ini pamkolpama kürü taeane ⌊ótókdako⌋, a ibü moboküp ma alam kokeasko kürükagabi. ");
INSERT INTO tof_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I kürü enan küp-koke ótókdako, zitülkus i pamab bókam bagósórrón gida umul baindako, wamaka kürü gidako!” ’” ");
INSERT INTO tof_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu pamkolpamab ngoro ngibaunürr tóbaka tótókóm. Wagó, “Tübarrkrru akó bóktanan ⌊küp ipüdam⌋! ");
INSERT INTO tof_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Paman taedó ne klama tótókda, oya we klama koke ⌊tómanan⌋ ngitanda Godón ilküpdü. A taedógabi ne klama burruanda, wató tómanan ngitanda.” ");
INSERT INTO tof_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Umulbain olmala oyaka togobórr, we bóktónóp wagó, “Ma ia umulóla, Parrisia ngürsilüm kuri bairre, i ene bóktan nóma barrkrrue?” ");
INSERT INTO tof_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu ibüka bóktan we yalkomólórr wagó, “Blaman zid, kürü kwitüm Aba koke ne kla iritürr, wa sab blaman azibe. ");
INSERT INTO tof_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Da e ibü elókam! I ilküküp murrbausürrün pamako, ilküküp murrbausürrün pam nidi balngomóldako. Darrü ilküküp murrbausürrün pama kamad nóma elngomóle, nizana sab aupi kugupidü.” ");
INSERT INTO tof_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita oyaka we bóktanórr wagó, “Ma kibüka ngaen-gógópan ene alap-alap bóktanan küp kóbó okaka simzazil!” ");
INSERT INTO tof_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu ibübóka wagó, “E ia wata umul-kókanakla ini ngibürr popa pamkolpamzan? ");
INSERT INTO tof_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","E ia kokean apadódakla? Pama ne kla aloda, bikómdü tótókda. Olgabi ama akó pulkakak we alkomólda, lae müótüdü. ");
INSERT INTO tof_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","A paman taedógabi ne klama burruanda, moboküpdügabi tótókda. Ini nadü elklazako, pam we klama tómanpükü ainda Godón ilküpdü. ");
INSERT INTO tof_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Oya moboküpdügabi ini kolaean elklaza bausdako: kolae gyagüpitótók, pam amkal, kol a pam gómól, kolae sarrgiwóm tonarr, gómól, obae tiz, akó obae bóktan alión ngibürrabkwata panzedó. ");
INSERT INTO tof_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Da ene elklaza módógako, pam idi tómanan ngitandako Godón ilküpdü. Pama go popa tómanpükü tange ta nóma elo-e, oya we klama koke tómanpükü ine Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu olgabi we bupadórr, ama Taerr akó Saedon, wirri basirr nis minggüpanan, we mogob pamkolpamab bwób órdóbóna wamlórr. ");
INSERT INTO tof_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Da módóga, darrpan Keinün kol, ola nótó ngyaben warilürr, Yesuka we katókórr. Wa inzan taegwarrkü katóklórr wagó, “Lod! ⌊Deibidün⌋ Olom, gyaurka, ma kürü gyaur kóse! Kürü óp oloman bübdü kolae samu yarilürr, da wa amkoman kolaean pokodómato!” ");
INSERT INTO tof_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Da Yesu darrü poko oyaka koke bóktanórr. Umulbain olmala oyaka we togobórr, da oya arüngi ilóp wagó, “Ini kol ugó zirrzwapó! Wa mibü solodó metat taegwarrkü akyando!” ");
INSERT INTO tof_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yesu koldó bóktanórr wagó, “Kürü God wató zirrkapónórr Isrrael bamrükürrün ne ⌊sipko⌋, ibüka, a ka mogob pamkolpamabkü koke tamórró.” ");
INSERT INTO tof_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yesu wa go ene poko enan bóktanórr, da ene kola ma Yesuka natókórr, oya minggüpanan wakósingül we nülkamülürr oya atom tóba tangamtinüm. Oyabóka wagó, “Lod, ma kürü tangkamti!” ");
INSERT INTO tof_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu oya bóktan we yalkomólórr alap-alap wagó, “Dümdüm kokea, olmalab alo azeb, ama akó umedó aman.” ");
INSERT INTO tof_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ene kola wagó, “Ene amkoman pokoa, Wirri Pam. A umea ta tibiób abalab tógal lorodó alodako, tógal kwitüdügab ne burrula balókdako.” ");
INSERT INTO tof_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Da Yesu oya bóktan we yalkomólórr wagó, “Kol, marü amkoman bangun kari ta kokea! Marü ubi ne klamóma, kubó tómbapóne!” Da dümdüman oya ngul oloma we dólóng bainürr. ");
INSERT INTO tof_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu ene bwób amgatórr, da Galili Malu kabe we mamoalórr. Da podo kasilürr, ola mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wirri kolpam ngoroa ugón togobórr oyaka. I abün azid kolpam tübarrmünürr oyaka: wapór bidal kolpam, ilküküp murrbausürrün kolpam, kolae wapór kolpam, bóktan-koke kolpam, akó ngibürr azidpükü nidi kwarilürr. Barrmülürr, kókó Yesun wapór minggüpanan we sirrbünóp. Ibü blaman we dólóng ninóp. ");
INSERT INTO tof_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pamkolpama gübarirr aengóp ibü nóma nósenóp: bóktan-koke kolpam bóktande, kolae wapór kolpam dólóng baindi, wapór bidal kolpam agólde, akó ilküküp murrbausürrün kolpam morroal basende. Da i Isrrael pamkolpamab God we yagürnóp. ");
INSERT INTO tof_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu tóba umulbain olmal tóbaka ngibaunürr. Ibübóka wagó, “Ka kari gyaur kokela ini pamkolpamdó, zitülkus i kankü aüd ngürr kuri amórre, da ibü darrü alo kla myamem babula. Kürü ubi babula ibü alo ngabyón-koke zirrbapónóm tibiób basirrdü. Kwat-kwat tótókde, ibü iltümüna kena tübyóng.” ");
INSERT INTO tof_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Da umulbain olmala oya we imtinóp wagó, “Ki kubó abün alo ne nóserre ini kolpam-koke bwóbdü, inzan pamkolpamab ngoro ngabyónüm?” ");
INSERT INTO tof_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu ibü nümtinóp wagó, “Yabü ia nigó brredako?” I bóktan yalkomólóp wagó, “7 Brredako akó aüdan kari wapi.” ");
INSERT INTO tof_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Da Yesu pamkolpam tüpdü mórranóm we nilóp. ");
INSERT INTO tof_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Da ene 7 brred akó aüd wapi yazebórr, Godón eso ekyanórr, syórr nangónóp, da tóba umulbain olmal nülinóp. Umulbain olmala ama akó pamkolpam we nülinóp. ");
INSERT INTO tof_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I nóma elop, ibü blaman bikóma nólóngóp. Da umulbain olmala 7 alóp murrnausóp, ne alo pokoa baminürr. ");
INSERT INTO tof_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ne kolpama elop, pam blaman kóta 4,000 kwarilürr, kol a karipókal koke etóngóp. ");
INSERT INTO tof_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu pamkolpamab ngoro tibiób basirrdü we zirrnapónóp, solkwat tüób butüdü we kasilürr, ama Magadan bwób órdóbóna we wamórr. ");
INSERT INTO tof_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ngibürr Parrisi akó ⌊Sadusi pama⌋ Yesuka togobórr oya apókóm, da i oya we yatop darrü kwitümgab wirri tulmil tónggapónóm, ibü igó poko amtyanóm wagó, oya arüng amkoman Godkagabia. ");
INSERT INTO tof_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu ibüka bóktan we yalkomólórr wagó, “Abüsa nóma botoe, e igó bóktónane wa, ‘Sab morroal ngürrase, zitülkus pülpül óe-óea.’ ");
INSERT INTO tof_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Akó irrbianande e igó bóktónane wagó, ‘Errkya ngup ngürra, zitülkus pülpül óe-óea akó tümün-tümüna.’ E umulakla bwób tonarr apónóm, a e ma gaodó koke iadeakla Godón tulmil bómzyatóm, errkya ne tonarra tómbapóndako? ");
INSERT INTO tof_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ini lüólan pamkolpam kolaeanako akó i Godón amkoman koke angundako, zitülkus i kürü wirri tulmilüm atodako. A ibünkü darrü wirri tulmil koke tónggapórrón yarile, wata prropet Zonakazan ne wirri tulmila tómbapónórr.” Yesu ibü we nümgütóp, da we wamórr. ");
INSERT INTO tof_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Da umulbain olmala ta malu dakla dorro we baurrürr, Yesu ne yarilürr. Ibü bamrükürr brred amarrum inkü. ");
INSERT INTO tof_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu ibüka we bóktanórr wagó, “E ta mamka! E umul-umul kwarilün Parrisi akó Sadusi pam, ibü istabkwata.” ");
INSERT INTO tof_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","I tibiób we ikik koralórr wagó, “Wa igósidi bóktanda, zitülkus mi brred koke tübarrmüna.” ");
INSERT INTO tof_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu umul bainürr i ne poko bóktan kwarilürr, da ibü nümtinóp wagó, “E iade ikikdakla yabióbka wa, ‘Mibü brred myamem babula.’? ");
INSERT INTO tof_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","E ia ⌊küp apad⌋ küsilanakla? Yabü ia koke ngambangólda, ka ne 5 brred syórr nangónarre 5,000 pam ngabyónüm? E ene bamirrün alo pokodógab ia nigó alóp murrnausnarre? ");
INSERT INTO tof_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Akó ene 7 brrede, ka akó 4,000 pam ngabyórró. Yabü ia koke ngambangólda, e akó olgabi nigó alóp murrnausnarre, ne pokoa baminürr? ");
INSERT INTO tof_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","E wa küp tai koke iade apadódakla, ka yabüka brredankwata koke bóktan namüla? Yabiób tai ngabkónamke Parrisi akó Sadusi pam, ibü istdügab!” ");
INSERT INTO tof_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Da ene pokodó umulbain olmala küp we esenóp, wa ibüka igó poko koke bóktan yarilürr tibiób morroal ngabkanóm brredan istdügab, a wa Parrisi akó Sadusi pam, ibü kle-kle umulbainankwata bóktan yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu wamórr we bwóbdü, Sesarria Pilipi wirri basirr nege. Wa tóba umulbain olmal nümtinóp wagó, “Pamkolpama ia bóktandako, ka nótókla, Pamkolpamab Olom?” ");
INSERT INTO tof_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I oyabóka wagó, “Ngibürr pamkolpama igó bóktandako wagó, ma Zonla, ⌊Baptaes Bain⌋ Pam. Ngibürra ma igó bóktandako wagó, ma prropet Ilaezala, ngibürra wagó, ma prropet Zerremaeala, akó ngibürra go wagó, ma darrü prropetla, ngaen nótó tamórr.” ");
INSERT INTO tof_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wa ibü nümtinóp wagó, “A yadi, e wa ia gyagüpi tótókdakla kürükwata, ka nótókla?” ");
INSERT INTO tof_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saemon Pita bóktan yalkomólórr wagó, “Ma ene ⌊Kerrisola⌋, arról Godón olom.” ");
INSERT INTO tof_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu oyaka bóktan we yalkomólórr wagó, “Marüka barnginwóm ki yarilün, Saemon Pita, Zonón olom! Ini amkoman bóktana popa pamdógab koke tame. A marüka ini bóktan kürü Aba okaka simzazile, kwitüm nótókase! ");
INSERT INTO tof_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","“Akó ka marü igó ayaldóla, ma Pitala. Ini wirri ingülküp kwitüm, ka sab kólba sos we elo. Büdülan arünga sab kürü sos kokean ⌊ut-ut ine⌋. ");
INSERT INTO tof_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka sab marü balngomól arüng mókyeno pamkolpam ok bainüm ia Godón Kingzan Balngomóldó barrbünüm, ta ia koke. Ma ini tüpdü pamkolpam ne kla tómbapón-gum nólenónómo, ka ta kwitüm kuri nólenónóma, akó ma tüpdü pamkolpam ne kla ok ninünümo, ka ta kwitüm ok kuri ninünüma.” ");
INSERT INTO tof_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu tóba umulbain olmal arüng bóktan we nókyenóp wagó, “Darrü pam azazilgu igó, ka ene Kerriso módógla.” ");
INSERT INTO tof_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ene ngürrdügabi, Yesu tóba umulbain olmaldó tóba panzedó we pupo bainürr wagó, “Ka sab Zerrusalem wirri basirrdü wamo abün-abün azid aengóm ⌊balngomól byarrmarr pamdógabi⌋, wirri prristdügabi, akó Mosesón gida umulbain pamdógabi. Sab kürü büdülümpükü kómkólórre a aüd ngim ngürrdü, God kürü sab kürsümüle arróldó.” ");
INSERT INTO tof_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita oya tebe-tebe pokodó idódürr, da wa oya agórr wagó, “God gyaur ki yarilün marüka! Inzan klama sab kokean ki tómbapó marüka!” ");
INSERT INTO tof_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu tübyalüngürr, da Pitaka bóktanórr wagó, “Yaya kürükagab, satani, ma kakota alkomól! Ma kürü kwat murrausüm kaindóla. Zitülkus módóga, ma Godón elklaza koke gyagüpi amandóla, a marü gyagüpitótók tüpan elklazadóma.” ");
INSERT INTO tof_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu tóba umulbain olmaldó bóktanórr wagó, “Nadü oloman ubi yarile kürüka solkwat akyanóm, wa tóbabóka imrüke. Wa tóba krros bügasile azid aengóm kazan, ó kürüka solkwat tókyale. ");
INSERT INTO tof_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Zitülkus módóga, nadü olom ubi yarile tóba tüpan arról zid ainüm, wa sab tóba ⌊ngarkwat-koke arról⌋ imrüke. A nadü oloma sab tóba tüpan arról imrüke kürübókamde, wa sab tóba ngarkwat-koke arról esene. ");
INSERT INTO tof_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ia laró morroala, darrü pama ini tüpan elklaza blaman azebóm, a tóbanan ngarkwat-koke arról ma ki imrüke? Ia darrü kla asine, wa tóba ngarkwat-koke arról sab ia salkomóle? Babula! ");
INSERT INTO tof_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Ka, Pamkolpamab Olom nótókla, tótók kari pokola kólba Aban ⌊wirri kómal zyónpükü⌋ akó kólba anerrupükü. Ka sab darrem nüliónünümo darrpan-darrpan pam tibiób tórrmen ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ka yabü amkoman poko byaldóla: e ngibürr aini nidipakla bórrangórrón, sab koke nurrbarino kókó ka, Pamkolpamab Olom nótókla, nóma tamo, kólba king ngi baterrón, pamkolpam balngomólóm.” ");
INSERT INTO tof_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","6 Ngürr kakóm, Yesu ibü yazebórr, Pita, Zeims, akó Zon, Zeimsün zoret. Wa ibü tibióban imarrurr wirri pododó. ");
INSERT INTO tof_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ibü obzek kwata oya büba darrü tonarr bainürr. Oya obzeka abüszan zyón bapón yarilürr, akó oya mórrkenyórrapükü ta gabülplie ongang bapón kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Da módóga, Moses akó Ilaeza ibüka okaka tübyórri, Yesukü ikikdi. ");
INSERT INTO tof_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita Yesuka bóktanórr wagó, “Lod, mi morroal ainizanakla! Marü ubi ne nóma yarile, ka kubó aüd twal müót balmelo, darrü marünkü, darrü Mosesónkü, darrü Ilaezankü.” ");
INSERT INTO tof_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita enezan bóktan yarilürr, da módóga, zyónan pülpül pokoa we tamórr ibü sisingül. Akó bóktan bómgóla we sidórükürr pülpül pokodógab wagó, “Ini kürü kólbanan Olome. Kürü ⌊moboküpdü ubi⌋ oyakama. Ka kari bagürwóm kokela oyaka. Oya bóktan amkoman ipadólamke!” ");
INSERT INTO tof_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ene aüd umulbain olmala ene bóktan nóma barrkrrurr, i kari gum ta koke koralórr. I balókórr, obzek tüpdü. ");
INSERT INTO tof_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yesu ibüka we tamórr da ibü namurróp. Ibübóka wagó, “Ugó bazeb! Gumgu!” ");
INSERT INTO tof_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","I ngabkanóm ilküp nóma kwit bainóp, i ngibürr pam koke nósenóp, wata Yesun tóbanan esenóp. ");
INSERT INTO tof_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","I pododógabizan tübabilürr, Yesu ibü arüng bóktan nókyenóp wagó, “Darrü olom azazilgu, e ne kla esenane, ngarkwat kókó God kürü, Pamkolpamab Olom nótókla, sab büdüldügab nóma kürsümüle.” ");
INSERT INTO tof_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Da umulbain olmala oya we imtinóp wagó, “Mosesón gida umulbain pama iade bóktandako wagó, Ilaeza sab ngaen-gógópan wató tame akó ⌊Kerriso⌋ ama solodó tame?” ");
INSERT INTO tof_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu ibüka bóktan yalkomólórr wagó, “Ilaeza wa tótókda, ugósüm blaman elklaza tibiób gaodó akonóm. ");
INSERT INTO tof_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","A ka yabü igó byaldóla, Ilaeza wa kuri tamórr, da pamkolpama oya koke emzyetóp akó i tibiób ubidügab kolae tómbapónónóp oyaka. Ka, Pamkolpamab Olom nótókla, ta sab dadan ngarkwatódó azid aengo ibü tulmildügab.” ");
INSERT INTO tof_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ene pokodó, Yesun umulbain olmala küp we esenóp wagó, Yesu ibüka Zon ⌊Baptaes Bain⌋ Pam, oyakwata bóktanda. ");
INSERT INTO tof_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu tóba aüd umulbain olmalpükü nóma alkomólórr pamkolpamab ngorodó, darrü pama Yesuka tamórr, wakósingül nülkamülürr oya obzek kwata. ");
INSERT INTO tof_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Oyabóka wagó, “Wirri Pam, gyaurka, ma kürü olom gyaur ese! Wa kari azid kokea. Ene azida oya nóma amiógda, oya tüpdü singalkalda akó ola pepes apón yarile. Abün münüm wa urdü ó naedó aupda. ");
INSERT INTO tof_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ka go marü umulbain olmaldó idüda, a ibü gaodó koke yaril oya dólóng ainüm.” ");
INSERT INTO tof_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu blamandó bóktan yalkomólórr wagó, “E amkoman bangun-koke akó kolae tonarr lüól pamkolpamakla! Ka ia yenkü nadüzan ngarkwat ngyabelo? Kürüka kari müp kokea metat yenkü ngyabenóm yabü amkoman bangun kokede. Ala sidüdam ene olommokur kürüka!” ");
INSERT INTO tof_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu ene kolae samu agórr ene olommokur amgatóm, da wa ene olommokurdügabi tubrranórr. Wata ugósan ene olommokura dólóng bainürr. ");
INSERT INTO tof_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Da umulbain olmala Yesuka we togobórr tebe-tebe pokodó, oya amtinüm. Wagó, “Ia ki gaodó koke iade korala kolae samu amaiküm?” ");
INSERT INTO tof_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu ibüka bóktan we yalkomólórr wagó, “Zitülkus módóga, yabü ne amkoman bangune gaodó kokea! Zitülkus módóga, ka yabü amkoman poko byaldóla: yabü amkoman bangun ne inzan kari nóma warile, wamaka karian küpa, da e ini podo kuri ilane wagó, ‘Algabi ugó bupa, ama aum wam!’ Da igósidi kuri wame! Blaman Godón ubi ngarkwatódó elklaza sab igósidi yabüka popadan kwarile tómbapónóm!” ");
INSERT INTO tof_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Umulbain olmala darrpan pokodó nóma kwób bazenórr Galilim, Yesu ibübóka wagó, “Darrüpa sab kürü, Pamkolpamab Olom nótókla, pamkolpamab tangdó küngrine. ");
INSERT INTO tof_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","I sab kürü büdülümpükü kómkórre, da aüd ngim ngürrdü, God sab kürü ugón kürsümüle arróldó.” Ini bóktan arrkrrudi, oya umulbain olmal kari gyaur ta koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu tóba umulbain olmalpükü Kaperrna-um wirri basirrdü nóma tamórr, Godón Gyabi Müótan taks mani dakabain pama Pitaka togobórr. Oya imtinóp wagó, “Yabü umulbain pama Godón Gyabi Müótan taks mani ia arrbünda?” ");
INSERT INTO tof_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita ibübóka wagó, “Ó, wa ta arrbünda!” Pita Yesun müótüdü nóma bangrinürr, ngaen-gógópan Yesu wató bóktanórr wagó, “Saemon, marü gyagüpitótók iada? Ini tüpan kinga taks mani ia nibióbkagab azebdako? Ia tibiób bwób pamkolpamdógab, ta ia mogob pamkolpamdógab?” ");
INSERT INTO tof_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita bóktan oyaka we yalkomólórr wagó, “Taks mani mogob pamkolpamdógabi azebdako.” Yesu bóktan inzan yalkomólórr wagó, “Da taia, oya küp igósa, bwób pama tib koke urrbule. ");
INSERT INTO tof_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","A mi ini pamkolpam ngürsilan koke ngintirre. Ma maludü ugó wam, arreag amaik. Da ma ngaen-gógópan ne wapi amurruto, oya taedó ma kubó mani küp eseno. Ipadke da taks mani dakabain pamdó idódke. Kubó gaodó yarile mibü nizanabkü Godón Gyabi Müót taks mani akyanóm.” ");
INSERT INTO tof_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ene dadan tonarr ngarkwat, Yesun umulbain olmala oyaka togobórr, da oya imtinóp wagó, “Godón Kingzan Balngomóldó amkoman wirrian ia nótóke?” ");
INSERT INTO tof_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yesu kari olom tóbaka ngyaunürr, oya zamngól-zamngólan we yónürr tibiób aodó. ");
INSERT INTO tof_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Wa bóktanórr wagó, “Ka yabü amkoman poko byaldóla: e Godón Kingzan Balngomóldó koke barrbuno, ngarkwat kókó e yabiób kolae tonarrdógabi tübyalüngane akó kari olmalpókalzan bainane. ");
INSERT INTO tof_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Da ene inzanase, nadü oloma tóba ngi tüp alkomólda, ini kari olomzan, wa wirrian pama Godón Kingzan Balngomóldó. ");
INSERT INTO tof_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inzan kari olom morroal tonarre nótó nóma apadóda kürü ngidü, enta igósa, wa kürü morroal tonarre apadóda. ");
INSERT INTO tof_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Inzan wa kolae yarile darrü pamankü igó, pamkolpama wirri kugupi bapórrón ingülküp ki amrókrre oya gepkodó, ama ki amanikórre kukurru maludü. A oyaka sab ne klama tómbapóne, wa popa olom, kürü amkoman nótó angunda, kolae tonarr tónggapónóm nóma elngomóle, ene wa kari kolae ta koke yarile. ");
INSERT INTO tof_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Godón ngürsila sab tame ini tüpan pamkolpamdó, kolae tonarr tómbapónóm nidi balngomóldako. Blaman tonarr inzan tulmila tómbapóndako, a Godón ngürsila sab tame ene olomdó, ini kolaea noakama tótókda! ");
INSERT INTO tof_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Marü tang a wapór ibükagab darrüpa ne kolae tónggapónóm nóma müdüde, da itül a ugó amaik mobakagab. Ma darrpan tangpükü ó darrpan wapórpükü ⌊ngarkwat-koke arróldó⌋ nóma bangrino, ene ma tai kolae kokea. A marü nis tang nispükü ó nis wapór nispükü ⌊metat bólmyan urdü⌋ nóma mumanikórre, ene amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Akó marü darrü ilküpa ne kolae tonarr tónggapónóm nóma müdüde, da irrua a ugó amaik mobakagab. Ma darrpan ilküppükü ngarkwat-koke arróldó nóma bangrino, ene ma tai kolae kokea. A marü nis ilküp nispükü metat bólmyan urdü nóma mumanikórre, amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tai ngakónam, inzan popa olom alzizi amaikgum. Ka yabü igó byaldóla, ibü tangbamtin anerru kürü kwitüm Aban obzek kwata metat asisko. ");
INSERT INTO tof_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“E ia gyagüpi tótókdakla, darrü paman ne 100 sip nóma korale, darrüpa nóma busue? Wa kubó ia laró tónggapóne? Wa kubó ene 99 podo kabedó ola bimgüte, da tüób kubó ene bamrükürrün kla amkünüm wame. ");
INSERT INTO tof_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ka yabü amkoman poko byaldóla: wa ne ene darrpan nóma esene, wa kari bagürwóm ta koke yarile oyaka, da koke ne 99 sipa bamrükóp, ibüka ama inzan bagürwóm koke yarile. ");
INSERT INTO tof_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ene dadan ngarkwatódó, mibü kwitüm Aban ubi babula, popa oloma bamrüke. ");
INSERT INTO tof_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Marü Lodón amkoman angun zonareta ne kolae tonarr nóma tónggapóne marüka, da oyaka wamke, da yalke wa ne kolae tónggapóne. Pamkolpama koke umul bairre, wata e yabian amaniki ene bóktan. Marü bóktan ne nóma arrkrrue, ma moba ene zonaret kuri salkomóla. ");
INSERT INTO tof_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ene oloma ne marü bóktan koke nóma arrkrrue, da kubó darrpan ó nis pampükü wamke oyaka, Mosesón gida ngarkwatódó. Ene igósüm, ‘nis ó aüd kolpama wata sab bóktórre wagó, i darrü kolae tonarr esenóp. Da nis ó aüd kolpama inzan nóma bóktórre, ene kolae tonarra amkoman tómbapónórr.’ ");
INSERT INTO tof_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wa ne ibü bóktan koke nóma arrkrrue, da blaman kla ma sosdó pupo ninünüma. Dómdóm, wa ne sosan bóktan koke nóma arrkrrue, da oya popa elkomólamke Godónbóka umul-kók pamzan akó ⌊taks mani dakabain pamzan⌋. ");
INSERT INTO tof_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“We ngarkwatódó, ka yabü amkoman poko byaldóla: e ini tüpdü pamkolpam ne kla tómbapón-gum nólenane, ka ta kwitüm kuri nólenónóma, akó e tüpdü pamkolpam ne kla ok ninane, ka ta kwitüm kuri ok ninünüma. ");
INSERT INTO tof_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ini amkoman pokoa! Ka yabü akó ngibürr bóktan byaldóla. Nis pam nisa yabükagab ini tüpdü ne darrpan gyagüpitótók akó darrpan moboküpi nóma namüli darrpan klamóm tóre akom, kürü kwitüm Aba sab ibü nókyene. ");
INSERT INTO tof_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Zitülkus módóga, enana nis ó aüd pama kürü ngidü nóma kwób bazene, ka ola asinla ibü aodó.” ");
INSERT INTO tof_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita Yesuka tamórr, da imtinürr wagó, “Lod, kürü Lodón amkoman angun zonareta kürüka kolae tonarr metat nóma yarile, ka ia oya kolae tonarr nigó münüm norrgonónómo? Ia 7 münüm?” ");
INSERT INTO tof_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu oyaka bóktan we yalkomólórr wagó, “Koke, 7 mün gaodó kokea. Ka marü igó ayaldóla, ma moba Lodón amkoman angun zonaretan kolae tonarr metat barrgon namulo. ");
INSERT INTO tof_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","We ngarkwatódó, Godón Kingzan Balngomól inzana: Darrü king asi yarilürr. Darrü ngürr oya ubi tóba elklaza ngabkan pamab mani ngarkwat dümdüm ainüm yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wa ngarkwat nóma bókyanórr, darrü oya elklaza ngabkan pam sidüdóp. Ene pama tóba wirri pamdógab amkoman wirrian mani ngarkwat dedidü yazebórr. ");
INSERT INTO tof_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ene elklaza ngabkan pam gaodó koke yarilürr tóba wirri paman dedi amkalóm. Kinga tóba ngibürr zaget pam nilóp wagó, ‘Ini pam, tóba kol akó olmal, akó oya blaman ne elklazako sel ninamke, wa ne kla dedidü ipadórr, we kla amkalóm.’ ");
INSERT INTO tof_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Da ene elklaza ngabkan pama wakósingül we nülkamülürr kingan obzek kwata, da oya yatorr wagó, ‘Kürü wirri pam! Ma kürü ayalgu moba dedi büsai amkalóm! Ka sab darrem blaman elklaza marü mülino!’ ");
INSERT INTO tof_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kinga oya gyaur bóktan ipadórr, da oya we yalórr wagó, ‘Ma moba dedi amkalgu; ka kuri norrgonónóma!’ Da müót kalkuma we zirrapónórr. ");
INSERT INTO tof_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ene elklaza ngabkan pamazan wamlórr, da tóba zaget kamadpükü baserri, oya mani dedidü nótó yazebórr ngibürr kina. Tóbaka idódürr, gepkodó arümürr. Oyabóka wagó, ‘Kürü darrem kókya, ma ne kla ipadórró!’ ");
INSERT INTO tof_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Oya zaget kamada wakósingül we nülkamülürr. Oya yatorr wagó, ‘Ma kürü ayalgu moba dedi büsai amkalóm! Ka sab darrem marü elklaza mülino!’ ");
INSERT INTO tof_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Da wa oya bóktan koke ipadórr. Oya tümün müótüdü we amaikürr, ngarkwat kókó wa ene dedi ki emkóle. ");
INSERT INTO tof_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Oya zaget kamdala nóma esenóp ne klama tómbapónórr, i kari gyaur koke koralórr, da king blaman kla azazilüm we ogobórr. ");
INSERT INTO tof_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Da kinga ene ngaen-gógópan elklaza ngabkan pam akó ngyaunürr. Oyabóka wagó, ‘Ma küp-koke zaget pamla! Ka marü dedi arrgorró, ma kürükagab ne ngarkwat sipadórró, zitülkus ma kürü katorró. ");
INSERT INTO tof_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ma moba zaget kamadódó gyaur ki namüla, ka marükazan gyaur namülnürrü.’ ");
INSERT INTO tof_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King kari ngürsil ta koke yarilürr ngaen-gógópan elklaza ngabkan pamdó, da ene olom tümün müótüdü we zirrapónórr. Tümün müót ngakan pama oya ola emkalnóp, ngarkwat kókó ta wa tóba dedi ki emkóle. ");
INSERT INTO tof_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Da ene inzanase, e yabiób Lodón amkoman angun ⌊zonaretalab⌋ kolae tonarr ne koke nóma norrgonane yabiób amkoman moboküpdügab, kürü kwitüm Aba ta sab yabü dadanzan nangónórre.” ");
INSERT INTO tof_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesun ini bóktana nóma blakónórr, Galili amgatórr, ama Zudia bwóbdübóna wamórr, Zodan tobarr dakla dorro. ");
INSERT INTO tof_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Oyaka wirri pamkolpamab ngoroa zutalórr, da ibü we dólóng nyónónóp ola. ");
INSERT INTO tof_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ngibürr Parrisia oyaka we togobórr. Ibü ubi oya amiógüm yarilürr tóba bóktandógab. I oya imtinóp wagó, “Mibü gidadógab ia taia, pama kol amaiküm popa pokodógab, ta ia koke?” ");
INSERT INTO tof_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu ibüka bóktan yalkomólórr wagó, “E Godón Wibalómórrón Bóktan ta etóngarre igó ne poko yarilürr wagó, ‘Bwób zitüldü, God blaman elklaza nóma tómbapónórr, wa ibü igó tónzapónórr, pam a kol’. ");
INSERT INTO tof_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","God igó yarilürr wagó, ‘Ini zitülkusdü pama tóba aipab nis nümgüte, ama tóba koldó dabine, da i ma darrpan bübüm baini.’ ");
INSERT INTO tof_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Igósidi i ma nis kokeamli, a ma darrpanamli. God ne kla dayónda darrpan pokodó, pama kokean nürrgrrüte.” ");
INSERT INTO tof_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Parrisia Yesun imtinóp wagó, “Da Moses wa pam iade arüng bóktan ekyanórr, kol amaik peba mórrag kol akyanóm, wirri ngi pama ne kla wialómórr, da we klampükü amaiküm?” ");
INSERT INTO tof_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu ibüka bóktan we yalkomólórr wagó, “Yabü ene kwat Moses igósidi nómtyenóp yabiób kol amanóm, zitülkus e Godón gida bóktan poko mamoanóm kokeanómakla. A pam a kol nóma tónzapónórr, inzan tonarr ugón babul yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka ma yabü igó byaldóla: Nadü pama tóba kol zumanike popa pokodó, a pam gómólankwata koke, akó darrü kol zumige, wa kol gómól yarile.” ");
INSERT INTO tof_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesun umulbain olmala oyaka bóktónóp wagó, “Inzan ne nóma yarile pam a kol ibüka, da morroal igósa, kol bumióg a pam bumióg ki yarilün!” ");
INSERT INTO tof_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu ibüka bóktan yalkomólórr wagó, “Blaman pamkolpama ini bóktanan küp koke asendako, wata idi, God nibiób nókyenóp, igó, ");
INSERT INTO tof_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ene pokodó abün küpako, pama kol koke iade amiógda. Ngibürra we zitülkusdü, i gaodó kokeako kol bumiógüm, i ne ngarkwatódó tóbabótórr. Ngibürra go we zitülkusdü, pama ibü pugum küp nüsilóp. Akó ngibürra go we zitülkusdü, Godón Kingzan Balngomólankwata. Ini umulbain bóktan apadóm gaodó nótó yarile, wa ki ipa.” ");
INSERT INTO tof_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngibürr pamkolpama kari olmalpókal tübarrmünürr Yesuka, ibü singüldü tóba tang nis amelóm akó ibünkü tóre ki eko-e. Da umulbain olmala ma ene kolpam we nagóp amarrugum. ");
INSERT INTO tof_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu ibüka bóktanórr wagó, “Kari olmalpókala ki togob kürüka! E ibü burrmatgu, zitülkus Godón Kingzan Balngomól ibünse, inzan olmalpókal nidipko!” ");
INSERT INTO tof_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Da módóga, wa darrpan-darrpandó tóba tang nis nómngyelórr ibü bles byónüm, da tüób olgabi we wamórr. ");
INSERT INTO tof_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Darrü tonarr, küsil pama Yesuka tamórr. Oyabóka wagó, “Umulbain pam, ka ia laró morroal tórrmen tulmil tómbapono ⌊ngarkwat-koke arról⌋ apadóm?” ");
INSERT INTO tof_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu oyaka bóktan we yalkomólórr wagó, “Ma kürü iade amtindóla morroalankwata? Ene wata Darrpana morroal nótóke, God tüób. Godón ne gida bóktan pokoko, ma we kla emorrono ngarkwat-koke arróldó tótókóm.” ");
INSERT INTO tof_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wa imtinürr wagó, “Ia nadü ne gida bóktan pokoko?” Yesu bóktanórr oyaka wagó, “Ma darrü olom büdülümpükü amkalgu, ma kol ó pam gómólgu, ma gómólgu, ma obae tiz bóktan adrratgu darrü olomankwata, ");
INSERT INTO tof_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ma moba aipab nis morroal angón namülün, marü ⌊moboküpdü ubi⌋ moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane.” ");
INSERT INTO tof_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ene küsil pama we bóktanórr wagó, “Ka go blaman ini gida bóktan poko amkoman amorran namülnürrü. Ka da ma akó laró tónggapono?” ");
INSERT INTO tof_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu oyabóka wagó, “Ma ubi nóma namulo ⌊dudu kómal⌋ bainüm, da ugó wam, moba blaman elklaza sel ninünümke, ene mani sab elklaza-koke ne kolpamko nülinünümke. Sab igósidi marü mórrel ma kwitüm yarile. Da yao, kürüka tókyanke.” ");
INSERT INTO tof_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ene küsil pama ene bóktan nóma arrkrrurr, wa gyaurpükü we wamórr, zitülkus oya abün elklaza kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesu tóba umulbain olmalbóka wagó, “Ka yabü amkoman poko byaldóla: sab kari müp ta koke yarile mórrel pamankü Godón Kingzan Balngomóldó bangrinüm. ");
INSERT INTO tof_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka yabü akó byaldóla, ⌊kamelan⌋ nabea nil tótórrana bangrinüm, a mórrel paman ma amkoman nabeana Godón Kingzan Balngomóldó bangrinüm.” ");
INSERT INTO tof_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Umulbain olmala ene bóktan nóma barrkrrurr, i karibóka-koke gübarirr aengóp. I we imtinóp wagó, “Da ia sab dama nótó zid baine?” ");
INSERT INTO tof_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu ibü dümdüman ngankónóp, bóktan we yalkomólórr wagó, “Pamakanankü gaodó ta kokea tómbapónóm; Godka ma blaman kla gaodómako.” ");
INSERT INTO tof_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pita oyaka we bóktanórr wagó, “Ma turrkrru, ki blaman elklaza oloknórró marüka atanóm!. Ki sab ia laró darrem ipüdórre?” ");
INSERT INTO tof_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu ibübóka wagó, “Ka yabü amkoman poko byaldóla: küsil ngyabena sab nóma tame, ka, Pamkolpamab Olom nótókla, sab kólba ⌊wirri kómal zyón⌋ kingan mórran klamdó nóma mórrono pamkolpam balngomólóm, e kürü ne 12 umulbain olmalakla, e ta sab yabiób kingan mórran klamdó bobrrono, Isrrael 12 zitül pamkolpam balngomólóm. ");
INSERT INTO tof_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nadü oloma tóba müót basirr, zonaretal, bólbótal, aipab nis, olmal, akó tüp bimgüte kürünkü, ene oloma sab 100 münüm yazeble ene elklaza akó wa sab ngarkwat-koke arról ipüde. ");
INSERT INTO tof_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Abün singül kwata nidipako, sab ma solodó kwarile, ó abün solodó nidipako, sab ma singül kwata kwarile. ");
INSERT INTO tof_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“We ngarkwatódó, Godón Kingzan Balngomól inzanase: Irrbianande, darrü grreip apapan aba wamórr zaget pam bumiógüm tóba grreip apapdó zagetóm. ");
INSERT INTO tof_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Wa ubi bainürr darrpan-darrpan zaget pam darrpan ⌊silba⌋ mani küp darrem aliónüm. Da i ubi bainóp. Ene wata angrirrün ngarkwat yarilürr apapdó zaget pamabkü. Da wa ibü we zirrnapónóp tóba apapdó zagetóm. ");
INSERT INTO tof_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Irrbianande, abüsa tüngürürr kókó dadamüz. Wa akó elklaza bumióg pokodó we wamórr. Da ngibürr pam nósenóp popa bórrangde, i darrü kla koke tónggapón koralórr. ");
INSERT INTO tof_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wa akó ibü we nilóp wagó, ‘E ta ugó ogob kürü apapdó zagetóm. Yabü ka kubó morroal darrem nülinünümo.’ ");
INSERT INTO tof_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Da i we ogobórr. Abüs singülküp nóma yarilürr, wa akó ngibürr pam bumiógürr. Abüs aüd küp nóma emrranórr simam, wa akó ngibürr pam bumiógürr. Wa ibüka ta dadan bóktan poko we bóktanórr ibü darrem klamankwata. ");
INSERT INTO tof_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Abüsa 5 küp nóma emrranórr, wa akó elklaza bumióg pokodó wamórr. Wa akó ngibürr pam we nósenóp ola bórrangde. Wa ibü nümtinóp wagó, ‘E ia ini ngürr popa larógóm amanikdakla, darrü kla tónggapón-koke?’ ");
INSERT INTO tof_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","I oyaka bóktan yalkomólóp wagó, ‘Kibü darrü pama koke kuri tübumige.’ Wirri pama ibü we nilóp wagó, ‘Da e ta ugó ogob kürü grreip apapdó zagetóm.’ ");
INSERT INTO tof_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Abüsa nóma bótaolórrma, apap aba tóba zaget alngomól pambóka wagó, ‘Zaget pam ugó ngibau, da ibü kubó darrem kla nülinünümke. Da ibüka we ngarkwat bókyanke, ka dómdóm solodó nibiób bumiga. Kalma ola elakónke, ka ngaen-gógópan nibiób bumiga.’ ");
INSERT INTO tof_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dómdóm ne pam bumiógürr, abüsa 5 küp nóma emrranórr, ibü blaman darrpan silba mani küp nülinóp. ");
INSERT INTO tof_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Irrbianande nibiób bumiógürr, tibiób darrem azebóm nóma ogobórr, ibü gyagüpitótók inzan yarilürr wagó, i ta kubó wirrian darrem ipüdórre. A i ta darrpan silba mani küp yazebóp. ");
INSERT INTO tof_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tibiób darrem kla nóma yazebóp, we kakóm, apap ab we murrkurr akrrónóp wagó, ");
INSERT INTO tof_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ma abüs irrübüm ne pam bumiga, i wata darrpan abüs küpüm zaget apórre. Ki wa dudu ngürr zaget korala abüs ururdü, da ma ma kibü darrpan ngarkwat darrem iade tülinünüma?’ ");
INSERT INTO tof_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Wa darrüdü bóktan yalkomólórr wagó, ‘Gódam, turrkrru! Ka marü koke gómól-gómól mangóna. Ma ta müób ubi baina zagetóm darrpan silba mani küp apadóm. ");
INSERT INTO tof_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Da moba darrem ipa, da ugó wam müótüdü. Kürü ubi yaril, ka solodó ne pam bumiga, ibü we ngarkwat nülinünüma, ka yabü ne ngarkwat darrem alióndóla. ");
INSERT INTO tof_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kürü ene dümdüm asine. Kürü ubi laró tónggapónóma kólba manie, ene kürü kólbakama! Ia marü gyagüp kolaea igósidi mómkóle, zitülkus ka morroal tonarr olomla?’ ");
INSERT INTO tof_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Da módóga, solodó nidipako, sab singül kwata kwarile, ó singül kwata nidipako, sab solodó kwarile.” ");
INSERT INTO tof_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu Zerrusalem wirri basirrdü nóma kasilülürr, tóba 12 umulbain olmal kwat-kwat tótókde tebe-tebe pokodó imarrurr, akó ibüka we bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Tübarrkrru! Mi Zerrusalem bamseldakla. I sab kürü, Pamkolpamab Olom nótókla, wirri prrist akó Mosesón gida umulbain pam, ibü tangdó ola küngrirre, da i kürü büdül bóktan sab ola kókyerre. ");
INSERT INTO tof_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Olgabi ama akó Zu-koke nidipko, ibü tangdó ugón küngrirre. I kürü sab we ⌊tiz kangónórre⌋ akó karrkukus sye-i kyólnórre, da kürü krrosdó sab we kómngyerre. Aüd ngim ngürrdü, God kürü sab ugón kürsümüle büdüldügab.” ");
INSERT INTO tof_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedin siman olom nis, ibü aipa katókórr Yesuka, tóba nis siman olom nispükü. Wa tóba wakósingül nülkamülürr Yesun obzek kwata, tóba ubi pupainüm darrü klamóm. ");
INSERT INTO tof_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu oya umtinürr wagó, “Marü ubi larógóma?” Wa bóktan yalkomólórr wagó, “Ma kürü dümdüman kyal, kürü ne siman olom nisamli marü minggüpanan mórróni moba Kingzan Balngomól Bwóbdü, darrüpa marü tutul kwata, darrüpa marü banól kwata.” ");
INSERT INTO tof_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu ibüka bóktanórr wagó, “E umul-kókakla e larógóm batodakla! E ia gaodómamli ene müp ódódóm, ka ne müp ódódóm kaindóla?” I bóktan yalkomórri wagó, “Ki gaodómamli.” ");
INSERT INTO tof_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ibüka bóktanórr wagó, “Amkoman, e ene müp sab idüdi, ka ne müp ódódóm kaindóla. A kürü gaodó kokea yabü ok ainüm mórranóm kürü tutul kwata akó kürü banól kwata. Sab kürü Aba wató nókyene ene marrgu nis, wa nibióbkü kuri tónzapónórr.” ");
INSERT INTO tof_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Da ene 10 ngarkwat umulbain olmala nóma barrkrrurr, ibü ngürsila yazebórr ene nis narezoreti pam nisdü, Zeims a Zon. ");
INSERT INTO tof_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Da Yesu ibü blaman ngibaunürr tóbaka. Wa bóktanórr ibüka wagó, “E umulakla, Zu-koke nidipako, ibü singüldü pama pamkolpam zirrbapón-bapón balngomóldako, akó ibü wirri pama ibü wirri arüngi balngomóldako. ");
INSERT INTO tof_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Da yabüka inzan babula. Nadü oloman ubi yarile wirri ngi bainüm yabü aodó, wa yabü blamanab popa tangbamtin pam ki yaril. ");
INSERT INTO tof_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Akó yabükagab singüldü tótókóm nótó nóma yarile, wa yabü ⌊leba zaget olom⌋ ki yaril. ");
INSERT INTO tof_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ene inzana, ka, Pamkolpamab Olom nótókla, igósidi koke tamórró igó, pamkolpama kürü popa tangamtin kwarile. Koke! Ka pamkolpam popa tangbamtinüm tamórró, kólba arról abün pamkolpamabkü darrem akyanóm, ibü arról akonóm kolae tonarrdógab.” ");
INSERT INTO tof_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu tóba umulbain olmalpükü Zerriko wirri basirr nóma amgatórr, ibüka wirri pamkolpamab ngoroa zutalórr. ");
INSERT INTO tof_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Da módóga, nis ilküp murrbausürrün pam nisa kwat kabedó mórran namülnürri. Nóma arrkrrurri wagó, Yesu ibü arrgrratódae, i górrgarri wagó, “Lod, ⌊Deibidün⌋ Olom, kibü gyaur tóse!” ");
INSERT INTO tof_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ene pamkolpama ibü nagóp, da nilóp piküp bainüm. A i ma górrganóm tai arüng ipadnürri wagó, “Lod, ⌊Deibidün Olom⌋, kibü gyaur tóse!” ");
INSERT INTO tof_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu zamngólórr, da ibü nginaunürr. I nóma turrürri, wa ibü we nümtinürr wagó, “Ia yabü ubi ka yabünkü laró tónggapono?” ");
INSERT INTO tof_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","I we bóktarri wagó, “Lod, gyaurka, kibü ilküp ugó tomgolnónóm!” ");
INSERT INTO tof_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu ibü gyaur nósenórr, da ibü ilküp we namurróp. Dümdüman ibü ilküpa we tomgolóp, da i Yesuka we akyarri. ");
INSERT INTO tof_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesup Zerrusalem wirri basirr nóma ngorram yónónópma, i darrü basirr we emrranónóp, ngi Betpage, ⌊Olib Podo⌋ kabedó. Yesu tóba umulbain olom nis ngaensingülan we zirrnapónórr ");
INSERT INTO tof_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ini bóktanpükü wagó, “E ugó aurram kókó yabü singül kwata ne basirrse. E kubó nóma bangrini, dümdüman e kubó óp ⌊donki⌋ tóba kyampükü oseni, sye-i amrókrrón. Kubó nogoamke, da kubó tüdüdamke. ");
INSERT INTO tof_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Darrü oloma ne yabüka darrü poko nóma bóktóne, kubó igó ilamke magó, ‘Lod ini nis klamóm sógóse. Da wa kalma büsai talkomóle.’” ");
INSERT INTO tof_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ini pokoa igósidi tómbapónórr, Lodón bóktan küppükü ainüm, wa prropetódó ne poko bóktanórr pamkolpamdó adrratóm wagó, ");
INSERT INTO tof_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zerrusalem pamkolpam nilam, ‘Ngakónam, yabü kinga yabüka tótókda! Wa tüób mómók tonarr pama. Wa donkie tótókda, donki kyam kwitüm mórrarróna.’” ");
INSERT INTO tof_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Da umulbain olom nisa we aurrürri, da tónggapórri ibü Yesu enezan nyalórr tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ene donki tóba kyampükü we tüdüdóp Yesuka. I tibiób tumum mórrkenyórr we nüdrratrri ene nis donki kwitüm. Yesu we kasilürr, da mórrkenyórr kwitüdü mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Wa enezan wamlórr, abüna pamkolpamab ngorodógab tibiób tumum mórrkenyórr we zursilürr kwatódó oya morroal apadóm. Ngibürra pórngaepükü kari nugup tiz singgalgónóp, kwat kabedó kla, da Yesun kwatódó we zursilürr. ");
INSERT INTO tof_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Singül kwata ne pamkolpamab ngoroa ogoblórr akó oya solkwat nidi zutalórr, oya wirribóka we yagürnóp wagó, “Mi ⌊Deibidün⌋ Olom yagürnórre! Wa bles airrüna, Lodón ngidü nótó tótókda! Mi Wirri Kwitüm Godón yagürnórre!” ");
INSERT INTO tof_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu Zerrusalem nóma bangrinürr, blaman basirr pamkolpama barrkürrürr. Tibiób bamtinónóp wagó, “Ini ia nótóke?” ");
INSERT INTO tof_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yesuka ne pamkolpamab ngoroa zutalórr, ibüka we bóktanónóp wagó, “Ini Yesue, ene prropet Nazarretgab, Galili prrobinsdüma.” ");
INSERT INTO tof_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu Godón Gyabi Müótan kal akólórrón pul basirrdü we bangrinürr. Wa blaman kolpam kolabütan yarilürr, ola nidi sel bain akó nidi bumióg kwarilürr. Mogob pamkolpamab mani nidi sensi bangón kwarilürr, Yesu ibü tógal okaka we izazilürr. Gainao póyae nidi sel bain kwarilürr, ibü mórran klampükü ta izazilürr. ");
INSERT INTO tof_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Wa ibüka bóktanórr wagó, “Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Kürü Müót sab wata inzan ngilian kwarile wagó, pamkolpamab tóre müót.’ A e ma igó aindakla, wamaka gómól pamab ban bwóbe!” ");
INSERT INTO tof_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ilküp murrbausürrün pamkolpam akó kolae wapór pamkolpama ene kal akólórrón pul basirrdü oyaka we togoblórr. Wa ibü blaman dólóng ninóp. ");
INSERT INTO tof_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wirri prrist akó Mosesón gida umulbain pama esenóp, Yesu wirri morroal ne elklaza tómbapón yarilürr, akó i ta kari olmalpókal nurrkrruóp taegwarrde Godón Gyabi Müótan kal akólórrón pul basirrdü wagó, “⌊Deibidün Olom⌋ yagüram!” Ibü ngürsila igósidi we yazebórr. ");
INSERT INTO tof_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Da i Yesun we imtinóp wagó, “Ma ia arrkrrudóla kari olmalpókala ne poko bóktandako?” Yesu bóktan yalkomólórr wagó, “Ó, ka kuri nurrkrrunüma. E ta Godón Buk kuri etóngarre, igó ne poko bóktanda wagó, “‘Ma sab kari olmalpókal akó ngóm alo olmal umul ninünümo, moba agürüm amkoman moboküpi.’” ");
INSERT INTO tof_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu ene pamkolpam ene wirri basirrdü nümgütóp. Wa we wamórr Betani basirrdü. Ene irrüb ola umtulürr. ");
INSERT INTO tof_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ene irrbianande, i Zerrusalem nóma bakolórr, Yesun aloa ipadórr. ");
INSERT INTO tof_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wa darrü pig nugup osenórr kwat kabedó, da we wamórr ngakanóm. Darrü küp koke esenórr, wata pórngaean kwarilürr. Yesu ene nugupdü we bóktanórr wagó, “Ma sab myamem küp kokean waono!” Dümdüman ene pig nugupa odalórr, da nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Umulbain olmala ene nugup nóma osenóp odalde, gübarirr aengóp. Da i oya we imtinóp wagó, “Ini pig nugupa büsai-büsai iade odole?” ");
INSERT INTO tof_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu ibüka bóktanórr wagó, “Ka yabü amkoman poko byaldóla: e ne Godón amkoman nóma yangunane akó abün-abün gyagüpitótók koke nóma koralo, e inzan tórrmen tulmil tólaelane, ka ini pig nugupzan wangóna. A ini kla tebean koke. E ta ini podo ne igó nóma ilane magó, ‘Ma ugó bupa, da moba bumanik maludü,’ ene pokoa sab amkoman tómbapóne. ");
INSERT INTO tof_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","E ne Godón amkoman nóma yangunane, e tóredó ne klamóm yatoane, e sab ene kla ipüdane.” ");
INSERT INTO tof_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu Godón Gyabi Müótan kal akólórrón pul basirrdü bangrinürr. Wa pamkolpamzan umul bain yarilürr, wirri prrist akó Zu pamkolpamab ⌊balngomól byarrmarr pama⌋ oyaka we togobórr. Da we imtinóp wagó, “Ma ini elklaza ia nadü balngomól arüngi tómbapóndóla? Marü ini arüng ia nótó mókyanórr?” ");
INSERT INTO tof_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu ibüka bóktan yalkomólórr wagó, “Ka yabü darrpan amtin bóktan poko bamtindóla. E ne kürüka morroal bóktan nóma salkomólane, ka yabü umulüm igósidi adrrüto, ka ini elklaza nadü arüngi tómbapóndóla. ");
INSERT INTO tof_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Zonón ⌊baptaes baina⌋ ia nubógabi tamórr? Ia kwitümgab, ta ia pamdógab?” I tibiób ini bamtin bóktan pokoankwata we apón kwarilürr wagó, “Mi ne igó nóma kwarilo wagó, ‘Kwitümgab,’ wa kubó mibü tümtirre wagó, ‘Da e oya amkoman angunüm koke iade koralnórró?’ ");
INSERT INTO tof_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A mi ne igó nóma kwarilo igó, ‘Pamdógab,’ pamkolpam kubó ngürsil kwarile mibüka. Da mi pamkolpamab gum kwarilo, zitülkus blamana Zonón igó angundako wagó, wa prropeta.” ");
INSERT INTO tof_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Da i bóktan we yalkomólóp Yesuka wagó, “Ki umul kokeakla.” Yesu ibüka bóktanórr wagó, “Ka ta yabü koke nüzazilnümo igó, ka ini elklaza ia nadü arüngi tómbapóndóla. ");
INSERT INTO tof_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“E ia gyagüpi tótókdakla ini alap-alap bóktanankwata? Darrü tonarr, paman nis siman olom nis namülnürri. Wa tóba ngaen siman olomdó wamórr a oyabóka wagó, ‘Kürü olom, ⌊grreip⌋ didiburrdü zagetóm ugó wam ini ngürr.’ ");
INSERT INTO tof_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Wa tóba abbóka wagó, ‘Ka kokela.’ Da solodó tóba gyagüpitótók we imzazilürr, da we wamórr didiburrdü zagetóm. ");
INSERT INTO tof_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aba akó darrü siman olomdó wamórr. Oya akó dadan bóktan poko yalórr wagó, ‘Kürü olom, didiburrdü zagetóm ugó wam ini ngürr.’ Ene oloma tóba abbóka wagó, ‘Taia ba, ka kubó wamo.’ Da ma koke wamórr. ");
INSERT INTO tof_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ia nadü oloma aban ubi ipadórr?” Wirri prrist akó Zu pamkolpamab balngomól byarrmarr pama oyabóka wagó, “Ngaen siman oloma tóba aban ubi ipadórr.” Yesu ibübóka wagó, “Ene amkoman pokoa! Ka yabü amkoman poko byaldóla: taks mani dakabain pama akó popa kwatódó agól kol, Godka nóma tübyalüngórre, Godón Kingzan Balngomóldó ngaen-gógópan idi barrbündako yabü singül kwata. ");
INSERT INTO tof_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zon Baptaes Bain Pama yabü dümdüm kwat mamoanóm umul bainüm tamórr, da e oya amkoman koke yangunarre, a taks mani dakabain pam akó popa kwatódó agól kol, i ma oya amkoman yangunóp. E go ene kolae tonarr pamkolpamab amkoman bangun esenarre, da e yabiób gyagüpitótók koke izazinarre Zonón amkoman angunüm, solodó. ");
INSERT INTO tof_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Akó darrü alap-alap bóktan tübarrkrru. Darrü pama abün grreip zid iritürr tóba tüpdü. Ene kakóm, wa kal akólórr. Wa kugupi ilüngürr, ene grreip ngórr mor amóngóm, da wa barrkyanan kwit azil müót elórr, tóba grreip kaldó olgab azilüm. Da wa ene grreip apap ngibürr ngaon pam nókyenóp ngakanóm tibiób darremóm akó tóbankü. Tüób ama aibwób wamórr. ");
INSERT INTO tof_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Grreip ngórr abül tonarr nóma semrranórr, wa tóba leba zaget pam zirrnapónóp ene pamdó, grreip apap nidi ngakan kwarilürr, tóba ene pailan grreip ngórr azebóm. ");
INSERT INTO tof_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ene apap ngakan pama ene leba zaget pam bumigóp. Darrü we enan dom apónóp, darrü we büdülümpükü emkólóp, akó darrü wa ingülküpi emkólóp. ");
INSERT INTO tof_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ene apap aba akó dokyanan leba zaget pam we zirrnapónóp. Ibü akó dadanzan nangónóp. ");
INSERT INTO tof_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dómdóm ma aba tóba darrpanan siman olom we zirrapónórr ibüka, igó gyagüpitótókpükü wagó, ‘I kürü siman olom sab morroal tonarre yangórre.’ ");
INSERT INTO tof_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ene grreip apap ngakan pama aban olom nóma esenóp, i tibióbka bóktónóp wagó, ‘Ene olom módóga, ini grreip apap sab nótó ipüde. Yao! Mi errkya büdülümpükü amkaldakla, akó oya aban elklaza sab midi iade yazebrre, aban büdül kakóm!’ ");
INSERT INTO tof_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Da módóga, i oya we amigóp, ama apap kalkuma amaikóp, da büdülümpükü we emkólóp. ");
INSERT INTO tof_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ene grreip apap aba sab tüób nóma tame, wa ia laró tónggapóne ene grreip apap ngakan pamdó?” ");
INSERT INTO tof_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ene wirri pama bóktan we yalkomólóp wagó, “Ene kolaean pam sab büdülümpükü ekrróne, akó wa ene grreip apap sab ngibürr apap ngakan pam nókyerre. Da i sab oya tóba ngórr grreip iliónórre, abül tonarr nóma semrrale.” ");
INSERT INTO tof_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu ibübóka wagó, “E ta ini poko kürükwata etóngarre Godón Wibalómórrón Bóktandó wagó, “‘Müót balmel pama ne ingülküp alzizi amaiknóp, errkya ma ene müótan zirrgüpdü ingülküpüm wató kuri baine. Lod ini kla tüób tónggapónórr, da mibü ilküpdü kari morroal ta kokea!’ ");
INSERT INTO tof_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ini zitülkusdü ka yabü igó byaldóla, God sab bólene yabü balngomólóm Kingzan akó wa bókyene we pamkolpam balngomólóm Kingzan, Godón Balngomólan küp nidi bapóndako. ");
INSERT INTO tof_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nótó aupe ini ingülküp kwitüdü, sab syórr yangóne. Akó ingülküpa noanka tupe, oya sab baem apóne.” ");
INSERT INTO tof_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wirri prrist akó Parrisia oya alap-alap bóktan nóma arrkrruóp, da i umul bainóp wagó, Yesu ibükwata bóktanda. ");
INSERT INTO tof_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I kwat we yamkünónóp oya amiógüm. A i ma pamkolpamab gum kwarilürr, zitülkus ene pamkolpama igó yangunónóp wagó, Yesu wata prropeta. ");
INSERT INTO tof_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu wirri prristdü akó ⌊balngomól byarrmarr pamdó⌋, akó alap-alap bóktan yarilürr wagó, ");
INSERT INTO tof_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godón Kingzan Balngomól inzanase. Darrü bwóban kinga tóba siman oloman kol amióg tóre tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wa tóba ⌊leba zaget⌋ pam zirrnapónóp, nibiób ngibaunürr, ibü byalóm ene tóredó tótókóm. Da i ma ubi koke bainóp tótókóm. ");
INSERT INTO tof_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Wirri pama akó tóba ngibürr zaget pam zirrnapónóp wa ne pam ngibaunürr, ibü byalóm tóba tóredó tótókóm, ini bóktanpükü wagó, ‘Tübarrkrru! Ka kólba tórean blaman alo kla kuri tómbapóna. Kürü simanal ⌊kau⌋ akó pyórr aupürrün kau kuri bódabórre. Blaman kla tómbapórrónako, da yao, ugó togob tóredó!’ ");
INSERT INTO tof_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","A ibü darrü baku burrul ta babulan yarilürr. I blamana tibiób ubiankwata barsenórr. Darrüpa tóba ngaon bwóbdü wamórr, darrüpa tóba elklaza bumióg müótüdü wamórr, ");
INSERT INTO tof_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","a barrea wirri paman zaget pam bumigóp, kolae akrran we okrralórr, da büdülümpükü we ekrrónóp. ");
INSERT INTO tof_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kinga nóma arrkrrurr, oya kari ngürsila ta koke ipadórr. Wa tóba gazirr pam we zirrnapónóp oya zaget pam nidi okrralórr, ibü blaman büdülümpükü akrranóm. Akó ibü wirri basirrpükü ta uri setenóp. ");
INSERT INTO tof_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Wa tóba ngibürr leba zaget pam ngibaunürr, ibübóka wagó, ‘Tóre alo kla blaman tómbapórrónako. Ka ngaen-gógópan ne pamkolpam ngibauna, morroal tonarr ngarkwatódó pamkolpam koke kwaril kürü tóredó tótókóm. ");
INSERT INTO tof_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Da ugó ogob wirri kwatódó ne il bagótdako. E kubó nigó-nigó pamkolpam nósenane, da kubó ngiblinamke tóredó tótókóm.’ ");
INSERT INTO tof_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Oya leba zaget pama we ogoblórr wirri kwatódóma. I nibiób nósenónóp, morroal pamkolpam, kolae pamkolpam, ibü darrpan pokodó we kwób isuóp. Ene kwóbbazen müóta tai kókó we barümürr pamkolpamabme. ");
INSERT INTO tof_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kinga ene pamkolpam ngabkanóm wamórr. Wa ola darrü pam esenórr tóre mórrkenyórr koke nótó batenórr. ");
INSERT INTO tof_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Oyabóka wagó, ‘Gódam, ma wa ini ia tübangrina tóre mórrkenyórr-koke?’ Ene pama darrü poko kokean bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Da kinga tóba zaget pam nilóp wagó, ‘Wapór a tang nürümam, kalkuma tümün kwatódó ugó amaikam. Wa sab ola yón akó zirrgüp bótak yarile.’ ");
INSERT INTO tof_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","God blaman pamkolpam ngibaunda, sab ma aüdan sazebe.” ");
INSERT INTO tof_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ene kakóm, Parrisia ogobórr, bóktan we tónggapónóp Yesun darrü bamtin bóktan poko amtinüm, wa morroal koke ne bóktan poko ki yalkomóle. ");
INSERT INTO tof_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Da i ngibürr Errodón mamoan pam akó tibiób ngibürr umulbain olmal we zirrnapónóp Yesuka. Oyabóka wagó, “Umulbain Pam, ki umulakla wagó, ma amkomanla akó ma Godón kwat amkoman bóktane umul byóndóla pamkolpamdó. Akó pamkolpamab gyagüpitótóka marü koke gum-guman ngitandako. Ki ene kla umulakla, zitülkus ma blaman pamkolpam, ia wirri pam, kari pam, wata darrpan ngarkwatódó ngabkandóla.” ");
INSERT INTO tof_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Oya imtinóp wagó, “Kibü moba gyagüpitótók kóbó tüzazilnüm, mibü gidadógab ia taia Sisan taks mani aliónüm, ta ia koke?” ");
INSERT INTO tof_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A Yesu ma ibü kolaean gyagüpitótók umul bainürr, da we nilóp wagó, “E taepurrane bóktan pamakla! Ia e kürü kólba bóktandógabi amiógüm iade kaindakla? ");
INSERT INTO tof_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Darrü taks mani küp kürü kóbó kómtyenam!” I oyaka darrü küp we idüdóp, ");
INSERT INTO tof_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","da wa ibü nümtinóp wagó, “Ia noan obzeke akó ngie?” ");
INSERT INTO tof_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","I bóktan we yalkomólóp wagó, “Sisan.” Da Yesu ibüka bóktanórr wagó, “Da módóga, Sisan ne klamko, Sisan ilinamke, akó Godón ne klamko, Godón ilinamke.” ");
INSERT INTO tof_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Da i Yesun bóktan nóma arrkrruóp, gübarirr aengóp. I oya we amgütóp, da we bakonórr. ");
INSERT INTO tof_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ene dadan ngürr, ngibürr ⌊Sadusi pama⌋ Yesuka togobórr bamtin bóktan poko amtinüm, amkoman moboküpi koke. Ini pama igó bóktan kwarilürr wagó, pamkolpama sab koke tübarsile büdüldügab. ");
INSERT INTO tof_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","I Yesuka we bóktónóp wagó, “Umulbain Pam, Moses igó yarilürr wagó, ‘Darrü kolpükü pama ne nóma nurrótóke olmal-koke, ene paman narezoreta sab ene kóble ki zumióg, olmal balngenóm tóba büdül narezoretan ngidü.’ ");
INSERT INTO tof_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Da módóga, ngaen 7 zonaretalpükü pam kinkü aini koralórr. Nareta kol zumiógürr, da wa nurrótókórr olmal-koke. Kóble wa tóba olgabi zoretan tangdó zumgatórr. ");
INSERT INTO tof_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ene kóble noa tangdó ungrinürr, wa ta olmal-koke nurrótókórr. Akó darrüpa upadórr; wa ta olmal-koke nurrótókórr. Inzan kókó blaman ene pama nurrbarinürr. ");
INSERT INTO tof_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Solodó ene kóblea we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Da sab büdüldügab barsin tonarrdó, ia wa sab tai noan kol warile? Ki ene poko amtindakla, zitülkus i oya blamana zumigóp.” ");
INSERT INTO tof_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu ibüka bóktan yalkomólórr wagó, “E kle-kle gyagüpi tótókdakla, zitülkus e umul-kókakla Godón Wibalómórrón Bóktan akó Godón arüng! ");
INSERT INTO tof_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Büdüla nóma tübarsile arróldó, i sab myamem tibiób koke bumiógnórre, a i ma sab inzan kwarile, wamaka kwitüm anerruako. ");
INSERT INTO tof_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E ta kuri etóngarre God yabüka ne poko bóktanórr büdülab barsinankwata wagó, ");
INSERT INTO tof_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ka Eibrra-amón God, Aesakón God, akó Zeikobón God.’ Wa büdül pamkolpamab God koke-e, a wa arról pamkolpamab Gode.” ");
INSERT INTO tof_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pamkolpam ngoroa ene bóktan nóma barrkrrurr, i gübarirr aengóp, wa ne poko umul nyónónóp. ");
INSERT INTO tof_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Parrisia nóma barrkrrurr wagó, Yesu Sadusi pamab bóktan kuri piküp ine, i darrpan pokodó we kwób bazenórr. ");
INSERT INTO tof_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Darrpan Parrisia, tüób Zu pamkolpamab gida umulbain pam yarilürr, Yesun apókórr tóba bamtin bóktan poko-e. ");
INSERT INTO tof_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Wagó, “Umulbain Pam, Godón wirrian gida bóktan poko ia nadü ne klame?” ");
INSERT INTO tof_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu oyaka bóktan yalkomólórr wagó, “Marü ⌊moboküpdü ubi⌋ asi ki yarilün Lodka, marü God, moba dudu moboküpi, dudu samu-i, akó dudu gyagüpitótóke. ");
INSERT INTO tof_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ini ngaen-gógópan Godón wirrian gida bóktan poko módóga. ");
INSERT INTO tof_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nis ngim wirrian gida bóktan poko módóga, ‘Marü moboküpdü ubi moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane.’ ");
INSERT INTO tof_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mosesón dudu Gida Buk akó blaman Prropetab Peba, ini nis gida bóktan pokodó karrkukus bórrangórrónako.” ");
INSERT INTO tof_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parrisiazan darrpan pokodó kwób bazerrón kwarilürr, da Yesu ibü igó poko nümtinóp wagó, ");
INSERT INTO tof_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“E ia gyagüpi tótókdakla Kerrisonkwata? Ia wa noan olome?” I bóktan yalkomólóp wagó, “Wa ⌊Deibidün⌋ olome.” ");
INSERT INTO tof_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu akó bóktanórr wagó, “Godón Samua Deibidün iade yalórr tóba olom ngi ngyesilüm wagó, ‘Lod’? Deibid igó wialómórr wagó, ");
INSERT INTO tof_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Lod God igó bóktanórr kürü Lodódó wagó, “Ma ae mórra kürü tutul tangdó, kókó ka sab marüka nidi bóka bamgündako, marü wapór-o lorodó irrbuno.” ’ ");
INSERT INTO tof_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deibid tüób ne Kerrison nóma ngilianórr wagó, ‘Lod’, da Kerriso Deibidün olom iadea?” ");
INSERT INTO tof_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Darrü pam gaodó koke yarilürr Yesuka bóktan poko alkomólóm, da ene ngürrdügab blaman gum kwarilürr oya ngibürr poko amtinüm. ");
INSERT INTO tof_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ene kakóm, Yesu pamkolpamab ngorodó akó tóba umulbain olmaldó bóktan yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Wagó, “Mosesón gida umulbain pam akó Parrisia Mosesón pabo kuri ipüdóp; ibü ene arüng ó dümdüm asine Mosesón gida müsirrga ainüm. ");
INSERT INTO tof_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","E sab ibü blaman bóktan amorran kwarilünke, yabü ne kla tómbapónóm byal kwarile. A i ne kla tólbaeldako, e ibü mamoan-gu, zitülkus i pamkolpam ne kla umul baindako, tib tórrmendó koke arrbündako. ");
INSERT INTO tof_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Inzande, i ngyaben kari müp koke aindako abün gida tómbapónde pamkolpama mamoanóm. A i ma tib tibiób tang pyóm kubó kokean ingrirre ene müp kwit ainüm. ");
INSERT INTO tof_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","I blaman ne elklaza tómbapóndako, ibü ubi pamkolpama ibü nóserre. I tibiób müóngdü ne bokoszan kla bameldako, Godón bóktan opor ne kla kugupidümako peba mórragdó balómórrón, barrkyananako ngibürr pamab bokoszan klamdógab. Akó banól tangdó ta inzan bameldako. Ibü tumum mórrkenyórrdü maenzan balmelórrón sye ta kokrrap byóndako. ");
INSERT INTO tof_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ibü ta ene wirri ubi pokoa wirri pamab mórran bwóbdü mórranóm alongalo tóredó akó mórranóm wirri pamab mórran pokodó mibü kwóbbazen müótüdü. ");
INSERT INTO tof_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ibü ta inzan wirri ubi pokoa, pamkolpama ibü morroal ngürr bóktan nüliónórre pul basirrdü akó ‘Rrabi’bóka nóma ngiblianórre. ");
INSERT INTO tof_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pamkolpama yabü ‘Rrabi’bóka koke ki ngiblianórre, zitülkus e blaman zonaretalpükümakla. Ka wata yabü blamanab darrpan Umulbain Pamla. ");
INSERT INTO tof_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E darrü pam ini tüpdü yabiób abbóka koke ngilian kwarilo, zitülkus yabü blamanab wirri Ab wata kwitümase. ");
INSERT INTO tof_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yabü ta ‘Balngomól Pam’bóka koke ngiblian korale, zitülkus pamkolpam balngomól pam wata darrpan módóga, ⌊Kerriso⌋. ");
INSERT INTO tof_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yabü wirri pam nótóke, wa pamkolpamabkü leba zaget olom yarile. ");
INSERT INTO tof_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nadü oloma tóba ngi kwit ainda, God oya ngi sab tüp solkomóle. Akó nadü oloma tóba ngi tüp alkomólda, God oya ngi sab kwit ine. ");
INSERT INTO tof_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka, zitülkus e Godón Balngomól Bwóban barrbün mamtae murrausdakla pamkolpamab obzek kwata. Da e yaib ta koke barrbündakla, akó e ibü kwatpükü murrausdakla, barrbünüm nidi kaindako. ");
INSERT INTO tof_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka, zitülkus e ini tüpdü akó maludü agóltagóldakla darrpanan olom amkünüm, ubi nótó bainda Godón agürüm yabiób gyagüpitótók ngarkwatódó. E sab oya amkoman satanian olomóm inane; oya kolae tonarr ta sab wirrian yarile yabü kolae tonarrdógab, da wa sab igósidi ⌊metat bólmyan urdü⌋ wame. ");
INSERT INTO tof_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ilküp murrbausürrün balngomól pam, sab Godón ngürsila tame yabüka! E igó umul baindakla yabiób bóktan arüng akyanóm wagó, ‘Darrü pama ne ⌊arüng alkamül-koke bóktan⌋ nóma angrinda ⌊Godón Gyabi Müótan⌋ ngidü, oya bóktanan küp babula; ene wa taia tóba bóktan alkamül. A darrü pama ne arüng alkamül-koke bóktan nóma angrinda Godón Gyabi Müótüdü ne ⌊goldko⌋, ibü ngidü, ene wa tóba bóktan kokean alkamüle.’ ");
INSERT INTO tof_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ilküp murrbausürrün gonggo pam! Wirrian ia nadü klama: ia gold, ta ia Godón Gyabi Müót, gold ne klama gyabian ngitanda? Godón Gyabi Müót wirrian klama! ");
INSERT INTO tof_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","E akó igó umul baindakla wagó, ‘Darrü pama ne arüng alkamül-koke bóktan nóma angrinda ⌊altan⌋ ngidü, oya bóktanan küp babula. Ene wa taia tóba bóktan alkamül. A darrü pama ne arüng alkamül-koke bóktan nóma angrinda altadó ne ⌊gyaur klame⌋, oya ngidü, ene wa tóba bóktan kokean alkamüle.’ ");
INSERT INTO tof_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","E amkoman ilküküp murrbausürrünakla, wirrian ia nadü klama, gyaur kla, ta ia alta, gyaur kla ne klama gyabian ngitanda? Alta wirrian klama! ");
INSERT INTO tof_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ene igósidi, darrü pama arüng alkamül-koke bóktan nóma angrinda altan ngidü, wa ta altadó blaman ne gyaur klamko ibü ngidü bóktanda. ");
INSERT INTO tof_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Akó wa arüng alkamül-koke bóktan nóma angrinda Godón Gyabi Müótan ngidü, wa ta oya ngidü bóktanda, ola nótó ngyabenda. ");
INSERT INTO tof_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Akó wa arüng alkamül-koke bóktan nóma angrinda kwitüm ngidü, wa Godón kingan mórran klaman ngidü bóktanda akó oya ngidü, ola nótó mórranda. ");
INSERT INTO tof_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka, zitülkus e wa kari gida bóktan poko karrkukus amorrandakla, a e ma amkoman wirrian gida bóktan poko kuri elókane. Ini ne kari zidpókala dódórr baindako, mint, dil, akó kumin, e ⌊wantent⌋ Godón ekyenane, tóba gida ngarkwatódó. Ini kari gida bóktan poko mamoan taia, a e ma ngibürr wirri gida bóktan poko koke ki elókane, igó wa: pamkolpam ⌊dümdüm tonarre⌋ akó gyauri ngabkan, akó ma ne poko bóktóna tónggapono. ");
INSERT INTO tof_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ilküp murrbausürrün balngomól pam, e büz kuri irrunane anón naedógab, a e ma ⌊kamel⌋ kuri idarükane! ");
INSERT INTO tof_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka, zitülkus e yabiób kübül wata tumum poko bagul umulakla, a ibü auma kugupi ama kari tómanpükü kokeako. Yabü moboküp kolae tonarre murrbausürrünako: a e wata yabióban gyagüpi bomandakla akó yabü ubi wata abün elklaza do bainüma! ");
INSERT INTO tof_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ilküp murrbausürrün Parrisi, ngaen-gógópan kübül kugupi ugó nugulam; tumum ta kubó igósidi ⌊tóman-koke⌋ yarile. ");
INSERT INTO tof_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka, zitülkus e wa inzanakla, wamaka morroal püti airrün gapókako. Ngabkande wa morroalako, a ibü auma kugupidü, büdül pamkolpamab kus akó abürrün büdül büb barümürrünako. ");
INSERT INTO tof_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ene dadan ngarkwatódó, pamkolpamab ilküpdü e dümdüm ngyaben pamakla, a yabü auma büb kugupidü, e wata Godón taepurrane ngilian pamakla, akó kolae tonarr kari ta kokea yabüka. ");
INSERT INTO tof_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Mosesón gida umulbain pam akó Parrisi: e taepurrane bóktan pamakla! Sab Godón ngürsila tame yabüka. E prropetab gapók tómbapóndakla morroal obzeksyók bapónóm, prropet ngaen ne gapókdó urrbulürr, akó e ngibürr dümdüm ngyaben pamkolpamab gapók ta püti baindakla ibü gyagüpi amanóm. ");
INSERT INTO tof_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E wa igó bóktandakla wagó, ‘Mi ne asi nóma ki kwarila mibiób abalbobatalab tonarrdó, mi ibü koke ki tang nólenóp ene prropet akrranóm.’ ");
INSERT INTO tof_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Da inzan bóktande, e wa yabiób kuri pupo tübinane wagó: prropet nidi okrralórr, e ibü bobatalakla. ");
INSERT INTO tof_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Da taia, akó pokodó ugó ipüdam, yabü abalbobatala ne kla ngangólóp! ");
INSERT INTO tof_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","E gwarakla akó gwarab kupoakla! E wa sab metat bólmyan urdügab ia kyab kórzinane, God yabü ola nóma zirrnapórre yabiób kolae tonarranme? ");
INSERT INTO tof_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","We zitülkusdü, ka yabü igó poko byaldóla, ka sab yabüka prropet, ⌊wirri gyagüpitótók⌋ pam, akó umulbain pam zirrtapónónómo. E sab ngibürr büdülümpükü okrralo, ngibürr krrosdó omelolo, ngibürr e sab Zu pamkolpamab kwóbbazen müótüdü karrkukus sye-i ola nyólnane, ngibürr e ma sab basirr-basirrdüma kolabütan kwarilo. ");
INSERT INTO tof_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Inzan tórrmen tómbapónde, dümdüm ngyaben pamab óea ne tópkónóp, ene sab yabü müp yarile, tai Eibolón óedógab, dümdüm nótó ngyaben yarilürr, kókó Zekarraean óea ne tópkanórr, Berrekayan olom. E oya ⌊Gyabi Bwób⌋ akó alta, ibü dadamüz emkólarre. ");
INSERT INTO tof_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ka yabü amkoman poko byaldóla: blaman ene müpa sab ini lüólan pamkolpamdó togobe! ");
INSERT INTO tof_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Zerrusalem, Zerrusalem! Ma prropet büdülümpükü akrrandóla, akó God tóba ne bóktan amarru pam zirrbapónda, ibü ta ma ingülküpi akrrandóla. Ia nigó münüm kürü wirri ubi yarilürr marü pamkolpam kwób asum darrpan pokodó, aip karrakarra póyaea tóba kupozan kwób asudo, da tape ngablaodo. A ma ubi koke namülnürrü, ka ene poko koke ki tólaela! ");
INSERT INTO tof_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Turrkrru, marü müót sab yuógan amgatórrón yarile. ");
INSERT INTO tof_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Zitülkus módóga, ka marü igó ayaldóla, ma sab myamem kürü kokean kóseno, kókó ma sab igó bóktono wagó, ‘Wa bles airrüna, Lodón ngidü nótó tótókda.’” ");
INSERT INTO tof_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu Godón Gyabi Müótüdügabi tubrranórr, da nóma wamlórrma, umulbain olmala oyaka togobórr oya Godón blaman ene müót akó umul ainüm. Oyabóka wagó, “Ma ini morroal wirri müót ngankónónóm!” ");
INSERT INTO tof_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu bóktan yalkomólórr wagó, “E ini kla tai kuri nósenane? Ka yabü amkoman poko byaldóla: sab darrü ingülküpa aini kokean bamine tóba pabodó. Blaman sab amarrón kwarile ama tüpdü.” ");
INSERT INTO tof_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yesu ⌊Olib Pododó⌋ nóma mórran yarilürr, oya umulbain olmala tibi-tibi pokodó oya ola agotóp. Oyabóka wagó, “Ma kibü tüzazilnüm ini klama sab nóma tómbapórre. Akó ki sab ia umul bairre igó, marü alkomól tonarra minggüpanan kuri tübine akó ini ngyaben wata kuri blakóne?” ");
INSERT INTO tof_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu ibüka bóktan yalkomólórr wagó, “E umul-umul kwarilün, sab darrü olom ok ain-gu yabü ilklió büliónüm. ");
INSERT INTO tof_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Zitülkus módóga, abüna sab kürü ngidü togoble igó bóktankü wagó, ‘Ka módógla, ⌊Kerriso⌋.’ I sab abün pamkolpam ilklió nüliónórre ibü amkoman bangunüm. ");
INSERT INTO tof_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","E sab barrkrrulo wagó, bwób-bwóba tibiób bókrrandako akó ngibürr bóktan gazirrankwata. Da ene pokodó arrkürrgu! Ini klama sab ki tólbaelnóm, Godón tóba bóktan ngarkwatódó, a tüpan blakón tonarr wa küsila. ");
INSERT INTO tof_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Darrü kantrri pamkolpama sab darrü kantrri pamkolpampükü bókrrale. Darrü kingan gazirr pama sab darrü kingan gazirr pampükü gazirr kwarile. Sab wirri ku kwarile akó bwób-bwób sab tüpa mórrbaeng yarile. ");
INSERT INTO tof_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Blaman ini elklaza sab inzan kwarile, wamaka kola ngaen-gógópan azid nóma apadódo marrna bain minggüpanan. Ene azid ngaen-gógópan karia, ama solkwat tai wirri baile. ");
INSERT INTO tof_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Yabü sab wirri pamab tangdó urrbule. Yabü sab wirri müp nüliónórre, solodó ama büdüldü urrbule. Blaman ini tüpdü pamkolpama sab yabü alzizi zomale, kürü ngianbókamde. ");
INSERT INTO tof_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ene tonarrdó, abün pamkolpama sab kak amórre Godón amkoman angun-gum. Pamkolpama tibiób sab alzizi boman kwarile, akó darrem-darrem pupo bainórre wirri ngi pamdó. ");
INSERT INTO tof_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Akó sab abün obae prropeta togoble, da i sab abün pamkolpam ilklió nüliónórre ibü bóktan amkoman angunüm. ");
INSERT INTO tof_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ene tonarr, kolaea sab tai wirri baile ini tüpdü. Ini zitülkusdü abün pamkolpamab moboküpdü sab gyaur burrul babulan yarile gódamdó. ");
INSERT INTO tof_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kürü amkoman angunüm karrkukus nótó zamngólda kókó blakón tonarrdó, God sab oya zid ine. ");
INSERT INTO tof_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ini Morroal Bóktan Godón Kingzan Balngomólankwata, sab bwób-bwób akó basirr-basirr amgol kwarile, blaman pamkolpam umul-umulan ngibtanóm. Solodó, dómdóm ngürr ugón semrróne. ");
INSERT INTO tof_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Prropet Danielzan bóktanórr, e sab ngazirr kla esenane Godón Gyabi Müótüdü, gyabian pokodó zamngólórrón. Ene ngazirr klama sab ene Gyabi Müót amkoman ⌊tómanan⌋ ngitine Godón ilküpdü.” (Atang olom nótóke, wa ini bóktanan küp tai ki emzyat!) ");
INSERT INTO tof_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Ini klama sab nóma tómbapóne, Zudiam nidipako, sab podopükü bwóbdü ki busunüm. ");
INSERT INTO tof_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mórrkakak kwitüm ne olome, wa koke ki abi darrü kla apadóm. A wa büsai ki buso tóba zid bainüm. ");
INSERT INTO tof_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ngaon bwóbdü ne olome, koke ki alkomól tóba müótüdü, tumum mórrkenyórr apadóm. A wa büsai ki buso. ");
INSERT INTO tof_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sab kari kolae koke yarile ene ngürrdü bikómpükü akó ngómrin kolabkü! ");
INSERT INTO tof_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","E inzan tóre bako kwarilün Godka wagó, ‘Ini buso tupsoa koke ki tómbapó güb melpaldó ó ⌊Sabad⌋ ngürrdü.’ ");
INSERT INTO tof_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Zitülkus módóga, ene müp sab kari kolae koke kwarile, pamkolpama ne kla koke kuri azid aengóp, ngaen, ini tüpan zitüldügab, kókó errkya. Myamem akó inzan kla babul yarile. ");
INSERT INTO tof_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","God ene kolae ngürrab ngarkwat sab tugup tünggürre. Wa ne koke nóma ki tugup tünggürre, darrü oloma kokean ki zid baine. Tóba alearrón pamkolpamab gyaurdügab, wa ene kolae ngürr sab igósidi tugup tünggürre. ");
INSERT INTO tof_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Darrü oloma ne yabüka igó nóma bóktóne wagó, ‘Ngakónam, ene Kerriso yóni!’ ó ‘Ngakónam, ene Kerriso módóga!’ oya bóktan amkoman angun-gu. ");
INSERT INTO tof_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Zitülkus módóga, obae kerriso akó obae prropeta sab togoble. I sab wirrian tulmil akó ⌊basen-koke tórrmen⌋ tómbapón kwarile pamkolpam ilklió büliónüm kle-kle kwatódó tótókóm. I ta Godón alearrón pamkolpam ilklió büliónüm kain kwarile. ");
INSERT INTO tof_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Da módóga, yabü gyagüpdü ki yarilün, ka yabüka ngaen-gógópan ne bóktan kuri pupo ninünüma! ");
INSERT INTO tof_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Da yabü pamkolpama ne kürükwata igó nóma nyalnórre igó, ‘Yazilam, wa módógase ⌊ngüin-koke bwóbdü⌋!’ - e ola tótókgu; ó yabü ne igó nóma nyalnórre igó, ‘Ngakónam, wa yóni, müót kugupidü!’ - da e ibü amkoman angun-gu. ");
INSERT INTO tof_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Zitülkus módóga, ka, Pamkolpamab Olom nótókla, ka sab inzan ngarkwatódó tolkomolo, wamaka aona warri sapóne pülpüldügab, abüsa nólgabi banikda kókó abüsa nóla bótaoda: blaman pamkolpama sab kürü kóserre. ");
INSERT INTO tof_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Da ene ta inzana; büdül büb nega, kekek póyaea ola kwób bazendako. ");
INSERT INTO tof_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Dümdüman ene müp tonarr kakóm, abüsa sab tümünüm baine. Melpalan ta sab zyón myamem babul yarile. Wimurra sab pülpüldügabi tóbalókle, akó pülpüldü ne arüng klamko, i sab mórrbaengóm bairre akó i tibiób pabo sab bimgütórre. ");
INSERT INTO tof_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Darrü tórrmen tulmil sab pülpüldü eserre igó poko umul bainüm wagó, ‘Pamkolpamab Olom mamka!’ Blaman basirr-basirr bwób-bwób pamkolpama sab yón gyaur kwarile, kürü nóma kóserre tótókde pülpül kwitüm, kólba arüng akó wirrian kómal zyónpükü. ");
INSERT INTO tof_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Wirri arüng mobolzan klaman bóktana nóma sidórüke, ka sab kólba anerru zirrtapónónómo blaman bwób-bwób ini tüpdü, solomamtaedó, bolmüótüdü, malubarrdó, akó dorrmetódó, Godón alearrón pamkolpam darrpan pokodó dakasum. ");
INSERT INTO tof_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kya pig nugupa yabü kóbó ki umul ninünüm alap-alap bóktane. Oya il tiza óe-óe akó saul nóma bairre, akó küsil pórngaea bamgolóm nóma bairre, da e umul kwarilo wagó: pail minggüpanana. ");
INSERT INTO tof_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Da ene ta inzana, e ini blaman basen-koke elklaza tómbapónde nóma nósenane, e sab umul kwarilo wagó: Ka, Pamkolpamab Olom nótókla, alkomól kari pokola, ka kuri tama kókó mamtaedómla. ");
INSERT INTO tof_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka yabü amkoman poko byaldóla: ini lüólan pamkolpama sab kokean nurrbarine, kókó ini blaman elklaza sab tómbapórre. ");
INSERT INTO tof_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tüp a pülpüla sab bamrüki, a kürü ne bóktane sab kokean bamrüke. ");
INSERT INTO tof_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Darrü olom umul babula ene ngürr a abüs küp ngarkwat nóma semrróne. Kwitüm anerru ta umul kokeako. Akó ka, Aban Olom nótókla, ta umul-kókla. Wata Ab umul tebease. ");
INSERT INTO tof_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Enezan yarilürr Noan tonarrdó, da enta sab inzan yarile Pamkolpamab Oloman alkomól ngürrdü. ");
INSERT INTO tof_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Dómdóm ne ngürr kwarilürr wirri naiz naea tótókóm, pamkolpama alo akó anón kwarilürr, kol a pam bumióg kwarilürr, kókó tai ene ngürrdü, Noa tóba wirri butüdü nóma bangrinürr. ");
INSERT INTO tof_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pamkolpama kokean umul bainóp laróga tómbapón yarilürr, kókó ene wirri naiza nóma tamórr. Ibü blaman imarrurr. Sab dadanzan yarile, pamkolpama sab popa ngyaben kwarile bobarrzan, ka, Pamkolpamab Olom nótókla, nóma tolkomolo. ");
INSERT INTO tof_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nis pam nisa sab ngaon bwóbdü zaget namüli. Darrü sab sipüde, a darrü ma ola amgüte. ");
INSERT INTO tof_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nis kol nisa sab ⌊wit⌋ küp zaze amgün namüli plaoa tómbapónóm. Darrü sab tupude, a darrü ma ola zumgute. ");
INSERT INTO tof_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Da e ta azil kwarilün, zitülkus e umul-kókakla yabü Lod sab nadü ngürr tolkomóle. ");
INSERT INTO tof_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Da e ini poko tai umul koralo: müót olom ne umul nóma ki yaril igó, gómól pama nadü abüs küpdü tame, wa igósidi aerr ki yaril, ene gómól pama müót amken-gum. ");
INSERT INTO tof_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Da e ta metat inzan wazilülün, zitülkus ka, Pamkolpamab Olom nótókla, sab ene ngürrdü tamo, e koke ne ngürr akyandakla. ");
INSERT INTO tof_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ngambangól akó ⌊wirri gyagüpitótók⌋ leba zaget pam nótóke, oya wirri pama sab oya ingrine tóba müótan leba zaget kolpam balngomólóm akó ibü alo kla aliónüm dümdüm abüs küp ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sab kari morroal koke yarile ene leba zaget pamankü, sab wirri pama nóma tolkomóle, da ini zaget tómbapónde semrróne. ");
INSERT INTO tof_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ka yabü amkoman poko byaldóla: wirri pama sab oya tóba blaman elklaza ngabkanóm ingrine. ");
INSERT INTO tof_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","A kolae leba zaget pam nótóke, wa sab tóbaka wagó, ‘Kürü wirri pama irrbaindase alkomólóm.’ ");
INSERT INTO tof_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Da wa tóba zaget kamdal akrranóm ugón baine, akó alo a ngyepam anón yarile ngyepam anónan pampükü. ");
INSERT INTO tof_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Da módóga, sab ene leba zaget paman wirri pama igó ngürrdü tolkomóle, wa oya koke ne ngürr akyanda, akó we abüs küpdü, wa umul-kók ne abüs küpe. ");
INSERT INTO tof_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Oya sab we amige, wirrianbóka emkóle, akó taepurrane bóktan pampükü ingrine. I sab ola yón gyaur akó zirrgüp bótak kwarile. ");
INSERT INTO tof_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ene ngürr, Godón Kingzan Balngomól sab inzan yarile. Darrü ngürr 10 ngul olmala tibiób zyón kla yazebóp, da kol nótó ki zumige, oya akyanóm ogobórr. ");
INSERT INTO tof_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ibükagab 5, wa amkoman morroal gyagüpitótók ngul olmal kwarilürr; ngibürr 5, ibü gyagüpitótók tugupurr koralórr. ");
INSERT INTO tof_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ene tugupurr gyagüpitótók ngul olmala tibiób zyón kla yazebóp, a oel sokol ma koke yazebóp. ");
INSERT INTO tof_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A ⌊wirri gyagüpitótók⌋ ngul olmal nidi kwarilürr, i tibiób dudu oel bele yazebóp zyón klampükü. ");
INSERT INTO tof_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kol nótó ki zumige büsai koke tübzilürr, da ene ngul olmal blaman genggorrama we yazebórr, utapükü tübarrümürr. ");
INSERT INTO tof_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Da irrüb zokrrok, ene pokodó wirri taegwarr yarilürr wagó, ‘Ngakónam! Kol ne pama ki zumige tótókda. Oya akyanóm ugó ogob!’ ");
INSERT INTO tof_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ene 10 ngul olmal, i blamana tübarsinürr, tibiób zyón kla wiki tómbapónóp morroal bólmyanóm. ");
INSERT INTO tof_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ene tugupurr gyagüpitótók ngul olmala ene wirri gyagüpitótók ngul olmalbóka wagó, ‘Kibü yabióbnüm oeldógab sokol tülinam, zitülkus kibü zyón klama bütamündasko.’ ");
INSERT INTO tof_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","A ene wirri gyagüpitótók ngul olmala ibübóka wagó, ‘Mibü blamanabkü gaodó kokea. Da e ugó ogob ene pamdó, oel nibióbkagab bumiógdako, yabióbkü oel bumiógüm.’ ");
INSERT INTO tof_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","I tibiób oel bumiógümzan ogoblórr, ene kol nótó ki zumige ugón tübzilürr. Oel nibiób kwarilürr, i we ogobórr ene pampükü oya tóre bwóbdü. Da mamtaea we murrbausürr. ");
INSERT INTO tof_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ene kakóm, ene tugupurr gyagüpitótók ngul olmala we tóbakonórr, da we górrgónóp wagó, ‘Wirri pam, wirri pam, gyaurka, kya mamtae tapaku kibünkü!’ ");
INSERT INTO tof_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Wa ibüka bóktan igó yalkomólórr wagó, ‘Koke! Ka yabü amkoman poko byaldóla: ka yabübóka umul-kókanla.’ ");
INSERT INTO tof_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Da e ta azil kwarilün, zitülkus e umul-kókakla ngürr akó abüs küp ngarkwat, Pamkolpamab Oloma sab nóma tolkomóle. ");
INSERT INTO tof_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ene ngürr, Godón Kingzan Balngomól sab inzan yarile. Darrü pama aibwób basirrdü wamlórrma. Wa tóba leba zaget pam darrpan pokodó ngibaunürr. Ibübóka wagó, ‘Ka kólba elklaza yabü tangdó arrbündóla.’ ");
INSERT INTO tof_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Wa tóba leba zaget pam tibiób susumüri ngarkwatódó mani nülinóp akó mani tónggapónóm. Darrü wa 5 mani alóp iliónürr, manie murrbausürrün, darrü wa nis, darrü wa darrpan ekyanórr, ene mani küp dódórr ainüm. Da wa we bupadórr darrü basirrdü tótókóm. ");
INSERT INTO tof_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wa 5 mani alóp ne zaget pam iliónürr, wa dümdüman ene mani zagetan ngitanórr akó mani tómbapónóm. Wa akó 5 mani alóp we tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wa nis mani alóp noan ekyanórr, wa dümdüman dadanzan yangónórr. Wa akó nis we tónzapónórr. ");
INSERT INTO tof_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wa darrpan noan ekyanórr, wa gumzan yarilürr, da wamórr, tüp kugupi ilüngürr, tóba wirri paman mani ola inikürr. ");
INSERT INTO tof_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ibü wirri pama wirri kokrrap nóma ngyabenórr darrü basirrdü, wa akó we tolkomólórr. Wa tóba darrpan-darrpan zaget pampükü mórran-mórran bainürr umul bainüm, oya mania ia zaget koralórr. ");
INSERT INTO tof_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","5 Mani alóp nótó yazebórr, tamórra, oyaka akó ngibürr 5 simarrurr. Oyabóka wagó, ‘Wirri pam, ma kürü 5 mani alóp kliórrü. Ngaka, ka ene 5 mani alóp zagetan nóma ngibtarró, ka akó ngibürr 5 murrnausnarre.’ ");
INSERT INTO tof_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Oya wirri pama bóktan we yalkomólórr wagó, ‘Ma morroal tónggapóna, morroal zaget akó ngambangól zaget pam! Zitülkus ma ngambangól zaget pamla kari-kari elklazadó, da ka sab marü wirri elklaza mülino ngabkanóm. Da yao, ugó tübangri, kürü ene barnginwómpükü ngyaben pokodó.’ ");
INSERT INTO tof_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Da nis mani alóp nótó nüpadórr, tamórra, oyabóka wagó, ‘Wirri pam, ma kürü nis mani alóp kókyarró. Ngaka, ka ene nis mani alóp nóma zagetan ngintarró, ka akó nis tólnaelórró.’ ");
INSERT INTO tof_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Oya wirri pama bóktan we yalkomólórr wagó, ‘Ma morroal tónggapóna, morroal zaget akó ngambangól zaget pam! Zitülkus ma ngambangól zaget pamla kari-kari elklazadó, da ka sab marü wirri elklaza mülino ngabkanóm. Da yao, ugó tübangri, kürü ene barnginwómpükü ngyaben pokodó.’ ");
INSERT INTO tof_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Darrpan mani alóp nótó ipadórr, tamórra, oyabóka wagó, ‘Wirri pam, ka umulóla ma kari karrkukus pam ta kokela. Didiburrdü kla mató abüldóla, ma koke nóla barit namülnürrü, akó mató kwób asudóla, ma küp koke ne amarró. ");
INSERT INTO tof_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Da ka gum namülnürrü, da marü mani ka tüp kugupidü kolakyarró. Ngaka, marü ene mani ikwóni.’ ");
INSERT INTO tof_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Oya wirri pama bóktan we yalkomólórr wagó, ‘Ma kolae zógósan leba zaget olomla! Ma ia igó poko umulóla igó, didiburrdü kla kótó abüldóla, ka koke nóla barit namülnürrü, akó kótó kwób asudóla, ka küp koke ne amarró? ");
INSERT INTO tof_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ma ta kürü mani igósidi mani müótüdü ki ingrina; ka nóma ki tolkomóla, ka kólba mani ki ipüda akó mani müóta kürü manian zaget darrem ki kókyene. ");
INSERT INTO tof_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ene mani oyakagab irrkinam ama oya ekyenam, 10 mani alóp noanko! ");
INSERT INTO tof_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Zitülkus módóga, noanko, sab akó oya ene tumum ngibürr iline. Oya sab igósidi ngaru bapón-koke kwarile. A babul noanko, oyakagab sab irrkine, oya kari-kari ne klame. ");
INSERT INTO tof_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ene küp-koke zaget pam tümün kwatódó amanikam! Wa sab ola yón gyaur akó zirrgüp bótak yarile.’ ");
INSERT INTO tof_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ka, Pamkolpamab Olom nótókla, sab Kinga nóma tamo kólba ⌊wirri kómal zyónpükü⌋ akó kólba blaman anerrupükü, ka kólba ene zyónan kingan mórran kla mórran-mórran baino. ");
INSERT INTO tof_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ini tüpdü blaman pamkolpama sab kürüka kwób tóbazele. Ka sab nis kwób nangono, ⌊sip⌋ ngabkan pama sipzan amanda ⌊goutüdügab⌋. ");
INSERT INTO tof_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ka sab sip kólba tutul kwata irrbuno, a gout ka sab kólba banól kwata irrbuno. ");
INSERT INTO tof_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ka küób Kingan arüngdügab sab igó bóktono kürü tutul kwata ne pamkolpamko kagó, ‘Yao, yabü kürü Aba kuri bles nirre! Balngomól Bwóbdü ugó barrbü, God yabünkü ne kla tólaelórr, ini tüp ugón tónggapónóm nóma yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Zitülkus módóga, ka alom nóma namülnürrü, kürü yadi ngakinóp; naem nóma namülnürrü, kürü anónóm yadi kókyenóp. Ka mogob nóma namülnürrü, kürü yabiób müótüdü yadi küngrinóp. ");
INSERT INTO tof_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka mórrkenyórr-koke nóma namülnürrü, kürü mórrkenyórr yadi kómelóp. Ka azid nóma namülnürrü, kürü yadi almil kwarilnürrü, akó tümün müótüdü nóma namülnürrü, kürü yadi angónóm ogobnórró.’ ");
INSERT INTO tof_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Godón ilküpdü dümdüm nidipko, kürüka sab bóktan salkomólórre wagó, ‘Lod, ki wa marü nóma mósenóp, ma alom nóma namülnürrü, da marü ngaminóp, akó ki wa marü nóma mósenóp, ma naem nóma namülnürrü, da marü anónóm mókyenóp? ");
INSERT INTO tof_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ki wa marü nóma mósenóp, ma mogob nóma namülnürrü, da ki marü müótüdü müngrinóp? Ki wa marü akó mórrkenyórr-koke nóma mósenóp, da marü mórrkenyórr mómelóp? ");
INSERT INTO tof_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ki wa marü nóma mósenóp azid, akó ma tümün müótüdü nóma namülnürrü, da ki marü angónóm ogobnórró?’ ");
INSERT INTO tof_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Da ka sab ibüka bóktan yalkomolo kagó, ‘Ka yabü amkoman poko byaldóla: e wa kürü amkoman angun kari zoretódó nóma tónggapónarre, da ene igósidi inzana, e wa ene amkoman kürüka tólaelarre.’ ");
INSERT INTO tof_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Da ka sab ibüka bóktono, kürü banól kwata nidipko, kagó, ‘Kürükagabi usi ogob! E amórrórrónakla. Da ⌊metat bólmyan urdü⌋ ugó bamsel, God ne ur setanórr ⌊debólankü⌋ tóba kolae anerrupükü. ");
INSERT INTO tof_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Zitülkus módóga, ka alom nóma namülnürrü, e kürü koke ngakinarre; ka naem nóma namülnürrü, e kürü anónóm koke kókyenarre. ");
INSERT INTO tof_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka mogob nóma namülnürrü, e kürü yabiób müótüdü koke küngrinarre. Mórrkenyórr-koke nóma namülnürrü, e kürü mórrkenyórr koke kómelarre. Ka azid akó tümün müótüdü nóma namülnürrü, e kürü angónóm koke ogobnórró.’ ");
INSERT INTO tof_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Da i sab bóktan salkomólórre wagó, ‘Lod, ki wa marü nóma mósenóp, ma naem a alom akó mogob nóma namülnürrü? Ki wa marü nóma mósenóp mórrkenyórr-koke akó azid a tümün müótüdü, da marü koke tangmamtinóp?’ ");
INSERT INTO tof_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Da ka sab ibüka bóktan yalkomolo wagó, ‘Ka yabü amkoman poko byaldóla: e wa kürü amkoman angun kari zoretódó koke nóma tónggapónarre, da ene igósidi inzana, e wa ene amkoman kürüka ta koke tólaelarre.’ ");
INSERT INTO tof_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ene nidipko, i sab metat bólmyan urdü ogobe. Dümdüm ngyaben nidipko, i sab ⌊ngarkwat-koke⌋ arróldó ogobe.” ");
INSERT INTO tof_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesun blaman umulbain bóktana nóma blakónórr, tóba umulbain olmalbóka wagó, ");
INSERT INTO tof_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“E umulakla, nis ngürr kakóm sab ⌊Büdül Kórzyón Tórease⌋. I kürü, Pamkolpamab Olom nótókla, sab wirri ngi pamab tangdó ugón küngrirre krrosdó amngyelóm.” ");
INSERT INTO tof_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Wirri prrist akó Zu pamkolpamab ⌊balngomól byarrmarr pama⌋ darrpan pokodó kwób bazenórr Kayapasón wirrian müótüdü. Wa tüób singüldü prrist yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","I bóktan we tónggapón kwarilürr Yesun piküpan amiógüm akó büdülümpükü amkalóm. ");
INSERT INTO tof_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tibióbbóka wagó, “Mi ini poko tóre tonarrdó koke tónggapórre, zitülkus pamkolpama sab mibüka ngürsilüm kena bainünüm.” ");
INSERT INTO tof_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu ugón Saemonón müótüdü yarilürr Betani basirrdü. Saemon tüób ngaen soso azid pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Yesu nóma alo yarilürr, darrü kola ugón katókórr. Wa darrü wirri darrem ingülküpi tónggapórrón bele sidódürr, morroal ilang idipükü. Kari darrem idi koke yarilürr. Ene kola ene idi Yesun singüldü we ekanórr, wazan alom nólgópe banomólórr. ");
INSERT INTO tof_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oya umulbain olmala nóma osenóp, ibü ngürsila yazebórr, da i darrpan-darrpan we bóktan kwarilürr wagó, “Wa ia laró zitülkusdü popa akando ini morroal ilang idi? ");
INSERT INTO tof_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ini idi ne nóma ki sel irre wirri darrem klamóm, da ene mani küp ama elklaza-koke kolpam ki nülirre!” ");
INSERT INTO tof_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu umul yarilürr, i laró poko bóktan kwarilürr, da wa ibübóka wagó, “Oya olkomólam! E oya larógóm müp akyandakla? Wa amkoman morroal tonarr tónggapóne kürüka. ");
INSERT INTO tof_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Zitülkus módóga, elklaza-koke kolpam sab yabüka metat ae kwarile. A ka wa sab yabüka metat ae koke namulo. ");
INSERT INTO tof_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wa ene morroal ilang idi kürü bübdü igósidi ekóne, zitülkus wa kürü büb morroal ine gapókdó angrin ngarkwat sab nóma semrróne. ");
INSERT INTO tof_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da ka yabü amkoman poko byaldóla: sab kürükwata ini Morroal Bóktan nótó amgol yarile ini tüpdü, wa ta sab ini poko adrrüte, ini kola ne poko tónggapóne. Pamkolpama sab oya igósidi gyagüpi zumaniknórre.” ");
INSERT INTO tof_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Da módóga, Zudas Iskarriot, darrü Yesun 12 umulbain olmaldógab, we wamórr wirri prristdü. ");
INSERT INTO tof_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ibübóka wagó, “E kürü sab darrem laró kókyenane, ka ne Yesun yabü nóma nókyenónómo?” I oya darrem 30 silba mani küp ilinóp. ");
INSERT INTO tof_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ene kakóm, Zudas kwat we yamkülürr Yesun ibü tangdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngaen-gógópan ⌊Ist-koke Brred Tóre⌋ ngürrdü, umulbain olmala Yesuka togobórr. Oyabóka wagó, “Marü ubi, ki nubó ogobo alo kla tómbapónóm marünkü Büdül Kórzyón Tóre alo alom?” ");
INSERT INTO tof_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu tóba umulbain olmal we zirrnapónóp, igó bóktanpükü wagó, “Ugó barrbün Zerrusalem wirri basirrdü, da e kubó ola ene pamdó ogobke, e umul noabókamakla. Kubó oya ilamke magó, ‘Umulbain Pama igó yaril wagó, “Kürü abüs küp ngarkwat kuri semrróne. Ka kólba umulbain olmalpükü kubó Büdül Kórzyón Tóre alo marü müótüdü elo-o.” ’” ");
INSERT INTO tof_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu tóba umulbain olmalzan nilóp, i elklaza we tómbapónóp Büdül Kórzyón Tóre alongaloankü. ");
INSERT INTO tof_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Irrübazan tumziklürr, Yesu tóba 12 umulbain olmalpükü alom nólgópe banomólórr. ");
INSERT INTO tof_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","I nóma alo kwarilürr, Yesu ibüka we bóktanórr wagó, “Ka yabü amkoman poko byaldóla: darrüpa yabükagab kalma kürü wirri pamab tangdó wató küngrine.” ");
INSERT INTO tof_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Umulbain olmala kari gyaur koke koralórr, da i darrpan-darrpana Yesun we imtinónóp wagó, “Lod, ia kótó kokela?” ");
INSERT INTO tof_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu ibüka bóktan we yalkomólórr wagó, “Tóba brred poko kankü ne nótó kuri yanggóbóle kübüldü, da kürü kalma wirri pamab tangdó wató küngrine. ");
INSERT INTO tof_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ka, Pamkolpamab Olom nótókla, sab nurrótoko, wata Godón Wibalómórrón Bóktana enezan bóktanda kürükwata. A Godón ngürsila sab tame ene olomdó, Pamkolpamab Olom wirri pamab tangdó nótó ingrine. Kari morroal koke ki yaril, ene oloma koke ki tómtómóle!” ");
INSERT INTO tof_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Zudas, Yesun sab wirri pamab tangdó nótó ingrine, wa bóktanórr wagó, “Rrabi, ia kótó kokela?” Yesu bóktan oyaka yalkomólórr wagó, “Ma müób kuri bóktóna.” ");
INSERT INTO tof_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","I nóma alo koralórr, Yesu dudu brred ipadórr, akó Godón eso akyan kakóm, wa syórr yangónórr. Wa tóba umulbain olmal poko nülinóp ini bóktanpükü wagó, “Ipüdam, eloam; ini kürü bübe.” ");
INSERT INTO tof_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wa akó waenpükü kübül ipadórr, akó Godón eso akyan kakóm, wa ibü nókyenóp ini bóktanpükü wagó, “Blamana ugó enónam. ");
INSERT INTO tof_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ini kürü óe-e. Wirri arüng akyanda Godón ⌊alkamül-koke tónggapórrón bóktan⌋. Sab abün pamkolpamabkü tópkóne, igósüm God sab ibü kolae tonarr norrgorre. ");
INSERT INTO tof_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka yabü igó byaldóla, ka sab ini waen myamem koke enono, kókó ene ngürrdü, ka sab yenkü küsil waen nóma enono kólba Aban Kingzan Balngomóldó.” ");
INSERT INTO tof_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Da módóga, i Godón wórr we atop. Ene kakóm, i we ogobórr ⌊Olib Pododó⌋. ");
INSERT INTO tof_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu ibübóka wagó, “Errkya ini ne irrübe, e yabiób büódan kuri ngibtinane kürüme. E kubó blamana busuane ó kürü kubó kólbanan kümgütane, zitülkus Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Ka sab ⌊sip⌋ ngabkan pam büdülümpükü sómkolo, da ene sipa sab popa barsene.’ ");
INSERT INTO tof_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","A kürü sab nóma kürsümüle büdüldügab, da ka sab wamópo yabü singül kwata Galili prrobinsdü.” ");
INSERT INTO tof_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita oyabóka wagó, “Enana i blamana kubó busurre marübókamde, ka marü kokean mimgüto!” ");
INSERT INTO tof_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu Pitaka we bóktanórr wagó, “Ka marü amkoman poko ayaldóla: siman karrakarra póyaea ini irrüb bóktan küsil yarile, da ma kalma aüd münüm kalpino igó, ma kürübóka umul-kókla.” ");
INSERT INTO tof_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita oyaka bóktan we yalkomólórr wagó, “Ka kubó igó poko kokean bóktono, ka marübóka umul-kókla. Kürü mankü nurrótók ta taia!” Akó blaman umulbain olmala ta inzan bóktan kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ene kakóm, Yesu tóba umulbain olmalpükü we wamórr darrü bwób, ngi Getsemani. Wa ibübóka wagó, “E ae bobrra, ka wezan tótókdóla tóre akom.” ");
INSERT INTO tof_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wa tóba aüd umulbain olmal yazebórr, Pita akó Zebedin nis siman olom nis, Zeims a Zon. Yesun bübdü gyaur akó müp gyagüpitótóka we togobórr. ");
INSERT INTO tof_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Da wa ibüka we bóktanórr wagó, “Kürü moboküpdü kari gyaura koke kuri tübangrine, wamaka ka büdülüm kaindóla. E ae bobrra, da dakla aerr koralón kankü.” ");
INSERT INTO tof_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wa karianbóka küór amanórr. Wa simbalkalórr, tóba obzek tüp we elkomólórr. Tóre inzan ekorr wagó, “Kürü Ab, marüka ne tai nóma yarile, kürü ini wirri azidüdüma ódódgu. A kürü ubia koke ki tómbapó, wata marü ubie.” ");
INSERT INTO tof_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yesu we tolkomólórr, ó wa tóba aüd umulbain olmal utüdi tómrrónóp. Wa Pitaka bóktanórr wagó, “E ia gaodó koke kwarila kankü aerróm darrpan abüs küp ngarkwatóm? ");
INSERT INTO tof_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","E dakla wazilülün ó dakla tóre okolón, igósüm darrü klama yabü kolae tonarr tómbapónóm koke ki nolngomólnónóm. Yabü samuan ubi asine dümdüman elklaza tómbapónóm; büban ma arüng babula.” ");
INSERT INTO tof_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu akó nis ngim we wamórr dadan pokodó tórem. Wagó, “Kürü Ab, marü ubi koke nóma yarile ini müp kürükagab apadóm, da inzan ki yarilün: ka sab azid aengo. Wata marü ubia ki tómbapó!” ");
INSERT INTO tof_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wa nis ngim nóma tolkomólórr tóba aüd umulbain olmaldó, wa akó ibü utüdi tómrrónóp, zitülkus ibü uta barüm yarilürr; tibiób ilküp kokean nomgolóp. ");
INSERT INTO tof_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wa ibü aüd ngim nóma nümgütóp tóre akom, wa akó dadan bóktan opor bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wa umulbain olmaldó nóma tolkomólórr, wa ibüka we bóktanórr wagó, “E wata ia utakla akó ngón ngabagóndakla? Ngakónam, ene abüs küp kuri semrróne. I kürü, Pamkolpamab Olom nótókla, kolae tonarr pamab tangdó angrindako. ");
INSERT INTO tof_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bazeb, mi nau! Ngakónam, ene pam módóga, kürü kubó wirri pamab tangdó nótó küngrine!” ");
INSERT INTO tof_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu tóba umulbain olmaldózan bóktan yarilürr, Zudas, darrü ene 12 umulbain olmaldógab, ugón tübzilürr wirri gazirr pam ngoropükü, tibiób gazirr turrik akó kubidampükü, Yesun amiógüm. Wirri prrist akó Zu pamkolpamab balngomól byarrmarr pama ibü zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Oya wirri pamab tangdó nótó ingrine, wa ngaen-gógópan umul ninóp wagó, “Ka ne nadü olom ipruko, da módóga, ene olom. Oya amigamke!” ");
INSERT INTO tof_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Da módóga, Zudas wata dümdüman we wamórr Yesuka. Oyabóka wagó, “Umulbain Pam, paud marüka asi ki yarilün!” Da oya we iprükürr. ");
INSERT INTO tof_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu oyabóka wagó, “Gódam, ma ne kla tónggapónóm tama, da ma tónggapó!” Da módóga, ene gazirr pama Yesun minggüpanan togobórr, da tange karrkukus we amigóp. ");
INSERT INTO tof_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Darrpan olom Yesukü nidi kwarilürr, wa tóba gazirr turrik irruanórr, da singüldü prristan ⌊leba zaget⌋ paman güblang we itülürr. ");
INSERT INTO tof_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu oyaka bóktanórr wagó, “Moba gazirr turrik tóba pokodó yalkomól! Gazirr turrik nidi amorrandako gazirrüm, ibü ta sab turriki ekrrórre. ");
INSERT INTO tof_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ma ia umul-kókla wagó, ka ne kólba Abdó nóma ki górrgóna kólba tangamtinüm, wa dümdüman abün gazirr anerru ki zirrtapórre? ");
INSERT INTO tof_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ka ne nóma ki górrgóna, da igósidi kürü büdül tonarra koke tómbapóne, Godón Wibalómórrón Bóktana enezan bóktanda wagó, ene tonarra ki tómbapó!” ");
INSERT INTO tof_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ene tonarr, Yesu ene pamkolpamab ngorodó we bóktanórr wagó, “E wa gazirr turrik a kubidampükü kürü amiógüm iade togoba, wamaka ka gazirr-gazirr gómól pamla? Blaman ngürrzan ka go yenkü mórran namülnürrü umul bainkü ⌊Godón Gyabi Müótan⌋ kal akólórrón pul basirrdü, da e ma kürü koke kümigarre. ");
INSERT INTO tof_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Da blaman ini elklaza igósidi tómbapóndako, Godón Bóktan küppükü ainüm, wa prropetódó ne poko bóktanórr wialómóm.” Da módóga, blaman umulbain olmala oya ola amgütóp, da i we busuóp. ");
INSERT INTO tof_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yesun nidi amigóp, oya we idüdóp singüldü prrist Kayapasón müótüdü. Ene pokodó, Mosesón gida umulbain pam akó balngomól byarrmarr pama we kwób bazelórr. ");
INSERT INTO tof_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Da Pita ibü solodó barrkyanan kan akyalórr, kókó tai singüldü prristan kal akólórrón pul basirrdü we bangrinürr. Wa we mórran-mórran bainürr Godón Gyabi Müót ngakan pampükü, asenóm wagó, kubó laróga tómbapóne Yesuka. ");
INSERT INTO tof_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Da müót kugupidü, wirri prrist akó blaman Zu balngomól byarrmarr pama obae bóktanan küp amkün koralórr Yesun büdülümpükü amkalóm. ");
INSERT INTO tof_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Enana abün pamkolpama obae bóktan oyakwata we büdrrat kwarilürr, i darrü küp koke esenóp. Dómdóm nis pam nisa zamngórri. ");
INSERT INTO tof_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","I bóktarri wagó, “Inipa igó bóktanórr wagó, ‘Ka gaodómla Godón Gyabi Müót algatóm akó aelóm aüd ngürr kakóm.’” ");
INSERT INTO tof_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Singüldü prrista we zamngólórr. Yesunbóka wagó, “Marü ia alkomól bóktan babula? Ini pama marükwata ne poko bóktandako?” ");
INSERT INTO tof_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Da Yesu ma piküp bain yarilürr. Singüldü prrista akó oya imtinürr wagó, “Mi ne metat ngyaben Godón ⌊ótókdakla⌋, ka marü ayaldóla oya ngidü, amkoman poko adrratóm. Kibü kóbó tüzazilnüm: ia ma ene ⌊Kerrisola⌋, Godón Olom?” ");
INSERT INTO tof_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu bóktan yalkomólórr wagó, “Mazan namüla. Da ka yabü blaman byaldóla: ini tonarrdógab e sab kürü kósenane, Pamkolpamab Olom nótókla, mórrande wirri pabodó, Wirri Arüng Godón tutul tangdó, ó pülpül pokopükü tótókde kwitüdügab!” ");
INSERT INTO tof_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ene pokodó, singüldü prrista tóba tumum mórrkenyórr we atürrürr ngürsilanme akó we bóktanórr wagó, “Wa Godón ngi kulainda! Mi myamem darrü oloman bóktan koke arrkrrurre oyakwata. E oya bóktan kuri barrkrrua: wa Godón ngi kuri kulaine! ");
INSERT INTO tof_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yabü gyagüpitótók ia negako?” Blaman ene pama bóktan yalkomólóp wagó, “Wa ngarkwatódóma büdülüm!” ");
INSERT INTO tof_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ngibürr pama oya we gwerr atóng kwarilürr obzekdó akó tibiób tang kubidame we emkalnóp. Ngibürra oya obzek tang o-e emkalnóp, ");
INSERT INTO tof_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","da oya we imtinónóp wagó, “Kerriso-e, ma ne amkoman prropet nóma namulo, ma kibüka kóbó tópta: marü ia nótó mómkóle?” ");
INSERT INTO tof_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita wata kalkuma mórran yarilürr, kal akólórrón pul basirrdü. Darrü zaget ngul oloma oyaka we katókórr. Oyabóka wagó, “Ma ta Yesukü asi namülnürrü, ene Galili olom!” ");
INSERT INTO tof_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pita we balpinürr blamanab obzek kwata wagó, “Ka umul-kókla ma wa ia laró poko bóktandóla.” ");
INSERT INTO tof_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Da wa kal akólórrón pul basirr amgatórr, ama barrbün mamtaedó wamórr. Akó darrü zaget ngul oloma Pitan ola esenórr. Ola nidi kwarilürr, ibübóka wagó, “Módóga! Ene pam Yesukü asi yarilürr, ene Nazarret olom.” ");
INSERT INTO tof_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita akó karrkukusande balpinürr wagó, “Ka amkoman ene pambóka umul-kókanla!” ");
INSERT INTO tof_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Akó wirri ngarkwat babul, ola nidi bórranglórr, Pitaka togobórr. Oyabóka wagó, “Amkoman, ma ta darrü módógla, zitülkus ma Galili olomla. Ki marü moba bóktandógab amzyatódakla.” ");
INSERT INTO tof_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Da módóga, Pita we bóktanórr wagó, “Ka yabü amkoman poko byaldóla! Kürü God ki kómórr, ka ne obae nóma namulo! Ka amkoman ene pambóka umul-kókla!” Tai ene pokoandó, karrakarra póyaea we bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Da Pita Yesun ene bóktan poko ugón gyagüpi amanikürr wagó, “Siman karrakarra póyaea bóktan küsil yarile, da ma kalma aüd münüm kalpino magó, ma kürübóka umul-kókla.” Da Pita ene müót pul basirrdügab pulkaka burruanórr, da wirribóka yónüm we bainürr. ");
INSERT INTO tof_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Irrbianande, blaman wirri prrista Zu pamkolpamab ⌊balngomól byarrmarr pampükü⌋ bóktan we ingrinóp Yesun büdülümpükü amkalóm. ");
INSERT INTO tof_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Da i Yesun sye-i amarükóp, we idüdóp, Rrom gabenan tangdó ingrinóp, ngi Paelat. ");
INSERT INTO tof_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Zudas, Yesun wirri pamab tangdó nótó ingrinürr, oya kari gyaura koke simiógürr igó nóma umul bainürr wagó, Yesun kubó emkórre büdülümpükü. Da wa ene 30 silba mani küp igósidi yakonórr wirri prrist akó balngomól byarrmarr pamdó. ");
INSERT INTO tof_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Zudas ibübóka wagó, “Ka amkoman kolaean tonarr tónggapóna! Wa amkoman darrü kolae tonarr koke tónggapónórr, da ini pam yabü tangdó kótó ingrina büdülüm!” Ene pama Zudasónbóka wagó, “Ini wa kibü müp koke-e! Ene wa marü müpe!” ");
INSERT INTO tof_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Zudas ene mani küp ⌊Godón Gyabi Müótüdü⌋ amanórr, da we wamórr, sye-i gepko byamrókórr, da büdüla we olean yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wirri prrista ene mani küp dakainóp. Da i bóktónóp wagó, “Ini amkoman gyabia inzan mani küp Godón Gyabi Müótan manipükü dayónüm, zitülkus ene Galili paman óea kubó tópkóne ini manianme.” ");
INSERT INTO tof_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Da i bóktan ingrinóp, ene manie darrü paman tüp poko amiógüm, mariti alongalo elklaza nótó tólbael yarilürr. Ene tüp poko mogob pamab gapók balüng bwób ki yaril. ");
INSERT INTO tof_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","We zitülkusdü, ene tüp poko ngi we ngyesilóp “Óepükü Tüp Poko,” akó errkya wata ngiliandako. ");
INSERT INTO tof_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ngaen prropeta Zerremaeazan bóktanórr, küppükü bainürr, wagó, “I ene mani küp yazebóp, Isrrael pamkolpama ne ngarkwat ingrinóp oya büb amiógüm. ");
INSERT INTO tof_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ene manie darrü oloman tüp poko we amigóp, alongalo elklaza mariti nótó tómbapón yarilürr, kürü Lod iazan kyalórr.” ");
INSERT INTO tof_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesu Paelatón obzek kwata zamngólórr, Rrom gabena ugón wató yarilürr. Oya imtinürr wagó, “Ia ma Zu pamkolpamab king módógla?” Yesu oyaka bóktan we yalkomólórr wagó, “Ma kuri bóktóna.” ");
INSERT INTO tof_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wirri prrist akó balngomól byarrmarr pama Paelatka Yesun kotóm ain bóktan nóma aman kwarilürr, Yesu myamem bóktan koke yalkomólórr. ");
INSERT INTO tof_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Da Paelat oyabóka wagó, “Ia ma arrkrrudóla, marü blaman ne kotóm ain bóktan amandako?” ");
INSERT INTO tof_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu myamem bóktan koke yalkomólórr, da Paelat igósidi abün-abün gyagüpitótók yazebórr. ");
INSERT INTO tof_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Blaman pailzan ⌊Büdül Kórzyón Tóredó⌋, Rrom gabena darrpan pam tümün müótüdügab irrualórr pamkolpamab ubi ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ene ngürrdü, darrü umulürrün kolae pam asi yarilürr tümün müótüdü, oya ngi Barrabas. ");
INSERT INTO tof_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pamkolpama darrpan pokodó nóma kwób bazenórr, Paelat ibü nümtinóp wagó, “Yabü ubi iada: ia ka nadü pam irruno tümün müótüdügab? Barrabas, ta ia Yesu, ⌊Kerrisobóka⌋ noan ngiliandako?” ");
INSERT INTO tof_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wa umul yarilürr igó, wirri prrista Yesun igósidi ekyenóp, zitülkus ibü gyagüp kolaea ekrranórr, zitülkus abün pamkolpama Yesuka atan kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paelat tóba zazan mórran klamdózan mórran yarilürr, oya kola bóktan zirrapónórr wagó, “Ene kolae tónggapón-koke pam elkomól! Ini irrüb kürü nusdü ka kari müpdü ta koke namüla oyabókamde.” ");
INSERT INTO tof_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Da wirri prrist akó balngomól byarrmarr pama, pamkolpam gyagüpitótók we nókyenóp Paelatón atom Barrabasón tümün müótüdügab arruanóm akó Yesun büdülümpükü amkalóm. ");
INSERT INTO tof_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Paelat pamkolpam nümtinóp wagó, “Ini nis pam nisdügabi, ka tümün müótüdügab nadü pam irruno yabünkü?” I bóktan yalkomólóp wagó, “Barrabas!” ");
INSERT INTO tof_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paelat akó pamkolpam we nümtinóp wagó, “Ia ka dama Yesun ia yangono, Kerrisobóka noan ngiliandako?” I blamana bóktan yalkomólóp wagó, “Oya krrosdó emngyelam!” ");
INSERT INTO tof_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Paelat ibü nümtinóp wagó, “Iade? Wa ia tai laró kolae tónggapónórr?” Da pamkolpama wata wirri taegwarróm we inóp wagó, “Krrosdó emngyelam!” ");
INSERT INTO tof_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Paelat nóma ngakanórr wagó, wa gaodó koke yarilürr darrü kla tónggapónóm Yesun tangamtinüm - pamkolpama gazirrüm kena bainüm - wa nae itürr, tóba tang pamkolpamab obzek kwata we bagulürr. Wa ibübóka wagó, “E ne poko tónggapóndakla, ene paman büdül müp sab kótó koke ipudo. Sab yabü müp yarile!” ");
INSERT INTO tof_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pamkolpam blamana bóktan yalkomólóp wagó, “Ene paman büdül müp sab kibüka ki yarilün akó kibü olmaldó!” ");
INSERT INTO tof_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Da Paelat Barrabasón ibünkü we irruanórr tümün müótüdügabi. Da wa gazirr pam we nilóp Yesun kus pokopükü sye-i ailüm. Olgabi wa oya ngibürr gazirr pamab tangdó we ingrinürr krrosdó amngyelóm. ");
INSERT INTO tof_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Da módóga, Paelatón gazirr pama Yesun we idüdóp gabenan wirri müótan kal akólórrón pul basirrdü. I tibiób blaman kamdal we ngibaunóp Yesun kal-kal angónóm. ");
INSERT INTO tof_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Oya tumum mórrkenyórr enólóp, ama akó óe-óe mórrkenyórr tupo ngarkwat we atenóp. ");
INSERT INTO tof_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","I akó oya singül müóngdur we elóp tórez-tórez nugup tizi, da i oya singüldü we emngyelóp. Tutul tangdó go tupuru ingrinóp. I tibiób wakósingül nümgünóp, oya we yagürnóp, amkoman moboküpi-koke, a i oya tiz yangónónóp wagó, “Ma wirri kokrrap ki ngyaben namüla, Zu pamkolpamab king!” ");
INSERT INTO tof_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Da i oya akó gwerr we atóngnóp akó tupuru oya tangdó kla ipüdóp, da singül we emkalnóp. ");
INSERT INTO tof_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ibü nóma blakónórr oya tizangóna, da i oya ene óe-óe mórrkenyórr we ininóp, ama akó tóba mórrkenyórr oya we amelóp. Da i oya we idüdóp krrosdó amngyelóm. ");
INSERT INTO tof_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I nóma bauslürr Zerrusalem wirri basirrdügab, i darrü Saerrin wirri basirr pam we emrrónóp, ngi Saemon, da gazirr pama oya arüng-arüng we zirrapónóp Yesun krros bügasilüm. ");
INSERT INTO tof_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Solodó, i darrü pokodó babzilürr, ngi Golgota (oya küp módóga: “Singül Kakan Bwób Poko”). ");
INSERT INTO tof_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","I oya waen akyanóm kain koralórr anónóm, darrü kapan klampükü yarrisarri apórrón. Nóma apókórr, da bangónórr anónóm. ");
INSERT INTO tof_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oya krrosdó we emngyelóp. Ene kakóm, i tibiób ngipükü nugup poko aman kwarilürr basenóm wa, Yesun mórrkenyórr poko nidi ki yazebrre. Inzan kwata i oya mórrkenyórr we arrgrrütóp tibióbkü. ");
INSERT INTO tof_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ene kakóm, i we bobrranórr, oya ngakanóm. ");
INSERT INTO tof_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Oya sisingül darrü nugup pósek emngyelóp, wialómórrón ini bóktan opore, oya ne bóktana büdüldü ingrinürr wagó, “Ini wa Yesue, Zu pamkolpamab King.” ");
INSERT INTO tof_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Da ene pokodó, i ta nis gazirr-gazirr gómól pam nis tibiób krrosdó nómngyelóp Yesukü, darrü oya tutul kwata, darrü oya banól kwata. ");
INSERT INTO tof_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pamkolpama nidi bórrgrrat-tórrgrrat kwarilürr, oya kle-kle yalnónóp. Tibiób singül bóngapnóp igó bóktankü wagó, ");
INSERT INTO tof_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ma módógla, Godón Gyabi Müót nótó ki ilgüte akó ma aüd ngürr kugupidü ki ela! Moba kóbó zid bai! Ma ne Godón olom nómadóla, da krrosdógab ugó tibi!” ");
INSERT INTO tof_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dadan ngarkwatódó, wirri prrist, Mosesón gida umulbain pam, akó balngomól byarrmarr pama Yesun we tiz yangónónóp wagó, ");
INSERT INTO tof_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Wa ngibürr zid bain yarilürr, da wa ma gaodó kokea tóba zid bainüm! Ia wa Isrrael pamkolpamab kinga, be? Errkyadan ugó kóbó ki tibi ene krrosdógab. Mi oya amkoman kubó igósidi yangurre! ");
INSERT INTO tof_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Wa Godón amkoman angunda. God oya ki zid syó errkyadan, Godón ubi ne asi nóma yarile oyaka, zitülkus wa igó bóktanórr wagó, ‘Ka Godón olomla.’” ");
INSERT INTO tof_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ene gazirr-gazirr gómól pam nisa, Yesun kabe-kabe tibiób krrosdó amngyelórrón nidi namülnürri, oya ta dadanzan kle-kle yalnórri. ");
INSERT INTO tof_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Abüs singülküp nóma semrranórr, tümüna blaman bwób ngaslaorr. Ene tümüna aüd abüs küp ngarkwatóm wamórr. ");
INSERT INTO tof_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Abüs aüd küp ngarkwat nóma semrranórr simam, Yesu wirri gyagüpi we taegwarr apónórr wagó, “Eli, Eli, lama sabagtani?” Oya küp módóga: “Kürü God, kürü God, ma kürü iade kolkomóla kólbanan?” ");
INSERT INTO tof_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ngibürr kolpama ibükagab, ola nidi bórrang kwarilürr, oya bóktan nóma barrkrrurr, da we bóktónóp wagó, “Wa Ilaezan ngyaunda.” ");
INSERT INTO tof_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dümdüman darrüpa busorr, mórrkenyórr pokozan kla ipadórr, muran waendó yanggóbólórr, aul pepeamdó amrókórr, da oya ekyanórr ausüm. ");
INSERT INTO tof_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A ngibürra we bóktónóp wagó, “Kubó, mi kya kóbó ngakónónóm, Ilaeza ia kubó tame oya zid ainüm.” ");
INSERT INTO tof_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu akó wirri gyagüpi taegwarr apónórr, tóba dómdóm ngón we semanórr, da nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Da módóga, Godón Gyabi Müót kugupidü ne wirri adrratórrón mórrkenyórra olean yarilürr, tebe aodó nis ór we bangónórr, tai kwitüdügabi kókó tüp. Tüpapükü mórrbaengórr, wirri ingülküpapükü órpókal bangónóp. ");
INSERT INTO tof_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gapókapükü tapabakuóp, akó ngaen abün ne Godón amkoman angun pamkolpam kwarilürr, nidi nurrbarinürr, God ibü ugón irsinürr arróldó. ");
INSERT INTO tof_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","I tibiób gapók nümgütóp. Yesun arsümül tonarr kakóm, i blamana Zerrusalem we barrbünürr, Godón gyabian wirri basirrdü. Ibü abün pamkolpama nósenónóp. ");
INSERT INTO tof_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Gazirr pamab kopo ngakan wirri pam tóba gazirr pampükü Yesun nidi ngakan kwarilürr, i tüp mórrbaengde nóma esenóp akó blaman ne tórrmen tulmila tómbapón kwarilürr, i blaman kari gum koke koralórr. I blamana inzan bóktónóp wagó, “Amkoman, wa Godón olom yaril!” ");
INSERT INTO tof_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ene pokodó abün kol kwarilürr, barrkyanan kandógabi nidi azil kwarilürr, Yesun Galiligabi nidi mamoanónóp oya tangamtinüm. ");
INSERT INTO tof_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Inkü we kol koralórr: Merri Magdalin, Merri, Zeims a Zosep ibü aip nótó warilürr, akó Zebedin olom nisab aip. ");
INSERT INTO tof_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Simaman nóma yarilürr, darrü mórrel pama ugón tübzilürr, ngi Zosep. Wa Arrimatia wirri basirr pam yarilürr, Yesun darrü umulbain olom. ");
INSERT INTO tof_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Wa Paelatka we wamórr, da Yesun büdül bübüm we yatorr. Paelat arüng bóktan zirrapónórr wagó, Yesun büb Zosepón akyanóm. ");
INSERT INTO tof_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Zosep büb ipadórr, da wirri darrem baeb tóman-koke mórrkenyórri we errgótanórr, ");
INSERT INTO tof_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","da gapókdó we ingrinürr, tóbankü ngaensingülan ne kla ilüngürr karrkukus ingülküpdü. Da wa ene gapók mamtae murrausüm wirri ingülküp we yanenórr. Da wa ae wamórr. ");
INSERT INTO tof_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Merri Magdalin, akó darrü Merri ola mórran namülnürri, obzek ma gapókdó. ");
INSERT INTO tof_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yesun ne ngürr emkólóp, ugón dómdóm elklaza tómbapón ngürr yarilürr. Ene ngürr kakóm ma ibü ⌊Sabad⌋ ki yaril. Wirri prrist akó Parrisia Paelatón asenóm ugón ogobórr. ");
INSERT INTO tof_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oyabóka wagó, “Wirri pam, kibü kuri ngambangóle, ene ilklió bülión pam ne arról nóma yarilürr, wa igó bóktanórr wagó, ‘Ka sab aüd ngürr kakóm büdüldügab ugón türsümulo.’ ");
INSERT INTO tof_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Da arüng bóktan ugó nókyenónóm oya gapók tai murrausüm akó morroal ngakanóm, ngarkwat kókó aüd ngürra nóma bobrrone. Oya umulbain olmalab sab gaodó koke ia yarile, oya büdül büb gómól-gómól apadóm akó pamkolpamdó bóktanóm wagó, ‘God oya büdüldügab kuri irsümüle.’ Ini dómdóm ilklió bülión bóktan sab wirri kolae yarile. Ngaen-gógópan kla wa tai wirri kolae koke yarilürr.” ");
INSERT INTO tof_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Paelat ibübóka wagó, “Gazirr pam yazebam, da ugó ogob. Ene gapók morroal ngakan ki kwarilün yabü gyagüpitótók ngarkwatódó.” ");
INSERT INTO tof_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Da i we ogobórr, ene gapók mamtaedó ne ingülküp yarilürr, wirri karrkukus sye-i arümóp anen-gum akó pama gapókdó bangrin-gum. Gazirr pam ola bimgütóp gapók ngakanóm. ");
INSERT INTO tof_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","⌊Sabada⌋ nóma blakónórr, udaian ngaen-gógópan ngürrdü, irrbianande, sisa nóma balgón yarilürr, Merri Magdalin akó darrü Merri gapók angónóm aurrürri. ");
INSERT INTO tof_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Da módóga, tüpa wirri arüngi we mórrbaengórr, zitülkus Lodón darrü anerrua kwitümgabi we tübinürr. Wa gapók minggüpanandó wamórr, da ene ingülküp we yanenórr mamtaedógab. Tüób wa we mórran-mórran bainürr ene ingülküp kwitüdü. ");
INSERT INTO tof_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oya büb a obzek igó yarilürr, wamaka aona warri amanda. Oya mórrkenyórra ongang bapólórr wamaka gabülplian pülpül pokoa. ");
INSERT INTO tof_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Gapók ne gazirr pama ngakan koralórr, ibüka kari gum tórrngón koke yarilürr, da i büdül pamzan bainóp. ");
INSERT INTO tof_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Da anerrua ene kolbóka wagó, “E gumgu. Ka umulóla e Yesun amkündakla, krrosdó noan emngyelóp. ");
INSERT INTO tof_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Wa aini babula, zitülkus oya kuri irsümüle, wa tüób enezan yarilürr. Da yao, ene poko ngakanóm togob, oya büb ne angrirrün yarilürr. ");
INSERT INTO tof_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Da büsai-büsai ugó ogob errkyadan. Oya umulbain olmal umul-umulan ngintinamke magó, ‘God oya büdüldügab kuri irsümüle! Wa Galili tótókdase yabü singül kwata. E kubó oya ola esenane!’ Ka yabü umul-umulan ngitanóm tama.” ");
INSERT INTO tof_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","I gum tórrngónkü büsai-büsai we aurrürri gapókdógab. Ibü bübdü ta wirri bagürwóma tübangrinürr, da we busorri umulbain olmal umul-umulan ngibtanóm. ");
INSERT INTO tof_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Da módóga, i umulbain olmal umul-umulan ngibtanóm nóma aurrnürrima, da Yesukü basenóp. Ibübóka wagó, “Paud yabüka asi ki yarilün!” Da i oyaka we aurrürri, wakósingül nülkamürri, oya wapór nis nómoarri, oya ⌊ótókóm⌋. ");
INSERT INTO tof_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu ibübóka wagó, “E gumgu; ugó aurram kürü zonaretal umul-umulan ngibtanóm, Galili tótókóm. I kürü sab ola kóserre.” ");
INSERT INTO tof_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ene kola nóma ogoblórr, da módóga, gazirr pam, gapók nidi ngakanónóp, i ta we bakonórr Zerrusalem wirri basirrdü. Wirri prristab umulüm, blaman poko adrrütóp gapókdó ne klama tómbapónóp. ");
INSERT INTO tof_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Wirri prrist akó ⌊balngomól byarrmarr pama⌋ darrü bóktan akó we tónggapónóp, da wirri ngarkwat mani gazirr pam nókyenóp. ");
INSERT INTO tof_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ibübóka wagó, “E sab igó kwarilünke magó, ‘Yesun umulbain olmala irrüb togobórr a büdül büb ugón sipüdóp, ki ut nóma koralórr.’ ");
INSERT INTO tof_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Gabena ne ini bóktan nóma arrkrrue, ki sab oya gyagüpitótók yalüngrre kibü amkoman angunüm, da yabüka sab darrü müp babul yarile.” ");
INSERT INTO tof_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ene gapók ne gazirr pama ngakan koralórr, ene mani ipüdóp, da wirri ngi pamab bóktan mamunóp, ibü enezan nilóp. Da Zu pamkolpama ene bóktan metat ayodako, tai ene ngürrdügab ngarkwat kókó ta errkya. ");
INSERT INTO tof_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ene 11 umulbain olmala Galili we ogobórr, ene pododó, Yesu ibü enezan nilóp ola tótókóm. ");
INSERT INTO tof_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","I oya nóma esenóp, i wakósingül we nümgünóp oya agürüm. A ngibürr wa gyagüp-gyagüp koralórr wagó, “Ia amkoman watóke?” ");
INSERT INTO tof_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu ibü minggüpanan nóma tamórr, ibübóka wagó, “Kürü Aba blaman ene balngomól arüng kókyanórr, kwitüm akó tüpdü. ");
INSERT INTO tof_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Da e igósidi ugó ogob pamkolpamdóma bwób-bwób. Sab kürü umulbain olmalóm ninamke, ibü ⌊baptaes bainkü⌋ Aban ngidü, Oloman ngidü akó Godón Samuan ngidü, ");
INSERT INTO tof_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","akó ibü umul bainkü blaman bóktan karrkukus amorranóm, ka yabüka ne poko arüngi bóktan namülnürrü mamoanóm. Da módóga, ka sab yabüka asi namulo metat, kókó tüpan blakón tonarra nóma tame.” Metyun Peba aini blakónda. ");
INSERT INTO tof_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Morroal Bóktana ae bókyanda, Yesu Kerrisonkwata, Godón Olom. ");
INSERT INTO tof_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enezan wialómórróna ⌊prropet⌋ Aesayan pebadó, God ⌊Kerrisodó⌋ ne poko bóktanórr wagó, “Turrkrru! Ka sab kólba bóktan ódód pam zirrapono marü singül kwata. Wa sab marü kwat wató ngagróte.” ");
INSERT INTO tof_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Darrü pama taegwarrdase ⌊ngüin-koke bwóbdü⌋ wagó, ‘Kwat ngagrótam ⌊Lodón⌋ tótókóm akó kwat morroal dümdüm alótam oyankü.’” ");
INSERT INTO tof_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Da Zon Baptaes Bain Pama we okaka tübyónürr ngüin-koke bwóbdü, bóktan igó amgolkü wagó, “Godka tübyalüngam yabiób kolae tonarrdógabi. Da ka yabü baptaes ninünümo. Ene igósüm, God yabü kolae tonarr sab norrgorre.” ");
INSERT INTO tof_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Blaman pamkolpama ogoblórr, Zudia prrobins kugupidü ne basirrdügabi akó Zerrusalem wirri basirrdügabi, Zonón bóktan arrkrrum. I tibiób kolae tonarr nóma okaka uzazilürr, da Zon ibü baptaes nyónónóp Zodan tobarrdó. ");
INSERT INTO tof_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Zon wa ⌊kamel⌋ ngüin mórrkenyórr bamelórrón yarilürr, akó wa lar sopae belt baterrón yarilürr. Oya alo kla we kla yarilürr, paza tónók akó molpokodó gus mor. ");
INSERT INTO tof_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Wa ibüka bóktan amgolórr wagó, “Darrü pama kürü solkwat tótókda, wirri arüng nótóke kürükagab. Ka ta ngarkwatódó kokela tüp aupüm oya wapórdó bamel kla sye agom. ");
INSERT INTO tof_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ka yabü nae-e baptaes baindóla, a wa sab yabü Godón Samu-i baptaes bain yarile.” ");
INSERT INTO tof_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ene tonarrdó, Yesu we tübzilürr Nazarret wirri basirrdügab, Galili prrobins kugupidü, ó Zon oya we baptaes yónürr, Zodan tobarrdó. ");
INSERT INTO tof_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Dümdüman Yesu naedógabi nóma saogórr, wa pülpül esenórr nóma tapabakulürr. Akó wa Godón Samu we esenórr, kwitümgabi abindi akó oya kwitüdü amngyelde nurre póyae buli. ");
INSERT INTO tof_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kwitüdügabi bóktan kümüla we sidórükürr wagó, “Ma kürü kólbanan olomla. Kürü ⌊moboküpdü ubi⌋ marükama. Ka kari barnginwóm kokela marüka.” ");
INSERT INTO tof_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Dümdüman oya Godón Samua we idódürr ngüin-koke bwóbdü. ");
INSERT INTO tof_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wa olazan yarilürr, wa 40 ngürr amanórr, satania nóla alngomólóm kain yarilürr kolae tonarr tónggapónóm. Yesu nurr larpükü ngyabelórr ama ⌊anerrua⌋ oya we tangamtinóp. ");
INSERT INTO tof_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Zonón tümün müótüdü we ingrinóp. We kakóm, Yesu ma Galili wamórr, Godón Morroal Bóktan amgolkü. ");
INSERT INTO tof_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Wagó, “Ene tonarra kuri tübzile. Godón Kingzan Balngomóla minggüpanan kuri tübine. Yabiób kolae tonarrdógabi ugó tübyalüngam, ama Morroal Bóktan amkoman angunüm!” ");
INSERT INTO tof_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu Galili Malu kabeana nóma wamlórr, wa nis pam nis nósenórr, Saemon akó oya zoret, Endrru. I net yagóbnürri naedó, zitülkus i wapi baib pam nis namülnürri. ");
INSERT INTO tof_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu ibü nyalórr wagó, “Yao! Kankü turram. Ka yabü pamkolpam bumióg umul nino.” ");
INSERT INTO tof_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Darrpan güblang i ne arrkrrurri, tibiób net ola bimgatrri, da Yesuka we akyarri. ");
INSERT INTO tof_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesu ne barrkyananbóka nóma wamórr, wa nis narezoreti pam nis nósenórr, Zeims a Zon, Zebedin olom nis. I tibiób butüdü net barrgüp namülnürri. ");
INSERT INTO tof_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesu ibü we nósenórr, da ibü dümdüman we nginaunürr oyaka solkwat akyanóm. I tibiób ab Zebedin ola amgatrri butüdü, tóba zaget pampükü, da Yesuka we akyarri. ");
INSERT INTO tof_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu tóba tokom umulbain olmalpükü wamórr kókó Kaperrna-um wirri basirrdü. Darrü ⌊Sabad⌋ ngürrdü wa ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ ugón bangrinürr, da umulbain ngarkwat we bókyanórr. ");
INSERT INTO tof_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pamkolpama gübarirr aengóp, wa ne ngarkwatódó umul nyónónóp. Zitülkus módóga, wa ne balngomól arüngi umul bain yarilürr, wa Mosesón gida umulbain pam nórrgrrótóp. ");
INSERT INTO tof_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Dümdüman ene tonarrdó, darrpan kolae samupükü pam ibü kwóbbazen müót kugupidü we yarilürr. Kolae samua ene pam we zirratakórr wirribóka taegwarr apónóm wagó, ");
INSERT INTO tof_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Marü ubi laró tónggapónóma kibüka, Yesu Nazarret olom? Ia ma kibü kolae bainüm tama? Ka umulóla ma nótókla. Ma Godón Gyabian Olomla!” ");
INSERT INTO tof_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu ene kolae samu agórr wagó, “Piküp bai! Ma ugó tubrra we pamdógab!” ");
INSERT INTO tof_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kolae samua ene pam wirribóka inurr. Wa karibóka-koke taegwarr apónórr, da wa we tubrranórr ene pamdógabi. ");
INSERT INTO tof_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Blaman pamkolpama gübarirr aengóp, da i tibiób bamtinónóp wagó, “Ini ia laróga? Ini küsil umulbain bóktana, balngomól arüngpükü! Wa kolae samu dele arüng bóktan aliónda akó i oya bóktan arrkrrudako!” ");
INSERT INTO tof_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Da módóga, Yesunkwata bóktana büsai we büdólórr dudu Galili bwóbdüma. ");
INSERT INTO tof_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu tóba tokom umulbain olmalpükü kwóbbazen müót we amgatórr, ama Saemon a Endrru, ibü müótüdü bangrinürr. ");
INSERT INTO tof_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saemonón mónang güb azid warilürr, nyórrdü utürrün, da dümdüman i Yesun we izazilóp oyakwata. ");
INSERT INTO tof_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Da Yesu azid koldó we wamórr, oya tangdó omoanórr, mórran-mórran wyónürr, solkwat we zamngólórr. Da oya ene azida wata we zumgatórr. Solkwat wa ibü alo kla we nganinóp. ");
INSERT INTO tof_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ene simaman, abüsa nóma mórralórr, pamkolpama Yesuka blaman azid kolpam akó kolae samupükü kolpam ugón tübarrmülürr. ");
INSERT INTO tof_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Blaman ene basirr pamkolpama we kwób tóbazelórr kókó ene müót mamtaedó. ");
INSERT INTO tof_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu ia-ia abün azid kolpam we dólóng nyónónóp, akó abün kolae samu amalórr. Wa kolae samu koke ok ninóp bóktanóm, zitülkus i umul koralórr, wa nótó yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sisa balgón tai küsil yarilürr, Yesu müót zokrrok we amgatórr. Wa ene basirr amgatórr, da kolpam-koke bwóbdü wamórr. Wa ola tóre ako yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saemon tóba kamdalpükü oya amkünüm we bazebórr. ");
INSERT INTO tof_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nóma esenóp, i wagó, “Blaman pamkolpama marü amkündako!” ");
INSERT INTO tof_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ibüka bóktan we yalkomólórr wagó, “Mi wata ini ngibürr basirrdüma ogoblo, ini wirri basirr minggüpanan nidipako. Ka ta ola amgolo Morroal Bóktan, zitülkus ka ugósüm tamórró.” ");
INSERT INTO tof_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Da módóga, wa we wamlórr basirr-basirr Galili kugupidü, Godónkwata Morroal Bóktan amgolkü tibiób kwóbbazen müótüdü akó kolae samu amankü. ");
INSERT INTO tof_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Darrpan soso azid pama tamórr kókó Yesuka. Wa wakósingül nülkamülürr, da wa we bóktanórr wagó, “Marü ubi ne nóma yarile, ma gaodó namulo kürü ⌊tóman⌋ arrgonóm Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu oya kari gyaur koke esenórr, tóba tang orrakórr, da ene pam we yamurrürr. Yesu oyaka we bóktanórr wagó, “Kürü ubia! Tómana ki barrgo!” ");
INSERT INTO tof_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Dümdüman ene soso azida oya we amgatórr. Tómana oya büb ugón amgatórr. ");
INSERT INTO tof_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Dümdüman Yesu oya zirrapónórr, wirri arüng bóktanpükü ");
INSERT INTO tof_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wagó, “Tai turrkrru! Ma ini poko darrü olom azazilgu! A ma wam ⌊prristdü⌋, moba bómtyanke, da wa marü büb sopae tai ki ngamka. Yabü ne ngaen Moses ne gida bóktan poko nókyenóp, da ene ⌊gyaur kla⌋ kubó ⌊Godón Gyabi Müótüdü⌋ idódke prrista ola urdü agasilüm pamkolpam amtyanóm igó, marü soso azida kuri blakóne, da marü tómana kuri barrgone Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Da ene oloma ma we wamórr, blaman bwóbdüma büdrratkü ne pokoa tómbapónórr. Wa bóktan we ayorr. Yesu ma igósidi gaodó koke yarilürr panzeana tótókóm blaman wirri basirrdü. Ene pokodó, Yesu kolpam-koke bwóbdü igósidi ngyabelórr. Ó da módóga, blaman pamkolpama bwób-bwób we togoblórr ama oyaka. ");
INSERT INTO tof_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ngibürr ngürr kakóm, Yesu Kaperrna-um wirri basirrdü we alkomólórr, ó pamkolpama bóktan barrkrrurr wagó, “Wa müótüdü asine.” ");
INSERT INTO tof_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Abün pamkolpama togoblórr, darrpan pokodó kwób bazenóp ene müótüdü. Ene müót kugupi mamtae wata barümürrün yarilürr. Yesu ibü Godón bóktan we umul bain yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Da módóga, ngibürr kolpama ugón tübabzilürr. Tokom pama ibükagab, darrü büb bidal pam sidódnóp ama oyaka. ");
INSERT INTO tof_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","I ene pam minggüpanan koke idüdóp, zitülkus pamkolpamab ngoro ola yarilürr. Da módóga, i mórrkakakdó bamselórr ene pampükü. I mórrkakak we tae apónóp, Yesu ne pokodó zamngól yarilürr. I nóma tae apónóp, ene pam rraparrapapükü we tüp solkomólóp, Yesun obzek kwata. ");
INSERT INTO tof_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu ibü amkoman bangun nóma esenórr, wa büb bidal pamdó bóktanórr wagó, “Kürü olom, ka marü kolae tonarr kuri norrgonónóma!” ");
INSERT INTO tof_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ngibürr Mosesón gida umulbain pama we bobrralórr, gyagüpi tótókde ");
INSERT INTO tof_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","wagó, “Ini pama ini poko inzan iade bóktanda? Wa Godón pabo apadóm kainda! Gaodó ia nótóke kolae tonarr barrgonóm, a wata God tebean?” ");
INSERT INTO tof_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dümdüman Yesu ibü gyagüpitótók yazebórr, da wa ibüka we bóktanórr wagó, “E wa inzan poko iade gyagüpi tótókdakla yabiób moboküpdü? ");
INSERT INTO tof_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ini nis bóktan nisdügab, ia kürüka ulan nadü bóktana bóktanóm ini büb bidal pamdó? Ia, ‘Marü kolae tonarr barrgorrónako,’ ta ia, ‘Bupa, moba nyórr errngam, da ugó agólóm bai’? ");
INSERT INTO tof_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Da kürü ubi igósüma, e kubó ini kla umul bainane wagó, Pamkolpamab Oloman balngomól arüng asine ini tüpdü kolae tonarr barrgonóm.” Da wa ene büb bidal pamdó bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ka marü ayaldóla, ugó bupa, moba nyórr ipa, da ugó wam, moba müót basirrdü!” ");
INSERT INTO tof_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dümdüman ene pama bupadórr, tóba nyórr ipadórr, da we wamórr blaman pamkolpamab obzek kwata. I blamana gübarirr aengóp akó i Godón we yagürnóp. I igó zwapólórr wagó, “Iba, inzan kla ta mi ngaen kokean esenóp!” ");
INSERT INTO tof_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu akó we alkomólórr Galili Maludü. Wa malu kabeana nóma wamlórr, wirri pamkolpamab ngoroa we togoblórr oyaka, da wa ibü we umul bain yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wazan wamlórr, wa ⌊taks mani dakabain pam⌋ we esenórr, ngi Libae, Alpeiusün olom, tóba kari zaget müótüdü mórrande. Yesu oyabóka wagó, “Yao, ma kürüka tókya!” Libae we bupadórr, oyaka we akyanórr. ");
INSERT INTO tof_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ene kakóm, Yesu tóba umulbain olmalpükü Libaen müótüdü nóma alo yarilürr, abün taks mani dakabain pam akó kolae tonarr kolpama we togobórr, inkü alom ene tógaldó. Zitülkus módóga, Yesuka abün inzan pamkolpama atan koralórr. ");
INSERT INTO tof_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ngibürr Mosesón gida umulbain pama, akó tib ⌊Parrisi⌋ kwarilürr, Yesun alode nóma esenóp taks mani dakabain pam akó kolae tonarr kolpampükü, da i oya umulbain olmal nümtinóp wagó, “Wa iade aloda inzan kolpampükü?” ");
INSERT INTO tof_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ibü nurrkrruóp, da bóktanórr ene pokodó wagó, “Azid-koke kolpam nidipako, i dokta koke amkündako, wata azid nidipko. Ka ini tüpdü igósüm koke tamórró igó, dümdüm ngyaben pamkolpam ngibaunüm. A ka wa kolae tonarr pamkolpam ngibaunüm tamórró Godka byalüngüm kolae tonarrdógab.” ");
INSERT INTO tof_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Darrü tonarr, Zon ⌊Baptaes Bain⌋ Paman umulbain olmal akó Parrisi, i alo bütók kwarilürr. Ngibürr kolpama Yesun amtinüm togobórr. I oya imtinóp wagó, “Ia Zonón umulbain olmal ó Parrisiab umulbain olmala alo larógóm bütókdako, a marü ma koke?” ");
INSERT INTO tof_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu tóbakwata alap-alap bóktanórr ibüka wagó, “Yabü gyagüpitótók iada, pamkolpama kol amióg tóredó ia kubó alo bütókrre, kol amióg pam ibüka nómade? Koke! Kol amióg pamzan asine ibüka, i alo koke bütókrre. ");
INSERT INTO tof_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","A ene ngürr sab semrróne, kol amióg pam ibükagabi nóma sipüdrre. Da ene ngürrdü i sab alo bütókrre. ");
INSERT INTO tof_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Darrü oloma küsil mórrkenyórr poko koke arrgüpe ngaep mórrkenyórrdü tae murrausüm. Wa ne nóma tólaele, ene küsil mórrkenyórr pokoa nóma korrom baine, ene ngaep mórrkenyórr sab amurrute da batürre, ama tai wirri tae ine. ");
INSERT INTO tof_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Darrü pama küsil waen koke errngóme ngaep lar sopae beledó. Wa ne nóma tólaele, ene waena kubó ene ngaep bele amkene. Waen a lar sopae bele sab kolae baini. Igósidi, küsil waen wata küsil lar sopae beledó errngómórre.” ");
INSERT INTO tof_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Darrpan Sabad ngürrdü, Yesu ⌊wit⌋ apapana tótók yarilürr. Oya umulbain olmala wanküzan ogoblórr, i wit küp we zulkulóp alom. ");
INSERT INTO tof_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Da Parrisia Yesuka we bóktónóp wagó, “Ngaka, marü umulbain olmala ene zaget iade tónggapóndako, gyabi ne klame Sabad ngürrandó?” ");
INSERT INTO tof_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ibüka we bóktanórr wagó, “E ia kokean etóngarre Godón Wibalómórrón Bóktandó, Deibid ne kla tónggapónórr, we tonarr, wa tóba pam kopopükü alom nóma yarilürr? ");
INSERT INTO tof_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Wa Godón ⌊Palae Müótüdü⌋ bangrinürr, Abyatarr ⌊singüldü prrist⌋ nóma yarilürr, da ene gyabi brred elorr, prrista Godón obzek kwata ne kla urrbulürr. Ngibürr tóba pam nülinóp. A Mosesón gida ngarkwatódó dümdüm kokea ene brred alom; wata prristab dümdüme, ene brred alom!” ");
INSERT INTO tof_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesu elakónórr wagó, “Sabad pamkolpamab morroalóm tónggapónórr. Pamkolpam Sabadan morroalóm koke tómbapónóp. ");
INSERT INTO tof_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Da ka Pamkolpamab Olomzanla, ka ta Sabadan Lodla.” ");
INSERT INTO tof_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Akó darrü ⌊Sabad⌋ ngürrdü Yesu ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ bangrinürr. Ola darrü pam yarilürr, tutul tang bidal akó sarrpi airrün. ");
INSERT INTO tof_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ngibürr Parrisia kwat amkün kwarilürr Yesun kotóm ain bóktan amanóm, da oya tai ilküpane we idódnóp wa, ia wa kubó Sabad ngürrdü ene pam dólóng ine. ");
INSERT INTO tof_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu ene tang bidal pamdó we bóktanórr wagó, “Bupa, ugó zamngól blamanab aodó!” ");
INSERT INTO tof_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Da Yesu ene Parrisidü we bóktanórr wagó, “Mibü gidadógab ia taia Sabad ngürrdü morroal tónggapónóm, ta ia kolae tónggapónóm; ia arról zid ainüm, ta ia arról alakónóm?” A ibü darrü bóktan ta babul yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu pamkolpam nóma ngabkanórr, oya ngürsila we simiógürr. Wa ta kari gyaur koke yarilürr ene pamkolpamdó, zitülkus ibü baku burrul babulan yarilürr. Yesu ene tang bidal pam we yalórr wagó, “Moba tang ugó adrrat.” Wa adrratórr, da oya tanga tóba gaodó alkomólórr. ");
INSERT INTO tof_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parrisia kwóbbazen müót nóma amgütóp, dümdüman we kwób bazenórr Errodón mamoan pampükü, Yesun amkal bóktan angrinüm. ");
INSERT INTO tof_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu tóba umulbain olmalpükü Galili Maludü nóma wamlórr, wirri pamkolpamab ngoroa Galili prrobinsdügabi oyaka zutalórr. Akó pamkolpamab ngoroa Zudia prrobinsdügabi togoblórr, ");
INSERT INTO tof_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Zerrusalem wirri basirrdügab, Idumea bwóbdügabi, akó abüsa nólgab banikda Zodan tobarrdó. Ngibürra ta wirri basirr nis, ngi Taerr akó Saedon minggüpanandógabi togoblórr. Blaman ene pamkolpama barrkrrurr Yesu ne arüng tórrmen tómbapón yarilürr, da i oyaka ugósümpükü togobórr. ");
INSERT INTO tof_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pamkolpam ngorozan yarilürr, Yesu tóba umulbain olmal we nilóp but oya minggüpanan ódódóm, oya koke iade ki sur irre. ");
INSERT INTO tof_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngaen-gógópan wa abün pamkolpam we dólóng ninóp, solkwat akó abün azid pamkolpama oyaka ugón togoblórr, tibiób zirrbapónkü. Ibü ubi i oya ki yamurrórre. ");
INSERT INTO tof_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kolae samupükü pamkolpama oya nóma esenónóp, we balóklórr oya obzek kwata, da we taegwarr apónónóp wagó, “Ma Godón Olomla!” ");
INSERT INTO tof_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu ibüka wirri arüng bóktan we nókyenóp wagó, “Ngibürr büzazilgu ka nótókla!” ");
INSERT INTO tof_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu we angürürr pododó. Wa tóba ubi pam we ngibaunürr tóbaka. Da i we togobórr oyaka. ");
INSERT INTO tof_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ene pokodó, wa 12 pam irrbünürr, wa apostolóm nibiób ngibasilürr, oyankü ngyabenóm akó ibü zirrbapónóm bóktan amgolóm. ");
INSERT INTO tof_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Wa ibü ta irrbünürr wirri arüng azebóm kolae samu amanóm. ");
INSERT INTO tof_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ene 12 arrbürrün pam módógako: Saemon (noan ngyesilürr Pita), ");
INSERT INTO tof_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zeims akó oya zoret Zon, Zebedin olom nis nidi namülnürri (Yesu ibü ngi we nókyanórr Boanerrges, oya küp módóga: “Ngürsil Pam Nis”), ");
INSERT INTO tof_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Endrru, Pilip, Barrtolomyu, Metyu, Tomas, akó darrü Zeims, Alpeiusün olom nótó yarilürr, Tadeius, akó darrü Saemon, ngaen Zilot pam nótó yarilürr, ");
INSERT INTO tof_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","akó Zudas Iskarriot, Yesun sab nótó ingrine wirri ngi pamab tangdó. ");
INSERT INTO tof_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu darrü müótüdü nóma bangrinürr, pamkolpamab ngoroa akó we dakabasulürr. Yesu akó tóba umulbain olmala gaodó koke kwarilürr alo alom, zitülkus aüd pamkolpam koke kwarilürr ola. ");
INSERT INTO tof_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesun zitül pamkolpama ene poko nóma barrkrrurr, i oya apadóm we ogobórr, zitülkus i tib igó bóktanónóp wagó, “Oya gonggoa kuri simige!” ");
INSERT INTO tof_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ngibürr Mosesón gida umulbain pama Zerrusalemgabi togobórr. I igó bóktan kwarilürr wagó, “Yesun bübdü Be-elzebul asine. Satani, kolae samuab singüldü pam nótóke, oya ene arüng wató akyanda kolae samu amanóm.” ");
INSERT INTO tof_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu ene pam we ngibaunürr tóbaka, da wa ibüka alap-alap we bóktanórr wagó, “Satani tüób wa satani ia amanike pamkolpamdógab? ");
INSERT INTO tof_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Darrü kingan balngomól bwób pamkolpama ne tibiób nóma bürrgrrütórre tibióbka bóka bamgünüm, i sab gaodó koke kwarile morroal ngyabenóm tibiób bwóbdü. ");
INSERT INTO tof_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Akó darrpan müótüdü pamkolpama ne tibiób nóma bürrgrrütórre, i sab gaodó koke kwarile dabyónüm. ");
INSERT INTO tof_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Da ene ta inzana, satani akó tóba kolae samua ne tibiób nóma bóka bamgün kwarile ó i ne tibiób nóma bürrgrrütórre, da satani sab gaodó koke yarile zamngólóm, da oya arünga ta sab igósidi we blakóne. ");
INSERT INTO tof_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Anda, darrü pam gaodó kokea arüng paman müótüdü popa bangrinüm, oya elklaza azebóm. Ngaen-gógópan wa ene arüng pam sye-i amróke, da ene kakóm oya müót igósidi amkene, oya elklaza azebóm. ");
INSERT INTO tof_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ka yabü amkoman poko byaldóla: God sab pamkolpamab blaman kolae tonarr norrgorre akó i ne kolae poko bóktandako Godónkwata. ");
INSERT INTO tof_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","A nadü oloma ne kolae poko bóktanda Godón Samuankwata, God sab oya ene kolae tonarr kokean arrgone, zitülkus wa barrgon-koke kolae tónggapónórr.” ");
INSERT INTO tof_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Yesu inzan igósidi bóktanórr, zitülkus ene Mosesón gida umulbain pama inzan bóktónóp wagó, “Oya bübdü kolae samu asine.”) ");
INSERT INTO tof_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ene kakóm, Yesun aip akó zoretala ugón tübabzilürr. I müót kalkuma bórranglórr, da i bóktan we zirrapónóp, oya tótókóm. ");
INSERT INTO tof_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pamkolpam ngoroa Yesun myangrao apónóp izan mórran koralórr, da i oyaka igó bóktónóp wagó, “Yazil, marü aip akó zoretala kalkumako. Ibü ubi marü asenóma.” ");
INSERT INTO tof_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu ibüka bóktan we yalkomólórr wagó, “Kürü aip akó zoretal ia tai nidipako?” ");
INSERT INTO tof_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wa pamkolpam nóma ngabkalórr oya myangrao apórrón, da wa we bóktanórr wagó, “Ngakónam, ini kürü aip akó zoretalko! ");
INSERT INTO tof_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Zitülkus módóga, Godón ubi nótó tómbapónda, wa kürü zorete, kürü bólbóto, kürü aipo.” ");
INSERT INTO tof_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Akó Yesu we bókyanórr pamkolpam umul bain Galili Malu kabedó. Wirri pamkolpamab ngoroa oya amarüksimarük yangónónóp. Kan babul nóma yarilürr, da wa butüdü igósidi we kasilürr, we mórran-mórran bainürr. But wa naedó yarilürr, dudu ngoroazan bórranglórr malu kabedó, nae ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Olgabi Yesu ibü alap-alap abün elklaza umul bain yarilürr. Wa ibüka bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tübarrkrru! Darrü küp barit pama we wamórr ⌊wit⌋ küp tüpdü aman-aman aritüm apapdó. ");
INSERT INTO tof_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wazan ene küp amalórr, ngibürra kwat kabedó balóklórr. Póyaea togobórr, we ololórr. ");
INSERT INTO tof_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ngibürra wirri ingülküppükü tüpdü balóklórr. Ene pokodó, kari tüp yarilürr. Ene wit guba büsai-büsai igósidi tübausürr, zitülkus ene ingülküp kwitüm tüp tumuman yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Abüsa nóma tübanikürr, oya urura ene küsil zid igósidi toklomóp, da odalan ngintinóp, zitülkus ibü simkün babul kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Akó ngibürr küpa tórezpükü sólmól pokodó balóklórr. Ene sólmóla nóma dódórr bain yarilürr, da ene wit zid ola sarrpi ninóp. Ene zida igósidi küp koke bapónóp. ");
INSERT INTO tof_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ngibürr küpa ma morroal tüpdü balóklórr. Ene küpa we bamkenóp, dódórr bainóp, da küp we bapónóp, ngibürra 30, ngibürra 60, akó ngibürra 100, darrpan küpdügab.” ");
INSERT INTO tof_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Da Yesu ibüka bóktanórr wagó, “Güblang noane arrkrrum, wa ki turrkrru!” ");
INSERT INTO tof_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I tibi-tibi pokodó nóma kwarilürr, Yesuka atan pamkolpam akó oya 12 umulbain olmala oya imtinóp ene alap-alap bóktan müsirrga ainüm. ");
INSERT INTO tof_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Wa ibüka we bóktanórr wagó, “Godón Kingzan Balngomólankwata anikürrün klambóka umul yabü akyarróna. A umulbain olmal-koke ne pamkolpamko, ka go enan alap-alap ikikdóla. ");
INSERT INTO tof_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ene igósüm, “‘I wa sab metat azil wa azil kwarile, da i ma tai kokean asen kwarile; i wa sab metat arrkrru wa arrkrru, da i ma Godón bóktanan ⌊küp tai kokean apad⌋ kwarile. Koke ne nóma, i ki tübyalüngórre kürüka, da ka ibü kolae tonarr igósidi ki barrgona.’” ");
INSERT INTO tof_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu ibü nümtinóp wagó, “E ia koke apadódakla ini alap-alap bóktanan küp? E kubó ngibürr alap-alap bóktanan küp ia-ia yazebane? ");
INSERT INTO tof_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ene küp barit pama Godón bóktan aritóda. ");
INSERT INTO tof_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ngibürr pamkolpam inzanako, kwat kabedó ne küpa balókórr. I bóktan nóma arrkrrudako, satania tótókda ó ene bóktan ibü bübdügab ausda. ");
INSERT INTO tof_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ngibürr pamkolpam inzanako, ingülküppükü tüpdü ne küpa balókórr. I Godón bóktan nóma arrkrrudako, bagürwómpükü apadódako. ");
INSERT INTO tof_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","A ene bóktana ibü bübdü tai koke mórran-mórran bainda, zitülkus oya simkün babulako, da ene bóktana wirrianbóka aebókande koke ngyabenda. Ngibürr müp tonarra nóma tótókdako ibüka ó ngibürr pamkolpama ibü wirri müp alióndako, zitülkus i Godón Bóktan amkoman angundako, i büsai-büsai bóleandako amkoman bangun-gum. ");
INSERT INTO tof_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ngibürr pamkolpam inzanako, tórezpükü sólmól pokodó ne küpa balókórr. I Godón bóktan arrkrrudako, ");
INSERT INTO tof_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","a tüpan gyakolae, mórrelwómóm ubi, akó ngibürr elklazam ubia ibü gyagüpitótókdó barrbündako, da Godón bóktan sarrpi aindako. Da ene pamkolpama küp koke igósidi bapóndako. ");
INSERT INTO tof_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","A ngibürr pamkolpam inzanako, morroal tüpdü ne küpa balókórr. I Godón bóktan arrkrrudako, apadódako, da i küppükü igósidiako. Ngibürra 30, ngibürra 60, ó ngibürra 100, darrpan küpdügab.” ");
INSERT INTO tof_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu ibüka bóktanórr wagó, “Ia darrü oloma zyón kla sidüde, da alópe ngalo-e ó ut bwób lorodó ingrine? Koke! Zyón kla wata kumngyindü amngyelórrón yarile! ");
INSERT INTO tof_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dadanzan, blaman barrón ne elklazako errkya, sab ma tübause panzedó, ó blaman ngablaorrón ne elklazako, sab zyóndü togobe. ");
INSERT INTO tof_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Darrü oloman ne güblang asi nóma namüli arrkrrum, wa ki turrkrru!” ");
INSERT INTO tof_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Akó wa ibüka bóktanórr wagó, “E wata umul-umul, e ne poko barrkrrua! E ne morroal nóma arrkrru koralo, God yabü sab umul nülirre. Da ini ma sab kari koke yarile. E ne morroal koke nóma arrkrru koralo, God yabü sab wata kari umul nülirre. ");
INSERT INTO tof_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Zitülkus módóga, noanko, sab akó oya ene tumum ngibürr iline. Babul noanko, oya sab imtine, oya kari-kari ne klame.” ");
INSERT INTO tof_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu ibüka akó alap-alap bóktanórr wagó, “Godón Kingzan Balngomól inzana. Darrpan oloma küp baritóda tüpdü. ");
INSERT INTO tof_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Irrüb wa utóda, ngürr wa arsümülda. Ngibürr ngürr kakóm, ene küp bamkerrónako, da i ma morroal dódórr baindako. Wa umul-kóka ia-ia tómbapónda. ");
INSERT INTO tof_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tüpa tüób tómbapónda zid dódórr ainüm ó küp basenóm; urr amankü dódórr baindase kókókó singüla tubrrune. Küpa ugón tómbapónda. ");
INSERT INTO tof_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Küpa nóma ngórr angurinda, da pama ugón atülda turriki, zitülkus abül ngarkwat kuri semrróne.” ");
INSERT INTO tof_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu akó bóktanórr wagó, “Ia mi Godón Kingzan Balngomól larópükü atanirre? Ó mi laró alap-alap bóktane ene Balngomólbóka bóktórre? ");
INSERT INTO tof_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ene inzana, wamaka karian küpa. Ene karian küpa blaman küpdügab tüpdü. ");
INSERT INTO tof_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","A darrü pama ene küp nóma artümülda tóba apapdó, ene zida dódórr bainda kókó wirri bainda blaman didiburr zidüdügab. Oya tiz ta wirriako, da kwitüm póyaea igósidi tibiób müót balmeldako oya murrdü.” ");
INSERT INTO tof_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu tóba bóktan nóma büdrratlórr pamkolpamdó, wa abün inzan alap-alap bóktan tómbapón yarilürr. Wa ibüka blaman elklaza tibiób ngarkwatódó bóktan yarilürr, ibü morroal arrkrrum. ");
INSERT INTO tof_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Wa ibüka wata alap-alap bóktane bóktalórr. Wa tebe nóma yarilürr tóba umulbain olmalpükü, wa blaman kla ugón müsirrga nyónónóp ibüka. ");
INSERT INTO tof_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Akó ene ngürr simaman, Yesu bóktanórr tóba umulbain olmaldó wagó, “Mi dakla dorro baurrdakla.” ");
INSERT INTO tof_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Da i pamkolpamab ngoro ola bimgütóp. Oya umulbain olmala butüdü bamselórr, Yesu ne butüdü mórran yarilürr. I usakü we bazebórr, oya dakla dorrodó ódódóm. Ngibürr but ta asi koralórr ene pokodó, da i usakü we ogoblórr. ");
INSERT INTO tof_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Amkórrónde, wirri arüng wóra ugón tubsorr. Goblola but kari poko isurrunópma. Naebait kari poko yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","A Yesu wa ngól updü ut yarilürr. Oya singül müózdü angrirrün yarilürr. Umulbain olmala oya irsümülóp. Oyaka bóktónóp wagó, “Umulbain Pam, ma ia gyaur kokela? Mi brariakla!” ");
INSERT INTO tof_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu türsümülürr, ó wa wór agórr wagó, “Ma piküp!” Akó wa maludü bóktanórr wagó, “Ma ugó bólea!” Ene pokodó, wóra we piküp bainürr. Ene ngarkwat, malua ta morroal amkónórr. ");
INSERT INTO tof_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Wa tóba umulbain olmaldó we bóktanórr wagó, “E gum iadeakla? E kürü amkoman koke angundakla?” ");
INSERT INTO tof_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Da i kari gum koke ipüdóp, ó i tibióbka bóktan koralórr wagó, “Ini wa ia nótóke? Wór akó malua ta oya bóktan arrkrrudamli!” ");
INSERT INTO tof_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu tóba umulbain olmalpükü Gerrasa wirri basirr pamkolpamab bwóbdü abzilürr Galili Malu dakla dorrodó. ");
INSERT INTO tof_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu butüdügabi nóma banikürr, darrü pama oya we semrranórr. Ene pama gapók balüng bwóbdügabi tubrranórr ó wa kolae samupükü yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wa gapók balüng bwóbdü ngyaben yarilürr. Myamem darrü olom babul yarilürr oya arümüm. Sein sye ta gaodó koke yarilürr oya arümüm. ");
INSERT INTO tof_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Zitülkus módóga, abün münüm oya wapór a tang sein sye-i enan arümnóp, a tüób ene sein sye singgalgólórr. Wa ta ugón kari arüng pam koke yarilürr. Darrü pam gaodó koke yarilürr oya amiógüm. ");
INSERT INTO tof_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Irrüb ngürr, wa popa agól yarilürr gapók balüng bwóbdü ó podopükü bwóbdü, taegwarrkü ó tóba büb syórr bangónkü ingülküpi. ");
INSERT INTO tof_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ene pam ugón barrkyanan küór yarilürr olgabi, wa Yesu nóma esenórr. Wa we busorr, simbalkalórr, ó wakósingül nülkamülürr Yesun obzek kwata. ");
INSERT INTO tof_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ene pama wirribóka taegwarr apónórr wagó, “Marü ubi ia larógóma kürüka, Yesu, Wirri Kwitüm Godón Olom? Ka Godón ngidü marü atodóla, ma kürü wirri azid akyan-gu!” ");
INSERT INTO tof_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ene pama ini poko igósidi bóktanórr, zitülkus Yesu ngaen-gógópan oyaka bóktanórr wagó, “Kolae samu, ugó tubrra ini pamdógab!” ");
INSERT INTO tof_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu oya imtinürr wagó, “Marü ngi ia nótóke?” Ene pama bóktan yalkomólórr wagó, “Kürü ngi módóga, ‘Abün gazirr pam’, zitülkus ki aüd kokeakla.” ");
INSERT INTO tof_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wa wata Yesun arüngi ato yarilürr, ene kolae samu aman-gum ene bwóbdügab. ");
INSERT INTO tof_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Podo kabedó, wirri tang kyamül yabüla we ololórr, wirri kan koke ibükagabi. ");
INSERT INTO tof_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ene kolae samua Yesun we yatop wagó, “Ma kibü ugó zirrtapónónóm kyamülab bübdü, da ki kubó ola barrbuno.” ");
INSERT INTO tof_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Da Yesu ok ninóp ibü barrbünüm. Da módóga, ene kolae samua ene pam we amgütóp, ama kyamülab bübdü we barrbünürr. Ene kyamül yabüla (ngarkwat módóga aprrapórr 2,000 kyamül blamana) buso-buso we tübabinürr buruburuana, mengrempükü ama Galili Maludü bagóbórr, ó ola nae baitóp büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ene kyamül ngabkan pama we busuóp, da pamkolpam we umul-umulan ngintinóp, Gerrasa wirri basirrdü akó madmad kabedó. Pamkolpama we ogobórr asenóm ne pokoa tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Da i Yesuka nóma togobórr, i ene pam esenóp, kolae samu ngoroa noan amgütóp. Wa we mórran yarilürr, mórrkenyórr bamelórrón akó kakal gyagüpitótóke. Da pamkolpama gum ipüdóp. ");
INSERT INTO tof_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nidi nósenóp, kolpam nüzazilóp laróga tómbapónórr ene kolae samupükü pamdó akó kyamüldü. ");
INSERT INTO tof_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Da i Yesun arüngi ato kwarilürr, tibiób bwób amgatóm. ");
INSERT INTO tof_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu butüdü nóma kasil yarilürr, kolae samu ne oloma imarrulürr, Yesun we yatorr wankü tótókóm. ");
INSERT INTO tof_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Da Yesu oya koke ok yónürr wankü tótókóm, a wa ma oya yalórr wagó, “Ugó alkomól, moba müót basirrdü, moba pamkolpamdó, da ma nüzazilnümke Lod marüka ne kla tónggapóne, ó oya ne gyaur yaril marüka.” ");
INSERT INTO tof_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Da módóga, ene pama we wamórr we bwób órdóma, ngi Dekapolis, tóba okaka bümzazilkü, oyaka Yesu ne kla tónggapónórr. Da blaman pamkolpama gübarirr aengóp. ");
INSERT INTO tof_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu akó nóma banikürr dakla malu kabedó, ola oyaka wirri pamkolpamab ngoroa kwób tóbazelórr, da i oya kal-kal yangónóp. Wa tüób malu kabedó yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Da módóga, darrü ⌊Zu pamkolpamab kwóbbazen müót⌋ ngakan pama ugón tübzilürr Yesuka, oya ngi Zaerrus. Wa Yesun nóma esenórr, wa oya wapór nis minggüpanandó simbalkalórr. ");
INSERT INTO tof_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Wa oya arüngi yatorr wagó, “Kürü kari ngul oloman büdül kari pokoa. Gyaurka, kya tam, oyaka moba tang nis amngyelóm. Ene igósüm, wa kalma dólóng baine ó ngyabene!” ");
INSERT INTO tof_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","I usakü we ogobórr. Wirri pamkolpamab ngoroa mamoan koralórr, da i Yesun kal-kal yangónónóp blaman órdógab. ");
INSERT INTO tof_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Darrpan kol óe bókan azid warilürr, 12 pailüm. ");
INSERT INTO tof_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wa kari azid koke balmilülürr, oya dokta ne merrsin uliónónóp. Wa tóba dólóng bainüm mani enan nüliónónóp, da wa morroal koke bainürr. Ene azida ma wirri bain yarilürr, blaman pailzan. ");
INSERT INTO tof_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wa Yesunbóka arrkrrurr, da wa we tübangrinürr ene pamkolpamab ngorodó, akó oya tumum mórrkenyórr we yamurrürr. ");
INSERT INTO tof_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Zitülkus módóga, wa tóbaka bóktan warilürr wagó, “Ka ne kubó wata oya tumum mórrkenyórr nóma yamurro, ka kubó dólóng baino.” ");
INSERT INTO tof_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Wa Yesun mórrkenyórr nóma yamurrürr, oya ene óe bókana ugón blakónórr. Wa tóba büb küp bamkónórr, wa dólóng kuri baine tóba ini müpdügab. ");
INSERT INTO tof_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yesu tüób dümdüman umul bainürr wagó, “Kürükagab ngibürr arünga kuri bause.” Wa nóma byalüngürr ene pamkolpamab ngorodó, da wa nümtinóp wagó, “Ia kürü mórrkenyórr nótó yamurre?” ");
INSERT INTO tof_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Oya umulbain olmala bóktan we yalkomólóp wagó, “Ngaka, ini pamkolpamab ngoroa marü kuri kal-kal mangórre. Ma iade bóktóna wagó, ‘Ia kürü mórrkenyórr nótó yamurre?’” ");
INSERT INTO tof_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu wata azil yarilürr, asenóm ene kla nótó tónggapóne. ");
INSERT INTO tof_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ene kolan büba otórrngónóm bainürr, zitülkus wa tüób umul bainürr ne klama tómbapónórr tóbaka. Wa natókórr, simbalkalórr Yesun obzek kwata, ó amkoman bóktan blaman we adrratórr oyaka. ");
INSERT INTO tof_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu oyaka bóktanórr wagó, “Kürü olom, marü moba amkoman banguna dólóng kuri mine. Natók, moboküpdü paud sab marüka asi ki yarilün. Ini azida marü sab myamem koke mümige!” ");
INSERT INTO tof_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu bóktan alakón küsil yarilürr, ngibürr pamkolpama Zaerruska ugón togobórr oya müótüdügab, da i oya ilóp wagó, “Marü olom büdülato. Ma Umulbain Pam myamem müp akyan-gu.” ");
INSERT INTO tof_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu ibü bóktan nóma arrkrrurr, wa bóktanórr Zaerruska wagó, “Ma gumgu, ma kürü wata amkoman kangu.” ");
INSERT INTO tof_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu blaman pamkolpam nólónóp wankü tótókóm. Pita a Zeims akó oya zoret Zon, wata idi ogobórr. ");
INSERT INTO tof_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","I Zaerrusün müótüdü nóma babzilürr, Yesu pamkolpamab ngoro we esenórr. I taegwarr-taegwarr yón koralórr. ");
INSERT INTO tof_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wa müótüdü nóma bangrinürr, wa ibüka bóktanórr wagó, “Ini ia laró taegwarrwóma? E iade yóndakla? Ini olom go büdül kokeo, a wa go uto.” ");
INSERT INTO tof_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","I oya we ngüóng angyalnóp, zitülkus i umul kwarilürr wagó, wa go amkoman büdülano. Yesu ene pamkolpam zirrnapónóp pulkaka. Wata wa ene oloman aipab nis akó oya aüd umulbain olmal, i usakü barrbünürr, olom ne pokodó warilürr. ");
INSERT INTO tof_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Wa oya tangdó omoanórr, da oyaka bóktanórr tibiób-tibiób wagó, “Talita, kum.” Oya küp módóga: “Kari kol, ka marü mila, ugó bupa!” ");
INSERT INTO tof_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ene pokodó, ene oloma türsümülürr akó agólóm we bainürr. Wa tüób ta 12 pail olom warilürr. Ene pokoa nóma tómbapónórr, ene oloman aipab nis akó Yesun aüd umulbain olmala karibóka-koke gübarirr aengóp. ");
INSERT INTO tof_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Da Yesu ibüka wirri arüngi bóktanórr wagó, “Kubó darrü olom azazilgu!” Akó wa bóktanórr wagó, “Oya darrü kla ugó okyenam alom.” ");
INSERT INTO tof_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu ene poko amgatórr, da ama wamórr tóbanan basirrdü Nazarret. Oya umulbain olmala we zutalórr. ");
INSERT INTO tof_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Darrü ⌊Sabad⌋ ngürrdü, wa umulbain we bókyanórr ⌊Zu pamkolpamab kwóbbazen müótüdü⌋. Abün pamkolpam kwarilürr ene pokodó. Da i oya nóma arrkrru kwarilürr, blamana gübarirr aengóp. I tibióbbóka bütünóp wagó, “Wa ini kla nubógabi ipüde? Ia ini nadü ⌊wirri gyagüpitótóka⌋, oya ne kla akyarróna? Wa ini ⌊arüng tonarr⌋ ia-ia tómbapónda? ");
INSERT INTO tof_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A wa go ene müót balmel oloma, Merrin siman olom, Zeims, Zosep, Zudas, akó Saemon ibü naret. Oya bólbótala ae ngyabendako.” Da i oya alzizi amanikóp. ");
INSERT INTO tof_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ibüka bóktanórr wagó, “Prropet wirri ngi atendako ngibürr bwóbdü, a tóbanan basirrdü, zitül pama ó müót pama ama inzan koke.” ");
INSERT INTO tof_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Yesu gübarirr aengórr, zitülkus i oya amkoman koke yangunóp. Wa darrü arüng tonarr koke igósidi tónggapónórr ola. Wata tóba tang nis aüd azid kolpamdó nómngyelórr, da ibü dólóng ninóp. Yesu ene basirr blaman nümarükóp umulbainkü. ");
INSERT INTO tof_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Da wa tóba 12 umulbain olmal tóbaka ngibaunürr. Wa ibü ninis zirrnapónóp akó balngomól arüng we nókyenóp kolae samu amanóm. ");
INSERT INTO tof_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ibü we nilóp wagó, “Yenkü wata yabiób tupuru imarrulam ini agólde, darrü kla ódódgu: alo kla, angasangap angón alóp, akó mani yabiób pam alópdó. ");
INSERT INTO tof_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","E wa wapór kla bamelam, da yabiób bübdü ne mórrkenyórrko, e wata we klamane ogob. Ngibürr amarrugu. ");
INSERT INTO tof_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","E ne müótüdü barrbuno, wata ola bamilke, kókó e ene basirr sab amgütane. ");
INSERT INTO tof_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","E ne inzan basirrdü nóma togobo igó, pamkolpama yabü ne morroal tonarre koke yazebrre, akó yabü bóktan koke ne arrkrru kwarile, ene basirr amgütamke, wapórdó buru we bainamke. Ini tonarra sab igó poko umul nirre wagó, ibü ⌊kolaean darrema⌋ sab tame Godkagab.” ");
INSERT INTO tof_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Da i we ogoblórr, pamkolpamdó bóktan amgolkü wagó, “E yabiób kolae tonarrdógab ugó tübyalüngam.” ");
INSERT INTO tof_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","I abün kolae samu aman kwarilürr akó i ⌊olib⌋ oele ang kwarilürr abün azid pamkolpamdó, da ibü dólóng we ninóp. ");
INSERT INTO tof_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Errod, ugón Galili prrobins wató alngomól yarilürr, arrkrrurr Yesu ne poko tómbapón yarilürr, zitülkus Yesun ngia bwób-bwób gwarranórr. Ngibürr pamkolpama igó bóktan kwarilürr wagó, “God Zon Baptaes Bain Pam wa büdüldügab kuri irsümüle. Da ene arünga oyaka ene zitülkusdü zagetóda wirri arüng tonarr tólbaelóm.” ");
INSERT INTO tof_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ngibürra ma bóktónóp wagó, “Wa Ilaeza-e.” Akó ngibürra wagó, “Wa prropeta, wamaka wa ngaen prropetzan kwarilürr.” ");
INSERT INTO tof_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","A Errod nóma arrkrrurr ini bóktan Yesunkwata, wa ta bóktanórr wagó, “Wa Zon Baptaes Bain Pama! Kürü gazirr pama oya singül nam itülóp wata kazan nilóp, da oya büdüldügab kuri irsümürre!” ");
INSERT INTO tof_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ngaen Errod tóba gazirr pam zirrnapónóp Zonón amiógüm, sye-i amelóm, tümün müótüdü zirrapónóm. Wa ini poko tóba kol Errodiasónbókamde tónggapónórr. Errodias ngaen-gógópan oya naret Pilipün kol warilürr, a wa ma oya gómól-gómól zumiógürr tóba kolóm. ");
INSERT INTO tof_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Errod Zonón tümün müótüdü zirrapónórr, zitülkus Zon oya bobarr igó ayal yarilürr wagó, “Ini gyabia moba naretan kol amiógüm!” ");
INSERT INTO tof_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Da Errodiasón ngürsila upadórr Zonka. Oya ubi amkalóm yarilürr, da wa gaodó koke warilürr tónggapónóm ene poko, Errodónbókamde. ");
INSERT INTO tof_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Errod Zonón gum yarilürr, zitülkus wa umul yarilürr wagó, Zon morroal akó dümdüm ngyaben pama. Wa oya igósidi adlang yarilürr. Errodón ubi Zonón arrkrrum yarilürr, da wa wirri müp gyagüpitótók ipadórr blaman ngürr wa Zonón nóma arrkrru yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Errodón amtómól ngürran tóre nóma semrranórr, Errodias kwat esenórr Zonón amkalóm. Errod ene ngürr ingrinürr alongalom. Wa alongalom ibü ngibaunürr, Galili prrobins wirri ngi pam, gazirr singüldü wirri ngi pam, akó Galili prrobins singüldü pam. ");
INSERT INTO tof_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Errodiasón óp oloma katókórr, da wa zil emkalólórr ibünkü. Wa Errodón akó wirri pam morroal barnginwóman ngintinóp. Da Errod ene ngulmokurdü bóktanórr wagó, “Ma kürü kyal, marü ubi larógóma? Ka marü mókyeno ene kla.” ");
INSERT INTO tof_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Wa oya ⌊arüng alkamül-koke bóktan⌋ uliónürr wagó, “Ma kürüka ne klamóm tóbato-o, ka wata marü mókyeno, enana marü ubi kürü tüp aodó atülüma, marü darrü poko, kürü darrü poko!” ");
INSERT INTO tof_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Da ene ngulmokura tóba aip amtinüm natókórr wagó, “Ka ia larógóm yato?” Aipa bóktan yalkomólórr wagó, “Ma Zon Baptaes Bain Pam, oya singülüm bato.” ");
INSERT INTO tof_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Dümdüman ene ngulmokura büsai-büsai we alkomólórr Errodka, da yatorr wagó, “Kürü ubi ma kürü kókyeno errkyadan aini alongalo klamdó, Zon Baptaes Bain Pam, oya singül!” ");
INSERT INTO tof_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Errod kari gyaur ta koke yarilürr, da wa ia ki badóle, zitülkus wa arüng alkamül-koke bóktan uliónürr wirri ngi pamab obzek kwata, tóre bwóbdü nidi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Dümdüman Errod tóba darrü büb ngakan gazirr pam we zirrapónórr arüng bóktanpükü Zonón singül ódódóm. Da ene pama we wamórr tümün müótüdü, Zonón singül we itülürr. ");
INSERT INTO tof_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ene kakóm, ene pama Zonón singül we sidódürr alongalo klamdó, da ene ngul olom okyanórr, ama akó nótó okyanórr tóba aip. ");
INSERT INTO tof_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Zonón umulbain olmala nóma barrkrrurr oya büdül poko, i we togobórr, oya büb we idüdóp gapókdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","⌊Apostola⌋ Yesuka tóbakonórr akó we kwób tóbazenórr, da i oya izazilóp i ne elklaza tómbapónónóp ó umulbain kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yesu ibüka bóktanórr wagó, “E yabi ugó togob kankü kolpam-koke bwóbdü, karianbóka ngón ngabagónóm.” Zitülkus módóga, abün pamkolpama kwat zwapólórr, da ibü darrü kan babul yarilürr alo alom. ");
INSERT INTO tof_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","I tibi butüdü we bamselórr, da ene poko we amgütóp kolpam-koke bwóbdü tótókóm. ");
INSERT INTO tof_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Da pamkolpama nósenóp i nóma bazebórr, ó abüna umul bainóp i nidi kwarilürr. I blamana tibiób basirrdügabi we buso kwarilürr dorro kwata, wapórane, da i ngaen-gógópan we babzilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu butüdügabi nóma banikürr, wa wirri pamkolpamab ngoro nósenóp, da wa kari gyaur koke yarilürr ibüka, zitülkus i ⌊sipzan⌋ koralórr, sip ngabkan pam babul nibiób koralórr. Da wa ibü abün poko umul bain we bókyanórr. ");
INSERT INTO tof_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Simam abüs, Yesun umulbain olmala oyaka togobórr, da i oyaka bóktónóp wagó, “Ini kolpam-koke bwóba, irrüba amzik kari pokoa. ");
INSERT INTO tof_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Da ma ini pamkolpam ugó zirrnapónónóm minggüpanan basirrdü akó madmad kabedó ne müótko, tibióbkü alo kla bumiógüm.” ");
INSERT INTO tof_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Da wa ibüka bóktan yalkomólórr wagó, “E yaib ibü ngibürr alo kla nülinam!” I oya imtinóp wagó, “Ki ia nadü manie ogobo alo kla bumiógüm? Ene wata aprrapórr 200 ⌊silba⌋ mani küp ki kwaril blaman ene pamkolpam ngabyónüm! Kibü mani gaoandó kokeako.” ");
INSERT INTO tof_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu ibü we nümtinóp wagó, “Ia yabü nigó brredako? Kya kóbó ngabkónam.” I nóma umul bainóp, da i oya we izazilóp wagó, “5 Brred akó nis wapi.” ");
INSERT INTO tof_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu ibü nilóp pamkolpam kukwin opopordó mórran-mórran bainüm kopo-kopo. ");
INSERT INTO tof_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Da blamana we bobrranórr kopo-kopo, darrü kopoan 100, darrü kopoan 50. ");
INSERT INTO tof_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu ene 5 brred akó nis wapi yazebórr, kwit yazilürr da Godón eso ekyanórr. Wa brred syórr nangónóp, da tóba umulbain olmal nülinóp ene pamkolpam gyabalómóm. Wa akó ene nis wapi inzan gyabalómórr. ");
INSERT INTO tof_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","I blamana nóma elop, ibü bikóma nólóngóp. ");
INSERT INTO tof_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Alo kakóm, umulbain olmala bamirrün alo poko dakainóp akó 12 alóp murrnausóp ene brred akó wapidügab. ");
INSERT INTO tof_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","I ne pama elop, ibü ngarkwat we kla yarilürr, 5,000. ");
INSERT INTO tof_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dümdüman ene kakóm, Yesu tóba umulbain olmal we nilóp butüdü bamselóm ó singül kwata baurrüm malu dakla kabedó, Betsaeda basirrdü. I nóma ogoblórr, wa ene pamkolpam we zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu pamkolpam yawal bóktan nóma nókyenóp, ene kakóm, wa podo kwitüdü we angürürr, tóre akom. ");
INSERT INTO tof_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Abüsazan mórralórr, but ugón malu aodó yarilürr. Yesu wa tebe yarilürr malu kabedó. ");
INSERT INTO tof_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wa umulbain olmal nóma ngabkalórr, i wirri arüngi atül kwarilürr, zitülkus wóra singül kwatagabi tubsolürr. Sis minggüpanan nóma yarilürr, wa ibüka we wamórr, nae kwitana tótókde. Ibü nórrgrrótnópma, ");
INSERT INTO tof_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","da i oya nae kwitana tótókde esenóp. Ibü gyagüpitótók wamaka mórrkea, da i taegwarr we apónóp. ");
INSERT INTO tof_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","I blaman kari gum koke kwarilürr, i oya nóma esenóp. Dümdüman Yesu ibüka bóktanórr wagó, “Moboküp karrkukus ninam! Ini kótókla. E gumgu!” ");
INSERT INTO tof_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Yesu ibüka we wamórr, butüdü kasilürr, da wóra ugón batülürr. Oya umulbain olmala wirribóka gübarirr aengóp, ");
INSERT INTO tof_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","zitülkus i tai koke umul bainóp amkoman küp brredankwata, Yesu ene 5,000 pam ia ngabyónürr ene aüdan alo klame. Ibü singül karrkukus kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I malu dakla kabedó nóma baurrürr, i we babzilürr Genesarret bwóbdü, da i but ola enomólóp. ");
INSERT INTO tof_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","I but nóma amgütóp, pamkolpama dümdüman Yesun we emzyetóp. ");
INSERT INTO tof_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pamkolpama ene bwób ór blaman we amarükóp, da i tibiób azid kolpam rraparrapa-e we barrmülürr Yesuka, i ne barrkrrurr wa ne pokodó yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Wa ne pokodó wamlórr, ia wirri basirr, kari basirr, ó didiburr, i blaman azid kolpam tübarrmülürr kwóbbazen pokodó oyaka. I oya yatop, azid kolpama wata oya mórrkenyórr zarran amurrum. Nidi yamurrnóp, i blamana dólóng we bainónóp. ");
INSERT INTO tof_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ngibürr Parrisi akó Mosesón gida umulbain pama, nidi togobórr Zerrusalemgabi, Yesun we kal-kal yangónóp. ");
INSERT INTO tof_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Da i ngibürr Yesun umulbain olmal nósenóp alode ⌊tómanpükü⌋ tange; i tibiób tang inzan koke bagulóp, Parrisiab gida-azan bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Zitülkus módóga, Parrisi akó blaman ⌊Zu pamkolpama⌋ abalbobatalab gida mamoandako: i kubó igósidi elorre kókó tang nóma bagulórre tibiób gida ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Akó i alo kla bumióg pokodógab nóma bakondako, i koke elorre, wata ngaen-gógópan i bapüre. Akó ibü ngibürr abalbobatalab gida asiko, i ne kla mamoandako. Darrü módóga, ma kübül, kurróp, brronze tónggapórrón sospen, akó alongalo mórrakós morroal bagulo.) ");
INSERT INTO tof_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Da Parrisi akó Mosesón gida umulbain pama Yesun imtinóp wagó, “Ia marü umulbain olmala mibü abalbobatalab gida koke iade mamoandako, da i ma iade alodako tómanpükü tange?” ");
INSERT INTO tof_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu bóktan yalkomólórr ibüka wagó, “Prropet Aesaya wata amkoman yarilürr, yabükwata igó ne poko bóktanórr Godón ngidü. E taepurrane bóktan pamakla. Enezan wialómórróna, “‘God igó bóktanda wagó, “Ini pamkolpama kürü taeane ⌊ótókdako⌋, a ibü moboküp ma alam kokeasko kürükagabi. ");
INSERT INTO tof_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I kürü enan küp-koke ótókdako, zitülkus i pamab bókam bagósórrón gida umul baindako, wamaka kürü gidako!” ’ ");
INSERT INTO tof_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“E Godón gida bóktan poko kabedó angrindakla, ama tüpan pamab bóktan karrkukus bumiógdakla.” ");
INSERT INTO tof_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu akó pokodó ipadórr wagó, “E kari umul kolpam kokeakla Godón gida alzizi amanóm, a e ma yabiób gida kari karrkukusi koke amorrandakla. ");
INSERT INTO tof_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ka müsirrga aindóla: Moses ta bóktanórr wagó, ‘Ma moba aipab nis morroal angón namülün.’ Akó, ‘Nadü oloma tóba aipab nis nótó nómórre, büdüldü ki ingrinam.’ ");
INSERT INTO tof_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","A e ma kolpam igó umul baindakla wagó, paman ne darrü kla asi nóma yarile tóba ab a aip nis tangamtinüm, ama kubó igó bóktóne wagó, ‘Ini korrban klama’ (oya küp módóga: ‘ini Godón akyarrón klame, oya ngi klame’), ");
INSERT INTO tof_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","e oya ok aindakla tóba aipab nis tangamtin-gum. ");
INSERT INTO tof_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Inzan morroal kokea; yabiób gida inzan karrkukus amoande, e Godón gida bóktan poko kuri alkamülane. Akó abün inzan elklaza asiko, e ne kla tómbapóndakla.” ");
INSERT INTO tof_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu akó pamkolpamab ngoro ngibaunürr tóbaka tótókóm. Wagó, “Kürü kurrkrruam blamana, e bóktanan ⌊küp ipüdam⌋! ");
INSERT INTO tof_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Darrü kla babula, pulkakakdógabi ne klama tótókda paman büb kugupidü, oya tómanan ngitanda Godón ilküpdü. Oyakagabi ne klama burruanda, oya tómanan ngitanda.” ");
INSERT INTO tof_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu ene pamkolpam nóma nümgütóp, wa müótüdü wamórr. Oya umulbain olmala ola imtinóp ene alap-alap bóktan müsirrga ainüm. ");
INSERT INTO tof_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu ibüka bóktanórr wagó, “E ia wata umul-kókanakla ini ngibürr popa pamkolpamzan? E koke kuri umul ipüdane? Darrü kla myamem babula pulkakakdógabi ne klama tótókda marü büb kugupidü marü amkoman tómanan ngitanóm, ");
INSERT INTO tof_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","zitülkus marü moboküpdü koke tótókda a marü bikómdü tótókda. Olgabi ama akó pulkakak we alkomólda, lae müótüdü.” (Ini bóktande, Yesu we müsirrga yónürr wagó, blaman alo taiako alom.) ");
INSERT INTO tof_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Wa akó we bóktanórr wagó, “Paman moboküpdügabi ne klama burruanda, oya wató tómanan ngitanda Godón ilküpdü. ");
INSERT INTO tof_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Auma moboküp kwindügab ini kolaean elklaza bausdako: kolae gyagüpitótók, kolae sarrgiwóm tonarr, gómól, pam amkal, ");
INSERT INTO tof_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kol a pam gómól, abün elklazadó ubi bain, azid alión, ilklió bülión, büódan tulmil tómbapón, gyagüp kolaea akrran, obae bóktan alión ngibürrabkwata panzedó, ikub bagür, gonggo tulmil tómbapón. ");
INSERT INTO tof_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Blaman ini ne kolae elklazako auma moboküp kwindügabi bausdako; pam idi tómanan ngitandako.” ");
INSERT INTO tof_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu olgabi we bupadórr, ama Taerr wirri basirr minggüpanan, we mogob pamkolpamab bwób órdóbóna wamlórr. Wa we bangrinürr müót kugupidü. Oya ubi babul yarilürr darrü oloma koke ki umul baine igó, wa olama. Da wa gaodó koke yarilürr aniküm. ");
INSERT INTO tof_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Darrü kol asi warilürr, oya óp oloman bübdü kolae samu yarilürr. Wa Yesunbóka nóma arrkrrurr, oyaka dümdüman we katókórr, tüpdü we simbalkalórr, Yesun wapór nis minggüpanandó. ");
INSERT INTO tof_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wa Zu kol koke warilürr. Wa Ponisia bwóbdü tómtómólórr, Sirria prrobins kugupidü. Yesun we metat yatolórr kolae samu amaniküm tóba óp olomdógab. ");
INSERT INTO tof_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu bóktan we yalkomólórr alap-alap wagó, “Ki kya ngaen-gógópan olmal ngabinünüm. Dümdüm kokea, olmalab alo azeb, ama akó umedó aman.” ");
INSERT INTO tof_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ene kola bóktan we yalkomólórr wagó, “Lod, umea tógal lorodó olmalab alo kla burul ta alodako!” ");
INSERT INTO tof_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Da Yesu ene koldó we bóktanórr wagó, “Zitülkus ma kürü amkoman angundóla, ma ugó alkomól moba basirrdü. Kolae samua marü olom kuri zumgute!” ");
INSERT INTO tof_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ene kola tóba müótüdü nóma alkomólórr, olom nyórrdü utüdi omrranórr. Amkoman ene kolae samu amanikürrün yarilürr ene olomdógab. ");
INSERT INTO tof_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu Taerr bwób nóma amgatórr, wa Saedon wirri basirrana wamórr, ama akó Galili Malu kabedó. Wa we bwób órdóma wamlórr, ngi Dekapolis. ");
INSERT INTO tof_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ngibürr pamkolpama darrü azid pam sidüdóp Yesuka, oya dólóng ainüm. Ene paman güblang akó tae murrbausürrün kwarilürr. I oya yatop tóba tang oyaka amngyelóm. ");
INSERT INTO tof_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Da Yesu ene pam pamkolpamdógab idódürr tebe-tebe pokodó. Wa tóba tang pyóm nis ene paman güblangdó zirrnapónórr, gwerr amanikürr, akó ene paman ulit we yamurrürr. ");
INSERT INTO tof_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Da Yesu kwitüdü yazilürr, wirri ngón we semanórr akó ene olomdó we bóktanórr wagó, “Epata!” oya küp módóga: “Tapabaku!” ");
INSERT INTO tof_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Dümdüman ene paman güblang nisa we tapabakurri, akó oya ulita we morroal bainürr, da wa tai bóktanóm we bainürr. ");
INSERT INTO tof_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu ene pamkolpam arüng bóktan nókyenóp wagó, “Darrü olom azazilgu!” Wa ene arüng bóktan metatzan byal yarilürr, i ma dakla ene bóktan ugón ayonóp. ");
INSERT INTO tof_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I nidi barrkrrurr, karibóka-koke gübarirr aengóp. I inzan bóktan kwarilürr wagó, “Wa blaman kla morroal tómbapónda. Wa güblang murrbausürrün olmal dólóng bainda akó tae murrbausürrün olmal bóktanan ngibtanda!” ");
INSERT INTO tof_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wirri kokrrap ngarkwat koke akó wirri pamkolpamab ngoroa darrpan pokodó togobórr Yesuka. Ibü alo kla babul yarilürr, da Yesu tóba umulbain olmal ngibaunürr da bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ka kari gyaur kokela ini pamkolpamdó, zitülkus i kankü aüd ngürr kuri amórre, da ibü darrü alo kla myamem babula. ");
INSERT INTO tof_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka ne ibü alo ngabyón-koke nóma zirrnapónónómo tibiób basirrdü, ibü kubó iltümüna kena tübyóng kwat-kwat, zitülkus ngibürra alamgabi koke togobe.” ");
INSERT INTO tof_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Oya umulbain olmala bóktan yalkomólóp wagó, “Ini kolpam-koke bwóbdü mi alo kla ia nóserre ini pamkolpam ngabyónüm?” ");
INSERT INTO tof_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu ibü nümtinóp wagó, “Yabü ia nigó brredako?” I bóktan yalkomólóp wagó, “7 Brredako.” ");
INSERT INTO tof_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu pamkolpam tüpdü mórranóm we nilóp. Da wa ene 7 brred yazebórr, Godón eso ekyanórr, syórr nangónóp, da tóba umulbain olmal nülinóp alo gyabalómóm ene pamkolpam. Da ibü we nülinóp. ");
INSERT INTO tof_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ibü ngibürr kari wapipókal asi kwarilürr. Yesu Godón eso ekyanórr ene wapim, da tóba umulbain olmal nilóp pamkolpam gyabalómóm. ");
INSERT INTO tof_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I nóma elop, ibü blaman bikóma nólóngóp. Da umulbain olmala 7 alóp murrnausóp, ne alo pokoa baminürr. ");
INSERT INTO tof_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Da i aprrapórr 4,000 pamkolpam kwarilürr. Yesu ibü we zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Dümdüman ene kakóm, wa tóba umulbain olmalpükü butüdü we kasilürr, ama Dalmanuta bwób órdóbóna we wamórr. ");
INSERT INTO tof_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ngibürr Parrisia Yesuka togobórr, da ibü ikika we bókyanórr. Ibü ubi oya apókóm yarilürr, da i oya imtinóp darrü kwitümgab wirri tulmil tónggapónóm igó poko amtyanóm wagó, oya arüng amkoman Godkagabia. ");
INSERT INTO tof_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu wirri ngón we semanórr, da we bóktanórr wagó, “Ini lüólan pamkolpama wirri tulmilüm iade atodako? Ka yabü amkoman poko byaldóla: ini lüólan pamkolpamabkü darrü wirri tulmil tónggapórrón koke yarile!” ");
INSERT INTO tof_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","I Parrisi we nümgütóp, butüdü bamselórr, we ogoblórr ama dakla malu kabedó. ");
INSERT INTO tof_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Umulbain olmalab bamrükürr dokyanan brred amarrum inkü. Wata darrpan brred yarilürr butüdü. ");
INSERT INTO tof_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu ibü arüngi ikik nókrrónóp wagó, “E ta mamka! E umul-umul kwarilün Parrisi akó Errod, ibü istabkwata.” ");
INSERT INTO tof_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I tibiób we ikik koralórr wagó, “Wa igósidi bóktanda, zitülkus mibü brred myamem babula.” ");
INSERT INTO tof_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu umul bainürr i ne poko bóktan kwarilürr, da ibü nümtinóp wagó, “E iade ikikdakla wagó, ‘Mibü brred myamem babula.’? E ia ⌊küp apad⌋ akó umul bain küsilanakla? Yabü singül ia wata karrkukusanako? ");
INSERT INTO tof_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yabü ilküküp asiko, da e koke iade asendakla? Yabü güblang asiko, da e koke iade arrkrrudakla? Yabü ia koke ngambangólda, ");
INSERT INTO tof_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ka ne 5 brred syórr nangónarre 5,000 pam ngabyónüm? E ene bamirrün alo pokodógab ia nigó alóp murrnausnarre?” I bóktan we yalkomólóp wagó, “12.” ");
INSERT INTO tof_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Yesu ibü akó nümtinóp wagó, “Ka 7 brred nóma syórr nangónarre 4,000 pamkolpam ngabyónüm, e ene bamirrün alo pokodógab ia nigó alóp murrnausnarre?” I bóktan we yalkomólóp wagó, “7.” ");
INSERT INTO tof_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Wa ibü nümtinóp wagó, “Da e wa küp apad küsilanakla?” ");
INSERT INTO tof_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I nóma togobórr Betsaeda basirrdü, ngibürr pamkolpama ilküküp murrbausürrün pam sidüdóp Yesuka, da i oya yatop ene pam amurrum. ");
INSERT INTO tof_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu ene ilküküp murrbausürrün pam tangdó emoanórr, da basirr kabedó idódürr. Wa oya ilküküp nisdü gwerr amanórr, tóba tang nis nómngyelórr ene pamdó, da oya imtinürr wagó, “Ma ia darrü kla asendóla?” ");
INSERT INTO tof_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ene pama kwit yazilürr, da bóktanórr wagó, “Ó, ka kolpam basendóla, da i wamaka nugupa agóltagóldako.” ");
INSERT INTO tof_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu akó tóba tang nis ene paman ilküküp nisdü nómngyelórr. Ini tonarr ene pama tóba ilküküp morroal nóbzelórr. Oya ilküküp nisa dólóng bairri, da wa blaman kla morroal nósenóp. ");
INSERT INTO tof_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu ene pam müótüdü zirrapónórr igó bóktanpükü wagó, “Ma basirrdü alkomólgu.” ");
INSERT INTO tof_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu tóba umulbain olmalpükü wamlórr ngibürr basirrdü, Sesarria Pilipi wirri basirran minggüpanan. Kwat-kwat Yesu ibü nümtinóp wagó, “Kürü kilam, pamkolpama ia bóktandako, ka nótókla?” ");
INSERT INTO tof_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","I bóktan yalkomólóp wagó, “Ngibürr pamkolpama igó bóktandako wagó, ma Zonla, ⌊Baptaes Bain⌋ Pam. Ngibürra ma igó bóktandako wagó, ma prropet Ilaezala, a ngibürra go wagó, ma darrü prropetla.” ");
INSERT INTO tof_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Wa ibü nümtinóp wagó, “A yadi, e wa ia gyagüpi tótókdakla, ka nótókla?” Pita oyaka bóktan yalkomólórr wagó, “Ma ene ⌊Kerrisola⌋.” ");
INSERT INTO tof_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu ibü arüng bóktan we nókyenóp wagó, “Darrü olom azazilgu kürükwata.” ");
INSERT INTO tof_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu tóba umulbain we bókyanórr wagó, “Ka, Pamkolpamab Olom nótókla, sab abün-abün azid aeng namulo. ⌊Balngomól byarrmarr pam⌋, ⌊wirri prrist⌋, akó Mosesón gida umulbain pama kürü wata alzizi kümaniknórre. Sab kürü büdülümpükü kómkólórre a aüd ngürr kakóm God kürü sab kürsümüle büdüldügab.” ");
INSERT INTO tof_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wa ini poko ibüka kwasirrgana bóktanórr. Da Pita oya tebe-tebe pokodó idódürr, da wa oya agórr. ");
INSERT INTO tof_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yesu tübyalüngürr, tóba umulbain olmal ngabkalórr, da Pitan agórr wagó, “Yaya kürükagab, satani, ma kakota alkomól! Zitülkus módóga, ma Godón elklaza koke gyagüpi amandóla, a marü gyagüpitótók tüpan elklazadóma.” ");
INSERT INTO tof_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Da Yesu pamkolpamab ngoro akó tóba umulbain olmal ngibaunürr tóbaka. Wa ibüka bóktanórr wagó, “Nadü oloman ubi yarile kürüka solkwat akyanóm, wa tóbabóka imrüke. Wa tóba krros bügasile azid aengóm kazan, ó kürüka solkwat tókyale. ");
INSERT INTO tof_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Zitülkus módóga, nadü olom ubi yarile tóba tüpan arról zid ainüm, wa sab tóba ⌊ngarkwat-koke arról⌋ imrüke. A nadü oloma sab tóba tüpan arról imrüke kürübókamde akó Morroal Bóktananme, wa sab tóba ngarkwat-koke arról zid ine. ");
INSERT INTO tof_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ia laró morroala, darrü pama ini tüpan elklaza blaman azebóm, a tóbanan ngarkwat-koke arról ma ki imrüke? ");
INSERT INTO tof_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ia darrü kla asine, wa tóba ngarkwat-koke arról sab ia salkomóle? Babula! ");
INSERT INTO tof_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ini tonarr ngyabende, abün pamkolpama Godón wata taeane ⌊ótókdako⌋, da i dakla ma ngibürr obae god bütókdako. I ta abün kolae tonarr tómbapóndako. Nadü oloma büód aengda kürükwata akó kürü bóktanankwata, ka, Pamkolpamab Olom nótókla, sab ta büód aengo oyakwata, ka sab kólba Aban ⌊wirri kómal zyónpükü⌋ nóma tamlo, gyabi anerrupükü.” ");
INSERT INTO tof_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu akó ibüka bóktanórr wagó, “Ka yabü amkoman poko byaldóla: e ngibürr aini nidipakla bórrangórrón, sab koke nurrbarino kókó God ini tüp Kingzan alngomól nóma bókyene wirri arüngpükü.” ");
INSERT INTO tof_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","6 Ngürr kakóm, Yesu ibü yazebórr, Pita, Zeims, akó Zon. Wa ibü imarrurr wirri pododó. I wata tibi kwarilürr ene pokodó. Ibü obzek kwata oya büba darrü tonarr bainürr. ");
INSERT INTO tof_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Oya mórrkenyórra ongang bapón yarilürr gabülplie. Darrü oloma ini tüpdü kokean igule inzan gabülplie. ");
INSERT INTO tof_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Da módóga, Ilaeza akó Moses ibüka we okaka tübyórri, akó i Yesukü ikik koralórr. ");
INSERT INTO tof_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita Yesuka bóktanórr wagó, “Umulbain Pam, mi morroal ainizanakla! Ki kubó aüd twal müót ki balmerre, darrü marünkü, darrü Mosesónkü, darrü Ilaezankü.” ");
INSERT INTO tof_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Wa ene poko bóktanórr, zitülkus wa umul-kók yarilürr, wa ia poko ki bóktóne, zitülkus i kari gum koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Da módóga, pülpül pokoa we tamórr ibü sisingül, akó oya dandanga ibü blaman nganolop. Akó bóktan bómgóla we sidórükürr ene pülpül pokodógabi wagó, “Ini kürü kólbanan Olome. Kürü ⌊moboküpdü ubi⌋ oyakama. Ka kari bagürwóm kokela oyaka. Oya bóktan amkoman ipadólamke!” ");
INSERT INTO tof_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ugósan umulbain olmala Ilaeza akó Mosesón ilküküpane nóma nyamkünóp, i ibü myamem koke nósenóp, wata Yesun tóbanan esenóp. ");
INSERT INTO tof_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","I pododógabizan tübabilürr, Yesu ibü arüng bóktan nókyenóp wagó, “Darrü olom azazilgu, e ne kla esenane, ngarkwat kókó sab ka, Pamkolpamab Olom nótókla, nóma türsümulo büdüldügab.” ");
INSERT INTO tof_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I oya bóktan ipüdóp, da i tibi we ikik kwarilürr wagó, “Büdüldügab barsin küp ia tai laróga?” ");
INSERT INTO tof_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Da i Yesun we imtinóp wagó, “Mosesón gida umulbain pama iade bóktandako wagó, Ilaeza sab ngaen-gógópan wató tame akó ⌊Kerriso⌋ ama solodó tame?” ");
INSERT INTO tof_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Wa ibüka bóktan yalkomólórr wagó, “Ilaeza wa ta ngaen-gógópan tótókda, ugósüm blaman elklaza tibiób gaodó akonóm. Da Godón Wialómórrón Bóktana ta igó bóktanda kürükwata wagó, ‘Pamkolpamab Oloma sab abün-abün azid aenge akó oya alzizi amaniknórre.’ ");
INSERT INTO tof_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","A ka yabü igó byaldóla, Ilaeza wa kuri tamórr. Pamkolpama tibiób ubidügab tómbapónónóp oyaka, wata Godón Wibalómórrón Bóktana enezan bóktanda.” ");
INSERT INTO tof_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Da Yesu akó tóba aüd umulbain olmala nóma tóbakonórr ngibürr umulbain olmaldó, wirri pamkolpamab ngoro nósenóp ibü kal-kal angórrón. I ta ngibürr Mosesón gida umulbain pam nósenóp inkü ongyalde. ");
INSERT INTO tof_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ene pamkolpama Yesun nóma esenóp, i karibóka-koke gübarirr aengóp. I oyaka busuóp, da oya morroal ngürr ekyenóp. ");
INSERT INTO tof_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu tóba umulbain olmal nümtinóp wagó, “E ini Mosesón gida umulbain pampükü ia poko ongyaldakla?” ");
INSERT INTO tof_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Darrü pama pamkolpamab ngorodógab bóktan we yalkomólórr wagó, “Umulbain Pam, ka kólba olom sidüda marüka, zitülkus oyaka kolae samua, akó wa koke bóktanda. ");
INSERT INTO tof_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Oya bübdü ne kubó kolae samua nóma bangrine, kubó tüpdü singalkóle, tae godeapükü, akó kubó zirrgüp bótak yarile kókó büba dümdümbarr bainesa. Ka marü umulbain olmal nümtinünüma kolae samu amaniküm, a ibü gaodó koke yaril.” ");
INSERT INTO tof_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu blamandó bóktan yalkomólórr wagó, “E amkoman bangun-koke lüól pamkolpamakla! Ka ia yenkü nadüzan ngarkwat ngyabelo? Kürüka kari müp kokea metat yenkü ngyabenóm yabü amkoman bangun kokede. Ene olommokur sidüdam kürüka!” ");
INSERT INTO tof_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","I ene olom Yesuka sidüdóp. Ene kolae samua Yesun nóma esenórr, dümdüman olommokur amanikürr, oya iltümüna tupürr. Wa tüpdü simbalkalórr, we arrgoben yarilürr, tae godeapükü. ");
INSERT INTO tof_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu oya ab imtinürr wagó, “Ia wa inzan nadüzan ngarkwat kuri ngyabenórr?” Oya aba inzan bóktan yalkomólórr wagó, “Oya wata karimokurdügab. ");
INSERT INTO tof_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kolae samua oya abün münüm urdü amaiklürr akó naedó yanggóbólólórr oya amkalóm. Ma kibü gyaur ipa, akó ma gaodó ne nóma namulo darrü kla tónggapónóm, kibü tangtamtinünümo!” ");
INSERT INTO tof_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu akó oyaka bóktanórr wagó, “Ma ia larógóm bóktóna, ‘ma gaodó ne nóma namulo’? Blaman elklaza tómbapón popadanako kürü amkoman angundi.” ");
INSERT INTO tof_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Da aba dümdüman wirribóka taegwarr apónórr wagó, “Ka go marü amkoman angundóla, da ma ka gaodó kokela. Kürü tangkamti kürü amkoman bangun wirri ainüm!” ");
INSERT INTO tof_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesun ubi babul yarilürr abün pamkolpama koke ki eserre, wa ia laró tónggapóne. Wa nóma esenórr darrü pamkolpamab ngoroa busorr darrpan pokodó, da wa dümdüman kolae samu we agórr wagó, “Güblang arrkrru-koke akó tae-koke samu, ka marü arüng bóktan akyandóla, ugó tubrra ini olommokurdügab. Ma myamem oyaka bangrin-gu!” ");
INSERT INTO tof_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kolae samua wirribóka taegwarr apónórr, ene olommokur wirribóka we inurr. Oya iltümüna tupürr. Ene samua we tubrranórr, da ene olommokur büdülzan yarilürr. Abün pamkolpama bóktanónóp wagó, “Büa, a büdüla!” ");
INSERT INTO tof_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","A Yesu ma ene olommokur tangdó emoanórr, kwit yónürr, we zamngólórr. ");
INSERT INTO tof_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu müótüdü nóma bangrinürr, oya umulbain olmala tibi-tibi pokodó imtinóp wagó, “Ia ki gaodó koke iade korala kolae samu amaiküm?” ");
INSERT INTO tof_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ibüka bóktanórr wagó, “Wata tórea amaik yarile inzan kla. Darrü kla myamem babula.” ");
INSERT INTO tof_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesu tóba umulbain olmalpükü ene bwób amgatórr, ama Galili prrobinsdüma wamórr. Wa ubi koke yarilürr, darrü pama koke ki umul baine, wa ne yarilürr, ");
INSERT INTO tof_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","zitülkus wa tóba umulbain olmal umul nyónónóp. Wagó, “Darrüpa kürü, Pamkolpamab Olom nótókla, sab pamkolpamab tangdó küngrine. I sab kürü büdülümpükü kómkórre, da aüd ngürr kakóm ka ugón türsümulo.” ");
INSERT INTO tof_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A i ma Yesun bóktanan ⌊küp tai koke ipüdóp⌋. Akó i tib gum kwarilürr oya amtinüm. ");
INSERT INTO tof_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yesu akó tóba umulbain olmala ogobórr kókó Kaperrna-um wirri basirrdü, solkwat barrbünürr müótüdü. Yesu tóba umulbain olmal nümtinóp wagó, “E kwatódó ia poko ongyal kwarila?” ");
INSERT INTO tof_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","I oyaka bóktan koke yalkomólóp, zitülkus tibiób ongyal kwarilürr we bóktan pokodógab wagó, ia amkoman wirrian nótóke. ");
INSERT INTO tof_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu mórran-mórran bainürr, da tóba 12 umulbain olmal we ngibaunürr. Ibü we nilóp wagó, “Nadü oloman ubi yarile singüldü tótókóm, wa solodó ki yaril, akó wa blaman pamkolpamab popa tangbamtin pam ki yaril.” ");
INSERT INTO tof_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Da wa kari olom ipadórr, zamngól-zamngólan we yónürr tibiób aodó. Tóba tang nisi kari olom errgótanórr, ibü we nilóp wagó, ");
INSERT INTO tof_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Inzan kari olom morroal tonarre nótó nóma apadóda kürü ngidü, enta igósa, wa kürü morroal tonarre apadóda. Ó kürü morroal tonarre nótó nóma apadóda, kürü kólbanan morroal tonarre koke apadóda, a wa oya ta inzan morroal tonarre apadóda, kürü nótó zirrkapónórr.” ");
INSERT INTO tof_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zon bóktanórr Yesuka wagó, “Umulbain Pam, ki darrü pam eserre kolae samu amande pamkolpamdógabi marü ngidü. Ki oya piküp ainüm kain kwarilürr, zitülkus wa minkü kokea.” ");
INSERT INTO tof_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","A Yesu ma ibü nilóp wagó, “E oya piküp ain-gu, zitülkus darrü pam babula ⌊arüng tonarr⌋ tómbapónóm kürü arüngi, solkwat kubó ma kolae bóktan yarile kürükwata. ");
INSERT INTO tof_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Zitülkus módóga, mibüka koke nótó bóka bamgünda, wa igósidi mibüne. ");
INSERT INTO tof_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ka yabü amkoman poko byaldóla: yabü ne sab nae nótó nóma nókyerre anónóm, zitülkus e kürünakla, Kerriso nótókla, ene oloma sab tóba darrem kla kokean arene. ");
INSERT INTO tof_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Inzan wa kolae yarile darrü pamankü igó, pamkolpama wirri kugupi bapórrón ingülküp ki amrókrre oya gepkodó, ama ki amanikórre maludü. A oyaka sab ne klama tómbapóne, wa popa olom, kürü amkoman nótó angunda, kolae tonarr tónggapónóm nóma elngomóle, ene wa kari kolae ta koke yarile. ");
INSERT INTO tof_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Marü darrü tanga ne kolae tonarr tónggapónóm nóma müdüde, da itül. Ma darrpan tangpükü ⌊ngarkwat-koke arróldó⌋ nóma bangrino, ene ma tai kolae kokea. A ma nis tang nispükü ⌊metat bólmyan urdü⌋ nóma wamo, ene amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Marü darrü wapóra ne kolae tonarr tónggapónóm nóma müdüde, da itül. Ma darrpan wapórpükü ngarkwat-koke arróldó nóma bangrino, ene ma tai kolae kokea. A marü nis wapór nispükü metat bólmyan urdü nóma mumanikórre, ene amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Akó marü darrü ilküpa ne kolae tonarr tónggapónóm nóma müdüde, da irrua. Ma darrpan ilküppükü ene bwóbdü nóma bangrino, God ne balngomólda Kingzan, ene ma tai kolae kokea. A marü nis ilküp nispükü metat bólmyan urdü nóma mumanikórre, amkoman kolaean yarile. ");
INSERT INTO tof_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ene pokodó, ‘ibü ne kupula olongóle, sab kokean nurrbarine, akó ibü ne ura badüngle, sab kokean bütamüne.’ ");
INSERT INTO tof_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Solta ⌊urdü agasil lar⌋ ⌊kolkal⌋ ainda. Dadan ngarkwatódó, pamkolpam müpa nóma bumiógda ibü ngyaben tonarrdó, ene müpa wamaka ura baebda, ibü moboküp kolkal ainüm. ");
INSERT INTO tof_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Solt wa morroala, a solt misa ne nóma bamrüke, da ma myamem misan koke ngitino. “Solta alozan morroal ainda, e yabiób ngyaben sab ta inzan morroal ninamke. Akó e ta paud ngyabenam yabiób darrpan-darrpandó.” ");
INSERT INTO tof_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Da Yesu Kaperrna-um wirri basirr we amgatórr, ama Zudia bwóbdübóna wamórr, da Zodan tobarr we banikürr ama dakla dorrodó. Pamkolpam ngoroa akó we kwób tóbazenórr oyaka, da wa ibüka we bóktan yarilürr, wa bobarrzan umul nyónónóp. ");
INSERT INTO tof_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ngibürr Parrisia oyaka we togobórr. Ibü ubi oya amiógüm yarilürr tóba bóktandógab. Da i oya imtinóp wagó, “Ma kibü kóbó tüzazilnüm, mibü gidadógab ia taia, pama kol amaiküm?” ");
INSERT INTO tof_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu bóktan yalkomólórr wagó, “Moses yabü ia nadü gida bóktan poko nókyenóp?” ");
INSERT INTO tof_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Da i bóktan yalkomólóp wagó, “Moses darrü pam ok yónürr kol amaik peba mórrag wialómóm akó oya we klampükü amaiküm.” ");
INSERT INTO tof_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ibüka bóktanórr wagó, “Moses ini gida bóktan poko yabünkü igósidi wialómórr, zitülkus e Godón gida bóktan poko mamoanóm kokeanómakla. ");
INSERT INTO tof_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Da bwób zitüldü, God blaman elklaza nóma tómbapónórr, ‘Wa ibü igó tónzapónórr, pam a kol.’ ");
INSERT INTO tof_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Da ini zitülkusdü pama tóba aipab nis nümgüte, ama tóba koldó dabine, ");
INSERT INTO tof_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","da i ama darrpan bübüm baini.’ Igósidi i nis kokeamli, a ma darrpanamli. ");
INSERT INTO tof_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","God ne kla dayónda darrpan pokodó, pama kokean nürrgrrüte.” ");
INSERT INTO tof_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","I müót kugupidü nóma kwarilürr, umulbain olmala Yesun akó we imtinóp ene dadan bóktanankwata. ");
INSERT INTO tof_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Wa ibüka bóktanórr wagó, “Nadü pama tóba kol zumanike, akó darrü kol zumige, wa kol gómól yarile. Inzande wa kolae tonarr tónggapóne tóba ngaen koldó. ");
INSERT INTO tof_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kola ta inzan: wa müór nóma amaike, ama akó darrü müór nóma amige, wa pam gómól warile.” ");
INSERT INTO tof_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ngibürr pamkolpama kari olmalpókal tübarrmülürr Yesuka, ibü singüldü tang amelóm. Da umulbain olmala ma ene kolpam we nagóp amarrugum. ");
INSERT INTO tof_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu ene kla nóma esenórr, da wa ngürsilüm bainürr. Wa umulbain olmaldó bóktanórr wagó, “Kari olmalpókala ki togob kürüka! E ibü burrmatgu, zitülkus Godón Kingzan Balngomól ibünse, inzan olmalpókal nidipko. ");
INSERT INTO tof_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ka yabü amkoman poko byaldóla: Godón Kingzan Balngomól koke nótó apadóda kari olomzan, sab kokean bangrine.” ");
INSERT INTO tof_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wa ene olmalpókal tóbaka simarrurr, darrpan-darrpandó tóba tang nis nómngyelórr, da ibü we bles ninóp. ");
INSERT INTO tof_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu akó tótókóm bupadlórrma kwatódó, da pama ugón tubsorr, wakósingül nülkamülürr oya obzek kwata, da imtinürr wagó, “Morroal Umulbain Pam, ka ia kaino ⌊ngarkwat-koke arról⌋ apadóm?” ");
INSERT INTO tof_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu oya we imtinürr wagó, “Ia ma kürü morroalbóka iade ngiklina? Darrü morroal olom babula, wata God tebea. ");
INSERT INTO tof_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ma Godón gida bóktan pokobóka umulóla wagó, ‘Ma darrü olom büdülümpükü amkalgu, ma kol ó pam gómólgu, ma gómólgu, ma obae tiz bóktan adrratgu darrü olomankwata, ma ilklió bülión-gu, ma moba aipab nis morroal angón namülün.’” ");
INSERT INTO tof_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ene pama we bóktanórr wagó, “Umulbain Pam, ene tonarrdógab ka karimakur nóma namülnürrü, ka ini blaman gida bóktan poko amkoman amorran namülnürrü.” ");
INSERT INTO tof_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu dümdüman oya ngakanórr akó Yesun ⌊moboküpdü⌋ ubi oyaka yarilürr. Da wa bóktanórr wagó, “Marü dóma wata darrpan klama. Ma ugó wam, moba blaman elklaza sel ninünümke, da mani sab elklaza-koke kolpam nülinünümke. Sab igósidi marü mórrel ma kwitüm yarile. Da yao, kürüka tókyanke.” ");
INSERT INTO tof_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wa ene bóktan nóma arrkrrurr, oya mólmóna tupürr. Wa gyaurpükü we wamórr, zitülkus oya abün elklaza kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu tóba umulbain olmal ngabkanórr akó ibüka bóktanórr wagó, “Sab kari müp koke yarile mórrel pamkolpamab Godón Kingzan Balngomóldó barrbünüm!” ");
INSERT INTO tof_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Oya umulbain olmala gübarirr aengóp ene bóktan pokodógab. Da Yesu akó bóktanórr wagó, “Kürü olmal, ene go kari müp ta kokea Godón Kingzan Balngomóldó bangrinüm! ");
INSERT INTO tof_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","⌊Kamelan⌋ nabea nil tótórrana bangrinüm, a mórrel paman ma amkoman nabeana Godón Kingzan Balngomóldó bangrinüm.” ");
INSERT INTO tof_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Umulbain olmala wirribóka gübarirr aengóp, da tibiób darrpan-darrpan we bamtinóp wagó, “Da ma ia sab nótó zid baine?” ");
INSERT INTO tof_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ibü dümdüman ngankónóp, bóktan we yalkomólórr wagó, “Pamakanankü gaodó ta kokea tómbapónóm, wata God tebea; zitülkus Godka ma blaman kla gaodómako.” ");
INSERT INTO tof_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Da Pita oyaka bóktanórr wagó, “Ma turrkrru, ki blaman elklaza oloknórró marüka atanóm!” ");
INSERT INTO tof_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu bóktanórr ibüka wagó, “Ka yabü amkoman poko byaldóla: nadü oloma tóba müót basirr, zonaretal, bólbótal, aipab nis, olmal, akó tüp bimgüte kürünkü akó Godón Morroal Bóktananme, ");
INSERT INTO tof_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wa sab 100 münüm yazeble ene elklaza ini ngyaben tonarrdó. Wa sab abün inzan elklaza yazeble; müót basirr, zonaretal, bólbótal, aipal, olmal, akó tüp. Akó oya sab wirri müp alión kwarile Godón zagetanme. Akó sab ugórr ne tonarra tame, wa ta sab ngarkwat-koke arról ipüde. ");
INSERT INTO tof_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Abün singül kwata nidipako, sab ma solodó kwarile, ó abün solodó nidipako, sab ma singül kwata kwarile.” ");
INSERT INTO tof_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu akó tóba umulbain olmalpükü Zerrusalem wirri basirr kwatódó yarilürr, ola nóma bamselólórr. Yesu ibünkü wató singül apónórr. Umulbain olmala gübarirr aengóp, akó ibüka solkwat nidi tutalórr, ibü ta guma yazebórr. Yesu akó tóba 12 umulbain olmal tebe-tebe pokodó we imarrurr ibüka bóktanóm, oyaka sab ne klama tómbapóne. ");
INSERT INTO tof_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Wagó, “Tübarrkrru! Mi Zerrusalem bamseldakla. I sab kürü, Pamkolpamab Olom nótókla, wirri prrist akó Mosesón gida umulbain pam, ibü tangdó ola küngrirre. Kürü büdül bóktan sab ola kókyerre, olgabi ama akó Zu-koke nidipko, ibü tangdó ugón küngrirre. ");
INSERT INTO tof_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I kürü sab we ⌊tiz kangónórre⌋, gwerr kótóngnórre, akó karrkukus sye-i kyólnórre, da kürü kómkórre büdülümpükü. Aüd ngürr kakóm, ka sab ugón türsümulo büdüldügab.” ");
INSERT INTO tof_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zeims a Zon, Zebedin siman olom nis nidi namülnürri, Yesuka turrürri, da i bóktarri wagó, “Umulbain Pam, kibü ubi ma darrü kla sab tónggapono kibünkü, ki ne klamóm batodamli.” ");
INSERT INTO tof_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu ibü nümtinürr wagó, “Yabü ubi ka ia laró tónggapono yabünkü?” ");
INSERT INTO tof_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Da i oyaka bóktan yalkomórri wagó, “Ma kibü ugó ok tió marü minggüpanan mórranóm, darrüpa marü tutul kwata, darrüpa marü banól kwata, ma ne sab moba ene ⌊wirri kómal zyón⌋ marrgudü nóma mórran-mórran baino.” ");
INSERT INTO tof_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ibüka bóktanórr wagó, “E umul-kókamli e larógóm batodamli. E ia gaodómamli ene müp ódódóm, ka ne müp ódóddóla? Da e ia gaodómamli ene wirri azidüdü bangrinüm, ka ne azidüdü bangrinüm kaindóla?” ");
INSERT INTO tof_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","I bóktan yalkomórri wagó, “Ki gaodómamli.” Yesu ibüka bóktanórr wagó, “Amkoman, e ene müp sab idüdi, ka ne müp ódóddóla, da e sab ene wirri azidüdü bangrini, ka ne azidüdü bangrinüm kaindóla. ");
INSERT INTO tof_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","A kürü gaodó kokea yabü ok ainüm mórranóm kürü tutul kwata akó kürü banól kwata. Sab God wató nókyene ene marrgu nis, wa nibióbkü kuri tónzapónórr.” ");
INSERT INTO tof_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Da ene 10 ngarkwat umulbain olmala nóma barrkrrurr, ibü ngürsila yazebórr Zeims a Zon ibüka. ");
INSERT INTO tof_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Da Yesu ibü blaman ngibaunürr tóbaka. Wa bóktanórr ibüka wagó, “E umulakla, Zu-koke nidipako, ibü amzyatórrón singüldü pama pamkolpam zirrbapón-bapón balngomóldako, akó ibü wirri pama ibü wirri arüngi balngomóldako. ");
INSERT INTO tof_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Da yabüka inzan babula. Nadü oloman ubi yarile wirri ngim bainüm yabü aodó, wa yabü blamanab popa tangbamtin pam ki yaril; ");
INSERT INTO tof_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","akó yabükagab singüldü tótókóm nótó nóma yarile, wa yabü blamanab ⌊leba zaget olom⌋ ki yaril. ");
INSERT INTO tof_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Zitülkus módóga, ka, Pamkolpamab Olom nótókla, ta igósidi koke tamórró igó, pamkolpama kürü popa tangamtin kwarile. Koke! Ka pamkolpam popa tangbamtinüm tamórró, kólba arról abün pamkolpamabkü darrem akyanóm, ibü arról akonóm kolae tonarrdógab.” ");
INSERT INTO tof_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu tóba umulbain olmal akó wirri pamkolpamab ngoropükü Zerriko wirri basirr nóma arrgrrat yarilürr, darrpan ilküp murrbausürrün bato pama kwat kabedó mórran yarilürr. Oya ngi Barrtimeius, Timeiusün olom. ");
INSERT INTO tof_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Barrtimeius nóma arrkrrurr wagó, Yesu Nazarret olom we kwat mamoanda, wa górrganóm bainürr wagó, “Yesu, ⌊Deibidün⌋ Olom, kürü gyaur kóse!” ");
INSERT INTO tof_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Abün pamkolpama oya agóp, da ilóp piküp bainüm. A wa ma górrganóm tai arüng ipadlórr wagó, “⌊Deibidün Olom⌋, kürü gyaur kóse!” ");
INSERT INTO tof_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu zamngólórr, da bóktanórr wagó, “Oya ngyaunam, ala ki tam.” Da i ene ilküp murrbausürrün pam we ngyaunóp. I oya ilóp wagó, “Ma arüng ipa! Ugó bupa, Yesu marü ngyaunda.” ");
INSERT INTO tof_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Da wa tóba tumum mórrkenyórr we amaikürr, büsai we bupadórr, Yesuka we wamórr. ");
INSERT INTO tof_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu oya imtinürr wagó, “Ia marü ubi ka marünkü laró tónggapono?” Ilküp murrbausürrün pama bóktan we yalkomólórr wagó, “Umulbain pam, kürü ubi akó basenóma.” ");
INSERT INTO tof_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu oya yalórr wagó, “Ma ugó wam, marü moba amkoman banguna dólóng kuri mine.” Dümdüman oya ilküp nisa tomgorri, da wa Yesuka we akyanórr. ");
INSERT INTO tof_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesup Zerrusalem wirri basirr nóma ngorram yónónópma, i nis basirr we nómrranónóp, ngi Betpage akó Betani, ⌊Olib Podo⌋ kabedó, Yesu tóba umulbain olom nis ngaensingülan we zirrnapónórr, ");
INSERT INTO tof_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ini bóktanpükü wagó, “E ugó aurram kókó yabü singül kwata ne basirrse. E kubó nóma bangrini, dümdüman e ⌊donki⌋ kyam eseni, sye-i amrókrrón, darrü pama koke ne klamdó kuri kasile ódódóm. Kubó agoamke, da ala sidüdamke. ");
INSERT INTO tof_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Darrü oloma ne yabü nóma nümtine wagó, ‘E iade agodamli?’ kubó igó ilamke magó, ‘Lod ini klamóm sógóse. Da wa kalma büsai salkomóle.’” ");
INSERT INTO tof_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Da i aurrürri ó ene donki kyam i eserri kwat kabedó, müót mamtae minggüpanan, sye-i amrókrrón. I enezan ago namülnürri, ");
INSERT INTO tof_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ngibürr pamkolpama nidi bórrang kwarilürr, ibü nümtinóp wagó, “Yabü ia laró dümdüma we donki kyam agom?” ");
INSERT INTO tof_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","I bóktan we yalkomórri Yesu ibü enezan nyalórr, da ene pamkolpama ibü we ok ninóp tótókóm ene donki kyampükü. ");
INSERT INTO tof_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ene donki kyam we sidódrri Yesuka. I tibiób tumum mórrkenyórr we nüdrratrri ene donki kyam kwitüm. Yesu donki kyamdó we kasilürr, da oya kwitüm mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wa enezan wamlórr, abün pamkolpama tibiób tumum mórrkenyórr we zursilürr kwatódó oya morroal apadóm. Ngibürra pórngaepükü kari nugup tiz singgalgónóp, kwatódó apapdó kla, da Yesun kwatódó we zursilürr. ");
INSERT INTO tof_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Singül kwata nidi ogoblórr akó solkwat nidi zutalórr wirri bóktane we yagürnóp wagó, “Mi Godón yagürnórre! Wa bles airrüna, Lodón ngidü nótó tótókda. ");
INSERT INTO tof_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ngaen mibü ab king ⌊Deibidzan⌋ balngomól yarilürr, oya bobat Yesu mibü sab inzan balngomól yarile! God ene ngürr sab bles ine! Mi Wirri Kwitüm Godón yagürnórre!” ");
INSERT INTO tof_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu Zerrusalem abzilürr, akó ⌊Godón Gyabi Müótan⌋ kal akólórrón pul basirrdü we bangrinürr. Wa ola blaman elklaza ngabkan yarilürr. Da wa tóba 12 umulbain olmalpükü we alkomólórr Betani basirrdü, zitülkus irrüba amzik kari poko yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Darrü ngürr, i Betani nóma amgütóp, kwat-kwat Yesun aloa ipadórr. ");
INSERT INTO tof_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Wa osenórr, wirri kandógab, darrü pig nugup, pórngaea ngalaorrón warilürr. Da wa we wamórr ngakanóm wagó, oya küp ia asiko. Wa nóma wamórr oya minggüpanan, wa pórngaean nósenóp, zitülkus ene oya amkoman waon ngarkwat koke warilürr. ");
INSERT INTO tof_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu ene nugup wyalórr wagó, “Darrü oloma sab myamem darrü küp koke elo-e marükagab.” Da oya umulbain olmala arrkrruóp. ");
INSERT INTO tof_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","I Zerrusalem nóma babzilürr, Yesu Godón Gyabi Müótan kal akólórrón pul basirrdü bangrinürr. Wa ene kolpam kolabütanóm we bainürr, nidi sel bain akó nidi bumióg kwarilürr. Mogob pamkolpamab mani nidi sensi bangón kwarilürr, Yesu ibü tógal okaka we izazilürr. Gainao póyae nidi sel bain kwarilürr, ibü mórran klampükü ta izazilürr. ");
INSERT INTO tof_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Wa darrü olom koke ki ok ine elklaza amarrum Godón Gyabi Müótan pul basirrana. ");
INSERT INTO tof_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Wa kolpam we umul bain yarilürr wagó, “Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Kürü Müót sab wata inzan ngilian kwarile wagó, pamkolpamab tóre müót blaman bwób-bwóbabkü.’ A e ma igó kuri inane, wamaka gómól pamab ban bwóbe!” ");
INSERT INTO tof_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wirri prrist akó Mosesón gida umulbain pama nóma barrkrrurr ini bóktan, i ma ngibürr kwat byamkünónóp oya amkalóm. Zitülkus módóga, i oya gum kwarilürr, zitülkus blaman pamkolpama gübarirr aengóp oya umulbaindügab. ");
INSERT INTO tof_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Abüsa bótaom nóma kain yarilürr, Yesu tóba umulbain olmalpükü ene wirri basirr we amgatórr. ");
INSERT INTO tof_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Darrü irrbianande, i nóma togoblórr kwatana, i osenóp ene pig nugup. Wa büdül warilürr tai simkündügab kókó ta solo amrran. ");
INSERT INTO tof_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitan ngambangólórr Yesun ene bóktan pokoa, da wa Yesuka bóktanórr wagó, “Iba, ma ngaka! Umulbain Pam, ma ne pig nugup zomórra, odalda!” ");
INSERT INTO tof_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu ibüka bóktan we yalkomólórr wagó, “Amkoman yangunam Godón. ");
INSERT INTO tof_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ka yabü amkoman poko byaldóla: darrü oloma ne ini podo igó nóma ile wagó, ‘Ma ugó bupa, da moba bumanik maludü,’ a ene oloman moboküpdü abün-abün gyagüpitótók koke kwarile, a wa amkoman yangune wagó, wa ne poko bóktóne sab amkoman tómbapóne, da ene oloma sab ene kla igósidi esene. ");
INSERT INTO tof_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ini zitülkusdü, ka yabü igó byaldóla, e tóredó ne klamóm yatoane, amkoman yangunamke e ene kla kuri ipüdane, da e igósidi sab esenane. ");
INSERT INTO tof_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Akó e nóma tóre kwarilo, e pamkolpamab kolae tonarr barrgon kwarilünke, i yabüka ne kolae tómbapóndako. Ene igósüm, yabü kolae tonarr yabü kwitüm Aba sab ta igósidi norrgorre.” ");
INSERT INTO tof_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu tóba umulbain olmalpükü akó Zerrusalem abzilürr. Wa Godón Gyabi Müótan kal akólórrón pul basirrdü nóma agóltagól yarilürr, wirri prrist, Mosesón gida umulbain pam, akó ⌊balngomól byarrmarr pama⌋ oyaka we togobórr. ");
INSERT INTO tof_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Da we imtinóp wagó, “Ma ini elklaza ia nadü balngomól arüngi tómbapóndóla? Marü ini arüng ia nótó mókyanórr ini elklaza tómbapónóm?” ");
INSERT INTO tof_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu ibüka bóktanórr wagó, “Ka yabü darrpan bamtin bóktan poko bamtindóla. Kürüka morroal bóktan kóbó salkomólam, da ka yabü umulüm igósidi adrrüto, ka ini elklaza nadü arüngi tómbapóndóla. ");
INSERT INTO tof_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kürü küzazilam: Zonón ⌊baptaes baina⌋ ia kwitümgab tamórr, ta ia pamdógab?” ");
INSERT INTO tof_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I tibiób ini bamtin bóktan pokoankwata we apón kwarilürr wagó, “Mi ne igó nóma kwarilo wagó, ‘Kwitümgab,’ wa kubó mibü tümtirre wagó, ‘Da e ma oya amkoman angunüm koke iade koralnórró?’ ");
INSERT INTO tof_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","A mi ne igó nóma kwarilo igó, ‘Pamdógab,’ pamkolpam kubó ngürsil kwarile mibüka.” (Ene wirri pama pamkolpamab gum kwarilürr, zitülkus blaman pamkolpama Zonón igó yangunóp wagó, wa amkoman prropeta.) ");
INSERT INTO tof_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Da i bóktan we yalkomólóp Yesuka wagó, “Ki umul-kókakla.” Yesu ibüka bóktanórr wagó, “Ka ta yabü koke nüzazilnümo igó, ka ini elklaza ia nadü arüngi tómbapóndóla.” ");
INSERT INTO tof_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu bókyanórr wirri pamdó alap-alap bóktan wagó, “Darrü pama abün grreip zid iritürr tóba tüpdü. Ene kakóm, wa kal akólórr. Wa kugupi ilüngürr ene grreip ngórr mor amóngóm, da wa barrkyanan kwit azil müót elórr, tóba grreip kaldó olgab azilüm. Da wa ene grreip apap ngibürr ngaon pam nókyenóp ngakanóm tibiób darremóm akó tóbankü. Tüób ama aibwób wamórr. ");
INSERT INTO tof_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Grreip ngórr abül tonarr nóma semrranórr, wa tóba darrü ⌊leba zaget⌋ pam we zirrapónórr ene pamdó, grreip apap nidi ngakan kwarilürr, ngibürr grreip ngórr azebóm ene apapdógab. ");
INSERT INTO tof_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","A i ene leba zaget pam amigóp, dom apónóp, da popa we zirrapónóp tang küpan. ");
INSERT INTO tof_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ene apap aba akó darrü leba zaget pam we zirrapónórr. I oya singülan we emkólóp akó oya kolae büódan poko tómbapónóp. ");
INSERT INTO tof_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Wa akó darrü leba zaget pam we zirrapónórr. I oya büdülümpükü we emkólóp. Wa abün leba zaget pam we zirrnapónóp. Ene grreip apap ngakan pama ngibürr zaget pam dom napónónóp ó ngibürr büdülümpükü okrralórr. ");
INSERT INTO tof_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dómdóm dama aban tóba darrpanan moboküpdü siman olom yarilürr. Da wa oya zirrsapónórr ibüka ini gyagüpitótókpükü wagó, ‘I kürü olom sab morroal tonarre yangórre.’ ");
INSERT INTO tof_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ene grreip apap ngakan pama ma tibióbka igó bóktónóp wagó, ‘Ene olom módóga, ini grreip apap sab nótó ipüde. Yao! Mi errkya büdülümpükü amkaldakla ó oya aban elklaza ama mibü kwarile aban büdül kakóm!’ ");
INSERT INTO tof_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Da módóga, i oya siman olom we amigóp, büdülümpükü we emkólóp, ó oya büb apap kalkuma we amaikóp. ");
INSERT INTO tof_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ene grreip apap aba ia laró tónggapóne? Wa sab tüób tame, da ene grreip apap ngakan pam sab ekrróne büdülümpükü a ene apap ama ngibürr pam nókyerre ngakanóm. ");
INSERT INTO tof_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","E ta ini poko kürükwata etóngarre Godón Wibalómórrón Bóktandó wagó, “‘Müót balmel pama ne ingülküp alzizi amaiknóp, errkya ma ene müótan zirrgüpdü ingülküpüm wató kuri baine. ");
INSERT INTO tof_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Lod ini kla tüób tónggapónórr, da mibü ilküpdü kari morroal ta kokea!’” ");
INSERT INTO tof_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wirri prrist, Mosesón gida umulbain pam, akó ⌊balngomól byarrmarr pama⌋ kwat we yamkünónóp Yesun amiógüm, zitülkus i umul bainóp wagó, Yesu ini alap-alap bóktan ibükwata adrratlórr. A i ma pamkolpamab gum kwarilürr. Da módóga, i oya we amgütóp ó we ogobórr tibiób kwata. ");
INSERT INTO tof_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wirri pama ngibürr Parrisi akó Errodón mamoan pam Yesuka zirrnapónóp, Yesun amiógüm tóba bóktandógab. ");
INSERT INTO tof_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","I oyaka babzilürr, da we bóktónóp wagó, “Umulbain Pam, ki umulakla wagó, ma amkomanla akó pamkolpamab gyagüpitótóka marü koke gum-guman ngitandako. Ki umulakla zitülkus, ma blaman pamkolpam, ia wirri pam, kari pam, wata darrpan ngarkwatódó ngabkandóla, a ma Godón kwat amkoman umul byóndóla pamkolpamdó.” I oya imtinóp wagó, “Mibü gidadógab ia taia Sisan taks mani aliónüm, ta ia koke? Mi ilirres ó ta ia koke?” ");
INSERT INTO tof_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A Yesu ma umul bainürr, i wata taepurrane bóktan kwarilürr, da ibü nilóp wagó, “Ia e kürü kólba bóktandógabi amiógüm iade kaindakla? Darrü ⌊silba⌋ mani küp ala sidüdam, ka kóbó ngakanón.” ");
INSERT INTO tof_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","I oyaka darrpan küp we idüdóp, da wa ibü nümtinóp wagó, “Ia noan obzeke akó ngi?” I oya bóktan we yalkomólóp wagó, “Sisan.” ");
INSERT INTO tof_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Da Yesu ibüka bóktanórr wagó, “Sisan ne klamko, Sisan ilinamke, akó Godón ne klamko, Godón ilinamke.” Da i gübarirr aengóp Yesun bóktanankwata. ");
INSERT INTO tof_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ngibürr ⌊Sadusi pama⌋ Yesuka togobórr amtin bóktan poko amtinüm, amkoman moboküpi koke. Ini pama igó bóktan kwarilürr wagó, pamkolpama sab koke tübarsile büdüldügab. I Yesuka we bóktónóp wagó, ");
INSERT INTO tof_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Umulbain pam, Moses igó gida bóktan poko wialómórr mibünkü, Zu pamkolpamabkü wagó, ‘Paman narezoreta ne nóma nurrótóke olmal basen-koke, ene pama sab ene kóble ki zumióg, olmal balngenóm tóba büdül narezoretan ngidü.’ ");
INSERT INTO tof_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Da módóga, ngaen 7 zonaretalpükü pam kwarilürr. Nareta kol zumiógürr, da wa nurrótókórr, olmal-koke. ");
INSERT INTO tof_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Olgabi, naretódógab nótó tókyalórr, naretan kóble zumiógürr, da nurrótókórr. Akó aüd ngim siman oloma zumiógürr akó nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Blaman ene 7 zonaretalpükü pama zumgütóp, ibü olmal babul. Dómdóm ene kóblea ta we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sab büdüldügab barsin tonarrdó, ia wa sab tai noan kol warile? Ki ene poko amtindakla, zitülkus ene 7 blamana oya zumigóp.” ");
INSERT INTO tof_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu ibüka bóktan yalkomólórr wagó, “E kle-kle gyagüpi tótókdakla! E umulakla iade? Zitülkus módóga, e umul-kókakla Godón Wibalómórrón Bóktan akó Godón arüng. ");
INSERT INTO tof_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Büdüla nóma tübarsile arróldó, i sab myamem tibiób koke bumiógnórre, a i ma sab inzan kwarile wamaka kwitüm anerruako. ");
INSERT INTO tof_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ka akó igó poko bóktanón büdülab barsinankwata. E ta Mosesón pebadó etóngarre, kari nugupan baeb póepdó, God Moseska ia bóktanórr wagó, ‘Ka Eibrra-amón God, Aesakón God, akó Zeikobón God.’ ");
INSERT INTO tof_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Wa büdül pamkolpamab God koke-e, a wa arról pamkolpamab Gode. E wata amkoman kle-kle gyagüpi tótókdakla!” ");
INSERT INTO tof_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Darrpan Mosesón gida umulbain pam ola asi yarilürr, ibü ikik bóktan nótó arrkrrurr. Wa umul yarilürr wagó, Yesu ibüka morroal bóktan yalkomólórr. Da wa Yesun amtinüm we tamórr wagó, “Ia wirrian nadü gida bóktan pokoa, ngibürr Godón gida bóktan pokodógab?” ");
INSERT INTO tof_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu bóktan yalkomólórr oyaka wagó, “Wirrian gida bóktan poko módóga, ‘Isrrael, tübarrkrru! Lod, mibü God, wata darrpan God watóka. ");
INSERT INTO tof_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Marü ⌊moboküpdü ubi⌋ asi ki yarilün Lodka, marü God, moba dudu moboküpi, dudu samu-i, dudu gyagüpitótóke, akó dudu arüngi.’ ");
INSERT INTO tof_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nis ngim gida bóktan poko módóga, ‘Marü moboküpdü ubi moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane. Myamem darrü wirri gida bóktan poko babula ini nis gida bóktan pokodógab.’” ");
INSERT INTO tof_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ene Mosesón gida umulbain pama Yesuka bóktanórr wagó, “Ma morroal bóktan salkomóla kürüka, Umulbain Pam; wa amkoman mazan bóktóna. ‘Wata darrpan God watóka, darrü God myamem babula. ");
INSERT INTO tof_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Marü moboküpdü ubi asi ki yarilün Godka dudu moboküpi, dudu gyagüpitótóke, akó dudu arüngi, akó marü moboküpdü ubi moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane.’ Kari morroal kokea ini nis gida bóktan poko nis apadóm. Ma ini nis gida bóktan poko nis koke nóma nüpüdo, ma Godón darrü ⌊urdü amsel lar⌋ akó dudu bóngan ⌊gyaur kla⌋ sab enan ilino, zitülkus wa igósidi bagürwóm koke yarile marüka.” ");
INSERT INTO tof_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu nóma esenórr, ene oloman bóktan kari morroal koke yarilürr, wa oyaka bóktanórr wagó, “Ma Godón Kingzan Balngomóldógab aibwób-kokela.” Ene solkwat, i gum kwarilürr Yesun ngibürr poko amtinüm. ");
INSERT INTO tof_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesu ⌊Godón Gyabi Müótüdüzan⌋ nóma umul bain yarilürr, wa bóktanórr wagó, “Gida umulbain pama igó iade bóktandako wagó, ene Kerriso, wa ⌊Deibidün⌋ olome? ");
INSERT INTO tof_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Godón Samua king Deibidün igó tangamtinürr ini bóktan wialómóm wagó, “‘Lod God igó bóktanórr kürü Lodódó wagó, “Ma ae mórra kürü tutul tangdó, kókó ka sab marüka nidi bóka bamgündako, marü wapór-o lorodó irrbuno.” ’ ");
INSERT INTO tof_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deibid tüób Kerrison ngilianórr wagó, ‘Lod.’ Da Kerriso Deibidün olom iadea?” Wirri pamkolpamab ngoroa Yesun bóktan arrkrru kwarilürr barnginwómpükü. ");
INSERT INTO tof_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wa ibü nóma umul ninóp, wa bóktanórr wagó, “E umul-umul kwarilün Mosesón gida umulbain pamabkwata. I ubi baindako tibiób kokrrapan mórrkenyórrpükü agóltagólóm akó pamkolpama ibü morroal ngürr bóktan aliónüm pul basirrdü. ");
INSERT INTO tof_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","I ta ubi baindako wirri pamab mórran pokodó mórranóm mibü kwóbbazen müótüdü akó mórranóm wirri pamab mórran bwóbdü alongalo tóredó. ");
INSERT INTO tof_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I gómól tizi kóbleab müót akó elklaza azebdako akó kokrrap tóre bakodako pamkolpama basenóm. Ini pama sab ⌊kolaean darrem⌋ kari koke ipüdórre Godkagab.” ");
INSERT INTO tof_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu we mórran-mórran bainürr Godón Gyabi Müótan kal akólórrón pul basirrdü, pamkolpama mani ne arrbün kwarilürr, da wa ibü ngabkan yarilürr. Abün mórrel pamkolpama wirri ngarkwat mani urrbulürr. ");
INSERT INTO tof_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Darrü elklaza-koke kóblea natókórr, da wa nis kari mani küp nüngrinürr, ngibürr toea amrran ngarkwat. ");
INSERT INTO tof_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu tóba umulbain olmal ngibaunürr tóbaka, da bóktanórr wagó, “Ka yabü amkoman poko byaldóla: ini elklaza-koke kóblea barrkyanan ingrine ene mani arrbün klamdó, nidi sirrbürre, ibü blamandógab. ");
INSERT INTO tof_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ka ini poko bóktóna, zitülkus blaman ini pamkolpama tibiób mórreldógab irrbürre. A ini elklaza-koke kóblea, wa blaman we kla ingrine, tóba ngyaben ne klame ki idüde.” ");
INSERT INTO tof_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu Godón Gyabi Müótüdügabizan tubrranórr, oya darrpan umulbain pama we bóktanórr wagó, “Umulbain Pam, ngaka! Ma ini amkoman wirri ingülküp ó amkoman wirri müót ngankónónóm!” ");
INSERT INTO tof_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu bóktan yalkomólórr wagó, “Ma ini ne wirri müót basendóla? Sab darrü ingülküpa aini kokean bamine tóba pabodó. Blaman sab amarrón kwarile ama tüpdü.” ");
INSERT INTO tof_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ene kakóm, Yesu ⌊Olib Pododó⌋ mórralórr, Godón Gyabi Müót dakla kabe. Da Pita, Zeims, Zon, akó Endrru oya amtin kwarilürr tibi-tibi pokodó. ");
INSERT INTO tof_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Oyabóka wagó, “Ma kibü tüzazilnüm ini klama sab nóma tómbapórre? Akó kibü sab laróga umul-umulan ngisitirre igó, ini elklaza tómbapónóm baindasko?” ");
INSERT INTO tof_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu ibüka bóktanórr wagó, “E umul-umul kwarilün, sab darrü olom ok ain-gu yabü ilklió büliónüm ibü amkoman bangunüm. ");
INSERT INTO tof_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Abüna sab kürü ngidü togoble igó bóktankü wagó, ‘Ka watókla, ene ⌊Kerriso⌋, e noan akyandakla.’ I sab abün pamkolpam ilklió nüliónórre. ");
INSERT INTO tof_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Da e arrkürrgu e igó nóma barrkrrulo wagó, bwób-bwóba tibiób bókrrandako, akó ngibürr bóktan gazirrankwata. Ini klama sab ki tólbaelnóm Godón tóba bóktan ngarkwatódó, a tüpan blakón tonarr wa küsila. ");
INSERT INTO tof_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Darrü kantrri pamkolpama sab darrü kantrri pamkolpampükü bókrrale. Darrü kingan gazirr pama sab darrü kingan gazirr pampükü gazirr kwarile. Bwób-bwób sab tüpa mórrbaeng yarile akó wirri ku kwarile. Ini elklaza sab inzan kwarile, wamaka kola ngaen-gógópan azid nóma apadódo marrna bain minggüpanan. Ene azid ngaen-gógópan karia, ama solkwat tai wirri baile. ");
INSERT INTO tof_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“E yaib umul-umul kwarilünke! Yabü sab wirri pamab tangdó urrbule kotóm. Yabü sab ola okrrale tibiób kwóbbazen müótüdü. Kürübókamde e sab kotóm bórrongo gabena akó king, ibü obzek kwata, ibüka Morroal Bóktan amgolóm kürükwata. ");
INSERT INTO tof_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Da blakón ngarkwata solkwat ki tam, e akó ngibürr pamkolpama ngaen-gógópan Morroal Bóktan kürükwata amgolólamke blaman bwób-bwób. ");
INSERT INTO tof_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","I sab yabü kotódó nóma imarrunórre akó wirri pamab tangdó irrbürre, e singül kwata gyakolaegu e sab ia poko bóktónane. Ene tonarrdó, bóktónamke wata Godón Samua sab yabü ne bóktan nülirre. Zitülkus módóga, yabü kubó ne bóktan yarile, yabü yabióbankagab koke yarile. Ene bóktana sab Godón Samudügab tame. ");
INSERT INTO tof_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pamkolpama sab tibiób zonaretal wirri pamab tangdó urrbule büdüldü arrbünüm, akó abala ta sab dadanzan kairre tibiób olmaldó. Olmala sab tibiób aipalabaldó bóka bamgün kwarile akó ibü ta sab inzan wirri pamab tangdó urrbule büdüldü arrbünüm. ");
INSERT INTO tof_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Blaman pamkolpama sab yabü alzizi zomale, zitülkus e kürü mamoandakla. A kürü amkoman angunüm karrkukus nótó zamngólda kókó blakón tonarrdó, God sab oya zid ine.” ");
INSERT INTO tof_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yesu akó bóktanórr tóba umulbain olmaldó wagó, “E sab ngazirr kla esenane, ene pokodó zamngólórrón, zamngól-koke bwóbdü. Ene ngazirr klama sab ene poko amkoman ⌊tómanan⌋ ngitine Godón ilküpdü.” (Atang olom nótóke, wa ini bóktanan küp tai ki sipa!) “Ini klama sab nóma tómbapóne, Zudiam nidipako, sab podopükü bwóbdü ki busunüm. ");
INSERT INTO tof_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mórrkakak kwitüm ne olome, wa koke ki abi ó tóba müót kugupidü koke ki bangri darrü kla apadóm. A wa büsai ki buso tóba zid bainüm. ");
INSERT INTO tof_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ngaon bwóbdü ne olome, koke ki alkomól tóba müótüdü, tumum mórrkenyórr apadóm. A wa büsai ki buso. ");
INSERT INTO tof_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sab kari kolae koke yarile ene ngürrdü bikómpükü akó ngómrin kolabkü! ");
INSERT INTO tof_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","E inzan tóre bako kwarilün Godka wagó, ini kolaea koke ki tómbapó güb melpaldó. ");
INSERT INTO tof_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Zitülkus módóga, ene ngürran ne müpko sab kari kolae koke kwarile, pamkolpama koke kuri ne kla azid aengóp, ngaen zitüldügab, God ini tüp nóma tónggapónórr, kókó errkya. Myamem akó inzan kla babul yarile. ");
INSERT INTO tof_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Lod ene kolae ngürrab ngarkwat sab tugup tünggürre. Wa ne koke nóma ki tugup tünggürre, darrü oloma kokean ki zid baine. Tóba alearrón pamkolpamab gyaurdügab, wa ene kolae ngürr sab igósidi tugup tünggürre. ");
INSERT INTO tof_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Darrü oloma ne yabüka igó nóma bóktóne wagó, ‘Ngakónam, ene Kerriso yóni!’ ó ‘Ngakónam, ene Kerriso módóga!’ - oya bóktan amkoman angun-gu. ");
INSERT INTO tof_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Zitülkus módóga, obae kerriso akó obae prropeta sab togoble. I sab ⌊wirri tulmil⌋ akó ⌊basen-koke tórrmen⌋ tómbapón kwarile pamkolpam ilklió büliónüm kle-kle kwatódó tótókóm. I ta Godón alearrón pamkolpam ilklió büliónüm kain kwarile. ");
INSERT INTO tof_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","E umul-umul kwarilün, zitülkus ka yabüka ngaen-gógópan blaman bóktan kuri pupo ninünüma! ");
INSERT INTO tof_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Da ene ngürrdü, ene müp tonarr kakóm, abüsa sab tümünüm baine. Melpalan ta sab zyón myamem babul yarile. ");
INSERT INTO tof_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Wimurra sab pülpüldügabi tóbalókle, akó pülpüldü ne arüng klamko, i sab mórrbaengóm bairre akó i tibiób pabo sab bimgütórre. ");
INSERT INTO tof_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","I sab kürü ugón kóserre, Pamkolpamab Olom nótókla, pülpül pokopükü tótókde, kólba wirri arüng akó kómal zyónpükü. ");
INSERT INTO tof_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ka sab kólba anerru ugón zirrtapónónómo blaman bwób-bwób ini tüpdü, solomamtaedó, bolmüótüdü, malubarrdó akó dorrmetódó, Godón alearrón pamkolpam darrpan pokodó dakasum.” ");
INSERT INTO tof_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yesu wagó, “Kya pig nugupa yabü kóbó ki umul ninünüm alap-alap bóktane. Oya il tiza óe-óe akó saul nóma bairre, akó küsil pórngaea bamgolóm nóma bairre, da e umul kwarilo wagó, pail minggüpanana. ");
INSERT INTO tof_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Da enta inzana, e ini basen-koke elklaza tómbapónde nóma nósenane, e sab umul kwarilo wagó, Pamkolpamab Olom alkomól kari pokoa, wa kuri tame kókó mamtaedóma. ");
INSERT INTO tof_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ka yabü amkoman poko byaldóla: ini lüólan pamkolpama sab kokean nurrbarine, kókó ini blaman elklaza sab tómbapórre. ");
INSERT INTO tof_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tüp a pülpüla sab bamrüki, a kürü ne bóktane sab kokean bamrüke. ");
INSERT INTO tof_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Darrü olom umul babula ene ngürr ó abüs küp ngarkwat nóma semrróne. Kwitüm anerru ta umul kokeako. Akó ka, Aban olom nótókla, ta umul-kókla. Wata Ab umul tebease. ");
INSERT INTO tof_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","E umul-umul akó aerr kwarilün, zitülkus e umul-kókakla kürü alkomól tonarra wa nóma tame. ");
INSERT INTO tof_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Wa sab inzan yarile, wamaka darrü pama tóba müót amgatódase darrü bwóbdü tótókóm. Wa tóba ⌊leba zaget⌋ pam balngomól arüng nülirre elklaza ngabkanóm. Wa darrpan-darrpan zaget nülirre tómbapónóm, akó wa mamtae ngakan pam ingrine azilüm. ");
INSERT INTO tof_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Da e ta azil kwarilün, zitülkus e umul-kókakla müót pama sab nóma tolkomóle, aprrapórr tai abüsa mórran kakóm, irrüb zokrrok, sisa anin küsil, ó abüsa nóma tübanike. ");
INSERT INTO tof_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wa ugósan ne nóma tolkomóle, wa yabü utüdi koke ki tómrrónónóm. ");
INSERT INTO tof_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ka yabü ne poko byaldóla, da ka blaman pamkolpamdó bóktandóla wagó, e azil kwarilün!” ");
INSERT INTO tof_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","⌊Büdül Kórzyón Tóre⌋ akó ⌊Ist-koke Brred Tóre⌋ dómdóm nis ngürr nóma namülnürri, wirri prrist akó Mosesón gida umulbain pama bóktan we tónggapón kwarilürr Yesun amiógüm piküpan akó büdülümpükü amkalóm. ");
INSERT INTO tof_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tibióbbóka wagó, “Mi ini poko tóre tonarrdó koke tónggapórre, zitülkus pamkolpama sab mibüka ngürsilüm kena bainünüm.” ");
INSERT INTO tof_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu ugón Saemonón müótüdü yarilürr, Betani basirrdü. Saemon tüób ngaen soso azid pam yarilürr. Yesu nóma alo yarilürr, darrü kola ugón katókórr. Wa darrü wirri darrem ingülküpi tónggapórrón bele sidódürr, morroal ilang idipükü, ⌊kolkal⌋ nade tónggapórrón. Kari darrem idi koke yarilürr. Ene kola bele taepurr amkenórr, da ene idi Yesun singüldü we ekanórr. ");
INSERT INTO tof_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ngibürr pamkolpama ngürsilüm bainóp, da i darrpan-darrpan we bóktan kwarilürr wagó, “Wa ia laró zitülkusdü popa akando ini morroal ilang idi? ");
INSERT INTO tof_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ini idi ne nóma ki sel irre 300 silba mani küpüm, da ene mani küp ama elklaza-koke kolpam ki nülirre.” Ene kol wirribóka zwagóp. ");
INSERT INTO tof_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu ibüka bóktanórr wagó, “Oya olkomólam! E oya larógóm müp akyandakla? Wa amkoman morroal tonarr tónggapóne kürüka. ");
INSERT INTO tof_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zitülkus módóga, elklaza-koke kolpam sab yabüka metat ae kwarile, akó yabü ubi nóma yarile, e ibü sab tangnamtinamke. A ka wa sab yabüka metat ae koke namulo. ");
INSERT INTO tof_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wa umul ne klamo, wa wata we kla tónggapóne. Wa ene morroal ilang idi kürü bübdü igósidi ekóne, zitülkus wa kürü büb morroal ine, gapókdó angrin ngarkwat sab nóma semrróne. ");
INSERT INTO tof_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da ka yabü amkoman poko byaldóla: sab ne kürükwata Morroal Bóktan nótó amgol yarile ini tüpdü, wa ta sab ini poko adrrüte, ini kola ne poko tónggapóne. Pamkolpama sab oya igósidi gyagüpi zumaniknórre.” ");
INSERT INTO tof_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Da módóga, Zudas Iskarriot, darrü Yesun 12 umulbain olmaldógab, we wamórr wirri prristdü, Yesun ibü tangdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","I ene bóktan nóma barrkrrurr, i wirri barnginüm we bainóp, da i oya ⌊alkamül-koke bóktan⌋ ekyenóp mani akyanóm. Da módóga, Zudas kwat we yamkülürr Yesun ibü tangdó angrinüm. ");
INSERT INTO tof_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ngaen-gógópan Ist-koke Brred Tóre ngürrdü, Zu pamkolpama ⌊sip⌋ kupo nóma ekrrónóp Büdül Kórzyón Tóreankü, Yesun umulbain olmala oya imtinóp wagó, “Marü ubi, ki nubó ogobo alo kla tómbapónóm marünkü Büdül Kórzyón Tóre alo alom?” ");
INSERT INTO tof_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu tóba nis umulbain olom nis we zirrnapónórr, igó bóktanpükü wagó, “Ugó bangrinam Zerrusalem wirri basirrdü, da darrü pama kubó yabü tómrróne mariti tónggapórrón nae bele ódódde tóba tupodó. Kubó oyaka solkwat akyalamke. ");
INSERT INTO tof_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Wa ne müótüdü bangrine, da ene müót olom kubó ilamke magó, ‘Umulbain Pama marü ini bamtin bóktan poko kümtine wagó, “Kürü alongalo marrgu ia nega, ka kubó ene Büdül Kórzyón Tóre alo ne elo-o kólba umulbain olmalpükü?” ’ ");
INSERT INTO tof_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da wa kubó yabü nómtyene darrü ene müótan wirri marrgu, kwitana paugdü, morroal tónggapórrón. Blaman alongalo elklaza akó mórrakós olamako. Da ola kubó blaman elklaza tómbapónamke mibü alom.” ");
INSERT INTO tof_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ene nis umulbain olom nisa Zerrusalem bangrirri, da nósenóp blaman elklaza wata ibü Yesuzan nyalórr. Da módóga, i elklaza we tómbapórri Büdül Kórzyón Tóre alongaloankü. ");
INSERT INTO tof_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Irrübazan tumziklürr, Yesu tóba 12 umulbain olmalpükü ugón tamórr. ");
INSERT INTO tof_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","I nóma alo kwarilürr, Yesu ibüka we bóktanórr wagó, “Ka yabü amkoman poko byaldóla: darrüpa yabükagab, minkü nótó aloda, kalma kürü wirri pamab tangdó wató küngrine.” ");
INSERT INTO tof_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ini bóktana umulbain olmal gyaur-gyauran ngintinóp, da i darrpan-darrpana Yesun we imtinónóp wagó, “Ia kótó kokela?” ");
INSERT INTO tof_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ibüka bóktan we yalkomólórr wagó, “Yabü 12dógabi darrpan olom asine, kubó ne tóba brred poko kankü ne nótó yanggóbóle kübüldü. ");
INSERT INTO tof_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ka, Pamkolpamab Olom nótókla, sab nurrótoko, Godón Wibalómórrón Bóktana enezan bóktanda kürükwata. A Godón ngürsila sab tame ene olomdó, Pamkolpamab Olom wirri pamab tangdó nótó ingrine. Kari morroal koke ki yaril, ene oloma koke ki tómtómóle!” ");
INSERT INTO tof_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","I nóma alo koralórr, Yesu dudu brred ipadórr, akó Godón eso akyan kakóm, wa syórr yangónórr. Wa tóba umulbain olmal poko nülinóp ini bóktanpükü wagó, “Ipüdam, eloam; ini kürü bübe.” ");
INSERT INTO tof_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wa akó waenpükü kübül ipadórr, akó Godón eso akyan kakóm wa ibü nókyenóp. I blamana we enónóp. ");
INSERT INTO tof_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu ibüka we bóktanórr wagó, “Ini kürü óe-e. Wirri arüng akyanda Godón ⌊alkamül-koke tónggapórrón bóktan⌋. Sab tópkóne abün pamkolpamab morroalóm. ");
INSERT INTO tof_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ka yabü amkoman poko byaldóla: ka sab waen myamem koke enono, kókó ene ngürrdü, ka ene küsil waen sab nóma enono Godón Kingzan Balngomóldó.” ");
INSERT INTO tof_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Da módóga, i Godón wórr we atop. Ene kakóm, i we ogobórr ⌊Olib Pododó⌋. ");
INSERT INTO tof_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ibübóka wagó, “E kubó blamana busuane ó kürü kubó kólbanan kümgütane, zitülkus Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Ka sab sip ngabkan pam büdülümpükü sómkolo, da ene sipa sab popa barsene.’ ");
INSERT INTO tof_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","A kürü sab nóma kürsümüle büdüldügab, ka sab wamópo yabü singül kwata Galili prrobinsdü.” ");
INSERT INTO tof_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita oyaka bóktan yalkomólórr wagó, “Enana i blamana kubó busurre, ka marü kokean mimgüto!” ");
INSERT INTO tof_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu Pitaka we bóktanórr wagó, “Ka marü amkoman poko ayaldóla: siman karrakarra póyaea ini irrüb nis münüm bóktan küsil nóma yarile, da ma kalma aüd münüm kalpino igó, ma kürübóka umul-kókla.” ");
INSERT INTO tof_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pita oyaka wirri arüngi we bóktanórr wagó, “Ka kubó igó poko kokean bóktono, ka marübóka umul-kókla. Kürü mankü nurrótók ta taia!” Akó blaman umulbain olmala ta inzan bóktan kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","I we ogobórr darrü bwób, ngi Getsemani. Yesu we bóktanórr tóba umulbain olmaldó wagó, “E ae bobrra, kazan tórem kaindóla.” ");
INSERT INTO tof_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wa tóba aüd umulbain olmal yazebórr, Pita, Zeims, akó Zon. Yesun bübdü wirri gyaur akó müp gyagüpitótóka we togobórr. ");
INSERT INTO tof_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Da wa ibüka we bóktanórr wagó, “Kürü moboküpdü kari gyaura koke kuri tübangrine, wamaka ka büdülüm kaindóla. E ae bobrra, da dakla aerr koralón.” ");
INSERT INTO tof_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wa karianbóka küór amanórr, we simbalkalórr tüpdü, da tóre inzan ekorr wagó, wa ne gaodó nóma yarile, wa ene tonarrdó inzan wirri kolaedó koke wame. ");
INSERT INTO tof_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wagó, “Ba, kürü Ab. Blaman elklaza marüka popadanako. Kürü ini wirri azidüdüma ódódgu. A kürü ubia koke ki tómbapó, a wa marü ubie.” ");
INSERT INTO tof_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yesu we tolkomólórr, ó wa tóba aüd umulbain olmal utüdi tómrrónóp. Wa Pitaka bóktanórr wagó, “Saemon, ma ia utla? Ma ia gaodó koke namüla aerróm darrpan abüs küp ngarkwatóm? ");
INSERT INTO tof_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","E dakla wazilülün ó dakla tóre okolón, igósüm darrü klama yabü kolae tonarr tómbapónóm koke ki nolngomólnónóm. Yabü samuan ubi asine, büban ma arüng babula.” ");
INSERT INTO tof_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesu akó we wamórr dadan pokodó tórem. Wa akó dadan bóktan poko we bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wa nis ngim nóma tolkomólórr tóba aüd umulbain olmaldó, wa akó ibü utüdi tómrrónóp, zitülkus ibü uta barüm yarilürr; tibiób ilküp kokean nomgolóp. I umul koke kwarilürr, i nadü poko ki bóktórre Yesuka. ");
INSERT INTO tof_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wa akó aüd ngim nóma tolkomólórr, wa ibüka we bóktanórr wagó, “E wata ia utakla akó ngón ngabagóndakla? Gaodóma! Ene abüs küp kuri semrróne! Ngakónam, i errkyadan kürü, Pamkolpamab Olom nótókla, kolae tonarr pamab tangdó angrindako. ");
INSERT INTO tof_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bazeb, mi nau! Ngakónam, ene pam módóga, kürü kubó wirri pamab tangdó nótó küngrine!” ");
INSERT INTO tof_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu wata tóba umulbain olmaldózan bóktan yarilürr, Zudas, darrü ene 12 umulbain olmaldógab, ugón tübzilürr wirri gazirr pam ngoropükü, tibiób gazirr turrik akó kubidampükü, Yesun amiógüm. Wirri prrist, Mosesón gida umulbain pam, akó ⌊balngomól byarrmarr pama⌋ ibü zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Oya wirri pamab tangdó nótó ingrine, wa ngaen-gógópan umul ninóp wagó, “Ka ne nadü olom ipruko, da módóga, ene olom. Oya amigamke, we elngomólamke ngakankü.” ");
INSERT INTO tof_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zudas wata dümdüman we wamórr Yesuka. Oyabóka wagó, “Umulbain Pam!” da oya we iprükürr. ");
INSERT INTO tof_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Da módóga, ene gazirr pama Yesun tange karrkukus we amigóp. ");
INSERT INTO tof_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Darrpan oloma, ola nótó zamngól yarilürr, tóba gazirr turrik irruanórr, da singüldü prristan leba zaget paman güblang we itülürr. ");
INSERT INTO tof_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu ibüka we bóktanórr wagó, “E wa gazirr turrik a kubidampükü kürü amiógüm togoba, wamaka ka gazirr-gazirr gómól pamla? ");
INSERT INTO tof_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Blaman ngürrzan ka go yenkü umul bain namülnürrü ⌊Godón Gyabi Müótan⌋ kal akólórrón pul basirrdü, da e ma kürü koke kümigarre. Da taia, Godón Wibalómórrón Bóktana kürükwata inzan küpüm ki bai.” ");
INSERT INTO tof_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Da módóga, blaman umulbain olmala oya ola amgütóp, da i we busuóp. ");
INSERT INTO tof_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Darrpan küsil pama Yesuka solkwat akyalórr. Wa popa mórrkenyórr poko baterrón yarilürr. Gazirr pamab ubi oya amiógüm yarilürr, ");
INSERT INTO tof_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","da wa we busorr, kakapur, ó mórrkenyórr poko kakota amgatórr. ");
INSERT INTO tof_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ene pama Yesun we idüdóp kókó wirri müótüdü, singüldü prrista ne ngyabelórr. Ene pokodó, blaman wirri prrist akó balngomól byarrmarr pam akó Mosesón gida umulbain pama we kwób bazelórr Yesun kotóm ainüm. ");
INSERT INTO tof_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ibü solodó barrkyanan kan akyalórr, da tai singüldü prristan kal akólórrón pul basirrdü we bangrinürr. Wa we mórran-mórran bainürr, Godón Gyabi Müót ngakan pampükü. Wa tüób urdü güb boklam yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wirri prrist akó blaman Zu balngomól byarrmarr pama küp amkün koralórr Yesun büdülümpükü amkalóm. Da i darrü küp koke esenóp. ");
INSERT INTO tof_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Zitülkus módóga, abün pamkolpama obae bóktan oyakwata we büdrrat kwarilürr, da ibü bóktan darrpan tonarr koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Akó ngibürr pama we bórranglórr obae bóktan büdrratóm oyakwata wagó, ");
INSERT INTO tof_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ki oya igó arrkrruóp wagó, ‘Ka sab ini Godón Gyabi Müót ilgüto, pama ne kla elóp. Aüd ngürr kugupidü, ka sab darrü müót elo, pama koke ne kla elóp.’” ");
INSERT INTO tof_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ibü bóktan inikwata ta akó inzan, darrpan tonarr koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Singüldü prrista we zamngólórr blaman pamkolpamab aodó, da Yesun amtin bóktan poko we imtinürr wagó, “Marü ia alkomól bóktan babula, ini pama marükwata ne poko bóktandako?” ");
INSERT INTO tof_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Da Yesu ma piküp bain yarilürr ó wa darrü poko koke bóktanórr. Singüldü prrista akó oya imtinürr wagó, “Ki ne Godón ⌊ótókdakla⌋, ia ma tai oya Olomla, ene ⌊Kerriso⌋?” ");
INSERT INTO tof_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu bóktan yalkomólórr wagó, “Ka módógla. E sab kürü kósenane, Pamkolpamab Olom nótókla, mórrande wirri pabodó, Wirri Arüng Godón tutul tangdó, ó pülpül pokopükü tótókde kwitüdügab!” ");
INSERT INTO tof_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Singüldü prrista tóba tumum mórrkenyórr we atürrürr ngürsilanme akó we bóktanórr wagó, “Mi myamem darrü oloman bóktan koke arrkrrurre oyakwata. ");
INSERT INTO tof_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","E oya kolae bóktan kuri barrkrrua: wa Godón ngi kuri kulaine! Yabü gyagüpitótók ia negako?” I blamana igó bóktónóp wagó, “Wa kolae tónggapónórr! Wa ngarkwatódóma büdülüm!” ");
INSERT INTO tof_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ngibürr pamkolpama oya gwerr atóng we bókyenóp, ó i oya ilküp nis mórrkenyórr poko-e nganolop, da tibiób tangkubidame we emkalnóp. I oya we imtinóp wagó, “Ma ne amkoman prropet nóma namulo, ma kibüka kóbó tópta: marü ia nótó mómkóle?” Godón Gyabi Müót ngakan pama oya ipüdóp, da we emkólóp tibiób tang o-e taptap kwata. ");
INSERT INTO tof_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita wata kal akólórrón pul basirrdü yarilürr, darrpan Singüldü prristan zaget ngul oloma nóma katókórr. ");
INSERT INTO tof_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wa Pitan nóma esenórr, güb boklamde, wa oyaka dümdüman we yazilürr, da bóktanórr wagó, “Ma ta Yesukü asi namülnürrü, ene Nazarret olom!” ");
INSERT INTO tof_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","A Pita we balpinürr wagó, “Ka umul-kókla ma wa ia laró poko bóktandóla. Ka marü bóktan amzyatóm nabe kaindóla.” Da wa we wamórr kwatódó. Ene pokodó, karrakarra póyaea we bóktanórr. ");
INSERT INTO tof_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Zaget ngul oloma oya we esenórr, akó we arükürr dadan bóktan ibüka, nidi bórrang kwarilürr wagó, “Ene pam darrü módóga, oya umulbain olom!” ");
INSERT INTO tof_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita akó balpinürr. Wirri ngarkwat babul, ola nidi bórranglórr Pitaka we bóktónóp wagó, “Amkoman, ma darrü módógla, zitülkus ma Galili olomla.” ");
INSERT INTO tof_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Da módóga, Pita we bóktanórr wagó, “Ka yabü amkoman poko byaldóla: kürü God ki kómórr, ka ne obae nóma namulo. Ka amkoman umul-kókla e ne pambóka apóndakla!” ");
INSERT INTO tof_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tai ene pokoandó, karrakarra póyaea akó we bóktanórr, da Pitan ugón ngambangólórr, oya Yesu ngaen-gógópan ne poko yalórr wagó, “Karrakarra póyaea nis münüm bóktan küsil yarile, ma kubó aüd münüm ugón kalpino magó, ma kürübóka umul-kókla.” Da wa we yón sabinürr. ");
INSERT INTO tof_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Irrbianande, wirri prrista, ⌊balngomól byarrmarr pam⌋ akó Mosesón gida umulbain pampükü, blaman Zu balngomól byarrmarr pam nidi kwarilürr, tibiób bóktan we ingrinóp, da i Yesun sye-i amarükóp, we idüdóp, Paelatón tangdó we ingrinóp. ");
INSERT INTO tof_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Paelat oya imtinürr wagó, “Ia ma Zu pamkolpamab King módógla?” Yesu oya bóktan we yalkomólórr wagó, “Ma kuri bóktóna.” ");
INSERT INTO tof_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Wirri prrista Yesun abün kotóm ain bóktan aman koralórr. ");
INSERT INTO tof_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Paelat akó oya imtinürr wagó, “Turrkrru, i abün bóktan amarrudako marükwata, ma ne elklaza tómbapón namülnürrü. Ia ma bóktan koke yalkomolo?” ");
INSERT INTO tof_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu myamem bóktan koke yalkomólórr, da Paelat igósidi abün gyagüpitótók yazebórr. ");
INSERT INTO tof_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bókam tumtum ngarkwatódó, ⌊Büdül Kórzyón Tóredó⌋, Paelat darrpan tümün müótüdü pam bobarr irrualórr, pamkolpama noanbókamóm ato koralórr arruanóm. ");
INSERT INTO tof_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ene ngürrdü, darrü pam asi yarilürr, oya ngi Barrabas. Wa tümün müótüdü yarilürr ngibürr kolae gazirr pampükü, Rrom pam nidi büdülümpükü okrralórr gazirr kugupidü Rrom pampükü. ");
INSERT INTO tof_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pamkolpamab ngoroa nóma kwób tóbazelórr Paelatón amtinüm ibü ubi apadóm bobarrzan, ");
INSERT INTO tof_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Paelat ibü nümtinóp wagó, “Ia ka Zu pamkolpamab King irruno yabünkü?” ");
INSERT INTO tof_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Wa emzyatórr igó, wirri prrista Yesun igósidi ekyenóp, zitülkus ibü gyagüp kolaea ekrranórr, zitülkus abün pamkolpama Yesuka atan kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Da wirri prrista pamkolpamab ngoro we nilóp Paelatón ayalóm Barrabasón tümün müótüdügabi arruanóm. ");
INSERT INTO tof_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Paelat akó pamkolpam we nümtinóp wagó, “Ia ka dama oya ia yangono, e ne olom ngiliandakla Zu pamkolpamab Kingbóka?” ");
INSERT INTO tof_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pamkolpama we górrgónóp wagó, “Oya krrosdó emngyelam!” ");
INSERT INTO tof_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Paelat ibü nümtinóp wagó, “Iade? Wa ia tai laró kolae tónggapónórr?” Da pamkolpama wata wirri taegwarróm we inóp wagó, “Krrosdó emngyelam!” ");
INSERT INTO tof_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Paelatón ubi yarilürr pamkolpamab ngoroab gyagüpitótók morroal ainüm, da wa Barrabasón ibünkü we irruanórr tümün müótüdügabi. Da wa gazirr pam we nilóp Yesun kus pokopükü sye-i ailüm. Olgabi wa oya ngibürr gazirr pamab tangdó ingrinürr krrosdó amngyelóm. ");
INSERT INTO tof_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Paelatón gazirr pama Yesun we idüdóp Paelatón wirri müótan kal akólórrón pul basirrdü. I tibiób blaman kamdal we ngibaunóp darrpan pokodó kwób bazenóm. ");
INSERT INTO tof_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","I Yesun ilulu óe-óe mórrkenyórr tupo ngarkwat we atenóp, akó oya singül müóngdur we elóp tórez-tórez nugup tizi, da oya singüldü we emngyelóp. ");
INSERT INTO tof_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","I oya we yagürnóp, amkoman moboküpi koke, a i oya tiz yangónónóp wagó, “Ma wirri kokrrap ki ngyaben namüla, Zu pamkolpamab king!” ");
INSERT INTO tof_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Da i oya singül emkalnóp tupuru-i akó oya gwerr atóngnóp, da i tibiób wakósingül we nümgünóp akó tibiób singül we tüp elókóp oya agürüm. ");
INSERT INTO tof_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ibü nóma blakónórr oya tizangóna, da i oya ene ilulu óe-óe mórrkenyórr we ininóp, ama akó tóba mórrkenyórr oya we amelóp. Da i oya krrosdó amngyelóm we idüdóp. ");
INSERT INTO tof_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","I nóma ogoblórr, kwat-kwat i Saemonkü basenóp, darrü Saerrin wirri basirr pam, Aleksandórr a Rrupus, ibü ab, wa Zerrusalem wirri basirrdüzan bangrilürr madmad kabedógab. Oya Paelatón gazirr pama arüng-arüng we zirrapónóp Yesun krros bügasilüm. ");
INSERT INTO tof_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Da ene gazirr pama Yesun we idüdóp darrü pokodó, ngi Golgota, oya küp módóga: “Singül Kakan Bwób Poko.” ");
INSERT INTO tof_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ene pokodó, i oya waen akyanóm kain koralórr, mirr yarrisarri apórrón. Da Yesu koke enónórr. ");
INSERT INTO tof_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Irrbi abüs 9 ngarkwat nóma yarilürr, Paelatón gazirr pama Yesun krrosdó we emngyelóp. Ene kakóm, i tibiób ngipükü nugup poko aman kwarilürr pam basenóm wa, Yesun mórrkenyórr poko nidi ki yazebrre. Inzan kwata i oya mórrkenyórr we arrgrrütóp tibióbkü. ");
INSERT INTO tof_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Yesun sisingül darrü bóktan opor wialómóp oyakwata, oya ne bóktana büdüldü ingrinürr wagó, “Ini wa Zu pamkolpamab Kinge.” ");
INSERT INTO tof_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Da ene pokodó, i ta nis gazirr-gazirr gómól pam nis tibiób krrosdó nómngyelóp Yesukü, darrü oya tutul kwata, darrü oya banól kwata. ");
INSERT INTO tof_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pamkolpama nidi bórrgrrat-tórrgrrat kwarilürr, oya kle-kle yalnónóp. Tibiób singül bóngapnóp igó bóktankü wagó, “Oyo, ma módógla, ⌊Godón Gyabi Müót⌋ nótó ki ilgüte akó ma aüd ngürr kugupidü ki ela! ");
INSERT INTO tof_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ma krrosdógab ugó tibi akó moba kóbó zid bai!” ");
INSERT INTO tof_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dadan ngarkwatódó, wirri prrist akó Mosesón gida umulbain pama Yesun we tiz yangónónóp. I tibiób darrpan-darrpandó we bóktan kwarilürr wagó, “Wa ngibürr zid bain yarilürr, da wa ma gaodó kokea tóba zid bainüm! ");
INSERT INTO tof_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ini ⌊Kerriso⌋, Isrrael King, ugó kóbó ki tibi ene krrosdógab, da mi kubó eserre, ó oya amkoman kubó igósidi yangurre!” Ene gómól pam nisa, Yesun kabe-kabe tibiób krrosdó amngyelórrón nidi namülnürri, oya ta inzan kle-kle yalnórri. ");
INSERT INTO tof_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Abüs singülküp nóma semrranórr, tümüna dudu bwób ngaslaorr. Ene tümüna aüd abüs küp ngarkwatóm wamórr. ");
INSERT INTO tof_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Abüs aüd küp ngarkwat nóma semrranórr simam, Yesu wirri gyagüpi we taegwarr apónórr wagó, “Elo-i, Elo-i, lama sabagtani?” Oya küp módóga: “Kürü God, kürü God, ma kürü iade kolkomóla kólbanan?” ");
INSERT INTO tof_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ngibürr kolpama ibükagab, ola nidi bórrang kwarilürr, oya bóktan nóma barrkrrurr, da we bóktónóp wagó, “Arrkrruam, wa Ilaezan ngyaunda!” ");
INSERT INTO tof_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Darrüpa busorr, mórrkenyórr pokozan kla muran waendó yanggóbólórr, da aul pepeamdó amrókórr. Yesun ausüm we ekyanórr, da we bóktanórr pamkolpamdó wagó, “Kubó, mi kya kóbó ngakónónóm, Ilaeza ia kubó tame oya ini krrosdógabi alkumilüm!” ");
INSERT INTO tof_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu wirri taegwarre tóba dómdóm ngón we semanórr akó we nurrótókórr. ");
INSERT INTO tof_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Godón Gyabi Müót kugupidü ne wirri adrratórrón mórrkenyórra olean yarilürr, tebe aodó nis ór we bangónórr, tai kwitüdügabi kókó tüp. ");
INSERT INTO tof_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Gazirr pamab kopo ngakan wirri pam, Yesun obzek kwata nótó zamngól yarilürr, wa esenórr wagó, Yesu inzan nurrótókórr. Da wa bóktanórr wagó, “Amkoman, ini pam wata Godón Olom yaril!” ");
INSERT INTO tof_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ene pokodó ngibürr kola barrkyanan kandógabi azil kwarilürr. Inkü we kol koralórr: Merri Magdalin, Merri, kari Zeims akó Zosep ibü aip nótó warilürr, akó Salome. ");
INSERT INTO tof_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I Yesun mamoan akó tangamtin kwarilürr, wa Galilim nóma yarilürr. Abün kol akó asi kwarilürr; i usakü togobórr ama Zerrusalem. ");
INSERT INTO tof_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Simaman nóma yarilürr, Zosep, Arrimatia wirri basirr pam, ugón tübzilürr. Wa darrü Zu pamkolpamab balngomól byarrmarr pam yarilürr, da pamkolpama oya morroal angón koralórr. Wa tüób Godón Kingzan Balngomól akyan yarilürr. Ene dómdóm elklaza tómbapón ngürr yarilürr, darrü ngürr ama ⌊Sabad⌋ ki yarile. Zosep gum-koke we wamórr Paelatka Yesun büdül bübüm atom. ");
INSERT INTO tof_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Paelat arrkürrürr wa nóma arrkrrurr wagó, Yesu kuri nurrótóke. Wa tóba gazirr pamab kopo ngakan wirri pam ngyaunürr, ó wa oya imtinürr wagó, “Ia Yesu kuraian nurrótóke?” ");
INSERT INTO tof_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gazirr pamab kopo ngakan wirri pama bóktan we yalkomólórr wagó, “Ó, wa kuraian nurrótóke.” Da Paelat Zosepón we yalórr wagó, “Taia, ma kubó Yesun büb ipadke.” ");
INSERT INTO tof_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zosep wirri darrem baeb mórrkenyórr amiógürr, Yesun büb krrosdógabi ilkumilürr, da oya büb we errgótanórr ene mórrkenyórri. Ene kakóm, wa gapókdó we ingrinürr. Ene gapók karrkukus ingülküpdü alüngürrün yarilürr. Da wa wirri ingülküp we yanenórr, ene gapók mamtae murrausüm. ");
INSERT INTO tof_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Merri, Magdalin, akó Merri, Zosepón aip, ngakan namülnürri, ó i eserri Yesun büb ne ingrinürr. ");
INSERT INTO tof_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","⌊Sabada⌋ nóma blakónórr, abüsa nóma bótaolórr, Merri Magdalin, Merri, Zeimsün aip nótó warilürr, akó Salome morroal ilang elklaza bumigóp gapókdó tótókóm Yesun bübdü akanóm. ");
INSERT INTO tof_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Udaian ngaen-gógópan ngürrdü, irrbianande, abüsa nóma tübanikürr, ene dadan kola we ogobórr gapókdó. ");
INSERT INTO tof_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kwat-kwat tibiób we bamtinóp wagó, “Ini ingülküp ia kubó nótó amaike mibünkü ene gapók mamtaedógab?” ");
INSERT INTO tof_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","I nóma yazilóp gapókdó, ene ingülküp anerrón yarilürr mamtaedógabi. (Ene kari ingülküp ta koke yarilürr.) ");
INSERT INTO tof_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","I gapókdó nóma barrbünürr, i küsil pam esenóp mórrande ibü tutul kwata, gabülpli mórrkenyórr baterrón. I kari gübarirr koke aengóp. ");
INSERT INTO tof_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ene pama ibüka we bóktanórr wagó, “E arrkürrgu! E Yesun amkündakla, ene Nazarret olom krrosdó noan emngyelóp. Wa aini babula! Oya kuri irsümüle! Ene poko ngakónam, oya büb ne angrirrün yarilürr. ");
INSERT INTO tof_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Da errkyadan ugó bako. E umulbain olmal akó Pita umul-umulan ngintinamke magó, ‘Wa Galili tótókdase yabü singül kwata. E kubó oya ola esenane, wa yabü tüóbzan nilóp.’” ");
INSERT INTO tof_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","I gum tórrngón akó gübarirr aengkü we busuóp gapókdógab. I darrü pamdó koke bóktónóp kwat-kwat, zitülkus i gum koralórr. ");
INSERT INTO tof_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yesu büdüldügab nóma türsümülürr udaian ngaen-gógópan ngürrdü, irrbianande, wa ngaen-gógópan Merri Magdalinka okaka tübyónürr. We koldó wa 7 kolae samu noakagabi amanórr. ");
INSERT INTO tof_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Wa we natókórr, Yesun ngibürr gómdamal we nüzazilóp, i nóma yón gyaur akó yón kwarilürr. ");
INSERT INTO tof_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wagó, “Yesu arróla. Ka oya esena!” Da i oya amkoman koke wangunóp. ");
INSERT INTO tof_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ene solkwat, Yesu akó darrü obzeke okaka tübyónürr tóba nis umulbain olom nisdü, kwat-kwat i nóma aurrnürrima darrü bwóbdü. ");
INSERT INTO tof_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","I nóma alkomórri, ngibürr umulbain olmal nüzazilóp, da ibü amkoman koke nangunóp. ");
INSERT INTO tof_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu akó dómdóm we okaka tübyónürr tóba 11 umulbain olmaldó, i nóma alo kwarilürr. Wa ibü nagóp, zitülkus ibü amkoman bangun babul yarilürr, akó ibü moboküp kari karrkukus koke koralórr ibü amkoman angunüm oya nidi esenóp arrólde. ");
INSERT INTO tof_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wa ibüka bóktanórr wagó, “E ugó ogob, bwób-bwób, blaman pamkolpamdó kürükwata Morroal Bóktan amgolkü. ");
INSERT INTO tof_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Sab Morroal Bóktan amkoman nótó yangune akó ⌊baptaes nótó baine⌋, God oya zid ine. Akó obae nótó yangune, God oya zaz ine akó ⌊kolaean darrem⌋ ekyene. ");
INSERT INTO tof_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne pamkolpama Morroal Bóktan amkoman yangurre, God ibü sab arüng nókyerre wirri ⌊arüng tonarr⌋ tómbapónóm. Kürü ngidü i sab kolae samu aman kwarile ó i akó sab küsil bóktane bóktan kwarile, i koke ne bóktan umul bainóp. ");
INSERT INTO tof_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","I gwar nóma emorre akó i darrü kolae kla nóma enórre, ibü koke kolae nirre. I tibiób tang azid olomdó nóma emelórre, azida blakóne.” ");
INSERT INTO tof_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Lod Yesun bóktana nóma blakónórr tóba umulbain olmaldó, ene kakóm God oya we sipadórr kwitüdü. Ene pokodó, wa wirri pabodó, Godón tutul tangdó we mórran-mórran bainürr. ");
INSERT INTO tof_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Oya umulbain olmala we ogoblórr bwób-bwób, Morroal Bóktan amgolkü. Yesu ibü zaget kugupidü asi yarilürr. Wa umul-kók tórrmen tómbapón yarilürr tóba umulbain olmalab bóktan arüng bütanóm. Makón Peba aini blakónda. ");
INSERT INTO tof_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wirri Pam Tiopilus, Abün pama tibiób arüng angrin kwarilürr bóktan wibalómóm, ne elklaza küppükü bainónóp mibüka, ");
INSERT INTO tof_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ngibürrazan kibü ne poko tüzazilnónóp, i tibióbnüm ilküpi ne elklaza nósenónóp bwób zitüldügab, akó Godón bóktan nidi büdrratnónóp pamkolpamdó. ");
INSERT INTO tof_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ka küób ta tai kuri mumyamla Yesun ene póepa ne bókyanórr, da ka küób igó gyagüpi wama, ka dümdüm wialómdóla marünkü, Tiopilus, ");
INSERT INTO tof_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","marü tai umulüm amkoman bóktan, marü ngibürra ne kla umul myónónóp. ");
INSERT INTO tof_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Errod king nóma yarilürr Zudia Prrobinsankü, darrü ⌊prrist⌋ asi yarilürr, ngi Zekarraea, Abaezan prristab kobodógabi. Oya kol Elizabet wa ta Erronón zitüldügab katókórr. ");
INSERT INTO tof_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","I nizana dümdüm ngyabenórri Godón ilküpdü, akó i ⌊Lodón⌋ blaman gida bóktan poko akó mamoan bóktan karrkukus amorran namülnürri. ");
INSERT INTO tof_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A ibü ma olmal babul kwarilürr, zitülkus Elizabet olmal balngón-koke kol warilürr. Akó i ta tib tai epep myang bain namülnürri. ");
INSERT INTO tof_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Darrpan ngürr, Zekarraean prristab kobo zagetódó nóma yarilürr, Zekarraea tóba zaget tónggapón yarilürr ⌊Godón Gyabi Müótüdü⌋. ");
INSERT INTO tof_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Prristab gida ngarkwatódó ngi amkün kla nóma aman kwarilürr asenóm Lodón Gyabi Müótüdü morroal ilang buru nótó ki angan yarile ⌊altadó⌋, da Zekarraean ngia tubrranórr. ");
INSERT INTO tof_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wazan ene ilang buru angan yarilürr, blaman pamkolpama dakla tóre kwarilürr pulkakak. ");
INSERT INTO tof_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Darrü Lodón anerrua tóba ugón okaka tübyónürr Zekarraeaka. Ene anerrua alta tutul kwata zamngól yarilürr, ene morroal ilang buru ne bóngan kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zekarraea ene anerru nóma esenórr, wa karibóka-koke arrkürrürr akó dakla guma ipadórr. ");
INSERT INTO tof_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ene anerrua Zekarraeanbóka wagó, “Ma gumgu, Zekarraea! God marü tóre arrkrru yarilürr olomóm. Elizabet marü kola sab siman olom esene marünkü, da sab Zon ngi ngyesilke. ");
INSERT INTO tof_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ma sab bagürwóm namulo oyame. Akó abün pamkolpam sab bagürwóm kwarile, wa sab nóma tómtómóle. ");
INSERT INTO tof_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Wa sab wirri pam yarile Godón ilküpdü. Wa sab waen koke ki enólón akó ia ngyepam. Oya amtómól küsil nóma yarile, oya büb sab Godón Samua gwarrarrón yarile. ");
INSERT INTO tof_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Wa sab abün Isrrael pamkolpam sakone Lodka, tibiób God. ");
INSERT INTO tof_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Zon sab Lodón singül kwata wame. Oya samu akó arüng, ⌊prropet⌋ Ilaezan samu akó arüngzan yarile. Wa inzan wamle, abal akó olmal darrpan pokodó amarrum paudi ngyabenóm akó Godón arrkrru-koke pamkolpam alüngüm dümdüm gyagüpitótók apadóm. Ini tonarre, wa pamkolpam dümdüm nütürre Lodón pamkolpamóm bainüm.” ");
INSERT INTO tof_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zekarraea anerru imtinürr wagó, “Ka ia umul baino ia ini amkoman pokoa? A ka go myangla, akó kürü kol ta epepo; oya pail alam ngarkwat kokea!” ");
INSERT INTO tof_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ene anerrua bóktanórr wagó, “Kürü ngi Geibrriel. Blaman ngürrzan ka Godón obzek kwata zamngóldóla. Da kürü God wató zirrkapóne marüka ini morroal bóktan ódódóm. ");
INSERT INTO tof_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Da turrkrru, ma sab piküp namulo akó gaodó koke namulo bóktanóm, kókó ene ngürr nóma semrróne, zitülkus ma kürü bóktan amkoman koke angundóla. Ene bóktana sab tóba ngarkwatódó küppükü baine.” ");
INSERT INTO tof_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Da pamkolpama dakla Zekarraean akyan kwarilürr. Ibü gyagüpitótók abün-abün koralórr, da tibiób bamtinónóp wagó, “Ia ini pama wirri ngarkwat larógóm apadóda Godón Gyabi Müót kugupidü?” ");
INSERT INTO tof_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zekarraea amkoman nóma tubrranórr, wa gaodó koke yarilürr bóktanóm. I umul bainóp wagó, ini pama nuszan kla esene Godón Gyabi Müót kugupidü. Wa wata tange tórrmen tómbapón yarilürr pamkolpamdó, a oya tae wata murrbausürrün yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zekarraean Godón Gyabi Müótüdü zageta nóma blakónórr, wa tóba basirrdü we alkomólórr. ");
INSERT INTO tof_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ene kakóm, oya kola Elizabet bikóm we esenórr. Wa müótüdügabi koke burruan warilürr 5 melpal kugupidü. ");
INSERT INTO tof_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elizabet bóktanórr wagó, “Errkya ini ngyaben tonarrdó, Lod kürü kuri tangkamtine! Wa kürü ene olmal balngón-koke büód kuri amanike pamkolpamab obzek kwata!” ");
INSERT INTO tof_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","6 Melpal ngarkwat Elizabetón bikóm ódódde, God tóba anerru Geibrrielün ugón zirrsapónórr Nazarret wirri basirrdü, Galili prrobinsdü, ");
INSERT INTO tof_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","pampükü ut-koke ngul olomdó, ngi Merri. Wa arrearrón warilürr darrü pam amiógüm ngi Zosep, ⌊Deibidün⌋ bobataldógab. ");
INSERT INTO tof_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Geibrriel oyaka wamórr, da bóktanórr wagó, “Paud marüka asi ki yarilün, God wirribóka ne kol agürda! Lod mankü asine!” ");
INSERT INTO tof_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Geibrrielün bóktana Merrin abün gyagüpitótók uliónürr. Wa tóba bamtin warilürr wagó, “Anerruan bóktanan küp ia laróga?” ");
INSERT INTO tof_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anerrua oyaka bóktanórr wagó, “Gumgu, Merri, zitülkus God tóba obzek kwata marüka morroal kuri sesene! ");
INSERT INTO tof_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Turrkrru, ma sab bikóm ipudo, akó siman olom eseno. Da ma oya Yesu ngi ngyesilke. ");
INSERT INTO tof_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Wa sab wirri pam yarile, akó sab ngilianórre: Wirri Kwitüm God oya Olombóka. Akó Lod God sab oya tóba abbobat Deibidün pabodó ingrine. ");
INSERT INTO tof_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Akó sab wa wató nolngomólnórre Zeikobón olmalbobatal, metat; oya balngomóla sab kokean blakóne!” ");
INSERT INTO tof_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Merri anerru imtinürr wagó, “Ini wa ia tómbapóne? Ka go pambóka umul-kókla.” ");
INSERT INTO tof_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anerrua bóktan yalkomólórr wagó, “Godón Samua sab marüka tübangrine, akó Wirri Kwitüm Godón wirri arünga sab marü ngamlo-e. Módóga, we zitülkusdü, sab ne oloma tómtómóle marükagab sab tebe-tebe bumanikürrün akó ⌊kolkal⌋ ngyaben yarile akó ngilianórre Godón Olombóka. ");
INSERT INTO tof_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Da ma turrkrru: marü gódam Elizabet bikómpükümato. Wa epepande kuri ipüde. Pamkolpama oyabóka igó apón koralórr wa, ‘Wa olmal balngón-koke kolo,’ a wa ma errkya 6 ngim melpal amaikdo bikómpükü. ");
INSERT INTO tof_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Zitülkus módóga, darrü kla müp babula Godka.” ");
INSERT INTO tof_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Merri bóktan yalkomólórr wagó, “Ka Lodón ⌊leba zaget⌋ kolóla. Taia! Amkoman ki tómbapó kürüka, marü bóktan ngarkwatódó!” Da anerrua oya we zumgatórr. ");
INSERT INTO tof_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ene kakóm, Merri tóba elklaza tómbapónórr, da órnae we natókórr darrü wirri basirrdü Zudia prrobins podopükü bwóbdü, Zekarraea a Elizabet ibü asenóm. ");
INSERT INTO tof_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Wa Zekarraean müótüdü nóma bangrinürr, wa Elizabetónbóka wagó, “Paud marüka asi ki yarilün!” ");
INSERT INTO tof_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabet Merrin nóma zurrkrrurr, Elizabetón oloma aumana bikómdü wata ugósan wirribóka balngónórr, akó Elizabetón büb Godón Samua ta ugósan gwarrarrón yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wa wirri gyagüpi bóktanórr wagó, “God marü kuri bles mine ngibürr koldógabi! God sab bles ine, ma sab ne olom ilngumilo! ");
INSERT INTO tof_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ia ini wirri klama ia larógóm tómbapónda kürüka, ene wa, kürü Lodón aipa katóke kürü angónóm! ");
INSERT INTO tof_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Dümdüman ka marü nóma murrkrrua, kürü bikómdü ne olome bagürwómpükü balngóne! ");
INSERT INTO tof_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bagürwóm marükama, zitülkus ma amkoman angundóla, marü Lod ne bóktan mókyanórr sab amkoman küppükü baine!” ");
INSERT INTO tof_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Merri bóktanórr wagó, “Ka Lodón ngi kwit amngyeldóla moboküpi; ");
INSERT INTO tof_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","kürü samu kari bagürwóm kokea Godónkwata, kürü Zidain Pam, ");
INSERT INTO tof_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","zitülkus wa kürü gyagüpi kümanikürr, oya tüpana leba zaget ngulmokur! Errkyadógab kókó sab ugórr, pamkolpama sab igó bóktanórre wagó, ‘Wa bagürwóm kolo’, ");
INSERT INTO tof_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","zitülkus Wirri Arüng Goda kari morroal elklaza koke tólbaelórr kürünkü. Oya gyabian ngia! ");
INSERT INTO tof_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Oya ne pamkolpama ⌊ótókdako⌋, wa tóba gyaur okaka amzazilda ibüka, darrü lüóldügabi kókó darrü lüól. ");
INSERT INTO tof_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wa wirri tórrmen tólbaelórr tóba arüng tange: wa ikub bagür pamkolpam tibiób gyagüpitótókpükü nórngenóp. ");
INSERT INTO tof_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wa balngomól wirri pam tibiób pabodógab tüp selókórr, a tibiób ngi nidi tüp alókdako, wa ibü ngi kwit ninóp. ");
INSERT INTO tof_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wa alo-koke ngyaben kolpam morroal elklaza-e ngabyónürr, a wa mórrel pam tang küpan zirrnapónóp aibwób. ");
INSERT INTO tof_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","God tóba zaget pam Isrrael kuri tangnamtirre. Wa oya gyaura ngambangóle ");
INSERT INTO tof_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Eibrra-amka akó oya olmalbobataldó metatómpükü, wa mibü abalbobatal ne bóktan nókyenóp!” ");
INSERT INTO tof_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Merri Elizabetka aüd melpal ngarkwat ngyabenórr, da we alkomólórr tóba basirrdü Nazarret. ");
INSERT INTO tof_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabetón nóma twarrpinürr, da siman olom esenórr. ");
INSERT INTO tof_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Oya minggüpanandó nidi ngyabenónóp akó oya zonaretala barrkrrurr, Lod nadüzan gyaur yarilürr oyaka. I usakü kari bagürwóm koke kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","8 Ngim ne ngürr yarilürr, pama togobórr oya ⌊gyabi sopae singgapinüm⌋. Ibü ubi aban ngi ngyesilüm yarilürr, Zekarraea. ");
INSERT INTO tof_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A oya aipa bóktan yalkomólórr wagó, “Koke! Oya ngi sab Zon yarile!” ");
INSERT INTO tof_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I bóktónóp oyaka wagó, “A darrü pam go babula marü zitüldü ene ngipükü!” ");
INSERT INTO tof_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Olgabi tange tórrmen tólbael kwarilürr Zekarraeaka, oya amtinüm nadü ngi akyanóm olommokur. ");
INSERT INTO tof_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zekarraea darrem tange tórrmen tólaelórr ibüka wibalóm klamóm. I nóma sidüdóp, wa ini opor wibalómórr wagó, “Oya ngi Zone.” Blaman pamkolpama gübarirr aengóp. ");
INSERT INTO tof_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tai ene pokoandó, Zekarraean taea ulitapükü ugón tapabakurr, da bóktanóm we bainürr. Dakla Godón yagürlürr. ");
INSERT INTO tof_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ene pamkolpama ibü minggüpanandó nidi ngyabenónóp, karibóka-koke barrkürrürr, i blaman ne kla nósenóp. Akó blaman Zudia podopükü bwóbdü ne pamkolpam kwarilürr, blamana wata ene poko zwapólórr. ");
INSERT INTO tof_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Blamana nidi barrkrrurr ini poko, metat gyagüpi ogoblórr. I tibiób bamtinónóp wagó, “Ia wa sab ia pamóm baine, ini olommokura?” Zitülkus módóga, ibüka popadan yarilürr Lodón arüng tang oyaka asi yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Olgabi oya ab Zekarraean büb Godón Samua gwarrarrón yarilürr, da ⌊prropetzan igósidi bóktanórr⌋ wagó: ");
INSERT INTO tof_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mi blamana yagürnórre Lodón, mibü Isrrael isab God! Zitülkus módóga, wa kuri tame tóba pamkolpam ⌊aurdü amanóm⌋. ");
INSERT INTO tof_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","God mibü kuri tókyerre mibü wirri Zidbain Pam. Wa Godón zaget pam Deibidün zitüldügabi kuri tame. ");
INSERT INTO tof_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","God bóktanórr tóba prropetódóma, tibi-tibi amórrón nidi kwarilürr tóbankü, ngaen nidi ngyabenónóp, wagó, ");
INSERT INTO tof_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Wa mibü sab zid tirre ibükagab, minkü nidi gazirrdako, akó ibü tangdógab syuse, mibü nidi alzizi amandako. ");
INSERT INTO tof_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","God ini poko sab tónggapóne tóba gyaur okaka amzazilüm, wa ne arüng bóktan nókyenóp mibü abalbobatal. Oya ⌊alkamül-koke tónggapórrón bóktan⌋ metat gyagüpitótókdó yarile, ");
INSERT INTO tof_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","wa ne ⌊arüng alkamül-koke bóktan⌋ ekyanórr mibü abbobat Eibrra-amón wagó, ");
INSERT INTO tof_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","wa sab mibü aurdü semóne ibükagab, minkü nidi gazirrdako, mibü ok bainüm oya gum-koke ótókóm. ");
INSERT INTO tof_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ini pokodó, mi sab kolkal akó dümdüm ngyaben koralo oya obzek kwata mibü ini ngyabenbarrdó.’ ");
INSERT INTO tof_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A mató, kürü olom, marü sab igó ngimlianórre, Wirri Kwitüm Godón prropet, zitülkus ma sab Lodón singül kwata wamo kwat alótóm. ");
INSERT INTO tof_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Marü zaget sab we kla yarile, oya pamkolpam umul-umulan ngibtanóm, God sab ibü zid nirre, wa ibü kolae tonarr nóma norrgorre. ");
INSERT INTO tof_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mibü God ini poko tónggapónóm kainda, zitülkus wa kari gyaur kokea mibüka. Ini gyaur zitülkusdü, abüsazan angürda, zyóna sab mibüka inzan tame kwitümgab. ");
INSERT INTO tof_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wa sab tame warri apónóm ibüka, samuan ngarkwatódó tümün akó büdül kwatódó nidipko akó mibü paud kwatódó balngomólóm.” ");
INSERT INTO tof_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ene olommokur Zon we dódórr bailürr akó arüng ipadlórr samuan ngarkwatódó. Wa ⌊ngüin-koke bwóbdü⌋ ngyaben yarilürr, kókó ene ngürr nóma semrranórr, wa ugón we okaka tübyónürr Isrrael pamkolpamdó. ");
INSERT INTO tof_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Zon ne tonarr tómtómólórr, Sisa Ogustus arüng bóktan igó zirrapónórr, bwób-bwób blaman pamkolpama tibiób ngi amarrum, sansus bukdü arrbünüm, wa ne bwób ór ngabkalórr. ");
INSERT INTO tof_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini ngaen-gógópan ngi arrbün tonarra ugón tómbapónórr, Kwirrinius gabena nóma yarilürr Sirria prrobinsdü. ");
INSERT INTO tof_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Da blaman pamkolpama we ogoblórr tibióban darrpan-darrpan babót wirri basirrdü, tibiób ngi amarrum, sansus bukdü arrbünüm. ");
INSERT INTO tof_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Da módóga, Zosep ta wamórr Nazarret wirri basirrdügab, Galili prrobins kugupidü, ama Betliem wirri basirrdü, Zudia prrobins kugupidü, King ⌊Deibid⌋ ne tómtómólórr, zitülkus wa Deibidün zitül olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I Merridi aurrürri tibiób ngi angrinüm sansus bukdü, zitülkus wa oya arrearrón kol warilürr. Merri ta ugón bikómpükü warilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","I olazan namülnürri, ene tonarrdó Merrin ugón twarrpinürr. ");
INSERT INTO tof_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wa tóba ngaen siman olom we esenórr, da mórrkenyórri we errgótanórr, ama ngabyón larab paugtundü ingrinürr, zitülkus ut bwób gaodó koke yarilürr amil marrgudü. ");
INSERT INTO tof_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ene irrüb, sip ngabkan pama tibiób sip ola ngabkan koralórr ene dadan basirr madmad kabedó. ");
INSERT INTO tof_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Darrü Lodón anerrua ibüka we okaka tübyónürr. Lodón ⌊wirri kómal zyóna⌋ ibü nóma warri napónóp, ibü wirri guma yazebórr. ");
INSERT INTO tof_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Da anerrua ibüka we bóktanórr wagó, “E gumgu, zitülkus ka yabüka morroal bagürwóm bóktan sidüda, blaman pamkolpamabkü. ");
INSERT INTO tof_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Errkya ini ngürr, Deibidün wirri basirrdü, yabü Zidbain Oloma kuri tómtómóle. Wa módóga, ene ⌊Kerriso⌋, yabü ⌊Lod⌋. ");
INSERT INTO tof_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","E oya kubó inzan emzyetane: e kubó gab olom mórrkenyórri arrgótarrón eserre, paugtundü arrükdi.” ");
INSERT INTO tof_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Olgabi, büzyón-babul, kwitümgab wirri anerru kwóba oyaka we barümóp. I Godón yagürnóp, igó bóktankü wagó, ");
INSERT INTO tof_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Wirrian kwitüm Godón ngi wirri kwitüm emngyelam, akó tüpdü paud asi ki yarilün pamkolpamab aodó, oya nidi bagürwóman ngitandako!” ");
INSERT INTO tof_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Anerrua sip ngabkan pam nóma nümgütóp, i we bakolórr ama kwitüdü. Da sip ngabkan pama tibióbka we bóktan kwarilürr wagó, “Nau kóbó! Mi tótókdakla Betliem ene tonarr asenóm, Lod ne poko umul-umulan ngibtirre!” ");
INSERT INTO tof_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Da i órnae we ogobórr. I Merri, Zosep, akó ene gab olom we nómrrónóp. Oloma paug tundü we arrük yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","I ene gab olom nóma esenóp, ene bóktan we ayop, ibü anerrua ne bóktan nüzazilóp ene gab olombóka. ");
INSERT INTO tof_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Blamana nidi barrkrrurr, i gübarirr aengóp, ibü sip ngabkan pama ne poko nüzazilóp. ");
INSERT INTO tof_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Blaman ne pokoa tómbapónónóp, Merri tóba moboküpdü irrbülürr, da gyagüpi amalórr. ");
INSERT INTO tof_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ene sip ngabkan pama we bakonórr Godón ngi wirri kwitüm amngyelkü akó agürkü, i ne kla barrkrrulürr akó ne kla nósenónóp. Blaman klama we ngarkwatódó tómbapónóp, anerruazan bóktanórr. ");
INSERT INTO tof_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","8 Ngim ne ngürr yarilürr, oya ⌊gyabi sopae nóma singgapinóp⌋, da oya aipab nisa Yesu ngi we ngyesilürri. Wa aipan bikómdü solkwat tómtómólórr, ini ngi anerrua wata ngaensingülan ekyanórr. ");
INSERT INTO tof_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Merri akó Zosep ibü ene tóman barrgon tóre nóma semrranórr, Mosesón gida-azan bóktanda, i Zerrusalem wirri basirrdü we ogobórr, ene tóre akom akó Yesun Lodka pupainüm. ");
INSERT INTO tof_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Enezan wialómórróna Lodón gidadó wagó, “Blaman ngaen simanal olmal tibi-tibi amarrón kwarile Lodónkü.” ");
INSERT INTO tof_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","I ola ene tóman barrgon tóre tónggapórri, póyae nüdüdi, Lodón gida-azan bóktanda wagó, “Ma kubó nis nurre póyae ta ia nis kubukubu kupo póyae ekyeno prrist ⌊altadó⌋ anganóm, Lodón bagürwóman ngitanóm.” ");
INSERT INTO tof_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ene tonarrdó, Zerrusalemóm darrü pam yarilürr, ngi Simion. Wa wata dümdüm ngyaben akó igó pam yarilürr, Godón bóktan morroal nótó azeb yarilürr. Wa igó tonarr akyan yarilürr wa, God sab kókó Isrrael pamkolpamdó zidbain olom zirrsapóne. Godón Samua oya wató alngomól yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Simionka Godón Samua igó okaka simzazilürr wagó, “Ma sab ngaen-gógópan mobanóm ilküpi ene Kerriso eseno, ene solkwat ma sab nurrótoko.” ");
INSERT INTO tof_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Godón Samuazan alngomól yarilürr, wa Godón Gyabi Müót kal akólórrón pul basirrdü we bangrinürr. Merri akó Zosep Yesun ola ugón sidódrri. I Yesun ugósüm sidódrri Lodka pupainüm, Mosesón gida ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion ene olom nóma esenórr, tange ipadórr, dalgüpdü ingrinürr, Godón agürkü wagó, ");
INSERT INTO tof_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Lod, ma enezan namülnürrü, ka, marü zaget pam nótókla, kubó paudüdü nurrótoko. Kürü arról ugó sipa, ");
INSERT INTO tof_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","zitülkus kürü ilküp nisa kuri eseni, ma noan ingrirrü blaman pamkolpam zid bainüm. ");
INSERT INTO tof_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wa zyóna, marü okaka amzazilüm ibüka, Zu-koke nidipko, akó moba Isrrael pamkolpamab ngi wirri kwitüm amngyelóm.” ");
INSERT INTO tof_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ene olommokuran aipab nisa gübarirr aengrri, Simion oyakwata ne poko bóktan yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Da Simion ibü we bles ninóp, da wa Merrika, Yesun aipdü, we bóktanórr wagó, “Turrkrru, God ini olom ugósüm amaikürr, ngibürr pamkolpama Isrrael kugupidü sab oya ipadnórre da zid bairre, ngibürra ma koke; ibü sab kolaea tawirre. Wa sab timamzan yarile, pamkolpam Godónbóka umul-umulan ngibtanóm. Sab abün pamkolpama oyaka bóka bamgün kwarile. ");
INSERT INTO tof_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ini kla tómbapónde, ma sab kari gyaur koke namulo, wamaka marü moboküp sab zirr turrikazan itile, akó God sab abün pamkolpamab gyagüpitótók okaka sizazine, ibü moboküpdü ne klamko.” ");
INSERT INTO tof_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Darrü kol ola asi warilürr. Wa prropet warilürr, oya ngi Ana. Tüób Panuelün óp olom, Asyerrón zitül kol. Wa tüób epepan akó 84 pail warilürr. Wa müórpükü wata 7 pailüm ngyabenórr. Ene tonarrdógabi wa kóblea ngyabelórr. Wa Godón Gyabi Müót kokean amgat warilürr Godón ótókóm irrüb akó ngürr. Abün tonarr alo bütók warilürr, akó metat tóre bako warilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ene tonarrdó, wa Merri a Zosep, ibüka we katókórr akó Godón eso we ekyanórr. Akó ene olommokurankwata pamkolpamdó we apón warilürr blamandó, Godón nidi akyan kwarilürr Zerrusalem ⌊aurdü amaniküm⌋. ");
INSERT INTO tof_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Merri akó Zosep ibü blaman tórrmen tulmil tómbapóna nóma blakónórr Lodón gida ngarkwatódó, i we tolkomólórri tibiób wirri basirrdü Nazarret, Galili kugupidü. ");
INSERT INTO tof_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ene olommokura we dódórr bailürr akó arüng ipadlórr, dakla ⌊wirri gyagüpitótók⌋ ipadlórr. Módóga, Godón ⌊gail tonarr⌋ wata metat asi yarilürr oyaka. ");
INSERT INTO tof_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Blaman pail oya aipab nisa aurrnürri Zerrusalem, ⌊Zu pamkolpamab⌋ ⌊Büdül Kórzyón Tórem⌋. ");
INSERT INTO tof_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wa 12 pail nóma bainürr, wa aipab nisdü ene tórem we akyanórr, gida ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ene tóre ngürra nóma blakónóp, oya aipab nisa alkomólóm nóma bupadürri, i igó umul-kók namülnürri igó, Yesu ola burrmute Zerrusalemóm. ");
INSERT INTO tof_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ibü gyagüpitótók igó yarilürr wagó, wa inkü asine. Ibü tótókde darrpan ngürra nóma blakónórr, i amkünüm we bairri zonaretaldóma akó gómdamaldóma. ");
INSERT INTO tof_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Koke nóma eserri, i Zerrusalem we alkomórri oya amkünüm. ");
INSERT INTO tof_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aüd ngürr kakóm, oya Godón Gyabi Müót kal akólórrón pul basirrdü esenóp, umulbain pampükü mórrande. Wa ibü arrkrru yarilürr akó bamtin bóktan poko bamtin yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Blamana nidi barrkrrurr oya bóktan, gübarirr aengóp oya morroal gyagüpitótókdógabi akó bóktan akonde. ");
INSERT INTO tof_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oya aipab nisa nóma eserri, i ta gübarirr aengrri. Oya aipa we yalórr wagó, “Iba, olom! Ma kibüka ini poko iade tónggapóna? Marü ab akó kótó, ki kari gyakolae koke namülnürri: ki errkya-koke bókyarri marü amkünüm!” ");
INSERT INTO tof_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wa we yalkomólórr wagó, “E ia kürü iade amkün namülnürri? E igó poko umul-kókamli igó, ka kólba Aban müótüdü ki namüla?” ");
INSERT INTO tof_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ini poko nóma bóktanórr, i ⌊küp koke ipadrri⌋, wa ne poko bóktanórr. ");
INSERT INTO tof_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Da wa inkü we wamórr ama Nazarret. Wa ola tóba aipab nisab bóktan arrkrru yarilürr. Oya aipa ini poko moboküpdü irrbülürr, wa ne poko nósenóp. ");
INSERT INTO tof_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu pamómzan bailürr, oya gyagüpitótók akó arünga ta wirri bairri. Godón oya agüra ta metat wirri bailürr; pamkolpamab agüra ta inzan wirri bailürr. ");
INSERT INTO tof_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","15 Ngim ne pail yarilürr, Taebirrius ugón Rrom sisa yarilürr. Pontius Paelat ma ugón Zudia gabena yarilürr. Akó Errod Antipas go Galili prrobins alngomól pam yarilürr. Oya narezoret Pilip go Iturrea akó Trrakonaetis bwób nis alngomól pam yarilürr. Akó Lisanias go Abilini bwób alngomól pam yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ugón ma Anas a Kayapas ⌊singüldü prrist⌋ nis namülnürri. Da Godón bóktana tamórr Zekarraean olomdó, Zonka, wa ⌊ngüin-koke bwóbdüzan⌋ yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Zon blaman Zodan tobarr minggüpanan bwóbdüma we wamlórr, bóktan igó amgolkü wagó, “Godka tübyalüngam yabiób kolae tonarrdógabi. Da ka yabü baptaes ninünümo. Ene igósüm, God yabü kolae tonarr sab norrgorre.” ");
INSERT INTO tof_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Enezan wialómórróna prropet Aesayan pebadó wagó, “Darrü pama taegwarrdase ngüin-koke bwóbdü wagó, ‘Kwat ngagrótam Lodón tótókóm. Kwat dümdüm alótam oyankü! ");
INSERT INTO tof_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Blaman buruburu sab nüditirre, akó wirri podo akó kari podo durdur nirre. Sab gomo-gomo kwat dümdüm nirre akó balóng-balóng kwat morroal durdur nirre. ");
INSERT INTO tof_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Blaman bwób-bwób pamkolpama sab ugón eserre, Godón zidbain iada.’” ");
INSERT INTO tof_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pamkolpamab ngoro, nidi togoblórr Zonka baptaes bainüm, wa ibüka we bóktanórr wagó, “E blaman kolae balóng gwarab kupoakla! E igó gyagüpi tótókgu igó, e sab Godón wirri ngürsildügab kyab kórzinane, ne klama tótókóm kainda, wata ene zitülkusdü, e sab baptaes bairrün nóma koralo. ");
INSERT INTO tof_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yabü ubi ne nóma yarile Godón wirri ngürsildügab kyab kórzyónüm, e ngaen-gógópan morroal küp waon koralo yabiób ngyaben kugupidü! Yabü olgabi nómzyetórre wagó, e Godka kuri tübyalüngane yabiób kolae tonarrdógabi. Akó yabióbka igó bóktan-gu igó, ‘God sab kibü koke kolae tirre, zitülkus Eibrra-am kibü abbobate.’ Enana Eibrra-am yabü abbobat: wa yabü sab koke tangnamtirre Godón wirri ngürsildügab busom! Zitülkus módóga, ka yabü igó byaldóla, Godón gaodóma olmal tólbaelóm Eibrra-amónkü ini ingülküpdügabi! ");
INSERT INTO tof_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Errkya God kari pokoa pamkolpam kolae bainüm. Salmita nugup simkün ngarkwatódó olama, nugup singgalgónóm. Morroal küp koke ne nugupa waondako, sab singgalgórre ama urdü amórre.” ");
INSERT INTO tof_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pamkolpama Zonón imtinónóp wagó, “Ia ki ia kairre?” ");
INSERT INTO tof_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Zon ibü we nilóp wagó, “Nis sod mórrkenyórr ne noan nóma namüli, wa darrü olom ki ekyan, babul noa yarile. Akó alo noan yarile, wa olom ki tangamti, babul noa yarile.” ");
INSERT INTO tof_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Módóga, ⌊taks mani dakabain pama⌋ ta Zonka baptaes bainüm togobórr. Da we imtinóp wagó, “Umulbain pam, ki ia kairre?” ");
INSERT INTO tof_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Zon ibüka bóktan we yalkomólórr wagó, “E wata taks mani we ngarkwatódó dakabain kwarilo gida ne ngarkwatódóma, a e yabiób ubidügab kwit bamselgu.” ");
INSERT INTO tof_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Akó gazirr pama we imtinóp wagó, “Ki wa ia? Ki tai ia kairre?” Zon we yalkomólórr wagó, “E pamkolpam akrran-gu mani aliónüm, akó obae tiz-gu pamkolpamdó igó, i kolae tónggapónóp, igósüm, mani azebóm ibükagab. Gabamana yabü ne darrem kla aliónda, ene wata gaodó ki yarile.” ");
INSERT INTO tof_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pamkolpama gedlóngóm bainóp wagó, kubó errkyadan darrü klama módó tómbapóne, zitülkus ibü moboküpa igó bóktan kwarilürr wagó, Zon aprrapórr ene ⌊Kerriso-e⌋, God noa ki zirrsapóne ibü zid bainüm. ");
INSERT INTO tof_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Zon ibü we nilóp wagó, “Ka yabü nae-e baptaes baindóla, a wirri arüng nótóke kürükagab, wa tótókda. Ka ta ngarkwatódó kokela oya wapórdó bamel kla sye agom. Wa sab yabü Godón Samu-i akó uri baptaes bain yarile. ");
INSERT INTO tof_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Zono-zono paezan kla tangdóma ⌊wit⌋ küp aus bwóbdü, wit küp aleanóm buldügab. Wa wit küp kwób isue, ama gyagu müótüdü irrbüne, a bul ama bütamün-koke urdü yamsele.” ");
INSERT INTO tof_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zon Morroal Bóktan pamkolpamdó ngibürr abün arüng bóktane adrrat yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ngibürr tonarr kakóm Zon Errodón, Galili prrobins alngomól pam, we agórr wagó, “Ini gyabia, Errodiasón, moba naretan kol amiógüm! Akó ma abün ngibürr kolae tómbapón namülnürrü!” ");
INSERT INTO tof_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Errod akó darrü ini kolaean poko tónggapónórr: wa Zonón tümün müótüdü zirrapónórr. ");
INSERT INTO tof_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Errod solkwat Zonón tümün müótüdü zirrapónórr, ngaen-gógópan Zon blaman pamkolpam baptaes nóma ninóp, Yesun ta baptaes yónürr. Yesuzan tóre yarilürr, pülpüla ugón tapabakurr. ");
INSERT INTO tof_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Godón Samua kwitümgabi we tómngyelórr oya kwitüdü nurre póyae buli. Kwitüdügabi bóktan kümüla we sidórükürr wagó, “Ma kürü kólbanan olomla. Kürü ⌊moboküpdü ubi⌋ marükama. Ka kari barnginwóm kokela marüka.” ");
INSERT INTO tof_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu aprrapórr ugón 30 pail ngarkwat yarilürr, wa tóba Aban zaget nóma bókyanórr. Pamkolpama oya igó ngakan kwarilürr wa, Yesu ta Zosepón siman olome. Zosep Elin siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli Matatón siman olom yarilürr. Matat Libaen siman olom yarilürr. Libae Melkin siman olom yarilürr. Melki Zanaen siman olom yarilürr. Zanae Zosepón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zosep Matatiasón siman olom yarilürr. Matatias Eimosün siman olom yarilürr. Eimos Na-umón siman olom yarilürr. Na-um Eslin siman olom yarilürr. Esli Nagaen siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae Ma-atón siman olom yarilürr. Ma-at Matatiasón siman olom yarilürr. Matatias Semeinón siman olom yarilürr. Semein Zosekón siman olom yarilürr. Zosek Zodan siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda Zoananón siman olom yarilürr. Zoanan Rresan siman olom yarilürr. Rresa Zerrubbabelón siman olom yarilürr. Zerrubbabel Syealtielón siman olom yarilürr. Syealtiel Nerrin siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerri Melkin siman olom yarilürr. Melki Adin siman olom yarilürr. Adi Kosamón siman olom yarilürr. Kosam Elmadamón siman olom yarilürr. Elmadam Errón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Err Zosyuan siman olom yarilürr. Zosyua Eilieizerrón siman olom yarilürr. Eilieizerr Zorrimón siman olom yarilürr. Zorrim Matatón siman olom yarilürr. Matat Libaen siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libae Simionón siman olom yarilürr. Simion Zudan siman olom yarilürr. Zuda Zosepón siman olom yarilürr. Zosep Zonamón siman olom yarilürr. Zonam Eliakimón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Melean siman olom yarilürr. Melea Menan siman olom yarilürr. Mena Matatan siman olom yarilürr. Matata Neitónón siman olom yarilürr. Neitón ⌊Deibidün⌋ siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibid Zesin siman olom yarilürr. Zesi Obedón siman olom yarilürr. Obed Boazón siman olom yarilürr. Boaz Salmonón siman olom yarilürr. Salmon Nasonón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason Aminadabón siman olom yarilürr. Aminadab Adminün siman olom yarilürr. Admin Arrnin siman olom yarilürr. Arrni Ezrronón siman olom yarilürr. Ezrron Perrezón siman olom yarilürr. Perrez Zudan siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda Zeikobón siman olom yarilürr. Zeikob Aesakón siman olom yarilürr. Aesak Eibrra-amón siman olom yarilürr. Eibrra-am Terran siman olom yarilürr. Terra Na-orrón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Na-orr Sirrugün siman olom yarilürr. Sirrug Rreun siman olom yarilürr. Rreu Pelegón siman olom yarilürr. Peleg Eberrón siman olom yarilürr. Eberr Syilan siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Syila Kaenanón siman olom yarilürr. Kaenan Arrpaksadón siman olom yarilürr. Arrpaksad Syemón siman olom yarilürr. Syem Noan siman olom yarilürr. Noa Lamekón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Metuselan siman olom yarilürr. Metusela Inokón siman olom yarilürr. Inok Zarredón siman olom yarilürr. Zarred Ma-alalelón siman olom yarilürr. Ma-alalel Kaenanón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaenan Inosón siman olom yarilürr. Inos Setón siman olom yarilürr. Set Adamón siman olom yarilürr. Adam Godón siman olom yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu Zodan tobarr nóma amgatórr, Godón Samua oya büb gwarranórr, da we idódürr ⌊ngüin-koke bwóbdü⌋, ");
INSERT INTO tof_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","oya 40 ngürrüm ⌊debóla⌋ nóla alngomólóm kain yarilürr kolae tonarr tónggapónóm. Wa darrü kla koke elolórr ene ngarkwatóm. Ene 40 ngürra blakónóp, oya tai aloana we ipadórr. ");
INSERT INTO tof_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Da debóla oyaka we bóktanórr wagó, “Zitülkus ma Godón olomla, ma ini ingülküp ugó nilnünüm brredóm büzazinüm.” ");
INSERT INTO tof_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu bóktan we yalkomólórr wagó, “Koke! Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Pama brredane koke ngyabene.’” ");
INSERT INTO tof_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Olgabi debóla oya we idódürr wirri kwitüm pokodó, da oya blaman ini tüpan kingab balngomól bwób póyae-póyaebarr we emtyanórr. ");
INSERT INTO tof_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Oya we yalórr wagó, “Ka marü ngi akó arüng mókyeno ini bwób akó pamkolpam balngomólóm blaman arrbirrün elklazapükü, zitülkus kürünko. Da kürü kólbakama popa pam aliónüm. ");
INSERT INTO tof_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Da ma ne wakósingül nóma nülkamulo kürü ótókóm, da kubó blaman igósidi marü korale.” ");
INSERT INTO tof_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu bóktan we yalkomólórr wagó, “Koke! Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Ma wakósingül nülkamulo Lodón obzek kwata, marü God nótóke, akó wata oya ótók namulo.’” ");
INSERT INTO tof_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Akó debóla oya we idódürr Zerrusalem wirri basirrdü, da we emngyelórr ⌊Godón Gyabi Müót⌋ wirri kwitüm pokodó. Oya we yalórr wagó, “Zitülkus ma Godón olomla, algabi ugó aup. ");
INSERT INTO tof_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Zitülkus módóga, Godón Wialómórrón Bóktana igó bóktanda wagó, “‘God kubó tóba anerru arüng bóktan nókyerre marü adlangóm. ");
INSERT INTO tof_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","I marü kubó tibiób tange kwit mirre, igósüm ma moba wapór koke bómkolo ingülküpdü.’” ");
INSERT INTO tof_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu oya bóktan we yalkomólórr wagó, “Koke! Godón Wialómórrón Bóktana igó bóktanda wagó, ‘Ma Lodón moba God nótóke, apókgu, asenóm wa ia amkoman Goda.’” ");
INSERT INTO tof_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Debóla blaman ini tonarre enan kain yarilürr Yesun alngomólóm kolae tonarr tónggapónóm, da Yesun we amgatórr solkwat tonarróm dadan kla tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu Galili alkomólórr akó Godón Samuan arünga oya büb blaman gwarranórr. Akó oyakwata bóktana bayolórr basirr-basirr ene bwóbdü. ");
INSERT INTO tof_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wa tibiób kwóbbazen müótüdü nóma umul bain yarilürr, blamana oya dakla agür koralórr. ");
INSERT INTO tof_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wa Nazarret wirri basirrdü we wamórr, oya nóla dódórr inóp, da ⌊Sabad⌋ ngürrdü ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ we bangrinürr, zitülkus ene oya bókam tumtum yarilürr. Da wa we zamngólórr Godón Buk atangóm. ");
INSERT INTO tof_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Prropet Aesaya ne ⌊arrngamórrón peba⌋ wialómórr, oya we kla ekyenóp. Da nóma mórraongórr, igó poko esenórr wagó, ");
INSERT INTO tof_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lodón Samu kürükama, zitülkus wa kürü küngrinürr morroal bóktan büdrratóm elklaza-koke pamkolpamdó. Wa kürü ugósüm zirrkapónórr igó bóktan amgolóm wagó, ka sab ibü panzedó suso, ⌊ut-ut bairrün⌋ pamkolpam tümün müótüdü iszan nidipko, akó ilküküp murrbausürrün is dólóng ninünümo. Akó wa kürü ugósüm zirrkapónórr, igó pamkolpam ⌊aurdü amanóm⌋, ngibürr isa nibiób kle-kle ngabkandako, ");
INSERT INTO tof_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","akó igó bóktan amgolóm wagó, Ene tonarr kari pokoa Lodón tóba morroal tonarr pupo ainüm.” ");
INSERT INTO tof_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Da wa ene peba errngamórr, zaget pam we ekyanórr, da mórran-mórran we bainürr umul bainüm. Blaman pamkolpam ene kwóbbazen müótüdü nidi koralórr, ilküp wata oyaka koralórr. ");
INSERT INTO tof_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Da wa bóktan igó poko-e tapakurr wagó, “Ka ne poko etónga akó e kuri barrkrrua, errkyadan tómbapónóm kuri bairre!” ");
INSERT INTO tof_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Blamana oya nidi arrkrruóp, oyabóka mis apón kwarilürr. I gübarirr aengóp, oya taedógab ne ⌊gail tonarr⌋ bóktana baus kwarilürr. Da tibiób igó we bamtinónóp wagó, “Ini Zosepón olome, wa inzan tonarre iada bóktanda?” ");
INSERT INTO tof_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu ibüka igó we bóktanórr wagó, “Amkoman, e kubó igó ikik akrran bóktane tóptónane kürüka wagó, ‘Dokta, moba ugó dólóng byó.’ Akó e kubó tóptónane wagó, ‘Mobanan basirrdü kya kóbó tónggapó, ki barrkrrurrü wagó, ma Kaperrna-um wirri basirrdü ne ⌊arüng tonarr⌋ tómbapón namülnürrü.’” ");
INSERT INTO tof_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu ibüka akó we bóktanórr wagó, “Ka yabü amkoman poko byaldóla: prropet nótóke, sab tóbanan basirrdü morroal koke ipüdórre. ");
INSERT INTO tof_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Ka yabü amkoman poko byaldóla, ngaen Ilaeza prropet nóma yarilürr, Isrraelóm abün kóble koralórr. Ene tonarrdó aüd akó poko pailüm ngup babulan yarilürr, da ene ngarkwatóm kari kolae ku koke yarilürr blaman Isrrael tüpdü. ");
INSERT INTO tof_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Da God ta Ilaezan ibü darrü Isrrael pamdó kokean zirrapónórr, a wa ma oya darrü kóble tangamtinüm zirrapónórr Zarrepat wirri basirrdü, Saedon wirri basirr minggüpanan. ");
INSERT INTO tof_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Akó solkwat, prropet Ilaesyan tonarrdó, ola ugón Isrraelóm abün soso azid pamkolpam koralórr. Da God ta ibü darrü kokean dólóng yónürr, wata darrü pam ngi Neiman, Sirria bwóbdügab, oya dólóng yónürr.” ");
INSERT INTO tof_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Blaman pamkolpam kwóbbazen müótüdü nidi koralórr, ibü blaman kari ngürsila koke yazebórr ini bóktan nóma barrkrrurr. ");
INSERT INTO tof_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Da i we bazebórr, oya olgabi amorrat-amorrat we idüdóp basirr kalkuma. I oya idüdóp kókó podo zonodó, Nazarret basirr ne aelórrón yarilürr. Ibü ubi igósüm yarilürr, oya olgabi ki simaikrre. ");
INSERT INTO tof_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Da wa tübyalüngürr, ibü aoanana we sitülürr, ama tóba kwata wamórr. ");
INSERT INTO tof_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu Nazarret pododógab we tübinürr ama Kaperrna-um wirri basirrdü, Galili prrobins kugupidü. Sabad ngürrdü, wa pamkolpam Godónbóka we umul bain yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","I gübarirr aengóp, wa ne ngarkwatódó umul nyónónóp, zitülkus oya bóktan balngomól arüngpükü kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ene kwóbbazen müót kugupidü ola darrü pam asi yarilürr kolae samua noan bübdü ngyaben yarilürr. Kolae samua ene pam we zirratakórr wirri arüngi taegwarr apónóm wagó, ");
INSERT INTO tof_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei, Yesu, Nazarret olom! Marü ubi laró tónggapónóma kibüka? Ia ma kibü kolae bainüm tama? Ka umulóla ma nótókla. Ma Godón Gyabian Olomla!” ");
INSERT INTO tof_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu ene kolae samu agórr wagó, “Piküp bai! Ma ugó tubrra we pamdógab!” Ene kolae samua ene pam we singalkalórr pamkolpamab obzek kwata. Da we tubrranórr ene pamdógabi. Darrü azid koke ekyanórr. ");
INSERT INTO tof_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Blaman pamkolpama gübarirr aengóp, da tibióbka we zwapólórr wagó, “Ini go laró bóktana? Wa kolae samu dele tomkompükü akó arüng bóktan aliónda, da i bausdako!” ");
INSERT INTO tof_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesunkwata bóktana blaman minggüpanan basirr-basirr we büdólórr. ");
INSERT INTO tof_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Olgabi Yesu kwóbbazen müót we amgatórr, ama Saemonón müótüdü bangrinürr. Ugón Saemonón mónang wirri güb azid warilürr. Yesun yatop oya dólóng ainüm. ");
INSERT INTO tof_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Da Yesu oya minggüpanan anenórr da güb azid we agórr wagó, “Azid, ma oya zumgat!” Wata we zumgatórr. Wa dümdüman we bupadórr, da ibü alo kla we nganinóp. ");
INSERT INTO tof_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Abüsa nóma mórralórr, pamkolpama tibiób ia-ia abün azid gómdamal tübarrmülürr Yesuka. Wa wata tangan nóma amel yarilürr ibü darrpan-darrpandó, ibü blaman dólóng nyónónóp. ");
INSERT INTO tof_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kolae samua ta abün pamkolpamdógab baus kwarilürr igó taegwarrkü wagó, “Ma amkoman Godón Olomla!” A Yesu ma ibü nagóp; ibü koke ok ninóp bóktanóm, zitülkus i umul koralórr wagó, wa ene ⌊Kerriso-e⌋. ");
INSERT INTO tof_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sisa nóma balgólórr, Yesu ene basirr amgatórr, da kolpam-koke bwóbdü wamórr. Olgabi pamkolpama amkünüm we bainóp. Oya nóma esenóp, oya arrmatóm we yangónónóp. ");
INSERT INTO tof_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Da ibü we nilóp wagó, “Ka wata kubó wamo ngibürr pamkolpamdó ngibürr basirrdü, Morroal Bóktan büdrratóm Godón Kingzan Balngomólankwata, zitülkus God kürü ugósüm zirrkapónórr.” ");
INSERT INTO tof_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yesu we wamlórr basirr-basirr Zudia prrobins kugupidü, Godónkwata Morroal Bóktan amgolkü abün Zu pamkolpamab kwóbbazen müótüdü. ");
INSERT INTO tof_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Darrpan ngürr Yesu Genesarret Malu kabedó zamngólólórr. Da pamkolpama oya myangrao apónóp Godón bóktan arrkrrum, tibiób zamngól pabo bóleankü. ");
INSERT INTO tof_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wa nis but nósenórr malu kabedó amrókrrón, wapi baib pama ne kla nümgütóp. Ene pama tibiób net bagulnónóp. ");
INSERT INTO tof_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu darrü ene butüdü kasilürr, Saemonón ne kla yarilürr. Da Saemonón imtinürr karianbóka but aodóbóna anenóm. Yesu mórranórr butüdü, da pamkolpam olgabi umulbain yarilürr, garoardó nidi kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesun pamkolpam umulbaina nóma blakónórr, da Saemonón yalórr wagó, “But yane kukurru bwóbdü net agóbóm naedó, wapi bumiógüm.” ");
INSERT INTO tof_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Da Saemon Yesunbóka wagó, “Wirri pam, ki wapim dudu irrüb enan kuri baerrla. Da taia, mazan namüla, ka kubó but amaiko aodó, net amanóm.” ");
INSERT INTO tof_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","I ene poko nóma tólaelóp, da abün wapi bumigóp; neta batürrüm kain kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Da módóga, darrü butüdü kamdal pamdó tang bóngapnóp, ibü tangbamtinüm tótókóm. I nóma togobórr, nizan but nis nanop, kókó but nisa nae baitüm kain namülnürri. ");
INSERT INTO tof_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saemon Pita ene tonarr nóma esenórr, wa tüp we simbalkalórr, wakósingüli mórranórr Yesun obzek kwata. Wagó, “Usi wam kürükagab, Lod, zitülkus ka kolae tonarr pamla!” ");
INSERT INTO tof_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Wa inzan igósidi bóktanórr, zitülkus watóka akó i nisakü kwarilürr ene nis butüdü, blamana gübarirr aengóp, i ne abün wapi bumigóp. ");
INSERT INTO tof_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saemonón wapi baib gódam nis Zeims akó Zon, Zebedin olom nis, ta gübarirr aengrri. Yesu Saemonón yalórr wagó, “Ma gumgu! Ini tonarrdógab kókó ugórr, ma sab pamkolpam bumiógolo.” ");
INSERT INTO tof_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ene kakóm, i blamana tibiób but sórenóp, blaman kla ola bimgütóp, da Yesuka we zutalórr. ");
INSERT INTO tof_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu darrü wirri basirrdü nóma yarilürr, da darrü pam ola asi yarilürr, büb blaman soso azida gwarrarrón. Wa Yesun nóma esenórr, wa tóba we bumanikürr, wakósingül nülkamülürr, singül ama tüp, da wa yatorr wagó, “Wirri Pam, marü ubi ne nóma yarile, ma gaodó namulo kürü tóman arrgonóm Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu tóba tang orrakórr, da ene pam we yamurrürr. Yesu oyaka we bóktanórr wagó, “Kürü ubia. Tómana ki barrgonóm!” Dümdüman, ene soso azida we amgatórr. ");
INSERT INTO tof_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Da Yesu oya arüng bóktan ekyanórr wagó, “Ma darrü olom azazilgu! A ma wam prristdü, moba bómtyanke, da wa marü büb sopae tai ki ngamka. Ma ⌊gyaur kla⌋ kubó ⌊Godón Gyabi Müótüdü⌋ idódke prrista ola urdü agasilüm marü tóman barrgonóm Godón ilküpdü, Moses ne gida bóktan pokozan nókyenóp. Ene igósüm, pamkolpam amtyanóm igó, marü soso azida kuri blakóne, da marü tómana kuri barrgone Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","A Yesunkwata bóktana we wirribóka bayolórr ngaendógab. Ini zitülkusdü abün pamkolpama serrngamlórr bóktan arrkrrum, wa ne poko umulbain yarilürr, akó Yesu ibü dólóng bainüm tibiób azidüdügab. ");
INSERT INTO tof_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A Yesu bobarr piküpan burrualórr kolpam-koke bwóbdü tórem. ");
INSERT INTO tof_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Darrpan ngürr, Yesu pamkolpam nóma umulbain yarilürr, abün ⌊Parrisi⌋ akó Mosesón gida umulbain pama ola bobrralórr. I darrpan-darrpan basirrdügabi togobórr Galili prrobins, Zudia prrobins, akó Zerrusalem wirri basirrdügabi. Da Lodón arüng Yesuka asi yarilürr pamkolpam azidüdügab dólóng bainüm. ");
INSERT INTO tof_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Da módóga, ngibürr pama togobórr Yesu ne müótüdü yarilürr. I darrü büb bidal pam sidüdóp rraparrapadó. Ibü ubi ene müótüdü barrbünüm yarilürr Yesun obzek kwata angrinüm. ");
INSERT INTO tof_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Da i gaodó koke kwarilürr barrbünüm, zitülkus pamkolpamab ngoro ola yarilürr. Módóga, i mórrkakakdó bamselórr ene pampükü, da tae apónóp. Da módóga, ene mórrkakak tae apórrón kwata we tüp solkomólóp tóba rraparrapadó, tai pamkolpamab aodó, Yesun obzek kwata. ");
INSERT INTO tof_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu ibü amkoman bangun nóma esenórr, wa ene büb bidal pamdó bóktanórr wagó, “Gódam, ka marü kolae tonarr kuri norrgonónóma!” ");
INSERT INTO tof_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A Parrisi akó Mosesón gida umulbain pama igó gyagüpi tótók kwarilürr wagó, “Ini pam ia nótóke, Godón pabo nótó apadóm kainda? Gaodó ia nótóke kolae tonarr barrgonóm, a wata God tebean?” ");
INSERT INTO tof_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu ibü gyagüpitótók yazebórr, da bóka nütünóp wagó, “E wa ini poko yabiób moboküpdü iade gyagüpi tótókdakla? ");
INSERT INTO tof_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ini nis bóktan nisdügab, ia kürüka ulan nadü bóktana bóktanóm? Ia, ‘Marü kolae tonarr barrgorrónako,’ ta ia, ‘Bupa, da ma agólóm bai’? ");
INSERT INTO tof_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Da kürü ubi igósüma, e kubó ini kla umul bainane wagó, kürüka, Pamkolpamab Olom nótókla, balngomól arüng asine ini tüpdü kolae tonarr barrgonóm.” Da wa ene büb bidal pamdó bóktanórr wagó, “Ka marü ayaldóla, ugó bupa, moba nyórr ipa da ugó wam moba müót basirrdü!” ");
INSERT INTO tof_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Dümdüman ene pama we bupadórr pamkolpamab obzek kwata. Wa tóba ut kla ipadórr, wa ne klamdó ut yarilürr, da we wamórr tóba müót basirrdü Godón agürkü. ");
INSERT INTO tof_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ene pamkolpama wirri gübarirr aengóp akó i Godón we yagürnóp. I blaman kari gum koke kwarilürr Godón ⌊arüng tonarrdógab⌋, da zwapólórr wagó, “Ki errkya asen-koke tonarr kuri eserre!” ");
INSERT INTO tof_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ene kakóm, Yesu ene müót amgatórr, da darrü ⌊taks mani dakabain pam⌋ esenórr ngi Libae, tóba kari zaget müótüdü mórrande. Yesu oyabóka wagó, “Yao, ma kürüka tókya.” ");
INSERT INTO tof_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Libae we bupadórr, blaman elklaza we bimgatórr, oyaka we akyanórr. ");
INSERT INTO tof_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","We kakóm, Libae wirri alongalo tólaelórr tóba müótüdü Yesunkü, da Yesu tóba umulbain olmalpükü wamórr. Abün taks mani dakabain pam akó popa kolpamapükü alongalo kwarilürr ene müótüdü. ");
INSERT INTO tof_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ngibürr Parrisi akó Mosesón gida umulbain pama murrkurr nókrrónóp Yesun umulbain olmal. I bóktónóp wagó, “E taks mani dakabain pam akó kolae tonarr kolpampükü iade alo akó anóndakla?” ");
INSERT INTO tof_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","A Yesu ma ibüka bóktan yalkomólórr wagó, “Azid-koke kolpam nidipko, i dokta koke amkündako, wata azid nidipko. ");
INSERT INTO tof_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ka ini tüpdü igósüm koke tamórró igó, dümdüm ngyaben pamkolpam ngibaunüm. A ka wa kolae tonarr pamkolpam ngibaunüm tamórró Godka byalüngüm kolae tonarrdógab.” ");
INSERT INTO tof_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ngibürr pamkolpama Yesun imtinóp wagó, “Zon ⌊Baptaes Bain⌋ paman umulbain olmala bobarr alo bütókdako tórem. Akó Parrisiab umulbain olmala ta inzan. A marü umulbain olmala ma metat iade alo akó anóndako?” ");
INSERT INTO tof_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu tóbakwata alap-alap bóktanórr ibüka wagó, “E ia gaodómakla pamkolpam zirrbótakóm alo bütóküm kol amióg tóredó, kol amióg pam ibüka nómade? Koke! ");
INSERT INTO tof_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","A ene ngürr sab semrróne, kol amióg pam ibükagabi nóma sipüdrre. Da ene ngürrdü i sab alo ugón bütókrre.” ");
INSERT INTO tof_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu akó ibüka ini alap-alap bóktan adrratórr wagó, “Darrü pama küsil mórrkenyórr poko koke atürre ngaep mórrkenyórrdü arrgüpüm tae murrausüm. Wa ne nóma tólaele, ene küsil mórrkenyórr sab atürre, akó ene küsil mórrkenyórr pokoa sab kokean tórrmamóle ene ngaep mórrkenyórrdü. ");
INSERT INTO tof_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Darrü pama küsil waen koke errngóme ngaep lar sopae beledó. Wa ne nóma tólaele, ene küsil waena kubó ene ngaep bele amkene. Ene waena kubó bókóne akó ene lar sopae belea sab kolae baine. ");
INSERT INTO tof_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","We gaodó, pamkolpama küsil waen ki bórrngómam küsil lar sopae beledó. ");
INSERT INTO tof_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pamkolpama sab ubi koke bairre küsil waendó ngaep waen anón kakóm, zitülkus i igó bóktandako wagó, ‘Ngaep waen kekama.’” ");
INSERT INTO tof_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Darrpan Sabad ngürrdü, Yesu tóba umulbain olmalpükü ⌊wit⌋ apapana nóma tótók yarilürr, oya umulbain olmala ngibürr wit küp we zulkulóp. I tange balkomen koralórr bul amanóm küp alom. ");
INSERT INTO tof_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ngibürr Parrisia ibüka we bóktónóp wagó, “E ene zaget iade tónggapóndakla, gyabi ne klame Sabad ngürrandó?” ");
INSERT INTO tof_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu bóktan we yalkomólórr wagó, “E ia koke kuri etóngarre Godón Wibalómórrón Bóktandó, Deibid ne kla tónggapónórr, we tonarr, wa tóba pam kopopükü alom nóma yarilürr? ");
INSERT INTO tof_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Wa Godón ⌊Palae Müótüdü⌋ bangrinürr, ene gyabi brred yazebórr, prrista Godón obzek kwata ne kla urrbulürr, da we elorr. Ngibürr tóba pam nülinóp. A Mosesón gida ngarkwatódó dümdüm kokea ene brred alom; wata prristab dümdüme ene brred alom!” ");
INSERT INTO tof_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesu ibüka akó we bóktanórr wagó, “Ka Pamkolpamab Olomzanla, ka Sabadan Lodla.” ");
INSERT INTO tof_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Akó darrü Sabad ngürrdü wa darrü ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ bangrinürr, da umul bailürr. Ola darrü pam yarilürr, tutul tang bidal akó sarrpi airrün. ");
INSERT INTO tof_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Parrisi akó Mosesón gida umulbain pama kwat amkün kwarilürr Yesun kotóm ain bóktan amanóm, da oya tai ilküpane we idódnóp wa, ia wa kubó Sabad ngürrdü pam dólóng ine. ");
INSERT INTO tof_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A Yesu ma umul yarilürr i ne poko gyagüpi ogoblórr, da wa ene tang bidal pamdó we bóktanórr wagó, “Ugó bupa, da zamngól blamanab aodó.” Da wa bupadórr a we zamngólórr. ");
INSERT INTO tof_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Da Yesu ibüka we bóktanórr wagó, “Ka yabü bamtindóla, mibü gidadógab ia taia Sabad ngürrdü morroal tónggapónóm, ta ia kolae tónggapónóm; ia arról zid ainüm, ta ia arról kolae ainüm?” ");
INSERT INTO tof_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ibü ola ngabkanda, da ene pamdó we bóktanórr wagó, “Moba tang ugó adrrat.” Wa inzan tónggapónórr, da oya tanga tóba gaodó alkomólórr. ");
INSERT INTO tof_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ene zitülkusdü i ngürsilüm bainóp, da tibiób agom we bainóp wagó, “Mi Yesuka ia laró tónggapórre?” ");
INSERT INTO tof_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ene tonarrdó, Yesu we wamórr pododó tórem. Irrüb we amanikürr Godka tórede. ");
INSERT INTO tof_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Irrbi, wa tóba umulbain olmal tóbaka we ngibaunürr, da 12 we ilianórr, wa apostolóm nibiób ngibasilürr. ");
INSERT INTO tof_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ene 12 módógako: Saemon (noan ngyesilürr Pita); oya narezoret Endrru; Zeims akó Zon; Pilip akó Barrtolomyu; ");
INSERT INTO tof_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Metyu akó Tomas; Zeims, Alpeiusün olom nótó yarilürr, akó Saemon (akó ngiliarrón Zilot), ");
INSERT INTO tof_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zudas, Zeimsün olom nótó yarilürr, akó Zudas Iskarriot, Yesun sab nótó ingrine wirri ngi pamab tangdó. ");
INSERT INTO tof_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Olgabi Yesu tóba apostolpükü we tübinürr, da we zamngólórr buruburudü. Ola oya abün umulbain olmal akó pamkolpamab ngoro kwarilürr, blaman Zudia prrobinsdügabi, Zerrusalem wirri basirrdügabi, akó ene bwóbdügabi, Taerr akó Saedon ne namülnürri, malu kabedó ne wirri basirr nis, ");
INSERT INTO tof_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","nidi togobórr oya bóktan arrkrrum akó dólóng bainüm tibiób azidüdügab. Akó kolae samua nibiób kolae bailürr, da we dólóng ninóp. ");
INSERT INTO tof_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Akó blaman pamkolpamab ubi wata oya amurrum yarilürr, zitülkus dólóngbain arünga oyakagab tótók yarilürr, da wa ibü blaman dólóng we ninóp. ");
INSERT INTO tof_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Da Yesu tóba umulbain olmaldó yazilürr, da we bóktanórr wagó, “Bagürwóm yadipakla, elklaza-koke nidipakla, zitülkus yabü God balngomólda Kingzan! ");
INSERT INTO tof_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bagürwóm yadipakla, errkya alom nidipakla, zitülkus yabü bikóm sab byamrókórrón kwarile! Bagürwóm yadipakla, errkya nidi yóndako, zitülkus e sab ngüóng órnae kwarilo! ");
INSERT INTO tof_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Bagürwóm yadipakla, pamkolpama yabü nóma alzizi amandako, yabü nóma amaiksimaik nangónórre, kle-kle nóma nyalnórre, akó ngi nóma kolae nyónórre, zitülkus e kürü, Pamkolpamab Olom nótókla, amkoman angundakla! ");
INSERT INTO tof_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","E bagürwóm akó bórzyón kwarilünke ene ngürrdü, zitülkus yabü wirri darrem kwitüm asise. Ene ka igósidi byaldóla, zitülkus ibü abalbobatala ene prropet inzan bangón kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“A sab Godón ngürsila tame yabüka, e mórrel pam nidipakla: yabü sab myamem babul yarile. E yabiób ngaen yazebarre! ");
INSERT INTO tof_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Sab Godón ngürsila tame yabüka, errkya morroal nidi kómóp bapóndakla: sab e alom kwarilo. Sab Godón ngürsila tame yabüka, e nidi ngüóng órnaedakla: sab e yón gyaur akó yón kwarilo. ");
INSERT INTO tof_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Sab Godón ngürsila tame yabüka, blaman pamkolpama yabü nóma agürdako, zitülkus ibü abalbobatala obae prropet ta inzan bangón kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“A ka yabü igó byaldóla, kürü nidi arrkrrudako, yabü moboküpdü ubi ta ibüka asi ki kwarilün, yabü gómdamal-koke nidipko; morroal tónggapónamke, yabü nidi alzizi amandako. ");
INSERT INTO tof_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Bles ain bóktan nülinam, yabü amórr bóktan nidi alióndako; e tóre koralo ibünkü, yabü kle-kle nidi bangóndako. ");
INSERT INTO tof_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Da marü ne ngorrkob nótó nóma mómkóle tang o-e marü büódan ngitanóm, akó dakla ngorrkob emtya amkalóm. Akó marü tumum mórrkenyórr nótó nóma ipüde, ma sod mórrkenyórr ta koke irrmüta. ");
INSERT INTO tof_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Marü darrü klamóm nótó nóma mato-e, ma oya ekya, akó marü darrü kla nótó nóma mürrkine, ma oya myamem koke yatoa alkomólóm. ");
INSERT INTO tof_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mazan ubila pamkolpama marü ne tonarr ngarkwatódó angón kwarile, ma ta ibü ene tonarr ngarkwatódó bangón namulo. ");
INSERT INTO tof_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Yabü ne moboküpdü ubi wata ibüka nóma kwarile, moboküpdü ubi nibióbe yabükamóm, yabüka ene laró darrema? Babula! Zitülkus módóga, kolae tonarr isab moboküpdü ubi ta ibükamako, moboküpdü ubi nibióbe ibükamóm! ");
INSERT INTO tof_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","E ne wata morroal nóma tómbapóndakla ibüka, yabüka morroal nidi tómbapóndako, yabüka ene laró darrema? Babula! Zitülkus módóga, kolae tonarr isa ta inzan kaindako! ");
INSERT INTO tof_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Akó e ne mani nóma alióndakla tibióban, e nibióbka gedlóngóm baindakla darrem akonóm, yabüka ene laró darrema? Babula! Kolae tonarr isa kubó kolae tonarr is mani nülirre, zitülkus i umulako wagó, i sab akó dudu sakorre! ");
INSERT INTO tof_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","A yabü moboküpdü ubi ibüka asi ki kwarilün, yabü gómdamal-koke nidipko, morroal tónggapólamke ibüka. E ne mani alióndakla, darrem azebóm gyagüpi tótókgu. Ini pokodógab yabü darrem sab wirri yarile. E sab Wirri Kwitüm Godón olmal kwarilo, zitülkus wa morroal tonarra ibüka, oya eso bóktan kokean nidi akyandako akó ibüka, kolaean is nidipko. ");
INSERT INTO tof_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yabü Abanzan gyaure pamkolpamdó, yabü gyaur ta sab inzan ki yarilün. ");
INSERT INTO tof_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ngibürr kolpam zaz bain-gu, igósidi yabü ta God sab koke zaz nirre. Ngibürr kolpamdó bóktan-gu igó, ‘E kolae tónggapónarre’, igósidi yabüka God sab koke bóktóne wagó, ‘E kolae tónggapónarre’. Ngibürr kolpamab kolae tonarr norrgonónóm, igósidi yabü kolae tonarr God ta sab norrgorre. ");
INSERT INTO tof_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","E ngibürr nüliólam, da God sab yabü nülirre. Ene amkoman: God sab yabü dudu akó ngaru bapón-koke nülirre. Zitülkus módóga, ma ne atanin klame atanindóla, ene klame marü sab ngibürra mütanirre.” ");
INSERT INTO tof_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu akó ibü ta ini alap-alap bóktan nilóp wagó, “Ia ilküküp murrbausürrün pama kamad kuri elngomóle? Ia i sab nizana koke aupi kugupidü? ");
INSERT INTO tof_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Umulbain olom wirri kokea tóba umulbain pamdógabi, a blaman umulbain ne nótó yazeble, sab wa tóba umulbain pamzan yarile. ");
INSERT INTO tof_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ia ma moba zonaretan ilküpdü püip iade ngakandóla? A marü moba ilküpdü ne nugup poko-e, ma wa koke iade asendóla? ");
INSERT INTO tof_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ia ma kubó moba zonaretódó igó iade bóktono wagó, ‘Zware, ka kya marü ilküpdü we püip urruanón,’ a ma ma moba koke iade asendóla igó, marü moba ilküpdü nugup poko asine? Ma taepurrane bóktan pamla! Ma ngaen-gógópan moba ilküpdü ne nugup poko ugó irrua, da ma sab igósidi tai eseno moba zonaretan ilküpdü ne püipe arruanóm. ");
INSERT INTO tof_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Morroal nugupa kubó kolae küp koke bapóne, ó kolae nugupa kubó morroal küp koke bapóne. ");
INSERT INTO tof_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nizan nugup kubó tibiób küpdügab nómzyetórre. Pamkolpama kubó ⌊pig⌋ ngórr tórez-tórez syepor zidüdügabi koke alkülórre akó i kubó ⌊grreip⌋ ngórr tórezpükü nugup zidüdügab koke ilumórre. ");
INSERT INTO tof_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Morroal oloma morroal elklaza ausda moboküpdügab, morroal ne klame. A kolae oloma kolae elklaza ausda moboküpdügab, kolae ne klame. Zitülkus módóga, darrü oloman taea we poko bóktanda, oya moboküpdü ne klame. ");
INSERT INTO tof_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ia e kürü iade ngiliandakla wagó, ‘⌊Lod⌋ Lod,’ a e ama koke tómbapóndakla ka yabü ne poko byaldóla? ");
INSERT INTO tof_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ka yabü inzan nómtyenónómo, wa ia pama, wa ne kürü bóktan nóma arrkrruda akó tórrmendó angrinda. ");
INSERT INTO tof_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wa inzan pama, tóba müót nótó elórr. Tüp ilüngürr kókó wa ingülküp emrranórr. Da müót we alangórr. Naiz naea nóma tamórr, wirribóka selkalórr, da koke inurr, zitülkus morroal aelórrón yarilürr ingülküpdü. ");
INSERT INTO tof_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akó kürü bóktan nótó arrkrruda, a koke nótó tórrmendó angrinda, inzan pama tüpandó zitülkus-koke bwóbdü tóba müót nótó elórr. Ene tonarr naiza nóma selkalórr, dümdüman we bülgatórr - karibóka-koke sip tóbayorr!” ");
INSERT INTO tof_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesun pamkolpamdó bóktana nóma blakónórr, da we wamórr ama Kaperrna-um wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rrom gazirr pamab kopo ngakan wirri pam, oya leba zaget olom asi yarilürr, da ene gazirr wirri pama oya karibóka-koke yagürlürr. Ene leba zaget olom kari azid koke yarilürr, büdül kari poko. ");
INSERT INTO tof_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ene gazirr wirri pama Yesunbóka nóma arrkrrurr, wa ngibürr Zu pamkolpamab ⌊balngomól byarrmarr pam⌋ we zirrnapónóp oyaka, oya amtinüm tótókóm ene azid olom dólóng ainüm. ");
INSERT INTO tof_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","I we ogobórr a Yesun moboküpi yatop wagó, “Ini pam ngarkwatódóma; marü tangbamtin wata asi yarile, ");
INSERT INTO tof_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","zitülkus oya ⌊moboküpdü ubi⌋ Zu pamkolpamdó asine, akó mibü ⌊Zu isab kwóbbazen müót⌋ aelóm mani küp ekyanórr.” ");
INSERT INTO tof_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Da módóga, Yesu inkü we wamórr. Yesu ene gazirr pamab kopo ngakan wirri paman müót minggüpanan nóma tamórr, ene gazirr wirri pama tóba gómdamal zirrnapónóp Yesun azazilüm ini bóktanpükü wagó, “Lod, elklaza müp bain-gu mobankü, zitülkus ka ngarkwatódó kokela, ma kürü müótüdü koke tübangrino. ");
INSERT INTO tof_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","We ngarkwatódó, ka gyagüpi koke tótókdóla wagó, ka ngarkwatódómla marüka tótókóm. Ma wata tae opore bókta, da kürü leba zaget oloma kubó dólóng baine. ");
INSERT INTO tof_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ka umulóla marü gaodóma ini poko tónggapónóm, zitülkus ka küób igó olomla, ka ngibürr pamab tüpana zagetdóla. Akó ngibürr gazirr pam asiko, kürü tüpana nidi zagetódako. Ka kubó darrü igó nóma ilo igó, ‘Wam!’ wa kubó wame. Akó darrü igó nóma ilo igó, ‘Tam!’ wa kubó tame. Ka kólba leba zaget olom nóma ilo igó, ‘Ene kla tólael!’ wa kubó tólaele. Enta inzana, azida marü bóktan kuri arrkrrue!” ");
INSERT INTO tof_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu ini bóktan nóma arrkrrurr, wa we gübarirr aengórr. Wa tübyalüngürr a bóktanórr pamkolpamab ngorodó oya nidi mamoanónóp wagó, “Ka yabü igó byaldóla, ka darrü inzan pam koke kuri seserró, kürü amkoman wirri arüngi nótó angunda, Isrraelóm ta kokean!” ");
INSERT INTO tof_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ene gazirr wirri pama nibiób zirrnapónóp oya müótüdü nóma bakonórr, oya leba zaget olom ama kekam emrrónóp. ");
INSERT INTO tof_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aibwób babul ene kakóm, Yesu darrü wirri basirrdü we wamórr, ngi Nein. Oya umulbain olmal akó wirri pamkolpamab ngoroa wankü ogoblórr. ");
INSERT INTO tof_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yesu ene wirri basirran barrbün mamtae minggüpanan nóma tamórr, da módóga, pamkolpama ama büdül olom sidódnóp ene basirrdügab, alüngüm. Oya aip kóble warilürr, ó oya wata darrpanan siman olom yarilürr. Oya wirri pamkolpamab ngoroa tolngomólóp. ");
INSERT INTO tof_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lod ene kol nóma osenórr, wa kari gyaur koke yarilürr oyaka. Wa bóktanórr wagó, “Ma yón-gu.” ");
INSERT INTO tof_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Olgabi wa ae wamórr a ene koben yamurrürr, da ne pama ódód kwarilürr, bólenóp. Yesu bóktanórr wagó, “Omokur, ka marü ayaldóla, ugó bupa!” ");
INSERT INTO tof_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ene büdül omokura saogórr, da mórran-mórran bainürr, ola ikikda! Olgabi Yesu oya aipan tangdó ingrinürr. ");
INSERT INTO tof_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Blaman pamkolpama Godón gum kwarilürr, akó dakla Godón yagürnóp. I zwapólórr wagó, “Darrü wirri prropeta mibüka kuri okaka tübine!” akó, “God kuri tame tóba pamkolpam tangbamtinüm!” ");
INSERT INTO tof_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ini bóktana Yesunkwata we bayorr Zudia prrobins kugupidü akó minggüpanan bwóbdüma. ");
INSERT INTO tof_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Zon Baptaes Bain Paman umulbain olmala Zonón izazilóp Yesu ne poko tómbapólórr. Da Zon wata tóba nis umulbain olom nis nginaunürr, ");
INSERT INTO tof_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","da we zirrnapónórr Lodka oya amtinüm wagó, “Ia ma módógla nótó ki tame, prropeta noabóka apón kwarilürr, ta ia ki darrü pam akyan kwarilo?” ");
INSERT INTO tof_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ene umulbain olom nisa Yesuka tübzirri, da oyaka bóktarri wagó, “Zon baptaes bain pama kibü wató zirrtapóne marü amtinüm, ‘Ia ma módógla, nótó ki tame, prropeta noabóka apón kwarilürr, ta ia ki darrü pam akyan kwarilo?’” ");
INSERT INTO tof_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","I olazan namülnürri, ibü wapi Yesu azid pamkolpam dólóng bain yarilürr akó kolae samua nibiób büb kugupidü ngyaben kwarilürr. Akó wa abün ilküküp murrbausürrün pamkolpam dólóng nyónónóp ngabkanóm. ");
INSERT INTO tof_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Da módóga, Yesu Zonón umulbain olom nis darrem bóktan we nókyanórr wagó, “Ugó alkomólam, da Zonón izazilamke, e ne kla nóserre akó ne poko arrkrru-i: ilküp murrbausürrün nidi kwarilürr, errkya basendako, akó wapór bidal nidi kwarilürr, errkya agóldako. Soso azid nidi balmilnóp, errkya dólóng airrünako. Güblang murrbausürrün nidi kwarilürr, errkya arrkrrudako. Büdül nidi kwarilürr, akó arrólako. Akó elklaza-koke pamkolpama Godón Morroal Bóktan arrkrrudako. ");
INSERT INTO tof_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bagürwóm watóke, ninis gyagüpitótók babul noakame kürükwata!” ");
INSERT INTO tof_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Zonón bóktan ódód pam nisa nóma bupadürri, Yesu ugón pamkolpamab ngorodó bóktan we bókyanórr Zonónkwata wagó, “E wa ⌊ngüin-koke bwóbdü⌋ laró asenóm ogobnórró? Ia e twal asenóm ogobnórró, wóra ne kla angapda? Koke! ");
INSERT INTO tof_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Da e wa tai laró asenóm ogobnórró? Ia morroal mórrkenyórr bamelórrón pam? Koke! Wirri darrem mórrkenyórr nidi bameldako akó abün elklaza tumum nidi ngyabendako, kingab wirrian müótüdü ngyabendako, a ngüin-koke bwóbdü koke. ");
INSERT INTO tof_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Da e wa tai laró asenóm ogobnórró ngüin-koke bwóbdü? Ia prropet? Ó, ene amkoman. Ka yabü igó byaldóla, e wa amkoman wirrian pam esenarre ngibürr prropetódógab. ");
INSERT INTO tof_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Zon we pama, ngaen Godón Wialómórrón Bóktana noanbóka apónda, God ⌊Kerrisodó⌋ ne poko bóktanórr wagó, “‘Turrkrru! Ka sab bóktan ódód pam zirrapono marü singül kwata. Wa marü kwat sab wató ngagróte.’ ");
INSERT INTO tof_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ka yabü igó byaldóla, darrü pama koke kuri tómtómólórr yabü aodó wirrian nótóke Zon Baptaes Bain Pamdógab. A kari ngi olom nótóke Godón Kingzan Balngomóldó, wa wirriana Zonkagab.” ");
INSERT INTO tof_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Blaman pamkolpam akó ta ⌊taks mani dakabain pama⌋, oya bóktan nidi arrkrruóp, babinürr wa, Godón kwat dümdüma, zitülkus Zon ibü wató baptaes ninóp. ");
INSERT INTO tof_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","A Parrisi akó Mosesón gida umulbain pama Godón tónggapórrón bóktan tibióbkü alzizi amanikóp, zitülkus i bangónóp Zon ibü koke ki baptaes nirre. ");
INSERT INTO tof_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu wagó, “Ia ka ini lüólan pamkolpam larópükü nütaninünümo? I ia iadako? ");
INSERT INTO tof_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","I kari olmalpókalzanako, pul basirrdü nidi mórrandako akó tibióbka górrgandako wagó, “‘Ki yabünkü marret tatarror apul kwarilnürrü, a e zil koke kwarilnürrü; ki büdül yónamto wórr bato kwarilnürrü, a e yón gyaur koke kwarilnürrü.’ ");
INSERT INTO tof_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ka ini poko igósidi byaldóla, zitülkus Zon Baptaes Bain Pama nóma tamórr, wa alo bütóklürr akó waen koke enólórr. We zitülkusdü e igó bóktandakla wagó, ‘Oya bübdü kolae samua ngyabenda!’ ");
INSERT INTO tof_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A ka, Pamkolpamab Olom nótókla, nóma tamórró, ka alo akó anón namülnürrü. Akó we zitülkusdü, e kürübóka igó apóndakla wagó, ‘Ngakónam, wa barngin-koke alo akó gorrgorr bain pama! Wa taks mani dakabain pam akó kolae tonarr pamkolpamab gódame!’ ");
INSERT INTO tof_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","A blaman pamkolpama, Godón ⌊wirri gyagüpitótók⌋ nidi mamoandako, igó poko okaka amzazildako, Godón wirri gyagüpitótók amkomana.” ");
INSERT INTO tof_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Darrü Parrisia Yesun ngyaunürr wankü alom tótókóm. Da módóga, Yesu we wamórr ene Parrisian müótüdü, da müót kugupidü nólgópe banomólórr alom. ");
INSERT INTO tof_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Da módóga, darrü kol warilürr ene wirri basirrdü, arrkrru-koke kolae tonarr alngón kol. Wa umul bainürr wagó, Yesu ta ene Parrisian müótüdü aloda. Da wa darrü wirri darrem ingülküpi tónggapórrón bele sidódürr, morroal ilang idipükü. ");
INSERT INTO tof_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wa katókórr, Yesun kakota trramngólórr oya wapór minggüpanandó. Wazan yón warilürr, oya yarrmurra ama Yesun wapór zipür nólóplórr. Olgabi oya wapór nis tóba órrngóene norrgonórr, akó arük-arük nüprüklürr ó morroal ilang idi we ekanórr nizan wapórdó. ");
INSERT INTO tof_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ene Parrisia, Yesun nótó bóka itanórr wankü alom, nóma esenórr ini poko, da gyagüpi wamlórr wagó, “Ini pam ne amkoman Godón prropet nóma ki yarile, wa umul ki yarile oya ia kola amurrdo, ó wa umul ki yarile igó, ini kolae tonarr kolo.” ");
INSERT INTO tof_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Olgabi Yesu ene Parrisi pamdó bóktanórr wagó, “Saemon, kürü darrü pokoa marü azazilüm.” Da Saemon bóktanórr wagó, “Umulbain Pam, kóbó bókta.” ");
INSERT INTO tof_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu bóktanórr wagó, “Darrü pam yarilürr, da nis pam nis mani nókyanórr igó bókampükü, i solkwat darrem nóma ki salkomóli, i ene tumum ki emeli. Darrü ene pama we ngarkwat ipadórr: 500 ⌊silba⌋ mani küp. Akó darrü pama ma 50 silba mani küp ipadórr. ");
INSERT INTO tof_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ibü nizanab ngarkwatódó mani koke yarilürr oya darrem akyanóm, i oya ne kla ki ekyeni. Da módóga, wa ibü nizan we nyalórr ene darrem kolaebóka ainüm, i oya ne ngarkwat ki ekyeni. Ene nis pam nisdügab, ia noa moboküpdü ubi wirria ene mani mórrel pamdó?” ");
INSERT INTO tof_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saemon bóktan igó yalkomólórr wagó, “Aprrapórr ia we pama, abün mani noan iliónürr akó kolaebóka yónürr.” Yesu bóktanórr wagó, “Ma dümdüm kuri ekyena!” ");
INSERT INTO tof_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Olgabi Yesu ene koldó byalüngürra da bóktanórr Saemonka wagó, “Ma ini kol kuri osena? Ka marü müótüdü nóma tama, ma kürü nae koke kókyena kólba wapór bagulüm. A ini kola ma tóba yarrmurri kürü wapór nis zipür nólópe, akó zipür tóba órrngóene norrgorre. ");
INSERT INTO tof_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma kürü koke küprüka, ka nóma tama. A ini kola koke bólene kürü wapór nis aprük, ka marü müótüdü nóma tübangrina. ");
INSERT INTO tof_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma kürü singüldü oel koke ekóna, a wa ma kürü wapór nisdü morroal ilang idi ekóne. ");
INSERT INTO tof_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Da we ngarkwatódó ka marü igó ayaldóla, ini kolan moboküpdü ubi wirria kürüka. Akó ini tonarra we poko okaka simzazile: wa ne abün kolae tonarr elngólórr, ka kuri barrgona. A ka karianbóka noa kolae tonarr arrgona, oya moboküpdü ubi wata karia.” ");
INSERT INTO tof_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Olgabi Yesu bóktanórr ene koldó wagó, “Ka marü kolae tonarr kuri norrgonónóma.” ");
INSERT INTO tof_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ene pamkolpama, wankü nidi ololórr, tibióbka ola zwapólórr wagó, “Ini pam ia nótóke, kolae tonarr ta dele barrgonda?” ");
INSERT INTO tof_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Da Yesu bóktanórr ene koldó wagó, “Marü moba amkoman banguna kuri zid mine! Nató, moboküpdü paud sab marüka asi ki yarilün.” ");
INSERT INTO tof_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","We kakóm, Yesu basirr-basirr wamlórr, wirri akó kari basirrdüma. Wa Morroal Bóktan büdrrat yarilürr Godón Kingzan Balngomólankwata. Tóba 12 umulbain olmal wankü koralórr, ");
INSERT INTO tof_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","akó ngibürr kol wa kolae samu nibióbkagab amanórr akó azidüdügab nibiób dólóng ninóp. Darrü ene kol Merri warilürr, oya darrü ngi Magdalin. Yesu oyakagabi 7 kolae samu amanórr. ");
INSERT INTO tof_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Akó darrü Zoana warilürr, Kuzan kol. Kuza Errodón zaget alngomól pam yarilürr. Darrü Susana warilürr. Akó abün ngibürr kola zutalórr Yesuka. I tibiób büban manie bórrangórr Yesun akó oya umulbain olmal tangbóleanóm. ");
INSERT INTO tof_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wirri pamkolpamab ngoroa tamlórr abün wirri basirrdügab, ama Yesuka tóbazelórr. Da Yesu ini alap-alap bóktan adrratórr wagó, ");
INSERT INTO tof_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Darrü küp barit pama we wamórr ⌊wit⌋ küp tüpdü aman-aman aritüm apapdó. Wazan ene küp amalórr, ngibürra kwat kabedó balóklórr. Pamkolpama wapóre ola nyólnóp izan agóltagól kwarilürr, akó kwitüm póyaea ene küp idi ololórr. ");
INSERT INTO tof_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ngibürra wirri ingülküppükü tüpdü balóklórr. Da i nóma dódórr bain kwarilürr, ene zid odalan ngintinóp, zitülkus i ngarkwatódó nae koke azeb kwarilürr. ");
INSERT INTO tof_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Akó ngibürr küpa tórezpükü sólmól pokodó balóklórr. Ene sólmóla nóma dódórr bain yarilürr wit zidpükü, da ene wit zid ola sarrpi ninóp. ");
INSERT INTO tof_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A ngibürr küpa ma morroal tüpdü balóklórr. Ene zida dódórr bainóp ó küp we bapónóp: 100 darrpan-darrpan küpdügab, ene küp barit pamazan iritürr.” Oya bóktana nóma blakónórr, wa pamkolpamdó wirri arüngi bóktanórr wagó, “Güblang noane arrkrrum, wa ki turrkrru!” ");
INSERT INTO tof_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Umulbain olmala Yesun imtinóp ene alap-alap bóktanan küp laró yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Da wa ibüka bóktanórr wagó, “Godón Kingzan Balngomólankwata arrón elklazabóka umul yabü aliórrünako, a ngibürrdü ka go enan alap-alap ikikdóla. Ene igósüm, enana i azildako, i tai kokean asendako. Akó enana i arrkrrudako, i ma bóktanan ⌊küp koke apadódako⌋. ");
INSERT INTO tof_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ene alap-alap bóktanan küp yóni: ene küpa Godón bóktanóm zamngólda. ");
INSERT INTO tof_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kwat kabedó ne küpa balókórr, we pamkolpamóm zamngólda Godón bóktan nidi arrkrrudako. Ene kakóm, ⌊debóla⌋ kubó tame, da ibü moboküpdügab ene bóktan kubó yuse. Ene igósüm, i koke amkoman yangurre akó koke iade zid bairre. ");
INSERT INTO tof_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ingülküppükü tüpdü ne küpa balókórr, we pamkolpamóm zamngólda, bagürwómpükü nidi arrkrrudako Godón bóktan. A Godón bóktana nugup simkünzan ibü büb kugupidü koke barrbünda. I Godón bóktan tugupurr watóm amkoman angundako. A apók tonarra nóma tótókdako, i bóleandako amkoman bangun-gum. ");
INSERT INTO tof_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Akó tórezpükü sólmól pokodó ne küpa balókórr, we pamkolpamóm zamngólda Godón bóktan nidi arrkrrudako. A enezan ngyabendako, tüpan elklaza ibü sarrpi aindako: abün elklazam gyakolae, mórrelwóm, akó tüpan ubi elklaza tólbael. Ene pokodógab i morroal küp koke bapóndako. ");
INSERT INTO tof_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A morroal tüpdü ne küpa balókórr, we pamkolpamóm zamngólda, morroal akó amkoman moboküpi nidipako. I Godón bóktan arrkrrudako, moboküpdü zürüki arrbündako, da i küppükü igósidiako karrkukus bórrangde müp tonarrdó. ");
INSERT INTO tof_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Darrü oloma zyón kla nóma setene, wa kübüli koke ngalo-e ó ut bwób lorodó koke ingrine. A wa kumngyindü emngyele, da pamkolpama kubó zyón eserre, i müótan kugupidü nóma barrbüne. ");
INSERT INTO tof_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Blaman barrón ne elklazako errkya, sab ma tübause panzedó. Blaman ngablaorrón ne elklazako, sab umulürrün korale ó sab zyóndü togobe. ");
INSERT INTO tof_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Da e umul-umul koralo, e ia arrkrrudakla. Zitülkus módóga, noanko, sab akó oya ene tumum ngibürr iline. Babul noanko, oya sab imtine, wa ia gyagüpi tótókda oya kari-kari ne klame.” ");
INSERT INTO tof_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Olgabi Yesun aip akó zoretala togobórr oya asenóm. A ibü ma gaodó koke yarilürr oya minggüpanandó tótókóm, zitülkus pamkolpamab ngoroa ngalop. ");
INSERT INTO tof_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Da darrü oloma oya we izazilürr wagó, “Marü aip akó zoretal bórrangde módógako kalkuma. Ibü ubi marü asenóma.” ");
INSERT INTO tof_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wa ibüka bóktan we yalkomólórr wagó, “Kürü aip akó zoretal idipako, Godón bóktan ne pamkolpama arrkrrudako akó tórrmendó nidi arrbündako.” ");
INSERT INTO tof_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Darrpan ngürr Yesu bóktanórr tóba umulbain olmaldó wagó, “Mi malu dakla dorro baurrdakla.” I butüdü bamselórr, da we bazebórr. ");
INSERT INTO tof_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","I nóma baurrlülürr nyórri, Yesun uta türümürr. Wirri wóra ugón tórrpenóp ene maludü. Buta nae baitüm ugón bainürr, dakla ma busurralórr, da i wirri müpdü koralórr. ");
INSERT INTO tof_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Da módóga, umulbain olmala we ogobórr Yesuka, irsümülóp, da we bóktónóp wagó, “Wirri Pam, Wirri Pam! Mi brariakla!” Yesu bupadórr, da wór akó goblol nagóp wagó, “Piküp bainam!” Ene pokodó, wóra bóleanórr akó goblola zao-zao bainóp. Malua we amkónórr. ");
INSERT INTO tof_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Da Yesu tóba umulbain olmal nümtinóp wagó, “Yabü amkoman bangun ia nega?” I kari gum koke kwarilürr, ó gübarirr aengóp. Da tibiób ola bamtinónóp wagó, “Ini wa ia nótóke? Wa wór a goblol arüng bóktan akyanda, da i ta oya bóktan arrkrrudako!” ");
INSERT INTO tof_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Olgabi i nyórrpükü buti we ogobórr ama Gerrasa wirri basirr pamkolpamab bwóbdü babzilürr, malu dakla dorrodó Galili prrobinsdügab. ");
INSERT INTO tof_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu malu kabedó wapór nóma irtümülürr, oya darrü ene wirri basirrdügab kolae samupükü pama we semrranórr. Ene pama mórrkenyórr bamel-koke ngyabelórr abün watóm. Wa müótüdü koke ngyabelórr, a wa gapók balüng bwóbdü ngyaben yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ene pama Yesun nóma esenórr, wa ilwóm yarilürr. Olgabi wa Yesun obzek kwata simbalkalórr. Wa wirribóka taegwarr apónórr wagó, “Marü ubi ia larógóma kürüka, Yesu, Wirri Kwitüm Godón Olom? Ka marü arüngi atodóla, kürü wirri azid akyan-gu!” ");
INSERT INTO tof_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ene pama ini poko igósidi bóktanórr, zitülkus Yesu ene kolae samu arüng bóktan ngaen-gógópan ekyanórr ene pamdógabi burruanóm. Errkyadórrón-koke yarilürr ene kolae samua ene pam amióg abün münüm. Pama nóma makrraonónóp, sein sye-i wapór tang arümürrün nómade, wa ene klam kubó singgalgónóle, ó ene kolae samua kubó oya ⌊ngüin-koke bwóbdüma⌋ idüdle. ");
INSERT INTO tof_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu imtinürr ene pam wagó, “Marü ngi ia nótóke?” Wa bóktan yalkomólórr wagó, “Kürü ngi módóga, ‘Abün gazirr pam’.” Ene pama ini ngi ngilianórr, zitülkus oya bübdü abün kolae samua barrbünürr. ");
INSERT INTO tof_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ene kolae samua Yesun yatop ibü arüng bóktan koke ki nókyerre, ene ngaru bapón-koke kugupidü barrbünüm. ");
INSERT INTO tof_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Podo kabedó, wirri tang kyamül yabüla we ololórr. Ene kolae samua Yesun we yatop ene kyamülab bübdü barrbünüm. Da Yesu ok ninóp ibü barrbünüm. ");
INSERT INTO tof_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Da módóga, ene kolae samua ene pam we amgütóp, ama kyamülab bübdü we barrbünürr. Ene kyamül yabüla buso-buso we tübabinürr buruburuana, mengrempükü ama maludü we bagóbórr, ó ola nae baitóp büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ene kyamül ngabkan pama nóma esenóp ne klama tómbapónórr, i busuóp, da pamkolpam we umul-umulan ngintinóp, Gerrasa wirri basirrdü akó madmad kabedó. ");
INSERT INTO tof_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Da pamkolpama ogobórr ngakanóm ene ne tonarra tólbaelórr. I Yesuka nóma togobórr, i ene pam esenóp kolae samua noan amgütóp. Wa Yesun wapór minggüpanandó mórran yarilürr, mórrkenyórr bamelórrón akó kakal gyagüpitótóke. Da pamkolpama gum ipüdóp. ");
INSERT INTO tof_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nidi nósenóp, kolpam nüzazilóp Yesu ene kolae samupükü pam ia dólóng yónürr. ");
INSERT INTO tof_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Olgabi blaman Gerrasa bwób pamkolpama Yesun yatop ibü bimgatóm, zitülkus i kari gum ta koke kwarilürr. Da módóga, Yesu tóba umulbain olmalpükü butüdü kasilürr, da bupadlórrma alkomólóm. ");
INSERT INTO tof_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yesu ene kolae samu noakagabi amanórr, Yesun yatorr wankü tótókóm. Yesu ma oya zirrapónórr, da oya yalórr wagó, ");
INSERT INTO tof_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Moba müót basirrdü alkomól. Pamkolpam nüzazilnümke God marüka ne kla tónggapóne.” Da módóga, ene pama we wamórr, da büdrratlórr ene dudu wirri basirrdüma, oyaka Yesu ne kla tónggapónórr. ");
INSERT INTO tof_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu nóma alkomólórr malu dakla dorrodó, pamkolpamab ngoroa sisingül akyanóm tamórr, zitülkus i blamana oya akyanónóp alkomólóm. ");
INSERT INTO tof_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Da módóga, darrü ⌊Zu pamkolpamab kwóbbazen müót⌋ ngakan pama ugón tübzilürr Yesuka, oya ngi Zaerrus. Wa Yesun wapór nis minggüpanandó simbalkalórr, da Yesun arüngi yatorr oya müótüdü tótókóm, ");
INSERT INTO tof_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","zitülkus oya darrpanan óp olom, 12 pail ngarkwat, büdülüm kain warilürr. Yesuzan tótók yarilürr Zaerrusün müótüdü, wirri pamkolpamab ngoroa ugón myangrao apónóp, ngón aman nabe. ");
INSERT INTO tof_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ene ngorodó darrü kol warilürr óe bókan azidpükü 12 pailüm. Darrü olom gaodó koke yarilürr oya dólóng ainüm. ");
INSERT INTO tof_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Da módóga, wa Yesun agwatórr kakota, oya tumum mórrkenyórr zarr we yamurrürr. Büzyón babul, ene óe bókana we blakónórr. ");
INSERT INTO tof_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu nümtinóp wagó, “Ia kürü nótó kamurre?” Blamana balpinóp. Olgabi Pita bóktanórr Yesuka wagó, “Wirri Pam, ini pamkolpamab ngoroa marü kuri kal-kal mangórre akó ma myangrao apórrón bwóbdümla.” ");
INSERT INTO tof_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","A Yesu bóktanórr wagó, “Kürü wata darrü oloma kamurre. Ka umulóla, zitülkus ka kólba bübdü küpüm baina kürükagab ngibürr arünga kuri bause.” ");
INSERT INTO tof_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ene kola tüób nóma küp bamkónórr wagó, Yesu kuri umul baine, oya büba otórrngónóm bainürr. Wa natókórr, simbalkalórr Yesun obzek kwata. Blaman pamkolpamab obzek kwata, Yesuka we pupo bainürr, wa oya ne zitülkusdü yamurrürr. Da wa oyaka adrratórr, wa ene tonarr pokodó ia dólóng bainürr. ");
INSERT INTO tof_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Olgabi Yesu ene kol wyalórr wagó, “Kürü olom, marü moba amkoman banguna dólóng kuri mine. Natók, moboküpdü paud sab marüka asi ki yarilün.” ");
INSERT INTO tof_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu bóktan alakón küsil yarilürr, darrü pama Zaerruska ugón tamórr oya müótüdügab, da wa oya yalórr wagó, “Marü olom büdülato. Ma Umulbain Pam myamem müp akyan-gu.” ");
INSERT INTO tof_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu ini poko nóma arrkrrurr, wa bóktanórr Zaerruska wagó, “Ma gumgu, ma kürü wata amkoman kangu, da wa kubó igósidi dólóng baine.” ");
INSERT INTO tof_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu Zaerrusün müótüdü nóma abzilürr, wa abün is koke ok ninóp wankü barrbünüm müótüdü. Wata idi kwarilürr: Pita, Zon, Zeims, akó ene ngulmokuran aipab nis. ");
INSERT INTO tof_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Blaman pamkolpam yón taegwarr akó yón gyaurdü kwarilürr. Yesu ibüka bóktanórr wagó, “E yón piküp bainam, zitülkus wa büdül kokeo, a wa go uto.” ");
INSERT INTO tof_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","I ma oya ngüóng angyalnóp, zitülkus i umul kwarilürr wagó, wa go amkoman büdülano. ");
INSERT INTO tof_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Wa ma oya tangdó omoanórr, da wirribóka karrzwosilürr wagó, “Olom, ugó bupa!” ");
INSERT INTO tof_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ene ngulmokuran arróla tóbaka tolkomólórr; büzyón-babul, wa zamngólórr! Olgabi Yesu aipab nis nyalórr alo kla akyanóm. ");
INSERT INTO tof_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ene ngulmokuran aipab nisa gübarirr aengrri. A Yesu ma ibü arüng bóktan nókyanórr wagó, “Darrü olom azazilgu, errkyadan ne tonarra tómbapóne.” ");
INSERT INTO tof_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu tóba 12 umulbain olmal darrpan pokodó ngibaunürr. Wa ibü wirri arüng akó dümdüm nókyenóp blaman kolae samu amanóm akó azid alakónóm. ");
INSERT INTO tof_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Olgabi wa ibü zirrnapónóp pamkolpamdó amgolóm Godón Kingzan Balngomólankwata akó azid pamkolpam dólóng bainüm. ");
INSERT INTO tof_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Wa ngaen-gógópan bóktanórr ibüka wagó, “Yenkü darrü kla ódódgu ini agólde: tupuru, angasangap angón alóp, alo kla, mani, akó ngibürr mórrkenyórr. ");
INSERT INTO tof_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","E ne müótüdü barrbuno, wata ola bamilke, kókó e ene basirr sab amgütane. ");
INSERT INTO tof_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pamkolpama yabü ne morroal tonarre koke nóma yazebrre darrü basirrdü, ene basirr amgütamke, wapórdó buru we bainamke. Ini tonarra sab igó poko umul nirre wagó, ibü ⌊kolaean darrema⌋ sab tame Godkagab.” ");
INSERT INTO tof_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Da módóga, ene umulbain olmala we bazebórr basirr-basirr. I Morroal Bóktan büdrratkü ogoblórr, dakla azid pamkolpam dólóng bainkü, i ne bwób-bwóbdüma ogoblórr. ");
INSERT INTO tof_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galili prrobins alngomól wirri pam Errod arrkrrurr, blaman ne elklaza tómbapón kwarilürr. Wa abün-abün gyagüpitótók yazebórr, zitülkus ngibürr pamkolpama igó bóktan kwarilürr wagó, “God Zonón ⌊Baptaes Bain⌋ Pam wa büdüldügab kuri irsümüle.” ");
INSERT INTO tof_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ngibürr isa igó bóktan kwarilürr wagó, “Prropet Ilaeza akó okaka tübine.” Akó ngibürra wagó, “Darrü prropeta, ngaen usian nótó ngyabelórr, nurrótókórra, da akó kuri türsümüle arróldó.” ");
INSERT INTO tof_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","A Errod wagó, “Kürü gazirr pama Zonón singül nam itülóp wata kazan nilóp. A ini wa dama nótóke, ka inzan poko noanbóka arrkrrudóla?” Da módóga, Errod Yesun asenóm kain yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesun umulbain olmala nóma tóbakonórr, da Yesun izazilóp, i ne elklaza tómbapónónóp. Olgabi wa ibü yazebórra, ae ogobórr kókó Betsaeda wirri basirr minggüpanandó, i tibi ne ki korale. ");
INSERT INTO tof_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","A pamkolpamab ngoroa ma kari güblange barrkrrurr Yesu nebóna tótókóm kain yarilürr, da zutalórr oya solkwat. Yesu ibü morroal yazebórr, da ibüka bóktanórr Godón Kingzan Balngomólankwata, da wa ibü dólóng nyónónóp, dólóng bain nidi amkün koralórr. ");
INSERT INTO tof_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Abüsa nóma mórralórr, ene 12 umulbain olmala oyaka togobórr, da i oyaka bóktónóp wagó, “Ini pamkolpamab ngoro ugó zirrnapónónóm minggüpanan basirrdü akó madmad kabedó ne müótko, alo kla azebóm akó ut bwób byamkünüm, zitülkus ini kolpam-koke bwóba.” ");
INSERT INTO tof_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A Yesu ibü nilóp wagó, “E yaib ibü ngibürr alo kla nülinam.” I ma bóktónóp wagó, “Kibü wata 5 brredako akó nis wapiamli. Marü ia ubia, ki ogobo ini abün pamkolpamabkü alo kla bumiógüm?” ");
INSERT INTO tof_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ene pokodó blaman kókó 5,000 pam koralórr.) A Yesu ma tóba umulbain olmaldó bóktanórr wagó, “Ibü mórran-mórran ninam kopo-kopo, darrpan kopodó kóta 50 kolpam ngarkwat.” ");
INSERT INTO tof_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oya umulbain olmala tónggapónóp wazan nilóp, kókó ene pamkolpama blamana bobrranórr. ");
INSERT INTO tof_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ene 5 brred akó nis wapi yazebórr, kwit yazilürr, da Godón eso ekyanórr. Wa ene brred akó wapi syórr nangónóp, da tóba umulbain olmal nülinóp ene pamkolpam gyabalómóm. ");
INSERT INTO tof_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I blamana nóma elop, ibü bikóma nólóngóp. Umulbain olmala bamirrün alo poko dakainóp akó 12 alóp murrnausóp. ");
INSERT INTO tof_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Darrpan ngürr, Yesu tebe nóma tóre ekolórr, oya umulbain olmal ta wankü asi kwarilürr. Olgabi oya tórea nóma blakónórr, da nümtinóp wagó, “Pamkolpama ia bóktandako, ka nótókla?” ");
INSERT INTO tof_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Umulbain olmala bóktan yalkomólóp Yesuka wagó, “Ngibürr pamkolpama igó bóktandako wagó, ma Zonla, Baptaes Bain Pam. Ngibürra ma igó bóktandako wagó, ma prropet Ilaezala. Ngibürra go wagó, ma darrü prropetla, ngaen usian nótó ngyabelórr, nurrótókórra, da akó kuri türsümüle arróldó.” ");
INSERT INTO tof_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wa ibü nümtinóp wagó, “A yadi, e wa ia gyagüpi tótókdakla kürükwata, ka nótókla?” Pita bóktan yalkomólórr wagó, “Ma ene ⌊Kerrisola⌋, God noan zirrsapónórr.” ");
INSERT INTO tof_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu ibü arüng bóktan we nókyenóp wagó, “Darrü olom azazilgu igó, ka ene Kerriso módógla.” ");
INSERT INTO tof_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu akó bóktanórr wagó, “Ka, Pamkolpamab Olom nótókla, wata sab abün-abün azid aeng namulo. ⌊Balngomól byarrmarr pam⌋, ⌊wirri prrist⌋, akó Mosesón gida umulbain pama sab kürü wata alzizi kümaniknórre. Sab kürü büdülümpükü kómkólórre a aüd ngim ngürrdü God kürü sab kürsümüle arróldó.” ");
INSERT INTO tof_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Olgabi Yesu ibüka bóktanórr wagó, “Nadü oloman ubi yarile kürüka solkwat akyanóm, wa tóbabóka imrüke. Wa blaman ngürrzan tóba krros bügasile azid aengóm kazan, ó kürüka solkwat tókyale. ");
INSERT INTO tof_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Zitülkus módóga, nadü oloman ubi yarile tóba tüpan arról zid ainüm, wa sab tóba ⌊ngarkwat-koke arról⌋ imrüke. A nadü oloma sab tóba tüpan arról imrüke kürübókamde, wa sab tóba ngarkwat-koke arról zid ine. ");
INSERT INTO tof_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ia laró morroala, darrü pama ini tüpan elklaza blaman azebóm, a tóbanan ngarkwat-koke arról ma ki imrüke? Babula! ");
INSERT INTO tof_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nadü oloma büód aengda kürükwata akó kürü bóktanankwata, ka Pamkolpamab Olom nótókla, sab ta büód aengo oyakwata, ka nóma tamlo kólba ⌊wirri kómal zyónpükü⌋, Ab akó gyabi anerru ne wirri kómal zyóna myangrao bapónda. ");
INSERT INTO tof_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ka yabü amkoman poko byaldóla: e ngibürr aini nidipakla bórrangórrón, sab koke nurrbarino kókó God ini tüp Kingzan alngomól nóma bókyene.” ");
INSERT INTO tof_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Aprrapórr 8 ngürr kakóm Yesu ibü yazebórr, Pita, Zon, akó Zeims, da podo bangürlürr usakü, tórem. ");
INSERT INTO tof_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yesuzan tóre yarilürr, oya obzeka darrü tonarr bainürr. Oya mórrkenyórra ongang bapón yarilürr gabülplie. ");
INSERT INTO tof_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Da módóga, pam nisa we okaka tübyórri, Moses a Ilaeza, Yesukü ikikdi. ");
INSERT INTO tof_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","I ta wirri kómal zyónpükü okaka tübyórri. I igó poko ikik kwarilürr, Yesu sab nadü tonarre nurrótóke. Wa karipoko yarilürr Godón bóktan tórrmendó angrinüm Zerrusalem wirri basirrdü. ");
INSERT INTO tof_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitan tóba gódam nispükü uta arüm yarilürr, a i tai nóma tübarsinürr, i esenóp Yesu ne wirri kómal zyóndü yarilürr akó i ta nósenóp ene pam nis wankü nidi zamngólnórri. ");
INSERT INTO tof_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses a akó Ilaezazan bupadóm kain namülnürri, da Pita Yesuka bóktanórr wagó, “Wirri Pam, mi morroal ainizanakla! Ki kya aüd twal müót balmerre, darrü marünkü, darrü Mosesónkü, darrü Ilaezankü.” (Pita koke emzyatórr tóba bóktanan küp tai laró yarilürr.) ");
INSERT INTO tof_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pita enezan bóktan yarilürr, da módóga, pülpül pokoa we tamórr, a ibü ngatolop. Ene umulbain olmal gum kwarilürr pülpül pokoa ibüzan ngablao yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Pülpül pokodógab bóktan bómgóla sidórükürr wagó, “Ini kürü Kólbanan Olome. Oya kótó ipadórró. Oya bóktan amkoman ipadólamke!” ");
INSERT INTO tof_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ene bóktan bómgóla nóma blakónórr, umulbain olmala Yesun tóbanan esenóp. I koke bóktan kwarilürr inikwata, wata tibióbka ola yarilürr. I ene tonarrdó darrü olom kokean izazilóp, i ne elklaza nósenóp. ");
INSERT INTO tof_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Darrü ngürr Yesu tóba aüd umulbain olmalpükü nóma tübinürr pododógab, wirri pamkolpamab ngoroa tóbazenórr oyaka. ");
INSERT INTO tof_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Da módóga, darrü pama ene pamkolpamab ngorodógabi tórrgóganórr Yesuka wagó, “Umulbain Pam, ka marü atodóla kólba siman olom ngakanóm, zitülkus kürü wata darrpan olom módóga! ");
INSERT INTO tof_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kolae samua blaman tonarrdó nóma amiógda, ugósan kubó taegwarran ngitine. Ene kolae samua kubó tórrngónan ngitine, da tüpdü singalkóle tae godeapükü. Ene klama wirri ngarkwatóm koke amgatóda, dakla oya büb kulainda. ");
INSERT INTO tof_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ka marü umulbain olmal enan natonóma ini kolae samu amaiküm, a ibü gaodó koke yaril.” ");
INSERT INTO tof_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu blamandó bóktan yalkomólórr wagó, “E amkoman bangun-koke akó kolae tonarr lüól pamkolpamakla! Ia ka yenkü nadüzan ngarkwat ngyabelo yabü amkoman bangun kokede?” Da wa ene pamdó bóktanórr wagó, “Moba olom ala sidó.” ");
INSERT INTO tof_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ene olommokura Yesun nóma ngorram ain yarilürr, kolae samua oya ugón tórrngónan ngitanórr, da singalkalórr tüpdü. A Yesu ma ene kolae samu agórr ene olommokur amgatóm. Ene olommokur we dólóng yónürr, da abdó we yalkomólórr. ");
INSERT INTO tof_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Blaman pamkolpama gübarirr aengóp Godón wirri arüng nóma esenóp. Blaman pamkolpamazan gübarirr aeng kwarilürr Yesu ne blaman elklaza tómbapónórr, da wa tóba umulbain olmaldó we bóktanórr wagó, ");
INSERT INTO tof_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tai tübarrkrru, amrükgu, ka yabü ne wirri bóktan büzazilüm kaindóla. Darrüpa kürü, Pamkolpamab Olom nótókla, sab pamkolpamab tangdó küngrine.” ");
INSERT INTO tof_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","A i ma Yesun bóktanan ⌊küp tai koke emzyetóp⌋. God ene bóktanan küp ibükagab inikürr, igósüm i tai koke ipüdóp. Akó i tib gum kwarilürr Yesun amtinüm oya bóktanan küpankwata. ");
INSERT INTO tof_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Da módóga, ene umulbain olmala tibiób ola murr bazebdako wagó, ia amkoman wirrian nótóke. ");
INSERT INTO tof_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu wa ibü gyagüpitótók ngaen-gógópan bumiógürr, da darrü kari olom ipadórr, zamngól-zamngólan we yónürr tóba nólgóp kwata. ");
INSERT INTO tof_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Olgabi Yesu tóba umulbain olmaldó bóktanórr wagó, “Inzan kari olom morroal tonarre nótó nóma apadóda kürü ngidü, enta igósa, wa kürü morroal tonarre apadóda. Ó kürü morroal tonarre nótó nóma apadóda, wa ta Godón morroal tonarre apadóda, kürü nótó zirrkapónórr. Ini amkoman pokoa, zitülkus karian nótóke yabü aodó, God wirrian oya angunda.” ");
INSERT INTO tof_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zon bóktanórr Yesuka wagó, “Wirri Pam, ki darrü pam eserre kolae samu amande pamkolpamdógabi marü ngidü. Ki oya piküp ainüm kain kwarilürr, zitülkus wa minkü kokea.” ");
INSERT INTO tof_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A Yesu ma ibü nilóp wagó, “E oya piküp ain-gu, zitülkus yabüka koke nótó bóka bamgünda, wa igósidi yabüne.” ");
INSERT INTO tof_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesun kwitüdü kasil ngürrazan ngorram bain yarilürr, Yesun ama gyagüpbarr yarilürr Zerrusalem wirri basirrdü tótókóm. ");
INSERT INTO tof_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Da wa bóktan bamtül pam zirrnapónóp singül kwata. Ene pama we ogobórr darrü basirrdü, Samarria prrobins kugupidü, elklaza tómbapónóm Yesunkü. ");
INSERT INTO tof_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","A pamkolpam ene basirrdü koke kwarilürr Yesun tóba umulbain olmalpükü morroal tonarre apadóm, zitülkus i Zerrusalem ki bórrgrrótórre. ");
INSERT INTO tof_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zeims akó Zon igó nóma ngakarri wagó, Yesun ini pamkolpama morroal tonarre koke ipüdóp, da bóka itarri wagó, “Lod, ia marü ubia, ki kubó Godón imtini ur zirrapónóm kwitüdügab ibü almitüm?” ");
INSERT INTO tof_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A Yesu ma tübyalüngürr, da ibü nagórr. ");
INSERT INTO tof_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Olgabi ma i akó darrü basirrdü ogobórr. ");
INSERT INTO tof_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","I kwatódó iazan tótók kwarilürr, darrü pama Yesunbóka wagó, “Ka sab marüka akyalo, enana ma nega wamlo.” ");
INSERT INTO tof_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ma oyaka bóktanórr wagó, “Poksab tibiób ngyaben kugupi asiko akó kwitüm póyaeab müótako. A Pamkolpamab Oloman ma darrü ut bwób babula, ka kólba singül ne ingrino ngón ngagónóm.” ");
INSERT INTO tof_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Olgabi Yesu akó darrü pamdó bóktanórr wagó, “Kürüka tókya!” A ene pama ma Yesuka igó bóktanórr wagó, “Lod, ma kürü ngaen-gógópan ok kyó basirrdü alkomólóm kólba ab gapókdó angrinüm.” ");
INSERT INTO tof_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ma oya igó yalórr wagó, “Büdül nidipako tibiób büdül ki balüngnüm. A mató, ma wam a pamkolpamdó ayolónke ene morroal bóktan Godón Kingzan Balngomólankwata.” ");
INSERT INTO tof_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Akó darrü pama bóktanórr Yesuka wagó, “Lod, ka sab marüka akyalo, a ngaensingülan ka kya kólba müót kolpam yawal bókyanóm wamón.” ");
INSERT INTO tof_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ma oya igó yalórr wagó, “Darrü pama ne kesu angónde kakota nóma yazile, wa ngarkwatódó zaget pam kokea Godón Kingzan Balngomólankü.” ");
INSERT INTO tof_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","We kakóm, Yesu ngibürr 72 pam ilianórr, akó tómbapón yarilürr ibü zirrbapónóm. I sab oya singül kwata ogobe ninis, blaman wirri basirr akó bwóbdüma wa ne tótókóm bóktan tólbael yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I solkwat ogobórr, a Yesu ngaen-gógópan ibüka bóktanórr wagó, “Abül ta kari kokea, a zaget pam ma abün kokeako ene alo kla abülüm. We ngarkwatódó, e Lodka tóre kwarilün, abül zitülkus olom nótóke, akó oya imtinamke zaget kolpam zirrbapónóm alo kla abülüm. ");
INSERT INTO tof_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ogob! Ka yabü zirrbapóndóla ⌊sip⌋ kupozan wirri nurr ume ngorodó. ");
INSERT INTO tof_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yenkü paos, angasangap angón alóp, akó ngibürr wapórdó bamel kla amarrugu. Kwatódó bólean-gu pamkolpamdó ikiküm. ");
INSERT INTO tof_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","E darrü oloman müótüdü nóma barrbuno, ngaen-gógópan bóktónamke magó: ‘Paud asi ki yarilün ini müótüdü!’ ");
INSERT INTO tof_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Paud olom ne ola nóma yarile, yabü paud oyaka yarile; koke ne nóma, ene pauda yabüka tolkomóle. ");
INSERT INTO tof_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ene dadan müótüdü bamilke, akó alo a anón, i yabü ia klame ngabyón kwarile. Zitülkus módóga, zaget paman dümdüm asine tóba darrem kla azebóm ibükagab, nibiób tangbamtinda. Abün-abün müótüdüma ngyabenkü tótókgu darrpan basirrdü. ");
INSERT INTO tof_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","E darrü wirri basirrdü nóma barrbülo, da pamkolpama yabü morroal tonarre nóma yazebrre, ololónke i yabünkü ia alo tübarrmüle. ");
INSERT INTO tof_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Dólóng nyólamke ola azid pamkolpam nidipako, akó nüzazilamke magó, ‘Godón Kingzan Balngomóla yabü minggüpanandó kuri tübine.’ ");
INSERT INTO tof_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","A e darrü wirri basirrdü nóma barrbuno akó ene pamkolpama yabü morroal tonarre koke nóma yazebrre, wirri kwatódó ogobke, da ini poko bóktónamke magó, ");
INSERT INTO tof_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Yabü basirran ne buruko kibü wapórdó ki ae barrgondakla yabü amtyanóm yabü kolae asiko. A e ma umul kwarilo ini poko: Godón Kingzan Balngomóla minggüpanandó kuri tübine!’ ");
INSERT INTO tof_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka yabü igó byaldóla, Godón Kot Ngürrdü wa sab Sodom wirri basirr pamkolpam kolaean darrem nókyerre. A wa ma ene basirr pamkolpam sab tai wirrian kolaean darrem nókyerre. ");
INSERT INTO tof_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Sab Godón ngürsila tame marüka, Korrazin wirri basirr! Akó sab Godón ngürsila tame marüka, Betsaeda wirri basirr! Ka Taerr akó Saedon wirri basirr nisdü ene ⌊arüng tonarr⌋ ne nóma ki tómbapóla, ka yabüka ne arüng tonarr tómbapólórró, ene pamkolpama gyaur mórrkenyórr ngaen ki bamelórre akó urtók buru ki olokól tibiób singüldü, Godka okaka azazinüm wagó, i tibiób kolae tonarrdógabi kuri tübyalüngórre. ");
INSERT INTO tof_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Godón Kot ngürrdü wa sab Taerr akó Saedon wirri basirr pamkolpam kolaean darrem nókyerre. A wa ma sab yabü, Korrazin akó Betsaeda, tai wirrian kolaean darrem tókyerre. ");
INSERT INTO tof_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Akó mató, Kaperrna-um wirri basirr, ma ia igó gyagüpitótókdóla, God sab marü kwitüdü mómngyele? Kokean! Ma sab bangrino tüpdü, büdülab bwóbdü!” ");
INSERT INTO tof_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Olgabi Yesu tóba umulbain olmaldó bóktanórr wagó, “Yabü bóktan ne oloma arrkrruda, enta igósa, wa kürü bóktan arrkrruda. Akó yabü nótó alzizi amanda, enta igósa, wa kürü alzizi amanikda. Akó kürü nótó alzizi amanikda, enta igósa, wa Godón alzizi amanikda, kürü nótó zirrkapónórr.” Yesun bóktan kakóm, wa ene 72 umulbain olmal we zirrnapónóp. ");
INSERT INTO tof_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ngibürr tonarr kakóm, ene 72 umulbain olmala tóbakonórr Yesuka tibiób agóltagóldógabi, da i kari bagürwóm koke kwarilürr. I bóktónóp oyaka wagó, “Lod, enana kolae samua ta kibü bóktan amorran kwarilürr, ki arüng bóktan nóma nüliónónóp marü ngidü!” ");
INSERT INTO tof_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Da Yesu ibüka bóktanórr wagó, “Ka satani eserró kwitümgab büsai aupdi, wamaka aon warri zyóna büsai-büsai aupda pülpüldügabi. ");
INSERT INTO tof_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tübarrkrru! Ka yabü balngomól arüng ngaen nókyenarre büdül tarük gwar a walipwalip bailüm akó satanian arüng ⌊ut-ut ainüm⌋. Darrü kla babula yabü azid akyanóm. ");
INSERT INTO tof_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","E bagürwómdakla, zitülkus kolae samua ta yabü bóktan amorrandako. E ma bagürwómgu ene zitülkusdü, a e barre we pokodó bagürwóm kwarilo, God yabü ngi kwitüdü ngaen wibalómórr tóba pebadó.” ");
INSERT INTO tof_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ene tonarrdó, Godón Samua oya bübzan gwarran yarilürr bagürwómpükü, Yesu Godka bóktanórr wagó, “Ka marü agürdóla, kürü Ab, tüp a pülpülan Lod, zitülkus ma ini elklazab amkoman küp iniknürrü ⌊wirri gyagüpitótók⌋ akó wirri susumüri pamdógabi, da errkya ma popa kolpamdó kuri okaka sizazina, marü kari olmalzan nidi amkoman angundako. Amkoman, kürü Ab, ma tónggapórró ini kwata, zitülkus marü wirri ubi inzanóm yarilürr.” ");
INSERT INTO tof_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu akó pamkolpamdó we bóktanórr wagó, “Blaman kla kürü Aba kuri küliónürr. Darrü olom umul-kóka, Godón olom ia oloma. Wata Ab umul tebea. Akó darrü olom umul-kóka Ab ia oloma. Wata oya Olom umul tebea, akó wa nibiób aleanda tóba Ab okaka amzazilüm.” ");
INSERT INTO tof_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Olgabi Yesu tóba umulbain olmaldó byalüngürr, da ibüka we bünyón bóktanórr wagó, “Bagürwóm idipako, nidi basendako e ne elklaza basendakla! ");
INSERT INTO tof_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Zitülkus módóga, ka yabü igó byaldóla, abün prropet akó king ngaen ubi kwarilürr asenóm, e errkya ne kla basendakla kürü tómbapónde, da i kokean esenóp. Akó ibü ubi ta arrkrrum yarilürr, e ne poko arrkrrudakla, da i kokean barrkrrurr.” ");
INSERT INTO tof_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Da módóga, darrü Zu pamkolpamab gida umulbain pama zamngólórr, da Yesun apókóm darrü amtin bóktan poko imtinürr wagó, “Umulbain Pam, ka ia kaino ⌊ngarkwat-koke⌋ arról apadóm?” ");
INSERT INTO tof_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A Yesu ma darrem oya igó imtinürr wagó, “Mosesón gidadó inikwata ia wialómórróna? Ma ia amzyatdóla?” ");
INSERT INTO tof_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wa Yesuka bóktan yalkomólórr wagó, “‘Marü ⌊moboküpdü ubi⌋ asi ki yarilün Lodka, marü God, moba dudu moboküpi, dudu samu-i, dudu arüngi, akó dudu gyagüpitótóke’, akó ‘Marü moboküpdü ubi moba minggüpanandó ne olome inzan ki yarilün, marü moboküpdü ubi mobakazane.’” ");
INSERT INTO tof_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu oyaka bóktanórr wagó, “Ma bóktan dümdüman salkomóla. Ini bóktan mamoan namülünke, da ma sab ngarkwat-koke arróldó ngyabelo.” ");
INSERT INTO tof_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","A ene gida umulbain pama kwat amkün yarilürr tóba bagom. Da módóga, wa akó Yesun imtinürr wagó, “Kürü minggüpanan olom ia nótóke?” ");
INSERT INTO tof_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu darrem bóktan yalkomólórr wagó, “Darrü ngürr darrü pama Zerrusalem wirri basirrdügabi abilürr ama Zerriko wirri basirrdü wamlórr. Wazan wamlórr, ngibürr gazirr-gazirr gómól pama ugón simigóp. I oya mórrkenyórr akó elklaza blaman imtinóp, emkólóp kókó büdül kari poko. Tib ae ogobórr. ");
INSERT INTO tof_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Igó pokoa tómbapónórr, darrü prrista tamlórr ene dadan kwatana. Wa ene pam nóma esenórr, wa kwatana bórrgrratórr kwat dakla kabeana. ");
INSERT INTO tof_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Dadan ngarkwatódó, Libae zitül pama tamlórr dadan pokodó. Wa ene pam nóma esenórr, wa kwatana bórrgrratórr kwat dakla kabeana. ");
INSERT INTO tof_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ta asi, darrü Samarria pama ene kwatanazan wamlórr, wa ene pokodó tamórr ene pam ne yarilürr. Wa nóma esenórr, wa oyaka kari gyaur koke yarilürr. ");
INSERT INTO tof_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Módóga, wa wamórr kókó oyaka, oel akó waen ekanórr oya gülüngdü akó mórrkenyórr syórri twóp amelórr kókó tai. Da wa ene pam ipadórr, tóba ⌊donkidü⌋ igasilürr, da we idódürr manie ngyaben amil müótüdü, da we ngakan yarilürr darrpan ngürrüm. ");
INSERT INTO tof_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Darrü ngürr ene Samarria pama nis silba mani küp nurruanórr, da ene manie ngyaben amil müót ngakan pam ekyanórr. Wa bóktanórr oyaka wagó, ‘Gyaurka, ini pam tai ngakalónke. Akó darrem ne barrkyanan nóma yarile ini tumum, ka marü sab barre ugón kókyeno ka nóma tolkomolo.’” ");
INSERT INTO tof_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Olgabi Yesu ene Mosesón gida umulbain pam imtinürr wagó, “Ma ia gyagüpi tótókdóla? Ini aüd pamdógabi, morroal minggüpanan olom ia nótó yaril ene gazirr-gazirr gómól pama amkarrón olomdó?” ");
INSERT INTO tof_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ene pama bóktan yalkomólórr wagó, “Gyaur nótó ipadórr oyaka.” Olgabi Yesu oya yalórr wagó, “Ma wam, da dadanzan kainke.” ");
INSERT INTO tof_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu tóba umulbain olmalpükü Zerrusalemzan wamlórr, da kwat-kwat darrü basirrdü tübzilürr. Ola darrü kol warilürr, ngi Marrta, da wa Yesun ngisaunürr tóba müótüdü. ");
INSERT INTO tof_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marrtan zoret asi warilürr, ngi Merri, Lodón wapór minggüpanandó nótó mórran warilürr oya umulbain bóktan arrkrrum. ");
INSERT INTO tof_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","A Marrta ma gyakolae warilürr, zitülkus oya abün zaget akó elklaza koralórr tómbapónóm. Marrta natókórr a oyabóka wagó, “Lod, ia ini morroala marüka, kürü zoreta kürü inzan amgatóm blaman ini zaget tómbapónóm kólbe püóran? Wyal kürü tangamtinüm!” ");
INSERT INTO tof_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Da Yesu oyaka bóktan yalkomólórr wagó, “Marrta, Marrta, ma kari gyakolae kokela abün elklazabkwata. ");
INSERT INTO tof_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","A wata darrpan kla asine tónggapónóm. Merri wa ene dümdüm kla kuri ipüde, da kubó koke ipüdórre oyakagab.” ");
INSERT INTO tof_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Darrpan ngürr Yesu darrü pokodó tóre yarilürr. Oya tóre akoa nóma blakónórr, da oya darrü umulbain oloma bóktanórr oyaka wagó, “Lod, ma kibü umul tinünüm Godka tóre bako iada, wata Zon ⌊Baptaes Bain⌋ Pam tóba umulbain olmalzan umul ninóp.” ");
INSERT INTO tof_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Olgabi Yesu bóktanórr ibüka wagó, “E Godka nóma tóre kwarilo, igó ekolamke magó, “‘Ba, marü ngi gyabiana; pamkolpama marü ngi ki ⌊ótók⌋ kwarilün. Marü Kingzan Balngomóla ugó ki tam. ");
INSERT INTO tof_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kibü darrpan-darrpan ngürrzan alo kla alión namülün. ");
INSERT INTO tof_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma kibü kolae tonarr torrgonónóm, zitülkus kibüka kolae tonarr nidi tómbapóndako, ki ta ibü kolae tonarr barrgondakla. Akó kibü balngomólgu kolae tonarr tómbapónóm.’” ");
INSERT INTO tof_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Olgabi Yesu bóktanórr tóba umulbain olmaldó wagó, “Darrüpa yabükagabi kubó aprrapórr wame kamadan müótüdü irrüb zokrrok, da kubó bóktóne wagó, ‘Kürü gódam, gyaurka, kya kürü aüd brred mató külió, darrem ka sab marü mókyeno solkwat. ");
INSERT INTO tof_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Zitülkus kürü darrü gódama aibwóbdügabi tübzile, da wa kankü aega, ó kürü ta bumat kla babula oya akyanóm.’ ");
INSERT INTO tof_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Olgabi ene müót kugupidü gódama kubó bóktan salkomóle wagó, ‘Ma kürü müp akyan-gu! Mamtae murrausürrüna, ó ka ta kólba olmalpükü ut bwóbdümla. Ka bupadóm gaoandó kokela marü darrü kla akyanóm.’ ");
INSERT INTO tof_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka yabü igó byaldóla. Solodó, wa kubó bupude, ene pam alo kla ekyene oya ubi ngarkwatódó, a ene igó pokodógabi koke, igó zitülkus wa oya gódame, a zitülkus wa mengre tangbamtinüm batoda. ");
INSERT INTO tof_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Da ka yabü igó byaldóla, yatolam Godón, da yabü sab nókyerre. Yamkülam, da e sab esenane. Mamtae alkólam, da God sab yabünkü tapakue. ");
INSERT INTO tof_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Zitülkus módóga, nótó nóma yatole, sab ipüde. Nótó nóma yamküle, sab esene. Akó mamtae nótó nóma alkóle, God sab tapakue oyankü. ");
INSERT INTO tof_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ia yabü aodó igó ab asine, tóba oloma ne wapim nóma bato-e, ia wa kubó büdülngal ekyene? ");
INSERT INTO tof_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ó wa ne oya póyae urgupüm nóma yato-e, wa ia kubó oya walipwalip ekyene? Koke! ");
INSERT INTO tof_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Enana e kolae tonarr pamkolpamakla, a e ma umulakla yabiób olmal morroal elklaza gail. Da amkoman, yabü kwitüm Aba sab igósidi tóba Samu nókyerre, oya nidi atodako!” ");
INSERT INTO tof_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Darrü tonarrdó, Yesu kolae samu amanikürr darrü pamdógabi, oya bóktan-gum nótó elealórr. Ene kolae samua ene bóktan-koke pam nóma amgatórr, ene pama bóktanóm bainürr. Pamkolpam ola nidi koralórr gübarirr aengóp. ");
INSERT INTO tof_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","A ngibürr pamkolpama ma Yesunkwata igó bóktanónóp wagó, “Be-elzebul, kolae samuab singüldü pam nótóke, oya ene arüng wató akyanda kolae samu amanóm.” ");
INSERT INTO tof_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ngibürr pamkolpama oya apókóm yangónónóp, da imtinónóp darrü kwitümgab ⌊wirri tulmil⌋ tónggapónóm igó poko amtyanóm wagó, oya arüng amkoman Godkagabia. ");
INSERT INTO tof_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu ibü gyagüpitótók umul bainürr, da wa ibüka we bóktanórr wagó, “Darrü kingan balngomól bwób pamkolpama tibiób nóma bürrgrrütórre tibióbka bóka bamgünüm, ibü bwóba sab kolae baine. Akó darrpan müótüdü pamkolpama tibiób nóma bürrgrrütórre, i sab myamem dabyórrün koke kwarile. ");
INSERT INTO tof_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Da ene ta inzana, satani akó tóba kolae samua ne tibiób nóma bürrgrrütórre, da oya balngomóla sab myamem koke zamngóle. Ka ini poko bóktandóla, zitülkus e igó bóktandakla wagó, ka kolae samu Be-elzebulün arüngi amandóla. ");
INSERT INTO tof_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A ka kolae samu ne Be-elzebulün arüngi nóma amandóla, da yabüka nidi atandako, i ma kolae samu noan arüngi amandako? Ini zitülkusdü i sab yabü igó zaz nirre wagó, e obaedakla e nóma bóktandakla wagó, ka kolae samu Be-elzebulün arüngi amandóla. ");
INSERT INTO tof_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A ka wa kolae samu Godón tang pyómi amandóla. Akó ini klama igó poko okaka amzazilda wagó, Godón Kingzan Balngomóla yabüka kuri tame. ");
INSERT INTO tof_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Darrü arüng pam abün gazirr elklazapükü nómada akó tóba müót nóma ngakanda, oya elklaza kubó zid kwarile. ");
INSERT INTO tof_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","A kubó ma darrü arüngan pama gazirrüm nóma sisingül akyene, akó oya nóma ⌊ut-ut ine⌋, olgabi ene wirri arüngan pama ene gazirr elklaza kubó imtine, wa ne klamdó ngambangólda. Da kubó ene wirri arüngan pama arrgrrüte kamdalpükü ene arüng paman elklaza. ");
INSERT INTO tof_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Kankü koke nótóke, wa kürüka bóka bamgünda. Akó kankü pamkolpam koke nótó dakasuda, wa arngenda. ");
INSERT INTO tof_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kolae samua nóma burruanda pamdógab, wa agóltagóldase nae-koke bwóbdüma, ngón ngagón bwób byamkünkü. Wa darrü koke nóma asenda, wa tóbaka bóktanda wagó, ‘Ka ma alkomóldóla ka ne müót amgatórró.’ ");
INSERT INTO tof_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wa nóma abzilda ene müótüdü, wa morroal pabzaurrün akó ngarkwatódó asenda. ");
INSERT INTO tof_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wa tótókda, da ngibürr 7 amkoman kolaean samu we amarruda. I blamana ene müótüdü we barrbündako ola ngyabenóm. Da ene tonarrdó ene pam ugón ma tai kolaean pokodóma ngaensingülan pokodógabi.” ");
INSERT INTO tof_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesun ini pokozan bóktan yarilürr, darrü kola wirri pamkolpamab ngorodógab ugón tórrgóganórr wagó, “Bagürwómdü we aipo marü nótó mulngumilürr akó ngómdü nótó müngrinürr!” ");
INSERT INTO tof_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A Yesu ma bóktan yalkomólórr wagó, “Taiwan bagürwóm idipako, Godón bóktan nidi arrkrrudako akó tórrmendó nidi arrbündako!” ");
INSERT INTO tof_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pamkolpamab ngoroa oyakazan kwób tóbazelórr, Yesu bóktanórr wagó, “Ini lüólan pamkolpam kolaeanako. Zitülkus módóga, i kürü wirri tulmilüm atodako. A ibünkü darrü wirri tulmil tónggapórrón koke yarile, wata prropet Zonakazan ne wirri tulmila tómbapónórr. ");
INSERT INTO tof_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Zonaka ne klama tómbapónórr, ene igó wirri tulmil yarilürr Ninebe wirri basirr pamkolpama amzyatóm wagó, oya God zirrsapónórr. Da darrpan ngarkwatódó, kürüka, Pamkolpamab Olom nótókla, sab ne klama tómbapóne, ene igó wirri tulmil yarile ini lüólan pamkolpama amzyatóm wagó, kürü God zirrkapónórr. ");
INSERT INTO tof_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ngaen, Syiba kwina aibwóbdügabi katókórr king Solomonón ⌊wirri gyagüpitótók⌋ bóktan arrkrrum. Da Godón Kot Ngürrdü, ene kola sab igósidi Godón obzek kwata zamngóle ini lüólan pamkolpampükü, da sab ibü kolae tonarr wató pupainirre. Tübarrkrru, Solomonkagabi darrü wirri ngi pam aini asine! E ia kürü wirri gyagüpitótók bóktan amkoman koke iade angundakla, Syiba kwinazan Solomonón wirri gyagüpitótók bóktan amkoman yangunürr? ");
INSERT INTO tof_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ngaen, Zonan nóma arrkrruóp Godón bóktan amgolde, Ninebe basirr pamkolpama Godka tübyalüngóp tibiób kolae tonarrdógabi. Da Godón Kot Ngürrdü, i sab igósidi Godón obzek kwata bórrónge ini lüólan pamkolpampükü, da sab ibü kolae tonarr idi pupainirre. Tübarrkrru, Zonakagabi darrü wirri ngi pam aini asine! E Godka byalüngüm koke iadeakla Ninebe basirr pamkolpamzan? ");
INSERT INTO tof_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Darrü oloma zyón kla nóma setene, wa koke inike ó wa alóp lorodó koke ingrine. A wa kumngyindü emngyele, da pamkolpama kubó zyón eserre, i müótan kugupidü nóma barrbüne. ");
INSERT INTO tof_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Marü ilküp büban zyón klame. Marü ilküp ziz nómadamli, marü dudu büb ugón wirri zyóndüma; a i tümün nómadamli, marü büb wata blaman tümündüma. ");
INSERT INTO tof_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Da ma tai ngaka, marüka ne zyóne wata amkoman zyón ki yarilün a tümün koke. ");
INSERT INTO tof_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Da módóga, marü dudu büb ne zyóndü nóma yarile, ó darrü poko ne tümündü babul nómada, sab blaman zyóna gwarrarrón yarile, wamaka marü zyón klama warri mapóne.” ");
INSERT INTO tof_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu bóktan nóma elakónórr, darrü Parrisia oya we ngyaunürr wankü alom; da wa wamórr, müótüdü bangrinürr, da nólgópe banomólórr alom. ");
INSERT INTO tof_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ene Parrisia arrkürrürr wa nóma esenórr igó wa, Yesu ta tang koke bagule alom, Zu pamkolpamab bókam tumtum ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Da Lod oyaka we bóktanórr wagó, “E Parrisia kap a kübül wata tumum poko bagul umulakla, a kugupidü e kari kolae is kokeakla! Akó yabü ubi wata abün elklaza do bainüma! ");
INSERT INTO tof_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","E gonggo pamakla! Büb tumum sopae nótó tónggapónórr, wa auma büb kugupi ta ia wató koke tónggapónórr? ");
INSERT INTO tof_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","A kübül kugupidü ne klamko, e elklaza-koke pamkolpam nülinam, da módóga, blaman kla ⌊tóman-koke⌋ kwarile yabünkü Godón ilküpdü. ");
INSERT INTO tof_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“E ne Parrisiakla, sab Godón ngürsila tame yabüka! Zitülkus módóga, e ⌊wantent⌋ yabiób didiburr alo misan ngitan klamdógabi enan alióndakla Godón. A e pamkolpam dümdüm tonarre koke bangóndakla akó yabü ⌊moboküpdü ubi⌋ Godka babula. A e ma pamkolpam dümdüm tonarre ki bangón kwarila akó yabü moboküpdü ubi Godka ki kwarile, ezan wantent alióndakla. ");
INSERT INTO tof_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“E ne Parrisiakla, sab Godón ngürsila tame yabüka! Zitülkus módóga, yabü ta ene wirri ubi pokoa wirri pamab mórran pokodó mórranóm mibü kwóbbazen müótüdü. Akó yabü ta inzan wirri ubi pokoa, pamkolpama yabü morroal ngürr bóktan nüliónórre pul basirrdü. ");
INSERT INTO tof_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Sab Godón ngürsila tame yabüka! Zitülkus módóga, e wamaka gapókakla, pamkolpama koke ne kla basendako. Akó i ene gapók kwitana agóltagóldako, umul kókme igó, büdül muru aegako.” ");
INSERT INTO tof_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Darrü Mosesón gida umulbain pama bóktan yalkomólórr wagó, “Umulbain Pam, ma ini poko nóma bóktandóla, ma ta kibü samupükü akrrandóla!” ");
INSERT INTO tof_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu ibüka bóktan we yalkomólórr wagó, “E ne Mosesón gida umulbain pamakla, sab Godón ngürsila tame yabüka! Zitülkus módóga, e pamkolpam abün müp alióndakla abün gida tómbapónde ibü mamoanóm, i nabe amarrum ne kla kaindako. A e ma yabiób tang pyóm kubó kokean ingrinane ene müp kwit ainüm. ");
INSERT INTO tof_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sab Godón ngürsila tame yabüka! Zitülkus módóga, e prropetab gapók tómbapóndakla morroal obzeksyók bapónóm, prropet ngaen ne gapókdó urrbulürr - yabü abalbobatala nibiób okrralórr büdülümpükü. ");
INSERT INTO tof_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Da ini poko tómbapónde, e igó poko okaka azazindakla wagó, e ubi baindakla yabü abalbobatala ne poko tómbapónóp: i prropet okrralórr, da e ibü gapók tómbapóndakla! ");
INSERT INTO tof_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ini zitülkusdü God tóba wirri gyagüpitótóke igó bóktanórr wagó, ‘Ka sab ibüka prropet akó ⌊apostol⌋ zirrnapónónómo; i ngibürr sab okrrale büdülümpükü akó ngibürr sab wirri müp nüliónórre.’ ");
INSERT INTO tof_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Da ini lüólan pamkolpama sab müp idi ipüdórre prropetab óea ne tópkanónóp, ngaen tüpan zitüldügab, ");
INSERT INTO tof_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tai Eibolón óedógab, kókó Zekarraean óea ne tópkanórr, ⌊alta⌋ akó ⌊Gyabi Bwób⌋, ibü aodó. Amkoman, ka yabü igó byaldóla, ini lüólan pamkolpama sab blaman müp idi ipüdórre! ");
INSERT INTO tof_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“E ne Mosesón gida umulbain pamakla, sab Godón ngürsila tame yabüka! Zitülkus módóga, e kwat murrnausnarre Godónbóka umul bainüm. E yaib ene kwat koke mamoan kwarilnürrü akó ene pamkolpam, ene kwat mamoanóm nidi kain kwarilürr, e ibü nürrmatnarre!” ");
INSERT INTO tof_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu ene poko nóma amgatórr, ene tonarrdógab Mosesón gida umulbain pam akó Parrisia oyaka ngürsilpükü bóka bamgünüm bainóp akó oya abün elklazabkwata amtinüm we bainóp. ");
INSERT INTO tof_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","I akyan kwarilürr oya amiógüm oya bóktandógabi. ");
INSERT INTO tof_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ene dadan tonarr, abün taosan pamkolpama tóbazenórr. I auma tumum tibiób byól kwarilürr, darrü kan poko babul yarilürr. Yesu ngaensingülan tóba umulbain olmaldó bóktanórr wagó, “E umul-umul kwarilün Parrisiab istabkwata: ibü bóktan a tórrmen tulmil wa morroalako. A ibü aumana gyagüpitótók darrpan pokodó koke bórrmamóldako. ");
INSERT INTO tof_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Blaman ngablaorrón ne elklazako errkya, sab ma ngabratórrón kwarile, ó blaman barrón ne elklazako, sab amarrón kwarile panzedó. ");
INSERT INTO tof_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Da módóga, e ne poko zwapónórró tümündü, sab barrkrrue ngürr zyóndü. Akó e müótan kugupidü bünyón ne poko zwapónórró, sab mórrkakakdógabi amgolnórre. ");
INSERT INTO tof_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Kürü gómdamal, ka yabü igó byaldóla, e ibükagab gumgu, büb nidi amkaldako. A ene solkwat, i gaodó kokeako darrü kla tónggapónóm. ");
INSERT INTO tof_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","A ka ma yabü nómtyenónómo e noa gum koralo. E oya gum koralo, büb amkal kakóm, balngomól arüng noane yabü ⌊metat bólmyan urdü⌋ amanóm. Amkoman, ka yabü igó byaldóla, e oya gum koralo! ");
INSERT INTO tof_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ia pamkolpama kubó 5 kari póyaepókal nis kari mani küpi koke bumigrre? A Godkagab darrpana koke bamrükda, a wa ma ibü blaman gyagüpi amanda. ");
INSERT INTO tof_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Anda, yabü órrngóen ta blaman bótangórrónako. God blaman kla umula yabükwata. E gumgu, zitülkus e Godón ilküpdü wirrianakla abün kari póyaepókaldógab! ");
INSERT INTO tof_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ka yabü igó byaldóla, tóba pamkolpamab obzek kwata nótó nóma pupo baile igó, ‘Ka Yesunla,’ ka Pamkolpamab Olom nótókla, ta sab oya dadanzan pupaino Godón anerruab obzek kwata igó, ‘Wa kürüne.’ ");
INSERT INTO tof_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","A kürü nótó nóma kalpine pamkolpamab obzek kwata, ka ta sab oya yalpino Godón anerruab obzek kwata. ");
INSERT INTO tof_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Akó blamana ne kolae bóktan, kürü Pamkolpamab Olom nótókla, nidi kókyerre, God sab ene kolae tonarr norrgorre. A kolae poko nótó bóktanda Godón Samuankwata, God sab oya ene kolae tonarr koke arrgone. ");
INSERT INTO tof_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“I sab yabü kotódó nóma imarrunórre ⌊Zu pamkolpamab kwóbbazen müótüdü⌋ ó bwób singüldü pam ó wirri ngi pamab obzek kwata kürübókamde, gyakolaegu e yabiób ia bódlóngane akó e ne poko bóktónane. ");
INSERT INTO tof_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Zitülkus módóga, Godón Samua sab yabü umul nirre ene tonarrdó ne poko bóktanóm.” ");
INSERT INTO tof_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Darrüpa pamkolpamab ngorodógab oyaka we bóktanórr wagó, “Umulbain Pam, gyaurka, kürü naret yal, kibü aba büdüldü ne kla bimgatórr, ene elklaza arrgrratóm.” ");
INSERT INTO tof_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu oyaka bóktan we yalkomólórr wagó, “Gódam, ene kürü nótó küngrine yabü zaz ainüm akó yabü elklaza arrgrratóm?” ");
INSERT INTO tof_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Da wa ibüka we bóktanórr wagó, “E umul-umul kwarilün: abün elklaza do bain-gu! Yabü arról ene abün elklazadó kokeako!” ");
INSERT INTO tof_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Olgabi wa ibüka alap-alap bóktan we adrratórr wagó, “Mórrel paman tüpa zid tulum bamgünan ngibtanórr. ");
INSERT INTO tof_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Da wa tüób gyagüpi wamlórr wagó, ‘Ka dama ia kaino? Kürü kan myamem babula kólba abülan küp arrbünüm.’ ");
INSERT INTO tof_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Da tóbaka we bóktanórr wagó, ‘Ka sab ini poko tónggapono. Ka sab kólba gyagu müót nülgütnünümo, ama wirrian kla balmelo, da sab ma ka ola irrbuno ene ⌊wit⌋ küp akó ngibürr elklaza. ");
INSERT INTO tof_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sab ka kólbaka ugón bóktono kagó, “Kürü abün elklazako, sab abün pail wat yazebe. Kürü zageta kuri blakóne; ka wata sab enan mórran, alo, anón akó barnginwómdü namulo.” ’ ");
INSERT INTO tof_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","God ma oya we yalórr wagó, ‘Gonggo-e! Errkya ini ne irrübe ka marü arról apaddóla! Da kubó ma marü elklaza nótó yazebe, ma mobankü ne kla gyagu müót bapórró?’ ");
INSERT INTO tof_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Sab inzan pokoa tómbapóne oyaka, tüpan mórrel elklaza nótó kwób asuda tóbankü, a ma mórrel pam kokea Godón ilküpdü.” ");
INSERT INTO tof_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Da Yesu tóba umulbain olmaldó we bóktanórr wagó, “Ini zitülkusdü ka yabü igó byaldóla, e yabiób arrólankwata gyakolaegu igó, ‘Ia ka laró elo-o?’ Akó e yabiób bübankwata gyakolaegu igó, ‘Ia ka laró mórrkenyórr bateno?’ ");
INSERT INTO tof_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Arról wirriana alo klamdógab, akó büb wirriana mórrkenyórrdügab. ");
INSERT INTO tof_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Kokab ngabkónam: ibü arit akó abül babula. Ibü gyagu müót babulanako, a ibü ma God ngabyónda. E ma kari kla kokeakla póyaedógab! ");
INSERT INTO tof_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Darrü yabükagab gyakolae nómada elklazam, ia wa gaodóma tóba ngyaben arratóm darrpan abüs küpüm? Koke! ");
INSERT INTO tof_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Zitülkus e gaodó kokeakla ini karian kla tónggapónóm, e wa dama ngibürr elklazam iade gyakolaedakla? ");
INSERT INTO tof_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","E gyagüpi amónam, kubóla ia dódórr baindako. I kokean zagetódako, akó tibiób mórrkenyórr ta koke barrgüpdako. A ka yabü igó byaldóla, king Solomon abün arrbirrün elklaza pam enan yarilürr, a oya ma morroal mórrkenyórr ta babul kwarilürr ene pulzan. ");
INSERT INTO tof_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God ene nurr twal inzan nóma püti bainda, errkya ne klamko, sab ama urdü amarrón kwarile, da ia wama yabü koke püti nirre? Ó! Wa ta sab yabü morroal püti nirre! E kari-karibóka amkoman bangun pamkolpamakla! ");
INSERT INTO tof_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“A e wa yabiób gyagüpitótók blaman ola arrbün-gu, e sab ne kla ololo akó onolo. Ini klamóm gyakolaegu! ");
INSERT INTO tof_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Zitülkus módóga, ini blaman tüpan pamkolpam, Godónbóka umul-kók nidipko, ene inzan gyakolaedako ini elklaza azebóm. A yabü Ab ma umula, e ne klamómakla. ");
INSERT INTO tof_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","A yabü gyagüpitótók ngaen-gógópan wata Godón Kingzan Balngomóldó kwarile, da wa sab ini ne elklazako enta igósidi yabü nülirre. ");
INSERT INTO tof_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kürü kari ⌊sip⌋ yabül: e gumgu, zitülkus yabü Ab wirri bagürwómdüma yabü balngomólóm Kingzan. ");
INSERT INTO tof_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yabiób elklaza sel ninamke, ene mani ama elklaza-koke is nülinamke. Yabióbkü paos tómbapónamke, sab koke ne klama praka bairre, ó kwitüm e sab mórrel bapólamke, koke ne klama blakórre, sab gómól pama minggüpanan koke ne tame ó pua koke ne kolae nirre. ");
INSERT INTO tof_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Zitülkus módóga, marü mórrel nólamse, marü moboküp wa ta ola yarile. ");
INSERT INTO tof_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“E wata tómbapórrón kwarilo, akó yabü zyón kla babzelórrón kwarile, ");
INSERT INTO tof_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","wamaka leba zaget pama tibiób wirri pam akyandako kol amióg tóre alongalodógab alkomólóm. Módóga, wa sab nóma tolkomóle, da mamtae sólkóle, i wata sab büsai tapakurre oyankü. ");
INSERT INTO tof_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bagürwóm igó leba zaget kolpamako, oya umul-umul nidi akyan kwarile. Ka yabü amkoman poko byaldóla: wa sab ta püti baine alo kla gailüm ibü, akó wa sab ibü nólgópe banomólóm nirre alo tógaldó, akó wa tame ibü alo kla gailüm. ");
INSERT INTO tof_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sab bagürwóm kwarile ene leba zaget kolpam, nibiób wirri pama tómrrórre tómbapórrón, ia ugón irrüb zokrrok yarile, da sab ia nadü tonarr yarile, ene wirri pama nóma tolkomóle. ");
INSERT INTO tof_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Da e ini poko tai umul koralo: müót olom ne umul nóma ki yaril igó, gómól pama nadü abüs küpdü tame, wa igósidi ki aerr yaril, ene gómól pama müót amken-gum. ");
INSERT INTO tof_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","E ta metat inzan wazilülün, zitülkus ka, Pamkolpamab Olom nótókla, sab ene ngürr tamo, e koke ne ngürr akyandakla.” ");
INSERT INTO tof_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita Yesun we imtinürr wagó, “Lod, ma kibü umulüm ne alap-alap bóktan adrrüta, ia kibübóka apónda, ó ta ia blaman pamkolpamabbóka?” ");
INSERT INTO tof_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lod oya we yalórr wagó, “Ngambangól akó ⌊wirri gyagüpitótók⌋ elklaza ngabkan pam nótóke, oya wirri pama sab oya ingrine tóba leba zaget kolpam balngomólóm akó ibü alo kla aliónüm dümdüm abüs küp ngarkwatódó. ");
INSERT INTO tof_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sab kari morroal koke yarile ene leba zaget pamankü, sab wirri pama nóma tolkomóle, da ini zaget tómbapónde semrróne. ");
INSERT INTO tof_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ka yabü amkoman poko byaldóla: wirri pama sab oya tóba blaman elklaza ngabkanóm ingrine. ");
INSERT INTO tof_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","A ene leba zaget pama aprrapórr tóbaka inzan yarile igó, ‘Kürü wirri pama irrbaindase alkomólóm.’ Da wa leba zaget pam akó leba zaget kol, nibiób ngabkale, akrranóm ugón baine, akó alo garrirr a anón gorrgorr baile. ");
INSERT INTO tof_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Da módóga, sab ene leba zaget paman wirri pama igó ngürrdü tolkomóle, wa oya koke ne ngürr akyanda, akó we abüs küpdü, wa umul-kók ne abüs küpe. Oya sab we amige, wirrianbóka emkóle, da ngambangól-koke ispükü ingrine. ");
INSERT INTO tof_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Leba zaget oloma tóba wirri paman ubi umul nótóke, a ma koke tómbapónda tóba wirri paman alkomól tonarrankü akó wirri paman ubi koke tómbapónda, sab dom apóne müsamüsi abün münüm, tóba kolae tonarran darrem. ");
INSERT INTO tof_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","A umul-kók nótóke tóba wirri paman ubi ne klame, akó wa ne kolae elklaza tómbapónda tóba wirri pama oya darrem neme akyanóm kainda, sab kari-karibóka dom apóne. Wirri umul ne noan ekyene, oyakagab wirrian küpa ki tam. Akó wirri zaget ne noan ekyene, umuldi wa morroal tónggapóne, wa wirrian zaget ki tónggapóne. ");
INSERT INTO tof_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ka tamórró ini tüpan pamkolpamdó ur ódódóm. Ene ura sab pamkolpam zaz nirre akó nürrgrrütrre, da kürü wirri ubi igósa, ini ura kuri bopone! ");
INSERT INTO tof_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","A ka sab wirri azidüdü bangrino, akó kürü karibóka-koke anuda, kókó ene pokoa sab nóma blakóne! ");
INSERT INTO tof_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ia yabü gyagüpitótók igósa igó, ka wata tamórró paud ódódóm ini tüpan pamkolpamdó? Koke! Ka yabü igó byaldóla, sab pamkolpama tibiób darrem-darrem bóka bamgün kwarile kürübókamde. ");
INSERT INTO tof_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ini tonarrdógab, darrpan müótüdügab 5 ngarkwat nidipko, sab darrem-darrem bóka bamgün kwarile. Aüda sab nispükü darrem-darrem bóka bamgün kwarile, ó nisa aüdpükü. ");
INSERT INTO tof_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aba sab tóba siman olompükü tibiób darrem-darrem bóka bamgün namüli. Aipa sab tóba óp olompükü tibiób darrem-darrem bóka bamgün namüli. Kolalkota ta kolalkotpükü sab tibiób darrem-darrem bóka bamgün namüli.” ");
INSERT INTO tof_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu pamkolpamab ngorodó akó we bóktanórr wagó, “E tümün pülpül nóma esenane abüsa nóla bótaoda, e wata kubó büsai igó kwarilo wagó, ‘Kubó ngupa tame,’ - da ene wata kubó tómbapóne. ");
INSERT INTO tof_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Akó bao wóra nóma sibsue, e kubó igó bóktórre wagó, ‘Kubó urur yarile,’ - da ene wata kubó tómbapóne. ");
INSERT INTO tof_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","E taepurrane bóktan pamkolpamakla! E umulakla bwób tonarr apón, a e ma grianakla ini ngürran tonarr amzyat iada? ");
INSERT INTO tof_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ia yabü nabe iadea, yabióbkü morroal akó kolae bómzyatóm? ");
INSERT INTO tof_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Darrü oloma nóma bóktanda wagó, ma darrü kolae tónggapórró akó marü kotóm nóma ódódóm kainda, e kwat-kwat wirri arüngi bütaninamke saul bainüm. E ne saul koke nóma baini, wa marü sab zazdó kena müdó. Marü ma sab zaza pug umeab tangdó müngrine, marü tümün müótüdü angrinüm. ");
INSERT INTO tof_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ka marü igó ayaldóla: ma sab kokean tubrruno, kókóta ma sab moba dómdóm kari mani küp ungrino burruanóm, zazan bóktan ngarkwatódó.” ");
INSERT INTO tof_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ngibürr pamkolpam ene tonarrdó Yesukü nidi kwarilürr oya izazilóp, ne pokoa tómbapónórr ngibürr Galili pamkolpamdó. Rrom gabena Paelat oya gazirr pama ibü ekrrónóp, Godka ⌊urdü amsel lar⌋ nidi bónganónóp. ");
INSERT INTO tof_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu bóktanórr wagó, “Igó gyagüpi tótókgu igó, i kari kolae koke tólbael kwarilürr blaman Galili pamkolpamdógabi, zitülkus i ne ngarkwatódó nurrbarinürr. ");
INSERT INTO tof_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ka yabü amkoman poko byaldóla: ene inzan koke yarilürr! A e ne Godka koke nóma tübyalüngane yabiób k