﻿USE sofia;
DROP TABLE IF EXISTS sofia.tod_vpl;
CREATE TABLE tod_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tod_vpl WRITE;
INSERT INTO tod_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tɔɔzeizu mɔunpa GALA ge geeɠɔlɔgi ta zooi ɓɛtɛni. ");
INSERT INTO tod_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kɛʋele ɠila ge la ɠɛni zooi ʋa, suɲakai ɠɛni de. Kpidii ʋɛɛni ziɛ zɛbɛlɛ golai ɠa. GALA Zɛnvui ɠɛni leʋeteʋesu ziɛi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","GALA ge ɠɛni ma: «Wozakalagi ɠula.» Wozakalagi ma ge ɠula. ");
INSERT INTO tod_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","GALA ge kaani ga wozakalagi ʋagɛ. GALA ge wozakalagi ta kpidii yeeɠaaɠwɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","GALA ge wozakalagi laasei pɛɛni ga foloi, é kpidii laasei pɛɛ ga kuai. Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga folo mɔungi. ");
INSERT INTO tod_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","GALA ge ɠɛni ma: «Zɔɠɔzu ɠɛ ziɛiti ba, é ziɛiti zeeɠaaɠwɛ ta ziɛiti.» ");
INSERT INTO tod_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","GALA ge zɔɠɔzu ɠɛɛni ziɛiti ba, niiti ti buu ʋelei, ta niiti ti maazu ʋelei. Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","GALA ge zɔɠɔzuʋɛ laasei pɛɛni ga geeɠɔlɔgi. Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga foloi velesiɛi. ");
INSERT INTO tod_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","GALA ge ɠɛni ma: «Ziɛiti ti geeɠɔlɔgi wu, naati ti ɠaalɛ ba ada ɠila, ada vɔɔi ɠula kɛlɛma.» Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","GALA ge ma vɔɔi laasei pɛɛni ga zooi. Ziɛiti ti ɠaalɛai ba, é naati daasei pɛɛ ga kpoloɗɛiti. GALA ge kaani ga naa ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Naa ʋolu GALA ge ɠɛni ma: «Zooi pɔnɔba aniiti kula, eɠɛʋelei ti-ma ziiti ti la: tufai nii ma waai su a ɠɛ ga ma zuwui, ta gwaa wuluiti, niiti ti-ma waai ti zu ta ɠɛ ga ma zuwui.» Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Zooi pɔnɔba aniiti kulani, eɠɛʋelei ti-ma ziiti ti la: tufai nii ma waai su a ɠɛ ga ma zuwui, ta gwaa wuluiti, niiti ti-ma waai ti zu ta ɠɛ ga ma zuwui. GALA ge kaani ga naa ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga foloi zaʋasiɛi. ");
INSERT INTO tod_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","GALA ge ɠɛni ma: «Wozakalagiti ti ɠɛ geezuʋɛ geei ɠaaʋɛ, ti foloi ta kuai yeeɠaaɠwɛ. Naati ti ɠɛ ga poogiti, é lo siɛgiti ba, ta foloiti, ta konagiti, ");
INSERT INTO tod_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ti ɠɛ ga wozakalagiti geei ɠaaʋɛ, ti eteai zuɠala.» Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","GALA ge wozakala gola felegɔiti kpɛtɛni, ma wola gelei ɗa zei foloi unda, ma go gelei ɗa zei kuai unda. É somideɠaiti ɓalaa kpɛtɛni. ");
INSERT INTO tod_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","GALA ge ti zɛlɛni geei ɠaaʋɛ ga ti ɗa eteai zuɠala, ");
INSERT INTO tod_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ti zei foloi ta kuai unda, ti wozakalagi ta kpidii yeeɠaaɠwɛ. GALA ge kaani ga naa ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga foloi naanisiɛi. ");
INSERT INTO tod_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","GALA ge ɠɛni ma: «Ziɛ wu ani vuluiti ti wola mɔin ziɛiti bu, wɔniiti ti ɗa ɠoʋe geezuʋɛ, zooi maazu.» ");
INSERT INTO tod_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","GALA ge kpoloɗɛ wu zua wolaiti kpɛtɛni, eɠɛʋelei ti-ma ziiti ti la, ta zɛnvu anii ma ziiti kpein, eɠɛʋelei ti-ma ziiti ti la, niiti ti leʋeteʋesu ziɛiti bu. É wɔniiti kpɛtɛni, eɠɛʋelei ti-ma ziiti ti la. GALA ge kaani ga naa ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","GALA ge tuya looni ti ʋɛ, é ɠɛ ma: «À ɓuɠu, wo mɔin, wo kpoloɗɛiti buulaave, wɔniiti ti mɔin eteai zu.» ");
INSERT INTO tod_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga foloi lɔɔlusiɛi. ");
INSERT INTO tod_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","GALA ge ɠɛni ma: «Zooi fuluaniiti kula, eɠɛʋelei ti-ma ziiti ti la: toganiiti, ta kpokpo ganiiti, ta dɔɓɔ zuaiti, eɠɛʋelei ti ɠilagilagi ti-ma ziiti ti la.» Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","GALA ge dɔɓɔ zuaiti kpɛtɛni, eɠɛʋelei ti-ma ziiti ti la, toganiiti eɠɛʋelei ti-ma ziiti ti la, ta kpokpo ganiiti pɛ, eɠɛʋelei ti-ma ziiti ti la. GALA ge kaani ga naa ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","GALA ge ɠɛni ma: «Ade nuɓusɛi ɓɛtɛ ga ade-maaniinigi, é ɠɛ ga de-ʋaaɠulabai, é zei kaleiti unda, ta wɔniiti, ta toganiiti, ta eteai pɛ, ta aniiti kpein ti ɓokposu zooi ma.» ");
INSERT INTO tod_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","GALA ge nuɓusɛi ɓɛtɛni ga tɔ ɓɔɠɔi maaniinigi, é kpɛtɛni ga GALA maaniinigi. É zunui ta anzanui ɓɛtɛni. ");
INSERT INTO tod_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","GALA ge tuya looni ti ʋɛ, é ɠɛ ti ma: «À ɓuɠu, wo mɔin, wo eteai laave, wo maaɠolo. À zei kaleiti unda, ta wɔniiti, ta suai kpein é yɛnvuzu zooi ɠa.» ");
INSERT INTO tod_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","GALA ge ɠɛni ma: «Wɛlɛ, tufai nii ma waai su a ɠɛ ga ma zuwui, zooi ɠa ná pɛ, gè naa vea wo ʋɛ, ta gului nii ma waai su a ɠɛ ga ma zuwui, naa ɠa ɠɛ ga wo-laamianigi. ");
INSERT INTO tod_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Gè tufa wundui vea ga daamianigi zou ɠa zuaiti pɛ bɛ, ta wɔniiti, ta nii kpein é ɓokposu zooi ma, nii nɔpɛ zɛnvu viilɛi su.» Naa ɠɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","GALA ge kaani ga nii kpein é kpɛtɛai, ti wola ʋagɛ. Kpidii ʋɛɛni, geelaalao: naa ɠɛni ga foloi lɔzitasiɛi. ");
INSERT INTO tod_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Pele ɠana geeɠɔlɔgi ɓɛtɛ vai ɓeni la ta zooi, ta ti zu aniiti kpein. ");
INSERT INTO tod_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Foloi lɔfelasiɛi, GALA kpegai ma ga ná-botii ɠaaɓela, é looɠoni ná-botii pɛ ba, nii é kɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","GALA ge tuya looni foloi lɔfelasiɛi ʋɛ, é makɛ ɓɔɠɔ ʋɛ, tɔɔzei naama voloi é looɠoni, é lo ná-botii pɛ ba, aniiti kpɛtɛ vai zu é kɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Geeɠɔlɔgi ta zooi lɔɔzei ʋelei ɠa é ga nii, siɛgi zu ti ɓɛtɛni la. Siɛgi zu Ɠɔoɠɔ GALAGI zooi ta geeɠɔlɔgi ɓɛtɛni la, ");
INSERT INTO tod_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","dɔɓɔ ɠila kpalaa ge la ɠɛni dɛ eteai zu, tufa ɠila kpalaa ge la ɠɛni dɛ ʋɔnɔni, mazɔlɔɔ Ɠɔoɠɔ GALAGI la ɠɛni dɛ tona ʋuuni zooi ma, nu la ɠɛni dɛ ná ɲɛgɛlɛin, é ʋa ɗa boti ɠɛ zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kɛlɛ ɓumugi ɠɛni wuzeɠezu, é ɗa zooi ma yɛɓɛ. ");
INSERT INTO tod_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ɠɔoɠɔ GALAGI zooi ma ʋɔlɔi zeɠeni, é kpɛtɛ ga zunui, é zɛnvu viilɛi ʋu sokpayeɠeiti su, zunui ɠɛ ga zɛnvu su anii. ");
INSERT INTO tod_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Naa ʋolu Ɠɔoɠɔ GALAGI kpelei leʋeni Edɛn yooi zu, folo ɠulazu ʋelei. É zunui ʋilɛni su, nii é kpɛtɛai. ");
INSERT INTO tod_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","É gului ma zii kpein pɔnɔni zooi ɠa, ti ʋɛtɛga maanɛai, ti-ma waaiti nɛai. Zɛnvu wului ɠɛni loni kpelei zaamaʋɛ, naa ʋɛɛ gului ʋa, nii é faa ʋagɔi ta faa ɲɔi yɔɠɔzuɠwɛɛ pelei lɛɛzu. ");
INSERT INTO tod_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ziɛ wolai ɠɛni ɠulazu Edɛn yooi zu, é ɗa ʋu kpelei ma. Kulaai ma ná ʋa, gaaɠwɛɛni su ga ma ɓeke naanigɔ. ");
INSERT INTO tod_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ma mɔungi laaseigi ɠɛni ga Pison, naa ɠa kakuɠakugai Ɠavila yooi ná pɛ su. Zanugi ɠa ɗa ɠa zooi naa zu, ");
INSERT INTO tod_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","zanugi nii pagai. Nu ɠa ɗa gulu mana maku nɛɛnɛgi ɓalaa ɠa ná, daa ga ɓedɛliwume, ta kɔtu zɔngɔ ɓaagi, daa ga wonikese. ");
INSERT INTO tod_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Felesiɛi laaseigi ɠɛni ga Giyon, naa ɠa kakuɠakugai Kuse yooi ná pɛ su. ");
INSERT INTO tod_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Saʋasiɛi laaseigi ɠɛni ga Tigele, naa ɠa é yeizu Asuul laai zu folo ɠulazu ʋelei. Ziɛ wolai naanisiɛi ɠa é ga Efelate. ");
INSERT INTO tod_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ɠɔoɠɔ GALAGI zunui zeɠeni, é pilɛ Edɛn kpelei zu, ga é tii ɠɛ ná, ta é makɛ. ");
INSERT INTO tod_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","É devei nii veeni zunui ya, é ɠɛ ma: «Ɗa zoo è guluiti kpein ma waaiti ta mi, niiti ti kpelei zu, ");
INSERT INTO tod_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","kɛlɛ nii é faa ʋagɔi ta faa ɲɔi yɔɠɔzuɠwɛɛ pelei lɛɛzu, mina naama waai ta mi, mazɔlɔɔ voloi ɗa naa ta miina la, ɗa za.» ");
INSERT INTO tod_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ɠɔoɠɔ GALAGI ɠɛni ma: «É la ʋani ga zunui ɠila ko yɛ de. Nà kpɔba nu ʋagɔ ɓɛtɛzu bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ɠɔoɠɔ GALAGI dɔɓɔ zuaiti ta wɔniiti kpɛtɛni ga pɔlɔi. É ʋaani ga tiye zunui ʋɔ, é pɛtɛ, ʋelei a ti-laaseigiti pɛɛ la, naa ɠa a kɛ ti kpein ti daaseigi zɔlɔɔ, nii zunui a pɛɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Zunui daaseigiti pɛɛni toganii pɛ ba, ta wɔniiti, ta dɔɓɔ zuaiti kpein. Kɛlɛ zunui la ɠɛni kpɔba nu ʋagɔ zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ɠɔoɠɔ GALAGI ɲiimɛni wolai lɔɔni zunui ɠaazu, é ɲi. É kaka ɠaegi gila seɠeni, é ma zuai laaɠulu pogi zu. ");
INSERT INTO tod_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ɠɔoɠɔ GALAGI anzanui ɓɛtɛni ga naama ɠaka ɠaegi, nii é seɠeni, é kula zunui ɠakai zu, é ʋaani la zunui ʋɔ. ");
INSERT INTO tod_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Zunui ɠɛni ma: «Niizu nii ɠa é ga kaei, nii é ga mà ɠaei, kpusɛi nii é ga kpùsɛi. Daaseigi ɠa ʋɛɛ ga anzanui, mazɔlɔɔ kulaʋɛ zunui zu.» ");
INSERT INTO tod_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Naa ɠa é ba, zunui ɠa zeɠe kɛɛɠɛ ta dee ʋa, é ɠili anzai ʋa, ti ɠɛ ga kpusɛ ɠila. ");
INSERT INTO tod_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Zunui ta anzai ti felegɔ ti ɠabei ɠɛni de, kɛlɛ ti la ɠɛni unfesu ɓɔɠɔ ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kaalii ɠeleɠelega ɠɛni de, é leʋe dɔɓɔ zuaiti kpein ba, niiti Ɠɔoɠɔ GALAGI ti ɓɛtɛni. É ɠɛni anzanui ma: «GALA ge bogɛ nɛi ga ɠite, ga wo mina guluiti kpein ma waai mi, niiti ti kpelei zu?» ");
INSERT INTO tod_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Anzanui kaalii wooɠaaʋoteni, é ɠɛ ma: «Gá zoo gi kpelei zu wuluiti ma waai ta mi. ");
INSERT INTO tod_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kɛlɛ nii é ga gului é loni kpelei zaamaʋɛ, naa ma waai, GALA ge ɠɛni ma: ‹À mina ta mi, wo mina vɔɔɠu ba, naa ɠa a kɛ wo mina za.› » ");
INSERT INTO tod_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kaalii ɠɛni anzanui ma: «Wo la zaa ɲɛgɛlɛin! ");
INSERT INTO tod_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kɛlɛ GALA ge kwɛɛ ga foloi nɔpɛ wo ta miizu la, wo-ɠaazuʋɛti ta zeɠe ma, wa ɠɛ eɠɛ GALA, wa faa ʋagɔi ta faa ɲɔi yɔɠɔzuɠwɛɛ.» ");
INSERT INTO tod_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Anzanui kaani ga gului naa ma waaiti pɛtɛ ga maanɛɛʋɛ, ta pagɛ ga nu mi, fizɔgɛ ga é keleɠelegi ve nu ya. É ma waai ta ɠulani, é mi. Naa ʋolu é ta veeni sinigi ya, nii é ɠɛni koba, naa ɓalaa ge miini. ");
INSERT INTO tod_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ti felegɔ ti-ɠaazuʋɛti ti zeɠeni ma. Ti kwɛɛni ga ti ɠabei ʋe. Ti kooleɠoole gului ma laaiti daɠani, ti gili ɓɔɠɔ ma. ");
INSERT INTO tod_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kpɔkɔ lɛilɛigi, ti Ɠɔoɠɔ GALAGI lugi mɛnini, é ɗa ziɛziɛ kpelei zu. Zunui ta anzai ti lɔɔɠuni poun Ɠɔoɠɔ GALAGI ʋa kpele zu wuluiti saama. ");
INSERT INTO tod_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ɠɔoɠɔ GALAGI zunui lolini, é ɠɛ ma: «Mini ɠa è ná?» ");
INSERT INTO tod_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","É gooɠaaʋoteni, é ɠɛ ma: «Gè è-lugi mɛnigɛ kpelei zu. Dùaʋɛ, mazɔlɔɔ kàbei ʋe, naa ɠa é kɛa gè lɔɔɠua.» ");
INSERT INTO tod_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ɓɛ ɠa kɛai è ma, è ɠabei ʋe? È gulu waai naa ta mia ɓaa, nii gè ɠɛni è ma, mina ta mi?» ");
INSERT INTO tod_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Zunui gooɠaaʋoteni, é ɠɛ ma: «Anzanui nii è fea zèa, ga gi eteai ziɛ ʋɔɔma, naa ɠa é gulu waai vea zèa, gè ta mi.» ");
INSERT INTO tod_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ɠɔoɠɔ GALAGI ɠɛni anzanui ma: «Leeni vaa zu è naa ɠɛai?» É gooɠaaʋoteni, é ɠɛ ma: «Kaalii ɠa é yàava, gè gulu waai ta mi.» ");
INSERT INTO tod_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ɠɔoɠɔ GALAGI ɠɛni kaalii ma: «Tɛi è naa ɠɛa, gè è ɠotoa, toganiiti kpein ta dɔɓɔ zuaiti saama. Ɗa ɗa ɓokpo è-ɠogi ma, è ɗa pɔlɔi mi, è-zii ma voloi pɛ su. ");
INSERT INTO tod_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nà kpaai lɔ wo yɔɠɔzu wa anzanui, naa ɠa ɠɛ mavofodai ta ɗɔnɔiti zɔɠɔzu. Nɔnɔi ɠa ɗɔungi maawana, ɗɔun ɗa kɔɠɔ libiligi maawana.» ");
INSERT INTO tod_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","É ɠɛni anzanui ma: «Nà ta la ɗa-ɓɔlɔi ma, kogi a ɠɛna è ma, ɗa ɓɔlɔ pɛ, ɗa ʋa dointi sɔlɔɔ. È yiima vai ɠa è mɛɛn è-zinigi ʋɔ pelei, toɠa zei è unda.» ");
INSERT INTO tod_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","É ɠɛni zunui ma: «Tɛi è woiloga è-anzai wooi ma, è gulu waai mi, nii gè ɠɛni è mina mi, zooi ɠa ɠoto è maaʋele ma. Kɛni è zuvikɛi ɠula, è ɓɔlɔ pɛ, é ʋa leɠa è-laamianigi zɔlɔɔ, è-zii ma voloi pɛ su. ");
INSERT INTO tod_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Toɠa ɠaingiti pɔnɔ è laalɔɠɔma. Ɗa ɠɛ zooi ɠa lufaiti miizu. ");
INSERT INTO tod_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ɗa è-laamianigi zɔlɔɔ, kɛlɛ kɛni fɔdɔi ɠula è-loʋalaʋɛ, eyɛsu è ɠale ma zooi wu, ʋɛ è zeɠeai ná. Mazɔlɔɔ è ɓɛtɛʋɛ ga pɔlɔi, ɗa ɠale ma pɔlɔi zu.» ");
INSERT INTO tod_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adama anzai laasei pɛɛni ga Ɛve, mazɔlɔɔ tɔ ɠa é ɠɛni ga nu vuluiti kpein ti-lee. ");
INSERT INTO tod_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ɠɔoɠɔ GALAGI sua ɠɔlɔi ɓɛtɛni ga seɠei Adama ta anzai ʋɛ, é too ti ɠɔba. ");
INSERT INTO tod_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ɠɔoɠɔ GALAGI ɠɛni ma: «Pɛtɛ, zunui ɠɛa eɠɛ ade taɠila, faa ʋagɔi ta faa ɲɔi yɔɠɔzuɠwɛɛ fai zu. Ade pele leʋe tuɠɔ niina, é mina yeemaale, é ʋa zɛnvu wului ma waai ɠula, a ʋa mi, a ʋa yɛ vulua ɠɔoɠɔ.» ");
INSERT INTO tod_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ɠɔoɠɔ GALAGI zunui ɠulani Edɛn kpelei ʋa, ga é ɗa zooi woli, ʋɛ kulaai ná. ");
INSERT INTO tod_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","É zunui ɓɛai ma, geezuɠeelaiti ti-laaseigi ga seeluɓɛin, é naati toni Edɛn kpelei zu folo ɠulazu ʋelei, ta boɠa zɔkpɔi nii abui ba, é ɗa lati, ti ɗa zɛnvu wului ma ʋelei makɛ. ");
INSERT INTO tod_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Zunui anzai Ɛve laani ʋolu, naa kogi zeɠe, é sɔlɔɔ ga Kayɛn, é ɠɛni ma: «Gè zunu zɔlɔɔga ga Ɠɔoɠɔ GALAGI ná-kpɔbai maaʋele.» ");
INSERT INTO tod_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Naa ʋolu, é deɠei Aɓɛle zɔlɔɔni. Aɓɛle ɠɛni ga baala makɛ nui, Kayɛn ɠɛ ga tii ɠɛɛ nui. ");
INSERT INTO tod_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yeeɠɛɠalai ta laawu, Kayɛn ʋaani ga zooi ʋaalɔnɔgi tanigaa, é kɛ ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Aɓɛle ɓalaagi ʋaani ga ná-baala kpulugi ma yiʋo mɔungi tanigaa, é ti-ma zuai ʋasuʋɛti kula ga zalaɠai. Ɠɔoɠɔ GALAGI yeezeini Aɓɛle ta ná-vebɛanii wu ga pagɔ. ");
INSERT INTO tod_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kɛlɛ é la ɠɛni yeezeini Kayɛn ta ná-vebɛanii wu. Kayɛn wola yiiɠaawanani, gaazuɠili. ");
INSERT INTO tod_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ɠɔoɠɔ GALAGI ɠɛni Kayɛn ma: «Lee vaa zu è yiiɠaawanaai, è ɠaazuɠili? ");
INSERT INTO tod_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Gaaɠalagɛ ga ni ɗa faa ʋagɔi ɠɛɛna, ɗa ɠaazuʋɛ wuzeɠe, kɛlɛ ni ɗa faa ɲɔi ɠɛɛna, kotoi ɠa laani ɗa-ʋɛlɛlaʋɛ. Ziima vai ɠa ɠɛ ga é zei è unda, kɛlɛ ɗɔun, vɔni ma.» ");
INSERT INTO tod_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kayɛn ɓɔɛni deɠei Aɓɛle ʋɔ, tɛi ti ɠɛni dɔɓɔi zu, Kayɛn valani Aɓɛle ʋa, é paa. ");
INSERT INTO tod_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Naa ʋoluma, Ɠɔoɠɔ GALAGI ɠɛni Kayɛn ma: «È-leɠei Aɓɛle ɠa mini?» É gooɠaaʋoteni, é ɠɛ ma: «Gè la kwɛɛ. Nà ɠa gè ga dèɠei makɛ nui ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Naa ɠɛni ma: «Lee ɠa è kɛai? È-leɠei ma ɲamai ɓain gooi ɠa zeelizu mà, é zeɠe zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Niizu è ɠotoʋɛ zooi ɠa, nii é laalaoga, é è-leɠei ma ɲamai ɓɔle, è paai. ");
INSERT INTO tod_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Siɛgi zu è boti ɠɛɛzu la zooi ma, é la mɔ ná-kulanuma vea è ya. Ɗa ɠɛ ga pela nu, è ɗa leʋeteʋe eteai zu.» ");
INSERT INTO tod_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayɛn ɠɛni Ɠɔoɠɔ GALAGI ma: «Nà-faa ɲɔi ma ɓakɔi wola wuiʋɛ ga gè ʋa ziɛ bu. ");
INSERT INTO tod_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Wɛlɛ, ɗa kpɛ̀ɛzu za tii ɠɛɛ yooi ma, gè maaɠooza, gè lɔɔɠu è ʋa. Nà ɠɛ ga pela nu, gè ɗa leʋeteʋe eteai zu. Ni nu a kàana, toɠa pàa.» ");
INSERT INTO tod_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ɓa-o! Ni nui ta a Kayɛn ʋaana, Kayɛn nɔnɔi ʋoto ka ɠula naama nui ma, ná zeizu ɠɛ lɔfela.» Ɠɔoɠɔ GALAGI poogi ʋɛɛni Kayɛn ʋa ga nu nɔpɛ ka kaana, é mina paa. ");
INSERT INTO tod_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Naa ʋolu, Kayɛn maaɠoozani Ɠɔoɠɔ GALAGI ʋa, é li, é zei Nɔde yooi zu, Edɛn folo ɠulazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayɛn anzai laani ʋolu, naa kogi zeɠe, é Enɔke zɔlɔɔ. É taai loni, é ná-doun zunui laaseigi ʋɛɛ ba. ");
INSERT INTO tod_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enɔke Iilade zɔlɔɔni, Iilade Meɠuyayɛle zɔlɔɔ, Meɠuyayɛle Metusayɛle zɔlɔɔ, Metusayɛle Lemɛke zɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemɛke anza felegɔ zeini. Gilagi laaseigi ɠɛni ga Ada, zɔi laaseigi ɠɛ ga Sila. ");
INSERT INTO tod_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada Yaɓale zɔlɔɔni. Tɔ ɠa é ga naati ti-mɛmɛwolai, niiti ti zeini seɠe ɠotaiti bu, ti ɗa toganiiti makɛ. ");
INSERT INTO tod_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Deɠei laaseigi ɠɛni ga Yuɓale. Tɔ ɠa é ga naati kpein ti-mɛmɛwolai, niiti ti kɔnigi ɠɛinsu, ti ɗa koolei vɛ. ");
INSERT INTO tod_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila ɓalaagi Tuɓale-Kayɛn zɔlɔɔni, naa ɠa é ɠɛni ga kɔlu ɓɔigi ta kɔlu aniiti kpein gain nui. Tuɓale-Kayɛn deɠe anzanui ɠɛni ga Naama. ");
INSERT INTO tod_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lemɛke ɠɛni anzaiti ma: «Ada ta Sila, à woilo gòoi ma, Lemɛke anzaiti, à woilo ga pagɔ gòoi ma. Gè zunu ʋaani màawana vai zu, ta zunu loungo nà-palai vaa zu. ");
INSERT INTO tod_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Potokulai a ɠɛna Kayɛn ma, ná zeizu ɠɛ lɔfela, Lemɛke nɔnɔi zeizu ɠa ɠɛ ga puulɔfela maazu lɔfela (77).» ");
INSERT INTO tod_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adama anzai laani ʋolu mɔnɔ, naa kogi zeɠe, é doun zunu zɔlɔɔ, é daasei pɛɛ ga Sɛte, mazɔlɔɔ é ɠɛni ma: «GALA ge doun zunu ɠili fea zèa Aɓɛle ʋotogi zu, nii Kayɛn paani.» ");
INSERT INTO tod_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sɛte doun zunu zɔlɔɔni ɓalaa, é daasei pɛɛ ga Enɔse. Názuʋɛ ɠa ti tɔɔzeini la ga Ɠɔoɠɔ GALAGI valia. ");
INSERT INTO tod_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama mavofodai ma zɛʋɛi ɠa. Siɛgi zu GALA ge nui ɓɛtɛni la, é kpɛtɛni ga GALA baaɠulabai. ");
INSERT INTO tod_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","É zunui ɓɛtɛni ta anzanui, é tuya looni ti ʋɛ, é ti-laasei pɛɛ ga nuɓusɛi, ti ɓɛtɛ voloi nɔ. ");
INSERT INTO tod_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adama ná-konagi ɠɛai ma ga ungila puusaʋagɔ (130), é doun zunu zɔlɔɔni, nii é ɠɛni ga baaɠulabai, ta maaniinigi, é daasei pɛɛni ga Sɛte. ");
INSERT INTO tod_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛte zɔlɔɔga ʋoluma, Adama kona undɔsaʋa (800) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adama zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ puusaʋagɔ (930), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛte ná-konagi ɠɛai ma ga ungila dɔɔlugɔ (105), é Enɔse zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔse zɔlɔɔga ʋoluma, Sɛte kona undɔsaʋa kona dɔfela (807) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛte zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ puugɔ maazu felegɔ (912), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enɔse ná-konagi ɠɛai ma ga puutaaʋuugɔ (90), é Kenan zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan zɔlɔɔga ʋoluma, Enɔse kona undɔsaʋa puugɔ maazu lɔɔlugɔ (815) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enɔse zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ kona dɔɔlugɔ (905), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan ná-konagi ɠɛai ma ga puulɔfela (70), é Maɠalaleyɛle zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maɠalaleyɛle zɔlɔɔga ʋoluma, Kenan kona undɔsaʋa puunaanigɔ (840) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ kona puugɔ (910), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maɠalaleyɛle ná-konagi ɠɛai ma ga puulɔzita maazu lɔɔlugɔ (65), é Yelɛde zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yelɛde zɔlɔɔga ʋoluma, Maɠalaleyɛle kona undɔsaʋa puusaʋagɔ (830) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maɠalaleyɛle zii ma voloi kpein ge ɠɛni ga kona undɔsaʋa puutaaʋuu maazu lɔɔlugɔ (895), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yelɛde ná-konagi ɠɛai ma ga ungila puulɔzita maazu felegɔ (162), é Enɔke zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔke zɔlɔɔga ʋoluma, Yelɛde kona undɔsaʋa (800) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yelɛde zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ puulɔzita maazu felegɔ (962), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enɔke ná-konagi ɠɛai ma ga puulɔzita maazu lɔɔlugɔ (65), é Matuzalɛme zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matuzalɛme zɔlɔɔga ʋoluma, Enɔke kona unsaʋagɔ (300) ɠili kɛɛni, é ɗa ziɛ ga GALA ziimai. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔke zii ma voloi kpein ge ɠɛni ga kona unsaʋagɔ puulɔzita maazu lɔɔlugɔ (365). ");
INSERT INTO tod_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enɔke ziɛni ga GALA ziimai, é la ɠɛni yɛni ná, tɔɔzei GALA ge seɠeni. ");
INSERT INTO tod_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuzalɛme ná-konagi ɠɛai ma ga ungila puulɔsaʋa maazu lɔfela (187), é Lemɛke zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛke zɔlɔɔga ʋoluma, Matuzalɛme kona undɔfela puulɔsaʋa maazu felegɔ (782) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matuzalɛme zii ma voloi kpein ge ɠɛni ga untaaʋuugɔ puulɔzita maazu taaʋuugɔ (969), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemɛke ná-konagi ɠɛai ma ga ungila puulɔsaʋa maazu felegɔ (182), é doun zunu ɠila sɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","É daasei pɛɛni ga Nowe. É ɠɛni ma: «Nii ɠa ade ɠaanɛɛnɛ ada-wotiiti ta ada-ɓɔlɔiti kpein faa zu, é zɔlɔɔsu zooi ʋa, nii Ɠɔoɠɔ GALAGI foovoai.» ");
INSERT INTO tod_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowe zɔlɔɔga ʋoluma, Lemɛke kona undɔɔlugɔ puutaaʋuu maazu lɔɔlugɔ (595) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lemɛke zii ma voloi kpein ge ɠɛni ga kona undɔfela puulɔfela maazu lɔfela (777), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nowe ná-konagi ɠɛai ma ga undɔɔlugɔ (500), é Sɛme ta Same ta Zafɛteni sɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Siɛgi zu nuiti ti tɔɔzeini la ga mɔinɗa zooi ɠa, ti doun anzanuiti sɔlɔɔni, ");
INSERT INTO tod_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","GALA doun zunuiti ti kaani ga nuiti ti-loun anzanuiti pagɛ, ti tanigaani seɠeni, ti ti ɠɛ ga ti-anzaiti, naati saama, niiti ti yiimazeɠeni ga tiye. ");
INSERT INTO tod_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Názu ɠa Ɠɔoɠɔ GALAGI ɠɛni ma la: «Nà-zɛnvui la yɛga nuɓusɛi zu ɠɔ, mazɔlɔɔ nui ɠa ga saa ani nɔ, sii ma voloi ɠa ɠɛ ga kona ungila puufelegɔ (120) nɔ.» ");
INSERT INTO tod_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Kooza nuiti ti ɠɛni eteai zu naama ziɛgiti su. Ʋele nɔ ɠana é ɠɛni la, GALA doun zunuiti pilɛga ʋoluma nuiti ti-loun anzanuiti polu. Naati ti dointi sɔlɔɔni ti ʋɛ, naama nu wolaiti ka ti lɔɠɔɠulani wɔlɔwɔlɔi zu. ");
INSERT INTO tod_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ɠɔoɠɔ GALAGI kaani ga nuɓusɛiti ta-vaa ɲɔi wola wɔɔlɔni zooi ɠa, ti-yiimaʋɛ ma ɠisiɛiti ti ɠɛni losu nɔ faa ɲɔi ʋa folo-o-folo. ");
INSERT INTO tod_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ɠɔoɠɔ GALAGI yiiɠoloɠoloni nuɓusɛi ɓɛtɛ vai zu, é pilɛ zooi ɠa, gola ɠaazuɠilini. ");
INSERT INTO tod_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","É ɠɛni ma: «Nà nuɓusɛi ma zuwu ɠaaleʋezu zooi ɠa, nui nii gè kpɛtɛai, naa ʋɛɛ toganiiti ba, ta kpokpo ganiiti, ta wɔniiti, mazɔlɔɔ zìiɠoloɠologɛ ga leeni vaa zu gè ti ɓɛtɛai.» ");
INSERT INTO tod_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kɛlɛ Nowe zaalai zɔlɔɔni Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowe mavofodai ʋɛtɛ. Nowe ɠɛni ga telebo nu ta sɔle nu ná-siɛgi zu nuɓusɛiti saama. Nowe ɠɛni ziɛzu ga GALA ziimai. ");
INSERT INTO tod_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowe doun zunu saʋagɔ zɔlɔɔni: Sɛme, ta Same, naa ʋɛɛ Zafɛte ʋa. ");
INSERT INTO tod_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Eteai ɠoloɠoloni GALA gaazu, daave ga toomai. ");
INSERT INTO tod_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","GALA ge eteai ʋɛtɛni, é ka ga é ɠoloɠologa, mazɔlɔɔ nuɓusɛiti kpein ti-ziɛ ʋelei ɠoloɠoloni eteai zu. ");
INSERT INTO tod_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","GALA ge ɠɛni Nowe ma: «Gè devea ga gè kpɛtɛanii kpein sii ɠaaɓela, mazɔlɔɔ nuiti ti eteai laavega ga toomai. Naa ɠa é ba, nà ti undaaʋilisu zooi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kein golai ɓɛtɛ ga gulu ʋagɔi. Ɗa teʋeleʋe su ga pɛlɛ goiti, è managi ziɛ koozuʋɛ ta poluʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Wɛlɛ ʋelei ɗa kɛ la: keingi zakpai ɠa ɠɛ ga mɛtɛlɛ ungila puulɔɔlugɔ (150), kogi ɠɛ ga mɛtɛlɛ ʋuufelegɔ maazu lɔɔlugɔ (25), ta gaalɔgai ɠɛ ga mɛtɛlɛ puugɔ maazu lɔɔlugɔ (15). ");
INSERT INTO tod_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ɗa fiilɛ zosuʋɛ ɠɛ ba maazuʋɛ kavagi wu, é ɠaku ma, nii tiegɔi a ɠɛ ga mɛtɛlɛ ʋalisaamai liegɔi. Ɗa daaʋɛ ɠula kakamaʋɛ. Ɗa sangasoi lo suʋɛ, ma ʋɛlɛi ɠɛ ɓɔɠɔ maazu ga saʋagɔ. ");
INSERT INTO tod_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nɔ̀un nà, nà ʋaazu ga ziɛve golai zooi ɠa, ga é fuluaniiti kpein koloɠolo, niiti kpein ti zooi ɠa, ti undaa ɠa ʋili. ");
INSERT INTO tod_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kɛlɛ nà nà-minazeɠegi ɠɛɛzu de yɔɠɔzu, ɗa lɛ keingi zu, ɗa-o, è-loun zunuiti-yo, é ʋɛɛ è-anzai ta è-loun anzaiti ba. ");
INSERT INTO tod_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ɗa suai ma zii velefelegi lɛ keingi zu ɓalaa, ga è ti-ma vului makɛ ɠoba. Ɗa kɛ ga ma zinɛ ɠila ta ma zaa ɠila. ");
INSERT INTO tod_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ma zinɛ ta ma zaa, ma zii ɠilagilagi ɠa ʋa è ʋɔ bɛ, wɔniiti su, toganiiti ɓalaa su, ta aniiti kpein ti ɓokposu zooi ma, ga ti pɛ ti yɛnvui makɛ. ");
INSERT INTO tod_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ɗa daamianigiti kpein seɠe, è makɛ ɠoba, naa ɠa a kɛ é ɠɛ ga daamianigi è ʋɛ ta tiya ɓalaa bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Naa ɠa Nowe kɛɛni. É naati kpein kɛɛni, nii GALA ge ma levei veeni zea. ");
INSERT INTO tod_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ɠɔoɠɔ GALAGI ɠɛni Nowe ma: «Lɛ keingi zu, ɗa-o, ɗa-ʋɛlɛyeɠei-yo, mazɔlɔɔ gè è ʋɛtɛgɛ ga telebo nu niima yeeɠɛɠalai zu nuɓusɛiti saama. ");
INSERT INTO tod_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Suai niiti ti ɲadegai, ɗa ma zii ɠilagilagi zeɠe, ma zinɛ lɔfela, ta ma zaa lɔfela, kɛlɛ suai niiti ti ɠɔzɔai, ɗa naama zii ɠɛ ga ma zinɛ ta ma zaa nɔ. ");
INSERT INTO tod_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Wɔniiti ɓalaa, ɗa ma zii ɠilagilagi zeɠe, ma zinɛ lɔfela, ta ma zaa lɔfela, naa ɠa a kɛ è ti-ma zuwui makɛ eteai zu ná pɛ. ");
INSERT INTO tod_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Mazɔlɔɔ é yɛga ga folo lɔfela, gè tonai ʋu eteai zu, folo ʋuunaanigɔ (40) ta kpidi ʋuunaanigɔ (40) laawu, fuluaniiti kpein gè ti ɓɛtɛai, gè ti-ma zuwu ɠaaleʋe zooi ɠa.» ");
INSERT INTO tod_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nowe naa kpein kɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni zea. ");
INSERT INTO tod_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe kona undɔzita (600) zɔlɔɔni niina, siɛgi zu ziɛve golai ʋaani la eteai zu. ");
INSERT INTO tod_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nowe lɛɛni keingi zu ta ná-doun zunuiti, ta anzai, ta ná-doun anzaiti, ga ti ɠizo ziɛve golai ma. ");
INSERT INTO tod_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Suai niiti saama, ti ɲadegai, ta niiti ti ɠɔzɔai, naa ʋɛɛ wɔniiti kpein ba, ta suai niiti kpein ti ɓokposu zooi ma, ");
INSERT INTO tod_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ti kpein ti zeelini Nowe ma keingi ʋɔ bɛ ga felefelegi, ma zinɛ ɠila ta ma zaa ɠila, eɠɛʋelei GALA ge ma levei veeni la Nowe ya. ");
INSERT INTO tod_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Folo lɔfela ʋoluma, ziɛve golai eteai maaɓɔleni. ");
INSERT INTO tod_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowe zii ma ɠona undɔzitai (600) ma alu felesiɛi ma volo puugɔ maazu lɔfelasiɛi (17) ma, naama voloi zooi wu ɗɛ wolaiti ma ɗɛungiti kpein daaleʋeni, ta geeɠɔlɔgi ma ʋɛlɛlaʋɛti ɓalaa daalaoni. ");
INSERT INTO tod_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tonai tɔɔzeini ga ʋua eteai zu, eyɛsu folo ʋuunaanigɔ (40) ta kpidi ʋuunaanigɔ (40). ");
INSERT INTO tod_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Naama voloi ɓɔɠɔi nɔ ɠa Noweni ti lɛɛni la keingi zu, tɔun be, Sɛme ʋe, Same ʋe, ta Zafɛte, é ɓɔ anzai ʋa ta ná-doun anza saʋagɔiti, ");
INSERT INTO tod_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","naa ʋɛɛ dɔɓɔ zuai ma zii kpein ba, ta toganiiti, ta aniiti kpein ti ɓokposu zooi ma, é ɓɔ wɔniiti kpein ba, ta koʋe ganiiti kpein. ");
INSERT INTO tod_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Anii vului ma ziiti kpein, ma zinɛ ma zaa, ti ʋaani ga felefelegi Nowe ʋɔ bɛ, ga ti lɛ keingi zu. ");
INSERT INTO tod_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ti ɠilagilagi lɛɛni ma zinɛ ma zaa, ti ma ziiti kɛʋelei, eɠɛʋelei GALA ge ma levei veeni la Nowe ya. Naa ʋolu Ɠɔoɠɔ GALAGI daaɠuluni ma. ");
INSERT INTO tod_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ziɛve golai yɛni lɛɛzu, é kɛ ga folo ʋuunaanigɔ (40) eteai zu. Ziɛi veni, é keingi wuzeɠe zooi maazu. ");
INSERT INTO tod_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ziɛi veni, é wola lɛ su eteai zu. Keingi ɠɛni ziɛzu ziɛi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ziɛi ɠɛni lɛɛzu su nɔ, eyɛsu é gize ɠaaɠoozagiti pɛ maaɓɔle geeɠɔlɔgi wu eteai zu ná pɛ. ");
INSERT INTO tod_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ziɛi lɛɛni gizeiti maazu ga mɛtɛlɛ lɔfela ɠɛɠala, ti pɛ maalɔɔɠuni. ");
INSERT INTO tod_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nii kpein é ɠɛni ga fuluanii eteai zu, ti pɛ ti zaani, wɔniiti, toganiiti, dɔɓɔ zuaiti, nii kpein é ɠɛni ɓokposu, ta nuɓusɛi kpein. ");
INSERT INTO tod_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nii kpein é ɠɛni yɛnvuzu zou vɔɔi ma, naa pɛ ge zaani. ");
INSERT INTO tod_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","GALA ge fuluanii kpein suwuɠaaleʋeni zooi ɠa: nuɓusɛi ta suaiti, naa ʋɛɛ kpokpo ganiiti ta wɔniiti ba. Nowe nɔ ɠa é yɛni ná, ta niiti ti ɠɛni ba keingi zu. ");
INSERT INTO tod_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ziɛvegi yɛni eteai zu eyɛsu folo ungila folo ʋuulɔɔlugɔ (150). ");
INSERT INTO tod_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","GALA ge ɠizɛni Nowe zu, ta dɔɓɔ zuaiti pɛ, ta toganiiti ti ɠɛni ba keingi zu. GALA ge fiilɛi leʋeni eteai zu, ziɛvegi tɔɔzeini ga maa ɗa yei. ");
INSERT INTO tod_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Zooi wu ɗɛungiti ta geeɠɔlɔgi ma ʋɛlɛlaʋɛti daaɠuluni, tonai teʋe. ");
INSERT INTO tod_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Ziɛi maa ɠɛni yeizu vaa, é ɗa zeɠe zooi ma, maalɔini folo ungila folo ʋuulɔɔlugɔ (150) laawu. ");
INSERT INTO tod_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Alu dɔfelasiɛi ma volo puugɔ maazu lɔfelasiɛi (17) ma, keingi loni gizei ma, nii daaseigi ga Alalate. ");
INSERT INTO tod_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ziɛi ɠɛni ba maa ɗa yei, eyɛsu alugi ʋuusiɛi. Naama alugi ma volo mɔungi, gizeiti tɔungiti ti ɠulani kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Folo ʋuunaanigɔ (40) leʋegai ma, Nowe fenɛtɛlɛi laalaoni, nii é kpɛtɛni keingi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","É kalawɔnii ʋilɛni, naa ɠula, é ɗa li, é ɗa ɠaaɠale ma, ná zeizu ɠɛ mɔinmɔin. É ná maaɓɔunni, eyɛsu ziɛi vɔ zooi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Naa ʋolu é poopogi ɓalaa ʋilɛ, ga é pɛtɛ, ni ziɛi maayeiɗa zooi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kɛlɛ poopogi la ɠɛni zeizu zɔlɔɔni, é ɠaleni ma pɔ bɛ keingi zu, mazɔlɔɔ ziɛi ɠɛni zooi ma ná pɛ. Nowe yeeɠulani, é so, é tɛ ɓɔɠɔ ma keingi zu. ");
INSERT INTO tod_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","É folo lɔfela ɠiligaa maaɓɔunni mɔnɔ, naa ʋolu é yeeɓeni poopogi ʋa, é ɠula keingi zu. ");
INSERT INTO tod_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kpɔkɔmaʋɛ, poopogi ɠaleni ma, é ʋa pɔ bɛ. Pɛtɛ, wolive wului ɠaalaagi gila ge ɠɛni dakulugi ɠa. Nowe kwɛɛni naazu ga ziɛi maalɔiɗa ɠɛni de niina zooi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","É folo lɔfela ɠiligaa maaɓɔunni mɔnɔ, naa ʋolu é poopogi ʋilɛni. Kɛlɛ naa la mɔ ɠɛni ɠaleni ma ʋolu pɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nowe zii ma ɠona undɔzita maazu ɠilagi (601) ma alu mɔungi ma volo mɔungi, ziɛi vɔɔni zooi ɠa. Nowe keingi lakulugi zeɠeni da. É wɛlɛni, é ka ga zooi ɠaaʋɛ vɔɔni niina. ");
INSERT INTO tod_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Alugi velesiɛi ma volo ʋuufelegɔ maazu lɔfelasiɛi (27) ma, zooi vɔɔni niina kpaankpaan. ");
INSERT INTO tod_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","GALA ge ɓɔɛni Nowe ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Ɠula keingi zu, wa è-anzai, wa è-loun zunuiti, ta è-loun anzaiti. ");
INSERT INTO tod_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fuluanii ma zii kpein kula, niiti ti è ɠoba: wɔniiti, suaiti, ta kpokpo ganiiti, ti vaza eteai zu, ti ɓuɠu, ti mɔin ná.» ");
INSERT INTO tod_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Nowe ɠulani keingi zu, ta ná-doun zunuiti, ta anzai, ta ná-doun anzaiti. ");
INSERT INTO tod_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Suai ma zii ɠilagilagi kpein ge ɠulani keingi zu, ani niiti ti ɓokposu, wɔniiti ta nii kpein é vulua eteai zu. ");
INSERT INTO tod_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nowe zalaɠa ɠulazuʋɛ ɓɛtɛni Ɠɔoɠɔ GALAGI ʋɛ. É ta zeɠeni suaiti su, niiti ti ɲadegai, ta wɔniiti su, niiti ti ɲadegai, é ti ɠɛ ga gala zalaɠai, zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ɠɔoɠɔ GALAGI zalaɠai naama maku nɛɛnɛgi mɛnigai ma, é boni yiimaʋɛ, é ɠɛ ma: «Gè la mɔ eteai ɠotoa nui maaʋele ma, anɛɛ ɓalaa nui yiimaʋɛ ma ɠisiɛiti togɛ faa ɲɔi ʋa, é lɔɔzei ma loungo ziɛgi zu ma. Gè la mɔ fuluanii kpein koloɠologa, eɠɛʋelei gè kɛai la. ");
INSERT INTO tod_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ni nɔ eteai ɠa dɛ ná, anii vaza fai ta teʋe vai, diegi ta kɔɔlɛi, foɠoi ta samai, foloi ta kpidii, naati ti la ɓega ɲɛgɛlɛin.» ");
INSERT INTO tod_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","GALA ge tuya looni Nowe ʋɛ ta ná-doun zunuiti, é ɠɛni ti ma: «À ɓuɠu, wo mɔin, wo eteai laave. ");
INSERT INTO tod_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Fuluaniiti kpein ta lua wo ʋa, ti zasu ɗa ɓali, é zo suaiti ma ti eteai zu, é li wɔniiti pɔ, ta kpokpo ganiiti, ta kaleiti: Ti pɛ feeʋɛ wo ya. ");
INSERT INTO tod_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Gè fuluaniiti kpein fea wo ʋɛ ga daamianigi. Eɠɛʋelei gè tufa lɛnugi veai la wo ʋɛ, gè ti pɛ fea wo ʋɛ ɠana. ");
INSERT INTO tod_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Anɛɛ naa ʋe, à mina suai mi, ma ɲamai ʋa yɛ su, naa ɠa é ga zɛnvui. ");
INSERT INTO tod_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","À suɠwɛɛ ɓalaa ga wo-ma ɲamai ɠa é ga wo-yɛnvui, nà maaɠaazaɠabo. Nà maaɠaazaɠabo naa ma, nii nɔpɛ a nu ɲamai ʋu, é ɠɛni ga suai, ɓaa é ɠɛni ga nui. Nà nui ɠilagilagi ɠaazaɠa kɛɛɠɛloin ma ɲamai ma. ");
INSERT INTO tod_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Zɔi a nu ɲama ʋu, tɔ ɓalaa nu ɠili ka ma ɲamai ʋu, mazɔlɔɔ GALA ge nui ɓɛtɛʋɛ ga maaniinigi ɠɛʋele. ");
INSERT INTO tod_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Wɔun wa, à ɓuɠu, wo mɔin eteai zu.» ");
INSERT INTO tod_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","GALA ge ɓɔɛni Nowe ʋɔ ta ná-doun zunuiti, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Wɛlɛ, gè minazeɠea wo ʋɛ, wa wo-mavofodai, ");
INSERT INTO tod_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","naa ʋɛɛ nii kpein ba é vulua wo ɠoba, wɔniiti, toganiiti, ta dɔɓɔ zuaiti, wa niiti kpein wo ɠulaai keingi zu ʋɔɔma, ti ʋaazu yɛnvuzu eteai zu. ");
INSERT INTO tod_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Gè minazeɠea wo ʋɛ ga: Fuluanii pɛ undaa la mɔ ʋiliga ga ziɛve golai, ziɛve gola la mɔ ɠɛa ná, é ʋa eteai ɠoloɠolo.» ");
INSERT INTO tod_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","GALA ge ɠɛni ma mɔnɔ: «Nii ɠa é ga minazeɠegi ma ʋoogi eyɛsu ɠɔ, gè kɛɛzu ade yɔɠɔzu, nà-o, wa-o, ta anii kpein ti yɛnvuzu wo ɠoba. ");
INSERT INTO tod_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Gè nà-kpazamanamanagi zeiɗa tonaɓiingi zu, toɠa ɠɛ ga minazeɠegi ma ʋoogi gi yɔɠɔzu gá eteai. ");
INSERT INTO tod_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Siɛgi zu gè tonaɓiingiti gaalɛɛzu ba la, é zɛlɛ zooi maazu, kpazamanamanagi a ɠulana kɛlɛma tonaɓiingi zu, ");
INSERT INTO tod_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","nà ɠizɛ nà-minazeɠegi zu, é ade yɔɠɔzu, nà-o, wa-o, ta nii kpein é vulua. Ziɛi la mɔ vega, é ʋa fuluanii kpein koloɠolo. ");
INSERT INTO tod_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kpazamanamanagi ɠa ɠɛ tonaɓiingi zu, nà wɛlɛna ba, nà ɠizɛ ɠɔoɠɔ minazeɠegi zu, nii é gi yɔɠɔzu gá fuluaniiti kpein ti eteai zu.» ");
INSERT INTO tod_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","GALA ge ɠɛni Nowe ma mɔnɔ: «Naa ɠa é ga minazeɠegi ma ʋoogi, nii gè kɛa gi yɔɠɔzu gá fuluaniiti kpein ti eteai zu.» ");
INSERT INTO tod_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nowe ná-doun zunuiti ti ɠulani keingi zu, ti ɠɛni ga niiti: Sɛme, Same, ta Zafɛte. Kanaan kɛɛɠɛ ɠɛni ga Same. ");
INSERT INTO tod_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Naati ka ti ga Nowe ná-doun zunu saʋagɔiti, ti-mavofodai ɠa é eteai laavegai. ");
INSERT INTO tod_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowe ɠɛni ga tii ɠɛɛ nu mɔungi, nii é leezɛn ɓelei leʋeni. ");
INSERT INTO tod_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","É ma lɔɔi ɓɔleni, naa so, é la ga ɠabei ná-seɠe ɠotai wu. ");
INSERT INTO tod_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Same, nii é ga Kanaan kɛɛɠɛ, naa kɛɛɠɛ ɠabei ɠaani, é liini eteaʋɛ, é bo diɛni felegɔ ma. ");
INSERT INTO tod_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sɛme ta Zafɛte ti tookɔba wolai zeɠeni, ti pɛɛ ɠɔma, ti ziɛ ga ʋoluʋelei, ti pɛɛ ti-ɠɛɛ ma, kabei maalɔɔɠu. Tɛi ti ʋoluavega ɠɛni de, ti la ɠɛni ti-ɠɛɛ ɠabei ɠaani ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Siɛgi zu Nowe wuunni da, é ɠula ná-dɔɔzodai zu, é naa mɛnini, nii ná-doun zunu ɠaaɓelagi kɛɛni la, ");
INSERT INTO tod_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","é zɛba é ɠɛ ma: «Kanaan ɠotoʋɛ! Toɠa ɠɛ ga kɛɛɠɛleaiti ta-luɔiti tɔnɔ ma luɔi!» ");
INSERT INTO tod_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Naa ʋolu é ɠɛni ma: «Mamagi ɠa Ɠɔoɠɔ GALAGI ʋɛ, Sɛme ná-GALAGI, Kanaan ɠa ɠɛ ga Sɛme ná-duɔi! ");
INSERT INTO tod_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","GALA ge Zafɛte zeizuʋɛ maawɔɔlɔ, é zei Sɛme ná-seɠe ɠotaiti bu, Kanaan ɠa ɠɛ ga ná-duɔi!» ");
INSERT INTO tod_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ziɛve golai ʋoluma, Nowe kɛɛni ga kona unsaʋagɔ puulɔɔlugɔ (350). ");
INSERT INTO tod_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nowe zii ma voloi kpein ge ɠɛni ga kona untaaʋuugɔ puulɔɔlugɔ (950), naa ʋolu é zaani. ");
INSERT INTO tod_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ziɛve golai leʋega ʋoluma, Nowe ná-doun zunuiti, Sɛme, Same ta Zafɛte, ti dointi sɔlɔɔni. Ti-mavofodaiti daaseigiti ti ɠɛni ga: ");
INSERT INTO tod_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Zafɛte mavofodaiti ti ɠɛni ga: Gomɛɛl, Magɔge, Madayi, Yavan, Tuɓale, Mesɛke, ta Tilase. ");
INSERT INTO tod_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomɛɛl mavofodaiti ti ɠɛni ga: Asakenaze, Lifate, ta Togaalema. ");
INSERT INTO tod_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan mavofodaiti ti ɠɛni ga: Elisa, Taalasise, Kitime, ta Dodanime. ");
INSERT INTO tod_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ti-mavofodaiti kaa, ti zeini ziɛ zaama yooiti su, ta kpoloɗɛi laaʋɛ yooiti. Ti vazagɛ zooiti su, eɠɛʋelei ta-ʋɛlɛyeɠeiti, ta ti-laawooiti ta ti-ma ziiti ti la. ");
INSERT INTO tod_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Same mavofodaiti ti ɠɛni ga: Kuse, Miselayime, Pute, ta Kanaan. ");
INSERT INTO tod_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuse mavofodaiti ti ɠɛni ga: Seɓa, Ɠavila, Saɓata, Layema, ta Saɓeteka. Layema mavofodaiti ti ɠɛni ga: Saɓa ta Dedan. ");
INSERT INTO tod_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuse Nimelɔde zɔlɔɔni, naa ɠa é ɠɛɛni ga zɛbɛsu nu wola mɔungi zooi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","É ɠɛni ga doso wola Ɠɔoɠɔ GALAGI ɠaazu, naa ɠa é ba, a ɗa wo da ga: «Doso wolai Ɠɔoɠɔ GALAGI ɠaazu, eɠɛ Nimelɔde.» ");
INSERT INTO tod_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ná-masadai ma laa wola mɔungiti ti ɠɛni ga Ɓaɓɛleni ta Elɛke, naa ʋɛɛ Akade ʋa, ta Kalené, niiti ti Sineyaal yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Naama yooi ʋoluma, Nimelɔde liini Asiili yooi zu, é Ninive laa wolai lo, ta Leɠoɓɔte-Iil, ta Kala, ");
INSERT INTO tod_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","naa ʋɛɛ Lesɛn ʋa, nii é Ninive ta taa wolai Kala ti yɔɠɔzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Miselayime mavofodaiti ti ɠɛni ga: Lude nuiti, Aname nuiti, Leɠaɓe nuiti, Nafatu nuiti, ");
INSERT INTO tod_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patɔlɔse nuiti, Kasulu nuiti, ta Kafatɔɔl nuiti. (Kasulu nui naati ka Filisiti nuiti kulaai ti zu). ");
INSERT INTO tod_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan ná-doun zunu mɔungi é sɔlɔɔni, naa ɠa é ɠɛni ga Sidɔn, naa ʋolu gelei ɠɛ ga Ɠɛte. ");
INSERT INTO tod_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan mavofodaiti ti ɠɛni ga: Yeɓuse nuiti, Amool nuiti, Giilegase nuiti, ");
INSERT INTO tod_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ɠeve nuiti, Aaleke nuiti, Sine nuiti, ");
INSERT INTO tod_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Aalevade nuiti, Semaal nuiti, ta Ɠamate nuiti. Naa ʋoluma Kanaan nuiti ta-ʋɛlɛyeɠeiti ti vazani. ");
INSERT INTO tod_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaan nuiti ta-you ɠwɛgi liini eyɛsu Sidɔn, Gelaal letema ʋelei, eyɛsu é zeeli Gaza, ta Sɔdɔme ʋele, é ʋɛɛ Gomɔɔl ʋele ʋa, é li Adema ta Seɓoyime, eyɛsu é gaaɓela Lesa yooi ma. ");
INSERT INTO tod_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Same mavofodaiti kana, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, ta ti-laawooiti, ta ti-ma ziiti ta-yooiti su. ");
INSERT INTO tod_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sɛme doun zunuiti ɓalaa sɔlɔɔni, tɔ ɠa é ɠɛni ga Eɓɛɛl lointi kpein ti-mɛmɛwolai, Zafɛte nɔnɔ liɛi. ");
INSERT INTO tod_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sɛme mavofodaiti ti ɠɛni ga: Elame, Asuul, Aalapakasade, Lude, ta Alame. ");
INSERT INTO tod_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alame mavofodaiti ti ɠɛni ga: Use, Ɠule, Getɛɛl, ta Mase. ");
INSERT INTO tod_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aalapakasade Sela zɔlɔɔni, ta Sela Eɓɛɛl zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eɓɛɛl zunu loun felegɔ zɔlɔɔni: Gilagi laaseigi ɠɛni ga Pelɛge, tɔɔzei ná-siɛgi zu ɠa zooi ɠa nuɓusɛiti zeeɠaaɠwɛɛni la, ta kɛɛɠɛloin laaseigi ɠɛni ga Yoketan. ");
INSERT INTO tod_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoketan mavofodaiti ti ɠɛni ga: Alamodade, Selɛfe, Ɠasaalemavɛte, Yela, ");
INSERT INTO tod_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Ɠadolame, Uzale, Dikila, ");
INSERT INTO tod_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Woɓale, Aɓimayɛle, Saɓa, ");
INSERT INTO tod_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Wofiil, Ɠavila, ta Yoɓaɓe. Niima nuiti pɛ ti ɠɛni ga Yoketan mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ti zeini Mesa ta Sefaal ɠize yooi yɔɠɔzu, nii é folo ɠulazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sɛme mavofodaiti kana, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, ta ti-laawooiti, ta ti-ma ziiti ta-yooiti su. ");
INSERT INTO tod_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nowe ná-doun zunuiti ta-ʋɛlɛyeɠeiti kana, eɠɛʋelei ti-mavofodaiti ti la, ti-ma ziiti saama. Tiya ɠa ziiti kpein kulaai ti zu, ti vazagai eteai zu ziɛve golai leʋega ʋoluma. ");
INSERT INTO tod_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Eteai pɛ ge ɠɛni zii woo ɠilagi wosu, ti ɠɛni ɓɔɛzu ga woo ɠilagi. ");
INSERT INTO tod_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ti zeɠeni ga folo ɠulazu ʋelei, ti nɛmɛ wola ɠila kaani Sineyaal yooi zu, miná ɠa ti zeini ná. ");
INSERT INTO tod_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ti ɠɛni ɓɔɠɔ ma: «Ade li, ade ɓilikiiti doɠa, ade ti ɠala abui zu.» Ɓilikii ɠɛni ti ʋɛ ga pɛlɛ lo kɔtui, ti ɗa sei ga managi. ");
INSERT INTO tod_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ti ɠɛni ɓɔɠɔ ma mɔnɔ: «Ade li, de taai ta lo ɓɔɠɔ ʋɛ, ta pɛlɛ ɠaaɠoozagi nii nɔungi a zei geei ʋa. Ade ɓɔɠɔ lɔɠɔɠula, naa ɠa a kɛ ade mina vaza zooi ɠa ná pɛ.» ");
INSERT INTO tod_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ɠɔoɠɔ GALAGI yeini taai ʋɛtɛsu ta pɛlɛ ɠaaɠoozagi, nii nuiti ti ɠɛni tosu. ");
INSERT INTO tod_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ɠɔoɠɔ GALAGI ɠɛni ma: «Wɛlɛ, ta ga zii ɠilagi nɔ, woo ɠilagi nɔ ɠa é ti-la. Ni ta tɔɔzeina ɠani, ani nɔpɛ ge la mɔ pele ɓesaga ti luɠɔ naa ɠɛɛ vai zu, nii a ɠɛ ti ɠisu. ");
INSERT INTO tod_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ade yei, de li, de ti-laawooi zupu, naa ɠa a kɛ, ti mina ɓɔɠɔ laawooiti mɛni.» ");
INSERT INTO tod_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ɠɔoɠɔ GALAGI ti zuvazani, ti maaɠooza ná ʋa, ti li eteai zu ná pɛ. Ti looɠoni taai lo fai ʋa. ");
INSERT INTO tod_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Naa ɠa é kɛai taai naa laasei pɛai ga Ɓaɓɛle, mazɔlɔɔ miná ɠa Ɠɔoɠɔ GALAGI eteai kpein gooi zupuai ná. Ná ɠa Ɠɔoɠɔ GALAGI ti zuvazani ná, ti li eteai zu ná kpein. ");
INSERT INTO tod_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛme mavofodai ɠaa: Ziɛve golai leʋegai ma, é ɠɛ ga kona felegɔ, Sɛme ná-konagi ɠɛni ga ungila (100), é Aalapakasade zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aalapakasade zɔlɔɔga ʋoluma, Sɛme kona undɔɔlugɔ (500) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Aalapakasade ná-konagi ɠɛai ma ga puusaʋagɔ maazu lɔɔlugɔ (35), é Sela zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Sela zɔlɔɔga ʋoluma, Aalapakasade kona unnaanigɔ kona saʋagɔ (403) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela ná-konagi ɠɛai ma ga puusaʋagɔ (30), é Eɓɛɛl zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eɓɛɛl zɔlɔɔga ʋoluma, Sela kona unnaanigɔ kona saʋagɔ (403) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eɓɛɛl ná-konagi ɠɛai ma ga puusaʋagɔ maazu naanigɔ (34), é Pelɛge zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛge zɔlɔɔga ʋoluma, Eɓɛɛl kona unnaanigɔ puusaʋagɔ (430) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelɛge ná-konagi ɠɛai ma ga puusaʋagɔ (30), é Leyu zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Leyu zɔlɔɔga ʋoluma, Pelɛge kona unfelegɔ kona taaʋuugɔ (209) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leyu ná-konagi ɠɛai ma ga puusaʋagɔ maazu felegɔ (32), é Seluge zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seluge zɔlɔɔga ʋoluma, Leyu kona unfelegɔ kona dɔfela (207) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seluge ná-konagi ɠɛai ma ga puusaʋagɔ (30), é Naɠɔɔl zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naɠɔɔl zɔlɔɔga ʋoluma, Seluge kona unfelegɔ (200) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naɠɔɔl ná-konagi ɠɛai ma ga puufelegɔ maazu taaʋuugɔ (29), é Tela zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tela zɔlɔɔga ʋoluma, Naɠɔɔl kona ungila puugɔ maazu taaʋuugɔ (119) ɠili kɛɛni. É doun zunui ta doun anzanui taɠiligaa zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela ná-konagi ɠɛai ma ga puulɔfela (70), é Abalameni sɔlɔɔni ta Naɠɔɔl ta Ɠalan. ");
INSERT INTO tod_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tela mavofodai ɠaa: Tela Abalameni sɔlɔɔni ta Naɠɔɔl, ta Ɠalan. Ɠalan Lote zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ɠalan zaani kɛɛɠɛ Tela luɠɔ, sɔlɔɔ zooi zu, ʋɛ ná ga Uul, Ɓaɓilɔne yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abalame ta Naɠɔɔl ti anzaiti seini. Abalame anzai laaseigi ɠɛni ga Salayi. Naɠɔɔl anzai laaseigi ɠɛ ga Milika. Milika ta Yisekani ti-ɠɛɛ ɠɛni ga Ɠalan. ");
INSERT INTO tod_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Salayi maaloni, doun la ɠɛni bɛ ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela ná-doun zunui Abalame zeɠeni, ta ná-dounloin Lote, Ɠalan ná-doun zunui, ta ná-doun anzai Salayi, Abalame anzai. Ti ɠulani ʋɔɔma Uul ʋa Ɓaɓilɔne yooi zu, ti li Kanaan yooi zu ʋele. Ti zeelini Ɠalan, ti zei ná. ");
INSERT INTO tod_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela zii ma voloi kpein ge ɠɛni ga kona unfelegɔ kona dɔɔlugɔ (205), naa ʋolu Tela zaani Ɠalan. ");
INSERT INTO tod_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ɠɔoɠɔ GALAGI ɠɛni Abalame ma: «Zeɠe ɗa-yooi zu, ɗa-wolodai zu, è ɠula è-ɠɛɛ ʋɛlɛi wu, li zooi naa zu, ʋɛ gè ná lɛɛzu ga ɗe. ");
INSERT INTO tod_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Nà ʋaazu zii wola ɠulazu è zu, nà tuya loo è ʋɛ, gè è-laaseigi wɔɔlɔ. Nà tuya loo zɔiti bɛ ga è maaʋele. ");
INSERT INTO tod_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nà tuya loo naati bɛ, niiti ta tuya loo è ʋɛ, nà naati foovo, niiti ta è voovo, etea ʋɛlɛyeɠei kpein ka tuyai zɔlɔɔ è maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abalame liini, eɠɛʋelei Ɠɔoɠɔ GALAGI boni ma la, Lote ʋilɛni polu. Abalame ná-konagi ɠɛni ga puulɔfela maazu lɔɔlugɔ (75), siɛgi zu è ɠulani la Ɠalan taai ʋa. ");
INSERT INTO tod_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abalame anzai Salayi zeɠeni ta Lote, nii é ɠɛni ga deɠe loin, é ʋɛɛ zeaɠɔligiti kpein ba, ta botiɠɛ nuiti, é ti zɔlɔɔni Ɠalan. Ti wuzeɠeni, ti li Kanaan yooi zu. Ti zeeliai ma Kanaan yooi zu, ");
INSERT INTO tod_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abalame ná zuɓizɛni, eyɛsu é li adaʋɛ ná laaseigi ga Sikɛme, eyɛsu é zeeli Molé, sɛne gului ʋɔ bɛ. Kanaan nuiti ka ti ɠɛni naama yooi zu názu. ");
INSERT INTO tod_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ɠɔoɠɔ GALAGI ɠulani kɛlɛma Abalame ʋɛ, é ɠɛ ma: «Nà zooi nii veezu è-mavofodai ya.» Abalame zalaɠa ɠulazuʋɛ ɓɛtɛni ná Ɠɔoɠɔ GALAGI ʋɛ, nii é ɠulani bɛ kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Naa ʋolu, é zeɠeni ná, é li ga gize yooi zu ʋelei, Ɓetɛle folo ɠulazu ʋelei. É ná-seɠe ɠotai loni Ɓetɛle folo liizu ʋelei ti yɔɠɔzuʋɛ ta Ayi, nii é folo ɠulazu ʋelei. É zalaɠa ɠulazuʋɛ ɓɛtɛni ná Ɠɔoɠɔ GALAGI ʋɛ, é wooɠula Ɠɔoɠɔ GALAGI ma. ");
INSERT INTO tod_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abalame ɠɛni liizu ɓɛkpɛ ga lɛkpɛmaʋɛ nu yeezazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Pului looni zooi zu, Abalame yeini Ezipete ga é lago zei ná, mazɔlɔɔ pului wola wɔɔlɔni zooi zu. ");
INSERT INTO tod_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Siɛgi zu é ɠɛni ʋaazu maaɓuɠazu la Ezipete ʋa, é ɠɛni anzai Salayi ma: «Wɛlɛ, gè kwɛɛ ga ɗa ga anzanui nii pagai. ");
INSERT INTO tod_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Siɛgi zu Ezipete nuiti ti è ɠaazu la, ta ɠɛ ma: ‹Anzai ʋe!› Ta pàa, ti è yɛ vulua. ");
INSERT INTO tod_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ɗa ɠɛ ti ma mu, ɗa ga bàazeelai, naa ɠa a kɛ ti sò ga pagɔ è maaʋele ma, zɛ̀nvui yɛ zèa è-zaalai zu.» ");
INSERT INTO tod_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Siɛgi zu Abalame zeelini la Ezipete yooi zu, Ezipete nuiti ti kaani ga anzai wola ʋagɛ. ");
INSERT INTO tod_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Falaɠɔn ná-nu wolaiti ti kaai ma, ti maamusɛni Falaɠɔn ɠaazu. Ti liini ga anzanui masagi ná-pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","É Abalame zoni ga pagɔ anzanui maaʋele ma. Abalame togani goiti ta togani wolaiti sɔlɔɔni, naa ʋɛɛ soovalegiti ba, ta botiɠɛ zunuiti ta botiɠɛ anzanuiti, ta soovale saaiti ta ɲɔmɛiti. ");
INSERT INTO tod_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kɛlɛ Ɠɔoɠɔ GALAGI maanɔɠɔ vaa wolaiti pɛɛni Falaɠɔn ta ná-pɛlɛyeɠei ʋa, Salayi maaʋele ma, nii é ga Abalame anzai. ");
INSERT INTO tod_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Falaɠɔn zɛba é Abalame loli, é ɠɛ ma: «Leeni ɠa è kɛai ga ze? Lee vaa zu è la boni mà ga è-anzai ʋe? ");
INSERT INTO tod_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lee vaa zu è ɠɛai mà: ‹Bàazeelai ʋe›? Naa ɠa é kɛai gè seɠeai ga ànza. È-anzai ɠaa niina, seɠena, è li!» ");
INSERT INTO tod_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Falaɠɔn devei veeni ná-nuiti zea ga ti zɛ ná, é li, ta anzai, é ʋɛɛ naati kpein ba, ti ɠɛni ga nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abalame zeɠeni Ezipete yooi zu, é lɛ ʋolu Kanaan yooi zu, lɛkpɛmaʋɛ nu yeezazuʋɛ, tɔun be-o, anzai ʋe-o, ta niiti kpein ti ɠɛni ga nɔnɔ. Lote ɠɛni ba. ");
INSERT INTO tod_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abalame wola ɓɛtɛni, toganiiti su, ta walii, ta zanugi. ");
INSERT INTO tod_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","É yɛni lɛɛzu ɓɛkpɛ, é zo lɛkpɛmaʋɛ nu yeezazuʋɛ yooi zu, eyɛsu é li Ɓetɛle, ʋɛ ná-seɠe ɠotai ɠɛni ná mɔunpa, Ɓetɛle ta Ayi ti yɔɠɔzuʋɛ, ");
INSERT INTO tod_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ʋɛ é zalaɠa ɠulazuʋɛ loni ná mɔunpa. Miná ɠa Abalame wooɠulani ná, Ɠɔoɠɔ GALAGI ma. ");
INSERT INTO tod_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lote, nii é ɠɛni Abalame maazaasu, baalagiti ti ɠɛni zea ɓalaa, naa ʋɛɛ boliiti ba, ta nikɛiti, ta seɠe ɠotaiti, ");
INSERT INTO tod_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","zooi la ɠɛni kula ɠɛa ti ʋa, ga ti ʋa zei ada ɠila, mazɔlɔɔ ti-yeaɠɔligiti ti wola mɔinni gola, ti la ɓena zoo ti ʋa zei ada ɠila. ");
INSERT INTO tod_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Naa ʋolu ɓalaa, Kanaan nuiti ta Felɛze nuiti ti ɠɛni zeini ma yooi zu naama ziɛgi zu. Kpɔɛi leʋeni Abalame ná-togani makɛ nuiti zɔɠɔzu ta Lote ná-togani makɛ nuiti. ");
INSERT INTO tod_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abalame ɠɛni Lote ma: «Nà è maanɛɛnɛzu, maaɠaali mina ɠɛ de yɔɠɔzu da ɗe, ɓaa nà-togani makɛ nuiti ta ɗɔnɔiti zɔɠɔzu. Mazɔlɔɔ da ga kɛɛɠɛlointi. ");
INSERT INTO tod_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Zooi kpein ka è ɠakala. De ɠaaɠwɛɛna ma mu, ni ɗa liina ga nu ɠɔʋɛzu ʋelei, nà li ga nu yeezazu ʋelei, ni ɗa liina ga nu yeezazu ʋelei, nà li ga nu ɠɔʋɛzu ʋelei.» ");
INSERT INTO tod_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lote ɠaazuwuzeɠeni, é wɛlɛ, é Zuludɛn nɛmɛ wolai ɠa, nii zɛɓɛa ɠɛni de ɲɛgɛlɛin. Ɠɔoɠɔ GALAGI ɠɛɛzu é ʋa Sɔdɔme ta Gomɔɔl ɠoloɠolo, ná ɠɛni eɠɛ Ɠɔoɠɔ GALAGI ná-kpelei, eyɛsu é zeeli Sowaal, kulaai ga Ezipete yooi ɠɛʋele. ");
INSERT INTO tod_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lote yiimazeɠeni ga Zuludɛn ma nɛmɛ wolai kpein, é liini ga folo ɠulazu ʋelei. Ʋele ɠana ti felegɔ ti ɠaaɠwɛɛni ma la. ");
INSERT INTO tod_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abalame zeini Kanaan yooi zu, Lote zei nɛmɛ zu laaiti su, é ná-seɠe ɠotaiti toni Sɔdɔme letema ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sɔdɔme nuiti ti wola zuɲɔuni, ti ɠɛni ga kotoba nu wolaiti Ɠɔoɠɔ GALAGI laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ɠɔoɠɔ GALAGI ɓɔɛni Abalame ʋɔ, Lote zeɠea ʋoluma polu, é ɠɛ ma: «Adaʋɛ è ná loni, ɠaazuwuzeɠe, è wɛlɛ, nu ɠɔʋɛzu ʋelei ta nu yeezazu ʋelei, folo ɠulazu ʋelei ta folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Mazɔlɔɔ, zooi nii kpein è pɛtɛsu, nà ʋaazu feezu è ʋɛ, wa è-mavofodai, eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nà è-mavofodai ɠɛ eɠɛ zooi ma vufiligi, nii nu la zooga é ʋa gaalu, eɠɛ pelegi nu la zooga la é ʋa zooi ma vufiligi ɠaalu. ");
INSERT INTO tod_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Wuzeɠena ʋɛ, è zooi zuɓizɛ, è ziɛ sakpai ta kogi ma, mazɔlɔɔ nà ʋaazu feezu è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abalame ná-seɠe ɠotaiti seɠeni, é li, é zei Mamelé ná-sɛne guluiti bu, Eɓelɔn ɠobaʋɛ. É zalaɠa ɠulazuʋɛ loni ná Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Naama ziɛgi zu, Sineyaal masagi Amalafɛle, ta Elazaal masagi Aliyɔke, ta Elame masagi Kedɔɔl-Lawomɛɛl, ta Gɔyime masagi Tideyale, ");
INSERT INTO tod_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","yeeta naati ti kɔɔi ʋɛɛni Sɔdɔme masagi Ɓela ʋa ta Gomɔɔl masagi Ɓiilisa, ta Adema masagi Sineyaɓe, ta Seɓoyime masagi Semeyebɛɛl, ta Ɓela masagi (taai naa laa ɠa ga ɓalaa Sowaal). ");
INSERT INTO tod_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Naati kpein ti ɠaalɛɛni ba Sidime nɛmɛ wolai zu, nii maaɓɔlegai za ga Kpoloɗɛ Wanai. ");
INSERT INTO tod_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kona puugɔ maazu felegɔ (12) laawu, ti ɠoloa ɠɛni de Kedɔɔl-Lawomɛɛl ʋɛ, kɛlɛ kona puugɔ maazu zaʋasiɛi (13) ma, ti ɓakani. ");
INSERT INTO tod_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kona puugɔ maazu naanisiɛi (14) ma, Kedɔɔl-Lawomɛɛl ta masagiti ti ɠɛni polu, ti ʋaani, ti zobo sɔlɔɔ Lefa mavofodaiti ma Asatelɔte-Kaalenayime, ta Zuze mavofodaiti ti Ɠame, ta Eme mavofodaiti ti Savé-Kiliyatayime, ");
INSERT INTO tod_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ta Woli nuiti ti ta-ɠizeiti su Seyiil, eyɛsu é zeeli Palan sɛne guluiti pɔ bɛ, nii é teʋebai ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Naa ʋolu, ti ɠaleni ma, ti li En-Misepate, nii é ga Kadɛse, ti zobo sɔlɔɔni Amalɛke nuiti ma, ta-yooi ná pɛ su, é ʋɛɛ Amool nuiti ba, ti ɠɛni zeini Ɠasason-Tamaal. ");
INSERT INTO tod_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Názuʋɛ ɠa Sɔdɔme masagi, ta Gomɔɔl masagi, ta Adema masagi, ta Seɓoyime masagi, ta Ɓela masagi nii é ga Sowaal, naati ti kɔɔi ɠɛʋele ɓɛtɛni la ti laalɔɠɔma Sidime nɛmɛ wolai zu. ");
INSERT INTO tod_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elame masagi Kedɔɔl-Lawomɛɛl, ta Gɔyime masagi Tideyale, ta Sineyaal masagi Amalafɛle, ta Elazaal masagi Aliyɔke, ti ɠɛni ga masa naanigɔ, dɔɔlugɔi laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mana zeɠei wola mɔinni Sidime nɛmɛi zu, Sɔdɔme masagi ta Gomɔɔl ʋele geleiti ti ɠɛni ʋelazu, ti ɗa li, ti ɗa loo zeɠei naati su. Mɔtaiti ti ʋelani, ti li gizei ma. ");
INSERT INTO tod_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Niiti ti zobogi zɔlɔɔni, naati ka ti Sɔdɔme ta Gomɔɔl naavoloiti kpein seɠeni, ta daamiani makɛgaiti, naa ʋolu ti li. ");
INSERT INTO tod_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ti Abalame deɠe loin Lote ta kɔligiti soni, ti li ga tiye, mazɔlɔɔ Lote ɠɛni zeini Sɔdɔme. ");
INSERT INTO tod_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pela nu ɠila ge ʋaani, é daazeeli Eɓulu nui Abalame ma, nii é ɠɛni zeini Amool nui Mamelé ná-sɛne guluiti saama. Mamelé ɠɛni ga Esekɔleni ta Anɛɛl ti-ɠɛɛloin, niiti ti minazeɠeni Abalame ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abalame mɛnigai ma ga deɠe loin zogɛ, é ná-botiɠɛ nu unsaʋagɔ nu puugɔ maazu lɔsaʋa (318) maaɠilini, niiti ti zuzeeliai kɔɔɠɔ vai ma, ti zɔlɔɔgai ná-pɛlɛi wu, naati ti ʋilɛni masagiti polu, eyɛsu ti zeeli Dan. ");
INSERT INTO tod_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","É ná-botiɠɛ nuiti balini su, é sili nuiti so kpidii. É zobo sɔlɔɔni ti ma, é yɛ ti ʋolu, ti zeeli Woɓa, nii é Damase ɠɔʋɛzu ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","É ɠaleni ma ga kɔɔzoganiiti kpein. É ɠaleni ma ɓalaa ga deɠe loin Lote, ta zeaɠɔligiti, ta anzanuiti ɓalaa, ta kɔɔ luɔiti. ");
INSERT INTO tod_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Naa ʋoluma, Abalame ɠaleni ma, é zobogi zɔlɔɔgai ma Kedɔɔl-Lawomɛɛl ma, ta masagiti ti ɠɛni polu. Sɔdɔme masagi ɠulani, é daaɠomi Savé nɛmɛi zu, nii é ga Masa Nɛmɛi. ");
INSERT INTO tod_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mɛlekizedɛke, Salɛme masagi ʋaani ga ɓului ta dɔɔi. É ɠɛni ga GALA nii é Anii-Pɛ-Unda, naa ná-zalaɠa ɠula nui. ");
INSERT INTO tod_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","É tuya looni Abalame ʋɛ, é ɠɛ ma: «GALA ge tuya loo Abalame ʋɛ, GALAGI nii é Anii-Pɛ-Unda, é geeɠɔlɔgi ta zooi ɓɛtɛai! ");
INSERT INTO tod_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Mamagi ɠa GALA bɛ, nii é Anii-Pɛ-Unda, nii é vaa bu, è zobogi zɔlɔɔ è zili nuiti ma!» Abalame kɔɔzoganiiti pɛ ma ʋuusiɛi veeni zea. ");
INSERT INTO tod_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sɔdɔme masagi ɠɛni Abalame ma: «Nuiti fe zèa, è naavoloiti ta sɔɔlaiti seɠe ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abalame ɠɛni Sɔdɔme masagi ma: «Gè ɠonaa Ɠɔoɠɔ GALAGI ma, nii é Anii-Pɛ-Unda, é geeɠɔlɔgi ta zooi ɓɛtɛai, ");
INSERT INTO tod_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","nii dɔin é ga ɗɔnɔi, gè la ani nɔpɛ seɠea naa ʋa, anɛɛ geze ɠaali ɠilagi ɓaa saʋala galu ɠilagi, naa ɠa a kɛ è mina ɠɛ ma: ‹Gè Abalame ɠɛɛʋɛ ga kpɛtɛ nu.› ");
INSERT INTO tod_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Gè la ani nɔpɛ makɛsu nà ɓɔɠɔi bɛ̀, kɛni niigi zunu loungoiti ti miai, ta zunui naati tɔnɔi, niiti gi ɠɛa siɛi zu, Anɛɛl ta Esekɔle ta Mamelé, naati ta tɔnɔ zeɠe.» ");
INSERT INTO tod_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Naama vaiti poluma, Ɠɔoɠɔ GALAGI ɓɔɛni Abalame ʋɔ segi zu, é ɠɛ ma: «Abalame, mina lua ɲɛgɛlɛin, nà ɠa gè ga è makɛ nui, ɗa-ɠulanumai ɠa wɔɔlɔ.» ");
INSERT INTO tod_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abalame gooɠaaʋoteni, é ɠɛ ma: «Màliɠii, Ɠɔoɠɔ GALAGI, lee ɠa è feezu zèa? Tɔɔzei doun la zèa, nà-pɛlɛi wu ʋogani zeɠe nui ɠa é ga Eliyezɛɛl, Damase nui.» ");
INSERT INTO tod_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","É ta laani ma mɔnɔ, é ɠɛ ma: «È la màvofoda ɓɛtɛni, zɔi sɔlɔɔgai nà-pɛlɛi wu, naa ɠa é ɠɛɛzu ga nà-pogani zeɠe nui.» ");
INSERT INTO tod_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ɠɔoɠɔ GALAGI ɓɔɛni pɔ, é ɠɛ ma: «Ɓa-o, naa laade, é ʋa ɠɛ ɠɛɛzu ga ɗa-ʋogani zeɠe nui, kɛlɛ kɛni zɔi é ɠulazu è ɠoozu, naa ɠa a ɠɛ ga ɗa-ʋogani zeɠe nui.» ");
INSERT INTO tod_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Naa ʋolu GALA ge ɠulani la eteaʋɛ ná-seɠe ɠotai ʋoluʋɛ, é ɠɛ ma: «Geeɠɔlɔgi ɠaaʋɛ ʋɛtɛ, è somideɠaiti gaalu, ni ɗa zoo è ti ɠaalu.» É ɠɛni ma mɔnɔ: «Zekana è-mavofodaiti tiegɔi a ɠɛ la.» ");
INSERT INTO tod_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abalame laani Ɠɔoɠɔ GALAGI la, naa naa leveni bɛ ga telebodai. ");
INSERT INTO tod_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","É ɠɛni ma: «Nà ɠa gè ga Ɠɔoɠɔ GALAGI, nii é è ɠula Uul taai ʋa Ɓaɓilɔne yooi zu, gè niima yooi ve è ya ga ɗɔnɔ.» ");
INSERT INTO tod_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abalame gooɠaaʋoteni, é ɠɛ ma: «Màliɠii, Ɠɔoɠɔ GALAGI, nà kwɛɛ ɠale ɠiteɠite ga nà sɔlɔɔsu?» ");
INSERT INTO tod_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","GALA ge ɠɛni ma: «Li, è kona saʋagɔ nikɛ ɓeai zo, ta kona saʋagɔ woli zaai, ta kona saʋagɔ ʋaala sinɛ wolai, è kpɔ kpumagoi ʋa, ta poopogi, è ti ɠula ga zalaɠai.» ");
INSERT INTO tod_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abalame naama zuaiti kpein seɠeni, é ti ʋaliʋali su, é ma zɛʋɛiti gaaʋote ɓɔɠɔ ma, é ɠɛ ga ma ɲɛkpɛ felegɔ, kɛlɛ é la ɠɛni wɔniiti baliʋalini su. ");
INSERT INTO tod_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Sua mii wɔniiti ti ɠɛni ʋuuzu ti-ma ʋoomaiti ma, kɛlɛ Abalame ti ɓɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Foloi liizuʋɛ, ɲiimɛni wolai leʋeni ga Abalame, dualuagi so, kpidi ɓɔii ʋɛɛ ma. ");
INSERT INTO tod_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ɠɔoɠɔ GALAGI ɠɛni Abalame ma: «Suɠwɛɛ ga è-mavofodaiti ta ɠɛ ga seikɔɠɔma nuiti zooi taɠili su, ta ɠɛ ná ga duɔiti, ti ti zopele ɲɔu kona unnaanigɔ (400) laawu. ");
INSERT INTO tod_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kɛlɛ nà zii naa lukpɔɠaaleʋe, nii ta duɔlai ɠɛ zeezu, naa ʋoluma, naavolo wolaiti ta yɛ ti ya, ti ɠula zeezu. ");
INSERT INTO tod_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ɗɔun ɗa, ɗa za ziilɛigi zu, è maa ɠa ɠulu, è wɔlɔzaɠaga ʋoluma, undaanɛɛi zu. ");
INSERT INTO tod_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","È-mavofodai ma yamanii naanisiɛi ɠa ʋa ʋolu ʋɛ, mazɔlɔɔ Amool nuiti ta-vaaɠaaza golai laa la dɛ zeelini.» ");
INSERT INTO tod_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Siɛgi zu foloi liini la, kpidi ɓɔii ʋɛɛni, diɠii nii é duului ɠulazu, ta sɔmɔgi é zosu, naati ti leʋeni sua ɠaaɠwɛaiti zɔɠɔzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Naama yee ná, Ɠɔoɠɔ GALAGI minazeɠeni Abalame ʋɛ, é ɠɛ ma: «Gè niima yooi kpein fea è-mavofodai ʋɛ, é zo Ezipete ɗɛ wolai ma, é zeeli ziɛ wolai Efelate ma, ");
INSERT INTO tod_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ken nuiti ta-yooi, Kenize nuiti, Kademɔn nuiti, ");
INSERT INTO tod_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Ɠɛte nuiti, Felɛze nuiti, Lefa mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amool nuiti, Kanaan nuiti, Giilegase nuiti, ta Yeɓuse nuiti.» ");
INSERT INTO tod_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abalame anzai Salayi la ɠɛni doun zɔlɔɔni bɛ ɲɛgɛlɛin. Kɛlɛ duɔ anzanui ta ɠɛni zea, daaseigi ɠɛni ga Agaal, é ɠɛni ga Ezipete yooi zu nu. ");
INSERT INTO tod_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","É ɠɛni Abalame ma: «È kaa ga Ɠɔoɠɔ GALAGI la vaani bu ga gè doun zɔlɔɔ. Li, è ʋilɛ nà-duɔ anzanui ʋolu, tanisu nà doun zunu zɔlɔɔ ga maaʋele.» Abalame ziɛni ga anzai Salayi ná-tɛnɛ gooi. ");
INSERT INTO tod_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Abalame anzai Salayi ná-duɔ anzanui, Ezipete nui Agaal zeɠeni, é fe sinigi Abalame ya ga anza. Abalame zeini niina Kanaan yooi zu, é kɛ ná ga kona puugɔ. ");
INSERT INTO tod_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","É ʋilɛni Agaal ʋolu, naa kogi zeɠe. Siɛgi zu é ɓɔɠɔ ɠaai ma ga kogi ɠa ma, é ɠɛni bɛlɛlala wɛlɛi wosu ná-duɔ deei ʋa. ");
INSERT INTO tod_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Salayi ɠɛni Abalame ma: «Poomugi é zeelizu mà, ɗa ɠa è unma ɠasɔ ʋe. Nà ɓɔɠɔi ɠa gè nà-duɔ anzanui zeɠea, gè da è ʋolu, siɛgi zu é kaa la ga kogi ɠa ma, é ɗa bɛlɛlala wɛlɛi wo ga ze. Ɠɔoɠɔ GALAGI ɠɛ ga tukpɔɠaaleʋe nui de yɔɠɔzu.» ");
INSERT INTO tod_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abalame Salayi wooɠaaʋoteni, é ɠɛ ma: «Ɗa-luɔ anzanui ɠa è yeezu. So, eɠɛʋelei nɛai la è ʋɛ.» Salayi zɛba é ɗa sopele ɲɔu, eyɛsu naa ʋela ba. ");
INSERT INTO tod_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ɠɔoɠɔ GALAGI ná-geezuɠeelai kaani ziɛungi ɠobaʋɛ teʋebai zu, nii é Suul ʋelei zu. ");
INSERT INTO tod_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","É ɠɛni ma: «Salayi ná-duɔ anzanui Agaal, mini ɠa è zeɠeai ná, mini ɠa è liizu ná?» É gooɠaaʋoteni, é ɠɛ ma: «Nà ʋelazu nà-duɔ deei Salayi ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠɛni ma: «Ɠale ma ɗa-luɔ deei ʋɔ bɛ, è ɓɔɠɔ unmaayei bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠɛni ma mɔnɔ: «Nà è-mavofodai mɔinzu, toɠa mɔin gola, nu nɔpɛ ge la zooga é ʋa gaalu.» ");
INSERT INTO tod_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","É ɠɛni ma mɔnɔ: «Wɛlɛ, ɗa doun zɔlɔɔsu, toɠa ɠɛ ga zunu loun. Ɗa daasei pɛɛ ga Isemayɛle, mazɔlɔɔ Ɠɔoɠɔ GALAGI è woomɛnini ɗa-ɠoozuʋiligi zu. ");
INSERT INTO tod_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Toɠa ɠɛ ga dɔɓɔi zu zoovalegi, toɠa ɠɛ ɛsɛ pɛ daalɔɠɔma, ɛsɛ pɛ ge ɠɛ daalɔɠɔma, toɠa zeɠe kɛɛɠɛlointi pɛ ba, é zei yɛ.» ");
INSERT INTO tod_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agaal ɓɔɠɔ ɠaazaɠani, é ɠɛ ma: «Gè GALA ɓɔɠɔi ɠaaʋɛ nɛi ɓaa, nii é nɔ̀un kaazu?» Ɠɔoɠɔ GALAGI nii é ɓɔɛni tɔun pɔ, é naa laasei pɛɛni ga Ata-Ɛle-Lɔyi. ");
INSERT INTO tod_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Naa ɠa é ba, ma ɠɔlɔyeɠei laasei pɛai ga, Laɠayi-Loyi ɠɔlɔyeɠei, Toɠa Kadɛseni ta Ɓelɛde zɔɠɔzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agaal doun zunu zɔlɔɔni Abalame ʋɛ, naa daasei pɛɛni ga Isemayɛle. ");
INSERT INTO tod_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abalame ná-konagi ɠɛni ga puulɔsaʋa maazu lɔzita (86), siɛgi zu Agaal Isemayɛle zɔlɔɔni la bɛ. ");
INSERT INTO tod_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abalame ná-konagi ɠɛai ma ga puutaaʋuu maazu taaʋuu (99), Ɠɔoɠɔ GALAGI ɠulani bɛ kɛlɛma, é ɠɛ ma: «Nà ɠa gè ga GALA Zɛbɛi-Pɛ-Maliɠii. Ɗa-eteai ziɛ gàazu ga pagɔ, zelilomazu mina ɠɛ è ʋa. ");
INSERT INTO tod_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Nà minazeɠezu è ʋɛ, nà è-mavofodai mɔinzu gola.» ");
INSERT INTO tod_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abalame maaʋɛɛni, é nɔkɔ zooi ma, GALA ge ɠɛni ɓɔɛzu pɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Wɛlɛ, nà-minazeɠegi ɠaa, gè kɛɛzu è ʋɛ: Ɗa ɠɛɛzu ga zii mɔinmɔingaa ti-ɠɛɛ. ");
INSERT INTO tod_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Za ʋoluma, è la mɔ loliga ga Abalame, kɛlɛ è-laaseigi ɠa ɠɛ ga Abalaame, mazɔlɔɔ nà è ɠɛɛzu ga zii mɔinmɔingaa ti-ɠɛɛ. ");
INSERT INTO tod_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Nà è-mavofodai ɠaawɔɔlɔ gola, ɗa ɠɛ ga zii mɔinmɔin tɔɔzeizu, masagiti ta ɠula è-mavofodai zu. ");
INSERT INTO tod_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nà nà-minazeɠegi zo è letema eyɛsu ɠɔ, nà kɛ ɠana nɔ è-mavofodai kpein bɛ. Niima minazeɠegi maaʋele ma, nà ɠɛ ga ɗa-ƓALAGI, ta è-mavofodai nɔnɔ è zeɠea ʋoluma ná. ");
INSERT INTO tod_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nà Kanaan yooi kpein fe è ʋɛ, ɗa-o, è-mavofodaiti-yo, ʋɛ è ná ga seikɔɠɔma nui niizu. Toɠa ɠɛ ga wɔnɔ eyɛsu ɠɔ. Nà ɠɛ ga è-mavofodai ná-GALAGI.» ");
INSERT INTO tod_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","GALA ge ɠɛni Abalaame ma mɔnɔ: «Ɗɔun, ɗa nà-minazeɠegiti makɛ, wa è-mavofodaiti kpein. ");
INSERT INTO tod_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nà-minazeɠegi ɠa é ga nii, nii wa so kpaan ade yɔɠɔzu, ɗa-o, è-mavofodaiti-yo: Zunuiti kpein ti wo zaama, ti lati pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Wa-latipɛlɛʋolui ɠa ɠɛ ga minazeɠegi ma ʋoogi ade yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Zunuiti kpein ta ɠɛ wo zaama, wa ɗa ti lati pɛlɛʋolu foloi lɔsaʋasiɛi ma, é ɠɛ ɠana wo-mavofodaiti kpein su, é zɔlɔɔni pɛlɛi wu, ɓaa é ɠeyani ga walii, wɛɛin é ga duɔi, niiti ti la ga è-mavofoda. ");
INSERT INTO tod_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ti pɛ, zeeɠaaɠwɛɛzu la ba, ta lati pɛlɛʋolu, é zɔlɔɔni ɗa-ʋɛlɛi wu, ɓaa é ɠeyani ga ɗa-walii, nà-minazeɠegi ma ʋoogi ɠa ɠɛ wo-ɓusɛi ma zuai ʋa. Naa ɠa é ga ɠɔoɠɔ minazeɠegi. ");
INSERT INTO tod_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Zunui nii é la latini pɛlɛʋolu kpusɛi zu, naa ɓe ka leʋe ná-nuɓusɛiti ba, tɔɔzei é nà-minazeɠegi ɠoloɠologa.» ");
INSERT INTO tod_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","GALA ge ɠɛni Abalaame ma: «È la mɔ è-anzai Salayi loliga ga Salayi, kɛlɛ daaseigi ɠa ɠɛ ga Sala. ");
INSERT INTO tod_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nà tuya loo bɛ, nà doun zunu ve è ya ga tɔun maaʋele, nà tuya loozu bɛ, toɠa ɠɛ ga zii mɔinmɔingaa ti-lee, nuɓusɛiti ma mɔinmɔingaa ta-masagiti ta ɠula tɔun su.» ");
INSERT INTO tod_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abalaame maaʋɛɛni, é nɔkɔ zooi ma, é ɲɛɛi wo, é ɠɛ yiimaʋɛ: «Doun zunu ɠa zɔlɔɔ nɛi zunu ʋa, nii é kona ungila (100) kɛai na? Ta ànzai Sala é kona ʋuutaaʋuugɔ (90) ɠɛai na, naa ɠa zoo é doun zɔlɔɔ ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abalaame ɠɛni GALA ma: «Nii gè falizu è ma, naa ɠa é ga Isemayɛle ɠula su, è makɛ ma kpaan.» ");
INSERT INTO tod_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","GALA ge ɠɛni ma: «Ɓa-o, è-anzai Sala ɠa doun zunu zɔlɔɔsu è ʋɛ, ɗa daasei pɛɛ ga Izaake. Nà-minazeɠegi ɠa ɠɛ ga ɠɔoɠɔ faa, gi yɔɠɔzu gá tɔ, ta gi yɔɠɔzu gá mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Isemayɛle letemazu, gè ɗa-vali wooi mɛnigɛ ná-faa zu. Ungo, nà tuya loo bɛ. Toɠa ɓuɠu, nà mavofodai ɠaawɔɔlɔ gola. Masa puugɔ maazu felegɔ (12) ɠa ɠula tɔun su, toɠa ɠɛ ga zii wola ma mɛmɛwolai. ");
INSERT INTO tod_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kɛlɛ nà nà-minazeɠegi ɠɛ gi yɔɠɔzu gá Izaake, doun zunui nii Sala sɔlɔɔsu è ʋɛ, niima yeeɠɛɠalai nɔ zu, konagi nii é ʋaazu.» ");
INSERT INTO tod_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Siɛgi zu GALA ge ɓeni la ga ɓɔɛ Abalaame ʋɔ, é zeɠeni ná, é li. ");
INSERT INTO tod_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abalaame ná-doun zunui Isemayɛle zeɠeni, ta nii kpein é zɔlɔɔni ná-pɛlɛi wu, ta nii kpein é geyani ga walii, zunuiti kpein ná-pɛlɛ wu nuiti saama, é ti latini pɛlɛʋolu naama voloi, eɠɛʋelei GALA ge devei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abalaame ná-konagi ɠɛni ga puutaaʋuu maazu taaʋuu (99), siɛgi zu é latini da pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ná-doun zunui Isemayɛle ná-konagi ɠɛni ga puugɔ maazu saʋagɔ (13) niina, siɛgi zu é latini da pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abalaame ta ná-doun zunui Isemayɛle ti latini pɛlɛʋolu naama voloi nɔ zu. ");
INSERT INTO tod_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Zenɔ ɠana é ɠɛni la ga ná-pɛlɛ wu zunuiti kpein, niiti ti zɔlɔɔni ná-pɛlɛi wu, ta wɛɛinti ti ɠeyani ga walii, ti pɛ ti latini pɛlɛʋolu ta tiye. ");
INSERT INTO tod_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ɠɔoɠɔ GALAGI ɠulani kɛlɛma Abalaame ʋɛ Mamelé ná-sɛne guluiti kobaʋɛ. Abalaame ɠɛni zeini ná-seɠe ɠotai laaʋɛ. Folo kpaai ɠɛni de. ");
INSERT INTO tod_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","É ɠaazuwuzeɠeni, é wɛlɛ. É zunu saʋagɔiti kaani loni, ti lago maaɠoozaai ba. É ti ɠaai ma, é zo ná-seɠe ɠotai laaʋɛ, é ɓizɛni, é ti laaɠomi, é maaʋɛɛni, é nɔkɔ zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","É ɠɛni ti ma: «Màliɠii, nà è maanɛɛnɛzu, nɛ̀i gè ga ɗa-wotiɠɛ nui, nii gè zaalai zɔlɔɔgɛ è ɠaazu, mina leʋe, è ʋa maaɠooza bà. ");
INSERT INTO tod_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","À va bu ga gè ʋa ga ziɛi tago, wo ɠɔɠɔiti maagba, wo lago looɠo gulu wolai tɛi bu. ");
INSERT INTO tod_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nà liizu, gè ʋa ga ɓulu go wo ʋɔ, wo zɛbɛ zɔlɔɔ ʋolu, naa ʋolu wa li niina, naa ɠa a kɛ wo mina leʋe ɠana nɔ pɔ̀ bɛ, nɛ̀i gè ga wa-wotiɠɛ nui.» Ti gooɠaaʋoteni, ti ɠɛ ma: «Ungo, kɛ, eɠɛʋelei è bogai la.» ");
INSERT INTO tod_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abalaame liini gaamago nɔ ná-seɠe ɠotai wu, é ɠɛ Sala ma: «Suvilɛ, è kɔɠɔ ganii ɲɛ saʋagɔ zeɠe ɓulu vukɔi zu, è gaayɔ, è ɓulu ʋɛlɛʋɛlɛgiti kpɛtɛ.» ");
INSERT INTO tod_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abalaame ɓizɛni ná-togani ɓulugi ʋɔ bɛ, é nikɛ yiʋoi yɔbugi zeɠe nii pagai, é fe botiɠɛ nui ta ya, naa suvilɛ ga kpɛtɛa. ");
INSERT INTO tod_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","É nikɛ ɲiimiɗɛi ma wulɔi ta nɔnɔi zeɠeni, é pɛɛ nikɛ yiʋoi ʋa, ti kɛʋele ɓɛtɛni, é ʋaa la ti ʋɔ. É loni ti ɠoba tɔ ɓɔɠɔi, gulu wolai wu, ti ɠɛai ma laamiizu. ");
INSERT INTO tod_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Naa ʋolu ti ɠɛni ma: «Mini ɠa è-anzai Sala ná?» É ti wooɠaaʋoteni, é ɠɛ ti ma: «Toɠa ʋɛ seɠe ɠotai wu.» ");
INSERT INTO tod_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Gila ge ɠɛni ma: «Konagi nii é ʋaazu, niima yeeɠɛɠalai zu, nà ʋaazu ʋolu è ʋɔ bɛ, è-anzai Sala ɠa doun zunu zɔlɔɔ.» Sala yɛni poluʋɛ seɠe ɠotai wu, é niima wooiti mɛni. ");
INSERT INTO tod_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abalaame ta Sala ti wɔlɔzaɠaga ɠɛni de niina, ti kona mɔinmɔin kula. Sala ɓudɛni niina doun zɔlɔɔ siɛgi maazu. ");
INSERT INTO tod_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sala ɲɛɛi woni ɠoozu, é ɠɛ ma: «Niizu gè wɔlɔzaɠaga, zini pɛlɛ wu wɔin ɠa ɠɛ mà mɔnɔ ɓaa? Màliɠii ɓalaa wɔlɔzaɠaga.» ");
INSERT INTO tod_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ɠɔoɠɔ GALAGI ɠɛni Abalaame ma: «Lee vaa zu Sala ɲɛɛi wogai, é ɗa ɠɛ ma: ‹Gaama ʋe nɛi ɓaa, ga nà doun zunu zɔlɔɔsu, nɛ̀igi pɔ̀lɔzaɠagai na?› ");
INSERT INTO tod_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Faa ɠa ná nɛi ɓaa, nii Ɠɔoɠɔ GALAGI la zooga kɛɛzu? Konagi nii é ʋaazu, niima yeeɠɛɠalai nɔ zu, nà ʋaazu ʋolu è ʋɔ bɛ, Sala ɠa doun zunu zɔlɔɔ.» ");
INSERT INTO tod_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sala luani, é zɛɛi wo, é ɠɛ ma: «Gè la ɲɛɛ woni.» Kɛlɛ Ɠɔoɠɔ GALAGI ɠɛni ma: «Ga ɠite, è ɲɛɛi wogɛ.» ");
INSERT INTO tod_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Zunuiti ti wuzeɠeni ga ti li, ti wɛlɛ ga Sɔdɔme ʋele. Abalaame ti ʋuuni ga pele, é vali ti ma. ");
INSERT INTO tod_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè la naa lɔɔɠuzu Abalaame ʋa, nii gè ʋaazu kɛɛzu. ");
INSERT INTO tod_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Zii wolai nii zeeɠaaɓaai, toɠa ɠɛɛzu ga naa mɛmɛwola. Eteai zu zii kpein ka tuyai zɔlɔɔ maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mazɔlɔɔ gè yiimazeɠeʋɛ la, nii a kɛ, é devei ve ná-dointi zea, ta mavofodaiti, ga ti Ɠɔoɠɔ GALAGI yiimai ɠɛ, ti yɛ sɔledai ta telebodai ɠɛɛzu, naa ɠa a kɛ gè minazeɠegiti daazeeli, niiti gè ti woni bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ɠɔoɠɔ GALAGI ɠɛni Abalaame ma: «Sɔdɔme ta Gomɔɔl ti maalɔɔ ɓee wooi zuwɔɔlɔa, ta-ɠotoi ɓaɠoa gola. ");
INSERT INTO tod_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Naa ɠa é ba, nà yeizu, gè pɛtɛ, ni ti ɠɛɛʋɛ eɠɛʋelei ma wooi ʋaa la, é zeeli mà, ɓaa ni é la ɠana, nà kwɛɛ.» ");
INSERT INTO tod_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Zunui naati ti liini ga Sɔdɔme ʋele, siɛgi zu Abalaame ɠɛni loni la dɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abalaame maaɓuɠani ba, é ɠɛ ma: «Ɗa telebo nui ɓɔ nu ɲɔi ʋa, è ti undaaʋili ɓaa? ");
INSERT INTO tod_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Tanisu telebo nu ʋuulɔɔlugɔ (50) ɠa taai zu, ɗa naati ɓalaa undaaʋilisu, è la taai zuvaayɛga telebo nu ʋuulɔɔlugɔi (50) maaʋele ma, ti ti zaama? ");
INSERT INTO tod_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","È la zooga è ʋa naa ɠɛ! È la telebo nui ta nu ɲɔi zoga ga ɠɛʋele, è ʋa telebo nui ɓɔ faa ɲɔu ɠɛ nui ʋa, è ʋa ti ʋaa! È la zooga è ʋa naa ɠɛ! Ɗɛi è eteai kpein tukpɔɠaaleʋezu, è la telebodai ɠɛa ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ni nà telebo nu ʋuulɔɔlugɔ (50) ɠaana Sɔdɔme taazuʋɛ, nà taai kpein suvaayɛ ti maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abalaame kpɔɛi zeɠeni ʋolu, é ɠɛ ma: «Wɛlɛ, nà zoosu gè ɓɔɛ Màliɠii ʋɔ, nɛ̀i gè ga pɔlɔi nɔ, ta zuʋui. ");
INSERT INTO tod_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tanisu telebo nu ʋuulɔɔlugɔi (50) ɠaaɠaaʋoola ga dɔɔlugɔ, dɔɔlugɔ vai zu, ɗa taai kpein suɠoloɠolo ɓaa?» Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè la taai zuɠoloɠologa, ni nà telebo nu ʋuunaanigɔ maazu lɔɔlugɔ (45) ɠaana ná.» ");
INSERT INTO tod_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abalaame kpɔɛi zeɠeni ʋolu mɔnɔ, é ɠɛ ma: «Tanisu telebo nu ʋuunaanigɔ (40) nɔ ɠa é ná.» Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè la suɠoloɠologa naama nu ʋuunaanigɔi (40) maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abalaame ɠɛni ma: «Màliɠii, soma kae è mina yiiɠaawana, tɔɔzei nà ɠilizu faa ɠilagi ʋa. Tanisu telebo nu ʋuusaʋagɔ (30) ɠa é ná.» Ɠɔoɠɔ GALAGI ɠɛni ma: «Ni nà telebo nu ʋuusaʋagɔ (30) ɠaana ná, gè la taai zuɠoloɠologa.» ");
INSERT INTO tod_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abalaame ɠɛni ma: «Wɛlɛ, nà zoosu gè ɓɔɛ Màliɠii ʋɔ. Tanisu telebo nu ʋuufelegɔ (20) ɠa é ná.» Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè la taai zuɠoloɠologa nu ʋuufelegɔi (20) maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abalaame ɠɛni ma: «Màliɠii, soma kae è mina yiiɠaawana, gè la mɔ kpɔɛ ɠili nɔpɛ bosu, é ɠula nii ʋolu. Tanisu telebo nu puugɔ ɠa ɠɛ ná.» Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè la Sɔdɔme zuɠoloɠologa naama nu puugɔiti maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Siɛgi zu ti ɓeni la ga yɛpɛ ta Abalaame, Ɠɔoɠɔ GALAGI liini. Abalaame ɓalaagi ɠaleni ma seizuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Geezuɠeela felegɔiti ti zeɠeni Sɔdɔme kpɔkɔmaʋɛ. Lote ɠɛni zeini Sɔdɔme taa ziɠidaʋɛ. Siɛgi zu Lote ti ɠaani la, é wuzeɠeni, é ti laaɠomi, é maaʋɛɛni, é nɔkɔ zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","É ɠɛni ti ma: «Nà wo maanɛɛnɛzu, màliɠiiti, à ɠale ma, wo ɲi nà-pɛlɛi wu, nɛ̀i gè ga wa-wotiɠɛ nui. Wa zoo wo wo-ɠɔɠɔiti maagba ná, wo ɲi piin, sobui wo wuzeɠe, wo ɗa li wo-liizu ʋelei.» Ti ɠɛni ma: «Ɓa-o, gá ɲiizu koi zaamaʋɛ nɔ.» ");
INSERT INTO tod_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kɛlɛ Lote ɠilini ti ma gola, ti vaani bu, ti li ná-pɛlɛi wu. É daamianigi ɓɛtɛni ti ʋɛ, é pɛɛ ɓului ʋa, nii lɛʋɛ la su. Ti laamiini. ");
INSERT INTO tod_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aisa ti ʋa la, Sɔdɔme taazuʋɛ zunuiti kpein ti ʋaani, ti ɠaku pɛlɛi ma, zunuiti kpein ti ʋaani, é zo zunu loungoiti ma, é li kɛwolaiti pɔ, ti pɛ ɲɛgɛlɛin ti ʋaani ná. ");
INSERT INTO tod_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ti Lote lolini, ti ɠɛ ma: «Zunuiti ta mini, niiti ti ʋaai è ʋɔ bɛ kpidii? Ti ɠula, è ʋa ga tiye gi ʋɔ, gi ɓɛdɛ ɠula ga tiye.» ");
INSERT INTO tod_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lote ɠulani pɛlɛlaʋɛ, é daaɠulu ga ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","É ɠɛni ti ma: «Ɓa, kɛ̀ɛleaiti, nà wo maanɛɛnɛzu, à mina faa ɲɔi ɠɛ. ");
INSERT INTO tod_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","À woilo, dòun anzanu felegɔiti ti ná, ti la vɔlɔ zunu vaa ɠwɛɛ. Nà ʋaazu ga naati wo ʋɔ eteaʋɛ, wo naa ɠɛ ga tiye, nii nɛai wo ʋɛ. Kɛlɛ à mina vɔɔɠu zunui niiti ba, tɔɔzei ti ʋaaʋɛ, ti laazuʋɛ nà-pɛlɛi wu.» ");
INSERT INTO tod_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ti ɠɛni ma: «Zeɠe lɛɛ ʋɛ!» Ti ɠɛni ma mɔnɔ: «Ɗɛi è ga seikɔɠɔma nu nɔ, è ʋaai, ɗa pɔ è ɠɛ ga tukpɔɠaaleʋe nu! Ɓe nɔ, nii gi kɛɛzu ga ɗe, naa ɠa ɲɔu tɔnɔi ʋa.» Ti Lote ɓakpani ga ɲɔuɗa, ti maaɓuɠani kpogi ʋa, ga ti koloɠolo. ");
INSERT INTO tod_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Zunu felegɔiti ti ɠɛni Lote ʋɔ bɛ, ti soni, ti mɛɛn pɛlɛi wu, ti pɛlɛi laaɠulu. ");
INSERT INTO tod_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ti yeeziɛni nuiti gaazu, niiti ti ɠɛni loni pɛlɛlaʋɛ, ti ɠaazuɠole, é zo zunu loungoiti ma, é li kɛwolaiti pɔ, naa ɠa é kɛɛni ti la mɔ ɠɛni pɛlɛlaʋɛ ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Zunu felegɔiti ti ɠɛni Lote ma: «Ɓɛgele ɠa é è ya ʋɛ mɔnɔ? È-nɛkoiti, è-loun zunuiti, è-loun anzanuiti, nii kpein é ga ɗɔnɔ taazuʋɛ ʋɛ, ti pɛ kula niima adaʋɛ ʋa. ");
INSERT INTO tod_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Mazɔlɔɔ gá ga ʋa niima laai ɠoloɠolosu, tɔɔzei maalɔɔ ɓee wooi wɔɔlɔʋɛ, é zeelizu Ɠɔoɠɔ GALAGI ma. Naa ɠa é ba, Ɠɔoɠɔ GALAGI gi leʋegɛ ga gi taai tɛi koloɠolo.» ");
INSERT INTO tod_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lote ɠulani, é li, é ɓɔɛ naati pɔ, niiti ti ná-doun anzanuiti maazoni, é ɠɛ ti ma: «À wuzeɠe, wo ɠula niima adaʋɛ ʋa, mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠana ʋa taai ɠoloɠolosu!» Kɛlɛ naati ti naama wooiti kaani ga ɲɛɛvae faa nɔ. ");
INSERT INTO tod_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Geelaalao siɛgi zu, geezuɠeelaiti ti ɠilini Lote ma, ti ɗa ɠɛ ma: «Wuzeɠe, è-anzai zeɠe ta è-loun anzanu felegɔiti niiti ti ʋɛ, naa ɠa a kɛ è undaa mina ʋili taai ná-undaaʋiligi zu.» ");
INSERT INTO tod_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tɛi é ɠɛni nɛkɛsu, zunu felegɔiti ti soni zeei ʋa, tɔun be-o, anzai ʋe-o, ta ná-doun anzanu felegɔiti be-o, mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠɛni pɔ ga é ɓaa ti maazu, ti liini ga tiye, ti ti yɛ taa ʋoluʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ti ɠulaai ma taai ʋa, geezuɠeelai gila ge ɠɛni ma: «Ɓizɛ, è è-yɛnvui ɠizo! Mina wɛlɛ ʋolu, mina lo nɛmɛi zu ada nɔpɛ! Ʋela, è lɛ gizei ma, ni ɗa pɔ ga è undaa mina ʋili.» ");
INSERT INTO tod_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lote ɠɛni ma: «Ɓa-o, màliɠii! ");
INSERT INTO tod_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nɛ̀i gè ga ɗa-wotiɠɛ nui, gè zaalai zɔlɔɔgɛ è ɠaazu, è ɠɛɛʋɛ ga wooɠɛɠila nu bɛ̀, è zɛ̀nvui ɠizo fai zu. Gè la zooga gè ʋa ʋela, gè ʋa lɛ gizei ma, nà ɠɛ gè za, ùndaaʋili. ");
INSERT INTO tod_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wɛlɛ, taai tɛi tago maaɓuɠaʋɛ, ga gè ɓizɛ gè zeeli ná. Dɔiʋɛ, nà zoo gè ʋela, gè li ná, zɛ̀nvui ɠizo! Taai naa la lɔini ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Geezuɠeelai ɠɛni ma: «Wɛlɛ, gè vaa naa wu, ga gè kɛ è ʋɛ ga faaɓɔɠɔ, gè la taai tɔna koloɠologa, nii è ná-fai wosu. ");
INSERT INTO tod_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Suvilɛ, è ʋela, è li ná, mazɔlɔɔ gè la zooga gè ʋa faa nɔpɛ kɛ, eyɛsu è zeeli ná.» Naa ɠa é kɛa, ti taai naa laasei pɛai ga Sowaal. ");
INSERT INTO tod_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Folo tɛɛ ziɛgi zu ɠa Lote zeelini la Sowaal. ");
INSERT INTO tod_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Názu ɠa Ɠɔoɠɔ GALAGI timini abui ʋuuni la Sɔdɔme ta Gomɔɔl, eɠɛ tonai, é ɠulazu geezuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","É taai naati koloɠoloni, naa ʋɛɛ maaɠoolii ma nɛmɛi kpein ba, ta ma nuɓusɛiti, naa ʋɛɛ siinziin ganigiti ba. ");
INSERT INTO tod_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lote anzai wɛlɛni ga ʋoluʋelei, é ʋoteni ga kpolo ziɠigi. ");
INSERT INTO tod_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abalaame wuzeɠeni ga sobuzobui, ga é li naama adaʋɛ, ʋɛ é ɠɛni loni ná Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","É ɠaazuziɛni Sɔdɔme ta Gomɔɔl letema ʋelei, ta nɛmɛi maaɠoolii ma yooi kpein su, pɛtɛ, é duului ɠaani, é ɗa wuzeɠe zooi ma, eɠɛ abuzulugi ma luului. ");
INSERT INTO tod_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Siɛgi zu GALA ge nɛmɛ zu laaiti suɠoloɠoloni la, é ɠizɛni Abalaame zu, é Lote ɠula faaɓaagi zaama, nii é taaiti tokani da, ʋɛ Lote ɠɛni zeini ná. ");
INSERT INTO tod_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lote zeɠeni Sowaal, é li, é zei gizei ma, ta ná-doun anzanu felegɔiti, mazɔlɔɔ é luani ga é mina yɛ Sowaal. É zeini pugi zu ta ná-doun anzanu felegɔiti. ");
INSERT INTO tod_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yeeta, nu ɠite gelei ɠɛni loungo gelei ma: «De-ɠɛɛ wɔlɔzaɠaga, zunu la zou yɔɠɔzuʋɛ ʋɛ, nii a ʋilɛ de ʋolu, eɠɛʋelei de ɠula de ka la etea. ");
INSERT INTO tod_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","De li, de dɔɔi ʋu de-ɠɛɛ la. De la koba, naa ɠa a kɛ, de-ɠɛɛ mavofodai ɠɛ ná.» ");
INSERT INTO tod_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ti dɔɔi ʋuuni ti-ɠɛɛ la kpidii naa, nu ɠite gelei liini, é la kɛɛɠɛ ɠoba. Naa la looni ga daa la koba, ta buzeɠe la. ");
INSERT INTO tod_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Naa ʋolu sobui, nu ɠitei ɠɛni loungo gelei ma: «Wɛlɛ, dàaʋɛ kɛ̀ɛ ɠoba kpɔkɔ ná. De dɔɔi ʋu da mɔnɔ za kpɔkɔi, è li, è la koba, naa ɠa a kɛ de-ɠɛɛ mavofodai ɠɛ ná.» ");
INSERT INTO tod_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ti dɔɔi ʋuuni ti-ɠɛɛ la mɔnɔ kpɔkɔi tɔna. Loungo gelei liini, é la koba. Naa la looni ga daa la koba, ta buzeɠe la. ");
INSERT INTO tod_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lote ná-doun anzanu felegɔiti ti kogi zeɠeni ti-ɠɛɛ ʋa. ");
INSERT INTO tod_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nu ɠite gelei doun zunu zɔlɔɔni, é daasei pɛɛ ga Moaɓe. Zaaɠaza tɔ ɠa é ga Moaɓe nuiti ti-mɛmɛwolai. ");
INSERT INTO tod_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Loungo gelei ɓalaagi doun zunu zɔlɔɔni, é daasei pɛɛ ga Ɓɛne-Ami. Zaaɠaza tɔ ɠa é ga Amɔn nuiti ti-mɛmɛwolai. ");
INSERT INTO tod_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abalaame zeɠeni niima yooi zu, é li ga lɛkpɛmaʋɛ nu yeezazu ʋelei, é zeini Kadɛseni zɔɠɔzuʋɛ ta Suul, é lago zeini Gelaal. ");
INSERT INTO tod_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abalaame a la ɠɛna ɓɔɛa, é lo anzai Sala ʋa, é ɠɛni ɠɛɛzu ma: «Toɠa ga bàazeelai.» Gelaal masagi Aɓimelɛke Sala zeɠeni. ");
INSERT INTO tod_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Naazu, GALA ge ɠulani kɛlɛma segi zu Aɓimelɛke ʋɛ kpidii, é ɠɛ ma: «Wɛlɛ, ɗa ʋaazu zaazu, tɔɔzei anzanui naa ná-faa zu, nii è seɠeai, mazɔlɔɔ zini ka bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Aɓimelɛke la ɠɛni dɛ daani ʋolu, é gooɠaaʋoteni, é ɠɛ ma: «Màliɠii, ɗa sɔbalala nuiti paa ɓaa? ");
INSERT INTO tod_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Sinigi ɓɔɠɔi lɛi kɛai mà: ‹Bàazeelai ʋe›? Ta anzanui ɓɔɠɔi ɓalaa bogɛ ga: ‹Dìɛi ʋe›? Gè kɛɛʋɛ kisiɛ ʋagɔi zu, ta sɔbalalai zu.» ");
INSERT INTO tod_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","GALA ge ɠɛni ma segi zu: «Gè kwɛɛ gè ɠɛ è kɛɛʋɛ zii ʋagɔlai zu, naa ɠa é kɛa gè pele ɓesagai è luɠɔ ga è mina koto ɠɛ dàalɔɠɔma. Naa ɠa é ba, gè la vaani bu ga è ʋa da ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Niizu zunui nii anzai ve zea, mazɔlɔɔ toɠa ga GALA goo wo nui ta. Toɠa maanɛɛnɛi wo è ʋɛ, ɗa yɛ vulua. Kɛlɛ ni è la teʋeni pɔ, suɠwɛɛ ga ɗa za, ɗa-o, ɗa-nuɓusɛiti-yo.» ");
INSERT INTO tod_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Aɓimelɛke wuzeɠeni sobuzobui, é ná-botiɠɛ nu wolaiti toli, é naama vaiti pɛ bo ti ma, ti wola luani. ");
INSERT INTO tod_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Aɓimelɛke Abalaame ɓalaa tolini, é ɠɛ ma: «Lee ɠa è kɛai ga giye? Kotoi ɓɛgele ɠa gè kɛai è laalɔɠɔma, nà-o, nà-masadai-yo, è gi lɔai kotoi nii zu? È-ziɛ ʋelei é lo nɔ̀un ba, nu maa la nɛɛni ga é ʋa naa ɠɛ.» ");
INSERT INTO tod_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Aɓimelɛke ɠɛni Abalaame ma: «Leeni ɠa é ɠɛa è ɠisu, è niima vai ɠɛai?» ");
INSERT INTO tod_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abalaame gooɠaaʋoteni, é ɠɛ ma: «Gè ɠɛni ɠisiɛzu, gè ɗa ɠɛ ɓɔɠɔ ma, zeɠema nɔpɛ ge la ba, ta ʋaazu pàazu ànzai vai zu, tɔɔzei GALA gaazuluaba ɠila kpalaa ge la niima yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Gaama ʋe, toɠa ga bàazeelai, é ga kɛ̀ɛ ná-doun anzanui, kɛlɛ dèe ná-doun anzanu laade. Toɠa ga ànzai. ");
INSERT INTO tod_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Siɛgi zu GALA ge kɛ̀ɛni la ga teʋeteʋe nu, gè ɠula kɛ̀ɛ ná-pɛlɛyeɠei wu, gè ɠɛni Sala ma: ‹Ʋɛ nɔpɛ de liizu ná, kɛni è ɠɛ bɛ̀ ga wooɠɛɠila nu, è ɗa ɠɛ ti ma: Dìɛi ʋe.› » ");
INSERT INTO tod_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Aɓimelɛke toganii tanigaa zoni baalagiti saama, ta boliiti, ta nikɛiti, é ti ve Abalaame ya, é pɛɛ botiɠɛ zunuiti ba, ta botiɠɛ anzanuiti. É anzai Sala ɓalaa teʋeni pɔ. ");
INSERT INTO tod_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","É ɠɛni ma: «Nà-zooi laalaogɛ è luɠɔ, zei ʋɛ nɔpɛ ná nɛɛzu è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","É ɠɛni Sala ma: «Gè wali ɠae waagila (1.000) fea è-liɛ ya, é ɠɛ ga poogi ga è la ga sɔba nu niima vaiti su, è-maaɠoolii zu nuiti gaazu.» ");
INSERT INTO tod_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abalaame GALA falini. GALA ge Aɓimelɛke ɠɛdɛni, ta anzai, ta ná-botiɠɛ anzanuiti, ti zooni ti ɗa dointi sɔlɔɔ ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Mazɔlɔɔ Ɠɔoɠɔ GALAGI Aɓimelɛke ná-pɛlɛyeɠei wu anzanuiti pɛ kɛɛni ga doun zɔlɔɔtala nuiti, Abalaame anzai Sala ná-faa zu. ");
INSERT INTO tod_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ɠɔoɠɔ GALAGI Sala maawɔinɠaani, é naa laazeelini bɛ, nii é minazeɠeni la. ");
INSERT INTO tod_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Abalaame wɔlɔzaɠagai ma, anzai Sala kogi zeɠeni, é doun zunu zɔlɔɔ bɛ, naa ɠɛɛni é zoloo GALA ná-ku logai ma, nii é boni ma. ");
INSERT INTO tod_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Doun zunui nii Sala sɔlɔɔni bɛ, Abalaame daasei pɛɛni ga Izaake. ");
INSERT INTO tod_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abalaame ná-doun zunui Izaake latini pɛlɛʋolu, sɔlɔɔ foloi lɔsaʋasiɛi ma, eɠɛʋelei GALA ge ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abalaame ná-konagi ɠɛni ga ungila (100), siɛgi zu ná-doun zunui Izaake zɔlɔɔni da. ");
INSERT INTO tod_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sala ɠɛni ma: «GALA ge zobo fea ga gè ɲɛɛi wo ga koozunɛɛi, nu-o-nu nii a nii mɛnina, naa ɠa ɗa ɲɛɛ nɔ kpaain.» ");
INSERT INTO tod_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","É ɠɛni ma: «Ɓɛ ɠa a la ɠɛ Abalaame ma, Sala ɠa ɲiimi ve dounɠa ya? Tama gè zunu loun zɔlɔɔga bɛ pɔlɔzaɠa siɛgi zu.» ");
INSERT INTO tod_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Doungoi wɔɔlɔni, Sala daaɠula ɲiimii ʋa. Abalaame fɛti wolai ɠulani naama voloi. ");
INSERT INTO tod_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ezipete anzanui Agaal ná-doun zunui é sɔlɔɔni Abalaame ʋa, Sala naa ɠaani, é ɗa ɲɛɛi wo. ");
INSERT INTO tod_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sala ɠɛni Abalaame ma: «Duɔ anzanui nii ɓɛ ta ná-doun zunui, mazɔlɔɔ niima luɔ anzanui ná-doun zunui, ta dòun zunui Izaake ti la ɓɔga poganii ma.» ");
INSERT INTO tod_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Niima wooi wanani Abalaame ma gola, ná-doun zunui maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kɛlɛ GALA ge ɠɛni Abalaame ma: «Mina nii wana ɓɔɠɔ ma ɗa-luɔ anzanui ná-doun zunui vaa zu. Naa pɛ kɛ Sala ʋɛ, nii é bosu è ma. Mazɔlɔɔ Izaake ɠa è-mavofodai a ɠula su. ");
INSERT INTO tod_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Anɛɛ naa ʋe, nà ɗa-luɔ anzanui ná-doun zunui ɠɛ ga zii ta mɛmɛwola, mazɔlɔɔ tɔ ɓalaa ɠulaʋɛ è zu.» ");
INSERT INTO tod_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Poluma zobui, Abalaame wuzeɠeni ga sobuzobui, é ɓului zeɠe ta kɔlɔ woolei ziɛi su, é sɛlɛ Agaal ɓaki ba, é zunu loungoi ɓalaa ve zea, é vali ti ma. É liini, é leʋeteʋe Ɓeel-Seɓa teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Siɛgi zu kɔlɔ woolei zu ɗɛi ɓeni da, é zunu loungoi yɛni laani gulu goi ta wu, ");
INSERT INTO tod_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","é li, é zei tɔ ɠila ɠoozama, ná tago maaɠoozaai nɔ fɔɛn, mazɔlɔɔ é ɠɛni ɠɛɛzu ma: «Gàazu la yɛsu doin ʋa, é ʋa ɗa za.» É zeini tɔ ɠila ɠoozama, é ɗa ɓalakpala, é ɗa wɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","GALA ge zunu loungoi wooi mɛnini, GALA ná-geezuɠeelai yɛni geezuʋɛ, é Agaal loli, é ɠɛ ma: «Agaal, leeni ɠa é è ya? Mina lua, mazɔlɔɔ ʋɛ è doungoi yɛgai ná, GALA ge goomɛnigɛ ná. ");
INSERT INTO tod_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Wuzeɠe, è zunu loungoi zeɠe, è gaanɛɛnɛ. Mazɔlɔɔ nà zii wola ɓɛtɛzu ba.» ");
INSERT INTO tod_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","GALA ge gaazuzeɠeni ma, é kɔlɔyeɠei ɠa, é li, é kɔlɔ woolei laave ga ziɛi, é ta ve zunu loungoi ya, é ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","GALA ge ɠɛni zunu loungoi ʋa, é ɗa wɔɔlɔ. É zeini teʋebai zu, é ɠɛni ga mɛɛn ʋili nu ʋagɔi. ");
INSERT INTO tod_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","É zeini Palan teʋebai zu. Dee anzanui ta ɠaiziɛni bɛ, é sei, naa ɠɛni ga Ezipete yooi zu nu. ");
INSERT INTO tod_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Naama ziɛgi nɔ zu, Aɓimelɛke ná-kɔɔɠuluɓai Pikɔle ʋilɛni polu, ti ʋa, ti Abalaame ɠa, é ɠɛ ma: «GALA ka naa pɛ suɓɛtɛzu, nii è kɛɛzu. ");
INSERT INTO tod_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ɠona bɛ̀ niina ga GALA daaseigi, ga è la yàava, ɓaa dòinti, ɓaa màvofodaiti, kɛlɛ ɗa yɛ ɗa-wooɠɛɠiladai ɠilagi nɔ ʋolu nɔ̀un bɛ, ta niima yooi nii è lago zeizu su, eɠɛʋelei gè kɛa la è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abalaame ɠɛni ma: «Gè konai naa woga.» ");
INSERT INTO tod_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","É ɓaazaɠani Aɓimelɛke ma kɔlɔyeɠei ná-fai zu, nii naa ná-botiɠɛ nuiti ti seɠeni ga zeeɠaaɓaai. ");
INSERT INTO tod_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Aɓimelɛke gooɠaaʋoteni, é ɠɛ ma: «Gè la kwɛɛ ɓɛ ɠa é naa ɠɛa. Ɗa ɓɔɠɔi è la ɠɛni naa woni mà, za ɠa gè mɛnisu da.» ");
INSERT INTO tod_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abalaame baalagi tanigaa zeɠeni, ta boliiti, ta nikɛiti, é ti ve Aɓimelɛke ʋɛ, ti felegɔ pɛ ti minazeɠegi ɠɛɛni ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abalaame baala ziʋo zaa lɔfela makɛni yɛ ma ɓulugi zu. ");
INSERT INTO tod_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Aɓimelɛke ɠɛni Abalaame ma: «Leeni vaa zu è niima ʋaala ziʋo zaa lɔfelaiti makɛgai yɛ?» ");
INSERT INTO tod_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","É gooɠaaʋoteni, é ɠɛ ma: «Yeezei baala ziʋo zaa lɔfelai niiti bu, gè feezu è ya, naa ɠa ɠɛ bɛ̀ ga zeele wooi ga nà ɠa gè niima ɠɔlɔyeɠei wɔa.» ");
INSERT INTO tod_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Naa ɠa é ba, ti naama adaʋɛ laaseigi ʋɛɛni la ga Ɓeel-Seɓa (nii poluʋɛ ga «minazeɠe kɔlɔyeɠei»), tɔɔzei miná ɠa ti felegɔ ti minazeɠeni ná ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ti minazeɠeni ɓɔɠɔ ʋɛ Ɓeel-Seɓa. Naa ʋoluma Aɓimelɛke wuzeɠeni ta ná-kɔɔɠuluɓai Pikɔle, ti ɠale ma Filisiti nuiti ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abalaame gului ta ziinni Ɓeel-Seɓa, nii ti ɠɛɛzu ma tamalise, náʋɛ ɠa é Ɠɔoɠɔ GALAGI valini ná, GALA nii é ná eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","É lɛbini zeini Filisiti nuiti ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Niima vaiti pɛ poluma, GALA ge Abalaame zuɠɔɠɔni, é ɠɛ ma: «Abalaame!» Naa gooɠaaʋoteni, é ɠɛ ma: «Nà ɠaa!» ");
INSERT INTO tod_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","GALA ge ɠɛ ma: «È-loun zunu ɠila kpegi Izaake zeɠe, nii è nɛai ʋɛ, è li Moliya yooi zu, è kula ga gala zalaɠai gizei naa ma, nii ná yeelo ba.» ");
INSERT INTO tod_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abalaame wuzeɠeni ga sobuzobui, é ná-soovalegi ɠasɔɠili, é ná-botiɠɛ nu felegɔ zeɠeni ta ná-doun zunui Izaake. É koʋii ʋaliʋalini gala zalaɠai vaa ma, é li naama adaʋɛ, ʋɛ GALA ge yeeloni ná ʋa. ");
INSERT INTO tod_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Foloi zaʋasiɛi ma, Abalaame ɠaazuwuzeɠeni, é naama adaʋɛ ɠa ɠoozama. ");
INSERT INTO tod_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","É ɠɛni ná-botiɠɛ nuiti ma: «À yɛ ʋɛ soovalegi ɠoba. Nà-o, zunu loungoi-yo, gá liizu munu, gi nɔkɔ GALA bu, naa ʋoluma gi ʋa wo ɠoba.» ");
INSERT INTO tod_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abalaame gala zalaɠai ma ɠoʋii zeɠeni, é ná-doun zunui Izaake laalɛ bu, é abui ta boɠai zeɠe. Ti felegɔ ti ɗa ziɛ ʋɔɔma, ti ɗa li. ");
INSERT INTO tod_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Izaake ɓɔɛni kɛɛɠɛ Abalaame ʋɔ, é ɠɛ ma: «Kɛ̀ɛ!» É gooɠaaʋoteni, é ɠɛ ma: «Nà ɠaa, dòun zunu.» Izaake ɠɛ ma: «Abui ta koʋiiti kaa, kɛlɛ mini ɠa baala ziʋoi ná, gala zalaɠai vaa zu?» ");
INSERT INTO tod_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abalaame gooɠaaʋoteni, é ɠɛ ma: «Dòun zunu, GALA ɓɔɠɔgoi ɠa ʋa ga baala ziʋoi, gala zalaɠai vaa zu.» Ti felegɔ ti ɠɛni ziɛzu ʋɔɔma, ti ɗa li. ");
INSERT INTO tod_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ti zeeliai ma naama adaʋɛ, ʋɛ GALA ge ná lɛɛni, Abalaame zalaɠa ɠulazuʋɛ ɓɛtɛni, é koʋii la maazu ga pagɔ. É ná-doun zunui Izaake yeeiti ta kɔɠɔiti suɠilini, é da zalaɠa ɠulazuʋɛ koʋii maazu. ");
INSERT INTO tod_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Naa ʋoluma Abalaame boɠai zeɠeni ga é ná-doun zunui ɠɔdaaleʋe. ");
INSERT INTO tod_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Gaamago nɔ, Ɠɔoɠɔ GALAGI ná-geezuɠeelai yɛni geezuʋɛ, é toli, é ɠɛ ma: «Abalaame! Abalaame!» É gooɠaaʋoteni, é ɠɛ ma: «Nà ɠa!» ");
INSERT INTO tod_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Geezuɠeelai ɠɛni ma: «Mina yeevɔɔɠu zunu loungoi ʋa, è ʋa faa nɔpɛ kɛ la. Mazɔlɔɔ gè kwɛni niina ga ɗa luazu GALA ba, è la kòmani ga è-loun zunu ɠila kpegi.» ");
INSERT INTO tod_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abalaame ɠaazuwuzeɠeni, é baala sinɛ wolai ɠa ʋoluʋɛ, minɛiti sogai dɔɓɔ goi zu, é ɓata. É baala sinɛ wolai zoni, é kula ga gala zalaɠai ná-doun zunui ʋotogi zu. ");
INSERT INTO tod_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abalaame naama adaʋɛ laasei pɛɛni ga Adɔnayi-Yiileyee (nii poluʋɛ ga «Ɠɔoɠɔ GALAGI nii é nu ɠulazu faa zu»). Naa ɠa é ba, zaaɠaza ti ɠɛɛzu ná ma: «Ɠɔoɠɔ GALAGI ná-gizei ma, ɗa ɠula su.» ");
INSERT INTO tod_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ɠɔoɠɔ GALAGI ná-geezuɠeelai yɛni geezuʋɛ, é Abalaame loli ná zeizu velesiɛi, ");
INSERT INTO tod_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","é ɠɛ ma: «Ɠɔoɠɔ GALAGI laawooi ɠaa: nà ɠonazu nà ɓɔɠɔi ma, tɛi è naa ɠɛa, è la kòmani ga è-loun zunu ɠila kpegi, ");
INSERT INTO tod_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nà tuya loozu è ʋɛ, gè è-mavofodai ɠaawɔɔlɔ, eɠɛ pelegi somideɠaiti ti mɔinɗai la geezuʋɛ, ta eɠɛ ɲaɠaegi nii é kpoloɗɛi ɠobaʋɛ. È-mavofodai ɠa zobo sɔlɔɔ sili nuiti ma. ");
INSERT INTO tod_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ziiti kpein ti eteai zu, ta tuyai zɔlɔɔ è-mavofodai maaʋele ma, tɔɔzei è gòoi zogɛ.» ");
INSERT INTO tod_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abalaame ɠaleni ma ná-botiɠɛ nuiti pɔ pelei, naa ʋolu ti ʋilɛni pelei ma, ti ɗa li ʋɔɔma Ɓeel-Seɓa. Miná ɠa Abalaame ɠɛni zeini ná. ");
INSERT INTO tod_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Naama vaiti pɛ poluma, Abalaame mɛnini ga, Milika ɓalaagi doun zunua zɔlɔɔni kɛɛɠɛloin Naɠɔɔl ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Use ɠa é ga ná-doun mɔungi, naa deɠeiti ti ɠɛ ga Ɓuze, ta Kemuwɛle nii é ga Alame kɛɛɠɛ, ");
INSERT INTO tod_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesede, Ɠazo, Piledase, Yidilafe, ta Ɓetuwɛle. ");
INSERT INTO tod_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Ɓetuwɛle ɠa é Eleɓɛka zɔlɔɔni. Naama loun lɔsaʋaiti ka Milika ti zɔlɔɔni Abalaame kɛɛɠɛloin Naɠɔɔl ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Anza ɠiligi nii é la ɠɛni vuluni ga zɔi ɠɛʋele, nii daaseigi ɠɛni ga Leyuma, naa dointi sɔlɔɔni, ti-laaseigiti ti ɠɛni ga: Teba, Gaɠame, Taɠase, ta Maaka. ");
INSERT INTO tod_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sala zii ma voloi kpein ge ɠɛni ga kona ungila puufele maazu lɔfela (127). ");
INSERT INTO tod_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","É zaani Kiliyate-Aaleɓa, nii é ga Eɓelɔn, Kanaan yooi zu. Abalaame ná-saa vai ɠɛɛni, é ma wɔlɔi wo. ");
INSERT INTO tod_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Naa ʋolu Abalaame wuzeɠeni, é anzai ma ʋoomai yɛ laani, é li, é ɓɔɛ Ɠɛte nuiti pɔ, ");
INSERT INTO tod_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","é ɠɛ ti ma: «Nà ga wɛɛin, gè zeini wo zaama. À maaɠulu bosu ve zèa, gè ànzai maaɠulu, nii saai.» ");
INSERT INTO tod_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ɠɛte nuiti ti gooɠaaʋoteni, ti ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Woilo gi-woo ma, màliɠii. GALA ge è ɠɛɛʋɛ ga nu wola gi zaama. È-anzai maaɠulu gá-ɠabayeɠeiti ma ʋagɔi zu. Gi tanɔpɛ ge la è ɠoma ga ná-kabayeɠe ve vaa è ya è-anzai maaɠulu vai zu.» ");
INSERT INTO tod_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abalaame wuzeɠeni, é maaʋɛɛ zou nuiti bɛ, Ɠɛte mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","É ɓɔɛ ti ʋɔ, é ɠɛ ti ma: «Ni wo va bu ga gè ànzai maaɠulu, à Soɠaal ná-doun zunui Efelon maanɛɛnɛ bɛ̀, ");
INSERT INTO tod_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ga é Makepela ʋugi ve zèa, toɠa nɔnɔ ʋe, nii é ná-kpala kpelamaʋɛ. É zɛ zèa ga sɔngɔ ɠitei nɔ wo ɠaazu, naa ɠa a kɛ é ɠɛ zèa ga maaɠulu bosuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efelon ɠɛni zeini Ɠɛte nuiti saama. É Abalaame wooɠaaʋoteni Ɠɛte nuiti gaazu, ta niiti kpein ti ɠɛni lɛɛzu taazu ga siɠida ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","É ɠɛ ma: «Ɓa-o, màliɠii, woilo gòo ma! Gè nà-kpalagi vea è ʋɛ, ta pugi nii é ná. Gè fea è ʋɛ ga faanɛɛ, nà-nuɓusɛiti gaazu, ga è è-anzai maaɠulu ná.» ");
INSERT INTO tod_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abalaame maaʋɛɛni zou nuiti bɛ. ");
INSERT INTO tod_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","É Efelon wooɠaaʋoteni, nii a kɛ ti pɛ ti gooi mɛni, é ɠɛni ma: «Woilo dɛɛ gòoi ma, ɗa ɓalaagi. Va bu gè kpalagi zɔngɔi ve è ya. Yeezei bu bɛ̀, nà ànzai maaɠulu ná niina.» ");
INSERT INTO tod_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efelon Abalaame wooɠaaʋoteni, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Màliɠii, woilo gòoi ma, leeni ɠa a ɠɛ ga naa de yɔɠɔzu da ɗe, zooi naa vaa zu nii sɔngɔi ga wali ɠae unnaanigɔ (400)? È-anzai maaɠulu ná.» ");
INSERT INTO tod_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abalaame vaani naa wu, nii Efelon boni, é wali ɠaei ɠaaluni, nii naa boni ma Ɠɛte nuiti gaazu, é lo wali ɠae unnaanigɔi (400) ʋa, eɠɛʋelei falibogi laaʋɛ ɠɛni la yaaɠoiti zea. ");
INSERT INTO tod_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Zekana Efelon ná-kpalagi é Makepela, Mamelé letemaʋɛ, kpalagi ta pugi é ná, guluiti ti kpalagi zu, kwɛpelemaʋɛ maaɠoolii zu, ");
INSERT INTO tod_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","naati pɛ ti ɠɛɛni niina ga Abalaame nɔnɔ, Ɠɛte nuiti gaazu, naati kpein gaazu, niiti ti ɠɛni lɛɛzu taazu ga siɠida ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Naa ʋoluma Abalaame anzai Sala maaɠuluni Makepela ɓalagi ma ʋugi zu, Mamelé letema ʋelei, nii é ga Eɓelɔn, Kanaan yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kpalagi ta pugi nii é ná, ti ɠɛni ga Abalaame nɔnɔ, naa ɠɛ ga kabamaʋɛ, é geyani Ɠɛte nuiti ma. ");
INSERT INTO tod_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abalaame wola wɔlɔzaɠaga ɠɛni de na, ta Ɠɔoɠɔ GALAGI tuya looni bɛ faiti kpein su. ");
INSERT INTO tod_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abalaame ná-botiɠɛ zunui lolini, nii pɔlɔzaɠagai é leʋe ti pɛ ba ná-pɛlɛi wu. Tɔ ɠa é ɠɛni zeaɠɔligiti kpein unda, é ɗa makɛ. É ɠɛni naa ma: «Yeelɔ kpàlai wu, ");
INSERT INTO tod_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ɗa ɠonazu bɛ̀ Ɠɔoɠɔ GALAGI ɠaazu, geeɠɔlɔgi ta zooi ma ƓALAGI, ga è la anza ɠaiziaa dòun zunui ʋɛ Kanaan anzalopoiti saama, ʋɛ gè zeini ná. ");
INSERT INTO tod_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kɛlɛ ɗa liizu nà-zooi zu, nà-bolodai zu, è anzai zeɠe ná dòun zunui Izaake ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Botiɠɛ zunui gooɠaaʋoteni, é ɠɛ ma: «Tanisu anzanui la kɛa, é ʋa ʋilɛ pòlu, é ʋa ʋa niima yooi tɛi su, kɛni mu gè li ga è-loun zunui zooi naa zu, ʋɛ è ɠulaai ná ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abalaame gooɠaaʋoteni, é ɠɛ ma: «Dama, è mina li ga dòun zunui ná. ");
INSERT INTO tod_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ɠɔoɠɔ GALAGI, é ga geeɠɔlɔgi ma ƓALAGI, nii é kùla kɛ̀ɛ ʋɛlɛi wu, ta kɛ̀ɛ ná-zooi ʋa, nii é ɓɔɛni pɔ̀, é ɠonani bɛ̀, ga toɠa zooi nii ve màvofodai ya, tɔ ɓɔɠɔi ɠa ná-geezuɠeelai leʋe è luɠɔ, è anzai zeɠe ná dòun zunui ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ni anzanui la pɔ, é ʋa ʋilɛ è ʋolu, ɗa vie naazu konai vaa zu, nii è bogai bɛ̀. Kɛlɛ anɛɛ naa ʋe, mina li ná nɔ ga dòun zunui.» ");
INSERT INTO tod_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Botiɠɛ nui yeei lɔɔni maliɠii Abalaame ɓalai wu, é ɠona bɛ ga toɠa ná-deveiti so. ");
INSERT INTO tod_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Botiɠɛ nui ɲɔmɛ puugɔ zeɠeni maliɠii ná-ɲɔmɛiti saama, é liini ga maliɠii yeaɠɔligi ma zii mɔinmɔin. É wuzeɠeni, é li Mezopotami, Naɠɔɔl ná-taazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Seeliai ma ná, é ɲɔmɛiti pilɛni ɲiibiɠa taa ʋoluʋɛ ziɛyeɠei ɠobaʋɛ, kpɔkɔmaʋɛ ma ziɛgi zu, yeeɠɛɠalai zu nii anzanuiti ta ɗa ɠula la, ti li ziɛ zaɠazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Naa ʋolu é ɠɛni ma: «Ɠɔoɠɔ GALAGI, màliɠii Abalaame ná-GALAGI, va bu, è ɗa-wooɠɛɠiladai ɠula kɛlɛma màliɠii Abalaame ʋɛ za, ga gè ɠomi ga naa, nii gè gaiziɛzu. ");
INSERT INTO tod_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nà ɠa, gè loni ʋɛ ziɛungi ɠobaʋɛ, taa nuiti ti-loun anzanuiti ta ʋaazu ɠulazu ga ti ʋa ti ziɛi zaɠa. ");
INSERT INTO tod_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Anzalopoi nɔpɛ gè ɠɛɛzu ma: ‹Nà è maanɛɛnɛzu, ɗa-ɗɛ liɠii yei lɛɛ, gè ɓɔɔle,› a gooɠaaʋotena ga: ‹Ɓɔɔle, nà ziɛ veezu ɓalaa ɲɔmɛiti zea, ti ɓɔɔle,› naa ɠɛ ga naama anzanui, nii è devea ɗa-wotiɠɛ nui Izaake ʋɛ. Nà kwɛɛ ga naa maaʋele ga è ɗa-wooɠɛɠiladai ɠula kɛlɛma màliɠii ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","É ɠɛɛzu é ɓe ga ɓɔɛ, Eleɓɛka ʋaani, ná-ziɛ liɠii zeini kɔma. É ɠɛni ga Ɓetuwɛle ná-doun anzanui, Abalaame kɛɛɠɛloin Naɠɔɔl ta anzai Milika ti-lounloin. ");
INSERT INTO tod_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","É ɠɛni ga anzalopoi nii gola ʋani, kpea ɠɛni de na, zunu nɔpɛ ge la ɠɛni dɛ kwɛɛ. É yeini ziɛungi zu, é ná-ziɛ liɠii laave, é lɛ ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Botiɠɛ nui ɓizɛni, é daaɠomi, é ɠɛ ma: «Nà è maanɛɛnɛzu, ɗa-ɗɛ liɠii zu ɗɛi ta ve zèa, gè ɓɔɔle.» ");
INSERT INTO tod_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","É gooɠaaʋoteni, é ɠɛ ma: «Ɓɔɔle, màliɠii!» É ná-ziɛ liɠii maayeini gaazuvilɛi zu, é ziɛi ve zea, é ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Siɛgi zu é ɓeni la ga ziɛi ve zea ga é ɓɔɔle, é ɠɛni ma: «Nà ʋaazu ziɛi zaɠazu ɓalaa ɗa-ɲɔmɛiti bɛ, eyɛsu ti ɓɔɔle gola ga pagɔ.» ");
INSERT INTO tod_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","É ɠaazuvilɛni, é ná-ziɛ liɠii zuwo toganiiti ta-ɓɔɔle wosuʋɛ, é ɓizɛni ziɛyeɠei ʋɔ bɛ mɔnɔ, é ziɛi zaɠa ɲɔmɛiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Zunui la ɠɛni faa nɔpɛ boni, é ɠɛni nɔ ɓɔɠɔ ɠaazaɠasu, é ɗa wɛlɛ, ni Ɠɔoɠɔ GALAGI ɠa ná-siɛi nɛɛzu, ɓaa ni é la nɛɛzu. ");
INSERT INTO tod_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Siɛgi zu ɲɔmɛiti ti ɓeni la ga ɓɔɔle, zunui zanu balaɠae gila seɠeni, nii buɲɛgi a la ɠɛ ga galamu lɔzita, ta zanu bala felegɔ ti ɠilagilagi wuɲɛgi ga galamu ungila (100) kɛɠala maazu ba, é ti veeni zea ga é ti lɔ yeeɠɔdaʋɛti. ");
INSERT INTO tod_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","É ɠɛni ma: «Ɓɛ ná-doun anzanu ɠa é ga ɗe? Bo dɛɛ mà, nà è maanɛɛnɛzu. Gá laazu zɔlɔɔ nɛi è-ɠɛɛ ná-pɛlɛi wu, ga gi ɲi ná?» ");
INSERT INTO tod_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Eleɓɛka gooɠaaʋoteni, é ɠɛ ma: «Nà ga Ɓetuwɛle ná-doun anzanui, Milika ta Naɠɔɔl ti-loun zunui.» ");
INSERT INTO tod_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","É ɠɛni ma mɔnɔ: «Suaiti daazuʋɛ lufai ta ti-laamianigi ɠa gi ʋɔ bɛ ga bɔɔlɔa, nu laazuʋɛ ɠa ná ɓalaa.» ");
INSERT INTO tod_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Zunui nɔkɔni Ɠɔoɠɔ GALAGI wu, ");
INSERT INTO tod_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","é ɠɛ ma: «Mamagi ɠa Ɠɔoɠɔ GALAGI ʋɛ, màliɠii Abalaame ná-GALAGI, nii é la ɓeni ná-nuɓɔɠɔlai ʋa ta ná-wooɠɛɠiladai màliɠii letegi! Nà-siɛi nii zu, Ɠɔoɠɔ GALAGI lia ga ze màliɠii kɛɛɠɛlointi ta-ʋɛlɛi wu.» ");
INSERT INTO tod_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Anzalopoi ɓizɛni, é li dee ʋɔ bɛ, é naama vaiti kpein suɠula ma. ");
INSERT INTO tod_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Eleɓɛka diɛi ta ɠɛni ná, daaseigi ga Laɓan. Laɓan ɓizɛni, é ɠula eteaʋɛ, é li zunui ʋɔ bɛ ziɛungi ɠoba. ");
INSERT INTO tod_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","É balaɠaegi ɠaani, ta balaiti baazeelai Eleɓɛka yeeɠɔdaʋɛti, é naa kpein mɛnini, nii zunui boni ma. É ʋaani zunui tɛi pɔ bɛ, nii é ɠɛni loni ɲɔmɛiti kobaʋɛ, ziɛungi ɠoba. ");
INSERT INTO tod_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","É ɠɛni ma: «Ʋa, ɗɛi Ɠɔoɠɔ GALAGI tuya loai è ʋɛ! Lee vaa zu è yɛsu eteaʋɛ? Gè pɛlɛi wu ɠɛʋele ɓɛtɛa, ta adaʋɛ ʋɛ ɲɔmɛiti ta ɠɛ ná.» ");
INSERT INTO tod_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Botiɠɛ nui lɛɛni pɛlɛi wu, Laɓan ɲɔmɛiti daayeini, é suaiti daazuʋɛ lufai ta ti-laamianigi ve ti ya, é ziɛi ve zunui ya ga ti ɠɔɠɔiti maagba ta maazaa nuiti. ");
INSERT INTO tod_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Naa ʋolu ti daamianigi veeni zea. Kɛlɛ é ɠɛni ma: «Gè la daami wosu pɛ, kɛni nà naa wona, nii é bɛ̀ ga gè bo.» Laɓan ɠɛ ma: «Ʋoluvaawona.» ");
INSERT INTO tod_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","É ɠɛni ma: «Nà ga Abalaame ná-botiɠɛ nui. ");
INSERT INTO tod_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ɠɔoɠɔ GALAGI tuya looʋɛ gola màliɠii ʋɛ, é ɠɛa ga zɛbɛsu nu. Ɠɔoɠɔ GALAGI baalagiti feeʋɛ zea, boliiti ta nikɛiti, walii ta zanugi, botiɠɛ zunuiti ta botiɠɛ anzanuiti, ɲɔmɛiti ta soovalegiti. ");
INSERT INTO tod_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Màliɠii anzai Sala wɔlɔzaɠagai ma, é zunu loun zɔlɔɔgɛ màliɠii ʋɛ. É sɔlɔɔ ganiiti kpein feeʋɛ doun zunui naa ya. ");
INSERT INTO tod_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Màliɠii ɠɛni mà: ‹Ɠonana, è ɠɛ mà, è la anzanu zeɠea dòun zunui ʋɛ Kanaan anzalopoiti saama, niiti gè zeini ti zaama ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kɛlɛ ɗa liizu kɛ̀ɛ ʋɛlɛyeɠei wu, nà-bolodai zu, miná ɠa ɗa anzai zeɠe ná dòun zunui ʋɛ.› ");
INSERT INTO tod_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Gè ɠɛni màliɠii ma: ‹Tanisu anzanui la kɛa, é ʋa ʋilɛ pòlu.› ");
INSERT INTO tod_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","É gòoɠaaʋoteni, é ɠɛ mà: ‹Ɠɔoɠɔ GALAGI nii gè ziaa gaazu ga pagɔ, naa ɠa ná-geezuɠeelai ʋilɛ è ʋolu, toɠa ɗa-ziɛi nɛɛ, ɗa anzai zeɠe dòun zunui ʋɛ nà-bolodai zu, kɛ̀ɛ ʋɛlɛyeɠei wu. ");
INSERT INTO tod_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Siɛgi zu è liizu la nà-bolodai zu, ni ta ɠɛlɛna, ti la anzalopo veeni è ya, ɗa vie minazeɠegi vaa zu, è bosu bɛ̀.› ");
INSERT INTO tod_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Sèeliai ma ziɛungi ma, kɛ̀ɛʋɛ ma: ‹Ɠɔoɠɔ GALAGI, màliɠii Abalaame ná-GALAGI, va bu, è nà-siɛi nɛɛ, nii gè ma ɠani. ");
INSERT INTO tod_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nà ɠa gè loni ziɛungi ɠobaʋɛ, anzalopoi nii é ʋaazu ga é ziɛi zaɠa, nii nà ɠɛ ma é ná-ziɛ liɠii zu ɗɛi tago ve zèa, gè ɓɔɔle, ");
INSERT INTO tod_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ni a gòoɠaaʋotena ga: Ɓɔɔle ɗa ɓɔɠɔi, nà zoo ɓalaa gè ziɛi zaɠa ɗa-ɲɔmɛiti bɛ, naama anzalopoi ɠɛ ga anzanui naa, nii Ɠɔoɠɔ GALAGI devea màliɠii ná-doun zunui ʋɛ.› ");
INSERT INTO tod_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Gè ɠɛɛzu gè ɓe ga ɓɔɛ zìimaʋɛ, Eleɓɛka ɠanu é ʋaazu, ná-ziɛ liɠii zeini kɔma, é yei ziɛungi zu, é ziɛi zaɠa. Kɛ̀ɛʋɛ ma: ‹Nà è maanɛɛnɛzu, ziɛi ve zèa, gè ɓɔɔle.› ");
INSERT INTO tod_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","É ɠaazuvilɛʋɛ ga é ná-ziɛ liɠii maayei, nii é ɠɛni zeini kɔma, é ɠɛ mà: ‹Ɓɔɔlena, nà ziɛi veezu ɓalaa ɗa-ɲɔmɛiti zea, ti ɓɔɔle.› Gè ɓɔɔleʋɛ, é ta ve ɲɔmɛiti zea, ti ɓɔɔle ɓalaa. ");
INSERT INTO tod_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Gè gaazaɠagɛ, gè ɠɛ ma: ‹Ɓɛ ná-doun anzanu ɠa ga ɗe?› É gòoɠaaʋotegɛ ga: ‹Nà ga Ɓetuwɛle ná-doun anzanui, Naɠɔɔl ta Milika ti-lounloin.› Gè balaɠaegi lɔɔʋɛ sokpai ʋa, gè balaiti dɔ zeeiti ba. ");
INSERT INTO tod_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Naa ʋoluma, gè maaʋɛɛʋɛ, gè nɔkɔ Ɠɔoɠɔ GALAGI wu, gè Ɠɔoɠɔ GALAGI mama, nii é ga màliɠii Abalaame ná-GALAGI, nii é loga tùɠɔ wooɠɛɠiladai zu, naa ɠa a kɛ gè màliɠii kɛɛɠɛloin ná-dounloin zeɠe ná-doun zunui ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Niizu, ni wa nuɓɔɠɔlai ɠɛɛzu ta wooɠɛɠiladai màliɠii ʋɛ, à naa wo mà, ni mɔnɔ naa laade, wo naa ɓalaa bo mà, gè li ada ɠili.» ");
INSERT INTO tod_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laɓan ta Ɓetuwɛle ti gooɠaaʋoteni, ti ɠɛ ma: «Niima vai zeɠeʋɛ Ɠɔoɠɔ GALAGI ʋɔ, gi la zooga gi ʋa ɓɔɛ é ʋɔ ga taali ɠili. ");
INSERT INTO tod_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Eleɓɛka ʋɛtɛ, é è ɠakala, seɠe, è lii la, é ɠɛ ga è-maliɠii ná-doun zunui anzai, eɠɛʋelei Ɠɔoɠɔ GALAGI bogai la.» ");
INSERT INTO tod_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Siɛgi zu Abalaame ná-botiɠɛ zunui ti-wooiti mɛnini da, é nɔkɔni zooi ma Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Botiɠɛ zunui wali zɔɔlaiti kulani ta zanu sɔɔlaiti, ta seɠeiti, é ti ve Eleɓɛka ya, é faanɛɛ wolaiti kɛɛni diɛ ʋɛ ta dee ɓalaagi. ");
INSERT INTO tod_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Naa ʋoluma, tɔ-o, maazaa nuiti-yo, ti daamii woni, ti ɓɔɔle, ti ɲi ná. Sobui, siɛgi zu ti wuzeɠeni la, botiɠɛ zunui ɠɛni ma: «À yeeɓe bà niina, gè ɠale ma màliɠii ʋɔ bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Eleɓɛka diɛ ta deeni ti ɠɛni ma: «Ɓɛ dɛ anzalopoi yɛ gi ʋa yeeɠɛɠala laawu, folo puugɔ ɠɛɠala, naa ʋolu wa li niina.» ");
INSERT INTO tod_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kɛlɛ é ti wooɠaaʋoteni, é ɠɛ ma: «À mina mà volo li, tɔɔzei Ɠɔoɠɔ GALAGI nà-siɛi nɛa. À yeeɓe bà, gè li, gè ɠale ma màliɠii ʋɔ bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ti ɠɛni ma: «Ade anzalopoi lolina, ade gaazaɠa tɔ ɓɔɠɔi.» ");
INSERT INTO tod_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ti Eleɓɛka lolini, ti ɠɛ ma: «Ɗa pɔ wo li, wa zunui nii?» É ti wooɠaaʋoteni, é ɠɛ ma: «Ungo, gá li.» ");
INSERT INTO tod_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ti vaani bu ga ti-ʋaazeelai Eleɓɛka li ta anzanui nii é ɠɛni sosu, ta Abalaame ná-botiɠɛ zunui, é ʋɛɛ ná-nuiti ba, ti ɠɛni polu. ");
INSERT INTO tod_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ti tuya looni Eleɓɛka ʋɛ, ti ɠɛ ma: «Ɗɛi è ga gi-ʋaazeelai, ɗa ɠɛ ga waawaagiti ti-lee! È-mavofodai zobo sɔlɔɔ siliɲɔɠɔiti ma faan!» ");
INSERT INTO tod_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Eleɓɛka wuzeɠeni ta ná-botiɠɛ anzanu loungoiti, ti zei ɲɔmɛiti kɔma, ti ʋilɛ zunui ʋolu, ti ɗa li. Botiɠɛ zunui Eleɓɛka zeɠeni, é lii la. ");
INSERT INTO tod_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Izaake ʋaani, é zeɠe Laɠayi-Loyi ɠɔlɔyeɠei ʋɔ bɛ, lɛkpɛmaʋɛ nu yeezazuʋɛ yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kpɔkɔmaʋɛ ta, Izaake ɠulani, é ɗa ziɛziɛ dɔɓɔi zu, é ɠaazuwuzeɠeni, é wɛlɛ, é ɲɔmɛiti kaa, ti ɗa ʋa. ");
INSERT INTO tod_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Eleɓɛka ɠaazuwuzeɠeni ɓalaa, é Izaake ɠa, é zeɠe ɲɔmɛi ɠɔma, é ʋilɛ. ");
INSERT INTO tod_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","É ɠɛni botiɠɛ zunui ma: «Ɓɛ ɠa é ga zunui tɛi, é dɔɓɔi zu, é ʋaazu ade laaɠomisu?» Botiɠɛ zunui gooɠaaʋoteni, é ɠɛ ma: «Màliɠii ʋe.» Gaamago nɔ, é ná-ɓazai ʋɛɛni ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Botiɠɛ zunui faiti kpein boni Izaake ma, niiti é ti ɠɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Naa ʋolu, Izaake loni Eleɓɛka luɠɔ, é lii la dee Sala ná-seɠe ɠotai wu. É Eleɓɛka zeɠeni, naa ɠɛ ga anzai, é nɛɛni ʋɛ. Pele ɠana Izaake gaanɛɛnɛi zɔlɔɔni da, balaga ʋoluma dee ma. ");
INSERT INTO tod_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abalaame anzai ta zeɠeni mɔnɔ, nii daaseigi ɠɛni ga Ketula. ");
INSERT INTO tod_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Dointi é ti zɔlɔɔni bɛ ti-laaseigiti ti ɠɛni ga: Zimelan, Yokesan, Medan, Madiyan, Yisiɓake, ta Suwa. ");
INSERT INTO tod_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokesan Saɓa ta Dedanni sɔlɔɔni. Dedan mavofodaiti ti ɠɛni ga: Asuul nuiti, Letuse nuiti, ta Leyume nuiti. ");
INSERT INTO tod_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madiyan mavofodaiti ti ɠɛni ga: Efa, Efɛɛl, Enɔke, Aɓida, ta Eledaa. Niima nuiti pɛ ti ɠɛni ga Ketula mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abalaame yeaɠɔligiti kpein feeni Izaake ya. ");
INSERT INTO tod_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Anza ɠiligiti niiti ti la ɠɛni vuluni ga zɔiti kɛʋele, é vebɛaniiti feeni ti-loun zunuiti bɛ. Kɛai ma vulua dɛ, é ti leʋeni folo ɠulazu ʋelei, é ti maaɠooza ná-doun zunui Izaake ʋa. ");
INSERT INTO tod_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abalaame zii ma voloi kpein ge ɠɛni ga kona ungila kona ʋuulɔfela maazu lɔɔlu (175). ");
INSERT INTO tod_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abalaame yii looni, é zaani pɔlɔzaɠaga ʋoluma undaanɛɛi zu, é lɛbini gola sii zuɠooza, naa ʋolu é liini mɛmɛwolani pɔ ti zaai. ");
INSERT INTO tod_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ná-doun zunuiti Izaake ta Isemayɛle ti maaɠuluni Makepela ʋugi zu, Efelon ná-kpalagi zu, Ɠɛte nui Soɠaal ná-doun zunui, Mamelé letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Naama ɓalagi ɠa Abalaame geyani Ɠɛte nuiti ma. Miná ɠa Abalaameni ta anzai Sala ti maaɠuluni ná. ");
INSERT INTO tod_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abalaame zaa ʋoluma, GALA ge tuya looni ná-doun zunui Izaake ʋɛ, é ɠɛni zeini Laɠayi-Loyi ɠɔlɔyeɠei ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Abalaame ná-doun zunui Isemayɛle mavofodai ɠaa, tɔ ɠa Agaal, Ezipete anzanui é ga Sala ná-duɔ anzanui sɔlɔɔni Abalaame ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isemayɛle ná-doun zunuiti daaseigiti kaa, eɠɛʋelei ti-mavofodaiti ti la: Neɓayɔte, Isemayɛle ná-doun zunu mɔungi, ta Kedaal, Adaɓeyɛle, Miɓisame, ");
INSERT INTO tod_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misema, Duma, Masa, ");
INSERT INTO tod_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Ɠadade, Tema, Yetuul, Nafise, ta Kedema. ");
INSERT INTO tod_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isemayɛle ná-doun zunuiti ta ti-laaseigiti kana, eɠɛʋelei ta-ɠwɛpelegiti ta ti ʋuu ʋeleiti ti la. Kundiɠi puugɔ maazu felegɔiti (12) kaa, ti ɠɛni ta-nuɓusɛiti unda. ");
INSERT INTO tod_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isemayɛle zii ma voloi kpein ge ɠɛni ga kona ungila puusaʋagɔ maazu lɔfela (137). Zii looni, é za, é li mɛmɛwolani pɔ ti zaai. ");
INSERT INTO tod_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Isemayɛle mavofodaiti ti zeini, é zo Ɠavila, eyɛsu é zeeli Suul, Ezipete yooi letema ʋelei, nu ɗa ɠɛna lia ga Asiili ʋele. Ti zeɠeni ti-ɠɛɛlointi pɛ ba, ti zei yɛ. ");
INSERT INTO tod_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abalaame ná-doun zunui Izaake mavofodai ɠaa: Izaake kɛɛɠɛ ɠɛni ga Abalaame. ");
INSERT INTO tod_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Izaake ná-konagi ɠɛni ga puunaanigɔ (40), siɛgi zu é Laɓan baazeelai Eleɓɛka zeɠeni la ga anzai, Alame nui Ɓetuwɛle ná-doun anzanui, nii é Padan-Alame. ");
INSERT INTO tod_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Izaake Ɠɔoɠɔ GALAGI maanɛɛnɛni anzai ná-faa zu, mazɔlɔɔ é ɠɛni ga doun zɔlɔɔtala nu. Ɠɔoɠɔ GALAGI gooɠaaʋoteni, anzai Eleɓɛka kogi zeɠeni. ");
INSERT INTO tod_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Dointi ti ɠɛni ziɠazu ɓɔɠɔ ʋa koozu, é ɠɛni ma: «Leeni ɠa é ɠɛɛzu ga ze?» É liini, é Ɠɔoɠɔ GALAGI ɠaazaɠa. ");
INSERT INTO tod_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ɠɔoɠɔ GALAGI ɠɛni ma: «Zii felegɔ ɠa é è ɠoozu, nuɓusɛiti ma zii felegɔ ɠa ɠaaɠwɛɛzu, ta ɠɛna zɔlɔɔga, ti ɠula è ɠoozu. Gilagi zɛbɛi ɠa wɔɔlɔ é leʋe zɔi ʋa, nu ɠitei ɠa lɔ loungoi yeezu.» ");
INSERT INTO tod_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Doun zɔlɔɔ foloi zeeliai ma, ti kaani ga yoogiti ka ti ɠɛni koozu. ");
INSERT INTO tod_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ma mɔungi é ʋaani, maaɓɔikpɔini, deɠai ɠɛ ma eɠɛ sua ɠɔlɔ. Ti daaseigi ʋɛɛni ga Ezawu. ");
INSERT INTO tod_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Naa ʋoluma, deɠei zɔlɔɔni, zeei Ezawu ɠɔɠɔ libiligi zogai. Ti daaseigi ʋɛɛni ga Zakɔɓe. Kona ʋuulɔzita (60) ɠa Izaake kɛɛni kpein, ti zɔlɔɔ siɛgi zu. ");
INSERT INTO tod_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Doun zunu felegɔi niiti ti kulasui woni. Ezawu ɠɛni ga dosoi zeeletegai, ta dɔɓɔ ziɛ nui, kɛlɛ Zakɔɓe ɠɛni ga zunui ná-fai ɠaalɛiɗai, é nɛɛni bɛ ga é yɛ nɔ seɠe ɠotaiti bu. ");
INSERT INTO tod_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izaake Ezawu nɛɛni ʋɛ, tɔɔzei dɔɓɔ zuai nɛɛni bɛ. Kɛlɛ Eleɓɛka Zakɔɓe nɛɛni ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Foloi ta, Zakɔɓe ɠɛai ma tɔɠɔi ɓɔlɔzu, Ezawu zeɠeni dɔɓɔi zu, gola ɓɔlɔai. ");
INSERT INTO tod_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ezawu ɠɛni Zakɔɓe ma: «Tɔɠɔ ɓɔi kpɔlɔi nii ta ve zèa, gè mi, mazɔlɔɔ kpɔ̀lɔʋɛ gola.» Naa ɠa é kɛɛni ti Edɔme laaseigi ʋɛɛni la Ezawu ʋa. ");
INSERT INTO tod_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Ɗa-loun mɔun tosuʋɛ ʋɔdi mà dɛ.» ");
INSERT INTO tod_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezawu ɠɛni ma: «Wɛlɛ, nà ga ʋa zaazu ga pului, naama loun mɔun tosuʋɛ ɠa leeni ɠɛ bɛ̀?» ");
INSERT INTO tod_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Zakɔɓe ɠɛni ma: «Ɠonana dɛ bɛ̀.» Ezawu ɠonani bɛ, é ná-doun mɔun tosuʋɛ ʋɔdi Zakɔɓe ma. ");
INSERT INTO tod_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Názu ɠa Zakɔɓe ɓului ta tɔɠɔ ɓɔlɔiti feeni la Ezawu ya. É daamii woni, é ɓɔɔle. Naa ʋolu é wuzeɠeni, é li. Zekana Ezawu doun mɔun tosuʋɛ ʋɛlɛʋɛlɛni da. ");
INSERT INTO tod_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Pului taɠili ge looni zooi zu, é ɠula zɔi ʋolu, é looni Abalaame ná-siɛgi zu. Izaake liini Gelaal, Filisiti nuiti ta-masagi Aɓimelɛke ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ɠɔoɠɔ GALAGI ɠulani bɛ kɛlɛma, é ɠɛ ma: «Mina yei Ezipete yooi zu, kɛlɛ zei zooi naa zu, nii gè dɛɛzu ga ɗe. ");
INSERT INTO tod_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Yeeɠɛɠala ɠɛ niima yooi zu. Nà yɛ è ʋa, gè tuya loo è ʋɛ, mazɔlɔɔ nà niima you yɔɠɔzuʋɛti kpein feezu è ʋɛ, wa è-mavofodai. Nà nà-minazeɠegi zo kpaan, nii gè kɛɛni è-ɠɛɛ Abalaame ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nà è-mavofodai mɔin su, eɠɛ geeɠɔlɔgi ma zomideɠaiti, nà niima you yɔɠɔzuʋɛti kpein fe è-mavofodai ya. Eteai zu zii kpein ka tuyai zɔlɔɔ è-mavofodai maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Tɔɔzei Abalaame gòoi zoni, é nà-deveiti so, ta tɛnɛgiti gè ti woni la, ta nà-tɔgiti.» ");
INSERT INTO tod_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Naa ɠa é kɛɛni, Izaake zeini la Gelaal. ");
INSERT INTO tod_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Siɛgi zu naama adaʋɛ nuiti ti ɠɛni gaazaɠagi wosu da, é lo anzai ʋa, é ɠɛni ɠɛɛzu ti ma: «Bàazeelai ʋe.» É ɠɛni luazu ga a ɠɛɛna anzai ʋe, náʋɛ nuiti ti mina paa Eleɓɛka ná-faa zu, tɔɔzei gola ʋani. ");
INSERT INTO tod_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Tɛi ná-sei yeeɠɛɠalai zu ɠɛni ɠoozazu náʋɛ, foloi ta ɠɛni de Filisiti nuiti ta-masagi Aɓimelɛke wɛlɛni fenɛtɛlɛi la, é Izaake ɠa ta anzai Eleɓɛka, ti ɗa zeeʋoegi ɠɛ. ");
INSERT INTO tod_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Aɓimelɛke Izaake lolini, é ɠɛ ma: «Gaamai zu, è-anzai ʋe! Lee vaa zu è ɠɛni ma: ‹Bàazeelai ʋe›?» Izaake gooɠaaʋoteni, é ɠɛ ma: «Kpɔ̀ɛʋɛ ɠana, nii a kɛ gè mina za maaʋele zu.» ");
INSERT INTO tod_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Aɓimelɛke ɠɛni ma: «Lee ɠa è kɛai ga giye? Ná tago nɔ ɠɛa de nuɓusɛiti saama, zunui taɠila ge ʋa la ga è-anzai, è ɠɛa ʋaazu gi ɠɛɛzu ga sɔba nuiti.» ");
INSERT INTO tod_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Aɓimelɛke niima levei veeni nuɓusɛiti kpein zea ga: «Nu nɔpɛ a faa ɲɔu ɠɛɛna ga zunui tɛi ɓaa anzai, ta naama nui ʋaa.» ");
INSERT INTO tod_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izaake tii ɠɛni zooi naa zu, é ɓɛtɛ, é ma ʋɛɛda ungila (100) sɔlɔɔni naama ɠonagi, mazɔlɔɔ Ɠɔoɠɔ GALAGI tuya looni bɛ. ");
INSERT INTO tod_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Zunui nii ɓɛtɛni, é ɠɛni liizu nɔ ga ɓɛtɛa, eyɛsu é ɠɛ ga kpɛtɛ nu wola. ");
INSERT INTO tod_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Togani ɓulugiti ti ɠɛni zea, nikɛiti, baalagiti, boliiti, ta botiɠɛ nu mɔinmɔingiti. Filisiti nuiti ti ɠɛni toloi ɠulazu la. ");
INSERT INTO tod_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kɔlɔyeɠeiti kpein kɛɛɠɛ Abalaame ná-botiɠɛ nuiti ti ti wɔɔni ná-siɛgi zu, ti naati daaveni ga pɔlɔi. ");
INSERT INTO tod_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Aɓimelɛke ɠɛni Izaake ma: «Liina, è zeɠe gi ʋɔ bɛ, mazɔlɔɔ é yeeɠaaɓa, é leʋe gi ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Izaake zeɠeni ná, é li, é ʋuuzuʋɛ ɠɛ ga Gelaal nɛmɛi zu, miná ɠa é zeini ná. ");
INSERT INTO tod_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Izaake ziɛyeɠeiti bɔɔni ʋolu ga niinɛ, niiti ti wɔɔni kɛɛɠɛ Abalaame ná-siɛgi zu, niiti Filisiti nuiti ti ti laaveni Abalaame ná-saai ʋoluma. É naama laaseigiti nɔ ʋɛɛni ti ʋa, niiti kɛɛɠɛ ti ʋɛɛni ti ʋa. ");
INSERT INTO tod_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Izaake ná-botiɠɛ nuiti ti ta wɔɔni mɔnɔ nɛmɛi zu, ti ziɛungi ɠaani ná. ");
INSERT INTO tod_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Baala makɛ nuiti ti ɠɛni Gelaal, ti kpɔɛi ʋɛɛni Izaake ná-baala makɛ nuiti ba, ti ɠɛ ma: «Ziɛi ɠa ga gɔnɔ!» É ziɛyeɠei laasei pɛɛni ga Esɛke (nii poluʋɛ ga «maaɠaalii»), tɔɔzei ti kpɔɛi ʋɛɛni ba ziɛyeɠei ná-faa zu. ");
INSERT INTO tod_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ná-botiɠɛ nuiti ti ziɛyeɠe ɠili bɔɔni, nii ti sakpeni mɔnɔ ná-faa zu, é daasei pɛɛni ga Sitina (nii poluʋɛ ga «sakpegi»). ");
INSERT INTO tod_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","É zeɠeni miná, é li, é ziɛyeɠei taɠili bɔ, niigi kpɔɛ vaa la ɠɛni wuzeɠeni, é ʋa lo ba. É naa laasei pɛɛni ga Leɠoɓɔte (nii poluʋɛ ga «suwɔɔlɔa»), mazɔlɔɔ é ɠɛni ma: «Niizu, Ɠɔoɠɔ GALAGI suwɔɔlɔa gi ʋɛ, gi undaa ɠa nɛ zooi zu niina.» ");
INSERT INTO tod_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","É zeɠeni ná, é lɛ ga Ɓeel-Seɓa ʋele. ");
INSERT INTO tod_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ɠɔoɠɔ GALAGI ɠulani bɛ kɛlɛma naama ɓidii, é ɠɛ ma: «Nà ɠa gè ga è-ɠɛɛ Abalaame ná-GALAGI. Mina lua, mazɔlɔɔ nà è ʋa. Nà tuya loozu è ʋɛ, gè è-mavofodai mɔin su nà-botiɠɛ nui Abalaame maaʋele ma.» ");
INSERT INTO tod_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Izaake zalaɠa ɠulazuʋɛ loni náʋɛ, é wooɠula Ɠɔoɠɔ GALAGI ma. É ná-seɠe ɠotai loni ná ɓalaa. Ná-botiɠɛ nuiti ti ziɛyeɠe ɠila bɔɔni ná. ");
INSERT INTO tod_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Aɓimelɛke ʋaani pɔ bɛ, é zeɠe Gelaal, ta ná-tɛnɛbo nui Aɠuzate, ta Pikɔle, nii é ɠɛni ga ná-kɔɔɠɔ ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izaake ɠɛni ti ma: «Lee vaa zu wo ʋaazu pɔ̀, tama wo ɗa wɔ̀inzeɠe, wo ɗa kpɛ̀ wo ʋɔ bɛti?» ");
INSERT INTO tod_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ti gooɠaaʋoteni, ti ɠɛ ma: «Gá pɛtɛsu ga Ɠɔoɠɔ GALAGI ɠa è ʋa. Naa ɠa é ba, gi ɠɛɛzu, minazeɠegi ɠɛ ade yɔɠɔzu, gá-o, ɗa-o, ade minazeɠe ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ɗa ɠonazu ga è la faa ɲɔu nɔpɛ kɛa ga giye, eɠɛʋelei gi la è zopele ɲɔuni la ɲɛgɛlɛin, kɛni faa ʋagɔi nɔ ɠa gi kɛa è ʋɛ, gi è yɛni ná, è li ziilɛigi zu. Ɗɛi è tuyai zɔlɔɔgai Ɠɔoɠɔ GALAGI ya.» ");
INSERT INTO tod_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Izaake daamii ɠɛʋele ɓɛtɛni ti ʋɛ. Ti laamiini, ti ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ti wuzeɠeni sobuzobui, ti ɠona ɓɔɠɔ ʋɛ. Naa ʋolu Izaake valini ti ma, ti li ziilɛigi zu. ");
INSERT INTO tod_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Naama voloi nɔ zu, Izaake ná-botiɠɛ nuiti ti ʋaani, ti ʋoluvaawo ma, é lo kɔlɔyeɠei ʋa, ti ɠɛni bɔɔzu, ti ɠɛ ma: «Gi ziɛi ɠaaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izaake daasei pɛɛni ga Siɓa (nii poluʋɛ ga «minazeɠegi»). Naa ɠa é ba, ti taai laasei pɛai la ga Ɓeel-Seɓa (nii poluʋɛ ga «minazeɠe kɔlɔyeɠei»), eyɛsu zaaɠaza. ");
INSERT INTO tod_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ezawu ná-konagi ɠɛai ma ga puunaanigɔ (40), é Ɠɛte nui Ɓeyeli ná-doun anzanui Zudite zeɠeni ga anza, ta Ɠɛte nui Elon ná-doun anzanui Ɓasemate. ");
INSERT INTO tod_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ti felegɔ pɛ ti ɠɛni Izaake ta Eleɓɛkani ziiɓɔlɔzu ti ɠoozu. ");
INSERT INTO tod_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izaake ɠɛni wɔlɔzaɠasu, gaazuʋɛti maa ɠɛni ɓidizu, é la mɔ ɠɛni wozaɠaazu ɲɛgɛlɛin. É ná-doun zunu mɔungi Ezawu lolini, é ɠɛ ma: «Dòun zunu!» Naa gooɠaaʋoteni, é ɠɛ ma: «Nà ɠaa!» ");
INSERT INTO tod_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izaake ɠɛni ma: «Nà ɠaa, gè wɔlɔzaɠaga, gè la zaa volo ɠwɛɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ɗa-loso zɔɔlaiti ti ga ɗa-mɛɛn ʋuu ɓɔlɔi, ta ɗa-mɛɛn ɠaeiti, ti zeɠena, è li dɔɓɔi zu, è sua ɠaiziɛ bɛ̀. ");
INSERT INTO tod_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Daamiani nɛɛnɛ kpɛtɛ bɛ̀, eɠɛʋelei nɛai la bɛ̀, è ʋaa la pɔ̀, gè mi, naa ɠa a kɛ gè tuya loo è ʋɛ pɛ, gè ʋa leɠa za.» ");
INSERT INTO tod_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Eleɓɛka ɠɛni naa mɛnisu, nii Izaake ɠɛni bosu ná-doun zunui Ezawu ma. Ezawu liini dɔɓɔi zu sua ɠaiziɛzuʋɛ, é ʋa ʋaa la. ");
INSERT INTO tod_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Eleɓɛka ɠɛni ná-doun zunui Zakɔɓe ma: «Wɛlɛ, gè è-ɠɛɛ woomɛnigɛ, é ɗa ɓɔɛ è-liɛ Ezawu ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‹Ʋa bɛ̀ ga sua, è daamiani nɛɛnɛ kpɛtɛ bɛ̀, nii nà mi, nà tuya loozu è ʋɛ Ɠɔoɠɔ GALAGI ɠaazu pɛ, gè ʋa leɠa za.› ");
INSERT INTO tod_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Woilo dɛɛ gòoi ma, dòun zunu, nii gè bosu è ma, è naa nɔ ɠɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Li bɛ̀ togani ɓulugi zaama, è boli yiʋo ʋagɔ felegɔ zo, è ʋaa la, nà ti ɓɛtɛzu è-ɠɛɛ ʋɛ ga daamiani nɛɛnɛgi, eɠɛʋelei nɛai la bɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","È lii la è-ɠɛɛ ʋɔ, é mi, nii a kɛ é tuya loo è ʋɛ pɛ, é ʋa leɠa za.» ");
INSERT INTO tod_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Zakɔɓe dee wooɠaaʋoteni, é ɠɛ ma: «Ungo, kɛlɛ dìɛ Ezawu ɠa ga deɠaleɠa nu, nɔ̀un nà, gè la ga naama nu. ");
INSERT INTO tod_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Tanisu kɛ̀ɛ ɠa yeeʋɛɛpɛɛ bà, nà ɠɛ gaazu ga woya nu, náma su, nà foovooi maaloli ɓɔɠɔ ma, tuyai ʋotogi zu.» ");
INSERT INTO tod_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Dee ɠɛni ma: «Dòun zunu, naama voovooi yɛ ga ze! Woilo nɔ gòoi ma, è li, è ʋa ga tiye pɔ̀.» ");
INSERT INTO tod_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Zakɔɓe liini, é ti zeɠe, é ʋa ga tiye dee ʋɔ. Naa daaɠolii woni, eɠɛʋelei nɛai la kɛɛɠɛ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Naa ʋolu, Eleɓɛka ná-doun zunu mɔungi Ezawu ná-seɠeiti seɠeni, niiti ti wola ʋaga ɠɛni de, ti ɠɛni pɛlɛi wu, é ti loo ná-doun zunui loungo gelei Zakɔɓe ɠɔba. ");
INSERT INTO tod_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","É zeeiti ta kɔgi maavelevele ga boli yiʋoi ma ɠɔlɔiti, tɔɔzei deɠa la ɠɛni náti ma. ");
INSERT INTO tod_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Daamiani nɛɛnɛgi ta ɓului niiti é ti ɓɛtɛni, é naati feeni ná-doun zunui Zakɔɓe ya. ");
INSERT INTO tod_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Naa liini kɛɛɠɛ ʋɔ bɛ, é ɠɛ ma: «Kɛ̀ɛ!» Izaake ɠɛ ma: «Nà ɠaa! Ɓɛ ɠa é ga ɗe, dòun zunu?» ");
INSERT INTO tod_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Zakɔɓe kɛɛɠɛ wooɠaaʋoteni, é ɠɛ ma: «Nà ga Ezawu, è-loun zunu mɔungi. Gè naa ɠɛa, nii è bogai mà. Nà è maanɛɛnɛzu, wuzeɠe, è zei, è nà-sua ɓɛtɛai mi, naa ɠa a kɛ è tuya loo bɛ̀.» ");
INSERT INTO tod_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izaake ɠɛni ná-doun zunui ma: «È kɛɛʋɛ ɠale, dòun zunu, è suai ta zɔlɔɔgai gaamanɔ?» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Ɠɔoɠɔ GALAGI ɗa-ƓALAGI ɠa é ʋaa la pɔ̀.» ");
INSERT INTO tod_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izaake ɠɛni Zakɔɓe ma: «Maaɓuɠa lɛɛ bà, dòun zunu, gè yeevɔɔɠu è ʋa, gè ɠɛ kwɛɛ, ni ɗa ga dòun zunui Ezawu, ɓaa ni é la ga tɔun.» ");
INSERT INTO tod_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Zakɔɓe maaɓuɠani kɛɛɠɛ Izaake ʋa, naa yeeʋɛɛpɛɛ ba, é ɠɛ ma: «Kpɔɛ ʋelei ɠa ga Zakɔɓe ɓɔɛ ʋelei, kɛlɛ zeeiti ta ga Ezawu yeeiti.» ");
INSERT INTO tod_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","É la ɠɛni ɠwɛɛsu ɠaani ba, tɔɔzei deɠai ɠɛni zeeiti ma, eɠɛ diɛ Ezawu yeeiti. É tuya looni bɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","É gaazaɠani dɛ, é ɠɛ ma: «Ɗa ɠa nɛi è ga dòun zunui Ezawu ɓaa?» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Nà ʋe.» ");
INSERT INTO tod_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izaake ɠɛni ma: «Dòun zunu, ɗa-zuai ta veena zèa, naa ɠa a kɛ gè mi, gè tuya loo è ʋɛ.» Zakɔɓe feeni zea, é mi, é ʋa pɔ ga dɔɔi ɓalaa, é kpɔle. ");
INSERT INTO tod_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Naa ʋolu kɛɛɠɛ Izaake ɠɛni ma: «Dòun zunu, maaɓuɠa bà, è nɛ̀ɛnɛ ga daaʋɛ komagai.» ");
INSERT INTO tod_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Zakɔɓe maaɓuɠani ba, é nɛɛnɛ ga daaʋɛ komagai. Izaake ná-seɠeiti makugi mɛnini. Naa ʋoluma, é tuya looni bɛ, é ɠɛ ma: «Ungo, dòun zunui makugi ɠɛɛʋɛ eɠɛ kpalagi makugi, nii Ɠɔoɠɔ GALAGI tuya loai bɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","GALA ge geeɠɔlɔgi ma nɔɗai ve è ya, ta zooi ma ɠulanumai, é moloi ta dɔɔi ve ga mɔinɗa. ");
INSERT INTO tod_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nuɓusɛiti ti ɠolo è ʋɛ, ziiti ti boti ɠɛ è ʋɛ. È ɠɛ ga è-ɠɛɛleaiti ti-maliɠii, è-leelointi ti boti ɠɛ è ʋɛ. Zɔi a è voovo, naa ɠa voovo, zɔi a tuya loo è ʋɛ, tuya ɠa naa ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Izaake ɓeni nɔ ga tuya loo Zakɔɓe ʋɛ, Zakɔɓe zeɠezuʋɛ nɔ feya kɛɛɠɛ Izaake ʋɔ bɛ, diɛ Ezawu ɗa unkula, é zeɠe doso ziɛ bosuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Tɔ ɓalaagi é daamiani nɛɛnɛgi ɠɛʋele ɓɛtɛni, é ʋaa la kɛɛɠɛ ʋɔ bɛ, é ɠɛ kɛɛɠɛ ma: «Kɛ̀ɛ, wuzeɠena, è è-loun zunui ná-suai ta mi, naa ɠa a kɛ è tuya loo bɛ̀.» ");
INSERT INTO tod_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kɛɛɠɛ Izaake ɠɛ ma: «Ɓɛ ɠa é ga ɗe?» É gooɠaaʋoteni, é ɠɛ ma: «Nà ga è-loun zunu mɔungi Ezawu.» ");
INSERT INTO tod_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Izaake ɠɛni wola unga wuulee, é ɗa wola ɓali, é ɠɛ ma: «Ɓɛ ɠa ga naa deɠɛmu, nii é suai zogai, é ʋaa la pɔ̀? Gè ti pɛ ta miai, è ɠɛɛzu è ʋa, gè tuya loa bɛ. Toɠa tuyai zɔlɔɔ.» ");
INSERT INTO tod_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Siɛgi zu Ezawu kɛɛɠɛ wooiti mɛnini da, é ɓainni ga woo wola, é ziiɠaawana ɓee wolai looni, é ɠɛ kɛɛɠɛ ma: «Kɛ̀ɛ, tuya loo bɛ̀, nà ɓalaagi!» ");
INSERT INTO tod_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Izaake ɠɛni ma: «È-leɠei ʋaaʋɛ ga yaavai, é ɗa-luyai zeɠe.» ");
INSERT INTO tod_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezawu ɠɛni ma: «Tɛi daaseigi ʋɛai ga Zakɔɓe, naa ɠa é yàavaai la ná zeizu ɠɛ fele ɓaa? É nà-doun mɔun tosuʋɛ zeɠea, é ʋaa mɔnɔ niizu, é nà-tuyai zeɠe!» É ɠɛni kɛɛɠɛ ma: «È la tuyai ta makɛni bɛ̀ ɓaa?» ");
INSERT INTO tod_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izaake ɠɛni Ezawu ma: «Wɛlɛ, gè seiɗa ga è-maliɠii, gè kɛɛɠɛlointi kpein kɛa ga ná-botiɠɛ nuiti, gè moloi ta dɔɔi vea zea. Lee ɠa deɠɛmu nà zoo gè kɛ è ʋɛ, dòun zunu?» ");
INSERT INTO tod_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezawu kɛɛɠɛ wooɠaaʋoteni, é ɠɛ ma: «Naama luya ɠilagi nɔ ɠa é è ya ɓaa, kɛ̀ɛ? Nà ɓalaa tuya loo bɛ̀, kɛ̀ɛ!» Ezawu tɔɔzeini ga ɓainga, é ɗa wɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kɛɛɠɛ Izaake gooɠaaʋoteni, é ɠɛ ma: «Pɛtɛ, è-zeizuʋɛ ɠa ʋala zooi ma ɠulanumai ma, ta geeɠɔlɔgi ma nɔɗagi ma. ");
INSERT INTO tod_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ɗa-woɠa zɔkpɔi ɠa a ɠɛ ga è-ɠɔnɔ gaiziɛ anii, ɗa ɠɛ ga è-ɠɛɛloin ná-botiɠɛ nui, kɛlɛ ɗa ɠɛna ziɛziɛga ɓɔɠɔ yeema, ɗa ná-unbawului ɠaleɠale, è kula ɓɔɠɔ ɠɔba.» ");
INSERT INTO tod_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezawu Zakɔɓe wɔinzeɠeni, tɔɔzei tuyai ʋa kɛɛɠɛ boni bɛ, é ɗa ɠɛ yiimaʋɛ: «Kɛ̀ɛ zaa voloi maa ɠana ɓuɠa, nà dèɠei Zakɔɓe ʋaa naama yeei.» ");
INSERT INTO tod_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ti Eleɓɛka ná-doun zunu mɔungi Ezawu wooiti boni ma. É ná-doun zunui loungo gelei Zakɔɓe lolini, é ɠɛ ma: «Wɛlɛ, è-liɛ Ezawu ɠa ɠɛɛzu é potokulai ɠɛ, é è ʋaa. ");
INSERT INTO tod_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Woilo gòoi ma niizu, dòun zunu! Wuzeɠe, è ʋela, è li dìɛ Laɓan ʋɔ bɛ Ɠalan yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","È yɛ koba yeeɠɛɠala laawu, eyɛsu è-liɛ yiimaalɛi. ");
INSERT INTO tod_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Siɛgi zu è-liɛ ná-ziiɠaawanai ɓudɛzu la è maazu, é yeema naa ma, nii è kɛai la, nà è ɠaaɠale ma naazu niina. Leeni vaa zu nà ʋala wo felegɔ ma ʋɔɔma, folo ɠilagi zu?» ");
INSERT INTO tod_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Eleɓɛka ɠɛni Izaake ma: «Zɛnvui wɔinzeɠea mà, Ɠɛte ná-doun anzanui niiti ta-vaa zu. Ni Zakɔɓe ɓalaa ka zooi niizu anzanui ta zeɠena, zɛnvui ɠa bɛ̀ ga leeni názu?» ");
INSERT INTO tod_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Izaake Zakɔɓe lolini, é tuya loo bɛ, é devei nii ve zea, é ɠɛ ma: «Mina anzanu zeɠe Kanaan anzanu lointi saama. ");
INSERT INTO tod_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Wuzeɠena, è li Padan-Alame è-lee kɛɛɠɛ Ɓetuwɛle ʋɔ bɛ, è anza ɠaiziɛ è-ɠɛkɛ Laɓan ná-doun anzanuiti saama, è sei. ");
INSERT INTO tod_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","GALA Zɛbɛi-Pɛ-Maliɠii tuya loo è ʋɛ, é è ɠɛ ga kpuɠu nu, ɗa ɠa ga nuɓusɛ mɔinmɔin mɛmɛwola. ");
INSERT INTO tod_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","É Abalaame ná-tuyai ve è ya, é ʋɛɛ è-mavofodai ʋa, nii a kɛ zooi è zeini su ga seikɔɠɔma nui, è naa zɔlɔɔ, zooi nii GALA ge feeni Abalaame ya!» ");
INSERT INTO tod_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Izaake Zakɔɓe leʋeni ga è li Padan-Alame, Alame nui Ɓetuwɛle ná-doun zunui Laɓan ʋɔ bɛ, Zakɔɓe ta Ezawu ti-lee Eleɓɛka diɛi. ");
INSERT INTO tod_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezawu kaani ga Izaake tuya looni Zakɔɓe ʋɛ, é teʋe Padan-Alame ga é anza zeɠe ná. É mɛnini ɓalaa ga kɛai ma tuya loozu bɛ, é devei nii veeni zea ga: «Mina anza zeɠe Kanaan anzanu lointi saama.» ");
INSERT INTO tod_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","É kwɛɛni ɓalaa ga Zakɔɓe ɠoloni kɛɛɠɛ ta dee ʋɛ, é li Padan-Alame. ");
INSERT INTO tod_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ezawu gaaɠaani ga Kanaan anzanu lointi maayo ge la ɠɛni kɛɛɠɛ Izaake ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ezawu liini Abalaame ná-doun zunui Isemayɛle ʋɔ bɛ. É Isemayɛle ná-doun anzanui Maɠalate zeɠeni ga anzai, nii é ga Neɓayɔte baazeelai, zɔɔma anzaiti poluma ti ɠɛni zea. ");
INSERT INTO tod_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Zakɔɓe zeɠeni Ɓeel-Seɓa, é li Ɠalan. ");
INSERT INTO tod_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","É zeelini adaʋɛ ta, ʋɛ é ɲiini ná, mazɔlɔɔ foloi liini niina. É náʋɛ ɠɔtui ta zeɠeni, é da unbu, é ɲiini naama adaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ná-segi zu, é kaɓagi ɠaani loni zooi ma, nɔungi zeiɗai geei ʋa. Pɛtɛ, GALA ná-geezuɠeelaiti ti ɠɛni lɛɛzu, ti ɗa yeei kaɓagi naa zu. ");
INSERT INTO tod_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Pɛtɛ, Ɠɔoɠɔ GALAGI ɠɛni loni kaɓagi unsuʋɛ, é ɠɛ ma: «Nà ga Ɠɔoɠɔ GALAGI, è-ɠɛɛ Abalaame ná-GALAGI, ta Izaake ná-GALAGI. Zooi nii è laani ma, nà feezu è ʋɛ, wa è-mavofodai. ");
INSERT INTO tod_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","È-mavofodai ɠa ɠɛ eɠɛ zooi ma vufiligi, ná-zooi zu ɠa ɓaɠo, é zo folo ɠulazu ʋelei, é li folo liizu ʋelei, é zo nu ɠɔʋɛzu ʋelei, é li nu yeezazu ʋelei. Eteai ma ʋɛlɛyeɠeiti kpein ta tuyai zɔlɔɔ è maaʋele ma, ta è-mavofodai maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Wɛlɛ, nà ɓɔɠɔi nà è ʋa, nà è makɛ, ʋɛ kpein è liizu ná, nà ʋaazu ga ɗe ʋolu niima yooi zu, mazɔlɔɔ gè la ɠɛlɛa è ʋa ɲɛgɛlɛin, eyɛsu naa kpein daazeeli, nii gè boga è ma.» ");
INSERT INTO tod_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Zakɔɓe wuunni, é ɠula ná-ɲiimɛnii zu, é ɠɛ ma: «Gaamazu Ɠɔoɠɔ GALAGI ɠa niima adaʋɛ, nɔ̀un gè la ɠɛa suɠwɛɛ!» ");
INSERT INTO tod_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","É luani, é ɠɛ ma: «Aɛ, niima adaʋɛ maayikiʋɛ! Ʋɛ ɠa ná ga GALA ná-pɛlɛi, geeɠɔlɔgi ma ziɠidaʋɛ ʋe.» ");
INSERT INTO tod_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Zakɔɓe wuzeɠeni ga sobuzobui, kɔtui nii é daani unbu, é naa zeɠeni, é gaalɔ ga ɠizɛsui, é gulɔi ʋu unsuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","É naama adaʋɛ laasei pɛɛni ga Ɓetɛle (nii poluʋɛ ga «GALA ná-pɛlɛi»), kɛlɛ taai naa laaseigi ɠɛni ga Luze mɔungi zu. ");
INSERT INTO tod_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Zakɔɓe minazeɠeni, é ɠɛ ma: «Ni GALA ga yɛna bà, é màkɛ siɛi nii zu, gè bosu, ni a daamianigiti ta seɠeiti feena zèa, ");
INSERT INTO tod_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ta ni nà ɠalena ma kɛ̀ɛ ʋɛlɛi wu ziilɛigi zu, Ɠɔoɠɔ GALAGI ɠa ɠɛ ga nà-GALAGI naazu. ");
INSERT INTO tod_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kɔtui nii gè gaalɔgai ga ɠizɛsui, naa ɠa ɠɛ ga GALA ná-pɛlɛi. Nii kpein è feezu zèa, nà naama ʋuusiɛi ve è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Zakɔɓe siɛi lɔɔzeini ʋolu, é li folo ɠulazu ʋelei yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","É wɛlɛni yeeta, é kɔlɔyeɠei ɠa dɔɓɔi zu, pɛtɛ, togani ɓulu seizu saʋagɔ ɠɛni ná, ti ɗa looɠo, mazɔlɔɔ naama ɠɔlɔyeɠei ɠa togani ɓulugiti ti ɠɛni ɓɔɔlezu la. Kɔtu wolai ɠa é ɠɛni ga kɔlɔyeɠei lakulugi. ");
INSERT INTO tod_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Siɛgi zu togani ɓulugiti kpein ti ɓena ɠaalɛ ba la ná, ti ɓena kɔtui ɠilikili, ti seɠe ziɛyeɠei laaʋɛ, ta la ziɛi veena togani ɓulugiti zea, ti kɔtui la daazuʋɛ ziɛyeɠei la. ");
INSERT INTO tod_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Zakɔɓe ɠɛni togani makɛ nuiti ma: «Kɛ̀ɛleaiti, mini nu ɠa ga woye?» Ti gooɠaaʋoteni, ti ɠɛ ma: «Gá ga Ɠalan nuiti.» ");
INSERT INTO tod_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","É ɠɛni ti ma: «Wo Laɓan ɠwɛɛ nɛi ɓaa, nii é ga Naɠɔɔl ná-doun zunui?» Ti gooɠaaʋoteni, ti ɠɛ ma: «Uun, gi kwɛɛ.» ");
INSERT INTO tod_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","É ɠɛni ti ma: «Kɛdɛgɛ nɛi ɓaa?» Ti gooɠaaʋoteni, ti ɠɛ ma: «Kɛdɛgɛ, wɛlɛ nuu, ná-doun anzanui Lasɛle ʋa, é ʋaazu ga togani goiti.» ");
INSERT INTO tod_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Zakɔɓe ɠɛni ma: «Wɛlɛ, foloi wɔɔlɔʋɛ dɛ, yeeɠɛɠala la ga nii, ga nu togani ɓulugiti gaalɛ ba. À ziɛi ve togani goiti zea, naa ʋolu, wo li ga tiye ga ti daami wo.» ");
INSERT INTO tod_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ti gooɠaaʋoteni, ti ɠɛ ma: «Gi la zooga, kɛni togani ɓulugi kpein gaa ɠa lɛɛna ba, názu ɠa gá ɗa kɔtui ɠilikili da, é zeɠe ziɛyeɠei laaʋɛ, gi ziɛi ve togani goiti zea.» ");
INSERT INTO tod_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","É yɛni nɔ ɓɔɛzu dɛ ti ʋɔ, Lasɛle ɗa unkula ga kɛɛɠɛ ná-togani goiti, mazɔlɔɔ é ɠɛni ga togani makɛ nui. ");
INSERT INTO tod_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Siɛgi zu Zakɔɓe kɛkɛ Laɓan ná-doun anzanui Lasɛle ɠaani la, ta Laɓan ná-togani ɓulugi, é maaɓuɠani ba, é kɔtui ɠilikili, é seɠe ziɛyeɠei laaʋɛ, é ziɛi ve kɛkɛ Laɓan ná-togani ɓulugi ya. ");
INSERT INTO tod_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Naa ʋolu, Zakɔɓe Lasɛle nɛɛnɛni ga daaʋɛ komagai, é wooɠula, é wɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Zakɔɓe boni Lasɛle ma ga toɠa ga kɛɛɠɛ ná-nu, é ga Eleɓɛka ná-doun zunui. Lasɛle ɓizɛni, é li, é bo kɛɛɠɛ ma. ");
INSERT INTO tod_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laɓan baazeelai ná-doun zunui Zakɔɓe ʋaa vai ma wooi mɛnini nɔ feya, é ɓizɛni, é daaɠomi, é velevele da, é nɛɛnɛ. É loni tuɠɔ, é lii la ná-pɛlɛi wu. Faiti ti ziɛni, Zakɔɓe naati kpein gaalɛɛni la. ");
INSERT INTO tod_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laɓan ɠɛni ma naazu: «Gaamazu, ɗa ga màvofoda ɓɔɠɔɓɔɠɔgi.» Zakɔɓe alu gila kɛɛni Laɓan ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Naa ʋoluma, Laɓan ɠɛni Zakɔɓe ma: «Nà-nui ɠa ga ɗe, ɗa yɛsu botii ɠɛɛzu bɛ̀ ɠana nɔ ɓaa? Nii a ɠɛ ga è-zalai, naa lɛ ga ze.» ");
INSERT INTO tod_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Tama anzanu loun felegɔ ɠɛni Laɓan ya. Ma mɔungi laaseigi ɠɛni ga Lea, loungo gelei laaseigi ɠɛ ga Lasɛle. ");
INSERT INTO tod_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea la ɠɛni wola ʋani, kɛlɛ Lasɛle wola ʋaga ɠɛni de. ");
INSERT INTO tod_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Lasɛle maayo ge ɠɛni Zakɔɓe ʋɛ. É ɠɛni Laɓan ma: «Nà botii ɠɛ è ʋɛ ga kona dɔfela, è-loun anzanui loungo gelei ná-faa zu.» ");
INSERT INTO tod_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laɓan ɠɛni ma: «Yɛ pɔ̀ bɛ, nɛɛʋɛ bɛ̀ ga gè fe è ya, gè ʋa ʋɛ liizu feezu zunu ɠili zea.» ");
INSERT INTO tod_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ʋele ɠana Zakɔɓe botii ɠɛɛni la kona dɔfela zu Lasɛle ná-faa zu, kɛlɛ ti ɠɛni gaazu, eɠɛ foloi tanigaani nɔ, tɔɔzei maayo ge ɠɛni bɛ. ");
INSERT INTO tod_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Naa ʋolu Zakɔɓe ɠɛni Laɓan ma: «Ànzai veena zèa, mazɔlɔɔ nà-botiɠɛ voloi laazeelia, nà pɔ ga gè ʋilɛ polu.» ");
INSERT INTO tod_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laɓan náʋɛ nuiti kpein gaalɛɛni ba, ti daamii ɠoozunɛɛi wo. ");
INSERT INTO tod_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kpɔkɔi zeeliai ma, é ná-doun anzanui Lea zeɠeni, é lii la Zakɔɓe ʋɔ, naa ʋilɛni polu. ");
INSERT INTO tod_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laɓan botiɠɛ anzanui Zilepa zeɠeni, é fe ná-doun anzanui Lea ya, ga naa ɠɛ ga ná-botiɠɛ anzanui. ");
INSERT INTO tod_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ma ɠeelaalaogai ma, Zakɔɓe ɗa wɛlɛ, é Lea ɠa, é ɠɛ Laɓan ma: «Lee ɠa è kɛai ga ze? Lasɛle ná-faa ɠa gè boti ɠɛai la è ʋɔ bɛ. Lee vaa zu è yàavaai?» ");
INSERT INTO tod_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laɓan ɠɛni ma: «Naa la ɗa ga ɠɛa gi ʋɔ bɛ pɔlɔmazu, ga è loungoi ve zini bɛ, nu ɠitei luɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","À dɔɔɠɔi ɠaaɓela wa nii, nà zɔi ɓalaa ve è ya, è botii ɠɛ mɔnɔ pɔ̀ bɛ kona dɔfela ɠiligaa laawu.» ");
INSERT INTO tod_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Zakɔɓe vaani bu, ti dɔɔɠɔi ɠaaɓela ta Lea. Naa ʋolu Laɓan ná-doun anzanui Lasɛle zeɠeni, é fe Zakɔɓe ya ga anza. ");
INSERT INTO tod_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laɓan botiɠɛ anzanui Ɓiliɠa zeɠeni, é fe ná-doun anzanui Lasɛle ya ga ná-botiɠɛ anzanui. ");
INSERT INTO tod_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Zakɔɓe Lasɛle ɓalaa daani ʋolu, nii gola nɛɛni bɛ, é leʋe Lea ʋa. É botii ɠɛɛni mɔnɔ Laɓan ʋɔ bɛ kona dɔfela ɠiligaa laawu. ");
INSERT INTO tod_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tɛi Ɠɔoɠɔ GALAGI kaani ga tiba la ɠɛni Lea ʋa, é naa ɠɛɛni ga kpuɠu nu, Lasɛle ma ge ɠɛni ga doun zɔlɔɔtala nu. ");
INSERT INTO tod_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea kogi zeɠeni, é zunu loun zɔlɔɔ. É daasei pɛɛni ga Luɓɛn, tɔɔzei é ɠɛni ma: «Ɠɔoɠɔ GALAGI nà-ɓɔɠɔmaayeii ʋɛtɛga, sìnigi ɠa nɛ̀ɛʋɛ niina niizu.» ");
INSERT INTO tod_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","É kogi zeɠeni mɔnɔ, é zunu loun zɔlɔɔ, é ɠɛ ma: «Ɠɔoɠɔ GALAGI mɛnigɛ ga tiba la bà, é nii ɓalaa fea bɛ̀.» É naa laasei pɛɛni ga Simiyɔn. ");
INSERT INTO tod_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","É kogi zeɠeni mɔnɔ, é zunu loun zɔlɔɔ, é ɠɛ ma: «Sìnigi ɠa ɠili bà niina niizu, mazɔlɔɔ gè zunu loun saʋagɔ zɔlɔɔga bɛ.» Naa ɠa é kɛɛni ti daasei pɛɛni ga Levi. ");
INSERT INTO tod_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","É kogi zeɠeni mɔnɔ, é zunu loun zɔlɔɔ, é ɠɛ ma: «Nà Ɠɔoɠɔ GALAGI maamusɛzu niina niizu.» Naa ɠa é kɛɛni, é daasei pɛɛni ga Zuda. É ɓeni niina doun zɔlɔɔgi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Tɛi Lasɛle kaani ga é la doun zɔlɔɔsu Zakɔɓe ʋɛ, é toloi ɠulani ga baazeelai, é ɗa ɠɛ Zakɔɓe ma: «Dounɠa ve bɛ̀, ni naa laade, kɛni gè za!» ");
INSERT INTO tod_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Zakɔɓe yiiɠaawanani Lasɛle ma, é ɠɛ ma: «Nà ɠa gè GALA potogi zu ɓaa, é pele leʋesu ɗa-loun zɔlɔɔgi luɠɔ?» ");
INSERT INTO tod_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Lasɛle ɠɛni ma: «Nà-botiɠɛ anzanui Ɓiliɠa ʋɛtɛ, ʋilɛna naa ʋolu, é doun zɔlɔɔ kɔ̀ɠɔ ma, tɔun maaʋele ma gè doun zɔlɔɔ, nà ɓalaa.» ");
INSERT INTO tod_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","É ná-botiɠɛ anzanui Ɓiliɠa zeɠeni, é fe bɛ ga anza. Zakɔɓe ʋilɛni naa ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ɓiliɠa kogi zeɠeni, é doun zunu zɔlɔɔ Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Lasɛle ɠɛni ma: «GALA ge nà-gaamai vea zèa, é gòoi mɛniga, nà ɓalaagi, é doun zunu vea bɛ̀.» Naa ɠa é ba, é daasei pɛɛni ga Dan. ");
INSERT INTO tod_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Lasɛle ná-botiɠɛ anzanui Ɓiliɠa kogi zeɠeni mɔnɔ, é doun zunui velesiɛi zɔlɔɔ Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Lasɛle ɠɛni ma: «Gè ɲɛpi ɓaaɓaa kɔa bàazeelai laalɔɠɔma, gè zobo sɔlɔɔgɛ.» É daasei pɛɛni ga Nɛfɛtali. ");
INSERT INTO tod_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lea kaai ma ga é ɓega doun zɔlɔɔgi ʋa, é ná-botiɠɛ anzanui Zilepa zeɠeni, é fe Zakɔɓe ya ga anza. ");
INSERT INTO tod_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Lea ná-botiɠɛ anzanui Zilepa doun zunu zɔlɔɔni Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea ɠɛni ma: «Niima undaanɛɛ ɠa lee!» É daasei pɛɛni ga Gade. ");
INSERT INTO tod_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lea ná-botiɠɛ anzanui Zilepa doun zunui velesiɛi zɔlɔɔni Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea ɠɛni ma: «Ga-o, kòozunɛa! Uun, anzalopoiti ta ɠɛ mà koozunɛ nui.» É daasei pɛɛni ga Asɛɛl. ");
INSERT INTO tod_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Luɓɛn ɠulani moloi é ga ɓeleegi, naa leʋe ziɛgi zu. Siinziin ganigi daaseigi ga mandelagɔɔlegi, é naati kaani kpalagiti su, é ti zeɠeni, é ʋa ga tiye dee Lea ʋɔ. Lasɛle ɠɛ Lea ma: «Nà è maanɛɛnɛzu ga è è-loun zunui ná-mandelagɔɔlegi ta ve zèa.» ");
INSERT INTO tod_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Naa gooɠaaʋoteni, é ɠɛ ma: «Faa go ɠana nɛi ɓaa, ga è sìnigi zeɠea, è ʋa li mɔnɔ dòun zunui ná-ani waaiti seɠezu?» Lasɛle ɠɛni ma: «Kii ɓaa! Zakɔɓe ɠa la è ɠoba za ɓidii, è-loun zunui ná-mandelagɔɔlegiti ma vaa zu.» ");
INSERT INTO tod_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kpɔkɔi Zakɔɓe ɠɛai ma ʋaazu, é zeɠe kpalagaʋɛ, Lea ɠulani, é daaɠomi, é ɠɛ ma: «Pɔ̀ bɛ ɠa é ʋaazu ná za ɓidii, mazɔlɔɔ gè è ɠeyaʋɛ ga dòun zunui ná-mandelagɔɔlegiti, è maazɔlɔɔ fai zu.» É ɲiini pɔ bɛ naama ɓidii. ");
INSERT INTO tod_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","GALA ge Lea wooɠaaʋoteni, é kogi zeɠe, é doun zunui lɔɔlusiɛi zɔlɔɔ Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea ɠɛni ma: «GALA ge nà-kulanumai vea, tɔɔzei gè nà-botiɠɛ anzanui veeni sìnigi ya.» É daasei pɛɛni ga Isakaal. ");
INSERT INTO tod_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lea kogi zeɠeni mɔnɔ, é doun zunui lɔzitasiɛi zɔlɔɔ Zakɔɓe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea ɠɛ ma: «GALA ge vebɛani ʋagɔ vea bɛ̀ niizu, sìnigi ɠa ʋaazu zeizu pɔ̀, mazɔlɔɔ gè doun zunu lɔzita zɔlɔɔga bɛ.» É daasei pɛɛni ga Zaɓulɔn. ");
INSERT INTO tod_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Naa ʋolu é doun anzanu zɔlɔɔni, nii é daasei pɛɛni ga Dina. ");
INSERT INTO tod_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","GALA ge ɠitooni Lasɛle zu, é gooɠaaʋote, é kɛ ga kpuɠu nu. ");
INSERT INTO tod_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","É kogi zeɠeni, é doun zunu zɔlɔɔni, é ɠɛ ma: «GALA ge nà-unfegi zeɠea mà.» ");
INSERT INTO tod_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","É daasei pɛɛni ga Zozɛfe. É GALA falini, é ɗa ɠɛ ma: «Ɠɔoɠɔ GALAGI doun zunu ɠila kpɔ ba bɛ̀!» ");
INSERT INTO tod_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Siɛgi zu Lasɛle Zozɛfe zɔlɔɔni da, Zakɔɓe ɠɛni Laɓan ma: «Ɓena bà, gè ɠale ma, gè li nà-taazu, nà-zooi zu. ");
INSERT INTO tod_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ànzaiti feena zèa, ta dòinti, gi li, niiti gè botii ɠɛa è ʋɛ ti-ma vaa zu, mazɔlɔɔ è kwɛɛ ɗa ɓɔɠɔi botii niiti gè ti ɠɛa è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laɓan ɠɛni ma: «Ni ɗa kɛɛna, woilo gòo ma. Nà-galagiti ti dɛɛʋɛ ga ze ga Ɠɔoɠɔ GALAGI tuya looʋɛ bɛ̀, ɗɔun è maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","È-zalai lɛ ga ze, nà feezu è ya.» ");
INSERT INTO tod_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Zakɔɓe ɠɛni ma: «È kwɛɛ ɗa ɓɔɠɔi, eɠɛʋelei gè botii ɠɛai la è ʋɛ, ʋelei ɗa-logani ɓulugi ɠɛai la zèa. ");
INSERT INTO tod_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mazɔlɔɔ nii goi é ɠɛni è ya, aisa gè ʋa ʋa è ʋɔ bɛ, naa wola ɠaawɔɔlɔa. Ɠɔoɠɔ GALAGI tuya loa è ʋɛ, kaite kɔ̀ɠɔi ʋilɛ folo ma è ʋɔ bɛ. Niizu, siɛgi ɓɛgele ɠa nà botii ɠɛɛ la nà-pɛlɛi ʋɛ?» ");
INSERT INTO tod_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laɓan ɠɛni ma: «Leeni ɠa nà fe è ya?» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «È la ani nɔpɛ feezu zèa. Ni ɗa vaana naa wu, nii gè bosu è ma, nà ɗa-logani ɓulugi ɠɔnɔkula mɔnɔ, gè makɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Nà ziɛzu za ɗa-logani ɓulugi zaama. Gè naati pu yɛ, toganiiti saama, nii kpein pɔnɛai, ta ti ʋodapodagai, ta baala ziʋoi nii kpein tɛiɗai, gè kɛ ɠana nɔ boliiti saama, nii kpein podapodagai ta ti ʋɔnɛai. Naati ka ta ɠɛ ga sàlai. ");
INSERT INTO tod_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nà-ladalai ɠa gooɠaaʋotegi ve bɛ̀ lina, siɛgi zu è ʋaazu la, è sàlai ɠa. Nii kpein é la ʋɔnɛni, ɓaa é la ʋodapodani, boliiti su, ta ti la lɛini baala ziʋoiti su, naa ta a ɠaana zèa, naati ti unmaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laɓan ɠɛni ma: «É ɠɛ ɠana, eɠɛʋelei è bogai la.» ");
INSERT INTO tod_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Naama volo ná nɔ, Laɓan boli zinɛiti puuni yɛ, niiti ti ʋɔnɛni ta ti ʋodapodagai, ta boli zaaiti ti ʋɔnɛai, ti ʋodapodagai, niiti kpein kolezu ɠɛni ti ʋa, ta niiti kpein ti lɛiɗai baala ziʋoiti su. É naati kalivaani ná-doun zunuiti ma. ");
INSERT INTO tod_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Naa ʋolu é folo saʋagɔ ɠɛɠala ziɛ wosu yɛni ti yɔɠɔzu ta Zakɔɓe, nii é ɠɛni Laɓan ná-togani ɓulugi mɔtai ɠɔnɔkulazu, é ɗa makɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Gului niiti ti ga pɛpele ta amande ta pelatanegiti, Zakɔɓe naati ma ɓeke wundui tanigaani teʋeni, é maaɠɔlɔgi naa tanigaa ɠula ma, naa ɠa a kɛ ma ɠolegi naa tanigaa ti ɠula kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Naa ʋolu, gulu ɓekegi niiti é maaɠɔlɔgi ɠulani ti ma, é ti zeɠeni, é ti ʋilɛpilɛ kpɔɔle wosuʋɛ, ti ɠɛ toganiiti gaazu, ti ʋaazu ɓɔɔlezu, niiti ti ɓɔsɔgai, ti ɗa ka, ta ʋaana ɓɔɔlezu. ");
INSERT INTO tod_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Toganii nii kpein kpɔsɔgai, ti ɠɛni leʋesu gulu ɓekegiti kakalaʋɛ, ti ɓena yiʋoiti pu, ti ʋɔnɛai, ɓaa ti ʋodapodagai. ");
INSERT INTO tod_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Zakɔɓe ɠɛni togani yiʋoiti zeeɠaaɠwɛɛzu, kɛlɛ é togani ɓulugi mɔtai ʋuuni, ti ɗa wɛlɛ Laɓan ná-togani ɓulugi ʋa, niiti ti ʋɔnɛai, ta nii kpein tɛiɗai. Pele ɠana Zakɔɓe ná-togani ɓulugi ʋuuni la ɓɔɠɔ ma yɛ, é la ti ɓɔni su ta Laɓan ná-togani ɓulugi. ");
INSERT INTO tod_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Siɛnɔpɛ su toganiiti ti maanɛai, ti ɠɛni pɛɛpolui wosu da, Zakɔɓe ɠɛni gulu ɓekegiti pilɛsu kpɔɔle wosuʋɛti, toganiiti gaazu, nii a kɛ ti ɓɔsɔgai ɗa leʋe gulu ɓekegiti kakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Siɛgi zu toganiiti ta la ɠaɲana la, é la ɠɛni gulu ɓekegiti pilɛsu, naa ɠa a kɛ, niiti ti ɠaɲaai, naati ti ɠɛ ga Laɓan nɔnɔiti, niiti ma ti maanɛai, naati ti ɠɛ ga Zakɔɓe nɔnɔiti. ");
INSERT INTO tod_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Zakɔɓe ná-kpɛtɛi tanɔ ɠa é ɠɛni laazu ma. É togani goiti sɔlɔɔni ga mɔinɗa, ta botiɠɛ anzanuiti, naa ʋɛɛ botiɠɛ zunuiti ba, ta ɲɔmɛiti, ta soovalegiti. ");
INSERT INTO tod_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Zakɔɓe Laɓan ná-doun zunuiti goomɛnini, ti ɗa ɠɛ ma: «Nii kpein é ɠɛa ga gi-ɠɛɛ nɔnɔi, Zakɔɓe naati seɠea, gi-ɠɛɛ ɠɔligi ɠa é niima ɓɛtɛi zɔlɔɔgai su.» ");
INSERT INTO tod_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Zakɔɓe Laɓan ɠaazuʋɛ ʋɛtɛni, é la mɔ ɠɛni ɠɛɛni, eɠɛʋelei é ɠɛni la mɔungi zu. ");
INSERT INTO tod_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Názu ɠa Ɠɔoɠɔ GALAGI ɠɛni la Zakɔɓe ma: «Ɠale ma è-mɛmɛwolani ta-yooi zu, ɗa-ʋɛlɛyeɠei wu, nà ɠɛ è ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Zakɔɓe Lasɛleni ta Lea lolini, ga ti ʋa dɔɓɔi zu, ʋɛ é ɠɛni ná, ná-togani ɓulugi ɠoba. ");
INSERT INTO tod_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","É ɠɛni ti ma: «Nà kaazu ga wo-ɠɛɛ ɠaazuʋɛ la mɔ ga eɠɛʋelei é ɠɛa la nɔ̀un tetema mɔungi, kɛlɛ kɛ̀ɛ ná-GALAGI yɛgɛ nɔ̀un ba. ");
INSERT INTO tod_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Wa ɓɔɠɔgoi wo kwɛni ga gè botii ɠɛɛni wo-ɠɛɛ ʋɛ ga sùvikɛi kpein. ");
INSERT INTO tod_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kɛlɛ wo-ɠɛɛ yaavai ɠɛɛni ga ze, é sàlai valiboni ná zeizu ɠɛ puu. GALA ge la ɠɛni vaani bu, é ʋa faa ɲɔu ɠɛ ga ze. ");
INSERT INTO tod_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Siɛgi zu é ɠɛni ɠɛɛzu la mà: ‹Ma ʋodapodagiti ta ɠɛ ga è-zalai,› toganiiti ti ɓena pu ga ma yiʋoiti ti ʋodapodagai. Ta siɛgi zu a la ɠɛna la mà: ‹Ma ʋɔnɛgiti ta ɠɛ ga è-zalai,› toganiiti kpein ti ɓena sɔlɔɔga ma yiʋo ʋɔnɛgiti. ");
INSERT INTO tod_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","GALA ka é wo-ɠɛɛ ná-togani ɓulugi ɠulani zea, é fe bɛ̀. ");
INSERT INTO tod_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Siɛgi zu toganiiti ti ɠɛni ʋɛɛzu la ɓɔɠɔ ʋolu, gè ɠaazuwuzeɠeni, segi zu gè kaani ga boli zinɛiti ti ɠɛni ʋɛɛzu ma zaaiti polu, ti ʋɔnɛni, ti ʋodapodagɛ. ");
INSERT INTO tod_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","GALA ná-geezuɠeelai ɠɛni mà segi zu: ‹Zakɔɓe.› Gè gooɠaaʋoteni, gè ɠɛ ma: ‹Nà ɠaa.› ");
INSERT INTO tod_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","É ɠɛ mà: ‹Ɠaazu wuzeɠe, è wɛlɛ, boli zinɛiti kpein ti ʋɛɛzu ma zaaiti polu, ti ʋɔnɛʋɛ, ti ʋodapodagɛ, mazɔlɔɔ gè naa kpein kaa, nii Laɓan kɛai ga ɗe. ");
INSERT INTO tod_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nà ɠa gè ga Ɓetɛle ƓALAGI, ʋɛ è gulɔi ziɛni ná kɔtui ma, è gaalɔ ga ɠizɛsui, ʋɛ è minazeɠeni ná bɛ̀. Niizuʋɛ wuzeɠena, ɠula niima yooi ʋa, è ɠale ma è zɔlɔɔ zooi zu.› » ");
INSERT INTO tod_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Lasɛle ta Lea ti gooɠaaʋoteni, ti ɠɛ ma: «Leeni ɠa é gi ʋɛ mɔnɔ ga gɔnɔ ɓaa pogani gi-ɠɛɛ ná-pɛlɛi wu? ");
INSERT INTO tod_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","É la gi zoni nɔ eɠɛ wɛɛn anzanuiti ɓaa? Tɔɔzei é gi ʋɔdia, é gi-zɔngɔi mi. ");
INSERT INTO tod_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Naavoloi kpein GALA ge kulaai gi-ɠɛɛ ya, ta ga gɔnɔ gá gi-lointi. Deɠɛmu, niizu, naa kpein kɛ, nii GALA ge boga è ma.» ");
INSERT INTO tod_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Zakɔɓe wuzeɠeni, é ná-dointi ta anzaiti tɛ, é ti zei ɲɔmɛiti kɔma. ");
INSERT INTO tod_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","É liini ga ná-togani ɓulugi kpein, ta kɔligiti é ti zɔlɔɔni, togani ɓulugi é ɠɛni zea, é ti zɔlɔɔni Padan-Alame. É wuzeɠeni, é li kɛɛɠɛ Izaake ʋɔ bɛ, Kanaan yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Názuʋɛ ɠa Laɓan liini la ná-baalagiti maaleɠaiti teʋezu. Lasɛle kɛɛɠɛ ná-pɛlɛ wu zaleiti unmani. ");
INSERT INTO tod_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Zekana Zakɔɓe Alame nui Laɓan yaavani la, é la faa nɔpɛ boni ma, é ɗa ʋela. ");
INSERT INTO tod_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","É ʋelani ga naa kpein, nii é ɠɛni ga nɔnɔ. É liini, é ziɛ wolai Efelate ɓudɛ, naa ʋolu é leteni Galaade ɠize yooi ʋɔ pelei ma. ");
INSERT INTO tod_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Foloi zaʋasiɛi ma ti daazeelini Laɓan ma ga Zakɔɓe ʋela. ");
INSERT INTO tod_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","É pɛlɛ wu nuiti seɠeni, ti ʋilɛ Zakɔɓe ʋolu, folo lɔfela laawu ti ɗa ziɛ. Ti kɔɠɔzumɛɛnni Galaade ɠize yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kɛlɛ GALA ge ɠulani kɛlɛma kpidii segi zu Alame nui Laɓan ʋɛ, é ɠɛ ma: «Dama, mina ɓɔɛ Zakɔɓe ʋɔ ga ɲɔuɗa.» ");
INSERT INTO tod_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laɓan zeelini Zakɔɓe ma. Zakɔɓe ná-seɠe ɠotai loni gize yooi zu. Laɓan ʋɛɛ ná-pɛlɛ wu nuiti ba, ti tɔnɔi loni ɓalaa Galaade ɠize yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laɓan ɠɛni Zakɔɓe ma naazu: «Lee ɠa è kɛai? Lee vaa zu è yàavaai, è liizu ga dòun anzanuiti, eɠɛ ta ɠɛ ga duɔiti, ti zogai kɔɔi zu? ");
INSERT INTO tod_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Leeni vaa zu è ʋelaai dɔɔɠuzu, è nɔ̀un yaava, è la tòoni ɠisu lago pa? Nà la ɓe è ʋa, è li koozunɛɛi zu, guye wooiti saama, ta tamadegiti, ta kɔnigiti gooiti. ");
INSERT INTO tod_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","È la zɛ̀ni ná, gè ʋa dòunlointi ta dòun anzanuiti nɛɛnɛ ga daaʋɛ komagai! Ɠimalala vaa ɠa è kɛai niima gelei zu. ");
INSERT INTO tod_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Zobogi ɠa bɛ̀, gè faa ɲɔu ɠɛ ga woye, kɛlɛ wo-ɠɛɛ ná-GALAGI ɠɛni mà wogi ɓidii: ‹Dama, mina ɓɔɛ Zakɔɓe ʋɔ ga ɲɔuɗa.› ");
INSERT INTO tod_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Niizu è lia niina, tɔɔzei è-ɠɛɛ ʋɛlɛi ɠa wɔin ɠɛa è ma, kɛlɛ lee vaa zu è nà-galagiti unmaai?» ");
INSERT INTO tod_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Zakɔɓe Laɓan wooɠaaʋoteni, é ɠɛ ma: «Dualuagi ɠa é ɠɛni sù, gè ɗa ɠisiɛ ga tanisu ɗa ʋaazu è-loun anzanuiti kulazu zèa ga zeeɠaaɓaai! ");
INSERT INTO tod_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kɛlɛ nui nɔpɛgi è ʋaazu ɗa-ɠalagiti kaazu zea, naa la mɔ zɛnvui ta woga! Adaʋɛti pɛ fɛɠɛlɛfɛɠɛlɛ da-nuiti gaazu, è naa zeɠe, nii é ga ɗɔnɔi.» Zakɔɓe la ɠɛni suɠwɛɛ ga Lasɛle ti unmani. ");
INSERT INTO tod_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laɓan lɛɛni Zakɔɓe ná-seɠe ɠotai wu, ta Lea ná-seɠe ɠotai, ta botiɠɛ anzanu felegɔiti ta-zeɠe ɠotai wu, é la ani nɔpɛ kaani. É ɠulani Lea ʋɔ bɛ, é lɛ Lasɛle ná-seɠe ɠotai wu. ");
INSERT INTO tod_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Lasɛle pɛlɛ wu zaleiti seɠeni, é ti la ɲɔmɛi ná-kpɔkpɔgi wu, é zei maazu. Laɓan wɛlɛni seɠe ɠotai kpein bu, é la ani nɔpɛ kaani. ");
INSERT INTO tod_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Lasɛle ɠɛni kɛɛɠɛ ma: «Màliɠii, mina yiiɠaawana, ni gè la zooni gè ʋa wuzeɠe ɗɔun è ɠakala, mazɔlɔɔ nii a ɗa ɠɛ ga anzanuiti pɔlɔmazu, naa ɠa é bà.» É pɛlɛ wu zaleiti gaiziɛni, é la ti ɠaani ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Zakɔɓe yiiɠaawanani, é kpɔɛi laalɛ Laɓan wu. É ɠɛni ma: «Tɔ koloɠologi ɓɛgele ɠa gè kɛai, nà-kotoi ɠa ga ɓɛgele, è ʋilɛsu pòlu ga zeliloma wolai nii ma zii? ");
INSERT INTO tod_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Siɛgi zu è nà-kasɔiti kpein fɛɠɛlɛfɛɠɛlɛni la, leeni ɠa è kaai ga ɗa-ʋɛlɛ wu zɔɔlai? Dɛɛ lɛɛ nà-pɛlɛ wu nuiti ta ɗa-ʋɛlɛ wu nuiti gaazu, ti ɠɛ ga de zuvaa wo nui. ");
INSERT INTO tod_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Wɛlɛ kona ʋuufelegɔ (20) ɠa gè kɛɛni è ʋɔ bɛ, ɗa-ʋaala saaiti ta ɗa-woli zaaiti ta ɠo ge la zeɠeni ma, gè la ɗa-logani ɓulugi ma ʋaala sinɛiti ta miini. ");
INSERT INTO tod_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Gè la ʋaani è ʋɔ ga togani, nii suaa ti baliai ga, naama vai ɠɛni nà nɔ bà. Nii ta la unma zèa, foloi ɓaa kpidii, è ɠɛni naama zɔngɔi ɠulazu zèa. ");
INSERT INTO tod_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Diegi ɠɛni zeizu mà, é ɗa kpɔ̀lɔ foloi, kɔɔlɛi ɠɛni ʋaazu mà kpidii, ɲiimɛni nɔpɛ gè la ɠɛni bosu. ");
INSERT INTO tod_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Kona ʋuufelegɔ (20) ɠa gè kɛai ɗa-ʋɛlɛi wu, gè botii ɠɛɛni è ʋɛ ga kona puugɔ maazu naanigɔ (14) è-loun anzanu felegɔiti ta-vaa zu, gè kɛ ɗa-logani ɓulugi makɛ vai zu ga kona dɔzita, è sàlai valiboni ná zeizu ɠɛ puu. ");
INSERT INTO tod_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ni kɛ̀ɛ ná-GALAGI la ɠɛni ʋaani, é ʋa lo bɛ̀, Abalaame ná-GALAGI nii Izaake luazu ba, è ɓena zɛ̀ ɠana, gè ɠale ma ga zeaɲakai. Kɛlɛ GALA ge nà-kpɔlɔi ɠaani, ta nà-botii ɠɛʋelei, é zaamazu logi wo de yɔɠɔzu, wogi ɓidii.» ");
INSERT INTO tod_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laɓan Zakɔɓe wooɠaaʋoteni, é ɠɛ ma: «Anzanu lointi ta ga nɔ̀un doun anzanuiti, doin niiti ta ga nɔ̀un dointi, niima logani ɓulugi ɠa ga nà-togani ɓulugi, nii kpein è kaazu, naa ɠa ga nɔ̀nɔ. Leeni ɠa nà zoo gè kɛ za dòun anzanuiti bɛ, ta ti-lointi, ti ti zɔlɔɔgai? ");
INSERT INTO tod_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Niizu de minazeɠegi wo ɓɔɠɔ ʋɛ, nà-o, ɗa-o, naa ɠɛ ga zeelei de yɔɠɔzu de felegɔ.» ");
INSERT INTO tod_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Zakɔɓe kɔtu ɠila seɠeni, é gaalɔ. ");
INSERT INTO tod_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Zakɔɓe ɠɛni ná-pɛlɛ wu nuiti ma: «À kɔtuiti zɛʋɛ.» Ti kɔtuiti gaalɛɛni ba, ti ma ziɠigi lo. Ti daamii woni náʋɛ, kɔtu ziɠigi ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laɓan daasei pɛɛni ga Yegaal-Saɠaduta, Zakɔɓe ma ge daasei pɛɛ ga Galeede. ");
INSERT INTO tod_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laɓan ɠɛni ma: «Niima ɠɔtu ziɠigi ɠɛa ga zeelei de yɔɠɔzu za.» Naa ɠa é ba, ti daaseigi ʋɛɛni ga Galeede. ");
INSERT INTO tod_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ta ɗa toli ɓalaa ga Misepa, tɔɔzei Laɓan ɠɛni ma: «Ɠɔoɠɔ GALAGI ɗa wɛlɛ de ma, nà-o, ɗa-o, siɛgi zu de ɠaazuzeɠezu la ɓɔɠɔ ʋa de felegɔ. ");
INSERT INTO tod_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ni ɗa dòun anzanuiti sopele ɲɔuna, ni ɗa anza ɠiligaa zeɠena mɔnɔ, nu laade é ʋa ɠɛ lɔɔzu de yɔɠɔzu, kɛlɛ dama, GALA ka é ɠɛɛzu de yɔɠɔzu ga zeelei.» ");
INSERT INTO tod_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laɓan ɠɛni Zakɔɓe ma: «Wɛlɛ kɔtu ziɠigi ʋa ta kɔtu ɠaalɔgai, niiti gè ti logai de yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kɔtu ziɠigi nii ta kɔtu ɠaalɔgai niiti ta ga zeeleiti, ga eyɛsu pɛ gè la ɓudɛa ti maazu, gè ʋa li è ʋɔ pelei, gè ʋa faa ɲɔu ɠɛ ga ɗe, ta eyɛsu pɛ è la ɓudɛa ti maazu, è ʋa ʋa pɔ̀ pelei, è ʋa faa ɲɔu ɠɛ ga ze. ");
INSERT INTO tod_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abalaame ta Naɠɔɔl ta-ƓALAGI, ti-ɠɛɛ ná-GALAGI ɠɛ ga tukpɔɠaaleʋe nui de yɔɠɔzu.» Zakɔɓe ɠonani GALAGI naa ma, nii Izaake ɠɛni luazu ba. ");
INSERT INTO tod_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Naa ʋolu Zakɔɓe zalaɠai ɠulani gizei ma, é kɛɛɠɛleaiti toli ga ti daamii wo. Ti laamiini, ti ɲi gizei ma. ");
INSERT INTO tod_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Laɓan wuzeɠeni ga sobuzobui, é ná-dounlointi ta ná-doun anzanuiti nɛɛnɛ, é tuya loo ti ʋɛ. Naa ʋolu é ɠale ma, é li zeizuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Zakɔɓe ʋilɛni pelei zu, é ɗa li. GALA ná-geezuɠeelaiti ti ʋaani, ti daaɠomi. ");
INSERT INTO tod_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Zakɔɓe ti ɠaai ma, é ɠɛni ma: «GALA ná-kɔɔlaaɠai ɠa!» É naama adaʋɛ laasei pɛɛni ga Maɠanayime (nii poluʋɛ ga «kɔɔlaaɠa felegɔi»). ");
INSERT INTO tod_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Zakɔɓe keelaiti teʋeni luɠɔ diɛ Ezawu ma, Seyiil yooi zu, Edɔme ɠoʋii zu. ");
INSERT INTO tod_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","É devei nii veeni ti ya, é ɠɛ ti ma: «Wɛlɛ nii ɠa wa bo màliɠii Ezawu ma: ‹Pele ɠa ɗa-wotiɠɛ nui Zakɔɓe ɓɔɛzu la: Gè zeini Laɓan ʋɔ bɛ, zɛ̀gɛ ná eyɛsu niizu zeeli. ");
INSERT INTO tod_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nikɛiti ta zèa, ta soovalegiti, ta baalagiti, ta botiɠɛ zunuiti, ta botiɠɛ anzanuiti. Gè keelaiti teʋegɛ ga ti naama wooi laazeeli è ma, màliɠii, naa ɠa a kɛ gè zaalai zɔlɔɔ è ɠaazu.› » ");
INSERT INTO tod_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Keelaiti ti ɠaleni ma Zakɔɓe ʋɔ bɛ, ti ɠɛ ma: «Gi liiʋɛ è-liɛ Ezawu ʋɔ bɛ, ta ʋaazu è laaɠomisu, ta zunu unnaanigɔ (400).» ");
INSERT INTO tod_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Zakɔɓe wola luani, zii ɗa zoolɛ. Nuiti ti ɠɛni polu, é naati balini su ga seizu felegɔ, é ʋɛɛ baalagiti ba, ta nikɛiti, ta ɲɔmɛiti. ");
INSERT INTO tod_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","É ɠɛni ma: «Ni Ezawu a ʋaana, é seizu ɠilagi zo, zɔi é yɛsu ná, naa ɠa zoo é ʋela.» ");
INSERT INTO tod_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Naa ʋoluma Zakɔɓe maanɛɛnɛi woni, é ɠɛ ma: «Kɛ̀ɛ Abalaame ná-GALAGI, ta kɛ̀ɛ Izaake ná-GALAGI, Ɠɔoɠɔ GALAGI, ɗɛi è ɠɛni mà: ‹Ɠalena ma ɗa-yooi zu, ɗa-ʋɛlɛyeɠei wu, nà faa ʋagɔ ɠɛʋele ɓɛtɛzu è ʋɛ.› ");
INSERT INTO tod_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Gè la kulani su, gè ʋa nuɓɔɠɔlai kpein sɔlɔɔ, ta wooɠɛɠiladai kpein nii è kɛa nɔ̀un tetema, nɛ̀i gè ga ɗa-wotiɠɛ nui, mazɔlɔɔ kɛ̀ai ma Zuludɛn tɛi kpudɛzu, nà-tukpɔi nɔ ɠa é ɠɛni zèa, kɛlɛ niizu, nà niina nuɓusɛ ʋɛbɛ zeizu felegɔ unda. ");
INSERT INTO tod_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nà è maanɛɛnɛzu, kìzo, è kùla dìɛ Ezawu ya. Mazɔlɔɔ nà luazu ga é mina ʋa, é ʋa pàa, gá doun deeiti ta dointi. ");
INSERT INTO tod_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ɗa ma, è ɠɛni mà: ‹Nà faa ʋagɔ ɠɛʋele ɓɛtɛzu è ʋɛ, gè è-mavofodai ɠɛ eɠɛ kpoloɗɛi ɠoba ɲaɠaegi, é wola mɔin su, nu la zooga é ʋa gaalu.› » ");
INSERT INTO tod_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Naama adaʋɛ tɔna ka Zakɔɓe ɲiini ná. Nii é ʋaani la ga kɔligi, é naa ta zeɠeni ba ga ɓɔɠɔ maazoloogi, é teʋe diɛ Ezawu ʋɔ: ");
INSERT INTO tod_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","boli zaa unfelegɔ (200) ta boli zinɛ ʋuufelegɔ (20), baala saa unfelegɔ (200) ta baala sinɛ wola ʋuufelegɔ (20), ");
INSERT INTO tod_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ɲɔmɛ zaa ʋuusaʋagɔ (30), é ʋɛɛ ti-yiʋoiti ba, ti ɠɛni ɲiimii ɓɔlezu, nikɛ zaa ʋuunaanigɔ (40) ta nikɛ zinɛ puugɔ (10), soovale saa ʋuufelegɔ (20) ta soovale sinɛ puugɔ (10). ");
INSERT INTO tod_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","É ti ɠalivaani ná-botiɠɛ nuiti ma, togani ɓulugi yeeɠaaɠwɛa ɠɛni de su kpɛkpɛ. É ɠɛni ná-botiɠɛ nuiti ma: «À leʋe tùɠɔ, wo zɔɠɔzu ɠɛ togani ɓulugi ɠilagilagi ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","É niima levei veeni ma mɔungi ya ga: «Siɛgi zu dìɛ Ezawu wo laaɠomisu da, é wo ɠaazaɠa ga: ‹Ɗa ga ɓɛ ná-nu? Mini ɠa è liizu ná?› A ɠɛna ma: ‹Ɓɛ nɔnɔ ɠa ga togani ɓulugi, nii é è ɠakala?›, ");
INSERT INTO tod_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ɗa gooɠaaʋote ga: ‹Ɗa-wotiɠɛ nui Zakɔɓe nɔnɔi ʋe, é teʋegɛ màliɠii Ezawu ma ga sabai. Wɛlɛ tɔ ɓɔɠɔgoi ʋa, é ʋaazu gi ʋoluʋelei.› » ");
INSERT INTO tod_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Naama leve ɠilagi nɔ ɠa é feeni felesiɛi ya, ta saʋasiɛi, ta naati kpein niiti ti ʋilɛni togani ɓulugiti polu, é ɠɛ ti ma: «Ʋele ɠana wa ɓɔɛ la Ezawu ʋɔ, siɛgi zu wa ɠomina da. ");
INSERT INTO tod_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Wa ɠɛɛzu ma ɓalaa: ‹Wɛlɛ, ɗa-wotiɠɛ nui Zakɔɓe ʋa, é ʋaazu gi ʋoluʋelei.› » Mazɔlɔɔ é ɠɛni ɠɛɛzu ma: «Nà ziilɛizu ga ɓɔɠɔ maazoloo ganii, nii é liizu tùɠɔ, naa ʋolu nà gaazuʋɛ ʋɛtɛ niina, tanisu toɠa yeezei bù ga pagɔ.» ");
INSERT INTO tod_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ɓɔɠɔ maazoloo ganiiti ti liini tuɠɔʋelei, tɔ ɓɔɠɔi ɲiini kotai wu naama ɓidii. ");
INSERT INTO tod_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","É wuzeɠeni naama ɓidii nɔ, é li ga anza felegɔiti, ta botiɠɛ anzanu felegɔiti, ta ná-doun puugɔ maazu ɠilagiti (11), é ɓudɛ ziɛ wolai Yaɓɔke maaleʋesuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","É ti zeɠeni, é ti ɓudɛ ziɛ wolai maazu, nii kpein é ɠɛni ga nɔnɔ, é naa pɛ kpudɛni. ");
INSERT INTO tod_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Zakɔɓe ɠila ko yɛni ná. Ti kɔɔni naazu ta zunui ta, eyɛsu geelaalao. ");
INSERT INTO tod_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Zunui kaai ma ga é la ziɛzu Zakɔɓe wu, é doɠani kpala ɠaei losuʋɛ kpoɠi ɠaei ʋa. Kpala ɠaei ziɛni su kpoɠi ɠaei losuʋɛ, siɛgi zu ti ɠɛni ɲɛpii ɠɔɔzu la. ");
INSERT INTO tod_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Zunui ɠɛni Zakɔɓe ma: «Ɓena bà, gè li, mazɔlɔɔ woza ɠana ɠala.» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Gè la ɓesu è ʋa pɛ, è ʋa li, ni è la tuya looni bɛ̀.» ");
INSERT INTO tod_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Zunui ɠɛni ma: «È-laaseigi ɠa ga lee?» É gooɠaaʋoteni, é ɠɛ ma: «Zakɔɓe.» ");
INSERT INTO tod_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Zunui ɠɛni ma mɔnɔ: «È-laaseigi la mɔ ɠɛa ga Zakɔɓe, kɛlɛ toɠa ɠɛ ga Izilayɛle, mazɔlɔɔ è ɲɛpii ɠɔa GALA daalɔɠɔma, ta nuiti, è pilɛ sɔlɔɔga.» ");
INSERT INTO tod_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Zakɔɓe gaazaɠani, é ɠɛ ma: «Nà è maanɛɛnɛzu, è-laaseigi lɛ ga ze.» É gooɠaaʋoteni ga: «Leeni vaa zu è dàaseigi maaɠaazaɠabosu?» É tuya looni bɛ náʋɛ nɔ. ");
INSERT INTO tod_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Zakɔɓe naama adaʋɛ laasei pɛɛni ga Penuwele, mazɔlɔɔ é ɠɛni ma: «Gè GALA kaaʋɛ ga ɠaazuni ta ɠaazu, zɛ̀nvui ɠizo.» ");
INSERT INTO tod_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Foloi lɛɛni niina, siɛgi zu é ɠɛni leʋesu la Penuwele ʋa. Zakɔɓe ɠɛni lɛkpuzu, é ɗa yei ɓalai ma fifi. ");
INSERT INTO tod_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Naa ɠa é ba, zaaɠaza, Izilayɛle nuiti ti la ɗa ga sua ɲatai mia, nii é kpalai zu, é lɛɛzu kpoɠi ɠaei lodazuʋɛ, mazɔlɔɔ Zakɔɓe loɠani ɲatai ʋa, é kpala ɠaei lodazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Zakɔɓe ɠaazuwuzeɠeni, é wɛlɛ, é Ezawu ɠa, é ɗa ʋa, zunu unnaanigɔ (400) polu. É dointi gaaɠwɛɛni Leani zɔɠɔzu ta Lasɛle ta botiɠɛ anzanu felegɔiti. ");
INSERT INTO tod_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","É botiɠɛ anzanuiti ta ti-lointi toni ʋelelaʋɛ ti untuɠɔ, naa ʋolu Lea ta ná-dointi, gaaɓelasu ɠɛ ga Lasɛle ta Zozɛfe. ");
INSERT INTO tod_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Tɔ ɓɔɠɔi leʋeni ti luɠɔʋelei, é nɔkɔni zooi ma ná zeizu ɠɛ lɔfela, eyɛsu é zeeli diɛ Ezawu ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezawu ɓizɛni, é daaɠomi, é velevele ga kɔgi, é nɛɛnɛ. Ti felegɔ ti tɔɔzeini ga wɔlɔa. ");
INSERT INTO tod_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Naa ʋolu, Ezawu ɠaazuwuzeɠeni, é anzanuiti ka ta dointi, é ɠɛ ma: «Ɓɛɛni kanu ti è yeema loni munu?» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Dointi kana, niiti GALA ge ti veai ná-zaalai zu ɗa-wotiɠɛ nui ya.» ");
INSERT INTO tod_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Botiɠɛ anzanuiti ti maaɓuɠani, tiya-o, ti-lointi-yo, ti nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea ta ná-dointi ti maaɓuɠani ɓalaa, ti nɔkɔ. Naa ʋolu Zozɛfe ta Lasɛle ti maaɓuɠani, ti nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezawu ɠɛni ma: «Leeni ɠa è kɛɛzu ga nuuma ʋɛbɛiti, gi ɠomigai ga tiye?» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Gè è zabaʋɛ, naa ɠa a kɛ, gè zaalai zɔlɔɔ màliɠii è ɠaazu.» ");
INSERT INTO tod_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezawu ɠɛ ma: «Anii ʋooʋaʋɛ zèa, kɛ̀ɛloun, ɗɔnɔi kpein makɛ.» ");
INSERT INTO tod_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Ɓa-o, nà è maanɛɛnɛzu, ni gè zaalai zɔlɔɔgɛ è ɠaazu, nà-soloo ganii zo. Mazɔlɔɔ gwɛ̀lɛʋɛ è-ɠaazuʋɛ ʋa, eɠɛʋelei nu a wɛlɛ la GALA gaazuʋɛ ʋa, tama è yeezeiʋɛ bù ga pagɔ. ");
INSERT INTO tod_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Deɠɛmu, nà-soloo ganii zo, nii feai è ʋɛ, tɔɔzei GALA ge zaalaiti daavegɛ bɛ̀, gè la ʋalani ani nɔpɛ ma.» É ɠilini Ezawu ma, eyɛsu naa yeezei bu. ");
INSERT INTO tod_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ezawu ɠɛ ma: «Ade liina, ade ʋilɛna pelei zu. Nà liizu è luɠɔ.» ");
INSERT INTO tod_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Màliɠii kwɛɛ ga doungoiti ta-vai ɓaaʋɛ, ta togani yiʋoiti ti ɲiimii ɓɔlezu. Ni nu a ɓɔina ti la, folo ɠila su ga ti ziɛ vai, togani ɓulugi kpein undaa ɠa ʋili. ");
INSERT INTO tod_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Màliɠii lo ʋelela nɔ̀un tuɠɔ, nɛ̀i gè ga ná-botiɠɛ nui. Nɔ̀un nà, nà ʋilɛsu ti ʋolu, gi ɗa li vaa, é zoloo togani ɓulugi ná-siɛi ma, nii é kàkala, ta é zoloo doungoiti ta-ziɛi ma, eyɛsu gè zeeli màliɠii ʋɔ bɛ Seyiil.» ");
INSERT INTO tod_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ezawu ɠɛ ma: «Nà pɔ tɔun gè nà-nuɓusɛiti gilazuʋɛ yɛ è ʋa.» Zakɔɓe gooɠaaʋoteni, é ɠɛ ma: «Lee vaa zu naa a ɠɛ? Gè zaalai zɔlɔɔ nɔ màliɠii ɠaazu!» ");
INSERT INTO tod_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Naama volo ná nɔ, Ezawu ɠaleni ma ga Seyiil ʋele. ");
INSERT INTO tod_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kɛlɛ Zakɔɓe liini Sukɔte, é pɛlɛi loni ɓɔɠɔ ʋɛ, é kotaiti to ná-togani ɓulugiti bɛ. Naa ɠa é ba, adaʋɛ ná laasei pɛai la ga Sukɔte (nii poluʋɛ ga «kotaiti»). ");
INSERT INTO tod_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Zakɔɓe zeɠeai ma Padan-Alame, é zeelini ga pagɔ Sikɛme taazuʋɛ, Kanaan yooi zu. É zeini taa loaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ʋɛ é ná-seɠe ɠotai loni ná, é naama you ɓuɠai ɠeyani Sikɛme kɛɛɠɛ Ɠamɔɔl ná-doun zunuiti ma, ga wali ɠae ungila (100). ");
INSERT INTO tod_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Miná ɠa é zalaɠa ɠulazuʋɛ ɓɛtɛni ná, nii é daasei pɛɛni ga Ɛle-Ɛlɔɠee-Izilayɛle (nii poluʋɛ ga «GALA ka ga Izilayɛle ná-GALAGI»). ");
INSERT INTO tod_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Yeeta, Lea ná-doun anzanui Dina, nii é sɔlɔɔni Zakɔɓe ʋa, naa ɠa é ɠulani zooi zu anzanu loungoiti pɛtɛ fai ma. ");
INSERT INTO tod_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Zou ɠundiɠii Ɠeve nui Ɠamɔɔl ná-doun zunui Sikɛme kaani, é vala ba, é ma ɓea zeɠe. ");
INSERT INTO tod_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","É ɠilini Zakɔɓe ná-doun anzanui Dina ʋa ga zii pɛ. Anzalopoi nɛɛni bɛ, é ɓɔɛni naa ʋɔ ga é kigi lati. ");
INSERT INTO tod_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sikɛme ɠɛni kɛɛɠɛ Ɠamɔɔl ma: «Anzalopoi nii ɠaiziɛ bɛ̀ ga anza.» ");
INSERT INTO tod_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Zakɔɓe mɛnigai ma ga é ɓaaɠulaʋɛ ná-doun anzanui Dina ma, tɛi ná-doun zunuiti ti ɠɛni dɔɓɔi zu ga ná-togani ɓulugi, é maaɠɛni kpɔ, eyɛsu ti ʋa. ");
INSERT INTO tod_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sikɛme kɛɛɠɛ Ɠamɔɔl liini, é ɓɔɛ Zakɔɓe ʋɔ. ");
INSERT INTO tod_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Naa laa yɔɠɔzu, Zakɔɓe ná-doun zunuiti ti ʋaani, ti zeɠe dɔɓɔi zu. Ti mɛnigai ma, ti yiiɠaawanani, ti yiiɠula, tɔɔzei Sikɛme kɔzɔba vai ɠɛɛni Izilayɛle nuiti saama, daa vai zu ga Zakɔɓe ná-doun anzanui, nii maa la nɛɛni ga é ʋa ɠɛ. ");
INSERT INTO tod_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ɠamɔɔl ɓɔɛni ti ʋɔ, é ɠɛ ti ma: «Wo-loun anzanui wola nɛɛʋɛ dòun zunui Sikɛme ʋɛ, nà wo maanɛɛnɛzu ga wo fe bɛ niina ga anza. ");
INSERT INTO tod_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","À ɠili gi ʋa vulu vai zu, wo ɗa wo-loun anzanuiti fe gi ʋɛ, wo ɗa gɔnɔiti seɠe. ");
INSERT INTO tod_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Wa zei gi zaama, zooi laa ɠa lao wo luɠɔ ga wo zei ná, wo wa-wotii ɠɛ su, wo ná tanigaa ɠeya ɓɔɠɔ ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sikɛme ɠɛni anzanu loungoi kɛɛɠɛ ta diɛni ma: «À niima vaaɓɔɠɔi ɠɛ bɛ̀, nà naa ve wo ya, nii wa bona ga gè fe. ");
INSERT INTO tod_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","À kàkala la ga vulu anii, nii bɔɔlɔai, ta faaɓɔɠɔ ani mɔinmɔin, nà naa ve, nii wa bo mà, kɛlɛ à va bu ga anzalopoi ɠɛ ga ànza.» ");
INSERT INTO tod_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Zakɔɓe ná-doun zunuiti ti Sikɛme ta kɛɛɠɛ Ɠamɔɔl wooɠaaʋoteni ga keleɠele, tɔɔzei é ɓaaɠulani ti-ʋaazeelai Dina ma. ");
INSERT INTO tod_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ti ɠɛni ti ma: «Faa ɠana, nii gi la zooga gi ʋa kɛ, ga gi gi-ʋaazeelai ve zunu ʋɛ, nii é la latini pɛlɛʋolu, mazɔlɔɔ toɠa ɠɛ ga ɓaaɠulama vaa gi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Gá va niima vai wu, kɛlɛ kɛni wa ɠɛna ga gi ɠɛʋele, ga wo zaama zunuiti kpein ti lati pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Naazu, gá gi-loun anzanuiti fe wo ya, gi wo-loun anzanuiti seɠe ʋɛ, gá zei wo zaama, ade ɠɛ ga nuɓusɛ ɠila. ");
INSERT INTO tod_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kɛlɛ ni wo la vaani tatipɛlɛʋolu vai wu, gi bogai, gá gi-ʋaazeelai zeɠe, gi li.» ");
INSERT INTO tod_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ɠamɔɔl ta Sikɛme ti yeezeini naama wooiti bu, ti boni. ");
INSERT INTO tod_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Zunu loungoi la ɠɛni suɠoozani, é naama vai ɠɛ, nii ti boni, mazɔlɔɔ é ɠɛni Zakɔɓe ná-doun anzanui ʋɔ. Toɠa ti ɠɛni woilosu goo ma gola kɛɛɠɛ ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ɠamɔɔl ta ná-doun zunui Sikɛme ti liini taa ziɠidaʋɛ, ti ɓɔɛ ɠani ta-laazu nuiti pɔ, ");
INSERT INTO tod_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","ti ɠɛ ma: «Nui niiti ta ga ziilɛi bea ade letegi, de va bu, ti zei zooi zu, ti ɗa suɠani ɠaiziɛ, wɛlɛ zooi zuwɔɔlɔʋɛ ta-vaa zu, naati kpein nɔ. Da ti-loun anzanuiti sei, de dɔnɔiti fe ti ya. ");
INSERT INTO tod_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kɛlɛ zunui naati ti la vaa bu, ti ʋa zei ade zaama, de ʋa ɠɛ ga nuɓusɛ ɠila, kɛni ade zaama zunui kpein ge lati pɛlɛʋolu, eɠɛʋelei tiya ɓɔɠɔi ti la, ti latigai da pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ta-logani ɓulugiti, ti-yeaɠɔligiti ta ta-loganiiti kpein ti la ɠɛa ga dɔnɔ ɓaa? Ade yeezei nɔ ta-levei wu, nii a kɛ ti yɛ ade ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Niiti kpein ti ɠɛni taa ziɠidaʋɛ, ti Ɠamɔɔl ta ná-doun zunui Sikɛme wooi mɛni, ti yeezeini ti-wooi wu. Taazuʋɛ zunuiti kpein ti latini pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Foloi zaʋasiɛi ma, siɛgi zu ti ɠɛni taɓai zu la, Zakɔɓe ná-doun zunu felegɔiti Simiyɔn ta Levi, Dina diɛiti, ti ta-woɠa zɔkpɔiti seɠeni, ti loo taai zu, ʋɛ ziilɛigi ɠɛni ná, ti zunuiti kpein paa. ");
INSERT INTO tod_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ti Ɠamɔɔl ta Sikɛmeni ɓalaa paani ga boɠa zɔkpɔi, ti lɛ, ti Dina ɠula Sikɛme ná-pɛlɛi wu, ti ɠula ná ʋa. ");
INSERT INTO tod_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Zakɔɓe ná-doun zunui zɔiti ti ʋaani, ti nu ʋoomaiti zeaɠɔligiti seɠe, ti taazuʋɛ zɔɔlaiti seɠe, tɔɔzei ti ɓaaɠulani ti-ʋaazeelai ma. ");
INSERT INTO tod_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ti togani goiti ta ma wolaiti seɠeni, é ʋɛɛ soovalegiti ba, nii kpein nɔ é ɠɛni taazuʋɛ, ta ɓalaɠaiti su. ");
INSERT INTO tod_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ti liini ga ta-naavoloiti kpein, ta ti-lointi, ta ti-anzaiti, ta nii kpein é ɠɛni pɛlɛiti bu, ti naati kpein seɠeni. ");
INSERT INTO tod_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Zakɔɓe ɠɛni naazu Simiyɔn ta Levi ma: «Wa kpɔ̀lɔzu, wo màayoseɠe zooi zu nuɓusɛiti bɛ, niiti ti ga Kanaan nuiti, ta Felɛze nuiti. Nuɓusɛ go nɔ ɠa é zèa, ta ʋaazu ɠaalɛɛzu ba dàalɔɠɔma, ti kɔɔi ʋɛɛ bà, ti kòloɠolo, nà-o, nà-pɛlɛyeɠei-yo.» ");
INSERT INTO tod_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ti gooɠaaʋoteni, ti ɠɛ ma: «Lee vaa zu gá gi-ʋaazeelai yɛ ná, ti so eɠɛ koloɠolo anzanu?» ");
INSERT INTO tod_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","GALA ge ɠɛni Zakɔɓe ma: «Wuzeɠe, è lɛ Ɓetɛle, è zei ná. Ɗa zalaɠa ɠulazuʋɛ ta ɓɛtɛ ná GALAGI ʋɛ, nii é ɠulani è ʋɛ kɛlɛma, siɛgi zu è ɠɛni ʋelazu la è-liɛ Ezawu ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Zakɔɓe ɠɛni ná-pɛlɛyeɠe wu nuiti ma, ta niiti kpein ti ɠɛni ba: «À kɔɔɠɔ ganigiti kula ɓɔɠɔ zaama, wo ɓɔɠɔ ɲade, wo wa-zeɠeiti maavalibo. ");
INSERT INTO tod_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ada wuzeɠezu, ade lɛ Ɓetɛle. Nà zalaɠa ɠulazuʋɛ ɓɛtɛzu GALA bɛ náʋɛ, nii é gòoɠaaʋoteni, siɛgi zu gè ɠɛni la kpalai zu, é ɠɛni bà nà-siɛi zu, kɛ̀ai ma pelei zu, gè ɗa li.» ");
INSERT INTO tod_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ti kɔɔɠɔ ganigiti kpein feeni Zakɔɓe ya, niiti ti ɠɛni ti ya, ta goizu anigiti ti ɠɛni ti woizu. Zakɔɓe zeɠei wɔɔni, é ti ʋu su, é pɔlɔi ʋu ti ma sɛne gului wu, Sikɛme ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Naa ʋoluma, ti zeɠeni ná, ti li. GALA ge dualuagi lɔɔni ná maaɠoolii zu laaiti nuɓusɛiti su, nu nɔpɛ ge la mɔ ɠɛni Zakɔɓe ná-doun zunuiti saɠalaboni. ");
INSERT INTO tod_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Zakɔɓe zeelini Luze, taai nii é Kanaan yooi zu, naa ɠa é ga Ɓetɛle, ta ná-siɛpoluiti kpein. ");
INSERT INTO tod_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","É zalaɠa ɠulazuʋɛ ɓɛtɛni ná, é naama adaʋɛ laasei pɛɛni ga Ɛle-Ɓetɛle (nii poluʋɛ ga «Ɓetɛle ƓALAGI»), mazɔlɔɔ miná ɠa GALA ge ɠulani bɛ ná kɛlɛma, siɛgi zu é ɠɛni ʋelazu la diɛ Ezawu ʋa. ");
INSERT INTO tod_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Deɓola, anzanui nii é ɠɛni ga Eleɓɛka zo nui, naa zaani. Ti maaɠuluni Ɓetɛle, sɛne gului wu. Ti ná laasei pɛɛni ga: «Gɔlɔ wo sɛne gului». ");
INSERT INTO tod_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","GALA ge ɠulani mɔnɔ kɛlɛma Zakɔɓe ʋɛ, siɛgi zu é ʋaani la, é zeɠe Padan-Alame, é tuya loo bɛ. ");
INSERT INTO tod_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","GALA ge ɠɛni ma: «È-laaseigi ɠa ga Zakɔɓe, kɛlɛ è la mɔ loli ga Zakɔɓe laaseigi, è-laaseigi ɠa ɠɛ ga Izilayɛle.» É daasei pɛɛni ga Izilayɛle. ");
INSERT INTO tod_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","GALA ge ɠɛni ma: «Nà ga GALA Zɛbɛi-Pɛ-Maliɠii. Ɓuɠu, è ɠaawɔɔlɔ, ziiti ta zii mɔinmɔin ka ɠula è zu, masagaa ta ɠula è ɠoozu. ");
INSERT INTO tod_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Zooi naa gè feeni Abalaame ʋɛ ta Izaake, nà naa veezu è ʋɛ, wa è-mavofodai.» ");
INSERT INTO tod_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Naa ʋolu GALA ge wuzeɠeni, é zeɠe koba, naama adaʋɛ ʋɛ é ɠɛni ɓɔɛzu pɔ ná. ");
INSERT INTO tod_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Zakɔɓe kɔtui ɠaalɔni, ʋɛ GALA ge ɓɔɛni pɔ ná, é puya zalaɠai ʋuuni maazu, ta é gulɔi ʋu ma. ");
INSERT INTO tod_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Zakɔɓe naama adaʋɛ laasei pɛɛni ga Ɓetɛle, ʋɛ GALA ge ɓɔɛni pɔ ná. ");
INSERT INTO tod_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Zakɔɓe ta ná-nuiti ti zeɠeni Ɓetɛle. Aisa ti ʋa zeeli Efelata, ti lago maaɠoozaa ɠɛni de dɛ ná ʋa, eyɛsu Lasɛle ɗa doin zɔlɔɔ. Ná-doun zɔlɔɔ fai ɓaani. ");
INSERT INTO tod_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Doun zɔlɔɔ koozuwanai ma ziɛgi zu, maavie bo anzanui ɠɛni ma: «Mina lua, è doun zunu zɔlɔɔga mɔnɔ.» ");
INSERT INTO tod_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kɛlɛ zii loozuʋɛ, é ʋa za, é daasei pɛɛni ga Ɓɛne-Woni (nii poluʋɛ ga «màanɔɠɔ loun zunui»), kɛlɛ kɛɛɠɛ daasei pɛɛni ga Ɓɛnzamɛn (nii poluʋɛ ga «zeezazu loun zunui»). ");
INSERT INTO tod_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Lasɛle zaani, ti maaɠulu Efelata pelei zu, naa ɠa é ga Ɓɛteleyɛme. ");
INSERT INTO tod_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zakɔɓe kɔtu ziɠigi loni ná-kabai ma ga ɠizɛsui. Zaaɠaza ta ɠɛɛzu ma «Lasɛle ná-kabama ɠizɛsu ɠɔtui». ");
INSERT INTO tod_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Izilayɛle wuzeɠeni, é li, é ná-seɠe ɠotai lo Migedale-Edɛɛl ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Siɛgi zu Izilayɛle ɠɛni zeini la naama yooi zu, Luɓɛn liini, é la ga Ɓiliɠa, kɛɛɠɛ anza ɠiligi nii é la ɠɛni vuluni ga zɔi ɠɛʋele. Izilayɛle naama wooi mɛnini. Zakɔɓe ná-doun zunuiti tiegɔi ɠɛni ga puugɔ maazu fele (12). ");
INSERT INTO tod_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ná-doun zunuiti ti ɠɛni ga: Luɓɛn, Zakɔɓe ná-doun zunu mɔungi, ta Simiyɔn, Levi, Zuda, Isakaal, ta Zaɓulɔn. ");
INSERT INTO tod_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Lasɛle ná-doun zunuiti ti ɠɛni ga: Zozɛfe ta Ɓɛnzamɛn. ");
INSERT INTO tod_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Lasɛle ná-botiɠɛ anzanui Ɓiliɠa ná-doun zunuiti ti ɠɛni ga: Dan ta Nɛfɛtali. ");
INSERT INTO tod_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Lea ná-botiɠɛ anzanui Zilepa ná-doun zunuiti ti ɠɛni ga: Gade ta Asɛɛl. Zakɔɓe ná-doun zunuiti kana, é ti zɔlɔɔni Padan-Alame. ");
INSERT INTO tod_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Zakɔɓe ɠaleni ma, é ʋa kɛɛɠɛ Izaake ʋɔ bɛ, Mamelé, nii é ga Kiliyate-Aaleɓa, daasei pɛai ga Eɓelɔn, ʋɛ Abalaameni ta Izaake ti seikɔɠɔmai ɠɛni ná. ");
INSERT INTO tod_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Izaake zii ma voloi kpein ge ɠɛni ga kona ungila kona ʋuulɔsaʋa (180). ");
INSERT INTO tod_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Naa ʋolu zii looni, é za, é li mɛmɛwolani pɔ ti zaai. É wɔlɔzaɠani, sii zuɠooza. Ná-doun zunui Ezawuni ta Zakɔɓe ɠa ti maaɠuluni. ");
INSERT INTO tod_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ezawu nii é ga Edɔme mavofodai ɠa. ");
INSERT INTO tod_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezawu anzanu saʋagɔ zeɠeni, é sei, Kanaan anzanu loungoiti saama: Ada, Elon Ɠɛte nui ná-doun anzanui, Woɠoliɓama, Ana ná-doun anzanui, Siɓeyon Ɠeve nui ná-dounloin, ");
INSERT INTO tod_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ɓasemate, Isemayɛle ná-doun anzanui, Neɓayɔte baazeelai. ");
INSERT INTO tod_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada Elifaze zɔlɔɔni Ezawu ʋɛ, Ɓasemate Leyuwɛle zɔlɔɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Woɠoliɓama Yeyuse zɔlɔɔ, ta Yalame, ta Kola. Ezawu ná-doun zunuiti kana, é ti zɔlɔɔni Kanaan yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ezawu anzaiti seɠeni, ta ná-doun zunuiti, ta ná-doun anzanuiti, ta ná-pɛlɛ wu nuiti kpein, ta ná-togani ɓulugiti, ta ná-toganii kpein, naavoloi kpein é sɔlɔɔni Kanaan yooi zu, é li, é zei zou ɠili su, é maaɠooza deɠei Zakɔɓe ʋa. ");
INSERT INTO tod_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Tɔɔzei naavoloi wola ɠaawɔɔlɔni, ti la ɓena zoo zeizu ʋɔɔma ada ɠila, ta zooi zu, ʋɛ ti seikɔɠɔmai ɠɛni ná, naa la mɔ ɓena kula ɠɛ ti ʋa, tɔɔzei ta-logani ɓulugiti faa ʋa. ");
INSERT INTO tod_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Zekana Ezawu zeini la Seyiil ɠize yooi zu. Ezawu ɠa é ga Edɔme. ");
INSERT INTO tod_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ezawu mavofodai ná-fai ɠaa: Edɔme nuiti ti-mɛmɛwolai, é ɠɛni Seyiil ɠize yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ezawu ná-doun zunuiti ti ɠɛni ga: Elifaze, Ezawu anzai Ada ná-doun zunui, Leyuwɛle, Ezawu anzai Ɓasemate ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaze ná-doun zunuiti ti ɠɛni ga: Teman, Womaal, Sefo, Gayetame, ta Kenaze. ");
INSERT INTO tod_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ezawu ná-doun zunui Elifaze anza ɠiligi ɠɛni ga Timina, nii é la ɠɛni vuluni ga zɔi ɠɛʋele, naa doun zunui zɔlɔɔni bɛ ga Amalɛke. Ezawu anzai Ada ná-dounlointi kana. ");
INSERT INTO tod_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Leyuwɛle ná-doun zunuiti ti ɠɛni ga: Naɠate, Zela, Sama, ta Miza. Ezawu anzai Ɓasemate ná-dounlointi kana. ");
INSERT INTO tod_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ezawu anzai Woɠoliɓama, é ga Ana ná-doun anzanui, Siɓeyon ná-dounloin, naa ɠa é Yeyuse zɔlɔɔni bɛ, ta Yalame, ta Kola. ");
INSERT INTO tod_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Bolodama ɠundiɠiiti kaa, ti ɠulani Ezawu ná-doun zunuiti saama. Ezawu ná-doun mɔungi Elifaze ná-doun zunuiti ti ɠɛni ga: kundiɠii Teman, kundiɠii Womaal, kundiɠii Sefo, kundiɠii Kenaze, ");
INSERT INTO tod_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","kundiɠii Kola, kundiɠii Gayetame, ta kundiɠii Amalɛke. Elifaze nɔnɔ ma wolodama ɠundiɠiiti kana Edɔme yooi zu. Ada ná-dounlointi kana. ");
INSERT INTO tod_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ezawu ná-doun zunui Leyuwɛle ná-doun zunuiti ti ɠɛni ga: kundiɠii Naɠate, kundiɠii Zela, kundiɠii Sama ta kundiɠii Miza. Leyuwɛle nɔnɔ ma wolodama ɠundiɠiiti kana Edɔme yooi zu. Ezawu anzai Ɓasemate ná-dounlointi kana. ");
INSERT INTO tod_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ezawu anzai Woɠoliɓama ná-doun zunuiti ti ɠɛni ga: kundiɠii Yeyuse, kundiɠii Yalame, ta kundiɠii Kola. Ana ná-doun anzanui Woɠoliɓama, Ezawu anzai nɔnɔ ma wolodama ɠundiɠiiti kana. ");
INSERT INTO tod_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ezawu nii é ga Edɔme ná-doun zunuiti kana, ta ma wolodama ɠundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Woli nui Seyiil mavofodaiti kaa, ti ɠɛni ga sei nu mɔungiti zooi zu: Lotan, Sɔɓale, Siɓeyon, Ana, ");
INSERT INTO tod_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Esɛɛl, ta Disan. Naati ka ti ga Woli nuiti ta-wolodama ɠundiɠiiti, Seyiil ná-doun zunuiti, Edɔme yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan mavofodaiti ti ɠɛni ga: Woli ta Ɠemame. Lotan baazeelai laaseigi ɠɛni ga: Timina. ");
INSERT INTO tod_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sɔɓale mavofodaiti ti ɠɛni ga: Alavan, Manaɠate, Eɓale, Sefo ta Woname. ");
INSERT INTO tod_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Siɓeyon ná-doun zunuiti ti ɠɛni ga: Aya ta Ana. Ana tɛi ka é ziɛungi ɠaani teʋebai zu, nii kpadiai, siɛgi zu é ɠɛni daamianigi veezu la kɛɛɠɛ ná-soovalegiti zea, é ɗa ti makɛ. ");
INSERT INTO tod_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ná-dointi ti ɠɛni ga: ná-doun zunui Dison ta ná-doun anzanui Woɠoliɓama. ");
INSERT INTO tod_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison ná-doun zunuiti ti ɠɛni ga: Ɠɛmɛdan, Eseɓan, Yitilan ta Kelan. ");
INSERT INTO tod_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esɛɛl ná-doun zunuiti ti ɠɛni ga: Ɓiliɠan, Zaavan ta Akan. ");
INSERT INTO tod_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ná-doun zunuiti ti ɠɛni ga: Use ta Alan. ");
INSERT INTO tod_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Woli nuiti ta-wolodama ɠundiɠiiti ti ɠɛni ga: kundiɠii Lotan, kundiɠii Sɔɓale, kundiɠii Siɓeyon, kundiɠii Ana, ");
INSERT INTO tod_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","kundiɠii Dison, kundiɠii Esɛɛl ta kundiɠii Disan. Tiya ɠa ti ɠɛni ga Woli nuiti ta-wolodama ɠundiɠiiti Seyiil yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Masagiti daaseigiti kaa, niiti ti masadai ɠɛɛni Edɔme yooi unda, aisa masa ge ʋa zei Izilayɛle unda. ");
INSERT INTO tod_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ɓeyɔɔl ná-doun zunui Ɓela masadai ɠɛɛni Edɔme unda, ná-taai laaseigi ɠɛni ga Dinaɓa. ");
INSERT INTO tod_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ɓela zaai ma, Ɓosela nui Zela ná-doun zunui Yoɓaɓe masadai ɠɛɛni potogi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yoɓaɓe zaai ma, Teman nuiti ta-you zu nui Ɠusame masadai ɠɛɛni potogi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ɠusame zaai ma, Ɓedade ná-doun zunui Ɠadade masadai ɠɛɛni potogi zu. Tɔun ka é vɔnini Madiyan nuiti ma Moaɓe yooi zu. Ná-taai laaseigi ɠɛni ga Avite. ");
INSERT INTO tod_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ɠadade zaai ma, Maseleka nui Samala masadai ɠɛɛni potogi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samala zaai ma, Sayile masadai ɠɛɛni potogi zu. É ɠɛni ga Leɠoɓɔte taa wolai zunu, ziɛ wolai laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sayile zaai ma, Akaɓɔɔl ná-doun zunui Ɓaale-Ɠanan masadai ɠɛɛni potogi zu. ");
INSERT INTO tod_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akaɓɔɔl ná-doun zunui Ɓaale-Ɠanan zaai ma, Ɠadaal masadai ɠɛɛni potogi zu. Ná-taai laaseigi ɠɛni ga Pau. Anzai laaseigi ɠɛni ga Meɠetaɓeyɛle, Matelede ná-doun anzanui, é ga Mezaɠaɓe ná-dounloin. ");
INSERT INTO tod_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ezawu ná-bolodama ɠundiɠiiti daaseigiti kaa, eɠɛʋelei ti-zeizuʋɛti ti la, ta eɠɛʋelei ti-laaseigiti ti la: Timina, Alava, Yetete, ");
INSERT INTO tod_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Woɠoliɓama, Ela, Pinon, ");
INSERT INTO tod_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaze, Teman, Miɓisaal, ");
INSERT INTO tod_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magadiyɛle, ta Iilame. Edɔme ɠundiɠiiti kana, eɠɛʋelei ti-zeizuʋɛti ti la, zooi zu nii ti sɔlɔɔni. Ezawu ɠa é ga Edɔme mɛmɛwolai. ");
INSERT INTO tod_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Zakɔɓe zeini Kanaan yooi zu, ʋɛ kɛɛɠɛ seikɔɠɔmai ɠɛni ná. ");
INSERT INTO tod_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Zakɔɓe ná-pɛlɛyeɠei ná-fai ʋɛtɛ. Zozɛfe kona puugɔ maazu lɔfela (17) ɠulaai ma, ti ɠɛni togani ɓulugi makɛsu ta diɛni kɛɛɠɛ anzai Ɓiliɠa ná-doun zunuiti ta Zilepa ná-doun zunuiti. Zozɛfe ɠɛni ti maalɔɔzu, é ɗa ti-ziɛ ʋele ɲɔiti bo ti-ɠɛɛ ma. ");
INSERT INTO tod_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zozɛfe nɛɛni Izilayɛle ʋɛ, é leʋe zɔɔma lointi ba, mazɔlɔɔ é naa zɔlɔɔni pɔlɔzaɠa siɛgi zu. É seɠe ʋɔnɛ papa feeni bɛ. ");
INSERT INTO tod_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Diɛni ti kaani ga nɛɛʋɛ ti-ɠɛɛ ʋɛ, é leʋe ti kpein ba. Ti wɔinzeɠeni, ti la ɠɛni zoosu ti ʋa ɓɔɛ pɔ ga nɛɛnɛgi. ");
INSERT INTO tod_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Zozɛfe segi ta woni, é ɗa li, é suɠula diɛni ma, naati ti wɔinzeɠeni mɔnɔ ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","É ɠɛni ti ma: «À woilo segi naa ma, nii gè bogai! ");
INSERT INTO tod_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Gè ade ɠaani, de ɗa moloi ɠili ba kpalagaʋɛ. Nà-molo ɠilii wuzeɠeni, é lo, wɔnɔ ma molo ɠiliiti ti ɠoolini ma, ti ɗa nɔkɔ bu.» ");
INSERT INTO tod_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Diɛni ti ɠɛni ma: «Ɗa kaazu ga ɗa ɠɛɛzu ga masagi, è zei gi unda, è ɗa gi leve?» Ti wɔinzeɠeni mɔnɔ sɛsɛ, ná-segiti ta daawooiti maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","É segi taɠili boni mɔnɔ, nii é suɠulani diɛni ma. É ɠɛni ti ma: «Gè segi ta wogɛ mɔnɔ. Gè foloi ɠaani, ta alugi, ta somideɠa puugɔ maazu ɠilagiti (11), ti ʋaani, ti nɔkɔ bù kàkalaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","É suɠulani kɛɛɠɛ ta diɛni ma, naa zelii lo ma, é ɠɛ ma: «Segi naa ʋoluʋɛ ɠa ga lee, nii è bogai? Ɗa kaazu ga nà-o, è-lee-o, gá è-liɛni, gi kpein gá ʋaazu, gi nɔkɔ è wu?» ");
INSERT INTO tod_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Diɛni ti ɠɛni toloi ɠulazu la, kɛlɛ kɛɛɠɛ naama vaiti makɛni ɠigi zu. ");
INSERT INTO tod_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Zozɛfe diɛni ti liini Sikɛme lugiti su ʋele, ga ti ti-ɠɛɛ ná-togani ɓulugi makɛ. ");
INSERT INTO tod_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izilayɛle ɠɛni Zozɛfe ma: «Nà pɔ gè è leʋe è-liɛni pɔ bɛ, ti togani ɓulugi makɛsuʋɛ Sikɛme.» É gooɠaaʋoteni, é ɠɛ ma: «Kɛ̀ɛ, nà ɠaa.» ");
INSERT INTO tod_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Izilayɛle ɠɛni ma: «Li, è è-liɛni pɛtɛ, ni ti ɠɛdɛgɛ, ta ni faa nɔpɛ ge la toganiiti ba, è ɠale ma, è ʋa ga ti-maawoo ʋagɔi pɔ̀.» É Zozɛfe leʋeni ɠana, é zeɠe Eɓelɔn nɛmɛi zu, é li Sikɛme ʋele zɔli. ");
INSERT INTO tod_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ti ɠomini ta zunui ta, é ɗa diɛni ɠaiziɛ dɔɓɔi zu. É gaazaɠani, é ɠɛ ma: «Leeni ɠa è gaiziɛzu?» ");
INSERT INTO tod_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Zozɛfe gooɠaaʋoteni, é ɠɛ ma: «Nà dìɛni gaiziɛzu. Nà è maanɛɛnɛzu, ná lɛ ga ze, ʋɛ dìɛni ti togani ɓulugi makɛsu ná.» ");
INSERT INTO tod_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Zunui ɠɛni ma: «Ti zeɠea ʋɛ, ti li, tɔɔzei gè mɛnini, ti ɗa ɠɛ ma: ‹Ade li Dotan.› » Zozɛfe ʋilɛni diɛni kɔɠɔ ʋogi ʋa, é ɗa li, é ti ɠa Dotan. ");
INSERT INTO tod_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ti kaai ma ɠoozama, kɛɛzu é maaɓuɠa ti ʋa, ti yaavai ɠilini ma ga ti paa. ");
INSERT INTO tod_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ti ɠɛni ɓɔɠɔ ma: «Se bo nui ʋɛtɛ, é ʋaazu. ");
INSERT INTO tod_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","À ʋa, ade paa, de pili zeɠezaɠai taɠila su. Ada ɠɛ ma nɔ sua vilɛi ta ɠa é sogai, da pɛtɛ naazu ʋelegi ná-segiti ti ʋaazu ɠɛɛzu la.» ");
INSERT INTO tod_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Siɛgi zu Luɓɛn naa mɛnini la, é Zozɛfe maaloboni, é ɠɛni pɔ, é kula ti ya. É ɠɛni ti ma: «Ade mina zɛnvui ɠula zea.» ");
INSERT INTO tod_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Luɓɛn ɠɛni ti ma mɔnɔ: «À mina ɲamai ʋu! À seɠe, wo pili zeɠezaɠai nii zu, é teʋebai zu, kɛlɛ à mina yeeloo ma.» É ɠɛni ɠisiɛzu ga é kizo, nii a kɛ é gaaɠale ma, é li kɛɛɠɛ ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Siɛgi zu Zozɛfe zeelini la diɛni pɔ bɛ, ti ná-seɠe ʋɔnɛgi ɠulani ma. ");
INSERT INTO tod_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ti soni, ti seɠe, ti pili zeɠezaɠai ɓogi zu, nii suɲakai ɠɛni de, ziɛ nɔpɛ ge la ɠɛni su. ");
INSERT INTO tod_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ti zeini naa ʋoluma, ti ɗa daamii wo. Ti ɠaazuwuzeɠeni, ti wɛlɛ, ti Isemayɛle nuiti ma ʋɛbɛi ɠa, ti ɗa ʋa, ti ɗa zeɠe Galaade, ta-ɲɔmɛiti kasɔɠiliai ga gulu mana maku nɛɛnɛgi ma aniiti, ti ɠɛni liizu ga tiye Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ná nɔ, Zuda ɠɛ kɛɛɠɛleaiti ma: «Lee ɠulanuma ɠa da sɔlɔɔ, da de-leɠei ʋaana, de ma ɲamai lɔɔɠu? ");
INSERT INTO tod_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ade li, de pɔdi Isemayɛle nuiti ma, de mina yeevɔɔɠu ba, mazɔlɔɔ de-leɠei ɠa ga de-ma ɲamai ta!» Kɛɛɠɛleaiti ti woiloni goo ma. ");
INSERT INTO tod_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Yaaɠoiti ti ɠɛni zeɠezu Madiyan, naati teʋesuʋɛ, ti Zozɛfe mɛɛnni, ti tɛ, ti kula zeɠezaɠai zu, ti pɔdini Isemayɛle nuiti ma ga wali ɠae ʋuufelegɔ (20), naati ti lii la Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Siɛgi zu Luɓɛn ʋaani la ʋolu zeɠezaɠai laaʋɛ, Zozɛfe la mɔ ɠɛni su. É ɠɔba zeɠeiti balini ga kidaaʋiligi maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","É ɠaleni ma kɛɛɠɛleaiti pɔ bɛ, é ɠɛ ti ma: «Doungoi la mɔ ná! Leeni ɠa nà kɛ?» ");
INSERT INTO tod_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ti Zozɛfe ná-seɠei zeɠeni, ti boli zinɛi ɠɔdaaleʋe, ti dɔ ma ɲamai wu. ");
INSERT INTO tod_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ti ná-seɠe ʋɔnɛgi leʋeni ti-ɠɛɛ ma, ti ɠɛ ma: «Wɛlɛ nii ɠa gi kaai! Pɛtɛ, ni è-loun zunui ná-seɠei laade.» ");
INSERT INTO tod_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zakɔɓe kwɛɛni, é ɠɛ ma: «Dòun zunui ná-seɠei ʋe! Sua vilɛi ta soga! Zozɛfe ʋaliʋalia ga!» ");
INSERT INTO tod_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Zakɔɓe ná-seɠeiti balini ga ga kidaaʋiligi maaʋele, é zaamaɠili ga saa wɔlɔ wo seɠei, é folo mɔinmɔin kɛɛni ná-doun zunui ná-saa wɔlɔi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ná-doun zunuiti ta ná-doun anzanuiti kpein ti ʋaani gaanɛɛnɛzu, kɛlɛ é la ɠɛni yeezeini gaanɛɛnɛ nɔpɛ bu. É ɠɛni ɠɛɛzu ti ma: «Nà yɛsu wɔlɔzu, eyɛsu gè yei dòun zunui ʋɔ bɛ gɔvɛalaazu!» É ɠɛni ba nɔ, é ɗa wɔlɔ ná-doun zunui zaa vai zu. ");
INSERT INTO tod_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Madiyan nuiti ti Zozɛfe ʋɔdini Ezipete yooi zu Potifaal ma, nii é ɠɛni ga Falaɠɔn ná-botiɠɛ nu wolai ta, masagi makɛ nuiti ta-ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Naama ziɛgi zu, Zuda zeɠeni kɛɛɠɛleaiti ba, é li, é zei Adulame zunui ta ʋɔ bɛ, nii daaseigi ɠɛni ga Yiila. ");
INSERT INTO tod_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Náʋɛ Zuda Kanaan anzalopoi ta ɠaani, nii kɛɛɠɛ laaseigi ɠɛni ga Suwa. É seɠeni ga anza, é ʋilɛ polu. ");
INSERT INTO tod_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","É kogi zeɠeni, é doun zunu zɔlɔɔ bɛ. É daasei pɛɛni ga Ɛɛl. ");
INSERT INTO tod_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","É kogi zeɠeni mɔnɔ, é doun zunu zɔlɔɔ, é daasei pɛɛ ga Wonan. ");
INSERT INTO tod_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","É doun zunui zaʋasiɛi zɔlɔɔni ʋolu, é daasei pɛɛ ga Sela. Zuda ɠɛni Keziɓe siɛgi zu anzai sɔlɔɔni da. ");
INSERT INTO tod_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Zuda anzanui ta zeɠeni ná-doun zunu mɔungi Ɛɛl ʋɛ, daaseigi ɠɛni ga Tamaal. ");
INSERT INTO tod_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ɛɛl ɠɛni ga nu ɲɔu Ɠɔoɠɔ GALAGI ɠaazu. Ɠɔoɠɔ GALAGI paani. ");
INSERT INTO tod_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Zuda ɠɛni naazu Wonan ma: «Li, è ʋilɛ è-liɛ anzai ʋolu, è-nimɔɠɔi ʋe, sei, è pɔnɔ to è-liɛ ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kɛlɛ Wonan kwɛɛni ga naama lointi ti la ɠɛɛzu ga tɔun nɔnɔ. Naa ɠa é ba, a la ɠɛna ɓɛdɛa diɛ anzai ma, é ɠɛni gaaɓelazu ga é ma ɗɛi ʋu zooi ma, nii a kɛ é mina mavofoda zɔlɔɔ diɛ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Nii é ɠɛni kɛɛzu, naa wola ɲɔuni Ɠɔoɠɔ GALAGI ɠaazu, naa tɔ ɓalaa paani. ");
INSERT INTO tod_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Zuda ɠɛni naazu ná-doun anzai Tamaal ma: «Yɛna ga poanzai è-ɠɛɛ ʋɛlɛi wu, eyɛsu dòun zunui Sela wɔɔlɔ.» É ɠɛni ɓɔɛzu ɠana ga Sela mina za ga diɛni kɛʋele. Tamaal liini, é zei kɛɛɠɛ ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Suɠoozani folo mɔinmɔingaa ti leʋe naa ma, Suwa ná-doun anzanui, é ga Zuda anzai, naa zaani. Siɛgi zu Zuda ná-gɔlɔ wo foloiti ti leʋeni da, é lɛɛni ga Timina ʋele ta bɔɔlai Yiila, Adulame nui, ná-baalagiti maaleɠa leʋezuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ti ɠɛni Tamaal ma: «Wɛlɛ, è-ɠɛɛmɔɔin ɠa lɛɛzu Timina, ná-baalagiti maaleɠa leʋezuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","É ná-poanza zeɠeiti puuni, é seɠei veleveleni ɓɔɠɔ ma, é ɓɔɠɔ ɠaazumaalɔɔɠu, é lɛ, é zei Enayime nu lɛɛzuʋɛ Timina ʋelei zu. Mazɔlɔɔ é pɛtɛni ga Sela wɔɔlɔni niina, kɛlɛ ti la ɠɛni feeni naa ya ga anzai. ");
INSERT INTO tod_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Zuda Tamaal ɠaani ga koloɠolo anzanui ta ʋe, mazɔlɔɔ é ɠaazuʋɛ maalɔɔɠuni. ");
INSERT INTO tod_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","É maaɓuɠani ba pele ɠobaʋɛ, é ɠɛ ma: «Va bu, gè la ga ɗe.» Mazɔlɔɔ é la ɠɛni kwɛɛni ga ná-doun anzai ʋe. Naa ɠɛni ma: «Leeni ɠa ɗa fe zèa, ɗa ʋilɛna pòlu?» ");
INSERT INTO tod_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","É gooɠaaʋoteni, é ɠɛ ma: «Nà boli yiʋo ɠila teʋe è ma, é ɠula nà-togani ɓulugi zu.» Naa ɠɛni ma: «Zèe ɠa bu, kɛlɛ ɗa kpɔunma ve zèa, eyɛsu è teʋe.» ");
INSERT INTO tod_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","É gooɠaaʋoteni, é ɠɛ ma: «Leeni ɠa nà fe è ya ga kpɔunmai?» É ɠɛni ma: «Nii ɗa ɗa yeeʋozɛ da aniiti ba, naa ve zèa, ta ɗa-ɠalui, é ʋɛɛ ɗa-lukpɔi ʋa.» Naa ʋolu é ʋilɛni polu, naa kogi zeɠeni. ");
INSERT INTO tod_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","É wuzeɠeni, é li, é ná-seɠei ʋu, nii é ɠaazumaalɔɔɠuni la, é ná-poanza zeɠeiti seɠeni. ");
INSERT INTO tod_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Zuda boli yiʋoi leʋeni bɔɔlai Adulame nui ʋɔ ga é lii la, é kpɔunma aniiti kula anzanui ya. Kɛlɛ é la ɠɛni anzanui ɠaani mɔnɔ. ");
INSERT INTO tod_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","É náʋɛ nuiti gaazaɠani, é ɠɛ ti ma: «Mini ɠa koloɠolo anzanui ná, nii é ɠɛni losu pele ɠobaʋɛ Enayime?» Ti gooɠaaʋoteni, ti ɠɛ ma: «Koloɠolo anzanu la dɛ niima ada yɔɠɔzuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","É ɠaleni ma, é li, é ɠɛ Zuda ma: «Gè la kaani, náʋɛ nuiti ti ɠɛɛʋɛ mà: ‹Koloɠolo anzanu la dɛ ná yɔɠɔzuʋɛ ɲɛgɛlɛin.› » ");
INSERT INTO tod_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Zuda ɠɛni ma naazu: «É makɛ naa ʋa, nii é zea, de mina ɓɔɠɔ lɔ ɲɛɛɠulasu zu. Wɛlɛ, nɔ̀un gè boli yiʋoi nii leʋega pɔ, kɛlɛ è la kaani.» ");
INSERT INTO tod_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Alu saʋagɔ ɠɛɠala leʋegai ma, ti ʋaani, ti ɠɛ Zuda ma: «È-loun anzai Tamaal koloɠologi ɠɛa, tɔ vɔlɔ kogi ɠa ma, koloɠologi maaʋele ma.» Zuda ɠɛ ma: «À ɠula la, é ɠala.» ");
INSERT INTO tod_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ti ɠɛai ma ɠulazu la eteaʋɛ, é nu leʋeni kɛɛmɔɔin ma, é bo ma ga: «Zunui nii po ge ga niima ɠɔligiti, naa ɠa ná-kogi mà. Nà è maanɛɛnɛzu, ti ʋɛtɛ dɛɛ, ɓɛ ɠa nɔnɔ ga anii, nii nu a ɗa yeeʋozɛ da aniiti ba, ta galui, ta tukpɔi niiti?» ");
INSERT INTO tod_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Zuda ti ɠaai ma, é ti ɠwɛɛni, é ɠɛ ma: «Tɔun sɔlegɛ, é leʋe nɔ̀un ba, é naa ɠɛɛʋɛ, tɔɔzei ba ga, gè la vaani bu, é ʋa zei dòun zunui Sela ʋɛ.» É la mɔ ɠɛni kɛɛni, é ʋa laa la. ");
INSERT INTO tod_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ná-doun zɔlɔɔ siɛgi zeeliai ma, ti kaani ga yoogiti ka ti ɠɛni koozu. ");
INSERT INTO tod_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Doun zɔlɔɔ yeeɠɛɠalai zeeliai ma bɛ, gilagi yeei ɠulani kɛlɛma. Maavie bo anzanui soni, é geze ɓɔigi ɠili zeei ʋa, é ɠɛ ma: «Niima gelei ɠa é ɠulazu mɔunpa.» ");
INSERT INTO tod_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kɛlɛ é yeei lɔɔɠuni mɔnɔ, bɔɔlai ɠula etea mɔunpa. Maavie bo anzanui ɠɛni ma: «È ɠulaʋɛ ga zeeɠaaɓaai!» Ti daasei pɛɛni ga Pelɛze (nii poluʋɛ ga «kulazuʋɛ»). ");
INSERT INTO tod_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Naa ʋoluma bɔɔlai zɔlɔɔni, nii geze ɓɔigi ɠilini zeei ʋa. Ti naa laasei pɛɛni ga Zela. ");
INSERT INTO tod_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ti yeini ga Zozɛfe Ezipete yooi zu. Ezipete nui Potifaal, nii é ɠɛni ga Falaɠɔn ná-botiɠɛ nu wolai ta, ta é ga masagi makɛ nuiti ta-ɠundiɠii, naa ɠa é Zozɛfe ɠeyani Isemayɛle nuiti ma. ");
INSERT INTO tod_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ɠɔoɠɔ GALAGI ɠɛni Zozɛfe ʋa, naa maaʋele ma, é ɠɛni undaanɛɛi zɔlɔɔsu naa kpein su, nii é ɓena kɛ. É ɠɛni maliɠii Ezipete nui ná-pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Naa pɛtɛni ga Ɠɔoɠɔ GALAGI ɠa tɔun ba, nii nɔpɛgi é ɠɛni kɛɛzu, Ɠɔoɠɔ GALAGI ɠɛni naa ɓɛtɛzu zeema. ");
INSERT INTO tod_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Zozɛfe zaalai zɔlɔɔni maliɠii ɠaazu, é dɔɔni ná-botii zu, é sei ná-pɛlɛi unda. Nii kpein é ɠɛni zea, é naati kalivaani ma. ");
INSERT INTO tod_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","É zo naama voloi ma, Potifaal seiɗai ma ná-pɛlɛi unda, ta nii kpein é ɠɛni zea, Ɠɔoɠɔ GALAGI tuya looni Ezipete nui Potifaal ná-pɛlɛi ʋɛ, Zozɛfe maaʋele ma. Ɠɔoɠɔ GALAGI ná-tuyai ɠɛni zeaɠɔligiti kpein ba, é ɠɛni ga pɛlɛi wu, ɓaa kpalagaʋɛti. ");
INSERT INTO tod_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Niiti kpein ti ɠɛni ga zeaɠɔli, é ti yɛni Zozɛfe yeezu, é la mɔ ɠɛni faa ɠili kɛɛzu, kɛni é ná-daamianigi zeɠe nɔ. Zozɛfe ɠɛni ga zaalamai gola ʋagai. ");
INSERT INTO tod_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Naama vaiti pɛ poluma, Zozɛfe maliɠii anzai ɠaazuɠulani ba, é ɠɛ ma: «Laa ga ze.» ");
INSERT INTO tod_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","É ɠɛlɛni, é ɠɛ maliɠii anzai ma: «Pɛlɛi wu vai leʋe ga kɔɠɔ felegɔ, màliɠii la faa nɔpɛ kwɛɛ ta zu, é ti pɛ zɛgɛ zèezu. ");
INSERT INTO tod_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","É la wɔɔlɔni nɔ̀un ba niima ʋɛlɛi wu, é la tɔ seini faa nɔpɛ ma, kɛni ɗa nɔ, tɔɔzei ɗa ga anzai. Nà naama vaa ɲɔu wolai ɠɛɛzu ɠale, gè koto zeɠe GALA daalɔɠɔma?» ");
INSERT INTO tod_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Folo-o-folo é ɠɛni ɓɔizu Zozɛfe la, é ɗa faa ɠilagi nɔ wo ma, kɛlɛ naa la ɠɛni woilosu ta ma, é ɠɛlɛni ná-dakoba vai ʋa, ga a ʋa ʋilɛ polu. ");
INSERT INTO tod_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Foloi ta, Zozɛfe ʋaani, é lɛ pɛlɛi wu, ga é ná-botii ɠɛ. Nu nɔpɛ ge la ɠɛni ná, pɛlɛi wu nuiti su. ");
INSERT INTO tod_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","É soni ná-seɠei ʋa, é ɠɛ ma: «Laa ga ze!» Zozɛfe ná-seɠei yɛni zea, é ʋela, é ɠula etea ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Siɛgi zu é kaani la ga naa ná-seɠei yɛga zea, é ʋela, é li ga etea ʋelei, ");
INSERT INTO tod_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","é ná-pɛlɛ wu nuiti tolini, é ɠɛ ti ma: «Sìnigi ʋaa ga Eɓulu nui ade ʋɔ, é ɗa ɓaaɠula ade ma. Paaʋɛ pɔ̀, é ɠɛ é la ga ze, kɛni kpàingai. ");
INSERT INTO tod_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Siɛgi zu é kaai la ga gè wooɠula ga kpeei, é ná-seɠei yɛgɛ ʋuuni kòbaʋɛ, é ʋela, é li ga etea ʋelei.» ");
INSERT INTO tod_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","É Zozɛfe ná-seɠei yɛni ɠobaʋɛ, eyɛsu sinigi ʋaa pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","É faa ɠilagi nɔ woni ma, é ɠɛ ma: «Eɓulu nui é ga duɔi, nii è ʋaai la ade ʋɔ, paaʋɛ pɔ̀ ga é ɓaaɠula mà. ");
INSERT INTO tod_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kɛlɛ tɛi gè wooɠulaai ga kpeei, é ná-seɠei yɛgɛ kòbaʋɛ, é ʋela, é li ga etea ʋelei.» ");
INSERT INTO tod_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kpegai ma ga anzai ɓɔɛ wooiti mɛni, é ɗa ɠɛ ma: «Wɛlɛna, naa ɠa ɗa-luɔi kɛa,» Zozɛfe maliɠii wola yiiɠaawanani. ");
INSERT INTO tod_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","É Zozɛfe zoni, é pili kasoi ɠa, ʋɛ masagi ná-kasoɠa nuiti ti makɛni ná. Miná ɠa Zozɛfe ɠɛni ná kasoi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ɠɔoɠɔ GALAGI ɠɛni Zozɛfe ʋa, é wooɠɛɠiladai ɠɛ bɛ, nii a kɛ naa zaalai zɔlɔɔ kaso ɠundiɠii ya. ");
INSERT INTO tod_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Kaso ɠundiɠii kasoɠa nui zɔiti kpein kalivaani Zozɛfe ma. Faa nɔpɛ ge la ɠɛni ɠɛɛzu tɔun polu. ");
INSERT INTO tod_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kaso ɠundiɠii la mɔ ɠɛni wɛlɛzu naama vai tanɔpɛ ma, nii é ɠɛni ɠɛɛzu Zozɛfe yeezu, mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠɛni ba. É vaani bu, naa pɛ suɓɛtɛ, nii é ɠɛni kɛɛzu. ");
INSERT INTO tod_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Naama vaiti poluma, Ezipete masagi Falaɠɔn ná-kpɔleɓɔle gani wotiɠɛ nuiti ta-ɠundiɠii ta ná-daaɠoli wotiɠɛ nuiti ta-ɠundiɠii ti ɓaaɠoni ti-maliɠii, Ezipete masagi ma. ");
INSERT INTO tod_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Falaɠɔn yiiɠulani niima ɠundiɠi felegɔiti daalɔɠɔma, kpɔleɓɔle gani wotiɠɛ nuiti ta-ɠundiɠii ta daaɠoli wotiɠɛ nuiti ta-ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","É ti ʋilini kasoi ɠa, masagi makɛ nuiti ta-ɠundiɠii ná-pɛlɛi wu, ʋɛ Zozɛfe makɛga ɠɛni de ná. ");
INSERT INTO tod_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Naa ti ɠalivaani Zozɛfe ma, ga é ɗa wɛlɛ ti ma. Ti yeeɠɛɠalai ta ɠɛɛni kasoi ɠa sɛ. ");
INSERT INTO tod_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kpidii ta, Ezipete masagi ná-kpɔleɓɔle gani ɠundiɠii ta ná-daaɠoli ɠundiɠii, ti ɠɛni kasoi ɠa, ti felegɔ pɛ ti segi woni, ɛsɛni ta nɔnɔ ma zegi, poluʋɛ ɠɛni ti ɠilagilagi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Naa ʋoluma zobui, Zozɛfe ʋaai ma ti ʋɔ bɛ, é wɛlɛni ti ʋa, ti pɛ ti ɠaazuɠiliai. ");
INSERT INTO tod_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","É Falaɠɔn ná-botiɠɛ ɠundiɠiiti gaazaɠani, ti ɠɛni tɔun ba maliɠii ná-pɛlɛi wu kasoi ɠa, é ɠɛ ti ma: «Lee vaa zu za wo-ɠaazuʋɛti ɲɔuɗai?» ");
INSERT INTO tod_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ti gooɠaaʋoteni, ti ɠɛ ma: «Gi segi wogɛ, kɛlɛ nu nɔpɛ ge la ná, nii a poluʋɛ wo gi ma.» Zozɛfe ɠɛni ti ma: «GALA tɛi a zoo é segiti poluʋɛti bo ɓaa? À wa-zegiti suɠula lɛɛ mà.» ");
INSERT INTO tod_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kpɔleɓɔle gani ɠundiɠii laalɔɔni ná-segi zu, é suɠula Zozɛfe ma, é ɠɛ ma: «Nà-segi zu, wɛlɛ, ansaɠɔ tɔkulugi ɠɛni kàkalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ansaɠɔ tɔkulugi naama ɓeke saʋagɔ ɠɛni ba. Siɛgi zu é lɛnuni la, ma ʋuai ɠulani, ta ma ɠɔpɔgiti ti leezɛn ɓɔigi ve. ");
INSERT INTO tod_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Falaɠɔn ná-kpɔɔle wɔwɔi ɠɛni zèa zoni, gè leezɛinti seɠeni, gè ti luɓa Falaɠɔn ná-kpɔɔle wɔwɔi zu, gè kpɔɔle wɔwɔi ve Falaɠɔn ya.» ");
INSERT INTO tod_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Zozɛfe ɠɛni tɔun ma: «Poluʋɛ ɠaa: ma ɓeke saʋagɔiti ta ga folo saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Folo saʋagɔ a leʋena, Falaɠɔn ɠa ɗɔungi wuzeɠe, é è ɠaaɠale ma ɗa-wotii zu. Ɗa ná-kpɔɔle wɔwɔi zeizu zeezaamaʋɛ, eɠɛʋelei è ɠɛni kɛɛzu la, siɛgi zu è ɠɛni la ga ná-kpɔleɓɔle ganiiti ma ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kɛlɛ nà è maanɛɛnɛzu, ɠizɛ sù, siɛgi zu è undaanɛɛzu la, nuɓɔɠɔla ɠɛ bɛ̀, è nà-faa ʋagɔ wo Falaɠɔn ma, nii a kɛ é kùla niima ɠasoi ɠa. ");
INSERT INTO tod_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mazɔlɔɔ ti kùlaʋɛ Eɓulu nuiti ta-yooi zu ga zeeɠaaɓaai, ʋɛ ɓalaagi gè la faa ɲɔu nɔpɛ kɛɛni, nii nà ʋili kasoɠa ma vaa zu.» ");
INSERT INTO tod_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Siɛgi zu daaɠoli wotiɠɛ nuiti ta-ɠundiɠii kaani la ga Zozɛfe segi ʋolu ʋagɔ wogɛ, é ɠɛni ma: «Nà ɓalaa gè segi ta wogɛ, ɓulu ɓɔlɔ saʋagɔ ɠɛni zeini ùnma. ");
INSERT INTO tod_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kpɔlɔgi nii gaaɠoozaa ɠɛni de, daamianigi ma zii kpein ge ɠɛni su Falaɠɔn ʋɛ, kɛlɛ wɔniiti ti ɠɛni miizu kpɔlɔgi zu, é zeini ùnma.» ");
INSERT INTO tod_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Zozɛfe gooɠaaʋoteni, é ɠɛ ma: «Poluʋɛ ɠaa: kpɔlɔ saʋagɔiti ta ga folo saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Folo saʋagɔ a leʋena, Falaɠɔn ɠa ɗɔungi leʋe è ʋa, é è zɛlɛ gului ʋa, wɔniiti ta è-ma zuai mi.» ");
INSERT INTO tod_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Foloi zaʋasiɛi ma, Falaɠɔn zɔlɔɔ fai ma ɠoozunɛ yeei, é daamiani nɛɛnɛ golai ɓɛtɛni, é fe ná-botiɠɛ nuiti kpein bɛ. Ná-botiɠɛ nuiti gaazu, é kpɔleɓɔle gani wotiɠɛ nuiti ta-ɠundiɠii ɠulani, ta daaɠoli wotiɠɛ nuiti ta-ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","É kpɔleɓɔle gani ɠundiɠii ʋilɛni mɔnɔ ná-botii ma, é ɗa kpɔɔle wɔwɔi zei Falaɠɔn yeezaama. ");
INSERT INTO tod_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Kɛlɛ é daaɠoli wotiɠɛ nuiti ta-ɠundiɠii zɛlɛni gului ʋa. Faiti pɛ ti ʋilɛni su, eɠɛʋelei nɔ Zozɛfe ta-zegiti poluʋɛti boni la. ");
INSERT INTO tod_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kɛlɛ kpɔleɓɔle gani wotiɠɛ nuiti ta-ɠundiɠii la ɠɛni ɠizɛni Zozɛfe zu, é yeemani ma. ");
INSERT INTO tod_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kona felegɔ leʋegai ma, Falaɠɔn segi ta woni. Pɛtɛ: é ɠɛni ziɛ wolai Nile ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","É nikɛ zaa lɔfela ɠaani, ti wola ʋagai, ti lɔtɔai. Ti lɛɛni, ti ɠula ziɛ wolai wu, ti ɗa daamii wo tufa lɛnugi zu, ziɛ ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nikɛ zaa lɔfela ɠiligaa ti ɠulani ziɛ wolai wu zɔiti poluma, ti ɲɔuɗai, ti ɠaɲa, ti lo ti ɠobaʋɛ, ziɛ wolai laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nikɛ zaaiti ti ɲɔuɗai ta ti ɠaɲaai, naati ti nikɛ zaa lɔfelaiti miini, niiti ti ʋagai, ti lɔtɔai. Falaɠɔn wuunni. ");
INSERT INTO tod_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","É ɲiini ʋolu, é segi velesiɛi wo. É wɛlɛni, é anii ɠɔpɔ dɔfela ɠa, ti ɠɛzɛai, ti ʋagai, ti ʋɔnɔgai ma lɔkulu gilagi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Naa ʋoluma, ani ɠɔpɔ dɔfela ɠiligaa ti ʋɔnɔni zɔiti poluma, ti ɓooveai, ti ʋooloai ga folo ɠulazu ʋele viilɛi. ");
INSERT INTO tod_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ani ɠɔpɔgiti ti ɓooveai, naati ti ani ɠɔpɔ dɔfela ʋagɔiti kpɔleni, niiti ti ɠɛzɛai, ti laavegai. Falaɠɔn wuunni, é gaaɠa ga é ɠɛa segi zu. ");
INSERT INTO tod_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sobui, Falaɠɔn ɠɛni unga wuulee, é Ezipete molikulagiti ta ma ɠima nuiti kpein tolini, é segiti suɠula ti ma. Kɛlɛ nu nɔpɛ ge la ɠɛni zooni, é ʋa ti ʋoluwo Falaɠɔn ma. ");
INSERT INTO tod_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kpɔleɓɔle gani wotiɠɛ ɠundiɠii kpɔɛi zeɠeni, é ɠɛ Falaɠɔn ma: «Kìgi loa nà-faaɠaazagi zu za. ");
INSERT INTO tod_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yeeta ɠɛni de, Falaɠɔn yiiɠaawanani ná-botiɠɛ nuiti ma, é nɔ̀un pilini kasoi ɠa masagi makɛ nuiti ta-ɠundiɠii ná-pɛlɛi wu, nà-o, daaɠoli wotiɠɛ nuiti ta-ɠundiɠii-yo. ");
INSERT INTO tod_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kpidi ɠilagi zu, gi felegɔ pɛ gi segiti boni, poluʋɛ ɠɛni ti ʋa. ");
INSERT INTO tod_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Eɓulu zunu loungoi ta ɠɛni gi ʋa náʋɛ, masagi makɛ nuiti ta-ɠundiɠii ná-duɔi, gi gá-zegiti suɠulani ma, é ɛsɛ nɔnɔ ʋoluwoni ma. ");
INSERT INTO tod_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ti pɛ ti ʋilɛni su nɔ, eɠɛʋelei é poluwoni gi ma la. Falaɠɔn pìlɛni ʋolu nà-botii ma, é daaɠoli wotiɠɛ nuiti ta-ɠundiɠii zɛlɛ gului ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Falaɠɔn Zozɛfe lolini, ti kulani kasoi ɠa ga gaazuvilɛi. É nɔungi woni, é ná-seɠeiti maavalibo, é li Falaɠɔn ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Falaɠɔn ɠɛni Zozɛfe ma: «Gè se bogɛ, nu nɔpɛ ge la zooni poluʋɛ wosu, kɛlɛ gè mɛnigɛ ga ɗa ɗa segi ʋoluʋɛ wo, ni nu a suɠulana è ma.» ");
INSERT INTO tod_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Zozɛfe Falaɠɔn wooɠaaʋoteni, é ɠɛ ma: «Nà laade, kɛlɛ GALA ka a gooɠaaʋote pagɔi ve Falaɠɔn ya.» ");
INSERT INTO tod_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Falaɠɔn ɠɛni Zozɛfe ma: «Nà-segi zu, gè ɠɛni loni ziɛ wolai Nile laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Gè nikɛ zaa lɔfela ɠaani, ti lɔtɔai, ti wola ʋagai. Ti lɛɛni, ti ɠula ziɛ wolai wu, ti ɗa daamii wo tufa lɛnugi zu ziɛ ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Naa ʋolu, nikɛ zaa lɔfela ɠiligaa ti ɠulani, ti lɛ zɔiti poluʋelei, ti ɠaɲaai, ti wola ɲɔuɗai, ti-ɠɔlɔgi ɠulaai ti ma, gè la dɛ ti ɠɛɠala ɠaani ɲɔi zu Ezipete yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nikɛ zaaiti ti ɠɔlɔgi ɠulaai ti ma, ti wola ɲɔuɗai, naati ti nikɛ zaa lɔfela mɔungiti miini, niiti ti lɔtɔa ɠɛni de. ");
INSERT INTO tod_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ti ti ɓɔleni, ti yei ti ɠoozu, nu la vɔlɔ kwɛɛga ga ti lɔɔʋɛ ti ɠoozu. Nikɛ zaa ɠaɲaiti ti ɲɔuni nɔ, eɠɛʋelei ti ɠɛni la mɔunpa. Eyɛsu gè wuun. ");
INSERT INTO tod_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Naa ʋolu zegi mɔnɔ, ani ɠɔpɔ dɔfela ti laavegai, ti ʋagai, naati ti ʋɔnɔni ma lɔkulu gilagi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Naa ʋoluma, ani ɠɔpɔ dɔfela ɠiligaa ti ʋɔnɔni zɔiti poluma, ti ɓooveai, ti zuɲakai, ti ʋooloai ga folo ɠulazu ʋele viilɛi. ");
INSERT INTO tod_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ani ɠɔpɔgiti ti ɓooveai, naati ti ani ɠɔpɔ dɔfela ʋagɔiti kpɔleni. Gè suɠulaa molikulagiti ma, kɛlɛ nu nɔpɛ ge la poluʋɛ woni mà.» ");
INSERT INTO tod_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Zozɛfe ɠɛni Falaɠɔn ma: «Segi bogai è ʋɛ, toɠa ga faa ɠila nɔ. Nii GALA ge ʋaazu kɛɛzu, naa ɠana é kula kɛlɛma Falaɠɔn ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nikɛ zaa lɔfela ʋagɔiti ta ga kona dɔfelaiti, ani ɠɔpɔ dɔfela ʋagɔiti ta ga kona dɔfelaiti. Se gila kpegi nɔ ʋe. ");
INSERT INTO tod_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nikɛ zaa lɔfelaiti ti ɠaɲaai, ti ɲɔuɗai, ti ma mɔungiti poluma, naati ta ga kona dɔfela ɓalaa, ta ani ɠɔpɔ dɔfelaiti ti zuɲakaiti, ti ʋooloai ga folo ɠulazu ʋele viilɛi, ta ɠɛɛzu ga kona dɔfela ʋului. ");
INSERT INTO tod_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Eɠɛʋelei nɔ gè boga da Falaɠɔn ma, nii GALA ge ʋaazu kɛɛzu, naa ɠa é kulaa kɛlɛma Falaɠɔn ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pɛtɛ, kona dɔfela laawu, daamianigi wola ɠa mɔin Ezipete yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Pului ma ɠona dɔfelai ɠa ʋa naati poluma, nu ɠa yeema anii mɔin ziɛgi naa ma Ezipete yooi zu. Pului ɠa zooi ɠoloɠolo. ");
INSERT INTO tod_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Pului naa é ʋaazu, toɠa ɓɔi, nu ɠi ge la mɔ loa su vɔlɔ ga ni daamiani ge ʋooʋani zooi zu. ");
INSERT INTO tod_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ni Falaɠɔn segi ɠaa, ná zeizu ɠɛ fele, naa ɠa ga faa ʋe deveai niina GALA bɛ, é ʋaazu ɠɛɛzu ga suvilɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Falaɠɔn faa ɠila kɛɛna niizu, wɛlɛ vaa ga ɠima nui ta, nii keleɠelegai, è seɠe, è sei Ezipete yooi unda. ");
INSERT INTO tod_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kɛni Falaɠɔn ani makɛ nuiti sei zooi zu, ga ti Ezipete moloi zeizu lɔɔlusiɛi zeɠe ba, ani mɔin ɠona dɔfelaiti ma ziɛgiti su. ");
INSERT INTO tod_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kona pagɔiti su ti ʋaazu zeelizu, ti naama laamianigiti kpein gaalɛ ba, Falaɠɔn ná-devei wu, ti moloiti gaalɛ ba taaiti su, molo makɛsuʋɛti, ti ɗa wɛlɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Daamianigi naati ta ɠɛ ʋuuni ná zooi ʋɛ, pulu ɠona dɔfelaiti bɛ, ti ʋaazu Ezipete yooi zu, naa ɠa a kɛ nuɓusɛiti ti mina za ga pului zooi zu.» ");
INSERT INTO tod_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Naama wooiti ti wola nɛɛni Falaɠɔn ta ná-botiɠɛ nu wolaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Falaɠɔn ɠɛni ti ma: «Ada zoo nu ɠili sɔlɔɔsu nɛi ɓaa ga nii ɠɛʋele, nii GALA Zɛnvui a ɠɛ zeini su?» ");
INSERT INTO tod_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Falaɠɔn ɠɛni Zozɛfe ma: «Tɛi GALA ge niima vaiti dɛa ga ɗe, nu nɔpɛ ge la ná nii a ɠeleɠele, é ɠɛ ga ɠima nu ɓalaa ga è ɠɛʋele. ");
INSERT INTO tod_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ɗa ɠa è ɠɛɛzu nà-pɛlɛyeɠei unda, nà-nuɓusɛiti kpein ta ɠolo ɗa-lɔgiti bɛ. Nà ɓɔɠɔi nɔ ɠa teʋegai è ʋa, ta gè ɠɛ è maazu ga masa kpɔkpɔgi maaʋele.» ");
INSERT INTO tod_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Falaɠɔn ɠɛni Zozɛfe ma: «Wɛlɛ, gè è zeiɗa Ezipete yooi kpein unda, devei ɠa ɗa nɔ è ya.» ");
INSERT INTO tod_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Falaɠɔn nà-masa balaɠaegi ɠulani yee ʋa, é dɔ Zozɛfe yeei ʋa. É seɠei looni kɔba, nii é ga geze ʋagɔi. É zanu kɔbu ansai ʋilini kɔbu. ");
INSERT INTO tod_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","É tɛɛni ná-wotoloi velesiɛi zu. Teʋesuʋɛ, ti ɗa zeze kakala ʋelei, ti ɗa ɠɛ ma: «À ʋilɛ ɲiibiɠa!» Zekana Falaɠɔn Zozɛfe zeini la Ezipete yooi kpein unda. ");
INSERT INTO tod_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Falaɠɔn ɠɛni mɔnɔ Zozɛfe ma: «Nà ɠa gè ga Falaɠɔn! Ni ɗa laade, nu nɔpɛ ge la yeeʋua faa wu Ezipete yooi kpein su.» ");
INSERT INTO tod_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Falaɠɔn Zozɛfe laasei pɛɛni ga Safenate-Payeneya. É Asenate zeɠeni, é fe zea ga anza, galagi daa ga Won, naa ná-zalaɠa ɠula nui Potifela ná-doun anzanui. Zozɛfe liini, é leʋeteʋe, é wɛlɛ Ezipete yooi ná kpein su. ");
INSERT INTO tod_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Zozɛfe ná-konagi ɠɛni niina ga puusaʋagɔ (30), siɛgi zu é liini la, é lo Ezipete masagi Falaɠɔn ɠaazu. Seɠeai ma Falaɠɔn ʋɔ bɛ, é Ezipete yooi kpein suɓizɛni. ");
INSERT INTO tod_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Kona dɔfelaiti daawu, niiti daamianigiti ti ɓɛtɛni su, zooi baalɔnɔgi veeni ga pooʋamai. ");
INSERT INTO tod_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Zozɛfe kona dɔfelai ma laamianigiti kpein gaalɛɛni ba Ezipete yooi zu, é daamianigiti maaɓɔni, é pu taaiti su. É naa ʋuuni taai ɠilagilagi ɠoozuʋɛ, nii é ga maaɠoolii zu yooi ná-daamianigiti. ");
INSERT INTO tod_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Zozɛfe moloi ɠaalɛɛni ba, gola mɔin eɠɛ kpoloɗɛi ma ɲaɠaegi. Naama ʋooʋamai maaʋele ma, ti looɠoni gaalu fai ʋa, tɔɔzei nu la mɔ ɠɛni zoosu é ʋa gaalu, tiegi lateʋega ɠɛni de. ");
INSERT INTO tod_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Pulu ɠona mɔunpagi yeeluɠɔ, Won ná-zalaɠa ɠula nui Potifela ná-doun anzanui Asenate zunu loun felegɔ zɔlɔɔni Zozɛfe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Zozɛfe doun mɔungi laasei pɛɛni ga Manasé, mazɔlɔɔ é ɠɛni ma: «GALA ge zèema nà-kpɔlɔiti kpein ma, ta kɛ̀ɛ ná-pɛlɛyeɠei kpein ma.» ");
INSERT INTO tod_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","É felesiɛi laasei pɛɛni ga Efelayime. É ɠɛni ma: «Mazɔlɔɔ GALA ge kɛ̀a ga kpuɠu nu, zooi naa zu, ʋɛ gè ziiɓɔlɔi zɔlɔɔni ná.» ");
INSERT INTO tod_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kona dɔfelai niiti aniiti ti wola ɓɛtɛni su Ezipete yooi zu, naati ti leʋeni. ");
INSERT INTO tod_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kona dɔfela ʋuluiti ti tɔɔzeini ga ʋaa, eɠɛʋelei Zozɛfe boni la. Pului looni zooi kpein su, kɛlɛ daamianigi ɠɛni Ezipete yooi pɛ su. ");
INSERT INTO tod_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Siɛgi zu pului a la Ezipete yooi kpein sona da, nuɓusɛiti ti ɓena kpeei loo Falaɠɔn woizu ga ti daamianigi zɔlɔɔ. Falaɠɔn ɠɛni Ezipete nui kpein ma: «À li Zozɛfe ʋɔ bɛ, nii é bosu wo ma, wo naa ɠɛ.» ");
INSERT INTO tod_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Pului looni zooi kpein su. Zozɛfe daamiani makɛsuʋɛti kpein daalaoni, é ɗa moloi ʋɔdi Ezipete nuiti ma. Pului ɠɛni liizu ga ɓɔiɗa Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Nui ɠɛni zeɠezu zooi kpein su, ti ɗa ʋa Ezipete, Zozɛfe ʋɔ bɛ, ga ti moloi ɠeya, mazɔlɔɔ pului wola ɓɔini zooi kpein su. ");
INSERT INTO tod_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Zakɔɓe kaai ma ga moloi ɠa Ezipete yooi zu, é ɠɛni ná-doun zunuiti ma: «Lee vaa zu wo wɛlɛzu ɓɔɠɔ ʋa wo ɠilagilagi? ");
INSERT INTO tod_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Gè mɛnigɛ ga moloi ɠa Ezipete yooi zu. À yei, wo ta ɠeya ná ade ʋɛ, nii a kɛ ade yɛ vulua, ade mina za.» ");
INSERT INTO tod_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Zozɛfe kɛɛɠɛloun puugɔiti ti yeini Ezipete yooi zu molo ɠeyazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Zakɔɓe la ɠɛni Zozɛfe deɠei Ɓɛnzamɛn ʋilɛni ti ʋolu, é ɠɛni luazu ga faa ɲɔu mina ɠɛ la. ");
INSERT INTO tod_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Izilayɛle ná-doun zunuiti ti ɠɛni zɔiti saama, niiti ti yeini molo ɠeyazuʋɛ, mazɔlɔɔ pului ɓɔini Kanaan yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zozɛfe ɠa é ɠɛni devei wosu zooi zu ná kpein. Tɔ ɠa é ɠɛni moloi ʋɔdizu nuɓusɛi kpein ma. Zozɛfe kɛɛɠɛleaiti ti ʋaani, ti nɔkɔ bu, ti unpilɛ zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Zozɛfe kɛɛɠɛleaiti kaani. É ti ɠwɛɛni, kɛlɛ é ɓɔɠɔ ɠɛɛni, eɠɛ é la ti ɠwɛɛ. É la ɠɛni ɓɔɛni ti ʋɔ fɔɔn, é ɠɛni ti ma: «Mini ɠa wo zeɠeai ná?» Ti gooɠaaʋoteni, ti ɠɛ ma: «Gá zeɠezu Kanaan yooi zu, gi ʋaaʋɛ daamiani geyazu.» ");
INSERT INTO tod_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Zozɛfe kɛɛɠɛleaiti kwɛɛni, kɛlɛ tiya mu ti la ɠɛni tɔun kwɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Zozɛfe ɠigi looni segiti su, é boni, é ʋilɛ ti ʋa. É ɠɛni ti ma: «Wa ga nɛnɛgiti! Wo ʋaaʋɛ ga wo zooi ná-zobotalazuʋɛti sumɔ.» ");
INSERT INTO tod_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ti gooɠaaʋoteni, ti ɠɛ ma: «Ɓa-o, màliɠii, gɛi gi ga ɗa-wotiɠɛ nuiti, gi ʋaaʋɛ nɔ ga gi molo ɠeya. ");
INSERT INTO tod_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Gi kpein gá nɔ ga zunu ɠila kpegi ná-doun zunuiti, gá ga sɔɓelama nuiti, ɗa-wotiɠɛ nuiti gi la ga nɛnɛgaa nɔ.» ");
INSERT INTO tod_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","É ɠɛni ti ma: «Kpele-o, wo ʋaaʋɛ zooi ná-zobotalazuʋɛti sumɔsu nɔ.» ");
INSERT INTO tod_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ti gooɠaaʋoteni, ti ɠɛ ma: «Ɗa-wotiɠɛ nuiti gá ga kɛɛɠɛloun puugɔ maazu felegɔ (12), zunu ɠila kpegi ná-doun zunuiti Kanaan yooi zu. Loungo gelei, naa yɛgɛ gi-ɠɛɛ ʋɔ bɛ za, gila ge ɠɛni ná, naa la mɔ vulua.» ");
INSERT INTO tod_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Zozɛfe ɠɛni ti ma: «Naa mu ka gè bosu wo ma, gè ɠɛ ma, wa ga nɛnɛgiti. ");
INSERT INTO tod_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Wɛlɛ, ʋelegi gè ʋaazu wo ʋoluɠulazu la. Nà ɠonazu Falaɠɔn ma, nii é vulua, wo la ɠulazuʋɛ ɲɛgɛlɛin, ni wo-leɠei la ʋaani ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Wo zaama, à gila teʋe, é li, é ʋa ga wo-leɠei. Wa ma, wo yɛ kasoi ɠa eyɛsu wo ɓɔɛ wooiti poluɠula, nà kwɛɛ ni gaamai ɠa wo bosu. Ni naa laade, gè ɠonaa Falaɠɔn ma, nii é vulua, wa ga nɛnɛgiti.» ");
INSERT INTO tod_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","É ti kpein dɔɔni ʋɔɔma kasoi ɠa folo saʋagɔ laawu. ");
INSERT INTO tod_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Foloi zaʋasiɛi ma, Zozɛfe ɠɛni ti ma: «Nɔ̀un nà luazu GALA ba. Nii gè bosu wo ma, à naa ɠɛ, wa zɛnvui wo. ");
INSERT INTO tod_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ni wa ga sɔɓelama nuiti, wo-ɠɛɛloin ta yɛ kasoi ɠa, ʋɛ wo ná, wɔun, wo li ga moloi, wo wa-ʋɛlɛyeɠeiti kɔnɔkula la, ");
INSERT INTO tod_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","naa ʋolu wo ʋa pɔ̀ ga wo-leɠei, naa ɠa a kɛ wa-ɓɔɛiti poluɠula, wo mina za.» Ti yeezeini naa wu, ti naa ɠɛ. ");
INSERT INTO tod_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ti ɠɛni ɠɛɛzu ɓɔɠɔ ma: «Ungo, ade ɠɛɛʋɛ ga sɔba nu de-leɠei letegi, mazɔlɔɔ de ná-ziizoolɛi ɠaani, siɛgi zu é ɠɛni de maanɛɛnɛzu la, de la ɠɛni woiloni ma ɲɛgɛlɛin! Naa ɠa é kɛa niima maanɔɠɔ vai zeelia ade ma la.» ");
INSERT INTO tod_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Luɓɛn kpɔɛi zeɠeni, é ɠɛ ti ma: «Gè la ɠɛni bosu wo ma ɓaa, ga: ‹À mina ɲama ɠula gaazu vaa ɠɛ ga doungoi nii›? Kɛlɛ wo la ɠɛni woiloni gòo ma ɲɛgɛlɛin. Ma ɲamai ɠa niizu maaɠaazaɠa ge wosu de ma.» ");
INSERT INTO tod_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ti la ɠɛni suɠwɛɛ ga Zozɛfe ɠa gaaɠaazu, mazɔlɔɔ é ɓena daawooleʋe nui ɠɛ ti yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Zozɛfe maaɠoozani ti ʋa, é li, é lo, é ɗa wɔlɔ. É ʋaani ʋolu, é ɓɔɛ ti ʋɔ, é Simiyɔn ɠulani ti zaama, é gili ti ɠaazu. ");
INSERT INTO tod_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Zozɛfe devei veeni ga ti ta-ɓɔlɔiti daave ga moloi, ti ɛsɛ ná-walii la ná-ɓɔlɔi zu, ti daamianigiti fe ti ya, ta mi pelei zu. Naa ɠa ti kɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ti ta-zoovalegiti kasɔɠilini ga moloi, ti li. ");
INSERT INTO tod_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ti taɠila ge ná-molo ɓɔlɔi laalaoni ga é daamianigi ve ná-soovalegi ya, ʋɛ ti ɲiini ná, é wɛlɛni, é ná-walii ɠa ná-ɓɔlɔi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","É ɠɛni kɛɛɠɛleaiti ma: «Nà-walii ɠaaɠalegɛ ma ʋolu, wɛlɛ lɛɛ ba nà-ɓɔlɔi zu!» Ti ɠoozuʋilini, ti ɗa lua, ti ɗa ɠɛ ɓɔɠɔ ma: «Leeni ɠa GALA ge kɛa ga adeye?» ");
INSERT INTO tod_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ti zeelini ti-ɠɛɛ Zakɔɓe ʋɔ bɛ, Kanaan yooi zu. Ti naa kpein suɠulani ma, nii é ɠɛni ga tiye. ");
INSERT INTO tod_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Ti ɠɛni ma: «Zunui nii é ga zooi maliɠii, kpɔɛʋɛ gi ʋɔ ga ɲɔuɗa, é gi zogɛ, eɠɛ gá ɠɛ ga nɛnɛgiti. ");
INSERT INTO tod_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Gi ɠɛɛʋɛ ma: ‹Gá ga sɔɓelama nuiti, gi la ga nɛnɛgaa. ");
INSERT INTO tod_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Gá ga kɛɛɠɛloun puugɔ maazu felegɔ (12), gi pɛɛ ga kɛɛɠɛi ma. Gilagi la mɔ ná, doungo gelei ɠa gi-ɠɛɛ ʋɔ bɛ za, Kanaan yooi zu.› ");
INSERT INTO tod_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Zunui naa é ga zooi maliɠii, kɛɛʋɛ gi ma: ‹Pɛtɛ ʋelei nà kwɛɛ da ga wa ga sɔɓelama nuiti. À wo-ɠɛɛloin gila zɛ kòba. À daamianigi zeɠe wa-ʋɛlɛyeɠeiti faa ma. Tɔɔzei pului ɓɔiʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","À li, wo ʋa ga wo-leɠei pɔ̀. Nà kwɛɛ ga naa maaʋele ga wo la ga nɛnɛgaa, kɛlɛ wa ga sɔɓelama nuiti. Nà wo-ɠɛɛloin ve wo ya, wa zoo wo ziɛziɛ zooi zu, maaɠili la ɠɛa wo ma.› » ");
INSERT INTO tod_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Siɛgi zu ti ta-ɓɔlɔiti suwoni da, ɛsɛ ná-wali ɓuun ge ɠɛni laani ná-ɓɔlɔi zu. Tiya-o, ti-ɠɛɛ-o, ti wɛlɛni, ti ta-wali ɓuungi ɠa, eyɛsu ti ɗa lua. ");
INSERT INTO tod_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ti-ɠɛɛ Zakɔɓe ɠɛni ti ma: «Wa bàlasu dòinti ma! Zozɛfe la mɔ ná, Simiyɔn la mɔ ná mɔnɔ, wa ga Ɓɛnzamɛn zeɠe mɔnɔ, wo lii la! Nà nɔ ɠa naa kpein ge yɛsu ga ze.» ");
INSERT INTO tod_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Luɓɛn ɠɛni kɛɛɠɛ ma: «Ɗa dòun zunu felegɔiti paa, ni gè la ɠaleni ma è ʋɔ ga Ɓɛnzamɛn. Kaliva mà, nà ɠale ma la, gè ʋaa la è ʋɔ.» ");
INSERT INTO tod_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Zakɔɓe ɠɛni ma: «Ɓa-o! Wo la lia ʋɔɔma pɛ wa dòun zunui, mazɔlɔɔ diɛ zunui zaa, tɔ ɠila kpe nɔ ɠa é zèa niina. Ni faa ɲɔu a maazɔlɔɔna siɛi zu, wo la ʋaazu bosu, wa nɔ̀undeɠa ɠolegiti zeizu gɔvɛalaazu soolɛi zu.» ");
INSERT INTO tod_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Pului ɠɛni liizu ga wola ɓɔiɗa zooi zu. ");
INSERT INTO tod_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Siɛgi zu ti ɓeni la ga moloi mi, nii ti zeɠeni la Ezipete yooi zu, Zakɔɓe ɠɛni ná-doun zunuiti ma: «À ɠale ma, wo li, wo daamianigi tago ɠeya ade ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Zuda gooɠaaʋoteni, é ɠɛ ma: «Zunui naa boni, é maaɓakpa ga: ‹Wo la mɔ ɠaazulaa gàazuʋɛ ma, kɛni wo-leɠei a yɛ ná wo ʋolu, wo ʋa.› ");
INSERT INTO tod_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ni ɗa yeeɓena gi-leɠei ʋa, gi li ʋɔɔma, gá li naazu Ezipete yooi zu, gi daamianigiti geya è ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kɛlɛ ni è la pɔ, è ʋa teʋe, gi la kɛa, gi ʋa yei pɛ, mazɔlɔɔ zunui naa ɠɛɛʋɛ gi ma: ‹Wo la mɔ ɠaazulaa gàazuʋɛ ma, kɛni wo-leɠei a yɛ ná wo ʋolu, wo ʋa.› » ");
INSERT INTO tod_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izilayɛle ɠɛni ma: «Lee vaa ɲɔu mu kana wo kɛai ga ze, wa ɠɛna lia ɠɛɛzu zunui naa ma, wo-ɠɛɛloin taɠili kana mɔnɔ?» ");
INSERT INTO tod_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ti gooɠaaʋoteni, ti ɠɛ ma: «Zunui naa gi ɠaazaɠagɛ ga fɛɠɛlɛfɛɠɛlɛgi gá-vaiti ma, ta gá-ʋɛlɛyeɠe vaiti, é ɠɛ ma: ‹Wo-ɠɛɛ ɠa dɛ vulua ɓaa? Kɛɛɠɛloun ɠili ka wo ʋɛ?› Gá ma, gi gooɠaaʋotegi veeni naati pɛ su, gá la zoo ɠale gi kwɛɛ ga toɠa ɠɛ gi ma: ‹À li, wo ʋa ga wo-leɠe zunui›?» ");
INSERT INTO tod_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Zuda ɠɛni kɛɛɠɛ Izilayɛle ma: «Doungoi yɛ ná, é li pɔ̀, naa ɠa a kɛ, gi wuzeɠe, gi li, ada zoo de zɛnvui wo, ade mina za, ɗa-o, gi-lointi-yo, giya-o. ");
INSERT INTO tod_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nà ɠa gè ga zeelagai, ga nà ɓaazu tɔun maazu, ɗa maaɠaazaɠabo mà, ni gè la ʋaani la ʋolu è ʋɔ, gè ʋa pilɛ è ɠakala si, gè ɠɛ è ya ga sɔba nu eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ni gi la ɠɛni lɛbini eyɛsu niizu zeeli, é ga gi ziɛ ná zeizu ɠɛ ɠɛɠala fele.» ");
INSERT INTO tod_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ti-ɠɛɛ Izilayɛle ɠɛni ti ma: «Tɛi é ɠɛa ɠana, à nii ɠɛɛna mu. À zooi ma zɔlɔɔ gani ʋagɔiti seɠena, wo ti ʋu wa-ɓɔlɔiti su, wo lii la ga sabaliʋai zunui naa ʋɔ, gulɔ maku nɛɛnɛgi tago, ta kɔin gulɔi tago, ta gulu mana maku nɛɛnɛgi, ta miilegi, ta gulu waai ma ɠɛzɛiti, niiti ti ga pisetasegiti ta amandegiti. ");
INSERT INTO tod_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","À walii ma ʋɛɛda felegɔi zeɠe, wo ɠale ma ga walii ti daani wa-ɓɔlɔiti daaʋɛ, tanisu kaka faa nɔ ɠɛni de. ");
INSERT INTO tod_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","À wo-leɠe zunui zeɠe, wo wuzeɠe, wo ɠale ma zunui naa ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","GALA Zɛbɛi-Pɛ-Maliɠii zaalai ve wo ya zunui naa ɠaazu, é va bu, é yeeɓe wo-ɠɛɛloin zɔi ʋa, ta Ɓɛnzamɛn, ga ti ɠale ma wo ʋɔ. Nɔ̀un nà, ni nà ʋalasu dòinti ma, gè ʋala ti ma!» ");
INSERT INTO tod_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ti sabaliʋai zeɠeni, ti walii ma ʋɛɛda felegɔiti seɠe ya, ti li ga Ɓɛnzamɛn ɓalaa. Ti yeini Ezipete yooi zu, ti li, ti ɓɔɠɔ lɛ ga Zozɛfe. ");
INSERT INTO tod_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Zozɛfe wɛlɛni, é Ɓɛnzamɛn ɠa ti ʋa, é ɠɛ ná-naavolo unda nui ma: «Nui niiti tɛ nà-pɛlɛi wu, suai ta ʋaa, è kpɛtɛ, è daamii ɠɛʋele ɓɛtɛ, mazɔlɔɔ niima nuiti ta ʋaazu laamiizu pɔ̀ bɛ folo gaalɔgai ma.» ");
INSERT INTO tod_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Zunui naama vaiti kpein kɛɛni, niiti Zozɛfe deveni ti ma, é liini ga nuiti Zozɛfe ná-pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ti luani siɛgi zu ti liini ga tiye la Zozɛfe ná-pɛlɛi wu, ti ɠɛni ma: «Walii vaa ʋe, é ɠɛni ada-ɓɔlɔiti su zɔizu. Naa ɠa ti liizu ga adeye ma, ti vala ade ʋa ga maaɓaai, ti de ɠɛ ga duɔiti, ti da-zoovalegiti seɠe.» ");
INSERT INTO tod_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ti maaɓuɠaai ma Zozɛfe ná-naavolo unda nui ʋa, ti ɓɔɛni pɔ nu lɛɛzuʋɛ pɛlɛlaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ti ɠɛni ma: «Gi maavaayɛ, màliɠii! Gi ʋaa ná zeizu ɠɛ ɠila, ga gi daamianigiti geya. ");
INSERT INTO tod_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Siɛgi zu gi zeeliai ma ʋɛ maanɛɛni ga gi ɲi ná kpidii, gi gá-ɓɔlɔiti daalaoni, ɛsɛ ge wɛlɛni, é ná-walii ɠa ná-ɓɔlɔi laaʋɛ, é ɠɛni nɔ kpein ga walii naa liegɔi, gi pɔdii looni la. Gi ʋaaʋɛ la ʋolu. ");
INSERT INTO tod_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Gi ʋaaʋɛ ɓalaa ga wali ɠiligaa, ga gi daamianigiti geya. Gi la kwɛɛ ɓɛ ɠa é gá-walii laani gá-ɓɔlɔiti su.» ");
INSERT INTO tod_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Naavolo unda nui ti wooɠaaʋoteni, é ɠɛ ma: «À yiilɛi, wo mina lua! Wa-ƓALAGI ʋe, wo-ɠɛɛ ná-GALAGI, nii é naavoloi laani wa-ɓɔlɔiti su. Wa-walii zeelini zèa.» Naa ʋolu é yeeɓeni Simiyɔn ʋa, é lii la ti ʋɔ. ");
INSERT INTO tod_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","É ti lɛɛni Zozɛfe ná-pɛlɛi wu, é ʋa ga ziɛi ti ʋɔ, ti ɠɔɠɔiti maagba. É daamianigi veeni ɓalaa ta-zoovalegiti zea. ");
INSERT INTO tod_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ti ɠɛni sabaliʋaiti kɛʋele ɓɛtɛzu, ti ɗa Zozɛfe maaɓɔun, é ɠɛɛzu é ʋa folo gaalɔgai ma, mazɔlɔɔ é woni ti ma ga ta daami wosu ʋɔɔma ta tiye. ");
INSERT INTO tod_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Siɛgi zu Zozɛfe ʋaani la ná-pɛlɛi wu, ti sabaliʋai veeni zea, nii é yɛni ti ya, ti ʋaa la, ti nɔkɔni bu zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","É ti ɠaazaɠani ʋelei ti ɠɛʋelei la, é ɠɛ ti ma: «Wo-ɠɛɛ ma wɔlɔzaɠagi, nii wo ná-fai woni, kɛdɛgɛ? Toɠa dɛ vulua?» ");
INSERT INTO tod_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ti gooɠaaʋoteni, ti ɠɛ ma: «Ɗa-wotiɠɛ nui gi-ɠɛɛ ɠɛdɛgɛ, toɠa dɛ vulua.» Ti laani kɔɠɔwu. ");
INSERT INTO tod_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Zozɛfe wɛlɛni, é Ɓɛnzamɛn ɠa, nii é ɠɛni ga deɠei, dee ná-doun zunui. É gaazaɠagi woni, é ɠɛ ma: «Wo-leɠe zunu ɠaaɓelagi ɠaa, nii wo ná-fai woni mà?» É ɠɛni naa ma: «GALA ge è ɠaazumaawɔinɠa, dòun zunu!» ");
INSERT INTO tod_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Zozɛfe ɠulani ga suvilɛ, mazɔlɔɔ deɠei ɠaa vai zu bɛ, naa kɛɛni wuulee, gɔlɔ wɔin soni. É lɛɛni daa ʋɛlɛi wu, é wɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Naa ʋolu é ɠaazuʋɛ gbani, é ɠula ná. É ɠaaɓaani é ɓɔɠɔ zuzo, é ɠɛni ma: «À ʋa ga daamianigi.» ");
INSERT INTO tod_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ti Zozɛfe nɔnɔi veeni zea yɛ, kɛɛɠɛleaiti tɔnɔi ɠɛ yɛ, Ezipete nuiti ti ɠɛni laamiizu pɔ bɛ, naati ɓalaa tɔnɔ veeni ti ya yɛ, mazɔlɔɔ Ezipete nuiti ti la ɠɛni kɛa, ti ʋa laami ʋɔɔma ta Eɓulu nuiti, ti ɠaazu kɔzɔba va ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Zozɛfe kɛɛɠɛleaiti ti zeini gaazu ga ti zɔlɔɔ pelei, é zo ma mɔungi ma, é li ma ɠaaɓelagi ʋɔ. Ti ɠɛni wɛlɛzu ɓɔɠɔ ʋa, ti laavɔai, ti ɠilagilagi. ");
INSERT INTO tod_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Zozɛfe daamianigiti teʋeni ti ʋɔ, niiti ti ɠɛni ná-taɓalii ɠa. Ɓɛnzamɛn ɠɛni sɔlɔɔsu, ná zeizu ɠɛ lɔɔlu, é leʋe zɔiti ba. Ti ɓɔɔleni, ti ɠoozunɛ ta tiye. ");
INSERT INTO tod_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Zozɛfe devei nii veeni ná-naavolo unda nui ya, é ɠɛ ma: «Niima zunuiti ta-ɓɔlɔiti daave ga daamianigiti, eɠɛʋelei ta ziɛ bu la, è ɛsɛ ná-wali la ná-ɓɔlɔi la. ");
INSERT INTO tod_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nà-kpɔɔle wɔwɔi, nii é ga walii, ɗa naa la loungo gelei ná-ɓɔlɔi la, è pɛɛ ná-molo zɔngɔi ʋa.» Pɛlɛ ungi Zozɛfe ná-deveiti kɛɛni. ");
INSERT INTO tod_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sobui, geelaalaogai ma, ti yeeɓeni nui niiti ba ta ta-zoovalegiti, ti li. ");
INSERT INTO tod_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ti ɠulaai ma taai ʋa, ti maa la ɠɛni dɛ ɠoozani, Zozɛfe ɠɛni ná-naavolo unda nui ma: «Wuzeɠe, è li, è ʋilɛ nui niiti polu. Siɛgi zu è ti ɠɔɠɔzu mɛɛnsu da, ɗa ɠɛ ti ma: ‹Lee vaa zu wo faa ʋagɔi zuloozu ga faa ɲɔi? ");
INSERT INTO tod_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Leeni vaa zu wo màliɠii ná-kpɔɔle wɔwɔi unmaai, nii a ɗa ɓɔɔle su, é ɗa seɠe, é adɔi ɓɛɛ la? Faa ɲɔu wola ɠana wo kɛai ga ná.› » ");
INSERT INTO tod_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Naavolo unda nui ti ɠɔɠɔzumɛɛnni, é ɓɔɛ ti ʋɔ, eɠɛʋelei nɔ maliɠii boni la ma. ");
INSERT INTO tod_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ti gooɠaaʋoteni, ti ɠɛ ma: «Leeni vaa zu màliɠii ɓɔɛzu ɠana ga naama zii? Ɗa-wotiɠɛ nuiti ti la dɛ naama ɠisiɛ nɔpɛ boni ga ti naa ɠɛɠala vaa ɲɔu ɠɛ! ");
INSERT INTO tod_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Walii gi kaani gá-ɓɔlɔiti daaʋɛ, gi ʋaaʋɛ ga naa ʋolu è ʋɔ, gi zeɠe la Kanaan yooi zu. Lee vaa zu gá li mɔnɔ walii ɓaa mu zanu unmazu è-maliɠii ná-pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ɗa-wotiɠɛ nuiti gi zaama, zɔi nɔpɛ kpɔɔle wɔwɔi ɠulazu zeeʋo su, naama nui ɠa za, giya ɓɔɠɔi gá ɠɛ ga màliɠii ná-duɔiti!» ");
INSERT INTO tod_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Naavolo unda nui ɠɛni ti ma: «Naa zolooga eɠɛʋelei wo bogai la. Zɔi nɔpɛ a ɠula zeeʋo su, naama nui ɠa ɠɛ ga nà-duɔi, naazu wɔun, wa ɠɛ ga sɔbalala nuiti.» ");
INSERT INTO tod_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ɛsɛ ge ɠaazuvilɛni, é ná-ɓɔlɔi ʋilɛ zooi ma, é daalao. ");
INSERT INTO tod_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Naavolo unda nui ta-ɓɔlɔiti suveelɛni, é tɔɔzeini ti-ma ɓakologi ʋa, é gaaɓela ti-ma loungoi ma. Kpɔɔle wɔwɔi ɠaani Ɓɛnzamɛn ná-ɓɔlɔi zu. ");
INSERT INTO tod_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ti ta-zeɠeiti balini ga kidaaʋiligi maaʋele ma, ɛsɛ ge ná-soovale kasɔɠili ʋolu, ti ɠale ma taazu. ");
INSERT INTO tod_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zuda ta kɛɛɠɛleaiti ti zeelini Zozɛfe ná-pɛlɛi wu, naa ɠɛni dɛ ná-pɛlɛi wu, ti nɔkɔni bu zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Zozɛfe ɠɛni ti ma: «Leeni vaa ɠa wo kɛai ga nii? Wo la kwɛni ɓaa, ga zunui eɠɛʋelei gè la, ná zoo adɔi ɓɛɛzu?» ");
INSERT INTO tod_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Zuda gooɠaaʋoteni, é ɠɛ ma: «Lee ɠa gá bo màliɠii ma? Gá ɓɔɛ ɠale? Gá ɓɔɠɔ maalobo ɠale? GALA ge ɗa-wotiɠɛ nuiti ta-vaaɠaazagi ɠula kɛlɛma. Giya ɠaa, gi ɠɛa ga màliɠii ná-duɔiti, giya-o, zɔi kpɔɔle wɔwɔi ɠaai zea-o.» ");
INSERT INTO tod_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kɛlɛ Zozɛfe ɠɛni ma: «Gè ɠizo naa ma, gè ʋa naa ɠɛɠala vaa ɠɛ! Nui nii kpɔɔle wɔwɔi ɠaai zea, naa ɠa a ɠɛ ga nà-duɔi. Kɛlɛ wɔun, à li wo-ɠɛɛ ʋɔ ziilɛigi zu.» ");
INSERT INTO tod_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Zuda maaɓuɠani Zozɛfe ʋa, é ɠɛ ma: «Màliɠii, soma, è va bu ɗa-wotiɠɛ nui ɓɔɛ è ʋɔ, naa mina ɠɛ ga ɗa-yiiɠaawana vaa wola ɗa-wotiɠɛ zunui laalɔɠɔma, mazɔlɔɔ è ɠɛɛʋɛ eɠɛ Falaɠɔn. ");
INSERT INTO tod_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mɔunpa, màliɠii ɗa-wotiɠɛ nuiti gaazaɠani, é ɠɛ gi ma: ‹Kɛɛɠɛ ɠa wo ʋɛ nɛi, ɓaa wo-ɠɛɛloin taɠili?› ");
INSERT INTO tod_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Gi màliɠii wooɠaaʋoteni ga, gi-ɠɛɛ ma wɔlɔzaɠagi ɠa ná, ta gi-leɠe zunu ɠilagi, nii é sɔlɔɔgai pɔlɔzaɠagai ma, naa diɛi zaa. Nii ɠila kpe ka zɛgai dee ya, kɛɛɠɛ gola nɛai ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","È ɠɛni ɗa-wotiɠɛ nuiti gi ma: ‹À li, wo ʋaa la pɔ̀, gè ka ga ɠaazuʋɛ nà ɓɔɠɔi.› ");
INSERT INTO tod_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Gi màliɠii wooɠaaʋoteni ga, zunu loungoi la zooga é ʋa zeɠe kɛɛɠɛ ʋa, ni naa laade, kɛɛɠɛ ɠa za. ");
INSERT INTO tod_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","È ɠɛni ɗa-wotiɠɛ nuiti gi ma: ‹Ni wo-leɠei la yɛni wo ʋolu, wo ʋa ʋa, wo la mɔ ɠaazulaa gàazuʋɛ ma pɛ.› ");
INSERT INTO tod_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Siɛgi zu gi lɛai ma la ʋolu ɗa-wotiɠɛ nui gi-ɠɛɛ ʋɔ bɛ, gi màliɠii wooiti boni ma. ");
INSERT INTO tod_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Siɛgi zu gi-ɠɛɛ ɠɛni ma la: ‹À ɠale ma, wo li, wo daamianigi ta ɠeya ade ʋɛ,› ");
INSERT INTO tod_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","gi gooɠaaʋoteni, gi ɠɛ ma: ‹Gi la zooga ɠalesu ma ná, kɛni ni gi-leɠe zunui ɠa gi ʋa, gá yei naazu, mazɔlɔɔ ni gi-leɠe zunui la gi ʋa, gi la zooga gi ʋa ɠaazula zunui naa ɠaazuʋɛ ma.› ");
INSERT INTO tod_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ɗa-wotiɠɛ nui gi-ɠɛɛ ɠɛni gi ma: ‹Wo kwɛni ga ànzai Lasɛle doun zunu felegɔ zɔlɔɔni bɛ̀. ");
INSERT INTO tod_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Gilagi ɠulani zèa, nà ɠisiɛzu ga, ɠiteɠitegi zu, dɔɓɔ zuai ta ɠa é soni, é baliʋali ga, tɔɔzei gè la mɔ ɠɛni kaani eyɛsu zaaɠaza. ");
INSERT INTO tod_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Wa niima gelei zeɠena mɔnɔ, wo lii la, wo maaɠooza la bà, faa ɲɔu a ɠɛɛna la, wa nɔ̀undeɠa ɠolegi yeizu gɔvɛalaazu soolɛi zu.› ");
INSERT INTO tod_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Niizu, ni nà ɠalena ma ɗa-wotiɠɛ nui kɛ̀ɛ ʋɔ bɛ, zunu loungoi la yɛni gi ʋolu, gi ʋa li, ta nii ti ɠiliai ɓɔɠɔ ʋa, ");
INSERT INTO tod_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","toɠa za. Ɗa-wotiɠɛ nuiti gá ɠɛ ga sɔba nuiti, ni gá ɗa-wotiɠɛ nui gi-ɠɛɛ nɔundeɠa ɠolegi yeina gɔvɛalaazu soolɛi zu. ");
INSERT INTO tod_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","É ɓudɛ naa maazu, nɛ̀i gè ga ɗa-wotiɠɛ nui, gè yeelaani doungoi ná-fai ɠa. Gè ɠɛni kɛ̀ɛ ma: ‹Ni gè la ʋaani la ʋolu è ʋɔ, nà ɠɛ ga sɔba nu è letema eyɛsu ɠɔ.› ");
INSERT INTO tod_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«Màliɠii, nà è maanɛɛnɛzu, nɛ̀i gè ga ɗa-wotiɠɛ nui, nà yɛ zunu loungoi ʋotogi zu, gè ɠɛ ga màliɠii ná-duɔi, zunu loungoiti ti li ta diɛni. ");
INSERT INTO tod_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nà zoo lɛɛzu ɠale kɛ̀ɛ ʋɔ bɛ, ni zunu loungoi la liini pòlu? Ee! Gè mina nimizai ɠa, nii é ʋaazu zeelizu kɛ̀ɛ ma!» ");
INSERT INTO tod_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Zozɛfe la mɔ ɠɛni ziɛni ná wu, é ʋa ɓɔɠɔ zuzo naati kpein gaazu, ti ɠɛni loni maaɠoolii zu. É wooɠulani, é ɠɛ ma: «À nuiti kpein kula!» Nu nɔpɛ ge la ɠɛni yɛni Zozɛfe ɠoba, siɛgi zu é ɠɛni ɓɔɠɔ lɛɛzu la ga kɛɛɠɛleaiti. ");
INSERT INTO tod_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","É wola wooɠulani ga gɔlɔi, eyɛsu Ezipete nuiti ti mɛni, ma wooi zeelini Falaɠɔn ná-pɛlɛyeɠei ma. ");
INSERT INTO tod_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Zozɛfe ɠɛni kɛɛɠɛleaiti ma: «Nà ga Zozɛfe! Kɛ̀ɛ ɠa nɛi dɛ vulua?» Kɛlɛ kɛɛɠɛleaiti ti la ɠɛni zooni ti ʋa tɔun gooɠaaʋote, mazɔlɔɔ ti ɠɛni luazu ba, ti zasu ɗa ɓali gaazu. ");
INSERT INTO tod_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Zozɛfe ɠɛni kɛɛɠɛleaiti ma: «Nà wo maanɛɛnɛzu, à maaɓuɠa bà.» Ti maaɓuɠani ba. É ɠɛni ti ma: «Nà ɠa gè ga Zozɛfe, wo-ɠɛɛloin, nii wo pɔdini, ti ʋaa la Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Niizu, naa mina ɠɛ wo ʋɛ ga ziiɓɔlɔ vaa, naa mina wo yiiɠaawana ga tɛi wo pɔ̀dini. Pàaʋɛ ʋɛ, nu yɛnvui makɛ vai ɠa é kɛa GALA ge tèʋe ʋɛ wo luɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Mazɔlɔɔ kona felegɔ ɠaa na, pului loai zooi zu, kona dɔɔlugɔ ɠa dɛ ná ʋolu, wozawoli la ɠɛa, ɓaa molo leʋe vaa. ");
INSERT INTO tod_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","GALA ge tèʋegɛ wɔun wo luɠɔ, nii a kɛ wo yɛ vulua zooi ɠa, wo-yɛnvui makɛ, naa ɠɛ ga kpɔba vaa wola. ");
INSERT INTO tod_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Naa ɠa é ba, wa laade, wo ʋa tèʋe ʋɛ, kɛlɛ GALA be. É sèiʋɛ ga Falaɠɔn kɛɛɠɛ, é kɛ̀ ga ná-pɛlɛi maliɠii, é kɛ̀ɛʋɛ ga Ezipete yooi kpein ma ɠundiɠi wolai. ");
INSERT INTO tod_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«À ɠale ma fala, wo li kɛ̀ɛ ɠoba. Wa ɠɛ ma: ‹È-loun zunui Zozɛfe ɠa é niima wooi laazeelizu è ma: GALA ge sèiɗa ga Ezipete yooi kpein maliɠii. Suvilɛ, è ʋa pɔ̀ bɛ! ");
INSERT INTO tod_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ɗa ʋaazu zeizu Gosɛn yooi zu, è ɠɛ kòbaʋɛ, ɗa-o, è-loun zunuiti-yo, è lounlointi-yo, wa ɗa-ʋaalagiti, ta ɗa-nikɛiti, é ʋɛɛ nii kpein ba, é ga è-ɠɔligiti. ");
INSERT INTO tod_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Miná ɠa nà è-maavai pɛ kɛ ná, naa ɠa a kɛ è la ʋalaga ani nɔpɛ ma, ɗa-o, ɗa-ʋɛlɛyeɠei-yo, ta nii kpein é ga ɗɔnɔi, mazɔlɔɔ kona dɔɔlugɔ ʋului ɠa dɛ ʋaazu.› ");
INSERT INTO tod_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«Wa ɓɔɠɔi wo kaa ga ɠaazuʋɛ, dèɠei Ɓɛnzamɛn ɓalaa kaa ga ɠaazuʋɛ, ga nà ɓɔɠɔgoi ɠa gè ɓɔɛzu wo ʋɔ. ");
INSERT INTO tod_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ɠaazu unfegi kpein é bɛ̀ Ezipete yooi zu, à li, wo naa zuɠula kɛ̀ɛ ma, nii kpein wo kaa ga ɠaazu, wo naa wo ma. À suvilɛ, wo ʋaa ga kɛ̀ɛ ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Naa ʋolu, é yeeʋilini deɠe zunui Ɓɛnzamɛn ɠɔgi zu, é wɔlɔ. Ɓɛnzamɛn yee yɛni kɔgi ʋa, é ɗa wɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","É kɛɛɠɛleaiti kpein nɛɛnɛni ɓalaa, é ɗa wɔlɔ. Naa ʋoluma, kɛɛɠɛleaiti ti yɛpɛni tɔun pɔ. ");
INSERT INTO tod_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Zozɛfe kɛɛɠɛleaiti paa vai ma wooi vazani Falaɠɔn ná-pɛlɛi wu. Naa nɛɛni Falaɠɔn ʋɛ ta ná-botiɠɛ nu wolaiti. ");
INSERT INTO tod_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Falaɠɔn ɠɛni Zozɛfe ma: «Ɠɛ è-ɠɛɛleaiti ma: ‹À wa-loganiiti kasɔɠili, wo li Kanaan yooi zu, ");
INSERT INTO tod_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","wo wo-ɠɛɛ zeɠe ta wa-ʋɛlɛyeɠe wu nuɓusɛiti, naa ʋolu wo ɠale ma, wo ʋa pɔ̀ bɛ. Nà zooi ʋasuʋɛti fe wo ya Ezipete yooi zu. Wa zooi ná-kulanuma ʋagɔiti sɔlɔɔ, wo mi.› ");
INSERT INTO tod_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ɗa devei nii ve ti ya, è ɠɛ ti ma: ‹À wotoloiti seɠe Ezipete yooi zu, wo-lointi bɛ ta wo-anzaiti. Wa wo-ɠɛɛ ɓalaa seɠe, wo ʋa. ");
INSERT INTO tod_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Wo-yii mina ɠoloɠolo wo-ɠɔligiti faa zu, mazɔlɔɔ anii ʋagɔiti ti Ezipete yooi zu, naati ta ɠɛ ga wɔnɔ.› » ");
INSERT INTO tod_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Izilayɛle ná-dointi ti kɛɛni ɠana nɔ. Zozɛfe wotoloiti feeni ti ya, eɠɛʋelei Falaɠɔn ná-devei ɠɛni la. É daamianigiti feeni ti ya ɓalaa, nii ta mi pelei zu. ");
INSERT INTO tod_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","É seɠe niinɛi veeni ti ɠilagilagi ya. É wali ɠae unsaʋagɔ (300) veeni Ɓɛnzamɛn ya, ta seɠe niinɛ lɔɔlugɔ. ");
INSERT INTO tod_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","É soovale sinɛ puugɔ leʋeni kɛɛɠɛ ma, ti ɠasɔɠiliai ga Ezipete anii ʋapagiti, ta soovale saa puugɔ ti ɠasɔɠiliai ga moloi, ta ɓului, ta daamianigiti kɛɛɠɛ ná-siɛ vai zu. ");
INSERT INTO tod_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Naa ʋolu, é yeeɓeni kɛɛɠɛleaiti ba, ti li, é ɠɛ ti ma: «À mina ɓɔɛ pelei zu.» ");
INSERT INTO tod_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ti ɠaleni ma, ti zeɠe Ezipete yooi zu, ti lɛ Kanaan yooi zu ti-ɠɛɛ Zakɔɓe ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ti ɠɛni ma: «Zozɛfe ɠa dɛ vulua, tɔ ɠa é Ezipete yooi kpein unda.» Kɛlɛ Zakɔɓe ɠaalɛini nɔ tɔɔn, mazɔlɔɔ é la ɠɛni laani ti la. ");
INSERT INTO tod_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ti wooiti kpein daazeelini ma, niiti Zozɛfe ti woni ti ma. Zakɔɓe wotoloiti kaani, niiti Zozɛfe ti leʋeni seɠe vai zu. Názu ɠa ti-ɠɛɛ Zakɔɓe yiilɛini la ɓɔɠɔ ma. ");
INSERT INTO tod_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Izilayɛle ɠɛni ma: «É zolooga! Dòun zunui Zozɛfe ɠa dɛ vulua! Nà liizu, gè pɛtɛ, aisa gè ʋa za.» ");
INSERT INTO tod_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izilayɛle ʋilɛni pelei zu, é ɗa li, é ʋɛɛ naati kpein ba, ti ɠɛni ga nɔnɔi. Siɛgi zu é zeelini la Ɓeel-Seɓa, é zalaɠaiti kulani kɛɛɠɛ Izaake ná-GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","GALA ge ɓɔɛni Izilayɛle ʋɔ kulakɛlɛmaiti su kpidii naa. É tolini, é ɠɛ ma: «Zakɔɓe! Zakɔɓe!» Izilayɛle gooɠaaʋoteni, é ɠɛni ma: «Nà ɠaa!» ");
INSERT INTO tod_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","GALA ge ɠɛni ma: «Nà ga GALA, è-ɠɛɛ ná-GALAGI. Mina lua è lii vai zu Ezipete yooi zu, mazɔlɔɔ náʋɛ ɠa gè è ɠɛɛzu ná ga zii wola. ");
INSERT INTO tod_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nà ɓɔɠɔi ɠa gè yɛsu è ʋa, de yei Ezipete yooi zu, nà ɓɔɠɔi nɔ ɠa mɔnɔ gè ʋaazu lɛɛzu ga ɗe, gè è ɠula náʋɛ. Ɗa zaana, Zozɛfe ɠa é ʋaazu è-ɠaazuʋɛti pɛɛzu ma ga tɔ ɓɔɠɔi zeei.» ");
INSERT INTO tod_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Zakɔɓe zeɠeni Ɓeel-Seɓa. Izilayɛle ná-doun zunuiti ti ti-ɠɛɛ Zakɔɓe zeɠeni, ta ti-lointi, ta ti-anzaiti, ti ti lɛ wotoloiti su, niiti Falaɠɔn ti leʋeni ga ti ti zeɠe ti zu. ");
INSERT INTO tod_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ti ta-logani ɓulugiti seɠeni ɓalaa, ta ti-yeaɠɔligiti kpein, niiti ti ti zɔlɔɔni Kanaan yooi zu. Pele ɠana Zakɔɓe zeelini la Ezipete yooi zu, é ʋɛɛ ná-pɛlɛyeɠei kpein ba. ");
INSERT INTO tod_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","É liini ga ná-pɛlɛyeɠei kpein Ezipete yooi zu: ná-doun zunuiti, ta naati ti-loun zunuiti ta ti-loun anzanuiti, ta ná-doun anzanuiti. ");
INSERT INTO tod_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Izilayɛle ná-doun zunuiti daaseigiti kaa, niiti ti yeini Ezipete yooi zu, Zakɔɓe ta ná-doun zunuiti. Zakɔɓe ná-doun zunu mɔungi, é sɔlɔɔni, daaseigi ɠɛni ga Luɓɛn. ");
INSERT INTO tod_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Luɓɛn ná-doun zunuiti ti ɠɛni ga: Enɔke, Palu, Ɠɛsɛlon, ta Kaalemi. ");
INSERT INTO tod_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simiyɔn ná-doun zunuiti ti ɠɛni ga: Yemuwɛle, Yamin, Woɠade, Yakin, Soɠaal, ta Sayile, nii é ga Kanaan anzanui ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ná-doun zunuiti ti ɠɛni ga: Gɛɛlɛson, Keɠate, ta Melali. ");
INSERT INTO tod_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Zuda ná-doun zunuiti ti ɠɛni ga: Ɛɛl, Wonan, Sela, Pelɛze, ta Zela. Kɛlɛ Ɛɛl ta Wɔnanni ti zaani Kanaan yooi zu. Pelɛze nɔnɔ ma loun zunuiti ti ɠɛni ga: Ɠɛsɛlon ta Ɠamule. ");
INSERT INTO tod_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakaal ná-doun zunuiti ti ɠɛni ga: Tola, Puva, Yoɓe, ta Similon. ");
INSERT INTO tod_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zaɓulɔn ná-doun zunuiti ti ɠɛni ga: Selɛde, Elon, ta Yaleyɛle. ");
INSERT INTO tod_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Zunu lointi kana Lea ti zɔlɔɔni Zakɔɓe ʋɛ Padan-Alame, é ʋɛɛ ti-loun anzanui Dina ʋa. Ti-mavofodaiti pɛ ti ɠɛni ga nu ʋuusaʋa maazu saʋa (33). ");
INSERT INTO tod_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gade ná-doun zunuiti ti ɠɛni ga: Sifiyon, Ɠagi, Suni, Ɛseɓon, Eli, Alodi, ta Aleli. ");
INSERT INTO tod_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛɛl ná-doun zunuiti ti ɠɛni ga: Yimina, Yisiva, Yisivi, Ɓelia, ta ti-ʋaazeelai Sela. Ɓelia ná-doun zunuiti ti ɠɛni ga: Ɠeɓɛɛl ta Malekiyɛle. ");
INSERT INTO tod_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zakɔɓe mavofodaiti kana ti yɔɠɔzu ta Zilepa, botiɠɛ anzanui nii Laɓan feeni ná-doun anzanui Lea ya. Ti pɛ ti ɠɛni ga nu puugɔ maazu lɔzita (16). ");
INSERT INTO tod_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Zakɔɓe anzai Lasɛle ná-doun zunuiti ti ɠɛni ga: Zozɛfe ta Ɓɛnzamɛn. ");
INSERT INTO tod_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Won ná-zalaɠa ɠula nui Potifela ná-doun anzanui Asenate doun felegɔ zɔlɔɔni Zozɛfe ʋɛ Ezipete yooi zu: Manasé ta Efelayime. ");
INSERT INTO tod_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ɓɛnzamɛn ná-doun zunuiti ti ɠɛni ga: Ɓela, Ɓekɛɛl, Asaɓɛle, Gela, Naaman, Eyi, Lɔse, Mupime, Ɠupime, ta Aalede. ");
INSERT INTO tod_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Zakɔɓe mavofodaiti kana ti yɔɠɔzu ta Lasɛle. Ti pɛ ti ɠɛni ga nu puugɔ maazu naani (14). ");
INSERT INTO tod_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ná-doun zunui ɠɛni ga: Ɠusime. ");
INSERT INTO tod_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfɛtali ná-doun zunuiti ti ɠɛni ga: Yaseyɛle, Guni, Yesɛɛl, ta Sileme. ");
INSERT INTO tod_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Zakɔɓe mavofodaiti kana ti yɔɠɔzu ta Ɓiliɠa, botiɠɛ anzanui Laɓan feeni ná-doun anzanui Lasɛle ya. Ti pɛ ti ɠɛni ga nu lɔfela. ");
INSERT INTO tod_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Nuiti ti yɛni Zakɔɓe ʋa, ti ʋa Ezipete yooi zu, ti ɠulaai tɔun su, ti kpein kpɔga ɠɛni ga nu ʋuulɔzita maazu lɔzita (66), Zakɔɓe ná-doun zunuiti ti-anzaiti ti la naama ɠaalugi zu. ");
INSERT INTO tod_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Zozɛfe ná-doun zunuiti ti zɔlɔɔni Ezipete yooi zu: nu felegɔ. Zakɔɓe ná-pɛlɛyeɠei ma nuɓusɛi liegɔi é yeini Ezipete yooi zu, é ɠɛni ga nu ʋuulɔfela (70). ");
INSERT INTO tod_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Zakɔɓe Zuda leʋeni luɠɔʋelei Zozɛfe ʋɔ bɛ, é bo ma ga é daaɠomi Gosɛn. Ti zeeliai ma Gosɛn yooi zu, ");
INSERT INTO tod_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Zozɛfe ná-wotoloi ɠɛʋele ɓɛtɛni, é lɛ su, é li Gosɛn, kɛɛɠɛ Izilayɛle laaɠomisu. É kaai ma nɔ feya, é vɛɛlɛ ga kɔgi, é lɛbi wɔlɔzu zeei naa ɠɔgi ʋa. ");
INSERT INTO tod_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izilayɛle ɠɛni Zozɛfe ma: «Nà zoo zaazu niina, tɔɔzei gè è-ɠaazuʋɛ ɠaa, ɗa dɛ vulua!» ");
INSERT INTO tod_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Zozɛfe ɠɛni kɛɛɠɛleaiti ma, ta kɛɛɠɛ ná-pɛlɛyeɠei: «Nà liizu, gè Falaɠɔn loo ɠisu, gè ɠɛ ma: ‹Kɛ̀ɛleaiti ta kɛ̀ɛ ʋɛlɛyeɠei, niiti ti ɠɛa Kanaan yooi zu, ti ʋa, ti zeelia mà. ");
INSERT INTO tod_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Niima nuiti ta ga togani makɛ nuiti, mazɔlɔɔ togani lo nuiti be, ti ʋaaʋɛ ga ta-ʋaalagiti, ta ta-woliiti, ta ta-nikɛiti, ta nii kpein é ga ti-ɠɔligiti.› ");
INSERT INTO tod_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Siɛgi zu Falaɠɔn a wo lolina da, é ɠɛ wo ma: ‹Ɓɛgele ɠa wa ɗa kɛ?› ");
INSERT INTO tod_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","wa gooɠaaʋote ga: ‹Ɗa-wotiɠɛ nuiti gá ga togani lo nuiti, é tɔɔzei gi-ma loungo yeei ma, eyɛsu niizu, giya-o, gi-mɛmɛwolani-yo.› Naa ɠɛʋele ma, toɠa vaazu bu, wo zei Gosɛn yooi zu, mazɔlɔɔ togani lo nuiti bɛlɛzeɠeʋɛ Ezipete nuiti bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Zozɛfe liini, é Falaɠɔn loo ɠisu, é ɠɛ ma: «Kɛ̀ɛ ta kɛ̀ɛleaiti ti ʋaa, ti zeɠe Kanaan yooi zu, é ʋɛɛ ta-logani wolaiti ta ma goiti ba, ta nii kpein é ga tɔnɔi. Pɛtɛ, ti lia Gosɛn yooi zu.» ");
INSERT INTO tod_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","É nu lɔɔlugɔ zeɠeni kɛɛɠɛleaiti su, é li, é ti lɛ ga Falaɠɔn. ");
INSERT INTO tod_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Falaɠɔn Zozɛfe kɛɛɠɛleaiti gaazaɠani, é ɠɛ ti ma: «Wa-wotii ɠa ga ɓɛgele?» Ti Falaɠɔn wooɠaaʋoteni, ti ɠɛ ma: «Ɗa-wotiɠɛ nuiti gá ga togani lo nuiti, eɠɛʋelei gi-mɛmɛwolani ti ɠɛni la.» ");
INSERT INTO tod_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ti ɠɛni mɔnɔ Falaɠɔn ma: «Gi ʋaaʋɛ lago zeizu zooi zu, tɔɔzei daamiani ge la mɔ ɗa-wotiɠɛ nuiti ta-logani ɓulugiti zea, mazɔlɔɔ pului wola ɓɔiʋɛ Kanaan yooi zu. Va bu, ɗa-wotiɠɛ nuiti gi zei Gosɛn yooi zu.» ");
INSERT INTO tod_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Falaɠɔn ɠɛni Zozɛfe ma: «È-ɠɛɛ ta è-ɠɛɛleaiti paaʋɛ è ɠoba. ");
INSERT INTO tod_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ezipete yooi ɠa è yeema. È-ɠɛɛ ta è-ɠɛɛleaiti sei zooi ʋasuʋɛ. Ti zei Gosɛn yooi zu. Ni è kwɛɛ ga sɔɓelama zunua ta ti zaama, ti zei nà-togani ɓulugiti unda.» ");
INSERT INTO tod_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Zozɛfe ʋaani ga kɛɛɠɛ Zakɔɓe, é dɛɛ ga Falaɠɔn. Zakɔɓe tuya looni Falaɠɔn ʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Falaɠɔn ɠɛni Zakɔɓe ma: «È-zii ma voloi ma ɠonagiti ti ɠɛa ga dielegɔ?» ");
INSERT INTO tod_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Zakɔɓe Falaɠɔn wooɠaaʋoteni, é ɠɛ ma: «Sìi ma voloi ma ɠonagiti ti ɠɛai siɛziɛgi zu, ta ga kona ungila puusaʋa (130). Sìi ma voloi ma ɠonagiti ti la mɔinni, ti ɲɔuʋɛ, ti la zeelini ɲɛgɛlɛin mɛ̀mɛwolani ti-zii ma voloi ma ɠonagiti su, tɔnɔ ma ziɛziɛ voloiti.» ");
INSERT INTO tod_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Zakɔɓe tuya looni mɔnɔ Falaɠɔn ʋɛ, é zeɠe naa ʋɔ bɛ, é li. ");
INSERT INTO tod_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Zozɛfe kɛɛɠɛ ta kɛɛɠɛleaiti seizu ɠulani, é naa ta veeni ti ya ga tɔnɔ Ezipete yooi zu, zooi ʋasuʋɛ, Lamesɛse yooi zu, eɠɛʋelei Falaɠɔn ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Zozɛfe kɛɛɠɛ ta kɛɛɠɛleaiti kɔnɔkulani, é ti laazɔbo, ta kɛɛɠɛ ná-pɛlɛyeɠei kpein, eɠɛʋelei dointi tiegɔi ɠɛni la. ");
INSERT INTO tod_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Daamiani ge la mɔ ɠɛni zooi zu ná kpein, mazɔlɔɔ pului wola ɓɔini. Nuɓusɛiti ti ɠaɲani, Ezipete yooi zu ta Kanaan yooi zu, pului maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Zozɛfe walii kpein gaalɛɛni ba, é kula Ezipete yooi zu ta Kanaan yooi, moloi ʋoluʋele zu ti ɠɛni geyazu. É naama walii lɛɛni Falaɠɔn ná-pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Siɛgi zu walii ɓeni da Ezipete yooi zu ta Kanaan yooi zu, Ezipete nuiti ti ʋaani Zozɛfe ʋɔ bɛ, ti ɠɛ ma: «Daamianigi ve gi ya! Kɛni nɔ gi za è ɠaazu, tɔɔzei walii ɓega?» ");
INSERT INTO tod_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Zozɛfe ɠɛni ma: «Ni wali la mɔ ná, à wa-loganiiti fe, nà daamianigi ve wo ya wa-loganiiti potogi zu.» ");
INSERT INTO tod_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ti ɠɛni ʋaazu ga ta-loganiiti Zozɛfe ʋɔ. Zozɛfe daamianigi veeni ti ya, ta-zooiti potogi zu, ta ta-nikɛiti, ta ta-ʋaalagiti, ta ta-woliiti, ta ta-zoovalegiti. É daamianigi veeni ti ya ɠana naama ɠonagi, ta-loganiiti kpein potogi zu. ");
INSERT INTO tod_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Siɛgi zu naama ɠonagi leʋeni da, ti ʋaani pɔ bɛ poluma ɠonagi, ti ɠɛ ma: «Gi la dɔɔɠuzu ɲɛgɛlɛin màliɠii ʋa ga walii ɓega gi ya, ta gi ʋaa ga togani ɓulugi màliɠii ʋɔ, naa ɓega, é yɛga gi ma nɔ ga gi ʋaa ga gi-ɓusɛiti ta gá-yooiti, gi fe màliɠii ya. ");
INSERT INTO tod_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Lee vaa zu gá li zaazu è ɠaazu, giya-o, gá-yooiti-yo? Gi ʋɛɛna gá-yooiti ba, è gi ɠeya daamianigi ʋotogiti su, gá ɠɛ ga Falaɠɔn ná-duɔiti, giya-o, gá-yooiti-yo. Nii ɓalaa gá faza, naa ve gi ya, naa ɠa a kɛ gi yɛ vulua, gi mina za, gá-yooiti gaa ɲakai mina yɛ.» ");
INSERT INTO tod_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Zozɛfe Ezipete yooi kpein geyani Falaɠɔn ʋɛ, mazɔlɔɔ Ezipete nuiti ti ta-ɓalagiti pɔdini, ti ɠilagilagi, tɔɔzei pului ɓɔini ti la. Zooi ɠɛni ga Falaɠɔn ʋogi. ");
INSERT INTO tod_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","É nuɓusɛiti gaalɛɛni ba, é ti ʋu taa wolaiti su Ezipete ɠwɛpelemaʋɛti, é zo zɔɔla ʋele, é li zɔɔla ʋele. ");
INSERT INTO tod_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Kɛlɛ é la ɠɛni zalaɠa ɠula nuiti ta-yooiti geyani, tɔɔzei Falaɠɔn tɔ seini zalaɠa ɠula nuiti ta-vaa zu. Ti-ɠɔnɔgi ɠɛni ga nii Falaɠɔn ɠɛni feezu ti ya. Naa ɠa é ba, ti la ɠɛni ta-yooiti pɔdini ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Zozɛfe ɠɛni nuɓusɛiti ma: «Gè wo ɠeyaʋɛ za Falaɠɔn ʋɛ, wo ʋɛɛ wa-yooiti ba. Ani zuwui ʋɛtɛ, wa zoo wo faza, wo boli wa-yooiti ba. ");
INSERT INTO tod_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Molo leʋe ziɛgi zu, wa seizu lɔɔlusiɛi ve Falaɠɔn ya, seizu naanisiɛi zɔiti ti ɠɛ ga wɔnɔ, é ɠɛ ga kpalagiti ba zuwui, é wo ɠɔnɔkula wa wo-lointi, ta niiti kpein ti wa-ʋɛlɛyeɠeiti bu.» ");
INSERT INTO tod_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ti ɠɛni ma: «Ɗa ɠa è gi-yɛnvui yɛga gi ya, mazɔlɔɔ gi zaalai zɔlɔɔgɛ màliɠii è ɠaazu, gá ɠɛ ga Falaɠɔn ná-duɔiti.» ");
INSERT INTO tod_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Zozɛfe naa ɠɛɛni ga tɔgi Ezipete yooi kpein su, naa yɛgɛ ma zaaɠaza, Ezipete yooiti ma zɔlɔɔ ganii zeizu lɔɔlusiɛi ɠa ga Falaɠɔn nɔnɔ. Kɛni nɔ zalaɠa ɠula nuiti ta-yooiti ka ti la ga Falaɠɔn nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Izilayɛle nuiti ti zeini Ezipete yooi zu, Gosɛn yooi zu. Ti ɓɔɠɔ zɔlɔɔni, ti ɓuɠu, ti wola ɠaawɔɔlɔ. ");
INSERT INTO tod_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Zakɔɓe kona puugɔ maazu lɔfela ɠɛni Ezipete yooi zu. Zakɔɓe zii ma voloi kpein ge ɠɛni ga kona ungila puunaani maazu lɔfela (147). ");
INSERT INTO tod_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Siɛgi zu saa voloi maaɓuɠani la, é ná-doun zunui Zozɛfe lolini, é ɠɛ ma: «Ni ɗa va bu, è faaɓɔɠɔ ɠɛ bɛ̀, nà è maanɛɛnɛzu, yeei lɔ kpàlai wu, è minazeɠe bɛ̀, è nɛɛbɛi ɠula kɛlɛma bɛ̀, ta wooɠɛɠiladai, ga è la màaɠulua Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Siɛgi zu gè liizu la mɛ̀mɛwolani pɔ, ti zaai, ɗa kùla Ezipete yooi ʋa, è li ga ze, è màaɠulu ta-ɠabayeɠei zu.» Zozɛfe gooɠaaʋoteni, é ɠɛ ma: «Nà kɛ ɠana, eɠɛʋelei è bogai la.» ");
INSERT INTO tod_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Izilayɛle ɠɛni ma: «Ɠona bɛ̀.» Zozɛfe ɠonani bɛ. Naa ʋolu Izilayɛle nɔkɔni ná-betei unbuaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Naama vaiti poluma, ti ʋaani, ti ɠɛ Zozɛfe ma: «Wɛlɛ, è-ɠɛɛ ɠa zeeɓɛzu.» É ná-doun zunu felegɔiti seɠeni ya, Manasé ta Efelayime. ");
INSERT INTO tod_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ti liini, ti daazeeli Zakɔɓe ma ga: «È-loun zunui Zozɛfe ɠa ʋaazu è ʋɔ bɛ.» Izilayɛle zuvikɛiti kpein gaalɛɛni ba, é wuzeɠe, é zei ná-betei zu. ");
INSERT INTO tod_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Zakɔɓe ɠɛni Zozɛfe ma: «GALA Zɛbɛi-Pɛ-Maliɠii ɠulani bɛ̀ kɛlɛma Luze, Kanaan yooi zu, é tuya looni bɛ̀. ");
INSERT INTO tod_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","É ɠɛni mà: ‹Nà è ɠɛɛzu ga kpuɠu nu, gè è ɠaawɔɔlɔ, gè è ɠɛ ga zii mɔinmɔin. Nà niima yooi ve è-mavofodai ʋɛ, ɗɔun ɗa zeɠena ná, toɠa ɠɛ ɠɔ ga è-mavofodai nɔnɔ.› ");
INSERT INTO tod_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Doun zunu felegɔiti ti zɔlɔɔgai è ʋɛ Ezipete yooi zu, aisa gè ʋa ʋa è ʋɔ bɛ, Efelayime ta Manasé, naati ta ɠɛ ga nɔ̀nɔiti, eɠɛʋelei nɔ Luɓɛn ta Simiyɔnni ti la zèa. ");
INSERT INTO tod_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kɛlɛ, dointi è ti zɔlɔɔga niiti poluma, naati ta ɠɛ ga ɗɔnɔiti. Ta tɔnɔ ma ʋoganii zɔlɔɔ ti-liɛni ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Mazɔlɔɔ gè ɠɛni ɠalesu ma, gè ɗa zeɠe Padan-Alame, Lasɛle zaani pelei zu kòbaʋɛ, Kanaan yooi zu, ná maa la ɠɛni ɠoozani gola Efelata ʋa. Miná ɠa gè maaɠuluni ná, Efelata pelei zu.» (Efelata é lolisu ɓalaa ga Ɓɛteleyɛme.) ");
INSERT INTO tod_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Izilayɛle wɛlɛni Zozɛfe ná-doun zunuiti ba, é ɠɛ ma: «Ɓɛɛni ka ga niiti?» ");
INSERT INTO tod_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Zozɛfe kɛɛɠɛ wooɠaaʋoteni, é ɠɛ ma: «Dòun zunuiti kana, GALA ge ti vea zèa ʋɛ.» Izilayɛle ɠɛni ma: «Nà è maanɛɛnɛzu, ti maaɓuɠa lɛɛ bà, ga gè tuya loo ti ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Izilayɛle ɠaazuʋɛti maaɓidini pɔlɔzaɠagi maaʋele ma, é la mɔ ɠɛni wozaɠaazu fɔɔn. Zozɛfe ti zeɠeni, é ti maaɓuɠa ba. Izilayɛle laaʋɛɛni ti-ɠomagaʋɛti, é ti nɛɛnɛ. ");
INSERT INTO tod_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izilayɛle ɠɛni Zozɛfe ma: «Gè la ɠɛni ɠisiɛzu ga nà è-ɠaazuʋɛ ɠa ʋolu mɔnɔ, kɛlɛ wɛlɛ, GALA ge vaa bu vɔlɔ gè ɠaazula è-lointi ma.» ");
INSERT INTO tod_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Zozɛfe ná-doun felegɔiti kulani kɛɛɠɛ ɲiibiiti zɔɠɔzu, é nɔkɔ zooi ma. ");
INSERT INTO tod_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Naa ʋoluma Zozɛfe ti felegɔ pɛ seɠeni, é Efelayime zoni ga zeezai, é naa lo Izilayɛle ɠɔʋɛzu ʋelei, é Manasé zo ga ɠɔʋɛi, é naa lo ga Izilayɛle yeezazu ʋelei, é ti maaɓuɠa ba. ");
INSERT INTO tod_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kɛlɛ Izilayɛle zeezai maaleni, é pɛɛ Efelayime unma, nii é ɠɛni ga loungoi, é ɠɔʋɛzu ʋele yeei wuzeɠe, é pɛɛ Manasé unma. É zeeiti gaaʋolani ba, anɛɛ ni Manasé ɠa é ɠɛni ga doun mɔungi. ");
INSERT INTO tod_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","É tuya looni Zozɛfe ʋɛ, é ɠɛ ma: «GALAGI niigi kɛ̀ɛ Abalaame ta kɛ̀ɛ Izaake ti ziɛni gaazu, GALAGI nii togai tùɠɔ sìi ma voloi pɛ su eyɛsu za, ");
INSERT INTO tod_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","geezuɠeelai nii é ùnmɔɔga faa ɲɔi kpein ma, naa tuya loo niima zunu loungoiti bɛ. Ti ɗa ti loli ga dàaseigi, ta kɛ̀ɛni daaseigi, Abalaame ta Izaake, ti wola ɠaawɔɔlɔ zooi zu ná pɛ.» ");
INSERT INTO tod_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Zozɛfe kaani ga kɛɛɠɛ ɠa yeezai laazu Efelayime unma, naa la ɠɛni nɛɛni bɛ. É kɛɛɠɛ yeei zoni ga é seɠe Efelayime unma, é lii la Manasé unma ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Zozɛfe ɠɛni kɛɛɠɛ ma: «Mina kɛ ɠana kɛ̀ɛ, mazɔlɔɔ nii ma gelei ɠa é ga doun mɔungi. È-yeezai la nɔungi ma.» ");
INSERT INTO tod_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kɛɛɠɛ ɠɛlɛni, é ɠɛ ma: «Gè kwɛɛ, dòun zunu, gè suɠwɛɛ. Tɔ ɓalaagi toɠa ʋaazu ɠɛɛzu ga nuɓusɛ mɔinmɔin, gaawɔɔlɔ. Kɛlɛ deɠe zunui ɠa wɔɔlɔzu, é leʋe tɔun ba, mavofodaiti ta ɠɛ ga zii wola.» ");
INSERT INTO tod_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Naama volo ná, é tuya looni ti felegɔ ʋɛ, é ɠɛ ma: «Izilayɛle nuɓusɛiti ta wo-laaseigi wo ta-luyai zu, ti ɠɛ ma: ‹GALA ge è ɠɛ ga Efelayime ta Manasé ɠɛʋele.› » Zekana é Efelayime leʋeni da Manasé luɠɔ. ");
INSERT INTO tod_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Izilayɛle ɠɛni Zozɛfe ma: «Sàa yeei ɠana ʋa zeelizu, wɛlɛ GALA ka ɠɛɛzu wo ʋa, toɠa wo ɠaaɠale ma, é li ga woye, wo-mɛmɛwolani ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nɔ̀un nà, nà Sikɛme yooi zeɠezu, gè da ɗɔnɔi ma, é leʋe è-ɠɛɛlointi tɔnɔi ʋa, nii gè kulani Amool nuiti zea, ga nà-boɠa zɔkpɔi, ta nà-mɛɛin.» ");
INSERT INTO tod_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Zakɔɓe ná-doun zunuiti tolini, é ɠɛ ti ma: «À ɠaalɛ ba, gè faiti bo wo ma, niiti ti ʋaazu ɠɛɛzu ga woye ʋelela ʋelei. ");
INSERT INTO tod_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«À ɠaalɛ ba, wo woilo gòo ma ga pagɔ, Zakɔɓe ná-doun zunuiti! À woilo wo-ɠɛɛ Izilayɛle wooi ma! ");
INSERT INTO tod_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Luɓɛn, ɗa ɠa è ga dòun mɔungi, ɗa ga è ga sɛ̀bɛi ta sùvikɛi ma mɔungiti, è-losuʋɛ wɔɔlɔai ti pɛ ba, è-zɛbɛi wɔɔlɔai ti pɛ ba. ");
INSERT INTO tod_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","È yeeɠaaɓaai eɠɛ ziɛvegi, è la mɔ nu ɠitela losuʋɛ zɔlɔɔga, mazɔlɔɔ è lɛɛʋɛ è-ɠɛɛ laa ʋetei zu, è nà-betei ɠɔzɔʋɛ è lɛɛ vai zu ná. ");
INSERT INTO tod_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simiyɔn ta Levi ta ga kɛɛɠɛlointi, ta-woɠa zɔkpɔiti ta ga tooma aniiti. ");
INSERT INTO tod_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Zìi mina ʋɔɔpɛɛ ta-yaava vai ʋa ɲɛgɛlɛin, nà-kisiɛi mina ɠili ta-ɠaalɛbai ʋa! Mazɔlɔɔ ti nu ʋaani ta-yiiɠulagi zu, ti nikɛiti kɔɠɔʋolu ɲataiti teʋeni ta-unsuɲɔi zu. ");
INSERT INTO tod_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ta-yiiɠulagi ɠotoʋɛ, mazɔlɔɔ gola ɲɔuʋɛ, ta-yiiɓadii ɠotoʋɛ! Nà ti ɠaaɠwɛ Zakɔɓe nɔnɔiti saama, nà ti vaza Izilayɛle zaama. ");
INSERT INTO tod_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Zuda, ɗa ɠa è-ɠɛɛlointi ti ʋaazu è maamusɛzu. È-yeei ɠa ɠɛ è zili nuiti kɔ poluʋɛ. È-ɠɛɛ ná-doun zunuiti ta ɠɛ nɔkɔsu è wu. ");
INSERT INTO tod_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Zuda, dòun zunu, ɗa ga zala zinɛ goi, nii é zeɠezu paa wosuʋɛ! É ɲiibiiti pɛɛ su, é ʋɛɛ, eɠɛ zalai, eɠɛ zala zaai, ɓɛ ɠa a zoo é buzeɠe pɛɛzuʋɛ? ");
INSERT INTO tod_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kundiɠilai ma lukpɔi la ɠulaa Zuda ʋɛlɛyeɠei ʋa pɛ, anɛɛ tɔgi maazuɓaa nui ná-poogi la ɠulaa kɔɠɔ yɔɠɔzuʋɛti, eyɛsu nii tukpɔi ga nɔnɔ naama nui ʋa, nuiti ti ɠolo bɛ. ");
INSERT INTO tod_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Toɠa ná-soovalegi ɠili leezɛn lɔkulugi ʋa, é ná-soovale saai ma yiʋoi ɠili ma lɔkulu pagɔi ʋa. Toɠa ná-seɠei gba dɔɔ ɗɛi wu, é ná-seɠe maazu zeɠei gba leezɛin ma ɲamai wu. ");
INSERT INTO tod_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Gaazuɠɛzɛiti kpɔiʋɛ su ga dɔɔi, nɔnɔi ɲiigaiti koleʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zaɓulɔn ɠa zei Kpoloɗɛ Wolai ɠobaʋɛ yooiti su, toɠa zei ziɛlaʋɛ, ɓatoiti tosuʋɛ, ná-zou ɠwɛpelemaʋɛti ta zeeli Sidɔn yooi ʋɔ pelei. ");
INSERT INTO tod_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Isakaal ɠa ga soovale sinɛi suɓaai, é laani togani makɛ zasa felegɔiti zɔɠɔzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","É ɗa ka ga ná-dooɠo bosuʋɛ ʋagɛ, zooi wola ʋagɛ. É ɗa ɓili kasɔi wu, é ɗa ɓɔɠɔ lɔ duɔlai ma wotii zu. ");
INSERT INTO tod_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Dan ɠa ná-nuɓusɛiti tukpɔɠaaleʋe, eɠɛ Izilayɛle ná-bolodai ɠila. ");
INSERT INTO tod_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan ɠa ɠɛɛzu pelei zu ga kaalii, é ɠɛ ga pɛɛɠaalii pele goi zu, é sooi ɲi kɔɠɔ libiligi ʋa, sooi ɠɔma nui loo daazei. ");
INSERT INTO tod_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«Ee, Ɠɔoɠɔ GALAGI, kìtogɛ ɗa-ɠizo fai ʋa! ");
INSERT INTO tod_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Toosu nuiti ta ʋa Gade laalɔɠɔma, kɛlɛ toɠa wuzeɠe, é laalɛ ti wu, é ti ziɠa ga ɠɔɠɔi. ");
INSERT INTO tod_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Asɛɛl ná-zooi zu ɠa daamianigi a ɠɛ ná ga bɔɔlɔa. Toɠa masa daamiani pagɔi kpein kula. ");
INSERT INTO tod_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Nɛfɛtali ɠa ga dopai, é ɓɔɠɔ yeema, é ɗa ʋili, é ɗa ziʋo ʋagɔiti pu. ");
INSERT INTO tod_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Zozɛfe ɠa ga gwaa wulu ʋagɔi ma ʋɔnɔbai, gwaa wulu ʋagɔi ma ʋɔnɔbai, é ziɛungi ɠobaʋɛ. Ma ɓekegiti buzeɠeʋɛ, ti zɛlɛ siɠigi maazu. ");
INSERT INTO tod_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ti ɓaaɠogɛ ma, ti mɛɛin ʋili ma. Mɛɛn ʋili nuiti ti ɠɛni ga tɔun sili nuiti. ");
INSERT INTO tod_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kɛlɛ é ná-mɛɛin zogɛ kpaan tɔ ɓɔɠɔi, zeeiti sulogɛ ga Zakɔɓe ná-Zɛbɛ-Su-ƓALAGI yeeiti, nii é ga Izilayɛle makɛ nui ta ná-fasai. ");
INSERT INTO tod_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","È-ɠɛɛ ná-GALAGI zaalai zu, nii é ga ɗa-ɓɔba nui, GALA Zɛbɛi-Pɛ-Maliɠii, nii a tuya loo è ʋɛ, ɗa tuyaiti sɔlɔɔ, ti zeɠezu maazuʋɛ geeɠɔlɔgi zu, ta tuyaiti ti ɠulazu ziɛi ɓomaʋɛ zooi wu, ta doun mɔinmɔingiti ta togani ɓulugiti. ");
INSERT INTO tod_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","È-ɠɛɛ ná-tuyaiti zeeɠaaɓaaʋɛ, ti leʋe sɔ̀lɔɔ nuiti tɔnɔiti ba, eyɛsu é zeeli ɠɔoɠɔ gizeiti kwɛgi. Tuyai naati ti yei Zozɛfe unma, é yei, é la kɛɛɠɛlointi ta-ɠundiɠii losaamaʋɛ! ");
INSERT INTO tod_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Ɓɛnzamɛn ɠa ga zuluɓui, nii é anii ʋalizu ga, sobui é ná-ani zogai mi, kpɔkɔi, é kɔɔzoganii ɠaaɠwɛ.» ");
INSERT INTO tod_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Naati kpein ka ti ga Izilayɛle ná-boloda puugɔ maazu felegɔiti (12), pele ɠana ti-ɠɛɛ naama ɓɔɛiti boni la ti ma, é ɗa tuya loo ti ʋɛ. É tuya looni ti ʋɛ, ɛsɛ gilagilagi ta nɔnɔ ma luyai. ");
INSERT INTO tod_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Naa ʋolu é nii ma levei veeni ti ya ga: «Nà ga ʋa liizu kɛ̀ɛni pɔ, ti zaai. Wa màaɠulu mɛ̀mɛwolani kobaʋɛ, pugi zu, é Ɠɛte nui Efelon ná-kpalagi zu, ");
INSERT INTO tod_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Makepela ɓalagi ma ʋugi zu, Mamelé ɠobaʋɛ, Kanaan yooi zu. Kpalagi naa ɠa Abalaame geyani Ɠɛte nui Efelon ma, é ɠɛ bɛ ga maaɠulu bosuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ná nɔ ɠa ti Abalaame ta anzai Sala maaɠuluni ná. Ná nɔ ɠa ti Izaake ta anzai Eleɓɛka maaɠuluni ná. Ná nɔ ɠa gè Lea maaɠuluni ná. ");
INSERT INTO tod_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Kpalagi ta pugi é ɠɛni su, ti ɠeyaa ɠɛni de Ɠɛte nuiti ma.» ");
INSERT INTO tod_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Siɛgi zu Zakɔɓe ɓeni da ga deveiti fe ná-doun zunuiti zea, é laani ʋolu betei zu, zii looni, é za, é li mɛmɛwolani pɔ ti zaai. ");
INSERT INTO tod_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Zozɛfe ɠizini kɛɛɠɛ ɠaazuʋɛ ma. É wɔlɔni ma, é nɛɛnɛ ga daaʋɛ komagai. ");
INSERT INTO tod_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Naa ʋolu Zozɛfe devei veeni ɗɔɠɔtɔlɔiti zea, niiti ti ɠɛni ga ná-botiɠɛ nuiti, ga ti kɛɛɠɛ ɠɛʋele ɓɛtɛ fɔɔn. Ɗɔɠɔtɔlɔiti ti Izilayɛle ma ʋoomai vɔɔni, ti ɗa gulɔ maku nɛɛnɛgi ɲɔfɔ ma. ");
INSERT INTO tod_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kɛni ta la kɛ ga folo ʋuunaanigɔ (40), yeeɠɛɠalai naa ɠa maanɛɛni, é ɠɛ, poomai ɗa vɔ, gulɔi ɗa ɲɔfɔ ma. Ezipete nuiti ti ná-wɔlɔi woni folo ʋuulɔfela (70) laawu. ");
INSERT INTO tod_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Siɛgi zu saa wɔlɔi ma voloiti ti leʋeni da, Zozɛfe liini, é ɓɔɛ Falaɠɔn ná-koizuʋɛ nuiti pɔ, é ɠɛ ti ma: «Ni wa vaana bu, wo faaɓɔɠɔ ɠɛ bɛ̀, nà wo maanɛɛnɛzu ga wo li, wo niima wooiti bo Falaɠɔn ma: ");
INSERT INTO tod_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹Kɛ̀ɛ ɠɛni gè ɠona bɛ, é ɠɛni mà: Nà ga ʋa zaazu. Ɗa màaɠulu kabayeɠei zu, nii gè bɔɔni Kanaan yooi zu. Nà pɔ gè lɛ ná, gè kɛ̀ɛ maaɠulu, naa ʋolu, nà ɠalesu ma, gè ʋa.› » ");
INSERT INTO tod_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Falaɠɔn gooɠaaʋoteni, é ɠɛ ma: «Lɛ, è è-ɠɛɛ maaɠulu, eɠɛʋelei è ɠonani la tɔun bɛ.» ");
INSERT INTO tod_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Zozɛfe lɛɛni ga é kɛɛɠɛ maaɠulu, Falaɠɔn ná-botiɠɛ nuiti kpein ti ʋilɛni polu, ta ná-koizu ɠɛwolaiti, ta Ezipete yooi zu ɠɛwolaiti kpein, ");
INSERT INTO tod_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ta Zozɛfe ná-pɛlɛyeɠei kpein, kɛɛɠɛleaiti, ta kɛɛɠɛ ná-pɛlɛyeɠei, doungoiti nɔ ɠa ti ti yɛni Gosɛn yooi zu, é ʋɛɛ ta-logani goiti ta ma wolaiti ba. ");
INSERT INTO tod_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Wotoloiti ta soo nuiti ti ɠɛni Zozɛfe ʋolu ɓalaagi, naa ɠa é kɛɛni bɛbɛi wola laaɓaɠoni. ");
INSERT INTO tod_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ti zeelini Atade molo loɠazuʋɛ, nii é ziɛ wolai Zuludɛn ʋoluʋelei, ti ma maaɠulu bo fai wɔɔlɔni, ti maawui. Zozɛfe kɛɛɠɛ lɛbini, é kɛ ga folo lɔfela, é ɗa kɛɛɠɛ zaa wɔlɔi wo. ");
INSERT INTO tod_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanaan nuiti ti ɠɛni zeini zooi zu, ti ɠidaani saa vai naa ɠɛʋelei wu, nii é ɠɛɛni Atade molo loɠazuʋɛ, ti ɠɛni ma: «Saa wɔlɔ ɓii ka ga nii kpaai Ezipete nuiti ma.» Naa ɠa é ba, ti naama molo loɠazuʋɛ laasei pɛɛni ga Aɓɛle-Miselayime. Adaʋɛ ná ɠa ziɛ wolai Zuludɛn ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ʋele ɠana Zakɔɓe ná-doun zunuiti ti ti-ɠɛɛ ná-deveiti kɛɛni la. ");
INSERT INTO tod_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ná-doun zunuiti ti liini la Kanaan yooi zu, ti maaɠuluni Makepela ɓalagi ma ʋugi zu, nii Abalaame geyani Ɠɛte nui Efelon ma, ga é ɠɛ ga nɔnɔ ma maaɠulu bosuʋɛ, Mamelé ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Zozɛfe ɓegai ma ga kɛɛɠɛ maaɠulu, é ɠaleni ma Ezipete, ta kɛɛɠɛleaiti, ta niiti kpein ti lɛɛni ʋɔɔma kɛɛɠɛ maaɠuluzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Zozɛfe kɛɛɠɛleaiti ti kaai ma ga ti-ɠɛɛ zaa, ti ɠɛni ma: «Ni sɛi Zozɛfe a ɠɛna, é ɠɛ ga ade zili nu, faa ɲɔi kpein de kɛɛni la, é ti ʋotokula ade ma!» ");
INSERT INTO tod_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ti keela wooi leʋeni Zozɛfe ma, ti ɠɛ ma: «Aisa è-ɠɛɛ ʋa za, é niima levei veeni, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Wa ɓɔɛ Zozɛfe ʋɔ ɠani ga: Nà è maanɛɛnɛzu, è-ɠɛɛleaiti ta-lɔ koloɠologi zuvaayɛ, ta ta-ɠotoi, mazɔlɔɔ ti faa ɲɔi ɠɛɛʋɛ ga ɗe.› Gá è maanɛɛnɛzu, è-ɠɛɛ ná-GALAGI ná-botiɠɛ nuiti gá-ɠotoi zuvaayɛ niizu!» Zozɛfe wɔlɔni, siɛgi zu ti ɓɔɛni pɔ la ɠana. ");
INSERT INTO tod_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kɛɛɠɛlointi ti ʋaani tiya ɓɔɠɔi, ti la kɔɠɔwu, ti ɠɛ ma: «Giya ɠaa, gá ga ɗa-wotiɠɛ nuiti.» ");
INSERT INTO tod_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Zozɛfe ɠɛni ti ma: «À mina lua, nà ɠa gè GALA potogi zu ɓaa? ");
INSERT INTO tod_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Wo ɠisiɛni ga wo faa ɲɔu ɠɛ ga ze, kɛlɛ GALA ge naa valiboni, é kɛ ga faa ʋagɔ, ga naa laazeeli, nii é ɠɛɛzu za, naa ɠa a kɛ nuɓusɛ mɔinmɔin zɛnvui ɠizo. ");
INSERT INTO tod_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Niizu, deɠɛmu à mina mɔ lua, nà wo-maavaiti pɛ kɛɛzu, ta wo-lointi tɔnɔi.» É ti ɠaanɛɛnɛni, kpɔɛ ʋelei ma ti ʋɔ ga pagɔ. ");
INSERT INTO tod_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Zozɛfe zeini Ezipete, ta ná-pɛlɛyeɠei. É yɛni vulua, ná-konagi ɠɛ ga ungila puugɔ (110). ");
INSERT INTO tod_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Zozɛfe Efelayime mavofodaiti kaani, eyɛsu é zaʋagi ɠa. Manasé ná-doun zunui Makiil ná-doun zunuiti ti zɔlɔɔni ɓalaa kɔɠɔ ma. ");
INSERT INTO tod_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Zozɛfe ɠɛni kɛɛɠɛleaiti ma: «Nà ga ʋa zaazu. Kɛlɛ GALA ka ʋaazu wo ɠulazu niima yooi tɛi su, é li ga woye mɔnɔ zooi naa zu, nii é ma minazeɠegi woni, é ma ɠonai wo Abalaame ʋɛ, ta Izaake, ta Zakɔɓe.» ");
INSERT INTO tod_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Zozɛfe ɠɛni Izilayɛle lointi ma: «Kɛni wo ɠona, GALA ka ʋaazu wo maalobosu, zeɠema nɔpɛ ge la ba, wa lɛ ga mà ɠaeiti, wo ti maaɠooza ʋɛ ʋa.» ");
INSERT INTO tod_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Zozɛfe ná-konagi ɠɛai ma ga ungila puugɔ (110), é zaani. Ti ma ʋoomai vɔɔni, ti ɗa gulɔ maku nɛɛnɛgi ɲɔfɔ ma, ti da pooma ɠesui zu Ezipete yooi zu.");
INSERT INTO tod_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Izilayɛle ná-doun zunuiti kaa, ti yɛni Zakɔɓe ʋolu, ti ʋa Ezipete yooi zu, ɛsɛ ta ná-pɛlɛyeɠei: ");
INSERT INTO tod_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Luɓɛn, Simiyɔn, Levi ta Zuda, ");
INSERT INTO tod_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakaal, Zaɓulɔn ta Ɓɛnzamɛn, ");
INSERT INTO tod_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nɛfɛtali, Gade ta Asɛɛl. ");
INSERT INTO tod_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Zakɔɓe mavofodaiti tiegɔi ɠɛni ga nu ʋuulɔfela (70). Zozɛfe ɠɛni niina Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Zozɛfe zaani, kɛɛɠɛleaiti kpein ɓalaa, ta ti-ma ɠɛɠalamaiti kpein. ");
INSERT INTO tod_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Izilayɛle nuiti ti ɓuɠuni, ti mɔin, ti ɠaawɔɔlɔ, ti ɗa ɠɛ nɔ ga zobobɛ nuiti. Zooi zulaaveni ga tiye. ");
INSERT INTO tod_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Masa niinɛ zeini Ezipete yooi unda, nii é la ɠɛni Zozɛfe ɠwɛɛ. ");
INSERT INTO tod_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","É ɠɛni ná-nuɓusɛiti ma: «À wɛlɛ, Izilayɛle nuɓusɛiti ti mɔinɗa de ʋa, ti-zɛbɛi wɔɔlɔ dɔnɔi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Ade li, de ɓɔɠɔ lɛ ga da ga keleɠele nuiti ta-vaa zu. De pele ɓesa ta-ɓuɠu vai luɠɔ, mazɔlɔɔ ni kɔɔ a ʋaana, ti mina ɓɔ de wɔinzeɠe nuiti ba, ti ʋa de zakpe, ti ʋa ɠula zooi ʋa naa ʋolu.» ");
INSERT INTO tod_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Názu ɠa ti gwɛlɛma nuiti seini la Izilayɛle nuiti unda, ti ɗa ti ɓɔlɔ ga boti ɓaagiti, ti ɠɛni feezu ti ya ga maaɓaai. Pele ɠana ti taa wolaiti toni da Falaɠɔn ʋɛ, niiti ti ga Pitɔme ta Lamesɛse, anii makɛsuʋɛti. ");
INSERT INTO tod_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kɛlɛ tɔun ta la ɠɛna ti ɓɔlɔzu, ti maa ɓena mɔin nɔ, ti ɠaa ɗa wɔɔlɔ, eyɛsu Ezipete nuiti ti ti wɔinzeɠe. ");
INSERT INTO tod_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Ezipete nuiti ti Izilayɛle nuiti gola zopele ɲɔuni, ti ʋɛɛ ti unga ga duɔla ɓaaɓaagi. ");
INSERT INTO tod_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ti eteai ɓaani ti ma ga boti ɓaaɓaagiti ti ɠɛni kɛɛzu, pɔlɔ ɠaayɔ faiti, ɓiliki loɠa vaiti, ta kpalaga wotiiti kpein, nii nɔ da ɠɛ ma wotii kpein, ti ti pɛ daani ti unma ga maaɓaai. ");
INSERT INTO tod_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ezipete masagi ɓɔɛni Eɓulu nuiti ta-maavie bo anzanuiti pɔ, gilagi laaseigi ɠɛni ga, Sifela, zɔi ɠɛ ga Pua, ");
INSERT INTO tod_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","é ɠɛ ti ma: «Siɛgi zu wo maaviegi wosu da Eɓulu anzanuiti pɔ bɛ, ni zunu loun ʋe, à naa ʋaa. Ni anzanu loun ʋe, à naa yɛ ná, é yɛ vulua.» ");
INSERT INTO tod_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kɛlɛ maavie bo anzanuiti ti ɠɛni luazu GALA ba, ti la ɠɛni kɛɛni, eɠɛʋelei Ezipete masagi boni la, ti ɠɛni doun zunuiti zɛsu vulua. ");
INSERT INTO tod_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ezipete masagi maavie bo anzanuiti tolini, é ɠɛ ti ma: «Lee vaa zu wo naa ɠɛɛzu, wo ɗa doun zunuiti zɛ vulua?» ");
INSERT INTO tod_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Maavie bo anzanuiti ti Falaɠɔn wooɠaaʋoteni, ti ɠɛ ma: «Eɓulu nuiti ti-anzaiti ti la ga Ezipete anzanuiti kɛʋele, ti zulogɛ, ta doin zɔlɔɔsu pɛ, maavie bo anzanui mu ge ʋa zeeli ná.» ");
INSERT INTO tod_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","GALA ge tuya looni maavie bo anzanuiti bɛ. Nuɓusɛiti maamɔinni, ti-zɛbɛi wɔɔlɔ. ");
INSERT INTO tod_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tɛi maavie bo anzanuiti ti luani GALA ba, GALA ge ti-mavofodai ɠaawɔɔlɔ. ");
INSERT INTO tod_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Názu ɠa Falaɠɔn niima levei veeni la ná-nuɓusɛi kpein zea ga: «Zunu lointi kpein ta zɔlɔɔ, wa naati pili ya ziɛ wolai Nile wu, kɛlɛ anzanu lointi kpein wa naati zɛ vulua.» ");
INSERT INTO tod_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Levi ná-pɛlɛyeɠei wu zunui ta liini, é anzanui ta zeɠe ná-bolodai zu, é sei ga anza. ");
INSERT INTO tod_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Naama anzanui kogi zeɠeni, é doun zunu zɔlɔɔ. É kaani ga doungoi ʋagɛ, é seɠeni, é dɔɔɠu alu saʋagɔ laawu. ");
INSERT INTO tod_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tɛi é la mɔ ɠɛni zooga é ʋa dɔɔɠu, é tɛmu ɓɔlɔgi zeɠeni, é managi ziɛ ba. Naa ʋolu é doungoi zeɠeni, é da su, é li, é sei seeligiti saama ziɛ wolai Nile ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Doungoi diɛ anzanui liini, é lo ɠoozama tago, nii a kɛ é kwɛɛ, nii é ʋaazu ɠɛɛzu la. ");
INSERT INTO tod_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Falaɠɔn ná-doun anzanui yeini ziɛ wolai Nile ʋɔ pelei ga é maagba, ta ná-botiɠɛ anzanuiti, ti ɠɛni ziɛziɛsu ziɛ wolai Nile laaʋɛ. É wɛlɛni, é tɛmu ɓɔlɔgi ɠa seeligiti saama, é ná-botiɠɛ anzanui leʋeni ga é li, é seɠe. ");
INSERT INTO tod_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","É daalaoni, é doungoi ɠa laani su. Zunu loungoi ɠɛni de, é ɗa wɔlɔ. Naa maawɔin soni, é ɠɛ ma: «Eɓulu nuiti ti-loin ta ɠaa.» ");
INSERT INTO tod_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Doungoi diɛ anzanui ɠɛni Falaɠɔn ná-doun anzanui ma: «Nà zoo nɛi gè li, gè doun ɠulasu anzanui ta loli è ʋɛ, Eɓulu anzanuiti saama, naa ɠa a kɛ é ɗa ɲiimii ve doungoi nii ya è ʋɛ?» ");
INSERT INTO tod_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Falaɠɔn ná-doun anzanui gooɠaaʋoteni, é ɠɛ ma: «Li!» Anzanu loungoi liini, é doungoi dee loli. ");
INSERT INTO tod_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Falaɠɔn ná-doun anzanui ɠɛni ma: «Li bɛ̀ ga doungoi nii, è ɗa ɲiimii ve zea, nà ʋaazu è zalazu.» Anzanui doungoi zeɠeni, é kula su. ");
INSERT INTO tod_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Siɛgi zu doungoi wɔɔlɔni la, é liini la Falaɠɔn ná-doun anzanui ʋɔ. Naa seɠeni, é kɛ ga ná-doun zunu. É daasei pɛɛni ga Moize, mazɔlɔɔ é ɠɛni ma: «Gè kulaʋɛ ziɛi ɠa.» ");
INSERT INTO tod_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Naama ziɛgi zu, Moize wɔɔlɔai ma, é liini ná-nuɓusɛiti pɔ bɛ, é wɛlɛni, é naati ta-woti ɓaagiti pɛtɛ. É Ezipete nui ta ɠaani, é ɗa kɛɛɠɛloin Eɓulu nui ta loɠa. ");
INSERT INTO tod_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","É wɛlɛni ɠoba, é kaai ma ga nu nɔpɛ ge la ɠɛni ná, é Ezipete zunui zoni, é paa, é dɔɔɠu ɲaɠaegi zu. ");
INSERT INTO tod_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","É ɠulani naa ʋoluma zobui, pɛtɛ, Eɓulu zunu felegɔ ɠɛni ná, ti ɗa kɔ. Zɔi é la ɠɛni ʋeeni, é ɠɛni naa ma: «Lee vaa zu è è-ɠɛɛloin loɠazu?» ");
INSERT INTO tod_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","É gooɠaaʋoteni, é ɠɛ ma: «Ɓɛ ɠa é è zeiɗa ga kundiɠii ta tukpɔɠaaleʋe nui gi unda? Ɗa ɠisiɛzu ga è pàa, eɠɛʋelei è Ezipete nui ʋaani la?» Moize luani, é ɠɛ ɓɔɠɔ ma: «Gaamazu fai nii ɠwɛɛgɛ na.» ");
INSERT INTO tod_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Falaɠɔn naa mɛnini, nii é ɠɛɛni, é ɠɛni pɔ ga é Moize ʋaa. Kɛlɛ Moize ʋelani Falaɠɔn ʋa, é li poun, é zei Madiyan yooi zu. Kɛai ma ziɛyeɠei ta ɠobaʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","anzanu loun lɔfela ti ʋaani ziɛ zaɠazuʋɛ. Ti ɠɛni ga Madiyan zalaɠa ɠula nui ná-doun anzanuiti. Ti toganiiti ta-ɓɔɔle wosuʋɛti daaveni, ti ti-ɠɛɛ ná-togani ɓulugiti kɔ. ");
INSERT INTO tod_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kɛlɛ togani makɛ nuiti ti ʋaani, ti ti ɓɛ. Moize wuzeɠeni, é ti maalobo, é ta-logani ɓulugiti kɔ. ");
INSERT INTO tod_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Siɛgi zu ti ɠaleni ma la ti-ɠɛɛ Leyuwɛle ʋɔ bɛ, naa ti ɠaazaɠani, é ɠɛ ti ma: «Lee vaa zu wo ʋaai fala za?» ");
INSERT INTO tod_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ti gooɠaaʋoteni, ti ɠɛ ma: «Ezipete zunui ta ɠa é gi maalobogai, é gi ɠula togani makɛ nuiti zea, é ziɛi zaɠaʋɛ vɔlɔ gi ʋɛ, é togani ɓulugi ɠɔ.» ");
INSERT INTO tod_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","É ɠɛni ná-doun anzanuiti ma: «Mini ɠa é ná? Lee vaa zu wo zunui naa yɛgai mu? À tolina, é daamianigi ta mi.» ");
INSERT INTO tod_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moize yeezeini bu ga é zei zunui naa ʋɔ bɛ, naa ma ge ná-doun anzanui Sefola zeɠe, é fe bɛ ga anza. ");
INSERT INTO tod_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","É doun zunu zɔlɔɔni. Moize daasei pɛɛni ga Gɛɛlɛsome (nii poluʋɛ ga «seikɔɠɔmai»), mazɔlɔɔ é ɠɛni ma: «Nà ga seikɔɠɔma nui, gè zeini zou ɠili su.» ");
INSERT INTO tod_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Suɠoozaai ma, Ezipete masagi zaani. Izilayɛle nuɓusɛiti ti ɠɛni ɓalasu nɔ dɛ duɔlai zu, ti ɠɛni kpeei loozu. Kpeei ti ɠɛni toozu duɔlai zu, naa zeelini GALA ma. ");
INSERT INTO tod_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","GALA ge ti ɓala gooi mɛnini. GALA ge ɠizɛni ná-minazeɠegi zu, é boni Abalaame ʋɛ, ta Izaake, naa ʋɛɛ Zakɔɓe ʋa. ");
INSERT INTO tod_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","GALA ge wɛlɛni Izilayɛle nuɓusɛiti ba, ti maawɔin so. ");
INSERT INTO tod_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moize ɠɛni nɛkoi Zetelo ná-togani ɓulugi makɛsu, nii é ɠɛni ga zalaɠa ɠula nui Madiyan yooi zu. É liini ga togani ɓulugi teʋebai ʋoluʋelei, eyɛsu é li GALA ná-gizei ma, Wolɛɓe. ");
INSERT INTO tod_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠulani bɛ kɛlɛma abuzogi zaama, kpɔvɔ goi zaamaʋɛ. Moize wɛlɛni, pɛtɛ, abui soni kpɔvɔ goi ʋa ná kpein, kɛlɛ kpɔvɔ goi la ɠɛni ɠalazu ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moize ɠɛni ma: «Nà latisu, gè li, gè niima laavɔɔ vaa wolai ɠa, lee vaa zu kpɔvɔ goi la ɠalazu ɲɛgɛlɛin.» ");
INSERT INTO tod_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ɠɔoɠɔ GALAGI kaani ga toɠa na lati ga é ná ɠa. GALA ge yɛni kpɔvɔ goi zaamaʋɛ, é toli, é ɠɛ ma: «Moize! Moize!» É gooɠaaʋoteni, é ɠɛ ma: «Nà ɠaa!» ");
INSERT INTO tod_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","GALA ge ɠɛni ma: «Mina maaɓuɠa ʋɛ ʋa, ɗa-zaʋalagiti kula ɠɔɠɔa, mazɔlɔɔ adaʋɛ ʋɛ è loni ná, zou ʋe gè maaɲɛɛ ʋɛai ba.» ");
INSERT INTO tod_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","É ɠɛni ma ʋolu: «Nà ɠa gè ga è-ɠɛɛ ná-GALAGI, ta è-mɛmɛwolani Abalaame, Izaake, ta Zakɔɓe ta-ƓALAGI.» Moize ɠaazuʋɛ lɔɔɠuni, mazɔlɔɔ é ɠɛni luazu ga é mina wɛlɛ GALA ba. ");
INSERT INTO tod_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè nà-nuɓusɛiti ta-ɓɔlɔi ɠaa Ezipete yooi zu, gè ta-ɓee wooi mɛniga, ti toozu ta-wɛlɛma nuiti zea, gè ta-ɓɔlɔi ɠwɛɛ. ");
INSERT INTO tod_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Gè ʋaa ga gè ti unmɔɔ, gè ti ɠula Ezipete nuiti zea, gè lɛ ga tiye zou ʋagɔi zu, suwɔɔlɔai, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná, zooi nii Kanaan nuiti ti zeini su, ta Ɠɛte nuiti, ta Amool nuiti, ta Felɛze nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti. ");
INSERT INTO tod_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Niizu Izilayɛle nuɓusɛiti ta-ɓee wooiti ti zeelia mà, gè nimizai ɠa, nii Ezipete nuiti ti seizu ti ma. ");
INSERT INTO tod_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Naa ɠa é ba, nà è leʋesu Falaɠɔn ʋɔ bɛ, è nà-nuɓusɛi Izilayɛle nuiti kula Ezipete yooi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moize ɠɛni GALA ma: «Ɓɛ ɠa é ga ze, gè liizu Falaɠɔn ʋɔ bɛ, ga gè Izilayɛle nuɓusɛiti kula Ezipete yooi ʋa?» ");
INSERT INTO tod_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","GALA ge ɠɛni ma: «Nà ɠɛ è ʋa, wɛlɛ nii é ɠɛɛzu ga poogi ga nà ɠa gè è leʋesu: Siɛgi zu ɗa nuɓusɛiti kulana la Ezipete yooi ʋa, wa nɔkɔ bù gizei nii ma.» ");
INSERT INTO tod_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moize ɠɛni GALA ma: «Nà liizu Izilayɛle nuɓusɛiti pɔ bɛ, gè ɠɛ ti ma: ‹Wo-mɛmɛwolani ta-ƓALAGI tèʋegɛ wo ʋɔ bɛ.› Kɛlɛ ni ta gàazaɠana ga ‹daasei ka lee?› Nà ti wooɠaaʋote ɠale?» ");
INSERT INTO tod_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","GALA ge ɠɛni Moize ma: «Nà ga naa, nii é ná.» É ɠɛni ma mɔnɔ: «Pele ɠa ɗa Izilayɛle nuiti gooɠaaʋote da: ‹Zɔi é lolisu ga: Nà ná, naa ɠa é tèʋegai wo ʋɔ bɛ.› » ");
INSERT INTO tod_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","GALA ge ɠɛni Moize ma mɔnɔ: «Ɗa ɓɔɛ ɠani Izilayɛle nuiti pɔ: ‹Ɠɔoɠɔ GALAGI, nii é ga wo-mɛmɛwolani ta-ƓALAGI, Abalaameni, ta Izaake, naa ʋɛɛ Zakɔɓe ʋa, ta-ƓALAGI naa ɠa é tèʋegai wo ʋɔ bɛ.› Dàaseigi ɠana eyɛsu ɠɔ, pele ɠana gè pɔ ga ti ɗa wooɠula mà la, yeeɠɛɠalaiti pɛ su. ");
INSERT INTO tod_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Li, è Izilayɛle ɠɛwolaiti gaalɛ ba, è ɠɛ ti ma: ‹Ɠɔoɠɔ GALAGI, wo-mɛmɛwolani ta-ƓALAGI ɠulaʋɛ bɛ̀ kɛlɛma, nii é ga Abalaame ná-GALAGI, ta Izaake, ta Zakɔɓe. É ɠɛ ma: Gè wɛlɛa wo ma, gaamazu gè naa ɠaa, nii ti daazu wo ma Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Gè devea ga nà ʋaazu lɛɛzu ga woye, gè wo ɠula Ezipete yooi ʋa, ʋɛ wo ná kpɔlɔi zu, gè li ga woye Kanaan nuiti ta-yooi zu, ta Ɠɛte nuiti, ta Amool nuiti, ta Felɛze nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná.› ");
INSERT INTO tod_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ta woilo è-woo ma. Ɗa-o, Izilayɛle ɠɛwolaiti-yo, wa li Ezipete masagi ʋɔ bɛ, wo ɠɛ ma: ‹Ɠɔoɠɔ GALAGI, Eɓulu nuiti ta-ƓALAGI ʋaaʋɛ gi ʋɔ. Va bu niizu, gi folo saʋagɔ ziɛ wo teʋebai zu, ga gi li, gi zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, é ga gá-ƓALAGI.› ");
INSERT INTO tod_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Gè kwɛni ga Ezipete masagi la ʋaazu yeeɓesu wo ʋa, wo ʋa li, ni naa la ɠɛɛni ga zeemaɓai. ");
INSERT INTO tod_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nà yeemaalesu, gè Ezipete yooi loɠa ga maaɓɛlɛ vai ma ziiti kpein, gè ʋaazu kɛɛzu ti zaama. Naa ʋoluma, toɠa ʋaazu yeeɓesu wo ʋa, wo li. ");
INSERT INTO tod_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nà fai ta ɠɛ, nii a kɛ niima nuɓusɛiti ti ɠaazu unfe sɔlɔɔ Ezipete nuiti gaazu. Siɛgi zu wo ʋaazu liizu la, wo la lia ga yeaɲaka ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Izilayɛle anzanui ɠilagilagi ɠa wali aniɲakaiti, ta zanu aniɲakaiti, ta seɠeiti fali seiɲɔɠɔi ma, ta naama anzanui ma, nii é ná-pɛlɛi wu, wo wo-loun zunuiti ta wo-loun anzanuiti maaɠili la. Wa ti ɠula Ezipete nuiti zea, wo ti maavo.» ");
INSERT INTO tod_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moize gooɠaaʋoteni, é ɠɛ ma: «Ti la ʋaazu laazu dà, ti la woiloga gòoi ma. Kɛlɛ ta ʋaazu ɠɛɛzu mà: ‹Ɠɔoɠɔ GALAGI la ɠulani è ʋɛ kɛlɛma.› » ");
INSERT INTO tod_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ɠɔoɠɔ GALAGI ɠɛni ma: «Lee ɠa é zoni è ya?» É gooɠaaʋoteni, é ɠɛ ma: «Tukpɔi ʋe.» ");
INSERT INTO tod_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ɠɔoɠɔ GALAGI ɠɛni ma: «Pili ya zooi ma.» É pilini ya zooi ma, naa latini, é ɠɛ ga kaalii. Moize ʋelani ba. ");
INSERT INTO tod_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yeemaale, è so wɔɔngi ʋa.» É yeemaaleni, é so, naa latini, é ɠɛ ʋolu ga tukpɔi zea. ");
INSERT INTO tod_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ɗa naa ɠɛ, naa ɠa a kɛ, ti la da ga Ɠɔoɠɔ GALAGI, ti-mɛmɛwolani ta-ƓALAGI ɠulaʋɛ kɛlɛma è ʋɛ, nii é ga Abalaame, Izaake, ta Zakɔɓe ta-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ɠɔoɠɔ GALAGI ɠɛni ma mɔnɔ: «Yeeʋɛɛ è-ɠakai zu.» É yeei ʋɛɛni ɠakai zu. Naa ʋolu é seɠeni ná, pɛtɛ, geei ɠulani zeei maaʋɛ pɛ, koleai eɠɛ kobe kolegi. ");
INSERT INTO tod_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ɠɔoɠɔ GALAGI ɠɛni ma: «Yeei ʋɛɛ ʋolu è-ɠakai zu.» É yeei ʋɛɛni ʋolu kakai zu. Naa ʋolu é yeei zeɠeni ɠakai zu, é latini, é ɠɛ ʋolu ga kɔlɔgi ɠɛʋelei. ");
INSERT INTO tod_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ni ti la laani è la, ti la ɠisɔlɔɔni poogi ma mɔungi ma, ta la poogi velesiɛi la. ");
INSERT INTO tod_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ni ɓalaa ti la laani poo felegɔi naati da, ti la woiloni è-wooi ma, ɗa ziɛ wolai Nile ma ɗɛi ta zeɠe, è pu ya zooi ma. Ziɛi è ʋaazu seɠezu ziɛ wolai Nile ɠa, naa ɠa lati, é ɠɛ ga ɲamai zooi ma.» ");
INSERT INTO tod_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moize ɠɛni Ɠɔoɠɔ GALAGI ma: «Ee, Màliɠii, gè la ga zunui nii daaɠɔlɔai, naa ma ge la tɔɔzeini bà wogi, ɓaa veleina, anɛɛ voloi naa è tɔɔzeiɗa la ga ɓɔɛa pɔ̀, nɛ̀i gè ga ɗa-wotiɠɛ nui, mazɔlɔɔ dàaʋɛ ta nɛ̀gi ti ɠiliʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ɠɔoɠɔ GALAGI ɠɛni ma: «Ɓɛ ɠa é nu vului laaʋɛ ɓɛtɛa? Ɓɛ ɠa a ɗa nui ɠɛ ga ɓoɓoi, ɓaa goizuɓɔlɔ nu, ɓaa é kɛ ga wozaɠaa nu, ɓaa gaazuɠole nu? Nà nɔ laade ɓaa, nɛ̀i gè ga Ɠɔoɠɔ GALAGI? ");
INSERT INTO tod_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Liina deɠɛmu ɠani, nà ɓɔɠɔi ɠa gè ɠɛɛzu è ʋa, ɗa ɠɛna ɓɔɛa, nii è ʋaazu bosu, nà è ɠala ga naa.» ");
INSERT INTO tod_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moize ɠɛni ma: «Ee, Màliɠii, nu ɠili teʋe, nii è pɔ è teʋe.» ");
INSERT INTO tod_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ɠɔoɠɔ GALAGI yiiɠaawanani Moize ma, é ɠɛ ma: «È-liɛ Aalɔn, Levi nui, ɠa ná. Gè kwɛɛ ga daaɠɔlɔʋɛ. Wɛlɛ tɔ ɓɔɠɔgo ʋa, é ʋaazu è laaɠomisu. Siɛgi zu é è ɠaazu la, gola ɠoozu ɠa nɛɛ, ga ziimaʋɛ pɛ. ");
INSERT INTO tod_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ɗa ɓɔɛ pɔ, è wooiti pu da. Nɔ̀un nà, nà ɠɛ wo ʋa, wa ɠɛna ɓɔɛa, nà wo ɠala ga naa, nii wa kɛ. ");
INSERT INTO tod_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Toɠa ɓɔɛ è ʋɛ nuɓusɛiti pɔ, é ɠɛ ga è-laaʋɛ, ɗɔun ɗa ɠɛ GALA tosuʋɛ tɔun bɛ. ");
INSERT INTO tod_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tukpɔi nii zeɠe ya, nii è ʋaazu poogiti kɛɛzu la.» ");
INSERT INTO tod_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moize ɠaleni ma, é li nɛkoi Zetelo ʋɔ bɛ, é ɠɛni naa ma: «Nà pɔ gè li kɛ̀ɛleaiti pɔ bɛ, niiti ti Ezipete yooi zu, gè pɛtɛ ni ta dɛ vulua.» Zetelo ɠɛni ma: «Li ziilɛigi zu.» ");
INSERT INTO tod_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ɠɔoɠɔ GALAGI ɠɛni Moize ma Madiyan yooi zu: «Ɠale ma, è li Ezipete yooi zu, mazɔlɔɔ niiti kpein ti ɠɛa pɔ ti è ʋaa, naati ti zaa.» ");
INSERT INTO tod_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moize anzai ta ná-doun zunuiti seɠeni, é ti zei soovale sinɛi ɠɔma, ti pele zo, ti ɗa li Ezipete yooi zu. Moize GALA ná-tukpɔi zeɠeni ya. ");
INSERT INTO tod_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɗa ɠalena ma Ezipete yooi zu, kɛni è maaɓɛlɛ vaiti kpein kɛ Falaɠɔn ɠaazu, nii gè ma zobogi veai è ya. Nɔ̀un nà, nà ʋaazu kigi ɓaazu, é la ʋaazu yeeɓesu nuɓusɛiti ba, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ɗa ɠɛɛzu Falaɠɔn ma: ‹Ɠɔoɠɔ GALAGI wooi ɠaa: Izilayɛle ɠa ga dòun zunu mɔungi. ");
INSERT INTO tod_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Gè bo è ma: Ɓe dòun zunui ʋa, é li, é boti ɠɛ bɛ̀. Ni è la ɠɛ kɛɛni, è ʋa ɓe ba, é ʋa li, nà è-loun zunu mɔungi undaaʋili.› » ");
INSERT INTO tod_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Siɛgi zu Moize ɠɛni siɛi ma la, é ɠulani adaʋɛ ta, ʋɛ é ɲiini ná, Ɠɔoɠɔ GALAGI daaɠomini, é ɠɛni pɔ ga é paa. ");
INSERT INTO tod_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sefola dodo ɠɔtui zeɠeni, é ná-doun zunui ná-zunu anii laayɔɓɔgi leʋega, é fɔɔɠu Moize ɠɔligi ʋa, é ɠɛ ma: «Ɗa bɛ̀ ga zinigi gè sɔlɔɔgai ga ɲamai.» ");
INSERT INTO tod_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ɠɔoɠɔ GALAGI zɛni ná. Názu ɠa anzanui ɠɛni ma la: «Zinigi sɔlɔɔgai ga ɲamai,» tatipɛlɛʋolui maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ɠɔoɠɔ GALAGI ɠɛni Aalɔn ma: «Li teʋebai zu, è Moize laaɠomi.» Aalɔn liini, é Moize laaɠomini GALA ná-gizei ma, é nɛɛnɛ. ");
INSERT INTO tod_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moize wooi kpein dɛɛni ga Aalɔn, nii Ɠɔoɠɔ GALAGI teʋeni pɔ, ta poogiti kpein é deveni ga é kɛ. ");
INSERT INTO tod_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moize ta Aalɔn ti liini, ti Izilayɛle ɠɛwolaiti kpein gaalɛ ba. ");
INSERT INTO tod_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aalɔn ʋoluvaawoni ga naama vaiti kpein, niiti Ɠɔoɠɔ GALAGI ti woni Moize ma. É poogiti kɛɛni nuɓusɛiti gaazu. ");
INSERT INTO tod_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Nuɓusɛiti ti laani da. Ti kwɛɛgai ma ga Ɠɔoɠɔ GALAGI ʋaaʋɛ Izilayɛle nuiti pɔ, ga é wɛlɛ ti ma, é ta-maanɔɠɔi ɠa, ti ɓɔɠɔmaayeini, ti nɔkɔ bu. ");
INSERT INTO tod_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Naama vaiti teʋegai ma, Moize ta Aalɔn ti liini Falaɠɔn ʋɔ bɛ, ti ɠɛ ma: «Ɠɔoɠɔ GALAGI, Izilayɛle ná-GALAGI wooi ɠaa: ‹Ɓe nà-nuɓusɛiti ba, ti li, ti fɛti ɠula teʋebai zu dàaseigi lɛbi vaa ma.› » ");
INSERT INTO tod_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Falaɠɔn ti wooɠaaʋoteni, é ɠɛ ti ma: «Ɓɛ ɠa é ga Ɠɔoɠɔ GALAGI, ga gè ɠolo bɛ, gè ɓe Izilayɛle nuiti ba, ti li? Gè la Ɠɔoɠɔ GALAGI ɠwɛɛ, gè la yeeɓega Izilayɛle nuiti ba pɛ, ti ʋa li.» ");
INSERT INTO tod_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ti ɠɛni ma: «Eɓulu nuiti ta-ƓALAGI ɠulaʋɛ kɛlɛma gi ʋɛ. Va bu gi folo saʋagɔ ziɛ wo teʋebai zu, gi li, gi zalaɠaiti kula gá-ƓALAGI, Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa a kɛ, é mina ʋa seeɓɛ wola ʋɛɛzu gi ʋa, ɓaa a ʋa kɔɔ ʋɛɛ gi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ezipete masagi ɠɛni ti ma: «Moize ta Aalɔn, leeni vaa zu wo nuɓusɛiti seɠezu ta-wotiiti ma? À ɠale ma, wo wa-wotiiti kɛ.» ");
INSERT INTO tod_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Falaɠɔn ɠɛni ma: «Niizu, niima nuɓusɛiti ti mɔinɗa zooi zu, wa ta-wotiiti suɠoloɠolosu!» ");
INSERT INTO tod_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Naama voloi nɔ, Falaɠɔn niima levei veeni nuɓusɛiti ta-wɛlɛma nuiti zea, ta ta-wotiɠɛ ɠundiɠiiti, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«À mina mɔ tufa ve nuɓusɛiti zea, eɠɛʋelei é ɠɛa ɠɛɛzu la mɔungi zu, ga ti ʋa ɓilikii loɠa, ti ɗa li niina, tiya ɓɔɠɔi ti ɗa tufai yɛʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Anɛɛ naa ʋe, ɓilikii liegɔi ti ɠɛa doɠazu mɔungi zu, wa naa nɔ la ti ɠakala. À mina ta ɠula naa la ga tago ɓalaa, mazɔlɔɔ ta ga dɔɔʋɛ nuiti, naa ɠa é kɛɛzu, ti kpeei loozu, ti ɗa ɠɛ ma: ‹Ɓe gi ʋa, gi li, gi zalaɠaiti kula gá-ƓALAGI ʋɛ.› ");
INSERT INTO tod_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","À nui niiti kasɔɠili ga botii, ti-un ka yɛ naa ma, ti mina woilo zɛɛ ɓɔɛzuɠulaiti ma.» ");
INSERT INTO tod_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Nuɓusɛiti ta-wɛlɛma nuiti, ta ta-wotiɠɛ ɠundiɠiiti ti liini, ti ɠɛ nuɓusɛiti ma: «Falaɠɔn wooi ɠaa: ‹Gè la mɔ tufa veezu wo ya. ");
INSERT INTO tod_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Wa ɓɔɠɔi, à li, wo tufai ɠaiziɛ ɓɔɠɔ ʋɛ, ʋɛ nɔpɛ wa ka ná. Anɛɛ naa ʋe, tanɔpɛ ge la ɠulazu wa-wotii la.› » ");
INSERT INTO tod_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Nuɓusɛiti ti vazani Ezipete yooi zu ná pɛ, ti ɗa tufa unkpulugiti zɛʋɛ tufai ʋotogi zu. ");
INSERT INTO tod_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ta-wɛlɛma nuiti ti ɠɛni ɓɔizu ti la, ti ɗa ɠɛ ma: «À wa-volo ɠila kuɠui ɓe, eɠɛ nɔ siɛgi zu tufai ɠɛni la wo ya.» ");
INSERT INTO tod_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ti ɠɛni Izilayɛle nuiti ta-wotiɠɛ ɠundiɠiiti doɠazu, niiti Falaɠɔn ná-gwɛlɛma nuiti ti ti zeini ti unda. Ti ɠɛni ɠɛɛzu ti ma: «Lee vaa zu wo la ɓeni ga wogi ta za ɓilikii liegɔi loɠa, daai wo ɠakala, eɠɛʋelei é laani la wo ɠakala mɔungi zu?» ");
INSERT INTO tod_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Izilayɛle nuiti ta-wotiɠɛ ɠundiɠiiti ti liini, ti ɓaazaɠa Falaɠɔn ma, ti ɠɛ ma: «Lee vaa zu è gi zosu ɠani, gɛi gi ga ɗa-wotiɠɛ nuiti? ");
INSERT INTO tod_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Ti la mɔ tufa veezu gi ya, gɛi gi ga ɗa-wotiɠɛ nuiti, ti ɗa ɠɛ gi ma: ‹À ɓilikiiti doɠa!› Gɛi gi ga ɗa-wotiɠɛ nuiti, ta gi loɠazu, tama ɗa-nuɓusɛiti ka ti faaɠaazagi ɠɛai.» ");
INSERT INTO tod_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Falaɠɔn ti wooɠaaʋoteni, é ɠɛ ma: «Wa ga dɔɔʋɛ nuiti, dɔɔʋɛ nu wolaiti! Naa ɠa é kɛɛzu, wo ɠɛɛzu ma: ‹Ɓe gi ʋa, gi li, gi zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ.› ");
INSERT INTO tod_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Niizu, à li, wa-woti ɠɛɛzuʋɛ, nu la mɔ tufa veezu wo ya ɲɛgɛlɛin, kɛlɛ wa ɓilikii liegɔi nɔ ve, nii wo ɠɛni feezu pɔlɔma.» ");
INSERT INTO tod_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Izilayɛle nuiti ta-wotiɠɛ ɠundiɠiiti ti kaani ga ta ti maanɔɠɔzu nɔ sɛsɛ, ti ɗa ɠɛ ma: «Wo la tanɔpɛ kulazu ɓilikii liegɔi la, nii é veezu folo-o-folo.» ");
INSERT INTO tod_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ti ɠulazuʋɛ Falaɠɔn ʋɔ bɛ, ti zeelini Moize ta Aalɔn ʋɔ bɛ, naati ti ɠɛni ti maaɓɔunsu. ");
INSERT INTO tod_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ti ɠɛni ti ma: «Ɠɔoɠɔ GALAGI ɠa wo ɠaazu, toɠa wo lukpɔɠaaleʋe! Wo gi maayogi zeɠea Falaɠɔn ta ná-botiɠɛ nuiti bɛ. Wo boɠa zɔkpɔi laa ti-yeezaamaʋɛ, ga ti gi ʋaa la.» ");
INSERT INTO tod_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moize ɠaleni ma Ɠɔoɠɔ GALAGI ʋɔ bɛ, é ɠɛ ma: «Màliɠii, lee vaa zu é faa ɲɔi ɠɛa ga niima nuɓusɛiti? Lee vaa zu è tèʋegai? ");
INSERT INTO tod_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kaipa gè liini Falaɠɔn ʋɔ bɛ, gè ɓɔɛ pɔ è-laaseigi zu, toɠa faa ɲɔi ɠɛɛzu nɔ ga niima nuɓusɛiti, ɗa ma, è la ɗa-nuɓusɛiti unmɔɔni pɛ, è ʋa ti ɠula zea.» ");
INSERT INTO tod_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɗa ʋaazu pɛtɛsu niizu, nii gè ʋaazu kɛɛzu ga Falaɠɔn. Nà-zeeɠaaɓaa wolai maaʋele ɠa é ʋaazu ɓesu la Izilayɛle nuiti ba, ti li, toɠa ti ɓɛɛzu, é ti ɠula ná-zooi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","GALA ge ɓɔɛni mɔnɔ Moize ʋɔ, é ɠɛ ma: «Nɔ̀un nà, nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Gè ɠulani kɛlɛma Abalaame ʋɛ, ta Izaake, ta Zakɔɓe, ga GALA Zɛbɛi-Pɛ-Maliɠii, kɛlɛ gè la ɠɛni ɓɔɠɔ lɛɛni ga tiye ga dàaseigi ɠa ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Gè minazeɠeni ti ʋɛ, ga nà Kanaan yooi veezu ti ʋɛ, zooi naa, nii ti su ga seikɔɠɔma nuiti. ");
INSERT INTO tod_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nɔ̀un nà, gè Izilayɛle nuiti kpala gooi mɛnigɛ, niiti ti ga Ezipete nuiti ta-luɔiti. Gè ɠizɛgɛ nà-minazeɠegi zu. ");
INSERT INTO tod_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Naa ɠa é ba, ɠɛ Izilayɛle nuiti ma: ‹Nà ga Ɠɔoɠɔ GALAGI, nà wo viesu, gè wo ɠula boti ɓaagi laawu, niiti Ezipete nuiti ti daazu wo unma. Nà wo unmɔɔsu, wo ɠula duɔlai zu, nii wo su ti ya. Nà wo unmɔɔsu ga nà-zeeɠaaɓaai, naa ɠa ɠɛ ga tukpɔɠaaleʋe wolai ti laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nà wo zeɠezu, wo ɠɛ ga nà-nuɓusɛiti, nà ɠɛ ga wa-ƓALAGI. Wa suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo unmɔɔsu, é wo ɠula boti ɓaagiti daawu, niiti Ezipete nuiti ti daazu wo unma. ");
INSERT INTO tod_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nà lɛɛzu ga woye zooi naa zu, nii gè ma ɠonai woni ga nà fe Abalaame ya, ta Izaake, ta Zakɔɓe. Nɔ̀un nà, nà feezu wo ya, é ɠɛ ga wɔnɔ. Nà Ɠɔoɠɔ GALAGI ʋe.› » ");
INSERT INTO tod_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moize naama wooiti boni Izilayɛle nuiti ma, kɛlɛ naati ti la ɠɛni woiloni goo ma, mazɔlɔɔ ti ɠɛni iɲɔteʋe wolai zu, duɔla ɓaaɓaa golai maaʋele ma, nii ti ɠɛni su. ");
INSERT INTO tod_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Li, è ɓɔɛ Falaɠɔn ʋɔ, Ezipete masagi, é ɓe Izilayɛle nuiti ba, ti li, ti ɠula ná-zooi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moize Ɠɔoɠɔ GALAGI wooɠaaʋoteni, é ɠɛ ma: «Izilayɛle nuiti ti la woiloni gòoi ma. Falaɠɔn ɠa zoo ɠale woilosu gòo ma, nɛ̀i kpɔ̀ɛla ɓaai?» ");
INSERT INTO tod_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é deveiti fe ti ya, é ʋilɛ Izilayɛle nuiti ba ta Ezipete masagi Falaɠɔn, Izilayɛle nuiti kula vai zu Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Izilayɛle nuiti ta-ʋɛlɛyeɠeiti ma ɠundiɠiiti ti ɠɛni ga: Izilayɛle ná-doun zunu mɔungi é zɔlɔɔni, daa ga Luɓɛn. Naa ná-doun zunuiti ti ɠɛni ga: Enɔke, Palu, Ɠɛsɛlon, ta Kaalemi. Luɓɛn nɔnɔ ma ʋɛlɛyeɠeiti kana. ");
INSERT INTO tod_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simiyɔn ná-doun zunuiti ti ɠɛni ga: Yemuwɛle, Yamin, Woɠade, Yakin, Soɠaal, ta Sayile, Kanaan anzanui ná-doun zunui. Simiyɔn ná-pɛlɛyeɠeiti kana. ");
INSERT INTO tod_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi ná-doun zunuiti daaseigiti kaa, eɠɛʋelei ti-mavofodaiti ti la: Gɛɛlɛson, Keɠate, ta Melali. Levi zii ma ɠonagiti ti ɠɛni ga kona ungila puusaʋagɔ maazu lɔfela (137). ");
INSERT INTO tod_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gɛɛlɛson ná-doun zunuiti ti ɠɛni ga: Liɓini ta Simeyi, ta ta-ʋɛlɛyeɠeiti. ");
INSERT INTO tod_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Keɠate ná-doun zunuiti ti ɠɛni ga: Amalame, Yiseɠaal, Eɓelɔn, ta Uziyɛle. Keɠate zii ma ɠonagiti ti ɠɛni ga kona ungila puusaʋagɔ maazu saʋagɔ (133). ");
INSERT INTO tod_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Melali ná-doun zunuiti ti ɠɛni ga: Maali ta Musi. Naati ka ti ga Levi ná-pɛlɛyeɠeiti, eɠɛʋelei ti-mavofodaiti ti la. ");
INSERT INTO tod_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amalame nazai Yokeɓɛde zeini ga anza, naa doun zunuiti sɔlɔɔni bɛ: Aalɔn ta Moize. Amalame zii ma voloi kpein ge ɠɛni ga kona ungila puusaʋagɔ maazu lɔfela (137). ");
INSERT INTO tod_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yiseɠaal ná-doun zunuiti ti ɠɛni ga: Kolé, Nefɛge, ta Zikili. ");
INSERT INTO tod_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziyɛle ná-doun zunuiti ti ɠɛni ga: Misayɛle, Ɛlɛsafan, ta Sitili. ");
INSERT INTO tod_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aalɔn Naason baazeelai Eliseɓa zeini ga anza, nii é ga Aminadaɓe ná-doun anzanui, naa doun zunuiti sɔlɔɔni bɛ: Nadaɓe, Aɓiyu, Eleazaal, ta Itamaal. ");
INSERT INTO tod_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kolé ná-doun zunuiti ti ɠɛni ga: Asiil, Ɛlɛkana, ta Aɓiazafe. Kolé ná-doun zunuiti ta-ʋɛlɛyeɠeiti kana. ");
INSERT INTO tod_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aalɔn ná-doun zunui Eleazaal, Putiyɛle ná-doun anzanui zeini ga anza, naa doun zunu zɔlɔɔni bɛ, é daasei pɛɛni ga Fineyase. Naati ka ti ga Levi lointi ta-ʋɛlɛyeɠeiti ma ɠundiɠiiti, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la. ");
INSERT INTO tod_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aalɔn ta Moize naati ka Ɠɔoɠɔ GALAGI ɠɛni ti ma: «À li, wo Izilayɛle nuiti kula Ezipete yooi ʋa, wo ti zei kpasu ga pagɔ.» ");
INSERT INTO tod_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moize ta Aalɔn ɠa ti liini, ti ɓɔɛ Ezipete masagi Falaɠɔn ʋɔ, ga ti Izilayɛle nuiti kula Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Siɛgi zu Ɠɔoɠɔ GALAGI ɓɔɛni la Moize ʋɔ, Ezipete yooi zu, ");
INSERT INTO tod_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","é ɠɛni ma: «Nà ga Ɠɔoɠɔ GALAGI. Li, è ɓɔɛ Ezipete masagi Falaɠɔn ʋɔ, naama vaiti kpein bo ma, nii gè bosu è ma.» ");
INSERT INTO tod_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kɛlɛ Moize Ɠɔoɠɔ GALAGI wooɠaaʋoteni, é ɠɛ ma: «Nɔ̀un nà ɠa kpɔ̀ɛla ɓaai, Falaɠɔn ɠa woilo ɠale gòo ma?» ");
INSERT INTO tod_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Wɛlɛ, nà è losu GALA tosuʋɛ Falaɠɔn ʋɛ, è-liɛ Aalɔn ɠɛ ga è laavaawo nui. ");
INSERT INTO tod_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ɗɔun, ɗa naati kpein bo, nii gè ʋaazu è levezu ma. È-liɛ Aalɔn ɠa lati, é ti wo ʋolu Falaɠɔn ma, ga é ɓe Izilayɛle nuiti ba, ti ɠula ná-zooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Nà ma, nɔ̀un, nà Falaɠɔn ɠigi ɓaazu, nà nà-poogiti ta nà-laavɔɔ vaiti kɛ, ná zeizu ɠɛ mɔinmɔin Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kɛlɛ Falaɠɔn la ʋaazu woilosu wo-wooi ma. Názuʋɛ, nà yeeʋɛɛzu Ezipete yooi ma, gè nà-nu ɓulugiti kula Ezipete yooi ʋa, nà-nuɓusɛiti ti ga Izilayɛle nuiti, ga tukpɔɠaaleʋe wolai maaʋele. ");
INSERT INTO tod_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ezipete nuiti ta suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, siɛgi zu gè ʋaazu yeemaalesu da Ezipete yooi maazu, gè Izilayɛle nuiti kula ti zaama.» ");
INSERT INTO tod_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moize ta Aalɔn ti naa ɠɛɛni, eɠɛʋelei nɔ kpein Ɠɔoɠɔ GALAGI devei veeni la ti ya. ");
INSERT INTO tod_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moize ná-konagi ɠɛni niina ga puulɔsaʋa (80), Aalɔn ná-konagi ɠɛ ga puulɔsaʋa maazu saʋagɔ (83), siɛgi zu ti liini la, ti ɓɔɛ Falaɠɔn ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: ");
INSERT INTO tod_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Ni Falaɠɔn a ɓɔɛna wo ʋɔ, é ɠɛ wo ma: ‹À laavɔɔ vaa ɠila kɛ,› ɗa ɠɛ Aalɔn ma: ‹Ɗa-lukpɔi zeɠe, è pili Falaɠɔn ɠakala zooi ma.› Toɠa ɠɛ ga kaalii.» ");
INSERT INTO tod_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moize ta Aalɔn ti liini Falaɠɔn ʋɔ bɛ, ti naa ɠɛɛni, nii Ɠɔoɠɔ GALAGI valini la ti ma. Aalɔn ná-tukpɔi ʋilini zooi ma Falaɠɔn ɠakala ta ná-botiɠɛ nu wolaiti, naa latini, é ɠɛ ga kaalii. ");
INSERT INTO tod_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kɛlɛ Falaɠɔn molikulagiti tolini, ta zoɠoiti. Tiya ɓalaa, ti naa ɠɛɠalai ɠɛɛni ga ta-zoɠolaiti maaʋele. ");
INSERT INTO tod_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ti kpein ti ta-lukpɔiti pilini zooi ma, naati ti latini, ti ɠɛ ga kaaliiti. Kɛlɛ Aalɔn ná-tukpɔi ta-lukpɔiti kpɔleni. ");
INSERT INTO tod_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Falaɠɔn ɠigi ɓaani, é la ɠɛni woiloni Moizeni ta Aalɔn wooi ma pɛ, eɠɛʋelei nɔ Ɠɔoɠɔ GALAGI boni la. ");
INSERT INTO tod_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Falaɠɔn ɠigi ɓaa, é la kɛɛzu, é ʋa ɓe nuɓusɛiti ba, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Li Falaɠɔn ʋɔ bɛ sobui nɔ, toɠa ɠulazu, é ɗa li ziɛ wolai Nile laaʋɛ. Tukpɔi zo ya, nii é latini, é ɠɛ ga kaalii. ");
INSERT INTO tod_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ɗa ɠɛɛzu Falaɠɔn ma: ‹Ɠɔoɠɔ GALAGI, Eɓulu nuiti ta-ƓALAGI, tèʋegɛ è ʋɔ bɛ ga gè bo è ma ga è ɓe ná-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛbi teʋebai zu. Kɛlɛ ɗɔun, zaaɠaza é la dɛ kɛɛni. ");
INSERT INTO tod_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ɠɔoɠɔ GALAGI wooi ɠaa: Ɗa ʋaazu kwɛɛsu nii maaʋele ma, ga toɠa ga Ɠɔoɠɔ GALAGI. Nà ʋaazu ziɛ wolai Nile loɠazu ga tukpɔi é zoni zèa, toɠa ʋaazu latisu, é ɠɛ ga ɲamai. ");
INSERT INTO tod_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kaleiti kpein ti ziɛ wolai Nile wu, ta za, ziɛ wolai Nile makugi ɠa ɠula, Ezipete nuiti ta ɠaaɓa wafuun ga ti ziɛ wolai Nile ta ɓɔle.› » ");
INSERT INTO tod_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɠɛ Aalɔn ma: ‹Ɗa-lukpɔi zeɠe, è yeemaale Ezipete nuiti ta-ɗɛiti ma: ta-ɗɛ wolaiti, ta-ma ɓekegiti, ta-ɓoigiti, ta ta-ɗɛ yeɠe goiti. Ta ɠɛ ga ɲamai, ɲamai ɠa ɠɛ Ezipete yooi kpein su, gulu aniɲakaiti su ta kɔtu aniɲakaiti.› » ");
INSERT INTO tod_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moize ta Aalɔn ti naa ɠɛɛni, nii Ɠɔoɠɔ GALAGI valini la ti ma. É tukpɔi wuzeɠeni, é ziɛ wolai Nile loɠa Falaɠɔn ɠaazu, ta ná-botiɠɛ nu wolaiti gaazu, Nile ɗɛi kpein ge latini ga ɲamai. ");
INSERT INTO tod_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kaleiti ti zaani ziɛ wolai Nile wu. Ziɛ wolai Nile makugi ɠulani, Ezipete nuiti ti la mɔ ɠɛni zoosu ti ʋa ziɛ wolai Nile ɓɔle. Ɲamai ɠɛni Ezipete yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kɛlɛ Ezipete molikulagiti ti naa ɠɛɠalai ɠɛɛni ga ta-zoɠolaiti maaʋele. Falaɠɔn ɠigi ɓaani, é la woiloni Moizeni ta Aalɔn woo ma, eɠɛʋelei nɔ Ɠɔoɠɔ GALAGI boni la. ");
INSERT INTO tod_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Falaɠɔn ɠaleni ma, é li ná-masa pɛlɛi wu, é la vɔlɔ ɠisɔlɔɔni niima vai ma ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ezipete nuiti kpein ti zeɠeiti bɔɔni ziɛ wolai Nile maaɠoolii zu, ga ti kpɔɔle ɗɛ zɔlɔɔ, mazɔlɔɔ ti la ɠɛni zoosu ti ʋa ziɛ wolai Nile ta ɓɔle. ");
INSERT INTO tod_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ɠɔoɠɔ GALAGI ziɛ wolai Nile ɠoloɠologai ma, é kɛɛni su ga folo lɔfela. ");
INSERT INTO tod_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Li Falaɠɔn ʋɔ bɛ, è ɠɛ ma: ‹Ɠɔoɠɔ GALAGI wooi ɠaa: Ɓe ná-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛ̀bi. ");
INSERT INTO tod_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ni è la ɠɛ kɛɛni, è ʋa ɓe ti ʋa, ti ʋa li, nà ʋaazu ɗa-yooi kpein suɠoloɠolosu ga zɔlɔgiti. ");
INSERT INTO tod_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Ziɛ wolai Nile wuulaa ɠa ve ga zɔlɔgiti, ta ɠula bu, ti lɛ ɗa-masa pɛlɛi wu, ti lɔ è laa ʋɛlɛi wu, ta ɗa-ʋetei zu, ti lɛ ɗa-wotiɠɛ nuiti ta-ʋɛlɛiti bu, ta ɗa-nuɓusɛiti pɔ bɛti, ta ʋu ɗa-ɓulu mɔ zeɠeiti su, ta ɗa-ɓulu vukɔ ɠaayɔ aniɲakaiti su. ");
INSERT INTO tod_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Zɔlɔgiti ta lɛ wo ma, wa ɗa-nuɓusɛiti, ta ɗa-wotiɠɛ nuiti kpein.› » ");
INSERT INTO tod_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɠɛ Aalɔn ma: ‹Yeemaale ga ɗa-lukpɔi ziɛ wolaiti ma, ta ma ɓekegiti, ta kpoigiti, zɔlɔgiti ti lɛ Ezipete yooi ɠa.› » ");
INSERT INTO tod_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aalɔn yeemaaleni Ezipete ɗɛiti ma. Zɔlɔgiti ti lɛɛni, ti Ezipete yooi maaɓɔle. ");
INSERT INTO tod_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kɛlɛ molikulagiti ti naa ɠɛɠalai ɠɛɛni ga ta-zoɠolaiti maaʋele. Ti zɔlɔgiti puuni ɓalaagi Ezipete yooi ɠa. ");
INSERT INTO tod_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Falaɠɔn Moizeni ta Aalɔn lolini, é ɠɛ ti ma: «À Ɠɔoɠɔ GALAGI maanɛɛnɛ, naa ɠa a kɛ é zɔlɔgiti maaɠooza gi ʋa ga nà-nuɓusɛiti. Nà ɓesu wa-nuɓusɛiti ba, ti li, ti zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Moize ɠɛni Falaɠɔn ma: «Masagi, va bu ɗa ɓɔɠɔi è kui lɛ ga ze, yeei gè ʋaazu Ɠɔoɠɔ GALAGI maanɛɛnɛzu la è ʋɛ, wa ɗa-wotiɠɛ nuiti, ta ɗa-nuɓusɛiti, nii a kɛ é zɔlɔgiti maaɠooza è ʋa, ta ɗa-ʋɛlɛiti? Taɠila kpalaa ge la yɛga ná, kɛni ziɛ wolai Nile nɔ wu.» ");
INSERT INTO tod_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Falaɠɔn gooɠaaʋoteni, é ɠɛ ma: «Lina nɔ.» Moize ɠɛni ma: «Toɠa ɠɛ ɠana, eɠɛʋelei è faliai la, naa ɠa a kɛ, è kwɛɛ ga gala kili ge la ɠulani ga Ɠɔoɠɔ GALAGI, gá-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Zɔlɔgiti ta maaɠooza è ʋa, ta ɗa-ʋɛlɛiti, ta ɗa-wotiɠɛ nuiti, ta ɗa-nuɓusɛiti, taɠila kpalaa ge la yɛga ná, kɛni ziɛ wolai Nile nɔ wu.» ");
INSERT INTO tod_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Moize ta Aalɔn ti zeɠeni Falaɠɔn ʋɔ bɛ, Moize wooɠulani Ɠɔoɠɔ GALAGI ma, zɔlɔgiti ta-vaa zu, niiti é ti leʋeni Falaɠɔn laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ɠɔoɠɔ GALAGI naa ɠɛɛni, nii Moize falini ma. Zɔlɔgiti ti zaani pɛlɛiti bu, ta koizuʋɛti, ta dɔɓɔiti su. ");
INSERT INTO tod_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ti ti ɠaalɛɛni ba kpifɔkpifɔ, makugi ɠɛni ɠulazu zooi zu ná pɛ. ");
INSERT INTO tod_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kɛlɛ Falaɠɔn kaai ma ga faiti ti zolooga, é ɓɔɠɔ ɠikpaani, é la woiloni Moizeni ta Aalɔn woo ma, eɠɛʋelei Ɠɔoɠɔ GALAGI bogai la. ");
INSERT INTO tod_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɠɛ Aalɔn ma: ‹Ɗa-lukpɔi maale, è zooi ma vufiligi loɠa. Toɠa latisu ga sosoligiti Ezipete yooi zu ná kpein.› » ");
INSERT INTO tod_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Zekana ti kɛɛni la. Aalɔn yeemaaleni ga ná-tukpɔi, é zooi ma vufiligi loɠa la. É ɠɛni ga sosoligiti, é ʋu nuiti ma, ta suaiti. Zooi ma vufiligi kpein ge ɠɛni ga sosoligiti, Ezipete yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Molikulagiti ti ta-zoɠolaiti kpein kɛɛni, ga ti ʋa sosoligiti kula, kɛlɛ ti la ɠɛni zooni. Sosoligiti ti ʋuuni nuiti ma ta suaiti. ");
INSERT INTO tod_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Názu ɠa molikulagiti ti ɠɛni la Falaɠɔn ma: «GALA ɓɔɠɔi yee ʋogi ʋe!» Kɛlɛ Falaɠɔn ɠigi ɓaani, é la woiloni Moizeni ta Aalɔn woo ma, eɠɛʋelei Ɠɔoɠɔ GALAGI bogai la. ");
INSERT INTO tod_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Wuzeɠe ga sobuzobui, è li, è lo Falaɠɔn ɠakala, siɛgi zu é ɠulazu la ga é li ziaʋɛ, ɗa ɠɛ ma: ‹Ɠɔoɠɔ GALAGI wooi ɠaa: Ɓe nà-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛ̀bi. ");
INSERT INTO tod_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ni è la ɓeni nà-nuɓusɛiti ba, ti ʋa li, nà ʋaazu è laalɔɠɔma ga dɛgiti ti laaɓadiai, wa ɗa-wotiɠɛ nuiti, ta ɗa-nuɓusɛiti, naa ʋɛɛ ɗa-ʋɛlɛiti ba. Ezipete nuiti ta-ʋɛlɛiti buulaa ɠa ve ga dɛgiti, ta zooi ɓalaa laa ɠa ve. ");
INSERT INTO tod_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kɛlɛ naama volo ná, nà zeeɠaaɠwɛɛzu ɠɛ Gosɛn yooi ʋa, ʋɛ nà-nuɓusɛiti ti zeini ná, dɛgiti ti la ɠɛa miná ɲɛgɛlɛin, naa ɠa a kɛ è suɠwɛɛ ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, nà naama yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Nà zeeɠaaɠwɛɛzu ɠɛɛzu nà-nuɓusɛiti ta ɗa-nuɓusɛiti ba. Laavɔɔ vai ma ʋoogi naa ɠa ɠula kɛlɛma lina.› » ");
INSERT INTO tod_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ɠɔoɠɔ GALAGI kɛɛni ɠana. Dɛgiti ti laaɓadiai, naati ma ɓulugi ʋaani Falaɠɔn ná-masa pɛlɛi wu, ta ná-botiɠɛ nuiti ta-ʋɛlɛiti bu, ta Ezipete yooi kpein su. Zooi ɠoloɠoloni dɛgiti zea. ");
INSERT INTO tod_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Falaɠɔn Moizeni ta Aalɔn lolini, é ɠɛ ti ma: «À li, wo zalaɠaiti kula wa-ƓALAGI ʋɛ zooi zu.» ");
INSERT INTO tod_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Moize gooɠaaʋoteni, é ɠɛ ma: «É la zolooni lago pa ga é ɠɛ ɠana, mazɔlɔɔ gá ʋaazu zalaɠaiti kulazu Ɠɔoɠɔ GALAGI ʋɛ, gá-ƓALAGI, ti ga kɔzɔba aniiti Ezipete nuiti bɛ. Ni gá zalaɠaiti kulana Ezipete nuiti gaazu, ti ga kɔzɔba aniiti ti ʋɛ, ti la gi zɔa ga kɔtui ɓaa? ");
INSERT INTO tod_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Gá folo saʋagɔ ziɛ wosu teʋebai zu, gi zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, gá-ƓALAGI, eɠɛʋelei é bogai la gi ma.» ");
INSERT INTO tod_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Falaɠɔn ɠɛ ma: «Nɔ̀un nà, nà yeeɓesu wo ʋa, wo li teʋebai zu, wo zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, wa-ƓALAGI. Kɛlɛ wa ɠɛna lia, à mina maaɠooza. À maanɛɛnɛi wo bɛ̀.» ");
INSERT INTO tod_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moize gooɠaaʋoteni, é ɠɛ ma: «Pɛtɛ, nà ga ɠula è ʋɔ bɛ, nà Ɠɔoɠɔ GALAGI maanɛɛnɛzu è ʋɛ. Lina, dɛgiti ta maaɠooza Falaɠɔn ʋa, ta ná-botiɠɛ nuiti, ta ná-nuɓusɛiti, kɛlɛ Falaɠɔn mina yɛ gi yaavazu, é ʋa ɓe yeeɓesu nuɓusɛiti ba, ti ʋa li, ti ʋa zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moize ɠulani Falaɠɔn ʋɔ bɛ, é Ɠɔoɠɔ GALAGI maanɛɛnɛ. ");
INSERT INTO tod_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ɠɔoɠɔ GALAGI kɛɛni eɠɛʋelei Moize falini la ma, dɛgiti ti maaɠoozani Falaɠɔn ʋa, ta ná-botiɠɛ nuiti, ta ná-nuɓusɛiti. Gila kpalaa ge la ɠɛni yɛni ná. ");
INSERT INTO tod_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kɛlɛ niizu mɔnɔ, Falaɠɔn ɓɔɠɔ ɠigi ɓaani, é la yeeɓeni nuɓusɛiti ba, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Li Falaɠɔn ʋɔ bɛ, è ɠɛ ma: ‹Ɠɔoɠɔ GALAGI, Eɓulu nuiti ta-ƓALAGI wooi ɠaa: Ɓe nà-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛ̀bi. ");
INSERT INTO tod_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ni è la ɠɛ kɛɛni, è ʋa ɓe ti ʋa, ti ʋa li, ɗa ti zona, ");
INSERT INTO tod_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Ɠɔoɠɔ GALAGI yeei ɠa ɠɛ ɗa-loganiiti daalɔɠɔma, niiti ti dɔɓɔiti su, sooiti, ta soovalegiti, ta ɲɔmɛiti, ta nikɛiti, ta baalagiti, ta boliiti. Toɠa ɠɛ ga ɗɔfɔi, é wola ɲɔu. ");
INSERT INTO tod_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kɛlɛ Ɠɔoɠɔ GALAGI ɠa zeeɠaaɠwɛɛzu ɠɛ Izilayɛle ná-toganiiti ba ta Ezipete nuiti ta-loganiiti. Niiti ti ga Izilayɛle nuiti tɔnɔi, gila kpalaa ge la zaa ti ʋa.› » ");
INSERT INTO tod_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ɠɔoɠɔ GALAGI kui leʋea ba, é ɠɛ ma: «Lina, Ɠɔoɠɔ GALAGI ɠa naa ɠɛ zooi zu.» ");
INSERT INTO tod_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ɠɔoɠɔ GALAGI kɛɛni ɠana nɔ, poluma voloi. Ezipete nuiti ta-loganiiti kpein ti zaani, kɛlɛ sua ɠila kpalaa ge la ɠɛni zaani Izilayɛle nuiti ta-loganiiti su. ");
INSERT INTO tod_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Falaɠɔn keelai leʋeni ga ti gaazaɠagiti bo, pɛtɛ, Izilayɛle ná-toganiiti gila kpalaa ge la ɠɛni zaani. Falaɠɔn ɠigi ɓaani, é la ɠɛni ɓeni Izilayɛle nuiti ba, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: «À yeelaave ga diɠi losuʋɛ ma yuʋui, Moize foɓe geezu ʋelei Falaɠɔn ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Toɠa ɠɛ ga fufiligi, é ʋɛɛ Ezipete yooi pɛ ma, é ɠɛ ga divologi, é lo nuiti ta suaiti ba, é ɠula ti ma, Ezipete yooi zu ná pɛ.» ");
INSERT INTO tod_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ti sulugi ma yuʋui zeɠeni, ti li, ti lo Falaɠɔn ɠakala. Moize foɓeni geezu ʋelei, é ɠɛni ga divologiti, kɛai ga kula ma anii nuiti ta suaiti ma. ");
INSERT INTO tod_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Molikulagiti ti la ɠɛni zooni ti ʋa ʋa Moize ɠakala, tɔɔzei divologiti ba, mazɔlɔɔ divologiti ti ɠɛni molikulagiti ba, eɠɛʋelei é ɠɛni la Ezipete nuiti kpein ba. ");
INSERT INTO tod_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ɠɔoɠɔ GALAGI Falaɠɔn ɠigi ɓaani, Falaɠɔn la ɠɛni woiloni Moizeni ta Aalɔn wooi ma, eɠɛʋelei Ɠɔoɠɔ GALAGI bogai la Moize ma. ");
INSERT INTO tod_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Wuzeɠe ga sobuzobui, è li, è lo Falaɠɔn ɠakala. Ɗa ɠɛɛzu ma: ‹Ɠɔoɠɔ GALAGI, Eɓulu nuiti ta-ƓALAGI wooi ɠaa: Ɓe nà-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛ̀bi. ");
INSERT INTO tod_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Mazɔlɔɔ niizu, nà ʋaazu ga maanɔɠɔ vaiti kpein ɗa ɓɔɠɔi è laalɔɠɔma, ta ɗa-wotiɠɛ nuiti daalɔɠɔma, ta ɗa-nuɓusɛiti daalɔɠɔma, naa ɠa a kɛ, è kwɛɛ ga kɛ̀ɠala nɔpɛ ge la ná eteai zu ná kpein. ");
INSERT INTO tod_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ni gè yeemaaleni, gè è loɠa ga saai, ɗa-o, ɗa-nuɓusɛiti-yo, é ga wo ɲɛɛlɛa etea. ");
INSERT INTO tod_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kɛlɛ gè è yɛgɛ vulua, naa ɠa a kɛ, è sɛ̀bɛi ɠa, ta ti dàaseigi wo eteai zu ná pɛ. ");
INSERT INTO tod_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ɗa ba, è ɗa pele ɓesa nà-nuɓusɛiti dii vai luɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Naa ɠa é ba, lina, niima lɛlɛi ma, nà sakɔtui ʋuuzu zeeɠaaɓa, nii kɛɠala nɔpɛ ge la dɛ ɠɛɛni Ezipete yooi zu, é zo naa ɓɛtɛ volo ma, eyɛsu niizu. ");
INSERT INTO tod_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Deɠɛmu, ɗa-loganiiti makɛsu ɓɛtɛna ga pagɔ, ta nii kpein é ga ɗɔnɔ, é è ya eteaʋɛ. Sakɔtui ɠa ʋaazu ʋuuzu nuiti kpein ma ta suaiti, niiti ti ʋaazu yɛsu eteaʋɛ, ti la lɔɔɠuni pɛlɛiti bu, naati ta za.› » ");
INSERT INTO tod_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Falaɠɔn ná-botiɠɛ nuiti saama, niiti ti luani Ɠɔoɠɔ GALAGI laawooi ʋa, naati ti ta-wotiɠɛ nuiti ta ta-loganiiti tɛɛni pɛlɛiti bu ga gaazuvilɛi. ");
INSERT INTO tod_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kɛlɛ niiti ti la ɠɛni Ɠɔoɠɔ GALAGI laawooi lɔɔni yiima, ti ʋa kɛ ɠaazu ma ga faa, naati ti ta-wotiɠɛ nuiti ta ta-loganiiti zɛni eteaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yeemaale geeɠɔlɔgi ʋɔ pelei, sakɔtui ʋu Ezipete yooi kpein su nuiti ma, ta suaiti, ta tufaiti kpein dɔɓɔiti su, Ezipete yooi zu.» ");
INSERT INTO tod_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moize ná-tukpɔi leteni geeɠɔlɔgi ʋɔ pelei. Ɠɔoɠɔ GALAGI tona kpunɛ tugi leʋeni, ta sakɔtui, geeɓadɛi yeini eteai zu. Ɠɔoɠɔ GALAGI sakɔtui ʋuuni Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Sakɔtui ʋuuni, mainmain ɠɛni saɠazu, geeɓadɛi ɗa loo sakɔtuiti saama, gola yeeɠaaɓaani, kɛɠala la dɛ ɠɛɛni Ezipete yooi zu, kaipa é ɠɛɛni ga ɓɔɠɔ you. ");
INSERT INTO tod_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sakɔtui ʋuuni, é zeelini Ezipete yooi kpein ma ga ɲɔuɗa, nii kpein é ɠɛni eteaʋɛ, é zo nuiti ma, é zeeli suaiti ma. Sakɔtui ʋuuni tufaiti kpein ma dɔɓɔiti su, é guluiti suɠoloɠoloni dɔɓɔiti su. ");
INSERT INTO tod_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kɛni nɔ ʋɛ Izilayɛle nuiti ti ɠɛni ná, Gosɛn yooi zu, miná ɠa sakɔtui la ɠɛni zeelini ná. ");
INSERT INTO tod_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Falaɠɔn Moizeni ta Aalɔn lolini, é ɠɛ ti ma: «Gè kotoi ɠɛa niizu. Ɠɔoɠɔ GALAGI ɠa sɔlegai, nà-o, nà-nuɓusɛiti-yo, gi la ʋeeni. ");
INSERT INTO tod_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","À Ɠɔoɠɔ GALAGI maanɛɛnɛna, nii a kɛ tona kpunɛ tugi mina mɔ ɠula, ta sakɔtui mina mɔ ʋu. Nà ɓesu wo ʋa, wo li, nu la mɔ yeeʋiliga wo zu mɔnɔ.» ");
INSERT INTO tod_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moize ɠɛni ma: «Siɛgi zu gè ɠulazu la taai ʋa, nà zeeiti tɛɛzu Ɠɔoɠɔ GALAGI ma. Tona kpunɛ tugi maa ɠa leʋe, ta sakɔtui, naa ɠa a kɛ è kwɛɛ ga Ɠɔoɠɔ GALAGI ɠa po ge ga eteai. ");
INSERT INTO tod_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kɛlɛ gè kwɛɛ ga ɗa-o, ɗa-wotiɠɛ nuiti-yo, wo la dɛ luazu Ɠɔoɠɔ GALAGI ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Gezei ta wɔɔlezegi ti ɠoloɠoloni, tɔɔzei wɔɔlezegi ɠulaa ɠɛni de su ga niinɛ, gezei ʋua ɠɛni de ga niinɛ. ");
INSERT INTO tod_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ɓeleegi ta epɔtelegi ti la ɠɛni ɠoloɠoloni, tɔɔzei ti nɛkɛgɛ.) ");
INSERT INTO tod_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moize ɠulani Falaɠɔn ʋɔ bɛ, é li taa ʋoluʋɛ, é yeeiti tɛɛni Ɠɔoɠɔ GALAGI ma, tona kpunɛ gooi ta sakɔtuiti maaleʋeni, tonai la mɔ ɠɛni ʋuuni zooi ma. ");
INSERT INTO tod_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Falaɠɔn kaai ma ga tonai, ta sakɔtui, ta tona kpunɛ gooiti maaleʋea, é ɠɛni nɔ ba, é ɗa kotoi ɠɛ, é ɓɔɠɔ ɠigi ɓaani, tɔ-o, ná-botiɠɛ nuiti-yo. ");
INSERT INTO tod_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Falaɠɔn ɠigi ɓaani, é la ɠɛni ɓeni Izilayɛle nuiti ba, ti ʋa li, eɠɛʋelei nɔ Ɠɔoɠɔ GALAGI puuni la Moize la, é bo. ");
INSERT INTO tod_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Li Falaɠɔn ʋɔ bɛ, mazɔlɔɔ nà ɠa gè kigi ɓaai, ta ná-botiɠɛ nuiti zii, nii a kɛ gè nà-poogiti kula kɛlɛma ti zaama. ");
INSERT INTO tod_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Toɠa ɓalaa ga è suɠula è-lointi ma, ta ti-lointi, pelei gè Ezipete nuiti sogai da, ta poogi ma ziiti gè ti ɠulaai kɛlɛma ti zaama. Wa suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI.» ");
INSERT INTO tod_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moize ta Aalɔn ti liini Falaɠɔn ʋɔ bɛ, ti ɠɛ ma: «Ɠɔoɠɔ GALAGI, Eɓulu nuiti ta-ƓALAGI wooi ɠaa: ‹Ɗa yɛsu ɠɛlɛzu eyɛsu siɛgi ɓɛgele zu, ga è la ɓɔɠɔ unmaayeiɗa bɛ̀? Ɓe nà-nuɓusɛiti ba, ti li, naa ɠa a kɛ ti dɛ̀bi. ");
INSERT INTO tod_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Mazɔlɔɔ ni è la ɠɛ kɛɛni, è ʋa ɓe nà-nuɓusɛiti ba, ti ʋa li, wɛlɛ, nà ʋaazu lina ga kotogiti ɗa-yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ta zooi maaɓɔle, nu la zooga é ʋa zooi ɠa, ti anii mɔtaiti mi nii é ná, nii sakɔtui zɛgai wo ya, guluiti kpein ti ɓɛtɛzu wo ʋɛ dɔɓɔiti su, ta naati kpein miizu. ");
INSERT INTO tod_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ta ɗa-ʋɛlɛiti buulaave, ta ɗa-wotiɠɛ nuiti kpein ta-ʋɛlɛiti, ta Ezipete nuiti kpein ta-ʋɛlɛiti. È-ɠɛɛni, ta è-ɠɛɛni ti-ɠɛɛni ti la ɠɛni naa ɠɛɠala ɠaani, kaipa ti ɠulani, ti ɗa yɛnvu zooi nii zu, eyɛsu niima voloi.› » Moize ʋoluaveni, é ɠula Falaɠɔn ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Falaɠɔn ná-botiɠɛ nuiti ti ɠɛni ma: «Zunui nii ɠa ɠɛɛzu ga balii ɠale ade ʋɛ, eyɛsu siɛ kpɛgele zu? Ɓena nui niiti ba, ti li, ti Ɠɔoɠɔ GALAGI lɛbi, ta-ƓALAGI. È la dɛ suɠwɛɛ ɓaa ga Ezipete undaa ɠana ʋili?» ");
INSERT INTO tod_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ti ʋaani ʋolu ga Moize ta Aalɔn Falaɠɔn ʋɔ bɛ, naa ɠɛ ti ma: «À li, wo Ɠɔoɠɔ GALAGI lɛbi. Kɛlɛ ɓɛɛni ka ti liizu?» ");
INSERT INTO tod_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moize gooɠaaʋoteni, é ɠɛ ma: «Gá liizu ga gá-nu niinɛiti ta gá-nu wɔlɔiti, gá liizu ga gi-loun zunuiti ta gi-loun anzanuiti, é ʋɛɛ gá-logani goiti ta ma wolaiti ba, mazɔlɔɔ kɛni gi fɛti ɠula Ɠɔoɠɔ GALAGI lɛbi vaa ma.» ");
INSERT INTO tod_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Falaɠɔn ɠɛni ti ma: «Ɠɔoɠɔ GALAGI yɛ wo ʋa, ni nà ɓena wo ʋa, wo li, wa-o, wo lointi-yo! À dama ga ɓɔɠɔ, tɔɔzei maanɔɠɔi ɠa wo ɠaiziɛzu! ");
INSERT INTO tod_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kɛlɛ é la ɠɛɛzu ɠana! Zunuiti à li, wo Ɠɔoɠɔ GALAGI lɛbi, mazɔlɔɔ naa ɠa wo maaɠaazaɠaboni!» Ti ti ɓɛɛni Falaɠɔn ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yeei maale Ezipete yooi maazu, nii a kɛ kotogiti ti ʋa, ti ʋu Ezipete yooi zu, ti zooi ɠa lufaiti kpein mi, nii kpein sakɔtui zɛgai.» ");
INSERT INTO tod_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moize ná-tukpɔi maaleni Ezipete yooi maazu, Ɠɔoɠɔ GALAGI ʋaani ga folo ɠulazu ʋele viilɛi zooi zu, naama voloi pɛ ta ma ɓidii pɛ. Sobui, folo ɠulazu viilɛi ʋaani ga kotogiti. ");
INSERT INTO tod_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kotogiti ti lɛɛni Ezipete yooi kpein ga, ti ʋuuni Ezipete yooi ɠa adaʋɛ pɛ, naa wola ɓɔini, é leʋe mɔungi ʋa, koto ge la dɛ mɔinni ɠana, kɛɠala la mɔ ɠɛa ʋelela ʋelei eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ti zooi maaʋɛ kpein seɠeni, zooi maaɓidini. Ti tufai kpein miini zooi ɠa, ta gulu waaiti kpein, nii kpein sakɔtui zɛni ná. Daa wundu ɠila kpalaa ge la ɠɛni yɛni guluiti ga, anɛɛ tufaiti ɓalaa dɔɓɔiti su, Ezipete yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Falaɠɔn Moizeni ta Aalɔn lolini ga gaazuvilɛi, é ɠɛ ti ma: «Gè koto ɠɛa Ɠɔoɠɔ GALAGI laalɔɠɔma, wa-ƓALAGI, ta wo laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kɛlɛ nà-kotoi zuvaayɛ na, niima gelei nɔ zu. Ɠɔoɠɔ GALAGI maanɛɛnɛ bɛ̀, wa-ƓALAGI, nii a kɛ é saa maanɔɠɔi nii maaɠooza bà niizu.» ");
INSERT INTO tod_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moize ɠulani Falaɠɔn ʋɔ bɛ, é Ɠɔoɠɔ GALAGI maanɛɛnɛ. ");
INSERT INTO tod_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ɠɔoɠɔ GALAGI ʋaani ga folo liizu ʋele viilɛi, gola yeeɠaaɓaai, é li ga kotogiti, é ti ʋili Seeli Kpoloɗɛi wu. Kotogi gila kpalaa ge la ɠɛni yɛni Ezipete yooi ná tanɔpɛ. ");
INSERT INTO tod_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kɛlɛ Ɠɔoɠɔ GALAGI Falaɠɔn ɠigi ɓaani, Falaɠɔn la ɠɛni ɓeni Izilayɛle nuiti ba, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yeei maale geeɠɔlɔgi ʋɔ pelei, kpidii ʋɛɛ Ezipete yooi zu, kpidii nu yeei a vɔɔɠu ba.» ");
INSERT INTO tod_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moize yeei maaleni geeɠɔlɔgi ʋɔ pelei, kpidii ʋɛɛni Ezipete yooi zu ná pɛ, nii gola ɠaaɠiligai, naa ɠɛɛni folo saʋagɔ laawu. ");
INSERT INTO tod_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Nu la ɠɛni bɔɔla ɠaazu, nu nɔpɛ ge la ɠɛni zeɠeni zeizuʋɛ folo saʋagɔ laawu. Kɛlɛ wozakalagi ɠɛni adaʋɛti pɛ, ʋɛ Izilayɛle nuiti ti ɠɛni náti. ");
INSERT INTO tod_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Falaɠɔn Moize lolini, é ɠɛ ma: «À li, wo Ɠɔoɠɔ GALAGI lɛbi. Wo-lointi ta zoo ti ʋilɛ wo ʋolu, kɛni wa-logani goiti ta ma wolaiti nɔ ɠa wa ti yɛ ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moize gooɠaaʋoteni, é ɠɛ ma: «Kɛni è gá-loganiiti zɛ gi ya, nii a kɛ gi zalaɠaiti ta gala zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Gá liizu ga gá-logani ɓulugiti, ma ʋoloka gila kpalaa ge la yɛga, mazɔlɔɔ toɠa gi ta zeɠezu, gi Ɠɔoɠɔ GALAGI lɛbi la, gá-ƓALAGI. Eyɛsu gi zeeli ná, gi la kwɛɛ, nii liegɔi gá kula ga zalaɠai Ɠɔoɠɔ GALAGI lɛbi vai ma.» ");
INSERT INTO tod_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kɛlɛ Ɠɔoɠɔ GALAGI Falaɠɔn ɠigi ɓaani, Falaɠɔn la ɠɛni kɛɛni, é ʋa ɓe ti ʋa, ti ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Falaɠɔn ɠɛni Moize ma: «Ɠula pɔ̀ bɛ! Dama ga ɓɔɠɔ, è ʋa gàazuʋɛ ɠa mɔnɔ, mazɔlɔɔ voloi ɗa gàazuʋɛ ʋɛtɛ da, ɗa za.» ");
INSERT INTO tod_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moize ɠɛni ma: «È boga! Gè la mɔ è-ɠaazuʋɛ ɠaa pɛ.» ");
INSERT INTO tod_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nà ʋaazu ga maanɔɠɔ ɠaaɓelagi Falaɠɔn ʋɔ ta Ezipete yooi. Naa a ɠɛɛna, toɠa ɓesu wo ʋa, wo ɠula ʋɛ ʋa. Siɛgi zu é ɓesu la wo ʋa ga wo li, toɠa wo ɓɛ ʋɛ tɛtɛ. ");
INSERT INTO tod_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ɓɔɛ nuɓusɛiti pɔ ga, zunui ɠilagilagi ta anzanui ɠilagilagi wali aniɲakaiti ta zanu aniɲakaiti fali seiɲɔɠɔi ma.» ");
INSERT INTO tod_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ɠɔoɠɔ GALAGI kɛɛni ɠana, eyɛsu nuɓusɛiti ti ɠaazu unfe sɔlɔɔ Ezipete nuiti gaazu, Moize ɓɔɠɔi ɠɛni ga nui nii unfemai ɠɛni veezu bɛ gola Ezipete yooi zu, Falaɠɔn ná-botiɠɛ nuiti zea, ta nuɓusɛiti pɛ. ");
INSERT INTO tod_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moize ɠɛni: «Ɠɔoɠɔ GALAGI wooi ɠaa: ‹Kua zaamai ma yeeɠɛɠalai, nà ʋaazu, gè leʋe Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Doun zunu mɔungi kpein ka za Ezipete yooi zu, Falaɠɔn é zeini masa kpɔkpɔgi ɠa, é zo naa ná-doun zunu mɔungi ma, eyɛsu é zeeli botiɠɛ anzanui ná-doun zunu mɔungi ma, nii é moloi ziɠazu, eyɛsu é zeeli toganiiti ti-yiʋo zinɛ mɔungiti kpein ma. ");
INSERT INTO tod_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Kpee wola ɠa loo Ezipete yooi kpein su, nii kɛɠala la dɛ ɠɛɛni kaipa, ta kɛɠala la mɔ ɠɛa pɛ. ");
INSERT INTO tod_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kɛlɛ Izilayɛle nuiti pɔ bɛ, nu la ɠite ɓalaa gilɛ ɓɔzɔ woomɛniga nu ma, ɓaa mu sua ma, naa ɠa a kɛ wo kwɛɛ ga Ɠɔoɠɔ GALAGI zɔɠɔzu ɠɛɛʋɛ Ezipete ʋa ta Izilayɛle.› ");
INSERT INTO tod_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Naazu, ɗa-wotiɠɛ nuiti kpein ta ʋa, ti nɔkɔ bù, ti ɠɛ ma: ‹Ɠula ʋɛ ʋa, wa nuɓusɛiti pɛ, niiti ti è ʋolu!› Naa ʋoluma nà ɠula, gè li.» Moize ɠulani Falaɠɔn ʋɔ bɛ ga ziiɠaawana wolai. ");
INSERT INTO tod_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Falaɠɔn la woiloga wo-woo ma, naa ɠa a kɛ gè nà-maaɓɛlɛ vaiti kɛ ga mɔinɗa Ezipete yooi zu.» ");
INSERT INTO tod_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moize ta Aalɔn ti naama maaɓɛlɛ vaiti kpein kɛɛni Falaɠɔn ɠaazu, kɛlɛ Ɠɔoɠɔ GALAGI Falaɠɔn ɠigi ɓaani, é la ɓeni Izilayɛle nuiti ba, ti ʋa li, ti ʋa ɠula ná-zooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma, Ezipete yooi zu: ");
INSERT INTO tod_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Niima alugi ɠa ɠɛ wo ʋɛ ga alugiti ma mɔungi, toɠa ɠɛɛzu wo ʋɛ ga konagi ma alu mɔungi. ");
INSERT INTO tod_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","À ɠɛ Izilayɛle ʋɛbɛi ma: ‹Niima alugi ma volo puugɔi ma, pɛlɛyeɠe ɠila baala ziʋo ɠila, ɓaa koi ɠila baala ziʋo ɠila, naa ɠa wa kula. ");
INSERT INTO tod_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ni pɛlɛyeɠei lɔiʋɛ baala ziʋoi ma, wa seɠe ti ʋɛ ta kobaʋɛ gelei, eɠɛʋelei nuiti tiegɔi la, wa baala ziʋoi naa ɠaaɠwɛ ga nii nu ɠilagilagi a zoo é mi. ");
INSERT INTO tod_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Toɠa ɠɛ ga baala ziʋoi, nii nɛɛʋuzu la ba, é ga ma zinɛi, é kona gila kulaai. Wa zoo wo baala ziʋoi ɓaa boli yiʋoi zeɠe. ");
INSERT INTO tod_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Wa makɛ, wo ɗa pɛtɛ eyɛsu alugi ma volo puugɔ maazu naanisiɛi (14), Izilayɛle ʋɛbɛi kpein ka ti ɠɔdaaleʋe kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Wa ma ɲamai zo, wo ta ziɛ daamasagiti ma, maazuʋɛ ta kobaʋɛ felegɔiti, ʋɛ a mi ná. ");
INSERT INTO tod_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Naama ɓidii nɔ, wa ma zuai mi, mɔgai abui ɠa. Wa mi ta ɓului nii lɛʋɛ la su, ta tufa wanaiti. ");
INSERT INTO tod_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","À mina ma wundu mi, ɓaa wo ʋa gili ziɛi wu, kɛlɛ toɠa mɔ abui ɠa, nɔungi ʋɛɛ ma ɓeɠaiti ba ta koozu aniiti. ");
INSERT INTO tod_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","À mina tanɔpɛ zɛ ná sobu ʋa zeeli. Ni ta a yɛna ná sobui zeeli, wa naa ɠala. ");
INSERT INTO tod_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Wɛlɛ ʋelei wa mi la: saamaɠiligi ɠa ɠɛ wo zaama, wa-zaʋalagiti ti ɠɛ wo-ɠɔɠɔiti ga, wa-lukpɔi ɠɛ zoni wo ya. Wa mi ga gaazuvilɛ. Ɠɔoɠɔ GALAGI ná-Pakegi ʋe. ");
INSERT INTO tod_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Naama ɓidii, nà ziɛzu Ezipete yooi zu, gè Ezipete yooi zu loun zunu mɔungiti kpein paa, é zo nuiti ma, é li toganiiti pɔ. Nà Ezipete yooi ná-galagiti kpein tukpɔɠaaleʋe. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ɲamai ɠa ɠɛ ga poogi wo ʋɛ pɛlɛiti ma, ʋɛ wa ɠɛ ná. Nà ɲamai ɠaana, nà ɓudɛ wo maazu, maanɔɠɔ la zeelia wo ma, nii a wo ɠoloɠolo, siɛgi zu gè ʋaazu Ezipete yooi loɠazu la. ");
INSERT INTO tod_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","« ‹Naama voloi ɠa ɠɛ wo ʋɛ ga ɠizɛsui, wa ma ɠoozunɛɛi wo Ɠɔoɠɔ GALAGI lɛbi vaa ma, é ɠɛ ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Folo lɔfela laawu, wa yɛ ɓului miizu, nii lɛʋɛ la su. Folo mɔungi ma, wa lɛʋɛi ɠula wa-ʋɛlɛiti bu tɛtɛ, mazɔlɔɔ, nu nɔpɛ a ɓului miina, nii lɛʋɛi su, é zo folo mɔungi ma, é li folo lɔfelasiɛi ʋɔ, naa ɓe ka leʋe Izilayɛle ʋa. ");
INSERT INTO tod_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Folo mɔungi, wa gaalɛba ɲadegai wo, dɔfelasiɛi wa gaalɛba ɲadegai wo. Nu nɔpɛ ge la boti nɔpɛ kɛa naama voloiti su. Wa zoo nɔ wo nu ɠilagilagi ná-daamianigi ɓɛtɛ. ");
INSERT INTO tod_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ɓului nii lɛʋɛ la su, wa naama vɛti voloi makɛ, mazɔlɔɔ naama voloi ɓɔɠɔi nɔ ɠa gè wa-nu ɓulugiti kulazu la Ezipete yooi ʋa, wa naama voloi makɛ, é ɠɛ ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Alugi ma mɔungi, ma volo puugɔ maazu naanisiɛi (14) ma ɓɔkɔi, wa ɓuluiti mi nii lɛʋɛ la su, eyɛsu folo ʋuufelegɔ maazu ɠilasiɛi (21) ma ɓɔkɔi. ");
INSERT INTO tod_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Folo lɔfela laawu, lɛʋɛ nɔpɛ ge mina ɠa wa-ʋɛlɛiti bu, mazɔlɔɔ nu nɔpɛ a ɓulu miina lɛʋɛi su, naa ɓe ka leʋe Izilayɛle ʋɛbɛi ʋa, é ɠɛni ga seikɔɠɔma nu ɓaa zou loun. ");
INSERT INTO tod_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","À mina ɓulu mi nii lɛʋɛi su. Adaʋɛti kpein wo zeini náti, wa ɓuluiti mi nii lɛʋɛ la su.› » ");
INSERT INTO tod_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moize Izilayɛle ɠɛwolaiti kpein tolini, é ɠɛ ti ma: «À li, wo baala ziʋoi ɓaa boli yiʋoi ta zeɠe wa-ʋɛlɛyeɠeiti bɛ, wo paa Pakegi vaa zu. ");
INSERT INTO tod_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Wa ɠizɔɔpe tufa ɓifɔgi zeɠe, wo dɔ ɲamai wu, nii é ɠɛɛzu kokoi zu, wa kokoi zu ɲamai ziɛ daamasagiti ma, maazuʋɛ ta kobaʋɛ felegɔiti. Wo tanɔpɛ ge mina ɠula ná-pɛlɛi wu eyɛsu sobui zeeli. ");
INSERT INTO tod_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Siɛgi zu Ɠɔoɠɔ GALAGI ʋaazu ziɛzu la Ezipete yooi zu, ga é paai wo, a ɲamai ɠaana daamasagiti ma, maazuʋɛ ta kobaʋɛ felegɔiti, Ɠɔoɠɔ GALAGI ɠa ɓudɛ kpogi maazuʋɛ, é la ɓega faa zuɠoloɠolo geezuɠeelai ʋa, é ʋa lɛ wa-ʋɛlɛiti bu, é ʋa wo ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Wa niima vai makɛ kpaan ɓɔɠɔ ʋɛ ta wo-lointi bɛ eɠɛ tɔgi eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Siɛgi zu wo lɛɛzu la zooi naa zu, nii Ɠɔoɠɔ GALAGI feezu wo ʋɛ, eɠɛʋelei ná-minazeɠegi la, wa makɛ niima vai ma. ");
INSERT INTO tod_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Siɛgi zu wo-lointi ta ɠɛna la wo ma: ‹Niima vai ʋoluʋɛ ɠa wo ʋɛ ga ɓɛgele?›, ");
INSERT INTO tod_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","wa gooɠaaʋotegi ve, wo ɠɛ ma: ‹Pakegi ma zalaɠai ʋe, Ɠɔoɠɔ GALAGI lɛbi vai ma, nii é ɓudɛni Izilayɛle nuiti ta-ʋɛlɛiti maazu Ezipete yooi zu, siɛgi zu é Ezipete nuiti paani la, é ada-ʋɛlɛiti makɛ.› » Nuɓusɛiti ti maayeini, ti nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Izilayɛle nuiti ti liini, ti naa ɠɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ta Aalɔn ya. ");
INSERT INTO tod_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kua zaamai, Ɠɔoɠɔ GALAGI doun zunu mɔungiti kpein paani Ezipete yooi zu, é zo Ezipete masagi Falaɠɔn ná-doun zunu mɔungi ma, é li kasoɠa nui ʋɔ, naa ná-doun zunu mɔungi, ta toganiiti ti-yiʋo zinɛ mɔungiti kpein. ");
INSERT INTO tod_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Falaɠɔn wuzeɠeni kpidii, tɔ ʋe, ná-botiɠɛ nuiti kpein be, ta Ezipete nuiti kpein. Kpee wolaiti ti looni Ezipete yooi zu ná kpein, mazɔlɔɔ pɛlɛ ɠila kpalaa ge la ɠɛni ná, ʋɛ nu la zaani ná. ");
INSERT INTO tod_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Naama ɓidii nɔ zu, Falaɠɔn Moizeni ta Aalɔn lolini, é ɠɛ ti ma: «À wuzeɠe, wo ɠula nà-nuɓusɛiti saama, wa Izilayɛle nuiti. À li, wo Ɠɔoɠɔ GALAGI lɛbi, eɠɛʋelei wo boni la. ");
INSERT INTO tod_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","À wa-logani goiti seɠe, ta wa-logani wolaiti, eɠɛʋelei wo boni la. À li, à tuya loo nà ɓalaa bɛ̀.» ");
INSERT INTO tod_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ezipete nuiti ti ɠɛni ɓɔizu nuɓusɛiti da, ti ɓalani ga ti ɠula zooi ʋa, mazɔlɔɔ ti ɠɛni ɠɛɛzu ma: «Gi kpein gi undaa ɠana ʋili.» ");
INSERT INTO tod_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Nuɓusɛiti ti liini ga ta-ɓulu vukɔ ɠaayɔgai, nii é la ɠɛni dɛ ɓokoloni. Ti ɓulu vukɔ ɠaayɔ aniɲakaiti maaveleveleni ta-zeɠeiti su, ti ti la ɠɔmaʋɛti. ");
INSERT INTO tod_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Izilayɛle nuiti ti naa ɠɛɛni, nii Moize boni ti ma: Ti wali aniɲakaiti falini Ezipete nuiti ma, ta zanu aniɲakaiti, ta seɠeiti. ");
INSERT INTO tod_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ɠɔoɠɔ GALAGI kɛɛni ɠana eyɛsu nuɓusɛiti ti ɠaazu unfe sɔlɔɔ Ezipete nuiti gaazu. Nii ti falini ti ma, ti naa veeni ti ya. Ti naati kulani Ezipete nuiti zea, ti ti maavo. ");
INSERT INTO tod_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Izilayɛle nuiti ti zeɠeni Lamesɛse, ti li Sukɔte. Zunuiti ti ɠɛni ziɛzu ɠɔɠɔa, naati ti ɠɛni ga nu waaundɔzita (600.000) ɠɛɠala, doungoiti ta anzanuiti ti la naama ɠaalugi zu. ");
INSERT INTO tod_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Nui ma zii laalitaaligi kpein ge ʋilɛni ti ʋolu, toganii wola mɔinni ti ya, ma goiti ta ma wolaiti. ");
INSERT INTO tod_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ti ɓulu ʋɛlɛʋɛlɛgiti mɔni, nii lɛʋɛ la su, ga ɓulu vukɔ ɠaayɔgai, ti zeɠeni la Ezipete yooi zu, é la ɠɛni ɓokoloni, mazɔlɔɔ ti ti ɓɛɛni Ezipete yooi zu, ti la ɓena nɛkɛ, ta ti la ɠɛni zooga daamiani kpɛtɛzu ɓɔɠɔ ʋɛ, nii ta mi ʋelela ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Yeeɠɛɠalai liegɔi Izilayɛle nuiti ti kɛɛni Ezipete yooi zu, naa ɠɛni ga kona unnaanigɔ kona ʋuusaʋagɔ (430). ");
INSERT INTO tod_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kona unnaanigɔ kona ʋuusaʋagɔi (430), naama ɠona pilɛda voloi nɔ ɠa, Ɠɔoɠɔ GALAGI ná-nuɓusɛ ɓulugiti kpein ti ɠulani la Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Yeei Ɠɔoɠɔ GALAGI ti ɠulani la Ezipete yooi ʋa, é ɲiigaazuɠai ɠɛni naama ɓidii. Izilayɛle nuiti ta ti-mavofodaiti kpein ɓalaa, kɛni ti ɲiigaazuɠai ɠɛ naama ɓidii, Ɠɔoɠɔ GALAGI lɛbi vai ma. ");
INSERT INTO tod_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: «Wɛlɛ tɔgi ʋa, Pakegi ma vaa zu: Wɛɛn ɠila kpalaa mina ma anii ta mi. ");
INSERT INTO tod_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Duɔi kpein nii geyaai ga walii, ta tatigai pɛlɛʋolu, toɠa zoo é ta mi. ");
INSERT INTO tod_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Seikɔɠɔma nui ta botiɠɛ nui é zalazu, naati ti mina ta mi. ");
INSERT INTO tod_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Wa mi pɛlɛi nɔ wu. À mina ɠula ga ma zuai tanɔpɛ pɛlɛi ʋa. À mina ma ɠaei tanɔpɛ gale. ");
INSERT INTO tod_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Izilayɛle ʋɛbɛi kpein ka Pake fɛtii ɠula. ");
INSERT INTO tod_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Ni wɛɛin é zeini wo ɠɔɠɔma, naa ɠa pɔ é Pake fɛtii ɠula Ɠɔoɠɔ GALAGI ʋɛ, kɛni zunu kpein é ná-pɛlɛi wu, ti lati pɛlɛʋolu, naazu toɠa ʋa, é fɛtii ɠula. Toɠa ɠɛ naazu eɠɛ zou loun, kɛlɛ tatipɛlɛʋolulala nu nɔpɛ ge mina ta mi. ");
INSERT INTO tod_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Tɔ gilagi naa nɔ ɠa é zeizu zou loin ma, ta seikɔɠɔma nui.» ");
INSERT INTO tod_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Izilayɛle nuiti ti kɛɛni ɠana nɔ, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la Moize ta Aalɔn ya. ");
INSERT INTO tod_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Naama voloi ɓɔɠɔi nɔ ɠa, Ɠɔoɠɔ GALAGI Izilayɛle nuiti kulani la Ezipete yooi ʋa, eɠɛʋelei ti-ma ɓulugiti ti zeini la kpasu ga pagɔ. ");
INSERT INTO tod_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Doun zunu mɔungi kpein fe bɛ̀, niiti ta zɔlɔɔ Izilayɛle nuiti saama, nuɓusɛiti ta toganiiti. Ma mɔungi kpein Izilayɛle nuiti pɔ bɛ, ta ga nɔ̀nɔ.» ");
INSERT INTO tod_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moize ɠɛni nuɓusɛiti ma: «À ɠizɛ naama voloi zu, yeei wo ɠulani la Ezipete yooi ʋa, duɔla ʋɛlɛi wu, mazɔlɔɔ Ɠɔoɠɔ GALAGI ná-zeeɠaaɓaai ɠa é wo ɠulani la. Nu mina ɓului mi nii lɛʋɛi su. ");
INSERT INTO tod_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Wa ɠulazu za Ezipete yooi ʋa, molo ɠulasu alugi ma, wo li. ");
INSERT INTO tod_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Siɛgi zu Ɠɔoɠɔ GALAGI lɛɛzu la ga woye Kanaan nuiti ta-yooi zu, ta Ɠɛte nuiti, ta Amool nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti, nii é ma ɠonai woni wo-mɛmɛwolani bɛ ga é fe wo ʋɛ, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná, wa niima lɛbiyai ve Ɠɔoɠɔ GALAGI ʋɛ, niima alugi ɓɔɠɔi nɔ ma. ");
INSERT INTO tod_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Folo lɔfela laawu, wa ɠɛ ɓuluiti miizu nii lɛʋɛ la su. Folo lɔfelasiɛi ma, fɛtii ɠa ɠɛ Ɠɔoɠɔ GALAGI lɛbi vaa ma. ");
INSERT INTO tod_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Wa ɓuluiti mi folo lɔfela laawu, nii lɛʋɛ la su. Ɓului nii lɛʋɛi su, naa mina ɠa wo-zeizuʋɛ, nu mina lɛʋɛ ɠa wo ʋɔ bɛ wa-yooi ɠa ná pɛ. ");
INSERT INTO tod_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«Naama voloi zu, wa suɠula wo-loun zunui ma ga: ‹Toɠa ga naama vai, nii Ɠɔoɠɔ GALAGI kɛɛni bɛ̀, siɛgi zu gè ɠulani la Ezipete yooi ʋa.› ");
INSERT INTO tod_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Toɠa ɠɛ wo ʋɛ wo-yeei ʋa ga poogi, ta tookisui wo-loʋalaʋɛ, naa ɠa a kɛ Ɠɔoɠɔ GALAGI ná-tɔgi ɠɛ wo-laaʋɛ, mazɔlɔɔ Ɠɔoɠɔ GALAGI wo ɠulaʋɛ Ezipete yooi ʋa ga ná-zeeɠaaɓaai. ");
INSERT INTO tod_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Wa niima levei zo, wo kɛ ma yeeɠɛɠalai ma kona-o-kona. ");
INSERT INTO tod_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Siɛgi zu Ɠɔoɠɔ GALAGI lɛɛzu la ga woye Kanaan nuiti ta-yooi zu, eɠɛʋelei é ma ɠonai woni la wo ʋɛ, ta wo-mɛmɛwolani bɛ, ga toɠa ʋaazu feezu wo ʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","wa doun zunu mɔungi kpein fe Ɠɔoɠɔ GALAGI ʋɛ, anɛɛ toganiiti ti-yiʋoi ma mɔungiti ti sɔlɔɔsu, ma zinɛiti ta ga Ɠɔoɠɔ GALAGI nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Wa soovale ziʋo mɔungi kpein unmɔɔ ga baala ziʋoi. Ni wo la unmɔɔni, wa kɔtɔɠaʋɛ wolo. Wa doun zunu mɔungi kpein unmɔɔ, wo-loun zunuiti saama. ");
INSERT INTO tod_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Siɛgi zu wo-loun zunuiti ti wo ɠaazaɠasu la lina ɠa lina ga: ‹Naa ʋoluʋɛ ɠa ga ɓɛgele?›, wa gooɠaaʋote ga: ‹Ɠɔoɠɔ GALAGI ná-zeeɠaaɓaai maaʋele ɠa é ade ɠulani la Ezipete yooi ʋa, duɔla ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Tɛi Falaɠɔn ɠɛni ɠɛlɛzu ga kikpaai, ga é mina ɓe ade ʋa, de ʋa li, Ɠɔoɠɔ GALAGI doun zunu mɔungi kpein paani Ezipete yooi zu, é zo nuiti ti-loun zunu mɔungiti ma, é li suaiti ti-ma yiʋo zinɛ mɔungiti pɔ. Naa ɠa é kɛɛzu, ade ma zinɛ mɔungiti kpein kulazu la ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ta de doun zunu mɔungiti kpein unmɔɔsu la.› ");
INSERT INTO tod_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Toɠa ɠɛ eɠɛ poogi wo-yeei ʋa, ta wo-loʋalaʋɛ, mazɔlɔɔ Ɠɔoɠɔ GALAGI ade ɠulani Ezipete yooi ʋa ga ná-zeeɠaaɓaai.» ");
INSERT INTO tod_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Siɛgi zu Falaɠɔn ɓeni la nuɓusɛiti ba ga ti li, GALA ge la ɠɛni liini ga tiye Filisiti nuiti ta-yooi zu ʋele, anɛɛ ni naa wola maaɓuɠani, mazɔlɔɔ GALA ge ɠɛni ɠɛɛzu ma: «Nuɓusɛiti ti iɲɔ ka leʋe, ti ɠale ma Ezipete yooi zu, ta ɠɛna kɔɔi ɠaa.» ");
INSERT INTO tod_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kɛlɛ GALA ge ti ɠaaɠaleni ma, é li ga tiye ga teʋebai zu ʋelei, Seeli Kpoloɗɛi ʋɔ pelei. Izilayɛle nuiti ti ɠulani Ezipete yooi ʋa, ti ɠasɔɠiliai ga pagɔ. ");
INSERT INTO tod_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moize Zozɛfe ma ɠaeiti seɠeni ya, mazɔlɔɔ Zozɛfe ɠɛni Izilayɛle ná-doun zunuiti ma: «À ɠonana, wo ɠɛ, GALA ka ʋaazu ɓɔsu wo ʋa, wa lɛ ga mà ɠaeiti ya, wo ti maaɠooza ʋɛ ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ti zeɠeni Sukɔte, ti li, ti ʋu Etame teʋebai laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ɠɔoɠɔ GALAGI ɠɛni liizu ti luɠɔ foloi tonaɓiingi zu, é lo ti luɠɔ pelei zu, ta kpidii é lo ti luɠɔ ga abuzogi, é ti maaɠala, naa ɠa a kɛ ti ziɛ folo ʋɛɛ kpidi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tonaɓiingi la ɠɛni zeɠezu nuɓusɛiti tuɠɔ foloi laawu, abuzogi ɓalaa la ɠɛni zeɠezu ti luɠɔ kpidii laawu. ");
INSERT INTO tod_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ ga ti ɠale ma, ti ʋu Pi-Ɠaɠilɔte ɠakalaʋɛ, Migedɔle ta kpoloɗɛi ti yɔɠɔzuʋɛ, Ɓaale-Sefon letemaʋɛ. Naama adaʋɛ letemaʋɛ ɠa wa ʋu ná, kpoloɗɛi ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Falaɠɔn ɠa ʋaazu ɠɛɛzu ma: ‹Izilayɛle nuiti ti loa ya zooi zu, teʋebai ti maaɓɔlega.› ");
INSERT INTO tod_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Nà Falaɠɔn ɠigi ɓaazu, toɠa ʋaazu ʋilɛsu ti ʋolu, kɛlɛ nà ʋaazu lɛbiyai zɔlɔɔsu ga Falaɠɔn ta ná-kɔɔʋɛbɛi maaʋele. Ezipete nuiti ta suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI.» Izilayɛle nuiti ti kɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","É woni Ezipete masagi ma ga Izilayɛle nuɓusɛiti ti ʋela. Názu ɠa Falaɠɔn ná-kisiɛi ta ná-botiɠɛ nuiti ta-ɠisiɛi latini la, é lo nuɓusɛiti ta-vai ʋa. Ti ɠɛni ma: «Leeni ɠa ade kɛai, ga de ɓe fai Izilayɛle nuɓusɛiti ba, ti li, da-wotiiti ti la mɔ ɠɛa?» ");
INSERT INTO tod_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Falaɠɔn ná-wotoloi ɠɛʋele ɓɛtɛni, é ná-kɔɔʋɛbɛi ʋilɛ ʋolu. ");
INSERT INTO tod_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","É wotolo ɓii gola undɔzita (600) zeɠeni ta Ezipete wotoloiti kpein, kɔɔɠɔ nuiti ti ɠɛni ti zu ga nu zaʋasaʋagi. ");
INSERT INTO tod_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Ɠɔoɠɔ GALAGI Ezipete masagi Falaɠɔn ɠigi ɓaani, Falaɠɔn ʋilɛ Izilayɛle nuiti polu. Izilayɛle nuiti ti ɠulani ga zɛbɛi. ");
INSERT INTO tod_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ezipete nuiti ti ʋilɛni ti ʋolu, sooiti kpein, ta Falaɠɔn ná-wotoloiti, ta ná-soo ɓizɛ zalaʋusuiti, ta ná-kɔɔɓɔgi, ti zeelini ti ma, názu ti ʋuuni kpoloɗɛi ɠobaʋɛ, Pi-Ɠaɠilɔte ʋele, Ɓaale-Sefon letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Falaɠɔn ɠɛni maaɓuɠazu ti ʋa. Izilayɛle nuiti ti ɠaazuwuzeɠeni, wɛlɛ Ezipete nuiti ba, ti ʋaazu ti ʋoluʋelei. Izilayɛle nuiti ti wola luani, ti kpeei looni, ti wooɠula Ɠɔoɠɔ GALAGI ma. ");
INSERT INTO tod_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ti ɠɛni Moize ma: «Kabayeɠea ti la Ezipete yooi zu ɓaa, è ʋaazu ga giye ga gi za teʋebai zu? Lee ɠa è kɛai ga giye, è ɠulazu ga giye Ezipete yooi ʋa? ");
INSERT INTO tod_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Naa laade gi ɓena bo è ma Ezipete yooi zu ɓaa, ga: ‹Gi yɛ ná, gi botii ɠɛ Ezipete nuiti bɛ›? Mazɔlɔɔ fizɔgɛ gi ma ga gi botii ɠɛ Ezipete nuiti bɛ, é leʋe gi zaa vai ʋa teʋebai zu.» ");
INSERT INTO tod_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moize nuɓusɛiti gooɠaaʋoteni, é ɠɛ ti ma: «À mina lua. À yɛ zeini ʋɛ, wo wɛlɛ, ʋelei Ɠɔoɠɔ GALAGI ʋaazu wo ɠizosu la za. Mazɔlɔɔ Ezipete nuiti wo ti ɠaazu za, wo la mɔ ti ɠaa eyɛsu pɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ɠɔoɠɔ GALAGI ɠa kɔɔi ɠɔ wo ʋɛ. Wɔun, à ná lɛi tɔɔn.» ");
INSERT INTO tod_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Lee vaa zu è wooɠulazu mà ga kpeei? Ɓɔɛ Izilayɛle nuiti pɔ, ga ti ɗa nɔ li. ");
INSERT INTO tod_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ɗɔun, ɗa-lukpɔi wuzeɠe, yeemaale kpoloɗɛi ma, è bali su. Izilayɛle nuiti ta lɔɔzu kpoloɗɛi zaamaʋɛ ga ɠɔɠɔa vɔɔi. ");
INSERT INTO tod_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nɔ̀un nà, nà ʋaazu Ezipete nuiti kigi ɓaazu, ga ti ʋilɛ ti ʋolu. Nà ʋaazu lɛbiyai zɔlɔɔsu Falaɠɔn ta ná-kɔɔɓɔgi ná-faa zu, ta ná-wotoloiti, ta ná-soo ɓizɛ zalaʋusuiti. ");
INSERT INTO tod_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ezipete nuiti ta suɠwɛɛ ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, siɛgi zu Falaɠɔn ta ná-wotoloiti ta ná-soo ɓizɛ zalaʋusuiti, ta nà-lɛbiyai ɠulana la kɛlɛma.» ");
INSERT INTO tod_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","GALA ná-geezuɠeelai nii é ɠɛni liizu Izilayɛle ʋɛbɛi luɠɔ, naa leʋeni ga ti ʋoluʋelei. Tonaɓiingi zeɠeni ɓalaa ti ɠakala ʋelei, é li, é lo ti ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","É loni Ezipete nuiti ta-ʋɛbɛi ta Izilayɛle nuiti ta-ʋɛbɛi ti zɔɠɔzuʋɛ. Tonaɓiingi ɠɛni ga kpidi ɓɔii gilazu ʋelei ʋɛ, ta é ɗa wozaɠala kpidii zu zɔɔla ʋelei ʋɛ. Ti la ɠɛni maaɓuɠani ɓɔɠɔ ʋa ɲɛgɛlɛin kpidii. ");
INSERT INTO tod_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Názu ɠa Moize yeemaaleni la kpoloɗɛi ma, Ɠɔoɠɔ GALAGI kpoloɗɛi ɠaaɠaleni ma kpidii ɲɛgɛlɛin ga folo ɠulazu ʋele viilɛi, nii gola yeeɠaaɓaai. É kpoloɗɛi vɔɔni, ziɛi ʋali su. ");
INSERT INTO tod_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Izilayɛle nuiti ti lɔɔni kpoloɗɛi zaamaʋɛ ga ti-ɠɔɠɔa vɔai. Ziɛi ɠaalɛɛni ba, é ɠɛ ga siɠigi ti yeezazuʋɛ ta ti ɠɔʋɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ezipete nuiti ti ʋilɛni ti ʋolu kpoloɗɛi zaamaʋɛ ga Falaɠɔn ná-sooiti kpein, ta ná-wotoloiti, naa ʋɛɛ ná-soo ɓizɛ zalaʋusuiti ba. ");
INSERT INTO tod_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ma ɠeelaalaosuʋɛ sobui, Ɠɔoɠɔ GALAGI yɛni abuzogi ta tonaɓiingi letemaʋɛ, é wɛlɛni Ezipete nuiti ma ɓulugi ʋa, é Ezipete nu ɓulugiti kɛ wuulee. ");
INSERT INTO tod_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","É ta-wotoloiti kɔɠɔiti kulani ba, ti ziɛ vai ɓaa. Ezipete nuiti ti ɠɛni ma naazu: «Ade ʋela Izilayɛle nuiti ba, mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠa kɔɔi ɠɔɔzu ti ʋɛ de laalɔɠɔma.» ");
INSERT INTO tod_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yeei maale kpoloɗɛi ma, ziɛi ɠa ɠaaɠalesu ma Ezipete nuiti ma, ta ta-wotoloiti, ta ta-zoo ɓizɛ nuiti.» ");
INSERT INTO tod_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moize yeemaaleni kpoloɗɛi ma. Sobui zeelizuʋɛ, kpoloɗɛi ʋaani daazuʋɛ ʋolu. Ezipete nuiti ti ɓizɛni maaɓuɠazuʋɛ ti ʋa, kɛlɛ Ɠɔoɠɔ GALAGI Ezipete nuiti tooni kpoloɗɛi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ziɛi ɠaaɠaleni ma, é wotoloiti maaɓɔle, ta soo ɓizɛ zalaʋusuiti, ta Falaɠɔn ná-kɔɔɓɔgi kpein. Niiti ti lɔɔni kpoloɗɛi zaamaʋɛ Izilayɛle nuiti poluʋelei, gila kpalaa ge la ɠɛni ɠulani. ");
INSERT INTO tod_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kɛlɛ Izilayɛle nuiti ti ziɛni ga ɠɔɠɔa vɔɔiti kpoloɗɛi zaamaʋɛ. Ziɛi ɠaalɛɛni ba eɠɛ siɠigi, ti yeezazuʋɛ ta ti ɠɔʋɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Naama voloi Ɠɔoɠɔ GALAGI Izilayɛle ɠizoni, é kula Ezipete nuiti zea. Izilayɛle Ezipete nuiti ma ʋoomaiti kaani laani kpoloɗɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Izilayɛle Ɠɔoɠɔ GALAGI ná-zeeɠaaɓaai ɠaani, é kɛɛni Ezipete nuiti daalɔɠɔma. Nuɓusɛiti ti luani Ɠɔoɠɔ GALAGI ʋa. Ti ɠidaaleʋeni Ɠɔoɠɔ GALAGI ma, ta ná-botiɠɛ nui Moize. ");
INSERT INTO tod_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Názuʋɛ, Moize ta Izilayɛle nuiti ti niima wuyei looni Ɠɔoɠɔ GALAGI ʋɛ, ti ɠɛ ma: «Nà guyei loozu Ɠɔoɠɔ GALAGI ʋɛ, mazɔlɔɔ é ná-fɔnifaamai ɠulaʋɛ kɛlɛma, é sooi ta kpizɛ nui ʋiliga kpoloɗɛi wu. ");
INSERT INTO tod_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ɠɔoɠɔ GALAGI ɠa ga sùvikɛi ta nà-maamusɛ wuyeiti ma ungi, tɔ ɠa é ga nà-kizogi. Toɠa ga nà-GALAGI, nà bɔɔlɔ. Toɠa ga kɛ̀ɛ ná-GALAGI, nà maamusɛzu. ");
INSERT INTO tod_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ɠɔoɠɔ GALAGI ɠa ga kɔɔɠuluɓai. Daaseigi ɠa ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","É Falaɠɔn ná-wotoloiti ta ná-kɔɔɓɔgi ʋiliga kpoloɗɛi wu, ná-kɔɔɠuluɓa ɠɛzɛiti maaɓɔlega Seeli Kpoloɗɛi wu. ");
INSERT INTO tod_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ziɛ lakpatakpagiti ti ti maaɓɔleni, ti yeini ziɛi ɓomaʋɛti eɠɛ kɔtui. ");
INSERT INTO tod_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ee, Ɠɔoɠɔ GALAGI, è-yeezai maayikiʋɛ ga suvikɛi. Ee, Ɠɔoɠɔ GALAGI, è-yeezai ɠa é è zili nui ɠaayɔni. ");
INSERT INTO tod_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ee, è ɠaazu unfegi wɔɔlɔʋɛ! Ɗa naati tokasu, niiti ti wuzeɠezu è laalɔɠɔma, ɗa yeeɓesu ɗa-yiiɠaawana wolai ʋa, é ti ɠala eɠɛ kpakui. ");
INSERT INTO tod_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ziɛi ma ziɠigiti ti loni ga è-zokpa zu viilɛiti maaʋele. Ziɛi ɠaalɛɛni ba eɠɛ siɠigi, paliiti ti ɓaani kpe kpoloɗɛi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Sili nui ɠɛni ɠɛɛzu ma: ‹Nà ʋilɛ ti ʋolu, gè ti zo. Nà ta-naavoloi ɠaaɠwɛ, gè ta mi. Nà boɠa zɔkpɔi mɛɛn, gè yeei ʋɛɛ ti ma.› ");
INSERT INTO tod_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","È laavuuvuuni, kpoloɗɛi ti maaɓɔleni. Ti ɠɛni loozu eɠɛ kena kpui ziɛi wu, ti wola yeeɠaaɓaai. ");
INSERT INTO tod_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ee, Ɠɔoɠɔ GALAGI, ɓɛ ɠa é ga è ɠɛʋele galagiti saama? Ɓɛ ɠa é ga è ɠɛʋele, maayikiai ɲadedai zu, ɠaazu unfegi bɛ, maamusɛi zoloogai ma, é laavɔɔ vaiti kɛɛzu? ");
INSERT INTO tod_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","È yeezai maaleni nɔ, zooi gi ɓɛɛ nuiti kpɔle. ");
INSERT INTO tod_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nuɓusɛiti é ti unmɔɔni, è loni naati tuɠɔ ga ɗa-wooɠɛɠiladai, ɗa losu ti luɠɔ ga è-zuvikɛi, è li ga tiye è-zeizu ɲadegai. ");
INSERT INTO tod_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nuɓusɛiti ti mɛnini, ti zuɓali, dualuagi Filisiti nuiti soga. ");
INSERT INTO tod_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔme ɠundiɠiiti sasu ɠa ɓalizu, sasuɓalii Moaɓe ɠɔɔɠuluɓaiti soni, Kanaan zei wo nuiti dɔtɔzuleʋea. ");
INSERT INTO tod_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Maalua vai ta dualuagiti ta zeeli ti ma. È-yeelokoi ná-bɔɔlɔi maaʋele ma, ta ɠɛɛzu ga ɓoɓoiti eɠɛ kɔtui, ee, Ɠɔoɠɔ GALAGI, eyɛsu ɗa-nuɓusɛiti ti leʋe, ɗa-nuɓusɛiti è ti ɠeyaai. ");
INSERT INTO tod_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ɗa liizu ga tiye, è ti zei ɗa-ɠizei ma, ee, Ɠɔoɠɔ GALAGI, adaʋɛ è ná ɓɛtɛa ga è-zeizuʋɛ, ee, Maliɠii, seizu ɲadegai, nii è-yeeiti ti kpɛtɛni. ");
INSERT INTO tod_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ɠɔoɠɔ GALAGI ɠa masadai ɠɛɛzu eyɛsu ɠɔ.» ");
INSERT INTO tod_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Mazɔlɔɔ Falaɠɔn ná-sooiti, ta ná-wotoloiti ta ná-soo ɓizɛ zalaʋusuiti ti lɔɔni kpoloɗɛi zaamaʋɛ. Ɠɔoɠɔ GALAGI kpoloɗɛi ɠaaɠale ma ti ma, kɛlɛ Izilayɛle nuiti ti ziɛni ga ɠɔɠɔa vɔɔi kpoloɗɛi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miliyame é ga GALA goo wo anzanui, Aalɔn baazeelai, tamadegi zeɠeni. Anzanuiti kpein ti ʋilɛni polu ga tamadegiti, ti ɗa kuai wo. ");
INSERT INTO tod_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miliyame ɠɛni guyei laazosu, é ɗa ɠɛ ma: «À guyei loo Ɠɔoɠɔ GALAGI ʋɛ, mazɔlɔɔ é ná-bɔɔlɔlai ɠula kɛlɛma, é sooi ta kpizɛ nui ʋiliga kpoloɗɛi wu.» ");
INSERT INTO tod_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moize liini ga Izilayɛle nuiti, ti zeɠe Seeli Kpoloɗɛi ʋɔ bɛ. Ti Suul teʋebai zu ʋelei zeɠeni, ti ziɛni teʋebai zu ga folo saʋagɔ, ti la ɠɛni ziɛ ɠaani ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ti zeelini Mala, kɛlɛ ti la ɠɛni zooni, ti ʋa Mala ɗɛi ta ɓɔle, tɔɔzei é wanani. Naa ɠa é kɛɛni, naama laaseigi ʋɛɛni ba ga Mala (nii poluʋɛ ga «wanaʋɛ»). ");
INSERT INTO tod_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Nuɓusɛiti ti zelii loni Moize ma, ti ɠɛ ma: «Leeni ɠa gá kpɔle?» ");
INSERT INTO tod_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moize wooɠulani Ɠɔoɠɔ GALAGI ma. Ɠɔoɠɔ GALAGI gului ta lɛɛni la. É ma ɓuɠai ta ʋilini ziɛi wu, ziɛi nɛɛni. Miná ɠa Ɠɔoɠɔ GALAGI tɔgiti ta deveiti feeni ná-nuɓusɛiti zea ná. Miná ɠa é ti ʋoluɠulani ná. ");
INSERT INTO tod_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","É ɠɛni ma: «Ni wa woilona gòo ma ga pagɔ, nɛ̀i gè ga Ɠɔoɠɔ GALAGI wa-ƓALAGI, ni wa naa ɠɛɛna, nii sɔlegai gàazu, ni wa woilona nà-deveiti ma, ta ni wa nà-tɔgiti kpein sona, gè la seeɓɛiti taɠila kpalaa pɛa wo ʋa, nii gè pɛɛni Ezipete nuiti ba, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é wo ɠɛdɛsu.» ");
INSERT INTO tod_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ti zeelini Elime, ʋɛ ziɛun puugɔ maazu felegɔ (12) ɠɛni ná, ta dɔɔ wulu ʋuulɔfela (70). Ti ʋuuni miná ziɛlaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Izilayɛle ʋɛbɛi kpein ge zeɠeni Elime, ti li, ti zeeli Sin teʋebai zu, nii é Elime ta Sinayi ti yɔɠɔzuʋɛ, folo puugɔ maazu lɔɔlusiɛi (15) ma, alugi velesiɛi ma, ti ɠulaai ma Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Izilayɛle ʋɛbɛi kpein ge zelii loni Moize ta Aalɔn ma teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Izilayɛle nuiti ti ɠɛni ti ma: «Leeni vaa zu gi la zaani Ɠɔoɠɔ GALAGI yeezu Ezipete yooi zu, siɛgi zu gi ɠɛni la sua liɠiiti koba, siɛgi zu gi ɠɛni la ɓului miizu, gi yiɠo kpe? Kɛlɛ wo ʋaaʋɛ ga giye teʋebai niizu ga wo bɛbɛi nii kpein paa ga pului.» ");
INSERT INTO tod_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nà ʋaazu ɓului ʋuuzu, é zeɠe geezuʋɛ. Nuɓusɛiti ta ʋaazu ɠulazu, ti ɗa zɛʋɛ folo-o-folo nii liegɔi a kula ɠɛ, naa ɠa a kɛ gè ti ʋoluɠula, gè pɛtɛ ni ta ziɛ ga nà-tɔgi, ɓaa ni ti la ziaa la. ");
INSERT INTO tod_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Folo lɔzitasiɛi, siɛgi zu ti naa ɠɛʋele ɓɛtɛzu la, nii ti ʋaazu la, nii ta ɗa zɛʋɛ folo-o-folo, toɠa ɠɛ ga ná zeizu felegɔi.» ");
INSERT INTO tod_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moize ta Aalɔn ti ɠɛni Izilayɛle nuiti ma: «Za kpɔkɔi, wa ʋaazu kwɛɛsu ga Ɠɔoɠɔ GALAGI ɠa é wo ɠula Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Sobu, wa Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠa, tɔɔzei é wa-yelilomaiti mɛnigɛ, wo kɛai Ɠɔoɠɔ GALAGI laalɔɠɔma. Mazɔlɔɔ gá ga leeni, wo zelii losu gi ma?» ");
INSERT INTO tod_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moize ɠɛni ma: «Ɠɔoɠɔ GALAGI ɠa suai veezu wo ya za kpɔkɔi, wo mi, sobui é ɓului ve wo ya, wo mi, wo yiɠo. Ɠɔoɠɔ GALAGI zelilomaiti mɛnigɛ, wo ti ɠɛai daalɔɠɔma, mazɔlɔɔ gá ga ɓɛgele? Giya lɛi wa-yelilomaiti ti ʋa ɠɛ ɠɛɛzu gi laalɔɠɔma, Ɠɔoɠɔ GALAGI ɠa ti ɠɛɛzu daalɔɠɔma.» ");
INSERT INTO tod_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moize ɠɛni Aalɔn ma: «Bo Izilayɛle ʋɛbɛi ma, ga ti maaɓuɠa Ɠɔoɠɔ GALAGI ʋa, mazɔlɔɔ é ta-yelilomaiti mɛnigɛ.» ");
INSERT INTO tod_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Siɛgi zu Aalɔn ɠɛni ɓɔɛzu la Izilayɛle ʋɛbɛi kpein pɔ, ti ɠaaʋoteni ga teʋebai ʋɔ pelei, pɛtɛ, Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani kɛlɛma tonaɓiingi zu. ");
INSERT INTO tod_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Gè Izilayɛle nuiti ta-yelilomaiti mɛnigɛ. Ɠɛ ti ma: ‹Kpɔkɔi wa suai miizu, sobui wa yiɠo ga ɓului, wa suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.› » ");
INSERT INTO tod_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kpɔkɔi, wɔniiti ti ʋaani, ti-ma zii ɠɛai eɠɛ kakalogi, ti ti-ʋuuzuʋɛ maaɓidi. Sobui, nɔɗagi ɠɛni ʋɛɛni ti-ʋuuzuʋɛ maaɠoolii zu. ");
INSERT INTO tod_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Siɛgi zu naama nɔɗagi ɲɛɛlɛni la, ani goi ta ɠɛni teʋebai zu eɠɛ ani waa, eɠɛ kobe kolegi ma ɓuun goiti, é zooi ma. ");
INSERT INTO tod_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Izilayɛle nuiti ti wɛlɛni ba, ti ɠɛ ɓɔɠɔ ma ti ɠilagilagi: «Leeni ɠa ga nii?» Mazɔlɔɔ ti la ɠɛni kwɛɛ, nii é ɠɛni de. Moize ɠɛni ti ma: «Ɓului ʋe Ɠɔoɠɔ GALAGI fea wo ya ga daamianigi. ");
INSERT INTO tod_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Pɛtɛ nii Ɠɔoɠɔ GALAGI deveai: Ɛsɛ gilagilagi naa yɛʋɛ, nii a zoloo ga ná-daamianigi, kɔɠɔ ganii ɲɛ gila nu ɠila, eɠɛʋelei wa-nuiti tiegɔi la. Ɛsɛ ge ta zeɠe naati bɛ, niiti ti ná-seɠe ɠotai wu.» ");
INSERT INTO tod_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Izilayɛle nuiti ti kɛɛni ɠana. Tanigaa ti zɛʋɛni ga gola, tanigaa ma ti zɛʋɛ ga tago. ");
INSERT INTO tod_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ti ɠɛni kɔɠɔsu kɔɠɔ gani zu, zɔi é ɠɛni zɛʋɛzu ga mɔinɗa, é la ɠɛni ʋooʋazu naa ya, zɔi ma é ɠɛni tago nɔ yɛʋɛzu, naa la ɠɛni ʋalasu. Ɛsɛ ge ɠɛni zɛʋɛzu, é zoloo nɔ ná-daamianigi ma. ");
INSERT INTO tod_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moize ɠɛni ti ma: «Nu nɔpɛ ge mina ta yɛ ná, é ʋa yɛsu sobui.» ");
INSERT INTO tod_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Nui tanigaani ti la ɠɛni woiloni Moize woo ma, ti ta yɛni ná eyɛsu sobui. Kɛlɛ koegiti ti ʋuuni su, naa makugi ɠulani. Moize yiiɠaawanani naama nuiti ma. ");
INSERT INTO tod_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Sobu ɠilagila, ɛsɛ ge ɠɛni naa yɛʋɛzu, nii a zoloo ga ná-daamianigi. Siɛgi zu foloi ma liegi a la ʋaana la, gaa ɠɛni wuunsu. ");
INSERT INTO tod_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Foloi lɔzitasiɛi, ti ɠɛni daamianigi zeizu felegɔi yɛʋɛzu, wɔmɛɛl zu felegɔ nu ɠila. Bɛbɛi ma ɠundiɠiiti kpein ti ʋaani, ti suɠula Moize ma. ");
INSERT INTO tod_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moize ɠɛni ti ma: «Naa ɠa Ɠɔoɠɔ GALAGI bogai, lina ɠa ga dooɠo folo ɲadegai Ɠɔoɠɔ GALAGI ʋɛ. À naa mɔ, nii é wo ya ga wo mɔ. À naa ɓɔlɔ, nii é wo ya ga wo kpɔlɔ, mɔtai nii kpein é yɛsu, wo naa makɛ eyɛsu sobu.» ");
INSERT INTO tod_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ti zɛni ná eyɛsu sobui, eɠɛʋelei Moize devei veeni la. Naa maku ge la ɠɛni ɠulani, ta koegaa ti la ɠɛni ʋuuni su ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moize ɠɛni ma: «À mi za, mazɔlɔɔ dooɠo foloi ʋe Ɠɔoɠɔ GALAGI ʋɛ. Za, wo la ta ɠaa adaʋɛ tanɔpɛ eteaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Folo lɔzita laawu, wa ɠɛ zɛʋɛzu, kɛlɛ foloi lɔfelasiɛi ɠa ga dooɠo foloi, ta la ɠɛa ná, naama yeei.» ");
INSERT INTO tod_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Foloi lɔfelasiɛi ma, nuɓusɛi tanigaani ti ɠulani ga ti ta yɛʋɛ, kɛlɛ ti la ɠɛni ta ɠaani. ");
INSERT INTO tod_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Názu ɠa Ɠɔoɠɔ GALAGI ɠɛni la Moize ma: «Eyɛsu siɛ kpɛgele zu ɠa wo yɛsu ɠɛlɛzu la nà-deveiti ta nà-tɔgiti so fai ʋa? ");
INSERT INTO tod_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","À kwɛɛ ga Ɠɔoɠɔ GALAGI dooɠo foloi veeʋɛ wo ya, naa ɠa é ba, folo lɔzitasiɛi ma, toɠa folo felegɔ laamianigi veezu wo ya. Ɛsɛ ge yɛ zeizuʋɛ, nu mina zeɠe zeizuʋɛ folo lɔfelasiɛi ma.» ");
INSERT INTO tod_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Nuɓusɛiti ti dooɠo foloi maaɲɛɛni, ti looɠo folo lɔfelasiɛi ma. ");
INSERT INTO tod_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Izilayɛle ʋɛlɛyeɠei naama laamianigi laaseigi ʋɛɛni ga manegi. É ɠulani ga kɔliandelegi ma ɠaei, é ɠoleni, é nɛɛ ga gatoi ɠɛʋelei, nii kɔin gulɔi ba. ");
INSERT INTO tod_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moize ɠɛni ma: «Wɛlɛ nii Ɠɔoɠɔ GALAGI devea: À kɔɠɔ ganii zu ɠila makɛ manegi zu, wo-mavofodaiti bɛ, lina ɠa lina, naa ɠa a kɛ ti ɓului ɠa, nii gè feeni wo ya, wo mi teʋebai zu, siɛgi zu wo ɠulani la Ezipete yooi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moize ɠɛni Aalɔn ma: «Diɠii zeɠe, è kɔɠɔ ganii ɲɛ ɠila pu su manegi zu, è sei Ɠɔoɠɔ GALAGI ɠaazu, naa ɠa a kɛ é makɛ wo-mavofodaiti bɛ lina ɠa lina.» ");
INSERT INTO tod_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Eɠɛʋelei devei la, Ɠɔoɠɔ GALAGI feeni Moize ya, Aalɔn seini zeele woo zɛʋɛi ma ɠesui ɠakalaʋɛ, naa ɠa a kɛ, é makɛ. ");
INSERT INTO tod_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Izilayɛle nuiti ti manegi miini kona ʋuunaanigɔ (40) laawu, eyɛsu ti zeeli zooi naa zu, ʋɛ nua ti ɠɛni zeini ná. Ti manegi miini, eyɛsu ti zeeli Kanaan yooi ɠwɛgi ma. ");
INSERT INTO tod_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Nu ɠilagilagi ɠɔnɔgi ɠɛni ga kɔɠɔ ganii zu ɠila. Kɔɠɔ ganii nii daaseigi ga wɔmɛɛlegi, naa ɠa ga efagi ma ɠaaɠwɛsu puugɔi.) ");
INSERT INTO tod_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Izilayɛle ʋɛbɛi kpein ge zeɠeni Sin teʋebai zu, eɠɛʋelei Ɠɔoɠɔ GALAGI ná-devei ɠɛni la, é ʋilɛ ta-ziɛ vai ʋa, ti liini, ti ʋu Lefidime. Ʋɛ nuɓusɛiti ti la ɠɛni ziɛ zɔlɔɔni ná, ti ʋa ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Názu ɠa nuɓusɛiti ti wuzeɠeni la Moize laalɔɠɔma. Ti ɠɛ ma: «À ziɛi ve gi ya, gi ɓɔɔle.» Moize ti wooɠaaʋoteni, é ɠɛ ti ma: «Leeni vaa zu wo wuzeɠezu dàalɔɠɔma? Leeni vaa zu wo Ɠɔoɠɔ GALAGI zuɠɔɠɔsu?» ");
INSERT INTO tod_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Nuɓusɛiti ti ɠɛni ná, kpɔɔle wɔin ɗa ɓɔi ti la, ti ɗa zelii lo Moize ma. Ti ɠɛni ɠɛɛzu ma: «Lee vaa zu è gi ɠulaai Ezipete yooi ʋa, ga è gi ʋaa ga kpɔɔle wɔin, giya-o, gi-lointi-yo, ta gá-loganiiti-yo?» ");
INSERT INTO tod_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moize wooɠulani Ɠɔoɠɔ GALAGI ma, é ɠɛ ma: «Leeni ɠa nà kɛ, é lo niima nuɓusɛiti ba? Ná tago nɔ ʋe, ti ʋa ti sɔ̀ɔ ga kɔtui.» ");
INSERT INTO tod_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Leʋe nuɓusɛiti kakala ʋelei, è Izilayɛle ɠɛwolai tanigaani seɠe, ɗa-lukpɔi ɓalaa seɠe, nii è ziɛ wolai Nile loɠani la, è li luɠɔʋelei. ");
INSERT INTO tod_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Wɛlɛ, nà liizu, gè lo è luɠɔ Wolɛɓe ɠɔtui ma, ɗa kɔtui loɠa, ziɛi ɠa ɠula ba, nuɓusɛiti ta ɓɔɔle.» Zekana Moize kɛɛni la, Izilayɛle ɠɛwolaiti gaazu. ");
INSERT INTO tod_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","É naama adaʋɛ laasei pɛɛni ga Masa ta Meliɓa (niiti ti-ʋoluʋɛti ga «suɠɔɠɔgi» ta «maaɠaalii»), tɔɔzei Izilayɛle nuiti ti maaɠaalii ɠɛɛni ná, ti Ɠɔoɠɔ GALAGI zuɠɔɠɔ, ti ɗa ɠɛ ma: «Ɠɔoɠɔ GALAGI ɠa ade zaama nɛi, ɓaa é la ná?» ");
INSERT INTO tod_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalɛke nuiti ti ʋaani, ti kɔɔi ʋɛɛ Izilayɛle nuiti ba Lefidime. ");
INSERT INTO tod_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moize ɠɛni Zozuwe ma: «Yiimazeɠe ga zunui tanigaa ade ʋɛ, wo li, wo vala Amalɛke nuiti ba. Lina, nà liizu, gè lo gize unmaʋɛ, GALA ná-tukpɔi zoni zèa.» ");
INSERT INTO tod_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Zozuwe naa ɠɛɛni, nii Moize boni ma, ga é Amalɛke zakpe. Moize ʋɛɛ Aalɔn ʋa, ta Ɠuul ti lɛɛni gizei unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Siɛgi zu Moize a la yeei wuzeɠena la, Izilayɛle ɠɛni pilɛ sɔlɔɔsu, kɛlɛ siɛgi zu a la yeei yeina la, Amalɛke ɠɛni pilɛ sɔlɔɔsu. ");
INSERT INTO tod_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Tɛi Moize yeeiti suɓɔlɔni, ti kɔtui zeɠeni, ti da bu, é zei maazu. Aalɔn ta Ɠuul ti zeeiti soni, gilagi lo kakamaʋɛ, zɔi lo zɔɔla ʋelei, zeeiti maalegai yɛni de kpaan eyɛsu foloi da. ");
INSERT INTO tod_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Zozuwe pilɛ sɔlɔɔni Amalɛke ma ta ná-nuɓusɛiti, ga boɠa zɔkpɔ ɠaaligi. ");
INSERT INTO tod_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Niima vaiti sɛʋɛ sɛʋɛi zu, é ɠɛ ga ɠizɛsu vaa, è bo Zozuwe ma ga, nà Amalɛke ma zuwui ɠaaleʋezu geeɠɔlɔgi wu, nu la mɔ ɠisiaa ti zu.» ");
INSERT INTO tod_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moize zalaɠa ɠulazuʋɛ ta loni, é daasei pɛɛni ga: «Ɠɔoɠɔ GALAGI ɠa ga nà-ɗalapoi». ");
INSERT INTO tod_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","É ɠɛni ma: «Tɔɔzei nui ta yeei wuzeɠea Ɠɔoɠɔ GALAGI ná-masa kpɔkpɔgi laalɔɠɔma, Ɠɔoɠɔ GALAGI ná-kɔɔi ɠa ɠɛ Amalɛke laalɔɠɔma, yeeɠɛɠalaiti pɛ su.» ");
INSERT INTO tod_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Moize nɛkoi Zetelo, Madiyan zalaɠa ɠula nui, naa kpein mɛnini, nii GALA ge kɛɛni Moize ʋɛ ta ná-nuɓusɛi Izilayɛle nuiti, naa ɠa é ɠɛni ga Ɠɔoɠɔ GALAGI Izilayɛle nuiti kula vai Ezipete ʋa. ");
INSERT INTO tod_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Moize nɛkoi Zetelo Moize anzai Sefola zeɠeni, nii Moize yeeɓeni ba, é li kɛɛɠɛ ʋɔ bɛ ʋolu, ");
INSERT INTO tod_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ta ná-doun zunu felegɔiti ɓalaa, gilagi laaseigi ɠɛni ga Gɛɛlɛsome (nii poluʋɛ ga «seikɔɠɔmai»), mazɔlɔɔ Moize ɠɛni ma: «Nà ga seikɔɠɔma nui, gè zeini zou ɠili su.» ");
INSERT INTO tod_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Zɔi laaseigi ɠɛni ga Eliyezɛɛl (nii poluʋɛ ga «nà-GALAGI ɓɔgɛ bà»), mazɔlɔɔ é ɠɛni ma: «Kɛ̀ɛ ná-GALAGI ɓɔgɛ bà, é ùnmɔɔ, é kùla Falaɠɔn ná-boɠa zɔkpɔi ya.» ");
INSERT INTO tod_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Moize nɛkoi Zetelo liini teʋebai zu ga Moize ná-doun zunuiti ta anzai, ʋɛ é ɠɛni ʋuuni ná, GALA ná-gizei ɠoba. ");
INSERT INTO tod_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","É wooleʋeni Moize ma, é ɠɛ ma: «Nɔ̀un nà, è-nɛkoi Zetelo, pàaʋɛ è ʋɔ bɛ, ga è-anzai, é ʋɛɛ ná-doun zunu felegɔiti ba.» ");
INSERT INTO tod_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moize ɠulani é nɛkoi laaɠomi, é nɔkɔ bu, é nɛɛnɛ ga daaʋɛ komagai. Ti ɓɔɠɔ ɠaazaɠani ta-ɠɛdɛyaiti ma vaa ma, naa ʋolu ti lɛɛni Moize ná-seɠe ɠotai wu. ");
INSERT INTO tod_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moize naa kpein suɠulani nɛkoi ma, nii Ɠɔoɠɔ GALAGI kɛɛni ga Falaɠɔn ta Ezipete yooi Izilayɛle ná-faa zu, kpɔlɔiti kpein ti zeelini ti ma pelei zu, ta ʋelei Ɠɔoɠɔ GALAGI ti ɠulani la ti zu. ");
INSERT INTO tod_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Zetelo ɠoozunɛɛni faa ʋagɔi kpein ma vaa zu Ɠɔoɠɔ GALAGI kɛɛni Izilayɛle nuiti bɛ, ta eɠɛʋelei é ti unmɔɔni la, é ti ɠula Ezipete nuiti zea. ");
INSERT INTO tod_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Zetelo ɠɛni ma: «Mamagi ɠa Ɠɔoɠɔ GALAGI ʋɛ, nii é wo ɠula Ezipete nuiti zea, ta Falaɠɔn ya, nii é nuɓusɛiti kula Ezipete nuiti ta-zobogi ya! ");
INSERT INTO tod_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Gè kwɛɛga niizu ga Ɠɔoɠɔ GALAGI wɔɔlɔʋɛ, é leʋe galagiti kpein ba, é naa ɠulani kɛlɛma, siɛgi zu Ezipete nuiti ti ɠɛni gaazumaavɔɔ vaiti kɛɛzu la ga Izilayɛle nuiti.» ");
INSERT INTO tod_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Moize nɛkoi Zetelo gala zalaɠai ta zalaɠaiti kulani GALA bɛ. Aalɔn ta Izilayɛle ɠɛwolaiti kpein ti naama laamii woni ʋɔɔma ta Moize nɛkoi, GALA gaazu. ");
INSERT INTO tod_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Poluma zobui, Moize zeini ga é nuɓusɛiti ta-lukpɔiti gaaleʋe. Nuɓusɛiti ti loni Moize ɠakala, é zo sobui ma, eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Nii kpein Moize kɛɛni nuɓusɛiti bɛ, nɛkoi naa ɠaani, é ɠɛ ma: «Lee ɠa è kɛɛzu niima nuɓusɛiti bɛ? Lee vaa zu è zeizu ɗa ɠila, nuɓusɛiti kpein ti loni è ɠakala, é zo sobui ma, eyɛsu kpɔkɔi zeeli?» ");
INSERT INTO tod_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moize nɛkoi wooɠaaʋoteni, é ɠɛ ma: «Toɠa ga nuɓusɛiti ka ti ʋaazu pɔ̀ ga ti GALA gaazaɠa. ");
INSERT INTO tod_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Siɛgi zu fai ta ɠɛɛzu la ti ya, ta ʋaazu pɔ̀, gè tukpɔi ɠaaleʋe ti yɔɠɔzu, gè GALA ná-deveiti ta ná-tɔgiti dɛɛ.» ");
INSERT INTO tod_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Moize nɛkoi ɠɛni ma: «Nii è kɛɛzu, naa la ʋani. ");
INSERT INTO tod_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ɗa ɓɔɠɔ suvikɛi ɓesu fala, ta niima nuɓusɛi ɓalaa é è ʋa, mazɔlɔɔ fai nii wuiʋɛ è-zɛbɛi ma. Ɗa ɠila è la zooga è ʋa kɛ. ");
INSERT INTO tod_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Niizu, woilona gòoi ma, nà è lɛnɛsu, GALA ge ɠɛ è ʋa! Ɠɛ ga nuɓusɛiti gaazuʋɛ GALA koba, ɗa ɓɔɠɔi è li ga nuɓusɛiti ta-vaiti GALA pɔ. ");
INSERT INTO tod_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Deveiti ta tɔgiti gaalɛ ga tiye, pelei lɛ ga tiye, nii maanɛai ti ʋilɛ ba, ta kɛɛwotii nii maanɛai ti kɛ. ");
INSERT INTO tod_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Yiimazeɠe ga sɔɓelama zunuiti nuɓusɛiti kpein saama, ti luazu GALA ba, zunuiti ti ɠiliai gaamai ʋa, ti lobɛanii wɔinzeɠezu, è ti zeɠe, è ti zei nuɓusɛiti unda ga nu waagilagila kundiɠiiti, nu ungilagila kundiɠiiti, nu ʋuulɔɔludɔɔlu kundiɠiiti, ta nu ʋuupuu kundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Ti ɗa nuɓusɛiti ta-lukpɔi ɠaaleʋe siɛnɔpɛ, ti ʋa ga faa ɓiigiti è ʋɔ, tiya ɓɔɠɔiti ti faa goiti ma lukpɔi ɠaaleʋe. Ta ɠula ɗa-ɠasɔi ma, wo seɠe ʋɔɔma. ");
INSERT INTO tod_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ni ɗa naa ɠɛɛna, GALA ge deveiti fe è ya, ɗa zoo è ziɛ bu ga pagɔ, niima nuɓusɛiti kpein ta zeeli ziilɛigi zu ti ʋɔ bɛ.» ");
INSERT INTO tod_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moize woiloni nɛkoi wooi ma, é naa kpein kɛɛni, nii naa boni ma. ");
INSERT INTO tod_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moize yiimazeɠe ga sɔɓelama zunuiti, Izilayɛle nuiti kpein saama, é ti zei nuɓusɛiti unda ga nu waagilagila kundiɠiiti, nu ungilagila kundiɠiiti, nu ʋuulɔɔludɔɔlu kundiɠiiti, ta nu ʋuupuu kundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ti ɠɛni nuɓusɛiti ta-lukpɔiti gaaleʋezu siɛnɔpɛ, ti ɠɛni ʋaazu ga faa ɓii golaiti Moize ʋɔ bɛ, tiya ɓɔɠɔi ti ɓena fai mɔtaiti ma lukpɔi ɠaaleʋe. ");
INSERT INTO tod_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moize ɓeni nɛkoi ʋa, é li, naa liini ná-zooi zu. ");
INSERT INTO tod_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Alugi zaʋasiɛi ma, ti ɠula ʋoluma Ezipete yooi ʋa, Izilayɛle nuiti ti zeelini Sinayi teʋebai zu naama voloi. ");
INSERT INTO tod_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Ti zeɠeni Lefidime, ti liini, ti zeeli Sinayi teʋebai zu, ti ʋuuni teʋebai zu. Izilayɛle ʋuuni miná, gizei ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moize lɛɛni GALA pɔ pelei, Ɠɔoɠɔ GALAGI tolini gizei unmaʋɛ, é ɠɛ ma: «Wɛlɛ, nii ɠa ɗa bo Zakɔɓe ná-pɛlɛyeɠei ma, è daazeeli Izilayɛle nuiti ma: ");
INSERT INTO tod_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Wa ɓɔɠɔgoi wo naa ɠaani, nii gè kɛɛni ga Ezipete nuiti, gè wo zeɠeni koɠɛ ɠoʋegiti su, gè ʋa ga woye pɔ̀ pelei. ");
INSERT INTO tod_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Niizu, ni wa woilona gòoi ma, ni wa makɛna nà-minazeɠegi ma, wa ɠɛ ga nɔ̀nɔ ɠiteɠitegiti, nuɓusɛiti kpein saama. Anɛɛ ni eteai kpein ka ga nɔ̀nɔ, ");
INSERT INTO tod_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","wɔun wa, wa ɠɛ bɛ̀ ga zalaɠa ɠula zii, nii ɲadegai.› Wooiti kana ɗa ti wo Izilayɛle nuiti ma.» ");
INSERT INTO tod_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moize liini, é nuɓusɛiti ta-ɠɛwolaiti toli, é wooi nii kpein daani ti ʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Nuɓusɛiti kpein ti zolooni faa ɠila ma, ti ɠɛ ma: «Gá naa kpein kɛ, nii Ɠɔoɠɔ GALAGI bogai.» Moize nuɓusɛiti gooi laazeelini Ɠɔoɠɔ GALAGI ma. ");
INSERT INTO tod_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Wɛlɛ, nà ʋaazu è ʋɔ tonaɓiin gaaɠiligi zu, naa ɠa a kɛ, siɛgi zu gè ɓɔɛzu la è ʋɔ, nuɓusɛiti ti mɛni, ti la è la ɠɔ.» Moize nuɓusɛiti gooi laazeelini Ɠɔoɠɔ GALAGI ma. ");
INSERT INTO tod_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Li nuɓusɛiti pɔ bɛ, è ti ɲade za ta lina, ti ta-zeɠeiti gba. ");
INSERT INTO tod_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ti ɠɛʋele ɓɛtɛai ɠɛle foloi zaʋasiɛi ma, mazɔlɔɔ foloi zaʋasiɛi ma, Ɠɔoɠɔ GALAGI ɠa ʋaazu yeizu nuɓusɛiti kpein gaazu, Sinayi gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ɗa nuɓusɛiti kwɛsuʋɛ leʋe ba gizei maaɠoolii zu, è ɠɛ ma: ‹À dama, wo mina lɛ gizei ma, wo mina vɔɔɠu dakɔlɔgaʋɛ ʋa. Nu nɔpɛ a vɔɔɠuna gizei ʋa, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nu la yeevɔɔɠua ba, kɛlɛ toɠa zɔɔ ga kɔtui, ɓaa ti bɔ ga mɛɛinti, é ɠɛni ga sua, ɓaa nu, é la yɛga vulua ɲɛgɛlɛin.› Siɛgi zu baala sinɛ minɛi ma ʋuʋugi a vɛɛna la, tanigaa ta lɛ gizei ma názu.» ");
INSERT INTO tod_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moize yeini nuɓusɛiti pɔ pelei, é zeɠe gizei ma, é nuɓusɛiti ɲadeni. Naati ti ta-zeɠeiti gbani. ");
INSERT INTO tod_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","É ɠɛni nuɓusɛiti ma: «À ɠɛʋele ɓɛtɛ folo saʋagɔ laawu. À mina maaɓuɠa anzanu ɠila kpalaa ba.» ");
INSERT INTO tod_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Foloi zaʋasiɛi, ma zobui, tonai kpunɛni, mainmainti ti ɗa saɠa, ta tonaɓiin gaaɠiligai ɠɛni gizei ma, puʋu gooi wola ɠulani. Nuɓusɛiti kpein ti ɠɛni zeini ti-ʋuuzuʋɛ, ti tɔɔzeini ga sasuɓalii, dualuagi maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moize nuɓusɛiti kulani ti-ʋuuzuʋɛ, ti GALA daaɠomi. Ti liini, ti lo gizei ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinayi gizei kpein ge ɠɛni ga duulu letele, tɔɔzei Ɠɔoɠɔ GALAGI yeini ná, abui zaama. Naama luului ɠɛni ɠulazu eɠɛ abuzulugi zu luului, gizei kpein ge ɠɛni ɓalizu ga zeeɠaaɓaai. ");
INSERT INTO tod_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Puʋu gooi ɠɛni lɛɛzu, tugi ɗa zizi. Moize ɠɛni ɓɔɛzu, GALA ge ɠɛni gooɠaaʋotesu ga woo wola. ");
INSERT INTO tod_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Zekana Ɠɔoɠɔ GALAGI yeini la Sinayi gizei ma, gize losaamaʋɛ. Moize lɛɛni ná. ");
INSERT INTO tod_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yei, è nuɓusɛiti kwɛteʋe, ta mina ɓudɛ, é ʋa ʋa Ɠɔoɠɔ GALAGI ʋɔ pelei, faazuɓɛɛwo faa ma, ma mɔinmɔin undaa mina ʋa ʋilisu ti zaama. ");
INSERT INTO tod_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Zalaɠa ɠula nuiti ɓɔɠɔi ti maaɓuɠazu Ɠɔoɠɔ GALAGI ʋa, ti ɓɔɠɔ ɲade, Ɠɔoɠɔ GALAGI mina ʋa ta zeɠezu ti ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moize ɠɛni Ɠɔoɠɔ GALAGI ma: «Nuɓusɛiti ti la zooga ti ʋa lɛ Sinayi gizei ma, mazɔlɔɔ è gi lɛnɛgɛ ga gi kwɛgi la gizei maaɠoolii zu, maaɲɛɛi ʋɛɛ ba.» ");
INSERT INTO tod_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ɠɔoɠɔ GALAGI ɠɛni ma: «Li, è yei, ɗa lɛɛzu ʋolu wa Aalɔn. Kɛlɛ zalaɠa ɠula nuiti ta nuɓusɛiti ti mina ɓudɛ ɲɛgɛlɛin, ti ʋa lɛ Ɠɔoɠɔ GALAGI ʋɔ bɛ, nii a kɛ saa mina ʋa loozu ti zaama.» ");
INSERT INTO tod_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moize yeini nuɓusɛiti pɔ bɛ, é ɓɔɛ ti ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","GALA ge niima wooiti kpein boni, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Nà ga Ɠɔoɠɔ GALAGI, ɗa-ƓALAGI, nii é è ɠulani Ezipete yooi ʋa, duɔla ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Gala kiligaa ti mina ɠɛ è ʋɛ nɔ̀un polu. ");
INSERT INTO tod_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mina ani maaniini saɠa ɓɔɠɔ ʋɛ ɲɛgɛlɛin, ta ani nɔpɛ baaɠulaba, niiti ti geeɠɔlɔgi zu, ɓaa niiti ti zooi ma, ɓaa niiti ti ziɛiti bu zooi wu. ");
INSERT INTO tod_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mina nɔkɔ ti wu ɲɛgɛlɛin, mina ti lɛbi ɲɛgɛlɛin, mazɔlɔɔ nà, Ɠɔoɠɔ GALAGI, ɗa-ƓALAGI, nà ga GALAGI toloai, nii a ɗa ɠɛɛɠɛiti ta-vaa ɲɔi ʋotokula ti-lointi ma, eyɛsu é zeeli yamanii zaʋasiɛi ta naanisiɛi ma, niiti ti màayoseɠezu ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kɛlɛ nà ɗa wooɠɛɠiladai ɠɛ, eyɛsu é zeeli yamani waagilasiɛi (1.000) ma, naati bɛ, niiti ti nɛ̀ɛzu ʋɛ, ta ti nà-deveiti sosu. ");
INSERT INTO tod_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mina Ɠɔoɠɔ GALAGI, ɗa-ƓALAGI laaseigi wo fuun ɲɛgɛlɛin, mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠa naama nui leve ga sɔba nu, nii é daaseigi wosu fuun. ");
INSERT INTO tod_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ɠizɛ dooɠo foloi zu, è maaɲɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ɗa botii ɠɛ folo lɔzitai zu, è ɗa-wotii kpein kɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Kɛlɛ folo lɔfelasiɛi ɠa ga Ɠɔoɠɔ GALAGI, ɗa-ƓALAGI, ná-dooɠo foloi. Mina boti nɔpɛ kɛ ma, ɗa-o, è-loun zunuiti-yo, è-loun anzanuiti-yo, ɗa-wotiɠɛ zunuiti-yo, ɗa-wotiɠɛ anzanuiti-yo, ɗa-loganiiti-yo, ta wɛɛinti niiti ti zeini è ɠɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mazɔlɔɔ folo lɔzita laawu Ɠɔoɠɔ GALAGI geeɠɔlɔgi ɓɛtɛni, ta zooi, ta kpoloɗɛi, ta ti zu aniiti kpein, é looɠoni foloi lɔfelasiɛi ma. Naa ɠa é ba, Ɠɔoɠɔ GALAGI tuya looni dooɠo foloi ma, é makɛ ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","È-ɠɛɛ lɛbi ta è-lee, naa ɠa a kɛ è-zii ma voloiti suɠooza, naama yooi zu nii Ɠɔoɠɔ GALAGI, ɗa-ƓALAGI feezu è ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mina nu ʋaa ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mina wɛɛnziɛ bo ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mina unma wo ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Mina zɛɛ zeele woo wo ɲɛgɛlɛin è-zeiɲɔɠɔi laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mina ɠaazuɠula ɲɛgɛlɛin è-zeiɲɔɠɔi ná-pɛlɛi ʋa. Mina ɠaazuɠula ɲɛgɛlɛin è-zeiɲɔɠɔi anzai ʋa, ɓaa ná-botiɠɛ zunui, ɓaa ná-botiɠɛ anzanui, ɓaa ná-nikɛi, ɓaa ná-soovalegi, ɓaa ani nɔpɛ é ga è-zeiɲɔɠɔi nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nuɓusɛiti kpein ti tona kpunɛ tugiti mɛnini, ti mainmainti kaa, ti puʋugi wooi mɛni, ti gizei ɠa abuzogi ba. Nuɓusɛiti ti naati kaai ma, ti zasuɓalini, ti lo ɠoozama. ");
INSERT INTO tod_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ti ɠɛni Moize ma: «Ɗa ɓɔɠɔi è ɗa ɓɔɛ gi ʋɔ, gá woilo ma, kɛlɛ GALA ge mina ɓɔɛ gi ʋɔ, gá ʋa za.» ");
INSERT INTO tod_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moize ɠɛni nuɓusɛiti ma: «À mina lua, mazɔlɔɔ GALA paaʋɛ ga é wo ʋoluɠula, naa ɠa a kɛ, wo lua ba, wo mina koto ɠɛ.» ");
INSERT INTO tod_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nuɓusɛiti ti ɠɛni loni ɠoozama. Kɛlɛ Moize maaɓuɠani tonaɓiingi ʋa, ʋɛ GALA ge ɠɛni ná. ");
INSERT INTO tod_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: Ʋele ɠa ɗa ɓɔɛ la Izilayɛle nuiti pɔ: Wo pɛtɛgɛ ga zɛ̀gɛ geeɠɔlɔgi zu, gè ɓɔɛ wo ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","À mina galagaa ɓɛtɛ ɓɔɠɔ ʋɛ ga walii ɓaa zanugiti, wo ʋa ti ʋokɔɠɔ mà. À mina naa ta ɠɛ ɓɔɠɔ ʋɛ ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Wa zalaɠa ɠulazuʋɛ lo bɛ̀ ga pɔlɔi, nii wa gala zalaɠaiti ta ziilɛi zalaɠaiti kula maazu, ga wa-ʋaalagiti ta wa-nikɛiti. Ʋɛ nɔpɛ gè ɠulazu ná kɛlɛma, nà ʋa wo ʋɔ bɛ, ga gè tuya loo wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ni wa zalaɠa ɠulazuʋɛ lona bɛ̀ ga kɔtui, à mina to ga kɔtu zaɠaai, mazɔlɔɔ wa wa-zɔɔlaiti pɛɛna kɔtui ʋa, wa kɔzɔ. ");
INSERT INTO tod_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","À mina nà-zalaɠa ɠulazuʋɛ lo, wo ʋa nu lɛɛzuʋɛ ɓɛtɛ ba, nu a ɠɛna lɛa ga, kabei mina ɠula kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Tɔgiti pɛtɛ, ɗa dɛɛ ga tiye: ");
INSERT INTO tod_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ni wa Eɓulu nui ta ɠeyana ga duɔi, toɠa botii ɠɛ kona dɔzita laawu, kɛlɛ dɔfelasiɛi, toɠa ɠula, é wɔɔlɔyai zɔlɔɔ, é mina ani nɔpɛ sala. ");
INSERT INTO tod_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ni tɔ ɠila ka é ʋaani, tɔ ɠila ka a li, ni anza ɠɛɛʋɛ zea, ta li ta anzai. ");
INSERT INTO tod_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ni maliɠii ɠa é anzai veeni zea, é doun zunuiti ta doun anzanuiti sɔlɔɔ, anzanui ta ná-dointi ta ɠɛ ga maliɠii nɔnɔ, tɔ ɠila ka a li názu. ");
INSERT INTO tod_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ni duɔi a ɠɛna ma: «Màliɠii nɛɛʋɛ bɛ̀, ta ànzai ta dòinti ɓalaa, gè la pɔ gè ʋa ɠɛ ɓɔɠɔ yeema,» ");
INSERT INTO tod_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","naazu maliɠii ɠa lii la GALA kakala, é maaɓuɠa pɛlɛlaʋɛ ʋa, ɓaa daamasagi ʋa. Maliɠii ɠa goii wɔ ga kɔlu ɠaazoɓagi. Duɔi ɠa yɛ ná-botii zu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Siɛgi zu zunui ta a ná-doun anzanui ʋɔdina la, ga é ɠɛ ga duɔi, é la ɠula duɔlai zu, eɠɛʋelei zunuiti ta ɠula la. ");
INSERT INTO tod_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ni wɔin a zeɠena maliɠii ma, nii é ɠɛa deveni ga é seɠe ga anza, toɠa zɛ ná, nu ɠili ge unmɔɔ, kɛlɛ zobo ge la ɠɛa zea ga é ʋa pɔdi zii ɠili ma, a naa ɠɛna é ɠɛa ga yaava nu anzanui letema. ");
INSERT INTO tod_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ni a devena ga é fulu ná-doun zunui ʋɛ, toɠa kɛ bɛ, eɠɛʋelei soloogai la anzanu lointi ma. ");
INSERT INTO tod_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ni a anza ɠili seɠena, é la ta ɠula ma mɔungi ná-daamianigi la, ta ná-seɠei, ta é la ɠɛlɛa naa ná-dakobai ʋa. ");
INSERT INTO tod_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ni é la ɠɛ naama vaa saʋagɔiti kɛɛni bɛ, toɠa zoo é li, é mina ani nɔpɛ sala. ");
INSERT INTO tod_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Zɔi nɔpɛ a nu loɠana, é za, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ni é la woya ɓɛtɛni tuɠɔ, ni GALA ge kɛa é ɠɛ zea ga teʋezea vaa, nà ada ɓɛtɛzu wo ʋɛ, ʋɛ a ʋela, é li, é lɔɔɠu ná. ");
INSERT INTO tod_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kɛlɛ siɛgi zu nu a gaaɠilina la ma, é wuzeɠe seiɲɔɠɔi laalɔɠɔma, é keleɠele ɲɔi ɠɛ ga é paa, anɛɛ ni diiʋɛ, é lɔɔɠu nà-zalaɠa ɠulazuʋɛ, wa kula naa ʋa, wo paa. ");
INSERT INTO tod_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Zɔi nɔpɛ a kɛɛɠɛ loɠa, ɓaa dee, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Zɔi nɔpɛ a nuɓusɛ unma, é pɔdi, ɓaa é makɛ ya, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Zɔi nɔpɛ é kɛɛɠɛ ɓaa dee ɠotozu, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Siɛgi zu nua ti ɓɔɛzu la, gila ge seiɲɔɠɔi zɔɔ ga kɔtui, ɓaa é doɠa ga zeeɓuin, ni é la ɠɛɛni ga saa vaa, kɛlɛ naa ma ge la ga seeɓɛi, ");
INSERT INTO tod_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ni toɠa zoo é ná-tukpɔi zeɠe, é ziɛziɛ eteaʋɛ, zɔi é doɠai wogai, faa la mɔ ɠɛa naa ʋa, kɛlɛ ná-botii koloɠologai ma, toɠa naa zala, é lati, é naa zale, eyɛsu é ɠɛdɛ. ");
INSERT INTO tod_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Siɛgi zu zunui ta ná-duɔi loɠazu la ga tukpɔi, zunu ɓaa anzanu, eyɛsu duɔi za zea, ta potokula ma. ");
INSERT INTO tod_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ni a yɛna vulua folo ɠila, ɓaa felegɔ, ti la potokulaa ma, mazɔlɔɔ ná-walii ʋe. ");
INSERT INTO tod_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ni zunua ta ɓɔɛna, ti ziɠa anzanui ta ʋa kogi ma, é doin zɔlɔɔ, faaɓa kili ge la sɔlɔɔni, ta alamanii zala nii anzazinigi dɛɛzu, ta sala faawo bo nuiti kakala. ");
INSERT INTO tod_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kɛlɛ ni faaɓa ka ɠulana su, zɛnvui ʋoto ka ɠɛ ga zɛnvui, ");
INSERT INTO tod_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","nu ɠaazuɠɛzɛi ʋoto ka ɠɛ ga nu ɠaazuɠɛzɛi, nu ɲiiga ʋoto ka ɠɛ ga nu ɲiiga, nu yeei ʋoto ka ɠɛ ga nu yeei, nu ɠɔɠɔi ʋoto ka ɠɛ ga nu ɠɔɠɔi, ");
INSERT INTO tod_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","abu ʋalai ʋoto ka ɠɛ ga abu ʋalai, maawanai ʋoto ka ɠɛ ga maawanai, maaɓologi ʋoto ka ɠɛ ga maaɓologi. ");
INSERT INTO tod_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Ni zunui ta a ná-duɔi loɠana gaazuɠɛzɛi gilagi ʋa, é ɠɛni ga zunu ɓaa anzanu, é naa ʋala gaazuɠɛzɛi ma, toɠa yeeɓe ba, é li, é ɠula duɔlai zu, gaazuɠɛzɛi zalai ɠana. ");
INSERT INTO tod_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ni a ná-duɔi ɲiigai gila kulana da, é ɠɛni ga zunu ɓaa anzanu, toɠa yeeɓe ba, é li, é ɠula duɔlai zu, ɲiigai zalai ɠana. ");
INSERT INTO tod_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ni nikɛi a nu ziɠana ga minɛi, zunu ɓaa anzanu, naa za, nikɛi ɠa zɔɔ ga kɔtui, nu mina ma zuai mi pa. Nikɛ nui la mɔ faa zɔlɔɔga. ");
INSERT INTO tod_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kɛlɛ ni kaite, nikɛi ɠɛɛʋɛ ba, é ɗa nuiti siɠa ga minɛi, ti ɗa nikɛ nui lɛnɛ, é la wɛlɛzu ma, siɛgi zu a zunu ɓaa anzanu ʋaana la, nikɛi ɠa zɔɔ ga kɔtui, é za. Ta nikɛ nui ɓalaagi ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ni ta zɛnvui unmɔɔ salai levena ma, toɠa naa kpein sala, nii a leve ma. ");
INSERT INTO tod_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Siɛgi zu nikɛi a zunu loun ɓaa anzanu loun ziɠana la, naama lɔgi nɔ ɠa a ziɛ. ");
INSERT INTO tod_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kɛlɛ siɛgi zu nikɛi a duɔi ziɠana la, zunu ɓaa anzanu, wali ɠae ʋuusaʋagɔ (30) ɠa a zo duɔ kɛɛɠɛi ya, nikɛi ɠa zɔɔ ga kɔtui. ");
INSERT INTO tod_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Ni zunui ta a ziɛyeɠei laalaogai yɛna de, ɓaa ni zunui ta a ziɛyeɠei ta wɔɔna, é la daaɠuluni, nikɛi loo su, ɓaa soovalegi, ");
INSERT INTO tod_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ziɛyeɠe nui ɠa toganii liegɔi ma walii zala kɛɛ nui ma, sua ʋoomai ɠa ɠɛ ga tɔun nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ni nui ta ná-nikɛ zinɛ a nui taɠili ná-nikɛ zinɛ ziɠana ga minɛiti, naa za, ta nikɛ zinɛi ʋɔdi, nii é vulua, ti walii ɠaaɠwɛ ʋa, ti lati, ti nikɛ ʋoomai ɓalaa gaaɠwɛ ʋa. ");
INSERT INTO tod_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kɛlɛ ni kwɛɛgɛ ga nikɛi é taɠili paai, kɛɛʋɛ siɠai wosu, ma nui la wɛlɛni ma ɲɛgɛlɛin, ma nui ɠa potogi leʋe ga nikɛi nɔ, nikɛ ʋoomai ɠɛ ga nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Ni nui ta a nikɛ ɓaa baala unmana, ni a kɔdaaleʋena, ɓaa é pɔdi, toɠa nikɛ zinɛ lɔɔlugɔ ve nikɛ ɠilagi ʋotogi zu, ta baala naanigɔ baalagi ʋotogi zu. ");
INSERT INTO tod_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ni unma nui a zona unma wosuʋɛ ga maaɓaai, nu doɠa, é za, ti la ɠɛa ga sɔba nu ɲɛgɛlɛin, tɔun tetema saa vai zu. ");
INSERT INTO tod_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kɛlɛ ni foloi a tɛɛna, ta ɠɛ ga sɔba nu tɔun tetemazu paa vai zu. Unma nui kpein ka naa ʋotogi ve, nii é unmaai. Ni ani la zea, ta pɔdi ná-unma vai zu. ");
INSERT INTO tod_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ni nii é unmaai, nikɛi ɓaa soovalegi, ɓaa baalagi, naa ɠa dɛ vulua zea, toɠa naa ʋotogi ve ga ma ʋɛɛdai. ");
INSERT INTO tod_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ni zunui ta a faa zuɠoloɠolo kɛɛna kpalagi ta zu, ɓaa kpelei ta zu, é ɓe ná-toganiiti ba, ti daami wo seiɲɔɠɔi ná-kpalagi zu, toɠa ma vaa zu ɓɛtɛi ɠɛ ga ná-kpalagi zu ani ʋagɔi, ɓaa ná-leezɛn ɓelei zu ani ʋagɔi. ");
INSERT INTO tod_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ni abui a leʋena, é so dɔɓɔi ʋa, moloi nii daa ga ɓelee, é so naama ɠilii ʋa, ɓaa nii é ma ɓaɠai ɠa, ɓaa é kpalagi ɠala, zɔi é abui loga, naa ɠa naama vai ɓɛtɛ ga é potogi ve. ");
INSERT INTO tod_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ni nui ta a walii ɓaa ani ɠiligaa ɠalivaana nui ta ma ga é makɛ, ni ta ti unmana naa ná-pɛlɛi wu, unma nui ɠa ma ʋɛɛdai ɠaaɠale ma, ni ta sona. ");
INSERT INTO tod_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ni unma nui la zoni, pɛlɛ nui ɠa lo GALA gaazu, é dɛɛ ga é la yeezeelini seiɲɔɠɔi ɠɔligi ma. ");
INSERT INTO tod_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Maaɠaali vaa kpein, é lo nikɛ vaa ʋa, ɓaa soovale faa, ɓaa baala faa, ɓaa seɠe vaa, ɓaa tooya ani vaa, nii nu a ɠɛ ma: «Nii ʋe,» naama nu zeizu felegɔiti ta-vai laa ɠa zeeli GALA ma. Zɔi GALA ga peelalana, naa ɠa seiɲɔɠɔi nɔnɔi ɠaaɠale ma ga ma ʋɛɛdai. ");
INSERT INTO tod_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ni nui ta a soovale, ɓaa nikɛi, ɓaa baalagi, ɓaa togani nɔpɛ feena nui ta ya ga é makɛ ba, suai zɛba é za, ɓaa nata ɠale ba, ɓaa é ɲɛɛlɛ, nu nɔpɛ ge la kaani, ");
INSERT INTO tod_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","konai ɠa wo Ɠɔoɠɔ GALAGI laaseigi zu ti felegɔ yɔɠɔzu, zɔi é suai makɛgai, naa ɠa bo ga é la yeeʋɛɛni seiɲɔɠɔi ɠɔligi ʋa. Togani nui ɠa yeezei konai naa wu, zɔi la ani nɔpɛ gaaɠalega ma ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kɛlɛ ni suai unmaʋɛ pɔ bɛ, toɠa potogi ve ma nu ya. ");
INSERT INTO tod_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ni suai ʋaliʋaliʋɛ ga, toɠa dɛɛ, é ɠɛ ga zeele wooi, é la mɔ naa ʋoto fea, nii baliʋaliai ga. ");
INSERT INTO tod_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ni nui ta a togani ziingaona seiɲɔɠɔi ma, nata ɠale suai naa ʋa, ɓaa é za, ma nui ɠaazu la ná, toɠa potogi ve. ");
INSERT INTO tod_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ni ma nui ɠa ná, poto ge la vea. Ni suai zala vaa ɠɛɛʋɛ de, sala zɔngɔi ɠa kula ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ni zunui ta a anzalopo ɓeai ta nɛɛnɛsona, nii maa la dɛ zoni, é la koba, toɠa fulu naavoloi ɠula, é seɠe ga anza. ");
INSERT INTO tod_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ni doun kɛɛɠɛi a ɠɛlɛna, é ʋa fe zea, nii anzalopoiti ta ɗa vulu la, toɠa naa liegɔi zala ga walii. ");
INSERT INTO tod_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","À mina zoɠo anzanui yɛ ná, é ʋa yɛ vulua. ");
INSERT INTO tod_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Nu-o-nu a la ga suai, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Zɔi a zalaɠaa ɠula gala kiligaa ʋɛ, é ɠula Ɠɔoɠɔ GALAGI ɠila kpe polu, naa undaa ɠa ʋili. ");
INSERT INTO tod_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","À mina seikɔɠɔma nui zopele ɲɔu ɲɛgɛlɛin, wo ʋa suziɠa, mazɔlɔɔ wo ɠɛni ga seikɔɠɔma nuiti Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","À mina poanzai ɓaa podoin yiiɓɔlɔ vaa ɠɛ ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ni wa ti yiiɓɔlɔna, ti wooɠula mà ga kpeei, nà ti ɓain gooi mɛni. ");
INSERT INTO tod_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Nà wola yiiɠaawana wo laalɔɠɔma, nà wo ʋaa ga kɔɔi, wo-anzaiti ta ɠɛ ga poanzaiti, ta wo-lointi ti ɠɛ ga podointi. ");
INSERT INTO tod_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ni wa wali ɠuye ʋɛɛna nà-nuɓusɛiti ta ma, mɔnɛ nui é wo ʋɔ bɛ, à mina ɠɛ bɛ eɠɛ kuye ʋɛɛ nu, wo mina talama maaloli ma ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ni wa wo-zeiɲɔɠɔi ná-seɠei zeɠena ga kpɔunmai, wa fe zea, aisa foloi ʋa li. ");
INSERT INTO tod_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Mazɔlɔɔ ná-seɠe ɠilagi ʋe, é pɛɛzu ɓɔɠɔ ma. Ni naa a ɠulana zea, lee ɠa a pɛɛ ɓɔɠɔ ma? A wooɠulana mà ga kpeei, nà gooi mɛni, mazɔlɔɔ nà ɗa nu maawɔinɠa. ");
INSERT INTO tod_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","À mina GALA koto, wo mina woo ɲɔu wo wa-nuɓusɛiti ta-ɠundiɠii ma. ");
INSERT INTO tod_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Wo maanɛɛʋɛ, wo ʋa bɛ̀ ga wa-molo leʋea mɔungiti, wo kɛ ga zalaɠai, ta wa-leezɛn ɗɛ mɔungiti. Wa wo-loun zunu mɔungi ve zèa. ");
INSERT INTO tod_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Zekana wa kɛ la wa-logani wolai ta wa-logani goiti ta-vaa zu. Ma mɔungi ɠa yɛ dee ʋa folo lɔfela zu. Foloi lɔsaʋasiɛi, wa fe zèa. ");
INSERT INTO tod_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Wa ɠɛ bɛ̀ ga nu ɲadegaiti. À mina sua mi, nii baliʋaliai ga dɔɓɔi zu. Wa naa ʋili ya gilɛiti bu. ");
INSERT INTO tod_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","À mina tiɠɛ woo vaza. À mina ɓɔ nu ɲɔu ʋa, wo ʋa zɛɛ zeele woo wo. ");
INSERT INTO tod_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","À mina ʋilɛ bɛbɛi ʋolu ga wo ʋa faa ɲɔu ɠɛ. Ni wo loligɛ ga wo zeele wooi ve, à mina lo naati polu, niiti ti mɔinɗai, wo ʋa telebodai maaʋe. ");
INSERT INTO tod_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","À mina lo mɔnɛ nui ʋolu ná-faawogi zu. ");
INSERT INTO tod_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ni wa ɠomina ga wo zili nui ná-nikɛi ɓaa ná-soovalegi toai ya, kɛni wo ʋaa la pɔ. ");
INSERT INTO tod_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nui é wo wɔinzeɠezu, wa ná-soovalegi ɠaana, toai ná-kasɔi wu, wa ma, wa inɛinɛsu ga daayei vai, wa ʋɛɛ ba, wo daayei. ");
INSERT INTO tod_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","À mina mɔnɛ nui ná-gaamai maaʋe ná-tukpɔi zu. ");
INSERT INTO tod_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kɛni wo ɓeteʋe zɛɛ ɓɔɛ wo fai ʋa. À mina sɔbalala nui ʋaa ta telebo nui. Mazɔlɔɔ gè la sɔba nui ʋɛtɛga eɠɛ telebo nui. ");
INSERT INTO tod_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","À mina lobɛani zo, mazɔlɔɔ lobɛaniiti ta ɗa naati gaazuɠole, niiti ti ɠaazuzeɠeai ma, ta ti telebo nuiti kpɔɛ wooiti maaʋe. ");
INSERT INTO tod_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","À mina seikɔɠɔma nui maanɔɠɔ. Wo kwɛni wa ɓɔɠɔi nii seikɔɠɔma nui a ɗa suzo, mazɔlɔɔ wo ɠɛni ga seikɔɠɔma nuiti Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Kona dɔzita laawu, wa ani zuwui vaza wa-yooi ma, wo baalɔnɔgi zɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kɛlɛ wa yeeɓe ba, wo zɛ ɠana nɔ, kona dɔfelasiɛi, é naa ɠɛ dooɠogi zu. Mɔnɛ nuiti ti wa-nuɓusɛiti saama, naati ti naa mi, nii ta ka, ta dɔɓɔ zuaiti ti naa mi, nii é yɛsu. Wa kɛ ɠana ga wa-leezɛn ɓelei, ta wa-wolive wuluiti. ");
INSERT INTO tod_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Folo lɔzita laawu, wa wa-wotii ɠɛ. Kɛlɛ folo lɔfelasiɛi, wa looɠo, naa ɠa a kɛ wa-wotiɠɛ nikɛiti ta wa-zoovalegiti ti looɠo, ta wa-luɔiti ta seikɔɠɔma nuiti ti lago looɠo. ");
INSERT INTO tod_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","À naa kpein so, nii gè bogai wo ma. À mina gala kiligaa laasei bo ɲɛgɛlɛin, nu mina ta mɛni ɲɛgɛlɛin, é ʋa ɠula wo-laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ná zeizu ɠa ɠɛ saʋa konagi zu, wo ɗa fɛtiiti kula dàaseigi lɛbi vai zu. ");
INSERT INTO tod_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ɓului nii lɛʋɛ la su, wa naama vɛtii makɛ. Folo lɔfela laawu, naama ziɛgi deveai molo ɠulasu alugi ma, wa ɓului mi, nii lɛʋɛ la su, eɠɛʋelei gè ma levei veai la wo ya, mazɔlɔɔ naama alugi ma ɠa wo ɠulani la Ezipete yooi ʋa. Nu nɔpɛ ge mina ɠula kɛlɛma gàazu ga yeaɲaka. ");
INSERT INTO tod_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Wa molo mɔɔ vɛtii makɛ, wa-wotii zulɔnɔ mɔungiti, nii wa faza kpalagaʋɛ. Wa molo leʋe vɛtii makɛ kona ɠaaɓelagi zu, siɛgi zu wo ɓesu la ga wa-wotii zulɔnɔgi ɠaalɛ ba. ");
INSERT INTO tod_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ná zeizu ɠa ɠɛ saʋa konagi zu, zunuiti kpein ti ɠula kɛlɛma gàazu, nɛ̀i gè ga wo-Maliɠii Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ɓului nii lɛʋɛi su, à mina naa ɓɔ suai ʋa, wo ʋa kula ga nà-zalaɠai. À mina nà-fɛtii ma zalaɠai ma wulɔi makɛ kpidii laawu, é ʋa yɛsu sobu ʋa zeeli. ");
INSERT INTO tod_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Wa ʋa ga wa-yooi ʋaalɔnɔ mɔungiti Ɠɔoɠɔ GALAGI, wa-ƓALAGI zei ʋɛlɛi wu. À mina boli yiʋoi ɠili ga dee ná-ɲiimiɗɛi. ");
INSERT INTO tod_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Nɔ̀un nà, nà geezuɠeelai ta leʋesu wo luɠɔ, é wo makɛ pelei zu, é wo laazeeli naama adaʋɛ, gè ná ɓɛtɛai. ");
INSERT INTO tod_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","À dama, wo ɓɔɠɔ zo gaazu, wo ɠolo gooi ʋɛ. À mina ziiɓɔlɔ vaa ɠɛ, tɔɔzei é la wa-lɔ koloɠologiti suvaayɛga, mazɔlɔɔ dàaseigi ɠa tɔun ba. ");
INSERT INTO tod_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kɛlɛ ni wa ɠolona gooi ʋɛ, ta ni wa naa kpein kɛɛna, nii gè bosu wo ma, nà ɠɛ ga wo zili nuiti sili nui, ta wo maayoseɠe nuiti maayoseɠe nui. ");
INSERT INTO tod_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Nà-geezuɠeelai ɠa lo wo luɠɔ, é li ga woye Amool nuiti pɔ bɛ, ta Ɠɛte nuiti, ta Felɛze nuiti, ta Kanaan nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti, ta nà ti-ma zuwui ɠaaleʋe. ");
INSERT INTO tod_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","À mina nɔkɔ ta-ɠalagiti bu, wo mina ti lɛbi. À mina ʋokɔɠɔ naama nuɓusɛiti ma ti-ziɛ ʋelei zu. Kɛlɛ wa ti ɠoloɠolo, wo ta-zale ɠɔtuiti kpezeɠele. ");
INSERT INTO tod_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Wa dɛ̀bi, nɛ̀i gè ga Ɠɔoɠɔ GALAGI wa-ƓALAGI. Nà tuya loo wa-laamianigi ma, ta wa-ɓɔɔle ɗɛi. Nà seeɓɛi ɠula wo zaama, gè maaɠooza wo ʋa. ");
INSERT INTO tod_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Anzanu la ɠɛa wa-yooi zu, nii kogi a zeɠe ma, ɓaa doun zɔlɔɔtala anzanu. Nà wo-zii ma ɠonagi zuɠooza. ");
INSERT INTO tod_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Aisa wo ʋa zeeli, nà dualuagi ʋu zooi zu nuiti su. Nà nuɓusɛiti kpein daaʋili, gè ti zeɠe pelei zu wo luɠɔ, niiti wa zeeli ti ʋɔ bɛ. Nà wo zili nuiti kpein kpɛ, ti ʋela wo ʋa. ");
INSERT INTO tod_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nà kaogiti teʋesu wo luɠɔ, ta Ɠeve nuiti kpɛ, ta Kanaan nuiti, ta Ɠɛte nuiti, ti maaɠooza wo ʋa. ");
INSERT INTO tod_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Gè la ʋaazu ti ɓɛɛzu kona gila su, ti ʋa maaɠooza wo ʋa, naa ɠa a kɛ, zooi zu, ɲakai mina yɛ, dɔɓɔ zuaiti ti mina mɔin wo laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nà ti ɓɛɛzu vaavaa, ti maaɠooza wo ʋa, eyɛsu wo ɗa wola mɔin, wo zoo wo zooi zɔlɔɔ ga wɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Nà wa-ɠwɛpelemaʋɛti daazu, é zo Seeli Kpoloɗɛi ma, é zeeli Kpoloɗɛ Wolai ma, ta é zo teʋebai ma, é zeeli ziɛ wolai ma. Mazɔlɔɔ nà zooi ɠa nuiti dɔɔzu wo yeezu, wa ti ɓɛ luɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","À mina minazeɠe kɛ yɔɠɔzu wa tiye, ɓaa wa ta-ɠalagiti. ");
INSERT INTO tod_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ti mina zei wa-yooi zu, naa ɠa a kɛ ti mina wo lɔ kotoi zu dàalɔɠɔma, mazɔlɔɔ wa ta-ɠalagiti dɛbi, naa ɠa ɠɛ ga balii wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","GALA ge ɠɛni Moize ma: «Lɛ Ɠɔoɠɔ GALAGI ʋɔ bɛ, ɗa ɓɔɠɔi wa Aalɔn, ta Nadaɓe ta Aɓiyu, ta Izilayɛle ɠɛwola wɔlɔ ʋuulɔfela (70), wo yɛ ɠoozama, wo nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ɗa ɠila kpe nɔ ɠa ɗa maaɓuɠa Ɠɔoɠɔ GALAGI ʋa. Zɔiti ti mina maaɓuɠa ba, nuɓusɛiti ti mina yɛ é ʋolu, ti ʋa lɛ.» ");
INSERT INTO tod_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moize ʋaani, é Ɠɔoɠɔ GALAGI wooiti kpein bo nuɓusɛiti ma, ta tɔgiti kpein. Nuɓusɛiti kpein ti gooɠaaʋotegi veeni ga woo ɠila, ti ɠɛ ma: «Gá naa kpein kɛ, nii Ɠɔoɠɔ GALAGI boga.» ");
INSERT INTO tod_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moize Ɠɔoɠɔ GALAGI wooiti kpein sɛʋɛni. Naa ʋolu é wuzeɠeni ga sobuzobui, é zalaɠa ɠulazuʋɛ lo gizei ɠɔɠɔaʋɛ, é kɔtu puugɔ maazu felegɔiti (12) pilɛni ga ɠizɛsui Izilayɛle ná-boloda puugɔ maazu felegɔiti (12) faa zu. ");
INSERT INTO tod_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","É Izilayɛle zinipoiti teʋeni, ga ti gala zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, ta ti nikɛ zinɛiti kula ga ziilɛi zalaɠaiti. ");
INSERT INTO tod_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moize ɲamai ma lukpɛgi zeɠeni, é pu kokoiti su, é ma lukpɛgi zɔi zeɠeni, é pili zalaɠa ɠulazuʋɛ ma. ");
INSERT INTO tod_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","É minazeɠegi ma zɛʋɛi zeɠeni, é kala nuɓusɛiti gaazu. Ti ɠɛni ma: «Gá naa kpein kɛ, nii Ɠɔoɠɔ GALAGI boga, gá ɠolo gooiti bɛ.» ");
INSERT INTO tod_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moize ɲamai zeɠeni, é faza nuɓusɛiti ma, é ɠɛ ma: «Nii ɠa é ga ɲamai nii é minazeɠegi maaɓakpasu, nii Ɠɔoɠɔ GALAGI kɛa wo yɔɠɔzu, eɠɛʋelei niima ɓɔɛiti kpein ti la.» ");
INSERT INTO tod_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moizeni ti lɛɛni gizei ma ta Aalɔn, ta Nadaɓe, ta Aɓiyu, é ʋɛɛ Izilayɛle ɠɛwola wɔlɔ ʋuulɔfela (70) ʋa. ");
INSERT INTO tod_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ti Izilayɛle ná-GALAGI ɠaani, kɔɠɔiti bu ɠɛai eɠɛ kɔtui nii daaseigi ga safiilegi, kpiiniai eɠɛ geeɠɔlɔgi. ");
INSERT INTO tod_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Ɠɔoɠɔ GALAGI la ɠɛni faa ɲɔu nɔpɛ kɛɛni ga Izilayɛle nu ɓiigiti. Ti GALA kaani, naa ʋolu ti daamii woni, ti ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Lɛ pɔ̀ bɛ gizei ma, è yɛ ná. Nà kɔtu ɠokologiti feezu è ya: tɔgi ta deveiti gè ti zɛʋɛai Izilayɛle nuiti bɛ, ti ɠala fai zu.» ");
INSERT INTO tod_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moize wuzeɠeni, ta Zozuwe, nii é ga ná-botiɠɛ nui, Moize lɛɛni GALA ná-gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","É ɠɛni kɛwolaiti ma: «À gi maaɓɔun ʋɛ, eyɛsu gi ɠale ma ʋolu wo ʋɔ bɛ. Wɛlɛ, Aalɔn ta Ɠuul ta yɛsu wo ʋa ʋɛ, ni faaɠaaɠulaba a ɠɛna ta ya, toɠa bo ti ma.» ");
INSERT INTO tod_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moize lɛɛni gizei ma, tonaɓiingi ʋɛɛni gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ɠɔoɠɔ GALAGI ná-lɛbiyai yeini, é ʋɛɛ Sinayi gizei ma, tonaɓiingi ʋɛɛni ma folo lɔzita laawu. Foloi lɔfelasiɛi, Ɠɔoɠɔ GALAGI Moize lolini tonaɓiingi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠɛʋelei ɠɛni Izilayɛle nuiti gaazu, eɠɛ abuzogi gize unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moize lɔɔni tonaɓiingi zaama, é lɛ gizei ma. Moize kɛɛni gizei ma ga folo ʋuunaanigɔ (40) ta kpidi ʋuunaanigɔ (40). ");
INSERT INTO tod_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Bo Izilayɛle nuiti ma, ti ʋa pɔ̀ ga vebɛaniiti. Wa so, é ɠula nui kpein zea, nii faanɛɛ ɠigi bɛ. ");
INSERT INTO tod_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Wɛlɛ vebɛanii ʋa, nii wa so, é ɠula ti ya: zanugi, ta walii, ta kɔlu ɓɔigi, ");
INSERT INTO tod_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, ta boli leɠai, ");
INSERT INTO tod_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ta baala sinɛ ɠɔlɔiti, ti loai ga ma ɓɔigi, ta ziɛ wu zua ɠɔlɔiti, ta akasia wului, ");
INSERT INTO tod_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ta fitina wulɔi, ta tufa maku nɛɛnɛgiti ti ga siɛma wulɔ ɲadegai ta ansansegi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ta kɔtu zɔngɔ ɓaagi nii daaseigi ga wonikese, ta kɔtu zɔngɔ ɓaa kiligiti zalaɠa ɠula zeɠei ma vaa zu, ta ma ɠakazu zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ta seizu ɲadegai lo bɛ̀, nà zei ti zaama. ");
INSERT INTO tod_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Wa ti kpein kɛ ga seɠe ʋɛlɛ ɲadegai ɠazaʋi pelei, é ɠɛ ga sɔɔlai kpein kazaʋi pelei, nii gè ʋaazu dɛɛzu ga ɗe. ");
INSERT INTO tod_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ta kesui ɓɛtɛ ga akasia wului. Sakpai ɠa ɠɛ ga mɛtɛlɛ ɠila taata, kogi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui, ta sɔligi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ɗa zanu kitei ziɛ koozuʋɛ ta poluʋɛ, è daaɓegi ɠɛ ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ɗa zanugi ɠaawuun, è bala naanigɔiti kpɛtɛ bɛ, è ti ʋili goizu naanigɔiti ba, bala felegɔ gilazu ʋelei ta bala felegɔ zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ɗa gulu zɔkpɔiti kpɛtɛ ga akasia wului, è zanugi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ɗa gulu zɔkpɔiti dɔ balaiti su, kesui ɠakamaʋɛti, ti kesui ʋa, kesui ɗa zeɠe ga tiye. ");
INSERT INTO tod_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Gulu zɔkpɔiti ta yɛ kesui ná-balaiti su, ti mina ɠula ná. ");
INSERT INTO tod_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Zeele woo zɛʋɛi gè feezu è ya, ɗa da kesui zu. ");
INSERT INTO tod_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ɗa kesui lakulugi ɓɛtɛ ga zanu kitei. Sakpai ɠa ɠɛ ga mɛtɛlɛ ɠila taata, kogi ɠa ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Geezuɠeela felegɔiti ti laaseigi ga seeluɓɛin, ɗa naati kpɛtɛ ga zanu doɠai, è ti ʋilɛ kesui lakulugi laaɓe felegɔiti ga. ");
INSERT INTO tod_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ɗa seeluɓɛin gila kpɛtɛ daaɓegi ɠilazuʋɛ ɠa, seeluɓɛin gila daaɓegi zɔɔla ʋelei ɠa. Ɗa seeluɓɛin felegɔiti ta kesui lakulugi ɓɛtɛ ga ani ɠila nɔ. ");
INSERT INTO tod_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Seeluɓɛinti ta ti-ɠoʋegiti suvie maazuʋɛ, ti kesui lakulugi maalɔɔɠu ga ti-ɠoʋegiti, ta ɠaaʋote ɓɔɠɔ ma. Seeluɓɛinti ta ɠaaʋote kesui lakulugi ma. ");
INSERT INTO tod_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Zeele woo zɛʋɛi gè feezu è ya, ɗa da kesui zu. Ɗa kesui laaɠulu. ");
INSERT INTO tod_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Miná ɠa nà ɠɛ ɠulazu ná kɛlɛma è ʋɛ, zeele woo ɠesui lakulugi maazuʋɛ seeluɓɛin felegɔiti zɔɠɔzuʋɛ. Ná ɠa gè ʋaazu ɓɔɛzu ná è ʋɔ, é lo nà-deveiti kpein ba, Izilayɛle nuiti faa zu. ");
INSERT INTO tod_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Ɗa taɓalii ɓɛtɛ ga akasia wului. Sakpai ɠa ɠɛ ga mɛtɛlɛ ɠila, kogi ɠɛ ga mɛtɛlɛ lukpɛgi, sɔligi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ɗa zanu kitei ziɛ ma, è daaɓegi ɓɛtɛ ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ɗa kakamaʋɛti kpɛtɛ ga nu yeaʋɛ liegɔi ɠɛɠala, è naa laaɓegi ɓalaa kpɛtɛ ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ɗa zanu bala naanigɔiti to goizu naanigɔiti ba, ti ɠɛ kɔɠɔ naanigɔiti tetegi. ");
INSERT INTO tod_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Balaiti ta ɠɛ kakamaʋɛti ba, gulu zɔkpɔiti ta lɔ ti zu, taɓalii zeɠe vai zu. ");
INSERT INTO tod_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ɗa gulu zɔkpɔiti kpɛtɛ ga akasia wului, è zanugi ziɛ ti ma, ti ɠɛ ga taɓalii zeɠe aniiti. ");
INSERT INTO tod_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ɗa diɠiiti kpɛtɛ, ta tazaiti, puya zalaɠai vaa zu, naa ʋɛɛ ziawɔiti ta kokoiti ba. Ɗa ti ɠɛ ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ɗa ɓuluiti da taɓalii ɠa, niiti ti veai bɛ̀, ti ɠɛ ná gàazu yeenɔpɛ. ");
INSERT INTO tod_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ɗa fitina zei anii ɓɛtɛ ga zanu kitei doɠaai. Ti pɛ ti ɠɛ ga ani ɠila: kɔɠɔi, ta ma wului, ta ma ɓekegiti, ta maaɠili zɔɔlaiti ti ɠulaai ga gulu ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Fitina zei anii ma ɓeke dɔzitaiti ta ɠula kakamaʋɛti, ma ɓeke saʋagɔ ɠa ɠɛɛzu kakamaʋɛ gilazuʋɛ, ta ma ɓeke saʋagɔ ɠɛ kakamaʋɛ zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Maaɠili zɔɔlai ɠa ɠɛ saʋa ma ɓeke dɔzitai ɠilagilagi pɛ ba, ti ɠulaai ga amandegi ma ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Maaɠili zɔɔla naanigɔ ɠa ɠɛ fitina zei anii ma wului ʋa, ti ɠulaai ga amandegi ma ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Maaɠili zɔɔlai gila ka ɠɛ ma ɓeke felefelegiti todazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Fitina zei anii ɠa ɠɛ ga zanu kitei doɠaai. Baalobazuʋɛti pɛ ti ɠɛ ga ani ɠila: ma wului, ta ma ɓekegiti, ta maaɠili zɔɔlaiti. ");
INSERT INTO tod_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Ɗa ná-fitina lɔfelaiti kpɛtɛ, ti zeizu maazuʋɛ, nii a kɛ é ɗa wozaɠala gaazu. ");
INSERT INTO tod_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ná-salaʋa zo sɔɔlaiti ta ná-salaʋa zeɠe aniɲakaiti, ta ɠɛ ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ɗa kilo ʋuusaʋagɔ (30) zeɠe zanu kitei zu, è kpɛtɛ ga fitina zei anii ta ma zɔɔlaiti kpein. ");
INSERT INTO tod_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Dama, è kɛ ga naama ɠazaʋigi nɔ, nii é lɛɛni ga ɗe gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ɗa seɠe ʋɛlɛ ɲadegai ɓɛtɛ ga tanda puugɔ, ga geze ʋagɔi kpaliai, ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi. Ɗa suʋu ga seeluɓɛinti baaɠulabai. ");
INSERT INTO tod_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Tanda ɠilagi zakpai ɠa ɠɛ ga mɛtɛlɛ puugɔ maazu naanigɔ (14), kogi ɠɛ ga mɛtɛlɛ felegɔ. Kɔɠɔgi ɠa ɠɛ ga ani ɠila nɔ tandaiti kpein faa zu. ");
INSERT INTO tod_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Tanda lɔɔlugɔiti ta zei ɓɔɠɔ la, zɔ lɔɔlugɔiti ɓalaa ta zei ɓɔɠɔ la. ");
INSERT INTO tod_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Ɗa galu ɓiiniiti giliɠili tandai ma ɓɔsu mɔungi laamaʋɛ. Ɗa kɛ ɠana nɔ ga tandai ma ɓɔsu velesiɛi laamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ɗa galu ʋuulɔɔlugɔ (50) ɠiliɠili tandai ma ɓɔsu mɔungi laamaʋɛ ʋa, è galu ʋuulɔɔlugɔ (50) ɠiliɠili tandai ma ɓɔsu velesiɛi laamaʋɛ ʋa. Naama ɠaluiti ta zoloo ɓɔɠɔ ma ga felefele. ");
INSERT INTO tod_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ɗa zanu kala puulɔɔlugɔ (50) ɓɛtɛ, è tandai ma ɓɔsuiti giliɠili ɓɔɠɔ ʋa ga tiye. Seɠe ʋɛlɛ ɲadegai ɠa ɠɛ ga ani ɠila kpe nɔ. ");
INSERT INTO tod_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ɗa boli leɠa landa puugɔ maazu ɠila (11) kpɛtɛ, ti ʋɛɛ seɠe ʋɛlɛ ɲadegai ɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tanda ɠilagi zakpai ɠa ɠɛ ga mɛtɛlɛ puugɔ maazu lɔɔlugɔ (15), kogi ɠɛ ga mɛtɛlɛ felegɔ. Kɔɠɔgi ɠa ɠɛ ga ani ɠila nɔ tanda puugɔ maazu ɠilagiti (11) bɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ɗa tanda lɔɔlugɔiti giliɠili ɓɔɠɔ ʋa, ta è zɔ lɔzitaiti giliɠili ɓɔɠɔ ʋa. Ɗa tandai lɔzitasiɛi ʋɛɛ su fele seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ɗa galu ʋuulɔɔlugɔ (50) ɠiliɠili tandai ma ɓɔsu mɔungi laamaʋɛ, ɗa galu ʋuulɔɔlugɔ (50) ɓalaa giliɠili tandai ma ɓɔsu velesiɛi laamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ɗa kɔlu ɓɔi kala puulɔɔlugɔ (50) ɓɛtɛ, è kalagiti dɔ galuiti unsu. Ɗa tanda ma ɓɔsuiti sei ɓɔɠɔ la ɠana, ti ɠɛ ga ani ɠila nɔ. ");
INSERT INTO tod_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Seɠe ʋɛlɛi ma landaiti ta ʋaazu ʋooʋazu ma ga ta tukpɛ, naa ɠa yei, é ʋu ga seɠe ʋɛlɛ ɲadegai ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Mɛtɛlɛ ɠaaɠwɛsui é yɛsu kakamaʋɛ gilazu ʋelei, ta mɛtɛlɛ ɠaaɠwɛsui é yɛsu zɔɔla ʋelei, niiti ti yɛsu ʋolu seɠe ʋɛlɛi zakpai ma, naati ka ti yeizu seɠe ʋɛlɛ ɲadegai ɠakama felegɔiti, ti ʋɛɛ ma. ");
INSERT INTO tod_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ɗa baala sinɛ ɠɔlɔiti kpɛtɛ ga pɛɛmazeɠei, toai ga ma ɓɔigi, seɠe ʋɛlɛi vaa zu, è ziɛ wu zua ɠɔlɔiti ma ʋɛɛmazeɠei ʋɛɛ maazu. ");
INSERT INTO tod_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ɗa seɠe ʋɛlɛi zuzo guluiti kpɛtɛ seɠe ʋɛlɛ ɲadegai ʋɛ ga akasia wuluiti. ");
INSERT INTO tod_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Seɠe ʋɛlɛi zuzo gului zɔligɔi ɠa ɠɛ ga mɛtɛlɛ lɔɔlugɔ, kogi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Seɠe ʋɛlɛi zuzo gului ɠilagilagi pɛ kpadɔzuʋɛ ɠaa ɠa zoɓa ma wulu felegɔi ʋa. Zekana ɗa kɛ la seɠe ʋɛlɛ ɲadegai zuzo guluiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ɗa seɠe ʋɛlɛi zuzo gulu ʋuufelegɔ (20) ɓɛtɛ seɠe ʋɛlɛ ɲadegai ʋɛ, ti ɠɛɛzu nu yeezazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ɗa dabu ʋuunaanigɔiti (40) kpɛtɛ ga walii, ti ʋa la seɠe ʋɛlɛi zuzo gulu ʋuufelegɔiti (20) gilagilagi wu, kpadɔzu felegɔiti bɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ɗa seɠe ʋɛlɛi zuzo gulu ʋuufelegɔ (20) ɓɛtɛ ɓalaa seɠe ʋɛlɛ ɲadegai ʋɛ, nu ɠɔʋɛzu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ɗa dabu ʋuunaanigɔiti (40) kpɛtɛ ɓalaa ga walii, ti ʋa la seɠe ʋɛlɛi zuzo gulu ʋuufelegɔiti (20) gilagilagi wu, kpadɔzu felegɔiti bɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ɗa seɠe ʋɛlɛi zuzo gulu lɔzita ɓɛtɛ seɠe ʋɛlɛ ɲadegai ɓogaʋɛ, folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ɗa seɠe ʋɛlɛi zuzo gulu felegɔ ɓɛtɛ seɠe ʋɛlɛ ɲadegai ma zoko felegɔiti bɛ, ti kpogaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ta ɠili seɠe ʋɛlɛi zuzo gului zɔiti ba, é zo buuʋɛ, é zeeli bala mɔungi ma ungaʋɛ. Ʋele ɠana a ɠɛ la ga ti felegɔ, ti ʋilɛgai soko felegɔiti su. ");
INSERT INTO tod_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Seɠe ʋɛlɛi zuzo gulu lɔsaʋa ɠa naazu, é ɠɛɛzu seɠe ʋɛlɛ ɲadegai ɓogaʋɛ, é ʋɛɛ ta-labu puugɔ maazu lɔzitaiti (16) ba, ti ɓɛtɛai ga walii, seɠe ʋɛlɛi zuzo gulu ɠila dabu felegɔ. ");
INSERT INTO tod_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ɗa gulu zɔkpɔ lɔɔlugɔ ɓɛtɛ seɠe ʋɛlɛi zuzo guluiti bɛ ga akasia wului, ti ɓesa seɠe ʋɛlɛ ɲadegai ɠakamaʋɛ ɠilagi, ");
INSERT INTO tod_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ta gulu zɔkpɔ lɔɔlugɔ seɠe ʋɛlɛ ɲadegai ɠakamaʋɛ zɔɔla ʋelei zuzo guluiti bɛ, ta gulu zɔkpɔ lɔɔlugɔ seɠe ʋɛlɛ ɲadegai ɓogaʋɛ zuzo guluiti bɛ, folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Zaamazu wulu zɔkpɔi ɠa seɠe ʋɛlɛi zuzo guluiti maaleʋe, é zo kwɛgi ma, é li zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ɗa zanugi ziɛ seɠe ʋɛlɛi zuzo guluiti ma. Ɗa ta-ʋalaiti kpɛtɛ ga zanugi, ga gulu zɔkpɔiti ti lɔ ti zu. Ɗa zanugi ziɛ naama wulu zɔkpɔiti ma. ");
INSERT INTO tod_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ɗa seɠe ʋɛlɛ ɲadegai lo, eɠɛʋelei ma ɠazaʋigi lɛɛni la ga ɗe gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Ɗa kwɛpele seɠezuɠoozagi ɓɛtɛ ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ɗa suʋu ga seeluɓɛinti baaɠulabai. ");
INSERT INTO tod_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Toɠa zɛlɛ ga zanu kalagiti ti tɔkpala naanigɔiti ba, ti ɓɛtɛai ga akasia wului, zanugi ziaai ti ma, ti ɓadɔai dabu naanigɔiti ma, niiti ti ɓɛtɛai ga walii. ");
INSERT INTO tod_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ɗa kwɛpele seɠezuɠoozagi zɛlɛ kalagiti buuʋɛ. Kwɛpele seɠezuɠoozagi ɠoozu ʋelei, miná ɠa ɗa zeele woo ɠesui lɛ ná. Kwɛpele seɠezuɠoozagi ɠa ɠɛ wo ʋɛ ga ada ɲadegai ta ada ɲadega wolai ti yeeɠaaɠwɛɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Ɗa zeele woo ɠesui laaɠulu, ada ɲadega wolai ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ɗa taɓalii ʋilɛ kwɛpele seɠezuɠoozagi ɠakalaʋɛ, seɠe ʋɛlɛ ɲadegai wu, lɛkpɛmaʋɛ nu ɠɔʋɛzuʋɛ. Fitina zei anii ɠɛ taɓalii letemaʋɛ, lɛkpɛmaʋɛ nu yeezazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ɗa kwɛpele seɠezuɠoozagi taɠili kpɛtɛ seɠe ʋɛlɛi laaʋɛ ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, é ɠɛ ga seɠe zuʋuai. ");
INSERT INTO tod_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Toɠa zɛlɛ ga zanu kalagiti ti tɔkpala lɔɔlugɔiti ba, ti ɓɛtɛai ga akasia wului, zanugi ziaai ti ma. Ɗa kɔlu ɓɔigi ɠaawuun, é ɠɛ ti ʋɛ ga ta-labu lɔɔlugɔiti. ");
INSERT INTO tod_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ɗa zalaɠa ɠulazuʋɛ ɓɛtɛ ga akasia wului. Sakpai ɠa ɠɛ ga mɛtɛlɛ felegɔ ta tukpɛ (2,5), kogi ɠɛ ga mɛtɛlɛ felegɔ ta tukpɛ (2,5). Zalaɠa ɠulazuʋɛ ɠa ɠɛ ga seki naanigi, sɔligi ɠɛ ga mɛtɛlɛ ɠila ta tukpɛ (1,5). ");
INSERT INTO tod_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ɗa minɛiti kpɛtɛ goizu naanigɔiti ba, ma minɛiti ta ɓɔ ba, ti ɠɛ ga ani ɠila nɔ. Ɗa kɔlu ɓɔigi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ɗa aniɲakaiti kpɛtɛ zuʋui zo fai zu, ta pɛluiti, ta ɲama vaza aniɲakaiti, ta sua zɔɔ mitɛ wolaiti, ta abu zeɠe aniiti. Ɗa sɔɔlai naati kpein kpɛtɛ ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ɗa kɔlu vɛlɛai ɓɛtɛ ga kɔlu ɓɔigi zalaɠa ɠulazuʋɛ. Ɗa kɔlu ɓɔi balaiti to kɔlu vɛlɛai ʋa, goizu naanigɔiti su. ");
INSERT INTO tod_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ɗa pilɛ zalaɠa ɠulazuʋɛ lakɔlɔgaʋɛ wu, é zo buuʋɛ, eyɛsu é zeeli zalaɠa ɠulazuʋɛ zɔligɔi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ɗa gulu zɔkpɔiti kpɛtɛ zalaɠa ɠulazuʋɛ ʋɛ, ga akasia wului, è kɔlu ɓɔigi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Gulu zɔkpɔiti ta lɔ balaiti su. Gulu zɔkpɔi naati ta ɠɛ zalaɠa ɠulazuʋɛ ɠakama felegɔiti, siɛgi zu a ɠɛna ʋa zeɠezu la. ");
INSERT INTO tod_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ɗa zalaɠa ɠulazuʋɛ ɓɛtɛ ga gulu zɛʋɛiti, zeɠei ɠɛ koozu. Toɠa ɠɛ eɠɛʋelei é lɛɛni la ga ɗe gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ɗa seɠe ʋɛlɛ ɲadegai ma ɠoizuʋɛ ɓɛtɛ. Lɛkpɛmaʋɛ nu yeezazuʋɛ, maazasa ga seɠei é ga geze ʋagɔi kpaliai. Sasai zakpai ɠɛ ga mɛtɛlɛ ʋuulɔɔlugɔ (50) naama ɠakama mɔungi. ");
INSERT INTO tod_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Tɔkpala ʋuufelegɔiti (20) ta lɔ dabu ʋuufelegɔiti (20) ga, ti ɓɛtɛai ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti ta ɠɛ ga walii. ");
INSERT INTO tod_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Lɛkpɛmaʋɛ nu ɠɔʋɛzuʋɛ, sasai zakpai ɠa ɠɛ miná ɓalaa ga mɛtɛlɛ ʋuulɔɔlugɔ (50), naa ɠɛ ga seɠei, ta tɔkpala ʋuufelegɔiti (20), ta ta-labu ʋuufelegɔiti (20), ti ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti ta ɠɛ ga walii. ");
INSERT INTO tod_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Folo liizu ʋelei, sasai ɠogi ɠa ɠɛ ga mɛtɛlɛ ʋuufelegɔ maazu lɔɔlugɔ (25), naa ɠɛ ga seɠei, ta ta-lɔkpala puugɔ ta ta-labu puugɔiti. ");
INSERT INTO tod_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Folo ɠulazu ʋelei, sasai ɠogi ɠa ɠɛ ga mɛtɛlɛ ʋuufelegɔ maazu lɔɔlugɔ (25). ");
INSERT INTO tod_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Nu lɛɛzuʋɛ ɠobaʋɛ ɠilazuʋɛ, sasai ɠa ɠɛ ga mɛtɛlɛ lɔfela ta tukpɛ (7,5), naa ɠɛ ga seɠei, ta tɔkpala saʋagɔ, ta ta-labu saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Nu lɛɛzuʋɛ ɠobaʋɛ zɔɔla ʋelei, sasai ɠa ɠɛ miná ga mɛtɛlɛ lɔfela ta tukpɛ (7,5), naa ɠɛ ga seɠei, ta tɔkpala saʋagɔ, ta ta-labu saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Sasai laaʋɛ vaa zu, kwɛpele seɠezuɠoozagi ɠa ɠɛ ga mɛtɛlɛ puugɔ, é ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, suʋuai, ta tɔkpala naanigɔ, ta ta-labu naanigɔiti. ");
INSERT INTO tod_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Sasai ma lɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti kpein ta ɠɛ ga walii. Ta-labuiti kpein ta ɠɛ ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Sasai zakpai ɠa ɠɛ ga mɛtɛlɛ ʋuulɔɔlugɔ (50), kogi ɠɛ ga puufelegɔ maazu lɔɔlugɔ (25), sɔligi ɠɛ ga mɛtɛlɛ felegɔ ta tukpɛ (2,5). Seɠeiti ta ɠɛ ga geze ʋagɔi kpaliai, ta dabuiti ta ɠɛ ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Sɔɔlai kpein deveai seɠe ʋɛlɛ ɲadegai ma wotii vaa ma, ta suzo kɔluiti kpein, ta sasai zuzo kɔluiti kpein ta ɠɛ ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ɗa devei ve Izilayɛle nuiti zea, ga ti ʋa è ʋɔ ga wolive wulɔ ʋagɔi, kpɛtɛai fitinai vaa zu, naa ɠa a kɛ wo yeeyɛ fitinaiti ba, yeenɔpɛ ti mina za. ");
INSERT INTO tod_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","GALA daaɠomi seɠe ʋɛlɛi wu, kwɛpele seɠezuɠoozagi ɠakalaʋɛ, nii é zeele woo ɠesui ɠakalaʋɛ. Miná ɠa Aalɔn ta ná-doun zunuiti ta sei ná, fitinaiti ti zo, é zo kpɔkɔi ma, eyɛsu geelaalao, Ɠɔoɠɔ GALAGI ɠaazu. Toɠa ga ɠɔoɠɔ tɔgi Izilayɛle nuiti ti-mavofodaiti kpein bɛ, ti maanɛai, ti so. ");
INSERT INTO tod_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Ɗa è-liɛ Aalɔn maaɓuɠa ɓɔɠɔ ʋa, ta ná-doun zunuiti, ti zeɠe Izilayɛle nuiti saama, ga è ti ve bɛ̀, nà-boti vai zu, é ga zalaɠa ɠula vai, Aalɔn ta ná-doun zunuiti, Nadaɓe ta Aɓiyu, ta Eleazaal ta Itamaal. ");
INSERT INTO tod_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ɗa zalaɠa ɠula zeɠeiti kpɛtɛ è-liɛ Aalɔn ʋɛ, ti ɠɛ ga tosuʋɛ ta ná-lɛbiyai ma ʋoogi. ");
INSERT INTO tod_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ɗa ɓɔɛ naati kpein pɔ, ti ga ɲɛɛliɠi nuiti, niiti gè ti laavegai ga ɠima yɛnvui, ta Aalɔn ná-seɠeiti kpɛtɛ, naa ɠa a kɛ é ve bɛ̀, é nà-zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Wɛlɛ seɠeiti ba, ta ti ɓɛtɛ: kakazu zeɠe ɠila, zalaɠa ɠula zeɠe ɠila, tookɔba wola ɠila, seɠewuzeɠe ɠila nii suʋuai, bɔɔlɔ gila, ta saamaɠili gila. Ta zalaɠa ɠula zeɠe ɲadegaiti kpɛtɛ è-liɛ Aalɔn ta ná-doun zunuiti bɛ, naa ɠa a kɛ ti nà-zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ta zanugi zeɠe ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ta zalaɠa ɠula zeɠei ɓɛtɛ ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ta suʋu ga zanu galui. ");
INSERT INTO tod_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Ta kpakiga zeɠe felegɔiti kpɛtɛ, ti zei zalaɠa ɠula zeɠei ɠaaɓelasu felegɔiti da. ");
INSERT INTO tod_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Zalaɠa ɠula zeɠei ma lokoi ɠa ɓɛtɛ ga ma zii nɔ. Toɠa ɠɛ ga zanugi, ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ta ɠɛ ga ani ɠila ta zalaɠa ɠula zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Kɔtu zɔngɔ ɓaagi nii daaseigi ga wonikese, ɗa naa felegɔ zeɠe, è Izilayɛle ná-doun zunuiti daaseigiti sɛʋɛ ti ma, ");
INSERT INTO tod_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ti-laasei dɔzita ɠa zɛʋɛ kɔtu ɠilagi ma, zɔɔma laasei dɔzitaiti ti ɠɛ kɔtui velesiɛi ma, eɠɛʋelei ti zɔlɔɔ pelei la. ");
INSERT INTO tod_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ɗa Izilayɛle ná-doun zunuiti daaseigiti sɛʋɛ kɔtu felegɔiti ma, eɠɛʋelei nu a ɗa kɔtui zaɠa la, eɠɛ zeeʋozɛba aniiti. Ɗa ti ɓata ti-lɔɔzuʋɛti ba, ti ga zanugi. ");
INSERT INTO tod_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ɗa ti ɠili zalaɠa ɠula zeɠei ma ɓakiga zeɠeiti ba, ti ɠɛ ga Izilayɛle ná-doun zunuiti ta-ɠizɛsui, nii Aalɔn seɠezu ɓaki felegɔiti ga, ga ti-laaseigi Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ɗa dɔɔzuʋɛti felegɔ ɓɛtɛ ga zanugi. ");
INSERT INTO tod_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ɗa zanu galu felegɔiti fɛlɛ, è ti lo dɔɔzuʋɛti ba. ");
INSERT INTO tod_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Ɗa kakazu zeɠei ɓɛtɛ, nii deveiti ti zeɠezu la, ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ɗa suʋu ga zanu galui, ga zalaɠa ɠula zeɠei ɠɛʋelei. ");
INSERT INTO tod_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kakazu zeɠei ɠa ʋɛɛ su fele, é ɠɛ ga seki naanigi. Sakpai ɠɛ ga zeelo gila, kogi ɠɛ ga zeelo gila. ");
INSERT INTO tod_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ɗa kɔtu zɔngɔ ɓaagiti ɲɛkpɛ ba, ma ɲɛkpɛ naanigɔi zu: ma ɲɛkpɛ mɔungi zu, saaledowane gila, topaze gila, ta emelɔde gila, ");
INSERT INTO tod_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ma ɲɛkpɛi velesiɛi zu, gelenate gila, safiil gila, ta diama ɠila, ");
INSERT INTO tod_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ma ɲɛkpɛi zaʋasiɛi zu, wɔpale gila, agate gila, ta ametisete gila, ");
INSERT INTO tod_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ma ɲɛkpɛi naanisiɛi zu, kelizolite gila, wonikese gila, ta zasepe gila. Naama ɠɔtu zɔngɔ ɓaagiti ta ɓata ti-lɔɔzuʋɛti ba, ti ga zanugi. ");
INSERT INTO tod_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ɗa Izilayɛle ná-doun zunuiti daaseigiti sɛʋɛ kɔtu puugɔ maazu felegɔiti (12) ma, eɠɛʋelei nu a ɗa kɔtui zaɠa la, eɠɛ zeeʋozɛba aniiti. Boloda puugɔ maazu felegɔiti (12) daaseigiti ta ɠɛ ti ma, kɔtu ɠila, gila daasei, kɔtu ɠila, gila daasei. ");
INSERT INTO tod_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ɗa zanu galuiti to kakazu zeɠei ʋa, ti vɛlɛai ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ɗa zanu balaɠae felegɔiti kpɛtɛ, è ti lo kakazu zeɠei woizu felegɔiti ba. ");
INSERT INTO tod_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ɗa zanu galu felegɔiti to balaɠae felegɔiti ba, kakazu zeɠei woizu felegɔiti. ");
INSERT INTO tod_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ɗa zanu galu felegɔiti sokpaiti to dɔɔzuʋɛti felegɔ ʋa, niiti ti ɠiliai zalaɠa ɠula zeɠei ma ɓakiga zeɠe felegɔiti ba, nii a kɛ kakazu zeɠei yɛ ʋelelaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ɗa zanu balaɠae felegɔ ɓɛtɛ mɔnɔ, è ti lo kakazu zeɠei woizu felegɔi zɔiti ba, koozu ʋelei, ná ʋɛɛzu zalaɠa ɠula zeɠei ma. ");
INSERT INTO tod_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ɗa zanu balaɠae felegɔ ɠiligaa ɓɛtɛ, è ti lo zalaɠa ɠula zeɠei ma ɓakiga zeɠe felegɔiti ba, buuʋɛ, ʋelela ʋelei, ti-lodazuʋɛ ɠobaʋɛ, zalaɠa ɠula zeɠei ma lokoi maazu. ");
INSERT INTO tod_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kakazu zeɠei ná-balaɠaegiti ta ɠili zalaɠa ɠula zeɠei ná-balaɠaegiti ba, ga galu ɓiinii, naa ɠa a kɛ, kakazu zeɠei ɠɛ zalaɠa ɠula zeɠei ma lokoi maazu, ti yeeɠaa mina ɠwɛ ta zalaɠa ɠula zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Siɛgi zu Aalɔn lɛɛzu la ada ɲadegai, Izilayɛle ná-doun zunuiti daaseigi ɠa ɠɛ ziilaʋɛ, sɛʋɛai kakazu zeɠei ma, nii deveiti ti zeɠezu la, ga é ma ɠizɛsui makɛ yeenɔpɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Anii niiti ti-laaseigi ga wuulimegi ta tumimegi, naati pu kakazu zeɠei zu, nii deveiti ti zeɠezu la, ti ɠɛɛzu Aalɔn yiilaʋɛ, siɛgi zu é lɛɛzu la Ɠɔoɠɔ GALAGI ɠaazu. Ʋele ɠana Aalɔn a pɛɛ la yiilaʋɛ yeenɔpɛ, nii a kɛ é ɠɛ Ɠɔoɠɔ GALAGI yiima vai ɠwɛɛ, é lo Izilayɛle nuiti ba. ");
INSERT INTO tod_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ɗa zalaɠa ɠula zeɠei ma lookɔba wolai ɠɛ ga geze ɓiinii, ");
INSERT INTO tod_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ɗa kɔteʋe zaamazuʋɛ, nɔungi ɗa lɔ ná, è daaɠale é ɠaku ma ga seɠe vɛlɛai taɠili, naa ɠa a kɛ é mina ʋali ga. ");
INSERT INTO tod_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Gului nii daa ga gelenadegi, ɗa naama waai maaniinigi ɠili daamaʋɛ, é ɠaku ma ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, zanu tala koiti ti ɠɛ ti yɔɠɔzuʋɛti, ");
INSERT INTO tod_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","zanu tala ko ɠila, gelenade gila, zanu tala ko ɠila, gelenade gila, naa ɠaku tookɔba wolai laamaʋɛ ma. ");
INSERT INTO tod_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aalɔn ɠa ɓɔɠɔ maaɠili la, é ɗa botii ɠɛ, tala koiti gooi ɠa ɠɛ mɛnisu, siɛgi zu é lɛɛzu la ada ɲadegai, Ɠɔoɠɔ GALAGI ɠaazu, ta siɛgi zu é ɠulazu la ná, é la zaa názu. ");
INSERT INTO tod_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Ɗa zanu kitei ma zɛʋɛ goi ɓɛtɛ, è sɛʋɛi ɠɛ ma ga: «Feai Ɠɔoɠɔ GALAGI ʋɛ». Sɛʋɛai eɠɛʋelei nu a ɗa zeeʋozɛba anii maazaɠa la. ");
INSERT INTO tod_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ɗa gili bɔɔlɔgi ʋa ga galu ɓiinii, kakala ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Toɠa ɠɛ Aalɔn loʋalaʋɛ yeenɔpɛ, siɛgi zu é losu la gàazu, nɛ̀i gè ga Ɠɔoɠɔ GALAGI. Naa maaʋele ma, nà yeezei Izilayɛle nuiti ta-vebɛani ɲadegaiti bu, anɛɛ ni ta faaɠaazagiti kɛɛzu, ta ɠɛna ti vea zèa. ");
INSERT INTO tod_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Seɠewuzeɠei ta bɔɔlɔgi ɓɛtɛ ga geze ʋagɔi, è saamaɠiligi ɓɛtɛ, è suʋu. ");
INSERT INTO tod_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ɗa seɠewuzeɠeiti kpɛtɛ Aalɔn ná-doun zunuiti bɛ, è saamaɠiligiti kpɛtɛ ti ʋɛ, è bɔɔlɔgiti kpɛtɛ ti ʋɛ, ti ɠɛ ga ti-losuʋɛ ta ta-lɛbiyai ma ʋoogi. ");
INSERT INTO tod_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ɗa è-liɛ Aalɔn ta ná-doun zunuiti maaɠili la. Ɗa gulɔi ziɛ ti ma, è ti ve bɛ̀, è ti ɲade, naa ɠa a kɛ ti nà-zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ɗa ʋɛlɛ kpuɠagi ɓɛtɛ ti ʋɛ ga gezei, é ti maaɲakaiti dɔɔɠu, toɠa zo ti-zaamaʋɛ, é yei ti-ɓalaiti ma. ");
INSERT INTO tod_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aalɔn ta ná-doun zunuiti ta ti lɛ ɓɔɠɔ ma, siɛgi zu ti lɛɛzu la GALA daaɠomi seɠe ʋɛlɛi wu, ɓaa siɛgi zu ti maaɓuɠazu la zalaɠa ɠulazuʋɛ ʋa, ti ʋa botii ɠɛ ada ɲadegai, naazu ti la ɠɛa ga sɔba nua ɲɛgɛlɛin, ta ti la zaa. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi Aalɔn ʋɛ ta mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Wɛlɛ, nii ɗa kɛ, Aalɔn ta ná-dointi fee vai zu bɛ̀, naa ɠa a kɛ ti nà-zalaɠa ɠula wotii ɠɛ. Nikɛ zinɛ ɓokpa gila seɠe, ta baala sinɛ felegɔ, nɛɛʋuzu mina ɠɛ ti ʋa, ");
INSERT INTO tod_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ta ɓului nii lɛʋɛ la su, ta ɓulu ʋɛlɛʋɛlɛgiti lɛʋɛ la su, gaayɔgai ga gulɔi, ta ɓulu lɛɛvɛiti, lɛʋɛ la su, gulɔi ʋuai ma, è ti ɓɛtɛ ga ɓulu vukɔ ʋagɔi. ");
INSERT INTO tod_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ɗa ti ʋu kpɔlɔ gila su, è ʋa ga tiye kpɔlɔgi naa zu, è ti lɛ, ɗa ɠɛna nikɛ zinɛi ta baala sinɛ felegɔiti kulaa ga zalaɠai. ");
INSERT INTO tod_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ɗa li ga Aalɔn ta ná-doun zunuiti GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, è ti maagba ga ziɛi. ");
INSERT INTO tod_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ɗa seɠeiti seɠe, è Aalɔn maaɠili ga seɠewuzeɠei, ta tookɔba wolai, ta zalaɠa ɠula zeɠei, ta kakazu zeɠei, è saamaɠili ga zalaɠa ɠula zeɠei ma lokoi. ");
INSERT INTO tod_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ɗa bɔɔlɔgi lɔ nɔungi ʋa, è zanu sɛʋɛ goi ɠili kakalaʋɛ, nii é ga fee vai ma ʋoogi GALA bɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","È siɛma wulɔ ɲadegai zeɠe, è ta ʋu nɔungi zu, è ta ziɛ ma. ");
INSERT INTO tod_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ɗa ʋa ga ná-doun zunuiti, è ti maaɠili ga seɠewuzeɠeiti. ");
INSERT INTO tod_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ɗa ti zaamaɠili ga saamaɠiligiti, è bɔɔlɔgiti dɔ tɔungiti ba. Ta nà-zalaɠa ɠula wotii ɠɛ, tɔgi ɠana eyɛsu ɠɔ. Ɗa Aalɔn ta ná-doun zunuiti fe bɛ̀. ");
INSERT INTO tod_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ɗa ʋa ga nikɛ zinɛ ɓokpagi GALA daaɠomi seɠe ʋɛlɛi ɠakalaʋɛ, Aalɔn ta ná-doun zunuiti ti-yeeiti pɛɛ nikɛ zinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ɗa nikɛ zinɛi ɠɔdaaleʋe Ɠɔoɠɔ GALAGI ɠaazu, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ɗa nikɛ zinɛi ma ɲamai zeɠe, è ta ziɛ zalaɠa ɠulazuʋɛ ma minɛiti ma ga è-yeeɓeɠai. Ɗa ɲamai mɔtai ʋu ya zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ɗa ma wulɔi kpein seɠe, nii felevelegai koozu zɔɔlaiti ma, ta ma mɔɔin ʋasuʋɛ, ta ma lɔɠɔ felegɔiti ma, ta gulɔi é ti maaʋɛ ɲɛgɛlɛin, ɗa naa ɠala zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Kɛlɛ ɗa nikɛ zinɛi mɔtai ɠala wo-ʋuuzuʋɛ ʋoluʋɛ: ma zuai, ta ma ɠɔlɔi, naa ʋɛɛ ma ɓooiti ba. Toɠa ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Ɗa baala sinɛi taɠila seɠe, Aalɔn ta ná-doun zunuiti ta yeeiti pɛɛ baala sinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ɗa baala sinɛi ɠɔdaaleʋe, è ma ɲamai zeɠe, è pili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ɗa baala sinɛi leʋeleʋe, è kpulukpulu, è koozu zɔɔlaiti ta kɔɠɔiti gba, è ti la kpulukpulugai ta ma ungi ma. ");
INSERT INTO tod_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ɗa baala sinɛi pɛ gala zalaɠa ɠulazuʋɛ. Toɠa ga gala zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ɗa zɔɔma ʋaala sinɛi zeɠe. Aalɔn ta ná-doun zunuiti ta yeeiti pɛɛ baala sinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ɗa baala sinɛi ɠɔdaaleʋe, è ma ɲamai ta zeɠe, è siɛ Aalɔn yeezazu ʋele woi yɔkpɔgi ma, ta ná-doun zunuiti zeezazu ʋele woi yɔkpɔgiti ma, ta ti-yeezazu yeezinɛkpotogiti ma, ta ti-yeezazu ɠɔɠɔzinɛkpotogiti ma. Ɗa ɲamai mɔtai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ɗa ɲamai ta zeɠe, nii a ɠɛ zalaɠa ɠulazuʋɛ, ta siɛma wulɔ ɲadegai ta, è ti vaza Aalɔn ta ná-seɠeiti ma, naa ʋɛɛ ná-doun zunuiti ta ta-zeɠeiti ba. Pele ɠana ɗa Aalɔnni fe la bɛ̀, ta ná-seɠeiti, naa ʋɛɛ ná-doun zunuiti ta ta-zeɠeiti ba. ");
INSERT INTO tod_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ɗa baala sinɛi ma wulɔi zeɠe, ta ma wɔɔngi, ta ma wulɔi felevelegai koozu zɔɔlaiti ma, ta ma mɔɔin ʋasuʋɛ, ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, ta zeezazu ɓalai, mazɔlɔɔ toɠa ga ti zei vai ma ʋaala sinɛi. ");
INSERT INTO tod_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Ɓului lɛʋɛ la su, naama ɓɔlɔgi, nii seiɗai Ɠɔoɠɔ GALAGI ɠakala, ɗa ɓulu ɠila seɠe naama ɓɔlɔgi zu, ta ɓulu ʋɛlɛʋɛlɛ gila gulɔi ba, ta ɓulu lɛɛvɛ ɠila. ");
INSERT INTO tod_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ɗa ti kpein pu Aalɔn ta ná-doun zunuiti zeezu, ti ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Naa ʋoluma, ɗa ti ɠula niina ti ya, è ti ɠala zalaɠa ɠulazuʋɛ, gala zalaɠai maazu. Toɠa ga zalaɠai, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ɗa Aalɔn zei vai ma ʋaala sinɛi ma ɠekegi zeɠe, è datɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. Naa ɠa ɠɛ ga ɗɔnɔi. ");
INSERT INTO tod_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ɗa ti zei vai ma ʋaala sinɛi ma ɠekegi zeɠe ba ta ma ɓalai, niiti ti ɠula ga datɛɠɛ vai ma ʋoogi, ti zeɠe ba Aalɔn ʋɛ ta ná-doun zunuiti. ");
INSERT INTO tod_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ta ɠɛ ga Aalɔn ta ná-doun zunuiti tɔnɔ, naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi, nii Izilayɛle nuiti ta so, mazɔlɔɔ vebɛanii ɠana seɠeai ba Izilayɛle nuiti ta-yiilɛi zalaɠaiti su. Naa ɠa ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aalɔn a zaana, ná-zalaɠa ɠula zeɠeiti ta ɠɛ ga ná-doun zunuiti tɔnɔ, ta ti loo ɠɔba, siɛgi zu ti gulɔ ɲadegai ziɛzu la ti ma, ti zei vai zu. ");
INSERT INTO tod_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ná-doun zunuiti su, nii a ɠɛ potogi zu, zalaɠa ɠula vai zu, naa ɠa too ɠɔba folo lɔfela laawu, siɛgi zu é ɠɛɛzu lɛɛzu la GALA daaɠomi seɠe ʋɛlɛi wu, ga é botii ɠɛ ada ɲadegai. ");
INSERT INTO tod_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Ɗa ti zei vai ma ʋaala sinɛi zeɠe, è ma zuai ɠili ada ɲadegai ta. ");
INSERT INTO tod_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Baala sinɛi ma zuai ta ɓului a ɠɛ kpɔlɔgi zu, Aalɔn ta ná-doun zunuiti ti mi, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Nii kɛai ga koto gba anii, ta naa mi ɠana, naa ɠa a kɛ ti ve bɛ̀, ta ti ti zei. Nu ɠili nɔpɛ ge la ta mia, mazɔlɔɔ ti ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ni ti zei vai ma zalaɠa zuai ɓaa ma ɓului ta ɠa yɛna ná eyɛsu sobui, nu la mɔ mia ɲɛgɛlɛin, mazɔlɔɔ ti ɲadegɛ. Nii é yɛsu, ɗa naa ɠala. ");
INSERT INTO tod_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ɗa ziɛ ga deveiti kpein, gè ti vea è ya Aalɔn ta ná-doun zunuiti ta-vaa zu. Ɗa folo lɔfela ɠɛ ti zei vai zu. ");
INSERT INTO tod_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Folo-o-folo, ɗa nikɛ zinɛ ɠila kula ga zalaɠai koto gba vai zu. Ɗa zalaɠa ɠulazuʋɛ ɲade ga naama ɠoto gba vai, è gulɔi ziɛ ma ga é ɲade. ");
INSERT INTO tod_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Folo lɔfela laawu, ɗa koto gba vaiti kɛ zalaɠa ɠulazuʋɛ, é ɲade, zalaɠa ɠulazuʋɛ wola ɠa ɲade. Nii kpein a vɔɔɠu zalaɠa ɠulazuʋɛ ʋa, naa ɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Folo-o-folo, ɗa ɗa kona gila baala sinɛ felegɔ ɠula ga zalaɠai zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ɗa baala ziʋoi ɠilagi ɠula ga zalaɠai sobui, è zɔɔma ʋaala ziʋoi ɠula ga zalaɠai kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ɗa baala ziʋo mɔungi ɠula ga zalaɠai, è pɛɛ ɓulu vukɔ ʋagɔi kilo saʋagɔ ʋa, gaayɔgai ga wolive wulɔ ʋagɔi ma litɛlɛ ɠila ta tukpɛ (1,5), naa ʋɛɛ dɔɔi litɛlɛ ɠila ta tukpɛ (1,5) ba. ");
INSERT INTO tod_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ɗa baala ziʋoi velesiɛi ɠula ga zalaɠai kpɔkɔi, è pɛɛ vebɛ zalaɠai ʋa, ta puya zalaɠai, eɠɛʋelei sobu gelei la. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Toɠa ɠɛ ga gala zalaɠai, wo-mavofodaiti kpein ta ɠɛ kulazu folo-o-folo, gàazu, nɛ̀i gè ga Ɠɔoɠɔ GALAGI, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, miná ɠa nà ɠɛ ɠulazu ná kɛlɛma wo ʋɛ, gè ɗa ɓɔɛ è ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Miná ɠa nà ɠɛ ɠulazu ná kɛlɛma Izilayɛle nuiti bɛ, naama adaʋɛ ɠa ɲade ga nà-lɛbiyai. ");
INSERT INTO tod_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nà GALA daaɠomi seɠe ʋɛlɛi ta zalaɠa ɠulazuʋɛ ɲade. Nà Aalɔn ta ná-doun zunuiti ɲade, ti ɗa nà-zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Nà zei Izilayɛle nuiti saama, gè ɠɛ ga ta-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ta suɠwɛɛ naazu ga nà ɠa gè ga Ɠɔoɠɔ GALAGI, ta-ƓALAGI, nii é ti ɠulani Ezipete yooi ʋa, nà zei ti zaama. Nà ga Ɠɔoɠɔ GALAGI, ta-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ɗa zalaɠa ɠulazuʋɛ gila kpɛtɛ ansansegiti gala vai zu. Ɗa kpɛtɛ ga akasia wului. ");
INSERT INTO tod_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Toɠa ɠɛ ga seki naanigi, sakpai ɠɛ ga mɛtɛlɛ lukpɛgi, kogi ɠɛ ga mɛtɛlɛ lukpɛgi, sɔligi ɠɛ ga mɛtɛlɛ ɠila. Ma minɛiti ti ɠɛɛzu ba, ta ɠɛ ga ani ɠila. ");
INSERT INTO tod_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ɗa zanu kitei ziɛ ma, gaaʋɛ, ta kakamaʋɛti, é ɠaku ma, ta ma minɛiti ma ná pɛ. Ɗa daaɓegi ɓɛtɛ ga zanugi, é ɠaku ná pɛ ma. ");
INSERT INTO tod_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ɗa zanu bala felegɔ lo ba daaɓegi wuʋɛ, kakama felegɔiti, gulu zɔkpɔiti ti ɗa lɔ ti zu, seɠe vai zu. ");
INSERT INTO tod_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ɗa gulu zɔkpɔiti kpɛtɛ ga akasia wului, è zanugi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ɗa zalaɠa ɠulazuʋɛ lo kwɛpele seɠezuɠoozagi ɠakalaʋɛ, nii é zeele woo ɠesui ɠakalaʋɛ, kesui lakulugi ɠaazu letemaʋɛ, nii é zeele woo zɛʋɛi maazuʋɛ, ʋɛ nà ɠɛ ɠulazu kɛlɛma ná è ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Miná ɠa Aalɔn a ɗa ansansegiti gala ná. Toɠa ɠɛ ta ɠalazu sobu-o-sobu, siɛgi zu a ɠɛ fitinaiti kɛʋele ɓɛtɛzu la. ");
INSERT INTO tod_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aalɔn ɠa ɠɛ ta ɠalazu kpɔkɔi, siɛgi zu a ɠɛ fitinaiti kɛʋele ɓɛtɛzu la. Ansansegi ʋe, a ɠɛ ɠalazu yeenɔpɛ Ɠɔoɠɔ GALAGI ɠaazu, wo-mavofodaiti kpein su. ");
INSERT INTO tod_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","À mina ansanse ma zii ɠili kula ga zalaɠa, zalaɠa ɠulazuʋɛ, anɛɛ gala zalaɠa ɠili be, ɓaa vebɛ zalaɠa ɠili. À mina puya zalaɠa ɠila kpalaa pu ya ná. ");
INSERT INTO tod_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aalɔn ɠa ɗa koto gba vaiti kɛ zalaɠa ɠulazuʋɛ minɛiti maazu, ná ɠɛ ɠila kona-o-kona. Toɠa kɛ ga koto gba zuai ma ɲamai, ná ɠɛ ɠila kona-o-kona, wo-mavofodaiti kpein su. Zalaɠa ɠulazuʋɛ naa ɠa ɠɛ ga faa ɲadega wola Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Siɛgi zu è Izilayɛle nuiti gaalusu da, ti ɠilagilagi ta ɓɔɠɔ unmɔɔ ganii zala Ɠɔoɠɔ GALAGI ma, naa ɠa ɠɛ gaalugi ma ziɛgi zu, naa ɠa a kɛ maanɔɠɔ mina zeeli wo ma. ");
INSERT INTO tod_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Niiti kpein ti ɠaalusu, naati ta ʋaazu wali ɠaei galamu lɔzita veezu, eɠɛʋelei seizu ɲadegai ma wali ɠaei la. Naa ɠɛ ga vebɛanii, é zeɠe ba Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Nu-o-nu é ɠɛɛzu gaalugi zu, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, naa ɠa vebɛanii zala, nii é veezu Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Naavolo nui la salaa, é ʋa ʋooʋa ma, mɔnɛ nui ɓalaa la salaa, é ʋa yei bu. Vebɛani ʋe, é veezu Ɠɔoɠɔ GALAGI ʋɛ, ta-ɠotoiti gba vai zu. ");
INSERT INTO tod_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ɗa koto gba walii ɠula Izilayɛle nuiti zea, è dɔ GALA daaɠomi seɠe ʋɛlɛi ma wotii zu. Toɠa ɠɛ ga ɠizɛsu vaa Izilayɛle nuiti bɛ Ɠɔoɠɔ GALAGI ɠaazu, nuɓusɛiti ta-ɠotoiti gba vai zu.» ");
INSERT INTO tod_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ɗa maagba aniɲakai ɓɛtɛ ga kɔlu ɓɔigi, ná-seiga anii ɓalaa ɠa ɠɛ ga kɔlu ɓɔigi, maagba vaiti su. Ɗa pilɛ GALA daaɠomi seɠe ʋɛlɛi ta zalaɠa ɠulazuʋɛ ti yɔɠɔzuʋɛ, è ziɛi ʋu su. ");
INSERT INTO tod_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Naa ɠa Aalɔn ta ná-doun zunuiti ta ɠɛ yeeiti ta ɠɔɠɔiti maagbazu la. ");
INSERT INTO tod_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Siɛgi zu ti lɛɛzu la GALA daaɠomi seɠe ʋɛlɛi wu, ta ɓɔɠɔ maagba ga naama ɗɛi, naa ɠa a kɛ ti mina za, ta siɛgi zu ti maaɓuɠazu la zalaɠa ɠulazuʋɛ ʋa, ga ti botii ɠɛ, ti zalaɠaiti gala ga abui Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ta ti-yeeiti ta ti-ɠɔɠɔiti maagba, naa ɠa a kɛ ti mina za. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi, Aalɔn ʋɛ ta ná-doun zunuiti, ta ti-mavofodaiti kpein bɛ.» ");
INSERT INTO tod_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Ɗa ansanse papagiti seɠe: miile gulɔ maku nɛɛnɛgi kilo lɔzita, ta kanɛle maku nɛɛnɛgi kilo saʋagɔ, ta seeli kpaɠa maku nɛɛnɛgi kilo saʋagɔ, ");
INSERT INTO tod_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ta kasegi kilo lɔzita, eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi la, ta wolive wulɔi litɛlɛ lɔzita. ");
INSERT INTO tod_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ɗa naa ɠɛ ga siɛma wulɔ ɲadegai, eɠɛʋelei gulɔ maku nɛɛnɛ kpɛtɛ nui a ɗa kpɛtɛ la. Naa ɠa é ɠɛɛzu ga siɛma wulɔ ɲadegai. ");
INSERT INTO tod_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","«Naa ɠa ɗa ta ziɛ GALA daaɠomi seɠe ʋɛlɛi ma, ta zeele woo ɠesui, ");
INSERT INTO tod_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ta taɓalii ta ná-sɔɔlaiti, ta fitina zei anii, ta ná-sɔɔlaiti, ta ansansegiti ma zalaɠa ɠulazuʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ta è siɛ gala zalaɠaiti kulazuʋɛ ta ná-sɔɔlaiti kpein ma, ta maagba aniɲakai, é ʋɛɛ ná-seiga anii ʋa. ");
INSERT INTO tod_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ɗa niima aniiti kpein fe bɛ̀, ti wola ɠa ɲade, nii kpein a vɔɔɠu ti ʋa, naa ɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ɗa gulɔ ɲadegai ziɛ Aalɔn ta ná-doun zunuiti ma, è ti ve bɛ̀, naa ɠa a kɛ ti nà-zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Ɗa ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: ‹Naa ɠa ɠɛ bɛ̀ ga siɛma wulɔ ɲadegai, wo-mavofodaiti kpein su. ");
INSERT INTO tod_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Nu mina ta ziɛ ɓusɛi ma, ɲɛgɛlɛin. À mina ma zii ɓɛtɛ ga kɛʋele. Ɲadegɛ, wa ɗa pɛtɛ ga ɲade ganii. ");
INSERT INTO tod_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nu-o-nu a ma zii ɓɛtɛna, ɓaa é ta ziɛ nu ɠili ma, é la ga zalaɠa ɠula nu, naa ɓe ka leʋe ná-nuɓusɛiti ba.› » ");
INSERT INTO tod_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ansansegi naati seɠe, ti ɠɛ tie: setaketegi, ta wonikesegi, ta galeɓanumegi, ta gulu mana maku nɛɛnɛgi. ");
INSERT INTO tod_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Ɗa naa ɠɛ ga ansansegi, supuai, eɠɛʋelei gulɔ maku nɛɛnɛ kpɛtɛ nui a ɗa kpɛtɛ la, kpoloi ɠɛ ba. Toɠa ɠɛ ga ma ɠitei, é ɲade. ");
INSERT INTO tod_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ɗa kɛ ga ma vukɔi, è sei zeele woo ɠesui ɠakalaʋɛ, GALA daaɠomi seɠe ʋɛlɛi wu, ʋɛ nà ɠɛ ɠulazu kɛlɛma ná è ʋɛ. Toɠa ɠɛ wo ʋɛ ga anii gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","À mina ansanse kpɛtɛ ɓɔɠɔ ʋɛ ɲɛgɛlɛin ga nii ɠɛʋele, siɛma vaa zu. Wa pɛtɛ ga ani ʋe ɲadegai, makɛgai Ɠɔoɠɔ GALAGI ɠila kpe nɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nu nɔpɛ a naa ɠɛɠala ɓɛtɛna, ga é ɗa maku, naa ɓe ka leʋe ná-nuɓusɛiti ba.» ");
INSERT INTO tod_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Wɛlɛ, gè yiimazeɠeʋɛ ga Ɓɛsaleyɛle, nii é ga Uli ná-doun zunui, Ɠuul ná-dounloin, Zuda ná-bolodai zu. ");
INSERT INTO tod_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Gè daavegɛ ga GALA Zɛnvui, ta ɠimalai, ta keleɠelegi, ta soofaalai, botii ma zii kpein faa zu, ");
INSERT INTO tod_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","é zoo faiti kazaʋisu, é zanugi ɓɛtɛ, ta walii, ta kɔlu ɓɔigi, ");
INSERT INTO tod_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","é kɔtu zɔngɔ ɓaagiti saɠa, é ti ɲɛkpɛ ti-lɔɔzuʋɛti, é gului zaɠa, é botii ma zii kpein kɛ. ");
INSERT INTO tod_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Gè kpɔba nu ʋɛɛʋɛ ba, nii é ga Woɠoliyaɓe, Ayizamake ná-doun zunui, é ɠula Dan ná-bolodai zu. Gè keleɠelegi ʋuuʋɛ naati kpein ziimaʋɛ, niiti ti zoogai faa la, ga ti naa kpein kɛ, nii gè è leveai ma, ");
INSERT INTO tod_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","é zo GALA daaɠomi seɠe ʋɛlɛi ma, é li zeele woo ɠesui ʋɔ, ta dakulugi, ta seɠe ʋɛlɛi ma zɔɔlaiti kpein, ");
INSERT INTO tod_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ta taɓalii ta ná-sɔɔlaiti, ta fitinai zei anii é ga zanu kitei, ta ná-sɔɔlaiti kpein, ta ansansegiti ma zalaɠa ɠulazuʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ta gala zalaɠaiti kulazuʋɛ ta ná-sɔɔlaiti kpein, ta maagba aniɲakai ta ná-seiga anii, ");
INSERT INTO tod_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ta botiɠɛ zeɠeiti, niiti ti ga zalaɠa ɠula nui Aalɔn ná-zalaɠa ɠula zeɠeiti, ta ná-doun zunuiti ta-zeɠeiti zalaɠa ɠulazuʋɛ ma woti vai ma, ");
INSERT INTO tod_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ta siɛma wulɔ ɲadegai, ta ada ɲadegai ma ansansegi. Ta naa kpein kɛ, eɠɛʋelei gè deveai la.» ");
INSERT INTO tod_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: ‹Wa nà-dooɠo foloiti maaɲɛ, mazɔlɔɔ naa ɠa a ɠɛ nɔ̀un nà, ta wa, ade yɔɠɔzu, wo-mavofodaiti kpein saama, é ɠɛ ga poogi, nii nu a kwɛɛ la ga nà ga Ɠɔoɠɔ GALAGI, nii é wo ɲadesu. ");
INSERT INTO tod_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Wa dooɠo foloi maaɲɛ, mazɔlɔɔ toɠa ɠɛ wo ʋɛ ga faa ɲadegai. Zɔi a kɔzɔna, ta naama nui ʋaa. Nu nɔpɛ a boti ɠɛɛna naama voloi ma, naa ɓe ka leʋe ná-nuɓusɛiti ba, é ɠula ti zaama. ");
INSERT INTO tod_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Folo lɔzita laawu, nu ɠa boti ɠɛ, kɛlɛ foloi lɔfelasiɛi ɠa ɠɛ ga dooɠo foloi, feai Ɠɔoɠɔ GALAGI ʋɛ. Zɔi nɔpɛ a boti ɠɛɛna dooɠo foloi, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Izilayɛle nuiti ta dooɠo foloi maaɲɛ, tiya-o, ti-mavofodaiti-yo, é ɠɛ ga ɠɔoɠɔ minazeɠegi. ");
INSERT INTO tod_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Toɠa ɠɛ ga poogi, nà-o, Izilayɛle nuiti-yo, gi yɔɠɔzu, eyɛsu ɠɔ, mazɔlɔɔ folo lɔzita laawu, Ɠɔoɠɔ GALAGI geeɠɔlɔgi ta zooi ɓɛtɛni. Folo lɔfelasiɛi é ɓeni ná-botii ʋa, é looɠo.› » ");
INSERT INTO tod_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Siɛgi zu Ɠɔoɠɔ GALAGI ɓeni la ga ɓɔɛ Moize ʋɔ Sinayi gizei ma, é zeele woo ɠokolo felegɔiti feeni zea, kɔtu ɠokologiti, GALA ge sɛʋɛi ɠɛai ti ma ga tɔ ɓɔɠɔi zeeɓeɠai. ");
INSERT INTO tod_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Nuɓusɛiti ti kaai ma ga Moize lɛbiga, é la yeini, é ʋa zeɠe gizei ma fala, ti ɠaalɛɛni ba Aalɔn maaɠoolii zu, ti ɠɛ ma: «Wuzeɠena, è galagiti kpɛtɛ gi ʋɛ, ti lo gi luɠɔ, mazɔlɔɔ Moize nii, zunui tɛi é gi ɠulaai Ezipete yooi ʋa, gi la kwɛɛ nii kɛai la.» ");
INSERT INTO tod_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aalɔn ɠɛni ti ma: «À zanu goizu anigiti kula wo-anzaiti goizuʋɛti, ta wo-loun zunuiti goizuʋɛti, ta wo-loun anzanuiti goizuʋɛti, wo ʋa ga tiye pɔ̀.» ");
INSERT INTO tod_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Nuɓusɛiti kpein ti zanu goizu anigiti kulani woizuʋɛti, ti ʋa ga tiye Aalɔn ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","É yeezeini zanugi wu, ti feeni zea. É gaawuunni, é pu zanu kpɛtɛ ɠokologi zu, é kpɛtɛ ga nikɛ yiʋoi maaniinigi. Naa ʋolu, ti ɠɛni ma: «Izilayɛle nuiti, à wɛlɛ wa-ɠalagi ʋa, é wo ɠulaai Ezipete yooi ʋa.» ");
INSERT INTO tod_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Siɛgi zu Aalɔn miná ɠaani la, é zalaɠa ɠulazuʋɛ ta ɓɛtɛni nikɛ yiʋoi maaniinigi ʋɛ. É wooɠulani, é ɠɛ ma: «Fɛti wola ɠa ɠɛ ga lina Ɠɔoɠɔ GALAGI lɛbi vai ma!» ");
INSERT INTO tod_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ma ɠeelaalaogai ma, ti wuzeɠeni ga sobuzobui, ti gala zalaɠaiti ta ziilɛi zalaɠaiti kula. Nuɓusɛiti ti zeini, ti daamii ta kpɔɔlei wo. Naa ʋolu, ti wuzeɠeni, ti ɗa ɠaɠo. ");
INSERT INTO tod_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Yei, è li, mazɔlɔɔ ɗa-nuɓusɛiti, è ti ɠulani Ezipete yooi ʋa, ti ɓɔɠɔ ɠɔzɔa. ");
INSERT INTO tod_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ti zeɠea gaamago nɔ naama ʋelei ʋa, nii gè dɛai ga tiye. Ti nikɛ yiʋoi maaniinigi ɓɛtɛa ɓɔɠɔ ʋɛ, ga zanu gaawuungai, ti nɔkɔ bu, ti zalaɠaiti kula bɛ, ti ɠɛni ma: ‹Izilayɛle nuiti, à wɛlɛ wa-ɠalagi ʋa, é wo ɠulaai Ezipete yooi ʋa.› » ");
INSERT INTO tod_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nà kaazu ga niima nuɓusɛiti ta ga nuɓusɛiti ti zuvɔai. ");
INSERT INTO tod_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Niizu, zɛ̀ dɛɛ ná! Nà-ziiɠaawanai ɠa ʋaazu ti laalɔɠɔma, nà ti-ma zuwui ɠaaleʋezu, kɛlɛ nà è ɠɛɛzu ga zii wola.» ");
INSERT INTO tod_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moize ná-GALAGI maanɛɛnɛni, Ɠɔoɠɔ GALAGI, é ɠɛ ma: «Ee, Ɠɔoɠɔ GALAGI, lee vaa zu ɗa yiiɠaawanai ʋaazu ɗa-nuɓusɛiti daalɔɠɔma, niiti è ti ɠulaai Ezipete yooi ʋa, ga ɗa-zɛbɛ wolai, ta zeeɠaaɓaai? ");
INSERT INTO tod_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ni ɗa naa ɠɛɛna, Ezipete nuiti ta ɠɛ ma: ‹Ti maanɔɠɔ vai ɠa é ti ɠulaai ma, ga é ti ʋaa gizeiti su, é ti-ma zuwu ɠaaleʋe eteai zu.› Ɗa-yiiɠaawana wolai yɛ ná, è mina faa ɲɔu ɠɛ ga ɗa-nuɓusɛiti. ");
INSERT INTO tod_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ɠizɛ Abalaame zu, ta Izaake, ta Izilayɛle, ɗa-wotiɠɛ nuiti, niiti è ɠonani ɓɔɠɔ ma ti ʋɛ ga: ‹Nà wo-mavofodai mɔin eɠɛ geeɠɔlɔgi ma zomideɠaiti, zooi nii kpein gè ɓɔɛzu ná-faa zu, ga nà fe wo-mavofodai ya, ta sɔlɔɔ, é yɛ ti ya ɠɔ.› » ");
INSERT INTO tod_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ɠɔoɠɔ GALAGI zeɠeni faa ɲɔi ʋolu, nii é ɠɛni pɔ é kɛ ga ná-nuɓusɛiti. ");
INSERT INTO tod_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moize yeini, é zeɠe gizei ma, zeele woo ɠokolo felegɔiti ti zoni zea, sɛʋɛi ɠɛɛni ti-ɠakama felegɔiti, ti zɛʋɛni zɔɔla ʋele ta zɔɔla ʋele. ");
INSERT INTO tod_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","GALA ka é kokologiti kpɛtɛni, GALA ná-sɛʋɛ ɠɛai ɠa é ɠɛni ti ma, pɔnɛai kokologiti ma. ");
INSERT INTO tod_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Zozuwe nuɓusɛiti gooi mɛnini, ti ɗa zɔngɔ, é ɠɛ Moize ma: «Kɔɔ ɓee wooi ɠa nuiti puuzuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","É gooɠaaʋoteni, é ɠɛ ma: «Pilɛ sɔlɔɔ nua ta-ɓee woo laade, pilɛ sɔlɔɔtala nua ta-ɓee woo laade, guye woo ɠa gè mɛnisu.» ");
INSERT INTO tod_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tɛi é ɠɛni maaɓuɠazu ti-ʋuuzuʋɛ ʋa, é nikɛ yiʋoi ɠaani, nuiti ti ɠɛni kuai wosu. Moize wola yiiɠaawanani. É kɔtu ɠokologiti pilini zooi ma, é ti wolowolo gize ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","É nikɛ yiʋoi zeɠeni, nii ti kpɛtɛni, é gala. É fukɔni, é kɛ ga fufiligi, é ma vukɔi vaza ziɛi ɠa, é to Izilayɛle nuiti da, ti kpɔle. ");
INSERT INTO tod_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moize ɠɛni Aalɔn ma: «Leeni ɠa nuɓusɛiti ti kɛai ga ɗe, è ti yɛgai ná, ti niima ɠoto wolai ɠɛ?» ");
INSERT INTO tod_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aalɔn gooɠaaʋoteni ga: «Màliɠii, ná-ziiɠaawanai mina wɔɔlɔ. Ɗa ɓɔɠɔ è niima nuɓusɛiti kwɛɛ, faa ɲɔi ɠa ti polu. ");
INSERT INTO tod_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ti ɠɛni mà: ‹Galagiti kpɛtɛ gi ʋɛ, ti lo gi luɠɔ, mazɔlɔɔ Moize nii, zunui tɛi é gi ɠulaai Ezipete yooi ʋa, gi la kwɛɛ nii kɛai la.› ");
INSERT INTO tod_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Gè ɠɛni ti ma: ‹Niiti zanugi ti ya, ti kula ɓɔɠɔ ma.› Ti feeni zèa, gè pilini abui zu, niima nikɛ yiʋoi ɠulani su.» ");
INSERT INTO tod_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moize pɛtɛni ga nuɓusɛiti ti lɔɔni faazupui zu, Aalɔn ti yɛni faazupui naa zu, eyɛsu ti ɓɔɠɔ lɔ ti maayoseɠe nuiti ta-ɲɛɛɠulasui zu. ");
INSERT INTO tod_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moize loni ti-ʋuuzuʋɛ ma ʋɛlɛlaʋɛ, é ɠɛ ti ma: «À ʋa pɔ̀, wɔiti wo ga Ɠɔoɠɔ GALAGI nɔnɔiti!» Levi ná-bolodamaiti kpein ti ɠaalɛɛni ba koba. ");
INSERT INTO tod_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","É ɠɛni ti ma: «Ɠɔoɠɔ GALAGI, Izilayɛle ná-GALAGI wooi ɠaa: ‹Wo ɠilagilagi ná-boɠa zɔkpɔ la ɠoba, à leʋeteʋe nuiti puuzuʋɛ, wo lati naa ma, é zo zɔɔma ʋɛlɛlaʋɛ, é li zɔɔla ʋelei, ɛsɛ gilagilagi kɛɛɠɛloun ʋaa, ɓaa bɔɔlai, ɓaa ná-nui.› » ");
INSERT INTO tod_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levi nuiti ti kɛɛni, eɠɛʋelei Moize boni la, zunu waasaʋagɔ (3.000) ɠɛɠala ɠa é zaani nuɓusɛiti saama naama voloi. ");
INSERT INTO tod_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moize ɠɛni ma: «Za, wo vea Ɠɔoɠɔ GALAGI ʋɛ, mazɔlɔɔ wo ɠilagilagi la inɛinɛni ná-doun zunui ɓaa kɛɛɠɛloin ɠula vai zu ga zalaɠai, nii a kɛ é tuyai yei wo ma za voloi.» ");
INSERT INTO tod_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Poluma zobui, Moize ɠɛni nuɓusɛiti ma: «Wo koto wola ɠɛɛʋɛ. Nà ʋaazu lɛɛzu niizu Ɠɔoɠɔ GALAGI ʋɔ bɛ. Tanisu nà wa-ɠotoi ma zuvaayɛgi zɔlɔɔ.» ");
INSERT INTO tod_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moize ɠaleni ma Ɠɔoɠɔ GALAGI ʋɔ bɛ, é ɠɛ ma: «Ee! Niima nuɓusɛiti ti koto wola ɠɛɛʋɛ. Ti zanugi ɓɛtɛʋɛ ɓɔɠɔ ʋɛ ga galagi. ");
INSERT INTO tod_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Soma kae, è ta-ɠotoi zuvaayɛ! Ni naa laade, nà è maanɛɛnɛzu, dàaseigi ɠaaʋa, é ɠula ɗa-zɛʋɛi zu, è kɛai.» ");
INSERT INTO tod_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Zɔi é kotoi ɠɛai dàalɔɠɔma, naa ɠa nà daaseigi ɠaaʋa, é ɠula nà-sɛʋɛi zu. ");
INSERT INTO tod_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Li niizuʋɛ, è li ga nuɓusɛiti, ʋɛ gè ná lɛɛni ga ɗe. Wɛlɛ, nà-geezuɠeelai ɠa lo è luɠɔ. Kɛlɛ nà-potokula voloi, ta ta-ɠotoiti suɓoloi ɠɔmɔ.» ");
INSERT INTO tod_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ɠɔoɠɔ GALAGI nuɓusɛiti doɠani, tɔɔzei nikɛ yiʋoi ʋa, nii ti ɠɛni Aalɔn ma, é kpɛtɛ ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Li, zeɠe ʋɛ, ɗa-o, nuɓusɛiti-yo, niiti è ti ɠula Ezipete yooi ʋa. Lɛ zooi ʋɔ pelei, nii gè ma minazeɠeni ga nà feezu Abalaame ya, ta Izaake, ta Zakɔɓe, gè ɠɛ ma: ‹Nà feezu è-mavofodai ya.› ");
INSERT INTO tod_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nà geezuɠeelai ta leʋesu è luɠɔ, nà Kanaan nuiti kpɛɛzu è luɠɔ, ta Amool nuiti, ta Ɠɛte nuiti, ta Felɛze nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti. ");
INSERT INTO tod_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Lɛ naama yooi zu, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná. Kɛlɛ ade la lɛɛzu ʋɔɔma, gè mina wo undaaʋili pelei zu, mazɔlɔɔ wa ga suvɔ nuɓusɛiti.» ");
INSERT INTO tod_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Siɛgi zu nuɓusɛiti ti naama ɓɔɛ ɲɔiti mɛnini da, ti ɠaalɛini. Nu nɔpɛ ge la ɠɛni ɓɔɠɔ maaɠilini ga ná-sɔɔla ʋagɔ. ");
INSERT INTO tod_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɠɛ Izilayɛle nuiti ma: ‹Wa ga nuɓusɛiti ti zuvɔai. Ni gè lɛɛni wo zaama yeeɠɛɠala go laawu, nà la wo undaaʋili. Niizu, à wa-maaɠili zɔɔla ʋagɔiti kula ɓɔɠɔ ma, nà pɛtɛ, nii gè ʋaazu kɛɛzu wo ʋɛ.› » ");
INSERT INTO tod_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Izilayɛle nuiti ti maaɠoozaai ma Wolɛɓe gizei ʋa, ti la mɔ ɠɛni ta-maaɠili zɔɔla ʋagɔiti toozu ɠɔba. ");
INSERT INTO tod_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ta la ti-ʋuuzuʋɛ ɓɛtɛna, Moize ɓena seɠe ʋɛlɛ ɲadegai zeɠe, é to ti-ʋuuzuʋɛ ʋoluʋɛ, tago maaɠooza. É daasei pɛɛni ga GALA daaɠomi seɠe ʋɛlɛi. Nu-o-nu nii é ɠɛni pɔ ga é Ɠɔoɠɔ GALAGI ɠaazaɠa, naa ɠɛni ɠulazu, é li GALA daaɠomi seɠe ʋɛlɛi ʋɔ pelei, nii é ɠɛni ti-ʋuuzuʋɛ ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Siɛgi zu Moize ɠɛni liizu la seɠe ʋɛlɛ ɲadegai wu, nuɓusɛi kpein ge ɠɛni wuzeɠezu, ɛsɛ ge ɠɛni losu ná-seɠe ʋɛlɛi laaʋɛ, é ɠaazulo Moize ʋa, eyɛsu é lɛ seɠe ʋɛlɛ ɲadegai wu. ");
INSERT INTO tod_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Siɛgi zu Moize ɠɛni lɛɛzu la seɠe ʋɛlɛ ɲadegai wu, tonaɓiingi ɠɛni yeizu, é lo seɠe ʋɛlɛ ɲadegai laaʋɛ, Ɠɔoɠɔ GALAGI ɠɛni ɓɔɛzu Moize ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Nuɓusɛi kpein ge ɠɛni tonaɓiingi ɠaazu, é ɗa lo seɠe ʋɛlɛ ɲadegai laaʋɛ, naazu nuɓusɛi kpein ge ɓena wuzeɠe, é yɛ ná-seɠe ʋɛlɛi laaʋɛ, é nɔkɔ GALA bu. ");
INSERT INTO tod_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ɠɔoɠɔ GALAGI ɠɛni ɓɔɛzu Moize ʋɔ ɠaazuni ta ɠaazu, eɠɛʋelei nu a ɗa ɓɔɛ la bɔɔla ʋɔ. Naa ʋolu Moize ɓena ɠale ma ti-ʋuuzuʋɛ, kɛlɛ ná-botiɠɛ zunu loungoi Zozuwe, Nun ná-doun zunui la ɠɛni zeɠezu seɠe ʋɛlɛ ɲadegai ɠoozu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moize ɠɛni Ɠɔoɠɔ GALAGI ma: «Wɛlɛ, è ɠɛɛʋɛ mà: ‹Lo niima nuɓusɛiti tuɠɔ, è lɛ ga tiye,› ɗa ma, è la naama nui lɛɛni ga ze, nii gá li, é màaza! Anɛɛ naa ʋe, è ɠɛni mà: ‹Gè è ɠwɛɛ ga è-laaseigi, è zaalai zɔlɔɔgɛ gàazu.› ");
INSERT INTO tod_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Niizu, ni gè zaalai zɔlɔɔgɛ è ɠaazu, ɗa-ʋeleiti dɛɛna ga ze, naazu nà è ɠwɛɛ, gè zaalai zɔlɔɔ è ɠaazu mɔnɔ. Wɛlɛ, zii tɛi ka ga ɗa-nuɓusɛi.» ");
INSERT INTO tod_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ɠɔoɠɔ GALAGI gooɠaaʋoteni, é ɠɛ ma: «Nà losu è luɠɔ, nà ɓɔɠɔi. Nà dooɠo feezu è ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moize ɠɛni ma: «Ni ɗa ɓɔɠɔi è la losu gi luɠɔ, mina gi zeɠe ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Toɠa ɠwɛɛ ɠale ga gaama, ga gè zaalai zɔlɔɔgɛ è ɠaazu, nɔ̀un nà-o, ɗa-nuɓusɛiti-yo? Siɛgi zu laade, ade ziɛzu la ʋɔɔma, ta siɛgi zu nà-o, ɗa-nuɓusɛiti-yo, zɔɠɔzu ɠɛɛzu la gi ʋa ga nuɓusɛiti kpein ti eteai zu?» ");
INSERT INTO tod_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nà naa ɠɛ, nii è maaɠaazaɠaboga mà, mazɔlɔɔ è zaalai zɔlɔɔgɛ gàazu, gè è ɠwɛɛ ga è-laaseigi.» ");
INSERT INTO tod_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moize ɠɛni ma: «Soma kae, è ɗa-lɛbiyai lɛ ga ze!» ");
INSERT INTO tod_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ɠɔoɠɔ GALAGI gooɠaaʋoteni, é ɠɛ ma: «Nà leʋesu è ɠakalaʋɛ, gè nà-padai kpein dɛɛ ga ɗe, gè dàaseigi lɛ ga ɗe, nii é ga Ɠɔoɠɔ GALAGI. Nà zaalai la naa ma, nii gè pɔ gè zaalai la ma. Nà maawɔinɠai ɠɛ naa ʋɛ, nii gè pɔ gè maawɔinɠai ɠɛ bɛ.» ");
INSERT INTO tod_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","É ɠɛni ma mɔnɔ: «È la zooga è ʋa gàazuʋɛ ɠa, mazɔlɔɔ nui la zooga kàazu, é ʋa yɛ vulua.» ");
INSERT INTO tod_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ɠɔoɠɔ GALAGI ɠɛ ma: «Wɛlɛ adaʋɛ ta ʋa, kòbaʋɛ, ɗa lo fasai ma. ");
INSERT INTO tod_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Siɛgi zu nà-lɛbiyai leʋesu da, nà è lɔɔzu fasa yeɠei ta zu, gè è maalɔɔɠu ga zèei, eyɛsu gè leʋe. ");
INSERT INTO tod_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Naa ʋolu, nà yee ɠaaɠale ma niina, ɗa pòluʋelei ɠa, kɛlɛ gàazuʋɛ la zooga ɠaazu.» ");
INSERT INTO tod_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Kɔtu ɠokolo felegɔ zaɠa ga ma mɔungiti kɛʋele. Nà wooiti sɛʋɛzu naama ɠɔtu ɠokologiti ma, wooi niiti ti ɠɛni ma mɔungiti ma, niiti è ti wolowoloni. ");
INSERT INTO tod_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sobuzobui, ɠɛʋele ɓɛtɛ, sobui nɔ, è lɛ Sinayi gizei ma, ɗa losu náʋɛ kàkala, gizei unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nu nɔpɛ ge mina ʋilɛ è ʋolu, wo ʋa lɛ. Nu nɔpɛ ge mina ɓɔɠɔ lɛ gizei ma ná tanɔpɛ. Toganii ma go ɓaa ma wola mina ɓalaa daami wo gizei ma, ma lugi zu kpein.» ");
INSERT INTO tod_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moize kɔtu ɠokolo felegɔi zaɠani, eɠɛʋelei ma mɔungiti ti ɠɛni la. Moize wuzeɠeni sobuzobui, é lɛ Sinayi gizei ma, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la zea, é kɔtu ɠokolo felegɔiti seɠeni ya. ");
INSERT INTO tod_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ɠɔoɠɔ GALAGI yeini tonaɓiingi zu, é lo ná kobaʋɛ, é Ɠɔoɠɔ GALAGI laaseigi lɛɛni. ");
INSERT INTO tod_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Ɠɔoɠɔ GALAGI leʋeni kakalaʋɛ, é wooɠulani, é ɠɛ ma: «Ɠɔoɠɔ GALAGI, Ɠɔoɠɔ GALAGI, maawɔinɠa ƓALAGI, nii é zaalai veezu, zii la ɠula fala, kpɛtɛai nuɓɔɠɔlai ta wooɠɛɠiladai zu, ");
INSERT INTO tod_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","é wooɠɛɠiladai ɠɛɛzu, eyɛsu é zeeli yamani waagilasiɛi (1.000) ma, é faa ɲɔi zuvaayɛsu, ta tɔ koloɠologiti, ta kotoi, kɛlɛ é la sɔba nui zoga ga sɔbalala nu, a ɗa ɠɛɛɠɛiti ta-vaa ɲɔi ʋotokula ti-lointi ma, ta ti-lounlointi ma, eyɛsu é zeeli yamani zaʋasiɛi ta naanisiɛi ma.» ");
INSERT INTO tod_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moize zuvilɛni ga maaʋɛa zooi ma, é nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","É ɠɛni ma: «Màliɠii, ni gè zaalai zɔlɔɔgɛ è ɠaazu, ɠɛ gi zaama. Anɛɛ ni suvɔ nuɓusɛiti be, gá-vaa ɲɔiti suvaayɛ, ta gá-ɠotoiti, gi zeɠe, è gi ɠɛ ga ɗɔnɔ.» ");
INSERT INTO tod_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ɠɔoɠɔ GALAGI gooɠaaʋoteni, é ɠɛ ma: «Nà ɓɔɠɔ nà minazeɠegi ɠɛɛzu wo ʋɛ. Nà laavɔɔ vaiti kɛɛzu ɗa-nuɓusɛiti kpein gaazu, niiti ti ta la dɛ ɠɛɛni eteai zu ná tanɔpɛ, ziiti kpein saama. Nuɓusɛiti kpein wo zeini ti zaama, ta Ɠɔoɠɔ GALAGI ná-kɛɛwotii ɠa, kɛɛwotii nii maaluaai, nii nà kɛ ga è maaʋele. ");
INSERT INTO tod_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","«À dama ga devei gè feezu wo ya za. Nà ʋaazu Amool nuiti kpɛɛzu wo luɠɔ, ta Kanaan nuiti, ta Ɠɛte nuiti, ta Felɛze nuiti, ta Ɠeve nuiti, ta Yeɓuse nuiti. ");
INSERT INTO tod_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","À dama, wo mina minazeɠe kɛ zooi zu nuɓusɛiti bɛ, ʋɛ wo ʋaazu zeizu ná, naa ɠa a kɛ, ti mina ɠɛ ga balii wo zaama. ");
INSERT INTO tod_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Kɛlɛ, kɛni wo ta-zalaɠa ɠulazuʋɛti golo, wo ta-zale ɠɔtuiti kpezeɠele, wo ta-zale wuluiti teʋe ga. ");
INSERT INTO tod_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","À mina nɔkɔ gala kili bu, mazɔlɔɔ nà, nɛ̀i gè ga Ɠɔoɠɔ GALAGI, dàaseigi ɠa ga ‹nii toloai›. Nà ga tolo ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«À mina minazeɠe kɛ zooi zu nuɓusɛiti bɛ, naa ɠa a kɛ, ta koloɠologi ɠɛɛna ta ta-ɠalagiti, ti ti ɠɔ ga zalaɠaiti, ti mina wo loli, wo ʋa ta mi. ");
INSERT INTO tod_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","À mina ti-loun anzanuiti seɠe wo-loun zunuiti bɛ, ti-loun anzanuiti ta koloɠologi ɠɛɛna ta ta-ɠalagiti, ti mina wo-loun zunuiti maalɛlɛ ga ti ʋa ɗa naa ta ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«À mina kɔlui ɠaawuun, wo ʋa kpɛtɛ ɓɔɠɔ ʋɛ ga galagi. ");
INSERT INTO tod_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Ɓului nii lɛʋɛ la su, wa naama vɛtii makɛ, folo lɔfela laawu, molo ɠulasu ziɛgi ma yeeɠɛɠalai zu, teʋeai ba, wa ɓuluiti mi nii lɛʋɛ la su, eɠɛʋelei gè devei veeni la wo ya, mazɔlɔɔ molo ɠulasu alugi ma ɠa wo ɠulani la Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Doun mɔungi kpein ka ga nɔ̀nɔ, anɛɛ toganii ma yiʋo mɔungi ma zinɛi, é ɠɛni ga nikɛ yiʋo, ɓaa baala ziʋo. ");
INSERT INTO tod_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Wa soovale ziʋo mɔungi unmɔɔ ga baala ziʋoi. Ni wo la unmɔɔni, wa kɔtɔɠaʋɛ wolo. Wa zunu loun mɔungi kpein unmɔɔ. Nu nɔpɛ ge mina ɠula kɛlɛma gàazu ga yeaɲaka. ");
INSERT INTO tod_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Wa botii ɠɛ folo lɔzita laawu, wo looɠo folo lɔfelasiɛi, anɛɛ wozawoli ta molo leʋe ziɛgi zu ʋe. ");
INSERT INTO tod_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Wa dɔɔɠɔiti ma vɛtii ɠula, ga moloi é ga ɓeleegi ma mɔɔ mɔungi, ta molo leʋe vɛtii konagi a ɓena. ");
INSERT INTO tod_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ná zeizu ɠa ɠɛ saʋa konagi zu, zunuiti kpein ti ɠula kɛlɛma Maliɠii ɠaazu, Ɠɔoɠɔ GALAGI, Izilayɛle ná-GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Mazɔlɔɔ nà ziiti kpɛɛzu wo luɠɔ, nà wa-ɠwɛpelemaʋɛti bɔɔlɔzu. Nu nɔpɛ gaazu la ɠulaa wa-yooi ʋa, siɛgi zu wo lɛɛzu la ga wo ɠula kɛlɛma Ɠɔoɠɔ GALAGI, wa-ƓALAGI ɠaazu, ná zeizu ɠa ɠɛ saʋa konagi zu. ");
INSERT INTO tod_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Ɓului nii lɛʋɛi su, à mina naa ɓɔ suai ʋa, wo ʋa kula ga nà-zalaɠai. À mina Pakegi ná-fɛtii ma zalaɠai makɛ kpidii laawu, é ʋa yɛsu sobu ʋa zeeli. ");
INSERT INTO tod_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Wa ʋa ga wa-yooi ʋaalɔnɔ mɔungiti Ɠɔoɠɔ GALAGI wa-ƓALAGI zei ʋɛlɛi wu. «À mina boli yiʋoi ɠili ga dee ná-ɲiimiɗɛi.» ");
INSERT INTO tod_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Wooi niiti sɛʋɛ, mazɔlɔɔ minazeɠegi gè kɛɛzu è ʋɛ, ta Izilayɛle ʋɛ, toɠa zoloosu niima wooiti ma.» ");
INSERT INTO tod_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moize kɛɛni Ɠɔoɠɔ GALAGI ɠoba náʋɛ ga folo ʋuunaanigɔ (40) ta kpidi ʋuunaanigɔ (40). É la daami woni, ta é la ziɛ ɓɔleni. É minazeɠe gooiti sɛʋɛni kokologiti ma, ti ga tɔ puugɔi ma wooiti. ");
INSERT INTO tod_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moize yeini, é zeɠe Sinayi gizei ma, zeele woo ɠokolo felegɔiti ti ɠɛni zea, zeizuʋɛ é zeɠe gizei ma. É la ɠɛni kwɛɛ ga gaazuʋɛ ɠɛni volozu, tɔɔzei ti yɛpɛni ta Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aalɔn ta Izilayɛle nuiti kpein ti wɛlɛni Moize ʋa, pɛtɛ, gaazuʋɛ ɠɛni volozu, ti ɠɛni luazu ga ti ʋa maaɓuɠa ba. ");
INSERT INTO tod_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moize ti lolini. Aalɔn ta bɛbɛiti ta-ɠundiɠiiti kpein ti ʋaani pɔ bɛ, é ɓɔɛni ti ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Naa ʋoluma, Izilayɛle nuiti kpein ti maaɓuɠani ba. É deveiti kpein feeni ti ya, niiti é ti zɔlɔɔni Ɠɔoɠɔ GALAGI ya, Sinayi gizei ma. ");
INSERT INTO tod_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Siɛgi zu Moize ɓeni la ga ɓɔɛ ti ʋɔ, é seɠei ʋɛɛni ɠaazu. ");
INSERT INTO tod_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Siɛgi zu Moize a la ɠɛna lɛa la Ɠɔoɠɔ GALAGI ʋɔ bɛ, ga é ɓɔɛ pɔ, é ɠɛni seɠei ɠulazu ɠaazu, eyɛsu é ɠula. Siɛgi zu a la ɠulana la, é ɠɛni naa wosu Izilayɛle nuiti ma, nii é ga devei é veeni zea. ");
INSERT INTO tod_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Izilayɛle nuiti ti ɠɛni wɛlɛzu Moize ɠaazuʋɛ, ti kaani ga gaazuʋɛ ɠɛni volozu, Moize ɠɛni seɠei ʋɛɛzu ɠaazu ʋolu, eyɛsu é lɛ, é ɓɔɛ Ɠɔoɠɔ GALAGI ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moize Izilayɛle ʋɛbɛi kpein tolini, é ɠɛ ti ma: «À pɛtɛ, faiti Ɠɔoɠɔ GALAGI ti leveai ga ti ɠɛ: ");
INSERT INTO tod_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Folo lɔzita laawu, nu ɠa boti ɠɛ, kɛlɛ folo lɔfelasiɛi ɠa ɠɛ ga dooɠo foloi, feai Ɠɔoɠɔ GALAGI ʋɛ. Zɔi nɔpɛ a boti ɠɛɛna naama voloi, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","À mina abu ɠaazo dooɠo foloi, wo-zeizuʋɛ tanɔpɛ.» ");
INSERT INTO tod_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moize ɓɔɛni Izilayɛle ʋɛbɛi kpein pɔ, é ɠɛ ti ma: «Wɛlɛ, nii ɠa Ɠɔoɠɔ GALAGI deveai: ");
INSERT INTO tod_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","À vebɛanii zeɠe wo-ɠɔligiti ba, Ɠɔoɠɔ GALAGI ʋɛ. Nu nɔpɛ faanɛɛ ɠigi bɛ, naa ɠa ʋa ga vebɛanii nii Ɠɔoɠɔ GALAGI ʋɛ: zanugi, ta walii, ta kɔlu ɓɔigi, ");
INSERT INTO tod_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, ta boli leɠai, ");
INSERT INTO tod_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ta baala sinɛ ɠɔlɔiti, ti loai ga ma ɓɔigi, ta ziɛ wu zua ɠɔlɔiti, ta akasia wului, ");
INSERT INTO tod_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ta fitina wulɔi, ta tufa maku nɛɛnɛgiti ti ga siɛma wulɔ ɲadegai, ta ansansegi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ta kɔtu zɔngɔ ɓaagi nii daaseigi ga wonikese, ta kɔtu zɔngɔ ɓaa kiligiti zalaɠa ɠula zeɠei ma vaa zu, ta ma ɠakazu zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Wo zaama, niiti kpein ti zoogai faa la, ɲɛɛliɠi vai zu, ti ʋa, ti naa ɠɛ, nii Ɠɔoɠɔ GALAGI deveai: ");
INSERT INTO tod_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","seɠe ʋɛlɛ ɲadegai, ta ná-seɠe ʋɛlɛi, ta ma ʋɛɛmazeɠei, ta ma ɠalagiti, ta suzo guluiti, ta ná-gulu zɔkpɔiti, ta ná-tɔkpalaiti, ta ná-dabuiti, ");
INSERT INTO tod_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ta kesui ta ná-gulu zɔkpɔiti, ta dakulugi, ta kwɛpele seɠezuɠoozagi, ");
INSERT INTO tod_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ta taɓalii, ta ná-gulu zɔkpɔiti, ta ná-sɔɔlaiti kpein, ta ɓuluiti ti veai GALA bɛ, ");
INSERT INTO tod_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ta fitina zei anii, ta ná-sɔɔlaiti, ta ná-fitinaiti, ta gulɔi fitinai vaa zu, ");
INSERT INTO tod_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ta ansansegiti ma zalaɠa ɠulazuʋɛ, ta ná-gulu zɔkpɔiti, ta siɛma wulɔ ɲadegai ta ansansegi, ta pɛlɛlaʋɛ ma ɠwɛpele seɠezuɠoozagi, nu lɛɛzuʋɛ seɠe ʋɛlɛ ɲadegai wu, ");
INSERT INTO tod_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ta gala zalaɠaiti kulazuʋɛ, ta kɔlu vɛlɛai é ga kɔlu ɓɔigi, ta ná-gulu zɔkpɔiti, ta ná-sɔɔlaiti kpein, ta maagba aniɲakai ta ná-seiga anii, ");
INSERT INTO tod_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ta koii ma zasai ma zeɠeiti, ma lɔkpalaiti, ta ma labuiti, ta sasai laaʋɛ ma ɠwɛpele seɠezuɠoozagi, ");
INSERT INTO tod_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ta seɠe ʋɛlɛ ɲadegai zuzo kɔluiti, ta koii ma zasai zuzo kɔluiti, ta ta-ɠaluiti, ");
INSERT INTO tod_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ta zalaɠa ɠula zeɠeiti ada ɲadegai vaa ma, zalaɠa ɠula nui Aalɔn ná-seɠeiti, ta ná-doun zunuiti ta-zeɠeiti zalaɠa ɠulazuʋɛ ma wotiiti faa zu.» ");
INSERT INTO tod_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Izilayɛle ʋɛbɛi kpein ge zeɠeni Moize ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Niiti kpein é ɓɛtɛni ti yiima, faanɛɛ ɠigi ɠɛni ti ʋɛ, ti ʋaani ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ, GALA daaɠomi seɠe ʋɛlɛi ma wotii ma vaa zu, ná-botii kpein faa zu, ta zalaɠa ɠula zeɠeiti faa zu. ");
INSERT INTO tod_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Zunuiti ti ʋaani, anzanuiti ɓalaa, nu-o-nu nii faanɛɛ ɠigi a la ɠɛ bɛ, naati ti ɠɛni ʋaazu ga kɔbu aniiti, goizu anigiti, balaɠaegiti, ta balaiti, ta zanu ganiiti ma zii kpein. Ɛsɛ ge zanu vebɛanii veeni Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Niiti kpein seɠeiti ti ɠɛni ti ya, geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi, ta boli leɠai, ta baala sinɛ ɠɔlɔiti toai ga ma ɓɔigi, ta ziɛ wu zua ɠɔlɔiti, ti ʋaani ga tiye. ");
INSERT INTO tod_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Niiti kpein walii ta kɔlu ɓɔigi ma vebɛanii ɠɛni ti ya, naati ti ʋaani ga tiye Ɠɔoɠɔ GALAGI ʋɔ. Niiti kpein akasia wului ɠɛni ti ya, a zoo ɓɛtɛzu ma vaa ma, ti ʋaani ga tiye. ");
INSERT INTO tod_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Anzanui niiti kpein ti zooni faa la, naati ti gezei ɓalini ga yeei, ti ʋaani ga gezei nii ti kpalini, geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Anzanui niiti kpein ti-yii ɠɛʋele ɓɛtɛni ga pagɔ, ti zoogai faa la, naati ti boli leɠai ɓalini. ");
INSERT INTO tod_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Nuɓusɛiti ta-ɠundiɠiiti ti ʋaani ga kɔtu zɔngɔ ɓaagi, nii daaseigi ga wonikese, ta kɔtu zɔngɔ ɓaa kiligiti, zalaɠa ɠula zeɠei ma vaa zu, ta ma ɠakazu zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ti ʋaani ga tufa maku nɛɛnɛgiti ta gulɔi, fitinai ná-fai zu, ta siɛma wulɔ ɲadegai ta ansansegiti kpɛtɛ vai zu. ");
INSERT INTO tod_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Izilayɛle nuiti kpein, zunuiti ta anzanuiti, niiti faanɛɛ ɠigi ɠɛni ti ʋɛ, ga ti ʋa ga ani Ɠɔoɠɔ GALAGI ʋɔ, ná-botiiti faa zu é ma levei veeni Moize ya, naati ti ʋaani ga vebɛaniiti Ɠɔoɠɔ GALAGI ʋɔ. ");
INSERT INTO tod_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moize ɠɛni Izilayɛle nuiti ma: «À wɛlɛ, Ɠɔoɠɔ GALAGI yeelogɛ Ɓɛsaleyɛle ʋa, nii é ga Uli ná-doun zunui, Ɠuul ná-dounloin, Zuda ná-bolodai zu. ");
INSERT INTO tod_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","GALA ge daavegɛ ga GALA Zɛnvui, ta ɠimalai, ta keleɠelegi, ta soofaalai, botii ma zii kpein faa zu: ");
INSERT INTO tod_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","é zoo faiti kazaʋisu, é zanugi ɓɛtɛ, ta walii, ta kɔlu ɓɔigi, ");
INSERT INTO tod_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","é kɔtu zɔngɔ ɓaagiti saɠa, é ti ɲɛkpɛ ti-lɔɔzuʋɛti, é gului zaɠa, ta é ɲɛɛliɠi wotii ma zii kpein kɛ. ");
INSERT INTO tod_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","É kalagi ma vebɛanii veeʋɛ bɛ, zekana ɓalaa é kɛai la Woɠoliyaɓe ʋɛ, Ayizamake ná-doun zunui, Dan ná-bolodai zu. ");
INSERT INTO tod_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","É ti laavegɛ ga ɠimalai, ga ti botii ma ziiti kpein kɛ, nii é ɠɛni ga ɲɛɛliɠi vai, ta faa niinɛ laaɠula vai, ta seɠe zuʋu vai ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, ta seɠe vɛlɛ vai. Ti zoogai ɲɛɛliɠi vai ma zii kpein da, ta faa niinɛ laaɠula vai ma zii kpein. ");
INSERT INTO tod_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Ɓɛsaleyɛle ta Woɠoliyaɓe, ta zunuiti kpein ti zooni faa la, niiti Ɠɔoɠɔ GALAGI ɠimalai ta keleɠelegi ʋuuni ti-yiimaʋɛ, ti zoo ti botii ɠɛ, eɠɛʋelei seizu ɲadegai naama wotii kpein ga ɠɛ la, ti lɔɔni botii zu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la.» ");
INSERT INTO tod_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moize Ɓɛsaleyɛle ta Woɠoliyaɓe lolini, ta zunuiti kpein ɠigi ɠɛni ti ma, niiti Ɠɔoɠɔ GALAGI keleɠelegi ʋuuni ti-yiimaʋɛ, niiti kpein ti-ɠigiti kɛʋele ɓɛtɛni ga ti ɠolo botiiti kɛɛ vai zu. ");
INSERT INTO tod_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ti vebɛaniiti kpein seɠeni Moize ɠaazu, niiti Izilayɛle nuiti ti daani ɠisu, ti ʋaa la, naa ɠa a kɛ, seizu ɲadegai ma wotii ɠɛ. Sobu-o-sobu, nuiti ti ɠɛni ʋaazu ga vebɛaniiti Moize ʋɔ bɛ mɔnɔ. ");
INSERT INTO tod_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Názu ɠa ɲɛɛliɠi nuiti kpein ti ɠɛni seizu ɲadegai ma wotii ɠɛɛzu, ti ɠilagilagi ti botiiti zɛni ná la, niiti ti ɠɛni ti ɠɛɛzu, ");
INSERT INTO tod_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ti ʋaani, ti ɠɛ Moize ma: «Nuɓusɛiti ta wola ʋaazu la, é ʋooʋa botiiti kɛɛ vai ma, nii Ɠɔoɠɔ GALAGI deveai ga é ɠɛ.» ");
INSERT INTO tod_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moize devei woni ga ti sezei wo ti-ʋuuzuʋɛ ga: «Nu nɔpɛ, zunu ɓaa anzanu, ta mina mɔ vebɛani ɠɛʋele ɓɛtɛ seizu ɲadegai vaa zu.» Zekana ti pele leʋeni la nuɓusɛiti tuɠɔ, ti ʋa ʋa ga ta. ");
INSERT INTO tod_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Sɔɔlaiti ti ti ɓɛtɛni, ti kula ɠɛɛni, é ʋooʋa botii kpein ma, é ɠɛni ɠɛɛzu. ");
INSERT INTO tod_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Zunuiti saama, niiti kpein ti zoogai faa la, ɲɛɛliɠi vai zu, ti seɠe ʋɛlɛ ɲadegai ɓɛtɛni ga tanda puugɔ, ga geze ʋagɔi kpaliai, ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi. Ti suʋuni ga seeluɓɛinti baaɠulabai. ");
INSERT INTO tod_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Tanda ɠilagi zakpai ɠɛni ga mɛtɛlɛ puugɔ maazu naanigɔ (14), kogi ɠɛ ga mɛtɛlɛ felegɔ. Kɔɠɔgi ɠɛni ga ani ɠila nɔ tandaiti kpein faa zu. ");
INSERT INTO tod_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Ti tanda lɔɔlugɔiti seini ɓɔɠɔ la, ti zɔ lɔɔlugɔiti ɓalaa sei ɓɔɠɔ la. ");
INSERT INTO tod_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Ti galu ɓiiniiti giliɠilini tandai ma ɓɔsu mɔungi laamaʋɛ. Ti kɛɛni ɠana nɔ ga tandai ma ɓɔsu velesiɛi laamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ti galu ʋuulɔɔlugɔ (50) ɠiliɠilini tandai ma ɓɔsu mɔungi laamaʋɛ ʋa, ti galu ʋuulɔɔlugɔ (50) ɠiliɠili tandai ma ɓɔsu velesiɛi laamaʋɛ ʋa. Naama ɠaluiti ti zolooni ɓɔɠɔ ma ga felefele. ");
INSERT INTO tod_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ti zanu kala puulɔɔlugɔ (50) ɓɛtɛni, ti tandai ma ɓɔsuiti giliɠili ɓɔɠɔ ʋa ga tiye. Seɠe ʋɛlɛ ɲadegai ɠɛni ga ani ɠila kpe nɔ. ");
INSERT INTO tod_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ti boli leɠa landa puugɔ maazu ɠila (11) kpɛtɛni, ti ti ʋɛɛ seɠe ʋɛlɛ ɲadegai ɠɔma. ");
INSERT INTO tod_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tanda ɠilagi zakpai ɠɛni ga mɛtɛlɛ puugɔ maazu lɔɔlugɔ (15), kogi ɠɛ ga mɛtɛlɛ felegɔ. Kɔɠɔgi ɠɛni ga ani ɠila nɔ tanda puugɔ maazu ɠilagiti (11) bɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Ti tanda lɔɔlugɔiti giliɠilini ɓɔɠɔ ʋa, ta ti zɔ lɔzitaiti giliɠili ɓɔɠɔ ʋa. ");
INSERT INTO tod_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ti galu ʋuulɔɔlugɔ (50) ɠiliɠilini tandai ma ɓɔsu mɔungi laamaʋɛ, ti galu ʋuulɔɔlugɔ (50) ɓalaa giliɠili tandai ma ɓɔsu velesiɛi laamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ti kɔlu ɓɔi kala puulɔɔlugɔ (50) ɓɛtɛni, naa ɠa a kɛ tandai ma ɓɔsuiti ti zei da ga tiye, ti ɠɛ ga ani ɠila nɔ. ");
INSERT INTO tod_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Ti baala sinɛ ɠɔlɔiti kpɛtɛni ga pɛɛmazeɠei, toai ga ma ɓɔigi, seɠe ʋɛlɛi ʋɛ, ti ziɛ wu zua ɠɔlɔiti ma ʋɛɛmazeɠei ʋɛɛ maazu. ");
INSERT INTO tod_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ti seɠe ʋɛlɛi zuzo guluiti kpɛtɛni seɠe ʋɛlɛ ɲadegai ʋɛ ga akasia wuluiti. ");
INSERT INTO tod_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Seɠe ʋɛlɛi zuzo gului zɔligɔi ɠɛni ga mɛtɛlɛ lɔɔlugɔ, kogi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Seɠe ʋɛlɛi zuzo gului ɠilagilagi pɛ kpadɔzuʋɛ ɠaazoɓani ma wulu felegɔi ʋa. Zekana ti kɛɛni la seɠe ʋɛlɛ ɲadegai zuzo guluiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ti seɠe ʋɛlɛi zuzo gulu ʋuufelegɔ (20) ɓɛtɛni seɠe ʋɛlɛ ɲadegai ʋɛ, ti ɠɛni nu yeezazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ti dabu ʋuunaanigɔiti (40) kpɛtɛni ga walii, ti ʋa la seɠe ʋɛlɛi zuzo gulu ʋuufelegɔiti (20) gilagilagi wu, kpadɔzu felegɔiti bɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ti seɠe ʋɛlɛi zuzo gulu ʋuufelegɔ (20) ɓɛtɛni ɓalaa seɠe ʋɛlɛ ɲadegai ʋɛ, nu ɠɔʋɛzu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Ti dabu ʋuunaanigɔiti (40) kpɛtɛni ɓalaa ga walii, ti ʋa la seɠe ʋɛlɛi zuzo gulu ʋuufelegɔiti (20) gilagilagi wu, kpadɔzu felegɔiti bɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Ti seɠe ʋɛlɛi zuzo gulu lɔzita ɓɛtɛni seɠe ʋɛlɛ ɲadegai ɓogaʋɛ, folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ti seɠe ʋɛlɛi zuzo gulu felegɔ ɓɛtɛni seɠe ʋɛlɛ ɲadegai ma zoko felegɔiti bɛ, ti kpogaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ti ɠilini seɠe ʋɛlɛi zuzo gului zɔiti ba, é zo buuʋɛ, é zeeli bala mɔungi ma ungaʋɛ. Ʋele ɠana é ɠɛni la ga ti felegɔ, ti ʋilɛgai soko felegɔiti su. ");
INSERT INTO tod_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Seɠe ʋɛlɛi zuzo gulu lɔsaʋa ɠa naazu, é ɠɛni seɠe ʋɛlɛ ɲadegai ɓogaʋɛ, é ʋɛɛ ta-labu puugɔ maazu lɔzitaiti (16) ba, ti ɓɛtɛai ga walii, seɠe ʋɛlɛi zuzo gulu ɠila dabu felegɔ. ");
INSERT INTO tod_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Ti gulu zɔkpɔ lɔɔlugɔ ɓɛtɛni seɠe ʋɛlɛi zuzo guluiti bɛ ga akasia wului, ti ɓesa seɠe ʋɛlɛ ɲadegai ɠakamaʋɛ ɠilagi, ");
INSERT INTO tod_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ta gulu zɔkpɔ lɔɔlugɔ seɠe ʋɛlɛ ɲadegai ɠakamaʋɛ zɔɔla ʋelei zuzo guluiti bɛ, ta gulu zɔkpɔ lɔɔlugɔ seɠe ʋɛlɛ ɲadegai ɓogaʋɛ zuzo guluiti bɛ, folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ti zaamazu wulu zɔkpɔi ɓɛtɛni, ga é seɠe ʋɛlɛi zuzo guluiti maaleʋe, é zo kwɛgi ma, é li zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Ti zanugi ziɛni seɠe ʋɛlɛi zuzo guluiti ma. Ti ta-ʋalaiti kpɛtɛni ga zanugi, ga gulu zɔkpɔiti ti ɗa lɔ ti zu. Ti zanugi ziɛni naama wulu zɔkpɔiti ma. ");
INSERT INTO tod_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ti kwɛpele seɠezuɠoozagi ɓɛtɛni ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ti suʋuni ga seeluɓɛinti baaɠulabai. ");
INSERT INTO tod_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ti akasia wulu lɔkpala naanigɔ ɓɛtɛni bɛ, ti zanugi ziɛ ti ma. Zanu kalagiti ti ɠɛni ti ʋa. Ti walii ɠaawuunni, ti kpɛtɛ ga ma labu naanigɔiti. ");
INSERT INTO tod_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ti kwɛpele seɠezuɠoozagi taɠili kpɛtɛni seɠe ʋɛlɛi laaʋɛ, ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai, é ɠɛni ga seɠe zuʋuai. ");
INSERT INTO tod_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Ti ná-tɔkpala lɔɔlugɔiti ta ta-ɠalagiti kpɛtɛni. Ti zanugi ziɛni ti-ma zeigaiti ma, ta ti ti zɛlɛ kɔluiti kpɛtɛ ga zanugi. Ta-labu lɔɔlugɔi ɠɛni ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Ɓɛsaleyɛle kesui ɓɛtɛni ga akasia wului. Sakpai ɠɛni ga mɛtɛlɛ ɠila taata, kogi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui, sɔligi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","É zanu kitei ziɛni koozuʋɛ ta poluʋɛ, é daaɓegi ɓɛtɛ ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","É zanugi ɠaawuunni, é bala naanigɔiti kpɛtɛ bɛ. É ti ʋilini goizu naanigɔiti ba, bala felegɔ gilazu ʋelei ta bala felegɔ zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","É gulu zɔkpɔiti kpɛtɛni ga akasia wului, é zanugi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","É gulu zɔkpɔiti dɔɔni balaiti su, kesui ɠakamaʋɛti, kesui zeɠe vai zu. ");
INSERT INTO tod_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","É kesui lakulugi ɓɛtɛni ga zanu kitei. Sakpai ɠɛni ga mɛtɛlɛ ɠila taata, kogi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","É seeluɓɛin felegɔiti kpɛtɛni ga zanu doɠai, kesui lakulugi laaɓe felegɔiti ga. ");
INSERT INTO tod_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Seeluɓɛin gilagi ɠɛni daaɓegi gilazuʋɛ ɠa, seeluɓɛin gilagi ɠɛ daaɓegi zɔɔla ʋelei ɠa. É seeluɓɛin felegɔiti ta kesui lakulugi ɓɛtɛni ga ani ɠila nɔ. ");
INSERT INTO tod_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Seeluɓɛinti ti ti-ɠoʋegiti suvieni maazuʋɛ, ti kesui lakulugi maalɔɔɠu ga ti-ɠoʋegiti, ti ɠaaʋote ɓɔɠɔ ma. Seeluɓɛinti ti ɠaaʋoteni kesui lakulugi ma. ");
INSERT INTO tod_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","É taɓalii ɓɛtɛni ga akasia wului. Sakpai ɠɛni ga mɛtɛlɛ ɠila, kogi ɠɛ ga mɛtɛlɛ lukpɛgi, sɔligi ɠɛ ga mɛtɛlɛ ɠaaɠwɛsui. ");
INSERT INTO tod_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","É zanu kitei ziɛni ma, é daaɓegi ɓɛtɛ ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","É kakamaʋɛti kpɛtɛ ga nu yeaʋɛ liegɔi ɠɛɠala, é naa laaɓegi ɓɛtɛ ɓalaa ga zanugi, é ɠaku ma. ");
INSERT INTO tod_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","É zanugi ɠaawuunni, é kɛ ga balaiti taɓalii ʋɛ. É ti loni goizu naanigɔiti ba, kɔɠɔ naanigɔiti tetegi. ");
INSERT INTO tod_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Balaiti ti ɠɛni kakamaʋɛti ba, gulu zɔkpɔiti ti lɔɔni ti zu, taɓalii zeɠe vai zu. ");
INSERT INTO tod_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","É gulu zɔkpɔiti kpɛtɛni ga akasia wului, é zanugi ziɛni ti ma, ti ɠɛ ga taɓalii zeɠe aniiti. ");
INSERT INTO tod_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","É aniɲakaiti kpɛtɛni ga nu ɗa ti zei taɓalii ɠa: diɠiiti, ta tazaiti, puya zalaɠai vaa zu, ta kokoiti, ta ziawɔiti. É ti ɓɛtɛni ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","É fitina zei anii ɓɛtɛni ga zanu kitei doɠaai. Ti pɛ ti ɠɛni ga ani ɠila: kɔɠɔi, ta ma wului, ta ma ɓekegiti, ta maaɠili zɔɔlaiti ti ɠulaai ga gulu ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Fitina zei anii ma ɓeke dɔzitaiti ti ɠulani kakamaʋɛti, ma ɓeke saʋagɔ ɠɛni kakamaʋɛ gilazuʋɛ, ta ma ɓeke saʋagɔ ɠɛ kakamaʋɛ zɔɔla ʋelei. ");
INSERT INTO tod_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Maaɠili zɔɔlai ɠɛni saʋa ma ɓeke dɔzitai ɠilagilagi pɛ ba, ti ɠulaai ga amandegi ma ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Maaɠili zɔɔla naanigɔ ɠɛni fitina zei anii ma wului ʋa, ti ɠulaai ga amandegi ma ʋuai. ");
INSERT INTO tod_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Maaɠili zɔɔlai gila ge ɠɛni ma ɓeke felefelegiti todazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Fitina zei anii ɠɛni ga zanu kitei doɠaai. Baalobazuʋɛti pɛ ti ɠɛni ga ani ɠila: ma wului, ta ma ɓekegiti, ta maaɠili zɔɔlaiti. ");
INSERT INTO tod_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","É ná-fitina lɔfelaiti kpɛtɛni, ta ná-salaʋa zo sɔɔlaiti, ta ná-salaʋa zeɠe aniɲakaiti, ti pɛ ti ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kilo ʋuusaʋagɔ (30) ɠa é seɠeni zanu kitei zu, fitina zei anii, ta ma zɔɔlaiti kpein kpɛtɛ vai zu. ");
INSERT INTO tod_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","É ansansegiti ma zalaɠa ɠulazuʋɛ ɓɛtɛni ga akasia wului. É ɠɛni ga seki naanigi, sakpai ɠɛ ga mɛtɛlɛ lukpɛgi, kogi ɠɛ ga mɛtɛlɛ lukpɛgi, sɔligi ɠɛ ga mɛtɛlɛ ɠila. Ma minɛiti ti ɠɛni ba, ti ɠɛ ga ani ɠila. ");
INSERT INTO tod_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","É zanu kitei ziɛni gaaʋɛ, ta kakamaʋɛti, é kaku ma, ta ma minɛiti ma. É daaɓegi ɓɛtɛni ga zanugi, é kaku ma. ");
INSERT INTO tod_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","É zanu bala felegɔ loni ba, daaɓegi wuʋɛ, kakama felegɔiti, gulu zɔkpɔiti ti ɗa lɔ ti zu, seɠe vai zu. ");
INSERT INTO tod_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","É gulu zɔkpɔiti kpɛtɛni ga akasia wului, é zanugi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","É siɛma wulɔ ɲadegai ɓɛtɛni, ta ansansegiti, eɠɛʋelei gulɔ maku nɛɛnɛ kpɛtɛ nui a ɗa kpɛtɛ la. ");
INSERT INTO tod_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","É gala zalaɠaiti kulazuʋɛ ɓɛtɛni ga akasia wului. Sakpai ɠɛni ga mɛtɛlɛ felegɔ ta tukpɛ (2,5), kogi ɠɛ ga mɛtɛlɛ felegɔ ta tukpɛ (2,5). É ɠɛni ga seki naanigi, sɔligi ɠɛ ga mɛtɛlɛ ɠila ta tukpɛ (1,5). ");
INSERT INTO tod_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","É minɛiti kpɛtɛni goizu naanigɔiti ba, ma minɛiti ti ɓɔ ba, ti ɠɛ ga ani ɠila nɔ. É kɔlu ɓɔigi ziɛni ti ma. ");
INSERT INTO tod_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","É zalaɠa ɠulazuʋɛ ma zɔɔlaiti kpein kpɛtɛni: zuʋu zo aniɲakaiti, ta pɛluiti, ta ɲama vaza aniɲakaiti, ta sua zɔɔ mitɛ wolaiti, ta abu zeɠe aniiti. É sɔɔlai naati kpein kpɛtɛni ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","É kɔlu vɛlɛai ɓɛtɛni ga kɔlu ɓɔigi zalaɠa ɠulazuʋɛ. É pilɛni zalaɠa ɠulazuʋɛ lakɔlɔgaʋɛ wu, é zo buuʋɛ, eyɛsu é zeeli zalaɠa ɠulazuʋɛ zɔligɔi zaamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","É kɔlu ɓɔi balaiti kpɛtɛni, é ti lo kɔlu vɛlɛai ʋa, goizu naanigɔiti su, gulu zɔkpɔiti ti ʋa ɗa lɔ su. ");
INSERT INTO tod_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","É gulu zɔkpɔiti kpɛtɛni ga akasia wului, é kɔlu ɓɔigi ziɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","É gulu zɔkpɔiti dɔɔni balaiti su, zalaɠa ɠulazuʋɛ ɠakamaʋɛti, ti ɠɛ ga seɠe aniiti. É zalaɠa ɠulazuʋɛ ɓɛtɛni ga gulu zɛʋɛiti, é zeɠei ɠɛ koozu. ");
INSERT INTO tod_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Anzanuiti niiti ti ɠɛni botii ɠɛɛzu GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, naati ti ʋaani ga ta-ɠɔlu ɓɔi pɛtɛgiti. Naati ka é ti ɓɛtɛni ga maagba aniɲakai, é ɠɛni ga kɔlu ɓɔigi. Ná-seiga anii ɓalaa ɠɛni ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","É koizuʋɛ ɓɛtɛni. Nu yeezazu ʋelei, seɠei é ga geze ʋagɔi kpaliai ɠa é ɠɛni ná ga sasai. Sasai zakpai ɠɛni ga mɛtɛlɛ ʋuulɔɔlugɔ (50). ");
INSERT INTO tod_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Tɔkpala ʋuufelegɔiti (20) ti lɔɔni dabu ʋuufelegɔiti (20) ga, ti ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti ti ɠɛni ga walii. ");
INSERT INTO tod_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Lɛkpɛmaʋɛ nu ɠɔʋɛzuʋɛ, sasai zakpai ɠɛni miná ɓalaa ga mɛtɛlɛ ʋuulɔɔlugɔ (50), naa ɠɛ ga seɠei, ta tɔkpala ʋuufelegɔ (20), ta ta-labu ʋuufelegɔiti (20), ti ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti ti ɠɛni ga walii. ");
INSERT INTO tod_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Folo liizu ʋelei, sasai ɠogi ɠɛni ga mɛtɛlɛ ʋuufelegɔ maazu lɔɔlugɔ (25), naa ɠɛ ga seɠei, ta ta-lɔkpala puugɔiti ta ta-labu puugɔiti. Tɔkpalaiti ma ɠalagiti ta ti zɛlɛ kɔluiti ti ɠɛni ga walii. ");
INSERT INTO tod_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Folo ɠulazu ʋelei, sasai ɠogi ɠɛni ga mɛtɛlɛ ʋuufelegɔ maazu lɔɔlugɔ (25). ");
INSERT INTO tod_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Nu lɛɛzuʋɛ ɠobaʋɛ ɠilazuʋɛ, sasai ɠɛni ga mɛtɛlɛ lɔfela ta tukpɛ (7,5), naa ɠɛ ga seɠei, ta tɔkpala saʋagɔ, ta ta-labu saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Nu lɛɛzuʋɛ ɠobaʋɛ zɔɔla ʋelei, sasai ɠɛni miná ga mɛtɛlɛ lɔfela ta tukpɛ (7,5), ta tɔkpala saʋagɔ, ta ta-labu saʋagɔiti. ");
INSERT INTO tod_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Seɠei niiti kpein ti ɠɛni ga sasai, naati ti ɠɛni ga geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Tɔkpalaiti ma labuiti ti ɠɛni ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti, ta ti zɛlɛ kɔluiti ti ɠɛni ga walii, ta walii ɠɛni ʋɛɛni ti-ma zeigaiti ma. ");
INSERT INTO tod_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Sasai laaʋɛ ma ɠwɛpele seɠezuɠoozagi zuʋua ɠɛni de ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Sakpai ɠɛni ga mɛtɛlɛ puugɔ. Sɔligi ɠɛni ga mɛtɛlɛ felegɔ ta tukpɛ (2,5), eɠɛʋelei sasai ma zeɠei la. ");
INSERT INTO tod_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Sasai laaʋɛ ma lɔkpala naanigɔiti ma labu naanigɔiti ti ɠɛni ga kɔlu ɓɔigi. Tɔkpalaiti ma ɠalagiti, ta ti zɛlɛ kɔluiti ti ɠɛni ga walii, ta walii ɠɛni ʋɛɛni ti-ma zeigaiti ma. ");
INSERT INTO tod_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Seɠe ʋɛlɛ ɲadegai zuzo kɔluiti kpein, ta sasai zuzo kɔluiti kpein ti ɠɛni ga kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Seɠe ʋɛlɛ ɲadegai lo ganiiti ma ɠaalugi ʋɛtɛ, seɠe ʋɛlɛi nii zeele woo ɠesui ɠɛni bu, é loni Moize ná-devei wu, ga Levi nuiti ta-ɠaaɓaai, Itamaal ná-totuɠɔlai zu, zalaɠa ɠula nui Aalɔn ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Uli ná-doun zunui Ɓɛsaleyɛle, Ɠuul ná-dounloin, Zuda ná-bolodai zu, é naa kpein kɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Woɠoliyaɓe, naa ɠɛni polu, é ga Ayizamake ná-doun zunui, Dan ná-bolodai zu, nii é ɠɛni ga ɲɛɛliɠi nui, faa niinɛ laaɠula nui, ta seɠe zuʋu nui ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Zanugi liegɔi nii é lɔɔni seizu ɲadegai ma wotiiti kpein su, é ɠɛni ga kilo waagila (1.000) kɛɠala, eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi la. ");
INSERT INTO tod_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Nuɓusɛiti ti ɠaaluni, naati ta-walii ɠɛni ga kilo waasaʋagɔ unnaani puunaanigɔ (3.440) ɠɛɠala, eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi la. ");
INSERT INTO tod_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nu ɠilagilagi ɠɛni wali ɠaei ma ʋalisaamai veezu, eɠɛʋelei seizu ɲadegai ma wali ɠaei la. Zunu ɠilagilagi naa ɠɛɛni, niiti kpein ti ɠaaluni, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, naa ɠa é ɠɛni ga zunu waaundɔzita maazu saʋagɔ undɔɔlu puulɔɔlugɔ (603.550). ");
INSERT INTO tod_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Walii kilo waasaʋagɔ unnaani puufelegɔ (3.420), naa ɠa gaawuunni, é ɠɛ ga seizu ɲadegai ma labuiti, ta kwɛpele seɠezuɠoozagi ma labuiti. Dabuiti ti ɓɛtɛai ga walii nii, naati ti ɠɛni ga ungila (100). ");
INSERT INTO tod_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Walii kilo ʋuufelegɔi (20) mɔtai zɔiti, naati ka é ti ɠaawuunni. É kalagiti ta sɛlɛ kɔluiti kpɛtɛni la tɔkpalaiti bɛ, ta é ti-ma zeigaiti pɛɛ la. ");
INSERT INTO tod_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Kɔlu ɓɔigi é ɠɛni ga vebɛanii, é ɠɛni ga kilo waafelegɔ unnaanigɔ puufele maazu ɠila (2.421) kɛɠala. ");
INSERT INTO tod_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Ti GALA daaɠomi seɠe ʋɛlɛi laaʋɛ ma labuiti kpɛtɛni ga naama ɠɔlu ɓɔigi, ta zalaɠa ɠulazuʋɛ, ta ná-kɔlu vɛlɛai, ta zalaɠa ɠulazuʋɛ ná-sɔɔlaiti kpein, ");
INSERT INTO tod_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ta koii ma zasai ma labuiti kpein, ta sasai laaʋɛ ma labuiti, ta seɠe ʋɛlɛ ɲadegai zuzo kɔluiti kpein, ta sasai zuzo kɔluiti. ");
INSERT INTO tod_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Gezei niiti ti loai ga ma ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, naa ɠa ti kpɛtɛni ga zalaɠa ɠula wotii ɠɛ zeɠeiti ada ɲadegai ma vaa ma. Ti ti ɓɛtɛni ga zalaɠa ɠula zeɠe ɲadegaiti Aalɔn ʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ti zalaɠa ɠula zeɠei ɓɛtɛni ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ti suʋuni ga zanu galui. ");
INSERT INTO tod_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ti zanugi ma sɛpɛgiti sumaaleni, ti teʋeleʋe eɠɛ galui, ti gezei zuʋu ga zanu galui, geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ti kpakiga zeɠeiti kpɛtɛni ba, ti zeini zalaɠa ɠula zeɠei ɠaaɓelasu felegɔiti da. ");
INSERT INTO tod_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ti zalaɠa ɠula zeɠei ma lokoi ɓɛtɛni ga ma zii nɔ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. É ɠɛni ga zanugi, ta geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ti ɠɛni ga ani ɠila ta zalaɠa ɠula zeɠei. ");
INSERT INTO tod_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ti kɔtu zɔngɔ ɓaa felegɔiti kpatani ti-lɔɔzuʋɛti ba, ti ga zanugi, kɔtui nii daaseigi ga wonikese, niiti Izilayɛle ná-doun zunuiti daaseigiti ti zɛʋɛni ti ma, eɠɛʋelei nu a ɗa kɔtui zaɠa la, eɠɛ zeeʋozɛba anii. ");
INSERT INTO tod_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ti ti ɠilini zalaɠa ɠula zeɠei ma ɓakiga zeɠe felegɔiti ba, ti ɠɛ ga Izilayɛle ná-doun zunuiti ta-ɠizɛsui, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ti kakazu zeɠei ɓɛtɛni ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. Ti suʋuni ga zanu galui, ga zalaɠa ɠula zeɠei ɠɛʋelei. ");
INSERT INTO tod_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kakazu zeɠei ʋɛɛni su fele, é ɠɛ ga seki naanigi. Sakpai ɠɛni ga zeelo gila, kogi ɠɛ ga zeelo gila. ");
INSERT INTO tod_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ti kɔtu zɔngɔ ɓaagiti ɲɛkpɛni ba, ma ɲɛkpɛ naanigɔi zu: ma ɲɛkpɛ mɔungi zu, saaledowane gila, topaze gila, ta emelɔde gila, ");
INSERT INTO tod_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ma ɲɛkpɛi velesiɛi zu, gelenate gila, safiil gila, ta diama ɠila, ");
INSERT INTO tod_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ma ɲɛkpɛi zaʋasiɛi zu, wɔpale gila, agate gila, ta ametisete gila, ");
INSERT INTO tod_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ma ɲɛkpɛi naanisiɛi zu, kelizolite gila, wonikese gila, ta zasepe gila. Niima ɠɔtu zɔngɔ ɓaagiti ti ɓatani ti-lɔɔzuʋɛti ba, ti ga zanugi. ");
INSERT INTO tod_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ti Izilayɛle ná-doun zunuiti daaseigiti sɛʋɛni kɔtu puugɔ maazu felegɔiti (12) ma, eɠɛʋelei nu a ɗa kɔtui zaɠa la, eɠɛ zeeʋozɛba aniiti. Boloda puugɔ maazu felegɔiti (12) daaseigiti ti ɠɛni ti ma, kɔtu ɠila, gila daasei, kɔtu ɠila, gila daasei. ");
INSERT INTO tod_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ti zanu galu felegɔiti toni kakazu zeɠei ʋa, ti vɛlɛai ga zanu kitei. ");
INSERT INTO tod_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ti zanu dɔɔzuʋɛ felegɔiti kpɛtɛni ta zanu balaɠae felegɔiti. Ti balaɠae felegɔiti toni kakazu zeɠei woizu felegɔiti ba. ");
INSERT INTO tod_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ti zanu galu felegɔiti toni balaɠae felegɔiti ba, kakazu zeɠei woizu felegɔiti. ");
INSERT INTO tod_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Ti zanu galu felegɔiti sokpaiti toni dɔɔzuʋɛti felegɔ ʋa, niiti ti ɠiliai zalaɠa ɠula zeɠei ma ɓakiga zeɠe felegɔiti ba, nii a kɛ kakazu zeɠei yɛ ʋelelaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ti zanu balaɠae felegɔi ɓɛtɛni mɔnɔ, ti ti lo kakazu zeɠei woizu felegɔi zɔiti ba, koozu ʋelei, ná ʋɛɛzu zalaɠa ɠula zeɠei ma. ");
INSERT INTO tod_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ti zanu balaɠae felegɔ ɠili kpɛtɛni, ti ti lo zalaɠa ɠula zeɠei ma ɓakiga zeɠe felegɔiti ba, buuʋɛ, ʋelela ʋelei, ti-lodazuʋɛ ɠobaʋɛ, zalaɠa ɠula zeɠei ma lokoi maazu. ");
INSERT INTO tod_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ti kakazu zeɠei ná-balaɠaegiti gilini zalaɠa ɠula zeɠei ná-balaɠaegiti ba, ga galu ɓiinii, naa ɠa a kɛ kakazu zeɠei ɠɛ zalaɠa ɠula zeɠei ma lokoi maazu, ti yeeɠaa mina ɠwɛ ta zalaɠa ɠula zeɠei. É ɠɛɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ti zalaɠa ɠula zeɠei ma lookɔba wolai ɓɛtɛni, fɛlɛai ɲɛgɛlɛin nɔ ga geze ɓiinii. ");
INSERT INTO tod_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Tookɔba wolai naa ɠɔ teʋezuʋɛ ɠɛni saamaʋɛ, daaɠaleai é ɠaku ma ga seɠei taɠili, naa ɠa a kɛ é mina ʋali ga. ");
INSERT INTO tod_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Gului nii daa ga gelenadegi, naama waai maaniinigi ɠa ti gilini tookɔba wolai laamaʋɛ, ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, ta geze ʋagɔi kpaliai. ");
INSERT INTO tod_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ti zanu kitei ma lala koiti kpɛtɛni, ti ti ɠili gelenadegiti zɔɠɔzuʋɛti, é ɠaku tookɔba wolai laamaʋɛ, gelenadegiti zɔɠɔzuʋɛti, ");
INSERT INTO tod_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","tala ko ɠila, gelenade gila, tala ko ɠila, gelenade gila, é ɠaku tookɔba wolai laamaʋɛ ma, botii ma vaa zu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ti seɠewuzeɠeiti kpɛtɛni Aalɔn ta ná-doun zunuiti bɛ, ga geze ʋagɔi, ");
INSERT INTO tod_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ta bɔɔlɔgiti ga geze ʋagɔi, ta ʋɛlɛ kpuɠagiti ga geze ʋagɔi kpaliai, ");
INSERT INTO tod_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ta saamaɠiligiti ga geze ʋagɔi kpaliai, é ga geze ɓiinii, ta ma ɓɔigi, ta ma ɓɔi sɔsɔgi, suʋuai. Ti naa pɛ kpɛtɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ti zanu kitei ma zɛʋɛ goi ɓɛtɛni masa bɔɔlɔ ɲadegai ʋa, ti sɛʋɛni ga: «Feai Ɠɔoɠɔ GALAGI ʋɛ». Sɛʋɛai eɠɛʋelei nu a ɗa zeeʋozɛba anii maazaɠa la. ");
INSERT INTO tod_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ti galu ɓiinii lo ba, nii a kɛ ti gili bɔɔlɔgi ʋa, maazuʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ʋele ɠana seɠe ʋɛlɛ ɲadegai ma wotii kpein ge ɓeni la, GALA daaɠomi seɠe ʋɛlɛi. Izilayɛle nuiti ti naa kpein kɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni Moize ya, ti kɛɛni ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ti ʋaani ga seɠe ʋɛlɛ ɲadegai Moize ʋɔ: ná-seɠe ʋɛlɛi, ta ná-sɔɔlaiti kpein, kalagiti, seɠe ʋɛlɛi zuzo guluiti, gulu zɔkpɔiti, tɔkpalaiti, ta dabuiti, ");
INSERT INTO tod_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ta baala sinɛ ɠɔlɔi ma ʋɛɛmazeɠei toai ga ma ɓɔigi, ta ziɛ wu zua ɠɔlɔiti ma ʋɛɛmazeɠei, ta kwɛpele seɠezuɠoozagi, ");
INSERT INTO tod_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ta zeele woo ɠesui ta ná-gulu zɔkpɔiti, ta dakulugi, ");
INSERT INTO tod_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ta taɓalii, ta ná-sɔɔlaiti kpein, ta ɓuluiti ti veai GALA bɛ, ");
INSERT INTO tod_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ta fitina zei anii é ga zanu kitei, ta ná-fitinaiti, ta ná-sɔɔlaiti kpein, ta gulɔi fitinai vaa zu, ");
INSERT INTO tod_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ta zalaɠa ɠulazuʋɛ nii zanugi ziɛni maaʋɛ, ta siɛma wulɔ ɲadegai, ta ansansegi, ta kwɛpele seɠezuɠoozagi é nu lɛɛzuʋɛ seɠe ʋɛlɛi wu, ");
INSERT INTO tod_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ta zalaɠa ɠulazuʋɛ é ga kɔlu ɓɔigi, ta kɔlu vɛlɛai é ga kɔlu ɓɔigi, ta ná-gulu zɔkpɔiti, ta ná-sɔɔlaiti kpein, ta maagba aniɲakai ta ná-seiga anii, ");
INSERT INTO tod_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ta koii ma zasai ma zeɠeiti, ta ma lɔkpalaiti, ta ma labuiti, ta sasai laaʋɛ ma ɠwɛpele seɠezuɠoozagi, ta ná-galuiti, ta ná-suzo kɔluiti, ta seɠe ʋɛlɛ ɲadegai wu wotiɠɛ zɔɔlaiti kpein, GALA daaɠomi seɠe ʋɛlɛi vaa zu, ");
INSERT INTO tod_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ta zalaɠa ɠula zeɠeiti ada ɲadegai vaa ma, zalaɠa ɠula nui Aalɔn ná-seɠeiti, ta ná-doun zunuiti ta-zeɠeiti zalaɠa ɠulazuʋɛ ma wotiiti faa zu. ");
INSERT INTO tod_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Izilayɛle nuiti ti naama wotiiti kpein kɛɛni, é zoloo ma, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moize botii kpein fɛɠɛlɛfɛɠɛlɛni. É kaani ga ti kɛɛʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI deveni la. Názu ɠa Moize tuya looni la ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Alu mɔungi ma volo mɔungi, ɗa seɠe ʋɛlɛ ɲadegai lo, GALA daaɠomi seɠe ʋɛlɛi. ");
INSERT INTO tod_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ɗa zeele woo ɠesui zei bu, è maalɔɔɠu ga kwɛpele seɠezuɠoozagi. ");
INSERT INTO tod_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ɗa ʋa ga taɓalii, è ná-sɔɔlaiti sei ga. Ɗa ʋa ga fitina zei anii, è fitinaiti kɛʋele ɓɛtɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ɗa ansansegi ma zalaɠa ɠulazuʋɛ ʋilɛ, nii zanugi ziɛni maaʋɛ, zeele woo ɠesui ɠakalaʋɛ. Ɗa kwɛpele seɠezuɠoozagi zɛlɛ nu lɛɛzuʋɛ seɠe ʋɛlɛ ɲadegai wu. ");
INSERT INTO tod_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ɗa gala zalaɠaiti kulazuʋɛ ʋilɛ seɠe ʋɛlɛ ɲadegai ɠakalaʋɛ, GALA daaɠomi seɠe ʋɛlɛi. ");
INSERT INTO tod_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ɗa maagba aniɲakai zei GALA daaɠomi seɠe ʋɛlɛi ta zalaɠa ɠulazuʋɛ ti yɔɠɔzuʋɛ, è ziɛi ʋu su. ");
INSERT INTO tod_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ɗa koii ma zasai lo, é maaɠooli ná pɛ, è kwɛpele seɠezuɠoozagi zɛlɛ sasai laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Ɗa siɛma wulɔ ɲadegai zeɠe, è ta ziɛ seɠe ʋɛlɛ ɲadegai ma, ta nii kpein a ɠɛ ná, è ti ɲade, ta ná-aniɲakaiti kpein. Toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ɗa gulɔ ɲadegai ziɛ gala zalaɠaiti kulazuʋɛ ma, ta ná-sɔɔlaiti. Ɗa zalaɠa ɠulazuʋɛ ve bɛ̀, naa ɠa a kɛ, zalaɠa ɠulazuʋɛ wola ɲade. ");
INSERT INTO tod_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ɗa gulɔ ɲadegai ziɛ maagba aniɲakai ma, é ʋɛɛ ná-seiga anii ʋa, è ɲade. ");
INSERT INTO tod_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Ɗa Aalɔn ta ná-doun zunuiti maaɓuɠa nu lɛɛzuʋɛ ʋa, GALA daaɠomi seɠe ʋɛlɛi ɠakalaʋɛ, è ti maagba ga ziɛi. ");
INSERT INTO tod_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ɗa Aalɔn maaɠili ga zalaɠa ɠula zeɠeiti. Ɗa gulɔ ɲadegai ziɛ ma, è fe bɛ̀, é zalaɠa ɠula losuʋɛ ma wotii ɠɛ bɛ̀. ");
INSERT INTO tod_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ɗa ʋa ga ná-doun zunuiti, è seɠewuzeɠei loo ti ɠɔba. ");
INSERT INTO tod_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ɗa gulɔ ɲadegai ziɛ ti ma, eɠɛʋelei è gulɔi ziɛzu la ti-ɠɛɛ ma, naa ɠa a kɛ ti nà-zalaɠa ɠula wotii ɠɛ. Gulɔi a ziɛna ti ma, naa maaʋele ma, zalaɠa ɠula vai ma losuʋɛ ɠa ɠɛ ti ya, ti-mavofodaiti kpein su.» ");
INSERT INTO tod_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moize naa kpein kɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni zea. Zekana é kɛɛni la. ");
INSERT INTO tod_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Konagi velesiɛi ma alu mɔungi ma volo mɔungi ɠa seɠe ʋɛlɛ ɲadegai loni la. ");
INSERT INTO tod_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moize seɠe ʋɛlɛ ɲadegai loni, é ma labuiti kpɛtɛ, é suzo guluiti pilɛ, é gulu zɔkpɔiti dɔ ti zu, é tɔkpalaiti to. ");
INSERT INTO tod_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","É tandai zuvieni, é pɛɛ seɠe ʋɛlɛ ɲadegai ma. É pɛɛmazeɠei ʋɛɛni maazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","É zeele woo ɠokolo felegɔi zeɠeni, é ti la kesui zu. É gulu zɔkpɔiti dɔɔni kesui ma ʋalaiti su. É kesui lakulugi zeini kesui la. ");
INSERT INTO tod_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","É liini ga kesui seɠe ʋɛlɛ ɲadegai wu. É kwɛpele seɠezuɠoozagi zɛlɛni, nii a kɛ é zeele woo ɠesui maalɔɔɠu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","É taɓalii ʋilɛni GALA daaɠomi seɠe ʋɛlɛi wu, nu ɠɔʋɛzu ʋelei, kwɛpele seɠezuɠoozagi ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","É ɓuluiti puuni ga ga pagɔ Ɠɔoɠɔ GALAGI ɠaazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","É fitina zei anii ʋilɛni GALA daaɠomi seɠe ʋɛlɛi wu, nu yeezazu ʋelei, taɓalii letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","É ma vitinaiti kɛʋele ɓɛtɛni, Ɠɔoɠɔ GALAGI ɠaazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","É zalaɠa ɠulazuʋɛ ʋilɛni, nii zanugi ziɛni maaʋɛ, GALA daaɠomi seɠe ʋɛlɛi wu, kwɛpele seɠezuɠoozagi ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","É ansansegiti galani ga, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","É kwɛpele seɠezuɠoozagi zɛlɛni nu lɛɛzuʋɛ seɠe ʋɛlɛ ɲadegai wu. ");
INSERT INTO tod_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","É gala zalaɠaiti kulazuʋɛ ʋilɛni seɠe ʋɛlɛ ɲadegai ɠakalaʋɛ, GALA daaɠomi seɠe ʋɛlɛi. É gala zalaɠai ɠulani ná ta vebɛ zalaɠai, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","É maagba aniɲakai zeini GALA daaɠomi seɠe ʋɛlɛi ta zalaɠa ɠulazuʋɛ ti yɔɠɔzuʋɛ. É ziɛi ʋuuni su maagba vaiti su. ");
INSERT INTO tod_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moize ta Aalɔnni, ta ná-doun zunuiti, ti ɠɔɠɔiti ta ti-yeeiti maagbani náʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ta la ɠɛna lɛa GALA daaɠomi seɠe ʋɛlɛi wu, ɓaa ti ʋa maaɓuɠa zalaɠa ɠulazuʋɛ ʋa, ti ɠɛni ɓɔɠɔ maagbazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","É koii ma zasai loni seɠe ʋɛlɛ ɲadegai ta zalaɠa ɠulazuʋɛ maaɠoolii zu, é kwɛpele seɠezuɠoozagi zɛlɛ sasai laaʋɛ. Zekana Moize ɓeni da ga botii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tonaɓiingi ʋɛɛni GALA daaɠomi seɠe ʋɛlɛi ma, Ɠɔoɠɔ GALAGI ná-lɛbiyai seɠe ʋɛlɛ ɲadegai wuulaaveni. ");
INSERT INTO tod_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moize la mɔ ɠɛni zoosu é ʋa lɛ GALA daaɠomi seɠe ʋɛlɛi wu, mazɔlɔɔ tonaɓiingi ɠɛni ʋɛɛni ma, Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠɛni nɔ seɠe ʋɛlɛ ɲadegai laavesu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Siɛgi zu tonaɓiingi ɠɛni wuzeɠezu la, é zeɠe seɠe ʋɛlɛ ɲadegai maazu, názu ɠa Izilayɛle nuiti ti ɓena siɛi wo da, ti zeɠe ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ni tonaɓiingi la dɛ wuzeɠeni maazu, ti la ɠɛni liizu, eyɛsu voloi a la wuzeɠena la. ");
INSERT INTO tod_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Mazɔlɔɔ Ɠɔoɠɔ GALAGI ná-tonaɓiingi ɠɛni seɠe ʋɛlɛ ɲadegai maazu foloi, kɛlɛ kpidii, abui ɠɛni zosu tonaɓiingi zu, Izilayɛle nuiti kpein ti ɠɛni kaazu kpezekele. Zekana é ɠɛni ɠɛɛzu la ta-ziɛ yeeɠɛɠalai kpein su.");
INSERT INTO tod_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ɠɔoɠɔ GALAGI Moize lolini, é ɓɔɛ pɔ GALA daaɠomi seɠe ʋɛlɛi wu, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu nui ta vebɛanii veezu la Ɠɔoɠɔ GALAGI ʋɛ, toɠa seɠe toganii ma wolaiti ɓaa ma goiti saama. ");
INSERT INTO tod_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ni ná-vebɛanii ɠa ga togani wolai, é ga gala zalaɠai, toɠa ma zinɛi ta ve, nɛɛʋuzu mina ɠɛ ba. Toɠa kula GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, ga Ɠɔoɠɔ GALAGI daazo. ");
INSERT INTO tod_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Toɠa yeeʋɛɛ gala zalaɠa loganii unmaʋɛ, naa ɠa nɛɛ Ɠɔoɠɔ GALAGI ʋɛ, ga é ɠɛ tɔun bɛ ga koto gba vai. ");
INSERT INTO tod_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Toɠa nikɛ zinɛi ɠɔdaaleʋe Ɠɔoɠɔ GALAGI ɠaazu. Zalaɠa ɠula nuiti, Aalɔn ná-doun zunuiti, ta ma ɲamai lɛ ga Ɠɔoɠɔ GALAGI, ti pili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo, é GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Toɠa gala zalaɠa loganii ɠɔlɔɔ, é teʋeleʋe, é kpulukpulu. ");
INSERT INTO tod_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Zalaɠa ɠula nui Aalɔn ná-doun zunuiti ta abui la zalaɠa ɠulazuʋɛ, ti koʋii ʋu abui ɠa. ");
INSERT INTO tod_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Zalaɠa ɠula nuiti, Aalɔn ná-doun zunuiti, ta ma ɓulukpulugiti, ta ma ungi, ta ma wulɔiti da koʋii maazu, zalaɠa ɠulazuʋɛ abui ɠa. ");
INSERT INTO tod_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Toɠa koozu zɔɔlaiti ta kɔɠɔiti gba ga ziɛi. Zalaɠa ɠula nui ɠa ti kpein gala zalaɠa ɠulazuʋɛ. Gala zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Ni ná-vebɛanii a ɠɛna ga gala zalaɠai, é ga togani goi, baala ziʋoiti ɓaa boli yiʋoiti, toɠa ma zinɛi ɠula ga zalaɠai, nɛɛʋuzu mina ɠɛ ba. ");
INSERT INTO tod_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Toɠa kɔdaaleʋe zalaɠa ɠulazuʋɛ ɠɔʋɛzuʋɛ, Ɠɔoɠɔ GALAGI ɠaazu. Zalaɠa ɠula nuiti, Aalɔn ná-doun zunuiti, ta ma ɲamai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Toɠa teʋeleʋe, é kpulukpulu, ta ma ungi, ta ma wulɔi. Zalaɠa ɠula nui ɠa ti la koʋii maazu, puai abui ɠa, zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Toɠa koozu zɔɔlaiti, ta ma ɠɔɠɔiti gba ga ziɛi. Zalaɠa ɠula nui ɠa ti kpein kula ga zalaɠai, é gala, zalaɠa ɠulazuʋɛ. Gala zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Ni ná-vebɛanii Ɠɔoɠɔ GALAGI ʋɛ, a ɠɛna ga gala zalaɠai, é ga wɔnii, toɠa ʋa ga kpumagoi ɓaa poopo kpokpagi. ");
INSERT INTO tod_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Zalaɠa ɠula nui ɠa ʋa ga wɔnii zalaɠa ɠulazuʋɛ. Toɠa nɔungi volo ba, é gala, zalaɠa ɠulazuʋɛ. Toɠa ma ɲamai leda zalaɠa ɠulazuʋɛ laamaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Toɠa ma ɠɔzɔgi ta su aniiti kula su, é ti ʋili ya zalaɠa ɠulazuʋɛ ɠobaʋɛ, folo ɠulazu ʋelei, zuʋu ʋilisuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Toɠa wɔni laaʋali koʋegiti zɔɠɔzuʋɛ, kɛlɛ é mina teʋe su. Zalaɠa ɠula nui ɠa wɔni ɠala zalaɠa ɠulazuʋɛ, koʋii maazu, puai abui ɠa. Gala zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Siɛgi zu nui ta vebɛ zalaɠa veezu la Ɠɔoɠɔ GALAGI ʋɛ, ná-vebɛanii ɠa ɠɛ ga ani vukɔ ʋagɔi. Toɠa gulɔi ʋu ma, é ansansegi ɓɔ ba. ");
INSERT INTO tod_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Toɠa ʋaa la zalaɠa ɠula nuiti pɔ, Aalɔn ná-doun zunuiti. Zalaɠa ɠula nui ɠa zeeɲɛ gila seɠe ani vukɔi zu, nii gulɔi ʋuai ma, é ɓɔ ansansegi kpein ba, é gala, zalaɠa ɠulazuʋɛ ga ɠizɛsui. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Nii é yɛsu vebɛ zalaɠai ʋolu, naa ɠa ɠɛ ga Aalɔn ta ná-doun zunuiti tɔnɔ. Toɠa ga anii ɲadega wola zalaɠa aniiti saama, ti ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Ni vebɛ zalaɠa ʋe, nii é mɔsu sulugi zu, é ɠɛ ga ɓulu ʋɛlɛʋɛlɛgiti lɛʋɛ la su, é kpɛtɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, ɓaa ɓulu lɛɛvɛiti lɛʋɛ la su, gulɔi ʋuai ma. ");
INSERT INTO tod_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Ni vebɛ zalaɠa ʋe, nii é ɠeesu kɔlui maazu, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi lɛʋɛ la su, gaayɔgai ga gulɔi. ");
INSERT INTO tod_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Toɠa ɠaleɠale, é ɓulukpulu, gulɔi ʋu maazu. Toɠa ga vebɛ zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Ni vebɛ zalaɠa ʋe, nii é ɠeesu kɔlu liɠii ma, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi. ");
INSERT INTO tod_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","«Ta ʋa ga vebɛ zalaɠai Ɠɔoɠɔ GALAGI ʋɔ, nii kpɛtɛai ga naama aniiti. Toɠa ve zalaɠa ɠula nui ya, é ʋaa la zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nii maanɛai, é ɠula ga ɠizɛsui, zalaɠa ɠula nui naa zeɠe ba, é gala, zalaɠa ɠulazuʋɛ. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Nii é yɛsu vebɛ zalaɠai ʋolu, naa ɠa ɠɛ ga Aalɔn ta ná-doun zunuiti tɔnɔ. Toɠa ga anii ɲadega wola zalaɠa aniiti saama, ti ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Vebɛ zalaɠai tanɔpɛ wo ɠɛɛzu feezu Ɠɔoɠɔ GALAGI ʋɛ, ta la ɓɛtɛa ga lɛʋɛi, mazɔlɔɔ wo la ani nɔpɛ gala, nii lɛʋɛi a ɠɛ su, ɓaa kɔin gulɔi, vebɛaniiti saama, ti ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Wa zoo wo ta ɠula Ɠɔoɠɔ GALAGI ʋɛ, ga zooi ʋaalɔnɔ mɔungiti ma vebɛanii, kɛlɛ é mina ɠala zalaɠa ɠulazuʋɛ, eɠɛ vebɛanii makugi nɛai. ");
INSERT INTO tod_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Wa kpoloi ʋu wa-vebɛ zalaɠaiti kpein ba. Kpoloi mina ʋala wa-vebɛ zalaɠai zu, wa-ƓALAGI ná-minazeɠegi ma ʋoogi ʋe. Kɛni kpoloi ʋu wa-vebɛaniiti kpein ba. ");
INSERT INTO tod_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Ni wa zooi ʋaalɔnɔ mɔungiti ma vebɛ zalaɠai veena Ɠɔoɠɔ GALAGI ʋɛ, wa ani ɠɔpɔ niinɛiti gee dɛ, naa ʋolu wo ti wolowolo, ma vukɔi ɠula. ");
INSERT INTO tod_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Wa gulɔi ʋu ma, ta ansansegi. Vebɛ zalaɠai ʋe. ");
INSERT INTO tod_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Zalaɠa ɠula nui ɠa ma vukɔi ɠilazuʋɛ ɠala, ta gulɔi, é ʋɛɛ ansansegi kpein ba, é ɠɛ ga ɠizɛsui. Zalaɠai ʋe, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Ni nui ta ná-vebɛanii a ɠɛna ga ziilɛi zalaɠai, ni toɠa ga togani wolai, toɠa ma zinɛi ɓaa ma zaai ɠula, nɛɛʋuzu mina ɠɛ ba, Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Toɠa yeeʋɛɛ zalaɠa loganii unmaʋɛ, é kɔdaaleʋe GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Zalaɠa ɠula nuiti, Aalɔn ná-doun zunuiti, ta ma ɲamai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Naama yiilɛi zalaɠai zu, nii a kula ba ga zalaɠai, é ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa é ga: ma wulɔi felevelegai koozu zɔɔlaiti ma, ta nii kpein giliai ba, ");
INSERT INTO tod_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, é ʋɛɛzu ma zaamalɔkaeiti ma, ta ma mɔɔin ʋasuʋɛ, a kula ma lɔɠɔiti kobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aalɔn ná-doun zunuiti ta naa ʋɛɛ gala zalaɠai ʋa, nii a ɠɛ koʋii maazu, ti gala zalaɠa ɠulazuʋɛ. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Ni toɠa ziilɛi zalaɠai ɠulazu Ɠɔoɠɔ GALAGI ʋɛ, ga togani goi ta, toɠa ma zinɛi ɓaa ma zaai ɠula, nɛɛʋuzu mina ɠɛ ba. ");
INSERT INTO tod_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ni baala ziʋoi ɠa a kula ga zalaɠai, toɠa ʋaa la Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Toɠa yeeʋɛɛ zalaɠa loganii unmaʋɛ, é kɔdaaleʋe GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Aalɔn ná-doun zunuiti ta ma ɲamai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Naama yiilɛi zalaɠai zu, nii a kula ba ga zalaɠai, é ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa é ga: ma wulɔi, ta wɔɔngi kpein, a kula saamalɔkaei ʋa, ta ma wulɔi felevelegai koozu zɔɔlaiti ma, ta nii kpein giliai ba, ");
INSERT INTO tod_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, é ʋɛɛzu ma zaamalɔkaeiti ma, ta ma mɔɔin ʋasuʋɛ, a kula ma lɔɠɔiti kobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Zalaɠa ɠula nui ɠa naa ɠala zalaɠa ɠulazuʋɛ. Daamiani zalaɠai ʋe, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Ni ná-vebɛanii a ɠɛna ga bolii, toɠa kula Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Toɠa yeeʋɛɛ zalaɠa loganii unmaʋɛ, é kɔdaaleʋe GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Aalɔn ná-doun zunuiti ta ma ɲamai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Nii a kula ba ga zalaɠai, é ɠalazu abui ɠa, Ɠɔoɠɔ GALAGI ɠaazu, naa ɠa é ga: ma wulɔi felevelegai koozu zɔɔlaiti ma, ta nii kpein giliai ba, ");
INSERT INTO tod_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, é ʋɛɛzu ma zaamalɔkaeiti ma, ta ma mɔɔin ʋasuʋɛ, a kula ma lɔɠɔiti kobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Zalaɠa ɠula nui ɠa naa ɠala zalaɠa ɠulazuʋɛ. Daamiani zalaɠai ʋe, nii abui galazu, makugi nɛai. Ma wulɔi kpein ka ga Ɠɔoɠɔ GALAGI nɔnɔi. ");
INSERT INTO tod_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Nii ɠa ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ, ʋɛ nɔpɛ wa zei ná: Wo la sua wulɔi ta ɲamai mia pɛ.» ");
INSERT INTO tod_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu nui ta kotoi ɠɛɛzu la, é la kɛɛni ga gaaɠilimai, Ɠɔoɠɔ GALAGI ná-devei ta laalɔɠɔma, é fai ta ɠɛ, nii maa la nɛɛni ga é ʋa ɠɛ, ");
INSERT INTO tod_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ni zalaɠa ɠula nui ʋe, gulɔ ɲadegai ziaai ma, é nuɓusɛiti kɛ ga sɔba nu, ná-kotoi é kɛai naa maaʋele ma, toɠa nikɛ zinɛ ɓokpagi ɠula ga zalaɠai, nii nɛɛʋuzu la ba, Ɠɔoɠɔ GALAGI ʋɛ, é ɠɛ ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Toɠa ʋa ga nikɛ zinɛi GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, Ɠɔoɠɔ GALAGI ɠaazu, é yeeʋɛɛ nikɛ zinɛi unmaʋɛ, é kɔdaaleʋe Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Zalaɠa ɠula nui gulɔi ziaai ma, naa ɠa nikɛ zinɛi ma ɲamai ta zeɠe, é lii la GALA daaɠomi seɠe ʋɛlɛi wu, ");
INSERT INTO tod_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","toɠa yeeɓeɠai lɔ ɲamai wu, é ɲamai vaza daa ɠɛ lɔfela, seizu ɲadegai ma ɠwɛpele seɠezuɠoozagi letemaʋɛ, Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Zalaɠa ɠula nui ɠa ɲamai ta ziɛ ansansegiti ma zalaɠa ɠulazuʋɛ ma minɛiti ma, nii é Ɠɔoɠɔ GALAGI ɠaazu, GALA daaɠomi seɠe ʋɛlɛi wu. Toɠa nikɛ zinɛi ma ɲamai mɔtai ʋu ya gala zalaɠaiti kulazuʋɛ ɠɔɠɔaʋɛ, nii é GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Toɠa koto gba nikɛ zinɛi ma wulɔi kpein kula: ma wulɔi felevelegai koozu zɔɔlaiti ma, ta nii kpein giliai ba, ");
INSERT INTO tod_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, é ʋɛɛzu ma zaamalɔkaeiti ma, ta ma mɔɔin ʋasuʋɛ, a kula ma lɔɠɔiti kobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Zalaɠa ɠula nui ɠa tobazuʋɛ naati kula, eɠɛʋelei ti ɠulazu la ziilɛi zalaɠa nikɛ zinɛi ʋa, é ti ɠala, gala zalaɠaiti kulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Kɛlɛ nikɛ zinɛi ma ɠɔlɔi, ta ma zuai kpein, é ʋɛɛ nɔungi ʋa, ta kɔɠɔiti, ta ma ɠoozu zɔɔlaiti, ta ma ɓooiti, ");
INSERT INTO tod_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","woo zuɓuɠa su, nii kpein zɛgai ʋoluzu nikɛ zinɛi ʋa, toɠa li ga naa ti-ʋuuzuʋɛ ʋoluʋɛ, ada ɲadegai ta, zuʋu ʋilisuʋɛ, é gala abui ɠa, koʋii maazu. Toɠa gala zuʋu ʋilisuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Ni Izilayɛle ʋɛbɛi kpein ka é kotoi ɠɛa, ti la gaaɠilini ma, ti la suɠwɛɛni, ti naa ɠɛ Ɠɔoɠɔ GALAGI ná-tɔgi taɠila daalɔɠɔma, fai nii ti maa la nɛɛni ga ti ʋa kɛ ɲɛgɛlɛin, ti ɓɔɠɔ ɠɛ ɠana ga sɔba nu, ");
INSERT INTO tod_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","kotoi ti kɛai, naa a ɠulana kɛlɛ zu, bɛbɛi ɠa nikɛ zinɛ ɓokpa gila kula ga koto gba zalaɠai, ta ʋaa la GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Izilayɛle ɠɛwolaiti ta yeeʋɛɛ nikɛ zinɛi unmaʋɛ, ti kɔdaaleʋe Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Zalaɠa ɠula nui nii gulɔi ziaai ma, naa ɠa li ga nikɛ zinɛi ma ɲamai ta GALA daaɠomi seɠe ʋɛlɛi wu, ");
INSERT INTO tod_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","toɠa yeeɓeɠai lɔ ɲamai wu, é faza, ná zeizu ɠɛ lɔfela Ɠɔoɠɔ GALAGI ɠaazu, kwɛpele seɠezuɠoozagi letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Toɠa ɲamai ta ziɛ zalaɠa ɠulazuʋɛ ma minɛiti su, nii é Ɠɔoɠɔ GALAGI ɠaazu GALA daaɠomi seɠe ʋɛlɛi wu, ta toɠa ɲamai mɔtai ʋu ya gala zalaɠaiti kulazuʋɛ ɠɔɠɔaʋɛ, nii é GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Toɠa nikɛ zinɛi ma wulɔi kpein kula, é gala, zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Toɠa nikɛ zinɛi naa ɠɛ, eɠɛʋelei nɔ koto gba nikɛ zinɛi ɠɛɛzu la. Toɠa kɛ ɠana nɔ. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la ti ʋɛ, suvaa ɠa yɛ ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Toɠa li ga nikɛ zinɛi ti-ʋuuzuʋɛ ʋoluʋɛ, é gala, eɠɛʋelei é nikɛ zinɛ mɔungi ɠalani la. Koto gba zalaɠai ɠana bɛbɛi ná-faa zu. ");
INSERT INTO tod_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Siɛgi zu kundiɠii ta a kotoi ɠɛɛna la, é la gaaɠilini ma, é kɛ ná-GALAGI, Ɠɔoɠɔ GALAGI ná-devei ta laalɔɠɔma, é fai ta ɠɛ, nii maa la nɛɛni ga é ʋa ɠɛ, é ɓɔɠɔ ɠɛ ɠana ga sɔba nu, ");
INSERT INTO tod_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","a ná-kotoi ɠwɛɛna, nii é kɛai, toɠa boli zinɛi ɠula ga zalaɠai, nii nɛɛʋuzu la ba. ");
INSERT INTO tod_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Toɠa yeeʋɛɛ boli zinɛi unmaʋɛ, é kɔdaaleʋe, gala zalaɠa loganiiti kɔdaaleʋezuʋɛ, Ɠɔoɠɔ GALAGI ɠaazu. Koto gba zalaɠai ʋe. ");
INSERT INTO tod_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Zalaɠa ɠula nui ɠa koto gba zalaɠai ma ɲamai ta zeɠe ga yeeɓeɠai, é ta ziɛ gala zalaɠaiti kulazuʋɛ ma minɛiti ma, toɠa ɲamai mɔtai ʋu ya gala zalaɠaiti kulazuʋɛ ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Toɠa ma wulɔi kpein gala zalaɠa ɠulazuʋɛ, eɠɛʋelei ziilɛi zalaɠai ma wulɔi la. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la kundiɠii naa ʋɛ, ná-kotoi vaa zu, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Ni nui ta ʋe, nuɓusɛiti saama, é kotoi ɠɛai, é la gaaɠilini ma, é naa ɠɛ Ɠɔoɠɔ GALAGI ná-tɔgiti ta laalɔɠɔma, é fai ta ɠɛ, nii maa la nɛɛni ga é ʋa ɠɛ ɲɛgɛlɛin, é ɓɔɠɔ ɠɛ ga sɔba nu ɠana, ");
INSERT INTO tod_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","a ná-kotoi ɠwɛɛna, é kɛai, toɠa boli zaai ɠula ga zalaɠai, nii nɛɛʋuzu la ba, kotoi vaa zu nii é kɛai. ");
INSERT INTO tod_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Toɠa yeeʋɛɛ koto gba loganii unmaʋɛ, é kɔdaaleʋe, gala zalaɠa loganiiti kɔdaaleʋezuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Zalaɠa ɠula nui ɠa suai ma ɲamai ta zeɠe ga yeeɓeɠai, é ta ziɛ gala zalaɠaiti kulazuʋɛ ma minɛiti ma, é ɲamai mɔtai ʋu ya zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Toɠa ma wulɔi kpein kula, eɠɛʋelei ziilɛi zalaɠai ma wulɔi ɠulazu la, é gala, zalaɠa ɠulazuʋɛ, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la bɛ, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Ni sɔba nui a ʋaana ga baalagi ga koto gba zalaɠai, toɠa ɠɛ ga ma zaai, nii nɛɛʋuzu la ba. ");
INSERT INTO tod_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Toɠa yeeʋɛɛ koto gba zalaɠa loganii unmaʋɛ, é kɔdaaleʋe, gala zalaɠa loganiiti kɔdaaleʋezuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Zalaɠa ɠula nui ɠa suai ma ɲamai ta zeɠe ga yeeɓeɠai, é ta ziɛ gala zalaɠaiti kulazuʋɛ ma minɛiti ma, é ɲamai mɔtai ʋu ya zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Zalaɠa ɠula nui ɠa ma wulɔi kpein kula, eɠɛʋelei ziilɛi zalaɠa ʋaala gulɔi ɠulazu la, é gala, zalaɠa ɠulazuʋɛ, naa ʋɛɛ gala zalaɠai zɔiti ba, ti ɠalazu Ɠɔoɠɔ GALAGI ʋɛ. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la zunui naa ʋɛ, ná-kotoi vaa zu é kɛai, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Ni nui ta a faa ɠaana, ɓaa é faa mɛni, naa ʋolu é toligi mɛni ga zeeleiti ti ʋa, kɛlɛ é la kɛɛni, nii é kwɛɛ, é ʋa naama zeele wooi wo, ná-faaɠaaza golai ma ɠasɔi ɠa la unma. ");
INSERT INTO tod_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Siɛgi zu nui ta vɔɔɠuzu la kɔzɔba anii ta ʋa, é la suɠwɛɛ, kɔzɔba zuai ta ma ʋoomai, é ɠɛni ga dɔɓɔ zua, ɓaa toganii ta, ɓaa kpokpo ganii, tɔ ɓɔɠɔi ɠa ɠɔzɔ, é ɠɛ ga sɔba nu. ");
INSERT INTO tod_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Ni a vɔɔɠuna nui ta ma zii nɔpɛ ba, kɔzɔai, nii a zoo tɔ ɓalaa kɔzɔzu, a suɠwɛɛna nɔ feya, toɠa ɠɛ ga sɔba nu názu. ");
INSERT INTO tod_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Ni nui ta a ɓɔɛna soleyai zu, é ɠona ga toɠa faa ɲɔu ɠɛɛzu ɓaa faa ʋagɔi, é la ɠidaani bu, a suɠwɛɛna nɔ feya, toɠa ɠɛ ga sɔba nu názu. ");
INSERT INTO tod_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Deɠɛmu, zɔi é ɠɛɛzu ga sɔba nu niima vaiti gila su, toɠa laa zɔ ga ga ná-kotoi. ");
INSERT INTO tod_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Naa ʋoluma ná-kotoi vaa zu é kɛai, toɠa ʋa ga baala saa ɠila ɓaa boli zaa ɠila, é ɠɛ ga koto gba zalaɠai, faazuɓɛtɛ vai zu Ɠɔoɠɔ GALAGI letema. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la bɛ, ná-kotoi vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Ni ani la nu ya, a baala saai zɔlɔɔ da, ɓaa boli zaai, ná-kotoi vaa zu é kɛai, toɠa ʋa ga kpumago felegɔ, ɓaa poopo kpokpa felegɔ, faazuɓɛtɛ vai zu Ɠɔoɠɔ GALAGI letema. Gilagi ɠɛ ga koto gba zalaɠai, zɔi ɠɛ ga gala zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Toɠa ʋa ga tiye zalaɠa ɠula nui ʋɔ, naa ɠa naa ɠula ga zalaɠai mɔunpa, nii maanɛai é ɠɛ ga koto gba zalaɠai. Zalaɠa ɠula nui ɠa kɔgi ʋee ga, kɛlɛ é mina nɔungi ɠula ga. ");
INSERT INTO tod_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Toɠa ma ɲamai ta vaza zalaɠa ɠulazuʋɛ laamaʋɛ, é ɲamai mɔtai leda zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ. Koto gba zalaɠai ʋe. ");
INSERT INTO tod_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Toɠa zɔɔma wɔni ɠɛ ga gala zalaɠai, eɠɛʋelei deveai la tɔgi zu. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la zunui naa ʋɛ, ná-kotoi vaa zu é kɛai, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Ni ani la nu ya, nii a kpumago felegɔ zɔlɔɔ da, ɓaa poopo kpokpa felegɔ, toɠa ʋa ga vebɛanii ná-kotoi ma vaa zu, ga kilo saʋagɔ ɓulu vukɔ ʋagɔi zu. É mina gulɔ ʋu ma ɲɛgɛlɛin, ta é mina ansanse pɛɛ ba ɓalaa, mazɔlɔɔ toɠa ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Toɠa ʋaa la zalaɠa ɠula nui ʋɔ. Zalaɠa ɠula nui ɠa zeeɲɛ gila seɠe ga ɠizɛsui, é gala, zalaɠa ɠulazuʋɛ, naa ʋɛɛ zalaɠai zɔiti ba, ti ɠalazu Ɠɔoɠɔ GALAGI ʋɛ. Koto gba zalaɠai ʋe. ");
INSERT INTO tod_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la zunui naa ʋɛ, ná-kotoi vaa zu é kɛai, é lo naama vaiti taɠila ba, suvaa ɠa yɛ bɛ. Nii a yɛ ʋoluzu, naa ɠa ɠɛ ga zalaɠa ɠula nui nɔnɔ, eɠɛʋelei a ɗa ɠɛ la ga vebɛ zalaɠai.» ");
INSERT INTO tod_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Siɛgi zu nui ta ɠɛɛzu la ga ladalala nu, é kotoi ɠɛ, é la gaaɠilini ma, é makɛ aniiti ba ɓɔɠɔ ʋɛ, niiti ti veai Ɠɔoɠɔ GALAGI ʋɛ, toɠa baala sinɛi zeɠe, nii nɛɛʋuzu la ba, é kula ga faazuɓɛtɛ zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ná-kotoi vaa zu, eɠɛʋelei sɔngɔi la, é lo seizu ɲadegai ma wali vaiti kɛʋelei ʋa. Faazuɓɛtɛ zalaɠai ʋe. ");
INSERT INTO tod_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Toɠa fe zalaɠa ɠula nui ya, é pɛɛ anii ná zeizu lɔɔlugɔi ɠilazuʋɛ ʋa, nii feai GALA bɛ. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la bɛ ga baala sinɛi, nii kulaai ga faazuɓɛtɛ zalaɠai, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Ni nui ta a koto ɠɛɛna, é la suɠwɛɛ, é naa ɠɛ Ɠɔoɠɔ GALAGI ná-devei gila daalɔɠɔma, fai niiti maa la nɛɛni, ti ʋa ɠɛ ɲɛgɛlɛin, toɠa ɓɔɠɔ ɠɛ ga sɔba nu, ná-faaɠaaza golai ma ɠasɔi ɠa la unma. ");
INSERT INTO tod_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Toɠa ʋa ga baala sinɛi, nii nɛɛʋuzu la ba, é fe zalaɠa ɠula nu ya, ga faazuɓɛtɛ zalaɠai, é seɠe togani ɓulugi zaama, eɠɛʋelei sɔngɔi la. Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la bɛ, ná-kotoi vaa zu é kɛai, é la suɠwɛɛ, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Faazuɓɛtɛ zalaɠai ʋe, zunui naa ɓɔɠɔ ɠɛɛni ɠiteɠite su ga sɔba nu Ɠɔoɠɔ GALAGI letemazu.» ");
INSERT INTO tod_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Siɛgi zu nui ta koto ɠɛɛzu la, é ɠɛ ga ladalala nu Ɠɔoɠɔ GALAGI letemazu, é zɛɛi wo seiɲɔɠɔi ma, kaliva ma vaa zu, anii é kalivaai ma ga é makɛ, anii unmaai, ɓaa ta ɠulaai su ga yaavai, ");
INSERT INTO tod_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ɓaa é laamaɓa ga tooya anii ɠaa vai, ɓaa é zɛɛ ɠonai wo, é lo kotoi tanɔpɛ ba, nuɓusɛi a zoo kɛɛzu, ");
INSERT INTO tod_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","siɛgi zu a kotoi ɠɛɛna la ɠana, é ɓɔɠɔ ɠɛ ga sɔba nu, anii nii é unma, ɓaa é ta ɠula su ga yaavai, toɠa naa ʋotogi ve, ɓaa anii é ɠalivaani ma, ɓaa anii toai ya, é ka, ");
INSERT INTO tod_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ɓaa anii-yo-anii nii é zɛɛ ɠonai wosu, é lo ba. Toɠa gaavɔnigai ve, é seizu lɔɔlusiɛi ɠilazuʋɛ ɠila pɛɛ ba, é teʋe anii kɛɛ nui ʋɔ, naama voloi nɔ ma, yeei é ná-faa zuɓɛtɛ zalaɠai ɠulazu la. ");
INSERT INTO tod_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Toɠa ʋa zalaɠa ɠula nui ʋɔ ga ná-faa zuɓɛtɛ zalaɠai, ná-kotoi vaa zu, Ɠɔoɠɔ GALAGI ɠaazu, ga baala sinɛi nii nɛɛʋuzu la ba, é ɠula togani ɓulugi zu, eɠɛʋelei sɔngɔi la. ");
INSERT INTO tod_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Zekana zalaɠa ɠula nui a koto gba vai ɠɛ la bɛ Ɠɔoɠɔ GALAGI ɠaazu, suvaa ɠa yɛ bɛ, é ɠɛni ga faaɠaazagi ma zii nɔpɛ, é ɓɔɠɔ ɠɛai su ga sɔba nu.» ");
INSERT INTO tod_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Niima levei ve Aalɔn ta ná-doun zunuiti zea, è ɠɛ ti ma: Gala zalaɠai ma lɔgi ɠaa: Gala zalaɠai ɠa yɛ zalaɠa ɠulazuʋɛ ma lutui zu, kpidii ɲɛgɛlɛin eyɛsu sobui, zalaɠa ɠulazuʋɛ ma abui ɠa yɛ sosu. ");
INSERT INTO tod_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Sobui, zalaɠa ɠula nui ɠa ná-seɠei loo ɠɔba, é ʋɛlɛ kpuɠagi lɛ ɓɔɠɔ ma, niiti ti ga gezei. Toɠa zuʋui ɠula, nii abui kulaai gala zalaɠai ɠalazuʋɛ, toɠa sei zalaɠa ɠulazuʋɛ ɠoba. ");
INSERT INTO tod_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Naa ʋoluma toɠa ná-seɠeiti pu, é taɠiligaa loo, ga é li ga zuʋui ti-ʋuuzuʋɛ ʋoluʋɛ, ada ɲadegai ta zu. ");
INSERT INTO tod_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Abui ɠa yɛ sosu zalaɠa ɠulazuʋɛ, é mina za ɲɛgɛlɛin. Sobu-o-sobu, zalaɠa ɠula nui ɠa abui lo koʋii ʋa, é gala zalaɠai ɓɛtɛ, é ziilɛi zalaɠaiti ma wulɔi ɠala. ");
INSERT INTO tod_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Abui ɠa yɛ sosu ɠɔ zalaɠa ɠulazuʋɛ, é mina za. ");
INSERT INTO tod_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Vebɛ zalaɠai ma lɔgi ɠaa: Aalɔn ná-doun zunuiti ta kula Ɠɔoɠɔ GALAGI ɠaazu, zalaɠa ɠulazuʋɛ ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Zalaɠa ɠula nui ɠa zeeɲɛ gila seɠe ani vukɔi zu, nii gulɔi ʋuai ma, é pɛɛ ansansegi kpein ba. Toɠa naa ɠala zalaɠa ɠulazuʋɛ ga ɠizɛsui, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aalɔn ta ná-doun zunuiti ta vebɛanii mɔtai mi. Ta mi ada ɲadegai ta, GALA daaɠomi seɠe ʋɛlɛi ma ɠoizuʋɛ, kɛlɛ lɛʋɛ mina ɠɛ ba. ");
INSERT INTO tod_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Nu mina lɛʋɛ ʋu ma, é ʋa mɔ da. Tɔnɔi ɠana gè feai ti ʋɛ nà-vebɛaniiti su, ti ɠalazu abui ɠa. Ani ʋe gola ɲadegai, eɠɛ koto gba zalaɠai ɓaa faazuɓɛtɛ zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Zunui kpein ka ta mi, Aalɔn ná-doun zunuiti saama. Tɔgi ɠana wo-mavofodaiti kpein bɛ eyɛsu ɠɔ, é lo vebɛaniiti ba, ti ɠalazu Ɠɔoɠɔ GALAGI ʋɛ. Nu-o-nu a vɔɔɠu ba, naa ɠa ɲade.» ");
INSERT INTO tod_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Wɛlɛ vebɛanii ʋa, Aalɔn ta ná-doun zunuiti ta fe Ɠɔoɠɔ GALAGI ʋɛ, foloi ta gulɔ ɲadegai ziɛna la ti ma: kilo saʋagɔ ɓulu vukɔ ʋagɔi zu, gilazuʋɛ sobui, gilazuʋɛ kpɔkɔi, eɠɛ folo-o-folo vebɛ zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Ɓulu vukɔi ɠa ɠaayɔ ga gulɔi, é la gee kɔlui maazu. Ɗa geegai ta teʋeleʋeai ɠula ga vebɛ zalaɠai, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Zalaɠa ɠula nui niigi, Aalɔn ná-doun zunuiti saama, gulɔ ɲadegai a ziɛ ma ga é zei potogi zu, naa ɓalaa ɠa vebɛanii naa ɠula. Ɠɔoɠɔ tɔgi ʋe. Toɠa ɠala ɲɛgɛlɛin Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Zalaɠa ɠula nui ná-vebɛ zalaɠai kpein ka ɠala ɲɛgɛlɛin, tanɔpɛ ge la mia.» ");
INSERT INTO tod_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","«Ɓɔɛ Aalɔn ʋɔ ta ná-doun zunuiti, è ɠɛ ti ma: Koto gba zalaɠai ma lɔgi ʋɛtɛ. Adaʋɛ gala zalaɠai ɠɔdaaleʋezu ná, miná ɠa koto gba zalaɠa zuai ɠɔdaaleʋezu ná, Ɠɔoɠɔ GALAGI ɠaazu. Ani ʋe gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Zalaɠa ɠula nui é koto gba zalaɠai ɠulazu, naa ɠa mi. Toɠa mi ada ɲadegai ta, GALA daaɠomi seɠe ʋɛlɛi ma ɠoizuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Nu-o-nu a vɔɔɠu ma zuai ʋa, naa ɠa ɲade. Ni ma ɲamai a vazana seɠe ma, ʋɛ fazagai ná ma, miná ɠa gba ada ɲadegai ta. ");
INSERT INTO tod_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Pɔlɔ liɠii a ɠili su, naa ɠa wolo. Ni kɔlu ɓɔi diɠii ɠa a ɠili su, su ɠa ɓale, é gba ziɛi wu. ");
INSERT INTO tod_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Zunui kpein é ga zalaɠa ɠula nui, naa pɛ ka ta mi. Ani ʋe gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kɛlɛ nu la zalaɠa zua nɔpɛ mia, nii ma ɲamai a ʋa GALA daaɠomi seɠe ʋɛlɛi wu, ga koto gba vai ʋa ɠɛ ada ɲadegai. Ma zuai ɠa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Wɛlɛ faazuɓɛtɛ zalaɠa lɔgi ʋa: Ani ʋe gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Adaʋɛ ti gala zalaɠai ɠɔdaaleʋezu ná, miná ɠa faazuɓɛtɛ zalaɠa zuai ɠɔdaaleʋezu ná. Ma ɲamai ɠa ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ta ma wulɔi kpein kula: ma wɔɔngi, ta ma wulɔi felevelegai koozu zɔɔlaiti ma, ");
INSERT INTO tod_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ta ma lɔɠɔ felegɔiti, ta ma wulɔi felevelegai ti ma, é ʋɛɛzu ma zaamalɔkaeiti ma, ta ma mɔɔin ʋasuʋɛ, a kula ma lɔɠɔiti kobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Zalaɠa ɠula nui ɠa naa ɠala zalaɠa ɠulazuʋɛ. Faazuɓɛtɛ zalaɠai ʋe, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Zunuiti kpein ti wo zaama ga zalaɠa ɠula nuiti, naati ta ta mi, é mi ada ɲadegai ta. Ani ʋe gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«Toɠa ɠɛ ɠana faazuɓɛtɛ zalaɠai vaa zu, eɠɛʋelei nɔ é la koto gba zalaɠai vaa zu. Tɔgi naa ɠa ga faa ɠila nɔ zalaɠa felegɔi naati faa zu, ma zuai ɠa ɠɛ ga zalaɠa ɠula nui nɔnɔ, nii é kotoi gbazu. ");
INSERT INTO tod_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Zalaɠa ɠula nui é ʋaazu gala zalaɠai ɠulazu, nui ta ʋɛ, nɔnɔi ɠa ɠɛ ga gala zalaɠai ma ɠɔlɔgi, nii é kulaai ga zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Vebɛ zalaɠai kpein mɔgai sulugi zu, ɓaa anii ɠee kɔlu liɠii ma, ɓaa anii ɠee kɔlui maazu, naa ɠa ɠɛ ga zalaɠa ɠula nui nɔnɔ, nii é kulaai. ");
INSERT INTO tod_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Vebɛ zalaɠai kpein gaayɔgai ga gulɔi, ɓaa ma vɔɔi, naa ɠa ɠɛ ga Aalɔn ná-doun zunuiti kpein tɔnɔ, ti ɠilagilagi pɛ. ");
INSERT INTO tod_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Ziilɛi zalaɠai ma lɔgi ʋɛtɛ, nii nu a kula Ɠɔoɠɔ GALAGI ʋɛ: ");
INSERT INTO tod_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Ni nui ta a ziilɛi zalaɠai ɠulana ga mama fee zalaɠai, toɠa kula ga ɓulu ʋɛlɛʋɛlɛgiti lɛʋɛ la su, gaayɔgai ga gulɔi, é ʋɛɛ ɓulu lɛɛvɛi ʋa, nii lɛʋɛ la su, gulɔi ʋuai ma, ta ɓulu ʋɛlɛʋɛlɛgiti, kpɛtɛai ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi. ");
INSERT INTO tod_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Toɠa ɓului ɠula ɓalaa, nii lɛʋɛi su, é pɛɛ ná-ziilɛi zalaɠai ʋa, mama fee vai zu. ");
INSERT INTO tod_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Vebɛani ɠilagilagi tago ɠa ɠula ma Ɠɔoɠɔ GALAGI ʋɛ. Naa ʋolu ta ɠɛ ga zalaɠa ɠula nui nɔnɔ, nii é ziilɛi zalaɠai ma ɲamai ʋiligai. ");
INSERT INTO tod_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ziilɛi zalaɠa zuai ɠa mi, naama voloi nɔ é ɠulazu la mama fee vai zu. Nu mina tanɔpɛ zɛ sobu ʋa zeeli. ");
INSERT INTO tod_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Ni nui ta a zalaɠa ɠulana minazeɠe daazeeli vaa zu, ɓaa vebɛanii vaa zu é daai ɠisu, ma zuai ɠa mi, naama voloi nɔ é kulazu la, nii a yɛ ʋoluzu, naa ɠa mi poluma zobui. ");
INSERT INTO tod_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Nii é yɛsu ga zalaɠa zuai mɔtai foloi zaʋasiɛi, naa ɠa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ni nu a naama yiilɛi zalaɠa zuai ta miina foloi zaʋasiɛi, zalaɠai laa la mɔ zoga, é la faa ʋaa naa ma, nii é kula. Toɠa ɠɛ ga anii kɔzɔai, nu-o-nu a ta miina, ná-faaɠaaza golai ma ɠasɔi ɠa la unma. ");
INSERT INTO tod_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","«Ma zuai fɔɔɠuai kɔzɔba anii ta ʋa, nu mina naa mi ɲɛgɛlɛin. Ma zuai ɠa ɠala. «Nui niiti kpein ti la ɠɔzɔni tɔgi letemazu, naati ta zoo ti ziilɛi zalaɠa zuai ta mi. ");
INSERT INTO tod_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Kɛlɛ nui nii kɔzɔai tɔgi letemazu, naa a ziilɛi zalaɠa zuai ta miina, é ga Ɠɔoɠɔ GALAGI nɔnɔi, naama nui ɓe ka leʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Zɔi a vɔɔɠuna anii ta ʋa, nii kɔzɔai, nuɓusɛi kɔzɔai, ɓaa suai kɔzɔai, ɓaa ani nɔpɛ é ga kɔzɔba anii, é ziilɛi zalaɠa zuai mi, é ga Ɠɔoɠɔ GALAGI nɔnɔi, naama nui ɓe ka leʋe ná-nuɓusɛiti ba.» ");
INSERT INTO tod_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: À mina nikɛ, ɓaa baala, ɓaa boli wulɔi mi ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Suai saai ɓɔɠɔ ʋɛ, ɓaa dɔɓɔ zuai ta paai, naama wulɔi ɠa zoo é ɠɛ ga wo-maavai ta ɠɛɛ anii nɔ, kɛlɛ wo la mia ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Zɔi a suai ma wulɔi ta mi, é ɠulazu ga zalaɠai, é ɠalazu abui ɠa Ɠɔoɠɔ GALAGI ʋɛ, naama nui ɓe ka leʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Ʋɛ nɔpɛ wa ɠɛ ná, à mina ɲamai mi, wɔnii nɔnɔi, ɓaa suai nɔnɔi. ");
INSERT INTO tod_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Zɔi nɔpɛ a ɲamai mi, ma zii nɔpɛ, naama nui ɓe ka leʋe ná-nuɓusɛiti ba.» ");
INSERT INTO tod_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Zɔi a ná-ziilɛi zalaɠai ɠula Ɠɔoɠɔ GALAGI ʋɛ, toɠa Ɠɔoɠɔ GALAGI nɔnɔi zeɠe ba. ");
INSERT INTO tod_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Zalaɠai nii maanɛai é ɠala abui ɠa, Ɠɔoɠɔ GALAGI ɠaazu, toɠa ʋa ga naa ɓɔɠɔ ʋɛ, ma wulɔi, ta ma ɠekegi, é ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Zalaɠa ɠula nui ɠa ma wulɔi ɠala zalaɠa ɠulazuʋɛ. Ma ɠekegi ɠa ɠɛ ga Aalɔn ta ná-doun zunuiti tɔnɔ. ");
INSERT INTO tod_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Wa-yiilɛi zalaɠaiti ka, wa ma yeezazu ɓalai ve zalaɠa ɠula nui ya. ");
INSERT INTO tod_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Aalɔn ná-doun zunuiti su, zɔi a ziilɛi zalaɠai ma ɲamai ta ma wulɔi ɠulana, naa ɠa ma yeezazu ɓalai zɔlɔɔ, é ɠɛ ga nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mazɔlɔɔ ziilɛi zalaɠaiti su, nii Izilayɛle nuiti ti kulazu, ma ɠekegi ta ma ɓalai niiti ta ɗa ɠula ga datɛɠɛ vai ma ʋoogi, nà ti zeɠe, gè ti ve zalaɠa ɠula nui Aalɔn ya ta ná-doun zunuiti zea, ga ɠɔoɠɔ tɔgi Izilayɛle nuiti ta so.» ");
INSERT INTO tod_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Daamiizuʋɛ ɠana, Aalɔn ta ná-doun zunuiti ti sɔlɔɔsu, zalaɠaiti su ti ɠalaai abui ɠa, Ɠɔoɠɔ GALAGI ʋɛ, é zo naama voloi ma, yeei ti lɛɛzu la ga ti zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Naa ɠa Ɠɔoɠɔ GALAGI Izilayɛle nuiti devezu la, ga é ve ti ya, é zo naama voloi ma, yeei gulɔ ɲadegai ziaa la ti ma. Toɠa ɠɛ ga ɠɔoɠɔ tɔgi ti-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Gala zalaɠai ma lɔgiti kana, ta vebɛ zalaɠai, ta koto gba zalaɠai, ta faazuɓɛtɛ zalaɠai, ta nu zei vai ma zalaɠai, ta ziilɛi zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ɠɔoɠɔ GALAGI ma leveiti feeni Moize ya, Sinayi gizei ma, voloi é devei veeni la Izilayɛle nuiti zea, ga ti ta-vebɛanii ve Ɠɔoɠɔ GALAGI ʋɛ Sinayi teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Aalɔn zeɠe ta ná-doun zunuiti ʋɔɔma, ta zalaɠa ɠula zeɠeiti, ta siɛma wulɔ ɲadegai, ta koto gba nikɛ zinɛi, ta baala sinɛ felegɔiti, ta ɓului lɛʋɛ la su, naama ɓɔlɔgi. ");
INSERT INTO tod_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Bɛbɛi kpein toli GALA daaɠomi seɠe ʋɛlɛi laaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moize naa ɠɛɛni, nii Ɠɔoɠɔ GALAGI deveni ga é kɛ. É bɛbɛi ɠaalɛɛni ba GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moize ɠɛni bɛbɛi ma: «À pɛtɛ, nii Ɠɔoɠɔ GALAGI deveai ga é ɠɛ.» ");
INSERT INTO tod_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moize ʋaani ga Aalɔn ta ná-doun zunuiti, é ti maagba ga ziɛi. ");
INSERT INTO tod_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","É seɠewuzeɠei looni Aalɔn ɠɔba, é saamaɠili ga saamaɠiligi. É tookɔba wolai looni kɔba, é zalaɠa ɠula zeɠei loo maazu, é gili ga zalaɠa ɠula zeɠei ma lokoi. ");
INSERT INTO tod_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","É kakazu zeɠei ʋilini kɔbu, é wuulimegi ta tumimegi ʋu kakazu zeɠei zu. ");
INSERT INTO tod_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","É bɔɔlɔgi lɔɔni nɔungi ʋa, é zanu sɛʋɛ goi ɠili kakalaʋɛ, nii é ga fee vai ma ʋoogi GALA bɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moize siɛma wulɔ ɲadegai zeɠeni, é siɛ seɠe ʋɛlɛ ɲadegai ma, ta aniiti kpein ti ɠɛni ná, ʋele ɠana é ti veeni la GALA bɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","É faza daa ɠɛɛni lɔfela zalaɠa ɠulazuʋɛ ma. É gulɔi ziɛni zalaɠa ɠulazuʋɛ ma, ta ná-sɔɔlaiti kpein, ta maagba aniɲakai ta ná-seiga anii, naa ɠa a kɛ é ti ve GALA bɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","É siɛma wulɔ ɲadegai ʋuuni Aalɔn nɔungi zu, é ta ziɛ ma, nii a kɛ é fe GALA bɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moize ʋaani ga Aalɔn ná-doun zunuiti, é ti maaɠili ga seɠewuzeɠeiti, é ti zaamaɠili ga saamaɠiligiti, é bɔɔlɔgiti dɔ ti unba, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","É ʋaani ga koto gba nikɛ zinɛi. Aalɔn ta ná-doun zunuiti ti yeeiti pɛɛni koto gba nikɛ zinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moize kɔdaaleʋeni, é ɲamai zeɠe, é ta ziɛ ga yeeɓeɠai zalaɠa ɠulazuʋɛ ma minɛiti ma, é zalaɠa ɠulazuʋɛ ɲade. É ɲamai mɔtai ʋuuni ya, zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ, é ɲade ga koto gba vai ɗa ɠɛ ná. ");
INSERT INTO tod_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","É ma wulɔi kpein seɠeni, nii felevelegai koozu zɔɔlaiti ma, ta ma mɔɔin ʋasuʋɛ, ta ma lɔɠɔ felegɔiti, é ɓɔ ti-ma wulɔiti ba, é naa ɠalani zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Kɛlɛ é nikɛ zinɛi mɔtai ɠalani ti-ʋuuzuʋɛ ʋoluʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea: ma zuai, ta ma ɠɔlɔi, naa ʋɛɛ ma ɓooiti ba. ");
INSERT INTO tod_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","É ʋaani ga gala zalaɠai ma ʋaala sinɛi. Aalɔn ta ná-doun zunuiti ti yeeiti pɛɛni baala sinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moize kɔdaaleʋeni, é ma ɲamai ʋili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","É baala sinɛi leʋeleʋeni, é kpulukpulu. É ma ungi ɠalani, ta ma ɓulukpulugiti, naa ʋɛɛ ma wulɔi ʋa. ");
INSERT INTO tod_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","É koozu zɔɔlaiti gbani ga ziɛi, ta kɔɠɔiti. É baala sinɛi pɛ galani zalaɠa ɠulazuʋɛ. Gala zalaɠai ɠɛni de, zalaɠai nii abui galaai, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","É ʋaani ga zɔɔma ʋaala sinɛi, ti zei vai ma ʋaala sinɛi. Aalɔn ta ná-doun zunuiti ti yeeiti pɛɛni baala sinɛi unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moize baala sinɛi ɠɔdaaleʋeni, é ma ɲamai ta zeɠe, é siɛ Aalɔn yeezazu ʋele woi yɔkpɔgi ma, ta zeezazu yeezinɛkpotogi ma, ta zeezazu ɠɔɠɔzinɛkpotogi ma. ");
INSERT INTO tod_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","É ʋaani ga Aalɔn ná-doun zunuiti, é ɲamai ziɛ ti-yeezazu ʋelei woi yɔkpɔgiti ma, ta ti-yeezazu yeezinɛkpotogiti, ta ti-yeezazu ɠɔɠɔzinɛkpotogiti. É ɲamai mɔtai ʋilini zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","É ma wulɔi zeɠeni, ta ma wɔɔngi, ta ma wulɔi kpein felevelegai koozu zɔɔlaiti ma, ta ma mɔɔin ʋasuʋɛ, ta ma lɔɠɔ felegɔiti, é ɓɔ ti-ma wulɔi ʋa, ta zeezazu ɓalai. ");
INSERT INTO tod_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ɓului lɛʋɛ la su, naama ɓɔlɔgi, nii seiɗai Ɠɔoɠɔ GALAGI ɠakala, é ɓulu ɠila seɠeni naama ɓɔlɔgi zu, ta ɓulu ʋɛlɛʋɛlɛ gila gulɔi ba, ta ɓulu lɛɛvɛ ɠila, é ti ʋuuni zalaɠa zuai ma wulɔi ma, ta ma yeezazu ɓalai ma. ");
INSERT INTO tod_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","É naama aniiti kpein puuni Aalɔn ta ná-doun zunuiti zea waa, ga ti ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Naa ʋolu, Moize ti ɠulani ti ya, é ti ɠala, zalaɠa ɠulazuʋɛ, gala zalaɠai maazu. Ti zei vai ma zalaɠai ɠɛni de, zalaɠai nii abui galaai, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moize ti zei vai ma ʋaala sinɛi ma ɠekegi zeɠeni, é datɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. Moize nɔnɔi ɠɛni ga naa, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moize siɛma wulɔ ɲadegai ta zeɠeni, ta ɲamai ta, nii é ɠɛni zalaɠa ɠulazuʋɛ. É ti vaza Aalɔn ta ná-seɠeiti ma, naa ʋɛɛ Aalɔn ná-doun zunuiti ta ta-zeɠeiti ba. É Aalɔn veeni GALA bɛ, ta ná-seɠeiti, naa ʋɛɛ ná-doun zunuiti ta ta-zeɠeiti ba. ");
INSERT INTO tod_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moize ɠɛni Aalɔn ta ná-doun zunuiti ma: «À suai ɠili GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Miná ɠa wa mi ná, é ʋɛɛ ɓului ʋa, nii é wo zei vai ma ɓɔlɔgi zu, eɠɛʋelei gè deveni la, gè ɠɛ ma: ‹Aalɔn ta ná-doun zunuiti ta mi.› ");
INSERT INTO tod_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Suai ta ɓului mɔtai é yɛsu, wa naa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Wa yɛ GALA daaɠomi seɠe ʋɛlɛi laaʋɛ eyɛsu folo lɔfela, wo mina zeɠe ná, eyɛsu wo zei voloi liegɔi laazeeli, mazɔlɔɔ folo lɔfela ɠa é ɠɛɛzu ga wo zei voloi. ");
INSERT INTO tod_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Nii kɛai za, Ɠɔoɠɔ GALAGI deveʋɛ ga naa ɠɛ wo ʋɛ ga koto gba vai. ");
INSERT INTO tod_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Wa yɛsu deɠɛmu GALA daaɠomi seɠe ʋɛlɛi laaʋɛ folo lɔfela, folo ʋɛɛ kpidi ʋa, wa Ɠɔoɠɔ GALAGI ná-deveiti so, naa ɠa a kɛ wo mina za, mazɔlɔɔ naa ɠa ma levei veeni zèa.» ");
INSERT INTO tod_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aalɔn ta ná-doun zunuiti ti naama vaiti kpein kɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni ga Moize maaʋele. ");
INSERT INTO tod_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Foloi lɔsaʋasiɛi ma, Moize Aalɔn ta ná-doun zunuiti tolini, ta Izilayɛle ɠɛwolaiti, ");
INSERT INTO tod_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","é ɠɛ Aalɔn ma: «Nikɛ yiʋo zinɛ ɠila seɠe koto gba zalaɠa vai zu, ta baala sinɛ ɠila gala zalaɠa vai zu, nɛɛʋuzu mina ɠɛ tanɔpɛ ba, è ti lo Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ɗa ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: ‹À boli zinɛ ɠila seɠe koto gba zalaɠai vaa zu, ta nikɛ yiʋo ɠila, ta baala ziʋo ɠila, kona gila keleiti, nɛɛʋuzu mina ɠɛ ti ʋa, gala zalaɠai vaa zu, ");
INSERT INTO tod_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ta nikɛ zinɛ ɠila, ta baala sinɛ ɠila ziilɛi zalaɠai vaa zu, naa ɠa a kɛ, ti ɠula ga zalaɠai Ɠɔoɠɔ GALAGI ɠaazu, ta vebɛ zalaɠai, nii é ga ani vukɔi, gaayɔgai ga gulɔi. Mazɔlɔɔ za Ɠɔoɠɔ GALAGI ɠa ɠulazu kɛlɛma wo ʋɛ.› » ");
INSERT INTO tod_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Nii Moize deveni, ti ʋaani ga naa GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Bɛbɛi kpein ge maaɓuɠani ná ʋa, ti lo Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moize ɠɛni ma: «Wa naa ɠɛ, nii Ɠɔoɠɔ GALAGI deveai, Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠa ʋaazu ɠulazu kɛlɛma wo ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moize ɠɛni Aalɔn ma: «Maaɓuɠa zalaɠa ɠulazuʋɛ ʋa. Ɗa-ɠotoi gba zalaɠai ɠula, ta ɗa-ɠala zalaɠai, è koto gba vai ɠɛ ɓɔɠɔ ʋɛ, ta nuɓusɛiti bɛ. Nuɓusɛiti ta-vebɛanii ɠula, è koto gba vai ɠɛ ti ʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI deveni la.» ");
INSERT INTO tod_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aalɔn maaɓuɠani zalaɠa ɠulazuʋɛ ʋa, é nikɛ yiʋoi ɠɔdaaleʋe tɔ ɓɔɠɔi ná-kotoi gba vai zu. ");
INSERT INTO tod_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Aalɔn ná-doun zunuiti ti ɲamai veeni zea. É yeeɓeɠai lɔɔni ɲamai wu, é ta ziɛ zalaɠa ɠulazuʋɛ ma minɛiti ma. É ɲamai mɔtai ʋuuni ya zalaɠa ɠulazuʋɛ ɠɔɠɔaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","É ma wulɔi ɠalani zalaɠa ɠulazuʋɛ, ta ma lɔɠɔiti, ta koto gba zalaɠa zuai ma mɔɔin ʋasuʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Kɛlɛ é ma zuai ta ma ɠɔlɔgi ɠalani abui ɠa, ti-ʋuuzuʋɛ ʋoluʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Aalɔn gala zalaɠa loganii ɠɔdaaleʋeni. Ná-doun zunuiti ti ɲamai veeni zea, é pili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ti gala zalaɠai veeni zea, teʋeleʋeai, é ɓulukpulu, é ʋɛɛ ma ungi ʋa, é ti ɠala zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","É koozu zɔɔlaiti ta kɔɠɔiti gbani, é ti ɠala zalaɠa ɠulazuʋɛ, gala zalaɠai maazu. ");
INSERT INTO tod_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Naa ʋolu, é nuɓusɛiti ta-zalaɠai ɠulani. É boli zinɛi zeɠeni nuɓusɛiti ta-ɠoto gba zalaɠai, é kɔdaaleʋe, é kula koto gba vai zu, eɠɛʋelei zalaɠa zua mɔungi ɠɛni la. ");
INSERT INTO tod_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","É gala zalaɠai ɠulani, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","É vebɛ zalaɠai ɠulani, é zeeɲɛ gila seɠe su, é naa ɠala zalaɠa ɠulazuʋɛ. Naa la ɓɔni gala zalaɠai ʋa, nii kulaai sobui. ");
INSERT INTO tod_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","É nikɛ zinɛi ɠɔdaaleʋeni, ta baala sinɛi ga ziilɛi zalaɠai, nuɓusɛiti faa zu. Aalɔn ná-doun zunuiti ti ɲamai veeni zea, é pili zalaɠa ɠulazuʋɛ ma, é ɠaku ma kpoloo. ");
INSERT INTO tod_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ti nikɛ zinɛi ta baala sinɛi ma wulɔi veeni zea: ma wɔɔngi, ta ma wulɔi é koozu zɔɔlaiti maavelevelegai, ta ma lɔɠɔiti, ta ma mɔɔin ʋasuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Ti ma wulɔiti puuni ma ɠekegiti su, é ma wulɔi ɠala zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aalɔn ma ɠekegiti ta zeezazu ɓalai zeɠeni, é ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu, eɠɛʋelei Moize ma levei veeni la. ");
INSERT INTO tod_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aalɔn yeeiti tɛɛni geezu nuɓusɛiti pɔ pelei, é tuya loo ti ʋɛ. Kpegai ma ga koto gba zalaɠai ɠula, ta gala zalaɠai, naa ʋɛɛ ziilɛi zalaɠai ʋa, é zeɠeni zalaɠa ɠulazuʋɛ, é yei. ");
INSERT INTO tod_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moize ta Aalɔn ti lɛɛni GALA daaɠomi seɠe ʋɛlɛi wu. Siɛgi zu ti ɠulani la ná, ti tuya looni nuɓusɛiti bɛ. Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani kɛlɛma nuɓusɛiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Abui ɠulani Ɠɔoɠɔ GALAGI ʋɔ bɛ, é gala zalaɠai ɠala, ta ma wulɔiti, niiti ti ɠɛni zalaɠa ɠulazuʋɛ. Nuɓusɛiti kpein ti kaani. Ti kpeeiti tooni ga koozunɛɛi, ti nɔkɔ. ");
INSERT INTO tod_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aalɔn ná-doun zunuiti Nadaɓe ta Aɓiyu ti ta-ansanse gala liɠiiti seɠeni, ti abulekaiti pu ti zu, ti ansansegi ʋu maazu. Naazu ti ʋaani ga abu ɠiligi Ɠɔoɠɔ GALAGI ɠaazu, niigi GALA ge la ɠɛni ma leve veeni. ");
INSERT INTO tod_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Gaamago nɔ, abui ɠulani Ɠɔoɠɔ GALAGI ʋɔ bɛ, é ti ɠala. Ti zaani Ɠɔoɠɔ GALAGI ɠakala. ");
INSERT INTO tod_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moize ɠɛni Aalɔn ma: «Naa ɠa Ɠɔoɠɔ GALAGI boni, siɛgi zu é ɠɛni la: ‹Niiti ti maaɓuɠazu bà, kɛni ti unfe nà-ɲadedai ma. Nà lɛbiyai zɔlɔɔ nuɓusɛiti kpein gaazu.› » Aalɔn maaɠɛni kpɔ. ");
INSERT INTO tod_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moize Misayɛle lolini ta Ɛlɛsafan, Uziyɛle ná-doun zunuiti, nii é ga Aalɔn kɛɛɠɛ kɛɛɠɛloin, é ɠɛ ti ma: «À maaɓuɠa bà, wo wo-ɠɛɛlointi seɠe, wo li ga tiye ade-ʋuuzuʋɛ ʋoluʋɛ, wo ti maaɠooza seizu ɲadegai ʋa.» ");
INSERT INTO tod_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ti maaɓuɠani ba, ti ti zeɠe ta-zeɠewuzeɠeiti su, ti li ga tiye ti-ʋuuzuʋɛ ʋoluʋɛ, eɠɛʋelei Moize boni la. ");
INSERT INTO tod_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moize ɠɛni Aalɔn ma, ta Eleazaal, ta Itamaal, Aalɔn ná-doun zunuiti: «À mina wɔundeɠaiti zɛ yaɠaba, wo mina wa-zeɠeiti bali ga, saa wɔlɔ vai zu, naa ɠa a kɛ, wo mina za, wo ʋa GALA ná-ziiɠaawanai maaloli bɛbɛi kpein ma. À wo-ɠɛɛlointi Izilayɛle ʋɛlɛyeɠeiti kpein zɛ ná, ti wɔlɔ naati ta-vaa zu, niiti Ɠɔoɠɔ GALAGI ti ɠalaai ga abui, nii é gaazogai. ");
INSERT INTO tod_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","À mina zeɠe GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, naa ɠa a kɛ wo mina za, mazɔlɔɔ Ɠɔoɠɔ GALAGI ná-siɛma wulɔ ɲadegai ɠa wo ma.» Ti naa ɠɛɛni, nii Moize bogai. ");
INSERT INTO tod_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Ɠɔoɠɔ GALAGI ɓɔɛni Aalɔn ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Mina dɔɔ ɓɔle, ɓaa kpɔleɓɔle ani nɔpɛ, nii a nu ɠaazulati, ɗa-o, è-loun zunuiti-yo, siɛgi zu wa ɠɛ lɛɛzu la GALA daaɠomi seɠe ʋɛlɛi wu, naa ɠa a kɛ wo mina za. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mazɔlɔɔ kɛni wo zoo zeeɠaaɠwɛɛzu ɠwɛɛsu ani ɲadegai ta ɲadetala gelei ʋa, ta nii kɔzɔai ta nii é la ɠɔzɔni. ");
INSERT INTO tod_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","À Izilayɛle nuiti kala ga tɔgi kpein, nii Ɠɔoɠɔ GALAGI feeni ti ya ga Moize maaʋele.» ");
INSERT INTO tod_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moize ɠɛni Aalɔn ma, ta doun zunu felegɔiti ti yɛni zea, Eleazaal ta Itamaal: «À vebɛ zalaɠai mɔtai zeɠe, nii é la ɠalani abui ɠa Ɠɔoɠɔ GALAGI ɠaazu. À mi zalaɠa ɠulazuʋɛ ɠobaʋɛ, lɛʋɛ mina ɠɛ ba, mazɔlɔɔ ani ʋe ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Wa mi ada ɲadegai ta, naa ɠa é ga wo-laamiizuʋɛ, wa è-loun zunuiti, zalaɠa aniiti saama, ti ɠalazu abui ɠa Ɠɔoɠɔ GALAGI ɠaazu, mazɔlɔɔ devei ɠa naa, é veeni zèa. ");
INSERT INTO tod_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ma ɠekegi ta ma ɓalai niiti ti ɠula ga datɛɠɛ vai ma ʋoogi, wa naati mi ada ɲadegai ta, ɗa-o, è-loun zunuiti-yo, ta è-loun anzanuiti ti è ʋɔ bɛ, mazɔlɔɔ ti veeʋɛ wo ʋɛ, ga é leve ɗɔun è ʋɛ, wa è-loun zunuiti, Izilayɛle nuiti ta-yiilɛi zalaɠaiti su. ");
INSERT INTO tod_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","É ɠula gulɔiti polu, ti maanɛai ti ɠala, Izilayɛle nuiti ta ʋa ga ma ɠekegi ta ma ɓalai. Ti ɠulaai ma ga datɛɠɛ vai ma ʋoogi, ta ɠɛ ga ɗɔnɔ, wa è-loun zunuiti, ti è ʋa, ɠɔoɠɔ tɔgi ɠa ɠɛ ga ná, eɠɛʋelei Ɠɔoɠɔ GALAGI deveni la.» ");
INSERT INTO tod_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moize koto gba woli zinɛi ɠaiziɛni, kɛlɛ galaa ɠɛni de niina. É yiiɠaawanani naazu Eleazaal ma, ta Itamaal, Aalɔn ná-doun zunuiti ti yɛni ná, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Leeni vaa zu wo la koto gba zalaɠa zuai miini ada ɲadegai ta? Toɠa ga anii gola ɲadegai, Ɠɔoɠɔ GALAGI feai wo ʋɛ, naa ɠa a kɛ wo bɛbɛi ná-faaɠaazagi zeɠe, naa ɠa a kɛ wo ná-kotoi gba bɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Wɛlɛ, wo la liini ga zalaɠa zuai ma ɲamai seizu ɲadegai ɠoozuʋɛ. Wo maanɛɛni, wo zalaɠai ma zuai mi ada ɲadegai ta, eɠɛʋelei gè ma levei veai la.» ");
INSERT INTO tod_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aalɔn ɠɛni Moize ma: «Wɛlɛ, ti ta-ɠoto gba zalaɠai ɠulaa za, ta ta-ɠala zalaɠai Ɠɔoɠɔ GALAGI ɠaazu. È suɠwɛɛni sɔ, nii kɛai ga ze. Ni za gè ɠɛa koto gba zalaɠai miini, naa a la ɠɛ ga faa ʋagɔ Ɠɔoɠɔ GALAGI ɠaazu ɓaa?» ");
INSERT INTO tod_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moize naama wooiti mɛnini, é yeezei ti wu. ");
INSERT INTO tod_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ ta Aalɔn, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«À ɓɔɛ Izilayɛle nuiti pɔ, wo ɠɛ ti ma: Suaiti kpein saama, niiti ti eteai zu, wɛlɛ niiti ka wa zoo wo ti mi. ");
INSERT INTO tod_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Wa zoo wo suai ma zii pɛ mi, nii polokagi ɠaaʋaliai, é miizu, é ɗa tɛ ʋolu. ");
INSERT INTO tod_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Kɛlɛ niiti wo la ti mia, anɛɛ ni ti-ʋolokagi ɠaaʋaliʋɛ, ɓaa ti miizu, ti ɗa tɛ ʋolu, naati ta ga niiti: ɲɔmɛi, anɛɛ ni toɠa miizu, é ɗa tɛ ʋolu, kɛlɛ polokagi ɠaa la ʋalini. Wa deve ga kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Foevoegoi ɓalaa ɠa miizu, é ɗa tɛ ʋolu, kɛlɛ polokagi ɠaa la ʋalini, wa deve ga kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Zaɓei ɓalaa ɠa miizu, é ɗa tɛ ʋolu, kɛlɛ polokagi ɠaa la ʋalini, wa deve ga kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Boigi ɓalaa, polokagi ɠaaʋaliʋɛ, kɛlɛ é la miizu, é ʋa ɗa tɛ ʋolu, wa deve ga kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","À mina ti-ma zuai ta mi, wo mina vɔɔɠu ti-ma ʋoomai ta ʋa. Wa ti leve ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Ziɛ wu zuaiti kpein su, wɛlɛ niiti ka wa zoo wo ti mi: niiti ma woekegi ti ʋa, ta maaɠalai ti ma, ti ziɛiti bu, é ɠɛni ga kpoloɗɛiti ɓaa ziɛ wolaiti. ");
INSERT INTO tod_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Kɛlɛ wa naati deve ga ti ɠɔzɔʋɛ, niiti kpein ma woeke ge la ti ʋa, ɓaa maaɠala la ti ma, ti kpein saama, ti yɛnvuzu ziɛi wu, é ɠɛni ga kpoloɗɛiti ɓaa ziɛ wolaiti. ");
INSERT INTO tod_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Wa ti leve ga ti ɠɔzɔʋɛ. À mina ti-ma zuai ta mi, wa ti-ma ʋoomai leve ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Wa naati kpein deve ga ti ɠɔzɔʋɛ wo ɠaazu, niiti ti ziɛiti bu, ma woeke ge la ti ʋa, maaɠala la ti ma. ");
INSERT INTO tod_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Wɔniiti saama, wɛlɛ niiti ka wa ti leve ga ti ɠɔzɔʋɛ, nu la ti mia: ɗuai ma zii pɛ, koɠɛi ma zii pɛ, ");
INSERT INTO tod_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","seeʋei ma zii pɛ, ");
INSERT INTO tod_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kalawɔnii ma zii pɛ, ");
INSERT INTO tod_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","sizigoi ma zii pɛ, buungi ma zii pɛ, ");
INSERT INTO tod_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kpoloɗɛ laaʋɛ wɔnii ma zii tanigaa, ");
INSERT INTO tod_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ziɛ wɔnii ma zii tanigaa, ");
INSERT INTO tod_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ta zɛgbɛlutugi, ta dɛvɛi. ");
INSERT INTO tod_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Fuluani goi kpein koʋegi ba, é ɗa ziɛ ɠɔɠɔiti ga, wa naati deve ga ti ɠɔzɔʋɛ wo ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Kɛlɛ fuluaniiti kpein saama, ti ɠoʋesu, ti ɗa ziɛ ɠɔɠɔiti ga, wa zoo wo naati mi, niiti ti-ɓeɠaiti ti ti-ɠɔɠɔzapalagiti maazuʋɛ, ti ɗa ʋili zooi ma. ");
INSERT INTO tod_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Pɛtɛ nii wa zoo wo mi: kotogi ta kpazinɛgi, ta ti-ma ziiti. ");
INSERT INTO tod_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Wa fuluani zɔiti deve ga ti ɠɔzɔʋɛ, niiti ti ɠoʋesu, ta kɔɠɔi ti ʋa. ");
INSERT INTO tod_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Suai tanigaa ta ná, ta zoo ti wo ɠɔzɔ, nu-o-nu a vɔɔɠu ti-ma ʋoomai ta ʋa, naa ɠa ɠɔzɔ eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Nu-o-nu a ti-ma ʋoomai ta zeɠe, kɛni é ná-seɠeiti gba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Wa suai naa kpein deve ga kɔzɔʋɛ, nii polokagi ba kɛlɛ kɔɠɔi ɠaa la ʋalini, ɓaa é la miizu, é ʋa ɗa tɛ. Nu-o-nu a vɔɔɠu ta ʋa, toɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Wa naati kpein deve ga ti ɠɔzɔʋɛ, niiti ti-ɠɔɠɔi naani, ti ziɛzu ti-ɠɔɠɔzapalagiti ga. Nu-o-nu a vɔɔɠu ti-ma ʋoomai ta ʋa, toɠa ɠɔzɔ eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Nu-o-nu a ti-ma ʋoomai ta zeɠe, kɛni é ná-seɠeiti gba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. Wa ti leve ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Pɛtɛ, sua goiti saama, ti ɓokposu zooi ma, niiti wa ti leve ga ti ɠɔzɔʋɛ, naati ta ga: inɛgi ma zii pɛ, ");
INSERT INTO tod_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ta zeegoi, ta kooloi ma zii pɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wa ti leve ga ti ɠɔzɔʋɛ, sua goiti saama. Nu-o-nu a vɔɔɠu ti-ma ʋoomai ta ʋa, toɠa ɠɔzɔ eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Sɔɔla kpein, ti-ma ʋoomai ta a vɔɔɠu ba, naa ɠa ɠɔzɔ: gulu aniɲakai, ɓaa seɠei, ɓaa kɔlɔ, ɓaa ɓɔlɔ, ɓaa aniɲaka kpein nu a ɓɛdɛ ɠula su. Kɛni é gba ga ziɛi, kɛlɛ kɔzɔai ɠa yɛ de eyɛsu kpɔkɔi zeeli, naa ʋolu toɠa ɲade niina. ");
INSERT INTO tod_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ni ti-ma ʋoomai a loona pɔlɔ liɠii zu, su anii ɠa ɠɔzɔ, wa aniɲakai naa wolo. ");
INSERT INTO tod_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Daamiani kpein a ɠɛ ga nu mi, ni pɔlɔ liɠii naa zu ɗɛi ta a ʋuuna ma, naa ɠa ɠɔzɔ. Ni ti-ma ʋoomai a loona aniɲakai nɔpɛ su, kpɔɔle ani kpein, nii a ɠɛ su, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Sɔɔla kpein, ti-ma ʋoomai ta a vɔɔɠu ba, naa ɠa ɠɔzɔ. Ni a ɠɛna ga sulugi ɓaa abu laazuʋɛti, wa ti ɠoloɠolo. Ti ɠɔzɔʋɛ, wa ti leve ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ni a ɠɛna ga ziɛungi ɓaa ziɛ makɛsuʋɛti, naati ti la ɠɔzɔa, ti ɲadegai ɠa yɛ de, kɛlɛ zɔi nɔpɛ a vɔɔɠu ti-ma ʋoomai ta ʋa, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ti-ma ʋoomai ta a loona ani zuwu ma, nii é vazasu, naa ɲadegai ɠa yɛ de. ");
INSERT INTO tod_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Kɛlɛ ni nu a ziɛi ʋuuna ani zuwui ma, ta ti-ma ʋoomai ta loo ani zuwui naa ma, wa deve ga kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Suaiti ti ɠɛɛzu wo ʋɛ ga daamianigi, naa ta a zaana, zɔi a vɔɔɠu ma ʋoomai ʋa, toɠa ɠɔzɔ eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Zɔi a ma zua ʋoomai ta mi, kɛni é ná-seɠeiti gba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. Zɔi a ma ʋoomai zeɠe, kɛni é ná-seɠeiti gba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Wa sua goi naati kpein deve ga ti ɠɔzɔʋɛ, niiti ti ɓokposu zooi ma. Nu mina ta mi ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","À mina sua goi naa tanɔpɛ mi ɲɛgɛlɛin, niiti ti ɓokposu zooi ma, anɛɛ niiti ti ɓokposu ɠogi ma, anɛɛ niiti ti ziɛzu ɠɔɠɔ naanigɔiti ga, ɓaa ɠɔɠɔ mɔinmɔingiti ga, mazɔlɔɔ wa ti leve ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","À mina ɓɔɠɔ ɠɔzɔ ga naama zuaiti ti ɓokposu. À mina ɓɔɠɔ ɠɛ ga ɲadetala nu ga ti maaʋele. ");
INSERT INTO tod_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. À ɓɔɠɔ ɲade, wa ɲade, mazɔlɔɔ nɔ̀un ɲàdegɛ. À mina ɓɔɠɔ ɠɔzɔ ga naama zua goiti, ti ɓokposu zooi ma. ");
INSERT INTO tod_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é wo ɠula Ezipete yooi ʋa, ga gè ɠɛ ga wa-ƓALAGI. À ɲade, mazɔlɔɔ nɔ̀un ɲàdegɛ.» ");
INSERT INTO tod_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Tɔgi ɠana, é ʋilɛ suaiti ta-vai ʋa, ta wɔniiti, ta fuluaniiti kpein ti vulua, ti yɛnvuzu ziɛiti bu, ta fuluaniiti ti ɓokposu zooi ma, ");
INSERT INTO tod_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","naa ɠa a kɛ wo zɔɠɔzu ɠwɛɛ ani ɲadegaiti ba, ta niiti ti ɠɔzɔai, suai nu a mi, ta suai nu la mia. ");
INSERT INTO tod_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu anzanui a kogi zeɠena la, é doun zunu zɔlɔɔ, toɠa ɠɔzɔ folo lɔfela laawu. Toɠa ɠɔzɔ eɠɛ ná-alu kaa ziɛgi ma yeeɠɛɠalai. ");
INSERT INTO tod_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Foloi lɔsaʋasiɛi ma, doungoi ɠa lati pɛlɛʋolu. ");
INSERT INTO tod_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Toɠa yɛ dɛ mɔnɔ ɓɔɠɔ ɲadesu folo ʋuusaʋagɔ maazu saʋagɔ (33) laawu ɲamai vaa zu, é mina vɔɔɠu ani ɲadega ɠila kpalaa ba, é mina li seizu ɲadegai, eyɛsu ná-ɲade foloiti daazeeli. ");
INSERT INTO tod_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Ni a anzanu loun zɔlɔɔna, kɔzɔai ɠa yɛ de dɔɔɠɔ felegɔ laawu, eɠɛ ná-alu kaa ziɛgi ma yeeɠɛɠalai. Toɠa yɛ ɓɔɠɔ ɲadesu folo ʋuulɔzita maazu lɔzita (66) laawu. ");
INSERT INTO tod_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Siɛgi zu ná-ɲade foloiti daazeelizu la, zunu loin ná-faa zu, ɓaa anzanu loin ná-faa zu, toɠa ʋa ga kona gila baala ziʋoi zalaɠa ɠula nui ʋɔ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, ga é kɛ ga gala zalaɠai, ta poopo kpokpa gila, ɓaa kpumago ɠila, é kɛ ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Zalaɠa ɠula nui ɠa ti ɠula Ɠɔoɠɔ GALAGI ɠaazu, é koto gba vai ɠɛ bɛ. Toɠa ɲade naama ɲama ɠula ba vai ma kɛai la. Tɔgi ɠana anzanui ná-faa zu, nii é zunu loin zɔlɔɔsu, ɓaa anzanu loin. ");
INSERT INTO tod_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ni ani la nu ya, a baala ziʋoi zɔlɔɔ da, toɠa kpumago felegɔ zeɠe, ɓaa poopo kpokpa felegɔ, gilagi ɠa ɠɛ ga gala zalaɠai, zɔi ɠɛ ga koto gba zalaɠai. Zalaɠa ɠula nui ɠa koto gba vai ɠɛ bɛ, toɠa ɲade.» ");
INSERT INTO tod_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Siɛgi zu nui ta ɠɔlɔgi maaɓokolosu da, ɓaa poʋoɠulɔi ɠɛ ma, ɓaa gɛlɛɠɛlɛgi, nii é ɠɛɛzu ga kulama zeeɓɛi kɔlɔgi ma, ta lii la zalaɠa ɠula nui Aalɔn ʋɔ, ɓaa ná-doun zunui taɠila pɔ. ");
INSERT INTO tod_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Zalaɠa ɠula nui ɠa seeɓɛi ɠɛʋele ʋɛtɛ, nii kulaai kɔlɔgi ma. Ni ma leɠai ɠoleʋɛ su, é yei, suɠooza kɔlɔgi ʋa, toɠa ga kulama zeeɓɛi ma zii ta. Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ, é dɛɛ ga nui naa ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ni ani ɠolekolegi é kɔlɔgi ma, é la yeini, su ʋa ɠooza kɔlɔgi ʋa, ma leɠai la ɠoleni, zalaɠa ɠula nui ɠa naama nui lɛ pɛlɛi wu, é daaɠulu ma, é yɛ ná folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ foloi lɔfelasiɛi ma. Ni seeɓɛi la ɠɛ liini luɠɔma, ta é la vazani kɔlɔgi ma, zalaɠa ɠula nui ɠa tɛ pɛlɛi wu mɔnɔ ná zeizu velesiɛi, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ, ná zeizu velesiɛi foloi lɔfelasiɛi ma. Ni tago zuzasaga, é la vazani kɔlɔgi ma, zalaɠa ɠula nui ɠa dɛɛ ga nui naa ɲadegɛ, poʋoɠulɔi ʋe. Toɠa ná-seɠeiti gba, toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kɛlɛ ni poʋoɠulɔi a vazana kɔlɔgi ma, é ɓɔɠɔ lɛa ʋoluma ga zalaɠa ɠula nui, naa dɛɛ ga ɲadegɛ, toɠa ɓɔɠɔ lɛ ga zalaɠa ɠula nui ná zeizu velesiɛi. ");
INSERT INTO tod_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Naa ɠa kɛʋele ʋɛtɛ. Ni poʋoɠulɔi vazagɛ kɔlɔgi ma, zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ. Kulama zeeɓɛi ma zii ta ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Siɛgi zu kulama zeeɓɛi ma zii ta ɠɛɛzu la nui ta ʋa, ta lii la zalaɠa ɠula nui ʋɔ. ");
INSERT INTO tod_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Naa ɠa kɛʋele ʋɛtɛ. Ni kɔlɔgi maaɓokologɛ, é ɠole, ta maaɓokolosuʋɛ ma leɠai ɠole, ta ma zua lɛtɛgi ɓokolo su, ");
INSERT INTO tod_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","kulama zeeɓɛi ʋe é naama nui ɠɔlɔgi wu. Zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ, é la tɛa pɛlɛ wu, é ʋa daaɠulu ma, mazɔlɔɔ kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ni kulama zeeɓɛi a ɠulana ma, é kɔlɔgi maazeɠe, é zo nɔungi ma, eyɛsu é zeeli kɔɠɔiti ma, ʋɛti zalaɠa ɠula nui ɠaazulosu naati ba, ");
INSERT INTO tod_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","naa ɠa kɛʋele ʋɛtɛ. Ni a kaana ga kulama zeeɓɛi kɔlɔgi maaʋɛ pɛ seɠea, toɠa dɛɛ ga nui nii seeɓɛi ba, ɲadegɛ, tɔɔzei maaʋɛ ɠolea ɲɛgɛlɛin, ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kɛlɛ voloi ta ma zua lɛtɛgi ɠaa la tɔun ba, toɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni a ma zua lɛtɛgi ɠaana, toɠa dɛɛ ga kɔzɔʋɛ. Ma zua lɛtɛgi ɠɔzɔʋɛ, kulama zeeɓɛi ma zii ta ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ni ma zua lɛtɛgi a valibona, é ɠole, toɠa li zalaɠa ɠula nui ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Naa ɠa kɛʋele ʋɛtɛ. Ni kɔlɔgi maaɠolea, zalaɠa ɠula nui ɠa dɛɛ ga nui nii seeɓɛi ba, ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Siɛgi zu divologi losu la nui ta ʋa, divologi zeɠe ba, é ɠɛdɛ, ");
INSERT INTO tod_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ʋɛ divologi ɠɛni ná, ani ɓudɔ ɠole ga ɠulana ná, ɓaa ani ɠolegi maaɓɔikpɔigai, naama nui ɠa ɓɔɠɔ lɛ ga zalaɠa ɠula nui. ");
INSERT INTO tod_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni seeɓɛi yeiʋɛ, suɠooza kɔlɔgi ʋa, ta ma leɠai ɠole, zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ. Kulama zeeɓɛi ma zii ta ʋe, nii kulaai divologi zu. ");
INSERT INTO tod_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kɛlɛ ni zalaɠa ɠula nui a kaana ga seeɓɛi zuzasagɛ, é la yeini, su ʋa ɠooza kɔlɔgi ʋa, ma leɠai ʋa ɠole, toɠa nui naa lɛ pɛlɛi wu, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ni seeɓɛi a vazana kɔlɔgi ma, zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ. Kulama zeeɓɛi ma zii ta ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kɛlɛ ni seeɓɛi a yɛna ada ɠilagi nɔ, é la vazani maaʋɛ, toɠa ga divologi ma ʋilii. Zalaɠa ɠula nui ɠa dɛɛ ga ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Siɛgi zu abui nui ta maaɠalazu la, gɛlɛɠɛlɛ kolegi ɠula galazuʋɛ ʋogi zu, ɓaa koleai maaɓɔikpɔi, ");
INSERT INTO tod_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni ma leɠai a ɠolena gɛlɛɠɛlɛgi zu, é yei suɠooza kɔlɔgi ʋa, kulama zeeɓɛi ʋe, nii kulaai gala ʋilii zu. Zalaɠa ɠula nui ɠa dɛɛ ga nui naa ɠɔzɔʋɛ. Kulama zeeɓɛi ma zii ta ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kɛlɛ ni zalaɠa ɠula nui a kaana ga seeɓɛi zuzasagɛ, é la yeini, su ʋa ɠooza kɔlɔgi ʋa, ma leɠai ʋa ɠole, toɠa nui naa lɛ pɛlɛi wu, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ foloi lɔfelasiɛi ma. Ni seeɓɛi vazaga kɔlɔgi ma, zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ. Kulama zeeɓɛi ma zii ta ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kɛlɛ ni seeɓɛi a yɛna ada ɠilagi nɔ, é la vazani kɔlɔgi ma, suzasaga, gala ʋilii maaɓokologi nɔ ʋe, zalaɠa ɠula nui ɠa dɛɛ ga ɲadegɛ, mazɔlɔɔ gala ʋilii ʋe. ");
INSERT INTO tod_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Siɛgi zu seeɓɛi ɠɛɛzu la zunui ta ɓaa anzanui ta nɔungi zu, ɓaa nɛkpɛi ʋa, ");
INSERT INTO tod_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","zalaɠa ɠula nui ɠa seeɓɛi ɠɛʋele ʋɛtɛ. Ni zeiʋɛ, suɠooza kɔlɔgi ʋa, ma leɠai ma ɓɔikpɔigi ɠa su, pɛlɛʋɛlɛgai, zalaɠa ɠula nui ɠa dɛɛ ga nui naa ɠɔzɔʋɛ. Gɛlɛɠɛlɛgi ʋe, kulama zeeɓɛi ma zii ta ʋe é nɔungi zu, ɓaa é nɛkpɛi ʋa. ");
INSERT INTO tod_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ni zalaɠa ɠula nui a kaana ga seeɓɛi la yeini, su ʋa ɠooza kɔlɔgi ʋa, ma leɠa ʋagɔ la ná, toɠa tɛ pɛlɛi wu, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Zalaɠa ɠula nui ɠa seeɓɛi ɠɛʋele ʋɛtɛ foloi lɔfelasiɛi ma. Ni ma leɠai ma ɓɔikpɔi ge la su ɲɛgɛlɛin, seeɓɛi la vazani ma, é ʋa yei, su ʋa ɠooza kɔlɔgi ʋa, ");
INSERT INTO tod_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","zɔi seeɓɛi ma, naa ɠa nɔungi wo ta kpɛlɛi, kɛlɛ é la miná woga, ʋɛ seeɓɛi ná. Zalaɠa ɠula nui ɠa tɛ pɛlɛi wu mɔnɔ ná zeizu velesiɛi, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Zalaɠa ɠula nui ɠa seeɓɛi ɠɛʋele ʋɛtɛ foloi lɔfelasiɛi ma. Ni seeɓɛi la vazani ma, é ʋa yei, su ʋa ɠooza kɔlɔgi ʋa, zalaɠa ɠula nui ɠa dɛɛ ga ɲadegɛ. Toɠa ná-seɠeiti gba, toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kɛlɛ ni seeɓɛi a vazana kɔlɔgi ma, dɛai ʋoluma ga ɲadegɛ, ");
INSERT INTO tod_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni seeɓɛi vazagɛ kɔlɔgi ma, zalaɠa ɠula nui la mɔ wɛlɛa ga ma leɠa ɓɔikpɔi faa, kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Ni seeɓɛi la liini luɠɔma gaazu, ma leɠa ʋagɔiti ti ʋɔnɔga, seeɓɛi ɠɛdɛga, é ɲadega. Zalaɠa ɠula nui ɠa dɛɛ ga ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Siɛgi zu gɛlɛɠɛlɛ kolegiti ti ɠulazu la zunui ta ɓaa anzanui ta maaʋɛ, ");
INSERT INTO tod_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni gɛlɛɠɛlɛgi ɠaaɠolekolegɛ, seeɓɛi ʋe, é la ɲɔuni, nui naa ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Siɛgi zu zunui ta ɠɛɛzu ná la, undeɠa la unma, toɠa ga kpaana nui, ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ni undeɠa la unma tosaamaʋɛ, é ʋa toʋala ʋelei, kpaana nui ʋe kakala ʋelei, ɲadegɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kɛlɛ ni seeɓɛi koleai maaɓɔikpɔi naa ɠa kpaanagi zu, kakala ʋelei ɓaa poluʋelei, kulama zeeɓɛi ɠana, kulaai kpaanagi zu. ");
INSERT INTO tod_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Ni seeɓɛi ɓokologɛ, é ɠole, maaɓɔikpɔi kpaanagi zu, poluʋelei ɓaa kakala ʋelei, kulaai ga kulama zeeɓɛi kɔlɔgi ma, ");
INSERT INTO tod_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","kulama zeeɓɛi ma zii ta ʋe, kɔzɔʋɛ. Zalaɠa ɠula nui ɠa dɛɛ ga kɔzɔʋɛ. Nɔungi zu ɠa seeɓɛi ná. ");
INSERT INTO tod_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Seeɓɛ nui ɠa ná-seɠei ʋali ga, é too ɠɔba, é nɔundeɠaiti zɛ yaɠaba, é daaʋɛ maalɔɔɠu, é ɗa kpeei loo, é ɗa ɠɛ ma: ‹Kɔ̀zɔʋɛ! Kɔ̀zɔʋɛ!› ");
INSERT INTO tod_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Eyɛsu seeɓɛi ɓe ba, toɠa yɛ kɔzɔyai zu. Tɔɔzei kɔzɔʋɛ, tɔ ɠila ka a zei yɛ, seizuʋɛ ɠa ɠɛ ga ti-ʋuuzuʋɛ ʋoluʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Siɛgi zu fuinfuingi ʋogi a ɠɛna la seɠei zu, baala deɠa zeɠei zu, ɓaa geze zeɠei zu, ");
INSERT INTO tod_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ɓaa fɛlɛ zeɠei zu, ɓaa kɔlɔ zeɠei ta ʋa, ɓaa kɔlɔ zɔɔlai tanɔpɛ ba, ");
INSERT INTO tod_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ni fuinfuingi ʋogi a ɓiinkpiinna ɓaa é ɓɔikpɔi seɠei zu, ɓaa kɔlɔi zu, fuinfuingi ʋe, maanɛai é lɛ ga zalaɠa ɠula nui. ");
INSERT INTO tod_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Zalaɠa ɠula nui ɠa kɛʋele ʋɛtɛ. Toɠa naama anii lɛ pɛlɛi wu, é daaɠulu ma folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Toɠa kɛʋele ʋɛtɛ foloi lɔfelasiɛi ma. Ni fuinfuingi ʋogi a vazana seɠei zu, ɓaa kɔlɔi ma, toɠa ga fuinfuingi, é sumiizu, anii naa ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Toɠa seɠei ɠala, ɓaa kɔlɔi, niigi fuinfuingi ʋogi ba, mazɔlɔɔ fuinfuingi ʋe, é sumiizu. Toɠa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«Kɛlɛ ni zalaɠa ɠula nui a kaana ga fuinfuingi ʋogi la vazani seɠei zu, ɓaa kɔlɔi, ");
INSERT INTO tod_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","zalaɠa ɠula nui ɠa devei ve ga ti naa gba, nii fuinfuingi ʋɛai ba. Toɠa tɛ pɛlɛi wu, é daaɠulu ma ná zeizu velesiɛi folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Zalaɠa ɠula nui ɠa fuinfuingi naa ʋɛtɛ, anii naa gbaai ʋoluma. Ni fuinfuingi ʋogi la zeɠeni ɠɛʋele ma, anɛɛ ni é la vazani, anii naa ɠɔzɔʋɛ. Toɠa ɠala, anɛɛ ni fuinfuingi ɠa gaazu ʋagɔi ɓaa gaazu ɲɔi ma. ");
INSERT INTO tod_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ni a kaana ga fuinfuingi ʋogi ɠaazasaga, anii naa gbaai ʋoluma, toɠa ná leʋe seɠei ʋa, ɓaa kɔlɔi. ");
INSERT INTO tod_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ni fuinfuingi ʋogi a ɠulana mɔnɔ kɛlɛma seɠei ma, ɓaa kɔlɔi, fuinfuingi ʋe, é sumiizu. Nii fuinfuingi ʋɛai ba, naa ɠa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Seɠei ɓaa kɔlɔi nii gbaai, fuinfuingi ʋogi zeɠe ba, naa ɠa gba ʋolu ná zeizu velesiɛi, toɠa ɲade.» ");
INSERT INTO tod_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Tɔgi ɠana, é ʋilɛ ani nɔpɛ ba, nii maaʋɛ vuinfuinsu, é ɠɛni ga baala deɠa zeɠei, ɓaa geze zeɠei, ɓaa fɛlɛ zeɠei, ɓaa kɔlɔ zeɠei, ɓaa kɔlɔ zɔɔlai tanɔpɛ, pelegi a ɠwɛɛ da ni ɲadegɛ, ɓaa ni kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Wɛlɛ pelegi tɔgi a ɠɛ la, é ʋilɛ kulama zeeɓɛ nui ʋa, ná-ɲade foloi vaa zu. Ta ʋaa la zalaɠa ɠula nui ʋɔ. ");
INSERT INTO tod_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Toɠa ɠula ti-ʋuuzuʋɛ ʋa, é kulama zeeɓɛ nui ɠɛʋele ʋɛtɛ. Ni kulama zeeɓɛ nui ɠɛdɛga, ");
INSERT INTO tod_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","zalaɠa ɠula nui ɠa devei ve ga ti wɔni felegɔ zeɠe, ti vulua, ti ɲadegai, ta sɛdele gulu ɓuɠai, ta geze ɓɔi sɔsɔgi, ta ɠizɔɔpe tufa ɓifɔgi, ná-ɲade fai zu. ");
INSERT INTO tod_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Toɠa devei ve ga ti wɔnii gila kɔdaaleʋe pɔlɔ liɠii maazu, daavegai ga ziɛungi zu ɗɛi. ");
INSERT INTO tod_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Toɠa wɔni vului zeɠe, ta sɛdele gulu ɓuɠai, ta geze ɓɔi sɔsɔgi, ta ɠizɔɔpe tufa ɓifɔgi, é ti lɔ wɔnii ɠɔdaaleʋeai ma ɲamai wu. ");
INSERT INTO tod_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Toɠa faza daa ɠɛ lɔfela naa ma, nii kulama zeeɓɛi ɠɛa ma, maanɛai ga é ɲade. Naa ʋolu toɠa dɛɛ ga ɲadegɛ, é yeeɓe wɔni vului ʋa, é li dɔɓɔi zu. ");
INSERT INTO tod_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Zɔi é ɓɔɠɔ ɲadesu, naa ɠa ná-seɠeiti gba, é ɓɔɠɔ maaleɠai kpein bo, a maagbana ziɛi wu, toɠa ɲade. Naa ʋolu toɠa zoo é lɛ ti-ʋuuzuʋɛ, kɛlɛ é la zeiɗa ná-seɠe ɠotai wu, eyɛsu folo lɔfela leʋe. ");
INSERT INTO tod_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Folo lɔfelasiɛi, toɠa maaleɠai kpein bo mɔnɔ, nɔungi ta kpɛlɛi, ta gaazu ɠɔ poluʋɛti. Toɠa ná-seɠeiti gba, é ɓusɛi maagba ga ziɛi, toɠa ɲade niina. ");
INSERT INTO tod_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Foloi lɔsaʋasiɛi, toɠa baala ziʋo zinɛ felegɔiti seɠe, niiti nɛɛʋuzu la ti ʋa, ta kona gila baala saai, nii nɛɛʋuzu la ba, ta ɓulu vukɔ ʋagɔi kilo taaʋuugɔ, nii gaayɔgai ga gulɔi, ta gulɔi litɛlɛ ɠaaɠwɛsui, é ɠɛ ga vebɛ zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Zalaɠa ɠula nui nii é ɲade fai ɠɛɛzu, naa ɠa zunui ɠula kɛlɛma, nii é ɓɔɠɔ ɲadesu, ta naama aniiti kpein Ɠɔoɠɔ GALAGI ɠaazu, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Zalaɠa ɠula nui ɠa baala ziʋo zinɛiti gila seɠe, é kula ga faazuɓɛtɛ zalaɠai, é ʋɛɛ gulɔi litɛlɛ lukpɛgi ʋa. Toɠa ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Toɠa baala ziʋoi ɠɔdaaleʋe, ʋɛ ta ɗa koto gba zalaɠa zuaiti kɔdaaleʋe ná, ta gala zalaɠaiti, ada ɲadegai ta, mazɔlɔɔ faazuɓɛtɛ zalaɠai ma zuai ɠa ga zalaɠa ɠula nui nɔnɔ, eɠɛʋelei koto gba zalaɠai ma zuai la, ani ʋe gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Zalaɠa ɠula nui ɠa faazuɓɛtɛ zalaɠa zuai ma ɲamai ta zeɠe, é siɛ naa yeezazu woi yɔkpɔgi ma, nii é ɓɔɠɔ ɲadesu, ta zeezazu yeezinɛkpotogi ma, naa ʋɛɛ zeezazu ɠɔɠɔzinɛkpotogi ʋa. ");
INSERT INTO tod_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Toɠa gulɔi naa ta zeɠe, é pu ɠɔʋɛzu yeei ɠa. ");
INSERT INTO tod_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Toɠa yeeɓeɠai lɔ gulɔi wu, nii é kɔʋɛzu yeei ɠa, é gulɔi vaza daa ɠɛ lɔfela ga yeeɓeɠai Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Toɠa gulɔi ta zeɠe, nii é kɔʋɛzu yeei ɠa, é siɛ naa yeezazu woi yɔkpɔgi ma, nii é ɓɔɠɔ ɲadesu, ta zeezazu yeezinɛkpotogi ma, naa ʋɛɛ zeezazu ɠɔɠɔzinɛkpotogi ʋa, ʋɛ faazuɓɛtɛ zalaɠa zuai ma ɲamai ziaai ná. ");
INSERT INTO tod_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Zalaɠa ɠula nui ɠa gulɔi mɔtai zeɠe, zɛgai zea, é siɛ naa nɔungi ma, nii é ɓɔɠɔ ɲadesu, naa ɠa a kɛ é koto gba vai ɠɛ tɔun bɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Naa ʋoluma, toɠa koto gba zalaɠai ɠula, é koto gba vai ɠɛ naa ʋɛ, nii é ɓɔɠɔ ɲadesu ná-kɔzɔba vai ma. Naa ʋolu toɠa gala zalaɠa loganii ɠɔdaaleʋe. ");
INSERT INTO tod_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Toɠa gala zalaɠai ta vebɛ zalaɠai ɠula zalaɠa ɠulazuʋɛ. Toɠa koto gba vai ɠɛ zunui naa ʋɛ, naa ɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Ni toɠa ga bala nui, ná-sɔlɔɔgiti ti la kula ɠɛa su, toɠa baala ziʋo zinɛ ɠila nɔ zeɠe, nii a ɠula ga faazuɓɛtɛ zalaɠai, é datɛɠɛ vai ma ʋoogi ɠɛ, koto gba vai ɠɛ la tɔun bɛ. Toɠa ɓulu vukɔ ʋagɔi kilo saʋagɔ zeɠe, gaayɔgai ga gulɔi, ta gulɔi litɛlɛ ɠaaɠwɛsui, é ɠɛ ga vebɛ zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Toɠa kpumago felegɔ zeɠe ɓalaa, ɓaa poopo kpokpa felegɔ, eɠɛʋelei ná-sɔlɔɔgiti ti la. Gilagi ɠɛ ga koto gba zalaɠai, zɔi ɠɛ ga gala zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Folo lɔsaʋasiɛi, toɠa ʋa ga naama aniiti kpein zalaɠa ɠula nui ʋɔ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, Ɠɔoɠɔ GALAGI ɠaazu, ná-ɲade fai zu. ");
INSERT INTO tod_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Zalaɠa ɠula nui ɠa faazuɓɛtɛ zalaɠai ma ʋaala ziʋoi zeɠe ta gulɔi. Toɠa ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Toɠa faazuɓɛtɛ zalaɠai ma ʋaala ziʋoi ɠɔdaaleʋe. Zalaɠa ɠula nui ɠa faazuɓɛtɛ zalaɠa zuai ma ɲamai ta zeɠe, é siɛ naa yeezazu woi yɔkpɔgi ma, nii é ɓɔɠɔ ɲadesu, ta zeezazu yeezinɛkpotogi ma, naa ʋɛɛ zeezazu ɠɔɠɔzinɛkpotogi ʋa. ");
INSERT INTO tod_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Toɠa gulɔi ta ʋu ɠɔʋɛzu yeei ɠa. ");
INSERT INTO tod_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Toɠa yeeɓeɠai lɔ gulɔi ɠa, nii é kɔʋɛzu yeei ɠa, é gulɔi vaza daa ɠɛ lɔfela ga yeeɓeɠai Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Toɠa gulɔi ta zeɠe, nii é kɔʋɛzu yeei ɠa, é siɛ naa yeezazu woi yɔkpɔgi ma, nii é ɓɔɠɔ ɲadesu, ta zeezazu yeezinɛkpotogi ma, naa ʋɛɛ zeezazu ɠɔɠɔzinɛkpotogi ʋa, ʋɛ faazuɓɛtɛ zalaɠa zuai ma ɲamai ziaai ná. ");
INSERT INTO tod_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Zalaɠa ɠula nui ɠa gulɔi mɔtai zeɠe, zɛgai zea, é siɛ naa nɔungi ma, nii é ɓɔɠɔ ɲadesu, naa ɠa a kɛ é koto gba vai ɠɛ tɔun bɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Naa ʋolu toɠa kpumagoiti gila kula ga zalaɠai, ɓaa poopo kpokpagiti gila, nii é zooga é sɔlɔɔ, ");
INSERT INTO tod_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","gilagi ɠa ɠɛ ga koto gba zalaɠai, zɔi ɠɛ ga gala zalaɠai, é ʋɛɛ vebɛ zalaɠai ʋa. Zalaɠa ɠula nui ɠa koto gba vai ɠɛ Ɠɔoɠɔ GALAGI ɠaazu, naama nui ʋɛ, nii é ɓɔɠɔ ɲadesu.» ");
INSERT INTO tod_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Ɲadedai ma lɔgi ɠana, naama nui vaa zu, nii kulama zeeɓɛi ba, tama sɔlɔɔgiti ti la kula ɠɛa su. ");
INSERT INTO tod_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ ta Aalɔn, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Siɛgi zu wo lɔɔzu la Kanaan yooi zu, nii gè feezu wo ya ga wɔnɔ, ni nà fuinfuingi ʋɛɛna pɛlɛi ta ʋa, zooi zu wo sɔlɔɔsu, ");
INSERT INTO tod_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","zɔi nɔnɔ ga pɛlɛi, naa ɠa li, é daazeeli zalaɠa ɠula nui ma, é ɠɛ ma: ‹Nà fuinfuingi ʋogi ʋɛtɛsu nà-pɛlɛi ʋa.› ");
INSERT INTO tod_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Aisa zalaɠa ɠula nui ʋa lɛ, é ʋa ná ɠɛʋele ʋɛtɛ, toɠa devei ve ga ti pɛlɛi zuwo, naa ɠa a kɛ, bu anii pɛ ge mina leve ga ti ɠɔzɔʋɛ. Naa ʋoluma zalaɠa ɠula nui ɠa lɛ pɛlɛi wu, é ná ɠɛʋele ʋɛtɛ. ");
INSERT INTO tod_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","«Toɠa fuinfuingi ʋogi ɠɛʋele ʋɛtɛ. Ni a kaana ga naa ʋogi ɠa pɛlɛi ʋa ga zeɠezeɠegiti suɓeingai, ɓaa ti maaɓɔikpɔigai, ti wɔai pɛlɛi zu suɠooza, ");
INSERT INTO tod_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","toɠa ɠula pɛlɛi wu, é lo daaʋɛ, é daaɠulu, é kɛ ga folo lɔfela. ");
INSERT INTO tod_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Zalaɠa ɠula nui ɠa ɠale ma ná, foloi lɔfelasiɛi ma. Ni a kaana ga fuinfuingi ʋogi vazagɛ pɛlɛi ma, ");
INSERT INTO tod_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","toɠa deve ga ti kɔtui naati kula ná, niiti ti vuinfuingai, ti ti ʋili ya ti-ʋuuzuʋɛ ʋoluʋɛ, ada ɠɔzɔai ta. ");
INSERT INTO tod_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Toɠa pɛlɛ ɠoozuʋɛ kpein fɔin, fufiligi kpein ti kpalesu, ta naa ʋili ya ti-ʋuuzuʋɛ ʋoluʋɛ, ada ɠɔzɔai ta. ");
INSERT INTO tod_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Ta kɔtuiti maaleʋe ga ma niinɛ ɠiligaa, ti pɔlɔi zeɠe, ti pɛlɛi ziɛ. ");
INSERT INTO tod_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Ni fuinfuingi ʋogi a ɠaaɠalena ma, é ɠula pɛlɛ ɠoozuʋɛ ma, kɔtuiti kulaa ʋoluma ná, maavɔin, ta pɛlɛi ziɛ ʋolu, ");
INSERT INTO tod_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","zalaɠa ɠula nui ɠa ɠale ma ná ʋolu. Ni a kaana ga fuinfuingi ʋogi vazagɛ pɛlɛ ɠoozuʋɛ, fuinfuingi ʋe, é sumiizu. Pɛlɛi ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ta pɛlɛi wolo, ti ma ɠɔtuiti seɠe, ta guluiti, ta siɛ ʋɔlɔiti kpein, ti li ga tiye ti-ʋuuzuʋɛ ʋoluʋɛ, ada ɠɔzɔai ta. ");
INSERT INTO tod_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Zɔi a lɛ pɛlɛi wu, siɛgi kpein su daaɠulugai la, naa ɠa ɠɔzɔ eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Zɔi a ɠɛ laani pɛlɛi naa wu, naa ɠa ná-seɠeiti gba. Zɔi a laamiina pɛlɛi naa wu, naa ɓalaa ɠa ná-seɠeiti gba. ");
INSERT INTO tod_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Ni zalaɠa ɠula nui nii é ɠalegai ma pɛlɛi wu, naa a kaana ga fuinfuingi ʋogi la vazani, pɛlɛi ziaa ʋoluma, toɠa dɛɛ ga pɛlɛi ɲadegɛ, mazɔlɔɔ fuinfuingi ɓega. ");
INSERT INTO tod_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Pɛlɛi ɲade fai zu, toɠa wɔni felegɔ zeɠe, ta sɛdele gulu ɓuɠai, ta geze ɓɔi sɔsɔgi ta ɠizɔɔpe tufa ɓifɔgi. ");
INSERT INTO tod_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Toɠa wɔni gila kɔdaaleʋe pɔlɔ liɠii maazu, daavegai ga ziɛungi zu ɗɛi. ");
INSERT INTO tod_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Toɠa sɛdele gulu ɓuɠai zeɠe, ta ɠizɔɔpe tufa ɓifɔgi, ta geze ɓɔi sɔsɔgi, ta wɔni vului, é ti lɔ wɔni ɠɔdaaleʋeai ma ɲamai wu, é faza daa ɠɛ lɔfela pɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Zekana a pɛlɛi ɲade da, ga wɔnii ma ɲamai, é ʋɛɛ ziɛungi zu ɗɛi ʋa, ta wɔni vului, naa ʋɛɛ sɛdele gulu ɓuɠai ta ɠizɔɔpe tufa ɓifɔgi ʋa, ta geze ɓɔi sɔsɔgi. ");
INSERT INTO tod_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Toɠa yeeɓe wɔni vului ʋa, é li ti-ʋuuzuʋɛ ʋoluʋɛ, dɔɓɔi zu. Zekana a koto gba vai ɠɛ la pɛlɛi ʋɛ. Pɛlɛi ɠa ɲade.» ");
INSERT INTO tod_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Tɔgi ɠana kulama zeeɓɛi kpein faa zu, ta gɛlɛɠɛlɛ faiti, ");
INSERT INTO tod_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ta fuinfuingi é ɠulazu seɠeiti su, ɓaa pɛlɛiti ma, ");
INSERT INTO tod_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ta ada ɓokolo ba vaiti, ta poʋoɠulɔiti, ta gɛlɛɠɛlɛgiti, ");
INSERT INTO tod_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","é kalagi wo, siɛgi zu anii ɠɔzɔai la, ta siɛgi zu ɲadegai la. Tɔgi ɠana kulama zeeɓɛi vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«À ɓɔɛ Izilayɛle nuiti pɔ, wo ɠɛ ti ma: Zunu nɔpɛ kalaɲa kolegi ba, kɔzɔʋɛ naa maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ná-kalaɲa kolegi maaʋele ɠa kɔzɔai la, é ɠɛni ɠulazu kpusɛi ʋa, ɓaa suzo pa de, kɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Bete nɔpɛ a la su, naa ɠɔzɔʋɛ, ta ani nɔpɛ a zei ma, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Zɔi a vɔɔɠu ná-betei ʋa, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Zɔi a zeina ani ma, niigi é ɠɛa zeini ma, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Zɔi a vɔɔɠu kpusɛi ʋa, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","A laaɗɛi ʋuuna nu ma, nii ɲadegai, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Seima ani nɔpɛ a zei ma togani ɠɔma, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Zɔi a vɔɔɠu ani nɔpɛ ba, nii é ɠɛa tɔun bu, naa ɠɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. Zɔi a naama anii ta zeɠena, kɛni é ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Nu-o-nu nii kalaɲa kolegi ba, é la yeagbani, a vɔɔɠuna nu ʋa, kɛni naama nui ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Pɔlɔ liɠii kpein tɔun ka vɔɔɠuna ba, kɛni naa wolo, gulu aniɲakai kpein ka gba ziɛi wu. ");
INSERT INTO tod_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Siɛgi zu ná-kalaɲa kolegi a ɓena la, toɠa folo lɔfela ɠaalu ná-ɲade fai zu, é ná-seɠeiti gba, é maagba ga ziɛungi zu ɗɛi. Naa ʋolu toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Folo lɔsaʋasiɛi ma, toɠa kpumago felegɔ zeɠe, ɓaa poopo kpokpa felegɔ, é li Ɠɔoɠɔ GALAGI ɠakala, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, é ti ve zalaɠa ɠula nui ya. ");
INSERT INTO tod_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Naa ɠa gilagi ɠɛ ga koto gba zalaɠai, é zɔi ɠɛ ga gala zalaɠai, é koto gba vai ɠɛ tɔun bɛ Ɠɔoɠɔ GALAGI ɠaazu, ná-kalaɲa kolegi vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Zunui nii maaɠoloɠolosu, kɛni é ɓusɛi kpein gba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Seɠei kpein, ta kɔlɔi kpein a ʋu ti ma, naati ta gba ziɛi wu. Ti ɠɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Ni zunui ta anzanui ta laana, ta maagba ti ɠilagilagi. Ti ɠɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Anzanui nii ɲamai ɠulazu ba, tɔɔzei ná-alugi ɠa é kaazu, toɠa yɛ ná-ɲadetalai zu folo lɔfela laawu. Nu-o-nu a vɔɔɠu ba, naa ɠɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Bete nɔpɛ a la su ná-ɲadetala ziɛgi zu, naa ɠa ɠɔzɔ. Ani nɔpɛ a zei ma, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nu-o-nu nii a vɔɔɠu ná-betei ʋa, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nu-o-nu nii a vɔɔɠu anii ta ʋa, nii é ɠɛa zeini ma, kɛni naa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Ni anii ɠa betei ɠa, ɓaa ʋɛ seiɗai ná, zɔi a vɔɔɠu ba, kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ni zunu a laana ga anzanui naa, ná-kɔzɔi ʋɛa tɔun ba. Kɔzɔai ɠa yɛ de, folo lɔfela laawu. Bete nɔpɛ a la su, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Anzanui nii ɲamai a yɛ ɠulazu ba folo mɔinmɔin daawu, é ɠula ná-alu kaa yeeɠɛɠala zoloogaiti polu, ɓaa ɲamai lɛbi ɠulazu ba, é leʋe pɔlɔmai ʋa, kɔzɔai ɠa yɛ de, ná-ɲama ʋuu ziɛgi kpein su, eɠɛʋelei nɔ ná-alu kaa yeeɠɛɠalai la. ");
INSERT INTO tod_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Bete nɔpɛ a la su, naama ɲama ɠula ziɛgi laawu, naa ɠa ɠɔzɔ eɠɛ ná-alu kaa ʋetei, ani nɔpɛ nii a zeina ma, naa ɠa ɠɔzɔ, eɠɛ ná-alu kaa ziɛgi zu nɔ. ");
INSERT INTO tod_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Nu-o-nu a vɔɔɠu ba, naa ɠa ɠɔzɔ, kɛni é ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. ");
INSERT INTO tod_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Siɛgi zu é ɲadesu la ná-ɲama ʋui ma, toɠa foloi ɠaalu ga dɔfela. Naati poluma, toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Foloi lɔsaʋasiɛi ma, toɠa kpumago felegɔ zeɠe, ɓaa poopo kpokpa felegɔ, é li ga tiye zalaɠa ɠula nui ʋɔ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Zalaɠa ɠula nui ɠa gilagi ɠula ga koto gba zalaɠai, é zɔi ɠɛ ga gala zalaɠai. Zalaɠa ɠula nui ɠa koto gba vai ɠɛ bɛ Ɠɔoɠɔ GALAGI ɠaazu, ɲama ʋui ma vaa zu, nii é ɠɛa kɔzɔzu. ");
INSERT INTO tod_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Wa Izilayɛle nuiti maaɠooza faiti kpein ba, ta ti ɠɔzɔ, naa ɠa a kɛ ti mina za ta-ɠɔzɔ vaiti su, ni ta nà-seɠe ʋɛlɛ ɲadegai ɠɔzɔna, nii é ti zaama.» ");
INSERT INTO tod_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Tɔgi ɠana naama zunui ʋɛ, nii kalaɲa kolegi ba, ɓaa maaɠoloɠologai, é ɠɔzɔ, ");
INSERT INTO tod_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ɓaa anzanui, nii kɔzɔai ga ná-alu kaa ɲamai, ɓaa zunui, ɓaa anzanui, nii ɲamai ɠulazu ba, ɓaa zunui, nii é laazu anzanui ɠoba, kɔzɔai. ");
INSERT INTO tod_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, Aalɔn ná-doun zunu felegɔiti saa ʋoluma, niiti ti ɓɔɠɔ lɛɛni ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɓɔɛ è-liɛ Aalɔn ʋɔ, naa ɠa a kɛ, é mina ɗa lɛ yeenɔpɛ ada ɲadega wolai, kwɛpele seɠezuɠoozagi ʋoluʋɛ, kesui lakulugi ɠakalaʋɛ, nii é minazeɠe kesui la, naa ɠa a kɛ é mina za, mazɔlɔɔ nà ɠulazu kɛlɛma tonaɓiingi zu kesui lakulugi maazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Pɛtɛ ʋelegi Aalɔn a zoo lɛɛzu la ada ɲadega wolai: Toɠa nikɛ zinɛ ɓokpa gila seɠe ga koto gba zalaɠai, ta baala sinɛ ɠila ga gala zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Toɠa seɠewuzeɠe ɲadegai loo ɠɔba, é ga gezei, é ma ʋɛlɛ kpuɠagi lɛ ɓɔɠɔ ma, é zaamaɠili ga geze zaamaɠiligi, é ma wɔɔlɔgi lɔ unba. Zalaɠa ɠula zeɠeiti kana, niiti a ɓɔɠɔ maaɠili ga tiye, é maagba ʋoluma. ");
INSERT INTO tod_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Toɠa boli zinɛ felegɔ ɠula Izilayɛle ʋɛbɛi ya ga koto gba zalaɠai, ta baala sinɛ ɠila ga gala zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Aalɔn ɠa koto gba vai ɠɛ ga ná-nikɛ zinɛi, toɠa ná-kotoi gba ta ná-pɛlɛyeɠei. ");
INSERT INTO tod_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Toɠa boli zinɛ felegɔiti seɠe, é ʋa ga tiye Ɠɔoɠɔ GALAGI ɠakala, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aalɔn ɠa kpakutoomai ɠɛ ga boli zinɛ felegɔiti, gilagi ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi, gilagi ɠɛ ga nii kotoi yɛsu da, é lii la. ");
INSERT INTO tod_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aalɔn ɠa boli zinɛi maaɓuɠa ʋa, niigi kpakui loozu ma Ɠɔoɠɔ GALAGI ʋɛ, é naa ɠula ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Boli zinɛi niigi kpakui loozu ma, ga kotoi yɛ da, é lii la, naa ma vului ɠa ʋilɛ Ɠɔoɠɔ GALAGI ɠakala, naa ɠa a kɛ, é koto gba vai ɠɛ, ta yeeɓe ba, é li teʋebai zu, kotoi yɛ da. ");
INSERT INTO tod_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aalɔn ɠa koto gba vai ɠɛ ga ná-nikɛ zinɛi. Toɠa koto gba vai ɠɛ tɔ ɓɔɠɔi ʋɛ, ta ná-pɛlɛyeɠei. Toɠa ná-koto gba nikɛ zinɛi ɠɔdaaleʋe. ");
INSERT INTO tod_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Toɠa ansanse gala liɠii ta zeɠe, daavegai ga abulekaiti, seɠeai zalaɠa ɠulazuʋɛ Ɠɔoɠɔ GALAGI ɠaazu, ta é zeeɲɛ felegɔ zeɠe ansansegi ma vukɔi zu. Toɠa li ga naama aniiti kwɛpele seɠezuɠoozagi ʋoluʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Toɠa ansansegi ʋu abui ɠa Ɠɔoɠɔ GALAGI ɠaazu, naa ɠa a kɛ ansansegi ma luului kesui lakulugi maalɔɔɠu, nii é zeele woo ɠesui maazu, naazu é la mɔ za pɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Toɠa nikɛ zinɛi ma ɲamai zeɠe, é faza ga yeeɓeɠai kesui lakulugi ɠakala ʋelei, folo ɠulazu ʋelei, é ɲamai vaza ga yeeɓeɠai, ná zeizu ɠɛ lɔfela, kesui lakulugi ɠakala ʋelei. ");
INSERT INTO tod_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Toɠa koto gba woli zinɛi ɠɔdaaleʋe nuɓusɛiti bɛ, é li ga ma ɲamai kwɛpele seɠezuɠoozagi ʋoluʋelei. Ʋelei nɔ é kɛai la ga nikɛ zinɛi ma ɲamai, zekana nɔ a kɛɛ la ga naa ma ɲamai, toɠa faza kesui lakulugi ma ta kakala ʋelei. ");
INSERT INTO tod_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","«Ʋele ɠana a koto gba vai ɠɛ la ada ɲadega wolai ʋɛ Izilayɛle nuiti ta-ɠɔzɔba vaiti faa zu, ta ta-lɔ koloɠologiti kpein maaʋele zu, ti kotoi ɠɛai ga ti maaʋele. Toɠa kɛ ɠana nɔ GALA daaɠomi seɠe ʋɛlɛi ʋɛ, mazɔlɔɔ toɠa kɔzɔba nuɓusɛiti saama. ");
INSERT INTO tod_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Nu nɔpɛ ge la yɛga GALA daaɠomi seɠe ʋɛlɛi wu, siɛgi zu é lɛɛzu la ga é koto gba vai ɠɛ ada ɲadega wolai, eyɛsu é ɠula ná. Toɠa koto gba vai ɠɛ tɔ ɓɔɠɔi ʋɛ, ta ná-pɛlɛyeɠei, ta Izilayɛle ʋɛbɛi kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«A ɠɛna ɠulaa, toɠa li zalaɠa ɠulazuʋɛ, nii é Ɠɔoɠɔ GALAGI ɠakala, é koto gba vai ɠɛ, zalaɠa ɠulazuʋɛ ʋɛ, é nikɛ zinɛi ta boli zinɛi ma ɲamai zeɠe, é siɛ zalaɠa ɠulazuʋɛ minɛiti ma, maaɠoolii pɛ su. ");
INSERT INTO tod_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Toɠa ɲamai vaza ga zeeɓeɠai, ná zeizu ɠɛ lɔfela, zalaɠa ɠulazuʋɛ ma. Toɠa kole, é ɲade, Izilayɛle nuiti ta-ɠɔzɔba vaiti faa zu. ");
INSERT INTO tod_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Siɛgi zu é ɓesu da ga koto gba vai ɠɛ ada ɲadega wolai ʋɛ, ta GALA daaɠomi seɠe ʋɛlɛi ʋɛ, ta zalaɠa ɠulazuʋɛ ʋɛ, toɠa boli zinɛi ma vului maaɓuɠa ʋa. ");
INSERT INTO tod_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aalɔn ɠa yee felegɔiti pɛɛ boli zinɛi ma vului unmaʋɛ, é laa zɔ ga maazu ga Izilayɛle nuiti ta-vaa ɲɔiti kpein, ta ta-lɔ koloɠologiti kpein, niiti ti kotoi ɠɛa ga ti maaʋele. Toɠa ti la boli zinɛi unma, naa ʋolu, é kpɛ, é li teʋebai zu, zunu ɠila ge ɓɔ ba, nii kɛʋele ɓɛtɛai. ");
INSERT INTO tod_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ta-vaa ɲɔiti ta yɛ boli zinɛi ʋa, ti kpɛ, é li teʋebai zu, é li zooi naa zu, ʋɛ ná ɲakai. ");
INSERT INTO tod_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Aalɔn ɠa lɛ GALA daaɠomi seɠe ʋɛlɛi wu, é geze zeɠeiti kula, niiti é ɠɛa ti looni tɛɛzuʋɛ ada ɲadega wolai. Toɠa ti la ná. ");
INSERT INTO tod_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Toɠa maagba ada ɲadegai ta, é ná-seɠeiti seɠe ʋolu. Naa ʋolu toɠa ɠula, é ná-gala zalaɠai ɠula, ta nuɓusɛiti ta-ɠala zalaɠai, é koto gba vai ɠɛ ɓɔɠɔ ʋɛ, ta nuɓusɛiti bɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Toɠa koto gba zuai ma wulɔi ɠala zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Zɔi a bolii ɓɛ, nii kotoi yɛgai da, naa ɠa ná-seɠeiti gba, é maagba, naa ʋoluma toɠa lɛ niina ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Koto gba zalaɠai ma nikɛ zinɛi ta koto gba woli zinɛi niiti ti ti-ma ɲamai zeɠeai, ti ʋaa la ada ɲadega wolai koto gba vai zu, ta li ga tiye ti-ʋuuzuʋɛ ʋoluʋɛ, ti ma ɠɔlɔiti gala abui ɠa, ta ma zuai, ta ma ɓooiti. ");
INSERT INTO tod_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Zɔi a gala, naa ɠa ná-seɠeiti gba, é maagba. Naa ʋolu toɠa lɛ niina ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Nii ɠa ɠɛ wo ʋɛ ga ɠɔoɠɔ tɔgi, alugi lɔfelasiɛi ma volo puugɔi ma, wa zugi zo, wo la boti nɔpɛ kɛa, é ɠɛni ga zou loun, ɓaa wɛɛin nii é ga seikɔɠɔma nui wo zaama. ");
INSERT INTO tod_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Mazɔlɔɔ naama volo ná, ta koto gba vai ɠɛ wo ʋɛ, naa ɠa a kɛ wo ɲade. Wa ɲade wa-ɠotoiti kpein faa zu, Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Toɠa ɠɛ wo ʋɛ ga dooɠo folo wolai, wa zugi zo. Toɠa ɠɛ wo ʋɛ ga ɠɔoɠɔ tɔgi. ");
INSERT INTO tod_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Koto gba vai ɠa ɠɛ zalaɠa ɠula nui ya, nii gulɔi ziaai ma, feai bɛ̀ ga é ʋilɛ kɛɛɠɛ ʋotogi zu zalaɠa ɠula vai zu. Toɠa ɓɔɠɔ maaɠili ga zalaɠa ɠula zeɠeiti, ti ga gezei. ");
INSERT INTO tod_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Toɠa koto gba vai ɠɛ ada ɲadega wolai ʋɛ, ta GALA daaɠomi seɠe ʋɛlɛi ʋɛ, ta zalaɠa ɠulazuʋɛ ʋɛ. Toɠa koto gba vai ɠɛ ɓalaa zalaɠa ɠula nuiti bɛ, ta nuɓusɛiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Toɠa ɠɛ wo ʋɛ ga ɠɔoɠɔ tɔgi, koto gba vai ɠa ɠɛ, ná ɠɛ ɠila kona-o-kona, Izilayɛle nuiti ta-ɠotoiti kpein faa zu.» Naa ɠɛɛni, nii Ɠɔoɠɔ GALAGI ma levei veeni Moize ya. ");
INSERT INTO tod_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Ɓɔɛ Aalɔn ʋɔ, ta ná-doun zunuiti, ta Izilayɛle nuiti kpein, è ɠɛ ti ma: Wɛlɛ, nii ɠa Ɠɔoɠɔ GALAGI deveai: ");
INSERT INTO tod_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Ni Izilayɛle nui ta a nikɛi ɓaa baalagi, ɓaa bolii ɠɔdaaleʋena ga zalaɠai ti-ʋuuzuʋɛ, ɓaa ti-ʋuuzuʋɛ ʋoluʋɛ, ");
INSERT INTO tod_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","é la liini la GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, é ʋa kɛ ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ ná-seɠe ʋɛlɛ ɲadegai ɠakalaʋɛ, naama nui ɠa ɠɛ ga sɔba nu, tɔɔzei é ɲamai ʋua. Kpe ka leʋe ná-nuɓusɛiti ba, é ɠula ti zaama. ");
INSERT INTO tod_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Naa ɠa a kɛ, Izilayɛle nuiti ti mina mɔ ta-zalaɠa aniiti kula dɔɓɔiti su, kɛlɛ ti ɗa ʋa ga tiye zalaɠa ɠula nui ʋɔ, Ɠɔoɠɔ GALAGI ɠakala GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, é ti ɠula ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ga ziilɛi zalaɠaiti. ");
INSERT INTO tod_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Zalaɠa ɠula nui ɠa ma ɲamai vaza Ɠɔoɠɔ GALAGI ná-zalaɠa ɠulazuʋɛ ma, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, é ma wulɔi ɠala, nii makugi a nɛɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ti la mɔ ta-zalaɠaiti kulaa zɛɛ ɠalagiti bɛ, niiti ti-ʋaaɠulabaiti ti ga boli zinɛiti, niiti ti ɠɛa ɓɔɠɔ ɠɔzɔzu ga tiye. Toɠa ɠɛ ga ɠɔoɠɔ tɔgi ti ʋɛ, ta ti-mavofodaiti kpein. ");
INSERT INTO tod_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Ɗa ɠɛ ti ma mɔnɔ: Ni Izilayɛle nui ta, ɓaa seikɔɠɔma nui ta, é ti zaama, a gala zalaɠai ɠulana, ɓaa zalaɠai taɠili, ");
INSERT INTO tod_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","é la liini la GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, é ʋa kula ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, naama nui ɓe ka leʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Ni Izilayɛle nui ta, ɓaa seikɔɠɔma nui ta, é ti zaama, a ɲamai ma zii tanɔpɛ miina, nà ʋoluave naama nui ʋa, nii é ɲamai miizu, nà naama nui ɓeteʋe ɓalaa ná-nuɓusɛiti ba, é ɠula ti zaama. ");
INSERT INTO tod_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Mazɔlɔɔ ɲamai ɠa é ga kpɛtɛanii kpein zɛnvui. Gè feeʋɛ wo ya, ga wo koto gba vai ɠɛ la zalaɠa ɠulazuʋɛ, wo-yɛnvuiti faa zu, mazɔlɔɔ tɛi é ga zɛnvui ma ʋoogi, naa maaʋele ɠa ɲamai a kotoi gba la. ");
INSERT INTO tod_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Naa ɠa é ba, gè bogɛ Izilayɛle nuiti ma ga, nu nɔpɛ ge mina ɲamai mi wo zaama, anɛɛ seikɔɠɔma nui ʋe, é mina ɲamai mi. ");
INSERT INTO tod_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Ni Izilayɛle nui ta, ɓaa seikɔɠɔma nui ta, é ti zaama, a sua zona dɔɓɔ ziɛ su, ɓaa wɔnii, nii nu a mi, toɠa ma ɲamai ʋu zooi ma, é fufiligi ʋu gaazu. ");
INSERT INTO tod_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Mazɔlɔɔ kpɛtɛanii kpein, ni nɔ toɠa vulua, zɛnvui ɠa ma ɲamai zu. Naa ɠa é ba, gè bogɛ Izilayɛle nuiti ma ga, wo la kpusɛi tanɔpɛ ma ɲamai mia, mazɔlɔɔ kpɛtɛanii kpein zɛnvui ɠa ɲamai zu, nu nɔpɛ a ta miina, naa ɓe ka leʋe Izilayɛle nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Nu nɔpɛ, é ɠɛni zou loun zu, ɓaa seikɔɠɔma nuiti su, a sua miina saai ɓɔɠɔ ʋɛ, ɓaa baliʋaliai ga, toɠa ná-seɠeiti gba, é maagba. Kɔzɔai ɠa yɛ de, eyɛsu kpɔkɔi. Naa ʋolu, toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ni é la ná-seɠeiti gbani, é ʋa maagba, ná-faaɠaaza golai ma ɠasɔi ɠa la unma.» ");
INSERT INTO tod_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","À mina naa ɠɛ, nii é ɠɛɛzu Ezipete yooi zu, ʋɛ wo ɠɛni zeini ná. À mina naa ɠɛ, nii é ɠɛɛzu Kanaan yooi zu, ʋɛ gè liizu ga woye ná. À mina ʋilɛ ta-lɔgiti polu. ");
INSERT INTO tod_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","À ɠolo nà-deveiti bɛ, wo makɛ nà-tɔgiti ma, wo ʋilɛ ti ʋolu. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","À ɠolo nà-tɔgiti bɛ, ta nà-deveiti, nui nii a ziɛna ga tiye, naa ɠa zɛnvui wo naa maaʋele ma. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Wo tanɔpɛ ge mina la ga anzanu, ta nii ti logai ɓɔɠɔ ʋa. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Mina la è-lee ɠoba. Toɠa ɠɛ ga è-ɠɛɛ unfe faa. Toɠa ɠɛ ɓalaa ga è-lee unfe faa, mazɔlɔɔ è-lee ʋe. ");
INSERT INTO tod_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Mina la è-ɠɛɛ anzai taɠili koba. Toɠa ɠɛ ga è-ɠɛɛ unfe faa. ");
INSERT INTO tod_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Mina la è-ʋaazeelai ɠoba, è-ɠɛɛ ná-doun anzanui ʋe, ɓaa è-lee ná-doun anzanui, anɛɛ ni kulaʋɛ su pɛlɛyeɠei taɠili bu. ");
INSERT INTO tod_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Mina la ga è-loun zunui ná-doun anzanui, ɓaa è-loun anzanui ná-doun anzanui, mazɔlɔɔ ɗa-unfe faa ʋe, ɗa ɓɔɠɔi. ");
INSERT INTO tod_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Mina la ga è-ɠɛɛ anzai taɠili ná-doun anzanui. Toɠa ga è-ɠɛɛ ná-doun anzanui. Toɠa ga è-ʋaazeelai. ");
INSERT INTO tod_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Mina la ga è-ɠɛɛ ʋaazeelai. Toɠa ga è-ɠɛɛ ná-nu ɠiteɠitegi. ");
INSERT INTO tod_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Mina la ga è-lee diɛ ɓaa deɠe anzanu, mazɔlɔɔ è-lee ná-nu ɠiteɠitegi ʋe. ");
INSERT INTO tod_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Mina la ga è-ɠɛɛ diɛ ɓaa deɠe zunui anzai, mazɔlɔɔ toɠa ga è-lee. ");
INSERT INTO tod_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Mina la ga è-loun anzai. Toɠa ɠɛ ga è-loin unfe faa. ");
INSERT INTO tod_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Mina la ga è-ɠɛɛloin anzai. Toɠa ɠɛ ga è-ɠɛɛloin unfe faa. ");
INSERT INTO tod_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Mina la ga anzanui, ta ná-doun anzanui. È la ná-doun zunui ná-doun anzanui zeɠea, ɓaa ná-doun anzanui nɔnɔ ma loun anzanui, mazɔlɔɔ ta ga ná-nu ɠiteɠitegiti, naa ɠa ga faa ɲɔu wola. ");
INSERT INTO tod_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Ni è-anzai ɠa dɛ vulua, mina diɛ ɓaa deɠe anzanui ta zeɠe ga è-anza. Ɗa toloi lɔ ti yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Mina la ga anzanui ná-alu kaa ziɛgi zu, nii é tɔun kɔzɔzu. ");
INSERT INTO tod_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Mina la ga è-zeiɲɔɠɔi anzai, ɗa ɓɔɠɔ ɠɔzɔ la. ");
INSERT INTO tod_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Mina è-loin tanɔpɛ kula ga zalaɠa, é ʋa ɠala kɔɔɠɔ ganigi ʋɛ daa ga Mɔlɔke, dɛbi vaa ma, è la ɗa-ƓALAGI lɔɠɔi ɠoloɠologa. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Mina la ga zunu, eɠɛʋelei nu a laa la ga anzanui. Naa ɠa ga kɔzɔba vaa. ");
INSERT INTO tod_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Mina la ga sua, è ʋa ɓɔɠɔ ɠɔzɔ. Anzanu mina la sua ɠoba. Ɓaaɠulama vaa ʋe. ");
INSERT INTO tod_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«À mina ɓɔɠɔ ɠɔzɔ ga naama ziɛ ʋelei tanɔpɛ, mazɔlɔɔ ziiti gè ti ɓɛɛzu wo luɠɔ, naati ti ɓɔɠɔ ɠɔzɔʋɛ ga naama ziɛ ʋeleiti kpein. ");
INSERT INTO tod_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Zooi kpein ge ɠɔzɔa, gè ti maaɠolo ta-vaaɠaaza golaiti faa zu, zooi unpiliga ga ná-nuɓusɛiti. ");
INSERT INTO tod_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«Wɔun wa, wa ɠolo nà-tɔgiti bɛ, ta nà-deveiti, wo mina naama ɠɔzɔba vai tanɔpɛ kɛ, é ɠɛni ga zou loun, ɓaa seikɔɠɔma nui, nii é wo zaama. ");
INSERT INTO tod_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Mazɔlɔɔ kɔzɔba vaiti kpein kana, zooi zu nuɓusɛiti ti ɠɛni kɛɛzu, niiti ti ɠɛni zeini zooi ɠa mɔungi wo luɠɔ, zooi ɠɔzɔa. ");
INSERT INTO tod_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Naa a ɠɛɛna, zooi la mɔ unpiliga ga woye, tɔɔzei wa-ɠɔzɔba vaiti ba, eɠɛʋelei é unpilini la ga ziiti, ti ɠɛni wɔun wo luɠɔ náʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Mazɔlɔɔ niiti kpein ti ʋaazu naa ɠɛɠala ɠɔzɔba vaiti ta ɠɛɛzu, ti ɓe ka leʋe ta-nuɓusɛiti ba, ti ɠula ti zaama. ");
INSERT INTO tod_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","«Wa ɠolo nà-deveiti bɛ, naa ɠa a kɛ, wo la mɔ naama vaa ɲɔu wolaiti tanɔpɛ kɛa, nii é ɠɛni ɠɛɛzu wo luɠɔ, wo la ɓɔɠɔ ɠɔzɔa ga naa ta. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Ɓɔɛ Izilayɛle ʋɛbɛi kpein pɔ, è ɠɛ ti ma: À ɲade, mazɔlɔɔ ɲàdegɛ, nà, Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","«Ɛsɛ gilagilagi ɠa unfe dee ta kɛɛɠɛ ma, é nà-dooɠo foloiti maaɲɛ. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«À mina ɠaaʋote kɔɔɠɔ ganigiti ma. À mina galagaa ɓɛtɛ ɓɔɠɔ ʋɛ ga kɔlu ɠaawuungi. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Siɛgi zu wa ziilɛi zalaɠai ɠulana la Ɠɔoɠɔ GALAGI ʋɛ, wa kɛ, nii a kɛ é daazo. ");
INSERT INTO tod_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ma zuai ɠa mi foloi wo kulazu la ga zalaɠai, ɓaa poluma zobui. Nii é yɛsu ná eyɛsu foloi zaʋasiɛi, naa ɠa ɠala. ");
INSERT INTO tod_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Foloi zaʋasiɛi, ni nu a ta miina, toɠa ɠɛ ga anii kɔzɔai, zalaɠai laa la mɔ zoga. ");
INSERT INTO tod_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Zɔi a ta miina, ná-faaɠaaza golai ma ɠasɔi ɠa la unma, mazɔlɔɔ toɠa naa ɠɔzɔzu, nii feai Ɠɔoɠɔ GALAGI ʋɛ, naama nui ɓe ka leʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Siɛgi zu wo moloi leʋezu la wa-yooi zu, wa kpala kpelamaʋɛ yɛ ná, wo mina ná leʋe, wo mina ɠale ma posuyɛʋɛi ma. ");
INSERT INTO tod_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","À mina ani ɠɔpɔgiti kula ɓalaa, niiti ti yɛgai wa-leezɛn ɓelei zu. À mina ma waaiti zɛʋɛ, niiti ti loozu. Wa naa yɛ ná bala nuiti bɛ, ta seikɔɠɔma nuiti. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«À mina unma wo. À mina zɛɛ wo, ɓaa wo ʋa woya ɓɛtɛ, wo ɠilagilagi wo-zeiɲɔɠɔi laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","À mina zɛɛ ɠona wo dàaseigi zu, mazɔlɔɔ wa wa-ƓALAGI lɔɠɔi ɠoloɠolo. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«À mina wo-zeiɲɔɠɔi maanɔɠɔ vaa ɠɛ, wo mina unma wo. À mina ɠata nu ná-sala wali ma, é ʋa yɛsu poluma zobui. ");
INSERT INTO tod_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","À mina goizuɓɔlɔ nui ɠoto, wo mina ani nɔpɛ kpesa gaazuɠole nui luɠɔ, nii a ɠɔɠɔziɠa ba, kɛlɛ wa ɠɛ ga GALA gaazuluaba nu. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«À mina telebotala vaa nɔpɛ kɛ tukpɔɠaaleʋeiti su. À mina topolu ɠɛ bala nui ɓaa nu wolai ʋɛ. Kɛlɛ wa wo-zeiɲɔɠɔi lukpɔɠaaleʋe ga sɔledai. ");
INSERT INTO tod_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","À mina lɔɠɔ ɲɔu vaa ʋɛɛ wa-nuɓusɛiti ta ʋa. À mina zɛɛ zeele woo wo wo-zeiɲɔɠɔi laalɔɠɔma, a ɠɛ ga saa zaɓu. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«À mina wo-ɠɛɛloin wɔinzeɠe wo-yiimaʋɛ. À dama, wa ɠɛna zelii loga wo-ɠɛɛloin ma, wo mina koto la ɓɔɠɔ unma tɔun ná-faa zu. ");
INSERT INTO tod_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","À mina nɔnɔ ʋotokula vaa ɠɛ, wo mina faa zei yiima wa-nuɓusɛiti ta laalɔɠɔma. Wa wo-zeiɲɔɠɔi nɛɛ ʋɛ, eɠɛ wa ɓɔɠɔi. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Wa ɠolo nà-deveiti bɛ. À mina sua ma zii felegɔ ʋu ɓɔɠɔ ma, ti ʋa pɛɛpolu wo. À mina ani zuwu zii felegɔ woli wa-ɓalagi ʋa. À mina seɠe loo ɠɔba fɛlɛai ga gezei ma zii felegɔ. ");
INSERT INTO tod_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Siɛgi zu zunui ta a laana ga duɔ anzanui ta, nii maazogai zunu ɠili bɛ, é la unmɔɔni, é la ɓɔɠɔ yeema, ta faa zuɠoloɠologi ɓɛtɛ, kɛlɛ ti la ti ʋaa, mazɔlɔɔ anzanui naa la ɓɔɠɔ yeema. ");
INSERT INTO tod_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Zunui ɠa ʋa ga baala sinɛ ɠila, Ɠɔoɠɔ GALAGI ʋɔ, ga ná-faa zuɓɛtɛ zalaɠai GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Zalaɠa ɠula nui ɠa koto gba vai ɠɛ tɔun bɛ, Ɠɔoɠɔ GALAGI ɠakala, ná-kotoi vaa zu é kɛai, é kɛ ga baala sinɛi, é kulazu ga faazuɓɛtɛ zalaɠai, kotoi naa é kɛai, suvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Siɛgi zu wo liizu la zooi ná zu, wa ɓena ga gwaa wului ma zii pɛ sin, wa ti-ma waaiti pɛtɛ kona saʋagɔ laawu ga ti ɠɔzɔʋɛ, à mina ta mi ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Konagi naanisiɛi ma, wa ti-ma waaiti kpein fe Ɠɔoɠɔ GALAGI ná-maamusɛ vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Konagi lɔɔlusiɛi ma, wa zoo wo ma waaiti ta mi. Ni wa naa ɠɛɛna, wa-ɠulanumai ɠa li ga wɔɔlɔa. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«À mina sua nɔpɛ mi, nii ɲamai su. À mina ɓɔɠɔ lɔ ungaiziɛ vaa zu, ta adɔɓɛɛ vaa nɔpɛ. ");
INSERT INTO tod_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","À mina wɔungiti buuwo, wo mina wo-ɓakalagiti bo. ");
INSERT INTO tod_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","À mina wɛn dɔ wo-ɠɔlɔgi ma gɔvɛ ʋɛ, wo mina pɔlɔpalɛ lɔ ɓɔɠɔ ma. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«À mina wo-loun anzanui ɠaazu unfe seɠe ga wo ʋa dɔ koloɠologi zu, galagi tanɔpɛ dɛbi vaa ma, naa ɠa a kɛ zooi zu nuɓusɛiti ti mina lɔ koloɠologi zu, ná zulaa a ʋa ve ga kɔzɔba vai. ");
INSERT INTO tod_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Wa nà-dooɠo foloiti maaɲɛ, wo unfe sèizu ɲadegai ma. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«À mina li, wo ʋa gɔvɛ laawooleʋe nuiti gaazaɠa, ɓaa niiti gɔvɛiti ti ʋelela ʋele vaiti bosu ti ma. À mina ti ɠaiziɛ, wo mina ɓɔɠɔ ɠɔzɔ ga tiye. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Wa wuzeɠe un kolegiti kpein bɛ, wo kɛwola wɔlɔi lɛbi. Wa lua wa-ƓALAGI ʋa. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Ni seikɔɠɔma nui ta a ʋaana wo zaama wa-yooi zu, à mina suziɠa. ");
INSERT INTO tod_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Wa seikɔɠɔma nui zo ga pagɔ, eɠɛ pelegi wo zou loin zosu da. Wa nɛɛ ʋɛ eɠɛ wa ɓɔɠɔi. Mazɔlɔɔ wo ɠɛni ga seikɔɠɔma nuiti Ezipete yooi zu. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«À mina telebotala vaa ɠɛ, tukpɔɠaaleʋeiti su, anɛɛ kɔɠɔgiti su, ɓaa aniiti sɔligiti su, ɓaa aniiti buɲɛgiti su. ");
INSERT INTO tod_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kɛni wa-ɠɔɠɔ ganiiti ti zɔle, bui ʋelei zoloo. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo ɠulani Ezipete yooi ʋa. ");
INSERT INTO tod_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Wa nà-deveiti kpein so, ta nà-tɔgiti, wo ti makɛ, wo ziɛ ga tiye. Nà ga Ɠɔoɠɔ GALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Ɠɛ Izilayɛle nuiti ma: Nu-o-nu é ɠɛni Izilayɛle nuiti saama, ɓaa seikɔɠɔma nu, nii a ná-doin ta ɠulana ga zalaɠa salei ʋɛ, daa ga Mɔlɔke, ta naama nui ʋaa. Zooi zu nuɓusɛiti ta sɔ ga kɔtui, é za. ");
INSERT INTO tod_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nɔ̀un nà ʋoluave naama nui ʋa, gè kpeteʋe ná-nuɓusɛiti ba, tɔɔzei ba é ná-doin ta leʋegɛ salei Mɔlɔke ʋɔ, é sèizu ɲadegai ɠɔzɔʋɛ, é dàasei ɲadegai ɠoloɠolo. ");
INSERT INTO tod_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ni Izilayɛle nuiti ta gilina ba, ti ɠaazuʋɛɛ ma naama nui letegi, nii é ná-doin ta leʋegai salei Mɔlɔke ʋɔ, ni ti la paani, ");
INSERT INTO tod_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nɔ̀un, nà ʋoluave ma nui ʋa, ta ná-pɛlɛyeɠei, nà kpeteʋe ná-nuɓusɛiti ba, é ʋɛɛ naati kpein ba, niiti ti kɔɔɠɔ gani kɔɔ vai ɠɛɛzu, eɠɛʋelei é kɛɛzu la salei Mɔlɔke ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Ni nui ta a liina, é gɔvɛ laawooleʋe nuiti gaazaɠa, ɓaa niiti gɔvɛiti ti ʋelela ʋele vaiti bosu ti ma, nii é ga kɔɔɠɔ gani kɔɔ vai ma zii, nà ʋoluave naama nui ʋa, gè kpeteʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","À ɓɔɠɔ ɲade, wa ɲade, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","À nà-deveiti makɛ, wo ziɛ ga tiye. Nà ga Ɠɔoɠɔ GALAGI, nii é wo ɲadesu. ");
INSERT INTO tod_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Zɔi nɔpɛ é kɛɛɠɛ ɓaa dee ɠotozu, ta naama nui ʋaa, tɔɔzei é kɛɛɠɛ ɓaa dee ɠotoa, ma ɲamai ɠa la tɔ ɓɔɠɔ unma. ");
INSERT INTO tod_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Siɛgi zu zunui ta a wɛɛnziɛ bona la ga seiɲɔɠɔi ta anza, wa wɛɛnziɛ nuiti felegɔ pɛ paa. ");
INSERT INTO tod_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Ni zunui ta a laana ga kɛɛɠɛ anzai, é kɛɛɠɛ ɠaazu unfe seɠea, wa naama zunui ta naama anzanuiti paa. Ti-ma ɲamai ɠa la ti unma. ");
INSERT INTO tod_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Ni zunui ta a laana ga ná-doun anzai, wa ti felegɔi pɛ paa. Ti unfetala vai ɠɛa, ti-ma ɲamai ɠa la ti unma. ");
INSERT INTO tod_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Ni zunui ta a laana ga zunui ta, ti kɔzɔba vai ɠɛa, wa ti ʋaa. Ti-ma ɲamai ɠa la ti unma. ");
INSERT INTO tod_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Ni zunui ta a anzanui ta dee zeɠena, é ti felegɔ zei ga anza, naa ɠa ga faa ɲɔu wola. Ta ti saʋagɔ ɠala, naa ɠa a kɛ faa ɲɔu wolai naa mina yɛ wo zaama. ");
INSERT INTO tod_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Ni zunui ta a laana ga suai, wa zunui naa ʋaa, wo suai ɓalaa paa. ");
INSERT INTO tod_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Ni anzanui ta a maaɓuɠana suai ta ʋa, é la koba, wa anzanui ʋaa, wo suai ʋaa. Ta ti pɛ paa, ti-ma ɲamai ɠa la ti unma. ");
INSERT INTO tod_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Ni zunui ta a ná-seelai zeina ga anza, kɛɛɠɛ ná-doun anzanui, ɓaa dee ná-doun anzanui, é naa unfega, ta é ɓɔɠɔ unfega. Unfetala vaa wola ɠana, ti ɓe ka leʋe ta-nuɓusɛiti ba, naa ɠa ɠɛ ta-nuiti pɛ gaazu. Zunui naa é ná-seelai unfegai, ná-faaɠaaza golai ma ɠasɔi ɠa la unma. ");
INSERT INTO tod_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Ni zunui ta a laana ga anzanui ta, é ná-alugi ɠaai, ti felegɔ pɛ ti ɓe ka leʋe ta-nuɓusɛiti ba, mazɔlɔɔ ti ná-alugi ma ɲamai ɠaa. ");
INSERT INTO tod_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«À mina la ga wo-lee diɛ ɓaa deɠe anzanui ta, ɓaa wo-ɠɛɛ ná-seelai ta. Ni zunui ta a laana ga ná-nu ɠiteɠitegi ta, ta-vaaɠaaza golai ma ɠasɔi ɠa la ti unma. ");
INSERT INTO tod_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Zunui ta a laana ga kɛɛɠɛ diɛ ɓaa deɠe zunui ta anza, é zunui naa ɠaazu unfe seɠea. Ti felegɔ ta ta-ɠotoi ma ɠasɔi zeɠe, ta za ɠana nɔ, ti la doun zɔlɔɔga. ");
INSERT INTO tod_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Ni zunui ta a kɛɛloin anzai zeina, kɔzɔba vaa ɠana, é kɛɛɠɛloin unfega, ti la doun zɔlɔɔga. ");
INSERT INTO tod_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Wa makɛ nà-deveiti ma, ta nà-tɔgiti, wo ti zo kpaan, naa ɠa a kɛ zooi ʋɛ gè ʋaazu liizu ga woye ná, ga wo zei ná, é la unpiliga ga woye. ");
INSERT INTO tod_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","À mina ziɛ ga zii naati ta-luʋai, niiti gè ʋaazu ti ɓɛɛzu wo luɠɔ, mazɔlɔɔ ti naama ɠɛɛwotiiti kpein kɛɛʋɛ, naa ʋɛlɛzeɠe bɛ̀. ");
INSERT INTO tod_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Gè boga wo ma: Wa ɠa wo ta-yooi zɔlɔɔsu, nà feezu wo ʋɛ ga wɔnɔ, zooi ʋe, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo yeeɠaaɠwɛa, wa zɔɔma ziiti. ");
INSERT INTO tod_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Wa zɔɠɔzu ɠɛ kɔzɔba zuaiti ta sua ɲadegaiti ba, ta kɔzɔba wɔniiti ta wɔni ɲadegaiti ba, naa ɠa a kɛ wo mina ɓɔɠɔ ɠɛ ga kɔzɔba ʋea, ga suaiti, ɓaa wɔniiti, ɓaa ga naati kpein, niiti ti ɓokposu zooi ma. Gè ti yeeɠaaɠwɛa, ta suai zɔiti, nii a kɛ wo kwɛɛ ga ti ɠɔzɔʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","«À ɲade nɔ̀un bɛ, mazɔlɔɔ ɲàdegɛ, nɔ̀un nà, Ɠɔoɠɔ GALAGI, gè wo yeeɠaaɠwɛɛʋɛ wa zɔɔma ziiti, naa ɠa a kɛ, wo ɠɛ ga nɔ̀nɔiti. ");
INSERT INTO tod_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Zunui ɓaa anzanui nii é ga gɔvɛ laawooleʋe nui, ɓaa nii gɔvɛiti ti ʋelela ʋele vaiti bosu ma, wa sɔ ga kɔtui, é za. Ma ɲamai ɠa la unma.» ");
INSERT INTO tod_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ɓɔɛ zalaɠa ɠula nuiti pɔ, Aalɔn ná-doun zunuiti, è ɠɛ ti ma: Zalaɠa ɠula nui la ɓɔɠɔ ɠɔzɔa ná-nuɓusɛiti saama gɔvɛ maaʋele ma. ");
INSERT INTO tod_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","É ɠula ná-nu ɠiteɠitegiti polu, dee, ɓaa kɛɛɠɛ, ɓaa ná-doun zunui, ɓaa ná-doun anzanui, ɓaa kɛɛɠɛloin, ");
INSERT INTO tod_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ɓaa ná-seelai, nii é la dɛ zeini zunu ʋɛ. Toɠa zoo é ɓɔɠɔ ɠɔzɔ ná-seelai naa ʋɛ, tɔɔzei naa ɠa ná-pɛlɛyeɠei wu, é la dɛ lɛɛni zunu ɠili ná-pɛlɛ wu. ");
INSERT INTO tod_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Toɠa ga kundiɠii ná-nuɓusɛiti saama, é la ɓɔɠɔ ɠɔzɔa, é ʋa lɔɠɔi ɠoloɠolo. ");
INSERT INTO tod_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Ni saa ɠa lona zalaɠa ɠula nuiti ma, ti la kpaana pɛa tɔungi zu, ti la ɓakalagiti boga, ti la pɔlɔpalɛ lɔa ɓɔɠɔ ma. ");
INSERT INTO tod_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ta ɲade ta-ƓALAGI ʋɛ, ti mina ta-ƓALAGI lɔɠɔi ɠoloɠolo, mazɔlɔɔ ta zalaɠaiti kulazu Ɠɔoɠɔ GALAGI ʋɛ, ná-daamianigi ʋe é ɠalazu abui ɠa. Ti maanɛɛʋɛ, ti ɲade. ");
INSERT INTO tod_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ti la koloɠolo anzanu zeiɗa, ɓaa nii tɔɠɔi ɠoloɠologai. Ti la anzanu zeiɗa, nii sinigi ɠɛlɛai ba, mazɔlɔɔ zalaɠa ɠula nui ɲadegɛ ná-GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Wa pɛtɛ ga ɲade nu, mazɔlɔɔ tɔ ɠa é daamianigi ɠulazu ga zalaɠai wa-ƓALAGI ʋɛ. Toɠa ɠɛ ga ɲade nu wo ʋɛ, mazɔlɔɔ nɔ̀un ɲàdegɛ, nɛ̀i gè ga Ɠɔoɠɔ GALAGI, nii é wo ɲadesu. ");
INSERT INTO tod_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ni zalaɠa ɠula nui ná-doun anzanui a lɔɠɔi ɠoloɠolona ga é lɔ koloɠologi zu, toɠa kɛɛɠɛ lɔɠɔi ɠoloɠolosu, ta gala, é za. ");
INSERT INTO tod_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Zalaɠa ɠula nui nii kundiɠilai zea, kɛɛɠɛlointi maazu, nii gulɔ ɲadegai ziaai ma, ta nii zalaɠa ɠula zeɠeiti toai kɔba, é la nɔundeɠaiti zɛga yaɠaba, ta é la ná-seɠeiti balia ga. ");
INSERT INTO tod_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","É la lia pooma ɠoba, é la ɓɔɠɔ ɠɔzɔa, anɛɛ ni kɛɛɠɛ a zaana, ɓaa dee. ");
INSERT INTO tod_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","É la ɠula seizu ɲadegai ʋa, naa ɠa a kɛ é mina seizu ɲadegai ɠɔzɔ, mazɔlɔɔ feeʋɛ bɛ̀ ga nà-siɛma wulɔ ɲadegai maaʋele. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Zalaɠa ɠula nui naa mina anzanu zei, nii é zunu vaa ɠwɛɛ. ");
INSERT INTO tod_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","É la poanza zeiɗa, ɓaa anzanui nii sinigi ɠɛlɛai ba, ɓaa koloɠolo anzanu, ɓaa nii tɔɠɔi ɠoloɠologai, kɛlɛ anzanui a ɠɛ seizu, kɛni é ɠɛ ga ná-bolodai zu anzalopo ɓeai, é la dɛ zunu vaa ɠwɛɛ. ");
INSERT INTO tod_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Zalaɠa ɠula nui naa la mavofodai lɔɠɔ ɠoloɠologa ná-bolodai zaama, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é tɔun ɲadesu.» ");
INSERT INTO tod_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Ɓɔɛ Aalɔn ʋɔ, è ɠɛ ma: È-mavofodai zu zunui tanɔpɛ, nii nɛɛʋuzu ba, naa mina maaɓuɠa ga é ná-GALAGI ná-daamianigi ɠula ga zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Zunui tanɔpɛ, nii nɛɛʋuzu a ɠɛ ba, naa la maaɓuɠaa ná ʋa: gaazuɠole nu, ɓaa dɛkpu nu, ɓaa nii sokpai maaʋegai, ɓaa baalobazuʋɛ ta zeɠeai kɛʋele ma, ");
INSERT INTO tod_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ɓaa zunui ta, nii kɔɠɔi ɠaleai, ɓaa zeei, ");
INSERT INTO tod_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ɓaa zunui ta, nii gɔgɔi polu, ɓaa é ga kutui, ɓaa gaazuwana nu, ɓaa dɔɠɔi ma, ɓaa kulama zeeɓɛi ba, ɓaa nii pɔlɔɠɛzɛɠain woloai. ");
INSERT INTO tod_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Zalaɠa ɠula nui Aalɔn mavofodai zu, zunui tanɔpɛ nii nɛɛʋuzu ba, naa mina maaɓuɠa ga é ʋa zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, zalaɠai niiti ti ɠalazu abui ɠa. Tɛi nɛɛʋuzuʋɛ ba, é mina maaɓuɠa, é ʋa ná-GALAGI ná-daamianigi ɠula ga zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Toɠa zoo é ná-GALAGI ná-daamianigi ta mi, aniiti ti wola ɲadegai, ta ani ɲadegaiti. ");
INSERT INTO tod_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Kɛlɛ é la lia kwɛpele seɠezuɠoozagi ʋɔ pelei, ta é la maaɓuɠaa zalaɠa ɠulazuʋɛ ʋa, mazɔlɔɔ nɛɛʋuzuʋɛ ɠa ba. É la nà-ada ɲadegai ɠɔzɔa ta ma zɔɔlaiti, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é ti ɲadesu.» ");
INSERT INTO tod_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moize naama wooiti daazeelini Aalɔn ma ta ná-doun zunuiti, é ʋɛɛ Izilayɛle nuiti kpein ba. ");
INSERT INTO tod_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Aalɔn ta ná-doun zunuiti kala ga fai niiti ta ti maaɲɛ, é lo vebɛani ɲadegaiti ba, niiti Izilayɛle nuiti ti ti ɠulazu bɛ̀, naa ɠa a kɛ ti mina dàasei ɲadegai ɠoloɠolo. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«Ɠɛ ti ma: Wo-mavofodaiti saama, zunu nɔpɛ kɔzɔai a yɛ de, é maaɓuɠa vebɛani ɲadegaiti ba, niiti Izilayɛle nuiti ti ti veezu bɛ̀, naama nui ɠa ɓɛ, é zeɠe gàazu. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Nu-o-nu Aalɔn mavofodai zu, kulama zeeɓɛi a ɠɛ ba, ɓaa kalaɲa kolegi, naa la vebɛani ɲadegaiti ta mia, eyɛsu é ɓe ga ɲade. Zekana é la ga zɔi a vɔɔɠuna nui ta ʋa, kɔzɔai ga poomai, ɓaa é ɓɔɠɔ maaɠoloɠologai. ");
INSERT INTO tod_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Zɔi a vɔɔɠuna kpokpo ganii ta ʋa, é kɔzɔi maazɔlɔɔ, ɓaa nu vului ta, nii kɔzɔba anii ma zii tanɔpɛ a ʋɛɛna ba, é ɠɔzɔ ga naa, ");
INSERT INTO tod_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","zɔi a vɔɔɠuna ta ʋa, naa ɠa yɛ kɔzɔyai zu eyɛsu kpɔkɔi, é la vebɛani ɲadegaiti ta mia, kɛni é maagba. ");
INSERT INTO tod_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Foloi a ɓena ga da, toɠa ɲade, naa ʋolu toɠa zoo niina é vebɛani ɲadegaiti ta mi, mazɔlɔɔ ná-daamianigi ʋe. ");
INSERT INTO tod_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","É la sua ʋooma mia, ɓaa nii baliʋaliai ga, nii a kɛ é mina ɓɔɠɔ ɠɔzɔ ga naa. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Zalaɠa ɠula nuiti ta nà-deveiti makɛ, naa ɠa a kɛ ti mina koloɠolo, koto ʋa la ti unma, ti mina ʋa zaazu. Nà ga Ɠɔoɠɔ GALAGI, nii é ti ɲadesu. ");
INSERT INTO tod_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Izilayɛle nu nɔpɛ ge mina vebɛani ɲadegai ta mi, ni é la ga zalaɠa ɠula nu. Anɛɛ zalaɠa ɠula nui ma wɛɛin ta ná-botiɠɛ nui, ti la vebɛani ɲadegai ta mia. ");
INSERT INTO tod_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kɛlɛ duɔi nii zalaɠa ɠula nui geyaai, naa ɠa zoo é ta mi, ta nii ɓalaagi sɔlɔɔgai ná-pɛlɛi wu, ta ná-daamianigi ta mi. ");
INSERT INTO tod_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Zalaɠa ɠula nui ná-doun anzanui, sinigi la ga zalaɠa ɠula nu, naa la naa ta mia, nii seɠeai vebɛani ɲadegaiti ba. ");
INSERT INTO tod_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kɛlɛ zalaɠa ɠula nui ná-doun anzanui, nii é ga poanzai, ɓaa nii sinigi ɠɛlɛai ba, é la doun zɔlɔɔni, ta nii é ʋaazu ɠalesu ma, é yɛ kɛɛɠɛ ná-pɛlɛi wu, eɠɛʋelei é ɠɛni ná la, ná-nu niinɛlai zu, naa ɠa zoo é kɛɛɠɛ ná-daamianigiti ta mi. Nu nɔpɛ ge la ta mia, ni é la ga zalaɠa ɠula nu. ");
INSERT INTO tod_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«Ni nui ta a vebɛani ɲadegai miina, ki ge la ba, toɠa vebɛanii liegɔi naa ve zalaɠa ɠula nui ya, é ta ʋɛɛ ba ga gaaɠwɛsu lɔɔlugɔi zeizu ɠilagi. ");
INSERT INTO tod_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Zalaɠa ɠula nuiti ti mina Izilayɛle nuiti ta-vebɛani ɲadegaiti kɔzɔ, nii naati ti seɠezu ba Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ni naati ta ta-vebɛani ɲadegaiti miina, ta ta-vaaɠaaza golai la ɓɔɠɔ unma, ti ɠɛ ga sɔba nuiti, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é ti ɲadesu.» ");
INSERT INTO tod_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Ɓɔɛ Aalɔn ta ná-doun zunuiti pɔ, naa ʋɛɛ Izilayɛle nuiti kpein ba, è ɠɛ ti ma: Nu kpein é ga Izilayɛle nu, ɓaa ti ga seikɔɠɔma nu Izilayɛle yooi zu, niiti ta gala zalaɠai ɠula Ɠɔoɠɔ GALAGI ʋɛ, minazeɠe daazeeli vaa zu, ɓaa vebɛanii vaa zu ti daai ɠisu, ");
INSERT INTO tod_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","nii a kɛ daazo, toɠa ʋa ga togani zinɛ ɠila, nii nɛɛʋuzu la ba, é kula nikɛiti saama, ɓaa baalagiti, ɓaa boliiti. ");
INSERT INTO tod_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","À mina ani nɔpɛ kula ga zalaɠai, nii nɛɛʋuzu a ɠɛ ba, mazɔlɔɔ daa la zoga wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ni zunui ta a toganii ma wolai ɓaa ma goi ta ɠulana ga ziilɛi zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, é ɠɛni ga minazeɠe daazeeli vai, ɓaa é ɠɛni ga vebɛanii nii é daai ɠisu, nɛɛʋuzu mina ɠɛ zalaɠa anii ʋa, naa ɠa a kɛ daazo. Nɛɛʋuzu nɔpɛ ge mina ɠɛ ba. ");
INSERT INTO tod_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","À mina sua nɔpɛ kula ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, nii gaazuɠoleai, ɓaa maalɛɠɛfɛgai, ɓaa koliiti ti ba, ɓaa kaʋai ɠulaai ma, ɓaa gɛlɛɠɛlɛgi ɠulaai ma. À mina naa ɠala zalaɠa ɠulazuʋɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Nikɛ zinɛi ɓaa baala ziʋoi nii baalobazuʋɛ ta ɠoozaai, ɓaa ta ɓuɠa, wa zoo wo naa ɠula ga zalaɠai ɓaa vebɛanii, nii wo daai ɠisu, kɛlɛ naa ɠɛɠala zuai ma zalaɠai la daazoga minazeɠe daazeeli vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","À mina sua ɠula ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, nii pɔlɔɠɛzɛɠain woloai, ɓaa kulaai su, ɓaa teʋeai ga. À mina naa ta ɠɛ ga zalaɠa wa-yooi zu. ");
INSERT INTO tod_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","À mina suai naa ma zii tanɔpɛ geya wɛɛn ma, wo ʋa kula wa-ƓALAGI ʋɛ ga zalaɠai. Mazɔlɔɔ ti maalɛɠɛfɛgɛ, nɛɛʋuzuʋɛ ɠa ba, daa la zoga wo ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Siɛgi zu nikɛi a zɔlɔɔna da, ɓaa baalagi, ɓaa bolii, toɠa yɛ ma leei ʋa, é kɛ ga folo lɔfela. É zo folo lɔsaʋasiɛi ma, eyɛsu zɔɔma voloiti, a ɠulana ga zalaɠai, nii abui galazu Ɠɔoɠɔ GALAGI ʋɛ, daa ɠa zo. ");
INSERT INTO tod_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","À mina togani leei ta ma yiʋoi ʋaa ʋɔɔma folo ɠila nɔ. ");
INSERT INTO tod_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Wa ɠɛna mama fee zalaɠai ɠulaa Ɠɔoɠɔ GALAGI ʋɛ, wa kula ʋele ɓɛtɛ, nii a kɛ daazo. ");
INSERT INTO tod_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Wa ti pɛ mi ma voloi nɔ ma, wo la ta yɛga ná, é ʋa yɛsu sobui ʋa zeeli. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Wa nà-deveiti so, wo ziɛ ga tiye. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","«À mina dàasei ɲadegai ɠoloɠolo, nà-ɲadedai ɠa maamusɛi zɔlɔɔ Izilayɛle nuiti saama. Nɔ̀un nà Ɠɔoɠɔ GALAGI, nii é wo ɲadesu, ");
INSERT INTO tod_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","nɛ̀i gè wo ɠulaai Ezipete yooi ʋa, ga gè ɠɛ ga wa-ƓALAGI. Nà ga Ɠɔoɠɔ GALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Fɛti voloi ɠa ga niiti, wo maanɛai wo ti ɠula dɛ̀bi vai ma, ti ga nà-fɛti voloiti. Naati ma vaa zu, wa nuɓusɛiti toli, ti gaalɛba ɲadegai wo. ");
INSERT INTO tod_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Ɛsɛ ka ná-botii ɠɛ folo lɔzita laawu, kɛlɛ foloi lɔfelasiɛi ɠa ga dooɠo foloi, gaalɛba ɲadegai ɠa wo ma. Wo la boti nɔpɛ kɛa naama voloi. Dooɠo foloi ɠa ɠɛ de Ɠɔoɠɔ GALAGI lɛbi vai ma, ʋɛ nɔpɛ wa zei ná. ");
INSERT INTO tod_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Wɛlɛ Ɠɔoɠɔ GALAGI ná-fɛti volo ɠiligi tanigaa ʋa, niiti wo maanɛai wo nuɓusɛiti toli ma, ti gaalɛba ɲadegai wo naama ɠuiti ma, ti logai. ");
INSERT INTO tod_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Alu mɔungi ma volo puugɔ maazu naanisiɛi (14) ma ɓɔkɔi, kpidii a ʋɛɛna, naa ɠa é ga Ɠɔoɠɔ GALAGI ná-Pakegi. ");
INSERT INTO tod_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Alugi naa ma volo puugɔ maazu lɔɔlusiɛi (15), naa ɠa ɠɛ ga ɓului nii lɛʋɛ la su, naa ma vɛtii, Ɠɔoɠɔ GALAGI lɛbi vai ma. Folo lɔfela laawu, wa yɛ ɓului miizu, nii lɛʋɛ la su. ");
INSERT INTO tod_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Folo mɔungi, wa gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Folo lɔfela laawu, wa zalaɠai ɠula, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ. Folo lɔfelasiɛi ma, wa nuɓusɛiti toli, wo gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la.» ");
INSERT INTO tod_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo ʋaazu lɔɔzu la zooi zu, nii gè feezu wo ya, wa moloi leʋena, wa ʋa ga ma ɠili ɠila, zalaɠa ɠula nui ʋɔ, wa-molo leʋea mɔungi zu. ");
INSERT INTO tod_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Dooɠo foloi ʋoluma zobui, zalaɠa ɠula nui ɠa molo ɠilii latɛɠɛ vai ma ʋoogi ɠɛ, Ɠɔoɠɔ GALAGI ɠakala, naa ɠa a kɛ daazo wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Voloi wo ʋaazu molo ɠilii latɛɠɛ vai ma ʋoogi ɠɛɛzu la, wa kona gila baala sinɛi zo, nii nɛɛʋuzu la ba, wo kula ga gala zalaɠai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Wa ɓulu vukɔ ʋagɔi kilo lɔzita ʋɛɛ ba, gaayɔgai ga gulɔi, eɠɛ vebɛ zalaɠai galaai abui ɠa, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ, ta puya zalaɠai litɛlɛ ɠila ta tukpɛ (1,5) dɔɔi zu. ");
INSERT INTO tod_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Aisa naama voloi ʋa zeeli, wo ʋaazu ma ga vebɛanii wa-ƓALAGI ʋɔ, à mina ɓulu mi, ɓaa ani ɠɔpɔ geega, ɓaa molo niinɛi. Naa ɠa ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ, ʋɛ nɔpɛ wa zei ná. ");
INSERT INTO tod_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Wa dɔɔɠɔi ɠaalu ga dɔfela, é zo dooɠo foloi ʋoluma voloi ma, yeei wo ʋaazu la ga molo ɠili, wo datɛɠɛ mà. ");
INSERT INTO tod_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","É zo dooɠo foloi ma voloi ma, wa folo ʋuulɔɔlugɔ (50) ɠaalu, wo molo niinɛi ma vebɛ zalaɠa ɠili kɛʋele ɓɛtɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Wa ʋa ga ɓulu felegɔ, wo zeɠe la wo-zeizuʋɛ, wo ti latɛɠɛ, ti ɠilagilagi ɠa ɓɛtɛ ga ɓulu vukɔ ʋagɔi kilo lɔzita, ti mɔ ga lɛʋɛi. Naati ta ga zooi ʋaalɔnɔ mɔungiti Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ɓului naati poluma, wa kona gila baala ziʋo lɔfela ɠula ga zalaɠai, nɛɛʋuzu mina ɠɛ ti ʋa, ta nikɛ zinɛ ɓokpa gila ta baala sinɛ felegɔ, ti ɠula ga gala zalaɠai, é ʋɛɛ ta-vebɛ zalaɠai ʋa, ta ta-ʋuya zalaɠai. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Wa boli zinɛi ɠula ga koto gba zalaɠai, ta kona gila baala sinɛ felegɔ, wo kula ga ziilɛi zalaɠai. ");
INSERT INTO tod_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Zalaɠa ɠula nui ɠa ti latɛɠɛ vai ma ʋoogi ɠɛ, Ɠɔoɠɔ GALAGI ɠakala, é ʋɛɛ zooi ʋaalɔnɔ mɔungiti ma ɓului ʋa, é ʋɛɛ baala ziʋo felegɔiti ba. Ta zeɠe, ti ve Ɠɔoɠɔ GALAGI ʋɛ, ti ɠɛ ga zalaɠa ɠula nui nɔnɔi. ");
INSERT INTO tod_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Naama voloi nɔ, wa nuɓusɛiti toli, ti gaalɛba ɲadegai wo. Wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ, ʋɛ nɔpɛ wa zei ná. ");
INSERT INTO tod_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Siɛgi zu wo moloi leʋezu la wa-yooi zu, wa kpala kpelamaʋɛ yɛ ná, wo mina ná leʋe, wo mina ɠale ma posuyɛʋɛi ma. Wa naa yɛ ná bala nuiti bɛ, ta seikɔɠɔma nuiti. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Alugi lɔfelasiɛi ma volo mɔungi ma, toɠa ɠɛ ga dooɠo folo wola wo ʋɛ, wo ɠitoo sù, wa puʋugiti fɛ, wo gaalɛba ɲadegai wo. ");
INSERT INTO tod_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. Wa zalaɠai ɠula, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Alugi lɔfelasiɛi ma volo puugɔi ma, naa ɠa ɠɛ ga koto gba voloi. Wa gaalɛba ɲadegai wo, wo zugi zo, wo zalaɠai ɠula, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Wo la boti nɔpɛ kɛa naama voloi, mazɔlɔɔ koto gba voloi ʋe, yeei koto gba vai maanɛai é ɠɛ la wo ʋɛ, Ɠɔoɠɔ GALAGI ɠaazu, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nu-o-nu nii é la zugi zoni naama voloi, naa ɓe ka leʋe ná-nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nu nɔpɛ a boti ɠɛɛna naama voloi, nà undaaʋili ná-nuɓusɛiti saama. ");
INSERT INTO tod_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Wo la boti nɔpɛ kɛa. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ, ʋɛ nɔpɛ wo zeizu ná. ");
INSERT INTO tod_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Toɠa ɠɛ wo ʋɛ ga dooɠo folo wolai, wa zugi zo. É zo alugi ma voloi laaʋuusiɛi ma ɓɔkɔi ma, é li poluma zobui ma ɓɔkɔi ʋɔ, kɛni wo looɠo.» ");
INSERT INTO tod_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Ma alugi lɔfelasiɛi nɔ ma volo puugɔ maazu lɔɔlusiɛi (15) ma, naa ɠa ɠɛ ga kota vɛtii Ɠɔoɠɔ GALAGI ʋɛ, folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Folo mɔungi, gaalɛba ɲadegai ɠa wo. Wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Folo lɔfela laawu, folo-o-folo wa gala zalaɠai gila kula, Ɠɔoɠɔ GALAGI ʋɛ. Foloi lɔsaʋasiɛi, wa gaalɛba ɲadegai wo, wo gala zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ. Toɠa ɠɛ ga gaalɛba ɲadegai GALA dɛbi vai ma. Wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Fɛti voloiti kana, Ɠɔoɠɔ GALAGI lɛbi vai ma, niiti wo maanɛai wo nuɓusɛiti toli ti ma, ti gaalɛba ɲadegai wo. Ti zalaɠaiti kula, ti ɠalazu abui ɠa, ta vebɛ zalaɠaiti, ta zalaɠaiti, ta puya zalaɠaiti, é zoloo foloi ɠilagilagi ma leveiti ma. ");
INSERT INTO tod_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Wa Ɠɔoɠɔ GALAGI ná-dooɠo foloiti maaɲɛ, wo ti la wa-vebɛaniiti maazu, ta wa-minazeɠegiti, ta wa-vebɛaniiti kpein wo ti laai ɠisu, niiti wo ti veezu Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Alu dɔfelasiɛi ma volo puugɔ maazu lɔɔlusiɛi (15) ma, siɛgi zu wo zooi zu ani waaiti kulazu la, wa fɛtii ɠula Ɠɔoɠɔ GALAGI lɛbi vai ma. Wa naa ɠɛ folo lɔfela laawu. Folo mɔungi ɠa ɠɛ ga dooɠogi, dɔsaʋasiɛi ɓalaa ɠɛ ga dooɠogi. ");
INSERT INTO tod_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Folo mɔungi, wa gulu ʋagɔiti ma waai zeɠe, ta dɔɔ laaiti, ta gulu ɓekegiti, ti ɠaaɓiiliai, ta ziɛla wulu ɓekegiti. Wa ɠoozunɛ Ɠɔoɠɔ GALAGI ɠaazu, wa-ƓALAGI, wo naa ɠɛ folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kona-o-kona wa fɛtii naa ɠula Ɠɔoɠɔ GALAGI lɛbi vai ma, folo lɔfela laawu. Toɠa ga ɠɔoɠɔ tɔgi wo-mavofodaiti kpein bɛ. Wa ɠɛ kulazu alu dɔfelasiɛi ma. ");
INSERT INTO tod_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Wa zei kotaiti bu folo lɔfela laawu. Izilayɛle yooi zu, zou lointi kpein ta zei kotaiti bu, ");
INSERT INTO tod_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","naa ɠa a kɛ, wo-mavofodaiti ti kwɛɛ ga gè Izilayɛle nuiti seini kotaiti bu, gè ti ɠulaai ma Ezipete yooi ʋa. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ʋele ɠana Moize kalagiti feeni la Izilayɛle nuiti zea, é ʋilɛ Ɠɔoɠɔ GALAGI ná-fɛti voloiti ba. ");
INSERT INTO tod_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Devei ve Izilayɛle nuiti zea, ga ti ʋa è ʋɔ ga wolive wulɔ ʋagɔi, kpɛtɛai fitinai vaa zu, naa ɠa a kɛ wo yeeyɛ fitinaiti ba, yeenɔpɛ ti mina za. ");
INSERT INTO tod_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","GALA daaɠomi seɠe ʋɛlɛi wu, kwɛpele seɠezuɠoozagi ɠakalaʋɛ, nii é zeele woo ɠesui ɠakalaʋɛ, miná ɠa Aalɔn a sei ná, fitinaiti ti so, é zo kpɔkɔi ma, eyɛsu geelaalao, Ɠɔoɠɔ GALAGI ɠaazu. Toɠa ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Toɠa fitinaiti kɛʋele ɓɛtɛ, fitina zei anii ɠa, é ga zanu kitei, ti ɗa zo yeenɔpɛ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Ɗa ɓulu vukɔ ʋagɔi zeɠe, è ɓulu puugɔ maazu felegɔ (12) ɓɛtɛ, ɓului ɠilagilagi ɠa ɠɛ ga kilo lɔzita. ");
INSERT INTO tod_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Ɗa ti ɠɛʋele ɓɛtɛ zanu kitei ma laɓalii ɠa, Ɠɔoɠɔ GALAGI ɠaazu, ga seizu felegɔ. ");
INSERT INTO tod_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Ɗa ansanse kitei ta ʋu seizu ɠilagilagi ma. Naa ʋolu ɗa ansanse kitei ɠala Ɠɔoɠɔ GALAGI ɠaazu, ɓului ʋotogi zu, eɠɛ ɠizɛsui. ");
INSERT INTO tod_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Dooɠo foloi ɠilagilagi, ta ɗa ɓului naati kɛʋele ɓɛtɛ yeenɔpɛ Ɠɔoɠɔ GALAGI ɠaazu. Toɠa ga minazeɠegi é yɛsu ná ɠɔ, Izilayɛle nuiti ta-vaa zu. ");
INSERT INTO tod_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ɓului naati ta ɠɛ ga Aalɔn ta ná-doun zunuiti tɔnɔ, ta ti mi ada ɲadegai ta, mazɔlɔɔ toɠa ɠɛ ti ʋɛ ga vebɛani ɲadega wolai, naati saama, niiti ti ɠalazu, Ɠɔoɠɔ GALAGI ɠaazu. Toɠa ga ɠɔoɠɔ tɔgi.» ");
INSERT INTO tod_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Yeeta, Izilayɛle anzanu ɠila ta Ezipete zunu ɠila, ti-loun zunui ʋaani Izilayɛle nuiti saama. Kpɔɛi leʋeni ti-ʋuuzuʋɛ, Izilayɛle anzanui naa ná-doun zunui ta Izilayɛle zunui ta ti yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Izilayɛle anzanui naa ná-doun zunui woo ɲɔiti boni GALA daalɔɠɔma, é koto. Ti ʋaani la Moize ʋɔ. Dee laaseigi ɠɛni ga Selomite, Diɓili ná-doun anzanui, Dan ná-bolodai zu. ");
INSERT INTO tod_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ti makɛni ga pagɔ, eyɛsu deve zɔlɔɔ Ɠɔoɠɔ GALAGI ya. ");
INSERT INTO tod_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«À woo ɲɔu wo nui ɠula wo-ʋuuzuʋɛ ʋa. Niiti kpein ti gooi mɛnigai, naati ti yeeiti pɛɛ unma, naa ʋoluma bɛbɛi kpein ge sɔ ga kɔtui, é za. ");
INSERT INTO tod_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ɗa ɓɔɛ Izilayɛle nuiti pɔ ga, nu-o-nu a ná-GALAGI ɠotona, naama nui ɠa ná-kotoi ma ɠasɔi zeɠe. ");
INSERT INTO tod_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Zɔi nɔpɛ a woo ɲɔu wona Ɠɔoɠɔ GALAGI laaseigi laalɔɠɔma, ta naama nui ʋaa, bɛbɛi kpein ka sɔ ga kɔtui, é za, é ɠɛni ga seikɔɠɔma nu ɓaa zou loun, tɔɔzei é woo ɲɔi woga GALA daaseigi laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«Zɔi a nu ʋaana, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Zɔi a sua ʋaana, toɠa potogi ve ga suai ta. Zɛnvui ʋoto ka ɠɛ ga zɛnvui. ");
INSERT INTO tod_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ni nui ta a seiɲɔɠɔi maawanana, toɠa ɠɛ la, eɠɛʋelei tɔ ɓɔɠɔi é kɛa la ga zɔi. ");
INSERT INTO tod_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Nii a nu ɠaei ɠale, naama nui ɠaei ɠa ɠale, nu ɠaazuɠɛzɛi ʋoto ka ɠɛ ga nu ɠaazuɠɛzɛi, nu ɲiiga ʋoto ka ɠɛ ga nu ɲiiga. Ta naama maawanai ɠɛɠalai ɠɛ ga naa, nii é kɛa ga zɔi. ");
INSERT INTO tod_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Zɔi a sua ʋaana, toɠa potogi ve. Kɛlɛ zɔi a nu ʋaana, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«Tɔ gilagi nɔ ɠa seiɗai wo ma, seikɔɠɔma nu ʋɛɛ zou loun ʋa, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moize ɓɔɛni Izilayɛle nuiti pɔ. Ti woo ɲɔu wo nui ɠulani ti-ʋuuzuʋɛ ʋa, ti sɔ ga kɔtuiti, é za. Izilayɛle nuiti ti kɛɛni ɠana, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ Sinayi gizei ma, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo ʋaazu lɛɛzu la zooi naa zu, gè feezu wo ʋɛ, wa ɗa zooi yɛ ná, é ɗa looɠo yeeɠɛɠalai tanigaa zu, naa ɠa ɠɛ Ɠɔoɠɔ GALAGI ná-lɛbiyai vaa ma. ");
INSERT INTO tod_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kona dɔzita laawu, wa wa-ani zuwui vaza wa-ɓalagiti su. Kona dɔzita laawu, wa wa-leezɛn ɓeleiti suɓɛtɛ ga pagɔ, wo gaawaai ɠula. ");
INSERT INTO tod_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kɛlɛ kona dɔfelasiɛi, dooɠogi ɠa ve zooi ya, dooɠogi ɠa ɠɛ Ɠɔoɠɔ GALAGI lɛbi vai ma. Wo la ani zuwu vazaga wa-ɓalagiti ba. Wo la wa-leezɛn ɓeleiti suɓɛtɛa. ");
INSERT INTO tod_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Wo la molo ɠɔɠɔʋolu leʋea, wo mina leezɛn ɠula kpelei zu, nii su la ɓɛtɛni. Naa ɠa ɠɛ ga dooɠogi ɲɛgɛlɛin zooi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Zooi ná-dooɠogi zaalai zu, wa ɠɔnɔgi zɔlɔɔ, wɔun wa, wa-wotiɠɛ zunuiti, ta wa-wotiɠɛ anzanuiti, ta nui nii wo salazu folo-o-folo, ta wɛɛn é zeini wo ɠɔɠɔma, ");
INSERT INTO tod_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ta wa-loganiiti, ta suaiti ti wa-yooi zu, zooi ʋaalɔnɔgi kpein ka ɠɛ ga daamianigi. ");
INSERT INTO tod_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Wa dooɠo kona dɔfela ɠaalu, kona dɔfela zeizu lɔfela, naa ɠa é ga kona ʋuunaanigɔ maazu taaʋuugɔ (49). ");
INSERT INTO tod_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Alu dɔfelasiɛi ma voloi ʋuusiɛi ma, wa puʋugi vɛ, gooɠula, koto gba voloi, wa puʋugi vɛ wa-yooi kpein su. ");
INSERT INTO tod_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Wa kona ʋuulɔɔlusiɛi (50) naa leve ga kona ɲadegai, wo ɓɔɠɔyeemai laazeeli zooi zu zei wo nuiti kpein ma. Toɠa ɠɛ wo ʋɛ ga ɓɔɠɔyeema ɠonagi, ɛsɛ gilagilagi ná-zooi ɠa ɠaaɠale ma pɔ, ta ɛsɛ ka ɠale ma ná-pɛlɛyeɠei wu. ");
INSERT INTO tod_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Kona ʋuulɔɔlusiɛi (50) ɠa ɠɛ wo ʋɛ ga ɓɔɠɔyeema ɠonagi: Wo la ani zuwu vazaga, wo mina molo ɠɔɠɔʋolu leʋe, wo mina leezɛn ɠula kpelei zu, nii su la ɓɛtɛni. ");
INSERT INTO tod_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Mazɔlɔɔ ɓɔɠɔyeema ɠonagi ʋe. Wa deve ga ɲadegɛ. Anii niiti ti ʋɔnɔsu ɓɔɠɔ ʋɛ kpalagi zu, wa naati mi. ");
INSERT INTO tod_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Ɓɔɠɔyeema ɠonagi naa zu, ɛsɛ gilagilagi ná-zooi ɠa ɠaaɠale ma pɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ni wa zou ʋɔdina, ɓaa wo geya Izilayɛle nui ta ma, à mina tooma vaa ɠɛ. ");
INSERT INTO tod_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wa zou ʋɔdi zɔngɔi ɓaa geya zɔngɔi ɠwɛteʋe, é tɔɔzei ɓɔɠɔyeema ɠona gaaɓelagi ma, konagi liegɔi teʋegai, ta molo leʋei liegɔi a ɠɛ, aisa ɓɔɠɔyeema ɠonagi ʋa zeeli. ");
INSERT INTO tod_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Konagi ta a ɠɛna laa ta ma, wa sɔngɔi ta la ma, konagi ma ge la ɠɛ dɛ mɔinni, wo ta ɠula sɔngɔi la. Mazɔlɔɔ molo leʋe laa liegɔi ɠa, é pɔdizu wo ma. ");
INSERT INTO tod_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Wo tanɔpɛ ge mina loo seiɲɔɠɔi ma. Wa lua wa-ƓALAGI ʋa, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","«À nà-tɔgiti so, ta nà-deveiti, wo ti makɛ, wo ziɛ ga tiye, wa zei zooi zu ziilɛigi zu. ");
INSERT INTO tod_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Zooi ɠa ná-kulanumaiti fe, wa daami wo, wo yiɠo, wo zei ziilɛigi zu. ");
INSERT INTO tod_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ni wa ɠɛna ma: ‹Leeni ɠa gá mi konagi lɔfelasiɛi, mazɔlɔɔ gi la tii ɠɛɛni, gi la ʋaazu ani zuwu ma lɔnɔ kulazu?› ");
INSERT INTO tod_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Nà, nà-tuyai loo wo ʋɛ, konagi lɔzitasiɛi, nii a kona saʋagɔ molo leʋei liegɔi ve wo ya. ");
INSERT INTO tod_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wa tii ɠɛ konagi lɔsaʋasiɛi ma, ta wa molo wɔlɔmai mi, eyɛsu molo leʋea niinɛi zeeli, wa ɠɛ ma wɔlɔmai miizu. ");
INSERT INTO tod_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Zooi la ʋɔdia, é ʋa yɛsu ɠɔ, mazɔlɔɔ zooi ɠa ga nɔ̀nɔ, wa pɔ̀ bɛ ga wɛɛinti, eɠɛ nuiti ti ʋaai zeizu zooi zu yeeɠɛɠala go laawu. ");
INSERT INTO tod_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Zooi zu ná kpein, ʋɛ wo ʋaazu zeizu ná, é ɠɛ ga wɔnɔ, wa tɔgi zei, é zobogi veezu ɛsɛ pɛ bɛ ga é ná-zooi unmɔɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Ni Izilayɛle nui ta a ɠɛna zeaɲakalai zu, é ná-zooi ta ʋɔdi, nii maanɛai ga é lo unmɔɔ fai ɠa, é ga ná-nu ɠiteɠitegi, naa ɠa ʋa, é naa unmɔɔ, nii kɛɛloin pɔdia. ");
INSERT INTO tod_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ni nui ta ɠa ná, nu la zea, maanɛai ga é lo unmɔɔ fai ɠa bɛ, ni a ani zɔlɔɔna ɓɔɠɔ ʋɛ, nii a ná-unmɔɔ fai ɠɛ la, ");
INSERT INTO tod_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","toɠa tɔɔzei ga konagiti gaaluga, é zo pɔdi voloi ma, é naa ʋotogi ve, nii é laazu maazu geya nui ʋɛ, ná-zooi ɠaaɠale ma pɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ni é la ani zɔlɔɔni, a potogi leʋe da, zooi ɠa yɛ geya nui yeezu, eyɛsu ɓɔɠɔyeema ɠonagi zeeli. Toɠa ɠaaɠale ma, é ɠɛ zeezu, é ɠɛ ga nɔnɔ názu. ");
INSERT INTO tod_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Ni nui ta a daa ʋɛlɛi ʋɔdina taai ta zu, maalatigai ga siɠigi, toɠa zoo é unmɔɔ kona gila daawu, é zo pɔdi voloi ma. Ná-unmɔɔ fai ɠa lɛbisu ga kona gila nɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kɛlɛ pɛlɛi naa togai taai ta zu, maalatigai ga siɠigi, ni naa la unmɔɔni kona gilagi ɠɛɛzu é pilɛ da, toɠa ɠɛ ga geya nui nɔnɔ niina eyɛsu ɠɔ, ta nɔnɔ mavofodai, ti la mɔ teʋega, anɛɛ ɓɔɠɔyeema ɠonagi a zeelina. ");
INSERT INTO tod_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pɛlɛiti ti taaiti su, siɠi ge la ti ma, naati ta leve, eɠɛʋelei zooi ma lɔgiti ti la. Pɔdi nui ɠa zoo é unmɔɔ, ni naa laade pɛlɛi ɠa leʋe ma nui ʋɔ ɓɔɠɔyeema ɠonagi. ");
INSERT INTO tod_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Nii é ga Levi nuiti ta-ʋɛlɛiti ta-vai, niiti ti ta-laaiti su, Levi nuiti ta zoo ti unmɔɔ fai ɠɛ eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Zɔi a pɛlɛi ta ɠeyana Levi nu ma taai zu, toɠa ɠula pɛlɛi naa wu, pɔdiai ma, ɓɔɠɔyeema ɠonagi ma. Mazɔlɔɔ Levi nuiti ta-ʋɛlɛiti ta-laaiti su, ta ga ta-ʋoganii Izilayɛle nuiti saama. ");
INSERT INTO tod_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Kpalagiti ti ta-laaiti maaɠoolii zu, naati maa la nɛɛni, ti ʋa ʋɔdi, mazɔlɔɔ tiya ɠa ta-ʋoganii ʋe eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Ni Izilayɛle nui ta a ɠɛna ga zeaɲaka nu wo ɠoba, aniiti balagai zea, wa yeezei bu, eɠɛʋelei wo kɛɛzu la wɛɛinti ɓaa seikɔɠɔma nuiti bɛ, naa ɠa a kɛ é zɛnvui wo wo ɠoba. ");
INSERT INTO tod_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","À mina talama maaloli ma, ɓaa kulanumai, wa lua wa-ƓALAGI ʋa, wo-ɠɛɛloin zɛnvui wo wo ɠoba. ");
INSERT INTO tod_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","À mina kuye ʋɛɛ ga wa-walii, wo ʋa ta la ma. Wo la wa-laamianigi vea zea ga lɔdɔgi, wo ʋa ta la ma. ");
INSERT INTO tod_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo ɠula Ezipete yooi ʋa, ga é Kanaan yooi ve wo ya, naa ɠa a kɛ gè ɠɛ ga wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Ni Izilayɛle nui ta a ɠɛna ga zeaɲaka nu wo ɠoba, é ɓɔɠɔ ʋɔdi wo ma, à mina duɔla wotii la unma. ");
INSERT INTO tod_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Toɠa ɠɛ wo ʋɔ bɛ, eɠɛ nui é botii ɠɛɛzu, wo ɗa sala, é ɠɛ eɠɛ seikɔɠɔma yeeɠɛɠala go nɔ zu. Toɠa yɛ wa-wotii laawu eyɛsu ɓɔɠɔyeema ɠonagi zeeli. ");
INSERT INTO tod_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Toɠa zeɠe názu wo ʋɔ bɛ, tɔ-o, ná-dointi-yo, é ɠale ma ná-bolodai zu, kɛɛɠɛ ʋoganii zaama. ");
INSERT INTO tod_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Mazɔlɔɔ nà-botiɠɛ nuiti be, gè ti ɠulaai Ezipete yooi ʋa, ti la ʋɔdia, eɠɛʋelei duɔiti ta ʋɔdi la. ");
INSERT INTO tod_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","È la zeiɗa unda ga maaɓa, kɛlɛ wa lua wa-ƓALAGI ʋa. ");
INSERT INTO tod_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«Ziiti ti wo-maaɠoolii zu, naati saama ɠa wa duɔ zunui ɓaa duɔ anzanui zeɠena, ti ɠɛ ga wɔnɔ, tiya ɠa wa duɔiti geya ti zu. ");
INSERT INTO tod_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Niiti ti ʋaai zeizu wo zaama, yeeɠɛɠala go laawu, wa zoo wo naati geya, ta ti-mavofodaiti. Ta ɠɛ ga wɔnɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wa ti yɛ ná, wa zeɠena ná, ti ɠɛ ga pogani wo-loun zunuiti bɛ, ti ɠɛ ga tɔnɔ. Wa zoo wo ti makɛ, ti ɠɛ ga duɔiti eyɛsu ɠɔ. Kɛlɛ wo-ɠɛɛlointi tetemazu, ti ga Izilayɛle nuiti, wo tanɔpɛ ge mina zei kɛɛɠɛloin unga ga maaɓa. ");
INSERT INTO tod_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Ni wɛɛn ɓaa seikɔɠɔma nu, a ɠɛna ga kpɛtɛ nui, Izilayɛle nui ta ɠɛ ga zeaɲaka nu koba, ni a ɓɔɠɔ ʋɔdina wɛɛn naa ma, ɓaa seikɔɠɔma nui naa ma, ɓaa wɛɛn ná-bolodai zu nui ta ma, ");
INSERT INTO tod_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","unmɔɔgi ma zobogi maanɛɛʋɛ é ɠɛ bɛ, anɛɛ ni é ɓega ga ɓɔɠɔ ʋɔdi. Kɛɛɠɛloin ta ɠa zoo é unmɔɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Kɛɛɠɛ diɛ ɓaa deɠe zunui ta, ɓaa naa ná-doun zunui ta, ɓaa ná-nu ɠiteɠitegi ta, é ná-bolodai zu, naa ɠa zoo é unmɔɔ. Ɓaa ni sɔlɔɔ gani ɠa ná, nii zeelaai ma, toɠa ɓɔɠɔ unmɔɔ. ");
INSERT INTO tod_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ta geya nui ta konagi ɠaalu, é zo pɔdi voloi ma, é zeeli ɓɔɠɔyeema ɠonagi ma. Unmɔɔ salai ɠa leve, é zoloo nui ná-folo ɠila wotiɠɛ zalai ma, naa ɠa gaalusu, é zoloo konagi liegɔi ma. ");
INSERT INTO tod_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ni konagi wola mɔinʋɛ dɛ, ná-unmɔɔ fai zu, toɠa letemaʋɛ ma walii ɠula, nii zunui naa geyaai la. ");
INSERT INTO tod_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ni kona mɔinmɔin ge la mɔ yɛni, eyɛsu ɓɔɠɔyeema ɠonagi zeeli, toɠa gaalugi ɠɛ, é letemaʋɛ ma walii ɠaaɠale ma, ná-unmɔɔ fai zu, é zoloo naama ɠonagiti ma. ");
INSERT INTO tod_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Toɠa ɠɛ maliɠii ʋɔ bɛ eɠɛ botiɠɛ nu, é ɗa zalai zeɠe konagi laawu. Naa la zeiɗa unda, é ʋa sopele ɲɔu ga maaɓa. ");
INSERT INTO tod_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ni é la unmɔɔni ga naama ʋelei tanɔpɛ, toɠa yɛ ná, eyɛsu ɓɔɠɔyeema ɠonagi zeeli, é ɠɛ ɓɔɠɔ yeema, tɔ-o, dointi-yo. ");
INSERT INTO tod_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Mazɔlɔɔ Izilayɛle nuiti ta ga botiɠɛ nuiti bɛ̀, tɔɔzei gè ti ɠulani Ezipete yooi ʋa. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«À mina kɔɔɠɔ ganigiti kpɛtɛ ɓɔɠɔ ʋɛ. À mina vololiba ʋilɛ, ɓaa sale ɠɔtu. À mina kɔtui tanɔpɛ saɠa, wo ʋa ɗa nɔkɔ bu wa-yooi zu, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","«Wa nà-dooɠo foloiti maaɲɛ, wo unfe sèizu ɲadegai ma. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Ni wa ziɛna ga nà-deveiti, wo ɠolo nà-tɔgiti bɛ, ni wa ti zona, ");
INSERT INTO tod_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nà tonaiti fe wo ya ma yeeɠɛɠalai ma, zooi ɠa ná-kulanumaiti fe, guluiti ta waa. ");
INSERT INTO tod_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Wa yɛ ɠɔ moloi loɠazu, eyɛsu dɔɔ ɓɛtɛ yeeɠɛɠalai zeeli, wo yɛ ɠɔ dɔɔ ɓɛtɛ vai ɠɛɛzu, eyɛsu ani zuwu vaza yeeɠɛɠalai zeeli. Wa daamianigi zɔlɔɔ ga mɔinɗa, wo zei ga pagɔ ziilɛigi zu, wa-yooi zu. ");
INSERT INTO tod_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Nà ziilɛigi lɔ zooi zu, wa ɲiimɛnii wo, faa nɔpɛ ge la wo ɓɔlɔa. Nà sua vilɛiti kpein kula wa-yooi ʋa, kɔɔ la ɠɔa wa-yooi zu. ");
INSERT INTO tod_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Wa ʋilɛ wo zili nuiti polu, wo zobo sɔlɔɔ ti ma ga wa-woɠa zɔkpɔi, ti loo. ");
INSERT INTO tod_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Wo zaama, nu lɔɔlugɔ ɠa pilɛ sɔlɔɔ nu ungila (100) ma, ta nu ungila (100) ka nu waapuugɔ (10.000) ɓɛ. Wa-woɠa zɔkpɔi ɠa ɠɛ wo zili nuiti toozu bu. ");
INSERT INTO tod_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Nà yeeyɛ wo ʋa, gè wo ɠɛ ga kpuɠu nu, wo wola mɔin. Nà nà-minazeɠegi makɛ kpaan wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Wa molo wɔlɔmai mi, wo mɔtai likpi vɔlɔ, nii a kɛ wo ma niinɛi ʋuuzu zɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Nà sèizuʋɛ ɓɛtɛ wo zaama, gè la mɔ ɠɛlɛa wo ʋa pɛ. ");
INSERT INTO tod_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nà ziɛ wo zaama, gè ɠɛ ga wa-ƓALAGI, wo ɠɛ ga nà-nuɓusɛiti. ");
INSERT INTO tod_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo ɠulani Ezipete yooi ʋa, é wo ɠula duɔlai zu. Gè wa-unbawuluiti galeɠaleni, wo ziɛ unbuzeɠei zu. ");
INSERT INTO tod_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Kɛlɛ ni wo la woiloni gòo ma, wo ʋa ziɛ ga devei niiti kpein, ");
INSERT INTO tod_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ni wa nà-deveiti wɔinzeɠena, wo ɠɛlɛ nà-tɔgiti ba, wo la ziɛni ga nà-deveiti kpein, wo nà-minazeɠegi ɠoloɠolo, ");
INSERT INTO tod_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","à wɛlɛ ʋelegi gè ʋaazu wo zosu da: Nà ziiɓɔlɔi lɔ wo zaama, kɔsɔ kolegi ta kɔlɔkpadimai ɗa wo zo, ti ɗa wo-ɠaazuʋɛti maaɓidi, ta ɗa ɠula wo-zii la. Wa wa-ani zuwuiti faza fuun nɔ, mazɔlɔɔ wo zili nuiti ta wa-molo leʋeaiti seɠe. ");
INSERT INTO tod_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nà ɠale ma wo laalɔɠɔma, wo-ɠɔɔɲɔɠɔiti ta zobo sɔlɔɔ wo ma. Niiti ti wo wɔinzeɠezu, naati ta zei wo unda. Wa ʋela, anɛɛ ni nu la ʋilɛni wo ʋolu, é ʋa ɗa wo ɓɛ. ");
INSERT INTO tod_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Ni naa pɛ poluma, wo la woiloni gòo ma, nà wo maaɠolo ná zeizu ɠɛ lɔfela wa-ɠotoiti faa zu. ");
INSERT INTO tod_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nà wa-wasogi ma zɛbɛi ɠoloɠolosu, geezuʋɛ ɠa ɓaa wo ma eɠɛ kɔlui, wa-yooi ɠɛ eɠɛ kɔlu ɓɔigi. ");
INSERT INTO tod_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Wo-zuvikɛi ɠa ɓe, é ɠula wo ya fuun, wa-yooi la mɔ ná-kulanumaiti fea, zooi ɠa wuluiti ti la mɔ waa. ");
INSERT INTO tod_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Ni wa ɠɛlɛna, wo la kɛɛni, wo ʋa woilo gòo ma, nà wo loɠa ná zeizu ɠɛ lɔfela, eɠɛʋelei wa-ɠotoiti ti la. ");
INSERT INTO tod_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nà dɔɓɔ zuaiti teʋe wo laalɔɠɔma, ti wo-lointi paa, ti wa-loganiiti suwuɠaaleʋe, ti wo maalɔi, wa-ʋeleiti ta ʋaazu ɠɛɛzu ga teʋebaiti. ");
INSERT INTO tod_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Ni, anɛɛ naa ʋe, wo la vaani bu, gè ʋa wo maaɠolo, wa sàkpena, ");
INSERT INTO tod_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nà ɓalaa, nà wo zakpe, gè wo loɠa ná zeizu ɠɛ lɔfela mɔnɔ, wa-ɠotoiti faa zu. ");
INSERT INTO tod_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nà kɔɔiti teʋe wo laalɔɠɔma, tɔɔzei wo minazeɠegi ɠoloɠologa. Wa ɠaalɛɛna ba wa-laaiti su, gè ɗɔfɔ zeeɓɛi lɔ wo zaama, wa lɔ wo zili nuiti zeezu. ");
INSERT INTO tod_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Siɛgi zu gè wo ʋalasu la wo-ɠɔnɔgi ma, anzanu puugɔ ɠa ɓului mɔ sulu gila su, ti ʋaa la wo ʋɔ, gaa a ɠwɛɛna, wa daami wo, wo la yiɠoa. ");
INSERT INTO tod_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Ni, anɛɛ naa ʋe, wo la woiloni gòo ma, wa sàkpena, ");
INSERT INTO tod_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nà ɓalaa, nà wo zakpe ga ziiɠaawanai, gè wo loɠa ná zeizu ɠɛ lɔfela mɔnɔ, wa-ɠotoiti faa zu. ");
INSERT INTO tod_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Wa wo-loun zunuiti ma zuaiti mi, wo wo-loun anzanuiti ma zuaiti mi. ");
INSERT INTO tod_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nà wa-zalaɠa ɠula adaʋɛti koloɠolo, ta wa-ansansegiti ma zalaɠa ɠulazuʋɛti, gè wo-ma ʋoomaiti pu wa-ɠɔɔɠɔ ganigiti ma ʋoomaiti ma, nà ɠɛlɛ wo ʋa. ");
INSERT INTO tod_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nà wa-laaiti kɛ ga teʋebai, gè wa-ada ɲadegaiti faza, wa-zalaɠa maku nɛɛnɛgiti ti la mɔ zìilɛiɗa. ");
INSERT INTO tod_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Nà ɓɔɠɔi, nà zooi zuɠoloɠolo, wo zili nuiti ti ʋaai, ti zei ná, naati koozu ɠa ʋili, ti laavɔ. ");
INSERT INTO tod_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nà wo vaza ziiti saama, gè ʋilɛ wo ʋolu ga boɠa zɔkpɔi. Wa-yooi zu ɠa ɠoloɠolo, wa-laaiti ta ɠɛ ga teʋebai. ");
INSERT INTO tod_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Naazu zooi ɠa dooɠo sɔlɔɔ, siɛgi kpein é kɛɛzu gaalɛi zu, wa ɠɛɛzu wo zili nuiti ta-yooi zu. Zooi ɠa looɠo názu. ");
INSERT INTO tod_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Siɛgi kpein é kɛɛzu gaalɛi zu, toɠa dooɠogi zɔlɔɔ, nii é la ɠɛa sɔlɔɔsu wa-looɠo konagiti su, siɛgi zu wo zeini la ná. ");
INSERT INTO tod_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Wo zaama, niiti ti ɠɛɛzu zeini ti zili nuiti ta-yooiti su, nà ti-yiiti daave ga dualuagi. Daai é ɲiikpisu, naa lugi ɠa ti maalua. Ta ʋela, eɠɛʋelei nu a ɗa ʋela la sili nui ná-boɠa zɔkpɔi ʋa. Ta loo, anɛɛ ni nu la ʋilɛni ti ʋolu. ");
INSERT INTO tod_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ta ɓunɛsu ɓɔɠɔ ma, eɠɛʋelei nu a ɠɛ la boɠa zɔkpɔi ɠakala, anɛɛ ni nu la ʋilɛni ti ʋolu. Wo la ungalɔga wo zili nuiti kakala. ");
INSERT INTO tod_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Wo undaa ɠa ʋili zii ɠiligiti saama. Wo zili nuiti ta-yooi ɠa wo maaɓili. ");
INSERT INTO tod_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Niiti ta yɛ vulua wo zaama, naati ta ɓɔɠɔ undaaʋili ti zili nuiti ta-yooi zu, ta-vaaɠaaza golaiti ta ti-mɛmɛwolani ta-vaaɠaaza golaiti faa zu. ");
INSERT INTO tod_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Ta laa zɔ ga ga ta-vaaɠaaza golaiti, ta ti-mɛmɛwolani ta-vaaɠaaza golaiti, é lo wooveledaiti ba, ti ti ɠɛɛni ga ze, ta sakpegi ti bogai ga ze, ");
INSERT INTO tod_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","naa ɠa é kɛa gè ti zakpeni, gè li ga tiye ti zili nuiti ta-yooi zu. Ni ta ɓɔɠɔmaayeina, ta ti ta-vaaɠaaza golai ma ɠuyei zala, ");
INSERT INTO tod_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","nà ɠizɛ nà-minazeɠegi zu, gi yɔɠɔzu gá ti-mɛmɛwolani, Zakɔɓe, Izaake, ta Abalaame, nà ɠizɛ ɓalaa zooi zu. ");
INSERT INTO tod_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Mazɔlɔɔ ta ɠula zooi ʋa, naa ɠa dooɠo sɔlɔɔ názu, siɛgi zu é gaalɛi zu la, ti maaɠoozaai ba. Ta ta-vaaɠaaza golai ma ɠuyei zala, tɔɔzei ti ɠɛlɛni nà-deveiti ta nà-tɔgiti ba. ");
INSERT INTO tod_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Kɛlɛ siɛgi zu ti ɠɛɛzu la, ti zili nuiti ta-yooi zu, gè la ɠɛlɛa ti ʋa ɲɛgɛlɛin, gè la ti-ma zuwu ɠaaleʋea, gè la nà-minazeɠegi ɠoloɠologa ti letemazu, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, ta-ƓALAGI. ");
INSERT INTO tod_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Nà ɠizɛsu nà-minazeɠe mɔungi zu ti-mɛmɛwolani tetemazu, niiti gè ti ɠulani la Ezipete yooi ʋa, ziiti gaazu, ga gè ɠɛ ga ta-ƓALAGI. Nà ga Ɠɔoɠɔ GALAGI.» ");
INSERT INTO tod_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Kalagiti kana, ta deveiti, ta tɔgiti, niiti Ɠɔoɠɔ GALAGI ti zeini, ti yɔɠɔzu ta Izilayɛle nuiti, Sinayi gizei ma ga Moize maaʋele. ");
INSERT INTO tod_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Ni nui ta a minazeɠena ga é nui ta ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔ, toɠa ná-minazeɠegi laazeeli ga sɔngɔi, ");
INSERT INTO tod_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","a lona zunui ta ʋa, nii é kona ʋuufelegɔ (20) zɔlɔɔga, eyɛsu é zeeli kona ʋuulɔzita (60) ma, sɔngɔi ɠa ɠɛ ga wali ɠae ʋuulɔɔlugɔ (50), é zoloo seizu ɲadegai ma walii ma. ");
INSERT INTO tod_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ni anzanu ʋe, sɔngɔi ɠa ɠɛ ga wali ɠae ʋuusaʋagɔ (30). ");
INSERT INTO tod_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Zunu loungoi, é zo kona dɔɔlugɔ ma, é li kona ʋuufelegɔ (20) ʋɔ, sɔngɔi ɠa ɠɛ ga wali ɠae ʋuufelegɔ (20), anzanu loungoi ma zɔngɔi ɠa ɠɛ ga wali ɠae puugɔ. ");
INSERT INTO tod_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","É zo alu gila ma, é li kona dɔɔlugɔ ʋɔ, zunu loungoi ma zɔngɔi ɠa ɠɛ ga wali ɠae lɔɔlugɔ, anzanu loungoi ma zɔngɔi ɠa ɠɛ ga wali ɠae saʋagɔ. ");
INSERT INTO tod_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","É zo kona ʋuulɔzita (60) ma, é lɛ zeemaazu, zunui ma zɔngɔi ɠa ɠɛ ga wali ɠae puugɔ maazu lɔɔlugɔ (15), ta anzanui ma zɔngɔi ɠa ɠɛ ga wali ɠae puugɔ. ");
INSERT INTO tod_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ni zɔi é minazeɠegi ɠɛai, naa ɠa ga zeaɲaka nu, é la zooga é ʋa sɔngɔi zala, toɠa ʋa ga zɔi nii é kalivaai, é dɛɛ ga zalaɠa ɠula nui. Naa ɠa deve, é soloo ná-sɔlɔɔgi ɠɛʋelei ma. ");
INSERT INTO tod_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Ni nu a minazeɠena ga é suai ta ve Ɠɔoɠɔ GALAGI ʋɛ, nii a zoo ɠulazu ga zalaɠa, naa veeʋɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nu la maavaliboga, nu la ma ʋagɔi ʋotogi ɠɛa ga ma ɲɔi, ɓaa ma ɲɔi ʋotogi ɠɛ ga ma ʋagɔi. Ni nu a suai ʋotogi ɠɛɛna ga taɠili, ti felegɔ ta ve Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«Ni nu a minazeɠena ga é sua ɠɔzɔai ta ve Ɠɔoɠɔ GALAGI ʋɛ, nii é la zooga ɠulazu ga zalaɠa, toɠa lɛ ga zalaɠa ɠula nui, ");
INSERT INTO tod_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","naa ɠa sɔngɔi leve, é zoloo pa pelei ɓaa ɲɔu ʋelei ma, ná-devei ɠa ta yeezei bu. ");
INSERT INTO tod_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ni fee nui ɠa pɔ é unmɔɔ, toɠa ta la ma ga dɔɔlugɔi zeizu ɠilagi. ");
INSERT INTO tod_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Ni nui ta wɔinʋɛ ga é ná-pɛlɛi ve Ɠɔoɠɔ GALAGI ʋɛ, é kɛ ga nɔnɔ, zalaɠa ɠula nui ɠa sɔngɔi leve, é zoloo ná-pagi ɓaa ná-ɲɔi ma, ta yeezei naa wu, sɔngɔi nɔpɛ é devezu. ");
INSERT INTO tod_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ni zɔi nii é feai, toɠa pɔ é unmɔɔ, toɠa sɔngɔi ma ɠaaɠwɛsu lɔɔlugɔi ɠilazuʋɛ la sɔngɔi ma, naa ɠa ɠɛ ga nɔnɔ ʋolu ga niinɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Ni nui ta a ná-kpalagi veena Ɠɔoɠɔ GALAGI ʋɛ, sɔngɔi liegɔi ɠa ɠwɛɛ, é zoloo ani zuwui liegɔi ma, nii a vaza ba, wali ɠae ʋuulɔɔlugɔ (50) moloi é ga wɔɔlezegi naama ɠilo unsaʋagɔ (300). ");
INSERT INTO tod_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ni a ná-kpalagi veena ɓɔɠɔyeema ɠonagi lɔɔzeigi, ta va sɔngɔi liegɔi wu. ");
INSERT INTO tod_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ni toɠa ná-kpalagi ve ɓɔɠɔyeema ɠonagi a leʋena, zalaɠa ɠula nui ɠa sɔngɔi ɠaalu, é zoloo konagi liegɔi ma, nii zɛgai ná, eyɛsu ɓɔɠɔyeema ɠonagi zɔi zeeli, ta ta ɠula sɔngɔi liegɔi la. ");
INSERT INTO tod_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ni kpala nui ɠa pɔ é ná-kpalagi unmɔɔ, toɠa sɔngɔi ma ɠaaɠwɛsu lɔɔlugɔi ɠilazuʋɛ ʋɛɛ ba, eɠɛʋelei zalaɠa ɠula nui a ɠida la sɔngɔi liegɔi wu, toɠa kpalagi zeɠe ʋolu. ");
INSERT INTO tod_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ni é la kpalagi unmɔɔni, é ʋɔdi zunui taɠili ma, zobo ge la mɔ ná, é ʋa unmɔɔ, ");
INSERT INTO tod_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ɓɔɠɔyeema ɠonagi a zeelina, kpalagi naa ɠa ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔ, é ɠɛ ga zalaɠa ɠula nui nɔnɔ, eɠɛ kpalagi nii feai Ɠɔoɠɔ GALAGI ʋɛ eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Ni nui ta a kpalagi veena Ɠɔoɠɔ GALAGI ʋɛ, nii é geyaai, é la ʋɛɛni ná-poganiiti ba, ");
INSERT INTO tod_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","zalaɠa ɠula nui ɠa ɠida sɔngɔi liegɔi wu, é zoloo konagi liegɔi ma, a yɛ ná, eyɛsu ɓɔɠɔyeema ɠonagi zɔi zeeli. Zou vee nui ɠa naama walii liegɔi zala, naama voloi nɔ yeei deveai la, mazɔlɔɔ kpalagi veeʋɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Kɛlɛ ɓɔɠɔyeema ɠonagi ma, kpalagi ɠa ɠaaɠale ma naa ma, nii é ɠeyani ma, nii zooi ɓɔɠɔi ɠɛa zea ga poganii. ");
INSERT INTO tod_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Sɔngɔi kpein ka wo é zoloo seizu ɲadegai ma walii ma, nii ma ɠae ɠilagi wuɲɛgi ga galamu puugɔi. ");
INSERT INTO tod_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Nu nɔpɛ ge la zooga é ʋa ná-togani ma yiʋo mɔungi ve Ɠɔoɠɔ GALAGI ʋɛ, mazɔlɔɔ ma mɔungi kpein ka niina ga Ɠɔoɠɔ GALAGI nɔnɔi, é ɠɛni ga togani goiti ɓaa ma wolaiti ti-ma yiʋoiti. ");
INSERT INTO tod_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ni toɠa ɠɛ ga sua ɠɔzɔai ta, é la ɠulaa ga zalaɠa, toɠa unmɔɔ, eɠɛʋelei sɔngɔi la, é sɔngɔi ma ɠaaɠwɛsu lɔɔlugɔi ɠilazuʋɛ zeɠe, é pɛɛ ba. Ni é la unmɔɔni, toɠa ʋɔdi, eɠɛʋelei sɔngɔi la. ");
INSERT INTO tod_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Naa ʋoluma, nii kpein nu a kona Ɠɔoɠɔ GALAGI ma, kɔligaa zaama ti ga nɔnɔi, naa la zooga ʋɔdizu, ɓaa é ʋa unmɔɔ, é ɠɛni ga nu vului, ɓaa toganii, ɓaa kpalagi é ga zeaɠɔligi. Nii kpein a ɠona Ɠɔoɠɔ GALAGI ma, naa ɠa ɠɛ ga nɔnɔ ta anii gola ɲadegai. ");
INSERT INTO tod_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Anɛɛ ni nuɓusɛi ʋe a kona, nu la zooga é ʋa unmɔɔ, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Zooi ná-puusiɛiti, é ɠɛni ga zooi ʋaalɔnɔgiti, ɓaa guluiti gaawaaiti, ta ga Ɠɔoɠɔ GALAGI nɔnɔ, ani ʋe feai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ni nui ta ɠa pɔ é ná-puusiɛi ma anii ta unmɔɔ, toɠa sɔngɔi ma ɠaaɠwɛsu lɔɔlugɔi ɠilazuʋɛ zeɠe, é pɛɛ ba. ");
INSERT INTO tod_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Puusiɛ vai, nii é ʋilɛsu nikɛiti ba, ta baalagiti, ta boliiti, toganii a leʋena puu, tukpɔi wu, puusiɛi ɠa ve Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Togani nui la zooga é ʋa ziimazeɠe kɛ, ma ʋagɔi ta ma ɲɔi zu. Nu la ta maavaliboga ga taɠili. Ni nu a ta ʋotogi ɠɛɛna ga taɠili, ti felegɔ ta ɠɛ ga ani ɲadegai, ti la zooga unmɔɔsu.» ");
INSERT INTO tod_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Deveiti kana Ɠɔoɠɔ GALAGI ti veeni Moize ya, Izilayɛle nuiti ta vaa ma, Sinayi gizei ma.");
INSERT INTO tod_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ Sinayi teʋebai zu, GALA daaɠomi seɠe ʋɛlɛi wu, alugi velesiɛi ma volo mɔungi ma, ti ɠulaai ma Ezipete yooi ʋa, ma ɠonagi velesiɛi. É ɠɛni ma: ");
INSERT INTO tod_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«À Izilayɛle nuɓusɛiti kpein gaalu, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, wo zunuiti kpein gaalu, ");
INSERT INTO tod_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, nii dɔin seeliai kɔɔɠɔ vai ma Izilayɛle nuiti saama. Wa Aalɔn, wa ti ɠaalu ga kɔɔʋɛbɛi ɠɛʋelei. ");
INSERT INTO tod_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","«Zunu ɠilagila ka ɠɛ wo ʋa, é ɠula bolodai ɠilagilagi zu, zunui nii a ɠɛ ga pɛlɛyeɠe ɠundiɠii. ");
INSERT INTO tod_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Wɛlɛ zunuiti daaseigiti ba, niiti ta ɓɔ wo ʋa: Luɓɛn ʋɔ bɛ, Elisuul, Sedeyuul ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simiyɔn ʋɔ bɛ, Selumiyɛle, Sulisadayi ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Zuda ʋɔ bɛ, Naason, Aminadaɓe ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isakaal ʋɔ bɛ, Netaneyɛle, Suaal ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zaɓulɔn ʋɔ bɛ, Eliyaɓe, Ɠelon ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Zozɛfe ná-doun zunuiti pɔ bɛ, Efelayime ʋɔ bɛ, Elisama, Amiyude ná-doun zunui, Manasé ʋɔ bɛ, Gameliyɛle, Pedasuul ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Ɓɛnzamɛn ʋɔ bɛ, Aɓidan, Gideyɔni ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan ʋɔ bɛ, Ayiyezɛɛl, Amisadayi ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asɛɛl ʋɔ bɛ, Pagiyɛle, Wokelan ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gade ʋɔ bɛ, Eliasafe, Deyuwɛle ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nɛfɛtali ʋɔ bɛ, Ayila, Enan ná-doun zunui.» ");
INSERT INTO tod_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Naati ka ti ɠɛni ga nuɓusɛiti gaazuʋɛti, ti ti lolini. Ti ɠɛni ga ta-wolodamaiti ta-lotuɠɔiti. Tiya ɠa ti ɠɛni ɓalaa ga Izilayɛle ɠɔɔɓɔgi ma ɠundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moize ta Aalɔn ti zunui niiti kpɔni ɓɔɠɔ ʋa, niiti ziimazeɠegi ɠɛni ga tiye ga ti-laaseigiti. ");
INSERT INTO tod_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Ti nuɓusɛiti pɛ gaalɛɛni ba, alugi velesiɛi ma volo mɔungi ma. Ti Izilayɛle nuiti kpein gaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti. Ti zunuiti daaseigiti sɛʋɛni ga gilagila, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, ");
INSERT INTO tod_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. Zekana Moize ta-ɠaalugi woni da Sinayi teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Luɓɛn, Izilayɛle ná-doun zunu mɔungi, mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Luɓɛn ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuunaani maazu lɔzita undɔɔlugɔ (46.500). ");
INSERT INTO tod_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simiyɔn mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simiyɔn ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔɔlu maazu taaʋuu unsaʋagɔ (59.300). ");
INSERT INTO tod_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gade mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gade ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuunaani maazu lɔɔlu undɔzita puulɔɔlu (45.650). ");
INSERT INTO tod_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Zuda mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Zuda ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔfela maazu naani undɔzita (74.600). ");
INSERT INTO tod_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Isakaal mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Isakaal ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔɔlu maazu naani unnaani (54.400). ");
INSERT INTO tod_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zaɓulɔn mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zaɓulɔn ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔɔlu maazu lɔfela unnaani (57.400). ");
INSERT INTO tod_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Zozɛfe ná-doun zunui Efelayime mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Efelayime ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuunaani undɔɔlu (40.500). ");
INSERT INTO tod_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasé mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manasé ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuusaʋa maazu fele unfelegɔ (32.200). ");
INSERT INTO tod_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Ɓɛnzamɛn mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ɓɛnzamɛn ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuusaʋa maazu lɔɔlu unnaanigɔ (35.400). ");
INSERT INTO tod_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔzita maazu fele undɔfela (62.700). ");
INSERT INTO tod_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asɛɛl mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Asɛɛl ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuunaani maazu ɠila undɔɔlugɔ (41.500). ");
INSERT INTO tod_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Nɛfɛtali mavofodaiti tetemazu, ti zunuiti gaaluni ga gilagila, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Nɛfɛtali ná-bolodai zu nii gaaluni, naa ɠɛni ga zunu waaʋuulɔɔlu maazu saʋa unnaanigɔ (53.400). ");
INSERT INTO tod_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Naati tiegɔi ɠa Moizeni ta Aalɔn ti gaaluni. Zunu puugɔ maazu felegɔiti (12) niiti ti ɠɛni ga Izilayɛle woloda ɠundiɠiiti, naati ti ɓɔni ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Izilayɛle nuiti saama, niiti kpein ti ti ɠaaluni, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, niiti kpein ta la zoo ti li kɔɔmaʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ti ɠɛni ga zunu waaundɔzita zunu waasaʋagɔ undɔɔlu puulɔɔlu (603.550). ");
INSERT INTO tod_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Levi nuiti ta-wolodai zu, ti-ɠɛɛ ʋɛlɛyeɠeiti bu, ti ɠaa la ɠɛni luni ti zaama. ");
INSERT INTO tod_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Mina Levi nuiti ta-wolodamaiti gaalu, mina ti ɠaalu Izilayɛle nuiti saama ɲɛgɛlɛin. ");
INSERT INTO tod_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Seɠe ʋɛlɛ ɲadegai, nii zeele woo ɠesui bu, naa ma wotii ve Levi nuiti zea, ta ma zɔɔlaiti kpein, ta nii kpein é ga naama vai. Ta seɠe ʋɛlɛi zeɠe, ta ná-sɔɔlaiti kpein, ti ná-botii ɠɛ, ti ʋu seɠe ʋɛlɛ ɲadegai maaɠoolii zu. ");
INSERT INTO tod_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Siɛgi zu seɠe ʋɛlɛ ɲadegai a ɠɛna zeɠea la losuʋɛ, é ʋa li ada ɠili, Levi nuiti ta kulakula ba, ti to ʋolu ga niinɛ, ʋɛ ta ɠɛ zeizu ná. Zɔi nɔpɛ a maaɓuɠana ná ʋa, nii é la ga Levi ná-bolodai zu nui ta, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Izilayɛle nuiti ta ʋu ti-ʋuuzuʋɛ ti ɠilagilagi, ná-bolodai ná-poogi ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Kɛlɛ Levi nuiti ta ʋu seɠe ʋɛlɛ ɲadegai maaɠoolii zu, nii zeele woo ɠesui bu, naa ɠa a kɛ nà-ziiɠaawanai mina vuka Izilayɛle ʋɛbɛi ma. Levi nuiti ta ɠɛ seɠe ʋɛlɛ ɲadegai makɛsu.» ");
INSERT INTO tod_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Izilayɛle nuiti ti ɠoloni, ti deveiti kpein so, niiti Ɠɔoɠɔ GALAGI ti veeni Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Izilayɛle nuiti ti ɠilagilagi ɠa ʋu ná-bolodai ná-poogi ɠobaʋɛ, ta-ʋɛlɛyeɠeiti ta-ʋoogi wu. Ta ʋu GALA daaɠomi seɠe ʋɛlɛi letema, ta maaɠoolii zu. ");
INSERT INTO tod_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Zuda ná-bolodai ɠa ʋu folo ɠulazu ʋelei, ná-poogi wu, ga ná-kɔɔɓɔgiti kɛʋelei. Ná-kundiɠii ɠa ɠɛ ga Naason, Aminadaɓe ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔfela maazu naani undɔzita (74.600). ");
INSERT INTO tod_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isakaal ná-bolodai ɠa ʋu kobaʋɛ. Ná-kundiɠii ɠa ɠɛ ga Netaneyɛle, Suaal ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔɔlu maazu naani unnaanigɔ (54.400). ");
INSERT INTO tod_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zaɓulɔn ná-bolodai ɠa ʋu zɔɔla ʋelei. Ná-kundiɠii ɠa ɠɛ ga Eliyaɓe, Ɠelon ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔɔlu maazu lɔfela unnaanigɔ (57.400). ");
INSERT INTO tod_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Zuda ná-kɔɔɓɔgiti ti-liegɔi ɠa ɠɛ ga zunu waaungila waaʋuulɔsaʋa maazu lɔzita unnaanigɔ (186.400). Naati ka ta lo siɛi ma ʋelei la. ");
INSERT INTO tod_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Luɓɛn ná-bolodai ɠa ʋu nu yeezazu ʋelei, ná-poogi wu, ga ná-kɔɔɓɔgiti kɛʋelei. Ná-kundiɠii ɠa ɠɛ ga Elisuul, Sedeyuul ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuunaani maazu lɔzita undɔɔlugɔ (46.500). ");
INSERT INTO tod_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simiyɔn ná-bolodai ɠa ʋu kobaʋɛ. Ná-kundiɠii ɠa ɠɛ ga Selumiyɛle, Sulisadayi ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔɔlu maazu taaʋuu unsaʋagɔ (59.300). ");
INSERT INTO tod_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gade ná-bolodai ɠa ʋu zɔɔla ʋelei. Ná-kundiɠii ɠa ɠɛ ga Eliasafe, Leyuwɛle ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuunaani maazu lɔɔlu undɔzita puulɔɔlugɔ (45.650). ");
INSERT INTO tod_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Luɓɛn ná-kɔɔɓɔgiti ti-liegɔi ɠa ɠɛ ga zunu waaungila waaʋuulɔɔlu maazu ɠila unnaani puulɔɔlugɔ (151.450). Naati ka ta ɠɛ ʋelelaiti poluʋɛ siɛ wo fai zu. ");
INSERT INTO tod_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Naa ʋoluma, Levi nuiti ta ʋilɛ ti ʋolu ga GALA daaɠomi seɠe ʋɛlɛi, siɛ wo fai zu. Ta ɠɛ kɔɔɓɔ felegɔ mɔungiti ta kɔɔɓɔ felegɔ ɠaaɓelagiti zɔɠɔzu. Ʋelei ti ʋuu ʋelei la, pele ɠana ta lii la, ɛsɛ ge yɛ losu, ti ɠilagilagi, ta ta-ʋoogiti. ");
INSERT INTO tod_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Efelayime ná-bolodai ɠa ʋu folo liizu ʋelei, ná-poogi wu, ga ná-kɔɔɓɔgiti kɛʋelei. Ná-kundiɠii ɠa ɠɛ ga Elisama, Amiyude ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuunaani undɔɔlugɔ (40.500). ");
INSERT INTO tod_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manasé ná-bolodai ɠa ʋu kobaʋɛ. Ná-kundiɠii ɠa ɠɛ ga Gameliyɛle, Pedasuul ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuusaʋa maazu fele unfelegɔ (32.200). ");
INSERT INTO tod_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ɓɛnzamɛn ná-bolodai ɠa ʋu zɔɔla ʋelei. Ná-kundiɠii ɠa ɠɛ ga Aɓidan, Gideyɔni ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuusaʋa maazu lɔɔlu unnaanigɔ (35.400). ");
INSERT INTO tod_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Efelayime ná-kɔɔɓɔgiti ti-liegɔi ɠa ɠɛ ga zunu waaungila maazu lɔsaʋa ungila (108.100). Naati ka ta ɠɛ liizu togi zaʋasiɛi zu. ");
INSERT INTO tod_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Dan ná-bolodai ɠa ʋu nu ɠɔʋɛzu ʋelei, ná-poogi wu, ga ná-kɔɔɓɔgiti kɛʋelei. Ná-kundiɠii ɠa ɠɛ ga Ayiyezɛɛl, Amisadayi ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔzita maazu felegɔ undɔfela (62.700). ");
INSERT INTO tod_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Asɛɛl ná-bolodai ɠa ʋu kobaʋɛ. Ná-kundiɠii ɠa ɠɛ ga Pagiyɛle, Wokelan ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuunaani maazu ɠila undɔɔlugɔ (41.500). ");
INSERT INTO tod_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Nɛfɛtali ná-bolodai ɠa ʋu zɔɔla ʋelei. Ná-kundiɠii ɠa ɠɛ ga Ayila, Enan ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ná-kɔɔɓɔgi liegɔi ɠa ɠɛ ga zunu waaʋuulɔɔlu maazu saʋa unnaanigɔ (53.400). ");
INSERT INTO tod_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan ná-kɔɔɓɔgiti ti-liegɔi ɠa ɠɛ ga zunu waaungila waaʋuulɔɔlugɔ maazu lɔfela undɔzita (157.600). Naati ka ta li ga gaaɓelagi ta ta-ʋoogiti.» ");
INSERT INTO tod_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Izilayɛle nuɓusɛiti ti ti ɠaaluni ga pɛlɛyeɠei, ta ta-ɠɔɔɓɔgiti kɛʋelei, ti-liegɔi ɠɛni ga zunu waaundɔzita zunu waasaʋagɔ undɔɔlu puulɔɔlugɔ (603.550). ");
INSERT INTO tod_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Levi nuiti gaa la ɠɛni luni Izilayɛle nui zɔiti saama, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Izilayɛle nuiti ti ziɛni ga deveiti pɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. Naa ɠa é kɛɛni, ti ɠɛni ʋuuzu ta-ʋoogi ɠoba. Ta ɠɛna ziaa, ti lo ga ta-woloda ʋelei, ta pɛlɛyeɠe ʋelei. ");
INSERT INTO tod_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Aalɔn ta Moize ti-mavofodai ʋɛtɛ, siɛgi zu Ɠɔoɠɔ GALAGI ɓɔɛni la Moize ʋɔ Sinayi gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aalɔn ná-doun zunuiti daaseigiti kaa: ma mɔungi laaseigi ɠɛni ga Nadaɓe, naa ʋolumai Aɓiyu ta Eleazaal, ta Itamaal. ");
INSERT INTO tod_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ti ɠɛni ga zalaɠa ɠula nuiti, gulɔ ɲadegai ziɛni ti ma, zobogi ve ti ya, ga ti zalaɠa ɠula wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Kɛlɛ Nadaɓe ta Aɓiyu ti zaani Ɠɔoɠɔ GALAGI ɠaazu Sinayi teʋebai zu, tɔɔzei ti ʋaani ga abu ɠiligi. Ti la ɠɛni dounɠa zɔlɔɔni. Eleazaal ta Itamaal ti zalaɠa ɠula wotii ɠɛɛni, ti-ɠɛɛ Aalɔn ɗa wɛlɛ ti ma. ");
INSERT INTO tod_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Ʋa ga Levi mavofodai, è ma nuɓusɛiti pu zalaɠa ɠula nui Aalɔn yeema, ga ti ɗa ɓɔ ba. ");
INSERT INTO tod_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ta ɠɛɛzu ná-botii zu, ta nuɓusɛiti ta-wotii, GALA daaɠomi seɠe ʋɛlɛi ɠakala, ti ti-losuʋɛti kpein kɛ, ti daazeeli, é lo seɠe ʋɛlɛ ɲadegai ʋa. ");
INSERT INTO tod_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ti ɠaaɓa GALA daaɠomi seɠe ʋɛlɛi wu zɔɔlaiti ma, ti ti makɛ, ti ɠɛ Izilayɛle nuiti ta-wotii zu, ti ti-losuʋɛ kpein kɛ, ti daazeeli, é lo seɠe ʋɛlɛ ɲadegai vai ʋa. ");
INSERT INTO tod_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ɗa Levi nuiti fe Aalɔn ta ná-doun zunuiti zea. Ta veezu bɛ ɲɛgɛlɛin, ti ɠɛ ga Izilayɛle nuiti gaazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ɗa Aalɔn ta ná-doun zunuiti sei, ti zalaɠa ɠula wotii ɠɛ. Zɔi nɔpɛ a maaɓuɠana seɠe ʋɛlɛ ɲadegai ʋa, nii é la ga ta-ʋɛlɛyeɠei wu nui ta, ta naama nui ʋaa.» ");
INSERT INTO tod_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Wɛlɛ, gè yiimazeɠea ga Levi nuiti, Izilayɛle nuiti saama, doun zunu mɔungiti kpein potogi zu, Izilayɛle anzanuiti ti-loun mɔungiti. Ta ga nɔ̀nɔiti. ");
INSERT INTO tod_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Doun zunu mɔungi kpein ka ga nɔ̀nɔ, é zo naama voloi ma, yeei gè Ezipete yooi zu loun zunu mɔungiti paani la, gè Izilayɛle loun zunu mɔungiti makɛni ɓɔɠɔ ʋɛ, é zo nuiti ti-lointi ma, é li suaiti ti-yiʋoiti pɔ. Ta ga nɔ̀nɔ. Nà ga Ɠɔoɠɔ GALAGI.» ");
INSERT INTO tod_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Ɠɔoɠɔ GALAGI devei veeni Moize ya, Sinayi teʋebai zu, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Levi mavofodaiti gaalu, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, ta ta-wolodamaiti. Ɗa zunuiti kpein gaalu, é zo alu gila ma, é lɛ zeemaazu.» ");
INSERT INTO tod_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moize ti ɠaaluni Ɠɔoɠɔ GALAGI ná-devei zu, eɠɛʋelei é ma levei zɔlɔɔni da. ");
INSERT INTO tod_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi ná-doun zunuiti daaseigiti ti ɠɛni ga: Gɛɛlɛson, Keɠate ta Melali. ");
INSERT INTO tod_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gɛɛlɛson ná-doun zunuiti daaseigiti kaa, eɠɛʋelei ta-wolodamaiti ti la: Liɓini ta Simeyi. ");
INSERT INTO tod_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Keɠate ná-doun zunuiti daaseigiti kaa, eɠɛʋelei ta-wolodamaiti ti la: Amalame, Yiseɠaal, Eɓelɔn, ta Uziyɛle. ");
INSERT INTO tod_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Melali ná-doun zunuiti daaseigiti kaa, eɠɛʋelei ta-wolodamaiti ti la: Maali ta Musi. Levi ná-bolodamaiti kana, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la. ");
INSERT INTO tod_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gɛɛlɛson mavofodaiti ti ɠɛni ga Liɓini ná-bolodamaiti ta Simeyi nɔnɔiti. ");
INSERT INTO tod_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ti-liegɔi ɠɛni ga zunu waadɔfela undɔɔlugɔ (7.500), é zo alu gila ma, é lɛ zeemaazu. ");
INSERT INTO tod_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gɛɛlɛson ná-bolodamaiti ti-ʋuuzuʋɛ ɠɛni ga seɠe ʋɛlɛ ɲadegai ʋoluʋelei, folo liizu ʋelei. ");
INSERT INTO tod_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gɛɛlɛson ná-bolodamaiti ta-ɠundiɠii ɠɛni ga Eliasafe, Layɛle ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ti-losuʋɛ ɠɛni ga ti ɠaaɓa GALA daaɠomi seɠe ʋɛlɛi ʋaalobazuʋɛ niiti ma: seɠe ʋɛlɛ ɲadegai, ta ma ʋɛɛmazeɠei, ta kwɛpele seɠezuɠoozagi, nii é GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ta koii ma zasai laaʋɛ ma ɠwɛpele seɠezuɠoozagi, ta sasai ma zeɠeiti, nii é seɠe ʋɛlɛ ɲadegai ta zalaɠa ɠulazuʋɛ maaɠoolii zu, é ʋɛɛ ta-ɠaluiti ba. Tiya ɠa ti-ɠasɔ ɠɛni ga botii, nii togai naama aniiti kpein ba. ");
INSERT INTO tod_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keɠate mavofodaiti ti ɠɛni ga Amalame ná-bolodamaiti, ta Yiseɠaal nɔnɔiti, naa ʋɛɛ Eɓelɔn ta Uziyɛle tɔnɔiti ba. ");
INSERT INTO tod_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ti-liegɔi ɠɛni ga zunu waadɔsaʋa undɔzita (8.600), é zo alu gila ma, é lɛ zeemaazu. Ti pɛ ka ti ɠɛni seizu ɲadegai ma wotii zu. ");
INSERT INTO tod_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Keɠate ná-bolodamaiti ti-ʋuuzuʋɛ ɠɛni ga nu yeezazu ʋelei seɠe ʋɛlɛ ɲadegai ɠilazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Keɠate ná-bolodamaiti ta-ʋɛlɛyeɠeiti ta-ɠundiɠii ɠɛni ga Elisafan, Uziyɛle ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ti-losuʋɛ ɠɛni ga ti ɠaaɓa GALA daaɠomi seɠe ʋɛlɛi ma zɔɔlai niiti ma: minazeɠe kesui, ta taɓalii, ta fitina zei anii, ta zalaɠa ɠulazuʋɛti, ta seizu ɲadegai ma zɔɔlaiti kpein, niiti botii ɠɛni ɠɛɛzu ga tiye, ta kwɛpele seɠezuɠoozagi. Tiya ɠa ti-ɠasɔ ɠɛni ga botii, nii togai naama aniiti kpein ba. ");
INSERT INTO tod_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Levi nuiti ta-ɠundiɠi wolai ɠɛni ga Eleazaal, zalaɠa ɠula nui Aalɔn ná-doun zunui. Tɔ ɠa é ɠɛni wɛlɛzu Levi nuiti ma, niiti ti ɠɛni seizu ɲadegai ma wotii zu. ");
INSERT INTO tod_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Melali mavofodaiti ti ɠɛni ga Maali ná-bolodamaiti ta Musi nɔnɔiti. ");
INSERT INTO tod_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ti-liegɔi ɠɛni ga zunu waadɔzita unfelegɔ (6.200), é zo alu gila ma, é lɛ zeemaazu. ");
INSERT INTO tod_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Melali ná-bolodamaiti ta-ʋɛlɛyeɠeiti ta-ɠundiɠii ɠɛni ga Suliyɛle, Aɓiyayile ná-doun zunui. Ti-ʋuuzuʋɛ ɠɛni ga seɠe ʋɛlɛ ɲadegai ɠilazu ʋelei nu ɠɔʋɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ti-losuʋɛ ɠɛni ga ti ɠaaɓa GALA daaɠomi seɠe ʋɛlɛi ʋaalobazuʋɛ niiti ma: seɠe ʋɛlɛ ɲadegai zuzo guluiti, ta ma wulu zɔkpɔiti, ta ma lɔkpalaiti, ta ta-labuiti, ta ta-zɔɔlaiti kpein niiti botii ɠɛni ɠɛɛzu ga tiye, ");
INSERT INTO tod_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ta tɔkpalaiti ti ɠɛni ga koii ma zasai, é ɠooli ma, é ʋɛɛ ta-labuiti ba, ta ti zuzo kɔluiti, ta ta-ɠaluiti. ");
INSERT INTO tod_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moize-o, Aalɔn ta ná-doun zunuiti-yo, ti ʋuuni seɠe ʋɛlɛ ɲadegai ɠakalaʋɛ, folo ɠulazu ʋelei, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Ti ɠɛni seizu ɲadegai ma wotii ɠɛɛzu Izilayɛle nuiti daaseigi zu. Zɔi nɔpɛ a la maaɓuɠana ná ʋa, ta naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Levi nuiti kpein, niiti Moizeni ta Aalɔn ti ti ɠaaluni, zunuiti, é zo alu gila ma, é lɛ zeemaazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ná-devei ɠɛni la, é lo pɛlɛyeɠeiti ba, ti ɠɛni ga zunu waaʋuufele maazu felegɔ (22.000). ");
INSERT INTO tod_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Doun zunu mɔungiti kpein gaalu Izilayɛle nuiti saama, é zo alu gila ma, é lɛ zeemaazu, è ti-laaseigiti sɛʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ɗa Levi nuiti fe bɛ̀, Izilayɛle nuiti ti-loun zunu mɔungiti potogi zu. Nà ga Ɠɔoɠɔ GALAGI. Levi nuiti ta-loganiiti ta ɠɛ ga nɔ̀nɔ, Izilayɛle nuiti ta-logani zinɛ mɔungiti potogi zu.» ");
INSERT INTO tod_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moize doun zunu mɔungiti kpein gaaluni Izilayɛle nuiti saama, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Doun zunu mɔungi kpein gaaluni, é zo alu gila ma, é lɛ zeemaazu. Ti-liegɔi ɠɛni ga waaʋuufele maazu fele unfele puulɔfela maazu saʋagɔ (22.273). ");
INSERT INTO tod_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Levi nuiti fe bɛ̀, Izilayɛle nuiti ti-loun zunu mɔungiti potogi zu, ta Levi nuiti ta-loganiiti, Izilayɛle nuiti ta-loganiiti potogi zu. Levi nuiti ta ɠɛ ga nɔ̀nɔ. Nà ga Ɠɔoɠɔ GALAGI. ");
INSERT INTO tod_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Izilayɛle nuiti ti-loun zunu mɔungiti, zunu unfele puulɔfela maazu saʋagɔ (273) unmɔɔ fai zu, nii daai ma, ti yɔɠɔzu ma ta Levi nuiti, ");
INSERT INTO tod_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","naa ɠa ga ɗa wali ɠae lɔɔludɔɔlu kula ti ɠilagilagi unmɔɔ fai zu. Wali ɠaei naa zoloo seizu ɲadegai ma walii ma, nii buɲɛgi ga galamu puugɔ. ");
INSERT INTO tod_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ɗa walii naa ve Aalɔn ta ná-doun zunuiti zea, ga naati unmɔɔ ganii, niiti ti-liegɔi a leʋe Levi nuiti tiegɔi ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moize unmɔɔgi ma walii zoni, é ɠula naati zea, niiti ti-liegɔi ɓudɛni Levi nuiti maazu, ti unmɔɔgai, ");
INSERT INTO tod_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","é walii zoni, é ɠula Izilayɛle nuiti ti-loun zunu mɔungiti zea, é ɠɛ ga wali ɠae waagila unsaʋa puulɔzita maazu lɔɔlugɔ (1.365), eɠɛʋelei seizu ɲadegai ma walii la. ");
INSERT INTO tod_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Moize unmɔɔgi ma walii veeni Aalɔn ta ná-doun zunuiti zea, é zoloo Ɠɔoɠɔ GALAGI ná-devei ma, eɠɛʋelei Ɠɔoɠɔ GALAGI Moize ɓɔɠɔi leveni la. ");
INSERT INTO tod_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Keɠate mavofodaiti gaalu, Levi ná-doun zunuiti saama, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, ");
INSERT INTO tod_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","«Keɠate mavofodaiti ta-wotii ʋɛtɛ, ta ɠɛ kɛɛzu GALA daaɠomi seɠe ʋɛlɛi wu: ada ɲadega wolai ma ɠasɔi ɠa ɠɛ ti unma. ");
INSERT INTO tod_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Siɛgi zu ta ɠɛ liizu la, ti zeɠe ti-ʋuuzuʋɛ, Aalɔn ta ná-doun zunuiti ta kwɛpele seɠezuɠoozagi ɠula, ti zeele woo ɠesui maavelevele la, ");
INSERT INTO tod_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ziɛ wu zua ɠɔlɔi ʋɛɛ ma, ti seɠe ɓiinii ʋɛɛ maazu, naa ʋolu ti kesui zeɠe wulu zɔkpɔiti to ba. ");
INSERT INTO tod_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«Ta seɠe ɓiinii ʋɛɛ taɓalii ma, nii ɓului laazu ga GALA bɛ, ti diɠiiti sei maazu, ta tazaiti, puya zalaɠai vaa zu, ta kokoiti, ta ziawɔiti. Ɓuluiti ti veai GALA bɛ, naati ta yɛ ná taɓalii ɠa. ");
INSERT INTO tod_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ta pɛɛmazeɠe ɓɔi sɔsɔgi ʋɛɛ ma aniiti ma, naa ʋolu ti ziɛ wu zua ɠɔlɔi velevele ti ma, naa ʋolu ti taɓalii zeɠe wulu zɔkpɔiti to ba. ");
INSERT INTO tod_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Ta seɠe ɓiinii zeɠe, ti felevele fitina zei anii ma, wozaɠala fai zu, ta ná-fitinaiti, ta ná-salaʋa zo sɔɔlaiti, ta ná-salaʋa zeɠe aniɲakaiti, ta ná-gulɔ aniɲakaiti, ná-botii ɠɛɛ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ta ti maavelevele, ta ná-sɔɔlaiti kpein, ziɛ wu zua ɠɔlɔi zu, ti ti la kasɔ zeɠe wului ma. ");
INSERT INTO tod_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Ta pɛɛmazeɠe ɓiinii ʋɛɛ zalaɠa ɠulazuʋɛ ma, nii zanugi ziɛni maaʋɛ, ti maavelevele ga ziɛ wu zua ɠɔlɔi, naa ʋolu ti seɠe wulu zɔkpɔiti to ba. ");
INSERT INTO tod_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ta aniɲakaiti kpein seɠe, niiti ti botii ɠɛɛzu ga tiye seizu ɲadegai zu, ti ti ʋu seɠe ɓiinii zu, ti ti maavelevele ga ziɛ wu zua ɠɔlɔi, naa ʋolu ti ti la kasɔ zeɠe wului ma. ");
INSERT INTO tod_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«Ta zalaɠa ɠulazuʋɛ ma yuʋui ɠula su, ti pɛɛmazeɠe ɓɔigi ʋɛɛ niina gaazu, ");
INSERT INTO tod_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","naa ɠa ti sɔɔlaiti kpein puuzu maazu, niiti ti ga ná-botiɠɛ aniiti: abu zeɠe aniiti, sua zɔɔ mitɛ wolaiti, pɛluiti, ta ɲama vaza aniɲakaiti. Naa ʋoluma ta ziɛ wu zua ɠɔlɔi ʋɛɛ ti pɛ maazu, ti seɠe wulu zɔkpɔiti to ba. ");
INSERT INTO tod_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Siɛgi zu Aalɔn ta ná-doun zunuiti ti ɓesu la ga seizu ɲadegai ta sɔɔlaiti maavelevele, ti lii ziɛgi zu, ti ʋa zeɠe ʋuuzuʋɛ, Keɠate ná-nuiti ta ʋa niina, ti ti zeɠe. Kɛlɛ ti mina yeevɔɔɠu ada ɲadegai ma anii ta ʋa, ti ʋa za. Keɠate mavofodaiti tosuʋɛ ɠana, GALA daaɠomi seɠe ʋɛlɛi ná-fai zu. ");
INSERT INTO tod_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Zalaɠa ɠula nui Aalɔn ná-doun zunui Eleazaal losuʋɛ ɠa ga, é ɗa wɛlɛ fitinai ná-gulɔi ma ta ansansegi, ta vebɛ zalaɠai é ɠulazu folo-o-folo, ta siɛma wulɔ ɲadegai. Toɠa seɠe ʋɛlɛ ɲadegai ma wɛlɛma vai kpein kɛ, ta bu anii kpein, ta seizu ɲadegai, é ʋɛɛ ma zɔɔlaiti kpein ba.» ");
INSERT INTO tod_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«À mina va bu ga Keɠate nuiti ta-wolodai ma ʋɛlɛyeɠeiti ma zuwu ɠaaleʋe Levi nuiti saama. ");
INSERT INTO tod_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Wɛlɛ pelegi maanɛai wo kɛ la ti ʋɛ, nii a kɛ ti zɛnvui wo, ti mina za: Siɛgi zu ti ʋaazu la ani ɲadegaiti pɔ bɛ, ɗɛi è ga Aalɔn, wa è-loun zunuiti, wa lɛ, wo ɛsɛ tosuʋɛ lɛɛ la, nii maanɛai é kɛ. ");
INSERT INTO tod_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Keɠate nuiti ti maa la nɛɛni, ti ʋa lɛ ada ɲadegai eyɛsu pɛ, naa ʋɛtɛ faa zu, anɛɛ yeeɠɛɠala go nɔ laawu, ti ʋa za.» ");
INSERT INTO tod_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gɛɛlɛson mavofodai ɠaalu, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti. ");
INSERT INTO tod_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Ɗa zunuiti kpein gaalu, é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Wɛlɛ nii ɠa é ɠɛɛzu ga Gɛɛlɛson nuiti ta-ʋɛlɛyeɠeiti tosuʋɛ, nii ta kɛ, ta nii ta seɠe: ");
INSERT INTO tod_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ta ɗa seɠe ʋɛlɛ ɲadegai ma landaiti seɠe, ta GALA daaɠomi seɠe ʋɛlɛi, ta ma ʋɛɛmazeɠeiti, ta ziɛ wu zua ɠɔlɔi é ʋɛɛzu ti maazu, ta kwɛpele seɠezuɠoozagi é GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ta koii ma zasai, nii é seɠe ʋɛlɛ ɲadegai ta zalaɠa ɠulazuʋɛ maaɠoolii zu, ta sasai laaʋɛ ma ɠwɛpele seɠezuɠoozagi, é ʋɛɛ ta-ɠaluiti ba, ta naama zɔɔlaiti kpein. Ta botii kpein kɛ, nii togai naa ʋa. ");
INSERT INTO tod_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gɛɛlɛson mavofodaiti ta ta-wotii kpein kɛ Aalɔn ta ná-doun zunuiti ta-levei wu, ti naama ɠasɔi zeɠe, nii maanɛai ti seɠe, ti ti-losuʋɛ laazeeli. ");
INSERT INTO tod_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pele ɠana Gɛɛlɛson nuiti ta-ʋɛlɛyeɠeiti ta-wotii a ɠɛ la, é lo GALA daaɠomi seɠe ʋɛlɛi vai ʋa. Ta kɛ, ti daazeeli zalaɠa ɠula nui Aalɔn ná-doun zunui Itamaal ná-devei wu. ");
INSERT INTO tod_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Ɗa Melali mavofodaiti gaalu ɓalaa, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti. ");
INSERT INTO tod_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Ɗa zunuiti kpein gaalu, é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","«Wɛlɛ, nii ɠa maanɛai ga ti ɗa seɠe, GALA daaɠomi seɠe ʋɛlɛi ma zɔɔlaiti su: seɠe ʋɛlɛ ɲadegai zuzo guluiti, ta ma wulu zɔkpɔiti, ta ma lɔkpalaiti, ta ma labuiti, ");
INSERT INTO tod_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ta tɔkpalaiti ti ɠɛni ga koii ma zasai, é ɠooli ma, é ʋɛɛ ta-labuiti ba, ta ti zuzo kɔluiti, ta ta-ɠaluiti, ta sɔɔlai nii kpein fizɔgai ti loda vai zu. Wa ɛsɛ ná-sɔɔla lɛɛ la, nii a ɠɛ seɠezu. ");
INSERT INTO tod_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Pele ɠana Melali nuiti ta-ʋɛlɛyeɠeiti ta-wotii a ɠɛ la, ta ti-losuʋɛ, é lo GALA daaɠomi seɠe ʋɛlɛi vai ʋa. Naa ɠa ta ɠɛ kɛɛzu Itamaal yeezu, nii é ga zalaɠa ɠula nui Aalɔn ná-doun zunui.» ");
INSERT INTO tod_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moize ta Aalɔn ta nuɓusɛiti ta-ɠundiɠiiti ti Keɠate mavofodaiti gaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, ");
INSERT INTO tod_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Nii gaaluni ta-wolodamaiti su, naa ɠɛni ga zunu waafelegɔ undɔfela puulɔɔlugɔ (2.750). ");
INSERT INTO tod_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Keɠate ná-bolodamaiti kana, ti ti ɠaaluni, nii kpein é ɠɛni botii ɠɛɛzu GALA daaɠomi seɠe ʋɛlɛi wu. Moize ta Aalɔn ti ti ɠaaluni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gɛɛlɛson mavofodaiti ti ɠaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, ");
INSERT INTO tod_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma, ");
INSERT INTO tod_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","nii gaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, naa ɠɛni ga zunu waafelegɔ undɔzita puusaʋagɔ (2.630). ");
INSERT INTO tod_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gɛɛlɛson ná-bolodamaiti kana, ti ti ɠaaluni, nii kpein é ɠɛni botii ɠɛɛzu GALA daaɠomi seɠe ʋɛlɛi wu. Moize ta Aalɔn ti ti ɠaaluni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la ti ya. ");
INSERT INTO tod_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Melali ná-bolodamaiti ti ɠaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, ");
INSERT INTO tod_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma, ");
INSERT INTO tod_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","nii gaaluni, eɠɛʋelei ta-wolodamaiti ti la, naa ɠɛni ga zunu waasaʋagɔ unfelegɔ (3.200). ");
INSERT INTO tod_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Melali ná-bolodamaiti kana, ti ti ɠaaluni. Moize ta Aalɔn ti ti ɠaaluni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Levi nuiti, Moize ta Aalɔn ta Izilayɛle nuiti ta-ɠundiɠiiti ti ti ɠaaluni, eɠɛʋelei ta-wolodamaiti ti la, ta ta-ʋɛlɛyeɠeiti, ");
INSERT INTO tod_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","é zo kona ʋuusaʋagɔ (30) ma, é li kona ʋuulɔɔlugɔ (50) ʋɔ, nii nɔpɛgi a zoloo GALA daaɠomi seɠe ʋɛlɛi ma wotii ta ɠɛɛ vai ma, ");
INSERT INTO tod_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ti-liegɔi ɠɛni ga zunu waadɔsaʋa undɔɔlugɔ puulɔsaʋa (8.580). ");
INSERT INTO tod_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Ɠɔoɠɔ GALAGI ɠa é devei veeni ga ti ti ɠaalu, Moize ɛsɛ ná-boti lɛɛni la, nii maanɛai é kɛ, ta kasɔi nii maanɛai é seɠe, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Devei ve Izilayɛle nuiti zea ga ti naati kpein kula ɓɔɠɔ zaama ti-ʋuuzuʋɛ, niiti ti ɠɔzɔai ga gee zeeɓɛi, ɓaa kalaɲa kolegi, ɓaa ti vɔɔɠuai poomai ta ʋa. ");
INSERT INTO tod_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","É ɠɛni ga zunu ɓaa anzanu, wa ti ɠula wo-ʋuuzuʋɛ ʋa, ti mina wo-ʋuuzuʋɛ ɠɔzɔ, ʋɛ gè zeini ná wo zaama.» ");
INSERT INTO tod_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Izilayɛle nuiti ti woozogi ɠɛɛni, ti naama nuiti kpein kulani ti-ʋuuzuʋɛ ʋa, ti li ná ʋoluʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Ni zunu ɓaa anzanu a ɓaaɠona nui ta ma, toɠa ɠɛ ga ladalala nu Ɠɔoɠɔ GALAGI letema, kɛni é leve ga sɔba nu. ");
INSERT INTO tod_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Toɠa laa zɔ ga ga kotoi é kɛai. Toɠa ma anii ɠaaɠale ma naa ʋɔ, nii é ɓaaɠogai ma, é kpɔ ba ga ma gaaɠwɛsu lɔɔlugɔi zeizu ɠilagi. ");
INSERT INTO tod_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ni nui nii kpaaɠomai wogai la, naa za, tama ná-pogani zeɠe nu la ná, nii faazuɓɛtɛi a wo zeezaama, aniiti kpein ta ve Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa ga zalaɠa ɠula nui ɠa ta ve zea, é ɓɔ baala sinɛi ʋa, é ga koto gba zalaɠai sɔba nui ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Vebɛani ɲadegai kpein Izilayɛle nuiti ta kula, faanɛɛ gelei nii a zeɠe ba, é ve zalaɠa ɠula nui ya, naa ɠa ɠɛ ga naa nɔnɔ. ");
INSERT INTO tod_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nii nui feezu Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa ve zalaɠa ɠula nui ya, nii nui a fe zalaɠa ɠula nui ya, naa nɔnɔ ɠana.» ");
INSERT INTO tod_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Wɛlɛ nii maanɛai wo kɛ, ni anzanui ta a sinigi yaavana, é ɠɛ bɛ ga ladalala nu. ");
INSERT INTO tod_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Ni zunu ɠili ka laana la, sinigi la ɠoleni ma, tɔɔzei é ɓɔɠɔ ɠɔzɔʋɛ dɔɔɠuzu, zeele la ná, a zeele woo wo daalɔɠɔma, tama é la zoni ná kɛɛzuʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","siɛgi zu tolo ɠigi ɠɛɛzu la sinigi ʋɛ, é zooʋi anzai ma, é ɠɛni ga ɠite vaa ɓaa zɛɛ, ");
INSERT INTO tod_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","toɠa ʋaa la zalaɠa ɠula nui ʋɔ bɛ, moloi nii é ga wɔɔlezegi, toɠa naama ɠɛzɛi kilo saʋagɔ zeɠe, é kɛ bɛ ga zalaɠai, é mina gulɔ ʋu ma, é mina ansanse pu ma, mazɔlɔɔ toɠa ga tolo zalaɠai, vebɛ zalaɠai nii é faaɠaaza golai ma vai loozu nu ɠisu. ");
INSERT INTO tod_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Zalaɠa ɠula nui ɠa maaɓuɠa ga anzanui seizu ɲadegai ʋa, é lo Ɠɔoɠɔ GALAGI ɠakala. ");
INSERT INTO tod_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Toɠa ziɛ ɲadegai zaɠa pɔlɔ liɠi zu, é seɠe ʋɛlɛ ɲadegai ma vufiligi yɛʋɛ, é pu su. ");
INSERT INTO tod_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Toɠa anzanui ɠaalɔ Ɠɔoɠɔ GALAGI ɠaazu, é nɔungi vie, é vebɛ zalaɠai ve zea, nii é ná-faaɠaazagi ma ɠizɛsui wosu, naa ɠa é ga tolo zalaɠai, kɛlɛ zalaɠa ɠula nui ɓɔɠɔi ɠa foovoo ɗɛ wanai zo ya. ");
INSERT INTO tod_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Toɠa ɠɛ anzanui ma: ‹Ɗa ɠonazu ga: Ni zunu ɠili ge la dɛ laani ga ɗe, è la dɛ ɓɔɠɔ ɠɔzɔni, è ʋa è-zinigi yaava, kaipa è zeini bɛ, naazu foovoo ɗɛ wanai nii mina faa ɲɔu nɔpɛ kɛ ga ɗe. ");
INSERT INTO tod_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Kɛlɛ tama, è zeiɗai ma zini bɛ, ni è è-zinigi yaava, è ɓɔɠɔ ɠɔzɔ, è la zunu ɠili koba, ");
INSERT INTO tod_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ɗa ɠonazu, è yeezei niima voovooiti bu: Ɠɔoɠɔ GALAGI è-ɓalaiti fɔ, é è-ɠogi lɛ da, eyɛsu ɗa-nuɓusɛiti ta ɠɛna foovoo loa, ti pokɔɠɔ è ma. ");
INSERT INTO tod_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Foovoo ɗɛi tɛi ge lɔ è ɠoozu, é è-ɠogi lɛ da, é è-ɓalaiti fɔ!› Anzanui ɠa gooɠaaʋote, é ɠɛ ma: ‹Ungo, é ɠɛ ɠana!› ");
INSERT INTO tod_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Zalaɠa ɠula nui ɠa foovoo vai niiti sɛʋɛ sɛʋɛi zu, é gba ziɛ wanai wu. ");
INSERT INTO tod_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Toɠa ziɛ wanai naa lo anzanui la, nii é ga foovoo ɗɛi, é kpɔle, é yei koozu. ");
INSERT INTO tod_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Aisa naa ʋa ɠɛ, zalaɠa ɠula nui ɠa tolo zalaɠai zeɠe anzanui ya, é datɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu, naa ʋolu é ʋaa la zalaɠa ɠulazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Zalaɠa ɠula nui ɠa zeeɲɛ gila seɠe ba, é makɛ ga ɠizɛsui, é gala, zalaɠa ɠulazuʋɛ, naa ʋoluma, é ziɛi ve anzanui ya, é kpɔle. ");
INSERT INTO tod_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ni gaama ʋe ga é ɓɔɠɔ ɠɔzɔʋɛ, é ɠɛ ga ladalala nui sinigi ʋɛ, foovoo ɗɛi ɠa yei koozuʋɛ, é naa wona, kogi lɛ da, kpalaiti ta vɔ, eyɛsu ná-nuɓusɛiti ta ɠɛna foovoo loa, ti pokɔɠɔ ma. ");
INSERT INTO tod_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kɛlɛ ni anzanui la ɓɔɠɔ ɠɔzɔni, ni ɲadegɛ, faa ɲɔu nɔpɛ ge la ɠɛa la, toɠa zoo é dounɠa zɔlɔɔ ʋolu. ");
INSERT INTO tod_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Naa ɠa é ga tɔgi é ʋilɛ tolo vai ʋa, siɛgi zu anzanui é zini bɛ, é sinigi yaavazu la, é ɓɔɠɔ ɠɔzɔ, ");
INSERT INTO tod_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ɓaa ni tolo yii a lɔɔna zunui ta yiima, é zooʋi anzai ma koloɠolo fai zu. Toɠa ɠula la Ɠɔoɠɔ GALAGI ɠakala. Zalaɠa ɠula nui ɠa naa ɠɛ, nii kpein sɛʋɛai tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Anzazinigi ɠa ɠɛ ga sɔbalala nu naazu, anzanui ná-faaɠaaza golai ma ɠasɔi ɠa la tɔ ɓɔɠɔi unma.» ");
INSERT INTO tod_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu zunui ta, ɓaa anzanui ta ɓɔɠɔ ɠalivaazu la Ɠɔoɠɔ GALAGI ʋɛ, é ɓɔɠɔ ɠalivaa minazeɠegi wo, ");
INSERT INTO tod_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","kɛni é ɓɔɠɔ zo, é mina dɔɔ ɓɔle, ɓaa kpɔɔle ani nɔpɛ a nu ɠaazulati, é mina dɔɔ laɓa ɓɔle, anɛɛ kpɔɔle ani laɓai ta ma zii nɔpɛ nii a nu zo, é mina leezɛin ma ɗɛi ta ɓɔle, é mina leezɛin ta mi, ma wundui ɓaa ma vɔɔi. ");
INSERT INTO tod_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Eyɛsu kalivaa ziɛgi ɓe, é mina leezɛin ʋaalobazuʋɛ tanɔpɛ mi, é zo ma ɠaei ma, é li ma ɠɔlɔ pɔ. ");
INSERT INTO tod_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","«Naama yeeɠɛɠalai kpein daawu, niiti kalivaai ti zu Ɠɔoɠɔ GALAGI ma, nɔungi mina wo, eyɛsu naama yeeɠɛɠalaiti daazeeli, toɠa ɲade niina, é nɔundeɠai ta kpɛlɛiti zɛ ná. ");
INSERT INTO tod_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","«Yeeɠɛɠalai kpein daawu, é deveai ga é ɓɔɠɔ ɠaliva Ɠɔoɠɔ GALAGI ma, é mina maaɓuɠa nu ʋooma ʋa. ");
INSERT INTO tod_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","É mina ɓɔɠɔ ɠɔzɔ tɔgi letemazu, kɛɛɠɛ ʋɛ, ɓaa dee, ɓaa kɛɛɠɛloun zunu ʋɛ, ɓaa baazeela ʋɛ, ni naa ta a zaana, mazɔlɔɔ ná-kalivaa vai GALA ma, naama ʋoogi ɠa unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kalivaa ziɛgi kpein daawu, toɠa ga nu ɲadegai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Ni nui ta a zaana koba kpaun, nɔungi é kalivaai, naa ɠɔzɔa, toɠa nɔungi wo ta kpɛlɛi, folo lɔfelasiɛi ma, ná-ɲade foloi. ");
INSERT INTO tod_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Foloi lɔsaʋasiɛi, toɠa li ga kpumago felegɔ ɓaa poopo kpokpa felegɔ zalaɠa ɠula nui ʋɔ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Zalaɠa ɠula nui ɠa gila kula ga koto gba zalaɠai, é zɔi ɠɛ ga gala zalaɠai, kotoi kɛai ga é yeevɔɔɠu poomai ʋa, naa gbaai ɠana. Naama voloi nɔ zu, toɠa nɔungi ɠaliva mɔnɔ ga niinɛ. ");
INSERT INTO tod_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Toɠa ɓɔɠɔ ɠaliva ʋolu ga niinɛ Ɠɔoɠɔ GALAGI ma, ná-kalivaa yeeɠɛɠalaiti faa zu é ɠɛa deveni. Toɠa kona gila baala sinɛi ɠula ga faazuɓɛtɛ zalaɠai. Foloiti ti leʋegai, é mina mɔ naati gaalu, tɔɔzei ná-kalivaa voloiti ti ɠɔzɔni. ");
INSERT INTO tod_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Tɔgi ʋɛtɛ é ʋilɛ ɓɔɠɔ ɠalivaa vai ʋa: Foloi ná-kalivaa vai ɓesu la, naama voloi ta ʋaa la GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Toɠa ná-zalaɠai ɠula Ɠɔoɠɔ GALAGI ʋɛ: kona gila baala sinɛ ɠila, nii nɛɛʋuzu la ba, naa ɠa ɠɛ ga gala zalaɠai, ta kona gila baala saa ɠila, nii nɛɛʋuzu la ba, naa ɠa ɠɛ ga koto gba zalaɠai, ta baala sinɛ wolai, nii nɛɛʋuzu la ba, naa ɠa ɠɛ ga ziilɛi zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Ɓului lɛʋɛ la su, toɠa ʋa ɓalaa ga naama ɓɔlɔgi: ɓului kpɛtɛai ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, ta ɓulu lɛɛvɛiti lɛʋɛ la su, gulɔi ʋuai ma, é ɓɔ ta-vebɛ zalaɠaiti ba, ta ta-ʋuya zalaɠaiti. ");
INSERT INTO tod_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Zalaɠa ɠula nui ɠa ʋa ga ti pɛ Ɠɔoɠɔ GALAGI ɠakala, é ná-koto gba zalaɠai ɠula, ta ná-gala zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Toɠa baala sinɛ wolai ɠula ga ziilɛi zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ta ɓului lɛʋɛ la su, naama ɓɔlɔgi, é kpɔ ná-vebɛ zalaɠai ʋa ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nui kalivaai, naa ɠa nɔungi wo, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Toɠa nɔundeɠai zeɠe ta kpɛlɛi, é ti ʋili abui ɠa, nii é ziilɛi zalaɠai wu. ");
INSERT INTO tod_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Zalaɠa ɠula nui ɠa baala sinɛ wolai ma ɓakigi zeɠe, nii giliai, ta ɓulu ɠila lɛʋɛ la su, ta ɓulu lɛɛvɛ ɠila lɛʋɛ la su, é fe nui naa ya, nii é ɓɔɠɔ ɠalivaai, naa a ɓena ga nɔungi wo. ");
INSERT INTO tod_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Naa ʋolu, zalaɠa ɠula nui ɠa ti latɛɠɛ vai ma ʋoogi ɠɛ Ɠɔoɠɔ GALAGI ɠaazu. Daamianigi naati ɲadegɛ, ta ɠɛ ga zalaɠa ɠula nui nɔnɔ, é ɓɔ ma ɠekegi ta ma ɓalai ʋa, niiti ti ɠula ga datɛɠɛ vai ma ʋoogi. Naa ɠɛa ʋoluma, nii é ɓɔɠɔ ɠalivaai, naa ɠa zoo é dɔɔi ɓɔle niina. ");
INSERT INTO tod_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Tɔgi ɠana é ʋilɛ naama nui ʋa, nii é ɓɔɠɔ ɠalivaazu, é minazeɠegi ɠɛai, nii maanɛai é kula ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ kalivaa vai zu, gaalu ge la naa ʋa, nii a ɠɛ ga faanɛɛi ma zobogi bɛ ga é kɛ. Toɠa kɛ eɠɛʋelei a minazeɠe la, é ɓɔ naa ʋa, nii tɔgi bogai, é ʋilɛ nui ɠalivaa vai ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Ɓɔɛ Aalɔn ta ná-doun zunuiti pɔ, è ɠɛ ti ma: ‹Wɛlɛ, ʋele ɠa wa ɠɛ tuya loozu la Izilayɛle nuiti bɛ, wa ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Ɠɔoɠɔ GALAGI tuya loo wo ʋɛ, é wo makɛ! ");
INSERT INTO tod_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ɠɔoɠɔ GALAGI yeezei wo wu ga pagɔ! É zaalai la wo ma! ");
INSERT INTO tod_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ɠɔoɠɔ GALAGI wɛlɛ wo ma! É ziilɛigi ve wo ʋɛ!› ");
INSERT INTO tod_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«Zekana ta wooɠula la mà, Izilayɛle nuiti ta-vaa zu, nɔ̀un nà, nà tuya loo ti ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Yeei Moize ɓeni da ga seɠe ʋɛlɛ ɲadegai lo, é gulɔ ɲadegai ziɛni ma, é fe GALA bɛ. É kɛɛni ɠana nɔ ga ma zɔɔlaiti, naa ʋɛɛ zalaɠa ɠulazuʋɛ ʋa, ta ma zɔɔlaiti. ");
INSERT INTO tod_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Pɛlɛyeɠe ɠundiɠiiti, ti ga bolodaiti ta-ɠundiɠiiti ti maaɓuɠani. Tɛiti ti loni gaalugi untuɠɔ. ");
INSERT INTO tod_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ti ʋaani ga vebɛaniiti Ɠɔoɠɔ GALAGI ʋɛ: wotolo lɔzita ti maazuʋɛai, ta nikɛ puugɔ maazu felegɔ (12), kundiɠi felegɔ wotolo ɠila, nikɛ ɠilagila. Ti ʋaani ga tiye seɠe ʋɛlɛ ɲadegai laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Ta-vebɛaniiti so. Wotoloi niiti, ta nikɛi niiti, ta lɔ GALA daaɠomi seɠe ʋɛlɛi ma wotii zu. Ɗa kaliva Levi nuiti ma, eɠɛʋelei ti ɠilagilagi ta-wotii ɓɛdɛma vai la.» ");
INSERT INTO tod_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moize yeezeini wotoloiti bu, ta nikɛiti, é ti ɠaaɠwɛ Levi nuiti ba. ");
INSERT INTO tod_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","É wotolo felegɔ zeɠeni, ta nikɛ naanigɔ, é fe Gɛɛlɛson ná-nuiti zea, eɠɛʋelei ta-wotii ɓɛdɛma vai ɠɛni la. ");
INSERT INTO tod_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","É wotolo naanigɔ ta nikɛ lɔsaʋa ve Melali ná-nuiti zea, tɔɔzei botii liegɔi ʋa, ti ɠɛni kɛɛzu Itamaal yeezu, zalaɠa ɠula nui Aalɔn ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","É la ɠɛni ta veeni Keɠate ná-nuiti zea, mazɔlɔɔ naati ka ani ɲadegaiti ma ɠasɔi ɠɛni ti unma, kɛni ti ɓena ti zeɠe ɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kundiɠiiti ti ʋaani ga ta-vebɛaniiti, voloi ti zalaɠa ɠulazuʋɛ veeni la GALA bɛ, ti daalao, ti gulɔ ɲadegai ziɛ ma. Kundiɠiiti ti ʋaani ga ta-vebɛaniiti zalaɠa ɠulazuʋɛ ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Názu ɠa Ɠɔoɠɔ GALAGI ɠɛni la Moize ma: «Kundiɠiiti ti ʋa ga ta-vebɛaniiti, ti ɠilagilagi pɛ, nu ɠila, folo ɠila, zalaɠa ɠulazuʋɛ laalao fai zu.» ");
INSERT INTO tod_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Folo mɔungi, Naason, Aminadaɓe ná-doun zunui ʋaani, é ná-vebɛanii lɛ. Naa ɠa é ɠɛni ga Zuda mavofodai nɔnɔi. ");
INSERT INTO tod_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","É ʋaani ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Aminadaɓe ná-doun zunui Naason ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Foloi velesiɛi, Netaneyɛle, Suaal ná-doun zunui, Isakaal mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Suaal ná-doun zunui Netaneyɛle ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Foloi zaʋasiɛi, Eliyaɓe, Ɠelon ná-doun zunui, Zaɓulɔn mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Ɠelon ná-doun zunui Eliyaɓe ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Foloi naanisiɛi, Elisuul, Sedeyuul ná-doun zunui, Luɓɛn mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Sedeyuul ná-doun zunui Elisuul ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Folo lɔɔlusiɛi, Selumiyɛle, Sulisadayi ná-doun zunui, Simiyɔn mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Sulisadayi ná-doun zunui Selumiyɛle ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Foloi lɔzitasiɛi, Eliasafe, Deyuwɛle ná-doun zunui, Gade mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Deyuwɛle ná-doun zunui Eliasafe ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Foloi lɔfelasiɛi, Elisama, Amiyude ná-doun zunui, Efelayime mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Amiyude ná-doun zunui Elisama ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Foloi lɔsaʋasiɛi, Gameliyɛle, Pedasuul ná-doun zunui, Manasé mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Pedasuul ná-doun zunui Gameliyɛle ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Foloi laaʋuusiɛi, Aɓidan, Gideyɔni ná-doun zunui, Ɓɛnzamɛn mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Gideyɔni ná-doun zunui Aɓidan ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Foloi ʋuusiɛi, Ayiyezɛɛl, Amisadayi ná-doun zunui, Dan mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Amisadayi ná-doun zunui Ayiyezɛɛl ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Folo puugɔ maazu ɠilasiɛi (11), Pagiyɛle, Wokelan ná-doun zunui Asɛɛl mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Wokelan ná-doun zunui Pagiyɛle ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Folo puugɔ maazu velesiɛi (12), Ayila, Enan ná-doun zunui, Nɛfɛtali mavofodaiti ta-ɠundiɠii ʋaani, é ná-vebɛanii lɛ. ");
INSERT INTO tod_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","É ɠɛni ga tazai, é ga walii, buɲɛgi ga kilo ɠila ta tukpɛ (1,5), ta koko ɠila, é ga walii, buɲɛgi ga galamu undɔsaʋa (800), eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi ɠɛni ɠɛɛzu la, ti felegɔ pɛ daavega ɠɛni de ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi, é ʋa ɠɛ ga vebɛ zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ta zanu aniɲaka ɠila, buɲɛgi ga galamu ungila puugɔ (110), daavegai ga ansansegi. ");
INSERT INTO tod_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","É ʋaani ɓalaa ga nikɛ zinɛ ɓokpa gila, ta baala sinɛ wola ɠila, ta kona gila baala sinɛ ɠila, gala zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ta boli zinɛ ɠila, koto gba zalaɠai vai zu, ");
INSERT INTO tod_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ta nikɛ felegɔ, ta baala sinɛ wola lɔɔlugɔ, ta boli zinɛ lɔɔlugɔ, ta kona gila baala sinɛ lɔɔlugɔ, ti ɠɛ ga ziilɛi zalaɠai. Enan ná-doun zunui Ayila ná-vebɛanii ɠɛni ga naa. ");
INSERT INTO tod_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Voloi ti zalaɠa ɠulazuʋɛ laalaoni la, ti gulɔ ɲadegai ziɛ ma, kundiɠiiti ta-vebɛaniiti ti ɠɛni ga: wali laza puugɔ maazu fele (12), wali ɠoko puugɔ maazu fele (12), zanu aniɲaka puugɔ maazu fele (12). ");
INSERT INTO tod_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Wali lazai ɠilagilagi wuɲɛgi ɠɛni ga kilo ɠila ta tukpɛ (1,5), wali ɠoko ɠilagilagi ɠɛni ga galamu undɔsaʋa (800), nii ti kulani, ti pɛ ge ɠɛni ga kilo ʋuufele maazu lɔfela ta tukpɛ (27,5) walii zu, eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi la. ");
INSERT INTO tod_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Zanu aniɲakai ɠilagilagi wuɲɛgi ɠɛni ga galamu ungila puugɔ (110), daavegai ga ansansegi, nii ti kulani, naa kpein ge ɠɛni ga galamu waagila unsaʋagɔ (1.300) zanugi zu, eɠɛʋelei seizu ɲadegai ma ɠɔɠɔgi la. ");
INSERT INTO tod_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Nii ti ʋaani la ga gala zalaɠai, naa ɠɛni ga: nikɛ zinɛ puugɔ maazu fele (12), baala sinɛ wola puugɔ maazu fele (12), kona gila baala sinɛ puugɔ maazu fele (12), é ʋɛɛ vebɛ zalaɠaiti ba, ti ɠɛni pɛɛzu ti ʋa. Ti ʋaani ɓalaa ga boli zinɛ puugɔ maazu fele (12), koto gba zalaɠai vai zu. ");
INSERT INTO tod_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ziilɛi zalaɠai ma vai zu, nii ti kulani, naa ɠɛni ga: nikɛ zinɛ ʋuufele maazu naanigɔ (24), baala sinɛ wola ʋuulɔzita (60), boli zinɛ ʋuulɔzita (60), ta kona gila baala sinɛ ʋuulɔzita (60). Vebɛaniiti kɛni ga naati, ti ɠulani zalaɠa ɠulazuʋɛ laalaosuʋɛ, ti ɓegai ma ga fe GALA bɛ, ti gulɔ ɲadegai ziɛ ma. ");
INSERT INTO tod_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Siɛgi zu Moize ɠɛni lɛɛzu la GALA daaɠomi seɠe ʋɛlɛi wu, ga é ʋa ɓɔɛ Ɠɔoɠɔ GALAGI ʋɔ, é ɠɛni wooi mɛnisu, é ɗa ɓɔɛ pɔ, é zeɠe kesui lakulugi maazuʋɛ seeluɓɛin felegɔiti zɔɠɔzuʋɛ, ti zeiɗai zeele woo ɠesui maazu. É ɠɛni ɓɔɛzu pɔ. ");
INSERT INTO tod_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Ɓɔɛ Aalɔn ʋɔ, è ɠɛ ma: Siɛgi zu è fitina lɔfelaiti seizu la ti-zeizuʋɛti, ɗa ti zei ga pagɔ, nii a kɛ ti-ma zezei ɗa ɠula fitina zei anii ɠakala, ʋelela ʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aalɔn kɛɛni ɠana. É fitinaiti seini, fitina zei anii ɠa ʋelela ʋelei, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Pɛtɛ ʋelei fitina zei anii ɓɛtɛni la, é ɠɛni ga zanu doɠai, é zo kɔɠɔi ma, é lɛ ma wulu ʋuaiti pɔ. Ti fitina zei anii ɓɛtɛni, é zoloo naama ɠazaʋigi ma, nii Ɠɔoɠɔ GALAGI dɛɛni ga Moize. ");
INSERT INTO tod_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Levi nuiti seɠe Izilayɛle nuiti saama, è ti ɲade. ");
INSERT INTO tod_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Wɛlɛ ʋelegi ɗa ti ɲade da. Ɗa ziɛi vaza ti ma, nii é ga ɲade ɗɛi, ti kpekai zeɠe, ti ti-ɓusɛi maaʋɛ pɛ bo da, ti ta-zeɠeiti gba. Tɔgi letemazu ti ɲadegai ɠana. ");
INSERT INTO tod_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ta nikɛ zinɛ ɓokpa gila seɠe, é ʋɛɛ vebɛ zalaɠai ʋa, nii soloogai ma, naa ɠa é ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi. Ɗɔun ɗa nikɛ zinɛ ɓokpagi velesiɛi zeɠe, é ɠɛ ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ɗa li ga Levi nuiti GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, è Izilayɛle nuɓusɛiti kpein toli. ");
INSERT INTO tod_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ɗa Levi nuiti maaɓuɠa Ɠɔoɠɔ GALAGI ʋa, Izilayɛle nuiti ti yeei la ti ma. ");
INSERT INTO tod_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aalɔn ɠa Levi nuiti fe nɔ̀un bɛ, Ɠɔoɠɔ GALAGI, Izilayɛle nuiti bɛ, ta lɔ niina nà-botii zu. ");
INSERT INTO tod_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levi nuiti ta yeei ʋɛɛ nikɛ zinɛ felegɔiti unmaʋɛ. Ɗa ti ɠula ga zalaɠai, gilagi ɠɛ ga koto gba zalaɠai, zɔi ɠɛ ga gala zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa a kɛ koto gba zalaɠai ɠula Levi nuiti bɛ, eɠɛʋelei tɔgi la. ");
INSERT INTO tod_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ɗa Levi nuiti to Aalɔn ta ná-doun zunuiti kakala, è ti ve Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Pele ɠana, ɗa Levi nuiti sei la yɛ, Izilayɛle nuiti saama, ta ɠɛ ga nɔ̀nɔiti. ");
INSERT INTO tod_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","É zo názu ma niina, ta lɔ botii zu, ti ɗa kɛ GALA daaɠomi seɠe ʋɛlɛi wu. «Maanɛɛʋɛ è Levi nuiti ɲade, è ti ve bɛ̀ ɠana. ");
INSERT INTO tod_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Mazɔlɔɔ ti veeʋɛ bɛ̀ ɲɛgɛlɛin Izilayɛle nuiti saama, ga Izilayɛle nuiti ti-loun zunu mɔungiti potogi. Gè Levi nuiti seɠeʋɛ ga nɔ̀nɔiti. ");
INSERT INTO tod_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mazɔlɔɔ doun zunu mɔungi kpein ka ga nɔ̀nɔ, Izilayɛle nuiti saama, nuiti ti-lointi, ta suaiti ti-ma yiʋoiti. Voloi gè doun zunu mɔungiti paani la Ezipete yooi zu, naama yeei ɠa gè ti makɛni la ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Gè Levi nuiti seɠeʋɛ, ga Izilayɛle nuiti ti-loun zunu mɔungiti potogi. ");
INSERT INTO tod_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Gè ti veeʋɛ Aalɔn ta ná-doun zunuiti bɛ Izilayɛle nuiti saama, ga ti Izilayɛle nuiti ta-wotii ɠɛ GALA daaɠomi seɠe ʋɛlɛi wu, ta botii ɠɛ ti ya, koto gba vai zu. Naazu faa ɲɔu la ɠɛa ga Izilayɛle nuiti, mazɔlɔɔ ti la maaɓuɠazu seizu ɲadegai ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moize ta Aalɔn, ta Izilayɛle nu ʋɛbɛi kpein, ti naa ɠɛɛni Levi nuiti ta-vaa zu, nii kpein Ɠɔoɠɔ GALAGI ma levei veeni Moize ya, é ʋilɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi nuiti ti ɓɔɠɔ ɲadeni, ti ta-zeɠeiti gba. Aalɔn ti veeni Ɠɔoɠɔ GALAGI ʋɛ, é tɔgi ma ɲade fai laazeeli koto gba vai zu ti ʋɛ, nii a kɛ ti ɲade. ");
INSERT INTO tod_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Naa ʋoluma, Levi nuiti ti lɔɔni botii zu, GALA daaɠomi seɠe ʋɛlɛi wu, Aalɔn ta ná-doun zunuiti zeezu. Ti kɛɛni ta-vaa zu, eɠɛʋelei nɔ Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Ɠɔoɠɔ GALAGI ɓɔɛni mɔnɔ Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Levi nuiti ti kona ʋuufelegɔ maazu lɔɔlugɔi (25) zɔlɔɔgai, eyɛsu é lɛ zeemaazu, ta lɔ botii zu, ti ɗa kɛ GALA daaɠomi seɠe ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Zɔi a kona ʋuulɔɔlugɔ (50) zɔlɔɔna, naa ná-botii ɠa ɠwɛ niina, é la mɔ botii ɠɛa. ");
INSERT INTO tod_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Toɠa zoo é ɗa ɓɔ kɛɛɠɛleaiti ba GALA daaɠomi seɠe ʋɛlɛi wu, naati ta-wotiiti su, kɛlɛ tɔ ɓɔɠɔi la mɔ botii ɠɛa. Pele ɠana ɗa Levi nuiti ta-boti vaiti so da.» ");
INSERT INTO tod_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Konagi velesiɛi ma alu mɔungi ma, ti ɠula ʋoluma Ezipete yooi ʋa, Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, Sinayi gizei ma leʋebai zu. É ɠɛni ma: ");
INSERT INTO tod_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Kɛni Izilayɛle nuiti ti Pake fɛtii ɠula ma ɠu logai ma. ");
INSERT INTO tod_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Wa ma vɛtii ɠula niima alugi ma volo puugɔ maazu naanisiɛi (14) ma, kpɔkɔi. Wa ma vɛtii ɠula, eɠɛʋelei nɔ deveiti ta tɔgiti feai la, é lo ba.» ");
INSERT INTO tod_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moize ɓɔɛni Izilayɛle nuiti pɔ ga ti Pake fɛtii ɠula. ");
INSERT INTO tod_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Ti ma vɛtii ɠulani Sinayi teʋebai zu, alu mɔungi ma volo puugɔ maazu naanisiɛi (14) ma, kpɔkɔi, ti kɛ nɔ kpein, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Nui tanigaani ti ɠɛni ná, ti la zooni ti ʋa Pake fɛtii ta ɠula, tɔɔzei ti ɓɔɠɔ ɠɔzɔni ga ti vɔɔɠu vai poomai ta ʋa. Ti liini ma volo ná nɔ Moize ʋɔ bɛ ta Aalɔn, ");
INSERT INTO tod_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ti ɠɛ ma: «Tɔgi maaʋele ma gi ɓɔɠɔ ɠɔzɔʋɛ, tɔɔzei gi vɔɔɠuʋɛ poomai ʋa. Leeni vaa zu gi maa la nɛɛni, gi ʋa ʋa ga gá-vebɛanii, gi ʋa fe Ɠɔoɠɔ GALAGI ʋɛ ʋɔɔma, gá Izilayɛle nui zɔiti, ma ɠu logai ma?» ");
INSERT INTO tod_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moize ɠɛni ti ma: «À maaɓɔun ʋɛ, gè li, gè woilo Ɠɔoɠɔ GALAGI wooi ma, nii é bosu wa-vaa zu.» ");
INSERT INTO tod_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Ni nui ta a ɠɛna ná wo zaama, niizu ɓaa yeeɠɛɠalaiti su ti ʋaazu, a ɓɔɠɔ ɠɔzɔna tɔgi letemazu, tɔɔzei fɔɔɠuʋɛ poomai ta ʋa, ɓaa é siɛ ma ɠoozama, toɠa zoo nɔ é Pake fɛtii ɠula Ɠɔoɠɔ GALAGI lɛbi vai ma. ");
INSERT INTO tod_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Alugi velesiɛi ma volo puugɔ maazu naanisiɛi (14) ma, kpɔkɔi ɠa ta Pake fɛtii ɠula la, ti baala ziʋoi mi, ta ɓului nii lɛʋɛ la su, ti pɛɛ tufa wanaiti ba. ");
INSERT INTO tod_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ti mina tanɔpɛ zɛ sobu ʋa zeeli, ti mina ma ɠaei tanɔpɛ gale. Ta ziɛ eɠɛʋelei deveiti ti la, é lo Pakegi ʋa. ");
INSERT INTO tod_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kɛlɛ zɔi nɔpɛ ɲadegai tɔgi letemazu, é la siɛ ma, é Pake fɛti vai ɠɛ ga faalakobai, naa ɓe ka leʋe ná-nuɓusɛiti ba, ná-faaɠaazagi ma ɠasɔi ɠa la unma, tɔɔzei é la ná-vebɛanii veeni Ɠɔoɠɔ GALAGI ʋɛ ma ɠui ma. ");
INSERT INTO tod_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ni wɛɛin ta ɠa zeini wo zaama, é pɔ é Ɠɔoɠɔ GALAGI ná-Pake fɛtii ɠula, toɠa ziɛ eɠɛʋelei Pakegi ma lɔgi la ta ma leveiti. Seikɔɠɔma nu ʋɛɛ zou nu ʋa, niima lɔ gila kpe nɔ ɠa a zei ti ma.» ");
INSERT INTO tod_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Voloi seɠe ʋɛlɛ ɲadegai ɠaalɔni da, nii zeele woo ɠesui ɠɛni bu, tonaɓiingi ʋɛɛni ma. Kpɔkɔi, eyɛsu sobui, é ɠɛni seɠe ʋɛlɛ ɲadegai ma eɠɛ abuzogi. ");
INSERT INTO tod_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","É ɠɛni ɠana nɔ yeenɔpɛ su: Foloi, tonaɓiingi ɠɛni ʋɛɛzu seɠe ʋɛlɛi ma, kpidii ma ziɛgi zu, é ɠɛni ɠulazu eɠɛ abuzogi. ");
INSERT INTO tod_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Siɛgi zu tonaɓiingi ɠɛni wuzeɠezu la, é zeɠe seɠe ʋɛlɛi maazu, názu ɠa Izilayɛle nuiti ti ɓena lii la, ʋɛ a la lona ná, ti ʋu miná. ");
INSERT INTO tod_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Ɠɔoɠɔ GALAGI ná-devei ɠa Izilayɛle nuiti ti ɓena zeɠe la ti-ʋuuzuʋɛ, a la ná-devei veena, ti ʋu mɔnɔ. Ni nɔ tonaɓiingi ɠa dɛ ʋɛɛni seɠe ʋɛlɛ ɲadegai ma, ti la ɠɛni zeɠezu ná. ");
INSERT INTO tod_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Anɛɛ tonaɓiingi a la lɛbi pa seɠe ʋɛlɛ ɲadegai maazu suɠooza, Izilayɛle nuiti ti ɠɛni ɠolozu Ɠɔoɠɔ GALAGI wooi ʋɛ, ti la ɠɛni liizu. ");
INSERT INTO tod_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tanisu tonaɓiingi ɠɛni foloi tanigaani nɔ ɠɛɛzu seɠe ʋɛlɛ ɲadegai maazuʋɛ, siɛnɔpɛ su, ti ɠɛni nɔ Ɠɔoɠɔ GALAGI ná-devei maaɓɔunsu, ti ʋa ʋu ti-ʋuuzuʋɛ, ɓaa ti ʋa wuzeɠe ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Tanisu ɓalaa tonaɓiingi ɓena yɛ adaʋɛ ta nɔ kpɔkɔi eyɛsu geelaalao, ɓaa é kɛ nɔ ga folo ɠila, kpidi ɠila, é ɓena wuzeɠe nɔ feya, Izilayɛle nuiti ti wuzeɠe ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ni a la yɛna seɠe ʋɛlɛ ɲadegai ma, é kɛ ga folo felegɔ, ɓaa alu gila, ɓaa é wola lɛbi suɠooza, Izilayɛle nuiti ti la ɠɛni ti-ʋuuzuʋɛ valibosu, eyɛsu tonaɓiingi wuzeɠe. ");
INSERT INTO tod_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ɠɔoɠɔ GALAGI ɓena devei ve pɛ, Izilayɛle nuiti ti ʋa ʋu ti-ʋuuzuʋɛ, ɓaa ti ʋa wuzeɠe ti-ʋuuzuʋɛ. Ti ɠɛni ti-losuʋɛti kpein kɛɛzu, ti ɠolo Ɠɔoɠɔ GALAGI ná-deveiti bɛ, eɠɛʋelei é devei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Puʋu felegɔ ɓɛtɛ ga wali loɠai. Ta ɠɛ è ya, è ɗa bɛbɛi loli da, é ɠɛ ga poogi nuiti bɛ siɛ wo fai zu, wa ɠɛna zeɠea wo-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ta puʋu felegɔiti fɛɛna ʋɔɔma, bɛbɛi kpein ka maaɓɔ è ʋɔ bɛ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ni ta puʋu gilagi nɔ vɛɛna, Izilayɛle ɠundiɠiiti, bolodama ɠundiɠiiti nɔ ɠa, ta maaɓɔ è ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Siɛgi zu wo fɛɛzu la ga goo ɠaaɓaingai, niiti ti ʋuuni folo ɠulazu ʋelei, naati ta wuzeɠe, ti siɛi lɔɔzei. ");
INSERT INTO tod_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Siɛgi zu wo fɛɛzu la ga goo ɠaaɓaingai, ná zeizu velesiɛi, niiti ti ʋuuni nu yeezazu ʋelei, naati ta wuzeɠe, ti siɛi lɔɔzei. Puʋu goo ɠaaɓaingai ɠa ɠɛ ga siɛ wo fai ma ʋoogi. ");
INSERT INTO tod_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Wa ɗa fɛ ɓalaa bɛbɛi loli fai ma, kɛlɛ názu wo la puʋugi vɛa ga goo ɠaa ʋa ɓain. ");
INSERT INTO tod_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Zalaɠa ɠula nuiti ti ga Aalɔn mavofodaiti, naati gila nɔ ɠa ta ɗa puʋugiti fɛ. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Siɛgi zu wa ɠɛna la wa-yooi zu, wa ɠɛna lia kɔɔmaʋɛ wo zili nuiti daalɔɠɔma, ti laalɛ wo wu, wa puʋugi vɛ, wo goo ɠaaɓain, naazu nà ɠizɛ wo zu, nɛ̀i gè ga Ɠɔoɠɔ GALAGI wa-ƓALAGI. Nà wo unmɔɔ, gè wo ɠula wo zili nuiti zea. ");
INSERT INTO tod_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Wa puʋugi vɛ, wa-ɠoozunɛ voloiti, ta wa-volo wolaiti, ta alugi ma volo mɔungiti, siɛgi zu wo gala zalaɠaiti kulazu la, ta ziilɛi zalaɠaiti. Toɠa ɠɛ ga zaɓui, wa-ƓALAGI ɠizɛ wo zu. Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Konagi velesiɛi, ma alugi velesiɛi ma volo ʋuufelegɔi (20) ma, tonaɓiingi zeɠeni seɠe ʋɛlɛ ɲadegai maazu, nii zeele woo ɠesui ɠɛni bu. ");
INSERT INTO tod_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Izilayɛle nuiti ti zeɠeni Sinayi teʋebai zu, ti li, eɠɛʋelei devei veeni la, é ʋilɛ ta-ziɛ vai ʋa. Tonaɓiingi loni Palan teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ma mɔun ge ɠɛni ga nii ti ʋa zeɠe ti-ʋuuzuʋɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ná-devei ɠɛni la, nii ti sɔlɔɔni Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Nu ɓulugi nii gaalɛai ba Zuda ná-poogi wu, naa ɠa mɔunpa é ʋilɛni pelei ma. Zuda mavofodaiti ta-nu ɓulugiti ti ɠɛni Aminadaɓe ná-doun zunui Naason ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isakaal mavofodaiti ta-nu ɓulugi ɠɛni Suaal ná-doun zunui Netaneyɛle ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zaɓulɔn mavofodaiti ta-nu ɓulugi ɠɛni Ɠelon ná-doun zunui Eliyaɓe ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Naa ʋoluma, ti seɠe ʋɛlɛ ɲadegai ɠulakulani ba, Gɛɛlɛson mavofodaiti ta Melali mavofodaiti ti seɠe, ti ʋilɛ pelei ma. ");
INSERT INTO tod_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Naa ʋolu, nu ɓulugi nii gaalɛai ba Luɓɛn ná-poogi wu, naa ʋilɛni pelei ma. Luɓɛn mavofodaiti ta-nu ɓulugi ɠɛni Sedeyuul ná-doun zunui Elisuul ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simiyɔn mavofodaiti ta-nu ɓulugi ɠɛni Sulisadayi ná-doun zunui mavofodai Selumiyɛle ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gade mavofodaiti ta-nu ɓulugi ɠɛni Deyuwɛle ná-doun zunui Eliasafe ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Naa ʋolu, Keɠate mavofodaiti ti ada ɲadegai ma zɔɔlaiti seɠeni, ti ʋilɛ pelei ma. Levi nui zɔiti ti ɠɛni seɠe ʋɛlɛ ɲadegai ʋɛɛpɛɛzu ba, ti to, aisa Keɠate nuiti ti ʋa ʋa. ");
INSERT INTO tod_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Naa ʋolu, nu ɓulugi nii gaalɛai ba Efelayime ná-poogi wu, naa ʋilɛni pelei ma. Efelayime mavofodaiti ta-nu ɓulugi ɠɛni Amiyude ná-doun zunui Elisama ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasé mavofodaiti ta-nu ɓulugi ɠɛni Pedasuul ná-doun zunui Gameliyɛle ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Ɓɛnzamɛn mavofodaiti ta-nu ɓulugi ɠɛni Gideyɔni ná-doun zunui Aɓidan ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Naa ʋolu, nu ɓulugi nii gaalɛai ba Dan ná-poogi wu, naa ɠɛni ga ʋoluzui, é ʋilɛ pelei ma. Dan mavofodaiti ta-nu ɓulugi ɠɛni Amisadayi ná-doun zunui Ayiyezɛɛl ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asɛɛl mavofodaiti ta-nu ɓulugi ɠɛni Wokelan ná-doun zunui Pagiyɛle ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Nɛfɛtali mavofodaiti ta-nu ɓulugi ɠɛni Enan ná-doun zunui Ayila ná-deveiti bu. ");
INSERT INTO tod_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Izilayɛle nuiti ta-nu ɓulugiti ta-zeikpasui ɠɛni ga ná, siɛgi zu ta la ɠɛna siɛi woga da, ti ʋa zeɠe ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moize ɠɛni nɛkoi, Madiyan nui Leyuwɛle ná-doun zunui Woɓaɓe ma: «Gá ga li zooi naa zu, nii Ɠɔoɠɔ GALAGI minazeɠeni la gi ʋɛ, ga toɠa fe gi ʋɛ. Ʋa, ade li, ɗa ɠɛ gaanɛ zu, mazɔlɔɔ Ɠɔoɠɔ GALAGI minazeɠeni ga toɠa faa ʋagɔ ɠɛ Izilayɛle ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Woɓaɓe ɠɛni ma: «Gè la ʋilɛsu è ʋolu. Zìimai ɠa ga gè ɠale ma nà-zooi zu, nà-nuɓusɛiti pɔ bɛ.» ");
INSERT INTO tod_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moize ɠilini ma, é ɠɛ ma: «Nà è maanɛɛnɛzu, mina zeɠe gi ʋolu, mazɔlɔɔ è teʋebai nii zuɠwɛɛ gola, ta adaʋɛti gá zoo gi ʋu ná, ɗa ɠɛ gi ʋɛ ga totuɠɔi. ");
INSERT INTO tod_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ni ɗa gi maazaana, ɗa ɗɔnɔ zɔlɔɔ naama ani ʋagɔiti kpein su, nii Ɠɔoɠɔ GALAGI ʋaazu ti veezu gi ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Izilayɛle nuiti ti liini, ti zeɠe Ɠɔoɠɔ GALAGI ná-gizei ma, ti folo saʋagɔ ziɛi woni. Naama volo saʋagɔiti daawu, Ɠɔoɠɔ GALAGI ná-minazeɠe kesui ɠɛni loni ti luɠɔ, é ɗa ada ɠaiziɛ ti ʋɛ, ʋɛ ta looɠo ná. ");
INSERT INTO tod_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Siɛgi zu ta la zeɠena la ti-ʋuuzuʋɛ, Ɠɔoɠɔ GALAGI ná-tonaɓiingi ɠɛni zɛlɛsu ti maazu foloi. ");
INSERT INTO tod_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Minazeɠe kesui lii la ɠilagila, Moize ɠɛni GALA falii ɠɛɛzu, é ɗa ɠɛ ma: «Wuzeɠe Ɠɔoɠɔ GALAGI, è zili nuiti ti vaza, niiti ti è wɔinzeɠezu, naati ti ʋela è ʋa!» ");
INSERT INTO tod_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Siɛgi zu ta la zeina la, é ɠɛni ɠɛɛzu ma: «Ʋa ʋolu Ɠɔoɠɔ GALAGI, ɗa-nuɓusɛ ɓulu mɔinmɔingiti saama, ti ga Izilayɛle nuiti!» ");
INSERT INTO tod_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Foloi ta, nuɓusɛiti ti unsuyelii loni, ti daazeeli Ɠɔoɠɔ GALAGI ma. Siɛgi zu Ɠɔoɠɔ GALAGI naa mɛnini da, é yiiɠaawanani. Ɠɔoɠɔ GALAGI ná-abui soni ti-ʋuuzuʋɛ, é naa ɠobaʋɛ ɠala. ");
INSERT INTO tod_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Nuɓusɛiti ti wooɠulani Moize ma, naa Ɠɔoɠɔ GALAGI maanɛɛnɛ, abui za. ");
INSERT INTO tod_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ti naama adaʋɛ laasei pɛɛni ga Taɓeyela (nii poluʋɛ ga «ada ɠalai»), mazɔlɔɔ ná ɠa Ɠɔoɠɔ GALAGI ná-abui soni ná ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nu ɠiligiti ti ɠɛni ga wɛɛinti Izilayɛle nuiti saama, naati ti-yiimaʋɛ laaveni ga gaazuɠulapɔ vaiti. Názu ɠa Izilayɛle nuiti ti tɔɔzeini la ga kpeei loa, ti ɗa ɠɛ ma: «Ni gá la zoo gi ɗa sua zɔlɔɔ, gi mi! ");
INSERT INTO tod_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Gá ɠitoozu kalei zu, gi ɠɛni miizu Ezipete yooi zu, geya la ba, ta kilikamaiti, ta pasetɛkegiti, ta yaʋa laa kpaazagiti, ta yaʋa ɓaazagiti, ta yaʋa ʋɛlɛʋɛlɛgiti! ");
INSERT INTO tod_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Niizu gá ga ɠaɲa. Gi ʋalagɛ anii kpein ma, kɛni nɔ manegi, yeenɔpɛ nɔ manegi!» ");
INSERT INTO tod_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manegi ma ɠazaʋigi ɠɛni eɠɛ kɔliandelegi ma ɠaei, gaazuʋɛ ɠɛ eɠɛ gulu mana maku nɛɛnɛgi, daaseigi ga ɓedɛliwume. ");
INSERT INTO tod_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Nuɓusɛiti ti ɓena ɠula, ti vaza, ti ɗa zɛʋɛ, ti ɗa golowolo ga daamiani siɠa ɠɔtui, ɓaa ti siɠa kodai zu, ti gili diɠii zu, ti kɛ ga ɓulu ʋɛlɛʋɛlɛgi. Ná-nɛɛi ɠɛai eɠɛ ɓulu ʋɛlɛʋɛlɛgi gulɔi ba. ");
INSERT INTO tod_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","É ɠɛni ʋuuzu kpidii ti-ʋuuzuʋɛ, ta nɔɗai. ");
INSERT INTO tod_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Pɛlɛyeɠei ɠilagilagi ʋuuni ná-seɠe ɠotai laaʋɛ, é ɗa kpeei loo. Moize nuɓusɛiti gooi mɛnini, ti ɗa wɔlɔ. Ɠɔoɠɔ GALAGI wola yiiɠaawanani. Moize wola ɠaazuɠilini. ");
INSERT INTO tod_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","É ɠɛni Ɠɔoɠɔ GALAGI ma: «Lee vaa ɲɔu ɠa è kɛɛzu ga ze, nɛ̀i gè ga ɗa-wotiɠɛ nui? Lee vaa zu gè la zaalai zɔlɔɔni è ɠaazu? Ɗa zoo ɠale è niima nuɓusɛiti kpein ta-ɠasɔi la nɔ̀un unma? ");
INSERT INTO tod_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nà ɠa gè niima nuɓusɛiti kpein sɔlɔɔga ɓaa? Nà ɠa gè ti ʋilɛga etea ɓaa, è ɠɛɛzu mà: ‹Ti ʋɛɛ yiila, eɠɛʋelei doun deei a ɗa ná-ɲiimiɓɔlegi zo la,› gè naa ɠɛ eyɛsu gi zeeli naama yooi zu, nii è ma minazeɠe boni ti-mɛmɛwolani bɛ, ga ɗa feezu ti ya? ");
INSERT INTO tod_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mini ɠa nà suai zɔlɔɔna, gè ʋa gaaɠwɛ niima nuɓusɛiti kpein ba, ti wɔlɔzu kòba, ti ɗa ɠɛ ma: ‹Suai ve gi ya, gi mi!› ");
INSERT INTO tod_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Gè la zooga, nà ɠila ko, gè ʋa niima nuɓusɛiti kpein ta-ɠasɔi zeɠe. Gola wuiʋɛ mà! ");
INSERT INTO tod_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ni ɗa pɔ è zaalai la mà, zɛ̀nvui zeɠe, aisa è ʋa sò ɠani, gè mina nà-maanɔɠɔi ɠa!» ");
INSERT INTO tod_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Zunu ʋuulɔfela (70) ɠaalɛ ba bɛ̀, è ti ɠula Izilayɛle ɠundiɠiiti saama, zunui niiti è ti ɠwɛɛ ga ta ga sɔɓelama nua, nuɓusɛiti ta-ɠundiɠiiti. Ʋa ga tiye GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, wo lo ná ʋɔɔma, wa tiye. ");
INSERT INTO tod_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nà yeizu ná, gè ɓɔɛ è ʋɔ, nà ta zeɠe zɛnvui naa ʋa, nii é è ʋa, gè fe ti ya, naa ɠa a kɛ, wo niima nuɓusɛiti ta-ɠasɔi zeɠe ʋɔɔma, ɗa ɠila è mina mɔ seɠe. ");
INSERT INTO tod_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ɗa ɠɛ nuɓusɛiti ma: ‹À ɓɔɠɔ ɲade lina voloi vaa zu, wa ʋaazu suai miizu, tɔɔzei wo wɔlɔʋɛ Ɠɔoɠɔ GALAGI woizu ga: Ee, ni gá la zoo gi sua mi! Gi ɠɛa gaanɛ zu Ezipete yooi zu! Naa ɠa é ba, Ɠɔoɠɔ GALAGI ɠa ʋaazu suai veezu wo ya, wo mi. ");
INSERT INTO tod_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Wa ʋaazu miizu ɠɔ, é la nɔ ga folo ɠila faa, ɓaa folo felegɔ, ɓaa folo lɔɔlugɔ, ɓaa folo puugɔ, ɓaa folo ʋuufelegɔ (20). ");
INSERT INTO tod_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Kɛlɛ wa yɛsu miizu eyɛsu alu gila, eyɛsu é ɠula wo-zokpai zu, unpili wɔin ɗa wo zo. Mazɔlɔɔ wo Ɠɔoɠɔ GALAGI ʋɛlɛʋiliga, nii é wo zaama, wo wɔlɔa gaazu, wo ɠɛ ma: Leeni vaa zu deɠɛmu gi zeɠeai Ezipete yooi zu?› » ");
INSERT INTO tod_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moize gooɠaaʋoteni, é ɠɛ ma: «Niima nuɓusɛiti gè ti zaama, gá ga zunu waaundɔzita (600.000), è minazeɠe naati bɛ ga ta suai mi alu gila daawu ɲɛgɛlɛin! ");
INSERT INTO tod_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ta baalagiti paa ti ʋɛ, ta nikɛiti, é ʋa kula ɠɛ ti ʋa? Anɛɛ ni nu ɠa kpoloɗɛi wu ɠaleiti kpein kpɛɛzu ti ʋɛ, toɠa kula ɠɛ nɛi?» ");
INSERT INTO tod_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Ɠɔoɠɔ GALAGI gooɠaaʋoteni, é ɠɛ ma: «Ɠɔoɠɔ GALAGI yee ɠa wola ɓuɠa ɓaa? Su la mɔ ɠoozani, ɗa naa ɠa, ni ɠite ʋe, ɓaa zɛɛ ʋe, ga ni nii nà bo, toɠa ɗa ʋilɛ su.» ");
INSERT INTO tod_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moize ɠulani, é Ɠɔoɠɔ GALAGI laawooi wo nuɓusɛiti ma. Naa ʋolu, é zunu ʋuulɔfelaiti (70) gaalɛɛni ba, ta-ɠundiɠiiti saama, é ti lo seɠe ʋɛlɛi maaɠoolii zu. ");
INSERT INTO tod_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ɠɔoɠɔ GALAGI yeini tonaɓiingi zu, é ɓɔɛ pɔ. Zɛnvui nii é ɠɛni Moize ʋa, é ta zeɠeni naa ʋa, é fe kundiɠi ʋuulɔfelaiti (70) zea. Siɛgi zu zɛnvui yeini la ti ma, ti tɔɔzeini ga ɓɔɛa eɠɛ GALA goo wo nua, kɛlɛ ti la ɠɛni lɛbini ga. ");
INSERT INTO tod_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Zɛnvui yeini ɓalaa zunu felegɔ ma ti-ʋuuzuʋɛ, gilagi laaseigi ɠɛni ga Eledade, zɔi laaseigi ɠɛ ga Medade. Zɛnvui yeini ti ma, mazɔlɔɔ ti-laaseigi zɛʋɛni zunu ʋuulɔfelaiti (70) saama, kɛlɛ ti la ɠɛni zeɠeni ti-ʋuuzuʋɛ, ti ʋa li seɠe ʋɛlɛi ʋɔ bɛ. Ti tɔɔzeini ga ɓɔɛa eɠɛ GALA goo wo nua. ");
INSERT INTO tod_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Zunu loungoi ta ɓizɛni, é li, é bo Moize ma, é ɠɛ ma: «Eledade ta Medade ta GALA ná-kulakɛlɛma vaiti bosu ade-ʋuuzuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nun ná-doun zunui Zozuwe, nii é ɠɛni ga Moize ná-kpɔba nui, é zo ná-doungo ziɛgi zu ma, naa ɠɛni ma: «Màliɠii, Moize, pele leʋe ti luɠɔ, ti ɓe naa ɠɛɛzu!» ");
INSERT INTO tod_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moize ɠɛni ma: «Ɗa mà lolo ɠulazu? Ɠɔoɠɔ GALAGI ná-Zɛnvui yei Izilayɛle nuɓusɛiti pɛ ma, ti ɠɛ ga GALA goo wo nuiti!» ");
INSERT INTO tod_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Moize ta Izilayɛle ɠundiɠiiti ti ɠaleni ma ti-ʋuuzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ɠɔoɠɔ GALAGI fiilɛi leʋeni kpoloɗɛi ɠa, é ʋa ga kakalogiti, ti ʋu ti-ʋuuzuʋɛ maaɠoolii zu, é ɠaku ná ma ga folo ɠila siɛ liegɔ. Ti zooi maaɓidini, eyɛsu é lɛ ga mɛtɛlɛ ɠila sɔligɔ. ");
INSERT INTO tod_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Nuɓusɛiti ti loni ɠɔɠɔma naama voloi, ta ma ɓidii kpein, ta mɔnɔ poluma voloi ɲɛgɛlɛin, ti ɗa kakalogiti so. Nu nɔpɛ ge la ɠɛni seɠeni, é ʋa yei kilo waasaʋagɔ (3.000) zeeɠɔɠɔwu. Ti ti zuvieni, ti ɗa fɔ ti-ʋuuzuʋɛ maaɠoolii kpein su. ");
INSERT INTO tod_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Suai naa yɛni nɔ ti-laaʋɛ, ti la dɛ numani, eyɛsu Ɠɔoɠɔ GALAGI yiiɠaawana ti ma, é maanɔɠɔi ʋɛɛ nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Ti naama adaʋɛ laaseigi ʋɛɛni ga Kiɓelɔte-Ɠataava (nii poluʋɛ ga «gaazuɠulapɔ ɠabayeɠeiti»), mazɔlɔɔ miná ɠa ti naati ma mɔinmɔin maaɠuluni ná, niiti daamii vai ma ɠaazuɠulapɔi ti zoni. ");
INSERT INTO tod_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Nuɓusɛiti ti siɛi lɔɔzeini, ti zeɠe Kiɓelɔte-Ɠataava, ti ʋa Ɠaselɔte, ti ʋu miná. ");
INSERT INTO tod_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moize Kuse anzanui ta zeɠeni ga anza. Miliyame ta Aalɔn ti ɠɛni vaazu ma. ");
INSERT INTO tod_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ti ɠɛni ma: «Moize ɠila nɔ lɛi Ɠɔoɠɔ GALAGI ɓɔɛai pɔ! Kpɔɛʋɛ gá ɓalaagi gi ʋɔ!» Ɠɔoɠɔ GALAGI ti-wooi mɛnini. ");
INSERT INTO tod_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Tama Moize ɠɛni ga ɓɔɠɔmaayei nu gola, é leʋe nui pɛ ba eteai zu. ");
INSERT INTO tod_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Gaamago nɔ, Ɠɔoɠɔ GALAGI Moize lolini, naa ʋɛɛ Aalɔn ʋa, ta Miliyame, é ɠɛ ti ma: «À ɠomi, wo saʋagɔ, GALA daaɠomi seɠe ʋɛlɛi ʋɔ bɛ.» Ti liini ná. ");
INSERT INTO tod_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ɠɔoɠɔ GALAGI yeini tonaɓiingi zu, é lo seɠe ʋɛlɛi laaʋɛ maazuʋɛ. É Aalɔn ta Miliyameni tolini. Ti felegɔ ti ʋaani. ");
INSERT INTO tod_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","É ɠɛni ti ma: «À woilo, nii é bɛ̀, gè bo wo ma! Siɛgi zu GALA goo wo nu a ɠɛna la wo zaama, nà, Ɠɔoɠɔ GALAGI, nà ɗa ɓɔɠɔ lɛɛ la kulakɛlɛmai zu, gè ɓɔɛ pɔ segi zu. ");
INSERT INTO tod_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Kɛlɛ é la ɠana ga nà-botiɠɛ nui Moize, nii é ga lada nui nà-pɛlɛwu vai kpein su. ");
INSERT INTO tod_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nà ɗa ɓɔɛ pɔ ga wooi koleai, faa zuɓidi laade, gè ɓɔɠɔ lɛɛ la, é kà. Lee vaa zu wo la luani, wo ɗa va nà-botiɠɛ nui Moize ma?» ");
INSERT INTO tod_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ɠɔoɠɔ GALAGI yiiɠaawanani ti laalɔɠɔma, é li. ");
INSERT INTO tod_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Tonaɓiingi zeɠeni nɔ feya seɠe ʋɛlɛi maazuʋɛ, geei ʋɛɛ Miliyame ma mɛɛ, koleai eɠɛ kobe kolegi. Aalɔn wɛlɛni ba, é ka ga é ɠɛa ga gee nu. ");
INSERT INTO tod_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aalɔn ɠɛni Moize ma: «Soma màliɠii, è mina gá-ɠotoi ma ɠasɔi la gi unma, gi kɛai ɠimalalai zu! ");
INSERT INTO tod_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ee, de-ʋaazeelai mina ɠɛ eɠɛ doin saai, é ʋa zɔlɔɔ, nii kpusɛi ta luulaai, aisa é ʋa zɔlɔɔ.» ");
INSERT INTO tod_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moize wooɠulani Ɠɔoɠɔ GALAGI ma, é ɠɛ ma: «Ee, GALA, nà è maanɛɛnɛzu, kɛdɛ!» ");
INSERT INTO tod_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ni kɛɛɠɛ a la ɠɛni laaɗɛi ʋuuni gaazuʋɛ, é la ɓena yɛ ma unfegi zu, eyɛsu folo lɔfela? À kpɛ, é ɠula wo-ʋuuzuʋɛ ʋa, é kɛ su ga folo lɔfela, naa ʋoluma, wa yeezei bu niina, é ʋa wo zaama.» ");
INSERT INTO tod_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miliyame ɠulani ti-ʋuuzuʋɛ ʋa, é kɛ ga folo lɔfela. Nuɓusɛiti ti yɛni ti-ʋuuzuʋɛ, eyɛsu é ʋa, é lɔ ti zaama mɔnɔ. ");
INSERT INTO tod_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Naa ʋoluma, ti zeɠeni Ɠaselɔte, ti li, ti ʋu Palan teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Zunuiti teʋe, ti Kanaan yooi zuʋɛtɛ, gè feezu Izilayɛle nuiti bɛ. Yeelo nu ɠila ba, bolodai ɠilagilagi zu, seɠeai kundiɠiiti saama.» ");
INSERT INTO tod_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moize Ɠɔoɠɔ GALAGI wooi zoni, é zunuiti teʋeni, ti zeɠe Palan teʋebai zu. Izilayɛle nuiti ta-ɠundiɠiiti ti ɠɛni ga tiye. ");
INSERT INTO tod_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ti-laaseigiti ti ɠɛni ga: Luɓɛn ná-bolodai nɔnɔi ɠɛni ga: Samua, Zakuul ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simiyɔn ná-bolodai nɔnɔi ɠɛni ga: Safate, Woli ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Zuda ná-bolodai nɔnɔi ɠɛni ga: Kalɛɓe, Yefuné ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isakaal ná-bolodai nɔnɔi ɠɛni ga: Yigale, Zozɛfe ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efelayime ná-bolodai nɔnɔi ɠɛni ga: Wozé, Nun ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Ɓɛnzamɛn ná-bolodai nɔnɔi ɠɛni ga: Palati, Lafu ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zaɓulɔn ná-bolodai nɔnɔi ɠɛni ga: Gadiyɛle, Sodi ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Zozɛfe ná-bolodai nii é ga Manasé nɔnɔi, naa ɠɛni ga: Gadi, Susi ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan ná-bolodai nɔnɔi ɠɛni ga: Amiyɛle, Gemali ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asɛɛl ná-bolodai nɔnɔi ɠɛni ga: Setuul, Mikayɛle ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nɛfɛtali ná-bolodai nɔnɔi ɠɛni ga: Naaɓi, Vɔfesi ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gade ná-bolodai nɔnɔi ɠɛni ga: Geyuwɛle, Maki ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Zunuiti daaseigiti kana, niiti Moize ti leʋeni ga ti Kanaan yooi zuʋɛtɛ. Moize Nun ná-doun zunui Wozé laasei pɛɛni ga Zozuwe. ");
INSERT INTO tod_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moize ti leʋegai ma ga ti Kanaan yooi zuʋɛtɛ, é ɠɛni ti ma: «À leʋe ga lɛkpɛmaʋɛ nu yeezazuʋɛ yooi zu ʋele, wo zeeli gize yooi ʋɔ pelei, ");
INSERT INTO tod_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","wo ɠida zooi ná-fai wu. Wo ka ʋelei é la, ta nuiti ti zeini ná, wo ti ʋɛtɛ ni ti zulogɛ, ɓaa ni zɛbɛ la ti ya, ni ti mɔinʋɛ, ɓaa ni ti la mɔinni. ");
INSERT INTO tod_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Wo zooi ʋɛtɛ, ʋɛ ti zeini ná, ni pagɛ, ɓaa ni ɲɔuʋɛ, ta-laa wolaiti ta ɠale, ni siɠigi ɠa ti ma, ɓaa ni é la ti ma, ");
INSERT INTO tod_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ani ɓɛtɛ you ʋe, ɓaa ani la ɓɛtɛa ga, gulua ta ga, ɓaa ti la ná? À yiilɔɔ! À zooi zu wulu waai tanigaa zeɠe.» É ɠɛni ga leezɛn waa mɔungi ma yeeɠɛɠalai. ");
INSERT INTO tod_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Zunui naati ti liini, ti zooi zuʋɛtɛ, é tɔɔzei Sin teʋebai zu eyɛsu Leɠɔɓe, Leɓo-Ɠamate ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ti lɛɛni lɛkpɛmaʋɛ nu yeezazuʋɛ yooi zu, ti zeeli Eɓelɔn. Ayiman ta Sesayi ta Talamayi nuiti ti zeini ná, Anake mavofodaiti. Eɓelɔn laai loni, é kɛ ga kona dɔfela aisa Soan ʋa lo, nii é Ezipete yooi zu. ");
INSERT INTO tod_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ti zeeliai ma Esekɔle nɛmɛi zu, ti leezɛn ansaɠɔgi ma ɓeke gila teʋeni ba, nii leezɛn ɠɔpɔgi ɠɛni zɛlɛni ba. Bui ʋelei ma, ti dɔɔni gului ɠa, nu felegɔ da ɠɔma, ti seɠe. Ti gelenade wului ma waaiti seɠeni ɓalaa, ta kooleɠoolegiti. ");
INSERT INTO tod_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ti naama adaʋɛ laasei pɛɛni ga Esekɔle nɛmɛi (nii poluʋɛ ga «anii ɠɔpɔgi ma nɛmɛi»), tɔɔzei leezɛn ɠɔpɔgi ʋa, Izilayɛle nuiti ti teʋeni ná. ");
INSERT INTO tod_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ti ɠaleni ma, ti zeɠe zooi ʋɛtɛsuʋɛ, folo ʋuunaanigɔ (40) ɠa ti kɛɛni. ");
INSERT INTO tod_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ti ʋaani, ti Moize ɠa, ta Aalɔn, ta Izilayɛle ʋɛbɛi kpein, Palan teʋebai zu Kadɛse. Ti ʋoluvaawo ti ma ga nii kpein ti kaani, ti zooi zu wulu waaiti dɛɛ ga tiye. ");
INSERT INTO tod_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wɛlɛ poluvaawo gooi ʋa, ti boni Moize ma: «Gi zeelini zooi naa zu, ʋɛ è gi leʋeni ná. Gaamazu, zou ʋe, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná, naa wulu waaiti pɛtɛ. ");
INSERT INTO tod_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Kɛlɛ-o, nuiti ti zeini ná, ti wola zuɓaaʋɛ. Taaiti bɔɔlɔʋɛ, siɠigi ti ma. Gi Anake mavofodaiti ɓalaa pɛtɛgɛ ná. ");
INSERT INTO tod_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalɛke nuiti ta zeini nu yeezazu ʋelei. Ɠɛte nuiti, ta Yeɓuse nuiti, ta Amool nuiti ta zeini gize yooi zu. Kanaan nuiti ta zeini Kpoloɗɛ Wolai laaʋɛ, ta Zuludɛn nɛmɛi zu.» ");
INSERT INTO tod_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Názu ɠa Kalɛɓe ɠaaɓaani la ga é nuɓusɛiti gaaɓɛ, niiti ti tɔɔzeini niina ga wuzeɠea Moize laalɔɠɔma. É ɠɛni ti ma: «Ade li ná! Ada vɔni zooi ma, de seɠe. Mazɔlɔɔ ma ɠaaɓaai ɠa ade ya.» ");
INSERT INTO tod_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kɛlɛ zunuiti ti ɠɛni ga ná-siɛpoluiti, naati ti ɠɛni ɠɛɛzu ma: «Ma zobo ge la ade ʋɛ, de ʋa laalɛ nuuma nuɓusɛiti bu, mazɔlɔɔ ti zuɓaaʋɛ de ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ti tɔɔzeini Izilayɛle nuiti gaazu ga zooi naa ná-fai zuvalaga, nii ti liini ti ka, ti ɠɛni ma: «Zooi nii gi suɓizaai, gi suʋɛtɛ, toɠa ga zooi nii é naati paazu, niiti ti ʋaazu, ti zei ga. Nuiti kpein gi ti ɠaai ná, ta ga nu ɠoozagiti. ");
INSERT INTO tod_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Gi kooza nuiti kaaʋɛ ná ɓalaa, Anake mavofodaiti, nu ɠoozagiti ma zuwuzui. Gi ɠɛa ti ɠoba, é ɠɛ gi ɠaazu, eɠɛ gá ɠɛ ga kotogiti nɔ, tiya ɓalaa, ti ɠaazu, gi ɠɛni eɠɛ kotogaa nɔ!» ");
INSERT INTO tod_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Izilayɛle nuɓusɛiti kpein ti kpeei looni, ti ɲii wɔlɔzu naama ɓidii. ");
INSERT INTO tod_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ti unsuyelii loni Moize ta Aalɔn laalɔɠɔma. Nuɓusɛiti kpein ti ɠɛni ti ma: «Ni suɠila gi zaani Ezipete yooi zu, ɓaa teʋebai zu! ");
INSERT INTO tod_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Leeni vaa zu Ɠɔoɠɔ GALAGI pɔ ga é ʋa ga giye niima yooi zu, ti ʋa gi ʋaa ga kɔɔi, gi-anzaiti, ta gi-lointi, ti ʋa ɠɛ ga gi zili nuiti daamianigi? É la ɠɛa gi ʋɛ ga faa ʋagɔ ɓaa, ga gi ɠale ma Ezipete yooi zu?» ");
INSERT INTO tod_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ti ɠilagilagiti ti ɠɛni ɠɛɛzu ɓɔɠɔ ma: «Ade yeelo kundiɠi ɠila ba, de ɠale ma Ezipete yooi zu!» ");
INSERT INTO tod_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moize ta Aalɔn ti looni zooi ma, ti laaʋɛɛ Izilayɛle nuɓusɛiti kpein gaazu, ti ɠaalɛai ba. ");
INSERT INTO tod_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Zozuwe, Nun ná-doun zunui, ta Kalɛɓe, Yefuné ná-doun zunui, nu felegɔi naati, ti ɠɛni zɔiti ba, tɛiti ti liini zooi zuʋɛtɛsu, ti felegɔ ti ta-zeɠeiti balini ga kidaaʋiligi maaʋele ma, ");
INSERT INTO tod_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ti ɠɛ Izilayɛle nuɓusɛiti kpein ma: «Zooi nii gi suɓizaai, gi suʋɛtɛ, toɠa ga zou ʋagɔ wola. ");
INSERT INTO tod_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ni Ɠɔoɠɔ GALAGI ɠa ade ʋɛ, toɠa ade lɔ zooi naa zu, é fe de ʋɛ, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná. ");
INSERT INTO tod_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Toɠa nɔ ga, à mina wuzeɠe Ɠɔoɠɔ GALAGI laalɔɠɔma. À mina lua zooi naa zu nuiti ba, mazɔlɔɔ ta ɠɛɛzu nɔ ga ade-ɠɔnɔ, niinigi é ɠɛa ti makɛsu, naa maaɠooza ti ʋa, tama Ɠɔoɠɔ GALAGI ɠa ade ʋa. Deɠɛmu, à mina lua ti ʋa pa!» ");
INSERT INTO tod_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Nuɓusɛiti kpein ti ɠɛni ɠɛɛzu, ti ti zɔɔ ga kɔtui, ti ti ʋaa, kɛlɛ gaamanɔ Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani kɛlɛma Izilayɛle nuiti bɛ GALA daaɠomi seɠe ʋɛlɛi maazu. ");
INSERT INTO tod_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Niima nuɓusɛiti ta yɛsu bɛ̀lɛʋilisu eyɛsu siɛgi ɓɛgele zu? Ta yɛsu ɠɛlɛzu ga ti mina la dà, eyɛsu siɛgi ɓɛgele zu? Anɛɛ gè poo gola mɔinmɔin kɛa ti zaama. ");
INSERT INTO tod_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Nà ɗɔfɔ zeeɓɛi ʋɛɛzu ti ʋa, gè ti-ma zuwu ɠaaleʋe, naa ʋolu nà zii ɓɛtɛzu, é ɠula è zu, nii sɛbɛi a wɔɔlɔ, ta é mɔin Izilayɛle ʋa!» ");
INSERT INTO tod_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moize Ɠɔoɠɔ GALAGI wooɠaaʋoteni, é ɠɛ ma: «Ezipete nuiti ti kwɛɛ ga ɗa ɠa è niima nuɓusɛiti kula ta-yooi ʋa ga è-zɛbɛi. ");
INSERT INTO tod_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Ti bogɛ niima you zu nuiti kpein ma. Ti mɛnigɛ ga ɗa, Ɠɔoɠɔ GALAGI, ɗa niima nuɓusɛiti saama, ɗa ɓɔɠɔ lɛɛzu kpezekele. Ti mɛnigɛ ga ɗa-lonaɓiingi ɠa zɛlɛni ti maazu, ɗa losu ti luɠɔ foloi tonaɓiingi zu, ta kpidii abuzogi zu. ");
INSERT INTO tod_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ni ɗa niima nuɓusɛi kpein paana eɠɛ nu ɠila, zooiti ti è-ɠɛɛ vaiti ma woomɛniga, è ti ɠɛai, naati ta ʋaazu ɠɛɛzu ma: ");
INSERT INTO tod_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Ɠɔoɠɔ GALAGI la ɓena zobo sɔlɔɔ, é ʋa li ga nuɓusɛi tɛiti zooi naa zu, nii é ma ɠona woni ga é fe ti ya, naa ɠa é kɛai é ti ʋaa teʋebai zu.› ");
INSERT INTO tod_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Niizu Màliɠii, nà è maanɛɛnɛzu, ɗa-zobogi ɠula kɛlɛma ga zɛbɛi pɛ, eɠɛʋelei è boni la gi ma ga: ");
INSERT INTO tod_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Ɠɔoɠɔ GALAGI yii la ɗa ga ɠula fala, kpɛtɛʋɛ wooɠɛɠiladai zu, toɠa ɗa faaɠaaza golai zuvaayɛ ta tɔ koloɠologi. Kɛlɛ é la ɗa ga sɔba nui levea ga sɔbalala nu, toɠa doun kɛɛɠɛiti ta-vaa ɲɔi ʋotokula ti-lointi ma, eyɛsu yamani zaʋasiɛi ɓaa naanisiɛi.› ");
INSERT INTO tod_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Nà è maanɛɛnɛzu, niima nuɓusɛiti suvaayɛ ga ta-vaaɠaaza golai, ɗa-wooɠɛɠiladai maaʋele ma, eɠɛʋelei nɔ è niima nuɓusɛiti suvaayɛsu da, è zo ti ɠula voloi ma Ezipete yooi ʋa, é zeeli za ma.» ");
INSERT INTO tod_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ɠɔoɠɔ GALAGI ɠɛni ma: «Gè ti maavaayɛga, eɠɛʋelei è falia la. ");
INSERT INTO tod_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Kɛlɛ eɠɛʋelei gè vulua la ga ɠite, nɛ̀i gè ga Ɠɔoɠɔ GALAGI, nà-lɛbiyai eteai pɛ daavegai, gè ɠonaa ga: ");
INSERT INTO tod_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Nui niiti ti nà-lɛbiyai ɠaani, ta poo golaiti gè ti ɠɛɛni Ezipete yooi zu, ta teʋebai zu, ti sùɠɔɠɔ daa ɠɛa puu, ti la ɠoloni bɛ̀, ");
INSERT INTO tod_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ti taɠila kpalaa ge la zooi naa ɠaa, nii gè ma minazeɠe boni, gè ɠona su ti-mɛmɛwolani bɛ. Tɛiti kpein ti bɛ̀lɛʋiligai, taɠila kpalaa ge la lɛa ná. ");
INSERT INTO tod_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Kɛlɛ nà-botiɠɛ nui Kalɛɓe, ɠi kili ka é ɠɛni naa ʋɛ, kɛɛʋɛ bɛ̀ ga wooɠɛɠila nu eyɛsu ɠɔ. Naa ɠa é ba, nà lɛ ga naa, ma yooi zu, ʋɛ é liini ná, mavofodaiti ta naa zɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Tɛi Amalɛke nuiti ta Kanaan nuiti ti zeini nɛmɛi zu, lina sobu nɔ, wa nuiti gaaɠalesu ma teʋebai zu, wo li ga Seeli Kpoloɗɛi ʋɔ pelei.» ");
INSERT INTO tod_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: ");
INSERT INTO tod_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Nà niima nuɓusɛ ɲɔiti zɛsu ná, ti ɗa unsuyelii lo dàalɔɠɔma, eyɛsu yeelɛ? Mazɔlɔɔ gè Izilayɛle nuiti ta-unsuyeliiti mɛnigɛ, ti tosu dàalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ɠɛ ti ma: ‹Eɠɛʋelei gè vulua la ga ɠite, nà wo zosu, eɠɛʋelei wo wooiti bogai la gòizu, Ɠɔoɠɔ GALAGI wooi ɠana. ");
INSERT INTO tod_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Wa za teʋebai tɛi su, wo-ma ʋoomaiti ti la ná. Wɔiti dɔin ti wo ɠaaluni, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, mazɔlɔɔ wo unsuyelii logɛ dàalɔɠɔma, ");
INSERT INTO tod_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","wo la mɔ lɔa zooi naa zu, nii gè ma minazeɠegi woni, gè ɠona ga wa zei ga, kɛni Kalɛɓe, Yefuné ná-doun zunui, ta Zozuwe, Nun ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Kɛlɛ wo-lointi, wo ɠɛni ɠɛɛzu ma ta ɠɛ ga wo zili nuiti daamiani, nà liizu ga tiye ma yooi zu, ta zooi naa ɠwɛɛ, nii wo bɛlɛʋiligai. ");
INSERT INTO tod_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kɛlɛ wɔun, wa zaazu teʋebai tɛi su. ");
INSERT INTO tod_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Wo-lointi ta ɠɛɛzu ga teʋeteʋe nuiti, kona ʋuunaanigɔ (40) laawu. Ta wa-wooʋaladai ma zalai zɔlɔɔ ɠana, nii wo kɛa ga ze, eyɛsu wo pɛ wo za teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Folo ʋuunaanigɔ (40) ɠa wo kɛɛni zooi zuʋɛtɛsuʋɛ, tama, wa wa-vaaɠaaza golai ma zalai zɔlɔɔ kona ʋuunaanigɔ (40) laawu, kona gila, folo ɠilagi ʋotogi zu. Wa kwɛɛ naazu ga wa ɠɛlɛna bà, wa ɓala.› ");
INSERT INTO tod_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nà, Ɠɔoɠɔ GALAGI, nà ɠa kpɔ̀ɛai. Ungo, zekana gè ʋaazu niima nuɓusɛ ɲɔiti sosu da, ti ɠiliai ʋa, ti wuzeɠe dàalɔɠɔma. Ta ɲɛɛlɛzu teʋebai tɛi su, ti za ná.» ");
INSERT INTO tod_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Zunuiti Moize ti leʋeni ga ti zooi zuʋɛtɛ, ti ɠalegai ma ma, ti nuɓusɛiti unsuleʋeni, ti unsuyelii lo daalɔɠɔma, ga zooi zu vaiti suvala pelei. ");
INSERT INTO tod_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ɠɔoɠɔ GALAGI zunui naati doɠani, ti za, tɔɔzei ti zooi ná-fai zuvalani. ");
INSERT INTO tod_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Zunuiti ti liini zooi zuʋɛtɛsu, ti pɛ ti zaani, kɛni Zozuwe, Nun ná-doun zunui, ta Kalɛɓe, Yefuné ná-doun zunui, naati nɔ ɠa ti yɛni vulua. ");
INSERT INTO tod_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Siɛgi zu Moize Ɠɔoɠɔ GALAGI laawooi woni da Izilayɛle nuiti ma, nuɓusɛiti gola ɠaalɛini. ");
INSERT INTO tod_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Poluma zobui, ti wuzeɠeni ga sobuzobui, ti lɛ gize yooi ʋɔ pelei, ti ɠɛ ma: «Gi koto ɠɛa, kɛlɛ gá ga lɛ, ʋɛ Ɠɔoɠɔ GALAGI ɓɔɛai, é ʋilɛ ná ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moize ɠɛni ti ma: «Leeni vaa zu wo zeɠezu Ɠɔoɠɔ GALAGI wooi ʋolu? Wo la zobo sɔlɔɔga! ");
INSERT INTO tod_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","À mina lɛ, mazɔlɔɔ Ɠɔoɠɔ GALAGI la wo zaama. Wo zili nuiti ti mina wo ʋaa fuun. ");
INSERT INTO tod_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Mazɔlɔɔ wa Amalɛke nuiti kaazu luɠɔ, ta Kanaan nuiti, wa ɓɔɠɔ ʋaa. Ʋelei wo ʋoluavegai da Ɠɔoɠɔ GALAGI ʋa, é la mɔ ɠɛa wo ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ti daani mɛɛ, kɛni ti lɛɛni gize yooi ʋɔ pelei, kɛlɛ Ɠɔoɠɔ GALAGI ná-minazeɠe kesui la ɠɛni liini, ta Moize ɓalaa, ti ʋa ɠula ti-ʋuuzuʋɛ ʋa. ");
INSERT INTO tod_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Amalɛke nuiti ta Kanaan nuiti ti ɠɛni ʋuuni gize yooi zu, naati ti yeini, ti Izilayɛle nuiti sakpe, ti ti ɠoloɠolo, ti ʋilɛ ti ʋolu, eyɛsu ti li, ʋɛ ná laaseigi ga Ɠɔɔlema. ");
INSERT INTO tod_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo zeelizu la zooi naa zu, gè ʋaazu feezu wo ʋɛ ga wo zei ná, ");
INSERT INTO tod_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","wa ɠɛna pɔ wo zalaɠaiti kula Ɠɔoɠɔ GALAGI ʋɛ, nii abui galazu, gala zalaɠai, ɓaa minazeɠe daazeeli zalaɠai, ɓaa vebɛanii nui daai ɠisu, ɓaa zalaɠai nii é ʋilɛsu wa-ƓALA fai ma vɛti voloi ta ʋa, wa kɛ ga nikɛi, ɓaa baalagi, ɓaa bolii, nii é ɠalazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Wa vebɛ zalaɠaiti kpɔ zalaɠa zua ɠilagilagi pɛ ba. Wa ɓulu vukɔ ʋagɔi kilo saʋagɔ ɓɔ ba, gaayɔgai ga gulɔi litɛlɛ ɠila ta tukpɛ (1,5), ");
INSERT INTO tod_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ta puya zalaɠai ɠɛ ga dɔɔi litɛlɛ ɠila ta tukpɛ (1,5), ni zalaɠa zuai ɠa ga baala ziʋoi. ");
INSERT INTO tod_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ni baala sinɛ wolai ʋe, wa vebɛ zalaɠai ɠɛ ga ɓulu vukɔ ʋagɔi kilo lɔzita, gaayɔgai ga gulɔi litɛlɛ felegɔ, ");
INSERT INTO tod_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ta puya zalaɠai ɠɛ ga dɔɔi litɛlɛ felegɔ. Naama zalaɠaiti makugi ɠa nɛɛ Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ni nikɛ zinɛi ɠa wo kulazu ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, é ɠɛ ga gala zalaɠai, ɓaa minazeɠe daazeeli zalaɠai, ɓaa é ɠɛ ga ziilɛi zalaɠai, ");
INSERT INTO tod_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","wa ɓulu vukɔ ʋagɔi kilo taaʋuugɔ ɓɔ ba ga vebɛ zalaɠai, gaayɔgai ga gulɔi litɛlɛ saʋagɔ, ");
INSERT INTO tod_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ta puya zalaɠai ɠɛ ga dɔɔi litɛlɛ saʋagɔ. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Pele ɠana wo maanɛai wo nikɛ zinɛ zalaɠai ɠula la, ɓaa baala sinɛi, ɓaa baala sinɛ yiʋoi, ɓaa boli yiʋoi. ");
INSERT INTO tod_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Toganii mɔin ʋa ʋele-o-ʋele, vebɛanii ɠa ʋɛɛ ti ɠilagilagi ʋa. ");
INSERT INTO tod_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Izilayɛle nu ɓɔɔɓɔgi kpein maanɛɛʋɛ é naama lɔgi zo, a ɠɛna zalaɠai ɠulaa, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Tɔ gilagi naa nɔ ɠa a zei nuɓusɛi pɛ ma, ga faa ɠila nɔ anɛɛ wɛɛin é ga seikɔɠɔma nui, ɓaa ná-pɛlɛyeɠei wo zaama wo-mavofodaiti kpein su, ni ta pɔ ti zalaɠa ɠula, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Nuɓusɛi pɛ ka tɔgi naa zo, ga faa ɠila nɔ toɠa la ɛsɛ gilagilagi pɛ ma, Izilayɛle nu ʋɛɛ seikɔɠɔma nu ʋa. Naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ, ta seikɔɠɔma nui, Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Tɔ gilagi, ta deve ɠilagi nɔ ɠa a ɠɛ ná wo pɛ bɛ, wa seikɔɠɔma nui.» ");
INSERT INTO tod_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo zeelizu la zooi zu, ʋɛ gè losu wo luɠɔ, wo li ná, ");
INSERT INTO tod_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","wo ma you zu ɓului miizu, wa gilazu zeɠe ba ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Siɛgi zu wo ɓului mɔsu da, wa ma mɔungi zeɠe ba, wo kula bɛ̀ ga zalaɠai, eɠɛʋelei wa ɗa molo niinɛi nɔnɔi zeɠe ba la. ");
INSERT INTO tod_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Vebɛanii ɠana, wa fe Ɠɔoɠɔ GALAGI ʋɛ, é ɠula wa-vuului ná-botii ɠɛa mɔungi zu, wo-mavofodaiti kpein su. ");
INSERT INTO tod_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Ni wa koto ɠɛɛna, wo la gaaɠilini ma, wo la tɔgi niiti kpein soni, niiti Ɠɔoɠɔ GALAGI ti veai Moize ya, ");
INSERT INTO tod_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","é zo naama voloi ma Ɠɔoɠɔ GALAGI deveiti feeni la, eyɛsu é li wo-mavofodaiti pɔ ʋelela ʋelei, ");
INSERT INTO tod_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ni faaɠaazagi a ɠɛɛna, é la ɠɛɛni ga gaaɠilima, é ɠɛ ga nuɓusɛiti kwɛɛtala zu vaa, nuɓusɛi kpein ka nikɛ zinɛ ɓokpa gila kula ga gala zalaɠai, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ, é ɓɔ vebɛ zalaɠai ʋa, ta puya zalaɠai, eɠɛʋelei deveai la tɔgi zu, ta boli zinɛi, nii a ɠɛ ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Zalaɠa ɠula nui ɠa kotoi gba Izilayɛle nuɓusɛiti kpein bɛ, suvaa ɠa yɛ ti ʋɛ, tɔɔzei faaɠaazagi ʋe, ti kɛai, ti la gaaɠilini ma. Siɛgi zu ti ʋaazu la ga ta-zalaɠai, nii abui galazu, Ɠɔoɠɔ GALAGI ʋɛ, ta koto gba zalaɠai Ɠɔoɠɔ GALAGI ɠaazu, tɔɔzei ta-vaaɠaazagi vaa ʋa, ti kɛai, ti la gaaɠilini ma, ");
INSERT INTO tod_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","suvaa ɠa yɛ Izilayɛle nuɓusɛiti kpein bɛ, ta seikɔɠɔma nuiti, mazɔlɔɔ nuɓusɛiti ti naama vaaɠaazagi ɠɛɛʋɛ, ti la gaaɠilini ma. ");
INSERT INTO tod_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Ni nu ɠila kpe nɔ ʋe, é kotoi ɠɛai, é la gaaɠilini ma, toɠa kona gila boli zaai ɠula ga koto gba zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Zalaɠa ɠula nui ɠa kotoi gba Ɠɔoɠɔ GALAGI ɠaazu, nui naa ʋɛ, nii é kotoi ɠɛai, é la gaaɠilini ma. Siɛgi zu é kotoi gbazu la bɛ, naa zuvaa ɠa yɛ bɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Siɛgi zu nu a koto ɠɛɛna la, nii é la gaaɠilini ma, tɔ gilagi nii nɔ ɠa a zei nui pɛ ma, Izilayɛle nuiti ti ga zou lointi, ta seikɔɠɔma nuiti. ");
INSERT INTO tod_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«Kɛlɛ nu-o-nu, nii a gaaɠili ma, é kotoi ɠɛ, Izilayɛle nui, é ga zou loin, ɓaa seikɔɠɔma nui, é Ɠɔoɠɔ GALAGI lɔɠɔi ɠoloɠologa, kpe ka leʋe ná-nuɓusɛiti ba, é ɠula ti zaama. ");
INSERT INTO tod_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","É Ɠɔoɠɔ GALAGI laawooi ʋɛlɛʋiliga, é ná-deveiti koloɠolo, kɛni kpe ge leʋe ná-nuiti ba. Ná-faaɠaaza golai ma ɠasɔi ɠa la unma.» ");
INSERT INTO tod_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Tɛi Izilayɛle nuiti ti ɠɛni teʋebai zu, ti zunui ta ɠaani, é ɗa koʋii ɠale dooɠo foloi. ");
INSERT INTO tod_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Tɛiti ti soni ná, ti ʋaani la Moize ʋɔ ta Aalɔn, ta nuɓusɛiti kpein pɔ. ");
INSERT INTO tod_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ti makɛni ma ga pagɔ, tɔɔzei faa nɔpɛ ge la ɠɛni dɛ leveni, é ʋa ʋilɛ naa ʋa, nii a zoo é ɠɛ la. ");
INSERT INTO tod_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Ta naama zunui ʋaa. Wa lii la wo-ʋuuzuʋɛ ʋoluʋɛ, nuɓusɛi kpein ge sɔ ga kɔtui.» ");
INSERT INTO tod_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Názu ɠa nuɓusɛiti ti ɠulani la la, ti-ʋuuzuʋɛ ʋoluʋɛ, ti sɔ ga kɔtui, eyɛsu é za, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Bo Izilayɛle nuiti ma ga, tiya-o, ti-mavofodaiti-yo, ti geze yiizayiizagi lo ta-ʋɛɛkɔma zeɠeiti goizuʋɛ, ta geze ɠaali ɓiinii. ");
INSERT INTO tod_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Siɛgi zu wo geze yiizayiizagiti kaazu la, wa ɠizɛ Ɠɔoɠɔ GALAGI ná-deveiti su, wo ɗa kɛ, wo la ɓɔɠɔ ɠakaga, wo ʋa ʋilɛ wo yiima vaiti polu, ta wa-ɠaazuɠulapɔiti, niiti ti wo lɔɔzu wooʋaladai zu. ");
INSERT INTO tod_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Naazu wa ɠizɛ nà-deveiti kpein su, wo ɠolo ti ʋɛ. Wa ɲade wa-ƓALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI, nii é wo ɠulaai Ezipete yooi ʋa, ga é ɠɛ ga wa-ƓALAGI. Ungo, nà ga Ɠɔoɠɔ GALAGI, wa-ƓALAGI.» ");
INSERT INTO tod_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kolé, Yiseɠaal ná-doun zunui, Keɠate ná-pɛlɛyeɠei wu, Levi ná-bolodai zu zunui ta ɠɛni de, é Luɓɛn ná-bolodai zu zunu saʋagɔ ʋɛɛni ɓɔɠɔ ʋa, Datan ta Aɓilame, Eliyaɓe ná-doun zunuiti, ta Won, Pelɛte ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ti wuzeɠeni Moize laalɔɠɔma, ti Izilayɛle nuiti nu unfelegɔ puulɔɔlugɔ (250) ʋɛɛni ɓɔɠɔ ʋa, niiti ti ɠɛni ga nuɓusɛiti ta-ɠundiɠiiti, ti ɠɛni ga ɓalaa nuiti tɛnɛ nuiti maaɓɔgiti su, ti ga nuiti unfemai ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ti ɠaalɛɛni ba Moize ta Aalɔnni daalɔɠɔma, ti ɠɛ ti ma: «É kula ɠɛa! Nuɓusɛi kpein ka ɲadegai, Ɠɔoɠɔ GALAGI ɠa ade pɛ ba. Zobogi ɓɛgele ɠa é wo ya, ga wo zei Ɠɔoɠɔ GALAGI ná-bɛbɛi ɠa ɲii?» ");
INSERT INTO tod_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Siɛgi zu Moize naama yelilomaiti mɛnini da, é laaʋɛɛni zooi ma. ");
INSERT INTO tod_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Naa ʋolu é ɓɔɛni Kolé ʋɔ, ta polu nuiti, é ɠɛ ma: «Lina sobu, Ɠɔoɠɔ GALAGI ɠa naa lɛ, nii é ga nɔnɔi ta nii ɲadegai, a zoo maaɓuɠazu ba, nii é yiimazeɠezu la. ");
INSERT INTO tod_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Wɛlɛ nii wo ʋaazu kɛɛzu, Kolé ta polu nuiti kpein ta ansanse gala liɠiiti seɠe, ");
INSERT INTO tod_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ti ti laave ga abulekaiti, ti ansansegi ʋu ga, Ɠɔoɠɔ GALAGI ɠaazu. Nii Ɠɔoɠɔ GALAGI a yiimazeɠe la, naa ɠa ɲadegai. É kula ɠɛa, Levi ma zuwuzuiti!» ");
INSERT INTO tod_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moize ɠɛni Kolé ma mɔnɔ: «À woilo gòoi ma ga pagɔ, Levi nuiti! ");
INSERT INTO tod_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Naa ɠa wo ɠaazu ga faa go ɓaa, ga Izilayɛle ná-GALAGI yiimazeɠe ga woye yɛ, Izilayɛle nuɓusɛiti saama, é zobo fe wo ʋɛ, wo maaɓuɠa ba, wo ɗa botii ɠɛ Ɠɔoɠɔ GALAGI ná-seɠe ʋɛlɛ ɲadegai wu, wo lo nuɓusɛiti untuɠɔ, wo botii ɠɛ tɔun bɛ? ");
INSERT INTO tod_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","É ma zobogi veeʋɛ wo ʋɛ ga wo ɗa maaɓuɠa ba, wa è-ɠɛɛleaiti, Levi nuiti. Naa ɠa wo zalaɠa ɠula nui losuʋɛ ɠaiziɛzu mɔnɔ? ");
INSERT INTO tod_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Naa ɠa é kɛa ɗa-o, ɗa-nuiti-yo, wo gilia ba, wo wuzeɠe Ɠɔoɠɔ GALAGI laalɔɠɔma! Mazɔlɔɔ Aalɔn ɠa ga ɓɛ, wo ʋa ɠɛ unsuyelii losu daalɔɠɔma?» ");
INSERT INTO tod_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moize nu leʋeni ga ti Datan loli ta Aɓilame, Eliyaɓe ná-doun zunuiti. Kɛlɛ ti ɠɛni ma: «Gi la liizu! ");
INSERT INTO tod_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","È gi ɠula zou ʋagɔi ʋa, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná, é ʋa ga giye teʋebai zu ga gi za, faa go ɠana ɓaa? Ɗa ɠɛɛzu mɔnɔ, è zei gi unda ɓaa? ");
INSERT INTO tod_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","È la ʋaani ga giye zou zu, ʋɛ nɔnɔi ta kɔin gulɔi ʋooʋaai ná! È la kpalagaa veeni gi ya, ɓaa kpelea ga gɔnɔ. Ɗa niima nuiti kpein kaazu ga gaazuɠole nuiti? Ɓa-o, gi la liizu pɛ!» ");
INSERT INTO tod_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moize wola yiiɠaawanani, é ɠɛ Ɠɔoɠɔ GALAGI ma: «Mina yeezei ta-vebɛ zalaɠai wu! Gè la tanɔpɛ kɔli kulani zea, folo ɠila ɓalaa, anɛɛ soovale gila kpalaa, gè la dɛ faa ɲɔu ɠɛɛni ga taɠila ɓalaa!» ");
INSERT INTO tod_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moize ɠɛni Kolé ma: «Ɗa-o, è ʋolu nuiti-yo, é ɓɔ Aalɔn ʋa, à ɠula kɛlɛma lina Ɠɔoɠɔ GALAGI ɠakala. ");
INSERT INTO tod_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Wo ɠilagilagi, ansanse gala liɠii zeɠe, è ansansegi ʋu su, è ʋa Ɠɔoɠɔ GALAGI ɠakala. Wa ʋa ga ansanse gala liɠi unfelegɔ puulɔɔlugɔ (250), ɗa-o, Aalɔn-o, wo ɠilagilagi ɠa nɔnɔi zo ya.» ");
INSERT INTO tod_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ti ɠilagilagi, ti ta-ansanse gala liɠii zeɠeni, ti abulekaiti pu su, ti ansansegi ʋu ga. Ti pɛ ti loni GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, Moize ɓalaagi ta Aalɔn. ");
INSERT INTO tod_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kolé bɛbɛi ɠaalɛɛni ba ti laalɔɠɔma GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. Naazu, Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani kɛlɛma bɛbɛi kpein bɛ. ");
INSERT INTO tod_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: ");
INSERT INTO tod_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«À ɠula niima nuɓusɛiti saama, nà ti undaaʋilisu ɠaniɠanigi nɔ!» ");
INSERT INTO tod_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Kɛlɛ Moize ta Aalɔn ti laaʋɛɛni zooi ma, ti maanɛɛnɛi wo, ti ɠɛ ma: «Ee, GALA! GALAGI nii deve kpɛtɛaniiti kpein zɛnvui ma, ɗa ʋaazu bɛbɛi kpein sosu ga nu ɠilagi ná-kotoi?» ");
INSERT INTO tod_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Ɓɔɛ nuɓusɛiti pɔ, è devei ve ti ya ga ti maaɠooza Kolé ta Datan ta Aɓilameni ta-zeɠe ɠotaiti ba.» ");
INSERT INTO tod_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moize wuzeɠeni zooi ma. Izilayɛle ɠundiɠiiti ti ʋilɛni polu, ti li Datan ta Aɓilame ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","É ɠɛni nuɓusɛiti ma: «À maaɠooza kotoba nui tɛiti ta-zeɠe ɠotaiti ba. À mina vɔɔɠu ti-yeaɠɔligi tanɔpɛ ba, ni wo la wɔinni, wo undaa ʋa ʋili ta-ɠotoiti faa zu!» ");
INSERT INTO tod_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Naazu, ti maaɠoozani Kolé ta Datan ta Aɓilameni ta-zeɠe ɠotaiti ba. Datan ta Aɓilame ti ɠulani, ti lo ta-zeɠe ɠotaiti daaʋɛ, ta ti-anzaiti, ta ti-loun zunuiti, ta ti-lounlointi. ");
INSERT INTO tod_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moize ɠɛni ma: «Nii ɠa wa kwɛɛ da ga Ɠɔoɠɔ GALAGI ɠa é tèʋega, ga gè kɛɛwotii niiti kɛ, gè la faa nɔpɛ kɛɛzu ɓɔɠɔ ʋɛ ɠana nɔ. ");
INSERT INTO tod_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ni niima nuɓusɛiti ta zaana ga nu zaa ʋele nɔ, eɠɛʋelei deveai la nuɓusɛi ma ga é za, naazu Ɠɔoɠɔ GALAGI laade é ʋa vali mà, é ʋa tèʋe. ");
INSERT INTO tod_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kɛlɛ ni Ɠɔoɠɔ GALAGI a fai ta ɠɛɛna, nii kɛɠala la dɛ ɠɛɛni, ni zooi a laalaona, é ti ɓɔle ta ti-yeaɠɔligiti kpein, ti ma vului yei gɔvɛalaazu, wa kwɛɛ naazu ga nui niiti ti ɲɛɛɠulaʋɛ Ɠɔoɠɔ GALAGI zu.» ");
INSERT INTO tod_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Moize ɓeni nɔ ga woo ɠaaɓela, zooi ʋalini ga Datan ta Aɓilameni kɔɠɔwu. ");
INSERT INTO tod_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Zooi laalaoni, é ti ɓɔle, ta ta-ʋɛlɛyeɠeiti, ta Kolé ná-nuiti, ta ti-ɠɔligiti. ");
INSERT INTO tod_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Naama nuiti ti yeini gɔvɛalaazu ga ti ma vului, ta tɔnɔiti kpein. Zooi laaɠuluni ti ma ʋolu. Pele ɠana ti ɠaalani da, nuɓusɛiti saama. ");
INSERT INTO tod_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Ta-ɓee wooi mɛnigai ma, Izilayɛle nuiti kpein ti ɠɛni loni ná maaɠoolii zu, ti ɓizɛni, ti ɗa kpeei loo, ti ɠɛ ma: «Ade ɓizɛ, zooi mina ade ɓɔle, ada ɓalaa!» ");
INSERT INTO tod_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Abui ɠulani Ɠɔoɠɔ GALAGI ʋɔ bɛ, é zunu unfelegɔ puulɔɔlugɔiti (250) gala, niiti ansansegi ɠɛni ti ya. ");
INSERT INTO tod_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Ɓɔɛ Eleazaal ʋɔ, zalaɠa ɠula nui Aalɔn ná-doun zunui, bo ma ga é ansanse gala liɠiiti kula abui zu, é abulekaiti pu ya ɠoozama, mazɔlɔɔ diɠii naati ti ɲadega. ");
INSERT INTO tod_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Nui niiti, ti zaai ta-ɠotoi maaʋele ma, à ta-ansanse gala liɠiiti seɠe, wo ti loɠa, wo ti ɓɛtɛ ga kɔlu ɓɔi sɛpɛgiti, nii a ʋɛɛ zalaɠa ɠulazuʋɛ ma. Diɠii naati ti ɲadega, mazɔlɔɔ ti ʋaaʋɛ ga tiye pɔ̀. Ta ɠɛ ga poogi Izilayɛle nuiti bɛ.» ");
INSERT INTO tod_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Zalaɠa ɠula nui Eleazaal ansanse gala liɠiiti seɠeni, niiti ti ga kɔlu ɓɔigi, zunuiti niiti ti ʋaani ga tiye, abui naati galani. Ti ti loɠani, ti ti ɠɛ ga ma zɛpɛgiti, ti pɛɛ zalaɠa ɠulazuʋɛ ma. ");
INSERT INTO tod_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Naa ɠa é ga ɠizɛsui Izilayɛle nuiti bɛ, ga nu nɔpɛ nii é la ga Aalɔn mavofodai, maa la nɛɛni, é ʋa maaɓuɠa Ɠɔoɠɔ GALAGI ʋa, é ʋa ansanse kula ga zalaɠai gaazu, a ʋa ɠɛ eɠɛ Kolé ta ná-nuɓusɛiti, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la Moize ya ga é bo ma. ");
INSERT INTO tod_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Poluma zobui Izilayɛle nuɓusɛiti kpein ti ɠɛni zelii losu Moize ta Aalɔn ma, ti ɠɛ ma: «Wo Ɠɔoɠɔ GALAGI ná-nuɓusɛiti paaʋɛ!» ");
INSERT INTO tod_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Ti maaɓɔni ba Moize ta Aalɔn maaɠoolii zu. Ti ɠɛai ma latisu GALA daaɠomi seɠe ʋɛlɛi ʋɔ pelei, pɛtɛ, tonaɓiingi ʋɛɛni ma, Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Moize ta Aalɔn ti liini, ti lo GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«À ɠula bɛbɛi tɛi saama, nà ti-ma zuwu ɠaaleʋezu ɠani nɔ.» Ti laaʋɛɛni zooi ma. ");
INSERT INTO tod_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Naa ʋolu Moize ɠɛni Aalɔn ma: «Ɗa-ansanse gala liɠii zeɠe fala, abulekaiti seɠe zalaɠa ɠulazuʋɛ, è pu su, è ansansegi ʋu ga. Suvilɛ, è lii la nuɓusɛiti pɔ bɛ, è koto gba vai ɠɛ, mazɔlɔɔ Ɠɔoɠɔ GALAGI ná-ziiɠaawanai lokoleʋea, niizu maanɔɠɔi tɔɔzeiɗa.» ");
INSERT INTO tod_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aalɔn naa ɠɛɛni, nii Moize boni ma. É ansanse gala liɠii zeɠeni, é ɓizɛ, é li nuɓusɛiti saama. Naazu maanɔɠɔi tɔɔzeini niina ga zeelia nuɓusɛiti ma. É ansansegiti galani, é koto gba vai ɠɛ nuɓusɛiti bɛ. ");
INSERT INTO tod_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","É loni nuiti saama, niiti ti zaa ɠɛni de na, ta niiti ti ɠɛni vulua, maanɔɠɔi ɓeni. ");
INSERT INTO tod_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Nui liegɔi é zaani naama maanɔɠɔi zu, é ɠɛni ga nu waapuugɔ maazu naanigɔ undɔfela (14.700), é ɠula niiti polu, ti undaaʋilini Kolé ná-fai zu. ");
INSERT INTO tod_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Aalɔn ɠaleni ma Moize ʋɔ bɛ GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, siɛgi zu maanɔɠɔi ɓeni la. ");
INSERT INTO tod_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Devei ve Izilayɛle nuiti zea, ga bolodama ɠundiɠii ɠilagilagi tukpɔi ɠila fe è ya. Tukpɔ puugɔ maazu felegɔ (12) ɠa bolodama ɠundiɠiiti ta fe è ya. È ti ɠilagilagi laaseigi zɛʋɛ ɛsɛ nɔnɔ ma. ");
INSERT INTO tod_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Ɗa Aalɔn laaseigi zɛʋɛ Levi ná-bolodai ná-tukpɔi ma, mazɔlɔɔ bolodama ɠundiɠi ɠilagilagi ná-tukpɔi ɠa ɠɛ ná. ");
INSERT INTO tod_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Ɗa ti la GALA daaɠomi seɠe ʋɛlɛi wu, zeele woo ɠesui ɠakalaʋɛ, ʋɛ ada ɠɛ ɠomisu ná. ");
INSERT INTO tod_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Zunui nii gè yiimazeɠezu la, naa ná-tukpɔi ɠa ʋɔnɔ ba, naa ɠa a kɛ gè Izilayɛle nuiti ta-unsuyelii ɓe, nii ti bosu gòizu yeenɔpɛ wo laalɔɠɔma.» ");
INSERT INTO tod_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Moize naama leveiti feeni Izilayɛle nuiti zea. Bolodama ɠundiɠiiti gilagilagi tukpɔ ɠilagila feeni zea, é ɠɛ ga tukpɔ puugɔ maazu felegɔ (12). Aalɔn ná-tukpɔi ɠɛni tɔnɔiti saama. ");
INSERT INTO tod_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Moize ti laani Ɠɔoɠɔ GALAGI ɠaazu, seɠe ʋɛlɛi wu, nii zeele woo ɠesui ɠɛni bu. ");
INSERT INTO tod_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Poluma zobui, Moize lɛɛni seɠe ʋɛlɛi wu. É kaani ga Aalɔn ná-tukpɔi, nii é laani Levi ná-bolodai laaseigi zu, é ʋɔnɔni ba, ma ʋuaiti gaaʋuye, gulu waai é ga amandegi, naa ma ɓɔigi ɠɛni ba. ");
INSERT INTO tod_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Moize tukpɔi kpein seɠeni ʋolu seɠe ʋɛlɛi wu, Ɠɔoɠɔ GALAGI ɠaazu, é li, é dɛɛ ga Izilayɛle nuiti. Ti naa ɠaani nii kɛai, ɛsɛ ge ná-tukpɔ zeɠeni. ");
INSERT INTO tod_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Aalɔn ná-tukpɔi la ʋolu zeele woo ɠesui ɠakalaʋɛ. Toɠa makɛsu ná eɠɛ poogi niiti bɛ, ta ɠɛ ti ɓaka, naa ɠa a kɛ è ti ɓeteʋe unsuyeli lo fai ʋa gàazu, ti ʋa za.» ");
INSERT INTO tod_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Moize kɛɛni ɠana. É Ɠɔoɠɔ GALAGI wooi zoni, eɠɛʋelei naa deveni la. ");
INSERT INTO tod_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Izilayɛle nuiti ti ɠɛni Moize ma: «Wɛlɛ, gi loa ya, gá zaazu ɲɛgɛlɛin! ");
INSERT INTO tod_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Nu-o-nu a maaɓuɠa Ɠɔoɠɔ GALAGI ná-seɠe ʋɛlɛ ɲadegai ʋa, naa ɠa zaazu! Zekana gi pɛ gi ɠaaɓelazu la?» ");
INSERT INTO tod_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ɠɔoɠɔ GALAGI ɠɛni Aalɔn ma: «Ɗa-o, è-loun zunuiti-yo, ta è-ɠɛɛ mavofodaiti, faaɠaaza golaiti kpein ti ɠɛɛzu seizu ɲadegai laalɔɠɔma, ma ɠasɔi ɠa la wo unma. Ɗa-o, è-loun zunuiti-yo, faaɠaaza golaiti kpein ti ɠɛɛzu, wa-zalaɠa ɠula wotii ma ziɛgi zu, wa ɠa naama ɠasɔi a la wo unma. ");
INSERT INTO tod_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","È-ɠɛɛleaiti maaɓuɠa ɓɔɠɔ ʋa, Levi ná-bolodai, è-ɠɛɛ ná-bolodai, ti ɠili è ʋa, ti ɓɔ è ʋa, wa è-loun zunuiti wo ɠɛ botii zu seɠe ʋɛlɛi wu, nii zeele woo ɠesui bu. ");
INSERT INTO tod_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ta ɗa-levei zo, ti ɗa seɠe ʋɛlɛi kpein makɛ, kɛlɛ ti la maaɓuɠaa seizu ɲadegai ma zɔɔlaiti ba, anɛɛ zalaɠa ɠulazuʋɛ ɓalaa, wa ʋa lia zaazu, tiya-o, wa-o. ");
INSERT INTO tod_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ta ɠɛ wo ʋa, ɗa-wotii zu, ta ɠɛ GALA daaɠomi seɠe ʋɛlɛi wu wotii kpein su, ti ɗa botii pɛ kɛ, nii maanɛai ga ti kɛ. Kɛlɛ nu ɠili nɔpɛ ge la maaɓuɠaa wo ʋa. ");
INSERT INTO tod_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Wa ɠa seizu ɲadegai ma ɠasɔi a ɠɛ wo unma, ta zalaɠa ɠulazuʋɛ, nà-ziiɠaawanai loko la leʋea naazu, é ʋa yei Izilayɛle nuiti daalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","À wɛlɛ, gè yiimazeɠeni ga wo-ɠɛɛleaiti, Levi nuiti, Izilayɛle nui zɔiti saama, ta ga nɔ̀nɔi, gè ti veeʋɛ wo ya ga ti GALA daaɠomi seɠe ʋɛlɛi ma wotii ɠɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ɗɔun ɗa Aalɔn, wa è-mavofodaiti, wa wa-zalaɠa ɠula wotii ɠɛ, naa kpein su nii é ʋilɛsu zalaɠa ɠulazuʋɛ ʋa, ta nii é ada ɲadega wolai, kwɛpele seɠezuɠoozagi ʋoluʋɛ, wo-ɠasɔi ɠana. Gè wa-zalaɠa ɠula wotii veeʋɛ wo ʋɛ ga faanɛɛi. Zɔi nɔpɛ a maaɓuɠana ná ʋa, ga wo ɠɛʋele, ta naama nui ʋaa.» ");
INSERT INTO tod_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Ɠɔoɠɔ GALAGI ɠɛni Aalɔn ma: «Woilo, nii dɔin Izilayɛle nuiti ti kulazu vebɛani ɲadegaiti ba, nà ɓɔɠɔi gè naa makɛ vai ɠaliva è ma. Gè fea è ʋɛ, wa è-mavofodaiti, wɔnɔi ɠa ná, naa ɠa ɠɛ ga ɠɔoɠɔ tɔgi. ");
INSERT INTO tod_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Wɛlɛ nii a ɠɛ ga wɔnɔi vebɛani ɲadegaiti su, nii é ga nɔ̀nɔi, naa a zeɠena ba, é ɠala: nii dɔin Izilayɛle nuiti ti kɛɛzu bɛ̀ ga vebɛ zalaɠaiti moloi zu, ta koto gba zalaɠaiti, ta ná-faa zuɓɛtɛ zalaɠaiti, ti ʋaazu ga tiye pɔ̀. Naama ani ɲadega wolaiti ta ɠɛ ga ɗɔnɔ, wa è-loun zunuiti. ");
INSERT INTO tod_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Wa ti mi ada ɲadegai ta. Zunuiti nɔ ɠa ta mi. Ta ɠɛ ga ani ɲadega wolaiti wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«É ɓudɛ naa maazu, vebɛanii niiti Izilayɛle nuiti ti feezu bɛ̀, ɗa naa ɠilazuʋɛ zeɠe. Gè naa kpein fea è ʋɛ, wa è-loun zunuiti, ta è-loun anzanuiti, naa ɠa ga ɠɔoɠɔ tɔgi. Nuiti kpein ta ɠɛ ɗa-ʋɛlɛi wu, ti la tɔ koloɠoloni, ta zoo ti ta mi. ");
INSERT INTO tod_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Zooi ʋaalɔnɔ mɔungiti ti feezu bɛ̀, gè naati ɓalaa fea wo ʋɛ, naa ɠa é ga gulɔi, ta dɔɔ niinɛi, ta moloi, ");
INSERT INTO tod_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","zooi ʋaalɔnɔ mɔungi kpein ti ʋaazu la Ɠɔoɠɔ GALAGI ʋɔ. Nuiti kpein ta ɠɛ ɗa-ʋɛlɛi wu, ti la tɔ koloɠoloni, ta zoo ti ta mi. ");
INSERT INTO tod_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«Nii kpein Izilayɛle nuiti ta konana mà ga nɔ̀nɔi, naa ɠɛa ɓalaa ga wɔnɔ. ");
INSERT INTO tod_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Doun mɔungiti, ta togani mɔungiti, ta ti ve Ɠɔoɠɔ GALAGI ʋɛ, naati ta ɠɛ ga ɗɔnɔ. Kɛni è doun zunu mɔungi unmɔɔ, è togani yiʋo zinɛ mɔungi ɓalaa unmɔɔ, nii é la zooga é ʋa ɠula ga zalaɠa. ");
INSERT INTO tod_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Zunu loin unmɔɔ ganii ɠa ɠula, a alu gila sɔlɔɔna, sɔngɔi ɠa ɠɛ ga wali ɠae lɔɔlugɔ, seizu ɲadegai ma valibogi zu, naama wali ɠae ɠilagi ɠa ga galamu puugɔ. ");
INSERT INTO tod_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Kɛlɛ mina va bu, ti ʋa nikɛ yiʋo mɔungi unmɔɔ, ɓaa baala ziʋo mɔungi, ɓaa boli yiʋo mɔungi, ta ga zalaɠa ani ɲadegaiti. Wa ti-ma ɲamai vaza zalaɠa ɠulazuʋɛ ma, wo ti-ma wulɔi ɠula ga zalaɠai, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Ti-ma zuai ɠa ɠɛ ga ɗɔnɔ, eɠɛʋelei zalaɠa zuaiti ta ɗa ɠɛ la, ma ɠekegi ta ma ɓalai é ga zeezazu ʋelei, niiti ti ɠula ga datɛɠɛ vai ma ʋoogi. ");
INSERT INTO tod_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ani ɲadegaiti kpein Izilayɛle nuiti ti seɠezu ba Ɠɔoɠɔ GALAGI ʋɛ ta-vebɛaniiti su, gè naati fea wo ʋɛ, ɗa-o, è-loun zunuiti-yo, è-loun anzanuiti-yo, naa ɠa ga ɠɔoɠɔ tɔgi. Toɠa ga minazeɠegi é la ɠoloɠologa ta é la valiboga, wo yɔɠɔzu wa Ɠɔoɠɔ GALAGI ta è-mavofodaiti.» ");
INSERT INTO tod_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ɠɔoɠɔ GALAGI ɠɛni Aalɔn ma: «È la zou zɔlɔɔga, ga è ɓɔɠɔ gele, Izilayɛle yooi zu, ɗɔnɔ nɔpɛ ge la ɠɛa ná, ti zaama. Nà ɠa gè ga ɗɔnɔi ta ɗa-ɓɛtɛi Izilayɛle nuiti saama. ");
INSERT INTO tod_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«Puusiɛi nii kpein Izilayɛle nuiti ti kulazu, gè naa vea Levi nuiti bɛ ga tɔnɔ, botii vaa zu ti kɛɛzu, nii ti kɛɛzu GALA daaɠomi seɠe ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Izilayɛle nuiti ti la mɔ maaɓuɠaa GALA daaɠomi seɠe ʋɛlɛi ʋa, ti ʋa koto zeɠe, ti ʋa za. ");
INSERT INTO tod_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Levi nuiti nɔ ɠa ta ɠɛ GALA daaɠomi seɠe ʋɛlɛi wu wotiiti kɛɛzu, ni faaɠaaza gola ɠa ɠɛɛna ná, tiya ɠa ma ɠasɔi a la ti unma. Toɠa ɠɛ ga ɠɔoɠɔ tɔgi, wo-mavofodaiti kpein bɛ. Ti la zou zɔlɔɔga Izilayɛle nuiti saama, ");
INSERT INTO tod_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","mazɔlɔɔ nà puusiɛi kpein feezu Levi nuiti bɛ ga tɔnɔ, nii Izilayɛle nuiti ti kulazu Ɠɔoɠɔ GALAGI ʋɛ. Naa ɠa é kɛa, gè boni ti ma ga ti la zou zɔlɔɔga Izilayɛle nuiti saama.» ");
INSERT INTO tod_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Bo Levi nuiti ma ga: ‹Siɛgi zu Izilayɛle nuiti ti ʋaazu ga puusiɛiti wo ʋɔ, gè feezu wo ya ga wɔnɔ, wa puusiɛi ɠula ba ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ, naa ɠa é ɠɛɛzu ga puusiɛi ma ʋuusiɛi. ");
INSERT INTO tod_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Wɔnɔ ma ɠuladai naa ɠa levezu ga, eɠɛʋelei naa la, nii é ɠulazu molo loɠazuʋɛ ta dɔɔ ɓɛtɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Pele ɠana wa ta ɠula da la, wa ɓalaagi, é ɠɛ ga vebɛanii Ɠɔoɠɔ GALAGI ʋɛ, é ɠula puusiɛi kpein ba, wo sɔlɔɔsu Izilayɛle nuiti zea. Wa fe zalaɠa ɠula nui Aalɔn ya, é ɠɛ ga zalaɠai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Faanɛɛi kpein wo sɔlɔɔsu, wa vebɛanii zeɠe ba Ɠɔoɠɔ GALAGI ʋɛ, wa ma ʋagɔi zeɠe ba, é ɠɛ ga ma ʋagɔ ɲadegai seɠeai ba yɛ.› ");
INSERT INTO tod_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","«Ɗa ɠɛ ti ma mɔnɔ: ‹Wa ma ʋagɔi ɠulana ba, mɔtai ɠa ɠɛ wo ʋɛ, Levi nuiti, eɠɛʋelei naa la, nii é ɠulazu molo loɠazuʋɛ ta dɔɔ ɓɛtɛzuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Wa mi, ʋɛ nɔpɛ ná nɛai wo ʋɛ, wa wa-ʋɛlɛyeɠeiti, mazɔlɔɔ wo-zalai ɠana, botii kpein faa zu nii wo kɛɛzu GALA daaɠomi seɠe ʋɛlɛi wu. ");
INSERT INTO tod_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Wo la faaɠaaza nɔpɛ kɛa ga naa, tɔɔzei wo ma ʋagɔi zeɠeʋɛ ba bɛ̀. Naazu wo la Izilayɛle nuiti ta-vebɛani ɲadegaiti kɔzɔa ɲɛgɛlɛin, wo ʋa za.› » ");
INSERT INTO tod_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Pɛtɛ, devei nii ɠa é Ɠɔoɠɔ GALAGI ná-tɔgi zu: À bo Izilayɛle nuiti ma, ti ʋa ga nikɛ zaa ɓɔigi, nii nɛɛʋuzu la ba, ɓaa maa ʋa lɛɠɛfɛ, nii é la dɛ wozawolini. ");
INSERT INTO tod_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Wa fe zalaɠa ɠula nui Eleazaal ya. Naa ɓalaagi ɠa lii la wo-ʋuuzuʋɛ ʋoluʋɛ, ti kɔdaaleʋe gaazu. ");
INSERT INTO tod_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Toɠa ma ɲamai ta zo, é yeeɓeɠai lɔ bu, é faza ná zeizu ɠɛ lɔfela GALA daaɠomi seɠe ʋɛlɛi letema ʋelei. ");
INSERT INTO tod_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Naa ʋolu, ta nikɛ zaai naa ɠala gaazu: ma ɠɔlɔi, naa ʋɛɛ ma zuai ʋa, ta ma ɲamai, naa ʋɛɛ ma ɓooiti pɛ ba. ");
INSERT INTO tod_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Naa ʋolu, zalaɠa ɠula nui ɠa sɛdele gulu ɓuɠai zeɠe, ta ɠizɔɔpe tufa ɓifɔgi, ta geze ɓɔi sɔsɔgi, é ti ʋili abuzogi zaamaʋɛ, ʋɛ nikɛ zaa ɓɔigi ɠalazu ná. ");
INSERT INTO tod_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Naa pɛ poluma, zalaɠa ɠula nui ɠa ná-seɠeiti gba, é ɓɔɠɔ maagba, aisa é ʋa ɠale ma wo-ʋuuzuʋɛ, anɛɛ naa ʋe, kɔzɔai ɠa yɛ de tɔgi letemazu eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Zɔi ɓalaagi a nikɛ zaai ɠala, naa ɠa ná-seɠeiti gba, é ɓɔɠɔ maagba, kɔzɔai ɠa yɛ de eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Zunu ɠila nii ɲadegai tɔgi letemazu, naa ɠa nikɛ zaai ma yuʋui ɠaalɛ ba, é lii la wo-ʋuuzuʋɛ ʋoluʋelei, é pu ada ɲadegai ta, ʋɛ a makɛ ná Izilayɛle nuɓusɛiti bɛ, ɲade ɗɛi ɓɛtɛ vai zu, koto gba vai zu. ");
INSERT INTO tod_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Zɔi a nikɛ zaai ma yuʋui ɠaalɛ ba, naa ɓalaa ɠa ná-seɠeiti gba, kɔzɔai ɠa yɛ de eyɛsu kpɔkɔi zeeli. Izilayɛle nuiti ta seikɔɠɔma nuiti, ta tɔgi nii zo eyɛsu ɠɔ. ");
INSERT INTO tod_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Nu-o-nu a vɔɔɠu nu ʋooma ʋa, kɔzɔai ɠa yɛ de, tɔgi letemazu, folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ni a ɓɔɠɔ ɲadena foloi zaʋasiɛi ta dɔfelasiɛi, ga niima ɗɛi, toɠa ɲade. Ni naa la ɠɛɛni, kɔzɔai ɠa yɛ de. ");
INSERT INTO tod_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nu-o-nu nii a vɔɔɠu nu ʋooma ʋa, é la ɓɔɠɔ ɲade fai ɠɛɛni, toɠa Ɠɔoɠɔ GALAGI ná-seɠe ʋɛlɛ ɲadegai ɠɔzɔzu. Naama nui ɓe ka leʋe Izilayɛle nuiti ba. Tɔɔzei ɲade ɗɛi la vazani ma, kɔzɔai ɠa yɛ de. ");
INSERT INTO tod_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Tɔgi ʋɛtɛ, nii maanɛai ga wo so: Ni nu a zaana seɠe ɠotai wu, niiti kpein ti lɛɛzu ná, ta niiti kpein ti ɠɛni ná, ti ɠɔzɔai ɠa yɛ de folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Aniɲakai kpein daalaogai, dakulu ge la ʋɛɛni da, naa ɠa ɠɔzɔ. ");
INSERT INTO tod_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ni nu a vɔɔɠuna nu ʋooma ʋa dɔɓɔi zu, nu paa, ɓaa é za ɓɔɠɔ ʋɛ, ɓaa é vɔɔɠu nu ɠaei ɓaa kabai ʋa, kɔzɔai ɠa yɛ de folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Nii a kɛ é ɲade, ta nikɛ zaai ma yuʋui zeɠe, nii kulaai ga zalaɠai, é ɠala, koto gba vai zu, ti pu aniɲakai zu, ti ziɛungi zu ɗɛi ʋu ma. ");
INSERT INTO tod_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Zunui nii ɲadegai tɔgi letemazu, naa ɠa ɠizɔɔpe tufa ɓifɔgi gila seɠe, é dɔ ziɛi wu, é ta vaza seɠe ɠotai wu, ʋɛ nui ta zaai ná, ta aniɲakaiti ma, ta nuiti kpein ma ti ɠɛni ná. Toɠa kɛ ɠana nɔ naama nui ʋɛ, nii fɔɔɠuai nu ɠaeiti ba, ɓaa nu ʋoomai ʋa, nii nui ta paai, ɓaa saai ɓɔɠɔ ʋɛ, ɓaa nii fɔɔɠuai kabai ʋa. ");
INSERT INTO tod_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Nui nii ɲadegai tɔgi letemazu, naa ɠa a ziɛi vaza zɔi ma nii kɔzɔai. Toɠa naa ɠɛ foloi zaʋasiɛi ta dɔfelasiɛi ma. Folo lɔfelasiɛi, zunui kɔzɔai, naa ɠa ná-seɠeiti gba, é ɓɔɠɔ maagba. Kpɔkɔi, toɠa ɲade. ");
INSERT INTO tod_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Kɛlɛ ni zunui nii kɔzɔai, é la ɓɔɠɔ ɲadeni, kpe ka leʋe Izilayɛle nuiti ba, mazɔlɔɔ toɠa Ɠɔoɠɔ GALAGI zeizu ɲadegai ɠɔzɔzu. Tɔɔzei ɲade ɗɛi la vazani ma, kɔzɔai ɠa yɛ de. ");
INSERT INTO tod_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","«Izilayɛle nuiti ta niima lɔgi zo eyɛsu ɠɔ. Zɔi a ɲade ɗɛi vazana, naa ɠa ná-seɠeiti gba. Zɔi a vɔɔɠuna naama ɗɛi ʋa, naa ɠa ɠɔzɔ eyɛsu kpɔkɔi zeeli. ");
INSERT INTO tod_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Zunui kɔzɔai, anii kpein a vɔɔɠu ba, naati ta ɠɔzɔ, nu-o-nu a vɔɔɠu nui ʋa, nii kɔzɔai, tɔ ɓɔɠɔi ɠa ɠɔzɔ eyɛsu kpɔkɔi.» ");
INSERT INTO tod_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Konagi ma alu mɔungi, Izilayɛle nuɓusɛiti ti zeelini Sin teʋebai zu, ti ʋu Kadɛse. Miná ɠa Miliyame zaani ná, ti maaɠulu ná. ");
INSERT INTO tod_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ziɛ la ɠɛni ná. Nuɓusɛiti ti ɠaalɛɛni ba Moize ta Aalɔn laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Ti kpɔɛi ʋɛɛni Moize ʋa, ti ɠɛ ma: «Ee, ni gá la ɠɛni zaani, siɛgi zu gi-ɠɛɛleaiti ti ɠɛni zaazu la, Ɠɔoɠɔ GALAGI ɠaazu! ");
INSERT INTO tod_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Leeni vaa zu wo ʋaai ga Ɠɔoɠɔ GALAGI ná-nuɓusɛiti niima leʋebai zu, gi za gá gá-loganiiti? ");
INSERT INTO tod_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Leeni vaa zu wo zeɠeai ga giye Ezipete yooi zu, wo ʋa ga giye niima adaʋɛ nimizai zu? Nu la zooga é ʋa ani nɔpɛ sin ʋɛ. Nu la kooleɠoole gulu ɠaazu ʋɛ, ɓaa kpelei, ɓaa gelenade gului. Ziɛ vɔlɔ ɠa é la ná, nu ʋa ɓɔɔle.» ");
INSERT INTO tod_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moize ta Aalɔn ti maaɠoozani bɛbɛi ʋa, ti li GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, náʋɛ ɠa ti looni ná, ti laaʋɛɛ zooi ma. Názu ɠa Ɠɔoɠɔ GALAGI ná-lɛbiyai ɠulani la ti ʋɛ kɛlɛma. ");
INSERT INTO tod_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Ɗa-lukpɔi zeɠe, wa è-liɛ Aalɔn, wo nuɓusɛiti gaalɛ ba. Wa ɓɔɛ fasa ɠɔtui ʋɔ ti ɠaazu, é ziɛi ve. Ɗa ziɛi ɠulazu fasa ɠɔtui naa ʋa, è fe nuɓusɛiti zea, ti ɓɔɔle ta ta-loganiiti.» ");
INSERT INTO tod_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moize liini, é ná-tukpɔi zeɠe Ɠɔoɠɔ GALAGI ɠaazu, eɠɛʋelei naama levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moize ta Aalɔn ti bɛbɛi lolini fasa ɠɔtui ʋɔ bɛ, nii é lɛɛni ga tiye. Moize ɠɛni ti ma: «À woilo, wɔiti wo ga kololala nuiti! Wo laaʋɛ da ɓaa, ga gá zoo gi ziɛi ɠula fasa ɠɔtui tɛi ba wo ʋɛ?» ");
INSERT INTO tod_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moize yeewuzeɠeni, é fasa ɠɔtui loɠa la ɠɛ fele ga ná-tukpɔi. Ziɛi ɠulani ga bɔɔlɔa. Nuɓusɛiti ta toganiiti ti zooni ti ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kɛlɛ Ɠɔoɠɔ GALAGI ɠɛni Moize ta Aalɔn ma: «Tɔɔzei wo la laani dà, wo ʋa nà-ɲadedai wɔɔlɔ Izilayɛle nuiti gaazu, naa maaʋele ma, wa la mɔ de, wa lo niima ʋɛbɛi luɠɔ, wo ʋa lii la naama yooi zu, nii gè feezu ti ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Meliɓa ɗɛiti kana, Meliɓa laaseigi ɠa é ga «sakpegi». Ná ɠa Izilayɛle nuiti ti kpɔɛi ʋɛɛni ná Ɠɔoɠɔ GALAGI ʋa. Ná ɠa mɔnɔ é ná-lɛbiyai ɠulani ná kɛlɛma ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moize keelaiti teʋeni, ti zeɠe Kadɛse, ti li Edɔme masagi ʋɔ bɛ. Ti ɠɛni ma: «È-ɠɛɛloin Izilayɛle ɠɛ, è kpɔlɔiti kpein kwɛɛ, nii gi sɔlɔɔgai. ");
INSERT INTO tod_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Kaite gi-mɛmɛwolani ti liini Ezipete yooi zu, gi zeini ná kona mɔinmɔin daawu. Kɛlɛ Ezipete nuiti ti gi zopele ɲɔuni, eɠɛʋelei ti gi-mɛmɛwolani sopele ɲɔuni la. ");
INSERT INTO tod_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Gi ɓainni Ɠɔoɠɔ GALAGI woizu, é gi woomɛni. É ná-geezuɠeelai leʋeni, é gi ɠula Ezipete yooi ʋa. Niizu gá Kadɛse, taai nii é ʋuuni ɗa-yooi ma ɠwɛpelemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Va bu, gi leʋe ɗa-yooi zu. Gi la ziɛzu kpalagaa zu, ɓaa kpelea, gi la wa-ɠɔlɔyeɠe ɗɛ ɓɔlezu. Gá ʋilɛsu nɔ pele wolai nɔ ma, gi la zeɠezu ba, gi ʋa li ga yeezazu ʋele, ɓaa ɠɔʋɛzu ʋele, eyɛsu gi ɗa-yooi maazuɓudɛ.» ");
INSERT INTO tod_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edɔme masagi gooɠaaʋoteni, é ɠɛ ma: «Wo la leʋesu nà-zooi zu. Ni naa laade, nà kɔɔi ʋɛɛ wo ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Izilayɛle ɠeelaiti ti ɠɛni ma: «Gá ziɛzu nɔ ga pele wolai, ni gá ɗa-ɗɛi ta ɓɔlena, gá gá-loganiiti, gá sɔngɔi ve è ya. Gi la faa ɠili nɔpɛ maaɠaazaɠabosu è ma, kɛni nɔ è va bu, gi ziɛ ɠɔɠɔa, gi leʋe ɗa-yooi zu.» ");
INSERT INTO tod_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Masagi ti wooɠaaʋoteni, é ɠɛ ti ma: «Wo la leʋesu ʋɛ!» Edɔme nuiti ti Izilayɛle laaɠomini ga kɔɔɓɔgi, ti wola mɔin, ti wola yeeɠaaɓaai, ");
INSERT INTO tod_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ti pele ɓesa ti luɠɔ, ti ʋa leʋe ta-yooi zu, naa ɠa é kɛɛni Izilayɛle nuiti ti liini la ga pele ɠili. ");
INSERT INTO tod_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Izilayɛle nuɓusɛiti kpein ti zeɠeni Kadɛse, ti zeeli Ɠɔɔl gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ta Aalɔn ʋɔ, Ɠɔɔl gizei ma, Edɔme yooi ma ɠwɛpelemaʋɛ, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aalɔn ɠana ʋa liizu mɛmɛwolani pɔ, ti zaai. É la lɔɔzu zooi naa zu, nii gè ʋaazu feezu Izilayɛle nuiti zea, mazɔlɔɔ wo woozotalai ɠɛɛni ga nà-deveiti, Meliɓa ɗɛi ná-faa zu. ");
INSERT INTO tod_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aalɔn zeɠe ta ná-doun zunui Eleazaal, è lɛ ga tiye Ɠɔɔl gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ɗa Aalɔn ná-zalaɠa ɠula zeɠeiti kula kɔba, è ti loo ná-doun zunui Eleazaal ɠɔba. Naazu Aalɔn ɠa li niina mɛmɛwolani pɔ, toɠa za miná.» ");
INSERT INTO tod_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moize naa ɠɛɛni, nii Ɠɔoɠɔ GALAGI deveni la. Ti saʋagɔ, ti lɛɛni Ɠɔɔl gizei ma, nuɓusɛiti gaazu. ");
INSERT INTO tod_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moize Aalɔn ná-seɠeiti kulani kɔba, é ti loo ná-doun zunui Eleazaal ɠɔba. Aalɔn zaani ná, gize unmaʋɛ. Moize ta Eleazaal ti yeini, ti zeɠe gize unmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Izilayɛle nuɓusɛiti kpein ti suɠwɛɛni ga Aalɔn zaa. Nuɓusɛiti kpein ti ná-wɔlɔi woni folo ʋuusaʋagɔ (30) laawu. ");
INSERT INTO tod_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Masagi Alade, Kanaan nui, é ɠɛni zeini lɛkpɛmaʋɛ nu yeezazuʋɛ yooi zu, é mɛnini ga Izilayɛle nuiti ta leʋesu ga Atalime ʋelei. É laalɛɛni ti wu, é tanigaa zo ti zaama ga duɔi. ");
INSERT INTO tod_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Izilayɛle nuiti ti minazeɠeni Ɠɔoɠɔ GALAGI ʋɛ, ti ɠɛ ma: «Ni ɗa niima nuɓusɛiti dɔɔna gi yeezu, gá ta-laaiti kpein koloɠolo mɛtu.» ");
INSERT INTO tod_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ɠɔoɠɔ GALAGI Izilayɛle nuiti gooi zoni, é zobogi ve ti ʋɛ, ti pilɛ sɔlɔɔ Kanaan nuiti ma. Izilayɛle nuiti ti ti zuwuɠaaleʋeni, ti ta-laaiti koloɠolo. Ti naama adaʋɛ laaseigi ʋɛɛni ga Ɠɔɔlema (nii poluʋɛ ga «é ɠoloɠologa»). ");
INSERT INTO tod_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Izilayɛle nuiti ti zeɠeni Ɠɔɔl gizei ma, ti li ga Seeli Kpoloɗɛi ʋɔ pelei, nii a kɛ ti Edɔme yooi maala. Kɛlɛ nuɓusɛiti iɲɔ ge leʋeni pelei zu. ");
INSERT INTO tod_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ti tɔɔzeini ga ɓɔɛa GALA daalɔɠɔma ta Moize, ti ɗa ɠɛ ma: «Lee vaa zu wo gi ɠulaai Ezipete yooi ʋa, wo ʋa ga giye, gi ʋa za teʋebai zu? Mazɔlɔɔ ɓulu la ná, ziɛ la ná, niima maanɔɠɔ laamianigi wɔinzeɠea gi ma!» ");
INSERT INTO tod_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Názu ɠa Ɠɔoɠɔ GALAGI kaali ɲɔiti teʋeni la nuɓusɛiti daalɔɠɔma, ti ɗa ti ɲi. Izilayɛle nuɓusɛi zaani ga gola. ");
INSERT INTO tod_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Nuɓusɛiti ti ʋaani, ti Moize ɠa, ti ɠɛ ma: «Gi kotoi ɠɛɛni, siɛgi zu gi ɓɔɛa la Ɠɔoɠɔ GALAGI laalɔɠɔma ta ɗa ɓɔɠɔi. Niizu, soma è Ɠɔoɠɔ GALAGI maanɛɛnɛ, é kaalii tɛiti kula gi ma!» Moize maanɛɛnɛi woni nuɓusɛiti bɛ. ");
INSERT INTO tod_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ɠɔoɠɔ GALAGI gooɠaaʋoteni, é ɠɛ ma: «Kaalii ɓɛtɛ ga kɔlui, è sɛlɛ gulu ɠoozagi ʋa. Zɔi nɔpɛ kaali a ɲiina, é ɠaazuwuzeɠe, é wɛlɛ kaalii tɔna ba, naa la zaa.» ");
INSERT INTO tod_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moize kaalii ɓɛtɛni ga kɔlu ɓɔigi, é sɛlɛ gulu ɠoozagi ʋa. É zo názu ma, nu nɔpɛ kaalii a la ɲiina, é ɠaazuwuzeɠe, é wɛlɛ kaalii ʋa, é ga kɔlu ɓɔigi, naa la mɔ ɠɛni za. ");
INSERT INTO tod_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Naa ʋoluma, Izilayɛle nuiti ti zeɠeni ti-ʋuuzuʋɛ, ti li, ti ʋu Wɔɓɔte. ");
INSERT INTO tod_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ti zeɠeni miná, ti li Ye-Aɓalime, nii é teʋebai zu, gaaʋotegai Moaɓe yooi ma, folo ɠulazu ʋelei. ");
INSERT INTO tod_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Naa ʋoluma, ti liini, ti ʋu Zelɛde nɛmɛi zu, ");
INSERT INTO tod_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","naa ʋolu ti liini, ti ʋu ziɛ wolai Aalanɔn ʋoluʋelei, ziɛi naa ɠa é yeizu teʋebai zu, é ɗa ɠula Amool nuiti ta-yooi zu, é ga kwɛpelegi Moaɓe yooi ta Amool nuiti ta-yooi yɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Naa ɠa é ba, bogɛ é ɠole, Ɠɔoɠɔ GALAGI ná-kɔɔ vaiti ma zɛʋɛi zu ga: «Waɠɛɓe nii é Sufa, ta ma ɓekegiti, ta Aalanɔn, ");
INSERT INTO tod_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","é ɓɔ ma ɓekegiti ba, ti yeizu Aal taai ʋɔ pelei, tiya ɠa ti ga Moaɓe ɠwɛpelegiti.» ");
INSERT INTO tod_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ti zeɠeni miná, ti li Ɓeel. Kɔlɔyeɠei naa ná-fai ɠa é kɛɛni Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nuɓusɛiti gaalɛ ba, nà ziɛi veezu ti ya.» ");
INSERT INTO tod_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Izilayɛle nuiti ti niima wuyei looni, ti ɠɛ ma: «Ziɛi ɠula kɔlɔyeɠei zu, é lɛ! À maamusɛi wo! ");
INSERT INTO tod_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","À kɔlɔyeɠei ʋɛtɛ, nii kundiɠiiti ti bɔɔni, nii nu wolaiti ti bɔɔni ga ta-lukpɔi ta ta-ɓakɔiti.» Ti zeɠeni teʋebai zu, ti li Matana, ");
INSERT INTO tod_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","ti li Naɠaliyɛle, ta Ɓamɔte. ");
INSERT INTO tod_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Ti liini nɛmɛi zu, nii é Moaɓe yooi zu, gizei nii daaseigi ga Pizega, naa unmaʋɛ, ʋɛ ná zɛlɛgai teʋebai maazu. ");
INSERT INTO tod_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Izilayɛle nuiti ti keelaiti teʋeni Amool nuiti ta-masagi Siɠon ma, ti ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Va bu, gi leʋe ɗa-yooi zu. Gi la ziɛzu kpalagaa zu, ɓaa kpelea, gi la wa-ɠɔlɔyeɠe ɗɛ ɓɔlezu. Gá ʋilɛsu nɔ pele wolai nɔ ma, eyɛsu gi ɗa-yooi maazuɓudɛ.» ");
INSERT INTO tod_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Anɛɛ naa ʋe, Siɠon ɠɛlɛni, é la ɓeni ti ʋa, ti ʋa ziɛ ná-zooi zu. É ná-kɔɔɠɔ nuiti pɛ gaalɛɛni ba, é li Izilayɛle nuiti daalɔɠɔma teʋebai zu, é kɔɔi ʋɛɛ ti ʋa Yaɠase. ");
INSERT INTO tod_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kɛlɛ Izilayɛle nuiti ti vɔnini ma, ti ná-zooi pɛ seɠe, é zo ziɛ wolai Aalanɔn ma, nu yeezazu ʋelei, é li ziɛ wolai Yaɓɔke ʋɔ pelei, nu ɠɔʋɛzuʋɛ, eyɛsu é li Amɔn nuiti ta-ɠwɛpelemaʋɛ, folo ɠulazu ʋelei, ná makɛga ɠɛni de kpekpe. ");
INSERT INTO tod_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Izilayɛle Amool nuiti ta-laaiti kpein soni, é zei ti zu, Ɠɛsɛɓon taai la ma mɛɛ, ta maaɠoolii zu geleiti pɛ. ");
INSERT INTO tod_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Mazɔlɔɔ Ɠɛsɛɓon ɠɛni ga taa wola, ʋɛ Amool nuiti ta-masagi Siɠon ɠɛni zeini ná, é zo naama ziɛgi zu ma, é kɔɔi ʋɛɛni la Moaɓe masagi ʋa, é zooi kpein seɠeni, é zeeli ziɛ wolai Aalanɔn ma. ");
INSERT INTO tod_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Naa ɠa é ba, faaɠwɛ nuiti ti boni la, ti ɠɛ ma: «À ʋa Ɠɛsɛɓon! Siɠon ná-taai lo ʋolu, é lo ʋolu! ");
INSERT INTO tod_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Mazɔlɔɔ abui ɠa vukazu, é ɗa ɠula Ɠɛsɛɓon, abuzogi vazaga, é ɗa ɠula Siɠon ná-taazuʋɛ, é Aal ɠala Moaɓe yooi zu, ta Aalanɔn ada ɠaaɠoozagiti maliɠiiti. ");
INSERT INTO tod_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Maanɔɠɔi ɠa è ʋɛ, Moaɓe! È loa ya, Kemɔse ná-nuɓusɛi! È-loun zunuiti ti ʋela. È-loun anzanuiti ti ɠɛa ga Amool nuiti ta-masagi ná-duɔiti, ungo, Siɠon masagi. ");
INSERT INTO tod_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Gi gá-mɛɛinti pilini Amool nuiti ma! Niizu zooi pɛ ge ɠoloɠologa, é zo Ɠɛsɛɓon, eyɛsu é zeeli Diɓon. Eyɛsu é li Nofa, é li ɠite Medeɓa, gi ti kpein koloɠoloni!» ");
INSERT INTO tod_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Zekana Izilayɛle nuiti ti zeini la Amool nuiti ta-yooi zu. ");
INSERT INTO tod_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moize zou zuʋɛtɛ nuiti teʋeni, ti li, ti Yazɛɛl taai ʋɛtɛ. Taaiti kpein ti ɠɛni ba, Izilayɛle nuiti ti naati soni, ti Amool nuiti kpɛ ná. ");
INSERT INTO tod_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Naa ʋolu ti latini, ti li ga Ɓasan ʋele. Ɓasan masagi Wɔge ɠulani, ta ná-kɔɔɠɔ nuiti kpein, ti ti laaɠomi, ti ʋa kɔɔi ʋɛɛ ti ʋa Edeleyi. ");
INSERT INTO tod_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Mina lua tɔun ba, mazɔlɔɔ gè dɔa è yeezu, ta ná-kɔɔɠɔ nuiti kpein, é ʋɛɛ ná-zooi ʋa. Ɗa so, eɠɛʋelei è Amool nuiti ta-masagi Siɠon zoni da, nii é ɠɛni zeini Ɠɛsɛɓon.» ");
INSERT INTO tod_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Izilayɛle nuiti ti Wɔge ʋaani ta ná-doun zunuiti, ta ná-kɔɔɠɔ nuiti kpein. Nu ɠila kpalaa ge la ɠulani. Ti ná-zooi zoni. ");
INSERT INTO tod_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Izilayɛle nuiti ti liini mɔnɔ, ti ʋu Moaɓe nɛmɛi zu ziɛ wolai Zuludɛn folo ɠulazu ʋelei, Zeliko letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Sipɔɔl ná-doun zunui Ɓalake naa kpein kaani, nii Izilayɛle kɛɛni ga Amool nuiti. ");
INSERT INTO tod_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moaɓe nuiti ti wola luani nuɓusɛiti mɔin vai ʋa. Moaɓe nuiti sasuɓalini Izilayɛle nuiti tuɠɔ. ");
INSERT INTO tod_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ti ɓɔɠɔ ɠaani ta Madiyan nuiti ta-ɠundiɠiiti, ti ɠɛ naati ma: «Niima ʋɛbɛ wolai ɠa ʋaazu, ti zooi ta maaɠoolii kpein koloɠolo, eɠɛʋelei nikɛiti ta ɗa tufaiti gaamii la dɔɓɔiti su.» Naama ziɛgi zu Sipɔɔl ná-doun zunui Ɓalake ɠɛni masadai ɠɛɛzu Moaɓe yooi unda. ");
INSERT INTO tod_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","É keelaiti teʋeni Ɓeyɔɔl ná-doun zunui Ɓalaame ma Petɔɔl, ziɛ wolai Efelate ɠobaʋɛ, zooi naa ɠa é zɔlɔɔni su, é ɠɛ naa ma: «Wɛlɛ nuɓusɛiti kulaʋɛ Ezipete! Ti vazaga adaʋɛ pɛ, ti zeiɗa nà-zooi letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Niizu nà è maanɛɛnɛzu ga è ʋa. Niima nuɓusɛiti foovo bɛ̀, mazɔlɔɔ ti-zɛbɛi wɔɔlɔʋɛ nɔ̀nɔi ʋa. Tanisu nà zoo naazu gè vala ti ʋa, gè vɔni ti ma, gè ti ɓɛ, ti ɠula zooi ʋa. Mazɔlɔɔ gè kwɛɛ, zɔi ɗa tuya loo bɛ, tuyai ɠa naa ʋɛ, zɔi ɗa foovo, naa voovooʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Moaɓe ɠɛwolaiti ta Madiyan ɠɛwolaiti ti liini ga lobɛanii, ungaiziɛ vai zu, ti ʋa fe Ɓalaame ya. Ti zeelini Ɓalaame ʋɔ bɛ, ti Ɓalake laawooi wo ma. ");
INSERT INTO tod_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ɓalaame ti wooɠaaʋoteni, é ɠɛ ma: «À yɛ ʋɛ za kpɔkɔi. Lina, nà nà-gooɠaaʋotegi ve wo ya, eɠɛʋelei Ɠɔoɠɔ GALAGI a ɓɔɛ la pɔ̀.» Moaɓe ɠundiɠiiti ti ɲiini pɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","GALA ge ʋaani Ɓalaame ʋɔ bɛ, é gaazaɠa, é ɠɛ ma: «Nui ɓɛgele ɠa ga niiti ti è ʋɔ bɛ?» ");
INSERT INTO tod_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Ɓalaame gooɠaaʋoteni, é ɠɛ ma: «Nuiti be Sipɔɔl ná-doun zunui Ɓalake, Moaɓe masagi ti leʋegai, ga ti ɠɛ mà: ");
INSERT INTO tod_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Nuɓusɛiti ti ɠulaai Ezipete yooi ʋa, niizu ti ʋɛa zooi zu mɛɛ. Ʋa, è ti voovo bɛ̀, tanisu nà zoo naazu gè ti zakpe, gè ti ɓɛ.› » ");
INSERT INTO tod_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kɛlɛ GALA ge ɠɛni Ɓalaame ma: «Mina ʋilɛ ti ʋolu, wo ʋa li. È la niima nuɓusɛiti foovoa, mazɔlɔɔ tuyai ɠa ti ma.» ");
INSERT INTO tod_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Poluma zobui, Ɓalaame liini, é ɠɛ kundiɠiiti ma, niiti Ɓalake ti leʋeni: «À ɠale ma wa-yooi zu, mazɔlɔɔ Ɠɔoɠɔ GALAGI la yeezeini bu ga gè ʋilɛ wo ʋolu.» ");
INSERT INTO tod_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moaɓe zou zu ɠundiɠiiti ti wuzeɠeni, ti ɠale ma Ɓalake ʋɔ bɛ, ti ɠɛni ma: «Ɓalaame la kɛɛni, é ʋa ʋilɛ gi ʋolu, gi ʋa ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Ɓalake kundiɠi ɠiligaa leʋeni, ti mɔin gola, é leʋe ma mɔungi ʋa, ta unfemai veezu ti ʋɛ, é leʋe mɔun keleiti ba. ");
INSERT INTO tod_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ti ʋaani Ɓalaame ʋɔ bɛ, ti ɠɛ ma: «Sipɔɔl ná-doun zunui Ɓalake ɠɛ ma: ‹Soma, è mina ɠɛlɛ, è ʋa è ɓɔ bà. ");
INSERT INTO tod_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Nà è wola wɔɔlɔ, nà naa pɛ kɛ, nii ɗa maaɠaazaɠabo mà. Kɛlɛ kɛni è ʋa, è nuɓusɛi tɛiti foovo bɛ̀.› » ");
INSERT INTO tod_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ɓalaame Ɓalake ná-botiɠɛ nuiti gooɠaaʋoteni, é ɠɛ ti ma: «Anɛɛ ni Ɓalake ɠa ʋaazu ga walii ta zanugi, nii é ná-masa pɛlɛi laavegai, é fe zèa, gè la Ɠɔoɠɔ GALAGI, nà-GALAGI ná-devei tanɔpɛ koloɠologa, ma wola, ɓaa ma go. ");
INSERT INTO tod_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Kɛlɛ tama, wa ɓalaa, à yɛ ʋɛ za kpɔkɔi. Nà pɔ gè naa ɠwɛɛ, nii Ɠɔoɠɔ GALAGI ɠa pɔ é fai ta wo mà dɛ.» ");
INSERT INTO tod_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Kpidii GALA ge ʋaani, é ɠɛ Ɓalaame ma: «Ni niima zunuiti ti ʋaa è lolisu, à li wa tiye. Kɛlɛ mina faa nɔpɛ kɛ, kɛni nii nà bona è ma.» ");
INSERT INTO tod_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ɓalaame wuzeɠeni sobui, é ná-soovale saai maaɠili, ti li ta Moaɓe ɠundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","GALA ge yiiɠaawanani siɛ vai naa zu. Ɠɔoɠɔ GALAGI ná-geezuɠeelai loni pelei zu, é ɓesa tuɠɔ. Ɓalaame ɠɛni ná-soovale saai ɠɔma, ná-botiɠɛ nu felegɔ ʋilɛgai polu. ");
INSERT INTO tod_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Soovale saai geezuɠeelai ɠaani, boɠa zɔkpɔi zea, kulaai maalaɠagi zu, é loni pele zaamaʋɛ. É zeɠeni pelei ʋa, é li ga dɔɓɔi zu ʋele. Ɓalaame tɔɔzeini ga doɠaa, é ʋaa la pelei zu. ");
INSERT INTO tod_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Geezuɠeelai liini, é lo ɠoozama pele zokogi zu, leezɛn ɓeleiti zɔɠɔzu, kɔtu ziɠigi zɔɔla ʋele, é zɔɔla ʋele. ");
INSERT INTO tod_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Soovale saai Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠaani, é ziɠa kɔtu ziɠigi ʋa, é Ɓalaame ɠɔɠɔi ɓata kɔtu ziɠigi ʋa. Naa ɓalaa tɔɔzeini ga doɠaa. ");
INSERT INTO tod_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ɠɔoɠɔ GALAGI ná-geezuɠeelai leʋeni ti ʋa mɔnɔ, é li, é lo pele ɓoɠologi zu, ʋɛ nu la zooga é ʋa leʋe ná, ga nu yeezazu ʋele, ɓaa nu ɠɔʋɛzu ʋele. ");
INSERT INTO tod_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Siɛgi zu soovale saai kaani la, é ʋɛɛni zooi ma, Ɓalaame wu. Ɓalaame yiiɠaawanani, é tɔɔzei ga suloɠaa ga ná-tukpɔi. ");
INSERT INTO tod_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ɠɔoɠɔ GALAGI soovale saai laaʋɛ vieni, é ɓɔɛ Ɓalaame ʋɔ, é ɠɛ ma: «Leeni ɠa gè kɛai ga ɗe, è dòɠa ná zeizu ɠɛa saʋa?» ");
INSERT INTO tod_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Ɓalaame gooɠaaʋoteni, é ɠɛ ma: «Mazɔlɔɔ è ɲɛɛɠulaʋɛ sù. Ee, ni boɠa zɔkpɔ ɠɛni zèa, gè ɠɛa è ʋaazu ɠani nɔ!» ");
INSERT INTO tod_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Soovale saai gooɠaaʋoteni, é ɠɛ ma: «Nà laade gè ʋa ɠɛ ga ɗa-zoovale saai, nii ɗa ɗa zei kɔma yeenɔpɛ? Zekaa nɛi nà ɗa è zo da pɔlɔmazu ɓaa?» É gooɠaaʋoteni, é ɠɛ ma: «Ɓa!» ");
INSERT INTO tod_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Gaamago nɔ, Ɠɔoɠɔ GALAGI Ɓalaame ɠaazuʋɛ zeɠeni ma, é Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠa, é loni pele zaamaʋɛ, ná-boɠa zɔkpɔi zea, kulaai maalaɠagi zu. Ɓalaame ʋilɛni ɲiibiɠa, é nɔkɔ, é unpilɛ zooi ma. ");
INSERT INTO tod_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠɛni ma: «Leeni vaa zu è ɗa-zoovale saai loɠaai ná zeizu ɠɛ saʋa? Nà ɠa pàai, gè pele leʋe è luɠɔ, mazɔlɔɔ siɛi nii è tɔɔzeiɗai, undaaʋili pelei ʋe. ");
INSERT INTO tod_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Soovale saai kàaʋɛ, é màala ná zeizu ɠɛ saʋa. Ni é la ɠɛni màalaani, é ga gè è ʋaa, gè tɔun zɛ vulua.» ");
INSERT INTO tod_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ɓalaame ɠɛni Ɠɔoɠɔ GALAGI ná-geezuɠeelai ma: «Gè gaazaʋɛ, mazɔlɔɔ gè la ɠɛa kwɛɛ ga ɗa loni tùɠɔ pelei zu. Ni siɛi nii wanaʋɛ è ma, gè ɠale ma.» ");
INSERT INTO tod_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ɠɔoɠɔ GALAGI ná-geezuɠeelai ɠɛni ma: «À li wa zunui tɛiti, kɛlɛ kɛni nɔ è ɗa woo ɠilagi nɔ wo, nii nà bo è ma.» Ɓalaame ta kundiɠiiti Ɓalake ti leʋeni, ti ʋilɛni pelei zu, ti ɗa li. ");
INSERT INTO tod_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Siɛgi zu Ɓalake mɛnini da ga Ɓalaame ʋaa, é liini, é daaɠomi Moaɓe taa wolai zu, nii é zou ɠwɛmaʋɛ ɠobaʋɛ, ziɛ wolai Aalanɔn ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ɓalake Ɓalaame ɠaazaɠani, é ɠɛ ma: «Gè la keela mɔungiti teʋeni ɓaa, ga è ʋa? Leeni vaa zu è la ʋaani gaamago nɔ pɔ̀ bɛ? È ɠɛni ɠisiɛzu ga gè la zooga gè ʋa è wɔɔlɔ?» ");
INSERT INTO tod_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Ɓalaame Ɓalake wooɠaaʋoteni, é ɠɛ ma: «Wɛlɛ, gè ʋaa è ʋɔ bɛ. Ɗa kaazu niina ga nà zoo ɓɔɛzu è ʋɔ ɓɔɠɔ ʋɛ ɠana nɔ? Wooi nii GALA ka pu dà, naa nɔ ɠa nà bo è ma.» ");
INSERT INTO tod_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ɓalaame ʋilɛni Ɓalake ʋolu, ti li Kiliyate-Ɠusɔte. ");
INSERT INTO tod_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ɓalake nikɛiti ta baalagiti kulani ga zalaɠai, é Ɓalaame nɔnɔi leʋe ma, ta kundiɠiiti ti yɛni polu, ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Poluma zobui, Ɓalake ʋaani, é Ɓalaame laaɠomi, ti lɛ Ɓamɔte-Ɓaale, ʋɛ é ɠɛni Izilayɛle nuɓusɛi ɠilazuʋɛ ɠaazu ná. ");
INSERT INTO tod_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ɓalaame ɠɛni Ɓalake ma: «Zalaɠa ɠulazu lɔfela lo bɛ̀ ʋɛ, è nikɛ zinɛ lɔfela ta baala sinɛ lɔfela ɠɛʋele ɓɛtɛ bɛ̀ ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Ɓalake naa ɠɛɛni, nii Ɓalaame boni. Ɓalake ta Ɓalaame ti nikɛ zinɛ ɠila ta baala sinɛ ɠila kulani ga zalaɠai, zalaɠa ɠulazuʋɛ ɠilagilagi. ");
INSERT INTO tod_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ɓalaame ɠɛni Ɓalake ma: «Ɠaalɔ, è lo ɗa-ɠala zalaɠai ɠoba. Nà maaɠoozazu, tanisu Ɠɔoɠɔ GALAGI ɠa ʋaazu é dàaɠomi. Nà naama wooi laazeeli è ma, nii a kula kɛlɛma bɛ̀.» É liini gizei ta ma, nii gulu la ma. ");
INSERT INTO tod_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","GALA ge ɠulani kɛlɛma Ɓalaame ʋɛ, naa ɠɛni ma: «Gè zalaɠa ɠulazu lɔfela logɛ, gè nikɛ zinɛi ta baala sinɛi ɠulaʋɛ ga zalaɠai, zalaɠa ɠulazuʋɛ ɠilagilagi.» ");
INSERT INTO tod_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ɠɔoɠɔ GALAGI wooi ʋuuni Ɓalaame la, é ɠɛ ma: «Ɠale ma Ɓalake ʋɔ bɛ, è ɓɔɛ pɔ ɠani.» ");
INSERT INTO tod_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ɓalaame ɠaleni ma Ɓalake ʋɔ bɛ, nii é ɠɛni ná-gala zalaɠai ɠoba, ta Moaɓe ɠundiɠiiti. ");
INSERT INTO tod_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ɓalaame faalaalii nii woni, é ɠɛ ma: «Moaɓe masagi Ɓalake zeɠeʋɛ ga ze Siili yooi zu gizeiti su. É ɠɛ mà: ‹Ʋa, è Zakɔɓe mavofodai voovo bɛ̀! Ʋa, è ɗa-yiiɠaawanai yei Izilayɛle laalɔɠɔma!› ");
INSERT INTO tod_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Nà naa voovoozu ɠale, nii GALA ge la foovooni? Nà yiiɠula ɠale nuɓusɛiti ma, siɛgi zu Ɠɔoɠɔ GALAGI yii la ɠulani la? ");
INSERT INTO tod_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nà yɛsu fasa ɠizeiti unmaʋɛ, gè pɛtɛ, nà yɛna gizeiti unmaʋɛ, gè pɛtɛ, nuɓusɛ ʋe é zeizu yɛ, zɔɠɔzu ɠa ti ʋa ta zii zɔiti. ");
INSERT INTO tod_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ɓɛ ɠa a zoo é Zakɔɓe mavofodai ma ʋɛbɛi ɠaalu, ɓaa é Izilayɛle nu ɓulugi ɠaalu? Gè za, eɠɛʋelei sɔle nui zaa ʋelei la. Gàaɓela ʋelei ɠɛ ga nɔnɔi ɠɛʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Ɓalake ɠɛni Ɓalaame ma: «Leeni ɠa è kɛa ga ze? Gè è zeɠeʋɛ ga è sìli nuiti foovo, wɛlɛ ɗa ba, è ɗa tuya loo ti ʋɛ!» ");
INSERT INTO tod_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","É ɠɛni ma: «Nà ɠɛna ɓɔɛa, gè la naa woga ɓaa, nii Ɠɔoɠɔ GALAGI pua dà?» ");
INSERT INTO tod_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ɓalake ɠɛ ma: «Ʋa pɔ̀ bɛ, de li ada taɠili, ʋɛ ɗa ti ɠa ná. Ɗa ti ɠilazuʋɛ nɔ ɠa, è la ti pɛ kaa, miná ɠa ɗa ti voovo ná nɔ̀un bɛ.» ");
INSERT INTO tod_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","É liini la Sɔfime kpalagaʋɛ, Pizega gizei unmaʋɛ, é zalaɠa ɠulazu lɔfela lo, é nikɛ zinɛ ɠila ta baala sinɛ ɠila kula ga zalaɠai, ti ɠilagilagi maazu. ");
INSERT INTO tod_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Ɓalaame ɠɛni ma: «Lo ʋɛ ɗa-ɠala zalaɠai ɠoba, gè li munu, gè Ɠɔoɠɔ GALAGI laaɠomi.» ");
INSERT INTO tod_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Ɠɔoɠɔ GALAGI ɠulani kɛlɛma Ɓalaame ʋɛ, é wooi ʋu da, é ɠɛ ma: «Ɠale ma Ɓalake ʋɔ bɛ, è ɓɔɛ pɔ ɠani.» ");
INSERT INTO tod_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ɓalaame ɠaleni ma Ɓalake ʋɔ bɛ, naa ɠɛni loni ná-gala zalaɠai ɠobaʋɛ, ta Moaɓe ɠundiɠiiti. Ɓalake ɠɛni ma: «Leeni ɠa Ɠɔoɠɔ GALAGI bogai?» ");
INSERT INTO tod_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ɓalaame faalaalii nii woni, é ɠɛ ma: «Ɓalake wuzeɠe, è woilo! Sipɔɔl ná-doun zunui, woilo gòoi ma! ");
INSERT INTO tod_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","GALA ge la ga nuɓusɛi, é ʋa zɛɛi wo, ɓaa nu vulu, é ʋa zeɠe kpɔɛ wooi ʋa. Nii é bogai, é la naa ɠɛa ɓaa? Toɠa woo wo, é la su vai ɠɛa? ");
INSERT INTO tod_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Wɛlɛ, gè devei zɔlɔɔga ga gè tuya loo, GALA ge tuya loa, gè la seɠezu ma. ");
INSERT INTO tod_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","É la telebotala vaa ɠaani Zakɔɓe ʋa, é la sɔletala vaa ɠaani Izilayɛle nuɓusɛiti ba. Ɠɔoɠɔ GALAGI, é ga ná-GALAGI, naa ɠa tɔun polu, toɠa masadai ma ɠoozunɛɛi zɔlɔɔ ti ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","GALA ge ti ɠulani Ezipete yooi ʋa, suvikɛi ɠulaʋɛ ga teɠui zuvikɛi ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Zoɠolai la ga faa nɔpɛ Zakɔɓe mavofodai ɠaazu, ɓaa ungaiziɛ vai Izilayɛle laalɔɠɔma. Yeeɠɛɠala ʋagɔi ma, toɠa ɗa wo Zakɔɓe ta Izilayɛle ma, nii kpein GALA ge kɛɛzu. ");
INSERT INTO tod_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Niima nuɓusɛiti ta wuzeɠezu eɠɛ zalai, toɠa ɠaalɔsu eɠɛ zalai, é ɗa ná-sua zogai mi, é ɗa ná-sua zogai ma ɲamai ɓɔle, naa ʋoluma ɠa niina a ɗa laa la.» ");
INSERT INTO tod_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ɓalake ɠɛni Ɓalaame ma: «Ni è la ti voovooni, mina tuya loo ti ʋɛ, ga tago ɓalaa.» ");
INSERT INTO tod_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ɓalaame gooɠaaʋoteni, é ɠɛ ma: «Gè la boni è ma ɓaa ga nà naati kpein nɔ ɠɛ, nii Ɠɔoɠɔ GALAGI bosu?» ");
INSERT INTO tod_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ɓalake ɠɛni Ɓalaame ma: «Ʋa deɠɛmu, nà liizu ga ɗe adaʋɛ taɠili, tanisu GALA ka pɛtɛ názu ga ɗa nuɓusɛi niiti foovo nɔ̀un bɛ.» ");
INSERT INTO tod_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ɓalake liini ga Ɓalaame Peyɔɔl gizei unmaʋɛ, nii é zɛlɛni teʋebai maazu. ");
INSERT INTO tod_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Ɓalaame ɠɛni Ɓalake ma: «Zalaɠa ɠulazu lɔfela lo bɛ̀, è nikɛ zinɛ lɔfela ta baala sinɛ lɔfela ɠɛʋele ɓɛtɛ bɛ̀ ʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Ɓalake naa ɠɛɛni, nii Ɓalaame boni. É nikɛ zinɛ ɠila ta baala sinɛ ɠila kulani ga zalaɠai, zalaɠa ɠulazuʋɛ ɠilagilagi. ");
INSERT INTO tod_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ɓalaame pɛtɛni ga nɛɛʋɛ Ɠɔoɠɔ GALAGI ʋɛ ga tuyai loo Izilayɛle ʋɛ, é la mɔ ɠɛni liini kulakɛlɛma ɠili gaiziɛzu, eɠɛ pelegi é ɠɛni kɛɛzu la zɔɔma ziɛgiti su, kɛlɛ é ɠaazu latini teʋebai letema ʋelei. ");
INSERT INTO tod_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","É ɠaazuwuzeɠeni, é Izilayɛle ɠa ʋuuni, eɠɛʋelei ná-bolodaiti ti la. Názu ɠa GALA Zɛnvui yeini la tɔun ma. ");
INSERT INTO tod_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Ɓalaame faalaalii nii laazeelini, é ɠɛ ma: «Ɓeyɔɔl ná-doun zunui Ɓalaame ná-keela wooi ɠaa, zunui nii gaazuzeɠeai ma, ná-keela wooi ɠaa, ");
INSERT INTO tod_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","nui nii é GALA gooiti mɛnisu, naa ná-keela wooi ɠaa, é Zɛbɛi-Pɛ-Maliɠii ná-kulakɛlɛmai ɠaazu, siɛgi zu é loozu la suɠili, gaazuzeɠe ma: ");
INSERT INTO tod_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ee Zakɔɓe, ɗa-zeɠe ɠotaiti wola ʋagɛ, ta è-ɲiizuʋɛti ɓalaa, Izilayɛle! ");
INSERT INTO tod_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ti ɗa yei ga zuviega eɠɛ laasamagiti, eɠɛ kpeleiti, ti ziɛ ɠobaʋɛ, eɠɛ alɔwɛ gului, Ɠɔoɠɔ GALAGI siingai, eɠɛ sɛdele gului, ti ziɛlaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ziɛi ɠa yeizu, é ɗa ɠula seizuʋɛ, ziɛ mɔinmɔingiti ta ná-ani zuwuiti fae. Ná-masagi ɠa zobogi zɔlɔɔ Agage ma, ná-masadai zɛbɛi ɠa wɔɔlɔ. ");
INSERT INTO tod_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","GALA ge kulaʋɛ Ezipete yooi ʋa, teɠui zɛbɛi ɠɛɠalai ɠa é zea, toɠa zobo sɔlɔɔ ziiti ma, ti ga sili nuiti, é ti-ma ɠaeiti golowolo, é ti zɔ ga ná-mɛɛinti. ");
INSERT INTO tod_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Toɠa ɓili, é ʋɛɛ eɠɛ zala zinɛi, eɠɛʋelei zala zaai la, ɓɛ ɠa a kata ga é wuzeɠe? Nui nii a tuya loo è ʋɛ, tuya ɠa naa ʋɛ, nui nii a è voovo, foovooi ɠa naa zo.» ");
INSERT INTO tod_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ɓalake yiiɠaawanani Ɓalaame ma, é yealoɠani, é ɠɛni Ɓalaame ma: «Gè è loligɛ ga è ʋa, è sìli nuiti foovo, wɛlɛ, ná zeizu ɠɛa saʋa, è ɗa tuya loo ti ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Tɛi é ɠɛa ɠana, liina ɗa-yooi zu! Gè boni ga nà faanɛɛ mɔinmɔin kɛ è ʋɛ, kɛlɛ Ɠɔoɠɔ GALAGI è ʋalagɛ faanɛɛiti sɔlɔɔ fai ma.» ");
INSERT INTO tod_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Ɓalaame Ɓalake wooɠaaʋoteni, é ɠɛ ma: «Gè ɓɔɛni ɠani keelaiti pɔ, è ti leʋeni mà: ");
INSERT INTO tod_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Anɛɛ ni Ɓalake ɠa ʋaazu ga walii ta zanugi, nii é ná-masa pɛlɛi laavegai, é fe zèa, gè la zooga faa nɔpɛ kɛɛzu ga ma ʋagɔ, ɓaa ma ɲɔu, Ɠɔoɠɔ GALAGI ná-devei laalɔɠɔma. Nà naa nɔ wo, nii Ɠɔoɠɔ GALAGI a bo mà.› ");
INSERT INTO tod_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Niizu nà ga li nà-nuɓusɛiti pɔ. Ʋa, nà naa lɛɛzu ga ɗe, nii Izilayɛle nuɓusɛiti ti ʋaazu kɛɛzu ga ɗa-nuɓusɛiti, yeeɠɛɠalaiti su ti ʋaazu.» ");
INSERT INTO tod_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ɓalaame faalaalii nii laazeelini, é ɠɛ ma: «Ɓeyɔɔl ná-doun zunui Ɓalaame ná-keela wooi ɠaa, zunui nii gaazuzeɠeai ma, ná-keela wooi ɠaa, ");
INSERT INTO tod_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","nui nii é GALA gooiti mɛnisu, naa ná-keela wooi ɠaa, nii é Anii-Pɛ-Unda ná-faaɠwɛgiti feai zea, é Zɛbɛi-Pɛ-Maliɠii ná-kulakɛlɛmai ɠaazu, siɛgi zu é loozu la suɠili, gaazuzeɠe ma: ");
INSERT INTO tod_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nà pɛtɛsu, kɛlɛ niizu laade dɛ, nà sumɔsu, kɛlɛ maa la dɛ ɓuɠani, ʋelela ʋelei, somideɠai ta ɠa ɠulazu Zakɔɓe mavofodai zu, masadai ma lukpɔi ɠa ɠɛ Izilayɛle zaama, nii a ɠɛ Moaɓe nuiti goizuloɠazu, toɠa Sɛte ná-doun zunuiti kpein doɠa tɔungi zu. ");
INSERT INTO tod_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Toɠa Edɔme yooi zo, é ɠɛ ga nɔnɔ, sili nuiti su, Seyiil yooi ɠa zo, Izilayɛle ɠa ná-zeeɠaaɓaai lɛ. ");
INSERT INTO tod_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Nui nii é ɠulazu Zakɔɓe mavofodai zu, naa ɠa masadai ɠɛ, toɠa naati undaaʋili, niiti ti ʋelazu, ti ɠula taaiti ba.» ");
INSERT INTO tod_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ɓalaame Amalɛke ɠaani. É faalaalii nii laazeelini, é ɠɛ ma: «Amalɛke ɠa é ga ziiti pɛ ti-ma mɔungi. Kɛlɛ gaaɓelasu, toɠa ɠoloɠolosu.» ");
INSERT INTO tod_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","É Ken nuiti kaani. É faalaalii nii laazeelini, é ɠɛ ma: «È-zeizuʋɛ logɛ kpe, è-laɠagi logɛ fasa ɠizei ma. ");
INSERT INTO tod_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Kɛlɛ Ken nuiti ta ɠɛ ga abui laamianigi. Gaaɓelasu, Asuul nuiti ta li ga woye, ti wo ɠɛ ga kasoɠa nuiti.» ");
INSERT INTO tod_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Gaaɓelasu, é faalaalii nii laazeelini, é ɠɛ ma: «Ee, maanɔɠɔi nii é ʋaazu! Ɓɛ ɠa a yɛ vulua GALA ná-kɛɛwotii luɠɔ? ");
INSERT INTO tod_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Kɛlɛ keingiti ti ziɛi ɠa, ti ʋaazu, ti zeɠe Kitime, ta Asuul nuiti maanɔɠɔ, ti Eɓɛɛl nuiti maanɔɠɔ. Tɔ ɓalaa toɠa liizu undaaʋiligi zu.» ");
INSERT INTO tod_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ɓalaame liini, é ɠale ma ná-zooi zu. Ɓalake ɓalaagi liini ga ʋɔ pelei. ");
INSERT INTO tod_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Izilayɛle nuiti ti zeini Sitime. Nuɓusɛiti ti tɔɔzeini ga ɓɔɠɔ lɔa koloɠologi zu, ta Moaɓe anzanu lointi. ");
INSERT INTO tod_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Naati ti ti lolini ga ti zalaɠai ɠula ta-ɠalagiti bɛ. Nuɓusɛiti ti vaani bu, ti zalaɠa laamii wo, ti nɔkɔ naati ta-ɠalagiti bu. ");
INSERT INTO tod_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ti ʋɔɔpɛɛni naati ta-ɠalagi Ɓaale-Peyɔɔl lɛbi vai ʋa. Naama vai Ɠɔoɠɔ GALAGI yiiɠaawanani ti laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nuɓusɛiti kpein gaalɛ ba, è ta-ɠundiɠiiti sɛlɛ guluiti ba, foloi ɠa, gàazu, naa ɠa a kɛ nà-ziiɠaawanai zeɠe Izilayɛle maala.» ");
INSERT INTO tod_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moize ɠɛni Izilayɛle lukpɔɠaaleʋe nuiti ma: «Wo ɠilagilagi ná-nuiti paa, niiti ti ʋɔɔpɛai Ɓaale-Peyɔɔl lɛbi vai ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Zunu ɠila ge ɠɛni Izilayɛle nuiti saama, é ʋaani ga Madiyan anzanu ɠila kɛɛɠɛlointi saama, Moize ta Izilayɛle ʋɛbɛi kpein gaazu, naazu naati ti ɗa wɔlɔ, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Zalaɠa ɠula nui Aalɔn ná-doun zunui Eleazaal ná-doun zunui Fineyase naama vai ɠaai ma, é wuzeɠeni bɛbɛi zaama, é kpɛɛin zeɠe, ");
INSERT INTO tod_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","é ʋilɛ Izilayɛle zunui ʋolu ná-seɠe ɠotai wu, é ti felegɔ pɛ sɔ ʋɔɔma, kpɛɛin zunui volokula, é anzanui zo kobuʋɛ. Naazu maanɔɠɔ vai ɓeni Izilayɛle nuiti saama. ");
INSERT INTO tod_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Nu waaʋuufelegɔ maazu naanigɔ (24.000) ɠa é zaani maanɔɠɔi naa zu. ");
INSERT INTO tod_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Zalaɠa ɠula nui, Aalɔn ná-doun zunui Eleazaal ná-doun zunui Fineyase ɠa é nà-ziiɠaawanai zeɠea Izilayɛle nuiti maala, nà-ziizoolɛi ɠa é ma ti zaama, naa ɠa é kɛa, nɛ̀i gè ga GALAGI, nà pɔ ga ti nà ɠila nɔ dɛ̀bi, nà-ziiɠaawanai zu, gè la mɔ Izilayɛle nuiti ma zuwu ɠaaleʋeni. ");
INSERT INTO tod_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Naa ɠa é ba, ɗa ɠɛ ma: ‹Gè minazeɠegi ɠɛa tɔun bɛ, nii a ɠɛ ga ziilɛigi ma ungi. ");
INSERT INTO tod_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Toɠa ɠɛ ga tɔun nɔnɔ, ta mavofodaiti. Zalaɠa ɠula wotii ɠa ɠɛ ga tɔnɔ, yeeɠɛɠalai pɛ su, tɔɔzei é ná-ziizoolɛi ɠulaʋɛ kɛlɛma ná-GALAGI ʋɛ, é koto gba vai ɠɛɛʋɛ Izilayɛle nuiti ta-vaa zu.› » ");
INSERT INTO tod_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Izilayɛle zunui ti paani ta Madiyan anzanui ʋɔɔma, daaseigi ɠɛni ga Zimili, Salu ná-doun zunui. É ɠɛni ga Simiyɔn ná-pɛlɛyeɠe ɠundiɠii ta. ");
INSERT INTO tod_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Madiyan anzanui nii ti paani, daaseigi ɠɛni ga Koziɓi, kɛɛɠɛ laaseigi ɠɛni ga Suul, nii é ɠɛni ga bolodama mɔinmɔin ma ɠundiɠii, kulaai bolodai gila su Madiyan yooi zu. ");
INSERT INTO tod_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Vala Madiyan nuiti ba, è ti-ma zuwu ɠaaleʋe. ");
INSERT INTO tod_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Mazɔlɔɔ ti ɠɛni ga wo zili nuiti, ti laavegai ga keleɠele ɲɔi, Peyɔɔl ná-fai zu, ta Koziɓi, nii é ɠɛni ga Madiyan ɠundiɠii ta ná-doun anzanui, nii é zaani ga maanɔɠɔi, tɔɔzei Peyɔɔl ná-fai ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU25_19","005_25_19","NUM","25","19","19","Maanɔɠɔ vai naa leʋega ʋoluma, ");
INSERT INTO tod_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ɠɔoɠɔ GALAGI ɠɛni Moize ta zalaɠa ɠula nui Eleazaal ma, nii é ga Aalɔn ná-doun zunui: ");
INSERT INTO tod_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«À Izilayɛle ʋɛbɛi kpein gaalu, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, Izilayɛle nuiti kpein su, niiti ta zoo ti li kɔɔmaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moize ta zalaɠa ɠula nui Eleazaal, ti ɓɔɛni ti ʋɔ Moaɓe nɛmɛi zu, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ, ti ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Ada ʋaazu gaalugi wosu, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya.» Izilayɛle nuɓusɛiti pɛtɛ, niiti ti ɠulani Ezipete yooi ʋa: ");
INSERT INTO tod_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Izilayɛle nii daa ga Zakɔɓe, ná-doun zunu mɔungi é sɔlɔɔni, daaseigi ɠɛni ga Luɓɛn. Luɓɛn ná-doun zunuiti ti-mavofodaiti, ti ɠɛni ga: Enɔke mavofodaiti, Palu mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Ɠɛsɛlon mavofodaiti, ta Kaalemi mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Luɓɛn mavofodaiti tiegɔi ɠɛni ga zunu waaʋuunaani maazu saʋagɔ undɔfela puusaʋagɔ (43.730). ");
INSERT INTO tod_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu ná-doun zunui ɠɛni ga Eliyaɓe. ");
INSERT INTO tod_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Naa ɠa é ɠɛni ga Nemuwɛle kɛɛɠɛ, ta Datan, ta Aɓilame. Datan naa, ta Aɓilame ti ɠɛni ga kundiɠiiti bɛbɛi untuɠɔ, ti wuzeɠeni Moize ta Aalɔn laalɔɠɔma, ta Kolé ná-nu ɓulugiti, siɛgi zu ti wuzeɠeni la Ɠɔoɠɔ GALAGI laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Zooi laaʋalini, é ti maalɔɔɠu, ta Kolé, siɛgi zu ná-nu ɓulugiti ti zaani la, ta siɛgi zu abui zunu unfelegɔ puulɔɔlugɔ (250) ɠalani la. Ti ɠɛni nuɓusɛiti bɛ ga kizɛsu vai. ");
INSERT INTO tod_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kɛlɛ Kolé ná-doun zunuiti ti la ɠɛni zaani. ");
INSERT INTO tod_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simiyɔn ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Nemuwɛle mavofodaiti, Yamin mavofodaiti, Yakin mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zela mavofodaiti, ta Sayile mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simiyɔn mavofodaiti tiegɔi ɠɛni ga zunu waaʋuufele maazu fele unfelegɔ (22.200). ");
INSERT INTO tod_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gade ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Sefon mavofodaiti, Ɠagi mavofodaiti, Suni mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Wozeni mavofodaiti, Eli mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Alode mavofodaiti, ta Aleli mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Gade mavofodaiti tiegɔi ɠɛni ga zunu waaʋuunaanigɔ undɔɔlugɔ (40.500). ");
INSERT INTO tod_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Zuda ná-doun zunuiti ti ɠɛni ga Ɛɛl ta Wonan. Ɛɛl ta Wonan ti zaani Kanaan yooi zu. ");
INSERT INTO tod_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Zuda ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Sela mavofodaiti, Pelɛze mavofodaiti, ta Zela mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Pelɛze ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Ɠɛsɛlon mavofodaiti ta Ɠamule mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Zuda mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔfela maazu lɔzita undɔɔlugɔ (76.500). ");
INSERT INTO tod_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isakaal ná-doun zunuiti, eɠɛʋelei ta-wolodamaiti ti la, ti ɠɛni ga: Tola mavofodaiti, Puva mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasuɓe mavofodaiti, ta Similon mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isakaal mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔzita maazu naani unsaʋagɔ (64.300). ");
INSERT INTO tod_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zaɓulɔn ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Selɛde mavofodaiti, Elon mavofodaiti, ta Yaleyɛle mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Zaɓulɔn mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔzita undɔɔlugɔ (60.500). ");
INSERT INTO tod_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Zozɛfe ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Manasé ta Efelayime. ");
INSERT INTO tod_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasé ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Makiil mavofodaiti, Galaade mavofodaiti, nii é ɠɛni ga Makiil ná-doun zunui. ");
INSERT INTO tod_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galaade ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Yezɛɛl mavofodaiti, Ɠelɛke mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asaliyɛle mavofodaiti, Sikɛme mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida mavofodaiti, ta Ɠefɛɛl mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Ɠefɛɛl ná-doun zunui Selofeɠade la ɠɛni doun zunua zɔlɔɔni, kɛlɛ é doun anzanuiti sɔlɔɔni, ti-laaseigiti kaa: Maala, Noa, Wogela, Milika ta Tiilesa. ");
INSERT INTO tod_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Manasé mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔɔlugɔ maazu felegɔ undɔfela (52.700). ");
INSERT INTO tod_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efelayime ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Sutela mavofodaiti, Ɓekɛɛl mavofodaiti, ta Taɠan mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Elan mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efelayime mavofodaiti tiegɔi ɠɛni ga zunu waaʋuusaʋagɔ maazu felegɔ undɔɔlugɔ (32.500). Zozɛfe ná-doun zunuiti kana, eɠɛʋelei ti-mavofodaiti ti la. ");
INSERT INTO tod_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ɓɛnzamɛn ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Ɓela mavofodaiti, Asaɓɛle mavofodaiti, Ayilame mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sufame mavofodaiti, ta Ɠufame mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ɓela ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Aalede mavofodaiti ta Naaman mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ɓɛnzamɛn mavofodaiti tiegɔi ɠɛni ga zunu waaʋuunaani maazu lɔɔlugɔ undɔzita (45.600). ");
INSERT INTO tod_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Suɠame mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Suɠame mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔzita maazu naanigɔ unnaanigɔ (64.400). ");
INSERT INTO tod_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asɛɛl ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Yimina mavofodaiti, Yisivi mavofodaiti, ta Ɓelia mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Ɓelia ná-doun zunuiti ti-mavofodaiti ti ɠɛni ga: Ɠeɓɛɛl mavofodaiti ta Malekiyɛle mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Anzanu loun ɠɛni Asɛɛl ya, daaseigi ɠɛni ga Sela. ");
INSERT INTO tod_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asɛɛl mavofodaiti tiegɔi ɠɛni ga zunu waaʋuulɔɔlugɔ maazu saʋagɔ unnaanigɔ (53.400). ");
INSERT INTO tod_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Nɛfɛtali ná-doun zunuiti, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Yaseyɛle mavofodaiti, Guni mavofodaiti, ");
INSERT INTO tod_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yesɛɛl mavofodaiti, ta Sileme mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Nɛfɛtali mavofodaiti tiegɔi ɠɛni ga zunu waaʋuunaanigɔ maazu lɔɔlugɔ unnaanigɔ (45.400). ");
INSERT INTO tod_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Izilayɛle nuiti tiegɔi ɠɛni ga zunu waaundɔzita maazu ɠila undɔfela puusaʋagɔ (601.730). ");
INSERT INTO tod_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Zooi ɠaaɠwɛ bolodaiti ba, é zoloo nuiti tiegɔiti ma. ");
INSERT INTO tod_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Bolodaiti ti mɔinɗai, ɗa zooi ve ti ya ga bɔɔlɔa, niiti ti lɔiɗai, è zooi tago ve ti ya. Ɛsɛ gilagilagi ná-zooi ɠa ve zea, é zoloo ti-liegɔi ma. ");
INSERT INTO tod_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Kɛlɛ zooi ɠaa ɠa ɠwɛ ga kpakutoomai. Ta ti zɔlɔɔ ga tɔnɔ, eɠɛʋelei ti-ɠɛɛni ta-wolodaiti daaseigi la. ");
INSERT INTO tod_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Zooi ɠaa ɠa ɠwɛ ga kpakutoomai, naati zɔɠɔzu, niiti ti wola mɔinɗai, ta niiti ti wola la mɔinni.» ");
INSERT INTO tod_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levi nuiti, ti ɠaaluni, eɠɛʋelei ti-mavofodaiti ti la, ti ɠɛni ga: Gɛɛlɛson mavofodaiti, Keɠate mavofodaiti, ta Melali mavofodaiti. ");
INSERT INTO tod_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi mavofodaiti ti ɠɛni ga: Liɓini mavofodaiti, Eɓelɔn mavofodaiti, Maali mavofodaiti, Musi mavofodaiti, ta Kolé mavofodaiti. Keɠate Amalame zɔlɔɔni. ");
INSERT INTO tod_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amalame anzai laaseigi ɠɛni ga Yokeɓɛde, Levi ná-doun anzanui, nii é zɔlɔɔni Levi ʋɛ Ezipete yooi zu. É dounɠa zɔlɔɔni Amalame ʋɛ ga Aalɔn ta Moize, ta Miliyame, nii é ɠɛni ga ti-ʋaazeelai. ");
INSERT INTO tod_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Niiti ti zɔlɔɔni Aalɔn ʋɛ ti ɠɛni ga Nadaɓe, Aɓiyu, naa ʋɛɛ Eleazaal ʋa, ta Itamaal. ");
INSERT INTO tod_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadaɓe ta Aɓiyu ti zaani, naa ɠɛni siɛgi zu ti ʋaani la ga abu ɠiligi Ɠɔoɠɔ GALAGI ɠakala. ");
INSERT INTO tod_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Niiti ti ɠaaluni, zunuiti kpein é zo alu gila ma, é lɛ zeemaazu, zunuiti ta zunu lointi, ti ɠɛni ga zunu waaʋuufele maazu saʋagɔ (23.000). Ti la ɠɛni ti ʋɛɛni Izilayɛle nuiti ba, ti ʋa ti ɠaalu, mazɔlɔɔ zou la ɠɛni veeni ti ya Izilayɛle nuiti saama. ");
INSERT INTO tod_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Naati ka Moize ta Eleazaal ti ti ɠaaluni Moaɓe nɛmɛiti su, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Niiti kpein Moize ta zalaɠa ɠula nui Aalɔn ti ti ɠaaluni Sinayi teʋebai zu, naa tanɔpɛ ge la mɔ ɠɛni niiti saama. ");
INSERT INTO tod_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Mazɔlɔɔ Ɠɔoɠɔ GALAGI ɠɛni ti ma: «Ta zaazu teʋebai zu.» Gila kpalaa ge la ɠɛni yɛni vulua, é ɠula Yefuné ná-doun zunui Kalɛɓe ʋolu, ta Nun ná-doun zunui Zozuwe. ");
INSERT INTO tod_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Anzanu loun lɔɔlugɔ ɠɛni ná, ti-laaseigi ga: Maala, Noa, Wogela, Milika, ta Tiilesa. Ti-ɠɛɛ laaseigi ɠɛni ga Selofeɠade, Ɠefɛɛl ná-doun zunui, nii mɛmɛwolani ti ɠɛni ga Galaade, ta Makiil, ta Manasé, ta Zozɛfe. Anzanui naati ka ti ʋaani, ");
INSERT INTO tod_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ti lo Moize ɠakala, ta Eleazaal, ta kundiɠiiti, ta bɛbɛi kpein, GALA daaɠomi seɠe ʋɛlɛi laaʋɛ, ti ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Gi-ɠɛɛ zaaʋɛ teʋebai zu, kɛlɛ é la ɠɛni naati ta-ɓɔgi zu, niiti ti wuzeɠeni Ɠɔoɠɔ GALAGI laalɔɠɔma, Kolé ná-nu ɓulugiti, kɛlɛ é zaani ga kpɔɠɔ ɠotoi maaʋele, doun zunu la ɠɛni zea. ");
INSERT INTO tod_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Leeni vaa zu gi-ɠɛɛ laaseigi a ɠula ná-bolodai zaama, tɔɔzei doun zunu ʋalagi maaʋele ma? Gi-ʋɔɔda ve, gi-ɠɛɛ kɛɛɠɛlointi saama.» ");
INSERT INTO tod_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moize liini ga ti-maavai Ɠɔoɠɔ GALAGI ɠakala. ");
INSERT INTO tod_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Gaamai ɠa Selofeɠade ná-doun anzanuiti ti bosu. Ɗa zooi ve ti ya, é ɠɛ ga tɔnɔi, ti-ɠɛɛ kɛɛɠɛlointi saama. Tiya ɠa ɗa ti-ɠɛɛ nɔnɔi leʋe ti ʋɔ. ");
INSERT INTO tod_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ɗa ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu zunui ta zaazu la, é la doun zunu yɛni, wa ná-poganii ve ná-doun anzanui ya. ");
INSERT INTO tod_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ni doun anzanu la zea, wa ná-poganii ve kɛɛɠɛlointi zea. ");
INSERT INTO tod_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ni kɛɛɠɛlounɠa ti la bɛ, wa ná-poganii ve kɛɛɠɛ kɛɛɠɛlointi zea. ");
INSERT INTO tod_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ni kɛɛɠɛlounɠa ti la kɛɛɠɛ ʋɛ, wa ná-poganii leʋe ná-nu ɠiteɠitegi ta ʋɔ bolodai zu, naa ɠa a yɛ zea. Toɠa ɠɛ ga devei ta tɔgi Izilayɛle nuiti bɛ, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya.» ");
INSERT INTO tod_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Lɛ Aɓalime ɠizei nii ma, è wɛlɛ zooi ʋa, gè feezu Izilayɛle nuiti bɛ. ");
INSERT INTO tod_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ɗa wɛlɛzu ba, kɛlɛ ɗa ɓalaagi ɗa zaazu, è li è-mɛmɛwolani pɔ, ti zaai, eɠɛʋelei è-ɠɛɛloin Aalɔn zaani la, é li mɛmɛwolani pɔ ti zaai. ");
INSERT INTO tod_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Mazɔlɔɔ wo ɠɛɛʋɛ ga kololala nuiti nà-devei laalɔɠɔma, Sin teʋebai zu, siɛgi zu bɛbɛi zu nuɓusɛiti ti maaɠaalii ɠɛɛni la, ti kpɔɛi ʋɛɛ bà. Wo la ɠɛni nà-ɲadedai maawuini nuɓusɛiti gaazu, é lo ziɛi vai ʋa, ti ɠɛni maalolisu.» (Naa ɠɛni ga Meliɓa ɗɛi ná-fai é ɠɛni Kadɛse, Sin teʋebai zu.) ");
INSERT INTO tod_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moize ɓɔɛni Ɠɔoɠɔ GALAGI ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Ɠɔoɠɔ GALAGI é ga kpusɛi kpein ta-zɛnvuiti ta-ƓALAGI, ɗa ɓɔɠɔi yiimazeɠe ga nu, è sei bɛbɛi unda, é ɠɛ ga kundiɠii, ");
INSERT INTO tod_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","nui nii a ɠɛ losu ti untuɠɔ kɔɔɠɔzuʋɛti, é ɗa li ga tiye, é ɗa ʋa ga tiye, nii a kɛ Ɠɔoɠɔ GALAGI ná-nuɓusɛiti ti mina ɠɛ eɠɛʋelei baalagiti ti la, ti makɛ nu la ná.» ");
INSERT INTO tod_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: «Nun ná-doun zunui Zozuwe zeɠe, zunu ʋe nii zɛnvui zeini su, ɗa yeela ma. ");
INSERT INTO tod_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ɗa lii la, è sei zalaɠa ɠula nui Eleazaal ɠakala, ta bɛbɛi kpein, è deveiti fe zea ti ɠaazu. ");
INSERT INTO tod_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ɗa ɗa-ɠundiɠilai ma zobogi ta ve zea, naa ɠa a kɛ Izilayɛle ʋɛbɛi ɠolo bɛ. ");
INSERT INTO tod_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Toɠa zei zalaɠa ɠula nui Eleazaal ɠakala, naa ɠa ɗa gàazaɠa tɔun bɛ, ga anii nii daaseigi ga wuulimegi. Nii nɔpɛ a bona, ʋele ɠana Zozuwe ta Izilayɛle nuɓusɛiti ta ta-ɠɔɔɠɔ vaiti so da.» ");
INSERT INTO tod_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moize kɛɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. É Zozuwe zeini zalaɠa ɠula nui Eleazaal ɠakala, ta bɛbɛi kpein. ");
INSERT INTO tod_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","É yeeiti daani ma, é deveiti fe zea, eɠɛʋelei Ɠɔoɠɔ GALAGI boni la ma. ");
INSERT INTO tod_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Niima levei laazeeli Izilayɛle nuiti ma, è ɠɛ ti ma: Wa dama kpɛ, wo nɔ̀nɔ ma vebɛanii ve, yeeɠɛɠala ʋagɔi zu, é ga nà-zalaɠaiti, daamianigiti ti ɠalazu abui ɠa, ti bɛ̀ ga ani maku nɛai. ");
INSERT INTO tod_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ɗa ɠɛ ti ma: Folo-o-folo, wa kona gila baala sinɛ felegɔ ɠula, nii nɛɛʋuzu la ba, Ɠɔoɠɔ GALAGI ʋɛ ga gala zalaɠai, nii abui galazu. ");
INSERT INTO tod_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ɗa baala ziʋoi ɠilagi ɠula ga zalaɠai sobui, è zɔɔma ʋaala ziʋoi ɠula ga zalaɠai kpɔkɔi, ");
INSERT INTO tod_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","naa ʋɛɛ vebɛ zalaɠai ʋa, nii é ga ɓulu vukɔ ʋagɔi kilo saʋagɔ, gaayɔgai ga wolive wulɔ ʋagɔi litɛlɛ ɠila ta tukpɛ (1,5). ");
INSERT INTO tod_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Gala zalaɠai ɠana, folo-o-folo, nii é ɠɛɛzu ɠulazu, eɠɛʋelei deveai la Sinayi gizei ma. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Wa puya zalaɠai ɓɔ baala ziʋo mɔungi ʋa, ga dɔɔ ɓaagi litɛlɛ ɠila ta tukpɛ (1,5), ada ɲadegai zu ɠa wa puya zalaɠai naa ɠula ná, ga dɔɔ ɓaagi Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Baala ziʋoi velesiɛi ɠa ɠula ga zalaɠai kpɔkɔi, vebɛ zalaɠai ta puya zalaɠai, niiti ti ɓɔgai sobu gelei ʋa, naa ma ziiti nɔ ɓɔ ba. Zalaɠai ʋe, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Dooɠo foloi, wa baala ziʋo felegɔ ɠula ga zalaɠai, niiti ti kona gila nɔ ɠɛa, nɛɛʋuzu nɔpɛ ge la ba, è vebɛ zalaɠai ʋu ma ga ɓulu vukɔ ʋagɔi kilo lɔzita, gaayɔgai ga gulɔi, puya zalaɠai ʋu ma. ");
INSERT INTO tod_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Wa gala zalaɠai naa ɠula dooɠo foloi ɠilagilagi. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Alugi laaɠulazuʋɛ, wa nikɛ zinɛ ɓokpa felegɔ ɠula ga gala zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ta baala sinɛ ɠila, ta kona gila baala sinɛ lɔfela, nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ɠilagilagi ʋɛ, ta kilo lɔzita baala sinɛi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. Gala zalaɠai ʋe, zalaɠai nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Puya zalaɠaiti ta ɠɛɛzu ga dɔɔi litɛlɛ saʋagɔ, é ʋɛɛ nikɛ zinɛ ɠilagi ʋa, litɛlɛ felegɔ ʋɛɛ baala sinɛi ʋa, ta litɛlɛ ɠila ta tukpɛ (1,5) ge ʋɛɛ baala ziʋoi ʋa. Gala zalaɠaiti kana, ta ɠɛ ɠulazu alugi laaɠulazuʋɛ, alu-o-alu, konagi zu. ");
INSERT INTO tod_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai Ɠɔoɠɔ GALAGI ʋɛ. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«Alu mɔungi ma volo puugɔ maazu naanisiɛi (14) ɠa ɠɛɛzu ga Ɠɔoɠɔ GALAGI ná-Pakegi. ");
INSERT INTO tod_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","«Alugi naa ma volo puugɔ maazu lɔɔlusiɛi (15) ɠa fɛtii lɔɔzeizu ma. Ɓului nii lɛʋɛ la su, naa ɠa wa ɠɛ miizu eyɛsu folo lɔfela. ");
INSERT INTO tod_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Folo mɔungi, wa gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la, ");
INSERT INTO tod_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","wa nikɛ zinɛ ɓokpa felegɔ ɠula ga gala zalaɠai Ɠɔoɠɔ GALAGI ʋɛ, ta baala sinɛ ɠila, ta kona gila baala sinɛ lɔfela, nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ɠilagilagi ʋɛ, ta kilo lɔzita baala sinɛi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Wa boli zinɛ ɠila kula ga koto gba zalaɠai, naa ɠa a kɛ koto gba vai ɠɛ wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Naati kpein ta laazu gala zalaɠai maazu, é ɠulazu sobu-o-sobu. ");
INSERT INTO tod_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Folo-o-folo, folo lɔfela laawu, wa naama laamianigiti kula, nii abui galazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. Wa ti ɠula ga zalaɠai, é ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Foloi lɔfelasiɛi, wa gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Zooi ʋaalɔnɔ mɔungiti ma ɠoozunɛ voloi, wo ʋaazu vebɛ zalaɠai veezu la Ɠɔoɠɔ GALAGI ʋɛ, ga ani niinɛiti, dɔɔɠɔiti ma vɛtii, wa gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Wa nikɛ zinɛ ɓokpa felegɔ ɠula ga gala zalaɠai, ta baala sinɛ ɠila, ta kona gila baala sinɛ lɔfela, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ɠilagilagi ʋɛ, ta kilo lɔzita baala sinɛi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Wa boli zinɛi ɠula ɓalaa, naa ɠa a kɛ koto gba vai ɠɛ wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Wa suai niiti kula, nɛɛʋuzu mina ɠɛ ti ʋa, ta ta-ʋuya zalaɠaiti. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛanii. ");
INSERT INTO tod_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Alugi lɔfelasiɛi ma volo mɔungi, wa gaalɛba ɲadegai wo. Wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. Toɠa ɠɛ wo ʋɛ ga puʋu fɛɛ yeei. ");
INSERT INTO tod_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Wa nikɛ zinɛ ɓokpa gila kula ga gala zalaɠai, ta baala sinɛ ɠila, ta kona gila baala sinɛ lɔfela, nɛɛʋuzu mina ɠɛ ti ʋa, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ʋɛ, ta kilo lɔzita baala sinɛi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Wa boli zinɛ ɠila kula ga koto gba zalaɠai, naa ɠa a kɛ koto gba vai ɠɛ wo ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Naama zalaɠaiti ta ɓɔ gala zalaɠaiti ba, niiti ti ɠulazu alu-o-alu ta folo-o-folo, ta ta-vebɛ zalaɠaiti, ta ta-ʋuya zalaɠaiti, eɠɛʋelei deveai la tɔgi zu ta-vaa zu. Zalaɠaiti be, niiti abui ti ɠalazu, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Alugi lɔfelasiɛi ma volo puugɔi ma, wa gaalɛba ɲadegai wo. Wa zugi zo, wo la boti nɔpɛ kɛa. ");
INSERT INTO tod_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Wa nikɛ zinɛ ɓokpa gila kula ga gala zalaɠai, ta baala sinɛ ɠila, ta kona gila baala sinɛ lɔfelaiti, nɛɛʋuzu mina ɠɛ ti ʋa, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ʋɛ, ta kilo lɔzita baala sinɛi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ koto gba zalaɠai ʋa, nii é ɠulazu koto gba voloi, ta gala zalaɠai, nii é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ta-ʋuya zalaɠaiti. ");
INSERT INTO tod_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Alugi lɔfelasiɛi ma volo puugɔ maazu lɔɔlusiɛi (15) ma, wa gaalɛba ɲadegai wo, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. Wa fɛtii ɠula Ɠɔoɠɔ GALAGI lɛbi vai ma, wa naa ɠɛ folo lɔfela laawu. ");
INSERT INTO tod_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Wa nikɛ zinɛ ɓokpa puugɔ maazu saʋagɔ (13) ɠula ga gala zalaɠai, ta boli zinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Wa vebɛ zalaɠai ʋɛɛ gala zalaɠa zuaiti ba, toɠa ɠɛ ga ɓulu vukɔ ʋagɔi, gaayɔgai ga gulɔi: kilo taaʋuugɔ nikɛ zinɛi ɠilagilagi ʋɛ, ta kilo lɔzita baala sinɛi ɠilagilagi ʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ta kilo saʋagɔ baala ziʋoi ɠilagilagi ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","«Foloi velesiɛi ma, wa nikɛ zinɛ ɓokpa puugɔ maazu felegɔ (12) ɠula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","«Foloi zaʋasiɛi ma, wa nikɛ zinɛ puugɔ maazu ɠila (11) kula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","«Foloi naanisiɛi ma, wa nikɛ zinɛ puugɔ ɠula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","«Foloi lɔɔlusiɛi ma, wa nikɛ zinɛ taaʋuugɔ ɠula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","«Foloi lɔzitasiɛi ma, wa nikɛ zinɛ lɔsaʋa ɠula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","«Foloi lɔfelasiɛi ma, wa nikɛ zinɛ lɔfela ɠula ga zalaɠai, ta baala sinɛ felegɔ, ta kona gila baala sinɛ puugɔ maazu naanigɔ (14), nɛɛʋuzu mina ɠɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","«Foloi lɔsaʋasiɛi ma, wa GALA dɛbi ɠaalɛbai wo. Naama voloi, wo la boti nɔpɛ kɛa, eɠɛʋelei wa ɗa kɛ la. ");
INSERT INTO tod_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Wa nikɛ zinɛ ɠila kula ga gala zalaɠai, baala sinɛ ɠila, ta kona gila baala sinɛ lɔfela, nɛɛʋuzu mina ɠɛ ti ʋa, makugi nɛai Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Wa vebɛ zalaɠaiti ta puya zalaɠaiti pɛɛ zalaɠa zuaiti ba, kɔɠɔgi liegɔi zoloo ti-liegɔi ma, eɠɛʋelei deveai la tɔgi zu. ");
INSERT INTO tod_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Wa boli zinɛi ɠula ɓalaa ga koto gba zalaɠai. Naa kpein ge ɓɔ gala zalaɠai ʋa, é ɠulazu folo-o-folo, ta ná-vebɛ zalaɠai, ta ná-puya zalaɠai. ");
INSERT INTO tod_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","«Naa ɠa wa kɛ Ɠɔoɠɔ GALAGI ʋɛ, wa-vɛti voloiti su, é ɠula wa-vebɛaniiti polu, wo ti laai ɠisu, ta wa-minazeɠe daazeeli zalaɠaiti, ti ga wa-ɠala zalaɠaiti, ta wa-vebɛ zalaɠaiti, ta wa-ʋuya zalaɠaiti, ta wa-yiilɛi zalaɠaiti.» ");
INSERT INTO tod_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moize devei naati kpein boni Izilayɛle nuiti ma, niiti Ɠɔoɠɔ GALAGI ti veeni zea. ");
INSERT INTO tod_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Moize ɓɔɛni Izilayɛle nuiti ma wolodama ɠundiɠiiti pɔ, é ɠɛni ti ma: «Devei ʋɛtɛ, nii Ɠɔoɠɔ GALAGI feai: ");
INSERT INTO tod_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Siɛgi zu zunui ta minazeɠezu la Ɠɔoɠɔ GALAGI ʋɛ, ɓaa é konai wo, é ʋilɛ fai ta ʋa, nii é pɔ ga é kɛ, é la mɔ daawooi zeɠea ma. Toɠa naa kpein kɛ, niiti ti ɠulaai da, é bo. ");
INSERT INTO tod_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","«Ni anzalopoi ta, nii é kɛɛɠɛ ná-pɛlɛi wu dɛ, a minazeɠe kɛɛna Ɠɔoɠɔ GALAGI ʋɛ, é ɓɔɠɔ ɠili ga naa, ");
INSERT INTO tod_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ni kɛɛɠɛ a ná-minazeɠe fai ta ná-kona vai zuɠwɛɛna, é ɓɔɠɔ ɠiliai la, ni kɛɛɠɛ a maaɠɛna kpɔ, é la faa woni tɔun tetegi, ná-minazeɠegiti ta ná-konaiti kpein ta yɛ ma, niiti é ɓɔɠɔ ɠiliai ga tiye. ");
INSERT INTO tod_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Kɛlɛ ni kɛɛɠɛ la yeezeini bu, yeei nɔ é faa ɠwɛɛgai la su, minazeɠegiti ta konai kpein é ɓɔɠɔ ɠiliai la, naati ti la mɔ yɛga ma. Ɠɔoɠɔ GALAGI ɠa suvaayɛ, mazɔlɔɔ kɛɛɠɛ la yeezeini ti wu. ");
INSERT INTO tod_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","«Ni toɠa zini bɛ, é minazeɠegaa ɠɛai na, ɓaa é ɓɔɠɔ ɠiliai na, ga kpɔɛi ta nii kulaai na da, é bo, ");
INSERT INTO tod_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ta sinigi a faa ɠwɛɛna su, é maaɠɛ kpɔ tɔun tetegi voloi nɔ é faa ɠwɛɛgai la su, ná-minazeɠegiti ta yɛ ma, ta konaiti é ɓɔɠɔ ɠiliai ga tiye, ta yɛ ma. ");
INSERT INTO tod_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Kɛlɛ ni sinigi la yeezeini bu, voloi nɔ é suɠwɛɛsu da, é minazeɠegi ɠaaʋa, nii é kɛai, ta kpɔɛi kulaai daaʋɛ, niiti é ɓɔɠɔ ɠiliai ga tiye, Ɠɔoɠɔ GALAGI ɠa suvaayɛ. ");
INSERT INTO tod_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","«Poanzai, ɓaa anzanui ti ɠɛlɛai ba, minazeɠegi naa a bo, ɓaa konai nɔpɛ kulaai daaʋɛ, nii é ɓɔɠɔ ɠilizu la, giliai ɠa yɛ de. ");
INSERT INTO tod_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","«Anzanui nii é zini bɛ, naa a minazeɠegaa ɠɛɛna, ɓaa é ɓɔɠɔ ɠili ga konai ta, ");
INSERT INTO tod_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","sinigi a faa ɠwɛɛna su, é maaɠɛ kpɔ, é la yeeɠulani bu, é ʋa ɠɛlɛ, ná-minazeɠegiti kpein ta yɛ ma, ta kona wooi nɔpɛ é ɓɔɠɔ ɠiliai la. ");
INSERT INTO tod_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Kɛlɛ ni sinigi a ɠɛlɛna, voloi nɔ é suɠwɛɛsu da, ná-minazeɠegi kpein ta kona wooi kpein é lo tɔ ɓɔɠɔi ʋa, ɓaa daawooi ʋa, naati ti la yɛga ma. Sinigi ti ɠaaʋaa, Ɠɔoɠɔ GALAGI ɠa suvaayɛ. ");
INSERT INTO tod_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Sinigi ɠa zoo é ti yɛ ma, ɓaa é minazeɠegi kpein koloɠolo, ɓaa konai kpein nii a zoo ɠɛlɛzu la anii ta ʋa. ");
INSERT INTO tod_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ni sinigi la ɠɛlɛni, a maaɠɛna kpɔ eyɛsu poluma zobui zeeli, anzai ɠa ɠili minazeɠegi kpein su, ta kona wooiti kpein su, é ti woga. É vaa bu ga é ti makɛ, tɔɔzei é maaɠɛga kpɔ, é la faa woni, foloi é mɛniga da. ");
INSERT INTO tod_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Kɛlɛ ni toɠa ti zeɠe ma, foloi tanigaani teʋega ʋoluma, kpega ʋoluma ga suɠwɛɛ, toɠa anzai ná-faaɠaaza golai ma ɠasɔi zeɠe.» ");
INSERT INTO tod_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Tɔgiti kana, niiti Ɠɔoɠɔ GALAGI ti veeni Moize ya, é ʋilɛ zunui ta anzai ti yɔɠɔzuʋɛ ʋa, doun kɛɛɠɛi ta ná-doun anzanui ti yɔɠɔzuʋɛ ʋa, siɛgi zu é ga nu niinɛi, é kɛɛɠɛ ná-pɛlɛi wu dɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","«Izilayɛle nuiti tɔnɔi ʋotokula Madiyan nuiti ma, naa ʋolu, ɗa li niina è-mɛmɛwolani pɔ, ti zaai.» ");
INSERT INTO tod_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moize ɓɔɛni nuɓusɛiti pɔ, é ɠɛ ti ma: «À zunui tanigaani maaɠili ga kɔɔɠɔ zɔɔlaiti wo zaama, ti li Madiyan nuiti daalɔɠɔma, naa ɠa a kɛ, Ɠɔoɠɔ GALAGI ná-potokulai laazeeli Madiyan nuiti ma. ");
INSERT INTO tod_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Bolodai ɠilagilagi zu, wa zunu waagila (1.000) kula ti zaama, wo ti leʋe kɔɔmaʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ti ziimazeɠegi woni Izilayɛle nuɓusɛiti saama, bolodai ɠilagilagi zu, zunu waagilagila (1.000), ti-liegɔi ɠɛni ga zunu waapuugɔ maazu felegɔ (12.000) ti maaɠiliai kɔɔɠɔ vai ma. ");
INSERT INTO tod_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moize ti leʋeni kɔɔmaʋɛ, é Fineyase ʋɛɛ ti ʋa, zalaɠa ɠula nui Eleazaal ná-doun zunui, naa ɠa é ɠɛni seizu ɲadegai ma zɔɔlaiti seɠezu, ta puʋugiti é ʋa ɗa poogiti dɛɛ la. ");
INSERT INTO tod_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ti kɔɔɠɔ zɔɔlaiti seɠeni, ti li Madiyan nuiti daalɔɠɔma, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la Moize ya. Ti zunuiti kpein paani, ");
INSERT INTO tod_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","é ɓɔ Madiyan nuiti ta-masa dɔɔlugɔ ʋa, ti ga: Evi, Lekɛme, Suul, Ɠuul, ta Leɓa. Ti Ɓeyɔɔl ná-doun zunui Ɓalaame ɓalaagi ʋaani ga boɠa zɔkpɔi. ");
INSERT INTO tod_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Izilayɛle nuiti ti Madiyan anzanuiti ta ti-lointi soni ga duɔiti, ti li ga tiye. Ti ta-zuaiti soni, ta ta-logani ɓulugiti kpein, é ʋɛɛ ti-yeaɠɔligi kpein ba. ");
INSERT INTO tod_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ti abui loni ta-laaiti kpein ba, ʋɛti ti ɠɛni zeini ná, ta ti-ʋuuzuʋɛti kpein. ");
INSERT INTO tod_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ti liini ga aniiti kpein ti ti zoni kɔɔmaʋɛ, nuiti ti ʋɛɛ toganiiti ba. ");
INSERT INTO tod_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Ti liini ga duɔiti, ta kɔɔzoganiiti, ta kɔɔi zu aniiti Moize ʋɔ, ta zalaɠa ɠula nui Eleazaal, ta Izilayɛle ʋɛbɛi, naati ti ɠɛni ʋuuni Moaɓe nɛmɛi zu, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moize ta zalaɠa ɠula nui Eleazaal ta bɛbɛi ná-kundiɠiiti kpein ti wuzeɠeni, ti li, ti laaɠomisuʋɛ, ti-ʋuuzuʋɛ ʋoluʋelei. ");
INSERT INTO tod_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moize yiiɠaawanani kɔɔɠuluɓaiti ma, nu waagilagila kundiɠiiti, ta nu ungilagila kundiɠiiti, niiti ti ʋaani, ti zeɠe kɔɔmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moize ti ɠaazaɠani, é ɠɛ ti ma: «Lee vaa zu wo niima anzanuiti kpein zɛgai vulua? ");
INSERT INTO tod_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","À ɠizɛ su ga, tiya ɠa ti Ɓalaame ná-tɛnɛ gooi zoni, ti Izilayɛle nuiti dɔ wooʋaladai zu, Ɠɔoɠɔ GALAGI laalɔɠɔma, Peyɔɔl ná-fai zu, naa ɠa é ʋaani ga maanɔɠɔi Ɠɔoɠɔ GALAGI ná-nuɓusɛiti saama. ");
INSERT INTO tod_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Niizu niina, à zunu loungoiti kpein paa, wo anzanui kpein paa, niiti ti zunu vaa ɠwɛɛgai na. ");
INSERT INTO tod_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Anzanu loungoiti, niiti ti la dɛ zunu lakoba vaa ɠwɛɛ, naati nɔ ɠa wa ti yɛ ná, wo ti makɛ ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","«Wɔun wa, à li, wo ʋu ada ɠila ade-ʋuuzuʋɛ ʋoluʋɛ, wo yɛ ná folo lɔfela laawu, wɔiti wo nu ʋaai, ɓaa wo vɔɔɠu pooma ʋa, wa ɓɔɠɔ ɲade foloi zaʋasiɛi, ta foloi lɔfelasiɛi, wa-o, wa-luɔiti-yo. ");
INSERT INTO tod_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Wa seɠeiti kpein ɲade ɓalaagi, sɔɔla kpein kpɛtɛai ga kɔlɔi, ɓaa boli leɠa zeɠei kpein, ta aniɲaka kpein é ga gului.» ");
INSERT INTO tod_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Zalaɠa ɠula nui Eleazaal ɓɔɛni kɔɔɠɔ nuiti pɔ, ti zeɠeni kɔɔmaʋɛ, é ɠɛ ti ma: «À wɛlɛ faazeikpasui ʋa, é tɔgi zu, Ɠɔoɠɔ GALAGI ma levei veai Moize ya: ");
INSERT INTO tod_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","zanugi, walii, kɔlu ɓɔigi, kɔlui, foɠagi, ta bɔbɔgi, ");
INSERT INTO tod_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","anii kpein nii a zoo lɔɔzu abui ɠa, é la ɠala, wa naa lɔ abui ɠa, é ɲade. Naa ʋolu, wa ti lɔ ɓalaa ziɛ ɲadegai wu. Kɛlɛ, sɔɔla kpein é la zooga lɔɔzu abui ɠa, wa naati dɔ nɔ ziɛ ɲadegai wu. ");
INSERT INTO tod_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Wa wa-zeɠeiti gba, foloi lɔfelasiɛi, wa ɲade niina, naa ʋoluma, wa zoo lɔɔzu ade-ʋuuzuʋɛ.» ");
INSERT INTO tod_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Ɠɔoɠɔ GALAGI ɠɛni Moize ma: ");
INSERT INTO tod_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","«Zalaɠa ɠula nui Eleazaal zeɠe, é ʋɛɛ è ʋa, ta nuɓusɛiti ta-ʋɛlɛyeɠeiti ma ɠundiɠiiti, wo kɔɔzoganiiti gaalu, duɔiti ta toganiiti. ");
INSERT INTO tod_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Ɗa kɔɔzoganii naati gaaɠwɛ su fele, ma ʋalisaamai ve kɔɔɠɔ nuiti zea, ma ʋalisaamai ve nuɓusɛi zɔiti kpein zea. ");
INSERT INTO tod_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nii é ɠɛɛzu ga kɔɔɠɔ nuiti tɔnɔi, vebɛanii ɠa zeɠe ba, é ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi, nu ɠila ka zeɠe nu undɔɔlugɔi (500) zaama, togani ɠila ka zeɠe togani undɔɔlugɔi (500) zaama, ma wolaiti ta ma goiti ta soovalegiti saama. ");
INSERT INTO tod_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Ma ʋalisaamai nii feai ti ya, ɗa seɠe naa ʋa, è fe zalaɠa ɠula nui Eleazaal ya, é ɠɛ ga vebɛanii seɠeai ba Ɠɔoɠɔ GALAGI ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Ma ʋalisaamai nii é ɠɛɛzu ga Izilayɛle nuiti tɔnɔi, ɗa nu ɠila seɠe nu ʋuulɔɔlugɔi (50) zaama, è togani ɠila seɠe togani ʋuulɔɔlugɔi (50) zaama, ma wolaiti ta ma goiti ta soovalegiti saama, è ti ve Levi nuiti zea, niiti Ɠɔoɠɔ GALAGI ná-seɠe ʋɛlɛ ɲadegai makɛ vai ɠalivaai ti ma.» ");
INSERT INTO tod_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moize ta zalaɠa ɠula nui Eleazaal ti kɛɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Kɔɔzoganiiti niiti kɔɔɠɔ nuiti ti ʋaani la, naa ɠɛni ga: baalagi ta bolii waaundɔzita waaʋuulɔfela maazu lɔɔlu (675.000), ");
INSERT INTO tod_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","nikɛ waaʋuulɔfela maazu felegɔ (72.000), ");
INSERT INTO tod_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","soovale waaʋuulɔzita maazu ɠila (61.000), ");
INSERT INTO tod_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","anzanu loungoi niiti ti la ɠɛni dɛ zunu lakoba vaa ɠwɛɛ, naati ti ɠɛni ga nu waaʋuusaʋagɔ maazu felegɔ (32.000). ");
INSERT INTO tod_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ma ʋalisaamai nii é ɠɛni ga kɔɔɠɔ nuiti tɔnɔi, tiegɔi ɠɛni ga: baalagi ta bolii waaunsaʋagɔ waaʋuusaʋagɔ maazu lɔfela undɔɔlu (337.500), ");
INSERT INTO tod_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","naa ɠa undɔzita puulɔfela maazu lɔɔlugɔi (675) zeɠeni ba, é ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi, ");
INSERT INTO tod_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","nikɛ waaʋuusaʋagɔ maazu lɔzitai (36.000), naa ɠa puulɔfela maazu felegɔi (72) zeɠeni ba, é ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi, ");
INSERT INTO tod_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","soovale waaʋuusaʋagɔ undɔɔlugɔi (30.500), naa ɠa puulɔzita maazu ɠilagi (61) zeɠeni ba, é ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi, ");
INSERT INTO tod_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","nuɓusɛ waapuugɔ maazu lɔzitai (16.000), naa ɠa nu ʋuusaʋagɔ maazu felegɔi (32) zeɠeni ba, é ɠɛ ga Ɠɔoɠɔ GALAGI nɔnɔi. ");
INSERT INTO tod_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Vebɛanii kpein é ɠɛni ga Ɠɔoɠɔ GALAGI nɔnɔi, Moize naa zeɠeni, é pu zalaɠa ɠula nui Eleazaal yeezu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Ma ʋalisaamai é ɠɛni ga Izilayɛle nuɓusɛiti tɔnɔi, nii Moize puuni yɛ, kɔɔɠɔ nuiti tɔnɔi ʋoluma, ");
INSERT INTO tod_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","naa ɠɛni ga: baalagi ta bolii waaunsaʋagɔ waaʋuusaʋagɔ maazu lɔfela undɔɔlu (337.500), ");
INSERT INTO tod_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nikɛ waaʋuusaʋagɔ maazu lɔzita (36.000), ");
INSERT INTO tod_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","soovale waaʋuusaʋagɔ undɔɔlu (30.500), ");
INSERT INTO tod_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nuɓusɛ waapuugɔ maazu lɔzita (16.000). ");
INSERT INTO tod_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Ma ʋalisaamai é ɠɛni ga Izilayɛle nuiti tɔnɔi, Moize nu ɠilagilagi zeɠeni nu ʋuulɔɔludɔɔlugi (50) kpein ba, é togani ɠilagilagi ɠula togani ʋuulɔɔludɔɔlugi (50) kpein saama, é ti ve Levi nuiti zea, niiti ti Ɠɔoɠɔ GALAGI ná-seɠe ʋɛlɛ ɲadegai makɛsu, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la zea. ");
INSERT INTO tod_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Kɔɔɓɔgiti deve ɠundiɠiiti, waagilagila kundiɠiiti, ta nu ungilagila kundiɠiiti, naati ti ʋaani naazu, ");
INSERT INTO tod_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","ti ɠɛ Moize ma: «Gɛi gi ga ɗa-wotiɠɛ nuiti, gi kɔɔɠɔ nuiti gaaluga, niiti ti ɠɛa gá-leveiti bu, ti ɠaavɔnigɛ, zunu ɠila kpalaa ge la yɛni ná ʋolu gi zaama. ");
INSERT INTO tod_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Gi ɠilagilagi gá ʋaazu ga zanu sɔɔlaiti Ɠɔoɠɔ GALAGI ʋɔ, ti ɠɛ ga vebɛaniiti, nii gi ka, zanu balaiti, yɔlɔɠɔiti, balaɠaegiti, goizu anigiti, ta kɔbu ansaiti, é ɠɛ ga koto gba anii tɔgi letemazu, gi-ɓusɛiti faa zu, Ɠɔoɠɔ GALAGI ɠaazu.» ");
INSERT INTO tod_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moize ta zalaɠa ɠula nui Eleazaal ti yeezeini naama zɔɔlaiti bu, ti ti veeni ti ya, ti ɓɛtɛai ga zanugi. ");
INSERT INTO tod_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Zanugi kpein nu waagilagila kundiɠiiti ta nu ungilagila kundiɠiiti ti gaaluni Ɠɔoɠɔ GALAGI ʋɛ, buɲɛgi ɠɛni ga kilo ungila puulɔsaʋa maazu naanigɔ (184). ");
INSERT INTO tod_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kɔɔɠɔ nuiti ɛsɛ ge ná-kɔɔzoganii zeɠeni ɓɔɠɔ ʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moize ta zalaɠa ɠula nui Eleazaal ti zanugi zeɠeni, nu waagilagila (1.000) kundiɠiiti ta nu ungilagila (100) kundiɠiiti zea, ti lii la GALA daaɠomi seɠe ʋɛlɛi wu, é ɠɛ ga ɠizɛsui Izilayɛle nuiti bɛ, Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Togani ɓulu golai ɠɛni Luɓɛn mavofodaiti ta Gade mavofodaiti zea. Ti kaani ga Yazɛɛl yooi ta Galaade yooi ta ga ada ʋagɔ toganiiti to fai zu. ");
INSERT INTO tod_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Ti ʋaani, ti zeeli Moize ma, ta zalaɠa ɠula nui Eleazaal, ta nuɓusɛiti ta-ɠundiɠiiti, ti ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","«Taaiti ti ga, Atalɔte, Diɓon, Yazɛɛl, Nimila, Ɠɛsɛɓon, Eleyalé, Seɓame, Neɓo ta Ɓeyon, ");
INSERT INTO tod_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","zooi nii Ɠɔoɠɔ GALAGI feai Izilayɛle nuɓusɛiti bɛ, toɠa ga zooi pagai togani lo fai ma. Tama, toganii wola mɔinʋɛ gi ya gɛi gi ga ɗa-wotiɠɛ nuiti.» ");
INSERT INTO tod_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ti ɠɛni ma: «Ni gi zaalai zɔlɔɔgɛ è ɠaazu, yeezei bu, è zooi nii ve gi ya, gɛi gi ga ɗa-wotiɠɛ nuiti. Mina gi ɓudɛ ga Zuludɛn ʋoluʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moize bolodama felegɔi niiti gooɠaaʋoteni, é ɠɛ ti ma: «Wa pɔ wo yɛ ʋɛ, wo-ɠɛɛlointi ta ɠɛɛna lia kɔɔmaʋɛ, naa ɠa ɠɛ ɠale? ");
INSERT INTO tod_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Lee vaa zu wo pɔ Izilayɛle nuiti iɲɔteʋe ti lɛɛ vai zu zooi zu, nii Ɠɔoɠɔ GALAGI feezu ti ya? ");
INSERT INTO tod_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Zekana kpein nɔ wo-ɠɛɛni ti kɛɛni la, siɛgi zu gè ti leʋeni la, ti zeɠe Kadɛse-Ɓaaleneya, ti li, ti zooi ʋɛtɛ. ");
INSERT INTO tod_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ti lɛɛni, ti zeeli Esekɔle nɛmɛi zu, ti ɓegai ma ga zooi ʋɛtɛ, ti Izilayɛle nuiti iɲɔteʋeni ga ti mina li zooi zu, nii Ɠɔoɠɔ GALAGI feezu ti ya. ");
INSERT INTO tod_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Ɠɔoɠɔ GALAGI yiiɠaawanani naama voloi, é ɠona, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‹Zunui niiti ti ɠulaai Ezipete yooi ʋa, é zo kona ʋuufelegɔ (20) ma, é lɛ zeemaazu, naati ti la ɠaazulaa zooi ma, nii gè ma ɠona woga ga nà feezu Abalaame ya, ta Izaake, ta Zakɔɓe, mazɔlɔɔ ti la ʋilɛni gòoi ʋolu, ti ʋa ɠolo bɛ̀, ");
INSERT INTO tod_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","é ɠula Kalɛɓe ʋolu, Yefuné ná-doun zunui, nii é ga Kenize nui, ta Nun ná-doun zunui Zozuwe, niiti ti ʋilɛni Ɠɔoɠɔ GALAGI laawooi ʋolu, ti ɠolo bɛ.› ");
INSERT INTO tod_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","«Ɠɔoɠɔ GALAGI yiiɠaawanani Izilayɛle nuiti ma, é ti leʋeteʋe teʋebai zu kona ʋuunaanigɔ (40) laawu, eyɛsu naama yamanii kpein ge zeɠe ná, niiti ti Ɠɔoɠɔ GALAGI wanama vai ɠɛɛni. ");
INSERT INTO tod_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Wɛlɛ, wa ɠa wo wo-ɠɛɛni tosuʋɛ zeɠea, eɠɛʋelei wo la ga kotoba nuiti ti zɔlɔɔgai, wo Ɠɔoɠɔ GALAGI ná-ziiɠaawanai ɠaalɛɛzu ba Izilayɛle laalɔɠɔma. ");
INSERT INTO tod_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Mazɔlɔɔ ni wo la ɠɛ kɛɛni, wo ʋa ɠolo tɔun bɛ, toɠa Izilayɛle yɛ nɔ teʋebai zu, wa ɠɛ ga zaɓui wo niima nuɓusɛi kpein undaaʋili.» ");
INSERT INTO tod_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ti Moize wooɠaaʋoteni, ti ɠɛ ma: «Ɓa-o, gá sasaiti nɔ losu ʋɛ, gá-logani ɓulugiti faa zu, gi taaiti to gá-ʋɛlɛyeɠeiti bɛ. ");
INSERT INTO tod_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Gɔun gi letegi, gá ɓɔɠɔ maaɠili ga kɔɔɠɔ zɔɔlaiti gaazuvilɛi zu, gi lo Izilayɛle nuiti untuɠɔ, eyɛsu gi lɔ ga tiye naama adaʋɛ, ʋɛ ná veai ti ya. Gá-ʋɛlɛyeɠeiti gila nɔ ɠa ta ɠɛ yɛsu taaiti su, siɠigiti ti ti ma, nii a kɛ ti maalɔɔɠu zooi zu nuɓusɛiti ba. ");
INSERT INTO tod_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Gi la ɠalega ma gá-ʋɛlɛiti bu, eyɛsu Izilayɛle nuiti gilagilagiti ti tɔnɔ ma yooiti sɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Kɛlɛ gi la mɔ zou zɔlɔɔga Zuludɛn ʋoluʋelei, anɛɛ ná maaɠooza ʋa, tɔɔzei gi gɔnɔ ma yooi zɔlɔɔga Zuludɛn ɠakamaʋɛ folo ɠulazu ʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moize ɠɛni ti ma: «Ni wa minazeɠe gooi naa laazeelina, ni wa ɓɔɠɔ maaɠilina ga wo kɔɔi ɠɔ Ɠɔoɠɔ GALAGI ɠaazu, ");
INSERT INTO tod_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ni wa-ɠɔɔɠɔ nuiti kpein ta ɓɔɠɔ maaɠili, ti Zuludɛn ɓudɛ, Ɠɔoɠɔ GALAGI ɠaazu, eyɛsu é sili nuiti kpein kpɛ ɠaazu, ");
INSERT INTO tod_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ni wa ɠale ma, siɛgi zu nɔ zooi maaɠolozu la Ɠɔoɠɔ GALAGI ɠaazu, faa la mɔ ɠɛa wo ʋa, wa vie naazu Ɠɔoɠɔ GALAGI ɠaazu, ta Izilayɛle letegi. Naazu, niima ada yɔɠɔzuʋɛ ɠa ɠɛ ga wɔnɔ Ɠɔoɠɔ GALAGI ɠaazu. ");
INSERT INTO tod_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Kɛlɛ ni wo la ɠɛ kɛɛni ɠana, wo koto ɠɛa Ɠɔoɠɔ GALAGI laalɔɠɔma. À suɠwɛɛ ga wa-ɠotoi ɠa wo ɠɔɠɔzumɛɛn! ");
INSERT INTO tod_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","À taaiti to wa-ʋɛlɛyeɠeiti bɛ, wo sasaiti to wa-logani ɓulugiti bɛ. Nii é ɠulaa wo-la, wo bo, à ziɛ ga naa.» ");
INSERT INTO tod_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gade mavofodaiti ta Luɓɛn mavofodaiti ti ɠɛni Moize ma: «Ɗa-wotiɠɛ nuiti gá kɛ, eɠɛʋelei màliɠii devei wogai la. ");
INSERT INTO tod_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Gi-lointi, gi-anzaiti, gá-loganiiti, ta gá-logani ɓulugiti ta yɛ Galaade taaiti su. ");
INSERT INTO tod_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Gɛi gi ga ɗa-wotiɠɛ zunuiti, gi pɛ gi maaɠiliai ga kɔɔɠɔ zɔɔlaiti, gá Zuludɛn ɓudɛ, gi kɔɔi ɠɔ Ɠɔoɠɔ GALAGI ɠaazu, eɠɛʋelei màliɠii bosu da.» ");
INSERT INTO tod_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moize devei veeni ta-vaa zu zalaɠa ɠula nui Eleazaal ya, ta Nun ná-doun zunui Zozuwe ya, é ʋɛɛ Izilayɛle wolodama ʋɛlɛyeɠe ɠundiɠiiti ba. ");
INSERT INTO tod_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","É ɠɛni ti ma: «Ni wa Gade mavofodaiti ta Luɓɛn mavofodaiti, wa Zuludɛn maazuɓudɛna ʋɔɔma, ti maaɠiliai ga kɔɔɠɔ zɔɔlaiti, ti kɔɔi ɠɔ Ɠɔoɠɔ GALAGI ɠaazu, eyɛsu zooi maaɠolo wo ʋɛ, wa Galaade yooi ve ti ya ga tɔnɔ. ");
INSERT INTO tod_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Kɛlɛ ni ti la Zuludɛn ɓudɛni, ti ɠɛʋele ɓɛtɛai ʋa ɠɛ de, ga wo kɔɔi ɠɔ ʋɔɔma, ta zei wo zaama Kanaan yooi zu.» ");
INSERT INTO tod_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gade mavofodaiti ta Luɓɛn mavofodaiti ti gooɠaaʋoteni, ti ɠɛ ma: «Gá naa ɠɛ, nii Ɠɔoɠɔ GALAGI bogai gi ma, gɛi gi ga ɗa-wotiɠɛ nuiti. ");
INSERT INTO tod_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Gá ɓudɛ, gi maaɠiliai ga kɔɔɠɔ zɔɔlaiti, Ɠɔoɠɔ GALAGI ɠaazu, Kanaan yooi zu, kɛlɛ gá gɔnɔi ma yooi zɔlɔɔ Zuludɛn ɠakala ʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Amool nuiti ta-masagi Siɠon, ta Ɓasan nuiti ta-masagi Wɔge, Moize naati ta-masadai ta ta-yooiti feeni Gade mavofodaiti zea, ta Luɓɛn mavofodaiti, é ʋɛɛ Manasé ná-bolodai ɠilazuʋɛ ʋa, nii é ga Zozɛfe ná-doun zunui, é ʋɛɛ ta-laaiti ba, ta ma yooiti ti ɠɛni ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Taai niiti Gade mavofodaiti ti ti loni, ti ɠɛni ga: Diɓon, Atalɔte, Alowɛɛl, ");
INSERT INTO tod_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atalɔte-Sofan, Yazɛɛl, Yogeɓeɠa, ");
INSERT INTO tod_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Ɓɛte-Nimala, ta Ɓɛte-Ɠalan, taaiti siɠigi ti ma. Ti sasaiti toni togani ɓulugiti faa zu. ");
INSERT INTO tod_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Taai niiti Luɓɛn mavofodaiti ti ti loni, ti ɠɛni ga: Ɠɛsɛɓon, Eleyalé, ta Kiliyatayime, ");
INSERT INTO tod_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Neɓo, ta Ɓaale-Meyon, naati ti-laaseigi valiboni, ta Siɓima. Ti daaseigiti pɛɛni taaiti ba, niiti ti ti loni. ");
INSERT INTO tod_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Makiil mavofodaiti, nii é ga Manasé ná-doun zunui, naati ti liini Galaade laalɔɠɔma, ti vɔni ma, ti zobo sɔlɔɔ Amool nuiti ma, ti ɠɛni zeini ná, ti ti zeɠe. ");
INSERT INTO tod_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moize Galaade yooi veeni ti ya, ti zeini ná. ");
INSERT INTO tod_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Yayiil é ga Manasé ná-dounloin ta, naa wuzeɠeni, é li, é ɓalaɠaiti so, é ti-laasei pɛɛni ga Yayiil ná-taaiti. ");
INSERT INTO tod_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nɔɓa laalɛɛni Kenate wu, é so, ta taaiti ti ɠilini ba, é tɔ ɓɔɠɔi daaseigi ʋɛɛ ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Peleiti pɛtɛ Izilayɛle nuiti ti leʋeni da, ti ɠulaai ma Ezipete yooi ʋa, ti zeiɗai kpasu, Moize ta Aalɔn ti loni ti luɠɔ. ");
INSERT INTO tod_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moize ti-ʋuuzuʋɛti ta ti-ziɛzuʋɛti sɛʋɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ná-devei ɠɛni la. ");
INSERT INTO tod_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Alu mɔungi ma volo puugɔ maazu lɔɔlugɔi (15) ma, Pakegi ʋoluma zobui, ti liini, ti zeɠe Lamesɛse. Izilayɛle nuiti ti ɠulani ɓɔɠɔ yeema zooi ʋa, Ezipete nuiti kpein gaazu ɠɛni ti ʋa. ");
INSERT INTO tod_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Ezipete nuiti ti ɠɛni ti-loun zunu mɔungiti maaɠuluzu, niiti Ɠɔoɠɔ GALAGI ti ʋaani. Tukpɔi ɠana é daalɛɛni ta-ɠalagiti bu. ");
INSERT INTO tod_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Izilayɛle nuiti ti zeɠeni Lamesɛse, ti li, ti ʋu Sukɔte. ");
INSERT INTO tod_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ti zeɠeni Sukɔte, ti li, ti ʋu Etame, nii é teʋebai ɠaaɓelazuʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ti zeɠeni Etame, ti ɠaaɠale ma ga ʋogi Pi-Ɠaɠilɔte ʋele, Ɓaale-Sefon folo ɠulazu ʋelei, ti li, ti ʋu Migedɔle letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ti zeɠeni Pi-Ɠaɠilɔte, ti leʋe Seeli Kpoloɗɛi zaamaʋɛ, teʋebai ʋɔ pelei. Ti folo saʋagɔ ziɛ woni Etame teʋebai zu, ti li, ti ʋu Mala. ");
INSERT INTO tod_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ti zeɠeni Mala, ti zeeli Elime, ʋɛ ziɛun puugɔ maazu felegɔ (12) ɠɛni ná, ta dɔɔ wulu ʋuulɔfela (70), miná ɠa ti ʋuuni ná. ");
INSERT INTO tod_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ti zeɠeni Elime, ti li, ti ʋu Seeli Kpoloɗɛi ɠobaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Ti zeɠeni Seeli Kpoloɗɛi ɠobaʋɛ, ti li, ti ʋu Sin teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ti zeɠeni Sin teʋebai zu, ti li, ti ʋu Dofeka. ");
INSERT INTO tod_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Ti zeɠeni Dofeka, ti li, ti ʋu Aluse. ");
INSERT INTO tod_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ti zeɠeni Aluse, ti li, ti ʋu Lefidime, ʋɛ nuɓusɛiti ti la ɠɛni ziɛ zɔlɔɔni ná ga ti ʋa ɓɔɔle. ");
INSERT INTO tod_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ti zeɠeni Lefidime, ti li, ti ʋu Sinayi teʋebai zu. ");
INSERT INTO tod_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Ti zeɠeni Sinayi teʋebai zu, ti li, ti ʋu Kiɓelɔte-Ɠataava. ");
INSERT INTO tod_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ti zeɠeni Kiɓelɔte-Ɠataava, ti li, ti ʋu Ɠaselɔte. ");
INSERT INTO tod_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ti zeɠeni Ɠaselɔte, ti li, ti ʋu Litima. ");
INSERT INTO tod_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ti zeɠeni Litima, ti li, ti ʋu Limon-Peelɛse. ");
INSERT INTO tod_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Ti zeɠeni Limon-Peelɛse, ti li, ti ʋu Liɓina. ");
INSERT INTO tod_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ti zeɠeni Liɓina, ti li, ti ʋu Lisa. ");
INSERT INTO tod_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ti zeɠeni Lisa, ti li, ti ʋu Keɠelata. ");
INSERT INTO tod_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ti zeɠeni Keɠelata, ti li, ti ʋu Safɛɛl gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Ti zeɠeni Safɛɛl gizei ma, ti li, ti ʋu Ɠalada. ");
INSERT INTO tod_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Ti zeɠeni Ɠalada, ti li, ti ʋu Makelɔte. ");
INSERT INTO tod_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ti zeɠeni Makelɔte, ti li, ti ʋu Taɠate. ");
INSERT INTO tod_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Ti zeɠeni Taɠate, ti li, ti ʋu Tala. ");
INSERT INTO tod_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Ti zeɠeni Tala, ti li, ti ʋu Mitaka. ");
INSERT INTO tod_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ti zeɠeni Mitaka, ti li, ti ʋu Ɠasemona. ");
INSERT INTO tod_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ti zeɠeni Ɠasemona, ti li, ti ʋu Moselɔte. ");
INSERT INTO tod_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Ti zeɠeni Moselɔte, ti li, ti ʋu Ɓené-Yaakan. ");
INSERT INTO tod_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ti zeɠeni Ɓené-Yaakan, ti li, ti ʋu Ɠɔɔl-Gidegade. ");
INSERT INTO tod_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Ti zeɠeni Ɠɔɔl-Gidegade, ti li, ti ʋu Yoteɓata. ");
INSERT INTO tod_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Ti zeɠeni Yoteɓata, ti li, ti ʋu Aɓelɔna. ");
INSERT INTO tod_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Ti zeɠeni Aɓelɔna, ti li, ti ʋu Ɛsiyon-Geeɓɛɛl. ");
INSERT INTO tod_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Ti zeɠeni Ɛsiyon-Geeɓɛɛl, ti li, ti ʋu Sin teʋebai zu, tɔ ɠa é ga Kadɛse. ");
INSERT INTO tod_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ti zeɠeni Kadɛse, ti li, ti ʋu Ɠɔɔl gizei ma, Edɔme yooi ɠwɛmaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Eɠɛʋelei Ɠɔoɠɔ GALAGI ná-devei woni da, zalaɠa ɠula nui Aalɔn lɛɛni Ɠɔɔl gizei ma, é za, Izilayɛle nuiti kulaai ma Ezipete yooi ʋa ma ɠonagi ʋuunaanisiɛi (40) ma, alugi lɔɔlusiɛi ma volo mɔungi ma. ");
INSERT INTO tod_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aalɔn ná-konagi ɠɛni ga kona ungila kona ʋuufele maazu saʋagɔ (123), siɛgi zu é zaani la Ɠɔɔl gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Názu ɠa Alade masagi, Kanaan yooi zu nui, nii é ɠɛni zeini zooi unda lɛkpɛmaʋɛ nu yeezazuʋɛ, naa mɛnini da ga Izilayɛle nuiti ta ʋaazu. ");
INSERT INTO tod_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ti zeɠeni Ɠɔɔl gizei ma, ti li, ti ʋu Salamona. ");
INSERT INTO tod_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Ti zeɠeni Salamona, ti li, ti ʋu Punon. ");
INSERT INTO tod_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Ti zeɠeni Punon, ti li, ti ʋu Wɔɓɔte. ");
INSERT INTO tod_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ti zeɠeni Wɔɓɔte, ti li, ti ʋu Ye-Aɓalime, Moaɓe kwɛpelemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Ti zeɠeni Ye-Aɓalime, ti li, ti ʋu Diɓon-Gade. ");
INSERT INTO tod_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Ti zeɠeni Diɓon-Gade, ti li, ti ʋu Alamon-Diɓelatayime. ");
INSERT INTO tod_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Ti zeɠeni Alamon-Diɓelatayime, ti li, ti ʋu Aɓalime gizeiti zɔɠɔzuʋɛ, Neɓo gizei ɠakalaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ti zeɠeni Aɓalime gizeiti ma, ti li, ti ʋu Moaɓe nɛmɛi zu, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Ti ʋuuni Zuludɛn ɠobaʋɛ, é zo Ɓɛte-Yesimɔte, é li Aɓɛle-Sitime, Moaɓe nɛmɛiti su. ");
INSERT INTO tod_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, Moaɓe nɛmɛiti su Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ, ");
INSERT INTO tod_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","é ɠɛ ma: «Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo Zuludɛn ɓudɛzu la, wo lɔ Kanaan yooi zu, ");
INSERT INTO tod_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","wa zooi zu nuiti kpein kpɛ luɠɔ, wo ta-ɠɔɔɠɔ ganigiti kpein koloɠolo, ti ti ɓɛtɛai ga kɔtui, wo ta-vololibaiti kpein koloɠolo, ti ɓɛtɛai ga kɔlui gaawuungai, wo ta-zalaɠa ɠula adaʋɛti kpein koloɠolo. ");
INSERT INTO tod_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Wa zooi zeɠe ga wɔnɔ, wo zei ná, mazɔlɔɔ gè zooi vea wo ya, é ɠɛ ga wɔnɔ. ");
INSERT INTO tod_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Wa zooi ɠaaɠwɛ ʋa, wa kɛ ga kpakutoomai, eɠɛʋelei wa-wolodamaiti ti la. Niiti ti mɔinɗai, wa ta-yooi wɔɔlɔ, wo fe ti ya, niiti ti la mɔinni, wa ta-yooi ve ti ya, kɛlɛ gola mina wɔɔlɔ. Ɛsɛ ka naa zɔlɔɔ, nii a ve zea ga kpakutoomai, wa ti zeɠe ga wɔnɔ, eɠɛʋelei wo-ɠɛɛni ta-wolodamaiti ti la. ");
INSERT INTO tod_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kɛlɛ ni wo la zooi zu nuiti kpɛɛni luɠɔ, ti zaama, niiti wa ti yɛ ná, ta ɠɛɛzu ga ɠaingi, ti ɗa ʋu wo-ɠaazuʋɛti, ta ani ɠaazoɓagiti ti ɗa wo-ɠo kakamaʋɛti kpota, ta ɠɛ ga wo zili nuiti zooi naa zu, ʋɛ wo ʋaazu zeizu ná. ");
INSERT INTO tod_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Názu ɠa nà wo zo da, eɠɛʋelei gè deveni la ga gè ti zo da.» ");
INSERT INTO tod_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","«Devei nii ve Izilayɛle nuiti zea, è ɠɛ ti ma: Siɛgi zu wo ʋaazu lɛɛzu la Kanaan yooi zu, wɛlɛ zooi ʋa, nii é ʋaazu veezu wo ya ga wɔnɔ, Kanaan yooi, é ʋɛɛ ná-kwɛpelegiti ba. ");
INSERT INTO tod_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Lɛkpɛmaʋɛ nu yeezazuʋɛ, wa-you ɠwɛgi lɔɔ ɠa zei Sin teʋebai zu, é lɛ ga Edɔme yooi zakpai. Folo ɠulazu ʋelei, wo-ɠwɛgi sogai lɛkpɛmaʋɛ nu yeezazuʋɛ, naa ɠa liizu, é lo Kpoloɗɛ Wanai ʋa, ");
INSERT INTO tod_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","wo-ɠwɛgi zu ɠa ɓilisu gize yɔɠɔzuʋɛ Akelaɓime, lɛkpɛmaʋɛ nu yeezazuʋɛ, é leʋe ga Sin ʋele, é zeeli Kadɛse-Ɓaaleneya, lɛkpɛmaʋɛ nu yeezazuʋɛ. É li ga Ɠasaal-Adaal ʋele, é leʋe ga Asamon ʋele, ");
INSERT INTO tod_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","é zo Asamon, é lati, é li, é zeeli Ezipete ɠɔtuɗɛi ma, é ʋilɛ Kpoloɗɛ Wolai ʋa. ");
INSERT INTO tod_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","«Wa-ɠwɛpelemaʋɛ é folo liizu ʋelei, naa ɠa ɠɛ ga Kpoloɗɛ Wolai. ");
INSERT INTO tod_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","«Wɛlɛ nii é ɠɛɛzu ga wa-ɠwɛpelemaʋɛ lɛkpɛmaʋɛ nu ɠɔʋɛzuʋɛ, é zo Kpoloɗɛ Wolai ma, wa kwɛgi la, eyɛsu é zeeli Ɠɔɔl gizei ma. ");
INSERT INTO tod_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Wa ɠwɛgi la, é zo Ɠɔɔl gizei ma, é li Leɓo-Ɠamate, é ʋilɛ Sedade ʋa, ");
INSERT INTO tod_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","é zo miná, é li ga Zifelon ʋele, é li, é ʋilɛ Ɠasaal-Enan ʋa. Lɛkpɛmaʋɛ nu ɠɔʋɛzu ʋele ɠwɛpelegi ɠana. ");
INSERT INTO tod_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","«Wa ɠwɛpelemaʋɛ leʋe ba folo ɠulazu ʋelei, é zo Ɠasaal-Enan, é li Sefame ʋele, ");
INSERT INTO tod_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","é zo miná, é yei Liɓila, Ayɛn folo ɠulazu ʋelei, kwɛpelemaʋɛ ɠa yeizu, é ʋilɛ Kinelɛte ɓoloɗɛi ʋa, folo ɠulazu ʋelei, ");
INSERT INTO tod_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","é yei mɔnɔ ga ziɛ wolai Zuludɛn, é ʋilɛ Kpoloɗɛ Wanai ʋa. Wa-yooi ɠwɛgiti kana.» ");
INSERT INTO tod_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moize Izilayɛle nuiti kalani ga niima vaiti, é ɠɛ ti ma: «Zooi ɠana nii wo ʋaazu gaaɠwɛɛzu ga kpakutoomai, Ɠɔoɠɔ GALAGI devea ga é ve boloda taaʋuugɔi ta ma lukpɛgi ya. ");
INSERT INTO tod_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Mazɔlɔɔ Luɓɛn nuiti ta-wolodamaiti, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, ti ta-yooiti seɠea, ta Gade nuiti ta-wolodamaiti ɓalaa, eɠɛʋelei ta-ʋɛlɛyeɠeiti ti la, Manasé ná-bolodai ɠilazuʋɛ ɓalaagi ná-zooi zeɠea. ");
INSERT INTO tod_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Boloda felegɔi naati ta boloda lukpɛgi, ti tɔnɔi zeɠea Zuludɛn ʋoluʋelei, Zeliko letemaʋɛ, folo ɠulazu ʋelei.» ");
INSERT INTO tod_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","«Wɛlɛ zunuiti daaseigiti ba, ti ʋaazu zooi ɠaaɠwɛɛzu wo yɔɠɔzu: zalaɠa ɠula nui Eleazaal, ta Nun ná-doun zunui é ga Zozuwe. ");
INSERT INTO tod_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Wa bolodama ɠundiɠii ɠilagilagi zeɠe ga ti zooi ɠaaɠwɛ. ");
INSERT INTO tod_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Naama zunuiti daaseigiti ta ga: Zuda ná-bolodai zu, Yefuné ná-doun zunui Kalɛɓe, ");
INSERT INTO tod_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simiyɔn nɔnɔi, Amiyude ná-doun zunui Samiyɛle, ");
INSERT INTO tod_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Ɓɛnzamɛn nɔnɔi, Kisilon ná-doun zunui Elidade, ");
INSERT INTO tod_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan nɔnɔi, Yogeli ná-doun zunui Ɓuki é ga kundiɠii, ");
INSERT INTO tod_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Zozɛfe mavofodaiti su, Manasé nɔnɔi, kundiɠii Ɠaniyɛle, Efode ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Efelayime nɔnɔi, kundiɠii Kemuwɛle, Sifitan ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zaɓulɔn nɔnɔi, kundiɠii Elisafan, Paalenake ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isakaal nɔnɔi, kundiɠii Paletiyɛle, Azan ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asɛɛl nɔnɔi, kundiɠii Ayiyude, Selɔmi ná-doun zunui, ");
INSERT INTO tod_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Nɛfɛtali nɔnɔi, kundiɠii Pedaɠɛle, Amiyude ná-doun zunui.» ");
INSERT INTO tod_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Naati ka Ɠɔoɠɔ GALAGI devei veeni ti ya, ga ti Kanaan yooi ɠaaɠwɛ Izilayɛle nuiti zɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, Moaɓe nɛmɛiti su, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ. ");
INSERT INTO tod_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","É ɠɛni ma: «Devei ve Izilayɛle nuiti zea, ga ti va bu, ti taai tanigaa ve Levi nuiti zea ta-yooi zu, nii ti sɔlɔɔgai ga tɔnɔ, ʋɛti ta zoo ti zei náti. Wa náti maaɠooliiti fe Levi nuiti zea. ");
INSERT INTO tod_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Naama laaiti ta ɠɛ ga ti-zeizuʋɛ. Ti-maaɠooliiti su ɠɛ ga ta-logani losuʋɛti, ti-yeaɠɔligiti ti ɠɛ ná, ta ta-logani ɓulugiti. ");
INSERT INTO tod_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Taaiti maaɠooliiti su, niiti wo ti veezu Levi nuiti zea, zooi ɠa ɠɛ ba, é ɠaku ma ga mɛtɛlɛ undɔɔlugɔ (500), é tɔɔzei siɠigiti ma, é li poluʋelei maaɠoolii kpein su. ");
INSERT INTO tod_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Wa kɔɠɔ, wo kwɛgi la taa ʋoluʋelei, ga mɛtɛlɛ waagila (1.000), é ɠaku ma kpoloo, taai ɠa ɠɛ zaamazuʋɛ. Ʋele ɠana zooi a ɠɛ la, ta-laaiti maaɠoolii zu. ");
INSERT INTO tod_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Wa yeelo taa lɔzita ʋa, wo fe Levi nuiti bɛ, ti ɠɛ ga maaʋela wosuʋɛ, nui niiti ti nu ʋaazu, ti la gaaɠilini ma, ta zoo ti ʋela, ti li ná, é ʋɛɛ taa ʋuunaanigɔ maazu felegɔ (42) ɠiligaa ʋa. ");
INSERT INTO tod_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Taaiti wo ʋaazu ti veezu Levi nuiti bɛ, tiegɔi ɠa ɠɛ ga puunaanigɔ maazu lɔsaʋa (48), é ʋɛɛ ti-maaɠoolii ma yooiti ba, ti ɠilagilagi pɛ. ");
INSERT INTO tod_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Taaiti wo ʋaazu ti zeɠezu Izilayɛle nuiti ta-yooiti su, mɔinɗa ɠa ɠula naati zea, niiti gola ti ya, tago nɔ ɠa a ɠula naati zea, niiti é la mɔinni ti ya. Bolodai ɠilagilagi ɠa ná-taai ta ve Levi nuiti bɛ, eɠɛʋelei a zoloo da sɔlɔɔgi ma, é ʋaazu bosu.» ");
INSERT INTO tod_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Ɠɔoɠɔ GALAGI ɓɔɛni Moize ʋɔ, é ɠɛ ma: ");
INSERT INTO tod_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","«Ɓɔɛ Izilayɛle nuiti pɔ, è ɠɛ ti ma: Siɛgi zu wo Zuludɛn ɓudɛzu la, wo lɛ Kanaan yooi zu, ");
INSERT INTO tod_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","wa yeelo taai tanigaani ba, ta ɠɛ wo ʋɛ ga maaʋela laaiti, ni nu a nu ʋaana, é la gaaɠilini ma, é ʋela, é li ná. ");
INSERT INTO tod_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Naama laaiti ta ɠɛ wo ʋɛ ga maaʋela laaiti, ɲamai ʋotokula nui ʋa, naa ɠa a kɛ nu ʋaa nui mina za, aisa é ʋa ɠula kɛlɛma nuɓusɛiti gaazu, ná-tukpɔi ɠaa ʋa leʋe. ");
INSERT INTO tod_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Wa yeelo taa lɔzita ʋa, ti ɠɛ ga maaʋela laaiti, ");
INSERT INTO tod_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","wa taa saʋagɔ ve Zuludɛn ʋoluʋelei, wo taa saʋagɔ ve Kanaan yooi zu. Naati ta ɠɛɛzu ga maaʋela laaiti. ");
INSERT INTO tod_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Naama laa lɔzitaiti ta ɠɛɛzu ga maaʋela laaiti Izilayɛle nuiti bɛ, ta wɛɛinti, naa ʋɛɛ seikɔɠɔma nuiti ba, nu-o-nu nii a nu ʋaana, é la gaaɠilini ma, miná ɠa a ʋela, é li ná. ");
INSERT INTO tod_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","«Ni zunui ta a seiɲɔɠɔi loɠana ga kɔlu ani, naa za, toɠa ga nu ʋaa nu. Ta nu ʋaa nui naa ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ni a sɔɔna ga kɔtu, naa za, toɠa ga nu ʋaa nu. Ta nu ʋaa nui naa ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Ni a doɠana ga gulu, naa za, toɠa ga nu ʋaa nu. Ta nu ʋaa nui naa ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Ɲamai ʋotokula nui ɠa nu ʋaa nui naa ʋaa, siɛgi zu é maazɔlɔɔsu da. ");
INSERT INTO tod_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ni zunui ta a zɔɔna seiɲɔɠɔi ʋa ga wɔinzeɠemai, ɓaa é ani zeɠe, é pili ma ga kisiɛ ɲɔi, saa vaa ɠula su, ");
INSERT INTO tod_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ɓaa ni a doɠana ga yeei, sili vaa zu, saa vaa ɠula su, toɠa ga nu ʋaa nu, ta paa. Ɲamai ʋotokula nui naa ɠa nu ʋaa nui naa ʋaa, siɛgi zu é yeezeelizu la ma. ");
INSERT INTO tod_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","«Kɛlɛ ni zunui ta a zɔɔna seiɲɔɠɔi ʋa, é la gaaɠilini ma, é la daani ɠisu, ɓaa é anii ta ʋili ma, é la daani ɠisu, ");
INSERT INTO tod_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ɓaa é la naa ɠaazu, eyɛsu é kɔtui loo ma, naa ʋolu ɠɛ ga saai, é la ga siliɲɔɠɔ, é la faa ɲɔu ɓɛtɛzu daalɔɠɔma, ");
INSERT INTO tod_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","nuɓusɛiti ta tukpɔɠaaleʋe, é zoloo tɔgi ma, nu ʋaa nui ta ɲamai ʋotokula nuiti zɔɠɔzu. ");
INSERT INTO tod_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Nuɓusɛiti ta nu ʋaa nui ɠizo, ti kula ɲamai ʋotokula nui ya. Nuɓusɛiti ta gaaɠale ma maaʋela laai zu, ʋɛ pelaai, é li ná. Toɠa yɛ ná eyɛsu zalaɠa ɠula ɠundiɠi wolai, nii gulɔ ɲadegai ziaai ma, naa za. ");
INSERT INTO tod_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","«Ni nu ʋaa nui a ɓudɛna maaʋela laai ma ɠwɛgiti maazu, ʋɛ pelaai, é li ná, ");
INSERT INTO tod_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ni ta ɠomina ta ɲamai ʋotokula nui taa ʋoluʋɛ, naa paa, é la ɠɛa ga sɔba nu, nu ʋaa vaa zu. ");
INSERT INTO tod_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Mazɔlɔɔ, nu ʋaa nui maanɛɛʋɛ, é yɛ maaʋela laai zu, eyɛsu zalaɠa ɠula ɠundiɠi wolai za. Zalaɠa ɠula ɠundiɠi wolai zaa ʋoluma, nu ʋaa nui ɠa zoo é ɠale ma ná-poganii unda. ");
INSERT INTO tod_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","«Deveiti kana wo ma vaa zu, wo-mavofodaiti kpein su, ʋɛ nɔpɛ wa zei ná. ");
INSERT INTO tod_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ni nui ta a nu loɠana, é za, ta nu ʋaa nui ʋaa, zeeleiti gooi ma. Kɛlɛ zeele ɠila ge la kula ɠɛa, peelalai ʋa ve nui ya ga ti paa. ");
INSERT INTO tod_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","«À mina yeezei walii wu, nu ʋaa nui yɛnvui vaa zu, nii maanɛai ga é za, mazɔlɔɔ kɛni ti naama nui ʋaa. ");
INSERT INTO tod_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","À mina yeezei walii wu, wo ʋa pelei ve zea, é ʋa ɠula maaʋela laai ʋa, é ʋa ɠale ma ná-zooi zu, aisa zalaɠa ɠula ɠundiɠi wolai ʋa za. ");
INSERT INTO tod_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","À mina zooi ɠɔzɔ, ʋɛ wo ʋaazu zeizu ná, mazɔlɔɔ ɲamai ɠa ɗa zooi ɠɔzɔ. Koto gba vaa la ɠɛa ɲamai ná-faa zu nii puai, kɛni naama nui ɲamai, nii é ɲamai ʋuai. ");
INSERT INTO tod_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Wo la zooi naa ɠɔzɔa, ʋɛ wo ʋaazu zeizu ná, ʋɛ nà ɓalaagi gè ʋaazu zeizu ná, mazɔlɔɔ nà ga Ɠɔoɠɔ GALAGI, nii é zeini Izilayɛle nuiti saama.» ");
INSERT INTO tod_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Pɛlɛyeɠe ɠundiɠiiti ti ɠulaai Galaade ná-bolodai zu, Makiil ná-doun zunui, Manasé ná-doun zunui, Zozɛfe ná-doun zunuiti ta-wolodamaiti saama, ti ʋaani Moize ʋɔ bɛ, ti ɓɔɛ pɔ, ta Izilayɛle nuiti ta-ʋɛlɛyeɠe ɠundiɠiiti, ");
INSERT INTO tod_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","ti ɠɛ ti ma: «Ɠɔoɠɔ GALAGI devei veeni màliɠii ya, ga é zooi ɠaaɠwɛ Izilayɛle nuiti ba ga kpakutoomai. Naa ʋoluma, màliɠii devei zɔlɔɔni Ɠɔoɠɔ GALAGI ya, ga é gi-ɠɛɛloin Selofeɠade ná-poganii ve ná-doun anzanuiti zea. ");
INSERT INTO tod_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ni ta vuluna Izilayɛle nuiti ta-wolodamai taɠili ma, ta-ʋoganii ɠa zeɠe gi-mɛmɛwolani ta-ʋoganii ʋa, é ʋɛɛ bolodai naa, ná-poganii ʋa, nii ti ɠiliai ba, naa maaʋele ma, ta ɠa ɠulazu poganii la, nii gaaɠwɛai gi ʋa ga kpakutoomai. ");
INSERT INTO tod_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Ɓɔɠɔyeema ɠonagi a zeelina Izilayɛle nuiti bɛ, ta-ʋoganii ɠa ʋɛɛ bolodai naa nɔnɔi ʋa, nii ti ɠilizu ba, toɠa zeɠe gá-wolodai nɔnɔ ma gelei ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Moize Ɠɔoɠɔ GALAGI ná-deveiti daazeelini Izilayɛle nuiti ma, é ɠɛ ti ma: «Zozɛfe mavofodaiti ta-wolodai ɠa gaamai wosu. ");
INSERT INTO tod_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Pɛtɛ nii Ɠɔoɠɔ GALAGI deveai Selofeɠade ná-doun anzanuiti ma: Ta zei naama nuiti bɛ, niiti ta ɠɛ ti ʋɔ, ni nɔ ta zei ti-ɠɛɛni ta-wolodai zu. ");
INSERT INTO tod_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Izilayɛle yooi zu, poganii tanɔpɛ ge la ɠulaa bolodai ta zu, é ʋa li bolodai zɔi zu, kɛlɛ Izilayɛle nui ɠilagilagi ɠa ɠili kɛɛɠɛni ta-wolodai ma ʋoganii ʋa. ");
INSERT INTO tod_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Anzanu loin ɠilagilagi kpein poganii a ɠɛ zea, Izilayɛle nuiti ta-wolodaiti su, kɛni naa zei zini bɛ, kɛɛɠɛ ná-bolodai zu, naa ɠa a kɛ Izilayɛle nuiti gilagilagiti ti ti-mɛmɛwolani ta-ʋoganii zɔlɔɔ. ");
INSERT INTO tod_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Poganii tanɔpɛ ge la ɠulaa bolodai ta ʋa, é ʋa li bolodai taɠili su, kɛlɛ Izilayɛle nuiti ta-wolodaiti ta ɠili ti ɠilagilagi ta-ʋoganii ʋa.» ");
INSERT INTO tod_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Selofeɠade ná-doun anzanuiti ti kɛɛni, eɠɛʋelei Ɠɔoɠɔ GALAGI ma levei veeni la Moize ya. ");
INSERT INTO tod_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Selofeɠade ná-doun anzanuiti ti ga Maala, Tiilesa, Wogela, Milika ta Noa, ti zeini ti-ɠɛɛ kɛɛɠɛlointi ti-loun zunuiti bɛ, ");
INSERT INTO tod_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","ti zeini Zozɛfe ná-doun zunui Manasé mavofodaiti bɛ, ta-ʋoganiiti ti yɛni ti-ɠɛɛni ta-wolodai zu. ");
INSERT INTO tod_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Deveiti ta tɔgiti kana, niiti Ɠɔoɠɔ GALAGI feeni Izilayɛle nuiti zea, ga Moize maaʋele, Moaɓe nɛmɛi zu, Zuludɛn ɠobaʋɛ, Zeliko letemaʋɛ.");
INSERT INTO tod_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Sɛʋɛi nii ɠa wooiti bosu, niiti Moize ti laazeelini Izilayɛle nuiti kpein ma, Zuludɛn folo ɠulazu ʋelei, teʋebai zu, pɛtu nɛmɛi zu Sufe letemaʋɛ. Nɛmɛi naa ɠa Palanni zɔɠɔzuʋɛ ta taa naanigɔi zɔiti: Tofɛle ta Laɓan, naa ʋɛɛ Ɠaselɔte ta Di-Zaɠaɓe ʋa. ");
INSERT INTO tod_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Folo puugɔ maazu ɠila (11) siɛ ɠa é ná, é zo Wolɛɓe gizei ma, é ʋa ga Seyiil ɠizei ma ʋelei, é zeeli Kadɛse-Ɓaaleneya.) ");
INSERT INTO tod_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Kona ʋuunaanisiɛi (40) ma alu puugɔ maazu ɠilagi (11) ma volo mɔungi ma, ti ɠula ʋoluma Ezipete yooi ʋa, Moize ɓɔɛni Izilayɛle nuiti pɔ, eɠɛʋelei Ɠɔoɠɔ GALAGI devei veeni la zea ta-vaa zu. ");
INSERT INTO tod_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Naa ɠɛɛni, siɛgi zu é ɓeni da ga vɔni Amool nuiti ta-masagi Siɠon ma, nii ná-taa wolai ɠɛni ga Ɠɛsɛɓon, ta Ɓasan masagi Wɔge, nii é ɠɛni zeini Asatalɔte ta Edeleyi. ");
INSERT INTO tod_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Zuludɛn ʋoluʋelei, Moaɓe yooi zu, miná ɠa Moize tɔɔzeini ná ga tɔgi nii yɔɠɔzulɛa ga tiye, é ɠɛ ti ma: ");
INSERT INTO tod_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Ɠɔoɠɔ GALAGI da-ƓALAGI ɓɔɛni de ʋɔ Wolɛɓe gizei ma, é ɠɛ ma: «Wo wola lɛbigɛ zeini gizei nii ʋɔ bɛ. ");
INSERT INTO tod_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","À latina, wo li Amool nuiti ta-ɠize yooi zu, ta ná maaɠooliiti su, ʋɛ Kanaan nuiti ti zeini ná, Zuludɛn ma ʋɛtu nɛmɛi zu, ta gizeiti ma, naa ʋɛɛ ziɛlaʋɛ ma nɛmɛi zu ʋa, ta lɛkpɛmaʋɛ nu yeezazuʋɛ, ta Kpoloɗɛ Wolai ɠobaʋɛti, eyɛsu é zeeli Liɓan ɠizeiti ma, ta ziɛ wolai Efelate ma. ");
INSERT INTO tod_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","À pɛtɛ, gè zooi tɛi fea wo ʋɛ. À li, wo zooi naa zeɠe ga wɔnɔ, nii nɔ̀un nà Ɠɔoɠɔ GALAGI gè ma ɠona woni wo-mɛmɛwolani bɛ, Abalaame, ta Izaake, naa ʋɛɛ Zakɔɓe ʋa, ga gè fe ti ʋɛ, ta ti-mavofodaiti, ta zeɠena ná.» ");
INSERT INTO tod_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Moize ɠɛni ma mɔnɔ: Naama ziɛgi zu, gè ɓɔɛni wo ʋɔ ɠani ga: «Gè la zooga, nà ɠila, gè ʋa lo wo luɠɔ. ");
INSERT INTO tod_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Ɠɔoɠɔ GALAGI wa-ƓALAGI, wo maamɔinɗa, za wo mɔinɗa eɠɛ geeɠɔlɔgi ma zomideɠaiti. ");
INSERT INTO tod_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ɠɔoɠɔ GALAGI, wo-mɛmɛwolani ta-ƓALAGI, ta ɓɔ wo ʋa ná zeizu ɠɛ ga waagila (1.000), é tuya loo wo ʋɛ, eɠɛʋelei é minazeɠeni la! ");
INSERT INTO tod_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Nà ɠila, nà wa-ɠasɔi zeɠe ɠale, gè wa-vaiti gaaɠula ba, ta wa-ɓɔɛ vaiti? ");
INSERT INTO tod_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","À yeelo zunui tanigaani ba, wa-wolodaiti su, ti ga ɠima nuiti, ti ɠeleɠelegai, ta lɔɠɔ ʋagɔi ti ʋa, gè ti zei wo unda.» ");
INSERT INTO tod_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Wo gòoɠaaʋoteni, wo ɠɛ mà: «Nii è ɠisiaa su ga è kɛ, naa ɠa ga faa ʋagɔ.» ");
INSERT INTO tod_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Gè wa-wolodama ɠundiɠiiti seɠeni, ɠima nuiti, lɔɠɔ ʋagɔi ti ʋa. Gè tanigaa zei wo unda ga nu waagilagila kundiɠiiti, nu ungilagila kundiɠiiti, nu ʋuulɔɔludɔɔlu kundiɠiiti, ta nu ʋuupuu kundiɠiiti. Gè zɔiti kɛ ga faaɠaaɠulaba nuiti wa-wolodaiti su. ");
INSERT INTO tod_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Gè devei veeni naama ziɛgi zu, wa-lukpɔɠaaleʋe nuiti zea, gè ɠɛ ti ma: «À woilo wo-ɠɛɛleaiti goo ma, wo ti lukpɔɠaaleʋe ti yɔɠɔzu vaiti su, ta ti-ɠɛɛleaiti, ta wɛɛinti, ga telebodai. ");
INSERT INTO tod_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","À mina zeelɔzɔɠɔzu ɠɛ nuiti su, wa woilo mɔnɛ nuiti goo ma, ta zobobɛ nuiti. À mina lua nu nɔpɛ ba, mazɔlɔɔ GALA ka po ge ga tukpɔɠaaleʋe vai. Ni fai ta a ɓaana wo ya gola, wa ʋaa la pɔ̀ bɛ, gè gaaɠula ba.» ");
INSERT INTO tod_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Pele ɠana naama ziɛgi zu gè devei veeni la, ga nii kpein wa kɛ. ");
INSERT INTO tod_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Ade zeɠeni Wolɛɓe gizei ʋɔ bɛ, de ziɛ teʋeba wolai zu, nii maayikiai, de li ga Amool nuiti ta-ɠize yoo